
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  178 ( 1387),  selected  178 , name 2par_B
# Molecule2: number of CA atoms  188 ( 1523),  selected  188 , name T0470.pdb
# PARAMETERS: 2par_B.T0470.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K     2_B      T       2           -
LGA    Q     3_B      K       3           -
LGA    S     4_B      Q       4           -
LGA    H     5_B      E       5           -
LGA    F     6_B      K       6           -
LGA    -       -      I       7           -
LGA    -       -      E       8           -
LGA    -       -      K       9           -
LGA    F     7_B      T      10           #
LGA    A     8_B      I      11           -
LGA    H     9_B      T      12           -
LGA    -       -      F      13           -
LGA    L    10_B      V      14          3.229
LGA    -       -      K      15           -
LGA    S    11_B      H      16          0.288
LGA    R    12_B      I      17          2.908
LGA    L    13_B      L      18          1.915
LGA    K    14_B      E      19           #
LGA    L    15_B      K      20           #
LGA    -       -      D      21           -
LGA    I    16_B      A      22          2.744
LGA    N    17_B      S      23          5.446
LGA    R    18_B      G      24           -
LGA    W    19_B      -       -           -
LGA    P    20_B      -       -           -
LGA    L    21_B      -       -           -
LGA    M    22_B      -       -           -
LGA    R    23_B      -       -           -
LGA    N    24_B      -       -           -
LGA    V    25_B      -       -           -
LGA    R    26_B      -       -           -
LGA    T    27_B      -       -           -
LGA    E    28_B      -       -           -
LGA    N    29_B      H      25          3.392
LGA    V    30_B      D      26          2.539
LGA    S    31_B      W      27          1.360
LGA    E    32_B      Y      28          1.335
LGA    H    33_B      H      29          1.083
LGA    S    34_B      I      30          0.860
LGA    L    35_B      R      31          0.487
LGA    Q    36_B      R      32          0.735
LGA    V    37_B      V      33          0.712
LGA    A    38_B      H      34          0.460
LGA    M    39_B      K      35          1.117
LGA    V    40_B      M      36          1.173
LGA    A    41_B      A      37          1.342
LGA    H    42_B      I      38          1.315
LGA    A    43_B      S      39          1.460
LGA    L    44_B      L      40          1.673
LGA    A    45_B      S      41          1.613
LGA    A    46_B      E      42          1.663
LGA    I    47_B      Q      43          2.241
LGA    K    48_B      E      44          1.967
LGA    N    49_B      G      45          3.844
LGA    R    50_B      -       -           -
LGA    K    51_B      -       -           -
LGA    F    52_B      -       -           -
LGA    G    53_B      -       -           -
LGA    G    54_B      -       -           -
LGA    N    55_B      -       -           -
LGA    V    56_B      G      46          1.106
LGA    N    57_B      N      47          2.004
LGA    A    58_B      R      48          3.136
LGA    E    59_B      F      49          4.376
LGA    R    60_B      I      50          3.278
LGA    I    61_B      I      51          1.448
LGA    A    62_B      E      52          2.351
LGA    L    63_B      M      53          2.687
LGA    L    64_B      A      54          1.617
LGA    A    65_B      A      55          0.978
LGA    M    66_B      L      56          1.323
LGA    Y    67_B      L      57          1.490
LGA    H    68_B      H      58          1.537
LGA    D    69_B      D      59          0.788
LGA    A    70_B      V      60          1.522
LGA    S    71_B      A      61          2.273
LGA    A    72_B      D      62          4.486
LGA    V    73_B      -       -           -
LGA    L    74_B      -       -           -
LGA    T    75_B      -       -           -
LGA    G    76_B      L      65          1.412
LGA    D    77_B      N      66           #
LGA    L    78_B      E      67           -
LGA    P    79_B      S      68           -
LGA    T    80_B      -       -           -
LGA    P    81_B      -       -           -
LGA    A    90_B      -       -           -
LGA    Q    91_B      -       -           -
LGA    E    92_B      -       -           -
LGA    Y    93_B      -       -           -
LGA    K    94_B      -       -           -
LGA    A    95_B      E      69          4.807
LGA    I    96_B      E      70          2.768
LGA    E    97_B      -       -           -
LGA    K    98_B      -       -           -
LGA    I    99_B      A      71          2.498
LGA    A   100_B      G      72          1.220
LGA    Q   101_B      M      73          1.889
LGA    Q   102_B      K      74          0.878
LGA    K   103_B      K      75          2.879
LGA    L   104_B      V      76          3.780
LGA    V   105_B      S      77          2.628
LGA    D   106_B      D      78          2.678
LGA    M   107_B      W      79          5.308
LGA    V   108_B      L      80           #
LGA    P   109_B      -       -           -
LGA    E   110_B      -       -           -
LGA    E   111_B      E      81           #
LGA    L   112_B      E      82          3.083
LGA    R   113_B      L      83           #
LGA    -       -      H      84           -
LGA    D   114_B      V      85          3.096
LGA    I   115_B      E      86          5.721
LGA    F   116_B      E      87           -
LGA    -       -      E      88           -
LGA    -       -      E      89           -
LGA    A   117_B      S      90          4.364
LGA    P   118_B      -       -           -
LGA    L   119_B      K      91           #
LGA    I   120_B      H      92           -
LGA    D   121_B      V      93           #
LGA    E   122_B      L      94          3.564
LGA    H   123_B      H      95          1.868
LGA    A   124_B      -       -           -
LGA    Y   125_B      I      96          3.540
LGA    S   126_B      I      97           -
LGA    -       -      A      98           -
LGA    -       -      N      99           -
LGA    -       -      M     100           -
LGA    D   127_B      S     112          1.572
LGA    E   128_B      I     113          1.453
LGA    E   129_B      E     114          1.724
LGA    K   130_B      G     115          1.853
LGA    S   131_B      K     116          1.430
LGA    L   132_B      L     117          1.088
LGA    V   133_B      V     118          1.125
LGA    K   134_B      Q     119          1.263
LGA    Q   135_B      D     120          1.303
LGA    A   136_B      A     121          1.162
LGA    D   137_B      D     122          0.965
LGA    A   138_B      R     123          0.918
LGA    L   139_B      L     124          0.826
LGA    C   140_B      D     125          0.689
LGA    A   141_B      A     126          2.111
LGA    Y   142_B      L     127          2.142
LGA    L   143_B      G     128          3.927
LGA    -       -      A     129           -
LGA    K   144_B      I     130          3.279
LGA    C   145_B      G     131          1.349
LGA    L   146_B      I     132          2.806
LGA    E   147_B      A     133          3.523
LGA    E   148_B      R     134          3.762
LGA    L   149_B      -       -           -
LGA    A   150_B      -       -           -
LGA    A   151_B      -       -           -
LGA    G   152_B      -       -           -
LGA    N   153_B      T     135           #
LGA    N   154_B      F     136          3.369
LGA    -       -      A     137           -
LGA    -       -      Y     138           -
LGA    E   155_B      G     139          2.747
LGA    -       -      G     140           -
LGA    -       -      A     141           -
LGA    -       -      K     142           -
LGA    -       -      G     143           -
LGA    -       -      R     144           -
LGA    -       -      L     145           -
LGA    -       -      M     146           -
LGA    -       -      Y     147           -
LGA    -       -      D     148           -
LGA    -       -      P     149           -
LGA    -       -      T     150           -
LGA    -       -      I     151           -
LGA    -       -      P     152           -
LGA    -       -      P     153           -
LGA    -       -      R     154           -
LGA    -       -      D     167           -
LGA    -       -      P     168           -
LGA    F   156_B      S     169          4.864
LGA    L   157_B      L     170          3.335
LGA    L   158_B      N     171          4.228
LGA    A   159_B      H     172          4.146
LGA    K   160_B      F     173          3.464
LGA    T   161_B      Y     174          3.055
LGA    -       -      E     175           -
LGA    R   162_B      K     176          0.746
LGA    L   163_B      L     177          2.576
LGA    E   164_B      L     178          2.453
LGA    A   165_B      K     179          1.950
LGA    T   166_B      L     180          3.190
LGA    L   167_B      K     181          3.028
LGA    E   168_B      D     182          0.600
LGA    A   169_B      L     183          2.301
LGA    R   170_B      M     184          2.786
LGA    R   171_B      N     185           #
LGA    S   172_B      T     186          3.706
LGA    Q   173_B      N     187          1.988
LGA    E   174_B      A     188          1.628
LGA    M   175_B      A     189          1.835
LGA    D   176_B      K     190          2.616
LGA    Y   177_B      Q     191          2.059
LGA    F   178_B      E     192          1.542
LGA    M   179_B      A     193          2.825
LGA    E   180_B      E     194          4.638
LGA    I   181_B      V     195          5.367
LGA    F   182_B      -       -           -
LGA    V   183_B      -       -           -
LGA    P   184_B      R     196          5.094
LGA    S   185_B      H     197           -
LGA    F   186_B      R     198           -
LGA    H   187_B      Y     199          3.928
LGA    -       -      M     200           -
LGA    -       -      E     201           -
LGA    -       -      Q     202           -
LGA    -       -      F     203           -
LGA    -       -      I     204           -
LGA    -       -      E     205           -
LGA    -       -      Q     206           -
LGA    -       -      F     207           -
LGA    -       -      M     208           -
LGA    -       -      K     209           -
LGA    -       -      E     210           -
LGA    -       -      W     211           -
LGA    -       -      N     212           -
LGA    -       -      A     213           -
LGA    -       -      Q     214           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  178  188    5.0    114    2.69    20.18     38.363     4.090

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.148518 * X  +  -0.191893 * Y  +   0.970113 * Z  +  41.803165
  Y_new =   0.889441 * X  +   0.454707 * Y  +  -0.046225 * Z  +  62.564682
  Z_new =  -0.432247 * X  +   0.869723 * Y  +   0.238209 * Z  + 100.965134 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.303461   -1.838131  [ DEG:    74.6828   -105.3172 ]
  Theta =   0.446983    2.694609  [ DEG:    25.6103    154.3898 ]
  Phi   =   1.405343   -1.736249  [ DEG:    80.5202    -99.4798 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2par_B                                        
REMARK     2: T0470.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2par_B.T0470.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  178  188   5.0  114   2.69   20.18  38.363
REMARK  ---------------------------------------------------------- 
MOLECULE 2par_B
HEADER    HYDROLASE                               27-MAR-07   2PAR              
TITLE     CRYSTAL STRUCTURE OF THE 5'-DEOXYNUCLEOTIDASE YFBR MUTANT             
TITLE    2 E72A COMPLEXED WITH CO(2+) AND TMP                                   
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: 5'-DEOXYNUCLEOTIDASE YFBR;                                 
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: NUCLEOSIDE 5'-MONOPHOSPHATE PHOSPHOHYDROLASE, 5'-           
COMPND   5 DEOXYRIBONUCLEOTIDASE;                                               
COMPND   6 EC: 3.1.3.5;                                                         
COMPND   7 ENGINEERED: YES;                                                     
COMPND   8 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 STRAIN: K12;                                                         
SOURCE   4 GENE: YFBR, B2291, JW2288;                                           
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: ROSETTA2(DE3);                             
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: MODIFIED PET-15B                          
KEYWDS    NUCLEOTIDASE, 5'-DEOXYNUCLEOTIDASE, YFBR, HD DOMAIN                   
KEYWDS   2 PHOSPHOHYDROLASE                                                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.D.ZIMMERMAN,M.PROUDFOOT,A.YAKUNIN,W.MINOR                           
REVDAT   2   06-MAY-08 2PAR    1       JRNL   VERSN                             
REVDAT   1   04-MAR-08 2PAR    0                                                
JRNL        AUTH   M.D.ZIMMERMAN,M.PROUDFOOT,A.YAKUNIN,W.MINOR                  
JRNL        TITL   STRUCTURAL INSIGHT INTO THE MECHANISM OF SUBSTRATE           
JRNL        TITL 2 SPECIFICITY AND CATALYTIC ACTIVITY OF AN HD-DOMAIN           
JRNL        TITL 3 PHOSPHOHYDROLASE: THE 5'-DEOXYRIBONUCLEOTIDASE               
JRNL        TITL 4 YFBR FROM ESCHERICHIA COLI.                                  
JRNL        REF    J.MOL.BIOL.                   V. 378   215 2008              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 2.10 ANGSTROMS.                                          
DBREF  2PAR A    1   199  UNP    P76491   YFBR_ECOLI       1    199             
DBREF  2PAR B    1   199  UNP    P76491   YFBR_ECOLI       1    199             
SEQRES   1 A  201  GLY HIS MET LYS GLN SER HIS PHE PHE ALA HIS LEU SER          
SEQRES   2 A  201  ARG LEU LYS LEU ILE ASN ARG TRP PRO LEU MET ARG ASN          
SEQRES   3 A  201  VAL ARG THR GLU ASN VAL SER GLU HIS SER LEU GLN VAL          
SEQRES   4 A  201  ALA MET VAL ALA HIS ALA LEU ALA ALA ILE LYS ASN ARG          
SEQRES   5 A  201  LYS PHE GLY GLY ASN VAL ASN ALA GLU ARG ILE ALA LEU          
SEQRES   6 A  201  LEU ALA MET TYR HIS ASP ALA SER ALA VAL LEU THR GLY          
SEQRES   7 A  201  ASP LEU PRO THR PRO VAL LYS TYR PHE ASN SER GLN ILE          
SEQRES   8 A  201  ALA GLN GLU TYR LYS ALA ILE GLU LYS ILE ALA GLN GLN          
SEQRES   9 A  201  LYS LEU VAL ASP MET VAL PRO GLU GLU LEU ARG ASP ILE          
SEQRES  10 A  201  PHE ALA PRO LEU ILE ASP GLU HIS ALA TYR SER ASP GLU          
SEQRES  11 A  201  GLU LYS SER LEU VAL LYS GLN ALA ASP ALA LEU CYS ALA          
SEQRES  12 A  201  TYR LEU LYS CYS LEU GLU GLU LEU ALA ALA GLY ASN ASN          
SEQRES  13 A  201  GLU PHE LEU LEU ALA LYS THR ARG LEU GLU ALA THR LEU          
SEQRES  14 A  201  GLU ALA ARG ARG SER GLN GLU MET ASP TYR PHE MET GLU          
SEQRES  15 A  201  ILE PHE VAL PRO SER PHE HIS LEU SER LEU ASP GLU ILE          
SEQRES  16 A  201  SER GLN ASP SER PRO LEU                                      
SEQRES   1 B  201  GLY HIS MET LYS GLN SER HIS PHE PHE ALA HIS LEU SER          
SEQRES   2 B  201  ARG LEU LYS LEU ILE ASN ARG TRP PRO LEU MET ARG ASN          
SEQRES   3 B  201  VAL ARG THR GLU ASN VAL SER GLU HIS SER LEU GLN VAL          
SEQRES   4 B  201  ALA MET VAL ALA HIS ALA LEU ALA ALA ILE LYS ASN ARG          
SEQRES   5 B  201  LYS PHE GLY GLY ASN VAL ASN ALA GLU ARG ILE ALA LEU          
SEQRES   6 B  201  LEU ALA MET TYR HIS ASP ALA SER ALA VAL LEU THR GLY          
SEQRES   7 B  201  ASP LEU PRO THR PRO VAL LYS TYR PHE ASN SER GLN ILE          
SEQRES   8 B  201  ALA GLN GLU TYR LYS ALA ILE GLU LYS ILE ALA GLN GLN          
SEQRES   9 B  201  LYS LEU VAL ASP MET VAL PRO GLU GLU LEU ARG ASP ILE          
SEQRES  10 B  201  PHE ALA PRO LEU ILE ASP GLU HIS ALA TYR SER ASP GLU          
SEQRES  11 B  201  GLU LYS SER LEU VAL LYS GLN ALA ASP ALA LEU CYS ALA          
SEQRES  12 B  201  TYR LEU LYS CYS LEU GLU GLU LEU ALA ALA GLY ASN ASN          
SEQRES  13 B  201  GLU PHE LEU LEU ALA LYS THR ARG LEU GLU ALA THR LEU          
SEQRES  14 B  201  GLU ALA ARG ARG SER GLN GLU MET ASP TYR PHE MET GLU          
SEQRES  15 B  201  ILE PHE VAL PRO SER PHE HIS LEU SER LEU ASP GLU ILE          
SEQRES  16 B  201  SER GLN ASP SER PRO LEU                                      
HET     CO  A 201       1                                                       
HET     CO  B 201       1                                                       
HET    TMP  A 301      21                                                       
HET    TMP  B 301      21                                                       
HET    PEG  A 401       7                                                       
HETNAM      CO COBALT (II) ION                                                  
HETNAM     TMP THYMIDINE-5'-PHOSPHATE                                           
HETNAM     PEG DI(HYDROXYETHYL)ETHER                                            
FORMUL   3   CO    2(CO 2+)                                                     
FORMUL   5  TMP    2(C10 H15 N2 O8 P)                                           
FORMUL   7  PEG    C4 H10 O3                                                    
FORMUL   8  HOH   *42(H2 O)                                                     
CRYST1  136.136  136.136   55.418  90.00  90.00 120.00 H 3          18          
ATOM   1356  N   LYS B   2      71.951  41.566  87.237  1.00 30.70           N  
ATOM   1357  CA  LYS B   2      70.968  42.404  86.514  1.00 31.00           C  
ATOM   1358  C   LYS B   2      69.575  42.236  87.154  1.00 30.35           C  
ATOM   1359  O   LYS B   2      68.972  41.173  87.148  1.00 31.47           O  
ATOM   1360  CB  LYS B   2      70.947  42.099  85.007  1.00 30.99           C  
ATOM   1361  N   GLN B   3      69.100  43.311  87.750  1.00 29.89           N  
ATOM   1362  CA  GLN B   3      67.816  43.345  88.400  1.00 29.60           C  
ATOM   1363  C   GLN B   3      66.834  43.933  87.382  1.00 27.83           C  
ATOM   1364  O   GLN B   3      67.218  44.586  86.404  1.00 27.13           O  
ATOM   1365  CB  GLN B   3      67.926  44.137  89.704  1.00 29.65           C  
ATOM   1366  CG  GLN B   3      68.908  43.488  90.693  1.00 33.45           C  
ATOM   1367  CD  GLN B   3      69.535  44.485  91.655  1.00 36.71           C  
ATOM   1368  OE1 GLN B   3      69.054  45.597  91.779  1.00 41.10           O  
ATOM   1369  NE2 GLN B   3      70.614  44.084  92.340  1.00 39.53           N  
ATOM   1370  N   SER B   4      65.572  43.621  87.565  1.00 26.64           N  
ATOM   1371  CA  SER B   4      64.571  44.056  86.653  1.00 25.02           C  
ATOM   1372  C   SER B   4      63.630  44.988  87.404  1.00 25.97           C  
ATOM   1373  O   SER B   4      63.247  44.692  88.546  1.00 24.66           O  
ATOM   1374  CB  SER B   4      63.837  42.844  86.083  1.00 25.66           C  
ATOM   1375  OG  SER B   4      62.536  43.164  85.597  1.00 21.36           O  
ATOM   1376  N   HIS B   5      63.230  46.074  86.705  1.00 26.18           N  
ATOM   1377  CA  HIS B   5      62.355  47.142  87.202  1.00 25.95           C  
ATOM   1378  C   HIS B   5      60.910  46.830  86.909  1.00 26.79           C  
ATOM   1379  O   HIS B   5      60.022  47.595  87.246  1.00 26.16           O  
ATOM   1380  CB  HIS B   5      62.744  48.486  86.543  1.00 27.31           C  
ATOM   1381  CG  HIS B   5      64.144  48.925  86.861  1.00 25.21           C  
ATOM   1382  ND1 HIS B   5      64.892  49.732  86.030  1.00 31.26           N  
ATOM   1383  CD2 HIS B   5      64.941  48.645  87.918  1.00 29.73           C  
ATOM   1384  CE1 HIS B   5      66.077  49.955  86.576  1.00 29.62           C  
ATOM   1385  NE2 HIS B   5      66.136  49.298  87.720  1.00 28.67           N  
ATOM   1386  N   PHE B   6      60.654  45.661  86.358  1.00 26.19           N  
ATOM   1387  CA  PHE B   6      59.337  45.353  85.872  1.00 26.17           C  
ATOM   1388  C   PHE B   6      58.244  45.420  86.928  1.00 26.90           C  
ATOM   1389  O   PHE B   6      57.265  46.096  86.739  1.00 24.59           O  
ATOM   1390  CB  PHE B   6      59.374  43.986  85.220  1.00 27.10           C  
ATOM   1391  CG  PHE B   6      58.007  43.509  84.707  1.00 25.46           C  
ATOM   1392  CD1 PHE B   6      57.407  44.126  83.652  1.00 25.79           C  
ATOM   1393  CD2 PHE B   6      57.407  42.383  85.264  1.00 26.93           C  
ATOM   1394  CE1 PHE B   6      56.180  43.674  83.136  1.00 26.55           C  
ATOM   1395  CE2 PHE B   6      56.158  41.916  84.795  1.00 28.43           C  
ATOM   1396  CZ  PHE B   6      55.550  42.553  83.713  1.00 27.50           C  
ATOM   1397  N   PHE B   7      58.415  44.721  88.050  1.00 27.93           N  
ATOM   1398  CA  PHE B   7      57.388  44.752  89.112  1.00 28.29           C  
ATOM   1399  C   PHE B   7      57.346  46.101  89.865  1.00 28.17           C  
ATOM   1400  O   PHE B   7      56.262  46.539  90.328  1.00 27.08           O  
ATOM   1401  CB  PHE B   7      57.570  43.578  90.087  1.00 28.75           C  
ATOM   1402  CG  PHE B   7      56.781  42.378  89.698  1.00 28.74           C  
ATOM   1403  CD1 PHE B   7      55.478  42.229  90.158  1.00 30.92           C  
ATOM   1404  CD2 PHE B   7      57.303  41.421  88.839  1.00 28.81           C  
ATOM   1405  CE1 PHE B   7      54.704  41.139  89.771  1.00 31.36           C  
ATOM   1406  CE2 PHE B   7      56.544  40.338  88.447  1.00 26.61           C  
ATOM   1407  CZ  PHE B   7      55.230  40.201  88.917  1.00 28.31           C  
ATOM   1408  N   ALA B   8      58.507  46.744  89.991  1.00 27.03           N  
ATOM   1409  CA  ALA B   8      58.597  48.117  90.529  1.00 26.87           C  
ATOM   1410  C   ALA B   8      57.632  49.032  89.729  1.00 27.77           C  
ATOM   1411  O   ALA B   8      56.833  49.768  90.278  1.00 28.11           O  
ATOM   1412  CB  ALA B   8      60.011  48.622  90.437  1.00 26.63           C  
ATOM   1413  N   HIS B   9      57.645  48.913  88.417  1.00 28.23           N  
ATOM   1414  CA  HIS B   9      56.737  49.705  87.612  1.00 28.71           C  
ATOM   1415  C   HIS B   9      55.268  49.238  87.763  1.00 28.55           C  
ATOM   1416  O   HIS B   9      54.351  50.051  87.812  1.00 28.78           O  
ATOM   1417  CB  HIS B   9      57.155  49.604  86.159  1.00 29.91           C  
ATOM   1418  CG  HIS B   9      58.339  50.417  85.822  1.00 28.91           C  
ATOM   1419  ND1 HIS B   9      58.276  51.785  85.693  1.00 30.77           N  
ATOM   1420  CD2 HIS B   9      59.624  50.069  85.576  1.00 32.07           C  
ATOM   1421  CE1 HIS B   9      59.475  52.244  85.373  1.00 30.73           C  
ATOM   1422  NE2 HIS B   9      60.311  51.223  85.303  1.00 31.14           N  
ATOM   1423  N   LEU B  10      55.041  47.933  87.819  1.00 29.22           N  
ATOM   1424  CA  LEU B  10      53.671  47.450  87.998  1.00 30.18           C  
ATOM   1425  C   LEU B  10      53.068  47.860  89.310  1.00 30.13           C  
ATOM   1426  O   LEU B  10      51.858  48.091  89.377  1.00 29.92           O  
ATOM   1427  CB  LEU B  10      53.563  45.930  87.864  1.00 30.63           C  
ATOM   1428  CG  LEU B  10      53.101  45.438  86.484  1.00 33.97           C  
ATOM   1429  CD1 LEU B  10      53.418  46.421  85.352  1.00 36.64           C  
ATOM   1430  CD2 LEU B  10      53.845  44.158  86.257  1.00 35.88           C  
ATOM   1431  N   SER B  11      53.884  47.947  90.345  1.00 30.16           N  
ATOM   1432  CA  SER B  11      53.436  48.526  91.646  1.00 31.58           C  
ATOM   1433  C   SER B  11      52.820  49.962  91.571  1.00 31.28           C  
ATOM   1434  O   SER B  11      52.004  50.336  92.423  1.00 33.48           O  
ATOM   1435  CB  SER B  11      54.599  48.525  92.635  1.00 31.41           C  
ATOM   1436  OG  SER B  11      55.434  49.654  92.391  1.00 32.51           O  
ATOM   1437  N   ARG B  12      53.156  50.740  90.545  1.00 30.88           N  
ATOM   1438  CA  ARG B  12      52.592  52.099  90.374  1.00 31.02           C  
ATOM   1439  C   ARG B  12      51.235  52.205  89.690  1.00 30.45           C  
ATOM   1440  O   ARG B  12      50.666  53.284  89.573  1.00 30.52           O  
ATOM   1441  CB  ARG B  12      53.538  52.908  89.566  1.00 31.06           C  
ATOM   1442  CG  ARG B  12      54.879  52.974  90.231  1.00 34.64           C  
ATOM   1443  CD  ARG B  12      55.840  53.640  89.320  1.00 37.50           C  
ATOM   1444  NE  ARG B  12      55.985  55.048  89.634  1.00 39.90           N  
ATOM   1445  CZ  ARG B  12      56.384  55.550  90.791  1.00 39.85           C  
ATOM   1446  NH1 ARG B  12      56.683  54.789  91.837  1.00 40.91           N  
ATOM   1447  NH2 ARG B  12      56.486  56.856  90.891  1.00 41.50           N  
ATOM   1448  N   LEU B  13      50.730  51.091  89.223  1.00 29.34           N  
ATOM   1449  CA  LEU B  13      49.355  51.048  88.732  1.00 29.41           C  
ATOM   1450  C   LEU B  13      48.296  51.694  89.624  1.00 28.53           C  
ATOM   1451  O   LEU B  13      47.306  52.303  89.137  1.00 26.90           O  
ATOM   1452  CB  LEU B  13      48.965  49.598  88.508  1.00 28.70           C  
ATOM   1453  CG  LEU B  13      49.281  49.046  87.111  1.00 33.74           C  
ATOM   1454  CD1 LEU B  13      48.749  47.624  86.945  1.00 34.25           C  
ATOM   1455  CD2 LEU B  13      48.688  49.899  86.031  1.00 35.15           C  
ATOM   1456  N   LYS B  14      48.468  51.455  90.919  1.00 28.01           N  
ATOM   1457  CA  LYS B  14      47.527  51.947  91.914  1.00 27.74           C  
ATOM   1458  C   LYS B  14      47.612  53.468  92.058  1.00 27.11           C  
ATOM   1459  O   LYS B  14      46.732  54.037  92.617  1.00 25.55           O  
ATOM   1460  CB  LYS B  14      47.744  51.252  93.247  1.00 27.00           C  
ATOM   1461  CG  LYS B  14      49.100  51.590  93.968  1.00 27.27           C  
ATOM   1462  CD  LYS B  14      49.359  50.548  95.071  1.00 27.44           C  
ATOM   1463  CE  LYS B  14      50.542  50.845  95.963  1.00 29.51           C  
ATOM   1464  NZ  LYS B  14      51.826  50.936  95.173  1.00 31.24           N  
ATOM   1465  N   LEU B  15      48.723  54.071  91.633  1.00 27.18           N  
ATOM   1466  CA  LEU B  15      48.862  55.540  91.570  1.00 27.09           C  
ATOM   1467  C   LEU B  15      48.078  56.193  90.408  1.00 26.94           C  
ATOM   1468  O   LEU B  15      47.812  57.411  90.473  1.00 26.87           O  
ATOM   1469  CB  LEU B  15      50.335  55.949  91.480  1.00 27.13           C  
ATOM   1470  CG  LEU B  15      51.216  55.477  92.649  1.00 26.60           C  
ATOM   1471  CD1 LEU B  15      52.675  55.831  92.436  1.00 28.70           C  
ATOM   1472  CD2 LEU B  15      50.665  56.020  93.966  1.00 26.02           C  
ATOM   1473  N   ILE B  16      47.696  55.436  89.367  1.00 25.78           N  
ATOM   1474  CA  ILE B  16      47.204  56.086  88.145  1.00 25.79           C  
ATOM   1475  C   ILE B  16      45.725  56.206  88.240  1.00 26.14           C  
ATOM   1476  O   ILE B  16      45.020  55.233  88.344  1.00 25.96           O  
ATOM   1477  CB  ILE B  16      47.575  55.350  86.773  1.00 26.79           C  
ATOM   1478  CG1 ILE B  16      49.058  54.971  86.713  1.00 24.66           C  
ATOM   1479  CG2 ILE B  16      47.217  56.232  85.554  1.00 24.44           C  
ATOM   1480  CD1 ILE B  16      49.939  56.104  86.577  1.00 28.04           C  
ATOM   1481  N   ASN B  17      45.254  57.430  88.222  1.00 25.65           N  
ATOM   1482  CA  ASN B  17      43.881  57.683  88.444  1.00 25.98           C  
ATOM   1483  C   ASN B  17      43.129  57.759  87.139  1.00 25.72           C  
ATOM   1484  O   ASN B  17      43.659  58.225  86.139  1.00 26.15           O  
ATOM   1485  CB  ASN B  17      43.721  58.945  89.288  1.00 25.14           C  
ATOM   1486  CG  ASN B  17      44.054  58.690  90.758  1.00 27.35           C  
ATOM   1487  OD1 ASN B  17      43.903  57.592  91.231  1.00 27.12           O  
ATOM   1488  ND2 ASN B  17      44.464  59.718  91.479  1.00 26.87           N  
ATOM   1489  N   ARG B  18      41.875  57.325  87.175  1.00 25.11           N  
ATOM   1490  CA  ARG B  18      41.058  57.212  85.975  1.00 25.22           C  
ATOM   1491  C   ARG B  18      39.967  58.282  86.000  1.00 24.27           C  
ATOM   1492  O   ARG B  18      39.799  58.935  86.986  1.00 22.93           O  
ATOM   1493  CB  ARG B  18      40.415  55.801  85.891  1.00 24.26           C  
ATOM   1494  CG  ARG B  18      41.368  54.753  85.342  1.00 25.12           C  
ATOM   1495  CD  ARG B  18      40.934  53.340  85.613  1.00 25.32           C  
ATOM   1496  NE  ARG B  18      39.627  53.033  85.092  1.00 27.54           N  
ATOM   1497  CZ  ARG B  18      39.364  52.836  83.804  1.00 28.92           C  
ATOM   1498  NH1 ARG B  18      40.334  52.855  82.907  1.00 27.10           N  
ATOM   1499  NH2 ARG B  18      38.121  52.606  83.430  1.00 31.10           N  
ATOM   1500  N   TRP B  19      39.229  58.426  84.902  1.00 24.64           N  
ATOM   1501  CA  TRP B  19      38.157  59.436  84.770  1.00 24.02           C  
ATOM   1502  C   TRP B  19      38.499  60.866  85.265  1.00 24.85           C  
ATOM   1503  O   TRP B  19      37.749  61.448  86.061  1.00 23.22           O  
ATOM   1504  CB  TRP B  19      36.914  58.932  85.515  1.00 25.06           C  
ATOM   1505  CG  TRP B  19      36.335  57.599  85.005  1.00 25.60           C  
ATOM   1506  CD1 TRP B  19      36.627  56.322  85.479  1.00 25.96           C  
ATOM   1507  CD2 TRP B  19      35.383  57.421  83.954  1.00 25.84           C  
ATOM   1508  NE1 TRP B  19      35.941  55.396  84.745  1.00 25.99           N  
ATOM   1509  CE2 TRP B  19      35.164  56.027  83.818  1.00 26.09           C  
ATOM   1510  CE3 TRP B  19      34.703  58.296  83.104  1.00 24.55           C  
ATOM   1511  CZ2 TRP B  19      34.269  55.492  82.893  1.00 25.25           C  
ATOM   1512  CZ3 TRP B  19      33.826  57.764  82.188  1.00 27.00           C  
ATOM   1513  CH2 TRP B  19      33.615  56.361  82.090  1.00 26.47           C  
ATOM   1514  N   PRO B  20      39.627  61.449  84.785  1.00 25.11           N  
ATOM   1515  CA  PRO B  20      40.116  62.718  85.344  1.00 25.92           C  
ATOM   1516  C   PRO B  20      39.249  63.931  85.035  1.00 26.10           C  
ATOM   1517  O   PRO B  20      39.437  64.981  85.647  1.00 25.65           O  
ATOM   1518  CB  PRO B  20      41.452  62.919  84.631  1.00 25.61           C  
ATOM   1519  CG  PRO B  20      41.247  62.219  83.317  1.00 25.59           C  
ATOM   1520  CD  PRO B  20      40.481  60.995  83.677  1.00 25.28           C  
ATOM   1521  N   LEU B  21      38.351  63.815  84.063  1.00 26.21           N  
ATOM   1522  CA  LEU B  21      37.648  64.987  83.564  1.00 26.81           C  
ATOM   1523  C   LEU B  21      36.367  65.274  84.318  1.00 27.18           C  
ATOM   1524  O   LEU B  21      35.675  66.257  84.047  1.00 26.77           O  
ATOM   1525  CB  LEU B  21      37.339  64.809  82.080  1.00 27.56           C  
ATOM   1526  CG  LEU B  21      38.551  64.553  81.183  1.00 26.93           C  
ATOM   1527  CD1 LEU B  21      38.119  64.441  79.704  1.00 27.17           C  
ATOM   1528  CD2 LEU B  21      39.590  65.657  81.369  1.00 25.83           C  
ATOM   1529  N   MET B  22      36.032  64.409  85.255  1.00 27.81           N  
ATOM   1530  CA  MET B  22      34.821  64.612  86.029  1.00 28.87           C  
ATOM   1531  C   MET B  22      35.145  64.627  87.467  1.00 27.67           C  
ATOM   1532  O   MET B  22      36.156  64.062  87.878  1.00 26.21           O  
ATOM   1533  CB  MET B  22      33.821  63.494  85.753  1.00 29.78           C  
ATOM   1534  CG  MET B  22      33.220  63.652  84.387  1.00 32.85           C  
ATOM   1535  SD  MET B  22      33.794  62.345  83.353  1.00 34.83           S  
ATOM   1536  CE  MET B  22      32.454  61.198  83.602  1.00 37.26           C  
ATOM   1537  N   ARG B  23      34.274  65.290  88.216  1.00 27.22           N  
ATOM   1538  CA  ARG B  23      34.194  65.066  89.653  1.00 27.75           C  
ATOM   1539  C   ARG B  23      33.818  63.614  89.867  1.00 27.65           C  
ATOM   1540  O   ARG B  23      32.831  63.139  89.276  1.00 28.98           O  
ATOM   1541  CB  ARG B  23      33.104  65.906  90.292  1.00 28.78           C  
ATOM   1542  CG  ARG B  23      32.530  65.227  91.538  1.00 30.61           C  
ATOM   1543  CD  ARG B  23      31.681  66.130  92.394  1.00 33.57           C  
ATOM   1544  NE  ARG B  23      31.262  65.353  93.555  1.00 35.40           N  
ATOM   1545  CZ  ARG B  23      30.056  64.816  93.735  1.00 36.47           C  
ATOM   1546  NH1 ARG B  23      29.068  64.983  92.847  1.00 36.45           N  
ATOM   1547  NH2 ARG B  23      29.827  64.146  94.859  1.00 38.15           N  
ATOM   1548  N   ASN B  24      34.596  62.924  90.690  1.00 26.48           N  
ATOM   1549  CA  ASN B  24      34.336  61.586  91.097  1.00 26.88           C  
ATOM   1550  C   ASN B  24      33.927  61.603  92.568  1.00 27.44           C  
ATOM   1551  O   ASN B  24      34.614  62.232  93.385  1.00 26.23           O  
ATOM   1552  CB  ASN B  24      35.599  60.727  90.968  1.00 27.85           C  
ATOM   1553  CG  ASN B  24      35.880  60.259  89.533  1.00 28.07           C  
ATOM   1554  OD1 ASN B  24      35.808  59.069  89.256  1.00 30.99           O  
ATOM   1555  ND2 ASN B  24      36.273  61.186  88.639  1.00 27.56           N  
ATOM   1556  N   VAL B  25      32.842  60.904  92.912  1.00 27.05           N  
ATOM   1557  CA  VAL B  25      32.479  60.695  94.298  1.00 27.33           C  
ATOM   1558  C   VAL B  25      33.607  59.869  94.930  1.00 27.89           C  
ATOM   1559  O   VAL B  25      34.008  60.111  96.066  1.00 28.14           O  
ATOM   1560  CB  VAL B  25      31.090  60.008  94.428  1.00 27.72           C  
ATOM   1561  CG1 VAL B  25      30.864  59.525  95.838  1.00 29.39           C  
ATOM   1562  CG2 VAL B  25      29.951  60.966  94.047  1.00 29.69           C  
ATOM   1563  N   ARG B  26      34.141  58.917  94.169  1.00 27.59           N  
ATOM   1564  CA  ARG B  26      35.304  58.163  94.566  1.00 28.49           C  
ATOM   1565  C   ARG B  26      36.244  57.971  93.369  1.00 28.54           C  
ATOM   1566  O   ARG B  26      35.820  57.525  92.276  1.00 28.01           O  
ATOM   1567  CB  ARG B  26      34.887  56.806  95.083  1.00 29.20           C  
ATOM   1568  CG  ARG B  26      36.047  56.021  95.712  1.00 31.87           C  
ATOM   1569  CD  ARG B  26      35.657  54.561  95.849  1.00 35.38           C  
ATOM   1570  NE  ARG B  26      36.772  53.860  96.428  1.00 36.82           N  
ATOM   1571  CZ  ARG B  26      37.782  53.361  95.725  1.00 39.24           C  
ATOM   1572  NH1 ARG B  26      37.796  53.401  94.373  1.00 39.84           N  
ATOM   1573  NH2 ARG B  26      38.752  52.780  96.396  1.00 38.39           N  
ATOM   1574  N   THR B  27      37.504  58.322  93.583  1.00 28.76           N  
ATOM   1575  CA  THR B  27      38.522  58.223  92.534  1.00 29.84           C  
ATOM   1576  C   THR B  27      38.967  56.772  92.386  1.00 29.30           C  
ATOM   1577  O   THR B  27      39.371  56.117  93.356  1.00 30.90           O  
ATOM   1578  CB  THR B  27      39.673  59.187  92.771  1.00 30.15           C  
ATOM   1579  OG1 THR B  27      39.149  60.521  92.696  1.00 32.77           O  
ATOM   1580  CG2 THR B  27      40.810  59.035  91.681  1.00 30.35           C  
ATOM   1581  N   GLU B  28      38.837  56.285  91.163  1.00 27.61           N  
ATOM   1582  CA  GLU B  28      39.288  54.972  90.765  1.00 27.45           C  
ATOM   1583  C   GLU B  28      40.692  55.019  90.193  1.00 25.67           C  
ATOM   1584  O   GLU B  28      41.015  55.920  89.380  1.00 26.06           O  
ATOM   1585  CB  GLU B  28      38.401  54.488  89.652  1.00 27.37           C  
ATOM   1586  CG  GLU B  28      38.386  53.028  89.472  1.00 30.68           C  
ATOM   1587  CD  GLU B  28      37.642  52.614  88.210  1.00 28.42           C  
ATOM   1588  OE1 GLU B  28      37.760  53.287  87.180  1.00 29.04           O  
ATOM   1589  OE2 GLU B  28      36.986  51.569  88.235  1.00 31.47           O  
ATOM   1590  N   ASN B  29      41.508  54.074  90.595  1.00 23.73           N  
ATOM   1591  CA  ASN B  29      42.792  53.895  89.984  1.00 23.20           C  
ATOM   1592  C   ASN B  29      42.852  52.678  89.029  1.00 23.27           C  
ATOM   1593  O   ASN B  29      41.924  51.827  88.916  1.00 21.47           O  
ATOM   1594  CB  ASN B  29      43.962  53.926  91.015  1.00 23.14           C  
ATOM   1595  CG  ASN B  29      43.917  52.770  91.979  1.00 23.06           C  
ATOM   1596  OD1 ASN B  29      43.912  51.609  91.564  1.00 27.80           O  
ATOM   1597  ND2 ASN B  29      43.931  53.066  93.259  1.00 20.37           N  
ATOM   1598  N   VAL B  30      43.973  52.607  88.311  1.00 22.98           N  
ATOM   1599  CA  VAL B  30      44.064  51.607  87.274  1.00 23.55           C  
ATOM   1600  C   VAL B  30      44.139  50.211  87.885  1.00 23.55           C  
ATOM   1601  O   VAL B  30      43.761  49.209  87.278  1.00 23.42           O  
ATOM   1602  CB  VAL B  30      45.226  51.916  86.349  1.00 23.61           C  
ATOM   1603  CG1 VAL B  30      45.514  50.736  85.442  1.00 25.25           C  
ATOM   1604  CG2 VAL B  30      44.891  53.160  85.521  1.00 22.48           C  
ATOM   1605  N   SER B  31      44.651  50.145  89.097  1.00 23.89           N  
ATOM   1606  CA  SER B  31      44.812  48.871  89.750  1.00 24.64           C  
ATOM   1607  C   SER B  31      43.482  48.262  90.158  1.00 23.69           C  
ATOM   1608  O   SER B  31      43.234  47.101  89.896  1.00 23.83           O  
ATOM   1609  CB  SER B  31      45.754  49.006  90.966  1.00 24.66           C  
ATOM   1610  OG  SER B  31      45.419  47.966  91.818  1.00 30.47           O  
ATOM   1611  N   GLU B  32      42.626  49.055  90.791  1.00 24.62           N  
ATOM   1612  CA  GLU B  32      41.194  48.694  91.032  1.00 24.38           C  
ATOM   1613  C   GLU B  32      40.368  48.353  89.759  1.00 24.70           C  
ATOM   1614  O   GLU B  32      39.654  47.327  89.689  1.00 21.82           O  
ATOM   1615  CB  GLU B  32      40.511  49.825  91.798  1.00 24.88           C  
ATOM   1616  CG  GLU B  32      41.334  50.302  93.045  1.00 23.63           C  
ATOM   1617  CD  GLU B  32      40.806  51.624  93.609  1.00 25.21           C  
ATOM   1618  OE1 GLU B  32      40.288  52.452  92.834  1.00 24.63           O  
ATOM   1619  OE2 GLU B  32      40.874  51.806  94.824  1.00 27.40           O  
ATOM   1620  N   HIS B  33      40.563  49.143  88.708  1.00 24.18           N  
ATOM   1621  CA  HIS B  33      39.905  48.865  87.446  1.00 23.48           C  
ATOM   1622  C   HIS B  33      40.313  47.496  86.887  1.00 23.55           C  
ATOM   1623  O   HIS B  33      39.486  46.730  86.396  1.00 24.10           O  
ATOM   1624  CB  HIS B  33      40.293  50.017  86.455  1.00 24.76           C  
ATOM   1625  CG  HIS B  33      39.994  49.737  85.007  1.00 24.48           C  
ATOM   1626  ND1 HIS B  33      38.706  49.637  84.513  1.00 24.69           N  
ATOM   1627  CD2 HIS B  33      40.819  49.645  83.933  1.00 24.64           C  
ATOM   1628  CE1 HIS B  33      38.745  49.447  83.203  1.00 24.62           C  
ATOM   1629  NE2 HIS B  33      40.018  49.434  82.824  1.00 27.36           N  
ATOM   1630  N   SER B  34      41.610  47.222  86.904  1.00 22.51           N  
ATOM   1631  CA  SER B  34      42.198  46.042  86.280  1.00 23.04           C  
ATOM   1632  C   SER B  34      41.770  44.755  87.003  1.00 23.04           C  
ATOM   1633  O   SER B  34      41.411  43.749  86.367  1.00 22.88           O  
ATOM   1634  CB  SER B  34      43.718  46.181  86.259  1.00 23.22           C  
ATOM   1635  OG  SER B  34      44.075  47.208  85.352  1.00 23.52           O  
ATOM   1636  N   LEU B  35      41.699  44.835  88.332  1.00 22.10           N  
ATOM   1637  CA  LEU B  35      41.147  43.742  89.095  1.00 21.87           C  
ATOM   1638  C   LEU B  35      39.659  43.535  88.740  1.00 21.88           C  
ATOM   1639  O   LEU B  35      39.164  42.396  88.568  1.00 22.98           O  
ATOM   1640  CB  LEU B  35      41.337  43.974  90.599  1.00 20.65           C  
ATOM   1641  CG  LEU B  35      40.754  42.685  91.319  1.00 22.31           C  
ATOM   1642  CD1 LEU B  35      41.610  41.492  91.147  1.00 23.34           C  
ATOM   1643  CD2 LEU B  35      40.456  42.870  92.763  1.00 19.35           C  
ATOM   1644  N   GLN B  36      38.918  44.609  88.543  1.00 23.41           N  
ATOM   1645  CA  GLN B  36      37.479  44.410  88.221  1.00 23.16           C  
ATOM   1646  C   GLN B  36      37.263  43.877  86.806  1.00 23.03           C  
ATOM   1647  O   GLN B  36      36.356  43.034  86.533  1.00 22.64           O  
ATOM   1648  CB  GLN B  36      36.680  45.696  88.444  1.00 24.16           C  
ATOM   1649  CG  GLN B  36      35.163  45.412  88.375  1.00 27.40           C  
ATOM   1650  CD  GLN B  36      34.337  46.672  88.488  1.00 34.80           C  
ATOM   1651  OE1 GLN B  36      34.725  47.731  87.961  1.00 42.15           O  
ATOM   1652  NE2 GLN B  36      33.190  46.578  89.157  1.00 35.86           N  
ATOM   1653  N   VAL B  37      38.104  44.339  85.874  1.00 24.21           N  
ATOM   1654  CA  VAL B  37      38.008  43.895  84.455  1.00 22.75           C  
ATOM   1655  C   VAL B  37      38.347  42.390  84.395  1.00 22.05           C  
ATOM   1656  O   VAL B  37      37.729  41.674  83.627  1.00 23.44           O  
ATOM   1657  CB  VAL B  37      38.897  44.685  83.434  1.00 20.89           C  
ATOM   1658  CG1 VAL B  37      38.816  44.046  82.095  1.00 21.17           C  
ATOM   1659  CG2 VAL B  37      38.469  46.153  83.288  1.00 21.71           C  
ATOM   1660  N   ALA B  38      39.326  41.961  85.182  1.00 22.15           N  
ATOM   1661  CA  ALA B  38      39.767  40.575  85.267  1.00 21.09           C  
ATOM   1662  C   ALA B  38      38.689  39.691  85.788  1.00 21.94           C  
ATOM   1663  O   ALA B  38      38.456  38.588  85.281  1.00 20.61           O  
ATOM   1664  CB  ALA B  38      40.974  40.481  86.151  1.00 22.02           C  
ATOM   1665  N   MET B  39      37.997  40.176  86.817  1.00 22.05           N  
ATOM   1666  CA  MET B  39      36.884  39.403  87.378  1.00 22.61           C  
ATOM   1667  C   MET B  39      35.690  39.298  86.437  1.00 22.21           C  
ATOM   1668  O   MET B  39      35.072  38.238  86.310  1.00 22.78           O  
ATOM   1669  CB  MET B  39      36.407  39.948  88.737  1.00 22.13           C  
ATOM   1670  CG  MET B  39      37.326  39.468  89.828  1.00 21.74           C  
ATOM   1671  SD  MET B  39      36.827  40.181  91.364  1.00 23.72           S  
ATOM   1672  CE  MET B  39      38.107  39.521  92.461  1.00 26.75           C  
ATOM   1673  N   VAL B  40      35.356  40.415  85.832  1.00 22.20           N  
ATOM   1674  CA  VAL B  40      34.335  40.461  84.815  1.00 20.98           C  
ATOM   1675  C   VAL B  40      34.666  39.670  83.542  1.00 21.21           C  
ATOM   1676  O   VAL B  40      33.836  38.902  83.104  1.00 20.81           O  
ATOM   1677  CB  VAL B  40      33.959  41.915  84.503  1.00 22.14           C  
ATOM   1678  CG1 VAL B  40      32.892  41.959  83.434  1.00 22.82           C  
ATOM   1679  CG2 VAL B  40      33.438  42.640  85.792  1.00 20.83           C  
ATOM   1680  N   ALA B  41      35.837  39.884  82.930  1.00 21.80           N  
ATOM   1681  CA  ALA B  41      36.263  39.097  81.738  1.00 22.80           C  
ATOM   1682  C   ALA B  41      36.352  37.591  82.030  1.00 22.96           C  
ATOM   1683  O   ALA B  41      36.000  36.787  81.199  1.00 24.70           O  
ATOM   1684  CB  ALA B  41      37.625  39.560  81.241  1.00 23.24           C  
ATOM   1685  N   HIS B  42      36.847  37.206  83.198  1.00 22.13           N  
ATOM   1686  CA  HIS B  42      36.774  35.792  83.556  1.00 21.81           C  
ATOM   1687  C   HIS B  42      35.322  35.285  83.602  1.00 21.81           C  
ATOM   1688  O   HIS B  42      35.030  34.218  83.071  1.00 21.93           O  
ATOM   1689  CB  HIS B  42      37.430  35.527  84.882  1.00 22.93           C  
ATOM   1690  CG  HIS B  42      37.179  34.148  85.396  1.00 23.45           C  
ATOM   1691  ND1 HIS B  42      36.258  33.882  86.386  1.00 20.38           N  
ATOM   1692  CD2 HIS B  42      37.755  32.962  85.082  1.00 25.21           C  
ATOM   1693  CE1 HIS B  42      36.214  32.576  86.598  1.00 23.35           C  
ATOM   1694  NE2 HIS B  42      37.106  31.992  85.810  1.00 24.91           N  
ATOM   1695  N   ALA B  43      34.434  36.010  84.272  1.00 21.67           N  
ATOM   1696  CA  ALA B  43      33.039  35.580  84.358  1.00 21.76           C  
ATOM   1697  C   ALA B  43      32.385  35.494  82.996  1.00 20.76           C  
ATOM   1698  O   ALA B  43      31.681  34.572  82.748  1.00 21.48           O  
ATOM   1699  CB  ALA B  43      32.172  36.548  85.260  1.00 22.12           C  
ATOM   1700  N   LEU B  44      32.602  36.473  82.145  1.00 21.00           N  
ATOM   1701  CA  LEU B  44      32.006  36.481  80.784  1.00 21.22           C  
ATOM   1702  C   LEU B  44      32.417  35.250  80.012  1.00 21.84           C  
ATOM   1703  O   LEU B  44      31.605  34.640  79.316  1.00 21.25           O  
ATOM   1704  CB  LEU B  44      32.455  37.757  80.015  1.00 21.29           C  
ATOM   1705  CG  LEU B  44      31.864  39.087  80.415  1.00 20.10           C  
ATOM   1706  CD1 LEU B  44      32.322  40.197  79.510  1.00 19.12           C  
ATOM   1707  CD2 LEU B  44      30.345  39.012  80.344  1.00 20.82           C  
ATOM   1708  N   ALA B  45      33.707  34.887  80.160  1.00 21.15           N  
ATOM   1709  CA  ALA B  45      34.278  33.724  79.526  1.00 22.12           C  
ATOM   1710  C   ALA B  45      33.669  32.396  80.068  1.00 23.42           C  
ATOM   1711  O   ALA B  45      33.404  31.423  79.327  1.00 22.48           O  
ATOM   1712  CB  ALA B  45      35.835  33.776  79.743  1.00 23.22           C  
ATOM   1713  N   ALA B  46      33.517  32.329  81.388  1.00 23.90           N  
ATOM   1714  CA  ALA B  46      32.968  31.124  81.997  1.00 23.72           C  
ATOM   1715  C   ALA B  46      31.520  30.969  81.611  1.00 22.73           C  
ATOM   1716  O   ALA B  46      31.064  29.846  81.351  1.00 23.72           O  
ATOM   1717  CB  ALA B  46      33.165  31.184  83.521  1.00 24.66           C  
ATOM   1718  N   ILE B  47      30.785  32.078  81.511  1.00 21.59           N  
ATOM   1719  CA  ILE B  47      29.387  32.046  81.066  1.00 21.01           C  
ATOM   1720  C   ILE B  47      29.294  31.581  79.605  1.00 20.83           C  
ATOM   1721  O   ILE B  47      28.506  30.710  79.247  1.00 18.39           O  
ATOM   1722  CB  ILE B  47      28.717  33.438  81.271  1.00 21.64           C  
ATOM   1723  CG1 ILE B  47      28.603  33.772  82.769  1.00 20.37           C  
ATOM   1724  CG2 ILE B  47      27.301  33.536  80.596  1.00 19.62           C  
ATOM   1725  CD1 ILE B  47      28.288  35.259  83.093  1.00 21.82           C  
ATOM   1726  N   LYS B  48      30.174  32.115  78.775  1.00 21.15           N  
ATOM   1727  CA  LYS B  48      30.278  31.724  77.370  1.00 22.72           C  
ATOM   1728  C   LYS B  48      30.499  30.226  77.211  1.00 23.39           C  
ATOM   1729  O   LYS B  48      29.741  29.533  76.536  1.00 22.00           O  
ATOM   1730  CB  LYS B  48      31.414  32.489  76.670  1.00 22.80           C  
ATOM   1731  CG  LYS B  48      31.482  32.228  75.168  1.00 22.20           C  
ATOM   1732  CD  LYS B  48      32.287  33.301  74.467  1.00 24.64           C  
ATOM   1733  CE  LYS B  48      32.211  33.200  72.928  1.00 27.67           C  
ATOM   1734  NZ  LYS B  48      33.484  32.672  72.415  1.00 30.96           N  
ATOM   1735  N   ASN B  49      31.537  29.752  77.881  1.00 23.40           N  
ATOM   1736  CA  ASN B  49      31.835  28.338  77.925  1.00 23.79           C  
ATOM   1737  C   ASN B  49      30.666  27.504  78.420  1.00 24.05           C  
ATOM   1738  O   ASN B  49      30.243  26.541  77.767  1.00 24.02           O  
ATOM   1739  CB  ASN B  49      33.098  28.095  78.784  1.00 23.34           C  
ATOM   1740  CG  ASN B  49      34.349  28.450  78.048  1.00 24.81           C  
ATOM   1741  OD1 ASN B  49      34.285  28.769  76.858  1.00 27.83           O  
ATOM   1742  ND2 ASN B  49      35.510  28.372  78.711  1.00 21.94           N  
ATOM   1743  N   ARG B  50      30.146  27.873  79.573  1.00 23.24           N  
ATOM   1744  CA  ARG B  50      29.087  27.145  80.188  1.00 24.38           C  
ATOM   1745  C   ARG B  50      27.790  27.108  79.381  1.00 24.07           C  
ATOM   1746  O   ARG B  50      27.181  26.065  79.220  1.00 23.91           O  
ATOM   1747  CB  ARG B  50      28.787  27.706  81.576  1.00 24.30           C  
ATOM   1748  CG  ARG B  50      27.599  26.972  82.286  1.00 26.05           C  
ATOM   1749  CD  ARG B  50      27.894  25.481  82.463  1.00 28.32           C  
ATOM   1750  NE  ARG B  50      29.204  25.256  83.100  1.00 27.43           N  
ATOM   1751  CZ  ARG B  50      29.441  25.220  84.414  1.00 28.23           C  
ATOM   1752  NH1 ARG B  50      28.472  25.369  85.291  1.00 25.72           N  
ATOM   1753  NH2 ARG B  50      30.679  25.034  84.853  1.00 29.54           N  
ATOM   1754  N   LYS B  51      27.360  28.258  78.889  1.00 23.98           N  
ATOM   1755  CA  LYS B  51      26.060  28.391  78.320  1.00 23.48           C  
ATOM   1756  C   LYS B  51      26.023  28.652  76.843  1.00 23.69           C  
ATOM   1757  O   LYS B  51      24.962  28.445  76.220  1.00 20.99           O  
ATOM   1758  CB  LYS B  51      25.337  29.484  79.055  1.00 25.48           C  
ATOM   1759  CG  LYS B  51      24.836  29.020  80.440  1.00 25.89           C  
ATOM   1760  CD  LYS B  51      23.990  30.040  81.142  1.00 26.24           C  
ATOM   1761  CE  LYS B  51      22.467  29.909  80.828  1.00 29.10           C  
ATOM   1762  NZ  LYS B  51      21.845  28.571  81.040  1.00 28.53           N  
ATOM   1763  N   PHE B  52      27.129  29.106  76.236  1.00 22.31           N  
ATOM   1764  CA  PHE B  52      26.994  29.579  74.831  1.00 23.57           C  
ATOM   1765  C   PHE B  52      27.948  28.960  73.796  1.00 23.92           C  
ATOM   1766  O   PHE B  52      28.192  29.565  72.758  1.00 24.11           O  
ATOM   1767  CB  PHE B  52      26.932  31.141  74.771  1.00 22.40           C  
ATOM   1768  CG  PHE B  52      25.851  31.712  75.629  1.00 21.71           C  
ATOM   1769  CD1 PHE B  52      24.537  31.410  75.381  1.00 20.85           C  
ATOM   1770  CD2 PHE B  52      26.135  32.501  76.714  1.00 23.06           C  
ATOM   1771  CE1 PHE B  52      23.501  31.895  76.190  1.00 22.26           C  
ATOM   1772  CE2 PHE B  52      25.114  32.994  77.510  1.00 19.97           C  
ATOM   1773  CZ  PHE B  52      23.782  32.667  77.242  1.00 22.22           C  
ATOM   1774  N   GLY B  53      28.437  27.750  74.048  1.00 24.18           N  
ATOM   1775  CA  GLY B  53      29.201  27.016  73.013  1.00 25.18           C  
ATOM   1776  C   GLY B  53      30.677  27.397  73.026  1.00 26.21           C  
ATOM   1777  O   GLY B  53      31.455  27.004  72.151  1.00 26.85           O  
ATOM   1778  N   GLY B  54      31.078  28.166  74.025  1.00 25.69           N  
ATOM   1779  CA  GLY B  54      32.432  28.660  74.055  1.00 26.53           C  
ATOM   1780  C   GLY B  54      33.428  27.572  74.310  1.00 26.59           C  
ATOM   1781  O   GLY B  54      33.098  26.515  74.867  1.00 24.32           O  
ATOM   1782  N   ASN B  55      34.649  27.876  73.896  1.00 27.92           N  
ATOM   1783  CA  ASN B  55      35.806  27.060  74.150  1.00 29.08           C  
ATOM   1784  C   ASN B  55      37.041  27.924  74.445  1.00 29.58           C  
ATOM   1785  O   ASN B  55      38.148  27.581  74.064  1.00 31.25           O  
ATOM   1786  CB  ASN B  55      36.045  26.149  72.943  1.00 29.81           C  
ATOM   1787  CG  ASN B  55      37.078  25.087  73.208  1.00 33.20           C  
ATOM   1788  OD1 ASN B  55      37.781  24.665  72.292  1.00 37.77           O  
ATOM   1789  ND2 ASN B  55      37.193  24.656  74.454  1.00 35.98           N  
ATOM   1790  N   VAL B  56      36.864  29.004  75.200  1.00 29.16           N  
ATOM   1791  CA  VAL B  56      37.937  29.973  75.446  1.00 27.62           C  
ATOM   1792  C   VAL B  56      38.612  29.643  76.775  1.00 28.05           C  
ATOM   1793  O   VAL B  56      37.975  29.075  77.657  1.00 28.17           O  
ATOM   1794  CB  VAL B  56      37.402  31.443  75.435  1.00 28.27           C  
ATOM   1795  CG1 VAL B  56      36.820  31.806  74.080  1.00 27.25           C  
ATOM   1796  CG2 VAL B  56      36.370  31.688  76.496  1.00 25.61           C  
ATOM   1797  N   ASN B  57      39.916  29.918  76.896  1.00 27.00           N  
ATOM   1798  CA  ASN B  57      40.590  29.743  78.177  1.00 27.68           C  
ATOM   1799  C   ASN B  57      40.307  30.930  79.095  1.00 27.25           C  
ATOM   1800  O   ASN B  57      40.955  31.994  79.056  1.00 28.90           O  
ATOM   1801  CB  ASN B  57      42.091  29.471  77.965  1.00 27.69           C  
ATOM   1802  CG  ASN B  57      42.879  29.345  79.253  1.00 29.12           C  
ATOM   1803  OD1 ASN B  57      42.401  29.653  80.362  1.00 28.57           O  
ATOM   1804  ND2 ASN B  57      44.153  28.957  79.102  1.00 27.58           N  
ATOM   1805  N   ALA B  58      39.340  30.721  79.966  1.00 26.89           N  
ATOM   1806  CA  ALA B  58      38.856  31.747  80.870  1.00 27.11           C  
ATOM   1807  C   ALA B  58      39.945  32.199  81.882  1.00 26.76           C  
ATOM   1808  O   ALA B  58      40.019  33.356  82.223  1.00 27.29           O  
ATOM   1809  CB  ALA B  58      37.672  31.247  81.557  1.00 27.24           C  
ATOM   1810  N   GLU B  59      40.749  31.284  82.376  1.00 26.25           N  
ATOM   1811  CA  GLU B  59      41.830  31.639  83.316  1.00 27.13           C  
ATOM   1812  C   GLU B  59      42.875  32.537  82.621  1.00 27.00           C  
ATOM   1813  O   GLU B  59      43.330  33.561  83.159  1.00 26.43           O  
ATOM   1814  CB  GLU B  59      42.465  30.363  83.856  1.00 27.68           C  
ATOM   1815  CG  GLU B  59      41.744  29.877  85.064  1.00 32.59           C  
ATOM   1816  CD  GLU B  59      41.846  28.399  85.315  1.00 38.54           C  
ATOM   1817  OE1 GLU B  59      42.825  27.729  84.850  1.00 40.37           O  
ATOM   1818  OE2 GLU B  59      40.879  27.915  85.978  1.00 42.46           O  
ATOM   1819  N   ARG B  60      43.196  32.166  81.389  1.00 25.68           N  
ATOM   1820  CA  ARG B  60      44.026  32.985  80.553  1.00 26.80           C  
ATOM   1821  C   ARG B  60      43.443  34.409  80.384  1.00 25.33           C  
ATOM   1822  O   ARG B  60      44.184  35.420  80.524  1.00 25.23           O  
ATOM   1823  CB  ARG B  60      44.208  32.274  79.208  1.00 27.40           C  
ATOM   1824  CG  ARG B  60      44.899  33.103  78.176  1.00 31.32           C  
ATOM   1825  CD  ARG B  60      46.230  33.439  78.659  1.00 33.27           C  
ATOM   1826  NE  ARG B  60      47.160  33.642  77.559  1.00 38.55           N  
ATOM   1827  CZ  ARG B  60      48.479  33.495  77.696  1.00 36.12           C  
ATOM   1828  NH1 ARG B  60      48.964  33.109  78.840  1.00 37.88           N  
ATOM   1829  NH2 ARG B  60      49.301  33.703  76.683  1.00 38.76           N  
ATOM   1830  N   ILE B  61      42.126  34.481  80.193  1.00 23.69           N  
ATOM   1831  CA  ILE B  61      41.442  35.737  80.018  1.00 23.29           C  
ATOM   1832  C   ILE B  61      41.480  36.615  81.279  1.00 22.62           C  
ATOM   1833  O   ILE B  61      41.664  37.808  81.195  1.00 21.37           O  
ATOM   1834  CB  ILE B  61      40.057  35.547  79.408  1.00 24.18           C  
ATOM   1835  CG1 ILE B  61      40.201  35.252  77.888  1.00 25.82           C  
ATOM   1836  CG2 ILE B  61      39.234  36.775  79.636  1.00 25.74           C  
ATOM   1837  CD1 ILE B  61      39.056  34.585  77.256  1.00 25.41           C  
ATOM   1838  N   ALA B  62      41.407  36.025  82.450  1.00 22.07           N  
ATOM   1839  CA  ALA B  62      41.641  36.792  83.699  1.00 22.50           C  
ATOM   1840  C   ALA B  62      43.008  37.440  83.772  1.00 22.72           C  
ATOM   1841  O   ALA B  62      43.145  38.626  83.999  1.00 20.72           O  
ATOM   1842  CB  ALA B  62      41.420  35.862  84.924  1.00 22.38           C  
ATOM   1843  N   LEU B  63      44.048  36.658  83.530  1.00 24.01           N  
ATOM   1844  CA  LEU B  63      45.401  37.203  83.456  1.00 24.07           C  
ATOM   1845  C   LEU B  63      45.585  38.316  82.349  1.00 24.46           C  
ATOM   1846  O   LEU B  63      46.176  39.353  82.586  1.00 24.01           O  
ATOM   1847  CB  LEU B  63      46.327  36.010  83.233  1.00 24.70           C  
ATOM   1848  CG  LEU B  63      47.794  36.194  83.340  1.00 26.87           C  
ATOM   1849  CD1 LEU B  63      48.130  36.842  84.641  1.00 26.05           C  
ATOM   1850  CD2 LEU B  63      48.483  34.789  83.145  1.00 26.38           C  
ATOM   1851  N   LEU B  64      45.051  38.137  81.135  1.00 24.32           N  
ATOM   1852  CA  LEU B  64      45.094  39.239  80.162  1.00 24.08           C  
ATOM   1853  C   LEU B  64      44.368  40.486  80.660  1.00 24.56           C  
ATOM   1854  O   LEU B  64      44.818  41.609  80.423  1.00 25.12           O  
ATOM   1855  CB  LEU B  64      44.475  38.861  78.830  1.00 24.68           C  
ATOM   1856  CG  LEU B  64      45.025  37.618  78.151  1.00 23.26           C  
ATOM   1857  CD1 LEU B  64      44.154  37.319  76.942  1.00 22.01           C  
ATOM   1858  CD2 LEU B  64      46.482  37.759  77.807  1.00 25.95           C  
ATOM   1859  N   ALA B  65      43.196  40.291  81.279  1.00 23.68           N  
ATOM   1860  CA  ALA B  65      42.516  41.394  81.890  1.00 23.42           C  
ATOM   1861  C   ALA B  65      43.348  42.073  82.986  1.00 23.44           C  
ATOM   1862  O   ALA B  65      43.342  43.292  83.050  1.00 22.84           O  
ATOM   1863  CB  ALA B  65      41.057  41.009  82.346  1.00 23.65           C  
ATOM   1864  N   MET B  66      44.168  41.325  83.748  1.00 23.43           N  
ATOM   1865  CA  MET B  66      44.962  41.911  84.811  1.00 24.19           C  
ATOM   1866  C   MET B  66      45.942  42.909  84.265  1.00 23.54           C  
ATOM   1867  O   MET B  66      46.224  43.927  84.907  1.00 24.50           O  
ATOM   1868  CB  MET B  66      45.729  40.841  85.608  1.00 23.42           C  
ATOM   1869  CG  MET B  66      44.856  40.133  86.655  1.00 26.47           C  
ATOM   1870  SD  MET B  66      45.569  38.535  87.166  1.00 25.80           S  
ATOM   1871  CE  MET B  66      47.277  39.016  87.532  1.00 26.00           C  
ATOM   1872  N   TYR B  67      46.452  42.602  83.076  1.00 23.75           N  
ATOM   1873  CA  TYR B  67      47.511  43.360  82.435  1.00 23.50           C  
ATOM   1874  C   TYR B  67      47.106  44.321  81.305  1.00 23.65           C  
ATOM   1875  O   TYR B  67      47.974  44.971  80.745  1.00 23.76           O  
ATOM   1876  CB  TYR B  67      48.538  42.386  81.870  1.00 23.32           C  
ATOM   1877  CG  TYR B  67      49.492  41.892  82.921  1.00 22.07           C  
ATOM   1878  CD1 TYR B  67      50.567  42.677  83.350  1.00 22.91           C  
ATOM   1879  CD2 TYR B  67      49.306  40.675  83.500  1.00 21.51           C  
ATOM   1880  CE1 TYR B  67      51.459  42.202  84.307  1.00 22.07           C  
ATOM   1881  CE2 TYR B  67      50.168  40.206  84.491  1.00 24.96           C  
ATOM   1882  CZ  TYR B  67      51.230  40.959  84.883  1.00 19.55           C  
ATOM   1883  OH  TYR B  67      52.068  40.433  85.850  1.00 25.36           O  
ATOM   1884  N   HIS B  68      45.815  44.400  80.997  1.00 23.46           N  
ATOM   1885  CA  HIS B  68      45.316  45.064  79.781  1.00 23.70           C  
ATOM   1886  C   HIS B  68      45.624  46.539  79.763  1.00 23.57           C  
ATOM   1887  O   HIS B  68      45.689  47.108  78.691  1.00 23.77           O  
ATOM   1888  CB  HIS B  68      43.748  44.795  79.570  1.00 23.12           C  
ATOM   1889  CG  HIS B  68      42.851  45.717  80.334  1.00 23.42           C  
ATOM   1890  ND1 HIS B  68      42.536  45.530  81.664  1.00 25.15           N  
ATOM   1891  CD2 HIS B  68      42.243  46.874  79.972  1.00 24.21           C  
ATOM   1892  CE1 HIS B  68      41.801  46.537  82.096  1.00 24.62           C  
ATOM   1893  NE2 HIS B  68      41.594  47.362  81.085  1.00 22.77           N  
ATOM   1894  N   ASP B  69      45.811  47.183  80.929  1.00 24.49           N  
ATOM   1895  CA  ASP B  69      46.122  48.646  80.961  1.00 23.95           C  
ATOM   1896  C   ASP B  69      47.462  48.871  81.607  1.00 24.27           C  
ATOM   1897  O   ASP B  69      47.721  49.935  82.092  1.00 23.07           O  
ATOM   1898  CB  ASP B  69      45.084  49.459  81.725  1.00 24.52           C  
ATOM   1899  CG  ASP B  69      43.783  49.691  80.923  1.00 26.82           C  
ATOM   1900  OD1 ASP B  69      43.740  49.590  79.657  1.00 24.21           O  
ATOM   1901  OD2 ASP B  69      42.789  50.011  81.600  1.00 28.59           O  
ATOM   1902  N   ALA B  70      48.322  47.860  81.590  1.00 25.60           N  
ATOM   1903  CA  ALA B  70      49.600  47.910  82.343  1.00 26.82           C  
ATOM   1904  C   ALA B  70      50.532  49.008  81.884  1.00 27.94           C  
ATOM   1905  O   ALA B  70      51.328  49.513  82.681  1.00 28.29           O  
ATOM   1906  CB  ALA B  70      50.361  46.572  82.270  1.00 27.14           C  
ATOM   1907  N   SER B  71      50.444  49.356  80.595  1.00 28.83           N  
ATOM   1908  CA  SER B  71      51.297  50.409  79.998  1.00 28.23           C  
ATOM   1909  C   SER B  71      50.954  51.815  80.515  1.00 27.43           C  
ATOM   1910  O   SER B  71      51.689  52.760  80.199  1.00 24.73           O  
ATOM   1911  CB  SER B  71      51.087  50.470  78.486  1.00 27.96           C  
ATOM   1912  OG  SER B  71      49.734  50.871  78.203  1.00 30.75           O  
ATOM   1913  N   ALA B  72      49.800  51.968  81.184  1.00 26.99           N  
ATOM   1914  CA  ALA B  72      49.427  53.232  81.856  1.00 27.14           C  
ATOM   1915  C   ALA B  72      50.477  53.708  82.825  1.00 27.39           C  
ATOM   1916  O   ALA B  72      50.695  54.910  83.009  1.00 26.54           O  
ATOM   1917  CB  ALA B  72      48.046  53.085  82.555  1.00 28.56           C  
ATOM   1918  N   VAL B  73      51.235  52.779  83.395  1.00 28.24           N  
ATOM   1919  CA  VAL B  73      52.309  53.188  84.303  1.00 28.03           C  
ATOM   1920  C   VAL B  73      53.436  53.927  83.618  1.00 28.29           C  
ATOM   1921  O   VAL B  73      54.246  54.581  84.256  1.00 29.23           O  
ATOM   1922  CB  VAL B  73      52.864  51.986  85.096  1.00 28.66           C  
ATOM   1923  CG1 VAL B  73      51.784  51.363  85.915  1.00 26.78           C  
ATOM   1924  CG2 VAL B  73      53.574  50.950  84.144  1.00 28.03           C  
ATOM   1925  N   LEU B  74      53.502  53.819  82.306  1.00 28.35           N  
ATOM   1926  CA  LEU B  74      54.499  54.554  81.525  1.00 27.56           C  
ATOM   1927  C   LEU B  74      53.905  55.799  80.864  1.00 27.73           C  
ATOM   1928  O   LEU B  74      54.615  56.794  80.653  1.00 25.55           O  
ATOM   1929  CB  LEU B  74      55.053  53.629  80.438  1.00 28.67           C  
ATOM   1930  CG  LEU B  74      55.773  52.318  80.895  1.00 27.35           C  
ATOM   1931  CD1 LEU B  74      56.507  51.656  79.723  1.00 28.37           C  
ATOM   1932  CD2 LEU B  74      56.754  52.610  81.998  1.00 29.57           C  
ATOM   1933  N   THR B  75      52.622  55.720  80.487  1.00 26.55           N  
ATOM   1934  CA  THR B  75      52.009  56.732  79.657  1.00 27.64           C  
ATOM   1935  C   THR B  75      51.099  57.698  80.448  1.00 28.14           C  
ATOM   1936  O   THR B  75      50.940  58.870  80.041  1.00 27.97           O  
ATOM   1937  CB  THR B  75      51.106  56.102  78.580  1.00 27.97           C  
ATOM   1938  OG1 THR B  75      50.052  55.373  79.220  1.00 27.37           O  
ATOM   1939  CG2 THR B  75      51.909  55.192  77.627  1.00 30.21           C  
ATOM   1940  N   GLY B  76      50.539  57.218  81.557  1.00 27.91           N  
ATOM   1941  CA  GLY B  76      49.424  57.881  82.262  1.00 28.51           C  
ATOM   1942  C   GLY B  76      48.105  57.454  81.630  1.00 29.70           C  
ATOM   1943  O   GLY B  76      48.040  56.868  80.552  1.00 30.87           O  
ATOM   1944  N   ASP B  77      47.029  57.777  82.283  1.00 31.32           N  
ATOM   1945  CA  ASP B  77      45.727  57.454  81.764  1.00 32.55           C  
ATOM   1946  C   ASP B  77      45.441  58.542  80.705  1.00 33.37           C  
ATOM   1947  O   ASP B  77      45.911  59.669  80.841  1.00 33.93           O  
ATOM   1948  CB  ASP B  77      44.762  57.486  82.956  1.00 33.41           C  
ATOM   1949  CG  ASP B  77      43.365  57.137  82.582  1.00 32.61           C  
ATOM   1950  OD1 ASP B  77      43.120  56.044  82.024  1.00 40.42           O  
ATOM   1951  OD2 ASP B  77      42.540  57.981  82.810  1.00 32.11           O  
ATOM   1952  N   LEU B  78      44.803  58.189  79.591  1.00 33.65           N  
ATOM   1953  CA  LEU B  78      44.293  59.195  78.657  1.00 33.55           C  
ATOM   1954  C   LEU B  78      42.822  58.897  78.425  1.00 33.88           C  
ATOM   1955  O   LEU B  78      42.464  57.818  77.941  1.00 31.22           O  
ATOM   1956  CB  LEU B  78      45.058  59.200  77.323  1.00 34.16           C  
ATOM   1957  CG  LEU B  78      44.821  60.335  76.292  1.00 35.44           C  
ATOM   1958  CD1 LEU B  78      45.870  60.371  75.177  1.00 38.21           C  
ATOM   1959  CD2 LEU B  78      43.484  60.210  75.621  1.00 36.43           C  
ATOM   1960  N   PRO B  79      41.971  59.857  78.782  1.00 34.49           N  
ATOM   1961  CA  PRO B  79      40.572  59.644  78.747  1.00 34.58           C  
ATOM   1962  C   PRO B  79      40.141  59.374  77.310  1.00 34.79           C  
ATOM   1963  O   PRO B  79      40.550  60.071  76.393  1.00 33.25           O  
ATOM   1964  CB  PRO B  79      39.997  60.932  79.331  1.00 34.73           C  
ATOM   1965  CG  PRO B  79      41.011  61.886  79.258  1.00 34.97           C  
ATOM   1966  CD  PRO B  79      42.307  61.221  79.222  1.00 35.20           C  
ATOM   1967  N   THR B  80      39.374  58.310  77.126  1.00 35.81           N  
ATOM   1968  CA  THR B  80      39.079  57.815  75.770  1.00 37.72           C  
ATOM   1969  C   THR B  80      38.403  58.863  74.804  1.00 36.76           C  
ATOM   1970  O   THR B  80      38.683  58.864  73.603  1.00 36.29           O  
ATOM   1971  CB  THR B  80      38.281  56.459  75.792  1.00 37.52           C  
ATOM   1972  OG1 THR B  80      37.054  56.650  76.477  1.00 40.39           O  
ATOM   1973  CG2 THR B  80      39.070  55.329  76.456  1.00 37.93           C  
ATOM   1974  N   PRO B  81      37.577  59.783  75.321  1.00 36.74           N  
ATOM   1975  CA  PRO B  81      37.131  60.837  74.401  1.00 37.14           C  
ATOM   1976  C   PRO B  81      38.284  61.763  73.952  1.00 37.70           C  
ATOM   1977  O   PRO B  81      39.369  61.847  74.629  1.00 36.31           O  
ATOM   1978  CB  PRO B  81      36.100  61.613  75.223  1.00 37.71           C  
ATOM   1979  CG  PRO B  81      35.755  60.696  76.404  1.00 37.78           C  
ATOM   1980  CD  PRO B  81      37.020  59.957  76.667  1.00 37.50           C  
ATOM   1981  N   ALA B  90      45.048  59.454  68.087  1.00 33.97           N  
ATOM   1982  CA  ALA B  90      44.016  58.449  67.854  1.00 34.68           C  
ATOM   1983  C   ALA B  90      44.713  57.166  67.418  1.00 35.04           C  
ATOM   1984  O   ALA B  90      45.075  56.332  68.271  1.00 35.16           O  
ATOM   1985  CB  ALA B  90      43.051  58.931  66.824  1.00 34.84           C  
ATOM   1986  N   GLN B  91      44.974  57.043  66.113  1.00 35.30           N  
ATOM   1987  CA  GLN B  91      45.861  55.996  65.582  1.00 35.39           C  
ATOM   1988  C   GLN B  91      47.249  56.177  66.162  1.00 36.05           C  
ATOM   1989  O   GLN B  91      48.010  55.209  66.357  1.00 34.71           O  
ATOM   1990  CB  GLN B  91      45.957  56.065  64.049  1.00 35.58           C  
ATOM   1991  N   GLU B  92      47.591  57.429  66.424  1.00 36.36           N  
ATOM   1992  CA  GLU B  92      48.876  57.716  66.998  1.00 37.10           C  
ATOM   1993  C   GLU B  92      48.975  57.203  68.427  1.00 37.25           C  
ATOM   1994  O   GLU B  92      49.993  56.564  68.816  1.00 36.63           O  
ATOM   1995  CB  GLU B  92      49.158  59.209  66.938  1.00 37.52           C  
ATOM   1996  CG  GLU B  92      50.631  59.526  66.858  1.00 39.79           C  
ATOM   1997  CD  GLU B  92      51.356  58.704  65.802  1.00 41.70           C  
ATOM   1998  OE1 GLU B  92      50.852  58.615  64.653  1.00 43.34           O  
ATOM   1999  OE2 GLU B  92      52.423  58.149  66.133  1.00 41.59           O  
ATOM   2000  N   TYR B  93      47.926  57.460  69.213  1.00 37.15           N  
ATOM   2001  CA  TYR B  93      47.921  57.055  70.618  1.00 36.51           C  
ATOM   2002  C   TYR B  93      48.009  55.516  70.731  1.00 36.00           C  
ATOM   2003  O   TYR B  93      48.921  54.960  71.312  1.00 35.80           O  
ATOM   2004  CB  TYR B  93      46.700  57.581  71.386  1.00 36.62           C  
ATOM   2005  CG  TYR B  93      46.984  57.540  72.866  1.00 36.93           C  
ATOM   2006  CD1 TYR B  93      47.848  58.480  73.448  1.00 39.03           C  
ATOM   2007  CD2 TYR B  93      46.494  56.537  73.660  1.00 37.20           C  
ATOM   2008  CE1 TYR B  93      48.190  58.418  74.804  1.00 38.91           C  
ATOM   2009  CE2 TYR B  93      46.817  56.469  75.029  1.00 37.55           C  
ATOM   2010  CZ  TYR B  93      47.661  57.414  75.595  1.00 38.35           C  
ATOM   2011  OH  TYR B  93      47.952  57.360  76.942  1.00 37.62           O  
ATOM   2012  N   LYS B  94      47.058  54.837  70.144  1.00 35.92           N  
ATOM   2013  CA  LYS B  94      47.113  53.383  70.016  1.00 36.10           C  
ATOM   2014  C   LYS B  94      48.545  52.893  69.704  1.00 36.12           C  
ATOM   2015  O   LYS B  94      49.005  51.885  70.264  1.00 36.49           O  
ATOM   2016  CB  LYS B  94      46.053  52.938  68.974  1.00 36.15           C  
ATOM   2017  CG  LYS B  94      46.086  51.479  68.555  1.00 36.61           C  
ATOM   2018  N   ALA B  95      49.265  53.641  68.868  1.00 36.30           N  
ATOM   2019  CA  ALA B  95      50.685  53.377  68.557  1.00 35.86           C  
ATOM   2020  C   ALA B  95      51.651  53.597  69.750  1.00 35.68           C  
ATOM   2021  O   ALA B  95      52.599  52.810  69.937  1.00 35.22           O  
ATOM   2022  CB  ALA B  95      51.160  54.220  67.339  1.00 36.10           C  
ATOM   2023  N   ILE B  96      51.421  54.667  70.512  1.00 35.21           N  
ATOM   2024  CA  ILE B  96      52.186  54.957  71.720  1.00 35.32           C  
ATOM   2025  C   ILE B  96      51.961  53.877  72.765  1.00 34.98           C  
ATOM   2026  O   ILE B  96      52.914  53.470  73.437  1.00 34.13           O  
ATOM   2027  CB  ILE B  96      51.791  56.342  72.361  1.00 34.78           C  
ATOM   2028  CG1 ILE B  96      52.607  56.668  73.618  1.00 34.87           C  
ATOM   2029  CG2 ILE B  96      50.382  56.384  72.837  1.00 37.15           C  
ATOM   2030  CD1 ILE B  96      52.071  57.938  74.391  1.00 35.84           C  
ATOM   2031  N   GLU B  97      50.691  53.451  72.910  1.00 34.21           N  
ATOM   2032  CA  GLU B  97      50.320  52.406  73.842  1.00 33.66           C  
ATOM   2033  C   GLU B  97      51.125  51.174  73.491  1.00 32.89           C  
ATOM   2034  O   GLU B  97      51.647  50.508  74.376  1.00 32.70           O  
ATOM   2035  CB  GLU B  97      48.837  52.076  73.766  1.00 34.05           C  
ATOM   2036  CG  GLU B  97      47.956  52.995  74.575  1.00 36.52           C  
ATOM   2037  CD  GLU B  97      46.473  52.840  74.213  1.00 41.24           C  
ATOM   2038  OE1 GLU B  97      46.158  51.949  73.374  1.00 45.18           O  
ATOM   2039  OE2 GLU B  97      45.625  53.595  74.767  1.00 41.45           O  
ATOM   2040  N   LYS B  98      51.271  50.895  72.201  1.00 32.32           N  
ATOM   2041  CA  LYS B  98      52.003  49.691  71.791  1.00 32.87           C  
ATOM   2042  C   LYS B  98      53.487  49.804  72.084  1.00 32.49           C  
ATOM   2043  O   LYS B  98      54.133  48.811  72.409  1.00 33.14           O  
ATOM   2044  CB  LYS B  98      51.722  49.318  70.335  1.00 33.10           C  
ATOM   2045  CG  LYS B  98      50.295  48.752  70.157  1.00 33.37           C  
ATOM   2046  N   ILE B  99      54.027  51.006  72.015  1.00 32.49           N  
ATOM   2047  CA  ILE B  99      55.438  51.197  72.329  1.00 32.20           C  
ATOM   2048  C   ILE B  99      55.637  51.013  73.840  1.00 31.23           C  
ATOM   2049  O   ILE B  99      56.633  50.440  74.275  1.00 30.85           O  
ATOM   2050  CB  ILE B  99      55.925  52.613  72.014  1.00 32.98           C  
ATOM   2051  CG1 ILE B  99      55.593  53.003  70.567  1.00 36.11           C  
ATOM   2052  CG2 ILE B  99      57.441  52.746  72.342  1.00 31.81           C  
ATOM   2053  CD1 ILE B  99      55.988  51.961  69.516  1.00 37.77           C  
ATOM   2054  N   ALA B 100      54.720  51.585  74.620  1.00 28.97           N  
ATOM   2055  CA  ALA B 100      54.773  51.442  76.069  1.00 28.33           C  
ATOM   2056  C   ALA B 100      54.647  49.949  76.502  1.00 27.35           C  
ATOM   2057  O   ALA B 100      55.373  49.507  77.383  1.00 27.21           O  
ATOM   2058  CB  ALA B 100      53.721  52.265  76.721  1.00 26.75           C  
ATOM   2059  N   GLN B 101      53.693  49.225  75.906  1.00 26.59           N  
ATOM   2060  CA  GLN B 101      53.525  47.819  76.157  1.00 25.53           C  
ATOM   2061  C   GLN B 101      54.853  47.134  75.861  1.00 27.08           C  
ATOM   2062  O   GLN B 101      55.287  46.286  76.626  1.00 25.63           O  
ATOM   2063  CB  GLN B 101      52.405  47.231  75.304  1.00 24.62           C  
ATOM   2064  CG  GLN B 101      50.962  47.674  75.722  1.00 21.78           C  
ATOM   2065  CD  GLN B 101      49.881  47.316  74.760  1.00 24.30           C  
ATOM   2066  OE1 GLN B 101      50.152  46.707  73.734  1.00 26.68           O  
ATOM   2067  NE2 GLN B 101      48.589  47.673  75.099  1.00 22.67           N  
ATOM   2068  N   GLN B 102      55.490  47.500  74.758  1.00 28.89           N  
ATOM   2069  CA  GLN B 102      56.753  46.882  74.353  1.00 30.27           C  
ATOM   2070  C   GLN B 102      57.916  47.203  75.274  1.00 30.38           C  
ATOM   2071  O   GLN B 102      58.752  46.340  75.506  1.00 30.91           O  
ATOM   2072  CB  GLN B 102      57.123  47.267  72.924  1.00 30.91           C  
ATOM   2073  CG  GLN B 102      58.499  46.696  72.423  1.00 34.23           C  
ATOM   2074  CD  GLN B 102      58.559  45.157  72.476  1.00 38.74           C  
ATOM   2075  OE1 GLN B 102      57.532  44.479  72.233  1.00 41.74           O  
ATOM   2076  NE2 GLN B 102      59.743  44.599  72.819  1.00 33.02           N  
ATOM   2077  N   LYS B 103      58.012  48.451  75.751  1.00 30.05           N  
ATOM   2078  CA  LYS B 103      59.038  48.817  76.756  1.00 29.04           C  
ATOM   2079  C   LYS B 103      58.827  48.013  78.039  1.00 28.67           C  
ATOM   2080  O   LYS B 103      59.776  47.614  78.697  1.00 27.80           O  
ATOM   2081  CB  LYS B 103      58.963  50.303  77.139  1.00 29.44           C  
ATOM   2082  CG  LYS B 103      59.600  51.254  76.160  1.00 31.01           C  
ATOM   2083  CD  LYS B 103      59.401  52.674  76.574  1.00 30.42           C  
ATOM   2084  N   LEU B 104      57.576  47.795  78.422  1.00 27.32           N  
ATOM   2085  CA  LEU B 104      57.343  47.020  79.632  1.00 28.10           C  
ATOM   2086  C   LEU B 104      57.846  45.586  79.449  1.00 28.80           C  
ATOM   2087  O   LEU B 104      58.485  45.049  80.321  1.00 28.12           O  
ATOM   2088  CB  LEU B 104      55.849  46.963  79.937  1.00 28.39           C  
ATOM   2089  CG  LEU B 104      55.293  47.358  81.303  1.00 28.98           C  
ATOM   2090  CD1 LEU B 104      56.132  48.362  82.169  1.00 29.10           C  
ATOM   2091  CD2 LEU B 104      53.870  47.869  81.060  1.00 31.69           C  
ATOM   2092  N   VAL B 105      57.501  44.974  78.299  1.00 29.23           N  
ATOM   2093  CA  VAL B 105      57.972  43.636  77.917  1.00 28.68           C  
ATOM   2094  C   VAL B 105      59.489  43.524  77.980  1.00 28.25           C  
ATOM   2095  O   VAL B 105      60.022  42.499  78.450  1.00 27.47           O  
ATOM   2096  CB  VAL B 105      57.435  43.223  76.507  1.00 29.19           C  
ATOM   2097  CG1 VAL B 105      58.106  41.987  75.976  1.00 29.84           C  
ATOM   2098  CG2 VAL B 105      55.937  42.970  76.579  1.00 28.76           C  
ATOM   2099  N   ASP B 106      60.186  44.566  77.527  1.00 28.28           N  
ATOM   2100  CA  ASP B 106      61.645  44.527  77.428  1.00 27.68           C  
ATOM   2101  C   ASP B 106      62.305  44.569  78.809  1.00 27.77           C  
ATOM   2102  O   ASP B 106      63.538  44.279  78.939  1.00 25.55           O  
ATOM   2103  CB  ASP B 106      62.180  45.703  76.591  1.00 28.35           C  
ATOM   2104  CG  ASP B 106      61.819  45.603  75.101  1.00 30.06           C  
ATOM   2105  OD1 ASP B 106      61.436  44.499  74.621  1.00 28.32           O  
ATOM   2106  OD2 ASP B 106      61.937  46.652  74.412  1.00 31.00           O  
ATOM   2107  N   MET B 107      61.508  44.949  79.820  1.00 27.37           N  
ATOM   2108  CA  MET B 107      61.986  44.959  81.209  1.00 28.60           C  
ATOM   2109  C   MET B 107      62.022  43.574  81.855  1.00 27.31           C  
ATOM   2110  O   MET B 107      62.790  43.379  82.768  1.00 27.44           O  
ATOM   2111  CB  MET B 107      61.109  45.859  82.083  1.00 28.54           C  
ATOM   2112  CG  MET B 107      61.451  47.283  81.949  1.00 29.83           C  
ATOM   2113  SD  MET B 107      60.134  48.158  82.753  1.00 31.99           S  
ATOM   2114  CE  MET B 107      60.204  49.722  81.867  1.00 29.03           C  
ATOM   2115  N   VAL B 108      61.131  42.670  81.411  1.00 25.58           N  
ATOM   2116  CA  VAL B 108      60.993  41.339  81.977  1.00 24.30           C  
ATOM   2117  C   VAL B 108      62.316  40.635  81.714  1.00 23.90           C  
ATOM   2118  O   VAL B 108      62.866  40.736  80.626  1.00 23.32           O  
ATOM   2119  CB  VAL B 108      59.803  40.560  81.323  1.00 24.96           C  
ATOM   2120  CG1 VAL B 108      59.734  39.120  81.792  1.00 24.25           C  
ATOM   2121  CG2 VAL B 108      58.473  41.264  81.587  1.00 21.16           C  
ATOM   2122  N   PRO B 109      62.831  39.908  82.694  1.00 23.22           N  
ATOM   2123  CA  PRO B 109      64.067  39.171  82.372  1.00 23.11           C  
ATOM   2124  C   PRO B 109      63.872  38.241  81.128  1.00 23.91           C  
ATOM   2125  O   PRO B 109      62.747  37.749  80.856  1.00 22.65           O  
ATOM   2126  CB  PRO B 109      64.341  38.348  83.635  1.00 23.13           C  
ATOM   2127  CG  PRO B 109      63.648  39.086  84.739  1.00 21.00           C  
ATOM   2128  CD  PRO B 109      62.362  39.644  84.071  1.00 24.02           C  
ATOM   2129  N   GLU B 110      64.957  38.050  80.381  1.00 23.47           N  
ATOM   2130  CA  GLU B 110      64.904  37.373  79.101  1.00 25.08           C  
ATOM   2131  C   GLU B 110      64.290  35.983  79.227  1.00 25.27           C  
ATOM   2132  O   GLU B 110      63.416  35.638  78.462  1.00 24.34           O  
ATOM   2133  CB  GLU B 110      66.319  37.236  78.512  1.00 25.57           C  
ATOM   2134  CG  GLU B 110      66.269  36.844  77.040  1.00 28.92           C  
ATOM   2135  CD  GLU B 110      67.590  36.362  76.525  1.00 32.30           C  
ATOM   2136  OE1 GLU B 110      68.643  36.975  76.883  1.00 35.56           O  
ATOM   2137  OE2 GLU B 110      67.572  35.338  75.788  1.00 36.12           O  
ATOM   2138  N   GLU B 111      64.745  35.213  80.227  1.00 25.71           N  
ATOM   2139  CA  GLU B 111      64.302  33.818  80.427  1.00 26.76           C  
ATOM   2140  C   GLU B 111      62.800  33.754  80.762  1.00 26.72           C  
ATOM   2141  O   GLU B 111      62.189  32.692  80.700  1.00 28.09           O  
ATOM   2142  CB  GLU B 111      65.164  33.119  81.493  1.00 26.30           C  
ATOM   2143  CG  GLU B 111      64.950  33.665  82.923  1.00 27.34           C  
ATOM   2144  CD  GLU B 111      66.153  33.525  83.885  1.00 29.02           C  
ATOM   2145  OE1 GLU B 111      67.047  32.650  83.709  1.00 28.40           O  
ATOM   2146  OE2 GLU B 111      66.181  34.342  84.835  1.00 32.06           O  
ATOM   2147  N   LEU B 112      62.202  34.903  81.086  1.00 26.58           N  
ATOM   2148  CA  LEU B 112      60.801  34.981  81.410  1.00 26.03           C  
ATOM   2149  C   LEU B 112      59.969  35.638  80.342  1.00 26.66           C  
ATOM   2150  O   LEU B 112      58.752  35.648  80.444  1.00 25.95           O  
ATOM   2151  CB  LEU B 112      60.613  35.709  82.749  1.00 26.02           C  
ATOM   2152  CG  LEU B 112      61.303  34.962  83.909  1.00 25.14           C  
ATOM   2153  CD1 LEU B 112      61.224  35.674  85.219  1.00 26.01           C  
ATOM   2154  CD2 LEU B 112      60.737  33.592  84.049  1.00 23.47           C  
ATOM   2155  N   ARG B 113      60.620  36.195  79.328  1.00 26.84           N  
ATOM   2156  CA  ARG B 113      59.943  37.191  78.528  1.00 27.96           C  
ATOM   2157  C   ARG B 113      58.732  36.629  77.793  1.00 27.04           C  
ATOM   2158  O   ARG B 113      57.769  37.310  77.611  1.00 24.72           O  
ATOM   2159  CB  ARG B 113      60.897  37.832  77.538  1.00 28.37           C  
ATOM   2160  CG  ARG B 113      60.498  39.261  77.176  1.00 31.04           C  
ATOM   2161  CD  ARG B 113      61.660  39.979  76.528  1.00 32.93           C  
ATOM   2162  NE  ARG B 113      62.668  40.389  77.514  1.00 32.27           N  
ATOM   2163  CZ  ARG B 113      63.948  40.574  77.228  1.00 34.38           C  
ATOM   2164  NH1 ARG B 113      64.389  40.377  75.994  1.00 35.65           N  
ATOM   2165  NH2 ARG B 113      64.808  40.937  78.192  1.00 37.77           N  
ATOM   2166  N   ASP B 114      58.827  35.364  77.398  1.00 27.06           N  
ATOM   2167  CA  ASP B 114      57.843  34.729  76.562  1.00 28.25           C  
ATOM   2168  C   ASP B 114      56.590  34.352  77.381  1.00 28.43           C  
ATOM   2169  O   ASP B 114      55.548  34.064  76.807  1.00 28.51           O  
ATOM   2170  CB  ASP B 114      58.476  33.528  75.888  1.00 29.30           C  
ATOM   2171  CG  ASP B 114      59.125  32.619  76.884  1.00 33.35           C  
ATOM   2172  OD1 ASP B 114      60.378  32.763  77.159  1.00 39.46           O  
ATOM   2173  OD2 ASP B 114      58.351  31.821  77.451  1.00 34.06           O  
ATOM   2174  N   ILE B 115      56.693  34.399  78.713  1.00 27.34           N  
ATOM   2175  CA  ILE B 115      55.517  34.266  79.598  1.00 27.43           C  
ATOM   2176  C   ILE B 115      54.666  35.548  79.602  1.00 26.17           C  
ATOM   2177  O   ILE B 115      53.439  35.492  79.604  1.00 24.66           O  
ATOM   2178  CB  ILE B 115      55.933  34.034  81.110  1.00 27.41           C  
ATOM   2179  CG1 ILE B 115      56.988  32.928  81.289  1.00 29.99           C  
ATOM   2180  CG2 ILE B 115      54.729  33.778  81.960  1.00 26.96           C  
ATOM   2181  CD1 ILE B 115      56.563  31.642  80.814  1.00 33.01           C  
ATOM   2182  N   PHE B 116      55.364  36.684  79.650  1.00 26.22           N  
ATOM   2183  CA  PHE B 116      54.754  38.004  79.809  1.00 26.22           C  
ATOM   2184  C   PHE B 116      54.390  38.764  78.566  1.00 26.23           C  
ATOM   2185  O   PHE B 116      53.371  39.462  78.563  1.00 25.10           O  
ATOM   2186  CB  PHE B 116      55.646  38.889  80.724  1.00 25.98           C  
ATOM   2187  CG  PHE B 116      55.566  38.447  82.133  1.00 24.98           C  
ATOM   2188  CD1 PHE B 116      54.446  38.800  82.891  1.00 25.02           C  
ATOM   2189  CD2 PHE B 116      56.445  37.524  82.624  1.00 24.41           C  
ATOM   2190  CE1 PHE B 116      54.294  38.366  84.172  1.00 23.98           C  
ATOM   2191  CE2 PHE B 116      56.304  37.032  83.943  1.00 27.79           C  
ATOM   2192  CZ  PHE B 116      55.187  37.469  84.714  1.00 25.17           C  
ATOM   2193  N   ALA B 117      55.204  38.676  77.529  1.00 26.17           N  
ATOM   2194  CA  ALA B 117      54.844  39.332  76.251  1.00 26.41           C  
ATOM   2195  C   ALA B 117      53.366  39.073  75.824  1.00 26.69           C  
ATOM   2196  O   ALA B 117      52.647  39.988  75.447  1.00 24.63           O  
ATOM   2197  CB  ALA B 117      55.783  38.858  75.168  1.00 26.72           C  
ATOM   2198  N   PRO B 118      52.944  37.802  75.778  1.00 27.48           N  
ATOM   2199  CA  PRO B 118      51.558  37.568  75.327  1.00 27.89           C  
ATOM   2200  C   PRO B 118      50.464  38.017  76.286  1.00 28.46           C  
ATOM   2201  O   PRO B 118      49.270  37.833  75.973  1.00 28.25           O  
ATOM   2202  CB  PRO B 118      51.494  36.052  75.211  1.00 28.41           C  
ATOM   2203  CG  PRO B 118      52.630  35.527  76.046  1.00 28.09           C  
ATOM   2204  CD  PRO B 118      53.684  36.537  75.937  1.00 27.26           C  
ATOM   2205  N   LEU B 119      50.876  38.511  77.459  1.00 28.39           N  
ATOM   2206  CA  LEU B 119      49.969  39.060  78.433  1.00 27.90           C  
ATOM   2207  C   LEU B 119      49.911  40.563  78.303  1.00 28.56           C  
ATOM   2208  O   LEU B 119      48.822  41.155  78.428  1.00 28.80           O  
ATOM   2209  CB  LEU B 119      50.442  38.716  79.847  1.00 27.72           C  
ATOM   2210  CG  LEU B 119      50.651  37.245  80.203  1.00 28.26           C  
ATOM   2211  CD1 LEU B 119      50.953  37.132  81.690  1.00 25.42           C  
ATOM   2212  CD2 LEU B 119      49.432  36.380  79.762  1.00 27.68           C  
ATOM   2213  N   ILE B 120      51.066  41.198  78.103  1.00 27.95           N  
ATOM   2214  CA  ILE B 120      51.124  42.688  78.027  1.00 28.96           C  
ATOM   2215  C   ILE B 120      50.869  43.289  76.621  1.00 28.38           C  
ATOM   2216  O   ILE B 120      50.275  44.331  76.506  1.00 28.13           O  
ATOM   2217  CB  ILE B 120      52.506  43.200  78.524  1.00 29.00           C  
ATOM   2218  CG1 ILE B 120      52.710  42.891  80.013  1.00 29.83           C  
ATOM   2219  CG2 ILE B 120      52.695  44.709  78.288  1.00 30.09           C  
ATOM   2220  CD1 ILE B 120      54.195  42.843  80.362  1.00 30.77           C  
ATOM   2221  N   ASP B 121      51.360  42.632  75.573  1.00 28.51           N  
ATOM   2222  CA  ASP B 121      51.338  43.154  74.203  1.00 29.13           C  
ATOM   2223  C   ASP B 121      49.960  42.855  73.683  1.00 29.42           C  
ATOM   2224  O   ASP B 121      49.647  41.693  73.539  1.00 29.59           O  
ATOM   2225  CB  ASP B 121      52.455  42.433  73.392  1.00 29.37           C  
ATOM   2226  CG  ASP B 121      52.492  42.800  71.900  1.00 30.62           C  
ATOM   2227  OD1 ASP B 121      51.558  43.401  71.314  1.00 29.83           O  
ATOM   2228  OD2 ASP B 121      53.521  42.470  71.300  1.00 31.01           O  
ATOM   2229  N   GLU B 122      49.109  43.862  73.418  1.00 30.18           N  
ATOM   2230  CA  GLU B 122      47.695  43.544  72.972  1.00 30.57           C  
ATOM   2231  C   GLU B 122      47.636  42.938  71.553  1.00 28.86           C  
ATOM   2232  O   GLU B 122      46.590  42.459  71.149  1.00 27.83           O  
ATOM   2233  CB  GLU B 122      46.700  44.720  73.098  1.00 30.42           C  
ATOM   2234  CG  GLU B 122      45.196  44.283  73.170  1.00 33.32           C  
ATOM   2235  CD  GLU B 122      44.135  45.360  72.768  1.00 37.18           C  
ATOM   2236  OE1 GLU B 122      44.468  46.600  72.819  1.00 42.98           O  
ATOM   2237  OE2 GLU B 122      42.964  44.976  72.410  1.00 38.01           O  
ATOM   2238  N   HIS B 123      48.739  42.940  70.796  1.00 26.70           N  
ATOM   2239  CA  HIS B 123      48.746  42.184  69.548  1.00 26.30           C  
ATOM   2240  C   HIS B 123      48.494  40.669  69.802  1.00 25.74           C  
ATOM   2241  O   HIS B 123      48.067  39.993  68.895  1.00 23.68           O  
ATOM   2242  CB  HIS B 123      50.122  42.213  68.839  1.00 27.24           C  
ATOM   2243  CG  HIS B 123      50.503  43.493  68.171  1.00 27.84           C  
ATOM   2244  ND1 HIS B 123      49.755  44.082  67.171  1.00 32.84           N  
ATOM   2245  CD2 HIS B 123      51.635  44.241  68.284  1.00 30.74           C  
ATOM   2246  CE1 HIS B 123      50.378  45.169  66.739  1.00 31.64           C  
ATOM   2247  NE2 HIS B 123      51.527  45.281  67.389  1.00 31.09           N  
ATOM   2248  N   ALA B 124      48.921  40.123  70.960  1.00 24.86           N  
ATOM   2249  CA  ALA B 124      48.868  38.674  71.226  1.00 25.58           C  
ATOM   2250  C   ALA B 124      47.478  38.132  71.574  1.00 26.27           C  
ATOM   2251  O   ALA B 124      47.320  36.922  71.725  1.00 27.96           O  
ATOM   2252  CB  ALA B 124      49.865  38.301  72.351  1.00 25.43           C  
ATOM   2253  N   TYR B 125      46.480  39.001  71.719  1.00 26.16           N  
ATOM   2254  CA  TYR B 125      45.146  38.558  72.111  1.00 26.52           C  
ATOM   2255  C   TYR B 125      44.529  37.855  70.862  1.00 25.86           C  
ATOM   2256  O   TYR B 125      44.622  38.346  69.744  1.00 26.53           O  
ATOM   2257  CB  TYR B 125      44.306  39.764  72.672  1.00 28.17           C  
ATOM   2258  CG  TYR B 125      44.763  40.432  74.032  1.00 29.19           C  
ATOM   2259  CD1 TYR B 125      46.096  40.347  74.482  1.00 33.50           C  
ATOM   2260  CD2 TYR B 125      43.890  41.177  74.852  1.00 32.05           C  
ATOM   2261  CE1 TYR B 125      46.563  40.939  75.746  1.00 31.19           C  
ATOM   2262  CE2 TYR B 125      44.392  41.834  76.129  1.00 29.08           C  
ATOM   2263  CZ  TYR B 125      45.738  41.681  76.554  1.00 34.19           C  
ATOM   2264  OH  TYR B 125      46.360  42.251  77.784  1.00 32.08           O  
ATOM   2265  N   SER B 126      43.977  36.658  71.003  1.00 25.42           N  
ATOM   2266  CA  SER B 126      43.124  36.093  69.904  1.00 25.39           C  
ATOM   2267  C   SER B 126      41.911  36.972  69.646  1.00 25.47           C  
ATOM   2268  O   SER B 126      41.568  37.842  70.447  1.00 22.87           O  
ATOM   2269  CB  SER B 126      42.657  34.678  70.265  1.00 25.18           C  
ATOM   2270  OG  SER B 126      41.604  34.743  71.203  1.00 26.67           O  
ATOM   2271  N   ASP B 127      41.214  36.732  68.542  1.00 25.91           N  
ATOM   2272  CA  ASP B 127      39.983  37.473  68.262  1.00 26.40           C  
ATOM   2273  C   ASP B 127      38.972  37.356  69.422  1.00 25.33           C  
ATOM   2274  O   ASP B 127      38.354  38.335  69.811  1.00 24.23           O  
ATOM   2275  CB  ASP B 127      39.338  36.998  66.952  1.00 27.66           C  
ATOM   2276  CG  ASP B 127      39.848  37.757  65.731  1.00 31.94           C  
ATOM   2277  OD1 ASP B 127      41.092  37.895  65.563  1.00 32.59           O  
ATOM   2278  OD2 ASP B 127      38.982  38.214  64.917  1.00 39.38           O  
ATOM   2279  N   GLU B 128      38.808  36.163  69.967  1.00 24.82           N  
ATOM   2280  CA  GLU B 128      37.833  35.908  71.048  1.00 25.15           C  
ATOM   2281  C   GLU B 128      38.246  36.532  72.387  1.00 25.13           C  
ATOM   2282  O   GLU B 128      37.420  37.087  73.108  1.00 25.37           O  
ATOM   2283  CB  GLU B 128      37.644  34.392  71.198  1.00 25.51           C  
ATOM   2284  N   GLU B 129      39.536  36.425  72.709  1.00 24.97           N  
ATOM   2285  CA  GLU B 129      40.108  36.993  73.919  1.00 25.42           C  
ATOM   2286  C   GLU B 129      39.972  38.501  73.923  1.00 26.29           C  
ATOM   2287  O   GLU B 129      39.580  39.107  74.917  1.00 26.28           O  
ATOM   2288  CB  GLU B 129      41.594  36.603  74.010  1.00 26.00           C  
ATOM   2289  CG  GLU B 129      41.829  35.170  74.329  1.00 25.69           C  
ATOM   2290  CD  GLU B 129      43.264  34.773  74.241  1.00 28.79           C  
ATOM   2291  OE1 GLU B 129      44.065  35.510  73.568  1.00 25.94           O  
ATOM   2292  OE2 GLU B 129      43.596  33.702  74.855  1.00 31.90           O  
ATOM   2293  N   LYS B 130      40.237  39.092  72.759  1.00 27.01           N  
ATOM   2294  CA  LYS B 130      40.028  40.510  72.514  1.00 26.90           C  
ATOM   2295  C   LYS B 130      38.583  40.971  72.776  1.00 27.21           C  
ATOM   2296  O   LYS B 130      38.317  41.971  73.503  1.00 27.23           O  
ATOM   2297  CB  LYS B 130      40.425  40.775  71.053  1.00 26.87           C  
ATOM   2298  CG  LYS B 130      40.832  42.200  70.723  1.00 28.45           C  
ATOM   2299  CD  LYS B 130      41.594  42.322  69.369  1.00 28.61           C  
ATOM   2300  N   SER B 131      37.643  40.284  72.152  1.00 26.69           N  
ATOM   2301  CA  SER B 131      36.190  40.588  72.355  1.00 27.27           C  
ATOM   2302  C   SER B 131      35.826  40.576  73.849  1.00 27.15           C  
ATOM   2303  O   SER B 131      35.266  41.522  74.369  1.00 28.25           O  
ATOM   2304  CB  SER B 131      35.347  39.546  71.627  1.00 27.34           C  
ATOM   2305  OG  SER B 131      33.917  39.836  71.638  1.00 29.52           O  
ATOM   2306  N   LEU B 132      36.165  39.493  74.538  1.00 26.27           N  
ATOM   2307  CA  LEU B 132      35.832  39.340  75.936  1.00 24.84           C  
ATOM   2308  C   LEU B 132      36.423  40.429  76.849  1.00 24.49           C  
ATOM   2309  O   LEU B 132      35.707  40.965  77.676  1.00 23.11           O  
ATOM   2310  CB  LEU B 132      36.239  37.964  76.409  1.00 24.65           C  
ATOM   2311  CG  LEU B 132      35.315  36.879  75.865  1.00 25.32           C  
ATOM   2312  CD1 LEU B 132      35.961  35.519  75.863  1.00 25.06           C  
ATOM   2313  CD2 LEU B 132      34.002  36.866  76.622  1.00 28.12           C  
ATOM   2314  N   VAL B 133      37.720  40.733  76.695  1.00 23.31           N  
ATOM   2315  CA  VAL B 133      38.351  41.788  77.475  1.00 23.28           C  
ATOM   2316  C   VAL B 133      37.838  43.174  77.097  1.00 22.04           C  
ATOM   2317  O   VAL B 133      37.700  43.988  77.957  1.00 20.35           O  
ATOM   2318  CB  VAL B 133      39.834  41.803  77.310  1.00 23.43           C  
ATOM   2319  CG1 VAL B 133      40.444  42.993  78.010  1.00 24.71           C  
ATOM   2320  CG2 VAL B 133      40.492  40.490  77.812  1.00 23.77           C  
ATOM   2321  N   LYS B 134      37.530  43.439  75.823  1.00 22.88           N  
ATOM   2322  CA  LYS B 134      36.863  44.717  75.469  1.00 23.93           C  
ATOM   2323  C   LYS B 134      35.408  44.807  75.990  1.00 23.07           C  
ATOM   2324  O   LYS B 134      34.939  45.844  76.464  1.00 21.41           O  
ATOM   2325  CB  LYS B 134      36.956  44.978  73.955  1.00 24.35           C  
ATOM   2326  CG  LYS B 134      38.403  45.289  73.537  1.00 27.11           C  
ATOM   2327  CD  LYS B 134      38.524  45.942  72.179  1.00 30.58           C  
ATOM   2328  CE  LYS B 134      40.022  46.498  72.004  1.00 29.37           C  
ATOM   2329  NZ  LYS B 134      40.405  46.284  70.555  1.00 34.56           N  
ATOM   2330  N   GLN B 135      34.714  43.698  75.958  1.00 22.41           N  
ATOM   2331  CA  GLN B 135      33.352  43.631  76.604  1.00 21.68           C  
ATOM   2332  C   GLN B 135      33.464  43.920  78.131  1.00 22.21           C  
ATOM   2333  O   GLN B 135      32.754  44.752  78.694  1.00 20.62           O  
ATOM   2334  CB  GLN B 135      32.804  42.231  76.445  1.00 21.06           C  
ATOM   2335  CG  GLN B 135      32.206  41.927  75.049  1.00 24.59           C  
ATOM   2336  CD  GLN B 135      31.602  40.561  75.047  1.00 23.43           C  
ATOM   2337  OE1 GLN B 135      30.703  40.302  75.836  1.00 30.41           O  
ATOM   2338  NE2 GLN B 135      32.122  39.646  74.206  1.00 26.12           N  
ATOM   2339  N   ALA B 136      34.411  43.244  78.805  1.00 22.45           N  
ATOM   2340  CA  ALA B 136      34.625  43.516  80.248  1.00 23.64           C  
ATOM   2341  C   ALA B 136      34.956  44.982  80.549  1.00 23.43           C  
ATOM   2342  O   ALA B 136      34.422  45.578  81.486  1.00 22.92           O  
ATOM   2343  CB  ALA B 136      35.737  42.630  80.815  1.00 22.28           C  
ATOM   2344  N   ASP B 137      35.869  45.538  79.767  1.00 25.36           N  
ATOM   2345  CA  ASP B 137      36.346  46.918  79.984  1.00 25.09           C  
ATOM   2346  C   ASP B 137      35.164  47.918  79.862  1.00 25.19           C  
ATOM   2347  O   ASP B 137      34.993  48.822  80.692  1.00 23.52           O  
ATOM   2348  CB  ASP B 137      37.360  47.289  78.960  1.00 25.35           C  
ATOM   2349  CG  ASP B 137      38.078  48.566  79.338  1.00 27.78           C  
ATOM   2350  OD1 ASP B 137      38.912  48.528  80.238  1.00 29.43           O  
ATOM   2351  OD2 ASP B 137      37.804  49.607  78.742  1.00 28.11           O  
ATOM   2352  N   ALA B 138      34.367  47.736  78.817  1.00 24.48           N  
ATOM   2353  CA  ALA B 138      33.214  48.602  78.605  1.00 25.07           C  
ATOM   2354  C   ALA B 138      32.208  48.421  79.763  1.00 25.48           C  
ATOM   2355  O   ALA B 138      31.726  49.393  80.327  1.00 24.36           O  
ATOM   2356  CB  ALA B 138      32.590  48.333  77.295  1.00 24.59           C  
ATOM   2357  N   LEU B 139      31.980  47.178  80.180  1.00 26.50           N  
ATOM   2358  CA  LEU B 139      31.054  46.915  81.312  1.00 26.62           C  
ATOM   2359  C   LEU B 139      31.511  47.570  82.578  1.00 25.50           C  
ATOM   2360  O   LEU B 139      30.715  48.083  83.319  1.00 23.66           O  
ATOM   2361  CB  LEU B 139      30.942  45.421  81.616  1.00 26.76           C  
ATOM   2362  CG  LEU B 139      29.846  44.510  81.073  1.00 28.07           C  
ATOM   2363  CD1 LEU B 139      28.420  45.024  81.102  1.00 27.30           C  
ATOM   2364  CD2 LEU B 139      30.256  44.129  79.726  1.00 32.81           C  
ATOM   2365  N   CYS B 140      32.796  47.400  82.884  1.00 25.02           N  
ATOM   2366  CA  CYS B 140      33.402  48.032  84.063  1.00 25.53           C  
ATOM   2367  C   CYS B 140      33.260  49.554  84.044  1.00 25.89           C  
ATOM   2368  O   CYS B 140      32.854  50.158  85.028  1.00 25.32           O  
ATOM   2369  CB  CYS B 140      34.837  47.575  84.227  1.00 26.25           C  
ATOM   2370  SG  CYS B 140      34.842  45.838  84.808  1.00 29.96           S  
ATOM   2371  N   ALA B 141      33.463  50.153  82.886  1.00 25.12           N  
ATOM   2372  CA  ALA B 141      33.260  51.546  82.762  1.00 26.22           C  
ATOM   2373  C   ALA B 141      31.770  51.864  82.994  1.00 26.05           C  
ATOM   2374  O   ALA B 141      31.451  52.804  83.700  1.00 25.84           O  
ATOM   2375  CB  ALA B 141      33.726  52.018  81.392  1.00 27.07           C  
ATOM   2376  N   TYR B 142      30.867  51.048  82.460  1.00 25.48           N  
ATOM   2377  CA  TYR B 142      29.467  51.258  82.689  1.00 25.54           C  
ATOM   2378  C   TYR B 142      29.096  51.143  84.164  1.00 26.15           C  
ATOM   2379  O   TYR B 142      28.235  51.884  84.643  1.00 26.54           O  
ATOM   2380  CB  TYR B 142      28.718  50.197  81.940  1.00 26.58           C  
ATOM   2381  CG  TYR B 142      27.256  50.398  81.921  1.00 26.11           C  
ATOM   2382  CD1 TYR B 142      26.691  51.511  81.329  1.00 25.68           C  
ATOM   2383  CD2 TYR B 142      26.414  49.413  82.387  1.00 28.86           C  
ATOM   2384  CE1 TYR B 142      25.310  51.655  81.280  1.00 28.02           C  
ATOM   2385  CE2 TYR B 142      25.065  49.577  82.355  1.00 23.88           C  
ATOM   2386  CZ  TYR B 142      24.536  50.662  81.804  1.00 26.04           C  
ATOM   2387  OH  TYR B 142      23.187  50.718  81.780  1.00 30.95           O  
ATOM   2388  N   LEU B 143      29.729  50.203  84.859  1.00 25.19           N  
ATOM   2389  CA  LEU B 143      29.509  49.967  86.291  1.00 26.80           C  
ATOM   2390  C   LEU B 143      30.007  51.135  87.156  1.00 26.95           C  
ATOM   2391  O   LEU B 143      29.298  51.572  88.073  1.00 27.02           O  
ATOM   2392  CB  LEU B 143      30.121  48.640  86.767  1.00 26.37           C  
ATOM   2393  CG  LEU B 143      29.480  47.347  86.171  1.00 27.09           C  
ATOM   2394  CD1 LEU B 143      30.304  46.123  86.542  1.00 25.70           C  
ATOM   2395  CD2 LEU B 143      28.107  47.154  86.562  1.00 24.24           C  
ATOM   2396  N   LYS B 144      31.171  51.655  86.801  1.00 27.23           N  
ATOM   2397  CA  LYS B 144      31.679  52.917  87.375  1.00 27.05           C  
ATOM   2398  C   LYS B 144      30.637  54.028  87.302  1.00 26.47           C  
ATOM   2399  O   LYS B 144      30.358  54.692  88.319  1.00 26.05           O  
ATOM   2400  CB  LYS B 144      32.895  53.356  86.629  1.00 26.09           C  
ATOM   2401  CG  LYS B 144      33.401  54.738  86.977  1.00 28.05           C  
ATOM   2402  CD  LYS B 144      33.785  54.917  88.438  1.00 24.15           C  
ATOM   2403  CE  LYS B 144      34.337  56.313  88.673  1.00 24.31           C  
ATOM   2404  NZ  LYS B 144      34.668  56.631  90.136  1.00 24.08           N  
ATOM   2405  N   CYS B 145      30.082  54.241  86.109  1.00 25.77           N  
ATOM   2406  CA  CYS B 145      28.985  55.231  85.907  1.00 26.26           C  
ATOM   2407  C   CYS B 145      27.795  54.993  86.805  1.00 26.67           C  
ATOM   2408  O   CYS B 145      27.236  55.944  87.368  1.00 26.90           O  
ATOM   2409  CB  CYS B 145      28.504  55.222  84.454  1.00 27.27           C  
ATOM   2410  SG  CYS B 145      29.797  55.816  83.295  1.00 27.99           S  
ATOM   2411  N   LEU B 146      27.373  53.735  86.903  1.00 27.31           N  
ATOM   2412  CA  LEU B 146      26.224  53.341  87.740  1.00 28.15           C  
ATOM   2413  C   LEU B 146      26.479  53.609  89.241  1.00 28.39           C  
ATOM   2414  O   LEU B 146      25.571  54.023  89.947  1.00 25.61           O  
ATOM   2415  CB  LEU B 146      25.846  51.867  87.538  1.00 28.24           C  
ATOM   2416  CG  LEU B 146      25.281  51.437  86.178  1.00 28.86           C  
ATOM   2417  CD1 LEU B 146      25.037  49.947  86.187  1.00 28.40           C  
ATOM   2418  CD2 LEU B 146      24.006  52.171  85.840  1.00 28.77           C  
ATOM   2419  N   GLU B 147      27.721  53.370  89.704  1.00 28.49           N  
ATOM   2420  CA  GLU B 147      28.107  53.665  91.096  1.00 29.70           C  
ATOM   2421  C   GLU B 147      28.044  55.150  91.375  1.00 28.28           C  
ATOM   2422  O   GLU B 147      27.587  55.609  92.429  1.00 27.84           O  
ATOM   2423  CB  GLU B 147      29.538  53.152  91.392  1.00 29.94           C  
ATOM   2424  CG  GLU B 147      29.570  51.605  91.563  1.00 33.12           C  
ATOM   2425  CD  GLU B 147      30.986  50.967  91.617  1.00 34.22           C  
ATOM   2426  OE1 GLU B 147      32.048  51.678  91.661  1.00 42.43           O  
ATOM   2427  OE2 GLU B 147      31.028  49.702  91.577  1.00 43.31           O  
ATOM   2428  N   GLU B 148      28.540  55.913  90.423  1.00 27.58           N  
ATOM   2429  CA  GLU B 148      28.546  57.333  90.549  1.00 27.04           C  
ATOM   2430  C   GLU B 148      27.124  57.882  90.500  1.00 27.04           C  
ATOM   2431  O   GLU B 148      26.764  58.740  91.296  1.00 26.56           O  
ATOM   2432  CB  GLU B 148      29.470  57.955  89.491  1.00 28.19           C  
ATOM   2433  CG  GLU B 148      30.959  57.611  89.684  1.00 24.25           C  
ATOM   2434  CD  GLU B 148      31.627  58.444  90.753  1.00 26.79           C  
ATOM   2435  OE1 GLU B 148      31.176  59.599  91.008  1.00 32.76           O  
ATOM   2436  OE2 GLU B 148      32.629  57.971  91.329  1.00 22.95           O  
ATOM   2437  N   LEU B 149      26.289  57.364  89.618  1.00 27.45           N  
ATOM   2438  CA  LEU B 149      24.899  57.852  89.538  1.00 28.20           C  
ATOM   2439  C   LEU B 149      24.070  57.464  90.778  1.00 27.99           C  
ATOM   2440  O   LEU B 149      23.321  58.254  91.302  1.00 27.76           O  
ATOM   2441  CB  LEU B 149      24.229  57.336  88.273  1.00 28.23           C  
ATOM   2442  CG  LEU B 149      24.740  58.041  87.019  1.00 29.52           C  
ATOM   2443  CD1 LEU B 149      24.279  57.276  85.771  1.00 27.05           C  
ATOM   2444  CD2 LEU B 149      24.238  59.491  86.960  1.00 29.93           C  
ATOM   2445  N   ALA B 150      24.232  56.243  91.262  1.00 28.41           N  
ATOM   2446  CA  ALA B 150      23.677  55.870  92.557  1.00 28.28           C  
ATOM   2447  C   ALA B 150      24.166  56.761  93.709  1.00 29.29           C  
ATOM   2448  O   ALA B 150      23.431  56.996  94.644  1.00 28.67           O  
ATOM   2449  CB  ALA B 150      23.998  54.476  92.847  1.00 28.38           C  
ATOM   2450  N   ALA B 151      25.401  57.267  93.645  1.00 29.63           N  
ATOM   2451  CA  ALA B 151      25.889  58.214  94.644  1.00 29.77           C  
ATOM   2452  C   ALA B 151      25.385  59.616  94.393  1.00 30.46           C  
ATOM   2453  O   ALA B 151      25.839  60.578  95.050  1.00 31.23           O  
ATOM   2454  CB  ALA B 151      27.409  58.203  94.698  1.00 30.74           C  
ATOM   2455  N   GLY B 152      24.421  59.761  93.487  1.00 29.50           N  
ATOM   2456  CA  GLY B 152      23.878  61.066  93.167  1.00 29.31           C  
ATOM   2457  C   GLY B 152      24.708  62.004  92.276  1.00 30.01           C  
ATOM   2458  O   GLY B 152      24.442  63.187  92.245  1.00 30.00           O  
ATOM   2459  N   ASN B 153      25.674  61.477  91.519  1.00 30.17           N  
ATOM   2460  CA  ASN B 153      26.558  62.292  90.690  1.00 29.84           C  
ATOM   2461  C   ASN B 153      26.156  62.250  89.200  1.00 30.18           C  
ATOM   2462  O   ASN B 153      26.333  61.253  88.518  1.00 30.28           O  
ATOM   2463  CB  ASN B 153      28.004  61.806  90.913  1.00 28.81           C  
ATOM   2464  CG  ASN B 153      29.042  62.642  90.176  1.00 28.59           C  
ATOM   2465  OD1 ASN B 153      28.736  63.713  89.635  1.00 25.79           O  
ATOM   2466  ND2 ASN B 153      30.289  62.171  90.177  1.00 28.03           N  
ATOM   2467  N   ASN B 154      25.607  63.341  88.678  1.00 31.37           N  
ATOM   2468  CA  ASN B 154      25.114  63.352  87.290  1.00 30.87           C  
ATOM   2469  C   ASN B 154      26.173  63.731  86.281  1.00 30.30           C  
ATOM   2470  O   ASN B 154      25.899  63.839  85.100  1.00 29.77           O  
ATOM   2471  CB  ASN B 154      23.881  64.238  87.170  1.00 31.77           C  
ATOM   2472  CG  ASN B 154      22.657  63.573  87.795  1.00 33.31           C  
ATOM   2473  OD1 ASN B 154      22.330  62.419  87.480  1.00 36.58           O  
ATOM   2474  ND2 ASN B 154      22.019  64.267  88.716  1.00 35.99           N  
ATOM   2475  N   GLU B 155      27.403  63.887  86.735  1.00 30.10           N  
ATOM   2476  CA  GLU B 155      28.499  64.115  85.788  1.00 30.24           C  
ATOM   2477  C   GLU B 155      28.823  62.892  84.966  1.00 28.90           C  
ATOM   2478  O   GLU B 155      29.479  63.008  83.958  1.00 28.35           O  
ATOM   2479  CB  GLU B 155      29.760  64.660  86.488  1.00 30.29           C  
ATOM   2480  CG  GLU B 155      29.604  66.135  86.621  1.00 33.05           C  
ATOM   2481  CD  GLU B 155      30.797  66.858  87.125  1.00 34.75           C  
ATOM   2482  OE1 GLU B 155      31.916  66.347  86.996  1.00 35.46           O  
ATOM   2483  OE2 GLU B 155      30.578  67.985  87.616  1.00 38.68           O  
ATOM   2484  N   PHE B 156      28.377  61.735  85.430  1.00 28.52           N  
ATOM   2485  CA  PHE B 156      28.551  60.475  84.734  1.00 28.21           C  
ATOM   2486  C   PHE B 156      27.342  60.073  83.864  1.00 28.67           C  
ATOM   2487  O   PHE B 156      27.402  59.048  83.196  1.00 29.44           O  
ATOM   2488  CB  PHE B 156      28.902  59.374  85.745  1.00 27.26           C  
ATOM   2489  CG  PHE B 156      30.329  59.396  86.165  1.00 26.79           C  
ATOM   2490  CD1 PHE B 156      30.776  60.323  87.124  1.00 23.83           C  
ATOM   2491  CD2 PHE B 156      31.241  58.550  85.576  1.00 22.75           C  
ATOM   2492  CE1 PHE B 156      32.096  60.357  87.511  1.00 27.75           C  
ATOM   2493  CE2 PHE B 156      32.567  58.605  85.935  1.00 24.11           C  
ATOM   2494  CZ  PHE B 156      33.000  59.479  86.926  1.00 24.59           C  
ATOM   2495  N   LEU B 157      26.297  60.907  83.829  1.00 29.41           N  
ATOM   2496  CA  LEU B 157      25.094  60.646  83.048  1.00 30.44           C  
ATOM   2497  C   LEU B 157      25.357  60.531  81.540  1.00 30.75           C  
ATOM   2498  O   LEU B 157      24.945  59.554  80.900  1.00 30.51           O  
ATOM   2499  CB  LEU B 157      24.029  61.726  83.330  1.00 30.58           C  
ATOM   2500  CG  LEU B 157      22.644  61.322  82.854  1.00 31.80           C  
ATOM   2501  CD1 LEU B 157      22.272  59.905  83.340  1.00 34.75           C  
ATOM   2502  CD2 LEU B 157      21.578  62.335  83.246  1.00 32.70           C  
ATOM   2503  N   LEU B 158      26.053  61.528  80.991  1.00 31.15           N  
ATOM   2504  CA  LEU B 158      26.579  61.502  79.616  1.00 31.49           C  
ATOM   2505  C   LEU B 158      27.290  60.178  79.300  1.00 30.80           C  
ATOM   2506  O   LEU B 158      27.065  59.543  78.262  1.00 30.90           O  
ATOM   2507  CB  LEU B 158      27.613  62.657  79.396  1.00 31.98           C  
ATOM   2508  CG  LEU B 158      29.104  62.412  79.896  1.00 33.96           C  
ATOM   2509  CD1 LEU B 158      30.147  63.460  79.436  1.00 33.47           C  
ATOM   2510  CD2 LEU B 158      29.265  62.198  81.468  1.00 30.52           C  
ATOM   2511  N   ALA B 159      28.201  59.793  80.183  1.00 29.33           N  
ATOM   2512  CA  ALA B 159      29.102  58.677  79.906  1.00 29.15           C  
ATOM   2513  C   ALA B 159      28.309  57.377  79.913  1.00 28.86           C  
ATOM   2514  O   ALA B 159      28.588  56.449  79.142  1.00 28.15           O  
ATOM   2515  CB  ALA B 159      30.225  58.626  80.934  1.00 28.08           C  
ATOM   2516  N   LYS B 160      27.316  57.308  80.797  1.00 30.00           N  
ATOM   2517  CA  LYS B 160      26.498  56.109  80.920  1.00 30.85           C  
ATOM   2518  C   LYS B 160      25.805  55.883  79.582  1.00 30.74           C  
ATOM   2519  O   LYS B 160      25.908  54.804  78.965  1.00 30.13           O  
ATOM   2520  CB  LYS B 160      25.502  56.237  82.097  1.00 30.57           C  
ATOM   2521  CG  LYS B 160      24.673  54.974  82.333  1.00 32.43           C  
ATOM   2522  CD  LYS B 160      23.441  55.172  83.157  1.00 33.40           C  
ATOM   2523  CE  LYS B 160      22.258  55.644  82.353  1.00 38.09           C  
ATOM   2524  NZ  LYS B 160      21.320  54.545  82.020  1.00 38.73           N  
ATOM   2525  N   THR B 161      25.095  56.920  79.143  1.00 31.50           N  
ATOM   2526  CA  THR B 161      24.368  56.878  77.872  1.00 31.87           C  
ATOM   2527  C   THR B 161      25.280  56.441  76.706  1.00 32.11           C  
ATOM   2528  O   THR B 161      24.916  55.581  75.917  1.00 31.59           O  
ATOM   2529  CB  THR B 161      23.755  58.241  77.593  1.00 31.51           C  
ATOM   2530  OG1 THR B 161      22.766  58.492  78.587  1.00 32.45           O  
ATOM   2531  CG2 THR B 161      23.093  58.282  76.202  1.00 32.75           C  
ATOM   2532  N   ARG B 162      26.483  57.001  76.645  1.00 32.65           N  
ATOM   2533  CA  ARG B 162      27.455  56.649  75.603  1.00 32.60           C  
ATOM   2534  C   ARG B 162      27.970  55.222  75.713  1.00 32.71           C  
ATOM   2535  O   ARG B 162      28.165  54.535  74.699  1.00 32.14           O  
ATOM   2536  CB  ARG B 162      28.654  57.595  75.664  1.00 32.24           C  
ATOM   2537  N   LEU B 163      28.248  54.793  76.945  1.00 32.00           N  
ATOM   2538  CA  LEU B 163      28.541  53.379  77.168  1.00 30.86           C  
ATOM   2539  C   LEU B 163      27.357  52.460  76.802  1.00 30.60           C  
ATOM   2540  O   LEU B 163      27.586  51.389  76.296  1.00 29.19           O  
ATOM   2541  CB  LEU B 163      29.000  53.126  78.579  1.00 30.60           C  
ATOM   2542  CG  LEU B 163      30.460  53.568  78.786  1.00 30.38           C  
ATOM   2543  CD1 LEU B 163      30.662  53.779  80.245  1.00 30.40           C  
ATOM   2544  CD2 LEU B 163      31.427  52.568  78.208  1.00 31.28           C  
ATOM   2545  N   GLU B 164      26.118  52.855  77.036  1.00 30.22           N  
ATOM   2546  CA  GLU B 164      25.001  51.995  76.559  1.00 32.28           C  
ATOM   2547  C   GLU B 164      25.112  51.648  75.051  1.00 32.62           C  
ATOM   2548  O   GLU B 164      24.916  50.489  74.657  1.00 33.82           O  
ATOM   2549  CB  GLU B 164      23.616  52.566  76.952  1.00 32.78           C  
ATOM   2550  CG  GLU B 164      23.337  52.269  78.432  1.00 32.67           C  
ATOM   2551  CD  GLU B 164      22.230  53.078  79.067  1.00 34.89           C  
ATOM   2552  OE1 GLU B 164      21.601  53.923  78.382  1.00 39.65           O  
ATOM   2553  OE2 GLU B 164      21.965  52.851  80.270  1.00 32.49           O  
ATOM   2554  N   ALA B 165      25.496  52.624  74.227  1.00 33.06           N  
ATOM   2555  CA  ALA B 165      25.860  52.374  72.807  1.00 32.57           C  
ATOM   2556  C   ALA B 165      27.092  51.472  72.608  1.00 32.53           C  
ATOM   2557  O   ALA B 165      27.046  50.523  71.844  1.00 32.33           O  
ATOM   2558  CB  ALA B 165      26.090  53.716  72.090  1.00 33.31           C  
ATOM   2559  N   THR B 166      28.208  51.747  73.274  1.00 31.89           N  
ATOM   2560  CA  THR B 166      29.343  50.839  73.143  1.00 32.35           C  
ATOM   2561  C   THR B 166      28.986  49.353  73.452  1.00 32.45           C  
ATOM   2562  O   THR B 166      29.412  48.426  72.714  1.00 32.33           O  
ATOM   2563  CB  THR B 166      30.494  51.251  74.044  1.00 32.47           C  
ATOM   2564  OG1 THR B 166      30.731  52.656  73.909  1.00 33.94           O  
ATOM   2565  CG2 THR B 166      31.777  50.480  73.688  1.00 34.22           C  
ATOM   2566  N   LEU B 167      28.232  49.131  74.544  1.00 31.27           N  
ATOM   2567  CA  LEU B 167      27.879  47.777  74.987  1.00 30.51           C  
ATOM   2568  C   LEU B 167      27.000  47.051  73.934  1.00 31.83           C  
ATOM   2569  O   LEU B 167      27.234  45.864  73.622  1.00 30.57           O  
ATOM   2570  CB  LEU B 167      27.192  47.832  76.377  1.00 30.82           C  
ATOM   2571  CG  LEU B 167      28.073  48.251  77.596  1.00 27.51           C  
ATOM   2572  CD1 LEU B 167      27.272  48.432  78.899  1.00 26.44           C  
ATOM   2573  CD2 LEU B 167      29.120  47.185  77.780  1.00 27.90           C  
ATOM   2574  N   GLU B 168      26.020  47.766  73.363  1.00 31.58           N  
ATOM   2575  CA  GLU B 168      25.250  47.196  72.234  1.00 33.35           C  
ATOM   2576  C   GLU B 168      26.115  46.897  70.991  1.00 33.19           C  
ATOM   2577  O   GLU B 168      25.887  45.902  70.289  1.00 33.73           O  
ATOM   2578  CB  GLU B 168      24.068  48.080  71.834  1.00 33.14           C  
ATOM   2579  CG  GLU B 168      23.096  48.393  72.959  1.00 36.67           C  
ATOM   2580  CD  GLU B 168      22.020  47.306  73.257  1.00 41.94           C  
ATOM   2581  OE1 GLU B 168      21.582  46.542  72.344  1.00 46.44           O  
ATOM   2582  OE2 GLU B 168      21.568  47.265  74.436  1.00 44.44           O  
ATOM   2583  N   ALA B 169      27.086  47.754  70.703  1.00 33.47           N  
ATOM   2584  CA  ALA B 169      28.100  47.434  69.682  1.00 33.30           C  
ATOM   2585  C   ALA B 169      28.887  46.170  70.024  1.00 32.74           C  
ATOM   2586  O   ALA B 169      29.227  45.389  69.135  1.00 32.74           O  
ATOM   2587  CB  ALA B 169      29.077  48.613  69.470  1.00 33.43           C  
ATOM   2588  N   ARG B 170      29.181  45.949  71.296  1.00 32.79           N  
ATOM   2589  CA  ARG B 170      29.949  44.756  71.669  1.00 32.59           C  
ATOM   2590  C   ARG B 170      29.058  43.630  72.215  1.00 31.61           C  
ATOM   2591  O   ARG B 170      29.551  42.661  72.803  1.00 30.56           O  
ATOM   2592  CB  ARG B 170      31.050  45.133  72.652  1.00 33.05           C  
ATOM   2593  CG  ARG B 170      32.061  46.165  72.062  1.00 34.00           C  
ATOM   2594  CD  ARG B 170      33.082  46.662  73.080  1.00 32.49           C  
ATOM   2595  NE  ARG B 170      33.928  47.767  72.581  1.00 33.58           N  
ATOM   2596  CZ  ARG B 170      34.855  48.424  73.298  1.00 33.81           C  
ATOM   2597  NH1 ARG B 170      35.105  48.122  74.564  1.00 31.53           N  
ATOM   2598  NH2 ARG B 170      35.529  49.427  72.755  1.00 35.95           N  
ATOM   2599  N   ARG B 171      27.752  43.758  71.971  1.00 30.34           N  
ATOM   2600  CA  ARG B 171      26.742  42.816  72.435  1.00 29.54           C  
ATOM   2601  C   ARG B 171      27.137  41.339  72.182  1.00 29.08           C  
ATOM   2602  O   ARG B 171      27.658  40.988  71.097  1.00 29.67           O  
ATOM   2603  CB  ARG B 171      25.404  43.169  71.750  1.00 30.23           C  
ATOM   2604  CG  ARG B 171      24.185  42.468  72.295  1.00 31.41           C  
ATOM   2605  CD  ARG B 171      22.908  42.810  71.506  1.00 31.77           C  
ATOM   2606  N   SER B 172      26.932  40.499  73.199  1.00 26.80           N  
ATOM   2607  CA  SER B 172      27.012  39.033  73.081  1.00 26.02           C  
ATOM   2608  C   SER B 172      25.964  38.413  74.003  1.00 24.92           C  
ATOM   2609  O   SER B 172      25.346  39.101  74.830  1.00 22.72           O  
ATOM   2610  CB  SER B 172      28.409  38.498  73.427  1.00 25.26           C  
ATOM   2611  OG  SER B 172      28.808  38.859  74.756  1.00 25.95           O  
ATOM   2612  N   GLN B 173      25.783  37.112  73.867  1.00 23.08           N  
ATOM   2613  CA  GLN B 173      24.927  36.374  74.796  1.00 23.24           C  
ATOM   2614  C   GLN B 173      25.504  36.402  76.212  1.00 22.52           C  
ATOM   2615  O   GLN B 173      24.766  36.557  77.185  1.00 20.40           O  
ATOM   2616  CB  GLN B 173      24.692  34.926  74.307  1.00 22.67           C  
ATOM   2617  CG  GLN B 173      24.053  34.846  72.944  1.00 22.54           C  
ATOM   2618  CD  GLN B 173      23.298  33.524  72.778  1.00 24.96           C  
ATOM   2619  OE1 GLN B 173      23.750  32.596  72.105  1.00 25.25           O  
ATOM   2620  NE2 GLN B 173      22.176  33.428  73.435  1.00 22.64           N  
ATOM   2621  N   GLU B 174      26.819  36.291  76.339  1.00 23.09           N  
ATOM   2622  CA  GLU B 174      27.391  36.282  77.650  1.00 24.25           C  
ATOM   2623  C   GLU B 174      27.275  37.649  78.360  1.00 25.13           C  
ATOM   2624  O   GLU B 174      27.085  37.712  79.595  1.00 24.71           O  
ATOM   2625  CB  GLU B 174      28.842  35.739  77.643  1.00 26.36           C  
ATOM   2626  CG  GLU B 174      29.879  36.508  76.868  1.00 26.34           C  
ATOM   2627  CD  GLU B 174      30.000  36.087  75.406  1.00 29.33           C  
ATOM   2628  OE1 GLU B 174      29.086  35.392  74.888  1.00 29.75           O  
ATOM   2629  OE2 GLU B 174      31.005  36.515  74.771  1.00 31.80           O  
ATOM   2630  N   MET B 175      27.359  38.735  77.589  1.00 25.15           N  
ATOM   2631  CA  MET B 175      27.098  40.071  78.128  1.00 25.40           C  
ATOM   2632  C   MET B 175      25.633  40.249  78.512  1.00 25.08           C  
ATOM   2633  O   MET B 175      25.318  40.862  79.560  1.00 23.95           O  
ATOM   2634  CB  MET B 175      27.493  41.162  77.136  1.00 24.85           C  
ATOM   2635  CG  MET B 175      26.986  42.594  77.535  1.00 26.98           C  
ATOM   2636  SD  MET B 175      27.328  43.848  76.270  1.00 30.22           S  
ATOM   2637  CE  MET B 175      29.099  43.672  76.062  1.00 29.20           C  
ATOM   2638  N   ASP B 176      24.735  39.782  77.644  1.00 24.37           N  
ATOM   2639  CA  ASP B 176      23.329  39.862  77.934  1.00 25.30           C  
ATOM   2640  C   ASP B 176      23.060  39.139  79.265  1.00 24.98           C  
ATOM   2641  O   ASP B 176      22.446  39.680  80.158  1.00 24.33           O  
ATOM   2642  CB  ASP B 176      22.461  39.261  76.815  1.00 26.48           C  
ATOM   2643  CG  ASP B 176      22.512  40.063  75.458  1.00 29.14           C  
ATOM   2644  OD1 ASP B 176      22.516  41.299  75.417  1.00 32.19           O  
ATOM   2645  OD2 ASP B 176      22.487  39.412  74.386  1.00 35.96           O  
ATOM   2646  N   TYR B 177      23.546  37.921  79.417  1.00 24.74           N  
ATOM   2647  CA  TYR B 177      23.364  37.193  80.680  1.00 25.63           C  
ATOM   2648  C   TYR B 177      23.924  38.066  81.817  1.00 25.90           C  
ATOM   2649  O   TYR B 177      23.300  38.273  82.869  1.00 24.02           O  
ATOM   2650  CB  TYR B 177      24.136  35.867  80.613  1.00 27.02           C  
ATOM   2651  CG  TYR B 177      24.028  35.011  81.865  1.00 27.72           C  
ATOM   2652  CD1 TYR B 177      24.805  35.303  83.007  1.00 32.38           C  
ATOM   2653  CD2 TYR B 177      23.204  33.950  81.916  1.00 27.23           C  
ATOM   2654  CE1 TYR B 177      24.716  34.526  84.149  1.00 32.05           C  
ATOM   2655  CE2 TYR B 177      23.076  33.177  83.075  1.00 30.85           C  
ATOM   2656  CZ  TYR B 177      23.836  33.463  84.172  1.00 28.90           C  
ATOM   2657  OH  TYR B 177      23.723  32.690  85.310  1.00 32.86           O  
ATOM   2658  N   PHE B 178      25.105  38.626  81.584  1.00 25.86           N  
ATOM   2659  CA  PHE B 178      25.765  39.376  82.620  1.00 26.22           C  
ATOM   2660  C   PHE B 178      24.942  40.602  83.047  1.00 27.05           C  
ATOM   2661  O   PHE B 178      24.707  40.814  84.233  1.00 26.80           O  
ATOM   2662  CB  PHE B 178      27.165  39.843  82.196  1.00 27.16           C  
ATOM   2663  CG  PHE B 178      27.949  40.392  83.335  1.00 25.83           C  
ATOM   2664  CD1 PHE B 178      27.821  41.733  83.706  1.00 28.41           C  
ATOM   2665  CD2 PHE B 178      28.755  39.561  84.083  1.00 24.50           C  
ATOM   2666  CE1 PHE B 178      28.531  42.245  84.780  1.00 22.82           C  
ATOM   2667  CE2 PHE B 178      29.479  40.065  85.179  1.00 26.68           C  
ATOM   2668  CZ  PHE B 178      29.339  41.422  85.522  1.00 26.11           C  
ATOM   2669  N   MET B 179      24.474  41.357  82.062  1.00 27.60           N  
ATOM   2670  CA  MET B 179      23.682  42.544  82.293  1.00 28.62           C  
ATOM   2671  C   MET B 179      22.373  42.171  83.039  1.00 28.20           C  
ATOM   2672  O   MET B 179      21.919  42.887  83.898  1.00 28.18           O  
ATOM   2673  CB  MET B 179      23.303  43.179  80.955  1.00 30.23           C  
ATOM   2674  CG  MET B 179      24.449  43.803  80.149  1.00 31.97           C  
ATOM   2675  SD  MET B 179      24.823  45.438  80.728  1.00 40.79           S  
ATOM   2676  CE  MET B 179      23.313  46.339  80.350  1.00 40.57           C  
ATOM   2677  N   GLU B 180      21.790  41.029  82.710  1.00 26.19           N  
ATOM   2678  CA  GLU B 180      20.468  40.664  83.254  1.00 26.37           C  
ATOM   2679  C   GLU B 180      20.565  40.230  84.725  1.00 25.95           C  
ATOM   2680  O   GLU B 180      19.657  40.450  85.481  1.00 23.76           O  
ATOM   2681  CB  GLU B 180      19.897  39.531  82.420  1.00 25.92           C  
ATOM   2682  CG  GLU B 180      18.430  39.292  82.619  1.00 27.63           C  
ATOM   2683  N   ILE B 181      21.703  39.650  85.117  1.00 25.37           N  
ATOM   2684  CA  ILE B 181      21.821  38.894  86.348  1.00 25.79           C  
ATOM   2685  C   ILE B 181      22.676  39.635  87.395  1.00 26.63           C  
ATOM   2686  O   ILE B 181      22.353  39.644  88.575  1.00 26.45           O  
ATOM   2687  CB  ILE B 181      22.438  37.501  86.051  1.00 26.84           C  
ATOM   2688  CG1 ILE B 181      21.512  36.672  85.174  1.00 26.04           C  
ATOM   2689  CG2 ILE B 181      22.804  36.724  87.345  1.00 28.17           C  
ATOM   2690  CD1 ILE B 181      20.257  36.183  85.858  1.00 30.38           C  
ATOM   2691  N   PHE B 182      23.747  40.284  86.968  1.00 26.22           N  
ATOM   2692  CA  PHE B 182      24.616  40.933  87.904  1.00 26.68           C  
ATOM   2693  C   PHE B 182      24.536  42.474  87.968  1.00 27.62           C  
ATOM   2694  O   PHE B 182      24.958  43.054  88.972  1.00 27.93           O  
ATOM   2695  CB  PHE B 182      26.022  40.526  87.555  1.00 26.63           C  
ATOM   2696  CG  PHE B 182      26.332  39.087  87.812  1.00 24.81           C  
ATOM   2697  CD1 PHE B 182      26.176  38.539  89.077  1.00 24.13           C  
ATOM   2698  CD2 PHE B 182      26.905  38.317  86.825  1.00 25.92           C  
ATOM   2699  CE1 PHE B 182      26.562  37.218  89.342  1.00 27.42           C  
ATOM   2700  CE2 PHE B 182      27.286  36.993  87.079  1.00 26.07           C  
ATOM   2701  CZ  PHE B 182      27.121  36.446  88.343  1.00 25.80           C  
ATOM   2702  N   VAL B 183      24.022  43.131  86.925  1.00 27.90           N  
ATOM   2703  CA  VAL B 183      24.073  44.605  86.843  1.00 29.82           C  
ATOM   2704  C   VAL B 183      22.971  45.367  87.639  1.00 30.60           C  
ATOM   2705  O   VAL B 183      23.228  46.468  88.144  1.00 30.33           O  
ATOM   2706  CB  VAL B 183      24.162  45.104  85.334  1.00 29.69           C  
ATOM   2707  CG1 VAL B 183      23.947  46.670  85.197  1.00 30.03           C  
ATOM   2708  CG2 VAL B 183      25.468  44.651  84.696  1.00 30.85           C  
ATOM   2709  N   PRO B 184      21.739  44.807  87.735  1.00 31.78           N  
ATOM   2710  CA  PRO B 184      20.670  45.509  88.453  1.00 31.99           C  
ATOM   2711  C   PRO B 184      20.924  45.845  89.917  1.00 32.49           C  
ATOM   2712  O   PRO B 184      20.356  46.803  90.412  1.00 32.29           O  
ATOM   2713  CB  PRO B 184      19.471  44.546  88.335  1.00 32.81           C  
ATOM   2714  CG  PRO B 184      19.771  43.739  87.060  1.00 32.16           C  
ATOM   2715  CD  PRO B 184      21.270  43.532  87.152  1.00 31.67           C  
ATOM   2716  N   SER B 185      21.736  45.036  90.599  1.00 33.81           N  
ATOM   2717  CA  SER B 185      22.221  45.305  91.955  1.00 34.74           C  
ATOM   2718  C   SER B 185      23.192  46.501  91.994  1.00 35.74           C  
ATOM   2719  O   SER B 185      23.470  47.045  93.073  1.00 36.31           O  
ATOM   2720  CB  SER B 185      22.944  44.086  92.533  1.00 34.90           C  
ATOM   2721  OG  SER B 185      22.102  42.969  92.615  1.00 33.90           O  
ATOM   2722  N   PHE B 186      23.694  46.922  90.834  1.00 35.79           N  
ATOM   2723  CA  PHE B 186      24.337  48.227  90.735  1.00 36.63           C  
ATOM   2724  C   PHE B 186      23.333  49.384  90.516  1.00 38.46           C  
ATOM   2725  O   PHE B 186      23.618  50.512  90.872  1.00 38.35           O  
ATOM   2726  CB  PHE B 186      25.366  48.218  89.623  1.00 35.71           C  
ATOM   2727  CG  PHE B 186      26.510  47.289  89.856  1.00 33.89           C  
ATOM   2728  CD1 PHE B 186      26.380  45.930  89.650  1.00 31.44           C  
ATOM   2729  CD2 PHE B 186      27.738  47.783  90.270  1.00 32.15           C  
ATOM   2730  CE1 PHE B 186      27.477  45.091  89.815  1.00 31.35           C  
ATOM   2731  CE2 PHE B 186      28.827  46.950  90.465  1.00 30.49           C  
ATOM   2732  CZ  PHE B 186      28.707  45.606  90.228  1.00 33.19           C  
ATOM   2733  N   HIS B 187      22.197  49.069  89.882  1.00 40.34           N  
ATOM   2734  CA  HIS B 187      20.979  49.926  89.747  1.00 41.60           C  
ATOM   2735  C   HIS B 187      20.872  50.731  88.448  1.00 41.62           C  
ATOM   2736  O   HIS B 187      20.243  50.247  87.501  1.00 42.71           O  
ATOM   2737  CB  HIS B 187      20.709  50.792  90.981  1.00 41.87           C  
ATOM   2738  CG  HIS B 187      20.470  49.988  92.216  1.00 42.97           C  
ATOM   2739  ND1 HIS B 187      21.438  49.798  93.178  1.00 45.10           N  
ATOM   2740  CD2 HIS B 187      19.391  49.281  92.624  1.00 44.24           C  
ATOM   2741  CE1 HIS B 187      20.955  49.030  94.141  1.00 45.17           C  
ATOM   2742  NE2 HIS B 187      19.717  48.696  93.826  1.00 44.16           N  
TER    2743      HIS B 187                                                      
END
MOLECULE T0470.pdb
ATOM      1  N   THR     2      54.420  27.522  88.035  1.00 67.73           N  
ATOM      2  CA  THR     2      53.108  27.380  87.344  1.00 69.65           C  
ATOM      3  C   THR     2      52.525  28.722  86.889  1.00 69.97           C  
ATOM      4  O   THR     2      52.981  29.793  87.306  1.00 70.58           O  
ATOM      5  CB  THR     2      52.070  26.669  88.248  1.00 70.47           C  
ATOM      6  OG1 THR     2      50.847  26.474  87.525  1.00 71.89           O  
ATOM      7  CG2 THR     2      51.777  27.494  89.491  1.00 72.01           C  
ATOM      8  N   LYS     3      51.513  28.656  86.023  1.00 69.74           N  
ATOM      9  CA  LYS     3      50.861  29.849  85.484  1.00 69.53           C  
ATOM     10  C   LYS     3      50.268  30.737  86.573  1.00 70.20           C  
ATOM     11  O   LYS     3      50.510  31.945  86.591  1.00 69.16           O  
ATOM     12  CB  LYS     3      49.782  29.428  84.482  1.00 67.78           C  
ATOM     13  CG  LYS     3      50.303  29.361  83.052  1.00 68.14           C  
ATOM     14  CD  LYS     3      49.618  28.289  82.210  1.00 68.04           C  
ATOM     15  CE  LYS     3      49.960  28.461  80.732  1.00 67.69           C  
ATOM     16  NZ  LYS     3      51.397  28.805  80.520  1.00 68.33           N  
ATOM     17  N   GLN     4      49.505  30.130  87.481  1.00 70.53           N  
ATOM     18  CA  GLN     4      48.886  30.864  88.569  1.00 70.32           C  
ATOM     19  C   GLN     4      49.929  31.629  89.343  1.00 70.52           C  
ATOM     20  O   GLN     4      49.650  32.691  89.886  1.00 70.49           O  
ATOM     21  CB  GLN     4      48.149  29.918  89.517  1.00 70.74           C  
ATOM     22  CG  GLN     4      47.408  30.606  90.679  1.00 69.51           C  
ATOM     23  CD  GLN     4      46.205  31.420  90.223  1.00 68.71           C  
ATOM     24  OE1 GLN     4      45.399  30.969  89.405  1.00 68.36           O  
ATOM     25  NE2 GLN     4      46.064  32.617  90.776  1.00 68.07           N  
ATOM     26  N   GLU     5      51.137  31.100  89.418  1.00 72.17           N  
ATOM     27  CA  GLU     5      52.161  31.829  90.151  1.00 74.75           C  
ATOM     28  C   GLU     5      52.585  33.043  89.329  1.00 74.42           C  
ATOM     29  O   GLU     5      53.116  34.009  89.867  1.00 74.73           O  
ATOM     30  CB  GLU     5      53.366  30.926  90.458  1.00 76.64           C  
ATOM     31  CG  GLU     5      53.047  29.773  91.424  1.00 78.98           C  
ATOM     32  CD  GLU     5      54.280  28.980  91.856  1.00 79.51           C  
ATOM     33  OE1 GLU     5      55.222  29.593  92.417  1.00 79.22           O  
ATOM     34  OE2 GLU     5      54.298  27.744  91.649  1.00 79.24           O  
ATOM     35  N   LYS     6      52.328  32.993  88.026  1.00 73.80           N  
ATOM     36  CA  LYS     6      52.683  34.095  87.143  1.00 73.49           C  
ATOM     37  C   LYS     6      51.562  35.126  87.171  1.00 72.47           C  
ATOM     38  O   LYS     6      51.789  36.313  87.420  1.00 71.47           O  
ATOM     39  CB  LYS     6      52.922  33.561  85.727  1.00 75.15           C  
ATOM     40  CG  LYS     6      53.997  32.466  85.693  1.00 76.88           C  
ATOM     41  CD  LYS     6      54.449  32.067  84.283  1.00 76.71           C  
ATOM     42  CE  LYS     6      55.567  31.015  84.358  1.00 75.99           C  
ATOM     43  NZ  LYS     6      56.007  30.494  83.030  1.00 75.46           N  
ATOM     44  N   ILE     7      50.344  34.662  86.925  1.00 72.48           N  
ATOM     45  CA  ILE     7      49.190  35.538  86.961  1.00 72.23           C  
ATOM     46  C   ILE     7      49.228  36.208  88.335  1.00 72.32           C  
ATOM     47  O   ILE     7      48.704  37.300  88.502  1.00 73.73           O  
ATOM     48  CB  ILE     7      47.868  34.730  86.768  1.00 70.53           C  
ATOM     49  CG1 ILE     7      46.677  35.665  86.607  1.00 71.42           C  
ATOM     50  CG2 ILE     7      47.591  33.867  87.974  1.00 69.54           C  
ATOM     51  CD1 ILE     7      45.974  36.012  87.908  1.00 69.78           C  
ATOM     52  N   GLU     8      49.867  35.568  89.314  1.00 73.67           N  
ATOM     53  CA  GLU     8      49.958  36.157  90.650  1.00 74.45           C  
ATOM     54  C   GLU     8      51.022  37.243  90.738  1.00 74.03           C  
ATOM     55  O   GLU     8      50.756  38.341  91.224  1.00 75.27           O  
ATOM     56  CB  GLU     8      50.273  35.100  91.719  1.00 73.53           C  
ATOM     57  CG  GLU     8      49.055  34.457  92.367  1.00 75.26           C  
ATOM     58  CD  GLU     8      49.396  33.705  93.653  1.00 76.05           C  
ATOM     59  OE1 GLU     8      48.502  33.009  94.197  1.00 73.33           O  
ATOM     60  OE2 GLU     8      50.553  33.824  94.123  1.00 76.36           O  
ATOM     61  N   LYS     9      52.229  36.936  90.275  1.00 73.00           N  
ATOM     62  CA  LYS     9      53.322  37.894  90.358  1.00 72.14           C  
ATOM     63  C   LYS     9      53.089  39.085  89.445  1.00 72.09           C  
ATOM     64  O   LYS     9      53.622  40.178  89.668  1.00 70.96           O  
ATOM     65  CB  LYS     9      54.642  37.225  90.000  1.00 72.09           C  
ATOM     66  CG  LYS     9      55.819  37.867  90.700  1.00 72.17           C  
ATOM     67  CD  LYS     9      55.863  37.465  92.169  1.00 70.32           C  
ATOM     68  CE  LYS     9      56.739  38.411  92.991  1.00 69.14           C  
ATOM     69  NZ  LYS     9      56.059  39.713  93.280  1.00 66.21           N  
ATOM     70  N   THR    10      52.286  38.858  88.411  1.00 72.36           N  
ATOM     71  CA  THR    10      51.944  39.896  87.451  1.00 71.97           C  
ATOM     72  C   THR    10      50.982  40.874  88.183  1.00 71.19           C  
ATOM     73  O   THR    10      51.018  42.083  87.945  1.00 70.11           O  
ATOM     74  CB  THR    10      51.312  39.235  86.168  1.00 71.23           C  
ATOM     75  OG1 THR    10      51.643  40.001  85.000  1.00 69.88           O  
ATOM     76  CG2 THR    10      49.812  39.128  86.308  1.00 71.51           C  
ATOM     77  N   ILE    11      50.161  40.336  89.093  1.00 70.44           N  
ATOM     78  CA  ILE    11      49.219  41.124  89.904  1.00 69.72           C  
ATOM     79  C   ILE    11      50.035  42.057  90.766  1.00 71.16           C  
ATOM     80  O   ILE    11      49.551  43.080  91.257  1.00 71.13           O  
ATOM     81  CB  ILE    11      48.388  40.242  90.871  1.00 68.77           C  
ATOM     82  CG1 ILE    11      47.388  39.417  90.081  1.00 67.51           C  
ATOM     83  CG2 ILE    11      47.668  41.108  91.920  1.00 66.60           C  
ATOM     84  CD1 ILE    11      46.560  38.495  90.938  1.00 66.89           C  
ATOM     85  N   THR    12      51.283  41.681  90.970  1.00 72.51           N  
ATOM     86  CA  THR    12      52.155  42.500  91.759  1.00 73.91           C  
ATOM     87  C   THR    12      52.815  43.476  90.813  1.00 74.94           C  
ATOM     88  O   THR    12      53.055  44.622  91.173  1.00 75.82           O  
ATOM     89  CB  THR    12      53.201  41.642  92.473  1.00 75.30           C  
ATOM     90  OG1 THR    12      52.538  40.717  93.350  1.00 75.75           O  
ATOM     91  CG2 THR    12      54.145  42.526  93.284  1.00 76.45           C  
ATOM     92  N   PHE    13      53.071  43.034  89.586  1.00 75.86           N  
ATOM     93  CA  PHE    13      53.711  43.899  88.592  1.00 77.87           C  
ATOM     94  C   PHE    13      52.903  45.169  88.303  1.00 79.87           C  
ATOM     95  O   PHE    13      53.467  46.265  88.185  1.00 80.16           O  
ATOM     96  CB  PHE    13      53.940  43.127  87.291  1.00 76.60           C  
ATOM     97  CG  PHE    13      54.523  43.959  86.180  1.00 75.56           C  
ATOM     98  CD1 PHE    13      53.743  44.325  85.086  1.00 75.53           C  
ATOM     99  CD2 PHE    13      55.856  44.359  86.216  1.00 74.71           C  
ATOM    100  CE1 PHE    13      54.279  45.077  84.036  1.00 73.94           C  
ATOM    101  CE2 PHE    13      56.403  45.111  85.172  1.00 73.82           C  
ATOM    102  CZ  PHE    13      55.608  45.468  84.079  1.00 73.79           C  
ATOM    103  N   VAL    14      51.587  45.018  88.190  1.00 80.78           N  
ATOM    104  CA  VAL    14      50.717  46.147  87.927  1.00 81.21           C  
ATOM    105  C   VAL    14      50.497  46.914  89.220  1.00 83.76           C  
ATOM    106  O   VAL    14      50.582  48.134  89.241  1.00 85.04           O  
ATOM    107  CB  VAL    14      49.372  45.672  87.361  1.00 79.40           C  
ATOM    108  CG1 VAL    14      48.451  46.851  87.134  1.00 78.11           C  
ATOM    109  CG2 VAL    14      49.604  44.926  86.069  1.00 78.07           C  
ATOM    110  N   LYS    15      50.238  46.195  90.305  1.00 86.53           N  
ATOM    111  CA  LYS    15      50.010  46.838  91.594  1.00 89.42           C  
ATOM    112  C   LYS    15      51.136  47.797  91.974  1.00 92.04           C  
ATOM    113  O   LYS    15      50.909  48.804  92.650  1.00 91.87           O  
ATOM    114  CB  LYS    15      49.840  45.780  92.686  1.00 88.26           C  
ATOM    115  CG  LYS    15      48.424  45.229  92.793  1.00 87.49           C  
ATOM    116  CD  LYS    15      47.453  46.298  93.274  1.00 87.53           C  
ATOM    117  CE  LYS    15      46.640  45.797  94.462  1.00 87.66           C  
ATOM    118  NZ  LYS    15      45.830  46.861  95.134  1.00 86.79           N  
ATOM    119  N   HIS    16      52.344  47.486  91.518  1.00 95.20           N  
ATOM    120  CA  HIS    16      53.515  48.301  91.808  1.00 98.70           C  
ATOM    121  C   HIS    16      53.665  49.487  90.861  1.00 99.11           C  
ATOM    122  O   HIS    16      53.684  50.642  91.292  1.00 99.40           O  
ATOM    123  CB  HIS    16      54.783  47.437  91.756  1.00101.86           C  
ATOM    124  CG  HIS    16      55.481  47.306  93.076  1.00105.49           C  
ATOM    125  ND1 HIS    16      54.917  46.664  94.161  1.00106.97           N  
ATOM    126  CD2 HIS    16      56.685  47.762  93.496  1.00106.64           C  
ATOM    127  CE1 HIS    16      55.743  46.731  95.190  1.00107.92           C  
ATOM    128  NE2 HIS    16      56.824  47.394  94.814  1.00107.88           N  
ATOM    129  N   ILE    17      53.778  49.202  89.569  1.00 99.51           N  
ATOM    130  CA  ILE    17      53.945  50.257  88.577  1.00100.14           C  
ATOM    131  C   ILE    17      52.919  51.375  88.778  1.00100.65           C  
ATOM    132  O   ILE    17      53.162  52.521  88.400  1.00101.20           O  
ATOM    133  CB  ILE    17      53.827  49.695  87.139  1.00 99.75           C  
ATOM    134  CG1 ILE    17      54.322  50.731  86.138  1.00 99.34           C  
ATOM    135  CG2 ILE    17      52.386  49.319  86.835  1.00 99.68           C  
ATOM    136  CD1 ILE    17      55.770  51.105  86.326  1.00 99.26           C  
ATOM    137  N   LEU    18      51.780  51.040  89.380  1.00101.00           N  
ATOM    138  CA  LEU    18      50.732  52.024  89.637  1.00100.89           C  
ATOM    139  C   LEU    18      51.122  52.918  90.806  1.00101.50           C  
ATOM    140  O   LEU    18      50.451  53.906  91.094  1.00102.48           O  
ATOM    141  CB  LEU    18      49.396  51.330  89.947  1.00 99.29           C  
ATOM    142  CG  LEU    18      48.439  50.949  88.809  1.00 97.40           C  
ATOM    143  CD1 LEU    18      47.333  50.051  89.330  1.00 96.41           C  
ATOM    144  CD2 LEU    18      47.845  52.200  88.206  1.00 96.79           C  
ATOM    145  N   GLU    19      52.203  52.573  91.489  1.00101.98           N  
ATOM    146  CA  GLU    19      52.628  53.378  92.618  1.00103.29           C  
ATOM    147  C   GLU    19      53.678  54.398  92.190  1.00104.06           C  
ATOM    148  O   GLU    19      53.668  55.543  92.653  1.00104.54           O  
ATOM    149  CB  GLU    19      53.181  52.488  93.722  1.00103.20           C  
ATOM    150  CG  GLU    19      53.522  53.232  94.990  1.00103.43           C  
ATOM    151  CD  GLU    19      54.278  52.362  95.961  1.00104.06           C  
ATOM    152  OE1 GLU    19      55.462  52.057  95.693  1.00103.95           O  
ATOM    153  OE2 GLU    19      53.684  51.973  96.987  1.00104.64           O  
ATOM    154  N   LYS    20      54.579  53.988  91.300  1.00104.46           N  
ATOM    155  CA  LYS    20      55.623  54.888  90.812  1.00104.68           C  
ATOM    156  C   LYS    20      55.049  56.070  90.029  1.00104.66           C  
ATOM    157  O   LYS    20      55.796  56.822  89.401  1.00104.93           O  
ATOM    158  CB  LYS    20      56.616  54.142  89.910  1.00104.64           C  
ATOM    159  CG  LYS    20      57.659  53.292  90.629  1.00105.42           C  
ATOM    160  CD  LYS    20      57.151  51.896  90.962  1.00105.46           C  
ATOM    161  CE  LYS    20      58.321  50.946  91.197  1.00105.42           C  
ATOM    162  NZ  LYS    20      57.901  49.517  91.263  1.00104.88           N  
ATOM    163  N   ASP    21      53.731  56.236  90.059  1.00104.17           N  
ATOM    164  CA  ASP    21      53.103  57.338  89.337  1.00104.08           C  
ATOM    165  C   ASP    21      51.638  57.467  89.721  1.00102.94           C  
ATOM    166  O   ASP    21      51.298  57.504  90.908  1.00102.07           O  
ATOM    167  CB  ASP    21      53.222  57.118  87.817  1.00105.75           C  
ATOM    168  CG  ASP    21      52.880  58.371  87.003  1.00107.30           C  
ATOM    169  OD1 ASP    21      52.908  58.292  85.751  1.00108.74           O  
ATOM    170  OD2 ASP    21      52.592  59.431  87.609  1.00106.97           O  
ATOM    171  N   ALA    22      50.789  57.527  88.695  1.00101.55           N  
ATOM    172  CA  ALA    22      49.342  57.663  88.831  1.00 99.78           C  
ATOM    173  C   ALA    22      48.850  57.483  90.258  1.00 98.72           C  
ATOM    174  O   ALA    22      48.964  58.387  91.095  1.00 97.73           O  
ATOM    175  CB  ALA    22      48.637  56.669  87.906  1.00 98.99           C  
ATOM    176  N   SER    23      48.305  56.304  90.526  1.00 97.73           N  
ATOM    177  CA  SER    23      47.781  55.983  91.844  1.00 96.67           C  
ATOM    178  C   SER    23      47.405  54.521  91.962  1.00 93.94           C  
ATOM    179  O   SER    23      46.808  53.941  91.052  1.00 93.15           O  
ATOM    180  CB  SER    23      46.544  56.831  92.150  1.00 98.93           C  
ATOM    181  OG  SER    23      45.855  56.317  93.279  1.00101.01           O  
ATOM    182  N   GLY    24      47.747  53.934  93.100  1.00 91.17           N  
ATOM    183  CA  GLY    24      47.416  52.547  93.324  1.00 88.31           C  
ATOM    184  C   GLY    24      45.926  52.425  93.538  1.00 85.81           C  
ATOM    185  O   GLY    24      45.453  51.472  94.161  1.00 85.71           O  
ATOM    186  N   HIS    25      45.175  53.395  93.032  1.00 83.24           N  
ATOM    187  CA  HIS    25      43.738  53.342  93.195  1.00 81.98           C  
ATOM    188  C   HIS    25      43.058  52.852  91.917  1.00 80.44           C  
ATOM    189  O   HIS    25      41.926  52.355  91.961  1.00 79.67           O  
ATOM    190  CB  HIS    25      43.201  54.706  93.633  1.00 83.23           C  
ATOM    191  CG  HIS    25      41.775  54.670  94.088  1.00 84.88           C  
ATOM    192  ND1 HIS    25      41.314  53.769  95.025  1.00 85.42           N  
ATOM    193  CD2 HIS    25      40.702  55.406  93.714  1.00 84.94           C  
ATOM    194  CE1 HIS    25      40.018  53.948  95.204  1.00 85.70           C  
ATOM    195  NE2 HIS    25      39.622  54.935  94.420  1.00 85.98           N  
ATOM    196  N   ASP    26      43.757  52.958  90.784  1.00 79.12           N  
ATOM    197  CA  ASP    26      43.212  52.475  89.503  1.00 77.77           C  
ATOM    198  C   ASP    26      43.214  50.945  89.471  1.00 76.08           C  
ATOM    199  O   ASP    26      42.777  50.341  88.491  1.00 75.82           O  
ATOM    200  CB  ASP    26      44.034  52.977  88.307  1.00 77.40           C  
ATOM    201  CG  ASP    26      43.863  54.456  88.058  1.00 77.10           C  
ATOM    202  OD1 ASP    26      42.700  54.928  87.991  1.00 76.65           O  
ATOM    203  OD2 ASP    26      44.898  55.146  87.912  1.00 75.69           O  
ATOM    204  N   TRP    27      43.728  50.333  90.537  1.00 73.47           N  
ATOM    205  CA  TRP    27      43.779  48.888  90.635  1.00 70.85           C  
ATOM    206  C   TRP    27      42.388  48.305  90.787  1.00 68.98           C  
ATOM    207  O   TRP    27      42.028  47.349  90.096  1.00 70.15           O  
ATOM    208  CB  TRP    27      44.649  48.432  91.817  1.00 71.69           C  
ATOM    209  CG  TRP    27      44.241  47.064  92.346  1.00 73.38           C  
ATOM    210  CD1 TRP    27      43.473  46.804  93.458  1.00 74.39           C  
ATOM    211  CD2 TRP    27      44.455  45.796  91.714  1.00 73.53           C  
ATOM    212  NE1 TRP    27      43.191  45.462  93.549  1.00 73.85           N  
ATOM    213  CE2 TRP    27      43.783  44.819  92.494  1.00 74.77           C  
ATOM    214  CE3 TRP    27      45.143  45.388  90.567  1.00 72.74           C  
ATOM    215  CZ2 TRP    27      43.781  43.459  92.155  1.00 75.30           C  
ATOM    216  CZ3 TRP    27      45.139  44.037  90.231  1.00 74.15           C  
ATOM    217  CH2 TRP    27      44.463  43.089  91.024  1.00 74.79           C  
ATOM    218  N   TYR    28      41.596  48.873  91.687  1.00 65.51           N  
ATOM    219  CA  TYR    28      40.252  48.347  91.912  1.00 62.28           C  
ATOM    220  C   TYR    28      39.476  48.235  90.598  1.00 58.54           C  
ATOM    221  O   TYR    28      38.558  47.439  90.498  1.00 56.72           O  
ATOM    222  CB  TYR    28      39.515  49.208  92.951  1.00 64.73           C  
ATOM    223  CG  TYR    28      40.224  49.245  94.303  1.00 67.03           C  
ATOM    224  CD1 TYR    28      41.480  49.853  94.444  1.00 68.58           C  
ATOM    225  CD2 TYR    28      39.659  48.637  95.433  1.00 67.35           C  
ATOM    226  CE1 TYR    28      42.156  49.849  95.674  1.00 69.21           C  
ATOM    227  CE2 TYR    28      40.326  48.632  96.666  1.00 67.81           C  
ATOM    228  CZ  TYR    28      41.570  49.238  96.774  1.00 68.84           C  
ATOM    229  OH  TYR    28      42.228  49.226  97.980  1.00 70.91           O  
ATOM    230  N   HIS    29      39.866  49.016  89.593  1.00 55.40           N  
ATOM    231  CA  HIS    29      39.227  48.949  88.287  1.00 53.42           C  
ATOM    232  C   HIS    29      39.777  47.765  87.513  1.00 51.44           C  
ATOM    233  O   HIS    29      39.034  47.009  86.902  1.00 49.77           O  
ATOM    234  CB  HIS    29      39.485  50.221  87.475  1.00 55.32           C  
ATOM    235  CG  HIS    29      39.470  50.003  85.984  1.00 56.65           C  
ATOM    236  ND1 HIS    29      38.372  49.514  85.306  1.00 57.67           N  
ATOM    237  CD2 HIS    29      40.417  50.231  85.041  1.00 56.45           C  
ATOM    238  CE1 HIS    29      38.640  49.456  84.010  1.00 56.41           C  
ATOM    239  NE2 HIS    29      39.874  49.886  83.823  1.00 56.73           N  
ATOM    240  N   ILE    30      41.101  47.649  87.518  1.00 51.15           N  
ATOM    241  CA  ILE    30      41.801  46.572  86.828  1.00 51.20           C  
ATOM    242  C   ILE    30      41.229  45.238  87.300  1.00 53.62           C  
ATOM    243  O   ILE    30      40.860  44.378  86.488  1.00 53.68           O  
ATOM    244  CB  ILE    30      43.324  46.517  87.154  1.00 48.66           C  
ATOM    245  CG1 ILE    30      43.969  47.897  87.045  1.00 44.66           C  
ATOM    246  CG2 ILE    30      43.995  45.513  86.211  1.00 48.04           C  
ATOM    247  CD1 ILE    30      44.237  48.358  85.653  1.00 43.24           C  
ATOM    248  N   ARG    31      41.175  45.061  88.622  1.00 54.08           N  
ATOM    249  CA  ARG    31      40.676  43.817  89.194  1.00 54.15           C  
ATOM    250  C   ARG    31      39.234  43.543  88.788  1.00 52.06           C  
ATOM    251  O   ARG    31      38.924  42.494  88.229  1.00 51.50           O  
ATOM    252  CB  ARG    31      40.805  43.823  90.725  1.00 56.17           C  
ATOM    253  CG  ARG    31      40.390  42.491  91.340  1.00 60.09           C  
ATOM    254  CD  ARG    31      40.510  42.471  92.856  1.00 63.32           C  
ATOM    255  NE  ARG    31      39.691  43.495  93.505  1.00 65.45           N  
ATOM    256  CZ  ARG    31      39.502  43.561  94.823  1.00 66.81           C  
ATOM    257  NH1 ARG    31      40.069  42.659  95.621  1.00 66.56           N  
ATOM    258  NH2 ARG    31      38.759  44.528  95.351  1.00 65.71           N  
ATOM    259  N   ARG    32      38.358  44.492  89.071  1.00 51.28           N  
ATOM    260  CA  ARG    32      36.951  44.360  88.729  1.00 50.62           C  
ATOM    261  C   ARG    32      36.765  43.820  87.312  1.00 51.83           C  
ATOM    262  O   ARG    32      35.852  43.041  87.057  1.00 51.50           O  
ATOM    263  CB  ARG    32      36.276  45.712  88.846  1.00 48.27           C  
ATOM    264  CG  ARG    32      35.011  45.680  89.608  1.00 46.09           C  
ATOM    265  CD  ARG    32      34.328  47.014  89.485  1.00 47.69           C  
ATOM    266  NE  ARG    32      35.049  48.077  90.169  1.00 47.67           N  
ATOM    267  CZ  ARG    32      35.808  48.993  89.578  1.00 47.94           C  
ATOM    268  NH1 ARG    32      36.414  49.916  90.319  1.00 47.18           N  
ATOM    269  NH2 ARG    32      35.957  48.996  88.259  1.00 49.59           N  
ATOM    270  N   VAL    33      37.632  44.239  86.394  1.00 53.39           N  
ATOM    271  CA  VAL    33      37.567  43.781  85.003  1.00 54.19           C  
ATOM    272  C   VAL    33      38.111  42.351  84.934  1.00 55.41           C  
ATOM    273  O   VAL    33      37.501  41.474  84.322  1.00 54.30           O  
ATOM    274  CB  VAL    33      38.413  44.687  84.050  1.00 53.90           C  
ATOM    275  CG1 VAL    33      38.346  44.162  82.624  1.00 51.59           C  
ATOM    276  CG2 VAL    33      37.901  46.114  84.100  1.00 53.88           C  
ATOM    277  N   HIS    34      39.264  42.135  85.572  1.00 56.32           N  
ATOM    278  CA  HIS    34      39.923  40.826  85.620  1.00 55.84           C  
ATOM    279  C   HIS    34      38.996  39.755  86.217  1.00 56.94           C  
ATOM    280  O   HIS    34      38.687  38.754  85.561  1.00 56.34           O  
ATOM    281  CB  HIS    34      41.224  40.912  86.439  1.00 54.06           C  
ATOM    282  CG  HIS    34      41.802  39.575  86.794  1.00 52.65           C  
ATOM    283  ND1 HIS    34      41.877  38.535  85.894  1.00 50.77           N  
ATOM    284  CD2 HIS    34      42.330  39.108  87.952  1.00 52.11           C  
ATOM    285  CE1 HIS    34      42.424  37.485  86.480  1.00 50.16           C  
ATOM    286  NE2 HIS    34      42.708  37.805  87.728  1.00 50.45           N  
ATOM    287  N   LYS    35      38.549  39.958  87.455  1.00 56.59           N  
ATOM    288  CA  LYS    35      37.659  38.985  88.065  1.00 55.98           C  
ATOM    289  C   LYS    35      36.457  38.761  87.151  1.00 56.88           C  
ATOM    290  O   LYS    35      35.891  37.674  87.089  1.00 56.33           O  
ATOM    291  CB  LYS    35      37.201  39.472  89.439  1.00 53.59           C  
ATOM    292  CG  LYS    35      38.334  39.690  90.416  1.00 50.94           C  
ATOM    293  CD  LYS    35      37.800  40.159  91.759  1.00 50.35           C  
ATOM    294  CE  LYS    35      37.179  39.030  92.574  1.00 48.14           C  
ATOM    295  NZ  LYS    35      38.181  38.374  93.467  1.00 47.39           N  
ATOM    296  N   MET    36      36.091  39.803  86.424  1.00 59.10           N  
ATOM    297  CA  MET    36      34.960  39.753  85.511  1.00 62.62           C  
ATOM    298  C   MET    36      35.278  38.960  84.233  1.00 61.88           C  
ATOM    299  O   MET    36      34.404  38.286  83.671  1.00 62.26           O  
ATOM    300  CB  MET    36      34.539  41.187  85.171  1.00 67.04           C  
ATOM    301  CG  MET    36      33.169  41.333  84.535  1.00 72.36           C  
ATOM    302  SD  MET    36      32.234  42.926  85.147  1.00 81.64          SE  
ATOM    303  CE  MET    36      33.734  44.163  85.380  1.00 77.97           C  
ATOM    304  N   ALA    37      36.527  39.046  83.780  1.00 60.52           N  
ATOM    305  CA  ALA    37      36.968  38.332  82.585  1.00 58.25           C  
ATOM    306  C   ALA    37      37.003  36.852  82.909  1.00 56.97           C  
ATOM    307  O   ALA    37      36.825  36.009  82.026  1.00 55.56           O  
ATOM    308  CB  ALA    37      38.343  38.805  82.164  1.00 59.39           C  
ATOM    309  N   ILE    38      37.249  36.540  84.179  1.00 55.28           N  
ATOM    310  CA  ILE    38      37.252  35.153  84.601  1.00 54.56           C  
ATOM    311  C   ILE    38      35.823  34.652  84.444  1.00 55.34           C  
ATOM    312  O   ILE    38      35.507  33.926  83.510  1.00 55.56           O  
ATOM    313  CB  ILE    38      37.623  34.976  86.078  1.00 53.58           C  
ATOM    314  CG1 ILE    38      39.065  35.405  86.320  1.00 52.95           C  
ATOM    315  CG2 ILE    38      37.404  33.521  86.479  1.00 52.78           C  
ATOM    316  CD1 ILE    38      40.072  34.576  85.600  1.00 52.24           C  
ATOM    317  N   SER    39      34.959  35.068  85.359  1.00 55.32           N  
ATOM    318  CA  SER    39      33.573  34.645  85.344  1.00 56.07           C  
ATOM    319  C   SER    39      32.968  34.566  83.957  1.00 56.48           C  
ATOM    320  O   SER    39      32.089  33.741  83.699  1.00 55.65           O  
ATOM    321  CB  SER    39      32.749  35.572  86.226  1.00 56.50           C  
ATOM    322  OG  SER    39      33.229  35.508  87.550  1.00 59.84           O  
ATOM    323  N   LEU    40      33.451  35.419  83.064  1.00 57.31           N  
ATOM    324  CA  LEU    40      32.960  35.450  81.693  1.00 59.67           C  
ATOM    325  C   LEU    40      33.495  34.249  80.879  1.00 61.86           C  
ATOM    326  O   LEU    40      32.736  33.576  80.169  1.00 61.73           O  
ATOM    327  CB  LEU    40      33.367  36.778  81.046  1.00 59.16           C  
ATOM    328  CG  LEU    40      32.337  37.625  80.294  1.00 58.09           C  
ATOM    329  CD1 LEU    40      31.103  37.876  81.142  1.00 57.41           C  
ATOM    330  CD2 LEU    40      32.994  38.935  79.902  1.00 55.70           C  
ATOM    331  N   SER    41      34.795  33.970  80.996  1.00 63.41           N  
ATOM    332  CA  SER    41      35.410  32.847  80.270  1.00 63.60           C  
ATOM    333  C   SER    41      34.805  31.530  80.710  1.00 63.06           C  
ATOM    334  O   SER    41      34.439  30.702  79.880  1.00 61.82           O  
ATOM    335  CB  SER    41      36.937  32.800  80.500  1.00 64.79           C  
ATOM    336  OG  SER    41      37.285  32.046  81.658  1.00 63.73           O  
ATOM    337  N   GLU    42      34.717  31.354  82.026  1.00 62.63           N  
ATOM    338  CA  GLU    42      34.164  30.141  82.606  1.00 61.99           C  
ATOM    339  C   GLU    42      32.690  30.023  82.279  1.00 60.99           C  
ATOM    340  O   GLU    42      31.904  29.451  83.022  1.00 60.52           O  
ATOM    341  CB  GLU    42      34.377  30.105  84.125  1.00 62.67           C  
ATOM    342  CG  GLU    42      33.401  30.918  84.953  1.00 62.19           C  
ATOM    343  CD  GLU    42      33.918  31.142  86.361  1.00 62.74           C  
ATOM    344  OE1 GLU    42      33.116  31.508  87.246  1.00 62.64           O  
ATOM    345  OE2 GLU    42      35.140  30.973  86.577  1.00 62.23           O  
ATOM    346  N   GLN    43      32.310  30.580  81.150  1.00 59.93           N  
ATOM    347  CA  GLN    43      30.945  30.468  80.745  1.00 58.67           C  
ATOM    348  C   GLN    43      30.904  30.640  79.257  1.00 58.36           C  
ATOM    349  O   GLN    43      29.860  30.480  78.632  1.00 58.42           O  
ATOM    350  CB  GLN    43      30.096  31.522  81.412  1.00 59.96           C  
ATOM    351  CG  GLN    43      28.648  31.260  81.180  1.00 61.85           C  
ATOM    352  CD  GLN    43      27.815  31.788  82.291  1.00 62.80           C  
ATOM    353  OE1 GLN    43      26.603  31.585  82.327  1.00 64.57           O  
ATOM    354  NE2 GLN    43      28.457  32.478  83.223  1.00 62.58           N  
ATOM    355  N   GLU    44      32.062  30.948  78.687  1.00 56.60           N  
ATOM    356  CA  GLU    44      32.157  31.156  77.257  1.00 54.77           C  
ATOM    357  C   GLU    44      33.349  30.476  76.611  1.00 54.02           C  
ATOM    358  O   GLU    44      33.458  30.456  75.389  1.00 51.36           O  
ATOM    359  CB  GLU    44      32.226  32.645  76.963  1.00 56.28           C  
ATOM    360  CG  GLU    44      30.946  33.396  77.190  1.00 55.44           C  
ATOM    361  CD  GLU    44      29.845  32.942  76.270  1.00 58.05           C  
ATOM    362  OE1 GLU    44      30.150  32.492  75.138  1.00 57.77           O  
ATOM    363  OE2 GLU    44      28.665  33.049  76.675  1.00 59.93           O  
ATOM    364  N   GLY    45      34.248  29.937  77.428  1.00 54.00           N  
ATOM    365  CA  GLY    45      35.418  29.268  76.892  1.00 53.58           C  
ATOM    366  C   GLY    45      36.656  30.149  76.854  1.00 53.71           C  
ATOM    367  O   GLY    45      36.869  30.965  77.753  1.00 56.62           O  
ATOM    368  N   GLY    46      37.474  29.975  75.815  1.00 52.13           N  
ATOM    369  CA  GLY    46      38.703  30.742  75.660  1.00 49.24           C  
ATOM    370  C   GLY    46      39.796  30.423  76.673  1.00 48.72           C  
ATOM    371  O   GLY    46      39.519  29.985  77.795  1.00 47.46           O  
ATOM    372  N   ASN    47      41.047  30.672  76.289  1.00 48.16           N  
ATOM    373  CA  ASN    47      42.190  30.399  77.163  1.00 49.52           C  
ATOM    374  C   ASN    47      42.307  31.299  78.387  1.00 50.80           C  
ATOM    375  O   ASN    47      42.789  32.425  78.279  1.00 52.11           O  
ATOM    376  CB  ASN    47      43.494  30.520  76.391  1.00 49.39           C  
ATOM    377  CG  ASN    47      44.687  30.074  77.215  1.00 49.42           C  
ATOM    378  OD1 ASN    47      44.642  30.082  78.450  1.00 45.46           O  
ATOM    379  ND2 ASN    47      45.766  29.682  76.534  1.00 48.99           N  
ATOM    380  N   ARG    48      41.914  30.796  79.553  1.00 51.76           N  
ATOM    381  CA  ARG    48      41.987  31.582  80.780  1.00 51.84           C  
ATOM    382  C   ARG    48      43.284  32.372  80.928  1.00 51.82           C  
ATOM    383  O   ARG    48      43.280  33.595  80.782  1.00 51.81           O  
ATOM    384  CB  ARG    48      41.780  30.683  81.992  1.00 53.07           C  
ATOM    385  CG  ARG    48      40.309  30.400  82.278  1.00 57.10           C  
ATOM    386  CD  ARG    48      39.735  31.481  83.181  1.00 59.98           C  
ATOM    387  NE  ARG    48      40.602  31.683  84.348  1.00 61.76           N  
ATOM    388  CZ  ARG    48      40.326  31.286  85.589  1.00 60.86           C  
ATOM    389  NH1 ARG    48      39.184  30.661  85.857  1.00 59.67           N  
ATOM    390  NH2 ARG    48      41.210  31.501  86.559  1.00 59.79           N  
ATOM    391  N   PHE    49      44.394  31.697  81.203  1.00 51.76           N  
ATOM    392  CA  PHE    49      45.666  32.408  81.356  1.00 51.74           C  
ATOM    393  C   PHE    49      45.840  33.601  80.425  1.00 51.33           C  
ATOM    394  O   PHE    49      46.225  34.681  80.862  1.00 52.80           O  
ATOM    395  CB  PHE    49      46.830  31.481  81.111  1.00 51.48           C  
ATOM    396  CG  PHE    49      48.155  32.118  81.341  1.00 52.07           C  
ATOM    397  CD1 PHE    49      49.094  32.186  80.318  1.00 52.10           C  
ATOM    398  CD2 PHE    49      48.514  32.550  82.618  1.00 52.69           C  
ATOM    399  CE1 PHE    49      50.389  32.664  80.565  1.00 53.59           C  
ATOM    400  CE2 PHE    49      49.806  33.028  82.877  1.00 53.77           C  
ATOM    401  CZ  PHE    49      50.751  33.084  81.847  1.00 52.32           C  
ATOM    402  N   ILE    50      45.588  33.406  79.137  1.00 50.70           N  
ATOM    403  CA  ILE    50      45.739  34.514  78.214  1.00 50.46           C  
ATOM    404  C   ILE    50      44.749  35.584  78.623  1.00 49.83           C  
ATOM    405  O   ILE    50      45.142  36.714  78.886  1.00 51.30           O  
ATOM    406  CB  ILE    50      45.510  34.097  76.725  1.00 49.38           C  
ATOM    407  CG1 ILE    50      46.774  33.430  76.170  1.00 48.19           C  
ATOM    408  CG2 ILE    50      45.234  35.319  75.874  1.00 48.93           C  
ATOM    409  CD1 ILE    50      46.609  32.873  74.783  1.00 47.73           C  
ATOM    410  N   ILE    51      43.472  35.227  78.705  1.00 49.94           N  
ATOM    411  CA  ILE    51      42.448  36.195  79.082  1.00 50.81           C  
ATOM    412  C   ILE    51      42.883  36.992  80.317  1.00 53.81           C  
ATOM    413  O   ILE    51      42.873  38.229  80.291  1.00 55.26           O  
ATOM    414  CB  ILE    51      41.099  35.505  79.356  1.00 46.63           C  
ATOM    415  CG1 ILE    51      40.559  34.913  78.061  1.00 45.05           C  
ATOM    416  CG2 ILE    51      40.102  36.504  79.899  1.00 45.01           C  
ATOM    417  CD1 ILE    51      39.285  34.109  78.227  1.00 44.42           C  
ATOM    418  N   GLU    52      43.285  36.292  81.381  1.00 55.37           N  
ATOM    419  CA  GLU    52      43.718  36.952  82.608  1.00 57.49           C  
ATOM    420  C   GLU    52      44.933  37.841  82.408  1.00 58.45           C  
ATOM    421  O   GLU    52      44.906  39.026  82.735  1.00 59.10           O  
ATOM    422  CB  GLU    52      44.043  35.928  83.683  1.00 56.94           C  
ATOM    423  CG  GLU    52      42.875  35.139  84.137  1.00 58.84           C  
ATOM    424  CD  GLU    52      43.189  34.348  85.379  1.00 62.43           C  
ATOM    425  OE1 GLU    52      43.505  34.968  86.416  1.00 63.83           O  
ATOM    426  OE2 GLU    52      43.125  33.102  85.326  1.00 66.05           O  
ATOM    427  N   MET    53      46.008  37.267  81.887  1.00 60.12           N  
ATOM    428  CA  MET    53      47.213  38.051  81.661  1.00 63.39           C  
ATOM    429  C   MET    53      46.903  39.291  80.832  1.00 62.71           C  
ATOM    430  O   MET    53      47.500  40.356  81.037  1.00 62.91           O  
ATOM    431  CB  MET    53      48.274  37.225  80.941  1.00 67.12           C  
ATOM    432  CG  MET    53      48.942  36.210  81.823  1.00 73.08           C  
ATOM    433  SD  MET    53      49.749  37.059  83.358  1.00 83.60          SE  
ATOM    434  CE  MET    53      51.366  37.718  82.523  1.00 78.14           C  
ATOM    435  N   ALA    54      45.966  39.159  79.898  1.00 59.46           N  
ATOM    436  CA  ALA    54      45.625  40.288  79.052  1.00 57.21           C  
ATOM    437  C   ALA    54      44.861  41.346  79.830  1.00 55.89           C  
ATOM    438  O   ALA    54      45.317  42.490  79.935  1.00 57.33           O  
ATOM    439  CB  ALA    54      44.826  39.827  77.849  1.00 55.59           C  
ATOM    440  N   ALA    55      43.717  40.971  80.393  1.00 53.22           N  
ATOM    441  CA  ALA    55      42.894  41.910  81.150  1.00 50.69           C  
ATOM    442  C   ALA    55      43.701  42.646  82.206  1.00 50.15           C  
ATOM    443  O   ALA    55      43.427  43.796  82.508  1.00 48.41           O  
ATOM    444  CB  ALA    55      41.761  41.166  81.808  1.00 50.25           C  
ATOM    445  N   LEU    56      44.704  41.966  82.750  1.00 51.07           N  
ATOM    446  CA  LEU    56      45.559  42.507  83.792  1.00 51.70           C  
ATOM    447  C   LEU    56      46.627  43.484  83.326  1.00 54.01           C  
ATOM    448  O   LEU    56      47.231  44.160  84.155  1.00 54.43           O  
ATOM    449  CB  LEU    56      46.251  41.361  84.522  1.00 51.37           C  
ATOM    450  CG  LEU    56      45.783  40.934  85.917  1.00 51.81           C  
ATOM    451  CD1 LEU    56      45.348  39.469  85.913  1.00 51.25           C  
ATOM    452  CD2 LEU    56      46.937  41.137  86.898  1.00 50.58           C  
ATOM    453  N   LEU    57      46.873  43.574  82.020  1.00 55.71           N  
ATOM    454  CA  LEU    57      47.917  44.475  81.533  1.00 56.87           C  
ATOM    455  C   LEU    57      47.495  45.454  80.427  1.00 58.78           C  
ATOM    456  O   LEU    57      48.340  46.209  79.916  1.00 59.98           O  
ATOM    457  CB  LEU    57      49.135  43.645  81.079  1.00 56.76           C  
ATOM    458  CG  LEU    57      49.916  42.822  82.129  1.00 55.77           C  
ATOM    459  CD1 LEU    57      50.878  41.866  81.443  1.00 53.44           C  
ATOM    460  CD2 LEU    57      50.678  43.748  83.061  1.00 54.51           C  
ATOM    461  N   HIS    58      46.205  45.453  80.068  1.00 58.11           N  
ATOM    462  CA  HIS    58      45.678  46.352  79.023  1.00 57.60           C  
ATOM    463  C   HIS    58      45.853  47.808  79.420  1.00 56.70           C  
ATOM    464  O   HIS    58      46.028  48.694  78.582  1.00 55.98           O  
ATOM    465  CB  HIS    58      44.177  46.059  78.735  1.00 59.89           C  
ATOM    466  CG  HIS    58      43.226  46.445  79.840  1.00 64.46           C  
ATOM    467  ND1 HIS    58      43.357  46.003  81.143  1.00 66.22           N  
ATOM    468  CD2 HIS    58      42.085  47.181  79.815  1.00 66.37           C  
ATOM    469  CE1 HIS    58      42.343  46.447  81.868  1.00 65.24           C  
ATOM    470  NE2 HIS    58      41.556  47.163  81.086  1.00 66.11           N  
ATOM    471  N   ASP    59      45.824  48.028  80.724  1.00 55.66           N  
ATOM    472  CA  ASP    59      45.957  49.347  81.281  1.00 55.23           C  
ATOM    473  C   ASP    59      47.392  49.828  81.412  1.00 56.41           C  
ATOM    474  O   ASP    59      47.644  51.029  81.398  1.00 57.70           O  
ATOM    475  CB  ASP    59      45.263  49.386  82.638  1.00 54.64           C  
ATOM    476  CG  ASP    59      43.826  49.855  82.541  1.00 53.95           C  
ATOM    477  OD1 ASP    59      43.117  49.453  81.599  1.00 53.61           O  
ATOM    478  OD2 ASP    59      43.402  50.629  83.418  1.00 53.25           O  
ATOM    479  N   VAL    60      48.336  48.903  81.526  1.00 56.48           N  
ATOM    480  CA  VAL    60      49.734  49.276  81.686  1.00 55.99           C  
ATOM    481  C   VAL    60      50.368  49.796  80.405  1.00 57.45           C  
ATOM    482  O   VAL    60      51.435  50.415  80.427  1.00 57.80           O  
ATOM    483  CB  VAL    60      50.530  48.096  82.236  1.00 55.60           C  
ATOM    484  CG1 VAL    60      51.999  48.445  82.352  1.00 55.22           C  
ATOM    485  CG2 VAL    60      49.980  47.742  83.597  1.00 56.62           C  
ATOM    486  N   ALA    61      49.703  49.568  79.284  1.00 58.50           N  
ATOM    487  CA  ALA    61      50.227  50.055  78.023  1.00 60.65           C  
ATOM    488  C   ALA    61      49.501  51.351  77.644  1.00 63.43           C  
ATOM    489  O   ALA    61      50.048  52.195  76.934  1.00 63.87           O  
ATOM    490  CB  ALA    61      50.049  49.001  76.944  1.00 59.87           C  
ATOM    491  N   ASP    62      48.270  51.510  78.128  1.00 66.34           N  
ATOM    492  CA  ASP    62      47.468  52.711  77.854  1.00 66.96           C  
ATOM    493  C   ASP    62      48.321  53.975  77.892  1.00 65.64           C  
ATOM    494  O   ASP    62      48.732  54.471  76.852  1.00 64.05           O  
ATOM    495  CB  ASP    62      46.328  52.818  78.883  1.00 69.44           C  
ATOM    496  CG  ASP    62      45.606  54.165  78.846  1.00 72.14           C  
ATOM    497  OD1 ASP    62      44.950  54.481  77.817  1.00 70.22           O  
ATOM    498  OD2 ASP    62      45.688  54.904  79.865  1.00 73.11           O  
ATOM    499  N   LEU    65      48.350  56.770  79.950  1.00 63.26           N  
ATOM    500  CA  LEU    65      49.183  57.483  80.928  1.00 63.60           C  
ATOM    501  C   LEU    65      50.395  56.636  81.329  1.00 65.48           C  
ATOM    502  O   LEU    65      51.016  56.862  82.375  1.00 67.00           O  
ATOM    503  CB  LEU    65      48.374  57.837  82.200  1.00 61.25           C  
ATOM    504  CG  LEU    65      47.636  56.735  82.996  1.00 58.55           C  
ATOM    505  CD1 LEU    65      47.408  57.162  84.456  1.00 54.02           C  
ATOM    506  CD2 LEU    65      46.304  56.421  82.303  1.00 55.80           C  
ATOM    507  N   ASN    66      50.733  55.656  80.497  1.00 64.41           N  
ATOM    508  CA  ASN    66      51.866  54.777  80.800  1.00 65.42           C  
ATOM    509  C   ASN    66      53.182  55.458  80.452  1.00 65.25           C  
ATOM    510  O   ASN    66      54.152  55.400  81.217  1.00 66.11           O  
ATOM    511  CB  ASN    66      51.759  53.455  80.011  1.00 66.78           C  
ATOM    512  CG  ASN    66      52.116  53.618  78.521  1.00 67.01           C  
ATOM    513  OD1 ASN    66      51.412  54.308  77.774  1.00 67.34           O  
ATOM    514  ND2 ASN    66      53.216  52.990  78.096  1.00 64.00           N  
ATOM    515  N   GLU    67      53.196  56.073  79.272  1.00 64.42           N  
ATOM    516  CA  GLU    67      54.359  56.768  78.752  1.00 66.26           C  
ATOM    517  C   GLU    67      54.011  57.617  77.522  1.00 69.19           C  
ATOM    518  O   GLU    67      53.540  58.753  77.657  1.00 72.69           O  
ATOM    519  CB  GLU    67      55.446  55.770  78.375  1.00 67.01           C  
ATOM    520  CG  GLU    67      56.740  56.445  77.950  1.00 66.48           C  
ATOM    521  CD  GLU    67      57.832  56.281  78.992  1.00 65.04           C  
ATOM    522  OE1 GLU    67      57.622  56.701  80.158  1.00 65.65           O  
ATOM    523  OE2 GLU    67      58.910  55.746  78.640  1.00 64.94           O  
ATOM    524  N   SER    68      54.220  57.072  76.323  1.00 67.68           N  
ATOM    525  CA  SER    68      53.951  57.825  75.088  1.00 67.54           C  
ATOM    526  C   SER    68      53.652  56.898  73.899  1.00 71.84           C  
ATOM    527  O   SER    68      54.564  56.280  73.338  1.00 73.27           O  
ATOM    528  CB  SER    68      55.164  58.707  74.784  1.00 66.29           C  
ATOM    529  OG  SER    68      56.203  58.457  75.730  1.00 58.59           O  
ATOM    530  N   GLU    69      52.375  56.814  73.519  1.00 74.66           N  
ATOM    531  CA  GLU    69      51.937  55.948  72.421  1.00 77.50           C  
ATOM    532  C   GLU    69      52.318  54.458  72.665  1.00 80.84           C  
ATOM    533  O   GLU    69      52.253  53.969  73.795  1.00 79.23           O  
ATOM    534  CB  GLU    69      52.530  56.451  71.087  1.00 78.22           C  
ATOM    535  N   GLU    70      52.715  53.756  71.601  1.00 82.88           N  
ATOM    536  CA  GLU    70      53.096  52.344  71.665  1.00 83.86           C  
ATOM    537  C   GLU    70      54.446  52.143  72.368  1.00 84.49           C  
ATOM    538  O   GLU    70      55.265  51.314  71.962  1.00 82.91           O  
ATOM    539  CB  GLU    70      53.143  51.777  70.239  1.00 86.54           C  
ATOM    540  CG  GLU    70      53.149  50.249  70.127  1.00 91.10           C  
ATOM    541  CD  GLU    70      54.465  49.698  69.604  1.00 93.39           C  
ATOM    542  OE1 GLU    70      54.783  49.948  68.415  1.00 94.80           O  
ATOM    543  OE2 GLU    70      55.179  49.023  70.387  1.00 94.11           O  
ATOM    544  N   ALA    71      54.677  52.916  73.422  1.00 84.48           N  
ATOM    545  CA  ALA    71      55.915  52.811  74.174  1.00 85.35           C  
ATOM    546  C   ALA    71      55.727  51.797  75.298  1.00 87.00           C  
ATOM    547  O   ALA    71      56.696  51.242  75.827  1.00 86.42           O  
ATOM    548  CB  ALA    71      56.284  54.162  74.742  1.00 85.43           C  
ATOM    549  N   GLY    72      54.464  51.558  75.646  1.00 88.72           N  
ATOM    550  CA  GLY    72      54.136  50.614  76.701  1.00 90.58           C  
ATOM    551  C   GLY    72      54.090  49.183  76.206  1.00 91.40           C  
ATOM    552  O   GLY    72      54.205  48.240  76.985  1.00 91.79           O  
ATOM    553  N   MET    73      53.912  49.023  74.902  1.00 92.03           N  
ATOM    554  CA  MET    73      53.868  47.703  74.303  1.00 93.01           C  
ATOM    555  C   MET    73      55.137  46.949  74.672  1.00 91.55           C  
ATOM    556  O   MET    73      55.083  45.833  75.187  1.00 91.24           O  
ATOM    557  CB  MET    73      53.774  47.827  72.790  1.00 97.28           C  
ATOM    558  CG  MET    73      52.728  46.929  72.165  1.00102.19           C  
ATOM    559  SD  MET    73      50.960  47.206  72.919  1.00109.67          SE  
ATOM    560  CE  MET    73      50.901  49.159  72.946  1.00105.49           C  
ATOM    561  N   LYS    74      56.283  47.561  74.397  1.00 89.74           N  
ATOM    562  CA  LYS    74      57.549  46.929  74.721  1.00 88.01           C  
ATOM    563  C   LYS    74      57.703  46.900  76.228  1.00 87.41           C  
ATOM    564  O   LYS    74      58.559  46.197  76.755  1.00 88.23           O  
ATOM    565  CB  LYS    74      58.727  47.684  74.098  1.00 87.71           C  
ATOM    566  CG  LYS    74      60.100  47.062  74.395  1.00 86.29           C  
ATOM    567  CD  LYS    74      60.689  47.527  75.725  1.00 84.77           C  
ATOM    568  CE  LYS    74      62.018  46.846  76.007  1.00 85.01           C  
ATOM    569  NZ  LYS    74      62.982  46.979  74.879  1.00 83.18           N  
ATOM    570  N   LYS    75      56.881  47.671  76.928  1.00 85.82           N  
ATOM    571  CA  LYS    75      56.950  47.683  78.383  1.00 84.29           C  
ATOM    572  C   LYS    75      56.334  46.385  78.901  1.00 84.13           C  
ATOM    573  O   LYS    75      56.806  45.804  79.884  1.00 84.52           O  
ATOM    574  CB  LYS    75      56.204  48.901  78.934  1.00 83.86           C  
ATOM    575  CG  LYS    75      55.928  48.865  80.430  1.00 82.95           C  
ATOM    576  CD  LYS    75      55.774  50.284  81.001  1.00 84.90           C  
ATOM    577  CE  LYS    75      54.739  51.138  80.243  1.00 85.04           C  
ATOM    578  NZ  LYS    75      54.903  52.621  80.465  1.00 83.14           N  
ATOM    579  N   VAL    76      55.281  45.940  78.215  1.00 82.84           N  
ATOM    580  CA  VAL    76      54.563  44.703  78.540  1.00 80.09           C  
ATOM    581  C   VAL    76      55.294  43.546  77.868  1.00 80.15           C  
ATOM    582  O   VAL    76      55.431  42.451  78.423  1.00 78.85           O  
ATOM    583  CB  VAL    76      53.117  44.772  78.012  1.00 79.09           C  
ATOM    584  CG1 VAL    76      52.404  43.439  78.209  1.00 76.50           C  
ATOM    585  CG2 VAL    76      52.378  45.890  78.723  1.00 78.24           C  
ATOM    586  N   SER    77      55.766  43.823  76.661  1.00 80.38           N  
ATOM    587  CA  SER    77      56.513  42.862  75.873  1.00 81.49           C  
ATOM    588  C   SER    77      57.659  42.250  76.676  1.00 82.91           C  
ATOM    589  O   SER    77      57.655  41.050  76.962  1.00 83.81           O  
ATOM    590  CB  SER    77      57.058  43.547  74.619  1.00 80.41           C  
ATOM    591  OG  SER    77      58.246  42.925  74.183  1.00 79.27           O  
ATOM    592  N   ASP    78      58.634  43.079  77.043  1.00 84.30           N  
ATOM    593  CA  ASP    78      59.801  42.623  77.809  1.00 84.85           C  
ATOM    594  C   ASP    78      59.458  42.063  79.190  1.00 83.83           C  
ATOM    595  O   ASP    78      60.314  41.480  79.857  1.00 84.23           O  
ATOM    596  CB  ASP    78      60.859  43.756  77.933  1.00 85.87           C  
ATOM    597  CG  ASP    78      60.339  45.007  78.661  1.00 86.65           C  
ATOM    598  OD1 ASP    78      61.067  46.029  78.662  1.00 85.97           O  
ATOM    599  OD2 ASP    78      59.222  44.977  79.236  1.00 88.00           O  
ATOM    600  N   TRP    79      58.209  42.238  79.617  1.00 82.60           N  
ATOM    601  CA  TRP    79      57.786  41.726  80.919  1.00 81.42           C  
ATOM    602  C   TRP    79      57.365  40.270  80.794  1.00 81.65           C  
ATOM    603  O   TRP    79      57.804  39.413  81.565  1.00 81.76           O  
ATOM    604  CB  TRP    79      56.614  42.533  81.494  1.00 78.42           C  
ATOM    605  CG  TRP    79      55.969  41.841  82.677  1.00 75.56           C  
ATOM    606  CD1 TRP    79      54.757  41.201  82.696  1.00 74.82           C  
ATOM    607  CD2 TRP    79      56.530  41.668  83.987  1.00 74.54           C  
ATOM    608  NE1 TRP    79      54.531  40.640  83.935  1.00 73.22           N  
ATOM    609  CE2 TRP    79      55.604  40.908  84.744  1.00 73.62           C  
ATOM    610  CE3 TRP    79      57.729  42.075  84.595  1.00 73.64           C  
ATOM    611  CZ2 TRP    79      55.840  40.551  86.076  1.00 73.23           C  
ATOM    612  CZ3 TRP    79      57.961  41.716  85.926  1.00 72.07           C  
ATOM    613  CH2 TRP    79      57.021  40.961  86.645  1.00 72.33           C  
ATOM    614  N   LEU    80      56.502  39.997  79.822  1.00 81.35           N  
ATOM    615  CA  LEU    80      56.031  38.642  79.600  1.00 81.36           C  
ATOM    616  C   LEU    80      57.241  37.718  79.416  1.00 82.75           C  
ATOM    617  O   LEU    80      57.155  36.504  79.627  1.00 83.71           O  
ATOM    618  CB  LEU    80      55.126  38.608  78.372  1.00 78.55           C  
ATOM    619  CG  LEU    80      53.850  39.439  78.489  1.00 76.59           C  
ATOM    620  CD1 LEU    80      53.063  39.292  77.219  1.00 75.59           C  
ATOM    621  CD2 LEU    80      53.016  38.984  79.672  1.00 75.73           C  
ATOM    622  N   GLU    81      58.368  38.314  79.035  1.00 83.30           N  
ATOM    623  CA  GLU    81      59.611  37.592  78.827  1.00 83.18           C  
ATOM    624  C   GLU    81      60.227  37.194  80.150  1.00 83.96           C  
ATOM    625  O   GLU    81      60.591  36.040  80.354  1.00 83.28           O  
ATOM    626  CB  GLU    81      60.582  38.471  78.056  1.00 82.96           C  
ATOM    627  CG  GLU    81      60.260  38.530  76.601  1.00 83.91           C  
ATOM    628  CD  GLU    81      60.479  37.192  75.946  1.00 85.26           C  
ATOM    629  OE1 GLU    81      59.857  36.937  74.897  1.00 86.78           O  
ATOM    630  OE2 GLU    81      61.287  36.395  76.476  1.00 85.66           O  
ATOM    631  N   GLU    82      60.347  38.163  81.047  1.00 86.15           N  
ATOM    632  CA  GLU    82      60.911  37.912  82.360  1.00 89.31           C  
ATOM    633  C   GLU    82      60.109  36.816  83.058  1.00 91.08           C  
ATOM    634  O   GLU    82      60.662  36.018  83.811  1.00 90.62           O  
ATOM    635  CB  GLU    82      60.902  39.204  83.184  1.00 90.62           C  
ATOM    636  CG  GLU    82      61.229  39.021  84.663  1.00 92.96           C  
ATOM    637  CD  GLU    82      61.320  40.345  85.414  1.00 94.03           C  
ATOM    638  OE1 GLU    82      61.342  40.322  86.664  1.00 93.95           O  
ATOM    639  OE2 GLU    82      61.380  41.404  84.751  1.00 94.64           O  
ATOM    640  N   LEU    83      58.806  36.778  82.793  1.00 93.88           N  
ATOM    641  CA  LEU    83      57.914  35.771  83.373  1.00 96.03           C  
ATOM    642  C   LEU    83      57.913  34.522  82.495  1.00 97.28           C  
ATOM    643  O   LEU    83      57.220  33.550  82.785  1.00 97.42           O  
ATOM    644  CB  LEU    83      56.483  36.321  83.482  1.00 96.66           C  
ATOM    645  CG  LEU    83      55.888  36.711  84.846  1.00 97.05           C  
ATOM    646  CD1 LEU    83      55.599  35.465  85.651  1.00 97.35           C  
ATOM    647  CD2 LEU    83      56.836  37.626  85.602  1.00 98.25           C  
ATOM    648  N   HIS    84      58.693  34.565  81.420  1.00 99.41           N  
ATOM    649  CA  HIS    84      58.795  33.446  80.497  1.00101.32           C  
ATOM    650  C   HIS    84      57.437  32.991  80.006  1.00101.97           C  
ATOM    651  O   HIS    84      56.693  32.320  80.717  1.00102.24           O  
ATOM    652  CB  HIS    84      59.510  32.281  81.171  1.00103.74           C  
ATOM    653  CG  HIS    84      60.999  32.337  81.057  1.00106.67           C  
ATOM    654  ND1 HIS    84      61.839  32.019  82.103  1.00107.68           N  
ATOM    655  CD2 HIS    84      61.802  32.627  80.004  1.00107.80           C  
ATOM    656  CE1 HIS    84      63.094  32.107  81.701  1.00108.75           C  
ATOM    657  NE2 HIS    84      63.099  32.474  80.430  1.00109.14           N  
ATOM    658  N   VAL    85      57.117  33.366  78.778  1.00102.41           N  
ATOM    659  CA  VAL    85      55.851  32.991  78.173  1.00103.08           C  
ATOM    660  C   VAL    85      56.083  32.747  76.687  1.00103.80           C  
ATOM    661  O   VAL    85      56.294  33.689  75.927  1.00103.96           O  
ATOM    662  CB  VAL    85      54.799  34.106  78.368  1.00102.69           C  
ATOM    663  CG1 VAL    85      53.555  33.804  77.552  1.00102.21           C  
ATOM    664  CG2 VAL    85      54.442  34.222  79.837  1.00102.22           C  
ATOM    665  N   GLU    86      56.064  31.478  76.288  1.00104.39           N  
ATOM    666  CA  GLU    86      56.275  31.101  74.893  1.00105.44           C  
ATOM    667  C   GLU    86      55.646  32.116  73.959  1.00105.44           C  
ATOM    668  O   GLU    86      54.465  32.437  74.093  1.00106.40           O  
ATOM    669  CB  GLU    86      55.662  29.728  74.605  1.00106.95           C  
ATOM    670  CG  GLU    86      56.591  28.535  74.806  1.00107.43           C  
ATOM    671  CD  GLU    86      55.898  27.201  74.536  1.00107.73           C  
ATOM    672  OE1 GLU    86      55.252  27.052  73.474  1.00107.83           O  
ATOM    673  OE2 GLU    86      56.008  26.295  75.387  1.00108.14           O  
ATOM    674  N   GLU    87      56.432  32.616  73.011  1.00104.19           N  
ATOM    675  CA  GLU    87      55.925  33.590  72.056  1.00103.36           C  
ATOM    676  C   GLU    87      54.598  33.093  71.496  1.00102.82           C  
ATOM    677  O   GLU    87      53.759  33.882  71.068  1.00102.80           O  
ATOM    678  CB  GLU    87      56.909  33.780  70.904  1.00103.37           C  
ATOM    679  CG  GLU    87      56.454  34.829  69.898  1.00103.61           C  
ATOM    680  CD  GLU    87      57.228  34.789  68.595  1.00103.62           C  
ATOM    681  OE1 GLU    87      57.014  35.697  67.760  1.00103.68           O  
ATOM    682  OE2 GLU    87      58.038  33.853  68.403  1.00102.59           O  
ATOM    683  N   GLU    88      54.421  31.775  71.503  1.00101.96           N  
ATOM    684  CA  GLU    88      53.207  31.159  70.989  1.00101.12           C  
ATOM    685  C   GLU    88      51.974  31.695  71.713  1.00100.67           C  
ATOM    686  O   GLU    88      50.877  31.753  71.145  1.00101.54           O  
ATOM    687  CB  GLU    88      53.293  29.638  71.136  1.00100.80           C  
ATOM    688  CG  GLU    88      52.205  28.874  70.398  1.00 99.08           C  
ATOM    689  CD  GLU    88      52.751  27.672  69.648  1.00 98.05           C  
ATOM    690  OE1 GLU    88      53.387  26.802  70.285  1.00 97.31           O  
ATOM    691  OE2 GLU    88      52.535  27.597  68.421  1.00 96.89           O  
ATOM    692  N   GLU    89      52.159  32.094  72.967  1.00 98.71           N  
ATOM    693  CA  GLU    89      51.064  32.636  73.761  1.00 97.39           C  
ATOM    694  C   GLU    89      51.198  34.140  73.932  1.00 95.84           C  
ATOM    695  O   GLU    89      50.231  34.885  73.783  1.00 95.67           O  
ATOM    696  CB  GLU    89      51.022  31.957  75.130  1.00 97.85           C  
ATOM    697  CG  GLU    89      50.325  30.613  75.103  1.00 99.04           C  
ATOM    698  CD  GLU    89      50.149  29.999  76.478  1.00100.11           C  
ATOM    699  OE1 GLU    89      49.444  28.970  76.573  1.00101.59           O  
ATOM    700  OE2 GLU    89      50.717  30.529  77.461  1.00100.07           O  
ATOM    701  N   SER    90      52.414  34.570  74.244  1.00 93.98           N  
ATOM    702  CA  SER    90      52.719  35.974  74.447  1.00 91.31           C  
ATOM    703  C   SER    90      52.270  36.802  73.254  1.00 89.60           C  
ATOM    704  O   SER    90      51.670  37.861  73.401  1.00 88.42           O  
ATOM    705  CB  SER    90      54.220  36.138  74.659  1.00 90.94           C  
ATOM    706  OG  SER    90      54.531  37.471  74.991  1.00 92.54           O  
ATOM    707  N   LYS    91      52.567  36.305  72.066  1.00 88.76           N  
ATOM    708  CA  LYS    91      52.185  36.999  70.847  1.00 89.03           C  
ATOM    709  C   LYS    91      50.673  37.271  70.849  1.00 87.86           C  
ATOM    710  O   LYS    91      50.205  38.220  70.212  1.00 88.17           O  
ATOM    711  CB  LYS    91      52.576  36.150  69.624  1.00 89.63           C  
ATOM    712  CG  LYS    91      52.492  36.854  68.265  1.00 90.92           C  
ATOM    713  CD  LYS    91      53.587  37.910  68.079  1.00 90.23           C  
ATOM    714  CE  LYS    91      53.658  38.338  66.628  1.00 88.60           C  
ATOM    715  NZ  LYS    91      53.807  37.130  65.764  1.00 86.94           N  
ATOM    716  N   HIS    92      49.919  36.448  71.578  1.00 85.83           N  
ATOM    717  CA  HIS    92      48.453  36.571  71.658  1.00 83.02           C  
ATOM    718  C   HIS    92      48.032  37.435  72.824  1.00 81.96           C  
ATOM    719  O   HIS    92      47.025  38.143  72.755  1.00 81.68           O  
ATOM    720  CB  HIS    92      47.817  35.191  71.840  1.00 81.86           C  
ATOM    721  CG  HIS    92      46.321  35.184  71.732  1.00 80.25           C  
ATOM    722  ND1 HIS    92      45.557  34.099  72.113  1.00 79.61           N  
ATOM    723  CD2 HIS    92      45.458  36.100  71.239  1.00 79.93           C  
ATOM    724  CE1 HIS    92      44.286  34.351  71.857  1.00 78.84           C  
ATOM    725  NE2 HIS    92      44.196  35.555  71.325  1.00 80.02           N  
ATOM    726  N   VAL    93      48.798  37.349  73.905  1.00 81.14           N  
ATOM    727  CA  VAL    93      48.507  38.123  75.093  1.00 79.89           C  
ATOM    728  C   VAL    93      48.728  39.585  74.777  1.00 79.26           C  
ATOM    729  O   VAL    93      47.782  40.359  74.726  1.00 79.67           O  
ATOM    730  CB  VAL    93      49.407  37.712  76.278  1.00 79.74           C  
ATOM    731  CG1 VAL    93      49.230  38.699  77.421  1.00 79.38           C  
ATOM    732  CG2 VAL    93      49.063  36.298  76.742  1.00 77.99           C  
ATOM    733  N   LEU    94      49.971  39.969  74.528  1.00 78.44           N  
ATOM    734  CA  LEU    94      50.219  41.369  74.237  1.00 77.24           C  
ATOM    735  C   LEU    94      49.584  41.790  72.924  1.00 76.74           C  
ATOM    736  O   LEU    94      49.775  42.910  72.465  1.00 77.69           O  
ATOM    737  CB  LEU    94      51.716  41.678  74.217  1.00 75.64           C  
ATOM    738  CG  LEU    94      52.472  41.454  72.923  1.00 73.82           C  
ATOM    739  CD1 LEU    94      53.249  42.716  72.621  1.00 73.77           C  
ATOM    740  CD2 LEU    94      53.382  40.244  73.032  1.00 73.03           C  
ATOM    741  N   HIS    95      48.822  40.898  72.315  1.00 76.14           N  
ATOM    742  CA  HIS    95      48.185  41.242  71.060  1.00 75.94           C  
ATOM    743  C   HIS    95      46.935  42.046  71.368  1.00 76.07           C  
ATOM    744  O   HIS    95      46.907  43.256  71.146  1.00 76.24           O  
ATOM    745  CB  HIS    95      47.840  39.973  70.290  1.00 76.81           C  
ATOM    746  CG  HIS    95      47.133  40.217  68.994  1.00 77.40           C  
ATOM    747  ND1 HIS    95      47.681  40.955  67.967  1.00 77.15           N  
ATOM    748  CD2 HIS    95      45.931  39.783  68.545  1.00 78.36           C  
ATOM    749  CE1 HIS    95      46.849  40.963  66.940  1.00 76.73           C  
ATOM    750  NE2 HIS    95      45.780  40.259  67.266  1.00 77.49           N  
ATOM    751  N   ILE    96      45.913  41.385  71.906  1.00 76.13           N  
ATOM    752  CA  ILE    96      44.657  42.062  72.239  1.00 75.31           C  
ATOM    753  C   ILE    96      44.873  43.315  73.095  1.00 74.93           C  
ATOM    754  O   ILE    96      44.071  44.258  73.064  1.00 73.06           O  
ATOM    755  CB  ILE    96      43.658  41.069  72.918  1.00 75.29           C  
ATOM    756  CG1 ILE    96      44.343  40.261  74.013  1.00 74.28           C  
ATOM    757  CG2 ILE    96      43.108  40.102  71.872  1.00 75.72           C  
ATOM    758  CD1 ILE    96      43.480  39.134  74.559  1.00 72.10           C  
ATOM    759  N   ILE    97      45.986  43.319  73.827  1.00 75.18           N  
ATOM    760  CA  ILE    97      46.389  44.434  74.688  1.00 74.43           C  
ATOM    761  C   ILE    97      46.576  45.668  73.806  1.00 75.89           C  
ATOM    762  O   ILE    97      46.797  46.778  74.298  1.00 75.02           O  
ATOM    763  CB  ILE    97      47.732  44.127  75.385  1.00 72.70           C  
ATOM    764  CG1 ILE    97      47.703  44.579  76.831  1.00 70.67           C  
ATOM    765  CG2 ILE    97      48.869  44.845  74.674  1.00 73.04           C  
ATOM    766  CD1 ILE    97      48.921  44.134  77.596  1.00 68.87           C  
ATOM    767  N   ALA    98      46.514  45.457  72.496  1.00 77.45           N  
ATOM    768  CA  ALA    98      46.651  46.552  71.556  1.00 78.57           C  
ATOM    769  C   ALA    98      45.261  47.081  71.291  1.00 79.91           C  
ATOM    770  O   ALA    98      45.035  48.283  71.347  1.00 79.61           O  
ATOM    771  CB  ALA    98      47.285  46.072  70.272  1.00 77.97           C  
ATOM    772  N   ASN    99      44.325  46.173  71.027  1.00 82.07           N  
ATOM    773  CA  ASN    99      42.948  46.565  70.756  1.00 84.96           C  
ATOM    774  C   ASN    99      42.176  46.845  72.037  1.00 87.38           C  
ATOM    775  O   ASN    99      40.989  46.530  72.143  1.00 88.24           O  
ATOM    776  CB  ASN    99      42.228  45.489  69.935  1.00 84.22           C  
ATOM    777  CG  ASN    99      42.836  45.307  68.549  1.00 83.98           C  
ATOM    778  OD1 ASN    99      44.021  44.983  68.415  1.00 83.25           O  
ATOM    779  ND2 ASN    99      42.025  45.513  67.511  1.00 81.06           N  
ATOM    780  N   MET   100      42.862  47.446  73.004  1.00 90.07           N  
ATOM    781  CA  MET   100      42.257  47.791  74.289  1.00 92.39           C  
ATOM    782  C   MET   100      42.343  49.301  74.530  1.00 92.50           C  
ATOM    783  O   MET   100      42.370  49.760  75.676  1.00 92.32           O  
ATOM    784  CB  MET   100      42.967  47.035  75.423  1.00 94.34           C  
ATOM    785  CG  MET   100      42.676  45.532  75.458  1.00 96.06           C  
ATOM    786  SD  MET   100      40.983  45.046  76.295  1.00 99.14          SE  
ATOM    787  CE  MET   100      39.749  45.527  74.858  1.00 97.67           C  
ATOM    788  N   SER   112      38.959  36.828  67.887  1.00 57.10           N  
ATOM    789  CA  SER   112      39.634  36.118  68.979  1.00 59.32           C  
ATOM    790  C   SER   112      38.736  36.002  70.202  1.00 60.76           C  
ATOM    791  O   SER   112      38.458  37.004  70.851  1.00 62.84           O  
ATOM    792  CB  SER   112      40.914  36.850  69.394  1.00 57.29           C  
ATOM    793  OG  SER   112      41.423  36.300  70.601  1.00 54.81           O  
ATOM    794  N   ILE   113      38.304  34.799  70.559  1.00 61.84           N  
ATOM    795  CA  ILE   113      37.421  34.685  71.716  1.00 62.69           C  
ATOM    796  C   ILE   113      38.045  35.210  73.012  1.00 63.64           C  
ATOM    797  O   ILE   113      37.364  35.889  73.786  1.00 63.10           O  
ATOM    798  CB  ILE   113      36.965  33.242  71.943  1.00 63.08           C  
ATOM    799  CG1 ILE   113      36.063  33.196  73.180  1.00 63.17           C  
ATOM    800  CG2 ILE   113      38.181  32.327  72.026  1.00 63.80           C  
ATOM    801  CD1 ILE   113      35.669  31.819  73.639  1.00 62.87           C  
ATOM    802  N   GLU   114      39.324  34.892  73.250  1.00 65.08           N  
ATOM    803  CA  GLU   114      40.043  35.354  74.452  1.00 65.77           C  
ATOM    804  C   GLU   114      39.957  36.873  74.550  1.00 66.36           C  
ATOM    805  O   GLU   114      39.483  37.427  75.541  1.00 65.62           O  
ATOM    806  CB  GLU   114      41.525  34.960  74.401  1.00 65.57           C  
ATOM    807  CG  GLU   114      41.818  33.531  74.807  1.00 66.83           C  
ATOM    808  CD  GLU   114      41.458  32.527  73.735  1.00 68.23           C  
ATOM    809  OE1 GLU   114      41.516  31.311  74.032  1.00 66.45           O  
ATOM    810  OE2 GLU   114      41.129  32.948  72.599  1.00 69.55           O  
ATOM    811  N   GLY   115      40.445  37.545  73.515  1.00 67.29           N  
ATOM    812  CA  GLY   115      40.381  38.986  73.507  1.00 67.99           C  
ATOM    813  C   GLY   115      38.932  39.421  73.621  1.00 68.41           C  
ATOM    814  O   GLY   115      38.577  40.184  74.520  1.00 68.71           O  
ATOM    815  N   LYS   116      38.088  38.928  72.717  1.00 67.73           N  
ATOM    816  CA  LYS   116      36.676  39.295  72.725  1.00 68.55           C  
ATOM    817  C   LYS   116      36.142  39.342  74.152  1.00 67.58           C  
ATOM    818  O   LYS   116      35.397  40.260  74.501  1.00 68.88           O  
ATOM    819  CB  LYS   116      35.850  38.304  71.896  1.00 70.78           C  
ATOM    820  CG  LYS   116      34.942  38.966  70.849  1.00 74.29           C  
ATOM    821  CD  LYS   116      34.999  38.257  69.475  1.00 76.23           C  
ATOM    822  CE  LYS   116      34.254  36.908  69.463  1.00 76.64           C  
ATOM    823  NZ  LYS   116      34.420  36.133  68.187  1.00 74.59           N  
ATOM    824  N   LEU   117      36.529  38.374  74.982  1.00 64.19           N  
ATOM    825  CA  LEU   117      36.051  38.360  76.354  1.00 61.91           C  
ATOM    826  C   LEU   117      36.650  39.489  77.175  1.00 60.71           C  
ATOM    827  O   LEU   117      35.931  40.196  77.880  1.00 61.82           O  
ATOM    828  CB  LEU   117      36.324  37.004  77.025  1.00 61.68           C  
ATOM    829  CG  LEU   117      35.241  35.918  76.889  1.00 59.80           C  
ATOM    830  CD1 LEU   117      35.774  34.582  77.382  1.00 58.70           C  
ATOM    831  CD2 LEU   117      34.014  36.330  77.675  1.00 57.44           C  
ATOM    832  N   VAL   118      37.959  39.680  77.086  1.00 59.23           N  
ATOM    833  CA  VAL   118      38.593  40.756  77.852  1.00 58.13           C  
ATOM    834  C   VAL   118      37.867  42.074  77.558  1.00 56.86           C  
ATOM    835  O   VAL   118      37.543  42.838  78.467  1.00 55.82           O  
ATOM    836  CB  VAL   118      40.100  40.883  77.497  1.00 57.81           C  
ATOM    837  CG1 VAL   118      40.729  42.049  78.244  1.00 54.91           C  
ATOM    838  CG2 VAL   118      40.816  39.593  77.865  1.00 57.70           C  
ATOM    839  N   GLN   119      37.587  42.316  76.282  1.00 56.53           N  
ATOM    840  CA  GLN   119      36.904  43.526  75.888  1.00 55.92           C  
ATOM    841  C   GLN   119      35.482  43.600  76.426  1.00 56.24           C  
ATOM    842  O   GLN   119      34.946  44.678  76.659  1.00 56.85           O  
ATOM    843  CB  GLN   119      36.870  43.658  74.377  1.00 55.08           C  
ATOM    844  CG  GLN   119      36.385  45.025  74.002  1.00 55.59           C  
ATOM    845  CD  GLN   119      36.033  45.149  72.553  1.00 55.03           C  
ATOM    846  OE1 GLN   119      35.347  44.296  71.979  1.00 54.08           O  
ATOM    847  NE2 GLN   119      36.467  46.238  71.952  1.00 55.26           N  
ATOM    848  N   ASP   120      34.854  42.454  76.604  1.00 57.25           N  
ATOM    849  CA  ASP   120      33.502  42.449  77.132  1.00 60.27           C  
ATOM    850  C   ASP   120      33.568  42.669  78.625  1.00 61.61           C  
ATOM    851  O   ASP   120      32.614  43.139  79.248  1.00 62.29           O  
ATOM    852  CB  ASP   120      32.821  41.116  76.853  1.00 61.47           C  
ATOM    853  CG  ASP   120      32.345  40.999  75.430  1.00 61.45           C  
ATOM    854  OD1 ASP   120      32.070  39.857  75.010  1.00 59.82           O  
ATOM    855  OD2 ASP   120      32.236  42.048  74.744  1.00 62.95           O  
ATOM    856  N   ALA   121      34.710  42.315  79.202  1.00 62.86           N  
ATOM    857  CA  ALA   121      34.915  42.460  80.638  1.00 62.04           C  
ATOM    858  C   ALA   121      35.373  43.874  80.992  1.00 61.35           C  
ATOM    859  O   ALA   121      35.353  44.259  82.157  1.00 61.64           O  
ATOM    860  CB  ALA   121      35.945  41.430  81.125  1.00 61.68           C  
ATOM    861  N   ASP   122      35.783  44.646  79.991  1.00 60.20           N  
ATOM    862  CA  ASP   122      36.239  45.997  80.252  1.00 58.88           C  
ATOM    863  C   ASP   122      35.129  47.005  80.018  1.00 58.34           C  
ATOM    864  O   ASP   122      34.922  47.932  80.811  1.00 58.31           O  
ATOM    865  CB  ASP   122      37.441  46.333  79.375  1.00 57.59           C  
ATOM    866  CG  ASP   122      38.015  47.694  79.689  1.00 57.97           C  
ATOM    867  OD1 ASP   122      38.353  47.940  80.871  1.00 57.45           O  
ATOM    868  OD2 ASP   122      38.132  48.515  78.756  1.00 57.32           O  
ATOM    869  N   ARG   123      34.411  46.811  78.921  1.00 57.56           N  
ATOM    870  CA  ARG   123      33.309  47.691  78.559  1.00 56.52           C  
ATOM    871  C   ARG   123      32.165  47.562  79.589  1.00 55.47           C  
ATOM    872  O   ARG   123      31.511  48.560  79.932  1.00 54.82           O  
ATOM    873  CB  ARG   123      32.843  47.338  77.143  1.00 56.70           C  
ATOM    874  CG  ARG   123      31.968  48.376  76.471  1.00 58.83           C  
ATOM    875  CD  ARG   123      32.384  48.557  75.017  1.00 61.07           C  
ATOM    876  NE  ARG   123      32.644  47.274  74.373  1.00 62.11           N  
ATOM    877  CZ  ARG   123      32.703  47.082  73.059  1.00 61.15           C  
ATOM    878  NH1 ARG   123      32.944  45.868  72.581  1.00 61.50           N  
ATOM    879  NH2 ARG   123      32.511  48.090  72.225  1.00 58.51           N  
ATOM    880  N   LEU   124      31.941  46.350  80.104  1.00 54.11           N  
ATOM    881  CA  LEU   124      30.896  46.131  81.105  1.00 51.92           C  
ATOM    882  C   LEU   124      31.148  47.001  82.317  1.00 51.73           C  
ATOM    883  O   LEU   124      30.214  47.406  83.007  1.00 51.27           O  
ATOM    884  CB  LEU   124      30.880  44.678  81.544  1.00 50.85           C  
ATOM    885  CG  LEU   124      30.032  43.787  80.645  1.00 51.38           C  
ATOM    886  CD1 LEU   124      30.293  42.316  80.956  1.00 50.94           C  
ATOM    887  CD2 LEU   124      28.577  44.143  80.849  1.00 49.72           C  
ATOM    888  N   ASP   125      32.424  47.285  82.560  1.00 51.24           N  
ATOM    889  CA  ASP   125      32.830  48.101  83.687  1.00 50.23           C  
ATOM    890  C   ASP   125      32.632  49.581  83.420  1.00 49.42           C  
ATOM    891  O   ASP   125      33.531  50.385  83.651  1.00 49.77           O  
ATOM    892  CB  ASP   125      34.295  47.863  84.029  1.00 51.02           C  
ATOM    893  CG  ASP   125      34.650  48.394  85.397  1.00 52.34           C  
ATOM    894  OD1 ASP   125      33.987  47.955  86.362  1.00 56.39           O  
ATOM    895  OD2 ASP   125      35.564  49.241  85.518  1.00 49.41           O  
ATOM    896  N   ALA   126      31.456  49.945  82.933  1.00 47.73           N  
ATOM    897  CA  ALA   126      31.161  51.342  82.657  1.00 45.55           C  
ATOM    898  C   ALA   126      29.703  51.539  82.977  1.00 44.60           C  
ATOM    899  O   ALA   126      29.257  52.637  83.286  1.00 43.98           O  
ATOM    900  CB  ALA   126      31.418  51.650  81.201  1.00 45.25           C  
ATOM    901  N   LEU   127      28.971  50.437  82.901  1.00 44.50           N  
ATOM    902  CA  LEU   127      27.550  50.432  83.169  1.00 44.06           C  
ATOM    903  C   LEU   127      27.252  49.953  84.590  1.00 44.95           C  
ATOM    904  O   LEU   127      28.095  49.325  85.245  1.00 43.80           O  
ATOM    905  CB  LEU   127      26.841  49.519  82.164  1.00 43.33           C  
ATOM    906  CG  LEU   127      27.475  49.317  80.788  1.00 42.79           C  
ATOM    907  CD1 LEU   127      26.669  48.317  79.945  1.00 43.58           C  
ATOM    908  CD2 LEU   127      27.544  50.640  80.104  1.00 43.48           C  
ATOM    909  N   GLY   128      26.032  50.251  85.045  1.00 46.01           N  
ATOM    910  CA  GLY   128      25.584  49.861  86.369  1.00 45.61           C  
ATOM    911  C   GLY   128      25.827  50.923  87.429  1.00 46.73           C  
ATOM    912  O   GLY   128      26.403  51.982  87.157  1.00 44.35           O  
ATOM    913  N   ALA   129      25.389  50.628  88.650  1.00 47.54           N  
ATOM    914  CA  ALA   129      25.548  51.543  89.771  1.00 48.07           C  
ATOM    915  C   ALA   129      26.857  52.344  89.684  1.00 48.83           C  
ATOM    916  O   ALA   129      26.833  53.582  89.658  1.00 48.08           O  
ATOM    917  CB  ALA   129      25.492  50.767  91.077  1.00 48.05           C  
ATOM    918  N   ILE   130      27.985  51.630  89.636  1.00 48.24           N  
ATOM    919  CA  ILE   130      29.327  52.230  89.554  1.00 47.30           C  
ATOM    920  C   ILE   130      29.369  53.329  88.473  1.00 47.59           C  
ATOM    921  O   ILE   130      29.910  54.427  88.685  1.00 44.81           O  
ATOM    922  CB  ILE   130      30.424  51.139  89.205  1.00 48.89           C  
ATOM    923  CG1 ILE   130      30.141  49.831  89.950  1.00 49.53           C  
ATOM    924  CG2 ILE   130      31.830  51.641  89.589  1.00 45.74           C  
ATOM    925  CD1 ILE   130      30.215  49.947  91.467  1.00 51.75           C  
ATOM    926  N   GLY   131      28.805  53.002  87.307  1.00 45.61           N  
ATOM    927  CA  GLY   131      28.772  53.930  86.193  1.00 42.79           C  
ATOM    928  C   GLY   131      28.065  55.184  86.639  1.00 42.69           C  
ATOM    929  O   GLY   131      28.633  56.273  86.607  1.00 44.79           O  
ATOM    930  N   ILE   132      26.814  55.024  87.052  1.00 39.40           N  
ATOM    931  CA  ILE   132      26.030  56.134  87.548  1.00 36.25           C  
ATOM    932  C   ILE   132      26.952  56.971  88.421  1.00 34.92           C  
ATOM    933  O   ILE   132      27.177  58.146  88.147  1.00 33.86           O  
ATOM    934  CB  ILE   132      24.839  55.603  88.382  1.00 37.08           C  
ATOM    935  CG1 ILE   132      23.862  54.843  87.450  1.00 36.45           C  
ATOM    936  CG2 ILE   132      24.165  56.750  89.116  1.00 35.44           C  
ATOM    937  CD1 ILE   132      22.927  53.793  88.117  1.00 31.47           C  
ATOM    938  N   ALA   133      27.519  56.356  89.450  1.00 34.40           N  
ATOM    939  CA  ALA   133      28.409  57.091  90.334  1.00 34.98           C  
ATOM    940  C   ALA   133      29.565  57.665  89.570  1.00 35.23           C  
ATOM    941  O   ALA   133      29.783  58.866  89.593  1.00 36.54           O  
ATOM    942  CB  ALA   133      28.927  56.206  91.452  1.00 34.14           C  
ATOM    943  N   ARG   134      30.317  56.829  88.876  1.00 37.81           N  
ATOM    944  CA  ARG   134      31.453  57.379  88.162  1.00 40.15           C  
ATOM    945  C   ARG   134      31.059  58.655  87.445  1.00 40.66           C  
ATOM    946  O   ARG   134      31.816  59.617  87.417  1.00 41.81           O  
ATOM    947  CB  ARG   134      31.995  56.387  87.155  1.00 40.18           C  
ATOM    948  CG  ARG   134      33.352  56.763  86.627  1.00 39.20           C  
ATOM    949  CD  ARG   134      33.867  55.598  85.817  1.00 41.48           C  
ATOM    950  NE  ARG   134      33.855  54.382  86.635  1.00 43.84           N  
ATOM    951  CZ  ARG   134      33.340  53.210  86.258  1.00 45.16           C  
ATOM    952  NH1 ARG   134      32.780  53.062  85.059  1.00 45.26           N  
ATOM    953  NH2 ARG   134      33.388  52.176  87.086  1.00 46.42           N  
ATOM    954  N   THR   135      29.847  58.671  86.908  1.00 42.14           N  
ATOM    955  CA  THR   135      29.369  59.829  86.170  1.00 45.26           C  
ATOM    956  C   THR   135      29.187  61.097  87.012  1.00 45.20           C  
ATOM    957  O   THR   135      29.945  62.055  86.863  1.00 45.50           O  
ATOM    958  CB  THR   135      28.060  59.506  85.414  1.00 44.86           C  
ATOM    959  OG1 THR   135      28.067  58.130  85.011  1.00 43.34           O  
ATOM    960  CG2 THR   135      27.973  60.353  84.154  1.00 44.82           C  
ATOM    961  N   PHE   136      28.190  61.126  87.881  1.00 45.77           N  
ATOM    962  CA  PHE   136      27.988  62.308  88.704  1.00 46.48           C  
ATOM    963  C   PHE   136      29.284  62.731  89.370  1.00 47.76           C  
ATOM    964  O   PHE   136      29.530  63.929  89.577  1.00 48.36           O  
ATOM    965  CB  PHE   136      26.929  62.014  89.733  1.00 45.24           C  
ATOM    966  CG  PHE   136      25.622  61.677  89.126  1.00 46.87           C  
ATOM    967  CD1 PHE   136      24.916  62.640  88.430  1.00 47.75           C  
ATOM    968  CD2 PHE   136      25.086  60.410  89.247  1.00 45.51           C  
ATOM    969  CE1 PHE   136      23.689  62.353  87.877  1.00 46.20           C  
ATOM    970  CE2 PHE   136      23.853  60.117  88.693  1.00 45.51           C  
ATOM    971  CZ  PHE   136      23.157  61.086  88.009  1.00 44.96           C  
ATOM    972  N   ALA   137      30.119  61.743  89.688  1.00 49.37           N  
ATOM    973  CA  ALA   137      31.420  61.968  90.324  1.00 51.50           C  
ATOM    974  C   ALA   137      32.296  62.790  89.398  1.00 53.58           C  
ATOM    975  O   ALA   137      32.780  63.855  89.764  1.00 52.21           O  
ATOM    976  CB  ALA   137      32.089  60.637  90.602  1.00 52.06           C  
ATOM    977  N   TYR   138      32.506  62.264  88.196  1.00 56.04           N  
ATOM    978  CA  TYR   138      33.296  62.949  87.197  1.00 59.10           C  
ATOM    979  C   TYR   138      32.643  64.314  86.928  1.00 59.88           C  
ATOM    980  O   TYR   138      33.323  65.311  86.634  1.00 60.01           O  
ATOM    981  CB  TYR   138      33.335  62.106  85.930  1.00 63.06           C  
ATOM    982  CG  TYR   138      33.831  62.848  84.719  1.00 67.74           C  
ATOM    983  CD1 TYR   138      35.121  63.388  84.690  1.00 69.38           C  
ATOM    984  CD2 TYR   138      33.009  63.012  83.598  1.00 69.52           C  
ATOM    985  CE1 TYR   138      35.587  64.080  83.575  1.00 71.49           C  
ATOM    986  CE2 TYR   138      33.460  63.700  82.479  1.00 72.75           C  
ATOM    987  CZ  TYR   138      34.758  64.232  82.473  1.00 72.75           C  
ATOM    988  OH  TYR   138      35.220  64.911  81.368  1.00 72.46           O  
ATOM    989  N   GLY   139      31.315  64.348  87.042  1.00 59.18           N  
ATOM    990  CA  GLY   139      30.574  65.580  86.835  1.00 58.31           C  
ATOM    991  C   GLY   139      30.938  66.600  87.894  1.00 58.19           C  
ATOM    992  O   GLY   139      31.200  67.763  87.589  1.00 57.28           O  
ATOM    993  N   GLY   140      30.954  66.162  89.147  1.00 57.97           N  
ATOM    994  CA  GLY   140      31.320  67.059  90.225  1.00 59.09           C  
ATOM    995  C   GLY   140      32.691  67.676  90.016  1.00 59.07           C  
ATOM    996  O   GLY   140      32.855  68.892  90.126  1.00 58.89           O  
ATOM    997  N   ALA   141      33.676  66.832  89.716  1.00 59.75           N  
ATOM    998  CA  ALA   141      35.040  67.285  89.475  1.00 59.39           C  
ATOM    999  C   ALA   141      35.054  68.246  88.297  1.00 59.87           C  
ATOM   1000  O   ALA   141      35.524  69.372  88.414  1.00 60.06           O  
ATOM   1001  CB  ALA   141      35.942  66.102  89.187  1.00 58.71           C  
ATOM   1002  N   LYS   142      34.525  67.816  87.160  1.00 60.87           N  
ATOM   1003  CA  LYS   142      34.502  68.689  85.998  1.00 63.21           C  
ATOM   1004  C   LYS   142      33.667  69.967  86.157  1.00 64.39           C  
ATOM   1005  O   LYS   142      33.684  70.831  85.279  1.00 65.23           O  
ATOM   1006  CB  LYS   142      34.031  67.911  84.775  1.00 64.01           C  
ATOM   1007  CG  LYS   142      35.115  67.777  83.733  1.00 64.51           C  
ATOM   1008  CD  LYS   142      36.395  67.300  84.369  1.00 62.15           C  
ATOM   1009  CE  LYS   142      37.569  67.712  83.527  1.00 60.80           C  
ATOM   1010  NZ  LYS   142      38.768  67.839  84.392  1.00 59.41           N  
ATOM   1011  N   GLY   143      32.942  70.087  87.269  1.00 64.77           N  
ATOM   1012  CA  GLY   143      32.127  71.270  87.518  1.00 63.40           C  
ATOM   1013  C   GLY   143      30.912  71.412  86.614  1.00 62.51           C  
ATOM   1014  O   GLY   143      30.876  72.271  85.729  1.00 61.96           O  
ATOM   1015  N   ARG   144      29.906  70.577  86.851  1.00 61.37           N  
ATOM   1016  CA  ARG   144      28.688  70.591  86.062  1.00 59.78           C  
ATOM   1017  C   ARG   144      27.506  70.184  86.915  1.00 60.00           C  
ATOM   1018  O   ARG   144      27.665  69.610  87.994  1.00 58.78           O  
ATOM   1019  CB  ARG   144      28.813  69.615  84.892  1.00 59.73           C  
ATOM   1020  CG  ARG   144      30.066  69.807  84.050  1.00 62.09           C  
ATOM   1021  CD  ARG   144      30.038  68.966  82.776  1.00 63.81           C  
ATOM   1022  NE  ARG   144      31.382  68.674  82.275  1.00 64.77           N  
ATOM   1023  CZ  ARG   144      31.677  67.624  81.511  1.00 64.68           C  
ATOM   1024  NH1 ARG   144      32.925  67.426  81.105  1.00 63.47           N  
ATOM   1025  NH2 ARG   144      30.722  66.764  81.159  1.00 63.22           N  
ATOM   1026  N   LEU   145      26.314  70.476  86.425  1.00 61.31           N  
ATOM   1027  CA  LEU   145      25.110  70.106  87.150  1.00 64.02           C  
ATOM   1028  C   LEU   145      24.887  68.610  86.946  1.00 65.18           C  
ATOM   1029  O   LEU   145      25.684  67.932  86.290  1.00 63.31           O  
ATOM   1030  CB  LEU   145      23.914  70.879  86.609  1.00 64.87           C  
ATOM   1031  CG  LEU   145      24.281  72.173  85.880  1.00 65.62           C  
ATOM   1032  CD1 LEU   145      23.035  72.696  85.199  1.00 66.51           C  
ATOM   1033  CD2 LEU   145      24.876  73.192  86.836  1.00 63.82           C  
ATOM   1034  N   MET   146      23.804  68.098  87.514  1.00 67.39           N  
ATOM   1035  CA  MET   146      23.491  66.684  87.382  1.00 71.10           C  
ATOM   1036  C   MET   146      22.471  66.505  86.269  1.00 73.92           C  
ATOM   1037  O   MET   146      22.574  65.589  85.452  1.00 73.43           O  
ATOM   1038  CB  MET   146      22.913  66.155  88.680  1.00 70.84           C  
ATOM   1039  CG  MET   146      23.372  66.913  89.877  1.00 72.60           C  
ATOM   1040  SD  MET   146      22.905  65.976  91.486  1.00 78.81          SE  
ATOM   1041  CE  MET   146      21.040  65.589  91.166  1.00 76.86           C  
ATOM   1042  N   TYR   147      21.479  67.394  86.265  1.00 76.90           N  
ATOM   1043  CA  TYR   147      20.418  67.407  85.267  1.00 78.24           C  
ATOM   1044  C   TYR   147      20.000  68.839  84.996  1.00 79.71           C  
ATOM   1045  O   TYR   147      20.149  69.714  85.852  1.00 79.31           O  
ATOM   1046  CB  TYR   147      19.192  66.655  85.754  1.00 78.83           C  
ATOM   1047  CG  TYR   147      18.045  66.705  84.765  1.00 80.14           C  
ATOM   1048  CD1 TYR   147      16.734  66.830  85.202  1.00 80.08           C  
ATOM   1049  CD2 TYR   147      18.269  66.565  83.390  1.00 80.75           C  
ATOM   1050  CE1 TYR   147      15.673  66.807  84.309  1.00 80.19           C  
ATOM   1051  CE2 TYR   147      17.210  66.542  82.486  1.00 79.87           C  
ATOM   1052  CZ  TYR   147      15.917  66.660  82.957  1.00 80.01           C  
ATOM   1053  OH  TYR   147      14.856  66.606  82.089  1.00 80.94           O  
ATOM   1054  N   ASP   148      19.460  69.062  83.802  1.00 81.42           N  
ATOM   1055  CA  ASP   148      18.997  70.379  83.392  1.00 83.23           C  
ATOM   1056  C   ASP   148      18.013  70.223  82.232  1.00 84.70           C  
ATOM   1057  O   ASP   148      18.398  69.784  81.155  1.00 86.95           O  
ATOM   1058  CB  ASP   148      20.177  71.231  82.937  1.00 81.88           C  
ATOM   1059  CG  ASP   148      19.834  72.701  82.858  1.00 81.53           C  
ATOM   1060  OD1 ASP   148      18.756  73.040  82.330  1.00 82.07           O  
ATOM   1061  OD2 ASP   148      20.651  73.524  83.314  1.00 80.79           O  
ATOM   1062  N   PRO   149      16.734  70.583  82.436  1.00 85.17           N  
ATOM   1063  CA  PRO   149      15.697  70.480  81.402  1.00 84.60           C  
ATOM   1064  C   PRO   149      15.891  71.442  80.222  1.00 84.90           C  
ATOM   1065  O   PRO   149      15.166  71.378  79.236  1.00 85.02           O  
ATOM   1066  CB  PRO   149      14.422  70.765  82.180  1.00 85.35           C  
ATOM   1067  CG  PRO   149      14.887  71.755  83.203  1.00 86.59           C  
ATOM   1068  CD  PRO   149      16.173  71.127  83.685  1.00 85.94           C  
ATOM   1069  N   THR   150      16.868  72.335  80.336  1.00 85.31           N  
ATOM   1070  CA  THR   150      17.176  73.303  79.282  1.00 85.85           C  
ATOM   1071  C   THR   150      18.192  72.692  78.299  1.00 86.98           C  
ATOM   1072  O   THR   150      18.404  73.206  77.192  1.00 86.20           O  
ATOM   1073  CB  THR   150      17.774  74.599  79.885  1.00 86.05           C  
ATOM   1074  OG1 THR   150      16.817  75.185  80.773  1.00 85.27           O  
ATOM   1075  CG2 THR   150      18.140  75.598  78.790  1.00 85.25           C  
ATOM   1076  N   ILE   151      18.822  71.597  78.726  1.00 87.35           N  
ATOM   1077  CA  ILE   151      19.818  70.889  77.926  1.00 88.07           C  
ATOM   1078  C   ILE   151      19.433  69.413  77.779  1.00 88.78           C  
ATOM   1079  O   ILE   151      19.907  68.559  78.522  1.00 87.07           O  
ATOM   1080  CB  ILE   151      21.225  70.985  78.569  1.00 87.96           C  
ATOM   1081  CG1 ILE   151      21.580  72.437  78.841  1.00 88.05           C  
ATOM   1082  CG2 ILE   151      22.275  70.455  77.610  1.00 88.72           C  
ATOM   1083  CD1 ILE   151      21.621  73.282  77.581  1.00 90.03           C  
ATOM   1084  N   PRO   152      18.571  69.097  76.799  1.00 90.99           N  
ATOM   1085  CA  PRO   152      18.126  67.720  76.565  1.00 91.83           C  
ATOM   1086  C   PRO   152      19.251  66.833  76.044  1.00 92.62           C  
ATOM   1087  O   PRO   152      20.301  67.323  75.631  1.00 92.86           O  
ATOM   1088  CB  PRO   152      17.010  67.897  75.543  1.00 92.07           C  
ATOM   1089  CG  PRO   152      17.539  69.024  74.699  1.00 91.62           C  
ATOM   1090  CD  PRO   152      18.054  69.998  75.749  1.00 91.60           C  
ATOM   1091  N   PRO   153      19.041  65.508  76.056  1.00 93.62           N  
ATOM   1092  CA  PRO   153      20.057  64.560  75.576  1.00 94.13           C  
ATOM   1093  C   PRO   153      20.396  64.679  74.071  1.00 93.96           C  
ATOM   1094  O   PRO   153      19.637  65.261  73.293  1.00 93.11           O  
ATOM   1095  CB  PRO   153      19.455  63.195  75.945  1.00 94.12           C  
ATOM   1096  CG  PRO   153      17.976  63.442  75.866  1.00 94.32           C  
ATOM   1097  CD  PRO   153      17.841  64.798  76.536  1.00 93.75           C  
ATOM   1098  N   ARG   154      21.545  64.126  73.681  1.00 93.44           N  
ATOM   1099  CA  ARG   154      22.004  64.152  72.292  1.00 92.49           C  
ATOM   1100  C   ARG   154      22.469  62.757  71.847  1.00 92.25           C  
ATOM   1101  O   ARG   154      22.000  62.210  70.846  1.00 91.34           O  
ATOM   1102  CB  ARG   154      23.147  65.173  72.146  1.00 91.37           C  
ATOM   1103  CG  ARG   154      23.770  65.268  70.757  1.00 90.85           C  
ATOM   1104  CD  ARG   154      24.841  64.200  70.546  1.00 91.19           C  
ATOM   1105  NE  ARG   154      25.361  64.181  69.176  1.00 90.28           N  
ATOM   1106  CZ  ARG   154      24.739  63.621  68.144  1.00 89.45           C  
ATOM   1107  NH1 ARG   154      25.291  63.663  66.937  1.00 87.75           N  
ATOM   1108  NH2 ARG   154      23.574  63.008  68.321  1.00 90.00           N  
ATOM   1109  N   ASP   167      25.813  70.869  79.364  1.00 75.03           N  
ATOM   1110  CA  ASP   167      26.285  69.495  79.326  1.00 74.65           C  
ATOM   1111  C   ASP   167      26.305  68.926  80.748  1.00 73.03           C  
ATOM   1112  O   ASP   167      27.348  68.907  81.410  1.00 72.46           O  
ATOM   1113  CB  ASP   167      27.682  69.434  78.673  1.00 76.08           C  
ATOM   1114  CG  ASP   167      28.626  70.524  79.186  1.00 78.97           C  
ATOM   1115  OD1 ASP   167      29.751  70.632  78.646  1.00 78.19           O  
ATOM   1116  OD2 ASP   167      28.256  71.271  80.132  1.00 79.93           O  
ATOM   1117  N   PRO   168      25.133  68.470  81.237  1.00 70.89           N  
ATOM   1118  CA  PRO   168      24.956  67.895  82.571  1.00 68.45           C  
ATOM   1119  C   PRO   168      25.338  66.415  82.633  1.00 66.46           C  
ATOM   1120  O   PRO   168      25.385  65.730  81.612  1.00 64.86           O  
ATOM   1121  CB  PRO   168      23.479  68.127  82.825  1.00 68.47           C  
ATOM   1122  CG  PRO   168      22.908  67.820  81.487  1.00 69.40           C  
ATOM   1123  CD  PRO   168      23.830  68.580  80.552  1.00 69.73           C  
ATOM   1124  N   SER   169      25.580  65.930  83.845  1.00 65.69           N  
ATOM   1125  CA  SER   169      25.974  64.544  84.059  1.00 63.57           C  
ATOM   1126  C   SER   169      24.942  63.517  83.655  1.00 61.33           C  
ATOM   1127  O   SER   169      25.295  62.457  83.165  1.00 60.74           O  
ATOM   1128  CB  SER   169      26.325  64.311  85.527  1.00 64.41           C  
ATOM   1129  OG  SER   169      27.329  65.209  85.967  1.00 67.02           O  
ATOM   1130  N   LEU   170      23.669  63.812  83.867  1.00 60.48           N  
ATOM   1131  CA  LEU   170      22.634  62.847  83.526  1.00 60.66           C  
ATOM   1132  C   LEU   170      22.572  62.569  82.041  1.00 62.78           C  
ATOM   1133  O   LEU   170      22.270  61.449  81.626  1.00 63.65           O  
ATOM   1134  CB  LEU   170      21.259  63.318  83.985  1.00 57.33           C  
ATOM   1135  CG  LEU   170      20.190  62.240  83.848  1.00 52.71           C  
ATOM   1136  CD1 LEU   170      20.039  61.545  85.162  1.00 52.07           C  
ATOM   1137  CD2 LEU   170      18.880  62.857  83.442  1.00 51.94           C  
ATOM   1138  N   ASN   171      22.853  63.581  81.233  1.00 65.04           N  
ATOM   1139  CA  ASN   171      22.804  63.400  79.788  1.00 68.04           C  
ATOM   1140  C   ASN   171      23.843  62.391  79.307  1.00 68.57           C  
ATOM   1141  O   ASN   171      23.561  61.572  78.429  1.00 68.23           O  
ATOM   1142  CB  ASN   171      22.982  64.750  79.083  1.00 70.11           C  
ATOM   1143  CG  ASN   171      21.727  65.619  79.161  1.00 71.61           C  
ATOM   1144  OD1 ASN   171      21.797  66.842  79.045  1.00 70.95           O  
ATOM   1145  ND2 ASN   171      20.569  64.981  79.343  1.00 72.29           N  
ATOM   1146  N   HIS   172      25.035  62.439  79.893  1.00 70.13           N  
ATOM   1147  CA  HIS   172      26.110  61.520  79.522  1.00 71.32           C  
ATOM   1148  C   HIS   172      25.586  60.082  79.403  1.00 70.80           C  
ATOM   1149  O   HIS   172      26.102  59.288  78.615  1.00 71.74           O  
ATOM   1150  CB  HIS   172      27.246  61.593  80.561  1.00 72.60           C  
ATOM   1151  CG  HIS   172      28.413  60.690  80.273  1.00 73.91           C  
ATOM   1152  ND1 HIS   172      28.299  59.316  80.199  1.00 73.44           N  
ATOM   1153  CD2 HIS   172      29.726  60.964  80.076  1.00 74.10           C  
ATOM   1154  CE1 HIS   172      29.487  58.786  79.973  1.00 72.45           C  
ATOM   1155  NE2 HIS   172      30.371  59.764  79.895  1.00 73.85           N  
ATOM   1156  N   PHE   173      24.553  59.744  80.166  1.00 69.09           N  
ATOM   1157  CA  PHE   173      24.028  58.394  80.098  1.00 68.29           C  
ATOM   1158  C   PHE   173      23.559  58.061  78.692  1.00 68.86           C  
ATOM   1159  O   PHE   173      24.103  57.158  78.045  1.00 67.05           O  
ATOM   1160  CB  PHE   173      22.907  58.213  81.119  1.00 67.59           C  
ATOM   1161  CG  PHE   173      23.387  58.262  82.545  1.00 67.20           C  
ATOM   1162  CD1 PHE   173      22.977  59.276  83.395  1.00 65.74           C  
ATOM   1163  CD2 PHE   173      24.310  57.327  83.016  1.00 66.73           C  
ATOM   1164  CE1 PHE   173      23.472  59.355  84.682  1.00 63.73           C  
ATOM   1165  CE2 PHE   173      24.808  57.404  84.306  1.00 64.33           C  
ATOM   1166  CZ  PHE   173      24.393  58.421  85.135  1.00 64.47           C  
ATOM   1167  N   TYR   174      22.558  58.793  78.211  1.00 70.58           N  
ATOM   1168  CA  TYR   174      22.034  58.573  76.865  1.00 71.24           C  
ATOM   1169  C   TYR   174      23.142  58.810  75.855  1.00 73.12           C  
ATOM   1170  O   TYR   174      23.262  58.079  74.869  1.00 72.70           O  
ATOM   1171  CB  TYR   174      20.895  59.540  76.571  1.00 69.11           C  
ATOM   1172  CG  TYR   174      19.740  59.401  77.513  1.00 69.86           C  
ATOM   1173  CD1 TYR   174      19.088  58.177  77.670  1.00 68.60           C  
ATOM   1174  CD2 TYR   174      19.296  60.492  78.263  1.00 71.00           C  
ATOM   1175  CE1 TYR   174      18.024  58.047  78.552  1.00 68.97           C  
ATOM   1176  CE2 TYR   174      18.233  60.373  79.146  1.00 70.09           C  
ATOM   1177  CZ  TYR   174      17.605  59.150  79.286  1.00 70.16           C  
ATOM   1178  OH  TYR   174      16.560  59.045  80.168  1.00 72.51           O  
ATOM   1179  N   GLU   175      23.950  59.835  76.124  1.00 74.26           N  
ATOM   1180  CA  GLU   175      25.058  60.216  75.260  1.00 75.71           C  
ATOM   1181  C   GLU   175      25.911  59.044  74.797  1.00 76.05           C  
ATOM   1182  O   GLU   175      25.898  58.682  73.621  1.00 76.81           O  
ATOM   1183  CB  GLU   175      25.954  61.234  75.971  1.00 77.49           C  
ATOM   1184  CG  GLU   175      26.216  62.495  75.164  1.00 80.51           C  
ATOM   1185  CD  GLU   175      24.967  63.347  75.014  1.00 83.72           C  
ATOM   1186  OE1 GLU   175      24.650  64.129  75.944  1.00 85.14           O  
ATOM   1187  OE2 GLU   175      24.292  63.226  73.967  1.00 84.83           O  
ATOM   1188  N   LYS   176      26.655  58.448  75.722  1.00 76.42           N  
ATOM   1189  CA  LYS   176      27.532  57.350  75.359  1.00 76.38           C  
ATOM   1190  C   LYS   176      27.648  56.273  76.427  1.00 76.16           C  
ATOM   1191  O   LYS   176      28.753  55.851  76.753  1.00 77.18           O  
ATOM   1192  CB  LYS   176      28.933  57.898  75.017  1.00 76.48           C  
ATOM   1193  CG  LYS   176      28.963  58.904  73.840  1.00 75.87           C  
ATOM   1194  CD  LYS   176      30.386  59.334  73.454  1.00 74.33           C  
ATOM   1195  CE  LYS   176      31.082  60.122  74.558  1.00 74.40           C  
ATOM   1196  NZ  LYS   176      32.523  60.393  74.253  1.00 73.62           N  
ATOM   1197  N   LEU   177      26.518  55.823  76.968  1.00 75.50           N  
ATOM   1198  CA  LEU   177      26.539  54.776  77.991  1.00 74.89           C  
ATOM   1199  C   LEU   177      25.440  53.736  77.802  1.00 74.98           C  
ATOM   1200  O   LEU   177      25.714  52.540  77.781  1.00 75.16           O  
ATOM   1201  CB  LEU   177      26.435  55.381  79.402  1.00 72.96           C  
ATOM   1202  CG  LEU   177      27.728  55.664  80.176  1.00 71.09           C  
ATOM   1203  CD1 LEU   177      27.427  56.027  81.626  1.00 69.19           C  
ATOM   1204  CD2 LEU   177      28.588  54.429  80.137  1.00 70.74           C  
ATOM   1205  N   LEU   178      24.198  54.185  77.671  1.00 75.08           N  
ATOM   1206  CA  LEU   178      23.106  53.247  77.485  1.00 75.73           C  
ATOM   1207  C   LEU   178      23.277  52.463  76.188  1.00 77.01           C  
ATOM   1208  O   LEU   178      22.705  51.387  76.029  1.00 77.80           O  
ATOM   1209  CB  LEU   178      21.761  53.976  77.479  1.00 74.55           C  
ATOM   1210  CG  LEU   178      21.270  54.519  78.817  1.00 74.09           C  
ATOM   1211  CD1 LEU   178      19.895  55.126  78.642  1.00 73.47           C  
ATOM   1212  CD2 LEU   178      21.208  53.392  79.835  1.00 74.55           C  
ATOM   1213  N   LYS   179      24.073  52.999  75.265  1.00 77.77           N  
ATOM   1214  CA  LYS   179      24.306  52.339  73.984  1.00 78.05           C  
ATOM   1215  C   LYS   179      25.561  51.460  73.999  1.00 78.51           C  
ATOM   1216  O   LYS   179      26.146  51.188  72.946  1.00 79.11           O  
ATOM   1217  CB  LYS   179      24.431  53.380  72.868  1.00 78.24           C  
ATOM   1218  CG  LYS   179      25.661  54.275  72.973  1.00 77.44           C  
ATOM   1219  CD  LYS   179      25.707  55.313  71.851  1.00 77.04           C  
ATOM   1220  CE  LYS   179      24.596  56.346  71.998  1.00 75.83           C  
ATOM   1221  NZ  LYS   179      24.664  57.418  70.971  1.00 74.13           N  
ATOM   1222  N   LEU   180      25.965  51.013  75.191  1.00 78.30           N  
ATOM   1223  CA  LEU   180      27.146  50.161  75.354  1.00 76.34           C  
ATOM   1224  C   LEU   180      26.802  48.696  75.438  1.00 75.62           C  
ATOM   1225  O   LEU   180      27.647  47.852  75.173  1.00 76.79           O  
ATOM   1226  CB  LEU   180      27.929  50.555  76.601  1.00 74.65           C  
ATOM   1227  CG  LEU   180      28.813  51.781  76.411  1.00 73.57           C  
ATOM   1228  CD1 LEU   180      29.397  52.182  77.740  1.00 73.07           C  
ATOM   1229  CD2 LEU   180      29.914  51.468  75.410  1.00 73.90           C  
ATOM   1230  N   LYS   181      25.565  48.401  75.817  1.00 74.92           N  
ATOM   1231  CA  LYS   181      25.100  47.024  75.925  1.00 73.93           C  
ATOM   1232  C   LYS   181      24.877  46.409  74.551  1.00 73.05           C  
ATOM   1233  O   LYS   181      24.561  45.229  74.426  1.00 71.78           O  
ATOM   1234  CB  LYS   181      23.808  46.970  76.749  1.00 73.94           C  
ATOM   1235  CG  LYS   181      22.731  47.949  76.303  1.00 75.35           C  
ATOM   1236  CD  LYS   181      21.801  47.394  75.231  1.00 76.55           C  
ATOM   1237  CE  LYS   181      20.776  46.433  75.812  1.00 76.93           C  
ATOM   1238  NZ  LYS   181      21.418  45.228  76.402  1.00 78.17           N  
ATOM   1239  N   ASP   182      25.049  47.219  73.517  1.00 74.29           N  
ATOM   1240  CA  ASP   182      24.861  46.747  72.151  1.00 75.68           C  
ATOM   1241  C   ASP   182      26.196  46.398  71.496  1.00 75.38           C  
ATOM   1242  O   ASP   182      26.224  45.857  70.397  1.00 74.67           O  
ATOM   1243  CB  ASP   182      24.126  47.811  71.313  1.00 76.95           C  
ATOM   1244  CG  ASP   182      22.700  48.094  71.816  1.00 78.30           C  
ATOM   1245  OD1 ASP   182      21.904  47.136  71.990  1.00 77.49           O  
ATOM   1246  OD2 ASP   182      22.374  49.287  72.020  1.00 78.32           O  
ATOM   1247  N   LEU   183      27.293  46.702  72.186  1.00 75.46           N  
ATOM   1248  CA  LEU   183      28.637  46.431  71.682  1.00 75.33           C  
ATOM   1249  C   LEU   183      29.280  45.222  72.366  1.00 76.10           C  
ATOM   1250  O   LEU   183      30.450  44.903  72.138  1.00 75.33           O  
ATOM   1251  CB  LEU   183      29.528  47.660  71.881  1.00 75.27           C  
ATOM   1252  CG  LEU   183      29.250  48.915  71.048  1.00 74.97           C  
ATOM   1253  CD1 LEU   183      29.509  48.624  69.579  1.00 75.42           C  
ATOM   1254  CD2 LEU   183      27.824  49.386  71.264  1.00 74.93           C  
ATOM   1255  N   MET   184      28.513  44.550  73.212  1.00 77.26           N  
ATOM   1256  CA  MET   184      29.023  43.382  73.909  1.00 78.13           C  
ATOM   1257  C   MET   184      29.167  42.247  72.893  1.00 77.19           C  
ATOM   1258  O   MET   184      28.328  42.100  72.003  1.00 77.75           O  
ATOM   1259  CB  MET   184      28.055  42.996  75.030  1.00 80.86           C  
ATOM   1260  CG  MET   184      28.717  42.780  76.395  1.00 84.94           C  
ATOM   1261  SD  MET   184      29.730  44.308  77.056  1.00 87.42          SE  
ATOM   1262  CE  MET   184      28.303  45.371  77.829  1.00 85.70           C  
ATOM   1263  N   ASN   185      30.233  41.456  73.025  1.00 75.64           N  
ATOM   1264  CA  ASN   185      30.505  40.337  72.118  1.00 72.79           C  
ATOM   1265  C   ASN   185      29.903  39.005  72.539  1.00 71.82           C  
ATOM   1266  O   ASN   185      28.912  38.584  71.968  1.00 72.35           O  
ATOM   1267  CB  ASN   185      32.009  40.156  71.944  1.00 72.85           C  
ATOM   1268  CG  ASN   185      32.701  41.444  71.575  1.00 73.80           C  
ATOM   1269  OD1 ASN   185      32.131  42.284  70.870  1.00 73.42           O  
ATOM   1270  ND2 ASN   185      33.942  41.606  72.027  1.00 73.87           N  
ATOM   1271  N   THR   186      30.508  38.335  73.522  1.00 72.11           N  
ATOM   1272  CA  THR   186      30.001  37.031  73.968  1.00 72.31           C  
ATOM   1273  C   THR   186      28.644  37.151  74.638  1.00 74.06           C  
ATOM   1274  O   THR   186      28.168  38.248  74.934  1.00 73.83           O  
ATOM   1275  CB  THR   186      30.909  36.316  74.996  1.00 70.65           C  
ATOM   1276  OG1 THR   186      30.563  36.764  76.304  1.00 69.68           O  
ATOM   1277  CG2 THR   186      32.371  36.600  74.753  1.00 70.22           C  
ATOM   1278  N   ASN   187      28.035  36.000  74.900  1.00 75.92           N  
ATOM   1279  CA  ASN   187      26.725  35.951  75.532  1.00 76.49           C  
ATOM   1280  C   ASN   187      26.753  36.396  76.991  1.00 76.55           C  
ATOM   1281  O   ASN   187      26.038  37.320  77.354  1.00 77.17           O  
ATOM   1282  CB  ASN   187      26.149  34.530  75.456  1.00 78.02           C  
ATOM   1283  CG  ASN   187      25.748  34.125  74.046  1.00 78.58           C  
ATOM   1284  OD1 ASN   187      25.318  32.994  73.819  1.00 78.61           O  
ATOM   1285  ND2 ASN   187      25.878  35.047  73.096  1.00 79.16           N  
ATOM   1286  N   ALA   188      27.562  35.732  77.821  1.00 75.68           N  
ATOM   1287  CA  ALA   188      27.640  36.065  79.245  1.00 75.21           C  
ATOM   1288  C   ALA   188      27.756  37.573  79.469  1.00 75.67           C  
ATOM   1289  O   ALA   188      27.107  38.136  80.365  1.00 75.46           O  
ATOM   1290  CB  ALA   188      28.813  35.342  79.896  1.00 74.80           C  
ATOM   1291  N   ALA   189      28.584  38.217  78.646  1.00 75.41           N  
ATOM   1292  CA  ALA   189      28.792  39.665  78.705  1.00 74.71           C  
ATOM   1293  C   ALA   189      27.487  40.359  78.336  1.00 74.26           C  
ATOM   1294  O   ALA   189      27.053  41.280  79.023  1.00 73.63           O  
ATOM   1295  CB  ALA   189      29.889  40.077  77.731  1.00 74.38           C  
ATOM   1296  N   LYS   190      26.869  39.920  77.242  1.00 74.36           N  
ATOM   1297  CA  LYS   190      25.608  40.508  76.824  1.00 74.67           C  
ATOM   1298  C   LYS   190      24.570  40.349  77.928  1.00 75.01           C  
ATOM   1299  O   LYS   190      23.831  41.281  78.231  1.00 75.26           O  
ATOM   1300  CB  LYS   190      25.088  39.854  75.538  1.00 75.08           C  
ATOM   1301  CG  LYS   190      25.766  40.332  74.253  1.00 75.61           C  
ATOM   1302  CD  LYS   190      24.883  40.096  73.020  1.00 75.14           C  
ATOM   1303  CE  LYS   190      23.426  40.597  73.216  1.00 76.92           C  
ATOM   1304  NZ  LYS   190      23.231  42.059  73.518  1.00 74.41           N  
ATOM   1305  N   GLN   191      24.513  39.170  78.537  1.00 75.89           N  
ATOM   1306  CA  GLN   191      23.547  38.934  79.597  1.00 76.18           C  
ATOM   1307  C   GLN   191      23.737  39.951  80.701  1.00 74.48           C  
ATOM   1308  O   GLN   191      22.874  40.789  80.952  1.00 72.86           O  
ATOM   1309  CB  GLN   191      23.703  37.527  80.169  1.00 79.53           C  
ATOM   1310  CG  GLN   191      22.910  37.303  81.461  1.00 85.65           C  
ATOM   1311  CD  GLN   191      21.440  37.741  81.363  1.00 88.46           C  
ATOM   1312  OE1 GLN   191      21.122  38.937  81.409  1.00 88.38           O  
ATOM   1313  NE2 GLN   191      20.541  36.765  81.217  1.00 90.48           N  
ATOM   1314  N   GLU   192      24.876  39.865  81.368  1.00 73.40           N  
ATOM   1315  CA  GLU   192      25.179  40.791  82.439  1.00 73.33           C  
ATOM   1316  C   GLU   192      24.836  42.222  82.014  1.00 72.83           C  
ATOM   1317  O   GLU   192      24.169  42.947  82.753  1.00 73.68           O  
ATOM   1318  CB  GLU   192      26.660  40.683  82.799  1.00 73.12           C  
ATOM   1319  CG  GLU   192      27.144  41.718  83.787  1.00 74.16           C  
ATOM   1320  CD  GLU   192      26.452  41.613  85.125  1.00 74.74           C  
ATOM   1321  OE1 GLU   192      25.342  42.158  85.264  1.00 74.77           O  
ATOM   1322  OE2 GLU   192      27.013  40.968  86.035  1.00 75.76           O  
ATOM   1323  N   ALA   193      25.279  42.608  80.815  1.00 71.50           N  
ATOM   1324  CA  ALA   193      25.059  43.951  80.268  1.00 68.92           C  
ATOM   1325  C   ALA   193      23.603  44.386  80.271  1.00 68.50           C  
ATOM   1326  O   ALA   193      23.292  45.536  80.580  1.00 68.09           O  
ATOM   1327  CB  ALA   193      25.612  44.024  78.868  1.00 68.80           C  
ATOM   1328  N   GLU   194      22.715  43.468  79.904  1.00 67.87           N  
ATOM   1329  CA  GLU   194      21.293  43.756  79.898  1.00 66.46           C  
ATOM   1330  C   GLU   194      20.845  44.035  81.323  1.00 64.80           C  
ATOM   1331  O   GLU   194      20.080  44.954  81.567  1.00 65.66           O  
ATOM   1332  CB  GLU   194      20.517  42.567  79.347  1.00 67.96           C  
ATOM   1333  CG  GLU   194      20.005  42.779  77.933  1.00 70.18           C  
ATOM   1334  CD  GLU   194      18.933  43.853  77.859  1.00 70.72           C  
ATOM   1335  OE1 GLU   194      18.625  44.306  76.732  1.00 70.03           O  
ATOM   1336  OE2 GLU   194      18.395  44.235  78.926  1.00 69.67           O  
ATOM   1337  N   VAL   195      21.334  43.249  82.272  1.00 63.03           N  
ATOM   1338  CA  VAL   195      20.939  43.449  83.650  1.00 59.68           C  
ATOM   1339  C   VAL   195      21.485  44.783  84.126  1.00 59.89           C  
ATOM   1340  O   VAL   195      20.764  45.558  84.756  1.00 60.97           O  
ATOM   1341  CB  VAL   195      21.455  42.317  84.561  1.00 57.40           C  
ATOM   1342  CG1 VAL   195      20.565  42.196  85.765  1.00 54.67           C  
ATOM   1343  CG2 VAL   195      21.480  41.005  83.806  1.00 56.31           C  
ATOM   1344  N   ARG   196      22.751  45.057  83.818  1.00 59.61           N  
ATOM   1345  CA  ARG   196      23.391  46.319  84.223  1.00 60.56           C  
ATOM   1346  C   ARG   196      22.696  47.516  83.569  1.00 62.73           C  
ATOM   1347  O   ARG   196      22.392  48.521  84.237  1.00 63.28           O  
ATOM   1348  CB  ARG   196      24.864  46.368  83.797  1.00 58.24           C  
ATOM   1349  CG  ARG   196      25.871  45.590  84.642  1.00 54.44           C  
ATOM   1350  CD  ARG   196      27.048  46.513  84.932  1.00 52.09           C  
ATOM   1351  NE  ARG   196      28.298  45.818  85.194  1.00 51.02           N  
ATOM   1352  CZ  ARG   196      28.438  44.816  86.052  1.00 52.11           C  
ATOM   1353  NH1 ARG   196      27.395  44.377  86.733  1.00 54.90           N  
ATOM   1354  NH2 ARG   196      29.626  44.266  86.247  1.00 51.28           N  
ATOM   1355  N   HIS   197      22.480  47.400  82.253  1.00 63.26           N  
ATOM   1356  CA  HIS   197      21.842  48.447  81.453  1.00 62.92           C  
ATOM   1357  C   HIS   197      20.461  48.771  81.995  1.00 62.69           C  
ATOM   1358  O   HIS   197      20.097  49.935  82.154  1.00 62.26           O  
ATOM   1359  CB  HIS   197      21.741  48.014  79.978  1.00 60.95           C  
ATOM   1360  CG  HIS   197      21.149  49.059  79.076  1.00 60.69           C  
ATOM   1361  ND1 HIS   197      19.853  48.999  78.609  1.00 59.78           N  
ATOM   1362  CD2 HIS   197      21.682  50.191  78.552  1.00 59.85           C  
ATOM   1363  CE1 HIS   197      19.612  50.045  77.835  1.00 58.82           C  
ATOM   1364  NE2 HIS   197      20.704  50.784  77.785  1.00 59.69           N  
ATOM   1365  N   ARG   198      19.705  47.723  82.290  1.00 63.19           N  
ATOM   1366  CA  ARG   198      18.362  47.867  82.813  1.00 64.11           C  
ATOM   1367  C   ARG   198      18.372  48.754  84.046  1.00 65.67           C  
ATOM   1368  O   ARG   198      17.533  49.647  84.160  1.00 66.28           O  
ATOM   1369  CB  ARG   198      17.803  46.497  83.179  1.00 64.14           C  
ATOM   1370  CG  ARG   198      16.297  46.438  83.336  1.00 62.32           C  
ATOM   1371  CD  ARG   198      15.878  45.024  83.697  1.00 61.36           C  
ATOM   1372  NE  ARG   198      16.603  44.028  82.906  1.00 62.63           N  
ATOM   1373  CZ  ARG   198      16.603  43.963  81.573  1.00 64.10           C  
ATOM   1374  NH1 ARG   198      17.300  43.019  80.955  1.00 64.30           N  
ATOM   1375  NH2 ARG   198      15.912  44.839  80.849  1.00 65.67           N  
ATOM   1376  N   TYR   199      19.321  48.517  84.958  1.00 66.80           N  
ATOM   1377  CA  TYR   199      19.414  49.291  86.200  1.00 68.41           C  
ATOM   1378  C   TYR   199      19.596  50.794  85.951  1.00 70.32           C  
ATOM   1379  O   TYR   199      18.955  51.614  86.610  1.00 70.72           O  
ATOM   1380  CB  TYR   199      20.547  48.752  87.103  1.00 67.25           C  
ATOM   1381  CG  TYR   199      20.519  49.329  88.522  1.00 66.91           C  
ATOM   1382  CD1 TYR   199      21.544  50.150  88.987  1.00 67.24           C  
ATOM   1383  CD2 TYR   199      19.409  49.142  89.347  1.00 67.93           C  
ATOM   1384  CE1 TYR   199      21.458  50.783  90.232  1.00 68.80           C  
ATOM   1385  CE2 TYR   199      19.303  49.766  90.594  1.00 68.25           C  
ATOM   1386  CZ  TYR   199      20.322  50.591  91.028  1.00 68.93           C  
ATOM   1387  OH  TYR   199      20.178  51.269  92.216  1.00 68.72           O  
ATOM   1388  N   MET   200      20.459  51.157  85.004  1.00 72.62           N  
ATOM   1389  CA  MET   200      20.664  52.561  84.690  1.00 74.08           C  
ATOM   1390  C   MET   200      19.351  53.148  84.158  1.00 74.57           C  
ATOM   1391  O   MET   200      19.051  54.320  84.376  1.00 74.04           O  
ATOM   1392  CB  MET   200      21.794  52.722  83.663  1.00 76.05           C  
ATOM   1393  CG  MET   200      23.168  52.273  84.171  1.00 81.26           C  
ATOM   1394  SD  MET   200      24.671  52.625  82.955  1.00 89.11          SE  
ATOM   1395  CE  MET   200      25.413  54.241  83.731  1.00 86.30           C  
ATOM   1396  N   GLU   201      18.560  52.325  83.474  1.00 75.72           N  
ATOM   1397  CA  GLU   201      17.276  52.775  82.930  1.00 76.94           C  
ATOM   1398  C   GLU   201      16.309  53.085  84.072  1.00 76.91           C  
ATOM   1399  O   GLU   201      15.797  54.206  84.179  1.00 78.29           O  
ATOM   1400  CB  GLU   201      16.673  51.702  81.998  1.00 77.75           C  
ATOM   1401  CG  GLU   201      17.526  51.444  80.739  1.00 79.18           C  
ATOM   1402  CD  GLU   201      16.883  50.516  79.696  1.00 79.10           C  
ATOM   1403  OE1 GLU   201      16.629  49.320  80.002  1.00 78.25           O  
ATOM   1404  OE2 GLU   201      16.655  50.997  78.558  1.00 76.78           O  
ATOM   1405  N   GLN   202      16.072  52.085  84.918  1.00 75.22           N  
ATOM   1406  CA  GLN   202      15.185  52.208  86.070  1.00 73.35           C  
ATOM   1407  C   GLN   202      15.658  53.328  86.982  1.00 71.78           C  
ATOM   1408  O   GLN   202      14.843  54.035  87.572  1.00 72.11           O  
ATOM   1409  CB  GLN   202      15.157  50.892  86.845  1.00 73.80           C  
ATOM   1410  CG  GLN   202      14.783  49.699  85.993  1.00 73.00           C  
ATOM   1411  CD  GLN   202      15.285  48.388  86.568  1.00 73.10           C  
ATOM   1412  OE1 GLN   202      15.233  47.349  85.904  1.00 73.50           O  
ATOM   1413  NE2 GLN   202      15.776  48.427  87.806  1.00 71.54           N  
ATOM   1414  N   PHE   203      16.973  53.482  87.107  1.00 69.45           N  
ATOM   1415  CA  PHE   203      17.526  54.547  87.941  1.00 68.04           C  
ATOM   1416  C   PHE   203      17.067  55.913  87.416  1.00 68.43           C  
ATOM   1417  O   PHE   203      16.410  56.669  88.137  1.00 68.35           O  
ATOM   1418  CB  PHE   203      19.056  54.480  87.951  1.00 65.49           C  
ATOM   1419  CG  PHE   203      19.709  55.650  88.624  1.00 62.53           C  
ATOM   1420  CD1 PHE   203      19.941  56.830  87.931  1.00 62.08           C  
ATOM   1421  CD2 PHE   203      20.089  55.575  89.951  1.00 60.90           C  
ATOM   1422  CE1 PHE   203      20.542  57.923  88.556  1.00 62.00           C  
ATOM   1423  CE2 PHE   203      20.688  56.662  90.581  1.00 61.52           C  
ATOM   1424  CZ  PHE   203      20.915  57.836  89.881  1.00 61.62           C  
ATOM   1425  N   ILE   204      17.410  56.218  86.161  1.00 68.20           N  
ATOM   1426  CA  ILE   204      17.029  57.483  85.536  1.00 67.52           C  
ATOM   1427  C   ILE   204      15.503  57.620  85.562  1.00 67.97           C  
ATOM   1428  O   ILE   204      14.956  58.705  85.339  1.00 68.79           O  
ATOM   1429  CB  ILE   204      17.569  57.579  84.072  1.00 66.99           C  
ATOM   1430  CG1 ILE   204      19.101  57.482  84.074  1.00 66.55           C  
ATOM   1431  CG2 ILE   204      17.189  58.911  83.445  1.00 64.54           C  
ATOM   1432  CD1 ILE   204      19.744  57.720  82.713  1.00 65.48           C  
ATOM   1433  N   GLU   205      14.821  56.519  85.863  1.00 67.10           N  
ATOM   1434  CA  GLU   205      13.370  56.527  85.943  1.00 66.69           C  
ATOM   1435  C   GLU   205      12.966  56.952  87.340  1.00 65.58           C  
ATOM   1436  O   GLU   205      11.959  57.631  87.523  1.00 68.90           O  
ATOM   1437  CB  GLU   205      12.815  55.142  85.659  1.00 67.68           C  
ATOM   1438  CG  GLU   205      11.358  55.137  85.255  1.00 71.24           C  
ATOM   1439  CD  GLU   205      11.010  53.918  84.425  1.00 74.41           C  
ATOM   1440  OE1 GLU   205      11.160  52.789  84.967  1.00 76.62           O  
ATOM   1441  OE2 GLU   205      10.598  54.090  83.241  1.00 71.65           O  
ATOM   1442  N   GLN   206      13.746  56.542  88.331  1.00 62.02           N  
ATOM   1443  CA  GLN   206      13.447  56.914  89.698  1.00 58.05           C  
ATOM   1444  C   GLN   206      14.009  58.292  89.917  1.00 57.05           C  
ATOM   1445  O   GLN   206      13.497  59.054  90.717  1.00 56.80           O  
ATOM   1446  CB  GLN   206      14.103  55.962  90.680  1.00 57.90           C  
ATOM   1447  CG  GLN   206      14.098  56.472  92.108  1.00 56.31           C  
ATOM   1448  CD  GLN   206      12.749  56.321  92.767  1.00 55.57           C  
ATOM   1449  OE1 GLN   206      12.435  57.014  93.741  1.00 52.00           O  
ATOM   1450  NE2 GLN   206      11.943  55.397  92.248  1.00 55.98           N  
ATOM   1451  N   PHE   207      15.078  58.613  89.207  1.00 56.92           N  
ATOM   1452  CA  PHE   207      15.687  59.919  89.362  1.00 57.13           C  
ATOM   1453  C   PHE   207      14.760  60.998  88.875  1.00 59.67           C  
ATOM   1454  O   PHE   207      14.610  62.020  89.525  1.00 60.53           O  
ATOM   1455  CB  PHE   207      17.002  59.988  88.587  1.00 53.08           C  
ATOM   1456  CG  PHE   207      17.651  61.353  88.576  1.00 48.74           C  
ATOM   1457  CD1 PHE   207      17.185  62.365  87.746  1.00 47.05           C  
ATOM   1458  CD2 PHE   207      18.778  61.601  89.353  1.00 46.14           C  
ATOM   1459  CE1 PHE   207      17.842  63.597  87.690  1.00 45.78           C  
ATOM   1460  CE2 PHE   207      19.434  62.829  89.299  1.00 43.07           C  
ATOM   1461  CZ  PHE   207      18.968  63.822  88.467  1.00 44.02           C  
ATOM   1462  N   MET   208      14.130  60.766  87.730  1.00 63.77           N  
ATOM   1463  CA  MET   208      13.238  61.758  87.134  1.00 67.60           C  
ATOM   1464  C   MET   208      11.990  62.069  87.943  1.00 67.17           C  
ATOM   1465  O   MET   208      11.653  63.235  88.155  1.00 66.24           O  
ATOM   1466  CB  MET   208      12.837  61.307  85.734  1.00 72.75           C  
ATOM   1467  CG  MET   208      12.999  62.402  84.695  1.00 77.43           C  
ATOM   1468  SD  MET   208      14.721  63.292  84.858  1.00 85.66          SE  
ATOM   1469  CE  MET   208      15.860  61.781  84.437  1.00 81.71           C  
ATOM   1470  N   LYS   209      11.299  61.017  88.370  1.00 66.99           N  
ATOM   1471  CA  LYS   209      10.101  61.183  89.163  1.00 67.08           C  
ATOM   1472  C   LYS   209      10.442  62.065  90.363  1.00 67.63           C  
ATOM   1473  O   LYS   209       9.660  62.929  90.753  1.00 68.29           O  
ATOM   1474  CB  LYS   209       9.571  59.823  89.628  1.00 67.18           C  
ATOM   1475  CG  LYS   209      10.561  59.017  90.444  1.00 69.08           C  
ATOM   1476  CD  LYS   209       9.873  57.923  91.265  1.00 70.30           C  
ATOM   1477  CE  LYS   209       9.260  56.820  90.403  1.00 71.66           C  
ATOM   1478  NZ  LYS   209       8.714  55.728  91.266  1.00 69.38           N  
ATOM   1479  N   GLU   210      11.619  61.861  90.943  1.00 67.64           N  
ATOM   1480  CA  GLU   210      12.026  62.665  92.086  1.00 67.63           C  
ATOM   1481  C   GLU   210      12.238  64.102  91.643  1.00 67.64           C  
ATOM   1482  O   GLU   210      11.858  65.035  92.344  1.00 68.55           O  
ATOM   1483  CB  GLU   210      13.310  62.106  92.712  1.00 67.21           C  
ATOM   1484  CG  GLU   210      13.060  60.920  93.643  1.00 67.45           C  
ATOM   1485  CD  GLU   210      14.307  60.085  93.902  1.00 67.68           C  
ATOM   1486  OE1 GLU   210      15.361  60.664  94.258  1.00 66.52           O  
ATOM   1487  OE2 GLU   210      14.225  58.843  93.758  1.00 66.77           O  
ATOM   1488  N   TRP   211      12.824  64.277  90.466  1.00 67.75           N  
ATOM   1489  CA  TRP   211      13.089  65.613  89.942  1.00 68.73           C  
ATOM   1490  C   TRP   211      11.819  66.456  89.872  1.00 71.34           C  
ATOM   1491  O   TRP   211      11.869  67.687  89.964  1.00 72.36           O  
ATOM   1492  CB  TRP   211      13.721  65.511  88.554  1.00 65.05           C  
ATOM   1493  CG  TRP   211      14.083  66.831  87.973  1.00 60.34           C  
ATOM   1494  CD1 TRP   211      13.336  67.580  87.125  1.00 58.89           C  
ATOM   1495  CD2 TRP   211      15.285  67.568  88.215  1.00 58.39           C  
ATOM   1496  NE1 TRP   211      13.999  68.744  86.818  1.00 58.58           N  
ATOM   1497  CE2 TRP   211      15.199  68.760  87.475  1.00 58.00           C  
ATOM   1498  CE3 TRP   211      16.428  67.334  88.988  1.00 57.38           C  
ATOM   1499  CZ2 TRP   211      16.208  69.717  87.479  1.00 58.40           C  
ATOM   1500  CZ3 TRP   211      17.434  68.286  88.995  1.00 56.85           C  
ATOM   1501  CH2 TRP   211      17.317  69.465  88.243  1.00 58.01           C  
ATOM   1502  N   ASN   212      10.688  65.774  89.712  1.00 72.93           N  
ATOM   1503  CA  ASN   212       9.386  66.418  89.627  1.00 73.92           C  
ATOM   1504  C   ASN   212       8.563  66.067  90.854  1.00 73.58           C  
ATOM   1505  O   ASN   212       7.333  66.089  90.820  1.00 73.75           O  
ATOM   1506  CB  ASN   212       8.656  65.933  88.383  1.00 74.55           C  
ATOM   1507  CG  ASN   212       9.569  65.839  87.190  1.00 74.30           C  
ATOM   1508  OD1 ASN   212      10.203  66.825  86.810  1.00 73.51           O  
ATOM   1509  ND2 ASN   212       9.652  64.648  86.592  1.00 72.49           N  
ATOM   1510  N   ALA   213       9.247  65.724  91.935  1.00 73.45           N  
ATOM   1511  CA  ALA   213       8.563  65.373  93.168  1.00 73.35           C  
ATOM   1512  C   ALA   213       7.355  64.485  92.894  1.00 72.17           C  
ATOM   1513  O   ALA   213       6.223  64.953  92.952  1.00 71.56           O  
ATOM   1514  CB  ALA   213       8.116  66.640  93.888  1.00 73.56           C  
ATOM   1515  N   GLN   214       7.593  63.211  92.590  1.00 71.22           N  
ATOM   1516  CA  GLN   214       6.493  62.298  92.326  1.00 70.87           C  
ATOM   1517  C   GLN   214       6.192  61.552  93.616  1.00 72.22           C  
ATOM   1518  O   GLN   214       5.205  61.922  94.309  1.00 72.70           O  
ATOM   1519  CB  GLN   214       6.866  61.306  91.215  1.00 69.86           C  
ATOM   1520  CG  GLN   214       5.807  61.144  90.105  1.00 69.07           C  
ATOM   1521  CD  GLN   214       6.185  61.828  88.777  1.00 68.53           C  
ATOM   1522  OE1 GLN   214       7.066  61.312  88.062  1.00 67.41           O  
ATOM   1523  NE2 GLN   214       5.605  62.887  88.450  1.00 66.63           N  
END
