
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  189 ( 1472),  selected  189 , name 3ccg_A
# Molecule2: number of CA atoms  188 ( 1523),  selected  188 , name T0470.pdb
# PARAMETERS: 3ccg_A.T0470.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     0_A      T       2           -
LGA    X     1_A      -       -           -
LGA    W     2_A      K       3           #
LGA    -       -      Q       4           -
LGA    -       -      E       5           -
LGA    S     3_A      K       6          4.574
LGA    -       -      I       7           -
LGA    Y     4_A      E       8          2.435
LGA    D     5_A      K       9          3.881
LGA    -       -      T      10           -
LGA    -       -      I      11           -
LGA    K     6_A      T      12          2.806
LGA    I     7_A      F      13          1.572
LGA    T     8_A      V      14          3.779
LGA    D     9_A      K      15          2.772
LGA    Y    10_A      H      16          2.367
LGA    L    11_A      I      17          4.324
LGA    X    12_A      L      18          3.239
LGA    N    13_A      E      19          1.686
LGA    -       -      K      20           -
LGA    N    14_A      D      21          4.590
LGA    L    15_A      A      22          4.645
LGA    G    16_A      S      23          1.940
LGA    -       -      G      24           -
LGA    E    17_A      H      25          0.523
LGA    K    18_A      D      26          3.043
LGA    R    19_A      -       -           -
LGA    Y    20_A      W      27          1.847
LGA    K    21_A      Y      28          1.708
LGA    H    22_A      H      29          1.622
LGA    S    23_A      I      30          1.168
LGA    L    24_A      R      31          0.992
LGA    G    25_A      R      32          1.796
LGA    V    26_A      V      33          1.791
LGA    X    27_A      H      34          1.060
LGA    D    28_A      K      35          1.649
LGA    T    29_A      M      36          2.023
LGA    A    30_A      A      37          1.660
LGA    V    31_A      I      38          1.451
LGA    R    32_A      S      39          2.068
LGA    L    33_A      L      40          2.151
LGA    A    34_A      S      41          1.456
LGA    G    35_A      E      42          1.520
LGA    I    36_A      Q      43          2.051
LGA    Y    37_A      E      44          1.948
LGA    N    38_A      G      45          1.090
LGA    E    39_A      G      46          0.830
LGA    D    40_A      N      47          1.634
LGA    T    41_A      R      48          1.487
LGA    E    42_A      F      49          1.765
LGA    K    43_A      I      50          1.379
LGA    A    44_A      I      51          1.097
LGA    R    45_A      E      52          1.196
LGA    I    46_A      M      53          1.195
LGA    A    47_A      A      54          0.600
LGA    G    48_A      A      55          0.416
LGA    L    49_A      L      56          0.896
LGA    V    50_A      L      57          0.935
LGA    H    51_A      H      58          0.879
LGA    D    52_A      D      59          0.726
LGA    C    53_A      V      60          0.402
LGA    A    54_A      A      61          2.549
LGA    K    55_A      D      62          2.601
LGA    K    56_A      L      65          1.720
LGA    L    57_A      N      66          2.860
LGA    P    58_A      -       -           -
LGA    G    59_A      -       -           -
LGA    E    60_A      -       -           -
LGA    K    61_A      E      67          4.097
LGA    I    62_A      S      68          1.719
LGA    I    63_A      E      69          3.693
LGA    E    64_A      E      70           #
LGA    I    65_A      A      71          2.612
LGA    C    66_A      -       -           -
LGA    T    67_A      -       -           -
LGA    N    68_A      -       -           -
LGA    E    69_A      -       -           -
LGA    G    70_A      -       -           -
LGA    Y    71_A      -       -           -
LGA    E    72_A      -       -           -
LGA    L    73_A      -       -           -
LGA    G    74_A      -       -           -
LGA    D    75_A      -       -           -
LGA    E    76_A      -       -           -
LGA    D    77_A      -       -           -
LGA    I    78_A      -       -           -
LGA    R    79_A      -       -           -
LGA    N    80_A      -       -           -
LGA    S    81_A      -       -           -
LGA    Y    82_A      -       -           -
LGA    L    83_A      -       -           -
LGA    L    84_A      -       -           -
LGA    H    85_A      -       -           -
LGA    G    86_A      -       -           -
LGA    L    87_A      -       -           -
LGA    A    88_A      -       -           -
LGA    G    89_A      G      72          3.819
LGA    R    90_A      M      73          3.092
LGA    I    91_A      K      74          1.972
LGA    L    92_A      K      75          1.440
LGA    A    93_A      V      76          1.398
LGA    K    94_A      S      77          1.473
LGA    K    95_A      D      78          1.040
LGA    V    96_A      W      79          3.302
LGA    I    97_A      L      80          4.766
LGA    G    98_A      E      81          2.950
LGA    I    99_A      E      82           #
LGA    -       -      L      83           -
LGA    -       -      H      84           -
LGA    D   100_A      V      85          3.855
LGA    -       -      E      86           -
LGA    -       -      E      87           -
LGA    -       -      E      88           -
LGA    -       -      E      89           -
LGA    D   101_A      S      90          1.556
LGA    E   102_A      K      91          1.505
LGA    D   103_A      H      92          1.138
LGA    V   104_A      V      93          0.753
LGA    L   105_A      L      94          1.134
LGA    N   106_A      H      95          0.702
LGA    A   107_A      I      96          1.235
LGA    I   108_A      I      97          0.526
LGA    E   109_A      A      98          1.448
LGA    F   110_A      N      99          1.743
LGA    H   111_A      M     100          1.879
LGA    T   112_A      -       -           -
LGA    T   113_A      -       -           -
LGA    G   114_A      -       -           -
LGA    R   115_A      -       -           -
LGA    P   116_A      -       -           -
LGA    N   117_A      -       -           -
LGA    X   118_A      -       -           -
LGA    S   119_A      S     112          1.572
LGA    L   120_A      I     113          1.395
LGA    L   121_A      E     114          1.567
LGA    E   122_A      G     115          2.068
LGA    K   123_A      K     116          1.567
LGA    I   124_A      L     117          1.650
LGA    I   125_A      V     118          2.066
LGA    Y   126_A      Q     119          2.424
LGA    I   127_A      D     120          2.681
LGA    A   128_A      A     121          2.095
LGA    D   129_A      D     122          1.705
LGA    Y   130_A      R     123          0.715
LGA    I   131_A      L     124          0.834
LGA    E   132_A      D     125          2.588
LGA    P   133_A      -       -           -
LGA    G   134_A      A     126          5.392
LGA    R   135_A      L     127          3.914
LGA    E   136_A      G     128          4.611
LGA    -       -      A     129           -
LGA    -       -      I     130           -
LGA    -       -      G     131           -
LGA    -       -      I     132           -
LGA    -       -      A     133           -
LGA    -       -      R     134           -
LGA    -       -      T     135           -
LGA    -       -      F     136           -
LGA    -       -      A     137           -
LGA    -       -      Y     138           -
LGA    -       -      G     139           -
LGA    -       -      G     140           -
LGA    -       -      A     141           -
LGA    -       -      K     142           -
LGA    -       -      G     143           -
LGA    -       -      R     144           -
LGA    -       -      L     145           -
LGA    -       -      M     146           -
LGA    -       -      Y     147           -
LGA    -       -      D     148           -
LGA    -       -      P     149           -
LGA    -       -      T     150           -
LGA    -       -      I     151           -
LGA    -       -      P     152           -
LGA    -       -      P     153           -
LGA    -       -      R     154           -
LGA    -       -      D     167           -
LGA    -       -      P     168           -
LGA    -       -      S     169           -
LGA    -       -      L     170           -
LGA    -       -      N     171           -
LGA    -       -      H     172           -
LGA    -       -      F     173           -
LGA    -       -      Y     174           -
LGA    -       -      E     175           -
LGA    -       -      K     176           -
LGA    F   137_A      L     177          2.788
LGA    K   138_A      L     178          1.821
LGA    G   139_A      K     179          3.406
LGA    V   140_A      L     180          4.045
LGA    D   141_A      K     181          4.414
LGA    E   142_A      -       -           -
LGA    L   143_A      -       -           -
LGA    R   144_A      D     182           #
LGA    K   145_A      L     183           -
LGA    A   146_A      M     184          4.805
LGA    A   147_A      N     185          3.814
LGA    D   148_A      T     186          4.449
LGA    E   149_A      N     187          1.968
LGA    -       -      A     188           -
LGA    -       -      A     189           -
LGA    D   150_A      K     190           #
LGA    L   151_A      Q     191           -
LGA    N   152_A      E     192           -
LGA    K   153_A      -       -           -
LGA    A   154_A      A     193           #
LGA    L   155_A      E     194           -
LGA    L   156_A      V     195           -
LGA    X   157_A      R     196           -
LGA    S   158_A      H     197           -
LGA    F   159_A      R     198           -
LGA    D   160_A      Y     199           -
LGA    N   161_A      M     200           -
LGA    T   162_A      E     201           -
LGA    I   163_A      Q     202           -
LGA    K   164_A      F     203           -
LGA    F   165_A      I     204           -
LGA    V   166_A      E     205           -
LGA    I   167_A      Q     206           -
LGA    D   168_A      F     207           -
LGA    K   169_A      M     208           -
LGA    G   170_A      K     209           -
LGA    G   171_A      E     210           -
LGA    F   172_A      W     211           -
LGA    L   173_A      N     212           -
LGA    H   174_A      A     213           -
LGA    H   175_A      Q     214           -
LGA    N   176_A      -       -           -
LGA    T   177_A      -       -           -
LGA    I   178_A      -       -           -
LGA    E   179_A      -       -           -
LGA    A   180_A      -       -           -
LGA    R   181_A      -       -           -
LGA    N   182_A      -       -           -
LGA    Y   183_A      -       -           -
LGA    L   184_A      -       -           -
LGA    I   185_A      -       -           -
LGA    S   186_A      -       -           -
LGA    R   187_A      -       -           -
LGA    K   188_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  189  188    5.0    106    2.48    16.04     39.250     4.116

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.482619 * X  +  -0.864183 * Y  +  -0.142357 * Z  +  53.941490
  Y_new =   0.265657 * X  +   0.299323 * Y  +  -0.916424 * Z  +  48.285549
  Z_new =   0.834569 * X  +   0.404466 * Y  +   0.374035 * Z  +  50.402065 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.824467   -2.317126  [ DEG:    47.2385   -132.7615 ]
  Theta =  -0.987350   -2.154243  [ DEG:   -56.5710   -123.4290 ]
  Phi   =   0.503187   -2.638406  [ DEG:    28.8305   -151.1695 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3ccg_A                                        
REMARK     2: T0470.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3ccg_A.T0470.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  189  188   5.0  106   2.48   16.04  39.250
REMARK  ---------------------------------------------------------- 
MOLECULE 3ccg_A
HEADER    HYDROLASE                               25-FEB-08   3CCG              
TITLE     CRYSTAL STRUCTURE OF PREDICTED HD SUPERFAMILY HYDROLASE               
TITLE    2 INVOLVED IN NAD METABOLISM (NP_347894.1) FROM CLOSTRIDIUM            
TITLE    3 ACETOBUTYLICUM AT 1.50 A RESOLUTION                                  
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HD SUPERFAMILY HYDROLASE;                                  
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: CLOSTRIDIUM ACETOBUTYLICUM ATCC 824;            
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: DSM 792 / JCM 1419 / LMG 5710 / VKM B-1787;                  
SOURCE   5 GENE: NP_347894.1, CA_C1263;                                         
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    NP_347894.1, PREDICTED HD SUPERFAMILY HYDROLASE INVOLVED IN           
KEYWDS   2 NAD METABOLISM, HD DOMAIN, STRUCTURAL GENOMICS, JOINT                
KEYWDS   3 CENTER FOR STRUCTURAL GENOMICS, JCSG, PROTEIN STRUCTURE              
KEYWDS   4 INITIATIVE, PSI-2                                                    
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   11-MAR-08 3CCG    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF PREDICTED HD SUPERFAMILY                
JRNL        TITL 2 HYDROLASE INVOLVED IN NAD METABOLISM (NP_347894.1)           
JRNL        TITL 3 FROM CLOSTRIDIUM ACETOBUTYLICUM AT 1.50 A                    
JRNL        TITL 4 RESOLUTION                                                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.50 ANGSTROMS.                                          
DBREF  3CCG A    1   189  UNP    Q97JL1   Q97JL1_CLOAB     1    189             
SEQRES   1 A  190  GLY MSE TRP SER TYR ASP LYS ILE THR ASP TYR LEU MSE          
SEQRES   2 A  190  ASN ASN LEU GLY GLU LYS ARG TYR LYS HIS SER LEU GLY          
SEQRES   3 A  190  VAL MSE ASP THR ALA VAL ARG LEU ALA GLY ILE TYR ASN          
SEQRES   4 A  190  GLU ASP THR GLU LYS ALA ARG ILE ALA GLY LEU VAL HIS          
SEQRES   5 A  190  ASP CYS ALA LYS LYS LEU PRO GLY GLU LYS ILE ILE GLU          
SEQRES   6 A  190  ILE CYS THR ASN GLU GLY TYR GLU LEU GLY ASP GLU ASP          
SEQRES   7 A  190  ILE ARG ASN SER TYR LEU LEU HIS GLY LEU ALA GLY ARG          
SEQRES   8 A  190  ILE LEU ALA LYS LYS VAL ILE GLY ILE ASP ASP GLU ASP          
SEQRES   9 A  190  VAL LEU ASN ALA ILE GLU PHE HIS THR THR GLY ARG PRO          
SEQRES  10 A  190  ASN MSE SER LEU LEU GLU LYS ILE ILE TYR ILE ALA ASP          
SEQRES  11 A  190  TYR ILE GLU PRO GLY ARG GLU PHE LYS GLY VAL ASP GLU          
SEQRES  12 A  190  LEU ARG LYS ALA ALA ASP GLU ASP LEU ASN LYS ALA LEU          
SEQRES  13 A  190  LEU MSE SER PHE ASP ASN THR ILE LYS PHE VAL ILE ASP          
SEQRES  14 A  190  LYS GLY GLY PHE LEU HIS HIS ASN THR ILE GLU ALA ARG          
SEQRES  15 A  190  ASN TYR LEU ILE SER ARG LYS GLY                              
HET    MSE  A   1       8                                                       
HET    MSE  A  12      16                                                       
HET    MSE  A  27       8                                                       
HET    MSE  A 118       8                                                       
HET    MSE  A 157      16                                                       
HET     FE  A 190       1                                                       
HET     FE  A 191       1                                                       
HET    PO4  A 192       5                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      FE FE (III) ION                                                     
HETNAM     PO4 PHOSPHATE ION                                                    
FORMUL   1  MSE    5(C5 H11 N O2 SE)                                            
FORMUL   2   FE    2(FE 3+)                                                     
FORMUL   4  PO4    O4 P 3-                                                      
FORMUL   5  HOH   *198(H2 O)                                                    
CRYST1   90.540   36.320   72.600  90.00 125.46  90.00 C 1 2 1       4          
ATOM      1  N   GLY A   0      62.531  36.549  83.002  1.00 34.10           N  
ATOM      2  CA  GLY A   0      61.352  35.643  83.144  1.00 34.60           C  
ATOM      3  C   GLY A   0      60.107  36.469  83.464  1.00 32.45           C  
ATOM      4  O   GLY A   0      60.210  37.695  83.642  1.00 36.99           O  
HETATM    5  N   MSE A   1      58.948  35.823  83.551  1.00 27.38           N  
HETATM    6  CA  MSE A   1      57.714  36.565  83.874  1.00 25.74           C  
HETATM    7  C   MSE A   1      57.532  36.887  85.343  1.00 26.28           C  
HETATM    8  O   MSE A   1      57.719  36.034  86.220  1.00 25.50           O  
HETATM    9  CB  MSE A   1      56.473  35.852  83.409  1.00 25.75           C  
HETATM   10  CG  MSE A   1      55.233  36.816  83.426  1.00 27.66           C  
HETATM   11 SE   MSE A   1      53.773  35.871  82.826  0.75 38.45          SE  
HETATM   12  CE  MSE A   1      52.338  36.723  83.632  1.00 10.30           C  
ATOM     13  N   TRP A   2      57.101  38.114  85.614  1.00 20.20           N  
ATOM     14  CA  TRP A   2      56.879  38.539  86.966  1.00 20.24           C  
ATOM     15  C   TRP A   2      55.763  37.789  87.644  1.00 16.54           C  
ATOM     16  O   TRP A   2      54.821  37.323  86.998  1.00 18.91           O  
ATOM     17  CB  TRP A   2      56.491  40.019  87.067  1.00 19.18           C  
ATOM     18  CG  TRP A   2      57.558  40.969  86.730  1.00 18.78           C  
ATOM     19  CD1 TRP A   2      58.876  40.676  86.533  1.00 23.59           C  
ATOM     20  CD2 TRP A   2      57.453  42.404  86.677  1.00 17.70           C  
ATOM     21  NE1 TRP A   2      59.583  41.828  86.296  1.00 21.26           N  
ATOM     22  CE2 TRP A   2      58.741  42.904  86.399  1.00 22.82           C  
ATOM     23  CE3 TRP A   2      56.393  43.308  86.831  1.00 19.87           C  
ATOM     24  CZ2 TRP A   2      59.003  44.263  86.262  1.00 24.70           C  
ATOM     25  CZ3 TRP A   2      56.652  44.655  86.676  1.00 20.26           C  
ATOM     26  CH2 TRP A   2      57.969  45.118  86.418  1.00 17.16           C  
ATOM     27  N   SER A   3      55.877  37.694  88.977  1.00 19.01           N  
ATOM     28  CA  SER A   3      54.849  37.133  89.790  1.00 17.87           C  
ATOM     29  C   SER A   3      53.607  38.029  89.757  1.00 17.60           C  
ATOM     30  O   SER A   3      53.686  39.231  89.471  1.00 15.69           O  
ATOM     31  CB  SER A   3      55.291  37.040  91.263  1.00 20.31           C  
ATOM     32  OG  SER A   3      55.424  38.338  91.860  1.00 19.83           O  
ATOM     33  N   TYR A   4      52.478  37.420  90.036  0.50 16.16           N  
ATOM     35  CA  TYR A   4      51.248  38.150  90.111  0.50 15.06           C  
ATOM     37  C   TYR A   4      51.384  39.357  91.061  0.50 17.22           C  
ATOM     39  O   TYR A   4      51.021  40.466  90.712  0.50 15.99           O  
ATOM     41  CB  TYR A   4      50.154  37.194  90.555  0.50 18.39           C  
ATOM     43  CG  TYR A   4      48.798  37.827  90.608  0.50 13.88           C  
ATOM     45  CD1 TYR A   4      48.001  37.872  89.466  0.50 14.87           C  
ATOM     47  CD2 TYR A   4      48.324  38.411  91.772  0.50 18.94           C  
ATOM     49  CE1 TYR A   4      46.778  38.425  89.494  0.50 16.42           C  
ATOM     51  CE2 TYR A   4      47.090  39.000  91.806  0.50 14.12           C  
ATOM     53  CZ  TYR A   4      46.315  38.995  90.660  0.50 15.00           C  
ATOM     55  OH  TYR A   4      45.078  39.564  90.686  0.50 17.65           O  
ATOM     57  N   ASP A   5      51.964  39.132  92.240  1.00 16.04           N  
ATOM     58  CA  ASP A   5      52.090  40.150  93.266  1.00 15.62           C  
ATOM     59  C   ASP A   5      52.989  41.315  92.835  1.00 15.10           C  
ATOM     60  O   ASP A   5      52.712  42.477  93.167  1.00 16.89           O  
ATOM     61  CB  ASP A   5      52.561  39.520  94.581  1.00 17.10           C  
ATOM     62  CG  ASP A   5      51.449  38.784  95.289  1.00 18.87           C  
ATOM     63  OD1 ASP A   5      50.260  38.926  94.944  1.00 18.90           O  
ATOM     64  OD2 ASP A   5      51.789  38.048  96.237  1.00 18.19           O  
ATOM     65  N   LYS A   6      53.998  40.994  92.065  1.00 16.77           N  
ATOM     66  CA  LYS A   6      54.911  42.026  91.526  1.00 17.12           C  
ATOM     67  C   LYS A   6      54.142  42.867  90.504  1.00 17.93           C  
ATOM     68  O   LYS A   6      54.207  44.111  90.515  1.00 18.10           O  
ATOM     69  CB  LYS A   6      56.142  41.434  90.913  1.00 16.06           C  
ATOM     70  CG  LYS A   6      57.138  42.460  90.463  1.00 21.43           C  
ATOM     71  CD  LYS A   6      58.496  41.839  90.171  1.00 24.03           C  
ATOM     72  CE  LYS A   6      59.535  42.898  89.811  1.00 32.79           C  
ATOM     73  NZ  LYS A   6      60.889  42.290  89.606  1.00 36.45           N  
ATOM     74  N   ILE A   7      53.355  42.186  89.676  1.00 15.46           N  
ATOM     75  CA  ILE A   7      52.522  42.874  88.685  1.00 15.28           C  
ATOM     76  C   ILE A   7      51.518  43.799  89.339  1.00 16.31           C  
ATOM     77  O   ILE A   7      51.337  44.968  88.928  1.00 15.69           O  
ATOM     78  CB  ILE A   7      51.789  41.846  87.792  1.00 13.75           C  
ATOM     79  CG1 ILE A   7      52.788  41.124  86.929  1.00 17.80           C  
ATOM     80  CG2 ILE A   7      50.780  42.552  86.901  1.00 18.43           C  
ATOM     81  CD1 ILE A   7      52.230  39.857  86.251  1.00 18.79           C  
ATOM     82  N   THR A   8      50.836  43.331  90.371  1.00 14.51           N  
ATOM     83  CA  THR A   8      49.839  44.162  91.020  1.00 14.92           C  
ATOM     84  C   THR A   8      50.510  45.389  91.661  1.00 17.09           C  
ATOM     85  O   THR A   8      49.942  46.478  91.629  1.00 16.87           O  
ATOM     86  CB  THR A   8      48.904  43.401  91.994  1.00 20.82           C  
ATOM     87  OG1 THR A   8      49.712  42.750  92.965  1.00 23.45           O  
ATOM     88  CG2 THR A   8      48.060  42.378  91.225  1.00 19.63           C  
ATOM     89  N   ASP A   9      51.695  45.205  92.239  0.50 17.07           N  
ATOM     91  CA  ASP A   9      52.437  46.317  92.828  0.50 17.86           C  
ATOM     93  C   ASP A   9      52.721  47.360  91.760  0.50 17.18           C  
ATOM     95  O   ASP A   9      52.506  48.573  91.942  0.50 17.66           O  
ATOM     97  CB  ASP A   9      53.763  45.831  93.422  0.50 19.09           C  
ATOM     99  CG  ASP A   9      53.603  45.149  94.773  0.50 20.41           C  
ATOM    101  OD1 ASP A   9      52.507  45.206  95.363  0.50 23.04           O  
ATOM    103  OD2 ASP A   9      54.602  44.574  95.240  0.50 19.89           O  
ATOM    105  N   TYR A  10      53.213  46.868  90.635  1.00 16.62           N  
ATOM    106  CA  TYR A  10      53.571  47.738  89.510  1.00 17.44           C  
ATOM    107  C   TYR A  10      52.372  48.482  89.001  1.00 16.96           C  
ATOM    108  O   TYR A  10      52.447  49.689  88.721  1.00 17.43           O  
ATOM    109  CB  TYR A  10      54.155  46.890  88.416  1.00 16.70           C  
ATOM    110  CG  TYR A  10      54.507  47.566  87.093  1.00 21.33           C  
ATOM    111  CD1 TYR A  10      55.735  48.201  86.913  1.00 22.59           C  
ATOM    112  CD2 TYR A  10      53.685  47.426  85.994  1.00 26.34           C  
ATOM    113  CE1 TYR A  10      56.070  48.764  85.718  1.00 23.93           C  
ATOM    114  CE2 TYR A  10      54.017  47.985  84.781  1.00 27.03           C  
ATOM    115  CZ  TYR A  10      55.223  48.634  84.647  1.00 26.93           C  
ATOM    116  OH  TYR A  10      55.572  49.189  83.434  1.00 27.62           O  
ATOM    117  N   LEU A  11      51.251  47.795  88.830  1.00 14.97           N  
ATOM    118  CA  LEU A  11      50.029  48.442  88.314  1.00 14.94           C  
ATOM    119  C   LEU A  11      49.462  49.452  89.280  1.00 15.49           C  
ATOM    120  O   LEU A  11      49.034  50.542  88.871  1.00 18.75           O  
ATOM    121  CB  LEU A  11      48.965  47.395  87.905  1.00 14.75           C  
ATOM    122  CG  LEU A  11      49.328  46.459  86.756  1.00 16.20           C  
ATOM    123  CD1 LEU A  11      48.271  45.376  86.613  1.00 17.20           C  
ATOM    124  CD2 LEU A  11      49.564  47.225  85.428  1.00 14.23           C  
HETATM  125  N   MSE A  12      49.418  49.136  90.568  0.70 18.02           N  
HETATM  127  CA  MSE A  12      48.907  50.126  91.525  0.70 20.18           C  
HETATM  129  C   MSE A  12      49.772  51.400  91.494  0.70 20.86           C  
HETATM  131  O   MSE A  12      49.237  52.536  91.512  0.70 22.19           O  
HETATM  133  CB  MSE A  12      48.819  49.556  92.954  0.70 22.98           C  
HETATM  135  CG  MSE A  12      48.481  50.637  93.992  0.70 27.01           C  
HETATM  137 SE   MSE A  12      46.721  51.426  93.691  0.50 28.92          SE  
HETATM  139  CE  MSE A  12      45.601  50.113  94.572  0.70 34.30           C  
ATOM    141  N   ASN A  13      51.085  51.221  91.426  0.70 19.76           N  
ATOM    143  CA  ASN A  13      52.024  52.355  91.421  0.70 22.78           C  
ATOM    145  C   ASN A  13      51.888  53.235  90.189  0.70 22.19           C  
ATOM    147  O   ASN A  13      51.896  54.470  90.249  0.70 23.90           O  
ATOM    149  CB  ASN A  13      53.480  51.880  91.476  0.70 24.02           C  
ATOM    151  CG  ASN A  13      53.911  51.423  92.857  0.70 29.78           C  
ATOM    153  OD1 ASN A  13      53.476  51.971  93.872  0.70 33.95           O  
ATOM    155  ND2 ASN A  13      54.810  50.436  92.905  0.70 36.76           N  
ATOM    157  N   ASN A  14      51.682  52.585  89.064  1.00 18.56           N  
ATOM    158  CA  ASN A  14      51.677  53.267  87.768  1.00 21.01           C  
ATOM    159  C   ASN A  14      50.312  53.797  87.376  1.00 21.03           C  
ATOM    160  O   ASN A  14      50.216  54.843  86.737  1.00 23.71           O  
ATOM    161  CB  ASN A  14      52.274  52.382  86.661  1.00 22.63           C  
ATOM    162  CG  ASN A  14      53.799  52.356  86.689  1.00 30.55           C  
ATOM    163  OD1 ASN A  14      54.440  53.323  86.290  1.00 38.26           O  
ATOM    164  ND2 ASN A  14      54.378  51.270  87.150  1.00 35.87           N  
ATOM    165  N   LEU A  15      49.266  53.126  87.801  1.00 17.10           N  
ATOM    166  CA  LEU A  15      47.921  53.481  87.393  1.00 18.04           C  
ATOM    167  C   LEU A  15      47.138  54.289  88.419  1.00 18.97           C  
ATOM    168  O   LEU A  15      46.214  55.007  88.068  1.00 17.13           O  
ATOM    169  CB  LEU A  15      47.153  52.182  87.050  1.00 18.42           C  
ATOM    170  CG  LEU A  15      47.725  51.409  85.852  1.00 16.26           C  
ATOM    171  CD1 LEU A  15      46.844  50.231  85.582  1.00 16.15           C  
ATOM    172  CD2 LEU A  15      47.917  52.351  84.617  1.00 19.11           C  
ATOM    173  N   GLY A  16      47.472  54.123  89.691  1.00 17.38           N  
ATOM    174  CA  GLY A  16      46.703  54.805  90.744  1.00 20.48           C  
ATOM    175  C   GLY A  16      45.488  53.972  91.099  1.00 20.97           C  
ATOM    176  O   GLY A  16      45.146  52.992  90.408  1.00 19.41           O  
ATOM    177  N   GLU A  17      44.833  54.330  92.189  1.00 22.14           N  
ATOM    178  CA  GLU A  17      43.730  53.527  92.706  1.00 21.54           C  
ATOM    179  C   GLU A  17      42.571  53.263  91.767  1.00 20.21           C  
ATOM    180  O   GLU A  17      42.138  52.119  91.632  1.00 24.13           O  
ATOM    181  CB  GLU A  17      43.205  54.155  94.024  1.00 24.11           C  
ATOM    182  CG  GLU A  17      41.924  53.496  94.550  1.00 31.50           C  
ATOM    183  N   LYS A  18      42.029  54.301  91.161  1.00 19.60           N  
ATOM    184  CA  LYS A  18      40.827  54.157  90.364  1.00 22.20           C  
ATOM    185  C   LYS A  18      41.081  53.260  89.138  1.00 20.55           C  
ATOM    186  O   LYS A  18      40.319  52.301  88.878  1.00 20.54           O  
ATOM    187  CB  LYS A  18      40.336  55.527  89.951  1.00 22.48           C  
ATOM    188  CG  LYS A  18      38.938  55.581  89.420  1.00 31.77           C  
ATOM    189  N   ARG A  19      42.164  53.551  88.413  1.00 20.72           N  
ATOM    190  CA  ARG A  19      42.459  52.820  87.155  1.00 18.29           C  
ATOM    191  C   ARG A  19      42.924  51.382  87.468  1.00 18.89           C  
ATOM    192  O   ARG A  19      42.667  50.457  86.676  1.00 19.46           O  
ATOM    193  CB  ARG A  19      43.432  53.597  86.308  1.00 18.78           C  
ATOM    194  CG  ARG A  19      43.667  53.038  84.908  1.00 23.68           C  
ATOM    195  CD  ARG A  19      42.414  53.031  84.055  1.00 31.87           C  
ATOM    196  NE  ARG A  19      42.068  54.366  83.586  1.00 30.82           N  
ATOM    197  CZ  ARG A  19      41.131  54.582  82.676  1.00 32.00           C  
ATOM    198  NH1 ARG A  19      40.504  53.551  82.147  1.00 32.65           N  
ATOM    199  NH2 ARG A  19      40.852  55.806  82.291  1.00 35.11           N  
ATOM    200  N   TYR A  20      43.583  51.172  88.619  1.00 18.22           N  
ATOM    201  CA  TYR A  20      43.952  49.839  89.061  1.00 17.89           C  
ATOM    202  C   TYR A  20      42.691  49.030  89.371  1.00 18.23           C  
ATOM    203  O   TYR A  20      42.540  47.879  88.943  1.00 19.02           O  
ATOM    204  CB  TYR A  20      44.891  49.865  90.277  1.00 19.29           C  
ATOM    205  CG  TYR A  20      45.153  48.505  90.861  1.00 21.67           C  
ATOM    206  CD1 TYR A  20      45.946  47.592  90.208  1.00 21.83           C  
ATOM    207  CD2 TYR A  20      44.600  48.123  92.083  1.00 23.54           C  
ATOM    208  CE1 TYR A  20      46.182  46.339  90.728  1.00 22.42           C  
ATOM    209  CE2 TYR A  20      44.826  46.875  92.595  1.00 25.06           C  
ATOM    210  CZ  TYR A  20      45.610  45.993  91.923  1.00 25.16           C  
ATOM    211  OH  TYR A  20      45.852  44.752  92.414  1.00 28.47           O  
ATOM    212  N   LYS A  21      41.742  49.655  90.061  1.00 19.20           N  
ATOM    213  CA  LYS A  21      40.470  48.972  90.338  1.00 20.28           C  
ATOM    214  C   LYS A  21      39.760  48.595  89.031  1.00 20.54           C  
ATOM    215  O   LYS A  21      39.242  47.490  88.919  1.00 21.85           O  
ATOM    216  CB  LYS A  21      39.550  49.799  91.251  1.00 22.74           C  
ATOM    217  CG  LYS A  21      38.234  49.102  91.598  1.00 26.84           C  
ATOM    218  N   HIS A  22      39.726  49.519  88.067  1.00 21.74           N  
ATOM    219  CA  HIS A  22      39.178  49.252  86.695  1.00 19.99           C  
ATOM    220  C   HIS A  22      39.821  48.000  86.123  1.00 15.97           C  
ATOM    221  O   HIS A  22      39.151  47.125  85.591  1.00 17.95           O  
ATOM    222  CB  HIS A  22      39.350  50.477  85.724  1.00 21.32           C  
ATOM    223  CG  HIS A  22      39.325  50.169  84.232  1.00 20.00           C  
ATOM    224  ND1 HIS A  22      38.174  49.902  83.512  1.00 22.21           N  
ATOM    225  CD2 HIS A  22      40.327  50.245  83.307  1.00 24.61           C  
ATOM    226  CE1 HIS A  22      38.485  49.721  82.232  1.00 26.68           C  
ATOM    227  NE2 HIS A  22      39.787  49.937  82.075  1.00 21.49           N  
ATOM    228  N   SER A  23      41.144  47.934  86.246  1.00 15.49           N  
ATOM    229  CA  SER A  23      41.906  46.801  85.687  1.00 14.72           C  
ATOM    230  C   SER A  23      41.535  45.486  86.345  1.00 16.03           C  
ATOM    231  O   SER A  23      41.427  44.461  85.671  1.00 13.35           O  
ATOM    232  CB  SER A  23      43.392  47.054  85.786  1.00 14.26           C  
ATOM    233  OG  SER A  23      43.786  48.248  85.069  1.00 15.19           O  
ATOM    234  N   LEU A  24      41.320  45.497  87.649  1.00 16.36           N  
ATOM    235  CA  LEU A  24      40.867  44.255  88.324  1.00 15.96           C  
ATOM    236  C   LEU A  24      39.484  43.894  87.821  1.00 11.97           C  
ATOM    237  O   LEU A  24      39.132  42.736  87.642  1.00 15.32           O  
ATOM    238  CB  LEU A  24      40.824  44.396  89.847  1.00 19.00           C  
ATOM    239  CG  LEU A  24      42.171  44.568  90.543  1.00 19.36           C  
ATOM    240  CD1 LEU A  24      42.054  44.799  92.090  1.00 20.07           C  
ATOM    241  CD2 LEU A  24      43.056  43.382  90.274  1.00 19.69           C  
ATOM    242  N   GLY A  25      38.660  44.896  87.554  1.00 14.54           N  
ATOM    243  CA  GLY A  25      37.348  44.626  86.998  1.00 16.70           C  
ATOM    244  C   GLY A  25      37.438  43.992  85.625  1.00 16.36           C  
ATOM    245  O   GLY A  25      36.715  43.056  85.291  1.00 15.51           O  
ATOM    246  N   VAL A  26      38.329  44.536  84.815  1.00 14.98           N  
ATOM    247  CA  VAL A  26      38.505  43.960  83.488  1.00 12.95           C  
ATOM    248  C   VAL A  26      38.996  42.505  83.566  1.00 11.94           C  
ATOM    249  O   VAL A  26      38.524  41.612  82.836  1.00 13.55           O  
ATOM    250  CB  VAL A  26      39.421  44.846  82.593  1.00 14.62           C  
ATOM    251  CG1 VAL A  26      39.720  44.136  81.248  1.00 13.82           C  
ATOM    252  CG2 VAL A  26      38.706  46.197  82.398  1.00 14.87           C  
HETATM  253  N   MSE A  27      39.931  42.268  84.466  1.00 12.26           N  
HETATM  254  CA  MSE A  27      40.440  40.940  84.702  1.00 11.88           C  
HETATM  255  C   MSE A  27      39.329  39.979  85.053  1.00 12.49           C  
HETATM  256  O   MSE A  27      39.173  38.924  84.470  1.00 14.87           O  
HETATM  257  CB  MSE A  27      41.409  40.972  85.864  1.00 13.20           C  
HETATM  258  CG  MSE A  27      42.088  39.636  86.232  1.00 13.40           C  
HETATM  259 SE   MSE A  27      43.133  39.715  87.883  0.75 12.17          SE  
HETATM  260  CE  MSE A  27      41.536  39.976  89.080  1.00 18.96           C  
ATOM    261  N   ASP A  28      38.559  40.359  86.063  1.00 13.66           N  
ATOM    262  CA  ASP A  28      37.453  39.486  86.508  1.00 14.85           C  
ATOM    263  C   ASP A  28      36.442  39.230  85.367  1.00 14.34           C  
ATOM    264  O   ASP A  28      35.915  38.144  85.206  1.00 16.29           O  
ATOM    265  CB  ASP A  28      36.718  40.082  87.693  1.00 15.11           C  
ATOM    266  CG  ASP A  28      37.512  40.019  88.984  1.00 17.76           C  
ATOM    267  OD1 ASP A  28      38.422  39.188  89.124  1.00 19.85           O  
ATOM    268  OD2 ASP A  28      37.157  40.849  89.839  1.00 24.13           O  
ATOM    269  N   THR A  29      36.104  40.288  84.645  1.00 13.68           N  
ATOM    270  CA  THR A  29      35.169  40.173  83.544  1.00 13.40           C  
ATOM    271  C   THR A  29      35.691  39.282  82.429  1.00 13.06           C  
ATOM    272  O   THR A  29      34.966  38.444  81.862  1.00 14.56           O  
ATOM    273  CB  THR A  29      34.823  41.573  82.976  1.00 14.45           C  
ATOM    274  OG1 THR A  29      34.238  42.366  84.007  1.00 16.29           O  
ATOM    275  CG2 THR A  29      33.874  41.470  81.771  1.00 15.38           C  
ATOM    276  N   ALA A  30      36.972  39.451  82.094  1.00 12.64           N  
ATOM    277  CA  ALA A  30      37.624  38.619  81.087  1.00 13.22           C  
ATOM    278  C   ALA A  30      37.565  37.156  81.510  1.00 13.94           C  
ATOM    279  O   ALA A  30      37.305  36.294  80.717  1.00 13.97           O  
ATOM    280  CB  ALA A  30      39.093  39.046  80.871  1.00 12.42           C  
ATOM    281  N   VAL A  31      37.807  36.902  82.796  1.00 12.23           N  
ATOM    282  CA  VAL A  31      37.756  35.530  83.293  1.00 14.99           C  
ATOM    283  C   VAL A  31      36.349  34.972  83.179  1.00 14.51           C  
ATOM    284  O   VAL A  31      36.169  33.823  82.766  1.00 14.93           O  
ATOM    285  CB  VAL A  31      38.317  35.468  84.726  1.00 14.07           C  
ATOM    286  CG1 VAL A  31      38.020  34.092  85.404  1.00 15.93           C  
ATOM    287  CG2 VAL A  31      39.808  35.717  84.720  1.00 16.09           C  
ATOM    288  N   ARG A  32      35.362  35.797  83.520  1.00 14.08           N  
ATOM    289  CA  ARG A  32      33.947  35.372  83.445  1.00 14.14           C  
ATOM    290  C   ARG A  32      33.573  35.009  81.988  1.00 15.95           C  
ATOM    291  O   ARG A  32      33.021  33.935  81.658  1.00 18.31           O  
ATOM    292  CB  ARG A  32      33.038  36.452  84.005  1.00 16.61           C  
ATOM    293  CG  ARG A  32      31.552  36.067  84.041  1.00 17.80           C  
ATOM    294  CD  ARG A  32      30.696  37.141  84.623  1.00 21.38           C  
ATOM    295  NE  ARG A  32      30.753  38.389  83.864  1.00 22.76           N  
ATOM    296  CZ  ARG A  32      30.084  38.608  82.747  1.00 22.01           C  
ATOM    297  NH1 ARG A  32      29.346  37.655  82.213  1.00 23.88           N  
ATOM    298  NH2 ARG A  32      30.198  39.784  82.141  1.00 23.02           N  
ATOM    299  N   LEU A  33      33.980  35.879  81.051  1.00 15.50           N  
ATOM    300  CA  LEU A  33      33.650  35.648  79.666  1.00 14.64           C  
ATOM    301  C   LEU A  33      34.394  34.432  79.122  1.00 12.65           C  
ATOM    302  O   LEU A  33      33.920  33.702  78.250  1.00 16.79           O  
ATOM    303  CB  LEU A  33      33.930  36.911  78.826  1.00 15.12           C  
ATOM    304  CG  LEU A  33      33.041  38.108  79.050  1.00 14.66           C  
ATOM    305  CD1 LEU A  33      33.588  39.333  78.297  1.00 17.14           C  
ATOM    306  CD2 LEU A  33      31.580  37.841  78.607  1.00 17.59           C  
ATOM    307  N   ALA A  34      35.603  34.227  79.603  1.00 14.18           N  
ATOM    308  CA  ALA A  34      36.380  33.081  79.210  1.00 13.61           C  
ATOM    309  C   ALA A  34      35.696  31.769  79.562  1.00 15.54           C  
ATOM    310  O   ALA A  34      35.799  30.804  78.843  1.00 16.54           O  
ATOM    311  CB  ALA A  34      37.787  33.124  79.855  1.00 15.72           C  
ATOM    312  N   GLY A  35      35.056  31.793  80.726  1.00 17.87           N  
ATOM    313  CA  GLY A  35      34.269  30.636  81.172  1.00 20.21           C  
ATOM    314  C   GLY A  35      33.114  30.390  80.218  1.00 20.09           C  
ATOM    315  O   GLY A  35      32.876  29.247  79.818  1.00 23.87           O  
ATOM    316  N   ILE A  36      32.393  31.437  79.837  1.00 16.31           N  
ATOM    317  CA  ILE A  36      31.265  31.322  78.908  1.00 16.96           C  
ATOM    318  C   ILE A  36      31.692  30.792  77.529  1.00 19.94           C  
ATOM    319  O   ILE A  36      31.007  29.933  76.940  1.00 23.25           O  
ATOM    320  CB  ILE A  36      30.566  32.666  78.709  1.00 18.27           C  
ATOM    321  CG1 ILE A  36      29.849  33.087  80.003  1.00 17.22           C  
ATOM    322  CG2 ILE A  36      29.564  32.633  77.501  1.00 22.35           C  
ATOM    323  CD1 ILE A  36      29.370  34.532  80.065  1.00 22.49           C  
ATOM    324  N   TYR A  37      32.842  31.267  77.021  1.00 16.49           N  
ATOM    325  CA  TYR A  37      33.260  30.973  75.662  1.00 18.03           C  
ATOM    326  C   TYR A  37      34.373  29.936  75.521  1.00 18.03           C  
ATOM    327  O   TYR A  37      34.898  29.689  74.447  1.00 18.79           O  
ATOM    328  CB  TYR A  37      33.629  32.304  74.936  1.00 17.41           C  
ATOM    329  CG  TYR A  37      32.420  33.195  74.691  1.00 21.39           C  
ATOM    330  CD1 TYR A  37      31.536  32.935  73.637  1.00 22.36           C  
ATOM    331  CD2 TYR A  37      32.174  34.319  75.470  1.00 13.79           C  
ATOM    332  CE1 TYR A  37      30.441  33.720  73.424  1.00 22.67           C  
ATOM    333  CE2 TYR A  37      31.041  35.124  75.254  1.00 18.14           C  
ATOM    334  CZ  TYR A  37      30.182  34.801  74.212  1.00 19.35           C  
ATOM    335  OH  TYR A  37      29.096  35.599  73.982  1.00 21.96           O  
ATOM    336  N   ASN A  38      34.763  29.322  76.633  0.50 18.67           N  
ATOM    338  CA  ASN A  38      35.792  28.284  76.612  0.50 20.89           C  
ATOM    340  C   ASN A  38      37.201  28.786  76.235  0.50 19.27           C  
ATOM    342  O   ASN A  38      37.994  28.101  75.586  0.50 20.64           O  
ATOM    344  CB  ASN A  38      35.358  27.136  75.682  0.50 22.05           C  
ATOM    346  CG  ASN A  38      36.172  25.865  75.893  0.50 24.01           C  
ATOM    348  OD1 ASN A  38      36.691  25.619  76.978  0.50 25.51           O  
ATOM    350  ND2 ASN A  38      36.276  25.046  74.852  0.50 29.81           N  
ATOM    352  N   GLU A  39      37.515  30.006  76.662  1.00 17.19           N  
ATOM    353  CA  GLU A  39      38.837  30.538  76.454  1.00 16.83           C  
ATOM    354  C   GLU A  39      39.650  30.195  77.742  1.00 14.75           C  
ATOM    355  O   GLU A  39      39.100  29.993  78.840  1.00 15.69           O  
ATOM    356  CB  GLU A  39      38.809  32.053  76.173  1.00 16.13           C  
ATOM    357  CG  GLU A  39      40.152  32.703  75.938  1.00 16.43           C  
ATOM    358  CD  GLU A  39      40.915  32.015  74.846  1.00 17.06           C  
ATOM    359  OE1 GLU A  39      40.590  32.194  73.643  1.00 20.08           O  
ATOM    360  OE2 GLU A  39      41.830  31.215  75.162  1.00 21.93           O  
ATOM    361  N   ASP A  40      40.949  30.121  77.562  1.00 14.78           N  
ATOM    362  CA  ASP A  40      41.877  29.861  78.673  1.00 14.40           C  
ATOM    363  C   ASP A  40      41.717  30.891  79.768  1.00 15.88           C  
ATOM    364  O   ASP A  40      41.859  32.104  79.517  1.00 16.08           O  
ATOM    365  CB  ASP A  40      43.319  29.771  78.195  1.00 15.60           C  
ATOM    366  CG  ASP A  40      44.263  29.401  79.283  1.00 19.41           C  
ATOM    367  OD1 ASP A  40      44.687  30.260  80.025  1.00 19.95           O  
ATOM    368  OD2 ASP A  40      44.525  28.202  79.444  1.00 27.77           O  
ATOM    369  N   THR A  41      41.471  30.475  81.000  1.00 16.16           N  
ATOM    370  CA  THR A  41      41.167  31.465  82.015  1.00 17.45           C  
ATOM    371  C   THR A  41      42.377  32.289  82.440  1.00 15.17           C  
ATOM    372  O   THR A  41      42.205  33.460  82.786  1.00 15.16           O  
ATOM    373  CB  THR A  41      40.433  30.840  83.281  1.00 24.76           C  
ATOM    374  OG1 THR A  41      41.358  30.189  84.072  1.00 27.01           O  
ATOM    375  CG2 THR A  41      39.410  29.820  82.949  1.00 20.71           C  
ATOM    376  N   GLU A  42      43.555  31.699  82.419  1.00 15.55           N  
ATOM    377  CA  GLU A  42      44.744  32.425  82.861  1.00 14.90           C  
ATOM    378  C   GLU A  42      45.178  33.428  81.780  1.00 13.93           C  
ATOM    379  O   GLU A  42      45.632  34.509  82.111  1.00 14.48           O  
ATOM    380  CB  GLU A  42      45.881  31.485  83.275  1.00 19.32           C  
ATOM    381  CG  GLU A  42      46.882  32.171  84.203  1.00 20.61           C  
ATOM    382  CD  GLU A  42      46.337  32.604  85.597  1.00 33.37           C  
ATOM    383  OE1 GLU A  42      45.167  32.287  85.963  1.00 28.09           O  
ATOM    384  OE2 GLU A  42      47.114  33.268  86.335  1.00 35.56           O  
ATOM    385  N   LYS A  43      45.054  33.062  80.515  1.00 14.15           N  
ATOM    386  CA  LYS A  43      45.299  34.055  79.438  1.00 15.43           C  
ATOM    387  C   LYS A  43      44.360  35.260  79.620  1.00 12.96           C  
ATOM    388  O   LYS A  43      44.776  36.440  79.470  1.00 12.45           O  
ATOM    389  CB  LYS A  43      45.112  33.434  78.051  1.00 14.39           C  
ATOM    390  CG  LYS A  43      46.282  32.564  77.625  1.00 17.79           C  
ATOM    391  CD  LYS A  43      46.087  31.726  76.352  1.00 26.06           C  
ATOM    392  CE  LYS A  43      45.760  32.489  75.111  1.00 29.71           C  
ATOM    393  NZ  LYS A  43      45.620  31.638  73.825  1.00 21.26           N  
ATOM    394  N   ALA A  44      43.080  34.984  79.902  1.00 12.54           N  
ATOM    395  CA  ALA A  44      42.095  36.020  80.106  1.00 13.32           C  
ATOM    396  C   ALA A  44      42.471  36.867  81.324  1.00 12.93           C  
ATOM    397  O   ALA A  44      42.427  38.102  81.312  1.00 12.21           O  
ATOM    398  CB  ALA A  44      40.708  35.444  80.274  1.00 15.67           C  
ATOM    399  N   ARG A  45      42.796  36.207  82.428  0.50 11.67           N  
ATOM    401  CA  ARG A  45      43.174  36.925  83.673  0.50 10.09           C  
ATOM    403  C   ARG A  45      44.400  37.841  83.482  0.50 10.26           C  
ATOM    405  O   ARG A  45      44.415  38.989  83.943  0.50 10.28           O  
ATOM    407  CB  ARG A  45      43.445  35.922  84.824  0.50 11.56           C  
ATOM    409  CG  ARG A  45      43.811  36.568  86.205  0.50 11.98           C  
ATOM    411  CD  ARG A  45      44.276  35.541  87.270  0.50 11.12           C  
ATOM    413  NE  ARG A  45      43.361  34.411  87.256  0.50 12.95           N  
ATOM    415  CZ  ARG A  45      42.148  34.432  87.794  0.50 13.07           C  
ATOM    417  NH1 ARG A  45      41.739  35.509  88.434  0.50 14.92           N  
ATOM    419  NH2 ARG A  45      41.357  33.372  87.720  0.50 19.13           N  
ATOM    421  N   ILE A  46      45.456  37.341  82.859  1.00 13.22           N  
ATOM    422  CA  ILE A  46      46.670  38.180  82.718  1.00 14.11           C  
ATOM    423  C   ILE A  46      46.445  39.296  81.696  1.00 14.02           C  
ATOM    424  O   ILE A  46      46.815  40.421  81.940  1.00 13.73           O  
ATOM    425  CB  ILE A  46      47.906  37.376  82.373  1.00 15.65           C  
ATOM    426  CG1 ILE A  46      48.212  36.340  83.445  1.00 24.59           C  
ATOM    427  CG2 ILE A  46      49.191  38.278  82.188  1.00 17.10           C  
ATOM    428  CD1 ILE A  46      49.130  35.247  82.904  1.00 38.73           C  
ATOM    429  N   ALA A  47      45.833  38.977  80.565  1.00 12.30           N  
ATOM    430  CA  ALA A  47      45.611  40.023  79.590  1.00 11.76           C  
ATOM    431  C   ALA A  47      44.698  41.081  80.172  1.00 10.91           C  
ATOM    432  O   ALA A  47      44.925  42.277  79.987  1.00 11.26           O  
ATOM    433  CB  ALA A  47      45.007  39.410  78.317  1.00 11.95           C  
ATOM    434  N   GLY A  48      43.635  40.700  80.879  1.00 11.22           N  
ATOM    435  CA  GLY A  48      42.735  41.675  81.454  1.00 10.37           C  
ATOM    436  C   GLY A  48      43.415  42.518  82.535  1.00 12.11           C  
ATOM    437  O   GLY A  48      43.253  43.737  82.644  1.00 12.53           O  
ATOM    438  N   LEU A  49      44.220  41.851  83.363  1.00 12.54           N  
ATOM    439  CA  LEU A  49      44.913  42.556  84.411  1.00 12.57           C  
ATOM    440  C   LEU A  49      45.867  43.636  83.876  1.00 11.58           C  
ATOM    441  O   LEU A  49      45.891  44.743  84.421  1.00 13.34           O  
ATOM    442  CB  LEU A  49      45.688  41.579  85.298  1.00 13.67           C  
ATOM    443  CG  LEU A  49      46.461  42.176  86.501  1.00 14.62           C  
ATOM    444  CD1 LEU A  49      45.538  42.938  87.449  1.00 19.62           C  
ATOM    445  CD2 LEU A  49      47.238  41.061  87.195  1.00 18.91           C  
ATOM    446  N   VAL A  50      46.630  43.303  82.841  1.00 13.02           N  
ATOM    447  CA  VAL A  50      47.706  44.198  82.401  1.00 12.90           C  
ATOM    448  C   VAL A  50      47.389  45.037  81.174  1.00 13.54           C  
ATOM    449  O   VAL A  50      48.200  45.865  80.765  1.00 12.66           O  
ATOM    450  CB  VAL A  50      49.007  43.421  82.163  1.00 14.82           C  
ATOM    451  CG1 VAL A  50      49.347  42.522  83.383  1.00 13.68           C  
ATOM    452  CG2 VAL A  50      48.930  42.593  80.931  1.00 16.79           C  
ATOM    453  N   HIS A  51      46.176  44.947  80.670  1.00 12.98           N  
ATOM    454  CA  HIS A  51      45.836  45.561  79.370  1.00 12.86           C  
ATOM    455  C   HIS A  51      46.107  47.067  79.370  1.00 11.14           C  
ATOM    456  O   HIS A  51      46.453  47.601  78.300  1.00 10.93           O  
ATOM    457  CB  HIS A  51      44.387  45.299  78.962  1.00 14.11           C  
ATOM    458  CG  HIS A  51      43.405  46.173  79.653  1.00 13.92           C  
ATOM    459  ND1 HIS A  51      42.999  46.022  80.973  1.00 13.50           N  
ATOM    460  CD2 HIS A  51      42.758  47.265  79.201  1.00 12.88           C  
ATOM    461  CE1 HIS A  51      42.135  46.972  81.272  1.00 12.90           C  
ATOM    462  NE2 HIS A  51      41.987  47.759  80.221  1.00 14.46           N  
ATOM    463  N   ASP A  52      45.933  47.735  80.507  1.00 11.54           N  
ATOM    464  CA  ASP A  52      46.044  49.202  80.575  1.00 10.36           C  
ATOM    465  C   ASP A  52      47.388  49.580  81.242  1.00 11.86           C  
ATOM    466  O   ASP A  52      47.504  50.673  81.767  1.00 10.84           O  
ATOM    467  CB  ASP A  52      44.858  49.882  81.301  1.00 11.74           C  
ATOM    468  CG  ASP A  52      43.857  50.463  80.385  1.00 13.44           C  
ATOM    469  OD1 ASP A  52      44.031  50.513  79.162  1.00 12.14           O  
ATOM    470  OD2 ASP A  52      42.797  50.888  80.898  1.00 17.52           O  
ATOM    471  N   CYS A  53      48.372  48.699  81.241  1.00 11.97           N  
ATOM    472  CA  CYS A  53      49.619  48.985  81.938  1.00 10.77           C  
ATOM    473  C   CYS A  53      50.326  50.307  81.481  1.00 11.98           C  
ATOM    474  O   CYS A  53      51.147  50.906  82.246  1.00 11.86           O  
ATOM    475  CB  CYS A  53      50.564  47.760  81.962  1.00 11.38           C  
ATOM    476  SG  CYS A  53      51.248  47.311  80.382  1.00 12.66           S  
ATOM    477  N   ALA A  54      50.074  50.732  80.235  1.00 10.72           N  
ATOM    478  CA  ALA A  54      50.698  51.949  79.663  1.00 11.26           C  
ATOM    479  C   ALA A  54      49.724  53.116  79.629  1.00 11.76           C  
ATOM    480  O   ALA A  54      50.043  54.161  79.120  1.00 12.44           O  
ATOM    481  CB  ALA A  54      51.198  51.694  78.247  1.00 10.55           C  
ATOM    482  N   LYS A  55      48.548  52.932  80.228  1.00 12.45           N  
ATOM    483  CA  LYS A  55      47.490  53.938  80.148  1.00 13.44           C  
ATOM    484  C   LYS A  55      47.846  55.333  80.690  1.00 12.59           C  
ATOM    485  O   LYS A  55      47.376  56.338  80.133  1.00 13.93           O  
ATOM    486  CB  LYS A  55      46.244  53.417  80.899  1.00 13.81           C  
ATOM    487  CG  LYS A  55      45.028  54.415  80.963  1.00 14.41           C  
ATOM    488  CD  LYS A  55      44.503  54.610  79.621  1.00 14.10           C  
ATOM    489  CE  LYS A  55      43.153  55.412  79.663  1.00 14.31           C  
ATOM    490  NZ  LYS A  55      42.436  55.450  78.414  1.00 16.94           N  
ATOM    491  N   LYS A  56      48.627  55.377  81.732  1.00 12.60           N  
ATOM    492  CA  LYS A  56      48.936  56.630  82.402  1.00 12.25           C  
ATOM    493  C   LYS A  56      50.209  57.305  81.909  1.00 16.37           C  
ATOM    494  O   LYS A  56      50.717  58.239  82.513  1.00 19.55           O  
ATOM    495  CB  LYS A  56      49.035  56.432  83.916  1.00 15.66           C  
ATOM    496  CG  LYS A  56      47.742  56.090  84.587  1.00 20.23           C  
ATOM    497  CD  LYS A  56      46.802  57.273  84.509  1.00 24.53           C  
ATOM    498  CE  LYS A  56      45.612  57.088  85.470  1.00 25.39           C  
ATOM    499  NZ  LYS A  56      44.671  58.198  85.188  1.00 24.74           N  
ATOM    500  N   LEU A  57      50.701  56.892  80.770  1.00 17.61           N  
ATOM    501  CA  LEU A  57      51.873  57.571  80.192  1.00 16.29           C  
ATOM    502  C   LEU A  57      51.443  58.698  79.283  1.00 14.30           C  
ATOM    503  O   LEU A  57      50.380  58.626  78.622  1.00 15.20           O  
ATOM    504  CB  LEU A  57      52.672  56.569  79.390  1.00 14.30           C  
ATOM    505  CG  LEU A  57      53.303  55.422  80.167  1.00 17.21           C  
ATOM    506  CD1 LEU A  57      53.967  54.400  79.244  1.00 16.02           C  
ATOM    507  CD2 LEU A  57      54.307  56.006  81.146  1.00 21.13           C  
ATOM    508  N   PRO A  58      52.270  59.761  79.179  1.00 11.78           N  
ATOM    509  CA  PRO A  58      51.931  60.817  78.233  1.00 12.72           C  
ATOM    510  C   PRO A  58      52.006  60.316  76.815  1.00 12.59           C  
ATOM    511  O   PRO A  58      52.755  59.376  76.551  1.00 11.08           O  
ATOM    512  CB  PRO A  58      53.033  61.839  78.439  1.00 14.42           C  
ATOM    513  CG  PRO A  58      53.698  61.518  79.651  1.00 16.43           C  
ATOM    514  CD  PRO A  58      53.449  60.073  79.987  1.00 12.98           C  
ATOM    515  N   GLY A  59      51.231  60.864  75.911  1.00 11.94           N  
ATOM    516  CA  GLY A  59      51.212  60.432  74.507  1.00  9.62           C  
ATOM    517  C   GLY A  59      52.603  60.469  73.858  1.00 11.32           C  
ATOM    518  O   GLY A  59      52.968  59.613  73.060  1.00 10.48           O  
ATOM    519  N   GLU A  60      53.347  61.517  74.175  1.00 11.32           N  
ATOM    520  CA  GLU A  60      54.702  61.657  73.603  1.00 10.48           C  
ATOM    521  C   GLU A  60      55.558  60.450  74.020  1.00 10.97           C  
ATOM    522  O   GLU A  60      56.337  59.913  73.230  1.00 11.83           O  
ATOM    523  CB  GLU A  60      55.354  62.979  74.035  1.00 13.53           C  
ATOM    524  CG  GLU A  60      56.771  63.137  73.482  1.00 16.51           C  
ATOM    525  CD  GLU A  60      57.371  64.471  73.793  1.00 28.91           C  
ATOM    526  OE1 GLU A  60      56.701  65.307  74.464  1.00 28.93           O  
ATOM    527  OE2 GLU A  60      58.529  64.657  73.357  1.00 22.21           O  
ATOM    528  N   LYS A  61      55.438  60.036  75.290  1.00 12.03           N  
ATOM    529  CA  LYS A  61      56.240  58.896  75.800  1.00  9.49           C  
ATOM    530  C   LYS A  61      55.729  57.606  75.160  1.00 11.98           C  
ATOM    531  O   LYS A  61      56.499  56.695  74.822  1.00 12.28           O  
ATOM    532  CB  LYS A  61      56.149  58.845  77.315  1.00 12.26           C  
ATOM    533  CG  LYS A  61      56.891  57.707  77.942  1.00 17.05           C  
ATOM    534  CD  LYS A  61      58.348  57.701  77.580  1.00 21.64           C  
ATOM    535  CE  LYS A  61      59.141  58.727  78.308  1.00 31.93           C  
ATOM    536  NZ  LYS A  61      60.614  58.327  78.266  1.00 36.90           N  
ATOM    537  N   ILE A  62      54.433  57.462  75.033  1.00  9.23           N  
ATOM    538  CA  ILE A  62      53.842  56.278  74.346  1.00 10.68           C  
ATOM    539  C   ILE A  62      54.466  56.170  72.933  1.00 11.96           C  
ATOM    540  O   ILE A  62      54.942  55.104  72.507  1.00 11.18           O  
ATOM    541  CB  ILE A  62      52.330  56.375  74.317  1.00 11.81           C  
ATOM    542  CG1 ILE A  62      51.792  56.013  75.715  1.00 11.12           C  
ATOM    543  CG2 ILE A  62      51.662  55.419  73.265  1.00 12.45           C  
ATOM    544  CD1 ILE A  62      50.319  56.357  75.873  1.00 14.45           C  
ATOM    545  N   ILE A  63      54.472  57.280  72.211  1.00 10.90           N  
ATOM    546  CA  ILE A  63      55.014  57.277  70.870  1.00 10.81           C  
ATOM    547  C   ILE A  63      56.498  56.896  70.896  1.00 11.08           C  
ATOM    548  O   ILE A  63      56.973  56.098  70.062  1.00 11.83           O  
ATOM    549  CB  ILE A  63      54.802  58.634  70.209  1.00 11.07           C  
ATOM    550  CG1 ILE A  63      53.318  58.878  69.945  1.00 12.11           C  
ATOM    551  CG2 ILE A  63      55.625  58.765  68.903  1.00 11.21           C  
ATOM    552  CD1 ILE A  63      53.006  60.393  69.651  1.00 14.57           C  
ATOM    553  N   GLU A  64      57.231  57.457  71.832  0.50 10.23           N  
ATOM    555  CA  GLU A  64      58.657  57.156  71.978  0.50  9.19           C  
ATOM    557  C   GLU A  64      58.963  55.679  72.300  0.50 10.14           C  
ATOM    559  O   GLU A  64      59.994  55.140  71.843  0.50  9.50           O  
ATOM    561  CB  GLU A  64      59.246  58.090  73.040  0.50 10.31           C  
ATOM    563  CG  GLU A  64      59.421  59.472  72.500  0.50  9.11           C  
ATOM    565  CD  GLU A  64      59.598  60.563  73.559  0.50 10.89           C  
ATOM    567  OE1 GLU A  64      59.300  60.291  74.760  0.50 10.27           O  
ATOM    569  OE2 GLU A  64      59.964  61.711  73.160  0.50  8.09           O  
ATOM    571  N   ILE A  65      58.131  55.069  73.136  1.00  9.47           N  
ATOM    572  CA  ILE A  65      58.283  53.649  73.456  1.00 11.19           C  
ATOM    573  C   ILE A  65      58.024  52.809  72.216  1.00 10.04           C  
ATOM    574  O   ILE A  65      58.837  51.901  71.862  1.00 11.72           O  
ATOM    575  CB  ILE A  65      57.354  53.235  74.597  1.00 12.13           C  
ATOM    576  CG1 ILE A  65      57.856  53.844  75.884  1.00 13.70           C  
ATOM    577  CG2 ILE A  65      57.276  51.694  74.710  1.00 15.55           C  
ATOM    578  CD1 ILE A  65      56.830  53.798  77.057  1.00 16.79           C  
ATOM    579  N   CYS A  66      56.987  53.087  71.458  1.00  9.89           N  
ATOM    580  CA  CYS A  66      56.641  52.301  70.320  1.00  9.46           C  
ATOM    581  C   CYS A  66      57.735  52.445  69.227  1.00 11.19           C  
ATOM    582  O   CYS A  66      58.192  51.457  68.640  1.00 11.91           O  
ATOM    583  CB  CYS A  66      55.335  52.710  69.715  1.00  9.99           C  
ATOM    584  SG  CYS A  66      53.911  52.407  70.809  1.00 13.02           S  
ATOM    585  N   THR A  67      58.150  53.679  69.012  1.00 11.09           N  
ATOM    586  CA  THR A  67      59.173  53.983  67.990  1.00 10.56           C  
ATOM    587  C   THR A  67      60.513  53.351  68.341  1.00 10.50           C  
ATOM    588  O   THR A  67      61.180  52.706  67.484  1.00 11.60           O  
ATOM    589  CB  THR A  67      59.316  55.495  67.852  1.00 11.40           C  
ATOM    590  OG1 THR A  67      58.078  56.074  67.441  1.00 13.35           O  
ATOM    591  CG2 THR A  67      60.414  55.794  66.814  1.00 15.43           C  
ATOM    592  N   ASN A  68      60.938  53.466  69.581  1.00  9.84           N  
ATOM    593  CA  ASN A  68      62.223  52.919  70.042  1.00 11.12           C  
ATOM    594  C   ASN A  68      62.272  51.409  69.861  1.00 13.19           C  
ATOM    595  O   ASN A  68      63.328  50.853  69.548  1.00 12.91           O  
ATOM    596  CB  ASN A  68      62.498  53.246  71.495  1.00 11.67           C  
ATOM    597  CG  ASN A  68      63.914  52.893  71.896  1.00 18.31           C  
ATOM    598  OD1 ASN A  68      64.120  51.929  72.653  1.00 28.92           O  
ATOM    599  ND2 ASN A  68      64.865  53.604  71.355  1.00 18.10           N  
ATOM    600  N   GLU A  69      61.140  50.722  70.035  1.00 11.49           N  
ATOM    601  CA  GLU A  69      61.105  49.269  69.977  1.00 14.45           C  
ATOM    602  C   GLU A  69      60.926  48.791  68.551  1.00 15.75           C  
ATOM    603  O   GLU A  69      60.871  47.584  68.289  1.00 23.43           O  
ATOM    604  CB  GLU A  69      60.004  48.718  70.914  1.00 18.10           C  
ATOM    605  CG  GLU A  69      60.313  48.950  72.326  1.00 22.31           C  
ATOM    606  CD  GLU A  69      61.676  48.453  72.663  1.00 30.37           C  
ATOM    607  OE1 GLU A  69      61.973  47.320  72.219  1.00 34.37           O  
ATOM    608  OE2 GLU A  69      62.447  49.192  73.315  1.00 34.91           O  
ATOM    609  N   GLY A  70      60.853  49.683  67.578  1.00 14.33           N  
ATOM    610  CA  GLY A  70      60.852  49.287  66.187  1.00 18.62           C  
ATOM    611  C   GLY A  70      59.563  49.359  65.429  1.00 17.82           C  
ATOM    612  O   GLY A  70      59.511  49.008  64.239  1.00 18.23           O  
ATOM    613  N   TYR A  71      58.487  49.793  66.099  1.00 14.01           N  
ATOM    614  CA  TYR A  71      57.223  49.932  65.394  1.00 14.13           C  
ATOM    615  C   TYR A  71      57.184  51.201  64.578  1.00 16.24           C  
ATOM    616  O   TYR A  71      57.555  52.258  65.039  1.00 19.50           O  
ATOM    617  CB  TYR A  71      56.021  49.876  66.389  1.00 13.55           C  
ATOM    618  CG  TYR A  71      55.834  48.498  66.938  1.00 12.79           C  
ATOM    619  CD1 TYR A  71      56.543  48.045  68.043  1.00 15.86           C  
ATOM    620  CD2 TYR A  71      54.973  47.633  66.290  1.00 16.17           C  
ATOM    621  CE1 TYR A  71      56.338  46.739  68.509  1.00 15.63           C  
ATOM    622  CE2 TYR A  71      54.791  46.355  66.736  1.00 18.05           C  
ATOM    623  CZ  TYR A  71      55.478  45.922  67.796  1.00 13.49           C  
ATOM    624  OH  TYR A  71      55.215  44.620  68.221  1.00 24.11           O  
ATOM    625  N   GLU A  72      56.752  51.056  63.347  1.00 17.52           N  
ATOM    626  CA  GLU A  72      56.597  52.205  62.450  1.00 21.26           C  
ATOM    627  C   GLU A  72      55.218  52.827  62.682  1.00 20.51           C  
ATOM    628  O   GLU A  72      54.164  52.156  62.596  1.00 24.69           O  
ATOM    629  CB  GLU A  72      56.750  51.759  60.988  1.00 25.67           C  
ATOM    630  N   LEU A  73      55.222  54.083  63.079  1.00 20.82           N  
ATOM    631  CA  LEU A  73      53.982  54.792  63.272  1.00 18.38           C  
ATOM    632  C   LEU A  73      53.864  55.891  62.224  1.00 21.15           C  
ATOM    633  O   LEU A  73      54.799  56.653  61.976  1.00 24.67           O  
ATOM    634  CB  LEU A  73      53.907  55.436  64.656  1.00 20.12           C  
ATOM    635  CG  LEU A  73      54.085  54.506  65.856  1.00 20.69           C  
ATOM    636  CD1 LEU A  73      54.080  55.338  67.108  1.00 19.27           C  
ATOM    637  CD2 LEU A  73      53.013  53.443  65.879  1.00 22.73           C  
ATOM    638  N   GLY A  74      52.681  55.963  61.650  1.00 19.56           N  
ATOM    639  CA  GLY A  74      52.326  57.007  60.702  1.00 20.18           C  
ATOM    640  C   GLY A  74      51.673  58.184  61.364  1.00 17.58           C  
ATOM    641  O   GLY A  74      51.289  58.141  62.522  1.00 15.73           O  
ATOM    642  N   ASP A  75      51.472  59.241  60.587  1.00 18.06           N  
ATOM    643  CA  ASP A  75      50.854  60.441  61.099  1.00 20.11           C  
ATOM    644  C   ASP A  75      49.450  60.103  61.617  1.00 17.21           C  
ATOM    645  O   ASP A  75      48.988  60.693  62.589  1.00 20.51           O  
ATOM    646  CB  ASP A  75      50.809  61.552  60.015  1.00 22.90           C  
ATOM    647  CG  ASP A  75      52.195  62.153  59.680  1.00 28.73           C  
ATOM    648  OD1 ASP A  75      53.168  61.960  60.429  1.00 25.55           O  
ATOM    649  OD2 ASP A  75      52.294  62.827  58.626  1.00 39.90           O  
ATOM    650  N   GLU A  76      48.799  59.139  60.995  1.00 19.34           N  
ATOM    651  CA  GLU A  76      47.450  58.748  61.406  1.00 22.39           C  
ATOM    652  C   GLU A  76      47.466  58.066  62.782  1.00 24.35           C  
ATOM    653  O   GLU A  76      46.497  58.110  63.525  1.00 27.05           O  
ATOM    654  CB  GLU A  76      46.786  57.842  60.354  1.00 24.09           C  
ATOM    655  CG  GLU A  76      47.362  56.416  60.285  1.00 27.59           C  
ATOM    656  N   ASP A  77      48.568  57.417  63.122  1.00 21.61           N  
ATOM    657  CA  ASP A  77      48.712  56.806  64.470  1.00 18.45           C  
ATOM    658  C   ASP A  77      49.096  57.824  65.535  1.00 20.40           C  
ATOM    659  O   ASP A  77      48.725  57.729  66.719  1.00 25.10           O  
ATOM    660  CB  ASP A  77      49.816  55.748  64.435  1.00 19.05           C  
ATOM    661  CG  ASP A  77      49.566  54.662  63.429  1.00 24.36           C  
ATOM    662  OD1 ASP A  77      48.468  54.074  63.464  1.00 27.19           O  
ATOM    663  OD2 ASP A  77      50.462  54.372  62.626  1.00 24.97           O  
ATOM    664  N   ILE A  78      49.847  58.817  65.120  1.00 17.05           N  
ATOM    665  CA  ILE A  78      50.362  59.798  66.040  1.00 18.27           C  
ATOM    666  C   ILE A  78      49.316  60.824  66.410  1.00 22.71           C  
ATOM    667  O   ILE A  78      49.326  61.376  67.502  1.00 22.67           O  
ATOM    668  CB  ILE A  78      51.640  60.455  65.445  1.00 20.24           C  
ATOM    669  CG1 ILE A  78      52.798  59.410  65.435  1.00 21.33           C  
ATOM    670  CG2 ILE A  78      52.007  61.731  66.205  1.00 22.08           C  
ATOM    671  CD1 ILE A  78      53.917  59.690  64.515  1.00 23.00           C  
ATOM    672  N   ARG A  79      48.392  61.117  65.497  0.50 24.23           N  
ATOM    674  CA  ARG A  79      47.423  62.194  65.741  0.50 27.11           C  
ATOM    676  C   ARG A  79      46.400  61.844  66.803  0.50 27.32           C  
ATOM    678  O   ARG A  79      45.738  62.748  67.338  0.50 30.18           O  
ATOM    680  CB  ARG A  79      46.750  62.660  64.456  0.50 27.31           C  
ATOM    682  CG  ARG A  79      45.903  61.659  63.796  0.50 28.88           C  
ATOM    684  CD  ARG A  79      45.042  62.361  62.785  0.50 36.15           C  
ATOM    686  NE  ARG A  79      44.350  61.396  61.970  0.50 37.27           N  
ATOM    688  CZ  ARG A  79      44.730  61.063  60.749  0.50 32.28           C  
ATOM    690  NH1 ARG A  79      45.795  61.624  60.181  0.50 34.18           N  
ATOM    692  NH2 ARG A  79      44.049  60.160  60.104  0.50 20.69           N  
ATOM    694  N   ASN A  80      46.205  60.561  67.086  1.00 25.30           N  
ATOM    695  CA  ASN A  80      45.387  60.221  68.269  1.00 26.79           C  
ATOM    696  C   ASN A  80      46.219  59.313  69.175  1.00 21.47           C  
ATOM    697  O   ASN A  80      45.994  58.097  69.247  1.00 21.90           O  
ATOM    698  CB  ASN A  80      44.076  59.548  67.870  1.00 27.44           C  
ATOM    699  N   SER A  81      47.176  59.934  69.851  1.00 20.99           N  
ATOM    700  CA  SER A  81      48.213  59.148  70.535  1.00 18.56           C  
ATOM    701  C   SER A  81      47.701  58.384  71.718  1.00 19.09           C  
ATOM    702  O   SER A  81      48.329  57.410  72.161  1.00 21.85           O  
ATOM    703  CB  SER A  81      49.387  60.043  70.952  1.00 19.91           C  
ATOM    704  OG  SER A  81      48.989  61.058  71.889  1.00 21.59           O  
ATOM    705  N   TYR A  82      46.538  58.812  72.197  0.50 20.86           N  
ATOM    707  CA  TYR A  82      45.737  58.200  73.300  0.50 22.56           C  
ATOM    709  C   TYR A  82      45.705  56.715  72.978  0.50 20.16           C  
ATOM    711  O   TYR A  82      46.034  55.870  73.798  0.50 21.59           O  
ATOM    713  CB  TYR A  82      44.221  58.727  73.359  0.50 21.84           C  
ATOM    715  CG  TYR A  82      44.040  60.207  73.629  0.50 17.30           C  
ATOM    717  CD1 TYR A  82      43.947  61.092  72.621  0.50 19.29           C  
ATOM    719  CD2 TYR A  82      44.038  60.737  74.909  0.50 23.19           C  
ATOM    721  CE1 TYR A  82      43.807  62.445  72.869  0.50 16.63           C  
ATOM    723  CE2 TYR A  82      43.915  62.085  75.123  0.50 32.78           C  
ATOM    725  CZ  TYR A  82      43.829  62.937  74.118  0.50 22.25           C  
ATOM    727  OH  TYR A  82      43.761  64.288  74.293  0.50 26.24           O  
ATOM    729  N   LEU A  83      45.268  56.463  71.773  1.00 14.62           N  
ATOM    730  CA  LEU A  83      44.921  55.122  71.328  1.00 16.19           C  
ATOM    731  C   LEU A  83      46.152  54.258  71.251  1.00 16.77           C  
ATOM    732  O   LEU A  83      45.930  53.019  71.280  1.00 15.26           O  
ATOM    733  CB  LEU A  83      44.262  55.123  69.956  1.00 17.87           C  
ATOM    734  CG  LEU A  83      42.938  55.846  69.760  1.00 21.74           C  
ATOM    735  CD1 LEU A  83      42.530  55.804  68.276  1.00 23.41           C  
ATOM    736  CD2 LEU A  83      41.905  55.224  70.664  1.00 21.20           C  
ATOM    737  CA  LEU A  84      48.459  53.941  71.242  1.00 14.61           C  
ATOM    738  C   LEU A  84      48.868  53.273  72.521  1.00 11.72           C  
ATOM    739  O   LEU A  84      49.829  52.504  72.570  1.00 11.41           O  
ATOM    740  CB  LEU A  84      49.664  54.761  70.696  1.00 17.60           C  
ATOM    741  CG  LEU A  84      49.650  54.977  69.184  1.00 22.35           C  
ATOM    742  CD1 LEU A  84      50.690  56.038  68.871  1.00 20.97           C  
ATOM    743  CD2 LEU A  84      49.894  53.669  68.374  1.00 19.92           C  
ATOM    744  N   HIS A  85      48.134  53.519  73.618  1.00 10.07           N  
ATOM    745  CA  HIS A  85      48.493  52.848  74.873  1.00 11.10           C  
ATOM    746  C   HIS A  85      48.323  51.318  74.759  1.00  9.16           C  
ATOM    747  O   HIS A  85      48.934  50.605  75.551  1.00 10.76           O  
ATOM    748  CB  HIS A  85      47.781  53.406  76.130  1.00 11.50           C  
ATOM    749  CG  HIS A  85      46.327  53.071  76.235  1.00  9.93           C  
ATOM    750  ND1 HIS A  85      45.340  53.824  75.622  1.00 13.28           N  
ATOM    751  CD2 HIS A  85      45.690  52.117  76.951  1.00 10.89           C  
ATOM    752  CE1 HIS A  85      44.161  53.294  75.927  1.00 12.79           C  
ATOM    753  NE2 HIS A  85      44.343  52.268  76.753  1.00 11.46           N  
ATOM    754  N   GLY A  86      47.512  50.830  73.835  1.00 10.81           N  
ATOM    755  CA  GLY A  86      47.477  49.360  73.637  1.00 12.46           C  
ATOM    756  C   GLY A  86      48.848  48.816  73.199  1.00 12.09           C  
ATOM    757  O   GLY A  86      49.375  47.880  73.759  1.00 11.36           O  
ATOM    758  N   LEU A  87      49.413  49.406  72.152  1.00 10.05           N  
ATOM    759  CA  LEU A  87      50.725  48.929  71.612  1.00  9.18           C  
ATOM    760  C   LEU A  87      51.778  49.167  72.637  1.00 11.24           C  
ATOM    761  O   LEU A  87      52.611  48.308  72.862  1.00 10.97           O  
ATOM    762  CB  LEU A  87      51.032  49.649  70.304  1.00  9.84           C  
ATOM    763  CG  LEU A  87      52.395  49.313  69.688  1.00  9.26           C  
ATOM    764  CD1 LEU A  87      52.626  47.779  69.493  1.00 12.02           C  
ATOM    765  CD2 LEU A  87      52.584  50.030  68.356  1.00 11.78           C  
ATOM    766  N   ALA A  88      51.795  50.309  73.337  1.00  9.34           N  
ATOM    767  CA  ALA A  88      52.840  50.584  74.350  1.00  9.96           C  
ATOM    768  C   ALA A  88      52.681  49.551  75.473  1.00 10.89           C  
ATOM    769  O   ALA A  88      53.650  49.034  75.966  1.00 11.68           O  
ATOM    770  CB  ALA A  88      52.824  52.039  74.898  1.00 11.81           C  
ATOM    771  N   GLY A  89      51.436  49.219  75.806  1.00 11.01           N  
ATOM    772  CA  GLY A  89      51.172  48.209  76.829  1.00 10.47           C  
ATOM    773  C   GLY A  89      51.652  46.834  76.429  1.00 10.73           C  
ATOM    774  O   GLY A  89      52.158  46.093  77.268  1.00 11.81           O  
ATOM    775  N   ARG A  90      51.492  46.495  75.155  1.00  9.24           N  
ATOM    776  CA  ARG A  90      52.049  45.227  74.655  1.00  9.28           C  
ATOM    777  C   ARG A  90      53.543  45.206  74.856  1.00 10.98           C  
ATOM    778  O   ARG A  90      54.135  44.205  75.335  1.00 11.46           O  
ATOM    779  CB  ARG A  90      51.707  45.044  73.199  1.00 12.55           C  
ATOM    780  CG  ARG A  90      52.408  43.906  72.503  1.00 18.95           C  
ATOM    781  CD  ARG A  90      52.339  43.915  70.961  1.00 15.08           C  
ATOM    782  NE  ARG A  90      53.110  42.781  70.502  1.00 18.15           N  
ATOM    783  CZ  ARG A  90      52.616  41.684  69.976  1.00 25.87           C  
ATOM    784  NH1 ARG A  90      51.336  41.591  69.719  1.00 26.28           N  
ATOM    785  NH2 ARG A  90      53.454  40.711  69.630  1.00 36.66           N  
ATOM    786  N   ILE A  91      54.188  46.314  74.533  1.00 10.50           N  
ATOM    787  CA  ILE A  91      55.646  46.413  74.668  1.00 12.08           C  
ATOM    788  C   ILE A  91      56.088  46.294  76.116  1.00 12.36           C  
ATOM    789  O   ILE A  91      57.068  45.584  76.449  1.00 13.11           O  
ATOM    790  CB  ILE A  91      56.156  47.707  74.020  1.00 10.39           C  
ATOM    791  CG1 ILE A  91      55.991  47.618  72.535  1.00 12.93           C  
ATOM    792  CG2 ILE A  91      57.639  47.937  74.352  1.00 13.59           C  
ATOM    793  CD1 ILE A  91      56.230  49.016  71.817  1.00 14.29           C  
ATOM    794  N   LEU A  92      55.402  46.980  77.019  1.00 13.29           N  
ATOM    795  CA  LEU A  92      55.757  46.877  78.426  1.00 11.69           C  
ATOM    796  C   LEU A  92      55.489  45.439  78.927  1.00 13.70           C  
ATOM    797  O   LEU A  92      56.255  44.859  79.690  1.00 13.98           O  
ATOM    798  CB  LEU A  92      54.986  47.868  79.310  1.00 13.24           C  
ATOM    799  CG  LEU A  92      55.239  49.333  79.020  1.00 15.22           C  
ATOM    800  CD1 LEU A  92      54.409  50.190  79.958  1.00 18.06           C  
ATOM    801  CD2 LEU A  92      56.705  49.669  79.126  1.00 20.81           C  
ATOM    802  N   ALA A  93      54.358  44.868  78.552  1.00 11.85           N  
ATOM    803  CA  ALA A  93      54.003  43.504  78.990  1.00 12.31           C  
ATOM    804  C   ALA A  93      55.119  42.520  78.567  1.00 14.83           C  
ATOM    805  O   ALA A  93      55.522  41.652  79.341  1.00 14.46           O  
ATOM    806  CB  ALA A  93      52.690  43.114  78.372  1.00 13.03           C  
ATOM    807  N   LYS A  94      55.595  42.652  77.348  1.00 13.22           N  
ATOM    808  CA  LYS A  94      56.688  41.768  76.844  1.00 13.13           C  
ATOM    809  C   LYS A  94      58.032  42.067  77.458  1.00 17.30           C  
ATOM    810  O   LYS A  94      58.664  41.161  78.005  1.00 17.48           O  
ATOM    811  CB  LYS A  94      56.779  41.910  75.323  1.00 14.46           C  
ATOM    812  CG  LYS A  94      57.947  41.217  74.589  1.00 18.46           C  
ATOM    813  CD  LYS A  94      57.696  39.802  74.292  1.00 21.90           C  
ATOM    814  CE  LYS A  94      58.984  39.163  73.703  1.00 27.55           C  
ATOM    815  NZ  LYS A  94      58.720  37.766  73.407  1.00 24.71           N  
ATOM    816  N   LYS A  95      58.450  43.335  77.431  1.00 15.64           N  
ATOM    817  CA  LYS A  95      59.818  43.663  77.782  1.00 16.49           C  
ATOM    818  C   LYS A  95      60.070  43.931  79.229  1.00 19.77           C  
ATOM    819  O   LYS A  95      61.206  43.778  79.703  1.00 22.86           O  
ATOM    820  CB  LYS A  95      60.312  44.892  77.003  1.00 17.88           C  
ATOM    821  CG  LYS A  95      60.301  44.764  75.547  1.00 19.71           C  
ATOM    822  CD  LYS A  95      61.242  43.715  75.037  1.00 35.31           C  
ATOM    823  CE  LYS A  95      61.223  43.705  73.538  1.00 43.60           C  
ATOM    824  NZ  LYS A  95      62.347  42.906  72.999  1.00 46.86           N  
ATOM    825  N   VAL A  96      59.051  44.356  79.945  1.00 15.68           N  
ATOM    826  CA  VAL A  96      59.187  44.685  81.353  1.00 17.37           C  
ATOM    827  C   VAL A  96      58.612  43.563  82.233  1.00 19.11           C  
ATOM    828  O   VAL A  96      59.299  43.020  83.117  1.00 21.60           O  
ATOM    829  CB  VAL A  96      58.524  46.030  81.694  1.00 17.65           C  
ATOM    830  CG1 VAL A  96      58.466  46.268  83.196  1.00 21.70           C  
ATOM    831  CG2 VAL A  96      59.291  47.131  80.980  1.00 20.23           C  
ATOM    832  N   ILE A  97      57.383  43.149  81.942  1.00 17.40           N  
ATOM    833  CA  ILE A  97      56.696  42.141  82.767  1.00 15.42           C  
ATOM    834  C   ILE A  97      57.127  40.714  82.396  1.00 14.98           C  
ATOM    835  O   ILE A  97      57.033  39.821  83.249  1.00 18.42           O  
ATOM    836  CB  ILE A  97      55.162  42.328  82.719  1.00 14.69           C  
ATOM    837  CG1 ILE A  97      54.785  43.748  83.169  1.00 14.50           C  
ATOM    838  CG2 ILE A  97      54.472  41.263  83.580  1.00 16.77           C  
ATOM    839  CD1 ILE A  97      53.279  44.092  83.004  1.00 16.12           C  
ATOM    840  N   GLY A  98      57.614  40.525  81.186  1.00 14.10           N  
ATOM    841  CA  GLY A  98      58.043  39.212  80.729  1.00 13.73           C  
ATOM    842  C   GLY A  98      56.987  38.280  80.204  1.00 15.85           C  
ATOM    843  O   GLY A  98      57.158  37.047  80.265  1.00 16.72           O  
ATOM    844  N   ILE A  99      55.875  38.820  79.720  1.00 14.97           N  
ATOM    845  CA  ILE A  99      54.806  38.063  79.115  1.00 13.52           C  
ATOM    846  C   ILE A  99      55.133  37.771  77.660  1.00 15.70           C  
ATOM    847  O   ILE A  99      55.334  38.665  76.857  1.00 14.91           O  
ATOM    848  CB  ILE A  99      53.432  38.819  79.182  1.00 14.33           C  
ATOM    849  CG1 ILE A  99      53.041  38.960  80.643  1.00 15.55           C  
ATOM    850  CG2 ILE A  99      52.390  38.118  78.337  1.00 13.33           C  
ATOM    851  CD1 ILE A  99      51.964  40.053  80.929  1.00 15.08           C  
ATOM    852  N   ASP A 100      55.217  36.488  77.286  1.00 16.35           N  
ATOM    853  CA  ASP A 100      55.540  36.104  75.921  1.00 18.65           C  
ATOM    854  C   ASP A 100      54.407  35.560  75.067  1.00 16.59           C  
ATOM    855  O   ASP A 100      54.573  35.456  73.833  1.00 19.98           O  
ATOM    856  CB  ASP A 100      56.634  35.021  75.955  1.00 20.33           C  
ATOM    857  CG  ASP A 100      57.916  35.545  76.454  1.00 28.61           C  
ATOM    858  OD1 ASP A 100      58.243  36.716  76.126  1.00 30.05           O  
ATOM    859  OD2 ASP A 100      58.605  34.766  77.167  1.00 29.54           O  
ATOM    860  N   ASP A 101      53.280  35.217  75.701  1.00 16.03           N  
ATOM    861  CA  ASP A 101      52.186  34.613  74.982  1.00 14.24           C  
ATOM    862  C   ASP A 101      51.669  35.547  73.900  1.00 14.55           C  
ATOM    863  O   ASP A 101      51.226  36.662  74.167  1.00 14.35           O  
ATOM    864  CB  ASP A 101      51.048  34.181  75.880  1.00 14.09           C  
ATOM    865  CG  ASP A 101      49.990  33.480  75.133  1.00 19.41           C  
ATOM    866  OD1 ASP A 101      49.110  34.100  74.524  1.00 15.89           O  
ATOM    867  OD2 ASP A 101      50.015  32.242  75.189  1.00 23.50           O  
ATOM    868  N   GLU A 102      51.728  35.065  72.662  0.70 15.92           N  
ATOM    870  CA  GLU A 102      51.385  35.912  71.511  0.70 16.50           C  
ATOM    872  C   GLU A 102      49.949  36.421  71.537  0.70 14.17           C  
ATOM    874  O   GLU A 102      49.680  37.591  71.174  0.70 14.98           O  
ATOM    876  CB  GLU A 102      51.656  35.185  70.186  0.70 17.29           C  
ATOM    878  CG  GLU A 102      51.195  35.969  68.990  0.70 25.06           C  
ATOM    880  N   ASP A 103      49.026  35.561  71.951  1.00 13.31           N  
ATOM    881  CA  ASP A 103      47.598  35.896  71.987  1.00 12.17           C  
ATOM    882  C   ASP A 103      47.375  36.980  73.053  1.00 13.04           C  
ATOM    883  O   ASP A 103      46.691  37.960  72.801  1.00 12.30           O  
ATOM    884  CB  ASP A 103      46.784  34.641  72.307  1.00 12.53           C  
ATOM    885  CG  ASP A 103      45.338  34.748  71.972  1.00 15.84           C  
ATOM    886  OD1 ASP A 103      44.884  35.677  71.240  1.00 15.01           O  
ATOM    887  OD2 ASP A 103      44.591  33.849  72.426  1.00 16.68           O  
ATOM    888  N   VAL A 104      47.938  36.795  74.239  1.00 12.03           N  
ATOM    889  CA  VAL A 104      47.845  37.831  75.301  1.00 11.19           C  
ATOM    890  C   VAL A 104      48.387  39.136  74.788  1.00 12.28           C  
ATOM    891  O   VAL A 104      47.750  40.180  74.967  1.00  9.93           O  
ATOM    892  CB  VAL A 104      48.584  37.406  76.546  1.00  9.31           C  
ATOM    893  CG1 VAL A 104      48.765  38.532  77.589  1.00 10.66           C  
ATOM    894  CG2 VAL A 104      47.884  36.196  77.188  1.00 14.01           C  
ATOM    895  N   LEU A 105      49.547  39.123  74.163  1.00 10.92           N  
ATOM    896  CA  LEU A 105      50.126  40.380  73.690  1.00 11.34           C  
ATOM    897  C   LEU A 105      49.197  41.041  72.644  1.00 10.13           C  
ATOM    898  O   LEU A 105      49.019  42.271  72.665  1.00 10.60           O  
ATOM    899  CB  LEU A 105      51.532  40.133  73.139  1.00 11.51           C  
ATOM    900  CG  LEU A 105      52.537  39.677  74.172  1.00 11.80           C  
ATOM    901  CD1 LEU A 105      53.862  39.312  73.437  1.00 14.64           C  
ATOM    902  CD2 LEU A 105      52.755  40.716  75.275  1.00 13.38           C  
ATOM    903  N   ASN A 106      48.650  40.264  71.709  1.00 11.28           N  
ATOM    904  CA  ASN A 106      47.714  40.830  70.742  1.00 10.61           C  
ATOM    905  C   ASN A 106      46.468  41.445  71.436  1.00 10.00           C  
ATOM    906  O   ASN A 106      45.966  42.519  71.051  1.00 10.63           O  
ATOM    907  CB  ASN A 106      47.216  39.793  69.721  1.00 12.16           C  
ATOM    908  CG  ASN A 106      48.275  39.440  68.703  1.00 12.78           C  
ATOM    909  OD1 ASN A 106      49.175  40.233  68.430  1.00 15.74           O  
ATOM    910  ND2 ASN A 106      48.185  38.217  68.148  1.00 13.70           N  
ATOM    911  N   ALA A 107      45.927  40.740  72.425  1.00 10.11           N  
ATOM    912  CA  ALA A 107      44.740  41.201  73.120  1.00 10.96           C  
ATOM    913  C   ALA A 107      45.015  42.570  73.778  1.00 11.60           C  
ATOM    914  O   ALA A 107      44.166  43.437  73.792  1.00 12.22           O  
ATOM    915  CB  ALA A 107      44.315  40.176  74.140  1.00 11.78           C  
ATOM    916  N   ILE A 108      46.205  42.743  74.350  1.00 10.91           N  
ATOM    917  CA  ILE A 108      46.584  44.017  74.943  1.00  9.87           C  
ATOM    918  C   ILE A 108      46.753  45.066  73.820  1.00 10.24           C  
ATOM    919  O   ILE A 108      46.183  46.150  73.871  1.00 10.65           O  
ATOM    920  CB  ILE A 108      47.894  43.884  75.708  1.00  9.63           C  
ATOM    921  CG1 ILE A 108      47.789  42.864  76.849  1.00  9.52           C  
ATOM    922  CG2 ILE A 108      48.345  45.206  76.236  1.00  9.46           C  
ATOM    923  CD1 ILE A 108      49.176  42.490  77.458  1.00 11.90           C  
ATOM    924  N   GLU A 109      47.508  44.716  72.790  1.00  9.69           N  
ATOM    925  CA  GLU A 109      47.777  45.654  71.712  1.00 11.67           C  
ATOM    926  C   GLU A 109      46.508  46.245  71.088  1.00 10.87           C  
ATOM    927  O   GLU A 109      46.480  47.446  70.792  1.00 13.36           O  
ATOM    928  CB  GLU A 109      48.572  45.010  70.599  1.00 13.83           C  
ATOM    929  CG  GLU A 109      48.856  45.896  69.417  1.00 14.91           C  
ATOM    930  CD  GLU A 109      49.848  45.290  68.430  1.00 15.13           C  
ATOM    931  OE1 GLU A 109      50.243  44.134  68.558  1.00 18.59           O  
ATOM    932  OE2 GLU A 109      50.133  45.996  67.445  1.00 19.50           O  
ATOM    933  N   PHE A 110      45.527  45.409  70.818  1.00 10.63           N  
ATOM    934  CA  PHE A 110      44.358  45.839  70.034  1.00 11.75           C  
ATOM    935  C   PHE A 110      43.123  46.121  70.838  1.00 12.17           C  
ATOM    936  O   PHE A 110      42.010  46.333  70.304  1.00 12.81           O  
ATOM    937  CB  PHE A 110      44.061  44.825  68.904  1.00 13.55           C  
ATOM    938  CG  PHE A 110      45.169  44.734  67.902  1.00 12.18           C  
ATOM    939  CD1 PHE A 110      45.396  45.760  67.027  1.00 14.78           C  
ATOM    940  CD2 PHE A 110      46.064  43.670  67.897  1.00 12.06           C  
ATOM    941  CE1 PHE A 110      46.414  45.682  66.119  1.00 13.16           C  
ATOM    942  CE2 PHE A 110      47.092  43.597  66.985  1.00 15.14           C  
ATOM    943  CZ  PHE A 110      47.274  44.620  66.124  1.00 16.76           C  
ATOM    944  N   HIS A 111      43.304  46.254  72.143  1.00 10.95           N  
ATOM    945  CA  HIS A 111      42.121  46.483  72.947  1.00  9.53           C  
ATOM    946  C   HIS A 111      41.505  47.859  72.787  1.00 11.21           C  
ATOM    947  O   HIS A 111      40.357  48.029  73.188  1.00 14.30           O  
ATOM    948  CB  HIS A 111      42.400  46.260  74.468  1.00 10.46           C  
ATOM    949  CG  HIS A 111      43.006  47.427  75.195  1.00  9.77           C  
ATOM    950  ND1 HIS A 111      44.358  47.646  75.352  1.00 11.49           N  
ATOM    951  CD2 HIS A 111      42.386  48.428  75.861  1.00  8.88           C  
ATOM    952  CE1 HIS A 111      44.532  48.768  76.051  1.00 10.48           C  
ATOM    953  NE2 HIS A 111      43.345  49.241  76.403  1.00 10.23           N  
ATOM    954  N   THR A 112      42.255  48.824  72.284  1.00 11.60           N  
ATOM    955  CA  THR A 112      41.757  50.232  72.200  1.00 13.63           C  
ATOM    956  C   THR A 112      40.931  50.471  70.946  1.00 17.10           C  
ATOM    957  O   THR A 112      40.051  51.336  70.966  1.00 21.98           O  
ATOM    958  CB  THR A 112      42.854  51.284  72.295  1.00 16.19           C  
ATOM    959  OG1 THR A 112      43.702  51.230  71.113  1.00 15.75           O  
ATOM    960  CG2 THR A 112      43.669  51.091  73.525  1.00 17.50           C  
ATOM    961  N   THR A 113      41.220  49.723  69.887  1.00 11.39           N  
ATOM    962  CA  THR A 113      40.553  49.885  68.603  1.00 12.45           C  
ATOM    963  C   THR A 113      39.888  48.665  67.997  1.00 15.41           C  
ATOM    964  O   THR A 113      39.004  48.774  67.132  1.00 16.83           O  
ATOM    965  CB  THR A 113      41.598  50.330  67.500  1.00 13.07           C  
ATOM    966  OG1 THR A 113      42.623  49.348  67.382  1.00 13.68           O  
ATOM    967  CG2 THR A 113      42.259  51.673  67.839  1.00 17.13           C  
ATOM    968  N   GLY A 114      40.318  47.492  68.388  1.00 14.65           N  
ATOM    969  CA  GLY A 114      39.942  46.293  67.704  1.00 11.99           C  
ATOM    970  C   GLY A 114      40.737  46.209  66.388  1.00 14.07           C  
ATOM    971  O   GLY A 114      41.597  47.060  66.075  1.00 13.70           O  
ATOM    972  N   ARG A 115      40.503  45.150  65.635  1.00 13.24           N  
ATOM    973  CA  ARG A 115      41.128  44.984  64.326  1.00 12.86           C  
ATOM    974  C   ARG A 115      40.401  43.906  63.591  1.00 15.21           C  
ATOM    975  O   ARG A 115      39.570  43.201  64.161  1.00 13.82           O  
ATOM    976  CB  ARG A 115      42.610  44.611  64.482  1.00 13.34           C  
ATOM    977  CG  ARG A 115      42.858  43.207  65.155  1.00 12.46           C  
ATOM    978  CD  ARG A 115      44.254  42.721  64.913  1.00 13.65           C  
ATOM    979  NE  ARG A 115      44.545  41.501  65.646  1.00 14.89           N  
ATOM    980  CZ  ARG A 115      45.649  40.792  65.473  1.00 14.68           C  
ATOM    981  NH1 ARG A 115      46.539  41.119  64.557  1.00 17.32           N  
ATOM    982  NH2 ARG A 115      45.874  39.702  66.199  1.00 17.95           N  
ATOM    983  N   PRO A 116      40.698  43.749  62.300  1.00 15.47           N  
ATOM    984  CA  PRO A 116      40.104  42.587  61.665  1.00 14.69           C  
ATOM    985  C   PRO A 116      40.663  41.283  62.179  1.00 15.10           C  
ATOM    986  O   PRO A 116      41.777  41.220  62.633  1.00 16.51           O  
ATOM    987  CB  PRO A 116      40.520  42.735  60.189  1.00 17.99           C  
ATOM    988  CG  PRO A 116      41.042  44.068  60.042  1.00 18.99           C  
ATOM    989  CD  PRO A 116      41.454  44.602  61.374  1.00 17.14           C  
ATOM    990  N   ASN A 117      39.829  40.264  62.134  1.00 16.17           N  
ATOM    991  CA  ASN A 117      40.202  38.904  62.485  1.00 18.00           C  
ATOM    992  C   ASN A 117      40.863  38.747  63.863  1.00 17.58           C  
ATOM    993  O   ASN A 117      41.988  38.296  63.988  1.00 19.73           O  
ATOM    994  CB  ASN A 117      41.122  38.313  61.407  1.00 19.20           C  
ATOM    995  CG  ASN A 117      41.307  36.788  61.553  1.00 24.26           C  
ATOM    996  OD1 ASN A 117      40.455  36.080  62.103  1.00 23.86           O  
ATOM    997  ND2 ASN A 117      42.425  36.295  61.053  1.00 29.77           N  
HETATM  998  N   MSE A 118      40.101  39.169  64.852  1.00 16.14           N  
HETATM  999  CA  MSE A 118      40.483  39.070  66.262  1.00 15.53           C  
HETATM 1000  C   MSE A 118      40.313  37.629  66.762  1.00 13.86           C  
HETATM 1001  O   MSE A 118      39.395  36.918  66.423  1.00 16.75           O  
HETATM 1002  CB  MSE A 118      39.600  40.012  67.115  1.00 13.37           C  
HETATM 1003  CG  MSE A 118      39.822  41.519  66.827  1.00 13.02           C  
HETATM 1004 SE   MSE A 118      38.559  42.690  67.416  0.75 14.07          SE  
HETATM 1005  CE  MSE A 118      38.953  42.823  69.272  1.00 15.38           C  
ATOM   1006  N   SER A 119      41.232  37.242  67.630  1.00 13.43           N  
ATOM   1007  CA  SER A 119      41.062  35.997  68.335  1.00 12.27           C  
ATOM   1008  C   SER A 119      39.947  36.160  69.367  1.00 13.74           C  
ATOM   1009  O   SER A 119      39.559  37.263  69.769  1.00 13.39           O  
ATOM   1010  CB  SER A 119      42.372  35.605  69.027  1.00 14.51           C  
ATOM   1011  OG  SER A 119      42.563  36.399  70.200  1.00 12.97           O  
ATOM   1012  N   LEU A 120      39.483  35.020  69.869  1.00 14.77           N  
ATOM   1013  CA  LEU A 120      38.515  35.006  70.913  1.00 13.60           C  
ATOM   1014  C   LEU A 120      39.043  35.820  72.120  1.00 11.17           C  
ATOM   1015  O   LEU A 120      38.286  36.618  72.686  1.00 13.45           O  
ATOM   1016  CB  LEU A 120      38.203  33.556  71.295  1.00 14.93           C  
ATOM   1017  CG  LEU A 120      37.280  33.419  72.489  1.00 14.54           C  
ATOM   1018  CD1 LEU A 120      35.941  34.160  72.345  1.00 14.41           C  
ATOM   1019  CD2 LEU A 120      37.091  31.923  72.812  1.00 17.37           C  
ATOM   1020  N   LEU A 121      40.324  35.649  72.481  1.00 13.63           N  
ATOM   1021  CA  LEU A 121      40.894  36.389  73.639  1.00 12.98           C  
ATOM   1022  C   LEU A 121      40.885  37.901  73.351  1.00 11.53           C  
ATOM   1023  O   LEU A 121      40.510  38.687  74.204  1.00 11.60           O  
ATOM   1024  CB  LEU A 121      42.278  35.907  73.980  1.00 13.92           C  
ATOM   1025  CG  LEU A 121      42.964  36.612  75.168  1.00 11.86           C  
ATOM   1026  CD1 LEU A 121      42.157  36.266  76.475  1.00 12.32           C  
ATOM   1027  CD2 LEU A 121      44.447  36.215  75.211  1.00 13.94           C  
ATOM   1028  N   GLU A 122      41.282  38.282  72.142  1.00 12.49           N  
ATOM   1029  CA  GLU A 122      41.273  39.697  71.783  1.00 11.88           C  
ATOM   1030  C   GLU A 122      39.873  40.299  71.938  1.00 10.19           C  
ATOM   1031  O   GLU A 122      39.701  41.396  72.470  1.00 11.44           O  
ATOM   1032  CB  GLU A 122      41.724  39.884  70.342  1.00 10.99           C  
ATOM   1033  CG  GLU A 122      43.161  39.698  70.064  1.00 12.02           C  
ATOM   1034  CD  GLU A 122      43.484  39.778  68.589  1.00 13.15           C  
ATOM   1035  OE1 GLU A 122      43.319  40.900  68.045  1.00 15.89           O  
ATOM   1036  OE2 GLU A 122      43.846  38.750  67.970  1.00 14.74           O  
ATOM   1037  N   LYS A 123      38.839  39.556  71.492  1.00 10.67           N  
ATOM   1038  CA  LYS A 123      37.483  40.017  71.592  1.00 11.87           C  
ATOM   1039  C   LYS A 123      37.032  40.204  73.070  1.00  9.29           C  
ATOM   1040  O   LYS A 123      36.369  41.146  73.435  1.00 12.70           O  
ATOM   1041  CB  LYS A 123      36.505  39.114  70.863  1.00 11.80           C  
ATOM   1042  CG  LYS A 123      36.803  38.969  69.388  1.00 14.97           C  
ATOM   1043  CD  LYS A 123      35.797  38.054  68.706  1.00 16.46           C  
ATOM   1044  CE  LYS A 123      36.078  37.968  67.211  1.00 19.58           C  
ATOM   1045  NZ  LYS A 123      35.194  36.943  66.537  1.00 18.10           N  
ATOM   1046  N   ILE A 124      37.355  39.175  73.874  1.00 11.11           N  
ATOM   1047  CA  ILE A 124      37.019  39.179  75.298  1.00 12.00           C  
ATOM   1048  C   ILE A 124      37.637  40.416  76.013  1.00 10.76           C  
ATOM   1049  O   ILE A 124      36.962  41.116  76.798  1.00 12.82           O  
ATOM   1050  CB  ILE A 124      37.471  37.859  75.943  1.00 12.82           C  
ATOM   1051  CG1 ILE A 124      36.554  36.722  75.479  1.00 13.10           C  
ATOM   1052  CG2 ILE A 124      37.427  37.996  77.446  1.00 13.51           C  
ATOM   1053  CD1 ILE A 124      36.935  35.308  75.991  1.00 15.22           C  
ATOM   1054  N   ILE A 125      38.915  40.718  75.699  1.00 11.51           N  
ATOM   1055  CA  ILE A 125      39.613  41.813  76.399  1.00 11.45           C  
ATOM   1056  C   ILE A 125      39.023  43.148  75.925  1.00 11.41           C  
ATOM   1057  O   ILE A 125      38.697  44.042  76.721  1.00 11.37           O  
ATOM   1058  CB  ILE A 125      41.136  41.744  76.240  1.00 12.29           C  
ATOM   1059  CG1 ILE A 125      41.656  40.420  76.859  1.00 12.64           C  
ATOM   1060  CG2 ILE A 125      41.789  42.969  76.852  1.00 12.98           C  
ATOM   1061  CD1 ILE A 125      41.166  40.104  78.289  1.00 11.50           C  
ATOM   1062  N   TYR A 126      38.811  43.249  74.627  1.00 11.93           N  
ATOM   1063  CA  TYR A 126      38.212  44.453  74.071  1.00 12.03           C  
ATOM   1064  C   TYR A 126      36.841  44.775  74.720  1.00 11.24           C  
ATOM   1065  O   TYR A 126      36.586  45.893  75.181  1.00 12.42           O  
ATOM   1066  CB  TYR A 126      38.105  44.341  72.532  1.00 12.04           C  
ATOM   1067  CG  TYR A 126      37.343  45.496  71.905  1.00 13.83           C  
ATOM   1068  CD1 TYR A 126      35.973  45.477  71.922  1.00 14.70           C  
ATOM   1069  CD2 TYR A 126      37.985  46.629  71.424  1.00 12.49           C  
ATOM   1070  CE1 TYR A 126      35.238  46.498  71.428  1.00 17.95           C  
ATOM   1071  CE2 TYR A 126      37.244  47.695  70.929  1.00 17.27           C  
ATOM   1072  CZ  TYR A 126      35.866  47.622  70.971  1.00 18.41           C  
ATOM   1073  OH  TYR A 126      35.027  48.617  70.455  1.00 21.08           O  
ATOM   1074  N   ILE A 127      35.970  43.776  74.775  1.00 11.32           N  
ATOM   1075  CA  ILE A 127      34.631  44.045  75.298  1.00 13.30           C  
ATOM   1076  C   ILE A 127      34.602  44.171  76.820  1.00 13.12           C  
ATOM   1077  O   ILE A 127      33.822  44.948  77.380  1.00 13.43           O  
ATOM   1078  CB  ILE A 127      33.620  42.994  74.771  1.00 12.83           C  
ATOM   1079  CG1 ILE A 127      32.218  43.621  74.717  1.00 18.41           C  
ATOM   1080  CG2 ILE A 127      33.684  41.717  75.556  1.00 17.39           C  
ATOM   1081  CD1 ILE A 127      32.049  44.675  73.572  1.00 16.95           C  
ATOM   1082  N   ALA A 128      35.505  43.448  77.475  1.00 14.26           N  
ATOM   1083  CA  ALA A 128      35.575  43.503  78.946  1.00 11.96           C  
ATOM   1084  C   ALA A 128      35.819  44.896  79.432  1.00 12.68           C  
ATOM   1085  O   ALA A 128      35.245  45.313  80.448  1.00 14.11           O  
ATOM   1086  CB  ALA A 128      36.673  42.555  79.490  1.00 12.54           C  
ATOM   1087  N   ASP A 129      36.594  45.663  78.665  1.00 14.25           N  
ATOM   1088  CA  ASP A 129      36.858  47.033  79.047  1.00 16.26           C  
ATOM   1089  C   ASP A 129      35.556  47.884  79.160  1.00 17.13           C  
ATOM   1090  O   ASP A 129      35.407  48.707  80.058  1.00 20.31           O  
ATOM   1091  CB  ASP A 129      37.823  47.634  78.028  1.00 19.20           C  
ATOM   1092  CG  ASP A 129      38.405  48.933  78.496  1.00 28.58           C  
ATOM   1093  OD1 ASP A 129      38.762  49.016  79.666  1.00 28.76           O  
ATOM   1094  OD2 ASP A 129      38.562  49.839  77.664  1.00 32.93           O  
ATOM   1095  N   TYR A 130      34.626  47.630  78.249  1.00 15.33           N  
ATOM   1096  CA  TYR A 130      33.317  48.302  78.188  1.00 18.24           C  
ATOM   1097  C   TYR A 130      32.281  47.825  79.199  1.00 19.60           C  
ATOM   1098  O   TYR A 130      31.447  48.586  79.640  1.00 22.22           O  
ATOM   1099  CB  TYR A 130      32.716  48.148  76.772  1.00 19.35           C  
ATOM   1100  CG  TYR A 130      33.407  48.999  75.749  1.00 21.48           C  
ATOM   1101  CD1 TYR A 130      34.547  48.554  75.078  1.00 20.62           C  
ATOM   1102  CD2 TYR A 130      32.954  50.274  75.482  1.00 27.31           C  
ATOM   1103  CE1 TYR A 130      35.200  49.371  74.160  1.00 31.34           C  
ATOM   1104  CE2 TYR A 130      33.608  51.090  74.590  1.00 27.92           C  
ATOM   1105  CZ  TYR A 130      34.721  50.634  73.921  1.00 33.44           C  
ATOM   1106  OH  TYR A 130      35.351  51.483  73.018  1.00 31.99           O  
ATOM   1107  N   ILE A 131      32.315  46.550  79.544  1.00 15.45           N  
ATOM   1108  CA  ILE A 131      31.243  45.996  80.359  1.00 18.40           C  
ATOM   1109  C   ILE A 131      31.615  45.613  81.813  1.00 18.37           C  
ATOM   1110  O   ILE A 131      30.769  45.059  82.538  1.00 18.73           O  
ATOM   1111  CB  ILE A 131      30.628  44.757  79.633  1.00 18.45           C  
ATOM   1112  CG1 ILE A 131      31.614  43.597  79.538  1.00 17.70           C  
ATOM   1113  CG2 ILE A 131      30.074  45.144  78.224  1.00 17.75           C  
ATOM   1114  CD1 ILE A 131      31.043  42.263  79.166  1.00 18.70           C  
ATOM   1115  N   GLU A 132      32.863  45.879  82.225  1.00 18.35           N  
ATOM   1116  CA  GLU A 132      33.323  45.563  83.580  1.00 19.98           C  
ATOM   1117  C   GLU A 132      32.398  46.293  84.541  1.00 19.45           C  
ATOM   1118  O   GLU A 132      31.870  47.364  84.219  1.00 19.67           O  
ATOM   1119  CB  GLU A 132      34.822  45.836  83.798  1.00 18.31           C  
ATOM   1120  CG  GLU A 132      35.239  47.261  83.616  1.00 18.21           C  
ATOM   1121  CD  GLU A 132      35.319  48.021  84.925  1.00 24.32           C  
ATOM   1122  OE1 GLU A 132      34.918  47.431  85.975  1.00 21.31           O  
ATOM   1123  OE2 GLU A 132      35.795  49.200  84.887  1.00 25.15           O  
ATOM   1124  N   PRO A 133      32.170  45.686  85.700  1.00 20.97           N  
ATOM   1125  CA  PRO A 133      31.113  46.113  86.635  1.00 23.51           C  
ATOM   1126  C   PRO A 133      31.189  47.544  87.084  1.00 24.24           C  
ATOM   1127  O   PRO A 133      30.165  48.114  87.451  1.00 28.30           O  
ATOM   1128  CB  PRO A 133      31.310  45.180  87.834  1.00 24.09           C  
ATOM   1129  CG  PRO A 133      32.064  44.039  87.327  1.00 25.07           C  
ATOM   1130  CD  PRO A 133      32.853  44.464  86.145  1.00 19.85           C  
ATOM   1131  N   GLY A 134      32.381  48.094  87.080  1.00 24.59           N  
ATOM   1132  CA  GLY A 134      32.603  49.459  87.499  1.00 27.38           C  
ATOM   1133  C   GLY A 134      32.165  50.466  86.462  1.00 28.66           C  
ATOM   1134  O   GLY A 134      32.193  51.656  86.719  1.00 31.57           O  
ATOM   1135  N   ARG A 135      31.745  49.997  85.293  1.00 25.62           N  
ATOM   1136  CA  ARG A 135      31.276  50.927  84.262  1.00 26.23           C  
ATOM   1137  C   ARG A 135      29.767  51.167  84.312  1.00 27.12           C  
ATOM   1138  O   ARG A 135      28.971  50.301  84.646  1.00 28.87           O  
ATOM   1139  CB  ARG A 135      31.685  50.499  82.877  1.00 25.45           C  
ATOM   1140  CG  ARG A 135      33.160  50.743  82.696  1.00 28.82           C  
ATOM   1141  CD  ARG A 135      33.490  51.032  81.282  1.00 28.19           C  
ATOM   1142  NE  ARG A 135      34.907  51.285  81.091  1.00 28.57           N  
ATOM   1143  CZ  ARG A 135      35.451  52.494  81.142  1.00 33.17           C  
ATOM   1144  NH1 ARG A 135      34.675  53.559  81.400  1.00 30.04           N  
ATOM   1145  NH2 ARG A 135      36.746  52.647  80.919  1.00 26.10           N  
ATOM   1146  N   GLU A 136      29.430  52.383  83.918  1.00 24.13           N  
ATOM   1147  CA  GLU A 136      28.083  52.899  83.963  1.00 24.71           C  
ATOM   1148  C   GLU A 136      27.907  53.970  82.884  1.00 22.71           C  
ATOM   1149  O   GLU A 136      28.510  55.018  82.954  1.00 27.33           O  
ATOM   1150  CB  GLU A 136      27.872  53.493  85.369  1.00 27.56           C  
ATOM   1151  CG  GLU A 136      26.684  54.435  85.547  1.00 28.42           C  
ATOM   1152  CD  GLU A 136      25.350  53.804  85.216  1.00 33.21           C  
ATOM   1153  OE1 GLU A 136      25.217  52.554  85.275  1.00 27.39           O  
ATOM   1154  OE2 GLU A 136      24.435  54.591  84.898  1.00 34.33           O  
ATOM   1155  N   PHE A 137      27.128  53.627  81.865  1.00 25.02           N  
ATOM   1156  CA  PHE A 137      26.817  54.548  80.756  1.00 23.09           C  
ATOM   1157  C   PHE A 137      25.584  54.065  80.026  1.00 23.14           C  
ATOM   1158  O   PHE A 137      25.180  52.928  80.153  1.00 25.18           O  
ATOM   1159  CB  PHE A 137      28.021  54.709  79.795  1.00 25.07           C  
ATOM   1160  CG  PHE A 137      28.488  53.419  79.174  1.00 20.31           C  
ATOM   1161  CD1 PHE A 137      27.853  52.908  78.064  1.00 18.19           C  
ATOM   1162  CD2 PHE A 137      29.521  52.685  79.756  1.00 20.95           C  
ATOM   1163  CE1 PHE A 137      28.276  51.686  77.491  1.00 23.72           C  
ATOM   1164  CE2 PHE A 137      29.946  51.487  79.206  1.00 18.93           C  
ATOM   1165  CZ  PHE A 137      29.324  50.969  78.089  1.00 20.21           C  
ATOM   1166  N   LYS A 138      24.992  54.954  79.216  1.00 24.92           N  
ATOM   1167  CA  LYS A 138      23.784  54.614  78.478  1.00 25.32           C  
ATOM   1168  C   LYS A 138      24.017  53.405  77.572  1.00 28.71           C  
ATOM   1169  O   LYS A 138      24.872  53.426  76.681  1.00 27.40           O  
ATOM   1170  CB  LYS A 138      23.301  55.813  77.640  1.00 23.21           C  
ATOM   1171  CG  LYS A 138      21.954  55.570  76.979  1.00 28.40           C  
ATOM   1172  CD  LYS A 138      21.553  56.678  76.002  1.00 34.85           C  
ATOM   1173  N   GLY A 139      23.270  52.340  77.827  1.00 29.20           N  
ATOM   1174  CA  GLY A 139      23.346  51.130  77.020  1.00 29.90           C  
ATOM   1175  C   GLY A 139      24.328  50.048  77.477  1.00 30.28           C  
ATOM   1176  O   GLY A 139      24.527  49.042  76.775  1.00 32.83           O  
ATOM   1177  N   VAL A 140      24.958  50.276  78.622  1.00 29.32           N  
ATOM   1178  CA  VAL A 140      25.955  49.312  79.125  1.00 29.45           C  
ATOM   1179  C   VAL A 140      25.297  47.954  79.355  1.00 30.91           C  
ATOM   1180  O   VAL A 140      25.900  46.905  79.191  1.00 27.21           O  
ATOM   1181  CB  VAL A 140      26.699  49.828  80.384  1.00 27.00           C  
ATOM   1182  CG1 VAL A 140      25.774  49.966  81.592  1.00 29.00           C  
ATOM   1183  CG2 VAL A 140      27.885  48.891  80.679  1.00 26.90           C  
ATOM   1184  N   ASP A 141      23.993  47.996  79.603  1.00 32.00           N  
ATOM   1185  CA  ASP A 141      23.222  46.797  79.914  1.00 31.92           C  
ATOM   1186  C   ASP A 141      22.989  45.915  78.711  1.00 28.96           C  
ATOM   1187  O   ASP A 141      23.110  44.708  78.797  1.00 28.17           O  
ATOM   1188  CB  ASP A 141      21.866  47.192  80.531  1.00 33.29           C  
ATOM   1189  N   GLU A 142      22.669  46.510  77.575  1.00 30.33           N  
ATOM   1190  CA  GLU A 142      22.395  45.725  76.363  1.00 31.52           C  
ATOM   1191  C   GLU A 142      23.687  45.136  75.885  1.00 25.75           C  
ATOM   1192  O   GLU A 142      23.739  44.048  75.298  1.00 28.81           O  
ATOM   1193  CB  GLU A 142      21.790  46.586  75.252  1.00 34.74           C  
ATOM   1194  CG  GLU A 142      20.440  47.190  75.622  1.00 40.76           C  
ATOM   1195  CD  GLU A 142      20.526  48.134  76.825  1.00 49.47           C  
ATOM   1196  OE1 GLU A 142      21.495  48.919  76.915  1.00 56.39           O  
ATOM   1197  OE2 GLU A 142      19.623  48.095  77.683  1.00 61.73           O  
ATOM   1198  N   LEU A 143      24.740  45.905  76.123  1.00 26.45           N  
ATOM   1199  CA  LEU A 143      26.062  45.498  75.726  1.00 23.38           C  
ATOM   1200  C   LEU A 143      26.484  44.285  76.551  1.00 20.35           C  
ATOM   1201  O   LEU A 143      27.006  43.345  76.035  1.00 21.57           O  
ATOM   1202  CB  LEU A 143      27.035  46.649  75.926  1.00 23.74           C  
ATOM   1203  CG  LEU A 143      28.297  46.597  75.101  1.00 26.89           C  
ATOM   1204  CD1 LEU A 143      27.950  46.499  73.607  1.00 23.22           C  
ATOM   1205  CD2 LEU A 143      29.149  47.829  75.364  1.00 26.57           C  
ATOM   1206  N   ARG A 144      26.210  44.345  77.846  1.00 22.10           N  
ATOM   1207  CA  ARG A 144      26.494  43.225  78.753  1.00 22.13           C  
ATOM   1208  C   ARG A 144      25.698  41.984  78.349  1.00 21.93           C  
ATOM   1209  O   ARG A 144      26.223  40.899  78.328  1.00 20.75           O  
ATOM   1210  CB  ARG A 144      26.187  43.601  80.206  1.00 22.07           C  
ATOM   1211  CG  ARG A 144      27.282  44.407  80.892  1.00 21.02           C  
ATOM   1212  CD  ARG A 144      26.846  45.069  82.220  1.00 22.56           C  
ATOM   1213  NE  ARG A 144      27.955  45.791  82.841  1.00 21.97           N  
ATOM   1214  CZ  ARG A 144      27.837  46.855  83.606  1.00 24.23           C  
ATOM   1215  NH1 ARG A 144      26.640  47.379  83.864  1.00 22.46           N  
ATOM   1216  NH2 ARG A 144      28.902  47.432  84.080  1.00 23.50           N  
ATOM   1217  N   LYS A 145      24.420  42.164  78.023  1.00 25.05           N  
ATOM   1218  CA  LYS A 145      23.588  41.042  77.567  1.00 26.06           C  
ATOM   1219  C   LYS A 145      24.134  40.418  76.302  1.00 24.87           C  
ATOM   1220  O   LYS A 145      24.256  39.210  76.189  1.00 23.70           O  
ATOM   1221  CB  LYS A 145      22.139  41.473  77.290  1.00 28.32           C  
ATOM   1222  CG  LYS A 145      21.235  41.447  78.499  1.00 36.43           C  
ATOM   1223  CD  LYS A 145      19.774  41.542  78.084  1.00 37.97           C  
ATOM   1224  N   ALA A 146      24.468  41.271  75.336  1.00 22.81           N  
ATOM   1225  CA  ALA A 146      24.965  40.812  74.050  1.00 22.38           C  
ATOM   1226  C   ALA A 146      26.295  40.089  74.217  1.00 19.78           C  
ATOM   1227  O   ALA A 146      26.553  39.052  73.605  1.00 23.84           O  
ATOM   1228  CB  ALA A 146      25.089  42.018  73.090  1.00 22.11           C  
ATOM   1229  N   ALA A 147      27.138  40.612  75.101  1.00 21.78           N  
ATOM   1230  CA  ALA A 147      28.450  39.983  75.312  1.00 22.32           C  
ATOM   1231  C   ALA A 147      28.291  38.577  75.861  1.00 22.35           C  
ATOM   1232  O   ALA A 147      29.040  37.682  75.512  1.00 21.33           O  
ATOM   1233  CB  ALA A 147      29.350  40.834  76.229  1.00 20.68           C  
ATOM   1234  N   ASP A 148      27.298  38.402  76.731  1.00 21.73           N  
ATOM   1235  CA  ASP A 148      27.067  37.075  77.312  1.00 25.52           C  
ATOM   1236  C   ASP A 148      26.561  36.033  76.307  1.00 25.39           C  
ATOM   1237  O   ASP A 148      26.785  34.849  76.472  1.00 28.35           O  
ATOM   1238  CB  ASP A 148      26.096  37.165  78.498  1.00 24.56           C  
ATOM   1239  CG  ASP A 148      26.736  37.706  79.735  1.00 24.89           C  
ATOM   1240  OD1 ASP A 148      27.978  37.798  79.796  1.00 25.14           O  
ATOM   1241  OD2 ASP A 148      25.999  37.996  80.690  1.00 31.73           O  
ATOM   1242  N   GLU A 149      25.910  36.494  75.248  1.00 28.46           N  
ATOM   1243  CA  GLU A 149      25.259  35.604  74.266  1.00 31.86           C  
ATOM   1244  C   GLU A 149      25.865  35.540  72.874  1.00 30.02           C  
ATOM   1245  O   GLU A 149      25.915  34.487  72.238  1.00 33.67           O  
ATOM   1246  CB  GLU A 149      23.820  36.090  74.049  1.00 34.71           C  
ATOM   1247  CG  GLU A 149      22.988  36.227  75.305  1.00 42.91           C  
ATOM   1248  CD  GLU A 149      21.704  37.018  75.071  1.00 52.64           C  
ATOM   1249  OE1 GLU A 149      21.474  37.475  73.920  1.00 57.59           O  
ATOM   1250  OE2 GLU A 149      20.932  37.192  76.046  1.00 58.99           O  
ATOM   1251  N   ASP A 150      26.301  36.695  72.398  1.00 25.04           N  
ATOM   1252  CA  ASP A 150      26.759  36.844  71.034  1.00 26.35           C  
ATOM   1253  C   ASP A 150      27.834  37.945  70.985  1.00 21.11           C  
ATOM   1254  O   ASP A 150      27.581  39.124  70.778  1.00 22.01           O  
ATOM   1255  CB  ASP A 150      25.536  37.185  70.191  1.00 27.35           C  
ATOM   1256  CG  ASP A 150      25.834  37.250  68.699  1.00 33.19           C  
ATOM   1257  OD1 ASP A 150      27.009  37.165  68.304  1.00 32.69           O  
ATOM   1258  OD2 ASP A 150      24.868  37.393  67.911  1.00 43.34           O  
ATOM   1259  N   LEU A 151      29.035  37.481  71.236  1.00 22.95           N  
ATOM   1260  CA  LEU A 151      30.208  38.316  71.351  1.00 23.63           C  
ATOM   1261  C   LEU A 151      30.403  39.196  70.105  1.00 24.02           C  
ATOM   1262  O   LEU A 151      30.645  40.377  70.235  1.00 21.84           O  
ATOM   1263  CB  LEU A 151      31.434  37.429  71.629  1.00 25.65           C  
ATOM   1264  CG  LEU A 151      32.741  38.065  72.048  1.00 24.28           C  
ATOM   1265  CD1 LEU A 151      32.454  38.999  73.241  1.00 23.73           C  
ATOM   1266  CD2 LEU A 151      33.774  36.961  72.354  1.00 23.33           C  
ATOM   1267  N   ASN A 152      30.259  38.615  68.917  1.00 22.10           N  
ATOM   1268  CA  ASN A 152      30.413  39.385  67.684  1.00 21.67           C  
ATOM   1269  C   ASN A 152      29.370  40.515  67.593  1.00 20.40           C  
ATOM   1270  O   ASN A 152      29.656  41.644  67.153  1.00 19.67           O  
ATOM   1271  CB  ASN A 152      30.370  38.468  66.445  1.00 21.22           C  
ATOM   1272  CG  ASN A 152      31.609  37.597  66.302  1.00 25.58           C  
ATOM   1273  OD1 ASN A 152      32.656  37.889  66.871  1.00 23.71           O  
ATOM   1274  ND2 ASN A 152      31.494  36.517  65.539  1.00 26.76           N  
ATOM   1275  N   LYS A 153      28.152  40.217  68.019  1.00 19.13           N  
ATOM   1276  CA  LYS A 153      27.130  41.238  68.053  1.00 21.24           C  
ATOM   1277  C   LYS A 153      27.540  42.385  68.970  1.00 21.01           C  
ATOM   1278  O   LYS A 153      27.362  43.551  68.671  1.00 21.43           O  
ATOM   1279  CB  LYS A 153      25.781  40.645  68.505  1.00 25.76           C  
ATOM   1280  CG  LYS A 153      24.654  41.673  68.691  1.00 28.95           C  
ATOM   1281  CD  LYS A 153      23.390  41.010  69.308  1.00 35.97           C  
ATOM   1282  CE  LYS A 153      22.212  41.996  69.442  1.00 40.63           C  
ATOM   1283  N   ALA A 154      28.066  42.033  70.149  1.00 19.97           N  
ATOM   1284  CA  ALA A 154      28.462  43.024  71.112  1.00 18.46           C  
ATOM   1285  C   ALA A 154      29.560  43.936  70.540  1.00 15.54           C  
ATOM   1286  O   ALA A 154      29.524  45.139  70.715  1.00 15.80           O  
ATOM   1287  CB  ALA A 154      28.950  42.320  72.404  1.00 19.35           C  
ATOM   1288  N   LEU A 155      30.553  43.339  69.897  0.50 17.75           N  
ATOM   1290  CA  LEU A 155      31.633  44.165  69.321  0.50 16.90           C  
ATOM   1292  C   LEU A 155      31.056  45.122  68.281  0.50 16.15           C  
ATOM   1294  O   LEU A 155      31.294  46.335  68.343  0.50 12.70           O  
ATOM   1296  CB  LEU A 155      32.739  43.326  68.718  0.50 16.36           C  
ATOM   1298  CG  LEU A 155      33.909  43.012  69.644  0.50 20.84           C  
ATOM   1300  CD1 LEU A 155      33.520  42.089  70.769  0.50 14.78           C  
ATOM   1302  CD2 LEU A 155      35.048  42.410  68.809  0.50 16.72           C  
ATOM   1304  N   LEU A 156      30.212  44.573  67.410  1.00 18.65           N  
ATOM   1305  CA  LEU A 156      29.611  45.392  66.364  1.00 20.17           C  
ATOM   1306  C   LEU A 156      28.855  46.567  66.961  1.00 18.41           C  
ATOM   1307  O   LEU A 156      29.009  47.705  66.517  1.00 20.31           O  
ATOM   1308  CB  LEU A 156      28.762  44.488  65.455  1.00 22.26           C  
ATOM   1309  CG  LEU A 156      28.175  45.079  64.172  1.00 29.95           C  
ATOM   1310  CD1 LEU A 156      29.232  45.821  63.370  1.00 24.36           C  
ATOM   1311  CD2 LEU A 156      27.520  43.953  63.329  1.00 28.62           C  
HETATM 1312  N   MSE A 157      28.088  46.305  68.013  0.50 18.53           N  
HETATM 1314  CA  MSE A 157      27.366  47.355  68.682  0.50 18.75           C  
HETATM 1316  C   MSE A 157      28.333  48.413  69.225  0.50 17.73           C  
HETATM 1318  O   MSE A 157      28.079  49.618  69.178  0.50 18.80           O  
HETATM 1320  CB  MSE A 157      26.531  46.747  69.812  0.50 19.45           C  
HETATM 1322  CG  MSE A 157      25.480  45.772  69.323  0.50 23.50           C  
HETATM 1324 SE   MSE A 157      24.730  44.764  70.781  0.38 23.10          SE  
HETATM 1326  CE  MSE A 157      24.670  46.357  72.039  0.50  8.65           C  
ATOM   1328  N   SER A 158      29.445  47.946  69.791  1.00 19.42           N  
ATOM   1329  CA  SER A 158      30.456  48.866  70.342  1.00 17.48           C  
ATOM   1330  C   SER A 158      31.140  49.742  69.287  1.00 14.28           C  
ATOM   1331  O   SER A 158      31.311  50.959  69.480  1.00 15.81           O  
ATOM   1332  CB  SER A 158      31.503  48.088  71.183  1.00 17.44           C  
ATOM   1333  OG  SER A 158      32.372  48.992  71.841  1.00 25.62           O  
ATOM   1334  N   PHE A 159      31.502  49.107  68.171  1.00 15.23           N  
ATOM   1335  CA  PHE A 159      32.160  49.796  67.052  1.00 14.35           C  
ATOM   1336  C   PHE A 159      31.215  50.883  66.497  1.00 15.23           C  
ATOM   1337  O   PHE A 159      31.629  52.033  66.250  1.00 17.37           O  
ATOM   1338  CB  PHE A 159      32.559  48.818  65.954  1.00 16.42           C  
ATOM   1339  CG  PHE A 159      33.598  47.814  66.344  1.00 14.71           C  
ATOM   1340  CD1 PHE A 159      34.619  48.121  67.212  1.00 15.81           C  
ATOM   1341  CD2 PHE A 159      33.623  46.613  65.727  1.00 14.36           C  
ATOM   1342  CE1 PHE A 159      35.601  47.186  67.493  1.00 15.86           C  
ATOM   1343  CE2 PHE A 159      34.609  45.681  65.980  1.00 16.44           C  
ATOM   1344  CZ  PHE A 159      35.572  45.969  66.883  1.00 14.54           C  
ATOM   1345  N   ASP A 160      29.965  50.497  66.312  1.00 15.33           N  
ATOM   1346  CA  ASP A 160      28.948  51.443  65.804  1.00 17.04           C  
ATOM   1347  C   ASP A 160      28.816  52.635  66.721  1.00 17.75           C  
ATOM   1348  O   ASP A 160      28.813  53.773  66.306  1.00 17.85           O  
ATOM   1349  CB  ASP A 160      27.601  50.755  65.557  1.00 17.66           C  
ATOM   1350  CG  ASP A 160      27.602  49.836  64.351  1.00 18.73           C  
ATOM   1351  OD1 ASP A 160      28.581  49.805  63.583  1.00 19.11           O  
ATOM   1352  OD2 ASP A 160      26.588  49.118  64.170  1.00 19.79           O  
ATOM   1353  N   ASN A 161      28.728  52.351  68.020  0.70 19.83           N  
ATOM   1355  CA  ASN A 161      28.610  53.431  69.002  0.70 20.62           C  
ATOM   1357  C   ASN A 161      29.819  54.360  68.970  0.70 18.25           C  
ATOM   1359  O   ASN A 161      29.701  55.578  69.023  0.70 18.08           O  
ATOM   1361  CB  ASN A 161      28.518  52.875  70.424  0.70 23.22           C  
ATOM   1363  CG  ASN A 161      27.301  52.003  70.668  0.70 32.44           C  
ATOM   1365  OD1 ASN A 161      26.319  52.044  69.931  0.70 35.77           O  
ATOM   1367  ND2 ASN A 161      27.359  51.206  71.744  0.70 38.45           N  
ATOM   1369  N   THR A 162      31.009  53.769  68.932  1.00 16.43           N  
ATOM   1370  CA  THR A 162      32.237  54.541  68.885  1.00 17.78           C  
ATOM   1371  C   THR A 162      32.270  55.478  67.660  1.00 14.21           C  
ATOM   1372  O   THR A 162      32.528  56.667  67.770  1.00 16.55           O  
ATOM   1373  CB  THR A 162      33.466  53.635  68.872  1.00 18.83           C  
ATOM   1374  OG1 THR A 162      33.579  53.019  70.168  1.00 21.16           O  
ATOM   1375  CG2 THR A 162      34.760  54.397  68.585  1.00 18.21           C  
ATOM   1376  N   ILE A 163      31.943  54.927  66.503  1.00 17.46           N  
ATOM   1377  CA  ILE A 163      32.039  55.687  65.272  1.00 15.82           C  
ATOM   1378  C   ILE A 163      31.050  56.857  65.300  1.00 14.86           C  
ATOM   1379  O   ILE A 163      31.403  57.997  64.989  1.00 15.87           O  
ATOM   1380  CB  ILE A 163      31.815  54.793  64.041  1.00 15.35           C  
ATOM   1381  CG1 ILE A 163      32.955  53.754  63.892  1.00 14.36           C  
ATOM   1382  CG2 ILE A 163      31.757  55.677  62.756  1.00 14.14           C  
ATOM   1383  CD1 ILE A 163      32.572  52.579  63.002  1.00 16.97           C  
ATOM   1384  N   LYS A 164      29.834  56.574  65.757  1.00 17.34           N  
ATOM   1385  CA  LYS A 164      28.799  57.651  65.821  1.00 18.65           C  
ATOM   1386  C   LYS A 164      29.231  58.724  66.824  1.00 18.48           C  
ATOM   1387  O   LYS A 164      29.098  59.922  66.592  1.00 19.74           O  
ATOM   1388  CB  LYS A 164      27.421  57.090  66.179  1.00 20.11           C  
ATOM   1389  CG  LYS A 164      26.809  56.305  65.065  1.00 21.71           C  
ATOM   1390  CD  LYS A 164      25.411  55.910  65.373  1.00 33.12           C  
ATOM   1391  CE  LYS A 164      25.353  54.751  66.307  1.00 37.58           C  
ATOM   1392  NZ  LYS A 164      23.932  54.380  66.523  1.00 46.71           N  
ATOM   1393  N   PHE A 165      29.838  58.289  67.935  1.00 18.55           N  
ATOM   1394  CA  PHE A 165      30.267  59.231  68.964  1.00 19.58           C  
ATOM   1395  C   PHE A 165      31.372  60.135  68.470  1.00 17.28           C  
ATOM   1396  O   PHE A 165      31.349  61.347  68.658  1.00 18.85           O  
ATOM   1397  CB  PHE A 165      30.695  58.469  70.237  1.00 19.33           C  
ATOM   1398  CG  PHE A 165      31.133  59.374  71.373  1.00 21.30           C  
ATOM   1399  CD1 PHE A 165      30.211  59.900  72.255  1.00 32.28           C  
ATOM   1400  CD2 PHE A 165      32.463  59.722  71.529  1.00 23.17           C  
ATOM   1401  CE1 PHE A 165      30.622  60.750  73.273  1.00 26.63           C  
ATOM   1402  CE2 PHE A 165      32.873  60.565  72.562  1.00 31.97           C  
ATOM   1403  CZ  PHE A 165      31.947  61.071  73.429  1.00 30.28           C  
ATOM   1404  N   VAL A 166      32.346  59.544  67.787  1.00 16.19           N  
ATOM   1405  CA  VAL A 166      33.454  60.315  67.247  1.00 16.66           C  
ATOM   1406  C   VAL A 166      32.921  61.331  66.213  1.00 15.55           C  
ATOM   1407  O   VAL A 166      33.418  62.472  66.179  1.00 17.38           O  
ATOM   1408  CB  VAL A 166      34.543  59.386  66.625  1.00 18.00           C  
ATOM   1409  CG1 VAL A 166      35.533  60.170  65.797  1.00 22.05           C  
ATOM   1410  CG2 VAL A 166      35.247  58.584  67.743  1.00 16.91           C  
ATOM   1411  N   ILE A 167      31.980  60.878  65.368  1.00 19.53           N  
ATOM   1412  CA  ILE A 167      31.407  61.771  64.335  1.00 17.26           C  
ATOM   1413  C   ILE A 167      30.759  62.958  65.042  1.00 19.57           C  
ATOM   1414  O   ILE A 167      30.990  64.095  64.696  1.00 19.84           O  
ATOM   1415  CB  ILE A 167      30.431  61.044  63.385  1.00 19.35           C  
ATOM   1416  CG1 ILE A 167      31.251  60.174  62.416  1.00 20.00           C  
ATOM   1417  CG2 ILE A 167      29.530  62.071  62.634  1.00 18.71           C  
ATOM   1418  CD1 ILE A 167      30.395  59.235  61.701  1.00 20.18           C  
ATOM   1419  N   ASP A 168      29.984  62.638  66.070  0.50 20.96           N  
ATOM   1421  CA  ASP A 168      29.257  63.639  66.869  0.50 22.56           C  
ATOM   1423  C   ASP A 168      30.185  64.663  67.510  0.50 23.56           C  
ATOM   1425  O   ASP A 168      29.811  65.823  67.679  0.50 24.79           O  
ATOM   1427  CB  ASP A 168      28.470  62.945  67.979  0.50 21.68           C  
ATOM   1429  CG  ASP A 168      27.758  63.931  68.891  0.50 27.37           C  
ATOM   1431  OD1 ASP A 168      26.840  64.626  68.417  0.50 28.42           O  
ATOM   1433  OD2 ASP A 168      28.103  63.986  70.089  0.50 30.87           O  
ATOM   1435  N   LYS A 169      31.379  64.210  67.884  1.00 21.94           N  
ATOM   1436  CA  LYS A 169      32.393  65.044  68.524  1.00 21.98           C  
ATOM   1437  C   LYS A 169      33.383  65.636  67.558  1.00 20.69           C  
ATOM   1438  O   LYS A 169      34.239  66.409  67.938  1.00 23.17           O  
ATOM   1439  CB  LYS A 169      33.135  64.262  69.618  1.00 24.70           C  
ATOM   1440  CG  LYS A 169      32.229  63.693  70.653  1.00 27.45           C  
ATOM   1441  CD  LYS A 169      31.095  64.639  70.925  1.00 38.81           C  
ATOM   1442  CE  LYS A 169      30.154  64.129  71.986  1.00 41.72           C  
ATOM   1443  NZ  LYS A 169      30.746  64.344  73.310  1.00 47.79           N  
ATOM   1444  N   GLY A 170      33.295  65.263  66.281  1.00 18.90           N  
ATOM   1445  CA  GLY A 170      34.209  65.799  65.280  1.00 19.91           C  
ATOM   1446  C   GLY A 170      35.645  65.301  65.326  1.00 17.85           C  
ATOM   1447  O   GLY A 170      36.572  65.962  64.877  1.00 20.01           O  
ATOM   1448  N   GLY A 171      35.816  64.107  65.867  1.00 19.14           N  
ATOM   1449  CA  GLY A 171      37.155  63.558  65.986  1.00 19.69           C  
ATOM   1450  C   GLY A 171      37.598  62.679  64.825  1.00 19.74           C  
ATOM   1451  O   GLY A 171      36.909  62.486  63.842  1.00 17.90           O  
ATOM   1452  N   PHE A 172      38.804  62.184  64.937  1.00 19.13           N  
ATOM   1453  CA  PHE A 172      39.367  61.287  63.937  1.00 17.50           C  
ATOM   1454  C   PHE A 172      38.886  59.864  64.108  1.00 17.13           C  
ATOM   1455  O   PHE A 172      38.705  59.381  65.228  1.00 18.11           O  
ATOM   1456  CB  PHE A 172      40.908  61.286  63.986  1.00 17.40           C  
ATOM   1457  CG  PHE A 172      41.562  62.627  63.641  1.00 21.23           C  
ATOM   1458  CD1 PHE A 172      41.571  63.152  62.331  1.00 20.44           C  
ATOM   1459  CD2 PHE A 172      42.225  63.340  64.625  1.00 21.38           C  
ATOM   1460  CE1 PHE A 172      42.200  64.348  62.035  1.00 24.63           C  
ATOM   1461  CE2 PHE A 172      42.873  64.534  64.323  1.00 27.34           C  
ATOM   1462  CZ  PHE A 172      42.849  65.048  63.018  1.00 22.20           C  
ATOM   1463  N   LEU A 173      38.686  59.161  62.999  1.00 15.92           N  
ATOM   1464  CA  LEU A 173      38.305  57.750  63.035  1.00 15.75           C  
ATOM   1465  C   LEU A 173      39.497  56.881  62.647  1.00 15.47           C  
ATOM   1466  O   LEU A 173      40.117  57.076  61.582  1.00 15.68           O  
ATOM   1467  CB  LEU A 173      37.163  57.435  62.067  1.00 13.91           C  
ATOM   1468  CG  LEU A 173      35.795  58.045  62.385  1.00 13.59           C  
ATOM   1469  CD1 LEU A 173      34.842  57.919  61.178  1.00 17.49           C  
ATOM   1470  CD2 LEU A 173      35.245  57.333  63.634  1.00 16.81           C  
ATOM   1471  N   HIS A 174      39.845  55.926  63.510  1.00 15.23           N  
ATOM   1472  CA  HIS A 174      40.992  55.077  63.303  1.00 14.39           C  
ATOM   1473  C   HIS A 174      40.662  53.909  62.366  1.00 12.40           C  
ATOM   1474  O   HIS A 174      39.653  53.212  62.539  1.00 14.05           O  
ATOM   1475  CB  HIS A 174      41.501  54.560  64.658  1.00 15.86           C  
ATOM   1476  CG  HIS A 174      42.845  53.945  64.587  1.00 18.27           C  
ATOM   1477  ND1 HIS A 174      43.088  52.712  64.025  1.00 16.86           N  
ATOM   1478  CD2 HIS A 174      44.046  54.400  65.023  1.00 28.87           C  
ATOM   1479  CE1 HIS A 174      44.382  52.442  64.096  1.00 20.08           C  
ATOM   1480  NE2 HIS A 174      44.982  53.442  64.709  1.00 29.36           N  
ATOM   1481  N   HIS A 175      41.541  53.672  61.398  1.00 12.10           N  
ATOM   1482  CA  HIS A 175      41.290  52.635  60.398  1.00 12.22           C  
ATOM   1483  C   HIS A 175      41.076  51.259  60.987  1.00 12.25           C  
ATOM   1484  O   HIS A 175      40.325  50.446  60.464  1.00 13.98           O  
ATOM   1485  CB  HIS A 175      42.402  52.575  59.329  1.00 13.20           C  
ATOM   1486  CG  HIS A 175      43.684  51.978  59.808  1.00 15.83           C  
ATOM   1487  ND1 HIS A 175      44.009  50.655  59.609  1.00 19.45           N  
ATOM   1488  CD2 HIS A 175      44.696  52.510  60.530  1.00 22.09           C  
ATOM   1489  CE1 HIS A 175      45.200  50.419  60.138  1.00 23.92           C  
ATOM   1490  NE2 HIS A 175      45.621  51.518  60.725  1.00 23.14           N  
ATOM   1491  N   ASN A 176      41.725  50.973  62.128  1.00 12.62           N  
ATOM   1492  CA  ASN A 176      41.574  49.631  62.707  1.00 12.80           C  
ATOM   1493  C   ASN A 176      40.147  49.342  63.158  1.00 14.16           C  
ATOM   1494  O   ASN A 176      39.643  48.220  63.037  1.00 13.82           O  
ATOM   1495  CB  ASN A 176      42.538  49.374  63.869  1.00 12.30           C  
ATOM   1496  CG  ASN A 176      43.887  48.874  63.402  1.00 21.68           C  
ATOM   1497  OD1 ASN A 176      44.021  48.365  62.296  1.00 25.37           O  
ATOM   1498  ND2 ASN A 176      44.881  49.020  64.239  1.00 22.94           N  
ATOM   1499  N   THR A 177      39.495  50.374  63.664  1.00 12.68           N  
ATOM   1500  CA  THR A 177      38.132  50.238  64.133  1.00 14.39           C  
ATOM   1501  C   THR A 177      37.178  50.049  62.928  1.00 16.57           C  
ATOM   1502  O   THR A 177      36.275  49.182  62.917  1.00 15.44           O  
ATOM   1503  CB  THR A 177      37.725  51.372  65.012  1.00 18.80           C  
ATOM   1504  OG1 THR A 177      38.602  51.373  66.153  1.00 17.78           O  
ATOM   1505  CG2 THR A 177      36.292  51.134  65.474  1.00 17.48           C  
ATOM   1506  N   ILE A 178      37.456  50.827  61.881  1.00 13.81           N  
ATOM   1507  CA  ILE A 178      36.621  50.735  60.669  1.00 13.49           C  
ATOM   1508  C   ILE A 178      36.788  49.333  60.041  1.00 12.71           C  
ATOM   1509  O   ILE A 178      35.800  48.658  59.661  1.00 14.48           O  
ATOM   1510  CB  ILE A 178      36.981  51.854  59.654  1.00 14.07           C  
ATOM   1511  CG1 ILE A 178      36.817  53.256  60.254  1.00 15.66           C  
ATOM   1512  CG2 ILE A 178      36.137  51.709  58.379  1.00 14.11           C  
ATOM   1513  CD1 ILE A 178      35.474  53.551  60.924  1.00 16.65           C  
ATOM   1514  N   GLU A 179      38.031  48.911  59.953  1.00 11.92           N  
ATOM   1515  CA  GLU A 179      38.381  47.610  59.335  1.00 12.00           C  
ATOM   1516  C   GLU A 179      37.878  46.434  60.202  1.00 13.29           C  
ATOM   1517  O   GLU A 179      37.353  45.446  59.692  1.00 15.69           O  
ATOM   1518  CB  GLU A 179      39.862  47.517  58.966  1.00 15.54           C  
ATOM   1519  CG  GLU A 179      40.111  48.574  57.894  1.00 16.88           C  
ATOM   1520  CD  GLU A 179      41.502  49.132  57.760  1.00 32.91           C  
ATOM   1521  OE1 GLU A 179      42.433  48.610  58.389  1.00 27.01           O  
ATOM   1522  OE2 GLU A 179      41.643  50.125  56.965  1.00 29.53           O  
ATOM   1523  N   ALA A 180      37.912  46.623  61.524  1.00 13.70           N  
ATOM   1524  CA  ALA A 180      37.388  45.631  62.424  1.00 14.18           C  
ATOM   1525  C   ALA A 180      35.886  45.416  62.216  1.00 15.56           C  
ATOM   1526  O   ALA A 180      35.381  44.281  62.211  1.00 15.54           O  
ATOM   1527  CB  ALA A 180      37.678  46.066  63.902  1.00 15.12           C  
ATOM   1528  N   ARG A 181      35.165  46.509  62.111  1.00 14.35           N  
ATOM   1529  CA  ARG A 181      33.743  46.485  61.881  1.00 14.19           C  
ATOM   1530  C   ARG A 181      33.427  45.837  60.516  1.00 16.62           C  
ATOM   1531  O   ARG A 181      32.566  44.960  60.435  1.00 16.66           O  
ATOM   1532  CB  ARG A 181      33.136  47.887  61.980  1.00 14.00           C  
ATOM   1533  CG  ARG A 181      31.682  47.972  61.660  1.00 15.12           C  
ATOM   1534  CD  ARG A 181      31.168  49.368  61.688  1.00 15.71           C  
ATOM   1535  NE  ARG A 181      29.781  49.368  61.216  1.00 15.63           N  
ATOM   1536  CZ  ARG A 181      29.466  49.315  59.923  1.00 19.23           C  
ATOM   1537  NH1 ARG A 181      30.403  49.313  58.997  1.00 17.16           N  
ATOM   1538  NH2 ARG A 181      28.195  49.254  59.561  1.00 17.19           N  
ATOM   1539  N   ASN A 182      34.127  46.258  59.461  1.00 14.85           N  
ATOM   1540  CA  ASN A 182      33.858  45.692  58.150  1.00 15.52           C  
ATOM   1541  C   ASN A 182      34.036  44.197  58.175  1.00 17.81           C  
ATOM   1542  O   ASN A 182      33.263  43.459  57.570  1.00 18.82           O  
ATOM   1543  CB  ASN A 182      34.749  46.307  57.047  1.00 13.07           C  
ATOM   1544  CG  ASN A 182      34.334  47.704  56.642  1.00 14.41           C  
ATOM   1545  OD1 ASN A 182      33.190  48.082  56.771  1.00 16.60           O  
ATOM   1546  ND2 ASN A 182      35.292  48.463  56.146  1.00 15.70           N  
ATOM   1547  N   TYR A 183      35.094  43.745  58.822  1.00 16.19           N  
ATOM   1548  CA  TYR A 183      35.428  42.320  58.899  1.00 18.26           C  
ATOM   1549  C   TYR A 183      34.277  41.542  59.565  1.00 18.78           C  
ATOM   1550  O   TYR A 183      33.880  40.481  59.080  1.00 21.45           O  
ATOM   1551  CB  TYR A 183      36.756  42.121  59.641  1.00 20.39           C  
ATOM   1552  CG  TYR A 183      37.165  40.685  59.657  1.00 19.20           C  
ATOM   1553  CD1 TYR A 183      36.668  39.832  60.609  1.00 17.43           C  
ATOM   1554  CD2 TYR A 183      38.068  40.189  58.723  1.00 21.38           C  
ATOM   1555  CE1 TYR A 183      37.026  38.502  60.626  1.00 19.77           C  
ATOM   1556  CE2 TYR A 183      38.442  38.849  58.720  1.00 22.89           C  
ATOM   1557  CZ  TYR A 183      37.910  38.022  59.693  1.00 20.17           C  
ATOM   1558  OH  TYR A 183      38.261  36.688  59.708  1.00 26.97           O  
ATOM   1559  N   LEU A 184      33.713  42.064  60.647  1.00 17.33           N  
ATOM   1560  CA  LEU A 184      32.580  41.402  61.325  1.00 21.43           C  
ATOM   1561  C   LEU A 184      31.346  41.396  60.436  1.00 23.11           C  
ATOM   1562  O   LEU A 184      30.646  40.400  60.377  1.00 24.87           O  
ATOM   1563  CB  LEU A 184      32.250  42.027  62.676  1.00 21.22           C  
ATOM   1564  CG  LEU A 184      33.347  41.785  63.725  1.00 22.17           C  
ATOM   1565  CD1 LEU A 184      32.853  42.421  65.020  1.00 23.45           C  
ATOM   1566  CD2 LEU A 184      33.633  40.291  63.886  1.00 20.61           C  
ATOM   1567  N   ILE A 185      31.108  42.483  59.715  1.00 20.95           N  
ATOM   1568  CA  ILE A 185      29.951  42.518  58.836  1.00 24.32           C  
ATOM   1569  C   ILE A 185      30.085  41.466  57.756  1.00 27.70           C  
ATOM   1570  O   ILE A 185      29.111  40.789  57.442  1.00 31.81           O  
ATOM   1571  CB  ILE A 185      29.788  43.865  58.202  1.00 23.97           C  
ATOM   1572  CG1 ILE A 185      29.337  44.863  59.267  1.00 28.20           C  
ATOM   1573  CG2 ILE A 185      28.764  43.778  57.043  1.00 22.48           C  
ATOM   1574  CD1 ILE A 185      29.522  46.235  58.844  1.00 27.45           C  
ATOM   1575  N   SER A 186      31.293  41.276  57.248  1.00 27.93           N  
ATOM   1576  CA  SER A 186      31.524  40.348  56.134  1.00 35.01           C  
ATOM   1577  C   SER A 186      31.497  38.878  56.546  1.00 40.42           C  
ATOM   1578  O   SER A 186      31.442  37.985  55.681  1.00 40.93           O  
ATOM   1579  CB  SER A 186      32.868  40.616  55.448  1.00 32.72           C  
ATOM   1580  OG  SER A 186      33.936  40.102  56.227  1.00 43.84           O  
ATOM   1581  N   ARG A 187      31.565  38.630  57.851  1.00 43.92           N  
ATOM   1582  CA  ARG A 187      31.578  37.257  58.382  1.00 47.37           C  
ATOM   1583  C   ARG A 187      30.198  36.936  58.922  1.00 48.58           C  
ATOM   1584  O   ARG A 187      29.891  35.799  59.277  1.00 50.51           O  
ATOM   1585  CB  ARG A 187      32.591  37.104  59.526  1.00 47.35           C  
ATOM   1586  CG  ARG A 187      34.020  37.317  59.128  1.00 45.23           C  
ATOM   1587  CD  ARG A 187      34.438  36.314  58.093  1.00 48.06           C  
ATOM   1588  NE  ARG A 187      35.698  36.693  57.468  1.00 46.84           N  
ATOM   1589  N   LYS A 188      29.380  37.970  58.966  1.00 50.13           N  
ATOM   1590  CA  LYS A 188      28.037  37.894  59.525  1.00 51.48           C  
ATOM   1591  C   LYS A 188      27.018  37.631  58.431  1.00 53.53           C  
ATOM   1592  O   LYS A 188      27.352  37.050  57.393  1.00 56.96           O  
ATOM   1593  CB  LYS A 188      27.728  39.206  60.239  1.00 53.22           C  
ATOM   1594  CG  LYS A 188      26.342  39.367  60.815  1.00 55.62           C  
ATOM   1595  CD  LYS A 188      26.161  40.835  61.159  1.00 58.41           C  
ATOM   1596  CE  LYS A 188      24.755  41.170  61.597  1.00 63.15           C  
ATOM   1597  NZ  LYS A 188      24.619  42.637  61.896  1.00 67.77           N  
TER    1598      LYS A 188                                                      
END
MOLECULE T0470.pdb
ATOM      1  N   THR     2      54.420  27.522  88.035  1.00 67.73           N  
ATOM      2  CA  THR     2      53.108  27.380  87.344  1.00 69.65           C  
ATOM      3  C   THR     2      52.525  28.722  86.889  1.00 69.97           C  
ATOM      4  O   THR     2      52.981  29.793  87.306  1.00 70.58           O  
ATOM      5  CB  THR     2      52.070  26.669  88.248  1.00 70.47           C  
ATOM      6  OG1 THR     2      50.847  26.474  87.525  1.00 71.89           O  
ATOM      7  CG2 THR     2      51.777  27.494  89.491  1.00 72.01           C  
ATOM      8  N   LYS     3      51.513  28.656  86.023  1.00 69.74           N  
ATOM      9  CA  LYS     3      50.861  29.849  85.484  1.00 69.53           C  
ATOM     10  C   LYS     3      50.268  30.737  86.573  1.00 70.20           C  
ATOM     11  O   LYS     3      50.510  31.945  86.591  1.00 69.16           O  
ATOM     12  CB  LYS     3      49.782  29.428  84.482  1.00 67.78           C  
ATOM     13  CG  LYS     3      50.303  29.361  83.052  1.00 68.14           C  
ATOM     14  CD  LYS     3      49.618  28.289  82.210  1.00 68.04           C  
ATOM     15  CE  LYS     3      49.960  28.461  80.732  1.00 67.69           C  
ATOM     16  NZ  LYS     3      51.397  28.805  80.520  1.00 68.33           N  
ATOM     17  N   GLN     4      49.505  30.130  87.481  1.00 70.53           N  
ATOM     18  CA  GLN     4      48.886  30.864  88.569  1.00 70.32           C  
ATOM     19  C   GLN     4      49.929  31.629  89.343  1.00 70.52           C  
ATOM     20  O   GLN     4      49.650  32.691  89.886  1.00 70.49           O  
ATOM     21  CB  GLN     4      48.149  29.918  89.517  1.00 70.74           C  
ATOM     22  CG  GLN     4      47.408  30.606  90.679  1.00 69.51           C  
ATOM     23  CD  GLN     4      46.205  31.420  90.223  1.00 68.71           C  
ATOM     24  OE1 GLN     4      45.399  30.969  89.405  1.00 68.36           O  
ATOM     25  NE2 GLN     4      46.064  32.617  90.776  1.00 68.07           N  
ATOM     26  N   GLU     5      51.137  31.100  89.418  1.00 72.17           N  
ATOM     27  CA  GLU     5      52.161  31.829  90.151  1.00 74.75           C  
ATOM     28  C   GLU     5      52.585  33.043  89.329  1.00 74.42           C  
ATOM     29  O   GLU     5      53.116  34.009  89.867  1.00 74.73           O  
ATOM     30  CB  GLU     5      53.366  30.926  90.458  1.00 76.64           C  
ATOM     31  CG  GLU     5      53.047  29.773  91.424  1.00 78.98           C  
ATOM     32  CD  GLU     5      54.280  28.980  91.856  1.00 79.51           C  
ATOM     33  OE1 GLU     5      55.222  29.593  92.417  1.00 79.22           O  
ATOM     34  OE2 GLU     5      54.298  27.744  91.649  1.00 79.24           O  
ATOM     35  N   LYS     6      52.328  32.993  88.026  1.00 73.80           N  
ATOM     36  CA  LYS     6      52.683  34.095  87.143  1.00 73.49           C  
ATOM     37  C   LYS     6      51.562  35.126  87.171  1.00 72.47           C  
ATOM     38  O   LYS     6      51.789  36.313  87.420  1.00 71.47           O  
ATOM     39  CB  LYS     6      52.922  33.561  85.727  1.00 75.15           C  
ATOM     40  CG  LYS     6      53.997  32.466  85.693  1.00 76.88           C  
ATOM     41  CD  LYS     6      54.449  32.067  84.283  1.00 76.71           C  
ATOM     42  CE  LYS     6      55.567  31.015  84.358  1.00 75.99           C  
ATOM     43  NZ  LYS     6      56.007  30.494  83.030  1.00 75.46           N  
ATOM     44  N   ILE     7      50.344  34.662  86.925  1.00 72.48           N  
ATOM     45  CA  ILE     7      49.190  35.538  86.961  1.00 72.23           C  
ATOM     46  C   ILE     7      49.228  36.208  88.335  1.00 72.32           C  
ATOM     47  O   ILE     7      48.704  37.300  88.502  1.00 73.73           O  
ATOM     48  CB  ILE     7      47.868  34.730  86.768  1.00 70.53           C  
ATOM     49  CG1 ILE     7      46.677  35.665  86.607  1.00 71.42           C  
ATOM     50  CG2 ILE     7      47.591  33.867  87.974  1.00 69.54           C  
ATOM     51  CD1 ILE     7      45.974  36.012  87.908  1.00 69.78           C  
ATOM     52  N   GLU     8      49.867  35.568  89.314  1.00 73.67           N  
ATOM     53  CA  GLU     8      49.958  36.157  90.650  1.00 74.45           C  
ATOM     54  C   GLU     8      51.022  37.243  90.738  1.00 74.03           C  
ATOM     55  O   GLU     8      50.756  38.341  91.224  1.00 75.27           O  
ATOM     56  CB  GLU     8      50.273  35.100  91.719  1.00 73.53           C  
ATOM     57  CG  GLU     8      49.055  34.457  92.367  1.00 75.26           C  
ATOM     58  CD  GLU     8      49.396  33.705  93.653  1.00 76.05           C  
ATOM     59  OE1 GLU     8      48.502  33.009  94.197  1.00 73.33           O  
ATOM     60  OE2 GLU     8      50.553  33.824  94.123  1.00 76.36           O  
ATOM     61  N   LYS     9      52.229  36.936  90.275  1.00 73.00           N  
ATOM     62  CA  LYS     9      53.322  37.894  90.358  1.00 72.14           C  
ATOM     63  C   LYS     9      53.089  39.085  89.445  1.00 72.09           C  
ATOM     64  O   LYS     9      53.622  40.178  89.668  1.00 70.96           O  
ATOM     65  CB  LYS     9      54.642  37.225  90.000  1.00 72.09           C  
ATOM     66  CG  LYS     9      55.819  37.867  90.700  1.00 72.17           C  
ATOM     67  CD  LYS     9      55.863  37.465  92.169  1.00 70.32           C  
ATOM     68  CE  LYS     9      56.739  38.411  92.991  1.00 69.14           C  
ATOM     69  NZ  LYS     9      56.059  39.713  93.280  1.00 66.21           N  
ATOM     70  N   THR    10      52.286  38.858  88.411  1.00 72.36           N  
ATOM     71  CA  THR    10      51.944  39.896  87.451  1.00 71.97           C  
ATOM     72  C   THR    10      50.982  40.874  88.183  1.00 71.19           C  
ATOM     73  O   THR    10      51.018  42.083  87.945  1.00 70.11           O  
ATOM     74  CB  THR    10      51.312  39.235  86.168  1.00 71.23           C  
ATOM     75  OG1 THR    10      51.643  40.001  85.000  1.00 69.88           O  
ATOM     76  CG2 THR    10      49.812  39.128  86.308  1.00 71.51           C  
ATOM     77  N   ILE    11      50.161  40.336  89.093  1.00 70.44           N  
ATOM     78  CA  ILE    11      49.219  41.124  89.904  1.00 69.72           C  
ATOM     79  C   ILE    11      50.035  42.057  90.766  1.00 71.16           C  
ATOM     80  O   ILE    11      49.551  43.080  91.257  1.00 71.13           O  
ATOM     81  CB  ILE    11      48.388  40.242  90.871  1.00 68.77           C  
ATOM     82  CG1 ILE    11      47.388  39.417  90.081  1.00 67.51           C  
ATOM     83  CG2 ILE    11      47.668  41.108  91.920  1.00 66.60           C  
ATOM     84  CD1 ILE    11      46.560  38.495  90.938  1.00 66.89           C  
ATOM     85  N   THR    12      51.283  41.681  90.970  1.00 72.51           N  
ATOM     86  CA  THR    12      52.155  42.500  91.759  1.00 73.91           C  
ATOM     87  C   THR    12      52.815  43.476  90.813  1.00 74.94           C  
ATOM     88  O   THR    12      53.055  44.622  91.173  1.00 75.82           O  
ATOM     89  CB  THR    12      53.201  41.642  92.473  1.00 75.30           C  
ATOM     90  OG1 THR    12      52.538  40.717  93.350  1.00 75.75           O  
ATOM     91  CG2 THR    12      54.145  42.526  93.284  1.00 76.45           C  
ATOM     92  N   PHE    13      53.071  43.034  89.586  1.00 75.86           N  
ATOM     93  CA  PHE    13      53.711  43.899  88.592  1.00 77.87           C  
ATOM     94  C   PHE    13      52.903  45.169  88.303  1.00 79.87           C  
ATOM     95  O   PHE    13      53.467  46.265  88.185  1.00 80.16           O  
ATOM     96  CB  PHE    13      53.940  43.127  87.291  1.00 76.60           C  
ATOM     97  CG  PHE    13      54.523  43.959  86.180  1.00 75.56           C  
ATOM     98  CD1 PHE    13      53.743  44.325  85.086  1.00 75.53           C  
ATOM     99  CD2 PHE    13      55.856  44.359  86.216  1.00 74.71           C  
ATOM    100  CE1 PHE    13      54.279  45.077  84.036  1.00 73.94           C  
ATOM    101  CE2 PHE    13      56.403  45.111  85.172  1.00 73.82           C  
ATOM    102  CZ  PHE    13      55.608  45.468  84.079  1.00 73.79           C  
ATOM    103  N   VAL    14      51.587  45.018  88.190  1.00 80.78           N  
ATOM    104  CA  VAL    14      50.717  46.147  87.927  1.00 81.21           C  
ATOM    105  C   VAL    14      50.497  46.914  89.220  1.00 83.76           C  
ATOM    106  O   VAL    14      50.582  48.134  89.241  1.00 85.04           O  
ATOM    107  CB  VAL    14      49.372  45.672  87.361  1.00 79.40           C  
ATOM    108  CG1 VAL    14      48.451  46.851  87.134  1.00 78.11           C  
ATOM    109  CG2 VAL    14      49.604  44.926  86.069  1.00 78.07           C  
ATOM    110  N   LYS    15      50.238  46.195  90.305  1.00 86.53           N  
ATOM    111  CA  LYS    15      50.010  46.838  91.594  1.00 89.42           C  
ATOM    112  C   LYS    15      51.136  47.797  91.974  1.00 92.04           C  
ATOM    113  O   LYS    15      50.909  48.804  92.650  1.00 91.87           O  
ATOM    114  CB  LYS    15      49.840  45.780  92.686  1.00 88.26           C  
ATOM    115  CG  LYS    15      48.424  45.229  92.793  1.00 87.49           C  
ATOM    116  CD  LYS    15      47.453  46.298  93.274  1.00 87.53           C  
ATOM    117  CE  LYS    15      46.640  45.797  94.462  1.00 87.66           C  
ATOM    118  NZ  LYS    15      45.830  46.861  95.134  1.00 86.79           N  
ATOM    119  N   HIS    16      52.344  47.486  91.518  1.00 95.20           N  
ATOM    120  CA  HIS    16      53.515  48.301  91.808  1.00 98.70           C  
ATOM    121  C   HIS    16      53.665  49.487  90.861  1.00 99.11           C  
ATOM    122  O   HIS    16      53.684  50.642  91.292  1.00 99.40           O  
ATOM    123  CB  HIS    16      54.783  47.437  91.756  1.00101.86           C  
ATOM    124  CG  HIS    16      55.481  47.306  93.076  1.00105.49           C  
ATOM    125  ND1 HIS    16      54.917  46.664  94.161  1.00106.97           N  
ATOM    126  CD2 HIS    16      56.685  47.762  93.496  1.00106.64           C  
ATOM    127  CE1 HIS    16      55.743  46.731  95.190  1.00107.92           C  
ATOM    128  NE2 HIS    16      56.824  47.394  94.814  1.00107.88           N  
ATOM    129  N   ILE    17      53.778  49.202  89.569  1.00 99.51           N  
ATOM    130  CA  ILE    17      53.945  50.257  88.577  1.00100.14           C  
ATOM    131  C   ILE    17      52.919  51.375  88.778  1.00100.65           C  
ATOM    132  O   ILE    17      53.162  52.521  88.400  1.00101.20           O  
ATOM    133  CB  ILE    17      53.827  49.695  87.139  1.00 99.75           C  
ATOM    134  CG1 ILE    17      54.322  50.731  86.138  1.00 99.34           C  
ATOM    135  CG2 ILE    17      52.386  49.319  86.835  1.00 99.68           C  
ATOM    136  CD1 ILE    17      55.770  51.105  86.326  1.00 99.26           C  
ATOM    137  N   LEU    18      51.780  51.040  89.380  1.00101.00           N  
ATOM    138  CA  LEU    18      50.732  52.024  89.637  1.00100.89           C  
ATOM    139  C   LEU    18      51.122  52.918  90.806  1.00101.50           C  
ATOM    140  O   LEU    18      50.451  53.906  91.094  1.00102.48           O  
ATOM    141  CB  LEU    18      49.396  51.330  89.947  1.00 99.29           C  
ATOM    142  CG  LEU    18      48.439  50.949  88.809  1.00 97.40           C  
ATOM    143  CD1 LEU    18      47.333  50.051  89.330  1.00 96.41           C  
ATOM    144  CD2 LEU    18      47.845  52.200  88.206  1.00 96.79           C  
ATOM    145  N   GLU    19      52.203  52.573  91.489  1.00101.98           N  
ATOM    146  CA  GLU    19      52.628  53.378  92.618  1.00103.29           C  
ATOM    147  C   GLU    19      53.678  54.398  92.190  1.00104.06           C  
ATOM    148  O   GLU    19      53.668  55.543  92.653  1.00104.54           O  
ATOM    149  CB  GLU    19      53.181  52.488  93.722  1.00103.20           C  
ATOM    150  CG  GLU    19      53.522  53.232  94.990  1.00103.43           C  
ATOM    151  CD  GLU    19      54.278  52.362  95.961  1.00104.06           C  
ATOM    152  OE1 GLU    19      55.462  52.057  95.693  1.00103.95           O  
ATOM    153  OE2 GLU    19      53.684  51.973  96.987  1.00104.64           O  
ATOM    154  N   LYS    20      54.579  53.988  91.300  1.00104.46           N  
ATOM    155  CA  LYS    20      55.623  54.888  90.812  1.00104.68           C  
ATOM    156  C   LYS    20      55.049  56.070  90.029  1.00104.66           C  
ATOM    157  O   LYS    20      55.796  56.822  89.401  1.00104.93           O  
ATOM    158  CB  LYS    20      56.616  54.142  89.910  1.00104.64           C  
ATOM    159  CG  LYS    20      57.659  53.292  90.629  1.00105.42           C  
ATOM    160  CD  LYS    20      57.151  51.896  90.962  1.00105.46           C  
ATOM    161  CE  LYS    20      58.321  50.946  91.197  1.00105.42           C  
ATOM    162  NZ  LYS    20      57.901  49.517  91.263  1.00104.88           N  
ATOM    163  N   ASP    21      53.731  56.236  90.059  1.00104.17           N  
ATOM    164  CA  ASP    21      53.103  57.338  89.337  1.00104.08           C  
ATOM    165  C   ASP    21      51.638  57.467  89.721  1.00102.94           C  
ATOM    166  O   ASP    21      51.298  57.504  90.908  1.00102.07           O  
ATOM    167  CB  ASP    21      53.222  57.118  87.817  1.00105.75           C  
ATOM    168  CG  ASP    21      52.880  58.371  87.003  1.00107.30           C  
ATOM    169  OD1 ASP    21      52.908  58.292  85.751  1.00108.74           O  
ATOM    170  OD2 ASP    21      52.592  59.431  87.609  1.00106.97           O  
ATOM    171  N   ALA    22      50.789  57.527  88.695  1.00101.55           N  
ATOM    172  CA  ALA    22      49.342  57.663  88.831  1.00 99.78           C  
ATOM    173  C   ALA    22      48.850  57.483  90.258  1.00 98.72           C  
ATOM    174  O   ALA    22      48.964  58.387  91.095  1.00 97.73           O  
ATOM    175  CB  ALA    22      48.637  56.669  87.906  1.00 98.99           C  
ATOM    176  N   SER    23      48.305  56.304  90.526  1.00 97.73           N  
ATOM    177  CA  SER    23      47.781  55.983  91.844  1.00 96.67           C  
ATOM    178  C   SER    23      47.405  54.521  91.962  1.00 93.94           C  
ATOM    179  O   SER    23      46.808  53.941  91.052  1.00 93.15           O  
ATOM    180  CB  SER    23      46.544  56.831  92.150  1.00 98.93           C  
ATOM    181  OG  SER    23      45.855  56.317  93.279  1.00101.01           O  
ATOM    182  N   GLY    24      47.747  53.934  93.100  1.00 91.17           N  
ATOM    183  CA  GLY    24      47.416  52.547  93.324  1.00 88.31           C  
ATOM    184  C   GLY    24      45.926  52.425  93.538  1.00 85.81           C  
ATOM    185  O   GLY    24      45.453  51.472  94.161  1.00 85.71           O  
ATOM    186  N   HIS    25      45.175  53.395  93.032  1.00 83.24           N  
ATOM    187  CA  HIS    25      43.738  53.342  93.195  1.00 81.98           C  
ATOM    188  C   HIS    25      43.058  52.852  91.917  1.00 80.44           C  
ATOM    189  O   HIS    25      41.926  52.355  91.961  1.00 79.67           O  
ATOM    190  CB  HIS    25      43.201  54.706  93.633  1.00 83.23           C  
ATOM    191  CG  HIS    25      41.775  54.670  94.088  1.00 84.88           C  
ATOM    192  ND1 HIS    25      41.314  53.769  95.025  1.00 85.42           N  
ATOM    193  CD2 HIS    25      40.702  55.406  93.714  1.00 84.94           C  
ATOM    194  CE1 HIS    25      40.018  53.948  95.204  1.00 85.70           C  
ATOM    195  NE2 HIS    25      39.622  54.935  94.420  1.00 85.98           N  
ATOM    196  N   ASP    26      43.757  52.958  90.784  1.00 79.12           N  
ATOM    197  CA  ASP    26      43.212  52.475  89.503  1.00 77.77           C  
ATOM    198  C   ASP    26      43.214  50.945  89.471  1.00 76.08           C  
ATOM    199  O   ASP    26      42.777  50.341  88.491  1.00 75.82           O  
ATOM    200  CB  ASP    26      44.034  52.977  88.307  1.00 77.40           C  
ATOM    201  CG  ASP    26      43.863  54.456  88.058  1.00 77.10           C  
ATOM    202  OD1 ASP    26      42.700  54.928  87.991  1.00 76.65           O  
ATOM    203  OD2 ASP    26      44.898  55.146  87.912  1.00 75.69           O  
ATOM    204  N   TRP    27      43.728  50.333  90.537  1.00 73.47           N  
ATOM    205  CA  TRP    27      43.779  48.888  90.635  1.00 70.85           C  
ATOM    206  C   TRP    27      42.388  48.305  90.787  1.00 68.98           C  
ATOM    207  O   TRP    27      42.028  47.349  90.096  1.00 70.15           O  
ATOM    208  CB  TRP    27      44.649  48.432  91.817  1.00 71.69           C  
ATOM    209  CG  TRP    27      44.241  47.064  92.346  1.00 73.38           C  
ATOM    210  CD1 TRP    27      43.473  46.804  93.458  1.00 74.39           C  
ATOM    211  CD2 TRP    27      44.455  45.796  91.714  1.00 73.53           C  
ATOM    212  NE1 TRP    27      43.191  45.462  93.549  1.00 73.85           N  
ATOM    213  CE2 TRP    27      43.783  44.819  92.494  1.00 74.77           C  
ATOM    214  CE3 TRP    27      45.143  45.388  90.567  1.00 72.74           C  
ATOM    215  CZ2 TRP    27      43.781  43.459  92.155  1.00 75.30           C  
ATOM    216  CZ3 TRP    27      45.139  44.037  90.231  1.00 74.15           C  
ATOM    217  CH2 TRP    27      44.463  43.089  91.024  1.00 74.79           C  
ATOM    218  N   TYR    28      41.596  48.873  91.687  1.00 65.51           N  
ATOM    219  CA  TYR    28      40.252  48.347  91.912  1.00 62.28           C  
ATOM    220  C   TYR    28      39.476  48.235  90.598  1.00 58.54           C  
ATOM    221  O   TYR    28      38.558  47.439  90.498  1.00 56.72           O  
ATOM    222  CB  TYR    28      39.515  49.208  92.951  1.00 64.73           C  
ATOM    223  CG  TYR    28      40.224  49.245  94.303  1.00 67.03           C  
ATOM    224  CD1 TYR    28      41.480  49.853  94.444  1.00 68.58           C  
ATOM    225  CD2 TYR    28      39.659  48.637  95.433  1.00 67.35           C  
ATOM    226  CE1 TYR    28      42.156  49.849  95.674  1.00 69.21           C  
ATOM    227  CE2 TYR    28      40.326  48.632  96.666  1.00 67.81           C  
ATOM    228  CZ  TYR    28      41.570  49.238  96.774  1.00 68.84           C  
ATOM    229  OH  TYR    28      42.228  49.226  97.980  1.00 70.91           O  
ATOM    230  N   HIS    29      39.866  49.016  89.593  1.00 55.40           N  
ATOM    231  CA  HIS    29      39.227  48.949  88.287  1.00 53.42           C  
ATOM    232  C   HIS    29      39.777  47.765  87.513  1.00 51.44           C  
ATOM    233  O   HIS    29      39.034  47.009  86.902  1.00 49.77           O  
ATOM    234  CB  HIS    29      39.485  50.221  87.475  1.00 55.32           C  
ATOM    235  CG  HIS    29      39.470  50.003  85.984  1.00 56.65           C  
ATOM    236  ND1 HIS    29      38.372  49.514  85.306  1.00 57.67           N  
ATOM    237  CD2 HIS    29      40.417  50.231  85.041  1.00 56.45           C  
ATOM    238  CE1 HIS    29      38.640  49.456  84.010  1.00 56.41           C  
ATOM    239  NE2 HIS    29      39.874  49.886  83.823  1.00 56.73           N  
ATOM    240  N   ILE    30      41.101  47.649  87.518  1.00 51.15           N  
ATOM    241  CA  ILE    30      41.801  46.572  86.828  1.00 51.20           C  
ATOM    242  C   ILE    30      41.229  45.238  87.300  1.00 53.62           C  
ATOM    243  O   ILE    30      40.860  44.378  86.488  1.00 53.68           O  
ATOM    244  CB  ILE    30      43.324  46.517  87.154  1.00 48.66           C  
ATOM    245  CG1 ILE    30      43.969  47.897  87.045  1.00 44.66           C  
ATOM    246  CG2 ILE    30      43.995  45.513  86.211  1.00 48.04           C  
ATOM    247  CD1 ILE    30      44.237  48.358  85.653  1.00 43.24           C  
ATOM    248  N   ARG    31      41.175  45.061  88.622  1.00 54.08           N  
ATOM    249  CA  ARG    31      40.676  43.817  89.194  1.00 54.15           C  
ATOM    250  C   ARG    31      39.234  43.543  88.788  1.00 52.06           C  
ATOM    251  O   ARG    31      38.924  42.494  88.229  1.00 51.50           O  
ATOM    252  CB  ARG    31      40.805  43.823  90.725  1.00 56.17           C  
ATOM    253  CG  ARG    31      40.390  42.491  91.340  1.00 60.09           C  
ATOM    254  CD  ARG    31      40.510  42.471  92.856  1.00 63.32           C  
ATOM    255  NE  ARG    31      39.691  43.495  93.505  1.00 65.45           N  
ATOM    256  CZ  ARG    31      39.502  43.561  94.823  1.00 66.81           C  
ATOM    257  NH1 ARG    31      40.069  42.659  95.621  1.00 66.56           N  
ATOM    258  NH2 ARG    31      38.759  44.528  95.351  1.00 65.71           N  
ATOM    259  N   ARG    32      38.358  44.492  89.071  1.00 51.28           N  
ATOM    260  CA  ARG    32      36.951  44.360  88.729  1.00 50.62           C  
ATOM    261  C   ARG    32      36.765  43.820  87.312  1.00 51.83           C  
ATOM    262  O   ARG    32      35.852  43.041  87.057  1.00 51.50           O  
ATOM    263  CB  ARG    32      36.276  45.712  88.846  1.00 48.27           C  
ATOM    264  CG  ARG    32      35.011  45.680  89.608  1.00 46.09           C  
ATOM    265  CD  ARG    32      34.328  47.014  89.485  1.00 47.69           C  
ATOM    266  NE  ARG    32      35.049  48.077  90.169  1.00 47.67           N  
ATOM    267  CZ  ARG    32      35.808  48.993  89.578  1.00 47.94           C  
ATOM    268  NH1 ARG    32      36.414  49.916  90.319  1.00 47.18           N  
ATOM    269  NH2 ARG    32      35.957  48.996  88.259  1.00 49.59           N  
ATOM    270  N   VAL    33      37.632  44.239  86.394  1.00 53.39           N  
ATOM    271  CA  VAL    33      37.567  43.781  85.003  1.00 54.19           C  
ATOM    272  C   VAL    33      38.111  42.351  84.934  1.00 55.41           C  
ATOM    273  O   VAL    33      37.501  41.474  84.322  1.00 54.30           O  
ATOM    274  CB  VAL    33      38.413  44.687  84.050  1.00 53.90           C  
ATOM    275  CG1 VAL    33      38.346  44.162  82.624  1.00 51.59           C  
ATOM    276  CG2 VAL    33      37.901  46.114  84.100  1.00 53.88           C  
ATOM    277  N   HIS    34      39.264  42.135  85.572  1.00 56.32           N  
ATOM    278  CA  HIS    34      39.923  40.826  85.620  1.00 55.84           C  
ATOM    279  C   HIS    34      38.996  39.755  86.217  1.00 56.94           C  
ATOM    280  O   HIS    34      38.687  38.754  85.561  1.00 56.34           O  
ATOM    281  CB  HIS    34      41.224  40.912  86.439  1.00 54.06           C  
ATOM    282  CG  HIS    34      41.802  39.575  86.794  1.00 52.65           C  
ATOM    283  ND1 HIS    34      41.877  38.535  85.894  1.00 50.77           N  
ATOM    284  CD2 HIS    34      42.330  39.108  87.952  1.00 52.11           C  
ATOM    285  CE1 HIS    34      42.424  37.485  86.480  1.00 50.16           C  
ATOM    286  NE2 HIS    34      42.708  37.805  87.728  1.00 50.45           N  
ATOM    287  N   LYS    35      38.549  39.958  87.455  1.00 56.59           N  
ATOM    288  CA  LYS    35      37.659  38.985  88.065  1.00 55.98           C  
ATOM    289  C   LYS    35      36.457  38.761  87.151  1.00 56.88           C  
ATOM    290  O   LYS    35      35.891  37.674  87.089  1.00 56.33           O  
ATOM    291  CB  LYS    35      37.201  39.472  89.439  1.00 53.59           C  
ATOM    292  CG  LYS    35      38.334  39.690  90.416  1.00 50.94           C  
ATOM    293  CD  LYS    35      37.800  40.159  91.759  1.00 50.35           C  
ATOM    294  CE  LYS    35      37.179  39.030  92.574  1.00 48.14           C  
ATOM    295  NZ  LYS    35      38.181  38.374  93.467  1.00 47.39           N  
ATOM    296  N   MET    36      36.091  39.803  86.424  1.00 59.10           N  
ATOM    297  CA  MET    36      34.960  39.753  85.511  1.00 62.62           C  
ATOM    298  C   MET    36      35.278  38.960  84.233  1.00 61.88           C  
ATOM    299  O   MET    36      34.404  38.286  83.671  1.00 62.26           O  
ATOM    300  CB  MET    36      34.539  41.187  85.171  1.00 67.04           C  
ATOM    301  CG  MET    36      33.169  41.333  84.535  1.00 72.36           C  
ATOM    302  SD  MET    36      32.234  42.926  85.147  1.00 81.64          SE  
ATOM    303  CE  MET    36      33.734  44.163  85.380  1.00 77.97           C  
ATOM    304  N   ALA    37      36.527  39.046  83.780  1.00 60.52           N  
ATOM    305  CA  ALA    37      36.968  38.332  82.585  1.00 58.25           C  
ATOM    306  C   ALA    37      37.003  36.852  82.909  1.00 56.97           C  
ATOM    307  O   ALA    37      36.825  36.009  82.026  1.00 55.56           O  
ATOM    308  CB  ALA    37      38.343  38.805  82.164  1.00 59.39           C  
ATOM    309  N   ILE    38      37.249  36.540  84.179  1.00 55.28           N  
ATOM    310  CA  ILE    38      37.252  35.153  84.601  1.00 54.56           C  
ATOM    311  C   ILE    38      35.823  34.652  84.444  1.00 55.34           C  
ATOM    312  O   ILE    38      35.507  33.926  83.510  1.00 55.56           O  
ATOM    313  CB  ILE    38      37.623  34.976  86.078  1.00 53.58           C  
ATOM    314  CG1 ILE    38      39.065  35.405  86.320  1.00 52.95           C  
ATOM    315  CG2 ILE    38      37.404  33.521  86.479  1.00 52.78           C  
ATOM    316  CD1 ILE    38      40.072  34.576  85.600  1.00 52.24           C  
ATOM    317  N   SER    39      34.959  35.068  85.359  1.00 55.32           N  
ATOM    318  CA  SER    39      33.573  34.645  85.344  1.00 56.07           C  
ATOM    319  C   SER    39      32.968  34.566  83.957  1.00 56.48           C  
ATOM    320  O   SER    39      32.089  33.741  83.699  1.00 55.65           O  
ATOM    321  CB  SER    39      32.749  35.572  86.226  1.00 56.50           C  
ATOM    322  OG  SER    39      33.229  35.508  87.550  1.00 59.84           O  
ATOM    323  N   LEU    40      33.451  35.419  83.064  1.00 57.31           N  
ATOM    324  CA  LEU    40      32.960  35.450  81.693  1.00 59.67           C  
ATOM    325  C   LEU    40      33.495  34.249  80.879  1.00 61.86           C  
ATOM    326  O   LEU    40      32.736  33.576  80.169  1.00 61.73           O  
ATOM    327  CB  LEU    40      33.367  36.778  81.046  1.00 59.16           C  
ATOM    328  CG  LEU    40      32.337  37.625  80.294  1.00 58.09           C  
ATOM    329  CD1 LEU    40      31.103  37.876  81.142  1.00 57.41           C  
ATOM    330  CD2 LEU    40      32.994  38.935  79.902  1.00 55.70           C  
ATOM    331  N   SER    41      34.795  33.970  80.996  1.00 63.41           N  
ATOM    332  CA  SER    41      35.410  32.847  80.270  1.00 63.60           C  
ATOM    333  C   SER    41      34.805  31.530  80.710  1.00 63.06           C  
ATOM    334  O   SER    41      34.439  30.702  79.880  1.00 61.82           O  
ATOM    335  CB  SER    41      36.937  32.800  80.500  1.00 64.79           C  
ATOM    336  OG  SER    41      37.285  32.046  81.658  1.00 63.73           O  
ATOM    337  N   GLU    42      34.717  31.354  82.026  1.00 62.63           N  
ATOM    338  CA  GLU    42      34.164  30.141  82.606  1.00 61.99           C  
ATOM    339  C   GLU    42      32.690  30.023  82.279  1.00 60.99           C  
ATOM    340  O   GLU    42      31.904  29.451  83.022  1.00 60.52           O  
ATOM    341  CB  GLU    42      34.377  30.105  84.125  1.00 62.67           C  
ATOM    342  CG  GLU    42      33.401  30.918  84.953  1.00 62.19           C  
ATOM    343  CD  GLU    42      33.918  31.142  86.361  1.00 62.74           C  
ATOM    344  OE1 GLU    42      33.116  31.508  87.246  1.00 62.64           O  
ATOM    345  OE2 GLU    42      35.140  30.973  86.577  1.00 62.23           O  
ATOM    346  N   GLN    43      32.310  30.580  81.150  1.00 59.93           N  
ATOM    347  CA  GLN    43      30.945  30.468  80.745  1.00 58.67           C  
ATOM    348  C   GLN    43      30.904  30.640  79.257  1.00 58.36           C  
ATOM    349  O   GLN    43      29.860  30.480  78.632  1.00 58.42           O  
ATOM    350  CB  GLN    43      30.096  31.522  81.412  1.00 59.96           C  
ATOM    351  CG  GLN    43      28.648  31.260  81.180  1.00 61.85           C  
ATOM    352  CD  GLN    43      27.815  31.788  82.291  1.00 62.80           C  
ATOM    353  OE1 GLN    43      26.603  31.585  82.327  1.00 64.57           O  
ATOM    354  NE2 GLN    43      28.457  32.478  83.223  1.00 62.58           N  
ATOM    355  N   GLU    44      32.062  30.948  78.687  1.00 56.60           N  
ATOM    356  CA  GLU    44      32.157  31.156  77.257  1.00 54.77           C  
ATOM    357  C   GLU    44      33.349  30.476  76.611  1.00 54.02           C  
ATOM    358  O   GLU    44      33.458  30.456  75.389  1.00 51.36           O  
ATOM    359  CB  GLU    44      32.226  32.645  76.963  1.00 56.28           C  
ATOM    360  CG  GLU    44      30.946  33.396  77.190  1.00 55.44           C  
ATOM    361  CD  GLU    44      29.845  32.942  76.270  1.00 58.05           C  
ATOM    362  OE1 GLU    44      30.150  32.492  75.138  1.00 57.77           O  
ATOM    363  OE2 GLU    44      28.665  33.049  76.675  1.00 59.93           O  
ATOM    364  N   GLY    45      34.248  29.937  77.428  1.00 54.00           N  
ATOM    365  CA  GLY    45      35.418  29.268  76.892  1.00 53.58           C  
ATOM    366  C   GLY    45      36.656  30.149  76.854  1.00 53.71           C  
ATOM    367  O   GLY    45      36.869  30.965  77.753  1.00 56.62           O  
ATOM    368  N   GLY    46      37.474  29.975  75.815  1.00 52.13           N  
ATOM    369  CA  GLY    46      38.703  30.742  75.660  1.00 49.24           C  
ATOM    370  C   GLY    46      39.796  30.423  76.673  1.00 48.72           C  
ATOM    371  O   GLY    46      39.519  29.985  77.795  1.00 47.46           O  
ATOM    372  N   ASN    47      41.047  30.672  76.289  1.00 48.16           N  
ATOM    373  CA  ASN    47      42.190  30.399  77.163  1.00 49.52           C  
ATOM    374  C   ASN    47      42.307  31.299  78.387  1.00 50.80           C  
ATOM    375  O   ASN    47      42.789  32.425  78.279  1.00 52.11           O  
ATOM    376  CB  ASN    47      43.494  30.520  76.391  1.00 49.39           C  
ATOM    377  CG  ASN    47      44.687  30.074  77.215  1.00 49.42           C  
ATOM    378  OD1 ASN    47      44.642  30.082  78.450  1.00 45.46           O  
ATOM    379  ND2 ASN    47      45.766  29.682  76.534  1.00 48.99           N  
ATOM    380  N   ARG    48      41.914  30.796  79.553  1.00 51.76           N  
ATOM    381  CA  ARG    48      41.987  31.582  80.780  1.00 51.84           C  
ATOM    382  C   ARG    48      43.284  32.372  80.928  1.00 51.82           C  
ATOM    383  O   ARG    48      43.280  33.595  80.782  1.00 51.81           O  
ATOM    384  CB  ARG    48      41.780  30.683  81.992  1.00 53.07           C  
ATOM    385  CG  ARG    48      40.309  30.400  82.278  1.00 57.10           C  
ATOM    386  CD  ARG    48      39.735  31.481  83.181  1.00 59.98           C  
ATOM    387  NE  ARG    48      40.602  31.683  84.348  1.00 61.76           N  
ATOM    388  CZ  ARG    48      40.326  31.286  85.589  1.00 60.86           C  
ATOM    389  NH1 ARG    48      39.184  30.661  85.857  1.00 59.67           N  
ATOM    390  NH2 ARG    48      41.210  31.501  86.559  1.00 59.79           N  
ATOM    391  N   PHE    49      44.394  31.697  81.203  1.00 51.76           N  
ATOM    392  CA  PHE    49      45.666  32.408  81.356  1.00 51.74           C  
ATOM    393  C   PHE    49      45.840  33.601  80.425  1.00 51.33           C  
ATOM    394  O   PHE    49      46.225  34.681  80.862  1.00 52.80           O  
ATOM    395  CB  PHE    49      46.830  31.481  81.111  1.00 51.48           C  
ATOM    396  CG  PHE    49      48.155  32.118  81.341  1.00 52.07           C  
ATOM    397  CD1 PHE    49      49.094  32.186  80.318  1.00 52.10           C  
ATOM    398  CD2 PHE    49      48.514  32.550  82.618  1.00 52.69           C  
ATOM    399  CE1 PHE    49      50.389  32.664  80.565  1.00 53.59           C  
ATOM    400  CE2 PHE    49      49.806  33.028  82.877  1.00 53.77           C  
ATOM    401  CZ  PHE    49      50.751  33.084  81.847  1.00 52.32           C  
ATOM    402  N   ILE    50      45.588  33.406  79.137  1.00 50.70           N  
ATOM    403  CA  ILE    50      45.739  34.514  78.214  1.00 50.46           C  
ATOM    404  C   ILE    50      44.749  35.584  78.623  1.00 49.83           C  
ATOM    405  O   ILE    50      45.142  36.714  78.886  1.00 51.30           O  
ATOM    406  CB  ILE    50      45.510  34.097  76.725  1.00 49.38           C  
ATOM    407  CG1 ILE    50      46.774  33.430  76.170  1.00 48.19           C  
ATOM    408  CG2 ILE    50      45.234  35.319  75.874  1.00 48.93           C  
ATOM    409  CD1 ILE    50      46.609  32.873  74.783  1.00 47.73           C  
ATOM    410  N   ILE    51      43.472  35.227  78.705  1.00 49.94           N  
ATOM    411  CA  ILE    51      42.448  36.195  79.082  1.00 50.81           C  
ATOM    412  C   ILE    51      42.883  36.992  80.317  1.00 53.81           C  
ATOM    413  O   ILE    51      42.873  38.229  80.291  1.00 55.26           O  
ATOM    414  CB  ILE    51      41.099  35.505  79.356  1.00 46.63           C  
ATOM    415  CG1 ILE    51      40.559  34.913  78.061  1.00 45.05           C  
ATOM    416  CG2 ILE    51      40.102  36.504  79.899  1.00 45.01           C  
ATOM    417  CD1 ILE    51      39.285  34.109  78.227  1.00 44.42           C  
ATOM    418  N   GLU    52      43.285  36.292  81.381  1.00 55.37           N  
ATOM    419  CA  GLU    52      43.718  36.952  82.608  1.00 57.49           C  
ATOM    420  C   GLU    52      44.933  37.841  82.408  1.00 58.45           C  
ATOM    421  O   GLU    52      44.906  39.026  82.735  1.00 59.10           O  
ATOM    422  CB  GLU    52      44.043  35.928  83.683  1.00 56.94           C  
ATOM    423  CG  GLU    52      42.875  35.139  84.137  1.00 58.84           C  
ATOM    424  CD  GLU    52      43.189  34.348  85.379  1.00 62.43           C  
ATOM    425  OE1 GLU    52      43.505  34.968  86.416  1.00 63.83           O  
ATOM    426  OE2 GLU    52      43.125  33.102  85.326  1.00 66.05           O  
ATOM    427  N   MET    53      46.008  37.267  81.887  1.00 60.12           N  
ATOM    428  CA  MET    53      47.213  38.051  81.661  1.00 63.39           C  
ATOM    429  C   MET    53      46.903  39.291  80.832  1.00 62.71           C  
ATOM    430  O   MET    53      47.500  40.356  81.037  1.00 62.91           O  
ATOM    431  CB  MET    53      48.274  37.225  80.941  1.00 67.12           C  
ATOM    432  CG  MET    53      48.942  36.210  81.823  1.00 73.08           C  
ATOM    433  SD  MET    53      49.749  37.059  83.358  1.00 83.60          SE  
ATOM    434  CE  MET    53      51.366  37.718  82.523  1.00 78.14           C  
ATOM    435  N   ALA    54      45.966  39.159  79.898  1.00 59.46           N  
ATOM    436  CA  ALA    54      45.625  40.288  79.052  1.00 57.21           C  
ATOM    437  C   ALA    54      44.861  41.346  79.830  1.00 55.89           C  
ATOM    438  O   ALA    54      45.317  42.490  79.935  1.00 57.33           O  
ATOM    439  CB  ALA    54      44.826  39.827  77.849  1.00 55.59           C  
ATOM    440  N   ALA    55      43.717  40.971  80.393  1.00 53.22           N  
ATOM    441  CA  ALA    55      42.894  41.910  81.150  1.00 50.69           C  
ATOM    442  C   ALA    55      43.701  42.646  82.206  1.00 50.15           C  
ATOM    443  O   ALA    55      43.427  43.796  82.508  1.00 48.41           O  
ATOM    444  CB  ALA    55      41.761  41.166  81.808  1.00 50.25           C  
ATOM    445  N   LEU    56      44.704  41.966  82.750  1.00 51.07           N  
ATOM    446  CA  LEU    56      45.559  42.507  83.792  1.00 51.70           C  
ATOM    447  C   LEU    56      46.627  43.484  83.326  1.00 54.01           C  
ATOM    448  O   LEU    56      47.231  44.160  84.155  1.00 54.43           O  
ATOM    449  CB  LEU    56      46.251  41.361  84.522  1.00 51.37           C  
ATOM    450  CG  LEU    56      45.783  40.934  85.917  1.00 51.81           C  
ATOM    451  CD1 LEU    56      45.348  39.469  85.913  1.00 51.25           C  
ATOM    452  CD2 LEU    56      46.937  41.137  86.898  1.00 50.58           C  
ATOM    453  N   LEU    57      46.873  43.574  82.020  1.00 55.71           N  
ATOM    454  CA  LEU    57      47.917  44.475  81.533  1.00 56.87           C  
ATOM    455  C   LEU    57      47.495  45.454  80.427  1.00 58.78           C  
ATOM    456  O   LEU    57      48.340  46.209  79.916  1.00 59.98           O  
ATOM    457  CB  LEU    57      49.135  43.645  81.079  1.00 56.76           C  
ATOM    458  CG  LEU    57      49.916  42.822  82.129  1.00 55.77           C  
ATOM    459  CD1 LEU    57      50.878  41.866  81.443  1.00 53.44           C  
ATOM    460  CD2 LEU    57      50.678  43.748  83.061  1.00 54.51           C  
ATOM    461  N   HIS    58      46.205  45.453  80.068  1.00 58.11           N  
ATOM    462  CA  HIS    58      45.678  46.352  79.023  1.00 57.60           C  
ATOM    463  C   HIS    58      45.853  47.808  79.420  1.00 56.70           C  
ATOM    464  O   HIS    58      46.028  48.694  78.582  1.00 55.98           O  
ATOM    465  CB  HIS    58      44.177  46.059  78.735  1.00 59.89           C  
ATOM    466  CG  HIS    58      43.226  46.445  79.840  1.00 64.46           C  
ATOM    467  ND1 HIS    58      43.357  46.003  81.143  1.00 66.22           N  
ATOM    468  CD2 HIS    58      42.085  47.181  79.815  1.00 66.37           C  
ATOM    469  CE1 HIS    58      42.343  46.447  81.868  1.00 65.24           C  
ATOM    470  NE2 HIS    58      41.556  47.163  81.086  1.00 66.11           N  
ATOM    471  N   ASP    59      45.824  48.028  80.724  1.00 55.66           N  
ATOM    472  CA  ASP    59      45.957  49.347  81.281  1.00 55.23           C  
ATOM    473  C   ASP    59      47.392  49.828  81.412  1.00 56.41           C  
ATOM    474  O   ASP    59      47.644  51.029  81.398  1.00 57.70           O  
ATOM    475  CB  ASP    59      45.263  49.386  82.638  1.00 54.64           C  
ATOM    476  CG  ASP    59      43.826  49.855  82.541  1.00 53.95           C  
ATOM    477  OD1 ASP    59      43.117  49.453  81.599  1.00 53.61           O  
ATOM    478  OD2 ASP    59      43.402  50.629  83.418  1.00 53.25           O  
ATOM    479  N   VAL    60      48.336  48.903  81.526  1.00 56.48           N  
ATOM    480  CA  VAL    60      49.734  49.276  81.686  1.00 55.99           C  
ATOM    481  C   VAL    60      50.368  49.796  80.405  1.00 57.45           C  
ATOM    482  O   VAL    60      51.435  50.415  80.427  1.00 57.80           O  
ATOM    483  CB  VAL    60      50.530  48.096  82.236  1.00 55.60           C  
ATOM    484  CG1 VAL    60      51.999  48.445  82.352  1.00 55.22           C  
ATOM    485  CG2 VAL    60      49.980  47.742  83.597  1.00 56.62           C  
ATOM    486  N   ALA    61      49.703  49.568  79.284  1.00 58.50           N  
ATOM    487  CA  ALA    61      50.227  50.055  78.023  1.00 60.65           C  
ATOM    488  C   ALA    61      49.501  51.351  77.644  1.00 63.43           C  
ATOM    489  O   ALA    61      50.048  52.195  76.934  1.00 63.87           O  
ATOM    490  CB  ALA    61      50.049  49.001  76.944  1.00 59.87           C  
ATOM    491  N   ASP    62      48.270  51.510  78.128  1.00 66.34           N  
ATOM    492  CA  ASP    62      47.468  52.711  77.854  1.00 66.96           C  
ATOM    493  C   ASP    62      48.321  53.975  77.892  1.00 65.64           C  
ATOM    494  O   ASP    62      48.732  54.471  76.852  1.00 64.05           O  
ATOM    495  CB  ASP    62      46.328  52.818  78.883  1.00 69.44           C  
ATOM    496  CG  ASP    62      45.606  54.165  78.846  1.00 72.14           C  
ATOM    497  OD1 ASP    62      44.950  54.481  77.817  1.00 70.22           O  
ATOM    498  OD2 ASP    62      45.688  54.904  79.865  1.00 73.11           O  
ATOM    499  N   LEU    65      48.350  56.770  79.950  1.00 63.26           N  
ATOM    500  CA  LEU    65      49.183  57.483  80.928  1.00 63.60           C  
ATOM    501  C   LEU    65      50.395  56.636  81.329  1.00 65.48           C  
ATOM    502  O   LEU    65      51.016  56.862  82.375  1.00 67.00           O  
ATOM    503  CB  LEU    65      48.374  57.837  82.200  1.00 61.25           C  
ATOM    504  CG  LEU    65      47.636  56.735  82.996  1.00 58.55           C  
ATOM    505  CD1 LEU    65      47.408  57.162  84.456  1.00 54.02           C  
ATOM    506  CD2 LEU    65      46.304  56.421  82.303  1.00 55.80           C  
ATOM    507  N   ASN    66      50.733  55.656  80.497  1.00 64.41           N  
ATOM    508  CA  ASN    66      51.866  54.777  80.800  1.00 65.42           C  
ATOM    509  C   ASN    66      53.182  55.458  80.452  1.00 65.25           C  
ATOM    510  O   ASN    66      54.152  55.400  81.217  1.00 66.11           O  
ATOM    511  CB  ASN    66      51.759  53.455  80.011  1.00 66.78           C  
ATOM    512  CG  ASN    66      52.116  53.618  78.521  1.00 67.01           C  
ATOM    513  OD1 ASN    66      51.412  54.308  77.774  1.00 67.34           O  
ATOM    514  ND2 ASN    66      53.216  52.990  78.096  1.00 64.00           N  
ATOM    515  N   GLU    67      53.196  56.073  79.272  1.00 64.42           N  
ATOM    516  CA  GLU    67      54.359  56.768  78.752  1.00 66.26           C  
ATOM    517  C   GLU    67      54.011  57.617  77.522  1.00 69.19           C  
ATOM    518  O   GLU    67      53.540  58.753  77.657  1.00 72.69           O  
ATOM    519  CB  GLU    67      55.446  55.770  78.375  1.00 67.01           C  
ATOM    520  CG  GLU    67      56.740  56.445  77.950  1.00 66.48           C  
ATOM    521  CD  GLU    67      57.832  56.281  78.992  1.00 65.04           C  
ATOM    522  OE1 GLU    67      57.622  56.701  80.158  1.00 65.65           O  
ATOM    523  OE2 GLU    67      58.910  55.746  78.640  1.00 64.94           O  
ATOM    524  N   SER    68      54.220  57.072  76.323  1.00 67.68           N  
ATOM    525  CA  SER    68      53.951  57.825  75.088  1.00 67.54           C  
ATOM    526  C   SER    68      53.652  56.898  73.899  1.00 71.84           C  
ATOM    527  O   SER    68      54.564  56.280  73.338  1.00 73.27           O  
ATOM    528  CB  SER    68      55.164  58.707  74.784  1.00 66.29           C  
ATOM    529  OG  SER    68      56.203  58.457  75.730  1.00 58.59           O  
ATOM    530  N   GLU    69      52.375  56.814  73.519  1.00 74.66           N  
ATOM    531  CA  GLU    69      51.937  55.948  72.421  1.00 77.50           C  
ATOM    532  C   GLU    69      52.318  54.458  72.665  1.00 80.84           C  
ATOM    533  O   GLU    69      52.253  53.969  73.795  1.00 79.23           O  
ATOM    534  CB  GLU    69      52.530  56.451  71.087  1.00 78.22           C  
ATOM    535  N   GLU    70      52.715  53.756  71.601  1.00 82.88           N  
ATOM    536  CA  GLU    70      53.096  52.344  71.665  1.00 83.86           C  
ATOM    537  C   GLU    70      54.446  52.143  72.368  1.00 84.49           C  
ATOM    538  O   GLU    70      55.265  51.314  71.962  1.00 82.91           O  
ATOM    539  CB  GLU    70      53.143  51.777  70.239  1.00 86.54           C  
ATOM    540  CG  GLU    70      53.149  50.249  70.127  1.00 91.10           C  
ATOM    541  CD  GLU    70      54.465  49.698  69.604  1.00 93.39           C  
ATOM    542  OE1 GLU    70      54.783  49.948  68.415  1.00 94.80           O  
ATOM    543  OE2 GLU    70      55.179  49.023  70.387  1.00 94.11           O  
ATOM    544  N   ALA    71      54.677  52.916  73.422  1.00 84.48           N  
ATOM    545  CA  ALA    71      55.915  52.811  74.174  1.00 85.35           C  
ATOM    546  C   ALA    71      55.727  51.797  75.298  1.00 87.00           C  
ATOM    547  O   ALA    71      56.696  51.242  75.827  1.00 86.42           O  
ATOM    548  CB  ALA    71      56.284  54.162  74.742  1.00 85.43           C  
ATOM    549  N   GLY    72      54.464  51.558  75.646  1.00 88.72           N  
ATOM    550  CA  GLY    72      54.136  50.614  76.701  1.00 90.58           C  
ATOM    551  C   GLY    72      54.090  49.183  76.206  1.00 91.40           C  
ATOM    552  O   GLY    72      54.205  48.240  76.985  1.00 91.79           O  
ATOM    553  N   MET    73      53.912  49.023  74.902  1.00 92.03           N  
ATOM    554  CA  MET    73      53.868  47.703  74.303  1.00 93.01           C  
ATOM    555  C   MET    73      55.137  46.949  74.672  1.00 91.55           C  
ATOM    556  O   MET    73      55.083  45.833  75.187  1.00 91.24           O  
ATOM    557  CB  MET    73      53.774  47.827  72.790  1.00 97.28           C  
ATOM    558  CG  MET    73      52.728  46.929  72.165  1.00102.19           C  
ATOM    559  SD  MET    73      50.960  47.206  72.919  1.00109.67          SE  
ATOM    560  CE  MET    73      50.901  49.159  72.946  1.00105.49           C  
ATOM    561  N   LYS    74      56.283  47.561  74.397  1.00 89.74           N  
ATOM    562  CA  LYS    74      57.549  46.929  74.721  1.00 88.01           C  
ATOM    563  C   LYS    74      57.703  46.900  76.228  1.00 87.41           C  
ATOM    564  O   LYS    74      58.559  46.197  76.755  1.00 88.23           O  
ATOM    565  CB  LYS    74      58.727  47.684  74.098  1.00 87.71           C  
ATOM    566  CG  LYS    74      60.100  47.062  74.395  1.00 86.29           C  
ATOM    567  CD  LYS    74      60.689  47.527  75.725  1.00 84.77           C  
ATOM    568  CE  LYS    74      62.018  46.846  76.007  1.00 85.01           C  
ATOM    569  NZ  LYS    74      62.982  46.979  74.879  1.00 83.18           N  
ATOM    570  N   LYS    75      56.881  47.671  76.928  1.00 85.82           N  
ATOM    571  CA  LYS    75      56.950  47.683  78.383  1.00 84.29           C  
ATOM    572  C   LYS    75      56.334  46.385  78.901  1.00 84.13           C  
ATOM    573  O   LYS    75      56.806  45.804  79.884  1.00 84.52           O  
ATOM    574  CB  LYS    75      56.204  48.901  78.934  1.00 83.86           C  
ATOM    575  CG  LYS    75      55.928  48.865  80.430  1.00 82.95           C  
ATOM    576  CD  LYS    75      55.774  50.284  81.001  1.00 84.90           C  
ATOM    577  CE  LYS    75      54.739  51.138  80.243  1.00 85.04           C  
ATOM    578  NZ  LYS    75      54.903  52.621  80.465  1.00 83.14           N  
ATOM    579  N   VAL    76      55.281  45.940  78.215  1.00 82.84           N  
ATOM    580  CA  VAL    76      54.563  44.703  78.540  1.00 80.09           C  
ATOM    581  C   VAL    76      55.294  43.546  77.868  1.00 80.15           C  
ATOM    582  O   VAL    76      55.431  42.451  78.423  1.00 78.85           O  
ATOM    583  CB  VAL    76      53.117  44.772  78.012  1.00 79.09           C  
ATOM    584  CG1 VAL    76      52.404  43.439  78.209  1.00 76.50           C  
ATOM    585  CG2 VAL    76      52.378  45.890  78.723  1.00 78.24           C  
ATOM    586  N   SER    77      55.766  43.823  76.661  1.00 80.38           N  
ATOM    587  CA  SER    77      56.513  42.862  75.873  1.00 81.49           C  
ATOM    588  C   SER    77      57.659  42.250  76.676  1.00 82.91           C  
ATOM    589  O   SER    77      57.655  41.050  76.962  1.00 83.81           O  
ATOM    590  CB  SER    77      57.058  43.547  74.619  1.00 80.41           C  
ATOM    591  OG  SER    77      58.246  42.925  74.183  1.00 79.27           O  
ATOM    592  N   ASP    78      58.634  43.079  77.043  1.00 84.30           N  
ATOM    593  CA  ASP    78      59.801  42.623  77.809  1.00 84.85           C  
ATOM    594  C   ASP    78      59.458  42.063  79.190  1.00 83.83           C  
ATOM    595  O   ASP    78      60.314  41.480  79.857  1.00 84.23           O  
ATOM    596  CB  ASP    78      60.859  43.756  77.933  1.00 85.87           C  
ATOM    597  CG  ASP    78      60.339  45.007  78.661  1.00 86.65           C  
ATOM    598  OD1 ASP    78      61.067  46.029  78.662  1.00 85.97           O  
ATOM    599  OD2 ASP    78      59.222  44.977  79.236  1.00 88.00           O  
ATOM    600  N   TRP    79      58.209  42.238  79.617  1.00 82.60           N  
ATOM    601  CA  TRP    79      57.786  41.726  80.919  1.00 81.42           C  
ATOM    602  C   TRP    79      57.365  40.270  80.794  1.00 81.65           C  
ATOM    603  O   TRP    79      57.804  39.413  81.565  1.00 81.76           O  
ATOM    604  CB  TRP    79      56.614  42.533  81.494  1.00 78.42           C  
ATOM    605  CG  TRP    79      55.969  41.841  82.677  1.00 75.56           C  
ATOM    606  CD1 TRP    79      54.757  41.201  82.696  1.00 74.82           C  
ATOM    607  CD2 TRP    79      56.530  41.668  83.987  1.00 74.54           C  
ATOM    608  NE1 TRP    79      54.531  40.640  83.935  1.00 73.22           N  
ATOM    609  CE2 TRP    79      55.604  40.908  84.744  1.00 73.62           C  
ATOM    610  CE3 TRP    79      57.729  42.075  84.595  1.00 73.64           C  
ATOM    611  CZ2 TRP    79      55.840  40.551  86.076  1.00 73.23           C  
ATOM    612  CZ3 TRP    79      57.961  41.716  85.926  1.00 72.07           C  
ATOM    613  CH2 TRP    79      57.021  40.961  86.645  1.00 72.33           C  
ATOM    614  N   LEU    80      56.502  39.997  79.822  1.00 81.35           N  
ATOM    615  CA  LEU    80      56.031  38.642  79.600  1.00 81.36           C  
ATOM    616  C   LEU    80      57.241  37.718  79.416  1.00 82.75           C  
ATOM    617  O   LEU    80      57.155  36.504  79.627  1.00 83.71           O  
ATOM    618  CB  LEU    80      55.126  38.608  78.372  1.00 78.55           C  
ATOM    619  CG  LEU    80      53.850  39.439  78.489  1.00 76.59           C  
ATOM    620  CD1 LEU    80      53.063  39.292  77.219  1.00 75.59           C  
ATOM    621  CD2 LEU    80      53.016  38.984  79.672  1.00 75.73           C  
ATOM    622  N   GLU    81      58.368  38.314  79.035  1.00 83.30           N  
ATOM    623  CA  GLU    81      59.611  37.592  78.827  1.00 83.18           C  
ATOM    624  C   GLU    81      60.227  37.194  80.150  1.00 83.96           C  
ATOM    625  O   GLU    81      60.591  36.040  80.354  1.00 83.28           O  
ATOM    626  CB  GLU    81      60.582  38.471  78.056  1.00 82.96           C  
ATOM    627  CG  GLU    81      60.260  38.530  76.601  1.00 83.91           C  
ATOM    628  CD  GLU    81      60.479  37.192  75.946  1.00 85.26           C  
ATOM    629  OE1 GLU    81      59.857  36.937  74.897  1.00 86.78           O  
ATOM    630  OE2 GLU    81      61.287  36.395  76.476  1.00 85.66           O  
ATOM    631  N   GLU    82      60.347  38.163  81.047  1.00 86.15           N  
ATOM    632  CA  GLU    82      60.911  37.912  82.360  1.00 89.31           C  
ATOM    633  C   GLU    82      60.109  36.816  83.058  1.00 91.08           C  
ATOM    634  O   GLU    82      60.662  36.018  83.811  1.00 90.62           O  
ATOM    635  CB  GLU    82      60.902  39.204  83.184  1.00 90.62           C  
ATOM    636  CG  GLU    82      61.229  39.021  84.663  1.00 92.96           C  
ATOM    637  CD  GLU    82      61.320  40.345  85.414  1.00 94.03           C  
ATOM    638  OE1 GLU    82      61.342  40.322  86.664  1.00 93.95           O  
ATOM    639  OE2 GLU    82      61.380  41.404  84.751  1.00 94.64           O  
ATOM    640  N   LEU    83      58.806  36.778  82.793  1.00 93.88           N  
ATOM    641  CA  LEU    83      57.914  35.771  83.373  1.00 96.03           C  
ATOM    642  C   LEU    83      57.913  34.522  82.495  1.00 97.28           C  
ATOM    643  O   LEU    83      57.220  33.550  82.785  1.00 97.42           O  
ATOM    644  CB  LEU    83      56.483  36.321  83.482  1.00 96.66           C  
ATOM    645  CG  LEU    83      55.888  36.711  84.846  1.00 97.05           C  
ATOM    646  CD1 LEU    83      55.599  35.465  85.651  1.00 97.35           C  
ATOM    647  CD2 LEU    83      56.836  37.626  85.602  1.00 98.25           C  
ATOM    648  N   HIS    84      58.693  34.565  81.420  1.00 99.41           N  
ATOM    649  CA  HIS    84      58.795  33.446  80.497  1.00101.32           C  
ATOM    650  C   HIS    84      57.437  32.991  80.006  1.00101.97           C  
ATOM    651  O   HIS    84      56.693  32.320  80.717  1.00102.24           O  
ATOM    652  CB  HIS    84      59.510  32.281  81.171  1.00103.74           C  
ATOM    653  CG  HIS    84      60.999  32.337  81.057  1.00106.67           C  
ATOM    654  ND1 HIS    84      61.839  32.019  82.103  1.00107.68           N  
ATOM    655  CD2 HIS    84      61.802  32.627  80.004  1.00107.80           C  
ATOM    656  CE1 HIS    84      63.094  32.107  81.701  1.00108.75           C  
ATOM    657  NE2 HIS    84      63.099  32.474  80.430  1.00109.14           N  
ATOM    658  N   VAL    85      57.117  33.366  78.778  1.00102.41           N  
ATOM    659  CA  VAL    85      55.851  32.991  78.173  1.00103.08           C  
ATOM    660  C   VAL    85      56.083  32.747  76.687  1.00103.80           C  
ATOM    661  O   VAL    85      56.294  33.689  75.927  1.00103.96           O  
ATOM    662  CB  VAL    85      54.799  34.106  78.368  1.00102.69           C  
ATOM    663  CG1 VAL    85      53.555  33.804  77.552  1.00102.21           C  
ATOM    664  CG2 VAL    85      54.442  34.222  79.837  1.00102.22           C  
ATOM    665  N   GLU    86      56.064  31.478  76.288  1.00104.39           N  
ATOM    666  CA  GLU    86      56.275  31.101  74.893  1.00105.44           C  
ATOM    667  C   GLU    86      55.646  32.116  73.959  1.00105.44           C  
ATOM    668  O   GLU    86      54.465  32.437  74.093  1.00106.40           O  
ATOM    669  CB  GLU    86      55.662  29.728  74.605  1.00106.95           C  
ATOM    670  CG  GLU    86      56.591  28.535  74.806  1.00107.43           C  
ATOM    671  CD  GLU    86      55.898  27.201  74.536  1.00107.73           C  
ATOM    672  OE1 GLU    86      55.252  27.052  73.474  1.00107.83           O  
ATOM    673  OE2 GLU    86      56.008  26.295  75.387  1.00108.14           O  
ATOM    674  N   GLU    87      56.432  32.616  73.011  1.00104.19           N  
ATOM    675  CA  GLU    87      55.925  33.590  72.056  1.00103.36           C  
ATOM    676  C   GLU    87      54.598  33.093  71.496  1.00102.82           C  
ATOM    677  O   GLU    87      53.759  33.882  71.068  1.00102.80           O  
ATOM    678  CB  GLU    87      56.909  33.780  70.904  1.00103.37           C  
ATOM    679  CG  GLU    87      56.454  34.829  69.898  1.00103.61           C  
ATOM    680  CD  GLU    87      57.228  34.789  68.595  1.00103.62           C  
ATOM    681  OE1 GLU    87      57.014  35.697  67.760  1.00103.68           O  
ATOM    682  OE2 GLU    87      58.038  33.853  68.403  1.00102.59           O  
ATOM    683  N   GLU    88      54.421  31.775  71.503  1.00101.96           N  
ATOM    684  CA  GLU    88      53.207  31.159  70.989  1.00101.12           C  
ATOM    685  C   GLU    88      51.974  31.695  71.713  1.00100.67           C  
ATOM    686  O   GLU    88      50.877  31.753  71.145  1.00101.54           O  
ATOM    687  CB  GLU    88      53.293  29.638  71.136  1.00100.80           C  
ATOM    688  CG  GLU    88      52.205  28.874  70.398  1.00 99.08           C  
ATOM    689  CD  GLU    88      52.751  27.672  69.648  1.00 98.05           C  
ATOM    690  OE1 GLU    88      53.387  26.802  70.285  1.00 97.31           O  
ATOM    691  OE2 GLU    88      52.535  27.597  68.421  1.00 96.89           O  
ATOM    692  N   GLU    89      52.159  32.094  72.967  1.00 98.71           N  
ATOM    693  CA  GLU    89      51.064  32.636  73.761  1.00 97.39           C  
ATOM    694  C   GLU    89      51.198  34.140  73.932  1.00 95.84           C  
ATOM    695  O   GLU    89      50.231  34.885  73.783  1.00 95.67           O  
ATOM    696  CB  GLU    89      51.022  31.957  75.130  1.00 97.85           C  
ATOM    697  CG  GLU    89      50.325  30.613  75.103  1.00 99.04           C  
ATOM    698  CD  GLU    89      50.149  29.999  76.478  1.00100.11           C  
ATOM    699  OE1 GLU    89      49.444  28.970  76.573  1.00101.59           O  
ATOM    700  OE2 GLU    89      50.717  30.529  77.461  1.00100.07           O  
ATOM    701  N   SER    90      52.414  34.570  74.244  1.00 93.98           N  
ATOM    702  CA  SER    90      52.719  35.974  74.447  1.00 91.31           C  
ATOM    703  C   SER    90      52.270  36.802  73.254  1.00 89.60           C  
ATOM    704  O   SER    90      51.670  37.861  73.401  1.00 88.42           O  
ATOM    705  CB  SER    90      54.220  36.138  74.659  1.00 90.94           C  
ATOM    706  OG  SER    90      54.531  37.471  74.991  1.00 92.54           O  
ATOM    707  N   LYS    91      52.567  36.305  72.066  1.00 88.76           N  
ATOM    708  CA  LYS    91      52.185  36.999  70.847  1.00 89.03           C  
ATOM    709  C   LYS    91      50.673  37.271  70.849  1.00 87.86           C  
ATOM    710  O   LYS    91      50.205  38.220  70.212  1.00 88.17           O  
ATOM    711  CB  LYS    91      52.576  36.150  69.624  1.00 89.63           C  
ATOM    712  CG  LYS    91      52.492  36.854  68.265  1.00 90.92           C  
ATOM    713  CD  LYS    91      53.587  37.910  68.079  1.00 90.23           C  
ATOM    714  CE  LYS    91      53.658  38.338  66.628  1.00 88.60           C  
ATOM    715  NZ  LYS    91      53.807  37.130  65.764  1.00 86.94           N  
ATOM    716  N   HIS    92      49.919  36.448  71.578  1.00 85.83           N  
ATOM    717  CA  HIS    92      48.453  36.571  71.658  1.00 83.02           C  
ATOM    718  C   HIS    92      48.032  37.435  72.824  1.00 81.96           C  
ATOM    719  O   HIS    92      47.025  38.143  72.755  1.00 81.68           O  
ATOM    720  CB  HIS    92      47.817  35.191  71.840  1.00 81.86           C  
ATOM    721  CG  HIS    92      46.321  35.184  71.732  1.00 80.25           C  
ATOM    722  ND1 HIS    92      45.557  34.099  72.113  1.00 79.61           N  
ATOM    723  CD2 HIS    92      45.458  36.100  71.239  1.00 79.93           C  
ATOM    724  CE1 HIS    92      44.286  34.351  71.857  1.00 78.84           C  
ATOM    725  NE2 HIS    92      44.196  35.555  71.325  1.00 80.02           N  
ATOM    726  N   VAL    93      48.798  37.349  73.905  1.00 81.14           N  
ATOM    727  CA  VAL    93      48.507  38.123  75.093  1.00 79.89           C  
ATOM    728  C   VAL    93      48.728  39.585  74.777  1.00 79.26           C  
ATOM    729  O   VAL    93      47.782  40.359  74.726  1.00 79.67           O  
ATOM    730  CB  VAL    93      49.407  37.712  76.278  1.00 79.74           C  
ATOM    731  CG1 VAL    93      49.230  38.699  77.421  1.00 79.38           C  
ATOM    732  CG2 VAL    93      49.063  36.298  76.742  1.00 77.99           C  
ATOM    733  N   LEU    94      49.971  39.969  74.528  1.00 78.44           N  
ATOM    734  CA  LEU    94      50.219  41.369  74.237  1.00 77.24           C  
ATOM    735  C   LEU    94      49.584  41.790  72.924  1.00 76.74           C  
ATOM    736  O   LEU    94      49.775  42.910  72.465  1.00 77.69           O  
ATOM    737  CB  LEU    94      51.716  41.678  74.217  1.00 75.64           C  
ATOM    738  CG  LEU    94      52.472  41.454  72.923  1.00 73.82           C  
ATOM    739  CD1 LEU    94      53.249  42.716  72.621  1.00 73.77           C  
ATOM    740  CD2 LEU    94      53.382  40.244  73.032  1.00 73.03           C  
ATOM    741  N   HIS    95      48.822  40.898  72.315  1.00 76.14           N  
ATOM    742  CA  HIS    95      48.185  41.242  71.060  1.00 75.94           C  
ATOM    743  C   HIS    95      46.935  42.046  71.368  1.00 76.07           C  
ATOM    744  O   HIS    95      46.907  43.256  71.146  1.00 76.24           O  
ATOM    745  CB  HIS    95      47.840  39.973  70.290  1.00 76.81           C  
ATOM    746  CG  HIS    95      47.133  40.217  68.994  1.00 77.40           C  
ATOM    747  ND1 HIS    95      47.681  40.955  67.967  1.00 77.15           N  
ATOM    748  CD2 HIS    95      45.931  39.783  68.545  1.00 78.36           C  
ATOM    749  CE1 HIS    95      46.849  40.963  66.940  1.00 76.73           C  
ATOM    750  NE2 HIS    95      45.780  40.259  67.266  1.00 77.49           N  
ATOM    751  N   ILE    96      45.913  41.385  71.906  1.00 76.13           N  
ATOM    752  CA  ILE    96      44.657  42.062  72.239  1.00 75.31           C  
ATOM    753  C   ILE    96      44.873  43.315  73.095  1.00 74.93           C  
ATOM    754  O   ILE    96      44.071  44.258  73.064  1.00 73.06           O  
ATOM    755  CB  ILE    96      43.658  41.069  72.918  1.00 75.29           C  
ATOM    756  CG1 ILE    96      44.343  40.261  74.013  1.00 74.28           C  
ATOM    757  CG2 ILE    96      43.108  40.102  71.872  1.00 75.72           C  
ATOM    758  CD1 ILE    96      43.480  39.134  74.559  1.00 72.10           C  
ATOM    759  N   ILE    97      45.986  43.319  73.827  1.00 75.18           N  
ATOM    760  CA  ILE    97      46.389  44.434  74.688  1.00 74.43           C  
ATOM    761  C   ILE    97      46.576  45.668  73.806  1.00 75.89           C  
ATOM    762  O   ILE    97      46.797  46.778  74.298  1.00 75.02           O  
ATOM    763  CB  ILE    97      47.732  44.127  75.385  1.00 72.70           C  
ATOM    764  CG1 ILE    97      47.703  44.579  76.831  1.00 70.67           C  
ATOM    765  CG2 ILE    97      48.869  44.845  74.674  1.00 73.04           C  
ATOM    766  CD1 ILE    97      48.921  44.134  77.596  1.00 68.87           C  
ATOM    767  N   ALA    98      46.514  45.457  72.496  1.00 77.45           N  
ATOM    768  CA  ALA    98      46.651  46.552  71.556  1.00 78.57           C  
ATOM    769  C   ALA    98      45.261  47.081  71.291  1.00 79.91           C  
ATOM    770  O   ALA    98      45.035  48.283  71.347  1.00 79.61           O  
ATOM    771  CB  ALA    98      47.285  46.072  70.272  1.00 77.97           C  
ATOM    772  N   ASN    99      44.325  46.173  71.027  1.00 82.07           N  
ATOM    773  CA  ASN    99      42.948  46.565  70.756  1.00 84.96           C  
ATOM    774  C   ASN    99      42.176  46.845  72.037  1.00 87.38           C  
ATOM    775  O   ASN    99      40.989  46.530  72.143  1.00 88.24           O  
ATOM    776  CB  ASN    99      42.228  45.489  69.935  1.00 84.22           C  
ATOM    777  CG  ASN    99      42.836  45.307  68.549  1.00 83.98           C  
ATOM    778  OD1 ASN    99      44.021  44.983  68.415  1.00 83.25           O  
ATOM    779  ND2 ASN    99      42.025  45.513  67.511  1.00 81.06           N  
ATOM    780  N   MET   100      42.862  47.446  73.004  1.00 90.07           N  
ATOM    781  CA  MET   100      42.257  47.791  74.289  1.00 92.39           C  
ATOM    782  C   MET   100      42.343  49.301  74.530  1.00 92.50           C  
ATOM    783  O   MET   100      42.370  49.760  75.676  1.00 92.32           O  
ATOM    784  CB  MET   100      42.967  47.035  75.423  1.00 94.34           C  
ATOM    785  CG  MET   100      42.676  45.532  75.458  1.00 96.06           C  
ATOM    786  SD  MET   100      40.983  45.046  76.295  1.00 99.14          SE  
ATOM    787  CE  MET   100      39.749  45.527  74.858  1.00 97.67           C  
ATOM    788  N   SER   112      38.959  36.828  67.887  1.00 57.10           N  
ATOM    789  CA  SER   112      39.634  36.118  68.979  1.00 59.32           C  
ATOM    790  C   SER   112      38.736  36.002  70.202  1.00 60.76           C  
ATOM    791  O   SER   112      38.458  37.004  70.851  1.00 62.84           O  
ATOM    792  CB  SER   112      40.914  36.850  69.394  1.00 57.29           C  
ATOM    793  OG  SER   112      41.423  36.300  70.601  1.00 54.81           O  
ATOM    794  N   ILE   113      38.304  34.799  70.559  1.00 61.84           N  
ATOM    795  CA  ILE   113      37.421  34.685  71.716  1.00 62.69           C  
ATOM    796  C   ILE   113      38.045  35.210  73.012  1.00 63.64           C  
ATOM    797  O   ILE   113      37.364  35.889  73.786  1.00 63.10           O  
ATOM    798  CB  ILE   113      36.965  33.242  71.943  1.00 63.08           C  
ATOM    799  CG1 ILE   113      36.063  33.196  73.180  1.00 63.17           C  
ATOM    800  CG2 ILE   113      38.181  32.327  72.026  1.00 63.80           C  
ATOM    801  CD1 ILE   113      35.669  31.819  73.639  1.00 62.87           C  
ATOM    802  N   GLU   114      39.324  34.892  73.250  1.00 65.08           N  
ATOM    803  CA  GLU   114      40.043  35.354  74.452  1.00 65.77           C  
ATOM    804  C   GLU   114      39.957  36.873  74.550  1.00 66.36           C  
ATOM    805  O   GLU   114      39.483  37.427  75.541  1.00 65.62           O  
ATOM    806  CB  GLU   114      41.525  34.960  74.401  1.00 65.57           C  
ATOM    807  CG  GLU   114      41.818  33.531  74.807  1.00 66.83           C  
ATOM    808  CD  GLU   114      41.458  32.527  73.735  1.00 68.23           C  
ATOM    809  OE1 GLU   114      41.516  31.311  74.032  1.00 66.45           O  
ATOM    810  OE2 GLU   114      41.129  32.948  72.599  1.00 69.55           O  
ATOM    811  N   GLY   115      40.445  37.545  73.515  1.00 67.29           N  
ATOM    812  CA  GLY   115      40.381  38.986  73.507  1.00 67.99           C  
ATOM    813  C   GLY   115      38.932  39.421  73.621  1.00 68.41           C  
ATOM    814  O   GLY   115      38.577  40.184  74.520  1.00 68.71           O  
ATOM    815  N   LYS   116      38.088  38.928  72.717  1.00 67.73           N  
ATOM    816  CA  LYS   116      36.676  39.295  72.725  1.00 68.55           C  
ATOM    817  C   LYS   116      36.142  39.342  74.152  1.00 67.58           C  
ATOM    818  O   LYS   116      35.397  40.260  74.501  1.00 68.88           O  
ATOM    819  CB  LYS   116      35.850  38.304  71.896  1.00 70.78           C  
ATOM    820  CG  LYS   116      34.942  38.966  70.849  1.00 74.29           C  
ATOM    821  CD  LYS   116      34.999  38.257  69.475  1.00 76.23           C  
ATOM    822  CE  LYS   116      34.254  36.908  69.463  1.00 76.64           C  
ATOM    823  NZ  LYS   116      34.420  36.133  68.187  1.00 74.59           N  
ATOM    824  N   LEU   117      36.529  38.374  74.982  1.00 64.19           N  
ATOM    825  CA  LEU   117      36.051  38.360  76.354  1.00 61.91           C  
ATOM    826  C   LEU   117      36.650  39.489  77.175  1.00 60.71           C  
ATOM    827  O   LEU   117      35.931  40.196  77.880  1.00 61.82           O  
ATOM    828  CB  LEU   117      36.324  37.004  77.025  1.00 61.68           C  
ATOM    829  CG  LEU   117      35.241  35.918  76.889  1.00 59.80           C  
ATOM    830  CD1 LEU   117      35.774  34.582  77.382  1.00 58.70           C  
ATOM    831  CD2 LEU   117      34.014  36.330  77.675  1.00 57.44           C  
ATOM    832  N   VAL   118      37.959  39.680  77.086  1.00 59.23           N  
ATOM    833  CA  VAL   118      38.593  40.756  77.852  1.00 58.13           C  
ATOM    834  C   VAL   118      37.867  42.074  77.558  1.00 56.86           C  
ATOM    835  O   VAL   118      37.543  42.838  78.467  1.00 55.82           O  
ATOM    836  CB  VAL   118      40.100  40.883  77.497  1.00 57.81           C  
ATOM    837  CG1 VAL   118      40.729  42.049  78.244  1.00 54.91           C  
ATOM    838  CG2 VAL   118      40.816  39.593  77.865  1.00 57.70           C  
ATOM    839  N   GLN   119      37.587  42.316  76.282  1.00 56.53           N  
ATOM    840  CA  GLN   119      36.904  43.526  75.888  1.00 55.92           C  
ATOM    841  C   GLN   119      35.482  43.600  76.426  1.00 56.24           C  
ATOM    842  O   GLN   119      34.946  44.678  76.659  1.00 56.85           O  
ATOM    843  CB  GLN   119      36.870  43.658  74.377  1.00 55.08           C  
ATOM    844  CG  GLN   119      36.385  45.025  74.002  1.00 55.59           C  
ATOM    845  CD  GLN   119      36.033  45.149  72.553  1.00 55.03           C  
ATOM    846  OE1 GLN   119      35.347  44.296  71.979  1.00 54.08           O  
ATOM    847  NE2 GLN   119      36.467  46.238  71.952  1.00 55.26           N  
ATOM    848  N   ASP   120      34.854  42.454  76.604  1.00 57.25           N  
ATOM    849  CA  ASP   120      33.502  42.449  77.132  1.00 60.27           C  
ATOM    850  C   ASP   120      33.568  42.669  78.625  1.00 61.61           C  
ATOM    851  O   ASP   120      32.614  43.139  79.248  1.00 62.29           O  
ATOM    852  CB  ASP   120      32.821  41.116  76.853  1.00 61.47           C  
ATOM    853  CG  ASP   120      32.345  40.999  75.430  1.00 61.45           C  
ATOM    854  OD1 ASP   120      32.070  39.857  75.010  1.00 59.82           O  
ATOM    855  OD2 ASP   120      32.236  42.048  74.744  1.00 62.95           O  
ATOM    856  N   ALA   121      34.710  42.315  79.202  1.00 62.86           N  
ATOM    857  CA  ALA   121      34.915  42.460  80.638  1.00 62.04           C  
ATOM    858  C   ALA   121      35.373  43.874  80.992  1.00 61.35           C  
ATOM    859  O   ALA   121      35.353  44.259  82.157  1.00 61.64           O  
ATOM    860  CB  ALA   121      35.945  41.430  81.125  1.00 61.68           C  
ATOM    861  N   ASP   122      35.783  44.646  79.991  1.00 60.20           N  
ATOM    862  CA  ASP   122      36.239  45.997  80.252  1.00 58.88           C  
ATOM    863  C   ASP   122      35.129  47.005  80.018  1.00 58.34           C  
ATOM    864  O   ASP   122      34.922  47.932  80.811  1.00 58.31           O  
ATOM    865  CB  ASP   122      37.441  46.333  79.375  1.00 57.59           C  
ATOM    866  CG  ASP   122      38.015  47.694  79.689  1.00 57.97           C  
ATOM    867  OD1 ASP   122      38.353  47.940  80.871  1.00 57.45           O  
ATOM    868  OD2 ASP   122      38.132  48.515  78.756  1.00 57.32           O  
ATOM    869  N   ARG   123      34.411  46.811  78.921  1.00 57.56           N  
ATOM    870  CA  ARG   123      33.309  47.691  78.559  1.00 56.52           C  
ATOM    871  C   ARG   123      32.165  47.562  79.589  1.00 55.47           C  
ATOM    872  O   ARG   123      31.511  48.560  79.932  1.00 54.82           O  
ATOM    873  CB  ARG   123      32.843  47.338  77.143  1.00 56.70           C  
ATOM    874  CG  ARG   123      31.968  48.376  76.471  1.00 58.83           C  
ATOM    875  CD  ARG   123      32.384  48.557  75.017  1.00 61.07           C  
ATOM    876  NE  ARG   123      32.644  47.274  74.373  1.00 62.11           N  
ATOM    877  CZ  ARG   123      32.703  47.082  73.059  1.00 61.15           C  
ATOM    878  NH1 ARG   123      32.944  45.868  72.581  1.00 61.50           N  
ATOM    879  NH2 ARG   123      32.511  48.090  72.225  1.00 58.51           N  
ATOM    880  N   LEU   124      31.941  46.350  80.104  1.00 54.11           N  
ATOM    881  CA  LEU   124      30.896  46.131  81.105  1.00 51.92           C  
ATOM    882  C   LEU   124      31.148  47.001  82.317  1.00 51.73           C  
ATOM    883  O   LEU   124      30.214  47.406  83.007  1.00 51.27           O  
ATOM    884  CB  LEU   124      30.880  44.678  81.544  1.00 50.85           C  
ATOM    885  CG  LEU   124      30.032  43.787  80.645  1.00 51.38           C  
ATOM    886  CD1 LEU   124      30.293  42.316  80.956  1.00 50.94           C  
ATOM    887  CD2 LEU   124      28.577  44.143  80.849  1.00 49.72           C  
ATOM    888  N   ASP   125      32.424  47.285  82.560  1.00 51.24           N  
ATOM    889  CA  ASP   125      32.830  48.101  83.687  1.00 50.23           C  
ATOM    890  C   ASP   125      32.632  49.581  83.420  1.00 49.42           C  
ATOM    891  O   ASP   125      33.531  50.385  83.651  1.00 49.77           O  
ATOM    892  CB  ASP   125      34.295  47.863  84.029  1.00 51.02           C  
ATOM    893  CG  ASP   125      34.650  48.394  85.397  1.00 52.34           C  
ATOM    894  OD1 ASP   125      33.987  47.955  86.362  1.00 56.39           O  
ATOM    895  OD2 ASP   125      35.564  49.241  85.518  1.00 49.41           O  
ATOM    896  N   ALA   126      31.456  49.945  82.933  1.00 47.73           N  
ATOM    897  CA  ALA   126      31.161  51.342  82.657  1.00 45.55           C  
ATOM    898  C   ALA   126      29.703  51.539  82.977  1.00 44.60           C  
ATOM    899  O   ALA   126      29.257  52.637  83.286  1.00 43.98           O  
ATOM    900  CB  ALA   126      31.418  51.650  81.201  1.00 45.25           C  
ATOM    901  N   LEU   127      28.971  50.437  82.901  1.00 44.50           N  
ATOM    902  CA  LEU   127      27.550  50.432  83.169  1.00 44.06           C  
ATOM    903  C   LEU   127      27.252  49.953  84.590  1.00 44.95           C  
ATOM    904  O   LEU   127      28.095  49.325  85.245  1.00 43.80           O  
ATOM    905  CB  LEU   127      26.841  49.519  82.164  1.00 43.33           C  
ATOM    906  CG  LEU   127      27.475  49.317  80.788  1.00 42.79           C  
ATOM    907  CD1 LEU   127      26.669  48.317  79.945  1.00 43.58           C  
ATOM    908  CD2 LEU   127      27.544  50.640  80.104  1.00 43.48           C  
ATOM    909  N   GLY   128      26.032  50.251  85.045  1.00 46.01           N  
ATOM    910  CA  GLY   128      25.584  49.861  86.369  1.00 45.61           C  
ATOM    911  C   GLY   128      25.827  50.923  87.429  1.00 46.73           C  
ATOM    912  O   GLY   128      26.403  51.982  87.157  1.00 44.35           O  
ATOM    913  N   ALA   129      25.389  50.628  88.650  1.00 47.54           N  
ATOM    914  CA  ALA   129      25.548  51.543  89.771  1.00 48.07           C  
ATOM    915  C   ALA   129      26.857  52.344  89.684  1.00 48.83           C  
ATOM    916  O   ALA   129      26.833  53.582  89.658  1.00 48.08           O  
ATOM    917  CB  ALA   129      25.492  50.767  91.077  1.00 48.05           C  
ATOM    918  N   ILE   130      27.985  51.630  89.636  1.00 48.24           N  
ATOM    919  CA  ILE   130      29.327  52.230  89.554  1.00 47.30           C  
ATOM    920  C   ILE   130      29.369  53.329  88.473  1.00 47.59           C  
ATOM    921  O   ILE   130      29.910  54.427  88.685  1.00 44.81           O  
ATOM    922  CB  ILE   130      30.424  51.139  89.205  1.00 48.89           C  
ATOM    923  CG1 ILE   130      30.141  49.831  89.950  1.00 49.53           C  
ATOM    924  CG2 ILE   130      31.830  51.641  89.589  1.00 45.74           C  
ATOM    925  CD1 ILE   130      30.215  49.947  91.467  1.00 51.75           C  
ATOM    926  N   GLY   131      28.805  53.002  87.307  1.00 45.61           N  
ATOM    927  CA  GLY   131      28.772  53.930  86.193  1.00 42.79           C  
ATOM    928  C   GLY   131      28.065  55.184  86.639  1.00 42.69           C  
ATOM    929  O   GLY   131      28.633  56.273  86.607  1.00 44.79           O  
ATOM    930  N   ILE   132      26.814  55.024  87.052  1.00 39.40           N  
ATOM    931  CA  ILE   132      26.030  56.134  87.548  1.00 36.25           C  
ATOM    932  C   ILE   132      26.952  56.971  88.421  1.00 34.92           C  
ATOM    933  O   ILE   132      27.177  58.146  88.147  1.00 33.86           O  
ATOM    934  CB  ILE   132      24.839  55.603  88.382  1.00 37.08           C  
ATOM    935  CG1 ILE   132      23.862  54.843  87.450  1.00 36.45           C  
ATOM    936  CG2 ILE   132      24.165  56.750  89.116  1.00 35.44           C  
ATOM    937  CD1 ILE   132      22.927  53.793  88.117  1.00 31.47           C  
ATOM    938  N   ALA   133      27.519  56.356  89.450  1.00 34.40           N  
ATOM    939  CA  ALA   133      28.409  57.091  90.334  1.00 34.98           C  
ATOM    940  C   ALA   133      29.565  57.665  89.570  1.00 35.23           C  
ATOM    941  O   ALA   133      29.783  58.866  89.593  1.00 36.54           O  
ATOM    942  CB  ALA   133      28.927  56.206  91.452  1.00 34.14           C  
ATOM    943  N   ARG   134      30.317  56.829  88.876  1.00 37.81           N  
ATOM    944  CA  ARG   134      31.453  57.379  88.162  1.00 40.15           C  
ATOM    945  C   ARG   134      31.059  58.655  87.445  1.00 40.66           C  
ATOM    946  O   ARG   134      31.816  59.617  87.417  1.00 41.81           O  
ATOM    947  CB  ARG   134      31.995  56.387  87.155  1.00 40.18           C  
ATOM    948  CG  ARG   134      33.352  56.763  86.627  1.00 39.20           C  
ATOM    949  CD  ARG   134      33.867  55.598  85.817  1.00 41.48           C  
ATOM    950  NE  ARG   134      33.855  54.382  86.635  1.00 43.84           N  
ATOM    951  CZ  ARG   134      33.340  53.210  86.258  1.00 45.16           C  
ATOM    952  NH1 ARG   134      32.780  53.062  85.059  1.00 45.26           N  
ATOM    953  NH2 ARG   134      33.388  52.176  87.086  1.00 46.42           N  
ATOM    954  N   THR   135      29.847  58.671  86.908  1.00 42.14           N  
ATOM    955  CA  THR   135      29.369  59.829  86.170  1.00 45.26           C  
ATOM    956  C   THR   135      29.187  61.097  87.012  1.00 45.20           C  
ATOM    957  O   THR   135      29.945  62.055  86.863  1.00 45.50           O  
ATOM    958  CB  THR   135      28.060  59.506  85.414  1.00 44.86           C  
ATOM    959  OG1 THR   135      28.067  58.130  85.011  1.00 43.34           O  
ATOM    960  CG2 THR   135      27.973  60.353  84.154  1.00 44.82           C  
ATOM    961  N   PHE   136      28.190  61.126  87.881  1.00 45.77           N  
ATOM    962  CA  PHE   136      27.988  62.308  88.704  1.00 46.48           C  
ATOM    963  C   PHE   136      29.284  62.731  89.370  1.00 47.76           C  
ATOM    964  O   PHE   136      29.530  63.929  89.577  1.00 48.36           O  
ATOM    965  CB  PHE   136      26.929  62.014  89.733  1.00 45.24           C  
ATOM    966  CG  PHE   136      25.622  61.677  89.126  1.00 46.87           C  
ATOM    967  CD1 PHE   136      24.916  62.640  88.430  1.00 47.75           C  
ATOM    968  CD2 PHE   136      25.086  60.410  89.247  1.00 45.51           C  
ATOM    969  CE1 PHE   136      23.689  62.353  87.877  1.00 46.20           C  
ATOM    970  CE2 PHE   136      23.853  60.117  88.693  1.00 45.51           C  
ATOM    971  CZ  PHE   136      23.157  61.086  88.009  1.00 44.96           C  
ATOM    972  N   ALA   137      30.119  61.743  89.688  1.00 49.37           N  
ATOM    973  CA  ALA   137      31.420  61.968  90.324  1.00 51.50           C  
ATOM    974  C   ALA   137      32.296  62.790  89.398  1.00 53.58           C  
ATOM    975  O   ALA   137      32.780  63.855  89.764  1.00 52.21           O  
ATOM    976  CB  ALA   137      32.089  60.637  90.602  1.00 52.06           C  
ATOM    977  N   TYR   138      32.506  62.264  88.196  1.00 56.04           N  
ATOM    978  CA  TYR   138      33.296  62.949  87.197  1.00 59.10           C  
ATOM    979  C   TYR   138      32.643  64.314  86.928  1.00 59.88           C  
ATOM    980  O   TYR   138      33.323  65.311  86.634  1.00 60.01           O  
ATOM    981  CB  TYR   138      33.335  62.106  85.930  1.00 63.06           C  
ATOM    982  CG  TYR   138      33.831  62.848  84.719  1.00 67.74           C  
ATOM    983  CD1 TYR   138      35.121  63.388  84.690  1.00 69.38           C  
ATOM    984  CD2 TYR   138      33.009  63.012  83.598  1.00 69.52           C  
ATOM    985  CE1 TYR   138      35.587  64.080  83.575  1.00 71.49           C  
ATOM    986  CE2 TYR   138      33.460  63.700  82.479  1.00 72.75           C  
ATOM    987  CZ  TYR   138      34.758  64.232  82.473  1.00 72.75           C  
ATOM    988  OH  TYR   138      35.220  64.911  81.368  1.00 72.46           O  
ATOM    989  N   GLY   139      31.315  64.348  87.042  1.00 59.18           N  
ATOM    990  CA  GLY   139      30.574  65.580  86.835  1.00 58.31           C  
ATOM    991  C   GLY   139      30.938  66.600  87.894  1.00 58.19           C  
ATOM    992  O   GLY   139      31.200  67.763  87.589  1.00 57.28           O  
ATOM    993  N   GLY   140      30.954  66.162  89.147  1.00 57.97           N  
ATOM    994  CA  GLY   140      31.320  67.059  90.225  1.00 59.09           C  
ATOM    995  C   GLY   140      32.691  67.676  90.016  1.00 59.07           C  
ATOM    996  O   GLY   140      32.855  68.892  90.126  1.00 58.89           O  
ATOM    997  N   ALA   141      33.676  66.832  89.716  1.00 59.75           N  
ATOM    998  CA  ALA   141      35.040  67.285  89.475  1.00 59.39           C  
ATOM    999  C   ALA   141      35.054  68.246  88.297  1.00 59.87           C  
ATOM   1000  O   ALA   141      35.524  69.372  88.414  1.00 60.06           O  
ATOM   1001  CB  ALA   141      35.942  66.102  89.187  1.00 58.71           C  
ATOM   1002  N   LYS   142      34.525  67.816  87.160  1.00 60.87           N  
ATOM   1003  CA  LYS   142      34.502  68.689  85.998  1.00 63.21           C  
ATOM   1004  C   LYS   142      33.667  69.967  86.157  1.00 64.39           C  
ATOM   1005  O   LYS   142      33.684  70.831  85.279  1.00 65.23           O  
ATOM   1006  CB  LYS   142      34.031  67.911  84.775  1.00 64.01           C  
ATOM   1007  CG  LYS   142      35.115  67.777  83.733  1.00 64.51           C  
ATOM   1008  CD  LYS   142      36.395  67.300  84.369  1.00 62.15           C  
ATOM   1009  CE  LYS   142      37.569  67.712  83.527  1.00 60.80           C  
ATOM   1010  NZ  LYS   142      38.768  67.839  84.392  1.00 59.41           N  
ATOM   1011  N   GLY   143      32.942  70.087  87.269  1.00 64.77           N  
ATOM   1012  CA  GLY   143      32.127  71.270  87.518  1.00 63.40           C  
ATOM   1013  C   GLY   143      30.912  71.412  86.614  1.00 62.51           C  
ATOM   1014  O   GLY   143      30.876  72.271  85.729  1.00 61.96           O  
ATOM   1015  N   ARG   144      29.906  70.577  86.851  1.00 61.37           N  
ATOM   1016  CA  ARG   144      28.688  70.591  86.062  1.00 59.78           C  
ATOM   1017  C   ARG   144      27.506  70.184  86.915  1.00 60.00           C  
ATOM   1018  O   ARG   144      27.665  69.610  87.994  1.00 58.78           O  
ATOM   1019  CB  ARG   144      28.813  69.615  84.892  1.00 59.73           C  
ATOM   1020  CG  ARG   144      30.066  69.807  84.050  1.00 62.09           C  
ATOM   1021  CD  ARG   144      30.038  68.966  82.776  1.00 63.81           C  
ATOM   1022  NE  ARG   144      31.382  68.674  82.275  1.00 64.77           N  
ATOM   1023  CZ  ARG   144      31.677  67.624  81.511  1.00 64.68           C  
ATOM   1024  NH1 ARG   144      32.925  67.426  81.105  1.00 63.47           N  
ATOM   1025  NH2 ARG   144      30.722  66.764  81.159  1.00 63.22           N  
ATOM   1026  N   LEU   145      26.314  70.476  86.425  1.00 61.31           N  
ATOM   1027  CA  LEU   145      25.110  70.106  87.150  1.00 64.02           C  
ATOM   1028  C   LEU   145      24.887  68.610  86.946  1.00 65.18           C  
ATOM   1029  O   LEU   145      25.684  67.932  86.290  1.00 63.31           O  
ATOM   1030  CB  LEU   145      23.914  70.879  86.609  1.00 64.87           C  
ATOM   1031  CG  LEU   145      24.281  72.173  85.880  1.00 65.62           C  
ATOM   1032  CD1 LEU   145      23.035  72.696  85.199  1.00 66.51           C  
ATOM   1033  CD2 LEU   145      24.876  73.192  86.836  1.00 63.82           C  
ATOM   1034  N   MET   146      23.804  68.098  87.514  1.00 67.39           N  
ATOM   1035  CA  MET   146      23.491  66.684  87.382  1.00 71.10           C  
ATOM   1036  C   MET   146      22.471  66.505  86.269  1.00 73.92           C  
ATOM   1037  O   MET   146      22.574  65.589  85.452  1.00 73.43           O  
ATOM   1038  CB  MET   146      22.913  66.155  88.680  1.00 70.84           C  
ATOM   1039  CG  MET   146      23.372  66.913  89.877  1.00 72.60           C  
ATOM   1040  SD  MET   146      22.905  65.976  91.486  1.00 78.81          SE  
ATOM   1041  CE  MET   146      21.040  65.589  91.166  1.00 76.86           C  
ATOM   1042  N   TYR   147      21.479  67.394  86.265  1.00 76.90           N  
ATOM   1043  CA  TYR   147      20.418  67.407  85.267  1.00 78.24           C  
ATOM   1044  C   TYR   147      20.000  68.839  84.996  1.00 79.71           C  
ATOM   1045  O   TYR   147      20.149  69.714  85.852  1.00 79.31           O  
ATOM   1046  CB  TYR   147      19.192  66.655  85.754  1.00 78.83           C  
ATOM   1047  CG  TYR   147      18.045  66.705  84.765  1.00 80.14           C  
ATOM   1048  CD1 TYR   147      16.734  66.830  85.202  1.00 80.08           C  
ATOM   1049  CD2 TYR   147      18.269  66.565  83.390  1.00 80.75           C  
ATOM   1050  CE1 TYR   147      15.673  66.807  84.309  1.00 80.19           C  
ATOM   1051  CE2 TYR   147      17.210  66.542  82.486  1.00 79.87           C  
ATOM   1052  CZ  TYR   147      15.917  66.660  82.957  1.00 80.01           C  
ATOM   1053  OH  TYR   147      14.856  66.606  82.089  1.00 80.94           O  
ATOM   1054  N   ASP   148      19.460  69.062  83.802  1.00 81.42           N  
ATOM   1055  CA  ASP   148      18.997  70.379  83.392  1.00 83.23           C  
ATOM   1056  C   ASP   148      18.013  70.223  82.232  1.00 84.70           C  
ATOM   1057  O   ASP   148      18.398  69.784  81.155  1.00 86.95           O  
ATOM   1058  CB  ASP   148      20.177  71.231  82.937  1.00 81.88           C  
ATOM   1059  CG  ASP   148      19.834  72.701  82.858  1.00 81.53           C  
ATOM   1060  OD1 ASP   148      18.756  73.040  82.330  1.00 82.07           O  
ATOM   1061  OD2 ASP   148      20.651  73.524  83.314  1.00 80.79           O  
ATOM   1062  N   PRO   149      16.734  70.583  82.436  1.00 85.17           N  
ATOM   1063  CA  PRO   149      15.697  70.480  81.402  1.00 84.60           C  
ATOM   1064  C   PRO   149      15.891  71.442  80.222  1.00 84.90           C  
ATOM   1065  O   PRO   149      15.166  71.378  79.236  1.00 85.02           O  
ATOM   1066  CB  PRO   149      14.422  70.765  82.180  1.00 85.35           C  
ATOM   1067  CG  PRO   149      14.887  71.755  83.203  1.00 86.59           C  
ATOM   1068  CD  PRO   149      16.173  71.127  83.685  1.00 85.94           C  
ATOM   1069  N   THR   150      16.868  72.335  80.336  1.00 85.31           N  
ATOM   1070  CA  THR   150      17.176  73.303  79.282  1.00 85.85           C  
ATOM   1071  C   THR   150      18.192  72.692  78.299  1.00 86.98           C  
ATOM   1072  O   THR   150      18.404  73.206  77.192  1.00 86.20           O  
ATOM   1073  CB  THR   150      17.774  74.599  79.885  1.00 86.05           C  
ATOM   1074  OG1 THR   150      16.817  75.185  80.773  1.00 85.27           O  
ATOM   1075  CG2 THR   150      18.140  75.598  78.790  1.00 85.25           C  
ATOM   1076  N   ILE   151      18.822  71.597  78.726  1.00 87.35           N  
ATOM   1077  CA  ILE   151      19.818  70.889  77.926  1.00 88.07           C  
ATOM   1078  C   ILE   151      19.433  69.413  77.779  1.00 88.78           C  
ATOM   1079  O   ILE   151      19.907  68.559  78.522  1.00 87.07           O  
ATOM   1080  CB  ILE   151      21.225  70.985  78.569  1.00 87.96           C  
ATOM   1081  CG1 ILE   151      21.580  72.437  78.841  1.00 88.05           C  
ATOM   1082  CG2 ILE   151      22.275  70.455  77.610  1.00 88.72           C  
ATOM   1083  CD1 ILE   151      21.621  73.282  77.581  1.00 90.03           C  
ATOM   1084  N   PRO   152      18.571  69.097  76.799  1.00 90.99           N  
ATOM   1085  CA  PRO   152      18.126  67.720  76.565  1.00 91.83           C  
ATOM   1086  C   PRO   152      19.251  66.833  76.044  1.00 92.62           C  
ATOM   1087  O   PRO   152      20.301  67.323  75.631  1.00 92.86           O  
ATOM   1088  CB  PRO   152      17.010  67.897  75.543  1.00 92.07           C  
ATOM   1089  CG  PRO   152      17.539  69.024  74.699  1.00 91.62           C  
ATOM   1090  CD  PRO   152      18.054  69.998  75.749  1.00 91.60           C  
ATOM   1091  N   PRO   153      19.041  65.508  76.056  1.00 93.62           N  
ATOM   1092  CA  PRO   153      20.057  64.560  75.576  1.00 94.13           C  
ATOM   1093  C   PRO   153      20.396  64.679  74.071  1.00 93.96           C  
ATOM   1094  O   PRO   153      19.637  65.261  73.293  1.00 93.11           O  
ATOM   1095  CB  PRO   153      19.455  63.195  75.945  1.00 94.12           C  
ATOM   1096  CG  PRO   153      17.976  63.442  75.866  1.00 94.32           C  
ATOM   1097  CD  PRO   153      17.841  64.798  76.536  1.00 93.75           C  
ATOM   1098  N   ARG   154      21.545  64.126  73.681  1.00 93.44           N  
ATOM   1099  CA  ARG   154      22.004  64.152  72.292  1.00 92.49           C  
ATOM   1100  C   ARG   154      22.469  62.757  71.847  1.00 92.25           C  
ATOM   1101  O   ARG   154      22.000  62.210  70.846  1.00 91.34           O  
ATOM   1102  CB  ARG   154      23.147  65.173  72.146  1.00 91.37           C  
ATOM   1103  CG  ARG   154      23.770  65.268  70.757  1.00 90.85           C  
ATOM   1104  CD  ARG   154      24.841  64.200  70.546  1.00 91.19           C  
ATOM   1105  NE  ARG   154      25.361  64.181  69.176  1.00 90.28           N  
ATOM   1106  CZ  ARG   154      24.739  63.621  68.144  1.00 89.45           C  
ATOM   1107  NH1 ARG   154      25.291  63.663  66.937  1.00 87.75           N  
ATOM   1108  NH2 ARG   154      23.574  63.008  68.321  1.00 90.00           N  
ATOM   1109  N   ASP   167      25.813  70.869  79.364  1.00 75.03           N  
ATOM   1110  CA  ASP   167      26.285  69.495  79.326  1.00 74.65           C  
ATOM   1111  C   ASP   167      26.305  68.926  80.748  1.00 73.03           C  
ATOM   1112  O   ASP   167      27.348  68.907  81.410  1.00 72.46           O  
ATOM   1113  CB  ASP   167      27.682  69.434  78.673  1.00 76.08           C  
ATOM   1114  CG  ASP   167      28.626  70.524  79.186  1.00 78.97           C  
ATOM   1115  OD1 ASP   167      29.751  70.632  78.646  1.00 78.19           O  
ATOM   1116  OD2 ASP   167      28.256  71.271  80.132  1.00 79.93           O  
ATOM   1117  N   PRO   168      25.133  68.470  81.237  1.00 70.89           N  
ATOM   1118  CA  PRO   168      24.956  67.895  82.571  1.00 68.45           C  
ATOM   1119  C   PRO   168      25.338  66.415  82.633  1.00 66.46           C  
ATOM   1120  O   PRO   168      25.385  65.730  81.612  1.00 64.86           O  
ATOM   1121  CB  PRO   168      23.479  68.127  82.825  1.00 68.47           C  
ATOM   1122  CG  PRO   168      22.908  67.820  81.487  1.00 69.40           C  
ATOM   1123  CD  PRO   168      23.830  68.580  80.552  1.00 69.73           C  
ATOM   1124  N   SER   169      25.580  65.930  83.845  1.00 65.69           N  
ATOM   1125  CA  SER   169      25.974  64.544  84.059  1.00 63.57           C  
ATOM   1126  C   SER   169      24.942  63.517  83.655  1.00 61.33           C  
ATOM   1127  O   SER   169      25.295  62.457  83.165  1.00 60.74           O  
ATOM   1128  CB  SER   169      26.325  64.311  85.527  1.00 64.41           C  
ATOM   1129  OG  SER   169      27.329  65.209  85.967  1.00 67.02           O  
ATOM   1130  N   LEU   170      23.669  63.812  83.867  1.00 60.48           N  
ATOM   1131  CA  LEU   170      22.634  62.847  83.526  1.00 60.66           C  
ATOM   1132  C   LEU   170      22.572  62.569  82.041  1.00 62.78           C  
ATOM   1133  O   LEU   170      22.270  61.449  81.626  1.00 63.65           O  
ATOM   1134  CB  LEU   170      21.259  63.318  83.985  1.00 57.33           C  
ATOM   1135  CG  LEU   170      20.190  62.240  83.848  1.00 52.71           C  
ATOM   1136  CD1 LEU   170      20.039  61.545  85.162  1.00 52.07           C  
ATOM   1137  CD2 LEU   170      18.880  62.857  83.442  1.00 51.94           C  
ATOM   1138  N   ASN   171      22.853  63.581  81.233  1.00 65.04           N  
ATOM   1139  CA  ASN   171      22.804  63.400  79.788  1.00 68.04           C  
ATOM   1140  C   ASN   171      23.843  62.391  79.307  1.00 68.57           C  
ATOM   1141  O   ASN   171      23.561  61.572  78.429  1.00 68.23           O  
ATOM   1142  CB  ASN   171      22.982  64.750  79.083  1.00 70.11           C  
ATOM   1143  CG  ASN   171      21.727  65.619  79.161  1.00 71.61           C  
ATOM   1144  OD1 ASN   171      21.797  66.842  79.045  1.00 70.95           O  
ATOM   1145  ND2 ASN   171      20.569  64.981  79.343  1.00 72.29           N  
ATOM   1146  N   HIS   172      25.035  62.439  79.893  1.00 70.13           N  
ATOM   1147  CA  HIS   172      26.110  61.520  79.522  1.00 71.32           C  
ATOM   1148  C   HIS   172      25.586  60.082  79.403  1.00 70.80           C  
ATOM   1149  O   HIS   172      26.102  59.288  78.615  1.00 71.74           O  
ATOM   1150  CB  HIS   172      27.246  61.593  80.561  1.00 72.60           C  
ATOM   1151  CG  HIS   172      28.413  60.690  80.273  1.00 73.91           C  
ATOM   1152  ND1 HIS   172      28.299  59.316  80.199  1.00 73.44           N  
ATOM   1153  CD2 HIS   172      29.726  60.964  80.076  1.00 74.10           C  
ATOM   1154  CE1 HIS   172      29.487  58.786  79.973  1.00 72.45           C  
ATOM   1155  NE2 HIS   172      30.371  59.764  79.895  1.00 73.85           N  
ATOM   1156  N   PHE   173      24.553  59.744  80.166  1.00 69.09           N  
ATOM   1157  CA  PHE   173      24.028  58.394  80.098  1.00 68.29           C  
ATOM   1158  C   PHE   173      23.559  58.061  78.692  1.00 68.86           C  
ATOM   1159  O   PHE   173      24.103  57.158  78.045  1.00 67.05           O  
ATOM   1160  CB  PHE   173      22.907  58.213  81.119  1.00 67.59           C  
ATOM   1161  CG  PHE   173      23.387  58.262  82.545  1.00 67.20           C  
ATOM   1162  CD1 PHE   173      22.977  59.276  83.395  1.00 65.74           C  
ATOM   1163  CD2 PHE   173      24.310  57.327  83.016  1.00 66.73           C  
ATOM   1164  CE1 PHE   173      23.472  59.355  84.682  1.00 63.73           C  
ATOM   1165  CE2 PHE   173      24.808  57.404  84.306  1.00 64.33           C  
ATOM   1166  CZ  PHE   173      24.393  58.421  85.135  1.00 64.47           C  
ATOM   1167  N   TYR   174      22.558  58.793  78.211  1.00 70.58           N  
ATOM   1168  CA  TYR   174      22.034  58.573  76.865  1.00 71.24           C  
ATOM   1169  C   TYR   174      23.142  58.810  75.855  1.00 73.12           C  
ATOM   1170  O   TYR   174      23.262  58.079  74.869  1.00 72.70           O  
ATOM   1171  CB  TYR   174      20.895  59.540  76.571  1.00 69.11           C  
ATOM   1172  CG  TYR   174      19.740  59.401  77.513  1.00 69.86           C  
ATOM   1173  CD1 TYR   174      19.088  58.177  77.670  1.00 68.60           C  
ATOM   1174  CD2 TYR   174      19.296  60.492  78.263  1.00 71.00           C  
ATOM   1175  CE1 TYR   174      18.024  58.047  78.552  1.00 68.97           C  
ATOM   1176  CE2 TYR   174      18.233  60.373  79.146  1.00 70.09           C  
ATOM   1177  CZ  TYR   174      17.605  59.150  79.286  1.00 70.16           C  
ATOM   1178  OH  TYR   174      16.560  59.045  80.168  1.00 72.51           O  
ATOM   1179  N   GLU   175      23.950  59.835  76.124  1.00 74.26           N  
ATOM   1180  CA  GLU   175      25.058  60.216  75.260  1.00 75.71           C  
ATOM   1181  C   GLU   175      25.911  59.044  74.797  1.00 76.05           C  
ATOM   1182  O   GLU   175      25.898  58.682  73.621  1.00 76.81           O  
ATOM   1183  CB  GLU   175      25.954  61.234  75.971  1.00 77.49           C  
ATOM   1184  CG  GLU   175      26.216  62.495  75.164  1.00 80.51           C  
ATOM   1185  CD  GLU   175      24.967  63.347  75.014  1.00 83.72           C  
ATOM   1186  OE1 GLU   175      24.650  64.129  75.944  1.00 85.14           O  
ATOM   1187  OE2 GLU   175      24.292  63.226  73.967  1.00 84.83           O  
ATOM   1188  N   LYS   176      26.655  58.448  75.722  1.00 76.42           N  
ATOM   1189  CA  LYS   176      27.532  57.350  75.359  1.00 76.38           C  
ATOM   1190  C   LYS   176      27.648  56.273  76.427  1.00 76.16           C  
ATOM   1191  O   LYS   176      28.753  55.851  76.753  1.00 77.18           O  
ATOM   1192  CB  LYS   176      28.933  57.898  75.017  1.00 76.48           C  
ATOM   1193  CG  LYS   176      28.963  58.904  73.840  1.00 75.87           C  
ATOM   1194  CD  LYS   176      30.386  59.334  73.454  1.00 74.33           C  
ATOM   1195  CE  LYS   176      31.082  60.122  74.558  1.00 74.40           C  
ATOM   1196  NZ  LYS   176      32.523  60.393  74.253  1.00 73.62           N  
ATOM   1197  N   LEU   177      26.518  55.823  76.968  1.00 75.50           N  
ATOM   1198  CA  LEU   177      26.539  54.776  77.991  1.00 74.89           C  
ATOM   1199  C   LEU   177      25.440  53.736  77.802  1.00 74.98           C  
ATOM   1200  O   LEU   177      25.714  52.540  77.781  1.00 75.16           O  
ATOM   1201  CB  LEU   177      26.435  55.381  79.402  1.00 72.96           C  
ATOM   1202  CG  LEU   177      27.728  55.664  80.176  1.00 71.09           C  
ATOM   1203  CD1 LEU   177      27.427  56.027  81.626  1.00 69.19           C  
ATOM   1204  CD2 LEU   177      28.588  54.429  80.137  1.00 70.74           C  
ATOM   1205  N   LEU   178      24.198  54.185  77.671  1.00 75.08           N  
ATOM   1206  CA  LEU   178      23.106  53.247  77.485  1.00 75.73           C  
ATOM   1207  C   LEU   178      23.277  52.463  76.188  1.00 77.01           C  
ATOM   1208  O   LEU   178      22.705  51.387  76.029  1.00 77.80           O  
ATOM   1209  CB  LEU   178      21.761  53.976  77.479  1.00 74.55           C  
ATOM   1210  CG  LEU   178      21.270  54.519  78.817  1.00 74.09           C  
ATOM   1211  CD1 LEU   178      19.895  55.126  78.642  1.00 73.47           C  
ATOM   1212  CD2 LEU   178      21.208  53.392  79.835  1.00 74.55           C  
ATOM   1213  N   LYS   179      24.073  52.999  75.265  1.00 77.77           N  
ATOM   1214  CA  LYS   179      24.306  52.339  73.984  1.00 78.05           C  
ATOM   1215  C   LYS   179      25.561  51.460  73.999  1.00 78.51           C  
ATOM   1216  O   LYS   179      26.146  51.188  72.946  1.00 79.11           O  
ATOM   1217  CB  LYS   179      24.431  53.380  72.868  1.00 78.24           C  
ATOM   1218  CG  LYS   179      25.661  54.275  72.973  1.00 77.44           C  
ATOM   1219  CD  LYS   179      25.707  55.313  71.851  1.00 77.04           C  
ATOM   1220  CE  LYS   179      24.596  56.346  71.998  1.00 75.83           C  
ATOM   1221  NZ  LYS   179      24.664  57.418  70.971  1.00 74.13           N  
ATOM   1222  N   LEU   180      25.965  51.013  75.191  1.00 78.30           N  
ATOM   1223  CA  LEU   180      27.146  50.161  75.354  1.00 76.34           C  
ATOM   1224  C   LEU   180      26.802  48.696  75.438  1.00 75.62           C  
ATOM   1225  O   LEU   180      27.647  47.852  75.173  1.00 76.79           O  
ATOM   1226  CB  LEU   180      27.929  50.555  76.601  1.00 74.65           C  
ATOM   1227  CG  LEU   180      28.813  51.781  76.411  1.00 73.57           C  
ATOM   1228  CD1 LEU   180      29.397  52.182  77.740  1.00 73.07           C  
ATOM   1229  CD2 LEU   180      29.914  51.468  75.410  1.00 73.90           C  
ATOM   1230  N   LYS   181      25.565  48.401  75.817  1.00 74.92           N  
ATOM   1231  CA  LYS   181      25.100  47.024  75.925  1.00 73.93           C  
ATOM   1232  C   LYS   181      24.877  46.409  74.551  1.00 73.05           C  
ATOM   1233  O   LYS   181      24.561  45.229  74.426  1.00 71.78           O  
ATOM   1234  CB  LYS   181      23.808  46.970  76.749  1.00 73.94           C  
ATOM   1235  CG  LYS   181      22.731  47.949  76.303  1.00 75.35           C  
ATOM   1236  CD  LYS   181      21.801  47.394  75.231  1.00 76.55           C  
ATOM   1237  CE  LYS   181      20.776  46.433  75.812  1.00 76.93           C  
ATOM   1238  NZ  LYS   181      21.418  45.228  76.402  1.00 78.17           N  
ATOM   1239  N   ASP   182      25.049  47.219  73.517  1.00 74.29           N  
ATOM   1240  CA  ASP   182      24.861  46.747  72.151  1.00 75.68           C  
ATOM   1241  C   ASP   182      26.196  46.398  71.496  1.00 75.38           C  
ATOM   1242  O   ASP   182      26.224  45.857  70.397  1.00 74.67           O  
ATOM   1243  CB  ASP   182      24.126  47.811  71.313  1.00 76.95           C  
ATOM   1244  CG  ASP   182      22.700  48.094  71.816  1.00 78.30           C  
ATOM   1245  OD1 ASP   182      21.904  47.136  71.990  1.00 77.49           O  
ATOM   1246  OD2 ASP   182      22.374  49.287  72.020  1.00 78.32           O  
ATOM   1247  N   LEU   183      27.293  46.702  72.186  1.00 75.46           N  
ATOM   1248  CA  LEU   183      28.637  46.431  71.682  1.00 75.33           C  
ATOM   1249  C   LEU   183      29.280  45.222  72.366  1.00 76.10           C  
ATOM   1250  O   LEU   183      30.450  44.903  72.138  1.00 75.33           O  
ATOM   1251  CB  LEU   183      29.528  47.660  71.881  1.00 75.27           C  
ATOM   1252  CG  LEU   183      29.250  48.915  71.048  1.00 74.97           C  
ATOM   1253  CD1 LEU   183      29.509  48.624  69.579  1.00 75.42           C  
ATOM   1254  CD2 LEU   183      27.824  49.386  71.264  1.00 74.93           C  
ATOM   1255  N   MET   184      28.513  44.550  73.212  1.00 77.26           N  
ATOM   1256  CA  MET   184      29.023  43.382  73.909  1.00 78.13           C  
ATOM   1257  C   MET   184      29.167  42.247  72.893  1.00 77.19           C  
ATOM   1258  O   MET   184      28.328  42.100  72.003  1.00 77.75           O  
ATOM   1259  CB  MET   184      28.055  42.996  75.030  1.00 80.86           C  
ATOM   1260  CG  MET   184      28.717  42.780  76.395  1.00 84.94           C  
ATOM   1261  SD  MET   184      29.730  44.308  77.056  1.00 87.42          SE  
ATOM   1262  CE  MET   184      28.303  45.371  77.829  1.00 85.70           C  
ATOM   1263  N   ASN   185      30.233  41.456  73.025  1.00 75.64           N  
ATOM   1264  CA  ASN   185      30.505  40.337  72.118  1.00 72.79           C  
ATOM   1265  C   ASN   185      29.903  39.005  72.539  1.00 71.82           C  
ATOM   1266  O   ASN   185      28.912  38.584  71.968  1.00 72.35           O  
ATOM   1267  CB  ASN   185      32.009  40.156  71.944  1.00 72.85           C  
ATOM   1268  CG  ASN   185      32.701  41.444  71.575  1.00 73.80           C  
ATOM   1269  OD1 ASN   185      32.131  42.284  70.870  1.00 73.42           O  
ATOM   1270  ND2 ASN   185      33.942  41.606  72.027  1.00 73.87           N  
ATOM   1271  N   THR   186      30.508  38.335  73.522  1.00 72.11           N  
ATOM   1272  CA  THR   186      30.001  37.031  73.968  1.00 72.31           C  
ATOM   1273  C   THR   186      28.644  37.151  74.638  1.00 74.06           C  
ATOM   1274  O   THR   186      28.168  38.248  74.934  1.00 73.83           O  
ATOM   1275  CB  THR   186      30.909  36.316  74.996  1.00 70.65           C  
ATOM   1276  OG1 THR   186      30.563  36.764  76.304  1.00 69.68           O  
ATOM   1277  CG2 THR   186      32.371  36.600  74.753  1.00 70.22           C  
ATOM   1278  N   ASN   187      28.035  36.000  74.900  1.00 75.92           N  
ATOM   1279  CA  ASN   187      26.725  35.951  75.532  1.00 76.49           C  
ATOM   1280  C   ASN   187      26.753  36.396  76.991  1.00 76.55           C  
ATOM   1281  O   ASN   187      26.038  37.320  77.354  1.00 77.17           O  
ATOM   1282  CB  ASN   187      26.149  34.530  75.456  1.00 78.02           C  
ATOM   1283  CG  ASN   187      25.748  34.125  74.046  1.00 78.58           C  
ATOM   1284  OD1 ASN   187      25.318  32.994  73.819  1.00 78.61           O  
ATOM   1285  ND2 ASN   187      25.878  35.047  73.096  1.00 79.16           N  
ATOM   1286  N   ALA   188      27.562  35.732  77.821  1.00 75.68           N  
ATOM   1287  CA  ALA   188      27.640  36.065  79.245  1.00 75.21           C  
ATOM   1288  C   ALA   188      27.756  37.573  79.469  1.00 75.67           C  
ATOM   1289  O   ALA   188      27.107  38.136  80.365  1.00 75.46           O  
ATOM   1290  CB  ALA   188      28.813  35.342  79.896  1.00 74.80           C  
ATOM   1291  N   ALA   189      28.584  38.217  78.646  1.00 75.41           N  
ATOM   1292  CA  ALA   189      28.792  39.665  78.705  1.00 74.71           C  
ATOM   1293  C   ALA   189      27.487  40.359  78.336  1.00 74.26           C  
ATOM   1294  O   ALA   189      27.053  41.280  79.023  1.00 73.63           O  
ATOM   1295  CB  ALA   189      29.889  40.077  77.731  1.00 74.38           C  
ATOM   1296  N   LYS   190      26.869  39.920  77.242  1.00 74.36           N  
ATOM   1297  CA  LYS   190      25.608  40.508  76.824  1.00 74.67           C  
ATOM   1298  C   LYS   190      24.570  40.349  77.928  1.00 75.01           C  
ATOM   1299  O   LYS   190      23.831  41.281  78.231  1.00 75.26           O  
ATOM   1300  CB  LYS   190      25.088  39.854  75.538  1.00 75.08           C  
ATOM   1301  CG  LYS   190      25.766  40.332  74.253  1.00 75.61           C  
ATOM   1302  CD  LYS   190      24.883  40.096  73.020  1.00 75.14           C  
ATOM   1303  CE  LYS   190      23.426  40.597  73.216  1.00 76.92           C  
ATOM   1304  NZ  LYS   190      23.231  42.059  73.518  1.00 74.41           N  
ATOM   1305  N   GLN   191      24.513  39.170  78.537  1.00 75.89           N  
ATOM   1306  CA  GLN   191      23.547  38.934  79.597  1.00 76.18           C  
ATOM   1307  C   GLN   191      23.737  39.951  80.701  1.00 74.48           C  
ATOM   1308  O   GLN   191      22.874  40.789  80.952  1.00 72.86           O  
ATOM   1309  CB  GLN   191      23.703  37.527  80.169  1.00 79.53           C  
ATOM   1310  CG  GLN   191      22.910  37.303  81.461  1.00 85.65           C  
ATOM   1311  CD  GLN   191      21.440  37.741  81.363  1.00 88.46           C  
ATOM   1312  OE1 GLN   191      21.122  38.937  81.409  1.00 88.38           O  
ATOM   1313  NE2 GLN   191      20.541  36.765  81.217  1.00 90.48           N  
ATOM   1314  N   GLU   192      24.876  39.865  81.368  1.00 73.40           N  
ATOM   1315  CA  GLU   192      25.179  40.791  82.439  1.00 73.33           C  
ATOM   1316  C   GLU   192      24.836  42.222  82.014  1.00 72.83           C  
ATOM   1317  O   GLU   192      24.169  42.947  82.753  1.00 73.68           O  
ATOM   1318  CB  GLU   192      26.660  40.683  82.799  1.00 73.12           C  
ATOM   1319  CG  GLU   192      27.144  41.718  83.787  1.00 74.16           C  
ATOM   1320  CD  GLU   192      26.452  41.613  85.125  1.00 74.74           C  
ATOM   1321  OE1 GLU   192      25.342  42.158  85.264  1.00 74.77           O  
ATOM   1322  OE2 GLU   192      27.013  40.968  86.035  1.00 75.76           O  
ATOM   1323  N   ALA   193      25.279  42.608  80.815  1.00 71.50           N  
ATOM   1324  CA  ALA   193      25.059  43.951  80.268  1.00 68.92           C  
ATOM   1325  C   ALA   193      23.603  44.386  80.271  1.00 68.50           C  
ATOM   1326  O   ALA   193      23.292  45.536  80.580  1.00 68.09           O  
ATOM   1327  CB  ALA   193      25.612  44.024  78.868  1.00 68.80           C  
ATOM   1328  N   GLU   194      22.715  43.468  79.904  1.00 67.87           N  
ATOM   1329  CA  GLU   194      21.293  43.756  79.898  1.00 66.46           C  
ATOM   1330  C   GLU   194      20.845  44.035  81.323  1.00 64.80           C  
ATOM   1331  O   GLU   194      20.080  44.954  81.567  1.00 65.66           O  
ATOM   1332  CB  GLU   194      20.517  42.567  79.347  1.00 67.96           C  
ATOM   1333  CG  GLU   194      20.005  42.779  77.933  1.00 70.18           C  
ATOM   1334  CD  GLU   194      18.933  43.853  77.859  1.00 70.72           C  
ATOM   1335  OE1 GLU   194      18.625  44.306  76.732  1.00 70.03           O  
ATOM   1336  OE2 GLU   194      18.395  44.235  78.926  1.00 69.67           O  
ATOM   1337  N   VAL   195      21.334  43.249  82.272  1.00 63.03           N  
ATOM   1338  CA  VAL   195      20.939  43.449  83.650  1.00 59.68           C  
ATOM   1339  C   VAL   195      21.485  44.783  84.126  1.00 59.89           C  
ATOM   1340  O   VAL   195      20.764  45.558  84.756  1.00 60.97           O  
ATOM   1341  CB  VAL   195      21.455  42.317  84.561  1.00 57.40           C  
ATOM   1342  CG1 VAL   195      20.565  42.196  85.765  1.00 54.67           C  
ATOM   1343  CG2 VAL   195      21.480  41.005  83.806  1.00 56.31           C  
ATOM   1344  N   ARG   196      22.751  45.057  83.818  1.00 59.61           N  
ATOM   1345  CA  ARG   196      23.391  46.319  84.223  1.00 60.56           C  
ATOM   1346  C   ARG   196      22.696  47.516  83.569  1.00 62.73           C  
ATOM   1347  O   ARG   196      22.392  48.521  84.237  1.00 63.28           O  
ATOM   1348  CB  ARG   196      24.864  46.368  83.797  1.00 58.24           C  
ATOM   1349  CG  ARG   196      25.871  45.590  84.642  1.00 54.44           C  
ATOM   1350  CD  ARG   196      27.048  46.513  84.932  1.00 52.09           C  
ATOM   1351  NE  ARG   196      28.298  45.818  85.194  1.00 51.02           N  
ATOM   1352  CZ  ARG   196      28.438  44.816  86.052  1.00 52.11           C  
ATOM   1353  NH1 ARG   196      27.395  44.377  86.733  1.00 54.90           N  
ATOM   1354  NH2 ARG   196      29.626  44.266  86.247  1.00 51.28           N  
ATOM   1355  N   HIS   197      22.480  47.400  82.253  1.00 63.26           N  
ATOM   1356  CA  HIS   197      21.842  48.447  81.453  1.00 62.92           C  
ATOM   1357  C   HIS   197      20.461  48.771  81.995  1.00 62.69           C  
ATOM   1358  O   HIS   197      20.097  49.935  82.154  1.00 62.26           O  
ATOM   1359  CB  HIS   197      21.741  48.014  79.978  1.00 60.95           C  
ATOM   1360  CG  HIS   197      21.149  49.059  79.076  1.00 60.69           C  
ATOM   1361  ND1 HIS   197      19.853  48.999  78.609  1.00 59.78           N  
ATOM   1362  CD2 HIS   197      21.682  50.191  78.552  1.00 59.85           C  
ATOM   1363  CE1 HIS   197      19.612  50.045  77.835  1.00 58.82           C  
ATOM   1364  NE2 HIS   197      20.704  50.784  77.785  1.00 59.69           N  
ATOM   1365  N   ARG   198      19.705  47.723  82.290  1.00 63.19           N  
ATOM   1366  CA  ARG   198      18.362  47.867  82.813  1.00 64.11           C  
ATOM   1367  C   ARG   198      18.372  48.754  84.046  1.00 65.67           C  
ATOM   1368  O   ARG   198      17.533  49.647  84.160  1.00 66.28           O  
ATOM   1369  CB  ARG   198      17.803  46.497  83.179  1.00 64.14           C  
ATOM   1370  CG  ARG   198      16.297  46.438  83.336  1.00 62.32           C  
ATOM   1371  CD  ARG   198      15.878  45.024  83.697  1.00 61.36           C  
ATOM   1372  NE  ARG   198      16.603  44.028  82.906  1.00 62.63           N  
ATOM   1373  CZ  ARG   198      16.603  43.963  81.573  1.00 64.10           C  
ATOM   1374  NH1 ARG   198      17.300  43.019  80.955  1.00 64.30           N  
ATOM   1375  NH2 ARG   198      15.912  44.839  80.849  1.00 65.67           N  
ATOM   1376  N   TYR   199      19.321  48.517  84.958  1.00 66.80           N  
ATOM   1377  CA  TYR   199      19.414  49.291  86.200  1.00 68.41           C  
ATOM   1378  C   TYR   199      19.596  50.794  85.951  1.00 70.32           C  
ATOM   1379  O   TYR   199      18.955  51.614  86.610  1.00 70.72           O  
ATOM   1380  CB  TYR   199      20.547  48.752  87.103  1.00 67.25           C  
ATOM   1381  CG  TYR   199      20.519  49.329  88.522  1.00 66.91           C  
ATOM   1382  CD1 TYR   199      21.544  50.150  88.987  1.00 67.24           C  
ATOM   1383  CD2 TYR   199      19.409  49.142  89.347  1.00 67.93           C  
ATOM   1384  CE1 TYR   199      21.458  50.783  90.232  1.00 68.80           C  
ATOM   1385  CE2 TYR   199      19.303  49.766  90.594  1.00 68.25           C  
ATOM   1386  CZ  TYR   199      20.322  50.591  91.028  1.00 68.93           C  
ATOM   1387  OH  TYR   199      20.178  51.269  92.216  1.00 68.72           O  
ATOM   1388  N   MET   200      20.459  51.157  85.004  1.00 72.62           N  
ATOM   1389  CA  MET   200      20.664  52.561  84.690  1.00 74.08           C  
ATOM   1390  C   MET   200      19.351  53.148  84.158  1.00 74.57           C  
ATOM   1391  O   MET   200      19.051  54.320  84.376  1.00 74.04           O  
ATOM   1392  CB  MET   200      21.794  52.722  83.663  1.00 76.05           C  
ATOM   1393  CG  MET   200      23.168  52.273  84.171  1.00 81.26           C  
ATOM   1394  SD  MET   200      24.671  52.625  82.955  1.00 89.11          SE  
ATOM   1395  CE  MET   200      25.413  54.241  83.731  1.00 86.30           C  
ATOM   1396  N   GLU   201      18.560  52.325  83.474  1.00 75.72           N  
ATOM   1397  CA  GLU   201      17.276  52.775  82.930  1.00 76.94           C  
ATOM   1398  C   GLU   201      16.309  53.085  84.072  1.00 76.91           C  
ATOM   1399  O   GLU   201      15.797  54.206  84.179  1.00 78.29           O  
ATOM   1400  CB  GLU   201      16.673  51.702  81.998  1.00 77.75           C  
ATOM   1401  CG  GLU   201      17.526  51.444  80.739  1.00 79.18           C  
ATOM   1402  CD  GLU   201      16.883  50.516  79.696  1.00 79.10           C  
ATOM   1403  OE1 GLU   201      16.629  49.320  80.002  1.00 78.25           O  
ATOM   1404  OE2 GLU   201      16.655  50.997  78.558  1.00 76.78           O  
ATOM   1405  N   GLN   202      16.072  52.085  84.918  1.00 75.22           N  
ATOM   1406  CA  GLN   202      15.185  52.208  86.070  1.00 73.35           C  
ATOM   1407  C   GLN   202      15.658  53.328  86.982  1.00 71.78           C  
ATOM   1408  O   GLN   202      14.843  54.035  87.572  1.00 72.11           O  
ATOM   1409  CB  GLN   202      15.157  50.892  86.845  1.00 73.80           C  
ATOM   1410  CG  GLN   202      14.783  49.699  85.993  1.00 73.00           C  
ATOM   1411  CD  GLN   202      15.285  48.388  86.568  1.00 73.10           C  
ATOM   1412  OE1 GLN   202      15.233  47.349  85.904  1.00 73.50           O  
ATOM   1413  NE2 GLN   202      15.776  48.427  87.806  1.00 71.54           N  
ATOM   1414  N   PHE   203      16.973  53.482  87.107  1.00 69.45           N  
ATOM   1415  CA  PHE   203      17.526  54.547  87.941  1.00 68.04           C  
ATOM   1416  C   PHE   203      17.067  55.913  87.416  1.00 68.43           C  
ATOM   1417  O   PHE   203      16.410  56.669  88.137  1.00 68.35           O  
ATOM   1418  CB  PHE   203      19.056  54.480  87.951  1.00 65.49           C  
ATOM   1419  CG  PHE   203      19.709  55.650  88.624  1.00 62.53           C  
ATOM   1420  CD1 PHE   203      19.941  56.830  87.931  1.00 62.08           C  
ATOM   1421  CD2 PHE   203      20.089  55.575  89.951  1.00 60.90           C  
ATOM   1422  CE1 PHE   203      20.542  57.923  88.556  1.00 62.00           C  
ATOM   1423  CE2 PHE   203      20.688  56.662  90.581  1.00 61.52           C  
ATOM   1424  CZ  PHE   203      20.915  57.836  89.881  1.00 61.62           C  
ATOM   1425  N   ILE   204      17.410  56.218  86.161  1.00 68.20           N  
ATOM   1426  CA  ILE   204      17.029  57.483  85.536  1.00 67.52           C  
ATOM   1427  C   ILE   204      15.503  57.620  85.562  1.00 67.97           C  
ATOM   1428  O   ILE   204      14.956  58.705  85.339  1.00 68.79           O  
ATOM   1429  CB  ILE   204      17.569  57.579  84.072  1.00 66.99           C  
ATOM   1430  CG1 ILE   204      19.101  57.482  84.074  1.00 66.55           C  
ATOM   1431  CG2 ILE   204      17.189  58.911  83.445  1.00 64.54           C  
ATOM   1432  CD1 ILE   204      19.744  57.720  82.713  1.00 65.48           C  
ATOM   1433  N   GLU   205      14.821  56.519  85.863  1.00 67.10           N  
ATOM   1434  CA  GLU   205      13.370  56.527  85.943  1.00 66.69           C  
ATOM   1435  C   GLU   205      12.966  56.952  87.340  1.00 65.58           C  
ATOM   1436  O   GLU   205      11.959  57.631  87.523  1.00 68.90           O  
ATOM   1437  CB  GLU   205      12.815  55.142  85.659  1.00 67.68           C  
ATOM   1438  CG  GLU   205      11.358  55.137  85.255  1.00 71.24           C  
ATOM   1439  CD  GLU   205      11.010  53.918  84.425  1.00 74.41           C  
ATOM   1440  OE1 GLU   205      11.160  52.789  84.967  1.00 76.62           O  
ATOM   1441  OE2 GLU   205      10.598  54.090  83.241  1.00 71.65           O  
ATOM   1442  N   GLN   206      13.746  56.542  88.331  1.00 62.02           N  
ATOM   1443  CA  GLN   206      13.447  56.914  89.698  1.00 58.05           C  
ATOM   1444  C   GLN   206      14.009  58.292  89.917  1.00 57.05           C  
ATOM   1445  O   GLN   206      13.497  59.054  90.717  1.00 56.80           O  
ATOM   1446  CB  GLN   206      14.103  55.962  90.680  1.00 57.90           C  
ATOM   1447  CG  GLN   206      14.098  56.472  92.108  1.00 56.31           C  
ATOM   1448  CD  GLN   206      12.749  56.321  92.767  1.00 55.57           C  
ATOM   1449  OE1 GLN   206      12.435  57.014  93.741  1.00 52.00           O  
ATOM   1450  NE2 GLN   206      11.943  55.397  92.248  1.00 55.98           N  
ATOM   1451  N   PHE   207      15.078  58.613  89.207  1.00 56.92           N  
ATOM   1452  CA  PHE   207      15.687  59.919  89.362  1.00 57.13           C  
ATOM   1453  C   PHE   207      14.760  60.998  88.875  1.00 59.67           C  
ATOM   1454  O   PHE   207      14.610  62.020  89.525  1.00 60.53           O  
ATOM   1455  CB  PHE   207      17.002  59.988  88.587  1.00 53.08           C  
ATOM   1456  CG  PHE   207      17.651  61.353  88.576  1.00 48.74           C  
ATOM   1457  CD1 PHE   207      17.185  62.365  87.746  1.00 47.05           C  
ATOM   1458  CD2 PHE   207      18.778  61.601  89.353  1.00 46.14           C  
ATOM   1459  CE1 PHE   207      17.842  63.597  87.690  1.00 45.78           C  
ATOM   1460  CE2 PHE   207      19.434  62.829  89.299  1.00 43.07           C  
ATOM   1461  CZ  PHE   207      18.968  63.822  88.467  1.00 44.02           C  
ATOM   1462  N   MET   208      14.130  60.766  87.730  1.00 63.77           N  
ATOM   1463  CA  MET   208      13.238  61.758  87.134  1.00 67.60           C  
ATOM   1464  C   MET   208      11.990  62.069  87.943  1.00 67.17           C  
ATOM   1465  O   MET   208      11.653  63.235  88.155  1.00 66.24           O  
ATOM   1466  CB  MET   208      12.837  61.307  85.734  1.00 72.75           C  
ATOM   1467  CG  MET   208      12.999  62.402  84.695  1.00 77.43           C  
ATOM   1468  SD  MET   208      14.721  63.292  84.858  1.00 85.66          SE  
ATOM   1469  CE  MET   208      15.860  61.781  84.437  1.00 81.71           C  
ATOM   1470  N   LYS   209      11.299  61.017  88.370  1.00 66.99           N  
ATOM   1471  CA  LYS   209      10.101  61.183  89.163  1.00 67.08           C  
ATOM   1472  C   LYS   209      10.442  62.065  90.363  1.00 67.63           C  
ATOM   1473  O   LYS   209       9.660  62.929  90.753  1.00 68.29           O  
ATOM   1474  CB  LYS   209       9.571  59.823  89.628  1.00 67.18           C  
ATOM   1475  CG  LYS   209      10.561  59.017  90.444  1.00 69.08           C  
ATOM   1476  CD  LYS   209       9.873  57.923  91.265  1.00 70.30           C  
ATOM   1477  CE  LYS   209       9.260  56.820  90.403  1.00 71.66           C  
ATOM   1478  NZ  LYS   209       8.714  55.728  91.266  1.00 69.38           N  
ATOM   1479  N   GLU   210      11.619  61.861  90.943  1.00 67.64           N  
ATOM   1480  CA  GLU   210      12.026  62.665  92.086  1.00 67.63           C  
ATOM   1481  C   GLU   210      12.238  64.102  91.643  1.00 67.64           C  
ATOM   1482  O   GLU   210      11.858  65.035  92.344  1.00 68.55           O  
ATOM   1483  CB  GLU   210      13.310  62.106  92.712  1.00 67.21           C  
ATOM   1484  CG  GLU   210      13.060  60.920  93.643  1.00 67.45           C  
ATOM   1485  CD  GLU   210      14.307  60.085  93.902  1.00 67.68           C  
ATOM   1486  OE1 GLU   210      15.361  60.664  94.258  1.00 66.52           O  
ATOM   1487  OE2 GLU   210      14.225  58.843  93.758  1.00 66.77           O  
ATOM   1488  N   TRP   211      12.824  64.277  90.466  1.00 67.75           N  
ATOM   1489  CA  TRP   211      13.089  65.613  89.942  1.00 68.73           C  
ATOM   1490  C   TRP   211      11.819  66.456  89.872  1.00 71.34           C  
ATOM   1491  O   TRP   211      11.869  67.687  89.964  1.00 72.36           O  
ATOM   1492  CB  TRP   211      13.721  65.511  88.554  1.00 65.05           C  
ATOM   1493  CG  TRP   211      14.083  66.831  87.973  1.00 60.34           C  
ATOM   1494  CD1 TRP   211      13.336  67.580  87.125  1.00 58.89           C  
ATOM   1495  CD2 TRP   211      15.285  67.568  88.215  1.00 58.39           C  
ATOM   1496  NE1 TRP   211      13.999  68.744  86.818  1.00 58.58           N  
ATOM   1497  CE2 TRP   211      15.199  68.760  87.475  1.00 58.00           C  
ATOM   1498  CE3 TRP   211      16.428  67.334  88.988  1.00 57.38           C  
ATOM   1499  CZ2 TRP   211      16.208  69.717  87.479  1.00 58.40           C  
ATOM   1500  CZ3 TRP   211      17.434  68.286  88.995  1.00 56.85           C  
ATOM   1501  CH2 TRP   211      17.317  69.465  88.243  1.00 58.01           C  
ATOM   1502  N   ASN   212      10.688  65.774  89.712  1.00 72.93           N  
ATOM   1503  CA  ASN   212       9.386  66.418  89.627  1.00 73.92           C  
ATOM   1504  C   ASN   212       8.563  66.067  90.854  1.00 73.58           C  
ATOM   1505  O   ASN   212       7.333  66.089  90.820  1.00 73.75           O  
ATOM   1506  CB  ASN   212       8.656  65.933  88.383  1.00 74.55           C  
ATOM   1507  CG  ASN   212       9.569  65.839  87.190  1.00 74.30           C  
ATOM   1508  OD1 ASN   212      10.203  66.825  86.810  1.00 73.51           O  
ATOM   1509  ND2 ASN   212       9.652  64.648  86.592  1.00 72.49           N  
ATOM   1510  N   ALA   213       9.247  65.724  91.935  1.00 73.45           N  
ATOM   1511  CA  ALA   213       8.563  65.373  93.168  1.00 73.35           C  
ATOM   1512  C   ALA   213       7.355  64.485  92.894  1.00 72.17           C  
ATOM   1513  O   ALA   213       6.223  64.953  92.952  1.00 71.56           O  
ATOM   1514  CB  ALA   213       8.116  66.640  93.888  1.00 73.56           C  
ATOM   1515  N   GLN   214       7.593  63.211  92.590  1.00 71.22           N  
ATOM   1516  CA  GLN   214       6.493  62.298  92.326  1.00 70.87           C  
ATOM   1517  C   GLN   214       6.192  61.552  93.616  1.00 72.22           C  
ATOM   1518  O   GLN   214       5.205  61.922  94.309  1.00 72.70           O  
ATOM   1519  CB  GLN   214       6.866  61.306  91.215  1.00 69.86           C  
ATOM   1520  CG  GLN   214       5.807  61.144  90.105  1.00 69.07           C  
ATOM   1521  CD  GLN   214       6.185  61.828  88.777  1.00 68.53           C  
ATOM   1522  OE1 GLN   214       7.066  61.312  88.062  1.00 67.41           O  
ATOM   1523  NE2 GLN   214       5.605  62.887  88.450  1.00 66.63           N  
END
