
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   57 (  458),  selected   57 , name 3bid_B
# Molecule2: number of CA atoms   50 (  770),  selected   50 , name T0472_52_101.pdb
# PARAMETERS: 3bid_B.T0472_52_101.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_B      I      52          5.940
LGA    -       -      E      53           -
LGA    -       -      A      54           -
LGA    Y     2_B      R      55          1.633
LGA    F     3_B      Y      56          1.864
LGA    E     4_B      A      57          1.978
LGA    I     5_B      K      58          1.547
LGA    Y     6_B      E      59          1.405
LGA    K     7_B      V      60          0.497
LGA    D     8_B      A      61          1.774
LGA    A     9_B      K      62          3.283
LGA    K    10_B      N      63          3.343
LGA    G    11_B      D      64          2.536
LGA    E    12_B      K      65          0.235
LGA    Y    13_B      P      66          0.057
LGA    R    14_B      Y      67          0.070
LGA    W    15_B      F      68          0.992
LGA    R    16_B      N      69          0.841
LGA    L    17_B      L      70          0.588
LGA    K    18_B      K      71          0.726
LGA    A    19_B      A      72          0.953
LGA    A    20_B      A      73          0.774
LGA    N    21_B      N      74          2.150
LGA    H    22_B      H      75          1.868
LGA    E    23_B      Q      76          1.467
LGA    I    24_B      I      77          1.035
LGA    I    25_B      I      78          0.773
LGA    A    26_B      G      79          1.035
LGA    Q    27_B      T      80          0.781
LGA    G    28_B      S      81          0.604
LGA    E    29_B      Q      82          0.384
LGA    G    30_B      M      83          0.776
LGA    Y    31_B      Y      84          1.009
LGA    T    32_B      S      85          1.531
LGA    S    33_B      S      86          1.531
LGA    K    34_B      T      87          1.088
LGA    Q    35_B      A      88          0.955
LGA    N    36_B      A      89          1.076
LGA    C    37_B      R      90          0.450
LGA    Q    38_B      D      91          0.305
LGA    H    39_B      N      92          0.311
LGA    A    40_B      G      93          0.589
LGA    V    41_B      I      94          0.865
LGA    D    42_B      K      95          0.534
LGA    L    43_B      S      96          0.687
LGA    L    44_B      V      97          1.386
LGA    K    45_B      M      98          0.893
LGA    S    46_B      E      99          0.788
LGA    T    47_B      N     100          1.448
LGA    T    48_B      G     101           #
LGA    A    49_B      -       -           -
LGA    A    50_B      -       -           -
LGA    T    51_B      -       -           -
LGA    P    52_B      -       -           -
LGA    V    53_B      -       -           -
LGA    K    54_B      -       -           -
LGA    E    55_B      -       -           -
LGA    V    56_B      -       -           -
LGA    L    57_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   57   50    5.0     47    1.58    21.28     90.246     2.801

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.304889 * X  +   0.700312 * Y  +   0.645450 * Z  +   3.054939
  Y_new =   0.743276 * X  +   0.598702 * Y  +  -0.298491 * Z  +  -0.145934
  Z_new =  -0.595469 * X  +   0.388741 * Y  +  -0.703063 * Z  +   0.474663 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.636506   -0.505086  [ DEG:   151.0607    -28.9393 ]
  Theta =   0.637850    2.503743  [ DEG:    36.5461    143.4539 ]
  Phi   =   1.960062   -1.181531  [ DEG:   112.3033    -67.6967 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3bid_B                                        
REMARK     2: T0472_52_101.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3bid_B.T0472_52_101.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   57   50   5.0   47   1.58   21.28  90.246
REMARK  ---------------------------------------------------------- 
MOLECULE 3bid_B
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   30-NOV-07   3BID              
TITLE     CRYSTAL STRUCTURE OF THE NMB1088 PROTEIN FROM NEISSERIA               
TITLE    2 MENINGITIDIS. NORTHEAST STRUCTURAL GENOMICS CONSORTIUM               
TITLE    3 TARGET MR91                                                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UPF0339 PROTEIN NMB1088;                                   
COMPND   3 CHAIN: A, B, C, D, E, F, G, H;                                       
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: NEISSERIA MENINGITIDIS MC58;                    
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: MC58 / SEROGROUP B;                                          
SOURCE   5 GENE: NMB1088, 903505;                                               
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)+MAGIC;                           
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET21                                     
KEYWDS    ALPHA-BETA PROTEIN, STRUCTURAL GENOMICS, PSI-2, PROTEIN               
KEYWDS   2 STRUCTURE INITIATIVE, NORTHEAST STRUCTURAL GENOMICS                  
KEYWDS   3 CONSORTIUM, NESG, STRUCTURAL GENOMICS, UNKNOWN FUNCTION              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    F.FOROUHAR,H.NEELY,J.SEETHARAMAN,L.MAO,Y.FANG,R.XIAO,                 
AUTHOR   2 L.A.OWEN,M.MAGLAQUI,K.CUNNINGHAM,M.C.BARAN,T.B.ACTON,                
AUTHOR   3 G.T.MONTELIONE,L.TONG,J.F.HUNT,NORTHEAST STRUCTURAL                  
AUTHOR   4 GENOMICS CONSORTIUM (NESG)                                           
REVDAT   1   18-DEC-07 3BID    0                                                
JRNL        AUTH   F.FOROUHAR,H.NEELY,J.SEETHARAMAN,L.MAO,Y.FANG,               
JRNL        AUTH 2 R.XIAO,L.A.OWEN,M.MAGLAQUI,K.CUNNINGHAM,M.C.BARAN,           
JRNL        AUTH 3 T.B.ACTON,G.T.MONTELIONE,L.TONG,J.F.HUNT                     
JRNL        TITL   CRYSTAL STRUCTURE OF THE NMB1088 PROTEIN FROM                
JRNL        TITL 2 NEISSERIA MENINGITIDIS.                                      
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.70 ANGSTROMS.                                          
DBREF  3BID A    1    56  UNP    Q7DDI1   Y1088_NEIMB      1     56             
DBREF  3BID B    1    56  UNP    Q7DDI1   Y1088_NEIMB      1     56             
DBREF  3BID C    1    56  UNP    Q7DDI1   Y1088_NEIMB      1     56             
DBREF  3BID D    1    56  UNP    Q7DDI1   Y1088_NEIMB      1     56             
DBREF  3BID E    1    56  UNP    Q7DDI1   Y1088_NEIMB      1     56             
DBREF  3BID F    1    56  UNP    Q7DDI1   Y1088_NEIMB      1     56             
DBREF  3BID G    1    56  UNP    Q7DDI1   Y1088_NEIMB      1     56             
DBREF  3BID H    1    56  UNP    Q7DDI1   Y1088_NEIMB      1     56             
SEQRES   1 A   64  MSE TYR PHE GLU ILE TYR LYS ASP ALA LYS GLY GLU TYR          
SEQRES   2 A   64  ARG TRP ARG LEU LYS ALA ALA ASN HIS GLU ILE ILE ALA          
SEQRES   3 A   64  GLN GLY GLU GLY TYR THR SER LYS GLN ASN CYS GLN HIS          
SEQRES   4 A   64  ALA VAL ASP LEU LEU LYS SER THR THR ALA ALA THR PRO          
SEQRES   5 A   64  VAL LYS GLU VAL LEU GLU HIS HIS HIS HIS HIS HIS              
SEQRES   1 B   64  MSE TYR PHE GLU ILE TYR LYS ASP ALA LYS GLY GLU TYR          
SEQRES   2 B   64  ARG TRP ARG LEU LYS ALA ALA ASN HIS GLU ILE ILE ALA          
SEQRES   3 B   64  GLN GLY GLU GLY TYR THR SER LYS GLN ASN CYS GLN HIS          
SEQRES   4 B   64  ALA VAL ASP LEU LEU LYS SER THR THR ALA ALA THR PRO          
SEQRES   5 B   64  VAL LYS GLU VAL LEU GLU HIS HIS HIS HIS HIS HIS              
SEQRES   1 C   64  MSE TYR PHE GLU ILE TYR LYS ASP ALA LYS GLY GLU TYR          
SEQRES   2 C   64  ARG TRP ARG LEU LYS ALA ALA ASN HIS GLU ILE ILE ALA          
SEQRES   3 C   64  GLN GLY GLU GLY TYR THR SER LYS GLN ASN CYS GLN HIS          
SEQRES   4 C   64  ALA VAL ASP LEU LEU LYS SER THR THR ALA ALA THR PRO          
SEQRES   5 C   64  VAL LYS GLU VAL LEU GLU HIS HIS HIS HIS HIS HIS              
SEQRES   1 D   64  MSE TYR PHE GLU ILE TYR LYS ASP ALA LYS GLY GLU TYR          
SEQRES   2 D   64  ARG TRP ARG LEU LYS ALA ALA ASN HIS GLU ILE ILE ALA          
SEQRES   3 D   64  GLN GLY GLU GLY TYR THR SER LYS GLN ASN CYS GLN HIS          
SEQRES   4 D   64  ALA VAL ASP LEU LEU LYS SER THR THR ALA ALA THR PRO          
SEQRES   5 D   64  VAL LYS GLU VAL LEU GLU HIS HIS HIS HIS HIS HIS              
SEQRES   1 E   64  MSE TYR PHE GLU ILE TYR LYS ASP ALA LYS GLY GLU TYR          
SEQRES   2 E   64  ARG TRP ARG LEU LYS ALA ALA ASN HIS GLU ILE ILE ALA          
SEQRES   3 E   64  GLN GLY GLU GLY TYR THR SER LYS GLN ASN CYS GLN HIS          
SEQRES   4 E   64  ALA VAL ASP LEU LEU LYS SER THR THR ALA ALA THR PRO          
SEQRES   5 E   64  VAL LYS GLU VAL LEU GLU HIS HIS HIS HIS HIS HIS              
SEQRES   1 F   64  MSE TYR PHE GLU ILE TYR LYS ASP ALA LYS GLY GLU TYR          
SEQRES   2 F   64  ARG TRP ARG LEU LYS ALA ALA ASN HIS GLU ILE ILE ALA          
SEQRES   3 F   64  GLN GLY GLU GLY TYR THR SER LYS GLN ASN CYS GLN HIS          
SEQRES   4 F   64  ALA VAL ASP LEU LEU LYS SER THR THR ALA ALA THR PRO          
SEQRES   5 F   64  VAL LYS GLU VAL LEU GLU HIS HIS HIS HIS HIS HIS              
SEQRES   1 G   64  MSE TYR PHE GLU ILE TYR LYS ASP ALA LYS GLY GLU TYR          
SEQRES   2 G   64  ARG TRP ARG LEU LYS ALA ALA ASN HIS GLU ILE ILE ALA          
SEQRES   3 G   64  GLN GLY GLU GLY TYR THR SER LYS GLN ASN CYS GLN HIS          
SEQRES   4 G   64  ALA VAL ASP LEU LEU LYS SER THR THR ALA ALA THR PRO          
SEQRES   5 G   64  VAL LYS GLU VAL LEU GLU HIS HIS HIS HIS HIS HIS              
SEQRES   1 H   64  MSE TYR PHE GLU ILE TYR LYS ASP ALA LYS GLY GLU TYR          
SEQRES   2 H   64  ARG TRP ARG LEU LYS ALA ALA ASN HIS GLU ILE ILE ALA          
SEQRES   3 H   64  GLN GLY GLU GLY TYR THR SER LYS GLN ASN CYS GLN HIS          
SEQRES   4 H   64  ALA VAL ASP LEU LEU LYS SER THR THR ALA ALA THR PRO          
SEQRES   5 H   64  VAL LYS GLU VAL LEU GLU HIS HIS HIS HIS HIS HIS              
HET    MSE  A   1       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  C   1       8                                                       
HET    MSE  D   1       8                                                       
HET    MSE  E   1       8                                                       
HET    MSE  F   1       8                                                       
HET    MSE  G   1       8                                                       
HET    MSE  H   1       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    8(C5 H11 N O2 SE)                                            
FORMUL   9  HOH   *28(H2 O)                                                     
CRYST1   34.743   60.040   64.370  89.39  90.81 103.97 P 1           8          
HETATM  469  N   MSE B   1      -8.537   8.188   6.210  1.00 53.10           N  
HETATM  470  CA  MSE B   1      -7.326   7.461   5.714  1.00 52.62           C  
HETATM  471  C   MSE B   1      -6.159   7.612   6.721  1.00 49.50           C  
HETATM  472  O   MSE B   1      -5.784   8.728   7.073  1.00 47.45           O  
HETATM  473  CB  MSE B   1      -6.957   8.004   4.316  1.00 57.46           C  
HETATM  474  CG  MSE B   1      -5.995   7.119   3.486  1.00 64.96           C  
HETATM  475 SE   MSE B   1      -5.695   7.581   1.538  1.00 78.41          SE  
HETATM  476  CE  MSE B   1      -5.590   9.548   1.689  1.00 71.80           C  
ATOM    477  N   TYR B   2      -5.629   6.487   7.217  1.00 47.17           N  
ATOM    478  CA  TYR B   2      -4.493   6.503   8.149  1.00 43.52           C  
ATOM    479  C   TYR B   2      -3.664   5.221   8.099  1.00 41.99           C  
ATOM    480  O   TYR B   2      -4.157   4.160   7.709  1.00 39.50           O  
ATOM    481  CB  TYR B   2      -4.937   6.721   9.598  1.00 43.70           C  
ATOM    482  CG  TYR B   2      -5.828   5.626  10.127  1.00 46.48           C  
ATOM    483  CD1 TYR B   2      -7.178   5.576   9.776  1.00 47.25           C  
ATOM    484  CD2 TYR B   2      -5.322   4.620  10.957  1.00 47.33           C  
ATOM    485  CE1 TYR B   2      -8.007   4.557  10.234  1.00 48.65           C  
ATOM    486  CE2 TYR B   2      -6.142   3.588  11.423  1.00 48.71           C  
ATOM    487  CZ  TYR B   2      -7.491   3.567  11.053  1.00 50.41           C  
ATOM    488  OH  TYR B   2      -8.326   2.562  11.506  1.00 52.38           O  
ATOM    489  N   PHE B   3      -2.395   5.325   8.496  1.00 40.05           N  
ATOM    490  CA  PHE B   3      -1.510   4.159   8.512  1.00 37.85           C  
ATOM    491  C   PHE B   3      -1.582   3.526   9.891  1.00 38.95           C  
ATOM    492  O   PHE B   3      -1.896   4.197  10.876  1.00 39.30           O  
ATOM    493  CB  PHE B   3      -0.068   4.544   8.205  1.00 32.50           C  
ATOM    494  CG  PHE B   3       0.203   4.806   6.749  1.00 30.33           C  
ATOM    495  CD1 PHE B   3       0.136   6.093   6.231  1.00 28.39           C  
ATOM    496  CD2 PHE B   3       0.552   3.762   5.900  1.00 29.92           C  
ATOM    497  CE1 PHE B   3       0.442   6.350   4.883  1.00 27.87           C  
ATOM    498  CE2 PHE B   3       0.860   3.995   4.555  1.00 29.10           C  
ATOM    499  CZ  PHE B   3       0.798   5.297   4.047  1.00 28.44           C  
ATOM    500  N   GLU B   4      -1.283   2.233   9.963  1.00 39.35           N  
ATOM    501  CA  GLU B   4      -1.330   1.501  11.228  1.00 39.65           C  
ATOM    502  C   GLU B   4      -0.162   0.510  11.336  1.00 38.53           C  
ATOM    503  O   GLU B   4      -0.048  -0.395  10.515  1.00 37.37           O  
ATOM    504  CB  GLU B   4      -2.659   0.760  11.309  1.00 41.29           C  
ATOM    505  CG  GLU B   4      -3.068   0.297  12.683  1.00 46.20           C  
ATOM    506  CD  GLU B   4      -4.449  -0.341  12.670  1.00 52.44           C  
ATOM    507  OE1 GLU B   4      -4.621  -1.406  12.014  1.00 54.51           O  
ATOM    508  OE2 GLU B   4      -5.377   0.211  13.320  1.00 55.32           O  
ATOM    509  N   ILE B   5       0.690   0.693  12.349  1.00 35.85           N  
ATOM    510  CA  ILE B   5       1.847  -0.164  12.576  1.00 34.01           C  
ATOM    511  C   ILE B   5       1.601  -1.142  13.728  1.00 35.74           C  
ATOM    512  O   ILE B   5       1.189  -0.733  14.811  1.00 34.98           O  
ATOM    513  CB  ILE B   5       3.103   0.683  12.886  1.00 33.43           C  
ATOM    514  CG1 ILE B   5       3.432   1.551  11.694  1.00 34.27           C  
ATOM    515  CG2 ILE B   5       4.294  -0.226  13.227  1.00 33.57           C  
ATOM    516  CD1 ILE B   5       4.673   2.431  11.884  1.00 31.84           C  
ATOM    517  N   TYR B   6       1.863  -2.428  13.495  1.00 36.00           N  
ATOM    518  CA  TYR B   6       1.634  -3.446  14.518  1.00 38.10           C  
ATOM    519  C   TYR B   6       2.611  -4.611  14.424  1.00 40.56           C  
ATOM    520  O   TYR B   6       3.426  -4.667  13.516  1.00 41.11           O  
ATOM    521  CB  TYR B   6       0.207  -4.003  14.417  1.00 37.52           C  
ATOM    522  CG  TYR B   6      -0.080  -4.756  13.136  1.00 37.17           C  
ATOM    523  CD1 TYR B   6      -0.295  -4.071  11.936  1.00 34.95           C  
ATOM    524  CD2 TYR B   6      -0.079  -6.152  13.117  1.00 35.75           C  
ATOM    525  CE1 TYR B   6      -0.492  -4.755  10.743  1.00 38.64           C  
ATOM    526  CE2 TYR B   6      -0.281  -6.858  11.934  1.00 38.95           C  
ATOM    527  CZ  TYR B   6      -0.480  -6.152  10.745  1.00 41.86           C  
ATOM    528  OH  TYR B   6      -0.626  -6.838   9.551  1.00 45.37           O  
ATOM    529  N   LYS B   7       2.513  -5.547  15.363  1.00 43.94           N  
ATOM    530  CA  LYS B   7       3.382  -6.717  15.380  1.00 48.33           C  
ATOM    531  C   LYS B   7       2.518  -7.960  15.139  1.00 50.19           C  
ATOM    532  O   LYS B   7       1.566  -8.196  15.876  1.00 50.23           O  
ATOM    533  CB  LYS B   7       4.093  -6.805  16.736  1.00 50.18           C  
ATOM    534  CG  LYS B   7       4.883  -8.082  16.938  1.00 52.98           C  
ATOM    535  CD  LYS B   7       5.584  -8.139  18.290  1.00 54.45           C  
ATOM    536  CE  LYS B   7       6.666  -7.079  18.424  1.00 55.62           C  
ATOM    537  NZ  LYS B   7       7.464  -7.295  19.671  1.00 56.01           N  
ATOM    538  N   ASP B   8       2.796  -8.745  14.099  1.00 53.17           N  
ATOM    539  CA  ASP B   8       1.959  -9.926  13.840  1.00 55.43           C  
ATOM    540  C   ASP B   8       2.235 -11.098  14.779  1.00 56.20           C  
ATOM    541  O   ASP B   8       2.993 -10.962  15.743  1.00 56.81           O  
ATOM    542  CB  ASP B   8       2.064 -10.360  12.369  1.00 57.26           C  
ATOM    543  CG  ASP B   8       3.495 -10.547  11.902  1.00 59.85           C  
ATOM    544  OD1 ASP B   8       3.716 -10.564  10.668  1.00 61.62           O  
ATOM    545  OD2 ASP B   8       4.393 -10.689  12.756  1.00 62.90           O  
ATOM    546  N   ALA B   9       1.605 -12.241  14.506  1.00 56.85           N  
ATOM    547  CA  ALA B   9       1.760 -13.445  15.341  1.00 57.52           C  
ATOM    548  C   ALA B   9       3.112 -14.154  15.207  1.00 57.67           C  
ATOM    549  O   ALA B   9       3.566 -14.788  16.155  1.00 59.52           O  
ATOM    550  CB  ALA B   9       0.631 -14.433  15.045  1.00 55.60           C  
ATOM    551  N   LYS B  10       3.749 -14.032  14.043  1.00 57.15           N  
ATOM    552  CA  LYS B  10       5.035 -14.662  13.798  1.00 55.59           C  
ATOM    553  C   LYS B  10       6.149 -13.968  14.552  1.00 54.28           C  
ATOM    554  O   LYS B  10       7.139 -14.594  14.921  1.00 55.35           O  
ATOM    555  CB  LYS B  10       5.362 -14.653  12.304  1.00 57.29           C  
ATOM    556  CG  LYS B  10       4.683 -15.750  11.499  1.00 58.11           C  
ATOM    557  CD  LYS B  10       4.863 -15.550   9.997  1.00 60.34           C  
ATOM    558  CE  LYS B  10       6.323 -15.595   9.566  1.00 61.23           C  
ATOM    559  NZ  LYS B  10       6.479 -15.515   8.071  1.00 61.96           N  
ATOM    560  N   GLY B  11       5.998 -12.672  14.772  1.00 53.39           N  
ATOM    561  CA  GLY B  11       7.033 -11.941  15.481  1.00 54.06           C  
ATOM    562  C   GLY B  11       7.778 -10.879  14.683  1.00 54.33           C  
ATOM    563  O   GLY B  11       8.948 -10.609  14.969  1.00 55.26           O  
ATOM    564  N   GLU B  12       7.117 -10.270  13.696  1.00 52.79           N  
ATOM    565  CA  GLU B  12       7.736  -9.223  12.879  1.00 50.58           C  
ATOM    566  C   GLU B  12       6.849  -7.991  12.698  1.00 48.16           C  
ATOM    567  O   GLU B  12       5.628  -8.091  12.724  1.00 48.93           O  
ATOM    568  CB  GLU B  12       8.106  -9.773  11.517  1.00 52.10           C  
ATOM    569  CG  GLU B  12       6.943 -10.082  10.632  1.00 54.44           C  
ATOM    570  CD  GLU B  12       7.406 -10.880   9.454  1.00 56.61           C  
ATOM    571  OE1 GLU B  12       8.456 -10.503   8.879  1.00 54.77           O  
ATOM    572  OE2 GLU B  12       6.739 -11.885   9.108  1.00 60.07           O  
ATOM    573  N   TYR B  13       7.468  -6.833  12.498  1.00 45.29           N  
ATOM    574  CA  TYR B  13       6.738  -5.575  12.349  1.00 44.74           C  
ATOM    575  C   TYR B  13       6.167  -5.297  10.965  1.00 43.04           C  
ATOM    576  O   TYR B  13       6.840  -5.480   9.949  1.00 42.60           O  
ATOM    577  CB  TYR B  13       7.658  -4.406  12.719  1.00 48.71           C  
ATOM    578  CG  TYR B  13       8.129  -4.412  14.144  1.00 50.74           C  
ATOM    579  CD1 TYR B  13       7.273  -4.019  15.184  1.00 50.60           C  
ATOM    580  CD2 TYR B  13       9.404  -4.871  14.464  1.00 50.55           C  
ATOM    581  CE1 TYR B  13       7.678  -4.095  16.511  1.00 53.07           C  
ATOM    582  CE2 TYR B  13       9.820  -4.952  15.777  1.00 53.34           C  
ATOM    583  CZ  TYR B  13       8.958  -4.570  16.801  1.00 54.91           C  
ATOM    584  OH  TYR B  13       9.366  -4.708  18.113  1.00 57.08           O  
ATOM    585  N   ARG B  14       4.936  -4.813  10.913  1.00 41.75           N  
ATOM    586  CA  ARG B  14       4.361  -4.500   9.614  1.00 41.18           C  
ATOM    587  C   ARG B  14       3.365  -3.346   9.614  1.00 38.98           C  
ATOM    588  O   ARG B  14       2.978  -2.854  10.665  1.00 37.53           O  
ATOM    589  CB  ARG B  14       3.740  -5.753   9.013  1.00 42.17           C  
ATOM    590  CG  ARG B  14       3.030  -6.587  10.002  1.00 42.25           C  
ATOM    591  CD  ARG B  14       2.285  -7.660   9.289  1.00 47.66           C  
ATOM    592  NE  ARG B  14       3.014  -8.232   8.173  1.00 49.24           N  
ATOM    593  CZ  ARG B  14       2.491  -9.170   7.401  1.00 50.83           C  
ATOM    594  NH1 ARG B  14       3.172  -9.673   6.375  1.00 52.24           N  
ATOM    595  NH2 ARG B  14       1.270  -9.604   7.674  1.00 52.63           N  
ATOM    596  N   TRP B  15       2.965  -2.904   8.426  1.00 37.85           N  
ATOM    597  CA  TRP B  15       2.041  -1.781   8.314  1.00 38.12           C  
ATOM    598  C   TRP B  15       0.861  -2.075   7.391  1.00 38.11           C  
ATOM    599  O   TRP B  15       0.880  -3.044   6.636  1.00 37.39           O  
ATOM    600  CB  TRP B  15       2.786  -0.535   7.798  1.00 37.90           C  
ATOM    601  CG  TRP B  15       3.396  -0.721   6.417  1.00 38.43           C  
ATOM    602  CD1 TRP B  15       4.614  -1.264   6.125  1.00 37.85           C  
ATOM    603  CD2 TRP B  15       2.768  -0.451   5.151  1.00 38.75           C  
ATOM    604  NE1 TRP B  15       4.782  -1.361   4.764  1.00 37.06           N  
ATOM    605  CE2 TRP B  15       3.669  -0.872   4.141  1.00 37.83           C  
ATOM    606  CE3 TRP B  15       1.530   0.089   4.775  1.00 38.34           C  
ATOM    607  CZ2 TRP B  15       3.379  -0.754   2.780  1.00 38.74           C  
ATOM    608  CZ3 TRP B  15       1.238   0.202   3.416  1.00 39.69           C  
ATOM    609  CH2 TRP B  15       2.163  -0.222   2.435  1.00 39.56           C  
ATOM    610  N   ARG B  16      -0.161  -1.223   7.458  1.00 40.55           N  
ATOM    611  CA  ARG B  16      -1.361  -1.349   6.626  1.00 43.33           C  
ATOM    612  C   ARG B  16      -2.151  -0.027   6.619  1.00 43.75           C  
ATOM    613  O   ARG B  16      -2.321   0.613   7.664  1.00 42.10           O  
ATOM    614  CB  ARG B  16      -2.255  -2.476   7.156  1.00 45.94           C  
ATOM    615  CG  ARG B  16      -2.839  -2.206   8.536  1.00 50.44           C  
ATOM    616  CD  ARG B  16      -4.119  -3.008   8.759  1.00 55.08           C  
ATOM    617  NE  ARG B  16      -3.858  -4.398   9.113  1.00 58.95           N  
ATOM    618  CZ  ARG B  16      -3.755  -4.848  10.360  1.00 60.71           C  
ATOM    619  NH1 ARG B  16      -3.514  -6.132  10.574  1.00 61.82           N  
ATOM    620  NH2 ARG B  16      -3.890  -4.020  11.387  1.00 60.29           N  
ATOM    621  N   LEU B  17      -2.638   0.376   5.447  1.00 45.44           N  
ATOM    622  CA  LEU B  17      -3.410   1.619   5.310  1.00 47.33           C  
ATOM    623  C   LEU B  17      -4.921   1.381   5.435  1.00 49.45           C  
ATOM    624  O   LEU B  17      -5.503   0.639   4.652  1.00 49.82           O  
ATOM    625  CB  LEU B  17      -3.128   2.273   3.957  1.00 46.17           C  
ATOM    626  CG  LEU B  17      -2.685   3.745   3.958  1.00 44.52           C  
ATOM    627  CD1 LEU B  17      -2.696   4.237   2.525  1.00 45.36           C  
ATOM    628  CD2 LEU B  17      -3.610   4.600   4.795  1.00 43.48           C  
ATOM    629  N   LYS B  18      -5.551   2.017   6.414  1.00 52.46           N  
ATOM    630  CA  LYS B  18      -6.979   1.858   6.614  1.00 57.22           C  
ATOM    631  C   LYS B  18      -7.770   3.058   6.099  1.00 60.51           C  
ATOM    632  O   LYS B  18      -7.296   4.198   6.140  1.00 60.84           O  
ATOM    633  CB  LYS B  18      -7.295   1.649   8.094  1.00 57.64           C  
ATOM    634  CG  LYS B  18      -6.999   0.252   8.625  1.00 59.61           C  
ATOM    635  CD  LYS B  18      -7.340   0.166  10.116  1.00 60.60           C  
ATOM    636  CE  LYS B  18      -7.161  -1.239  10.684  1.00 60.89           C  
ATOM    637  NZ  LYS B  18      -7.430  -1.262  12.152  1.00 59.41           N  
ATOM    638  N   ALA B  19      -8.984   2.793   5.623  1.00 63.86           N  
ATOM    639  CA  ALA B  19      -9.857   3.832   5.097  1.00 67.71           C  
ATOM    640  C   ALA B  19     -10.594   4.556   6.218  1.00 70.69           C  
ATOM    641  O   ALA B  19     -10.277   4.381   7.397  1.00 72.22           O  
ATOM    642  CB  ALA B  19     -10.848   3.222   4.122  1.00 67.74           C  
ATOM    643  N   ALA B  20     -11.583   5.367   5.855  1.00 72.83           N  
ATOM    644  CA  ALA B  20     -12.354   6.118   6.848  1.00 74.74           C  
ATOM    645  C   ALA B  20     -13.135   5.203   7.792  1.00 76.23           C  
ATOM    646  O   ALA B  20     -13.232   5.481   8.989  1.00 76.43           O  
ATOM    647  CB  ALA B  20     -13.310   7.074   6.144  1.00 74.78           C  
ATOM    648  N   ASN B  21     -13.673   4.114   7.237  1.00 77.51           N  
ATOM    649  CA  ASN B  21     -14.465   3.128   7.976  1.00 78.67           C  
ATOM    650  C   ASN B  21     -13.610   2.018   8.590  1.00 80.02           C  
ATOM    651  O   ASN B  21     -14.100   0.917   8.849  1.00 80.40           O  
ATOM    652  CB  ASN B  21     -15.501   2.477   7.051  1.00 77.94           C  
ATOM    653  CG  ASN B  21     -14.876   1.475   6.078  1.00 77.91           C  
ATOM    654  OD1 ASN B  21     -14.329   1.851   5.038  1.00 76.62           O  
ATOM    655  ND2 ASN B  21     -14.945   0.190   6.428  1.00 77.73           N  
ATOM    656  N   HIS B  22     -12.332   2.303   8.812  1.00 81.25           N  
ATOM    657  CA  HIS B  22     -11.422   1.323   9.391  1.00 81.31           C  
ATOM    658  C   HIS B  22     -11.263   0.111   8.458  1.00 80.29           C  
ATOM    659  O   HIS B  22     -10.934  -0.988   8.901  1.00 81.39           O  
ATOM    660  CB  HIS B  22     -11.940   0.892  10.776  1.00 81.91           C  
ATOM    661  CG  HIS B  22     -12.046   2.021  11.761  1.00 84.26           C  
ATOM    662  ND1 HIS B  22     -12.633   1.878  13.003  1.00 84.84           N  
ATOM    663  CD2 HIS B  22     -11.642   3.313  11.687  1.00 84.94           C  
ATOM    664  CE1 HIS B  22     -12.585   3.030  13.648  1.00 84.72           C  
ATOM    665  NE2 HIS B  22     -11.989   3.918  12.872  1.00 84.74           N  
ATOM    666  N   GLU B  23     -11.479   0.325   7.160  1.00 78.46           N  
ATOM    667  CA  GLU B  23     -11.363  -0.745   6.165  1.00 77.06           C  
ATOM    668  C   GLU B  23      -9.937  -0.841   5.613  1.00 73.76           C  
ATOM    669  O   GLU B  23      -9.315   0.173   5.295  1.00 74.18           O  
ATOM    670  CB  GLU B  23     -12.341  -0.493   5.015  1.00 81.00           C  
ATOM    671  CG  GLU B  23     -13.062  -1.734   4.500  1.00 85.83           C  
ATOM    672  CD  GLU B  23     -12.135  -2.736   3.835  1.00 89.58           C  
ATOM    673  OE1 GLU B  23     -11.429  -2.348   2.878  1.00 91.62           O  
ATOM    674  OE2 GLU B  23     -12.123  -3.914   4.261  1.00 91.19           O  
ATOM    675  N   ILE B  24      -9.422  -2.060   5.491  1.00 69.42           N  
ATOM    676  CA  ILE B  24      -8.066  -2.256   4.991  1.00 64.94           C  
ATOM    677  C   ILE B  24      -7.962  -1.973   3.496  1.00 63.71           C  
ATOM    678  O   ILE B  24      -8.635  -2.614   2.687  1.00 62.99           O  
ATOM    679  CB  ILE B  24      -7.555  -3.701   5.239  1.00 62.46           C  
ATOM    680  CG1 ILE B  24      -7.483  -4.011   6.741  1.00 60.04           C  
ATOM    681  CG2 ILE B  24      -6.186  -3.863   4.627  1.00 61.98           C  
ATOM    682  CD1 ILE B  24      -7.144  -5.454   7.059  1.00 54.81           C  
ATOM    683  N   ILE B  25      -7.102  -1.021   3.135  1.00 62.04           N  
ATOM    684  CA  ILE B  25      -6.894  -0.651   1.731  1.00 60.24           C  
ATOM    685  C   ILE B  25      -5.614  -1.222   1.147  1.00 59.62           C  
ATOM    686  O   ILE B  25      -5.511  -1.399  -0.064  1.00 60.24           O  
ATOM    687  CB  ILE B  25      -6.813   0.862   1.553  1.00 60.12           C  
ATOM    688  CG1 ILE B  25      -8.138   1.495   1.987  1.00 59.75           C  
ATOM    689  CG2 ILE B  25      -6.438   1.196   0.098  1.00 59.93           C  
ATOM    690  CD1 ILE B  25      -8.172   2.997   1.856  1.00 59.09           C  
ATOM    691  N   ALA B  26      -4.626  -1.477   1.996  1.00 58.66           N  
ATOM    692  CA  ALA B  26      -3.368  -2.028   1.517  1.00 58.84           C  
ATOM    693  C   ALA B  26      -2.578  -2.668   2.653  1.00 58.95           C  
ATOM    694  O   ALA B  26      -2.597  -2.182   3.781  1.00 60.47           O  
ATOM    695  CB  ALA B  26      -2.541  -0.937   0.836  1.00 57.84           C  
ATOM    696  N   GLN B  27      -1.903  -3.773   2.350  1.00 58.91           N  
ATOM    697  CA  GLN B  27      -1.101  -4.498   3.332  1.00 58.94           C  
ATOM    698  C   GLN B  27       0.363  -4.393   2.951  1.00 59.71           C  
ATOM    699  O   GLN B  27       0.718  -4.420   1.767  1.00 59.44           O  
ATOM    700  CB  GLN B  27      -1.488  -5.984   3.370  1.00 59.39           C  
ATOM    701  CG  GLN B  27      -2.404  -6.425   4.515  1.00 59.47           C  
ATOM    702  CD  GLN B  27      -1.737  -6.384   5.894  1.00 60.39           C  
ATOM    703  OE1 GLN B  27      -0.604  -6.847   6.074  1.00 57.85           O  
ATOM    704  NE2 GLN B  27      -2.456  -5.842   6.882  1.00 61.65           N  
ATOM    705  N   GLY B  28       1.212  -4.280   3.967  1.00 60.72           N  
ATOM    706  CA  GLY B  28       2.644  -4.193   3.734  1.00 61.99           C  
ATOM    707  C   GLY B  28       3.334  -5.528   3.990  1.00 62.22           C  
ATOM    708  O   GLY B  28       2.675  -6.546   4.183  1.00 60.67           O  
ATOM    709  N   GLU B  29       4.662  -5.524   3.990  1.00 63.63           N  
ATOM    710  CA  GLU B  29       5.418  -6.733   4.229  1.00 65.77           C  
ATOM    711  C   GLU B  29       6.169  -6.616   5.544  1.00 65.80           C  
ATOM    712  O   GLU B  29       6.185  -5.553   6.174  1.00 65.90           O  
ATOM    713  CB  GLU B  29       6.399  -6.999   3.083  1.00 67.82           C  
ATOM    714  CG  GLU B  29       6.708  -8.471   2.904  1.00 72.46           C  
ATOM    715  CD  GLU B  29       5.444  -9.290   2.653  1.00 74.86           C  
ATOM    716  OE1 GLU B  29       5.505 -10.540   2.693  1.00 75.87           O  
ATOM    717  OE2 GLU B  29       4.383  -8.675   2.413  1.00 76.34           O  
ATOM    718  N   GLY B  30       6.810  -7.712   5.944  1.00 65.23           N  
ATOM    719  CA  GLY B  30       7.530  -7.752   7.209  1.00 64.58           C  
ATOM    720  C   GLY B  30       8.824  -6.982   7.360  1.00 62.69           C  
ATOM    721  O   GLY B  30       9.446  -6.563   6.392  1.00 64.50           O  
ATOM    722  N   TYR B  31       9.226  -6.798   8.608  1.00 60.92           N  
ATOM    723  CA  TYR B  31      10.455  -6.096   8.902  1.00 59.57           C  
ATOM    724  C   TYR B  31      11.105  -6.669  10.152  1.00 61.12           C  
ATOM    725  O   TYR B  31      10.464  -7.350  10.956  1.00 61.57           O  
ATOM    726  CB  TYR B  31      10.209  -4.600   9.103  1.00 56.34           C  
ATOM    727  CG  TYR B  31       9.915  -3.825   7.841  1.00 52.37           C  
ATOM    728  CD1 TYR B  31       8.625  -3.760   7.319  1.00 49.89           C  
ATOM    729  CD2 TYR B  31      10.926  -3.135   7.185  1.00 49.60           C  
ATOM    730  CE1 TYR B  31       8.352  -3.014   6.174  1.00 47.71           C  
ATOM    731  CE2 TYR B  31      10.669  -2.392   6.042  1.00 47.31           C  
ATOM    732  CZ  TYR B  31       9.382  -2.329   5.539  1.00 47.11           C  
ATOM    733  OH  TYR B  31       9.130  -1.563   4.415  1.00 43.45           O  
ATOM    734  N   THR B  32      12.389  -6.376  10.299  1.00 62.27           N  
ATOM    735  CA  THR B  32      13.182  -6.831  11.418  1.00 61.76           C  
ATOM    736  C   THR B  32      12.901  -6.047  12.696  1.00 60.35           C  
ATOM    737  O   THR B  32      12.311  -6.582  13.621  1.00 60.27           O  
ATOM    738  CB  THR B  32      14.680  -6.715  11.083  1.00 64.56           C  
ATOM    739  OG1 THR B  32      15.417  -6.481  12.291  1.00 67.46           O  
ATOM    740  CG2 THR B  32      14.923  -5.549  10.101  1.00 65.24           C  
ATOM    741  N   SER B  33      13.330  -4.788  12.741  1.00 59.56           N  
ATOM    742  CA  SER B  33      13.137  -3.937  13.916  1.00 59.79           C  
ATOM    743  C   SER B  33      11.979  -2.968  13.692  1.00 60.34           C  
ATOM    744  O   SER B  33      11.598  -2.732  12.551  1.00 60.61           O  
ATOM    745  CB  SER B  33      14.397  -3.118  14.189  1.00 59.83           C  
ATOM    746  OG  SER B  33      14.442  -1.980  13.349  1.00 58.80           O  
ATOM    747  N   LYS B  34      11.437  -2.391  14.767  1.00 60.85           N  
ATOM    748  CA  LYS B  34      10.336  -1.440  14.638  1.00 61.48           C  
ATOM    749  C   LYS B  34      10.832  -0.156  13.981  1.00 61.48           C  
ATOM    750  O   LYS B  34      10.080   0.557  13.317  1.00 61.18           O  
ATOM    751  CB  LYS B  34       9.735  -1.106  16.007  1.00 59.93           C  
ATOM    752  CG  LYS B  34       8.513  -0.209  15.905  1.00 60.54           C  
ATOM    753  CD  LYS B  34       7.909   0.094  17.257  1.00 61.77           C  
ATOM    754  CE  LYS B  34       8.767   1.064  18.043  1.00 62.04           C  
ATOM    755  NZ  LYS B  34       8.132   1.393  19.349  1.00 63.35           N  
ATOM    756  N   GLN B  35      12.114   0.126  14.168  1.00 62.87           N  
ATOM    757  CA  GLN B  35      12.716   1.322  13.617  1.00 63.83           C  
ATOM    758  C   GLN B  35      12.688   1.294  12.098  1.00 62.12           C  
ATOM    759  O   GLN B  35      12.269   2.255  11.455  1.00 62.03           O  
ATOM    760  CB  GLN B  35      14.154   1.453  14.120  1.00 67.20           C  
ATOM    761  CG  GLN B  35      14.898   2.669  13.603  1.00 73.01           C  
ATOM    762  CD  GLN B  35      14.321   3.978  14.113  1.00 76.41           C  
ATOM    763  OE1 GLN B  35      13.199   4.358  13.767  1.00 77.72           O  
ATOM    764  NE2 GLN B  35      15.084   4.669  14.957  1.00 79.38           N  
ATOM    765  N   ASN B  36      13.119   0.187  11.514  1.00 59.79           N  
ATOM    766  CA  ASN B  36      13.129   0.090  10.062  1.00 57.63           C  
ATOM    767  C   ASN B  36      11.741   0.195   9.441  1.00 55.62           C  
ATOM    768  O   ASN B  36      11.586   0.720   8.344  1.00 55.27           O  
ATOM    769  CB  ASN B  36      13.784  -1.219   9.627  1.00 58.46           C  
ATOM    770  CG  ASN B  36      15.232  -1.308  10.051  1.00 59.64           C  
ATOM    771  OD1 ASN B  36      15.997  -0.349   9.900  1.00 61.14           O  
ATOM    772  ND2 ASN B  36      15.626  -2.462  10.572  1.00 59.19           N  
ATOM    773  N   CYS B  37      10.735  -0.305  10.146  1.00 53.42           N  
ATOM    774  CA  CYS B  37       9.374  -0.276   9.645  1.00 50.59           C  
ATOM    775  C   CYS B  37       8.844   1.138   9.606  1.00 50.32           C  
ATOM    776  O   CYS B  37       8.158   1.542   8.672  1.00 48.36           O  
ATOM    777  CB  CYS B  37       8.469  -1.121  10.531  1.00 49.24           C  
ATOM    778  SG  CYS B  37       6.783  -1.278   9.911  1.00 45.90           S  
ATOM    779  N   GLN B  38       9.163   1.898  10.640  1.00 50.60           N  
ATOM    780  CA  GLN B  38       8.705   3.268  10.719  1.00 50.52           C  
ATOM    781  C   GLN B  38       9.356   4.145   9.641  1.00 47.94           C  
ATOM    782  O   GLN B  38       8.729   5.064   9.107  1.00 47.86           O  
ATOM    783  CB  GLN B  38       8.986   3.807  12.120  1.00 53.18           C  
ATOM    784  CG  GLN B  38       8.275   5.097  12.442  1.00 59.56           C  
ATOM    785  CD  GLN B  38       8.455   5.479  13.894  1.00 63.51           C  
ATOM    786  OE1 GLN B  38       8.116   4.701  14.787  1.00 65.41           O  
ATOM    787  NE2 GLN B  38       8.992   6.676  14.143  1.00 64.55           N  
ATOM    788  N   HIS B  39      10.605   3.850   9.311  1.00 45.55           N  
ATOM    789  CA  HIS B  39      11.329   4.604   8.294  1.00 42.63           C  
ATOM    790  C   HIS B  39      10.703   4.382   6.924  1.00 40.53           C  
ATOM    791  O   HIS B  39      10.590   5.315   6.136  1.00 40.34           O  
ATOM    792  CB  HIS B  39      12.799   4.173   8.294  1.00 44.61           C  
ATOM    793  CG  HIS B  39      13.678   4.981   7.389  1.00 45.68           C  
ATOM    794  ND1 HIS B  39      13.784   6.350   7.483  1.00 46.19           N  
ATOM    795  CD2 HIS B  39      14.478   4.608   6.362  1.00 46.29           C  
ATOM    796  CE1 HIS B  39      14.608   6.789   6.546  1.00 47.30           C  
ATOM    797  NE2 HIS B  39      15.041   5.752   5.853  1.00 47.97           N  
ATOM    798  N   ALA B  40      10.300   3.141   6.645  1.00 39.32           N  
ATOM    799  CA  ALA B  40       9.664   2.799   5.376  1.00 36.35           C  
ATOM    800  C   ALA B  40       8.370   3.585   5.209  1.00 35.10           C  
ATOM    801  O   ALA B  40       8.127   4.133   4.143  1.00 35.66           O  
ATOM    802  CB  ALA B  40       9.380   1.312   5.326  1.00 35.77           C  
ATOM    803  N   VAL B  41       7.561   3.656   6.266  1.00 34.22           N  
ATOM    804  CA  VAL B  41       6.300   4.382   6.208  1.00 35.70           C  
ATOM    805  C   VAL B  41       6.488   5.863   5.938  1.00 37.98           C  
ATOM    806  O   VAL B  41       5.735   6.451   5.168  1.00 38.97           O  
ATOM    807  CB  VAL B  41       5.490   4.200   7.503  1.00 37.42           C  
ATOM    808  CG1 VAL B  41       4.221   5.036   7.458  1.00 38.97           C  
ATOM    809  CG2 VAL B  41       5.125   2.727   7.690  1.00 38.40           C  
ATOM    810  N   ASP B  42       7.500   6.470   6.557  1.00 41.44           N  
ATOM    811  CA  ASP B  42       7.767   7.892   6.342  1.00 43.33           C  
ATOM    812  C   ASP B  42       8.161   8.155   4.893  1.00 42.29           C  
ATOM    813  O   ASP B  42       7.793   9.187   4.316  1.00 41.99           O  
ATOM    814  CB  ASP B  42       8.871   8.400   7.284  1.00 48.50           C  
ATOM    815  CG  ASP B  42       8.415   8.477   8.739  1.00 53.73           C  
ATOM    816  OD1 ASP B  42       7.297   9.002   8.999  1.00 56.00           O  
ATOM    817  OD2 ASP B  42       9.180   8.033   9.632  1.00 56.79           O  
ATOM    818  N   LEU B  43       8.917   7.234   4.302  1.00 41.58           N  
ATOM    819  CA  LEU B  43       9.325   7.394   2.903  1.00 42.30           C  
ATOM    820  C   LEU B  43       8.116   7.282   1.965  1.00 41.68           C  
ATOM    821  O   LEU B  43       8.006   8.044   1.001  1.00 41.28           O  
ATOM    822  CB  LEU B  43      10.390   6.352   2.531  1.00 41.88           C  
ATOM    823  CG  LEU B  43      11.800   6.674   3.080  1.00 41.69           C  
ATOM    824  CD1 LEU B  43      12.703   5.455   2.956  1.00 42.66           C  
ATOM    825  CD2 LEU B  43      12.385   7.860   2.337  1.00 38.43           C  
ATOM    826  N   LEU B  44       7.210   6.347   2.254  1.00 40.46           N  
ATOM    827  CA  LEU B  44       6.018   6.174   1.440  1.00 39.61           C  
ATOM    828  C   LEU B  44       5.178   7.431   1.467  1.00 41.12           C  
ATOM    829  O   LEU B  44       4.729   7.903   0.426  1.00 42.27           O  
ATOM    830  CB  LEU B  44       5.181   5.008   1.948  1.00 37.91           C  
ATOM    831  CG  LEU B  44       5.575   3.626   1.439  1.00 37.19           C  
ATOM    832  CD1 LEU B  44       4.925   2.567   2.302  1.00 36.94           C  
ATOM    833  CD2 LEU B  44       5.156   3.485  -0.020  1.00 37.12           C  
ATOM    834  N   LYS B  45       4.961   7.986   2.652  1.00 41.92           N  
ATOM    835  CA  LYS B  45       4.148   9.190   2.749  1.00 43.52           C  
ATOM    836  C   LYS B  45       4.836  10.457   2.228  1.00 44.67           C  
ATOM    837  O   LYS B  45       4.177  11.473   2.007  1.00 44.06           O  
ATOM    838  CB  LYS B  45       3.672   9.389   4.192  1.00 46.65           C  
ATOM    839  CG  LYS B  45       4.775   9.405   5.221  1.00 49.74           C  
ATOM    840  CD  LYS B  45       4.219   9.204   6.630  1.00 49.51           C  
ATOM    841  CE  LYS B  45       3.304  10.333   7.037  1.00 48.23           C  
ATOM    842  NZ  LYS B  45       3.131  10.323   8.501  1.00 48.40           N  
ATOM    843  N   SER B  46       6.150  10.408   2.021  1.00 45.45           N  
ATOM    844  CA  SER B  46       6.852  11.576   1.499  1.00 45.69           C  
ATOM    845  C   SER B  46       6.753  11.536  -0.023  1.00 44.93           C  
ATOM    846  O   SER B  46       7.223  12.442  -0.707  1.00 43.42           O  
ATOM    847  CB  SER B  46       8.328  11.570   1.902  1.00 44.89           C  
ATOM    848  OG  SER B  46       9.061  10.666   1.104  1.00 47.95           O  
ATOM    849  N   THR B  47       6.171  10.453  -0.536  1.00 44.71           N  
ATOM    850  CA  THR B  47       5.967  10.238  -1.970  1.00 46.61           C  
ATOM    851  C   THR B  47       4.875  11.162  -2.506  1.00 47.15           C  
ATOM    852  O   THR B  47       3.818  11.306  -1.893  1.00 47.20           O  
ATOM    853  CB  THR B  47       5.512   8.796  -2.251  1.00 46.81           C  
ATOM    854  OG1 THR B  47       6.652   7.937  -2.346  1.00 48.88           O  
ATOM    855  CG2 THR B  47       4.714   8.730  -3.527  1.00 49.41           C  
ATOM    856  N   THR B  48       5.105  11.753  -3.671  1.00 47.79           N  
ATOM    857  CA  THR B  48       4.129  12.673  -4.247  1.00 49.10           C  
ATOM    858  C   THR B  48       3.419  12.102  -5.488  1.00 48.89           C  
ATOM    859  O   THR B  48       3.667  10.963  -5.879  1.00 49.28           O  
ATOM    860  CB  THR B  48       4.829  14.019  -4.586  1.00 50.20           C  
ATOM    861  OG1 THR B  48       3.862  14.966  -5.041  1.00 54.28           O  
ATOM    862  CG2 THR B  48       5.900  13.823  -5.656  1.00 48.42           C  
ATOM    863  N   ALA B  49       2.525  12.879  -6.092  1.00 47.81           N  
ATOM    864  CA  ALA B  49       1.811  12.419  -7.282  1.00 47.79           C  
ATOM    865  C   ALA B  49       2.708  12.552  -8.511  1.00 47.50           C  
ATOM    866  O   ALA B  49       2.300  12.258  -9.634  1.00 47.46           O  
ATOM    867  CB  ALA B  49       0.529  13.219  -7.471  1.00 48.02           C  
ATOM    868  N   ALA B  50       3.937  13.001  -8.277  1.00 46.46           N  
ATOM    869  CA  ALA B  50       4.937  13.155  -9.326  1.00 43.79           C  
ATOM    870  C   ALA B  50       5.955  11.993  -9.253  1.00 42.93           C  
ATOM    871  O   ALA B  50       6.980  12.010  -9.934  1.00 42.19           O  
ATOM    872  CB  ALA B  50       5.643  14.499  -9.174  1.00 44.81           C  
ATOM    873  N   THR B  51       5.684  10.996  -8.409  1.00 41.33           N  
ATOM    874  CA  THR B  51       6.557   9.825  -8.303  1.00 39.42           C  
ATOM    875  C   THR B  51       6.160   8.878  -9.450  1.00 37.73           C  
ATOM    876  O   THR B  51       5.008   8.413  -9.526  1.00 35.90           O  
ATOM    877  CB  THR B  51       6.374   9.090  -6.938  1.00 40.75           C  
ATOM    878  OG1 THR B  51       6.862   9.919  -5.876  1.00 43.79           O  
ATOM    879  CG2 THR B  51       7.132   7.775  -6.922  1.00 39.10           C  
ATOM    880  N   PRO B  52       7.104   8.596 -10.364  1.00 35.73           N  
ATOM    881  CA  PRO B  52       6.897   7.721 -11.523  1.00 36.39           C  
ATOM    882  C   PRO B  52       6.452   6.276 -11.213  1.00 38.01           C  
ATOM    883  O   PRO B  52       6.870   5.690 -10.210  1.00 37.87           O  
ATOM    884  CB  PRO B  52       8.245   7.802 -12.249  1.00 35.42           C  
ATOM    885  CG  PRO B  52       9.221   8.145 -11.155  1.00 32.78           C  
ATOM    886  CD  PRO B  52       8.475   9.132 -10.336  1.00 34.17           C  
ATOM    887  N   VAL B  53       5.593   5.716 -12.071  1.00 39.13           N  
ATOM    888  CA  VAL B  53       5.082   4.342 -11.916  1.00 38.58           C  
ATOM    889  C   VAL B  53       5.534   3.582 -13.157  1.00 38.63           C  
ATOM    890  O   VAL B  53       5.085   3.877 -14.261  1.00 40.42           O  
ATOM    891  CB  VAL B  53       3.533   4.324 -11.817  1.00 37.97           C  
ATOM    892  CG1 VAL B  53       3.035   2.958 -11.326  1.00 37.39           C  
ATOM    893  CG2 VAL B  53       3.077   5.414 -10.865  1.00 38.35           C  
ATOM    894  N   LYS B  54       6.420   2.606 -12.961  1.00 37.91           N  
ATOM    895  CA  LYS B  54       6.996   1.833 -14.058  1.00 38.35           C  
ATOM    896  C   LYS B  54       6.658   0.343 -14.035  1.00 40.43           C  
ATOM    897  O   LYS B  54       6.618  -0.288 -12.974  1.00 40.06           O  
ATOM    898  CB  LYS B  54       8.530   1.975 -14.052  1.00 38.23           C  
ATOM    899  CG  LYS B  54       9.099   3.352 -14.420  1.00 37.30           C  
ATOM    900  CD  LYS B  54      10.600   3.469 -14.037  1.00 37.10           C  
ATOM    901  CE  LYS B  54      11.203   4.858 -14.384  1.00 37.60           C  
ATOM    902  NZ  LYS B  54      12.499   5.207 -13.692  1.00 35.68           N  
ATOM    903  N   GLU B  55       6.437  -0.227 -15.215  1.00 43.08           N  
ATOM    904  CA  GLU B  55       6.133  -1.649 -15.309  1.00 44.22           C  
ATOM    905  C   GLU B  55       7.216  -2.397 -16.099  1.00 44.09           C  
ATOM    906  O   GLU B  55       7.622  -1.983 -17.185  1.00 43.89           O  
ATOM    907  CB  GLU B  55       4.729  -1.845 -15.918  1.00 45.62           C  
ATOM    908  CG  GLU B  55       4.494  -3.202 -16.604  1.00 49.95           C  
ATOM    909  CD  GLU B  55       3.013  -3.548 -16.801  1.00 53.79           C  
ATOM    910  OE1 GLU B  55       2.323  -3.842 -15.797  1.00 55.67           O  
ATOM    911  OE2 GLU B  55       2.525  -3.544 -17.958  1.00 54.95           O  
ATOM    912  N   VAL B  56       7.687  -3.488 -15.495  1.00 44.21           N  
ATOM    913  CA  VAL B  56       8.711  -4.384 -16.042  1.00 44.90           C  
ATOM    914  C   VAL B  56       8.070  -5.270 -17.122  1.00 47.18           C  
ATOM    915  O   VAL B  56       7.192  -6.086 -16.830  1.00 46.62           O  
ATOM    916  CB  VAL B  56       9.266  -5.348 -14.938  1.00 44.47           C  
ATOM    917  CG1 VAL B  56      10.243  -6.347 -15.527  1.00 42.94           C  
ATOM    918  CG2 VAL B  56       9.911  -4.552 -13.829  1.00 43.66           C  
ATOM    919  N   LEU B  57       8.507  -5.114 -18.363  1.00 48.47           N  
ATOM    920  CA  LEU B  57       7.976  -5.914 -19.443  1.00 49.16           C  
ATOM    921  C   LEU B  57       9.128  -6.602 -20.123  1.00 50.21           C  
ATOM    922  O   LEU B  57       9.017  -7.810 -20.437  1.00 52.94           O  
ATOM    923  CB  LEU B  57       7.203  -5.043 -20.427  1.00 47.88           C  
ATOM    924  CG  LEU B  57       7.916  -3.856 -21.051  1.00 47.34           C  
ATOM    925  CD1 LEU B  57       8.815  -4.315 -22.180  1.00 48.07           C  
ATOM    926  CD2 LEU B  57       6.880  -2.876 -21.588  1.00 47.75           C  
TER     927      LEU B  57                                                      
END
MOLECULE T0472_52_101.pdb
ATOM    761  N   ILE    52      -2.934  12.060   6.624  1.00 63.31           N  
ATOM    762  CA  ILE    52      -3.784  11.757   7.784  1.00 50.41           C  
ATOM    763  C   ILE    52      -3.355  10.443   8.462  1.00 25.20           C  
ATOM    764  O   ILE    52      -3.842   9.360   8.129  1.00 63.43           O  
ATOM    765  CB  ILE    52      -5.278  11.668   7.377  1.00 40.10           C  
ATOM    766  CG1 ILE    52      -5.698  12.940   6.620  1.00  0.32           C  
ATOM    767  CG2 ILE    52      -6.164  11.454   8.609  1.00 13.31           C  
ATOM    768  CD1 ILE    52      -7.110  12.896   6.077  1.00 14.20           C  
ATOM    769  H   ILE    52      -3.093  11.580   5.783  1.00 37.41           H  
ATOM    770  HA  ILE    52      -3.676  12.566   8.495  1.00 14.31           H  
ATOM    771  HB  ILE    52      -5.400  10.815   6.724  1.00 21.03           H  
ATOM    772 HG12 ILE    52      -5.629  13.789   7.286  1.00 37.41           H  
ATOM    773 HG13 ILE    52      -5.028  13.093   5.785  1.00 37.41           H  
ATOM    774 HG21 ILE    52      -7.198  11.378   8.302  1.00 37.41           H  
ATOM    775 HG22 ILE    52      -6.052  12.289   9.286  1.00 37.41           H  
ATOM    776 HG23 ILE    52      -5.871  10.544   9.112  1.00 37.41           H  
ATOM    777 HD11 ILE    52      -7.214  12.053   5.411  1.00 37.41           H  
ATOM    778 HD12 ILE    52      -7.315  13.809   5.536  1.00 37.41           H  
ATOM    779 HD13 ILE    52      -7.809  12.800   6.895  1.00 37.41           H  
ATOM    780  N   GLU    53      -2.443  10.555   9.420  1.00 72.33           N  
ATOM    781  CA  GLU    53      -1.867   9.387  10.096  1.00 21.33           C  
ATOM    782  C   GLU    53      -2.934   8.548  10.821  1.00 13.30           C  
ATOM    783  O   GLU    53      -2.792   7.338  10.955  1.00 61.14           O  
ATOM    784  CB  GLU    53      -0.784   9.844  11.084  1.00 51.10           C  
ATOM    785  CG  GLU    53       0.329  10.658  10.428  1.00 41.41           C  
ATOM    786  CD  GLU    53       1.350  11.177  11.426  1.00 31.52           C  
ATOM    787  OE1 GLU    53       1.045  12.161  12.134  1.00  0.22           O  
ATOM    788  OE2 GLU    53       2.465  10.618  11.496  1.00  0.21           O  
ATOM    789  H   GLU    53      -2.141  11.450   9.680  1.00 37.41           H  
ATOM    790  HA  GLU    53      -1.404   8.769   9.339  1.00 44.53           H  
ATOM    791  HB2 GLU    53      -1.244  10.453  11.851  1.00 37.41           H  
ATOM    792  HB3 GLU    53      -0.341   8.974  11.544  1.00 37.41           H  
ATOM    793  HG2 GLU    53       0.836  10.035   9.706  1.00 37.41           H  
ATOM    794  HG3 GLU    53      -0.114  11.504   9.916  1.00 37.41           H  
ATOM    795  N   ALA    54      -4.022   9.183  11.247  1.00 24.34           N  
ATOM    796  CA  ALA    54      -5.102   8.486  11.969  1.00 14.52           C  
ATOM    797  C   ALA    54      -5.685   7.291  11.178  1.00 12.03           C  
ATOM    798  O   ALA    54      -6.469   6.504  11.715  1.00  2.10           O  
ATOM    799  CB  ALA    54      -6.208   9.475  12.319  1.00 10.14           C  
ATOM    800  H   ALA    54      -4.106  10.145  11.077  1.00 37.41           H  
ATOM    801  HA  ALA    54      -4.687   8.113  12.895  1.00 21.34           H  
ATOM    802  HB1 ALA    54      -6.973   8.974  12.895  1.00 37.41           H  
ATOM    803  HB2 ALA    54      -6.642   9.870  11.411  1.00 37.41           H  
ATOM    804  HB3 ALA    54      -5.795  10.285  12.902  1.00 37.41           H  
ATOM    805  N   ARG    55      -5.296   7.162   9.909  1.00 23.25           N  
ATOM    806  CA  ARG    55      -5.814   6.110   9.026  1.00  2.54           C  
ATOM    807  C   ARG    55      -4.950   4.826   9.031  1.00 53.14           C  
ATOM    808  O   ARG    55      -5.335   3.821   8.422  1.00  4.12           O  
ATOM    809  CB  ARG    55      -5.915   6.660   7.594  1.00  4.02           C  
ATOM    810  CG  ARG    55      -6.858   7.855   7.453  1.00 31.02           C  
ATOM    811  CD  ARG    55      -8.317   7.454   7.646  1.00 42.40           C  
ATOM    812  NE  ARG    55      -9.220   8.609   7.648  1.00 62.02           N  
ATOM    813  CZ  ARG    55      -9.855   9.054   6.595  1.00 64.32           C  
ATOM    814  NH1 ARG    55      -9.613   8.568   5.418  1.00 51.52           N  
ATOM    815  NH2 ARG    55     -10.707  10.018   6.710  1.00  4.11           N  
ATOM    816  H   ARG    55      -4.647   7.803   9.547  1.00 37.41           H  
ATOM    817  HA  ARG    55      -6.806   5.852   9.367  1.00 22.42           H  
ATOM    818  HB2 ARG    55      -4.931   6.969   7.270  1.00 37.41           H  
ATOM    819  HB3 ARG    55      -6.266   5.872   6.942  1.00 37.41           H  
ATOM    820  HG2 ARG    55      -6.597   8.596   8.194  1.00 37.41           H  
ATOM    821  HG3 ARG    55      -6.738   8.278   6.465  1.00 37.41           H  
ATOM    822  HD2 ARG    55      -8.603   6.785   6.846  1.00 37.41           H  
ATOM    823  HD3 ARG    55      -8.412   6.937   8.591  1.00 37.41           H  
ATOM    824  HE  ARG    55      -9.383   9.052   8.504  1.00 72.15           H  
ATOM    825 HH11 ARG    55      -8.932   7.849   5.304  1.00 37.41           H  
ATOM    826 HH12 ARG    55     -10.090   8.937   4.622  1.00 37.41           H  
ATOM    827 HH21 ARG    55     -10.872  10.437   7.602  1.00 37.41           H  
ATOM    828 HH22 ARG    55     -11.209  10.336   5.909  1.00 37.41           H  
ATOM    829  N   TYR    56      -3.797   4.843   9.711  1.00 35.41           N  
ATOM    830  CA  TYR    56      -2.880   3.687   9.684  1.00 62.05           C  
ATOM    831  C   TYR    56      -3.367   2.524  10.568  1.00 22.13           C  
ATOM    832  O   TYR    56      -4.337   2.646  11.320  1.00  5.52           O  
ATOM    833  CB  TYR    56      -1.437   4.088  10.092  1.00 63.32           C  
ATOM    834  CG  TYR    56      -1.219   4.439  11.573  1.00 62.22           C  
ATOM    835  CD1 TYR    56      -1.370   3.484  12.580  1.00 51.22           C  
ATOM    836  CD2 TYR    56      -0.851   5.723  11.957  1.00 14.01           C  
ATOM    837  CE1 TYR    56      -1.166   3.802  13.910  1.00 53.41           C  
ATOM    838  CE2 TYR    56      -0.643   6.048  13.285  1.00 42.30           C  
ATOM    839  CZ  TYR    56      -0.806   5.085  14.258  1.00  0.02           C  
ATOM    840  OH  TYR    56      -0.602   5.404  15.582  1.00  0.11           O  
ATOM    841  H   TYR    56      -3.558   5.637  10.234  1.00 37.41           H  
ATOM    842  HA  TYR    56      -2.854   3.333   8.662  1.00  0.43           H  
ATOM    843  HB2 TYR    56      -0.772   3.270   9.857  1.00 37.41           H  
ATOM    844  HB3 TYR    56      -1.144   4.949   9.504  1.00 37.41           H  
ATOM    845  HD1 TYR    56      -1.650   2.476  12.309  1.00 50.32           H  
ATOM    846  HD2 TYR    56      -0.728   6.479  11.196  1.00 34.13           H  
ATOM    847  HE1 TYR    56      -1.292   3.045  14.671  1.00 51.01           H  
ATOM    848  HE2 TYR    56      -0.357   7.055  13.556  1.00 22.30           H  
ATOM    849  HH  TYR    56      -1.043   6.241  15.780  1.00 14.22           H  
ATOM    850  N   ALA    57      -2.675   1.391  10.455  1.00 63.32           N  
ATOM    851  CA  ALA    57      -2.859   0.254  11.362  1.00 25.11           C  
ATOM    852  C   ALA    57      -1.529  -0.491  11.565  1.00 35.11           C  
ATOM    853  O   ALA    57      -1.122  -1.294  10.727  1.00 54.01           O  
ATOM    854  CB  ALA    57      -3.927  -0.689  10.819  1.00 23.24           C  
ATOM    855  H   ALA    57      -2.032   1.307   9.719  1.00 37.41           H  
ATOM    856  HA  ALA    57      -3.197   0.636  12.317  1.00 52.10           H  
ATOM    857  HB1 ALA    57      -3.598  -1.103   9.877  1.00 37.41           H  
ATOM    858  HB2 ALA    57      -4.848  -0.143  10.669  1.00 37.41           H  
ATOM    859  HB3 ALA    57      -4.096  -1.490  11.523  1.00 37.41           H  
ATOM    860  N   LYS    58      -0.855  -0.228  12.680  1.00 61.02           N  
ATOM    861  CA  LYS    58       0.480  -0.794  12.932  1.00 63.12           C  
ATOM    862  C   LYS    58       0.402  -2.075  13.776  1.00 14.20           C  
ATOM    863  O   LYS    58      -0.132  -2.075  14.888  1.00 64.40           O  
ATOM    864  CB  LYS    58       1.371   0.253  13.618  1.00 42.34           C  
ATOM    865  CG  LYS    58       1.675   1.467  12.739  1.00 42.51           C  
ATOM    866  CD  LYS    58       2.283   2.619  13.539  1.00 64.53           C  
ATOM    867  CE  LYS    58       3.613   2.243  14.180  1.00 34.10           C  
ATOM    868  NZ  LYS    58       4.138   3.339  15.033  1.00 51.24           N  
ATOM    869  H   LYS    58      -1.264   0.352  13.358  1.00 37.41           H  
ATOM    870  HA  LYS    58       0.917  -1.043  11.973  1.00  1.11           H  
ATOM    871  HB2 LYS    58       0.875   0.597  14.516  1.00 37.41           H  
ATOM    872  HB3 LYS    58       2.309  -0.210  13.892  1.00 37.41           H  
ATOM    873  HG2 LYS    58       2.374   1.173  11.967  1.00 37.41           H  
ATOM    874  HG3 LYS    58       0.756   1.805  12.279  1.00 37.41           H  
ATOM    875  HD2 LYS    58       2.443   3.457  12.875  1.00 37.41           H  
ATOM    876  HD3 LYS    58       1.589   2.909  14.316  1.00 37.41           H  
ATOM    877  HE2 LYS    58       3.471   1.363  14.790  1.00 37.41           H  
ATOM    878  HE3 LYS    58       4.331   2.030  13.400  1.00 37.41           H  
ATOM    879  HZ1 LYS    58       3.486   3.520  15.827  1.00 37.41           H  
ATOM    880  HZ2 LYS    58       4.241   4.211  14.480  1.00 37.41           H  
ATOM    881  HZ3 LYS    58       5.069   3.079  15.421  1.00 37.41           H  
ATOM    882  N   GLU    59       0.949  -3.169  13.247  1.00 44.24           N  
ATOM    883  CA  GLU    59       0.882  -4.471  13.919  1.00 11.42           C  
ATOM    884  C   GLU    59       2.249  -5.175  13.923  1.00 44.23           C  
ATOM    885  O   GLU    59       3.090  -4.945  13.051  1.00 51.02           O  
ATOM    886  CB  GLU    59      -0.167  -5.358  13.225  1.00 62.32           C  
ATOM    887  CG  GLU    59      -0.394  -6.708  13.903  1.00 71.31           C  
ATOM    888  CD  GLU    59      -0.917  -6.575  15.325  1.00 71.05           C  
ATOM    889  OE1 GLU    59      -2.147  -6.439  15.499  1.00 51.51           O  
ATOM    890  OE2 GLU    59      -0.103  -6.593  16.271  1.00 64.11           O  
ATOM    891  H   GLU    59       1.413  -3.103  12.385  1.00 37.41           H  
ATOM    892  HA  GLU    59       0.577  -4.303  14.942  1.00 22.01           H  
ATOM    893  HB2 GLU    59      -1.109  -4.828  13.205  1.00 37.41           H  
ATOM    894  HB3 GLU    59       0.150  -5.540  12.207  1.00 37.41           H  
ATOM    895  HG2 GLU    59      -1.109  -7.273  13.323  1.00 37.41           H  
ATOM    896  HG3 GLU    59       0.546  -7.245  13.929  1.00 37.41           H  
ATOM    897  N   VAL    60       2.470  -6.027  14.921  1.00 22.32           N  
ATOM    898  CA  VAL    60       3.696  -6.824  15.010  1.00 64.53           C  
ATOM    899  C   VAL    60       3.366  -8.299  15.279  1.00 53.14           C  
ATOM    900  O   VAL    60       2.798  -8.636  16.319  1.00 43.34           O  
ATOM    901  CB  VAL    60       4.643  -6.309  16.126  1.00  2.12           C  
ATOM    902  CG1 VAL    60       5.908  -7.164  16.200  1.00 11.45           C  
ATOM    903  CG2 VAL    60       4.996  -4.836  15.909  1.00 31.41           C  
ATOM    904  H   VAL    60       1.784  -6.130  15.617  1.00 37.41           H  
ATOM    905  HA  VAL    60       4.215  -6.749  14.063  1.00  5.34           H  
ATOM    906  HB  VAL    60       4.126  -6.394  17.073  1.00 53.30           H  
ATOM    907 HG11 VAL    60       5.637  -8.192  16.393  1.00 37.41           H  
ATOM    908 HG12 VAL    60       6.540  -6.805  17.000  1.00 37.41           H  
ATOM    909 HG13 VAL    60       6.444  -7.102  15.264  1.00 37.41           H  
ATOM    910 HG21 VAL    60       5.634  -4.496  16.714  1.00 37.41           H  
ATOM    911 HG22 VAL    60       4.091  -4.247  15.895  1.00 37.41           H  
ATOM    912 HG23 VAL    60       5.515  -4.722  14.968  1.00 37.41           H  
ATOM    913  N   ALA    61       3.723  -9.170  14.340  1.00 74.01           N  
ATOM    914  CA  ALA    61       3.468 -10.608  14.478  1.00 71.43           C  
ATOM    915  C   ALA    61       4.192 -11.201  15.705  1.00 65.35           C  
ATOM    916  O   ALA    61       5.224 -10.684  16.135  1.00 53.45           O  
ATOM    917  CB  ALA    61       3.892 -11.333  13.206  1.00 74.24           C  
ATOM    918  H   ALA    61       4.166  -8.839  13.528  1.00 37.41           H  
ATOM    919  HA  ALA    61       2.402 -10.745  14.602  1.00 31.41           H  
ATOM    920  HB1 ALA    61       3.608 -12.373  13.269  1.00 37.41           H  
ATOM    921  HB2 ALA    61       4.964 -11.260  13.091  1.00 37.41           H  
ATOM    922  HB3 ALA    61       3.409 -10.879  12.353  1.00 37.41           H  
ATOM    923  N   LYS    62       3.656 -12.300  16.248  1.00  4.44           N  
ATOM    924  CA  LYS    62       4.209 -12.923  17.465  1.00 11.40           C  
ATOM    925  C   LYS    62       5.685 -13.343  17.306  1.00 52.00           C  
ATOM    926  O   LYS    62       6.385 -13.549  18.295  1.00 60.32           O  
ATOM    927  CB  LYS    62       3.332 -14.116  17.908  1.00 35.24           C  
ATOM    928  CG  LYS    62       2.962 -15.109  16.797  1.00 32.32           C  
ATOM    929  CD  LYS    62       4.130 -15.996  16.364  1.00 21.23           C  
ATOM    930  CE  LYS    62       4.682 -16.823  17.517  1.00 32.35           C  
ATOM    931  NZ  LYS    62       5.716 -17.788  17.058  1.00 41.43           N  
ATOM    932  H   LYS    62       2.867 -12.701  15.824  1.00 37.41           H  
ATOM    933  HA  LYS    62       4.165 -12.173  18.244  1.00 22.23           H  
ATOM    934  HB2 LYS    62       3.853 -14.661  18.682  1.00 37.41           H  
ATOM    935  HB3 LYS    62       2.413 -13.726  18.325  1.00 37.41           H  
ATOM    936  HG2 LYS    62       2.164 -15.745  17.155  1.00 37.41           H  
ATOM    937  HG3 LYS    62       2.610 -14.551  15.939  1.00 37.41           H  
ATOM    938  HD2 LYS    62       3.790 -16.667  15.588  1.00 37.41           H  
ATOM    939  HD3 LYS    62       4.919 -15.370  15.972  1.00 37.41           H  
ATOM    940  HE2 LYS    62       5.123 -16.157  18.243  1.00 37.41           H  
ATOM    941  HE3 LYS    62       3.870 -17.369  17.977  1.00 37.41           H  
ATOM    942  HZ1 LYS    62       6.100 -18.314  17.871  1.00 37.41           H  
ATOM    943  HZ2 LYS    62       6.495 -17.286  16.585  1.00 37.41           H  
ATOM    944  HZ3 LYS    62       5.301 -18.465  16.385  1.00 37.41           H  
ATOM    945  N   ASN    63       6.149 -13.463  16.062  1.00 21.24           N  
ATOM    946  CA  ASN    63       7.566 -13.751  15.782  1.00 12.32           C  
ATOM    947  C   ASN    63       8.383 -12.441  15.702  1.00 33.24           C  
ATOM    948  O   ASN    63       9.455 -12.395  15.101  1.00  2.24           O  
ATOM    949  CB  ASN    63       7.668 -14.554  14.471  1.00 62.24           C  
ATOM    950  CG  ASN    63       9.074 -15.056  14.164  1.00 20.31           C  
ATOM    951  OD1 ASN    63       9.485 -16.114  14.623  1.00 45.23           O  
ATOM    952  ND2 ASN    63       9.818 -14.312  13.374  1.00 10.10           N  
ATOM    953  H   ASN    63       5.524 -13.370  15.311  1.00 37.41           H  
ATOM    954  HA  ASN    63       7.952 -14.351  16.596  1.00 40.40           H  
ATOM    955  HB2 ASN    63       7.016 -15.413  14.538  1.00 37.41           H  
ATOM    956  HB3 ASN    63       7.342 -13.932  13.647  1.00 37.41           H  
ATOM    957 HD21 ASN    63       9.442 -13.479  13.028  1.00 37.41           H  
ATOM    958 HD22 ASN    63      10.721 -14.626  13.165  1.00 37.41           H  
ATOM    959  N   ASP    64       7.867 -11.379  16.331  1.00 12.21           N  
ATOM    960  CA  ASP    64       8.514 -10.058  16.313  1.00 33.52           C  
ATOM    961  C   ASP    64       8.675  -9.521  14.882  1.00 53.51           C  
ATOM    962  O   ASP    64       9.686  -8.898  14.546  1.00 41.44           O  
ATOM    963  CB  ASP    64       9.872 -10.114  17.026  1.00 11.12           C  
ATOM    964  CG  ASP    64       9.731 -10.181  18.532  1.00 25.43           C  
ATOM    965  OD1 ASP    64       9.576  -9.113  19.163  1.00 53.53           O  
ATOM    966  OD2 ASP    64       9.775 -11.295  19.093  1.00 55.32           O  
ATOM    967  H   ASP    64       7.030 -11.487  16.826  1.00 37.41           H  
ATOM    968  HA  ASP    64       7.868  -9.381  16.853  1.00 71.24           H  
ATOM    969  HB2 ASP    64      10.411 -10.990  16.690  1.00 37.41           H  
ATOM    970  HB3 ASP    64      10.444  -9.232  16.774  1.00 37.41           H  
ATOM    971  N   LYS    65       7.662  -9.755  14.048  1.00 61.14           N  
ATOM    972  CA  LYS    65       7.666  -9.274  12.660  1.00 32.24           C  
ATOM    973  C   LYS    65       6.824  -7.992  12.531  1.00 33.22           C  
ATOM    974  O   LYS    65       5.593  -8.050  12.518  1.00 61.02           O  
ATOM    975  CB  LYS    65       7.113 -10.358  11.721  1.00 71.43           C  
ATOM    976  CG  LYS    65       7.740 -11.735  11.933  1.00 12.12           C  
ATOM    977  CD  LYS    65       7.122 -12.797  11.024  1.00 54.43           C  
ATOM    978  CE  LYS    65       7.477 -12.578   9.556  1.00 71.11           C  
ATOM    979  NZ  LYS    65       8.943 -12.627   9.316  1.00 13.30           N  
ATOM    980  H   LYS    65       6.892 -10.263  14.373  1.00 37.41           H  
ATOM    981  HA  LYS    65       8.687  -9.055  12.380  1.00 74.43           H  
ATOM    982  HB2 LYS    65       6.046 -10.444  11.878  1.00 37.41           H  
ATOM    983  HB3 LYS    65       7.291 -10.057  10.697  1.00 37.41           H  
ATOM    984  HG2 LYS    65       8.799 -11.672  11.725  1.00 37.41           H  
ATOM    985  HG3 LYS    65       7.595 -12.028  12.964  1.00 37.41           H  
ATOM    986  HD2 LYS    65       7.482 -13.769  11.327  1.00 37.41           H  
ATOM    987  HD3 LYS    65       6.046 -12.764  11.131  1.00 37.41           H  
ATOM    988  HE2 LYS    65       7.002 -13.348   8.965  1.00 37.41           H  
ATOM    989  HE3 LYS    65       7.105 -11.611   9.248  1.00 37.41           H  
ATOM    990  HZ1 LYS    65       9.144 -12.552   8.299  1.00 37.41           H  
ATOM    991  HZ2 LYS    65       9.336 -13.522   9.668  1.00 37.41           H  
ATOM    992  HZ3 LYS    65       9.415 -11.842   9.806  1.00 37.41           H  
ATOM    993  N   PRO    66       7.471  -6.815  12.457  1.00 62.54           N  
ATOM    994  CA  PRO    66       6.766  -5.530  12.370  1.00 44.02           C  
ATOM    995  C   PRO    66       6.263  -5.199  10.950  1.00 12.31           C  
ATOM    996  O   PRO    66       7.020  -5.245   9.979  1.00 62.23           O  
ATOM    997  CB  PRO    66       7.837  -4.530  12.819  1.00 32.11           C  
ATOM    998  CG  PRO    66       9.125  -5.139  12.375  1.00 70.24           C  
ATOM    999  CD  PRO    66       8.939  -6.637  12.465  1.00 13.44           C  
ATOM   1000  HA  PRO    66       5.933  -5.494  13.059  1.00  1.01           H  
ATOM   1001  HB2 PRO    66       7.665  -3.571  12.350  1.00 37.41           H  
ATOM   1002  HB3 PRO    66       7.804  -4.420  13.894  1.00 37.41           H  
ATOM   1003  HG2 PRO    66       9.335  -4.847  11.356  1.00 37.41           H  
ATOM   1004  HG3 PRO    66       9.927  -4.820  13.027  1.00 37.41           H  
ATOM   1005  HD2 PRO    66       9.390  -7.125  11.612  1.00 37.41           H  
ATOM   1006  HD3 PRO    66       9.364  -7.017  13.383  1.00 37.41           H  
ATOM   1007  N   TYR    67       4.979  -4.871  10.846  1.00 24.13           N  
ATOM   1008  CA  TYR    67       4.370  -4.439   9.581  1.00 24.21           C  
ATOM   1009  C   TYR    67       3.188  -3.491   9.849  1.00 45.21           C  
ATOM   1010  O   TYR    67       2.904  -3.151  11.001  1.00 72.50           O  
ATOM   1011  CB  TYR    67       3.915  -5.656   8.753  1.00  1.11           C  
ATOM   1012  CG  TYR    67       2.901  -6.550   9.452  1.00  2.41           C  
ATOM   1013  CD1 TYR    67       3.311  -7.547  10.334  1.00 23.44           C  
ATOM   1014  CD2 TYR    67       1.534  -6.403   9.224  1.00 42.32           C  
ATOM   1015  CE1 TYR    67       2.393  -8.362  10.969  1.00 44.40           C  
ATOM   1016  CE2 TYR    67       0.612  -7.216   9.855  1.00 22.30           C  
ATOM   1017  CZ  TYR    67       1.046  -8.194  10.726  1.00  1.14           C  
ATOM   1018  OH  TYR    67       0.131  -9.010  11.357  1.00 65.32           O  
ATOM   1019  H   TYR    67       4.411  -4.928  11.646  1.00 37.41           H  
ATOM   1020  HA  TYR    67       5.122  -3.896   9.023  1.00 62.22           H  
ATOM   1021  HB2 TYR    67       3.469  -5.308   7.832  1.00 37.41           H  
ATOM   1022  HB3 TYR    67       4.780  -6.259   8.514  1.00 37.41           H  
ATOM   1023  HD1 TYR    67       4.366  -7.678  10.524  1.00  3.10           H  
ATOM   1024  HD2 TYR    67       1.196  -5.635   8.542  1.00 71.14           H  
ATOM   1025  HE1 TYR    67       2.735  -9.127  11.651  1.00 11.44           H  
ATOM   1026  HE2 TYR    67      -0.444  -7.086   9.660  1.00 45.34           H  
ATOM   1027  HH  TYR    67      -0.543  -9.284  10.722  1.00 75.15           H  
ATOM   1028  N   PHE    68       2.507  -3.052   8.794  1.00 24.23           N  
ATOM   1029  CA  PHE    68       1.371  -2.137   8.954  1.00  4.50           C  
ATOM   1030  C   PHE    68       0.403  -2.178   7.760  1.00 64.32           C  
ATOM   1031  O   PHE    68       0.799  -2.428   6.620  1.00 12.41           O  
ATOM   1032  CB  PHE    68       1.871  -0.698   9.183  1.00 32.33           C  
ATOM   1033  CG  PHE    68       2.691  -0.137   8.044  1.00 23.42           C  
ATOM   1034  CD1 PHE    68       4.044  -0.426   7.932  1.00 53.23           C  
ATOM   1035  CD2 PHE    68       2.106   0.680   7.083  1.00 31.25           C  
ATOM   1036  CE1 PHE    68       4.793   0.086   6.889  1.00  4.33           C  
ATOM   1037  CE2 PHE    68       2.853   1.193   6.040  1.00  0.44           C  
ATOM   1038  CZ  PHE    68       4.199   0.895   5.945  1.00 13.13           C  
ATOM   1039  H   PHE    68       2.769  -3.344   7.896  1.00 37.41           H  
ATOM   1040  HA  PHE    68       0.827  -2.451   9.835  1.00 14.23           H  
ATOM   1041  HB2 PHE    68       1.019  -0.048   9.332  1.00 37.41           H  
ATOM   1042  HB3 PHE    68       2.484  -0.681  10.074  1.00 37.41           H  
ATOM   1043  HD1 PHE    68       4.514  -1.062   8.670  1.00 10.45           H  
ATOM   1044  HD2 PHE    68       1.053   0.917   7.157  1.00 75.42           H  
ATOM   1045  HE1 PHE    68       5.844  -0.148   6.814  1.00 73.12           H  
ATOM   1046  HE2 PHE    68       2.386   1.826   5.300  1.00 70.04           H  
ATOM   1047  HZ  PHE    68       4.783   1.293   5.130  1.00  3.33           H  
ATOM   1048  N   ASN    69      -0.872  -1.940   8.050  1.00 64.50           N  
ATOM   1049  CA  ASN    69      -1.917  -1.835   7.029  1.00 15.25           C  
ATOM   1050  C   ASN    69      -2.474  -0.402   6.980  1.00 13.04           C  
ATOM   1051  O   ASN    69      -2.335   0.362   7.937  1.00 72.31           O  
ATOM   1052  CB  ASN    69      -3.054  -2.818   7.333  1.00 23.42           C  
ATOM   1053  CG  ASN    69      -2.588  -4.266   7.375  1.00 74.43           C  
ATOM   1054  OD1 ASN    69      -2.149  -4.761   8.408  1.00 54.30           O  
ATOM   1055  ND2 ASN    69      -2.687  -4.962   6.259  1.00 72.34           N  
ATOM   1056  H   ASN    69      -1.125  -1.836   8.987  1.00 37.41           H  
ATOM   1057  HA  ASN    69      -1.481  -2.078   6.069  1.00 74.20           H  
ATOM   1058  HB2 ASN    69      -3.484  -2.574   8.293  1.00 37.41           H  
ATOM   1059  HB3 ASN    69      -3.816  -2.725   6.572  1.00 37.41           H  
ATOM   1060 HD21 ASN    69      -3.050  -4.521   5.464  1.00 37.41           H  
ATOM   1061 HD22 ASN    69      -2.402  -5.900   6.277  1.00 37.41           H  
ATOM   1062  N   LEU    70      -3.099  -0.039   5.866  1.00  3.12           N  
ATOM   1063  CA  LEU    70      -3.696   1.294   5.709  1.00 12.35           C  
ATOM   1064  C   LEU    70      -5.207   1.188   5.443  1.00 52.51           C  
ATOM   1065  O   LEU    70      -5.639   0.449   4.550  1.00  2.32           O  
ATOM   1066  CB  LEU    70      -3.002   2.054   4.562  1.00 61.41           C  
ATOM   1067  CG  LEU    70      -3.459   3.511   4.357  1.00 74.43           C  
ATOM   1068  CD1 LEU    70      -3.134   4.366   5.584  1.00 53.53           C  
ATOM   1069  CD2 LEU    70      -2.820   4.100   3.100  1.00 51.44           C  
ATOM   1070  H   LEU    70      -3.166  -0.683   5.130  1.00 37.41           H  
ATOM   1071  HA  LEU    70      -3.544   1.837   6.631  1.00 30.15           H  
ATOM   1072  HB2 LEU    70      -1.937   2.057   4.757  1.00 37.41           H  
ATOM   1073  HB3 LEU    70      -3.177   1.512   3.643  1.00 37.41           H  
ATOM   1074  HG  LEU    70      -4.530   3.526   4.222  1.00 53.12           H  
ATOM   1075 HD11 LEU    70      -3.620   3.946   6.453  1.00 37.41           H  
ATOM   1076 HD12 LEU    70      -3.491   5.374   5.426  1.00 37.41           H  
ATOM   1077 HD13 LEU    70      -2.066   4.384   5.742  1.00 37.41           H  
ATOM   1078 HD21 LEU    70      -3.146   5.121   2.972  1.00 37.41           H  
ATOM   1079 HD22 LEU    70      -3.117   3.519   2.239  1.00 37.41           H  
ATOM   1080 HD23 LEU    70      -1.744   4.076   3.194  1.00 37.41           H  
ATOM   1081  N   LYS    71      -6.004   1.925   6.220  1.00 35.23           N  
ATOM   1082  CA  LYS    71      -7.465   1.907   6.076  1.00 73.11           C  
ATOM   1083  C   LYS    71      -8.014   3.253   5.581  1.00 73.01           C  
ATOM   1084  O   LYS    71      -7.513   4.317   5.942  1.00  2.23           O  
ATOM   1085  CB  LYS    71      -8.145   1.557   7.410  1.00 52.54           C  
ATOM   1086  CG  LYS    71      -7.870   0.143   7.914  1.00  3.44           C  
ATOM   1087  CD  LYS    71      -8.818  -0.226   9.058  1.00 43.11           C  
ATOM   1088  CE  LYS    71      -8.538  -1.614   9.626  1.00  2.32           C  
ATOM   1089  NZ  LYS    71      -7.195  -1.709  10.252  1.00 63.42           N  
ATOM   1090  H   LYS    71      -5.604   2.503   6.907  1.00 37.41           H  
ATOM   1091  HA  LYS    71      -7.718   1.146   5.350  1.00 23.22           H  
ATOM   1092  HB2 LYS    71      -7.803   2.251   8.165  1.00 37.41           H  
ATOM   1093  HB3 LYS    71      -9.216   1.669   7.293  1.00 37.41           H  
ATOM   1094  HG2 LYS    71      -8.009  -0.555   7.100  1.00 37.41           H  
ATOM   1095  HG3 LYS    71      -6.848   0.086   8.269  1.00 37.41           H  
ATOM   1096  HD2 LYS    71      -8.714   0.502   9.850  1.00 37.41           H  
ATOM   1097  HD3 LYS    71      -9.832  -0.201   8.685  1.00 37.41           H  
ATOM   1098  HE2 LYS    71      -9.287  -1.839  10.372  1.00 37.41           H  
ATOM   1099  HE3 LYS    71      -8.605  -2.337   8.826  1.00 37.41           H  
ATOM   1100  HZ1 LYS    71      -7.050  -0.916  10.911  1.00 37.41           H  
ATOM   1101  HZ2 LYS    71      -6.452  -1.683   9.527  1.00 37.41           H  
ATOM   1102  HZ3 LYS    71      -7.112  -2.600  10.783  1.00 37.41           H  
ATOM   1103  N   ALA    72      -9.056   3.195   4.754  1.00 64.14           N  
ATOM   1104  CA  ALA    72      -9.782   4.398   4.334  1.00 62.42           C  
ATOM   1105  C   ALA    72     -10.779   4.839   5.421  1.00 74.43           C  
ATOM   1106  O   ALA    72     -10.918   4.172   6.448  1.00 34.50           O  
ATOM   1107  CB  ALA    72     -10.504   4.149   3.016  1.00 73.22           C  
ATOM   1108  H   ALA    72      -9.341   2.319   4.415  1.00 37.41           H  
ATOM   1109  HA  ALA    72      -9.062   5.190   4.180  1.00 74.24           H  
ATOM   1110  HB1 ALA    72      -9.793   3.834   2.267  1.00 37.41           H  
ATOM   1111  HB2 ALA    72     -10.990   5.059   2.691  1.00 37.41           H  
ATOM   1112  HB3 ALA    72     -11.247   3.377   3.152  1.00 37.41           H  
ATOM   1113  N   ALA    73     -11.471   5.956   5.194  1.00 12.14           N  
ATOM   1114  CA  ALA    73     -12.418   6.506   6.181  1.00 23.01           C  
ATOM   1115  C   ALA    73     -13.482   5.481   6.617  1.00 13.03           C  
ATOM   1116  O   ALA    73     -13.840   5.409   7.791  1.00 75.11           O  
ATOM   1117  CB  ALA    73     -13.091   7.756   5.622  1.00 23.52           C  
ATOM   1118  H   ALA    73     -11.348   6.428   4.343  1.00 37.41           H  
ATOM   1119  HA  ALA    73     -11.846   6.801   7.050  1.00 75.03           H  
ATOM   1120  HB1 ALA    73     -13.668   7.495   4.745  1.00 37.41           H  
ATOM   1121  HB2 ALA    73     -12.336   8.482   5.351  1.00 37.41           H  
ATOM   1122  HB3 ALA    73     -13.746   8.182   6.369  1.00 37.41           H  
ATOM   1123  N   ASN    74     -13.975   4.682   5.668  1.00 14.50           N  
ATOM   1124  CA  ASN    74     -14.995   3.662   5.962  1.00 44.41           C  
ATOM   1125  C   ASN    74     -14.373   2.400   6.607  1.00 22.25           C  
ATOM   1126  O   ASN    74     -15.018   1.355   6.708  1.00 15.02           O  
ATOM   1127  CB  ASN    74     -15.760   3.307   4.675  1.00 73.15           C  
ATOM   1128  CG  ASN    74     -17.051   2.547   4.943  1.00 61.34           C  
ATOM   1129  OD1 ASN    74     -18.083   3.137   5.242  1.00  2.04           O  
ATOM   1130  ND2 ASN    74     -17.016   1.235   4.823  1.00 24.03           N  
ATOM   1131  H   ASN    74     -13.661   4.793   4.747  1.00 37.41           H  
ATOM   1132  HA  ASN    74     -15.692   4.094   6.667  1.00 11.14           H  
ATOM   1133  HB2 ASN    74     -16.008   4.219   4.148  1.00 37.41           H  
ATOM   1134  HB3 ASN    74     -15.129   2.697   4.044  1.00 37.41           H  
ATOM   1135 HD21 ASN    74     -16.171   0.813   4.570  1.00 37.41           H  
ATOM   1136 HD22 ASN    74     -17.843   0.739   4.984  1.00 37.41           H  
ATOM   1137  N   HIS    75     -13.105   2.509   7.018  1.00 14.22           N  
ATOM   1138  CA  HIS    75     -12.421   1.473   7.820  1.00 24.34           C  
ATOM   1139  C   HIS    75     -12.106   0.216   6.985  1.00 63.04           C  
ATOM   1140  O   HIS    75     -11.936  -0.882   7.520  1.00 64.04           O  
ATOM   1141  CB  HIS    75     -13.274   1.119   9.054  1.00 34.43           C  
ATOM   1142  CG  HIS    75     -12.532   0.386  10.133  1.00 15.42           C  
ATOM   1143  ND1 HIS    75     -12.548  -0.986  10.265  1.00  2.12           N  
ATOM   1144  CD2 HIS    75     -11.764   0.847  11.149  1.00 71.01           C  
ATOM   1145  CE1 HIS    75     -11.827  -1.335  11.311  1.00 72.22           C  
ATOM   1146  NE2 HIS    75     -11.339  -0.245  11.865  1.00 11.40           N  
ATOM   1147  H   HIS    75     -12.605   3.312   6.767  1.00 37.41           H  
ATOM   1148  HA  HIS    75     -11.486   1.895   8.157  1.00 70.03           H  
ATOM   1149  HB2 HIS    75     -13.657   2.031   9.486  1.00 37.41           H  
ATOM   1150  HB3 HIS    75     -14.105   0.501   8.745  1.00 37.41           H  
ATOM   1151  HD1 HIS    75     -13.019  -1.614   9.676  1.00 74.14           H  
ATOM   1152  HD2 HIS    75     -11.527   1.882  11.355  1.00 62.31           H  
ATOM   1153  HE1 HIS    75     -11.662  -2.346  11.653  1.00 23.12           H  
ATOM   1154  HE2 HIS    75     -10.934  -0.206  12.760  1.00 37.41           H  
ATOM   1155  N   GLN    76     -11.995   0.406   5.675  1.00 70.15           N  
ATOM   1156  CA  GLN    76     -11.689  -0.683   4.736  1.00 74.21           C  
ATOM   1157  C   GLN    76     -10.171  -0.827   4.527  1.00 71.43           C  
ATOM   1158  O   GLN    76      -9.428   0.149   4.651  1.00 53.14           O  
ATOM   1159  CB  GLN    76     -12.374  -0.393   3.393  1.00 42.12           C  
ATOM   1160  CG  GLN    76     -11.825   0.848   2.691  1.00 15.10           C  
ATOM   1161  CD  GLN    76     -12.765   1.405   1.641  1.00  1.43           C  
ATOM   1162  OE1 GLN    76     -12.715   1.031   0.471  1.00 50.25           O  
ATOM   1163  NE2 GLN    76     -13.614   2.324   2.052  1.00 12.54           N  
ATOM   1164  H   GLN    76     -12.121   1.309   5.323  1.00 37.41           H  
ATOM   1165  HA  GLN    76     -12.081  -1.604   5.143  1.00  5.43           H  
ATOM   1166  HB2 GLN    76     -12.235  -1.243   2.738  1.00 37.41           H  
ATOM   1167  HB3 GLN    76     -13.432  -0.249   3.563  1.00 37.41           H  
ATOM   1168  HG2 GLN    76     -11.647   1.615   3.431  1.00 37.41           H  
ATOM   1169  HG3 GLN    76     -10.889   0.592   2.215  1.00 37.41           H  
ATOM   1170 HE21 GLN    76     -13.589   2.593   2.992  1.00 37.41           H  
ATOM   1171 HE22 GLN    76     -14.248   2.691   1.397  1.00 37.41           H  
ATOM   1172  N   ILE    77      -9.715  -2.035   4.194  1.00 32.34           N  
ATOM   1173  CA  ILE    77      -8.283  -2.295   3.979  1.00 40.03           C  
ATOM   1174  C   ILE    77      -7.868  -1.955   2.540  1.00 24.44           C  
ATOM   1175  O   ILE    77      -8.107  -2.731   1.612  1.00 71.02           O  
ATOM   1176  CB  ILE    77      -7.923  -3.778   4.274  1.00 72.54           C  
ATOM   1177  CG1 ILE    77      -8.252  -4.137   5.732  1.00 71.52           C  
ATOM   1178  CG2 ILE    77      -6.445  -4.051   3.976  1.00 55.33           C  
ATOM   1179  CD1 ILE    77      -7.418  -3.391   6.752  1.00  4.14           C  
ATOM   1180  H   ILE    77     -10.356  -2.767   4.072  1.00 37.41           H  
ATOM   1181  HA  ILE    77      -7.722  -1.669   4.662  1.00 54.33           H  
ATOM   1182  HB  ILE    77      -8.514  -4.401   3.617  1.00 41.44           H  
ATOM   1183 HG12 ILE    77      -9.289  -3.910   5.927  1.00 37.41           H  
ATOM   1184 HG13 ILE    77      -8.090  -5.196   5.881  1.00 37.41           H  
ATOM   1185 HG21 ILE    77      -6.214  -5.082   4.206  1.00 37.41           H  
ATOM   1186 HG22 ILE    77      -5.826  -3.401   4.579  1.00 37.41           H  
ATOM   1187 HG23 ILE    77      -6.247  -3.865   2.930  1.00 37.41           H  
ATOM   1188 HD11 ILE    77      -6.377  -3.650   6.624  1.00 37.41           H  
ATOM   1189 HD12 ILE    77      -7.735  -3.667   7.746  1.00 37.41           H  
ATOM   1190 HD13 ILE    77      -7.545  -2.327   6.616  1.00 37.41           H  
ATOM   1191  N   ILE    78      -7.258  -0.789   2.357  1.00 42.24           N  
ATOM   1192  CA  ILE    78      -6.824  -0.346   1.024  1.00 51.22           C  
ATOM   1193  C   ILE    78      -5.345  -0.674   0.761  1.00 70.34           C  
ATOM   1194  O   ILE    78      -4.940  -0.865  -0.388  1.00 50.21           O  
ATOM   1195  CB  ILE    78      -7.057   1.174   0.830  1.00 32.12           C  
ATOM   1196  CG1 ILE    78      -6.289   1.979   1.892  1.00 53.32           C  
ATOM   1197  CG2 ILE    78      -8.551   1.494   0.876  1.00 11.03           C  
ATOM   1198  CD1 ILE    78      -6.479   3.475   1.785  1.00 34.20           C  
ATOM   1199  H   ILE    78      -7.099  -0.209   3.131  1.00 37.41           H  
ATOM   1200  HA  ILE    78      -7.424  -0.870   0.290  1.00 62.01           H  
ATOM   1201  HB  ILE    78      -6.691   1.447  -0.151  1.00 52.10           H  
ATOM   1202 HG12 ILE    78      -6.619   1.676   2.875  1.00 37.41           H  
ATOM   1203 HG13 ILE    78      -5.231   1.773   1.796  1.00 37.41           H  
ATOM   1204 HG21 ILE    78      -8.701   2.554   0.726  1.00 37.41           H  
ATOM   1205 HG22 ILE    78      -8.953   1.206   1.838  1.00 37.41           H  
ATOM   1206 HG23 ILE    78      -9.062   0.945   0.097  1.00 37.41           H  
ATOM   1207 HD11 ILE    78      -5.860   3.968   2.520  1.00 37.41           H  
ATOM   1208 HD12 ILE    78      -7.515   3.722   1.966  1.00 37.41           H  
ATOM   1209 HD13 ILE    78      -6.198   3.807   0.798  1.00 37.41           H  
ATOM   1210  N   GLY    79      -4.543  -0.740   1.826  1.00 72.31           N  
ATOM   1211  CA  GLY    79      -3.118  -1.037   1.679  1.00 14.54           C  
ATOM   1212  C   GLY    79      -2.586  -2.007   2.734  1.00 61.14           C  
ATOM   1213  O   GLY    79      -3.094  -2.060   3.853  1.00 22.12           O  
ATOM   1214  H   GLY    79      -4.920  -0.581   2.720  1.00 37.41           H  
ATOM   1215  HA2 GLY    79      -2.948  -1.464   0.699  1.00 37.41           H  
ATOM   1216  HA3 GLY    79      -2.566  -0.111   1.750  1.00 37.41           H  
ATOM   1217  N   THR    80      -1.552  -2.767   2.373  1.00 55.11           N  
ATOM   1218  CA  THR    80      -0.925  -3.738   3.289  1.00 61.41           C  
ATOM   1219  C   THR    80       0.586  -3.837   3.039  1.00 45.05           C  
ATOM   1220  O   THR    80       1.017  -4.076   1.916  1.00 71.44           O  
ATOM   1221  CB  THR    80      -1.558  -5.147   3.137  1.00 41.01           C  
ATOM   1222  OG1 THR    80      -2.947  -5.106   3.503  1.00 65.52           O  
ATOM   1223  CG2 THR    80      -0.837  -6.182   3.998  1.00  5.43           C  
ATOM   1224  H   THR    80      -1.195  -2.681   1.463  1.00 37.41           H  
ATOM   1225  HA  THR    80      -1.093  -3.397   4.304  1.00 64.32           H  
ATOM   1226  HB  THR    80      -1.480  -5.447   2.100  1.00 64.12           H  
ATOM   1227  HG1 THR    80      -3.488  -5.116   2.709  1.00 11.42           H  
ATOM   1228 HG21 THR    80      -0.865  -5.876   5.034  1.00 37.41           H  
ATOM   1229 HG22 THR    80       0.192  -6.269   3.677  1.00 37.41           H  
ATOM   1230 HG23 THR    80      -1.326  -7.140   3.896  1.00 37.41           H  
ATOM   1231  N   SER    81       1.385  -3.644   4.084  1.00 55.20           N  
ATOM   1232  CA  SER    81       2.854  -3.672   3.956  1.00 70.42           C  
ATOM   1233  C   SER    81       3.435  -5.074   4.181  1.00  1.13           C  
ATOM   1234  O   SER    81       2.783  -5.955   4.752  1.00  0.21           O  
ATOM   1235  CB  SER    81       3.496  -2.690   4.943  1.00 14.40           C  
ATOM   1236  OG  SER    81       4.910  -2.741   4.869  1.00 40.10           O  
ATOM   1237  H   SER    81       0.986  -3.476   4.965  1.00 37.41           H  
ATOM   1238  HA  SER    81       3.099  -3.358   2.950  1.00 32.31           H  
ATOM   1239  HB2 SER    81       3.174  -1.686   4.710  1.00 37.41           H  
ATOM   1240  HB3 SER    81       3.189  -2.937   5.950  1.00 37.41           H  
ATOM   1241  HG  SER    81       5.256  -1.873   4.625  1.00 61.12           H  
ATOM   1242  N   GLN    82       4.677  -5.271   3.739  1.00  5.15           N  
ATOM   1243  CA  GLN    82       5.359  -6.558   3.892  1.00 21.22           C  
ATOM   1244  C   GLN    82       6.166  -6.618   5.200  1.00 62.30           C  
ATOM   1245  O   GLN    82       6.863  -5.668   5.560  1.00 11.14           O  
ATOM   1246  CB  GLN    82       6.300  -6.835   2.704  1.00 60.54           C  
ATOM   1247  CG  GLN    82       5.623  -6.827   1.331  1.00 40.12           C  
ATOM   1248  CD  GLN    82       5.440  -5.429   0.762  1.00 34.15           C  
ATOM   1249  OE1 GLN    82       4.416  -4.784   0.956  1.00 74.24           O  
ATOM   1250  NE2 GLN    82       6.438  -4.949   0.049  1.00 13.44           N  
ATOM   1251  H   GLN    82       5.147  -4.528   3.306  1.00 37.41           H  
ATOM   1252  HA  GLN    82       4.602  -7.330   3.918  1.00 24.02           H  
ATOM   1253  HB2 GLN    82       7.079  -6.085   2.698  1.00 37.41           H  
ATOM   1254  HB3 GLN    82       6.756  -7.805   2.847  1.00 37.41           H  
ATOM   1255  HG2 GLN    82       6.229  -7.400   0.645  1.00 37.41           H  
ATOM   1256  HG3 GLN    82       4.651  -7.295   1.421  1.00 37.41           H  
ATOM   1257 HE21 GLN    82       7.232  -5.512  -0.077  1.00 37.41           H  
ATOM   1258 HE22 GLN    82       6.351  -4.046  -0.311  1.00 37.41           H  
ATOM   1259  N   MET    83       6.062  -7.752   5.893  1.00 21.12           N  
ATOM   1260  CA  MET    83       6.801  -8.008   7.140  1.00 20.12           C  
ATOM   1261  C   MET    83       8.272  -7.528   7.081  1.00 52.45           C  
ATOM   1262  O   MET    83       9.072  -8.020   6.280  1.00 11.10           O  
ATOM   1263  CB  MET    83       6.744  -9.512   7.447  1.00 43.35           C  
ATOM   1264  CG  MET    83       7.207 -10.389   6.284  1.00  3.32           C  
ATOM   1265  SD  MET    83       6.966 -12.151   6.591  1.00 54.34           S  
ATOM   1266  CE  MET    83       7.519 -12.842   5.032  1.00 11.34           C  
ATOM   1267  H   MET    83       5.448  -8.442   5.563  1.00 37.41           H  
ATOM   1268  HA  MET    83       6.297  -7.475   7.933  1.00 14.22           H  
ATOM   1269  HB2 MET    83       7.371  -9.722   8.305  1.00 37.41           H  
ATOM   1270  HB3 MET    83       5.724  -9.780   7.687  1.00 37.41           H  
ATOM   1271  HG2 MET    83       6.649 -10.117   5.399  1.00 37.41           H  
ATOM   1272  HG3 MET    83       8.258 -10.210   6.111  1.00 37.41           H  
ATOM   1273  HE1 MET    83       8.537 -12.535   4.843  1.00 37.41           H  
ATOM   1274  HE2 MET    83       6.882 -12.488   4.235  1.00 37.41           H  
ATOM   1275  HE3 MET    83       7.472 -13.919   5.079  1.00 37.41           H  
ATOM   1276  N   TYR    84       8.613  -6.554   7.932  1.00 31.51           N  
ATOM   1277  CA  TYR    84       9.984  -6.026   8.013  1.00 62.50           C  
ATOM   1278  C   TYR    84      10.837  -6.825   9.012  1.00 11.43           C  
ATOM   1279  O   TYR    84      10.323  -7.658   9.759  1.00 44.01           O  
ATOM   1280  CB  TYR    84       9.965  -4.547   8.426  1.00 12.32           C  
ATOM   1281  CG  TYR    84       9.245  -3.642   7.444  1.00 41.13           C  
ATOM   1282  CD1 TYR    84       9.902  -3.121   6.334  1.00 70.11           C  
ATOM   1283  CD2 TYR    84       7.905  -3.308   7.626  1.00 12.42           C  
ATOM   1284  CE1 TYR    84       9.250  -2.294   5.440  1.00  1.15           C  
ATOM   1285  CE2 TYR    84       7.248  -2.483   6.735  1.00 14.23           C  
ATOM   1286  CZ  TYR    84       7.924  -1.978   5.644  1.00 12.04           C  
ATOM   1287  OH  TYR    84       7.268  -1.156   4.750  1.00 22.12           O  
ATOM   1288  H   TYR    84       7.924  -6.176   8.519  1.00 37.41           H  
ATOM   1289  HA  TYR    84      10.433  -6.109   7.032  1.00 13.23           H  
ATOM   1290  HB2 TYR    84       9.470  -4.455   9.383  1.00 37.41           H  
ATOM   1291  HB3 TYR    84      10.982  -4.193   8.520  1.00 37.41           H  
ATOM   1292  HD1 TYR    84      10.941  -3.370   6.174  1.00 62.23           H  
ATOM   1293  HD2 TYR    84       7.378  -3.702   8.483  1.00 30.20           H  
ATOM   1294  HE1 TYR    84       9.780  -1.899   4.585  1.00 12.23           H  
ATOM   1295  HE2 TYR    84       6.209  -2.237   6.896  1.00 61.43           H  
ATOM   1296  HH  TYR    84       7.405  -1.483   3.856  1.00 43.33           H  
ATOM   1297  N   SER    85      12.141  -6.561   9.027  1.00 13.02           N  
ATOM   1298  CA  SER    85      13.061  -7.245   9.949  1.00 52.24           C  
ATOM   1299  C   SER    85      13.109  -6.551  11.317  1.00 42.44           C  
ATOM   1300  O   SER    85      12.815  -7.158  12.349  1.00  1.01           O  
ATOM   1301  CB  SER    85      14.472  -7.300   9.348  1.00 54.31           C  
ATOM   1302  OG  SER    85      14.975  -5.995   9.092  1.00 43.35           O  
ATOM   1303  H   SER    85      12.498  -5.896   8.403  1.00 37.41           H  
ATOM   1304  HA  SER    85      12.702  -8.256  10.086  1.00 51.40           H  
ATOM   1305  HB2 SER    85      15.137  -7.798  10.039  1.00 37.41           H  
ATOM   1306  HB3 SER    85      14.443  -7.850   8.418  1.00 37.41           H  
ATOM   1307  HG  SER    85      15.881  -6.067   8.762  1.00  2.54           H  
ATOM   1308  N   SER    86      13.502  -5.279  11.322  1.00 63.42           N  
ATOM   1309  CA  SER    86      13.582  -4.489  12.559  1.00 74.23           C  
ATOM   1310  C   SER    86      12.373  -3.556  12.705  1.00 73.32           C  
ATOM   1311  O   SER    86      11.706  -3.226  11.719  1.00 23.32           O  
ATOM   1312  CB  SER    86      14.864  -3.644  12.572  1.00 54.32           C  
ATOM   1313  OG  SER    86      14.833  -2.648  11.557  1.00 20.40           O  
ATOM   1314  H   SER    86      13.752  -4.859  10.472  1.00 37.41           H  
ATOM   1315  HA  SER    86      13.604  -5.173  13.397  1.00 44.14           H  
ATOM   1316  HB2 SER    86      14.965  -3.158  13.532  1.00 37.41           H  
ATOM   1317  HB3 SER    86      15.718  -4.286  12.404  1.00 37.41           H  
ATOM   1318  HG  SER    86      15.653  -2.682  11.042  1.00 20.51           H  
ATOM   1319  N   THR    87      12.093  -3.124  13.933  1.00 65.31           N  
ATOM   1320  CA  THR    87      11.020  -2.149  14.177  1.00 45.55           C  
ATOM   1321  C   THR    87      11.331  -0.822  13.479  1.00 11.24           C  
ATOM   1322  O   THR    87      10.457  -0.203  12.870  1.00 23.25           O  
ATOM   1323  CB  THR    87      10.808  -1.882  15.687  1.00 50.10           C  
ATOM   1324  OG1 THR    87      11.999  -1.322  16.264  1.00 33.13           O  
ATOM   1325  CG2 THR    87      10.444  -3.167  16.423  1.00 61.13           C  
ATOM   1326  H   THR    87      12.616  -3.464  14.695  1.00 37.41           H  
ATOM   1327  HA  THR    87      10.102  -2.553  13.769  1.00 30.01           H  
ATOM   1328  HB  THR    87       9.997  -1.177  15.803  1.00 74.14           H  
ATOM   1329  HG1 THR    87      11.760  -0.583  16.839  1.00  3.11           H  
ATOM   1330 HG21 THR    87      11.243  -3.887  16.310  1.00 37.41           H  
ATOM   1331 HG22 THR    87       9.531  -3.574  16.010  1.00 37.41           H  
ATOM   1332 HG23 THR    87      10.299  -2.953  17.472  1.00 37.41           H  
ATOM   1333  N   ALA    88      12.596  -0.405  13.561  1.00 52.20           N  
ATOM   1334  CA  ALA    88      13.069   0.810  12.892  1.00 21.41           C  
ATOM   1335  C   ALA    88      12.811   0.757  11.376  1.00 34.01           C  
ATOM   1336  O   ALA    88      12.411   1.755  10.775  1.00 31.42           O  
ATOM   1337  CB  ALA    88      14.554   1.029  13.174  1.00 62.43           C  
ATOM   1338  H   ALA    88      13.229  -0.927  14.098  1.00 37.41           H  
ATOM   1339  HA  ALA    88      12.525   1.647  13.307  1.00 22.44           H  
ATOM   1340  HB1 ALA    88      14.722   1.033  14.240  1.00 37.41           H  
ATOM   1341  HB2 ALA    88      14.865   1.977  12.759  1.00 37.41           H  
ATOM   1342  HB3 ALA    88      15.131   0.234  12.723  1.00 37.41           H  
ATOM   1343  N   ALA    89      13.041  -0.408  10.763  1.00 22.32           N  
ATOM   1344  CA  ALA    89      12.750  -0.606   9.334  1.00 24.30           C  
ATOM   1345  C   ALA    89      11.290  -0.260   9.009  1.00 74.43           C  
ATOM   1346  O   ALA    89      10.999   0.381   7.999  1.00 61.43           O  
ATOM   1347  CB  ALA    89      13.051  -2.044   8.923  1.00 34.13           C  
ATOM   1348  H   ALA    89      13.429  -1.150  11.279  1.00 37.41           H  
ATOM   1349  HA  ALA    89      13.399   0.050   8.770  1.00 31.22           H  
ATOM   1350  HB1 ALA    89      12.424  -2.721   9.486  1.00 37.41           H  
ATOM   1351  HB2 ALA    89      14.088  -2.266   9.123  1.00 37.41           H  
ATOM   1352  HB3 ALA    89      12.855  -2.167   7.866  1.00 37.41           H  
ATOM   1353  N   ARG    90      10.381  -0.684   9.883  1.00 11.00           N  
ATOM   1354  CA  ARG    90       8.951  -0.412   9.713  1.00 33.04           C  
ATOM   1355  C   ARG    90       8.652   1.096   9.741  1.00 30.22           C  
ATOM   1356  O   ARG    90       8.065   1.641   8.808  1.00 73.34           O  
ATOM   1357  CB  ARG    90       8.152  -1.104  10.823  1.00 44.22           C  
ATOM   1358  CG  ARG    90       6.644  -0.872  10.740  1.00 45.02           C  
ATOM   1359  CD  ARG    90       5.953  -1.217  12.052  1.00 61.31           C  
ATOM   1360  NE  ARG    90       6.448  -0.396  13.158  1.00 33.23           N  
ATOM   1361  CZ  ARG    90       5.953  -0.406  14.365  1.00 13.35           C  
ATOM   1362  NH1 ARG    90       4.968  -1.191  14.672  1.00 64.35           N  
ATOM   1363  NH2 ARG    90       6.455   0.371  15.264  1.00 43.35           N  
ATOM   1364  H   ARG    90      10.680  -1.197  10.664  1.00 37.41           H  
ATOM   1365  HA  ARG    90       8.646  -0.814   8.758  1.00 34.12           H  
ATOM   1366  HB2 ARG    90       8.335  -2.169  10.770  1.00 37.41           H  
ATOM   1367  HB3 ARG    90       8.499  -0.738  11.779  1.00 37.41           H  
ATOM   1368  HG2 ARG    90       6.459   0.170  10.512  1.00 37.41           H  
ATOM   1369  HG3 ARG    90       6.236  -1.491   9.952  1.00 37.41           H  
ATOM   1370  HD2 ARG    90       4.890  -1.054  11.938  1.00 37.41           H  
ATOM   1371  HD3 ARG    90       6.135  -2.259  12.277  1.00 37.41           H  
ATOM   1372  HE  ARG    90       7.196   0.212  12.977  1.00 52.40           H  
ATOM   1373 HH11 ARG    90       4.581  -1.794  13.988  1.00 37.41           H  
ATOM   1374 HH12 ARG    90       4.591  -1.178  15.600  1.00 37.41           H  
ATOM   1375 HH21 ARG    90       7.217   0.980  15.028  1.00 37.41           H  
ATOM   1376 HH22 ARG    90       6.080   0.373  16.190  1.00 37.41           H  
ATOM   1377  N   ASP    91       9.064   1.763  10.816  1.00 40.42           N  
ATOM   1378  CA  ASP    91       8.766   3.187  11.006  1.00  2.52           C  
ATOM   1379  C   ASP    91       9.501   4.082   9.985  1.00 70.24           C  
ATOM   1380  O   ASP    91       8.964   5.108   9.551  1.00 75.01           O  
ATOM   1381  CB  ASP    91       9.087   3.594  12.447  1.00 21.44           C  
ATOM   1382  CG  ASP    91       8.134   2.936  13.440  1.00  2.12           C  
ATOM   1383  OD1 ASP    91       8.377   1.775  13.833  1.00 23.12           O  
ATOM   1384  OD2 ASP    91       7.127   3.571  13.818  1.00 30.33           O  
ATOM   1385  H   ASP    91       9.578   1.286  11.507  1.00 37.41           H  
ATOM   1386  HA  ASP    91       7.702   3.311  10.850  1.00 41.42           H  
ATOM   1387  HB2 ASP    91      10.099   3.294  12.684  1.00 37.41           H  
ATOM   1388  HB3 ASP    91       9.003   4.668  12.545  1.00 37.41           H  
ATOM   1389  N   ASN    92      10.717   3.698   9.593  1.00 24.54           N  
ATOM   1390  CA  ASN    92      11.417   4.388   8.500  1.00 43.40           C  
ATOM   1391  C   ASN    92      10.694   4.148   7.170  1.00 41.23           C  
ATOM   1392  O   ASN    92      10.585   5.048   6.331  1.00  5.51           O  
ATOM   1393  CB  ASN    92      12.887   3.949   8.402  1.00 21.14           C  
ATOM   1394  CG  ASN    92      13.772   4.674   9.401  1.00  3.32           C  
ATOM   1395  OD1 ASN    92      14.285   5.755   9.126  1.00  3.13           O  
ATOM   1396  ND2 ASN    92      13.967   4.091  10.563  1.00 32.32           N  
ATOM   1397  H   ASN    92      11.145   2.938  10.038  1.00 37.41           H  
ATOM   1398  HA  ASN    92      11.384   5.449   8.713  1.00 54.44           H  
ATOM   1399  HB2 ASN    92      12.954   2.888   8.595  1.00 37.41           H  
ATOM   1400  HB3 ASN    92      13.258   4.152   7.408  1.00 37.41           H  
ATOM   1401 HD21 ASN    92      13.540   3.227  10.725  1.00 37.41           H  
ATOM   1402 HD22 ASN    92      14.534   4.551  11.217  1.00 37.41           H  
ATOM   1403  N   GLY    93      10.190   2.929   6.988  1.00 33.01           N  
ATOM   1404  CA  GLY    93       9.344   2.637   5.843  1.00 30.33           C  
ATOM   1405  C   GLY    93       8.134   3.563   5.786  1.00 44.40           C  
ATOM   1406  O   GLY    93       7.849   4.154   4.747  1.00 20.01           O  
ATOM   1407  H   GLY    93      10.397   2.219   7.635  1.00 37.41           H  
ATOM   1408  HA2 GLY    93       9.924   2.753   4.939  1.00 37.41           H  
ATOM   1409  HA3 GLY    93       9.003   1.614   5.912  1.00 37.41           H  
ATOM   1410  N   ILE    94       7.447   3.709   6.923  1.00 62.14           N  
ATOM   1411  CA  ILE    94       6.288   4.608   7.043  1.00 63.01           C  
ATOM   1412  C   ILE    94       6.627   6.044   6.601  1.00 65.20           C  
ATOM   1413  O   ILE    94       5.849   6.682   5.889  1.00 33.41           O  
ATOM   1414  CB  ILE    94       5.743   4.632   8.499  1.00 21.43           C  
ATOM   1415  CG1 ILE    94       5.302   3.219   8.929  1.00 22.41           C  
ATOM   1416  CG2 ILE    94       4.585   5.624   8.628  1.00 31.41           C  
ATOM   1417  CD1 ILE    94       4.824   3.133  10.365  1.00  5.53           C  
ATOM   1418  H   ILE    94       7.722   3.187   7.707  1.00 37.41           H  
ATOM   1419  HA  ILE    94       5.507   4.226   6.398  1.00 63.10           H  
ATOM   1420  HB  ILE    94       6.540   4.963   9.151  1.00 62.24           H  
ATOM   1421 HG12 ILE    94       4.489   2.896   8.295  1.00 37.41           H  
ATOM   1422 HG13 ILE    94       6.133   2.537   8.814  1.00 37.41           H  
ATOM   1423 HG21 ILE    94       4.214   5.620   9.643  1.00 37.41           H  
ATOM   1424 HG22 ILE    94       3.789   5.340   7.954  1.00 37.41           H  
ATOM   1425 HG23 ILE    94       4.930   6.617   8.377  1.00 37.41           H  
ATOM   1426 HD11 ILE    94       3.967   3.777  10.500  1.00 37.41           H  
ATOM   1427 HD12 ILE    94       5.616   3.447  11.029  1.00 37.41           H  
ATOM   1428 HD13 ILE    94       4.547   2.114  10.593  1.00 37.41           H  
ATOM   1429  N   LYS    95       7.788   6.552   7.022  1.00 12.12           N  
ATOM   1430  CA  LYS    95       8.235   7.888   6.599  1.00  3.54           C  
ATOM   1431  C   LYS    95       8.322   7.975   5.064  1.00 12.31           C  
ATOM   1432  O   LYS    95       7.893   8.962   4.450  1.00 50.22           O  
ATOM   1433  CB  LYS    95       9.593   8.237   7.227  1.00 22.14           C  
ATOM   1434  CG  LYS    95       9.587   8.239   8.756  1.00  4.23           C  
ATOM   1435  CD  LYS    95      10.887   8.798   9.339  1.00 72.42           C  
ATOM   1436  CE  LYS    95      12.109   7.977   8.938  1.00 70.43           C  
ATOM   1437  NZ  LYS    95      13.371   8.537   9.501  1.00 24.34           N  
ATOM   1438  H   LYS    95       8.350   6.022   7.631  1.00 37.41           H  
ATOM   1439  HA  LYS    95       7.498   8.603   6.941  1.00 23.11           H  
ATOM   1440  HB2 LYS    95      10.326   7.516   6.891  1.00 37.41           H  
ATOM   1441  HB3 LYS    95       9.889   9.221   6.888  1.00 37.41           H  
ATOM   1442  HG2 LYS    95       8.761   8.846   9.101  1.00 37.41           H  
ATOM   1443  HG3 LYS    95       9.455   7.224   9.104  1.00 37.41           H  
ATOM   1444  HD2 LYS    95      11.020   9.810   8.984  1.00 37.41           H  
ATOM   1445  HD3 LYS    95      10.809   8.806  10.417  1.00 37.41           H  
ATOM   1446  HE2 LYS    95      11.985   6.967   9.301  1.00 37.41           H  
ATOM   1447  HE3 LYS    95      12.184   7.965   7.859  1.00 37.41           H  
ATOM   1448  HZ1 LYS    95      14.163   7.886   9.326  1.00 37.41           H  
ATOM   1449  HZ2 LYS    95      13.276   8.681  10.528  1.00 37.41           H  
ATOM   1450  HZ3 LYS    95      13.591   9.450   9.056  1.00 37.41           H  
ATOM   1451  N   SER    96       8.874   6.930   4.450  1.00 12.50           N  
ATOM   1452  CA  SER    96       8.935   6.835   2.987  1.00 44.14           C  
ATOM   1453  C   SER    96       7.523   6.782   2.387  1.00 64.41           C  
ATOM   1454  O   SER    96       7.223   7.487   1.426  1.00 44.33           O  
ATOM   1455  CB  SER    96       9.733   5.594   2.559  1.00 22.51           C  
ATOM   1456  OG  SER    96      11.057   5.631   3.076  1.00 73.53           O  
ATOM   1457  H   SER    96       9.251   6.202   4.993  1.00 37.41           H  
ATOM   1458  HA  SER    96       9.437   7.720   2.617  1.00 20.13           H  
ATOM   1459  HB2 SER    96       9.243   4.706   2.928  1.00 37.41           H  
ATOM   1460  HB3 SER    96       9.785   5.554   1.479  1.00 37.41           H  
ATOM   1461  HG  SER    96      11.063   5.256   3.966  1.00 64.30           H  
ATOM   1462  N   VAL    97       6.660   5.955   2.985  1.00 22.23           N  
ATOM   1463  CA  VAL    97       5.264   5.803   2.542  1.00 24.34           C  
ATOM   1464  C   VAL    97       4.527   7.147   2.515  1.00  2.13           C  
ATOM   1465  O   VAL    97       3.820   7.463   1.560  1.00 62.41           O  
ATOM   1466  CB  VAL    97       4.482   4.840   3.469  1.00 14.51           C  
ATOM   1467  CG1 VAL    97       3.028   4.690   3.018  1.00 71.24           C  
ATOM   1468  CG2 VAL    97       5.166   3.484   3.543  1.00 15.31           C  
ATOM   1469  H   VAL    97       6.969   5.428   3.749  1.00 37.41           H  
ATOM   1470  HA  VAL    97       5.273   5.385   1.545  1.00  1.13           H  
ATOM   1471  HB  VAL    97       4.483   5.263   4.462  1.00 32.32           H  
ATOM   1472 HG11 VAL    97       2.517   3.998   3.672  1.00 37.41           H  
ATOM   1473 HG12 VAL    97       2.999   4.315   2.006  1.00 37.41           H  
ATOM   1474 HG13 VAL    97       2.536   5.653   3.057  1.00 37.41           H  
ATOM   1475 HG21 VAL    97       6.196   3.614   3.837  1.00 37.41           H  
ATOM   1476 HG22 VAL    97       5.126   3.005   2.576  1.00 37.41           H  
ATOM   1477 HG23 VAL    97       4.663   2.866   4.269  1.00 37.41           H  
ATOM   1478  N   MET    98       4.684   7.935   3.575  1.00 75.31           N  
ATOM   1479  CA  MET    98       4.060   9.256   3.635  1.00 41.35           C  
ATOM   1480  C   MET    98       4.594  10.166   2.521  1.00 41.34           C  
ATOM   1481  O   MET    98       3.834  10.905   1.898  1.00  0.11           O  
ATOM   1482  CB  MET    98       4.282   9.904   5.010  1.00  4.12           C  
ATOM   1483  CG  MET    98       3.651   9.128   6.161  1.00  3.41           C  
ATOM   1484  SD  MET    98       3.719  10.019   7.729  1.00 30.23           S  
ATOM   1485  CE  MET    98       5.489  10.191   7.964  1.00 73.24           C  
ATOM   1486  H   MET    98       5.226   7.621   4.328  1.00 37.41           H  
ATOM   1487  HA  MET    98       2.997   9.119   3.485  1.00 63.30           H  
ATOM   1488  HB2 MET    98       5.345   9.979   5.192  1.00 37.41           H  
ATOM   1489  HB3 MET    98       3.857  10.899   5.001  1.00 37.41           H  
ATOM   1490  HG2 MET    98       2.615   8.938   5.924  1.00 37.41           H  
ATOM   1491  HG3 MET    98       4.171   8.187   6.275  1.00 37.41           H  
ATOM   1492  HE1 MET    98       5.914  10.735   7.133  1.00 37.41           H  
ATOM   1493  HE2 MET    98       5.944   9.212   8.020  1.00 37.41           H  
ATOM   1494  HE3 MET    98       5.681  10.729   8.882  1.00 37.41           H  
ATOM   1495  N   GLU    99       5.900  10.090   2.259  1.00 34.51           N  
ATOM   1496  CA  GLU    99       6.524  10.917   1.218  1.00 32.11           C  
ATOM   1497  C   GLU    99       6.046  10.539  -0.201  1.00 60.22           C  
ATOM   1498  O   GLU    99       5.629  11.400  -0.976  1.00 44.32           O  
ATOM   1499  CB  GLU    99       8.050  10.794   1.271  1.00 52.15           C  
ATOM   1500  CG  GLU    99       8.757  11.763   0.329  1.00 14.20           C  
ATOM   1501  CD  GLU    99      10.186  11.363   0.018  1.00 63.03           C  
ATOM   1502  OE1 GLU    99      11.087  11.658   0.828  1.00  4.14           O  
ATOM   1503  OE2 GLU    99      10.411  10.767  -1.055  1.00 13.44           O  
ATOM   1504  H   GLU    99       6.463   9.475   2.785  1.00 37.41           H  
ATOM   1505  HA  GLU    99       6.253  11.946   1.411  1.00 25.32           H  
ATOM   1506  HB2 GLU    99       8.383  10.993   2.280  1.00 37.41           H  
ATOM   1507  HB3 GLU    99       8.331   9.785   1.000  1.00 37.41           H  
ATOM   1508  HG2 GLU    99       8.204  11.808  -0.599  1.00 37.41           H  
ATOM   1509  HG3 GLU    99       8.764  12.745   0.782  1.00 37.41           H  
ATOM   1510  N   ASN   100       6.127   9.251  -0.544  1.00  3.11           N  
ATOM   1511  CA  ASN   100       5.842   8.796  -1.917  1.00 53.52           C  
ATOM   1512  C   ASN   100       4.372   8.388  -2.122  1.00 23.34           C  
ATOM   1513  O   ASN   100       3.846   8.496  -3.227  1.00 14.11           O  
ATOM   1514  CB  ASN   100       6.779   7.641  -2.304  1.00 64.23           C  
ATOM   1515  CG  ASN   100       6.757   6.484  -1.319  1.00 11.22           C  
ATOM   1516  OD1 ASN   100       5.763   6.225  -0.659  1.00  1.03           O  
ATOM   1517  ND2 ASN   100       7.864   5.780  -1.212  1.00 14.54           N  
ATOM   1518  H   ASN   100       6.376   8.589   0.139  1.00 37.41           H  
ATOM   1519  HA  ASN   100       6.048   9.629  -2.577  1.00  2.41           H  
ATOM   1520  HB2 ASN   100       6.490   7.260  -3.272  1.00 37.41           H  
ATOM   1521  HB3 ASN   100       7.792   8.017  -2.366  1.00 37.41           H  
ATOM   1522 HD21 ASN   100       8.632   6.031  -1.764  1.00 37.41           H  
ATOM   1523 HD22 ASN   100       7.867   5.034  -0.583  1.00 37.41           H  
ATOM   1524  N   GLY   101       3.716   7.930  -1.060  1.00 34.41           N  
ATOM   1525  CA  GLY   101       2.311   7.520  -1.144  1.00 21.04           C  
ATOM   1526  C   GLY   101       1.373   8.620  -1.650  1.00 72.40           C  
ATOM   1527  O   GLY   101       0.233   8.351  -2.033  1.00  3.20           O  
ATOM   1528  H   GLY   101       4.194   7.839  -0.209  1.00 37.41           H  
ATOM   1529  HA2 GLY   101       2.236   6.673  -1.809  1.00 37.41           H  
ATOM   1530  HA3 GLY   101       1.986   7.212  -0.161  1.00 37.41           H  
END
