
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   61 (  497),  selected   61 , name 3bid_E
# Molecule2: number of CA atoms   50 (  770),  selected   50 , name T0472_52_101.pdb
# PARAMETERS: 3bid_E.T0472_52_101.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_E      I      52          5.105
LGA    Y     2_E      E      53          3.738
LGA    -       -      A      54           -
LGA    -       -      R      55           -
LGA    F     3_E      Y      56          1.857
LGA    E     4_E      A      57          2.130
LGA    I     5_E      K      58          1.570
LGA    Y     6_E      E      59          1.322
LGA    K     7_E      V      60          0.572
LGA    D     8_E      A      61          1.262
LGA    A     9_E      K      62          2.657
LGA    K    10_E      N      63          2.320
LGA    G    11_E      D      64          1.801
LGA    E    12_E      K      65          1.010
LGA    Y    13_E      P      66          0.359
LGA    R    14_E      Y      67          0.233
LGA    W    15_E      F      68          0.970
LGA    R    16_E      N      69          1.017
LGA    L    17_E      L      70          0.750
LGA    K    18_E      K      71          0.932
LGA    A    19_E      A      72          1.059
LGA    A    20_E      A      73          1.137
LGA    N    21_E      N      74          1.459
LGA    H    22_E      H      75          0.856
LGA    E    23_E      Q      76          1.191
LGA    I    24_E      I      77          1.026
LGA    I    25_E      I      78          0.851
LGA    A    26_E      G      79          0.559
LGA    Q    27_E      T      80          0.469
LGA    G    28_E      S      81          0.563
LGA    E    29_E      Q      82          0.791
LGA    G    30_E      M      83          0.734
LGA    Y    31_E      Y      84          0.903
LGA    T    32_E      S      85          1.290
LGA    S    33_E      S      86          1.394
LGA    K    34_E      T      87          1.045
LGA    Q    35_E      A      88          0.527
LGA    N    36_E      A      89          0.322
LGA    C    37_E      R      90          0.298
LGA    Q    38_E      D      91          0.552
LGA    H    39_E      N      92          0.675
LGA    A    40_E      G      93          0.759
LGA    V    41_E      I      94          0.972
LGA    D    42_E      K      95          0.608
LGA    L    43_E      S      96          0.525
LGA    L    44_E      V      97          1.342
LGA    K    45_E      M      98          0.900
LGA    S    46_E      E      99          0.721
LGA    T    47_E      N     100          1.601
LGA    T    48_E      G     101           #
LGA    A    49_E      -       -           -
LGA    A    50_E      -       -           -
LGA    T    51_E      -       -           -
LGA    P    52_E      -       -           -
LGA    V    53_E      -       -           -
LGA    K    54_E      -       -           -
LGA    E    55_E      -       -           -
LGA    V    56_E      -       -           -
LGA    L    57_E      -       -           -
LGA    E    58_E      -       -           -
LGA    H    59_E      -       -           -
LGA    H    60_E      -       -           -
LGA    H    61_E      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   61   50    5.0     47    1.46    21.28     90.860     3.022

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.238314 * X  +   0.888724 * Y  +   0.391633 * Z  + -46.552086
  Y_new =   0.935708 * X  +   0.102110 * Y  +   0.337675 * Z  + -35.153210
  Z_new =   0.260110 * X  +   0.446927 * Y  +  -0.855920 * Z  +  38.452187 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.660375   -0.481218  [ DEG:   152.4282    -27.5718 ]
  Theta =  -0.263136   -2.878456  [ DEG:   -15.0766   -164.9234 ]
  Phi   =   1.820183   -1.321410  [ DEG:   104.2888    -75.7112 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3bid_E                                        
REMARK     2: T0472_52_101.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3bid_E.T0472_52_101.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   61   50   5.0   47   1.46   21.28  90.860
REMARK  ---------------------------------------------------------- 
MOLECULE 3bid_E
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   30-NOV-07   3BID              
TITLE     CRYSTAL STRUCTURE OF THE NMB1088 PROTEIN FROM NEISSERIA               
TITLE    2 MENINGITIDIS. NORTHEAST STRUCTURAL GENOMICS CONSORTIUM               
TITLE    3 TARGET MR91                                                          
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UPF0339 PROTEIN NMB1088;                                   
COMPND   3 CHAIN: A, B, C, D, E, F, G, H;                                       
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: NEISSERIA MENINGITIDIS MC58;                    
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: MC58 / SEROGROUP B;                                          
SOURCE   5 GENE: NMB1088, 903505;                                               
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)+MAGIC;                           
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET21                                     
KEYWDS    ALPHA-BETA PROTEIN, STRUCTURAL GENOMICS, PSI-2, PROTEIN               
KEYWDS   2 STRUCTURE INITIATIVE, NORTHEAST STRUCTURAL GENOMICS                  
KEYWDS   3 CONSORTIUM, NESG, STRUCTURAL GENOMICS, UNKNOWN FUNCTION              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    F.FOROUHAR,H.NEELY,J.SEETHARAMAN,L.MAO,Y.FANG,R.XIAO,                 
AUTHOR   2 L.A.OWEN,M.MAGLAQUI,K.CUNNINGHAM,M.C.BARAN,T.B.ACTON,                
AUTHOR   3 G.T.MONTELIONE,L.TONG,J.F.HUNT,NORTHEAST STRUCTURAL                  
AUTHOR   4 GENOMICS CONSORTIUM (NESG)                                           
REVDAT   1   18-DEC-07 3BID    0                                                
JRNL        AUTH   F.FOROUHAR,H.NEELY,J.SEETHARAMAN,L.MAO,Y.FANG,               
JRNL        AUTH 2 R.XIAO,L.A.OWEN,M.MAGLAQUI,K.CUNNINGHAM,M.C.BARAN,           
JRNL        AUTH 3 T.B.ACTON,G.T.MONTELIONE,L.TONG,J.F.HUNT                     
JRNL        TITL   CRYSTAL STRUCTURE OF THE NMB1088 PROTEIN FROM                
JRNL        TITL 2 NEISSERIA MENINGITIDIS.                                      
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.70 ANGSTROMS.                                          
DBREF  3BID A    1    56  UNP    Q7DDI1   Y1088_NEIMB      1     56             
DBREF  3BID B    1    56  UNP    Q7DDI1   Y1088_NEIMB      1     56             
DBREF  3BID C    1    56  UNP    Q7DDI1   Y1088_NEIMB      1     56             
DBREF  3BID D    1    56  UNP    Q7DDI1   Y1088_NEIMB      1     56             
DBREF  3BID E    1    56  UNP    Q7DDI1   Y1088_NEIMB      1     56             
DBREF  3BID F    1    56  UNP    Q7DDI1   Y1088_NEIMB      1     56             
DBREF  3BID G    1    56  UNP    Q7DDI1   Y1088_NEIMB      1     56             
DBREF  3BID H    1    56  UNP    Q7DDI1   Y1088_NEIMB      1     56             
SEQRES   1 A   64  MSE TYR PHE GLU ILE TYR LYS ASP ALA LYS GLY GLU TYR          
SEQRES   2 A   64  ARG TRP ARG LEU LYS ALA ALA ASN HIS GLU ILE ILE ALA          
SEQRES   3 A   64  GLN GLY GLU GLY TYR THR SER LYS GLN ASN CYS GLN HIS          
SEQRES   4 A   64  ALA VAL ASP LEU LEU LYS SER THR THR ALA ALA THR PRO          
SEQRES   5 A   64  VAL LYS GLU VAL LEU GLU HIS HIS HIS HIS HIS HIS              
SEQRES   1 B   64  MSE TYR PHE GLU ILE TYR LYS ASP ALA LYS GLY GLU TYR          
SEQRES   2 B   64  ARG TRP ARG LEU LYS ALA ALA ASN HIS GLU ILE ILE ALA          
SEQRES   3 B   64  GLN GLY GLU GLY TYR THR SER LYS GLN ASN CYS GLN HIS          
SEQRES   4 B   64  ALA VAL ASP LEU LEU LYS SER THR THR ALA ALA THR PRO          
SEQRES   5 B   64  VAL LYS GLU VAL LEU GLU HIS HIS HIS HIS HIS HIS              
SEQRES   1 C   64  MSE TYR PHE GLU ILE TYR LYS ASP ALA LYS GLY GLU TYR          
SEQRES   2 C   64  ARG TRP ARG LEU LYS ALA ALA ASN HIS GLU ILE ILE ALA          
SEQRES   3 C   64  GLN GLY GLU GLY TYR THR SER LYS GLN ASN CYS GLN HIS          
SEQRES   4 C   64  ALA VAL ASP LEU LEU LYS SER THR THR ALA ALA THR PRO          
SEQRES   5 C   64  VAL LYS GLU VAL LEU GLU HIS HIS HIS HIS HIS HIS              
SEQRES   1 D   64  MSE TYR PHE GLU ILE TYR LYS ASP ALA LYS GLY GLU TYR          
SEQRES   2 D   64  ARG TRP ARG LEU LYS ALA ALA ASN HIS GLU ILE ILE ALA          
SEQRES   3 D   64  GLN GLY GLU GLY TYR THR SER LYS GLN ASN CYS GLN HIS          
SEQRES   4 D   64  ALA VAL ASP LEU LEU LYS SER THR THR ALA ALA THR PRO          
SEQRES   5 D   64  VAL LYS GLU VAL LEU GLU HIS HIS HIS HIS HIS HIS              
SEQRES   1 E   64  MSE TYR PHE GLU ILE TYR LYS ASP ALA LYS GLY GLU TYR          
SEQRES   2 E   64  ARG TRP ARG LEU LYS ALA ALA ASN HIS GLU ILE ILE ALA          
SEQRES   3 E   64  GLN GLY GLU GLY TYR THR SER LYS GLN ASN CYS GLN HIS          
SEQRES   4 E   64  ALA VAL ASP LEU LEU LYS SER THR THR ALA ALA THR PRO          
SEQRES   5 E   64  VAL LYS GLU VAL LEU GLU HIS HIS HIS HIS HIS HIS              
SEQRES   1 F   64  MSE TYR PHE GLU ILE TYR LYS ASP ALA LYS GLY GLU TYR          
SEQRES   2 F   64  ARG TRP ARG LEU LYS ALA ALA ASN HIS GLU ILE ILE ALA          
SEQRES   3 F   64  GLN GLY GLU GLY TYR THR SER LYS GLN ASN CYS GLN HIS          
SEQRES   4 F   64  ALA VAL ASP LEU LEU LYS SER THR THR ALA ALA THR PRO          
SEQRES   5 F   64  VAL LYS GLU VAL LEU GLU HIS HIS HIS HIS HIS HIS              
SEQRES   1 G   64  MSE TYR PHE GLU ILE TYR LYS ASP ALA LYS GLY GLU TYR          
SEQRES   2 G   64  ARG TRP ARG LEU LYS ALA ALA ASN HIS GLU ILE ILE ALA          
SEQRES   3 G   64  GLN GLY GLU GLY TYR THR SER LYS GLN ASN CYS GLN HIS          
SEQRES   4 G   64  ALA VAL ASP LEU LEU LYS SER THR THR ALA ALA THR PRO          
SEQRES   5 G   64  VAL LYS GLU VAL LEU GLU HIS HIS HIS HIS HIS HIS              
SEQRES   1 H   64  MSE TYR PHE GLU ILE TYR LYS ASP ALA LYS GLY GLU TYR          
SEQRES   2 H   64  ARG TRP ARG LEU LYS ALA ALA ASN HIS GLU ILE ILE ALA          
SEQRES   3 H   64  GLN GLY GLU GLY TYR THR SER LYS GLN ASN CYS GLN HIS          
SEQRES   4 H   64  ALA VAL ASP LEU LEU LYS SER THR THR ALA ALA THR PRO          
SEQRES   5 H   64  VAL LYS GLU VAL LEU GLU HIS HIS HIS HIS HIS HIS              
HET    MSE  A   1       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  C   1       8                                                       
HET    MSE  D   1       8                                                       
HET    MSE  E   1       8                                                       
HET    MSE  F   1       8                                                       
HET    MSE  G   1       8                                                       
HET    MSE  H   1       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    8(C5 H11 N O2 SE)                                            
FORMUL   9  HOH   *28(H2 O)                                                     
CRYST1   34.743   60.040   64.370  89.39  90.81 103.97 P 1           8          
HETATM 1855  N   MSE E   1      -8.045   9.030   7.179  1.00 54.50           N  
HETATM 1856  CA  MSE E   1      -7.077   8.038   6.609  1.00 55.41           C  
HETATM 1857  C   MSE E   1      -5.856   8.037   7.523  1.00 52.04           C  
HETATM 1858  O   MSE E   1      -5.382   9.100   7.932  1.00 51.42           O  
HETATM 1859  CB  MSE E   1      -6.714   8.459   5.173  1.00 60.76           C  
HETATM 1860  CG  MSE E   1      -5.982   7.409   4.328  1.00 67.29           C  
HETATM 1861 SE   MSE E   1      -5.974   7.771   2.371  1.00 78.46          SE  
HETATM 1862  CE  MSE E   1      -4.448   8.982   2.231  1.00 73.10           C  
ATOM   1863  N   TYR E   2      -5.359   6.856   7.868  1.00 48.41           N  
ATOM   1864  CA  TYR E   2      -4.198   6.794   8.748  1.00 44.73           C  
ATOM   1865  C   TYR E   2      -3.413   5.488   8.629  1.00 42.52           C  
ATOM   1866  O   TYR E   2      -3.948   4.468   8.180  1.00 42.23           O  
ATOM   1867  CB  TYR E   2      -4.615   6.974  10.208  1.00 45.61           C  
ATOM   1868  CG  TYR E   2      -5.556   5.903  10.715  1.00 47.06           C  
ATOM   1869  CD1 TYR E   2      -6.907   5.920  10.373  1.00 46.30           C  
ATOM   1870  CD2 TYR E   2      -5.080   4.838  11.491  1.00 47.75           C  
ATOM   1871  CE1 TYR E   2      -7.762   4.902  10.783  1.00 48.32           C  
ATOM   1872  CE2 TYR E   2      -5.925   3.813  11.913  1.00 47.77           C  
ATOM   1873  CZ  TYR E   2      -7.263   3.851  11.553  1.00 50.01           C  
ATOM   1874  OH  TYR E   2      -8.106   2.836  11.954  1.00 51.89           O  
ATOM   1875  N   PHE E   3      -2.138   5.524   9.026  1.00 38.45           N  
ATOM   1876  CA  PHE E   3      -1.295   4.336   8.968  1.00 35.25           C  
ATOM   1877  C   PHE E   3      -1.371   3.659  10.325  1.00 37.00           C  
ATOM   1878  O   PHE E   3      -1.634   4.300  11.340  1.00 35.94           O  
ATOM   1879  CB  PHE E   3       0.166   4.682   8.656  1.00 31.82           C  
ATOM   1880  CG  PHE E   3       0.421   4.998   7.199  1.00 27.96           C  
ATOM   1881  CD1 PHE E   3       0.490   6.310   6.759  1.00 26.88           C  
ATOM   1882  CD2 PHE E   3       0.689   3.981   6.295  1.00 26.08           C  
ATOM   1883  CE1 PHE E   3       0.773   6.601   5.430  1.00 27.73           C  
ATOM   1884  CE2 PHE E   3       0.968   4.259   4.968  1.00 25.19           C  
ATOM   1885  CZ  PHE E   3       1.041   5.569   4.539  1.00 25.15           C  
ATOM   1886  N   GLU E   4      -1.141   2.351  10.338  1.00 39.01           N  
ATOM   1887  CA  GLU E   4      -1.198   1.572  11.566  1.00 39.85           C  
ATOM   1888  C   GLU E   4      -0.055   0.551  11.612  1.00 39.20           C  
ATOM   1889  O   GLU E   4       0.035  -0.303  10.735  1.00 39.48           O  
ATOM   1890  CB  GLU E   4      -2.553   0.872  11.621  1.00 42.31           C  
ATOM   1891  CG  GLU E   4      -2.970   0.365  12.976  1.00 48.06           C  
ATOM   1892  CD  GLU E   4      -4.380  -0.216  12.952  1.00 51.98           C  
ATOM   1893  OE1 GLU E   4      -4.595  -1.238  12.256  1.00 53.63           O  
ATOM   1894  OE2 GLU E   4      -5.276   0.343  13.626  1.00 55.03           O  
ATOM   1895  N   ILE E   5       0.806   0.643  12.631  1.00 37.78           N  
ATOM   1896  CA  ILE E   5       1.954  -0.271  12.801  1.00 36.13           C  
ATOM   1897  C   ILE E   5       1.673  -1.284  13.924  1.00 37.59           C  
ATOM   1898  O   ILE E   5       1.282  -0.905  15.029  1.00 37.00           O  
ATOM   1899  CB  ILE E   5       3.240   0.526  13.132  1.00 35.27           C  
ATOM   1900  CG1 ILE E   5       3.598   1.420  11.935  1.00 33.92           C  
ATOM   1901  CG2 ILE E   5       4.378  -0.412  13.459  1.00 34.43           C  
ATOM   1902  CD1 ILE E   5       4.817   2.275  12.170  1.00 33.22           C  
ATOM   1903  N   TYR E   6       1.875  -2.565  13.633  1.00 37.99           N  
ATOM   1904  CA  TYR E   6       1.618  -3.616  14.608  1.00 39.77           C  
ATOM   1905  C   TYR E   6       2.561  -4.817  14.458  1.00 42.26           C  
ATOM   1906  O   TYR E   6       3.363  -4.877  13.530  1.00 42.10           O  
ATOM   1907  CB  TYR E   6       0.162  -4.107  14.503  1.00 38.07           C  
ATOM   1908  CG  TYR E   6      -0.163  -4.801  13.197  1.00 38.28           C  
ATOM   1909  CD1 TYR E   6      -0.345  -4.062  12.021  1.00 37.85           C  
ATOM   1910  CD2 TYR E   6      -0.216  -6.197  13.120  1.00 37.04           C  
ATOM   1911  CE1 TYR E   6      -0.561  -4.691  10.797  1.00 39.12           C  
ATOM   1912  CE2 TYR E   6      -0.431  -6.845  11.898  1.00 38.74           C  
ATOM   1913  CZ  TYR E   6      -0.596  -6.088  10.735  1.00 41.58           C  
ATOM   1914  OH  TYR E   6      -0.739  -6.722   9.504  1.00 42.70           O  
ATOM   1915  N   LYS E   7       2.441  -5.776  15.372  1.00 45.49           N  
ATOM   1916  CA  LYS E   7       3.262  -6.977  15.349  1.00 49.84           C  
ATOM   1917  C   LYS E   7       2.451  -8.247  15.105  1.00 52.28           C  
ATOM   1918  O   LYS E   7       1.387  -8.431  15.695  1.00 50.33           O  
ATOM   1919  CB  LYS E   7       4.015  -7.128  16.671  1.00 50.95           C  
ATOM   1920  CG  LYS E   7       4.751  -8.453  16.794  1.00 54.01           C  
ATOM   1921  CD  LYS E   7       5.468  -8.603  18.122  1.00 56.82           C  
ATOM   1922  CE  LYS E   7       6.572  -7.572  18.296  1.00 58.27           C  
ATOM   1923  NZ  LYS E   7       7.376  -7.861  19.527  1.00 60.49           N  
ATOM   1924  N   ASP E   8       2.994  -9.155  14.289  1.00 56.49           N  
ATOM   1925  CA  ASP E   8       2.324 -10.433  13.975  1.00 61.73           C  
ATOM   1926  C   ASP E   8       2.777 -11.597  14.884  1.00 63.67           C  
ATOM   1927  O   ASP E   8       3.854 -11.541  15.471  1.00 63.98           O  
ATOM   1928  CB  ASP E   8       2.554 -10.772  12.496  1.00 64.32           C  
ATOM   1929  CG  ASP E   8       4.020 -10.937  12.151  1.00 66.27           C  
ATOM   1930  OD1 ASP E   8       4.356 -10.970  10.944  1.00 68.01           O  
ATOM   1931  OD2 ASP E   8       4.840 -11.042  13.081  1.00 67.32           O  
ATOM   1932  N   ALA E   9       1.961 -12.647  14.996  1.00 67.17           N  
ATOM   1933  CA  ALA E   9       2.274 -13.794  15.867  1.00 70.54           C  
ATOM   1934  C   ALA E   9       3.725 -14.262  15.787  1.00 72.99           C  
ATOM   1935  O   ALA E   9       4.255 -14.862  16.734  1.00 72.99           O  
ATOM   1936  CB  ALA E   9       1.327 -14.971  15.569  1.00 71.22           C  
ATOM   1937  N   LYS E  10       4.364 -13.981  14.656  1.00 74.59           N  
ATOM   1938  CA  LYS E  10       5.765 -14.346  14.446  1.00 75.43           C  
ATOM   1939  C   LYS E  10       6.680 -13.537  15.381  1.00 74.00           C  
ATOM   1940  O   LYS E  10       7.551 -14.102  16.033  1.00 74.22           O  
ATOM   1941  CB  LYS E  10       6.157 -14.091  12.984  1.00 77.85           C  
ATOM   1942  CG  LYS E  10       5.339 -14.864  11.951  1.00 80.37           C  
ATOM   1943  CD  LYS E  10       5.844 -14.596  10.537  1.00 81.49           C  
ATOM   1944  CE  LYS E  10       5.161 -15.495   9.517  1.00 82.98           C  
ATOM   1945  NZ  LYS E  10       5.784 -15.403   8.164  1.00 81.20           N  
ATOM   1946  N   GLY E  11       6.481 -12.221  15.428  1.00 72.50           N  
ATOM   1947  CA  GLY E  11       7.294 -11.383  16.286  1.00 70.62           C  
ATOM   1948  C   GLY E  11       7.882 -10.160  15.601  1.00 69.92           C  
ATOM   1949  O   GLY E  11       8.574  -9.353  16.233  1.00 69.85           O  
ATOM   1950  N   GLU E  12       7.607 -10.025  14.306  1.00 68.36           N  
ATOM   1951  CA  GLU E  12       8.096  -8.905  13.496  1.00 65.97           C  
ATOM   1952  C   GLU E  12       7.062  -7.804  13.363  1.00 63.20           C  
ATOM   1953  O   GLU E  12       5.903  -7.978  13.725  1.00 63.87           O  
ATOM   1954  CB  GLU E  12       8.486  -9.395  12.105  1.00 68.05           C  
ATOM   1955  CG  GLU E  12       7.465 -10.290  11.447  1.00 70.00           C  
ATOM   1956  CD  GLU E  12       8.111 -11.200  10.435  1.00 71.85           C  
ATOM   1957  OE1 GLU E  12       8.632 -10.683   9.425  1.00 73.34           O  
ATOM   1958  OE2 GLU E  12       8.121 -12.428  10.663  1.00 72.46           O  
ATOM   1959  N   TYR E  13       7.484  -6.670  12.824  1.00 59.30           N  
ATOM   1960  CA  TYR E  13       6.585  -5.544  12.680  1.00 56.43           C  
ATOM   1961  C   TYR E  13       6.133  -5.356  11.257  1.00 53.96           C  
ATOM   1962  O   TYR E  13       6.862  -5.678  10.325  1.00 54.59           O  
ATOM   1963  CB  TYR E  13       7.266  -4.275  13.160  1.00 58.97           C  
ATOM   1964  CG  TYR E  13       7.446  -4.236  14.654  1.00 59.47           C  
ATOM   1965  CD1 TYR E  13       6.445  -3.734  15.480  1.00 59.29           C  
ATOM   1966  CD2 TYR E  13       8.623  -4.692  15.244  1.00 60.18           C  
ATOM   1967  CE1 TYR E  13       6.616  -3.678  16.857  1.00 61.30           C  
ATOM   1968  CE2 TYR E  13       8.804  -4.643  16.617  1.00 61.88           C  
ATOM   1969  CZ  TYR E  13       7.799  -4.130  17.416  1.00 62.04           C  
ATOM   1970  OH  TYR E  13       7.998  -4.050  18.769  1.00 63.01           O  
ATOM   1971  N   ARG E  14       4.930  -4.821  11.088  1.00 50.03           N  
ATOM   1972  CA  ARG E  14       4.396  -4.588   9.758  1.00 46.53           C  
ATOM   1973  C   ARG E  14       3.383  -3.483   9.824  1.00 44.40           C  
ATOM   1974  O   ARG E  14       2.848  -3.205  10.885  1.00 44.37           O  
ATOM   1975  CB  ARG E  14       3.742  -5.845   9.227  1.00 46.42           C  
ATOM   1976  CG  ARG E  14       3.133  -6.644  10.324  1.00 48.90           C  
ATOM   1977  CD  ARG E  14       2.626  -7.956   9.801  1.00 52.70           C  
ATOM   1978  NE  ARG E  14       3.508  -8.519   8.793  1.00 56.65           N  
ATOM   1979  CZ  ARG E  14       3.271  -9.663   8.166  1.00 59.21           C  
ATOM   1980  NH1 ARG E  14       4.119 -10.106   7.245  1.00 61.38           N  
ATOM   1981  NH2 ARG E  14       2.190 -10.372   8.470  1.00 59.20           N  
ATOM   1982  N   TRP E  15       3.127  -2.856   8.680  1.00 41.47           N  
ATOM   1983  CA  TRP E  15       2.186  -1.759   8.587  1.00 38.80           C  
ATOM   1984  C   TRP E  15       0.964  -2.013   7.666  1.00 39.31           C  
ATOM   1985  O   TRP E  15       0.885  -3.038   6.976  1.00 38.08           O  
ATOM   1986  CB  TRP E  15       2.942  -0.515   8.123  1.00 37.22           C  
ATOM   1987  CG  TRP E  15       3.530  -0.633   6.753  1.00 36.01           C  
ATOM   1988  CD1 TRP E  15       4.807  -0.990   6.430  1.00 34.90           C  
ATOM   1989  CD2 TRP E  15       2.872  -0.326   5.519  1.00 34.88           C  
ATOM   1990  NE1 TRP E  15       4.990  -0.910   5.068  1.00 33.36           N  
ATOM   1991  CE2 TRP E  15       3.816  -0.507   4.486  1.00 34.45           C  
ATOM   1992  CE3 TRP E  15       1.575   0.083   5.189  1.00 33.60           C  
ATOM   1993  CZ2 TRP E  15       3.504  -0.279   3.140  1.00 34.38           C  
ATOM   1994  CZ3 TRP E  15       1.264   0.308   3.856  1.00 34.33           C  
ATOM   1995  CH2 TRP E  15       2.226   0.125   2.845  1.00 33.38           C  
ATOM   1996  N   ARG E  16       0.012  -1.071   7.685  1.00 39.79           N  
ATOM   1997  CA  ARG E  16      -1.216  -1.117   6.866  1.00 41.22           C  
ATOM   1998  C   ARG E  16      -1.937   0.245   6.831  1.00 40.69           C  
ATOM   1999  O   ARG E  16      -1.950   0.977   7.824  1.00 39.32           O  
ATOM   2000  CB  ARG E  16      -2.189  -2.186   7.389  1.00 42.92           C  
ATOM   2001  CG  ARG E  16      -2.655  -1.974   8.816  1.00 44.59           C  
ATOM   2002  CD  ARG E  16      -4.033  -2.551   9.030  1.00 47.24           C  
ATOM   2003  NE  ARG E  16      -4.053  -3.999   8.987  1.00 51.59           N  
ATOM   2004  CZ  ARG E  16      -3.994  -4.778  10.061  1.00 55.01           C  
ATOM   2005  NH1 ARG E  16      -4.021  -6.105   9.922  1.00 56.20           N  
ATOM   2006  NH2 ARG E  16      -3.879  -4.238  11.268  1.00 53.85           N  
ATOM   2007  N   LEU E  17      -2.530   0.581   5.685  1.00 40.89           N  
ATOM   2008  CA  LEU E  17      -3.245   1.860   5.509  1.00 40.11           C  
ATOM   2009  C   LEU E  17      -4.755   1.648   5.646  1.00 42.01           C  
ATOM   2010  O   LEU E  17      -5.315   0.785   4.975  1.00 40.40           O  
ATOM   2011  CB  LEU E  17      -2.943   2.446   4.119  1.00 34.14           C  
ATOM   2012  CG  LEU E  17      -2.573   3.908   4.043  1.00 30.45           C  
ATOM   2013  CD1 LEU E  17      -2.827   4.422   2.655  1.00 30.39           C  
ATOM   2014  CD2 LEU E  17      -3.371   4.706   5.041  1.00 31.45           C  
ATOM   2015  N   LYS E  18      -5.419   2.434   6.493  1.00 45.06           N  
ATOM   2016  CA  LYS E  18      -6.868   2.279   6.687  1.00 48.22           C  
ATOM   2017  C   LYS E  18      -7.703   3.491   6.249  1.00 50.82           C  
ATOM   2018  O   LYS E  18      -7.231   4.632   6.292  1.00 51.69           O  
ATOM   2019  CB  LYS E  18      -7.174   1.951   8.162  1.00 46.53           C  
ATOM   2020  CG  LYS E  18      -6.839   0.525   8.597  1.00 45.45           C  
ATOM   2021  CD  LYS E  18      -7.557   0.141   9.893  1.00 45.66           C  
ATOM   2022  CE  LYS E  18      -7.485  -1.368  10.144  1.00 45.37           C  
ATOM   2023  NZ  LYS E  18      -8.235  -1.829  11.350  1.00 45.08           N  
ATOM   2024  N   ALA E  19      -8.944   3.245   5.829  1.00 53.43           N  
ATOM   2025  CA  ALA E  19      -9.829   4.331   5.389  1.00 56.89           C  
ATOM   2026  C   ALA E  19     -10.587   4.989   6.551  1.00 59.27           C  
ATOM   2027  O   ALA E  19     -10.438   4.580   7.701  1.00 60.60           O  
ATOM   2028  CB  ALA E  19     -10.819   3.818   4.345  1.00 55.71           C  
ATOM   2029  N   ALA E  20     -11.386   6.015   6.243  1.00 61.55           N  
ATOM   2030  CA  ALA E  20     -12.154   6.748   7.260  1.00 63.34           C  
ATOM   2031  C   ALA E  20     -13.403   5.985   7.687  1.00 64.54           C  
ATOM   2032  O   ALA E  20     -14.154   6.434   8.558  1.00 63.92           O  
ATOM   2033  CB  ALA E  20     -12.544   8.123   6.737  1.00 63.71           C  
ATOM   2034  N   ASN E  21     -13.617   4.835   7.056  1.00 65.53           N  
ATOM   2035  CA  ASN E  21     -14.752   3.988   7.363  1.00 67.15           C  
ATOM   2036  C   ASN E  21     -14.243   2.641   7.853  1.00 68.55           C  
ATOM   2037  O   ASN E  21     -15.004   1.672   7.947  1.00 68.76           O  
ATOM   2038  CB  ASN E  21     -15.645   3.801   6.130  1.00 67.01           C  
ATOM   2039  CG  ASN E  21     -14.855   3.517   4.868  1.00 68.07           C  
ATOM   2040  OD1 ASN E  21     -14.374   4.438   4.198  1.00 69.12           O  
ATOM   2041  ND2 ASN E  21     -14.713   2.238   4.537  1.00 67.40           N  
ATOM   2042  N   HIS E  22     -12.950   2.596   8.171  1.00 69.85           N  
ATOM   2043  CA  HIS E  22     -12.298   1.386   8.663  1.00 70.66           C  
ATOM   2044  C   HIS E  22     -12.239   0.297   7.587  1.00 70.28           C  
ATOM   2045  O   HIS E  22     -13.128  -0.556   7.483  1.00 70.32           O  
ATOM   2046  CB  HIS E  22     -13.024   0.864   9.911  1.00 72.94           C  
ATOM   2047  CG  HIS E  22     -12.823   1.708  11.130  1.00 75.31           C  
ATOM   2048  ND1 HIS E  22     -13.139   1.269  12.400  1.00 77.34           N  
ATOM   2049  CD2 HIS E  22     -12.325   2.959  11.280  1.00 75.92           C  
ATOM   2050  CE1 HIS E  22     -12.841   2.212  13.277  1.00 78.01           C  
ATOM   2051  NE2 HIS E  22     -12.345   3.248  12.623  1.00 76.92           N  
ATOM   2052  N   GLU E  23     -11.183   0.333   6.785  1.00 69.01           N  
ATOM   2053  CA  GLU E  23     -11.007  -0.631   5.712  1.00 67.71           C  
ATOM   2054  C   GLU E  23      -9.565  -0.620   5.267  1.00 64.18           C  
ATOM   2055  O   GLU E  23      -8.979   0.440   5.056  1.00 64.31           O  
ATOM   2056  CB  GLU E  23     -11.894  -0.281   4.515  1.00 71.01           C  
ATOM   2057  CG  GLU E  23     -13.242  -0.986   4.485  1.00 77.28           C  
ATOM   2058  CD  GLU E  23     -13.295  -2.118   3.466  1.00 80.85           C  
ATOM   2059  OE1 GLU E  23     -13.239  -1.836   2.243  1.00 83.84           O  
ATOM   2060  OE2 GLU E  23     -13.386  -3.293   3.889  1.00 82.45           O  
ATOM   2061  N   ILE E  24      -9.006  -1.813   5.126  1.00 59.53           N  
ATOM   2062  CA  ILE E  24      -7.630  -1.961   4.697  1.00 55.07           C  
ATOM   2063  C   ILE E  24      -7.484  -1.572   3.234  1.00 52.60           C  
ATOM   2064  O   ILE E  24      -8.173  -2.113   2.372  1.00 52.70           O  
ATOM   2065  CB  ILE E  24      -7.150  -3.400   4.842  1.00 55.85           C  
ATOM   2066  CG1 ILE E  24      -7.335  -3.873   6.279  1.00 55.67           C  
ATOM   2067  CG2 ILE E  24      -5.683  -3.493   4.456  1.00 56.08           C  
ATOM   2068  CD1 ILE E  24      -7.000  -5.338   6.453  1.00 54.81           C  
ATOM   2069  N   ILE E  25      -6.574  -0.635   2.978  1.00 48.89           N  
ATOM   2070  CA  ILE E  25      -6.285  -0.131   1.646  1.00 44.32           C  
ATOM   2071  C   ILE E  25      -4.954  -0.647   1.113  1.00 44.75           C  
ATOM   2072  O   ILE E  25      -4.791  -0.792  -0.092  1.00 44.17           O  
ATOM   2073  CB  ILE E  25      -6.175   1.388   1.639  1.00 42.71           C  
ATOM   2074  CG1 ILE E  25      -7.495   2.029   2.035  1.00 41.40           C  
ATOM   2075  CG2 ILE E  25      -5.736   1.857   0.281  1.00 40.67           C  
ATOM   2076  CD1 ILE E  25      -7.457   3.552   1.934  1.00 40.53           C  
ATOM   2077  N   ALA E  26      -3.988  -0.883   1.999  1.00 44.08           N  
ATOM   2078  CA  ALA E  26      -2.683  -1.368   1.563  1.00 44.19           C  
ATOM   2079  C   ALA E  26      -1.921  -2.009   2.704  1.00 45.18           C  
ATOM   2080  O   ALA E  26      -1.918  -1.496   3.823  1.00 44.38           O  
ATOM   2081  CB  ALA E  26      -1.868  -0.240   0.955  1.00 44.19           C  
ATOM   2082  N   GLN E  27      -1.293  -3.144   2.387  1.00 46.78           N  
ATOM   2083  CA  GLN E  27      -0.515  -3.963   3.320  1.00 48.45           C  
ATOM   2084  C   GLN E  27       0.971  -3.934   2.961  1.00 49.25           C  
ATOM   2085  O   GLN E  27       1.322  -3.871   1.789  1.00 49.13           O  
ATOM   2086  CB  GLN E  27      -1.015  -5.412   3.265  1.00 49.73           C  
ATOM   2087  CG  GLN E  27      -2.377  -5.663   3.902  1.00 50.40           C  
ATOM   2088  CD  GLN E  27      -2.267  -5.917   5.387  1.00 53.64           C  
ATOM   2089  OE1 GLN E  27      -3.269  -6.121   6.076  1.00 54.87           O  
ATOM   2090  NE2 GLN E  27      -1.037  -5.911   5.895  1.00 57.32           N  
ATOM   2091  N   GLY E  28       1.838  -4.001   3.967  1.00 52.90           N  
ATOM   2092  CA  GLY E  28       3.270  -3.963   3.712  1.00 56.31           C  
ATOM   2093  C   GLY E  28       4.115  -5.084   4.298  1.00 59.68           C  
ATOM   2094  O   GLY E  28       3.806  -5.638   5.363  1.00 60.70           O  
ATOM   2095  N   GLU E  29       5.200  -5.411   3.589  1.00 61.79           N  
ATOM   2096  CA  GLU E  29       6.141  -6.474   3.979  1.00 63.07           C  
ATOM   2097  C   GLU E  29       6.581  -6.420   5.441  1.00 60.95           C  
ATOM   2098  O   GLU E  29       6.573  -5.361   6.070  1.00 59.98           O  
ATOM   2099  CB  GLU E  29       7.384  -6.431   3.074  1.00 65.74           C  
ATOM   2100  CG  GLU E  29       8.533  -7.342   3.530  1.00 73.07           C  
ATOM   2101  CD  GLU E  29       8.331  -8.827   3.185  1.00 77.54           C  
ATOM   2102  OE1 GLU E  29       9.128  -9.666   3.675  1.00 78.15           O  
ATOM   2103  OE2 GLU E  29       7.392  -9.151   2.419  1.00 79.62           O  
ATOM   2104  N   GLY E  30       6.962  -7.578   5.967  1.00 59.34           N  
ATOM   2105  CA  GLY E  30       7.419  -7.668   7.344  1.00 58.71           C  
ATOM   2106  C   GLY E  30       8.891  -7.310   7.494  1.00 57.81           C  
ATOM   2107  O   GLY E  30       9.741  -7.784   6.739  1.00 56.84           O  
ATOM   2108  N   TYR E  31       9.200  -6.470   8.473  1.00 57.87           N  
ATOM   2109  CA  TYR E  31      10.574  -6.055   8.696  1.00 58.22           C  
ATOM   2110  C   TYR E  31      11.206  -6.703   9.947  1.00 58.05           C  
ATOM   2111  O   TYR E  31      10.516  -7.331  10.758  1.00 56.86           O  
ATOM   2112  CB  TYR E  31      10.640  -4.521   8.768  1.00 57.74           C  
ATOM   2113  CG  TYR E  31      10.071  -3.830   7.533  1.00 58.34           C  
ATOM   2114  CD1 TYR E  31       8.688  -3.712   7.344  1.00 59.65           C  
ATOM   2115  CD2 TYR E  31      10.910  -3.347   6.526  1.00 57.53           C  
ATOM   2116  CE1 TYR E  31       8.156  -3.136   6.180  1.00 59.56           C  
ATOM   2117  CE2 TYR E  31      10.385  -2.772   5.356  1.00 58.14           C  
ATOM   2118  CZ  TYR E  31       9.008  -2.675   5.189  1.00 58.89           C  
ATOM   2119  OH  TYR E  31       8.485  -2.158   4.017  1.00 60.32           O  
ATOM   2120  N   THR E  32      12.524  -6.560  10.090  1.00 59.44           N  
ATOM   2121  CA  THR E  32      13.251  -7.142  11.221  1.00 60.44           C  
ATOM   2122  C   THR E  32      12.888  -6.435  12.523  1.00 61.17           C  
ATOM   2123  O   THR E  32      12.420  -7.065  13.478  1.00 62.12           O  
ATOM   2124  CB  THR E  32      14.780  -7.067  10.991  1.00 59.33           C  
ATOM   2125  OG1 THR E  32      15.128  -5.744  10.593  1.00 61.06           O  
ATOM   2126  CG2 THR E  32      15.223  -8.032   9.890  1.00 57.31           C  
ATOM   2127  N   SER E  33      13.084  -5.122  12.536  1.00 61.26           N  
ATOM   2128  CA  SER E  33      12.805  -4.287  13.699  1.00 62.15           C  
ATOM   2129  C   SER E  33      11.697  -3.267  13.420  1.00 62.82           C  
ATOM   2130  O   SER E  33      11.361  -2.989  12.267  1.00 63.95           O  
ATOM   2131  CB  SER E  33      14.075  -3.532  14.089  1.00 62.69           C  
ATOM   2132  OG  SER E  33      14.515  -2.702  13.018  1.00 62.10           O  
ATOM   2133  N   LYS E  34      11.145  -2.702  14.487  1.00 62.47           N  
ATOM   2134  CA  LYS E  34      10.100  -1.696  14.376  1.00 62.82           C  
ATOM   2135  C   LYS E  34      10.652  -0.459  13.677  1.00 63.45           C  
ATOM   2136  O   LYS E  34       9.919   0.314  13.061  1.00 63.35           O  
ATOM   2137  CB  LYS E  34       9.603  -1.298  15.760  1.00 61.84           C  
ATOM   2138  CG  LYS E  34       8.461  -0.315  15.714  1.00 62.35           C  
ATOM   2139  CD  LYS E  34       7.969   0.033  17.097  1.00 63.89           C  
ATOM   2140  CE  LYS E  34       8.940   0.942  17.817  1.00 63.02           C  
ATOM   2141  NZ  LYS E  34       8.399   1.315  19.150  1.00 62.65           N  
ATOM   2142  N   GLN E  35      11.959  -0.276  13.789  1.00 64.59           N  
ATOM   2143  CA  GLN E  35      12.631   0.858  13.181  1.00 64.36           C  
ATOM   2144  C   GLN E  35      12.519   0.822  11.659  1.00 62.70           C  
ATOM   2145  O   GLN E  35      12.170   1.821  11.038  1.00 61.16           O  
ATOM   2146  CB  GLN E  35      14.103   0.847  13.590  1.00 68.37           C  
ATOM   2147  CG  GLN E  35      14.927   1.986  13.021  1.00 73.88           C  
ATOM   2148  CD  GLN E  35      14.489   3.337  13.551  1.00 77.28           C  
ATOM   2149  OE1 GLN E  35      13.377   3.796  13.279  1.00 78.86           O  
ATOM   2150  NE2 GLN E  35      15.360   3.979  14.328  1.00 79.06           N  
ATOM   2151  N   ASN E  36      12.821  -0.325  11.059  1.00 60.39           N  
ATOM   2152  CA  ASN E  36      12.753  -0.435   9.606  1.00 57.54           C  
ATOM   2153  C   ASN E  36      11.344  -0.233   9.073  1.00 55.67           C  
ATOM   2154  O   ASN E  36      11.164   0.282   7.971  1.00 55.18           O  
ATOM   2155  CB  ASN E  36      13.281  -1.790   9.144  1.00 58.58           C  
ATOM   2156  CG  ASN E  36      14.736  -1.988   9.506  1.00 61.22           C  
ATOM   2157  OD1 ASN E  36      15.562  -1.092   9.311  1.00 61.26           O  
ATOM   2158  ND2 ASN E  36      15.064  -3.162  10.031  1.00 62.42           N  
ATOM   2159  N   CYS E  37      10.344  -0.637   9.851  1.00 53.18           N  
ATOM   2160  CA  CYS E  37       8.960  -0.502   9.429  1.00 51.70           C  
ATOM   2161  C   CYS E  37       8.540   0.952   9.392  1.00 51.24           C  
ATOM   2162  O   CYS E  37       7.859   1.391   8.470  1.00 51.97           O  
ATOM   2163  CB  CYS E  37       8.048  -1.272  10.376  1.00 50.64           C  
ATOM   2164  SG  CYS E  37       6.346  -1.352   9.816  1.00 47.18           S  
ATOM   2165  N   GLN E  38       8.956   1.700  10.400  1.00 50.63           N  
ATOM   2166  CA  GLN E  38       8.609   3.101  10.484  1.00 50.24           C  
ATOM   2167  C   GLN E  38       9.277   3.898   9.360  1.00 48.83           C  
ATOM   2168  O   GLN E  38       8.701   4.851   8.852  1.00 49.21           O  
ATOM   2169  CB  GLN E  38       9.023   3.624  11.849  1.00 52.20           C  
ATOM   2170  CG  GLN E  38       8.466   4.973  12.197  1.00 59.36           C  
ATOM   2171  CD  GLN E  38       8.756   5.345  13.636  1.00 63.00           C  
ATOM   2172  OE1 GLN E  38       8.413   4.599  14.556  1.00 65.21           O  
ATOM   2173  NE2 GLN E  38       9.399   6.501  13.841  1.00 64.25           N  
ATOM   2174  N   HIS E  39      10.476   3.492   8.954  1.00 46.34           N  
ATOM   2175  CA  HIS E  39      11.204   4.181   7.894  1.00 43.15           C  
ATOM   2176  C   HIS E  39      10.487   4.001   6.568  1.00 40.52           C  
ATOM   2177  O   HIS E  39      10.400   4.928   5.757  1.00 39.69           O  
ATOM   2178  CB  HIS E  39      12.644   3.641   7.820  1.00 43.93           C  
ATOM   2179  CG  HIS E  39      13.524   4.360   6.850  1.00 46.06           C  
ATOM   2180  ND1 HIS E  39      13.761   5.722   6.924  1.00 46.94           N  
ATOM   2181  CD2 HIS E  39      14.218   3.922   5.772  1.00 45.34           C  
ATOM   2182  CE1 HIS E  39      14.552   6.081   5.933  1.00 48.14           C  
ATOM   2183  NE2 HIS E  39      14.846   5.005   5.217  1.00 46.96           N  
ATOM   2184  N   ALA E  40       9.974   2.799   6.341  1.00 38.34           N  
ATOM   2185  CA  ALA E  40       9.242   2.506   5.103  1.00 37.01           C  
ATOM   2186  C   ALA E  40       7.994   3.397   4.999  1.00 36.50           C  
ATOM   2187  O   ALA E  40       7.716   3.965   3.939  1.00 35.44           O  
ATOM   2188  CB  ALA E  40       8.837   1.033   5.071  1.00 34.90           C  
ATOM   2189  N   VAL E  41       7.259   3.523   6.105  1.00 36.28           N  
ATOM   2190  CA  VAL E  41       6.067   4.362   6.129  1.00 36.64           C  
ATOM   2191  C   VAL E  41       6.380   5.828   5.830  1.00 39.30           C  
ATOM   2192  O   VAL E  41       5.636   6.487   5.113  1.00 38.63           O  
ATOM   2193  CB  VAL E  41       5.336   4.272   7.489  1.00 36.16           C  
ATOM   2194  CG1 VAL E  41       4.145   5.231   7.513  1.00 33.32           C  
ATOM   2195  CG2 VAL E  41       4.850   2.853   7.719  1.00 35.41           C  
ATOM   2196  N   ASP E  42       7.483   6.337   6.375  1.00 42.02           N  
ATOM   2197  CA  ASP E  42       7.874   7.726   6.138  1.00 44.40           C  
ATOM   2198  C   ASP E  42       8.201   7.966   4.658  1.00 43.81           C  
ATOM   2199  O   ASP E  42       7.894   9.026   4.106  1.00 43.57           O  
ATOM   2200  CB  ASP E  42       9.078   8.116   7.011  1.00 49.17           C  
ATOM   2201  CG  ASP E  42       8.712   8.269   8.489  1.00 54.67           C  
ATOM   2202  OD1 ASP E  42       7.662   8.907   8.801  1.00 58.66           O  
ATOM   2203  OD2 ASP E  42       9.484   7.775   9.348  1.00 55.47           O  
ATOM   2204  N   LEU E  43       8.824   6.984   4.014  1.00 42.25           N  
ATOM   2205  CA  LEU E  43       9.154   7.114   2.600  1.00 41.84           C  
ATOM   2206  C   LEU E  43       7.895   7.104   1.737  1.00 41.04           C  
ATOM   2207  O   LEU E  43       7.788   7.873   0.777  1.00 39.09           O  
ATOM   2208  CB  LEU E  43      10.104   5.991   2.172  1.00 42.54           C  
ATOM   2209  CG  LEU E  43      11.559   6.189   2.638  1.00 42.52           C  
ATOM   2210  CD1 LEU E  43      12.349   4.906   2.448  1.00 41.33           C  
ATOM   2211  CD2 LEU E  43      12.180   7.333   1.855  1.00 39.68           C  
ATOM   2212  N   LEU E  44       6.940   6.238   2.074  1.00 41.08           N  
ATOM   2213  CA  LEU E  44       5.684   6.167   1.321  1.00 40.51           C  
ATOM   2214  C   LEU E  44       4.946   7.505   1.401  1.00 42.04           C  
ATOM   2215  O   LEU E  44       4.474   8.026   0.385  1.00 42.78           O  
ATOM   2216  CB  LEU E  44       4.781   5.065   1.874  1.00 38.28           C  
ATOM   2217  CG  LEU E  44       5.019   3.647   1.384  1.00 35.57           C  
ATOM   2218  CD1 LEU E  44       4.297   2.690   2.292  1.00 35.20           C  
ATOM   2219  CD2 LEU E  44       4.543   3.514  -0.045  1.00 36.04           C  
ATOM   2220  N   LYS E  45       4.860   8.075   2.599  1.00 42.66           N  
ATOM   2221  CA  LYS E  45       4.152   9.334   2.743  1.00 44.04           C  
ATOM   2222  C   LYS E  45       4.908  10.536   2.187  1.00 43.75           C  
ATOM   2223  O   LYS E  45       4.332  11.605   2.036  1.00 44.02           O  
ATOM   2224  CB  LYS E  45       3.772   9.565   4.208  1.00 45.30           C  
ATOM   2225  CG  LYS E  45       4.922   9.485   5.166  1.00 47.14           C  
ATOM   2226  CD  LYS E  45       4.425   9.326   6.590  1.00 48.70           C  
ATOM   2227  CE  LYS E  45       3.628  10.525   7.053  1.00 49.82           C  
ATOM   2228  NZ  LYS E  45       3.543  10.530   8.532  1.00 51.51           N  
ATOM   2229  N   SER E  46       6.188  10.374   1.871  1.00 44.07           N  
ATOM   2230  CA  SER E  46       6.959  11.483   1.315  1.00 44.43           C  
ATOM   2231  C   SER E  46       6.764  11.486  -0.193  1.00 44.31           C  
ATOM   2232  O   SER E  46       7.253  12.356  -0.907  1.00 42.47           O  
ATOM   2233  CB  SER E  46       8.452  11.341   1.628  1.00 43.39           C  
ATOM   2234  OG  SER E  46       9.061  10.391   0.776  1.00 44.12           O  
ATOM   2235  N   THR E  47       6.078  10.473  -0.684  1.00 46.73           N  
ATOM   2236  CA  THR E  47       5.818  10.387  -2.099  1.00 48.47           C  
ATOM   2237  C   THR E  47       4.703  11.385  -2.334  1.00 49.57           C  
ATOM   2238  O   THR E  47       3.758  11.452  -1.545  1.00 49.25           O  
ATOM   2239  CB  THR E  47       5.338   8.993  -2.467  1.00 47.24           C  
ATOM   2240  OG1 THR E  47       6.427   8.073  -2.346  1.00 47.27           O  
ATOM   2241  CG2 THR E  47       4.812   8.972  -3.866  1.00 48.78           C  
ATOM   2242  N   THR E  48       4.820  12.165  -3.405  1.00 51.15           N  
ATOM   2243  CA  THR E  48       3.815  13.181  -3.750  1.00 53.16           C  
ATOM   2244  C   THR E  48       2.882  12.676  -4.842  1.00 53.44           C  
ATOM   2245  O   THR E  48       3.080  11.597  -5.376  1.00 54.25           O  
ATOM   2246  CB  THR E  48       4.476  14.462  -4.267  1.00 53.04           C  
ATOM   2247  OG1 THR E  48       3.461  15.420  -4.582  1.00 55.20           O  
ATOM   2248  CG2 THR E  48       5.295  14.167  -5.516  1.00 52.96           C  
ATOM   2249  N   ALA E  49       1.874  13.465  -5.188  1.00 54.02           N  
ATOM   2250  CA  ALA E  49       0.948  13.055  -6.230  1.00 54.47           C  
ATOM   2251  C   ALA E  49       1.628  13.034  -7.598  1.00 55.08           C  
ATOM   2252  O   ALA E  49       1.251  12.246  -8.473  1.00 57.30           O  
ATOM   2253  CB  ALA E  49      -0.255  13.977  -6.263  1.00 53.86           C  
ATOM   2254  N   ALA E  50       2.639  13.879  -7.786  1.00 53.72           N  
ATOM   2255  CA  ALA E  50       3.361  13.938  -9.064  1.00 51.77           C  
ATOM   2256  C   ALA E  50       4.293  12.750  -9.306  1.00 50.27           C  
ATOM   2257  O   ALA E  50       4.771  12.544 -10.418  1.00 48.91           O  
ATOM   2258  CB  ALA E  50       4.153  15.236  -9.151  1.00 50.65           C  
ATOM   2259  N   THR E  51       4.559  11.974  -8.264  1.00 49.58           N  
ATOM   2260  CA  THR E  51       5.433  10.815  -8.406  1.00 49.78           C  
ATOM   2261  C   THR E  51       4.899   9.873  -9.497  1.00 48.76           C  
ATOM   2262  O   THR E  51       3.749   9.433  -9.446  1.00 49.47           O  
ATOM   2263  CB  THR E  51       5.548  10.066  -7.069  1.00 49.46           C  
ATOM   2264  OG1 THR E  51       6.022  10.976  -6.067  1.00 50.12           O  
ATOM   2265  CG2 THR E  51       6.509   8.892  -7.191  1.00 48.57           C  
ATOM   2266  N   PRO E  52       5.743   9.546 -10.490  1.00 47.00           N  
ATOM   2267  CA  PRO E  52       5.378   8.664 -11.610  1.00 45.64           C  
ATOM   2268  C   PRO E  52       5.081   7.209 -11.247  1.00 44.83           C  
ATOM   2269  O   PRO E  52       5.472   6.743 -10.184  1.00 45.61           O  
ATOM   2270  CB  PRO E  52       6.572   8.806 -12.552  1.00 45.69           C  
ATOM   2271  CG  PRO E  52       7.722   9.027 -11.612  1.00 43.44           C  
ATOM   2272  CD  PRO E  52       7.158   9.956 -10.566  1.00 44.88           C  
ATOM   2273  N   VAL E  53       4.385   6.496 -12.126  1.00 42.97           N  
ATOM   2274  CA  VAL E  53       4.066   5.095 -11.870  1.00 42.93           C  
ATOM   2275  C   VAL E  53       4.284   4.277 -13.152  1.00 44.63           C  
ATOM   2276  O   VAL E  53       3.496   4.393 -14.085  1.00 46.30           O  
ATOM   2277  CB  VAL E  53       2.578   4.947 -11.367  1.00 41.94           C  
ATOM   2278  CG1 VAL E  53       2.204   3.472 -11.231  1.00 40.42           C  
ATOM   2279  CG2 VAL E  53       2.395   5.647 -10.012  1.00 38.93           C  
ATOM   2280  N   LYS E  54       5.357   3.483 -13.222  1.00 46.23           N  
ATOM   2281  CA  LYS E  54       5.638   2.658 -14.421  1.00 48.40           C  
ATOM   2282  C   LYS E  54       5.031   1.264 -14.226  1.00 49.85           C  
ATOM   2283  O   LYS E  54       4.956   0.784 -13.101  1.00 50.68           O  
ATOM   2284  CB  LYS E  54       7.149   2.470 -14.636  1.00 47.34           C  
ATOM   2285  CG  LYS E  54       8.023   3.703 -14.457  1.00 48.26           C  
ATOM   2286  CD  LYS E  54       7.993   4.627 -15.652  1.00 49.35           C  
ATOM   2287  CE  LYS E  54       8.913   5.809 -15.416  1.00 51.12           C  
ATOM   2288  NZ  LYS E  54       8.863   6.795 -16.534  1.00 53.85           N  
ATOM   2289  N   GLU E  55       4.627   0.600 -15.300  1.00 51.60           N  
ATOM   2290  CA  GLU E  55       4.050  -0.738 -15.166  1.00 54.39           C  
ATOM   2291  C   GLU E  55       4.663  -1.719 -16.174  1.00 54.75           C  
ATOM   2292  O   GLU E  55       4.620  -1.465 -17.374  1.00 55.29           O  
ATOM   2293  CB  GLU E  55       2.543  -0.659 -15.373  1.00 56.48           C  
ATOM   2294  CG  GLU E  55       2.174  -0.114 -16.732  1.00 62.13           C  
ATOM   2295  CD  GLU E  55       0.681  -0.038 -16.952  1.00 65.07           C  
ATOM   2296  OE1 GLU E  55      -0.002  -1.076 -16.776  1.00 67.93           O  
ATOM   2297  OE2 GLU E  55       0.196   1.061 -17.306  1.00 66.55           O  
ATOM   2298  N   VAL E  56       5.222  -2.837 -15.713  1.00 55.10           N  
ATOM   2299  CA  VAL E  56       5.833  -3.779 -16.655  1.00 57.03           C  
ATOM   2300  C   VAL E  56       4.830  -4.815 -17.151  1.00 58.82           C  
ATOM   2301  O   VAL E  56       3.877  -5.143 -16.459  1.00 59.58           O  
ATOM   2302  CB  VAL E  56       7.095  -4.488 -16.044  1.00 56.26           C  
ATOM   2303  CG1 VAL E  56       7.930  -3.486 -15.271  1.00 54.94           C  
ATOM   2304  CG2 VAL E  56       6.708  -5.638 -15.163  1.00 56.64           C  
ATOM   2305  N   LEU E  57       5.022  -5.310 -18.363  1.00 61.69           N  
ATOM   2306  CA  LEU E  57       4.097  -6.292 -18.900  1.00 65.57           C  
ATOM   2307  C   LEU E  57       4.698  -6.962 -20.126  1.00 68.93           C  
ATOM   2308  O   LEU E  57       5.646  -6.441 -20.709  1.00 70.31           O  
ATOM   2309  CB  LEU E  57       2.758  -5.623 -19.251  1.00 64.35           C  
ATOM   2310  CG  LEU E  57       2.754  -4.213 -19.850  1.00 63.40           C  
ATOM   2311  CD1 LEU E  57       1.943  -4.190 -21.144  1.00 61.49           C  
ATOM   2312  CD2 LEU E  57       2.164  -3.234 -18.835  1.00 61.69           C  
ATOM   2313  N   GLU E  58       4.158  -8.123 -20.504  1.00 72.28           N  
ATOM   2314  CA  GLU E  58       4.650  -8.855 -21.671  1.00 75.29           C  
ATOM   2315  C   GLU E  58       4.223  -8.127 -22.945  1.00 77.73           C  
ATOM   2316  O   GLU E  58       3.202  -7.434 -22.963  1.00 76.97           O  
ATOM   2317  CB  GLU E  58       4.093 -10.293 -21.702  1.00 75.31           C  
ATOM   2318  CG  GLU E  58       4.332 -11.146 -20.440  1.00 76.79           C  
ATOM   2319  CD  GLU E  58       3.753 -12.581 -20.534  1.00 77.44           C  
ATOM   2320  OE1 GLU E  58       4.210 -13.367 -21.392  1.00 76.01           O  
ATOM   2321  OE2 GLU E  58       2.840 -12.920 -19.742  1.00 78.43           O  
ATOM   2322  N   HIS E  59       5.020  -8.293 -23.998  1.00 81.49           N  
ATOM   2323  CA  HIS E  59       4.763  -7.683 -25.304  1.00 85.18           C  
ATOM   2324  C   HIS E  59       3.417  -8.120 -25.894  1.00 85.94           C  
ATOM   2325  O   HIS E  59       2.423  -7.396 -25.795  1.00 86.67           O  
ATOM   2326  CB  HIS E  59       5.869  -8.076 -26.281  1.00 88.58           C  
ATOM   2327  CG  HIS E  59       5.613  -7.642 -27.690  1.00 91.93           C  
ATOM   2328  ND1 HIS E  59       6.272  -8.196 -28.769  1.00 93.36           N  
ATOM   2329  CD2 HIS E  59       4.783  -6.702 -28.199  1.00 92.21           C  
ATOM   2330  CE1 HIS E  59       5.857  -7.616 -29.879  1.00 94.02           C  
ATOM   2331  NE2 HIS E  59       4.954  -6.706 -29.562  1.00 93.58           N  
ATOM   2332  N   HIS E  60       3.409  -9.290 -26.538  1.00 85.57           N  
ATOM   2333  CA  HIS E  60       2.198  -9.847 -27.142  1.00 85.70           C  
ATOM   2334  C   HIS E  60       1.918 -11.244 -26.585  1.00 86.28           C  
ATOM   2335  O   HIS E  60       0.912 -11.470 -25.902  1.00 85.54           O  
ATOM   2336  CB  HIS E  60       2.340  -9.922 -28.670  1.00 84.86           C  
ATOM   2337  CG  HIS E  60       1.130 -10.480 -29.365  1.00 84.46           C  
ATOM   2338  ND1 HIS E  60       1.046 -10.599 -30.736  1.00 84.45           N  
ATOM   2339  CD2 HIS E  60      -0.040 -10.959 -28.877  1.00 83.82           C  
ATOM   2340  CE1 HIS E  60      -0.121 -11.127 -31.062  1.00 84.25           C  
ATOM   2341  NE2 HIS E  60      -0.799 -11.355 -29.952  1.00 83.87           N  
ATOM   2342  N   HIS E  61       2.820 -12.172 -26.889  1.00 87.24           N  
ATOM   2343  CA  HIS E  61       2.714 -13.555 -26.443  1.00 88.00           C  
ATOM   2344  C   HIS E  61       3.061 -13.650 -24.958  1.00 87.81           C  
ATOM   2345  O   HIS E  61       3.665 -14.670 -24.564  1.00 88.12           O  
ATOM   2346  CB  HIS E  61       3.680 -14.417 -27.254  1.00 88.96           C  
ATOM   2347  CG  HIS E  61       3.566 -14.214 -28.733  1.00 90.79           C  
ATOM   2348  ND1 HIS E  61       4.545 -14.611 -29.620  1.00 91.70           N  
ATOM   2349  CD2 HIS E  61       2.581 -13.665 -29.484  1.00 90.97           C  
ATOM   2350  CE1 HIS E  61       4.169 -14.316 -30.851  1.00 91.13           C  
ATOM   2351  NE2 HIS E  61       2.981 -13.741 -30.797  1.00 91.08           N  
TER    2352      HIS E  61                                                      
END
MOLECULE T0472_52_101.pdb
ATOM    761  N   ILE    52      -2.934  12.060   6.624  1.00 63.31           N  
ATOM    762  CA  ILE    52      -3.784  11.757   7.784  1.00 50.41           C  
ATOM    763  C   ILE    52      -3.355  10.443   8.462  1.00 25.20           C  
ATOM    764  O   ILE    52      -3.842   9.360   8.129  1.00 63.43           O  
ATOM    765  CB  ILE    52      -5.278  11.668   7.377  1.00 40.10           C  
ATOM    766  CG1 ILE    52      -5.698  12.940   6.620  1.00  0.32           C  
ATOM    767  CG2 ILE    52      -6.164  11.454   8.609  1.00 13.31           C  
ATOM    768  CD1 ILE    52      -7.110  12.896   6.077  1.00 14.20           C  
ATOM    769  H   ILE    52      -3.093  11.580   5.783  1.00 37.41           H  
ATOM    770  HA  ILE    52      -3.676  12.566   8.495  1.00 14.31           H  
ATOM    771  HB  ILE    52      -5.400  10.815   6.724  1.00 21.03           H  
ATOM    772 HG12 ILE    52      -5.629  13.789   7.286  1.00 37.41           H  
ATOM    773 HG13 ILE    52      -5.028  13.093   5.785  1.00 37.41           H  
ATOM    774 HG21 ILE    52      -7.198  11.378   8.302  1.00 37.41           H  
ATOM    775 HG22 ILE    52      -6.052  12.289   9.286  1.00 37.41           H  
ATOM    776 HG23 ILE    52      -5.871  10.544   9.112  1.00 37.41           H  
ATOM    777 HD11 ILE    52      -7.214  12.053   5.411  1.00 37.41           H  
ATOM    778 HD12 ILE    52      -7.315  13.809   5.536  1.00 37.41           H  
ATOM    779 HD13 ILE    52      -7.809  12.800   6.895  1.00 37.41           H  
ATOM    780  N   GLU    53      -2.443  10.555   9.420  1.00 72.33           N  
ATOM    781  CA  GLU    53      -1.867   9.387  10.096  1.00 21.33           C  
ATOM    782  C   GLU    53      -2.934   8.548  10.821  1.00 13.30           C  
ATOM    783  O   GLU    53      -2.792   7.338  10.955  1.00 61.14           O  
ATOM    784  CB  GLU    53      -0.784   9.844  11.084  1.00 51.10           C  
ATOM    785  CG  GLU    53       0.329  10.658  10.428  1.00 41.41           C  
ATOM    786  CD  GLU    53       1.350  11.177  11.426  1.00 31.52           C  
ATOM    787  OE1 GLU    53       1.045  12.161  12.134  1.00  0.22           O  
ATOM    788  OE2 GLU    53       2.465  10.618  11.496  1.00  0.21           O  
ATOM    789  H   GLU    53      -2.141  11.450   9.680  1.00 37.41           H  
ATOM    790  HA  GLU    53      -1.404   8.769   9.339  1.00 44.53           H  
ATOM    791  HB2 GLU    53      -1.244  10.453  11.851  1.00 37.41           H  
ATOM    792  HB3 GLU    53      -0.341   8.974  11.544  1.00 37.41           H  
ATOM    793  HG2 GLU    53       0.836  10.035   9.706  1.00 37.41           H  
ATOM    794  HG3 GLU    53      -0.114  11.504   9.916  1.00 37.41           H  
ATOM    795  N   ALA    54      -4.022   9.183  11.247  1.00 24.34           N  
ATOM    796  CA  ALA    54      -5.102   8.486  11.969  1.00 14.52           C  
ATOM    797  C   ALA    54      -5.685   7.291  11.178  1.00 12.03           C  
ATOM    798  O   ALA    54      -6.469   6.504  11.715  1.00  2.10           O  
ATOM    799  CB  ALA    54      -6.208   9.475  12.319  1.00 10.14           C  
ATOM    800  H   ALA    54      -4.106  10.145  11.077  1.00 37.41           H  
ATOM    801  HA  ALA    54      -4.687   8.113  12.895  1.00 21.34           H  
ATOM    802  HB1 ALA    54      -6.973   8.974  12.895  1.00 37.41           H  
ATOM    803  HB2 ALA    54      -6.642   9.870  11.411  1.00 37.41           H  
ATOM    804  HB3 ALA    54      -5.795  10.285  12.902  1.00 37.41           H  
ATOM    805  N   ARG    55      -5.296   7.162   9.909  1.00 23.25           N  
ATOM    806  CA  ARG    55      -5.814   6.110   9.026  1.00  2.54           C  
ATOM    807  C   ARG    55      -4.950   4.826   9.031  1.00 53.14           C  
ATOM    808  O   ARG    55      -5.335   3.821   8.422  1.00  4.12           O  
ATOM    809  CB  ARG    55      -5.915   6.660   7.594  1.00  4.02           C  
ATOM    810  CG  ARG    55      -6.858   7.855   7.453  1.00 31.02           C  
ATOM    811  CD  ARG    55      -8.317   7.454   7.646  1.00 42.40           C  
ATOM    812  NE  ARG    55      -9.220   8.609   7.648  1.00 62.02           N  
ATOM    813  CZ  ARG    55      -9.855   9.054   6.595  1.00 64.32           C  
ATOM    814  NH1 ARG    55      -9.613   8.568   5.418  1.00 51.52           N  
ATOM    815  NH2 ARG    55     -10.707  10.018   6.710  1.00  4.11           N  
ATOM    816  H   ARG    55      -4.647   7.803   9.547  1.00 37.41           H  
ATOM    817  HA  ARG    55      -6.806   5.852   9.367  1.00 22.42           H  
ATOM    818  HB2 ARG    55      -4.931   6.969   7.270  1.00 37.41           H  
ATOM    819  HB3 ARG    55      -6.266   5.872   6.942  1.00 37.41           H  
ATOM    820  HG2 ARG    55      -6.597   8.596   8.194  1.00 37.41           H  
ATOM    821  HG3 ARG    55      -6.738   8.278   6.465  1.00 37.41           H  
ATOM    822  HD2 ARG    55      -8.603   6.785   6.846  1.00 37.41           H  
ATOM    823  HD3 ARG    55      -8.412   6.937   8.591  1.00 37.41           H  
ATOM    824  HE  ARG    55      -9.383   9.052   8.504  1.00 72.15           H  
ATOM    825 HH11 ARG    55      -8.932   7.849   5.304  1.00 37.41           H  
ATOM    826 HH12 ARG    55     -10.090   8.937   4.622  1.00 37.41           H  
ATOM    827 HH21 ARG    55     -10.872  10.437   7.602  1.00 37.41           H  
ATOM    828 HH22 ARG    55     -11.209  10.336   5.909  1.00 37.41           H  
ATOM    829  N   TYR    56      -3.797   4.843   9.711  1.00 35.41           N  
ATOM    830  CA  TYR    56      -2.880   3.687   9.684  1.00 62.05           C  
ATOM    831  C   TYR    56      -3.367   2.524  10.568  1.00 22.13           C  
ATOM    832  O   TYR    56      -4.337   2.646  11.320  1.00  5.52           O  
ATOM    833  CB  TYR    56      -1.437   4.088  10.092  1.00 63.32           C  
ATOM    834  CG  TYR    56      -1.219   4.439  11.573  1.00 62.22           C  
ATOM    835  CD1 TYR    56      -1.370   3.484  12.580  1.00 51.22           C  
ATOM    836  CD2 TYR    56      -0.851   5.723  11.957  1.00 14.01           C  
ATOM    837  CE1 TYR    56      -1.166   3.802  13.910  1.00 53.41           C  
ATOM    838  CE2 TYR    56      -0.643   6.048  13.285  1.00 42.30           C  
ATOM    839  CZ  TYR    56      -0.806   5.085  14.258  1.00  0.02           C  
ATOM    840  OH  TYR    56      -0.602   5.404  15.582  1.00  0.11           O  
ATOM    841  H   TYR    56      -3.558   5.637  10.234  1.00 37.41           H  
ATOM    842  HA  TYR    56      -2.854   3.333   8.662  1.00  0.43           H  
ATOM    843  HB2 TYR    56      -0.772   3.270   9.857  1.00 37.41           H  
ATOM    844  HB3 TYR    56      -1.144   4.949   9.504  1.00 37.41           H  
ATOM    845  HD1 TYR    56      -1.650   2.476  12.309  1.00 50.32           H  
ATOM    846  HD2 TYR    56      -0.728   6.479  11.196  1.00 34.13           H  
ATOM    847  HE1 TYR    56      -1.292   3.045  14.671  1.00 51.01           H  
ATOM    848  HE2 TYR    56      -0.357   7.055  13.556  1.00 22.30           H  
ATOM    849  HH  TYR    56      -1.043   6.241  15.780  1.00 14.22           H  
ATOM    850  N   ALA    57      -2.675   1.391  10.455  1.00 63.32           N  
ATOM    851  CA  ALA    57      -2.859   0.254  11.362  1.00 25.11           C  
ATOM    852  C   ALA    57      -1.529  -0.491  11.565  1.00 35.11           C  
ATOM    853  O   ALA    57      -1.122  -1.294  10.727  1.00 54.01           O  
ATOM    854  CB  ALA    57      -3.927  -0.689  10.819  1.00 23.24           C  
ATOM    855  H   ALA    57      -2.032   1.307   9.719  1.00 37.41           H  
ATOM    856  HA  ALA    57      -3.197   0.636  12.317  1.00 52.10           H  
ATOM    857  HB1 ALA    57      -3.598  -1.103   9.877  1.00 37.41           H  
ATOM    858  HB2 ALA    57      -4.848  -0.143  10.669  1.00 37.41           H  
ATOM    859  HB3 ALA    57      -4.096  -1.490  11.523  1.00 37.41           H  
ATOM    860  N   LYS    58      -0.855  -0.228  12.680  1.00 61.02           N  
ATOM    861  CA  LYS    58       0.480  -0.794  12.932  1.00 63.12           C  
ATOM    862  C   LYS    58       0.402  -2.075  13.776  1.00 14.20           C  
ATOM    863  O   LYS    58      -0.132  -2.075  14.888  1.00 64.40           O  
ATOM    864  CB  LYS    58       1.371   0.253  13.618  1.00 42.34           C  
ATOM    865  CG  LYS    58       1.675   1.467  12.739  1.00 42.51           C  
ATOM    866  CD  LYS    58       2.283   2.619  13.539  1.00 64.53           C  
ATOM    867  CE  LYS    58       3.613   2.243  14.180  1.00 34.10           C  
ATOM    868  NZ  LYS    58       4.138   3.339  15.033  1.00 51.24           N  
ATOM    869  H   LYS    58      -1.264   0.352  13.358  1.00 37.41           H  
ATOM    870  HA  LYS    58       0.917  -1.043  11.973  1.00  1.11           H  
ATOM    871  HB2 LYS    58       0.875   0.597  14.516  1.00 37.41           H  
ATOM    872  HB3 LYS    58       2.309  -0.210  13.892  1.00 37.41           H  
ATOM    873  HG2 LYS    58       2.374   1.173  11.967  1.00 37.41           H  
ATOM    874  HG3 LYS    58       0.756   1.805  12.279  1.00 37.41           H  
ATOM    875  HD2 LYS    58       2.443   3.457  12.875  1.00 37.41           H  
ATOM    876  HD3 LYS    58       1.589   2.909  14.316  1.00 37.41           H  
ATOM    877  HE2 LYS    58       3.471   1.363  14.790  1.00 37.41           H  
ATOM    878  HE3 LYS    58       4.331   2.030  13.400  1.00 37.41           H  
ATOM    879  HZ1 LYS    58       3.486   3.520  15.827  1.00 37.41           H  
ATOM    880  HZ2 LYS    58       4.241   4.211  14.480  1.00 37.41           H  
ATOM    881  HZ3 LYS    58       5.069   3.079  15.421  1.00 37.41           H  
ATOM    882  N   GLU    59       0.949  -3.169  13.247  1.00 44.24           N  
ATOM    883  CA  GLU    59       0.882  -4.471  13.919  1.00 11.42           C  
ATOM    884  C   GLU    59       2.249  -5.175  13.923  1.00 44.23           C  
ATOM    885  O   GLU    59       3.090  -4.945  13.051  1.00 51.02           O  
ATOM    886  CB  GLU    59      -0.167  -5.358  13.225  1.00 62.32           C  
ATOM    887  CG  GLU    59      -0.394  -6.708  13.903  1.00 71.31           C  
ATOM    888  CD  GLU    59      -0.917  -6.575  15.325  1.00 71.05           C  
ATOM    889  OE1 GLU    59      -2.147  -6.439  15.499  1.00 51.51           O  
ATOM    890  OE2 GLU    59      -0.103  -6.593  16.271  1.00 64.11           O  
ATOM    891  H   GLU    59       1.413  -3.103  12.385  1.00 37.41           H  
ATOM    892  HA  GLU    59       0.577  -4.303  14.942  1.00 22.01           H  
ATOM    893  HB2 GLU    59      -1.109  -4.828  13.205  1.00 37.41           H  
ATOM    894  HB3 GLU    59       0.150  -5.540  12.207  1.00 37.41           H  
ATOM    895  HG2 GLU    59      -1.109  -7.273  13.323  1.00 37.41           H  
ATOM    896  HG3 GLU    59       0.546  -7.245  13.929  1.00 37.41           H  
ATOM    897  N   VAL    60       2.470  -6.027  14.921  1.00 22.32           N  
ATOM    898  CA  VAL    60       3.696  -6.824  15.010  1.00 64.53           C  
ATOM    899  C   VAL    60       3.366  -8.299  15.279  1.00 53.14           C  
ATOM    900  O   VAL    60       2.798  -8.636  16.319  1.00 43.34           O  
ATOM    901  CB  VAL    60       4.643  -6.309  16.126  1.00  2.12           C  
ATOM    902  CG1 VAL    60       5.908  -7.164  16.200  1.00 11.45           C  
ATOM    903  CG2 VAL    60       4.996  -4.836  15.909  1.00 31.41           C  
ATOM    904  H   VAL    60       1.784  -6.130  15.617  1.00 37.41           H  
ATOM    905  HA  VAL    60       4.215  -6.749  14.063  1.00  5.34           H  
ATOM    906  HB  VAL    60       4.126  -6.394  17.073  1.00 53.30           H  
ATOM    907 HG11 VAL    60       5.637  -8.192  16.393  1.00 37.41           H  
ATOM    908 HG12 VAL    60       6.540  -6.805  17.000  1.00 37.41           H  
ATOM    909 HG13 VAL    60       6.444  -7.102  15.264  1.00 37.41           H  
ATOM    910 HG21 VAL    60       5.634  -4.496  16.714  1.00 37.41           H  
ATOM    911 HG22 VAL    60       4.091  -4.247  15.895  1.00 37.41           H  
ATOM    912 HG23 VAL    60       5.515  -4.722  14.968  1.00 37.41           H  
ATOM    913  N   ALA    61       3.723  -9.170  14.340  1.00 74.01           N  
ATOM    914  CA  ALA    61       3.468 -10.608  14.478  1.00 71.43           C  
ATOM    915  C   ALA    61       4.192 -11.201  15.705  1.00 65.35           C  
ATOM    916  O   ALA    61       5.224 -10.684  16.135  1.00 53.45           O  
ATOM    917  CB  ALA    61       3.892 -11.333  13.206  1.00 74.24           C  
ATOM    918  H   ALA    61       4.166  -8.839  13.528  1.00 37.41           H  
ATOM    919  HA  ALA    61       2.402 -10.745  14.602  1.00 31.41           H  
ATOM    920  HB1 ALA    61       3.608 -12.373  13.269  1.00 37.41           H  
ATOM    921  HB2 ALA    61       4.964 -11.260  13.091  1.00 37.41           H  
ATOM    922  HB3 ALA    61       3.409 -10.879  12.353  1.00 37.41           H  
ATOM    923  N   LYS    62       3.656 -12.300  16.248  1.00  4.44           N  
ATOM    924  CA  LYS    62       4.209 -12.923  17.465  1.00 11.40           C  
ATOM    925  C   LYS    62       5.685 -13.343  17.306  1.00 52.00           C  
ATOM    926  O   LYS    62       6.385 -13.549  18.295  1.00 60.32           O  
ATOM    927  CB  LYS    62       3.332 -14.116  17.908  1.00 35.24           C  
ATOM    928  CG  LYS    62       2.962 -15.109  16.797  1.00 32.32           C  
ATOM    929  CD  LYS    62       4.130 -15.996  16.364  1.00 21.23           C  
ATOM    930  CE  LYS    62       4.682 -16.823  17.517  1.00 32.35           C  
ATOM    931  NZ  LYS    62       5.716 -17.788  17.058  1.00 41.43           N  
ATOM    932  H   LYS    62       2.867 -12.701  15.824  1.00 37.41           H  
ATOM    933  HA  LYS    62       4.165 -12.173  18.244  1.00 22.23           H  
ATOM    934  HB2 LYS    62       3.853 -14.661  18.682  1.00 37.41           H  
ATOM    935  HB3 LYS    62       2.413 -13.726  18.325  1.00 37.41           H  
ATOM    936  HG2 LYS    62       2.164 -15.745  17.155  1.00 37.41           H  
ATOM    937  HG3 LYS    62       2.610 -14.551  15.939  1.00 37.41           H  
ATOM    938  HD2 LYS    62       3.790 -16.667  15.588  1.00 37.41           H  
ATOM    939  HD3 LYS    62       4.919 -15.370  15.972  1.00 37.41           H  
ATOM    940  HE2 LYS    62       5.123 -16.157  18.243  1.00 37.41           H  
ATOM    941  HE3 LYS    62       3.870 -17.369  17.977  1.00 37.41           H  
ATOM    942  HZ1 LYS    62       6.100 -18.314  17.871  1.00 37.41           H  
ATOM    943  HZ2 LYS    62       6.495 -17.286  16.585  1.00 37.41           H  
ATOM    944  HZ3 LYS    62       5.301 -18.465  16.385  1.00 37.41           H  
ATOM    945  N   ASN    63       6.149 -13.463  16.062  1.00 21.24           N  
ATOM    946  CA  ASN    63       7.566 -13.751  15.782  1.00 12.32           C  
ATOM    947  C   ASN    63       8.383 -12.441  15.702  1.00 33.24           C  
ATOM    948  O   ASN    63       9.455 -12.395  15.101  1.00  2.24           O  
ATOM    949  CB  ASN    63       7.668 -14.554  14.471  1.00 62.24           C  
ATOM    950  CG  ASN    63       9.074 -15.056  14.164  1.00 20.31           C  
ATOM    951  OD1 ASN    63       9.485 -16.114  14.623  1.00 45.23           O  
ATOM    952  ND2 ASN    63       9.818 -14.312  13.374  1.00 10.10           N  
ATOM    953  H   ASN    63       5.524 -13.370  15.311  1.00 37.41           H  
ATOM    954  HA  ASN    63       7.952 -14.351  16.596  1.00 40.40           H  
ATOM    955  HB2 ASN    63       7.016 -15.413  14.538  1.00 37.41           H  
ATOM    956  HB3 ASN    63       7.342 -13.932  13.647  1.00 37.41           H  
ATOM    957 HD21 ASN    63       9.442 -13.479  13.028  1.00 37.41           H  
ATOM    958 HD22 ASN    63      10.721 -14.626  13.165  1.00 37.41           H  
ATOM    959  N   ASP    64       7.867 -11.379  16.331  1.00 12.21           N  
ATOM    960  CA  ASP    64       8.514 -10.058  16.313  1.00 33.52           C  
ATOM    961  C   ASP    64       8.675  -9.521  14.882  1.00 53.51           C  
ATOM    962  O   ASP    64       9.686  -8.898  14.546  1.00 41.44           O  
ATOM    963  CB  ASP    64       9.872 -10.114  17.026  1.00 11.12           C  
ATOM    964  CG  ASP    64       9.731 -10.181  18.532  1.00 25.43           C  
ATOM    965  OD1 ASP    64       9.576  -9.113  19.163  1.00 53.53           O  
ATOM    966  OD2 ASP    64       9.775 -11.295  19.093  1.00 55.32           O  
ATOM    967  H   ASP    64       7.030 -11.487  16.826  1.00 37.41           H  
ATOM    968  HA  ASP    64       7.868  -9.381  16.853  1.00 71.24           H  
ATOM    969  HB2 ASP    64      10.411 -10.990  16.690  1.00 37.41           H  
ATOM    970  HB3 ASP    64      10.444  -9.232  16.774  1.00 37.41           H  
ATOM    971  N   LYS    65       7.662  -9.755  14.048  1.00 61.14           N  
ATOM    972  CA  LYS    65       7.666  -9.274  12.660  1.00 32.24           C  
ATOM    973  C   LYS    65       6.824  -7.992  12.531  1.00 33.22           C  
ATOM    974  O   LYS    65       5.593  -8.050  12.518  1.00 61.02           O  
ATOM    975  CB  LYS    65       7.113 -10.358  11.721  1.00 71.43           C  
ATOM    976  CG  LYS    65       7.740 -11.735  11.933  1.00 12.12           C  
ATOM    977  CD  LYS    65       7.122 -12.797  11.024  1.00 54.43           C  
ATOM    978  CE  LYS    65       7.477 -12.578   9.556  1.00 71.11           C  
ATOM    979  NZ  LYS    65       8.943 -12.627   9.316  1.00 13.30           N  
ATOM    980  H   LYS    65       6.892 -10.263  14.373  1.00 37.41           H  
ATOM    981  HA  LYS    65       8.687  -9.055  12.380  1.00 74.43           H  
ATOM    982  HB2 LYS    65       6.046 -10.444  11.878  1.00 37.41           H  
ATOM    983  HB3 LYS    65       7.291 -10.057  10.697  1.00 37.41           H  
ATOM    984  HG2 LYS    65       8.799 -11.672  11.725  1.00 37.41           H  
ATOM    985  HG3 LYS    65       7.595 -12.028  12.964  1.00 37.41           H  
ATOM    986  HD2 LYS    65       7.482 -13.769  11.327  1.00 37.41           H  
ATOM    987  HD3 LYS    65       6.046 -12.764  11.131  1.00 37.41           H  
ATOM    988  HE2 LYS    65       7.002 -13.348   8.965  1.00 37.41           H  
ATOM    989  HE3 LYS    65       7.105 -11.611   9.248  1.00 37.41           H  
ATOM    990  HZ1 LYS    65       9.144 -12.552   8.299  1.00 37.41           H  
ATOM    991  HZ2 LYS    65       9.336 -13.522   9.668  1.00 37.41           H  
ATOM    992  HZ3 LYS    65       9.415 -11.842   9.806  1.00 37.41           H  
ATOM    993  N   PRO    66       7.471  -6.815  12.457  1.00 62.54           N  
ATOM    994  CA  PRO    66       6.766  -5.530  12.370  1.00 44.02           C  
ATOM    995  C   PRO    66       6.263  -5.199  10.950  1.00 12.31           C  
ATOM    996  O   PRO    66       7.020  -5.245   9.979  1.00 62.23           O  
ATOM    997  CB  PRO    66       7.837  -4.530  12.819  1.00 32.11           C  
ATOM    998  CG  PRO    66       9.125  -5.139  12.375  1.00 70.24           C  
ATOM    999  CD  PRO    66       8.939  -6.637  12.465  1.00 13.44           C  
ATOM   1000  HA  PRO    66       5.933  -5.494  13.059  1.00  1.01           H  
ATOM   1001  HB2 PRO    66       7.665  -3.571  12.350  1.00 37.41           H  
ATOM   1002  HB3 PRO    66       7.804  -4.420  13.894  1.00 37.41           H  
ATOM   1003  HG2 PRO    66       9.335  -4.847  11.356  1.00 37.41           H  
ATOM   1004  HG3 PRO    66       9.927  -4.820  13.027  1.00 37.41           H  
ATOM   1005  HD2 PRO    66       9.390  -7.125  11.612  1.00 37.41           H  
ATOM   1006  HD3 PRO    66       9.364  -7.017  13.383  1.00 37.41           H  
ATOM   1007  N   TYR    67       4.979  -4.871  10.846  1.00 24.13           N  
ATOM   1008  CA  TYR    67       4.370  -4.439   9.581  1.00 24.21           C  
ATOM   1009  C   TYR    67       3.188  -3.491   9.849  1.00 45.21           C  
ATOM   1010  O   TYR    67       2.904  -3.151  11.001  1.00 72.50           O  
ATOM   1011  CB  TYR    67       3.915  -5.656   8.753  1.00  1.11           C  
ATOM   1012  CG  TYR    67       2.901  -6.550   9.452  1.00  2.41           C  
ATOM   1013  CD1 TYR    67       3.311  -7.547  10.334  1.00 23.44           C  
ATOM   1014  CD2 TYR    67       1.534  -6.403   9.224  1.00 42.32           C  
ATOM   1015  CE1 TYR    67       2.393  -8.362  10.969  1.00 44.40           C  
ATOM   1016  CE2 TYR    67       0.612  -7.216   9.855  1.00 22.30           C  
ATOM   1017  CZ  TYR    67       1.046  -8.194  10.726  1.00  1.14           C  
ATOM   1018  OH  TYR    67       0.131  -9.010  11.357  1.00 65.32           O  
ATOM   1019  H   TYR    67       4.411  -4.928  11.646  1.00 37.41           H  
ATOM   1020  HA  TYR    67       5.122  -3.896   9.023  1.00 62.22           H  
ATOM   1021  HB2 TYR    67       3.469  -5.308   7.832  1.00 37.41           H  
ATOM   1022  HB3 TYR    67       4.780  -6.259   8.514  1.00 37.41           H  
ATOM   1023  HD1 TYR    67       4.366  -7.678  10.524  1.00  3.10           H  
ATOM   1024  HD2 TYR    67       1.196  -5.635   8.542  1.00 71.14           H  
ATOM   1025  HE1 TYR    67       2.735  -9.127  11.651  1.00 11.44           H  
ATOM   1026  HE2 TYR    67      -0.444  -7.086   9.660  1.00 45.34           H  
ATOM   1027  HH  TYR    67      -0.543  -9.284  10.722  1.00 75.15           H  
ATOM   1028  N   PHE    68       2.507  -3.052   8.794  1.00 24.23           N  
ATOM   1029  CA  PHE    68       1.371  -2.137   8.954  1.00  4.50           C  
ATOM   1030  C   PHE    68       0.403  -2.178   7.760  1.00 64.32           C  
ATOM   1031  O   PHE    68       0.799  -2.428   6.620  1.00 12.41           O  
ATOM   1032  CB  PHE    68       1.871  -0.698   9.183  1.00 32.33           C  
ATOM   1033  CG  PHE    68       2.691  -0.137   8.044  1.00 23.42           C  
ATOM   1034  CD1 PHE    68       4.044  -0.426   7.932  1.00 53.23           C  
ATOM   1035  CD2 PHE    68       2.106   0.680   7.083  1.00 31.25           C  
ATOM   1036  CE1 PHE    68       4.793   0.086   6.889  1.00  4.33           C  
ATOM   1037  CE2 PHE    68       2.853   1.193   6.040  1.00  0.44           C  
ATOM   1038  CZ  PHE    68       4.199   0.895   5.945  1.00 13.13           C  
ATOM   1039  H   PHE    68       2.769  -3.344   7.896  1.00 37.41           H  
ATOM   1040  HA  PHE    68       0.827  -2.451   9.835  1.00 14.23           H  
ATOM   1041  HB2 PHE    68       1.019  -0.048   9.332  1.00 37.41           H  
ATOM   1042  HB3 PHE    68       2.484  -0.681  10.074  1.00 37.41           H  
ATOM   1043  HD1 PHE    68       4.514  -1.062   8.670  1.00 10.45           H  
ATOM   1044  HD2 PHE    68       1.053   0.917   7.157  1.00 75.42           H  
ATOM   1045  HE1 PHE    68       5.844  -0.148   6.814  1.00 73.12           H  
ATOM   1046  HE2 PHE    68       2.386   1.826   5.300  1.00 70.04           H  
ATOM   1047  HZ  PHE    68       4.783   1.293   5.130  1.00  3.33           H  
ATOM   1048  N   ASN    69      -0.872  -1.940   8.050  1.00 64.50           N  
ATOM   1049  CA  ASN    69      -1.917  -1.835   7.029  1.00 15.25           C  
ATOM   1050  C   ASN    69      -2.474  -0.402   6.980  1.00 13.04           C  
ATOM   1051  O   ASN    69      -2.335   0.362   7.937  1.00 72.31           O  
ATOM   1052  CB  ASN    69      -3.054  -2.818   7.333  1.00 23.42           C  
ATOM   1053  CG  ASN    69      -2.588  -4.266   7.375  1.00 74.43           C  
ATOM   1054  OD1 ASN    69      -2.149  -4.761   8.408  1.00 54.30           O  
ATOM   1055  ND2 ASN    69      -2.687  -4.962   6.259  1.00 72.34           N  
ATOM   1056  H   ASN    69      -1.125  -1.836   8.987  1.00 37.41           H  
ATOM   1057  HA  ASN    69      -1.481  -2.078   6.069  1.00 74.20           H  
ATOM   1058  HB2 ASN    69      -3.484  -2.574   8.293  1.00 37.41           H  
ATOM   1059  HB3 ASN    69      -3.816  -2.725   6.572  1.00 37.41           H  
ATOM   1060 HD21 ASN    69      -3.050  -4.521   5.464  1.00 37.41           H  
ATOM   1061 HD22 ASN    69      -2.402  -5.900   6.277  1.00 37.41           H  
ATOM   1062  N   LEU    70      -3.099  -0.039   5.866  1.00  3.12           N  
ATOM   1063  CA  LEU    70      -3.696   1.294   5.709  1.00 12.35           C  
ATOM   1064  C   LEU    70      -5.207   1.188   5.443  1.00 52.51           C  
ATOM   1065  O   LEU    70      -5.639   0.449   4.550  1.00  2.32           O  
ATOM   1066  CB  LEU    70      -3.002   2.054   4.562  1.00 61.41           C  
ATOM   1067  CG  LEU    70      -3.459   3.511   4.357  1.00 74.43           C  
ATOM   1068  CD1 LEU    70      -3.134   4.366   5.584  1.00 53.53           C  
ATOM   1069  CD2 LEU    70      -2.820   4.100   3.100  1.00 51.44           C  
ATOM   1070  H   LEU    70      -3.166  -0.683   5.130  1.00 37.41           H  
ATOM   1071  HA  LEU    70      -3.544   1.837   6.631  1.00 30.15           H  
ATOM   1072  HB2 LEU    70      -1.937   2.057   4.757  1.00 37.41           H  
ATOM   1073  HB3 LEU    70      -3.177   1.512   3.643  1.00 37.41           H  
ATOM   1074  HG  LEU    70      -4.530   3.526   4.222  1.00 53.12           H  
ATOM   1075 HD11 LEU    70      -3.620   3.946   6.453  1.00 37.41           H  
ATOM   1076 HD12 LEU    70      -3.491   5.374   5.426  1.00 37.41           H  
ATOM   1077 HD13 LEU    70      -2.066   4.384   5.742  1.00 37.41           H  
ATOM   1078 HD21 LEU    70      -3.146   5.121   2.972  1.00 37.41           H  
ATOM   1079 HD22 LEU    70      -3.117   3.519   2.239  1.00 37.41           H  
ATOM   1080 HD23 LEU    70      -1.744   4.076   3.194  1.00 37.41           H  
ATOM   1081  N   LYS    71      -6.004   1.925   6.220  1.00 35.23           N  
ATOM   1082  CA  LYS    71      -7.465   1.907   6.076  1.00 73.11           C  
ATOM   1083  C   LYS    71      -8.014   3.253   5.581  1.00 73.01           C  
ATOM   1084  O   LYS    71      -7.513   4.317   5.942  1.00  2.23           O  
ATOM   1085  CB  LYS    71      -8.145   1.557   7.410  1.00 52.54           C  
ATOM   1086  CG  LYS    71      -7.870   0.143   7.914  1.00  3.44           C  
ATOM   1087  CD  LYS    71      -8.818  -0.226   9.058  1.00 43.11           C  
ATOM   1088  CE  LYS    71      -8.538  -1.614   9.626  1.00  2.32           C  
ATOM   1089  NZ  LYS    71      -7.195  -1.709  10.252  1.00 63.42           N  
ATOM   1090  H   LYS    71      -5.604   2.503   6.907  1.00 37.41           H  
ATOM   1091  HA  LYS    71      -7.718   1.146   5.350  1.00 23.22           H  
ATOM   1092  HB2 LYS    71      -7.803   2.251   8.165  1.00 37.41           H  
ATOM   1093  HB3 LYS    71      -9.216   1.669   7.293  1.00 37.41           H  
ATOM   1094  HG2 LYS    71      -8.009  -0.555   7.100  1.00 37.41           H  
ATOM   1095  HG3 LYS    71      -6.848   0.086   8.269  1.00 37.41           H  
ATOM   1096  HD2 LYS    71      -8.714   0.502   9.850  1.00 37.41           H  
ATOM   1097  HD3 LYS    71      -9.832  -0.201   8.685  1.00 37.41           H  
ATOM   1098  HE2 LYS    71      -9.287  -1.839  10.372  1.00 37.41           H  
ATOM   1099  HE3 LYS    71      -8.605  -2.337   8.826  1.00 37.41           H  
ATOM   1100  HZ1 LYS    71      -7.050  -0.916  10.911  1.00 37.41           H  
ATOM   1101  HZ2 LYS    71      -6.452  -1.683   9.527  1.00 37.41           H  
ATOM   1102  HZ3 LYS    71      -7.112  -2.600  10.783  1.00 37.41           H  
ATOM   1103  N   ALA    72      -9.056   3.195   4.754  1.00 64.14           N  
ATOM   1104  CA  ALA    72      -9.782   4.398   4.334  1.00 62.42           C  
ATOM   1105  C   ALA    72     -10.779   4.839   5.421  1.00 74.43           C  
ATOM   1106  O   ALA    72     -10.918   4.172   6.448  1.00 34.50           O  
ATOM   1107  CB  ALA    72     -10.504   4.149   3.016  1.00 73.22           C  
ATOM   1108  H   ALA    72      -9.341   2.319   4.415  1.00 37.41           H  
ATOM   1109  HA  ALA    72      -9.062   5.190   4.180  1.00 74.24           H  
ATOM   1110  HB1 ALA    72      -9.793   3.834   2.267  1.00 37.41           H  
ATOM   1111  HB2 ALA    72     -10.990   5.059   2.691  1.00 37.41           H  
ATOM   1112  HB3 ALA    72     -11.247   3.377   3.152  1.00 37.41           H  
ATOM   1113  N   ALA    73     -11.471   5.956   5.194  1.00 12.14           N  
ATOM   1114  CA  ALA    73     -12.418   6.506   6.181  1.00 23.01           C  
ATOM   1115  C   ALA    73     -13.482   5.481   6.617  1.00 13.03           C  
ATOM   1116  O   ALA    73     -13.840   5.409   7.791  1.00 75.11           O  
ATOM   1117  CB  ALA    73     -13.091   7.756   5.622  1.00 23.52           C  
ATOM   1118  H   ALA    73     -11.348   6.428   4.343  1.00 37.41           H  
ATOM   1119  HA  ALA    73     -11.846   6.801   7.050  1.00 75.03           H  
ATOM   1120  HB1 ALA    73     -13.668   7.495   4.745  1.00 37.41           H  
ATOM   1121  HB2 ALA    73     -12.336   8.482   5.351  1.00 37.41           H  
ATOM   1122  HB3 ALA    73     -13.746   8.182   6.369  1.00 37.41           H  
ATOM   1123  N   ASN    74     -13.975   4.682   5.668  1.00 14.50           N  
ATOM   1124  CA  ASN    74     -14.995   3.662   5.962  1.00 44.41           C  
ATOM   1125  C   ASN    74     -14.373   2.400   6.607  1.00 22.25           C  
ATOM   1126  O   ASN    74     -15.018   1.355   6.708  1.00 15.02           O  
ATOM   1127  CB  ASN    74     -15.760   3.307   4.675  1.00 73.15           C  
ATOM   1128  CG  ASN    74     -17.051   2.547   4.943  1.00 61.34           C  
ATOM   1129  OD1 ASN    74     -18.083   3.137   5.242  1.00  2.04           O  
ATOM   1130  ND2 ASN    74     -17.016   1.235   4.823  1.00 24.03           N  
ATOM   1131  H   ASN    74     -13.661   4.793   4.747  1.00 37.41           H  
ATOM   1132  HA  ASN    74     -15.692   4.094   6.667  1.00 11.14           H  
ATOM   1133  HB2 ASN    74     -16.008   4.219   4.148  1.00 37.41           H  
ATOM   1134  HB3 ASN    74     -15.129   2.697   4.044  1.00 37.41           H  
ATOM   1135 HD21 ASN    74     -16.171   0.813   4.570  1.00 37.41           H  
ATOM   1136 HD22 ASN    74     -17.843   0.739   4.984  1.00 37.41           H  
ATOM   1137  N   HIS    75     -13.105   2.509   7.018  1.00 14.22           N  
ATOM   1138  CA  HIS    75     -12.421   1.473   7.820  1.00 24.34           C  
ATOM   1139  C   HIS    75     -12.106   0.216   6.985  1.00 63.04           C  
ATOM   1140  O   HIS    75     -11.936  -0.882   7.520  1.00 64.04           O  
ATOM   1141  CB  HIS    75     -13.274   1.119   9.054  1.00 34.43           C  
ATOM   1142  CG  HIS    75     -12.532   0.386  10.133  1.00 15.42           C  
ATOM   1143  ND1 HIS    75     -12.548  -0.986  10.265  1.00  2.12           N  
ATOM   1144  CD2 HIS    75     -11.764   0.847  11.149  1.00 71.01           C  
ATOM   1145  CE1 HIS    75     -11.827  -1.335  11.311  1.00 72.22           C  
ATOM   1146  NE2 HIS    75     -11.339  -0.245  11.865  1.00 11.40           N  
ATOM   1147  H   HIS    75     -12.605   3.312   6.767  1.00 37.41           H  
ATOM   1148  HA  HIS    75     -11.486   1.895   8.157  1.00 70.03           H  
ATOM   1149  HB2 HIS    75     -13.657   2.031   9.486  1.00 37.41           H  
ATOM   1150  HB3 HIS    75     -14.105   0.501   8.745  1.00 37.41           H  
ATOM   1151  HD1 HIS    75     -13.019  -1.614   9.676  1.00 74.14           H  
ATOM   1152  HD2 HIS    75     -11.527   1.882  11.355  1.00 62.31           H  
ATOM   1153  HE1 HIS    75     -11.662  -2.346  11.653  1.00 23.12           H  
ATOM   1154  HE2 HIS    75     -10.934  -0.206  12.760  1.00 37.41           H  
ATOM   1155  N   GLN    76     -11.995   0.406   5.675  1.00 70.15           N  
ATOM   1156  CA  GLN    76     -11.689  -0.683   4.736  1.00 74.21           C  
ATOM   1157  C   GLN    76     -10.171  -0.827   4.527  1.00 71.43           C  
ATOM   1158  O   GLN    76      -9.428   0.149   4.651  1.00 53.14           O  
ATOM   1159  CB  GLN    76     -12.374  -0.393   3.393  1.00 42.12           C  
ATOM   1160  CG  GLN    76     -11.825   0.848   2.691  1.00 15.10           C  
ATOM   1161  CD  GLN    76     -12.765   1.405   1.641  1.00  1.43           C  
ATOM   1162  OE1 GLN    76     -12.715   1.031   0.471  1.00 50.25           O  
ATOM   1163  NE2 GLN    76     -13.614   2.324   2.052  1.00 12.54           N  
ATOM   1164  H   GLN    76     -12.121   1.309   5.323  1.00 37.41           H  
ATOM   1165  HA  GLN    76     -12.081  -1.604   5.143  1.00  5.43           H  
ATOM   1166  HB2 GLN    76     -12.235  -1.243   2.738  1.00 37.41           H  
ATOM   1167  HB3 GLN    76     -13.432  -0.249   3.563  1.00 37.41           H  
ATOM   1168  HG2 GLN    76     -11.647   1.615   3.431  1.00 37.41           H  
ATOM   1169  HG3 GLN    76     -10.889   0.592   2.215  1.00 37.41           H  
ATOM   1170 HE21 GLN    76     -13.589   2.593   2.992  1.00 37.41           H  
ATOM   1171 HE22 GLN    76     -14.248   2.691   1.397  1.00 37.41           H  
ATOM   1172  N   ILE    77      -9.715  -2.035   4.194  1.00 32.34           N  
ATOM   1173  CA  ILE    77      -8.283  -2.295   3.979  1.00 40.03           C  
ATOM   1174  C   ILE    77      -7.868  -1.955   2.540  1.00 24.44           C  
ATOM   1175  O   ILE    77      -8.107  -2.731   1.612  1.00 71.02           O  
ATOM   1176  CB  ILE    77      -7.923  -3.778   4.274  1.00 72.54           C  
ATOM   1177  CG1 ILE    77      -8.252  -4.137   5.732  1.00 71.52           C  
ATOM   1178  CG2 ILE    77      -6.445  -4.051   3.976  1.00 55.33           C  
ATOM   1179  CD1 ILE    77      -7.418  -3.391   6.752  1.00  4.14           C  
ATOM   1180  H   ILE    77     -10.356  -2.767   4.072  1.00 37.41           H  
ATOM   1181  HA  ILE    77      -7.722  -1.669   4.662  1.00 54.33           H  
ATOM   1182  HB  ILE    77      -8.514  -4.401   3.617  1.00 41.44           H  
ATOM   1183 HG12 ILE    77      -9.289  -3.910   5.927  1.00 37.41           H  
ATOM   1184 HG13 ILE    77      -8.090  -5.196   5.881  1.00 37.41           H  
ATOM   1185 HG21 ILE    77      -6.214  -5.082   4.206  1.00 37.41           H  
ATOM   1186 HG22 ILE    77      -5.826  -3.401   4.579  1.00 37.41           H  
ATOM   1187 HG23 ILE    77      -6.247  -3.865   2.930  1.00 37.41           H  
ATOM   1188 HD11 ILE    77      -6.377  -3.650   6.624  1.00 37.41           H  
ATOM   1189 HD12 ILE    77      -7.735  -3.667   7.746  1.00 37.41           H  
ATOM   1190 HD13 ILE    77      -7.545  -2.327   6.616  1.00 37.41           H  
ATOM   1191  N   ILE    78      -7.258  -0.789   2.357  1.00 42.24           N  
ATOM   1192  CA  ILE    78      -6.824  -0.346   1.024  1.00 51.22           C  
ATOM   1193  C   ILE    78      -5.345  -0.674   0.761  1.00 70.34           C  
ATOM   1194  O   ILE    78      -4.940  -0.865  -0.388  1.00 50.21           O  
ATOM   1195  CB  ILE    78      -7.057   1.174   0.830  1.00 32.12           C  
ATOM   1196  CG1 ILE    78      -6.289   1.979   1.892  1.00 53.32           C  
ATOM   1197  CG2 ILE    78      -8.551   1.494   0.876  1.00 11.03           C  
ATOM   1198  CD1 ILE    78      -6.479   3.475   1.785  1.00 34.20           C  
ATOM   1199  H   ILE    78      -7.099  -0.209   3.131  1.00 37.41           H  
ATOM   1200  HA  ILE    78      -7.424  -0.870   0.290  1.00 62.01           H  
ATOM   1201  HB  ILE    78      -6.691   1.447  -0.151  1.00 52.10           H  
ATOM   1202 HG12 ILE    78      -6.619   1.676   2.875  1.00 37.41           H  
ATOM   1203 HG13 ILE    78      -5.231   1.773   1.796  1.00 37.41           H  
ATOM   1204 HG21 ILE    78      -8.701   2.554   0.726  1.00 37.41           H  
ATOM   1205 HG22 ILE    78      -8.953   1.206   1.838  1.00 37.41           H  
ATOM   1206 HG23 ILE    78      -9.062   0.945   0.097  1.00 37.41           H  
ATOM   1207 HD11 ILE    78      -5.860   3.968   2.520  1.00 37.41           H  
ATOM   1208 HD12 ILE    78      -7.515   3.722   1.966  1.00 37.41           H  
ATOM   1209 HD13 ILE    78      -6.198   3.807   0.798  1.00 37.41           H  
ATOM   1210  N   GLY    79      -4.543  -0.740   1.826  1.00 72.31           N  
ATOM   1211  CA  GLY    79      -3.118  -1.037   1.679  1.00 14.54           C  
ATOM   1212  C   GLY    79      -2.586  -2.007   2.734  1.00 61.14           C  
ATOM   1213  O   GLY    79      -3.094  -2.060   3.853  1.00 22.12           O  
ATOM   1214  H   GLY    79      -4.920  -0.581   2.720  1.00 37.41           H  
ATOM   1215  HA2 GLY    79      -2.948  -1.464   0.699  1.00 37.41           H  
ATOM   1216  HA3 GLY    79      -2.566  -0.111   1.750  1.00 37.41           H  
ATOM   1217  N   THR    80      -1.552  -2.767   2.373  1.00 55.11           N  
ATOM   1218  CA  THR    80      -0.925  -3.738   3.289  1.00 61.41           C  
ATOM   1219  C   THR    80       0.586  -3.837   3.039  1.00 45.05           C  
ATOM   1220  O   THR    80       1.017  -4.076   1.916  1.00 71.44           O  
ATOM   1221  CB  THR    80      -1.558  -5.147   3.137  1.00 41.01           C  
ATOM   1222  OG1 THR    80      -2.947  -5.106   3.503  1.00 65.52           O  
ATOM   1223  CG2 THR    80      -0.837  -6.182   3.998  1.00  5.43           C  
ATOM   1224  H   THR    80      -1.195  -2.681   1.463  1.00 37.41           H  
ATOM   1225  HA  THR    80      -1.093  -3.397   4.304  1.00 64.32           H  
ATOM   1226  HB  THR    80      -1.480  -5.447   2.100  1.00 64.12           H  
ATOM   1227  HG1 THR    80      -3.488  -5.116   2.709  1.00 11.42           H  
ATOM   1228 HG21 THR    80      -0.865  -5.876   5.034  1.00 37.41           H  
ATOM   1229 HG22 THR    80       0.192  -6.269   3.677  1.00 37.41           H  
ATOM   1230 HG23 THR    80      -1.326  -7.140   3.896  1.00 37.41           H  
ATOM   1231  N   SER    81       1.385  -3.644   4.084  1.00 55.20           N  
ATOM   1232  CA  SER    81       2.854  -3.672   3.956  1.00 70.42           C  
ATOM   1233  C   SER    81       3.435  -5.074   4.181  1.00  1.13           C  
ATOM   1234  O   SER    81       2.783  -5.955   4.752  1.00  0.21           O  
ATOM   1235  CB  SER    81       3.496  -2.690   4.943  1.00 14.40           C  
ATOM   1236  OG  SER    81       4.910  -2.741   4.869  1.00 40.10           O  
ATOM   1237  H   SER    81       0.986  -3.476   4.965  1.00 37.41           H  
ATOM   1238  HA  SER    81       3.099  -3.358   2.950  1.00 32.31           H  
ATOM   1239  HB2 SER    81       3.174  -1.686   4.710  1.00 37.41           H  
ATOM   1240  HB3 SER    81       3.189  -2.937   5.950  1.00 37.41           H  
ATOM   1241  HG  SER    81       5.256  -1.873   4.625  1.00 61.12           H  
ATOM   1242  N   GLN    82       4.677  -5.271   3.739  1.00  5.15           N  
ATOM   1243  CA  GLN    82       5.359  -6.558   3.892  1.00 21.22           C  
ATOM   1244  C   GLN    82       6.166  -6.618   5.200  1.00 62.30           C  
ATOM   1245  O   GLN    82       6.863  -5.668   5.560  1.00 11.14           O  
ATOM   1246  CB  GLN    82       6.300  -6.835   2.704  1.00 60.54           C  
ATOM   1247  CG  GLN    82       5.623  -6.827   1.331  1.00 40.12           C  
ATOM   1248  CD  GLN    82       5.440  -5.429   0.762  1.00 34.15           C  
ATOM   1249  OE1 GLN    82       4.416  -4.784   0.956  1.00 74.24           O  
ATOM   1250  NE2 GLN    82       6.438  -4.949   0.049  1.00 13.44           N  
ATOM   1251  H   GLN    82       5.147  -4.528   3.306  1.00 37.41           H  
ATOM   1252  HA  GLN    82       4.602  -7.330   3.918  1.00 24.02           H  
ATOM   1253  HB2 GLN    82       7.079  -6.085   2.698  1.00 37.41           H  
ATOM   1254  HB3 GLN    82       6.756  -7.805   2.847  1.00 37.41           H  
ATOM   1255  HG2 GLN    82       6.229  -7.400   0.645  1.00 37.41           H  
ATOM   1256  HG3 GLN    82       4.651  -7.295   1.421  1.00 37.41           H  
ATOM   1257 HE21 GLN    82       7.232  -5.512  -0.077  1.00 37.41           H  
ATOM   1258 HE22 GLN    82       6.351  -4.046  -0.311  1.00 37.41           H  
ATOM   1259  N   MET    83       6.062  -7.752   5.893  1.00 21.12           N  
ATOM   1260  CA  MET    83       6.801  -8.008   7.140  1.00 20.12           C  
ATOM   1261  C   MET    83       8.272  -7.528   7.081  1.00 52.45           C  
ATOM   1262  O   MET    83       9.072  -8.020   6.280  1.00 11.10           O  
ATOM   1263  CB  MET    83       6.744  -9.512   7.447  1.00 43.35           C  
ATOM   1264  CG  MET    83       7.207 -10.389   6.284  1.00  3.32           C  
ATOM   1265  SD  MET    83       6.966 -12.151   6.591  1.00 54.34           S  
ATOM   1266  CE  MET    83       7.519 -12.842   5.032  1.00 11.34           C  
ATOM   1267  H   MET    83       5.448  -8.442   5.563  1.00 37.41           H  
ATOM   1268  HA  MET    83       6.297  -7.475   7.933  1.00 14.22           H  
ATOM   1269  HB2 MET    83       7.371  -9.722   8.305  1.00 37.41           H  
ATOM   1270  HB3 MET    83       5.724  -9.780   7.687  1.00 37.41           H  
ATOM   1271  HG2 MET    83       6.649 -10.117   5.399  1.00 37.41           H  
ATOM   1272  HG3 MET    83       8.258 -10.210   6.111  1.00 37.41           H  
ATOM   1273  HE1 MET    83       8.537 -12.535   4.843  1.00 37.41           H  
ATOM   1274  HE2 MET    83       6.882 -12.488   4.235  1.00 37.41           H  
ATOM   1275  HE3 MET    83       7.472 -13.919   5.079  1.00 37.41           H  
ATOM   1276  N   TYR    84       8.613  -6.554   7.932  1.00 31.51           N  
ATOM   1277  CA  TYR    84       9.984  -6.026   8.013  1.00 62.50           C  
ATOM   1278  C   TYR    84      10.837  -6.825   9.012  1.00 11.43           C  
ATOM   1279  O   TYR    84      10.323  -7.658   9.759  1.00 44.01           O  
ATOM   1280  CB  TYR    84       9.965  -4.547   8.426  1.00 12.32           C  
ATOM   1281  CG  TYR    84       9.245  -3.642   7.444  1.00 41.13           C  
ATOM   1282  CD1 TYR    84       9.902  -3.121   6.334  1.00 70.11           C  
ATOM   1283  CD2 TYR    84       7.905  -3.308   7.626  1.00 12.42           C  
ATOM   1284  CE1 TYR    84       9.250  -2.294   5.440  1.00  1.15           C  
ATOM   1285  CE2 TYR    84       7.248  -2.483   6.735  1.00 14.23           C  
ATOM   1286  CZ  TYR    84       7.924  -1.978   5.644  1.00 12.04           C  
ATOM   1287  OH  TYR    84       7.268  -1.156   4.750  1.00 22.12           O  
ATOM   1288  H   TYR    84       7.924  -6.176   8.519  1.00 37.41           H  
ATOM   1289  HA  TYR    84      10.433  -6.109   7.032  1.00 13.23           H  
ATOM   1290  HB2 TYR    84       9.470  -4.455   9.383  1.00 37.41           H  
ATOM   1291  HB3 TYR    84      10.982  -4.193   8.520  1.00 37.41           H  
ATOM   1292  HD1 TYR    84      10.941  -3.370   6.174  1.00 62.23           H  
ATOM   1293  HD2 TYR    84       7.378  -3.702   8.483  1.00 30.20           H  
ATOM   1294  HE1 TYR    84       9.780  -1.899   4.585  1.00 12.23           H  
ATOM   1295  HE2 TYR    84       6.209  -2.237   6.896  1.00 61.43           H  
ATOM   1296  HH  TYR    84       7.405  -1.483   3.856  1.00 43.33           H  
ATOM   1297  N   SER    85      12.141  -6.561   9.027  1.00 13.02           N  
ATOM   1298  CA  SER    85      13.061  -7.245   9.949  1.00 52.24           C  
ATOM   1299  C   SER    85      13.109  -6.551  11.317  1.00 42.44           C  
ATOM   1300  O   SER    85      12.815  -7.158  12.349  1.00  1.01           O  
ATOM   1301  CB  SER    85      14.472  -7.300   9.348  1.00 54.31           C  
ATOM   1302  OG  SER    85      14.975  -5.995   9.092  1.00 43.35           O  
ATOM   1303  H   SER    85      12.498  -5.896   8.403  1.00 37.41           H  
ATOM   1304  HA  SER    85      12.702  -8.256  10.086  1.00 51.40           H  
ATOM   1305  HB2 SER    85      15.137  -7.798  10.039  1.00 37.41           H  
ATOM   1306  HB3 SER    85      14.443  -7.850   8.418  1.00 37.41           H  
ATOM   1307  HG  SER    85      15.881  -6.067   8.762  1.00  2.54           H  
ATOM   1308  N   SER    86      13.502  -5.279  11.322  1.00 63.42           N  
ATOM   1309  CA  SER    86      13.582  -4.489  12.559  1.00 74.23           C  
ATOM   1310  C   SER    86      12.373  -3.556  12.705  1.00 73.32           C  
ATOM   1311  O   SER    86      11.706  -3.226  11.719  1.00 23.32           O  
ATOM   1312  CB  SER    86      14.864  -3.644  12.572  1.00 54.32           C  
ATOM   1313  OG  SER    86      14.833  -2.648  11.557  1.00 20.40           O  
ATOM   1314  H   SER    86      13.752  -4.859  10.472  1.00 37.41           H  
ATOM   1315  HA  SER    86      13.604  -5.173  13.397  1.00 44.14           H  
ATOM   1316  HB2 SER    86      14.965  -3.158  13.532  1.00 37.41           H  
ATOM   1317  HB3 SER    86      15.718  -4.286  12.404  1.00 37.41           H  
ATOM   1318  HG  SER    86      15.653  -2.682  11.042  1.00 20.51           H  
ATOM   1319  N   THR    87      12.093  -3.124  13.933  1.00 65.31           N  
ATOM   1320  CA  THR    87      11.020  -2.149  14.177  1.00 45.55           C  
ATOM   1321  C   THR    87      11.331  -0.822  13.479  1.00 11.24           C  
ATOM   1322  O   THR    87      10.457  -0.203  12.870  1.00 23.25           O  
ATOM   1323  CB  THR    87      10.808  -1.882  15.687  1.00 50.10           C  
ATOM   1324  OG1 THR    87      11.999  -1.322  16.264  1.00 33.13           O  
ATOM   1325  CG2 THR    87      10.444  -3.167  16.423  1.00 61.13           C  
ATOM   1326  H   THR    87      12.616  -3.464  14.695  1.00 37.41           H  
ATOM   1327  HA  THR    87      10.102  -2.553  13.769  1.00 30.01           H  
ATOM   1328  HB  THR    87       9.997  -1.177  15.803  1.00 74.14           H  
ATOM   1329  HG1 THR    87      11.760  -0.583  16.839  1.00  3.11           H  
ATOM   1330 HG21 THR    87      11.243  -3.887  16.310  1.00 37.41           H  
ATOM   1331 HG22 THR    87       9.531  -3.574  16.010  1.00 37.41           H  
ATOM   1332 HG23 THR    87      10.299  -2.953  17.472  1.00 37.41           H  
ATOM   1333  N   ALA    88      12.596  -0.405  13.561  1.00 52.20           N  
ATOM   1334  CA  ALA    88      13.069   0.810  12.892  1.00 21.41           C  
ATOM   1335  C   ALA    88      12.811   0.757  11.376  1.00 34.01           C  
ATOM   1336  O   ALA    88      12.411   1.755  10.775  1.00 31.42           O  
ATOM   1337  CB  ALA    88      14.554   1.029  13.174  1.00 62.43           C  
ATOM   1338  H   ALA    88      13.229  -0.927  14.098  1.00 37.41           H  
ATOM   1339  HA  ALA    88      12.525   1.647  13.307  1.00 22.44           H  
ATOM   1340  HB1 ALA    88      14.722   1.033  14.240  1.00 37.41           H  
ATOM   1341  HB2 ALA    88      14.865   1.977  12.759  1.00 37.41           H  
ATOM   1342  HB3 ALA    88      15.131   0.234  12.723  1.00 37.41           H  
ATOM   1343  N   ALA    89      13.041  -0.408  10.763  1.00 22.32           N  
ATOM   1344  CA  ALA    89      12.750  -0.606   9.334  1.00 24.30           C  
ATOM   1345  C   ALA    89      11.290  -0.260   9.009  1.00 74.43           C  
ATOM   1346  O   ALA    89      10.999   0.381   7.999  1.00 61.43           O  
ATOM   1347  CB  ALA    89      13.051  -2.044   8.923  1.00 34.13           C  
ATOM   1348  H   ALA    89      13.429  -1.150  11.279  1.00 37.41           H  
ATOM   1349  HA  ALA    89      13.399   0.050   8.770  1.00 31.22           H  
ATOM   1350  HB1 ALA    89      12.424  -2.721   9.486  1.00 37.41           H  
ATOM   1351  HB2 ALA    89      14.088  -2.266   9.123  1.00 37.41           H  
ATOM   1352  HB3 ALA    89      12.855  -2.167   7.866  1.00 37.41           H  
ATOM   1353  N   ARG    90      10.381  -0.684   9.883  1.00 11.00           N  
ATOM   1354  CA  ARG    90       8.951  -0.412   9.713  1.00 33.04           C  
ATOM   1355  C   ARG    90       8.652   1.096   9.741  1.00 30.22           C  
ATOM   1356  O   ARG    90       8.065   1.641   8.808  1.00 73.34           O  
ATOM   1357  CB  ARG    90       8.152  -1.104  10.823  1.00 44.22           C  
ATOM   1358  CG  ARG    90       6.644  -0.872  10.740  1.00 45.02           C  
ATOM   1359  CD  ARG    90       5.953  -1.217  12.052  1.00 61.31           C  
ATOM   1360  NE  ARG    90       6.448  -0.396  13.158  1.00 33.23           N  
ATOM   1361  CZ  ARG    90       5.953  -0.406  14.365  1.00 13.35           C  
ATOM   1362  NH1 ARG    90       4.968  -1.191  14.672  1.00 64.35           N  
ATOM   1363  NH2 ARG    90       6.455   0.371  15.264  1.00 43.35           N  
ATOM   1364  H   ARG    90      10.680  -1.197  10.664  1.00 37.41           H  
ATOM   1365  HA  ARG    90       8.646  -0.814   8.758  1.00 34.12           H  
ATOM   1366  HB2 ARG    90       8.335  -2.169  10.770  1.00 37.41           H  
ATOM   1367  HB3 ARG    90       8.499  -0.738  11.779  1.00 37.41           H  
ATOM   1368  HG2 ARG    90       6.459   0.170  10.512  1.00 37.41           H  
ATOM   1369  HG3 ARG    90       6.236  -1.491   9.952  1.00 37.41           H  
ATOM   1370  HD2 ARG    90       4.890  -1.054  11.938  1.00 37.41           H  
ATOM   1371  HD3 ARG    90       6.135  -2.259  12.277  1.00 37.41           H  
ATOM   1372  HE  ARG    90       7.196   0.212  12.977  1.00 52.40           H  
ATOM   1373 HH11 ARG    90       4.581  -1.794  13.988  1.00 37.41           H  
ATOM   1374 HH12 ARG    90       4.591  -1.178  15.600  1.00 37.41           H  
ATOM   1375 HH21 ARG    90       7.217   0.980  15.028  1.00 37.41           H  
ATOM   1376 HH22 ARG    90       6.080   0.373  16.190  1.00 37.41           H  
ATOM   1377  N   ASP    91       9.064   1.763  10.816  1.00 40.42           N  
ATOM   1378  CA  ASP    91       8.766   3.187  11.006  1.00  2.52           C  
ATOM   1379  C   ASP    91       9.501   4.082   9.985  1.00 70.24           C  
ATOM   1380  O   ASP    91       8.964   5.108   9.551  1.00 75.01           O  
ATOM   1381  CB  ASP    91       9.087   3.594  12.447  1.00 21.44           C  
ATOM   1382  CG  ASP    91       8.134   2.936  13.440  1.00  2.12           C  
ATOM   1383  OD1 ASP    91       8.377   1.775  13.833  1.00 23.12           O  
ATOM   1384  OD2 ASP    91       7.127   3.571  13.818  1.00 30.33           O  
ATOM   1385  H   ASP    91       9.578   1.286  11.507  1.00 37.41           H  
ATOM   1386  HA  ASP    91       7.702   3.311  10.850  1.00 41.42           H  
ATOM   1387  HB2 ASP    91      10.099   3.294  12.684  1.00 37.41           H  
ATOM   1388  HB3 ASP    91       9.003   4.668  12.545  1.00 37.41           H  
ATOM   1389  N   ASN    92      10.717   3.698   9.593  1.00 24.54           N  
ATOM   1390  CA  ASN    92      11.417   4.388   8.500  1.00 43.40           C  
ATOM   1391  C   ASN    92      10.694   4.148   7.170  1.00 41.23           C  
ATOM   1392  O   ASN    92      10.585   5.048   6.331  1.00  5.51           O  
ATOM   1393  CB  ASN    92      12.887   3.949   8.402  1.00 21.14           C  
ATOM   1394  CG  ASN    92      13.772   4.674   9.401  1.00  3.32           C  
ATOM   1395  OD1 ASN    92      14.285   5.755   9.126  1.00  3.13           O  
ATOM   1396  ND2 ASN    92      13.967   4.091  10.563  1.00 32.32           N  
ATOM   1397  H   ASN    92      11.145   2.938  10.038  1.00 37.41           H  
ATOM   1398  HA  ASN    92      11.384   5.449   8.713  1.00 54.44           H  
ATOM   1399  HB2 ASN    92      12.954   2.888   8.595  1.00 37.41           H  
ATOM   1400  HB3 ASN    92      13.258   4.152   7.408  1.00 37.41           H  
ATOM   1401 HD21 ASN    92      13.540   3.227  10.725  1.00 37.41           H  
ATOM   1402 HD22 ASN    92      14.534   4.551  11.217  1.00 37.41           H  
ATOM   1403  N   GLY    93      10.190   2.929   6.988  1.00 33.01           N  
ATOM   1404  CA  GLY    93       9.344   2.637   5.843  1.00 30.33           C  
ATOM   1405  C   GLY    93       8.134   3.563   5.786  1.00 44.40           C  
ATOM   1406  O   GLY    93       7.849   4.154   4.747  1.00 20.01           O  
ATOM   1407  H   GLY    93      10.397   2.219   7.635  1.00 37.41           H  
ATOM   1408  HA2 GLY    93       9.924   2.753   4.939  1.00 37.41           H  
ATOM   1409  HA3 GLY    93       9.003   1.614   5.912  1.00 37.41           H  
ATOM   1410  N   ILE    94       7.447   3.709   6.923  1.00 62.14           N  
ATOM   1411  CA  ILE    94       6.288   4.608   7.043  1.00 63.01           C  
ATOM   1412  C   ILE    94       6.627   6.044   6.601  1.00 65.20           C  
ATOM   1413  O   ILE    94       5.849   6.682   5.889  1.00 33.41           O  
ATOM   1414  CB  ILE    94       5.743   4.632   8.499  1.00 21.43           C  
ATOM   1415  CG1 ILE    94       5.302   3.219   8.929  1.00 22.41           C  
ATOM   1416  CG2 ILE    94       4.585   5.624   8.628  1.00 31.41           C  
ATOM   1417  CD1 ILE    94       4.824   3.133  10.365  1.00  5.53           C  
ATOM   1418  H   ILE    94       7.722   3.187   7.707  1.00 37.41           H  
ATOM   1419  HA  ILE    94       5.507   4.226   6.398  1.00 63.10           H  
ATOM   1420  HB  ILE    94       6.540   4.963   9.151  1.00 62.24           H  
ATOM   1421 HG12 ILE    94       4.489   2.896   8.295  1.00 37.41           H  
ATOM   1422 HG13 ILE    94       6.133   2.537   8.814  1.00 37.41           H  
ATOM   1423 HG21 ILE    94       4.214   5.620   9.643  1.00 37.41           H  
ATOM   1424 HG22 ILE    94       3.789   5.340   7.954  1.00 37.41           H  
ATOM   1425 HG23 ILE    94       4.930   6.617   8.377  1.00 37.41           H  
ATOM   1426 HD11 ILE    94       3.967   3.777  10.500  1.00 37.41           H  
ATOM   1427 HD12 ILE    94       5.616   3.447  11.029  1.00 37.41           H  
ATOM   1428 HD13 ILE    94       4.547   2.114  10.593  1.00 37.41           H  
ATOM   1429  N   LYS    95       7.788   6.552   7.022  1.00 12.12           N  
ATOM   1430  CA  LYS    95       8.235   7.888   6.599  1.00  3.54           C  
ATOM   1431  C   LYS    95       8.322   7.975   5.064  1.00 12.31           C  
ATOM   1432  O   LYS    95       7.893   8.962   4.450  1.00 50.22           O  
ATOM   1433  CB  LYS    95       9.593   8.237   7.227  1.00 22.14           C  
ATOM   1434  CG  LYS    95       9.587   8.239   8.756  1.00  4.23           C  
ATOM   1435  CD  LYS    95      10.887   8.798   9.339  1.00 72.42           C  
ATOM   1436  CE  LYS    95      12.109   7.977   8.938  1.00 70.43           C  
ATOM   1437  NZ  LYS    95      13.371   8.537   9.501  1.00 24.34           N  
ATOM   1438  H   LYS    95       8.350   6.022   7.631  1.00 37.41           H  
ATOM   1439  HA  LYS    95       7.498   8.603   6.941  1.00 23.11           H  
ATOM   1440  HB2 LYS    95      10.326   7.516   6.891  1.00 37.41           H  
ATOM   1441  HB3 LYS    95       9.889   9.221   6.888  1.00 37.41           H  
ATOM   1442  HG2 LYS    95       8.761   8.846   9.101  1.00 37.41           H  
ATOM   1443  HG3 LYS    95       9.455   7.224   9.104  1.00 37.41           H  
ATOM   1444  HD2 LYS    95      11.020   9.810   8.984  1.00 37.41           H  
ATOM   1445  HD3 LYS    95      10.809   8.806  10.417  1.00 37.41           H  
ATOM   1446  HE2 LYS    95      11.985   6.967   9.301  1.00 37.41           H  
ATOM   1447  HE3 LYS    95      12.184   7.965   7.859  1.00 37.41           H  
ATOM   1448  HZ1 LYS    95      14.163   7.886   9.326  1.00 37.41           H  
ATOM   1449  HZ2 LYS    95      13.276   8.681  10.528  1.00 37.41           H  
ATOM   1450  HZ3 LYS    95      13.591   9.450   9.056  1.00 37.41           H  
ATOM   1451  N   SER    96       8.874   6.930   4.450  1.00 12.50           N  
ATOM   1452  CA  SER    96       8.935   6.835   2.987  1.00 44.14           C  
ATOM   1453  C   SER    96       7.523   6.782   2.387  1.00 64.41           C  
ATOM   1454  O   SER    96       7.223   7.487   1.426  1.00 44.33           O  
ATOM   1455  CB  SER    96       9.733   5.594   2.559  1.00 22.51           C  
ATOM   1456  OG  SER    96      11.057   5.631   3.076  1.00 73.53           O  
ATOM   1457  H   SER    96       9.251   6.202   4.993  1.00 37.41           H  
ATOM   1458  HA  SER    96       9.437   7.720   2.617  1.00 20.13           H  
ATOM   1459  HB2 SER    96       9.243   4.706   2.928  1.00 37.41           H  
ATOM   1460  HB3 SER    96       9.785   5.554   1.479  1.00 37.41           H  
ATOM   1461  HG  SER    96      11.063   5.256   3.966  1.00 64.30           H  
ATOM   1462  N   VAL    97       6.660   5.955   2.985  1.00 22.23           N  
ATOM   1463  CA  VAL    97       5.264   5.803   2.542  1.00 24.34           C  
ATOM   1464  C   VAL    97       4.527   7.147   2.515  1.00  2.13           C  
ATOM   1465  O   VAL    97       3.820   7.463   1.560  1.00 62.41           O  
ATOM   1466  CB  VAL    97       4.482   4.840   3.469  1.00 14.51           C  
ATOM   1467  CG1 VAL    97       3.028   4.690   3.018  1.00 71.24           C  
ATOM   1468  CG2 VAL    97       5.166   3.484   3.543  1.00 15.31           C  
ATOM   1469  H   VAL    97       6.969   5.428   3.749  1.00 37.41           H  
ATOM   1470  HA  VAL    97       5.273   5.385   1.545  1.00  1.13           H  
ATOM   1471  HB  VAL    97       4.483   5.263   4.462  1.00 32.32           H  
ATOM   1472 HG11 VAL    97       2.517   3.998   3.672  1.00 37.41           H  
ATOM   1473 HG12 VAL    97       2.999   4.315   2.006  1.00 37.41           H  
ATOM   1474 HG13 VAL    97       2.536   5.653   3.057  1.00 37.41           H  
ATOM   1475 HG21 VAL    97       6.196   3.614   3.837  1.00 37.41           H  
ATOM   1476 HG22 VAL    97       5.126   3.005   2.576  1.00 37.41           H  
ATOM   1477 HG23 VAL    97       4.663   2.866   4.269  1.00 37.41           H  
ATOM   1478  N   MET    98       4.684   7.935   3.575  1.00 75.31           N  
ATOM   1479  CA  MET    98       4.060   9.256   3.635  1.00 41.35           C  
ATOM   1480  C   MET    98       4.594  10.166   2.521  1.00 41.34           C  
ATOM   1481  O   MET    98       3.834  10.905   1.898  1.00  0.11           O  
ATOM   1482  CB  MET    98       4.282   9.904   5.010  1.00  4.12           C  
ATOM   1483  CG  MET    98       3.651   9.128   6.161  1.00  3.41           C  
ATOM   1484  SD  MET    98       3.719  10.019   7.729  1.00 30.23           S  
ATOM   1485  CE  MET    98       5.489  10.191   7.964  1.00 73.24           C  
ATOM   1486  H   MET    98       5.226   7.621   4.328  1.00 37.41           H  
ATOM   1487  HA  MET    98       2.997   9.119   3.485  1.00 63.30           H  
ATOM   1488  HB2 MET    98       5.345   9.979   5.192  1.00 37.41           H  
ATOM   1489  HB3 MET    98       3.857  10.899   5.001  1.00 37.41           H  
ATOM   1490  HG2 MET    98       2.615   8.938   5.924  1.00 37.41           H  
ATOM   1491  HG3 MET    98       4.171   8.187   6.275  1.00 37.41           H  
ATOM   1492  HE1 MET    98       5.914  10.735   7.133  1.00 37.41           H  
ATOM   1493  HE2 MET    98       5.944   9.212   8.020  1.00 37.41           H  
ATOM   1494  HE3 MET    98       5.681  10.729   8.882  1.00 37.41           H  
ATOM   1495  N   GLU    99       5.900  10.090   2.259  1.00 34.51           N  
ATOM   1496  CA  GLU    99       6.524  10.917   1.218  1.00 32.11           C  
ATOM   1497  C   GLU    99       6.046  10.539  -0.201  1.00 60.22           C  
ATOM   1498  O   GLU    99       5.629  11.400  -0.976  1.00 44.32           O  
ATOM   1499  CB  GLU    99       8.050  10.794   1.271  1.00 52.15           C  
ATOM   1500  CG  GLU    99       8.757  11.763   0.329  1.00 14.20           C  
ATOM   1501  CD  GLU    99      10.186  11.363   0.018  1.00 63.03           C  
ATOM   1502  OE1 GLU    99      11.087  11.658   0.828  1.00  4.14           O  
ATOM   1503  OE2 GLU    99      10.411  10.767  -1.055  1.00 13.44           O  
ATOM   1504  H   GLU    99       6.463   9.475   2.785  1.00 37.41           H  
ATOM   1505  HA  GLU    99       6.253  11.946   1.411  1.00 25.32           H  
ATOM   1506  HB2 GLU    99       8.383  10.993   2.280  1.00 37.41           H  
ATOM   1507  HB3 GLU    99       8.331   9.785   1.000  1.00 37.41           H  
ATOM   1508  HG2 GLU    99       8.204  11.808  -0.599  1.00 37.41           H  
ATOM   1509  HG3 GLU    99       8.764  12.745   0.782  1.00 37.41           H  
ATOM   1510  N   ASN   100       6.127   9.251  -0.544  1.00  3.11           N  
ATOM   1511  CA  ASN   100       5.842   8.796  -1.917  1.00 53.52           C  
ATOM   1512  C   ASN   100       4.372   8.388  -2.122  1.00 23.34           C  
ATOM   1513  O   ASN   100       3.846   8.496  -3.227  1.00 14.11           O  
ATOM   1514  CB  ASN   100       6.779   7.641  -2.304  1.00 64.23           C  
ATOM   1515  CG  ASN   100       6.757   6.484  -1.319  1.00 11.22           C  
ATOM   1516  OD1 ASN   100       5.763   6.225  -0.659  1.00  1.03           O  
ATOM   1517  ND2 ASN   100       7.864   5.780  -1.212  1.00 14.54           N  
ATOM   1518  H   ASN   100       6.376   8.589   0.139  1.00 37.41           H  
ATOM   1519  HA  ASN   100       6.048   9.629  -2.577  1.00  2.41           H  
ATOM   1520  HB2 ASN   100       6.490   7.260  -3.272  1.00 37.41           H  
ATOM   1521  HB3 ASN   100       7.792   8.017  -2.366  1.00 37.41           H  
ATOM   1522 HD21 ASN   100       8.632   6.031  -1.764  1.00 37.41           H  
ATOM   1523 HD22 ASN   100       7.867   5.034  -0.583  1.00 37.41           H  
ATOM   1524  N   GLY   101       3.716   7.930  -1.060  1.00 34.41           N  
ATOM   1525  CA  GLY   101       2.311   7.520  -1.144  1.00 21.04           C  
ATOM   1526  C   GLY   101       1.373   8.620  -1.650  1.00 72.40           C  
ATOM   1527  O   GLY   101       0.233   8.351  -2.033  1.00  3.20           O  
ATOM   1528  H   GLY   101       4.194   7.839  -0.209  1.00 37.41           H  
ATOM   1529  HA2 GLY   101       2.236   6.673  -1.809  1.00 37.41           H  
ATOM   1530  HA3 GLY   101       1.986   7.212  -0.161  1.00 37.41           H  
END
