
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   45 (  356),  selected   45 , name 2ay0_D
# Molecule2: number of CA atoms   40 (  676),  selected   40 , name T0474.pdb
# PARAMETERS: 2ay0_D.T0474.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T     3_D      M       9          1.976
LGA    T     4_D      G      10          1.441
LGA    T     5_D      R      11          0.872
LGA    M     6_D      I      12          0.692
LGA    G     7_D      L      13          0.564
LGA    V     8_D      L      14          0.571
LGA    M     9_D      D      15          0.350
LGA    L    10_D      L      16          0.974
LGA    D    11_D      S      17          0.432
LGA    D    12_D      N      18          0.257
LGA    A    13_D      E      19          0.493
LGA    T    14_D      V      20          0.549
LGA    R    15_D      I      21          1.025
LGA    E    16_D      K      22          1.136
LGA    R    17_D      Q      23          0.593
LGA    I    18_D      L      24          0.596
LGA    K    19_D      D      25          1.261
LGA    S    20_D      D      26          1.156
LGA    A    21_D      L      27          0.611
LGA    A    22_D      E      28          1.254
LGA    T    23_D      V      29          1.020
LGA    R    24_D      Q      30          0.911
LGA    I    25_D      R      31          1.432
LGA    D    26_D      N      32          1.714
LGA    R    27_D      L      33          1.246
LGA    T    28_D      P      34          1.330
LGA    P    29_D      R      35          0.786
LGA    H    30_D      A      36          0.894
LGA    W    31_D      D      37          0.874
LGA    L    32_D      L      38          0.656
LGA    I    33_D      L      39          0.552
LGA    K    34_D      R      40          0.567
LGA    Q    35_D      E      41          0.845
LGA    A    36_D      A      42          0.478
LGA    I    37_D      V      43          0.682
LGA    F    38_D      D      44          0.632
LGA    S    39_D      Q      45          0.666
LGA    Y    40_D      Y      46          0.720
LGA    L    41_D      L      47          0.652
LGA    E    42_D      I      48          0.624
LGA    Q    43_D      -       -           -
LGA    L    44_D      -       -           -
LGA    E    45_D      -       -           -
LGA    N    46_D      -       -           -
LGA    S    47_D      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   45   40    5.0     40    0.93    12.50     98.037     3.881

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.914679 * X  +   0.336744 * Y  +  -0.223530 * Z  +  13.135184
  Y_new =   0.370451 * X  +   0.477292 * Y  +  -0.796843 * Z  +  -8.463907
  Z_new =  -0.161643 * X  +  -0.811662 * Y  +  -0.561316 * Z  +  38.004986 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.175838    0.965755  [ DEG:  -124.6663     55.3337 ]
  Theta =   0.162355    2.979238  [ DEG:     9.3023    170.6977 ]
  Phi   =   2.756778   -0.384815  [ DEG:   157.9517    -22.0483 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ay0_D                                        
REMARK     2: T0474.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ay0_D.T0474.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   45   40   5.0   40   0.93   12.50  98.037
REMARK  ---------------------------------------------------------- 
MOLECULE 2ay0_D
HEADER    DNA BINDING PROTEIN                     06-SEP-05   2AY0              
TITLE     STRUCTURE OF THE LYS9MET MUTANT OF THE E. COLI PROLINE                
TITLE    2 UTILIZATION A (PUTA) DNA-BINDING DOMAIN.                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: BIFUNCTIONAL PUTA PROTEIN;                                 
COMPND   3 CHAIN: A, B, C, D, E, F;                                             
COMPND   4 FRAGMENT: RESIDUES 1-52;                                             
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: PUTA, POAA;                                                    
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21DE3 PLYSS;                             
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET23B                                    
KEYWDS    PUTA, RIBBON-HELIX-HELIX, DNA-BINDING DOMAIN, PROLINE                 
KEYWDS   2 CATABOLISM, PROLINE UTILIZATION A                                    
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.D.LARSON,J.P.SCHUERMANN,Y.ZHOU,J.L.JENKINS,D.F.BECKER,              
AUTHOR   2 J.J.TANNER                                                           
REVDAT   2   05-DEC-06 2AY0    1       JRNL                                     
REVDAT   1   15-AUG-06 2AY0    0                                                
JRNL        AUTH   J.D.LARSON,J.L.JENKINS,J.P.SCHUERMANN,Y.ZHOU,                
JRNL        AUTH 2 D.F.BECKER,J.J.TANNER                                        
JRNL        TITL   CRYSTAL STRUCTURES OF THE DNA-BINDING DOMAIN OF              
JRNL        TITL 2 ESCHERICHIA COLI PROLINE UTILIZATION A                       
JRNL        TITL 3 FLAVOPROTEIN AND ANALYSIS OF THE ROLE OF LYS9 IN             
JRNL        TITL 4 DNA RECOGNITION.                                             
JRNL        REF    PROTEIN SCI.                  V.  15  2630 2006              
JRNL        REFN   ASTM PRCIEI  US ISSN 0961-8368                               
REMARK   2 RESOLUTION. 2.10 ANGSTROMS.                                          
DBREF  2AY0 A    1    52  UNP    P09546   PUTA_ECOLI       1     52             
DBREF  2AY0 B    1    52  UNP    P09546   PUTA_ECOLI       1     52             
DBREF  2AY0 C    1    52  UNP    P09546   PUTA_ECOLI       1     52             
DBREF  2AY0 D    1    52  UNP    P09546   PUTA_ECOLI       1     52             
DBREF  2AY0 E    1    52  UNP    P09546   PUTA_ECOLI       1     52             
DBREF  2AY0 F    1    52  UNP    P09546   PUTA_ECOLI       1     52             
SEQRES   1 A   58  MET GLY THR THR THR MET GLY VAL MET LEU ASP ASP ALA          
SEQRES   2 A   58  THR ARG GLU ARG ILE LYS SER ALA ALA THR ARG ILE ASP          
SEQRES   3 A   58  ARG THR PRO HIS TRP LEU ILE LYS GLN ALA ILE PHE SER          
SEQRES   4 A   58  TYR LEU GLU GLN LEU GLU ASN SER ASP THR LEU PRO GLU          
SEQRES   5 A   58  HIS HIS HIS HIS HIS HIS                                      
SEQRES   1 B   58  MET GLY THR THR THR MET GLY VAL MET LEU ASP ASP ALA          
SEQRES   2 B   58  THR ARG GLU ARG ILE LYS SER ALA ALA THR ARG ILE ASP          
SEQRES   3 B   58  ARG THR PRO HIS TRP LEU ILE LYS GLN ALA ILE PHE SER          
SEQRES   4 B   58  TYR LEU GLU GLN LEU GLU ASN SER ASP THR LEU PRO GLU          
SEQRES   5 B   58  HIS HIS HIS HIS HIS HIS                                      
SEQRES   1 C   58  MET GLY THR THR THR MET GLY VAL MET LEU ASP ASP ALA          
SEQRES   2 C   58  THR ARG GLU ARG ILE LYS SER ALA ALA THR ARG ILE ASP          
SEQRES   3 C   58  ARG THR PRO HIS TRP LEU ILE LYS GLN ALA ILE PHE SER          
SEQRES   4 C   58  TYR LEU GLU GLN LEU GLU ASN SER ASP THR LEU PRO GLU          
SEQRES   5 C   58  HIS HIS HIS HIS HIS HIS                                      
SEQRES   1 D   58  MET GLY THR THR THR MET GLY VAL MET LEU ASP ASP ALA          
SEQRES   2 D   58  THR ARG GLU ARG ILE LYS SER ALA ALA THR ARG ILE ASP          
SEQRES   3 D   58  ARG THR PRO HIS TRP LEU ILE LYS GLN ALA ILE PHE SER          
SEQRES   4 D   58  TYR LEU GLU GLN LEU GLU ASN SER ASP THR LEU PRO GLU          
SEQRES   5 D   58  HIS HIS HIS HIS HIS HIS                                      
SEQRES   1 E   58  MET GLY THR THR THR MET GLY VAL MET LEU ASP ASP ALA          
SEQRES   2 E   58  THR ARG GLU ARG ILE LYS SER ALA ALA THR ARG ILE ASP          
SEQRES   3 E   58  ARG THR PRO HIS TRP LEU ILE LYS GLN ALA ILE PHE SER          
SEQRES   4 E   58  TYR LEU GLU GLN LEU GLU ASN SER ASP THR LEU PRO GLU          
SEQRES   5 E   58  HIS HIS HIS HIS HIS HIS                                      
SEQRES   1 F   58  MET GLY THR THR THR MET GLY VAL MET LEU ASP ASP ALA          
SEQRES   2 F   58  THR ARG GLU ARG ILE LYS SER ALA ALA THR ARG ILE ASP          
SEQRES   3 F   58  ARG THR PRO HIS TRP LEU ILE LYS GLN ALA ILE PHE SER          
SEQRES   4 F   58  TYR LEU GLU GLN LEU GLU ASN SER ASP THR LEU PRO GLU          
SEQRES   5 F   58  HIS HIS HIS HIS HIS HIS                                      
HET     CL      1       1                                                       
HET     CL      2       1                                                       
HET     CL      3       1                                                       
HET     CL      4       1                                                       
HET     CL      5       1                                                       
HET     CL      6       1                                                       
HETNAM      CL CHLORIDE ION                                                     
FORMUL   7   CL    6(CL 1-)                                                     
FORMUL  13  HOH   *67(H2 O)                                                     
CRYST1   72.070   91.494   69.606  90.00 119.21  90.00 C 1 2 1      24          
ATOM   1027  N   THR D   3     -15.589 -13.690   4.550  1.00 48.60           N  
ATOM   1028  CA  THR D   3     -14.240 -13.101   4.813  1.00 48.65           C  
ATOM   1029  C   THR D   3     -13.114 -13.933   4.180  1.00 48.32           C  
ATOM   1030  O   THR D   3     -13.159 -15.153   4.211  1.00 48.23           O  
ATOM   1031  CB  THR D   3     -13.977 -12.919   6.340  1.00 48.68           C  
ATOM   1032  OG1 THR D   3     -12.764 -12.180   6.540  1.00 49.49           O  
ATOM   1033  CG2 THR D   3     -13.860 -14.251   7.042  1.00 49.35           C  
ATOM   1034  N   THR D   4     -12.116 -13.267   3.597  1.00 48.06           N  
ATOM   1035  CA  THR D   4     -10.901 -13.950   3.124  1.00 47.71           C  
ATOM   1036  C   THR D   4      -9.697 -13.426   3.881  1.00 47.03           C  
ATOM   1037  O   THR D   4      -9.794 -12.425   4.575  1.00 46.69           O  
ATOM   1038  CB  THR D   4     -10.638 -13.774   1.593  1.00 47.81           C  
ATOM   1039  OG1 THR D   4     -10.358 -12.394   1.284  1.00 48.49           O  
ATOM   1040  CG2 THR D   4     -11.816 -14.290   0.770  1.00 47.96           C  
ATOM   1041  N   THR D   5      -8.565 -14.113   3.741  1.00 46.53           N  
ATOM   1042  CA  THR D   5      -7.295 -13.651   4.307  1.00 46.04           C  
ATOM   1043  C   THR D   5      -6.292 -13.411   3.181  1.00 45.21           C  
ATOM   1044  O   THR D   5      -5.943 -14.341   2.460  1.00 44.91           O  
ATOM   1045  CB  THR D   5      -6.717 -14.680   5.302  1.00 46.08           C  
ATOM   1046  OG1 THR D   5      -7.585 -14.782   6.431  1.00 46.28           O  
ATOM   1047  CG2 THR D   5      -5.332 -14.269   5.785  1.00 46.09           C  
ATOM   1048  N   MET D   6      -5.833 -12.172   3.016  1.00 44.21           N  
ATOM   1049  CA  MET D   6      -4.762 -11.936   2.063  1.00 43.74           C  
ATOM   1050  C   MET D   6      -3.450 -11.730   2.773  1.00 42.43           C  
ATOM   1051  O   MET D   6      -3.405 -11.549   3.977  1.00 41.97           O  
ATOM   1052  CB  MET D   6      -5.053 -10.833   1.023  1.00 43.95           C  
ATOM   1053  CG  MET D   6      -5.783  -9.566   1.414  1.00 44.22           C  
ATOM   1054  SD  MET D   6      -6.504  -8.811  -0.113  1.00 45.49           S  
ATOM   1055  CE  MET D   6      -5.122  -9.010  -1.254  1.00 43.45           C  
ATOM   1056  N   GLY D   7      -2.377 -11.840   2.006  1.00 41.22           N  
ATOM   1057  CA  GLY D   7      -1.048 -11.758   2.546  1.00 40.43           C  
ATOM   1058  C   GLY D   7      -0.548 -10.362   2.330  1.00 39.80           C  
ATOM   1059  O   GLY D   7      -0.777  -9.769   1.268  1.00 40.09           O  
ATOM   1060  N   VAL D   8       0.109  -9.830   3.352  1.00 38.94           N  
ATOM   1061  CA  VAL D   8       0.804  -8.551   3.260  1.00 38.78           C  
ATOM   1062  C   VAL D   8       2.279  -8.825   3.496  1.00 37.38           C  
ATOM   1063  O   VAL D   8       2.665  -9.327   4.549  1.00 36.84           O  
ATOM   1064  CB  VAL D   8       0.258  -7.551   4.272  1.00 38.73           C  
ATOM   1065  CG1 VAL D   8       0.931  -6.222   4.143  1.00 39.86           C  
ATOM   1066  CG2 VAL D   8      -1.202  -7.378   4.037  1.00 41.36           C  
ATOM   1067  N   MET D   9       3.093  -8.539   2.486  1.00 36.87           N  
ATOM   1068  CA  MET D   9       4.535  -8.675   2.612  1.00 34.89           C  
ATOM   1069  C   MET D   9       5.068  -7.436   3.326  1.00 36.48           C  
ATOM   1070  O   MET D   9       4.738  -6.301   2.975  1.00 36.38           O  
ATOM   1071  CB  MET D   9       5.185  -8.835   1.243  1.00 35.28           C  
ATOM   1072  CG  MET D   9       4.828 -10.166   0.567  1.00 34.26           C  
ATOM   1073  SD  MET D   9       5.490 -10.370  -1.070  1.00 26.21           S  
ATOM   1074  CE  MET D   9       7.105 -10.912  -0.622  1.00 29.23           C  
ATOM   1075  N   LEU D  10       5.877  -7.662   4.349  1.00 37.23           N  
ATOM   1076  CA  LEU D  10       6.399  -6.579   5.160  1.00 37.86           C  
ATOM   1077  C   LEU D  10       7.879  -6.734   5.302  1.00 38.26           C  
ATOM   1078  O   LEU D  10       8.344  -7.783   5.730  1.00 39.02           O  
ATOM   1079  CB  LEU D  10       5.776  -6.609   6.543  1.00 38.04           C  
ATOM   1080  CG  LEU D  10       4.306  -6.274   6.646  1.00 37.81           C  
ATOM   1081  CD1 LEU D  10       3.832  -6.543   8.061  1.00 37.93           C  
ATOM   1082  CD2 LEU D  10       4.071  -4.819   6.257  1.00 38.87           C  
ATOM   1083  N   ASP D  11       8.634  -5.699   4.952  1.00 39.01           N  
ATOM   1084  CA  ASP D  11      10.071  -5.744   5.227  1.00 39.54           C  
ATOM   1085  C   ASP D  11      10.265  -5.561   6.735  1.00 39.39           C  
ATOM   1086  O   ASP D  11       9.385  -5.050   7.424  1.00 38.93           O  
ATOM   1087  CB  ASP D  11      10.870  -4.760   4.352  1.00 40.23           C  
ATOM   1088  CG  ASP D  11      11.061  -3.397   4.984  1.00 41.55           C  
ATOM   1089  OD1 ASP D  11      10.258  -3.003   5.855  1.00 45.97           O  
ATOM   1090  OD2 ASP D  11      12.033  -2.712   4.595  1.00 43.50           O  
ATOM   1091  N   ASP D  12      11.401  -6.017   7.245  1.00 39.65           N  
ATOM   1092  CA  ASP D  12      11.618  -6.093   8.695  1.00 39.90           C  
ATOM   1093  C   ASP D  12      11.573  -4.734   9.391  1.00 39.71           C  
ATOM   1094  O   ASP D  12      11.039  -4.626  10.496  1.00 39.82           O  
ATOM   1095  CB  ASP D  12      12.927  -6.832   8.994  1.00 39.91           C  
ATOM   1096  CG  ASP D  12      12.865  -8.287   8.580  1.00 40.82           C  
ATOM   1097  OD1 ASP D  12      11.748  -8.762   8.259  1.00 42.05           O  
ATOM   1098  OD2 ASP D  12      13.917  -8.954   8.572  1.00 41.25           O  
ATOM   1099  N   ALA D  13      12.112  -3.707   8.738  1.00 39.42           N  
ATOM   1100  CA  ALA D  13      12.002  -2.339   9.238  1.00 39.48           C  
ATOM   1101  C   ALA D  13      10.542  -1.948   9.445  1.00 39.44           C  
ATOM   1102  O   ALA D  13      10.175  -1.451  10.510  1.00 39.11           O  
ATOM   1103  CB  ALA D  13      12.661  -1.369   8.286  1.00 39.53           C  
ATOM   1104  N   THR D  14       9.709  -2.184   8.429  1.00 39.62           N  
ATOM   1105  CA  THR D  14       8.299  -1.781   8.487  1.00 39.67           C  
ATOM   1106  C   THR D  14       7.529  -2.581   9.526  1.00 40.01           C  
ATOM   1107  O   THR D  14       6.704  -2.022  10.253  1.00 39.53           O  
ATOM   1108  CB  THR D  14       7.605  -1.927   7.099  1.00 39.83           C  
ATOM   1109  OG1 THR D  14       8.381  -1.257   6.095  1.00 39.39           O  
ATOM   1110  CG2 THR D  14       6.196  -1.357   7.138  1.00 39.04           C  
ATOM   1111  N   ARG D  15       7.799  -3.883   9.594  1.00 40.74           N  
ATOM   1112  CA  ARG D  15       7.192  -4.748  10.608  1.00 41.97           C  
ATOM   1113  C   ARG D  15       7.521  -4.323  12.049  1.00 42.08           C  
ATOM   1114  O   ARG D  15       6.648  -4.358  12.922  1.00 41.64           O  
ATOM   1115  CB  ARG D  15       7.603  -6.211  10.398  1.00 42.62           C  
ATOM   1116  CG  ARG D  15       6.910  -7.152  11.378  1.00 45.59           C  
ATOM   1117  CD  ARG D  15       6.568  -8.500  10.770  1.00 49.22           C  
ATOM   1118  NE  ARG D  15       5.828  -9.320  11.734  1.00 50.91           N  
ATOM   1119  CZ  ARG D  15       5.233 -10.484  11.458  1.00 52.01           C  
ATOM   1120  NH1 ARG D  15       5.264 -10.999  10.234  1.00 51.96           N  
ATOM   1121  NH2 ARG D  15       4.597 -11.140  12.426  1.00 52.80           N  
ATOM   1122  N   GLU D  16       8.777  -3.940  12.294  1.00 42.40           N  
ATOM   1123  CA  GLU D  16       9.187  -3.430  13.613  1.00 42.68           C  
ATOM   1124  C   GLU D  16       8.504  -2.101  13.954  1.00 42.45           C  
ATOM   1125  O   GLU D  16       8.248  -1.820  15.116  1.00 41.89           O  
ATOM   1126  CB  GLU D  16      10.702  -3.228  13.681  1.00 42.68           C  
ATOM   1127  CG  GLU D  16      11.539  -4.489  13.647  1.00 43.43           C  
ATOM   1128  CD  GLU D  16      13.028  -4.178  13.529  1.00 43.94           C  
ATOM   1129  OE1 GLU D  16      13.529  -3.401  14.371  1.00 46.34           O  
ATOM   1130  OE2 GLU D  16      13.706  -4.707  12.607  1.00 46.55           O  
ATOM   1131  N   ARG D  17       8.238  -1.282  12.939  1.00 42.84           N  
ATOM   1132  CA  ARG D  17       7.614   0.031  13.133  1.00 43.27           C  
ATOM   1133  C   ARG D  17       6.126  -0.116  13.417  1.00 42.42           C  
ATOM   1134  O   ARG D  17       5.551   0.617  14.232  1.00 41.71           O  
ATOM   1135  CB  ARG D  17       7.822   0.895  11.890  1.00 44.28           C  
ATOM   1136  CG  ARG D  17       7.508   2.375  12.087  1.00 47.40           C  
ATOM   1137  CD  ARG D  17       8.581   3.267  11.423  1.00 52.27           C  
ATOM   1138  NE  ARG D  17       8.145   3.790  10.128  1.00 54.26           N  
ATOM   1139  CZ  ARG D  17       7.265   4.781   9.968  1.00 55.14           C  
ATOM   1140  NH1 ARG D  17       6.689   5.369  11.025  1.00 55.06           N  
ATOM   1141  NH2 ARG D  17       6.949   5.181   8.737  1.00 55.33           N  
ATOM   1142  N   ILE D  18       5.507  -1.074  12.738  1.00 41.71           N  
ATOM   1143  CA  ILE D  18       4.137  -1.435  13.019  1.00 41.16           C  
ATOM   1144  C   ILE D  18       4.006  -1.928  14.470  1.00 41.38           C  
ATOM   1145  O   ILE D  18       3.146  -1.450  15.207  1.00 41.15           O  
ATOM   1146  CB  ILE D  18       3.626  -2.508  12.038  1.00 40.96           C  
ATOM   1147  CG1 ILE D  18       3.425  -1.893  10.642  1.00 40.39           C  
ATOM   1148  CG2 ILE D  18       2.323  -3.130  12.562  1.00 41.14           C  
ATOM   1149  CD1 ILE D  18       3.285  -2.910   9.525  1.00 40.34           C  
ATOM   1150  N   LYS D  19       4.873  -2.860  14.865  1.00 41.32           N  
ATOM   1151  CA  LYS D  19       4.824  -3.484  16.195  1.00 41.11           C  
ATOM   1152  C   LYS D  19       5.030  -2.455  17.319  1.00 41.18           C  
ATOM   1153  O   LYS D  19       4.362  -2.496  18.365  1.00 41.31           O  
ATOM   1154  CB  LYS D  19       5.886  -4.584  16.279  1.00 41.18           C  
ATOM   1155  CG  LYS D  19       5.904  -5.368  17.587  1.00 41.55           C  
ATOM   1156  N   SER D  20       5.952  -1.531  17.072  1.00 40.62           N  
ATOM   1157  CA  SER D  20       6.258  -0.447  17.985  1.00 40.27           C  
ATOM   1158  C   SER D  20       5.118   0.571  18.076  1.00 39.83           C  
ATOM   1159  O   SER D  20       4.730   0.984  19.182  1.00 39.35           O  
ATOM   1160  CB  SER D  20       7.551   0.246  17.533  1.00 40.38           C  
ATOM   1161  OG  SER D  20       7.599   1.578  17.998  1.00 41.35           O  
ATOM   1162  N   ALA D  21       4.596   0.979  16.919  1.00 39.38           N  
ATOM   1163  CA  ALA D  21       3.464   1.908  16.858  1.00 39.23           C  
ATOM   1164  C   ALA D  21       2.240   1.309  17.534  1.00 39.23           C  
ATOM   1165  O   ALA D  21       1.546   1.994  18.285  1.00 38.85           O  
ATOM   1166  CB  ALA D  21       3.139   2.275  15.427  1.00 39.25           C  
ATOM   1167  N   ALA D  22       1.984   0.028  17.277  1.00 39.21           N  
ATOM   1168  CA  ALA D  22       0.851  -0.663  17.895  1.00 39.24           C  
ATOM   1169  C   ALA D  22       0.996  -0.736  19.419  1.00 39.39           C  
ATOM   1170  O   ALA D  22       0.025  -0.517  20.143  1.00 39.49           O  
ATOM   1171  CB  ALA D  22       0.691  -2.049  17.312  1.00 39.13           C  
ATOM   1172  N   THR D  23       2.206  -1.031  19.889  1.00 39.79           N  
ATOM   1173  CA  THR D  23       2.505  -1.111  21.323  1.00 40.13           C  
ATOM   1174  C   THR D  23       2.335   0.261  21.987  1.00 40.53           C  
ATOM   1175  O   THR D  23       1.866   0.348  23.125  1.00 40.95           O  
ATOM   1176  CB  THR D  23       3.943  -1.663  21.571  1.00 40.15           C  
ATOM   1177  OG1 THR D  23       4.076  -2.961  20.984  1.00 40.15           O  
ATOM   1178  CG2 THR D  23       4.254  -1.775  23.042  1.00 40.44           C  
ATOM   1179  N   ARG D  24       2.700   1.323  21.271  1.00 40.82           N  
ATOM   1180  CA  ARG D  24       2.545   2.704  21.757  1.00 40.83           C  
ATOM   1181  C   ARG D  24       1.078   3.073  22.044  1.00 40.94           C  
ATOM   1182  O   ARG D  24       0.793   3.775  23.011  1.00 40.11           O  
ATOM   1183  CB  ARG D  24       3.125   3.691  20.736  1.00 40.91           C  
ATOM   1184  CG  ARG D  24       3.230   5.122  21.229  1.00 41.36           C  
ATOM   1185  N   ILE D  25       0.157   2.598  21.203  1.00 40.77           N  
ATOM   1186  CA  ILE D  25      -1.273   2.892  21.378  1.00 41.05           C  
ATOM   1187  C   ILE D  25      -2.060   1.751  22.053  1.00 41.01           C  
ATOM   1188  O   ILE D  25      -3.299   1.758  22.067  1.00 41.09           O  
ATOM   1189  CB  ILE D  25      -1.932   3.304  20.036  1.00 41.38           C  
ATOM   1190  CG1 ILE D  25      -1.922   2.158  19.035  1.00 40.96           C  
ATOM   1191  CG2 ILE D  25      -1.230   4.526  19.463  1.00 42.44           C  
ATOM   1192  CD1 ILE D  25      -2.348   2.553  17.607  1.00 41.91           C  
ATOM   1193  N   ASP D  26      -1.331   0.801  22.638  1.00 40.39           N  
ATOM   1194  CA  ASP D  26      -1.907  -0.350  23.337  1.00 40.00           C  
ATOM   1195  C   ASP D  26      -2.826  -1.195  22.443  1.00 38.87           C  
ATOM   1196  O   ASP D  26      -3.889  -1.642  22.867  1.00 38.30           O  
ATOM   1197  CB  ASP D  26      -2.639   0.099  24.607  1.00 40.57           C  
ATOM   1198  CG  ASP D  26      -2.901  -1.048  25.563  1.00 41.83           C  
ATOM   1199  OD1 ASP D  26      -2.224  -2.097  25.465  1.00 44.80           O  
ATOM   1200  OD2 ASP D  26      -3.805  -0.912  26.403  1.00 45.55           O  
ATOM   1201  N   ARG D  27      -2.382  -1.414  21.208  1.00 37.48           N  
ATOM   1202  CA  ARG D  27      -3.080  -2.256  20.250  1.00 37.35           C  
ATOM   1203  C   ARG D  27      -2.077  -3.249  19.621  1.00 37.49           C  
ATOM   1204  O   ARG D  27      -0.920  -3.333  20.043  1.00 37.82           O  
ATOM   1205  CB  ARG D  27      -3.761  -1.390  19.169  1.00 36.75           C  
ATOM   1206  CG  ARG D  27      -4.863  -0.473  19.665  1.00 35.46           C  
ATOM   1207  CD  ARG D  27      -6.052  -1.232  20.245  1.00 34.52           C  
ATOM   1208  NE  ARG D  27      -7.159  -0.350  20.629  1.00 33.69           N  
ATOM   1209  CZ  ARG D  27      -7.288   0.267  21.804  1.00 33.08           C  
ATOM   1210  NH1 ARG D  27      -8.338   1.048  22.022  1.00 34.04           N  
ATOM   1211  NH2 ARG D  27      -6.376   0.136  22.759  1.00 31.64           N  
ATOM   1212  N   THR D  28      -2.528  -4.009  18.631  1.00 37.66           N  
ATOM   1213  CA  THR D  28      -1.690  -5.015  17.988  1.00 37.31           C  
ATOM   1214  C   THR D  28      -1.457  -4.647  16.532  1.00 37.51           C  
ATOM   1215  O   THR D  28      -2.185  -3.826  15.990  1.00 37.21           O  
ATOM   1216  CB  THR D  28      -2.342  -6.418  18.067  1.00 37.30           C  
ATOM   1217  OG1 THR D  28      -3.579  -6.434  17.343  1.00 37.37           O  
ATOM   1218  CG2 THR D  28      -2.575  -6.839  19.532  1.00 36.04           C  
ATOM   1219  N   PRO D  29      -0.426  -5.244  15.892  1.00 38.00           N  
ATOM   1220  CA  PRO D  29      -0.210  -5.085  14.443  1.00 37.89           C  
ATOM   1221  C   PRO D  29      -1.442  -5.349  13.559  1.00 38.20           C  
ATOM   1222  O   PRO D  29      -1.731  -4.557  12.653  1.00 38.27           O  
ATOM   1223  CB  PRO D  29       0.910  -6.099  14.137  1.00 38.14           C  
ATOM   1224  CG  PRO D  29       1.672  -6.207  15.423  1.00 37.64           C  
ATOM   1225  CD  PRO D  29       0.648  -6.047  16.525  1.00 37.95           C  
ATOM   1226  N   HIS D  30      -2.158  -6.442  13.823  1.00 38.32           N  
ATOM   1227  CA  HIS D  30      -3.363  -6.770  13.066  1.00 37.64           C  
ATOM   1228  C   HIS D  30      -4.398  -5.650  13.216  1.00 37.34           C  
ATOM   1229  O   HIS D  30      -5.023  -5.270  12.248  1.00 37.49           O  
ATOM   1230  CB  HIS D  30      -3.942  -8.123  13.495  1.00 37.66           C  
ATOM   1231  CG  HIS D  30      -3.208  -9.314  12.934  1.00 38.86           C  
ATOM   1232  ND1 HIS D  30      -2.791 -10.370  13.718  1.00 39.71           N  
ATOM   1233  CD2 HIS D  30      -2.827  -9.618  11.673  1.00 38.49           C  
ATOM   1234  CE1 HIS D  30      -2.178 -11.265  12.963  1.00 39.57           C  
ATOM   1235  NE2 HIS D  30      -2.188 -10.833  11.717  1.00 39.08           N  
ATOM   1236  N   TRP D  31      -4.554  -5.110  14.426  1.00 36.95           N  
ATOM   1237  CA  TRP D  31      -5.449  -3.970  14.662  1.00 36.86           C  
ATOM   1238  C   TRP D  31      -5.028  -2.809  13.751  1.00 37.41           C  
ATOM   1239  O   TRP D  31      -5.849  -2.224  13.042  1.00 36.55           O  
ATOM   1240  CB  TRP D  31      -5.430  -3.551  16.151  1.00 36.43           C  
ATOM   1241  CG  TRP D  31      -6.418  -2.462  16.512  1.00 36.07           C  
ATOM   1242  CD1 TRP D  31      -7.680  -2.629  16.965  1.00 34.66           C  
ATOM   1243  CD2 TRP D  31      -6.216  -1.044  16.397  1.00 35.35           C  
ATOM   1244  NE1 TRP D  31      -8.283  -1.410  17.161  1.00 35.53           N  
ATOM   1245  CE2 TRP D  31      -7.401  -0.420  16.809  1.00 35.64           C  
ATOM   1246  CE3 TRP D  31      -5.137  -0.246  15.989  1.00 35.66           C  
ATOM   1247  CZ2 TRP D  31      -7.547   0.972  16.829  1.00 35.32           C  
ATOM   1248  CZ3 TRP D  31      -5.282   1.126  16.011  1.00 35.40           C  
ATOM   1249  CH2 TRP D  31      -6.481   1.722  16.430  1.00 35.69           C  
ATOM   1250  N   LEU D  32      -3.736  -2.503  13.774  1.00 38.44           N  
ATOM   1251  CA  LEU D  32      -3.184  -1.346  13.082  1.00 38.79           C  
ATOM   1252  C   LEU D  32      -3.349  -1.473  11.567  1.00 39.32           C  
ATOM   1253  O   LEU D  32      -3.694  -0.504  10.889  1.00 38.85           O  
ATOM   1254  CB  LEU D  32      -1.706  -1.190  13.454  1.00 38.89           C  
ATOM   1255  CG  LEU D  32      -0.944   0.030  12.932  1.00 40.02           C  
ATOM   1256  CD1 LEU D  32       0.245   0.318  13.845  1.00 41.38           C  
ATOM   1257  CD2 LEU D  32      -0.476  -0.149  11.453  1.00 41.78           C  
ATOM   1258  N   ILE D  33      -3.122  -2.671  11.038  1.00 39.50           N  
ATOM   1259  CA  ILE D  33      -3.263  -2.874   9.606  1.00 40.57           C  
ATOM   1260  C   ILE D  33      -4.701  -2.670   9.146  1.00 39.75           C  
ATOM   1261  O   ILE D  33      -4.945  -2.030   8.124  1.00 39.54           O  
ATOM   1262  CB  ILE D  33      -2.719  -4.246   9.179  1.00 41.16           C  
ATOM   1263  CG1 ILE D  33      -1.191  -4.216   9.317  1.00 42.70           C  
ATOM   1264  CG2 ILE D  33      -3.131  -4.580   7.722  1.00 41.47           C  
ATOM   1265  CD1 ILE D  33      -0.550  -5.517   9.013  1.00 45.26           C  
ATOM   1266  N   LYS D  34      -5.658  -3.187   9.896  1.00 39.46           N  
ATOM   1267  CA  LYS D  34      -7.053  -2.978   9.526  1.00 39.18           C  
ATOM   1268  C   LYS D  34      -7.415  -1.507   9.611  1.00 39.10           C  
ATOM   1269  O   LYS D  34      -8.051  -0.956   8.710  1.00 39.04           O  
ATOM   1270  CB  LYS D  34      -7.981  -3.837  10.382  1.00 39.40           C  
ATOM   1271  CG  LYS D  34      -7.821  -5.340  10.120  1.00 39.67           C  
ATOM   1272  CD  LYS D  34      -7.919  -5.705   8.629  1.00 40.42           C  
ATOM   1273  CE  LYS D  34      -9.299  -5.412   8.032  1.00 40.56           C  
ATOM   1274  NZ  LYS D  34     -10.359  -6.269   8.642  1.00 40.25           N  
ATOM   1275  N   GLN D  35      -6.969  -0.860  10.678  1.00 38.69           N  
ATOM   1276  CA  GLN D  35      -7.223   0.561  10.852  1.00 38.50           C  
ATOM   1277  C   GLN D  35      -6.695   1.354   9.659  1.00 37.43           C  
ATOM   1278  O   GLN D  35      -7.401   2.202   9.090  1.00 36.39           O  
ATOM   1279  CB  GLN D  35      -6.588   1.025  12.163  1.00 38.80           C  
ATOM   1280  CG  GLN D  35      -7.238   2.205  12.772  1.00 43.31           C  
ATOM   1281  CD  GLN D  35      -8.695   1.957  13.161  1.00 46.18           C  
ATOM   1282  OE1 GLN D  35      -9.084   0.875  13.657  1.00 47.12           O  
ATOM   1283  NE2 GLN D  35      -9.512   2.948  12.893  1.00 48.92           N  
ATOM   1284  N   ALA D  36      -5.465   1.043   9.251  1.00 36.54           N  
ATOM   1285  CA  ALA D  36      -4.846   1.687   8.091  1.00 36.04           C  
ATOM   1286  C   ALA D  36      -5.695   1.535   6.830  1.00 35.41           C  
ATOM   1287  O   ALA D  36      -5.947   2.508   6.092  1.00 34.01           O  
ATOM   1288  CB  ALA D  36      -3.423   1.139   7.874  1.00 35.79           C  
ATOM   1289  N   ILE D  37      -6.134   0.308   6.579  1.00 35.25           N  
ATOM   1290  CA  ILE D  37      -6.889  -0.004   5.376  1.00 35.33           C  
ATOM   1291  C   ILE D  37      -8.208   0.756   5.365  1.00 36.12           C  
ATOM   1292  O   ILE D  37      -8.584   1.381   4.363  1.00 34.69           O  
ATOM   1293  CB  ILE D  37      -7.163  -1.532   5.262  1.00 35.19           C  
ATOM   1294  CG1 ILE D  37      -5.859  -2.274   4.944  1.00 35.95           C  
ATOM   1295  CG2 ILE D  37      -8.189  -1.804   4.181  1.00 35.63           C  
ATOM   1296  CD1 ILE D  37      -5.911  -3.767   5.133  1.00 35.88           C  
ATOM   1297  N   PHE D  38      -8.923   0.688   6.487  1.00 37.58           N  
ATOM   1298  CA  PHE D  38     -10.232   1.328   6.561  1.00 38.90           C  
ATOM   1299  C   PHE D  38     -10.155   2.829   6.433  1.00 38.34           C  
ATOM   1300  O   PHE D  38     -10.905   3.435   5.663  1.00 37.43           O  
ATOM   1301  CB  PHE D  38     -10.963   0.925   7.829  1.00 40.65           C  
ATOM   1302  CG  PHE D  38     -11.723  -0.326   7.656  1.00 42.30           C  
ATOM   1303  CD1 PHE D  38     -11.283  -1.503   8.235  1.00 45.42           C  
ATOM   1304  CD2 PHE D  38     -12.846  -0.344   6.825  1.00 45.09           C  
ATOM   1305  CE1 PHE D  38     -11.971  -2.679   8.047  1.00 46.06           C  
ATOM   1306  CE2 PHE D  38     -13.549  -1.507   6.613  1.00 45.99           C  
ATOM   1307  CZ  PHE D  38     -13.117  -2.694   7.230  1.00 46.10           C  
ATOM   1308  N   SER D  39      -9.217   3.418   7.156  1.00 38.45           N  
ATOM   1309  CA  SER D  39      -9.056   4.866   7.125  1.00 39.22           C  
ATOM   1310  C   SER D  39      -8.632   5.346   5.719  1.00 38.55           C  
ATOM   1311  O   SER D  39      -9.140   6.349   5.211  1.00 38.94           O  
ATOM   1312  CB  SER D  39      -8.089   5.326   8.230  1.00 39.02           C  
ATOM   1313  OG  SER D  39      -6.797   4.807   8.006  1.00 42.12           O  
ATOM   1314  N   TYR D  40      -7.739   4.609   5.075  1.00 37.99           N  
ATOM   1315  CA  TYR D  40      -7.324   4.939   3.712  1.00 37.90           C  
ATOM   1316  C   TYR D  40      -8.471   4.838   2.686  1.00 37.20           C  
ATOM   1317  O   TYR D  40      -8.582   5.677   1.795  1.00 36.48           O  
ATOM   1318  CB  TYR D  40      -6.127   4.065   3.328  1.00 38.85           C  
ATOM   1319  CG  TYR D  40      -5.586   4.296   1.941  1.00 40.32           C  
ATOM   1320  CD1 TYR D  40      -4.810   5.412   1.645  1.00 41.25           C  
ATOM   1321  CD2 TYR D  40      -5.849   3.393   0.926  1.00 41.82           C  
ATOM   1322  CE1 TYR D  40      -4.318   5.627   0.361  1.00 41.14           C  
ATOM   1323  CE2 TYR D  40      -5.353   3.591  -0.350  1.00 43.75           C  
ATOM   1324  CZ  TYR D  40      -4.594   4.696  -0.633  1.00 41.78           C  
ATOM   1325  OH  TYR D  40      -4.132   4.829  -1.923  1.00 42.26           O  
ATOM   1326  N   LEU D  41      -9.328   3.823   2.811  1.00 37.07           N  
ATOM   1327  CA  LEU D  41     -10.476   3.678   1.898  1.00 37.45           C  
ATOM   1328  C   LEU D  41     -11.467   4.829   2.058  1.00 37.72           C  
ATOM   1329  O   LEU D  41     -11.968   5.365   1.071  1.00 37.13           O  
ATOM   1330  CB  LEU D  41     -11.199   2.353   2.129  1.00 37.44           C  
ATOM   1331  CG  LEU D  41     -10.496   1.071   1.671  1.00 37.84           C  
ATOM   1332  CD1 LEU D  41     -11.282  -0.138   2.197  1.00 37.60           C  
ATOM   1333  CD2 LEU D  41     -10.364   1.043   0.149  1.00 38.56           C  
ATOM   1334  N   GLU D  42     -11.753   5.194   3.307  1.00 38.50           N  
ATOM   1335  CA  GLU D  42     -12.586   6.355   3.609  1.00 39.81           C  
ATOM   1336  C   GLU D  42     -12.025   7.649   3.032  1.00 40.29           C  
ATOM   1337  O   GLU D  42     -12.730   8.387   2.356  1.00 40.01           O  
ATOM   1338  CB  GLU D  42     -12.719   6.513   5.113  1.00 39.77           C  
ATOM   1339  CG  GLU D  42     -13.614   5.483   5.733  1.00 41.08           C  
ATOM   1340  CD  GLU D  42     -13.783   5.708   7.216  1.00 41.27           C  
ATOM   1341  OE1 GLU D  42     -12.803   6.144   7.857  1.00 41.60           O  
ATOM   1342  OE2 GLU D  42     -14.897   5.460   7.719  1.00 43.88           O  
ATOM   1343  N   GLN D  43     -10.754   7.906   3.329  1.00 41.67           N  
ATOM   1344  CA  GLN D  43      -9.991   9.018   2.761  1.00 42.39           C  
ATOM   1345  C   GLN D  43     -10.149   9.090   1.229  1.00 42.58           C  
ATOM   1346  O   GLN D  43     -10.486  10.138   0.681  1.00 42.33           O  
ATOM   1347  CB  GLN D  43      -8.512   8.866   3.177  1.00 42.35           C  
ATOM   1348  CG  GLN D  43      -7.490   9.743   2.448  1.00 43.26           C  
ATOM   1349  CD  GLN D  43      -6.051   9.569   2.980  1.00 44.20           C  
ATOM   1350  OE1 GLN D  43      -5.640   8.474   3.388  1.00 48.48           O  
ATOM   1351  NE2 GLN D  43      -5.285  10.658   2.967  1.00 46.22           N  
ATOM   1352  N   LEU D  44      -9.924   7.964   0.555  1.00 43.41           N  
ATOM   1353  CA  LEU D  44     -10.033   7.895  -0.903  1.00 44.19           C  
ATOM   1354  C   LEU D  44     -11.447   8.218  -1.355  1.00 44.79           C  
ATOM   1355  O   LEU D  44     -11.648   9.089  -2.185  1.00 44.74           O  
ATOM   1356  CB  LEU D  44      -9.646   6.508  -1.421  1.00 44.22           C  
ATOM   1357  CG  LEU D  44      -8.165   6.142  -1.464  1.00 44.89           C  
ATOM   1358  CD1 LEU D  44      -8.026   4.658  -1.794  1.00 45.49           C  
ATOM   1359  CD2 LEU D  44      -7.419   6.998  -2.488  1.00 45.60           C  
ATOM   1360  N   GLU D  45     -12.415   7.499  -0.803  1.00 45.84           N  
ATOM   1361  CA  GLU D  45     -13.829   7.767  -1.067  1.00 46.64           C  
ATOM   1362  C   GLU D  45     -14.187   9.239  -0.834  1.00 47.10           C  
ATOM   1363  O   GLU D  45     -14.832   9.856  -1.684  1.00 47.13           O  
ATOM   1364  CB  GLU D  45     -14.719   6.837  -0.222  1.00 46.76           C  
ATOM   1365  CG  GLU D  45     -14.912   5.445  -0.853  1.00 47.66           C  
ATOM   1366  CD  GLU D  45     -14.737   4.289   0.132  1.00 49.26           C  
ATOM   1367  OE1 GLU D  45     -14.093   3.283  -0.251  1.00 48.78           O  
ATOM   1368  OE2 GLU D  45     -15.242   4.383   1.278  1.00 50.57           O  
ATOM   1369  N   ASN D  46     -13.748   9.799   0.295  1.00 47.70           N  
ATOM   1370  CA  ASN D  46     -14.025  11.209   0.623  1.00 48.07           C  
ATOM   1371  C   ASN D  46     -13.474  12.177  -0.425  1.00 48.28           C  
ATOM   1372  O   ASN D  46     -14.111  13.180  -0.727  1.00 48.48           O  
ATOM   1373  CB  ASN D  46     -13.473  11.579   2.010  1.00 48.18           C  
ATOM   1374  CG  ASN D  46     -14.182  10.844   3.150  1.00 49.14           C  
ATOM   1375  OD1 ASN D  46     -15.222  10.221   2.946  1.00 49.95           O  
ATOM   1376  ND2 ASN D  46     -13.608  10.903   4.352  1.00 49.84           N  
ATOM   1377  N   SER D  47     -12.300  11.872  -0.975  1.00 48.49           N  
ATOM   1378  CA  SER D  47     -11.691  12.706  -2.020  1.00 48.72           C  
ATOM   1379  C   SER D  47     -12.142  12.266  -3.411  1.00 48.61           C  
ATOM   1380  O   SER D  47     -13.212  12.652  -3.873  1.00 48.68           O  
ATOM   1381  CB  SER D  47     -10.161  12.661  -1.934  1.00 48.72           C  
ATOM   1382  OG  SER D  47      -9.622  11.578  -2.677  1.00 49.23           O  
TER    1383      SER D  47                                                      
END
MOLECULE T0474.pdb
ATOM    111  N   MET     9     -15.513 -13.396   6.798  1.00  1.00
ATOM    112  HN  MET     9     -15.434 -14.281   7.279  1.00  0.00
ATOM    113  CA  MET     9     -14.325 -12.543   6.707  1.00  1.00
ATOM    114  HA  MET     9     -14.565 -11.671   6.099  1.00  0.00
ATOM    115  CB  MET     9     -13.908 -12.081   8.105  1.00  1.00
ATOM    116 2HB  MET     9     -13.830 -12.945   8.766  1.00  0.00
ATOM    117 3HB  MET     9     -12.943 -11.578   8.049  1.00  0.00
ATOM    118  CG  MET     9     -14.958 -11.112   8.652  1.00  1.00
ATOM    119 2HG  MET     9     -15.026 -10.238   8.004  1.00  0.00
ATOM    120 3HG  MET     9     -15.932 -11.601   8.683  1.00  0.00
ATOM    121  SD  MET     9     -14.493 -10.590  10.321  1.00  1.00
ATOM    122  CE  MET     9     -13.435  -9.204   9.838  1.00  1.00
ATOM    123 1HE  MET     9     -13.039  -8.735  10.739  1.00  0.00
ATOM    124 2HE  MET     9     -12.614  -9.570   9.222  1.00  0.00
ATOM    125 3HE  MET     9     -14.020  -8.479   9.272  1.00  0.00
ATOM    126  C   MET     9     -13.176 -13.302   6.057  1.00  1.00
ATOM    127  O   MET     9     -12.801 -14.387   6.505  1.00  1.00
ATOM    128  N   GLY    10     -12.622 -12.725   4.996  1.00  1.00
ATOM    129  HN  GLY    10     -12.966 -11.834   4.669  1.00  0.00
ATOM    130  CA  GLY    10     -11.516 -13.351   4.281  1.00  1.00
ATOM    131 1HA  GLY    10     -11.622 -14.435   4.333  1.00  0.00
ATOM    132 2HA  GLY    10     -11.539 -13.037   3.238  1.00  0.00
ATOM    133  C   GLY    10     -10.188 -12.947   4.897  1.00  1.00
ATOM    134  O   GLY    10     -10.149 -12.229   5.897  1.00  1.00
ATOM    135  N   ARG    11      -9.096 -13.412   4.297  1.00  1.00
ATOM    136  HN  ARG    11      -9.181 -14.000   3.480  1.00  0.00
ATOM    137  CA  ARG    11      -7.763 -13.096   4.791  1.00  1.00
ATOM    138  HA  ARG    11      -7.806 -12.157   5.342  1.00  0.00
ATOM    139  CB  ARG    11      -7.286 -14.202   5.726  1.00  1.00
ATOM    140 2HB  ARG    11      -6.291 -13.959   6.097  1.00  0.00
ATOM    141 3HB  ARG    11      -7.976 -14.289   6.566  1.00  0.00
ATOM    142  CG  ARG    11      -7.236 -15.532   4.970  1.00  1.00
ATOM    143 2HG  ARG    11      -8.221 -15.755   4.560  1.00  0.00
ATOM    144 3HG  ARG    11      -6.512 -15.462   4.158  1.00  0.00
ATOM    145  CD  ARG    11      -6.820 -16.647   5.930  1.00  1.00
ATOM    146 2HD  ARG    11      -5.842 -16.415   6.352  1.00  0.00
ATOM    147 3HD  ARG    11      -7.550 -16.721   6.737  1.00  0.00
ATOM    148  NE  ARG    11      -6.752 -17.919   5.222  1.00  1.00
ATOM    149  HE  ARG    11      -6.699 -17.908   4.213  1.00  0.00
ATOM    150  CZ  ARG    11      -6.759 -19.073   5.880  1.00  1.00
ATOM    151  NH1 ARG    11      -6.698 -20.199   5.223  1.00  1.00
ATOM    152 1HH1 ARG    11      -6.704 -21.076   5.725  1.00  0.00
ATOM    153 2HH1 ARG    11      -6.645 -20.194   4.214  1.00  0.00
ATOM    154  NH2 ARG    11      -6.828 -19.081   7.183  1.00  1.00
ATOM    155 1HH2 ARG    11      -6.834 -19.960   7.681  1.00  0.00
ATOM    156 2HH2 ARG    11      -6.876 -18.210   7.692  1.00  0.00
ATOM    157  C   ARG    11      -6.786 -12.948   3.631  1.00  1.00
ATOM    158  O   ARG    11      -6.886 -13.656   2.628  1.00  1.00
ATOM    159  N   ILE    12      -5.838 -12.024   3.774  1.00  1.00
ATOM    160  HN  ILE    12      -5.799 -11.470   4.618  1.00  0.00
ATOM    161  CA  ILE    12      -4.836 -11.783   2.734  1.00  1.00
ATOM    162  HA  ILE    12      -4.856 -12.613   2.027  1.00  0.00
ATOM    163  CB  ILE    12      -5.149 -10.485   1.993  1.00  1.00
ATOM    164  HB  ILE    12      -5.211  -9.665   2.708  1.00  0.00
ATOM    165  CG2 ILE    12      -4.041 -10.193   0.977  1.00  1.00
ATOM    166 1HG2 ILE    12      -4.265  -9.266   0.450  1.00  0.00
ATOM    167 2HG2 ILE    12      -3.089 -10.095   1.497  1.00  0.00
ATOM    168 3HG2 ILE    12      -3.981 -11.012   0.260  1.00  0.00
ATOM    169  CG1 ILE    12      -6.487 -10.626   1.261  1.00  1.00
ATOM    170 2HG1 ILE    12      -6.369 -11.306   0.417  1.00  0.00
ATOM    171 3HG1 ILE    12      -7.235 -11.025   1.946  1.00  0.00
ATOM    172  CD1 ILE    12      -6.941  -9.258   0.753  1.00  1.00
ATOM    173 1HD1 ILE    12      -7.893  -9.361   0.231  1.00  0.00
ATOM    174 2HD1 ILE    12      -7.061  -8.579   1.597  1.00  0.00
ATOM    175 3HD1 ILE    12      -6.193  -8.859   0.068  1.00  0.00
ATOM    176  C   ILE    12      -3.449 -11.685   3.354  1.00  1.00
ATOM    177  O   ILE    12      -3.297 -11.280   4.502  1.00  1.00
ATOM    178  N   LEU    13      -2.441 -12.058   2.581  1.00  1.00
ATOM    179  HN  LEU    13      -2.622 -12.381   1.641  1.00  0.00
ATOM    180  CA  LEU    13      -1.058 -12.018   3.047  1.00  1.00
ATOM    181  HA  LEU    13      -1.049 -12.131   4.131  1.00  0.00
ATOM    182  CB  LEU    13      -0.268 -13.170   2.414  1.00  1.00
ATOM    183 2HB  LEU    13      -0.546 -13.261   1.364  1.00  0.00
ATOM    184 3HB  LEU    13       0.798 -12.958   2.491  1.00  0.00
ATOM    185  CG  LEU    13      -0.573 -14.493   3.133  1.00  1.00
ATOM    186  HG  LEU    13      -1.612 -14.492   3.464  1.00  0.00
ATOM    187  CD1 LEU    13      -0.343 -15.669   2.177  1.00  1.00
ATOM    188 1HD1 LEU    13      -0.564 -16.606   2.689  1.00  0.00
ATOM    189 2HD1 LEU    13      -0.998 -15.567   1.311  1.00  0.00
ATOM    190 3HD1 LEU    13       0.696 -15.672   1.848  1.00  0.00
ATOM    191  CD2 LEU    13       0.352 -14.655   4.350  1.00  1.00
ATOM    192 1HD2 LEU    13       0.128 -15.594   4.858  1.00  0.00
ATOM    193 2HD2 LEU    13       1.390 -14.661   4.018  1.00  0.00
ATOM    194 3HD2 LEU    13       0.195 -13.825   5.038  1.00  0.00
ATOM    195  C   LEU    13      -0.412 -10.701   2.682  1.00  1.00
ATOM    196  O   LEU    13      -0.703 -10.115   1.639  1.00  1.00
ATOM    197  N   LEU    14       0.467 -10.241   3.563  1.00  1.00
ATOM    198  HN  LEU    14       0.663 -10.769   4.402  1.00  0.00
ATOM    199  CA  LEU    14       1.169  -8.980   3.354  1.00  1.00
ATOM    200  HA  LEU    14       0.935  -8.615   2.354  1.00  0.00
ATOM    201  CB  LEU    14       0.683  -7.948   4.388  1.00  1.00
ATOM    202 2HB  LEU    14       0.127  -8.462   5.173  1.00  0.00
ATOM    203 3HB  LEU    14       1.545  -7.444   4.824  1.00  0.00
ATOM    204  CG  LEU    14      -0.224  -6.911   3.726  1.00  1.00
ATOM    205  HG  LEU    14      -0.583  -6.216   4.485  1.00  0.00
ATOM    206  CD1 LEU    14       0.576  -6.113   2.661  1.00  1.00
ATOM    207 1HD1 LEU    14      -0.074  -5.370   2.199  1.00  0.00
ATOM    208 2HD1 LEU    14       1.417  -5.612   3.139  1.00  0.00
ATOM    209 3HD1 LEU    14       0.946  -6.797   1.897  1.00  0.00
ATOM    210  CD2 LEU    14      -1.438  -7.627   3.095  1.00  1.00
ATOM    211 1HD2 LEU    14      -2.095  -6.890   2.633  1.00  0.00
ATOM    212 2HD2 LEU    14      -1.092  -8.331   2.337  1.00  0.00
ATOM    213 3HD2 LEU    14      -1.985  -8.167   3.869  1.00  0.00
ATOM    214  C   LEU    14       2.679  -9.170   3.464  1.00  1.00
ATOM    215  O   LEU    14       3.182  -9.797   4.399  1.00  1.00
ATOM    216  N   ASP    15       3.393  -8.610   2.493  1.00  1.00
ATOM    217  HN  ASP    15       2.926  -8.109   1.751  1.00  0.00
ATOM    218  CA  ASP    15       4.851  -8.698   2.462  1.00  1.00
ATOM    219  HA  ASP    15       5.173  -9.440   3.193  1.00  0.00
ATOM    220  CB  ASP    15       5.315  -9.130   1.075  1.00  1.00
ATOM    221 2HB  ASP    15       4.890  -8.463   0.325  1.00  0.00
ATOM    222 3HB  ASP    15       6.402  -9.082   1.024  1.00  0.00
ATOM    223  CG  ASP    15       4.857 -10.559   0.802  1.00  1.00
ATOM    224  OD1 ASP    15       4.446 -11.217   1.744  1.00  1.00
ATOM    225  OD2 ASP    15       4.921 -10.972  -0.343  1.00  1.00
ATOM    226 2HD  ASP    15       4.616 -11.877  -0.440  1.00  0.00
ATOM    227  C   ASP    15       5.475  -7.350   2.811  1.00  1.00
ATOM    228  O   ASP    15       5.377  -6.390   2.043  1.00  1.00
ATOM    229  N   LEU    16       6.122  -7.285   3.974  1.00  1.00
ATOM    230  HN  LEU    16       6.173  -8.102   4.566  1.00  0.00
ATOM    231  CA  LEU    16       6.771  -6.053   4.430  1.00  1.00
ATOM    232  HA  LEU    16       6.836  -5.363   3.589  1.00  0.00
ATOM    233  CB  LEU    16       5.942  -5.405   5.542  1.00  1.00
ATOM    234 2HB  LEU    16       5.703  -6.152   6.299  1.00  0.00
ATOM    235 3HB  LEU    16       6.514  -4.597   5.997  1.00  0.00
ATOM    236  CG  LEU    16       4.641  -4.842   4.951  1.00  1.00
ATOM    237  HG  LEU    16       4.182  -5.600   4.316  1.00  0.00
ATOM    238  CD1 LEU    16       3.679  -4.488   6.091  1.00  1.00
ATOM    239 1HD1 LEU    16       2.748  -4.100   5.676  1.00  0.00
ATOM    240 2HD1 LEU    16       3.469  -5.382   6.679  1.00  0.00
ATOM    241 3HD1 LEU    16       4.135  -3.732   6.729  1.00  0.00
ATOM    242  CD2 LEU    16       4.924  -3.580   4.103  1.00  1.00
ATOM    243 1HD2 LEU    16       3.991  -3.197   3.688  1.00  0.00
ATOM    244 2HD2 LEU    16       5.380  -2.816   4.732  1.00  0.00
ATOM    245 3HD2 LEU    16       5.603  -3.835   3.290  1.00  0.00
ATOM    246  C   LEU    16       8.175  -6.345   4.937  1.00  1.00
ATOM    247  O   LEU    16       8.442  -7.414   5.487  1.00  1.00
ATOM    248  N   SER    17       9.070  -5.384   4.746  1.00  1.00
ATOM    249  HN  SER    17       8.799  -4.524   4.291  1.00  0.00
ATOM    250  CA  SER    17      10.447  -5.538   5.181  1.00  1.00
ATOM    251  HA  SER    17      10.846  -6.462   4.762  1.00  0.00
ATOM    252  CB  SER    17      11.284  -4.360   4.677  1.00  1.00
ATOM    253 2HB  SER    17      10.709  -3.439   4.771  1.00  0.00
ATOM    254 3HB  SER    17      12.196  -4.282   5.269  1.00  0.00
ATOM    255  OG  SER    17      11.621  -4.572   3.312  1.00  1.00
ATOM    256  HG  SER    17      12.145  -3.827   3.009  1.00  0.00
ATOM    257  C   SER    17      10.515  -5.614   6.703  1.00  1.00
ATOM    258  O   SER    17       9.580  -5.216   7.397  1.00  1.00
ATOM    259  N   ASN    18      11.626  -6.130   7.212  1.00  1.00
ATOM    260  HN  ASN    18      12.366  -6.443   6.600  1.00  0.00
ATOM    261  CA  ASN    18      11.809  -6.259   8.652  1.00  1.00
ATOM    262  HA  ASN    18      10.994  -6.860   9.056  1.00  0.00
ATOM    263  CB  ASN    18      13.138  -6.955   8.951  1.00  1.00
ATOM    264 2HB  ASN    18      13.934  -6.476   8.382  1.00  0.00
ATOM    265 3HB  ASN    18      13.359  -6.873  10.015  1.00  0.00
ATOM    266  CG  ASN    18      13.053  -8.428   8.564  1.00  1.00
ATOM    267  OD1 ASN    18      12.406  -9.215   9.254  1.00  1.00
ATOM    268  ND2 ASN    18      13.669  -8.848   7.493  1.00  1.00
ATOM    269 1HD2 ASN    18      14.192  -8.183   6.941  1.00  0.00
ATOM    270 2HD2 ASN    18      13.620  -9.821   7.224  1.00  0.00
ATOM    271  C   ASN    18      11.791  -4.887   9.318  1.00  1.00
ATOM    272  O   ASN    18      11.239  -4.722  10.405  1.00  1.00
ATOM    273  N   GLU    19      12.397  -3.906   8.659  1.00  1.00
ATOM    274  HN  GLU    19      12.835  -4.089   7.767  1.00  0.00
ATOM    275  CA  GLU    19      12.445  -2.553   9.199  1.00  1.00
ATOM    276  HA  GLU    19      13.001  -2.571  10.137  1.00  0.00
ATOM    277  CB  GLU    19      13.159  -1.622   8.213  1.00  1.00
ATOM    278 2HB  GLU    19      12.722  -1.743   7.222  1.00  0.00
ATOM    279 3HB  GLU    19      13.039  -0.589   8.540  1.00  0.00
ATOM    280  CG  GLU    19      14.651  -1.968   8.157  1.00  1.00
ATOM    281 2HG  GLU    19      15.188  -1.170   7.646  1.00  0.00
ATOM    282 3HG  GLU    19      15.037  -2.068   9.171  1.00  0.00
ATOM    283  CD  GLU    19      14.860  -3.279   7.406  1.00  1.00
ATOM    284  OE1 GLU    19      13.967  -3.667   6.671  1.00  1.00
ATOM    285  OE2 GLU    19      15.911  -3.875   7.576  1.00  1.00
ATOM    286 2HE  GLU    19      15.974  -4.690   7.073  1.00  0.00
ATOM    287  C   GLU    19      11.035  -2.034   9.467  1.00  1.00
ATOM    288  O   GLU    19      10.807  -1.306  10.431  1.00  1.00
ATOM    289  N   VAL    20      10.092  -2.422   8.618  1.00  1.00
ATOM    290  HN  VAL    20      10.326  -3.021   7.839  1.00  0.00
ATOM    291  CA  VAL    20       8.705  -1.999   8.784  1.00  1.00
ATOM    292  HA  VAL    20       8.680  -0.915   8.890  1.00  0.00
ATOM    293  CB  VAL    20       7.890  -2.400   7.552  1.00  1.00
ATOM    294  HB  VAL    20       8.005  -3.470   7.375  1.00  0.00
ATOM    295  CG1 VAL    20       6.412  -2.082   7.784  1.00  1.00
ATOM    296 1HG1 VAL    20       5.835  -2.371   6.906  1.00  0.00
ATOM    297 2HG1 VAL    20       6.053  -2.636   8.652  1.00  0.00
ATOM    298 3HG1 VAL    20       6.294  -1.013   7.961  1.00  0.00
ATOM    299  CG2 VAL    20       8.396  -1.626   6.332  1.00  1.00
ATOM    300 1HG2 VAL    20       7.818  -1.914   5.454  1.00  0.00
ATOM    301 2HG2 VAL    20       8.282  -0.557   6.508  1.00  0.00
ATOM    302 3HG2 VAL    20       9.448  -1.857   6.166  1.00  0.00
ATOM    303  C   VAL    20       8.099  -2.635  10.035  1.00  1.00
ATOM    304  O   VAL    20       7.400  -1.970  10.801  1.00  1.00
ATOM    305  N   ILE    21       8.368  -3.920  10.235  1.00  1.00
ATOM    306  HN  ILE    21       8.948  -4.427   9.581  1.00  0.00
ATOM    307  CA  ILE    21       7.838  -4.626  11.395  1.00  1.00
ATOM    308  HA  ILE    21       6.752  -4.676  11.313  1.00  0.00
ATOM    309  CB  ILE    21       8.401  -6.053  11.442  1.00  1.00
ATOM    310  HB  ILE    21       9.480  -6.011  11.588  1.00  0.00
ATOM    311  CG2 ILE    21       7.762  -6.825  12.599  1.00  1.00
ATOM    312 1HG2 ILE    21       8.167  -7.837  12.630  1.00  0.00
ATOM    313 2HG2 ILE    21       7.980  -6.318  13.538  1.00  0.00
ATOM    314 3HG2 ILE    21       6.683  -6.871  12.453  1.00  0.00
ATOM    315  CG1 ILE    21       8.093  -6.768  10.120  1.00  1.00
ATOM    316 2HG1 ILE    21       7.014  -6.874  10.009  1.00  0.00
ATOM    317 3HG1 ILE    21       8.487  -6.180   9.291  1.00  0.00
ATOM    318  CD1 ILE    21       8.742  -8.158  10.110  1.00  1.00
ATOM    319 1HD1 ILE    21       8.517  -8.660   9.169  1.00  0.00
ATOM    320 2HD1 ILE    21       9.822  -8.055  10.218  1.00  0.00
ATOM    321 3HD1 ILE    21       8.349  -8.748  10.938  1.00  0.00
ATOM    322  C   ILE    21       8.208  -3.875  12.668  1.00  1.00
ATOM    323  O   ILE    21       7.418  -3.804  13.610  1.00  1.00
ATOM    324  N   LYS    22       9.407  -3.303  12.684  1.00  1.00
ATOM    325  HN  LYS    22      10.021  -3.389  11.887  1.00  0.00
ATOM    326  CA  LYS    22       9.862  -2.545  13.839  1.00  1.00
ATOM    327  HA  LYS    22       9.776  -3.171  14.728  1.00  0.00
ATOM    328  CB  LYS    22      11.326  -2.139  13.654  1.00  1.00
ATOM    329 2HB  LYS    22      11.435  -1.587  12.721  1.00  0.00
ATOM    330 3HB  LYS    22      11.638  -1.510  14.488  1.00  0.00
ATOM    331  CG  LYS    22      12.196  -3.398  13.609  1.00  1.00
ATOM    332 2HG  LYS    22      12.104  -3.937  14.552  1.00  0.00
ATOM    333 3HG  LYS    22      11.865  -4.039  12.792  1.00  0.00
ATOM    334  CD  LYS    22      13.656  -3.003  13.388  1.00  1.00
ATOM    335 2HD  LYS    22      13.751  -2.478  12.437  1.00  0.00
ATOM    336 3HD  LYS    22      13.982  -2.350  14.197  1.00  0.00
ATOM    337  CE  LYS    22      14.526  -4.260  13.365  1.00  1.00
ATOM    338 2HE  LYS    22      15.573  -3.977  13.253  1.00  0.00
ATOM    339 3HE  LYS    22      14.401  -4.808  14.299  1.00  0.00
ATOM    340  NZ  LYS    22      14.117  -5.125  12.221  1.00  1.00
ATOM    341 1HZ  LYS    22      14.695  -5.954  12.211  1.00  0.00
ATOM    342 2HZ  LYS    22      13.148  -5.389  12.327  1.00  0.00
ATOM    343 3HZ  LYS    22      14.235  -4.619  11.355  1.00  0.00
ATOM    344  C   LYS    22       8.997  -1.298  14.019  1.00  1.00
ATOM    345  O   LYS    22       8.652  -0.924  15.142  1.00  1.00
ATOM    346  N   GLN    23       8.653  -0.656  12.901  1.00  1.00
ATOM    347  HN  GLN    23       8.963  -1.001  12.004  1.00  0.00
ATOM    348  CA  GLN    23       7.831   0.548  12.941  1.00  1.00
ATOM    349  HA  GLN    23       8.313   1.285  13.583  1.00  0.00
ATOM    350  CB  GLN    23       7.694   1.124  11.528  1.00  1.00
ATOM    351 2HB  GLN    23       7.276   0.365  10.866  1.00  0.00
ATOM    352 3HB  GLN    23       7.032   1.989  11.552  1.00  0.00
ATOM    353  CG  GLN    23       9.064   1.547  11.014  1.00  1.00
ATOM    354 2HG  GLN    23       9.476   2.313  11.671  1.00  0.00
ATOM    355 3HG  GLN    23       9.730   0.683  11.009  1.00  0.00
ATOM    356  CD  GLN    23       8.947   2.103   9.601  1.00  1.00
ATOM    357  OE1 GLN    23       8.083   2.938   9.330  1.00  1.00
ATOM    358  NE2 GLN    23       9.773   1.691   8.681  1.00  1.00
ATOM    359 1HE2 GLN    23      10.473   1.006   8.928  1.00  0.00
ATOM    360 2HE2 GLN    23       9.710   2.051   7.740  1.00  0.00
ATOM    361  C   GLN    23       6.452   0.220  13.503  1.00  1.00
ATOM    362  O   GLN    23       5.946   0.913  14.386  1.00  1.00
ATOM    363  N   LEU    24       5.850  -0.844  12.982  1.00  1.00
ATOM    364  HN  LEU    24       6.307  -1.381  12.259  1.00  0.00
ATOM    365  CA  LEU    24       4.528  -1.263  13.434  1.00  1.00
ATOM    366  HA  LEU    24       3.832  -0.435  13.298  1.00  0.00
ATOM    367  CB  LEU    24       4.052  -2.459  12.603  1.00  1.00
ATOM    368 2HB  LEU    24       4.837  -3.215  12.575  1.00  0.00
ATOM    369 3HB  LEU    24       3.157  -2.882  13.059  1.00  0.00
ATOM    370  CG  LEU    24       3.729  -2.005  11.170  1.00  1.00
ATOM    371  HG  LEU    24       4.544  -1.383  10.801  1.00  0.00
ATOM    372  CD1 LEU    24       3.585  -3.238  10.273  1.00  1.00
ATOM    373 1HD1 LEU    24       3.368  -2.923   9.252  1.00  0.00
ATOM    374 2HD1 LEU    24       4.514  -3.808  10.287  1.00  0.00
ATOM    375 3HD1 LEU    24       2.771  -3.863  10.641  1.00  0.00
ATOM    376  CD2 LEU    24       2.418  -1.188  11.137  1.00  1.00
ATOM    377 1HD2 LEU    24       2.206  -0.873  10.115  1.00  0.00
ATOM    378 2HD2 LEU    24       1.597  -1.805  11.503  1.00  0.00
ATOM    379 3HD2 LEU    24       2.523  -0.309  11.773  1.00  0.00
ATOM    380  C   LEU    24       4.564  -1.644  14.905  1.00  1.00
ATOM    381  O   LEU    24       3.670  -1.288  15.668  1.00  1.00
ATOM    382  N   ASP    25       5.605  -2.358  15.302  1.00  1.00
ATOM    383  HN  ASP    25       6.321  -2.624  14.641  1.00  0.00
ATOM    384  CA  ASP    25       5.743  -2.776  16.690  1.00  1.00
ATOM    385  HA  ASP    25       4.924  -3.451  16.938  1.00  0.00
ATOM    386  CB  ASP    25       7.073  -3.509  16.877  1.00  1.00
ATOM    387 2HB  ASP    25       7.177  -4.272  16.106  1.00  0.00
ATOM    388 3HB  ASP    25       7.893  -2.797  16.790  1.00  0.00
ATOM    389  CG  ASP    25       7.121  -4.168  18.249  1.00  1.00
ATOM    390  OD1 ASP    25       6.068  -4.331  18.843  1.00  1.00
ATOM    391  OD2 ASP    25       8.210  -4.500  18.686  1.00  1.00
ATOM    392 2HD  ASP    25       8.165  -4.909  19.554  1.00  0.00
ATOM    393  C   ASP    25       5.692  -1.566  17.617  1.00  1.00
ATOM    394  O   ASP    25       4.993  -1.581  18.629  1.00  1.00
ATOM    395  N   ASP    26       6.427  -0.517  17.264  1.00  1.00
ATOM    396  HN  ASP    26       6.985  -0.545  16.423  1.00  0.00
ATOM    397  CA  ASP    26       6.444   0.690  18.080  1.00  1.00
ATOM    398  HA  ASP    26       6.825   0.440  19.070  1.00  0.00
ATOM    399  CB  ASP    26       7.360   1.736  17.441  1.00  1.00
ATOM    400 2HB  ASP    26       8.317   1.276  17.195  1.00  0.00
ATOM    401 3HB  ASP    26       6.898   2.112  16.528  1.00  0.00
ATOM    402  CG  ASP    26       7.587   2.893  18.406  1.00  1.00
ATOM    403  OD1 ASP    26       6.816   3.016  19.343  1.00  1.00
ATOM    404  OD2 ASP    26       8.529   3.639  18.196  1.00  1.00
ATOM    405 2HD  ASP    26       8.611   4.343  18.843  1.00  0.00
ATOM    406  C   ASP    26       5.032   1.249  18.217  1.00  1.00
ATOM    407  O   ASP    26       4.614   1.651  19.302  1.00  1.00
ATOM    408  N   LEU    27       4.300   1.259  17.110  1.00  1.00
ATOM    409  HN  LEU    27       4.690   0.919  16.243  1.00  0.00
ATOM    410  CA  LEU    27       2.929   1.754  17.111  1.00  1.00
ATOM    411  HA  LEU    27       2.919   2.741  17.572  1.00  0.00
ATOM    412  CB  LEU    27       2.416   1.878  15.672  1.00  1.00
ATOM    413 2HB  LEU    27       2.812   1.057  15.074  1.00  0.00
ATOM    414 3HB  LEU    27       1.327   1.836  15.670  1.00  0.00
ATOM    415  CG  LEU    27       2.881   3.225  15.071  1.00  1.00
ATOM    416  HG  LEU    27       3.841   3.501  15.506  1.00  0.00
ATOM    417  CD1 LEU    27       3.027   3.090  13.565  1.00  1.00
ATOM    418 1HD1 LEU    27       3.358   4.039  13.144  1.00  0.00
ATOM    419 2HD1 LEU    27       3.762   2.317  13.339  1.00  0.00
ATOM    420 3HD1 LEU    27       2.066   2.815  13.130  1.00  0.00
ATOM    421  CD2 LEU    27       1.846   4.321  15.376  1.00  1.00
ATOM    422 1HD2 LEU    27       2.181   5.267  14.952  1.00  0.00
ATOM    423 2HD2 LEU    27       0.886   4.046  14.938  1.00  0.00
ATOM    424 3HD2 LEU    27       1.735   4.426  16.455  1.00  0.00
ATOM    425  C   LEU    27       2.024   0.830  17.918  1.00  1.00
ATOM    426  O   LEU    27       1.076   1.278  18.558  1.00  1.00
ATOM    427  N   GLU    28       2.323  -0.461  17.875  1.00  1.00
ATOM    428  HN  GLU    28       3.112  -0.779  17.331  1.00  0.00
ATOM    429  CA  GLU    28       1.536  -1.444  18.599  1.00  1.00
ATOM    430  HA  GLU    28       0.481  -1.288  18.371  1.00  0.00
ATOM    431  CB  GLU    28       1.944  -2.847  18.147  1.00  1.00
ATOM    432 2HB  GLU    28       3.031  -2.923  18.137  1.00  0.00
ATOM    433 3HB  GLU    28       1.535  -3.585  18.838  1.00  0.00
ATOM    434  CG  GLU    28       1.401  -3.112  16.740  1.00  1.00
ATOM    435 2HG  GLU    28       0.318  -3.226  16.785  1.00  0.00
ATOM    436 3HG  GLU    28       1.647  -2.271  16.092  1.00  0.00
ATOM    437  CD  GLU    28       2.021  -4.385  16.175  1.00  1.00
ATOM    438  OE1 GLU    28       1.807  -5.434  16.759  1.00  1.00
ATOM    439  OE2 GLU    28       2.705  -4.290  15.169  1.00  1.00
ATOM    440 2HE  GLU    28       3.064  -5.129  14.871  1.00  0.00
ATOM    441  C   GLU    28       1.744  -1.301  20.103  1.00  1.00
ATOM    442  O   GLU    28       0.820  -1.498  20.886  1.00  1.00
ATOM    443  N   VAL    29       2.967  -0.967  20.496  1.00  1.00
ATOM    444  HN  VAL    29       3.699  -0.817  19.817  1.00  0.00
ATOM    445  CA  VAL    29       3.278  -0.811  21.916  1.00  1.00
ATOM    446  HA  VAL    29       3.008  -1.731  22.435  1.00  0.00
ATOM    447  CB  VAL    29       4.780  -0.558  22.093  1.00  1.00
ATOM    448  HB  VAL    29       5.090   0.246  21.426  1.00  0.00
ATOM    449  CG1 VAL    29       5.075  -0.157  23.544  1.00  1.00
ATOM    450 1HG1 VAL    29       6.143   0.023  23.663  1.00  0.00
ATOM    451 2HG1 VAL    29       4.524   0.751  23.789  1.00  0.00
ATOM    452 3HG1 VAL    29       4.766  -0.961  24.213  1.00  0.00
ATOM    453  CG2 VAL    29       5.558  -1.832  21.749  1.00  1.00
ATOM    454 1HG2 VAL    29       6.626  -1.651  21.870  1.00  0.00
ATOM    455 2HG2 VAL    29       5.248  -2.638  22.415  1.00  0.00
ATOM    456 3HG2 VAL    29       5.353  -2.115  20.717  1.00  0.00
ATOM    457  C   VAL    29       2.490   0.350  22.522  1.00  1.00
ATOM    458  O   VAL    29       1.838   0.200  23.555  1.00  1.00
ATOM    459  N   GLN    30       2.565   1.506  21.876  1.00  1.00
ATOM    460  HN  GLN    30       3.114   1.580  21.032  1.00  0.00
ATOM    461  CA  GLN    30       1.864   2.689  22.362  1.00  1.00
ATOM    462  HA  GLN    30       2.189   2.889  23.383  1.00  0.00
ATOM    463  CB  GLN    30       2.206   3.900  21.487  1.00  1.00
ATOM    464 2HB  GLN    30       1.589   4.748  21.782  1.00  0.00
ATOM    465 3HB  GLN    30       3.258   4.154  21.613  1.00  0.00
ATOM    466  CG  GLN    30       1.937   3.559  20.033  1.00  1.00
ATOM    467 2HG  GLN    30       2.480   2.652  19.767  1.00  0.00
ATOM    468 3HG  GLN    30       0.869   3.392  19.892  1.00  0.00
ATOM    469  CD  GLN    30       2.394   4.705  19.137  1.00  1.00
ATOM    470  OE1 GLN    30       3.594   4.951  19.007  1.00  1.00
ATOM    471  NE2 GLN    30       1.507   5.426  18.510  1.00  1.00
ATOM    472 1HE2 GLN    30       0.529   5.206  18.633  1.00  0.00
ATOM    473 2HE2 GLN    30       1.796   6.188  17.915  1.00  0.00
ATOM    474  C   GLN    30       0.361   2.454  22.363  1.00  1.00
ATOM    475  O   GLN    30      -0.341   2.869  23.283  1.00  1.00
ATOM    476  N   ARG    31      -0.127   1.784  21.325  1.00  1.00
ATOM    477  HN  ARG    31       0.492   1.461  20.595  1.00  0.00
ATOM    478  CA  ARG    31      -1.554   1.498  21.209  1.00  1.00
ATOM    479  HA  ARG    31      -2.114   2.326  21.644  1.00  0.00
ATOM    480  CB  ARG    31      -1.929   1.363  19.725  1.00  1.00
ATOM    481 2HB  ARG    31      -1.128   0.846  19.197  1.00  0.00
ATOM    482 3HB  ARG    31      -2.851   0.788  19.638  1.00  0.00
ATOM    483  CG  ARG    31      -2.137   2.754  19.099  1.00  1.00
ATOM    484 2HG  ARG    31      -1.427   3.455  19.537  1.00  0.00
ATOM    485 3HG  ARG    31      -1.972   2.693  18.023  1.00  0.00
ATOM    486  CD  ARG    31      -3.565   3.245  19.366  1.00  1.00
ATOM    487 2HD  ARG    31      -4.277   2.508  18.994  1.00  0.00
ATOM    488 3HD  ARG    31      -3.710   3.372  20.439  1.00  0.00
ATOM    489  NE  ARG    31      -3.789   4.518  18.692  1.00  1.00
ATOM    490  HE  ARG    31      -4.150   4.506  17.749  1.00  0.00
ATOM    491  CZ  ARG    31      -3.529   5.674  19.294  1.00  1.00
ATOM    492  NH1 ARG    31      -3.751   6.794  18.668  1.00  1.00
ATOM    493 1HH1 ARG    31      -3.552   7.672  19.125  1.00  0.00
ATOM    494 2HH1 ARG    31      -4.122   6.783  17.729  1.00  0.00
ATOM    495  NH2 ARG    31      -3.046   5.687  20.508  1.00  1.00
ATOM    496 1HH2 ARG    31      -2.848   6.567  20.961  1.00  0.00
ATOM    497 2HH2 ARG    31      -2.871   4.818  20.992  1.00  0.00
ATOM    498  C   ARG    31      -1.908   0.216  21.957  1.00  1.00
ATOM    499  O   ARG    31      -3.077  -0.038  22.248  1.00  1.00
ATOM    500  N   ASN    32      -0.898  -0.584  22.265  1.00  1.00
ATOM    501  HN  ASN    32       0.046  -0.334  22.008  1.00  0.00
ATOM    502  CA  ASN    32      -1.122  -1.829  22.974  1.00  1.00
ATOM    503  HA  ASN    32      -0.177  -2.368  23.046  1.00  0.00
ATOM    504  CB  ASN    32      -1.640  -1.544  24.378  1.00  1.00
ATOM    505 2HB  ASN    32      -2.629  -1.090  24.314  1.00  0.00
ATOM    506 3HB  ASN    32      -1.710  -2.478  24.936  1.00  0.00
ATOM    507  CG  ASN    32      -0.690  -0.596  25.097  1.00  1.00
ATOM    508  OD1 ASN    32       0.488  -0.908  25.268  1.00  1.00
ATOM    509  ND2 ASN    32      -1.133   0.553  25.526  1.00  1.00
ATOM    510 1HD2 ASN    32      -2.103   0.787  25.371  1.00  0.00
ATOM    511 2HD2 ASN    32      -0.514   1.193  26.002  1.00  0.00
ATOM    512  C   ASN    32      -2.126  -2.686  22.225  1.00  1.00
ATOM    513  O   ASN    32      -2.988  -3.319  22.832  1.00  1.00
ATOM    514  N   LEU    33      -2.020  -2.698  20.896  1.00  1.00
ATOM    515  HN  LEU    33      -1.296  -2.163  20.439  1.00  0.00
ATOM    516  CA  LEU    33      -2.942  -3.481  20.071  1.00  1.00
ATOM    517  HA  LEU    33      -3.452  -4.206  20.707  1.00  0.00
ATOM    518  CB  LEU    33      -3.983  -2.541  19.444  1.00  1.00
ATOM    519 2HB  LEU    33      -3.494  -1.621  19.126  1.00  0.00
ATOM    520 3HB  LEU    33      -4.437  -3.029  18.581  1.00  0.00
ATOM    521  CG  LEU    33      -5.078  -2.208  20.477  1.00  1.00
ATOM    522  HG  LEU    33      -4.621  -2.119  21.462  1.00  0.00
ATOM    523  CD1 LEU    33      -5.744  -0.882  20.108  1.00  1.00
ATOM    524 1HD1 LEU    33      -6.510  -0.640  20.845  1.00  0.00
ATOM    525 2HD1 LEU    33      -4.994  -0.092  20.092  1.00  0.00
ATOM    526 3HD1 LEU    33      -6.203  -0.968  19.123  1.00  0.00
ATOM    527  CD2 LEU    33      -6.144  -3.319  20.517  1.00  1.00
ATOM    528 1HD2 LEU    33      -6.907  -3.072  21.255  1.00  0.00
ATOM    529 2HD2 LEU    33      -6.608  -3.412  19.535  1.00  0.00
ATOM    530 3HD2 LEU    33      -5.673  -4.264  20.787  1.00  0.00
ATOM    531  C   LEU    33      -2.191  -4.230  18.972  1.00  1.00
ATOM    532  O   LEU    33      -1.121  -3.799  18.538  1.00  1.00
ATOM    533  N   PRO    34      -2.736  -5.331  18.512  1.00  1.00
ATOM    534  CD  PRO    34      -4.004  -5.930  18.977  1.00  1.00
ATOM    535  CA  PRO    34      -2.110  -6.148  17.430  1.00  1.00
ATOM    536  HA  PRO    34      -1.111  -6.469  17.726  1.00  0.00
ATOM    537  CB  PRO    34      -3.045  -7.368  17.298  1.00  1.00
ATOM    538 2HB  PRO    34      -3.151  -7.684  16.260  1.00  0.00
ATOM    539 3HB  PRO    34      -2.649  -8.179  17.909  1.00  0.00
ATOM    540  CG  PRO    34      -4.352  -6.929  17.881  1.00  1.00
ATOM    541 2HG  PRO    34      -4.918  -6.411  17.107  1.00  0.00
ATOM    542 3HG  PRO    34      -4.919  -7.773  18.274  1.00  0.00
ATOM    543 2HD  PRO    34      -4.789  -5.183  19.093  1.00  0.00
ATOM    544 3HD  PRO    34      -3.835  -6.452  19.919  1.00  0.00
ATOM    545  C   PRO    34      -2.016  -5.378  16.112  1.00  1.00
ATOM    546  O   PRO    34      -2.805  -4.471  15.854  1.00  1.00
ATOM    547  N   ARG    35      -1.047  -5.755  15.286  1.00  1.00
ATOM    548  HN  ARG    35      -0.423  -6.505  15.547  1.00  0.00
ATOM    549  CA  ARG    35      -0.858  -5.106  13.998  1.00  1.00
ATOM    550  HA  ARG    35      -0.686  -4.042  14.160  1.00  0.00
ATOM    551  CB  ARG    35       0.359  -5.712  13.299  1.00  1.00
ATOM    552 2HB  ARG    35       0.558  -5.163  12.379  1.00  0.00
ATOM    553 3HB  ARG    35       1.225  -5.644  13.957  1.00  0.00
ATOM    554  CG  ARG    35       0.090  -7.184  12.965  1.00  1.00
ATOM    555 2HG  ARG    35      -0.310  -7.689  13.845  1.00  0.00
ATOM    556 3HG  ARG    35      -0.633  -7.246  12.151  1.00  0.00
ATOM    557  CD  ARG    35       1.394  -7.858  12.540  1.00  1.00
ATOM    558 2HD  ARG    35       1.818  -7.323  11.690  1.00  0.00
ATOM    559 3HD  ARG    35       2.101  -7.833  13.369  1.00  0.00
ATOM    560  NE  ARG    35       1.140  -9.244  12.162  1.00  1.00
ATOM    561  HE  ARG    35       0.191  -9.523  11.958  1.00  0.00
ATOM    562  CZ  ARG    35       2.129 -10.128  12.085  1.00  1.00
ATOM    563  NH1 ARG    35       1.877 -11.362  11.743  1.00  1.00
ATOM    564 1HH1 ARG    35       2.630 -12.032  11.686  1.00  0.00
ATOM    565 2HH1 ARG    35       0.930 -11.647  11.536  1.00  0.00
ATOM    566  NH2 ARG    35       3.352  -9.761  12.354  1.00  1.00
ATOM    567 1HH2 ARG    35       4.103 -10.434  12.296  1.00  0.00
ATOM    568 2HH2 ARG    35       3.547  -8.807  12.620  1.00  0.00
ATOM    569  C   ARG    35      -2.094  -5.282  13.128  1.00  1.00
ATOM    570  O   ARG    35      -2.547  -4.338  12.481  1.00  1.00
ATOM    571  N   ALA    36      -2.630  -6.497  13.102  1.00  1.00
ATOM    572  HN  ALA    36      -2.226  -7.244  13.650  1.00  0.00
ATOM    573  CA  ALA    36      -3.804  -6.780  12.288  1.00  1.00
ATOM    574  HA  ALA    36      -3.513  -6.776  11.238  1.00  0.00
ATOM    575  CB  ALA    36      -4.367  -8.157  12.647  1.00  1.00
ATOM    576 1HB  ALA    36      -5.236  -8.372  12.024  1.00  0.00
ATOM    577 2HB  ALA    36      -3.604  -8.917  12.478  1.00  0.00
ATOM    578 3HB  ALA    36      -4.662  -8.167  13.696  1.00  0.00
ATOM    579  C   ALA    36      -4.869  -5.719  12.514  1.00  1.00
ATOM    580  O   ALA    36      -5.509  -5.258  11.569  1.00  1.00
ATOM    581  N   ASP    37      -5.044  -5.323  13.768  1.00  1.00
ATOM    582  HN  ASP    37      -4.497  -5.730  14.513  1.00  0.00
ATOM    583  CA  ASP    37      -6.026  -4.299  14.095  1.00  1.00
ATOM    584  HA  ASP    37      -6.992  -4.599  13.688  1.00  0.00
ATOM    585  CB  ASP    37      -6.145  -4.162  15.615  1.00  1.00
ATOM    586 2HB  ASP    37      -6.520  -5.096  16.035  1.00  0.00
ATOM    587 3HB  ASP    37      -5.163  -3.948  16.037  1.00  0.00
ATOM    588  CG  ASP    37      -7.104  -3.029  15.964  1.00  1.00
ATOM    589  OD1 ASP    37      -6.656  -2.063  16.560  1.00  1.00
ATOM    590  OD2 ASP    37      -8.272  -3.143  15.630  1.00  1.00
ATOM    591 2HD  ASP    37      -8.817  -2.394  15.882  1.00  0.00
ATOM    592  C   ASP    37      -5.626  -2.957  13.485  1.00  1.00
ATOM    593  O   ASP    37      -6.473  -2.203  13.007  1.00  1.00
ATOM    594  N   LEU    38      -4.328  -2.669  13.504  1.00  1.00
ATOM    595  HN  LEU    38      -3.671  -3.321  13.908  1.00  0.00
ATOM    596  CA  LEU    38      -3.822  -1.419  12.949  1.00  1.00
ATOM    597  HA  LEU    38      -4.409  -0.596  13.356  1.00  0.00
ATOM    598  CB  LEU    38      -2.356  -1.230  13.347  1.00  1.00
ATOM    599 2HB  LEU    38      -1.784  -2.110  13.051  1.00  0.00
ATOM    600 3HB  LEU    38      -1.955  -0.350  12.845  1.00  0.00
ATOM    601  CG  LEU    38      -2.254  -1.042  14.869  1.00  1.00
ATOM    602  HG  LEU    38      -2.762  -1.871  15.364  1.00  0.00
ATOM    603  CD1 LEU    38      -0.777  -1.036  15.282  1.00  1.00
ATOM    604 1HD1 LEU    38      -0.701  -0.916  16.363  1.00  0.00
ATOM    605 2HD1 LEU    38      -0.314  -1.979  14.988  1.00  0.00
ATOM    606 3HD1 LEU    38      -0.265  -0.211  14.788  1.00  0.00
ATOM    607  CD2 LEU    38      -2.919   0.283  15.301  1.00  1.00
ATOM    608 1HD2 LEU    38      -2.843   0.398  16.382  1.00  0.00
ATOM    609 2HD2 LEU    38      -2.416   1.117  14.812  1.00  0.00
ATOM    610 3HD2 LEU    38      -3.970   0.272  15.012  1.00  0.00
ATOM    611  C   LEU    38      -3.947  -1.410  11.431  1.00  1.00
ATOM    612  O   LEU    38      -4.315  -0.398  10.834  1.00  1.00
ATOM    613  N   LEU    39      -3.630  -2.539  10.810  1.00  1.00
ATOM    614  HN  LEU    39      -3.336  -3.347  11.341  1.00  0.00
ATOM    615  CA  LEU    39      -3.698  -2.642   9.359  1.00  1.00
ATOM    616  HA  LEU    39      -3.057  -1.878   8.920  1.00  0.00
ATOM    617  CB  LEU    39      -3.207  -4.021   8.928  1.00  1.00
ATOM    618 2HB  LEU    39      -3.755  -4.787   9.477  1.00  0.00
ATOM    619 3HB  LEU    39      -3.378  -4.147   7.859  1.00  0.00
ATOM    620  CG  LEU    39      -1.705  -4.160   9.223  1.00  1.00
ATOM    621  HG  LEU    39      -1.522  -3.885  10.262  1.00  0.00
ATOM    622  CD1 LEU    39      -1.276  -5.619   9.008  1.00  1.00
ATOM    623 1HD1 LEU    39      -0.214  -5.724   9.231  1.00  0.00
ATOM    624 2HD1 LEU    39      -1.851  -6.268   9.669  1.00  0.00
ATOM    625 3HD1 LEU    39      -1.460  -5.903   7.972  1.00  0.00
ATOM    626  CD2 LEU    39      -0.882  -3.226   8.308  1.00  1.00
ATOM    627 1HD2 LEU    39       0.179  -3.331   8.534  1.00  0.00
ATOM    628 2HD2 LEU    39      -1.058  -3.493   7.266  1.00  0.00
ATOM    629 3HD2 LEU    39      -1.188  -2.194   8.475  1.00  0.00
ATOM    630  C   LEU    39      -5.126  -2.437   8.872  1.00  1.00
ATOM    631  O   LEU    39      -5.366  -1.701   7.915  1.00  1.00
ATOM    632  N   ARG    40      -6.072  -3.096   9.529  1.00  1.00
ATOM    633  HN  ARG    40      -5.831  -3.690  10.309  1.00  0.00
ATOM    634  CA  ARG    40      -7.470  -2.980   9.142  1.00  1.00
ATOM    635  HA  ARG    40      -7.593  -3.390   8.139  1.00  0.00
ATOM    636  CB  ARG    40      -8.347  -3.770  10.118  1.00  1.00
ATOM    637 2HB  ARG    40      -8.014  -4.808  10.146  1.00  0.00
ATOM    638 3HB  ARG    40      -8.263  -3.335  11.114  1.00  0.00
ATOM    639  CG  ARG    40      -9.806  -3.716   9.661  1.00  1.00
ATOM    640 2HG  ARG    40     -10.146  -2.681   9.653  1.00  0.00
ATOM    641 3HG  ARG    40      -9.888  -4.134   8.658  1.00  0.00
ATOM    642  CD  ARG    40     -10.672  -4.528  10.623  1.00  1.00
ATOM    643 2HD  ARG    40     -11.704  -4.527  10.270  1.00  0.00
ATOM    644 3HD  ARG    40     -10.307  -5.555  10.660  1.00  0.00
ATOM    645  NE  ARG    40     -10.617  -3.946  11.960  1.00  1.00
ATOM    646  HE  ARG    40     -10.000  -4.363  12.642  1.00  0.00
ATOM    647  CZ  ARG    40     -11.359  -2.891  12.283  1.00  1.00
ATOM    648  NH1 ARG    40     -11.296  -2.394  13.488  1.00  1.00
ATOM    649 1HH1 ARG    40     -11.859  -1.592  13.731  1.00  0.00
ATOM    650 2HH1 ARG    40     -10.686  -2.811  14.176  1.00  0.00
ATOM    651  NH2 ARG    40     -12.145  -2.349  11.393  1.00  1.00
ATOM    652 1HH2 ARG    40     -12.707  -1.547  11.640  1.00  0.00
ATOM    653 2HH2 ARG    40     -12.192  -2.732  10.460  1.00  0.00
ATOM    654  C   ARG    40      -7.895  -1.518   9.138  1.00  1.00
ATOM    655  O   ARG    40      -8.571  -1.060   8.216  1.00  1.00
ATOM    656  N   GLU    41      -7.491  -0.789  10.169  1.00  1.00
ATOM    657  HN  GLU    41      -6.936  -1.209  10.902  1.00  0.00
ATOM    658  CA  GLU    41      -7.833   0.623  10.270  1.00  1.00
ATOM    659  HA  GLU    41      -8.914   0.728  10.175  1.00  0.00
ATOM    660  CB  GLU    41      -7.397   1.170  11.631  1.00  1.00
ATOM    661 2HB  GLU    41      -6.340   0.954  11.786  1.00  0.00
ATOM    662 3HB  GLU    41      -7.555   2.248  11.655  1.00  0.00
ATOM    663  CG  GLU    41      -8.219   0.511  12.742  1.00  1.00
ATOM    664 2HG  GLU    41      -8.141  -0.573  12.655  1.00  0.00
ATOM    665 3HG  GLU    41      -7.831   0.822  13.712  1.00  0.00
ATOM    666  CD  GLU    41      -9.683   0.924  12.626  1.00  1.00
ATOM    667  OE1 GLU    41     -10.523   0.212  13.150  1.00  1.00
ATOM    668  OE2 GLU    41      -9.942   1.945  12.011  1.00  1.00
ATOM    669 2HE  GLU    41     -10.881   2.143  11.977  1.00  0.00
ATOM    670  C   GLU    41      -7.157   1.416   9.157  1.00  1.00
ATOM    671  O   GLU    41      -7.731   2.362   8.620  1.00  1.00
ATOM    672  N   ALA    42      -5.935   1.025   8.816  1.00  1.00
ATOM    673  HN  ALA    42      -5.502   0.242   9.285  1.00  0.00
ATOM    674  CA  ALA    42      -5.195   1.711   7.765  1.00  1.00
ATOM    675  HA  ALA    42      -5.063   2.753   8.054  1.00  0.00
ATOM    676  CB  ALA    42      -3.822   1.062   7.588  1.00  1.00
ATOM    677 1HB  ALA    42      -3.264   1.589   6.815  1.00  0.00
ATOM    678 2HB  ALA    42      -3.273   1.112   8.529  1.00  0.00
ATOM    679 3HB  ALA    42      -3.949   0.019   7.296  1.00  0.00
ATOM    680  C   ALA    42      -5.957   1.654   6.445  1.00  1.00
ATOM    681  O   ALA    42      -6.127   2.672   5.774  1.00  1.00
ATOM    682  N   VAL    43      -6.414   0.461   6.074  1.00  1.00
ATOM    683  HN  VAL    43      -6.254  -0.351   6.654  1.00  0.00
ATOM    684  CA  VAL    43      -7.153   0.301   4.826  1.00  1.00
ATOM    685  HA  VAL    43      -6.540   0.667   4.003  1.00  0.00
ATOM    686  CB  VAL    43      -7.464  -1.180   4.601  1.00  1.00
ATOM    687  HB  VAL    43      -8.001  -1.572   5.465  1.00  0.00
ATOM    688  CG1 VAL    43      -8.329  -1.341   3.351  1.00  1.00
ATOM    689 1HG1 VAL    43      -8.550  -2.397   3.194  1.00  0.00
ATOM    690 2HG1 VAL    43      -9.261  -0.791   3.481  1.00  0.00
ATOM    691 3HG1 VAL    43      -7.794  -0.950   2.486  1.00  0.00
ATOM    692  CG2 VAL    43      -6.156  -1.955   4.421  1.00  1.00
ATOM    693 1HG2 VAL    43      -6.377  -3.011   4.264  1.00  0.00
ATOM    694 2HG2 VAL    43      -5.618  -1.564   3.558  1.00  0.00
ATOM    695 3HG2 VAL    43      -5.541  -1.842   5.314  1.00  0.00
ATOM    696  C   VAL    43      -8.454   1.098   4.873  1.00  1.00
ATOM    697  O   VAL    43      -8.725   1.916   3.995  1.00  1.00
ATOM    698  N   ASP    44      -9.257   0.847   5.901  1.00  1.00
ATOM    699  HN  ASP    44      -8.994   0.166   6.599  1.00  0.00
ATOM    700  CA  ASP    44     -10.528   1.542   6.045  1.00  1.00
ATOM    701  HA  ASP    44     -11.207   1.200   5.263  1.00  0.00
ATOM    702  CB  ASP    44     -11.143   1.234   7.411  1.00  1.00
ATOM    703 2HB  ASP    44     -11.062   0.165   7.610  1.00  0.00
ATOM    704 3HB  ASP    44     -10.604   1.784   8.182  1.00  0.00
ATOM    705  CG  ASP    44     -12.614   1.642   7.436  1.00  1.00
ATOM    706  OD1 ASP    44     -13.227   1.654   6.381  1.00  1.00
ATOM    707  OD2 ASP    44     -13.105   1.939   8.513  1.00  1.00
ATOM    708 2HD  ASP    44     -14.031   2.185   8.455  1.00  0.00
ATOM    709  C   ASP    44     -10.318   3.044   5.904  1.00  1.00
ATOM    710  O   ASP    44     -11.076   3.725   5.217  1.00  1.00
ATOM    711  N   GLN    45      -9.273   3.550   6.546  1.00  1.00
ATOM    712  HN  GLN    45      -8.678   2.949   7.098  1.00  0.00
ATOM    713  CA  GLN    45      -8.959   4.970   6.474  1.00  1.00
ATOM    714  HA  GLN    45      -9.843   5.537   6.765  1.00  0.00
ATOM    715  CB  GLN    45      -7.818   5.297   7.443  1.00  1.00
ATOM    716 2HB  GLN    45      -7.048   4.529   7.368  1.00  0.00
ATOM    717 3HB  GLN    45      -7.391   6.266   7.186  1.00  0.00
ATOM    718  CG  GLN    45      -8.354   5.341   8.877  1.00  1.00
ATOM    719 2HG  GLN    45      -9.109   6.123   8.958  1.00  0.00
ATOM    720 3HG  GLN    45      -8.806   4.380   9.124  1.00  0.00
ATOM    721  CD  GLN    45      -7.219   5.631   9.851  1.00  1.00
ATOM    722  OE1 GLN    45      -6.424   6.544   9.625  1.00  1.00
ATOM    723  NE2 GLN    45      -7.097   4.907  10.929  1.00  1.00
ATOM    724 1HE2 GLN    45      -7.762   4.164  11.093  1.00  0.00
ATOM    725 2HE2 GLN    45      -6.351   5.088  11.584  1.00  0.00
ATOM    726  C   GLN    45      -8.566   5.364   5.053  1.00  1.00
ATOM    727  O   GLN    45      -8.921   6.442   4.575  1.00  1.00
ATOM    728  N   TYR    46      -7.828   4.486   4.386  1.00  1.00
ATOM    729  HN  TYR    46      -7.559   3.615   4.821  1.00  0.00
ATOM    730  CA  TYR    46      -7.388   4.752   3.020  1.00  1.00
ATOM    731  HA  TYR    46      -6.832   5.689   3.011  1.00  0.00
ATOM    732  CB  TYR    46      -6.472   3.628   2.537  1.00  1.00
ATOM    733 2HB  TYR    46      -5.591   3.572   3.176  1.00  0.00
ATOM    734 3HB  TYR    46      -7.001   2.676   2.587  1.00  0.00
ATOM    735  CG  TYR    46      -6.050   3.901   1.111  1.00  1.00
ATOM    736  CD1 TYR    46      -5.180   4.963   0.835  1.00  1.00
ATOM    737 1HD  TYR    46      -4.815   5.585   1.639  1.00  0.00
ATOM    738  CE1 TYR    46      -4.783   5.218  -0.482  1.00  1.00
ATOM    739 1HE  TYR    46      -4.112   6.037  -0.695  1.00  0.00
ATOM    740  CZ  TYR    46      -5.255   4.412  -1.524  1.00  1.00
ATOM    741  CE2 TYR    46      -6.124   3.349  -1.250  1.00  1.00
ATOM    742 2HE  TYR    46      -6.487   2.726  -2.054  1.00  0.00
ATOM    743  CD2 TYR    46      -6.522   3.093   0.068  1.00  1.00
ATOM    744 2HD  TYR    46      -7.192   2.273   0.280  1.00  0.00
ATOM    745  OH  TYR    46      -4.864   4.665  -2.823  1.00  1.00
ATOM    746  HH  TYR    46      -5.247   4.053  -3.456  1.00  0.00
ATOM    747  C   TYR    46      -8.587   4.882   2.086  1.00  1.00
ATOM    748  O   TYR    46      -8.663   5.812   1.284  1.00  1.00
ATOM    749  N   LEU    47      -9.521   3.946   2.202  1.00  1.00
ATOM    750  HN  LEU    47      -9.413   3.203   2.878  1.00  0.00
ATOM    751  CA  LEU    47     -10.719   3.963   1.364  1.00  1.00
ATOM    752  HA  LEU    47     -10.410   3.940   0.319  1.00  0.00
ATOM    753  CB  LEU    47     -11.583   2.731   1.653  1.00  1.00
ATOM    754 2HB  LEU    47     -11.671   2.595   2.731  1.00  0.00
ATOM    755 3HB  LEU    47     -12.574   2.875   1.223  1.00  0.00
ATOM    756  CG  LEU    47     -10.934   1.482   1.033  1.00  1.00
ATOM    757  HG  LEU    47      -9.885   1.443   1.325  1.00  0.00
ATOM    758  CD1 LEU    47     -11.649   0.228   1.554  1.00  1.00
ATOM    759 1HD1 LEU    47     -11.185  -0.661   1.126  1.00  0.00
ATOM    760 2HD1 LEU    47     -11.571   0.190   2.641  1.00  0.00
ATOM    761 3HD1 LEU    47     -12.700   0.262   1.266  1.00  0.00
ATOM    762  CD2 LEU    47     -11.025   1.534  -0.513  1.00  1.00
ATOM    763 1HD2 LEU    47     -10.558   0.646  -0.939  1.00  0.00
ATOM    764 2HD2 LEU    47     -12.072   1.571  -0.814  1.00  0.00
ATOM    765 3HD2 LEU    47     -10.511   2.423  -0.877  1.00  0.00
ATOM    766  C   LEU    47     -11.533   5.227   1.610  1.00  1.00
ATOM    767  O   LEU    47     -12.036   5.844   0.671  1.00  1.00
ATOM    768  N   ILE    48     -11.657   5.610   2.871  1.00  1.00
ATOM    769  HN  ILE    48     -11.225   5.077   3.613  1.00  0.00
ATOM    770  CA  ILE    48     -12.415   6.804   3.212  1.00  1.00
ATOM    771  HA  ILE    48     -13.439   6.684   2.859  1.00  0.00
ATOM    772  CB  ILE    48     -12.428   6.992   4.735  1.00  1.00
ATOM    773  HB  ILE    48     -11.411   6.900   5.115  1.00  0.00
ATOM    774  CG2 ILE    48     -12.973   8.378   5.090  1.00  1.00
ATOM    775 1HG2 ILE    48     -12.973   8.505   6.173  1.00  0.00
ATOM    776 2HG2 ILE    48     -12.344   9.142   4.635  1.00  0.00
ATOM    777 3HG2 ILE    48     -13.992   8.474   4.714  1.00  0.00
ATOM    778  CG1 ILE    48     -13.306   5.915   5.379  1.00  1.00
ATOM    779 2HG1 ILE    48     -14.354   6.122   5.160  1.00  0.00
ATOM    780 3HG1 ILE    48     -13.037   4.938   4.976  1.00  0.00
ATOM    781  CD1 ILE    48     -13.093   5.916   6.896  1.00  1.00
ATOM    782 1HD1 ILE    48     -13.720   5.149   7.352  1.00  0.00
ATOM    783 2HD1 ILE    48     -12.046   5.707   7.116  1.00  0.00
ATOM    784 3HD1 ILE    48     -13.362   6.892   7.300  1.00  0.00
ATOM    785  C   ILE    48     -11.797   8.028   2.543  1.00  1.00
ATOM    786  O   ILE    48     -12.506   8.858   1.976  1.00  1.00
END
