
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   48 (  372),  selected   48 , name 2gpe_D
# Molecule2: number of CA atoms   40 (  676),  selected   40 , name T0474.pdb
# PARAMETERS: 2gpe_D.T0474.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     2_D      -       -           -
LGA    T     3_D      M       9          1.745
LGA    T     4_D      G      10          1.378
LGA    T     5_D      R      11          1.012
LGA    M     6_D      I      12          0.490
LGA    G     7_D      L      13          0.451
LGA    V     8_D      L      14          0.688
LGA    K     9_D      D      15          0.390
LGA    L    10_D      L      16          0.449
LGA    D    11_D      S      17          0.478
LGA    D    12_D      N      18          0.743
LGA    A    13_D      E      19          0.726
LGA    T    14_D      V      20          0.834
LGA    R    15_D      I      21          1.208
LGA    E    16_D      K      22          1.078
LGA    R    17_D      Q      23          0.496
LGA    I    18_D      L      24          0.648
LGA    K    19_D      D      25          1.095
LGA    S    20_D      D      26          0.926
LGA    A    21_D      L      27          0.515
LGA    A    22_D      E      28          1.206
LGA    T    23_D      V      29          1.064
LGA    R    24_D      Q      30          0.619
LGA    I    25_D      R      31          1.228
LGA    D    26_D      N      32          1.575
LGA    R    27_D      L      33          1.309
LGA    T    28_D      P      34          0.972
LGA    P    29_D      R      35          1.076
LGA    H    30_D      A      36          0.966
LGA    W    31_D      D      37          0.501
LGA    L    32_D      L      38          0.648
LGA    I    33_D      L      39          0.773
LGA    K    34_D      R      40          0.761
LGA    Q    35_D      E      41          0.744
LGA    A    36_D      A      42          0.703
LGA    I    37_D      V      43          0.800
LGA    F    38_D      D      44          0.774
LGA    S    39_D      Q      45          0.695
LGA    Y    40_D      Y      46          0.767
LGA    L    41_D      L      47          0.886
LGA    E    42_D      I      48          0.605
LGA    Q    43_D      -       -           -
LGA    L    44_D      -       -           -
LGA    E    45_D      -       -           -
LGA    N    46_D      -       -           -
LGA    S    47_D      -       -           -
LGA    D    48_D      -       -           -
LGA    T    49_D      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   48   40    5.0     40    0.91    12.50     98.026     3.971

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.150848 * X  +   0.984338 * Y  +   0.091235 * Z  +  20.200571
  Y_new =   0.988516 * X  +   0.149359 * Y  +   0.022976 * Z  +  28.268120
  Z_new =   0.008989 * X  +   0.093653 * Y  +  -0.995564 * Z  +  -7.647970 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   3.047798   -0.093795  [ DEG:   174.6260     -5.3740 ]
  Theta =  -0.008989   -3.132603  [ DEG:    -0.5150   -179.4850 ]
  Phi   =   1.722229   -1.419364  [ DEG:    98.6765    -81.3235 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2gpe_D                                        
REMARK     2: T0474.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2gpe_D.T0474.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   48   40   5.0   40   0.91   12.50  98.026
REMARK  ---------------------------------------------------------- 
MOLECULE 2gpe_D
HEADER    DNA BINDING PROTEIN                     17-APR-06   2GPE              
TITLE     STRUCTURE OF THE DNA-BINDING DOMAIN OF E. COLI PROLINE                
TITLE    2 UTILIZATION A (PUTA)                                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: BIFUNCTIONAL PROTEIN PUTA;                                 
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 FRAGMENT: RESIDUES 1-52;                                             
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: PUTA;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)PLYSS;                            
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PKA8H                                     
KEYWDS    PUTA, RIBBON-HELIX-HELIX, DNA-BINDING DOMAIN, PROLINE                 
KEYWDS   2 CATABOLISM, PROLINE UTILIZATION A                                    
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.L.JENKINS,J.LARSON,J.J.TANNER                                       
REVDAT   1   20-FEB-07 2GPE    0                                                
JRNL        AUTH   J.D.LARSON,J.L.JENKINS,J.P.SCHUERMANN,Y.ZHOU,                
JRNL        AUTH 2 D.F.BECKER,J.J.TANNER                                        
JRNL        TITL   CRYSTAL STRUCTURES OF THE DNA-BINDING DOMAIN OF              
JRNL        TITL 2 ESCHERICHIA COLI PROLINE UTILIZATION A                       
JRNL        TITL 3 FLAVOPROTEIN AND ANALYSIS OF THE ROLE OF LYS9 IN             
JRNL        TITL 4 DNA RECOGNITION.                                             
JRNL        REF    PROTEIN SCI.                  V.  15  2630 2006              
JRNL        REFN   ASTM PRCIEI  US ISSN 0961-8368                               
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  2GPE A    1    52  UNP    P09546   PUTA_ECOLI       1     52             
DBREF  2GPE B    1    52  UNP    P09546   PUTA_ECOLI       1     52             
DBREF  2GPE C    1    52  UNP    P09546   PUTA_ECOLI       1     52             
DBREF  2GPE D    1    52  UNP    P09546   PUTA_ECOLI       1     52             
SEQRES   1 A   52  MET GLY THR THR THR MET GLY VAL LYS LEU ASP ASP ALA          
SEQRES   2 A   52  THR ARG GLU ARG ILE LYS SER ALA ALA THR ARG ILE ASP          
SEQRES   3 A   52  ARG THR PRO HIS TRP LEU ILE LYS GLN ALA ILE PHE SER          
SEQRES   4 A   52  TYR LEU GLU GLN LEU GLU ASN SER ASP THR LEU PRO GLU          
SEQRES   1 B   52  MET GLY THR THR THR MET GLY VAL LYS LEU ASP ASP ALA          
SEQRES   2 B   52  THR ARG GLU ARG ILE LYS SER ALA ALA THR ARG ILE ASP          
SEQRES   3 B   52  ARG THR PRO HIS TRP LEU ILE LYS GLN ALA ILE PHE SER          
SEQRES   4 B   52  TYR LEU GLU GLN LEU GLU ASN SER ASP THR LEU PRO GLU          
SEQRES   1 C   52  MET GLY THR THR THR MET GLY VAL LYS LEU ASP ASP ALA          
SEQRES   2 C   52  THR ARG GLU ARG ILE LYS SER ALA ALA THR ARG ILE ASP          
SEQRES   3 C   52  ARG THR PRO HIS TRP LEU ILE LYS GLN ALA ILE PHE SER          
SEQRES   4 C   52  TYR LEU GLU GLN LEU GLU ASN SER ASP THR LEU PRO GLU          
SEQRES   1 D   52  MET GLY THR THR THR MET GLY VAL LYS LEU ASP ASP ALA          
SEQRES   2 D   52  THR ARG GLU ARG ILE LYS SER ALA ALA THR ARG ILE ASP          
SEQRES   3 D   52  ARG THR PRO HIS TRP LEU ILE LYS GLN ALA ILE PHE SER          
SEQRES   4 D   52  TYR LEU GLU GLN LEU GLU ASN SER ASP THR LEU PRO GLU          
HET    IMD    990       5                                                       
HET    IMD    991       5                                                       
HET    IMD    992       5                                                       
HET    IMD    993       5                                                       
HETNAM     IMD IMIDAZOLE                                                        
FORMUL   5  IMD    4(C3 H5 N2 1+)                                               
FORMUL   9  HOH   *68(H2 O)                                                     
CRYST1   55.731   55.731  125.019  90.00  90.00  90.00 P 41 21 2    32          
ATOM   1118  N   GLY D   2     -18.507 -13.152   3.900  1.00 31.77           N  
ATOM   1119  CA  GLY D   2     -17.389 -14.082   4.223  1.00 31.88           C  
ATOM   1120  C   GLY D   2     -16.147 -13.315   4.614  1.00 32.21           C  
ATOM   1121  O   GLY D   2     -16.165 -12.080   4.633  1.00 32.01           O  
ATOM   1122  N   THR D   3     -15.081 -14.057   4.923  1.00 32.33           N  
ATOM   1123  CA  THR D   3     -13.795 -13.506   5.351  1.00 32.71           C  
ATOM   1124  C   THR D   3     -12.663 -14.126   4.527  1.00 33.00           C  
ATOM   1125  O   THR D   3     -12.724 -15.301   4.168  1.00 32.64           O  
ATOM   1126  CB  THR D   3     -13.561 -13.762   6.860  1.00 32.47           C  
ATOM   1127  OG1 THR D   3     -14.515 -13.014   7.621  1.00 32.72           O  
ATOM   1128  CG2 THR D   3     -12.157 -13.350   7.301  1.00 32.79           C  
ATOM   1129  N   THR D   4     -11.651 -13.323   4.205  1.00 33.34           N  
ATOM   1130  CA  THR D   4     -10.421 -13.839   3.603  1.00 34.04           C  
ATOM   1131  C   THR D   4      -9.205 -13.241   4.289  1.00 34.12           C  
ATOM   1132  O   THR D   4      -9.216 -12.070   4.691  1.00 34.04           O  
ATOM   1133  CB  THR D   4     -10.314 -13.546   2.086  1.00 34.23           C  
ATOM   1134  OG1 THR D   4     -10.347 -12.130   1.859  1.00 35.57           O  
ATOM   1135  CG2 THR D   4     -11.431 -14.233   1.303  1.00 34.10           C  
ATOM   1136  N   THR D   5      -8.169 -14.058   4.440  1.00 34.48           N  
ATOM   1137  CA  THR D   5      -6.882 -13.581   4.906  1.00 34.90           C  
ATOM   1138  C   THR D   5      -6.072 -13.169   3.683  1.00 35.42           C  
ATOM   1139  O   THR D   5      -5.738 -14.006   2.834  1.00 35.43           O  
ATOM   1140  CB  THR D   5      -6.133 -14.647   5.727  1.00 34.94           C  
ATOM   1141  OG1 THR D   5      -6.882 -14.951   6.907  1.00 35.17           O  
ATOM   1142  CG2 THR D   5      -4.756 -14.143   6.140  1.00 35.01           C  
ATOM   1143  N   MET D   6      -5.804 -11.869   3.583  1.00 35.70           N  
ATOM   1144  CA  MET D   6      -4.925 -11.335   2.558  1.00 36.20           C  
ATOM   1145  C   MET D   6      -3.492 -11.348   3.078  1.00 35.70           C  
ATOM   1146  O   MET D   6      -3.220 -10.868   4.175  1.00 36.14           O  
ATOM   1147  CB  MET D   6      -5.314  -9.903   2.198  1.00 35.95           C  
ATOM   1148  CG  MET D   6      -6.629  -9.751   1.476  1.00 37.10           C  
ATOM   1149  SD  MET D   6      -6.378  -8.561   0.150  1.00 38.16           S  
ATOM   1150  CE  MET D   6      -7.885  -7.622   0.227  1.00 36.51           C  
ATOM   1151  N   GLY D   7      -2.585 -11.904   2.286  1.00 35.39           N  
ATOM   1152  CA  GLY D   7      -1.172 -11.900   2.627  1.00 34.92           C  
ATOM   1153  C   GLY D   7      -0.508 -10.615   2.171  1.00 34.46           C  
ATOM   1154  O   GLY D   7      -0.558 -10.266   0.984  1.00 34.52           O  
ATOM   1155  N   VAL D   8       0.104  -9.912   3.121  1.00 33.99           N  
ATOM   1156  CA  VAL D   8       0.850  -8.696   2.815  0.50 33.89           C  
ATOM   1158  C   VAL D   8       2.329  -8.896   3.130  1.00 33.86           C  
ATOM   1159  O   VAL D   8       2.705  -9.201   4.262  1.00 33.53           O  
ATOM   1160  CB  VAL D   8       0.252  -7.421   3.508  0.50 33.94           C  
ATOM   1162  CG1 VAL D   8       0.282  -7.527   5.033  0.50 33.82           C  
ATOM   1164  CG2 VAL D   8       0.962  -6.155   3.034  0.50 34.00           C  
ATOM   1166  N   LYS D   9       3.158  -8.752   2.100  1.00 33.88           N  
ATOM   1167  CA  LYS D   9       4.600  -8.889   2.233  1.00 34.49           C  
ATOM   1168  C   LYS D   9       5.202  -7.538   2.601  1.00 34.73           C  
ATOM   1169  O   LYS D   9       5.082  -6.562   1.853  1.00 34.54           O  
ATOM   1170  CB  LYS D   9       5.209  -9.421   0.931  1.00 34.50           C  
ATOM   1171  N   LEU D  10       5.839  -7.494   3.768  1.00 34.72           N  
ATOM   1172  CA  LEU D  10       6.391  -6.262   4.314  1.00 35.27           C  
ATOM   1173  C   LEU D  10       7.833  -6.519   4.686  1.00 35.19           C  
ATOM   1174  O   LEU D  10       8.175  -7.621   5.142  1.00 35.62           O  
ATOM   1175  CB  LEU D  10       5.626  -5.826   5.568  1.00 34.89           C  
ATOM   1176  CG  LEU D  10       4.143  -5.500   5.424  1.00 36.22           C  
ATOM   1177  CD1 LEU D  10       3.511  -5.350   6.795  1.00 36.32           C  
ATOM   1178  CD2 LEU D  10       3.918  -4.239   4.579  1.00 36.04           C  
ATOM   1179  N   ASP D  11       8.692  -5.527   4.488  1.00 35.26           N  
ATOM   1180  CA  ASP D  11      10.049  -5.695   4.968  1.00 35.26           C  
ATOM   1181  C   ASP D  11      10.030  -5.629   6.492  1.00 35.07           C  
ATOM   1182  O   ASP D  11       9.103  -5.059   7.090  1.00 34.48           O  
ATOM   1183  CB  ASP D  11      11.049  -4.716   4.325  1.00 35.90           C  
ATOM   1184  CG  ASP D  11      10.758  -3.252   4.638  1.00 37.06           C  
ATOM   1185  OD1 ASP D  11       9.836  -2.954   5.430  1.00 38.35           O  
ATOM   1186  OD2 ASP D  11      11.469  -2.388   4.073  1.00 36.86           O  
ATOM   1187  N   ASP D  12      11.034  -6.228   7.121  1.00 34.89           N  
ATOM   1188  CA  ASP D  12      11.070  -6.287   8.575  1.00 35.13           C  
ATOM   1189  C   ASP D  12      11.091  -4.907   9.220  1.00 35.21           C  
ATOM   1190  O   ASP D  12      10.539  -4.739  10.299  1.00 35.13           O  
ATOM   1191  CB  ASP D  12      12.239  -7.151   9.058  1.00 34.87           C  
ATOM   1192  CG  ASP D  12      12.016  -8.624   8.786  1.00 35.26           C  
ATOM   1193  OD1 ASP D  12      10.881  -9.098   8.970  1.00 36.20           O  
ATOM   1194  OD2 ASP D  12      12.966  -9.312   8.377  1.00 36.02           O  
ATOM   1195  N   ALA D  13      11.728  -3.929   8.561  1.00 35.18           N  
ATOM   1196  CA  ALA D  13      11.731  -2.547   9.063  1.00 35.34           C  
ATOM   1197  C   ALA D  13      10.302  -2.002   9.265  1.00 35.58           C  
ATOM   1198  O   ALA D  13       9.981  -1.464  10.328  1.00 35.40           O  
ATOM   1199  CB  ALA D  13      12.562  -1.629   8.151  1.00 35.41           C  
ATOM   1200  N   THR D  14       9.445  -2.172   8.261  1.00 35.49           N  
ATOM   1201  CA  THR D  14       8.034  -1.766   8.347  1.00 35.67           C  
ATOM   1202  C   THR D  14       7.303  -2.514   9.458  1.00 35.80           C  
ATOM   1203  O   THR D  14       6.572  -1.903  10.224  1.00 36.12           O  
ATOM   1204  CB  THR D  14       7.289  -1.982   7.007  1.00 35.21           C  
ATOM   1205  OG1 THR D  14       7.986  -1.286   5.971  1.00 34.93           O  
ATOM   1206  CG2 THR D  14       5.841  -1.479   7.078  1.00 35.69           C  
ATOM   1207  N   ARG D  15       7.506  -3.827   9.531  1.00 35.50           N  
ATOM   1208  CA  ARG D  15       6.933  -4.640  10.594  1.00 35.83           C  
ATOM   1209  C   ARG D  15       7.322  -4.142  12.005  1.00 35.61           C  
ATOM   1210  O   ARG D  15       6.485  -4.148  12.914  1.00 35.42           O  
ATOM   1211  CB  ARG D  15       7.320  -6.105  10.381  1.00 35.79           C  
ATOM   1212  CG  ARG D  15       6.674  -7.082  11.333  1.00 36.98           C  
ATOM   1213  CD  ARG D  15       6.752  -8.492  10.772  1.00 37.56           C  
ATOM   1214  NE  ARG D  15       6.987  -9.493  11.812  1.00 38.71           N  
ATOM   1215  CZ  ARG D  15       8.190  -9.835  12.267  1.00 39.07           C  
ATOM   1216  NH1 ARG D  15       9.281  -9.248  11.784  1.00 39.30           N  
ATOM   1217  NH2 ARG D  15       8.304 -10.762  13.210  1.00 38.29           N  
ATOM   1218  N   GLU D  16       8.578  -3.712  12.174  1.00 36.05           N  
ATOM   1219  CA  GLU D  16       9.055  -3.154  13.466  1.00 35.98           C  
ATOM   1220  C   GLU D  16       8.351  -1.848  13.793  1.00 35.60           C  
ATOM   1221  O   GLU D  16       8.033  -1.607  14.958  1.00 35.00           O  
ATOM   1222  CB  GLU D  16      10.579  -2.926  13.471  1.00 35.73           C  
ATOM   1223  CG  GLU D  16      11.215  -2.506  14.845  1.00 36.12           C  
ATOM   1224  CD  GLU D  16      11.116  -0.997  15.170  1.00 37.08           C  
ATOM   1225  OE1 GLU D  16      10.967  -0.160  14.247  1.00 35.36           O  
ATOM   1226  OE2 GLU D  16      11.205  -0.653  16.369  1.00 38.12           O  
ATOM   1227  N   ARG D  17       8.149  -1.007  12.773  1.00 35.21           N  
ATOM   1228  CA  ARG D  17       7.430   0.255  12.942  1.00 35.28           C  
ATOM   1229  C   ARG D  17       6.004  -0.026  13.367  1.00 35.68           C  
ATOM   1230  O   ARG D  17       5.495   0.631  14.278  1.00 35.78           O  
ATOM   1231  CB  ARG D  17       7.447   1.102  11.666  1.00 34.63           C  
ATOM   1232  CG  ARG D  17       8.796   1.748  11.338  1.00 35.63           C  
ATOM   1233  CD  ARG D  17       8.751   2.447   9.969  1.00 35.61           C  
ATOM   1234  NE  ARG D  17       7.859   3.610   9.980  1.00 36.22           N  
ATOM   1235  CZ  ARG D  17       7.342   4.191   8.895  1.00 36.73           C  
ATOM   1236  NH1 ARG D  17       7.604   3.733   7.675  1.00 35.50           N  
ATOM   1237  NH2 ARG D  17       6.557   5.247   9.037  1.00 36.54           N  
ATOM   1238  N   ILE D  18       5.377  -1.010  12.721  1.00 35.30           N  
ATOM   1239  CA  ILE D  18       4.019  -1.414  13.064  1.00 35.88           C  
ATOM   1240  C   ILE D  18       3.932  -1.898  14.515  1.00 36.21           C  
ATOM   1241  O   ILE D  18       3.054  -1.461  15.263  1.00 36.05           O  
ATOM   1242  CB  ILE D  18       3.454  -2.505  12.118  1.00 35.10           C  
ATOM   1243  CG1 ILE D  18       3.198  -1.937  10.714  1.00 35.20           C  
ATOM   1244  CG2 ILE D  18       2.126  -3.058  12.676  1.00 36.05           C  
ATOM   1245  CD1 ILE D  18       3.187  -2.995   9.611  1.00 35.15           C  
ATOM   1246  N   LYS D  19       4.842  -2.790  14.893  1.00 36.00           N  
ATOM   1247  CA  LYS D  19       4.892  -3.313  16.257  1.00 36.34           C  
ATOM   1248  C   LYS D  19       5.114  -2.221  17.307  1.00 35.95           C  
ATOM   1249  O   LYS D  19       4.445  -2.206  18.338  1.00 35.31           O  
ATOM   1250  CB  LYS D  19       5.974  -4.381  16.370  1.00 36.52           C  
ATOM   1251  CG  LYS D  19       5.546  -5.733  15.841  1.00 36.93           C  
ATOM   1252  CD  LYS D  19       6.767  -6.624  15.656  1.00 38.92           C  
ATOM   1253  CE  LYS D  19       6.451  -8.063  16.034  1.00 37.87           C  
ATOM   1254  NZ  LYS D  19       7.404  -9.003  15.397  1.00 39.63           N  
ATOM   1255  N   SER D  20       6.045  -1.306  17.032  1.00 35.70           N  
ATOM   1256  CA  SER D  20       6.353  -0.225  17.973  1.00 36.14           C  
ATOM   1257  C   SER D  20       5.164   0.721  18.126  1.00 35.47           C  
ATOM   1258  O   SER D  20       4.812   1.115  19.234  1.00 34.45           O  
ATOM   1259  CB  SER D  20       7.594   0.547  17.516  1.00 36.16           C  
ATOM   1260  OG  SER D  20       8.727  -0.296  17.578  1.00 39.11           O  
ATOM   1261  N   ALA D  21       4.537   1.064  17.002  1.00 35.47           N  
ATOM   1262  CA  ALA D  21       3.390   1.961  17.011  1.00 36.05           C  
ATOM   1263  C   ALA D  21       2.177   1.309  17.677  1.00 36.18           C  
ATOM   1264  O   ALA D  21       1.455   1.951  18.448  1.00 36.08           O  
ATOM   1265  CB  ALA D  21       3.056   2.413  15.592  1.00 36.23           C  
ATOM   1266  N   ALA D  22       1.963   0.032  17.377  1.00 36.03           N  
ATOM   1267  CA  ALA D  22       0.849  -0.694  17.951  1.00 36.26           C  
ATOM   1268  C   ALA D  22       1.001  -0.804  19.468  1.00 35.99           C  
ATOM   1269  O   ALA D  22       0.035  -0.570  20.198  1.00 36.30           O  
ATOM   1270  CB  ALA D  22       0.698  -2.064  17.299  1.00 35.91           C  
ATOM   1271  N   THR D  23       2.205  -1.113  19.957  1.00 35.95           N  
ATOM   1272  CA  THR D  23       2.417  -1.179  21.411  1.00 35.91           C  
ATOM   1273  C   THR D  23       2.132   0.156  22.092  1.00 36.28           C  
ATOM   1274  O   THR D  23       1.578   0.189  23.208  1.00 36.22           O  
ATOM   1275  CB  THR D  23       3.840  -1.637  21.788  1.00 35.77           C  
ATOM   1276  OG1 THR D  23       4.103  -2.904  21.184  1.00 35.92           O  
ATOM   1277  CG2 THR D  23       3.976  -1.787  23.294  1.00 35.88           C  
ATOM   1278  N   ARG D  24       2.529   1.246  21.435  1.00 36.13           N  
ATOM   1279  CA  ARG D  24       2.345   2.585  21.985  1.00 36.01           C  
ATOM   1280  C   ARG D  24       0.868   2.942  22.173  1.00 35.99           C  
ATOM   1281  O   ARG D  24       0.519   3.672  23.107  1.00 35.83           O  
ATOM   1282  CB  ARG D  24       3.057   3.636  21.128  1.00 35.90           C  
ATOM   1283  CG  ARG D  24       4.549   3.787  21.437  1.00 36.17           C  
ATOM   1284  CD  ARG D  24       5.258   4.702  20.426  1.00 36.11           C  
ATOM   1285  N   ILE D  25       0.009   2.421  21.296  1.00 35.87           N  
ATOM   1286  CA  ILE D  25      -1.429   2.710  21.360  1.00 35.76           C  
ATOM   1287  C   ILE D  25      -2.225   1.545  21.959  1.00 35.83           C  
ATOM   1288  O   ILE D  25      -3.455   1.574  21.967  1.00 35.29           O  
ATOM   1289  CB  ILE D  25      -2.019   3.123  19.966  1.00 35.84           C  
ATOM   1290  CG1 ILE D  25      -1.766   2.042  18.907  1.00 35.99           C  
ATOM   1291  CG2 ILE D  25      -1.479   4.501  19.525  1.00 35.62           C  
ATOM   1292  CD1 ILE D  25      -2.540   2.242  17.589  1.00 35.65           C  
ATOM   1293  N   ASP D  26      -1.517   0.525  22.459  1.00 36.15           N  
ATOM   1294  CA  ASP D  26      -2.162  -0.651  23.079  1.00 36.20           C  
ATOM   1295  C   ASP D  26      -3.172  -1.310  22.122  1.00 36.14           C  
ATOM   1296  O   ASP D  26      -4.338  -1.552  22.476  1.00 36.25           O  
ATOM   1297  CB  ASP D  26      -2.843  -0.276  24.405  1.00 36.03           C  
ATOM   1298  CG  ASP D  26      -3.143  -1.491  25.289  1.00 36.49           C  
ATOM   1299  OD1 ASP D  26      -2.510  -2.557  25.102  1.00 33.82           O  
ATOM   1300  OD2 ASP D  26      -4.004  -1.369  26.200  1.00 37.65           O  
ATOM   1301  N   ARG D  27      -2.708  -1.578  20.907  1.00 36.04           N  
ATOM   1302  CA  ARG D  27      -3.474  -2.298  19.895  1.00 36.03           C  
ATOM   1303  C   ARG D  27      -2.583  -3.409  19.332  1.00 36.29           C  
ATOM   1304  O   ARG D  27      -1.355  -3.380  19.511  1.00 35.98           O  
ATOM   1305  CB  ARG D  27      -3.924  -1.338  18.767  1.00 36.17           C  
ATOM   1306  CG  ARG D  27      -4.980  -0.275  19.180  1.00 36.02           C  
ATOM   1307  CD  ARG D  27      -6.310  -0.924  19.616  1.00 38.13           C  
ATOM   1308  NE  ARG D  27      -7.371   0.041  19.922  1.00 37.47           N  
ATOM   1309  CZ  ARG D  27      -7.564   0.614  21.110  1.00 38.82           C  
ATOM   1310  NH1 ARG D  27      -6.764   0.343  22.141  1.00 37.78           N  
ATOM   1311  NH2 ARG D  27      -8.563   1.478  21.268  1.00 38.91           N  
ATOM   1312  N   THR D  28      -3.189  -4.399  18.678  1.00 35.83           N  
ATOM   1313  CA  THR D  28      -2.413  -5.457  18.044  1.00 35.91           C  
ATOM   1314  C   THR D  28      -1.877  -4.938  16.706  1.00 35.94           C  
ATOM   1315  O   THR D  28      -2.485  -4.028  16.102  1.00 35.88           O  
ATOM   1316  CB  THR D  28      -3.241  -6.741  17.810  1.00 35.76           C  
ATOM   1317  OG1 THR D  28      -4.296  -6.442  16.895  1.00 35.50           O  
ATOM   1318  CG2 THR D  28      -3.831  -7.260  19.126  1.00 35.19           C  
ATOM   1319  N   PRO D  29      -0.719  -5.463  16.253  1.00 36.01           N  
ATOM   1320  CA  PRO D  29      -0.265  -5.135  14.895  1.00 36.10           C  
ATOM   1321  C   PRO D  29      -1.334  -5.377  13.818  1.00 36.09           C  
ATOM   1322  O   PRO D  29      -1.457  -4.576  12.875  1.00 36.09           O  
ATOM   1323  CB  PRO D  29       0.934  -6.069  14.702  1.00 35.81           C  
ATOM   1324  CG  PRO D  29       1.478  -6.222  16.071  1.00 35.91           C  
ATOM   1325  CD  PRO D  29       0.261  -6.314  16.955  1.00 36.74           C  
ATOM   1326  N   HIS D  30      -2.092  -6.464  13.958  1.00 35.73           N  
ATOM   1327  CA  HIS D  30      -3.201  -6.775  13.043  1.00 35.53           C  
ATOM   1328  C   HIS D  30      -4.272  -5.668  13.045  1.00 35.50           C  
ATOM   1329  O   HIS D  30      -4.716  -5.233  11.979  1.00 34.30           O  
ATOM   1330  CB  HIS D  30      -3.841  -8.121  13.404  1.00 35.18           C  
ATOM   1331  CG  HIS D  30      -4.936  -8.541  12.470  1.00 35.52           C  
ATOM   1332  ND1 HIS D  30      -6.269  -8.288  12.715  1.00 34.78           N  
ATOM   1333  CD2 HIS D  30      -4.891  -9.183  11.279  1.00 35.09           C  
ATOM   1334  CE1 HIS D  30      -6.996  -8.759  11.721  1.00 35.14           C  
ATOM   1335  NE2 HIS D  30      -6.185  -9.309  10.837  1.00 35.84           N  
ATOM   1336  N   TRP D  31      -4.675  -5.226  14.241  1.00 35.35           N  
ATOM   1337  CA  TRP D  31      -5.644  -4.131  14.372  1.00 35.45           C  
ATOM   1338  C   TRP D  31      -5.144  -2.864  13.642  1.00 35.32           C  
ATOM   1339  O   TRP D  31      -5.897  -2.217  12.905  1.00 34.70           O  
ATOM   1340  CB  TRP D  31      -5.963  -3.847  15.856  1.00 35.59           C  
ATOM   1341  CG  TRP D  31      -7.060  -2.827  16.032  1.00 36.47           C  
ATOM   1342  CD1 TRP D  31      -8.387  -3.077  16.253  1.00 36.61           C  
ATOM   1343  CD2 TRP D  31      -6.927  -1.395  15.965  1.00 36.06           C  
ATOM   1344  NE1 TRP D  31      -9.087  -1.891  16.334  1.00 35.40           N  
ATOM   1345  CE2 TRP D  31      -8.216  -0.846  16.163  1.00 36.32           C  
ATOM   1346  CE3 TRP D  31      -5.843  -0.523  15.775  1.00 36.35           C  
ATOM   1347  CZ2 TRP D  31      -8.451   0.535  16.164  1.00 36.57           C  
ATOM   1348  CZ3 TRP D  31      -6.083   0.854  15.769  1.00 35.67           C  
ATOM   1349  CH2 TRP D  31      -7.374   1.364  15.971  1.00 36.40           C  
ATOM   1350  N   LEU D  32      -3.871  -2.535  13.846  1.00 35.19           N  
ATOM   1351  CA  LEU D  32      -3.252  -1.356  13.250  1.00 35.30           C  
ATOM   1352  C   LEU D  32      -3.287  -1.436  11.728  1.00 35.34           C  
ATOM   1353  O   LEU D  32      -3.666  -0.464  11.064  1.00 35.56           O  
ATOM   1354  CB  LEU D  32      -1.826  -1.214  13.793  1.00 35.49           C  
ATOM   1355  CG  LEU D  32      -0.620  -0.377  13.331  1.00 36.27           C  
ATOM   1356  CD1 LEU D  32      -0.652   0.152  11.905  1.00 37.59           C  
ATOM   1357  CD2 LEU D  32      -0.213   0.698  14.346  1.00 35.14           C  
ATOM   1358  N   ILE D  33      -2.922  -2.587  11.164  1.00 35.39           N  
ATOM   1359  CA  ILE D  33      -3.011  -2.754   9.696  1.00 35.95           C  
ATOM   1360  C   ILE D  33      -4.461  -2.588   9.190  1.00 36.37           C  
ATOM   1361  O   ILE D  33      -4.714  -1.891   8.188  1.00 36.09           O  
ATOM   1362  CB  ILE D  33      -2.415  -4.096   9.234  1.00 35.92           C  
ATOM   1363  CG1 ILE D  33      -0.900  -4.103   9.504  1.00 36.10           C  
ATOM   1364  CG2 ILE D  33      -2.744  -4.356   7.744  1.00 35.54           C  
ATOM   1365  CD1 ILE D  33      -0.235  -5.465   9.376  1.00 37.75           C  
ATOM   1366  N   LYS D  34      -5.408  -3.192   9.894  1.00 36.02           N  
ATOM   1367  CA  LYS D  34      -6.808  -3.080   9.503  1.00 36.11           C  
ATOM   1368  C   LYS D  34      -7.284  -1.627   9.551  1.00 36.11           C  
ATOM   1369  O   LYS D  34      -7.978  -1.162   8.634  1.00 36.10           O  
ATOM   1370  CB  LYS D  34      -7.699  -3.978  10.361  1.00 36.11           C  
ATOM   1371  CG  LYS D  34      -7.888  -5.370   9.784  1.00 36.23           C  
ATOM   1372  CD  LYS D  34      -8.886  -6.211  10.573  1.00 37.38           C  
ATOM   1373  CE  LYS D  34     -10.330  -5.872  10.248  1.00 37.08           C  
ATOM   1374  NZ  LYS D  34     -11.240  -6.992  10.610  1.00 39.52           N  
ATOM   1375  N   GLN D  35      -6.920  -0.913  10.620  1.00 35.63           N  
ATOM   1376  CA  GLN D  35      -7.298   0.494  10.771  1.00 35.66           C  
ATOM   1377  C   GLN D  35      -6.685   1.362   9.662  1.00 35.46           C  
ATOM   1378  O   GLN D  35      -7.340   2.267   9.122  1.00 34.80           O  
ATOM   1379  CB  GLN D  35      -6.885   1.017  12.149  1.00 35.92           C  
ATOM   1380  CG  GLN D  35      -7.370   2.426  12.448  1.00 37.40           C  
ATOM   1381  CD  GLN D  35      -8.884   2.563  12.365  1.00 40.05           C  
ATOM   1382  OE1 GLN D  35      -9.629   1.726  12.880  1.00 40.48           O  
ATOM   1383  NE2 GLN D  35      -9.344   3.621  11.704  1.00 41.57           N  
ATOM   1384  N   ALA D  36      -5.424   1.085   9.350  1.00 35.55           N  
ATOM   1385  CA  ALA D  36      -4.703   1.750   8.265  1.00 35.29           C  
ATOM   1386  C   ALA D  36      -5.461   1.586   6.937  1.00 35.20           C  
ATOM   1387  O   ALA D  36      -5.657   2.569   6.208  1.00 34.43           O  
ATOM   1388  CB  ALA D  36      -3.269   1.201   8.162  1.00 35.24           C  
ATOM   1389  N   ILE D  37      -5.896   0.354   6.644  1.00 35.22           N  
ATOM   1390  CA  ILE D  37      -6.718   0.061   5.453  1.00 35.13           C  
ATOM   1391  C   ILE D  37      -8.045   0.827   5.449  1.00 35.22           C  
ATOM   1392  O   ILE D  37      -8.396   1.440   4.444  1.00 34.56           O  
ATOM   1393  CB  ILE D  37      -6.978  -1.468   5.275  1.00 35.01           C  
ATOM   1394  CG1 ILE D  37      -5.666  -2.192   4.916  1.00 34.98           C  
ATOM   1395  CG2 ILE D  37      -8.051  -1.709   4.230  1.00 35.49           C  
ATOM   1396  CD1 ILE D  37      -5.679  -3.728   5.115  1.00 34.57           C  
ATOM   1397  N   PHE D  38      -8.774   0.796   6.566  1.00 35.00           N  
ATOM   1398  CA  PHE D  38     -10.051   1.518   6.655  1.00 35.68           C  
ATOM   1399  C   PHE D  38      -9.869   3.024   6.467  1.00 36.06           C  
ATOM   1400  O   PHE D  38     -10.646   3.653   5.753  1.00 36.08           O  
ATOM   1401  CB  PHE D  38     -10.775   1.228   7.972  1.00 35.51           C  
ATOM   1402  CG  PHE D  38     -11.262  -0.188   8.104  1.00 35.82           C  
ATOM   1403  CD1 PHE D  38     -11.923  -0.819   7.052  1.00 37.18           C  
ATOM   1404  CD2 PHE D  38     -11.094  -0.885   9.302  1.00 36.80           C  
ATOM   1405  CE1 PHE D  38     -12.386  -2.135   7.186  1.00 37.22           C  
ATOM   1406  CE2 PHE D  38     -11.550  -2.191   9.441  1.00 38.03           C  
ATOM   1407  CZ  PHE D  38     -12.195  -2.818   8.373  1.00 37.61           C  
ATOM   1408  N   SER D  39      -8.843   3.582   7.114  1.00 35.79           N  
ATOM   1409  CA  SER D  39      -8.558   5.017   7.039  0.50 35.66           C  
ATOM   1411  C   SER D  39      -8.246   5.432   5.610  1.00 35.84           C  
ATOM   1412  O   SER D  39      -8.787   6.429   5.107  1.00 35.85           O  
ATOM   1413  CB  SER D  39      -7.385   5.397   7.953  0.50 35.58           C  
ATOM   1415  OG  SER D  39      -7.089   6.787   7.861  0.50 34.92           O  
ATOM   1417  N   TYR D  40      -7.366   4.668   4.961  1.00 35.59           N  
ATOM   1418  CA  TYR D  40      -6.963   4.987   3.614  1.00 35.93           C  
ATOM   1419  C   TYR D  40      -8.132   4.868   2.649  1.00 35.76           C  
ATOM   1420  O   TYR D  40      -8.294   5.716   1.776  1.00 35.08           O  
ATOM   1421  CB  TYR D  40      -5.799   4.106   3.172  1.00 35.93           C  
ATOM   1422  CG  TYR D  40      -5.131   4.576   1.908  1.00 36.32           C  
ATOM   1423  CD1 TYR D  40      -4.509   5.826   1.840  1.00 37.69           C  
ATOM   1424  CD2 TYR D  40      -5.090   3.759   0.783  1.00 36.36           C  
ATOM   1425  CE1 TYR D  40      -3.879   6.257   0.664  1.00 37.69           C  
ATOM   1426  CE2 TYR D  40      -4.466   4.177  -0.391  1.00 36.25           C  
ATOM   1427  CZ  TYR D  40      -3.867   5.423  -0.448  1.00 36.73           C  
ATOM   1428  OH  TYR D  40      -3.249   5.819  -1.615  1.00 37.16           O  
ATOM   1429  N   LEU D  41      -8.931   3.808   2.790  1.00 35.36           N  
ATOM   1430  CA  LEU D  41     -10.121   3.648   1.937  1.00 35.53           C  
ATOM   1431  C   LEU D  41     -11.136   4.783   2.108  1.00 35.58           C  
ATOM   1432  O   LEU D  41     -11.735   5.243   1.132  1.00 34.94           O  
ATOM   1433  CB  LEU D  41     -10.810   2.309   2.181  1.00 35.52           C  
ATOM   1434  CG  LEU D  41     -10.139   1.033   1.679  1.00 35.06           C  
ATOM   1435  CD1 LEU D  41     -10.938  -0.157   2.191  1.00 34.74           C  
ATOM   1436  CD2 LEU D  41     -10.052   1.029   0.158  1.00 35.19           C  
ATOM   1437  N   GLU D  42     -11.334   5.229   3.344  1.00 35.35           N  
ATOM   1438  CA  GLU D  42     -12.187   6.396   3.596  1.00 35.94           C  
ATOM   1439  C   GLU D  42     -11.650   7.640   2.872  1.00 35.79           C  
ATOM   1440  O   GLU D  42     -12.433   8.428   2.318  1.00 35.40           O  
ATOM   1441  CB  GLU D  42     -12.313   6.662   5.105  1.00 35.57           C  
ATOM   1442  CG  GLU D  42     -13.367   7.691   5.483  1.00 37.03           C  
ATOM   1443  CD  GLU D  42     -13.226   8.164   6.917  1.00 37.06           C  
ATOM   1444  OE1 GLU D  42     -14.082   7.798   7.753  1.00 38.95           O  
ATOM   1445  OE2 GLU D  42     -12.255   8.895   7.213  1.00 38.75           O  
ATOM   1446  N   GLN D  43     -10.324   7.803   2.877  1.00 35.44           N  
ATOM   1447  CA  GLN D  43      -9.661   8.941   2.218  1.00 35.72           C  
ATOM   1448  C   GLN D  43      -9.865   8.911   0.714  1.00 35.60           C  
ATOM   1449  O   GLN D  43     -10.178   9.942   0.110  1.00 35.97           O  
ATOM   1450  CB  GLN D  43      -8.157   8.975   2.531  1.00 35.09           C  
ATOM   1451  CG  GLN D  43      -7.823   9.549   3.896  1.00 36.31           C  
ATOM   1452  CD  GLN D  43      -6.406   9.235   4.342  1.00 37.53           C  
ATOM   1453  OE1 GLN D  43      -5.480   9.193   3.532  1.00 38.48           O  
ATOM   1454  NE2 GLN D  43      -6.230   9.023   5.641  1.00 38.08           N  
ATOM   1455  N   LEU D  44      -9.688   7.730   0.125  1.00 35.39           N  
ATOM   1456  CA  LEU D  44      -9.819   7.545  -1.330  1.00 35.55           C  
ATOM   1457  C   LEU D  44     -11.264   7.714  -1.775  1.00 35.53           C  
ATOM   1458  O   LEU D  44     -11.532   8.272  -2.838  1.00 35.47           O  
ATOM   1459  CB  LEU D  44      -9.320   6.154  -1.770  1.00 35.03           C  
ATOM   1460  CG  LEU D  44      -7.826   5.785  -1.707  1.00 35.45           C  
ATOM   1461  CD1 LEU D  44      -7.630   4.292  -1.922  1.00 35.09           C  
ATOM   1462  CD2 LEU D  44      -6.970   6.564  -2.704  1.00 34.52           C  
ATOM   1463  N   GLU D  45     -12.188   7.214  -0.955  1.00 35.57           N  
ATOM   1464  CA  GLU D  45     -13.613   7.204  -1.294  1.00 35.71           C  
ATOM   1465  C   GLU D  45     -14.338   8.520  -0.991  1.00 35.19           C  
ATOM   1466  O   GLU D  45     -15.396   8.781  -1.574  1.00 35.47           O  
ATOM   1467  CB  GLU D  45     -14.327   6.025  -0.607  1.00 35.57           C  
ATOM   1468  CG  GLU D  45     -13.822   4.641  -1.046  1.00 36.69           C  
ATOM   1469  CD  GLU D  45     -14.401   3.487  -0.235  1.00 36.48           C  
ATOM   1470  OE1 GLU D  45     -14.188   2.316  -0.632  1.00 37.31           O  
ATOM   1471  OE2 GLU D  45     -15.081   3.734   0.786  1.00 39.02           O  
ATOM   1472  N   ASN D  46     -13.801   9.329  -0.079  1.00 34.99           N  
ATOM   1473  CA  ASN D  46     -14.415  10.618   0.258  1.00 34.58           C  
ATOM   1474  C   ASN D  46     -13.958  11.728  -0.677  1.00 34.44           C  
ATOM   1475  O   ASN D  46     -12.813  12.174  -0.607  1.00 34.40           O  
ATOM   1476  CB  ASN D  46     -14.134  11.009   1.710  1.00 34.64           C  
ATOM   1477  N   SER D  47     -14.863  12.166  -1.546  1.00 34.11           N  
ATOM   1478  CA  SER D  47     -14.569  13.207  -2.522  1.00 33.84           C  
ATOM   1479  C   SER D  47     -15.129  14.564  -2.089  1.00 33.67           C  
ATOM   1480  O   SER D  47     -15.182  15.501  -2.889  1.00 33.67           O  
ATOM   1481  CB  SER D  47     -15.123  12.811  -3.895  1.00 33.81           C  
ATOM   1482  N   ASP D  48     -15.521  14.665  -0.817  1.00 33.40           N  
ATOM   1483  CA  ASP D  48     -16.148  15.877  -0.261  1.00 33.16           C  
ATOM   1484  C   ASP D  48     -15.231  17.103  -0.268  1.00 33.01           C  
ATOM   1485  O   ASP D  48     -15.703  18.242  -0.268  1.00 32.91           O  
ATOM   1486  CB  ASP D  48     -16.637  15.620   1.170  1.00 33.06           C  
ATOM   1487  CG  ASP D  48     -17.591  14.440   1.265  1.00 33.08           C  
ATOM   1488  OD1 ASP D  48     -18.423  14.257   0.350  1.00 32.86           O  
ATOM   1489  OD2 ASP D  48     -17.514  13.700   2.268  1.00 33.28           O  
ATOM   1490  N   THR D  49     -13.924  16.851  -0.278  1.00 32.82           N  
ATOM   1491  CA  THR D  49     -12.905  17.896  -0.179  1.00 32.70           C  
ATOM   1492  C   THR D  49     -12.592  18.574  -1.520  1.00 32.53           C  
ATOM   1493  O   THR D  49     -13.437  18.652  -2.414  1.00 32.26           O  
ATOM   1494  CB  THR D  49     -11.607  17.335   0.456  1.00 32.63           C  
ATOM   1495  OG1 THR D  49     -10.671  18.395   0.675  1.00 32.74           O  
ATOM   1496  CG2 THR D  49     -10.973  16.266  -0.434  1.00 32.92           C  
TER    1497      THR D  49                                                      
END
MOLECULE T0474.pdb
ATOM    111  N   MET     9     -15.513 -13.396   6.798  1.00  1.00
ATOM    112  HN  MET     9     -15.434 -14.281   7.279  1.00  0.00
ATOM    113  CA  MET     9     -14.325 -12.543   6.707  1.00  1.00
ATOM    114  HA  MET     9     -14.565 -11.671   6.099  1.00  0.00
ATOM    115  CB  MET     9     -13.908 -12.081   8.105  1.00  1.00
ATOM    116 2HB  MET     9     -13.830 -12.945   8.766  1.00  0.00
ATOM    117 3HB  MET     9     -12.943 -11.578   8.049  1.00  0.00
ATOM    118  CG  MET     9     -14.958 -11.112   8.652  1.00  1.00
ATOM    119 2HG  MET     9     -15.026 -10.238   8.004  1.00  0.00
ATOM    120 3HG  MET     9     -15.932 -11.601   8.683  1.00  0.00
ATOM    121  SD  MET     9     -14.493 -10.590  10.321  1.00  1.00
ATOM    122  CE  MET     9     -13.435  -9.204   9.838  1.00  1.00
ATOM    123 1HE  MET     9     -13.039  -8.735  10.739  1.00  0.00
ATOM    124 2HE  MET     9     -12.614  -9.570   9.222  1.00  0.00
ATOM    125 3HE  MET     9     -14.020  -8.479   9.272  1.00  0.00
ATOM    126  C   MET     9     -13.176 -13.302   6.057  1.00  1.00
ATOM    127  O   MET     9     -12.801 -14.387   6.505  1.00  1.00
ATOM    128  N   GLY    10     -12.622 -12.725   4.996  1.00  1.00
ATOM    129  HN  GLY    10     -12.966 -11.834   4.669  1.00  0.00
ATOM    130  CA  GLY    10     -11.516 -13.351   4.281  1.00  1.00
ATOM    131 1HA  GLY    10     -11.622 -14.435   4.333  1.00  0.00
ATOM    132 2HA  GLY    10     -11.539 -13.037   3.238  1.00  0.00
ATOM    133  C   GLY    10     -10.188 -12.947   4.897  1.00  1.00
ATOM    134  O   GLY    10     -10.149 -12.229   5.897  1.00  1.00
ATOM    135  N   ARG    11      -9.096 -13.412   4.297  1.00  1.00
ATOM    136  HN  ARG    11      -9.181 -14.000   3.480  1.00  0.00
ATOM    137  CA  ARG    11      -7.763 -13.096   4.791  1.00  1.00
ATOM    138  HA  ARG    11      -7.806 -12.157   5.342  1.00  0.00
ATOM    139  CB  ARG    11      -7.286 -14.202   5.726  1.00  1.00
ATOM    140 2HB  ARG    11      -6.291 -13.959   6.097  1.00  0.00
ATOM    141 3HB  ARG    11      -7.976 -14.289   6.566  1.00  0.00
ATOM    142  CG  ARG    11      -7.236 -15.532   4.970  1.00  1.00
ATOM    143 2HG  ARG    11      -8.221 -15.755   4.560  1.00  0.00
ATOM    144 3HG  ARG    11      -6.512 -15.462   4.158  1.00  0.00
ATOM    145  CD  ARG    11      -6.820 -16.647   5.930  1.00  1.00
ATOM    146 2HD  ARG    11      -5.842 -16.415   6.352  1.00  0.00
ATOM    147 3HD  ARG    11      -7.550 -16.721   6.737  1.00  0.00
ATOM    148  NE  ARG    11      -6.752 -17.919   5.222  1.00  1.00
ATOM    149  HE  ARG    11      -6.699 -17.908   4.213  1.00  0.00
ATOM    150  CZ  ARG    11      -6.759 -19.073   5.880  1.00  1.00
ATOM    151  NH1 ARG    11      -6.698 -20.199   5.223  1.00  1.00
ATOM    152 1HH1 ARG    11      -6.704 -21.076   5.725  1.00  0.00
ATOM    153 2HH1 ARG    11      -6.645 -20.194   4.214  1.00  0.00
ATOM    154  NH2 ARG    11      -6.828 -19.081   7.183  1.00  1.00
ATOM    155 1HH2 ARG    11      -6.834 -19.960   7.681  1.00  0.00
ATOM    156 2HH2 ARG    11      -6.876 -18.210   7.692  1.00  0.00
ATOM    157  C   ARG    11      -6.786 -12.948   3.631  1.00  1.00
ATOM    158  O   ARG    11      -6.886 -13.656   2.628  1.00  1.00
ATOM    159  N   ILE    12      -5.838 -12.024   3.774  1.00  1.00
ATOM    160  HN  ILE    12      -5.799 -11.470   4.618  1.00  0.00
ATOM    161  CA  ILE    12      -4.836 -11.783   2.734  1.00  1.00
ATOM    162  HA  ILE    12      -4.856 -12.613   2.027  1.00  0.00
ATOM    163  CB  ILE    12      -5.149 -10.485   1.993  1.00  1.00
ATOM    164  HB  ILE    12      -5.211  -9.665   2.708  1.00  0.00
ATOM    165  CG2 ILE    12      -4.041 -10.193   0.977  1.00  1.00
ATOM    166 1HG2 ILE    12      -4.265  -9.266   0.450  1.00  0.00
ATOM    167 2HG2 ILE    12      -3.089 -10.095   1.497  1.00  0.00
ATOM    168 3HG2 ILE    12      -3.981 -11.012   0.260  1.00  0.00
ATOM    169  CG1 ILE    12      -6.487 -10.626   1.261  1.00  1.00
ATOM    170 2HG1 ILE    12      -6.369 -11.306   0.417  1.00  0.00
ATOM    171 3HG1 ILE    12      -7.235 -11.025   1.946  1.00  0.00
ATOM    172  CD1 ILE    12      -6.941  -9.258   0.753  1.00  1.00
ATOM    173 1HD1 ILE    12      -7.893  -9.361   0.231  1.00  0.00
ATOM    174 2HD1 ILE    12      -7.061  -8.579   1.597  1.00  0.00
ATOM    175 3HD1 ILE    12      -6.193  -8.859   0.068  1.00  0.00
ATOM    176  C   ILE    12      -3.449 -11.685   3.354  1.00  1.00
ATOM    177  O   ILE    12      -3.297 -11.280   4.502  1.00  1.00
ATOM    178  N   LEU    13      -2.441 -12.058   2.581  1.00  1.00
ATOM    179  HN  LEU    13      -2.622 -12.381   1.641  1.00  0.00
ATOM    180  CA  LEU    13      -1.058 -12.018   3.047  1.00  1.00
ATOM    181  HA  LEU    13      -1.049 -12.131   4.131  1.00  0.00
ATOM    182  CB  LEU    13      -0.268 -13.170   2.414  1.00  1.00
ATOM    183 2HB  LEU    13      -0.546 -13.261   1.364  1.00  0.00
ATOM    184 3HB  LEU    13       0.798 -12.958   2.491  1.00  0.00
ATOM    185  CG  LEU    13      -0.573 -14.493   3.133  1.00  1.00
ATOM    186  HG  LEU    13      -1.612 -14.492   3.464  1.00  0.00
ATOM    187  CD1 LEU    13      -0.343 -15.669   2.177  1.00  1.00
ATOM    188 1HD1 LEU    13      -0.564 -16.606   2.689  1.00  0.00
ATOM    189 2HD1 LEU    13      -0.998 -15.567   1.311  1.00  0.00
ATOM    190 3HD1 LEU    13       0.696 -15.672   1.848  1.00  0.00
ATOM    191  CD2 LEU    13       0.352 -14.655   4.350  1.00  1.00
ATOM    192 1HD2 LEU    13       0.128 -15.594   4.858  1.00  0.00
ATOM    193 2HD2 LEU    13       1.390 -14.661   4.018  1.00  0.00
ATOM    194 3HD2 LEU    13       0.195 -13.825   5.038  1.00  0.00
ATOM    195  C   LEU    13      -0.412 -10.701   2.682  1.00  1.00
ATOM    196  O   LEU    13      -0.703 -10.115   1.639  1.00  1.00
ATOM    197  N   LEU    14       0.467 -10.241   3.563  1.00  1.00
ATOM    198  HN  LEU    14       0.663 -10.769   4.402  1.00  0.00
ATOM    199  CA  LEU    14       1.169  -8.980   3.354  1.00  1.00
ATOM    200  HA  LEU    14       0.935  -8.615   2.354  1.00  0.00
ATOM    201  CB  LEU    14       0.683  -7.948   4.388  1.00  1.00
ATOM    202 2HB  LEU    14       0.127  -8.462   5.173  1.00  0.00
ATOM    203 3HB  LEU    14       1.545  -7.444   4.824  1.00  0.00
ATOM    204  CG  LEU    14      -0.224  -6.911   3.726  1.00  1.00
ATOM    205  HG  LEU    14      -0.583  -6.216   4.485  1.00  0.00
ATOM    206  CD1 LEU    14       0.576  -6.113   2.661  1.00  1.00
ATOM    207 1HD1 LEU    14      -0.074  -5.370   2.199  1.00  0.00
ATOM    208 2HD1 LEU    14       1.417  -5.612   3.139  1.00  0.00
ATOM    209 3HD1 LEU    14       0.946  -6.797   1.897  1.00  0.00
ATOM    210  CD2 LEU    14      -1.438  -7.627   3.095  1.00  1.00
ATOM    211 1HD2 LEU    14      -2.095  -6.890   2.633  1.00  0.00
ATOM    212 2HD2 LEU    14      -1.092  -8.331   2.337  1.00  0.00
ATOM    213 3HD2 LEU    14      -1.985  -8.167   3.869  1.00  0.00
ATOM    214  C   LEU    14       2.679  -9.170   3.464  1.00  1.00
ATOM    215  O   LEU    14       3.182  -9.797   4.399  1.00  1.00
ATOM    216  N   ASP    15       3.393  -8.610   2.493  1.00  1.00
ATOM    217  HN  ASP    15       2.926  -8.109   1.751  1.00  0.00
ATOM    218  CA  ASP    15       4.851  -8.698   2.462  1.00  1.00
ATOM    219  HA  ASP    15       5.173  -9.440   3.193  1.00  0.00
ATOM    220  CB  ASP    15       5.315  -9.130   1.075  1.00  1.00
ATOM    221 2HB  ASP    15       4.890  -8.463   0.325  1.00  0.00
ATOM    222 3HB  ASP    15       6.402  -9.082   1.024  1.00  0.00
ATOM    223  CG  ASP    15       4.857 -10.559   0.802  1.00  1.00
ATOM    224  OD1 ASP    15       4.446 -11.217   1.744  1.00  1.00
ATOM    225  OD2 ASP    15       4.921 -10.972  -0.343  1.00  1.00
ATOM    226 2HD  ASP    15       4.616 -11.877  -0.440  1.00  0.00
ATOM    227  C   ASP    15       5.475  -7.350   2.811  1.00  1.00
ATOM    228  O   ASP    15       5.377  -6.390   2.043  1.00  1.00
ATOM    229  N   LEU    16       6.122  -7.285   3.974  1.00  1.00
ATOM    230  HN  LEU    16       6.173  -8.102   4.566  1.00  0.00
ATOM    231  CA  LEU    16       6.771  -6.053   4.430  1.00  1.00
ATOM    232  HA  LEU    16       6.836  -5.363   3.589  1.00  0.00
ATOM    233  CB  LEU    16       5.942  -5.405   5.542  1.00  1.00
ATOM    234 2HB  LEU    16       5.703  -6.152   6.299  1.00  0.00
ATOM    235 3HB  LEU    16       6.514  -4.597   5.997  1.00  0.00
ATOM    236  CG  LEU    16       4.641  -4.842   4.951  1.00  1.00
ATOM    237  HG  LEU    16       4.182  -5.600   4.316  1.00  0.00
ATOM    238  CD1 LEU    16       3.679  -4.488   6.091  1.00  1.00
ATOM    239 1HD1 LEU    16       2.748  -4.100   5.676  1.00  0.00
ATOM    240 2HD1 LEU    16       3.469  -5.382   6.679  1.00  0.00
ATOM    241 3HD1 LEU    16       4.135  -3.732   6.729  1.00  0.00
ATOM    242  CD2 LEU    16       4.924  -3.580   4.103  1.00  1.00
ATOM    243 1HD2 LEU    16       3.991  -3.197   3.688  1.00  0.00
ATOM    244 2HD2 LEU    16       5.380  -2.816   4.732  1.00  0.00
ATOM    245 3HD2 LEU    16       5.603  -3.835   3.290  1.00  0.00
ATOM    246  C   LEU    16       8.175  -6.345   4.937  1.00  1.00
ATOM    247  O   LEU    16       8.442  -7.414   5.487  1.00  1.00
ATOM    248  N   SER    17       9.070  -5.384   4.746  1.00  1.00
ATOM    249  HN  SER    17       8.799  -4.524   4.291  1.00  0.00
ATOM    250  CA  SER    17      10.447  -5.538   5.181  1.00  1.00
ATOM    251  HA  SER    17      10.846  -6.462   4.762  1.00  0.00
ATOM    252  CB  SER    17      11.284  -4.360   4.677  1.00  1.00
ATOM    253 2HB  SER    17      10.709  -3.439   4.771  1.00  0.00
ATOM    254 3HB  SER    17      12.196  -4.282   5.269  1.00  0.00
ATOM    255  OG  SER    17      11.621  -4.572   3.312  1.00  1.00
ATOM    256  HG  SER    17      12.145  -3.827   3.009  1.00  0.00
ATOM    257  C   SER    17      10.515  -5.614   6.703  1.00  1.00
ATOM    258  O   SER    17       9.580  -5.216   7.397  1.00  1.00
ATOM    259  N   ASN    18      11.626  -6.130   7.212  1.00  1.00
ATOM    260  HN  ASN    18      12.366  -6.443   6.600  1.00  0.00
ATOM    261  CA  ASN    18      11.809  -6.259   8.652  1.00  1.00
ATOM    262  HA  ASN    18      10.994  -6.860   9.056  1.00  0.00
ATOM    263  CB  ASN    18      13.138  -6.955   8.951  1.00  1.00
ATOM    264 2HB  ASN    18      13.934  -6.476   8.382  1.00  0.00
ATOM    265 3HB  ASN    18      13.359  -6.873  10.015  1.00  0.00
ATOM    266  CG  ASN    18      13.053  -8.428   8.564  1.00  1.00
ATOM    267  OD1 ASN    18      12.406  -9.215   9.254  1.00  1.00
ATOM    268  ND2 ASN    18      13.669  -8.848   7.493  1.00  1.00
ATOM    269 1HD2 ASN    18      14.192  -8.183   6.941  1.00  0.00
ATOM    270 2HD2 ASN    18      13.620  -9.821   7.224  1.00  0.00
ATOM    271  C   ASN    18      11.791  -4.887   9.318  1.00  1.00
ATOM    272  O   ASN    18      11.239  -4.722  10.405  1.00  1.00
ATOM    273  N   GLU    19      12.397  -3.906   8.659  1.00  1.00
ATOM    274  HN  GLU    19      12.835  -4.089   7.767  1.00  0.00
ATOM    275  CA  GLU    19      12.445  -2.553   9.199  1.00  1.00
ATOM    276  HA  GLU    19      13.001  -2.571  10.137  1.00  0.00
ATOM    277  CB  GLU    19      13.159  -1.622   8.213  1.00  1.00
ATOM    278 2HB  GLU    19      12.722  -1.743   7.222  1.00  0.00
ATOM    279 3HB  GLU    19      13.039  -0.589   8.540  1.00  0.00
ATOM    280  CG  GLU    19      14.651  -1.968   8.157  1.00  1.00
ATOM    281 2HG  GLU    19      15.188  -1.170   7.646  1.00  0.00
ATOM    282 3HG  GLU    19      15.037  -2.068   9.171  1.00  0.00
ATOM    283  CD  GLU    19      14.860  -3.279   7.406  1.00  1.00
ATOM    284  OE1 GLU    19      13.967  -3.667   6.671  1.00  1.00
ATOM    285  OE2 GLU    19      15.911  -3.875   7.576  1.00  1.00
ATOM    286 2HE  GLU    19      15.974  -4.690   7.073  1.00  0.00
ATOM    287  C   GLU    19      11.035  -2.034   9.467  1.00  1.00
ATOM    288  O   GLU    19      10.807  -1.306  10.431  1.00  1.00
ATOM    289  N   VAL    20      10.092  -2.422   8.618  1.00  1.00
ATOM    290  HN  VAL    20      10.326  -3.021   7.839  1.00  0.00
ATOM    291  CA  VAL    20       8.705  -1.999   8.784  1.00  1.00
ATOM    292  HA  VAL    20       8.680  -0.915   8.890  1.00  0.00
ATOM    293  CB  VAL    20       7.890  -2.400   7.552  1.00  1.00
ATOM    294  HB  VAL    20       8.005  -3.470   7.375  1.00  0.00
ATOM    295  CG1 VAL    20       6.412  -2.082   7.784  1.00  1.00
ATOM    296 1HG1 VAL    20       5.835  -2.371   6.906  1.00  0.00
ATOM    297 2HG1 VAL    20       6.053  -2.636   8.652  1.00  0.00
ATOM    298 3HG1 VAL    20       6.294  -1.013   7.961  1.00  0.00
ATOM    299  CG2 VAL    20       8.396  -1.626   6.332  1.00  1.00
ATOM    300 1HG2 VAL    20       7.818  -1.914   5.454  1.00  0.00
ATOM    301 2HG2 VAL    20       8.282  -0.557   6.508  1.00  0.00
ATOM    302 3HG2 VAL    20       9.448  -1.857   6.166  1.00  0.00
ATOM    303  C   VAL    20       8.099  -2.635  10.035  1.00  1.00
ATOM    304  O   VAL    20       7.400  -1.970  10.801  1.00  1.00
ATOM    305  N   ILE    21       8.368  -3.920  10.235  1.00  1.00
ATOM    306  HN  ILE    21       8.948  -4.427   9.581  1.00  0.00
ATOM    307  CA  ILE    21       7.838  -4.626  11.395  1.00  1.00
ATOM    308  HA  ILE    21       6.752  -4.676  11.313  1.00  0.00
ATOM    309  CB  ILE    21       8.401  -6.053  11.442  1.00  1.00
ATOM    310  HB  ILE    21       9.480  -6.011  11.588  1.00  0.00
ATOM    311  CG2 ILE    21       7.762  -6.825  12.599  1.00  1.00
ATOM    312 1HG2 ILE    21       8.167  -7.837  12.630  1.00  0.00
ATOM    313 2HG2 ILE    21       7.980  -6.318  13.538  1.00  0.00
ATOM    314 3HG2 ILE    21       6.683  -6.871  12.453  1.00  0.00
ATOM    315  CG1 ILE    21       8.093  -6.768  10.120  1.00  1.00
ATOM    316 2HG1 ILE    21       7.014  -6.874  10.009  1.00  0.00
ATOM    317 3HG1 ILE    21       8.487  -6.180   9.291  1.00  0.00
ATOM    318  CD1 ILE    21       8.742  -8.158  10.110  1.00  1.00
ATOM    319 1HD1 ILE    21       8.517  -8.660   9.169  1.00  0.00
ATOM    320 2HD1 ILE    21       9.822  -8.055  10.218  1.00  0.00
ATOM    321 3HD1 ILE    21       8.349  -8.748  10.938  1.00  0.00
ATOM    322  C   ILE    21       8.208  -3.875  12.668  1.00  1.00
ATOM    323  O   ILE    21       7.418  -3.804  13.610  1.00  1.00
ATOM    324  N   LYS    22       9.407  -3.303  12.684  1.00  1.00
ATOM    325  HN  LYS    22      10.021  -3.389  11.887  1.00  0.00
ATOM    326  CA  LYS    22       9.862  -2.545  13.839  1.00  1.00
ATOM    327  HA  LYS    22       9.776  -3.171  14.728  1.00  0.00
ATOM    328  CB  LYS    22      11.326  -2.139  13.654  1.00  1.00
ATOM    329 2HB  LYS    22      11.435  -1.587  12.721  1.00  0.00
ATOM    330 3HB  LYS    22      11.638  -1.510  14.488  1.00  0.00
ATOM    331  CG  LYS    22      12.196  -3.398  13.609  1.00  1.00
ATOM    332 2HG  LYS    22      12.104  -3.937  14.552  1.00  0.00
ATOM    333 3HG  LYS    22      11.865  -4.039  12.792  1.00  0.00
ATOM    334  CD  LYS    22      13.656  -3.003  13.388  1.00  1.00
ATOM    335 2HD  LYS    22      13.751  -2.478  12.437  1.00  0.00
ATOM    336 3HD  LYS    22      13.982  -2.350  14.197  1.00  0.00
ATOM    337  CE  LYS    22      14.526  -4.260  13.365  1.00  1.00
ATOM    338 2HE  LYS    22      15.573  -3.977  13.253  1.00  0.00
ATOM    339 3HE  LYS    22      14.401  -4.808  14.299  1.00  0.00
ATOM    340  NZ  LYS    22      14.117  -5.125  12.221  1.00  1.00
ATOM    341 1HZ  LYS    22      14.695  -5.954  12.211  1.00  0.00
ATOM    342 2HZ  LYS    22      13.148  -5.389  12.327  1.00  0.00
ATOM    343 3HZ  LYS    22      14.235  -4.619  11.355  1.00  0.00
ATOM    344  C   LYS    22       8.997  -1.298  14.019  1.00  1.00
ATOM    345  O   LYS    22       8.652  -0.924  15.142  1.00  1.00
ATOM    346  N   GLN    23       8.653  -0.656  12.901  1.00  1.00
ATOM    347  HN  GLN    23       8.963  -1.001  12.004  1.00  0.00
ATOM    348  CA  GLN    23       7.831   0.548  12.941  1.00  1.00
ATOM    349  HA  GLN    23       8.313   1.285  13.583  1.00  0.00
ATOM    350  CB  GLN    23       7.694   1.124  11.528  1.00  1.00
ATOM    351 2HB  GLN    23       7.276   0.365  10.866  1.00  0.00
ATOM    352 3HB  GLN    23       7.032   1.989  11.552  1.00  0.00
ATOM    353  CG  GLN    23       9.064   1.547  11.014  1.00  1.00
ATOM    354 2HG  GLN    23       9.476   2.313  11.671  1.00  0.00
ATOM    355 3HG  GLN    23       9.730   0.683  11.009  1.00  0.00
ATOM    356  CD  GLN    23       8.947   2.103   9.601  1.00  1.00
ATOM    357  OE1 GLN    23       8.083   2.938   9.330  1.00  1.00
ATOM    358  NE2 GLN    23       9.773   1.691   8.681  1.00  1.00
ATOM    359 1HE2 GLN    23      10.473   1.006   8.928  1.00  0.00
ATOM    360 2HE2 GLN    23       9.710   2.051   7.740  1.00  0.00
ATOM    361  C   GLN    23       6.452   0.220  13.503  1.00  1.00
ATOM    362  O   GLN    23       5.946   0.913  14.386  1.00  1.00
ATOM    363  N   LEU    24       5.850  -0.844  12.982  1.00  1.00
ATOM    364  HN  LEU    24       6.307  -1.381  12.259  1.00  0.00
ATOM    365  CA  LEU    24       4.528  -1.263  13.434  1.00  1.00
ATOM    366  HA  LEU    24       3.832  -0.435  13.298  1.00  0.00
ATOM    367  CB  LEU    24       4.052  -2.459  12.603  1.00  1.00
ATOM    368 2HB  LEU    24       4.837  -3.215  12.575  1.00  0.00
ATOM    369 3HB  LEU    24       3.157  -2.882  13.059  1.00  0.00
ATOM    370  CG  LEU    24       3.729  -2.005  11.170  1.00  1.00
ATOM    371  HG  LEU    24       4.544  -1.383  10.801  1.00  0.00
ATOM    372  CD1 LEU    24       3.585  -3.238  10.273  1.00  1.00
ATOM    373 1HD1 LEU    24       3.368  -2.923   9.252  1.00  0.00
ATOM    374 2HD1 LEU    24       4.514  -3.808  10.287  1.00  0.00
ATOM    375 3HD1 LEU    24       2.771  -3.863  10.641  1.00  0.00
ATOM    376  CD2 LEU    24       2.418  -1.188  11.137  1.00  1.00
ATOM    377 1HD2 LEU    24       2.206  -0.873  10.115  1.00  0.00
ATOM    378 2HD2 LEU    24       1.597  -1.805  11.503  1.00  0.00
ATOM    379 3HD2 LEU    24       2.523  -0.309  11.773  1.00  0.00
ATOM    380  C   LEU    24       4.564  -1.644  14.905  1.00  1.00
ATOM    381  O   LEU    24       3.670  -1.288  15.668  1.00  1.00
ATOM    382  N   ASP    25       5.605  -2.358  15.302  1.00  1.00
ATOM    383  HN  ASP    25       6.321  -2.624  14.641  1.00  0.00
ATOM    384  CA  ASP    25       5.743  -2.776  16.690  1.00  1.00
ATOM    385  HA  ASP    25       4.924  -3.451  16.938  1.00  0.00
ATOM    386  CB  ASP    25       7.073  -3.509  16.877  1.00  1.00
ATOM    387 2HB  ASP    25       7.177  -4.272  16.106  1.00  0.00
ATOM    388 3HB  ASP    25       7.893  -2.797  16.790  1.00  0.00
ATOM    389  CG  ASP    25       7.121  -4.168  18.249  1.00  1.00
ATOM    390  OD1 ASP    25       6.068  -4.331  18.843  1.00  1.00
ATOM    391  OD2 ASP    25       8.210  -4.500  18.686  1.00  1.00
ATOM    392 2HD  ASP    25       8.165  -4.909  19.554  1.00  0.00
ATOM    393  C   ASP    25       5.692  -1.566  17.617  1.00  1.00
ATOM    394  O   ASP    25       4.993  -1.581  18.629  1.00  1.00
ATOM    395  N   ASP    26       6.427  -0.517  17.264  1.00  1.00
ATOM    396  HN  ASP    26       6.985  -0.545  16.423  1.00  0.00
ATOM    397  CA  ASP    26       6.444   0.690  18.080  1.00  1.00
ATOM    398  HA  ASP    26       6.825   0.440  19.070  1.00  0.00
ATOM    399  CB  ASP    26       7.360   1.736  17.441  1.00  1.00
ATOM    400 2HB  ASP    26       8.317   1.276  17.195  1.00  0.00
ATOM    401 3HB  ASP    26       6.898   2.112  16.528  1.00  0.00
ATOM    402  CG  ASP    26       7.587   2.893  18.406  1.00  1.00
ATOM    403  OD1 ASP    26       6.816   3.016  19.343  1.00  1.00
ATOM    404  OD2 ASP    26       8.529   3.639  18.196  1.00  1.00
ATOM    405 2HD  ASP    26       8.611   4.343  18.843  1.00  0.00
ATOM    406  C   ASP    26       5.032   1.249  18.217  1.00  1.00
ATOM    407  O   ASP    26       4.614   1.651  19.302  1.00  1.00
ATOM    408  N   LEU    27       4.300   1.259  17.110  1.00  1.00
ATOM    409  HN  LEU    27       4.690   0.919  16.243  1.00  0.00
ATOM    410  CA  LEU    27       2.929   1.754  17.111  1.00  1.00
ATOM    411  HA  LEU    27       2.919   2.741  17.572  1.00  0.00
ATOM    412  CB  LEU    27       2.416   1.878  15.672  1.00  1.00
ATOM    413 2HB  LEU    27       2.812   1.057  15.074  1.00  0.00
ATOM    414 3HB  LEU    27       1.327   1.836  15.670  1.00  0.00
ATOM    415  CG  LEU    27       2.881   3.225  15.071  1.00  1.00
ATOM    416  HG  LEU    27       3.841   3.501  15.506  1.00  0.00
ATOM    417  CD1 LEU    27       3.027   3.090  13.565  1.00  1.00
ATOM    418 1HD1 LEU    27       3.358   4.039  13.144  1.00  0.00
ATOM    419 2HD1 LEU    27       3.762   2.317  13.339  1.00  0.00
ATOM    420 3HD1 LEU    27       2.066   2.815  13.130  1.00  0.00
ATOM    421  CD2 LEU    27       1.846   4.321  15.376  1.00  1.00
ATOM    422 1HD2 LEU    27       2.181   5.267  14.952  1.00  0.00
ATOM    423 2HD2 LEU    27       0.886   4.046  14.938  1.00  0.00
ATOM    424 3HD2 LEU    27       1.735   4.426  16.455  1.00  0.00
ATOM    425  C   LEU    27       2.024   0.830  17.918  1.00  1.00
ATOM    426  O   LEU    27       1.076   1.278  18.558  1.00  1.00
ATOM    427  N   GLU    28       2.323  -0.461  17.875  1.00  1.00
ATOM    428  HN  GLU    28       3.112  -0.779  17.331  1.00  0.00
ATOM    429  CA  GLU    28       1.536  -1.444  18.599  1.00  1.00
ATOM    430  HA  GLU    28       0.481  -1.288  18.371  1.00  0.00
ATOM    431  CB  GLU    28       1.944  -2.847  18.147  1.00  1.00
ATOM    432 2HB  GLU    28       3.031  -2.923  18.137  1.00  0.00
ATOM    433 3HB  GLU    28       1.535  -3.585  18.838  1.00  0.00
ATOM    434  CG  GLU    28       1.401  -3.112  16.740  1.00  1.00
ATOM    435 2HG  GLU    28       0.318  -3.226  16.785  1.00  0.00
ATOM    436 3HG  GLU    28       1.647  -2.271  16.092  1.00  0.00
ATOM    437  CD  GLU    28       2.021  -4.385  16.175  1.00  1.00
ATOM    438  OE1 GLU    28       1.807  -5.434  16.759  1.00  1.00
ATOM    439  OE2 GLU    28       2.705  -4.290  15.169  1.00  1.00
ATOM    440 2HE  GLU    28       3.064  -5.129  14.871  1.00  0.00
ATOM    441  C   GLU    28       1.744  -1.301  20.103  1.00  1.00
ATOM    442  O   GLU    28       0.820  -1.498  20.886  1.00  1.00
ATOM    443  N   VAL    29       2.967  -0.967  20.496  1.00  1.00
ATOM    444  HN  VAL    29       3.699  -0.817  19.817  1.00  0.00
ATOM    445  CA  VAL    29       3.278  -0.811  21.916  1.00  1.00
ATOM    446  HA  VAL    29       3.008  -1.731  22.435  1.00  0.00
ATOM    447  CB  VAL    29       4.780  -0.558  22.093  1.00  1.00
ATOM    448  HB  VAL    29       5.090   0.246  21.426  1.00  0.00
ATOM    449  CG1 VAL    29       5.075  -0.157  23.544  1.00  1.00
ATOM    450 1HG1 VAL    29       6.143   0.023  23.663  1.00  0.00
ATOM    451 2HG1 VAL    29       4.524   0.751  23.789  1.00  0.00
ATOM    452 3HG1 VAL    29       4.766  -0.961  24.213  1.00  0.00
ATOM    453  CG2 VAL    29       5.558  -1.832  21.749  1.00  1.00
ATOM    454 1HG2 VAL    29       6.626  -1.651  21.870  1.00  0.00
ATOM    455 2HG2 VAL    29       5.248  -2.638  22.415  1.00  0.00
ATOM    456 3HG2 VAL    29       5.353  -2.115  20.717  1.00  0.00
ATOM    457  C   VAL    29       2.490   0.350  22.522  1.00  1.00
ATOM    458  O   VAL    29       1.838   0.200  23.555  1.00  1.00
ATOM    459  N   GLN    30       2.565   1.506  21.876  1.00  1.00
ATOM    460  HN  GLN    30       3.114   1.580  21.032  1.00  0.00
ATOM    461  CA  GLN    30       1.864   2.689  22.362  1.00  1.00
ATOM    462  HA  GLN    30       2.189   2.889  23.383  1.00  0.00
ATOM    463  CB  GLN    30       2.206   3.900  21.487  1.00  1.00
ATOM    464 2HB  GLN    30       1.589   4.748  21.782  1.00  0.00
ATOM    465 3HB  GLN    30       3.258   4.154  21.613  1.00  0.00
ATOM    466  CG  GLN    30       1.937   3.559  20.033  1.00  1.00
ATOM    467 2HG  GLN    30       2.480   2.652  19.767  1.00  0.00
ATOM    468 3HG  GLN    30       0.869   3.392  19.892  1.00  0.00
ATOM    469  CD  GLN    30       2.394   4.705  19.137  1.00  1.00
ATOM    470  OE1 GLN    30       3.594   4.951  19.007  1.00  1.00
ATOM    471  NE2 GLN    30       1.507   5.426  18.510  1.00  1.00
ATOM    472 1HE2 GLN    30       0.529   5.206  18.633  1.00  0.00
ATOM    473 2HE2 GLN    30       1.796   6.188  17.915  1.00  0.00
ATOM    474  C   GLN    30       0.361   2.454  22.363  1.00  1.00
ATOM    475  O   GLN    30      -0.341   2.869  23.283  1.00  1.00
ATOM    476  N   ARG    31      -0.127   1.784  21.325  1.00  1.00
ATOM    477  HN  ARG    31       0.492   1.461  20.595  1.00  0.00
ATOM    478  CA  ARG    31      -1.554   1.498  21.209  1.00  1.00
ATOM    479  HA  ARG    31      -2.114   2.326  21.644  1.00  0.00
ATOM    480  CB  ARG    31      -1.929   1.363  19.725  1.00  1.00
ATOM    481 2HB  ARG    31      -1.128   0.846  19.197  1.00  0.00
ATOM    482 3HB  ARG    31      -2.851   0.788  19.638  1.00  0.00
ATOM    483  CG  ARG    31      -2.137   2.754  19.099  1.00  1.00
ATOM    484 2HG  ARG    31      -1.427   3.455  19.537  1.00  0.00
ATOM    485 3HG  ARG    31      -1.972   2.693  18.023  1.00  0.00
ATOM    486  CD  ARG    31      -3.565   3.245  19.366  1.00  1.00
ATOM    487 2HD  ARG    31      -4.277   2.508  18.994  1.00  0.00
ATOM    488 3HD  ARG    31      -3.710   3.372  20.439  1.00  0.00
ATOM    489  NE  ARG    31      -3.789   4.518  18.692  1.00  1.00
ATOM    490  HE  ARG    31      -4.150   4.506  17.749  1.00  0.00
ATOM    491  CZ  ARG    31      -3.529   5.674  19.294  1.00  1.00
ATOM    492  NH1 ARG    31      -3.751   6.794  18.668  1.00  1.00
ATOM    493 1HH1 ARG    31      -3.552   7.672  19.125  1.00  0.00
ATOM    494 2HH1 ARG    31      -4.122   6.783  17.729  1.00  0.00
ATOM    495  NH2 ARG    31      -3.046   5.687  20.508  1.00  1.00
ATOM    496 1HH2 ARG    31      -2.848   6.567  20.961  1.00  0.00
ATOM    497 2HH2 ARG    31      -2.871   4.818  20.992  1.00  0.00
ATOM    498  C   ARG    31      -1.908   0.216  21.957  1.00  1.00
ATOM    499  O   ARG    31      -3.077  -0.038  22.248  1.00  1.00
ATOM    500  N   ASN    32      -0.898  -0.584  22.265  1.00  1.00
ATOM    501  HN  ASN    32       0.046  -0.334  22.008  1.00  0.00
ATOM    502  CA  ASN    32      -1.122  -1.829  22.974  1.00  1.00
ATOM    503  HA  ASN    32      -0.177  -2.368  23.046  1.00  0.00
ATOM    504  CB  ASN    32      -1.640  -1.544  24.378  1.00  1.00
ATOM    505 2HB  ASN    32      -2.629  -1.090  24.314  1.00  0.00
ATOM    506 3HB  ASN    32      -1.710  -2.478  24.936  1.00  0.00
ATOM    507  CG  ASN    32      -0.690  -0.596  25.097  1.00  1.00
ATOM    508  OD1 ASN    32       0.488  -0.908  25.268  1.00  1.00
ATOM    509  ND2 ASN    32      -1.133   0.553  25.526  1.00  1.00
ATOM    510 1HD2 ASN    32      -2.103   0.787  25.371  1.00  0.00
ATOM    511 2HD2 ASN    32      -0.514   1.193  26.002  1.00  0.00
ATOM    512  C   ASN    32      -2.126  -2.686  22.225  1.00  1.00
ATOM    513  O   ASN    32      -2.988  -3.319  22.832  1.00  1.00
ATOM    514  N   LEU    33      -2.020  -2.698  20.896  1.00  1.00
ATOM    515  HN  LEU    33      -1.296  -2.163  20.439  1.00  0.00
ATOM    516  CA  LEU    33      -2.942  -3.481  20.071  1.00  1.00
ATOM    517  HA  LEU    33      -3.452  -4.206  20.707  1.00  0.00
ATOM    518  CB  LEU    33      -3.983  -2.541  19.444  1.00  1.00
ATOM    519 2HB  LEU    33      -3.494  -1.621  19.126  1.00  0.00
ATOM    520 3HB  LEU    33      -4.437  -3.029  18.581  1.00  0.00
ATOM    521  CG  LEU    33      -5.078  -2.208  20.477  1.00  1.00
ATOM    522  HG  LEU    33      -4.621  -2.119  21.462  1.00  0.00
ATOM    523  CD1 LEU    33      -5.744  -0.882  20.108  1.00  1.00
ATOM    524 1HD1 LEU    33      -6.510  -0.640  20.845  1.00  0.00
ATOM    525 2HD1 LEU    33      -4.994  -0.092  20.092  1.00  0.00
ATOM    526 3HD1 LEU    33      -6.203  -0.968  19.123  1.00  0.00
ATOM    527  CD2 LEU    33      -6.144  -3.319  20.517  1.00  1.00
ATOM    528 1HD2 LEU    33      -6.907  -3.072  21.255  1.00  0.00
ATOM    529 2HD2 LEU    33      -6.608  -3.412  19.535  1.00  0.00
ATOM    530 3HD2 LEU    33      -5.673  -4.264  20.787  1.00  0.00
ATOM    531  C   LEU    33      -2.191  -4.230  18.972  1.00  1.00
ATOM    532  O   LEU    33      -1.121  -3.799  18.538  1.00  1.00
ATOM    533  N   PRO    34      -2.736  -5.331  18.512  1.00  1.00
ATOM    534  CD  PRO    34      -4.004  -5.930  18.977  1.00  1.00
ATOM    535  CA  PRO    34      -2.110  -6.148  17.430  1.00  1.00
ATOM    536  HA  PRO    34      -1.111  -6.469  17.726  1.00  0.00
ATOM    537  CB  PRO    34      -3.045  -7.368  17.298  1.00  1.00
ATOM    538 2HB  PRO    34      -3.151  -7.684  16.260  1.00  0.00
ATOM    539 3HB  PRO    34      -2.649  -8.179  17.909  1.00  0.00
ATOM    540  CG  PRO    34      -4.352  -6.929  17.881  1.00  1.00
ATOM    541 2HG  PRO    34      -4.918  -6.411  17.107  1.00  0.00
ATOM    542 3HG  PRO    34      -4.919  -7.773  18.274  1.00  0.00
ATOM    543 2HD  PRO    34      -4.789  -5.183  19.093  1.00  0.00
ATOM    544 3HD  PRO    34      -3.835  -6.452  19.919  1.00  0.00
ATOM    545  C   PRO    34      -2.016  -5.378  16.112  1.00  1.00
ATOM    546  O   PRO    34      -2.805  -4.471  15.854  1.00  1.00
ATOM    547  N   ARG    35      -1.047  -5.755  15.286  1.00  1.00
ATOM    548  HN  ARG    35      -0.423  -6.505  15.547  1.00  0.00
ATOM    549  CA  ARG    35      -0.858  -5.106  13.998  1.00  1.00
ATOM    550  HA  ARG    35      -0.686  -4.042  14.160  1.00  0.00
ATOM    551  CB  ARG    35       0.359  -5.712  13.299  1.00  1.00
ATOM    552 2HB  ARG    35       0.558  -5.163  12.379  1.00  0.00
ATOM    553 3HB  ARG    35       1.225  -5.644  13.957  1.00  0.00
ATOM    554  CG  ARG    35       0.090  -7.184  12.965  1.00  1.00
ATOM    555 2HG  ARG    35      -0.310  -7.689  13.845  1.00  0.00
ATOM    556 3HG  ARG    35      -0.633  -7.246  12.151  1.00  0.00
ATOM    557  CD  ARG    35       1.394  -7.858  12.540  1.00  1.00
ATOM    558 2HD  ARG    35       1.818  -7.323  11.690  1.00  0.00
ATOM    559 3HD  ARG    35       2.101  -7.833  13.369  1.00  0.00
ATOM    560  NE  ARG    35       1.140  -9.244  12.162  1.00  1.00
ATOM    561  HE  ARG    35       0.191  -9.523  11.958  1.00  0.00
ATOM    562  CZ  ARG    35       2.129 -10.128  12.085  1.00  1.00
ATOM    563  NH1 ARG    35       1.877 -11.362  11.743  1.00  1.00
ATOM    564 1HH1 ARG    35       2.630 -12.032  11.686  1.00  0.00
ATOM    565 2HH1 ARG    35       0.930 -11.647  11.536  1.00  0.00
ATOM    566  NH2 ARG    35       3.352  -9.761  12.354  1.00  1.00
ATOM    567 1HH2 ARG    35       4.103 -10.434  12.296  1.00  0.00
ATOM    568 2HH2 ARG    35       3.547  -8.807  12.620  1.00  0.00
ATOM    569  C   ARG    35      -2.094  -5.282  13.128  1.00  1.00
ATOM    570  O   ARG    35      -2.547  -4.338  12.481  1.00  1.00
ATOM    571  N   ALA    36      -2.630  -6.497  13.102  1.00  1.00
ATOM    572  HN  ALA    36      -2.226  -7.244  13.650  1.00  0.00
ATOM    573  CA  ALA    36      -3.804  -6.780  12.288  1.00  1.00
ATOM    574  HA  ALA    36      -3.513  -6.776  11.238  1.00  0.00
ATOM    575  CB  ALA    36      -4.367  -8.157  12.647  1.00  1.00
ATOM    576 1HB  ALA    36      -5.236  -8.372  12.024  1.00  0.00
ATOM    577 2HB  ALA    36      -3.604  -8.917  12.478  1.00  0.00
ATOM    578 3HB  ALA    36      -4.662  -8.167  13.696  1.00  0.00
ATOM    579  C   ALA    36      -4.869  -5.719  12.514  1.00  1.00
ATOM    580  O   ALA    36      -5.509  -5.258  11.569  1.00  1.00
ATOM    581  N   ASP    37      -5.044  -5.323  13.768  1.00  1.00
ATOM    582  HN  ASP    37      -4.497  -5.730  14.513  1.00  0.00
ATOM    583  CA  ASP    37      -6.026  -4.299  14.095  1.00  1.00
ATOM    584  HA  ASP    37      -6.992  -4.599  13.688  1.00  0.00
ATOM    585  CB  ASP    37      -6.145  -4.162  15.615  1.00  1.00
ATOM    586 2HB  ASP    37      -6.520  -5.096  16.035  1.00  0.00
ATOM    587 3HB  ASP    37      -5.163  -3.948  16.037  1.00  0.00
ATOM    588  CG  ASP    37      -7.104  -3.029  15.964  1.00  1.00
ATOM    589  OD1 ASP    37      -6.656  -2.063  16.560  1.00  1.00
ATOM    590  OD2 ASP    37      -8.272  -3.143  15.630  1.00  1.00
ATOM    591 2HD  ASP    37      -8.817  -2.394  15.882  1.00  0.00
ATOM    592  C   ASP    37      -5.626  -2.957  13.485  1.00  1.00
ATOM    593  O   ASP    37      -6.473  -2.203  13.007  1.00  1.00
ATOM    594  N   LEU    38      -4.328  -2.669  13.504  1.00  1.00
ATOM    595  HN  LEU    38      -3.671  -3.321  13.908  1.00  0.00
ATOM    596  CA  LEU    38      -3.822  -1.419  12.949  1.00  1.00
ATOM    597  HA  LEU    38      -4.409  -0.596  13.356  1.00  0.00
ATOM    598  CB  LEU    38      -2.356  -1.230  13.347  1.00  1.00
ATOM    599 2HB  LEU    38      -1.784  -2.110  13.051  1.00  0.00
ATOM    600 3HB  LEU    38      -1.955  -0.350  12.845  1.00  0.00
ATOM    601  CG  LEU    38      -2.254  -1.042  14.869  1.00  1.00
ATOM    602  HG  LEU    38      -2.762  -1.871  15.364  1.00  0.00
ATOM    603  CD1 LEU    38      -0.777  -1.036  15.282  1.00  1.00
ATOM    604 1HD1 LEU    38      -0.701  -0.916  16.363  1.00  0.00
ATOM    605 2HD1 LEU    38      -0.314  -1.979  14.988  1.00  0.00
ATOM    606 3HD1 LEU    38      -0.265  -0.211  14.788  1.00  0.00
ATOM    607  CD2 LEU    38      -2.919   0.283  15.301  1.00  1.00
ATOM    608 1HD2 LEU    38      -2.843   0.398  16.382  1.00  0.00
ATOM    609 2HD2 LEU    38      -2.416   1.117  14.812  1.00  0.00
ATOM    610 3HD2 LEU    38      -3.970   0.272  15.012  1.00  0.00
ATOM    611  C   LEU    38      -3.947  -1.410  11.431  1.00  1.00
ATOM    612  O   LEU    38      -4.315  -0.398  10.834  1.00  1.00
ATOM    613  N   LEU    39      -3.630  -2.539  10.810  1.00  1.00
ATOM    614  HN  LEU    39      -3.336  -3.347  11.341  1.00  0.00
ATOM    615  CA  LEU    39      -3.698  -2.642   9.359  1.00  1.00
ATOM    616  HA  LEU    39      -3.057  -1.878   8.920  1.00  0.00
ATOM    617  CB  LEU    39      -3.207  -4.021   8.928  1.00  1.00
ATOM    618 2HB  LEU    39      -3.755  -4.787   9.477  1.00  0.00
ATOM    619 3HB  LEU    39      -3.378  -4.147   7.859  1.00  0.00
ATOM    620  CG  LEU    39      -1.705  -4.160   9.223  1.00  1.00
ATOM    621  HG  LEU    39      -1.522  -3.885  10.262  1.00  0.00
ATOM    622  CD1 LEU    39      -1.276  -5.619   9.008  1.00  1.00
ATOM    623 1HD1 LEU    39      -0.214  -5.724   9.231  1.00  0.00
ATOM    624 2HD1 LEU    39      -1.851  -6.268   9.669  1.00  0.00
ATOM    625 3HD1 LEU    39      -1.460  -5.903   7.972  1.00  0.00
ATOM    626  CD2 LEU    39      -0.882  -3.226   8.308  1.00  1.00
ATOM    627 1HD2 LEU    39       0.179  -3.331   8.534  1.00  0.00
ATOM    628 2HD2 LEU    39      -1.058  -3.493   7.266  1.00  0.00
ATOM    629 3HD2 LEU    39      -1.188  -2.194   8.475  1.00  0.00
ATOM    630  C   LEU    39      -5.126  -2.437   8.872  1.00  1.00
ATOM    631  O   LEU    39      -5.366  -1.701   7.915  1.00  1.00
ATOM    632  N   ARG    40      -6.072  -3.096   9.529  1.00  1.00
ATOM    633  HN  ARG    40      -5.831  -3.690  10.309  1.00  0.00
ATOM    634  CA  ARG    40      -7.470  -2.980   9.142  1.00  1.00
ATOM    635  HA  ARG    40      -7.593  -3.390   8.139  1.00  0.00
ATOM    636  CB  ARG    40      -8.347  -3.770  10.118  1.00  1.00
ATOM    637 2HB  ARG    40      -8.014  -4.808  10.146  1.00  0.00
ATOM    638 3HB  ARG    40      -8.263  -3.335  11.114  1.00  0.00
ATOM    639  CG  ARG    40      -9.806  -3.716   9.661  1.00  1.00
ATOM    640 2HG  ARG    40     -10.146  -2.681   9.653  1.00  0.00
ATOM    641 3HG  ARG    40      -9.888  -4.134   8.658  1.00  0.00
ATOM    642  CD  ARG    40     -10.672  -4.528  10.623  1.00  1.00
ATOM    643 2HD  ARG    40     -11.704  -4.527  10.270  1.00  0.00
ATOM    644 3HD  ARG    40     -10.307  -5.555  10.660  1.00  0.00
ATOM    645  NE  ARG    40     -10.617  -3.946  11.960  1.00  1.00
ATOM    646  HE  ARG    40     -10.000  -4.363  12.642  1.00  0.00
ATOM    647  CZ  ARG    40     -11.359  -2.891  12.283  1.00  1.00
ATOM    648  NH1 ARG    40     -11.296  -2.394  13.488  1.00  1.00
ATOM    649 1HH1 ARG    40     -11.859  -1.592  13.731  1.00  0.00
ATOM    650 2HH1 ARG    40     -10.686  -2.811  14.176  1.00  0.00
ATOM    651  NH2 ARG    40     -12.145  -2.349  11.393  1.00  1.00
ATOM    652 1HH2 ARG    40     -12.707  -1.547  11.640  1.00  0.00
ATOM    653 2HH2 ARG    40     -12.192  -2.732  10.460  1.00  0.00
ATOM    654  C   ARG    40      -7.895  -1.518   9.138  1.00  1.00
ATOM    655  O   ARG    40      -8.571  -1.060   8.216  1.00  1.00
ATOM    656  N   GLU    41      -7.491  -0.789  10.169  1.00  1.00
ATOM    657  HN  GLU    41      -6.936  -1.209  10.902  1.00  0.00
ATOM    658  CA  GLU    41      -7.833   0.623  10.270  1.00  1.00
ATOM    659  HA  GLU    41      -8.914   0.728  10.175  1.00  0.00
ATOM    660  CB  GLU    41      -7.397   1.170  11.631  1.00  1.00
ATOM    661 2HB  GLU    41      -6.340   0.954  11.786  1.00  0.00
ATOM    662 3HB  GLU    41      -7.555   2.248  11.655  1.00  0.00
ATOM    663  CG  GLU    41      -8.219   0.511  12.742  1.00  1.00
ATOM    664 2HG  GLU    41      -8.141  -0.573  12.655  1.00  0.00
ATOM    665 3HG  GLU    41      -7.831   0.822  13.712  1.00  0.00
ATOM    666  CD  GLU    41      -9.683   0.924  12.626  1.00  1.00
ATOM    667  OE1 GLU    41     -10.523   0.212  13.150  1.00  1.00
ATOM    668  OE2 GLU    41      -9.942   1.945  12.011  1.00  1.00
ATOM    669 2HE  GLU    41     -10.881   2.143  11.977  1.00  0.00
ATOM    670  C   GLU    41      -7.157   1.416   9.157  1.00  1.00
ATOM    671  O   GLU    41      -7.731   2.362   8.620  1.00  1.00
ATOM    672  N   ALA    42      -5.935   1.025   8.816  1.00  1.00
ATOM    673  HN  ALA    42      -5.502   0.242   9.285  1.00  0.00
ATOM    674  CA  ALA    42      -5.195   1.711   7.765  1.00  1.00
ATOM    675  HA  ALA    42      -5.063   2.753   8.054  1.00  0.00
ATOM    676  CB  ALA    42      -3.822   1.062   7.588  1.00  1.00
ATOM    677 1HB  ALA    42      -3.264   1.589   6.815  1.00  0.00
ATOM    678 2HB  ALA    42      -3.273   1.112   8.529  1.00  0.00
ATOM    679 3HB  ALA    42      -3.949   0.019   7.296  1.00  0.00
ATOM    680  C   ALA    42      -5.957   1.654   6.445  1.00  1.00
ATOM    681  O   ALA    42      -6.127   2.672   5.774  1.00  1.00
ATOM    682  N   VAL    43      -6.414   0.461   6.074  1.00  1.00
ATOM    683  HN  VAL    43      -6.254  -0.351   6.654  1.00  0.00
ATOM    684  CA  VAL    43      -7.153   0.301   4.826  1.00  1.00
ATOM    685  HA  VAL    43      -6.540   0.667   4.003  1.00  0.00
ATOM    686  CB  VAL    43      -7.464  -1.180   4.601  1.00  1.00
ATOM    687  HB  VAL    43      -8.001  -1.572   5.465  1.00  0.00
ATOM    688  CG1 VAL    43      -8.329  -1.341   3.351  1.00  1.00
ATOM    689 1HG1 VAL    43      -8.550  -2.397   3.194  1.00  0.00
ATOM    690 2HG1 VAL    43      -9.261  -0.791   3.481  1.00  0.00
ATOM    691 3HG1 VAL    43      -7.794  -0.950   2.486  1.00  0.00
ATOM    692  CG2 VAL    43      -6.156  -1.955   4.421  1.00  1.00
ATOM    693 1HG2 VAL    43      -6.377  -3.011   4.264  1.00  0.00
ATOM    694 2HG2 VAL    43      -5.618  -1.564   3.558  1.00  0.00
ATOM    695 3HG2 VAL    43      -5.541  -1.842   5.314  1.00  0.00
ATOM    696  C   VAL    43      -8.454   1.098   4.873  1.00  1.00
ATOM    697  O   VAL    43      -8.725   1.916   3.995  1.00  1.00
ATOM    698  N   ASP    44      -9.257   0.847   5.901  1.00  1.00
ATOM    699  HN  ASP    44      -8.994   0.166   6.599  1.00  0.00
ATOM    700  CA  ASP    44     -10.528   1.542   6.045  1.00  1.00
ATOM    701  HA  ASP    44     -11.207   1.200   5.263  1.00  0.00
ATOM    702  CB  ASP    44     -11.143   1.234   7.411  1.00  1.00
ATOM    703 2HB  ASP    44     -11.062   0.165   7.610  1.00  0.00
ATOM    704 3HB  ASP    44     -10.604   1.784   8.182  1.00  0.00
ATOM    705  CG  ASP    44     -12.614   1.642   7.436  1.00  1.00
ATOM    706  OD1 ASP    44     -13.227   1.654   6.381  1.00  1.00
ATOM    707  OD2 ASP    44     -13.105   1.939   8.513  1.00  1.00
ATOM    708 2HD  ASP    44     -14.031   2.185   8.455  1.00  0.00
ATOM    709  C   ASP    44     -10.318   3.044   5.904  1.00  1.00
ATOM    710  O   ASP    44     -11.076   3.725   5.217  1.00  1.00
ATOM    711  N   GLN    45      -9.273   3.550   6.546  1.00  1.00
ATOM    712  HN  GLN    45      -8.678   2.949   7.098  1.00  0.00
ATOM    713  CA  GLN    45      -8.959   4.970   6.474  1.00  1.00
ATOM    714  HA  GLN    45      -9.843   5.537   6.765  1.00  0.00
ATOM    715  CB  GLN    45      -7.818   5.297   7.443  1.00  1.00
ATOM    716 2HB  GLN    45      -7.048   4.529   7.368  1.00  0.00
ATOM    717 3HB  GLN    45      -7.391   6.266   7.186  1.00  0.00
ATOM    718  CG  GLN    45      -8.354   5.341   8.877  1.00  1.00
ATOM    719 2HG  GLN    45      -9.109   6.123   8.958  1.00  0.00
ATOM    720 3HG  GLN    45      -8.806   4.380   9.124  1.00  0.00
ATOM    721  CD  GLN    45      -7.219   5.631   9.851  1.00  1.00
ATOM    722  OE1 GLN    45      -6.424   6.544   9.625  1.00  1.00
ATOM    723  NE2 GLN    45      -7.097   4.907  10.929  1.00  1.00
ATOM    724 1HE2 GLN    45      -7.762   4.164  11.093  1.00  0.00
ATOM    725 2HE2 GLN    45      -6.351   5.088  11.584  1.00  0.00
ATOM    726  C   GLN    45      -8.566   5.364   5.053  1.00  1.00
ATOM    727  O   GLN    45      -8.921   6.442   4.575  1.00  1.00
ATOM    728  N   TYR    46      -7.828   4.486   4.386  1.00  1.00
ATOM    729  HN  TYR    46      -7.559   3.615   4.821  1.00  0.00
ATOM    730  CA  TYR    46      -7.388   4.752   3.020  1.00  1.00
ATOM    731  HA  TYR    46      -6.832   5.689   3.011  1.00  0.00
ATOM    732  CB  TYR    46      -6.472   3.628   2.537  1.00  1.00
ATOM    733 2HB  TYR    46      -5.591   3.572   3.176  1.00  0.00
ATOM    734 3HB  TYR    46      -7.001   2.676   2.587  1.00  0.00
ATOM    735  CG  TYR    46      -6.050   3.901   1.111  1.00  1.00
ATOM    736  CD1 TYR    46      -5.180   4.963   0.835  1.00  1.00
ATOM    737 1HD  TYR    46      -4.815   5.585   1.639  1.00  0.00
ATOM    738  CE1 TYR    46      -4.783   5.218  -0.482  1.00  1.00
ATOM    739 1HE  TYR    46      -4.112   6.037  -0.695  1.00  0.00
ATOM    740  CZ  TYR    46      -5.255   4.412  -1.524  1.00  1.00
ATOM    741  CE2 TYR    46      -6.124   3.349  -1.250  1.00  1.00
ATOM    742 2HE  TYR    46      -6.487   2.726  -2.054  1.00  0.00
ATOM    743  CD2 TYR    46      -6.522   3.093   0.068  1.00  1.00
ATOM    744 2HD  TYR    46      -7.192   2.273   0.280  1.00  0.00
ATOM    745  OH  TYR    46      -4.864   4.665  -2.823  1.00  1.00
ATOM    746  HH  TYR    46      -5.247   4.053  -3.456  1.00  0.00
ATOM    747  C   TYR    46      -8.587   4.882   2.086  1.00  1.00
ATOM    748  O   TYR    46      -8.663   5.812   1.284  1.00  1.00
ATOM    749  N   LEU    47      -9.521   3.946   2.202  1.00  1.00
ATOM    750  HN  LEU    47      -9.413   3.203   2.878  1.00  0.00
ATOM    751  CA  LEU    47     -10.719   3.963   1.364  1.00  1.00
ATOM    752  HA  LEU    47     -10.410   3.940   0.319  1.00  0.00
ATOM    753  CB  LEU    47     -11.583   2.731   1.653  1.00  1.00
ATOM    754 2HB  LEU    47     -11.671   2.595   2.731  1.00  0.00
ATOM    755 3HB  LEU    47     -12.574   2.875   1.223  1.00  0.00
ATOM    756  CG  LEU    47     -10.934   1.482   1.033  1.00  1.00
ATOM    757  HG  LEU    47      -9.885   1.443   1.325  1.00  0.00
ATOM    758  CD1 LEU    47     -11.649   0.228   1.554  1.00  1.00
ATOM    759 1HD1 LEU    47     -11.185  -0.661   1.126  1.00  0.00
ATOM    760 2HD1 LEU    47     -11.571   0.190   2.641  1.00  0.00
ATOM    761 3HD1 LEU    47     -12.700   0.262   1.266  1.00  0.00
ATOM    762  CD2 LEU    47     -11.025   1.534  -0.513  1.00  1.00
ATOM    763 1HD2 LEU    47     -10.558   0.646  -0.939  1.00  0.00
ATOM    764 2HD2 LEU    47     -12.072   1.571  -0.814  1.00  0.00
ATOM    765 3HD2 LEU    47     -10.511   2.423  -0.877  1.00  0.00
ATOM    766  C   LEU    47     -11.533   5.227   1.610  1.00  1.00
ATOM    767  O   LEU    47     -12.036   5.844   0.671  1.00  1.00
ATOM    768  N   ILE    48     -11.657   5.610   2.871  1.00  1.00
ATOM    769  HN  ILE    48     -11.225   5.077   3.613  1.00  0.00
ATOM    770  CA  ILE    48     -12.415   6.804   3.212  1.00  1.00
ATOM    771  HA  ILE    48     -13.439   6.684   2.859  1.00  0.00
ATOM    772  CB  ILE    48     -12.428   6.992   4.735  1.00  1.00
ATOM    773  HB  ILE    48     -11.411   6.900   5.115  1.00  0.00
ATOM    774  CG2 ILE    48     -12.973   8.378   5.090  1.00  1.00
ATOM    775 1HG2 ILE    48     -12.973   8.505   6.173  1.00  0.00
ATOM    776 2HG2 ILE    48     -12.344   9.142   4.635  1.00  0.00
ATOM    777 3HG2 ILE    48     -13.992   8.474   4.714  1.00  0.00
ATOM    778  CG1 ILE    48     -13.306   5.915   5.379  1.00  1.00
ATOM    779 2HG1 ILE    48     -14.354   6.122   5.160  1.00  0.00
ATOM    780 3HG1 ILE    48     -13.037   4.938   4.976  1.00  0.00
ATOM    781  CD1 ILE    48     -13.093   5.916   6.896  1.00  1.00
ATOM    782 1HD1 ILE    48     -13.720   5.149   7.352  1.00  0.00
ATOM    783 2HD1 ILE    48     -12.046   5.707   7.116  1.00  0.00
ATOM    784 3HD1 ILE    48     -13.362   6.892   7.300  1.00  0.00
ATOM    785  C   ILE    48     -11.797   8.028   2.543  1.00  1.00
ATOM    786  O   ILE    48     -12.506   8.858   1.976  1.00  1.00
END
