
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  132 ( 1042),  selected  132 , name 2bng_A
# Molecule2: number of CA atoms  117 ( 1867),  selected  117 , name T0475.pdb
# PARAMETERS: 2bng_A.T0475.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    E    13_A      -       -           -
LGA    T    14_A      N       2          0.885
LGA    T    15_A      S       3          2.094
LGA    E    16_A      E       4          2.154
LGA    A    17_A      I       5          0.858
LGA    I    18_A      E       6          1.571
LGA    R    19_A      L       7          2.559
LGA    A    20_A      P       8          1.262
LGA    V    21_A      V       9          0.404
LGA    E    22_A      Q      10          1.564
LGA    A    23_A      K      11          0.893
LGA    F    24_A      Q      12          0.743
LGA    L    25_A      L      13          1.494
LGA    N    26_A      E      14          1.337
LGA    A    27_A      A      15          0.745
LGA    L    28_A      Y      16          1.514
LGA    Q    29_A      N      17          1.250
LGA    N    30_A      A      18          1.185
LGA    E    31_A      R      19          1.060
LGA    D    32_A      D      20          0.412
LGA    F    33_A      I      21          1.221
LGA    D    34_A      D      22          1.042
LGA    T    35_A      A      23          0.992
LGA    V    36_A      F      24          1.557
LGA    D    37_A      M      25          2.060
LGA    A    38_A      A      26          0.838
LGA    A    39_A      W      27          2.104
LGA    L    40_A      W      28          1.979
LGA    G    41_A      A      29          1.277
LGA    D    42_A      D      30          1.611
LGA    D    43_A      D      31          2.025
LGA    L    44_A      C      32          1.651
LGA    V    45_A      Q      33          1.625
LGA    Y    46_A      Y      34          1.366
LGA    E    47_A      Y      35          1.839
LGA    N    48_A      A      36          2.061
LGA    V    49_A      F      37          0.744
LGA    G    50_A      P      38          3.173
LGA    F    51_A      A      39           -
LGA    S    52_A      T      40          4.280
LGA    R    53_A      L      41          2.364
LGA    I    54_A      L      42          1.605
LGA    R    55_A      A      43          2.444
LGA    -       -      G      44           -
LGA    G    56_A      N      45          1.192
LGA    G    57_A      A      46          0.965
LGA    R    58_A      A      47          1.104
LGA    R    59_A      E      48          1.105
LGA    T    60_A      I      49          1.046
LGA    A    61_A      R      50          0.816
LGA    T    62_A      V      51          2.129
LGA    L    63_A      R      52          2.509
LGA    L    64_A      H      53          1.899
LGA    R    65_A      I      54          2.271
LGA    R    66_A      E      55          4.029
LGA    X    67_A      R      56          4.176
LGA    Q    68_A      F      57          3.560
LGA    G    69_A      K      58          2.685
LGA    R    70_A      E      59          3.855
LGA    V    71_A      P      60           #
LGA    G    72_A      D      61          4.677
LGA    F    73_A      L      62          2.709
LGA    E    74_A      Y      63          1.591
LGA    V    75_A      G      64          1.555
LGA    K    76_A      E      65          2.149
LGA    I    77_A      L      66          2.166
LGA    H    78_A      L      67          2.177
LGA    R    79_A      T      68          2.115
LGA    I    80_A      R      69          1.655
LGA    G    81_A      V      70          2.044
LGA    A    82_A      I      71          1.616
LGA    D    83_A      V      72          1.983
LGA    G    84_A      G      73          1.794
LGA    A    85_A      N      74          0.971
LGA    A    86_A      V      75          0.927
LGA    V    87_A      V      76          1.085
LGA    L    88_A      I      77          1.709
LGA    T    89_A      D      78          2.536
LGA    E    90_A      H      79          2.542
LGA    R    91_A      E      80          2.194
LGA    T    92_A      T      81          1.880
LGA    D    93_A      V      82          2.044
LGA    A    94_A      T      83          2.013
LGA    L    95_A      R      84          2.511
LGA    I    96_A      -       -           -
LGA    I    97_A      -       -           -
LGA    G    98_A      -       -           -
LGA    P    99_A      -       -           -
LGA    L   100_A      N      85          2.445
LGA    R   101_A      F      86          5.506
LGA    -       -      P      87           -
LGA    -       -      E      88           -
LGA    -       -      G      89           -
LGA    -       -      K      90           -
LGA    V   102_A      G      91          1.287
LGA    Q   103_A      E      92          0.373
LGA    F   104_A      V      93          1.631
LGA    W   105_A      D      94          1.172
LGA    V   106_A      V      95          1.259
LGA    C   107_A      A      96          1.541
LGA    G   108_A      C      97          1.961
LGA    V   109_A      I      98          1.232
LGA    F   110_A      Y      99          0.693
LGA    E   111_A      E     100          0.443
LGA    V   112_A      V     101          0.966
LGA    D   113_A      E     102          2.013
LGA    D   114_A      N     103          3.115
LGA    G   115_A      G     104          3.100
LGA    R   116_A      R     105          1.677
LGA    I   117_A      I     106          1.474
LGA    T   118_A      A     107          1.849
LGA    L   119_A      K     108          1.844
LGA    W   120_A      A     109          1.667
LGA    R   121_A      W     110          1.379
LGA    D   122_A      F     111          1.218
LGA    Y   123_A      K     112          1.374
LGA    F   124_A      I     113          1.849
LGA    D   125_A      G     114          3.069
LGA    V   126_A      -       -           -
LGA    Y   127_A      -       -           -
LGA    D   128_A      E     115          2.440
LGA    X   129_A      P     116          1.446
LGA    F   130_A      -       -           -
LGA    K   131_A      R     117          4.070
LGA    G   132_A      I     118          3.754
LGA    L   133_A      -       -           -
LGA    L   134_A      -       -           -
LGA    R   135_A      -       -           -
LGA    G   136_A      -       -           -
LGA    L   137_A      -       -           -
LGA    V   138_A      -       -           -
LGA    A   139_A      -       -           -
LGA    L   140_A      -       -           -
LGA    V   141_A      -       -           -
LGA    V   142_A      -       -           -
LGA    P   143_A      -       -           -
LGA    S   144_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  132  117    5.0    110    2.08    17.27     71.205     5.049

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.528172 * X  +   0.655453 * Y  +   0.539830 * Z  + -80.273476
  Y_new =   0.806291 * X  +  -0.586520 * Y  +  -0.076735 * Z  +  -1.660437
  Z_new =   0.266325 * X  +   0.475789 * Y  +  -0.838269 * Z  +  -4.439511 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.625349   -0.516244  [ DEG:   150.4214    -29.5786 ]
  Theta =  -0.269578   -2.872014  [ DEG:   -15.4457   -164.5543 ]
  Phi   =   0.990870   -2.150723  [ DEG:    56.7727   -123.2273 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2bng_A                                        
REMARK     2: T0475.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2bng_A.T0475.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  132  117   5.0  110   2.08   17.27  71.205
REMARK  ---------------------------------------------------------- 
MOLECULE 2bng_A
HEADER    HYDROLASE                               24-MAR-05   2BNG              
TITLE     STRUCTURE OF AN M.TUBERCULOSIS LEH-LIKE EPOXIDE HYDROLASE             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MB2760;                                                    
COMPND   3 CHAIN: A, B, C;                                                      
COMPND   4 SYNONYM: LEH-LIKE EPOXIDE HYDROLASE;                                 
COMPND   5 EC: 3.3.2.8;                                                         
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 OTHER_DETAILS: ENDOGENOUS LIGAND OF UNKNOWN ORIGIN BOUND             
COMPND   8 IN THE ACTIVE SITE                                                   
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MYCOBACTERIUM TUBERCULOSIS;                     
SOURCE   3 STRAIN: H37RV;                                                       
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI                                  
KEYWDS    M.TUBERCULOSIS, EPOXIDE HYDROLASE, LIMONENE, HYDROLASE,               
KEYWDS   2 STRUCTURAL PROTEOMICS IN EUROPE, SPINE, STRUCTURAL GENOMICS          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    P.JOHANSSON,M.ARAND,T.UNGE,T.BERGFORS,T.A.JONES,S.L.MOWBRAY,          
AUTHOR   2 STRUCTURAL PROTEOMICS IN EUROPE (SPINE)                              
REVDAT   3   20-DEC-06 2BNG    1       JRNL                                     
REVDAT   2   10-AUG-05 2BNG    1       MTRIX1 MTRIX2 MTRIX3                     
REVDAT   1   03-AUG-05 2BNG    0                                                
JRNL        AUTH   P.JOHANSSON,T.UNGE,A.CRONIN,M.ARAND,T.BERGFORS,              
JRNL        AUTH 2 T.A.JONES,S.L.MOWBRAY                                        
JRNL        TITL   STRUCTURE OF AN ATYPICAL EPOXIDE HYDROLASE FROM              
JRNL        TITL 2 MYCOBACTERIUM TUBERCULOSIS GIVES INSIGHTS INTO ITS           
JRNL        TITL 3 FUNCTION.                                                    
JRNL        REF    J.MOL.BIOL.                   V. 351  1048 2005              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 2.50 ANGSTROMS.                                          
DBREF  2BNG A    1   149  UNP    Q7TY00   Q7TY00_MYCBO     1    149             
DBREF  2BNG B    1   149  UNP    Q7TY00   Q7TY00_MYCBO     1    149             
DBREF  2BNG C    1   149  UNP    Q7TY00   Q7TY00_MYCBO     1    149             
SEQRES   1 A  149  MSE ALA GLU LEU THR GLU THR SER PRO GLU THR PRO GLU          
SEQRES   2 A  149  THR THR GLU ALA ILE ARG ALA VAL GLU ALA PHE LEU ASN          
SEQRES   3 A  149  ALA LEU GLN ASN GLU ASP PHE ASP THR VAL ASP ALA ALA          
SEQRES   4 A  149  LEU GLY ASP ASP LEU VAL TYR GLU ASN VAL GLY PHE SER          
SEQRES   5 A  149  ARG ILE ARG GLY GLY ARG ARG THR ALA THR LEU LEU ARG          
SEQRES   6 A  149  ARG MSE GLN GLY ARG VAL GLY PHE GLU VAL LYS ILE HIS          
SEQRES   7 A  149  ARG ILE GLY ALA ASP GLY ALA ALA VAL LEU THR GLU ARG          
SEQRES   8 A  149  THR ASP ALA LEU ILE ILE GLY PRO LEU ARG VAL GLN PHE          
SEQRES   9 A  149  TRP VAL CYS GLY VAL PHE GLU VAL ASP ASP GLY ARG ILE          
SEQRES  10 A  149  THR LEU TRP ARG ASP TYR PHE ASP VAL TYR ASP MSE PHE          
SEQRES  11 A  149  LYS GLY LEU LEU ARG GLY LEU VAL ALA LEU VAL VAL PRO          
SEQRES  12 A  149  SER LEU LYS ALA THR LEU                                      
SEQRES   1 B  149  MSE ALA GLU LEU THR GLU THR SER PRO GLU THR PRO GLU          
SEQRES   2 B  149  THR THR GLU ALA ILE ARG ALA VAL GLU ALA PHE LEU ASN          
SEQRES   3 B  149  ALA LEU GLN ASN GLU ASP PHE ASP THR VAL ASP ALA ALA          
SEQRES   4 B  149  LEU GLY ASP ASP LEU VAL TYR GLU ASN VAL GLY PHE SER          
SEQRES   5 B  149  ARG ILE ARG GLY GLY ARG ARG THR ALA THR LEU LEU ARG          
SEQRES   6 B  149  ARG MSE GLN GLY ARG VAL GLY PHE GLU VAL LYS ILE HIS          
SEQRES   7 B  149  ARG ILE GLY ALA ASP GLY ALA ALA VAL LEU THR GLU ARG          
SEQRES   8 B  149  THR ASP ALA LEU ILE ILE GLY PRO LEU ARG VAL GLN PHE          
SEQRES   9 B  149  TRP VAL CYS GLY VAL PHE GLU VAL ASP ASP GLY ARG ILE          
SEQRES  10 B  149  THR LEU TRP ARG ASP TYR PHE ASP VAL TYR ASP MSE PHE          
SEQRES  11 B  149  LYS GLY LEU LEU ARG GLY LEU VAL ALA LEU VAL VAL PRO          
SEQRES  12 B  149  SER LEU LYS ALA THR LEU                                      
SEQRES   1 C  149  MSE ALA GLU LEU THR GLU THR SER PRO GLU THR PRO GLU          
SEQRES   2 C  149  THR THR GLU ALA ILE ARG ALA VAL GLU ALA PHE LEU ASN          
SEQRES   3 C  149  ALA LEU GLN ASN GLU ASP PHE ASP THR VAL ASP ALA ALA          
SEQRES   4 C  149  LEU GLY ASP ASP LEU VAL TYR GLU ASN VAL GLY PHE SER          
SEQRES   5 C  149  ARG ILE ARG GLY GLY ARG ARG THR ALA THR LEU LEU ARG          
SEQRES   6 C  149  ARG MSE GLN GLY ARG VAL GLY PHE GLU VAL LYS ILE HIS          
SEQRES   7 C  149  ARG ILE GLY ALA ASP GLY ALA ALA VAL LEU THR GLU ARG          
SEQRES   8 C  149  THR ASP ALA LEU ILE ILE GLY PRO LEU ARG VAL GLN PHE          
SEQRES   9 C  149  TRP VAL CYS GLY VAL PHE GLU VAL ASP ASP GLY ARG ILE          
SEQRES  10 C  149  THR LEU TRP ARG ASP TYR PHE ASP VAL TYR ASP MSE PHE          
SEQRES  11 C  149  LYS GLY LEU LEU ARG GLY LEU VAL ALA LEU VAL VAL PRO          
SEQRES  12 C  149  SER LEU LYS ALA THR LEU                                      
HET    MSE  A  67       8                                                       
HET    MSE  A 129       8                                                       
HET    MSE  B  67       8                                                       
HET    MSE  B 129       8                                                       
HET    MSE  C  67       8                                                       
HET    MSE  C 129       8                                                       
HET     CA  B1145       1                                                       
HET     CA  B1146       1                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      CA CALCIUM ION                                                      
FORMUL   1  MSE    6(C5 H11 N O2 SE)                                            
FORMUL   4   CA    2(CA 2+)                                                     
FORMUL   6  HOH   *89(H2 O)                                                     
CRYST1   81.901   81.901  117.025  90.00  90.00 120.00 P 32 2 1     18          
ATOM      1  N   GLU A  13      -0.418  -2.699  -3.428  1.00 76.85           N  
ATOM      2  CA  GLU A  13       0.754  -3.473  -3.918  1.00 74.93           C  
ATOM      3  C   GLU A  13       1.261  -4.405  -2.817  1.00 71.45           C  
ATOM      4  O   GLU A  13       1.212  -5.637  -2.919  1.00 68.62           O  
ATOM      5  CB  GLU A  13       1.864  -2.498  -4.328  1.00 77.74           C  
ATOM      6  CG  GLU A  13       2.896  -3.077  -5.283  1.00 78.28           C  
ATOM      7  CD  GLU A  13       2.353  -3.195  -6.696  1.00 80.56           C  
ATOM      8  OE1 GLU A  13       1.565  -4.131  -6.965  1.00 78.96           O  
ATOM      9  OE2 GLU A  13       2.719  -2.347  -7.533  1.00 83.63           O  
ATOM     10  N   THR A  14       1.774  -3.768  -1.775  1.00 71.31           N  
ATOM     11  CA  THR A  14       2.173  -4.387  -0.529  1.00 68.92           C  
ATOM     12  C   THR A  14       0.956  -5.043   0.154  1.00 67.10           C  
ATOM     13  O   THR A  14       0.998  -6.231   0.497  1.00 64.31           O  
ATOM     14  CB  THR A  14       2.763  -3.294   0.378  1.00 70.98           C  
ATOM     15  OG1 THR A  14       3.918  -2.731  -0.252  1.00 73.36           O  
ATOM     16  CG2 THR A  14       3.200  -3.829   1.698  1.00 69.31           C  
ATOM     17  N   THR A  15      -0.119  -4.268   0.348  1.00 68.41           N  
ATOM     18  CA  THR A  15      -1.361  -4.783   0.937  1.00 66.71           C  
ATOM     19  C   THR A  15      -1.993  -5.850   0.076  1.00 64.49           C  
ATOM     20  O   THR A  15      -2.517  -6.843   0.589  1.00 62.61           O  
ATOM     21  CB  THR A  15      -2.463  -3.711   1.160  1.00 69.89           C  
ATOM     22  OG1 THR A  15      -2.104  -2.500   0.491  1.00 72.94           O  
ATOM     23  CG2 THR A  15      -2.581  -3.340   2.530  1.00 69.79           C  
ATOM     24  N   GLU A  16      -1.965  -5.618  -1.233  1.00 64.45           N  
ATOM     25  CA  GLU A  16      -2.444  -6.566  -2.224  1.00 62.18           C  
ATOM     26  C   GLU A  16      -1.783  -7.929  -2.046  1.00 57.94           C  
ATOM     27  O   GLU A  16      -2.465  -8.966  -1.993  1.00 56.21           O  
ATOM     28  CB  GLU A  16      -2.065  -6.041  -3.591  1.00 64.20           C  
ATOM     29  CG  GLU A  16      -3.155  -5.428  -4.376  1.00 69.18           C  
ATOM     30  CD  GLU A  16      -3.322  -6.083  -5.685  1.00 71.82           C  
ATOM     31  OE1 GLU A  16      -2.546  -5.973  -6.663  1.00 74.21           O  
ATOM     32  OE2 GLU A  16      -4.294  -6.777  -5.719  1.00 72.45           O  
ATOM     33  N   ALA A  17      -0.448  -7.924  -1.965  1.00 55.76           N  
ATOM     34  CA  ALA A  17       0.337  -9.162  -1.833  1.00 51.52           C  
ATOM     35  C   ALA A  17       0.025  -9.877  -0.517  1.00 48.66           C  
ATOM     36  O   ALA A  17      -0.127 -11.092  -0.491  1.00 46.30           O  
ATOM     37  CB  ALA A  17       1.832  -8.881  -1.983  1.00 51.35           C  
ATOM     38  N   ILE A  18      -0.114  -9.100   0.550  1.00 48.85           N  
ATOM     39  CA  ILE A  18      -0.491  -9.608   1.861  1.00 47.37           C  
ATOM     40  C   ILE A  18      -1.874 -10.271   1.843  1.00 47.10           C  
ATOM     41  O   ILE A  18      -2.065 -11.369   2.377  1.00 45.28           O  
ATOM     42  CB  ILE A  18      -0.416  -8.483   2.924  1.00 49.14           C  
ATOM     43  CG1 ILE A  18       1.054  -8.161   3.236  1.00 48.75           C  
ATOM     44  CG2 ILE A  18      -1.213  -8.847   4.197  1.00 47.84           C  
ATOM     45  CD1 ILE A  18       1.275  -6.917   4.131  1.00 50.73           C  
ATOM     46  N   ARG A  19      -2.830  -9.612   1.205  1.00 48.66           N  
ATOM     47  CA  ARG A  19      -4.176 -10.137   1.128  1.00 48.50           C  
ATOM     48  C   ARG A  19      -4.301 -11.370   0.292  1.00 46.03           C  
ATOM     49  O   ARG A  19      -5.109 -12.245   0.619  1.00 45.39           O  
ATOM     50  CB  ARG A  19      -5.101  -9.098   0.584  1.00 51.38           C  
ATOM     51  CG  ARG A  19      -5.629  -8.330   1.702  1.00 54.93           C  
ATOM     52  CD  ARG A  19      -5.844  -6.976   1.302  1.00 59.85           C  
ATOM     53  NE  ARG A  19      -7.188  -6.793   0.892  1.00 65.91           N  
ATOM     54  CZ  ARG A  19      -7.518  -6.099  -0.176  1.00 68.57           C  
ATOM     55  NH1 ARG A  19      -6.636  -5.518  -0.978  1.00 69.75           N  
ATOM     56  NH2 ARG A  19      -8.772  -5.964  -0.416  1.00 69.97           N  
ATOM     57  N   ALA A  20      -3.527 -11.441  -0.790  1.00 44.57           N  
ATOM     58  CA  ALA A  20      -3.512 -12.646  -1.600  1.00 42.44           C  
ATOM     59  C   ALA A  20      -3.027 -13.820  -0.734  1.00 40.25           C  
ATOM     60  O   ALA A  20      -3.611 -14.906  -0.757  1.00 39.21           O  
ATOM     61  CB  ALA A  20      -2.648 -12.465  -2.836  1.00 42.15           C  
ATOM     62  N   VAL A  21      -1.986 -13.585   0.067  1.00 39.63           N  
ATOM     63  CA  VAL A  21      -1.417 -14.657   0.873  1.00 37.26           C  
ATOM     64  C   VAL A  21      -2.402 -15.111   1.951  1.00 37.59           C  
ATOM     65  O   VAL A  21      -2.621 -16.301   2.144  1.00 36.44           O  
ATOM     66  CB  VAL A  21       0.019 -14.312   1.426  1.00 36.86           C  
ATOM     67  CG1 VAL A  21       0.504 -15.380   2.432  1.00 33.47           C  
ATOM     68  CG2 VAL A  21       1.013 -14.202   0.288  1.00 34.22           C  
ATOM     69  N   GLU A  22      -3.001 -14.159   2.644  1.00 39.87           N  
ATOM     70  CA  GLU A  22      -4.021 -14.471   3.649  1.00 41.60           C  
ATOM     71  C   GLU A  22      -5.175 -15.219   3.033  1.00 40.93           C  
ATOM     72  O   GLU A  22      -5.567 -16.277   3.536  1.00 40.62           O  
ATOM     73  CB  GLU A  22      -4.548 -13.204   4.322  1.00 43.59           C  
ATOM     74  CG  GLU A  22      -3.582 -12.666   5.363  1.00 46.62           C  
ATOM     75  CD  GLU A  22      -3.938 -11.289   5.897  1.00 51.10           C  
ATOM     76  OE1 GLU A  22      -4.770 -10.556   5.285  1.00 57.25           O  
ATOM     77  OE2 GLU A  22      -3.359 -10.932   6.948  1.00 55.69           O  
ATOM     78  N   ALA A  23      -5.709 -14.682   1.940  1.00 41.36           N  
ATOM     79  CA  ALA A  23      -6.838 -15.309   1.264  1.00 40.84           C  
ATOM     80  C   ALA A  23      -6.470 -16.738   0.903  1.00 38.53           C  
ATOM     81  O   ALA A  23      -7.248 -17.662   1.157  1.00 38.10           O  
ATOM     82  CB  ALA A  23      -7.256 -14.497   0.029  1.00 41.71           C  
ATOM     83  N   PHE A  24      -5.266 -16.936   0.362  1.00 37.20           N  
ATOM     84  CA  PHE A  24      -4.851 -18.281  -0.047  1.00 35.54           C  
ATOM     85  C   PHE A  24      -4.825 -19.254   1.140  1.00 34.71           C  
ATOM     86  O   PHE A  24      -5.376 -20.370   1.060  1.00 33.87           O  
ATOM     87  CB  PHE A  24      -3.497 -18.270  -0.767  1.00 34.91           C  
ATOM     88  CG  PHE A  24      -2.833 -19.633  -0.826  1.00 32.68           C  
ATOM     89  CD1 PHE A  24      -3.368 -20.645  -1.632  1.00 30.88           C  
ATOM     90  CD2 PHE A  24      -1.699 -19.903  -0.066  1.00 30.84           C  
ATOM     91  CE1 PHE A  24      -2.775 -21.901  -1.708  1.00 32.16           C  
ATOM     92  CE2 PHE A  24      -1.089 -21.156  -0.122  1.00 32.28           C  
ATOM     93  CZ  PHE A  24      -1.634 -22.173  -0.937  1.00 32.03           C  
ATOM     94  N   LEU A  25      -4.200 -18.824   2.233  1.00 34.69           N  
ATOM     95  CA  LEU A  25      -4.025 -19.683   3.401  1.00 34.51           C  
ATOM     96  C   LEU A  25      -5.338 -19.998   4.096  1.00 35.33           C  
ATOM     97  O   LEU A  25      -5.535 -21.122   4.558  1.00 34.82           O  
ATOM     98  CB  LEU A  25      -3.005 -19.088   4.370  1.00 34.40           C  
ATOM     99  CG  LEU A  25      -1.562 -19.138   3.828  1.00 34.38           C  
ATOM    100  CD1 LEU A  25      -0.640 -18.189   4.606  1.00 33.93           C  
ATOM    101  CD2 LEU A  25      -1.033 -20.576   3.817  1.00 31.38           C  
ATOM    102  N   ASN A  26      -6.238 -19.016   4.149  1.00 36.72           N  
ATOM    103  CA  ASN A  26      -7.598 -19.270   4.611  1.00 37.99           C  
ATOM    104  C   ASN A  26      -8.376 -20.209   3.710  1.00 36.90           C  
ATOM    105  O   ASN A  26      -9.133 -21.031   4.203  1.00 36.99           O  
ATOM    106  CB  ASN A  26      -8.366 -17.968   4.857  1.00 40.39           C  
ATOM    107  CG  ASN A  26      -7.859 -17.229   6.104  1.00 44.12           C  
ATOM    108  OD1 ASN A  26      -7.808 -17.800   7.203  1.00 46.08           O  
ATOM    109  ND2 ASN A  26      -7.464 -15.962   5.933  1.00 46.15           N  
ATOM    110  N   ALA A  27      -8.185 -20.081   2.400  1.00 36.43           N  
ATOM    111  CA  ALA A  27      -8.847 -20.973   1.433  1.00 36.39           C  
ATOM    112  C   ALA A  27      -8.389 -22.412   1.613  1.00 35.27           C  
ATOM    113  O   ALA A  27      -9.209 -23.324   1.548  1.00 36.04           O  
ATOM    114  CB  ALA A  27      -8.638 -20.500   0.006  1.00 35.92           C  
ATOM    115  N   LEU A  28      -7.090 -22.608   1.848  1.00 34.85           N  
ATOM    116  CA  LEU A  28      -6.535 -23.927   2.183  1.00 34.50           C  
ATOM    117  C   LEU A  28      -7.240 -24.543   3.381  1.00 34.94           C  
ATOM    118  O   LEU A  28      -7.719 -25.667   3.328  1.00 35.31           O  
ATOM    119  CB  LEU A  28      -5.052 -23.806   2.511  1.00 33.60           C  
ATOM    120  CG  LEU A  28      -4.032 -24.330   1.518  1.00 34.81           C  
ATOM    121  CD1 LEU A  28      -2.652 -24.375   2.171  1.00 33.56           C  
ATOM    122  CD2 LEU A  28      -4.432 -25.715   0.985  1.00 34.84           C  
ATOM    123  N   GLN A  29      -7.297 -23.786   4.462  1.00 35.97           N  
ATOM    124  CA  GLN A  29      -7.920 -24.233   5.687  1.00 37.94           C  
ATOM    125  C   GLN A  29      -9.406 -24.539   5.469  1.00 39.65           C  
ATOM    126  O   GLN A  29      -9.932 -25.521   5.995  1.00 40.31           O  
ATOM    127  CB  GLN A  29      -7.750 -23.148   6.736  1.00 38.81           C  
ATOM    128  CG  GLN A  29      -8.470 -23.387   8.023  1.00 41.71           C  
ATOM    129  CD  GLN A  29      -7.832 -22.615   9.153  1.00 44.15           C  
ATOM    130  OE1 GLN A  29      -7.464 -23.186  10.163  1.00 46.74           O  
ATOM    131  NE2 GLN A  29      -7.670 -21.325   8.977  1.00 44.41           N  
ATOM    132  N   ASN A  30     -10.073 -23.717   4.667  1.00 40.63           N  
ATOM    133  CA  ASN A  30     -11.506 -23.847   4.483  1.00 42.79           C  
ATOM    134  C   ASN A  30     -11.876 -24.814   3.373  1.00 42.45           C  
ATOM    135  O   ASN A  30     -13.054 -25.041   3.131  1.00 43.14           O  
ATOM    136  CB  ASN A  30     -12.157 -22.473   4.235  1.00 44.63           C  
ATOM    137  CG  ASN A  30     -12.101 -21.558   5.467  1.00 47.71           C  
ATOM    138  OD1 ASN A  30     -11.961 -22.031   6.609  1.00 49.14           O  
ATOM    139  ND2 ASN A  30     -12.202 -20.235   5.240  1.00 50.78           N  
ATOM    140  N   GLU A  31     -10.868 -25.378   2.704  1.00 41.24           N  
ATOM    141  CA  GLU A  31     -11.066 -26.319   1.589  1.00 41.49           C  
ATOM    142  C   GLU A  31     -11.817 -25.699   0.428  1.00 41.74           C  
ATOM    143  O   GLU A  31     -12.633 -26.337  -0.198  1.00 42.46           O  
ATOM    144  CB  GLU A  31     -11.749 -27.593   2.074  1.00 41.82           C  
ATOM    145  CG  GLU A  31     -10.812 -28.480   2.893  1.00 42.46           C  
ATOM    146  CD  GLU A  31     -11.521 -29.620   3.617  1.00 45.16           C  
ATOM    147  OE1 GLU A  31     -11.281 -29.886   4.747  1.00 48.27           O  
ATOM    148  OE2 GLU A  31     -12.361 -30.324   3.130  1.00 47.95           O  
ATOM    149  N   ASP A  32     -11.525 -24.429   0.176  1.00 41.98           N  
ATOM    150  CA  ASP A  32     -12.134 -23.653  -0.884  1.00 42.67           C  
ATOM    151  C   ASP A  32     -11.150 -23.751  -2.045  1.00 41.44           C  
ATOM    152  O   ASP A  32     -10.299 -22.880  -2.233  1.00 41.00           O  
ATOM    153  CB  ASP A  32     -12.330 -22.212  -0.389  1.00 43.56           C  
ATOM    154  CG  ASP A  32     -12.926 -21.295  -1.440  1.00 46.16           C  
ATOM    155  OD1 ASP A  32     -13.230 -21.762  -2.568  1.00 45.95           O  
ATOM    156  OD2 ASP A  32     -13.071 -20.084  -1.133  1.00 48.49           O  
ATOM    157  N   PHE A  33     -11.262 -24.835  -2.805  1.00 40.86           N  
ATOM    158  CA  PHE A  33     -10.251 -25.192  -3.800  1.00 40.38           C  
ATOM    159  C   PHE A  33     -10.231 -24.436  -5.107  1.00 41.36           C  
ATOM    160  O   PHE A  33      -9.176 -24.338  -5.738  1.00 40.94           O  
ATOM    161  CB  PHE A  33     -10.231 -26.697  -4.056  1.00 40.19           C  
ATOM    162  CG  PHE A  33      -9.761 -27.480  -2.879  1.00 40.22           C  
ATOM    163  CD1 PHE A  33      -8.451 -27.337  -2.416  1.00 39.38           C  
ATOM    164  CD2 PHE A  33     -10.629 -28.346  -2.200  1.00 41.82           C  
ATOM    165  CE1 PHE A  33      -7.986 -28.059  -1.291  1.00 40.24           C  
ATOM    166  CE2 PHE A  33     -10.177 -29.077  -1.067  1.00 42.59           C  
ATOM    167  CZ  PHE A  33      -8.848 -28.932  -0.610  1.00 39.71           C  
ATOM    168  N   ASP A  34     -11.381 -23.902  -5.519  1.00 42.72           N  
ATOM    169  CA  ASP A  34     -11.398 -22.942  -6.618  1.00 44.23           C  
ATOM    170  C   ASP A  34     -10.582 -21.714  -6.280  1.00 43.39           C  
ATOM    171  O   ASP A  34      -9.843 -21.246  -7.113  1.00 43.74           O  
ATOM    172  CB  ASP A  34     -12.825 -22.566  -7.014  1.00 46.17           C  
ATOM    173  CG  ASP A  34     -13.609 -23.755  -7.496  1.00 48.63           C  
ATOM    174  OD1 ASP A  34     -14.819 -23.648  -7.722  1.00 53.61           O  
ATOM    175  OD2 ASP A  34     -13.038 -24.833  -7.651  1.00 49.56           O  
ATOM    176  N   THR A  35     -10.702 -21.221  -5.052  1.00 42.83           N  
ATOM    177  CA  THR A  35      -9.952 -20.039  -4.624  1.00 42.74           C  
ATOM    178  C   THR A  35      -8.460 -20.366  -4.548  1.00 41.64           C  
ATOM    179  O   THR A  35      -7.639 -19.569  -5.007  1.00 42.50           O  
ATOM    180  CB  THR A  35     -10.501 -19.467  -3.284  1.00 42.90           C  
ATOM    181  OG1 THR A  35     -11.875 -19.100  -3.473  1.00 43.53           O  
ATOM    182  CG2 THR A  35      -9.690 -18.260  -2.809  1.00 41.43           C  
ATOM    183  N   VAL A  36      -8.128 -21.538  -4.000  1.00 39.97           N  
ATOM    184  CA  VAL A  36      -6.771 -22.072  -4.067  1.00 38.83           C  
ATOM    185  C   VAL A  36      -6.236 -22.088  -5.502  1.00 39.80           C  
ATOM    186  O   VAL A  36      -5.144 -21.592  -5.730  1.00 40.18           O  
ATOM    187  CB  VAL A  36      -6.675 -23.485  -3.445  1.00 37.78           C  
ATOM    188  CG1 VAL A  36      -5.316 -24.088  -3.705  1.00 35.99           C  
ATOM    189  CG2 VAL A  36      -6.956 -23.448  -1.957  1.00 36.11           C  
ATOM    190  N   ASP A  37      -7.002 -22.638  -6.448  1.00 40.95           N  
ATOM    191  CA  ASP A  37      -6.687 -22.577  -7.884  1.00 42.60           C  
ATOM    192  C   ASP A  37      -6.419 -21.177  -8.420  1.00 43.11           C  
ATOM    193  O   ASP A  37      -5.461 -20.955  -9.158  1.00 43.66           O  
ATOM    194  CB  ASP A  37      -7.833 -23.182  -8.690  1.00 44.36           C  
ATOM    195  CG  ASP A  37      -7.582 -24.610  -9.051  1.00 47.68           C  
ATOM    196  OD1 ASP A  37      -6.546 -24.859  -9.707  1.00 51.31           O  
ATOM    197  OD2 ASP A  37      -8.409 -25.487  -8.696  1.00 51.86           O  
ATOM    198  N   ALA A  38      -7.285 -20.238  -8.053  1.00 43.24           N  
ATOM    199  CA  ALA A  38      -7.202 -18.879  -8.563  1.00 44.10           C  
ATOM    200  C   ALA A  38      -5.996 -18.151  -7.954  1.00 43.12           C  
ATOM    201  O   ALA A  38      -5.394 -17.279  -8.577  1.00 44.70           O  
ATOM    202  CB  ALA A  38      -8.504 -18.134  -8.290  1.00 44.83           C  
ATOM    203  N   ALA A  39      -5.628 -18.534  -6.744  1.00 40.85           N  
ATOM    204  CA  ALA A  39      -4.503 -17.889  -6.054  1.00 40.02           C  
ATOM    205  C   ALA A  39      -3.105 -18.252  -6.588  1.00 39.31           C  
ATOM    206  O   ALA A  39      -2.173 -17.458  -6.442  1.00 39.40           O  
ATOM    207  CB  ALA A  39      -4.575 -18.153  -4.547  1.00 38.34           C  
ATOM    208  N   LEU A  40      -2.958 -19.438  -7.189  1.00 38.38           N  
ATOM    209  CA  LEU A  40      -1.623 -19.951  -7.512  1.00 37.54           C  
ATOM    210  C   LEU A  40      -1.222 -19.677  -8.950  1.00 39.21           C  
ATOM    211  O   LEU A  40      -1.966 -20.016  -9.867  1.00 39.91           O  
ATOM    212  CB  LEU A  40      -1.555 -21.453  -7.210  1.00 35.75           C  
ATOM    213  CG  LEU A  40      -1.682 -21.858  -5.739  1.00 33.84           C  
ATOM    214  CD1 LEU A  40      -1.639 -23.387  -5.582  1.00 30.93           C  
ATOM    215  CD2 LEU A  40      -0.603 -21.188  -4.869  1.00 31.43           C  
ATOM    216  N   GLY A  41      -0.042 -19.078  -9.146  1.00 40.24           N  
ATOM    217  CA  GLY A  41       0.471 -18.787 -10.511  1.00 42.30           C  
ATOM    218  C   GLY A  41       0.830 -20.038 -11.307  1.00 42.75           C  
ATOM    219  O   GLY A  41       1.112 -21.091 -10.732  1.00 41.62           O  
ATOM    220  N   ASP A  42       0.822 -19.929 -12.631  1.00 45.03           N  
ATOM    221  CA  ASP A  42       1.125 -21.059 -13.513  1.00 46.17           C  
ATOM    222  C   ASP A  42       2.527 -21.586 -13.267  1.00 45.81           C  
ATOM    223  O   ASP A  42       2.760 -22.775 -13.344  1.00 45.56           O  
ATOM    224  CB  ASP A  42       0.941 -20.658 -14.985  1.00 49.03           C  
ATOM    225  CG  ASP A  42      -0.538 -20.524 -15.385  1.00 51.20           C  
ATOM    226  OD1 ASP A  42      -0.839 -19.909 -16.431  1.00 55.25           O  
ATOM    227  OD2 ASP A  42      -1.409 -21.048 -14.670  1.00 51.28           O  
ATOM    228  N   ASP A  43       3.454 -20.691 -12.942  1.00 46.30           N  
ATOM    229  CA  ASP A  43       4.848 -21.061 -12.753  1.00 46.40           C  
ATOM    230  C   ASP A  43       5.252 -21.127 -11.283  1.00 43.75           C  
ATOM    231  O   ASP A  43       6.446 -21.032 -10.948  1.00 43.98           O  
ATOM    232  CB  ASP A  43       5.751 -20.096 -13.519  1.00 49.19           C  
ATOM    233  CG  ASP A  43       5.572 -20.195 -15.015  1.00 54.31           C  
ATOM    234  OD1 ASP A  43       6.324 -19.510 -15.731  1.00 59.85           O  
ATOM    235  OD2 ASP A  43       4.695 -20.945 -15.500  1.00 57.46           O  
ATOM    236  N   LEU A  44       4.259 -21.304 -10.410  1.00 41.05           N  
ATOM    237  CA  LEU A  44       4.518 -21.525  -8.988  1.00 38.17           C  
ATOM    238  C   LEU A  44       5.676 -22.506  -8.778  1.00 37.80           C  
ATOM    239  O   LEU A  44       5.695 -23.575  -9.393  1.00 38.14           O  
ATOM    240  CB  LEU A  44       3.258 -22.072  -8.296  1.00 36.45           C  
ATOM    241  CG  LEU A  44       3.391 -22.383  -6.789  1.00 34.16           C  
ATOM    242  CD1 LEU A  44       3.475 -21.099  -5.912  1.00 31.10           C  
ATOM    243  CD2 LEU A  44       2.280 -23.276  -6.312  1.00 31.90           C  
ATOM    244  N   VAL A  45       6.651 -22.138  -7.948  1.00 36.67           N  
ATOM    245  CA  VAL A  45       7.461 -23.170  -7.312  1.00 35.37           C  
ATOM    246  C   VAL A  45       7.040 -23.272  -5.841  1.00 33.54           C  
ATOM    247  O   VAL A  45       6.913 -22.264  -5.146  1.00 32.97           O  
ATOM    248  CB  VAL A  45       9.042 -23.085  -7.560  1.00 37.47           C  
ATOM    249  CG1 VAL A  45       9.433 -22.119  -8.704  1.00 37.14           C  
ATOM    250  CG2 VAL A  45       9.811 -22.782  -6.294  1.00 35.48           C  
ATOM    251  N   TYR A  46       6.767 -24.501  -5.408  1.00 32.56           N  
ATOM    252  CA  TYR A  46       6.286 -24.796  -4.063  1.00 30.67           C  
ATOM    253  C   TYR A  46       7.285 -25.719  -3.389  1.00 30.91           C  
ATOM    254  O   TYR A  46       7.491 -26.843  -3.851  1.00 31.39           O  
ATOM    255  CB  TYR A  46       4.886 -25.438  -4.121  1.00 29.86           C  
ATOM    256  CG  TYR A  46       4.393 -26.076  -2.831  1.00 28.43           C  
ATOM    257  CD1 TYR A  46       4.571 -25.448  -1.581  1.00 27.27           C  
ATOM    258  CD2 TYR A  46       3.721 -27.307  -2.860  1.00 27.68           C  
ATOM    259  CE1 TYR A  46       4.101 -26.048  -0.397  1.00 27.18           C  
ATOM    260  CE2 TYR A  46       3.277 -27.919  -1.694  1.00 26.96           C  
ATOM    261  CZ  TYR A  46       3.458 -27.296  -0.471  1.00 28.55           C  
ATOM    262  OH  TYR A  46       3.001 -27.931   0.662  1.00 27.89           O  
ATOM    263  N   GLU A  47       7.883 -25.229  -2.305  1.00 30.50           N  
ATOM    264  CA  GLU A  47       8.880 -25.940  -1.551  1.00 31.63           C  
ATOM    265  C   GLU A  47       8.440 -26.125  -0.116  1.00 29.91           C  
ATOM    266  O   GLU A  47       7.938 -25.179   0.529  1.00 29.61           O  
ATOM    267  CB  GLU A  47      10.207 -25.161  -1.570  1.00 32.38           C  
ATOM    268  CG  GLU A  47      10.900 -25.217  -2.910  1.00 36.67           C  
ATOM    269  CD  GLU A  47      12.003 -24.158  -3.129  1.00 39.52           C  
ATOM    270  OE1 GLU A  47      12.199 -23.226  -2.287  1.00 42.20           O  
ATOM    271  OE2 GLU A  47      12.668 -24.270  -4.187  1.00 43.95           O  
ATOM    272  N   ASN A  48       8.629 -27.343   0.379  1.00 29.47           N  
ATOM    273  CA  ASN A  48       8.777 -27.586   1.818  1.00 28.92           C  
ATOM    274  C   ASN A  48      10.279 -27.771   2.044  1.00 29.49           C  
ATOM    275  O   ASN A  48      10.865 -28.759   1.563  1.00 29.67           O  
ATOM    276  CB  ASN A  48       7.974 -28.810   2.264  1.00 28.26           C  
ATOM    277  CG  ASN A  48       6.471 -28.582   2.162  1.00 28.91           C  
ATOM    278  OD1 ASN A  48       5.892 -27.774   2.904  1.00 28.16           O  
ATOM    279  ND2 ASN A  48       5.826 -29.303   1.248  1.00 27.93           N  
ATOM    280  N   VAL A  49      10.918 -26.804   2.708  1.00 29.63           N  
ATOM    281  CA  VAL A  49      12.387 -26.784   2.614  1.00 31.21           C  
ATOM    282  C   VAL A  49      13.074 -27.959   3.266  1.00 32.46           C  
ATOM    283  O   VAL A  49      12.702 -28.426   4.359  1.00 32.36           O  
ATOM    284  CB  VAL A  49      13.100 -25.377   2.707  1.00 31.59           C  
ATOM    285  CG1 VAL A  49      12.205 -24.321   2.983  1.00 28.92           C  
ATOM    286  CG2 VAL A  49      14.153 -25.345   3.689  1.00 30.92           C  
ATOM    287  N   GLY A  50      14.029 -28.493   2.511  1.00 34.13           N  
ATOM    288  CA  GLY A  50      14.684 -29.747   2.827  1.00 35.08           C  
ATOM    289  C   GLY A  50      13.897 -30.975   2.410  1.00 35.81           C  
ATOM    290  O   GLY A  50      14.414 -32.077   2.493  1.00 36.85           O  
ATOM    291  N   PHE A  51      12.652 -30.814   1.957  1.00 35.18           N  
ATOM    292  CA  PHE A  51      11.769 -31.985   1.827  1.00 36.30           C  
ATOM    293  C   PHE A  51      11.096 -32.202   0.489  1.00 36.68           C  
ATOM    294  O   PHE A  51      11.031 -33.327   0.031  1.00 37.66           O  
ATOM    295  CB  PHE A  51      10.736 -32.045   2.959  1.00 35.63           C  
ATOM    296  CG  PHE A  51      11.354 -32.329   4.286  1.00 38.30           C  
ATOM    297  CD1 PHE A  51      11.526 -33.653   4.730  1.00 42.25           C  
ATOM    298  CD2 PHE A  51      11.824 -31.291   5.076  1.00 39.32           C  
ATOM    299  CE1 PHE A  51      12.152 -33.916   5.966  1.00 42.71           C  
ATOM    300  CE2 PHE A  51      12.442 -31.537   6.296  1.00 40.33           C  
ATOM    301  CZ  PHE A  51      12.605 -32.848   6.741  1.00 41.18           C  
ATOM    302  N   SER A  52      10.573 -31.140  -0.129  1.00 36.15           N  
ATOM    303  CA  SER A  52       9.875 -31.285  -1.410  1.00 36.43           C  
ATOM    304  C   SER A  52       9.901 -30.017  -2.273  1.00 36.78           C  
ATOM    305  O   SER A  52       9.853 -28.892  -1.772  1.00 35.34           O  
ATOM    306  CB  SER A  52       8.430 -31.754  -1.190  1.00 35.35           C  
ATOM    307  OG  SER A  52       7.631 -30.735  -0.602  1.00 33.45           O  
ATOM    308  N   ARG A  53      10.003 -30.224  -3.578  1.00 38.55           N  
ATOM    309  CA  ARG A  53       9.800 -29.156  -4.523  1.00 39.90           C  
ATOM    310  C   ARG A  53       8.883 -29.576  -5.664  1.00 40.62           C  
ATOM    311  O   ARG A  53       9.098 -30.594  -6.313  1.00 41.99           O  
ATOM    312  CB  ARG A  53      11.103 -28.625  -5.096  1.00 41.56           C  
ATOM    313  CG  ARG A  53      10.804 -27.456  -6.005  1.00 43.78           C  
ATOM    314  CD  ARG A  53      11.974 -26.936  -6.733  1.00 49.75           C  
ATOM    315  NE  ARG A  53      12.792 -26.167  -5.830  1.00 54.69           N  
ATOM    316  CZ  ARG A  53      13.986 -26.588  -5.494  1.00 58.27           C  
ATOM    317  NH1 ARG A  53      14.401 -27.721  -6.025  1.00 60.62           N  
ATOM    318  NH2 ARG A  53      14.743 -25.895  -4.674  1.00 58.28           N  
ATOM    319  N   ILE A  54       7.864 -28.766  -5.900  1.00 40.11           N  
ATOM    320  CA  ILE A  54       6.929 -28.999  -6.979  1.00 41.29           C  
ATOM    321  C   ILE A  54       6.872 -27.728  -7.821  1.00 41.78           C  
ATOM    322  O   ILE A  54       6.849 -26.606  -7.287  1.00 40.89           O  
ATOM    323  CB  ILE A  54       5.513 -29.368  -6.439  1.00 40.28           C  
ATOM    324  CG1 ILE A  54       5.526 -30.761  -5.800  1.00 41.95           C  
ATOM    325  CG2 ILE A  54       4.452 -29.320  -7.540  1.00 40.59           C  
ATOM    326  CD1 ILE A  54       4.331 -31.025  -4.894  1.00 40.26           C  
ATOM    327  N   ARG A  55       6.852 -27.906  -9.137  1.00 43.39           N  
ATOM    328  CA  ARG A  55       6.703 -26.781 -10.064  1.00 44.94           C  
ATOM    329  C   ARG A  55       5.384 -26.803 -10.786  1.00 44.32           C  
ATOM    330  O   ARG A  55       4.984 -27.831 -11.318  1.00 45.50           O  
ATOM    331  CB  ARG A  55       7.821 -26.814 -11.071  1.00 47.62           C  
ATOM    332  CG  ARG A  55       9.096 -26.969 -10.357  1.00 51.36           C  
ATOM    333  CD  ARG A  55      10.188 -27.274 -11.241  1.00 59.78           C  
ATOM    334  NE  ARG A  55      10.610 -26.044 -11.865  1.00 64.67           N  
ATOM    335  CZ  ARG A  55      11.454 -25.184 -11.310  1.00 66.47           C  
ATOM    336  NH1 ARG A  55      11.946 -25.430 -10.148  1.00 65.60           N  
ATOM    337  NH2 ARG A  55      11.813 -24.075 -11.903  1.00 67.56           N  
ATOM    338  N   GLY A  56       4.713 -25.661 -10.824  1.00 43.28           N  
ATOM    339  CA  GLY A  56       3.453 -25.540 -11.533  1.00 42.57           C  
ATOM    340  C   GLY A  56       2.313 -25.313 -10.567  1.00 40.92           C  
ATOM    341  O   GLY A  56       2.131 -26.066  -9.609  1.00 39.97           O  
ATOM    342  N   GLY A  57       1.548 -24.259 -10.810  1.00 40.68           N  
ATOM    343  CA  GLY A  57       0.371 -23.954 -10.014  1.00 39.53           C  
ATOM    344  C   GLY A  57      -0.817 -24.894 -10.160  1.00 39.22           C  
ATOM    345  O   GLY A  57      -1.480 -25.172  -9.165  1.00 37.80           O  
ATOM    346  N   ARG A  58      -1.109 -25.349 -11.387  1.00 40.75           N  
ATOM    347  CA  ARG A  58      -2.144 -26.368 -11.646  1.00 41.15           C  
ATOM    348  C   ARG A  58      -1.820 -27.690 -10.977  1.00 40.19           C  
ATOM    349  O   ARG A  58      -2.701 -28.307 -10.410  1.00 39.27           O  
ATOM    350  CB  ARG A  58      -2.178 -26.816 -13.090  1.00 43.49           C  
ATOM    351  CG  ARG A  58      -2.612 -26.072 -14.291  1.00 46.08           C  
ATOM    352  CD  ARG A  58      -3.857 -25.500 -14.486  1.00 49.66           C  
ATOM    353  NE  ARG A  58      -3.258 -24.263 -14.476  1.00 53.29           N  
ATOM    354  CZ  ARG A  58      -3.341 -23.609 -13.394  1.00 51.89           C  
ATOM    355  NH1 ARG A  58      -4.089 -24.116 -12.462  1.00 50.45           N  
ATOM    356  NH2 ARG A  58      -2.729 -22.502 -13.265  1.00 51.50           N  
ATOM    357  N   ARG A  59      -0.583 -28.165 -11.131  1.00 40.59           N  
ATOM    358  CA  ARG A  59      -0.168 -29.392 -10.475  1.00 40.71           C  
ATOM    359  C   ARG A  59      -0.334 -29.301  -8.948  1.00 38.65           C  
ATOM    360  O   ARG A  59      -0.900 -30.206  -8.311  1.00 38.30           O  
ATOM    361  CB  ARG A  59       1.271 -29.779 -10.848  1.00 42.12           C  
ATOM    362  CG  ARG A  59       1.439 -31.260 -10.687  1.00 46.22           C  
ATOM    363  CD  ARG A  59       2.797 -31.810 -10.548  1.00 52.72           C  
ATOM    364  NE  ARG A  59       3.816 -31.273 -11.407  1.00 59.30           N  
ATOM    365  CZ  ARG A  59       4.953 -31.891 -11.680  1.00 63.25           C  
ATOM    366  NH1 ARG A  59       5.194 -33.042 -11.240  1.00 63.27           N  
ATOM    367  NH2 ARG A  59       5.877 -31.392 -12.408  1.00 64.77           N  
ATOM    368  N   THR A  60       0.144 -28.204  -8.364  1.00 37.19           N  
ATOM    369  CA  THR A  60       0.073 -28.031  -6.914  1.00 35.35           C  
ATOM    370  C   THR A  60      -1.383 -27.959  -6.444  1.00 34.91           C  
ATOM    371  O   THR A  60      -1.785 -28.638  -5.483  1.00 33.79           O  
ATOM    372  CB  THR A  60       0.849 -26.771  -6.441  1.00 34.93           C  
ATOM    373  OG1 THR A  60       2.219 -26.885  -6.819  1.00 34.05           O  
ATOM    374  CG2 THR A  60       0.751 -26.599  -4.946  1.00 31.53           C  
ATOM    375  N   ALA A  61      -2.161 -27.138  -7.141  1.00 35.31           N  
ATOM    376  CA  ALA A  61      -3.570 -26.987  -6.851  1.00 35.21           C  
ATOM    377  C   ALA A  61      -4.320 -28.324  -6.904  1.00 35.68           C  
ATOM    378  O   ALA A  61      -5.095 -28.605  -6.001  1.00 35.23           O  
ATOM    379  CB  ALA A  61      -4.186 -25.981  -7.776  1.00 36.35           C  
ATOM    380  N   THR A  62      -4.107 -29.153  -7.930  1.00 36.64           N  
ATOM    381  CA  THR A  62      -4.833 -30.422  -7.966  1.00 37.57           C  
ATOM    382  C   THR A  62      -4.323 -31.448  -6.930  1.00 37.33           C  
ATOM    383  O   THR A  62      -5.103 -32.213  -6.378  1.00 37.23           O  
ATOM    384  CB  THR A  62      -5.142 -30.970  -9.420  1.00 39.27           C  
ATOM    385  OG1 THR A  62      -4.500 -32.220  -9.697  1.00 39.25           O  
ATOM    386  CG2 THR A  62      -4.799 -30.003 -10.439  1.00 39.39           C  
ATOM    387  N   LEU A  63      -3.039 -31.391  -6.602  1.00 37.28           N  
ATOM    388  CA  LEU A  63      -2.501 -32.204  -5.519  1.00 37.27           C  
ATOM    389  C   LEU A  63      -3.151 -31.892  -4.185  1.00 36.26           C  
ATOM    390  O   LEU A  63      -3.493 -32.812  -3.429  1.00 35.70           O  
ATOM    391  CB  LEU A  63      -0.999 -32.012  -5.406  1.00 37.40           C  
ATOM    392  CG  LEU A  63      -0.394 -32.832  -4.277  1.00 39.75           C  
ATOM    393  CD1 LEU A  63      -0.128 -34.262  -4.781  1.00 43.40           C  
ATOM    394  CD2 LEU A  63       0.883 -32.171  -3.794  1.00 41.25           C  
ATOM    395  N   LEU A  64      -3.304 -30.598  -3.884  1.00 35.74           N  
ATOM    396  CA  LEU A  64      -4.000 -30.185  -2.661  1.00 35.62           C  
ATOM    397  C   LEU A  64      -5.484 -30.581  -2.699  1.00 36.46           C  
ATOM    398  O   LEU A  64      -6.002 -31.151  -1.737  1.00 36.31           O  
ATOM    399  CB  LEU A  64      -3.824 -28.689  -2.388  1.00 34.94           C  
ATOM    400  CG  LEU A  64      -2.376 -28.239  -2.174  1.00 35.23           C  
ATOM    401  CD1 LEU A  64      -2.252 -26.704  -2.379  1.00 36.19           C  
ATOM    402  CD2 LEU A  64      -1.818 -28.695  -0.818  1.00 32.73           C  
ATOM    403  N   ARG A  65      -6.142 -30.305  -3.821  1.00 37.43           N  
ATOM    404  CA  ARG A  65      -7.566 -30.642  -4.003  1.00 39.35           C  
ATOM    405  C   ARG A  65      -7.802 -32.120  -3.724  1.00 39.93           C  
ATOM    406  O   ARG A  65      -8.763 -32.488  -3.067  1.00 40.17           O  
ATOM    407  CB  ARG A  65      -8.055 -30.279  -5.413  1.00 39.83           C  
ATOM    408  CG  ARG A  65      -9.527 -30.550  -5.657  1.00 41.29           C  
ATOM    409  CD  ARG A  65      -9.899 -30.281  -7.129  1.00 42.74           C  
ATOM    410  NE  ARG A  65      -9.848 -28.857  -7.475  1.00 43.87           N  
ATOM    411  CZ  ARG A  65     -10.877 -28.003  -7.394  1.00 45.65           C  
ATOM    412  NH1 ARG A  65     -12.076 -28.386  -6.969  1.00 44.47           N  
ATOM    413  NH2 ARG A  65     -10.702 -26.739  -7.731  1.00 46.64           N  
ATOM    414  N   ARG A  66      -6.880 -32.960  -4.189  1.00 40.46           N  
ATOM    415  CA  ARG A  66      -7.028 -34.409  -4.059  1.00 41.49           C  
ATOM    416  C   ARG A  66      -6.761 -34.998  -2.687  1.00 41.59           C  
ATOM    417  O   ARG A  66      -7.034 -36.157  -2.468  1.00 41.95           O  
ATOM    418  CB  ARG A  66      -6.181 -35.089  -5.102  1.00 41.75           C  
ATOM    419  CG  ARG A  66      -6.825 -34.894  -6.418  1.00 42.65           C  
ATOM    420  CD  ARG A  66      -6.126 -35.568  -7.505  1.00 42.90           C  
ATOM    421  NE  ARG A  66      -6.869 -35.262  -8.715  1.00 43.48           N  
ATOM    422  CZ  ARG A  66      -6.454 -35.531  -9.942  1.00 43.76           C  
ATOM    423  NH1 ARG A  66      -5.304 -36.093 -10.094  1.00 43.25           N  
ATOM    424  NH2 ARG A  66      -7.157 -35.225 -11.014  1.00 42.76           N  
HETATM  425  N   MSE A  67      -6.252 -34.184  -1.773  1.00 41.52           N  
HETATM  426  CA  MSE A  67      -6.063 -34.569  -0.388  1.00 42.85           C  
HETATM  427  C   MSE A  67      -7.324 -34.397   0.462  1.00 42.59           C  
HETATM  428  O   MSE A  67      -7.405 -34.935   1.558  1.00 42.63           O  
HETATM  429  CB  MSE A  67      -4.925 -33.758   0.190  1.00 41.71           C  
HETATM  430  CG  MSE A  67      -3.612 -34.407  -0.090  1.00 43.20           C  
HETATM  431 SE   MSE A  67      -2.282 -33.277   0.583  0.63 44.23          SE  
HETATM  432  CE  MSE A  67      -1.605 -32.594  -0.956  1.00 45.31           C  
ATOM    433  N   GLN A  68      -8.304 -33.670  -0.059  1.00 42.48           N  
ATOM    434  CA  GLN A  68      -9.517 -33.420   0.680  1.00 43.21           C  
ATOM    435  C   GLN A  68     -10.193 -34.712   1.166  1.00 43.94           C  
ATOM    436  O   GLN A  68     -10.433 -35.626   0.385  1.00 44.25           O  
ATOM    437  CB  GLN A  68     -10.468 -32.605  -0.155  1.00 43.45           C  
ATOM    438  CG  GLN A  68     -11.744 -32.552   0.507  1.00 46.08           C  
ATOM    439  CD  GLN A  68     -12.725 -31.682  -0.136  1.00 47.86           C  
ATOM    440  OE1 GLN A  68     -12.731 -31.458  -1.274  1.00 46.90           O  
ATOM    441  NE2 GLN A  68     -13.568 -31.204   0.602  1.00 48.28           N  
ATOM    442  N   GLY A  69     -10.506 -34.767   2.457  1.00 44.06           N  
ATOM    443  CA  GLY A  69     -11.147 -35.931   3.050  1.00 44.92           C  
ATOM    444  C   GLY A  69     -10.118 -36.929   3.569  1.00 44.95           C  
ATOM    445  O   GLY A  69     -10.482 -37.939   4.167  1.00 45.89           O  
ATOM    446  N   ARG A  70      -8.835 -36.660   3.336  1.00 43.38           N  
ATOM    447  CA  ARG A  70      -7.757 -37.487   3.892  1.00 44.11           C  
ATOM    448  C   ARG A  70      -6.855 -36.731   4.822  1.00 42.48           C  
ATOM    449  O   ARG A  70      -6.385 -37.273   5.825  1.00 42.69           O  
ATOM    450  CB  ARG A  70      -6.787 -37.911   2.819  1.00 44.32           C  
ATOM    451  CG  ARG A  70      -7.325 -38.623   1.736  1.00 47.64           C  
ATOM    452  CD  ARG A  70      -7.486 -39.897   2.205  1.00 53.11           C  
ATOM    453  NE  ARG A  70      -7.822 -40.837   1.169  1.00 58.60           N  
ATOM    454  CZ  ARG A  70      -9.065 -41.238   0.897  1.00 61.54           C  
ATOM    455  NH1 ARG A  70     -10.102 -40.732   1.548  1.00 61.76           N  
ATOM    456  NH2 ARG A  70      -9.283 -42.121  -0.068  1.00 62.89           N  
ATOM    457  N   VAL A  71      -6.508 -35.518   4.407  1.00 40.76           N  
ATOM    458  CA  VAL A  71      -5.793 -34.605   5.292  1.00 39.53           C  
ATOM    459  C   VAL A  71      -6.394 -33.203   5.294  1.00 38.43           C  
ATOM    460  O   VAL A  71      -6.602 -32.604   4.241  1.00 37.85           O  
ATOM    461  CB  VAL A  71      -4.229 -34.673   5.110  1.00 38.80           C  
ATOM    462  CG1 VAL A  71      -3.845 -35.336   3.810  1.00 39.44           C  
ATOM    463  CG2 VAL A  71      -3.560 -33.349   5.264  1.00 37.25           C  
ATOM    464  N   GLY A  72      -6.716 -32.734   6.499  1.00 38.12           N  
ATOM    465  CA  GLY A  72      -7.182 -31.379   6.703  1.00 37.70           C  
ATOM    466  C   GLY A  72      -6.015 -30.497   7.109  1.00 36.81           C  
ATOM    467  O   GLY A  72      -4.998 -30.982   7.610  1.00 36.42           O  
ATOM    468  N   PHE A  73      -6.169 -29.202   6.865  1.00 36.29           N  
ATOM    469  CA  PHE A  73      -5.179 -28.220   7.212  1.00 35.83           C  
ATOM    470  C   PHE A  73      -5.794 -27.166   8.117  1.00 36.20           C  
ATOM    471  O   PHE A  73      -6.937 -26.777   7.952  1.00 36.20           O  
ATOM    472  CB  PHE A  73      -4.603 -27.562   5.950  1.00 35.59           C  
ATOM    473  CG  PHE A  73      -4.295 -28.535   4.823  1.00 36.96           C  
ATOM    474  CD1 PHE A  73      -3.287 -29.495   4.957  1.00 38.93           C  
ATOM    475  CD2 PHE A  73      -4.996 -28.478   3.619  1.00 39.69           C  
ATOM    476  CE1 PHE A  73      -2.997 -30.401   3.920  1.00 39.45           C  
ATOM    477  CE2 PHE A  73      -4.710 -29.387   2.554  1.00 39.07           C  
ATOM    478  CZ  PHE A  73      -3.713 -30.343   2.715  1.00 38.09           C  
ATOM    479  N   GLU A  74      -5.014 -26.723   9.092  1.00 36.68           N  
ATOM    480  CA  GLU A  74      -5.320 -25.518   9.845  1.00 37.99           C  
ATOM    481  C   GLU A  74      -4.112 -24.628   9.797  1.00 36.97           C  
ATOM    482  O   GLU A  74      -2.982 -25.107   9.832  1.00 36.03           O  
ATOM    483  CB  GLU A  74      -5.733 -25.840  11.272  1.00 39.34           C  
ATOM    484  CG  GLU A  74      -7.175 -26.357  11.338  1.00 43.30           C  
ATOM    485  CD  GLU A  74      -7.581 -26.881  12.702  1.00 48.52           C  
ATOM    486  OE1 GLU A  74      -6.957 -26.494  13.723  1.00 51.30           O  
ATOM    487  OE2 GLU A  74      -8.541 -27.679  12.748  1.00 51.42           O  
ATOM    488  N   VAL A  75      -4.365 -23.329   9.661  1.00 37.54           N  
ATOM    489  CA  VAL A  75      -3.315 -22.314   9.574  1.00 36.48           C  
ATOM    490  C   VAL A  75      -3.722 -21.142  10.436  1.00 37.57           C  
ATOM    491  O   VAL A  75      -4.802 -20.577  10.251  1.00 38.93           O  
ATOM    492  CB  VAL A  75      -3.068 -21.844   8.111  1.00 36.16           C  
ATOM    493  CG1 VAL A  75      -1.885 -20.865   8.037  1.00 35.82           C  
ATOM    494  CG2 VAL A  75      -2.797 -23.029   7.190  1.00 35.00           C  
ATOM    495  N   LYS A  76      -2.869 -20.803  11.398  1.00 37.32           N  
ATOM    496  CA  LYS A  76      -3.019 -19.591  12.193  1.00 38.18           C  
ATOM    497  C   LYS A  76      -1.808 -18.673  11.913  1.00 37.39           C  
ATOM    498  O   LYS A  76      -0.660 -19.087  12.097  1.00 36.90           O  
ATOM    499  CB  LYS A  76      -3.112 -19.966  13.664  1.00 39.16           C  
ATOM    500  CG  LYS A  76      -3.094 -18.798  14.641  1.00 42.79           C  
ATOM    501  CD  LYS A  76      -4.310 -17.948  14.502  1.00 48.10           C  
ATOM    502  CE  LYS A  76      -4.756 -17.301  15.790  1.00 52.37           C  
ATOM    503  NZ  LYS A  76      -4.305 -15.944  16.010  1.00 54.35           N  
ATOM    504  N   ILE A  77      -2.053 -17.462  11.416  1.00 37.24           N  
ATOM    505  CA  ILE A  77      -0.969 -16.526  11.074  1.00 36.11           C  
ATOM    506  C   ILE A  77      -0.781 -15.553  12.209  1.00 37.40           C  
ATOM    507  O   ILE A  77      -1.689 -14.792  12.505  1.00 39.38           O  
ATOM    508  CB  ILE A  77      -1.278 -15.706   9.805  1.00 36.63           C  
ATOM    509  CG1 ILE A  77      -1.546 -16.622   8.589  1.00 34.57           C  
ATOM    510  CG2 ILE A  77      -0.129 -14.744   9.529  1.00 36.40           C  
ATOM    511  CD1 ILE A  77      -2.158 -15.907   7.384  1.00 35.46           C  
ATOM    512  N   HIS A  78       0.380 -15.583  12.853  1.00 36.78           N  
ATOM    513  CA  HIS A  78       0.638 -14.746  14.018  1.00 38.11           C  
ATOM    514  C   HIS A  78       1.113 -13.369  13.585  1.00 38.84           C  
ATOM    515  O   HIS A  78       0.793 -12.366  14.214  1.00 40.79           O  
ATOM    516  CB  HIS A  78       1.683 -15.391  14.942  1.00 37.51           C  
ATOM    517  CG  HIS A  78       1.340 -16.784  15.368  1.00 37.91           C  
ATOM    518  ND1 HIS A  78       0.275 -17.070  16.201  1.00 39.50           N  
ATOM    519  CD2 HIS A  78       1.912 -17.977  15.064  1.00 36.04           C  
ATOM    520  CE1 HIS A  78       0.201 -18.380  16.383  1.00 38.34           C  
ATOM    521  NE2 HIS A  78       1.185 -18.953  15.707  1.00 36.00           N  
ATOM    522  N   ARG A  79       1.901 -13.352  12.516  1.00 37.36           N  
ATOM    523  CA  ARG A  79       2.513 -12.150  11.959  1.00 37.80           C  
ATOM    524  C   ARG A  79       2.748 -12.360  10.459  1.00 36.79           C  
ATOM    525  O   ARG A  79       3.053 -13.468   9.992  1.00 34.54           O  
ATOM    526  CB  ARG A  79       3.856 -11.839  12.621  1.00 37.90           C  
ATOM    527  CG  ARG A  79       3.816 -11.449  14.082  1.00 39.50           C  
ATOM    528  CD  ARG A  79       5.224 -11.397  14.646  1.00 40.55           C  
ATOM    529  NE  ARG A  79       5.226 -10.890  16.003  1.00 42.45           N  
ATOM    530  CZ  ARG A  79       5.098 -11.593  17.119  1.00 43.11           C  
ATOM    531  NH1 ARG A  79       5.099 -10.993  18.232  1.00 44.38           N  
ATOM    532  NH2 ARG A  79       4.964 -12.872  17.177  1.00 41.43           N  
ATOM    533  N   ILE A  80       2.597 -11.276   9.718  1.00 38.50           N  
ATOM    534  CA  ILE A  80       2.676 -11.282   8.265  1.00 38.06           C  
ATOM    535  C   ILE A  80       3.155  -9.905   7.801  1.00 40.76           C  
ATOM    536  O   ILE A  80       2.508  -8.895   8.083  1.00 43.28           O  
ATOM    537  CB  ILE A  80       1.317 -11.635   7.631  1.00 37.93           C  
ATOM    538  CG1 ILE A  80       1.452 -11.733   6.112  1.00 37.41           C  
ATOM    539  CG2 ILE A  80       0.224 -10.638   8.052  1.00 37.84           C  
ATOM    540  CD1 ILE A  80       0.262 -12.363   5.410  1.00 37.45           C  
ATOM    541  N   GLY A  81       4.303  -9.864   7.124  1.00 40.70           N  
ATOM    542  CA  GLY A  81       4.824  -8.622   6.556  1.00 42.41           C  
ATOM    543  C   GLY A  81       5.241  -8.757   5.112  1.00 42.21           C  
ATOM    544  O   GLY A  81       5.361  -9.855   4.589  1.00 41.09           O  
ATOM    545  N   ALA A  82       5.468  -7.634   4.460  1.00 44.71           N  
ATOM    546  CA  ALA A  82       5.771  -7.646   3.036  1.00 45.51           C  
ATOM    547  C   ALA A  82       6.956  -6.766   2.741  1.00 47.39           C  
ATOM    548  O   ALA A  82       7.204  -5.799   3.432  1.00 48.76           O  
ATOM    549  CB  ALA A  82       4.576  -7.171   2.222  1.00 46.39           C  
ATOM    550  N   ASP A  83       7.687  -7.146   1.707  1.00 48.25           N  
ATOM    551  CA  ASP A  83       8.692  -6.291   1.120  1.00 51.47           C  
ATOM    552  C   ASP A  83       8.600  -6.413  -0.394  1.00 52.01           C  
ATOM    553  O   ASP A  83       9.100  -7.355  -1.014  1.00 50.90           O  
ATOM    554  CB  ASP A  83      10.076  -6.478   1.797  1.00 51.77           C  
ATOM    555  CG  ASP A  83      11.208  -6.796   0.857  1.00 54.10           C  
ATOM    556  OD1 ASP A  83      11.575  -5.888   0.065  1.00 57.96           O  
ATOM    557  OD2 ASP A  83      11.793  -7.911   1.012  1.00 55.06           O  
ATOM    558  N   GLY A  84       7.869  -5.449  -0.951  1.00 54.05           N  
ATOM    559  CA  GLY A  84       7.513  -5.417  -2.361  1.00 55.03           C  
ATOM    560  C   GLY A  84       6.600  -6.580  -2.726  1.00 53.37           C  
ATOM    561  O   GLY A  84       5.480  -6.724  -2.195  1.00 53.03           O  
ATOM    562  N   ALA A  85       7.091  -7.437  -3.622  1.00 52.00           N  
ATOM    563  CA  ALA A  85       6.374  -8.635  -4.016  1.00 48.98           C  
ATOM    564  C   ALA A  85       6.573  -9.800  -3.033  1.00 45.71           C  
ATOM    565  O   ALA A  85       5.872 -10.806  -3.136  1.00 44.58           O  
ATOM    566  CB  ALA A  85       6.788  -9.051  -5.424  1.00 49.76           C  
ATOM    567  N   ALA A  86       7.509  -9.686  -2.090  1.00 43.78           N  
ATOM    568  CA  ALA A  86       7.709 -10.762  -1.116  1.00 40.53           C  
ATOM    569  C   ALA A  86       6.837 -10.596   0.129  1.00 39.16           C  
ATOM    570  O   ALA A  86       6.660  -9.488   0.621  1.00 40.23           O  
ATOM    571  CB  ALA A  86       9.153 -10.890  -0.734  1.00 40.15           C  
ATOM    572  N   VAL A  87       6.280 -11.708   0.611  1.00 36.39           N  
ATOM    573  CA  VAL A  87       5.450 -11.735   1.812  1.00 35.06           C  
ATOM    574  C   VAL A  87       5.996 -12.832   2.713  1.00 33.46           C  
ATOM    575  O   VAL A  87       6.198 -13.975   2.267  1.00 32.39           O  
ATOM    576  CB  VAL A  87       3.955 -12.022   1.476  1.00 35.05           C  
ATOM    577  CG1 VAL A  87       3.104 -12.176   2.753  1.00 34.04           C  
ATOM    578  CG2 VAL A  87       3.379 -10.953   0.539  1.00 35.41           C  
ATOM    579  N   LEU A  88       6.265 -12.489   3.970  1.00 33.40           N  
ATOM    580  CA  LEU A  88       6.749 -13.476   4.925  1.00 32.08           C  
ATOM    581  C   LEU A  88       5.693 -13.660   5.992  1.00 31.69           C  
ATOM    582  O   LEU A  88       5.012 -12.703   6.348  1.00 32.34           O  
ATOM    583  CB  LEU A  88       8.085 -13.056   5.545  1.00 32.46           C  
ATOM    584  CG  LEU A  88       9.309 -12.816   4.642  1.00 34.04           C  
ATOM    585  CD1 LEU A  88       9.369 -11.385   4.100  1.00 35.70           C  
ATOM    586  CD2 LEU A  88      10.604 -13.122   5.401  1.00 33.87           C  
ATOM    587  N   THR A  89       5.570 -14.895   6.490  1.00 30.45           N  
ATOM    588  CA  THR A  89       4.585 -15.241   7.508  1.00 30.55           C  
ATOM    589  C   THR A  89       5.204 -16.017   8.668  1.00 29.87           C  
ATOM    590  O   THR A  89       6.066 -16.855   8.446  1.00 29.66           O  
ATOM    591  CB  THR A  89       3.447 -16.125   6.937  1.00 30.29           C  
ATOM    592  OG1 THR A  89       3.971 -17.303   6.333  1.00 29.54           O  
ATOM    593  CG2 THR A  89       2.727 -15.454   5.906  1.00 28.96           C  
ATOM    594  N   GLU A  90       4.752 -15.740   9.891  1.00 29.90           N  
ATOM    595  CA  GLU A  90       5.023 -16.589  11.044  1.00 29.20           C  
ATOM    596  C   GLU A  90       3.699 -17.252  11.426  1.00 29.33           C  
ATOM    597  O   GLU A  90       2.728 -16.543  11.781  1.00 30.83           O  
ATOM    598  CB  GLU A  90       5.556 -15.764  12.221  1.00 30.27           C  
ATOM    599  CG  GLU A  90       5.787 -16.572  13.490  1.00 29.84           C  
ATOM    600  CD  GLU A  90       6.044 -15.731  14.757  1.00 32.31           C  
ATOM    601  OE1 GLU A  90       5.503 -14.600  14.893  1.00 35.58           O  
ATOM    602  OE2 GLU A  90       6.773 -16.230  15.642  1.00 31.38           O  
ATOM    603  N   ARG A  91       3.664 -18.588  11.387  1.00 27.85           N  
ATOM    604  CA  ARG A  91       2.403 -19.319  11.545  1.00 28.25           C  
ATOM    605  C   ARG A  91       2.512 -20.503  12.470  1.00 28.45           C  
ATOM    606  O   ARG A  91       3.622 -20.931  12.824  1.00 28.42           O  
ATOM    607  CB  ARG A  91       1.878 -19.846  10.198  1.00 27.19           C  
ATOM    608  CG  ARG A  91       2.309 -19.065   8.978  1.00 27.20           C  
ATOM    609  CD  ARG A  91       1.519 -19.385   7.762  1.00 26.28           C  
ATOM    610  NE  ARG A  91       1.583 -20.784   7.343  1.00 24.69           N  
ATOM    611  CZ  ARG A  91       2.294 -21.220   6.304  1.00 25.22           C  
ATOM    612  NH1 ARG A  91       3.017 -20.367   5.603  1.00 24.94           N  
ATOM    613  NH2 ARG A  91       2.276 -22.502   5.958  1.00 22.80           N  
ATOM    614  N   THR A  92       1.338 -21.003  12.868  1.00 29.18           N  
ATOM    615  CA  THR A  92       1.165 -22.339  13.437  1.00 29.41           C  
ATOM    616  C   THR A  92       0.244 -23.067  12.457  1.00 28.95           C  
ATOM    617  O   THR A  92      -0.857 -22.585  12.162  1.00 29.31           O  
ATOM    618  CB  THR A  92       0.488 -22.316  14.836  1.00 31.00           C  
ATOM    619  OG1 THR A  92       1.260 -21.508  15.743  1.00 32.75           O  
ATOM    620  CG2 THR A  92       0.351 -23.726  15.394  1.00 29.96           C  
ATOM    621  N   ASP A  93       0.714 -24.202  11.947  1.00 27.91           N  
ATOM    622  CA  ASP A  93      -0.061 -25.058  11.055  1.00 28.07           C  
ATOM    623  C   ASP A  93      -0.465 -26.341  11.760  1.00 28.10           C  
ATOM    624  O   ASP A  93       0.111 -26.688  12.752  1.00 28.36           O  
ATOM    625  CB  ASP A  93       0.772 -25.411   9.807  1.00 27.05           C  
ATOM    626  CG  ASP A  93       0.849 -24.265   8.787  1.00 29.69           C  
ATOM    627  OD1 ASP A  93       1.180 -24.579   7.614  1.00 30.20           O  
ATOM    628  OD2 ASP A  93       0.594 -23.064   9.141  1.00 31.81           O  
ATOM    629  N   ALA A  94      -1.453 -27.055  11.230  1.00 29.19           N  
ATOM    630  CA  ALA A  94      -1.761 -28.394  11.704  1.00 30.33           C  
ATOM    631  C   ALA A  94      -2.142 -29.272  10.528  1.00 31.04           C  
ATOM    632  O   ALA A  94      -2.870 -28.835   9.632  1.00 30.90           O  
ATOM    633  CB  ALA A  94      -2.878 -28.368  12.732  1.00 31.09           C  
ATOM    634  N   LEU A  95      -1.633 -30.505  10.513  1.00 31.92           N  
ATOM    635  CA  LEU A  95      -2.172 -31.526   9.611  1.00 33.28           C  
ATOM    636  C   LEU A  95      -3.050 -32.445  10.415  1.00 34.96           C  
ATOM    637  O   LEU A  95      -2.691 -32.819  11.549  1.00 36.39           O  
ATOM    638  CB  LEU A  95      -1.068 -32.341   8.918  1.00 32.88           C  
ATOM    639  CG  LEU A  95      -0.090 -31.527   8.051  1.00 33.45           C  
ATOM    640  CD1 LEU A  95       0.922 -32.437   7.388  1.00 33.55           C  
ATOM    641  CD2 LEU A  95      -0.797 -30.632   6.998  1.00 32.76           C  
ATOM    642  N   ILE A  96      -4.199 -32.778   9.835  1.00 35.29           N  
ATOM    643  CA  ILE A  96      -5.212 -33.583  10.502  1.00 37.10           C  
ATOM    644  C   ILE A  96      -5.563 -34.776   9.625  1.00 38.08           C  
ATOM    645  O   ILE A  96      -6.044 -34.631   8.486  1.00 37.92           O  
ATOM    646  CB  ILE A  96      -6.469 -32.748  10.870  1.00 38.12           C  
ATOM    647  CG1 ILE A  96      -5.996 -31.583  11.751  1.00 37.96           C  
ATOM    648  CG2 ILE A  96      -7.525 -33.630  11.612  1.00 37.45           C  
ATOM    649  CD1 ILE A  96      -6.616 -30.270  11.540  1.00 38.80           C  
ATOM    650  N   ILE A  97      -5.294 -35.955  10.169  1.00 39.31           N  
ATOM    651  CA  ILE A  97      -5.577 -37.229   9.505  1.00 40.70           C  
ATOM    652  C   ILE A  97      -6.436 -38.067  10.439  1.00 42.53           C  
ATOM    653  O   ILE A  97      -5.922 -38.635  11.416  1.00 43.51           O  
ATOM    654  CB  ILE A  97      -4.254 -37.967   9.158  1.00 40.61           C  
ATOM    655  CG1 ILE A  97      -3.308 -37.016   8.424  1.00 39.52           C  
ATOM    656  CG2 ILE A  97      -4.516 -39.138   8.255  1.00 41.59           C  
ATOM    657  CD1 ILE A  97      -1.835 -37.187   8.775  1.00 40.26           C  
ATOM    658  N   GLY A  98      -7.738 -38.107  10.153  1.00 42.96           N  
ATOM    659  CA  GLY A  98      -8.729 -38.632  11.091  1.00 44.68           C  
ATOM    660  C   GLY A  98      -8.625 -37.992  12.466  1.00 45.24           C  
ATOM    661  O   GLY A  98      -8.660 -36.767  12.598  1.00 44.15           O  
ATOM    662  N   PRO A  99      -8.470 -38.825  13.504  1.00 46.89           N  
ATOM    663  CA  PRO A  99      -8.405 -38.291  14.871  1.00 47.47           C  
ATOM    664  C   PRO A  99      -7.030 -37.741  15.215  1.00 45.85           C  
ATOM    665  O   PRO A  99      -6.886 -37.060  16.233  1.00 46.39           O  
ATOM    666  CB  PRO A  99      -8.726 -39.521  15.742  1.00 49.96           C  
ATOM    667  CG  PRO A  99      -8.266 -40.698  14.914  1.00 49.87           C  
ATOM    668  CD  PRO A  99      -8.351 -40.298  13.460  1.00 48.18           C  
ATOM    669  N   LEU A 100      -6.033 -38.047  14.381  1.00 44.02           N  
ATOM    670  CA  LEU A 100      -4.659 -37.595  14.606  1.00 42.21           C  
ATOM    671  C   LEU A 100      -4.447 -36.164  14.144  1.00 40.29           C  
ATOM    672  O   LEU A 100      -4.583 -35.866  12.964  1.00 39.18           O  
ATOM    673  CB  LEU A 100      -3.645 -38.520  13.916  1.00 41.59           C  
ATOM    674  CG  LEU A 100      -2.168 -38.070  14.019  1.00 40.88           C  
ATOM    675  CD1 LEU A 100      -1.647 -38.166  15.455  1.00 41.51           C  
ATOM    676  CD2 LEU A 100      -1.249 -38.827  13.067  1.00 39.84           C  
ATOM    677  N   ARG A 101      -4.092 -35.292  15.082  1.00 40.22           N  
ATOM    678  CA  ARG A 101      -3.790 -33.905  14.773  1.00 38.66           C  
ATOM    679  C   ARG A 101      -2.325 -33.625  15.074  1.00 37.35           C  
ATOM    680  O   ARG A 101      -1.855 -33.870  16.185  1.00 38.43           O  
ATOM    681  CB  ARG A 101      -4.703 -32.988  15.577  1.00 39.75           C  
ATOM    682  CG  ARG A 101      -4.305 -31.514  15.564  1.00 39.97           C  
ATOM    683  CD  ARG A 101      -5.095 -30.748  16.630  1.00 43.89           C  
ATOM    684  NE  ARG A 101      -4.893 -29.315  16.491  1.00 45.64           N  
ATOM    685  CZ  ARG A 101      -5.583 -28.557  15.646  1.00 46.26           C  
ATOM    686  NH1 ARG A 101      -6.518 -29.105  14.874  1.00 46.55           N  
ATOM    687  NH2 ARG A 101      -5.340 -27.257  15.570  1.00 44.85           N  
ATOM    688  N   VAL A 102      -1.601 -33.132  14.074  1.00 35.35           N  
ATOM    689  CA  VAL A 102      -0.176 -32.793  14.245  1.00 34.09           C  
ATOM    690  C   VAL A 102       0.007 -31.290  14.049  1.00 33.11           C  
ATOM    691  O   VAL A 102      -0.187 -30.760  12.950  1.00 32.15           O  
ATOM    692  CB  VAL A 102       0.747 -33.583  13.263  1.00 33.82           C  
ATOM    693  CG1 VAL A 102       2.248 -33.179  13.418  1.00 30.79           C  
ATOM    694  CG2 VAL A 102       0.550 -35.108  13.436  1.00 35.04           C  
ATOM    695  N   GLN A 103       0.382 -30.612  15.124  1.00 33.24           N  
ATOM    696  CA  GLN A 103       0.571 -29.170  15.089  1.00 32.70           C  
ATOM    697  C   GLN A 103       2.055 -28.805  15.198  1.00 31.58           C  
ATOM    698  O   GLN A 103       2.798 -29.481  15.924  1.00 32.62           O  
ATOM    699  CB  GLN A 103      -0.193 -28.586  16.256  1.00 34.14           C  
ATOM    700  CG  GLN A 103      -0.557 -27.152  16.103  1.00 35.07           C  
ATOM    701  CD  GLN A 103      -1.698 -26.793  17.036  1.00 38.90           C  
ATOM    702  OE1 GLN A 103      -2.834 -27.147  16.810  1.00 37.42           O  
ATOM    703  NE2 GLN A 103      -1.395 -26.109  18.077  1.00 37.34           N  
ATOM    704  N   PHE A 104       2.468 -27.750  14.488  1.00 29.58           N  
ATOM    705  CA  PHE A 104       3.886 -27.372  14.350  1.00 28.44           C  
ATOM    706  C   PHE A 104       4.006 -25.939  13.788  1.00 27.74           C  
ATOM    707  O   PHE A 104       3.153 -25.493  13.023  1.00 27.38           O  
ATOM    708  CB  PHE A 104       4.639 -28.369  13.438  1.00 27.29           C  
ATOM    709  CG  PHE A 104       4.006 -28.529  12.064  1.00 26.80           C  
ATOM    710  CD1 PHE A 104       4.467 -27.806  10.973  1.00 26.32           C  
ATOM    711  CD2 PHE A 104       2.928 -29.400  11.876  1.00 26.93           C  
ATOM    712  CE1 PHE A 104       3.866 -27.944   9.699  1.00 27.56           C  
ATOM    713  CE2 PHE A 104       2.325 -29.560  10.625  1.00 25.91           C  
ATOM    714  CZ  PHE A 104       2.787 -28.829   9.523  1.00 26.43           C  
ATOM    715  N   TRP A 105       5.065 -25.224  14.165  1.00 27.11           N  
ATOM    716  CA  TRP A 105       5.292 -23.895  13.618  1.00 26.51           C  
ATOM    717  C   TRP A 105       5.733 -23.949  12.158  1.00 25.69           C  
ATOM    718  O   TRP A 105       6.411 -24.900  11.743  1.00 24.85           O  
ATOM    719  CB  TRP A 105       6.274 -23.077  14.463  1.00 26.16           C  
ATOM    720  CG  TRP A 105       7.668 -23.593  14.598  1.00 26.51           C  
ATOM    721  CD1 TRP A 105       8.201 -24.212  15.693  1.00 26.85           C  
ATOM    722  CD2 TRP A 105       8.752 -23.457  13.653  1.00 26.29           C  
ATOM    723  NE1 TRP A 105       9.537 -24.505  15.480  1.00 26.63           N  
ATOM    724  CE2 TRP A 105       9.904 -24.041  14.245  1.00 26.23           C  
ATOM    725  CE3 TRP A 105       8.869 -22.884  12.365  1.00 26.31           C  
ATOM    726  CZ2 TRP A 105      11.158 -24.076  13.595  1.00 25.47           C  
ATOM    727  CZ3 TRP A 105      10.122 -22.941  11.706  1.00 24.85           C  
ATOM    728  CH2 TRP A 105      11.244 -23.531  12.329  1.00 25.00           C  
ATOM    729  N   VAL A 106       5.321 -22.943  11.381  1.00 25.37           N  
ATOM    730  CA  VAL A 106       5.807 -22.784  10.022  1.00 25.00           C  
ATOM    731  C   VAL A 106       6.142 -21.333   9.769  1.00 25.96           C  
ATOM    732  O   VAL A 106       5.389 -20.441  10.183  1.00 26.99           O  
ATOM    733  CB  VAL A 106       4.774 -23.278   8.970  1.00 24.73           C  
ATOM    734  CG1 VAL A 106       5.289 -23.023   7.551  1.00 24.87           C  
ATOM    735  CG2 VAL A 106       4.517 -24.748   9.136  1.00 23.16           C  
ATOM    736  N   CYS A 107       7.290 -21.077   9.140  1.00 26.14           N  
ATOM    737  CA  CYS A 107       7.533 -19.743   8.567  1.00 26.97           C  
ATOM    738  C   CYS A 107       7.457 -19.896   7.056  1.00 27.37           C  
ATOM    739  O   CYS A 107       8.211 -20.688   6.456  1.00 27.40           O  
ATOM    740  CB  CYS A 107       8.874 -19.165   8.981  1.00 27.55           C  
ATOM    741  SG  CYS A 107       9.020 -18.784  10.724  1.00 28.72           S  
ATOM    742  N   GLY A 108       6.521 -19.182   6.445  1.00 27.37           N  
ATOM    743  CA  GLY A 108       6.321 -19.292   5.013  1.00 28.48           C  
ATOM    744  C   GLY A 108       6.750 -18.017   4.319  1.00 30.07           C  
ATOM    745  O   GLY A 108       6.386 -16.916   4.770  1.00 31.18           O  
ATOM    746  N   VAL A 109       7.530 -18.165   3.242  1.00 30.12           N  
ATOM    747  CA  VAL A 109       7.840 -17.038   2.377  1.00 31.77           C  
ATOM    748  C   VAL A 109       7.190 -17.171   0.996  1.00 31.96           C  
ATOM    749  O   VAL A 109       7.181 -18.240   0.406  1.00 30.90           O  
ATOM    750  CB  VAL A 109       9.371 -16.619   2.363  1.00 32.88           C  
ATOM    751  CG1 VAL A 109      10.127 -17.219   3.509  1.00 31.62           C  
ATOM    752  CG2 VAL A 109      10.051 -16.886   1.030  1.00 35.23           C  
ATOM    753  N   PHE A 110       6.597 -16.077   0.529  1.00 33.09           N  
ATOM    754  CA  PHE A 110       5.824 -16.109  -0.695  1.00 34.04           C  
ATOM    755  C   PHE A 110       6.313 -15.026  -1.620  1.00 37.05           C  
ATOM    756  O   PHE A 110       6.872 -14.013  -1.186  1.00 38.15           O  
ATOM    757  CB  PHE A 110       4.325 -15.897  -0.417  1.00 32.93           C  
ATOM    758  CG  PHE A 110       3.706 -16.928   0.510  1.00 29.98           C  
ATOM    759  CD1 PHE A 110       3.845 -16.818   1.871  1.00 27.07           C  
ATOM    760  CD2 PHE A 110       2.973 -17.976   0.013  1.00 28.14           C  
ATOM    761  CE1 PHE A 110       3.279 -17.720   2.716  1.00 26.23           C  
ATOM    762  CE2 PHE A 110       2.395 -18.901   0.870  1.00 26.72           C  
ATOM    763  CZ  PHE A 110       2.537 -18.762   2.223  1.00 25.29           C  
ATOM    764  N   GLU A 111       6.112 -15.244  -2.909  1.00 39.22           N  
ATOM    765  CA  GLU A 111       6.233 -14.162  -3.855  1.00 42.97           C  
ATOM    766  C   GLU A 111       4.944 -14.064  -4.628  1.00 43.61           C  
ATOM    767  O   GLU A 111       4.405 -15.079  -5.088  1.00 42.79           O  
ATOM    768  CB  GLU A 111       7.441 -14.347  -4.754  1.00 44.42           C  
ATOM    769  CG  GLU A 111       8.476 -13.306  -4.464  1.00 50.26           C  
ATOM    770  CD  GLU A 111       9.896 -13.786  -4.681  1.00 56.47           C  
ATOM    771  OE1 GLU A 111      10.169 -14.472  -5.702  1.00 59.52           O  
ATOM    772  OE2 GLU A 111      10.750 -13.438  -3.833  1.00 57.90           O  
ATOM    773  N   VAL A 112       4.412 -12.848  -4.720  1.00 45.75           N  
ATOM    774  CA  VAL A 112       3.181 -12.649  -5.469  1.00 47.08           C  
ATOM    775  C   VAL A 112       3.338 -11.652  -6.599  1.00 50.55           C  
ATOM    776  O   VAL A 112       3.956 -10.590  -6.456  1.00 52.27           O  
ATOM    777  CB  VAL A 112       1.898 -12.455  -4.576  1.00 46.41           C  
ATOM    778  CG1 VAL A 112       2.219 -12.438  -3.081  1.00 44.04           C  
ATOM    779  CG2 VAL A 112       1.077 -11.258  -5.009  1.00 48.24           C  
ATOM    780  N   ASP A 113       2.797 -12.046  -7.737  1.00 52.21           N  
ATOM    781  CA  ASP A 113       2.895 -11.284  -8.949  1.00 56.04           C  
ATOM    782  C   ASP A 113       1.493 -11.209  -9.535  1.00 57.03           C  
ATOM    783  O   ASP A 113       0.905 -12.250  -9.898  1.00 56.10           O  
ATOM    784  CB  ASP A 113       3.861 -12.008  -9.890  1.00 56.77           C  
ATOM    785  CG  ASP A 113       3.871 -11.430 -11.275  1.00 62.26           C  
ATOM    786  OD1 ASP A 113       4.064 -10.199 -11.418  1.00 68.08           O  
ATOM    787  OD2 ASP A 113       3.699 -12.219 -12.230  1.00 64.97           O  
ATOM    788  N   ASP A 114       0.936  -9.997  -9.583  1.00 59.24           N  
ATOM    789  CA  ASP A 114      -0.370  -9.785 -10.226  1.00 60.62           C  
ATOM    790  C   ASP A 114      -1.502 -10.539  -9.531  1.00 58.18           C  
ATOM    791  O   ASP A 114      -2.347 -11.163 -10.195  1.00 58.16           O  
ATOM    792  CB  ASP A 114      -0.315 -10.276 -11.668  1.00 61.94           C  
ATOM    793  CG  ASP A 114      -0.066  -9.182 -12.667  1.00 67.07           C  
ATOM    794  OD1 ASP A 114      -0.237  -9.504 -13.838  1.00 70.03           O  
ATOM    795  OD2 ASP A 114       0.261  -8.023 -12.353  1.00 68.91           O  
ATOM    796  N   GLY A 115      -1.499 -10.508  -8.204  1.00 56.16           N  
ATOM    797  CA  GLY A 115      -2.470 -11.260  -7.413  1.00 53.78           C  
ATOM    798  C   GLY A 115      -2.233 -12.766  -7.364  1.00 50.98           C  
ATOM    799  O   GLY A 115      -2.924 -13.469  -6.631  1.00 49.84           O  
ATOM    800  N   ARG A 116      -1.275 -13.273  -8.140  1.00 49.74           N  
ATOM    801  CA  ARG A 116      -0.996 -14.709  -8.153  1.00 46.99           C  
ATOM    802  C   ARG A 116       0.301 -15.031  -7.386  1.00 44.61           C  
ATOM    803  O   ARG A 116       1.289 -14.296  -7.490  1.00 45.43           O  
ATOM    804  CB  ARG A 116      -0.919 -15.243  -9.593  1.00 48.33           C  
ATOM    805  CG  ARG A 116      -2.060 -14.814 -10.562  1.00 51.34           C  
ATOM    806  CD  ARG A 116      -3.219 -15.780 -10.659  1.00 52.50           C  
ATOM    807  NE  ARG A 116      -2.919 -17.044 -11.342  1.00 55.77           N  
ATOM    808  CZ  ARG A 116      -3.827 -18.000 -11.580  1.00 56.78           C  
ATOM    809  NH1 ARG A 116      -5.052 -17.837 -11.203  1.00 56.92           N  
ATOM    810  NH2 ARG A 116      -3.552 -19.134 -12.185  1.00 55.83           N  
ATOM    811  N   ILE A 117       0.282 -16.118  -6.614  1.00 40.96           N  
ATOM    812  CA  ILE A 117       1.470 -16.626  -5.906  1.00 38.27           C  
ATOM    813  C   ILE A 117       2.405 -17.419  -6.844  1.00 37.76           C  
ATOM    814  O   ILE A 117       2.002 -18.408  -7.446  1.00 37.33           O  
ATOM    815  CB  ILE A 117       1.076 -17.478  -4.652  1.00 36.24           C  
ATOM    816  CG1 ILE A 117       0.343 -16.606  -3.628  1.00 35.61           C  
ATOM    817  CG2 ILE A 117       2.296 -18.114  -4.008  1.00 34.35           C  
ATOM    818  CD1 ILE A 117      -0.473 -17.379  -2.647  1.00 34.50           C  
ATOM    819  N   THR A 118       3.644 -16.957  -6.955  1.00 37.52           N  
ATOM    820  CA  THR A 118       4.628 -17.542  -7.846  1.00 37.79           C  
ATOM    821  C   THR A 118       5.713 -18.299  -7.080  1.00 36.57           C  
ATOM    822  O   THR A 118       6.422 -19.112  -7.673  1.00 37.09           O  
ATOM    823  CB  THR A 118       5.321 -16.462  -8.684  1.00 40.21           C  
ATOM    824  OG1 THR A 118       5.897 -15.498  -7.795  1.00 41.42           O  
ATOM    825  CG2 THR A 118       4.331 -15.756  -9.650  1.00 40.81           C  
ATOM    826  N   LEU A 119       5.856 -18.006  -5.778  1.00 34.37           N  
ATOM    827  CA  LEU A 119       6.713 -18.768  -4.873  1.00 32.70           C  
ATOM    828  C   LEU A 119       5.963 -19.066  -3.561  1.00 31.03           C  
ATOM    829  O   LEU A 119       5.297 -18.197  -2.995  1.00 31.28           O  
ATOM    830  CB  LEU A 119       8.024 -18.016  -4.553  1.00 33.05           C  
ATOM    831  CG  LEU A 119       8.953 -18.672  -3.507  1.00 31.99           C  
ATOM    832  CD1 LEU A 119       9.580 -19.984  -4.033  1.00 29.00           C  
ATOM    833  CD2 LEU A 119      10.059 -17.724  -3.053  1.00 33.35           C  
ATOM    834  N   TRP A 120       6.085 -20.287  -3.067  1.00 28.94           N  
ATOM    835  CA  TRP A 120       5.499 -20.629  -1.803  1.00 26.94           C  
ATOM    836  C   TRP A 120       6.496 -21.523  -1.118  1.00 26.14           C  
ATOM    837  O   TRP A 120       6.663 -22.685  -1.494  1.00 25.71           O  
ATOM    838  CB  TRP A 120       4.119 -21.297  -1.985  1.00 26.70           C  
ATOM    839  CG  TRP A 120       3.523 -21.949  -0.742  1.00 25.63           C  
ATOM    840  CD1 TRP A 120       3.829 -21.676   0.576  1.00 25.09           C  
ATOM    841  CD2 TRP A 120       2.501 -22.958  -0.707  1.00 24.83           C  
ATOM    842  NE1 TRP A 120       3.075 -22.462   1.406  1.00 24.74           N  
ATOM    843  CE2 TRP A 120       2.261 -23.264   0.654  1.00 23.99           C  
ATOM    844  CE3 TRP A 120       1.784 -23.649  -1.696  1.00 25.54           C  
ATOM    845  CZ2 TRP A 120       1.334 -24.215   1.050  1.00 24.54           C  
ATOM    846  CZ3 TRP A 120       0.867 -24.610  -1.306  1.00 25.01           C  
ATOM    847  CH2 TRP A 120       0.645 -24.884   0.059  1.00 24.53           C  
ATOM    848  N   ARG A 121       7.156 -20.969  -0.103  1.00 25.30           N  
ATOM    849  CA  ARG A 121       8.241 -21.666   0.544  1.00 25.36           C  
ATOM    850  C   ARG A 121       8.005 -21.804   2.034  1.00 24.63           C  
ATOM    851  O   ARG A 121       8.119 -20.827   2.771  1.00 24.73           O  
ATOM    852  CB  ARG A 121       9.564 -20.968   0.258  1.00 26.76           C  
ATOM    853  CG  ARG A 121      10.775 -21.685   0.825  1.00 27.39           C  
ATOM    854  CD  ARG A 121      12.053 -20.920   0.575  1.00 27.90           C  
ATOM    855  NE  ARG A 121      12.418 -20.897  -0.835  1.00 31.36           N  
ATOM    856  CZ  ARG A 121      13.024 -19.866  -1.437  1.00 35.02           C  
ATOM    857  NH1 ARG A 121      13.307 -18.735  -0.778  1.00 34.31           N  
ATOM    858  NH2 ARG A 121      13.325 -19.963  -2.720  1.00 35.22           N  
ATOM    859  N   ASP A 122       7.668 -23.021   2.475  1.00 23.94           N  
ATOM    860  CA  ASP A 122       7.435 -23.267   3.891  1.00 23.68           C  
ATOM    861  C   ASP A 122       8.666 -23.877   4.593  1.00 24.61           C  
ATOM    862  O   ASP A 122       9.252 -24.854   4.122  1.00 24.61           O  
ATOM    863  CB  ASP A 122       6.205 -24.148   4.100  1.00 23.01           C  
ATOM    864  CG  ASP A 122       4.880 -23.369   4.008  1.00 24.45           C  
ATOM    865  OD1 ASP A 122       4.835 -22.104   4.004  1.00 25.31           O  
ATOM    866  OD2 ASP A 122       3.843 -24.055   3.969  1.00 26.42           O  
ATOM    867  N   TYR A 123       9.037 -23.256   5.713  1.00 25.13           N  
ATOM    868  CA  TYR A 123      10.097 -23.681   6.585  1.00 25.95           C  
ATOM    869  C   TYR A 123       9.484 -24.194   7.868  1.00 26.44           C  
ATOM    870  O   TYR A 123       8.586 -23.561   8.425  1.00 27.21           O  
ATOM    871  CB  TYR A 123      10.932 -22.475   6.995  1.00 26.27           C  
ATOM    872  CG  TYR A 123      11.777 -21.844   5.935  1.00 25.95           C  
ATOM    873  CD1 TYR A 123      11.261 -20.867   5.093  1.00 25.01           C  
ATOM    874  CD2 TYR A 123      13.115 -22.193   5.801  1.00 25.19           C  
ATOM    875  CE1 TYR A 123      12.069 -20.248   4.141  1.00 25.91           C  
ATOM    876  CE2 TYR A 123      13.919 -21.599   4.846  1.00 26.21           C  
ATOM    877  CZ  TYR A 123      13.392 -20.634   4.021  1.00 27.89           C  
ATOM    878  OH  TYR A 123      14.214 -20.037   3.100  1.00 30.88           O  
ATOM    879  N   PHE A 124      10.010 -25.313   8.356  1.00 27.19           N  
ATOM    880  CA  PHE A 124       9.631 -25.884   9.624  1.00 27.41           C  
ATOM    881  C   PHE A 124      10.775 -26.756  10.122  1.00 27.83           C  
ATOM    882  O   PHE A 124      11.750 -26.984   9.404  1.00 27.19           O  
ATOM    883  CB  PHE A 124       8.359 -26.719   9.458  1.00 27.79           C  
ATOM    884  CG  PHE A 124       8.418 -27.656   8.302  1.00 29.03           C  
ATOM    885  CD1 PHE A 124       7.863 -27.295   7.072  1.00 31.29           C  
ATOM    886  CD2 PHE A 124       9.041 -28.899   8.424  1.00 32.06           C  
ATOM    887  CE1 PHE A 124       7.921 -28.166   5.977  1.00 33.34           C  
ATOM    888  CE2 PHE A 124       9.102 -29.777   7.353  1.00 34.26           C  
ATOM    889  CZ  PHE A 124       8.545 -29.410   6.122  1.00 33.06           C  
ATOM    890  N   ASP A 125      10.610 -27.281  11.337  1.00 28.15           N  
ATOM    891  CA  ASP A 125      11.667 -28.001  12.049  1.00 29.18           C  
ATOM    892  C   ASP A 125      11.217 -29.444  12.292  1.00 29.50           C  
ATOM    893  O   ASP A 125      10.137 -29.650  12.838  1.00 28.88           O  
ATOM    894  CB  ASP A 125      11.932 -27.264  13.372  1.00 28.92           C  
ATOM    895  CG  ASP A 125      12.821 -28.030  14.310  1.00 30.70           C  
ATOM    896  OD1 ASP A 125      13.758 -28.697  13.828  1.00 30.13           O  
ATOM    897  OD2 ASP A 125      12.590 -27.916  15.540  1.00 31.93           O  
ATOM    898  N   VAL A 126      12.037 -30.424  11.905  1.00 30.20           N  
ATOM    899  CA  VAL A 126      11.687 -31.837  12.134  1.00 31.47           C  
ATOM    900  C   VAL A 126      11.532 -32.154  13.620  1.00 32.34           C  
ATOM    901  O   VAL A 126      10.659 -32.901  13.995  1.00 33.35           O  
ATOM    902  CB  VAL A 126      12.682 -32.869  11.473  1.00 32.69           C  
ATOM    903  CG1 VAL A 126      12.893 -32.546  10.006  1.00 31.90           C  
ATOM    904  CG2 VAL A 126      13.994 -32.877  12.183  1.00 34.25           C  
ATOM    905  N   TYR A 127      12.375 -31.594  14.469  1.00 33.06           N  
ATOM    906  CA  TYR A 127      12.243 -31.810  15.902  1.00 34.44           C  
ATOM    907  C   TYR A 127      10.889 -31.278  16.446  1.00 33.32           C  
ATOM    908  O   TYR A 127      10.162 -31.976  17.157  1.00 33.54           O  
ATOM    909  CB  TYR A 127      13.460 -31.196  16.602  1.00 36.31           C  
ATOM    910  CG  TYR A 127      13.376 -31.107  18.103  1.00 38.78           C  
ATOM    911  CD1 TYR A 127      13.305 -32.258  18.886  1.00 40.70           C  
ATOM    912  CD2 TYR A 127      13.385 -29.853  18.743  1.00 40.55           C  
ATOM    913  CE1 TYR A 127      13.239 -32.173  20.277  1.00 42.93           C  
ATOM    914  CE2 TYR A 127      13.323 -29.745  20.126  1.00 42.25           C  
ATOM    915  CZ  TYR A 127      13.242 -30.901  20.884  1.00 43.65           C  
ATOM    916  OH  TYR A 127      13.181 -30.775  22.254  1.00 46.18           O  
ATOM    917  N   ASP A 128      10.539 -30.059  16.073  1.00 31.73           N  
ATOM    918  CA  ASP A 128       9.251 -29.515  16.420  1.00 31.92           C  
ATOM    919  C   ASP A 128       8.078 -30.360  15.846  1.00 32.26           C  
ATOM    920  O   ASP A 128       7.097 -30.619  16.532  1.00 32.93           O  
ATOM    921  CB  ASP A 128       9.164 -28.082  15.929  1.00 30.85           C  
ATOM    922  CG  ASP A 128       7.848 -27.452  16.262  1.00 30.90           C  
ATOM    923  OD1 ASP A 128       7.623 -27.185  17.462  1.00 33.28           O  
ATOM    924  OD2 ASP A 128       7.026 -27.231  15.334  1.00 29.11           O  
HETATM  925  N   MSE A 129       8.196 -30.791  14.597  1.00 31.98           N  
HETATM  926  CA  MSE A 129       7.222 -31.679  14.004  1.00 33.30           C  
HETATM  927  C   MSE A 129       7.172 -33.042  14.666  1.00 34.31           C  
HETATM  928  O   MSE A 129       6.110 -33.621  14.796  1.00 34.93           O  
HETATM  929  CB  MSE A 129       7.531 -31.883  12.543  1.00 32.38           C  
HETATM  930  CG  MSE A 129       6.332 -32.382  11.743  1.00 33.74           C  
HETATM  931 SE   MSE A 129       6.754 -31.609  10.006  0.42 36.21          SE  
HETATM  932  CE  MSE A 129       6.878 -30.053  10.414  1.00 32.87           C  
ATOM    933  N   PHE A 130       8.321 -33.569  15.073  1.00 35.41           N  
ATOM    934  CA  PHE A 130       8.347 -34.843  15.761  1.00 37.06           C  
ATOM    935  C   PHE A 130       7.581 -34.707  17.083  1.00 37.86           C  
ATOM    936  O   PHE A 130       6.754 -35.554  17.411  1.00 38.41           O  
ATOM    937  CB  PHE A 130       9.800 -35.327  15.964  1.00 38.09           C  
ATOM    938  CG  PHE A 130       9.908 -36.613  16.729  1.00 40.70           C  
ATOM    939  CD1 PHE A 130       9.546 -37.823  16.136  1.00 42.94           C  
ATOM    940  CD2 PHE A 130      10.362 -36.616  18.049  1.00 42.84           C  
ATOM    941  CE1 PHE A 130       9.640 -39.026  16.848  1.00 46.08           C  
ATOM    942  CE2 PHE A 130      10.470 -37.813  18.780  1.00 44.96           C  
ATOM    943  CZ  PHE A 130      10.105 -39.018  18.180  1.00 46.04           C  
ATOM    944  N   LYS A 131       7.846 -33.628  17.821  1.00 37.79           N  
ATOM    945  CA  LYS A 131       7.161 -33.369  19.096  1.00 38.91           C  
ATOM    946  C   LYS A 131       5.662 -33.222  18.884  1.00 38.57           C  
ATOM    947  O   LYS A 131       4.867 -33.691  19.695  1.00 40.06           O  
ATOM    948  CB  LYS A 131       7.706 -32.105  19.780  1.00 38.49           C  
ATOM    949  CG  LYS A 131       9.072 -32.263  20.453  1.00 39.83           C  
ATOM    950  CD  LYS A 131       9.457 -30.999  21.242  1.00 40.34           C  
ATOM    951  CE  LYS A 131       9.766 -29.815  20.300  1.00 40.53           C  
ATOM    952  NZ  LYS A 131      10.030 -28.528  20.996  1.00 40.96           N  
ATOM    953  N   GLY A 132       5.278 -32.559  17.796  1.00 36.73           N  
ATOM    954  CA  GLY A 132       3.875 -32.381  17.462  1.00 36.32           C  
ATOM    955  C   GLY A 132       3.221 -33.728  17.205  1.00 38.04           C  
ATOM    956  O   GLY A 132       2.058 -33.952  17.606  1.00 38.54           O  
ATOM    957  N   LEU A 133       3.966 -34.622  16.541  1.00 38.15           N  
ATOM    958  CA  LEU A 133       3.511 -35.978  16.292  1.00 40.13           C  
ATOM    959  C   LEU A 133       3.270 -36.728  17.600  1.00 42.63           C  
ATOM    960  O   LEU A 133       2.200 -37.310  17.758  1.00 43.99           O  
ATOM    961  CB  LEU A 133       4.482 -36.740  15.382  1.00 39.99           C  
ATOM    962  CG  LEU A 133       4.130 -38.184  15.028  1.00 41.71           C  
ATOM    963  CD1 LEU A 133       2.966 -38.212  14.038  1.00 41.03           C  
ATOM    964  CD2 LEU A 133       5.337 -38.887  14.449  1.00 40.68           C  
ATOM    965  N   LEU A 134       4.238 -36.693  18.526  1.00 44.04           N  
ATOM    966  CA  LEU A 134       4.125 -37.383  19.829  1.00 47.34           C  
ATOM    967  C   LEU A 134       2.921 -36.907  20.602  1.00 48.42           C  
ATOM    968  O   LEU A 134       2.162 -37.705  21.129  1.00 50.03           O  
ATOM    969  CB  LEU A 134       5.358 -37.181  20.710  1.00 47.70           C  
ATOM    970  CG  LEU A 134       6.496 -38.153  20.460  1.00 50.76           C  
ATOM    971  CD1 LEU A 134       7.737 -37.494  20.863  1.00 51.46           C  
ATOM    972  CD2 LEU A 134       6.368 -39.439  21.228  1.00 54.56           C  
ATOM    973  N   ARG A 135       2.768 -35.595  20.665  1.00 48.02           N  
ATOM    974  CA  ARG A 135       1.628 -34.955  21.286  1.00 49.94           C  
ATOM    975  C   ARG A 135       0.312 -35.381  20.626  1.00 49.93           C  
ATOM    976  O   ARG A 135      -0.679 -35.585  21.308  1.00 51.98           O  
ATOM    977  CB  ARG A 135       1.800 -33.446  21.167  1.00 49.04           C  
ATOM    978  CG  ARG A 135       1.420 -32.667  22.388  1.00 53.45           C  
ATOM    979  CD  ARG A 135      -0.024 -32.469  22.307  1.00 59.38           C  
ATOM    980  NE  ARG A 135      -0.800 -31.692  23.272  1.00 63.69           N  
ATOM    981  CZ  ARG A 135      -0.401 -30.674  24.029  1.00 66.65           C  
ATOM    982  NH1 ARG A 135       0.853 -30.229  24.007  1.00 66.53           N  
ATOM    983  NH2 ARG A 135      -1.299 -30.106  24.822  1.00 68.17           N  
ATOM    984  N   GLY A 136       0.310 -35.512  19.304  1.00 48.37           N  
ATOM    985  CA  GLY A 136      -0.875 -35.955  18.575  1.00 48.48           C  
ATOM    986  C   GLY A 136      -1.221 -37.407  18.868  1.00 50.61           C  
ATOM    987  O   GLY A 136      -2.395 -37.747  19.029  1.00 51.49           O  
ATOM    988  N   LEU A 137      -0.191 -38.254  18.928  1.00 51.04           N  
ATOM    989  CA  LEU A 137      -0.365 -39.659  19.228  1.00 53.39           C  
ATOM    990  C   LEU A 137      -0.819 -39.858  20.666  1.00 55.94           C  
ATOM    991  O   LEU A 137      -1.693 -40.680  20.919  1.00 57.80           O  
ATOM    992  CB  LEU A 137       0.915 -40.443  18.948  1.00 53.75           C  
ATOM    993  CG  LEU A 137       1.357 -40.524  17.479  1.00 52.07           C  
ATOM    994  CD1 LEU A 137       2.762 -41.154  17.385  1.00 50.55           C  
ATOM    995  CD2 LEU A 137       0.323 -41.263  16.592  1.00 51.04           C  
ATOM    996  N   VAL A 138      -0.245 -39.095  21.594  1.00 56.17           N  
ATOM    997  CA  VAL A 138      -0.655 -39.141  22.998  1.00 59.05           C  
ATOM    998  C   VAL A 138      -2.125 -38.721  23.131  1.00 60.34           C  
ATOM    999  O   VAL A 138      -2.910 -39.380  23.824  1.00 62.92           O  
ATOM   1000  CB  VAL A 138       0.283 -38.283  23.922  1.00 59.01           C  
ATOM   1001  CG1 VAL A 138      -0.326 -38.076  25.315  1.00 60.38           C  
ATOM   1002  CG2 VAL A 138       1.671 -38.912  24.034  1.00 59.06           C  
ATOM   1003  N   ALA A 139      -2.489 -37.643  22.438  1.00 58.91           N  
ATOM   1004  CA  ALA A 139      -3.864 -37.102  22.426  1.00 60.28           C  
ATOM   1005  C   ALA A 139      -4.928 -38.082  21.922  1.00 62.05           C  
ATOM   1006  O   ALA A 139      -6.096 -37.961  22.268  1.00 63.79           O  
ATOM   1007  CB  ALA A 139      -3.920 -35.820  21.612  1.00 57.24           C  
ATOM   1008  N   LEU A 140      -4.517 -39.033  21.090  1.00 62.48           N  
ATOM   1009  CA  LEU A 140      -5.390 -40.105  20.595  1.00 64.86           C  
ATOM   1010  C   LEU A 140      -5.925 -40.981  21.714  1.00 69.39           C  
ATOM   1011  O   LEU A 140      -6.985 -41.590  21.599  1.00 71.26           O  
ATOM   1012  CB  LEU A 140      -4.592 -41.023  19.674  1.00 63.96           C  
ATOM   1013  CG  LEU A 140      -4.825 -41.179  18.182  1.00 61.85           C  
ATOM   1014  CD1 LEU A 140      -5.361 -39.916  17.544  1.00 59.89           C  
ATOM   1015  CD2 LEU A 140      -3.523 -41.620  17.561  1.00 59.87           C  
ATOM   1016  N   VAL A 141      -5.155 -41.049  22.791  1.00 71.77           N  
ATOM   1017  CA  VAL A 141      -5.363 -41.967  23.892  1.00 76.10           C  
ATOM   1018  C   VAL A 141      -5.841 -41.172  25.120  1.00 78.34           C  
ATOM   1019  O   VAL A 141      -6.681 -41.632  25.889  1.00 81.80           O  
ATOM   1020  CB  VAL A 141      -4.000 -42.669  24.164  1.00 76.66           C  
ATOM   1021  CG1 VAL A 141      -3.900 -43.142  25.463  1.00 79.60           C  
ATOM   1022  CG2 VAL A 141      -3.815 -43.827  23.332  1.00 76.93           C  
ATOM   1023  N   VAL A 142      -5.295 -39.971  25.294  1.00 77.28           N  
ATOM   1024  CA  VAL A 142      -5.748 -39.036  26.319  1.00 79.21           C  
ATOM   1025  C   VAL A 142      -6.244 -37.782  25.607  1.00 77.75           C  
ATOM   1026  O   VAL A 142      -5.463 -36.840  25.411  1.00 75.68           O  
ATOM   1027  CB  VAL A 142      -4.600 -38.620  27.256  1.00 79.31           C  
ATOM   1028  CG1 VAL A 142      -5.142 -37.815  28.423  1.00 81.18           C  
ATOM   1029  CG2 VAL A 142      -3.837 -39.831  27.746  1.00 80.84           C  
ATOM   1030  N   PRO A 143      -7.539 -37.760  25.203  1.00 78.95           N  
ATOM   1031  CA  PRO A 143      -8.055 -36.627  24.429  1.00 77.21           C  
ATOM   1032  C   PRO A 143      -7.991 -35.404  25.288  1.00 78.15           C  
ATOM   1033  O   PRO A 143      -8.916 -35.067  25.938  1.00 80.63           O  
ATOM   1034  CB  PRO A 143      -9.534 -36.962  24.215  1.00 78.89           C  
ATOM   1035  CG  PRO A 143      -9.699 -38.350  24.585  1.00 81.18           C  
ATOM   1036  CD  PRO A 143      -8.574 -38.772  25.463  1.00 81.76           C  
ATOM   1037  N   SER A 144      -6.905 -34.705  25.368  1.00 76.79           N  
ATOM   1038  CA  SER A 144      -7.026 -33.547  26.232  1.00 78.14           C  
ATOM   1039  C   SER A 144      -6.028 -32.695  25.710  1.00 75.61           C  
ATOM   1040  O   SER A 144      -4.965 -33.193  25.524  1.00 74.56           O  
ATOM   1041  CB  SER A 144      -6.564 -33.822  27.622  1.00 80.59           C  
ATOM   1042  OG  SER A 144      -6.621 -32.595  28.356  1.00 81.44           O  
TER    1043      SER A 144                                                      
END
MOLECULE T0475.pdb
ATOM     20  N   ASN     2       1.831  -2.392  -0.522  1.00  0.00
ATOM     21  HN  ASN     2       1.726  -2.331   0.453  1.00  0.00
ATOM     22  CA  ASN     2       2.075  -3.725  -1.109  1.00  0.00
ATOM     23  HA  ASN     2       2.284  -3.607  -2.174  1.00  0.00
ATOM     24  CB  ASN     2       3.299  -4.390  -0.422  1.00  0.00
ATOM     25  HB1 ASN     2       3.466  -5.372  -0.859  1.00  0.00
ATOM     26  HB2 ASN     2       3.089  -4.514   0.636  1.00  0.00
ATOM     27  CG  ASN     2       4.590  -3.576  -0.565  1.00  0.00
ATOM     28  OD1 ASN     2       5.324  -3.715  -1.546  1.00  0.00
ATOM     29  ND2 ASN     2       4.857  -2.700   0.401  1.00  0.00
ATOM     30 HD21 ASN     2       4.224  -2.628   1.148  1.00  0.00
ATOM     31 HD22 ASN     2       5.675  -2.167   0.331  1.00  0.00
ATOM     32  C   ASN     2       0.785  -4.553  -0.964  1.00  0.00
ATOM     33  O   ASN     2       0.810  -5.738  -0.618  1.00  0.00
ATOM     34  N   SER     3      -0.341  -3.891  -1.292  1.00  0.00
ATOM     35  HN  SER     3      -0.247  -3.002  -1.689  1.00  0.00
ATOM     36  CA  SER     3      -1.702  -4.409  -1.095  1.00  0.00
ATOM     37  HA  SER     3      -1.797  -4.700  -0.049  1.00  0.00
ATOM     38  CB  SER     3      -2.716  -3.279  -1.383  1.00  0.00
ATOM     39  HB1 SER     3      -2.599  -2.492  -0.645  1.00  0.00
ATOM     40  HB2 SER     3      -3.729  -3.660  -1.328  1.00  0.00
ATOM     41  OG  SER     3      -2.512  -2.719  -2.675  1.00  0.00
ATOM     42  HG  SER     3      -3.361  -2.595  -3.107  1.00  0.00
ATOM     43  C   SER     3      -1.979  -5.633  -1.981  1.00  0.00
ATOM     44  O   SER     3      -2.523  -6.626  -1.511  1.00  0.00
ATOM     45  N   GLU     4      -1.554  -5.549  -3.257  1.00  0.00
ATOM     46  HN  GLU     4      -1.122  -4.715  -3.539  1.00  0.00
ATOM     47  CA  GLU     4      -1.720  -6.638  -4.252  1.00  0.00
ATOM     48  HA  GLU     4      -2.760  -6.955  -4.203  1.00  0.00
ATOM     49  CB  GLU     4      -1.434  -6.132  -5.697  1.00  0.00
ATOM     50  HB1 GLU     4      -2.105  -5.307  -5.907  1.00  0.00
ATOM     51  HB2 GLU     4      -1.659  -6.934  -6.393  1.00  0.00
ATOM     52  CG  GLU     4       0.018  -5.661  -5.984  1.00  0.00
ATOM     53  HG1 GLU     4       0.166  -5.630  -7.063  1.00  0.00
ATOM     54  HG2 GLU     4       0.703  -6.396  -5.571  1.00  0.00
ATOM     55  CD  GLU     4       0.366  -4.277  -5.399  1.00  0.00
ATOM     56  OE1 GLU     4       0.009  -3.255  -6.022  1.00  0.00
ATOM     57  OE2 GLU     4       0.991  -4.208  -4.319  1.00  0.00
ATOM     58  C   GLU     4      -0.837  -7.869  -3.943  1.00  0.00
ATOM     59  O   GLU     4      -0.931  -8.886  -4.637  1.00  0.00
ATOM     60  N   ILE     5       0.041  -7.744  -2.937  1.00  0.00
ATOM     61  HN  ILE     5       0.146  -6.866  -2.519  1.00  0.00
ATOM     62  CA  ILE     5       0.867  -8.854  -2.432  1.00  0.00
ATOM     63  HA  ILE     5       0.966  -9.608  -3.214  1.00  0.00
ATOM     64  CB  ILE     5       2.303  -8.347  -2.025  1.00  0.00
ATOM     65  HB  ILE     5       2.196  -7.811  -1.085  1.00  0.00
ATOM     66  CG1 ILE     5       2.896  -7.353  -3.082  1.00  0.00
ATOM     67 HG11 ILE     5       3.865  -7.007  -2.738  1.00  0.00
ATOM     68 HG12 ILE     5       2.244  -6.502  -3.163  1.00  0.00
ATOM     69  CG2 ILE     5       3.271  -9.523  -1.775  1.00  0.00
ATOM     70 HG21 ILE     5       4.228  -9.142  -1.435  1.00  0.00
ATOM     71 HG22 ILE     5       3.417 -10.078  -2.691  1.00  0.00
ATOM     72 HG23 ILE     5       2.862 -10.182  -1.021  1.00  0.00
ATOM     73  CD1 ILE     5       3.082  -7.904  -4.488  1.00  0.00
ATOM     74 HD11 ILE     5       2.126  -8.218  -4.887  1.00  0.00
ATOM     75 HD12 ILE     5       3.755  -8.751  -4.459  1.00  0.00
ATOM     76 HD13 ILE     5       3.501  -7.137  -5.121  1.00  0.00
ATOM     77  C   ILE     5       0.167  -9.486  -1.207  1.00  0.00
ATOM     78  O   ILE     5       0.309 -10.683  -0.936  1.00  0.00
ATOM     79  N   GLU     6      -0.598  -8.649  -0.477  1.00  0.00
ATOM     80  HN  GLU     6      -0.624  -7.699  -0.730  1.00  0.00
ATOM     81  CA  GLU     6      -1.393  -9.075   0.691  1.00  0.00
ATOM     82  HA  GLU     6      -0.790  -9.767   1.280  1.00  0.00
ATOM     83  CB  GLU     6      -1.739  -7.844   1.574  1.00  0.00
ATOM     84  HB1 GLU     6      -2.373  -8.164   2.398  1.00  0.00
ATOM     85  HB2 GLU     6      -2.291  -7.131   0.971  1.00  0.00
ATOM     86  CG  GLU     6      -0.519  -7.120   2.167  1.00  0.00
ATOM     87  HG1 GLU     6       0.145  -6.834   1.353  1.00  0.00
ATOM     88  HG2 GLU     6       0.011  -7.810   2.816  1.00  0.00
ATOM     89  CD  GLU     6      -0.894  -5.858   2.968  1.00  0.00
ATOM     90  OE1 GLU     6      -1.011  -5.932   4.215  1.00  0.00
ATOM     91  OE2 GLU     6      -1.101  -4.793   2.350  1.00  0.00
ATOM     92  C   GLU     6      -2.691  -9.790   0.261  1.00  0.00
ATOM     93  O   GLU     6      -3.153 -10.698   0.961  1.00  0.00
ATOM     94  N   LEU     7      -3.271  -9.367  -0.887  1.00  0.00
ATOM     95  HN  LEU     7      -2.808  -8.685  -1.417  1.00  0.00
ATOM     96  CA  LEU     7      -4.562  -9.911  -1.391  1.00  0.00
ATOM     97  HA  LEU     7      -5.292  -9.732  -0.607  1.00  0.00
ATOM     98  CB  LEU     7      -5.054  -9.182  -2.681  1.00  0.00
ATOM     99  HB1 LEU     7      -5.975  -9.663  -3.009  1.00  0.00
ATOM    100  HB2 LEU     7      -4.310  -9.334  -3.456  1.00  0.00
ATOM    101  CG  LEU     7      -5.325  -7.651  -2.562  1.00  0.00
ATOM    102  HG  LEU     7      -4.402  -7.168  -2.287  1.00  0.00
ATOM    103  CD1 LEU     7      -5.756  -7.043  -3.913  1.00  0.00
ATOM    104 HD11 LEU     7      -6.661  -7.526  -4.269  1.00  0.00
ATOM    105 HD12 LEU     7      -4.968  -7.181  -4.640  1.00  0.00
ATOM    106 HD13 LEU     7      -5.941  -5.982  -3.792  1.00  0.00
ATOM    107  CD2 LEU     7      -6.353  -7.346  -1.453  1.00  0.00
ATOM    108 HD21 LEU     7      -5.982  -7.713  -0.505  1.00  0.00
ATOM    109 HD22 LEU     7      -7.295  -7.830  -1.678  1.00  0.00
ATOM    110 HD23 LEU     7      -6.509  -6.276  -1.383  1.00  0.00
ATOM    111  C   LEU     7      -4.504 -11.450  -1.632  1.00  0.00
ATOM    112  O   LEU     7      -5.411 -12.157  -1.175  1.00  0.00
ATOM    113  N   PRO     8      -3.462 -12.011  -2.364  1.00  0.00
ATOM    114  CA  PRO     8      -3.309 -13.478  -2.527  1.00  0.00
ATOM    115  HA  PRO     8      -4.145 -13.893  -3.088  1.00  0.00
ATOM    116  CB  PRO     8      -1.994 -13.649  -3.366  1.00  0.00
ATOM    117  HB1 PRO     8      -2.245 -13.908  -4.388  1.00  0.00
ATOM    118  HB2 PRO     8      -1.376 -14.442  -2.953  1.00  0.00
ATOM    119  CG  PRO     8      -1.308 -12.325  -3.298  1.00  0.00
ATOM    120  HG1 PRO     8      -0.750 -12.142  -4.212  1.00  0.00
ATOM    121  HG2 PRO     8      -0.632 -12.298  -2.447  1.00  0.00
ATOM    122  CD  PRO     8      -2.402 -11.297  -3.131  1.00  0.00
ATOM    123  HD1 PRO     8      -2.780 -10.972  -4.098  1.00  0.00
ATOM    124  HD2 PRO     8      -2.035 -10.447  -2.573  1.00  0.00
ATOM    125  C   PRO     8      -3.231 -14.208  -1.181  1.00  0.00
ATOM    126  O   PRO     8      -4.115 -14.994  -0.842  1.00  0.00
ATOM    127  N   VAL     9      -2.209 -13.860  -0.401  1.00  0.00
ATOM    128  HN  VAL     9      -1.703 -13.049  -0.636  1.00  0.00
ATOM    129  CA  VAL     9      -1.812 -14.612   0.800  1.00  0.00
ATOM    130  HA  VAL     9      -1.660 -15.641   0.491  1.00  0.00
ATOM    131  CB  VAL     9      -0.455 -14.070   1.348  1.00  0.00
ATOM    132  HB  VAL     9      -0.147 -14.712   2.173  1.00  0.00
ATOM    133  CG1 VAL     9       0.641 -14.156   0.254  1.00  0.00
ATOM    134 HG11 VAL     9       0.368 -13.532  -0.588  1.00  0.00
ATOM    135 HG12 VAL     9       0.746 -15.182  -0.082  1.00  0.00
ATOM    136 HG13 VAL     9       1.587 -13.820   0.657  1.00  0.00
ATOM    137  CG2 VAL     9      -0.593 -12.627   1.896  1.00  0.00
ATOM    138 HG21 VAL     9      -0.958 -11.972   1.115  1.00  0.00
ATOM    139 HG22 VAL     9       0.366 -12.271   2.239  1.00  0.00
ATOM    140 HG23 VAL     9      -1.292 -12.614   2.725  1.00  0.00
ATOM    141  C   VAL     9      -2.901 -14.601   1.905  1.00  0.00
ATOM    142  O   VAL     9      -3.020 -15.564   2.666  1.00  0.00
ATOM    143  N   GLN    10      -3.705 -13.515   1.950  1.00  0.00
ATOM    144  HN  GLN    10      -3.532 -12.787   1.318  1.00  0.00
ATOM    145  CA  GLN    10      -4.839 -13.376   2.888  1.00  0.00
ATOM    146  HA  GLN    10      -4.480 -13.600   3.893  1.00  0.00
ATOM    147  CB  GLN    10      -5.375 -11.914   2.859  1.00  0.00
ATOM    148  HB1 GLN    10      -5.608 -11.659   1.829  1.00  0.00
ATOM    149  HB2 GLN    10      -4.587 -11.252   3.197  1.00  0.00
ATOM    150  CG  GLN    10      -6.630 -11.627   3.718  1.00  0.00
ATOM    151  HG1 GLN    10      -7.444 -12.248   3.358  1.00  0.00
ATOM    152  HG2 GLN    10      -6.905 -10.587   3.587  1.00  0.00
ATOM    153  CD  GLN    10      -6.435 -11.892   5.211  1.00  0.00
ATOM    154  OE1 GLN    10      -6.001 -11.016   5.954  1.00  0.00
ATOM    155  NE2 GLN    10      -6.762 -13.097   5.655  1.00  0.00
ATOM    156 HE21 GLN    10      -7.111 -13.751   5.008  1.00  0.00
ATOM    157 HE22 GLN    10      -6.644 -13.289   6.609  1.00  0.00
ATOM    158  C   GLN    10      -5.951 -14.368   2.514  1.00  0.00
ATOM    159  O   GLN    10      -6.354 -15.200   3.335  1.00  0.00
ATOM    160  N   LYS    11      -6.395 -14.286   1.244  1.00  0.00
ATOM    161  HN  LYS    11      -5.949 -13.656   0.636  1.00  0.00
ATOM    162  CA  LYS    11      -7.508 -15.103   0.710  1.00  0.00
ATOM    163  HA  LYS    11      -8.378 -14.924   1.338  1.00  0.00
ATOM    164  CB  LYS    11      -7.846 -14.648  -0.732  1.00  0.00
ATOM    165  HB1 LYS    11      -8.562 -15.342  -1.167  1.00  0.00
ATOM    166  HB2 LYS    11      -6.938 -14.674  -1.329  1.00  0.00
ATOM    167  CG  LYS    11      -8.439 -13.225  -0.830  1.00  0.00
ATOM    168  HG1 LYS    11      -8.591 -12.983  -1.878  1.00  0.00
ATOM    169  HG2 LYS    11      -7.731 -12.521  -0.403  1.00  0.00
ATOM    170  CD  LYS    11      -9.782 -13.097  -0.085  1.00  0.00
ATOM    171  HD1 LYS    11      -9.626 -13.325   0.969  1.00  0.00
ATOM    172  HD2 LYS    11     -10.482 -13.816  -0.497  1.00  0.00
ATOM    173  CE  LYS    11     -10.403 -11.699  -0.200  1.00  0.00
ATOM    174  HE1 LYS    11     -10.562 -11.460  -1.242  1.00  0.00
ATOM    175  HE2 LYS    11      -9.730 -10.971   0.239  1.00  0.00
ATOM    176  NZ  LYS    11     -11.702 -11.633   0.510  1.00  0.00
ATOM    177  HZ1 LYS    11     -12.109 -10.686   0.416  1.00  0.00
ATOM    178  HZ2 LYS    11     -11.567 -11.843   1.519  1.00  0.00
ATOM    179  HZ3 LYS    11     -12.367 -12.326   0.112  1.00  0.00
ATOM    180  C   LYS    11      -7.180 -16.603   0.734  1.00  0.00
ATOM    181  O   LYS    11      -8.057 -17.429   0.977  1.00  0.00
ATOM    182  N   GLN    12      -5.904 -16.925   0.497  1.00  0.00
ATOM    183  HN  GLN    12      -5.262 -16.197   0.364  1.00  0.00
ATOM    184  CA  GLN    12      -5.412 -18.308   0.438  1.00  0.00
ATOM    185  HA  GLN    12      -6.116 -18.882  -0.161  1.00  0.00
ATOM    186  CB  GLN    12      -4.038 -18.347  -0.253  1.00  0.00
ATOM    187  HB1 GLN    12      -3.615 -19.342  -0.140  1.00  0.00
ATOM    188  HB2 GLN    12      -3.378 -17.634   0.241  1.00  0.00
ATOM    189  CG  GLN    12      -4.076 -18.013  -1.754  1.00  0.00
ATOM    190  HG1 GLN    12      -4.619 -17.084  -1.892  1.00  0.00
ATOM    191  HG2 GLN    12      -4.592 -18.806  -2.280  1.00  0.00
ATOM    192  CD  GLN    12      -2.692 -17.850  -2.370  1.00  0.00
ATOM    193  OE1 GLN    12      -2.513 -17.092  -3.318  1.00  0.00
ATOM    194  NE2 GLN    12      -1.704 -18.584  -1.862  1.00  0.00
ATOM    195 HE21 GLN    12      -1.901 -19.190  -1.120  1.00  0.00
ATOM    196 HE22 GLN    12      -0.821 -18.502  -2.263  1.00  0.00
ATOM    197  C   GLN    12      -5.310 -18.928   1.840  1.00  0.00
ATOM    198  O   GLN    12      -5.658 -20.085   2.024  1.00  0.00
ATOM    199  N   LEU    13      -4.802 -18.148   2.810  1.00  0.00
ATOM    200  HN  LEU    13      -4.515 -17.235   2.577  1.00  0.00
ATOM    201  CA  LEU    13      -4.660 -18.600   4.211  1.00  0.00
ATOM    202  HA  LEU    13      -4.023 -19.485   4.218  1.00  0.00
ATOM    203  CB  LEU    13      -4.000 -17.499   5.062  1.00  0.00
ATOM    204  HB1 LEU    13      -4.586 -16.593   4.943  1.00  0.00
ATOM    205  HB2 LEU    13      -3.007 -17.308   4.661  1.00  0.00
ATOM    206  CG  LEU    13      -3.869 -17.811   6.587  1.00  0.00
ATOM    207  HG  LEU    13      -4.781 -18.277   6.921  1.00  0.00
ATOM    208  CD1 LEU    13      -2.741 -18.824   6.881  1.00  0.00
ATOM    209 HD11 LEU    13      -2.683 -19.003   7.947  1.00  0.00
ATOM    210 HD12 LEU    13      -1.792 -18.435   6.532  1.00  0.00
ATOM    211 HD13 LEU    13      -2.952 -19.760   6.376  1.00  0.00
ATOM    212  CD2 LEU    13      -3.726 -16.522   7.391  1.00  0.00
ATOM    213 HD21 LEU    13      -3.726 -16.755   8.445  1.00  0.00
ATOM    214 HD22 LEU    13      -4.561 -15.868   7.172  1.00  0.00
ATOM    215 HD23 LEU    13      -2.801 -16.024   7.132  1.00  0.00
ATOM    216  C   LEU    13      -6.039 -18.958   4.803  1.00  0.00
ATOM    217  O   LEU    13      -6.199 -20.004   5.451  1.00  0.00
ATOM    218  N   GLU    14      -7.012 -18.054   4.579  1.00  0.00
ATOM    219  HN  GLU    14      -6.762 -17.194   4.166  1.00  0.00
ATOM    220  CA  GLU    14      -8.427 -18.274   4.938  1.00  0.00
ATOM    221  HA  GLU    14      -8.482 -18.402   6.018  1.00  0.00
ATOM    222  CB  GLU    14      -9.279 -17.045   4.529  1.00  0.00
ATOM    223  HB1 GLU    14     -10.327 -17.249   4.740  1.00  0.00
ATOM    224  HB2 GLU    14      -9.167 -16.886   3.459  1.00  0.00
ATOM    225  CG  GLU    14      -8.896 -15.744   5.249  1.00  0.00
ATOM    226  HG1 GLU    14      -7.833 -15.558   5.093  1.00  0.00
ATOM    227  HG2 GLU    14      -9.070 -15.875   6.311  1.00  0.00
ATOM    228  CD  GLU    14      -9.693 -14.526   4.750  1.00  0.00
ATOM    229  OE1 GLU    14     -10.749 -14.201   5.342  1.00  0.00
ATOM    230  OE2 GLU    14      -9.272 -13.890   3.756  1.00  0.00
ATOM    231  C   GLU    14      -8.950 -19.548   4.253  1.00  0.00
ATOM    232  O   GLU    14      -9.468 -20.433   4.916  1.00  0.00
ATOM    233  N   ALA    15      -8.711 -19.634   2.933  1.00  0.00
ATOM    234  HN  ALA    15      -8.204 -18.905   2.512  1.00  0.00
ATOM    235  CA  ALA    15      -9.156 -20.758   2.076  1.00  0.00
ATOM    236  HA  ALA    15     -10.235 -20.852   2.189  1.00  0.00
ATOM    237  CB  ALA    15      -8.862 -20.438   0.601  1.00  0.00
ATOM    238  HB1 ALA    15      -7.792 -20.355   0.451  1.00  0.00
ATOM    239  HB2 ALA    15      -9.327 -19.499   0.328  1.00  0.00
ATOM    240  HB3 ALA    15      -9.255 -21.223  -0.034  1.00  0.00
ATOM    241  C   ALA    15      -8.495 -22.102   2.478  1.00  0.00
ATOM    242  O   ALA    15      -9.058 -23.168   2.217  1.00  0.00
ATOM    243  N   TYR    16      -7.294 -22.028   3.098  1.00  0.00
ATOM    244  HN  TYR    16      -6.919 -21.135   3.279  1.00  0.00
ATOM    245  CA  TYR    16      -6.514 -23.215   3.518  1.00  0.00
ATOM    246  HA  TYR    16      -6.377 -23.844   2.639  1.00  0.00
ATOM    247  CB  TYR    16      -5.116 -22.780   4.043  1.00  0.00
ATOM    248  HB1 TYR    16      -5.253 -22.145   4.912  1.00  0.00
ATOM    249  HB2 TYR    16      -4.621 -22.198   3.274  1.00  0.00
ATOM    250  CG  TYR    16      -4.166 -23.936   4.432  1.00  0.00
ATOM    251  CD1 TYR    16      -3.688 -24.087   5.742  1.00  0.00
ATOM    252  HD1 TYR    16      -3.991 -23.371   6.499  1.00  0.00
ATOM    253  CD2 TYR    16      -3.752 -24.875   3.481  1.00  0.00
ATOM    254  HD2 TYR    16      -4.105 -24.781   2.460  1.00  0.00
ATOM    255  CE1 TYR    16      -2.836 -25.128   6.080  1.00  0.00
ATOM    256  HE1 TYR    16      -2.482 -25.225   7.100  1.00  0.00
ATOM    257  CE2 TYR    16      -2.904 -25.913   3.816  1.00  0.00
ATOM    258  HE2 TYR    16      -2.602 -26.625   3.059  1.00  0.00
ATOM    259  CZ  TYR    16      -2.448 -26.037   5.113  1.00  0.00
ATOM    260  OH  TYR    16      -1.602 -27.080   5.440  1.00  0.00
ATOM    261  HH  TYR    16      -1.856 -27.442   6.292  1.00  0.00
ATOM    262  C   TYR    16      -7.276 -24.016   4.589  1.00  0.00
ATOM    263  O   TYR    16      -7.355 -25.252   4.525  1.00  0.00
ATOM    264  N   ASN    17      -7.845 -23.289   5.560  1.00  0.00
ATOM    265  HN  ASN    17      -7.732 -22.312   5.539  1.00  0.00
ATOM    266  CA  ASN    17      -8.637 -23.887   6.651  1.00  0.00
ATOM    267  HA  ASN    17      -8.283 -24.908   6.797  1.00  0.00
ATOM    268  CB  ASN    17      -8.405 -23.104   7.979  1.00  0.00
ATOM    269  HB1 ASN    17      -7.345 -23.123   8.218  1.00  0.00
ATOM    270  HB2 ASN    17      -8.938 -23.600   8.780  1.00  0.00
ATOM    271  CG  ASN    17      -8.859 -21.642   7.940  1.00  0.00
ATOM    272  OD1 ASN    17      -9.998 -21.326   8.280  1.00  0.00
ATOM    273  ND2 ASN    17      -7.969 -20.740   7.540  1.00  0.00
ATOM    274 HD21 ASN    17      -7.069 -21.047   7.289  1.00  0.00
ATOM    275 HD22 ASN    17      -8.244 -19.800   7.514  1.00  0.00
ATOM    276  C   ASN    17     -10.139 -23.952   6.270  1.00  0.00
ATOM    277  O   ASN    17     -10.847 -24.858   6.711  1.00  0.00
ATOM    278  N   ALA    18     -10.592 -23.015   5.405  1.00  0.00
ATOM    279  HN  ALA    18      -9.945 -22.382   5.033  1.00  0.00
ATOM    280  CA  ALA    18     -12.017 -22.899   4.977  1.00  0.00
ATOM    281  HA  ALA    18     -12.645 -23.109   5.841  1.00  0.00
ATOM    282  CB  ALA    18     -12.330 -21.469   4.502  1.00  0.00
ATOM    283  HB1 ALA    18     -12.057 -20.761   5.270  1.00  0.00
ATOM    284  HB2 ALA    18     -13.389 -21.372   4.287  1.00  0.00
ATOM    285  HB3 ALA    18     -11.764 -21.251   3.601  1.00  0.00
ATOM    286  C   ALA    18     -12.372 -23.904   3.864  1.00  0.00
ATOM    287  O   ALA    18     -13.549 -24.058   3.525  1.00  0.00
ATOM    288  N   ARG    19     -11.335 -24.564   3.304  1.00  0.00
ATOM    289  HN  ARG    19     -10.428 -24.285   3.558  1.00  0.00
ATOM    290  CA  ARG    19     -11.463 -25.664   2.322  1.00  0.00
ATOM    291  HA  ARG    19     -10.461 -26.039   2.155  1.00  0.00
ATOM    292  CB  ARG    19     -12.324 -26.837   2.881  1.00  0.00
ATOM    293  HB1 ARG    19     -12.258 -27.674   2.191  1.00  0.00
ATOM    294  HB2 ARG    19     -13.358 -26.514   2.925  1.00  0.00
ATOM    295  CG  ARG    19     -11.926 -27.336   4.286  1.00  0.00
ATOM    296  HG1 ARG    19     -12.522 -28.212   4.517  1.00  0.00
ATOM    297  HG2 ARG    19     -12.152 -26.559   5.010  1.00  0.00
ATOM    298  CD  ARG    19     -10.443 -27.704   4.416  1.00  0.00
ATOM    299  HD1 ARG    19      -9.841 -26.820   4.237  1.00  0.00
ATOM    300  HD2 ARG    19     -10.192 -28.462   3.681  1.00  0.00
ATOM    301  NE  ARG    19     -10.151 -28.205   5.768  1.00  0.00
ATOM    302  HE  ARG    19      -9.995 -27.527   6.467  1.00  0.00
ATOM    303  CZ  ARG    19     -10.113 -29.498   6.120  1.00  0.00
ATOM    304  NH1 ARG    19     -10.315 -30.461   5.228  1.00  0.00
ATOM    305 HH11 ARG    19     -10.508 -30.236   4.271  1.00  0.00
ATOM    306 HH12 ARG    19     -10.261 -31.424   5.505  1.00  0.00
ATOM    307  NH2 ARG    19      -9.892 -29.827   7.378  1.00  0.00
ATOM    308 HH21 ARG    19      -9.761 -29.112   8.073  1.00  0.00
ATOM    309 HH22 ARG    19      -9.844 -30.791   7.648  1.00  0.00
ATOM    310  C   ARG    19     -11.996 -25.167   0.958  1.00  0.00
ATOM    311  O   ARG    19     -12.864 -25.800   0.338  1.00  0.00
ATOM    312  N   ASP    20     -11.443 -24.037   0.485  1.00  0.00
ATOM    313  HN  ASP    20     -10.788 -23.570   1.041  1.00  0.00
ATOM    314  CA  ASP    20     -11.769 -23.468  -0.838  1.00  0.00
ATOM    315  HA  ASP    20     -12.541 -24.077  -1.307  1.00  0.00
ATOM    316  CB  ASP    20     -12.309 -22.010  -0.689  1.00  0.00
ATOM    317  HB1 ASP    20     -12.380 -21.558  -1.674  1.00  0.00
ATOM    318  HB2 ASP    20     -11.601 -21.429  -0.100  1.00  0.00
ATOM    319  CG  ASP    20     -13.689 -21.930  -0.008  1.00  0.00
ATOM    320  OD1 ASP    20     -13.750 -21.843   1.238  1.00  0.00
ATOM    321  OD2 ASP    20     -14.720 -21.948  -0.721  1.00  0.00
ATOM    322  C   ASP    20     -10.514 -23.492  -1.734  1.00  0.00
ATOM    323  O   ASP    20      -9.717 -22.558  -1.696  1.00  0.00
ATOM    324  N   ILE    21     -10.357 -24.561  -2.547  1.00  0.00
ATOM    325  HN  ILE    21     -11.052 -25.252  -2.550  1.00  0.00
ATOM    326  CA  ILE    21      -9.181 -24.730  -3.438  1.00  0.00
ATOM    327  HA  ILE    21      -8.300 -24.483  -2.847  1.00  0.00
ATOM    328  CB  ILE    21      -9.016 -26.233  -3.930  1.00  0.00
ATOM    329  HB  ILE    21     -10.004 -26.599  -4.190  1.00  0.00
ATOM    330  CG1 ILE    21      -8.453 -27.132  -2.779  1.00  0.00
ATOM    331 HG11 ILE    21      -8.531 -28.173  -3.071  1.00  0.00
ATOM    332 HG12 ILE    21      -9.039 -26.979  -1.884  1.00  0.00
ATOM    333  CG2 ILE    21      -8.127 -26.369  -5.205  1.00  0.00
ATOM    334 HG21 ILE    21      -8.582 -25.828  -6.025  1.00  0.00
ATOM    335 HG22 ILE    21      -8.032 -27.412  -5.477  1.00  0.00
ATOM    336 HG23 ILE    21      -7.143 -25.959  -5.009  1.00  0.00
ATOM    337  CD1 ILE    21      -6.996 -26.864  -2.418  1.00  0.00
ATOM    338 HD11 ILE    21      -6.719 -27.483  -1.577  1.00  0.00
ATOM    339 HD12 ILE    21      -6.874 -25.824  -2.152  1.00  0.00
ATOM    340 HD13 ILE    21      -6.361 -27.100  -3.261  1.00  0.00
ATOM    341  C   ILE    21      -9.226 -23.742  -4.620  1.00  0.00
ATOM    342  O   ILE    21      -8.175 -23.315  -5.100  1.00  0.00
ATOM    343  N   ASP    22     -10.438 -23.351  -5.061  1.00  0.00
ATOM    344  HN  ASP    22     -11.243 -23.708  -4.615  1.00  0.00
ATOM    345  CA  ASP    22     -10.607 -22.411  -6.196  1.00  0.00
ATOM    346  HA  ASP    22     -10.117 -22.864  -7.058  1.00  0.00
ATOM    347  CB  ASP    22     -12.108 -22.225  -6.538  1.00  0.00
ATOM    348  HB1 ASP    22     -12.633 -21.874  -5.655  1.00  0.00
ATOM    349  HB2 ASP    22     -12.527 -23.188  -6.818  1.00  0.00
ATOM    350  CG  ASP    22     -12.355 -21.231  -7.695  1.00  0.00
ATOM    351  OD1 ASP    22     -12.735 -20.066  -7.435  1.00  0.00
ATOM    352  OD2 ASP    22     -12.135 -21.609  -8.867  1.00  0.00
ATOM    353  C   ASP    22      -9.928 -21.047  -5.907  1.00  0.00
ATOM    354  O   ASP    22      -9.220 -20.518  -6.762  1.00  0.00
ATOM    355  N   ALA    23     -10.136 -20.511  -4.691  1.00  0.00
ATOM    356  HN  ALA    23     -10.740 -20.975  -4.074  1.00  0.00
ATOM    357  CA  ALA    23      -9.486 -19.252  -4.239  1.00  0.00
ATOM    358  HA  ALA    23      -9.458 -18.561  -5.080  1.00  0.00
ATOM    359  CB  ALA    23     -10.297 -18.602  -3.105  1.00  0.00
ATOM    360  HB1 ALA    23      -9.839 -17.662  -2.810  1.00  0.00
ATOM    361  HB2 ALA    23     -10.332 -19.265  -2.252  1.00  0.00
ATOM    362  HB3 ALA    23     -11.309 -18.413  -3.447  1.00  0.00
ATOM    363  C   ALA    23      -8.040 -19.511  -3.791  1.00  0.00
ATOM    364  O   ALA    23      -7.160 -18.659  -3.967  1.00  0.00
ATOM    365  N   PHE    24      -7.810 -20.712  -3.236  1.00  0.00
ATOM    366  HN  PHE    24      -8.575 -21.307  -3.083  1.00  0.00
ATOM    367  CA  PHE    24      -6.473 -21.176  -2.830  1.00  0.00
ATOM    368  HA  PHE    24      -6.009 -20.382  -2.243  1.00  0.00
ATOM    369  CB  PHE    24      -6.615 -22.440  -1.934  1.00  0.00
ATOM    370  HB1 PHE    24      -6.963 -23.265  -2.547  1.00  0.00
ATOM    371  HB2 PHE    24      -7.362 -22.246  -1.173  1.00  0.00
ATOM    372  CG  PHE    24      -5.339 -22.878  -1.225  1.00  0.00
ATOM    373  CD1 PHE    24      -4.521 -23.871  -1.754  1.00  0.00
ATOM    374  HD1 PHE    24      -4.808 -24.367  -2.671  1.00  0.00
ATOM    375  CD2 PHE    24      -4.940 -22.263  -0.047  1.00  0.00
ATOM    376  HD2 PHE    24      -5.561 -21.491   0.389  1.00  0.00
ATOM    377  CE1 PHE    24      -3.356 -24.232  -1.120  1.00  0.00
ATOM    378  HE1 PHE    24      -2.732 -25.002  -1.545  1.00  0.00
ATOM    379  CE2 PHE    24      -3.775 -22.635   0.590  1.00  0.00
ATOM    380  HE2 PHE    24      -3.483 -22.147   1.511  1.00  0.00
ATOM    381  CZ  PHE    24      -2.979 -23.615   0.050  1.00  0.00
ATOM    382  HZ  PHE    24      -2.058 -23.904   0.544  1.00  0.00
ATOM    383  C   PHE    24      -5.585 -21.459  -4.071  1.00  0.00
ATOM    384  O   PHE    24      -4.392 -21.704  -3.933  1.00  0.00
ATOM    385  N   MET    25      -6.184 -21.461  -5.282  1.00  0.00
ATOM    386  HN  MET    25      -7.161 -21.385  -5.318  1.00  0.00
ATOM    387  CA  MET    25      -5.445 -21.605  -6.559  1.00  0.00
ATOM    388  HA  MET    25      -4.407 -21.823  -6.325  1.00  0.00
ATOM    389  CB  MET    25      -6.016 -22.776  -7.413  1.00  0.00
ATOM    390  HB1 MET    25      -7.067 -22.579  -7.602  1.00  0.00
ATOM    391  HB2 MET    25      -5.940 -23.689  -6.834  1.00  0.00
ATOM    392  CG  MET    25      -5.310 -23.025  -8.775  1.00  0.00
ATOM    393  HG1 MET    25      -5.016 -22.072  -9.200  1.00  0.00
ATOM    394  HG2 MET    25      -6.019 -23.489  -9.446  1.00  0.00
ATOM    395  SD  MET    25      -3.840 -24.101  -8.708  1.00  0.00
ATOM    396  CE  MET    25      -2.690 -23.286  -7.583  1.00  0.00
ATOM    397  HE1 MET    25      -1.756 -23.833  -7.570  1.00  0.00
ATOM    398  HE2 MET    25      -3.107 -23.276  -6.587  1.00  0.00
ATOM    399  HE3 MET    25      -2.510 -22.271  -7.910  1.00  0.00
ATOM    400  C   MET    25      -5.483 -20.303  -7.374  1.00  0.00
ATOM    401  O   MET    25      -4.536 -20.015  -8.120  1.00  0.00
ATOM    402  N   ALA    26      -6.576 -19.524  -7.206  1.00  0.00
ATOM    403  HN  ALA    26      -7.206 -19.764  -6.502  1.00  0.00
ATOM    404  CA  ALA    26      -6.870 -18.324  -8.030  1.00  0.00
ATOM    405  HA  ALA    26      -7.098 -18.668  -9.039  1.00  0.00
ATOM    406  CB  ALA    26      -8.111 -17.596  -7.486  1.00  0.00
ATOM    407  HB1 ALA    26      -8.955 -18.274  -7.463  1.00  0.00
ATOM    408  HB2 ALA    26      -8.354 -16.752  -8.122  1.00  0.00
ATOM    409  HB3 ALA    26      -7.918 -17.241  -6.478  1.00  0.00
ATOM    410  C   ALA    26      -5.690 -17.354  -8.081  1.00  0.00
ATOM    411  O   ALA    26      -5.165 -17.037  -9.147  1.00  0.00
ATOM    412  N   TRP    27      -5.237 -16.978  -6.894  1.00  0.00
ATOM    413  HN  TRP    27      -5.569 -17.449  -6.099  1.00  0.00
ATOM    414  CA  TRP    27      -4.272 -15.899  -6.699  1.00  0.00
ATOM    415  HA  TRP    27      -4.541 -15.083  -7.366  1.00  0.00
ATOM    416  CB  TRP    27      -4.404 -15.411  -5.253  1.00  0.00
ATOM    417  HB1 TRP    27      -3.650 -14.657  -5.074  1.00  0.00
ATOM    418  HB2 TRP    27      -4.223 -16.240  -4.578  1.00  0.00
ATOM    419  CG  TRP    27      -5.746 -14.806  -4.899  1.00  0.00
ATOM    420  CD1 TRP    27      -6.813 -15.425  -4.298  1.00  0.00
ATOM    421  HD1 TRP    27      -6.834 -16.466  -4.002  1.00  0.00
ATOM    422  CD2 TRP    27      -6.140 -13.442  -5.103  1.00  0.00
ATOM    423  NE1 TRP    27      -7.838 -14.529  -4.128  1.00  0.00
ATOM    424  HE1 TRP    27      -8.707 -14.731  -3.721  1.00  0.00
ATOM    425  CE2 TRP    27      -7.451 -13.309  -4.615  1.00  0.00
ATOM    426  CE3 TRP    27      -5.497 -12.321  -5.646  1.00  0.00
ATOM    427  HE3 TRP    27      -4.487 -12.389  -6.033  1.00  0.00
ATOM    428  CZ2 TRP    27      -8.137 -12.102  -4.667  1.00  0.00
ATOM    429  HZ2 TRP    27      -9.148 -12.004  -4.298  1.00  0.00
ATOM    430  CZ3 TRP    27      -6.182 -11.125  -5.699  1.00  0.00
ATOM    431  HZ3 TRP    27      -5.704 -10.246  -6.113  1.00  0.00
ATOM    432  CH2 TRP    27      -7.489 -11.021  -5.207  1.00  0.00
ATOM    433  HH2 TRP    27      -7.991 -10.060  -5.267  1.00  0.00
ATOM    434  C   TRP    27      -2.813 -16.314  -7.008  1.00  0.00
ATOM    435  O   TRP    27      -1.888 -15.520  -6.805  1.00  0.00
ATOM    436  N   TRP    28      -2.618 -17.549  -7.499  1.00  0.00
ATOM    437  HN  TRP    28      -3.388 -18.151  -7.573  1.00  0.00
ATOM    438  CA  TRP    28      -1.309 -18.047  -7.951  1.00  0.00
ATOM    439  HA  TRP    28      -0.524 -17.501  -7.429  1.00  0.00
ATOM    440  CB  TRP    28      -1.163 -19.564  -7.650  1.00  0.00
ATOM    441  HB1 TRP    28      -0.191 -19.902  -7.996  1.00  0.00
ATOM    442  HB2 TRP    28      -1.929 -20.106  -8.194  1.00  0.00
ATOM    443  CG  TRP    28      -1.297 -19.941  -6.191  1.00  0.00
ATOM    444  CD1 TRP    28      -2.412 -19.826  -5.411  1.00  0.00
ATOM    445  HD1 TRP    28      -3.365 -19.415  -5.743  1.00  0.00
ATOM    446  CD2 TRP    28      -0.291 -20.536  -5.349  1.00  0.00
ATOM    447  NE1 TRP    28      -2.155 -20.305  -4.159  1.00  0.00
ATOM    448  HE1 TRP    28      -2.801 -20.329  -3.422  1.00  0.00
ATOM    449  CE2 TRP    28      -0.869 -20.737  -4.089  1.00  0.00
ATOM    450  CE3 TRP    28       1.037 -20.908  -5.540  1.00  0.00
ATOM    451  HE3 TRP    28       1.520 -20.774  -6.499  1.00  0.00
ATOM    452  CZ2 TRP    28      -0.174 -21.298  -3.021  1.00  0.00
ATOM    453  HZ2 TRP    28      -0.632 -21.445  -2.052  1.00  0.00
ATOM    454  CZ3 TRP    28       1.731 -21.467  -4.485  1.00  0.00
ATOM    455  HZ3 TRP    28       2.764 -21.760  -4.617  1.00  0.00
ATOM    456  CH2 TRP    28       1.127 -21.653  -3.235  1.00  0.00
ATOM    457  HH2 TRP    28       1.710 -22.092  -2.434  1.00  0.00
ATOM    458  C   TRP    28      -1.162 -17.807  -9.463  1.00  0.00
ATOM    459  O   TRP    28      -2.148 -17.552 -10.168  1.00  0.00
ATOM    460  N   ALA    29       0.084 -17.865  -9.940  1.00  0.00
ATOM    461  HN  ALA    29       0.820 -17.910  -9.299  1.00  0.00
ATOM    462  CA  ALA    29       0.402 -17.858 -11.384  1.00  0.00
ATOM    463  HA  ALA    29      -0.268 -17.158 -11.880  1.00  0.00
ATOM    464  CB  ALA    29       1.851 -17.391 -11.618  1.00  0.00
ATOM    465  HB1 ALA    29       1.980 -16.392 -11.220  1.00  0.00
ATOM    466  HB2 ALA    29       2.066 -17.379 -12.680  1.00  0.00
ATOM    467  HB3 ALA    29       2.542 -18.065 -11.123  1.00  0.00
ATOM    468  C   ALA    29       0.186 -19.261 -11.971  1.00  0.00
ATOM    469  O   ALA    29       0.322 -20.257 -11.255  1.00  0.00
ATOM    470  N   ASP    30      -0.136 -19.337 -13.276  1.00  0.00
ATOM    471  HN  ASP    30      -0.232 -18.505 -13.787  1.00  0.00
ATOM    472  CA  ASP    30      -0.360 -20.632 -13.968  1.00  0.00
ATOM    473  HA  ASP    30      -1.069 -21.201 -13.371  1.00  0.00
ATOM    474  CB  ASP    30      -0.975 -20.409 -15.375  1.00  0.00
ATOM    475  HB1 ASP    30      -0.286 -19.812 -15.967  1.00  0.00
ATOM    476  HB2 ASP    30      -1.901 -19.854 -15.268  1.00  0.00
ATOM    477  CG  ASP    30      -1.287 -21.721 -16.139  1.00  0.00
ATOM    478  OD1 ASP    30      -0.682 -21.975 -17.205  1.00  0.00
ATOM    479  OD2 ASP    30      -2.136 -22.508 -15.671  1.00  0.00
ATOM    480  C   ASP    30       0.946 -21.444 -14.073  1.00  0.00
ATOM    481  O   ASP    30       0.921 -22.672 -14.123  1.00  0.00
ATOM    482  N   ASP    31       2.086 -20.743 -14.091  1.00  0.00
ATOM    483  HN  ASP    31       2.032 -19.765 -14.057  1.00  0.00
ATOM    484  CA  ASP    31       3.425 -21.361 -14.163  1.00  0.00
ATOM    485  HA  ASP    31       3.309 -22.413 -14.416  1.00  0.00
ATOM    486  CB  ASP    31       4.258 -20.668 -15.283  1.00  0.00
ATOM    487  HB1 ASP    31       3.670 -20.644 -16.196  1.00  0.00
ATOM    488  HB2 ASP    31       5.148 -21.261 -15.470  1.00  0.00
ATOM    489  CG  ASP    31       4.679 -19.220 -14.947  1.00  0.00
ATOM    490  OD1 ASP    31       5.893 -18.910 -14.968  1.00  0.00
ATOM    491  OD2 ASP    31       3.794 -18.390 -14.651  1.00  0.00
ATOM    492  C   ASP    31       4.145 -21.271 -12.798  1.00  0.00
ATOM    493  O   ASP    31       5.368 -21.436 -12.735  1.00  0.00
ATOM    494  N   CYS    32       3.372 -21.042 -11.708  1.00  0.00
ATOM    495  HN  CYS    32       2.397 -21.033 -11.820  1.00  0.00
ATOM    496  CA  CYS    32       3.929 -20.815 -10.357  1.00  0.00
ATOM    497  HA  CYS    32       4.586 -19.948 -10.425  1.00  0.00
ATOM    498  CB  CYS    32       2.822 -20.500  -9.334  1.00  0.00
ATOM    499  HB1 CYS    32       2.121 -21.327  -9.285  1.00  0.00
ATOM    500  HB2 CYS    32       2.292 -19.608  -9.643  1.00  0.00
ATOM    501  SG  CYS    32       3.442 -20.205  -7.661  1.00  0.00
ATOM    502  HG  CYS    32       3.893 -18.961  -7.609  1.00  0.00
ATOM    503  C   CYS    32       4.746 -22.018  -9.858  1.00  0.00
ATOM    504  O   CYS    32       4.315 -23.164  -9.982  1.00  0.00
ATOM    505  N   GLN    33       5.931 -21.735  -9.310  1.00  0.00
ATOM    506  HN  GLN    33       6.211 -20.795  -9.266  1.00  0.00
ATOM    507  CA  GLN    33       6.820 -22.757  -8.747  1.00  0.00
ATOM    508  HA  GLN    33       6.676 -23.687  -9.300  1.00  0.00
ATOM    509  CB  GLN    33       8.293 -22.308  -8.888  1.00  0.00
ATOM    510  HB1 GLN    33       8.940 -23.107  -8.534  1.00  0.00
ATOM    511  HB2 GLN    33       8.455 -21.432  -8.264  1.00  0.00
ATOM    512  CG  GLN    33       8.708 -21.948 -10.324  1.00  0.00
ATOM    513  HG1 GLN    33       9.714 -21.544 -10.306  1.00  0.00
ATOM    514  HG2 GLN    33       8.029 -21.185 -10.687  1.00  0.00
ATOM    515  CD  GLN    33       8.666 -23.115 -11.312  1.00  0.00
ATOM    516  OE1 GLN    33       9.627 -23.873 -11.448  1.00  0.00
ATOM    517  NE2 GLN    33       7.557 -23.249 -12.021  1.00  0.00
ATOM    518 HE21 GLN    33       6.829 -22.608 -11.869  1.00  0.00
ATOM    519 HE22 GLN    33       7.515 -23.970 -12.683  1.00  0.00
ATOM    520  C   GLN    33       6.458 -22.984  -7.273  1.00  0.00
ATOM    521  O   GLN    33       6.003 -22.058  -6.590  1.00  0.00
ATOM    522  N   TYR    34       6.660 -24.215  -6.795  1.00  0.00
ATOM    523  HN  TYR    34       7.018 -24.897  -7.399  1.00  0.00
ATOM    524  CA  TYR    34       6.366 -24.598  -5.412  1.00  0.00
ATOM    525  HA  TYR    34       6.364 -23.697  -4.801  1.00  0.00
ATOM    526  CB  TYR    34       4.974 -25.271  -5.320  1.00  0.00
ATOM    527  HB1 TYR    34       5.006 -26.231  -5.824  1.00  0.00
ATOM    528  HB2 TYR    34       4.250 -24.644  -5.830  1.00  0.00
ATOM    529  CG  TYR    34       4.468 -25.493  -3.889  1.00  0.00
ATOM    530  CD1 TYR    34       4.474 -26.760  -3.296  1.00  0.00
ATOM    531  HD1 TYR    34       4.842 -27.610  -3.864  1.00  0.00
ATOM    532  CD2 TYR    34       3.989 -24.416  -3.132  1.00  0.00
ATOM    533  HD2 TYR    34       3.970 -23.424  -3.573  1.00  0.00
ATOM    534  CE1 TYR    34       4.013 -26.943  -2.007  1.00  0.00
ATOM    535  HE1 TYR    34       4.024 -27.931  -1.565  1.00  0.00
ATOM    536  CE2 TYR    34       3.532 -24.598  -1.845  1.00  0.00
ATOM    537  HE2 TYR    34       3.165 -23.751  -1.278  1.00  0.00
ATOM    538  CZ  TYR    34       3.548 -25.860  -1.285  1.00  0.00
ATOM    539  OH  TYR    34       3.076 -26.040  -0.005  1.00  0.00
ATOM    540  HH  TYR    34       3.708 -26.559   0.500  1.00  0.00
ATOM    541  C   TYR    34       7.470 -25.531  -4.911  1.00  0.00
ATOM    542  O   TYR    34       7.623 -26.639  -5.427  1.00  0.00
ATOM    543  N   TYR    35       8.258 -25.050  -3.939  1.00  0.00
ATOM    544  HN  TYR    35       8.090 -24.143  -3.617  1.00  0.00
ATOM    545  CA  TYR    35       9.360 -25.806  -3.322  1.00  0.00
ATOM    546  HA  TYR    35       9.523 -26.709  -3.909  1.00  0.00
ATOM    547  CB  TYR    35      10.675 -24.980  -3.310  1.00  0.00
ATOM    548  HB1 TYR    35      11.435 -25.539  -2.770  1.00  0.00
ATOM    549  HB2 TYR    35      10.501 -24.053  -2.779  1.00  0.00
ATOM    550  CG  TYR    35      11.248 -24.622  -4.699  1.00  0.00
ATOM    551  CD1 TYR    35      12.419 -25.220  -5.176  1.00  0.00
ATOM    552  HD1 TYR    35      12.920 -25.960  -4.560  1.00  0.00
ATOM    553  CD2 TYR    35      10.630 -23.674  -5.519  1.00  0.00
ATOM    554  HD2 TYR    35       9.721 -23.191  -5.173  1.00  0.00
ATOM    555  CE1 TYR    35      12.942 -24.893  -6.412  1.00  0.00
ATOM    556  HE1 TYR    35      13.843 -25.374  -6.758  1.00  0.00
ATOM    557  CE2 TYR    35      11.150 -23.347  -6.756  1.00  0.00
ATOM    558  HE2 TYR    35      10.646 -22.616  -7.370  1.00  0.00
ATOM    559  CZ  TYR    35      12.306 -23.952  -7.197  1.00  0.00
ATOM    560  OH  TYR    35      12.820 -23.623  -8.433  1.00  0.00
ATOM    561  HH  TYR    35      13.041 -24.430  -8.909  1.00  0.00
ATOM    562  C   TYR    35       9.000 -26.224  -1.887  1.00  0.00
ATOM    563  O   TYR    35       8.172 -25.588  -1.222  1.00  0.00
ATOM    564  N   ALA    36       9.647 -27.307  -1.441  1.00  0.00
ATOM    565  HN  ALA    36      10.233 -27.776  -2.069  1.00  0.00
ATOM    566  CA  ALA    36       9.560 -27.833  -0.072  1.00  0.00
ATOM    567  HA  ALA    36       8.812 -27.261   0.480  1.00  0.00
ATOM    568  CB  ALA    36       9.131 -29.308  -0.103  1.00  0.00
ATOM    569  HB1 ALA    36       8.176 -29.395  -0.605  1.00  0.00
ATOM    570  HB2 ALA    36       9.038 -29.687   0.907  1.00  0.00
ATOM    571  HB3 ALA    36       9.868 -29.893  -0.640  1.00  0.00
ATOM    572  C   ALA    36      10.919 -27.677   0.619  1.00  0.00
ATOM    573  O   ALA    36      11.950 -27.634  -0.064  1.00  0.00
ATOM    574  N   PHE    37      10.898 -27.616   1.965  1.00  0.00
ATOM    575  HN  PHE    37      10.028 -27.690   2.410  1.00  0.00
ATOM    576  CA  PHE    37      12.100 -27.441   2.814  1.00  0.00
ATOM    577  HA  PHE    37      12.490 -26.449   2.624  1.00  0.00
ATOM    578  CB  PHE    37      11.685 -27.538   4.308  1.00  0.00
ATOM    579  HB1 PHE    37      11.206 -28.496   4.474  1.00  0.00
ATOM    580  HB2 PHE    37      10.960 -26.758   4.518  1.00  0.00
ATOM    581  CG  PHE    37      12.829 -27.390   5.318  1.00  0.00
ATOM    582  CD1 PHE    37      13.502 -26.179   5.459  1.00  0.00
ATOM    583  HD1 PHE    37      13.222 -25.338   4.834  1.00  0.00
ATOM    584  CD2 PHE    37      13.216 -28.454   6.136  1.00  0.00
ATOM    585  HD2 PHE    37      12.715 -29.408   6.039  1.00  0.00
ATOM    586  CE1 PHE    37      14.520 -26.033   6.380  1.00  0.00
ATOM    587  HE1 PHE    37      15.030 -25.081   6.474  1.00  0.00
ATOM    588  CE2 PHE    37      14.239 -28.307   7.056  1.00  0.00
ATOM    589  HE2 PHE    37      14.527 -29.141   7.681  1.00  0.00
ATOM    590  CZ  PHE    37      14.888 -27.095   7.179  1.00  0.00
ATOM    591  HZ  PHE    37      15.684 -26.978   7.901  1.00  0.00
ATOM    592  C   PHE    37      13.194 -28.502   2.500  1.00  0.00
ATOM    593  O   PHE    37      12.892 -29.697   2.556  1.00  0.00
ATOM    594  N   PRO    38      14.479 -28.106   2.177  1.00  0.00
ATOM    595  CA  PRO    38      14.924 -26.691   2.008  1.00  0.00
ATOM    596  HA  PRO    38      14.537 -26.075   2.819  1.00  0.00
ATOM    597  CB  PRO    38      16.467 -26.797   2.147  1.00  0.00
ATOM    598  HB1 PRO    38      16.750 -26.680   3.192  1.00  0.00
ATOM    599  HB2 PRO    38      16.955 -26.023   1.563  1.00  0.00
ATOM    600  CG  PRO    38      16.797 -28.171   1.643  1.00  0.00
ATOM    601  HG1 PRO    38      17.713 -28.531   2.101  1.00  0.00
ATOM    602  HG2 PRO    38      16.911 -28.148   0.562  1.00  0.00
ATOM    603  CD  PRO    38      15.623 -29.050   2.037  1.00  0.00
ATOM    604  HD1 PRO    38      15.819 -29.546   2.982  1.00  0.00
ATOM    605  HD2 PRO    38      15.416 -29.784   1.272  1.00  0.00
ATOM    606  C   PRO    38      14.491 -26.046   0.650  1.00  0.00
ATOM    607  O   PRO    38      13.769 -25.041   0.647  1.00  0.00
ATOM    608  N   ALA    39      14.901 -26.646  -0.492  1.00  0.00
ATOM    609  HN  ALA    39      15.417 -27.473  -0.427  1.00  0.00
ATOM    610  CA  ALA    39      14.593 -26.127  -1.842  1.00  0.00
ATOM    611  HA  ALA    39      13.665 -25.552  -1.792  1.00  0.00
ATOM    612  CB  ALA    39      15.713 -25.178  -2.326  1.00  0.00
ATOM    613  HB1 ALA    39      15.457 -24.768  -3.297  1.00  0.00
ATOM    614  HB2 ALA    39      16.645 -25.720  -2.403  1.00  0.00
ATOM    615  HB3 ALA    39      15.834 -24.365  -1.618  1.00  0.00
ATOM    616  C   ALA    39      14.388 -27.300  -2.818  1.00  0.00
ATOM    617  O   ALA    39      15.294 -27.665  -3.577  1.00  0.00
ATOM    618  N   THR    40      13.197 -27.913  -2.761  1.00  0.00
ATOM    619  HN  THR    40      12.521 -27.561  -2.142  1.00  0.00
ATOM    620  CA  THR    40      12.851 -29.096  -3.572  1.00  0.00
ATOM    621  HA  THR    40      13.657 -29.283  -4.280  1.00  0.00
ATOM    622  CB  THR    40      12.707 -30.356  -2.654  1.00  0.00
ATOM    623  HB  THR    40      11.946 -30.151  -1.903  1.00  0.00
ATOM    624  OG1 THR    40      13.957 -30.590  -1.979  1.00  0.00
ATOM    625  HG1 THR    40      13.879 -30.308  -1.067  1.00  0.00
ATOM    626  CG2 THR    40      12.296 -31.623  -3.435  1.00  0.00
ATOM    627 HG21 THR    40      13.015 -31.819  -4.220  1.00  0.00
ATOM    628 HG22 THR    40      11.315 -31.481  -3.876  1.00  0.00
ATOM    629 HG23 THR    40      12.264 -32.471  -2.765  1.00  0.00
ATOM    630  C   THR    40      11.555 -28.827  -4.355  1.00  0.00
ATOM    631  O   THR    40      10.466 -28.807  -3.771  1.00  0.00
ATOM    632  N   LEU    41      11.690 -28.604  -5.676  1.00  0.00
ATOM    633  HN  LEU    41      12.579 -28.711  -6.077  1.00  0.00
ATOM    634  CA  LEU    41      10.568 -28.232  -6.559  1.00  0.00
ATOM    635  HA  LEU    41      10.075 -27.367  -6.120  1.00  0.00
ATOM    636  CB  LEU    41      11.113 -27.835  -7.964  1.00  0.00
ATOM    637  HB1 LEU    41      11.598 -28.707  -8.395  1.00  0.00
ATOM    638  HB2 LEU    41      11.871 -27.070  -7.827  1.00  0.00
ATOM    639  CG  LEU    41      10.063 -27.304  -8.992  1.00  0.00
ATOM    640  HG  LEU    41       9.269 -28.028  -9.069  1.00  0.00
ATOM    641  CD1 LEU    41       9.414 -25.991  -8.514  1.00  0.00
ATOM    642 HD11 LEU    41      10.169 -25.224  -8.402  1.00  0.00
ATOM    643 HD12 LEU    41       8.924 -26.152  -7.563  1.00  0.00
ATOM    644 HD13 LEU    41       8.676 -25.665  -9.237  1.00  0.00
ATOM    645  CD2 LEU    41      10.680 -27.145 -10.400  1.00  0.00
ATOM    646 HD21 LEU    41      11.474 -26.407 -10.375  1.00  0.00
ATOM    647 HD22 LEU    41       9.918 -26.826 -11.099  1.00  0.00
ATOM    648 HD23 LEU    41      11.084 -28.094 -10.729  1.00  0.00
ATOM    649  C   LEU    41       9.549 -29.387  -6.673  1.00  0.00
ATOM    650  O   LEU    41       9.794 -30.377  -7.366  1.00  0.00
ATOM    651  N   LEU    42       8.424 -29.257  -5.947  1.00  0.00
ATOM    652  HN  LEU    42       8.353 -28.502  -5.331  1.00  0.00
ATOM    653  CA  LEU    42       7.306 -30.217  -6.004  1.00  0.00
ATOM    654  HA  LEU    42       7.720 -31.215  -6.065  1.00  0.00
ATOM    655  CB  LEU    42       6.422 -30.119  -4.726  1.00  0.00
ATOM    656  HB1 LEU    42       5.673 -30.904  -4.778  1.00  0.00
ATOM    657  HB2 LEU    42       5.906 -29.161  -4.745  1.00  0.00
ATOM    658  CG  LEU    42       7.155 -30.235  -3.352  1.00  0.00
ATOM    659  HG  LEU    42       7.771 -29.352  -3.218  1.00  0.00
ATOM    660  CD1 LEU    42       6.145 -30.250  -2.183  1.00  0.00
ATOM    661 HD11 LEU    42       5.491 -31.112  -2.265  1.00  0.00
ATOM    662 HD12 LEU    42       5.550 -29.348  -2.206  1.00  0.00
ATOM    663 HD13 LEU    42       6.679 -30.295  -1.243  1.00  0.00
ATOM    664  CD2 LEU    42       8.099 -31.459  -3.304  1.00  0.00
ATOM    665 HD21 LEU    42       8.577 -31.515  -2.336  1.00  0.00
ATOM    666 HD22 LEU    42       8.861 -31.355  -4.065  1.00  0.00
ATOM    667 HD23 LEU    42       7.537 -32.369  -3.483  1.00  0.00
ATOM    668  C   LEU    42       6.434 -29.958  -7.246  1.00  0.00
ATOM    669  O   LEU    42       5.915 -30.902  -7.860  1.00  0.00
ATOM    670  N   ALA    43       6.281 -28.670  -7.605  1.00  0.00
ATOM    671  HN  ALA    43       6.814 -27.988  -7.142  1.00  0.00
ATOM    672  CA  ALA    43       5.338 -28.239  -8.656  1.00  0.00
ATOM    673  HA  ALA    43       5.126 -29.084  -9.309  1.00  0.00
ATOM    674  CB  ALA    43       4.025 -27.815  -7.996  1.00  0.00
ATOM    675  HB1 ALA    43       3.306 -27.524  -8.754  1.00  0.00
ATOM    676  HB2 ALA    43       4.205 -26.979  -7.333  1.00  0.00
ATOM    677  HB3 ALA    43       3.620 -28.641  -7.424  1.00  0.00
ATOM    678  C   ALA    43       5.919 -27.088  -9.495  1.00  0.00
ATOM    679  O   ALA    43       6.235 -26.030  -8.953  1.00  0.00
ATOM    680  N   GLY    44       6.037 -27.307 -10.819  1.00  0.00
ATOM    681  HN  GLY    44       5.759 -28.179 -11.171  1.00  0.00
ATOM    682  CA  GLY    44       6.553 -26.303 -11.758  1.00  0.00
ATOM    683  HA1 GLY    44       7.207 -26.802 -12.463  1.00  0.00
ATOM    684  HA2 GLY    44       7.132 -25.564 -11.218  1.00  0.00
ATOM    685  C   GLY    44       5.441 -25.590 -12.533  1.00  0.00
ATOM    686  O   GLY    44       5.641 -25.190 -13.688  1.00  0.00
ATOM    687  N   ASN    45       4.307 -25.374 -11.842  1.00  0.00
ATOM    688  HN  ASN    45       4.350 -25.502 -10.870  1.00  0.00
ATOM    689  CA  ASN    45       3.029 -24.853 -12.409  1.00  0.00
ATOM    690  HA  ASN    45       3.173 -23.789 -12.573  1.00  0.00
ATOM    691  CB  ASN    45       2.606 -25.511 -13.767  1.00  0.00
ATOM    692  HB1 ASN    45       3.409 -25.382 -14.484  1.00  0.00
ATOM    693  HB2 ASN    45       1.735 -24.993 -14.147  1.00  0.00
ATOM    694  CG  ASN    45       2.271 -27.002 -13.667  1.00  0.00
ATOM    695  OD1 ASN    45       1.137 -27.384 -13.375  1.00  0.00
ATOM    696  ND2 ASN    45       3.246 -27.850 -13.945  1.00  0.00
ATOM    697 HD21 ASN    45       4.118 -27.483 -14.196  1.00  0.00
ATOM    698 HD22 ASN    45       3.059 -28.809 -13.885  1.00  0.00
ATOM    699  C   ASN    45       1.893 -25.018 -11.376  1.00  0.00
ATOM    700  O   ASN    45       1.989 -25.849 -10.466  1.00  0.00
ATOM    701  N   ALA    46       0.798 -24.256 -11.582  1.00  0.00
ATOM    702  HN  ALA    46       0.750 -23.746 -12.414  1.00  0.00
ATOM    703  CA  ALA    46      -0.338 -24.151 -10.638  1.00  0.00
ATOM    704  HA  ALA    46       0.060 -23.852  -9.672  1.00  0.00
ATOM    705  CB  ALA    46      -1.298 -23.046 -11.110  1.00  0.00
ATOM    706  HB1 ALA    46      -2.094 -22.908 -10.387  1.00  0.00
ATOM    707  HB2 ALA    46      -1.728 -23.316 -12.068  1.00  0.00
ATOM    708  HB3 ALA    46      -0.757 -22.114 -11.218  1.00  0.00
ATOM    709  C   ALA    46      -1.103 -25.482 -10.467  1.00  0.00
ATOM    710  O   ALA    46      -1.540 -25.816  -9.361  1.00  0.00
ATOM    711  N   ALA    47      -1.235 -26.238 -11.569  1.00  0.00
ATOM    712  HN  ALA    47      -0.755 -25.965 -12.382  1.00  0.00
ATOM    713  CA  ALA    47      -2.052 -27.468 -11.611  1.00  0.00
ATOM    714  HA  ALA    47      -3.072 -27.190 -11.352  1.00  0.00
ATOM    715  CB  ALA    47      -2.072 -28.062 -13.023  1.00  0.00
ATOM    716  HB1 ALA    47      -1.077 -28.410 -13.288  1.00  0.00
ATOM    717  HB2 ALA    47      -2.388 -27.309 -13.732  1.00  0.00
ATOM    718  HB3 ALA    47      -2.766 -28.896 -13.059  1.00  0.00
ATOM    719  C   ALA    47      -1.556 -28.516 -10.610  1.00  0.00
ATOM    720  O   ALA    47      -2.352 -29.223  -9.997  1.00  0.00
ATOM    721  N   GLU    48      -0.233 -28.614 -10.469  1.00  0.00
ATOM    722  HN  GLU    48       0.342 -28.017 -11.000  1.00  0.00
ATOM    723  CA  GLU    48       0.402 -29.568  -9.545  1.00  0.00
ATOM    724  HA  GLU    48      -0.139 -30.512  -9.619  1.00  0.00
ATOM    725  CB  GLU    48       1.867 -29.812  -9.970  1.00  0.00
ATOM    726  HB1 GLU    48       2.267 -30.649  -9.402  1.00  0.00
ATOM    727  HB2 GLU    48       2.450 -28.928  -9.739  1.00  0.00
ATOM    728  CG  GLU    48       2.051 -30.115 -11.465  1.00  0.00
ATOM    729  HG1 GLU    48       1.758 -29.236 -12.036  1.00  0.00
ATOM    730  HG2 GLU    48       1.391 -30.934 -11.741  1.00  0.00
ATOM    731  CD  GLU    48       3.504 -30.470 -11.823  1.00  0.00
ATOM    732  OE1 GLU    48       4.355 -29.560 -11.862  1.00  0.00
ATOM    733  OE2 GLU    48       3.797 -31.653 -12.083  1.00  0.00
ATOM    734  C   GLU    48       0.311 -29.068  -8.083  1.00  0.00
ATOM    735  O   GLU    48       0.176 -29.872  -7.152  1.00  0.00
ATOM    736  N   ILE    49       0.366 -27.724  -7.907  1.00  0.00
ATOM    737  HN  ILE    49       0.462 -27.157  -8.704  1.00  0.00
ATOM    738  CA  ILE    49       0.289 -27.064  -6.580  1.00  0.00
ATOM    739  HA  ILE    49       1.096 -27.457  -5.965  1.00  0.00
ATOM    740  CB  ILE    49       0.469 -25.495  -6.690  1.00  0.00
ATOM    741  HB  ILE    49      -0.315 -25.121  -7.346  1.00  0.00
ATOM    742  CG1 ILE    49       1.846 -25.144  -7.321  1.00  0.00
ATOM    743 HG11 ILE    49       1.937 -25.649  -8.277  1.00  0.00
ATOM    744 HG12 ILE    49       2.634 -25.501  -6.672  1.00  0.00
ATOM    745  CG2 ILE    49       0.297 -24.792  -5.316  1.00  0.00
ATOM    746 HG21 ILE    49       1.051 -25.147  -4.623  1.00  0.00
ATOM    747 HG22 ILE    49      -0.685 -25.006  -4.913  1.00  0.00
ATOM    748 HG23 ILE    49       0.399 -23.721  -5.439  1.00  0.00
ATOM    749  CD1 ILE    49       2.103 -23.670  -7.561  1.00  0.00
ATOM    750 HD11 ILE    49       1.338 -23.263  -8.208  1.00  0.00
ATOM    751 HD12 ILE    49       3.069 -23.547  -8.031  1.00  0.00
ATOM    752 HD13 ILE    49       2.098 -23.141  -6.619  1.00  0.00
ATOM    753  C   ILE    49      -1.055 -27.367  -5.898  1.00  0.00
ATOM    754  O   ILE    49      -1.088 -27.781  -4.727  1.00  0.00
ATOM    755  N   ARG    50      -2.158 -27.149  -6.646  1.00  0.00
ATOM    756  HN  ARG    50      -2.046 -26.855  -7.582  1.00  0.00
ATOM    757  CA  ARG    50      -3.520 -27.338  -6.116  1.00  0.00
ATOM    758  HA  ARG    50      -3.600 -26.716  -5.224  1.00  0.00
ATOM    759  CB  ARG    50      -4.611 -26.869  -7.122  1.00  0.00
ATOM    760  HB1 ARG    50      -4.481 -25.804  -7.291  1.00  0.00
ATOM    761  HB2 ARG    50      -5.590 -27.021  -6.675  1.00  0.00
ATOM    762  CG  ARG    50      -4.592 -27.580  -8.493  1.00  0.00
ATOM    763  HG1 ARG    50      -4.813 -28.633  -8.340  1.00  0.00
ATOM    764  HG2 ARG    50      -3.598 -27.490  -8.915  1.00  0.00
ATOM    765  CD  ARG    50      -5.596 -27.004  -9.492  1.00  0.00
ATOM    766  HD1 ARG    50      -5.375 -25.950  -9.646  1.00  0.00
ATOM    767  HD2 ARG    50      -6.595 -27.100  -9.080  1.00  0.00
ATOM    768  NE  ARG    50      -5.558 -27.703 -10.798  1.00  0.00
ATOM    769  HE  ARG    50      -5.351 -28.667 -10.777  1.00  0.00
ATOM    770  CZ  ARG    50      -5.793 -27.131 -11.995  1.00  0.00
ATOM    771  NH1 ARG    50      -6.067 -25.835 -12.087  1.00  0.00
ATOM    772 HH11 ARG    50      -6.107 -25.271 -11.264  1.00  0.00
ATOM    773 HH12 ARG    50      -6.224 -25.413 -12.988  1.00  0.00
ATOM    774  NH2 ARG    50      -5.749 -27.866 -13.097  1.00  0.00
ATOM    775 HH21 ARG    50      -5.543 -28.847 -13.045  1.00  0.00
ATOM    776 HH22 ARG    50      -5.925 -27.449 -13.992  1.00  0.00
ATOM    777  C   ARG    50      -3.740 -28.803  -5.705  1.00  0.00
ATOM    778  O   ARG    50      -4.128 -29.045  -4.574  1.00  0.00
ATOM    779  N   VAL    51      -3.408 -29.760  -6.610  1.00  0.00
ATOM    780  HN  VAL    51      -2.984 -29.477  -7.452  1.00  0.00
ATOM    781  CA  VAL    51      -3.637 -31.211  -6.391  1.00  0.00
ATOM    782  HA  VAL    51      -4.704 -31.352  -6.235  1.00  0.00
ATOM    783  CB  VAL    51      -3.214 -32.066  -7.648  1.00  0.00
ATOM    784  HB  VAL    51      -2.162 -31.866  -7.847  1.00  0.00
ATOM    785  CG1 VAL    51      -3.369 -33.593  -7.393  1.00  0.00
ATOM    786 HG11 VAL    51      -4.403 -33.823  -7.163  1.00  0.00
ATOM    787 HG12 VAL    51      -2.745 -33.892  -6.559  1.00  0.00
ATOM    788 HG13 VAL    51      -3.067 -34.144  -8.275  1.00  0.00
ATOM    789  CG2 VAL    51      -4.019 -31.637  -8.900  1.00  0.00
ATOM    790 HG21 VAL    51      -5.072 -31.835  -8.747  1.00  0.00
ATOM    791 HG22 VAL    51      -3.674 -32.188  -9.766  1.00  0.00
ATOM    792 HG23 VAL    51      -3.881 -30.576  -9.080  1.00  0.00
ATOM    793  C   VAL    51      -2.891 -31.695  -5.136  1.00  0.00
ATOM    794  O   VAL    51      -3.461 -32.419  -4.314  1.00  0.00
ATOM    795  N   ARG    52      -1.635 -31.228  -4.987  1.00  0.00
ATOM    796  HN  ARG    52      -1.264 -30.665  -5.700  1.00  0.00
ATOM    797  CA  ARG    52      -0.787 -31.528  -3.816  1.00  0.00
ATOM    798  HA  ARG    52      -0.610 -32.599  -3.805  1.00  0.00
ATOM    799  CB  ARG    52       0.581 -30.793  -3.923  1.00  0.00
ATOM    800  HB1 ARG    52       0.399 -29.724  -3.949  1.00  0.00
ATOM    801  HB2 ARG    52       1.051 -31.077  -4.858  1.00  0.00
ATOM    802  CG  ARG    52       1.589 -31.090  -2.777  1.00  0.00
ATOM    803  HG1 ARG    52       1.032 -31.227  -1.851  1.00  0.00
ATOM    804  HG2 ARG    52       2.244 -30.234  -2.662  1.00  0.00
ATOM    805  CD  ARG    52       2.462 -32.347  -3.023  1.00  0.00
ATOM    806  HD1 ARG    52       3.163 -32.435  -2.209  1.00  0.00
ATOM    807  HD2 ARG    52       3.018 -32.207  -3.944  1.00  0.00
ATOM    808  NE  ARG    52       1.695 -33.613  -3.138  1.00  0.00
ATOM    809  HE  ARG    52       0.724 -33.541  -3.267  1.00  0.00
ATOM    810  CZ  ARG    52       2.234 -34.846  -3.134  1.00  0.00
ATOM    811  NH1 ARG    52       3.523 -35.031  -2.888  1.00  0.00
ATOM    812 HH11 ARG    52       4.121 -34.248  -2.699  1.00  0.00
ATOM    813 HH12 ARG    52       3.910 -35.958  -2.895  1.00  0.00
ATOM    814  NH2 ARG    52       1.462 -35.896  -3.349  1.00  0.00
ATOM    815 HH21 ARG    52       0.479 -35.774  -3.517  1.00  0.00
ATOM    816 HH22 ARG    52       1.850 -36.820  -3.358  1.00  0.00
ATOM    817  C   ARG    52      -1.503 -31.133  -2.509  1.00  0.00
ATOM    818  O   ARG    52      -1.497 -31.883  -1.526  1.00  0.00
ATOM    819  N   HIS    53      -2.128 -29.944  -2.525  1.00  0.00
ATOM    820  HN  HIS    53      -2.103 -29.412  -3.355  1.00  0.00
ATOM    821  CA  HIS    53      -2.855 -29.406  -1.362  1.00  0.00
ATOM    822  HA  HIS    53      -2.267 -29.645  -0.476  1.00  0.00
ATOM    823  CB  HIS    53      -2.965 -27.871  -1.457  1.00  0.00
ATOM    824  HB1 HIS    53      -3.635 -27.503  -0.681  1.00  0.00
ATOM    825  HB2 HIS    53      -3.366 -27.600  -2.427  1.00  0.00
ATOM    826  CG  HIS    53      -1.648 -27.161  -1.283  1.00  0.00
ATOM    827  ND1 HIS    53      -1.079 -26.368  -2.258  1.00  0.00
ATOM    828  HD1 HIS    53      -1.440 -26.224  -3.161  1.00  0.00
ATOM    829  CD2 HIS    53      -0.817 -27.093  -0.214  1.00  0.00
ATOM    830  HD2 HIS    53      -0.952 -27.596   0.738  1.00  0.00
ATOM    831  CE1 HIS    53       0.038 -25.842  -1.797  1.00  0.00
ATOM    832  HE1 HIS    53       0.695 -25.175  -2.338  1.00  0.00
ATOM    833  NE2 HIS    53       0.216 -26.263  -0.560  1.00  0.00
ATOM    834  HE2 HIS    53       0.983 -26.034   0.015  1.00  0.00
ATOM    835  C   HIS    53      -4.242 -30.048  -1.190  1.00  0.00
ATOM    836  O   HIS    53      -4.702 -30.155  -0.073  1.00  0.00
ATOM    837  N   ILE    54      -4.888 -30.480  -2.288  1.00  0.00
ATOM    838  HN  ILE    54      -4.454 -30.385  -3.158  1.00  0.00
ATOM    839  CA  ILE    54      -6.223 -31.128  -2.237  1.00  0.00
ATOM    840  HA  ILE    54      -6.912 -30.438  -1.750  1.00  0.00
ATOM    841  CB  ILE    54      -6.754 -31.421  -3.692  1.00  0.00
ATOM    842  HB  ILE    54      -5.970 -31.954  -4.221  1.00  0.00
ATOM    843  CG1 ILE    54      -7.043 -30.094  -4.455  1.00  0.00
ATOM    844 HG11 ILE    54      -6.175 -29.451  -4.396  1.00  0.00
ATOM    845 HG12 ILE    54      -7.875 -29.586  -3.988  1.00  0.00
ATOM    846  CG2 ILE    54      -8.005 -32.322  -3.689  1.00  0.00
ATOM    847 HG21 ILE    54      -8.326 -32.509  -4.706  1.00  0.00
ATOM    848 HG22 ILE    54      -8.805 -31.837  -3.149  1.00  0.00
ATOM    849 HG23 ILE    54      -7.775 -33.267  -3.209  1.00  0.00
ATOM    850  CD1 ILE    54      -7.383 -30.256  -5.923  1.00  0.00
ATOM    851 HD11 ILE    54      -6.574 -30.774  -6.425  1.00  0.00
ATOM    852 HD12 ILE    54      -7.516 -29.281  -6.368  1.00  0.00
ATOM    853 HD13 ILE    54      -8.294 -30.825  -6.023  1.00  0.00
ATOM    854  C   ILE    54      -6.139 -32.425  -1.408  1.00  0.00
ATOM    855  O   ILE    54      -7.042 -32.737  -0.627  1.00  0.00
ATOM    856  N   GLU    55      -5.011 -33.137  -1.584  1.00  0.00
ATOM    857  HN  GLU    55      -4.387 -32.842  -2.287  1.00  0.00
ATOM    858  CA  GLU    55      -4.661 -34.337  -0.799  1.00  0.00
ATOM    859  HA  GLU    55      -5.442 -35.081  -0.961  1.00  0.00
ATOM    860  CB  GLU    55      -3.309 -34.900  -1.311  1.00  0.00
ATOM    861  HB1 GLU    55      -3.057 -35.796  -0.746  1.00  0.00
ATOM    862  HB2 GLU    55      -2.533 -34.154  -1.141  1.00  0.00
ATOM    863  CG  GLU    55      -3.303 -35.260  -2.811  1.00  0.00
ATOM    864  HG1 GLU    55      -3.646 -34.396  -3.377  1.00  0.00
ATOM    865  HG2 GLU    55      -3.998 -36.075  -2.980  1.00  0.00
ATOM    866  CD  GLU    55      -1.912 -35.671  -3.321  1.00  0.00
ATOM    867  OE1 GLU    55      -1.504 -36.835  -3.108  1.00  0.00
ATOM    868  OE2 GLU    55      -1.201 -34.826  -3.908  1.00  0.00
ATOM    869  C   GLU    55      -4.589 -34.001   0.707  1.00  0.00
ATOM    870  O   GLU    55      -5.053 -34.776   1.547  1.00  0.00
ATOM    871  N   ARG    56      -4.022 -32.822   1.019  1.00  0.00
ATOM    872  HN  ARG    56      -3.640 -32.283   0.290  1.00  0.00
ATOM    873  CA  ARG    56      -3.933 -32.309   2.403  1.00  0.00
ATOM    874  HA  ARG    56      -3.552 -33.117   3.025  1.00  0.00
ATOM    875  CB  ARG    56      -2.925 -31.123   2.465  1.00  0.00
ATOM    876  HB1 ARG    56      -3.324 -30.300   1.880  1.00  0.00
ATOM    877  HB2 ARG    56      -1.991 -31.438   2.009  1.00  0.00
ATOM    878  CG  ARG    56      -2.610 -30.595   3.886  1.00  0.00
ATOM    879  HG1 ARG    56      -3.521 -30.187   4.312  1.00  0.00
ATOM    880  HG2 ARG    56      -1.874 -29.805   3.809  1.00  0.00
ATOM    881  CD  ARG    56      -2.065 -31.690   4.833  1.00  0.00
ATOM    882  HD1 ARG    56      -2.833 -32.446   4.967  1.00  0.00
ATOM    883  HD2 ARG    56      -1.841 -31.244   5.798  1.00  0.00
ATOM    884  NE  ARG    56      -0.838 -32.328   4.315  1.00  0.00
ATOM    885  HE  ARG    56      -0.259 -31.772   3.752  1.00  0.00
ATOM    886  CZ  ARG    56      -0.454 -33.590   4.565  1.00  0.00
ATOM    887  NH1 ARG    56      -1.223 -34.418   5.262  1.00  0.00
ATOM    888 HH11 ARG    56      -2.117 -34.112   5.603  1.00  0.00
ATOM    889 HH12 ARG    56      -0.919 -35.355   5.446  1.00  0.00
ATOM    890  NH2 ARG    56       0.694 -34.032   4.076  1.00  0.00
ATOM    891 HH21 ARG    56       1.269 -33.433   3.517  1.00  0.00
ATOM    892 HH22 ARG    56       0.996 -34.974   4.261  1.00  0.00
ATOM    893  C   ARG    56      -5.334 -31.891   2.936  1.00  0.00
ATOM    894  O   ARG    56      -5.620 -32.033   4.128  1.00  0.00
ATOM    895  N   PHE    57      -6.204 -31.392   2.029  1.00  0.00
ATOM    896  HN  PHE    57      -5.910 -31.324   1.097  1.00  0.00
ATOM    897  CA  PHE    57      -7.585 -30.948   2.363  1.00  0.00
ATOM    898  HA  PHE    57      -7.532 -30.378   3.288  1.00  0.00
ATOM    899  CB  PHE    57      -8.155 -30.015   1.240  1.00  0.00
ATOM    900  HB1 PHE    57      -9.239 -29.995   1.315  1.00  0.00
ATOM    901  HB2 PHE    57      -7.892 -30.433   0.277  1.00  0.00
ATOM    902  CG  PHE    57      -7.661 -28.555   1.239  1.00  0.00
ATOM    903  CD1 PHE    57      -6.323 -28.234   1.443  1.00  0.00
ATOM    904  HD1 PHE    57      -5.612 -29.028   1.633  1.00  0.00
ATOM    905  CD2 PHE    57      -8.549 -27.500   0.998  1.00  0.00
ATOM    906  HD2 PHE    57      -9.600 -27.716   0.836  1.00  0.00
ATOM    907  CE1 PHE    57      -5.887 -26.925   1.408  1.00  0.00
ATOM    908  HE1 PHE    57      -4.841 -26.702   1.568  1.00  0.00
ATOM    909  CE2 PHE    57      -8.111 -26.188   0.969  1.00  0.00
ATOM    910  HE2 PHE    57      -8.813 -25.386   0.782  1.00  0.00
ATOM    911  CZ  PHE    57      -6.779 -25.904   1.172  1.00  0.00
ATOM    912  HZ  PHE    57      -6.434 -24.879   1.146  1.00  0.00
ATOM    913  C   PHE    57      -8.536 -32.152   2.606  1.00  0.00
ATOM    914  O   PHE    57      -9.682 -31.953   3.023  1.00  0.00
ATOM    915  N   LYS    58      -8.074 -33.393   2.318  1.00  0.00
ATOM    916  HN  LYS    58      -7.206 -33.481   1.866  1.00  0.00
ATOM    917  CA  LYS    58      -8.839 -34.627   2.627  1.00  0.00
ATOM    918  HA  LYS    58      -9.859 -34.477   2.281  1.00  0.00
ATOM    919  CB  LYS    58      -8.243 -35.850   1.885  1.00  0.00
ATOM    920  HB1 LYS    58      -8.840 -36.730   2.113  1.00  0.00
ATOM    921  HB2 LYS    58      -7.231 -36.015   2.245  1.00  0.00
ATOM    922  CG  LYS    58      -8.181 -35.689   0.356  1.00  0.00
ATOM    923  HG1 LYS    58      -7.812 -36.613  -0.078  1.00  0.00
ATOM    924  HG2 LYS    58      -7.483 -34.889   0.124  1.00  0.00
ATOM    925  CD  LYS    58      -9.552 -35.346  -0.276  1.00  0.00
ATOM    926  HD1 LYS    58      -9.987 -34.502   0.249  1.00  0.00
ATOM    927  HD2 LYS    58     -10.211 -36.201  -0.182  1.00  0.00
ATOM    928  CE  LYS    58      -9.426 -34.987  -1.757  1.00  0.00
ATOM    929  HE1 LYS    58      -9.070 -35.848  -2.300  1.00  0.00
ATOM    930  HE2 LYS    58      -8.711 -34.181  -1.866  1.00  0.00
ATOM    931  NZ  LYS    58     -10.715 -34.548  -2.334  1.00  0.00
ATOM    932  HZ1 LYS    58     -11.058 -33.699  -1.837  1.00  0.00
ATOM    933  HZ2 LYS    58     -11.426 -35.302  -2.237  1.00  0.00
ATOM    934  HZ3 LYS    58     -10.596 -34.324  -3.338  1.00  0.00
ATOM    935  C   LYS    58      -8.880 -34.902   4.139  1.00  0.00
ATOM    936  O   LYS    58      -9.810 -35.558   4.624  1.00  0.00
ATOM    937  N   GLU    59      -7.848 -34.424   4.866  1.00  0.00
ATOM    938  HN  GLU    59      -7.096 -34.001   4.395  1.00  0.00
ATOM    939  CA  GLU    59      -7.802 -34.505   6.334  1.00  0.00
ATOM    940  HA  GLU    59      -8.011 -35.534   6.612  1.00  0.00
ATOM    941  CB  GLU    59      -6.395 -34.117   6.888  1.00  0.00
ATOM    942  HB1 GLU    59      -6.483 -33.914   7.951  1.00  0.00
ATOM    943  HB2 GLU    59      -6.068 -33.205   6.395  1.00  0.00
ATOM    944  CG  GLU    59      -5.294 -35.190   6.700  1.00  0.00
ATOM    945  HG1 GLU    59      -5.636 -36.116   7.159  1.00  0.00
ATOM    946  HG2 GLU    59      -4.403 -34.863   7.228  1.00  0.00
ATOM    947  CD  GLU    59      -4.917 -35.468   5.229  1.00  0.00
ATOM    948  OE1 GLU    59      -5.500 -36.392   4.608  1.00  0.00
ATOM    949  OE2 GLU    59      -4.030 -34.772   4.698  1.00  0.00
ATOM    950  C   GLU    59      -8.893 -33.597   6.933  1.00  0.00
ATOM    951  O   GLU    59      -8.849 -32.384   6.724  1.00  0.00
ATOM    952  N   PRO    60      -9.906 -34.161   7.674  1.00  0.00
ATOM    953  CA  PRO    60     -10.942 -33.342   8.356  1.00  0.00
ATOM    954  HA  PRO    60     -11.427 -32.665   7.661  1.00  0.00
ATOM    955  CB  PRO    60     -11.959 -34.398   8.862  1.00  0.00
ATOM    956  HB1 PRO    60     -12.746 -34.531   8.122  1.00  0.00
ATOM    957  HB2 PRO    60     -12.407 -34.076   9.797  1.00  0.00
ATOM    958  CG  PRO    60     -11.148 -35.653   9.029  1.00  0.00
ATOM    959  HG1 PRO    60     -11.783 -36.527   8.927  1.00  0.00
ATOM    960  HG2 PRO    60     -10.668 -35.659  10.006  1.00  0.00
ATOM    961  CD  PRO    60     -10.112 -35.619   7.924  1.00  0.00
ATOM    962  HD1 PRO    60     -10.484 -36.107   7.030  1.00  0.00
ATOM    963  HD2 PRO    60      -9.189 -36.089   8.251  1.00  0.00
ATOM    964  C   PRO    60     -10.324 -32.526   9.518  1.00  0.00
ATOM    965  O   PRO    60     -10.854 -31.489   9.933  1.00  0.00
ATOM    966  N   ASP    61      -9.169 -33.022   9.991  1.00  0.00
ATOM    967  HN  ASP    61      -8.815 -33.826   9.561  1.00  0.00
ATOM    968  CA  ASP    61      -8.383 -32.455  11.093  1.00  0.00
ATOM    969  HA  ASP    61      -9.070 -32.015  11.810  1.00  0.00
ATOM    970  CB  ASP    61      -7.609 -33.601  11.794  1.00  0.00
ATOM    971  HB1 ASP    61      -8.322 -34.253  12.287  1.00  0.00
ATOM    972  HB2 ASP    61      -6.956 -33.183  12.556  1.00  0.00
ATOM    973  CG  ASP    61      -6.756 -34.455  10.824  1.00  0.00
ATOM    974  OD1 ASP    61      -5.547 -34.192  10.674  1.00  0.00
ATOM    975  OD2 ASP    61      -7.305 -35.406  10.215  1.00  0.00
ATOM    976  C   ASP    61      -7.413 -31.352  10.623  1.00  0.00
ATOM    977  O   ASP    61      -6.754 -30.720  11.462  1.00  0.00
ATOM    978  N   LEU    62      -7.318 -31.129   9.291  1.00  0.00
ATOM    979  HN  LEU    62      -7.811 -31.708   8.679  1.00  0.00
ATOM    980  CA  LEU    62      -6.494 -30.040   8.727  1.00  0.00
ATOM    981  HA  LEU    62      -5.474 -30.172   9.090  1.00  0.00
ATOM    982  CB  LEU    62      -6.475 -30.062   7.168  1.00  0.00
ATOM    983  HB1 LEU    62      -7.502 -30.058   6.817  1.00  0.00
ATOM    984  HB2 LEU    62      -6.010 -30.990   6.844  1.00  0.00
ATOM    985  CG  LEU    62      -5.719 -28.856   6.503  1.00  0.00
ATOM    986  HG  LEU    62      -6.098 -27.939   6.942  1.00  0.00
ATOM    987  CD1 LEU    62      -4.214 -28.898   6.824  1.00  0.00
ATOM    988 HD11 LEU    62      -3.776 -29.810   6.436  1.00  0.00
ATOM    989 HD12 LEU    62      -4.069 -28.860   7.897  1.00  0.00
ATOM    990 HD13 LEU    62      -3.724 -28.045   6.374  1.00  0.00
ATOM    991  CD2 LEU    62      -5.976 -28.767   4.987  1.00  0.00
ATOM    992 HD21 LEU    62      -5.614 -29.663   4.497  1.00  0.00
ATOM    993 HD22 LEU    62      -5.466 -27.904   4.578  1.00  0.00
ATOM    994 HD23 LEU    62      -7.039 -28.667   4.805  1.00  0.00
ATOM    995  C   LEU    62      -7.024 -28.673   9.193  1.00  0.00
ATOM    996  O   LEU    62      -8.181 -28.332   8.930  1.00  0.00
ATOM    997  N   TYR    63      -6.169 -27.902   9.876  1.00  0.00
ATOM    998  HN  TYR    63      -5.303 -28.282  10.141  1.00  0.00
ATOM    999  CA  TYR    63      -6.484 -26.522  10.257  1.00  0.00
ATOM   1000  HA  TYR    63      -7.120 -26.093   9.484  1.00  0.00
ATOM   1001  CB  TYR    63      -7.248 -26.497  11.610  1.00  0.00
ATOM   1002  HB1 TYR    63      -6.596 -26.860  12.393  1.00  0.00
ATOM   1003  HB2 TYR    63      -8.108 -27.157  11.545  1.00  0.00
ATOM   1004  CG  TYR    63      -7.756 -25.106  12.011  1.00  0.00
ATOM   1005  CD1 TYR    63      -8.895 -24.564  11.412  1.00  0.00
ATOM   1006  HD1 TYR    63      -9.432 -25.148  10.672  1.00  0.00
ATOM   1007  CD2 TYR    63      -7.089 -24.331  12.963  1.00  0.00
ATOM   1008  HD2 TYR    63      -6.204 -24.733  13.447  1.00  0.00
ATOM   1009  CE1 TYR    63      -9.355 -23.305  11.754  1.00  0.00
ATOM   1010  HE1 TYR    63     -10.241 -22.910  11.279  1.00  0.00
ATOM   1011  CE2 TYR    63      -7.548 -23.074  13.309  1.00  0.00
ATOM   1012  HE2 TYR    63      -7.014 -22.493  14.052  1.00  0.00
ATOM   1013  CZ  TYR    63      -8.674 -22.562  12.699  1.00  0.00
ATOM   1014  OH  TYR    63      -9.124 -21.307  13.039  1.00  0.00
ATOM   1015  HH  TYR    63      -8.371 -20.697  13.085  1.00  0.00
ATOM   1016  C   TYR    63      -5.186 -25.702  10.342  1.00  0.00
ATOM   1017  O   TYR    63      -4.316 -26.004  11.162  1.00  0.00
ATOM   1018  N   GLY    64      -5.066 -24.667   9.493  1.00  0.00
ATOM   1019  HN  GLY    64      -5.752 -24.532   8.814  1.00  0.00
ATOM   1020  CA  GLY    64      -3.939 -23.738   9.559  1.00  0.00
ATOM   1021  HA1 GLY    64      -3.723 -23.383   8.558  1.00  0.00
ATOM   1022  HA2 GLY    64      -3.058 -24.241   9.944  1.00  0.00
ATOM   1023  C   GLY    64      -4.286 -22.551  10.439  1.00  0.00
ATOM   1024  O   GLY    64      -5.040 -21.668  10.015  1.00  0.00
ATOM   1025  N   GLU    65      -3.767 -22.554  11.678  1.00  0.00
ATOM   1026  HN  GLU    65      -3.223 -23.324  11.955  1.00  0.00
ATOM   1027  CA  GLU    65      -3.981 -21.460  12.641  1.00  0.00
ATOM   1028  HA  GLU    65      -4.893 -20.934  12.359  1.00  0.00
ATOM   1029  CB  GLU    65      -4.157 -22.022  14.079  1.00  0.00
ATOM   1030  HB1 GLU    65      -3.276 -22.602  14.337  1.00  0.00
ATOM   1031  HB2 GLU    65      -5.016 -22.682  14.086  1.00  0.00
ATOM   1032  CG  GLU    65      -4.365 -20.940  15.164  1.00  0.00
ATOM   1033  HG1 GLU    65      -5.112 -20.237  14.811  1.00  0.00
ATOM   1034  HG2 GLU    65      -3.430 -20.404  15.301  1.00  0.00
ATOM   1035  CD  GLU    65      -4.810 -21.501  16.529  1.00  0.00
ATOM   1036  OE1 GLU    65      -3.973 -22.103  17.236  1.00  0.00
ATOM   1037  OE2 GLU    65      -5.989 -21.319  16.912  1.00  0.00
ATOM   1038  C   GLU    65      -2.805 -20.484  12.573  1.00  0.00
ATOM   1039  O   GLU    65      -1.716 -20.782  13.081  1.00  0.00
ATOM   1040  N   LEU    66      -3.025 -19.335  11.914  1.00  0.00
ATOM   1041  HN  LEU    66      -3.920 -19.164  11.554  1.00  0.00
ATOM   1042  CA  LEU    66      -1.977 -18.329  11.725  1.00  0.00
ATOM   1043  HA  LEU    66      -1.106 -18.842  11.325  1.00  0.00
ATOM   1044  CB  LEU    66      -2.394 -17.227  10.735  1.00  0.00
ATOM   1045  HB1 LEU    66      -3.212 -16.659  11.175  1.00  0.00
ATOM   1046  HB2 LEU    66      -2.770 -17.702   9.831  1.00  0.00
ATOM   1047  CG  LEU    66      -1.236 -16.235  10.348  1.00  0.00
ATOM   1048  HG  LEU    66      -0.560 -16.154  11.204  1.00  0.00
ATOM   1049  CD1 LEU    66      -0.385 -16.773   9.174  1.00  0.00
ATOM   1050 HD11 LEU    66       0.388 -16.056   8.929  1.00  0.00
ATOM   1051 HD12 LEU    66      -1.017 -16.932   8.304  1.00  0.00
ATOM   1052 HD13 LEU    66       0.076 -17.713   9.455  1.00  0.00
ATOM   1053  CD2 LEU    66      -1.774 -14.828  10.053  1.00  0.00
ATOM   1054 HD21 LEU    66      -2.436 -14.862   9.196  1.00  0.00
ATOM   1055 HD22 LEU    66      -0.950 -14.162   9.843  1.00  0.00
ATOM   1056 HD23 LEU    66      -2.318 -14.458  10.911  1.00  0.00
ATOM   1057  C   LEU    66      -1.596 -17.678  13.066  1.00  0.00
ATOM   1058  O   LEU    66      -2.457 -17.389  13.903  1.00  0.00
ATOM   1059  N   LEU    67      -0.296 -17.458  13.229  1.00  0.00
ATOM   1060  HN  LEU    67       0.304 -17.721  12.501  1.00  0.00
ATOM   1061  CA  LEU    67       0.300 -16.857  14.426  1.00  0.00
ATOM   1062  HA  LEU    67      -0.420 -16.849  15.242  1.00  0.00
ATOM   1063  CB  LEU    67       1.533 -17.710  14.815  1.00  0.00
ATOM   1064  HB1 LEU    67       1.818 -17.465  15.834  1.00  0.00
ATOM   1065  HB2 LEU    67       2.362 -17.437  14.158  1.00  0.00
ATOM   1066  CG  LEU    67       1.325 -19.248  14.715  1.00  0.00
ATOM   1067  HG  LEU    67       0.803 -19.457  13.785  1.00  0.00
ATOM   1068  CD1 LEU    67       2.662 -19.982  14.639  1.00  0.00
ATOM   1069 HD11 LEU    67       3.244 -19.789  15.531  1.00  0.00
ATOM   1070 HD12 LEU    67       3.205 -19.626  13.771  1.00  0.00
ATOM   1071 HD13 LEU    67       2.493 -21.046  14.539  1.00  0.00
ATOM   1072  CD2 LEU    67       0.450 -19.774  15.865  1.00  0.00
ATOM   1073 HD21 LEU    67      -0.520 -19.295  15.822  1.00  0.00
ATOM   1074 HD22 LEU    67       0.919 -19.555  16.815  1.00  0.00
ATOM   1075 HD23 LEU    67       0.324 -20.845  15.765  1.00  0.00
ATOM   1076  C   LEU    67       0.747 -15.437  14.081  1.00  0.00
ATOM   1077  O   LEU    67       0.355 -14.454  14.717  1.00  0.00
ATOM   1078  N   THR    68       1.537 -15.371  13.005  1.00  0.00
ATOM   1079  HN  THR    68       1.670 -16.197  12.483  1.00  0.00
ATOM   1080  CA  THR    68       2.230 -14.158  12.560  1.00  0.00
ATOM   1081  HA  THR    68       1.645 -13.294  12.870  1.00  0.00
ATOM   1082  CB  THR    68       3.651 -14.075  13.235  1.00  0.00
ATOM   1083  HB  THR    68       4.168 -15.016  13.050  1.00  0.00
ATOM   1084  OG1 THR    68       3.499 -13.930  14.661  1.00  0.00
ATOM   1085  HG1 THR    68       3.252 -13.020  14.868  1.00  0.00
ATOM   1086  CG2 THR    68       4.528 -12.927  12.695  1.00  0.00
ATOM   1087 HG21 THR    68       4.726 -13.084  11.641  1.00  0.00
ATOM   1088 HG22 THR    68       5.465 -12.902  13.233  1.00  0.00
ATOM   1089 HG23 THR    68       4.015 -11.981  12.824  1.00  0.00
ATOM   1090  C   THR    68       2.355 -14.164  11.029  1.00  0.00
ATOM   1091  O   THR    68       2.523 -15.218  10.420  1.00  0.00
ATOM   1092  N   ARG    69       2.257 -12.973  10.430  1.00  0.00
ATOM   1093  HN  ARG    69       2.025 -12.200  10.978  1.00  0.00
ATOM   1094  CA  ARG    69       2.482 -12.752   9.001  1.00  0.00
ATOM   1095  HA  ARG    69       3.107 -13.561   8.627  1.00  0.00
ATOM   1096  CB  ARG    69       1.137 -12.746   8.221  1.00  0.00
ATOM   1097  HB1 ARG    69       0.721 -13.750   8.239  1.00  0.00
ATOM   1098  HB2 ARG    69       1.324 -12.469   7.189  1.00  0.00
ATOM   1099  CG  ARG    69       0.092 -11.782   8.808  1.00  0.00
ATOM   1100  HG1 ARG    69       0.529 -10.788   8.858  1.00  0.00
ATOM   1101  HG2 ARG    69      -0.149 -12.105   9.814  1.00  0.00
ATOM   1102  CD  ARG    69      -1.205 -11.704   8.003  1.00  0.00
ATOM   1103  HD1 ARG    69      -1.619 -12.701   7.892  1.00  0.00
ATOM   1104  HD2 ARG    69      -0.986 -11.296   7.020  1.00  0.00
ATOM   1105  NE  ARG    69      -2.195 -10.844   8.682  1.00  0.00
ATOM   1106  HE  ARG    69      -2.097 -10.746   9.658  1.00  0.00
ATOM   1107  CZ  ARG    69      -3.204 -10.199   8.083  1.00  0.00
ATOM   1108  NH1 ARG    69      -3.389 -10.298   6.771  1.00  0.00
ATOM   1109 HH11 ARG    69      -2.775 -10.859   6.216  1.00  0.00
ATOM   1110 HH12 ARG    69      -4.145  -9.809   6.327  1.00  0.00
ATOM   1111  NH2 ARG    69      -4.023  -9.449   8.808  1.00  0.00
ATOM   1112 HH21 ARG    69      -3.895  -9.373   9.800  1.00  0.00
ATOM   1113 HH22 ARG    69      -4.775  -8.947   8.368  1.00  0.00
ATOM   1114  C   ARG    69       3.235 -11.423   8.819  1.00  0.00
ATOM   1115  O   ARG    69       2.846 -10.392   9.386  1.00  0.00
ATOM   1116  N   VAL    70       4.342 -11.464   8.066  1.00  0.00
ATOM   1117  HN  VAL    70       4.627 -12.333   7.703  1.00  0.00
ATOM   1118  CA  VAL    70       5.139 -10.268   7.727  1.00  0.00
ATOM   1119  HA  VAL    70       4.607  -9.388   8.089  1.00  0.00
ATOM   1120  CB  VAL    70       6.573 -10.288   8.399  1.00  0.00
ATOM   1121  HB  VAL    70       7.070  -9.362   8.142  1.00  0.00
ATOM   1122  CG1 VAL    70       6.464 -10.341   9.939  1.00  0.00
ATOM   1123 HG11 VAL    70       5.949 -11.249  10.237  1.00  0.00
ATOM   1124 HG12 VAL    70       5.908  -9.485  10.300  1.00  0.00
ATOM   1125 HG13 VAL    70       7.453 -10.331  10.382  1.00  0.00
ATOM   1126  CG2 VAL    70       7.456 -11.443   7.878  1.00  0.00
ATOM   1127 HG21 VAL    70       7.015 -12.395   8.154  1.00  0.00
ATOM   1128 HG22 VAL    70       8.449 -11.375   8.305  1.00  0.00
ATOM   1129 HG23 VAL    70       7.533 -11.390   6.797  1.00  0.00
ATOM   1130  C   VAL    70       5.254 -10.159   6.205  1.00  0.00
ATOM   1131  O   VAL    70       5.202 -11.171   5.510  1.00  0.00
ATOM   1132  N   ILE    71       5.408  -8.934   5.688  1.00  0.00
ATOM   1133  HN  ILE    71       5.460  -8.167   6.296  1.00  0.00
ATOM   1134  CA  ILE    71       5.504  -8.694   4.237  1.00  0.00
ATOM   1135  HA  ILE    71       5.712  -9.652   3.753  1.00  0.00
ATOM   1136  CB  ILE    71       4.140  -8.162   3.640  1.00  0.00
ATOM   1137  HB  ILE    71       3.419  -8.972   3.729  1.00  0.00
ATOM   1138  CG1 ILE    71       4.286  -7.810   2.124  1.00  0.00
ATOM   1139 HG11 ILE    71       4.695  -8.665   1.597  1.00  0.00
ATOM   1140 HG12 ILE    71       4.961  -6.973   2.010  1.00  0.00
ATOM   1141  CG2 ILE    71       3.573  -6.976   4.453  1.00  0.00
ATOM   1142 HG21 ILE    71       3.444  -7.275   5.485  1.00  0.00
ATOM   1143 HG22 ILE    71       2.614  -6.672   4.050  1.00  0.00
ATOM   1144 HG23 ILE    71       4.260  -6.140   4.406  1.00  0.00
ATOM   1145  CD1 ILE    71       2.987  -7.439   1.443  1.00  0.00
ATOM   1146 HD11 ILE    71       2.543  -6.583   1.935  1.00  0.00
ATOM   1147 HD12 ILE    71       2.301  -8.274   1.484  1.00  0.00
ATOM   1148 HD13 ILE    71       3.185  -7.192   0.410  1.00  0.00
ATOM   1149  C   ILE    71       6.677  -7.743   3.926  1.00  0.00
ATOM   1150  O   ILE    71       6.729  -6.606   4.414  1.00  0.00
ATOM   1151  N   VAL    72       7.647  -8.257   3.143  1.00  0.00
ATOM   1152  HN  VAL    72       7.561  -9.189   2.860  1.00  0.00
ATOM   1153  CA  VAL    72       8.823  -7.508   2.680  1.00  0.00
ATOM   1154  HA  VAL    72       8.838  -6.531   3.166  1.00  0.00
ATOM   1155  CB  VAL    72      10.159  -8.271   3.052  1.00  0.00
ATOM   1156  HB  VAL    72      10.197  -9.188   2.462  1.00  0.00
ATOM   1157  CG1 VAL    72      11.412  -7.431   2.695  1.00  0.00
ATOM   1158 HG11 VAL    72      11.407  -6.504   3.256  1.00  0.00
ATOM   1159 HG12 VAL    72      11.416  -7.203   1.634  1.00  0.00
ATOM   1160 HG13 VAL    72      12.309  -7.988   2.937  1.00  0.00
ATOM   1161  CG2 VAL    72      10.166  -8.680   4.549  1.00  0.00
ATOM   1162 HG21 VAL    72      11.070  -9.230   4.774  1.00  0.00
ATOM   1163 HG22 VAL    72       9.307  -9.308   4.762  1.00  0.00
ATOM   1164 HG23 VAL    72      10.121  -7.794   5.173  1.00  0.00
ATOM   1165  C   VAL    72       8.709  -7.316   1.152  1.00  0.00
ATOM   1166  O   VAL    72       9.061  -8.215   0.377  1.00  0.00
ATOM   1167  N   GLY    73       8.172  -6.154   0.742  1.00  0.00
ATOM   1168  HN  GLY    73       7.902  -5.501   1.421  1.00  0.00
ATOM   1169  CA  GLY    73       7.972  -5.828  -0.676  1.00  0.00
ATOM   1170  HA1 GLY    73       8.932  -5.852  -1.185  1.00  0.00
ATOM   1171  HA2 GLY    73       7.580  -4.822  -0.740  1.00  0.00
ATOM   1172  C   GLY    73       6.996  -6.771  -1.386  1.00  0.00
ATOM   1173  O   GLY    73       5.793  -6.767  -1.097  1.00  0.00
ATOM   1174  N   ASN    74       7.526  -7.594  -2.308  1.00  0.00
ATOM   1175  HN  ASN    74       8.498  -7.567  -2.448  1.00  0.00
ATOM   1176  CA  ASN    74       6.729  -8.548  -3.117  1.00  0.00
ATOM   1177  HA  ASN    74       5.713  -8.166  -3.186  1.00  0.00
ATOM   1178  CB  ASN    74       7.314  -8.665  -4.555  1.00  0.00
ATOM   1179  HB1 ASN    74       7.322  -7.683  -5.010  1.00  0.00
ATOM   1180  HB2 ASN    74       6.675  -9.315  -5.146  1.00  0.00
ATOM   1181  CG  ASN    74       8.750  -9.214  -4.594  1.00  0.00
ATOM   1182  OD1 ASN    74       9.585  -8.891  -3.742  1.00  0.00
ATOM   1183  ND2 ASN    74       9.037 -10.074  -5.557  1.00  0.00
ATOM   1184 HD21 ASN    74       8.325 -10.315  -6.189  1.00  0.00
ATOM   1185 HD22 ASN    74       9.943 -10.438  -5.598  1.00  0.00
ATOM   1186  C   ASN    74       6.680  -9.946  -2.463  1.00  0.00
ATOM   1187  O   ASN    74       6.224 -10.908  -3.082  1.00  0.00
ATOM   1188  N   VAL    75       7.108 -10.034  -1.201  1.00  0.00
ATOM   1189  HN  VAL    75       7.260  -9.199  -0.708  1.00  0.00
ATOM   1190  CA  VAL    75       7.309 -11.315  -0.489  1.00  0.00
ATOM   1191  HA  VAL    75       6.945 -12.129  -1.117  1.00  0.00
ATOM   1192  CB  VAL    75       8.848 -11.555  -0.195  1.00  0.00
ATOM   1193  HB  VAL    75       9.218 -10.684   0.349  1.00  0.00
ATOM   1194  CG1 VAL    75       9.087 -12.801   0.696  1.00  0.00
ATOM   1195 HG11 VAL    75       8.592 -12.672   1.653  1.00  0.00
ATOM   1196 HG12 VAL    75      10.147 -12.937   0.863  1.00  0.00
ATOM   1197 HG13 VAL    75       8.687 -13.683   0.207  1.00  0.00
ATOM   1198  CG2 VAL    75       9.662 -11.661  -1.510  1.00  0.00
ATOM   1199 HG21 VAL    75       9.314 -12.507  -2.091  1.00  0.00
ATOM   1200 HG22 VAL    75      10.714 -11.794  -1.282  1.00  0.00
ATOM   1201 HG23 VAL    75       9.541 -10.755  -2.094  1.00  0.00
ATOM   1202  C   VAL    75       6.515 -11.301   0.828  1.00  0.00
ATOM   1203  O   VAL    75       6.544 -10.301   1.540  1.00  0.00
ATOM   1204  N   VAL    76       5.783 -12.395   1.139  1.00  0.00
ATOM   1205  HN  VAL    76       5.728 -13.126   0.488  1.00  0.00
ATOM   1206  CA  VAL    76       5.064 -12.541   2.428  1.00  0.00
ATOM   1207  HA  VAL    76       5.338 -11.701   3.071  1.00  0.00
ATOM   1208  CB  VAL    76       3.493 -12.528   2.262  1.00  0.00
ATOM   1209  HB  VAL    76       3.200 -13.449   1.754  1.00  0.00
ATOM   1210  CG1 VAL    76       2.783 -12.508   3.646  1.00  0.00
ATOM   1211 HG11 VAL    76       1.711 -12.534   3.510  1.00  0.00
ATOM   1212 HG12 VAL    76       3.049 -11.606   4.184  1.00  0.00
ATOM   1213 HG13 VAL    76       3.086 -13.371   4.232  1.00  0.00
ATOM   1214  CG2 VAL    76       3.019 -11.344   1.389  1.00  0.00
ATOM   1215 HG21 VAL    76       3.486 -11.397   0.411  1.00  0.00
ATOM   1216 HG22 VAL    76       3.288 -10.408   1.859  1.00  0.00
ATOM   1217 HG23 VAL    76       1.945 -11.385   1.269  1.00  0.00
ATOM   1218  C   VAL    76       5.475 -13.854   3.126  1.00  0.00
ATOM   1219  O   VAL    76       5.559 -14.898   2.492  1.00  0.00
ATOM   1220  N   ILE    77       5.734 -13.766   4.433  1.00  0.00
ATOM   1221  HN  ILE    77       5.813 -12.878   4.816  1.00  0.00
ATOM   1222  CA  ILE    77       5.916 -14.910   5.337  1.00  0.00
ATOM   1223  HA  ILE    77       6.176 -15.798   4.765  1.00  0.00
ATOM   1224  CB  ILE    77       7.073 -14.588   6.362  1.00  0.00
ATOM   1225  HB  ILE    77       6.847 -13.610   6.770  1.00  0.00
ATOM   1226  CG1 ILE    77       8.463 -14.486   5.659  1.00  0.00
ATOM   1227 HG11 ILE    77       9.137 -13.928   6.297  1.00  0.00
ATOM   1228 HG12 ILE    77       8.355 -13.959   4.723  1.00  0.00
ATOM   1229  CG2 ILE    77       7.119 -15.560   7.574  1.00  0.00
ATOM   1230 HG21 ILE    77       7.923 -15.265   8.242  1.00  0.00
ATOM   1231 HG22 ILE    77       7.286 -16.571   7.234  1.00  0.00
ATOM   1232 HG23 ILE    77       6.178 -15.513   8.111  1.00  0.00
ATOM   1233  CD1 ILE    77       9.122 -15.813   5.355  1.00  0.00
ATOM   1234 HD11 ILE    77       8.436 -16.442   4.804  1.00  0.00
ATOM   1235 HD12 ILE    77       9.395 -16.301   6.279  1.00  0.00
ATOM   1236 HD13 ILE    77      10.007 -15.641   4.763  1.00  0.00
ATOM   1237  C   ILE    77       4.599 -15.127   6.100  1.00  0.00
ATOM   1238  O   ILE    77       4.265 -14.325   6.974  1.00  0.00
ATOM   1239  N   ASP    78       3.831 -16.161   5.735  1.00  0.00
ATOM   1240  HN  ASP    78       4.024 -16.623   4.895  1.00  0.00
ATOM   1241  CA  ASP    78       2.693 -16.628   6.545  1.00  0.00
ATOM   1242  HA  ASP    78       2.361 -15.800   7.176  1.00  0.00
ATOM   1243  CB  ASP    78       1.495 -17.090   5.663  1.00  0.00
ATOM   1244  HB1 ASP    78       0.808 -17.681   6.263  1.00  0.00
ATOM   1245  HB2 ASP    78       1.871 -17.715   4.859  1.00  0.00
ATOM   1246  CG  ASP    78       0.722 -15.907   5.051  1.00  0.00
ATOM   1247  OD1 ASP    78      -0.279 -15.444   5.664  1.00  0.00
ATOM   1248  OD2 ASP    78       1.123 -15.426   3.972  1.00  0.00
ATOM   1249  C   ASP    78       3.178 -17.755   7.453  1.00  0.00
ATOM   1250  O   ASP    78       3.447 -18.863   6.993  1.00  0.00
ATOM   1251  N   HIS    79       3.324 -17.435   8.743  1.00  0.00
ATOM   1252  HN  HIS    79       3.119 -16.519   9.012  1.00  0.00
ATOM   1253  CA  HIS    79       3.748 -18.381   9.770  1.00  0.00
ATOM   1254  HA  HIS    79       4.225 -19.233   9.284  1.00  0.00
ATOM   1255  CB  HIS    79       4.778 -17.711  10.721  1.00  0.00
ATOM   1256  HB1 HIS    79       4.334 -16.814  11.146  1.00  0.00
ATOM   1257  HB2 HIS    79       5.650 -17.421  10.147  1.00  0.00
ATOM   1258  CG  HIS    79       5.266 -18.576  11.867  1.00  0.00
ATOM   1259  ND1 HIS    79       5.141 -19.954  11.901  1.00  0.00
ATOM   1260  HD1 HIS    79       4.729 -20.508  11.208  1.00  0.00
ATOM   1261  CD2 HIS    79       5.881 -18.238  13.023  1.00  0.00
ATOM   1262  HD2 HIS    79       6.149 -17.237  13.337  1.00  0.00
ATOM   1263  CE1 HIS    79       5.651 -20.417  13.021  1.00  0.00
ATOM   1264  HE1 HIS    79       5.647 -21.450  13.340  1.00  0.00
ATOM   1265  NE2 HIS    79       6.108 -19.397  13.721  1.00  0.00
ATOM   1266  HE2 HIS    79       6.411 -19.446  14.651  1.00  0.00
ATOM   1267  C   HIS    79       2.505 -18.858  10.529  1.00  0.00
ATOM   1268  O   HIS    79       1.921 -18.112  11.330  1.00  0.00
ATOM   1269  N   GLU    80       2.124 -20.108  10.258  1.00  0.00
ATOM   1270  HN  GLU    80       2.686 -20.635   9.644  1.00  0.00
ATOM   1271  CA  GLU    80       0.924 -20.760  10.804  1.00  0.00
ATOM   1272  HA  GLU    80       0.514 -20.115  11.578  1.00  0.00
ATOM   1273  CB  GLU    80      -0.175 -20.959   9.682  1.00  0.00
ATOM   1274  HB1 GLU    80      -0.900 -20.154   9.758  1.00  0.00
ATOM   1275  HB2 GLU    80      -0.700 -21.893   9.862  1.00  0.00
ATOM   1276  CG  GLU    80       0.335 -20.987   8.215  1.00  0.00
ATOM   1277  HG1 GLU    80       0.813 -20.034   8.008  1.00  0.00
ATOM   1278  HG2 GLU    80      -0.520 -21.089   7.549  1.00  0.00
ATOM   1279  CD  GLU    80       1.327 -22.123   7.905  1.00  0.00
ATOM   1280  OE1 GLU    80       0.900 -23.297   7.853  1.00  0.00
ATOM   1281  OE2 GLU    80       2.529 -21.843   7.704  1.00  0.00
ATOM   1282  C   GLU    80       1.303 -22.088  11.480  1.00  0.00
ATOM   1283  O   GLU    80       2.444 -22.541  11.390  1.00  0.00
ATOM   1284  N   THR    81       0.341 -22.666  12.209  1.00  0.00
ATOM   1285  HN  THR    81      -0.501 -22.191  12.319  1.00  0.00
ATOM   1286  CA  THR    81       0.474 -23.983  12.842  1.00  0.00
ATOM   1287  HA  THR    81       1.480 -24.371  12.650  1.00  0.00
ATOM   1288  CB  THR    81       0.261 -23.908  14.389  1.00  0.00
ATOM   1289  HB  THR    81      -0.787 -23.710  14.592  1.00  0.00
ATOM   1290  OG1 THR    81       1.039 -22.837  14.930  1.00  0.00
ATOM   1291  HG1 THR    81       1.976 -23.062  14.888  1.00  0.00
ATOM   1292  CG2 THR    81       0.660 -25.216  15.097  1.00  0.00
ATOM   1293 HG21 THR    81       0.482 -25.123  16.161  1.00  0.00
ATOM   1294 HG22 THR    81       1.711 -25.421  14.928  1.00  0.00
ATOM   1295 HG23 THR    81       0.070 -26.040  14.711  1.00  0.00
ATOM   1296  C   THR    81      -0.563 -24.926  12.218  1.00  0.00
ATOM   1297  O   THR    81      -1.772 -24.750  12.420  1.00  0.00
ATOM   1298  N   VAL    82      -0.083 -25.896  11.437  1.00  0.00
ATOM   1299  HN  VAL    82       0.879 -25.935  11.288  1.00  0.00
ATOM   1300  CA  VAL    82      -0.929 -26.888  10.775  1.00  0.00
ATOM   1301  HA  VAL    82      -1.840 -26.394  10.432  1.00  0.00
ATOM   1302  CB  VAL    82      -0.208 -27.516   9.527  1.00  0.00
ATOM   1303  HB  VAL    82       0.646 -28.088   9.892  1.00  0.00
ATOM   1304  CG1 VAL    82      -1.137 -28.498   8.783  1.00  0.00
ATOM   1305 HG11 VAL    82      -1.435 -29.296   9.457  1.00  0.00
ATOM   1306 HG12 VAL    82      -0.621 -28.927   7.934  1.00  0.00
ATOM   1307 HG13 VAL    82      -2.021 -27.976   8.438  1.00  0.00
ATOM   1308  CG2 VAL    82       0.337 -26.425   8.585  1.00  0.00
ATOM   1309 HG21 VAL    82       0.824 -26.885   7.735  1.00  0.00
ATOM   1310 HG22 VAL    82       1.059 -25.812   9.117  1.00  0.00
ATOM   1311 HG23 VAL    82      -0.475 -25.799   8.238  1.00  0.00
ATOM   1312  C   VAL    82      -1.296 -28.010  11.758  1.00  0.00
ATOM   1313  O   VAL    82      -0.461 -28.864  12.069  1.00  0.00
ATOM   1314  N   THR    83      -2.536 -27.975  12.262  1.00  0.00
ATOM   1315  HN  THR    83      -3.078 -27.181  12.119  1.00  0.00
ATOM   1316  CA  THR    83      -3.105 -29.082  13.035  1.00  0.00
ATOM   1317  HA  THR    83      -2.412 -29.323  13.839  1.00  0.00
ATOM   1318  CB  THR    83      -4.481 -28.685  13.668  1.00  0.00
ATOM   1319  HB  THR    83      -5.160 -28.404  12.867  1.00  0.00
ATOM   1320  OG1 THR    83      -4.309 -27.544  14.529  1.00  0.00
ATOM   1321  HG1 THR    83      -3.679 -26.932  14.133  1.00  0.00
ATOM   1322  CG2 THR    83      -5.123 -29.845  14.468  1.00  0.00
ATOM   1323 HG21 THR    83      -4.452 -30.164  15.257  1.00  0.00
ATOM   1324 HG22 THR    83      -5.319 -30.683  13.809  1.00  0.00
ATOM   1325 HG23 THR    83      -6.058 -29.516  14.906  1.00  0.00
ATOM   1326  C   THR    83      -3.273 -30.305  12.114  1.00  0.00
ATOM   1327  O   THR    83      -3.958 -30.228  11.087  1.00  0.00
ATOM   1328  N   ARG    84      -2.578 -31.394  12.467  1.00  0.00
ATOM   1329  HN  ARG    84      -1.972 -31.324  13.232  1.00  0.00
ATOM   1330  CA  ARG    84      -2.657 -32.694  11.781  1.00  0.00
ATOM   1331  HA  ARG    84      -3.432 -32.655  11.018  1.00  0.00
ATOM   1332  CB  ARG    84      -1.281 -33.031  11.121  1.00  0.00
ATOM   1333  HB1 ARG    84      -1.383 -33.960  10.565  1.00  0.00
ATOM   1334  HB2 ARG    84      -0.548 -33.183  11.909  1.00  0.00
ATOM   1335  CG  ARG    84      -0.732 -31.946  10.157  1.00  0.00
ATOM   1336  HG1 ARG    84      -0.660 -31.004  10.698  1.00  0.00
ATOM   1337  HG2 ARG    84      -1.423 -31.826   9.334  1.00  0.00
ATOM   1338  CD  ARG    84       0.658 -32.295   9.587  1.00  0.00
ATOM   1339  HD1 ARG    84       0.579 -33.224   9.033  1.00  0.00
ATOM   1340  HD2 ARG    84       1.346 -32.434  10.413  1.00  0.00
ATOM   1341  NE  ARG    84       1.205 -31.246   8.692  1.00  0.00
ATOM   1342  HE  ARG    84       0.848 -30.336   8.810  1.00  0.00
ATOM   1343  CZ  ARG    84       2.180 -31.435   7.775  1.00  0.00
ATOM   1344  NH1 ARG    84       2.668 -32.650   7.536  1.00  0.00
ATOM   1345 HH11 ARG    84       2.318 -33.441   8.044  1.00  0.00
ATOM   1346 HH12 ARG    84       3.395 -32.782   6.857  1.00  0.00
ATOM   1347  NH2 ARG    84       2.654 -30.397   7.089  1.00  0.00
ATOM   1348 HH21 ARG    84       2.292 -29.477   7.252  1.00  0.00
ATOM   1349 HH22 ARG    84       3.387 -30.528   6.414  1.00  0.00
ATOM   1350  C   ARG    84      -3.039 -33.762  12.825  1.00  0.00
ATOM   1351  O   ARG    84      -3.453 -33.417  13.938  1.00  0.00
ATOM   1352  N   ASN    85      -2.949 -35.050  12.453  1.00  0.00
ATOM   1353  HN  ASN    85      -2.807 -35.252  11.503  1.00  0.00
ATOM   1354  CA  ASN    85      -3.068 -36.183  13.401  1.00  0.00
ATOM   1355  HA  ASN    85      -3.227 -35.777  14.401  1.00  0.00
ATOM   1356  CB  ASN    85      -4.278 -37.105  13.042  1.00  0.00
ATOM   1357  HB1 ASN    85      -4.060 -38.119  13.370  1.00  0.00
ATOM   1358  HB2 ASN    85      -4.403 -37.118  11.968  1.00  0.00
ATOM   1359  CG  ASN    85      -5.617 -36.685  13.664  1.00  0.00
ATOM   1360  OD1 ASN    85      -6.453 -37.533  13.983  1.00  0.00
ATOM   1361  ND2 ASN    85      -5.859 -35.394  13.817  1.00  0.00
ATOM   1362 HD21 ASN    85      -5.182 -34.752  13.529  1.00  0.00
ATOM   1363 HD22 ASN    85      -6.711 -35.132  14.223  1.00  0.00
ATOM   1364  C   ASN    85      -1.755 -36.982  13.410  1.00  0.00
ATOM   1365  O   ASN    85      -1.404 -37.632  12.418  1.00  0.00
ATOM   1366  N   PHE    86      -1.007 -36.881  14.523  1.00  0.00
ATOM   1367  HN  PHE    86      -1.294 -36.250  15.215  1.00  0.00
ATOM   1368  CA  PHE    86       0.217 -37.682  14.766  1.00  0.00
ATOM   1369  HA  PHE    86       0.519 -38.136  13.820  1.00  0.00
ATOM   1370  CB  PHE    86       1.375 -36.779  15.290  1.00  0.00
ATOM   1371  HB1 PHE    86       2.135 -37.406  15.746  1.00  0.00
ATOM   1372  HB2 PHE    86       0.983 -36.113  16.047  1.00  0.00
ATOM   1373  CG  PHE    86       2.077 -35.904  14.242  1.00  0.00
ATOM   1374  CD1 PHE    86       3.156 -35.097  14.611  1.00  0.00
ATOM   1375  HD1 PHE    86       3.492 -35.097  15.642  1.00  0.00
ATOM   1376  CD2 PHE    86       1.674 -35.879  12.903  1.00  0.00
ATOM   1377  HD2 PHE    86       0.841 -36.492  12.584  1.00  0.00
ATOM   1378  CE1 PHE    86       3.798 -34.301  13.681  1.00  0.00
ATOM   1379  HE1 PHE    86       4.630 -33.680  13.983  1.00  0.00
ATOM   1380  CE2 PHE    86       2.321 -35.081  11.980  1.00  0.00
ATOM   1381  HE2 PHE    86       1.997 -35.076  10.951  1.00  0.00
ATOM   1382  CZ  PHE    86       3.381 -34.297  12.368  1.00  0.00
ATOM   1383  HZ  PHE    86       3.888 -33.670  11.641  1.00  0.00
ATOM   1384  C   PHE    86      -0.083 -38.813  15.772  1.00  0.00
ATOM   1385  O   PHE    86      -0.908 -38.631  16.671  1.00  0.00
ATOM   1386  N   PRO    87       0.586 -40.007  15.644  1.00  0.00
ATOM   1387  CA  PRO    87       0.304 -41.188  16.506  1.00  0.00
ATOM   1388  HA  PRO    87      -0.753 -41.430  16.487  1.00  0.00
ATOM   1389  CB  PRO    87       1.090 -42.324  15.810  1.00  0.00
ATOM   1390  HB1 PRO    87       0.450 -42.828  15.088  1.00  0.00
ATOM   1391  HB2 PRO    87       1.439 -43.050  16.538  1.00  0.00
ATOM   1392  CG  PRO    87       2.225 -41.625  15.135  1.00  0.00
ATOM   1393  HG1 PRO    87       2.594 -42.216  14.303  1.00  0.00
ATOM   1394  HG2 PRO    87       3.031 -41.449  15.847  1.00  0.00
ATOM   1395  CD  PRO    87       1.650 -40.316  14.643  1.00  0.00
ATOM   1396  HD1 PRO    87       1.221 -40.430  13.654  1.00  0.00
ATOM   1397  HD2 PRO    87       2.411 -39.543  14.634  1.00  0.00
ATOM   1398  C   PRO    87       0.735 -41.013  17.986  1.00  0.00
ATOM   1399  O   PRO    87       0.406 -41.861  18.826  1.00  0.00
ATOM   1400  N   GLU    88       1.487 -39.932  18.296  1.00  0.00
ATOM   1401  HN  GLU    88       1.811 -39.361  17.568  1.00  0.00
ATOM   1402  CA  GLU    88       1.846 -39.587  19.694  1.00  0.00
ATOM   1403  HA  GLU    88       1.801 -40.508  20.274  1.00  0.00
ATOM   1404  CB  GLU    88       3.298 -39.019  19.810  1.00  0.00
ATOM   1405  HB1 GLU    88       3.992 -39.824  19.590  1.00  0.00
ATOM   1406  HB2 GLU    88       3.468 -38.713  20.839  1.00  0.00
ATOM   1407  CG  GLU    88       3.637 -37.816  18.889  1.00  0.00
ATOM   1408  HG1 GLU    88       4.235 -37.099  19.455  1.00  0.00
ATOM   1409  HG2 GLU    88       2.711 -37.325  18.599  1.00  0.00
ATOM   1410  CD  GLU    88       4.401 -38.201  17.607  1.00  0.00
ATOM   1411  OE1 GLU    88       3.776 -38.731  16.671  1.00  0.00
ATOM   1412  OE2 GLU    88       5.635 -37.981  17.541  1.00  0.00
ATOM   1413  C   GLU    88       0.823 -38.610  20.322  1.00  0.00
ATOM   1414  O   GLU    88       0.815 -38.439  21.545  1.00  0.00
ATOM   1415  N   GLY    89      -0.036 -37.962  19.498  1.00  0.00
ATOM   1416  HN  GLY    89       0.070 -38.056  18.526  1.00  0.00
ATOM   1417  CA  GLY    89      -1.120 -37.115  20.036  1.00  0.00
ATOM   1418  HA1 GLY    89      -0.733 -36.528  20.864  1.00  0.00
ATOM   1419  HA2 GLY    89      -1.902 -37.760  20.417  1.00  0.00
ATOM   1420  C   GLY    89      -1.738 -36.173  19.008  1.00  0.00
ATOM   1421  O   GLY    89      -2.265 -36.634  17.995  1.00  0.00
ATOM   1422  N   LYS    90      -1.688 -34.849  19.296  1.00  0.00
ATOM   1423  HN  LYS    90      -1.292 -34.580  20.148  1.00  0.00
ATOM   1424  CA  LYS    90      -2.228 -33.784  18.429  1.00  0.00
ATOM   1425  HA  LYS    90      -3.308 -33.929  18.384  1.00  0.00
ATOM   1426  CB  LYS    90      -1.953 -32.399  19.091  1.00  0.00
ATOM   1427  HB1 LYS    90      -0.889 -32.329  19.303  1.00  0.00
ATOM   1428  HB2 LYS    90      -2.482 -32.361  20.036  1.00  0.00
ATOM   1429  CG  LYS    90      -2.358 -31.147  18.270  1.00  0.00
ATOM   1430  HG1 LYS    90      -1.761 -31.127  17.361  1.00  0.00
ATOM   1431  HG2 LYS    90      -2.120 -30.263  18.854  1.00  0.00
ATOM   1432  CD  LYS    90      -3.857 -31.081  17.883  1.00  0.00
ATOM   1433  HD1 LYS    90      -4.078 -31.901  17.205  1.00  0.00
ATOM   1434  HD2 LYS    90      -4.036 -30.146  17.364  1.00  0.00
ATOM   1435  CE  LYS    90      -4.812 -31.157  19.088  1.00  0.00
ATOM   1436  HE1 LYS    90      -4.460 -30.494  19.864  1.00  0.00
ATOM   1437  HE2 LYS    90      -4.825 -32.172  19.468  1.00  0.00
ATOM   1438  NZ  LYS    90      -6.199 -30.777  18.717  1.00  0.00
ATOM   1439  HZ1 LYS    90      -6.576 -31.434  18.006  1.00  0.00
ATOM   1440  HZ2 LYS    90      -6.210 -29.813  18.321  1.00  0.00
ATOM   1441  HZ3 LYS    90      -6.816 -30.796  19.553  1.00  0.00
ATOM   1442  C   LYS    90      -1.669 -33.871  16.986  1.00  0.00
ATOM   1443  O   LYS    90      -2.296 -34.497  16.132  1.00  0.00
ATOM   1444  N   GLY    91      -0.478 -33.289  16.736  1.00  0.00
ATOM   1445  HN  GLY    91       0.003 -32.854  17.467  1.00  0.00
ATOM   1446  CA  GLY    91       0.113 -33.291  15.396  1.00  0.00
ATOM   1447  HA1 GLY    91      -0.475 -33.914  14.730  1.00  0.00
ATOM   1448  HA2 GLY    91       1.103 -33.721  15.472  1.00  0.00
ATOM   1449  C   GLY    91       0.249 -31.907  14.791  1.00  0.00
ATOM   1450  O   GLY    91       0.259 -31.760  13.567  1.00  0.00
ATOM   1451  N   GLU    92       0.402 -30.891  15.643  1.00  0.00
ATOM   1452  HN  GLU    92       0.538 -31.090  16.594  1.00  0.00
ATOM   1453  CA  GLU    92       0.411 -29.488  15.201  1.00  0.00
ATOM   1454  HA  GLU    92      -0.198 -29.405  14.301  1.00  0.00
ATOM   1455  CB  GLU    92      -0.210 -28.587  16.309  1.00  0.00
ATOM   1456  HB1 GLU    92      -1.247 -28.882  16.459  1.00  0.00
ATOM   1457  HB2 GLU    92      -0.200 -27.559  15.966  1.00  0.00
ATOM   1458  CG  GLU    92       0.511 -28.654  17.679  1.00  0.00
ATOM   1459  HG1 GLU    92       1.559 -28.392  17.534  1.00  0.00
ATOM   1460  HG2 GLU    92       0.465 -29.680  18.035  1.00  0.00
ATOM   1461  CD  GLU    92      -0.076 -27.730  18.754  1.00  0.00
ATOM   1462  OE1 GLU    92      -0.596 -28.231  19.775  1.00  0.00
ATOM   1463  OE2 GLU    92       0.010 -26.494  18.591  1.00  0.00
ATOM   1464  C   GLU    92       1.855 -29.069  14.862  1.00  0.00
ATOM   1465  O   GLU    92       2.758 -29.163  15.701  1.00  0.00
ATOM   1466  N   VAL    93       2.091 -28.670  13.592  1.00  0.00
ATOM   1467  HN  VAL    93       1.333 -28.599  12.963  1.00  0.00
ATOM   1468  CA  VAL    93       3.437 -28.330  13.109  1.00  0.00
ATOM   1469  HA  VAL    93       4.136 -28.473  13.938  1.00  0.00
ATOM   1470  CB  VAL    93       3.893 -29.287  11.940  1.00  0.00
ATOM   1471  HB  VAL    93       4.913 -29.019  11.665  1.00  0.00
ATOM   1472  CG1 VAL    93       3.922 -30.751  12.432  1.00  0.00
ATOM   1473 HG11 VAL    93       2.920 -31.068  12.705  1.00  0.00
ATOM   1474 HG12 VAL    93       4.560 -30.833  13.302  1.00  0.00
ATOM   1475 HG13 VAL    93       4.300 -31.398  11.653  1.00  0.00
ATOM   1476  CG2 VAL    93       3.006 -29.154  10.680  1.00  0.00
ATOM   1477 HG21 VAL    93       1.980 -29.407  10.925  1.00  0.00
ATOM   1478 HG22 VAL    93       3.360 -29.821   9.903  1.00  0.00
ATOM   1479 HG23 VAL    93       3.042 -28.135  10.314  1.00  0.00
ATOM   1480  C   VAL    93       3.493 -26.853  12.707  1.00  0.00
ATOM   1481  O   VAL    93       2.693 -26.383  11.896  1.00  0.00
ATOM   1482  N   ASP    94       4.421 -26.119  13.325  1.00  0.00
ATOM   1483  HN  ASP    94       5.019 -26.570  13.963  1.00  0.00
ATOM   1484  CA  ASP    94       4.590 -24.676  13.099  1.00  0.00
ATOM   1485  HA  ASP    94       3.610 -24.233  12.925  1.00  0.00
ATOM   1486  CB  ASP    94       5.220 -24.007  14.345  1.00  0.00
ATOM   1487  HB1 ASP    94       5.388 -22.954  14.128  1.00  0.00
ATOM   1488  HB2 ASP    94       6.183 -24.469  14.550  1.00  0.00
ATOM   1489  CG  ASP    94       4.342 -24.122  15.607  1.00  0.00
ATOM   1490  OD1 ASP    94       4.199 -25.244  16.141  1.00  0.00
ATOM   1491  OD2 ASP    94       3.815 -23.093  16.083  1.00  0.00
ATOM   1492  C   ASP    94       5.467 -24.462  11.857  1.00  0.00
ATOM   1493  O   ASP    94       6.667 -24.705  11.899  1.00  0.00
ATOM   1494  N   VAL    95       4.844 -24.006  10.764  1.00  0.00
ATOM   1495  HN  VAL    95       3.900 -23.767  10.842  1.00  0.00
ATOM   1496  CA  VAL    95       5.474 -23.850   9.440  1.00  0.00
ATOM   1497  HA  VAL    95       6.475 -24.278   9.461  1.00  0.00
ATOM   1498  CB  VAL    95       4.616 -24.600   8.339  1.00  0.00
ATOM   1499  HB  VAL    95       3.704 -24.046   8.214  1.00  0.00
ATOM   1500  CG1 VAL    95       5.309 -24.625   6.956  1.00  0.00
ATOM   1501 HG11 VAL    95       5.489 -23.609   6.618  1.00  0.00
ATOM   1502 HG12 VAL    95       4.680 -25.130   6.235  1.00  0.00
ATOM   1503 HG13 VAL    95       6.254 -25.146   7.033  1.00  0.00
ATOM   1504  CG2 VAL    95       4.215 -26.020   8.799  1.00  0.00
ATOM   1505 HG21 VAL    95       3.629 -25.959   9.713  1.00  0.00
ATOM   1506 HG22 VAL    95       5.102 -26.609   8.986  1.00  0.00
ATOM   1507 HG23 VAL    95       3.621 -26.503   8.031  1.00  0.00
ATOM   1508  C   VAL    95       5.557 -22.353   9.085  1.00  0.00
ATOM   1509  O   VAL    95       4.736 -21.559   9.544  1.00  0.00
ATOM   1510  N   ALA    96       6.583 -21.973   8.314  1.00  0.00
ATOM   1511  HN  ALA    96       7.309 -22.602   8.168  1.00  0.00
ATOM   1512  CA  ALA    96       6.671 -20.654   7.672  1.00  0.00
ATOM   1513  HA  ALA    96       5.835 -20.037   8.010  1.00  0.00
ATOM   1514  CB  ALA    96       7.980 -19.942   8.058  1.00  0.00
ATOM   1515  HB1 ALA    96       8.015 -19.803   9.132  1.00  0.00
ATOM   1516  HB2 ALA    96       8.025 -18.974   7.577  1.00  0.00
ATOM   1517  HB3 ALA    96       8.833 -20.535   7.748  1.00  0.00
ATOM   1518  C   ALA    96       6.565 -20.844   6.153  1.00  0.00
ATOM   1519  O   ALA    96       7.519 -21.300   5.508  1.00  0.00
ATOM   1520  N   CYS    97       5.387 -20.537   5.597  1.00  0.00
ATOM   1521  HN  CYS    97       4.653 -20.258   6.180  1.00  0.00
ATOM   1522  CA  CYS    97       5.136 -20.600   4.158  1.00  0.00
ATOM   1523  HA  CYS    97       5.833 -21.314   3.713  1.00  0.00
ATOM   1524  CB  CYS    97       3.695 -21.078   3.890  1.00  0.00
ATOM   1525  HB1 CYS    97       3.517 -21.101   2.822  1.00  0.00
ATOM   1526  HB2 CYS    97       2.997 -20.395   4.352  1.00  0.00
ATOM   1527  SG  CYS    97       3.345 -22.732   4.533  1.00  0.00
ATOM   1528  HG  CYS    97       2.775 -22.594   5.722  1.00  0.00
ATOM   1529  C   CYS    97       5.387 -19.209   3.562  1.00  0.00
ATOM   1530  O   CYS    97       4.641 -18.262   3.822  1.00  0.00
ATOM   1531  N   ILE    98       6.480 -19.101   2.804  1.00  0.00
ATOM   1532  HN  ILE    98       7.002 -19.913   2.642  1.00  0.00
ATOM   1533  CA  ILE    98       6.934 -17.849   2.180  1.00  0.00
ATOM   1534  HA  ILE    98       6.455 -17.017   2.702  1.00  0.00
ATOM   1535  CB  ILE    98       8.501 -17.678   2.336  1.00  0.00
ATOM   1536  HB  ILE    98       8.687 -17.488   3.387  1.00  0.00
ATOM   1537  CG1 ILE    98       9.025 -16.440   1.527  1.00  0.00
ATOM   1538 HG11 ILE    98       8.550 -15.545   1.910  1.00  0.00
ATOM   1539 HG12 ILE    98       8.756 -16.554   0.485  1.00  0.00
ATOM   1540  CG2 ILE    98       9.270 -18.977   1.998  1.00  0.00
ATOM   1541 HG21 ILE    98      10.334 -18.829   2.137  1.00  0.00
ATOM   1542 HG22 ILE    98       9.081 -19.261   0.972  1.00  0.00
ATOM   1543 HG23 ILE    98       8.935 -19.778   2.650  1.00  0.00
ATOM   1544  CD1 ILE    98      10.530 -16.210   1.574  1.00  0.00
ATOM   1545 HD11 ILE    98      11.047 -17.061   1.148  1.00  0.00
ATOM   1546 HD12 ILE    98      10.849 -16.068   2.596  1.00  0.00
ATOM   1547 HD13 ILE    98      10.770 -15.325   1.000  1.00  0.00
ATOM   1548  C   ILE    98       6.500 -17.817   0.702  1.00  0.00
ATOM   1549  O   ILE    98       6.639 -18.801  -0.012  1.00  0.00
ATOM   1550  N   TYR    99       5.959 -16.675   0.255  1.00  0.00
ATOM   1551  HN  TYR    99       5.921 -15.917   0.861  1.00  0.00
ATOM   1552  CA  TYR    99       5.429 -16.498  -1.110  1.00  0.00
ATOM   1553  HA  TYR    99       5.624 -17.406  -1.680  1.00  0.00
ATOM   1554  CB  TYR    99       3.895 -16.233  -1.087  1.00  0.00
ATOM   1555  HB1 TYR    99       3.512 -16.290  -2.104  1.00  0.00
ATOM   1556  HB2 TYR    99       3.708 -15.233  -0.706  1.00  0.00
ATOM   1557  CG  TYR    99       3.089 -17.221  -0.227  1.00  0.00
ATOM   1558  CD1 TYR    99       2.606 -18.425  -0.749  1.00  0.00
ATOM   1559  HD1 TYR    99       2.793 -18.660  -1.787  1.00  0.00
ATOM   1560  CD2 TYR    99       2.826 -16.947   1.118  1.00  0.00
ATOM   1561  HD2 TYR    99       3.189 -16.020   1.550  1.00  0.00
ATOM   1562  CE1 TYR    99       1.893 -19.310   0.036  1.00  0.00
ATOM   1563  HE1 TYR    99       1.530 -20.238  -0.389  1.00  0.00
ATOM   1564  CE2 TYR    99       2.112 -17.830   1.902  1.00  0.00
ATOM   1565  HE2 TYR    99       1.922 -17.591   2.943  1.00  0.00
ATOM   1566  CZ  TYR    99       1.647 -19.007   1.361  1.00  0.00
ATOM   1567  OH  TYR    99       0.941 -19.891   2.150  1.00  0.00
ATOM   1568  HH  TYR    99       0.481 -19.401   2.843  1.00  0.00
ATOM   1569  C   TYR    99       6.133 -15.323  -1.793  1.00  0.00
ATOM   1570  O   TYR    99       6.636 -14.416  -1.131  1.00  0.00
ATOM   1571  N   GLU   100       6.140 -15.362  -3.120  1.00  0.00
ATOM   1572  HN  GLU   100       5.799 -16.168  -3.552  1.00  0.00
ATOM   1573  CA  GLU   100       6.635 -14.292  -3.986  1.00  0.00
ATOM   1574  HA  GLU   100       6.837 -13.403  -3.389  1.00  0.00
ATOM   1575  CB  GLU   100       7.924 -14.756  -4.689  1.00  0.00
ATOM   1576  HB1 GLU   100       7.710 -15.675  -5.228  1.00  0.00
ATOM   1577  HB2 GLU   100       8.666 -14.976  -3.929  1.00  0.00
ATOM   1578  CG  GLU   100       8.539 -13.747  -5.672  1.00  0.00
ATOM   1579  HG1 GLU   100       9.022 -12.957  -5.104  1.00  0.00
ATOM   1580  HG2 GLU   100       7.746 -13.305  -6.273  1.00  0.00
ATOM   1581  CD  GLU   100       9.573 -14.401  -6.605  1.00  0.00
ATOM   1582  OE1 GLU   100      10.791 -14.386  -6.294  1.00  0.00
ATOM   1583  OE2 GLU   100       9.166 -14.934  -7.661  1.00  0.00
ATOM   1584  C   GLU   100       5.548 -13.992  -5.020  1.00  0.00
ATOM   1585  O   GLU   100       5.161 -14.879  -5.779  1.00  0.00
ATOM   1586  N   VAL   101       5.052 -12.755  -5.023  1.00  0.00
ATOM   1587  HN  VAL   101       5.439 -12.110  -4.407  1.00  0.00
ATOM   1588  CA  VAL   101       3.972 -12.303  -5.902  1.00  0.00
ATOM   1589  HA  VAL   101       3.516 -13.172  -6.376  1.00  0.00
ATOM   1590  CB  VAL   101       2.862 -11.562  -5.069  1.00  0.00
ATOM   1591  HB  VAL   101       3.329 -10.703  -4.590  1.00  0.00
ATOM   1592  CG1 VAL   101       1.715 -11.036  -5.970  1.00  0.00
ATOM   1593 HG11 VAL   101       1.243 -11.864  -6.486  1.00  0.00
ATOM   1594 HG12 VAL   101       2.108 -10.340  -6.704  1.00  0.00
ATOM   1595 HG13 VAL   101       0.975 -10.526  -5.364  1.00  0.00
ATOM   1596  CG2 VAL   101       2.309 -12.478  -3.948  1.00  0.00
ATOM   1597 HG21 VAL   101       1.829 -13.343  -4.391  1.00  0.00
ATOM   1598 HG22 VAL   101       1.583 -11.934  -3.354  1.00  0.00
ATOM   1599 HG23 VAL   101       3.117 -12.808  -3.305  1.00  0.00
ATOM   1600  C   VAL   101       4.542 -11.376  -6.989  1.00  0.00
ATOM   1601  O   VAL   101       5.094 -10.313  -6.680  1.00  0.00
ATOM   1602  N   GLU   102       4.414 -11.797  -8.255  1.00  0.00
ATOM   1603  HN  GLU   102       4.015 -12.676  -8.413  1.00  0.00
ATOM   1604  CA  GLU   102       4.833 -11.014  -9.426  1.00  0.00
ATOM   1605  HA  GLU   102       5.103 -10.015  -9.088  1.00  0.00
ATOM   1606  CB  GLU   102       6.062 -11.670 -10.097  1.00  0.00
ATOM   1607  HB1 GLU   102       5.778 -12.660 -10.438  1.00  0.00
ATOM   1608  HB2 GLU   102       6.847 -11.774  -9.356  1.00  0.00
ATOM   1609  CG  GLU   102       6.631 -10.893 -11.295  1.00  0.00
ATOM   1610  HG1 GLU   102       6.831  -9.871 -10.984  1.00  0.00
ATOM   1611  HG2 GLU   102       5.880 -10.874 -12.075  1.00  0.00
ATOM   1612  CD  GLU   102       7.921 -11.503 -11.871  1.00  0.00
ATOM   1613  OE1 GLU   102       7.840 -12.466 -12.663  1.00  0.00
ATOM   1614  OE2 GLU   102       9.026 -11.036 -11.517  1.00  0.00
ATOM   1615  C   GLU   102       3.654 -10.904 -10.411  1.00  0.00
ATOM   1616  O   GLU   102       2.986 -11.901 -10.698  1.00  0.00
ATOM   1617  N   ASN   103       3.415  -9.671 -10.900  1.00  0.00
ATOM   1618  HN  ASN   103       4.039  -8.959 -10.649  1.00  0.00
ATOM   1619  CA  ASN   103       2.282  -9.312 -11.789  1.00  0.00
ATOM   1620  HA  ASN   103       2.366  -8.247 -11.968  1.00  0.00
ATOM   1621  CB  ASN   103       2.369 -10.049 -13.169  1.00  0.00
ATOM   1622  HB1 ASN   103       1.503  -9.781 -13.766  1.00  0.00
ATOM   1623  HB2 ASN   103       2.346 -11.118 -12.998  1.00  0.00
ATOM   1624  CG  ASN   103       3.638  -9.702 -13.971  1.00  0.00
ATOM   1625  OD1 ASN   103       3.676  -8.714 -14.704  1.00  0.00
ATOM   1626  ND2 ASN   103       4.669 -10.528 -13.866  1.00  0.00
ATOM   1627 HD21 ASN   103       4.576 -11.319 -13.290  1.00  0.00
ATOM   1628 HD22 ASN   103       5.485 -10.318 -14.365  1.00  0.00
ATOM   1629  C   ASN   103       0.907  -9.560 -11.102  1.00  0.00
ATOM   1630  O   ASN   103      -0.110  -9.771 -11.776  1.00  0.00
ATOM   1631  N   GLY   104       0.884  -9.459  -9.754  1.00  0.00
ATOM   1632  HN  GLY   104       1.727  -9.269  -9.290  1.00  0.00
ATOM   1633  CA  GLY   104      -0.350  -9.611  -8.961  1.00  0.00
ATOM   1634  HA1 GLY   104      -1.184  -9.203  -9.520  1.00  0.00
ATOM   1635  HA2 GLY   104      -0.237  -9.035  -8.053  1.00  0.00
ATOM   1636  C   GLY   104      -0.682 -11.057  -8.573  1.00  0.00
ATOM   1637  O   GLY   104      -1.597 -11.294  -7.775  1.00  0.00
ATOM   1638  N   ARG   105       0.078 -12.022  -9.117  1.00  0.00
ATOM   1639  HN  ARG   105       0.847 -11.758  -9.666  1.00  0.00
ATOM   1640  CA  ARG   105      -0.132 -13.466  -8.876  1.00  0.00
ATOM   1641  HA  ARG   105      -0.949 -13.597  -8.168  1.00  0.00
ATOM   1642  CB  ARG   105      -0.469 -14.204 -10.201  1.00  0.00
ATOM   1643  HB1 ARG   105      -0.617 -15.260  -9.986  1.00  0.00
ATOM   1644  HB2 ARG   105       0.373 -14.106 -10.876  1.00  0.00
ATOM   1645  CG  ARG   105      -1.723 -13.684 -10.940  1.00  0.00
ATOM   1646  HG1 ARG   105      -1.778 -14.170 -11.911  1.00  0.00
ATOM   1647  HG2 ARG   105      -1.617 -12.616 -11.093  1.00  0.00
ATOM   1648  CD  ARG   105      -3.043 -13.942 -10.190  1.00  0.00
ATOM   1649  HD1 ARG   105      -2.951 -13.596  -9.168  1.00  0.00
ATOM   1650  HD2 ARG   105      -3.248 -15.009 -10.193  1.00  0.00
ATOM   1651  NE  ARG   105      -4.156 -13.215 -10.838  1.00  0.00
ATOM   1652  HE  ARG   105      -3.928 -12.348 -11.233  1.00  0.00
ATOM   1653  CZ  ARG   105      -5.432 -13.615 -10.931  1.00  0.00
ATOM   1654  NH1 ARG   105      -5.830 -14.779 -10.457  1.00  0.00
ATOM   1655 HH11 ARG   105      -5.176 -15.394 -10.017  1.00  0.00
ATOM   1656 HH12 ARG   105      -6.792 -15.061 -10.546  1.00  0.00
ATOM   1657  NH2 ARG   105      -6.311 -12.827 -11.526  1.00  0.00
ATOM   1658 HH21 ARG   105      -6.021 -11.944 -11.902  1.00  0.00
ATOM   1659 HH22 ARG   105      -7.269 -13.112 -11.617  1.00  0.00
ATOM   1660  C   ARG   105       1.146 -14.039  -8.272  1.00  0.00
ATOM   1661  O   ARG   105       2.232 -13.543  -8.565  1.00  0.00
ATOM   1662  N   ILE   106       1.022 -15.070  -7.430  1.00  0.00
ATOM   1663  HN  ILE   106       0.127 -15.399  -7.216  1.00  0.00
ATOM   1664  CA  ILE   106       2.186 -15.718  -6.820  1.00  0.00
ATOM   1665  HA  ILE   106       2.800 -14.933  -6.371  1.00  0.00
ATOM   1666  CB  ILE   106       1.775 -16.720  -5.683  1.00  0.00
ATOM   1667  HB  ILE   106       1.107 -17.458  -6.117  1.00  0.00
ATOM   1668  CG1 ILE   106       1.012 -15.962  -4.557  1.00  0.00
ATOM   1669 HG11 ILE   106       0.097 -15.544  -4.965  1.00  0.00
ATOM   1670 HG12 ILE   106       1.631 -15.156  -4.189  1.00  0.00
ATOM   1671  CG2 ILE   106       3.001 -17.477  -5.105  1.00  0.00
ATOM   1672 HG21 ILE   106       3.696 -16.769  -4.671  1.00  0.00
ATOM   1673 HG22 ILE   106       3.498 -18.025  -5.896  1.00  0.00
ATOM   1674 HG23 ILE   106       2.677 -18.174  -4.342  1.00  0.00
ATOM   1675  CD1 ILE   106       0.637 -16.813  -3.369  1.00  0.00
ATOM   1676 HD11 ILE   106       0.046 -17.658  -3.701  1.00  0.00
ATOM   1677 HD12 ILE   106       0.058 -16.222  -2.674  1.00  0.00
ATOM   1678 HD13 ILE   106       1.531 -17.170  -2.877  1.00  0.00
ATOM   1679  C   ILE   106       3.015 -16.423  -7.904  1.00  0.00
ATOM   1680  O   ILE   106       2.582 -17.414  -8.479  1.00  0.00
ATOM   1681  N   ALA   107       4.199 -15.862  -8.177  1.00  0.00
ATOM   1682  HN  ALA   107       4.455 -15.062  -7.676  1.00  0.00
ATOM   1683  CA  ALA   107       5.130 -16.371  -9.187  1.00  0.00
ATOM   1684  HA  ALA   107       4.568 -16.617 -10.084  1.00  0.00
ATOM   1685  CB  ALA   107       6.154 -15.279  -9.543  1.00  0.00
ATOM   1686  HB1 ALA   107       5.640 -14.397  -9.917  1.00  0.00
ATOM   1687  HB2 ALA   107       6.832 -15.640 -10.305  1.00  0.00
ATOM   1688  HB3 ALA   107       6.723 -15.006  -8.660  1.00  0.00
ATOM   1689  C   ALA   107       5.851 -17.624  -8.674  1.00  0.00
ATOM   1690  O   ALA   107       6.074 -18.580  -9.430  1.00  0.00
ATOM   1691  N   LYS   108       6.194 -17.607  -7.375  1.00  0.00
ATOM   1692  HN  LYS   108       5.915 -16.832  -6.831  1.00  0.00
ATOM   1693  CA  LYS   108       6.942 -18.685  -6.701  1.00  0.00
ATOM   1694  HA  LYS   108       6.708 -19.631  -7.187  1.00  0.00
ATOM   1695  CB  LYS   108       8.472 -18.426  -6.773  1.00  0.00
ATOM   1696  HB1 LYS   108       8.980 -19.140  -6.128  1.00  0.00
ATOM   1697  HB2 LYS   108       8.670 -17.427  -6.397  1.00  0.00
ATOM   1698  CG  LYS   108       9.079 -18.538  -8.184  1.00  0.00
ATOM   1699  HG1 LYS   108       8.475 -17.946  -8.865  1.00  0.00
ATOM   1700  HG2 LYS   108       9.045 -19.574  -8.498  1.00  0.00
ATOM   1701  CD  LYS   108      10.537 -18.048  -8.262  1.00  0.00
ATOM   1702  HD1 LYS   108      11.166 -18.699  -7.662  1.00  0.00
ATOM   1703  HD2 LYS   108      10.592 -17.037  -7.867  1.00  0.00
ATOM   1704  CE  LYS   108      11.059 -18.041  -9.707  1.00  0.00
ATOM   1705  HE1 LYS   108      10.418 -17.410 -10.314  1.00  0.00
ATOM   1706  HE2 LYS   108      11.037 -19.050 -10.101  1.00  0.00
ATOM   1707  NZ  LYS   108      12.447 -17.533  -9.804  1.00  0.00
ATOM   1708  HZ1 LYS   108      12.491 -16.547  -9.472  1.00  0.00
ATOM   1709  HZ2 LYS   108      12.773 -17.570 -10.790  1.00  0.00
ATOM   1710  HZ3 LYS   108      13.078 -18.110  -9.219  1.00  0.00
ATOM   1711  C   LYS   108       6.513 -18.750  -5.239  1.00  0.00
ATOM   1712  O   LYS   108       6.220 -17.721  -4.642  1.00  0.00
ATOM   1713  N   ALA   109       6.502 -19.953  -4.665  1.00  0.00
ATOM   1714  HN  ALA   109       6.737 -20.734  -5.208  1.00  0.00
ATOM   1715  CA  ALA   109       6.172 -20.164  -3.255  1.00  0.00
ATOM   1716  HA  ALA   109       6.435 -19.255  -2.705  1.00  0.00
ATOM   1717  CB  ALA   109       4.675 -20.420  -3.061  1.00  0.00
ATOM   1718  HB1 ALA   109       4.110 -19.584  -3.452  1.00  0.00
ATOM   1719  HB2 ALA   109       4.451 -20.530  -2.004  1.00  0.00
ATOM   1720  HB3 ALA   109       4.380 -21.325  -3.582  1.00  0.00
ATOM   1721  C   ALA   109       6.998 -21.320  -2.707  1.00  0.00
ATOM   1722  O   ALA   109       7.227 -22.318  -3.385  1.00  0.00
ATOM   1723  N   TRP   110       7.465 -21.142  -1.486  1.00  0.00
ATOM   1724  HN  TRP   110       7.229 -20.320  -1.027  1.00  0.00
ATOM   1725  CA  TRP   110       8.314 -22.088  -0.766  1.00  0.00
ATOM   1726  HA  TRP   110       8.312 -23.046  -1.280  1.00  0.00
ATOM   1727  CB  TRP   110       9.773 -21.523  -0.680  1.00  0.00
ATOM   1728  HB1 TRP   110      10.456 -22.341  -0.472  1.00  0.00
ATOM   1729  HB2 TRP   110       9.837 -20.806   0.130  1.00  0.00
ATOM   1730  CG  TRP   110      10.254 -20.819  -1.942  1.00  0.00
ATOM   1731  CD1 TRP   110      10.829 -21.392  -3.027  1.00  0.00
ATOM   1732  HD1 TRP   110      11.029 -22.441  -3.116  1.00  0.00
ATOM   1733  CD2 TRP   110      10.173 -19.414  -2.249  1.00  0.00
ATOM   1734  NE1 TRP   110      11.114 -20.458  -3.978  1.00  0.00
ATOM   1735  HE1 TRP   110      11.535 -20.638  -4.845  1.00  0.00
ATOM   1736  CE2 TRP   110      10.722 -19.236  -3.527  1.00  0.00
ATOM   1737  CE3 TRP   110       9.684 -18.298  -1.572  1.00  0.00
ATOM   1738  HE3 TRP   110       9.250 -18.392  -0.588  1.00  0.00
ATOM   1739  CZ2 TRP   110      10.812 -17.991  -4.134  1.00  0.00
ATOM   1740  HZ2 TRP   110      11.239 -17.864  -5.121  1.00  0.00
ATOM   1741  CZ3 TRP   110       9.770 -17.060  -2.173  1.00  0.00
ATOM   1742  HZ3 TRP   110       9.399 -16.182  -1.657  1.00  0.00
ATOM   1743  CH2 TRP   110      10.328 -16.917  -3.446  1.00  0.00
ATOM   1744  HH2 TRP   110      10.376 -15.926  -3.883  1.00  0.00
ATOM   1745  C   TRP   110       7.708 -22.259   0.635  1.00  0.00
ATOM   1746  O   TRP   110       6.983 -21.371   1.105  1.00  0.00
ATOM   1747  N   PHE   111       7.969 -23.381   1.302  1.00  0.00
ATOM   1748  HN  PHE   111       8.426 -24.118   0.848  1.00  0.00
ATOM   1749  CA  PHE   111       7.574 -23.541   2.713  1.00  0.00
ATOM   1750  HA  PHE   111       7.517 -22.541   3.155  1.00  0.00
ATOM   1751  CB  PHE   111       6.172 -24.216   2.858  1.00  0.00
ATOM   1752  HB1 PHE   111       5.495 -23.767   2.137  1.00  0.00
ATOM   1753  HB2 PHE   111       5.784 -24.007   3.851  1.00  0.00
ATOM   1754  CG  PHE   111       6.127 -25.733   2.651  1.00  0.00
ATOM   1755  CD1 PHE   111       6.113 -26.601   3.748  1.00  0.00
ATOM   1756  HD1 PHE   111       6.134 -26.191   4.750  1.00  0.00
ATOM   1757  CD2 PHE   111       6.102 -26.292   1.375  1.00  0.00
ATOM   1758  HD2 PHE   111       6.113 -25.645   0.507  1.00  0.00
ATOM   1759  CE1 PHE   111       6.072 -27.967   3.576  1.00  0.00
ATOM   1760  HE1 PHE   111       6.066 -28.618   4.446  1.00  0.00
ATOM   1761  CE2 PHE   111       6.058 -27.666   1.203  1.00  0.00
ATOM   1762  HE2 PHE   111       6.036 -28.085   0.203  1.00  0.00
ATOM   1763  CZ  PHE   111       6.044 -28.503   2.302  1.00  0.00
ATOM   1764  HZ  PHE   111       6.010 -29.578   2.166  1.00  0.00
ATOM   1765  C   PHE   111       8.658 -24.311   3.463  1.00  0.00
ATOM   1766  O   PHE   111       9.311 -25.203   2.897  1.00  0.00
ATOM   1767  N   LYS   112       8.853 -23.944   4.733  1.00  0.00
ATOM   1768  HN  LYS   112       8.345 -23.179   5.081  1.00  0.00
ATOM   1769  CA  LYS   112       9.775 -24.624   5.639  1.00  0.00
ATOM   1770  HA  LYS   112      10.080 -25.557   5.172  1.00  0.00
ATOM   1771  CB  LYS   112      11.048 -23.763   5.904  1.00  0.00
ATOM   1772  HB1 LYS   112      11.567 -23.625   4.959  1.00  0.00
ATOM   1773  HB2 LYS   112      11.705 -24.320   6.568  1.00  0.00
ATOM   1774  CG  LYS   112      10.812 -22.366   6.527  1.00  0.00
ATOM   1775  HG1 LYS   112      10.194 -22.481   7.412  1.00  0.00
ATOM   1776  HG2 LYS   112      10.289 -21.745   5.807  1.00  0.00
ATOM   1777  CD  LYS   112      12.137 -21.673   6.926  1.00  0.00
ATOM   1778  HD1 LYS   112      12.744 -21.538   6.035  1.00  0.00
ATOM   1779  HD2 LYS   112      12.672 -22.314   7.619  1.00  0.00
ATOM   1780  CE  LYS   112      11.934 -20.306   7.597  1.00  0.00
ATOM   1781  HE1 LYS   112      11.281 -20.419   8.454  1.00  0.00
ATOM   1782  HE2 LYS   112      11.476 -19.624   6.889  1.00  0.00
ATOM   1783  NZ  LYS   112      13.224 -19.721   8.052  1.00  0.00
ATOM   1784  HZ1 LYS   112      13.667 -20.339   8.762  1.00  0.00
ATOM   1785  HZ2 LYS   112      13.065 -18.784   8.468  1.00  0.00
ATOM   1786  HZ3 LYS   112      13.871 -19.623   7.246  1.00  0.00
ATOM   1787  C   LYS   112       9.041 -24.961   6.939  1.00  0.00
ATOM   1788  O   LYS   112       8.473 -24.080   7.585  1.00  0.00
ATOM   1789  N   ILE   113       9.040 -26.250   7.322  1.00  0.00
ATOM   1790  HN  ILE   113       9.508 -26.906   6.774  1.00  0.00
ATOM   1791  CA  ILE   113       8.370 -26.703   8.547  1.00  0.00
ATOM   1792  HA  ILE   113       7.521 -26.041   8.731  1.00  0.00
ATOM   1793  CB  ILE   113       7.816 -28.165   8.418  1.00  0.00
ATOM   1794  HB  ILE   113       8.638 -28.807   8.123  1.00  0.00
ATOM   1795  CG1 ILE   113       6.712 -28.224   7.318  1.00  0.00
ATOM   1796 HG11 ILE   113       7.049 -27.713   6.424  1.00  0.00
ATOM   1797 HG12 ILE   113       5.829 -27.716   7.680  1.00  0.00
ATOM   1798  CG2 ILE   113       7.259 -28.692   9.777  1.00  0.00
ATOM   1799 HG21 ILE   113       6.885 -29.702   9.653  1.00  0.00
ATOM   1800 HG22 ILE   113       6.450 -28.056  10.113  1.00  0.00
ATOM   1801 HG23 ILE   113       8.045 -28.690  10.523  1.00  0.00
ATOM   1802  CD1 ILE   113       6.289 -29.624   6.937  1.00  0.00
ATOM   1803 HD11 ILE   113       7.147 -30.184   6.587  1.00  0.00
ATOM   1804 HD12 ILE   113       5.550 -29.574   6.153  1.00  0.00
ATOM   1805 HD13 ILE   113       5.865 -30.117   7.799  1.00  0.00
ATOM   1806  C   ILE   113       9.363 -26.597   9.707  1.00  0.00
ATOM   1807  O   ILE   113      10.473 -27.147   9.642  1.00  0.00
ATOM   1808  N   GLY   114       8.949 -25.855  10.735  1.00  0.00
ATOM   1809  HN  GLY   114       8.035 -25.487  10.695  1.00  0.00
ATOM   1810  CA  GLY   114       9.788 -25.579  11.902  1.00  0.00
ATOM   1811  HA1 GLY   114       9.270 -24.872  12.536  1.00  0.00
ATOM   1812  HA2 GLY   114      10.716 -25.124  11.570  1.00  0.00
ATOM   1813  C   GLY   114      10.096 -26.827  12.718  1.00  0.00
ATOM   1814  O   GLY   114      11.252 -27.278  12.764  1.00  0.00
ATOM   1815  N   GLU   115       9.053 -27.397  13.343  1.00  0.00
ATOM   1816  HN  GLU   115       8.162 -26.994  13.241  1.00  0.00
ATOM   1817  CA  GLU   115       9.172 -28.619  14.151  1.00  0.00
ATOM   1818  HA  GLU   115       9.852 -29.295  13.644  1.00  0.00
ATOM   1819  CB  GLU   115       9.728 -28.287  15.575  1.00  0.00
ATOM   1820  HB1 GLU   115      10.550 -27.585  15.476  1.00  0.00
ATOM   1821  HB2 GLU   115      10.109 -29.202  16.018  1.00  0.00
ATOM   1822  CG  GLU   115       8.686 -27.683  16.540  1.00  0.00
ATOM   1823  HG1 GLU   115       7.840 -28.377  16.594  1.00  0.00
ATOM   1824  HG2 GLU   115       8.331 -26.745  16.126  1.00  0.00
ATOM   1825  CD  GLU   115       9.222 -27.446  17.960  1.00  0.00
ATOM   1826  OE1 GLU   115       9.196 -28.387  18.779  1.00  0.00
ATOM   1827  OE2 GLU   115       9.645 -26.314  18.276  1.00  0.00
ATOM   1828  C   GLU   115       7.789 -29.299  14.272  1.00  0.00
ATOM   1829  O   GLU   115       6.761 -28.666  13.976  1.00  0.00
ATOM   1830  N   PRO   116       7.741 -30.602  14.687  1.00  0.00
ATOM   1831  CA  PRO   116       6.494 -31.239  15.173  1.00  0.00
ATOM   1832  HA  PRO   116       5.641 -30.943  14.576  1.00  0.00
ATOM   1833  CB  PRO   116       6.790 -32.733  14.950  1.00  0.00
ATOM   1834  HB1 PRO   116       6.506 -32.996  13.942  1.00  0.00
ATOM   1835  HB2 PRO   116       6.227 -33.346  15.649  1.00  0.00
ATOM   1836  CG  PRO   116       8.272 -32.873  15.146  1.00  0.00
ATOM   1837  HG1 PRO   116       8.648 -33.718  14.577  1.00  0.00
ATOM   1838  HG2 PRO   116       8.494 -33.012  16.201  1.00  0.00
ATOM   1839  CD  PRO   116       8.876 -31.579  14.638  1.00  0.00
ATOM   1840  HD1 PRO   116       9.233 -31.695  13.621  1.00  0.00
ATOM   1841  HD2 PRO   116       9.687 -31.253  15.282  1.00  0.00
ATOM   1842  C   PRO   116       6.206 -30.918  16.661  1.00  0.00
ATOM   1843  O   PRO   116       7.129 -30.919  17.488  1.00  0.00
ATOM   1844  N   ARG   117       4.924 -30.616  16.993  1.00  0.00
ATOM   1845  HN  ARG   117       4.262 -30.532  16.275  1.00  0.00
ATOM   1846  CA  ARG   117       4.478 -30.391  18.393  1.00  0.00
ATOM   1847  HA  ARG   117       5.260 -30.770  19.040  1.00  0.00
ATOM   1848  CB  ARG   117       4.276 -28.879  18.700  1.00  0.00
ATOM   1849  HB1 ARG   117       3.834 -28.780  19.688  1.00  0.00
ATOM   1850  HB2 ARG   117       3.586 -28.466  17.969  1.00  0.00
ATOM   1851  CG  ARG   117       5.565 -28.041  18.664  1.00  0.00
ATOM   1852  HG1 ARG   117       5.961 -28.057  17.652  1.00  0.00
ATOM   1853  HG2 ARG   117       6.297 -28.484  19.334  1.00  0.00
ATOM   1854  CD  ARG   117       5.337 -26.586  19.081  1.00  0.00
ATOM   1855  HD1 ARG   117       4.955 -26.564  20.096  1.00  0.00
ATOM   1856  HD2 ARG   117       4.603 -26.141  18.414  1.00  0.00
ATOM   1857  NE  ARG   117       6.581 -25.804  19.027  1.00  0.00
ATOM   1858  HE  ARG   117       7.418 -26.293  19.188  1.00  0.00
ATOM   1859  CZ  ARG   117       6.657 -24.493  18.783  1.00  0.00
ATOM   1860  NH1 ARG   117       5.561 -23.791  18.512  1.00  0.00
ATOM   1861 HH11 ARG   117       4.663 -24.247  18.479  1.00  0.00
ATOM   1862 HH12 ARG   117       5.617 -22.807  18.348  1.00  0.00
ATOM   1863  NH2 ARG   117       7.837 -23.897  18.772  1.00  0.00
ATOM   1864 HH21 ARG   117       8.673 -24.434  18.945  1.00  0.00
ATOM   1865 HH22 ARG   117       7.911 -22.914  18.593  1.00  0.00
ATOM   1866  C   ARG   117       3.185 -31.163  18.716  1.00  0.00
ATOM   1867  O   ARG   117       2.409 -31.535  17.826  1.00  0.00
ATOM   1868  N   ILE   118       2.974 -31.375  20.032  1.00  0.00
ATOM   1869  HN  ILE   118       3.617 -30.990  20.664  1.00  0.00
ATOM   1870  CA  ILE   118       1.835 -32.123  20.603  1.00  0.00
ATOM   1871  HA  ILE   118       1.035 -32.176  19.864  1.00  0.00
ATOM   1872  CB  ILE   118       2.265 -33.596  21.008  1.00  0.00
ATOM   1873  HB  ILE   118       3.094 -33.515  21.708  1.00  0.00
ATOM   1874  CG1 ILE   118       2.754 -34.407  19.770  1.00  0.00
ATOM   1875 HG11 ILE   118       3.130 -35.368  20.099  1.00  0.00
ATOM   1876 HG12 ILE   118       3.559 -33.868  19.289  1.00  0.00
ATOM   1877  CG2 ILE   118       1.130 -34.358  21.729  1.00  0.00
ATOM   1878 HG21 ILE   118       0.866 -33.840  22.644  1.00  0.00
ATOM   1879 HG22 ILE   118       1.449 -35.363  21.972  1.00  0.00
ATOM   1880 HG23 ILE   118       0.255 -34.405  21.084  1.00  0.00
ATOM   1881  CD1 ILE   118       1.695 -34.665  18.720  1.00  0.00
ATOM   1882 HD11 ILE   118       0.912 -35.278  19.142  1.00  0.00
ATOM   1883 HD12 ILE   118       2.138 -35.173  17.878  1.00  0.00
ATOM   1884 HD13 ILE   118       1.271 -33.722  18.393  1.00  0.00
ATOM   1885  C   ILE   118       1.334 -31.368  21.850  1.00  0.00
ATOM   1886  O   ILE   118       2.152 -30.899  22.641  1.00  0.00
END
