
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  133 ( 1065),  selected  133 , name 2gex_B
# Molecule2: number of CA atoms  117 ( 1867),  selected  117 , name T0475.pdb
# PARAMETERS: 2gex_B.T0475.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     2_B      -       -           -
LGA    T     3_B      N       2          1.524
LGA    T     4_B      S       3          2.798
LGA    A     5_B      E       4          3.071
LGA    N     6_B      I       5          1.462
LGA    K     7_B      E       6          1.985
LGA    E     8_B      L       7          3.184
LGA    R     9_B      P       8          2.199
LGA    C    10_B      V       9          0.882
LGA    L    11_B      Q      10          1.253
LGA    E    12_B      K      11          0.551
LGA    X    13_B      Q      12          0.296
LGA    V    14_B      L      13          0.830
LGA    A    15_B      E      14          0.881
LGA    A    16_B      A      15          0.670
LGA    W    17_B      Y      16          0.869
LGA    N    18_B      N      17          1.402
LGA    R    19_B      A      18          1.483
LGA    W    20_B      R      19          1.601
LGA    D    21_B      D      20          2.378
LGA    V    22_B      I      21          2.574
LGA    S    23_B      D      22          3.205
LGA    G    24_B      A      23          2.441
LGA    V    25_B      F      24          0.850
LGA    V    26_B      M      25          1.373
LGA    A    27_B      A      26          1.520
LGA    H    28_B      W      27          1.453
LGA    W    29_B      W      28          1.049
LGA    A    30_B      A      29          0.722
LGA    P    31_B      D      30          1.444
LGA    D    32_B      D      31          1.492
LGA    V    33_B      C      32          0.749
LGA    V    34_B      Q      33          1.349
LGA    H    35_B      Y      34          1.525
LGA    Y    36_B      Y      35          2.097
LGA    D    37_B      A      36          2.723
LGA    D    38_B      F      37          2.877
LGA    E    39_B      P      38          4.318
LGA    D    40_B      A      39          2.952
LGA    K    41_B      T      40          3.784
LGA    P    42_B      L      41          2.583
LGA    V    43_B      L      42          2.459
LGA    S    44_B      A      43          2.137
LGA    A    45_B      G      44          5.328
LGA    -       -      N      45           -
LGA    -       -      A      46           -
LGA    E    46_B      A      47           #
LGA    E    47_B      E      48           #
LGA    V    48_B      I      49          3.786
LGA    V    49_B      R      50          3.472
LGA    R    50_B      V      51          3.869
LGA    R    51_B      R      52          3.181
LGA    X    52_B      H      53          1.515
LGA    N    53_B      I      54          2.127
LGA    S    54_B      E      55          2.328
LGA    A    55_B      R      56          1.807
LGA    V    56_B      F      57          1.583
LGA    E    57_B      K      58          1.202
LGA    A    58_B      E      59          2.667
LGA    F    59_B      -       -           -
LGA    P    60_B      P      60          0.810
LGA    D    61_B      D      61          3.348
LGA    L    62_B      L      62          2.160
LGA    R    63_B      Y      63          1.925
LGA    L    64_B      G      64          1.527
LGA    D    65_B      E      65          2.025
LGA    V    66_B      L      66          1.853
LGA    R    67_B      L      67          1.459
LGA    S    68_B      T      68          1.552
LGA    I    69_B      R      69          1.272
LGA    V    70_B      V      70          1.238
LGA    G    71_B      I      71          1.167
LGA    E    72_B      V      72          1.674
LGA    G    73_B      G      73          1.559
LGA    D    74_B      N      74          0.844
LGA    R    75_B      V      75          0.889
LGA    V    76_B      V      76          0.946
LGA    X    77_B      I      77          1.003
LGA    L    78_B      D      78          1.730
LGA    R    79_B      H      79          1.211
LGA    I    80_B      E      80          0.789
LGA    T    81_B      T      81          1.511
LGA    C    82_B      V      82          2.169
LGA    S    83_B      T      83          2.146
LGA    A    84_B      R      84          4.393
LGA    T    85_B      -       -           -
LGA    H    86_B      N      85          2.575
LGA    Q    87_B      -       -           -
LGA    G    88_B      -       -           -
LGA    V    89_B      -       -           -
LGA    F    90_B      -       -           -
LGA    X    91_B      -       -           -
LGA    G    92_B      -       -           -
LGA    I    93_B      -       -           -
LGA    A    94_B      -       -           -
LGA    P    95_B      F      86           #
LGA    T    96_B      P      87          4.800
LGA    G    97_B      E      88           -
LGA    R    98_B      G      89          4.491
LGA    K    99_B      K      90          2.982
LGA    V   100_B      G      91          2.468
LGA    R   101_B      E      92          1.047
LGA    W   102_B      V      93          1.266
LGA    T   103_B      D      94          0.705
LGA    Y   104_B      V      95          0.715
LGA    L   105_B      A      96          0.656
LGA    E   106_B      C      97          1.104
LGA    E   107_B      I      98          0.665
LGA    L   108_B      Y      99          0.735
LGA    R   109_B      E     100          0.695
LGA    F   110_B      V     101          0.444
LGA    S   111_B      E     102          1.300
LGA    E   112_B      N     103          3.043
LGA    A   113_B      G     104          2.284
LGA    G   114_B      -       -           -
LGA    K   115_B      R     105          0.753
LGA    V   116_B      I     106          0.365
LGA    V   117_B      A     107          0.290
LGA    E   118_B      K     108          0.688
LGA    H   119_B      A     109          0.548
LGA    W   120_B      W     110          1.533
LGA    D   121_B      F     111          3.188
LGA    V   122_B      -       -           -
LGA    F   123_B      -       -           -
LGA    N   124_B      K     112          4.042
LGA    F   125_B      I     113           #
LGA    S   126_B      G     114           -
LGA    P   127_B      E     115           #
LGA    L   128_B      -       -           -
LGA    F   129_B      -       -           -
LGA    R   130_B      P     116          5.532
LGA    D   131_B      R     117          5.270
LGA    L   132_B      I     118           #
LGA    G   133_B      -       -           -
LGA    V   134_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  133  117    5.0    107    2.26    16.82     70.796     4.540

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.617245 * X  +   0.009108 * Y  +  -0.786718 * Z  +  52.289577
  Y_new =  -0.580519 * X  +  -0.680192 * Y  +   0.447590 * Z  +  14.795791
  Z_new =  -0.531043 * X  +   0.732977 * Y  +   0.425133 * Z  +   6.584932 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.045206   -2.096386  [ DEG:    59.8859   -120.1141 ]
  Theta =   0.559831    2.581761  [ DEG:    32.0760    147.9240 ]
  Phi   =  -2.386847    0.754745  [ DEG:  -136.7563     43.2437 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2gex_B                                        
REMARK     2: T0475.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2gex_B.T0475.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  133  117   5.0  107   2.26   16.82  70.796
REMARK  ---------------------------------------------------------- 
MOLECULE 2gex_B
HEADER    OXIDOREDUCTASE                          21-MAR-06   2GEX              
TITLE     CRYSTAL STRUCTURE OF SNOAL2 A PUTATIVE HYDROXYLASE FROM               
TITLE    2 STREPTOMYCES NOGALATER                                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SNOL;                                                      
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: SNOAL2, PUTATIVE HYDROXYLASE;                               
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOMYCES NOGALATER;                         
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: SNOAL2;                                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET30B                                    
KEYWDS    ALPHA+BETA BARREL                                                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    P.BEINKER,B.LOHKAMP,G.SCHNEIDER                                       
REVDAT   1   18-JUL-06 2GEX    0                                                
JRNL        AUTH   P.BEINKER,B.LOHKAMP,T.PELTONEN,J.NIEMI,P.MANTSALA,           
JRNL        AUTH 2 G.SCHNEIDER                                                  
JRNL        TITL   CRYSTAL STRUCTURES OF SNOAL2 AND ACLR: TWO                   
JRNL        TITL 2 PUTATIVE HYDROXYLASES IN THE BIOSYNTHESIS OF                 
JRNL        TITL 3 AROMATIC POLYKETIDE ANTIBIOTICS                              
JRNL        REF    J.MOL.BIOL.                   V. 359   728 2006              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 2.50 ANGSTROMS.                                          
DBREF  2GEX A    1   139  UNP    Q9RN64   Q9RN64_STRNO     1    139             
DBREF  2GEX B    1   139  UNP    Q9RN64   Q9RN64_STRNO     1    139             
SEQRES   1 A  152  MSE SER THR THR ALA ASN LYS GLU ARG CYS LEU GLU MSE          
SEQRES   2 A  152  VAL ALA ALA TRP ASN ARG TRP ASP VAL SER GLY VAL VAL          
SEQRES   3 A  152  ALA HIS TRP ALA PRO ASP VAL VAL HIS TYR ASP ASP GLU          
SEQRES   4 A  152  ASP LYS PRO VAL SER ALA GLU GLU VAL VAL ARG ARG MSE          
SEQRES   5 A  152  ASN SER ALA VAL GLU ALA PHE PRO ASP LEU ARG LEU ASP          
SEQRES   6 A  152  VAL ARG SER ILE VAL GLY GLU GLY ASP ARG VAL MSE LEU          
SEQRES   7 A  152  ARG ILE THR CYS SER ALA THR HIS GLN GLY VAL PHE MSE          
SEQRES   8 A  152  GLY ILE ALA PRO THR GLY ARG LYS VAL ARG TRP THR TYR          
SEQRES   9 A  152  LEU GLU GLU LEU ARG PHE SER GLU ALA GLY LYS VAL VAL          
SEQRES  10 A  152  GLU HIS TRP ASP VAL PHE ASN PHE SER PRO LEU PHE ARG          
SEQRES  11 A  152  ASP LEU GLY VAL VAL PRO ASP GLY LEU LYS LEU ALA ALA          
SEQRES  12 A  152  ALA LEU GLU HIS HIS HIS HIS HIS HIS                          
SEQRES   1 B  152  MSE SER THR THR ALA ASN LYS GLU ARG CYS LEU GLU MSE          
SEQRES   2 B  152  VAL ALA ALA TRP ASN ARG TRP ASP VAL SER GLY VAL VAL          
SEQRES   3 B  152  ALA HIS TRP ALA PRO ASP VAL VAL HIS TYR ASP ASP GLU          
SEQRES   4 B  152  ASP LYS PRO VAL SER ALA GLU GLU VAL VAL ARG ARG MSE          
SEQRES   5 B  152  ASN SER ALA VAL GLU ALA PHE PRO ASP LEU ARG LEU ASP          
SEQRES   6 B  152  VAL ARG SER ILE VAL GLY GLU GLY ASP ARG VAL MSE LEU          
SEQRES   7 B  152  ARG ILE THR CYS SER ALA THR HIS GLN GLY VAL PHE MSE          
SEQRES   8 B  152  GLY ILE ALA PRO THR GLY ARG LYS VAL ARG TRP THR TYR          
SEQRES   9 B  152  LEU GLU GLU LEU ARG PHE SER GLU ALA GLY LYS VAL VAL          
SEQRES  10 B  152  GLU HIS TRP ASP VAL PHE ASN PHE SER PRO LEU PHE ARG          
SEQRES  11 B  152  ASP LEU GLY VAL VAL PRO ASP GLY LEU LYS LEU ALA ALA          
SEQRES  12 B  152  ALA LEU GLU HIS HIS HIS HIS HIS HIS                          
HET    MSE  A  13       8                                                       
HET    MSE  A  52       8                                                       
HET    MSE  A  77       8                                                       
HET    MSE  A  91       8                                                       
HET    MSE  B  13       8                                                       
HET    MSE  B  52       8                                                       
HET    MSE  B  77       8                                                       
HET    MSE  B  91       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    8(C5 H11 N O2 SE)                                            
FORMUL   3  HOH   *31(H2 O)                                                     
CRYST1   90.008   90.008  116.707  90.00  90.00 120.00 P 32 2 1     12          
ATOM   1170  N   SER B   2       0.806  -1.871  -2.405  1.00 58.64           N  
ATOM   1171  CA  SER B   2       0.827  -3.224  -3.042  1.00 59.11           C  
ATOM   1172  C   SER B   2       1.532  -4.288  -2.185  1.00 59.27           C  
ATOM   1173  O   SER B   2       1.381  -5.493  -2.426  1.00 59.53           O  
ATOM   1174  CB  SER B   2       1.456  -3.185  -4.428  1.00 59.13           C  
ATOM   1175  OG  SER B   2       1.143  -4.379  -5.116  1.00 59.19           O  
ATOM   1176  N   THR B   3       2.313  -3.842  -1.205  1.00 58.82           N  
ATOM   1177  CA  THR B   3       2.641  -4.683  -0.068  1.00 57.87           C  
ATOM   1178  C   THR B   3       1.311  -5.077   0.612  1.00 57.34           C  
ATOM   1179  O   THR B   3       1.022  -6.269   0.802  1.00 57.39           O  
ATOM   1180  CB  THR B   3       3.673  -3.965   0.859  1.00 58.20           C  
ATOM   1181  OG1 THR B   3       4.952  -4.593   0.713  1.00 57.85           O  
ATOM   1182  CG2 THR B   3       3.273  -3.994   2.328  1.00 59.54           C  
ATOM   1183  N   THR B   4       0.474  -4.075   0.901  1.00 56.23           N  
ATOM   1184  CA  THR B   4      -0.823  -4.274   1.558  1.00 54.80           C  
ATOM   1185  C   THR B   4      -1.649  -5.324   0.826  1.00 54.19           C  
ATOM   1186  O   THR B   4      -2.196  -6.247   1.454  1.00 54.64           O  
ATOM   1187  CB  THR B   4      -1.581  -2.922   1.677  1.00 55.08           C  
ATOM   1188  OG1 THR B   4      -0.724  -1.960   2.301  1.00 54.51           O  
ATOM   1189  CG2 THR B   4      -2.848  -3.037   2.516  1.00 55.05           C  
ATOM   1190  N   ALA B   5      -1.714  -5.204  -0.496  1.00 53.02           N  
ATOM   1191  CA  ALA B   5      -2.482  -6.143  -1.318  1.00 52.25           C  
ATOM   1192  C   ALA B   5      -1.943  -7.584  -1.330  1.00 51.27           C  
ATOM   1193  O   ALA B   5      -2.728  -8.533  -1.278  1.00 51.46           O  
ATOM   1194  CB  ALA B   5      -2.667  -5.610  -2.753  1.00 52.20           C  
ATOM   1195  N   ASN B   6      -0.623  -7.753  -1.400  1.00 50.29           N  
ATOM   1196  CA  ASN B   6      -0.010  -9.095  -1.287  1.00 48.94           C  
ATOM   1197  C   ASN B   6      -0.351  -9.784   0.043  1.00 48.81           C  
ATOM   1198  O   ASN B   6      -0.733 -10.952   0.077  1.00 48.02           O  
ATOM   1199  CB  ASN B   6       1.501  -9.025  -1.513  1.00 48.08           C  
ATOM   1200  CG  ASN B   6       1.865  -8.560  -2.938  1.00 47.92           C  
ATOM   1201  OD1 ASN B   6       1.080  -8.715  -3.874  1.00 48.66           O  
ATOM   1202  ND2 ASN B   6       3.052  -7.989  -3.098  1.00 44.81           N  
ATOM   1203  N   LYS B   7      -0.235  -9.034   1.134  1.00 49.08           N  
ATOM   1204  CA  LYS B   7      -0.592  -9.530   2.449  1.00 49.59           C  
ATOM   1205  C   LYS B   7      -2.046  -9.961   2.448  1.00 49.90           C  
ATOM   1206  O   LYS B   7      -2.370 -11.046   2.955  1.00 50.18           O  
ATOM   1207  CB  LYS B   7      -0.335  -8.482   3.539  1.00 49.66           C  
ATOM   1208  CG  LYS B   7       1.149  -8.186   3.777  1.00 49.72           C  
ATOM   1209  CD  LYS B   7       1.391  -7.673   5.192  1.00 53.24           C  
ATOM   1210  CE  LYS B   7       1.104  -6.182   5.330  1.00 56.69           C  
ATOM   1211  NZ  LYS B   7       1.047  -5.756   6.762  1.00 57.73           N  
ATOM   1212  N   GLU B   8      -2.907  -9.143   1.834  1.00 49.93           N  
ATOM   1213  CA  GLU B   8      -4.331  -9.440   1.749  0.50 49.91           C  
ATOM   1215  C   GLU B   8      -4.563 -10.684   0.895  1.00 49.80           C  
ATOM   1216  O   GLU B   8      -5.465 -11.477   1.166  1.00 50.46           O  
ATOM   1217  CB  GLU B   8      -5.119  -8.234   1.218  0.50 49.72           C  
ATOM   1219  CG  GLU B   8      -5.382  -7.139   2.270  0.50 50.25           C  
ATOM   1221  CD  GLU B   8      -5.982  -5.841   1.699  0.50 50.71           C  
ATOM   1223  OE1 GLU B   8      -6.659  -5.881   0.636  0.50 51.84           O  
ATOM   1225  OE2 GLU B   8      -5.780  -4.774   2.327  0.50 50.88           O  
ATOM   1227  N   ARG B   9      -3.755 -10.869  -0.139  1.00 49.25           N  
ATOM   1228  CA  ARG B   9      -3.917 -12.076  -0.945  1.00 49.24           C  
ATOM   1229  C   ARG B   9      -3.556 -13.329  -0.118  1.00 48.94           C  
ATOM   1230  O   ARG B   9      -4.221 -14.377  -0.229  1.00 48.98           O  
ATOM   1231  CB  ARG B   9      -3.098 -12.018  -2.244  1.00 49.20           C  
ATOM   1232  CG  ARG B   9      -3.208 -10.725  -3.043  1.00 50.79           C  
ATOM   1233  CD  ARG B   9      -4.418 -10.671  -4.021  1.00 53.35           C  
ATOM   1234  NE  ARG B   9      -5.667 -10.264  -3.365  0.50 53.33           N  
ATOM   1235  CZ  ARG B   9      -6.055  -9.003  -3.171  0.50 53.55           C  
ATOM   1236  NH1 ARG B   9      -5.299  -7.983  -3.569  0.50 53.75           N  
ATOM   1237  NH2 ARG B   9      -7.210  -8.758  -2.569  0.50 52.98           N  
ATOM   1238  N   CYS B  10      -2.514 -13.215   0.713  1.00 48.49           N  
ATOM   1239  CA  CYS B  10      -2.082 -14.308   1.582  1.00 48.23           C  
ATOM   1240  C   CYS B  10      -3.166 -14.688   2.555  1.00 48.08           C  
ATOM   1241  O   CYS B  10      -3.384 -15.862   2.797  1.00 47.29           O  
ATOM   1242  CB  CYS B  10      -0.806 -13.942   2.319  1.00 48.79           C  
ATOM   1243  SG  CYS B  10       0.658 -13.888   1.243  1.00 51.09           S  
ATOM   1244  N   LEU B  11      -3.882 -13.696   3.077  1.00 48.64           N  
ATOM   1245  CA  LEU B  11      -5.007 -13.985   3.970  1.00 49.62           C  
ATOM   1246  C   LEU B  11      -6.182 -14.685   3.282  1.00 50.07           C  
ATOM   1247  O   LEU B  11      -6.849 -15.522   3.893  1.00 50.86           O  
ATOM   1248  CB  LEU B  11      -5.459 -12.735   4.726  1.00 49.43           C  
ATOM   1249  CG  LEU B  11      -4.377 -12.061   5.585  1.00 49.35           C  
ATOM   1250  CD1 LEU B  11      -5.119 -11.223   6.599  1.00 49.93           C  
ATOM   1251  CD2 LEU B  11      -3.476 -13.076   6.287  1.00 45.03           C  
ATOM   1252  N   GLU B  12      -6.409 -14.395   2.004  1.00 50.91           N  
ATOM   1253  CA  GLU B  12      -7.461 -15.087   1.259  1.00 52.25           C  
ATOM   1254  C   GLU B  12      -7.055 -16.540   1.037  1.00 52.31           C  
ATOM   1255  O   GLU B  12      -7.891 -17.433   1.101  1.00 53.04           O  
ATOM   1256  CB  GLU B  12      -7.795 -14.398  -0.063  1.00 51.89           C  
ATOM   1257  CG  GLU B  12      -8.381 -12.974   0.047  1.00 52.95           C  
ATOM   1258  CD  GLU B  12      -8.284 -12.180  -1.277  1.00 55.25           C  
ATOM   1259  OE1 GLU B  12      -8.586 -12.733  -2.368  1.00 58.90           O  
ATOM   1260  OE2 GLU B  12      -7.898 -10.983  -1.240  1.00 61.08           O  
HETATM 1261  N   MSE B  13      -5.763 -16.784   0.843  1.00 52.69           N  
HETATM 1262  CA  MSE B  13      -5.281 -18.142   0.645  1.00 53.62           C  
HETATM 1263  C   MSE B  13      -5.438 -19.014   1.889  1.00 51.53           C  
HETATM 1264  O   MSE B  13      -5.867 -20.166   1.798  1.00 51.32           O  
HETATM 1265  CB  MSE B  13      -3.832 -18.115   0.184  1.00 52.99           C  
HETATM 1266  CG  MSE B  13      -3.675 -17.614  -1.229  1.00 56.12           C  
HETATM 1267 SE   MSE B  13      -1.772 -17.603  -1.798  1.00 60.76          SE  
HETATM 1268  CE  MSE B  13      -1.347 -15.895  -1.107  1.00 58.16           C  
ATOM   1269  N   VAL B  14      -5.073 -18.467   3.041  1.00 50.13           N  
ATOM   1270  CA  VAL B  14      -5.291 -19.124   4.339  1.00 48.95           C  
ATOM   1271  C   VAL B  14      -6.806 -19.366   4.580  1.00 48.53           C  
ATOM   1272  O   VAL B  14      -7.211 -20.464   4.976  1.00 48.39           O  
ATOM   1273  CB  VAL B  14      -4.645 -18.273   5.494  1.00 49.05           C  
ATOM   1274  CG1 VAL B  14      -5.087 -18.736   6.872  1.00 47.78           C  
ATOM   1275  CG2 VAL B  14      -3.103 -18.234   5.356  1.00 45.92           C  
ATOM   1276  N   ALA B  15      -7.646 -18.364   4.309  1.00 47.26           N  
ATOM   1277  CA  ALA B  15      -9.100 -18.568   4.451  1.00 46.20           C  
ATOM   1278  C   ALA B  15      -9.572 -19.736   3.550  1.00 45.91           C  
ATOM   1279  O   ALA B  15     -10.453 -20.522   3.947  1.00 45.61           O  
ATOM   1280  CB  ALA B  15      -9.890 -17.258   4.167  1.00 45.01           C  
ATOM   1281  N   ALA B  16      -8.976 -19.855   2.357  1.00 44.89           N  
ATOM   1282  CA  ALA B  16      -9.307 -20.952   1.453  1.00 45.37           C  
ATOM   1283  C   ALA B  16      -8.917 -22.325   2.004  1.00 46.17           C  
ATOM   1284  O   ALA B  16      -9.706 -23.290   1.908  1.00 45.88           O  
ATOM   1285  CB  ALA B  16      -8.704 -20.736   0.112  1.00 45.69           C  
ATOM   1286  N   TRP B  17      -7.713 -22.401   2.587  1.00 46.54           N  
ATOM   1287  CA  TRP B  17      -7.280 -23.575   3.322  1.00 46.98           C  
ATOM   1288  C   TRP B  17      -8.282 -23.893   4.410  1.00 47.11           C  
ATOM   1289  O   TRP B  17      -8.632 -25.061   4.606  1.00 47.52           O  
ATOM   1290  CB  TRP B  17      -5.933 -23.347   3.987  1.00 47.81           C  
ATOM   1291  CG  TRP B  17      -4.698 -23.743   3.212  1.00 48.33           C  
ATOM   1292  CD1 TRP B  17      -3.834 -22.904   2.559  1.00 48.25           C  
ATOM   1293  CD2 TRP B  17      -4.175 -25.065   3.040  1.00 48.35           C  
ATOM   1294  NE1 TRP B  17      -2.811 -23.623   2.001  1.00 47.50           N  
ATOM   1295  CE2 TRP B  17      -2.991 -24.949   2.280  1.00 47.38           C  
ATOM   1296  CE3 TRP B  17      -4.586 -26.336   3.467  1.00 50.47           C  
ATOM   1297  CZ2 TRP B  17      -2.210 -26.051   1.934  1.00 49.53           C  
ATOM   1298  CZ3 TRP B  17      -3.815 -27.443   3.113  1.00 49.72           C  
ATOM   1299  CH2 TRP B  17      -2.639 -27.293   2.358  1.00 49.83           C  
ATOM   1300  N   ASN B  18      -8.752 -22.865   5.113  1.00 46.74           N  
ATOM   1301  CA  ASN B  18      -9.706 -23.091   6.215  1.00 46.34           C  
ATOM   1302  C   ASN B  18     -11.108 -23.433   5.764  1.00 46.58           C  
ATOM   1303  O   ASN B  18     -11.914 -23.846   6.586  1.00 46.59           O  
ATOM   1304  CB  ASN B  18      -9.756 -21.913   7.179  1.00 45.75           C  
ATOM   1305  CG  ASN B  18      -8.535 -21.836   8.070  1.00 45.29           C  
ATOM   1306  OD1 ASN B  18      -7.879 -22.850   8.364  1.00 47.90           O  
ATOM   1307  ND2 ASN B  18      -8.196 -20.640   8.476  1.00 42.33           N  
ATOM   1308  N   ARG B  19     -11.410 -23.235   4.479  1.00 46.81           N  
ATOM   1309  CA  ARG B  19     -12.666 -23.719   3.925  1.00 47.96           C  
ATOM   1310  C   ARG B  19     -12.483 -25.126   3.376  1.00 48.50           C  
ATOM   1311  O   ARG B  19     -13.410 -25.674   2.796  1.00 48.54           O  
ATOM   1312  CB  ARG B  19     -13.156 -22.848   2.772  1.00 48.34           C  
ATOM   1313  CG  ARG B  19     -13.880 -21.577   3.131  1.00 48.41           C  
ATOM   1314  CD  ARG B  19     -14.274 -20.881   1.802  1.00 50.39           C  
ATOM   1315  NE  ARG B  19     -13.378 -19.748   1.546  1.00 54.07           N  
ATOM   1316  CZ  ARG B  19     -12.633 -19.579   0.464  1.00 53.65           C  
ATOM   1317  NH1 ARG B  19     -12.660 -20.456  -0.512  1.00 54.18           N  
ATOM   1318  NH2 ARG B  19     -11.866 -18.503   0.356  1.00 57.59           N  
ATOM   1319  N   TRP B  20     -11.273 -25.672   3.533  1.00 48.83           N  
ATOM   1320  CA  TRP B  20     -10.881 -26.985   3.013  1.00 48.93           C  
ATOM   1321  C   TRP B  20     -10.995 -27.031   1.486  1.00 49.28           C  
ATOM   1322  O   TRP B  20     -11.234 -28.077   0.907  1.00 49.90           O  
ATOM   1323  CB  TRP B  20     -11.634 -28.103   3.747  1.00 47.84           C  
ATOM   1324  CG  TRP B  20     -11.525 -27.896   5.275  1.00 48.87           C  
ATOM   1325  CD1 TRP B  20     -10.362 -27.758   5.998  1.00 47.26           C  
ATOM   1326  CD2 TRP B  20     -12.607 -27.794   6.238  1.00 46.78           C  
ATOM   1327  NE1 TRP B  20     -10.655 -27.563   7.330  1.00 48.16           N  
ATOM   1328  CE2 TRP B  20     -12.020 -27.593   7.504  1.00 46.91           C  
ATOM   1329  CE3 TRP B  20     -14.007 -27.859   6.147  1.00 48.18           C  
ATOM   1330  CZ2 TRP B  20     -12.788 -27.455   8.682  1.00 46.90           C  
ATOM   1331  CZ3 TRP B  20     -14.776 -27.697   7.325  1.00 46.63           C  
ATOM   1332  CH2 TRP B  20     -14.158 -27.505   8.569  1.00 46.38           C  
ATOM   1333  N   ASP B  21     -10.740 -25.884   0.858  1.00 49.77           N  
ATOM   1334  CA  ASP B  21     -10.909 -25.670  -0.579  1.00 50.32           C  
ATOM   1335  C   ASP B  21      -9.561 -25.411  -1.295  1.00 50.24           C  
ATOM   1336  O   ASP B  21      -9.150 -24.271  -1.522  1.00 50.01           O  
ATOM   1337  CB  ASP B  21     -11.894 -24.503  -0.790  1.00 50.17           C  
ATOM   1338  CG  ASP B  21     -12.162 -24.191  -2.245  1.00 51.59           C  
ATOM   1339  OD1 ASP B  21     -11.846 -25.010  -3.162  1.00 51.88           O  
ATOM   1340  OD2 ASP B  21     -12.719 -23.091  -2.467  1.00 54.01           O  
ATOM   1341  N   VAL B  22      -8.913 -26.494  -1.690  1.00 50.51           N  
ATOM   1342  CA  VAL B  22      -7.613 -26.453  -2.344  1.00 50.57           C  
ATOM   1343  C   VAL B  22      -7.583 -25.649  -3.665  1.00 51.15           C  
ATOM   1344  O   VAL B  22      -6.609 -24.948  -3.951  1.00 51.21           O  
ATOM   1345  CB  VAL B  22      -7.087 -27.891  -2.522  1.00 50.46           C  
ATOM   1346  CG1 VAL B  22      -5.928 -27.960  -3.532  1.00 49.34           C  
ATOM   1347  CG2 VAL B  22      -6.684 -28.431  -1.166  1.00 49.19           C  
ATOM   1348  N   SER B  23      -8.638 -25.728  -4.466  1.00 51.41           N  
ATOM   1349  CA  SER B  23      -8.667 -24.911  -5.687  1.00 51.87           C  
ATOM   1350  C   SER B  23      -8.837 -23.403  -5.406  1.00 51.84           C  
ATOM   1351  O   SER B  23      -8.425 -22.579  -6.222  1.00 52.25           O  
ATOM   1352  CB  SER B  23      -9.722 -25.409  -6.664  1.00 51.48           C  
ATOM   1353  OG  SER B  23     -10.960 -25.437  -6.009  1.00 53.03           O  
ATOM   1354  N   GLY B  24      -9.426 -23.049  -4.261  1.00 51.43           N  
ATOM   1355  CA  GLY B  24      -9.449 -21.655  -3.810  1.00 51.38           C  
ATOM   1356  C   GLY B  24      -8.054 -21.091  -3.558  1.00 51.53           C  
ATOM   1357  O   GLY B  24      -7.814 -19.886  -3.736  1.00 52.23           O  
ATOM   1358  N   VAL B  25      -7.130 -21.959  -3.148  1.00 50.87           N  
ATOM   1359  CA  VAL B  25      -5.733 -21.578  -2.948  1.00 50.41           C  
ATOM   1360  C   VAL B  25      -5.048 -21.498  -4.314  1.00 50.35           C  
ATOM   1361  O   VAL B  25      -4.446 -20.487  -4.663  1.00 50.37           O  
ATOM   1362  CB  VAL B  25      -4.989 -22.596  -2.017  1.00 50.72           C  
ATOM   1363  CG1 VAL B  25      -3.529 -22.226  -1.829  1.00 50.14           C  
ATOM   1364  CG2 VAL B  25      -5.693 -22.753  -0.646  1.00 49.58           C  
ATOM   1365  N   VAL B  26      -5.177 -22.551  -5.110  1.00 50.26           N  
ATOM   1366  CA  VAL B  26      -4.521 -22.610  -6.416  1.00 49.80           C  
ATOM   1367  C   VAL B  26      -4.932 -21.428  -7.301  1.00 50.14           C  
ATOM   1368  O   VAL B  26      -4.126 -20.936  -8.103  1.00 50.65           O  
ATOM   1369  CB  VAL B  26      -4.840 -23.948  -7.138  1.00 50.21           C  
ATOM   1370  CG1 VAL B  26      -4.435 -23.909  -8.640  1.00 49.21           C  
ATOM   1371  CG2 VAL B  26      -4.207 -25.129  -6.399  1.00 48.20           C  
ATOM   1372  N   ALA B  27      -6.178 -20.975  -7.154  1.00 49.67           N  
ATOM   1373  CA  ALA B  27      -6.696 -19.830  -7.918  1.00 49.54           C  
ATOM   1374  C   ALA B  27      -5.807 -18.589  -7.826  1.00 49.37           C  
ATOM   1375  O   ALA B  27      -5.801 -17.760  -8.729  1.00 49.07           O  
ATOM   1376  CB  ALA B  27      -8.104 -19.483  -7.468  1.00 49.76           C  
ATOM   1377  N   HIS B  28      -5.055 -18.472  -6.735  1.00 49.50           N  
ATOM   1378  CA  HIS B  28      -4.147 -17.339  -6.544  1.00 49.92           C  
ATOM   1379  C   HIS B  28      -2.805 -17.489  -7.279  1.00 49.54           C  
ATOM   1380  O   HIS B  28      -2.021 -16.538  -7.326  1.00 49.88           O  
ATOM   1381  CB  HIS B  28      -3.918 -17.071  -5.049  1.00 49.86           C  
ATOM   1382  CG  HIS B  28      -5.058 -16.360  -4.378  1.00 51.95           C  
ATOM   1383  ND1 HIS B  28      -6.124 -17.026  -3.803  1.00 54.70           N  
ATOM   1384  CD2 HIS B  28      -5.292 -15.043  -4.181  1.00 52.42           C  
ATOM   1385  CE1 HIS B  28      -6.964 -16.149  -3.282  1.00 53.86           C  
ATOM   1386  NE2 HIS B  28      -6.478 -14.938  -3.493  1.00 53.38           N  
ATOM   1387  N   TRP B  29      -2.539 -18.668  -7.841  1.00 49.06           N  
ATOM   1388  CA  TRP B  29      -1.268 -18.927  -8.520  1.00 49.34           C  
ATOM   1389  C   TRP B  29      -1.236 -18.251  -9.881  1.00 49.67           C  
ATOM   1390  O   TRP B  29      -2.263 -18.133 -10.525  1.00 50.00           O  
ATOM   1391  CB  TRP B  29      -1.051 -20.433  -8.696  1.00 48.45           C  
ATOM   1392  CG  TRP B  29      -0.848 -21.172  -7.407  1.00 49.06           C  
ATOM   1393  CD1 TRP B  29      -0.731 -20.625  -6.136  1.00 47.86           C  
ATOM   1394  CD2 TRP B  29      -0.696 -22.589  -7.239  1.00 48.44           C  
ATOM   1395  NE1 TRP B  29      -0.547 -21.620  -5.209  1.00 45.83           N  
ATOM   1396  CE2 TRP B  29      -0.512 -22.829  -5.844  1.00 46.90           C  
ATOM   1397  CE3 TRP B  29      -0.721 -23.682  -8.119  1.00 46.74           C  
ATOM   1398  CZ2 TRP B  29      -0.334 -24.108  -5.322  1.00 46.39           C  
ATOM   1399  CZ3 TRP B  29      -0.554 -24.967  -7.593  1.00 46.69           C  
ATOM   1400  CH2 TRP B  29      -0.360 -25.163  -6.207  1.00 47.92           C  
ATOM   1401  N   ALA B  30      -0.071 -17.789 -10.321  1.00 50.43           N  
ATOM   1402  CA  ALA B  30       0.051 -17.314 -11.703  1.00 50.78           C  
ATOM   1403  C   ALA B  30       0.162 -18.539 -12.602  1.00 51.15           C  
ATOM   1404  O   ALA B  30       0.591 -19.598 -12.139  1.00 51.20           O  
ATOM   1405  CB  ALA B  30       1.272 -16.402 -11.879  1.00 50.65           C  
ATOM   1406  N   PRO B  31      -0.241 -18.413 -13.881  1.00 51.60           N  
ATOM   1407  CA  PRO B  31      -0.046 -19.516 -14.829  1.00 51.73           C  
ATOM   1408  C   PRO B  31       1.335 -20.184 -14.756  1.00 51.84           C  
ATOM   1409  O   PRO B  31       1.412 -21.405 -14.857  1.00 51.93           O  
ATOM   1410  CB  PRO B  31      -0.260 -18.844 -16.185  1.00 51.52           C  
ATOM   1411  CG  PRO B  31      -1.275 -17.783 -15.897  1.00 51.05           C  
ATOM   1412  CD  PRO B  31      -0.926 -17.267 -14.520  1.00 51.83           C  
ATOM   1413  N   ASP B  32       2.398 -19.407 -14.557  1.00 51.96           N  
ATOM   1414  CA  ASP B  32       3.759 -19.964 -14.568  1.00 52.37           C  
ATOM   1415  C   ASP B  32       4.499 -19.955 -13.212  1.00 52.44           C  
ATOM   1416  O   ASP B  32       5.738 -19.805 -13.160  1.00 52.43           O  
ATOM   1417  CB  ASP B  32       4.605 -19.285 -15.650  1.00 52.43           C  
ATOM   1418  CG  ASP B  32       4.681 -17.781 -15.477  1.00 52.92           C  
ATOM   1419  OD1 ASP B  32       4.267 -17.255 -14.414  1.00 52.56           O  
ATOM   1420  OD2 ASP B  32       5.157 -17.121 -16.426  1.00 53.86           O  
ATOM   1421  N   VAL B  33       3.728 -20.103 -12.134  1.00 52.07           N  
ATOM   1422  CA  VAL B  33       4.258 -20.298 -10.787  1.00 51.75           C  
ATOM   1423  C   VAL B  33       5.397 -21.297 -10.744  1.00 51.44           C  
ATOM   1424  O   VAL B  33       5.358 -22.324 -11.416  1.00 50.93           O  
ATOM   1425  CB  VAL B  33       3.180 -20.866  -9.811  1.00 52.12           C  
ATOM   1426  CG1 VAL B  33       2.498 -19.758  -9.058  1.00 52.53           C  
ATOM   1427  CG2 VAL B  33       2.158 -21.763 -10.556  1.00 50.94           C  
ATOM   1428  N   VAL B  34       6.396 -20.999  -9.915  1.00 51.29           N  
ATOM   1429  CA  VAL B  34       7.461 -21.944  -9.612  1.00 50.54           C  
ATOM   1430  C   VAL B  34       7.344 -22.301  -8.131  1.00 50.42           C  
ATOM   1431  O   VAL B  34       7.222 -21.414  -7.284  1.00 50.39           O  
ATOM   1432  CB  VAL B  34       8.861 -21.373  -9.963  1.00 50.47           C  
ATOM   1433  CG1 VAL B  34       9.909 -22.440  -9.837  1.00 50.10           C  
ATOM   1434  CG2 VAL B  34       8.883 -20.803 -11.391  1.00 50.02           C  
ATOM   1435  N   HIS B  35       7.346 -23.598  -7.835  1.00 50.40           N  
ATOM   1436  CA  HIS B  35       7.345 -24.107  -6.472  1.00 50.88           C  
ATOM   1437  C   HIS B  35       8.682 -24.732  -6.122  1.00 50.88           C  
ATOM   1438  O   HIS B  35       9.118 -25.669  -6.782  1.00 51.58           O  
ATOM   1439  CB  HIS B  35       6.304 -25.195  -6.330  1.00 51.09           C  
ATOM   1440  CG  HIS B  35       4.958 -24.814  -6.851  1.00 53.26           C  
ATOM   1441  ND1 HIS B  35       4.019 -24.157  -6.080  1.00 54.49           N  
ATOM   1442  CD2 HIS B  35       4.386 -25.009  -8.064  1.00 54.82           C  
ATOM   1443  CE1 HIS B  35       2.932 -23.955  -6.801  1.00 54.58           C  
ATOM   1444  NE2 HIS B  35       3.128 -24.463  -8.007  1.00 55.08           N  
ATOM   1445  N   TYR B  36       9.325 -24.243  -5.071  1.00 50.92           N  
ATOM   1446  CA  TYR B  36      10.618 -24.786  -4.654  1.00 50.65           C  
ATOM   1447  C   TYR B  36      10.482 -25.605  -3.375  1.00 50.49           C  
ATOM   1448  O   TYR B  36       9.681 -25.280  -2.498  1.00 50.03           O  
ATOM   1449  CB  TYR B  36      11.634 -23.664  -4.450  1.00 50.71           C  
ATOM   1450  CG  TYR B  36      11.870 -22.788  -5.662  1.00 50.69           C  
ATOM   1451  CD1 TYR B  36      12.650 -23.232  -6.720  1.00 51.80           C  
ATOM   1452  CD2 TYR B  36      11.324 -21.510  -5.744  1.00 50.25           C  
ATOM   1453  CE1 TYR B  36      12.882 -22.430  -7.831  1.00 51.95           C  
ATOM   1454  CE2 TYR B  36      11.541 -20.699  -6.845  1.00 49.85           C  
ATOM   1455  CZ  TYR B  36      12.325 -21.163  -7.885  1.00 52.01           C  
ATOM   1456  OH  TYR B  36      12.559 -20.375  -9.002  1.00 52.22           O  
ATOM   1457  N   ASP B  37      11.261 -26.676  -3.289  1.00 50.27           N  
ATOM   1458  CA  ASP B  37      11.380 -27.446  -2.061  1.00 50.33           C  
ATOM   1459  C   ASP B  37      12.518 -26.824  -1.234  1.00 50.65           C  
ATOM   1460  O   ASP B  37      12.969 -25.721  -1.565  1.00 50.84           O  
ATOM   1461  CB  ASP B  37      11.630 -28.926  -2.376  1.00 50.09           C  
ATOM   1462  CG  ASP B  37      12.940 -29.168  -3.111  1.00 49.24           C  
ATOM   1463  OD1 ASP B  37      13.741 -28.225  -3.349  1.00 48.23           O  
ATOM   1464  OD2 ASP B  37      13.170 -30.332  -3.455  1.00 48.89           O  
ATOM   1465  N   ASP B  38      12.980 -27.514  -0.187  1.00 50.80           N  
ATOM   1466  CA  ASP B  38      14.032 -27.028   0.723  0.50 51.18           C  
ATOM   1468  C   ASP B  38      15.315 -26.663  -0.030  1.00 51.51           C  
ATOM   1469  O   ASP B  38      15.998 -25.681   0.292  1.00 51.68           O  
ATOM   1470  CB  ASP B  38      14.366 -28.092   1.787  0.50 50.97           C  
ATOM   1472  CG  ASP B  38      13.276 -29.159   1.935  0.50 51.46           C  
ATOM   1474  OD1 ASP B  38      12.575 -29.171   2.975  0.50 51.09           O  
ATOM   1476  OD2 ASP B  38      13.121 -29.989   1.012  0.50 50.84           O  
ATOM   1478  N   GLU B  39      15.653 -27.491  -1.025  1.00 51.78           N  
ATOM   1479  CA  GLU B  39      16.908 -27.339  -1.772  1.00 52.52           C  
ATOM   1480  C   GLU B  39      16.811 -26.445  -3.024  1.00 52.64           C  
ATOM   1481  O   GLU B  39      17.700 -26.480  -3.882  1.00 52.12           O  
ATOM   1482  CB  GLU B  39      17.463 -28.711  -2.158  1.00 52.34           C  
ATOM   1483  CG  GLU B  39      17.469 -29.736  -1.032  1.00 53.57           C  
ATOM   1484  CD  GLU B  39      18.230 -31.011  -1.394  1.00 53.43           C  
ATOM   1485  OE1 GLU B  39      19.460 -30.948  -1.603  1.00 54.82           O  
ATOM   1486  OE2 GLU B  39      17.595 -32.082  -1.474  1.00 55.39           O  
ATOM   1487  N   ASP B  40      15.746 -25.645  -3.127  1.00 52.95           N  
ATOM   1488  CA  ASP B  40      15.505 -24.822  -4.328  1.00 53.25           C  
ATOM   1489  C   ASP B  40      15.271 -25.643  -5.619  1.00 53.41           C  
ATOM   1490  O   ASP B  40      15.436 -25.114  -6.733  1.00 53.82           O  
ATOM   1491  CB  ASP B  40      16.661 -23.834  -4.559  1.00 53.29           C  
ATOM   1492  CG  ASP B  40      16.506 -22.537  -3.780  1.00 53.93           C  
ATOM   1493  OD1 ASP B  40      15.608 -22.425  -2.911  1.00 54.69           O  
ATOM   1494  OD2 ASP B  40      17.311 -21.617  -4.043  1.00 54.43           O  
ATOM   1495  N   LYS B  41      14.914 -26.924  -5.481  1.00 53.05           N  
ATOM   1496  CA  LYS B  41      14.608 -27.758  -6.644  1.00 52.66           C  
ATOM   1497  C   LYS B  41      13.137 -27.579  -7.011  1.00 52.59           C  
ATOM   1498  O   LYS B  41      12.257 -27.770  -6.160  1.00 52.54           O  
ATOM   1499  CB  LYS B  41      14.933 -29.233  -6.379  1.00 52.57           C  
ATOM   1500  CG  LYS B  41      16.428 -29.530  -6.274  1.00 52.40           C  
ATOM   1501  CD  LYS B  41      17.473 -29.794  -6.970  0.00 50.00           C  
ATOM   1502  CE  LYS B  41      18.075 -28.775  -7.929  0.00 50.00           C  
ATOM   1503  NZ  LYS B  41      19.022 -29.398  -8.901  0.00 50.00           N  
ATOM   1504  N   PRO B  42      12.854 -27.184  -8.270  1.00 52.40           N  
ATOM   1505  CA  PRO B  42      11.451 -27.001  -8.651  1.00 52.24           C  
ATOM   1506  C   PRO B  42      10.637 -28.272  -8.456  1.00 51.95           C  
ATOM   1507  O   PRO B  42      11.144 -29.380  -8.633  1.00 52.23           O  
ATOM   1508  CB  PRO B  42      11.531 -26.621 -10.142  1.00 51.88           C  
ATOM   1509  CG  PRO B  42      12.864 -27.033 -10.574  1.00 52.11           C  
ATOM   1510  CD  PRO B  42      13.755 -26.877  -9.389  1.00 52.23           C  
ATOM   1511  N   VAL B  43       9.388 -28.094  -8.073  1.00 51.56           N  
ATOM   1512  CA  VAL B  43       8.447 -29.191  -7.926  1.00 51.94           C  
ATOM   1513  C   VAL B  43       7.282 -28.861  -8.859  1.00 52.03           C  
ATOM   1514  O   VAL B  43       7.007 -27.675  -9.119  1.00 52.13           O  
ATOM   1515  CB  VAL B  43       7.942 -29.310  -6.452  1.00 51.90           C  
ATOM   1516  CG1 VAL B  43       6.936 -30.423  -6.307  1.00 52.09           C  
ATOM   1517  CG2 VAL B  43       9.102 -29.563  -5.515  1.00 52.37           C  
ATOM   1518  N   SER B  44       6.614 -29.894  -9.370  1.00 51.83           N  
ATOM   1519  CA  SER B  44       5.437 -29.698 -10.214  1.00 52.18           C  
ATOM   1520  C   SER B  44       4.201 -29.319  -9.399  1.00 52.20           C  
ATOM   1521  O   SER B  44       3.951 -29.872  -8.318  1.00 52.27           O  
ATOM   1522  CB  SER B  44       5.129 -30.968 -10.993  1.00 52.24           C  
ATOM   1523  OG  SER B  44       4.536 -31.923 -10.132  1.00 53.25           O  
ATOM   1524  N   ALA B  45       3.426 -28.387  -9.944  1.00 52.08           N  
ATOM   1525  CA  ALA B  45       2.083 -28.060  -9.451  1.00 51.41           C  
ATOM   1526  C   ALA B  45       1.271 -29.295  -9.063  1.00 51.16           C  
ATOM   1527  O   ALA B  45       0.571 -29.272  -8.054  1.00 51.37           O  
ATOM   1528  CB  ALA B  45       1.325 -27.236 -10.498  1.00 50.95           C  
ATOM   1529  N   GLU B  46       1.371 -30.364  -9.850  1.00 50.83           N  
ATOM   1530  CA  GLU B  46       0.608 -31.594  -9.601  1.00 50.75           C  
ATOM   1531  C   GLU B  46       1.005 -32.285  -8.285  1.00 50.67           C  
ATOM   1532  O   GLU B  46       0.146 -32.738  -7.528  1.00 50.92           O  
ATOM   1533  CB  GLU B  46       0.733 -32.563 -10.782  1.00 50.56           C  
ATOM   1534  CG  GLU B  46       0.554 -31.916 -12.167  1.00 51.20           C  
ATOM   1535  CD  GLU B  46       1.888 -31.598 -12.876  0.50 50.89           C  
ATOM   1536  OE1 GLU B  46       2.628 -32.543 -13.241  0.50 49.68           O  
ATOM   1537  OE2 GLU B  46       2.193 -30.400 -13.075  0.50 50.09           O  
ATOM   1538  N   GLU B  47       2.307 -32.357  -8.019  1.00 50.71           N  
ATOM   1539  CA  GLU B  47       2.824 -32.929  -6.776  1.00 50.50           C  
ATOM   1540  C   GLU B  47       2.391 -32.099  -5.556  1.00 50.34           C  
ATOM   1541  O   GLU B  47       2.062 -32.658  -4.511  1.00 50.62           O  
ATOM   1542  CB  GLU B  47       4.343 -33.032  -6.847  1.00 50.30           C  
ATOM   1543  CG  GLU B  47       4.964 -34.037  -5.881  1.00 50.59           C  
ATOM   1544  CD  GLU B  47       6.483 -34.159  -6.079  0.50 50.33           C  
ATOM   1545  OE1 GLU B  47       6.932 -34.282  -7.244  0.50 49.36           O  
ATOM   1546  OE2 GLU B  47       7.228 -34.130  -5.075  0.50 49.01           O  
ATOM   1547  N   VAL B  48       2.370 -30.777  -5.705  1.00 49.68           N  
ATOM   1548  CA  VAL B  48       1.914 -29.880  -4.640  1.00 49.26           C  
ATOM   1549  C   VAL B  48       0.426 -30.065  -4.324  1.00 49.18           C  
ATOM   1550  O   VAL B  48       0.041 -30.116  -3.153  1.00 48.93           O  
ATOM   1551  CB  VAL B  48       2.192 -28.382  -4.976  1.00 49.41           C  
ATOM   1552  CG1 VAL B  48       1.648 -27.469  -3.885  1.00 48.25           C  
ATOM   1553  CG2 VAL B  48       3.705 -28.123  -5.200  1.00 48.18           C  
ATOM   1554  N   VAL B  49      -0.395 -30.145  -5.371  1.00 49.52           N  
ATOM   1555  CA  VAL B  49      -1.854 -30.259  -5.253  1.00 49.71           C  
ATOM   1556  C   VAL B  49      -2.207 -31.624  -4.676  1.00 50.13           C  
ATOM   1557  O   VAL B  49      -3.077 -31.735  -3.805  1.00 49.74           O  
ATOM   1558  CB  VAL B  49      -2.592 -29.948  -6.619  1.00 50.09           C  
ATOM   1559  CG1 VAL B  49      -4.085 -30.350  -6.601  1.00 49.28           C  
ATOM   1560  CG2 VAL B  49      -2.467 -28.477  -6.977  1.00 49.24           C  
ATOM   1561  N   ARG B  50      -1.496 -32.652  -5.130  1.00 50.70           N  
ATOM   1562  CA  ARG B  50      -1.655 -33.988  -4.567  1.00 51.73           C  
ATOM   1563  C   ARG B  50      -1.486 -33.955  -3.046  1.00 52.04           C  
ATOM   1564  O   ARG B  50      -2.290 -34.529  -2.308  1.00 52.05           O  
ATOM   1565  CB  ARG B  50      -0.673 -34.977  -5.211  1.00 51.65           C  
ATOM   1566  CG  ARG B  50      -1.326 -35.952  -6.202  1.00 52.54           C  
ATOM   1567  CD  ARG B  50      -0.275 -36.734  -7.052  1.00 52.38           C  
ATOM   1568  NE  ARG B  50       1.040 -36.793  -6.398  0.50 51.46           N  
ATOM   1569  CZ  ARG B  50       2.128 -37.347  -6.927  0.50 50.82           C  
ATOM   1570  NH1 ARG B  50       2.076 -37.922  -8.119  0.50 49.48           N  
ATOM   1571  NH2 ARG B  50       3.271 -37.332  -6.258  0.50 50.73           N  
ATOM   1572  N   ARG B  51      -0.455 -33.253  -2.587  1.00 52.57           N  
ATOM   1573  CA  ARG B  51      -0.151 -33.194  -1.182  1.00 53.21           C  
ATOM   1574  C   ARG B  51      -1.125 -32.321  -0.384  1.00 53.59           C  
ATOM   1575  O   ARG B  51      -1.428 -32.601   0.777  1.00 52.78           O  
ATOM   1576  CB  ARG B  51       1.278 -32.720  -0.976  1.00 53.64           C  
ATOM   1577  CG  ARG B  51       1.784 -33.029   0.425  1.00 55.18           C  
ATOM   1578  CD  ARG B  51       2.516 -34.349   0.453  1.00 58.35           C  
ATOM   1579  NE  ARG B  51       3.711 -34.193   1.274  1.00 61.56           N  
ATOM   1580  CZ  ARG B  51       4.960 -34.236   0.830  1.00 60.35           C  
ATOM   1581  NH1 ARG B  51       5.235 -34.457  -0.444  1.00 60.35           N  
ATOM   1582  NH2 ARG B  51       5.941 -34.064   1.687  1.00 62.68           N  
HETATM 1583  N   MSE B  52      -1.618 -31.257  -0.997  1.00 53.93           N  
HETATM 1584  CA  MSE B  52      -2.576 -30.440  -0.290  1.00 55.54           C  
HETATM 1585  C   MSE B  52      -3.840 -31.247  -0.138  1.00 53.40           C  
HETATM 1586  O   MSE B  52      -4.419 -31.269   0.942  1.00 53.61           O  
HETATM 1587  CB  MSE B  52      -2.850 -29.138  -1.028  1.00 55.09           C  
HETATM 1588  CG  MSE B  52      -1.682 -28.191  -1.057  1.00 57.54           C  
HETATM 1589 SE   MSE B  52      -1.985 -26.699  -2.279  1.00 63.73          SE  
HETATM 1590  CE  MSE B  52      -1.844 -27.505  -3.840  1.00 62.34           C  
ATOM   1591  N   ASN B  53      -4.237 -31.933  -1.217  1.00 51.72           N  
ATOM   1592  CA  ASN B  53      -5.412 -32.805  -1.211  1.00 49.62           C  
ATOM   1593  C   ASN B  53      -5.341 -33.876  -0.119  1.00 48.68           C  
ATOM   1594  O   ASN B  53      -6.317 -34.096   0.574  1.00 48.46           O  
ATOM   1595  CB  ASN B  53      -5.678 -33.423  -2.601  1.00 49.36           C  
ATOM   1596  CG  ASN B  53      -6.296 -32.428  -3.596  1.00 49.09           C  
ATOM   1597  OD1 ASN B  53      -6.992 -31.500  -3.204  1.00 51.95           O  
ATOM   1598  ND2 ASN B  53      -6.030 -32.619  -4.882  1.00 47.72           N  
ATOM   1599  N   SER B  54      -4.182 -34.508   0.055  1.00 47.90           N  
ATOM   1600  CA  SER B  54      -3.996 -35.529   1.087  1.00 47.58           C  
ATOM   1601  C   SER B  54      -4.168 -34.938   2.477  1.00 47.73           C  
ATOM   1602  O   SER B  54      -4.870 -35.519   3.309  1.00 48.47           O  
ATOM   1603  CB  SER B  54      -2.604 -36.153   0.995  1.00 48.00           C  
ATOM   1604  OG  SER B  54      -2.321 -36.573  -0.315  1.00 47.19           O  
ATOM   1605  N   ALA B  55      -3.549 -33.778   2.719  1.00 47.37           N  
ATOM   1606  CA  ALA B  55      -3.632 -33.080   4.010  1.00 47.28           C  
ATOM   1607  C   ALA B  55      -5.077 -32.743   4.379  1.00 47.55           C  
ATOM   1608  O   ALA B  55      -5.523 -33.029   5.500  1.00 46.87           O  
ATOM   1609  CB  ALA B  55      -2.786 -31.824   3.997  1.00 47.03           C  
ATOM   1610  N   VAL B  56      -5.796 -32.144   3.432  1.00 47.72           N  
ATOM   1611  CA  VAL B  56      -7.201 -31.816   3.629  1.00 49.18           C  
ATOM   1612  C   VAL B  56      -8.050 -33.079   3.902  1.00 49.21           C  
ATOM   1613  O   VAL B  56      -8.945 -33.064   4.730  1.00 49.00           O  
ATOM   1614  CB  VAL B  56      -7.756 -31.047   2.417  1.00 49.35           C  
ATOM   1615  CG1 VAL B  56      -9.268 -31.182   2.334  1.00 50.54           C  
ATOM   1616  CG2 VAL B  56      -7.349 -29.597   2.497  1.00 49.68           C  
ATOM   1617  N   GLU B  57      -7.726 -34.170   3.217  1.00 49.69           N  
ATOM   1618  CA  GLU B  57      -8.419 -35.445   3.402  1.00 50.06           C  
ATOM   1619  C   GLU B  57      -8.096 -36.060   4.780  1.00 49.89           C  
ATOM   1620  O   GLU B  57      -9.029 -36.413   5.514  1.00 50.59           O  
ATOM   1621  CB  GLU B  57      -8.083 -36.405   2.239  1.00 49.98           C  
ATOM   1622  CG  GLU B  57      -8.943 -37.677   2.173  1.00 50.77           C  
ATOM   1623  CD  GLU B  57      -8.728 -38.472   0.878  0.50 50.44           C  
ATOM   1624  OE1 GLU B  57      -8.773 -37.860  -0.216  0.50 49.70           O  
ATOM   1625  OE2 GLU B  57      -8.520 -39.708   0.956  0.50 50.66           O  
ATOM   1626  N   ALA B  58      -6.804 -36.136   5.141  1.00 48.34           N  
ATOM   1627  CA  ALA B  58      -6.345 -36.737   6.411  1.00 47.49           C  
ATOM   1628  C   ALA B  58      -6.667 -35.935   7.697  1.00 47.44           C  
ATOM   1629  O   ALA B  58      -6.829 -36.514   8.797  1.00 46.84           O  
ATOM   1630  CB  ALA B  58      -4.843 -36.976   6.332  1.00 47.11           C  
ATOM   1631  N   PHE B  59      -6.704 -34.606   7.555  1.00 46.90           N  
ATOM   1632  CA  PHE B  59      -6.906 -33.689   8.664  1.00 46.32           C  
ATOM   1633  C   PHE B  59      -8.140 -32.856   8.353  1.00 47.01           C  
ATOM   1634  O   PHE B  59      -8.036 -31.667   8.031  1.00 46.44           O  
ATOM   1635  CB  PHE B  59      -5.663 -32.827   8.826  1.00 45.95           C  
ATOM   1636  CG  PHE B  59      -4.389 -33.629   9.034  1.00 45.32           C  
ATOM   1637  CD1 PHE B  59      -4.148 -34.285  10.231  1.00 43.89           C  
ATOM   1638  CD2 PHE B  59      -3.445 -33.724   8.032  1.00 44.73           C  
ATOM   1639  CE1 PHE B  59      -2.977 -35.033  10.419  1.00 45.91           C  
ATOM   1640  CE2 PHE B  59      -2.266 -34.467   8.208  1.00 46.23           C  
ATOM   1641  CZ  PHE B  59      -2.031 -35.119   9.404  1.00 45.30           C  
ATOM   1642  N   PRO B  60      -9.328 -33.493   8.410  1.00 47.36           N  
ATOM   1643  CA  PRO B  60     -10.530 -32.857   7.855  1.00 47.51           C  
ATOM   1644  C   PRO B  60     -10.975 -31.625   8.610  1.00 47.60           C  
ATOM   1645  O   PRO B  60     -11.737 -30.849   8.047  1.00 48.41           O  
ATOM   1646  CB  PRO B  60     -11.610 -33.958   7.941  1.00 46.95           C  
ATOM   1647  CG  PRO B  60     -11.165 -34.864   9.011  1.00 47.46           C  
ATOM   1648  CD  PRO B  60      -9.619 -34.821   8.978  1.00 47.35           C  
ATOM   1649  N   ASP B  61     -10.504 -31.436   9.843  1.00 47.81           N  
ATOM   1650  CA  ASP B  61     -10.883 -30.267  10.681  1.00 48.46           C  
ATOM   1651  C   ASP B  61      -9.690 -29.300  10.765  1.00 48.83           C  
ATOM   1652  O   ASP B  61      -9.482 -28.566  11.768  1.00 48.12           O  
ATOM   1653  CB  ASP B  61     -11.317 -30.720  12.093  1.00 47.62           C  
ATOM   1654  CG  ASP B  61     -10.227 -31.566  12.800  1.00 51.46           C  
ATOM   1655  OD1 ASP B  61      -9.185 -31.880  12.147  1.00 51.12           O  
ATOM   1656  OD2 ASP B  61     -10.405 -31.915  14.002  1.00 53.13           O  
ATOM   1657  N   LEU B  62      -8.881 -29.309   9.742  1.00 49.41           N  
ATOM   1658  CA  LEU B  62      -7.683 -28.539   9.727  1.00 50.04           C  
ATOM   1659  C   LEU B  62      -7.980 -27.067   9.891  1.00 49.51           C  
ATOM   1660  O   LEU B  62      -8.887 -26.548   9.329  1.00 48.97           O  
ATOM   1661  CB  LEU B  62      -6.936 -28.838   8.447  1.00 50.74           C  
ATOM   1662  CG  LEU B  62      -5.939 -27.939   7.756  1.00 52.35           C  
ATOM   1663  CD1 LEU B  62      -4.658 -27.933   8.516  1.00 56.79           C  
ATOM   1664  CD2 LEU B  62      -5.721 -28.511   6.440  1.00 54.07           C  
ATOM   1665  N   ARG B  63      -7.204 -26.403  10.709  1.00 49.07           N  
ATOM   1666  CA  ARG B  63      -7.369 -24.958  10.949  1.00 48.62           C  
ATOM   1667  C   ARG B  63      -6.036 -24.253  10.949  1.00 47.16           C  
ATOM   1668  O   ARG B  63      -5.203 -24.575  11.780  1.00 46.61           O  
ATOM   1669  CB  ARG B  63      -8.039 -24.694  12.312  1.00 49.17           C  
ATOM   1670  CG  ARG B  63      -8.181 -23.204  12.627  1.00 49.78           C  
ATOM   1671  CD  ARG B  63      -9.106 -23.001  13.806  1.00 53.76           C  
ATOM   1672  NE  ARG B  63      -8.637 -23.734  14.974  1.00 57.61           N  
ATOM   1673  CZ  ARG B  63      -7.721 -23.264  15.823  1.00 56.69           C  
ATOM   1674  NH1 ARG B  63      -7.210 -22.055  15.628  1.00 52.54           N  
ATOM   1675  NH2 ARG B  63      -7.339 -24.005  16.865  1.00 54.73           N  
ATOM   1676  N   LEU B  64      -5.841 -23.292  10.044  1.00 46.52           N  
ATOM   1677  CA  LEU B  64      -4.609 -22.452  10.037  1.00 46.51           C  
ATOM   1678  C   LEU B  64      -4.818 -21.096  10.724  1.00 46.79           C  
ATOM   1679  O   LEU B  64      -5.802 -20.396  10.476  1.00 47.14           O  
ATOM   1680  CB  LEU B  64      -4.068 -22.220   8.613  1.00 46.06           C  
ATOM   1681  CG  LEU B  64      -4.096 -23.280   7.484  1.00 47.58           C  
ATOM   1682  CD1 LEU B  64      -3.222 -22.877   6.305  1.00 46.52           C  
ATOM   1683  CD2 LEU B  64      -3.668 -24.657   7.970  1.00 46.83           C  
ATOM   1684  N   ASP B  65      -3.871 -20.714  11.560  1.00 47.31           N  
ATOM   1685  CA  ASP B  65      -3.918 -19.469  12.276  1.00 47.99           C  
ATOM   1686  C   ASP B  65      -2.657 -18.676  11.985  1.00 47.56           C  
ATOM   1687  O   ASP B  65      -1.525 -19.111  12.263  1.00 47.73           O  
ATOM   1688  CB  ASP B  65      -4.043 -19.782  13.758  1.00 50.02           C  
ATOM   1689  CG  ASP B  65      -3.995 -18.556  14.641  1.00 54.87           C  
ATOM   1690  OD1 ASP B  65      -4.321 -17.443  14.165  1.00 61.66           O  
ATOM   1691  OD2 ASP B  65      -3.657 -18.719  15.854  1.00 61.63           O  
ATOM   1692  N   VAL B  66      -2.856 -17.514  11.375  1.00 46.32           N  
ATOM   1693  CA  VAL B  66      -1.769 -16.609  11.068  1.00 44.64           C  
ATOM   1694  C   VAL B  66      -1.312 -15.897  12.336  1.00 44.53           C  
ATOM   1695  O   VAL B  66      -2.067 -15.168  12.938  1.00 44.61           O  
ATOM   1696  CB  VAL B  66      -2.192 -15.586  10.000  1.00 43.42           C  
ATOM   1697  CG1 VAL B  66      -1.066 -14.590   9.728  1.00 43.36           C  
ATOM   1698  CG2 VAL B  66      -2.517 -16.298   8.748  1.00 42.76           C  
ATOM   1699  N   ARG B  67      -0.068 -16.097  12.725  1.00 44.85           N  
ATOM   1700  CA  ARG B  67       0.452 -15.486  13.950  1.00 45.44           C  
ATOM   1701  C   ARG B  67       1.125 -14.140  13.673  1.00 45.88           C  
ATOM   1702  O   ARG B  67       1.099 -13.253  14.503  1.00 45.88           O  
ATOM   1703  CB  ARG B  67       1.420 -16.448  14.651  1.00 45.16           C  
ATOM   1704  CG  ARG B  67       0.863 -17.843  14.858  1.00 46.74           C  
ATOM   1705  CD  ARG B  67      -0.412 -17.796  15.678  1.00 50.17           C  
ATOM   1706  NE  ARG B  67      -0.126 -17.652  17.095  1.00 55.94           N  
ATOM   1707  CZ  ARG B  67      -0.832 -16.897  17.942  1.00 60.77           C  
ATOM   1708  NH1 ARG B  67      -1.868 -16.172  17.521  1.00 62.21           N  
ATOM   1709  NH2 ARG B  67      -0.484 -16.847  19.226  1.00 62.03           N  
ATOM   1710  N   SER B  68       1.770 -14.020  12.515  1.00 46.19           N  
ATOM   1711  CA  SER B  68       2.138 -12.727  11.967  1.00 46.77           C  
ATOM   1712  C   SER B  68       2.560 -12.855  10.534  1.00 46.24           C  
ATOM   1713  O   SER B  68       2.794 -13.954  10.017  1.00 45.46           O  
ATOM   1714  CB  SER B  68       3.243 -12.019  12.752  1.00 47.23           C  
ATOM   1715  OG  SER B  68       4.252 -12.936  13.066  1.00 51.21           O  
ATOM   1716  N   ILE B  69       2.646 -11.697   9.900  1.00 46.03           N  
ATOM   1717  CA  ILE B  69       2.781 -11.634   8.473  1.00 46.29           C  
ATOM   1718  C   ILE B  69       3.608 -10.393   8.266  1.00 46.34           C  
ATOM   1719  O   ILE B  69       3.442  -9.433   9.016  1.00 46.42           O  
ATOM   1720  CB  ILE B  69       1.380 -11.611   7.784  1.00 46.78           C  
ATOM   1721  CG1 ILE B  69       1.505 -11.476   6.268  1.00 46.12           C  
ATOM   1722  CG2 ILE B  69       0.407 -10.554   8.459  1.00 45.91           C  
ATOM   1723  CD1 ILE B  69       0.206 -11.769   5.518  1.00 46.02           C  
ATOM   1724  N   VAL B  70       4.582 -10.478   7.357  1.00 46.27           N  
ATOM   1725  CA  VAL B  70       5.401  -9.337   6.953  1.00 46.50           C  
ATOM   1726  C   VAL B  70       5.512  -9.265   5.433  1.00 46.83           C  
ATOM   1727  O   VAL B  70       5.638 -10.278   4.759  1.00 46.75           O  
ATOM   1728  CB  VAL B  70       6.809  -9.368   7.555  1.00 46.54           C  
ATOM   1729  CG1 VAL B  70       6.755  -9.213   9.071  1.00 45.08           C  
ATOM   1730  CG2 VAL B  70       7.490 -10.642   7.186  1.00 47.17           C  
ATOM   1731  N   GLY B  71       5.441  -8.050   4.903  1.00 47.39           N  
ATOM   1732  CA  GLY B  71       5.583  -7.811   3.478  1.00 47.67           C  
ATOM   1733  C   GLY B  71       6.720  -6.858   3.193  1.00 48.05           C  
ATOM   1734  O   GLY B  71       6.937  -5.900   3.932  1.00 47.94           O  
ATOM   1735  N   GLU B  72       7.458  -7.135   2.126  1.00 48.51           N  
ATOM   1736  CA  GLU B  72       8.496  -6.220   1.662  1.00 49.30           C  
ATOM   1737  C   GLU B  72       8.642  -6.365   0.161  1.00 49.52           C  
ATOM   1738  O   GLU B  72       8.837  -7.476  -0.349  1.00 49.72           O  
ATOM   1739  CB  GLU B  72       9.825  -6.493   2.359  1.00 49.25           C  
ATOM   1740  CG  GLU B  72      10.800  -5.350   2.267  1.00 49.03           C  
ATOM   1741  CD  GLU B  72      12.150  -5.672   2.903  1.00 50.96           C  
ATOM   1742  OE1 GLU B  72      12.345  -6.817   3.377  1.00 51.19           O  
ATOM   1743  OE2 GLU B  72      13.027  -4.777   2.922  1.00 51.40           O  
ATOM   1744  N   GLY B  73       8.535  -5.240  -0.543  1.00 49.62           N  
ATOM   1745  CA  GLY B  73       8.571  -5.259  -1.998  1.00 49.59           C  
ATOM   1746  C   GLY B  73       7.515  -6.203  -2.546  1.00 49.84           C  
ATOM   1747  O   GLY B  73       6.314  -5.988  -2.361  1.00 49.40           O  
ATOM   1748  N   ASP B  74       7.969  -7.260  -3.210  1.00 49.90           N  
ATOM   1749  CA  ASP B  74       7.064  -8.216  -3.817  1.00 50.31           C  
ATOM   1750  C   ASP B  74       6.966  -9.503  -2.993  1.00 50.35           C  
ATOM   1751  O   ASP B  74       6.271 -10.445  -3.381  1.00 50.58           O  
ATOM   1752  CB  ASP B  74       7.467  -8.499  -5.281  1.00 50.82           C  
ATOM   1753  CG  ASP B  74       8.962  -8.801  -5.452  1.00 52.39           C  
ATOM   1754  OD1 ASP B  74       9.620  -9.267  -4.494  1.00 52.20           O  
ATOM   1755  OD2 ASP B  74       9.489  -8.565  -6.573  1.00 55.73           O  
ATOM   1756  N   ARG B  75       7.646  -9.523  -1.848  1.00 49.94           N  
ATOM   1757  CA  ARG B  75       7.690 -10.695  -0.998  1.00 49.87           C  
ATOM   1758  C   ARG B  75       6.782 -10.609   0.240  1.00 49.69           C  
ATOM   1759  O   ARG B  75       6.580  -9.532   0.819  1.00 49.80           O  
ATOM   1760  CB  ARG B  75       9.127 -10.946  -0.563  1.00 50.44           C  
ATOM   1761  CG  ARG B  75      10.032 -11.604  -1.607  1.00 51.76           C  
ATOM   1762  CD  ARG B  75      11.350 -11.937  -0.959  1.00 56.91           C  
ATOM   1763  NE  ARG B  75      12.192 -12.749  -1.828  1.00 63.54           N  
ATOM   1764  CZ  ARG B  75      12.452 -14.046  -1.649  1.00 66.17           C  
ATOM   1765  NH1 ARG B  75      13.246 -14.680  -2.516  1.00 67.51           N  
ATOM   1766  NH2 ARG B  75      11.935 -14.711  -0.613  1.00 66.95           N  
ATOM   1767  N   VAL B  76       6.245 -11.758   0.644  1.00 48.86           N  
ATOM   1768  CA  VAL B  76       5.542 -11.904   1.917  1.00 48.09           C  
ATOM   1769  C   VAL B  76       6.035 -13.151   2.641  1.00 48.66           C  
ATOM   1770  O   VAL B  76       6.157 -14.210   2.015  1.00 48.23           O  
ATOM   1771  CB  VAL B  76       3.989 -12.091   1.748  1.00 48.35           C  
ATOM   1772  CG1 VAL B  76       3.299 -12.274   3.125  1.00 44.83           C  
ATOM   1773  CG2 VAL B  76       3.339 -10.935   0.952  1.00 47.11           C  
HETATM 1774  N   MSE B  77       6.263 -13.046   3.952  1.00 49.06           N  
HETATM 1775  CA  MSE B  77       6.425 -14.237   4.795  1.00 51.37           C  
HETATM 1776  C   MSE B  77       5.339 -14.320   5.860  1.00 49.84           C  
HETATM 1777  O   MSE B  77       4.960 -13.292   6.425  1.00 50.41           O  
HETATM 1778  CB  MSE B  77       7.819 -14.283   5.443  1.00 50.48           C  
HETATM 1779  CG  MSE B  77       8.968 -14.457   4.441  1.00 52.49           C  
HETATM 1780 SE   MSE B  77      10.691 -14.891   5.289  1.00 60.13          SE  
HETATM 1781  CE  MSE B  77      11.804 -13.786   4.452  1.00 53.43           C  
ATOM   1782  N   LEU B  78       4.848 -15.522   6.163  1.00 48.87           N  
ATOM   1783  CA  LEU B  78       3.923 -15.675   7.302  1.00 48.43           C  
ATOM   1784  C   LEU B  78       4.275 -16.795   8.253  1.00 47.74           C  
ATOM   1785  O   LEU B  78       4.664 -17.868   7.804  1.00 47.92           O  
ATOM   1786  CB  LEU B  78       2.498 -16.003   6.859  1.00 48.33           C  
ATOM   1787  CG  LEU B  78       1.694 -15.474   5.711  1.00 48.18           C  
ATOM   1788  CD1 LEU B  78       2.323 -15.819   4.349  1.00 45.49           C  
ATOM   1789  CD2 LEU B  78       0.355 -16.168   5.919  1.00 46.80           C  
ATOM   1790  N   ARG B  79       4.074 -16.559   9.552  1.00 46.87           N  
ATOM   1791  CA  ARG B  79       4.217 -17.597  10.565  1.00 46.27           C  
ATOM   1792  C   ARG B  79       2.835 -18.165  10.893  1.00 46.98           C  
ATOM   1793  O   ARG B  79       1.984 -17.464  11.485  1.00 46.90           O  
ATOM   1794  CB  ARG B  79       4.874 -17.055  11.829  1.00 46.06           C  
ATOM   1795  CG  ARG B  79       4.905 -18.081  12.978  1.00 44.69           C  
ATOM   1796  CD  ARG B  79       5.969 -17.808  14.051  1.00 45.49           C  
ATOM   1797  NE  ARG B  79       5.789 -16.507  14.671  1.00 45.33           N  
ATOM   1798  CZ  ARG B  79       4.956 -16.232  15.683  1.00 45.09           C  
ATOM   1799  NH1 ARG B  79       4.208 -17.170  16.231  1.00 41.93           N  
ATOM   1800  NH2 ARG B  79       4.867 -14.985  16.149  1.00 44.67           N  
ATOM   1801  N   ILE B  80       2.624 -19.423  10.493  1.00 46.83           N  
ATOM   1802  CA  ILE B  80       1.345 -20.112  10.643  1.00 46.36           C  
ATOM   1803  C   ILE B  80       1.411 -21.339  11.561  1.00 47.41           C  
ATOM   1804  O   ILE B  80       2.327 -22.162  11.459  1.00 47.52           O  
ATOM   1805  CB  ILE B  80       0.782 -20.570   9.279  1.00 46.56           C  
ATOM   1806  CG1 ILE B  80       0.677 -19.383   8.311  1.00 46.02           C  
ATOM   1807  CG2 ILE B  80      -0.569 -21.255   9.460  1.00 45.40           C  
ATOM   1808  CD1 ILE B  80       0.356 -19.752   6.881  1.00 44.08           C  
ATOM   1809  N   THR B  81       0.412 -21.440  12.436  1.00 48.25           N  
ATOM   1810  CA  THR B  81       0.201 -22.573  13.310  1.00 49.04           C  
ATOM   1811  C   THR B  81      -1.027 -23.337  12.818  1.00 49.63           C  
ATOM   1812  O   THR B  81      -2.104 -22.754  12.596  1.00 50.14           O  
ATOM   1813  CB  THR B  81      -0.037 -22.085  14.741  1.00 49.48           C  
ATOM   1814  OG1 THR B  81       1.202 -21.638  15.307  1.00 49.30           O  
ATOM   1815  CG2 THR B  81      -0.590 -23.194  15.606  1.00 50.73           C  
ATOM   1816  N   CYS B  82      -0.843 -24.638  12.624  1.00 49.87           N  
ATOM   1817  CA  CYS B  82      -1.906 -25.513  12.140  0.50 49.63           C  
ATOM   1819  C   CYS B  82      -2.336 -26.436  13.280  1.00 49.82           C  
ATOM   1820  O   CYS B  82      -1.512 -26.868  14.113  1.00 50.73           O  
ATOM   1821  CB  CYS B  82      -1.442 -26.325  10.920  0.50 49.70           C  
ATOM   1823  SG  CYS B  82      -2.750 -27.317  10.021  0.50 50.64           S  
ATOM   1825  N   SER B  83      -3.625 -26.726  13.336  1.00 48.82           N  
ATOM   1826  CA  SER B  83      -4.089 -27.675  14.323  1.00 48.81           C  
ATOM   1827  C   SER B  83      -5.174 -28.494  13.683  1.00 48.22           C  
ATOM   1828  O   SER B  83      -5.873 -27.990  12.831  1.00 48.24           O  
ATOM   1829  CB  SER B  83      -4.548 -26.991  15.608  1.00 48.70           C  
ATOM   1830  OG  SER B  83      -5.653 -26.172  15.355  1.00 51.06           O  
ATOM   1831  N   ALA B  84      -5.282 -29.763  14.063  1.00 47.80           N  
ATOM   1832  CA  ALA B  84      -6.208 -30.686  13.411  1.00 47.23           C  
ATOM   1833  C   ALA B  84      -6.307 -31.948  14.251  1.00 46.98           C  
ATOM   1834  O   ALA B  84      -5.525 -32.144  15.175  1.00 47.05           O  
ATOM   1835  CB  ALA B  84      -5.679 -31.034  12.014  1.00 47.01           C  
ATOM   1836  N   THR B  85      -7.225 -32.830  13.909  1.00 46.54           N  
ATOM   1837  CA  THR B  85      -7.166 -34.156  14.479  1.00 47.00           C  
ATOM   1838  C   THR B  85      -6.763 -35.098  13.350  1.00 45.88           C  
ATOM   1839  O   THR B  85      -7.207 -34.935  12.219  1.00 45.26           O  
ATOM   1840  CB  THR B  85      -8.503 -34.595  15.135  1.00 47.12           C  
ATOM   1841  OG1 THR B  85      -9.480 -34.675  14.119  1.00 50.88           O  
ATOM   1842  CG2 THR B  85      -9.002 -33.563  16.117  1.00 47.02           C  
ATOM   1843  N   HIS B  86      -5.900 -36.058  13.667  1.00 44.77           N  
ATOM   1844  CA  HIS B  86      -5.408 -36.982  12.683  1.00 44.52           C  
ATOM   1845  C   HIS B  86      -6.445 -38.092  12.449  1.00 44.25           C  
ATOM   1846  O   HIS B  86      -6.520 -39.059  13.214  1.00 43.50           O  
ATOM   1847  CB  HIS B  86      -4.054 -37.541  13.123  1.00 44.53           C  
ATOM   1848  CG  HIS B  86      -3.442 -38.497  12.150  1.00 44.83           C  
ATOM   1849  ND1 HIS B  86      -2.318 -39.237  12.450  1.00 46.48           N  
ATOM   1850  CD2 HIS B  86      -3.796 -38.845  10.889  1.00 45.49           C  
ATOM   1851  CE1 HIS B  86      -2.007 -40.002  11.414  1.00 46.44           C  
ATOM   1852  NE2 HIS B  86      -2.893 -39.789  10.455  1.00 46.52           N  
ATOM   1853  N   GLN B  87      -7.241 -37.921  11.391  1.00 44.03           N  
ATOM   1854  CA  GLN B  87      -8.365 -38.817  11.085  1.00 44.50           C  
ATOM   1855  C   GLN B  87      -8.109 -39.815   9.968  1.00 43.47           C  
ATOM   1856  O   GLN B  87      -8.626 -40.911  10.041  1.00 43.45           O  
ATOM   1857  CB  GLN B  87      -9.580 -38.013  10.679  1.00 45.06           C  
ATOM   1858  CG  GLN B  87     -10.014 -36.998  11.717  1.00 52.15           C  
ATOM   1859  CD  GLN B  87     -11.242 -37.470  12.448  1.00 60.53           C  
ATOM   1860  OE1 GLN B  87     -12.369 -37.068  12.093  1.00 63.46           O  
ATOM   1861  NE2 GLN B  87     -11.050 -38.375  13.448  1.00 59.72           N  
ATOM   1862  N   GLY B  88      -7.362 -39.419   8.932  1.00 42.86           N  
ATOM   1863  CA  GLY B  88      -7.085 -40.260   7.782  1.00 42.89           C  
ATOM   1864  C   GLY B  88      -5.646 -40.731   7.716  1.00 43.49           C  
ATOM   1865  O   GLY B  88      -4.770 -40.212   8.415  1.00 43.45           O  
ATOM   1866  N   VAL B  89      -5.391 -41.734   6.890  1.00 43.99           N  
ATOM   1867  CA  VAL B  89      -4.032 -42.153   6.641  1.00 45.32           C  
ATOM   1868  C   VAL B  89      -3.351 -40.955   6.002  1.00 46.55           C  
ATOM   1869  O   VAL B  89      -3.906 -40.336   5.109  1.00 46.58           O  
ATOM   1870  CB  VAL B  89      -3.969 -43.370   5.680  1.00 45.40           C  
ATOM   1871  CG1 VAL B  89      -2.517 -43.698   5.282  1.00 43.32           C  
ATOM   1872  CG2 VAL B  89      -4.669 -44.584   6.298  1.00 44.83           C  
ATOM   1873  N   PHE B  90      -2.181 -40.590   6.485  1.00 48.28           N  
ATOM   1874  CA  PHE B  90      -1.436 -39.518   5.834  1.00 50.70           C  
ATOM   1875  C   PHE B  90      -0.059 -40.015   5.449  1.00 52.62           C  
ATOM   1876  O   PHE B  90       0.693 -40.473   6.310  1.00 52.50           O  
ATOM   1877  CB  PHE B  90      -1.332 -38.278   6.728  1.00 50.19           C  
ATOM   1878  CG  PHE B  90      -0.653 -37.122   6.061  1.00 50.11           C  
ATOM   1879  CD1 PHE B  90      -1.253 -36.478   4.981  1.00 48.35           C  
ATOM   1880  CD2 PHE B  90       0.604 -36.690   6.491  1.00 50.97           C  
ATOM   1881  CE1 PHE B  90      -0.630 -35.418   4.346  1.00 48.11           C  
ATOM   1882  CE2 PHE B  90       1.249 -35.618   5.861  1.00 50.19           C  
ATOM   1883  CZ  PHE B  90       0.626 -34.981   4.784  1.00 49.69           C  
HETATM 1884  N   MSE B  91       0.261 -39.952   4.159  1.00 55.26           N  
HETATM 1885  CA  MSE B  91       1.558 -40.450   3.660  1.00 59.73           C  
HETATM 1886  C   MSE B  91       1.949 -41.759   4.343  1.00 56.67           C  
HETATM 1887  O   MSE B  91       3.040 -41.867   4.927  1.00 56.40           O  
HETATM 1888  CB  MSE B  91       2.677 -39.419   3.878  1.00 58.96           C  
HETATM 1889  CG  MSE B  91       2.402 -38.053   3.287  1.00 63.74           C  
HETATM 1890 SE   MSE B  91       3.918 -36.793   3.458  1.00 73.63          SE  
HETATM 1891  CE  MSE B  91       4.448 -36.902   5.532  1.00 72.77           C  
ATOM   1892  N   GLY B  92       1.030 -42.727   4.296  1.00 55.25           N  
ATOM   1893  CA  GLY B  92       1.247 -44.048   4.871  1.00 52.50           C  
ATOM   1894  C   GLY B  92       1.202 -44.132   6.383  1.00 51.01           C  
ATOM   1895  O   GLY B  92       1.501 -45.171   6.950  1.00 50.70           O  
ATOM   1896  N   ILE B  93       0.839 -43.047   7.049  1.00 49.95           N  
ATOM   1897  CA  ILE B  93       0.761 -43.066   8.505  1.00 49.21           C  
ATOM   1898  C   ILE B  93      -0.698 -43.191   8.949  1.00 48.43           C  
ATOM   1899  O   ILE B  93      -1.495 -42.263   8.775  1.00 48.32           O  
ATOM   1900  CB  ILE B  93       1.478 -41.838   9.139  1.00 49.15           C  
ATOM   1901  CG1 ILE B  93       2.966 -41.853   8.740  1.00 49.79           C  
ATOM   1902  CG2 ILE B  93       1.343 -41.875  10.652  1.00 48.72           C  
ATOM   1903  CD1 ILE B  93       3.710 -40.529   8.941  1.00 49.81           C  
ATOM   1904  N   ALA B  94      -1.035 -44.354   9.501  1.00 47.69           N  
ATOM   1905  CA  ALA B  94      -2.397 -44.659   9.974  1.00 47.45           C  
ATOM   1906  C   ALA B  94      -2.848 -43.644  11.040  1.00 47.11           C  
ATOM   1907  O   ALA B  94      -2.030 -43.165  11.816  1.00 47.72           O  
ATOM   1908  CB  ALA B  94      -2.478 -46.090  10.491  1.00 46.47           C  
ATOM   1909  N   PRO B  95      -4.138 -43.272  11.044  1.00 46.78           N  
ATOM   1910  CA  PRO B  95      -4.627 -42.221  11.961  1.00 46.71           C  
ATOM   1911  C   PRO B  95      -4.624 -42.579  13.450  1.00 46.79           C  
ATOM   1912  O   PRO B  95      -4.783 -43.747  13.818  1.00 45.99           O  
ATOM   1913  CB  PRO B  95      -6.063 -41.970  11.493  1.00 46.24           C  
ATOM   1914  CG  PRO B  95      -6.457 -43.224  10.759  1.00 46.84           C  
ATOM   1915  CD  PRO B  95      -5.198 -43.787  10.159  1.00 46.50           C  
ATOM   1916  N   THR B  96      -4.475 -41.558  14.294  1.00 47.17           N  
ATOM   1917  CA  THR B  96      -4.398 -41.772  15.737  1.00 47.33           C  
ATOM   1918  C   THR B  96      -5.581 -41.164  16.441  1.00 47.14           C  
ATOM   1919  O   THR B  96      -5.799 -41.445  17.608  1.00 46.66           O  
ATOM   1920  CB  THR B  96      -3.109 -41.155  16.341  1.00 47.53           C  
ATOM   1921  OG1 THR B  96      -3.121 -39.728  16.135  1.00 48.42           O  
ATOM   1922  CG2 THR B  96      -1.868 -41.769  15.695  1.00 45.67           C  
ATOM   1923  N   GLY B  97      -6.323 -40.319  15.721  1.00 47.68           N  
ATOM   1924  CA  GLY B  97      -7.430 -39.539  16.279  1.00 47.72           C  
ATOM   1925  C   GLY B  97      -6.992 -38.425  17.215  1.00 48.26           C  
ATOM   1926  O   GLY B  97      -7.819 -37.763  17.834  1.00 48.15           O  
ATOM   1927  N   ARG B  98      -5.692 -38.210  17.345  1.00 48.95           N  
ATOM   1928  CA  ARG B  98      -5.242 -37.185  18.256  1.00 50.59           C  
ATOM   1929  C   ARG B  98      -5.297 -35.787  17.670  1.00 50.77           C  
ATOM   1930  O   ARG B  98      -5.219 -35.608  16.447  1.00 50.96           O  
ATOM   1931  CB  ARG B  98      -3.837 -37.482  18.759  1.00 51.23           C  
ATOM   1932  CG  ARG B  98      -3.818 -38.583  19.809  1.00 53.49           C  
ATOM   1933  CD  ARG B  98      -2.413 -38.756  20.336  1.00 58.11           C  
ATOM   1934  NE  ARG B  98      -1.409 -39.129  19.317  1.00 59.15           N  
ATOM   1935  CZ  ARG B  98      -0.753 -40.297  19.327  1.00 59.65           C  
ATOM   1936  NH1 ARG B  98      -1.026 -41.198  20.274  1.00 58.24           N  
ATOM   1937  NH2 ARG B  98       0.170 -40.571  18.406  1.00 57.51           N  
ATOM   1938  N   LYS B  99      -5.455 -34.812  18.563  1.00 50.83           N  
ATOM   1939  CA  LYS B  99      -5.184 -33.420  18.270  1.00 51.13           C  
ATOM   1940  C   LYS B  99      -3.703 -33.280  17.948  1.00 51.16           C  
ATOM   1941  O   LYS B  99      -2.852 -33.658  18.748  1.00 50.86           O  
ATOM   1942  CB  LYS B  99      -5.529 -32.530  19.468  1.00 51.34           C  
ATOM   1943  CG  LYS B  99      -7.031 -32.387  19.730  1.00 53.22           C  
ATOM   1944  CD  LYS B  99      -7.611 -32.083  20.871  0.00 50.00           C  
ATOM   1945  CE  LYS B  99      -9.027 -32.316  20.580  0.00 50.00           C  
ATOM   1946  NZ  LYS B  99      -9.906 -32.191  19.384  0.00 50.00           N  
ATOM   1947  N   VAL B 100      -3.403 -32.736  16.774  1.00 51.09           N  
ATOM   1948  CA  VAL B 100      -2.019 -32.516  16.366  1.00 51.49           C  
ATOM   1949  C   VAL B 100      -1.758 -31.039  16.043  1.00 51.88           C  
ATOM   1950  O   VAL B 100      -2.681 -30.290  15.702  1.00 52.31           O  
ATOM   1951  CB  VAL B 100      -1.617 -33.435  15.159  1.00 51.54           C  
ATOM   1952  CG1 VAL B 100      -1.439 -34.876  15.635  1.00 51.08           C  
ATOM   1953  CG2 VAL B 100      -2.653 -33.344  14.027  1.00 50.13           C  
ATOM   1954  N   ARG B 101      -0.497 -30.633  16.116  1.00 52.21           N  
ATOM   1955  CA  ARG B 101      -0.153 -29.223  16.043  1.00 52.69           C  
ATOM   1956  C   ARG B 101       1.204 -29.043  15.408  1.00 51.24           C  
ATOM   1957  O   ARG B 101       2.160 -29.698  15.811  1.00 51.75           O  
ATOM   1958  CB  ARG B 101      -0.121 -28.655  17.460  1.00 53.42           C  
ATOM   1959  CG  ARG B 101      -0.885 -27.375  17.606  1.00 58.89           C  
ATOM   1960  CD  ARG B 101      -1.280 -27.149  19.073  1.00 65.67           C  
ATOM   1961  NE  ARG B 101      -2.320 -26.119  19.194  1.00 69.43           N  
ATOM   1962  CZ  ARG B 101      -2.131 -24.900  19.707  0.50 69.81           C  
ATOM   1963  NH1 ARG B 101      -3.150 -24.044  19.773  0.50 69.43           N  
ATOM   1964  NH2 ARG B 101      -0.936 -24.534  20.166  0.50 69.66           N  
ATOM   1965  N   TRP B 102       1.306 -28.156  14.427  1.00 49.95           N  
ATOM   1966  CA  TRP B 102       2.610 -27.786  13.899  1.00 48.92           C  
ATOM   1967  C   TRP B 102       2.609 -26.349  13.369  1.00 48.28           C  
ATOM   1968  O   TRP B 102       1.560 -25.819  13.030  1.00 47.76           O  
ATOM   1969  CB  TRP B 102       3.064 -28.798  12.818  1.00 49.45           C  
ATOM   1970  CG  TRP B 102       2.240 -28.807  11.555  1.00 49.17           C  
ATOM   1971  CD1 TRP B 102       2.550 -28.185  10.384  1.00 50.71           C  
ATOM   1972  CD2 TRP B 102       0.985 -29.473  11.327  1.00 49.39           C  
ATOM   1973  NE1 TRP B 102       1.567 -28.404   9.439  1.00 49.60           N  
ATOM   1974  CE2 TRP B 102       0.597 -29.193   9.988  1.00 49.45           C  
ATOM   1975  CE3 TRP B 102       0.150 -30.275  12.116  1.00 51.93           C  
ATOM   1976  CZ2 TRP B 102      -0.588 -29.681   9.423  1.00 51.41           C  
ATOM   1977  CZ3 TRP B 102      -1.053 -30.769  11.546  1.00 51.20           C  
ATOM   1978  CH2 TRP B 102      -1.405 -30.462  10.217  1.00 51.48           C  
ATOM   1979  N   THR B 103       3.799 -25.755  13.272  1.00 47.65           N  
ATOM   1980  CA  THR B 103       4.001 -24.384  12.845  1.00 46.94           C  
ATOM   1981  C   THR B 103       4.982 -24.345  11.657  1.00 47.46           C  
ATOM   1982  O   THR B 103       5.872 -25.175  11.567  1.00 48.15           O  
ATOM   1983  CB  THR B 103       4.549 -23.557  14.021  1.00 46.60           C  
ATOM   1984  OG1 THR B 103       3.682 -23.719  15.146  1.00 46.46           O  
ATOM   1985  CG2 THR B 103       4.627 -22.057  13.690  1.00 45.51           C  
ATOM   1986  N   TYR B 104       4.816 -23.394  10.746  1.00 47.23           N  
ATOM   1987  CA  TYR B 104       5.742 -23.215   9.628  1.00 47.43           C  
ATOM   1988  C   TYR B 104       5.650 -21.777   9.155  1.00 47.93           C  
ATOM   1989  O   TYR B 104       4.721 -21.068   9.525  1.00 48.08           O  
ATOM   1990  CB  TYR B 104       5.404 -24.164   8.451  1.00 47.53           C  
ATOM   1991  CG  TYR B 104       3.967 -24.046   7.917  1.00 47.03           C  
ATOM   1992  CD1 TYR B 104       2.921 -24.702   8.562  1.00 46.19           C  
ATOM   1993  CD2 TYR B 104       3.669 -23.305   6.762  1.00 44.89           C  
ATOM   1994  CE1 TYR B 104       1.621 -24.619   8.097  1.00 46.57           C  
ATOM   1995  CE2 TYR B 104       2.356 -23.209   6.279  1.00 45.14           C  
ATOM   1996  CZ  TYR B 104       1.341 -23.867   6.966  1.00 47.91           C  
ATOM   1997  OH  TYR B 104       0.030 -23.810   6.554  1.00 49.15           O  
ATOM   1998  N   LEU B 105       6.598 -21.360   8.322  1.00 49.22           N  
ATOM   1999  CA  LEU B 105       6.631 -20.007   7.773  1.00 50.42           C  
ATOM   2000  C   LEU B 105       6.503 -20.108   6.276  1.00 51.01           C  
ATOM   2001  O   LEU B 105       7.373 -20.690   5.642  1.00 50.99           O  
ATOM   2002  CB  LEU B 105       7.960 -19.289   8.107  1.00 51.00           C  
ATOM   2003  CG  LEU B 105       8.054 -18.421   9.382  1.00 51.66           C  
ATOM   2004  CD1 LEU B 105       7.781 -19.208  10.654  1.00 49.01           C  
ATOM   2005  CD2 LEU B 105       9.412 -17.695   9.490  1.00 50.30           C  
ATOM   2006  N   GLU B 106       5.423 -19.562   5.710  1.00 51.52           N  
ATOM   2007  CA  GLU B 106       5.285 -19.511   4.268  1.00 52.02           C  
ATOM   2008  C   GLU B 106       6.075 -18.339   3.720  1.00 52.49           C  
ATOM   2009  O   GLU B 106       6.224 -17.304   4.394  1.00 52.79           O  
ATOM   2010  CB  GLU B 106       3.827 -19.439   3.838  1.00 52.53           C  
ATOM   2011  CG  GLU B 106       3.240 -20.824   3.515  1.00 54.63           C  
ATOM   2012  CD  GLU B 106       2.024 -20.755   2.601  0.50 55.12           C  
ATOM   2013  OE1 GLU B 106       1.512 -19.625   2.397  0.50 54.31           O  
ATOM   2014  OE2 GLU B 106       1.589 -21.829   2.096  0.50 54.36           O  
ATOM   2015  N   GLU B 107       6.589 -18.514   2.501  1.00 51.88           N  
ATOM   2016  CA  GLU B 107       7.425 -17.518   1.877  1.00 51.28           C  
ATOM   2017  C   GLU B 107       7.049 -17.457   0.400  1.00 50.55           C  
ATOM   2018  O   GLU B 107       7.206 -18.444  -0.334  1.00 50.40           O  
ATOM   2019  CB  GLU B 107       8.886 -17.906   2.089  1.00 51.40           C  
ATOM   2020  CG  GLU B 107       9.945 -17.056   1.378  1.00 51.74           C  
ATOM   2021  CD  GLU B 107      11.348 -17.618   1.611  1.00 52.39           C  
ATOM   2022  OE1 GLU B 107      11.511 -18.459   2.522  1.00 52.74           O  
ATOM   2023  OE2 GLU B 107      12.288 -17.235   0.884  1.00 55.11           O  
ATOM   2024  N   LEU B 108       6.531 -16.305  -0.025  1.00 49.60           N  
ATOM   2025  CA  LEU B 108       6.013 -16.156  -1.396  1.00 49.25           C  
ATOM   2026  C   LEU B 108       6.443 -14.851  -2.052  1.00 48.71           C  
ATOM   2027  O   LEU B 108       6.693 -13.857  -1.365  1.00 48.44           O  
ATOM   2028  CB  LEU B 108       4.475 -16.254  -1.431  1.00 48.85           C  
ATOM   2029  CG  LEU B 108       3.751 -17.292  -0.579  1.00 48.65           C  
ATOM   2030  CD1 LEU B 108       3.205 -16.625   0.647  1.00 49.64           C  
ATOM   2031  CD2 LEU B 108       2.596 -17.916  -1.340  1.00 49.64           C  
ATOM   2032  N   ARG B 109       6.519 -14.858  -3.383  1.00 48.48           N  
ATOM   2033  CA  ARG B 109       6.733 -13.623  -4.150  1.00 48.23           C  
ATOM   2034  C   ARG B 109       5.571 -13.453  -5.099  1.00 47.76           C  
ATOM   2035  O   ARG B 109       5.129 -14.419  -5.717  1.00 47.27           O  
ATOM   2036  CB  ARG B 109       8.068 -13.651  -4.910  1.00 48.22           C  
ATOM   2037  CG  ARG B 109       8.358 -12.361  -5.707  1.00 49.55           C  
ATOM   2038  CD  ARG B 109       9.795 -12.278  -6.193  1.00 48.94           C  
ATOM   2039  NE  ARG B 109       9.968 -13.039  -7.423  1.00 52.58           N  
ATOM   2040  CZ  ARG B 109       9.682 -12.585  -8.648  1.00 54.14           C  
ATOM   2041  NH1 ARG B 109       9.199 -11.355  -8.820  1.00 54.59           N  
ATOM   2042  NH2 ARG B 109       9.871 -13.366  -9.713  1.00 53.68           N  
ATOM   2043  N   PHE B 110       5.076 -12.225  -5.211  1.00 48.29           N  
ATOM   2044  CA  PHE B 110       3.944 -11.907  -6.100  1.00 49.05           C  
ATOM   2045  C   PHE B 110       4.339 -11.061  -7.327  1.00 49.83           C  
ATOM   2046  O   PHE B 110       5.175 -10.161  -7.238  1.00 49.83           O  
ATOM   2047  CB  PHE B 110       2.826 -11.166  -5.341  1.00 48.70           C  
ATOM   2048  CG  PHE B 110       2.182 -11.969  -4.222  1.00 49.23           C  
ATOM   2049  CD1 PHE B 110       2.800 -12.076  -2.963  1.00 48.07           C  
ATOM   2050  CD2 PHE B 110       0.955 -12.596  -4.417  1.00 47.92           C  
ATOM   2051  CE1 PHE B 110       2.210 -12.791  -1.932  1.00 48.66           C  
ATOM   2052  CE2 PHE B 110       0.350 -13.318  -3.390  1.00 46.59           C  
ATOM   2053  CZ  PHE B 110       0.969 -13.413  -2.144  1.00 47.92           C  
ATOM   2054  N   SER B 111       3.704 -11.367  -8.459  1.00 50.56           N  
ATOM   2055  CA  SER B 111       3.657 -10.498  -9.627  1.00 51.04           C  
ATOM   2056  C   SER B 111       2.946  -9.190  -9.269  1.00 51.75           C  
ATOM   2057  O   SER B 111       2.385  -9.056  -8.173  1.00 51.86           O  
ATOM   2058  CB  SER B 111       2.903 -11.192 -10.770  1.00 51.02           C  
ATOM   2059  OG  SER B 111       1.499 -11.057 -10.622  1.00 50.00           O  
ATOM   2060  N   GLU B 112       2.946  -8.233 -10.200  1.00 52.13           N  
ATOM   2061  CA  GLU B 112       2.382  -6.913  -9.919  1.00 52.33           C  
ATOM   2062  C   GLU B 112       0.855  -6.980  -9.784  1.00 52.39           C  
ATOM   2063  O   GLU B 112       0.241  -6.178  -9.071  1.00 52.46           O  
ATOM   2064  CB  GLU B 112       2.780  -5.908 -11.000  1.00 52.49           C  
ATOM   2065  CG  GLU B 112       3.999  -6.306 -11.849  0.50 52.46           C  
ATOM   2066  CD  GLU B 112       3.635  -6.656 -13.297  0.50 52.22           C  
ATOM   2067  OE1 GLU B 112       4.096  -5.938 -14.220  0.50 50.07           O  
ATOM   2068  OE2 GLU B 112       2.886  -7.640 -13.505  0.50 51.71           O  
ATOM   2069  N   ALA B 113       0.256  -7.942 -10.481  1.00 52.23           N  
ATOM   2070  CA  ALA B 113      -1.189  -8.132 -10.486  1.00 52.14           C  
ATOM   2071  C   ALA B 113      -1.672  -8.935  -9.262  1.00 52.11           C  
ATOM   2072  O   ALA B 113      -2.859  -9.242  -9.151  1.00 52.17           O  
ATOM   2073  CB  ALA B 113      -1.620  -8.813 -11.790  1.00 51.90           C  
ATOM   2074  N   GLY B 114      -0.750  -9.277  -8.355  1.00 51.87           N  
ATOM   2075  CA  GLY B 114      -1.104  -9.945  -7.098  1.00 51.12           C  
ATOM   2076  C   GLY B 114      -1.205 -11.459  -7.163  1.00 50.60           C  
ATOM   2077  O   GLY B 114      -1.895 -12.068  -6.358  1.00 51.14           O  
ATOM   2078  N   LYS B 115      -0.523 -12.078  -8.119  1.00 50.21           N  
ATOM   2079  CA  LYS B 115      -0.543 -13.534  -8.249  1.00 49.66           C  
ATOM   2080  C   LYS B 115       0.773 -14.093  -7.763  1.00 49.43           C  
ATOM   2081  O   LYS B 115       1.840 -13.511  -8.027  1.00 48.92           O  
ATOM   2082  CB  LYS B 115      -0.746 -13.965  -9.711  1.00 49.78           C  
ATOM   2083  CG  LYS B 115      -2.008 -13.462 -10.368  1.00 49.88           C  
ATOM   2084  CD  LYS B 115      -3.243 -14.076  -9.732  1.00 51.32           C  
ATOM   2085  CE  LYS B 115      -4.365 -14.192 -10.738  1.00 51.31           C  
ATOM   2086  NZ  LYS B 115      -5.271 -15.270 -10.331  1.00 51.59           N  
ATOM   2087  N   VAL B 116       0.709 -15.230  -7.070  1.00 48.91           N  
ATOM   2088  CA  VAL B 116       1.928 -15.920  -6.659  1.00 48.35           C  
ATOM   2089  C   VAL B 116       2.713 -16.319  -7.916  1.00 48.52           C  
ATOM   2090  O   VAL B 116       2.144 -16.874  -8.856  1.00 47.89           O  
ATOM   2091  CB  VAL B 116       1.648 -17.163  -5.805  1.00 48.34           C  
ATOM   2092  CG1 VAL B 116       2.966 -17.804  -5.373  1.00 47.35           C  
ATOM   2093  CG2 VAL B 116       0.751 -16.814  -4.570  1.00 47.58           C  
ATOM   2094  N   VAL B 117       4.003 -15.992  -7.932  1.00 48.71           N  
ATOM   2095  CA  VAL B 117       4.901 -16.412  -9.014  1.00 49.56           C  
ATOM   2096  C   VAL B 117       6.039 -17.315  -8.490  1.00 49.57           C  
ATOM   2097  O   VAL B 117       6.637 -18.065  -9.247  1.00 49.17           O  
ATOM   2098  CB  VAL B 117       5.392 -15.189  -9.877  1.00 49.46           C  
ATOM   2099  CG1 VAL B 117       6.241 -14.205  -9.048  1.00 49.61           C  
ATOM   2100  CG2 VAL B 117       6.130 -15.649 -11.121  1.00 51.52           C  
ATOM   2101  N   GLU B 118       6.295 -17.271  -7.182  1.00 50.33           N  
ATOM   2102  CA  GLU B 118       7.315 -18.127  -6.552  1.00 50.92           C  
ATOM   2103  C   GLU B 118       6.948 -18.444  -5.118  1.00 51.09           C  
ATOM   2104  O   GLU B 118       6.562 -17.548  -4.367  1.00 51.56           O  
ATOM   2105  CB  GLU B 118       8.707 -17.467  -6.606  1.00 50.81           C  
ATOM   2106  CG  GLU B 118       9.460 -17.697  -7.918  1.00 50.84           C  
ATOM   2107  CD  GLU B 118      10.765 -16.926  -8.025  1.00 51.33           C  
ATOM   2108  OE1 GLU B 118      10.757 -15.683  -7.867  1.00 49.88           O  
ATOM   2109  OE2 GLU B 118      11.804 -17.571  -8.304  1.00 53.12           O  
ATOM   2110  N   HIS B 119       7.079 -19.713  -4.739  1.00 51.42           N  
ATOM   2111  CA  HIS B 119       6.700 -20.180  -3.401  1.00 51.71           C  
ATOM   2112  C   HIS B 119       7.807 -21.116  -2.950  1.00 51.21           C  
ATOM   2113  O   HIS B 119       8.110 -22.088  -3.641  1.00 51.12           O  
ATOM   2114  CB  HIS B 119       5.318 -20.894  -3.459  1.00 52.59           C  
ATOM   2115  CG  HIS B 119       4.757 -21.294  -2.119  1.00 54.56           C  
ATOM   2116  ND1 HIS B 119       3.675 -22.137  -1.994  1.00 57.62           N  
ATOM   2117  CD2 HIS B 119       5.124 -20.978  -0.849  1.00 57.05           C  
ATOM   2118  CE1 HIS B 119       3.391 -22.320  -0.712  1.00 55.49           C  
ATOM   2119  NE2 HIS B 119       4.250 -21.619   0.004  1.00 56.53           N  
ATOM   2120  N   TRP B 120       8.423 -20.811  -1.807  1.00 50.91           N  
ATOM   2121  CA  TRP B 120       9.617 -21.528  -1.347  1.00 50.27           C  
ATOM   2122  C   TRP B 120       9.332 -22.446  -0.185  1.00 50.85           C  
ATOM   2123  O   TRP B 120       8.451 -22.179   0.633  1.00 50.83           O  
ATOM   2124  CB  TRP B 120      10.728 -20.573  -0.923  1.00 49.40           C  
ATOM   2125  CG  TRP B 120      11.434 -19.916  -2.023  1.00 47.77           C  
ATOM   2126  CD1 TRP B 120      12.557 -20.365  -2.665  1.00 47.24           C  
ATOM   2127  CD2 TRP B 120      11.106 -18.663  -2.616  1.00 46.44           C  
ATOM   2128  NE1 TRP B 120      12.944 -19.470  -3.628  1.00 45.60           N  
ATOM   2129  CE2 TRP B 120      12.071 -18.415  -3.629  1.00 46.17           C  
ATOM   2130  CE3 TRP B 120      10.089 -17.727  -2.403  1.00 45.94           C  
ATOM   2131  CZ2 TRP B 120      12.048 -17.262  -4.429  1.00 46.75           C  
ATOM   2132  CZ3 TRP B 120      10.062 -16.577  -3.197  1.00 47.40           C  
ATOM   2133  CH2 TRP B 120      11.049 -16.356  -4.201  1.00 47.59           C  
ATOM   2134  N   ASP B 121      10.118 -23.523  -0.119  1.00 51.70           N  
ATOM   2135  CA  ASP B 121       9.972 -24.572   0.883  1.00 52.38           C  
ATOM   2136  C   ASP B 121       8.504 -24.973   0.960  1.00 52.19           C  
ATOM   2137  O   ASP B 121       7.873 -24.950   2.017  1.00 51.90           O  
ATOM   2138  CB  ASP B 121      10.544 -24.112   2.229  1.00 52.88           C  
ATOM   2139  CG  ASP B 121      10.854 -25.270   3.159  1.00 54.78           C  
ATOM   2140  OD1 ASP B 121      10.343 -26.392   2.905  1.00 55.70           O  
ATOM   2141  OD2 ASP B 121      11.598 -25.048   4.154  1.00 57.15           O  
ATOM   2142  N   VAL B 122       8.001 -25.375  -0.199  1.00 52.38           N  
ATOM   2143  CA  VAL B 122       6.581 -25.472  -0.479  1.00 52.58           C  
ATOM   2144  C   VAL B 122       5.887 -26.591   0.272  1.00 52.85           C  
ATOM   2145  O   VAL B 122       4.680 -26.526   0.471  1.00 53.53           O  
ATOM   2146  CB  VAL B 122       6.319 -25.595  -2.010  1.00 52.67           C  
ATOM   2147  CG1 VAL B 122       6.779 -26.949  -2.558  1.00 51.54           C  
ATOM   2148  CG2 VAL B 122       4.840 -25.369  -2.321  1.00 54.41           C  
ATOM   2149  N   PHE B 123       6.635 -27.603   0.693  1.00 52.93           N  
ATOM   2150  CA  PHE B 123       6.060 -28.706   1.456  1.00 53.53           C  
ATOM   2151  C   PHE B 123       6.107 -28.446   2.956  1.00 53.80           C  
ATOM   2152  O   PHE B 123       5.879 -29.361   3.769  1.00 54.11           O  
ATOM   2153  CB  PHE B 123       6.787 -30.019   1.141  1.00 53.75           C  
ATOM   2154  CG  PHE B 123       6.531 -30.532  -0.254  1.00 54.66           C  
ATOM   2155  CD1 PHE B 123       5.230 -30.812  -0.681  1.00 52.83           C  
ATOM   2156  CD2 PHE B 123       7.595 -30.723  -1.150  1.00 55.13           C  
ATOM   2157  CE1 PHE B 123       4.988 -31.285  -1.968  1.00 53.77           C  
ATOM   2158  CE2 PHE B 123       7.359 -31.184  -2.447  1.00 55.62           C  
ATOM   2159  CZ  PHE B 123       6.043 -31.477  -2.849  1.00 54.19           C  
ATOM   2160  N   ASN B 124       6.425 -27.209   3.322  1.00 53.44           N  
ATOM   2161  CA  ASN B 124       6.533 -26.856   4.722  1.00 53.37           C  
ATOM   2162  C   ASN B 124       5.215 -26.965   5.495  1.00 53.41           C  
ATOM   2163  O   ASN B 124       5.228 -27.312   6.669  1.00 53.91           O  
ATOM   2164  CB  ASN B 124       7.162 -25.474   4.886  1.00 53.55           C  
ATOM   2165  CG  ASN B 124       6.371 -24.367   4.207  1.00 53.02           C  
ATOM   2166  OD1 ASN B 124       5.291 -24.575   3.610  1.00 53.23           O  
ATOM   2167  ND2 ASN B 124       6.906 -23.161   4.311  1.00 52.25           N  
ATOM   2168  N   PHE B 125       4.086 -26.690   4.840  1.00 53.10           N  
ATOM   2169  CA  PHE B 125       2.779 -26.916   5.460  1.00 52.70           C  
ATOM   2170  C   PHE B 125       2.557 -28.381   5.857  1.00 52.66           C  
ATOM   2171  O   PHE B 125       1.692 -28.669   6.677  1.00 53.30           O  
ATOM   2172  CB  PHE B 125       1.642 -26.469   4.530  1.00 52.05           C  
ATOM   2173  CG  PHE B 125       1.418 -27.392   3.360  1.00 51.50           C  
ATOM   2174  CD1 PHE B 125       0.565 -28.508   3.480  1.00 50.62           C  
ATOM   2175  CD2 PHE B 125       2.072 -27.164   2.145  1.00 49.38           C  
ATOM   2176  CE1 PHE B 125       0.364 -29.375   2.400  1.00 49.01           C  
ATOM   2177  CE2 PHE B 125       1.873 -28.012   1.051  1.00 48.13           C  
ATOM   2178  CZ  PHE B 125       1.030 -29.126   1.179  1.00 49.69           C  
ATOM   2179  N   SER B 126       3.302 -29.310   5.264  1.00 52.46           N  
ATOM   2180  CA  SER B 126       3.017 -30.737   5.477  1.00 52.71           C  
ATOM   2181  C   SER B 126       3.734 -31.271   6.729  1.00 52.51           C  
ATOM   2182  O   SER B 126       4.969 -31.221   6.810  1.00 52.23           O  
ATOM   2183  CB  SER B 126       3.341 -31.555   4.221  1.00 52.72           C  
ATOM   2184  OG  SER B 126       3.694 -32.901   4.517  1.00 54.95           O  
ATOM   2185  N   PRO B 127       2.957 -31.771   7.716  1.00 52.33           N  
ATOM   2186  CA  PRO B 127       3.508 -32.218   8.997  1.00 51.86           C  
ATOM   2187  C   PRO B 127       4.388 -33.449   8.794  1.00 51.67           C  
ATOM   2188  O   PRO B 127       4.081 -34.265   7.936  1.00 51.94           O  
ATOM   2189  CB  PRO B 127       2.263 -32.596   9.793  1.00 51.96           C  
ATOM   2190  CG  PRO B 127       1.229 -32.935   8.753  1.00 52.25           C  
ATOM   2191  CD  PRO B 127       1.495 -31.981   7.636  1.00 52.51           C  
ATOM   2192  N   LEU B 128       5.484 -33.566   9.535  1.00 51.39           N  
ATOM   2193  CA  LEU B 128       6.292 -34.792   9.521  1.00 51.99           C  
ATOM   2194  C   LEU B 128       5.674 -35.840  10.451  1.00 51.97           C  
ATOM   2195  O   LEU B 128       4.783 -35.529  11.255  1.00 52.09           O  
ATOM   2196  CB  LEU B 128       7.722 -34.515   9.999  1.00 51.97           C  
ATOM   2197  CG  LEU B 128       8.717 -33.768   9.111  1.00 53.19           C  
ATOM   2198  CD1 LEU B 128       8.407 -32.264   9.012  1.00 54.22           C  
ATOM   2199  CD2 LEU B 128      10.111 -33.987   9.675  1.00 52.46           C  
ATOM   2200  N   PHE B 129       6.176 -37.064  10.373  1.00 51.75           N  
ATOM   2201  CA  PHE B 129       5.701 -38.141  11.229  1.00 52.19           C  
ATOM   2202  C   PHE B 129       5.903 -37.800  12.714  1.00 52.00           C  
ATOM   2203  O   PHE B 129       5.108 -38.206  13.561  1.00 52.26           O  
ATOM   2204  CB  PHE B 129       6.444 -39.433  10.893  1.00 52.84           C  
ATOM   2205  CG  PHE B 129       7.884 -39.354  11.193  1.00 53.63           C  
ATOM   2206  CD1 PHE B 129       8.760 -38.760  10.280  1.00 55.26           C  
ATOM   2207  CD2 PHE B 129       8.368 -39.787  12.430  1.00 54.68           C  
ATOM   2208  CE1 PHE B 129      10.112 -38.626  10.580  1.00 55.47           C  
ATOM   2209  CE2 PHE B 129       9.726 -39.670  12.742  1.00 55.02           C  
ATOM   2210  CZ  PHE B 129      10.597 -39.090  11.815  1.00 55.20           C  
ATOM   2211  N   ARG B 130       6.960 -37.055  13.030  1.00 51.86           N  
ATOM   2212  CA  ARG B 130       7.240 -36.667  14.409  0.50 52.02           C  
ATOM   2214  C   ARG B 130       6.250 -35.629  14.933  1.00 52.44           C  
ATOM   2215  O   ARG B 130       6.035 -35.539  16.141  1.00 52.84           O  
ATOM   2216  CB  ARG B 130       8.668 -36.147  14.542  0.50 51.91           C  
ATOM   2218  CG  ARG B 130       9.039 -35.110  13.506  0.50 50.82           C  
ATOM   2220  CD  ARG B 130      10.390 -34.482  13.804  0.50 48.88           C  
ATOM   2222  NE  ARG B 130      10.355 -33.516  14.904  0.50 46.65           N  
ATOM   2224  CZ  ARG B 130       9.689 -32.359  14.889  0.50 44.89           C  
ATOM   2226  NH1 ARG B 130       8.946 -31.992  13.835  0.50 40.23           N  
ATOM   2228  NH2 ARG B 130       9.766 -31.569  15.953  0.50 43.31           N  
ATOM   2230  N   ASP B 131       5.648 -34.844  14.025  1.00 52.86           N  
ATOM   2231  CA  ASP B 131       4.633 -33.862  14.431  1.00 54.05           C  
ATOM   2232  C   ASP B 131       3.356 -34.620  14.750  1.00 54.55           C  
ATOM   2233  O   ASP B 131       2.455 -34.089  15.402  1.00 54.49           O  
ATOM   2234  CB  ASP B 131       4.315 -32.830  13.326  1.00 54.49           C  
ATOM   2235  CG  ASP B 131       5.493 -31.898  12.995  1.00 54.28           C  
ATOM   2236  OD1 ASP B 131       6.222 -31.444  13.916  1.00 54.89           O  
ATOM   2237  OD2 ASP B 131       5.662 -31.600  11.789  1.00 52.38           O  
ATOM   2238  N   LEU B 132       3.282 -35.851  14.248  1.00 55.14           N  
ATOM   2239  CA  LEU B 132       2.122 -36.720  14.438  1.00 55.97           C  
ATOM   2240  C   LEU B 132       2.371 -37.742  15.536  1.00 57.14           C  
ATOM   2241  O   LEU B 132       1.451 -38.443  15.950  1.00 57.39           O  
ATOM   2242  CB  LEU B 132       1.749 -37.435  13.138  1.00 55.23           C  
ATOM   2243  CG  LEU B 132       1.394 -36.510  11.980  1.00 54.22           C  
ATOM   2244  CD1 LEU B 132       1.241 -37.306  10.698  1.00 52.31           C  
ATOM   2245  CD2 LEU B 132       0.137 -35.679  12.301  1.00 52.79           C  
ATOM   2246  N   GLY B 133       3.614 -37.823  16.002  1.00 58.14           N  
ATOM   2247  CA  GLY B 133       3.941 -38.659  17.146  1.00 59.45           C  
ATOM   2248  C   GLY B 133       3.854 -40.145  16.851  1.00 60.56           C  
ATOM   2249  O   GLY B 133       3.379 -40.916  17.693  1.00 60.98           O  
ATOM   2250  N   VAL B 134       4.303 -40.549  15.658  1.00 61.10           N  
ATOM   2251  CA  VAL B 134       4.413 -41.970  15.308  1.00 61.77           C  
ATOM   2252  C   VAL B 134       5.859 -42.362  14.953  1.00 62.21           C  
ATOM   2253  O   VAL B 134       6.413 -41.898  13.948  1.00 62.84           O  
ATOM   2254  CB  VAL B 134       3.412 -42.389  14.176  1.00 61.85           C  
ATOM   2255  CG1 VAL B 134       3.671 -43.839  13.715  1.00 61.56           C  
ATOM   2256  CG2 VAL B 134       1.953 -42.209  14.634  1.00 61.17           C  
TER    2257      VAL B 134                                                      
END
MOLECULE T0475.pdb
ATOM     20  N   ASN     2       1.831  -2.392  -0.522  1.00  0.00
ATOM     21  HN  ASN     2       1.726  -2.331   0.453  1.00  0.00
ATOM     22  CA  ASN     2       2.075  -3.725  -1.109  1.00  0.00
ATOM     23  HA  ASN     2       2.284  -3.607  -2.174  1.00  0.00
ATOM     24  CB  ASN     2       3.299  -4.390  -0.422  1.00  0.00
ATOM     25  HB1 ASN     2       3.466  -5.372  -0.859  1.00  0.00
ATOM     26  HB2 ASN     2       3.089  -4.514   0.636  1.00  0.00
ATOM     27  CG  ASN     2       4.590  -3.576  -0.565  1.00  0.00
ATOM     28  OD1 ASN     2       5.324  -3.715  -1.546  1.00  0.00
ATOM     29  ND2 ASN     2       4.857  -2.700   0.401  1.00  0.00
ATOM     30 HD21 ASN     2       4.224  -2.628   1.148  1.00  0.00
ATOM     31 HD22 ASN     2       5.675  -2.167   0.331  1.00  0.00
ATOM     32  C   ASN     2       0.785  -4.553  -0.964  1.00  0.00
ATOM     33  O   ASN     2       0.810  -5.738  -0.618  1.00  0.00
ATOM     34  N   SER     3      -0.341  -3.891  -1.292  1.00  0.00
ATOM     35  HN  SER     3      -0.247  -3.002  -1.689  1.00  0.00
ATOM     36  CA  SER     3      -1.702  -4.409  -1.095  1.00  0.00
ATOM     37  HA  SER     3      -1.797  -4.700  -0.049  1.00  0.00
ATOM     38  CB  SER     3      -2.716  -3.279  -1.383  1.00  0.00
ATOM     39  HB1 SER     3      -2.599  -2.492  -0.645  1.00  0.00
ATOM     40  HB2 SER     3      -3.729  -3.660  -1.328  1.00  0.00
ATOM     41  OG  SER     3      -2.512  -2.719  -2.675  1.00  0.00
ATOM     42  HG  SER     3      -3.361  -2.595  -3.107  1.00  0.00
ATOM     43  C   SER     3      -1.979  -5.633  -1.981  1.00  0.00
ATOM     44  O   SER     3      -2.523  -6.626  -1.511  1.00  0.00
ATOM     45  N   GLU     4      -1.554  -5.549  -3.257  1.00  0.00
ATOM     46  HN  GLU     4      -1.122  -4.715  -3.539  1.00  0.00
ATOM     47  CA  GLU     4      -1.720  -6.638  -4.252  1.00  0.00
ATOM     48  HA  GLU     4      -2.760  -6.955  -4.203  1.00  0.00
ATOM     49  CB  GLU     4      -1.434  -6.132  -5.697  1.00  0.00
ATOM     50  HB1 GLU     4      -2.105  -5.307  -5.907  1.00  0.00
ATOM     51  HB2 GLU     4      -1.659  -6.934  -6.393  1.00  0.00
ATOM     52  CG  GLU     4       0.018  -5.661  -5.984  1.00  0.00
ATOM     53  HG1 GLU     4       0.166  -5.630  -7.063  1.00  0.00
ATOM     54  HG2 GLU     4       0.703  -6.396  -5.571  1.00  0.00
ATOM     55  CD  GLU     4       0.366  -4.277  -5.399  1.00  0.00
ATOM     56  OE1 GLU     4       0.009  -3.255  -6.022  1.00  0.00
ATOM     57  OE2 GLU     4       0.991  -4.208  -4.319  1.00  0.00
ATOM     58  C   GLU     4      -0.837  -7.869  -3.943  1.00  0.00
ATOM     59  O   GLU     4      -0.931  -8.886  -4.637  1.00  0.00
ATOM     60  N   ILE     5       0.041  -7.744  -2.937  1.00  0.00
ATOM     61  HN  ILE     5       0.146  -6.866  -2.519  1.00  0.00
ATOM     62  CA  ILE     5       0.867  -8.854  -2.432  1.00  0.00
ATOM     63  HA  ILE     5       0.966  -9.608  -3.214  1.00  0.00
ATOM     64  CB  ILE     5       2.303  -8.347  -2.025  1.00  0.00
ATOM     65  HB  ILE     5       2.196  -7.811  -1.085  1.00  0.00
ATOM     66  CG1 ILE     5       2.896  -7.353  -3.082  1.00  0.00
ATOM     67 HG11 ILE     5       3.865  -7.007  -2.738  1.00  0.00
ATOM     68 HG12 ILE     5       2.244  -6.502  -3.163  1.00  0.00
ATOM     69  CG2 ILE     5       3.271  -9.523  -1.775  1.00  0.00
ATOM     70 HG21 ILE     5       4.228  -9.142  -1.435  1.00  0.00
ATOM     71 HG22 ILE     5       3.417 -10.078  -2.691  1.00  0.00
ATOM     72 HG23 ILE     5       2.862 -10.182  -1.021  1.00  0.00
ATOM     73  CD1 ILE     5       3.082  -7.904  -4.488  1.00  0.00
ATOM     74 HD11 ILE     5       2.126  -8.218  -4.887  1.00  0.00
ATOM     75 HD12 ILE     5       3.755  -8.751  -4.459  1.00  0.00
ATOM     76 HD13 ILE     5       3.501  -7.137  -5.121  1.00  0.00
ATOM     77  C   ILE     5       0.167  -9.486  -1.207  1.00  0.00
ATOM     78  O   ILE     5       0.309 -10.683  -0.936  1.00  0.00
ATOM     79  N   GLU     6      -0.598  -8.649  -0.477  1.00  0.00
ATOM     80  HN  GLU     6      -0.624  -7.699  -0.730  1.00  0.00
ATOM     81  CA  GLU     6      -1.393  -9.075   0.691  1.00  0.00
ATOM     82  HA  GLU     6      -0.790  -9.767   1.280  1.00  0.00
ATOM     83  CB  GLU     6      -1.739  -7.844   1.574  1.00  0.00
ATOM     84  HB1 GLU     6      -2.373  -8.164   2.398  1.00  0.00
ATOM     85  HB2 GLU     6      -2.291  -7.131   0.971  1.00  0.00
ATOM     86  CG  GLU     6      -0.519  -7.120   2.167  1.00  0.00
ATOM     87  HG1 GLU     6       0.145  -6.834   1.353  1.00  0.00
ATOM     88  HG2 GLU     6       0.011  -7.810   2.816  1.00  0.00
ATOM     89  CD  GLU     6      -0.894  -5.858   2.968  1.00  0.00
ATOM     90  OE1 GLU     6      -1.011  -5.932   4.215  1.00  0.00
ATOM     91  OE2 GLU     6      -1.101  -4.793   2.350  1.00  0.00
ATOM     92  C   GLU     6      -2.691  -9.790   0.261  1.00  0.00
ATOM     93  O   GLU     6      -3.153 -10.698   0.961  1.00  0.00
ATOM     94  N   LEU     7      -3.271  -9.367  -0.887  1.00  0.00
ATOM     95  HN  LEU     7      -2.808  -8.685  -1.417  1.00  0.00
ATOM     96  CA  LEU     7      -4.562  -9.911  -1.391  1.00  0.00
ATOM     97  HA  LEU     7      -5.292  -9.732  -0.607  1.00  0.00
ATOM     98  CB  LEU     7      -5.054  -9.182  -2.681  1.00  0.00
ATOM     99  HB1 LEU     7      -5.975  -9.663  -3.009  1.00  0.00
ATOM    100  HB2 LEU     7      -4.310  -9.334  -3.456  1.00  0.00
ATOM    101  CG  LEU     7      -5.325  -7.651  -2.562  1.00  0.00
ATOM    102  HG  LEU     7      -4.402  -7.168  -2.287  1.00  0.00
ATOM    103  CD1 LEU     7      -5.756  -7.043  -3.913  1.00  0.00
ATOM    104 HD11 LEU     7      -6.661  -7.526  -4.269  1.00  0.00
ATOM    105 HD12 LEU     7      -4.968  -7.181  -4.640  1.00  0.00
ATOM    106 HD13 LEU     7      -5.941  -5.982  -3.792  1.00  0.00
ATOM    107  CD2 LEU     7      -6.353  -7.346  -1.453  1.00  0.00
ATOM    108 HD21 LEU     7      -5.982  -7.713  -0.505  1.00  0.00
ATOM    109 HD22 LEU     7      -7.295  -7.830  -1.678  1.00  0.00
ATOM    110 HD23 LEU     7      -6.509  -6.276  -1.383  1.00  0.00
ATOM    111  C   LEU     7      -4.504 -11.450  -1.632  1.00  0.00
ATOM    112  O   LEU     7      -5.411 -12.157  -1.175  1.00  0.00
ATOM    113  N   PRO     8      -3.462 -12.011  -2.364  1.00  0.00
ATOM    114  CA  PRO     8      -3.309 -13.478  -2.527  1.00  0.00
ATOM    115  HA  PRO     8      -4.145 -13.893  -3.088  1.00  0.00
ATOM    116  CB  PRO     8      -1.994 -13.649  -3.366  1.00  0.00
ATOM    117  HB1 PRO     8      -2.245 -13.908  -4.388  1.00  0.00
ATOM    118  HB2 PRO     8      -1.376 -14.442  -2.953  1.00  0.00
ATOM    119  CG  PRO     8      -1.308 -12.325  -3.298  1.00  0.00
ATOM    120  HG1 PRO     8      -0.750 -12.142  -4.212  1.00  0.00
ATOM    121  HG2 PRO     8      -0.632 -12.298  -2.447  1.00  0.00
ATOM    122  CD  PRO     8      -2.402 -11.297  -3.131  1.00  0.00
ATOM    123  HD1 PRO     8      -2.780 -10.972  -4.098  1.00  0.00
ATOM    124  HD2 PRO     8      -2.035 -10.447  -2.573  1.00  0.00
ATOM    125  C   PRO     8      -3.231 -14.208  -1.181  1.00  0.00
ATOM    126  O   PRO     8      -4.115 -14.994  -0.842  1.00  0.00
ATOM    127  N   VAL     9      -2.209 -13.860  -0.401  1.00  0.00
ATOM    128  HN  VAL     9      -1.703 -13.049  -0.636  1.00  0.00
ATOM    129  CA  VAL     9      -1.812 -14.612   0.800  1.00  0.00
ATOM    130  HA  VAL     9      -1.660 -15.641   0.491  1.00  0.00
ATOM    131  CB  VAL     9      -0.455 -14.070   1.348  1.00  0.00
ATOM    132  HB  VAL     9      -0.147 -14.712   2.173  1.00  0.00
ATOM    133  CG1 VAL     9       0.641 -14.156   0.254  1.00  0.00
ATOM    134 HG11 VAL     9       0.368 -13.532  -0.588  1.00  0.00
ATOM    135 HG12 VAL     9       0.746 -15.182  -0.082  1.00  0.00
ATOM    136 HG13 VAL     9       1.587 -13.820   0.657  1.00  0.00
ATOM    137  CG2 VAL     9      -0.593 -12.627   1.896  1.00  0.00
ATOM    138 HG21 VAL     9      -0.958 -11.972   1.115  1.00  0.00
ATOM    139 HG22 VAL     9       0.366 -12.271   2.239  1.00  0.00
ATOM    140 HG23 VAL     9      -1.292 -12.614   2.725  1.00  0.00
ATOM    141  C   VAL     9      -2.901 -14.601   1.905  1.00  0.00
ATOM    142  O   VAL     9      -3.020 -15.564   2.666  1.00  0.00
ATOM    143  N   GLN    10      -3.705 -13.515   1.950  1.00  0.00
ATOM    144  HN  GLN    10      -3.532 -12.787   1.318  1.00  0.00
ATOM    145  CA  GLN    10      -4.839 -13.376   2.888  1.00  0.00
ATOM    146  HA  GLN    10      -4.480 -13.600   3.893  1.00  0.00
ATOM    147  CB  GLN    10      -5.375 -11.914   2.859  1.00  0.00
ATOM    148  HB1 GLN    10      -5.608 -11.659   1.829  1.00  0.00
ATOM    149  HB2 GLN    10      -4.587 -11.252   3.197  1.00  0.00
ATOM    150  CG  GLN    10      -6.630 -11.627   3.718  1.00  0.00
ATOM    151  HG1 GLN    10      -7.444 -12.248   3.358  1.00  0.00
ATOM    152  HG2 GLN    10      -6.905 -10.587   3.587  1.00  0.00
ATOM    153  CD  GLN    10      -6.435 -11.892   5.211  1.00  0.00
ATOM    154  OE1 GLN    10      -6.001 -11.016   5.954  1.00  0.00
ATOM    155  NE2 GLN    10      -6.762 -13.097   5.655  1.00  0.00
ATOM    156 HE21 GLN    10      -7.111 -13.751   5.008  1.00  0.00
ATOM    157 HE22 GLN    10      -6.644 -13.289   6.609  1.00  0.00
ATOM    158  C   GLN    10      -5.951 -14.368   2.514  1.00  0.00
ATOM    159  O   GLN    10      -6.354 -15.200   3.335  1.00  0.00
ATOM    160  N   LYS    11      -6.395 -14.286   1.244  1.00  0.00
ATOM    161  HN  LYS    11      -5.949 -13.656   0.636  1.00  0.00
ATOM    162  CA  LYS    11      -7.508 -15.103   0.710  1.00  0.00
ATOM    163  HA  LYS    11      -8.378 -14.924   1.338  1.00  0.00
ATOM    164  CB  LYS    11      -7.846 -14.648  -0.732  1.00  0.00
ATOM    165  HB1 LYS    11      -8.562 -15.342  -1.167  1.00  0.00
ATOM    166  HB2 LYS    11      -6.938 -14.674  -1.329  1.00  0.00
ATOM    167  CG  LYS    11      -8.439 -13.225  -0.830  1.00  0.00
ATOM    168  HG1 LYS    11      -8.591 -12.983  -1.878  1.00  0.00
ATOM    169  HG2 LYS    11      -7.731 -12.521  -0.403  1.00  0.00
ATOM    170  CD  LYS    11      -9.782 -13.097  -0.085  1.00  0.00
ATOM    171  HD1 LYS    11      -9.626 -13.325   0.969  1.00  0.00
ATOM    172  HD2 LYS    11     -10.482 -13.816  -0.497  1.00  0.00
ATOM    173  CE  LYS    11     -10.403 -11.699  -0.200  1.00  0.00
ATOM    174  HE1 LYS    11     -10.562 -11.460  -1.242  1.00  0.00
ATOM    175  HE2 LYS    11      -9.730 -10.971   0.239  1.00  0.00
ATOM    176  NZ  LYS    11     -11.702 -11.633   0.510  1.00  0.00
ATOM    177  HZ1 LYS    11     -12.109 -10.686   0.416  1.00  0.00
ATOM    178  HZ2 LYS    11     -11.567 -11.843   1.519  1.00  0.00
ATOM    179  HZ3 LYS    11     -12.367 -12.326   0.112  1.00  0.00
ATOM    180  C   LYS    11      -7.180 -16.603   0.734  1.00  0.00
ATOM    181  O   LYS    11      -8.057 -17.429   0.977  1.00  0.00
ATOM    182  N   GLN    12      -5.904 -16.925   0.497  1.00  0.00
ATOM    183  HN  GLN    12      -5.262 -16.197   0.364  1.00  0.00
ATOM    184  CA  GLN    12      -5.412 -18.308   0.438  1.00  0.00
ATOM    185  HA  GLN    12      -6.116 -18.882  -0.161  1.00  0.00
ATOM    186  CB  GLN    12      -4.038 -18.347  -0.253  1.00  0.00
ATOM    187  HB1 GLN    12      -3.615 -19.342  -0.140  1.00  0.00
ATOM    188  HB2 GLN    12      -3.378 -17.634   0.241  1.00  0.00
ATOM    189  CG  GLN    12      -4.076 -18.013  -1.754  1.00  0.00
ATOM    190  HG1 GLN    12      -4.619 -17.084  -1.892  1.00  0.00
ATOM    191  HG2 GLN    12      -4.592 -18.806  -2.280  1.00  0.00
ATOM    192  CD  GLN    12      -2.692 -17.850  -2.370  1.00  0.00
ATOM    193  OE1 GLN    12      -2.513 -17.092  -3.318  1.00  0.00
ATOM    194  NE2 GLN    12      -1.704 -18.584  -1.862  1.00  0.00
ATOM    195 HE21 GLN    12      -1.901 -19.190  -1.120  1.00  0.00
ATOM    196 HE22 GLN    12      -0.821 -18.502  -2.263  1.00  0.00
ATOM    197  C   GLN    12      -5.310 -18.928   1.840  1.00  0.00
ATOM    198  O   GLN    12      -5.658 -20.085   2.024  1.00  0.00
ATOM    199  N   LEU    13      -4.802 -18.148   2.810  1.00  0.00
ATOM    200  HN  LEU    13      -4.515 -17.235   2.577  1.00  0.00
ATOM    201  CA  LEU    13      -4.660 -18.600   4.211  1.00  0.00
ATOM    202  HA  LEU    13      -4.023 -19.485   4.218  1.00  0.00
ATOM    203  CB  LEU    13      -4.000 -17.499   5.062  1.00  0.00
ATOM    204  HB1 LEU    13      -4.586 -16.593   4.943  1.00  0.00
ATOM    205  HB2 LEU    13      -3.007 -17.308   4.661  1.00  0.00
ATOM    206  CG  LEU    13      -3.869 -17.811   6.587  1.00  0.00
ATOM    207  HG  LEU    13      -4.781 -18.277   6.921  1.00  0.00
ATOM    208  CD1 LEU    13      -2.741 -18.824   6.881  1.00  0.00
ATOM    209 HD11 LEU    13      -2.683 -19.003   7.947  1.00  0.00
ATOM    210 HD12 LEU    13      -1.792 -18.435   6.532  1.00  0.00
ATOM    211 HD13 LEU    13      -2.952 -19.760   6.376  1.00  0.00
ATOM    212  CD2 LEU    13      -3.726 -16.522   7.391  1.00  0.00
ATOM    213 HD21 LEU    13      -3.726 -16.755   8.445  1.00  0.00
ATOM    214 HD22 LEU    13      -4.561 -15.868   7.172  1.00  0.00
ATOM    215 HD23 LEU    13      -2.801 -16.024   7.132  1.00  0.00
ATOM    216  C   LEU    13      -6.039 -18.958   4.803  1.00  0.00
ATOM    217  O   LEU    13      -6.199 -20.004   5.451  1.00  0.00
ATOM    218  N   GLU    14      -7.012 -18.054   4.579  1.00  0.00
ATOM    219  HN  GLU    14      -6.762 -17.194   4.166  1.00  0.00
ATOM    220  CA  GLU    14      -8.427 -18.274   4.938  1.00  0.00
ATOM    221  HA  GLU    14      -8.482 -18.402   6.018  1.00  0.00
ATOM    222  CB  GLU    14      -9.279 -17.045   4.529  1.00  0.00
ATOM    223  HB1 GLU    14     -10.327 -17.249   4.740  1.00  0.00
ATOM    224  HB2 GLU    14      -9.167 -16.886   3.459  1.00  0.00
ATOM    225  CG  GLU    14      -8.896 -15.744   5.249  1.00  0.00
ATOM    226  HG1 GLU    14      -7.833 -15.558   5.093  1.00  0.00
ATOM    227  HG2 GLU    14      -9.070 -15.875   6.311  1.00  0.00
ATOM    228  CD  GLU    14      -9.693 -14.526   4.750  1.00  0.00
ATOM    229  OE1 GLU    14     -10.749 -14.201   5.342  1.00  0.00
ATOM    230  OE2 GLU    14      -9.272 -13.890   3.756  1.00  0.00
ATOM    231  C   GLU    14      -8.950 -19.548   4.253  1.00  0.00
ATOM    232  O   GLU    14      -9.468 -20.433   4.916  1.00  0.00
ATOM    233  N   ALA    15      -8.711 -19.634   2.933  1.00  0.00
ATOM    234  HN  ALA    15      -8.204 -18.905   2.512  1.00  0.00
ATOM    235  CA  ALA    15      -9.156 -20.758   2.076  1.00  0.00
ATOM    236  HA  ALA    15     -10.235 -20.852   2.189  1.00  0.00
ATOM    237  CB  ALA    15      -8.862 -20.438   0.601  1.00  0.00
ATOM    238  HB1 ALA    15      -7.792 -20.355   0.451  1.00  0.00
ATOM    239  HB2 ALA    15      -9.327 -19.499   0.328  1.00  0.00
ATOM    240  HB3 ALA    15      -9.255 -21.223  -0.034  1.00  0.00
ATOM    241  C   ALA    15      -8.495 -22.102   2.478  1.00  0.00
ATOM    242  O   ALA    15      -9.058 -23.168   2.217  1.00  0.00
ATOM    243  N   TYR    16      -7.294 -22.028   3.098  1.00  0.00
ATOM    244  HN  TYR    16      -6.919 -21.135   3.279  1.00  0.00
ATOM    245  CA  TYR    16      -6.514 -23.215   3.518  1.00  0.00
ATOM    246  HA  TYR    16      -6.377 -23.844   2.639  1.00  0.00
ATOM    247  CB  TYR    16      -5.116 -22.780   4.043  1.00  0.00
ATOM    248  HB1 TYR    16      -5.253 -22.145   4.912  1.00  0.00
ATOM    249  HB2 TYR    16      -4.621 -22.198   3.274  1.00  0.00
ATOM    250  CG  TYR    16      -4.166 -23.936   4.432  1.00  0.00
ATOM    251  CD1 TYR    16      -3.688 -24.087   5.742  1.00  0.00
ATOM    252  HD1 TYR    16      -3.991 -23.371   6.499  1.00  0.00
ATOM    253  CD2 TYR    16      -3.752 -24.875   3.481  1.00  0.00
ATOM    254  HD2 TYR    16      -4.105 -24.781   2.460  1.00  0.00
ATOM    255  CE1 TYR    16      -2.836 -25.128   6.080  1.00  0.00
ATOM    256  HE1 TYR    16      -2.482 -25.225   7.100  1.00  0.00
ATOM    257  CE2 TYR    16      -2.904 -25.913   3.816  1.00  0.00
ATOM    258  HE2 TYR    16      -2.602 -26.625   3.059  1.00  0.00
ATOM    259  CZ  TYR    16      -2.448 -26.037   5.113  1.00  0.00
ATOM    260  OH  TYR    16      -1.602 -27.080   5.440  1.00  0.00
ATOM    261  HH  TYR    16      -1.856 -27.442   6.292  1.00  0.00
ATOM    262  C   TYR    16      -7.276 -24.016   4.589  1.00  0.00
ATOM    263  O   TYR    16      -7.355 -25.252   4.525  1.00  0.00
ATOM    264  N   ASN    17      -7.845 -23.289   5.560  1.00  0.00
ATOM    265  HN  ASN    17      -7.732 -22.312   5.539  1.00  0.00
ATOM    266  CA  ASN    17      -8.637 -23.887   6.651  1.00  0.00
ATOM    267  HA  ASN    17      -8.283 -24.908   6.797  1.00  0.00
ATOM    268  CB  ASN    17      -8.405 -23.104   7.979  1.00  0.00
ATOM    269  HB1 ASN    17      -7.345 -23.123   8.218  1.00  0.00
ATOM    270  HB2 ASN    17      -8.938 -23.600   8.780  1.00  0.00
ATOM    271  CG  ASN    17      -8.859 -21.642   7.940  1.00  0.00
ATOM    272  OD1 ASN    17      -9.998 -21.326   8.280  1.00  0.00
ATOM    273  ND2 ASN    17      -7.969 -20.740   7.540  1.00  0.00
ATOM    274 HD21 ASN    17      -7.069 -21.047   7.289  1.00  0.00
ATOM    275 HD22 ASN    17      -8.244 -19.800   7.514  1.00  0.00
ATOM    276  C   ASN    17     -10.139 -23.952   6.270  1.00  0.00
ATOM    277  O   ASN    17     -10.847 -24.858   6.711  1.00  0.00
ATOM    278  N   ALA    18     -10.592 -23.015   5.405  1.00  0.00
ATOM    279  HN  ALA    18      -9.945 -22.382   5.033  1.00  0.00
ATOM    280  CA  ALA    18     -12.017 -22.899   4.977  1.00  0.00
ATOM    281  HA  ALA    18     -12.645 -23.109   5.841  1.00  0.00
ATOM    282  CB  ALA    18     -12.330 -21.469   4.502  1.00  0.00
ATOM    283  HB1 ALA    18     -12.057 -20.761   5.270  1.00  0.00
ATOM    284  HB2 ALA    18     -13.389 -21.372   4.287  1.00  0.00
ATOM    285  HB3 ALA    18     -11.764 -21.251   3.601  1.00  0.00
ATOM    286  C   ALA    18     -12.372 -23.904   3.864  1.00  0.00
ATOM    287  O   ALA    18     -13.549 -24.058   3.525  1.00  0.00
ATOM    288  N   ARG    19     -11.335 -24.564   3.304  1.00  0.00
ATOM    289  HN  ARG    19     -10.428 -24.285   3.558  1.00  0.00
ATOM    290  CA  ARG    19     -11.463 -25.664   2.322  1.00  0.00
ATOM    291  HA  ARG    19     -10.461 -26.039   2.155  1.00  0.00
ATOM    292  CB  ARG    19     -12.324 -26.837   2.881  1.00  0.00
ATOM    293  HB1 ARG    19     -12.258 -27.674   2.191  1.00  0.00
ATOM    294  HB2 ARG    19     -13.358 -26.514   2.925  1.00  0.00
ATOM    295  CG  ARG    19     -11.926 -27.336   4.286  1.00  0.00
ATOM    296  HG1 ARG    19     -12.522 -28.212   4.517  1.00  0.00
ATOM    297  HG2 ARG    19     -12.152 -26.559   5.010  1.00  0.00
ATOM    298  CD  ARG    19     -10.443 -27.704   4.416  1.00  0.00
ATOM    299  HD1 ARG    19      -9.841 -26.820   4.237  1.00  0.00
ATOM    300  HD2 ARG    19     -10.192 -28.462   3.681  1.00  0.00
ATOM    301  NE  ARG    19     -10.151 -28.205   5.768  1.00  0.00
ATOM    302  HE  ARG    19      -9.995 -27.527   6.467  1.00  0.00
ATOM    303  CZ  ARG    19     -10.113 -29.498   6.120  1.00  0.00
ATOM    304  NH1 ARG    19     -10.315 -30.461   5.228  1.00  0.00
ATOM    305 HH11 ARG    19     -10.508 -30.236   4.271  1.00  0.00
ATOM    306 HH12 ARG    19     -10.261 -31.424   5.505  1.00  0.00
ATOM    307  NH2 ARG    19      -9.892 -29.827   7.378  1.00  0.00
ATOM    308 HH21 ARG    19      -9.761 -29.112   8.073  1.00  0.00
ATOM    309 HH22 ARG    19      -9.844 -30.791   7.648  1.00  0.00
ATOM    310  C   ARG    19     -11.996 -25.167   0.958  1.00  0.00
ATOM    311  O   ARG    19     -12.864 -25.800   0.338  1.00  0.00
ATOM    312  N   ASP    20     -11.443 -24.037   0.485  1.00  0.00
ATOM    313  HN  ASP    20     -10.788 -23.570   1.041  1.00  0.00
ATOM    314  CA  ASP    20     -11.769 -23.468  -0.838  1.00  0.00
ATOM    315  HA  ASP    20     -12.541 -24.077  -1.307  1.00  0.00
ATOM    316  CB  ASP    20     -12.309 -22.010  -0.689  1.00  0.00
ATOM    317  HB1 ASP    20     -12.380 -21.558  -1.674  1.00  0.00
ATOM    318  HB2 ASP    20     -11.601 -21.429  -0.100  1.00  0.00
ATOM    319  CG  ASP    20     -13.689 -21.930  -0.008  1.00  0.00
ATOM    320  OD1 ASP    20     -13.750 -21.843   1.238  1.00  0.00
ATOM    321  OD2 ASP    20     -14.720 -21.948  -0.721  1.00  0.00
ATOM    322  C   ASP    20     -10.514 -23.492  -1.734  1.00  0.00
ATOM    323  O   ASP    20      -9.717 -22.558  -1.696  1.00  0.00
ATOM    324  N   ILE    21     -10.357 -24.561  -2.547  1.00  0.00
ATOM    325  HN  ILE    21     -11.052 -25.252  -2.550  1.00  0.00
ATOM    326  CA  ILE    21      -9.181 -24.730  -3.438  1.00  0.00
ATOM    327  HA  ILE    21      -8.300 -24.483  -2.847  1.00  0.00
ATOM    328  CB  ILE    21      -9.016 -26.233  -3.930  1.00  0.00
ATOM    329  HB  ILE    21     -10.004 -26.599  -4.190  1.00  0.00
ATOM    330  CG1 ILE    21      -8.453 -27.132  -2.779  1.00  0.00
ATOM    331 HG11 ILE    21      -8.531 -28.173  -3.071  1.00  0.00
ATOM    332 HG12 ILE    21      -9.039 -26.979  -1.884  1.00  0.00
ATOM    333  CG2 ILE    21      -8.127 -26.369  -5.205  1.00  0.00
ATOM    334 HG21 ILE    21      -8.582 -25.828  -6.025  1.00  0.00
ATOM    335 HG22 ILE    21      -8.032 -27.412  -5.477  1.00  0.00
ATOM    336 HG23 ILE    21      -7.143 -25.959  -5.009  1.00  0.00
ATOM    337  CD1 ILE    21      -6.996 -26.864  -2.418  1.00  0.00
ATOM    338 HD11 ILE    21      -6.719 -27.483  -1.577  1.00  0.00
ATOM    339 HD12 ILE    21      -6.874 -25.824  -2.152  1.00  0.00
ATOM    340 HD13 ILE    21      -6.361 -27.100  -3.261  1.00  0.00
ATOM    341  C   ILE    21      -9.226 -23.742  -4.620  1.00  0.00
ATOM    342  O   ILE    21      -8.175 -23.315  -5.100  1.00  0.00
ATOM    343  N   ASP    22     -10.438 -23.351  -5.061  1.00  0.00
ATOM    344  HN  ASP    22     -11.243 -23.708  -4.615  1.00  0.00
ATOM    345  CA  ASP    22     -10.607 -22.411  -6.196  1.00  0.00
ATOM    346  HA  ASP    22     -10.117 -22.864  -7.058  1.00  0.00
ATOM    347  CB  ASP    22     -12.108 -22.225  -6.538  1.00  0.00
ATOM    348  HB1 ASP    22     -12.633 -21.874  -5.655  1.00  0.00
ATOM    349  HB2 ASP    22     -12.527 -23.188  -6.818  1.00  0.00
ATOM    350  CG  ASP    22     -12.355 -21.231  -7.695  1.00  0.00
ATOM    351  OD1 ASP    22     -12.735 -20.066  -7.435  1.00  0.00
ATOM    352  OD2 ASP    22     -12.135 -21.609  -8.867  1.00  0.00
ATOM    353  C   ASP    22      -9.928 -21.047  -5.907  1.00  0.00
ATOM    354  O   ASP    22      -9.220 -20.518  -6.762  1.00  0.00
ATOM    355  N   ALA    23     -10.136 -20.511  -4.691  1.00  0.00
ATOM    356  HN  ALA    23     -10.740 -20.975  -4.074  1.00  0.00
ATOM    357  CA  ALA    23      -9.486 -19.252  -4.239  1.00  0.00
ATOM    358  HA  ALA    23      -9.458 -18.561  -5.080  1.00  0.00
ATOM    359  CB  ALA    23     -10.297 -18.602  -3.105  1.00  0.00
ATOM    360  HB1 ALA    23      -9.839 -17.662  -2.810  1.00  0.00
ATOM    361  HB2 ALA    23     -10.332 -19.265  -2.252  1.00  0.00
ATOM    362  HB3 ALA    23     -11.309 -18.413  -3.447  1.00  0.00
ATOM    363  C   ALA    23      -8.040 -19.511  -3.791  1.00  0.00
ATOM    364  O   ALA    23      -7.160 -18.659  -3.967  1.00  0.00
ATOM    365  N   PHE    24      -7.810 -20.712  -3.236  1.00  0.00
ATOM    366  HN  PHE    24      -8.575 -21.307  -3.083  1.00  0.00
ATOM    367  CA  PHE    24      -6.473 -21.176  -2.830  1.00  0.00
ATOM    368  HA  PHE    24      -6.009 -20.382  -2.243  1.00  0.00
ATOM    369  CB  PHE    24      -6.615 -22.440  -1.934  1.00  0.00
ATOM    370  HB1 PHE    24      -6.963 -23.265  -2.547  1.00  0.00
ATOM    371  HB2 PHE    24      -7.362 -22.246  -1.173  1.00  0.00
ATOM    372  CG  PHE    24      -5.339 -22.878  -1.225  1.00  0.00
ATOM    373  CD1 PHE    24      -4.521 -23.871  -1.754  1.00  0.00
ATOM    374  HD1 PHE    24      -4.808 -24.367  -2.671  1.00  0.00
ATOM    375  CD2 PHE    24      -4.940 -22.263  -0.047  1.00  0.00
ATOM    376  HD2 PHE    24      -5.561 -21.491   0.389  1.00  0.00
ATOM    377  CE1 PHE    24      -3.356 -24.232  -1.120  1.00  0.00
ATOM    378  HE1 PHE    24      -2.732 -25.002  -1.545  1.00  0.00
ATOM    379  CE2 PHE    24      -3.775 -22.635   0.590  1.00  0.00
ATOM    380  HE2 PHE    24      -3.483 -22.147   1.511  1.00  0.00
ATOM    381  CZ  PHE    24      -2.979 -23.615   0.050  1.00  0.00
ATOM    382  HZ  PHE    24      -2.058 -23.904   0.544  1.00  0.00
ATOM    383  C   PHE    24      -5.585 -21.459  -4.071  1.00  0.00
ATOM    384  O   PHE    24      -4.392 -21.704  -3.933  1.00  0.00
ATOM    385  N   MET    25      -6.184 -21.461  -5.282  1.00  0.00
ATOM    386  HN  MET    25      -7.161 -21.385  -5.318  1.00  0.00
ATOM    387  CA  MET    25      -5.445 -21.605  -6.559  1.00  0.00
ATOM    388  HA  MET    25      -4.407 -21.823  -6.325  1.00  0.00
ATOM    389  CB  MET    25      -6.016 -22.776  -7.413  1.00  0.00
ATOM    390  HB1 MET    25      -7.067 -22.579  -7.602  1.00  0.00
ATOM    391  HB2 MET    25      -5.940 -23.689  -6.834  1.00  0.00
ATOM    392  CG  MET    25      -5.310 -23.025  -8.775  1.00  0.00
ATOM    393  HG1 MET    25      -5.016 -22.072  -9.200  1.00  0.00
ATOM    394  HG2 MET    25      -6.019 -23.489  -9.446  1.00  0.00
ATOM    395  SD  MET    25      -3.840 -24.101  -8.708  1.00  0.00
ATOM    396  CE  MET    25      -2.690 -23.286  -7.583  1.00  0.00
ATOM    397  HE1 MET    25      -1.756 -23.833  -7.570  1.00  0.00
ATOM    398  HE2 MET    25      -3.107 -23.276  -6.587  1.00  0.00
ATOM    399  HE3 MET    25      -2.510 -22.271  -7.910  1.00  0.00
ATOM    400  C   MET    25      -5.483 -20.303  -7.374  1.00  0.00
ATOM    401  O   MET    25      -4.536 -20.015  -8.120  1.00  0.00
ATOM    402  N   ALA    26      -6.576 -19.524  -7.206  1.00  0.00
ATOM    403  HN  ALA    26      -7.206 -19.764  -6.502  1.00  0.00
ATOM    404  CA  ALA    26      -6.870 -18.324  -8.030  1.00  0.00
ATOM    405  HA  ALA    26      -7.098 -18.668  -9.039  1.00  0.00
ATOM    406  CB  ALA    26      -8.111 -17.596  -7.486  1.00  0.00
ATOM    407  HB1 ALA    26      -8.955 -18.274  -7.463  1.00  0.00
ATOM    408  HB2 ALA    26      -8.354 -16.752  -8.122  1.00  0.00
ATOM    409  HB3 ALA    26      -7.918 -17.241  -6.478  1.00  0.00
ATOM    410  C   ALA    26      -5.690 -17.354  -8.081  1.00  0.00
ATOM    411  O   ALA    26      -5.165 -17.037  -9.147  1.00  0.00
ATOM    412  N   TRP    27      -5.237 -16.978  -6.894  1.00  0.00
ATOM    413  HN  TRP    27      -5.569 -17.449  -6.099  1.00  0.00
ATOM    414  CA  TRP    27      -4.272 -15.899  -6.699  1.00  0.00
ATOM    415  HA  TRP    27      -4.541 -15.083  -7.366  1.00  0.00
ATOM    416  CB  TRP    27      -4.404 -15.411  -5.253  1.00  0.00
ATOM    417  HB1 TRP    27      -3.650 -14.657  -5.074  1.00  0.00
ATOM    418  HB2 TRP    27      -4.223 -16.240  -4.578  1.00  0.00
ATOM    419  CG  TRP    27      -5.746 -14.806  -4.899  1.00  0.00
ATOM    420  CD1 TRP    27      -6.813 -15.425  -4.298  1.00  0.00
ATOM    421  HD1 TRP    27      -6.834 -16.466  -4.002  1.00  0.00
ATOM    422  CD2 TRP    27      -6.140 -13.442  -5.103  1.00  0.00
ATOM    423  NE1 TRP    27      -7.838 -14.529  -4.128  1.00  0.00
ATOM    424  HE1 TRP    27      -8.707 -14.731  -3.721  1.00  0.00
ATOM    425  CE2 TRP    27      -7.451 -13.309  -4.615  1.00  0.00
ATOM    426  CE3 TRP    27      -5.497 -12.321  -5.646  1.00  0.00
ATOM    427  HE3 TRP    27      -4.487 -12.389  -6.033  1.00  0.00
ATOM    428  CZ2 TRP    27      -8.137 -12.102  -4.667  1.00  0.00
ATOM    429  HZ2 TRP    27      -9.148 -12.004  -4.298  1.00  0.00
ATOM    430  CZ3 TRP    27      -6.182 -11.125  -5.699  1.00  0.00
ATOM    431  HZ3 TRP    27      -5.704 -10.246  -6.113  1.00  0.00
ATOM    432  CH2 TRP    27      -7.489 -11.021  -5.207  1.00  0.00
ATOM    433  HH2 TRP    27      -7.991 -10.060  -5.267  1.00  0.00
ATOM    434  C   TRP    27      -2.813 -16.314  -7.008  1.00  0.00
ATOM    435  O   TRP    27      -1.888 -15.520  -6.805  1.00  0.00
ATOM    436  N   TRP    28      -2.618 -17.549  -7.499  1.00  0.00
ATOM    437  HN  TRP    28      -3.388 -18.151  -7.573  1.00  0.00
ATOM    438  CA  TRP    28      -1.309 -18.047  -7.951  1.00  0.00
ATOM    439  HA  TRP    28      -0.524 -17.501  -7.429  1.00  0.00
ATOM    440  CB  TRP    28      -1.163 -19.564  -7.650  1.00  0.00
ATOM    441  HB1 TRP    28      -0.191 -19.902  -7.996  1.00  0.00
ATOM    442  HB2 TRP    28      -1.929 -20.106  -8.194  1.00  0.00
ATOM    443  CG  TRP    28      -1.297 -19.941  -6.191  1.00  0.00
ATOM    444  CD1 TRP    28      -2.412 -19.826  -5.411  1.00  0.00
ATOM    445  HD1 TRP    28      -3.365 -19.415  -5.743  1.00  0.00
ATOM    446  CD2 TRP    28      -0.291 -20.536  -5.349  1.00  0.00
ATOM    447  NE1 TRP    28      -2.155 -20.305  -4.159  1.00  0.00
ATOM    448  HE1 TRP    28      -2.801 -20.329  -3.422  1.00  0.00
ATOM    449  CE2 TRP    28      -0.869 -20.737  -4.089  1.00  0.00
ATOM    450  CE3 TRP    28       1.037 -20.908  -5.540  1.00  0.00
ATOM    451  HE3 TRP    28       1.520 -20.774  -6.499  1.00  0.00
ATOM    452  CZ2 TRP    28      -0.174 -21.298  -3.021  1.00  0.00
ATOM    453  HZ2 TRP    28      -0.632 -21.445  -2.052  1.00  0.00
ATOM    454  CZ3 TRP    28       1.731 -21.467  -4.485  1.00  0.00
ATOM    455  HZ3 TRP    28       2.764 -21.760  -4.617  1.00  0.00
ATOM    456  CH2 TRP    28       1.127 -21.653  -3.235  1.00  0.00
ATOM    457  HH2 TRP    28       1.710 -22.092  -2.434  1.00  0.00
ATOM    458  C   TRP    28      -1.162 -17.807  -9.463  1.00  0.00
ATOM    459  O   TRP    28      -2.148 -17.552 -10.168  1.00  0.00
ATOM    460  N   ALA    29       0.084 -17.865  -9.940  1.00  0.00
ATOM    461  HN  ALA    29       0.820 -17.910  -9.299  1.00  0.00
ATOM    462  CA  ALA    29       0.402 -17.858 -11.384  1.00  0.00
ATOM    463  HA  ALA    29      -0.268 -17.158 -11.880  1.00  0.00
ATOM    464  CB  ALA    29       1.851 -17.391 -11.618  1.00  0.00
ATOM    465  HB1 ALA    29       1.980 -16.392 -11.220  1.00  0.00
ATOM    466  HB2 ALA    29       2.066 -17.379 -12.680  1.00  0.00
ATOM    467  HB3 ALA    29       2.542 -18.065 -11.123  1.00  0.00
ATOM    468  C   ALA    29       0.186 -19.261 -11.971  1.00  0.00
ATOM    469  O   ALA    29       0.322 -20.257 -11.255  1.00  0.00
ATOM    470  N   ASP    30      -0.136 -19.337 -13.276  1.00  0.00
ATOM    471  HN  ASP    30      -0.232 -18.505 -13.787  1.00  0.00
ATOM    472  CA  ASP    30      -0.360 -20.632 -13.968  1.00  0.00
ATOM    473  HA  ASP    30      -1.069 -21.201 -13.371  1.00  0.00
ATOM    474  CB  ASP    30      -0.975 -20.409 -15.375  1.00  0.00
ATOM    475  HB1 ASP    30      -0.286 -19.812 -15.967  1.00  0.00
ATOM    476  HB2 ASP    30      -1.901 -19.854 -15.268  1.00  0.00
ATOM    477  CG  ASP    30      -1.287 -21.721 -16.139  1.00  0.00
ATOM    478  OD1 ASP    30      -0.682 -21.975 -17.205  1.00  0.00
ATOM    479  OD2 ASP    30      -2.136 -22.508 -15.671  1.00  0.00
ATOM    480  C   ASP    30       0.946 -21.444 -14.073  1.00  0.00
ATOM    481  O   ASP    30       0.921 -22.672 -14.123  1.00  0.00
ATOM    482  N   ASP    31       2.086 -20.743 -14.091  1.00  0.00
ATOM    483  HN  ASP    31       2.032 -19.765 -14.057  1.00  0.00
ATOM    484  CA  ASP    31       3.425 -21.361 -14.163  1.00  0.00
ATOM    485  HA  ASP    31       3.309 -22.413 -14.416  1.00  0.00
ATOM    486  CB  ASP    31       4.258 -20.668 -15.283  1.00  0.00
ATOM    487  HB1 ASP    31       3.670 -20.644 -16.196  1.00  0.00
ATOM    488  HB2 ASP    31       5.148 -21.261 -15.470  1.00  0.00
ATOM    489  CG  ASP    31       4.679 -19.220 -14.947  1.00  0.00
ATOM    490  OD1 ASP    31       5.893 -18.910 -14.968  1.00  0.00
ATOM    491  OD2 ASP    31       3.794 -18.390 -14.651  1.00  0.00
ATOM    492  C   ASP    31       4.145 -21.271 -12.798  1.00  0.00
ATOM    493  O   ASP    31       5.368 -21.436 -12.735  1.00  0.00
ATOM    494  N   CYS    32       3.372 -21.042 -11.708  1.00  0.00
ATOM    495  HN  CYS    32       2.397 -21.033 -11.820  1.00  0.00
ATOM    496  CA  CYS    32       3.929 -20.815 -10.357  1.00  0.00
ATOM    497  HA  CYS    32       4.586 -19.948 -10.425  1.00  0.00
ATOM    498  CB  CYS    32       2.822 -20.500  -9.334  1.00  0.00
ATOM    499  HB1 CYS    32       2.121 -21.327  -9.285  1.00  0.00
ATOM    500  HB2 CYS    32       2.292 -19.608  -9.643  1.00  0.00
ATOM    501  SG  CYS    32       3.442 -20.205  -7.661  1.00  0.00
ATOM    502  HG  CYS    32       3.893 -18.961  -7.609  1.00  0.00
ATOM    503  C   CYS    32       4.746 -22.018  -9.858  1.00  0.00
ATOM    504  O   CYS    32       4.315 -23.164  -9.982  1.00  0.00
ATOM    505  N   GLN    33       5.931 -21.735  -9.310  1.00  0.00
ATOM    506  HN  GLN    33       6.211 -20.795  -9.266  1.00  0.00
ATOM    507  CA  GLN    33       6.820 -22.757  -8.747  1.00  0.00
ATOM    508  HA  GLN    33       6.676 -23.687  -9.300  1.00  0.00
ATOM    509  CB  GLN    33       8.293 -22.308  -8.888  1.00  0.00
ATOM    510  HB1 GLN    33       8.940 -23.107  -8.534  1.00  0.00
ATOM    511  HB2 GLN    33       8.455 -21.432  -8.264  1.00  0.00
ATOM    512  CG  GLN    33       8.708 -21.948 -10.324  1.00  0.00
ATOM    513  HG1 GLN    33       9.714 -21.544 -10.306  1.00  0.00
ATOM    514  HG2 GLN    33       8.029 -21.185 -10.687  1.00  0.00
ATOM    515  CD  GLN    33       8.666 -23.115 -11.312  1.00  0.00
ATOM    516  OE1 GLN    33       9.627 -23.873 -11.448  1.00  0.00
ATOM    517  NE2 GLN    33       7.557 -23.249 -12.021  1.00  0.00
ATOM    518 HE21 GLN    33       6.829 -22.608 -11.869  1.00  0.00
ATOM    519 HE22 GLN    33       7.515 -23.970 -12.683  1.00  0.00
ATOM    520  C   GLN    33       6.458 -22.984  -7.273  1.00  0.00
ATOM    521  O   GLN    33       6.003 -22.058  -6.590  1.00  0.00
ATOM    522  N   TYR    34       6.660 -24.215  -6.795  1.00  0.00
ATOM    523  HN  TYR    34       7.018 -24.897  -7.399  1.00  0.00
ATOM    524  CA  TYR    34       6.366 -24.598  -5.412  1.00  0.00
ATOM    525  HA  TYR    34       6.364 -23.697  -4.801  1.00  0.00
ATOM    526  CB  TYR    34       4.974 -25.271  -5.320  1.00  0.00
ATOM    527  HB1 TYR    34       5.006 -26.231  -5.824  1.00  0.00
ATOM    528  HB2 TYR    34       4.250 -24.644  -5.830  1.00  0.00
ATOM    529  CG  TYR    34       4.468 -25.493  -3.889  1.00  0.00
ATOM    530  CD1 TYR    34       4.474 -26.760  -3.296  1.00  0.00
ATOM    531  HD1 TYR    34       4.842 -27.610  -3.864  1.00  0.00
ATOM    532  CD2 TYR    34       3.989 -24.416  -3.132  1.00  0.00
ATOM    533  HD2 TYR    34       3.970 -23.424  -3.573  1.00  0.00
ATOM    534  CE1 TYR    34       4.013 -26.943  -2.007  1.00  0.00
ATOM    535  HE1 TYR    34       4.024 -27.931  -1.565  1.00  0.00
ATOM    536  CE2 TYR    34       3.532 -24.598  -1.845  1.00  0.00
ATOM    537  HE2 TYR    34       3.165 -23.751  -1.278  1.00  0.00
ATOM    538  CZ  TYR    34       3.548 -25.860  -1.285  1.00  0.00
ATOM    539  OH  TYR    34       3.076 -26.040  -0.005  1.00  0.00
ATOM    540  HH  TYR    34       3.708 -26.559   0.500  1.00  0.00
ATOM    541  C   TYR    34       7.470 -25.531  -4.911  1.00  0.00
ATOM    542  O   TYR    34       7.623 -26.639  -5.427  1.00  0.00
ATOM    543  N   TYR    35       8.258 -25.050  -3.939  1.00  0.00
ATOM    544  HN  TYR    35       8.090 -24.143  -3.617  1.00  0.00
ATOM    545  CA  TYR    35       9.360 -25.806  -3.322  1.00  0.00
ATOM    546  HA  TYR    35       9.523 -26.709  -3.909  1.00  0.00
ATOM    547  CB  TYR    35      10.675 -24.980  -3.310  1.00  0.00
ATOM    548  HB1 TYR    35      11.435 -25.539  -2.770  1.00  0.00
ATOM    549  HB2 TYR    35      10.501 -24.053  -2.779  1.00  0.00
ATOM    550  CG  TYR    35      11.248 -24.622  -4.699  1.00  0.00
ATOM    551  CD1 TYR    35      12.419 -25.220  -5.176  1.00  0.00
ATOM    552  HD1 TYR    35      12.920 -25.960  -4.560  1.00  0.00
ATOM    553  CD2 TYR    35      10.630 -23.674  -5.519  1.00  0.00
ATOM    554  HD2 TYR    35       9.721 -23.191  -5.173  1.00  0.00
ATOM    555  CE1 TYR    35      12.942 -24.893  -6.412  1.00  0.00
ATOM    556  HE1 TYR    35      13.843 -25.374  -6.758  1.00  0.00
ATOM    557  CE2 TYR    35      11.150 -23.347  -6.756  1.00  0.00
ATOM    558  HE2 TYR    35      10.646 -22.616  -7.370  1.00  0.00
ATOM    559  CZ  TYR    35      12.306 -23.952  -7.197  1.00  0.00
ATOM    560  OH  TYR    35      12.820 -23.623  -8.433  1.00  0.00
ATOM    561  HH  TYR    35      13.041 -24.430  -8.909  1.00  0.00
ATOM    562  C   TYR    35       9.000 -26.224  -1.887  1.00  0.00
ATOM    563  O   TYR    35       8.172 -25.588  -1.222  1.00  0.00
ATOM    564  N   ALA    36       9.647 -27.307  -1.441  1.00  0.00
ATOM    565  HN  ALA    36      10.233 -27.776  -2.069  1.00  0.00
ATOM    566  CA  ALA    36       9.560 -27.833  -0.072  1.00  0.00
ATOM    567  HA  ALA    36       8.812 -27.261   0.480  1.00  0.00
ATOM    568  CB  ALA    36       9.131 -29.308  -0.103  1.00  0.00
ATOM    569  HB1 ALA    36       8.176 -29.395  -0.605  1.00  0.00
ATOM    570  HB2 ALA    36       9.038 -29.687   0.907  1.00  0.00
ATOM    571  HB3 ALA    36       9.868 -29.893  -0.640  1.00  0.00
ATOM    572  C   ALA    36      10.919 -27.677   0.619  1.00  0.00
ATOM    573  O   ALA    36      11.950 -27.634  -0.064  1.00  0.00
ATOM    574  N   PHE    37      10.898 -27.616   1.965  1.00  0.00
ATOM    575  HN  PHE    37      10.028 -27.690   2.410  1.00  0.00
ATOM    576  CA  PHE    37      12.100 -27.441   2.814  1.00  0.00
ATOM    577  HA  PHE    37      12.490 -26.449   2.624  1.00  0.00
ATOM    578  CB  PHE    37      11.685 -27.538   4.308  1.00  0.00
ATOM    579  HB1 PHE    37      11.206 -28.496   4.474  1.00  0.00
ATOM    580  HB2 PHE    37      10.960 -26.758   4.518  1.00  0.00
ATOM    581  CG  PHE    37      12.829 -27.390   5.318  1.00  0.00
ATOM    582  CD1 PHE    37      13.502 -26.179   5.459  1.00  0.00
ATOM    583  HD1 PHE    37      13.222 -25.338   4.834  1.00  0.00
ATOM    584  CD2 PHE    37      13.216 -28.454   6.136  1.00  0.00
ATOM    585  HD2 PHE    37      12.715 -29.408   6.039  1.00  0.00
ATOM    586  CE1 PHE    37      14.520 -26.033   6.380  1.00  0.00
ATOM    587  HE1 PHE    37      15.030 -25.081   6.474  1.00  0.00
ATOM    588  CE2 PHE    37      14.239 -28.307   7.056  1.00  0.00
ATOM    589  HE2 PHE    37      14.527 -29.141   7.681  1.00  0.00
ATOM    590  CZ  PHE    37      14.888 -27.095   7.179  1.00  0.00
ATOM    591  HZ  PHE    37      15.684 -26.978   7.901  1.00  0.00
ATOM    592  C   PHE    37      13.194 -28.502   2.500  1.00  0.00
ATOM    593  O   PHE    37      12.892 -29.697   2.556  1.00  0.00
ATOM    594  N   PRO    38      14.479 -28.106   2.177  1.00  0.00
ATOM    595  CA  PRO    38      14.924 -26.691   2.008  1.00  0.00
ATOM    596  HA  PRO    38      14.537 -26.075   2.819  1.00  0.00
ATOM    597  CB  PRO    38      16.467 -26.797   2.147  1.00  0.00
ATOM    598  HB1 PRO    38      16.750 -26.680   3.192  1.00  0.00
ATOM    599  HB2 PRO    38      16.955 -26.023   1.563  1.00  0.00
ATOM    600  CG  PRO    38      16.797 -28.171   1.643  1.00  0.00
ATOM    601  HG1 PRO    38      17.713 -28.531   2.101  1.00  0.00
ATOM    602  HG2 PRO    38      16.911 -28.148   0.562  1.00  0.00
ATOM    603  CD  PRO    38      15.623 -29.050   2.037  1.00  0.00
ATOM    604  HD1 PRO    38      15.819 -29.546   2.982  1.00  0.00
ATOM    605  HD2 PRO    38      15.416 -29.784   1.272  1.00  0.00
ATOM    606  C   PRO    38      14.491 -26.046   0.650  1.00  0.00
ATOM    607  O   PRO    38      13.769 -25.041   0.647  1.00  0.00
ATOM    608  N   ALA    39      14.901 -26.646  -0.492  1.00  0.00
ATOM    609  HN  ALA    39      15.417 -27.473  -0.427  1.00  0.00
ATOM    610  CA  ALA    39      14.593 -26.127  -1.842  1.00  0.00
ATOM    611  HA  ALA    39      13.665 -25.552  -1.792  1.00  0.00
ATOM    612  CB  ALA    39      15.713 -25.178  -2.326  1.00  0.00
ATOM    613  HB1 ALA    39      15.457 -24.768  -3.297  1.00  0.00
ATOM    614  HB2 ALA    39      16.645 -25.720  -2.403  1.00  0.00
ATOM    615  HB3 ALA    39      15.834 -24.365  -1.618  1.00  0.00
ATOM    616  C   ALA    39      14.388 -27.300  -2.818  1.00  0.00
ATOM    617  O   ALA    39      15.294 -27.665  -3.577  1.00  0.00
ATOM    618  N   THR    40      13.197 -27.913  -2.761  1.00  0.00
ATOM    619  HN  THR    40      12.521 -27.561  -2.142  1.00  0.00
ATOM    620  CA  THR    40      12.851 -29.096  -3.572  1.00  0.00
ATOM    621  HA  THR    40      13.657 -29.283  -4.280  1.00  0.00
ATOM    622  CB  THR    40      12.707 -30.356  -2.654  1.00  0.00
ATOM    623  HB  THR    40      11.946 -30.151  -1.903  1.00  0.00
ATOM    624  OG1 THR    40      13.957 -30.590  -1.979  1.00  0.00
ATOM    625  HG1 THR    40      13.879 -30.308  -1.067  1.00  0.00
ATOM    626  CG2 THR    40      12.296 -31.623  -3.435  1.00  0.00
ATOM    627 HG21 THR    40      13.015 -31.819  -4.220  1.00  0.00
ATOM    628 HG22 THR    40      11.315 -31.481  -3.876  1.00  0.00
ATOM    629 HG23 THR    40      12.264 -32.471  -2.765  1.00  0.00
ATOM    630  C   THR    40      11.555 -28.827  -4.355  1.00  0.00
ATOM    631  O   THR    40      10.466 -28.807  -3.771  1.00  0.00
ATOM    632  N   LEU    41      11.690 -28.604  -5.676  1.00  0.00
ATOM    633  HN  LEU    41      12.579 -28.711  -6.077  1.00  0.00
ATOM    634  CA  LEU    41      10.568 -28.232  -6.559  1.00  0.00
ATOM    635  HA  LEU    41      10.075 -27.367  -6.120  1.00  0.00
ATOM    636  CB  LEU    41      11.113 -27.835  -7.964  1.00  0.00
ATOM    637  HB1 LEU    41      11.598 -28.707  -8.395  1.00  0.00
ATOM    638  HB2 LEU    41      11.871 -27.070  -7.827  1.00  0.00
ATOM    639  CG  LEU    41      10.063 -27.304  -8.992  1.00  0.00
ATOM    640  HG  LEU    41       9.269 -28.028  -9.069  1.00  0.00
ATOM    641  CD1 LEU    41       9.414 -25.991  -8.514  1.00  0.00
ATOM    642 HD11 LEU    41      10.169 -25.224  -8.402  1.00  0.00
ATOM    643 HD12 LEU    41       8.924 -26.152  -7.563  1.00  0.00
ATOM    644 HD13 LEU    41       8.676 -25.665  -9.237  1.00  0.00
ATOM    645  CD2 LEU    41      10.680 -27.145 -10.400  1.00  0.00
ATOM    646 HD21 LEU    41      11.474 -26.407 -10.375  1.00  0.00
ATOM    647 HD22 LEU    41       9.918 -26.826 -11.099  1.00  0.00
ATOM    648 HD23 LEU    41      11.084 -28.094 -10.729  1.00  0.00
ATOM    649  C   LEU    41       9.549 -29.387  -6.673  1.00  0.00
ATOM    650  O   LEU    41       9.794 -30.377  -7.366  1.00  0.00
ATOM    651  N   LEU    42       8.424 -29.257  -5.947  1.00  0.00
ATOM    652  HN  LEU    42       8.353 -28.502  -5.331  1.00  0.00
ATOM    653  CA  LEU    42       7.306 -30.217  -6.004  1.00  0.00
ATOM    654  HA  LEU    42       7.720 -31.215  -6.065  1.00  0.00
ATOM    655  CB  LEU    42       6.422 -30.119  -4.726  1.00  0.00
ATOM    656  HB1 LEU    42       5.673 -30.904  -4.778  1.00  0.00
ATOM    657  HB2 LEU    42       5.906 -29.161  -4.745  1.00  0.00
ATOM    658  CG  LEU    42       7.155 -30.235  -3.352  1.00  0.00
ATOM    659  HG  LEU    42       7.771 -29.352  -3.218  1.00  0.00
ATOM    660  CD1 LEU    42       6.145 -30.250  -2.183  1.00  0.00
ATOM    661 HD11 LEU    42       5.491 -31.112  -2.265  1.00  0.00
ATOM    662 HD12 LEU    42       5.550 -29.348  -2.206  1.00  0.00
ATOM    663 HD13 LEU    42       6.679 -30.295  -1.243  1.00  0.00
ATOM    664  CD2 LEU    42       8.099 -31.459  -3.304  1.00  0.00
ATOM    665 HD21 LEU    42       8.577 -31.515  -2.336  1.00  0.00
ATOM    666 HD22 LEU    42       8.861 -31.355  -4.065  1.00  0.00
ATOM    667 HD23 LEU    42       7.537 -32.369  -3.483  1.00  0.00
ATOM    668  C   LEU    42       6.434 -29.958  -7.246  1.00  0.00
ATOM    669  O   LEU    42       5.915 -30.902  -7.860  1.00  0.00
ATOM    670  N   ALA    43       6.281 -28.670  -7.605  1.00  0.00
ATOM    671  HN  ALA    43       6.814 -27.988  -7.142  1.00  0.00
ATOM    672  CA  ALA    43       5.338 -28.239  -8.656  1.00  0.00
ATOM    673  HA  ALA    43       5.126 -29.084  -9.309  1.00  0.00
ATOM    674  CB  ALA    43       4.025 -27.815  -7.996  1.00  0.00
ATOM    675  HB1 ALA    43       3.306 -27.524  -8.754  1.00  0.00
ATOM    676  HB2 ALA    43       4.205 -26.979  -7.333  1.00  0.00
ATOM    677  HB3 ALA    43       3.620 -28.641  -7.424  1.00  0.00
ATOM    678  C   ALA    43       5.919 -27.088  -9.495  1.00  0.00
ATOM    679  O   ALA    43       6.235 -26.030  -8.953  1.00  0.00
ATOM    680  N   GLY    44       6.037 -27.307 -10.819  1.00  0.00
ATOM    681  HN  GLY    44       5.759 -28.179 -11.171  1.00  0.00
ATOM    682  CA  GLY    44       6.553 -26.303 -11.758  1.00  0.00
ATOM    683  HA1 GLY    44       7.207 -26.802 -12.463  1.00  0.00
ATOM    684  HA2 GLY    44       7.132 -25.564 -11.218  1.00  0.00
ATOM    685  C   GLY    44       5.441 -25.590 -12.533  1.00  0.00
ATOM    686  O   GLY    44       5.641 -25.190 -13.688  1.00  0.00
ATOM    687  N   ASN    45       4.307 -25.374 -11.842  1.00  0.00
ATOM    688  HN  ASN    45       4.350 -25.502 -10.870  1.00  0.00
ATOM    689  CA  ASN    45       3.029 -24.853 -12.409  1.00  0.00
ATOM    690  HA  ASN    45       3.173 -23.789 -12.573  1.00  0.00
ATOM    691  CB  ASN    45       2.606 -25.511 -13.767  1.00  0.00
ATOM    692  HB1 ASN    45       3.409 -25.382 -14.484  1.00  0.00
ATOM    693  HB2 ASN    45       1.735 -24.993 -14.147  1.00  0.00
ATOM    694  CG  ASN    45       2.271 -27.002 -13.667  1.00  0.00
ATOM    695  OD1 ASN    45       1.137 -27.384 -13.375  1.00  0.00
ATOM    696  ND2 ASN    45       3.246 -27.850 -13.945  1.00  0.00
ATOM    697 HD21 ASN    45       4.118 -27.483 -14.196  1.00  0.00
ATOM    698 HD22 ASN    45       3.059 -28.809 -13.885  1.00  0.00
ATOM    699  C   ASN    45       1.893 -25.018 -11.376  1.00  0.00
ATOM    700  O   ASN    45       1.989 -25.849 -10.466  1.00  0.00
ATOM    701  N   ALA    46       0.798 -24.256 -11.582  1.00  0.00
ATOM    702  HN  ALA    46       0.750 -23.746 -12.414  1.00  0.00
ATOM    703  CA  ALA    46      -0.338 -24.151 -10.638  1.00  0.00
ATOM    704  HA  ALA    46       0.060 -23.852  -9.672  1.00  0.00
ATOM    705  CB  ALA    46      -1.298 -23.046 -11.110  1.00  0.00
ATOM    706  HB1 ALA    46      -2.094 -22.908 -10.387  1.00  0.00
ATOM    707  HB2 ALA    46      -1.728 -23.316 -12.068  1.00  0.00
ATOM    708  HB3 ALA    46      -0.757 -22.114 -11.218  1.00  0.00
ATOM    709  C   ALA    46      -1.103 -25.482 -10.467  1.00  0.00
ATOM    710  O   ALA    46      -1.540 -25.816  -9.361  1.00  0.00
ATOM    711  N   ALA    47      -1.235 -26.238 -11.569  1.00  0.00
ATOM    712  HN  ALA    47      -0.755 -25.965 -12.382  1.00  0.00
ATOM    713  CA  ALA    47      -2.052 -27.468 -11.611  1.00  0.00
ATOM    714  HA  ALA    47      -3.072 -27.190 -11.352  1.00  0.00
ATOM    715  CB  ALA    47      -2.072 -28.062 -13.023  1.00  0.00
ATOM    716  HB1 ALA    47      -1.077 -28.410 -13.288  1.00  0.00
ATOM    717  HB2 ALA    47      -2.388 -27.309 -13.732  1.00  0.00
ATOM    718  HB3 ALA    47      -2.766 -28.896 -13.059  1.00  0.00
ATOM    719  C   ALA    47      -1.556 -28.516 -10.610  1.00  0.00
ATOM    720  O   ALA    47      -2.352 -29.223  -9.997  1.00  0.00
ATOM    721  N   GLU    48      -0.233 -28.614 -10.469  1.00  0.00
ATOM    722  HN  GLU    48       0.342 -28.017 -11.000  1.00  0.00
ATOM    723  CA  GLU    48       0.402 -29.568  -9.545  1.00  0.00
ATOM    724  HA  GLU    48      -0.139 -30.512  -9.619  1.00  0.00
ATOM    725  CB  GLU    48       1.867 -29.812  -9.970  1.00  0.00
ATOM    726  HB1 GLU    48       2.267 -30.649  -9.402  1.00  0.00
ATOM    727  HB2 GLU    48       2.450 -28.928  -9.739  1.00  0.00
ATOM    728  CG  GLU    48       2.051 -30.115 -11.465  1.00  0.00
ATOM    729  HG1 GLU    48       1.758 -29.236 -12.036  1.00  0.00
ATOM    730  HG2 GLU    48       1.391 -30.934 -11.741  1.00  0.00
ATOM    731  CD  GLU    48       3.504 -30.470 -11.823  1.00  0.00
ATOM    732  OE1 GLU    48       4.355 -29.560 -11.862  1.00  0.00
ATOM    733  OE2 GLU    48       3.797 -31.653 -12.083  1.00  0.00
ATOM    734  C   GLU    48       0.311 -29.068  -8.083  1.00  0.00
ATOM    735  O   GLU    48       0.176 -29.872  -7.152  1.00  0.00
ATOM    736  N   ILE    49       0.366 -27.724  -7.907  1.00  0.00
ATOM    737  HN  ILE    49       0.462 -27.157  -8.704  1.00  0.00
ATOM    738  CA  ILE    49       0.289 -27.064  -6.580  1.00  0.00
ATOM    739  HA  ILE    49       1.096 -27.457  -5.965  1.00  0.00
ATOM    740  CB  ILE    49       0.469 -25.495  -6.690  1.00  0.00
ATOM    741  HB  ILE    49      -0.315 -25.121  -7.346  1.00  0.00
ATOM    742  CG1 ILE    49       1.846 -25.144  -7.321  1.00  0.00
ATOM    743 HG11 ILE    49       1.937 -25.649  -8.277  1.00  0.00
ATOM    744 HG12 ILE    49       2.634 -25.501  -6.672  1.00  0.00
ATOM    745  CG2 ILE    49       0.297 -24.792  -5.316  1.00  0.00
ATOM    746 HG21 ILE    49       1.051 -25.147  -4.623  1.00  0.00
ATOM    747 HG22 ILE    49      -0.685 -25.006  -4.913  1.00  0.00
ATOM    748 HG23 ILE    49       0.399 -23.721  -5.439  1.00  0.00
ATOM    749  CD1 ILE    49       2.103 -23.670  -7.561  1.00  0.00
ATOM    750 HD11 ILE    49       1.338 -23.263  -8.208  1.00  0.00
ATOM    751 HD12 ILE    49       3.069 -23.547  -8.031  1.00  0.00
ATOM    752 HD13 ILE    49       2.098 -23.141  -6.619  1.00  0.00
ATOM    753  C   ILE    49      -1.055 -27.367  -5.898  1.00  0.00
ATOM    754  O   ILE    49      -1.088 -27.781  -4.727  1.00  0.00
ATOM    755  N   ARG    50      -2.158 -27.149  -6.646  1.00  0.00
ATOM    756  HN  ARG    50      -2.046 -26.855  -7.582  1.00  0.00
ATOM    757  CA  ARG    50      -3.520 -27.338  -6.116  1.00  0.00
ATOM    758  HA  ARG    50      -3.600 -26.716  -5.224  1.00  0.00
ATOM    759  CB  ARG    50      -4.611 -26.869  -7.122  1.00  0.00
ATOM    760  HB1 ARG    50      -4.481 -25.804  -7.291  1.00  0.00
ATOM    761  HB2 ARG    50      -5.590 -27.021  -6.675  1.00  0.00
ATOM    762  CG  ARG    50      -4.592 -27.580  -8.493  1.00  0.00
ATOM    763  HG1 ARG    50      -4.813 -28.633  -8.340  1.00  0.00
ATOM    764  HG2 ARG    50      -3.598 -27.490  -8.915  1.00  0.00
ATOM    765  CD  ARG    50      -5.596 -27.004  -9.492  1.00  0.00
ATOM    766  HD1 ARG    50      -5.375 -25.950  -9.646  1.00  0.00
ATOM    767  HD2 ARG    50      -6.595 -27.100  -9.080  1.00  0.00
ATOM    768  NE  ARG    50      -5.558 -27.703 -10.798  1.00  0.00
ATOM    769  HE  ARG    50      -5.351 -28.667 -10.777  1.00  0.00
ATOM    770  CZ  ARG    50      -5.793 -27.131 -11.995  1.00  0.00
ATOM    771  NH1 ARG    50      -6.067 -25.835 -12.087  1.00  0.00
ATOM    772 HH11 ARG    50      -6.107 -25.271 -11.264  1.00  0.00
ATOM    773 HH12 ARG    50      -6.224 -25.413 -12.988  1.00  0.00
ATOM    774  NH2 ARG    50      -5.749 -27.866 -13.097  1.00  0.00
ATOM    775 HH21 ARG    50      -5.543 -28.847 -13.045  1.00  0.00
ATOM    776 HH22 ARG    50      -5.925 -27.449 -13.992  1.00  0.00
ATOM    777  C   ARG    50      -3.740 -28.803  -5.705  1.00  0.00
ATOM    778  O   ARG    50      -4.128 -29.045  -4.574  1.00  0.00
ATOM    779  N   VAL    51      -3.408 -29.760  -6.610  1.00  0.00
ATOM    780  HN  VAL    51      -2.984 -29.477  -7.452  1.00  0.00
ATOM    781  CA  VAL    51      -3.637 -31.211  -6.391  1.00  0.00
ATOM    782  HA  VAL    51      -4.704 -31.352  -6.235  1.00  0.00
ATOM    783  CB  VAL    51      -3.214 -32.066  -7.648  1.00  0.00
ATOM    784  HB  VAL    51      -2.162 -31.866  -7.847  1.00  0.00
ATOM    785  CG1 VAL    51      -3.369 -33.593  -7.393  1.00  0.00
ATOM    786 HG11 VAL    51      -4.403 -33.823  -7.163  1.00  0.00
ATOM    787 HG12 VAL    51      -2.745 -33.892  -6.559  1.00  0.00
ATOM    788 HG13 VAL    51      -3.067 -34.144  -8.275  1.00  0.00
ATOM    789  CG2 VAL    51      -4.019 -31.637  -8.900  1.00  0.00
ATOM    790 HG21 VAL    51      -5.072 -31.835  -8.747  1.00  0.00
ATOM    791 HG22 VAL    51      -3.674 -32.188  -9.766  1.00  0.00
ATOM    792 HG23 VAL    51      -3.881 -30.576  -9.080  1.00  0.00
ATOM    793  C   VAL    51      -2.891 -31.695  -5.136  1.00  0.00
ATOM    794  O   VAL    51      -3.461 -32.419  -4.314  1.00  0.00
ATOM    795  N   ARG    52      -1.635 -31.228  -4.987  1.00  0.00
ATOM    796  HN  ARG    52      -1.264 -30.665  -5.700  1.00  0.00
ATOM    797  CA  ARG    52      -0.787 -31.528  -3.816  1.00  0.00
ATOM    798  HA  ARG    52      -0.610 -32.599  -3.805  1.00  0.00
ATOM    799  CB  ARG    52       0.581 -30.793  -3.923  1.00  0.00
ATOM    800  HB1 ARG    52       0.399 -29.724  -3.949  1.00  0.00
ATOM    801  HB2 ARG    52       1.051 -31.077  -4.858  1.00  0.00
ATOM    802  CG  ARG    52       1.589 -31.090  -2.777  1.00  0.00
ATOM    803  HG1 ARG    52       1.032 -31.227  -1.851  1.00  0.00
ATOM    804  HG2 ARG    52       2.244 -30.234  -2.662  1.00  0.00
ATOM    805  CD  ARG    52       2.462 -32.347  -3.023  1.00  0.00
ATOM    806  HD1 ARG    52       3.163 -32.435  -2.209  1.00  0.00
ATOM    807  HD2 ARG    52       3.018 -32.207  -3.944  1.00  0.00
ATOM    808  NE  ARG    52       1.695 -33.613  -3.138  1.00  0.00
ATOM    809  HE  ARG    52       0.724 -33.541  -3.267  1.00  0.00
ATOM    810  CZ  ARG    52       2.234 -34.846  -3.134  1.00  0.00
ATOM    811  NH1 ARG    52       3.523 -35.031  -2.888  1.00  0.00
ATOM    812 HH11 ARG    52       4.121 -34.248  -2.699  1.00  0.00
ATOM    813 HH12 ARG    52       3.910 -35.958  -2.895  1.00  0.00
ATOM    814  NH2 ARG    52       1.462 -35.896  -3.349  1.00  0.00
ATOM    815 HH21 ARG    52       0.479 -35.774  -3.517  1.00  0.00
ATOM    816 HH22 ARG    52       1.850 -36.820  -3.358  1.00  0.00
ATOM    817  C   ARG    52      -1.503 -31.133  -2.509  1.00  0.00
ATOM    818  O   ARG    52      -1.497 -31.883  -1.526  1.00  0.00
ATOM    819  N   HIS    53      -2.128 -29.944  -2.525  1.00  0.00
ATOM    820  HN  HIS    53      -2.103 -29.412  -3.355  1.00  0.00
ATOM    821  CA  HIS    53      -2.855 -29.406  -1.362  1.00  0.00
ATOM    822  HA  HIS    53      -2.267 -29.645  -0.476  1.00  0.00
ATOM    823  CB  HIS    53      -2.965 -27.871  -1.457  1.00  0.00
ATOM    824  HB1 HIS    53      -3.635 -27.503  -0.681  1.00  0.00
ATOM    825  HB2 HIS    53      -3.366 -27.600  -2.427  1.00  0.00
ATOM    826  CG  HIS    53      -1.648 -27.161  -1.283  1.00  0.00
ATOM    827  ND1 HIS    53      -1.079 -26.368  -2.258  1.00  0.00
ATOM    828  HD1 HIS    53      -1.440 -26.224  -3.161  1.00  0.00
ATOM    829  CD2 HIS    53      -0.817 -27.093  -0.214  1.00  0.00
ATOM    830  HD2 HIS    53      -0.952 -27.596   0.738  1.00  0.00
ATOM    831  CE1 HIS    53       0.038 -25.842  -1.797  1.00  0.00
ATOM    832  HE1 HIS    53       0.695 -25.175  -2.338  1.00  0.00
ATOM    833  NE2 HIS    53       0.216 -26.263  -0.560  1.00  0.00
ATOM    834  HE2 HIS    53       0.983 -26.034   0.015  1.00  0.00
ATOM    835  C   HIS    53      -4.242 -30.048  -1.190  1.00  0.00
ATOM    836  O   HIS    53      -4.702 -30.155  -0.073  1.00  0.00
ATOM    837  N   ILE    54      -4.888 -30.480  -2.288  1.00  0.00
ATOM    838  HN  ILE    54      -4.454 -30.385  -3.158  1.00  0.00
ATOM    839  CA  ILE    54      -6.223 -31.128  -2.237  1.00  0.00
ATOM    840  HA  ILE    54      -6.912 -30.438  -1.750  1.00  0.00
ATOM    841  CB  ILE    54      -6.754 -31.421  -3.692  1.00  0.00
ATOM    842  HB  ILE    54      -5.970 -31.954  -4.221  1.00  0.00
ATOM    843  CG1 ILE    54      -7.043 -30.094  -4.455  1.00  0.00
ATOM    844 HG11 ILE    54      -6.175 -29.451  -4.396  1.00  0.00
ATOM    845 HG12 ILE    54      -7.875 -29.586  -3.988  1.00  0.00
ATOM    846  CG2 ILE    54      -8.005 -32.322  -3.689  1.00  0.00
ATOM    847 HG21 ILE    54      -8.326 -32.509  -4.706  1.00  0.00
ATOM    848 HG22 ILE    54      -8.805 -31.837  -3.149  1.00  0.00
ATOM    849 HG23 ILE    54      -7.775 -33.267  -3.209  1.00  0.00
ATOM    850  CD1 ILE    54      -7.383 -30.256  -5.923  1.00  0.00
ATOM    851 HD11 ILE    54      -6.574 -30.774  -6.425  1.00  0.00
ATOM    852 HD12 ILE    54      -7.516 -29.281  -6.368  1.00  0.00
ATOM    853 HD13 ILE    54      -8.294 -30.825  -6.023  1.00  0.00
ATOM    854  C   ILE    54      -6.139 -32.425  -1.408  1.00  0.00
ATOM    855  O   ILE    54      -7.042 -32.737  -0.627  1.00  0.00
ATOM    856  N   GLU    55      -5.011 -33.137  -1.584  1.00  0.00
ATOM    857  HN  GLU    55      -4.387 -32.842  -2.287  1.00  0.00
ATOM    858  CA  GLU    55      -4.661 -34.337  -0.799  1.00  0.00
ATOM    859  HA  GLU    55      -5.442 -35.081  -0.961  1.00  0.00
ATOM    860  CB  GLU    55      -3.309 -34.900  -1.311  1.00  0.00
ATOM    861  HB1 GLU    55      -3.057 -35.796  -0.746  1.00  0.00
ATOM    862  HB2 GLU    55      -2.533 -34.154  -1.141  1.00  0.00
ATOM    863  CG  GLU    55      -3.303 -35.260  -2.811  1.00  0.00
ATOM    864  HG1 GLU    55      -3.646 -34.396  -3.377  1.00  0.00
ATOM    865  HG2 GLU    55      -3.998 -36.075  -2.980  1.00  0.00
ATOM    866  CD  GLU    55      -1.912 -35.671  -3.321  1.00  0.00
ATOM    867  OE1 GLU    55      -1.504 -36.835  -3.108  1.00  0.00
ATOM    868  OE2 GLU    55      -1.201 -34.826  -3.908  1.00  0.00
ATOM    869  C   GLU    55      -4.589 -34.001   0.707  1.00  0.00
ATOM    870  O   GLU    55      -5.053 -34.776   1.547  1.00  0.00
ATOM    871  N   ARG    56      -4.022 -32.822   1.019  1.00  0.00
ATOM    872  HN  ARG    56      -3.640 -32.283   0.290  1.00  0.00
ATOM    873  CA  ARG    56      -3.933 -32.309   2.403  1.00  0.00
ATOM    874  HA  ARG    56      -3.552 -33.117   3.025  1.00  0.00
ATOM    875  CB  ARG    56      -2.925 -31.123   2.465  1.00  0.00
ATOM    876  HB1 ARG    56      -3.324 -30.300   1.880  1.00  0.00
ATOM    877  HB2 ARG    56      -1.991 -31.438   2.009  1.00  0.00
ATOM    878  CG  ARG    56      -2.610 -30.595   3.886  1.00  0.00
ATOM    879  HG1 ARG    56      -3.521 -30.187   4.312  1.00  0.00
ATOM    880  HG2 ARG    56      -1.874 -29.805   3.809  1.00  0.00
ATOM    881  CD  ARG    56      -2.065 -31.690   4.833  1.00  0.00
ATOM    882  HD1 ARG    56      -2.833 -32.446   4.967  1.00  0.00
ATOM    883  HD2 ARG    56      -1.841 -31.244   5.798  1.00  0.00
ATOM    884  NE  ARG    56      -0.838 -32.328   4.315  1.00  0.00
ATOM    885  HE  ARG    56      -0.259 -31.772   3.752  1.00  0.00
ATOM    886  CZ  ARG    56      -0.454 -33.590   4.565  1.00  0.00
ATOM    887  NH1 ARG    56      -1.223 -34.418   5.262  1.00  0.00
ATOM    888 HH11 ARG    56      -2.117 -34.112   5.603  1.00  0.00
ATOM    889 HH12 ARG    56      -0.919 -35.355   5.446  1.00  0.00
ATOM    890  NH2 ARG    56       0.694 -34.032   4.076  1.00  0.00
ATOM    891 HH21 ARG    56       1.269 -33.433   3.517  1.00  0.00
ATOM    892 HH22 ARG    56       0.996 -34.974   4.261  1.00  0.00
ATOM    893  C   ARG    56      -5.334 -31.891   2.936  1.00  0.00
ATOM    894  O   ARG    56      -5.620 -32.033   4.128  1.00  0.00
ATOM    895  N   PHE    57      -6.204 -31.392   2.029  1.00  0.00
ATOM    896  HN  PHE    57      -5.910 -31.324   1.097  1.00  0.00
ATOM    897  CA  PHE    57      -7.585 -30.948   2.363  1.00  0.00
ATOM    898  HA  PHE    57      -7.532 -30.378   3.288  1.00  0.00
ATOM    899  CB  PHE    57      -8.155 -30.015   1.240  1.00  0.00
ATOM    900  HB1 PHE    57      -9.239 -29.995   1.315  1.00  0.00
ATOM    901  HB2 PHE    57      -7.892 -30.433   0.277  1.00  0.00
ATOM    902  CG  PHE    57      -7.661 -28.555   1.239  1.00  0.00
ATOM    903  CD1 PHE    57      -6.323 -28.234   1.443  1.00  0.00
ATOM    904  HD1 PHE    57      -5.612 -29.028   1.633  1.00  0.00
ATOM    905  CD2 PHE    57      -8.549 -27.500   0.998  1.00  0.00
ATOM    906  HD2 PHE    57      -9.600 -27.716   0.836  1.00  0.00
ATOM    907  CE1 PHE    57      -5.887 -26.925   1.408  1.00  0.00
ATOM    908  HE1 PHE    57      -4.841 -26.702   1.568  1.00  0.00
ATOM    909  CE2 PHE    57      -8.111 -26.188   0.969  1.00  0.00
ATOM    910  HE2 PHE    57      -8.813 -25.386   0.782  1.00  0.00
ATOM    911  CZ  PHE    57      -6.779 -25.904   1.172  1.00  0.00
ATOM    912  HZ  PHE    57      -6.434 -24.879   1.146  1.00  0.00
ATOM    913  C   PHE    57      -8.536 -32.152   2.606  1.00  0.00
ATOM    914  O   PHE    57      -9.682 -31.953   3.023  1.00  0.00
ATOM    915  N   LYS    58      -8.074 -33.393   2.318  1.00  0.00
ATOM    916  HN  LYS    58      -7.206 -33.481   1.866  1.00  0.00
ATOM    917  CA  LYS    58      -8.839 -34.627   2.627  1.00  0.00
ATOM    918  HA  LYS    58      -9.859 -34.477   2.281  1.00  0.00
ATOM    919  CB  LYS    58      -8.243 -35.850   1.885  1.00  0.00
ATOM    920  HB1 LYS    58      -8.840 -36.730   2.113  1.00  0.00
ATOM    921  HB2 LYS    58      -7.231 -36.015   2.245  1.00  0.00
ATOM    922  CG  LYS    58      -8.181 -35.689   0.356  1.00  0.00
ATOM    923  HG1 LYS    58      -7.812 -36.613  -0.078  1.00  0.00
ATOM    924  HG2 LYS    58      -7.483 -34.889   0.124  1.00  0.00
ATOM    925  CD  LYS    58      -9.552 -35.346  -0.276  1.00  0.00
ATOM    926  HD1 LYS    58      -9.987 -34.502   0.249  1.00  0.00
ATOM    927  HD2 LYS    58     -10.211 -36.201  -0.182  1.00  0.00
ATOM    928  CE  LYS    58      -9.426 -34.987  -1.757  1.00  0.00
ATOM    929  HE1 LYS    58      -9.070 -35.848  -2.300  1.00  0.00
ATOM    930  HE2 LYS    58      -8.711 -34.181  -1.866  1.00  0.00
ATOM    931  NZ  LYS    58     -10.715 -34.548  -2.334  1.00  0.00
ATOM    932  HZ1 LYS    58     -11.058 -33.699  -1.837  1.00  0.00
ATOM    933  HZ2 LYS    58     -11.426 -35.302  -2.237  1.00  0.00
ATOM    934  HZ3 LYS    58     -10.596 -34.324  -3.338  1.00  0.00
ATOM    935  C   LYS    58      -8.880 -34.902   4.139  1.00  0.00
ATOM    936  O   LYS    58      -9.810 -35.558   4.624  1.00  0.00
ATOM    937  N   GLU    59      -7.848 -34.424   4.866  1.00  0.00
ATOM    938  HN  GLU    59      -7.096 -34.001   4.395  1.00  0.00
ATOM    939  CA  GLU    59      -7.802 -34.505   6.334  1.00  0.00
ATOM    940  HA  GLU    59      -8.011 -35.534   6.612  1.00  0.00
ATOM    941  CB  GLU    59      -6.395 -34.117   6.888  1.00  0.00
ATOM    942  HB1 GLU    59      -6.483 -33.914   7.951  1.00  0.00
ATOM    943  HB2 GLU    59      -6.068 -33.205   6.395  1.00  0.00
ATOM    944  CG  GLU    59      -5.294 -35.190   6.700  1.00  0.00
ATOM    945  HG1 GLU    59      -5.636 -36.116   7.159  1.00  0.00
ATOM    946  HG2 GLU    59      -4.403 -34.863   7.228  1.00  0.00
ATOM    947  CD  GLU    59      -4.917 -35.468   5.229  1.00  0.00
ATOM    948  OE1 GLU    59      -5.500 -36.392   4.608  1.00  0.00
ATOM    949  OE2 GLU    59      -4.030 -34.772   4.698  1.00  0.00
ATOM    950  C   GLU    59      -8.893 -33.597   6.933  1.00  0.00
ATOM    951  O   GLU    59      -8.849 -32.384   6.724  1.00  0.00
ATOM    952  N   PRO    60      -9.906 -34.161   7.674  1.00  0.00
ATOM    953  CA  PRO    60     -10.942 -33.342   8.356  1.00  0.00
ATOM    954  HA  PRO    60     -11.427 -32.665   7.661  1.00  0.00
ATOM    955  CB  PRO    60     -11.959 -34.398   8.862  1.00  0.00
ATOM    956  HB1 PRO    60     -12.746 -34.531   8.122  1.00  0.00
ATOM    957  HB2 PRO    60     -12.407 -34.076   9.797  1.00  0.00
ATOM    958  CG  PRO    60     -11.148 -35.653   9.029  1.00  0.00
ATOM    959  HG1 PRO    60     -11.783 -36.527   8.927  1.00  0.00
ATOM    960  HG2 PRO    60     -10.668 -35.659  10.006  1.00  0.00
ATOM    961  CD  PRO    60     -10.112 -35.619   7.924  1.00  0.00
ATOM    962  HD1 PRO    60     -10.484 -36.107   7.030  1.00  0.00
ATOM    963  HD2 PRO    60      -9.189 -36.089   8.251  1.00  0.00
ATOM    964  C   PRO    60     -10.324 -32.526   9.518  1.00  0.00
ATOM    965  O   PRO    60     -10.854 -31.489   9.933  1.00  0.00
ATOM    966  N   ASP    61      -9.169 -33.022   9.991  1.00  0.00
ATOM    967  HN  ASP    61      -8.815 -33.826   9.561  1.00  0.00
ATOM    968  CA  ASP    61      -8.383 -32.455  11.093  1.00  0.00
ATOM    969  HA  ASP    61      -9.070 -32.015  11.810  1.00  0.00
ATOM    970  CB  ASP    61      -7.609 -33.601  11.794  1.00  0.00
ATOM    971  HB1 ASP    61      -8.322 -34.253  12.287  1.00  0.00
ATOM    972  HB2 ASP    61      -6.956 -33.183  12.556  1.00  0.00
ATOM    973  CG  ASP    61      -6.756 -34.455  10.824  1.00  0.00
ATOM    974  OD1 ASP    61      -5.547 -34.192  10.674  1.00  0.00
ATOM    975  OD2 ASP    61      -7.305 -35.406  10.215  1.00  0.00
ATOM    976  C   ASP    61      -7.413 -31.352  10.623  1.00  0.00
ATOM    977  O   ASP    61      -6.754 -30.720  11.462  1.00  0.00
ATOM    978  N   LEU    62      -7.318 -31.129   9.291  1.00  0.00
ATOM    979  HN  LEU    62      -7.811 -31.708   8.679  1.00  0.00
ATOM    980  CA  LEU    62      -6.494 -30.040   8.727  1.00  0.00
ATOM    981  HA  LEU    62      -5.474 -30.172   9.090  1.00  0.00
ATOM    982  CB  LEU    62      -6.475 -30.062   7.168  1.00  0.00
ATOM    983  HB1 LEU    62      -7.502 -30.058   6.817  1.00  0.00
ATOM    984  HB2 LEU    62      -6.010 -30.990   6.844  1.00  0.00
ATOM    985  CG  LEU    62      -5.719 -28.856   6.503  1.00  0.00
ATOM    986  HG  LEU    62      -6.098 -27.939   6.942  1.00  0.00
ATOM    987  CD1 LEU    62      -4.214 -28.898   6.824  1.00  0.00
ATOM    988 HD11 LEU    62      -3.776 -29.810   6.436  1.00  0.00
ATOM    989 HD12 LEU    62      -4.069 -28.860   7.897  1.00  0.00
ATOM    990 HD13 LEU    62      -3.724 -28.045   6.374  1.00  0.00
ATOM    991  CD2 LEU    62      -5.976 -28.767   4.987  1.00  0.00
ATOM    992 HD21 LEU    62      -5.614 -29.663   4.497  1.00  0.00
ATOM    993 HD22 LEU    62      -5.466 -27.904   4.578  1.00  0.00
ATOM    994 HD23 LEU    62      -7.039 -28.667   4.805  1.00  0.00
ATOM    995  C   LEU    62      -7.024 -28.673   9.193  1.00  0.00
ATOM    996  O   LEU    62      -8.181 -28.332   8.930  1.00  0.00
ATOM    997  N   TYR    63      -6.169 -27.902   9.876  1.00  0.00
ATOM    998  HN  TYR    63      -5.303 -28.282  10.141  1.00  0.00
ATOM    999  CA  TYR    63      -6.484 -26.522  10.257  1.00  0.00
ATOM   1000  HA  TYR    63      -7.120 -26.093   9.484  1.00  0.00
ATOM   1001  CB  TYR    63      -7.248 -26.497  11.610  1.00  0.00
ATOM   1002  HB1 TYR    63      -6.596 -26.860  12.393  1.00  0.00
ATOM   1003  HB2 TYR    63      -8.108 -27.157  11.545  1.00  0.00
ATOM   1004  CG  TYR    63      -7.756 -25.106  12.011  1.00  0.00
ATOM   1005  CD1 TYR    63      -8.895 -24.564  11.412  1.00  0.00
ATOM   1006  HD1 TYR    63      -9.432 -25.148  10.672  1.00  0.00
ATOM   1007  CD2 TYR    63      -7.089 -24.331  12.963  1.00  0.00
ATOM   1008  HD2 TYR    63      -6.204 -24.733  13.447  1.00  0.00
ATOM   1009  CE1 TYR    63      -9.355 -23.305  11.754  1.00  0.00
ATOM   1010  HE1 TYR    63     -10.241 -22.910  11.279  1.00  0.00
ATOM   1011  CE2 TYR    63      -7.548 -23.074  13.309  1.00  0.00
ATOM   1012  HE2 TYR    63      -7.014 -22.493  14.052  1.00  0.00
ATOM   1013  CZ  TYR    63      -8.674 -22.562  12.699  1.00  0.00
ATOM   1014  OH  TYR    63      -9.124 -21.307  13.039  1.00  0.00
ATOM   1015  HH  TYR    63      -8.371 -20.697  13.085  1.00  0.00
ATOM   1016  C   TYR    63      -5.186 -25.702  10.342  1.00  0.00
ATOM   1017  O   TYR    63      -4.316 -26.004  11.162  1.00  0.00
ATOM   1018  N   GLY    64      -5.066 -24.667   9.493  1.00  0.00
ATOM   1019  HN  GLY    64      -5.752 -24.532   8.814  1.00  0.00
ATOM   1020  CA  GLY    64      -3.939 -23.738   9.559  1.00  0.00
ATOM   1021  HA1 GLY    64      -3.723 -23.383   8.558  1.00  0.00
ATOM   1022  HA2 GLY    64      -3.058 -24.241   9.944  1.00  0.00
ATOM   1023  C   GLY    64      -4.286 -22.551  10.439  1.00  0.00
ATOM   1024  O   GLY    64      -5.040 -21.668  10.015  1.00  0.00
ATOM   1025  N   GLU    65      -3.767 -22.554  11.678  1.00  0.00
ATOM   1026  HN  GLU    65      -3.223 -23.324  11.955  1.00  0.00
ATOM   1027  CA  GLU    65      -3.981 -21.460  12.641  1.00  0.00
ATOM   1028  HA  GLU    65      -4.893 -20.934  12.359  1.00  0.00
ATOM   1029  CB  GLU    65      -4.157 -22.022  14.079  1.00  0.00
ATOM   1030  HB1 GLU    65      -3.276 -22.602  14.337  1.00  0.00
ATOM   1031  HB2 GLU    65      -5.016 -22.682  14.086  1.00  0.00
ATOM   1032  CG  GLU    65      -4.365 -20.940  15.164  1.00  0.00
ATOM   1033  HG1 GLU    65      -5.112 -20.237  14.811  1.00  0.00
ATOM   1034  HG2 GLU    65      -3.430 -20.404  15.301  1.00  0.00
ATOM   1035  CD  GLU    65      -4.810 -21.501  16.529  1.00  0.00
ATOM   1036  OE1 GLU    65      -3.973 -22.103  17.236  1.00  0.00
ATOM   1037  OE2 GLU    65      -5.989 -21.319  16.912  1.00  0.00
ATOM   1038  C   GLU    65      -2.805 -20.484  12.573  1.00  0.00
ATOM   1039  O   GLU    65      -1.716 -20.782  13.081  1.00  0.00
ATOM   1040  N   LEU    66      -3.025 -19.335  11.914  1.00  0.00
ATOM   1041  HN  LEU    66      -3.920 -19.164  11.554  1.00  0.00
ATOM   1042  CA  LEU    66      -1.977 -18.329  11.725  1.00  0.00
ATOM   1043  HA  LEU    66      -1.106 -18.842  11.325  1.00  0.00
ATOM   1044  CB  LEU    66      -2.394 -17.227  10.735  1.00  0.00
ATOM   1045  HB1 LEU    66      -3.212 -16.659  11.175  1.00  0.00
ATOM   1046  HB2 LEU    66      -2.770 -17.702   9.831  1.00  0.00
ATOM   1047  CG  LEU    66      -1.236 -16.235  10.348  1.00  0.00
ATOM   1048  HG  LEU    66      -0.560 -16.154  11.204  1.00  0.00
ATOM   1049  CD1 LEU    66      -0.385 -16.773   9.174  1.00  0.00
ATOM   1050 HD11 LEU    66       0.388 -16.056   8.929  1.00  0.00
ATOM   1051 HD12 LEU    66      -1.017 -16.932   8.304  1.00  0.00
ATOM   1052 HD13 LEU    66       0.076 -17.713   9.455  1.00  0.00
ATOM   1053  CD2 LEU    66      -1.774 -14.828  10.053  1.00  0.00
ATOM   1054 HD21 LEU    66      -2.436 -14.862   9.196  1.00  0.00
ATOM   1055 HD22 LEU    66      -0.950 -14.162   9.843  1.00  0.00
ATOM   1056 HD23 LEU    66      -2.318 -14.458  10.911  1.00  0.00
ATOM   1057  C   LEU    66      -1.596 -17.678  13.066  1.00  0.00
ATOM   1058  O   LEU    66      -2.457 -17.389  13.903  1.00  0.00
ATOM   1059  N   LEU    67      -0.296 -17.458  13.229  1.00  0.00
ATOM   1060  HN  LEU    67       0.304 -17.721  12.501  1.00  0.00
ATOM   1061  CA  LEU    67       0.300 -16.857  14.426  1.00  0.00
ATOM   1062  HA  LEU    67      -0.420 -16.849  15.242  1.00  0.00
ATOM   1063  CB  LEU    67       1.533 -17.710  14.815  1.00  0.00
ATOM   1064  HB1 LEU    67       1.818 -17.465  15.834  1.00  0.00
ATOM   1065  HB2 LEU    67       2.362 -17.437  14.158  1.00  0.00
ATOM   1066  CG  LEU    67       1.325 -19.248  14.715  1.00  0.00
ATOM   1067  HG  LEU    67       0.803 -19.457  13.785  1.00  0.00
ATOM   1068  CD1 LEU    67       2.662 -19.982  14.639  1.00  0.00
ATOM   1069 HD11 LEU    67       3.244 -19.789  15.531  1.00  0.00
ATOM   1070 HD12 LEU    67       3.205 -19.626  13.771  1.00  0.00
ATOM   1071 HD13 LEU    67       2.493 -21.046  14.539  1.00  0.00
ATOM   1072  CD2 LEU    67       0.450 -19.774  15.865  1.00  0.00
ATOM   1073 HD21 LEU    67      -0.520 -19.295  15.822  1.00  0.00
ATOM   1074 HD22 LEU    67       0.919 -19.555  16.815  1.00  0.00
ATOM   1075 HD23 LEU    67       0.324 -20.845  15.765  1.00  0.00
ATOM   1076  C   LEU    67       0.747 -15.437  14.081  1.00  0.00
ATOM   1077  O   LEU    67       0.355 -14.454  14.717  1.00  0.00
ATOM   1078  N   THR    68       1.537 -15.371  13.005  1.00  0.00
ATOM   1079  HN  THR    68       1.670 -16.197  12.483  1.00  0.00
ATOM   1080  CA  THR    68       2.230 -14.158  12.560  1.00  0.00
ATOM   1081  HA  THR    68       1.645 -13.294  12.870  1.00  0.00
ATOM   1082  CB  THR    68       3.651 -14.075  13.235  1.00  0.00
ATOM   1083  HB  THR    68       4.168 -15.016  13.050  1.00  0.00
ATOM   1084  OG1 THR    68       3.499 -13.930  14.661  1.00  0.00
ATOM   1085  HG1 THR    68       3.252 -13.020  14.868  1.00  0.00
ATOM   1086  CG2 THR    68       4.528 -12.927  12.695  1.00  0.00
ATOM   1087 HG21 THR    68       4.726 -13.084  11.641  1.00  0.00
ATOM   1088 HG22 THR    68       5.465 -12.902  13.233  1.00  0.00
ATOM   1089 HG23 THR    68       4.015 -11.981  12.824  1.00  0.00
ATOM   1090  C   THR    68       2.355 -14.164  11.029  1.00  0.00
ATOM   1091  O   THR    68       2.523 -15.218  10.420  1.00  0.00
ATOM   1092  N   ARG    69       2.257 -12.973  10.430  1.00  0.00
ATOM   1093  HN  ARG    69       2.025 -12.200  10.978  1.00  0.00
ATOM   1094  CA  ARG    69       2.482 -12.752   9.001  1.00  0.00
ATOM   1095  HA  ARG    69       3.107 -13.561   8.627  1.00  0.00
ATOM   1096  CB  ARG    69       1.137 -12.746   8.221  1.00  0.00
ATOM   1097  HB1 ARG    69       0.721 -13.750   8.239  1.00  0.00
ATOM   1098  HB2 ARG    69       1.324 -12.469   7.189  1.00  0.00
ATOM   1099  CG  ARG    69       0.092 -11.782   8.808  1.00  0.00
ATOM   1100  HG1 ARG    69       0.529 -10.788   8.858  1.00  0.00
ATOM   1101  HG2 ARG    69      -0.149 -12.105   9.814  1.00  0.00
ATOM   1102  CD  ARG    69      -1.205 -11.704   8.003  1.00  0.00
ATOM   1103  HD1 ARG    69      -1.619 -12.701   7.892  1.00  0.00
ATOM   1104  HD2 ARG    69      -0.986 -11.296   7.020  1.00  0.00
ATOM   1105  NE  ARG    69      -2.195 -10.844   8.682  1.00  0.00
ATOM   1106  HE  ARG    69      -2.097 -10.746   9.658  1.00  0.00
ATOM   1107  CZ  ARG    69      -3.204 -10.199   8.083  1.00  0.00
ATOM   1108  NH1 ARG    69      -3.389 -10.298   6.771  1.00  0.00
ATOM   1109 HH11 ARG    69      -2.775 -10.859   6.216  1.00  0.00
ATOM   1110 HH12 ARG    69      -4.145  -9.809   6.327  1.00  0.00
ATOM   1111  NH2 ARG    69      -4.023  -9.449   8.808  1.00  0.00
ATOM   1112 HH21 ARG    69      -3.895  -9.373   9.800  1.00  0.00
ATOM   1113 HH22 ARG    69      -4.775  -8.947   8.368  1.00  0.00
ATOM   1114  C   ARG    69       3.235 -11.423   8.819  1.00  0.00
ATOM   1115  O   ARG    69       2.846 -10.392   9.386  1.00  0.00
ATOM   1116  N   VAL    70       4.342 -11.464   8.066  1.00  0.00
ATOM   1117  HN  VAL    70       4.627 -12.333   7.703  1.00  0.00
ATOM   1118  CA  VAL    70       5.139 -10.268   7.727  1.00  0.00
ATOM   1119  HA  VAL    70       4.607  -9.388   8.089  1.00  0.00
ATOM   1120  CB  VAL    70       6.573 -10.288   8.399  1.00  0.00
ATOM   1121  HB  VAL    70       7.070  -9.362   8.142  1.00  0.00
ATOM   1122  CG1 VAL    70       6.464 -10.341   9.939  1.00  0.00
ATOM   1123 HG11 VAL    70       5.949 -11.249  10.237  1.00  0.00
ATOM   1124 HG12 VAL    70       5.908  -9.485  10.300  1.00  0.00
ATOM   1125 HG13 VAL    70       7.453 -10.331  10.382  1.00  0.00
ATOM   1126  CG2 VAL    70       7.456 -11.443   7.878  1.00  0.00
ATOM   1127 HG21 VAL    70       7.015 -12.395   8.154  1.00  0.00
ATOM   1128 HG22 VAL    70       8.449 -11.375   8.305  1.00  0.00
ATOM   1129 HG23 VAL    70       7.533 -11.390   6.797  1.00  0.00
ATOM   1130  C   VAL    70       5.254 -10.159   6.205  1.00  0.00
ATOM   1131  O   VAL    70       5.202 -11.171   5.510  1.00  0.00
ATOM   1132  N   ILE    71       5.408  -8.934   5.688  1.00  0.00
ATOM   1133  HN  ILE    71       5.460  -8.167   6.296  1.00  0.00
ATOM   1134  CA  ILE    71       5.504  -8.694   4.237  1.00  0.00
ATOM   1135  HA  ILE    71       5.712  -9.652   3.753  1.00  0.00
ATOM   1136  CB  ILE    71       4.140  -8.162   3.640  1.00  0.00
ATOM   1137  HB  ILE    71       3.419  -8.972   3.729  1.00  0.00
ATOM   1138  CG1 ILE    71       4.286  -7.810   2.124  1.00  0.00
ATOM   1139 HG11 ILE    71       4.695  -8.665   1.597  1.00  0.00
ATOM   1140 HG12 ILE    71       4.961  -6.973   2.010  1.00  0.00
ATOM   1141  CG2 ILE    71       3.573  -6.976   4.453  1.00  0.00
ATOM   1142 HG21 ILE    71       3.444  -7.275   5.485  1.00  0.00
ATOM   1143 HG22 ILE    71       2.614  -6.672   4.050  1.00  0.00
ATOM   1144 HG23 ILE    71       4.260  -6.140   4.406  1.00  0.00
ATOM   1145  CD1 ILE    71       2.987  -7.439   1.443  1.00  0.00
ATOM   1146 HD11 ILE    71       2.543  -6.583   1.935  1.00  0.00
ATOM   1147 HD12 ILE    71       2.301  -8.274   1.484  1.00  0.00
ATOM   1148 HD13 ILE    71       3.185  -7.192   0.410  1.00  0.00
ATOM   1149  C   ILE    71       6.677  -7.743   3.926  1.00  0.00
ATOM   1150  O   ILE    71       6.729  -6.606   4.414  1.00  0.00
ATOM   1151  N   VAL    72       7.647  -8.257   3.143  1.00  0.00
ATOM   1152  HN  VAL    72       7.561  -9.189   2.860  1.00  0.00
ATOM   1153  CA  VAL    72       8.823  -7.508   2.680  1.00  0.00
ATOM   1154  HA  VAL    72       8.838  -6.531   3.166  1.00  0.00
ATOM   1155  CB  VAL    72      10.159  -8.271   3.052  1.00  0.00
ATOM   1156  HB  VAL    72      10.197  -9.188   2.462  1.00  0.00
ATOM   1157  CG1 VAL    72      11.412  -7.431   2.695  1.00  0.00
ATOM   1158 HG11 VAL    72      11.407  -6.504   3.256  1.00  0.00
ATOM   1159 HG12 VAL    72      11.416  -7.203   1.634  1.00  0.00
ATOM   1160 HG13 VAL    72      12.309  -7.988   2.937  1.00  0.00
ATOM   1161  CG2 VAL    72      10.166  -8.680   4.549  1.00  0.00
ATOM   1162 HG21 VAL    72      11.070  -9.230   4.774  1.00  0.00
ATOM   1163 HG22 VAL    72       9.307  -9.308   4.762  1.00  0.00
ATOM   1164 HG23 VAL    72      10.121  -7.794   5.173  1.00  0.00
ATOM   1165  C   VAL    72       8.709  -7.316   1.152  1.00  0.00
ATOM   1166  O   VAL    72       9.061  -8.215   0.377  1.00  0.00
ATOM   1167  N   GLY    73       8.172  -6.154   0.742  1.00  0.00
ATOM   1168  HN  GLY    73       7.902  -5.501   1.421  1.00  0.00
ATOM   1169  CA  GLY    73       7.972  -5.828  -0.676  1.00  0.00
ATOM   1170  HA1 GLY    73       8.932  -5.852  -1.185  1.00  0.00
ATOM   1171  HA2 GLY    73       7.580  -4.822  -0.740  1.00  0.00
ATOM   1172  C   GLY    73       6.996  -6.771  -1.386  1.00  0.00
ATOM   1173  O   GLY    73       5.793  -6.767  -1.097  1.00  0.00
ATOM   1174  N   ASN    74       7.526  -7.594  -2.308  1.00  0.00
ATOM   1175  HN  ASN    74       8.498  -7.567  -2.448  1.00  0.00
ATOM   1176  CA  ASN    74       6.729  -8.548  -3.117  1.00  0.00
ATOM   1177  HA  ASN    74       5.713  -8.166  -3.186  1.00  0.00
ATOM   1178  CB  ASN    74       7.314  -8.665  -4.555  1.00  0.00
ATOM   1179  HB1 ASN    74       7.322  -7.683  -5.010  1.00  0.00
ATOM   1180  HB2 ASN    74       6.675  -9.315  -5.146  1.00  0.00
ATOM   1181  CG  ASN    74       8.750  -9.214  -4.594  1.00  0.00
ATOM   1182  OD1 ASN    74       9.585  -8.891  -3.742  1.00  0.00
ATOM   1183  ND2 ASN    74       9.037 -10.074  -5.557  1.00  0.00
ATOM   1184 HD21 ASN    74       8.325 -10.315  -6.189  1.00  0.00
ATOM   1185 HD22 ASN    74       9.943 -10.438  -5.598  1.00  0.00
ATOM   1186  C   ASN    74       6.680  -9.946  -2.463  1.00  0.00
ATOM   1187  O   ASN    74       6.224 -10.908  -3.082  1.00  0.00
ATOM   1188  N   VAL    75       7.108 -10.034  -1.201  1.00  0.00
ATOM   1189  HN  VAL    75       7.260  -9.199  -0.708  1.00  0.00
ATOM   1190  CA  VAL    75       7.309 -11.315  -0.489  1.00  0.00
ATOM   1191  HA  VAL    75       6.945 -12.129  -1.117  1.00  0.00
ATOM   1192  CB  VAL    75       8.848 -11.555  -0.195  1.00  0.00
ATOM   1193  HB  VAL    75       9.218 -10.684   0.349  1.00  0.00
ATOM   1194  CG1 VAL    75       9.087 -12.801   0.696  1.00  0.00
ATOM   1195 HG11 VAL    75       8.592 -12.672   1.653  1.00  0.00
ATOM   1196 HG12 VAL    75      10.147 -12.937   0.863  1.00  0.00
ATOM   1197 HG13 VAL    75       8.687 -13.683   0.207  1.00  0.00
ATOM   1198  CG2 VAL    75       9.662 -11.661  -1.510  1.00  0.00
ATOM   1199 HG21 VAL    75       9.314 -12.507  -2.091  1.00  0.00
ATOM   1200 HG22 VAL    75      10.714 -11.794  -1.282  1.00  0.00
ATOM   1201 HG23 VAL    75       9.541 -10.755  -2.094  1.00  0.00
ATOM   1202  C   VAL    75       6.515 -11.301   0.828  1.00  0.00
ATOM   1203  O   VAL    75       6.544 -10.301   1.540  1.00  0.00
ATOM   1204  N   VAL    76       5.783 -12.395   1.139  1.00  0.00
ATOM   1205  HN  VAL    76       5.728 -13.126   0.488  1.00  0.00
ATOM   1206  CA  VAL    76       5.064 -12.541   2.428  1.00  0.00
ATOM   1207  HA  VAL    76       5.338 -11.701   3.071  1.00  0.00
ATOM   1208  CB  VAL    76       3.493 -12.528   2.262  1.00  0.00
ATOM   1209  HB  VAL    76       3.200 -13.449   1.754  1.00  0.00
ATOM   1210  CG1 VAL    76       2.783 -12.508   3.646  1.00  0.00
ATOM   1211 HG11 VAL    76       1.711 -12.534   3.510  1.00  0.00
ATOM   1212 HG12 VAL    76       3.049 -11.606   4.184  1.00  0.00
ATOM   1213 HG13 VAL    76       3.086 -13.371   4.232  1.00  0.00
ATOM   1214  CG2 VAL    76       3.019 -11.344   1.389  1.00  0.00
ATOM   1215 HG21 VAL    76       3.486 -11.397   0.411  1.00  0.00
ATOM   1216 HG22 VAL    76       3.288 -10.408   1.859  1.00  0.00
ATOM   1217 HG23 VAL    76       1.945 -11.385   1.269  1.00  0.00
ATOM   1218  C   VAL    76       5.475 -13.854   3.126  1.00  0.00
ATOM   1219  O   VAL    76       5.559 -14.898   2.492  1.00  0.00
ATOM   1220  N   ILE    77       5.734 -13.766   4.433  1.00  0.00
ATOM   1221  HN  ILE    77       5.813 -12.878   4.816  1.00  0.00
ATOM   1222  CA  ILE    77       5.916 -14.910   5.337  1.00  0.00
ATOM   1223  HA  ILE    77       6.176 -15.798   4.765  1.00  0.00
ATOM   1224  CB  ILE    77       7.073 -14.588   6.362  1.00  0.00
ATOM   1225  HB  ILE    77       6.847 -13.610   6.770  1.00  0.00
ATOM   1226  CG1 ILE    77       8.463 -14.486   5.659  1.00  0.00
ATOM   1227 HG11 ILE    77       9.137 -13.928   6.297  1.00  0.00
ATOM   1228 HG12 ILE    77       8.355 -13.959   4.723  1.00  0.00
ATOM   1229  CG2 ILE    77       7.119 -15.560   7.574  1.00  0.00
ATOM   1230 HG21 ILE    77       7.923 -15.265   8.242  1.00  0.00
ATOM   1231 HG22 ILE    77       7.286 -16.571   7.234  1.00  0.00
ATOM   1232 HG23 ILE    77       6.178 -15.513   8.111  1.00  0.00
ATOM   1233  CD1 ILE    77       9.122 -15.813   5.355  1.00  0.00
ATOM   1234 HD11 ILE    77       8.436 -16.442   4.804  1.00  0.00
ATOM   1235 HD12 ILE    77       9.395 -16.301   6.279  1.00  0.00
ATOM   1236 HD13 ILE    77      10.007 -15.641   4.763  1.00  0.00
ATOM   1237  C   ILE    77       4.599 -15.127   6.100  1.00  0.00
ATOM   1238  O   ILE    77       4.265 -14.325   6.974  1.00  0.00
ATOM   1239  N   ASP    78       3.831 -16.161   5.735  1.00  0.00
ATOM   1240  HN  ASP    78       4.024 -16.623   4.895  1.00  0.00
ATOM   1241  CA  ASP    78       2.693 -16.628   6.545  1.00  0.00
ATOM   1242  HA  ASP    78       2.361 -15.800   7.176  1.00  0.00
ATOM   1243  CB  ASP    78       1.495 -17.090   5.663  1.00  0.00
ATOM   1244  HB1 ASP    78       0.808 -17.681   6.263  1.00  0.00
ATOM   1245  HB2 ASP    78       1.871 -17.715   4.859  1.00  0.00
ATOM   1246  CG  ASP    78       0.722 -15.907   5.051  1.00  0.00
ATOM   1247  OD1 ASP    78      -0.279 -15.444   5.664  1.00  0.00
ATOM   1248  OD2 ASP    78       1.123 -15.426   3.972  1.00  0.00
ATOM   1249  C   ASP    78       3.178 -17.755   7.453  1.00  0.00
ATOM   1250  O   ASP    78       3.447 -18.863   6.993  1.00  0.00
ATOM   1251  N   HIS    79       3.324 -17.435   8.743  1.00  0.00
ATOM   1252  HN  HIS    79       3.119 -16.519   9.012  1.00  0.00
ATOM   1253  CA  HIS    79       3.748 -18.381   9.770  1.00  0.00
ATOM   1254  HA  HIS    79       4.225 -19.233   9.284  1.00  0.00
ATOM   1255  CB  HIS    79       4.778 -17.711  10.721  1.00  0.00
ATOM   1256  HB1 HIS    79       4.334 -16.814  11.146  1.00  0.00
ATOM   1257  HB2 HIS    79       5.650 -17.421  10.147  1.00  0.00
ATOM   1258  CG  HIS    79       5.266 -18.576  11.867  1.00  0.00
ATOM   1259  ND1 HIS    79       5.141 -19.954  11.901  1.00  0.00
ATOM   1260  HD1 HIS    79       4.729 -20.508  11.208  1.00  0.00
ATOM   1261  CD2 HIS    79       5.881 -18.238  13.023  1.00  0.00
ATOM   1262  HD2 HIS    79       6.149 -17.237  13.337  1.00  0.00
ATOM   1263  CE1 HIS    79       5.651 -20.417  13.021  1.00  0.00
ATOM   1264  HE1 HIS    79       5.647 -21.450  13.340  1.00  0.00
ATOM   1265  NE2 HIS    79       6.108 -19.397  13.721  1.00  0.00
ATOM   1266  HE2 HIS    79       6.411 -19.446  14.651  1.00  0.00
ATOM   1267  C   HIS    79       2.505 -18.858  10.529  1.00  0.00
ATOM   1268  O   HIS    79       1.921 -18.112  11.330  1.00  0.00
ATOM   1269  N   GLU    80       2.124 -20.108  10.258  1.00  0.00
ATOM   1270  HN  GLU    80       2.686 -20.635   9.644  1.00  0.00
ATOM   1271  CA  GLU    80       0.924 -20.760  10.804  1.00  0.00
ATOM   1272  HA  GLU    80       0.514 -20.115  11.578  1.00  0.00
ATOM   1273  CB  GLU    80      -0.175 -20.959   9.682  1.00  0.00
ATOM   1274  HB1 GLU    80      -0.900 -20.154   9.758  1.00  0.00
ATOM   1275  HB2 GLU    80      -0.700 -21.893   9.862  1.00  0.00
ATOM   1276  CG  GLU    80       0.335 -20.987   8.215  1.00  0.00
ATOM   1277  HG1 GLU    80       0.813 -20.034   8.008  1.00  0.00
ATOM   1278  HG2 GLU    80      -0.520 -21.089   7.549  1.00  0.00
ATOM   1279  CD  GLU    80       1.327 -22.123   7.905  1.00  0.00
ATOM   1280  OE1 GLU    80       0.900 -23.297   7.853  1.00  0.00
ATOM   1281  OE2 GLU    80       2.529 -21.843   7.704  1.00  0.00
ATOM   1282  C   GLU    80       1.303 -22.088  11.480  1.00  0.00
ATOM   1283  O   GLU    80       2.444 -22.541  11.390  1.00  0.00
ATOM   1284  N   THR    81       0.341 -22.666  12.209  1.00  0.00
ATOM   1285  HN  THR    81      -0.501 -22.191  12.319  1.00  0.00
ATOM   1286  CA  THR    81       0.474 -23.983  12.842  1.00  0.00
ATOM   1287  HA  THR    81       1.480 -24.371  12.650  1.00  0.00
ATOM   1288  CB  THR    81       0.261 -23.908  14.389  1.00  0.00
ATOM   1289  HB  THR    81      -0.787 -23.710  14.592  1.00  0.00
ATOM   1290  OG1 THR    81       1.039 -22.837  14.930  1.00  0.00
ATOM   1291  HG1 THR    81       1.976 -23.062  14.888  1.00  0.00
ATOM   1292  CG2 THR    81       0.660 -25.216  15.097  1.00  0.00
ATOM   1293 HG21 THR    81       0.482 -25.123  16.161  1.00  0.00
ATOM   1294 HG22 THR    81       1.711 -25.421  14.928  1.00  0.00
ATOM   1295 HG23 THR    81       0.070 -26.040  14.711  1.00  0.00
ATOM   1296  C   THR    81      -0.563 -24.926  12.218  1.00  0.00
ATOM   1297  O   THR    81      -1.772 -24.750  12.420  1.00  0.00
ATOM   1298  N   VAL    82      -0.083 -25.896  11.437  1.00  0.00
ATOM   1299  HN  VAL    82       0.879 -25.935  11.288  1.00  0.00
ATOM   1300  CA  VAL    82      -0.929 -26.888  10.775  1.00  0.00
ATOM   1301  HA  VAL    82      -1.840 -26.394  10.432  1.00  0.00
ATOM   1302  CB  VAL    82      -0.208 -27.516   9.527  1.00  0.00
ATOM   1303  HB  VAL    82       0.646 -28.088   9.892  1.00  0.00
ATOM   1304  CG1 VAL    82      -1.137 -28.498   8.783  1.00  0.00
ATOM   1305 HG11 VAL    82      -1.435 -29.296   9.457  1.00  0.00
ATOM   1306 HG12 VAL    82      -0.621 -28.927   7.934  1.00  0.00
ATOM   1307 HG13 VAL    82      -2.021 -27.976   8.438  1.00  0.00
ATOM   1308  CG2 VAL    82       0.337 -26.425   8.585  1.00  0.00
ATOM   1309 HG21 VAL    82       0.824 -26.885   7.735  1.00  0.00
ATOM   1310 HG22 VAL    82       1.059 -25.812   9.117  1.00  0.00
ATOM   1311 HG23 VAL    82      -0.475 -25.799   8.238  1.00  0.00
ATOM   1312  C   VAL    82      -1.296 -28.010  11.758  1.00  0.00
ATOM   1313  O   VAL    82      -0.461 -28.864  12.069  1.00  0.00
ATOM   1314  N   THR    83      -2.536 -27.975  12.262  1.00  0.00
ATOM   1315  HN  THR    83      -3.078 -27.181  12.119  1.00  0.00
ATOM   1316  CA  THR    83      -3.105 -29.082  13.035  1.00  0.00
ATOM   1317  HA  THR    83      -2.412 -29.323  13.839  1.00  0.00
ATOM   1318  CB  THR    83      -4.481 -28.685  13.668  1.00  0.00
ATOM   1319  HB  THR    83      -5.160 -28.404  12.867  1.00  0.00
ATOM   1320  OG1 THR    83      -4.309 -27.544  14.529  1.00  0.00
ATOM   1321  HG1 THR    83      -3.679 -26.932  14.133  1.00  0.00
ATOM   1322  CG2 THR    83      -5.123 -29.845  14.468  1.00  0.00
ATOM   1323 HG21 THR    83      -4.452 -30.164  15.257  1.00  0.00
ATOM   1324 HG22 THR    83      -5.319 -30.683  13.809  1.00  0.00
ATOM   1325 HG23 THR    83      -6.058 -29.516  14.906  1.00  0.00
ATOM   1326  C   THR    83      -3.273 -30.305  12.114  1.00  0.00
ATOM   1327  O   THR    83      -3.958 -30.228  11.087  1.00  0.00
ATOM   1328  N   ARG    84      -2.578 -31.394  12.467  1.00  0.00
ATOM   1329  HN  ARG    84      -1.972 -31.324  13.232  1.00  0.00
ATOM   1330  CA  ARG    84      -2.657 -32.694  11.781  1.00  0.00
ATOM   1331  HA  ARG    84      -3.432 -32.655  11.018  1.00  0.00
ATOM   1332  CB  ARG    84      -1.281 -33.031  11.121  1.00  0.00
ATOM   1333  HB1 ARG    84      -1.383 -33.960  10.565  1.00  0.00
ATOM   1334  HB2 ARG    84      -0.548 -33.183  11.909  1.00  0.00
ATOM   1335  CG  ARG    84      -0.732 -31.946  10.157  1.00  0.00
ATOM   1336  HG1 ARG    84      -0.660 -31.004  10.698  1.00  0.00
ATOM   1337  HG2 ARG    84      -1.423 -31.826   9.334  1.00  0.00
ATOM   1338  CD  ARG    84       0.658 -32.295   9.587  1.00  0.00
ATOM   1339  HD1 ARG    84       0.579 -33.224   9.033  1.00  0.00
ATOM   1340  HD2 ARG    84       1.346 -32.434  10.413  1.00  0.00
ATOM   1341  NE  ARG    84       1.205 -31.246   8.692  1.00  0.00
ATOM   1342  HE  ARG    84       0.848 -30.336   8.810  1.00  0.00
ATOM   1343  CZ  ARG    84       2.180 -31.435   7.775  1.00  0.00
ATOM   1344  NH1 ARG    84       2.668 -32.650   7.536  1.00  0.00
ATOM   1345 HH11 ARG    84       2.318 -33.441   8.044  1.00  0.00
ATOM   1346 HH12 ARG    84       3.395 -32.782   6.857  1.00  0.00
ATOM   1347  NH2 ARG    84       2.654 -30.397   7.089  1.00  0.00
ATOM   1348 HH21 ARG    84       2.292 -29.477   7.252  1.00  0.00
ATOM   1349 HH22 ARG    84       3.387 -30.528   6.414  1.00  0.00
ATOM   1350  C   ARG    84      -3.039 -33.762  12.825  1.00  0.00
ATOM   1351  O   ARG    84      -3.453 -33.417  13.938  1.00  0.00
ATOM   1352  N   ASN    85      -2.949 -35.050  12.453  1.00  0.00
ATOM   1353  HN  ASN    85      -2.807 -35.252  11.503  1.00  0.00
ATOM   1354  CA  ASN    85      -3.068 -36.183  13.401  1.00  0.00
ATOM   1355  HA  ASN    85      -3.227 -35.777  14.401  1.00  0.00
ATOM   1356  CB  ASN    85      -4.278 -37.105  13.042  1.00  0.00
ATOM   1357  HB1 ASN    85      -4.060 -38.119  13.370  1.00  0.00
ATOM   1358  HB2 ASN    85      -4.403 -37.118  11.968  1.00  0.00
ATOM   1359  CG  ASN    85      -5.617 -36.685  13.664  1.00  0.00
ATOM   1360  OD1 ASN    85      -6.453 -37.533  13.983  1.00  0.00
ATOM   1361  ND2 ASN    85      -5.859 -35.394  13.817  1.00  0.00
ATOM   1362 HD21 ASN    85      -5.182 -34.752  13.529  1.00  0.00
ATOM   1363 HD22 ASN    85      -6.711 -35.132  14.223  1.00  0.00
ATOM   1364  C   ASN    85      -1.755 -36.982  13.410  1.00  0.00
ATOM   1365  O   ASN    85      -1.404 -37.632  12.418  1.00  0.00
ATOM   1366  N   PHE    86      -1.007 -36.881  14.523  1.00  0.00
ATOM   1367  HN  PHE    86      -1.294 -36.250  15.215  1.00  0.00
ATOM   1368  CA  PHE    86       0.217 -37.682  14.766  1.00  0.00
ATOM   1369  HA  PHE    86       0.519 -38.136  13.820  1.00  0.00
ATOM   1370  CB  PHE    86       1.375 -36.779  15.290  1.00  0.00
ATOM   1371  HB1 PHE    86       2.135 -37.406  15.746  1.00  0.00
ATOM   1372  HB2 PHE    86       0.983 -36.113  16.047  1.00  0.00
ATOM   1373  CG  PHE    86       2.077 -35.904  14.242  1.00  0.00
ATOM   1374  CD1 PHE    86       3.156 -35.097  14.611  1.00  0.00
ATOM   1375  HD1 PHE    86       3.492 -35.097  15.642  1.00  0.00
ATOM   1376  CD2 PHE    86       1.674 -35.879  12.903  1.00  0.00
ATOM   1377  HD2 PHE    86       0.841 -36.492  12.584  1.00  0.00
ATOM   1378  CE1 PHE    86       3.798 -34.301  13.681  1.00  0.00
ATOM   1379  HE1 PHE    86       4.630 -33.680  13.983  1.00  0.00
ATOM   1380  CE2 PHE    86       2.321 -35.081  11.980  1.00  0.00
ATOM   1381  HE2 PHE    86       1.997 -35.076  10.951  1.00  0.00
ATOM   1382  CZ  PHE    86       3.381 -34.297  12.368  1.00  0.00
ATOM   1383  HZ  PHE    86       3.888 -33.670  11.641  1.00  0.00
ATOM   1384  C   PHE    86      -0.083 -38.813  15.772  1.00  0.00
ATOM   1385  O   PHE    86      -0.908 -38.631  16.671  1.00  0.00
ATOM   1386  N   PRO    87       0.586 -40.007  15.644  1.00  0.00
ATOM   1387  CA  PRO    87       0.304 -41.188  16.506  1.00  0.00
ATOM   1388  HA  PRO    87      -0.753 -41.430  16.487  1.00  0.00
ATOM   1389  CB  PRO    87       1.090 -42.324  15.810  1.00  0.00
ATOM   1390  HB1 PRO    87       0.450 -42.828  15.088  1.00  0.00
ATOM   1391  HB2 PRO    87       1.439 -43.050  16.538  1.00  0.00
ATOM   1392  CG  PRO    87       2.225 -41.625  15.135  1.00  0.00
ATOM   1393  HG1 PRO    87       2.594 -42.216  14.303  1.00  0.00
ATOM   1394  HG2 PRO    87       3.031 -41.449  15.847  1.00  0.00
ATOM   1395  CD  PRO    87       1.650 -40.316  14.643  1.00  0.00
ATOM   1396  HD1 PRO    87       1.221 -40.430  13.654  1.00  0.00
ATOM   1397  HD2 PRO    87       2.411 -39.543  14.634  1.00  0.00
ATOM   1398  C   PRO    87       0.735 -41.013  17.986  1.00  0.00
ATOM   1399  O   PRO    87       0.406 -41.861  18.826  1.00  0.00
ATOM   1400  N   GLU    88       1.487 -39.932  18.296  1.00  0.00
ATOM   1401  HN  GLU    88       1.811 -39.361  17.568  1.00  0.00
ATOM   1402  CA  GLU    88       1.846 -39.587  19.694  1.00  0.00
ATOM   1403  HA  GLU    88       1.801 -40.508  20.274  1.00  0.00
ATOM   1404  CB  GLU    88       3.298 -39.019  19.810  1.00  0.00
ATOM   1405  HB1 GLU    88       3.992 -39.824  19.590  1.00  0.00
ATOM   1406  HB2 GLU    88       3.468 -38.713  20.839  1.00  0.00
ATOM   1407  CG  GLU    88       3.637 -37.816  18.889  1.00  0.00
ATOM   1408  HG1 GLU    88       4.235 -37.099  19.455  1.00  0.00
ATOM   1409  HG2 GLU    88       2.711 -37.325  18.599  1.00  0.00
ATOM   1410  CD  GLU    88       4.401 -38.201  17.607  1.00  0.00
ATOM   1411  OE1 GLU    88       3.776 -38.731  16.671  1.00  0.00
ATOM   1412  OE2 GLU    88       5.635 -37.981  17.541  1.00  0.00
ATOM   1413  C   GLU    88       0.823 -38.610  20.322  1.00  0.00
ATOM   1414  O   GLU    88       0.815 -38.439  21.545  1.00  0.00
ATOM   1415  N   GLY    89      -0.036 -37.962  19.498  1.00  0.00
ATOM   1416  HN  GLY    89       0.070 -38.056  18.526  1.00  0.00
ATOM   1417  CA  GLY    89      -1.120 -37.115  20.036  1.00  0.00
ATOM   1418  HA1 GLY    89      -0.733 -36.528  20.864  1.00  0.00
ATOM   1419  HA2 GLY    89      -1.902 -37.760  20.417  1.00  0.00
ATOM   1420  C   GLY    89      -1.738 -36.173  19.008  1.00  0.00
ATOM   1421  O   GLY    89      -2.265 -36.634  17.995  1.00  0.00
ATOM   1422  N   LYS    90      -1.688 -34.849  19.296  1.00  0.00
ATOM   1423  HN  LYS    90      -1.292 -34.580  20.148  1.00  0.00
ATOM   1424  CA  LYS    90      -2.228 -33.784  18.429  1.00  0.00
ATOM   1425  HA  LYS    90      -3.308 -33.929  18.384  1.00  0.00
ATOM   1426  CB  LYS    90      -1.953 -32.399  19.091  1.00  0.00
ATOM   1427  HB1 LYS    90      -0.889 -32.329  19.303  1.00  0.00
ATOM   1428  HB2 LYS    90      -2.482 -32.361  20.036  1.00  0.00
ATOM   1429  CG  LYS    90      -2.358 -31.147  18.270  1.00  0.00
ATOM   1430  HG1 LYS    90      -1.761 -31.127  17.361  1.00  0.00
ATOM   1431  HG2 LYS    90      -2.120 -30.263  18.854  1.00  0.00
ATOM   1432  CD  LYS    90      -3.857 -31.081  17.883  1.00  0.00
ATOM   1433  HD1 LYS    90      -4.078 -31.901  17.205  1.00  0.00
ATOM   1434  HD2 LYS    90      -4.036 -30.146  17.364  1.00  0.00
ATOM   1435  CE  LYS    90      -4.812 -31.157  19.088  1.00  0.00
ATOM   1436  HE1 LYS    90      -4.460 -30.494  19.864  1.00  0.00
ATOM   1437  HE2 LYS    90      -4.825 -32.172  19.468  1.00  0.00
ATOM   1438  NZ  LYS    90      -6.199 -30.777  18.717  1.00  0.00
ATOM   1439  HZ1 LYS    90      -6.576 -31.434  18.006  1.00  0.00
ATOM   1440  HZ2 LYS    90      -6.210 -29.813  18.321  1.00  0.00
ATOM   1441  HZ3 LYS    90      -6.816 -30.796  19.553  1.00  0.00
ATOM   1442  C   LYS    90      -1.669 -33.871  16.986  1.00  0.00
ATOM   1443  O   LYS    90      -2.296 -34.497  16.132  1.00  0.00
ATOM   1444  N   GLY    91      -0.478 -33.289  16.736  1.00  0.00
ATOM   1445  HN  GLY    91       0.003 -32.854  17.467  1.00  0.00
ATOM   1446  CA  GLY    91       0.113 -33.291  15.396  1.00  0.00
ATOM   1447  HA1 GLY    91      -0.475 -33.914  14.730  1.00  0.00
ATOM   1448  HA2 GLY    91       1.103 -33.721  15.472  1.00  0.00
ATOM   1449  C   GLY    91       0.249 -31.907  14.791  1.00  0.00
ATOM   1450  O   GLY    91       0.259 -31.760  13.567  1.00  0.00
ATOM   1451  N   GLU    92       0.402 -30.891  15.643  1.00  0.00
ATOM   1452  HN  GLU    92       0.538 -31.090  16.594  1.00  0.00
ATOM   1453  CA  GLU    92       0.411 -29.488  15.201  1.00  0.00
ATOM   1454  HA  GLU    92      -0.198 -29.405  14.301  1.00  0.00
ATOM   1455  CB  GLU    92      -0.210 -28.587  16.309  1.00  0.00
ATOM   1456  HB1 GLU    92      -1.247 -28.882  16.459  1.00  0.00
ATOM   1457  HB2 GLU    92      -0.200 -27.559  15.966  1.00  0.00
ATOM   1458  CG  GLU    92       0.511 -28.654  17.679  1.00  0.00
ATOM   1459  HG1 GLU    92       1.559 -28.392  17.534  1.00  0.00
ATOM   1460  HG2 GLU    92       0.465 -29.680  18.035  1.00  0.00
ATOM   1461  CD  GLU    92      -0.076 -27.730  18.754  1.00  0.00
ATOM   1462  OE1 GLU    92      -0.596 -28.231  19.775  1.00  0.00
ATOM   1463  OE2 GLU    92       0.010 -26.494  18.591  1.00  0.00
ATOM   1464  C   GLU    92       1.855 -29.069  14.862  1.00  0.00
ATOM   1465  O   GLU    92       2.758 -29.163  15.701  1.00  0.00
ATOM   1466  N   VAL    93       2.091 -28.670  13.592  1.00  0.00
ATOM   1467  HN  VAL    93       1.333 -28.599  12.963  1.00  0.00
ATOM   1468  CA  VAL    93       3.437 -28.330  13.109  1.00  0.00
ATOM   1469  HA  VAL    93       4.136 -28.473  13.938  1.00  0.00
ATOM   1470  CB  VAL    93       3.893 -29.287  11.940  1.00  0.00
ATOM   1471  HB  VAL    93       4.913 -29.019  11.665  1.00  0.00
ATOM   1472  CG1 VAL    93       3.922 -30.751  12.432  1.00  0.00
ATOM   1473 HG11 VAL    93       2.920 -31.068  12.705  1.00  0.00
ATOM   1474 HG12 VAL    93       4.560 -30.833  13.302  1.00  0.00
ATOM   1475 HG13 VAL    93       4.300 -31.398  11.653  1.00  0.00
ATOM   1476  CG2 VAL    93       3.006 -29.154  10.680  1.00  0.00
ATOM   1477 HG21 VAL    93       1.980 -29.407  10.925  1.00  0.00
ATOM   1478 HG22 VAL    93       3.360 -29.821   9.903  1.00  0.00
ATOM   1479 HG23 VAL    93       3.042 -28.135  10.314  1.00  0.00
ATOM   1480  C   VAL    93       3.493 -26.853  12.707  1.00  0.00
ATOM   1481  O   VAL    93       2.693 -26.383  11.896  1.00  0.00
ATOM   1482  N   ASP    94       4.421 -26.119  13.325  1.00  0.00
ATOM   1483  HN  ASP    94       5.019 -26.570  13.963  1.00  0.00
ATOM   1484  CA  ASP    94       4.590 -24.676  13.099  1.00  0.00
ATOM   1485  HA  ASP    94       3.610 -24.233  12.925  1.00  0.00
ATOM   1486  CB  ASP    94       5.220 -24.007  14.345  1.00  0.00
ATOM   1487  HB1 ASP    94       5.388 -22.954  14.128  1.00  0.00
ATOM   1488  HB2 ASP    94       6.183 -24.469  14.550  1.00  0.00
ATOM   1489  CG  ASP    94       4.342 -24.122  15.607  1.00  0.00
ATOM   1490  OD1 ASP    94       4.199 -25.244  16.141  1.00  0.00
ATOM   1491  OD2 ASP    94       3.815 -23.093  16.083  1.00  0.00
ATOM   1492  C   ASP    94       5.467 -24.462  11.857  1.00  0.00
ATOM   1493  O   ASP    94       6.667 -24.705  11.899  1.00  0.00
ATOM   1494  N   VAL    95       4.844 -24.006  10.764  1.00  0.00
ATOM   1495  HN  VAL    95       3.900 -23.767  10.842  1.00  0.00
ATOM   1496  CA  VAL    95       5.474 -23.850   9.440  1.00  0.00
ATOM   1497  HA  VAL    95       6.475 -24.278   9.461  1.00  0.00
ATOM   1498  CB  VAL    95       4.616 -24.600   8.339  1.00  0.00
ATOM   1499  HB  VAL    95       3.704 -24.046   8.214  1.00  0.00
ATOM   1500  CG1 VAL    95       5.309 -24.625   6.956  1.00  0.00
ATOM   1501 HG11 VAL    95       5.489 -23.609   6.618  1.00  0.00
ATOM   1502 HG12 VAL    95       4.680 -25.130   6.235  1.00  0.00
ATOM   1503 HG13 VAL    95       6.254 -25.146   7.033  1.00  0.00
ATOM   1504  CG2 VAL    95       4.215 -26.020   8.799  1.00  0.00
ATOM   1505 HG21 VAL    95       3.629 -25.959   9.713  1.00  0.00
ATOM   1506 HG22 VAL    95       5.102 -26.609   8.986  1.00  0.00
ATOM   1507 HG23 VAL    95       3.621 -26.503   8.031  1.00  0.00
ATOM   1508  C   VAL    95       5.557 -22.353   9.085  1.00  0.00
ATOM   1509  O   VAL    95       4.736 -21.559   9.544  1.00  0.00
ATOM   1510  N   ALA    96       6.583 -21.973   8.314  1.00  0.00
ATOM   1511  HN  ALA    96       7.309 -22.602   8.168  1.00  0.00
ATOM   1512  CA  ALA    96       6.671 -20.654   7.672  1.00  0.00
ATOM   1513  HA  ALA    96       5.835 -20.037   8.010  1.00  0.00
ATOM   1514  CB  ALA    96       7.980 -19.942   8.058  1.00  0.00
ATOM   1515  HB1 ALA    96       8.015 -19.803   9.132  1.00  0.00
ATOM   1516  HB2 ALA    96       8.025 -18.974   7.577  1.00  0.00
ATOM   1517  HB3 ALA    96       8.833 -20.535   7.748  1.00  0.00
ATOM   1518  C   ALA    96       6.565 -20.844   6.153  1.00  0.00
ATOM   1519  O   ALA    96       7.519 -21.300   5.508  1.00  0.00
ATOM   1520  N   CYS    97       5.387 -20.537   5.597  1.00  0.00
ATOM   1521  HN  CYS    97       4.653 -20.258   6.180  1.00  0.00
ATOM   1522  CA  CYS    97       5.136 -20.600   4.158  1.00  0.00
ATOM   1523  HA  CYS    97       5.833 -21.314   3.713  1.00  0.00
ATOM   1524  CB  CYS    97       3.695 -21.078   3.890  1.00  0.00
ATOM   1525  HB1 CYS    97       3.517 -21.101   2.822  1.00  0.00
ATOM   1526  HB2 CYS    97       2.997 -20.395   4.352  1.00  0.00
ATOM   1527  SG  CYS    97       3.345 -22.732   4.533  1.00  0.00
ATOM   1528  HG  CYS    97       2.775 -22.594   5.722  1.00  0.00
ATOM   1529  C   CYS    97       5.387 -19.209   3.562  1.00  0.00
ATOM   1530  O   CYS    97       4.641 -18.262   3.822  1.00  0.00
ATOM   1531  N   ILE    98       6.480 -19.101   2.804  1.00  0.00
ATOM   1532  HN  ILE    98       7.002 -19.913   2.642  1.00  0.00
ATOM   1533  CA  ILE    98       6.934 -17.849   2.180  1.00  0.00
ATOM   1534  HA  ILE    98       6.455 -17.017   2.702  1.00  0.00
ATOM   1535  CB  ILE    98       8.501 -17.678   2.336  1.00  0.00
ATOM   1536  HB  ILE    98       8.687 -17.488   3.387  1.00  0.00
ATOM   1537  CG1 ILE    98       9.025 -16.440   1.527  1.00  0.00
ATOM   1538 HG11 ILE    98       8.550 -15.545   1.910  1.00  0.00
ATOM   1539 HG12 ILE    98       8.756 -16.554   0.485  1.00  0.00
ATOM   1540  CG2 ILE    98       9.270 -18.977   1.998  1.00  0.00
ATOM   1541 HG21 ILE    98      10.334 -18.829   2.137  1.00  0.00
ATOM   1542 HG22 ILE    98       9.081 -19.261   0.972  1.00  0.00
ATOM   1543 HG23 ILE    98       8.935 -19.778   2.650  1.00  0.00
ATOM   1544  CD1 ILE    98      10.530 -16.210   1.574  1.00  0.00
ATOM   1545 HD11 ILE    98      11.047 -17.061   1.148  1.00  0.00
ATOM   1546 HD12 ILE    98      10.849 -16.068   2.596  1.00  0.00
ATOM   1547 HD13 ILE    98      10.770 -15.325   1.000  1.00  0.00
ATOM   1548  C   ILE    98       6.500 -17.817   0.702  1.00  0.00
ATOM   1549  O   ILE    98       6.639 -18.801  -0.012  1.00  0.00
ATOM   1550  N   TYR    99       5.959 -16.675   0.255  1.00  0.00
ATOM   1551  HN  TYR    99       5.921 -15.917   0.861  1.00  0.00
ATOM   1552  CA  TYR    99       5.429 -16.498  -1.110  1.00  0.00
ATOM   1553  HA  TYR    99       5.624 -17.406  -1.680  1.00  0.00
ATOM   1554  CB  TYR    99       3.895 -16.233  -1.087  1.00  0.00
ATOM   1555  HB1 TYR    99       3.512 -16.290  -2.104  1.00  0.00
ATOM   1556  HB2 TYR    99       3.708 -15.233  -0.706  1.00  0.00
ATOM   1557  CG  TYR    99       3.089 -17.221  -0.227  1.00  0.00
ATOM   1558  CD1 TYR    99       2.606 -18.425  -0.749  1.00  0.00
ATOM   1559  HD1 TYR    99       2.793 -18.660  -1.787  1.00  0.00
ATOM   1560  CD2 TYR    99       2.826 -16.947   1.118  1.00  0.00
ATOM   1561  HD2 TYR    99       3.189 -16.020   1.550  1.00  0.00
ATOM   1562  CE1 TYR    99       1.893 -19.310   0.036  1.00  0.00
ATOM   1563  HE1 TYR    99       1.530 -20.238  -0.389  1.00  0.00
ATOM   1564  CE2 TYR    99       2.112 -17.830   1.902  1.00  0.00
ATOM   1565  HE2 TYR    99       1.922 -17.591   2.943  1.00  0.00
ATOM   1566  CZ  TYR    99       1.647 -19.007   1.361  1.00  0.00
ATOM   1567  OH  TYR    99       0.941 -19.891   2.150  1.00  0.00
ATOM   1568  HH  TYR    99       0.481 -19.401   2.843  1.00  0.00
ATOM   1569  C   TYR    99       6.133 -15.323  -1.793  1.00  0.00
ATOM   1570  O   TYR    99       6.636 -14.416  -1.131  1.00  0.00
ATOM   1571  N   GLU   100       6.140 -15.362  -3.120  1.00  0.00
ATOM   1572  HN  GLU   100       5.799 -16.168  -3.552  1.00  0.00
ATOM   1573  CA  GLU   100       6.635 -14.292  -3.986  1.00  0.00
ATOM   1574  HA  GLU   100       6.837 -13.403  -3.389  1.00  0.00
ATOM   1575  CB  GLU   100       7.924 -14.756  -4.689  1.00  0.00
ATOM   1576  HB1 GLU   100       7.710 -15.675  -5.228  1.00  0.00
ATOM   1577  HB2 GLU   100       8.666 -14.976  -3.929  1.00  0.00
ATOM   1578  CG  GLU   100       8.539 -13.747  -5.672  1.00  0.00
ATOM   1579  HG1 GLU   100       9.022 -12.957  -5.104  1.00  0.00
ATOM   1580  HG2 GLU   100       7.746 -13.305  -6.273  1.00  0.00
ATOM   1581  CD  GLU   100       9.573 -14.401  -6.605  1.00  0.00
ATOM   1582  OE1 GLU   100      10.791 -14.386  -6.294  1.00  0.00
ATOM   1583  OE2 GLU   100       9.166 -14.934  -7.661  1.00  0.00
ATOM   1584  C   GLU   100       5.548 -13.992  -5.020  1.00  0.00
ATOM   1585  O   GLU   100       5.161 -14.879  -5.779  1.00  0.00
ATOM   1586  N   VAL   101       5.052 -12.755  -5.023  1.00  0.00
ATOM   1587  HN  VAL   101       5.439 -12.110  -4.407  1.00  0.00
ATOM   1588  CA  VAL   101       3.972 -12.303  -5.902  1.00  0.00
ATOM   1589  HA  VAL   101       3.516 -13.172  -6.376  1.00  0.00
ATOM   1590  CB  VAL   101       2.862 -11.562  -5.069  1.00  0.00
ATOM   1591  HB  VAL   101       3.329 -10.703  -4.590  1.00  0.00
ATOM   1592  CG1 VAL   101       1.715 -11.036  -5.970  1.00  0.00
ATOM   1593 HG11 VAL   101       1.243 -11.864  -6.486  1.00  0.00
ATOM   1594 HG12 VAL   101       2.108 -10.340  -6.704  1.00  0.00
ATOM   1595 HG13 VAL   101       0.975 -10.526  -5.364  1.00  0.00
ATOM   1596  CG2 VAL   101       2.309 -12.478  -3.948  1.00  0.00
ATOM   1597 HG21 VAL   101       1.829 -13.343  -4.391  1.00  0.00
ATOM   1598 HG22 VAL   101       1.583 -11.934  -3.354  1.00  0.00
ATOM   1599 HG23 VAL   101       3.117 -12.808  -3.305  1.00  0.00
ATOM   1600  C   VAL   101       4.542 -11.376  -6.989  1.00  0.00
ATOM   1601  O   VAL   101       5.094 -10.313  -6.680  1.00  0.00
ATOM   1602  N   GLU   102       4.414 -11.797  -8.255  1.00  0.00
ATOM   1603  HN  GLU   102       4.015 -12.676  -8.413  1.00  0.00
ATOM   1604  CA  GLU   102       4.833 -11.014  -9.426  1.00  0.00
ATOM   1605  HA  GLU   102       5.103 -10.015  -9.088  1.00  0.00
ATOM   1606  CB  GLU   102       6.062 -11.670 -10.097  1.00  0.00
ATOM   1607  HB1 GLU   102       5.778 -12.660 -10.438  1.00  0.00
ATOM   1608  HB2 GLU   102       6.847 -11.774  -9.356  1.00  0.00
ATOM   1609  CG  GLU   102       6.631 -10.893 -11.295  1.00  0.00
ATOM   1610  HG1 GLU   102       6.831  -9.871 -10.984  1.00  0.00
ATOM   1611  HG2 GLU   102       5.880 -10.874 -12.075  1.00  0.00
ATOM   1612  CD  GLU   102       7.921 -11.503 -11.871  1.00  0.00
ATOM   1613  OE1 GLU   102       7.840 -12.466 -12.663  1.00  0.00
ATOM   1614  OE2 GLU   102       9.026 -11.036 -11.517  1.00  0.00
ATOM   1615  C   GLU   102       3.654 -10.904 -10.411  1.00  0.00
ATOM   1616  O   GLU   102       2.986 -11.901 -10.698  1.00  0.00
ATOM   1617  N   ASN   103       3.415  -9.671 -10.900  1.00  0.00
ATOM   1618  HN  ASN   103       4.039  -8.959 -10.649  1.00  0.00
ATOM   1619  CA  ASN   103       2.282  -9.312 -11.789  1.00  0.00
ATOM   1620  HA  ASN   103       2.366  -8.247 -11.968  1.00  0.00
ATOM   1621  CB  ASN   103       2.369 -10.049 -13.169  1.00  0.00
ATOM   1622  HB1 ASN   103       1.503  -9.781 -13.766  1.00  0.00
ATOM   1623  HB2 ASN   103       2.346 -11.118 -12.998  1.00  0.00
ATOM   1624  CG  ASN   103       3.638  -9.702 -13.971  1.00  0.00
ATOM   1625  OD1 ASN   103       3.676  -8.714 -14.704  1.00  0.00
ATOM   1626  ND2 ASN   103       4.669 -10.528 -13.866  1.00  0.00
ATOM   1627 HD21 ASN   103       4.576 -11.319 -13.290  1.00  0.00
ATOM   1628 HD22 ASN   103       5.485 -10.318 -14.365  1.00  0.00
ATOM   1629  C   ASN   103       0.907  -9.560 -11.102  1.00  0.00
ATOM   1630  O   ASN   103      -0.110  -9.771 -11.776  1.00  0.00
ATOM   1631  N   GLY   104       0.884  -9.459  -9.754  1.00  0.00
ATOM   1632  HN  GLY   104       1.727  -9.269  -9.290  1.00  0.00
ATOM   1633  CA  GLY   104      -0.350  -9.611  -8.961  1.00  0.00
ATOM   1634  HA1 GLY   104      -1.184  -9.203  -9.520  1.00  0.00
ATOM   1635  HA2 GLY   104      -0.237  -9.035  -8.053  1.00  0.00
ATOM   1636  C   GLY   104      -0.682 -11.057  -8.573  1.00  0.00
ATOM   1637  O   GLY   104      -1.597 -11.294  -7.775  1.00  0.00
ATOM   1638  N   ARG   105       0.078 -12.022  -9.117  1.00  0.00
ATOM   1639  HN  ARG   105       0.847 -11.758  -9.666  1.00  0.00
ATOM   1640  CA  ARG   105      -0.132 -13.466  -8.876  1.00  0.00
ATOM   1641  HA  ARG   105      -0.949 -13.597  -8.168  1.00  0.00
ATOM   1642  CB  ARG   105      -0.469 -14.204 -10.201  1.00  0.00
ATOM   1643  HB1 ARG   105      -0.617 -15.260  -9.986  1.00  0.00
ATOM   1644  HB2 ARG   105       0.373 -14.106 -10.876  1.00  0.00
ATOM   1645  CG  ARG   105      -1.723 -13.684 -10.940  1.00  0.00
ATOM   1646  HG1 ARG   105      -1.778 -14.170 -11.911  1.00  0.00
ATOM   1647  HG2 ARG   105      -1.617 -12.616 -11.093  1.00  0.00
ATOM   1648  CD  ARG   105      -3.043 -13.942 -10.190  1.00  0.00
ATOM   1649  HD1 ARG   105      -2.951 -13.596  -9.168  1.00  0.00
ATOM   1650  HD2 ARG   105      -3.248 -15.009 -10.193  1.00  0.00
ATOM   1651  NE  ARG   105      -4.156 -13.215 -10.838  1.00  0.00
ATOM   1652  HE  ARG   105      -3.928 -12.348 -11.233  1.00  0.00
ATOM   1653  CZ  ARG   105      -5.432 -13.615 -10.931  1.00  0.00
ATOM   1654  NH1 ARG   105      -5.830 -14.779 -10.457  1.00  0.00
ATOM   1655 HH11 ARG   105      -5.176 -15.394 -10.017  1.00  0.00
ATOM   1656 HH12 ARG   105      -6.792 -15.061 -10.546  1.00  0.00
ATOM   1657  NH2 ARG   105      -6.311 -12.827 -11.526  1.00  0.00
ATOM   1658 HH21 ARG   105      -6.021 -11.944 -11.902  1.00  0.00
ATOM   1659 HH22 ARG   105      -7.269 -13.112 -11.617  1.00  0.00
ATOM   1660  C   ARG   105       1.146 -14.039  -8.272  1.00  0.00
ATOM   1661  O   ARG   105       2.232 -13.543  -8.565  1.00  0.00
ATOM   1662  N   ILE   106       1.022 -15.070  -7.430  1.00  0.00
ATOM   1663  HN  ILE   106       0.127 -15.399  -7.216  1.00  0.00
ATOM   1664  CA  ILE   106       2.186 -15.718  -6.820  1.00  0.00
ATOM   1665  HA  ILE   106       2.800 -14.933  -6.371  1.00  0.00
ATOM   1666  CB  ILE   106       1.775 -16.720  -5.683  1.00  0.00
ATOM   1667  HB  ILE   106       1.107 -17.458  -6.117  1.00  0.00
ATOM   1668  CG1 ILE   106       1.012 -15.962  -4.557  1.00  0.00
ATOM   1669 HG11 ILE   106       0.097 -15.544  -4.965  1.00  0.00
ATOM   1670 HG12 ILE   106       1.631 -15.156  -4.189  1.00  0.00
ATOM   1671  CG2 ILE   106       3.001 -17.477  -5.105  1.00  0.00
ATOM   1672 HG21 ILE   106       3.696 -16.769  -4.671  1.00  0.00
ATOM   1673 HG22 ILE   106       3.498 -18.025  -5.896  1.00  0.00
ATOM   1674 HG23 ILE   106       2.677 -18.174  -4.342  1.00  0.00
ATOM   1675  CD1 ILE   106       0.637 -16.813  -3.369  1.00  0.00
ATOM   1676 HD11 ILE   106       0.046 -17.658  -3.701  1.00  0.00
ATOM   1677 HD12 ILE   106       0.058 -16.222  -2.674  1.00  0.00
ATOM   1678 HD13 ILE   106       1.531 -17.170  -2.877  1.00  0.00
ATOM   1679  C   ILE   106       3.015 -16.423  -7.904  1.00  0.00
ATOM   1680  O   ILE   106       2.582 -17.414  -8.479  1.00  0.00
ATOM   1681  N   ALA   107       4.199 -15.862  -8.177  1.00  0.00
ATOM   1682  HN  ALA   107       4.455 -15.062  -7.676  1.00  0.00
ATOM   1683  CA  ALA   107       5.130 -16.371  -9.187  1.00  0.00
ATOM   1684  HA  ALA   107       4.568 -16.617 -10.084  1.00  0.00
ATOM   1685  CB  ALA   107       6.154 -15.279  -9.543  1.00  0.00
ATOM   1686  HB1 ALA   107       5.640 -14.397  -9.917  1.00  0.00
ATOM   1687  HB2 ALA   107       6.832 -15.640 -10.305  1.00  0.00
ATOM   1688  HB3 ALA   107       6.723 -15.006  -8.660  1.00  0.00
ATOM   1689  C   ALA   107       5.851 -17.624  -8.674  1.00  0.00
ATOM   1690  O   ALA   107       6.074 -18.580  -9.430  1.00  0.00
ATOM   1691  N   LYS   108       6.194 -17.607  -7.375  1.00  0.00
ATOM   1692  HN  LYS   108       5.915 -16.832  -6.831  1.00  0.00
ATOM   1693  CA  LYS   108       6.942 -18.685  -6.701  1.00  0.00
ATOM   1694  HA  LYS   108       6.708 -19.631  -7.187  1.00  0.00
ATOM   1695  CB  LYS   108       8.472 -18.426  -6.773  1.00  0.00
ATOM   1696  HB1 LYS   108       8.980 -19.140  -6.128  1.00  0.00
ATOM   1697  HB2 LYS   108       8.670 -17.427  -6.397  1.00  0.00
ATOM   1698  CG  LYS   108       9.079 -18.538  -8.184  1.00  0.00
ATOM   1699  HG1 LYS   108       8.475 -17.946  -8.865  1.00  0.00
ATOM   1700  HG2 LYS   108       9.045 -19.574  -8.498  1.00  0.00
ATOM   1701  CD  LYS   108      10.537 -18.048  -8.262  1.00  0.00
ATOM   1702  HD1 LYS   108      11.166 -18.699  -7.662  1.00  0.00
ATOM   1703  HD2 LYS   108      10.592 -17.037  -7.867  1.00  0.00
ATOM   1704  CE  LYS   108      11.059 -18.041  -9.707  1.00  0.00
ATOM   1705  HE1 LYS   108      10.418 -17.410 -10.314  1.00  0.00
ATOM   1706  HE2 LYS   108      11.037 -19.050 -10.101  1.00  0.00
ATOM   1707  NZ  LYS   108      12.447 -17.533  -9.804  1.00  0.00
ATOM   1708  HZ1 LYS   108      12.491 -16.547  -9.472  1.00  0.00
ATOM   1709  HZ2 LYS   108      12.773 -17.570 -10.790  1.00  0.00
ATOM   1710  HZ3 LYS   108      13.078 -18.110  -9.219  1.00  0.00
ATOM   1711  C   LYS   108       6.513 -18.750  -5.239  1.00  0.00
ATOM   1712  O   LYS   108       6.220 -17.721  -4.642  1.00  0.00
ATOM   1713  N   ALA   109       6.502 -19.953  -4.665  1.00  0.00
ATOM   1714  HN  ALA   109       6.737 -20.734  -5.208  1.00  0.00
ATOM   1715  CA  ALA   109       6.172 -20.164  -3.255  1.00  0.00
ATOM   1716  HA  ALA   109       6.435 -19.255  -2.705  1.00  0.00
ATOM   1717  CB  ALA   109       4.675 -20.420  -3.061  1.00  0.00
ATOM   1718  HB1 ALA   109       4.110 -19.584  -3.452  1.00  0.00
ATOM   1719  HB2 ALA   109       4.451 -20.530  -2.004  1.00  0.00
ATOM   1720  HB3 ALA   109       4.380 -21.325  -3.582  1.00  0.00
ATOM   1721  C   ALA   109       6.998 -21.320  -2.707  1.00  0.00
ATOM   1722  O   ALA   109       7.227 -22.318  -3.385  1.00  0.00
ATOM   1723  N   TRP   110       7.465 -21.142  -1.486  1.00  0.00
ATOM   1724  HN  TRP   110       7.229 -20.320  -1.027  1.00  0.00
ATOM   1725  CA  TRP   110       8.314 -22.088  -0.766  1.00  0.00
ATOM   1726  HA  TRP   110       8.312 -23.046  -1.280  1.00  0.00
ATOM   1727  CB  TRP   110       9.773 -21.523  -0.680  1.00  0.00
ATOM   1728  HB1 TRP   110      10.456 -22.341  -0.472  1.00  0.00
ATOM   1729  HB2 TRP   110       9.837 -20.806   0.130  1.00  0.00
ATOM   1730  CG  TRP   110      10.254 -20.819  -1.942  1.00  0.00
ATOM   1731  CD1 TRP   110      10.829 -21.392  -3.027  1.00  0.00
ATOM   1732  HD1 TRP   110      11.029 -22.441  -3.116  1.00  0.00
ATOM   1733  CD2 TRP   110      10.173 -19.414  -2.249  1.00  0.00
ATOM   1734  NE1 TRP   110      11.114 -20.458  -3.978  1.00  0.00
ATOM   1735  HE1 TRP   110      11.535 -20.638  -4.845  1.00  0.00
ATOM   1736  CE2 TRP   110      10.722 -19.236  -3.527  1.00  0.00
ATOM   1737  CE3 TRP   110       9.684 -18.298  -1.572  1.00  0.00
ATOM   1738  HE3 TRP   110       9.250 -18.392  -0.588  1.00  0.00
ATOM   1739  CZ2 TRP   110      10.812 -17.991  -4.134  1.00  0.00
ATOM   1740  HZ2 TRP   110      11.239 -17.864  -5.121  1.00  0.00
ATOM   1741  CZ3 TRP   110       9.770 -17.060  -2.173  1.00  0.00
ATOM   1742  HZ3 TRP   110       9.399 -16.182  -1.657  1.00  0.00
ATOM   1743  CH2 TRP   110      10.328 -16.917  -3.446  1.00  0.00
ATOM   1744  HH2 TRP   110      10.376 -15.926  -3.883  1.00  0.00
ATOM   1745  C   TRP   110       7.708 -22.259   0.635  1.00  0.00
ATOM   1746  O   TRP   110       6.983 -21.371   1.105  1.00  0.00
ATOM   1747  N   PHE   111       7.969 -23.381   1.302  1.00  0.00
ATOM   1748  HN  PHE   111       8.426 -24.118   0.848  1.00  0.00
ATOM   1749  CA  PHE   111       7.574 -23.541   2.713  1.00  0.00
ATOM   1750  HA  PHE   111       7.517 -22.541   3.155  1.00  0.00
ATOM   1751  CB  PHE   111       6.172 -24.216   2.858  1.00  0.00
ATOM   1752  HB1 PHE   111       5.495 -23.767   2.137  1.00  0.00
ATOM   1753  HB2 PHE   111       5.784 -24.007   3.851  1.00  0.00
ATOM   1754  CG  PHE   111       6.127 -25.733   2.651  1.00  0.00
ATOM   1755  CD1 PHE   111       6.113 -26.601   3.748  1.00  0.00
ATOM   1756  HD1 PHE   111       6.134 -26.191   4.750  1.00  0.00
ATOM   1757  CD2 PHE   111       6.102 -26.292   1.375  1.00  0.00
ATOM   1758  HD2 PHE   111       6.113 -25.645   0.507  1.00  0.00
ATOM   1759  CE1 PHE   111       6.072 -27.967   3.576  1.00  0.00
ATOM   1760  HE1 PHE   111       6.066 -28.618   4.446  1.00  0.00
ATOM   1761  CE2 PHE   111       6.058 -27.666   1.203  1.00  0.00
ATOM   1762  HE2 PHE   111       6.036 -28.085   0.203  1.00  0.00
ATOM   1763  CZ  PHE   111       6.044 -28.503   2.302  1.00  0.00
ATOM   1764  HZ  PHE   111       6.010 -29.578   2.166  1.00  0.00
ATOM   1765  C   PHE   111       8.658 -24.311   3.463  1.00  0.00
ATOM   1766  O   PHE   111       9.311 -25.203   2.897  1.00  0.00
ATOM   1767  N   LYS   112       8.853 -23.944   4.733  1.00  0.00
ATOM   1768  HN  LYS   112       8.345 -23.179   5.081  1.00  0.00
ATOM   1769  CA  LYS   112       9.775 -24.624   5.639  1.00  0.00
ATOM   1770  HA  LYS   112      10.080 -25.557   5.172  1.00  0.00
ATOM   1771  CB  LYS   112      11.048 -23.763   5.904  1.00  0.00
ATOM   1772  HB1 LYS   112      11.567 -23.625   4.959  1.00  0.00
ATOM   1773  HB2 LYS   112      11.705 -24.320   6.568  1.00  0.00
ATOM   1774  CG  LYS   112      10.812 -22.366   6.527  1.00  0.00
ATOM   1775  HG1 LYS   112      10.194 -22.481   7.412  1.00  0.00
ATOM   1776  HG2 LYS   112      10.289 -21.745   5.807  1.00  0.00
ATOM   1777  CD  LYS   112      12.137 -21.673   6.926  1.00  0.00
ATOM   1778  HD1 LYS   112      12.744 -21.538   6.035  1.00  0.00
ATOM   1779  HD2 LYS   112      12.672 -22.314   7.619  1.00  0.00
ATOM   1780  CE  LYS   112      11.934 -20.306   7.597  1.00  0.00
ATOM   1781  HE1 LYS   112      11.281 -20.419   8.454  1.00  0.00
ATOM   1782  HE2 LYS   112      11.476 -19.624   6.889  1.00  0.00
ATOM   1783  NZ  LYS   112      13.224 -19.721   8.052  1.00  0.00
ATOM   1784  HZ1 LYS   112      13.667 -20.339   8.762  1.00  0.00
ATOM   1785  HZ2 LYS   112      13.065 -18.784   8.468  1.00  0.00
ATOM   1786  HZ3 LYS   112      13.871 -19.623   7.246  1.00  0.00
ATOM   1787  C   LYS   112       9.041 -24.961   6.939  1.00  0.00
ATOM   1788  O   LYS   112       8.473 -24.080   7.585  1.00  0.00
ATOM   1789  N   ILE   113       9.040 -26.250   7.322  1.00  0.00
ATOM   1790  HN  ILE   113       9.508 -26.906   6.774  1.00  0.00
ATOM   1791  CA  ILE   113       8.370 -26.703   8.547  1.00  0.00
ATOM   1792  HA  ILE   113       7.521 -26.041   8.731  1.00  0.00
ATOM   1793  CB  ILE   113       7.816 -28.165   8.418  1.00  0.00
ATOM   1794  HB  ILE   113       8.638 -28.807   8.123  1.00  0.00
ATOM   1795  CG1 ILE   113       6.712 -28.224   7.318  1.00  0.00
ATOM   1796 HG11 ILE   113       7.049 -27.713   6.424  1.00  0.00
ATOM   1797 HG12 ILE   113       5.829 -27.716   7.680  1.00  0.00
ATOM   1798  CG2 ILE   113       7.259 -28.692   9.777  1.00  0.00
ATOM   1799 HG21 ILE   113       6.885 -29.702   9.653  1.00  0.00
ATOM   1800 HG22 ILE   113       6.450 -28.056  10.113  1.00  0.00
ATOM   1801 HG23 ILE   113       8.045 -28.690  10.523  1.00  0.00
ATOM   1802  CD1 ILE   113       6.289 -29.624   6.937  1.00  0.00
ATOM   1803 HD11 ILE   113       7.147 -30.184   6.587  1.00  0.00
ATOM   1804 HD12 ILE   113       5.550 -29.574   6.153  1.00  0.00
ATOM   1805 HD13 ILE   113       5.865 -30.117   7.799  1.00  0.00
ATOM   1806  C   ILE   113       9.363 -26.597   9.707  1.00  0.00
ATOM   1807  O   ILE   113      10.473 -27.147   9.642  1.00  0.00
ATOM   1808  N   GLY   114       8.949 -25.855  10.735  1.00  0.00
ATOM   1809  HN  GLY   114       8.035 -25.487  10.695  1.00  0.00
ATOM   1810  CA  GLY   114       9.788 -25.579  11.902  1.00  0.00
ATOM   1811  HA1 GLY   114       9.270 -24.872  12.536  1.00  0.00
ATOM   1812  HA2 GLY   114      10.716 -25.124  11.570  1.00  0.00
ATOM   1813  C   GLY   114      10.096 -26.827  12.718  1.00  0.00
ATOM   1814  O   GLY   114      11.252 -27.278  12.764  1.00  0.00
ATOM   1815  N   GLU   115       9.053 -27.397  13.343  1.00  0.00
ATOM   1816  HN  GLU   115       8.162 -26.994  13.241  1.00  0.00
ATOM   1817  CA  GLU   115       9.172 -28.619  14.151  1.00  0.00
ATOM   1818  HA  GLU   115       9.852 -29.295  13.644  1.00  0.00
ATOM   1819  CB  GLU   115       9.728 -28.287  15.575  1.00  0.00
ATOM   1820  HB1 GLU   115      10.550 -27.585  15.476  1.00  0.00
ATOM   1821  HB2 GLU   115      10.109 -29.202  16.018  1.00  0.00
ATOM   1822  CG  GLU   115       8.686 -27.683  16.540  1.00  0.00
ATOM   1823  HG1 GLU   115       7.840 -28.377  16.594  1.00  0.00
ATOM   1824  HG2 GLU   115       8.331 -26.745  16.126  1.00  0.00
ATOM   1825  CD  GLU   115       9.222 -27.446  17.960  1.00  0.00
ATOM   1826  OE1 GLU   115       9.196 -28.387  18.779  1.00  0.00
ATOM   1827  OE2 GLU   115       9.645 -26.314  18.276  1.00  0.00
ATOM   1828  C   GLU   115       7.789 -29.299  14.272  1.00  0.00
ATOM   1829  O   GLU   115       6.761 -28.666  13.976  1.00  0.00
ATOM   1830  N   PRO   116       7.741 -30.602  14.687  1.00  0.00
ATOM   1831  CA  PRO   116       6.494 -31.239  15.173  1.00  0.00
ATOM   1832  HA  PRO   116       5.641 -30.943  14.576  1.00  0.00
ATOM   1833  CB  PRO   116       6.790 -32.733  14.950  1.00  0.00
ATOM   1834  HB1 PRO   116       6.506 -32.996  13.942  1.00  0.00
ATOM   1835  HB2 PRO   116       6.227 -33.346  15.649  1.00  0.00
ATOM   1836  CG  PRO   116       8.272 -32.873  15.146  1.00  0.00
ATOM   1837  HG1 PRO   116       8.648 -33.718  14.577  1.00  0.00
ATOM   1838  HG2 PRO   116       8.494 -33.012  16.201  1.00  0.00
ATOM   1839  CD  PRO   116       8.876 -31.579  14.638  1.00  0.00
ATOM   1840  HD1 PRO   116       9.233 -31.695  13.621  1.00  0.00
ATOM   1841  HD2 PRO   116       9.687 -31.253  15.282  1.00  0.00
ATOM   1842  C   PRO   116       6.206 -30.918  16.661  1.00  0.00
ATOM   1843  O   PRO   116       7.129 -30.919  17.488  1.00  0.00
ATOM   1844  N   ARG   117       4.924 -30.616  16.993  1.00  0.00
ATOM   1845  HN  ARG   117       4.262 -30.532  16.275  1.00  0.00
ATOM   1846  CA  ARG   117       4.478 -30.391  18.393  1.00  0.00
ATOM   1847  HA  ARG   117       5.260 -30.770  19.040  1.00  0.00
ATOM   1848  CB  ARG   117       4.276 -28.879  18.700  1.00  0.00
ATOM   1849  HB1 ARG   117       3.834 -28.780  19.688  1.00  0.00
ATOM   1850  HB2 ARG   117       3.586 -28.466  17.969  1.00  0.00
ATOM   1851  CG  ARG   117       5.565 -28.041  18.664  1.00  0.00
ATOM   1852  HG1 ARG   117       5.961 -28.057  17.652  1.00  0.00
ATOM   1853  HG2 ARG   117       6.297 -28.484  19.334  1.00  0.00
ATOM   1854  CD  ARG   117       5.337 -26.586  19.081  1.00  0.00
ATOM   1855  HD1 ARG   117       4.955 -26.564  20.096  1.00  0.00
ATOM   1856  HD2 ARG   117       4.603 -26.141  18.414  1.00  0.00
ATOM   1857  NE  ARG   117       6.581 -25.804  19.027  1.00  0.00
ATOM   1858  HE  ARG   117       7.418 -26.293  19.188  1.00  0.00
ATOM   1859  CZ  ARG   117       6.657 -24.493  18.783  1.00  0.00
ATOM   1860  NH1 ARG   117       5.561 -23.791  18.512  1.00  0.00
ATOM   1861 HH11 ARG   117       4.663 -24.247  18.479  1.00  0.00
ATOM   1862 HH12 ARG   117       5.617 -22.807  18.348  1.00  0.00
ATOM   1863  NH2 ARG   117       7.837 -23.897  18.772  1.00  0.00
ATOM   1864 HH21 ARG   117       8.673 -24.434  18.945  1.00  0.00
ATOM   1865 HH22 ARG   117       7.911 -22.914  18.593  1.00  0.00
ATOM   1866  C   ARG   117       3.185 -31.163  18.716  1.00  0.00
ATOM   1867  O   ARG   117       2.409 -31.535  17.826  1.00  0.00
ATOM   1868  N   ILE   118       2.974 -31.375  20.032  1.00  0.00
ATOM   1869  HN  ILE   118       3.617 -30.990  20.664  1.00  0.00
ATOM   1870  CA  ILE   118       1.835 -32.123  20.603  1.00  0.00
ATOM   1871  HA  ILE   118       1.035 -32.176  19.864  1.00  0.00
ATOM   1872  CB  ILE   118       2.265 -33.596  21.008  1.00  0.00
ATOM   1873  HB  ILE   118       3.094 -33.515  21.708  1.00  0.00
ATOM   1874  CG1 ILE   118       2.754 -34.407  19.770  1.00  0.00
ATOM   1875 HG11 ILE   118       3.130 -35.368  20.099  1.00  0.00
ATOM   1876 HG12 ILE   118       3.559 -33.868  19.289  1.00  0.00
ATOM   1877  CG2 ILE   118       1.130 -34.358  21.729  1.00  0.00
ATOM   1878 HG21 ILE   118       0.866 -33.840  22.644  1.00  0.00
ATOM   1879 HG22 ILE   118       1.449 -35.363  21.972  1.00  0.00
ATOM   1880 HG23 ILE   118       0.255 -34.405  21.084  1.00  0.00
ATOM   1881  CD1 ILE   118       1.695 -34.665  18.720  1.00  0.00
ATOM   1882 HD11 ILE   118       0.912 -35.278  19.142  1.00  0.00
ATOM   1883 HD12 ILE   118       2.138 -35.173  17.878  1.00  0.00
ATOM   1884 HD13 ILE   118       1.271 -33.722  18.393  1.00  0.00
ATOM   1885  C   ILE   118       1.334 -31.368  21.850  1.00  0.00
ATOM   1886  O   ILE   118       2.152 -30.899  22.641  1.00  0.00
END
