
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  157 ( 1251),  selected  157 , name 2gey_A
# Molecule2: number of CA atoms  117 ( 1867),  selected  117 , name T0475.pdb
# PARAMETERS: 2gey_A.T0475.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     2_A      -       -           -
LGA    M     3_A      N       2          1.960
LGA    A     4_A      S       3          3.660
LGA    E     5_A      E       4          3.994
LGA    R     6_A      I       5          1.911
LGA    K     7_A      E       6          2.110
LGA    A     8_A      L       7          3.776
LGA    L     9_A      P       8          2.928
LGA    C    10_A      V       9          0.933
LGA    L    11_A      Q      10          1.319
LGA    E    12_A      K      11          1.017
LGA    M    13_A      Q      12          0.634
LGA    V    14_A      L      13          0.671
LGA    A    15_A      E      14          0.740
LGA    A    16_A      A      15          0.612
LGA    W    17_A      Y      16          1.037
LGA    N    18_A      N      17          1.742
LGA    R    19_A      A      18          0.946
LGA    W    20_A      R      19          0.914
LGA    D    21_A      D      20          1.248
LGA    L    22_A      I      21          1.399
LGA    S    23_A      D      22          1.578
LGA    G    24_A      A      23          1.418
LGA    I    25_A      F      24          0.589
LGA    I    26_A      M      25          0.541
LGA    K    27_A      A      26          0.822
LGA    H    28_A      W      27          0.890
LGA    W    29_A      W      28          0.954
LGA    S    30_A      A      29          0.631
LGA    P    31_A      D      30          0.978
LGA    D    32_A      D      31          1.629
LGA    I    33_A      C      32          0.640
LGA    V    34_A      Q      33          0.895
LGA    H    35_A      Y      34          1.083
LGA    Y    36_A      Y      35          1.451
LGA    S    37_A      A      36          1.608
LGA    E    38_A      F      37          2.876
LGA    -       -      P      38           -
LGA    D    39_A      A      39          1.120
LGA    N    40_A      T      40          2.043
LGA    E    41_A      L      41          1.317
LGA    V    42_A      L      42          1.456
LGA    S    43_A      A      43          1.588
LGA    -       -      G      44           -
LGA    -       -      N      45           -
LGA    S    44_A      A      46          4.543
LGA    A    45_A      A      47          4.812
LGA    D    46_A      E      48          4.427
LGA    M    47_A      I      49          3.326
LGA    V    48_A      R      50          2.979
LGA    K    49_A      V      51          3.353
LGA    L    50_A      R      52          2.762
LGA    M    51_A      H      53          1.056
LGA    E    52_A      I      54          1.753
LGA    G    53_A      E      55          1.764
LGA    G    54_A      R      56          1.433
LGA    L    55_A      F      57          1.610
LGA    K    56_A      K      58          1.281
LGA    A    57_A      E      59          2.772
LGA    F    58_A      -       -           -
LGA    P    59_A      P      60          1.631
LGA    D    60_A      D      61          3.682
LGA    L    61_A      L      62          2.181
LGA    Q    62_A      Y      63          1.971
LGA    L    63_A      G      64          1.543
LGA    E    64_A      E      65          1.880
LGA    V    65_A      L      66          1.742
LGA    K    66_A      L      67          1.382
LGA    S    67_A      T      68          1.308
LGA    I    68_A      R      69          1.110
LGA    M    69_A      V      70          1.124
LGA    A    70_A      I      71          1.086
LGA    E    71_A      V      72          1.564
LGA    E    72_A      G      73          1.831
LGA    D    73_A      N      74          1.056
LGA    R    74_A      V      75          1.025
LGA    V    75_A      V      76          1.036
LGA    A    76_A      I      77          1.101
LGA    L    77_A      D      78          1.169
LGA    R    78_A      H      79          0.930
LGA    I    79_A      E      80          0.922
LGA    T    80_A      T      81          1.011
LGA    V    81_A      V      82          1.657
LGA    T    82_A      T      83          1.919
LGA    A    83_A      R      84          4.383
LGA    T    84_A      -       -           -
LGA    H    85_A      N      85          3.357
LGA    Q    86_A      -       -           -
LGA    G    87_A      -       -           -
LGA    E    88_A      -       -           -
LGA    F    89_A      -       -           -
LGA    M    90_A      F      86           #
LGA    G    91_A      -       -           -
LGA    V    92_A      -       -           -
LGA    Q    93_A      -       -           -
LGA    P    94_A      -       -           -
LGA    T    95_A      P      87           #
LGA    G    96_A      E      88           -
LGA    Q    97_A      G      89          5.284
LGA    R    98_A      K      90          3.217
LGA    V    99_A      G      91          2.368
LGA    S   100_A      E      92          0.649
LGA    W   101_A      V      93          0.805
LGA    H   102_A      D      94          1.318
LGA    L   103_A      V      95          0.757
LGA    V   104_A      A      96          0.690
LGA    E   105_A      C      97          1.034
LGA    E   106_A      I      98          1.067
LGA    L   107_A      Y      99          0.941
LGA    R   108_A      E     100          0.998
LGA    F   109_A      V     101          0.983
LGA    V   110_A      E     102          1.637
LGA    D   111_A      N     103          2.130
LGA    G   112_A      G     104          1.403
LGA    K   113_A      R     105          0.604
LGA    V   114_A      I     106          0.496
LGA    V   115_A      A     107          0.463
LGA    E   116_A      K     108          0.527
LGA    H   117_A      A     109          0.321
LGA    W   118_A      W     110          0.912
LGA    D   119_A      F     111          0.685
LGA    V   120_A      K     112          0.449
LGA    I   121_A      I     113          1.656
LGA    N   122_A      G     114          3.398
LGA    M   123_A      E     115          5.261
LGA    R   124_A      P     116          2.711
LGA    P   125_A      R     117          3.168
LGA    L   126_A      -       -           -
LGA    L   127_A      -       -           -
LGA    V   128_A      -       -           -
LGA    R   129_A      I     118           #
LGA    L   130_A      -       -           -
LGA    G   131_A      -       -           -
LGA    K   132_A      -       -           -
LGA    L   133_A      -       -           -
LGA    P   134_A      -       -           -
LGA    D   135_A      -       -           -
LGA    V   136_A      -       -           -
LGA    P   137_A      -       -           -
LGA    K   138_A      -       -           -
LGA    V   139_A      -       -           -
LGA    V   140_A      -       -           -
LGA    L   141_A      -       -           -
LGA    E   142_A      -       -           -
LGA    A   143_A      -       -           -
LGA    S   144_A      -       -           -
LGA    A   145_A      -       -           -
LGA    K   146_A      -       -           -
LGA    L   147_A      -       -           -
LGA    A   148_A      -       -           -
LGA    A   149_A      -       -           -
LGA    A   150_A      -       -           -
LGA    L   151_A      -       -           -
LGA    E   152_A      -       -           -
LGA    H   153_A      -       -           -
LGA    H   154_A      -       -           -
LGA    H   155_A      -       -           -
LGA    H   156_A      -       -           -
LGA    H   157_A      -       -           -
LGA    H   158_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  157  117    5.0    110    2.04    18.18     76.037     5.142

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.172040 * X  +  -0.172439 * Y  +   0.969880 * Z  + -23.458246
  Y_new =  -0.960339 * X  +  -0.189957 * Y  +  -0.204121 * Z  +  16.318777
  Z_new =   0.219434 * X  +  -0.966530 * Y  +  -0.132919 * Z  +  17.210245 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.707461    1.434131  [ DEG:   -97.8303     82.1697 ]
  Theta =  -0.221235   -2.920358  [ DEG:   -12.6758   -167.3242 ]
  Phi   =  -1.748061    1.393532  [ DEG:  -100.1565     79.8435 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2gey_A                                        
REMARK     2: T0475.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2gey_A.T0475.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  157  117   5.0  110   2.04   18.18  76.037
REMARK  ---------------------------------------------------------- 
MOLECULE 2gey_A
HEADER    OXIDOREDUCTASE                          21-MAR-06   2GEY              
TITLE     CRYSTAL STRUCTURE OF ACLR A PUTATIVE HYDROXYLASE FROM                 
TITLE    2 STREPTOMYCES GALILAEUS                                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ACLR PROTEIN;                                              
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 SYNONYM: PUTATIVE HYDROXYLASE;                                       
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOMYCES GALILAEUS;                         
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: ATCC31133;                                                   
SOURCE   5 GENE: ACLR;                                                          
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: PET30B                                    
KEYWDS    ALPHA+BETA BARREL                                                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    P.BEINKER,B.LOHKAMP,G.SCHNEIDER                                       
REVDAT   1   18-JUL-06 2GEY    0                                                
JRNL        AUTH   P.BEINKER,B.LOHKAMP,T.PELTONEN,J.NIEMI,P.MANTSALA,           
JRNL        AUTH 2 G.SCHNEIDER                                                  
JRNL        TITL   CRYSTAL STRUCTURES OF SNOAL2 AND ACLR: TWO                   
JRNL        TITL 2 PUTATIVE HYDROXYLASES IN THE BIOSYNTHESIS OF                 
JRNL        TITL 3 AROMATIC POLYKETIDE ANTIBIOTICS                              
JRNL        REF    J.MOL.BIOL.                   V. 359   728 2006              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  2GEY A    1   145  UNP    Q1XDX7   Q1XDX7_9ACTO     1    145             
DBREF  2GEY B    1   145  UNP    Q1XDX7   Q1XDX7_9ACTO     1    145             
DBREF  2GEY C    1   145  UNP    Q1XDX7   Q1XDX7_9ACTO     1    145             
DBREF  2GEY D    1   145  UNP    Q1XDX7   Q1XDX7_9ACTO     1    145             
SEQRES   1 A  158  MET SER MET ALA GLU ARG LYS ALA LEU CYS LEU GLU MET          
SEQRES   2 A  158  VAL ALA ALA TRP ASN ARG TRP ASP LEU SER GLY ILE ILE          
SEQRES   3 A  158  LYS HIS TRP SER PRO ASP ILE VAL HIS TYR SER GLU ASP          
SEQRES   4 A  158  ASN GLU VAL SER SER ALA ASP MET VAL LYS LEU MET GLU          
SEQRES   5 A  158  GLY GLY LEU LYS ALA PHE PRO ASP LEU GLN LEU GLU VAL          
SEQRES   6 A  158  LYS SER ILE MET ALA GLU GLU ASP ARG VAL ALA LEU ARG          
SEQRES   7 A  158  ILE THR VAL THR ALA THR HIS GLN GLY GLU PHE MET GLY          
SEQRES   8 A  158  VAL GLN PRO THR GLY GLN ARG VAL SER TRP HIS LEU VAL          
SEQRES   9 A  158  GLU GLU LEU ARG PHE VAL ASP GLY LYS VAL VAL GLU HIS          
SEQRES  10 A  158  TRP ASP VAL ILE ASN MET ARG PRO LEU LEU VAL ARG LEU          
SEQRES  11 A  158  GLY LYS LEU PRO ASP VAL PRO LYS VAL VAL LEU GLU ALA          
SEQRES  12 A  158  SER ALA LYS LEU ALA ALA ALA LEU GLU HIS HIS HIS HIS          
SEQRES  13 A  158  HIS HIS                                                      
SEQRES   1 B  158  MET SER MET ALA GLU ARG LYS ALA LEU CYS LEU GLU MET          
SEQRES   2 B  158  VAL ALA ALA TRP ASN ARG TRP ASP LEU SER GLY ILE ILE          
SEQRES   3 B  158  LYS HIS TRP SER PRO ASP ILE VAL HIS TYR SER GLU ASP          
SEQRES   4 B  158  ASN GLU VAL SER SER ALA ASP MET VAL LYS LEU MET GLU          
SEQRES   5 B  158  GLY GLY LEU LYS ALA PHE PRO ASP LEU GLN LEU GLU VAL          
SEQRES   6 B  158  LYS SER ILE MET ALA GLU GLU ASP ARG VAL ALA LEU ARG          
SEQRES   7 B  158  ILE THR VAL THR ALA THR HIS GLN GLY GLU PHE MET GLY          
SEQRES   8 B  158  VAL GLN PRO THR GLY GLN ARG VAL SER TRP HIS LEU VAL          
SEQRES   9 B  158  GLU GLU LEU ARG PHE VAL ASP GLY LYS VAL VAL GLU HIS          
SEQRES  10 B  158  TRP ASP VAL ILE ASN MET ARG PRO LEU LEU VAL ARG LEU          
SEQRES  11 B  158  GLY LYS LEU PRO ASP VAL PRO LYS VAL VAL LEU GLU ALA          
SEQRES  12 B  158  SER ALA LYS LEU ALA ALA ALA LEU GLU HIS HIS HIS HIS          
SEQRES  13 B  158  HIS HIS                                                      
SEQRES   1 C  158  MET SER MET ALA GLU ARG LYS ALA LEU CYS LEU GLU MET          
SEQRES   2 C  158  VAL ALA ALA TRP ASN ARG TRP ASP LEU SER GLY ILE ILE          
SEQRES   3 C  158  LYS HIS TRP SER PRO ASP ILE VAL HIS TYR SER GLU ASP          
SEQRES   4 C  158  ASN GLU VAL SER SER ALA ASP MET VAL LYS LEU MET GLU          
SEQRES   5 C  158  GLY GLY LEU LYS ALA PHE PRO ASP LEU GLN LEU GLU VAL          
SEQRES   6 C  158  LYS SER ILE MET ALA GLU GLU ASP ARG VAL ALA LEU ARG          
SEQRES   7 C  158  ILE THR VAL THR ALA THR HIS GLN GLY GLU PHE MET GLY          
SEQRES   8 C  158  VAL GLN PRO THR GLY GLN ARG VAL SER TRP HIS LEU VAL          
SEQRES   9 C  158  GLU GLU LEU ARG PHE VAL ASP GLY LYS VAL VAL GLU HIS          
SEQRES  10 C  158  TRP ASP VAL ILE ASN MET ARG PRO LEU LEU VAL ARG LEU          
SEQRES  11 C  158  GLY LYS LEU PRO ASP VAL PRO LYS VAL VAL LEU GLU ALA          
SEQRES  12 C  158  SER ALA LYS LEU ALA ALA ALA LEU GLU HIS HIS HIS HIS          
SEQRES  13 C  158  HIS HIS                                                      
SEQRES   1 D  158  MET SER MET ALA GLU ARG LYS ALA LEU CYS LEU GLU MET          
SEQRES   2 D  158  VAL ALA ALA TRP ASN ARG TRP ASP LEU SER GLY ILE ILE          
SEQRES   3 D  158  LYS HIS TRP SER PRO ASP ILE VAL HIS TYR SER GLU ASP          
SEQRES   4 D  158  ASN GLU VAL SER SER ALA ASP MET VAL LYS LEU MET GLU          
SEQRES   5 D  158  GLY GLY LEU LYS ALA PHE PRO ASP LEU GLN LEU GLU VAL          
SEQRES   6 D  158  LYS SER ILE MET ALA GLU GLU ASP ARG VAL ALA LEU ARG          
SEQRES   7 D  158  ILE THR VAL THR ALA THR HIS GLN GLY GLU PHE MET GLY          
SEQRES   8 D  158  VAL GLN PRO THR GLY GLN ARG VAL SER TRP HIS LEU VAL          
SEQRES   9 D  158  GLU GLU LEU ARG PHE VAL ASP GLY LYS VAL VAL GLU HIS          
SEQRES  10 D  158  TRP ASP VAL ILE ASN MET ARG PRO LEU LEU VAL ARG LEU          
SEQRES  11 D  158  GLY LYS LEU PRO ASP VAL PRO LYS VAL VAL LEU GLU ALA          
SEQRES  12 D  158  SER ALA LYS LEU ALA ALA ALA LEU GLU HIS HIS HIS HIS          
SEQRES  13 D  158  HIS HIS                                                      
HET    PG4   1001      13                                                       
HET    PG4   1002      13                                                       
HET    PG4   1003      13                                                       
HET    PG4   1004      13                                                       
HET    GOL   2001       6                                                       
HET    GOL   2002       6                                                       
HET    GOL   2003       6                                                       
HET    GOL   2004       6                                                       
HET    GOL   2005       6                                                       
HET    PEG   3001       7                                                       
HETNAM     PG4 TETRAETHYLENE GLYCOL                                             
HETNAM     GOL GLYCEROL                                                         
HETNAM     PEG DI(HYDROXYETHYL)ETHER                                            
FORMUL   5  PG4    4(C8 H18 O5)                                                 
FORMUL   9  GOL    5(C3 H8 O3)                                                  
FORMUL  14  PEG    C4 H10 O3                                                    
FORMUL  15  HOH   *548(H2 O)                                                    
CRYST1   80.908   81.724  136.640  90.00  90.00  90.00 P 21 21 21   16          
ATOM      1  N   SER A   2       0.503  -2.975  -3.527  1.00 26.72           N  
ATOM      2  CA  SER A   2       1.284  -2.542  -2.337  1.00 26.13           C  
ATOM      3  C   SER A   2       1.494  -3.723  -1.412  1.00 25.81           C  
ATOM      4  O   SER A   2       0.823  -4.746  -1.548  1.00 24.97           O  
ATOM      5  CB  SER A   2       0.510  -1.472  -1.578  1.00 26.55           C  
ATOM      6  OG  SER A   2      -0.600  -2.063  -0.927  1.00 26.94           O  
ATOM      7  N   MET A   3       2.393  -3.560  -0.442  1.00 25.34           N  
ATOM      8  CA  MET A   3       2.633  -4.591   0.559  1.00 25.35           C  
ATOM      9  C   MET A   3       1.348  -4.935   1.314  1.00 24.81           C  
ATOM     10  O   MET A   3       1.058  -6.095   1.542  1.00 24.58           O  
ATOM     11  CB  MET A   3       3.711  -4.133   1.544  1.00 25.05           C  
ATOM     12  CG  MET A   3       5.109  -4.080   0.946  1.00 25.03           C  
ATOM     13  SD  MET A   3       6.358  -3.494   2.102  1.00 26.97           S  
ATOM     14  CE  MET A   3       6.072  -1.728   2.032  1.00 28.03           C  
ATOM     15  N   ALA A   4       0.580  -3.912   1.682  1.00 24.85           N  
ATOM     16  CA  ALA A   4      -0.677  -4.103   2.405  1.00 24.80           C  
ATOM     17  C   ALA A   4      -1.657  -4.961   1.605  1.00 24.79           C  
ATOM     18  O   ALA A   4      -2.292  -5.860   2.153  1.00 23.92           O  
ATOM     19  CB  ALA A   4      -1.296  -2.765   2.726  1.00 24.99           C  
ATOM     20  N   GLU A   5      -1.764  -4.689   0.304  1.00 24.45           N  
ATOM     21  CA  GLU A   5      -2.673  -5.435  -0.564  1.00 25.10           C  
ATOM     22  C   GLU A   5      -2.222  -6.877  -0.747  1.00 24.71           C  
ATOM     23  O   GLU A   5      -3.047  -7.797  -0.759  1.00 24.50           O  
ATOM     24  CB  GLU A   5      -2.800  -4.740  -1.918  1.00 25.33           C  
ATOM     25  CG  GLU A   5      -3.607  -3.454  -1.801  1.00 27.00           C  
ATOM     26  CD  GLU A   5      -3.312  -2.429  -2.875  1.00 28.19           C  
ATOM     27  OE1 GLU A   5      -2.444  -2.659  -3.757  1.00 31.15           O  
ATOM     28  OE2 GLU A   5      -3.988  -1.382  -2.825  1.00 30.53           O  
ATOM     29  N   ARG A   6      -0.916  -7.082  -0.892  1.00 24.61           N  
ATOM     30  CA  ARG A   6      -0.387  -8.434  -1.052  1.00 24.65           C  
ATOM     31  C   ARG A   6      -0.566  -9.251   0.235  1.00 24.54           C  
ATOM     32  O   ARG A   6      -0.902 -10.435   0.166  1.00 24.63           O  
ATOM     33  CB  ARG A   6       1.061  -8.415  -1.531  1.00 24.48           C  
ATOM     34  CG  ARG A   6       1.178  -7.906  -2.968  1.00 24.31           C  
ATOM     35  CD  ARG A   6       2.593  -7.950  -3.486  1.00 25.46           C  
ATOM     36  NE  ARG A   6       3.418  -6.852  -2.987  1.00 25.06           N  
ATOM     37  CZ  ARG A   6       3.440  -5.619  -3.497  1.00 26.31           C  
ATOM     38  NH1 ARG A   6       2.675  -5.283  -4.522  1.00 26.08           N  
ATOM     39  NH2 ARG A   6       4.238  -4.700  -2.965  1.00 26.83           N  
ATOM     40  N   LYS A   7      -0.371  -8.626   1.393  1.00 24.75           N  
ATOM     41  CA  LYS A   7      -0.701  -9.285   2.673  1.00 24.97           C  
ATOM     42  C   LYS A   7      -2.169  -9.704   2.709  1.00 24.88           C  
ATOM     43  O   LYS A   7      -2.493 -10.847   3.055  1.00 24.53           O  
ATOM     44  CB  LYS A   7      -0.362  -8.395   3.865  1.00 25.18           C  
ATOM     45  CG  LYS A   7       1.139  -8.276   4.077  1.00 25.92           C  
ATOM     46  CD  LYS A   7       1.505  -7.629   5.413  1.00 27.53           C  
ATOM     47  CE  LYS A   7       1.219  -6.140   5.449  1.00 30.51           C  
ATOM     48  NZ  LYS A   7       1.893  -5.502   6.643  1.00 30.62           N  
ATOM     49  N   ALA A   8      -3.057  -8.795   2.321  1.00 24.72           N  
ATOM     50  CA  ALA A   8      -4.493  -9.098   2.296  1.00 24.88           C  
ATOM     51  C   ALA A   8      -4.795 -10.281   1.387  1.00 25.01           C  
ATOM     52  O   ALA A   8      -5.586 -11.158   1.745  1.00 25.36           O  
ATOM     53  CB  ALA A   8      -5.294  -7.871   1.871  1.00 25.00           C  
ATOM     54  N   LEU A   9      -4.167 -10.333   0.211  1.00 24.76           N  
ATOM     55  CA  LEU A   9      -4.392 -11.463  -0.699  1.00 24.84           C  
ATOM     56  C   LEU A   9      -3.902 -12.770  -0.075  1.00 24.49           C  
ATOM     57  O   LEU A   9      -4.576 -13.798  -0.145  1.00 24.30           O  
ATOM     58  CB  LEU A   9      -3.719 -11.227  -2.050  1.00 24.82           C  
ATOM     59  CG  LEU A   9      -4.407 -10.156  -2.909  1.00 25.78           C  
ATOM     60  CD1 LEU A   9      -3.499  -9.712  -4.041  1.00 27.84           C  
ATOM     61  CD2 LEU A   9      -5.755 -10.667  -3.434  1.00 25.82           C  
ATOM     62  N   CYS A  10      -2.744 -12.731   0.572  1.00 24.72           N  
ATOM     63  CA  CYS A  10      -2.234 -13.926   1.270  1.00 25.06           C  
ATOM     64  C   CYS A  10      -3.188 -14.393   2.372  1.00 25.18           C  
ATOM     65  O   CYS A  10      -3.395 -15.590   2.570  1.00 25.11           O  
ATOM     66  CB  CYS A  10      -0.844 -13.658   1.848  1.00 24.83           C  
ATOM     67  SG  CYS A  10       0.408 -13.488   0.563  1.00 27.30           S  
ATOM     68  N   LEU A  11      -3.784 -13.454   3.079  1.00 25.16           N  
ATOM     69  CA  LEU A  11      -4.731 -13.817   4.127  1.00 25.24           C  
ATOM     70  C   LEU A  11      -6.031 -14.370   3.551  1.00 25.51           C  
ATOM     71  O   LEU A  11      -6.721 -15.150   4.204  1.00 25.14           O  
ATOM     72  CB  LEU A  11      -4.965 -12.636   5.062  1.00 25.07           C  
ATOM     73  CG  LEU A  11      -3.723 -12.230   5.870  1.00 25.50           C  
ATOM     74  CD1 LEU A  11      -4.021 -11.017   6.705  1.00 27.88           C  
ATOM     75  CD2 LEU A  11      -3.243 -13.372   6.772  1.00 26.80           C  
ATOM     76  N   GLU A  12      -6.344 -14.013   2.308  1.00 26.03           N  
ATOM     77  CA  GLU A  12      -7.471 -14.640   1.614  1.00 26.14           C  
ATOM     78  C   GLU A  12      -7.183 -16.089   1.264  1.00 25.87           C  
ATOM     79  O   GLU A  12      -8.082 -16.940   1.306  1.00 26.14           O  
ATOM     80  CB  GLU A  12      -7.874 -13.835   0.370  1.00 27.15           C  
ATOM     81  CG  GLU A  12      -8.550 -12.514   0.714  1.00 29.50           C  
ATOM     82  CD  GLU A  12      -9.675 -12.681   1.703  1.00 36.70           C  
ATOM     83  OE1 GLU A  12     -10.750 -13.187   1.308  1.00 41.40           O  
ATOM     84  OE2 GLU A  12      -9.475 -12.328   2.891  1.00 41.96           O  
ATOM     85  N   MET A  13      -5.934 -16.369   0.911  1.00 25.56           N  
ATOM     86  CA  MET A  13      -5.489 -17.732   0.692  1.00 25.89           C  
ATOM     87  C   MET A  13      -5.546 -18.547   1.994  1.00 24.81           C  
ATOM     88  O   MET A  13      -6.011 -19.678   1.991  1.00 24.33           O  
ATOM     89  CB  MET A  13      -4.092 -17.729   0.072  1.00 25.82           C  
ATOM     90  CG  MET A  13      -4.073 -17.090  -1.297  1.00 27.64           C  
ATOM     91  SD  MET A  13      -2.401 -16.910  -1.953  1.00 31.40           S  
ATOM     92  CE  MET A  13      -2.167 -18.500  -2.700  1.00 33.06           C  
ATOM     93  N   VAL A  14      -5.122 -17.952   3.105  1.00 24.80           N  
ATOM     94  CA  VAL A  14      -5.294 -18.582   4.429  1.00 24.70           C  
ATOM     95  C   VAL A  14      -6.783 -18.854   4.707  1.00 24.13           C  
ATOM     96  O   VAL A  14      -7.165 -19.952   5.137  1.00 23.96           O  
ATOM     97  CB  VAL A  14      -4.674 -17.712   5.560  1.00 25.10           C  
ATOM     98  CG1 VAL A  14      -5.003 -18.276   6.931  1.00 25.87           C  
ATOM     99  CG2 VAL A  14      -3.156 -17.601   5.400  1.00 25.84           C  
ATOM    100  N   ALA A  15      -7.631 -17.867   4.435  1.00 24.07           N  
ATOM    101  CA  ALA A  15      -9.069 -18.029   4.663  1.00 23.98           C  
ATOM    102  C   ALA A  15      -9.624 -19.186   3.833  1.00 23.34           C  
ATOM    103  O   ALA A  15     -10.462 -19.934   4.322  1.00 23.15           O  
ATOM    104  CB  ALA A  15      -9.817 -16.755   4.356  1.00 24.52           C  
ATOM    105  N   ALA A  16      -9.140 -19.334   2.595  1.00 23.38           N  
ATOM    106  CA  ALA A  16      -9.533 -20.433   1.720  1.00 23.30           C  
ATOM    107  C   ALA A  16      -9.178 -21.787   2.337  1.00 23.26           C  
ATOM    108  O   ALA A  16     -10.011 -22.696   2.358  1.00 23.10           O  
ATOM    109  CB  ALA A  16      -8.889 -20.287   0.347  1.00 24.17           C  
ATOM    110  N   TRP A  17      -7.946 -21.916   2.832  1.00 22.72           N  
ATOM    111  CA  TRP A  17      -7.543 -23.108   3.581  1.00 23.09           C  
ATOM    112  C   TRP A  17      -8.523 -23.371   4.716  1.00 22.63           C  
ATOM    113  O   TRP A  17      -8.938 -24.502   4.936  1.00 23.15           O  
ATOM    114  CB  TRP A  17      -6.139 -22.951   4.176  1.00 23.68           C  
ATOM    115  CG  TRP A  17      -5.050 -23.506   3.297  1.00 24.22           C  
ATOM    116  CD1 TRP A  17      -4.028 -22.820   2.726  1.00 26.00           C  
ATOM    117  CD2 TRP A  17      -4.890 -24.870   2.903  1.00 25.13           C  
ATOM    118  NE1 TRP A  17      -3.238 -23.674   1.991  1.00 26.16           N  
ATOM    119  CE2 TRP A  17      -3.751 -24.937   2.078  1.00 25.94           C  
ATOM    120  CE3 TRP A  17      -5.605 -26.040   3.162  1.00 24.99           C  
ATOM    121  CZ2 TRP A  17      -3.299 -26.139   1.519  1.00 26.42           C  
ATOM    122  CZ3 TRP A  17      -5.157 -27.235   2.603  1.00 26.24           C  
ATOM    123  CH2 TRP A  17      -4.012 -27.267   1.791  1.00 25.73           C  
ATOM    124  N   ASN A  18      -8.876 -22.318   5.436  1.00 22.38           N  
ATOM    125  CA  ASN A  18      -9.653 -22.472   6.667  1.00 22.89           C  
ATOM    126  C   ASN A  18     -11.128 -22.780   6.457  1.00 22.68           C  
ATOM    127  O   ASN A  18     -11.814 -23.171   7.414  1.00 22.86           O  
ATOM    128  CB  ASN A  18      -9.476 -21.247   7.565  1.00 23.32           C  
ATOM    129  CG  ASN A  18      -8.149 -21.271   8.320  1.00 24.01           C  
ATOM    130  OD1 ASN A  18      -7.543 -22.341   8.497  1.00 26.00           O  
ATOM    131  ND2 ASN A  18      -7.701 -20.110   8.778  1.00 24.33           N  
ATOM    132  N   ARG A  19     -11.613 -22.591   5.235  1.00 22.70           N  
ATOM    133  CA  ARG A  19     -12.928 -23.111   4.837  1.00 23.44           C  
ATOM    134  C   ARG A  19     -12.805 -24.334   3.918  1.00 23.32           C  
ATOM    135  O   ARG A  19     -13.798 -24.804   3.344  1.00 22.30           O  
ATOM    136  CB  ARG A  19     -13.797 -22.010   4.215  1.00 23.82           C  
ATOM    137  CG  ARG A  19     -13.279 -21.432   2.959  1.00 24.54           C  
ATOM    138  CD  ARG A  19     -14.314 -20.526   2.256  1.00 25.25           C  
ATOM    139  NE  ARG A  19     -13.771 -20.182   0.955  1.00 26.57           N  
ATOM    140  CZ  ARG A  19     -12.950 -19.167   0.719  1.00 26.12           C  
ATOM    141  NH1 ARG A  19     -12.628 -18.316   1.675  1.00 27.00           N  
ATOM    142  NH2 ARG A  19     -12.470 -18.993  -0.504  1.00 27.92           N  
ATOM    143  N   TRP A  20     -11.591 -24.870   3.823  1.00 23.81           N  
ATOM    144  CA  TRP A  20     -11.316 -26.115   3.104  1.00 24.01           C  
ATOM    145  C   TRP A  20     -11.678 -26.050   1.615  1.00 24.51           C  
ATOM    146  O   TRP A  20     -12.262 -26.994   1.063  1.00 24.33           O  
ATOM    147  CB  TRP A  20     -12.008 -27.283   3.821  1.00 24.48           C  
ATOM    148  CG  TRP A  20     -11.764 -27.202   5.289  1.00 24.12           C  
ATOM    149  CD1 TRP A  20     -10.561 -27.300   5.922  1.00 24.36           C  
ATOM    150  CD2 TRP A  20     -12.732 -26.943   6.308  1.00 24.35           C  
ATOM    151  NE1 TRP A  20     -10.722 -27.135   7.269  1.00 24.83           N  
ATOM    152  CE2 TRP A  20     -12.045 -26.909   7.536  1.00 24.71           C  
ATOM    153  CE3 TRP A  20     -14.113 -26.724   6.301  1.00 24.93           C  
ATOM    154  CZ2 TRP A  20     -12.692 -26.680   8.748  1.00 25.02           C  
ATOM    155  CZ3 TRP A  20     -14.754 -26.492   7.508  1.00 25.30           C  
ATOM    156  CH2 TRP A  20     -14.047 -26.482   8.714  1.00 25.13           C  
ATOM    157  N   ASP A  21     -11.290 -24.939   0.987  1.00 24.61           N  
ATOM    158  CA  ASP A  21     -11.599 -24.627  -0.407  1.00 24.84           C  
ATOM    159  C   ASP A  21     -10.304 -24.483  -1.207  1.00 24.84           C  
ATOM    160  O   ASP A  21      -9.747 -23.392  -1.295  1.00 24.78           O  
ATOM    161  CB  ASP A  21     -12.390 -23.317  -0.472  1.00 25.34           C  
ATOM    162  CG  ASP A  21     -12.633 -22.837  -1.903  1.00 26.20           C  
ATOM    163  OD1 ASP A  21     -12.525 -23.640  -2.851  1.00 29.18           O  
ATOM    164  OD2 ASP A  21     -12.941 -21.642  -2.071  1.00 30.91           O  
ATOM    165  N   LEU A  22      -9.818 -25.570  -1.792  1.00 24.93           N  
ATOM    166  CA  LEU A  22      -8.527 -25.508  -2.476  1.00 25.32           C  
ATOM    167  C   LEU A  22      -8.572 -24.596  -3.705  1.00 25.35           C  
ATOM    168  O   LEU A  22      -7.571 -23.979  -4.044  1.00 24.93           O  
ATOM    169  CB  LEU A  22      -8.020 -26.900  -2.849  1.00 25.56           C  
ATOM    170  CG  LEU A  22      -7.762 -27.868  -1.691  1.00 26.76           C  
ATOM    171  CD1 LEU A  22      -7.204 -29.179  -2.225  1.00 28.93           C  
ATOM    172  CD2 LEU A  22      -6.830 -27.256  -0.679  1.00 28.72           C  
ATOM    173  N   SER A  23      -9.731 -24.508  -4.358  1.00 25.33           N  
ATOM    174  CA  SER A  23      -9.885 -23.650  -5.537  0.50 25.60           C  
ATOM    176  C   SER A  23      -9.613 -22.184  -5.195  1.00 25.92           C  
ATOM    177  O   SER A  23      -9.090 -21.434  -6.022  1.00 25.89           O  
ATOM    178  CB  SER A  23     -11.292 -23.789  -6.147  0.50 25.59           C  
ATOM    180  OG  SER A  23     -12.244 -23.024  -5.423  0.50 24.24           O  
ATOM    182  N   GLY A  24      -9.963 -21.782  -3.971  1.00 26.01           N  
ATOM    183  CA  GLY A  24      -9.754 -20.417  -3.476  1.00 26.42           C  
ATOM    184  C   GLY A  24      -8.307 -20.063  -3.194  1.00 26.59           C  
ATOM    185  O   GLY A  24      -7.970 -18.894  -3.018  1.00 26.74           O  
ATOM    186  N   ILE A  25      -7.446 -21.078  -3.139  1.00 26.80           N  
ATOM    187  CA  ILE A  25      -6.014 -20.866  -3.031  1.00 26.64           C  
ATOM    188  C   ILE A  25      -5.416 -20.792  -4.438  1.00 26.51           C  
ATOM    189  O   ILE A  25      -4.744 -19.823  -4.794  1.00 26.25           O  
ATOM    190  CB  ILE A  25      -5.346 -22.026  -2.256  1.00 26.68           C  
ATOM    191  CG1 ILE A  25      -5.961 -22.165  -0.859  1.00 27.64           C  
ATOM    192  CG2 ILE A  25      -3.838 -21.840  -2.176  1.00 27.42           C  
ATOM    193  CD1 ILE A  25      -5.767 -23.506  -0.271  1.00 27.95           C  
ATOM    194  N   ILE A  26      -5.683 -21.811  -5.249  1.00 26.23           N  
ATOM    195  CA  ILE A  26      -5.031 -21.954  -6.547  0.50 26.39           C  
ATOM    197  C   ILE A  26      -5.440 -20.837  -7.527  1.00 26.53           C  
ATOM    198  O   ILE A  26      -4.713 -20.528  -8.477  1.00 26.06           O  
ATOM    199  CB  ILE A  26      -5.278 -23.384  -7.114  0.50 26.36           C  
ATOM    201  CG1 ILE A  26      -4.549 -24.410  -6.231  0.50 26.50           C  
ATOM    203  CG2 ILE A  26      -4.813 -23.503  -8.555  0.50 26.20           C  
ATOM    205  CD1 ILE A  26      -5.103 -25.814  -6.299  0.50 26.70           C  
ATOM    207  N   LYS A  27      -6.593 -20.218  -7.289  1.00 26.51           N  
ATOM    208  CA  LYS A  27      -7.039 -19.118  -8.162  1.00 27.20           C  
ATOM    209  C   LYS A  27      -6.080 -17.923  -8.134  1.00 27.02           C  
ATOM    210  O   LYS A  27      -6.105 -17.084  -9.033  1.00 27.04           O  
ATOM    211  CB  LYS A  27      -8.449 -18.658  -7.787  1.00 27.43           C  
ATOM    212  CG  LYS A  27      -8.561 -17.996  -6.445  1.00 29.03           C  
ATOM    213  CD  LYS A  27     -10.007 -17.709  -6.081  1.00 29.89           C  
ATOM    214  CE  LYS A  27     -10.544 -16.504  -6.799  1.00 32.85           C  
ATOM    215  NZ  LYS A  27     -11.851 -16.075  -6.213  1.00 34.42           N  
ATOM    216  N   HIS A  28      -5.249 -17.847  -7.098  1.00 26.67           N  
ATOM    217  CA  HIS A  28      -4.290 -16.752  -6.951  1.00 27.00           C  
ATOM    218  C   HIS A  28      -2.923 -17.083  -7.527  1.00 26.94           C  
ATOM    219  O   HIS A  28      -2.029 -16.231  -7.540  1.00 26.54           O  
ATOM    220  CB  HIS A  28      -4.154 -16.387  -5.480  1.00 27.62           C  
ATOM    221  CG  HIS A  28      -5.402 -15.819  -4.893  1.00 29.56           C  
ATOM    222  ND1 HIS A  28      -5.908 -14.594  -5.274  1.00 32.16           N  
ATOM    223  CD2 HIS A  28      -6.269 -16.319  -3.979  1.00 30.60           C  
ATOM    224  CE1 HIS A  28      -7.017 -14.351  -4.596  1.00 33.21           C  
ATOM    225  NE2 HIS A  28      -7.262 -15.385  -3.811  1.00 31.42           N  
ATOM    226  N   TRP A  29      -2.756 -18.315  -8.004  1.00 26.17           N  
ATOM    227  CA  TRP A  29      -1.490 -18.730  -8.592  1.00 26.52           C  
ATOM    228  C   TRP A  29      -1.389 -18.256 -10.019  1.00 26.42           C  
ATOM    229  O   TRP A  29      -2.351 -18.364 -10.787  1.00 26.12           O  
ATOM    230  CB  TRP A  29      -1.379 -20.248  -8.606  1.00 26.02           C  
ATOM    231  CG  TRP A  29      -1.247 -20.900  -7.294  1.00 25.70           C  
ATOM    232  CD1 TRP A  29      -1.265 -20.320  -6.070  1.00 25.63           C  
ATOM    233  CD2 TRP A  29      -1.108 -22.302  -7.076  1.00 26.58           C  
ATOM    234  NE1 TRP A  29      -1.121 -21.274  -5.091  1.00 25.76           N  
ATOM    235  CE2 TRP A  29      -1.027 -22.505  -5.688  1.00 26.10           C  
ATOM    236  CE3 TRP A  29      -1.028 -23.408  -7.928  1.00 25.98           C  
ATOM    237  CZ2 TRP A  29      -0.874 -23.779  -5.127  1.00 26.15           C  
ATOM    238  CZ3 TRP A  29      -0.880 -24.672  -7.367  1.00 25.92           C  
ATOM    239  CH2 TRP A  29      -0.808 -24.846  -5.985  1.00 25.40           C  
ATOM    240  N   SER A  30      -0.221 -17.758 -10.396  1.00 26.71           N  
ATOM    241  CA  SER A  30       0.064 -17.530 -11.804  1.00 27.58           C  
ATOM    242  C   SER A  30       0.091 -18.870 -12.547  1.00 28.18           C  
ATOM    243  O   SER A  30       0.463 -19.895 -11.972  1.00 28.26           O  
ATOM    244  CB  SER A  30       1.414 -16.838 -11.979  1.00 27.42           C  
ATOM    245  OG  SER A  30       1.842 -16.880 -13.328  1.00 28.60           O  
ATOM    246  N   PRO A  31      -0.282 -18.867 -13.835  1.00 28.82           N  
ATOM    247  CA  PRO A  31      -0.028 -20.043 -14.674  1.00 29.21           C  
ATOM    248  C   PRO A  31       1.441 -20.473 -14.686  1.00 29.46           C  
ATOM    249  O   PRO A  31       1.732 -21.646 -14.912  1.00 30.03           O  
ATOM    250  CB  PRO A  31      -0.434 -19.574 -16.073  1.00 29.58           C  
ATOM    251  CG  PRO A  31      -1.371 -18.450 -15.847  1.00 29.37           C  
ATOM    252  CD  PRO A  31      -0.962 -17.791 -14.575  1.00 29.16           C  
ATOM    253  N   ASP A  32       2.352 -19.532 -14.450  1.00 29.50           N  
ATOM    254  CA  ASP A  32       3.789 -19.809 -14.500  1.00 29.38           C  
ATOM    255  C   ASP A  32       4.428 -19.961 -13.125  1.00 28.75           C  
ATOM    256  O   ASP A  32       5.654 -19.888 -12.989  1.00 28.68           O  
ATOM    257  CB  ASP A  32       4.494 -18.693 -15.266  1.00 30.51           C  
ATOM    258  CG  ASP A  32       3.913 -18.484 -16.649  1.00 33.05           C  
ATOM    259  OD1 ASP A  32       3.815 -19.472 -17.413  1.00 37.55           O  
ATOM    260  OD2 ASP A  32       3.550 -17.334 -16.970  1.00 36.97           O  
ATOM    261  N   ILE A  33       3.603 -20.185 -12.108  1.00 27.45           N  
ATOM    262  CA  ILE A  33       4.085 -20.334 -10.750  1.00 26.86           C  
ATOM    263  C   ILE A  33       5.109 -21.464 -10.617  1.00 26.46           C  
ATOM    264  O   ILE A  33       4.991 -22.522 -11.261  1.00 25.85           O  
ATOM    265  CB  ILE A  33       2.914 -20.567  -9.758  1.00 26.47           C  
ATOM    266  CG1 ILE A  33       3.403 -20.462  -8.311  1.00 25.92           C  
ATOM    267  CG2 ILE A  33       2.237 -21.920 -10.011  1.00 26.74           C  
ATOM    268  CD1 ILE A  33       2.278 -20.395  -7.306  1.00 26.37           C  
ATOM    269  N   VAL A  34       6.140 -21.208  -9.816  1.00 26.11           N  
ATOM    270  CA  VAL A  34       7.099 -22.232  -9.415  1.00 26.23           C  
ATOM    271  C   VAL A  34       7.043 -22.409  -7.899  1.00 25.87           C  
ATOM    272  O   VAL A  34       7.015 -21.430  -7.140  1.00 25.53           O  
ATOM    273  CB  VAL A  34       8.534 -21.862  -9.844  1.00 26.40           C  
ATOM    274  CG1 VAL A  34       9.510 -22.966  -9.469  1.00 26.94           C  
ATOM    275  CG2 VAL A  34       8.580 -21.605 -11.322  1.00 26.99           C  
ATOM    276  N   HIS A  35       7.006 -23.661  -7.465  1.00 25.63           N  
ATOM    277  CA  HIS A  35       7.003 -24.002  -6.053  1.00 25.99           C  
ATOM    278  C   HIS A  35       8.340 -24.612  -5.672  1.00 25.89           C  
ATOM    279  O   HIS A  35       8.868 -25.457  -6.401  1.00 25.29           O  
ATOM    280  CB  HIS A  35       5.914 -25.022  -5.738  1.00 26.12           C  
ATOM    281  CG  HIS A  35       4.557 -24.652  -6.247  1.00 26.76           C  
ATOM    282  ND1 HIS A  35       3.674 -23.883  -5.522  1.00 28.65           N  
ATOM    283  CD2 HIS A  35       3.914 -24.989  -7.387  1.00 28.91           C  
ATOM    284  CE1 HIS A  35       2.555 -23.742  -6.205  1.00 28.50           C  
ATOM    285  NE2 HIS A  35       2.673 -24.405  -7.340  1.00 28.67           N  
ATOM    286  N   TYR A  36       8.870 -24.202  -4.526  1.00 25.83           N  
ATOM    287  CA  TYR A  36      10.103 -24.756  -3.992  1.00 26.43           C  
ATOM    288  C   TYR A  36       9.899 -25.270  -2.573  1.00 26.44           C  
ATOM    289  O   TYR A  36       9.198 -24.654  -1.762  1.00 26.60           O  
ATOM    290  CB  TYR A  36      11.216 -23.707  -3.963  1.00 27.33           C  
ATOM    291  CG  TYR A  36      11.372 -22.893  -5.223  1.00 27.46           C  
ATOM    292  CD1 TYR A  36      10.678 -21.703  -5.385  1.00 28.84           C  
ATOM    293  CD2 TYR A  36      12.232 -23.288  -6.233  1.00 28.87           C  
ATOM    294  CE1 TYR A  36      10.818 -20.937  -6.524  1.00 28.91           C  
ATOM    295  CE2 TYR A  36      12.380 -22.522  -7.381  1.00 28.59           C  
ATOM    296  CZ  TYR A  36      11.675 -21.339  -7.508  1.00 28.25           C  
ATOM    297  OH  TYR A  36      11.806 -20.564  -8.640  1.00 29.84           O  
ATOM    298  N   SER A  37      10.537 -26.394  -2.274  1.00 26.36           N  
ATOM    299  CA  SER A  37      10.581 -26.933  -0.928  1.00 26.82           C  
ATOM    300  C   SER A  37      11.914 -27.650  -0.734  1.00 26.87           C  
ATOM    301  O   SER A  37      12.314 -28.456  -1.577  1.00 26.60           O  
ATOM    302  CB  SER A  37       9.407 -27.890  -0.717  1.00 27.11           C  
ATOM    303  OG  SER A  37       9.393 -28.367   0.615  1.00 29.28           O  
ATOM    304  N   GLU A  38      12.605 -27.333   0.358  1.00 27.27           N  
ATOM    305  CA  GLU A  38      13.935 -27.866   0.641  1.00 27.88           C  
ATOM    306  C   GLU A  38      14.909 -27.597  -0.514  1.00 28.13           C  
ATOM    307  O   GLU A  38      15.744 -28.436  -0.852  1.00 28.41           O  
ATOM    308  CB  GLU A  38      13.856 -29.360   0.990  1.00 27.55           C  
ATOM    309  CG  GLU A  38      12.881 -29.651   2.126  1.00 27.65           C  
ATOM    310  CD  GLU A  38      12.917 -31.094   2.600  1.00 28.82           C  
ATOM    311  OE1 GLU A  38      13.653 -31.899   1.996  1.00 30.18           O  
ATOM    312  OE2 GLU A  38      12.214 -31.412   3.583  1.00 28.43           O  
ATOM    313  N   ASP A  39      14.785 -26.405  -1.099  1.00 28.73           N  
ATOM    314  CA  ASP A  39      15.634 -25.924  -2.202  1.00 29.26           C  
ATOM    315  C   ASP A  39      15.524 -26.725  -3.504  1.00 29.52           C  
ATOM    316  O   ASP A  39      16.383 -26.608  -4.370  1.00 30.00           O  
ATOM    317  CB  ASP A  39      17.107 -25.803  -1.759  1.00 29.44           C  
ATOM    318  CG  ASP A  39      17.290 -24.845  -0.590  1.00 30.52           C  
ATOM    319  OD1 ASP A  39      16.423 -23.964  -0.396  1.00 31.71           O  
ATOM    320  OD2 ASP A  39      18.290 -24.978   0.147  1.00 30.87           O  
ATOM    321  N   ASN A  40      14.457 -27.510  -3.645  1.00 29.84           N  
ATOM    322  CA  ASN A  40      14.158 -28.229  -4.881  1.00 29.84           C  
ATOM    323  C   ASN A  40      12.795 -27.795  -5.377  1.00 29.66           C  
ATOM    324  O   ASN A  40      11.911 -27.530  -4.566  1.00 29.07           O  
ATOM    325  CB  ASN A  40      14.097 -29.735  -4.633  1.00 30.58           C  
ATOM    326  CG  ASN A  40      15.401 -30.303  -4.128  1.00 32.41           C  
ATOM    327  OD1 ASN A  40      16.445 -30.144  -4.755  1.00 36.09           O  
ATOM    328  ND2 ASN A  40      15.345 -30.983  -2.988  1.00 34.62           N  
ATOM    329  N   GLU A  41      12.609 -27.751  -6.694  1.00 29.48           N  
ATOM    330  CA  GLU A  41      11.307 -27.399  -7.263  0.50 29.49           C  
ATOM    332  C   GLU A  41      10.329 -28.550  -7.075  1.00 29.59           C  
ATOM    333  O   GLU A  41      10.711 -29.724  -7.164  1.00 29.29           O  
ATOM    334  CB  GLU A  41      11.396 -27.053  -8.758  0.50 29.58           C  
ATOM    336  CG  GLU A  41      10.037 -26.652  -9.364  0.50 29.39           C  
ATOM    338  CD  GLU A  41      10.072 -26.344 -10.854  0.50 29.49           C  
ATOM    340  OE1 GLU A  41      11.174 -26.234 -11.432  0.50 30.46           O  
ATOM    342  OE2 GLU A  41       8.979 -26.206 -11.448  0.50 26.54           O  
ATOM    344  N   VAL A  42       9.075 -28.200  -6.820  1.00 29.34           N  
ATOM    345  CA  VAL A  42       7.975 -29.141  -6.721  1.00 29.41           C  
ATOM    346  C   VAL A  42       6.967 -28.754  -7.799  1.00 29.29           C  
ATOM    347  O   VAL A  42       6.557 -27.592  -7.886  1.00 29.17           O  
ATOM    348  CB  VAL A  42       7.315 -29.057  -5.331  1.00 29.44           C  
ATOM    349  CG1 VAL A  42       6.105 -29.984  -5.237  1.00 29.51           C  
ATOM    350  CG2 VAL A  42       8.331 -29.392  -4.252  1.00 30.15           C  
ATOM    351  N   SER A  43       6.560 -29.710  -8.627  1.00 29.15           N  
ATOM    352  CA  SER A  43       5.603 -29.409  -9.696  1.00 29.01           C  
ATOM    353  C   SER A  43       4.261 -28.970  -9.108  1.00 28.97           C  
ATOM    354  O   SER A  43       3.893 -29.388  -8.015  1.00 28.50           O  
ATOM    355  CB  SER A  43       5.402 -30.621 -10.613  1.00 29.37           C  
ATOM    356  OG  SER A  43       4.668 -31.629  -9.949  1.00 29.12           O  
ATOM    357  N   SER A  44       3.535 -28.125  -9.833  1.00 29.09           N  
ATOM    358  CA  SER A  44       2.202 -27.709  -9.400  1.00 29.44           C  
ATOM    359  C   SER A  44       1.281 -28.921  -9.261  1.00 29.60           C  
ATOM    360  O   SER A  44       0.463 -28.982  -8.347  1.00 29.17           O  
ATOM    361  CB  SER A  44       1.596 -26.700 -10.375  1.00 29.60           C  
ATOM    362  OG  SER A  44       2.183 -25.422 -10.219  1.00 29.66           O  
ATOM    363  N   ALA A  45       1.436 -29.885 -10.166  1.00 29.89           N  
ATOM    364  CA  ALA A  45       0.677 -31.137 -10.110  1.00 30.04           C  
ATOM    365  C   ALA A  45       0.899 -31.851  -8.783  1.00 30.33           C  
ATOM    366  O   ALA A  45      -0.055 -32.279  -8.134  1.00 30.52           O  
ATOM    367  CB  ALA A  45       1.058 -32.040 -11.265  1.00 30.39           C  
ATOM    368  N   ASP A  46       2.159 -31.959  -8.368  1.00 30.06           N  
ATOM    369  CA  ASP A  46       2.489 -32.624  -7.114  1.00 29.95           C  
ATOM    370  C   ASP A  46       2.028 -31.794  -5.916  1.00 29.79           C  
ATOM    371  O   ASP A  46       1.563 -32.344  -4.921  1.00 29.16           O  
ATOM    372  CB  ASP A  46       3.993 -32.903  -7.025  1.00 29.94           C  
ATOM    373  CG  ASP A  46       4.440 -34.028  -7.962  1.00 31.05           C  
ATOM    374  OD1 ASP A  46       3.594 -34.600  -8.680  1.00 33.49           O  
ATOM    375  OD2 ASP A  46       5.644 -34.339  -7.980  1.00 32.87           O  
ATOM    376  N   MET A  47       2.153 -30.474  -6.022  1.00 30.02           N  
ATOM    377  CA  MET A  47       1.721 -29.584  -4.949  1.00 29.97           C  
ATOM    378  C   MET A  47       0.224 -29.748  -4.687  1.00 29.68           C  
ATOM    379  O   MET A  47      -0.199 -29.924  -3.542  1.00 29.46           O  
ATOM    380  CB  MET A  47       2.037 -28.135  -5.314  1.00 30.33           C  
ATOM    381  CG  MET A  47       1.773 -27.134  -4.196  1.00 31.79           C  
ATOM    382  SD  MET A  47       2.675 -27.460  -2.663  1.00 37.44           S  
ATOM    383  CE  MET A  47       4.310 -27.800  -3.286  1.00 36.23           C  
ATOM    384  N   VAL A  48      -0.575 -29.705  -5.746  1.00 29.38           N  
ATOM    385  CA  VAL A  48      -2.021 -29.859  -5.595  1.00 29.65           C  
ATOM    386  C   VAL A  48      -2.367 -31.227  -4.995  1.00 29.35           C  
ATOM    387  O   VAL A  48      -3.239 -31.318  -4.145  1.00 29.09           O  
ATOM    388  CB  VAL A  48      -2.774 -29.615  -6.926  1.00 29.85           C  
ATOM    389  CG1 VAL A  48      -4.255 -29.975  -6.787  1.00 30.63           C  
ATOM    390  CG2 VAL A  48      -2.628 -28.154  -7.345  1.00 30.12           C  
ATOM    391  N   LYS A  49      -1.670 -32.280  -5.421  1.00 29.32           N  
ATOM    392  CA  LYS A  49      -1.878 -33.609  -4.842  1.00 29.66           C  
ATOM    393  C   LYS A  49      -1.597 -33.649  -3.345  1.00 29.05           C  
ATOM    394  O   LYS A  49      -2.318 -34.316  -2.604  1.00 28.53           O  
ATOM    395  CB  LYS A  49      -1.025 -34.665  -5.552  1.00 30.21           C  
ATOM    396  CG  LYS A  49      -1.507 -34.958  -6.944  1.00 31.22           C  
ATOM    397  CD  LYS A  49      -0.628 -35.973  -7.655  1.00 31.62           C  
ATOM    398  CE  LYS A  49      -0.950 -36.023  -9.135  1.00 32.56           C  
ATOM    399  NZ  LYS A  49      -0.169 -37.086  -9.825  1.00 33.93           N  
ATOM    400  N   LEU A  50      -0.552 -32.949  -2.907  1.00 28.54           N  
ATOM    401  CA  LEU A  50      -0.207 -32.893  -1.486  1.00 28.78           C  
ATOM    402  C   LEU A  50      -1.264 -32.120  -0.723  1.00 28.34           C  
ATOM    403  O   LEU A  50      -1.590 -32.455   0.415  1.00 27.91           O  
ATOM    404  CB  LEU A  50       1.150 -32.220  -1.277  1.00 29.14           C  
ATOM    405  CG  LEU A  50       2.369 -33.019  -1.735  1.00 31.00           C  
ATOM    406  CD1 LEU A  50       3.591 -32.117  -1.736  1.00 32.13           C  
ATOM    407  CD2 LEU A  50       2.581 -34.231  -0.836  1.00 32.82           C  
ATOM    408  N   MET A  51      -1.786 -31.071  -1.355  1.00 27.97           N  
ATOM    409  CA  MET A  51      -2.833 -30.260  -0.742  1.00 28.01           C  
ATOM    410  C   MET A  51      -4.105 -31.091  -0.574  1.00 27.54           C  
ATOM    411  O   MET A  51      -4.707 -31.094   0.499  1.00 26.96           O  
ATOM    412  CB  MET A  51      -3.102 -29.010  -1.587  1.00 27.63           C  
ATOM    413  CG  MET A  51      -1.927 -28.040  -1.601  1.00 28.12           C  
ATOM    414  SD  MET A  51      -2.031 -26.788  -2.898  1.00 29.03           S  
ATOM    415  CE  MET A  51      -3.357 -25.766  -2.270  1.00 30.92           C  
ATOM    416  N   GLU A  52      -4.496 -31.801  -1.633  1.00 27.99           N  
ATOM    417  CA  GLU A  52      -5.680 -32.669  -1.602  1.00 28.49           C  
ATOM    418  C   GLU A  52      -5.535 -33.783  -0.564  1.00 28.37           C  
ATOM    419  O   GLU A  52      -6.464 -34.060   0.199  1.00 27.72           O  
ATOM    420  CB  GLU A  52      -5.938 -33.287  -2.986  1.00 28.77           C  
ATOM    421  CG  GLU A  52      -6.415 -32.272  -4.027  1.00 30.25           C  
ATOM    422  CD  GLU A  52      -6.540 -32.852  -5.426  1.00 31.53           C  
ATOM    423  OE1 GLU A  52      -5.761 -33.764  -5.788  1.00 37.23           O  
ATOM    424  OE2 GLU A  52      -7.431 -32.392  -6.176  1.00 36.91           O  
ATOM    425  N   GLY A  53      -4.374 -34.433  -0.557  1.00 28.37           N  
ATOM    426  CA  GLY A  53      -4.112 -35.533   0.376  1.00 28.41           C  
ATOM    427  C   GLY A  53      -4.074 -35.053   1.814  1.00 28.37           C  
ATOM    428  O   GLY A  53      -4.561 -35.734   2.719  1.00 28.24           O  
ATOM    429  N   GLY A  54      -3.494 -33.874   2.022  1.00 28.30           N  
ATOM    430  CA  GLY A  54      -3.434 -33.267   3.344  1.00 28.46           C  
ATOM    431  C   GLY A  54      -4.813 -32.940   3.881  1.00 28.42           C  
ATOM    432  O   GLY A  54      -5.124 -33.221   5.039  1.00 28.40           O  
ATOM    433  N   LEU A  55      -5.651 -32.365   3.028  1.00 28.60           N  
ATOM    434  CA  LEU A  55      -7.019 -32.034   3.409  1.00 28.73           C  
ATOM    435  C   LEU A  55      -7.846 -33.280   3.727  1.00 28.76           C  
ATOM    436  O   LEU A  55      -8.667 -33.270   4.644  1.00 29.37           O  
ATOM    437  CB  LEU A  55      -7.682 -31.218   2.295  1.00 29.15           C  
ATOM    438  CG  LEU A  55      -8.927 -30.393   2.618  1.00 29.51           C  
ATOM    439  CD1 LEU A  55      -8.795 -29.635   3.921  1.00 30.12           C  
ATOM    440  CD2 LEU A  55      -9.190 -29.428   1.459  1.00 29.55           C  
ATOM    441  N   LYS A  56      -7.630 -34.360   2.984  1.00 28.39           N  
ATOM    442  CA  LYS A  56      -8.329 -35.618   3.259  1.00 28.22           C  
ATOM    443  C   LYS A  56      -7.946 -36.210   4.623  1.00 27.66           C  
ATOM    444  O   LYS A  56      -8.801 -36.696   5.362  1.00 26.69           O  
ATOM    445  CB  LYS A  56      -8.035 -36.640   2.161  1.00 28.76           C  
ATOM    446  CG  LYS A  56      -8.897 -37.872   2.249  1.00 29.46           C  
ATOM    447  CD  LYS A  56      -8.458 -38.970   1.281  1.00 30.36           C  
ATOM    448  CE  LYS A  56      -9.022 -40.325   1.700  1.00 31.85           C  
ATOM    449  NZ  LYS A  56      -8.467 -40.798   3.023  1.00 33.20           N  
ATOM    450  N   ALA A  57      -6.659 -36.159   4.949  1.00 26.83           N  
ATOM    451  CA  ALA A  57      -6.147 -36.725   6.197  1.00 26.59           C  
ATOM    452  C   ALA A  57      -6.560 -35.880   7.404  1.00 26.14           C  
ATOM    453  O   ALA A  57      -6.850 -36.423   8.481  1.00 25.98           O  
ATOM    454  CB  ALA A  57      -4.641 -36.841   6.134  1.00 26.59           C  
ATOM    455  N   PHE A  58      -6.590 -34.561   7.194  1.00 25.52           N  
ATOM    456  CA  PHE A  58      -6.861 -33.570   8.237  1.00 25.17           C  
ATOM    457  C   PHE A  58      -8.006 -32.630   7.817  1.00 24.72           C  
ATOM    458  O   PHE A  58      -7.795 -31.430   7.611  1.00 24.38           O  
ATOM    459  CB  PHE A  58      -5.579 -32.795   8.516  1.00 25.09           C  
ATOM    460  CG  PHE A  58      -4.409 -33.685   8.824  1.00 25.13           C  
ATOM    461  CD1 PHE A  58      -4.367 -34.392  10.015  1.00 24.78           C  
ATOM    462  CD2 PHE A  58      -3.377 -33.856   7.906  1.00 25.74           C  
ATOM    463  CE1 PHE A  58      -3.306 -35.235  10.305  1.00 24.72           C  
ATOM    464  CE2 PHE A  58      -2.304 -34.697   8.195  1.00 25.62           C  
ATOM    465  CZ  PHE A  58      -2.277 -35.390   9.393  1.00 24.69           C  
ATOM    466  N   PRO A  59      -9.229 -33.176   7.713  1.00 24.75           N  
ATOM    467  CA  PRO A  59     -10.369 -32.462   7.108  1.00 24.76           C  
ATOM    468  C   PRO A  59     -10.855 -31.225   7.861  1.00 24.73           C  
ATOM    469  O   PRO A  59     -11.602 -30.419   7.294  1.00 24.83           O  
ATOM    470  CB  PRO A  59     -11.465 -33.524   7.076  1.00 24.92           C  
ATOM    471  CG  PRO A  59     -11.113 -34.483   8.134  1.00 25.20           C  
ATOM    472  CD  PRO A  59      -9.615 -34.533   8.146  1.00 24.84           C  
ATOM    473  N   ASP A  60     -10.447 -31.089   9.120  1.00 24.14           N  
ATOM    474  CA  ASP A  60     -10.847 -29.966   9.958  1.00 24.33           C  
ATOM    475  C   ASP A  60      -9.684 -29.019  10.232  1.00 23.91           C  
ATOM    476  O   ASP A  60      -9.725 -28.226  11.177  1.00 23.63           O  
ATOM    477  CB  ASP A  60     -11.426 -30.485  11.276  1.00 24.49           C  
ATOM    478  CG  ASP A  60     -10.441 -31.324  12.076  1.00 25.78           C  
ATOM    479  OD1 ASP A  60      -9.283 -31.535  11.644  1.00 25.53           O  
ATOM    480  OD2 ASP A  60     -10.839 -31.789  13.156  1.00 29.42           O  
ATOM    481  N   LEU A  61      -8.642 -29.087   9.413  1.00 23.64           N  
ATOM    482  CA  LEU A  61      -7.431 -28.338   9.718  1.00 23.76           C  
ATOM    483  C   LEU A  61      -7.710 -26.838   9.771  1.00 23.71           C  
ATOM    484  O   LEU A  61      -8.613 -26.328   9.089  1.00 23.41           O  
ATOM    485  CB  LEU A  61      -6.302 -28.657   8.736  1.00 23.63           C  
ATOM    486  CG  LEU A  61      -6.498 -28.261   7.271  1.00 24.49           C  
ATOM    487  CD1 LEU A  61      -6.127 -26.796   7.028  1.00 25.07           C  
ATOM    488  CD2 LEU A  61      -5.670 -29.182   6.371  1.00 24.14           C  
ATOM    489  N   GLN A  62      -6.956 -26.148  10.616  1.00 23.60           N  
ATOM    490  CA  GLN A  62      -7.046 -24.696  10.742  1.00 24.00           C  
ATOM    491  C   GLN A  62      -5.649 -24.108  10.765  1.00 24.58           C  
ATOM    492  O   GLN A  62      -4.756 -24.649  11.424  1.00 24.86           O  
ATOM    493  CB  GLN A  62      -7.800 -24.314  12.026  1.00 24.01           C  
ATOM    494  CG  GLN A  62      -9.280 -24.614  11.978  1.00 23.99           C  
ATOM    495  CD  GLN A  62     -10.021 -23.660  11.064  1.00 24.93           C  
ATOM    496  OE1 GLN A  62     -10.209 -22.487  11.402  1.00 24.12           O  
ATOM    497  NE2 GLN A  62     -10.437 -24.154   9.893  1.00 22.30           N  
ATOM    498  N   LEU A  63      -5.468 -23.023  10.019  1.00 24.74           N  
ATOM    499  CA  LEU A  63      -4.214 -22.279   9.981  1.00 25.36           C  
ATOM    500  C   LEU A  63      -4.329 -21.069  10.875  1.00 25.89           C  
ATOM    501  O   LEU A  63      -5.255 -20.269  10.712  1.00 25.37           O  
ATOM    502  CB  LEU A  63      -3.911 -21.789   8.568  1.00 25.22           C  
ATOM    503  CG  LEU A  63      -3.319 -22.789   7.582  1.00 25.76           C  
ATOM    504  CD1 LEU A  63      -4.208 -23.987   7.413  1.00 27.60           C  
ATOM    505  CD2 LEU A  63      -3.087 -22.094   6.256  1.00 26.66           C  
ATOM    506  N   GLU A  64      -3.390 -20.928  11.802  1.00 26.29           N  
ATOM    507  CA  GLU A  64      -3.284 -19.715  12.595  1.00 27.00           C  
ATOM    508  C   GLU A  64      -2.057 -18.946  12.137  1.00 26.82           C  
ATOM    509  O   GLU A  64      -0.939 -19.466  12.187  1.00 25.67           O  
ATOM    510  CB  GLU A  64      -3.156 -20.018  14.082  1.00 27.59           C  
ATOM    511  CG  GLU A  64      -3.097 -18.740  14.914  1.00 28.14           C  
ATOM    512  CD  GLU A  64      -2.803 -18.967  16.380  1.00 30.76           C  
ATOM    513  OE1 GLU A  64      -2.619 -20.130  16.796  1.00 35.88           O  
ATOM    514  OE2 GLU A  64      -2.733 -17.957  17.121  1.00 36.64           O  
ATOM    515  N   VAL A  65      -2.267 -17.711  11.685  1.00 26.53           N  
ATOM    516  CA  VAL A  65      -1.151 -16.865  11.269  1.00 26.26           C  
ATOM    517  C   VAL A  65      -0.524 -16.239  12.517  1.00 26.03           C  
ATOM    518  O   VAL A  65      -1.131 -15.404  13.201  1.00 25.59           O  
ATOM    519  CB  VAL A  65      -1.592 -15.794  10.241  1.00 26.05           C  
ATOM    520  CG1 VAL A  65      -0.421 -14.898   9.857  1.00 26.84           C  
ATOM    521  CG2 VAL A  65      -2.204 -16.478   9.016  1.00 26.89           C  
ATOM    522  N   LYS A  66       0.681 -16.682  12.837  1.00 25.97           N  
ATOM    523  CA  LYS A  66       1.412 -16.162  13.991  1.00 26.34           C  
ATOM    524  C   LYS A  66       2.112 -14.853  13.656  1.00 26.40           C  
ATOM    525  O   LYS A  66       2.280 -13.972  14.518  1.00 26.78           O  
ATOM    526  CB  LYS A  66       2.443 -17.184  14.468  1.00 26.64           C  
ATOM    527  CG  LYS A  66       1.880 -18.561  14.823  1.00 28.37           C  
ATOM    528  CD  LYS A  66       0.809 -18.524  15.899  1.00 30.58           C  
ATOM    529  CE  LYS A  66       1.330 -18.078  17.236  1.00 32.66           C  
ATOM    530  NZ  LYS A  66       0.302 -18.272  18.328  1.00 33.69           N  
ATOM    531  N   SER A  67       2.572 -14.741  12.418  1.00 26.00           N  
ATOM    532  CA  SER A  67       3.189 -13.508  11.954  0.50 25.92           C  
ATOM    534  C   SER A  67       3.083 -13.406  10.441  1.00 26.01           C  
ATOM    535  O   SER A  67       3.043 -14.408   9.740  1.00 25.45           O  
ATOM    536  CB  SER A  67       4.663 -13.426  12.385  0.50 25.80           C  
ATOM    538  OG  SER A  67       5.511 -14.108  11.474  0.50 23.73           O  
ATOM    540  N   ILE A  68       3.017 -12.170   9.961  1.00 26.30           N  
ATOM    541  CA  ILE A  68       2.994 -11.886   8.532  1.00 26.65           C  
ATOM    542  C   ILE A  68       3.930 -10.699   8.279  1.00 27.37           C  
ATOM    543  O   ILE A  68       4.014  -9.777   9.093  1.00 27.94           O  
ATOM    544  CB  ILE A  68       1.545 -11.676   7.997  1.00 26.62           C  
ATOM    545  CG1 ILE A  68       1.559 -11.468   6.488  1.00 26.40           C  
ATOM    546  CG2 ILE A  68       0.820 -10.518   8.706  1.00 28.04           C  
ATOM    547  CD1 ILE A  68       0.195 -11.666   5.844  1.00 27.48           C  
ATOM    548  N   MET A  69       4.684 -10.773   7.190  1.00 26.96           N  
ATOM    549  CA  MET A  69       5.670  -9.767   6.872  1.00 27.42           C  
ATOM    550  C   MET A  69       5.661  -9.577   5.375  1.00 26.36           C  
ATOM    551  O   MET A  69       5.412 -10.525   4.645  1.00 25.56           O  
ATOM    552  CB  MET A  69       7.043 -10.254   7.328  1.00 27.52           C  
ATOM    553  CG  MET A  69       8.155  -9.264   7.181  1.00 29.29           C  
ATOM    554  SD  MET A  69       9.725  -9.953   7.760  1.00 33.54           S  
ATOM    555  CE  MET A  69       9.241 -10.522   9.394  1.00 32.42           C  
ATOM    556  N   ALA A  70       5.914  -8.351   4.927  1.00 25.71           N  
ATOM    557  CA  ALA A  70       5.979  -8.049   3.504  1.00 25.69           C  
ATOM    558  C   ALA A  70       7.105  -7.068   3.214  1.00 25.62           C  
ATOM    559  O   ALA A  70       7.351  -6.141   3.995  1.00 24.96           O  
ATOM    560  CB  ALA A  70       4.666  -7.488   3.027  1.00 25.78           C  
ATOM    561  N   GLU A  71       7.784  -7.293   2.093  1.00 25.37           N  
ATOM    562  CA  GLU A  71       8.809  -6.383   1.594  1.00 25.85           C  
ATOM    563  C   GLU A  71       8.895  -6.573   0.090  1.00 25.61           C  
ATOM    564  O   GLU A  71       8.806  -7.702  -0.405  1.00 24.74           O  
ATOM    565  CB  GLU A  71      10.169  -6.653   2.243  1.00 25.92           C  
ATOM    566  CG  GLU A  71      11.196  -5.525   2.028  1.00 26.63           C  
ATOM    567  CD  GLU A  71      12.546  -5.772   2.710  1.00 27.97           C  
ATOM    568  OE1 GLU A  71      12.838  -6.916   3.069  1.00 28.16           O  
ATOM    569  OE2 GLU A  71      13.323  -4.802   2.891  1.00 32.87           O  
ATOM    570  N   GLU A  72       9.068  -5.467  -0.627  1.00 25.95           N  
ATOM    571  CA  GLU A  72       9.103  -5.517  -2.081  0.50 26.21           C  
ATOM    573  C   GLU A  72       7.859  -6.266  -2.599  1.00 26.10           C  
ATOM    574  O   GLU A  72       6.737  -5.950  -2.220  1.00 26.10           O  
ATOM    575  CB  GLU A  72      10.399  -6.197  -2.546  0.50 26.37           C  
ATOM    577  CG  GLU A  72      11.671  -5.625  -1.951  0.50 27.32           C  
ATOM    579  CD  GLU A  72      12.890  -6.353  -2.451  0.50 27.78           C  
ATOM    581  OE1 GLU A  72      13.153  -7.478  -1.973  0.50 30.80           O  
ATOM    583  OE2 GLU A  72      13.562  -5.820  -3.351  0.50 31.28           O  
ATOM    585  N   ASP A  73       8.069  -7.287  -3.436  1.00 25.49           N  
ATOM    586  CA  ASP A  73       6.960  -8.060  -4.025  1.00 25.65           C  
ATOM    587  C   ASP A  73       6.684  -9.381  -3.292  1.00 25.29           C  
ATOM    588  O   ASP A  73       5.940 -10.237  -3.801  1.00 25.47           O  
ATOM    589  CB  ASP A  73       7.222  -8.317  -5.521  1.00 25.79           C  
ATOM    590  CG  ASP A  73       8.598  -8.933  -5.805  1.00 26.54           C  
ATOM    591  OD1 ASP A  73       9.377  -9.207  -4.863  1.00 25.63           O  
ATOM    592  OD2 ASP A  73       8.913  -9.125  -7.007  1.00 28.39           O  
ATOM    593  N   ARG A  74       7.248  -9.529  -2.092  1.00 24.73           N  
ATOM    594  CA  ARG A  74       7.139 -10.759  -1.334  1.00 24.94           C  
ATOM    595  C   ARG A  74       6.335 -10.608  -0.043  1.00 24.14           C  
ATOM    596  O   ARG A  74       6.260  -9.524   0.543  1.00 23.29           O  
ATOM    597  CB  ARG A  74       8.535 -11.279  -1.000  1.00 24.93           C  
ATOM    598  CG  ARG A  74       9.306 -11.770  -2.208  1.00 26.29           C  
ATOM    599  CD  ARG A  74      10.684 -12.290  -1.826  1.00 28.21           C  
ATOM    600  NE  ARG A  74      11.583 -11.203  -1.446  1.00 31.55           N  
ATOM    601  CZ  ARG A  74      12.267 -11.104  -0.298  1.00 32.83           C  
ATOM    602  NH1 ARG A  74      12.204 -12.031   0.645  1.00 33.31           N  
ATOM    603  NH2 ARG A  74      13.039 -10.048  -0.103  1.00 33.21           N  
ATOM    604  N   VAL A  75       5.757 -11.724   0.391  1.00 23.94           N  
ATOM    605  CA  VAL A  75       5.076 -11.828   1.676  1.00 23.90           C  
ATOM    606  C   VAL A  75       5.505 -13.153   2.311  1.00 24.00           C  
ATOM    607  O   VAL A  75       5.654 -14.153   1.598  1.00 23.84           O  
ATOM    608  CB  VAL A  75       3.543 -11.809   1.516  1.00 23.98           C  
ATOM    609  CG1 VAL A  75       2.854 -11.859   2.892  1.00 24.07           C  
ATOM    610  CG2 VAL A  75       3.090 -10.581   0.729  1.00 24.57           C  
ATOM    611  N   ALA A  76       5.710 -13.154   3.626  1.00 23.81           N  
ATOM    612  CA  ALA A  76       6.016 -14.377   4.378  1.00 23.84           C  
ATOM    613  C   ALA A  76       5.069 -14.502   5.571  1.00 23.95           C  
ATOM    614  O   ALA A  76       4.812 -13.517   6.280  1.00 24.52           O  
ATOM    615  CB  ALA A  76       7.459 -14.369   4.858  1.00 24.16           C  
ATOM    616  N   LEU A  77       4.565 -15.712   5.787  1.00 23.83           N  
ATOM    617  CA  LEU A  77       3.623 -15.993   6.860  1.00 24.73           C  
ATOM    618  C   LEU A  77       4.180 -17.127   7.687  1.00 24.32           C  
ATOM    619  O   LEU A  77       4.539 -18.171   7.135  1.00 25.05           O  
ATOM    620  CB  LEU A  77       2.268 -16.425   6.314  1.00 24.96           C  
ATOM    621  CG  LEU A  77       1.561 -15.378   5.445  1.00 26.58           C  
ATOM    622  CD1 LEU A  77       1.985 -15.536   3.998  1.00 28.80           C  
ATOM    623  CD2 LEU A  77       0.071 -15.528   5.570  1.00 27.10           C  
ATOM    624  N   ARG A  78       4.244 -16.922   8.990  1.00 24.39           N  
ATOM    625  CA  ARG A  78       4.573 -17.983   9.928  1.00 24.82           C  
ATOM    626  C   ARG A  78       3.242 -18.499  10.470  1.00 24.91           C  
ATOM    627  O   ARG A  78       2.467 -17.744  11.071  1.00 24.50           O  
ATOM    628  CB  ARG A  78       5.467 -17.460  11.054  1.00 24.74           C  
ATOM    629  CG  ARG A  78       5.864 -18.542  12.060  1.00 24.93           C  
ATOM    630  CD  ARG A  78       7.040 -18.126  12.933  1.00 25.90           C  
ATOM    631  NE  ARG A  78       6.831 -16.820  13.559  1.00 26.34           N  
ATOM    632  CZ  ARG A  78       6.159 -16.616  14.686  1.00 26.24           C  
ATOM    633  NH1 ARG A  78       5.620 -17.612  15.352  1.00 26.85           N  
ATOM    634  NH2 ARG A  78       6.034 -15.392  15.157  1.00 28.60           N  
ATOM    635  N   ILE A  79       3.001 -19.786  10.256  1.00 25.15           N  
ATOM    636  CA  ILE A  79       1.695 -20.388  10.462  1.00 25.35           C  
ATOM    637  C   ILE A  79       1.796 -21.634  11.338  1.00 25.56           C  
ATOM    638  O   ILE A  79       2.713 -22.440  11.171  1.00 25.30           O  
ATOM    639  CB  ILE A  79       1.077 -20.775   9.103  1.00 25.59           C  
ATOM    640  CG1 ILE A  79       0.795 -19.512   8.278  1.00 26.61           C  
ATOM    641  CG2 ILE A  79      -0.195 -21.608   9.290  1.00 25.71           C  
ATOM    642  CD1 ILE A  79       0.573 -19.761   6.814  1.00 26.98           C  
ATOM    643  N   THR A  80       0.845 -21.779  12.256  1.00 25.27           N  
ATOM    644  CA  THR A  80       0.668 -23.006  13.017  1.00 25.02           C  
ATOM    645  C   THR A  80      -0.607 -23.680  12.534  1.00 25.07           C  
ATOM    646  O   THR A  80      -1.662 -23.044  12.451  1.00 25.03           O  
ATOM    647  CB  THR A  80       0.583 -22.713  14.520  1.00 25.32           C  
ATOM    648  OG1 THR A  80       1.828 -22.141  14.950  1.00 26.84           O  
ATOM    649  CG2 THR A  80       0.290 -23.999  15.320  1.00 25.52           C  
ATOM    650  N   VAL A  81      -0.492 -24.956  12.188  1.00 24.66           N  
ATOM    651  CA  VAL A  81      -1.636 -25.748  11.748  1.00 24.73           C  
ATOM    652  C   VAL A  81      -2.067 -26.666  12.878  1.00 24.66           C  
ATOM    653  O   VAL A  81      -1.224 -27.289  13.531  1.00 23.81           O  
ATOM    654  CB  VAL A  81      -1.303 -26.602  10.510  1.00 25.15           C  
ATOM    655  CG1 VAL A  81      -2.544 -27.371  10.044  1.00 25.49           C  
ATOM    656  CG2 VAL A  81      -0.760 -25.725   9.388  1.00 25.62           C  
ATOM    657  N   THR A  82      -3.375 -26.733  13.114  1.00 24.11           N  
ATOM    658  CA  THR A  82      -3.949 -27.693  14.056  1.00 24.37           C  
ATOM    659  C   THR A  82      -5.082 -28.443  13.380  1.00 24.17           C  
ATOM    660  O   THR A  82      -5.792 -27.883  12.551  1.00 23.24           O  
ATOM    661  CB  THR A  82      -4.452 -27.024  15.343  1.00 24.67           C  
ATOM    662  OG1 THR A  82      -5.415 -26.014  15.033  1.00 26.06           O  
ATOM    663  CG2 THR A  82      -3.294 -26.391  16.099  1.00 25.27           C  
ATOM    664  N   ALA A  83      -5.239 -29.713  13.729  1.00 24.49           N  
ATOM    665  CA  ALA A  83      -6.244 -30.549  13.100  1.00 25.14           C  
ATOM    666  C   ALA A  83      -6.467 -31.818  13.899  1.00 25.51           C  
ATOM    667  O   ALA A  83      -5.780 -32.071  14.889  1.00 25.04           O  
ATOM    668  CB  ALA A  83      -5.801 -30.911  11.692  1.00 25.05           C  
ATOM    669  N   THR A  84      -7.426 -32.613  13.437  1.00 26.25           N  
ATOM    670  CA  THR A  84      -7.623 -33.969  13.939  1.00 26.84           C  
ATOM    671  C   THR A  84      -7.205 -34.939  12.836  1.00 26.93           C  
ATOM    672  O   THR A  84      -7.477 -34.702  11.655  1.00 26.21           O  
ATOM    673  CB  THR A  84      -9.096 -34.218  14.307  1.00 27.09           C  
ATOM    674  OG1 THR A  84      -9.596 -33.096  15.039  1.00 30.61           O  
ATOM    675  CG2 THR A  84      -9.220 -35.439  15.164  1.00 27.80           C  
ATOM    676  N   HIS A  85      -6.556 -36.034  13.223  1.00 27.07           N  
ATOM    677  CA  HIS A  85      -6.109 -37.040  12.267  1.00 27.52           C  
ATOM    678  C   HIS A  85      -7.264 -37.998  11.970  1.00 27.79           C  
ATOM    679  O   HIS A  85      -7.514 -38.943  12.728  1.00 27.44           O  
ATOM    680  CB  HIS A  85      -4.877 -37.792  12.799  1.00 27.48           C  
ATOM    681  CG  HIS A  85      -4.298 -38.770  11.822  1.00 27.55           C  
ATOM    682  ND1 HIS A  85      -3.560 -39.868  12.213  1.00 27.53           N  
ATOM    683  CD2 HIS A  85      -4.363 -38.821  10.471  1.00 28.03           C  
ATOM    684  CE1 HIS A  85      -3.188 -40.547  11.141  1.00 27.99           C  
ATOM    685  NE2 HIS A  85      -3.670 -39.938  10.073  1.00 27.87           N  
ATOM    686  N   GLN A  86      -7.964 -37.730  10.867  1.00 28.29           N  
ATOM    687  CA  GLN A  86      -9.180 -38.459  10.495  1.00 28.93           C  
ATOM    688  C   GLN A  86      -9.007 -39.364   9.276  1.00 29.21           C  
ATOM    689  O   GLN A  86      -9.819 -40.268   9.067  1.00 28.86           O  
ATOM    690  CB  GLN A  86     -10.325 -37.479  10.203  1.00 29.35           C  
ATOM    691  CG  GLN A  86     -10.687 -36.526  11.338  1.00 31.09           C  
ATOM    692  CD  GLN A  86     -11.384 -37.191  12.519  1.00 35.56           C  
ATOM    693  OE1 GLN A  86     -11.712 -36.526  13.503  1.00 39.41           O  
ATOM    694  NE2 GLN A  86     -11.618 -38.495  12.431  1.00 37.07           N  
ATOM    695  N   GLY A  87      -7.975 -39.127   8.470  1.00 29.34           N  
ATOM    696  CA  GLY A  87      -7.696 -39.967   7.298  1.00 30.16           C  
ATOM    697  C   GLY A  87      -6.269 -40.479   7.302  1.00 30.48           C  
ATOM    698  O   GLY A  87      -5.403 -39.892   7.942  1.00 30.09           O  
ATOM    699  N   GLU A  88      -6.022 -41.584   6.595  1.00 31.17           N  
ATOM    700  CA  GLU A  88      -4.680 -42.155   6.546  0.50 31.28           C  
ATOM    702  C   GLU A  88      -3.677 -41.111   6.051  1.00 31.42           C  
ATOM    703  O   GLU A  88      -3.949 -40.356   5.117  1.00 31.25           O  
ATOM    704  CB  GLU A  88      -4.629 -43.414   5.669  0.50 31.49           C  
ATOM    706  CG  GLU A  88      -3.347 -44.239   5.849  0.50 31.53           C  
ATOM    708  CD  GLU A  88      -3.292 -45.479   4.968  0.50 31.97           C  
ATOM    710  OE1 GLU A  88      -2.215 -45.759   4.399  0.50 33.46           O  
ATOM    712  OE2 GLU A  88      -4.312 -46.193   4.863  0.50 32.85           O  
ATOM    714  N   PHE A  89      -2.521 -41.066   6.709  1.00 31.42           N  
ATOM    715  CA  PHE A  89      -1.468 -40.128   6.357  1.00 31.96           C  
ATOM    716  C   PHE A  89      -0.101 -40.752   6.607  1.00 32.54           C  
ATOM    717  O   PHE A  89       0.144 -41.305   7.678  1.00 32.30           O  
ATOM    718  CB  PHE A  89      -1.614 -38.838   7.166  1.00 31.36           C  
ATOM    719  CG  PHE A  89      -0.771 -37.711   6.652  1.00 30.93           C  
ATOM    720  CD1 PHE A  89      -1.046 -37.133   5.421  1.00 31.19           C  
ATOM    721  CD2 PHE A  89       0.300 -37.234   7.384  1.00 30.32           C  
ATOM    722  CE1 PHE A  89      -0.269 -36.096   4.935  1.00 31.08           C  
ATOM    723  CE2 PHE A  89       1.086 -36.195   6.905  1.00 31.20           C  
ATOM    724  CZ  PHE A  89       0.798 -35.622   5.680  1.00 31.00           C  
ATOM    725  N   MET A  90       0.776 -40.657   5.607  1.00 33.63           N  
ATOM    726  CA  MET A  90       2.113 -41.262   5.646  1.00 34.61           C  
ATOM    727  C   MET A  90       2.081 -42.729   6.070  1.00 34.44           C  
ATOM    728  O   MET A  90       2.948 -43.188   6.812  1.00 34.77           O  
ATOM    729  CB  MET A  90       3.031 -40.479   6.582  1.00 34.87           C  
ATOM    730  CG  MET A  90       3.164 -39.017   6.243  1.00 36.05           C  
ATOM    731  SD  MET A  90       4.411 -38.167   7.226  1.00 38.85           S  
ATOM    732  CE  MET A  90       4.054 -38.746   8.871  1.00 38.66           C  
ATOM    733  N   GLY A  91       1.069 -43.454   5.599  1.00 34.49           N  
ATOM    734  CA  GLY A  91       0.915 -44.867   5.911  1.00 34.30           C  
ATOM    735  C   GLY A  91       0.380 -45.172   7.300  1.00 34.20           C  
ATOM    736  O   GLY A  91       0.288 -46.335   7.678  1.00 34.29           O  
ATOM    737  N   VAL A  92       0.014 -44.142   8.058  1.00 33.84           N  
ATOM    738  CA  VAL A  92      -0.491 -44.324   9.419  1.00 33.71           C  
ATOM    739  C   VAL A  92      -2.008 -44.176   9.444  1.00 33.64           C  
ATOM    740  O   VAL A  92      -2.541 -43.162   8.997  1.00 33.44           O  
ATOM    741  CB  VAL A  92       0.137 -43.299  10.383  1.00 33.46           C  
ATOM    742  CG1 VAL A  92      -0.409 -43.481  11.799  1.00 33.55           C  
ATOM    743  CG2 VAL A  92       1.644 -43.429  10.363  1.00 33.27           C  
ATOM    744  N   GLN A  93      -2.700 -45.183   9.972  1.00 33.67           N  
ATOM    745  CA  GLN A  93      -4.157 -45.142  10.048  1.00 33.92           C  
ATOM    746  C   GLN A  93      -4.615 -44.053  11.019  1.00 33.73           C  
ATOM    747  O   GLN A  93      -3.945 -43.793  12.020  1.00 33.58           O  
ATOM    748  CB  GLN A  93      -4.722 -46.496  10.478  1.00 34.01           C  
ATOM    749  CG  GLN A  93      -4.426 -47.635   9.504  1.00 35.00           C  
ATOM    750  CD  GLN A  93      -4.854 -47.320   8.079  1.00 36.03           C  
ATOM    751  OE1 GLN A  93      -5.984 -46.903   7.833  1.00 36.81           O  
ATOM    752  NE2 GLN A  93      -3.941 -47.511   7.135  1.00 37.53           N  
ATOM    753  N   PRO A  94      -5.761 -43.417  10.727  1.00 33.82           N  
ATOM    754  CA  PRO A  94      -6.230 -42.303  11.545  1.00 33.99           C  
ATOM    755  C   PRO A  94      -6.552 -42.692  12.985  1.00 34.12           C  
ATOM    756  O   PRO A  94      -7.174 -43.728  13.227  1.00 33.90           O  
ATOM    757  CB  PRO A  94      -7.494 -41.837  10.817  1.00 34.01           C  
ATOM    758  CG  PRO A  94      -7.931 -42.992  10.014  1.00 33.68           C  
ATOM    759  CD  PRO A  94      -6.680 -43.694   9.609  1.00 33.73           C  
ATOM    760  N   THR A  95      -6.111 -41.850  13.917  1.00 34.36           N  
ATOM    761  CA  THR A  95      -6.320 -42.058  15.348  1.00 34.36           C  
ATOM    762  C   THR A  95      -7.517 -41.250  15.865  1.00 34.19           C  
ATOM    763  O   THR A  95      -8.181 -41.649  16.818  1.00 34.50           O  
ATOM    764  CB  THR A  95      -5.062 -41.642  16.138  1.00 34.82           C  
ATOM    765  OG1 THR A  95      -4.599 -40.366  15.681  1.00 35.80           O  
ATOM    766  CG2 THR A  95      -3.944 -42.652  15.937  1.00 35.78           C  
ATOM    767  N   GLY A  96      -7.794 -40.117  15.229  1.00 33.38           N  
ATOM    768  CA  GLY A  96      -8.714 -39.133  15.787  1.00 33.00           C  
ATOM    769  C   GLY A  96      -8.004 -38.207  16.763  1.00 32.53           C  
ATOM    770  O   GLY A  96      -8.648 -37.389  17.421  1.00 32.77           O  
ATOM    771  N   GLN A  97      -6.680 -38.334  16.851  1.00 31.91           N  
ATOM    772  CA  GLN A  97      -5.855 -37.499  17.723  1.00 31.76           C  
ATOM    773  C   GLN A  97      -5.782 -36.087  17.183  1.00 30.14           C  
ATOM    774  O   GLN A  97      -5.721 -35.895  15.969  1.00 29.66           O  
ATOM    775  CB  GLN A  97      -4.401 -37.980  17.751  1.00 31.91           C  
ATOM    776  CG  GLN A  97      -4.018 -38.982  18.799  1.00 34.54           C  
ATOM    777  CD  GLN A  97      -2.518 -38.924  19.083  1.00 35.03           C  
ATOM    778  OE1 GLN A  97      -2.098 -38.682  20.216  1.00 40.05           O  
ATOM    779  NE2 GLN A  97      -1.704 -39.100  18.037  1.00 38.84           N  
ATOM    780  N   ARG A  98      -5.722 -35.111  18.082  1.00 29.13           N  
ATOM    781  CA  ARG A  98      -5.358 -33.757  17.687  1.00 28.39           C  
ATOM    782  C   ARG A  98      -3.870 -33.698  17.361  1.00 27.80           C  
ATOM    783  O   ARG A  98      -3.040 -34.276  18.070  1.00 26.73           O  
ATOM    784  CB  ARG A  98      -5.681 -32.751  18.790  1.00 28.75           C  
ATOM    785  CG  ARG A  98      -7.162 -32.610  19.090  1.00 29.28           C  
ATOM    786  CD  ARG A  98      -7.908 -31.928  17.944  1.00 31.29           C  
ATOM    787  NE  ARG A  98      -7.581 -30.508  17.880  1.00 31.92           N  
ATOM    788  CZ  ARG A  98      -7.905 -29.688  16.880  1.00 31.66           C  
ATOM    789  NH1 ARG A  98      -8.566 -30.128  15.808  1.00 29.71           N  
ATOM    790  NH2 ARG A  98      -7.555 -28.413  16.960  1.00 31.52           N  
ATOM    791  N   VAL A  99      -3.538 -32.977  16.295  1.00 26.57           N  
ATOM    792  CA  VAL A  99      -2.170 -32.846  15.839  1.00 26.38           C  
ATOM    793  C   VAL A  99      -1.891 -31.387  15.522  1.00 26.06           C  
ATOM    794  O   VAL A  99      -2.822 -30.584  15.399  1.00 25.23           O  
ATOM    795  CB  VAL A  99      -1.885 -33.712  14.588  1.00 26.29           C  
ATOM    796  CG1 VAL A  99      -2.157 -35.195  14.881  1.00 26.65           C  
ATOM    797  CG2 VAL A  99      -2.699 -33.238  13.375  1.00 26.29           C  
ATOM    798  N   SER A 100      -0.609 -31.070  15.392  1.00 25.60           N  
ATOM    799  CA  SER A 100      -0.160 -29.736  15.018  1.00 25.94           C  
ATOM    800  C   SER A 100       1.154 -29.791  14.245  1.00 25.94           C  
ATOM    801  O   SER A 100       1.939 -30.750  14.360  1.00 25.68           O  
ATOM    802  CB  SER A 100       0.004 -28.852  16.260  1.00 26.34           C  
ATOM    803  OG  SER A 100       1.056 -29.337  17.088  1.00 27.87           O  
ATOM    804  N   TRP A 101       1.390 -28.756  13.450  1.00 25.14           N  
ATOM    805  CA  TRP A 101       2.694 -28.530  12.872  1.00 25.23           C  
ATOM    806  C   TRP A 101       2.866 -27.048  12.561  1.00 24.65           C  
ATOM    807  O   TRP A 101       1.961 -26.246  12.808  1.00 24.14           O  
ATOM    808  CB  TRP A 101       2.953 -29.446  11.657  1.00 25.53           C  
ATOM    809  CG  TRP A 101       2.100 -29.237  10.460  1.00 26.01           C  
ATOM    810  CD1 TRP A 101       2.396 -28.478   9.371  1.00 26.66           C  
ATOM    811  CD2 TRP A 101       0.832 -29.845  10.194  1.00 26.85           C  
ATOM    812  NE1 TRP A 101       1.385 -28.553   8.451  1.00 27.43           N  
ATOM    813  CE2 TRP A 101       0.413 -29.393   8.927  1.00 27.25           C  
ATOM    814  CE3 TRP A 101       0.012 -30.730  10.903  1.00 26.71           C  
ATOM    815  CZ2 TRP A 101      -0.795 -29.793   8.352  1.00 27.11           C  
ATOM    816  CZ3 TRP A 101      -1.185 -31.119  10.342  1.00 26.98           C  
ATOM    817  CH2 TRP A 101      -1.580 -30.648   9.074  1.00 26.85           C  
ATOM    818  N   HIS A 102       4.045 -26.688  12.083  1.00 24.53           N  
ATOM    819  CA  HIS A 102       4.420 -25.285  11.943  1.00 24.51           C  
ATOM    820  C   HIS A 102       5.101 -25.112  10.617  1.00 24.64           C  
ATOM    821  O   HIS A 102       5.816 -26.001  10.158  1.00 24.35           O  
ATOM    822  CB  HIS A 102       5.356 -24.875  13.080  1.00 24.44           C  
ATOM    823  CG  HIS A 102       4.832 -25.235  14.435  1.00 24.55           C  
ATOM    824  ND1 HIS A 102       3.980 -24.418  15.144  1.00 23.57           N  
ATOM    825  CD2 HIS A 102       4.994 -26.352  15.183  1.00 24.28           C  
ATOM    826  CE1 HIS A 102       3.656 -25.007  16.280  1.00 25.48           C  
ATOM    827  NE2 HIS A 102       4.263 -26.180  16.332  1.00 24.91           N  
ATOM    828  N   LEU A 103       4.877 -23.975   9.977  1.00 24.20           N  
ATOM    829  CA  LEU A 103       5.513 -23.713   8.697  0.50 24.34           C  
ATOM    831  C   LEU A 103       5.672 -22.226   8.455  1.00 24.13           C  
ATOM    832  O   LEU A 103       5.008 -21.418   9.094  1.00 23.68           O  
ATOM    833  CB  LEU A 103       4.694 -24.350   7.575  0.50 24.42           C  
ATOM    835  CG  LEU A 103       3.221 -23.921   7.510  0.50 24.56           C  
ATOM    837  CD1 LEU A 103       3.028 -22.819   6.502  0.50 24.51           C  
ATOM    839  CD2 LEU A 103       2.318 -25.095   7.184  0.50 25.47           C  
ATOM    841  N   VAL A 104       6.558 -21.892   7.529  1.00 24.38           N  
ATOM    842  CA  VAL A 104       6.649 -20.554   6.990  1.00 24.96           C  
ATOM    843  C   VAL A 104       6.429 -20.687   5.490  1.00 25.24           C  
ATOM    844  O   VAL A 104       7.053 -21.523   4.826  1.00 25.10           O  
ATOM    845  CB  VAL A 104       7.999 -19.865   7.292  1.00 24.77           C  
ATOM    846  CG1 VAL A 104       8.095 -18.520   6.546  1.00 25.63           C  
ATOM    847  CG2 VAL A 104       8.159 -19.659   8.783  1.00 25.49           C  
ATOM    848  N   GLU A 105       5.516 -19.879   4.959  1.00 25.85           N  
ATOM    849  CA  GLU A 105       5.300 -19.800   3.524  1.00 26.68           C  
ATOM    850  C   GLU A 105       5.771 -18.443   3.049  1.00 26.11           C  
ATOM    851  O   GLU A 105       5.455 -17.435   3.670  1.00 25.89           O  
ATOM    852  CB  GLU A 105       3.819 -19.958   3.192  1.00 27.08           C  
ATOM    853  CG  GLU A 105       3.310 -21.357   3.486  1.00 30.60           C  
ATOM    854  CD  GLU A 105       1.918 -21.612   2.981  1.00 32.16           C  
ATOM    855  OE1 GLU A 105       0.964 -21.398   3.771  1.00 39.92           O  
ATOM    856  OE2 GLU A 105       1.770 -22.048   1.809  1.00 39.27           O  
ATOM    857  N   GLU A 106       6.508 -18.425   1.945  1.00 25.51           N  
ATOM    858  CA  GLU A 106       6.963 -17.188   1.343  1.00 25.55           C  
ATOM    859  C   GLU A 106       6.431 -17.159  -0.077  1.00 25.08           C  
ATOM    860  O   GLU A 106       6.538 -18.149  -0.800  1.00 24.33           O  
ATOM    861  CB  GLU A 106       8.489 -17.091   1.386  1.00 25.68           C  
ATOM    862  CG  GLU A 106       9.056 -15.775   0.875  1.00 25.69           C  
ATOM    863  CD  GLU A 106      10.571 -15.718   0.917  1.00 27.23           C  
ATOM    864  OE1 GLU A 106      11.212 -16.599   1.543  1.00 29.12           O  
ATOM    865  OE2 GLU A 106      11.130 -14.766   0.329  1.00 30.40           O  
ATOM    866  N   LEU A 107       5.872 -16.016  -0.470  1.00 24.81           N  
ATOM    867  CA  LEU A 107       5.232 -15.859  -1.772  0.50 24.99           C  
ATOM    869  C   LEU A 107       5.745 -14.606  -2.464  1.00 24.95           C  
ATOM    870  O   LEU A 107       5.922 -13.574  -1.821  1.00 24.66           O  
ATOM    871  CB  LEU A 107       3.712 -15.746  -1.611  0.50 25.07           C  
ATOM    873  CG  LEU A 107       2.946 -16.917  -0.988  0.50 25.21           C  
ATOM    875  CD1 LEU A 107       1.466 -16.595  -0.980  0.50 26.55           C  
ATOM    877  CD2 LEU A 107       3.202 -18.223  -1.721  0.50 26.71           C  
ATOM    879  N   ARG A 108       5.988 -14.703  -3.768  1.00 24.91           N  
ATOM    880  CA  ARG A 108       6.349 -13.543  -4.579  1.00 25.18           C  
ATOM    881  C   ARG A 108       5.243 -13.320  -5.608  1.00 25.08           C  
ATOM    882  O   ARG A 108       4.795 -14.272  -6.261  1.00 24.40           O  
ATOM    883  CB  ARG A 108       7.703 -13.731  -5.279  1.00 25.10           C  
ATOM    884  CG  ARG A 108       8.176 -12.459  -5.986  1.00 25.83           C  
ATOM    885  CD  ARG A 108       9.584 -12.572  -6.494  1.00 27.26           C  
ATOM    886  NE  ARG A 108       9.659 -13.367  -7.709  1.00 29.09           N  
ATOM    887  CZ  ARG A 108       9.421 -12.909  -8.939  1.00 30.55           C  
ATOM    888  NH1 ARG A 108       9.037 -11.654  -9.156  1.00 31.42           N  
ATOM    889  NH2 ARG A 108       9.552 -13.730  -9.970  1.00 30.98           N  
ATOM    890  N   PHE A 109       4.828 -12.060  -5.752  1.00 25.14           N  
ATOM    891  CA  PHE A 109       3.707 -11.679  -6.613  1.00 25.60           C  
ATOM    892  C   PHE A 109       4.159 -10.932  -7.852  1.00 25.87           C  
ATOM    893  O   PHE A 109       5.095 -10.138  -7.795  1.00 25.27           O  
ATOM    894  CB  PHE A 109       2.747 -10.752  -5.859  1.00 25.51           C  
ATOM    895  CG  PHE A 109       1.910 -11.454  -4.828  1.00 25.11           C  
ATOM    896  CD1 PHE A 109       2.452 -11.787  -3.593  1.00 25.31           C  
ATOM    897  CD2 PHE A 109       0.583 -11.783  -5.097  1.00 25.35           C  
ATOM    898  CE1 PHE A 109       1.690 -12.449  -2.641  1.00 26.52           C  
ATOM    899  CE2 PHE A 109      -0.189 -12.431  -4.146  1.00 25.60           C  
ATOM    900  CZ  PHE A 109       0.373 -12.769  -2.918  1.00 25.96           C  
ATOM    901  N   VAL A 110       3.464 -11.180  -8.960  1.00 26.15           N  
ATOM    902  CA  VAL A 110       3.532 -10.337 -10.153  1.00 27.17           C  
ATOM    903  C   VAL A 110       2.101 -10.135 -10.642  1.00 27.61           C  
ATOM    904  O   VAL A 110       1.361 -11.105 -10.817  1.00 27.26           O  
ATOM    905  CB  VAL A 110       4.366 -10.969 -11.301  1.00 27.12           C  
ATOM    906  CG1 VAL A 110       4.328 -10.063 -12.526  1.00 28.24           C  
ATOM    907  CG2 VAL A 110       5.801 -11.214 -10.863  1.00 27.60           C  
ATOM    908  N   ASP A 111       1.712  -8.876 -10.838  1.00 28.60           N  
ATOM    909  CA  ASP A 111       0.367  -8.523 -11.294  1.00 29.23           C  
ATOM    910  C   ASP A 111      -0.742  -9.172 -10.468  1.00 29.27           C  
ATOM    911  O   ASP A 111      -1.750  -9.619 -11.018  1.00 29.54           O  
ATOM    912  CB  ASP A 111       0.195  -8.878 -12.773  1.00 30.58           C  
ATOM    913  CG  ASP A 111       1.115  -8.088 -13.670  1.00 34.41           C  
ATOM    914  OD1 ASP A 111       1.461  -6.940 -13.305  1.00 39.72           O  
ATOM    915  OD2 ASP A 111       1.507  -8.615 -14.736  1.00 38.85           O  
ATOM    916  N   GLY A 112      -0.545  -9.232  -9.155  1.00 28.26           N  
ATOM    917  CA  GLY A 112      -1.543  -9.773  -8.240  1.00 28.46           C  
ATOM    918  C   GLY A 112      -1.609 -11.292  -8.148  1.00 28.37           C  
ATOM    919  O   GLY A 112      -2.435 -11.825  -7.408  1.00 29.41           O  
ATOM    920  N   LYS A 113      -0.740 -11.993  -8.870  1.00 27.67           N  
ATOM    921  CA  LYS A 113      -0.735 -13.447  -8.853  1.00 27.34           C  
ATOM    922  C   LYS A 113       0.591 -13.945  -8.280  1.00 26.48           C  
ATOM    923  O   LYS A 113       1.624 -13.283  -8.407  1.00 25.92           O  
ATOM    924  CB  LYS A 113      -0.968 -13.998 -10.258  1.00 28.36           C  
ATOM    925  CG  LYS A 113      -2.353 -13.666 -10.841  1.00 30.49           C  
ATOM    926  CD  LYS A 113      -3.448 -14.613 -10.341  1.00 33.71           C  
ATOM    927  CE  LYS A 113      -4.871 -14.150 -10.731  1.00 35.18           C  
ATOM    928  NZ  LYS A 113      -5.430 -13.104  -9.760  1.00 38.40           N  
ATOM    929  N   VAL A 114       0.552 -15.109  -7.643  1.00 25.02           N  
ATOM    930  CA  VAL A 114       1.748 -15.705  -7.053  1.00 24.84           C  
ATOM    931  C   VAL A 114       2.568 -16.383  -8.161  1.00 24.43           C  
ATOM    932  O   VAL A 114       2.067 -17.280  -8.842  1.00 24.27           O  
ATOM    933  CB  VAL A 114       1.380 -16.739  -5.972  1.00 24.66           C  
ATOM    934  CG1 VAL A 114       2.626 -17.374  -5.373  1.00 24.32           C  
ATOM    935  CG2 VAL A 114       0.527 -16.083  -4.887  1.00 25.64           C  
ATOM    936  N   VAL A 115       3.820 -15.957  -8.331  1.00 23.87           N  
ATOM    937  CA  VAL A 115       4.725 -16.545  -9.328  1.00 24.26           C  
ATOM    938  C   VAL A 115       5.807 -17.463  -8.734  1.00 24.32           C  
ATOM    939  O   VAL A 115       6.407 -18.295  -9.451  1.00 23.95           O  
ATOM    940  CB  VAL A 115       5.393 -15.458 -10.203  1.00 24.02           C  
ATOM    941  CG1 VAL A 115       4.347 -14.727 -11.023  1.00 25.13           C  
ATOM    942  CG2 VAL A 115       6.211 -14.493  -9.358  1.00 24.15           C  
ATOM    943  N   GLU A 116       6.074 -17.296  -7.442  1.00 24.09           N  
ATOM    944  CA  GLU A 116       7.000 -18.161  -6.722  1.00 24.67           C  
ATOM    945  C   GLU A 116       6.480 -18.401  -5.323  1.00 24.40           C  
ATOM    946  O   GLU A 116       5.953 -17.481  -4.679  1.00 23.74           O  
ATOM    947  CB  GLU A 116       8.408 -17.551  -6.648  1.00 24.63           C  
ATOM    948  CG  GLU A 116       9.150 -17.540  -7.975  1.00 25.58           C  
ATOM    949  CD  GLU A 116      10.590 -17.082  -7.838  1.00 26.81           C  
ATOM    950  OE1 GLU A 116      10.808 -15.873  -7.618  1.00 28.57           O  
ATOM    951  OE2 GLU A 116      11.509 -17.924  -7.977  1.00 28.38           O  
ATOM    952  N   HIS A 117       6.673 -19.633  -4.859  1.00 24.73           N  
ATOM    953  CA  HIS A 117       6.205 -20.070  -3.561  0.50 25.03           C  
ATOM    955  C   HIS A 117       7.287 -20.942  -2.915  1.00 24.94           C  
ATOM    956  O   HIS A 117       7.689 -21.948  -3.495  1.00 24.80           O  
ATOM    957  CB  HIS A 117       4.884 -20.830  -3.759  0.50 25.35           C  
ATOM    959  CG  HIS A 117       4.461 -21.652  -2.587  0.50 25.92           C  
ATOM    961  ND1 HIS A 117       4.018 -22.951  -2.717  0.50 27.52           N  
ATOM    963  CD2 HIS A 117       4.417 -21.370  -1.262  0.50 27.43           C  
ATOM    965  CE1 HIS A 117       3.713 -23.431  -1.524  0.50 28.25           C  
ATOM    967  NE2 HIS A 117       3.945 -22.494  -0.625  0.50 28.32           N  
ATOM    969  N   TRP A 118       7.764 -20.538  -1.740  1.00 24.94           N  
ATOM    970  CA  TRP A 118       8.741 -21.310  -0.975  1.00 25.16           C  
ATOM    971  C   TRP A 118       8.130 -21.694   0.367  1.00 25.74           C  
ATOM    972  O   TRP A 118       7.461 -20.870   1.004  1.00 26.55           O  
ATOM    973  CB  TRP A 118      10.001 -20.488  -0.691  1.00 24.83           C  
ATOM    974  CG  TRP A 118      10.725 -19.937  -1.866  1.00 24.16           C  
ATOM    975  CD1 TRP A 118      11.799 -20.487  -2.492  1.00 24.80           C  
ATOM    976  CD2 TRP A 118      10.474 -18.688  -2.522  1.00 24.07           C  
ATOM    977  NE1 TRP A 118      12.228 -19.671  -3.506  1.00 24.69           N  
ATOM    978  CE2 TRP A 118      11.433 -18.559  -3.552  1.00 23.88           C  
ATOM    979  CE3 TRP A 118       9.541 -17.662  -2.333  1.00 24.50           C  
ATOM    980  CZ2 TRP A 118      11.476 -17.449  -4.405  1.00 24.41           C  
ATOM    981  CZ3 TRP A 118       9.578 -16.560  -3.185  1.00 24.16           C  
ATOM    982  CH2 TRP A 118      10.540 -16.463  -4.205  1.00 24.73           C  
ATOM    983  N   ASP A 119       8.356 -22.927   0.814  1.00 25.98           N  
ATOM    984  CA  ASP A 119       7.908 -23.329   2.154  1.00 26.33           C  
ATOM    985  C   ASP A 119       9.047 -23.911   2.975  1.00 26.01           C  
ATOM    986  O   ASP A 119       9.982 -24.496   2.429  1.00 26.30           O  
ATOM    987  CB  ASP A 119       6.726 -24.313   2.092  1.00 27.41           C  
ATOM    988  CG  ASP A 119       7.083 -25.648   1.447  1.00 29.62           C  
ATOM    989  OD1 ASP A 119       8.065 -26.302   1.870  1.00 33.43           O  
ATOM    990  OD2 ASP A 119       6.353 -26.075   0.518  1.00 34.60           O  
ATOM    991  N   VAL A 120       8.961 -23.713   4.282  1.00 25.27           N  
ATOM    992  CA  VAL A 120       9.794 -24.418   5.240  1.00 25.25           C  
ATOM    993  C   VAL A 120       8.819 -24.996   6.246  1.00 24.95           C  
ATOM    994  O   VAL A 120       8.156 -24.252   6.983  1.00 24.49           O  
ATOM    995  CB  VAL A 120      10.811 -23.486   5.926  1.00 24.93           C  
ATOM    996  CG1 VAL A 120      11.559 -24.225   7.024  1.00 25.25           C  
ATOM    997  CG2 VAL A 120      11.778 -22.900   4.907  1.00 25.37           C  
ATOM    998  N   ILE A 121       8.710 -26.321   6.263  1.00 25.34           N  
ATOM    999  CA  ILE A 121       7.705 -26.987   7.057  1.00 25.94           C  
ATOM   1000  C   ILE A 121       8.353 -27.849   8.133  1.00 25.88           C  
ATOM   1001  O   ILE A 121       9.162 -28.728   7.830  1.00 26.14           O  
ATOM   1002  CB  ILE A 121       6.787 -27.861   6.188  1.00 25.83           C  
ATOM   1003  CG1 ILE A 121       6.176 -27.030   5.054  1.00 26.61           C  
ATOM   1004  CG2 ILE A 121       5.692 -28.500   7.057  1.00 25.99           C  
ATOM   1005  CD1 ILE A 121       5.441 -27.834   4.037  1.00 27.69           C  
ATOM   1006  N   ASN A 122       7.998 -27.559   9.383  1.00 26.31           N  
ATOM   1007  CA  ASN A 122       8.396 -28.356  10.525  1.00 26.54           C  
ATOM   1008  C   ASN A 122       7.270 -29.297  10.912  1.00 26.46           C  
ATOM   1009  O   ASN A 122       6.332 -28.892  11.613  1.00 26.00           O  
ATOM   1010  CB  ASN A 122       8.741 -27.471  11.725  1.00 26.49           C  
ATOM   1011  CG  ASN A 122       9.003 -28.280  12.977  1.00 26.47           C  
ATOM   1012  OD1 ASN A 122       9.380 -29.442  12.890  1.00 26.63           O  
ATOM   1013  ND2 ASN A 122       8.787 -27.680  14.145  1.00 26.96           N  
ATOM   1014  N   MET A 123       7.400 -30.550  10.478  1.00 26.89           N  
ATOM   1015  CA  MET A 123       6.417 -31.585  10.790  0.70 27.92           C  
ATOM   1017  C   MET A 123       6.801 -32.392  12.032  1.00 27.39           C  
ATOM   1018  O   MET A 123       6.126 -33.354  12.396  1.00 26.58           O  
ATOM   1019  CB  MET A 123       6.256 -32.532   9.608  0.70 28.19           C  
ATOM   1021  CG  MET A 123       5.774 -31.864   8.333  0.70 30.19           C  
ATOM   1023  SD  MET A 123       4.388 -32.741   7.616  0.70 33.17           S  
ATOM   1025  CE  MET A 123       3.079 -31.880   8.467  0.70 35.02           C  
ATOM   1027  N   ARG A 124       7.873 -31.995  12.714  1.00 27.18           N  
ATOM   1028  CA  ARG A 124       8.323 -32.763  13.878  1.00 27.15           C  
ATOM   1029  C   ARG A 124       7.185 -33.175  14.841  1.00 26.66           C  
ATOM   1030  O   ARG A 124       7.054 -34.359  15.148  1.00 26.50           O  
ATOM   1031  CB  ARG A 124       9.445 -32.020  14.619  1.00 27.00           C  
ATOM   1032  CG  ARG A 124      10.182 -32.872  15.651  1.00 27.86           C  
ATOM   1033  CD  ARG A 124      10.783 -32.009  16.757  1.00 27.39           C  
ATOM   1034  NE  ARG A 124       9.736 -31.414  17.587  1.00 27.39           N  
ATOM   1035  CZ  ARG A 124       9.081 -32.052  18.550  1.00 29.59           C  
ATOM   1036  NH1 ARG A 124       8.125 -31.426  19.223  1.00 30.07           N  
ATOM   1037  NH2 ARG A 124       9.381 -33.307  18.872  1.00 30.72           N  
ATOM   1038  N   PRO A 125       6.339 -32.220  15.288  1.00 26.78           N  
ATOM   1039  CA  PRO A 125       5.295 -32.582  16.256  1.00 26.75           C  
ATOM   1040  C   PRO A 125       4.285 -33.581  15.690  1.00 26.83           C  
ATOM   1041  O   PRO A 125       3.788 -34.446  16.418  1.00 26.51           O  
ATOM   1042  CB  PRO A 125       4.595 -31.246  16.561  1.00 27.15           C  
ATOM   1043  CG  PRO A 125       5.441 -30.193  15.990  1.00 27.01           C  
ATOM   1044  CD  PRO A 125       6.268 -30.795  14.914  1.00 26.90           C  
ATOM   1045  N   LEU A 126       3.988 -33.457  14.401  1.00 26.81           N  
ATOM   1046  CA  LEU A 126       3.090 -34.393  13.737  1.00 26.96           C  
ATOM   1047  C   LEU A 126       3.733 -35.767  13.617  1.00 26.91           C  
ATOM   1048  O   LEU A 126       3.076 -36.791  13.830  1.00 27.15           O  
ATOM   1049  CB  LEU A 126       2.703 -33.874  12.349  1.00 26.78           C  
ATOM   1050  CG  LEU A 126       1.775 -34.764  11.515  1.00 27.22           C  
ATOM   1051  CD1 LEU A 126       0.458 -35.009  12.240  1.00 28.18           C  
ATOM   1052  CD2 LEU A 126       1.523 -34.130  10.156  1.00 27.43           C  
ATOM   1053  N   LEU A 127       5.018 -35.792  13.274  1.00 27.01           N  
ATOM   1054  CA  LEU A 127       5.740 -37.060  13.158  1.00 27.41           C  
ATOM   1055  C   LEU A 127       5.757 -37.826  14.480  1.00 27.43           C  
ATOM   1056  O   LEU A 127       5.663 -39.057  14.484  1.00 26.89           O  
ATOM   1057  CB  LEU A 127       7.163 -36.842  12.642  1.00 27.76           C  
ATOM   1058  CG  LEU A 127       7.267 -36.333  11.200  1.00 28.52           C  
ATOM   1059  CD1 LEU A 127       8.669 -35.795  10.927  1.00 29.53           C  
ATOM   1060  CD2 LEU A 127       6.895 -37.419  10.198  1.00 30.14           C  
ATOM   1061  N   VAL A 128       5.855 -37.100  15.592  1.00 27.79           N  
ATOM   1062  CA  VAL A 128       5.761 -37.713  16.915  1.00 28.38           C  
ATOM   1063  C   VAL A 128       4.360 -38.305  17.135  1.00 28.74           C  
ATOM   1064  O   VAL A 128       4.233 -39.450  17.578  1.00 28.39           O  
ATOM   1065  CB  VAL A 128       6.123 -36.705  18.029  1.00 28.32           C  
ATOM   1066  CG1 VAL A 128       5.864 -37.299  19.413  1.00 29.07           C  
ATOM   1067  CG2 VAL A 128       7.577 -36.300  17.904  1.00 28.06           C  
ATOM   1068  N   ARG A 129       3.319 -37.536  16.809  1.00 29.07           N  
ATOM   1069  CA  ARG A 129       1.933 -37.988  16.981  1.00 29.67           C  
ATOM   1070  C   ARG A 129       1.603 -39.208  16.134  1.00 29.58           C  
ATOM   1071  O   ARG A 129       0.821 -40.072  16.550  1.00 29.71           O  
ATOM   1072  CB  ARG A 129       0.946 -36.864  16.656  1.00 30.59           C  
ATOM   1073  CG  ARG A 129       0.857 -35.797  17.720  1.00 33.26           C  
ATOM   1074  CD  ARG A 129       0.148 -36.289  18.983  1.00 38.38           C  
ATOM   1075  NE  ARG A 129       0.897 -35.853  20.160  1.00 40.98           N  
ATOM   1076  CZ  ARG A 129       1.665 -36.621  20.936  1.00 41.69           C  
ATOM   1077  NH1 ARG A 129       1.792 -37.931  20.731  1.00 41.88           N  
ATOM   1078  NH2 ARG A 129       2.304 -36.061  21.956  1.00 43.33           N  
ATOM   1079  N   LEU A 130       2.207 -39.285  14.953  1.00 29.16           N  
ATOM   1080  CA  LEU A 130       2.008 -40.422  14.069  1.00 29.26           C  
ATOM   1081  C   LEU A 130       2.939 -41.595  14.365  1.00 28.85           C  
ATOM   1082  O   LEU A 130       2.877 -42.612  13.674  1.00 28.28           O  
ATOM   1083  CB  LEU A 130       2.180 -39.989  12.616  1.00 29.32           C  
ATOM   1084  CG  LEU A 130       1.134 -38.982  12.139  1.00 30.92           C  
ATOM   1085  CD1 LEU A 130       1.373 -38.655  10.703  1.00 31.97           C  
ATOM   1086  CD2 LEU A 130      -0.272 -39.498  12.326  1.00 31.38           C  
ATOM   1087  N   GLY A 131       3.801 -41.449  15.374  1.00 28.71           N  
ATOM   1088  CA  GLY A 131       4.677 -42.528  15.812  1.00 28.84           C  
ATOM   1089  C   GLY A 131       5.915 -42.739  14.959  1.00 28.94           C  
ATOM   1090  O   GLY A 131       6.582 -43.777  15.075  1.00 28.47           O  
ATOM   1091  N   LYS A 132       6.232 -41.768  14.107  1.00 28.67           N  
ATOM   1092  CA  LYS A 132       7.405 -41.853  13.237  1.00 29.20           C  
ATOM   1093  C   LYS A 132       8.667 -41.459  13.991  1.00 29.34           C  
ATOM   1094  O   LYS A 132       9.770 -41.861  13.617  1.00 29.45           O  
ATOM   1095  CB  LYS A 132       7.247 -40.940  12.023  1.00 29.36           C  
ATOM   1096  CG  LYS A 132       6.050 -41.251  11.142  1.00 29.89           C  
ATOM   1097  CD  LYS A 132       6.183 -42.611  10.478  1.00 31.08           C  
ATOM   1098  CE  LYS A 132       5.261 -42.734   9.275  0.50 30.88           C  
ATOM   1099  NZ  LYS A 132       5.666 -41.797   8.189  0.50 31.72           N  
ATOM   1100  N   LEU A 133       8.495 -40.632  15.021  1.00 29.59           N  
ATOM   1101  CA  LEU A 133       9.575 -40.269  15.933  1.00 29.72           C  
ATOM   1102  C   LEU A 133       9.155 -40.580  17.362  1.00 30.05           C  
ATOM   1103  O   LEU A 133       7.971 -40.526  17.687  1.00 29.41           O  
ATOM   1104  CB  LEU A 133       9.897 -38.781  15.823  1.00 29.68           C  
ATOM   1105  CG  LEU A 133      10.391 -38.299  14.462  1.00 29.59           C  
ATOM   1106  CD1 LEU A 133      10.492 -36.789  14.456  1.00 30.08           C  
ATOM   1107  CD2 LEU A 133      11.730 -38.933  14.114  1.00 30.51           C  
ATOM   1108  N   PRO A 134      10.128 -40.893  18.233  1.00 30.70           N  
ATOM   1109  CA  PRO A 134       9.785 -41.206  19.616  1.00 30.78           C  
ATOM   1110  C   PRO A 134       9.152 -40.030  20.345  1.00 30.75           C  
ATOM   1111  O   PRO A 134       9.522 -38.886  20.107  1.00 30.65           O  
ATOM   1112  CB  PRO A 134      11.142 -41.526  20.258  1.00 30.92           C  
ATOM   1113  CG  PRO A 134      12.067 -41.774  19.138  1.00 31.05           C  
ATOM   1114  CD  PRO A 134      11.579 -40.973  17.992  1.00 30.92           C  
ATOM   1115  N   ASP A 135       8.207 -40.332  21.229  1.00 31.21           N  
ATOM   1116  CA  ASP A 135       7.571 -39.329  22.076  1.00 31.32           C  
ATOM   1117  C   ASP A 135       8.285 -39.312  23.429  1.00 31.47           C  
ATOM   1118  O   ASP A 135       7.968 -40.109  24.321  1.00 31.65           O  
ATOM   1119  CB  ASP A 135       6.088 -39.664  22.253  1.00 31.59           C  
ATOM   1120  CG  ASP A 135       5.290 -38.518  22.847  1.00 32.49           C  
ATOM   1121  OD1 ASP A 135       5.874 -37.457  23.169  1.00 33.64           O  
ATOM   1122  OD2 ASP A 135       4.057 -38.676  22.979  1.00 36.80           O  
ATOM   1123  N   VAL A 136       9.254 -38.414  23.572  1.00 31.19           N  
ATOM   1124  CA  VAL A 136      10.091 -38.363  24.780  1.00 31.07           C  
ATOM   1125  C   VAL A 136       9.774 -37.116  25.599  1.00 30.85           C  
ATOM   1126  O   VAL A 136       9.867 -36.009  25.088  1.00 30.72           O  
ATOM   1127  CB  VAL A 136      11.591 -38.365  24.434  1.00 31.14           C  
ATOM   1128  CG1 VAL A 136      12.424 -38.586  25.699  1.00 31.27           C  
ATOM   1129  CG2 VAL A 136      11.905 -39.442  23.402  1.00 31.26           C  
ATOM   1130  N   PRO A 137       9.401 -37.286  26.880  1.00 30.87           N  
ATOM   1131  CA  PRO A 137       9.145 -36.123  27.737  1.00 30.68           C  
ATOM   1132  C   PRO A 137      10.350 -35.197  27.899  1.00 30.50           C  
ATOM   1133  O   PRO A 137      11.496 -35.661  27.891  1.00 30.20           O  
ATOM   1134  CB  PRO A 137       8.785 -36.751  29.092  1.00 30.87           C  
ATOM   1135  CG  PRO A 137       8.413 -38.140  28.803  1.00 31.20           C  
ATOM   1136  CD  PRO A 137       9.171 -38.556  27.591  1.00 31.15           C  
ATOM   1137  N   LYS A 138      10.080 -33.906  28.074  1.00 30.25           N  
ATOM   1138  CA  LYS A 138      11.118 -32.898  28.269  1.00 30.27           C  
ATOM   1139  C   LYS A 138      12.065 -33.278  29.407  1.00 30.03           C  
ATOM   1140  O   LYS A 138      13.275 -33.121  29.277  1.00 29.61           O  
ATOM   1141  CB  LYS A 138      10.482 -31.525  28.541  1.00 30.65           C  
ATOM   1142  CG  LYS A 138      11.440 -30.408  28.946  0.50 30.58           C  
ATOM   1143  CD  LYS A 138      10.685 -29.090  29.139  0.50 30.90           C  
ATOM   1144  CE  LYS A 138      11.435 -28.128  30.047  0.50 31.41           C  
ATOM   1145  NZ  LYS A 138      10.636 -26.906  30.351  0.50 31.70           N  
ATOM   1146  N   VAL A 139      11.520 -33.771  30.519  1.00 29.78           N  
ATOM   1147  CA  VAL A 139      12.376 -34.125  31.668  1.00 29.37           C  
ATOM   1148  C   VAL A 139      13.345 -35.257  31.319  1.00 28.64           C  
ATOM   1149  O   VAL A 139      14.455 -35.311  31.843  1.00 28.06           O  
ATOM   1150  CB  VAL A 139      11.577 -34.503  32.953  1.00 29.59           C  
ATOM   1151  CG1 VAL A 139      10.758 -33.311  33.446  1.00 30.76           C  
ATOM   1152  CG2 VAL A 139      10.698 -35.703  32.730  1.00 30.32           C  
ATOM   1153  N   VAL A 140      12.914 -36.165  30.446  1.00 27.79           N  
ATOM   1154  CA  VAL A 140      13.763 -37.273  30.020  1.00 27.86           C  
ATOM   1155  C   VAL A 140      14.851 -36.772  29.061  1.00 27.24           C  
ATOM   1156  O   VAL A 140      16.007 -37.160  29.176  1.00 26.63           O  
ATOM   1157  CB  VAL A 140      12.933 -38.409  29.376  1.00 27.55           C  
ATOM   1158  CG1 VAL A 140      13.841 -39.490  28.813  1.00 27.94           C  
ATOM   1159  CG2 VAL A 140      11.980 -39.002  30.395  1.00 28.07           C  
ATOM   1160  N   LEU A 141      14.477 -35.904  28.122  1.00 27.39           N  
ATOM   1161  CA  LEU A 141      15.463 -35.203  27.291  1.00 27.64           C  
ATOM   1162  C   LEU A 141      16.487 -34.458  28.146  1.00 27.46           C  
ATOM   1163  O   LEU A 141      17.677 -34.502  27.851  1.00 27.63           O  
ATOM   1164  CB  LEU A 141      14.778 -34.205  26.347  1.00 28.17           C  
ATOM   1165  CG  LEU A 141      14.396 -34.619  24.916  1.00 30.11           C  
ATOM   1166  CD1 LEU A 141      14.383 -36.111  24.692  1.00 30.91           C  
ATOM   1167  CD2 LEU A 141      13.042 -34.012  24.541  1.00 31.75           C  
ATOM   1168  N   GLU A 142      16.015 -33.773  29.191  1.00 27.07           N  
ATOM   1169  CA  GLU A 142      16.903 -33.047  30.106  0.50 26.92           C  
ATOM   1171  C   GLU A 142      17.892 -33.998  30.781  1.00 26.50           C  
ATOM   1172  O   GLU A 142      19.098 -33.730  30.821  1.00 26.67           O  
ATOM   1173  CB  GLU A 142      16.092 -32.290  31.167  0.50 27.00           C  
ATOM   1175  CG  GLU A 142      15.326 -31.091  30.625  0.50 27.44           C  
ATOM   1177  CD  GLU A 142      14.422 -30.352  31.423  0.00 20.00           C  
ATOM   1179  OE1 GLU A 142      14.898 -29.254  31.776  0.00 20.00           O  
ATOM   1181  OE2 GLU A 142      13.305 -30.758  31.810  0.00 20.00           O  
ATOM   1183  N   ALA A 143      17.381 -35.107  31.302  1.00 26.17           N  
ATOM   1184  CA  ALA A 143      18.222 -36.127  31.912  1.00 25.98           C  
ATOM   1185  C   ALA A 143      19.255 -36.682  30.922  1.00 25.45           C  
ATOM   1186  O   ALA A 143      20.405 -36.888  31.275  1.00 24.28           O  
ATOM   1187  CB  ALA A 143      17.363 -37.247  32.469  1.00 25.93           C  
ATOM   1188  N   SER A 144      18.845 -36.920  29.680  1.00 25.66           N  
ATOM   1189  CA  SER A 144      19.777 -37.412  28.649  1.00 25.87           C  
ATOM   1190  C   SER A 144      20.885 -36.399  28.357  1.00 26.11           C  
ATOM   1191  O   SER A 144      22.054 -36.769  28.175  1.00 26.21           O  
ATOM   1192  CB  SER A 144      19.021 -37.758  27.364  1.00 26.15           C  
ATOM   1193  OG  SER A 144      18.244 -38.916  27.561  1.00 25.81           O  
ATOM   1194  N   ALA A 145      20.511 -35.124  28.330  1.00 26.28           N  
ATOM   1195  CA  ALA A 145      21.467 -34.030  28.147  1.00 26.29           C  
ATOM   1196  C   ALA A 145      22.457 -33.928  29.306  1.00 25.96           C  
ATOM   1197  O   ALA A 145      23.647 -33.748  29.081  1.00 26.35           O  
ATOM   1198  CB  ALA A 145      20.732 -32.724  27.968  1.00 26.55           C  
ATOM   1199  N   LYS A 146      21.963 -34.053  30.540  1.00 26.04           N  
ATOM   1200  CA  LYS A 146      22.818 -34.087  31.726  1.00 25.85           C  
ATOM   1201  C   LYS A 146      23.804 -35.253  31.651  1.00 25.12           C  
ATOM   1202  O   LYS A 146      24.989 -35.087  31.912  1.00 24.80           O  
ATOM   1203  CB  LYS A 146      21.982 -34.172  33.016  1.00 26.21           C  
ATOM   1204  CG  LYS A 146      21.405 -32.815  33.455  1.00 27.59           C  
ATOM   1205  CD  LYS A 146      20.090 -32.941  34.226  1.00 28.28           C  
ATOM   1206  CE  LYS A 146      20.271 -33.224  35.694  1.00 30.36           C  
ATOM   1207  NZ  LYS A 146      18.948 -33.128  36.418  1.00 30.53           N  
ATOM   1208  N   LEU A 147      23.311 -36.433  31.285  1.00 24.37           N  
ATOM   1209  CA  LEU A 147      24.176 -37.601  31.141  1.00 24.36           C  
ATOM   1210  C   LEU A 147      25.253 -37.390  30.079  1.00 24.15           C  
ATOM   1211  O   LEU A 147      26.422 -37.618  30.340  1.00 23.81           O  
ATOM   1212  CB  LEU A 147      23.360 -38.845  30.799  1.00 24.09           C  
ATOM   1213  CG  LEU A 147      24.151 -40.117  30.477  1.00 23.84           C  
ATOM   1214  CD1 LEU A 147      25.081 -40.550  31.598  1.00 23.61           C  
ATOM   1215  CD2 LEU A 147      23.179 -41.230  30.147  1.00 24.84           C  
ATOM   1216  N   ALA A 148      24.853 -36.959  28.886  1.00 24.70           N  
ATOM   1217  CA  ALA A 148      25.811 -36.735  27.790  1.00 25.29           C  
ATOM   1218  C   ALA A 148      26.918 -35.759  28.222  1.00 25.60           C  
ATOM   1219  O   ALA A 148      28.098 -35.995  27.959  1.00 26.51           O  
ATOM   1220  CB  ALA A 148      25.094 -36.222  26.550  1.00 25.77           C  
ATOM   1221  N   ALA A 149      26.531 -34.687  28.907  1.00 26.12           N  
ATOM   1222  CA  ALA A 149      27.488 -33.709  29.433  1.00 25.89           C  
ATOM   1223  C   ALA A 149      28.439 -34.326  30.448  1.00 25.88           C  
ATOM   1224  O   ALA A 149      29.639 -34.024  30.456  1.00 25.89           O  
ATOM   1225  CB  ALA A 149      26.749 -32.534  30.062  1.00 26.48           C  
ATOM   1226  N   ALA A 150      27.902 -35.195  31.305  1.00 25.29           N  
ATOM   1227  CA  ALA A 150      28.689 -35.862  32.330  1.00 25.24           C  
ATOM   1228  C   ALA A 150      29.721 -36.801  31.715  1.00 24.90           C  
ATOM   1229  O   ALA A 150      30.860 -36.872  32.174  1.00 24.23           O  
ATOM   1230  CB  ALA A 150      27.775 -36.632  33.290  1.00 25.05           C  
ATOM   1231  N   LEU A 151      29.313 -37.524  30.677  1.00 25.04           N  
ATOM   1232  CA  LEU A 151      30.217 -38.434  29.971  1.00 25.60           C  
ATOM   1233  C   LEU A 151      31.323 -37.665  29.243  1.00 26.16           C  
ATOM   1234  O   LEU A 151      32.485 -38.049  29.308  1.00 25.97           O  
ATOM   1235  CB  LEU A 151      29.439 -39.311  28.988  1.00 25.33           C  
ATOM   1236  CG  LEU A 151      28.453 -40.301  29.623  1.00 24.24           C  
ATOM   1237  CD1 LEU A 151      27.536 -40.900  28.563  1.00 24.93           C  
ATOM   1238  CD2 LEU A 151      29.186 -41.386  30.355  1.00 24.56           C  
ATOM   1239  N   GLU A 152      30.950 -36.582  28.564  1.00 27.66           N  
ATOM   1240  CA  GLU A 152      31.929 -35.707  27.912  1.00 27.83           C  
ATOM   1241  C   GLU A 152      32.933 -35.179  28.940  1.00 27.88           C  
ATOM   1242  O   GLU A 152      34.138 -35.166  28.698  1.00 28.35           O  
ATOM   1243  CB  GLU A 152      31.221 -34.548  27.200  1.00 28.58           C  
ATOM   1244  CG  GLU A 152      32.130 -33.644  26.353  1.00 30.27           C  
ATOM   1245  CD  GLU A 152      32.789 -34.361  25.172  1.00 36.05           C  
ATOM   1246  OE1 GLU A 152      32.307 -35.450  24.772  1.00 39.42           O  
ATOM   1247  OE2 GLU A 152      33.798 -33.827  24.640  1.00 39.54           O  
ATOM   1248  N   HIS A 153      32.432 -34.777  30.102  1.00 28.12           N  
ATOM   1249  CA  HIS A 153      33.285 -34.247  31.162  1.00 27.70           C  
ATOM   1250  C   HIS A 153      34.305 -35.269  31.650  1.00 27.34           C  
ATOM   1251  O   HIS A 153      35.474 -34.941  31.833  1.00 27.02           O  
ATOM   1252  CB  HIS A 153      32.442 -33.747  32.329  1.00 28.27           C  
ATOM   1253  CG  HIS A 153      33.149 -32.753  33.193  1.00 28.88           C  
ATOM   1254  ND1 HIS A 153      33.856 -33.111  34.316  1.00 30.43           N  
ATOM   1255  CD2 HIS A 153      33.258 -31.407  33.090  1.00 30.91           C  
ATOM   1256  CE1 HIS A 153      34.369 -32.029  34.875  1.00 30.17           C  
ATOM   1257  NE2 HIS A 153      34.018 -30.982  34.152  1.00 30.76           N  
ATOM   1258  N   HIS A 154      33.865 -36.511  31.856  1.00 26.68           N  
ATOM   1259  CA  HIS A 154      34.770 -37.593  32.230  1.00 26.48           C  
ATOM   1260  C   HIS A 154      35.907 -37.730  31.229  1.00 26.29           C  
ATOM   1261  O   HIS A 154      37.033 -38.008  31.599  1.00 24.87           O  
ATOM   1262  CB  HIS A 154      34.038 -38.938  32.306  1.00 26.05           C  
ATOM   1263  CG  HIS A 154      33.305 -39.157  33.591  1.00 25.22           C  
ATOM   1264  ND1 HIS A 154      33.948 -39.238  34.807  1.00 24.79           N  
ATOM   1265  CD2 HIS A 154      31.989 -39.341  33.847  1.00 24.26           C  
ATOM   1266  CE1 HIS A 154      33.054 -39.443  35.759  1.00 24.75           C  
ATOM   1267  NE2 HIS A 154      31.859 -39.510  35.204  1.00 24.01           N  
ATOM   1268  N   HIS A 155      35.595 -37.537  29.954  1.00 26.64           N  
ATOM   1269  CA  HIS A 155      36.572 -37.803  28.902  1.00 27.39           C  
ATOM   1270  C   HIS A 155      37.678 -36.752  28.817  1.00 27.75           C  
ATOM   1271  O   HIS A 155      38.714 -37.006  28.206  1.00 28.10           O  
ATOM   1272  CB  HIS A 155      35.867 -37.956  27.559  1.00 27.44           C  
ATOM   1273  CG  HIS A 155      34.878 -39.081  27.540  1.00 27.44           C  
ATOM   1274  ND1 HIS A 155      33.763 -39.080  26.732  1.00 27.76           N  
ATOM   1275  CD2 HIS A 155      34.823 -40.228  28.260  1.00 28.24           C  
ATOM   1276  CE1 HIS A 155      33.072 -40.189  26.940  1.00 28.04           C  
ATOM   1277  NE2 HIS A 155      33.690 -40.899  27.865  1.00 26.93           N  
ATOM   1278  N   HIS A 156      37.467 -35.595  29.439  1.00 27.88           N  
ATOM   1279  CA  HIS A 156      38.501 -34.558  29.501  1.00 28.82           C  
ATOM   1280  C   HIS A 156      39.003 -34.326  30.921  1.00 29.11           C  
ATOM   1281  O   HIS A 156      39.691 -33.337  31.184  1.00 28.61           O  
ATOM   1282  CB  HIS A 156      37.968 -33.263  28.907  1.00 29.05           C  
ATOM   1283  CG  HIS A 156      37.491 -33.413  27.500  1.00 30.57           C  
ATOM   1284  ND1 HIS A 156      38.354 -33.560  26.434  1.00 32.40           N  
ATOM   1285  CD2 HIS A 156      36.241 -33.470  26.985  1.00 31.79           C  
ATOM   1286  CE1 HIS A 156      37.652 -33.680  25.319  1.00 32.70           C  
ATOM   1287  NE2 HIS A 156      36.369 -33.629  25.627  1.00 32.66           N  
ATOM   1288  N   HIS A 157      38.666 -35.245  31.826  1.00 29.53           N  
ATOM   1289  CA  HIS A 157      39.120 -35.167  33.211  1.00 30.00           C  
ATOM   1290  C   HIS A 157      40.386 -35.993  33.405  1.00 30.39           C  
ATOM   1291  O   HIS A 157      40.486 -37.122  32.921  1.00 30.44           O  
ATOM   1292  CB  HIS A 157      38.035 -35.649  34.184  1.00 30.21           C  
ATOM   1293  CG  HIS A 157      38.544 -35.863  35.575  1.00 30.44           C  
ATOM   1294  ND1 HIS A 157      38.411 -34.921  36.571  1.00 31.65           N  
ATOM   1295  CD2 HIS A 157      39.220 -36.900  36.123  1.00 32.47           C  
ATOM   1296  CE1 HIS A 157      38.967 -35.378  37.679  1.00 32.16           C  
ATOM   1297  NE2 HIS A 157      39.474 -36.573  37.433  1.00 32.84           N  
ATOM   1298  N   HIS A 158      41.341 -35.441  34.149  1.00 30.78           N  
ATOM   1299  CA  HIS A 158      42.622 -36.100  34.371  1.00 31.27           C  
ATOM   1300  C   HIS A 158      42.983 -36.156  35.850  1.00 31.74           C  
ATOM   1301  O   HIS A 158      43.937 -36.820  36.244  1.00 32.38           O  
ATOM   1302  CB  HIS A 158      43.713 -35.385  33.584  1.00 31.57           C  
ATOM   1303  CG  HIS A 158      43.498 -35.422  32.106  1.00 31.85           C  
ATOM   1304  ND1 HIS A 158      44.125 -36.333  31.283  1.00 33.16           N  
ATOM   1305  CD2 HIS A 158      42.705 -34.674  31.306  1.00 32.22           C  
ATOM   1306  CE1 HIS A 158      43.736 -36.133  30.036  1.00 32.44           C  
ATOM   1307  NE2 HIS A 158      42.871 -35.135  30.024  1.00 32.89           N  
ATOM   1308  OXT HIS A 158      42.316 -35.566  36.692  1.00 32.54           O  
TER    1309      HIS A 158                                                      
END
MOLECULE T0475.pdb
ATOM     20  N   ASN     2       1.831  -2.392  -0.522  1.00  0.00
ATOM     21  HN  ASN     2       1.726  -2.331   0.453  1.00  0.00
ATOM     22  CA  ASN     2       2.075  -3.725  -1.109  1.00  0.00
ATOM     23  HA  ASN     2       2.284  -3.607  -2.174  1.00  0.00
ATOM     24  CB  ASN     2       3.299  -4.390  -0.422  1.00  0.00
ATOM     25  HB1 ASN     2       3.466  -5.372  -0.859  1.00  0.00
ATOM     26  HB2 ASN     2       3.089  -4.514   0.636  1.00  0.00
ATOM     27  CG  ASN     2       4.590  -3.576  -0.565  1.00  0.00
ATOM     28  OD1 ASN     2       5.324  -3.715  -1.546  1.00  0.00
ATOM     29  ND2 ASN     2       4.857  -2.700   0.401  1.00  0.00
ATOM     30 HD21 ASN     2       4.224  -2.628   1.148  1.00  0.00
ATOM     31 HD22 ASN     2       5.675  -2.167   0.331  1.00  0.00
ATOM     32  C   ASN     2       0.785  -4.553  -0.964  1.00  0.00
ATOM     33  O   ASN     2       0.810  -5.738  -0.618  1.00  0.00
ATOM     34  N   SER     3      -0.341  -3.891  -1.292  1.00  0.00
ATOM     35  HN  SER     3      -0.247  -3.002  -1.689  1.00  0.00
ATOM     36  CA  SER     3      -1.702  -4.409  -1.095  1.00  0.00
ATOM     37  HA  SER     3      -1.797  -4.700  -0.049  1.00  0.00
ATOM     38  CB  SER     3      -2.716  -3.279  -1.383  1.00  0.00
ATOM     39  HB1 SER     3      -2.599  -2.492  -0.645  1.00  0.00
ATOM     40  HB2 SER     3      -3.729  -3.660  -1.328  1.00  0.00
ATOM     41  OG  SER     3      -2.512  -2.719  -2.675  1.00  0.00
ATOM     42  HG  SER     3      -3.361  -2.595  -3.107  1.00  0.00
ATOM     43  C   SER     3      -1.979  -5.633  -1.981  1.00  0.00
ATOM     44  O   SER     3      -2.523  -6.626  -1.511  1.00  0.00
ATOM     45  N   GLU     4      -1.554  -5.549  -3.257  1.00  0.00
ATOM     46  HN  GLU     4      -1.122  -4.715  -3.539  1.00  0.00
ATOM     47  CA  GLU     4      -1.720  -6.638  -4.252  1.00  0.00
ATOM     48  HA  GLU     4      -2.760  -6.955  -4.203  1.00  0.00
ATOM     49  CB  GLU     4      -1.434  -6.132  -5.697  1.00  0.00
ATOM     50  HB1 GLU     4      -2.105  -5.307  -5.907  1.00  0.00
ATOM     51  HB2 GLU     4      -1.659  -6.934  -6.393  1.00  0.00
ATOM     52  CG  GLU     4       0.018  -5.661  -5.984  1.00  0.00
ATOM     53  HG1 GLU     4       0.166  -5.630  -7.063  1.00  0.00
ATOM     54  HG2 GLU     4       0.703  -6.396  -5.571  1.00  0.00
ATOM     55  CD  GLU     4       0.366  -4.277  -5.399  1.00  0.00
ATOM     56  OE1 GLU     4       0.009  -3.255  -6.022  1.00  0.00
ATOM     57  OE2 GLU     4       0.991  -4.208  -4.319  1.00  0.00
ATOM     58  C   GLU     4      -0.837  -7.869  -3.943  1.00  0.00
ATOM     59  O   GLU     4      -0.931  -8.886  -4.637  1.00  0.00
ATOM     60  N   ILE     5       0.041  -7.744  -2.937  1.00  0.00
ATOM     61  HN  ILE     5       0.146  -6.866  -2.519  1.00  0.00
ATOM     62  CA  ILE     5       0.867  -8.854  -2.432  1.00  0.00
ATOM     63  HA  ILE     5       0.966  -9.608  -3.214  1.00  0.00
ATOM     64  CB  ILE     5       2.303  -8.347  -2.025  1.00  0.00
ATOM     65  HB  ILE     5       2.196  -7.811  -1.085  1.00  0.00
ATOM     66  CG1 ILE     5       2.896  -7.353  -3.082  1.00  0.00
ATOM     67 HG11 ILE     5       3.865  -7.007  -2.738  1.00  0.00
ATOM     68 HG12 ILE     5       2.244  -6.502  -3.163  1.00  0.00
ATOM     69  CG2 ILE     5       3.271  -9.523  -1.775  1.00  0.00
ATOM     70 HG21 ILE     5       4.228  -9.142  -1.435  1.00  0.00
ATOM     71 HG22 ILE     5       3.417 -10.078  -2.691  1.00  0.00
ATOM     72 HG23 ILE     5       2.862 -10.182  -1.021  1.00  0.00
ATOM     73  CD1 ILE     5       3.082  -7.904  -4.488  1.00  0.00
ATOM     74 HD11 ILE     5       2.126  -8.218  -4.887  1.00  0.00
ATOM     75 HD12 ILE     5       3.755  -8.751  -4.459  1.00  0.00
ATOM     76 HD13 ILE     5       3.501  -7.137  -5.121  1.00  0.00
ATOM     77  C   ILE     5       0.167  -9.486  -1.207  1.00  0.00
ATOM     78  O   ILE     5       0.309 -10.683  -0.936  1.00  0.00
ATOM     79  N   GLU     6      -0.598  -8.649  -0.477  1.00  0.00
ATOM     80  HN  GLU     6      -0.624  -7.699  -0.730  1.00  0.00
ATOM     81  CA  GLU     6      -1.393  -9.075   0.691  1.00  0.00
ATOM     82  HA  GLU     6      -0.790  -9.767   1.280  1.00  0.00
ATOM     83  CB  GLU     6      -1.739  -7.844   1.574  1.00  0.00
ATOM     84  HB1 GLU     6      -2.373  -8.164   2.398  1.00  0.00
ATOM     85  HB2 GLU     6      -2.291  -7.131   0.971  1.00  0.00
ATOM     86  CG  GLU     6      -0.519  -7.120   2.167  1.00  0.00
ATOM     87  HG1 GLU     6       0.145  -6.834   1.353  1.00  0.00
ATOM     88  HG2 GLU     6       0.011  -7.810   2.816  1.00  0.00
ATOM     89  CD  GLU     6      -0.894  -5.858   2.968  1.00  0.00
ATOM     90  OE1 GLU     6      -1.011  -5.932   4.215  1.00  0.00
ATOM     91  OE2 GLU     6      -1.101  -4.793   2.350  1.00  0.00
ATOM     92  C   GLU     6      -2.691  -9.790   0.261  1.00  0.00
ATOM     93  O   GLU     6      -3.153 -10.698   0.961  1.00  0.00
ATOM     94  N   LEU     7      -3.271  -9.367  -0.887  1.00  0.00
ATOM     95  HN  LEU     7      -2.808  -8.685  -1.417  1.00  0.00
ATOM     96  CA  LEU     7      -4.562  -9.911  -1.391  1.00  0.00
ATOM     97  HA  LEU     7      -5.292  -9.732  -0.607  1.00  0.00
ATOM     98  CB  LEU     7      -5.054  -9.182  -2.681  1.00  0.00
ATOM     99  HB1 LEU     7      -5.975  -9.663  -3.009  1.00  0.00
ATOM    100  HB2 LEU     7      -4.310  -9.334  -3.456  1.00  0.00
ATOM    101  CG  LEU     7      -5.325  -7.651  -2.562  1.00  0.00
ATOM    102  HG  LEU     7      -4.402  -7.168  -2.287  1.00  0.00
ATOM    103  CD1 LEU     7      -5.756  -7.043  -3.913  1.00  0.00
ATOM    104 HD11 LEU     7      -6.661  -7.526  -4.269  1.00  0.00
ATOM    105 HD12 LEU     7      -4.968  -7.181  -4.640  1.00  0.00
ATOM    106 HD13 LEU     7      -5.941  -5.982  -3.792  1.00  0.00
ATOM    107  CD2 LEU     7      -6.353  -7.346  -1.453  1.00  0.00
ATOM    108 HD21 LEU     7      -5.982  -7.713  -0.505  1.00  0.00
ATOM    109 HD22 LEU     7      -7.295  -7.830  -1.678  1.00  0.00
ATOM    110 HD23 LEU     7      -6.509  -6.276  -1.383  1.00  0.00
ATOM    111  C   LEU     7      -4.504 -11.450  -1.632  1.00  0.00
ATOM    112  O   LEU     7      -5.411 -12.157  -1.175  1.00  0.00
ATOM    113  N   PRO     8      -3.462 -12.011  -2.364  1.00  0.00
ATOM    114  CA  PRO     8      -3.309 -13.478  -2.527  1.00  0.00
ATOM    115  HA  PRO     8      -4.145 -13.893  -3.088  1.00  0.00
ATOM    116  CB  PRO     8      -1.994 -13.649  -3.366  1.00  0.00
ATOM    117  HB1 PRO     8      -2.245 -13.908  -4.388  1.00  0.00
ATOM    118  HB2 PRO     8      -1.376 -14.442  -2.953  1.00  0.00
ATOM    119  CG  PRO     8      -1.308 -12.325  -3.298  1.00  0.00
ATOM    120  HG1 PRO     8      -0.750 -12.142  -4.212  1.00  0.00
ATOM    121  HG2 PRO     8      -0.632 -12.298  -2.447  1.00  0.00
ATOM    122  CD  PRO     8      -2.402 -11.297  -3.131  1.00  0.00
ATOM    123  HD1 PRO     8      -2.780 -10.972  -4.098  1.00  0.00
ATOM    124  HD2 PRO     8      -2.035 -10.447  -2.573  1.00  0.00
ATOM    125  C   PRO     8      -3.231 -14.208  -1.181  1.00  0.00
ATOM    126  O   PRO     8      -4.115 -14.994  -0.842  1.00  0.00
ATOM    127  N   VAL     9      -2.209 -13.860  -0.401  1.00  0.00
ATOM    128  HN  VAL     9      -1.703 -13.049  -0.636  1.00  0.00
ATOM    129  CA  VAL     9      -1.812 -14.612   0.800  1.00  0.00
ATOM    130  HA  VAL     9      -1.660 -15.641   0.491  1.00  0.00
ATOM    131  CB  VAL     9      -0.455 -14.070   1.348  1.00  0.00
ATOM    132  HB  VAL     9      -0.147 -14.712   2.173  1.00  0.00
ATOM    133  CG1 VAL     9       0.641 -14.156   0.254  1.00  0.00
ATOM    134 HG11 VAL     9       0.368 -13.532  -0.588  1.00  0.00
ATOM    135 HG12 VAL     9       0.746 -15.182  -0.082  1.00  0.00
ATOM    136 HG13 VAL     9       1.587 -13.820   0.657  1.00  0.00
ATOM    137  CG2 VAL     9      -0.593 -12.627   1.896  1.00  0.00
ATOM    138 HG21 VAL     9      -0.958 -11.972   1.115  1.00  0.00
ATOM    139 HG22 VAL     9       0.366 -12.271   2.239  1.00  0.00
ATOM    140 HG23 VAL     9      -1.292 -12.614   2.725  1.00  0.00
ATOM    141  C   VAL     9      -2.901 -14.601   1.905  1.00  0.00
ATOM    142  O   VAL     9      -3.020 -15.564   2.666  1.00  0.00
ATOM    143  N   GLN    10      -3.705 -13.515   1.950  1.00  0.00
ATOM    144  HN  GLN    10      -3.532 -12.787   1.318  1.00  0.00
ATOM    145  CA  GLN    10      -4.839 -13.376   2.888  1.00  0.00
ATOM    146  HA  GLN    10      -4.480 -13.600   3.893  1.00  0.00
ATOM    147  CB  GLN    10      -5.375 -11.914   2.859  1.00  0.00
ATOM    148  HB1 GLN    10      -5.608 -11.659   1.829  1.00  0.00
ATOM    149  HB2 GLN    10      -4.587 -11.252   3.197  1.00  0.00
ATOM    150  CG  GLN    10      -6.630 -11.627   3.718  1.00  0.00
ATOM    151  HG1 GLN    10      -7.444 -12.248   3.358  1.00  0.00
ATOM    152  HG2 GLN    10      -6.905 -10.587   3.587  1.00  0.00
ATOM    153  CD  GLN    10      -6.435 -11.892   5.211  1.00  0.00
ATOM    154  OE1 GLN    10      -6.001 -11.016   5.954  1.00  0.00
ATOM    155  NE2 GLN    10      -6.762 -13.097   5.655  1.00  0.00
ATOM    156 HE21 GLN    10      -7.111 -13.751   5.008  1.00  0.00
ATOM    157 HE22 GLN    10      -6.644 -13.289   6.609  1.00  0.00
ATOM    158  C   GLN    10      -5.951 -14.368   2.514  1.00  0.00
ATOM    159  O   GLN    10      -6.354 -15.200   3.335  1.00  0.00
ATOM    160  N   LYS    11      -6.395 -14.286   1.244  1.00  0.00
ATOM    161  HN  LYS    11      -5.949 -13.656   0.636  1.00  0.00
ATOM    162  CA  LYS    11      -7.508 -15.103   0.710  1.00  0.00
ATOM    163  HA  LYS    11      -8.378 -14.924   1.338  1.00  0.00
ATOM    164  CB  LYS    11      -7.846 -14.648  -0.732  1.00  0.00
ATOM    165  HB1 LYS    11      -8.562 -15.342  -1.167  1.00  0.00
ATOM    166  HB2 LYS    11      -6.938 -14.674  -1.329  1.00  0.00
ATOM    167  CG  LYS    11      -8.439 -13.225  -0.830  1.00  0.00
ATOM    168  HG1 LYS    11      -8.591 -12.983  -1.878  1.00  0.00
ATOM    169  HG2 LYS    11      -7.731 -12.521  -0.403  1.00  0.00
ATOM    170  CD  LYS    11      -9.782 -13.097  -0.085  1.00  0.00
ATOM    171  HD1 LYS    11      -9.626 -13.325   0.969  1.00  0.00
ATOM    172  HD2 LYS    11     -10.482 -13.816  -0.497  1.00  0.00
ATOM    173  CE  LYS    11     -10.403 -11.699  -0.200  1.00  0.00
ATOM    174  HE1 LYS    11     -10.562 -11.460  -1.242  1.00  0.00
ATOM    175  HE2 LYS    11      -9.730 -10.971   0.239  1.00  0.00
ATOM    176  NZ  LYS    11     -11.702 -11.633   0.510  1.00  0.00
ATOM    177  HZ1 LYS    11     -12.109 -10.686   0.416  1.00  0.00
ATOM    178  HZ2 LYS    11     -11.567 -11.843   1.519  1.00  0.00
ATOM    179  HZ3 LYS    11     -12.367 -12.326   0.112  1.00  0.00
ATOM    180  C   LYS    11      -7.180 -16.603   0.734  1.00  0.00
ATOM    181  O   LYS    11      -8.057 -17.429   0.977  1.00  0.00
ATOM    182  N   GLN    12      -5.904 -16.925   0.497  1.00  0.00
ATOM    183  HN  GLN    12      -5.262 -16.197   0.364  1.00  0.00
ATOM    184  CA  GLN    12      -5.412 -18.308   0.438  1.00  0.00
ATOM    185  HA  GLN    12      -6.116 -18.882  -0.161  1.00  0.00
ATOM    186  CB  GLN    12      -4.038 -18.347  -0.253  1.00  0.00
ATOM    187  HB1 GLN    12      -3.615 -19.342  -0.140  1.00  0.00
ATOM    188  HB2 GLN    12      -3.378 -17.634   0.241  1.00  0.00
ATOM    189  CG  GLN    12      -4.076 -18.013  -1.754  1.00  0.00
ATOM    190  HG1 GLN    12      -4.619 -17.084  -1.892  1.00  0.00
ATOM    191  HG2 GLN    12      -4.592 -18.806  -2.280  1.00  0.00
ATOM    192  CD  GLN    12      -2.692 -17.850  -2.370  1.00  0.00
ATOM    193  OE1 GLN    12      -2.513 -17.092  -3.318  1.00  0.00
ATOM    194  NE2 GLN    12      -1.704 -18.584  -1.862  1.00  0.00
ATOM    195 HE21 GLN    12      -1.901 -19.190  -1.120  1.00  0.00
ATOM    196 HE22 GLN    12      -0.821 -18.502  -2.263  1.00  0.00
ATOM    197  C   GLN    12      -5.310 -18.928   1.840  1.00  0.00
ATOM    198  O   GLN    12      -5.658 -20.085   2.024  1.00  0.00
ATOM    199  N   LEU    13      -4.802 -18.148   2.810  1.00  0.00
ATOM    200  HN  LEU    13      -4.515 -17.235   2.577  1.00  0.00
ATOM    201  CA  LEU    13      -4.660 -18.600   4.211  1.00  0.00
ATOM    202  HA  LEU    13      -4.023 -19.485   4.218  1.00  0.00
ATOM    203  CB  LEU    13      -4.000 -17.499   5.062  1.00  0.00
ATOM    204  HB1 LEU    13      -4.586 -16.593   4.943  1.00  0.00
ATOM    205  HB2 LEU    13      -3.007 -17.308   4.661  1.00  0.00
ATOM    206  CG  LEU    13      -3.869 -17.811   6.587  1.00  0.00
ATOM    207  HG  LEU    13      -4.781 -18.277   6.921  1.00  0.00
ATOM    208  CD1 LEU    13      -2.741 -18.824   6.881  1.00  0.00
ATOM    209 HD11 LEU    13      -2.683 -19.003   7.947  1.00  0.00
ATOM    210 HD12 LEU    13      -1.792 -18.435   6.532  1.00  0.00
ATOM    211 HD13 LEU    13      -2.952 -19.760   6.376  1.00  0.00
ATOM    212  CD2 LEU    13      -3.726 -16.522   7.391  1.00  0.00
ATOM    213 HD21 LEU    13      -3.726 -16.755   8.445  1.00  0.00
ATOM    214 HD22 LEU    13      -4.561 -15.868   7.172  1.00  0.00
ATOM    215 HD23 LEU    13      -2.801 -16.024   7.132  1.00  0.00
ATOM    216  C   LEU    13      -6.039 -18.958   4.803  1.00  0.00
ATOM    217  O   LEU    13      -6.199 -20.004   5.451  1.00  0.00
ATOM    218  N   GLU    14      -7.012 -18.054   4.579  1.00  0.00
ATOM    219  HN  GLU    14      -6.762 -17.194   4.166  1.00  0.00
ATOM    220  CA  GLU    14      -8.427 -18.274   4.938  1.00  0.00
ATOM    221  HA  GLU    14      -8.482 -18.402   6.018  1.00  0.00
ATOM    222  CB  GLU    14      -9.279 -17.045   4.529  1.00  0.00
ATOM    223  HB1 GLU    14     -10.327 -17.249   4.740  1.00  0.00
ATOM    224  HB2 GLU    14      -9.167 -16.886   3.459  1.00  0.00
ATOM    225  CG  GLU    14      -8.896 -15.744   5.249  1.00  0.00
ATOM    226  HG1 GLU    14      -7.833 -15.558   5.093  1.00  0.00
ATOM    227  HG2 GLU    14      -9.070 -15.875   6.311  1.00  0.00
ATOM    228  CD  GLU    14      -9.693 -14.526   4.750  1.00  0.00
ATOM    229  OE1 GLU    14     -10.749 -14.201   5.342  1.00  0.00
ATOM    230  OE2 GLU    14      -9.272 -13.890   3.756  1.00  0.00
ATOM    231  C   GLU    14      -8.950 -19.548   4.253  1.00  0.00
ATOM    232  O   GLU    14      -9.468 -20.433   4.916  1.00  0.00
ATOM    233  N   ALA    15      -8.711 -19.634   2.933  1.00  0.00
ATOM    234  HN  ALA    15      -8.204 -18.905   2.512  1.00  0.00
ATOM    235  CA  ALA    15      -9.156 -20.758   2.076  1.00  0.00
ATOM    236  HA  ALA    15     -10.235 -20.852   2.189  1.00  0.00
ATOM    237  CB  ALA    15      -8.862 -20.438   0.601  1.00  0.00
ATOM    238  HB1 ALA    15      -7.792 -20.355   0.451  1.00  0.00
ATOM    239  HB2 ALA    15      -9.327 -19.499   0.328  1.00  0.00
ATOM    240  HB3 ALA    15      -9.255 -21.223  -0.034  1.00  0.00
ATOM    241  C   ALA    15      -8.495 -22.102   2.478  1.00  0.00
ATOM    242  O   ALA    15      -9.058 -23.168   2.217  1.00  0.00
ATOM    243  N   TYR    16      -7.294 -22.028   3.098  1.00  0.00
ATOM    244  HN  TYR    16      -6.919 -21.135   3.279  1.00  0.00
ATOM    245  CA  TYR    16      -6.514 -23.215   3.518  1.00  0.00
ATOM    246  HA  TYR    16      -6.377 -23.844   2.639  1.00  0.00
ATOM    247  CB  TYR    16      -5.116 -22.780   4.043  1.00  0.00
ATOM    248  HB1 TYR    16      -5.253 -22.145   4.912  1.00  0.00
ATOM    249  HB2 TYR    16      -4.621 -22.198   3.274  1.00  0.00
ATOM    250  CG  TYR    16      -4.166 -23.936   4.432  1.00  0.00
ATOM    251  CD1 TYR    16      -3.688 -24.087   5.742  1.00  0.00
ATOM    252  HD1 TYR    16      -3.991 -23.371   6.499  1.00  0.00
ATOM    253  CD2 TYR    16      -3.752 -24.875   3.481  1.00  0.00
ATOM    254  HD2 TYR    16      -4.105 -24.781   2.460  1.00  0.00
ATOM    255  CE1 TYR    16      -2.836 -25.128   6.080  1.00  0.00
ATOM    256  HE1 TYR    16      -2.482 -25.225   7.100  1.00  0.00
ATOM    257  CE2 TYR    16      -2.904 -25.913   3.816  1.00  0.00
ATOM    258  HE2 TYR    16      -2.602 -26.625   3.059  1.00  0.00
ATOM    259  CZ  TYR    16      -2.448 -26.037   5.113  1.00  0.00
ATOM    260  OH  TYR    16      -1.602 -27.080   5.440  1.00  0.00
ATOM    261  HH  TYR    16      -1.856 -27.442   6.292  1.00  0.00
ATOM    262  C   TYR    16      -7.276 -24.016   4.589  1.00  0.00
ATOM    263  O   TYR    16      -7.355 -25.252   4.525  1.00  0.00
ATOM    264  N   ASN    17      -7.845 -23.289   5.560  1.00  0.00
ATOM    265  HN  ASN    17      -7.732 -22.312   5.539  1.00  0.00
ATOM    266  CA  ASN    17      -8.637 -23.887   6.651  1.00  0.00
ATOM    267  HA  ASN    17      -8.283 -24.908   6.797  1.00  0.00
ATOM    268  CB  ASN    17      -8.405 -23.104   7.979  1.00  0.00
ATOM    269  HB1 ASN    17      -7.345 -23.123   8.218  1.00  0.00
ATOM    270  HB2 ASN    17      -8.938 -23.600   8.780  1.00  0.00
ATOM    271  CG  ASN    17      -8.859 -21.642   7.940  1.00  0.00
ATOM    272  OD1 ASN    17      -9.998 -21.326   8.280  1.00  0.00
ATOM    273  ND2 ASN    17      -7.969 -20.740   7.540  1.00  0.00
ATOM    274 HD21 ASN    17      -7.069 -21.047   7.289  1.00  0.00
ATOM    275 HD22 ASN    17      -8.244 -19.800   7.514  1.00  0.00
ATOM    276  C   ASN    17     -10.139 -23.952   6.270  1.00  0.00
ATOM    277  O   ASN    17     -10.847 -24.858   6.711  1.00  0.00
ATOM    278  N   ALA    18     -10.592 -23.015   5.405  1.00  0.00
ATOM    279  HN  ALA    18      -9.945 -22.382   5.033  1.00  0.00
ATOM    280  CA  ALA    18     -12.017 -22.899   4.977  1.00  0.00
ATOM    281  HA  ALA    18     -12.645 -23.109   5.841  1.00  0.00
ATOM    282  CB  ALA    18     -12.330 -21.469   4.502  1.00  0.00
ATOM    283  HB1 ALA    18     -12.057 -20.761   5.270  1.00  0.00
ATOM    284  HB2 ALA    18     -13.389 -21.372   4.287  1.00  0.00
ATOM    285  HB3 ALA    18     -11.764 -21.251   3.601  1.00  0.00
ATOM    286  C   ALA    18     -12.372 -23.904   3.864  1.00  0.00
ATOM    287  O   ALA    18     -13.549 -24.058   3.525  1.00  0.00
ATOM    288  N   ARG    19     -11.335 -24.564   3.304  1.00  0.00
ATOM    289  HN  ARG    19     -10.428 -24.285   3.558  1.00  0.00
ATOM    290  CA  ARG    19     -11.463 -25.664   2.322  1.00  0.00
ATOM    291  HA  ARG    19     -10.461 -26.039   2.155  1.00  0.00
ATOM    292  CB  ARG    19     -12.324 -26.837   2.881  1.00  0.00
ATOM    293  HB1 ARG    19     -12.258 -27.674   2.191  1.00  0.00
ATOM    294  HB2 ARG    19     -13.358 -26.514   2.925  1.00  0.00
ATOM    295  CG  ARG    19     -11.926 -27.336   4.286  1.00  0.00
ATOM    296  HG1 ARG    19     -12.522 -28.212   4.517  1.00  0.00
ATOM    297  HG2 ARG    19     -12.152 -26.559   5.010  1.00  0.00
ATOM    298  CD  ARG    19     -10.443 -27.704   4.416  1.00  0.00
ATOM    299  HD1 ARG    19      -9.841 -26.820   4.237  1.00  0.00
ATOM    300  HD2 ARG    19     -10.192 -28.462   3.681  1.00  0.00
ATOM    301  NE  ARG    19     -10.151 -28.205   5.768  1.00  0.00
ATOM    302  HE  ARG    19      -9.995 -27.527   6.467  1.00  0.00
ATOM    303  CZ  ARG    19     -10.113 -29.498   6.120  1.00  0.00
ATOM    304  NH1 ARG    19     -10.315 -30.461   5.228  1.00  0.00
ATOM    305 HH11 ARG    19     -10.508 -30.236   4.271  1.00  0.00
ATOM    306 HH12 ARG    19     -10.261 -31.424   5.505  1.00  0.00
ATOM    307  NH2 ARG    19      -9.892 -29.827   7.378  1.00  0.00
ATOM    308 HH21 ARG    19      -9.761 -29.112   8.073  1.00  0.00
ATOM    309 HH22 ARG    19      -9.844 -30.791   7.648  1.00  0.00
ATOM    310  C   ARG    19     -11.996 -25.167   0.958  1.00  0.00
ATOM    311  O   ARG    19     -12.864 -25.800   0.338  1.00  0.00
ATOM    312  N   ASP    20     -11.443 -24.037   0.485  1.00  0.00
ATOM    313  HN  ASP    20     -10.788 -23.570   1.041  1.00  0.00
ATOM    314  CA  ASP    20     -11.769 -23.468  -0.838  1.00  0.00
ATOM    315  HA  ASP    20     -12.541 -24.077  -1.307  1.00  0.00
ATOM    316  CB  ASP    20     -12.309 -22.010  -0.689  1.00  0.00
ATOM    317  HB1 ASP    20     -12.380 -21.558  -1.674  1.00  0.00
ATOM    318  HB2 ASP    20     -11.601 -21.429  -0.100  1.00  0.00
ATOM    319  CG  ASP    20     -13.689 -21.930  -0.008  1.00  0.00
ATOM    320  OD1 ASP    20     -13.750 -21.843   1.238  1.00  0.00
ATOM    321  OD2 ASP    20     -14.720 -21.948  -0.721  1.00  0.00
ATOM    322  C   ASP    20     -10.514 -23.492  -1.734  1.00  0.00
ATOM    323  O   ASP    20      -9.717 -22.558  -1.696  1.00  0.00
ATOM    324  N   ILE    21     -10.357 -24.561  -2.547  1.00  0.00
ATOM    325  HN  ILE    21     -11.052 -25.252  -2.550  1.00  0.00
ATOM    326  CA  ILE    21      -9.181 -24.730  -3.438  1.00  0.00
ATOM    327  HA  ILE    21      -8.300 -24.483  -2.847  1.00  0.00
ATOM    328  CB  ILE    21      -9.016 -26.233  -3.930  1.00  0.00
ATOM    329  HB  ILE    21     -10.004 -26.599  -4.190  1.00  0.00
ATOM    330  CG1 ILE    21      -8.453 -27.132  -2.779  1.00  0.00
ATOM    331 HG11 ILE    21      -8.531 -28.173  -3.071  1.00  0.00
ATOM    332 HG12 ILE    21      -9.039 -26.979  -1.884  1.00  0.00
ATOM    333  CG2 ILE    21      -8.127 -26.369  -5.205  1.00  0.00
ATOM    334 HG21 ILE    21      -8.582 -25.828  -6.025  1.00  0.00
ATOM    335 HG22 ILE    21      -8.032 -27.412  -5.477  1.00  0.00
ATOM    336 HG23 ILE    21      -7.143 -25.959  -5.009  1.00  0.00
ATOM    337  CD1 ILE    21      -6.996 -26.864  -2.418  1.00  0.00
ATOM    338 HD11 ILE    21      -6.719 -27.483  -1.577  1.00  0.00
ATOM    339 HD12 ILE    21      -6.874 -25.824  -2.152  1.00  0.00
ATOM    340 HD13 ILE    21      -6.361 -27.100  -3.261  1.00  0.00
ATOM    341  C   ILE    21      -9.226 -23.742  -4.620  1.00  0.00
ATOM    342  O   ILE    21      -8.175 -23.315  -5.100  1.00  0.00
ATOM    343  N   ASP    22     -10.438 -23.351  -5.061  1.00  0.00
ATOM    344  HN  ASP    22     -11.243 -23.708  -4.615  1.00  0.00
ATOM    345  CA  ASP    22     -10.607 -22.411  -6.196  1.00  0.00
ATOM    346  HA  ASP    22     -10.117 -22.864  -7.058  1.00  0.00
ATOM    347  CB  ASP    22     -12.108 -22.225  -6.538  1.00  0.00
ATOM    348  HB1 ASP    22     -12.633 -21.874  -5.655  1.00  0.00
ATOM    349  HB2 ASP    22     -12.527 -23.188  -6.818  1.00  0.00
ATOM    350  CG  ASP    22     -12.355 -21.231  -7.695  1.00  0.00
ATOM    351  OD1 ASP    22     -12.735 -20.066  -7.435  1.00  0.00
ATOM    352  OD2 ASP    22     -12.135 -21.609  -8.867  1.00  0.00
ATOM    353  C   ASP    22      -9.928 -21.047  -5.907  1.00  0.00
ATOM    354  O   ASP    22      -9.220 -20.518  -6.762  1.00  0.00
ATOM    355  N   ALA    23     -10.136 -20.511  -4.691  1.00  0.00
ATOM    356  HN  ALA    23     -10.740 -20.975  -4.074  1.00  0.00
ATOM    357  CA  ALA    23      -9.486 -19.252  -4.239  1.00  0.00
ATOM    358  HA  ALA    23      -9.458 -18.561  -5.080  1.00  0.00
ATOM    359  CB  ALA    23     -10.297 -18.602  -3.105  1.00  0.00
ATOM    360  HB1 ALA    23      -9.839 -17.662  -2.810  1.00  0.00
ATOM    361  HB2 ALA    23     -10.332 -19.265  -2.252  1.00  0.00
ATOM    362  HB3 ALA    23     -11.309 -18.413  -3.447  1.00  0.00
ATOM    363  C   ALA    23      -8.040 -19.511  -3.791  1.00  0.00
ATOM    364  O   ALA    23      -7.160 -18.659  -3.967  1.00  0.00
ATOM    365  N   PHE    24      -7.810 -20.712  -3.236  1.00  0.00
ATOM    366  HN  PHE    24      -8.575 -21.307  -3.083  1.00  0.00
ATOM    367  CA  PHE    24      -6.473 -21.176  -2.830  1.00  0.00
ATOM    368  HA  PHE    24      -6.009 -20.382  -2.243  1.00  0.00
ATOM    369  CB  PHE    24      -6.615 -22.440  -1.934  1.00  0.00
ATOM    370  HB1 PHE    24      -6.963 -23.265  -2.547  1.00  0.00
ATOM    371  HB2 PHE    24      -7.362 -22.246  -1.173  1.00  0.00
ATOM    372  CG  PHE    24      -5.339 -22.878  -1.225  1.00  0.00
ATOM    373  CD1 PHE    24      -4.521 -23.871  -1.754  1.00  0.00
ATOM    374  HD1 PHE    24      -4.808 -24.367  -2.671  1.00  0.00
ATOM    375  CD2 PHE    24      -4.940 -22.263  -0.047  1.00  0.00
ATOM    376  HD2 PHE    24      -5.561 -21.491   0.389  1.00  0.00
ATOM    377  CE1 PHE    24      -3.356 -24.232  -1.120  1.00  0.00
ATOM    378  HE1 PHE    24      -2.732 -25.002  -1.545  1.00  0.00
ATOM    379  CE2 PHE    24      -3.775 -22.635   0.590  1.00  0.00
ATOM    380  HE2 PHE    24      -3.483 -22.147   1.511  1.00  0.00
ATOM    381  CZ  PHE    24      -2.979 -23.615   0.050  1.00  0.00
ATOM    382  HZ  PHE    24      -2.058 -23.904   0.544  1.00  0.00
ATOM    383  C   PHE    24      -5.585 -21.459  -4.071  1.00  0.00
ATOM    384  O   PHE    24      -4.392 -21.704  -3.933  1.00  0.00
ATOM    385  N   MET    25      -6.184 -21.461  -5.282  1.00  0.00
ATOM    386  HN  MET    25      -7.161 -21.385  -5.318  1.00  0.00
ATOM    387  CA  MET    25      -5.445 -21.605  -6.559  1.00  0.00
ATOM    388  HA  MET    25      -4.407 -21.823  -6.325  1.00  0.00
ATOM    389  CB  MET    25      -6.016 -22.776  -7.413  1.00  0.00
ATOM    390  HB1 MET    25      -7.067 -22.579  -7.602  1.00  0.00
ATOM    391  HB2 MET    25      -5.940 -23.689  -6.834  1.00  0.00
ATOM    392  CG  MET    25      -5.310 -23.025  -8.775  1.00  0.00
ATOM    393  HG1 MET    25      -5.016 -22.072  -9.200  1.00  0.00
ATOM    394  HG2 MET    25      -6.019 -23.489  -9.446  1.00  0.00
ATOM    395  SD  MET    25      -3.840 -24.101  -8.708  1.00  0.00
ATOM    396  CE  MET    25      -2.690 -23.286  -7.583  1.00  0.00
ATOM    397  HE1 MET    25      -1.756 -23.833  -7.570  1.00  0.00
ATOM    398  HE2 MET    25      -3.107 -23.276  -6.587  1.00  0.00
ATOM    399  HE3 MET    25      -2.510 -22.271  -7.910  1.00  0.00
ATOM    400  C   MET    25      -5.483 -20.303  -7.374  1.00  0.00
ATOM    401  O   MET    25      -4.536 -20.015  -8.120  1.00  0.00
ATOM    402  N   ALA    26      -6.576 -19.524  -7.206  1.00  0.00
ATOM    403  HN  ALA    26      -7.206 -19.764  -6.502  1.00  0.00
ATOM    404  CA  ALA    26      -6.870 -18.324  -8.030  1.00  0.00
ATOM    405  HA  ALA    26      -7.098 -18.668  -9.039  1.00  0.00
ATOM    406  CB  ALA    26      -8.111 -17.596  -7.486  1.00  0.00
ATOM    407  HB1 ALA    26      -8.955 -18.274  -7.463  1.00  0.00
ATOM    408  HB2 ALA    26      -8.354 -16.752  -8.122  1.00  0.00
ATOM    409  HB3 ALA    26      -7.918 -17.241  -6.478  1.00  0.00
ATOM    410  C   ALA    26      -5.690 -17.354  -8.081  1.00  0.00
ATOM    411  O   ALA    26      -5.165 -17.037  -9.147  1.00  0.00
ATOM    412  N   TRP    27      -5.237 -16.978  -6.894  1.00  0.00
ATOM    413  HN  TRP    27      -5.569 -17.449  -6.099  1.00  0.00
ATOM    414  CA  TRP    27      -4.272 -15.899  -6.699  1.00  0.00
ATOM    415  HA  TRP    27      -4.541 -15.083  -7.366  1.00  0.00
ATOM    416  CB  TRP    27      -4.404 -15.411  -5.253  1.00  0.00
ATOM    417  HB1 TRP    27      -3.650 -14.657  -5.074  1.00  0.00
ATOM    418  HB2 TRP    27      -4.223 -16.240  -4.578  1.00  0.00
ATOM    419  CG  TRP    27      -5.746 -14.806  -4.899  1.00  0.00
ATOM    420  CD1 TRP    27      -6.813 -15.425  -4.298  1.00  0.00
ATOM    421  HD1 TRP    27      -6.834 -16.466  -4.002  1.00  0.00
ATOM    422  CD2 TRP    27      -6.140 -13.442  -5.103  1.00  0.00
ATOM    423  NE1 TRP    27      -7.838 -14.529  -4.128  1.00  0.00
ATOM    424  HE1 TRP    27      -8.707 -14.731  -3.721  1.00  0.00
ATOM    425  CE2 TRP    27      -7.451 -13.309  -4.615  1.00  0.00
ATOM    426  CE3 TRP    27      -5.497 -12.321  -5.646  1.00  0.00
ATOM    427  HE3 TRP    27      -4.487 -12.389  -6.033  1.00  0.00
ATOM    428  CZ2 TRP    27      -8.137 -12.102  -4.667  1.00  0.00
ATOM    429  HZ2 TRP    27      -9.148 -12.004  -4.298  1.00  0.00
ATOM    430  CZ3 TRP    27      -6.182 -11.125  -5.699  1.00  0.00
ATOM    431  HZ3 TRP    27      -5.704 -10.246  -6.113  1.00  0.00
ATOM    432  CH2 TRP    27      -7.489 -11.021  -5.207  1.00  0.00
ATOM    433  HH2 TRP    27      -7.991 -10.060  -5.267  1.00  0.00
ATOM    434  C   TRP    27      -2.813 -16.314  -7.008  1.00  0.00
ATOM    435  O   TRP    27      -1.888 -15.520  -6.805  1.00  0.00
ATOM    436  N   TRP    28      -2.618 -17.549  -7.499  1.00  0.00
ATOM    437  HN  TRP    28      -3.388 -18.151  -7.573  1.00  0.00
ATOM    438  CA  TRP    28      -1.309 -18.047  -7.951  1.00  0.00
ATOM    439  HA  TRP    28      -0.524 -17.501  -7.429  1.00  0.00
ATOM    440  CB  TRP    28      -1.163 -19.564  -7.650  1.00  0.00
ATOM    441  HB1 TRP    28      -0.191 -19.902  -7.996  1.00  0.00
ATOM    442  HB2 TRP    28      -1.929 -20.106  -8.194  1.00  0.00
ATOM    443  CG  TRP    28      -1.297 -19.941  -6.191  1.00  0.00
ATOM    444  CD1 TRP    28      -2.412 -19.826  -5.411  1.00  0.00
ATOM    445  HD1 TRP    28      -3.365 -19.415  -5.743  1.00  0.00
ATOM    446  CD2 TRP    28      -0.291 -20.536  -5.349  1.00  0.00
ATOM    447  NE1 TRP    28      -2.155 -20.305  -4.159  1.00  0.00
ATOM    448  HE1 TRP    28      -2.801 -20.329  -3.422  1.00  0.00
ATOM    449  CE2 TRP    28      -0.869 -20.737  -4.089  1.00  0.00
ATOM    450  CE3 TRP    28       1.037 -20.908  -5.540  1.00  0.00
ATOM    451  HE3 TRP    28       1.520 -20.774  -6.499  1.00  0.00
ATOM    452  CZ2 TRP    28      -0.174 -21.298  -3.021  1.00  0.00
ATOM    453  HZ2 TRP    28      -0.632 -21.445  -2.052  1.00  0.00
ATOM    454  CZ3 TRP    28       1.731 -21.467  -4.485  1.00  0.00
ATOM    455  HZ3 TRP    28       2.764 -21.760  -4.617  1.00  0.00
ATOM    456  CH2 TRP    28       1.127 -21.653  -3.235  1.00  0.00
ATOM    457  HH2 TRP    28       1.710 -22.092  -2.434  1.00  0.00
ATOM    458  C   TRP    28      -1.162 -17.807  -9.463  1.00  0.00
ATOM    459  O   TRP    28      -2.148 -17.552 -10.168  1.00  0.00
ATOM    460  N   ALA    29       0.084 -17.865  -9.940  1.00  0.00
ATOM    461  HN  ALA    29       0.820 -17.910  -9.299  1.00  0.00
ATOM    462  CA  ALA    29       0.402 -17.858 -11.384  1.00  0.00
ATOM    463  HA  ALA    29      -0.268 -17.158 -11.880  1.00  0.00
ATOM    464  CB  ALA    29       1.851 -17.391 -11.618  1.00  0.00
ATOM    465  HB1 ALA    29       1.980 -16.392 -11.220  1.00  0.00
ATOM    466  HB2 ALA    29       2.066 -17.379 -12.680  1.00  0.00
ATOM    467  HB3 ALA    29       2.542 -18.065 -11.123  1.00  0.00
ATOM    468  C   ALA    29       0.186 -19.261 -11.971  1.00  0.00
ATOM    469  O   ALA    29       0.322 -20.257 -11.255  1.00  0.00
ATOM    470  N   ASP    30      -0.136 -19.337 -13.276  1.00  0.00
ATOM    471  HN  ASP    30      -0.232 -18.505 -13.787  1.00  0.00
ATOM    472  CA  ASP    30      -0.360 -20.632 -13.968  1.00  0.00
ATOM    473  HA  ASP    30      -1.069 -21.201 -13.371  1.00  0.00
ATOM    474  CB  ASP    30      -0.975 -20.409 -15.375  1.00  0.00
ATOM    475  HB1 ASP    30      -0.286 -19.812 -15.967  1.00  0.00
ATOM    476  HB2 ASP    30      -1.901 -19.854 -15.268  1.00  0.00
ATOM    477  CG  ASP    30      -1.287 -21.721 -16.139  1.00  0.00
ATOM    478  OD1 ASP    30      -0.682 -21.975 -17.205  1.00  0.00
ATOM    479  OD2 ASP    30      -2.136 -22.508 -15.671  1.00  0.00
ATOM    480  C   ASP    30       0.946 -21.444 -14.073  1.00  0.00
ATOM    481  O   ASP    30       0.921 -22.672 -14.123  1.00  0.00
ATOM    482  N   ASP    31       2.086 -20.743 -14.091  1.00  0.00
ATOM    483  HN  ASP    31       2.032 -19.765 -14.057  1.00  0.00
ATOM    484  CA  ASP    31       3.425 -21.361 -14.163  1.00  0.00
ATOM    485  HA  ASP    31       3.309 -22.413 -14.416  1.00  0.00
ATOM    486  CB  ASP    31       4.258 -20.668 -15.283  1.00  0.00
ATOM    487  HB1 ASP    31       3.670 -20.644 -16.196  1.00  0.00
ATOM    488  HB2 ASP    31       5.148 -21.261 -15.470  1.00  0.00
ATOM    489  CG  ASP    31       4.679 -19.220 -14.947  1.00  0.00
ATOM    490  OD1 ASP    31       5.893 -18.910 -14.968  1.00  0.00
ATOM    491  OD2 ASP    31       3.794 -18.390 -14.651  1.00  0.00
ATOM    492  C   ASP    31       4.145 -21.271 -12.798  1.00  0.00
ATOM    493  O   ASP    31       5.368 -21.436 -12.735  1.00  0.00
ATOM    494  N   CYS    32       3.372 -21.042 -11.708  1.00  0.00
ATOM    495  HN  CYS    32       2.397 -21.033 -11.820  1.00  0.00
ATOM    496  CA  CYS    32       3.929 -20.815 -10.357  1.00  0.00
ATOM    497  HA  CYS    32       4.586 -19.948 -10.425  1.00  0.00
ATOM    498  CB  CYS    32       2.822 -20.500  -9.334  1.00  0.00
ATOM    499  HB1 CYS    32       2.121 -21.327  -9.285  1.00  0.00
ATOM    500  HB2 CYS    32       2.292 -19.608  -9.643  1.00  0.00
ATOM    501  SG  CYS    32       3.442 -20.205  -7.661  1.00  0.00
ATOM    502  HG  CYS    32       3.893 -18.961  -7.609  1.00  0.00
ATOM    503  C   CYS    32       4.746 -22.018  -9.858  1.00  0.00
ATOM    504  O   CYS    32       4.315 -23.164  -9.982  1.00  0.00
ATOM    505  N   GLN    33       5.931 -21.735  -9.310  1.00  0.00
ATOM    506  HN  GLN    33       6.211 -20.795  -9.266  1.00  0.00
ATOM    507  CA  GLN    33       6.820 -22.757  -8.747  1.00  0.00
ATOM    508  HA  GLN    33       6.676 -23.687  -9.300  1.00  0.00
ATOM    509  CB  GLN    33       8.293 -22.308  -8.888  1.00  0.00
ATOM    510  HB1 GLN    33       8.940 -23.107  -8.534  1.00  0.00
ATOM    511  HB2 GLN    33       8.455 -21.432  -8.264  1.00  0.00
ATOM    512  CG  GLN    33       8.708 -21.948 -10.324  1.00  0.00
ATOM    513  HG1 GLN    33       9.714 -21.544 -10.306  1.00  0.00
ATOM    514  HG2 GLN    33       8.029 -21.185 -10.687  1.00  0.00
ATOM    515  CD  GLN    33       8.666 -23.115 -11.312  1.00  0.00
ATOM    516  OE1 GLN    33       9.627 -23.873 -11.448  1.00  0.00
ATOM    517  NE2 GLN    33       7.557 -23.249 -12.021  1.00  0.00
ATOM    518 HE21 GLN    33       6.829 -22.608 -11.869  1.00  0.00
ATOM    519 HE22 GLN    33       7.515 -23.970 -12.683  1.00  0.00
ATOM    520  C   GLN    33       6.458 -22.984  -7.273  1.00  0.00
ATOM    521  O   GLN    33       6.003 -22.058  -6.590  1.00  0.00
ATOM    522  N   TYR    34       6.660 -24.215  -6.795  1.00  0.00
ATOM    523  HN  TYR    34       7.018 -24.897  -7.399  1.00  0.00
ATOM    524  CA  TYR    34       6.366 -24.598  -5.412  1.00  0.00
ATOM    525  HA  TYR    34       6.364 -23.697  -4.801  1.00  0.00
ATOM    526  CB  TYR    34       4.974 -25.271  -5.320  1.00  0.00
ATOM    527  HB1 TYR    34       5.006 -26.231  -5.824  1.00  0.00
ATOM    528  HB2 TYR    34       4.250 -24.644  -5.830  1.00  0.00
ATOM    529  CG  TYR    34       4.468 -25.493  -3.889  1.00  0.00
ATOM    530  CD1 TYR    34       4.474 -26.760  -3.296  1.00  0.00
ATOM    531  HD1 TYR    34       4.842 -27.610  -3.864  1.00  0.00
ATOM    532  CD2 TYR    34       3.989 -24.416  -3.132  1.00  0.00
ATOM    533  HD2 TYR    34       3.970 -23.424  -3.573  1.00  0.00
ATOM    534  CE1 TYR    34       4.013 -26.943  -2.007  1.00  0.00
ATOM    535  HE1 TYR    34       4.024 -27.931  -1.565  1.00  0.00
ATOM    536  CE2 TYR    34       3.532 -24.598  -1.845  1.00  0.00
ATOM    537  HE2 TYR    34       3.165 -23.751  -1.278  1.00  0.00
ATOM    538  CZ  TYR    34       3.548 -25.860  -1.285  1.00  0.00
ATOM    539  OH  TYR    34       3.076 -26.040  -0.005  1.00  0.00
ATOM    540  HH  TYR    34       3.708 -26.559   0.500  1.00  0.00
ATOM    541  C   TYR    34       7.470 -25.531  -4.911  1.00  0.00
ATOM    542  O   TYR    34       7.623 -26.639  -5.427  1.00  0.00
ATOM    543  N   TYR    35       8.258 -25.050  -3.939  1.00  0.00
ATOM    544  HN  TYR    35       8.090 -24.143  -3.617  1.00  0.00
ATOM    545  CA  TYR    35       9.360 -25.806  -3.322  1.00  0.00
ATOM    546  HA  TYR    35       9.523 -26.709  -3.909  1.00  0.00
ATOM    547  CB  TYR    35      10.675 -24.980  -3.310  1.00  0.00
ATOM    548  HB1 TYR    35      11.435 -25.539  -2.770  1.00  0.00
ATOM    549  HB2 TYR    35      10.501 -24.053  -2.779  1.00  0.00
ATOM    550  CG  TYR    35      11.248 -24.622  -4.699  1.00  0.00
ATOM    551  CD1 TYR    35      12.419 -25.220  -5.176  1.00  0.00
ATOM    552  HD1 TYR    35      12.920 -25.960  -4.560  1.00  0.00
ATOM    553  CD2 TYR    35      10.630 -23.674  -5.519  1.00  0.00
ATOM    554  HD2 TYR    35       9.721 -23.191  -5.173  1.00  0.00
ATOM    555  CE1 TYR    35      12.942 -24.893  -6.412  1.00  0.00
ATOM    556  HE1 TYR    35      13.843 -25.374  -6.758  1.00  0.00
ATOM    557  CE2 TYR    35      11.150 -23.347  -6.756  1.00  0.00
ATOM    558  HE2 TYR    35      10.646 -22.616  -7.370  1.00  0.00
ATOM    559  CZ  TYR    35      12.306 -23.952  -7.197  1.00  0.00
ATOM    560  OH  TYR    35      12.820 -23.623  -8.433  1.00  0.00
ATOM    561  HH  TYR    35      13.041 -24.430  -8.909  1.00  0.00
ATOM    562  C   TYR    35       9.000 -26.224  -1.887  1.00  0.00
ATOM    563  O   TYR    35       8.172 -25.588  -1.222  1.00  0.00
ATOM    564  N   ALA    36       9.647 -27.307  -1.441  1.00  0.00
ATOM    565  HN  ALA    36      10.233 -27.776  -2.069  1.00  0.00
ATOM    566  CA  ALA    36       9.560 -27.833  -0.072  1.00  0.00
ATOM    567  HA  ALA    36       8.812 -27.261   0.480  1.00  0.00
ATOM    568  CB  ALA    36       9.131 -29.308  -0.103  1.00  0.00
ATOM    569  HB1 ALA    36       8.176 -29.395  -0.605  1.00  0.00
ATOM    570  HB2 ALA    36       9.038 -29.687   0.907  1.00  0.00
ATOM    571  HB3 ALA    36       9.868 -29.893  -0.640  1.00  0.00
ATOM    572  C   ALA    36      10.919 -27.677   0.619  1.00  0.00
ATOM    573  O   ALA    36      11.950 -27.634  -0.064  1.00  0.00
ATOM    574  N   PHE    37      10.898 -27.616   1.965  1.00  0.00
ATOM    575  HN  PHE    37      10.028 -27.690   2.410  1.00  0.00
ATOM    576  CA  PHE    37      12.100 -27.441   2.814  1.00  0.00
ATOM    577  HA  PHE    37      12.490 -26.449   2.624  1.00  0.00
ATOM    578  CB  PHE    37      11.685 -27.538   4.308  1.00  0.00
ATOM    579  HB1 PHE    37      11.206 -28.496   4.474  1.00  0.00
ATOM    580  HB2 PHE    37      10.960 -26.758   4.518  1.00  0.00
ATOM    581  CG  PHE    37      12.829 -27.390   5.318  1.00  0.00
ATOM    582  CD1 PHE    37      13.502 -26.179   5.459  1.00  0.00
ATOM    583  HD1 PHE    37      13.222 -25.338   4.834  1.00  0.00
ATOM    584  CD2 PHE    37      13.216 -28.454   6.136  1.00  0.00
ATOM    585  HD2 PHE    37      12.715 -29.408   6.039  1.00  0.00
ATOM    586  CE1 PHE    37      14.520 -26.033   6.380  1.00  0.00
ATOM    587  HE1 PHE    37      15.030 -25.081   6.474  1.00  0.00
ATOM    588  CE2 PHE    37      14.239 -28.307   7.056  1.00  0.00
ATOM    589  HE2 PHE    37      14.527 -29.141   7.681  1.00  0.00
ATOM    590  CZ  PHE    37      14.888 -27.095   7.179  1.00  0.00
ATOM    591  HZ  PHE    37      15.684 -26.978   7.901  1.00  0.00
ATOM    592  C   PHE    37      13.194 -28.502   2.500  1.00  0.00
ATOM    593  O   PHE    37      12.892 -29.697   2.556  1.00  0.00
ATOM    594  N   PRO    38      14.479 -28.106   2.177  1.00  0.00
ATOM    595  CA  PRO    38      14.924 -26.691   2.008  1.00  0.00
ATOM    596  HA  PRO    38      14.537 -26.075   2.819  1.00  0.00
ATOM    597  CB  PRO    38      16.467 -26.797   2.147  1.00  0.00
ATOM    598  HB1 PRO    38      16.750 -26.680   3.192  1.00  0.00
ATOM    599  HB2 PRO    38      16.955 -26.023   1.563  1.00  0.00
ATOM    600  CG  PRO    38      16.797 -28.171   1.643  1.00  0.00
ATOM    601  HG1 PRO    38      17.713 -28.531   2.101  1.00  0.00
ATOM    602  HG2 PRO    38      16.911 -28.148   0.562  1.00  0.00
ATOM    603  CD  PRO    38      15.623 -29.050   2.037  1.00  0.00
ATOM    604  HD1 PRO    38      15.819 -29.546   2.982  1.00  0.00
ATOM    605  HD2 PRO    38      15.416 -29.784   1.272  1.00  0.00
ATOM    606  C   PRO    38      14.491 -26.046   0.650  1.00  0.00
ATOM    607  O   PRO    38      13.769 -25.041   0.647  1.00  0.00
ATOM    608  N   ALA    39      14.901 -26.646  -0.492  1.00  0.00
ATOM    609  HN  ALA    39      15.417 -27.473  -0.427  1.00  0.00
ATOM    610  CA  ALA    39      14.593 -26.127  -1.842  1.00  0.00
ATOM    611  HA  ALA    39      13.665 -25.552  -1.792  1.00  0.00
ATOM    612  CB  ALA    39      15.713 -25.178  -2.326  1.00  0.00
ATOM    613  HB1 ALA    39      15.457 -24.768  -3.297  1.00  0.00
ATOM    614  HB2 ALA    39      16.645 -25.720  -2.403  1.00  0.00
ATOM    615  HB3 ALA    39      15.834 -24.365  -1.618  1.00  0.00
ATOM    616  C   ALA    39      14.388 -27.300  -2.818  1.00  0.00
ATOM    617  O   ALA    39      15.294 -27.665  -3.577  1.00  0.00
ATOM    618  N   THR    40      13.197 -27.913  -2.761  1.00  0.00
ATOM    619  HN  THR    40      12.521 -27.561  -2.142  1.00  0.00
ATOM    620  CA  THR    40      12.851 -29.096  -3.572  1.00  0.00
ATOM    621  HA  THR    40      13.657 -29.283  -4.280  1.00  0.00
ATOM    622  CB  THR    40      12.707 -30.356  -2.654  1.00  0.00
ATOM    623  HB  THR    40      11.946 -30.151  -1.903  1.00  0.00
ATOM    624  OG1 THR    40      13.957 -30.590  -1.979  1.00  0.00
ATOM    625  HG1 THR    40      13.879 -30.308  -1.067  1.00  0.00
ATOM    626  CG2 THR    40      12.296 -31.623  -3.435  1.00  0.00
ATOM    627 HG21 THR    40      13.015 -31.819  -4.220  1.00  0.00
ATOM    628 HG22 THR    40      11.315 -31.481  -3.876  1.00  0.00
ATOM    629 HG23 THR    40      12.264 -32.471  -2.765  1.00  0.00
ATOM    630  C   THR    40      11.555 -28.827  -4.355  1.00  0.00
ATOM    631  O   THR    40      10.466 -28.807  -3.771  1.00  0.00
ATOM    632  N   LEU    41      11.690 -28.604  -5.676  1.00  0.00
ATOM    633  HN  LEU    41      12.579 -28.711  -6.077  1.00  0.00
ATOM    634  CA  LEU    41      10.568 -28.232  -6.559  1.00  0.00
ATOM    635  HA  LEU    41      10.075 -27.367  -6.120  1.00  0.00
ATOM    636  CB  LEU    41      11.113 -27.835  -7.964  1.00  0.00
ATOM    637  HB1 LEU    41      11.598 -28.707  -8.395  1.00  0.00
ATOM    638  HB2 LEU    41      11.871 -27.070  -7.827  1.00  0.00
ATOM    639  CG  LEU    41      10.063 -27.304  -8.992  1.00  0.00
ATOM    640  HG  LEU    41       9.269 -28.028  -9.069  1.00  0.00
ATOM    641  CD1 LEU    41       9.414 -25.991  -8.514  1.00  0.00
ATOM    642 HD11 LEU    41      10.169 -25.224  -8.402  1.00  0.00
ATOM    643 HD12 LEU    41       8.924 -26.152  -7.563  1.00  0.00
ATOM    644 HD13 LEU    41       8.676 -25.665  -9.237  1.00  0.00
ATOM    645  CD2 LEU    41      10.680 -27.145 -10.400  1.00  0.00
ATOM    646 HD21 LEU    41      11.474 -26.407 -10.375  1.00  0.00
ATOM    647 HD22 LEU    41       9.918 -26.826 -11.099  1.00  0.00
ATOM    648 HD23 LEU    41      11.084 -28.094 -10.729  1.00  0.00
ATOM    649  C   LEU    41       9.549 -29.387  -6.673  1.00  0.00
ATOM    650  O   LEU    41       9.794 -30.377  -7.366  1.00  0.00
ATOM    651  N   LEU    42       8.424 -29.257  -5.947  1.00  0.00
ATOM    652  HN  LEU    42       8.353 -28.502  -5.331  1.00  0.00
ATOM    653  CA  LEU    42       7.306 -30.217  -6.004  1.00  0.00
ATOM    654  HA  LEU    42       7.720 -31.215  -6.065  1.00  0.00
ATOM    655  CB  LEU    42       6.422 -30.119  -4.726  1.00  0.00
ATOM    656  HB1 LEU    42       5.673 -30.904  -4.778  1.00  0.00
ATOM    657  HB2 LEU    42       5.906 -29.161  -4.745  1.00  0.00
ATOM    658  CG  LEU    42       7.155 -30.235  -3.352  1.00  0.00
ATOM    659  HG  LEU    42       7.771 -29.352  -3.218  1.00  0.00
ATOM    660  CD1 LEU    42       6.145 -30.250  -2.183  1.00  0.00
ATOM    661 HD11 LEU    42       5.491 -31.112  -2.265  1.00  0.00
ATOM    662 HD12 LEU    42       5.550 -29.348  -2.206  1.00  0.00
ATOM    663 HD13 LEU    42       6.679 -30.295  -1.243  1.00  0.00
ATOM    664  CD2 LEU    42       8.099 -31.459  -3.304  1.00  0.00
ATOM    665 HD21 LEU    42       8.577 -31.515  -2.336  1.00  0.00
ATOM    666 HD22 LEU    42       8.861 -31.355  -4.065  1.00  0.00
ATOM    667 HD23 LEU    42       7.537 -32.369  -3.483  1.00  0.00
ATOM    668  C   LEU    42       6.434 -29.958  -7.246  1.00  0.00
ATOM    669  O   LEU    42       5.915 -30.902  -7.860  1.00  0.00
ATOM    670  N   ALA    43       6.281 -28.670  -7.605  1.00  0.00
ATOM    671  HN  ALA    43       6.814 -27.988  -7.142  1.00  0.00
ATOM    672  CA  ALA    43       5.338 -28.239  -8.656  1.00  0.00
ATOM    673  HA  ALA    43       5.126 -29.084  -9.309  1.00  0.00
ATOM    674  CB  ALA    43       4.025 -27.815  -7.996  1.00  0.00
ATOM    675  HB1 ALA    43       3.306 -27.524  -8.754  1.00  0.00
ATOM    676  HB2 ALA    43       4.205 -26.979  -7.333  1.00  0.00
ATOM    677  HB3 ALA    43       3.620 -28.641  -7.424  1.00  0.00
ATOM    678  C   ALA    43       5.919 -27.088  -9.495  1.00  0.00
ATOM    679  O   ALA    43       6.235 -26.030  -8.953  1.00  0.00
ATOM    680  N   GLY    44       6.037 -27.307 -10.819  1.00  0.00
ATOM    681  HN  GLY    44       5.759 -28.179 -11.171  1.00  0.00
ATOM    682  CA  GLY    44       6.553 -26.303 -11.758  1.00  0.00
ATOM    683  HA1 GLY    44       7.207 -26.802 -12.463  1.00  0.00
ATOM    684  HA2 GLY    44       7.132 -25.564 -11.218  1.00  0.00
ATOM    685  C   GLY    44       5.441 -25.590 -12.533  1.00  0.00
ATOM    686  O   GLY    44       5.641 -25.190 -13.688  1.00  0.00
ATOM    687  N   ASN    45       4.307 -25.374 -11.842  1.00  0.00
ATOM    688  HN  ASN    45       4.350 -25.502 -10.870  1.00  0.00
ATOM    689  CA  ASN    45       3.029 -24.853 -12.409  1.00  0.00
ATOM    690  HA  ASN    45       3.173 -23.789 -12.573  1.00  0.00
ATOM    691  CB  ASN    45       2.606 -25.511 -13.767  1.00  0.00
ATOM    692  HB1 ASN    45       3.409 -25.382 -14.484  1.00  0.00
ATOM    693  HB2 ASN    45       1.735 -24.993 -14.147  1.00  0.00
ATOM    694  CG  ASN    45       2.271 -27.002 -13.667  1.00  0.00
ATOM    695  OD1 ASN    45       1.137 -27.384 -13.375  1.00  0.00
ATOM    696  ND2 ASN    45       3.246 -27.850 -13.945  1.00  0.00
ATOM    697 HD21 ASN    45       4.118 -27.483 -14.196  1.00  0.00
ATOM    698 HD22 ASN    45       3.059 -28.809 -13.885  1.00  0.00
ATOM    699  C   ASN    45       1.893 -25.018 -11.376  1.00  0.00
ATOM    700  O   ASN    45       1.989 -25.849 -10.466  1.00  0.00
ATOM    701  N   ALA    46       0.798 -24.256 -11.582  1.00  0.00
ATOM    702  HN  ALA    46       0.750 -23.746 -12.414  1.00  0.00
ATOM    703  CA  ALA    46      -0.338 -24.151 -10.638  1.00  0.00
ATOM    704  HA  ALA    46       0.060 -23.852  -9.672  1.00  0.00
ATOM    705  CB  ALA    46      -1.298 -23.046 -11.110  1.00  0.00
ATOM    706  HB1 ALA    46      -2.094 -22.908 -10.387  1.00  0.00
ATOM    707  HB2 ALA    46      -1.728 -23.316 -12.068  1.00  0.00
ATOM    708  HB3 ALA    46      -0.757 -22.114 -11.218  1.00  0.00
ATOM    709  C   ALA    46      -1.103 -25.482 -10.467  1.00  0.00
ATOM    710  O   ALA    46      -1.540 -25.816  -9.361  1.00  0.00
ATOM    711  N   ALA    47      -1.235 -26.238 -11.569  1.00  0.00
ATOM    712  HN  ALA    47      -0.755 -25.965 -12.382  1.00  0.00
ATOM    713  CA  ALA    47      -2.052 -27.468 -11.611  1.00  0.00
ATOM    714  HA  ALA    47      -3.072 -27.190 -11.352  1.00  0.00
ATOM    715  CB  ALA    47      -2.072 -28.062 -13.023  1.00  0.00
ATOM    716  HB1 ALA    47      -1.077 -28.410 -13.288  1.00  0.00
ATOM    717  HB2 ALA    47      -2.388 -27.309 -13.732  1.00  0.00
ATOM    718  HB3 ALA    47      -2.766 -28.896 -13.059  1.00  0.00
ATOM    719  C   ALA    47      -1.556 -28.516 -10.610  1.00  0.00
ATOM    720  O   ALA    47      -2.352 -29.223  -9.997  1.00  0.00
ATOM    721  N   GLU    48      -0.233 -28.614 -10.469  1.00  0.00
ATOM    722  HN  GLU    48       0.342 -28.017 -11.000  1.00  0.00
ATOM    723  CA  GLU    48       0.402 -29.568  -9.545  1.00  0.00
ATOM    724  HA  GLU    48      -0.139 -30.512  -9.619  1.00  0.00
ATOM    725  CB  GLU    48       1.867 -29.812  -9.970  1.00  0.00
ATOM    726  HB1 GLU    48       2.267 -30.649  -9.402  1.00  0.00
ATOM    727  HB2 GLU    48       2.450 -28.928  -9.739  1.00  0.00
ATOM    728  CG  GLU    48       2.051 -30.115 -11.465  1.00  0.00
ATOM    729  HG1 GLU    48       1.758 -29.236 -12.036  1.00  0.00
ATOM    730  HG2 GLU    48       1.391 -30.934 -11.741  1.00  0.00
ATOM    731  CD  GLU    48       3.504 -30.470 -11.823  1.00  0.00
ATOM    732  OE1 GLU    48       4.355 -29.560 -11.862  1.00  0.00
ATOM    733  OE2 GLU    48       3.797 -31.653 -12.083  1.00  0.00
ATOM    734  C   GLU    48       0.311 -29.068  -8.083  1.00  0.00
ATOM    735  O   GLU    48       0.176 -29.872  -7.152  1.00  0.00
ATOM    736  N   ILE    49       0.366 -27.724  -7.907  1.00  0.00
ATOM    737  HN  ILE    49       0.462 -27.157  -8.704  1.00  0.00
ATOM    738  CA  ILE    49       0.289 -27.064  -6.580  1.00  0.00
ATOM    739  HA  ILE    49       1.096 -27.457  -5.965  1.00  0.00
ATOM    740  CB  ILE    49       0.469 -25.495  -6.690  1.00  0.00
ATOM    741  HB  ILE    49      -0.315 -25.121  -7.346  1.00  0.00
ATOM    742  CG1 ILE    49       1.846 -25.144  -7.321  1.00  0.00
ATOM    743 HG11 ILE    49       1.937 -25.649  -8.277  1.00  0.00
ATOM    744 HG12 ILE    49       2.634 -25.501  -6.672  1.00  0.00
ATOM    745  CG2 ILE    49       0.297 -24.792  -5.316  1.00  0.00
ATOM    746 HG21 ILE    49       1.051 -25.147  -4.623  1.00  0.00
ATOM    747 HG22 ILE    49      -0.685 -25.006  -4.913  1.00  0.00
ATOM    748 HG23 ILE    49       0.399 -23.721  -5.439  1.00  0.00
ATOM    749  CD1 ILE    49       2.103 -23.670  -7.561  1.00  0.00
ATOM    750 HD11 ILE    49       1.338 -23.263  -8.208  1.00  0.00
ATOM    751 HD12 ILE    49       3.069 -23.547  -8.031  1.00  0.00
ATOM    752 HD13 ILE    49       2.098 -23.141  -6.619  1.00  0.00
ATOM    753  C   ILE    49      -1.055 -27.367  -5.898  1.00  0.00
ATOM    754  O   ILE    49      -1.088 -27.781  -4.727  1.00  0.00
ATOM    755  N   ARG    50      -2.158 -27.149  -6.646  1.00  0.00
ATOM    756  HN  ARG    50      -2.046 -26.855  -7.582  1.00  0.00
ATOM    757  CA  ARG    50      -3.520 -27.338  -6.116  1.00  0.00
ATOM    758  HA  ARG    50      -3.600 -26.716  -5.224  1.00  0.00
ATOM    759  CB  ARG    50      -4.611 -26.869  -7.122  1.00  0.00
ATOM    760  HB1 ARG    50      -4.481 -25.804  -7.291  1.00  0.00
ATOM    761  HB2 ARG    50      -5.590 -27.021  -6.675  1.00  0.00
ATOM    762  CG  ARG    50      -4.592 -27.580  -8.493  1.00  0.00
ATOM    763  HG1 ARG    50      -4.813 -28.633  -8.340  1.00  0.00
ATOM    764  HG2 ARG    50      -3.598 -27.490  -8.915  1.00  0.00
ATOM    765  CD  ARG    50      -5.596 -27.004  -9.492  1.00  0.00
ATOM    766  HD1 ARG    50      -5.375 -25.950  -9.646  1.00  0.00
ATOM    767  HD2 ARG    50      -6.595 -27.100  -9.080  1.00  0.00
ATOM    768  NE  ARG    50      -5.558 -27.703 -10.798  1.00  0.00
ATOM    769  HE  ARG    50      -5.351 -28.667 -10.777  1.00  0.00
ATOM    770  CZ  ARG    50      -5.793 -27.131 -11.995  1.00  0.00
ATOM    771  NH1 ARG    50      -6.067 -25.835 -12.087  1.00  0.00
ATOM    772 HH11 ARG    50      -6.107 -25.271 -11.264  1.00  0.00
ATOM    773 HH12 ARG    50      -6.224 -25.413 -12.988  1.00  0.00
ATOM    774  NH2 ARG    50      -5.749 -27.866 -13.097  1.00  0.00
ATOM    775 HH21 ARG    50      -5.543 -28.847 -13.045  1.00  0.00
ATOM    776 HH22 ARG    50      -5.925 -27.449 -13.992  1.00  0.00
ATOM    777  C   ARG    50      -3.740 -28.803  -5.705  1.00  0.00
ATOM    778  O   ARG    50      -4.128 -29.045  -4.574  1.00  0.00
ATOM    779  N   VAL    51      -3.408 -29.760  -6.610  1.00  0.00
ATOM    780  HN  VAL    51      -2.984 -29.477  -7.452  1.00  0.00
ATOM    781  CA  VAL    51      -3.637 -31.211  -6.391  1.00  0.00
ATOM    782  HA  VAL    51      -4.704 -31.352  -6.235  1.00  0.00
ATOM    783  CB  VAL    51      -3.214 -32.066  -7.648  1.00  0.00
ATOM    784  HB  VAL    51      -2.162 -31.866  -7.847  1.00  0.00
ATOM    785  CG1 VAL    51      -3.369 -33.593  -7.393  1.00  0.00
ATOM    786 HG11 VAL    51      -4.403 -33.823  -7.163  1.00  0.00
ATOM    787 HG12 VAL    51      -2.745 -33.892  -6.559  1.00  0.00
ATOM    788 HG13 VAL    51      -3.067 -34.144  -8.275  1.00  0.00
ATOM    789  CG2 VAL    51      -4.019 -31.637  -8.900  1.00  0.00
ATOM    790 HG21 VAL    51      -5.072 -31.835  -8.747  1.00  0.00
ATOM    791 HG22 VAL    51      -3.674 -32.188  -9.766  1.00  0.00
ATOM    792 HG23 VAL    51      -3.881 -30.576  -9.080  1.00  0.00
ATOM    793  C   VAL    51      -2.891 -31.695  -5.136  1.00  0.00
ATOM    794  O   VAL    51      -3.461 -32.419  -4.314  1.00  0.00
ATOM    795  N   ARG    52      -1.635 -31.228  -4.987  1.00  0.00
ATOM    796  HN  ARG    52      -1.264 -30.665  -5.700  1.00  0.00
ATOM    797  CA  ARG    52      -0.787 -31.528  -3.816  1.00  0.00
ATOM    798  HA  ARG    52      -0.610 -32.599  -3.805  1.00  0.00
ATOM    799  CB  ARG    52       0.581 -30.793  -3.923  1.00  0.00
ATOM    800  HB1 ARG    52       0.399 -29.724  -3.949  1.00  0.00
ATOM    801  HB2 ARG    52       1.051 -31.077  -4.858  1.00  0.00
ATOM    802  CG  ARG    52       1.589 -31.090  -2.777  1.00  0.00
ATOM    803  HG1 ARG    52       1.032 -31.227  -1.851  1.00  0.00
ATOM    804  HG2 ARG    52       2.244 -30.234  -2.662  1.00  0.00
ATOM    805  CD  ARG    52       2.462 -32.347  -3.023  1.00  0.00
ATOM    806  HD1 ARG    52       3.163 -32.435  -2.209  1.00  0.00
ATOM    807  HD2 ARG    52       3.018 -32.207  -3.944  1.00  0.00
ATOM    808  NE  ARG    52       1.695 -33.613  -3.138  1.00  0.00
ATOM    809  HE  ARG    52       0.724 -33.541  -3.267  1.00  0.00
ATOM    810  CZ  ARG    52       2.234 -34.846  -3.134  1.00  0.00
ATOM    811  NH1 ARG    52       3.523 -35.031  -2.888  1.00  0.00
ATOM    812 HH11 ARG    52       4.121 -34.248  -2.699  1.00  0.00
ATOM    813 HH12 ARG    52       3.910 -35.958  -2.895  1.00  0.00
ATOM    814  NH2 ARG    52       1.462 -35.896  -3.349  1.00  0.00
ATOM    815 HH21 ARG    52       0.479 -35.774  -3.517  1.00  0.00
ATOM    816 HH22 ARG    52       1.850 -36.820  -3.358  1.00  0.00
ATOM    817  C   ARG    52      -1.503 -31.133  -2.509  1.00  0.00
ATOM    818  O   ARG    52      -1.497 -31.883  -1.526  1.00  0.00
ATOM    819  N   HIS    53      -2.128 -29.944  -2.525  1.00  0.00
ATOM    820  HN  HIS    53      -2.103 -29.412  -3.355  1.00  0.00
ATOM    821  CA  HIS    53      -2.855 -29.406  -1.362  1.00  0.00
ATOM    822  HA  HIS    53      -2.267 -29.645  -0.476  1.00  0.00
ATOM    823  CB  HIS    53      -2.965 -27.871  -1.457  1.00  0.00
ATOM    824  HB1 HIS    53      -3.635 -27.503  -0.681  1.00  0.00
ATOM    825  HB2 HIS    53      -3.366 -27.600  -2.427  1.00  0.00
ATOM    826  CG  HIS    53      -1.648 -27.161  -1.283  1.00  0.00
ATOM    827  ND1 HIS    53      -1.079 -26.368  -2.258  1.00  0.00
ATOM    828  HD1 HIS    53      -1.440 -26.224  -3.161  1.00  0.00
ATOM    829  CD2 HIS    53      -0.817 -27.093  -0.214  1.00  0.00
ATOM    830  HD2 HIS    53      -0.952 -27.596   0.738  1.00  0.00
ATOM    831  CE1 HIS    53       0.038 -25.842  -1.797  1.00  0.00
ATOM    832  HE1 HIS    53       0.695 -25.175  -2.338  1.00  0.00
ATOM    833  NE2 HIS    53       0.216 -26.263  -0.560  1.00  0.00
ATOM    834  HE2 HIS    53       0.983 -26.034   0.015  1.00  0.00
ATOM    835  C   HIS    53      -4.242 -30.048  -1.190  1.00  0.00
ATOM    836  O   HIS    53      -4.702 -30.155  -0.073  1.00  0.00
ATOM    837  N   ILE    54      -4.888 -30.480  -2.288  1.00  0.00
ATOM    838  HN  ILE    54      -4.454 -30.385  -3.158  1.00  0.00
ATOM    839  CA  ILE    54      -6.223 -31.128  -2.237  1.00  0.00
ATOM    840  HA  ILE    54      -6.912 -30.438  -1.750  1.00  0.00
ATOM    841  CB  ILE    54      -6.754 -31.421  -3.692  1.00  0.00
ATOM    842  HB  ILE    54      -5.970 -31.954  -4.221  1.00  0.00
ATOM    843  CG1 ILE    54      -7.043 -30.094  -4.455  1.00  0.00
ATOM    844 HG11 ILE    54      -6.175 -29.451  -4.396  1.00  0.00
ATOM    845 HG12 ILE    54      -7.875 -29.586  -3.988  1.00  0.00
ATOM    846  CG2 ILE    54      -8.005 -32.322  -3.689  1.00  0.00
ATOM    847 HG21 ILE    54      -8.326 -32.509  -4.706  1.00  0.00
ATOM    848 HG22 ILE    54      -8.805 -31.837  -3.149  1.00  0.00
ATOM    849 HG23 ILE    54      -7.775 -33.267  -3.209  1.00  0.00
ATOM    850  CD1 ILE    54      -7.383 -30.256  -5.923  1.00  0.00
ATOM    851 HD11 ILE    54      -6.574 -30.774  -6.425  1.00  0.00
ATOM    852 HD12 ILE    54      -7.516 -29.281  -6.368  1.00  0.00
ATOM    853 HD13 ILE    54      -8.294 -30.825  -6.023  1.00  0.00
ATOM    854  C   ILE    54      -6.139 -32.425  -1.408  1.00  0.00
ATOM    855  O   ILE    54      -7.042 -32.737  -0.627  1.00  0.00
ATOM    856  N   GLU    55      -5.011 -33.137  -1.584  1.00  0.00
ATOM    857  HN  GLU    55      -4.387 -32.842  -2.287  1.00  0.00
ATOM    858  CA  GLU    55      -4.661 -34.337  -0.799  1.00  0.00
ATOM    859  HA  GLU    55      -5.442 -35.081  -0.961  1.00  0.00
ATOM    860  CB  GLU    55      -3.309 -34.900  -1.311  1.00  0.00
ATOM    861  HB1 GLU    55      -3.057 -35.796  -0.746  1.00  0.00
ATOM    862  HB2 GLU    55      -2.533 -34.154  -1.141  1.00  0.00
ATOM    863  CG  GLU    55      -3.303 -35.260  -2.811  1.00  0.00
ATOM    864  HG1 GLU    55      -3.646 -34.396  -3.377  1.00  0.00
ATOM    865  HG2 GLU    55      -3.998 -36.075  -2.980  1.00  0.00
ATOM    866  CD  GLU    55      -1.912 -35.671  -3.321  1.00  0.00
ATOM    867  OE1 GLU    55      -1.504 -36.835  -3.108  1.00  0.00
ATOM    868  OE2 GLU    55      -1.201 -34.826  -3.908  1.00  0.00
ATOM    869  C   GLU    55      -4.589 -34.001   0.707  1.00  0.00
ATOM    870  O   GLU    55      -5.053 -34.776   1.547  1.00  0.00
ATOM    871  N   ARG    56      -4.022 -32.822   1.019  1.00  0.00
ATOM    872  HN  ARG    56      -3.640 -32.283   0.290  1.00  0.00
ATOM    873  CA  ARG    56      -3.933 -32.309   2.403  1.00  0.00
ATOM    874  HA  ARG    56      -3.552 -33.117   3.025  1.00  0.00
ATOM    875  CB  ARG    56      -2.925 -31.123   2.465  1.00  0.00
ATOM    876  HB1 ARG    56      -3.324 -30.300   1.880  1.00  0.00
ATOM    877  HB2 ARG    56      -1.991 -31.438   2.009  1.00  0.00
ATOM    878  CG  ARG    56      -2.610 -30.595   3.886  1.00  0.00
ATOM    879  HG1 ARG    56      -3.521 -30.187   4.312  1.00  0.00
ATOM    880  HG2 ARG    56      -1.874 -29.805   3.809  1.00  0.00
ATOM    881  CD  ARG    56      -2.065 -31.690   4.833  1.00  0.00
ATOM    882  HD1 ARG    56      -2.833 -32.446   4.967  1.00  0.00
ATOM    883  HD2 ARG    56      -1.841 -31.244   5.798  1.00  0.00
ATOM    884  NE  ARG    56      -0.838 -32.328   4.315  1.00  0.00
ATOM    885  HE  ARG    56      -0.259 -31.772   3.752  1.00  0.00
ATOM    886  CZ  ARG    56      -0.454 -33.590   4.565  1.00  0.00
ATOM    887  NH1 ARG    56      -1.223 -34.418   5.262  1.00  0.00
ATOM    888 HH11 ARG    56      -2.117 -34.112   5.603  1.00  0.00
ATOM    889 HH12 ARG    56      -0.919 -35.355   5.446  1.00  0.00
ATOM    890  NH2 ARG    56       0.694 -34.032   4.076  1.00  0.00
ATOM    891 HH21 ARG    56       1.269 -33.433   3.517  1.00  0.00
ATOM    892 HH22 ARG    56       0.996 -34.974   4.261  1.00  0.00
ATOM    893  C   ARG    56      -5.334 -31.891   2.936  1.00  0.00
ATOM    894  O   ARG    56      -5.620 -32.033   4.128  1.00  0.00
ATOM    895  N   PHE    57      -6.204 -31.392   2.029  1.00  0.00
ATOM    896  HN  PHE    57      -5.910 -31.324   1.097  1.00  0.00
ATOM    897  CA  PHE    57      -7.585 -30.948   2.363  1.00  0.00
ATOM    898  HA  PHE    57      -7.532 -30.378   3.288  1.00  0.00
ATOM    899  CB  PHE    57      -8.155 -30.015   1.240  1.00  0.00
ATOM    900  HB1 PHE    57      -9.239 -29.995   1.315  1.00  0.00
ATOM    901  HB2 PHE    57      -7.892 -30.433   0.277  1.00  0.00
ATOM    902  CG  PHE    57      -7.661 -28.555   1.239  1.00  0.00
ATOM    903  CD1 PHE    57      -6.323 -28.234   1.443  1.00  0.00
ATOM    904  HD1 PHE    57      -5.612 -29.028   1.633  1.00  0.00
ATOM    905  CD2 PHE    57      -8.549 -27.500   0.998  1.00  0.00
ATOM    906  HD2 PHE    57      -9.600 -27.716   0.836  1.00  0.00
ATOM    907  CE1 PHE    57      -5.887 -26.925   1.408  1.00  0.00
ATOM    908  HE1 PHE    57      -4.841 -26.702   1.568  1.00  0.00
ATOM    909  CE2 PHE    57      -8.111 -26.188   0.969  1.00  0.00
ATOM    910  HE2 PHE    57      -8.813 -25.386   0.782  1.00  0.00
ATOM    911  CZ  PHE    57      -6.779 -25.904   1.172  1.00  0.00
ATOM    912  HZ  PHE    57      -6.434 -24.879   1.146  1.00  0.00
ATOM    913  C   PHE    57      -8.536 -32.152   2.606  1.00  0.00
ATOM    914  O   PHE    57      -9.682 -31.953   3.023  1.00  0.00
ATOM    915  N   LYS    58      -8.074 -33.393   2.318  1.00  0.00
ATOM    916  HN  LYS    58      -7.206 -33.481   1.866  1.00  0.00
ATOM    917  CA  LYS    58      -8.839 -34.627   2.627  1.00  0.00
ATOM    918  HA  LYS    58      -9.859 -34.477   2.281  1.00  0.00
ATOM    919  CB  LYS    58      -8.243 -35.850   1.885  1.00  0.00
ATOM    920  HB1 LYS    58      -8.840 -36.730   2.113  1.00  0.00
ATOM    921  HB2 LYS    58      -7.231 -36.015   2.245  1.00  0.00
ATOM    922  CG  LYS    58      -8.181 -35.689   0.356  1.00  0.00
ATOM    923  HG1 LYS    58      -7.812 -36.613  -0.078  1.00  0.00
ATOM    924  HG2 LYS    58      -7.483 -34.889   0.124  1.00  0.00
ATOM    925  CD  LYS    58      -9.552 -35.346  -0.276  1.00  0.00
ATOM    926  HD1 LYS    58      -9.987 -34.502   0.249  1.00  0.00
ATOM    927  HD2 LYS    58     -10.211 -36.201  -0.182  1.00  0.00
ATOM    928  CE  LYS    58      -9.426 -34.987  -1.757  1.00  0.00
ATOM    929  HE1 LYS    58      -9.070 -35.848  -2.300  1.00  0.00
ATOM    930  HE2 LYS    58      -8.711 -34.181  -1.866  1.00  0.00
ATOM    931  NZ  LYS    58     -10.715 -34.548  -2.334  1.00  0.00
ATOM    932  HZ1 LYS    58     -11.058 -33.699  -1.837  1.00  0.00
ATOM    933  HZ2 LYS    58     -11.426 -35.302  -2.237  1.00  0.00
ATOM    934  HZ3 LYS    58     -10.596 -34.324  -3.338  1.00  0.00
ATOM    935  C   LYS    58      -8.880 -34.902   4.139  1.00  0.00
ATOM    936  O   LYS    58      -9.810 -35.558   4.624  1.00  0.00
ATOM    937  N   GLU    59      -7.848 -34.424   4.866  1.00  0.00
ATOM    938  HN  GLU    59      -7.096 -34.001   4.395  1.00  0.00
ATOM    939  CA  GLU    59      -7.802 -34.505   6.334  1.00  0.00
ATOM    940  HA  GLU    59      -8.011 -35.534   6.612  1.00  0.00
ATOM    941  CB  GLU    59      -6.395 -34.117   6.888  1.00  0.00
ATOM    942  HB1 GLU    59      -6.483 -33.914   7.951  1.00  0.00
ATOM    943  HB2 GLU    59      -6.068 -33.205   6.395  1.00  0.00
ATOM    944  CG  GLU    59      -5.294 -35.190   6.700  1.00  0.00
ATOM    945  HG1 GLU    59      -5.636 -36.116   7.159  1.00  0.00
ATOM    946  HG2 GLU    59      -4.403 -34.863   7.228  1.00  0.00
ATOM    947  CD  GLU    59      -4.917 -35.468   5.229  1.00  0.00
ATOM    948  OE1 GLU    59      -5.500 -36.392   4.608  1.00  0.00
ATOM    949  OE2 GLU    59      -4.030 -34.772   4.698  1.00  0.00
ATOM    950  C   GLU    59      -8.893 -33.597   6.933  1.00  0.00
ATOM    951  O   GLU    59      -8.849 -32.384   6.724  1.00  0.00
ATOM    952  N   PRO    60      -9.906 -34.161   7.674  1.00  0.00
ATOM    953  CA  PRO    60     -10.942 -33.342   8.356  1.00  0.00
ATOM    954  HA  PRO    60     -11.427 -32.665   7.661  1.00  0.00
ATOM    955  CB  PRO    60     -11.959 -34.398   8.862  1.00  0.00
ATOM    956  HB1 PRO    60     -12.746 -34.531   8.122  1.00  0.00
ATOM    957  HB2 PRO    60     -12.407 -34.076   9.797  1.00  0.00
ATOM    958  CG  PRO    60     -11.148 -35.653   9.029  1.00  0.00
ATOM    959  HG1 PRO    60     -11.783 -36.527   8.927  1.00  0.00
ATOM    960  HG2 PRO    60     -10.668 -35.659  10.006  1.00  0.00
ATOM    961  CD  PRO    60     -10.112 -35.619   7.924  1.00  0.00
ATOM    962  HD1 PRO    60     -10.484 -36.107   7.030  1.00  0.00
ATOM    963  HD2 PRO    60      -9.189 -36.089   8.251  1.00  0.00
ATOM    964  C   PRO    60     -10.324 -32.526   9.518  1.00  0.00
ATOM    965  O   PRO    60     -10.854 -31.489   9.933  1.00  0.00
ATOM    966  N   ASP    61      -9.169 -33.022   9.991  1.00  0.00
ATOM    967  HN  ASP    61      -8.815 -33.826   9.561  1.00  0.00
ATOM    968  CA  ASP    61      -8.383 -32.455  11.093  1.00  0.00
ATOM    969  HA  ASP    61      -9.070 -32.015  11.810  1.00  0.00
ATOM    970  CB  ASP    61      -7.609 -33.601  11.794  1.00  0.00
ATOM    971  HB1 ASP    61      -8.322 -34.253  12.287  1.00  0.00
ATOM    972  HB2 ASP    61      -6.956 -33.183  12.556  1.00  0.00
ATOM    973  CG  ASP    61      -6.756 -34.455  10.824  1.00  0.00
ATOM    974  OD1 ASP    61      -5.547 -34.192  10.674  1.00  0.00
ATOM    975  OD2 ASP    61      -7.305 -35.406  10.215  1.00  0.00
ATOM    976  C   ASP    61      -7.413 -31.352  10.623  1.00  0.00
ATOM    977  O   ASP    61      -6.754 -30.720  11.462  1.00  0.00
ATOM    978  N   LEU    62      -7.318 -31.129   9.291  1.00  0.00
ATOM    979  HN  LEU    62      -7.811 -31.708   8.679  1.00  0.00
ATOM    980  CA  LEU    62      -6.494 -30.040   8.727  1.00  0.00
ATOM    981  HA  LEU    62      -5.474 -30.172   9.090  1.00  0.00
ATOM    982  CB  LEU    62      -6.475 -30.062   7.168  1.00  0.00
ATOM    983  HB1 LEU    62      -7.502 -30.058   6.817  1.00  0.00
ATOM    984  HB2 LEU    62      -6.010 -30.990   6.844  1.00  0.00
ATOM    985  CG  LEU    62      -5.719 -28.856   6.503  1.00  0.00
ATOM    986  HG  LEU    62      -6.098 -27.939   6.942  1.00  0.00
ATOM    987  CD1 LEU    62      -4.214 -28.898   6.824  1.00  0.00
ATOM    988 HD11 LEU    62      -3.776 -29.810   6.436  1.00  0.00
ATOM    989 HD12 LEU    62      -4.069 -28.860   7.897  1.00  0.00
ATOM    990 HD13 LEU    62      -3.724 -28.045   6.374  1.00  0.00
ATOM    991  CD2 LEU    62      -5.976 -28.767   4.987  1.00  0.00
ATOM    992 HD21 LEU    62      -5.614 -29.663   4.497  1.00  0.00
ATOM    993 HD22 LEU    62      -5.466 -27.904   4.578  1.00  0.00
ATOM    994 HD23 LEU    62      -7.039 -28.667   4.805  1.00  0.00
ATOM    995  C   LEU    62      -7.024 -28.673   9.193  1.00  0.00
ATOM    996  O   LEU    62      -8.181 -28.332   8.930  1.00  0.00
ATOM    997  N   TYR    63      -6.169 -27.902   9.876  1.00  0.00
ATOM    998  HN  TYR    63      -5.303 -28.282  10.141  1.00  0.00
ATOM    999  CA  TYR    63      -6.484 -26.522  10.257  1.00  0.00
ATOM   1000  HA  TYR    63      -7.120 -26.093   9.484  1.00  0.00
ATOM   1001  CB  TYR    63      -7.248 -26.497  11.610  1.00  0.00
ATOM   1002  HB1 TYR    63      -6.596 -26.860  12.393  1.00  0.00
ATOM   1003  HB2 TYR    63      -8.108 -27.157  11.545  1.00  0.00
ATOM   1004  CG  TYR    63      -7.756 -25.106  12.011  1.00  0.00
ATOM   1005  CD1 TYR    63      -8.895 -24.564  11.412  1.00  0.00
ATOM   1006  HD1 TYR    63      -9.432 -25.148  10.672  1.00  0.00
ATOM   1007  CD2 TYR    63      -7.089 -24.331  12.963  1.00  0.00
ATOM   1008  HD2 TYR    63      -6.204 -24.733  13.447  1.00  0.00
ATOM   1009  CE1 TYR    63      -9.355 -23.305  11.754  1.00  0.00
ATOM   1010  HE1 TYR    63     -10.241 -22.910  11.279  1.00  0.00
ATOM   1011  CE2 TYR    63      -7.548 -23.074  13.309  1.00  0.00
ATOM   1012  HE2 TYR    63      -7.014 -22.493  14.052  1.00  0.00
ATOM   1013  CZ  TYR    63      -8.674 -22.562  12.699  1.00  0.00
ATOM   1014  OH  TYR    63      -9.124 -21.307  13.039  1.00  0.00
ATOM   1015  HH  TYR    63      -8.371 -20.697  13.085  1.00  0.00
ATOM   1016  C   TYR    63      -5.186 -25.702  10.342  1.00  0.00
ATOM   1017  O   TYR    63      -4.316 -26.004  11.162  1.00  0.00
ATOM   1018  N   GLY    64      -5.066 -24.667   9.493  1.00  0.00
ATOM   1019  HN  GLY    64      -5.752 -24.532   8.814  1.00  0.00
ATOM   1020  CA  GLY    64      -3.939 -23.738   9.559  1.00  0.00
ATOM   1021  HA1 GLY    64      -3.723 -23.383   8.558  1.00  0.00
ATOM   1022  HA2 GLY    64      -3.058 -24.241   9.944  1.00  0.00
ATOM   1023  C   GLY    64      -4.286 -22.551  10.439  1.00  0.00
ATOM   1024  O   GLY    64      -5.040 -21.668  10.015  1.00  0.00
ATOM   1025  N   GLU    65      -3.767 -22.554  11.678  1.00  0.00
ATOM   1026  HN  GLU    65      -3.223 -23.324  11.955  1.00  0.00
ATOM   1027  CA  GLU    65      -3.981 -21.460  12.641  1.00  0.00
ATOM   1028  HA  GLU    65      -4.893 -20.934  12.359  1.00  0.00
ATOM   1029  CB  GLU    65      -4.157 -22.022  14.079  1.00  0.00
ATOM   1030  HB1 GLU    65      -3.276 -22.602  14.337  1.00  0.00
ATOM   1031  HB2 GLU    65      -5.016 -22.682  14.086  1.00  0.00
ATOM   1032  CG  GLU    65      -4.365 -20.940  15.164  1.00  0.00
ATOM   1033  HG1 GLU    65      -5.112 -20.237  14.811  1.00  0.00
ATOM   1034  HG2 GLU    65      -3.430 -20.404  15.301  1.00  0.00
ATOM   1035  CD  GLU    65      -4.810 -21.501  16.529  1.00  0.00
ATOM   1036  OE1 GLU    65      -3.973 -22.103  17.236  1.00  0.00
ATOM   1037  OE2 GLU    65      -5.989 -21.319  16.912  1.00  0.00
ATOM   1038  C   GLU    65      -2.805 -20.484  12.573  1.00  0.00
ATOM   1039  O   GLU    65      -1.716 -20.782  13.081  1.00  0.00
ATOM   1040  N   LEU    66      -3.025 -19.335  11.914  1.00  0.00
ATOM   1041  HN  LEU    66      -3.920 -19.164  11.554  1.00  0.00
ATOM   1042  CA  LEU    66      -1.977 -18.329  11.725  1.00  0.00
ATOM   1043  HA  LEU    66      -1.106 -18.842  11.325  1.00  0.00
ATOM   1044  CB  LEU    66      -2.394 -17.227  10.735  1.00  0.00
ATOM   1045  HB1 LEU    66      -3.212 -16.659  11.175  1.00  0.00
ATOM   1046  HB2 LEU    66      -2.770 -17.702   9.831  1.00  0.00
ATOM   1047  CG  LEU    66      -1.236 -16.235  10.348  1.00  0.00
ATOM   1048  HG  LEU    66      -0.560 -16.154  11.204  1.00  0.00
ATOM   1049  CD1 LEU    66      -0.385 -16.773   9.174  1.00  0.00
ATOM   1050 HD11 LEU    66       0.388 -16.056   8.929  1.00  0.00
ATOM   1051 HD12 LEU    66      -1.017 -16.932   8.304  1.00  0.00
ATOM   1052 HD13 LEU    66       0.076 -17.713   9.455  1.00  0.00
ATOM   1053  CD2 LEU    66      -1.774 -14.828  10.053  1.00  0.00
ATOM   1054 HD21 LEU    66      -2.436 -14.862   9.196  1.00  0.00
ATOM   1055 HD22 LEU    66      -0.950 -14.162   9.843  1.00  0.00
ATOM   1056 HD23 LEU    66      -2.318 -14.458  10.911  1.00  0.00
ATOM   1057  C   LEU    66      -1.596 -17.678  13.066  1.00  0.00
ATOM   1058  O   LEU    66      -2.457 -17.389  13.903  1.00  0.00
ATOM   1059  N   LEU    67      -0.296 -17.458  13.229  1.00  0.00
ATOM   1060  HN  LEU    67       0.304 -17.721  12.501  1.00  0.00
ATOM   1061  CA  LEU    67       0.300 -16.857  14.426  1.00  0.00
ATOM   1062  HA  LEU    67      -0.420 -16.849  15.242  1.00  0.00
ATOM   1063  CB  LEU    67       1.533 -17.710  14.815  1.00  0.00
ATOM   1064  HB1 LEU    67       1.818 -17.465  15.834  1.00  0.00
ATOM   1065  HB2 LEU    67       2.362 -17.437  14.158  1.00  0.00
ATOM   1066  CG  LEU    67       1.325 -19.248  14.715  1.00  0.00
ATOM   1067  HG  LEU    67       0.803 -19.457  13.785  1.00  0.00
ATOM   1068  CD1 LEU    67       2.662 -19.982  14.639  1.00  0.00
ATOM   1069 HD11 LEU    67       3.244 -19.789  15.531  1.00  0.00
ATOM   1070 HD12 LEU    67       3.205 -19.626  13.771  1.00  0.00
ATOM   1071 HD13 LEU    67       2.493 -21.046  14.539  1.00  0.00
ATOM   1072  CD2 LEU    67       0.450 -19.774  15.865  1.00  0.00
ATOM   1073 HD21 LEU    67      -0.520 -19.295  15.822  1.00  0.00
ATOM   1074 HD22 LEU    67       0.919 -19.555  16.815  1.00  0.00
ATOM   1075 HD23 LEU    67       0.324 -20.845  15.765  1.00  0.00
ATOM   1076  C   LEU    67       0.747 -15.437  14.081  1.00  0.00
ATOM   1077  O   LEU    67       0.355 -14.454  14.717  1.00  0.00
ATOM   1078  N   THR    68       1.537 -15.371  13.005  1.00  0.00
ATOM   1079  HN  THR    68       1.670 -16.197  12.483  1.00  0.00
ATOM   1080  CA  THR    68       2.230 -14.158  12.560  1.00  0.00
ATOM   1081  HA  THR    68       1.645 -13.294  12.870  1.00  0.00
ATOM   1082  CB  THR    68       3.651 -14.075  13.235  1.00  0.00
ATOM   1083  HB  THR    68       4.168 -15.016  13.050  1.00  0.00
ATOM   1084  OG1 THR    68       3.499 -13.930  14.661  1.00  0.00
ATOM   1085  HG1 THR    68       3.252 -13.020  14.868  1.00  0.00
ATOM   1086  CG2 THR    68       4.528 -12.927  12.695  1.00  0.00
ATOM   1087 HG21 THR    68       4.726 -13.084  11.641  1.00  0.00
ATOM   1088 HG22 THR    68       5.465 -12.902  13.233  1.00  0.00
ATOM   1089 HG23 THR    68       4.015 -11.981  12.824  1.00  0.00
ATOM   1090  C   THR    68       2.355 -14.164  11.029  1.00  0.00
ATOM   1091  O   THR    68       2.523 -15.218  10.420  1.00  0.00
ATOM   1092  N   ARG    69       2.257 -12.973  10.430  1.00  0.00
ATOM   1093  HN  ARG    69       2.025 -12.200  10.978  1.00  0.00
ATOM   1094  CA  ARG    69       2.482 -12.752   9.001  1.00  0.00
ATOM   1095  HA  ARG    69       3.107 -13.561   8.627  1.00  0.00
ATOM   1096  CB  ARG    69       1.137 -12.746   8.221  1.00  0.00
ATOM   1097  HB1 ARG    69       0.721 -13.750   8.239  1.00  0.00
ATOM   1098  HB2 ARG    69       1.324 -12.469   7.189  1.00  0.00
ATOM   1099  CG  ARG    69       0.092 -11.782   8.808  1.00  0.00
ATOM   1100  HG1 ARG    69       0.529 -10.788   8.858  1.00  0.00
ATOM   1101  HG2 ARG    69      -0.149 -12.105   9.814  1.00  0.00
ATOM   1102  CD  ARG    69      -1.205 -11.704   8.003  1.00  0.00
ATOM   1103  HD1 ARG    69      -1.619 -12.701   7.892  1.00  0.00
ATOM   1104  HD2 ARG    69      -0.986 -11.296   7.020  1.00  0.00
ATOM   1105  NE  ARG    69      -2.195 -10.844   8.682  1.00  0.00
ATOM   1106  HE  ARG    69      -2.097 -10.746   9.658  1.00  0.00
ATOM   1107  CZ  ARG    69      -3.204 -10.199   8.083  1.00  0.00
ATOM   1108  NH1 ARG    69      -3.389 -10.298   6.771  1.00  0.00
ATOM   1109 HH11 ARG    69      -2.775 -10.859   6.216  1.00  0.00
ATOM   1110 HH12 ARG    69      -4.145  -9.809   6.327  1.00  0.00
ATOM   1111  NH2 ARG    69      -4.023  -9.449   8.808  1.00  0.00
ATOM   1112 HH21 ARG    69      -3.895  -9.373   9.800  1.00  0.00
ATOM   1113 HH22 ARG    69      -4.775  -8.947   8.368  1.00  0.00
ATOM   1114  C   ARG    69       3.235 -11.423   8.819  1.00  0.00
ATOM   1115  O   ARG    69       2.846 -10.392   9.386  1.00  0.00
ATOM   1116  N   VAL    70       4.342 -11.464   8.066  1.00  0.00
ATOM   1117  HN  VAL    70       4.627 -12.333   7.703  1.00  0.00
ATOM   1118  CA  VAL    70       5.139 -10.268   7.727  1.00  0.00
ATOM   1119  HA  VAL    70       4.607  -9.388   8.089  1.00  0.00
ATOM   1120  CB  VAL    70       6.573 -10.288   8.399  1.00  0.00
ATOM   1121  HB  VAL    70       7.070  -9.362   8.142  1.00  0.00
ATOM   1122  CG1 VAL    70       6.464 -10.341   9.939  1.00  0.00
ATOM   1123 HG11 VAL    70       5.949 -11.249  10.237  1.00  0.00
ATOM   1124 HG12 VAL    70       5.908  -9.485  10.300  1.00  0.00
ATOM   1125 HG13 VAL    70       7.453 -10.331  10.382  1.00  0.00
ATOM   1126  CG2 VAL    70       7.456 -11.443   7.878  1.00  0.00
ATOM   1127 HG21 VAL    70       7.015 -12.395   8.154  1.00  0.00
ATOM   1128 HG22 VAL    70       8.449 -11.375   8.305  1.00  0.00
ATOM   1129 HG23 VAL    70       7.533 -11.390   6.797  1.00  0.00
ATOM   1130  C   VAL    70       5.254 -10.159   6.205  1.00  0.00
ATOM   1131  O   VAL    70       5.202 -11.171   5.510  1.00  0.00
ATOM   1132  N   ILE    71       5.408  -8.934   5.688  1.00  0.00
ATOM   1133  HN  ILE    71       5.460  -8.167   6.296  1.00  0.00
ATOM   1134  CA  ILE    71       5.504  -8.694   4.237  1.00  0.00
ATOM   1135  HA  ILE    71       5.712  -9.652   3.753  1.00  0.00
ATOM   1136  CB  ILE    71       4.140  -8.162   3.640  1.00  0.00
ATOM   1137  HB  ILE    71       3.419  -8.972   3.729  1.00  0.00
ATOM   1138  CG1 ILE    71       4.286  -7.810   2.124  1.00  0.00
ATOM   1139 HG11 ILE    71       4.695  -8.665   1.597  1.00  0.00
ATOM   1140 HG12 ILE    71       4.961  -6.973   2.010  1.00  0.00
ATOM   1141  CG2 ILE    71       3.573  -6.976   4.453  1.00  0.00
ATOM   1142 HG21 ILE    71       3.444  -7.275   5.485  1.00  0.00
ATOM   1143 HG22 ILE    71       2.614  -6.672   4.050  1.00  0.00
ATOM   1144 HG23 ILE    71       4.260  -6.140   4.406  1.00  0.00
ATOM   1145  CD1 ILE    71       2.987  -7.439   1.443  1.00  0.00
ATOM   1146 HD11 ILE    71       2.543  -6.583   1.935  1.00  0.00
ATOM   1147 HD12 ILE    71       2.301  -8.274   1.484  1.00  0.00
ATOM   1148 HD13 ILE    71       3.185  -7.192   0.410  1.00  0.00
ATOM   1149  C   ILE    71       6.677  -7.743   3.926  1.00  0.00
ATOM   1150  O   ILE    71       6.729  -6.606   4.414  1.00  0.00
ATOM   1151  N   VAL    72       7.647  -8.257   3.143  1.00  0.00
ATOM   1152  HN  VAL    72       7.561  -9.189   2.860  1.00  0.00
ATOM   1153  CA  VAL    72       8.823  -7.508   2.680  1.00  0.00
ATOM   1154  HA  VAL    72       8.838  -6.531   3.166  1.00  0.00
ATOM   1155  CB  VAL    72      10.159  -8.271   3.052  1.00  0.00
ATOM   1156  HB  VAL    72      10.197  -9.188   2.462  1.00  0.00
ATOM   1157  CG1 VAL    72      11.412  -7.431   2.695  1.00  0.00
ATOM   1158 HG11 VAL    72      11.407  -6.504   3.256  1.00  0.00
ATOM   1159 HG12 VAL    72      11.416  -7.203   1.634  1.00  0.00
ATOM   1160 HG13 VAL    72      12.309  -7.988   2.937  1.00  0.00
ATOM   1161  CG2 VAL    72      10.166  -8.680   4.549  1.00  0.00
ATOM   1162 HG21 VAL    72      11.070  -9.230   4.774  1.00  0.00
ATOM   1163 HG22 VAL    72       9.307  -9.308   4.762  1.00  0.00
ATOM   1164 HG23 VAL    72      10.121  -7.794   5.173  1.00  0.00
ATOM   1165  C   VAL    72       8.709  -7.316   1.152  1.00  0.00
ATOM   1166  O   VAL    72       9.061  -8.215   0.377  1.00  0.00
ATOM   1167  N   GLY    73       8.172  -6.154   0.742  1.00  0.00
ATOM   1168  HN  GLY    73       7.902  -5.501   1.421  1.00  0.00
ATOM   1169  CA  GLY    73       7.972  -5.828  -0.676  1.00  0.00
ATOM   1170  HA1 GLY    73       8.932  -5.852  -1.185  1.00  0.00
ATOM   1171  HA2 GLY    73       7.580  -4.822  -0.740  1.00  0.00
ATOM   1172  C   GLY    73       6.996  -6.771  -1.386  1.00  0.00
ATOM   1173  O   GLY    73       5.793  -6.767  -1.097  1.00  0.00
ATOM   1174  N   ASN    74       7.526  -7.594  -2.308  1.00  0.00
ATOM   1175  HN  ASN    74       8.498  -7.567  -2.448  1.00  0.00
ATOM   1176  CA  ASN    74       6.729  -8.548  -3.117  1.00  0.00
ATOM   1177  HA  ASN    74       5.713  -8.166  -3.186  1.00  0.00
ATOM   1178  CB  ASN    74       7.314  -8.665  -4.555  1.00  0.00
ATOM   1179  HB1 ASN    74       7.322  -7.683  -5.010  1.00  0.00
ATOM   1180  HB2 ASN    74       6.675  -9.315  -5.146  1.00  0.00
ATOM   1181  CG  ASN    74       8.750  -9.214  -4.594  1.00  0.00
ATOM   1182  OD1 ASN    74       9.585  -8.891  -3.742  1.00  0.00
ATOM   1183  ND2 ASN    74       9.037 -10.074  -5.557  1.00  0.00
ATOM   1184 HD21 ASN    74       8.325 -10.315  -6.189  1.00  0.00
ATOM   1185 HD22 ASN    74       9.943 -10.438  -5.598  1.00  0.00
ATOM   1186  C   ASN    74       6.680  -9.946  -2.463  1.00  0.00
ATOM   1187  O   ASN    74       6.224 -10.908  -3.082  1.00  0.00
ATOM   1188  N   VAL    75       7.108 -10.034  -1.201  1.00  0.00
ATOM   1189  HN  VAL    75       7.260  -9.199  -0.708  1.00  0.00
ATOM   1190  CA  VAL    75       7.309 -11.315  -0.489  1.00  0.00
ATOM   1191  HA  VAL    75       6.945 -12.129  -1.117  1.00  0.00
ATOM   1192  CB  VAL    75       8.848 -11.555  -0.195  1.00  0.00
ATOM   1193  HB  VAL    75       9.218 -10.684   0.349  1.00  0.00
ATOM   1194  CG1 VAL    75       9.087 -12.801   0.696  1.00  0.00
ATOM   1195 HG11 VAL    75       8.592 -12.672   1.653  1.00  0.00
ATOM   1196 HG12 VAL    75      10.147 -12.937   0.863  1.00  0.00
ATOM   1197 HG13 VAL    75       8.687 -13.683   0.207  1.00  0.00
ATOM   1198  CG2 VAL    75       9.662 -11.661  -1.510  1.00  0.00
ATOM   1199 HG21 VAL    75       9.314 -12.507  -2.091  1.00  0.00
ATOM   1200 HG22 VAL    75      10.714 -11.794  -1.282  1.00  0.00
ATOM   1201 HG23 VAL    75       9.541 -10.755  -2.094  1.00  0.00
ATOM   1202  C   VAL    75       6.515 -11.301   0.828  1.00  0.00
ATOM   1203  O   VAL    75       6.544 -10.301   1.540  1.00  0.00
ATOM   1204  N   VAL    76       5.783 -12.395   1.139  1.00  0.00
ATOM   1205  HN  VAL    76       5.728 -13.126   0.488  1.00  0.00
ATOM   1206  CA  VAL    76       5.064 -12.541   2.428  1.00  0.00
ATOM   1207  HA  VAL    76       5.338 -11.701   3.071  1.00  0.00
ATOM   1208  CB  VAL    76       3.493 -12.528   2.262  1.00  0.00
ATOM   1209  HB  VAL    76       3.200 -13.449   1.754  1.00  0.00
ATOM   1210  CG1 VAL    76       2.783 -12.508   3.646  1.00  0.00
ATOM   1211 HG11 VAL    76       1.711 -12.534   3.510  1.00  0.00
ATOM   1212 HG12 VAL    76       3.049 -11.606   4.184  1.00  0.00
ATOM   1213 HG13 VAL    76       3.086 -13.371   4.232  1.00  0.00
ATOM   1214  CG2 VAL    76       3.019 -11.344   1.389  1.00  0.00
ATOM   1215 HG21 VAL    76       3.486 -11.397   0.411  1.00  0.00
ATOM   1216 HG22 VAL    76       3.288 -10.408   1.859  1.00  0.00
ATOM   1217 HG23 VAL    76       1.945 -11.385   1.269  1.00  0.00
ATOM   1218  C   VAL    76       5.475 -13.854   3.126  1.00  0.00
ATOM   1219  O   VAL    76       5.559 -14.898   2.492  1.00  0.00
ATOM   1220  N   ILE    77       5.734 -13.766   4.433  1.00  0.00
ATOM   1221  HN  ILE    77       5.813 -12.878   4.816  1.00  0.00
ATOM   1222  CA  ILE    77       5.916 -14.910   5.337  1.00  0.00
ATOM   1223  HA  ILE    77       6.176 -15.798   4.765  1.00  0.00
ATOM   1224  CB  ILE    77       7.073 -14.588   6.362  1.00  0.00
ATOM   1225  HB  ILE    77       6.847 -13.610   6.770  1.00  0.00
ATOM   1226  CG1 ILE    77       8.463 -14.486   5.659  1.00  0.00
ATOM   1227 HG11 ILE    77       9.137 -13.928   6.297  1.00  0.00
ATOM   1228 HG12 ILE    77       8.355 -13.959   4.723  1.00  0.00
ATOM   1229  CG2 ILE    77       7.119 -15.560   7.574  1.00  0.00
ATOM   1230 HG21 ILE    77       7.923 -15.265   8.242  1.00  0.00
ATOM   1231 HG22 ILE    77       7.286 -16.571   7.234  1.00  0.00
ATOM   1232 HG23 ILE    77       6.178 -15.513   8.111  1.00  0.00
ATOM   1233  CD1 ILE    77       9.122 -15.813   5.355  1.00  0.00
ATOM   1234 HD11 ILE    77       8.436 -16.442   4.804  1.00  0.00
ATOM   1235 HD12 ILE    77       9.395 -16.301   6.279  1.00  0.00
ATOM   1236 HD13 ILE    77      10.007 -15.641   4.763  1.00  0.00
ATOM   1237  C   ILE    77       4.599 -15.127   6.100  1.00  0.00
ATOM   1238  O   ILE    77       4.265 -14.325   6.974  1.00  0.00
ATOM   1239  N   ASP    78       3.831 -16.161   5.735  1.00  0.00
ATOM   1240  HN  ASP    78       4.024 -16.623   4.895  1.00  0.00
ATOM   1241  CA  ASP    78       2.693 -16.628   6.545  1.00  0.00
ATOM   1242  HA  ASP    78       2.361 -15.800   7.176  1.00  0.00
ATOM   1243  CB  ASP    78       1.495 -17.090   5.663  1.00  0.00
ATOM   1244  HB1 ASP    78       0.808 -17.681   6.263  1.00  0.00
ATOM   1245  HB2 ASP    78       1.871 -17.715   4.859  1.00  0.00
ATOM   1246  CG  ASP    78       0.722 -15.907   5.051  1.00  0.00
ATOM   1247  OD1 ASP    78      -0.279 -15.444   5.664  1.00  0.00
ATOM   1248  OD2 ASP    78       1.123 -15.426   3.972  1.00  0.00
ATOM   1249  C   ASP    78       3.178 -17.755   7.453  1.00  0.00
ATOM   1250  O   ASP    78       3.447 -18.863   6.993  1.00  0.00
ATOM   1251  N   HIS    79       3.324 -17.435   8.743  1.00  0.00
ATOM   1252  HN  HIS    79       3.119 -16.519   9.012  1.00  0.00
ATOM   1253  CA  HIS    79       3.748 -18.381   9.770  1.00  0.00
ATOM   1254  HA  HIS    79       4.225 -19.233   9.284  1.00  0.00
ATOM   1255  CB  HIS    79       4.778 -17.711  10.721  1.00  0.00
ATOM   1256  HB1 HIS    79       4.334 -16.814  11.146  1.00  0.00
ATOM   1257  HB2 HIS    79       5.650 -17.421  10.147  1.00  0.00
ATOM   1258  CG  HIS    79       5.266 -18.576  11.867  1.00  0.00
ATOM   1259  ND1 HIS    79       5.141 -19.954  11.901  1.00  0.00
ATOM   1260  HD1 HIS    79       4.729 -20.508  11.208  1.00  0.00
ATOM   1261  CD2 HIS    79       5.881 -18.238  13.023  1.00  0.00
ATOM   1262  HD2 HIS    79       6.149 -17.237  13.337  1.00  0.00
ATOM   1263  CE1 HIS    79       5.651 -20.417  13.021  1.00  0.00
ATOM   1264  HE1 HIS    79       5.647 -21.450  13.340  1.00  0.00
ATOM   1265  NE2 HIS    79       6.108 -19.397  13.721  1.00  0.00
ATOM   1266  HE2 HIS    79       6.411 -19.446  14.651  1.00  0.00
ATOM   1267  C   HIS    79       2.505 -18.858  10.529  1.00  0.00
ATOM   1268  O   HIS    79       1.921 -18.112  11.330  1.00  0.00
ATOM   1269  N   GLU    80       2.124 -20.108  10.258  1.00  0.00
ATOM   1270  HN  GLU    80       2.686 -20.635   9.644  1.00  0.00
ATOM   1271  CA  GLU    80       0.924 -20.760  10.804  1.00  0.00
ATOM   1272  HA  GLU    80       0.514 -20.115  11.578  1.00  0.00
ATOM   1273  CB  GLU    80      -0.175 -20.959   9.682  1.00  0.00
ATOM   1274  HB1 GLU    80      -0.900 -20.154   9.758  1.00  0.00
ATOM   1275  HB2 GLU    80      -0.700 -21.893   9.862  1.00  0.00
ATOM   1276  CG  GLU    80       0.335 -20.987   8.215  1.00  0.00
ATOM   1277  HG1 GLU    80       0.813 -20.034   8.008  1.00  0.00
ATOM   1278  HG2 GLU    80      -0.520 -21.089   7.549  1.00  0.00
ATOM   1279  CD  GLU    80       1.327 -22.123   7.905  1.00  0.00
ATOM   1280  OE1 GLU    80       0.900 -23.297   7.853  1.00  0.00
ATOM   1281  OE2 GLU    80       2.529 -21.843   7.704  1.00  0.00
ATOM   1282  C   GLU    80       1.303 -22.088  11.480  1.00  0.00
ATOM   1283  O   GLU    80       2.444 -22.541  11.390  1.00  0.00
ATOM   1284  N   THR    81       0.341 -22.666  12.209  1.00  0.00
ATOM   1285  HN  THR    81      -0.501 -22.191  12.319  1.00  0.00
ATOM   1286  CA  THR    81       0.474 -23.983  12.842  1.00  0.00
ATOM   1287  HA  THR    81       1.480 -24.371  12.650  1.00  0.00
ATOM   1288  CB  THR    81       0.261 -23.908  14.389  1.00  0.00
ATOM   1289  HB  THR    81      -0.787 -23.710  14.592  1.00  0.00
ATOM   1290  OG1 THR    81       1.039 -22.837  14.930  1.00  0.00
ATOM   1291  HG1 THR    81       1.976 -23.062  14.888  1.00  0.00
ATOM   1292  CG2 THR    81       0.660 -25.216  15.097  1.00  0.00
ATOM   1293 HG21 THR    81       0.482 -25.123  16.161  1.00  0.00
ATOM   1294 HG22 THR    81       1.711 -25.421  14.928  1.00  0.00
ATOM   1295 HG23 THR    81       0.070 -26.040  14.711  1.00  0.00
ATOM   1296  C   THR    81      -0.563 -24.926  12.218  1.00  0.00
ATOM   1297  O   THR    81      -1.772 -24.750  12.420  1.00  0.00
ATOM   1298  N   VAL    82      -0.083 -25.896  11.437  1.00  0.00
ATOM   1299  HN  VAL    82       0.879 -25.935  11.288  1.00  0.00
ATOM   1300  CA  VAL    82      -0.929 -26.888  10.775  1.00  0.00
ATOM   1301  HA  VAL    82      -1.840 -26.394  10.432  1.00  0.00
ATOM   1302  CB  VAL    82      -0.208 -27.516   9.527  1.00  0.00
ATOM   1303  HB  VAL    82       0.646 -28.088   9.892  1.00  0.00
ATOM   1304  CG1 VAL    82      -1.137 -28.498   8.783  1.00  0.00
ATOM   1305 HG11 VAL    82      -1.435 -29.296   9.457  1.00  0.00
ATOM   1306 HG12 VAL    82      -0.621 -28.927   7.934  1.00  0.00
ATOM   1307 HG13 VAL    82      -2.021 -27.976   8.438  1.00  0.00
ATOM   1308  CG2 VAL    82       0.337 -26.425   8.585  1.00  0.00
ATOM   1309 HG21 VAL    82       0.824 -26.885   7.735  1.00  0.00
ATOM   1310 HG22 VAL    82       1.059 -25.812   9.117  1.00  0.00
ATOM   1311 HG23 VAL    82      -0.475 -25.799   8.238  1.00  0.00
ATOM   1312  C   VAL    82      -1.296 -28.010  11.758  1.00  0.00
ATOM   1313  O   VAL    82      -0.461 -28.864  12.069  1.00  0.00
ATOM   1314  N   THR    83      -2.536 -27.975  12.262  1.00  0.00
ATOM   1315  HN  THR    83      -3.078 -27.181  12.119  1.00  0.00
ATOM   1316  CA  THR    83      -3.105 -29.082  13.035  1.00  0.00
ATOM   1317  HA  THR    83      -2.412 -29.323  13.839  1.00  0.00
ATOM   1318  CB  THR    83      -4.481 -28.685  13.668  1.00  0.00
ATOM   1319  HB  THR    83      -5.160 -28.404  12.867  1.00  0.00
ATOM   1320  OG1 THR    83      -4.309 -27.544  14.529  1.00  0.00
ATOM   1321  HG1 THR    83      -3.679 -26.932  14.133  1.00  0.00
ATOM   1322  CG2 THR    83      -5.123 -29.845  14.468  1.00  0.00
ATOM   1323 HG21 THR    83      -4.452 -30.164  15.257  1.00  0.00
ATOM   1324 HG22 THR    83      -5.319 -30.683  13.809  1.00  0.00
ATOM   1325 HG23 THR    83      -6.058 -29.516  14.906  1.00  0.00
ATOM   1326  C   THR    83      -3.273 -30.305  12.114  1.00  0.00
ATOM   1327  O   THR    83      -3.958 -30.228  11.087  1.00  0.00
ATOM   1328  N   ARG    84      -2.578 -31.394  12.467  1.00  0.00
ATOM   1329  HN  ARG    84      -1.972 -31.324  13.232  1.00  0.00
ATOM   1330  CA  ARG    84      -2.657 -32.694  11.781  1.00  0.00
ATOM   1331  HA  ARG    84      -3.432 -32.655  11.018  1.00  0.00
ATOM   1332  CB  ARG    84      -1.281 -33.031  11.121  1.00  0.00
ATOM   1333  HB1 ARG    84      -1.383 -33.960  10.565  1.00  0.00
ATOM   1334  HB2 ARG    84      -0.548 -33.183  11.909  1.00  0.00
ATOM   1335  CG  ARG    84      -0.732 -31.946  10.157  1.00  0.00
ATOM   1336  HG1 ARG    84      -0.660 -31.004  10.698  1.00  0.00
ATOM   1337  HG2 ARG    84      -1.423 -31.826   9.334  1.00  0.00
ATOM   1338  CD  ARG    84       0.658 -32.295   9.587  1.00  0.00
ATOM   1339  HD1 ARG    84       0.579 -33.224   9.033  1.00  0.00
ATOM   1340  HD2 ARG    84       1.346 -32.434  10.413  1.00  0.00
ATOM   1341  NE  ARG    84       1.205 -31.246   8.692  1.00  0.00
ATOM   1342  HE  ARG    84       0.848 -30.336   8.810  1.00  0.00
ATOM   1343  CZ  ARG    84       2.180 -31.435   7.775  1.00  0.00
ATOM   1344  NH1 ARG    84       2.668 -32.650   7.536  1.00  0.00
ATOM   1345 HH11 ARG    84       2.318 -33.441   8.044  1.00  0.00
ATOM   1346 HH12 ARG    84       3.395 -32.782   6.857  1.00  0.00
ATOM   1347  NH2 ARG    84       2.654 -30.397   7.089  1.00  0.00
ATOM   1348 HH21 ARG    84       2.292 -29.477   7.252  1.00  0.00
ATOM   1349 HH22 ARG    84       3.387 -30.528   6.414  1.00  0.00
ATOM   1350  C   ARG    84      -3.039 -33.762  12.825  1.00  0.00
ATOM   1351  O   ARG    84      -3.453 -33.417  13.938  1.00  0.00
ATOM   1352  N   ASN    85      -2.949 -35.050  12.453  1.00  0.00
ATOM   1353  HN  ASN    85      -2.807 -35.252  11.503  1.00  0.00
ATOM   1354  CA  ASN    85      -3.068 -36.183  13.401  1.00  0.00
ATOM   1355  HA  ASN    85      -3.227 -35.777  14.401  1.00  0.00
ATOM   1356  CB  ASN    85      -4.278 -37.105  13.042  1.00  0.00
ATOM   1357  HB1 ASN    85      -4.060 -38.119  13.370  1.00  0.00
ATOM   1358  HB2 ASN    85      -4.403 -37.118  11.968  1.00  0.00
ATOM   1359  CG  ASN    85      -5.617 -36.685  13.664  1.00  0.00
ATOM   1360  OD1 ASN    85      -6.453 -37.533  13.983  1.00  0.00
ATOM   1361  ND2 ASN    85      -5.859 -35.394  13.817  1.00  0.00
ATOM   1362 HD21 ASN    85      -5.182 -34.752  13.529  1.00  0.00
ATOM   1363 HD22 ASN    85      -6.711 -35.132  14.223  1.00  0.00
ATOM   1364  C   ASN    85      -1.755 -36.982  13.410  1.00  0.00
ATOM   1365  O   ASN    85      -1.404 -37.632  12.418  1.00  0.00
ATOM   1366  N   PHE    86      -1.007 -36.881  14.523  1.00  0.00
ATOM   1367  HN  PHE    86      -1.294 -36.250  15.215  1.00  0.00
ATOM   1368  CA  PHE    86       0.217 -37.682  14.766  1.00  0.00
ATOM   1369  HA  PHE    86       0.519 -38.136  13.820  1.00  0.00
ATOM   1370  CB  PHE    86       1.375 -36.779  15.290  1.00  0.00
ATOM   1371  HB1 PHE    86       2.135 -37.406  15.746  1.00  0.00
ATOM   1372  HB2 PHE    86       0.983 -36.113  16.047  1.00  0.00
ATOM   1373  CG  PHE    86       2.077 -35.904  14.242  1.00  0.00
ATOM   1374  CD1 PHE    86       3.156 -35.097  14.611  1.00  0.00
ATOM   1375  HD1 PHE    86       3.492 -35.097  15.642  1.00  0.00
ATOM   1376  CD2 PHE    86       1.674 -35.879  12.903  1.00  0.00
ATOM   1377  HD2 PHE    86       0.841 -36.492  12.584  1.00  0.00
ATOM   1378  CE1 PHE    86       3.798 -34.301  13.681  1.00  0.00
ATOM   1379  HE1 PHE    86       4.630 -33.680  13.983  1.00  0.00
ATOM   1380  CE2 PHE    86       2.321 -35.081  11.980  1.00  0.00
ATOM   1381  HE2 PHE    86       1.997 -35.076  10.951  1.00  0.00
ATOM   1382  CZ  PHE    86       3.381 -34.297  12.368  1.00  0.00
ATOM   1383  HZ  PHE    86       3.888 -33.670  11.641  1.00  0.00
ATOM   1384  C   PHE    86      -0.083 -38.813  15.772  1.00  0.00
ATOM   1385  O   PHE    86      -0.908 -38.631  16.671  1.00  0.00
ATOM   1386  N   PRO    87       0.586 -40.007  15.644  1.00  0.00
ATOM   1387  CA  PRO    87       0.304 -41.188  16.506  1.00  0.00
ATOM   1388  HA  PRO    87      -0.753 -41.430  16.487  1.00  0.00
ATOM   1389  CB  PRO    87       1.090 -42.324  15.810  1.00  0.00
ATOM   1390  HB1 PRO    87       0.450 -42.828  15.088  1.00  0.00
ATOM   1391  HB2 PRO    87       1.439 -43.050  16.538  1.00  0.00
ATOM   1392  CG  PRO    87       2.225 -41.625  15.135  1.00  0.00
ATOM   1393  HG1 PRO    87       2.594 -42.216  14.303  1.00  0.00
ATOM   1394  HG2 PRO    87       3.031 -41.449  15.847  1.00  0.00
ATOM   1395  CD  PRO    87       1.650 -40.316  14.643  1.00  0.00
ATOM   1396  HD1 PRO    87       1.221 -40.430  13.654  1.00  0.00
ATOM   1397  HD2 PRO    87       2.411 -39.543  14.634  1.00  0.00
ATOM   1398  C   PRO    87       0.735 -41.013  17.986  1.00  0.00
ATOM   1399  O   PRO    87       0.406 -41.861  18.826  1.00  0.00
ATOM   1400  N   GLU    88       1.487 -39.932  18.296  1.00  0.00
ATOM   1401  HN  GLU    88       1.811 -39.361  17.568  1.00  0.00
ATOM   1402  CA  GLU    88       1.846 -39.587  19.694  1.00  0.00
ATOM   1403  HA  GLU    88       1.801 -40.508  20.274  1.00  0.00
ATOM   1404  CB  GLU    88       3.298 -39.019  19.810  1.00  0.00
ATOM   1405  HB1 GLU    88       3.992 -39.824  19.590  1.00  0.00
ATOM   1406  HB2 GLU    88       3.468 -38.713  20.839  1.00  0.00
ATOM   1407  CG  GLU    88       3.637 -37.816  18.889  1.00  0.00
ATOM   1408  HG1 GLU    88       4.235 -37.099  19.455  1.00  0.00
ATOM   1409  HG2 GLU    88       2.711 -37.325  18.599  1.00  0.00
ATOM   1410  CD  GLU    88       4.401 -38.201  17.607  1.00  0.00
ATOM   1411  OE1 GLU    88       3.776 -38.731  16.671  1.00  0.00
ATOM   1412  OE2 GLU    88       5.635 -37.981  17.541  1.00  0.00
ATOM   1413  C   GLU    88       0.823 -38.610  20.322  1.00  0.00
ATOM   1414  O   GLU    88       0.815 -38.439  21.545  1.00  0.00
ATOM   1415  N   GLY    89      -0.036 -37.962  19.498  1.00  0.00
ATOM   1416  HN  GLY    89       0.070 -38.056  18.526  1.00  0.00
ATOM   1417  CA  GLY    89      -1.120 -37.115  20.036  1.00  0.00
ATOM   1418  HA1 GLY    89      -0.733 -36.528  20.864  1.00  0.00
ATOM   1419  HA2 GLY    89      -1.902 -37.760  20.417  1.00  0.00
ATOM   1420  C   GLY    89      -1.738 -36.173  19.008  1.00  0.00
ATOM   1421  O   GLY    89      -2.265 -36.634  17.995  1.00  0.00
ATOM   1422  N   LYS    90      -1.688 -34.849  19.296  1.00  0.00
ATOM   1423  HN  LYS    90      -1.292 -34.580  20.148  1.00  0.00
ATOM   1424  CA  LYS    90      -2.228 -33.784  18.429  1.00  0.00
ATOM   1425  HA  LYS    90      -3.308 -33.929  18.384  1.00  0.00
ATOM   1426  CB  LYS    90      -1.953 -32.399  19.091  1.00  0.00
ATOM   1427  HB1 LYS    90      -0.889 -32.329  19.303  1.00  0.00
ATOM   1428  HB2 LYS    90      -2.482 -32.361  20.036  1.00  0.00
ATOM   1429  CG  LYS    90      -2.358 -31.147  18.270  1.00  0.00
ATOM   1430  HG1 LYS    90      -1.761 -31.127  17.361  1.00  0.00
ATOM   1431  HG2 LYS    90      -2.120 -30.263  18.854  1.00  0.00
ATOM   1432  CD  LYS    90      -3.857 -31.081  17.883  1.00  0.00
ATOM   1433  HD1 LYS    90      -4.078 -31.901  17.205  1.00  0.00
ATOM   1434  HD2 LYS    90      -4.036 -30.146  17.364  1.00  0.00
ATOM   1435  CE  LYS    90      -4.812 -31.157  19.088  1.00  0.00
ATOM   1436  HE1 LYS    90      -4.460 -30.494  19.864  1.00  0.00
ATOM   1437  HE2 LYS    90      -4.825 -32.172  19.468  1.00  0.00
ATOM   1438  NZ  LYS    90      -6.199 -30.777  18.717  1.00  0.00
ATOM   1439  HZ1 LYS    90      -6.576 -31.434  18.006  1.00  0.00
ATOM   1440  HZ2 LYS    90      -6.210 -29.813  18.321  1.00  0.00
ATOM   1441  HZ3 LYS    90      -6.816 -30.796  19.553  1.00  0.00
ATOM   1442  C   LYS    90      -1.669 -33.871  16.986  1.00  0.00
ATOM   1443  O   LYS    90      -2.296 -34.497  16.132  1.00  0.00
ATOM   1444  N   GLY    91      -0.478 -33.289  16.736  1.00  0.00
ATOM   1445  HN  GLY    91       0.003 -32.854  17.467  1.00  0.00
ATOM   1446  CA  GLY    91       0.113 -33.291  15.396  1.00  0.00
ATOM   1447  HA1 GLY    91      -0.475 -33.914  14.730  1.00  0.00
ATOM   1448  HA2 GLY    91       1.103 -33.721  15.472  1.00  0.00
ATOM   1449  C   GLY    91       0.249 -31.907  14.791  1.00  0.00
ATOM   1450  O   GLY    91       0.259 -31.760  13.567  1.00  0.00
ATOM   1451  N   GLU    92       0.402 -30.891  15.643  1.00  0.00
ATOM   1452  HN  GLU    92       0.538 -31.090  16.594  1.00  0.00
ATOM   1453  CA  GLU    92       0.411 -29.488  15.201  1.00  0.00
ATOM   1454  HA  GLU    92      -0.198 -29.405  14.301  1.00  0.00
ATOM   1455  CB  GLU    92      -0.210 -28.587  16.309  1.00  0.00
ATOM   1456  HB1 GLU    92      -1.247 -28.882  16.459  1.00  0.00
ATOM   1457  HB2 GLU    92      -0.200 -27.559  15.966  1.00  0.00
ATOM   1458  CG  GLU    92       0.511 -28.654  17.679  1.00  0.00
ATOM   1459  HG1 GLU    92       1.559 -28.392  17.534  1.00  0.00
ATOM   1460  HG2 GLU    92       0.465 -29.680  18.035  1.00  0.00
ATOM   1461  CD  GLU    92      -0.076 -27.730  18.754  1.00  0.00
ATOM   1462  OE1 GLU    92      -0.596 -28.231  19.775  1.00  0.00
ATOM   1463  OE2 GLU    92       0.010 -26.494  18.591  1.00  0.00
ATOM   1464  C   GLU    92       1.855 -29.069  14.862  1.00  0.00
ATOM   1465  O   GLU    92       2.758 -29.163  15.701  1.00  0.00
ATOM   1466  N   VAL    93       2.091 -28.670  13.592  1.00  0.00
ATOM   1467  HN  VAL    93       1.333 -28.599  12.963  1.00  0.00
ATOM   1468  CA  VAL    93       3.437 -28.330  13.109  1.00  0.00
ATOM   1469  HA  VAL    93       4.136 -28.473  13.938  1.00  0.00
ATOM   1470  CB  VAL    93       3.893 -29.287  11.940  1.00  0.00
ATOM   1471  HB  VAL    93       4.913 -29.019  11.665  1.00  0.00
ATOM   1472  CG1 VAL    93       3.922 -30.751  12.432  1.00  0.00
ATOM   1473 HG11 VAL    93       2.920 -31.068  12.705  1.00  0.00
ATOM   1474 HG12 VAL    93       4.560 -30.833  13.302  1.00  0.00
ATOM   1475 HG13 VAL    93       4.300 -31.398  11.653  1.00  0.00
ATOM   1476  CG2 VAL    93       3.006 -29.154  10.680  1.00  0.00
ATOM   1477 HG21 VAL    93       1.980 -29.407  10.925  1.00  0.00
ATOM   1478 HG22 VAL    93       3.360 -29.821   9.903  1.00  0.00
ATOM   1479 HG23 VAL    93       3.042 -28.135  10.314  1.00  0.00
ATOM   1480  C   VAL    93       3.493 -26.853  12.707  1.00  0.00
ATOM   1481  O   VAL    93       2.693 -26.383  11.896  1.00  0.00
ATOM   1482  N   ASP    94       4.421 -26.119  13.325  1.00  0.00
ATOM   1483  HN  ASP    94       5.019 -26.570  13.963  1.00  0.00
ATOM   1484  CA  ASP    94       4.590 -24.676  13.099  1.00  0.00
ATOM   1485  HA  ASP    94       3.610 -24.233  12.925  1.00  0.00
ATOM   1486  CB  ASP    94       5.220 -24.007  14.345  1.00  0.00
ATOM   1487  HB1 ASP    94       5.388 -22.954  14.128  1.00  0.00
ATOM   1488  HB2 ASP    94       6.183 -24.469  14.550  1.00  0.00
ATOM   1489  CG  ASP    94       4.342 -24.122  15.607  1.00  0.00
ATOM   1490  OD1 ASP    94       4.199 -25.244  16.141  1.00  0.00
ATOM   1491  OD2 ASP    94       3.815 -23.093  16.083  1.00  0.00
ATOM   1492  C   ASP    94       5.467 -24.462  11.857  1.00  0.00
ATOM   1493  O   ASP    94       6.667 -24.705  11.899  1.00  0.00
ATOM   1494  N   VAL    95       4.844 -24.006  10.764  1.00  0.00
ATOM   1495  HN  VAL    95       3.900 -23.767  10.842  1.00  0.00
ATOM   1496  CA  VAL    95       5.474 -23.850   9.440  1.00  0.00
ATOM   1497  HA  VAL    95       6.475 -24.278   9.461  1.00  0.00
ATOM   1498  CB  VAL    95       4.616 -24.600   8.339  1.00  0.00
ATOM   1499  HB  VAL    95       3.704 -24.046   8.214  1.00  0.00
ATOM   1500  CG1 VAL    95       5.309 -24.625   6.956  1.00  0.00
ATOM   1501 HG11 VAL    95       5.489 -23.609   6.618  1.00  0.00
ATOM   1502 HG12 VAL    95       4.680 -25.130   6.235  1.00  0.00
ATOM   1503 HG13 VAL    95       6.254 -25.146   7.033  1.00  0.00
ATOM   1504  CG2 VAL    95       4.215 -26.020   8.799  1.00  0.00
ATOM   1505 HG21 VAL    95       3.629 -25.959   9.713  1.00  0.00
ATOM   1506 HG22 VAL    95       5.102 -26.609   8.986  1.00  0.00
ATOM   1507 HG23 VAL    95       3.621 -26.503   8.031  1.00  0.00
ATOM   1508  C   VAL    95       5.557 -22.353   9.085  1.00  0.00
ATOM   1509  O   VAL    95       4.736 -21.559   9.544  1.00  0.00
ATOM   1510  N   ALA    96       6.583 -21.973   8.314  1.00  0.00
ATOM   1511  HN  ALA    96       7.309 -22.602   8.168  1.00  0.00
ATOM   1512  CA  ALA    96       6.671 -20.654   7.672  1.00  0.00
ATOM   1513  HA  ALA    96       5.835 -20.037   8.010  1.00  0.00
ATOM   1514  CB  ALA    96       7.980 -19.942   8.058  1.00  0.00
ATOM   1515  HB1 ALA    96       8.015 -19.803   9.132  1.00  0.00
ATOM   1516  HB2 ALA    96       8.025 -18.974   7.577  1.00  0.00
ATOM   1517  HB3 ALA    96       8.833 -20.535   7.748  1.00  0.00
ATOM   1518  C   ALA    96       6.565 -20.844   6.153  1.00  0.00
ATOM   1519  O   ALA    96       7.519 -21.300   5.508  1.00  0.00
ATOM   1520  N   CYS    97       5.387 -20.537   5.597  1.00  0.00
ATOM   1521  HN  CYS    97       4.653 -20.258   6.180  1.00  0.00
ATOM   1522  CA  CYS    97       5.136 -20.600   4.158  1.00  0.00
ATOM   1523  HA  CYS    97       5.833 -21.314   3.713  1.00  0.00
ATOM   1524  CB  CYS    97       3.695 -21.078   3.890  1.00  0.00
ATOM   1525  HB1 CYS    97       3.517 -21.101   2.822  1.00  0.00
ATOM   1526  HB2 CYS    97       2.997 -20.395   4.352  1.00  0.00
ATOM   1527  SG  CYS    97       3.345 -22.732   4.533  1.00  0.00
ATOM   1528  HG  CYS    97       2.775 -22.594   5.722  1.00  0.00
ATOM   1529  C   CYS    97       5.387 -19.209   3.562  1.00  0.00
ATOM   1530  O   CYS    97       4.641 -18.262   3.822  1.00  0.00
ATOM   1531  N   ILE    98       6.480 -19.101   2.804  1.00  0.00
ATOM   1532  HN  ILE    98       7.002 -19.913   2.642  1.00  0.00
ATOM   1533  CA  ILE    98       6.934 -17.849   2.180  1.00  0.00
ATOM   1534  HA  ILE    98       6.455 -17.017   2.702  1.00  0.00
ATOM   1535  CB  ILE    98       8.501 -17.678   2.336  1.00  0.00
ATOM   1536  HB  ILE    98       8.687 -17.488   3.387  1.00  0.00
ATOM   1537  CG1 ILE    98       9.025 -16.440   1.527  1.00  0.00
ATOM   1538 HG11 ILE    98       8.550 -15.545   1.910  1.00  0.00
ATOM   1539 HG12 ILE    98       8.756 -16.554   0.485  1.00  0.00
ATOM   1540  CG2 ILE    98       9.270 -18.977   1.998  1.00  0.00
ATOM   1541 HG21 ILE    98      10.334 -18.829   2.137  1.00  0.00
ATOM   1542 HG22 ILE    98       9.081 -19.261   0.972  1.00  0.00
ATOM   1543 HG23 ILE    98       8.935 -19.778   2.650  1.00  0.00
ATOM   1544  CD1 ILE    98      10.530 -16.210   1.574  1.00  0.00
ATOM   1545 HD11 ILE    98      11.047 -17.061   1.148  1.00  0.00
ATOM   1546 HD12 ILE    98      10.849 -16.068   2.596  1.00  0.00
ATOM   1547 HD13 ILE    98      10.770 -15.325   1.000  1.00  0.00
ATOM   1548  C   ILE    98       6.500 -17.817   0.702  1.00  0.00
ATOM   1549  O   ILE    98       6.639 -18.801  -0.012  1.00  0.00
ATOM   1550  N   TYR    99       5.959 -16.675   0.255  1.00  0.00
ATOM   1551  HN  TYR    99       5.921 -15.917   0.861  1.00  0.00
ATOM   1552  CA  TYR    99       5.429 -16.498  -1.110  1.00  0.00
ATOM   1553  HA  TYR    99       5.624 -17.406  -1.680  1.00  0.00
ATOM   1554  CB  TYR    99       3.895 -16.233  -1.087  1.00  0.00
ATOM   1555  HB1 TYR    99       3.512 -16.290  -2.104  1.00  0.00
ATOM   1556  HB2 TYR    99       3.708 -15.233  -0.706  1.00  0.00
ATOM   1557  CG  TYR    99       3.089 -17.221  -0.227  1.00  0.00
ATOM   1558  CD1 TYR    99       2.606 -18.425  -0.749  1.00  0.00
ATOM   1559  HD1 TYR    99       2.793 -18.660  -1.787  1.00  0.00
ATOM   1560  CD2 TYR    99       2.826 -16.947   1.118  1.00  0.00
ATOM   1561  HD2 TYR    99       3.189 -16.020   1.550  1.00  0.00
ATOM   1562  CE1 TYR    99       1.893 -19.310   0.036  1.00  0.00
ATOM   1563  HE1 TYR    99       1.530 -20.238  -0.389  1.00  0.00
ATOM   1564  CE2 TYR    99       2.112 -17.830   1.902  1.00  0.00
ATOM   1565  HE2 TYR    99       1.922 -17.591   2.943  1.00  0.00
ATOM   1566  CZ  TYR    99       1.647 -19.007   1.361  1.00  0.00
ATOM   1567  OH  TYR    99       0.941 -19.891   2.150  1.00  0.00
ATOM   1568  HH  TYR    99       0.481 -19.401   2.843  1.00  0.00
ATOM   1569  C   TYR    99       6.133 -15.323  -1.793  1.00  0.00
ATOM   1570  O   TYR    99       6.636 -14.416  -1.131  1.00  0.00
ATOM   1571  N   GLU   100       6.140 -15.362  -3.120  1.00  0.00
ATOM   1572  HN  GLU   100       5.799 -16.168  -3.552  1.00  0.00
ATOM   1573  CA  GLU   100       6.635 -14.292  -3.986  1.00  0.00
ATOM   1574  HA  GLU   100       6.837 -13.403  -3.389  1.00  0.00
ATOM   1575  CB  GLU   100       7.924 -14.756  -4.689  1.00  0.00
ATOM   1576  HB1 GLU   100       7.710 -15.675  -5.228  1.00  0.00
ATOM   1577  HB2 GLU   100       8.666 -14.976  -3.929  1.00  0.00
ATOM   1578  CG  GLU   100       8.539 -13.747  -5.672  1.00  0.00
ATOM   1579  HG1 GLU   100       9.022 -12.957  -5.104  1.00  0.00
ATOM   1580  HG2 GLU   100       7.746 -13.305  -6.273  1.00  0.00
ATOM   1581  CD  GLU   100       9.573 -14.401  -6.605  1.00  0.00
ATOM   1582  OE1 GLU   100      10.791 -14.386  -6.294  1.00  0.00
ATOM   1583  OE2 GLU   100       9.166 -14.934  -7.661  1.00  0.00
ATOM   1584  C   GLU   100       5.548 -13.992  -5.020  1.00  0.00
ATOM   1585  O   GLU   100       5.161 -14.879  -5.779  1.00  0.00
ATOM   1586  N   VAL   101       5.052 -12.755  -5.023  1.00  0.00
ATOM   1587  HN  VAL   101       5.439 -12.110  -4.407  1.00  0.00
ATOM   1588  CA  VAL   101       3.972 -12.303  -5.902  1.00  0.00
ATOM   1589  HA  VAL   101       3.516 -13.172  -6.376  1.00  0.00
ATOM   1590  CB  VAL   101       2.862 -11.562  -5.069  1.00  0.00
ATOM   1591  HB  VAL   101       3.329 -10.703  -4.590  1.00  0.00
ATOM   1592  CG1 VAL   101       1.715 -11.036  -5.970  1.00  0.00
ATOM   1593 HG11 VAL   101       1.243 -11.864  -6.486  1.00  0.00
ATOM   1594 HG12 VAL   101       2.108 -10.340  -6.704  1.00  0.00
ATOM   1595 HG13 VAL   101       0.975 -10.526  -5.364  1.00  0.00
ATOM   1596  CG2 VAL   101       2.309 -12.478  -3.948  1.00  0.00
ATOM   1597 HG21 VAL   101       1.829 -13.343  -4.391  1.00  0.00
ATOM   1598 HG22 VAL   101       1.583 -11.934  -3.354  1.00  0.00
ATOM   1599 HG23 VAL   101       3.117 -12.808  -3.305  1.00  0.00
ATOM   1600  C   VAL   101       4.542 -11.376  -6.989  1.00  0.00
ATOM   1601  O   VAL   101       5.094 -10.313  -6.680  1.00  0.00
ATOM   1602  N   GLU   102       4.414 -11.797  -8.255  1.00  0.00
ATOM   1603  HN  GLU   102       4.015 -12.676  -8.413  1.00  0.00
ATOM   1604  CA  GLU   102       4.833 -11.014  -9.426  1.00  0.00
ATOM   1605  HA  GLU   102       5.103 -10.015  -9.088  1.00  0.00
ATOM   1606  CB  GLU   102       6.062 -11.670 -10.097  1.00  0.00
ATOM   1607  HB1 GLU   102       5.778 -12.660 -10.438  1.00  0.00
ATOM   1608  HB2 GLU   102       6.847 -11.774  -9.356  1.00  0.00
ATOM   1609  CG  GLU   102       6.631 -10.893 -11.295  1.00  0.00
ATOM   1610  HG1 GLU   102       6.831  -9.871 -10.984  1.00  0.00
ATOM   1611  HG2 GLU   102       5.880 -10.874 -12.075  1.00  0.00
ATOM   1612  CD  GLU   102       7.921 -11.503 -11.871  1.00  0.00
ATOM   1613  OE1 GLU   102       7.840 -12.466 -12.663  1.00  0.00
ATOM   1614  OE2 GLU   102       9.026 -11.036 -11.517  1.00  0.00
ATOM   1615  C   GLU   102       3.654 -10.904 -10.411  1.00  0.00
ATOM   1616  O   GLU   102       2.986 -11.901 -10.698  1.00  0.00
ATOM   1617  N   ASN   103       3.415  -9.671 -10.900  1.00  0.00
ATOM   1618  HN  ASN   103       4.039  -8.959 -10.649  1.00  0.00
ATOM   1619  CA  ASN   103       2.282  -9.312 -11.789  1.00  0.00
ATOM   1620  HA  ASN   103       2.366  -8.247 -11.968  1.00  0.00
ATOM   1621  CB  ASN   103       2.369 -10.049 -13.169  1.00  0.00
ATOM   1622  HB1 ASN   103       1.503  -9.781 -13.766  1.00  0.00
ATOM   1623  HB2 ASN   103       2.346 -11.118 -12.998  1.00  0.00
ATOM   1624  CG  ASN   103       3.638  -9.702 -13.971  1.00  0.00
ATOM   1625  OD1 ASN   103       3.676  -8.714 -14.704  1.00  0.00
ATOM   1626  ND2 ASN   103       4.669 -10.528 -13.866  1.00  0.00
ATOM   1627 HD21 ASN   103       4.576 -11.319 -13.290  1.00  0.00
ATOM   1628 HD22 ASN   103       5.485 -10.318 -14.365  1.00  0.00
ATOM   1629  C   ASN   103       0.907  -9.560 -11.102  1.00  0.00
ATOM   1630  O   ASN   103      -0.110  -9.771 -11.776  1.00  0.00
ATOM   1631  N   GLY   104       0.884  -9.459  -9.754  1.00  0.00
ATOM   1632  HN  GLY   104       1.727  -9.269  -9.290  1.00  0.00
ATOM   1633  CA  GLY   104      -0.350  -9.611  -8.961  1.00  0.00
ATOM   1634  HA1 GLY   104      -1.184  -9.203  -9.520  1.00  0.00
ATOM   1635  HA2 GLY   104      -0.237  -9.035  -8.053  1.00  0.00
ATOM   1636  C   GLY   104      -0.682 -11.057  -8.573  1.00  0.00
ATOM   1637  O   GLY   104      -1.597 -11.294  -7.775  1.00  0.00
ATOM   1638  N   ARG   105       0.078 -12.022  -9.117  1.00  0.00
ATOM   1639  HN  ARG   105       0.847 -11.758  -9.666  1.00  0.00
ATOM   1640  CA  ARG   105      -0.132 -13.466  -8.876  1.00  0.00
ATOM   1641  HA  ARG   105      -0.949 -13.597  -8.168  1.00  0.00
ATOM   1642  CB  ARG   105      -0.469 -14.204 -10.201  1.00  0.00
ATOM   1643  HB1 ARG   105      -0.617 -15.260  -9.986  1.00  0.00
ATOM   1644  HB2 ARG   105       0.373 -14.106 -10.876  1.00  0.00
ATOM   1645  CG  ARG   105      -1.723 -13.684 -10.940  1.00  0.00
ATOM   1646  HG1 ARG   105      -1.778 -14.170 -11.911  1.00  0.00
ATOM   1647  HG2 ARG   105      -1.617 -12.616 -11.093  1.00  0.00
ATOM   1648  CD  ARG   105      -3.043 -13.942 -10.190  1.00  0.00
ATOM   1649  HD1 ARG   105      -2.951 -13.596  -9.168  1.00  0.00
ATOM   1650  HD2 ARG   105      -3.248 -15.009 -10.193  1.00  0.00
ATOM   1651  NE  ARG   105      -4.156 -13.215 -10.838  1.00  0.00
ATOM   1652  HE  ARG   105      -3.928 -12.348 -11.233  1.00  0.00
ATOM   1653  CZ  ARG   105      -5.432 -13.615 -10.931  1.00  0.00
ATOM   1654  NH1 ARG   105      -5.830 -14.779 -10.457  1.00  0.00
ATOM   1655 HH11 ARG   105      -5.176 -15.394 -10.017  1.00  0.00
ATOM   1656 HH12 ARG   105      -6.792 -15.061 -10.546  1.00  0.00
ATOM   1657  NH2 ARG   105      -6.311 -12.827 -11.526  1.00  0.00
ATOM   1658 HH21 ARG   105      -6.021 -11.944 -11.902  1.00  0.00
ATOM   1659 HH22 ARG   105      -7.269 -13.112 -11.617  1.00  0.00
ATOM   1660  C   ARG   105       1.146 -14.039  -8.272  1.00  0.00
ATOM   1661  O   ARG   105       2.232 -13.543  -8.565  1.00  0.00
ATOM   1662  N   ILE   106       1.022 -15.070  -7.430  1.00  0.00
ATOM   1663  HN  ILE   106       0.127 -15.399  -7.216  1.00  0.00
ATOM   1664  CA  ILE   106       2.186 -15.718  -6.820  1.00  0.00
ATOM   1665  HA  ILE   106       2.800 -14.933  -6.371  1.00  0.00
ATOM   1666  CB  ILE   106       1.775 -16.720  -5.683  1.00  0.00
ATOM   1667  HB  ILE   106       1.107 -17.458  -6.117  1.00  0.00
ATOM   1668  CG1 ILE   106       1.012 -15.962  -4.557  1.00  0.00
ATOM   1669 HG11 ILE   106       0.097 -15.544  -4.965  1.00  0.00
ATOM   1670 HG12 ILE   106       1.631 -15.156  -4.189  1.00  0.00
ATOM   1671  CG2 ILE   106       3.001 -17.477  -5.105  1.00  0.00
ATOM   1672 HG21 ILE   106       3.696 -16.769  -4.671  1.00  0.00
ATOM   1673 HG22 ILE   106       3.498 -18.025  -5.896  1.00  0.00
ATOM   1674 HG23 ILE   106       2.677 -18.174  -4.342  1.00  0.00
ATOM   1675  CD1 ILE   106       0.637 -16.813  -3.369  1.00  0.00
ATOM   1676 HD11 ILE   106       0.046 -17.658  -3.701  1.00  0.00
ATOM   1677 HD12 ILE   106       0.058 -16.222  -2.674  1.00  0.00
ATOM   1678 HD13 ILE   106       1.531 -17.170  -2.877  1.00  0.00
ATOM   1679  C   ILE   106       3.015 -16.423  -7.904  1.00  0.00
ATOM   1680  O   ILE   106       2.582 -17.414  -8.479  1.00  0.00
ATOM   1681  N   ALA   107       4.199 -15.862  -8.177  1.00  0.00
ATOM   1682  HN  ALA   107       4.455 -15.062  -7.676  1.00  0.00
ATOM   1683  CA  ALA   107       5.130 -16.371  -9.187  1.00  0.00
ATOM   1684  HA  ALA   107       4.568 -16.617 -10.084  1.00  0.00
ATOM   1685  CB  ALA   107       6.154 -15.279  -9.543  1.00  0.00
ATOM   1686  HB1 ALA   107       5.640 -14.397  -9.917  1.00  0.00
ATOM   1687  HB2 ALA   107       6.832 -15.640 -10.305  1.00  0.00
ATOM   1688  HB3 ALA   107       6.723 -15.006  -8.660  1.00  0.00
ATOM   1689  C   ALA   107       5.851 -17.624  -8.674  1.00  0.00
ATOM   1690  O   ALA   107       6.074 -18.580  -9.430  1.00  0.00
ATOM   1691  N   LYS   108       6.194 -17.607  -7.375  1.00  0.00
ATOM   1692  HN  LYS   108       5.915 -16.832  -6.831  1.00  0.00
ATOM   1693  CA  LYS   108       6.942 -18.685  -6.701  1.00  0.00
ATOM   1694  HA  LYS   108       6.708 -19.631  -7.187  1.00  0.00
ATOM   1695  CB  LYS   108       8.472 -18.426  -6.773  1.00  0.00
ATOM   1696  HB1 LYS   108       8.980 -19.140  -6.128  1.00  0.00
ATOM   1697  HB2 LYS   108       8.670 -17.427  -6.397  1.00  0.00
ATOM   1698  CG  LYS   108       9.079 -18.538  -8.184  1.00  0.00
ATOM   1699  HG1 LYS   108       8.475 -17.946  -8.865  1.00  0.00
ATOM   1700  HG2 LYS   108       9.045 -19.574  -8.498  1.00  0.00
ATOM   1701  CD  LYS   108      10.537 -18.048  -8.262  1.00  0.00
ATOM   1702  HD1 LYS   108      11.166 -18.699  -7.662  1.00  0.00
ATOM   1703  HD2 LYS   108      10.592 -17.037  -7.867  1.00  0.00
ATOM   1704  CE  LYS   108      11.059 -18.041  -9.707  1.00  0.00
ATOM   1705  HE1 LYS   108      10.418 -17.410 -10.314  1.00  0.00
ATOM   1706  HE2 LYS   108      11.037 -19.050 -10.101  1.00  0.00
ATOM   1707  NZ  LYS   108      12.447 -17.533  -9.804  1.00  0.00
ATOM   1708  HZ1 LYS   108      12.491 -16.547  -9.472  1.00  0.00
ATOM   1709  HZ2 LYS   108      12.773 -17.570 -10.790  1.00  0.00
ATOM   1710  HZ3 LYS   108      13.078 -18.110  -9.219  1.00  0.00
ATOM   1711  C   LYS   108       6.513 -18.750  -5.239  1.00  0.00
ATOM   1712  O   LYS   108       6.220 -17.721  -4.642  1.00  0.00
ATOM   1713  N   ALA   109       6.502 -19.953  -4.665  1.00  0.00
ATOM   1714  HN  ALA   109       6.737 -20.734  -5.208  1.00  0.00
ATOM   1715  CA  ALA   109       6.172 -20.164  -3.255  1.00  0.00
ATOM   1716  HA  ALA   109       6.435 -19.255  -2.705  1.00  0.00
ATOM   1717  CB  ALA   109       4.675 -20.420  -3.061  1.00  0.00
ATOM   1718  HB1 ALA   109       4.110 -19.584  -3.452  1.00  0.00
ATOM   1719  HB2 ALA   109       4.451 -20.530  -2.004  1.00  0.00
ATOM   1720  HB3 ALA   109       4.380 -21.325  -3.582  1.00  0.00
ATOM   1721  C   ALA   109       6.998 -21.320  -2.707  1.00  0.00
ATOM   1722  O   ALA   109       7.227 -22.318  -3.385  1.00  0.00
ATOM   1723  N   TRP   110       7.465 -21.142  -1.486  1.00  0.00
ATOM   1724  HN  TRP   110       7.229 -20.320  -1.027  1.00  0.00
ATOM   1725  CA  TRP   110       8.314 -22.088  -0.766  1.00  0.00
ATOM   1726  HA  TRP   110       8.312 -23.046  -1.280  1.00  0.00
ATOM   1727  CB  TRP   110       9.773 -21.523  -0.680  1.00  0.00
ATOM   1728  HB1 TRP   110      10.456 -22.341  -0.472  1.00  0.00
ATOM   1729  HB2 TRP   110       9.837 -20.806   0.130  1.00  0.00
ATOM   1730  CG  TRP   110      10.254 -20.819  -1.942  1.00  0.00
ATOM   1731  CD1 TRP   110      10.829 -21.392  -3.027  1.00  0.00
ATOM   1732  HD1 TRP   110      11.029 -22.441  -3.116  1.00  0.00
ATOM   1733  CD2 TRP   110      10.173 -19.414  -2.249  1.00  0.00
ATOM   1734  NE1 TRP   110      11.114 -20.458  -3.978  1.00  0.00
ATOM   1735  HE1 TRP   110      11.535 -20.638  -4.845  1.00  0.00
ATOM   1736  CE2 TRP   110      10.722 -19.236  -3.527  1.00  0.00
ATOM   1737  CE3 TRP   110       9.684 -18.298  -1.572  1.00  0.00
ATOM   1738  HE3 TRP   110       9.250 -18.392  -0.588  1.00  0.00
ATOM   1739  CZ2 TRP   110      10.812 -17.991  -4.134  1.00  0.00
ATOM   1740  HZ2 TRP   110      11.239 -17.864  -5.121  1.00  0.00
ATOM   1741  CZ3 TRP   110       9.770 -17.060  -2.173  1.00  0.00
ATOM   1742  HZ3 TRP   110       9.399 -16.182  -1.657  1.00  0.00
ATOM   1743  CH2 TRP   110      10.328 -16.917  -3.446  1.00  0.00
ATOM   1744  HH2 TRP   110      10.376 -15.926  -3.883  1.00  0.00
ATOM   1745  C   TRP   110       7.708 -22.259   0.635  1.00  0.00
ATOM   1746  O   TRP   110       6.983 -21.371   1.105  1.00  0.00
ATOM   1747  N   PHE   111       7.969 -23.381   1.302  1.00  0.00
ATOM   1748  HN  PHE   111       8.426 -24.118   0.848  1.00  0.00
ATOM   1749  CA  PHE   111       7.574 -23.541   2.713  1.00  0.00
ATOM   1750  HA  PHE   111       7.517 -22.541   3.155  1.00  0.00
ATOM   1751  CB  PHE   111       6.172 -24.216   2.858  1.00  0.00
ATOM   1752  HB1 PHE   111       5.495 -23.767   2.137  1.00  0.00
ATOM   1753  HB2 PHE   111       5.784 -24.007   3.851  1.00  0.00
ATOM   1754  CG  PHE   111       6.127 -25.733   2.651  1.00  0.00
ATOM   1755  CD1 PHE   111       6.113 -26.601   3.748  1.00  0.00
ATOM   1756  HD1 PHE   111       6.134 -26.191   4.750  1.00  0.00
ATOM   1757  CD2 PHE   111       6.102 -26.292   1.375  1.00  0.00
ATOM   1758  HD2 PHE   111       6.113 -25.645   0.507  1.00  0.00
ATOM   1759  CE1 PHE   111       6.072 -27.967   3.576  1.00  0.00
ATOM   1760  HE1 PHE   111       6.066 -28.618   4.446  1.00  0.00
ATOM   1761  CE2 PHE   111       6.058 -27.666   1.203  1.00  0.00
ATOM   1762  HE2 PHE   111       6.036 -28.085   0.203  1.00  0.00
ATOM   1763  CZ  PHE   111       6.044 -28.503   2.302  1.00  0.00
ATOM   1764  HZ  PHE   111       6.010 -29.578   2.166  1.00  0.00
ATOM   1765  C   PHE   111       8.658 -24.311   3.463  1.00  0.00
ATOM   1766  O   PHE   111       9.311 -25.203   2.897  1.00  0.00
ATOM   1767  N   LYS   112       8.853 -23.944   4.733  1.00  0.00
ATOM   1768  HN  LYS   112       8.345 -23.179   5.081  1.00  0.00
ATOM   1769  CA  LYS   112       9.775 -24.624   5.639  1.00  0.00
ATOM   1770  HA  LYS   112      10.080 -25.557   5.172  1.00  0.00
ATOM   1771  CB  LYS   112      11.048 -23.763   5.904  1.00  0.00
ATOM   1772  HB1 LYS   112      11.567 -23.625   4.959  1.00  0.00
ATOM   1773  HB2 LYS   112      11.705 -24.320   6.568  1.00  0.00
ATOM   1774  CG  LYS   112      10.812 -22.366   6.527  1.00  0.00
ATOM   1775  HG1 LYS   112      10.194 -22.481   7.412  1.00  0.00
ATOM   1776  HG2 LYS   112      10.289 -21.745   5.807  1.00  0.00
ATOM   1777  CD  LYS   112      12.137 -21.673   6.926  1.00  0.00
ATOM   1778  HD1 LYS   112      12.744 -21.538   6.035  1.00  0.00
ATOM   1779  HD2 LYS   112      12.672 -22.314   7.619  1.00  0.00
ATOM   1780  CE  LYS   112      11.934 -20.306   7.597  1.00  0.00
ATOM   1781  HE1 LYS   112      11.281 -20.419   8.454  1.00  0.00
ATOM   1782  HE2 LYS   112      11.476 -19.624   6.889  1.00  0.00
ATOM   1783  NZ  LYS   112      13.224 -19.721   8.052  1.00  0.00
ATOM   1784  HZ1 LYS   112      13.667 -20.339   8.762  1.00  0.00
ATOM   1785  HZ2 LYS   112      13.065 -18.784   8.468  1.00  0.00
ATOM   1786  HZ3 LYS   112      13.871 -19.623   7.246  1.00  0.00
ATOM   1787  C   LYS   112       9.041 -24.961   6.939  1.00  0.00
ATOM   1788  O   LYS   112       8.473 -24.080   7.585  1.00  0.00
ATOM   1789  N   ILE   113       9.040 -26.250   7.322  1.00  0.00
ATOM   1790  HN  ILE   113       9.508 -26.906   6.774  1.00  0.00
ATOM   1791  CA  ILE   113       8.370 -26.703   8.547  1.00  0.00
ATOM   1792  HA  ILE   113       7.521 -26.041   8.731  1.00  0.00
ATOM   1793  CB  ILE   113       7.816 -28.165   8.418  1.00  0.00
ATOM   1794  HB  ILE   113       8.638 -28.807   8.123  1.00  0.00
ATOM   1795  CG1 ILE   113       6.712 -28.224   7.318  1.00  0.00
ATOM   1796 HG11 ILE   113       7.049 -27.713   6.424  1.00  0.00
ATOM   1797 HG12 ILE   113       5.829 -27.716   7.680  1.00  0.00
ATOM   1798  CG2 ILE   113       7.259 -28.692   9.777  1.00  0.00
ATOM   1799 HG21 ILE   113       6.885 -29.702   9.653  1.00  0.00
ATOM   1800 HG22 ILE   113       6.450 -28.056  10.113  1.00  0.00
ATOM   1801 HG23 ILE   113       8.045 -28.690  10.523  1.00  0.00
ATOM   1802  CD1 ILE   113       6.289 -29.624   6.937  1.00  0.00
ATOM   1803 HD11 ILE   113       7.147 -30.184   6.587  1.00  0.00
ATOM   1804 HD12 ILE   113       5.550 -29.574   6.153  1.00  0.00
ATOM   1805 HD13 ILE   113       5.865 -30.117   7.799  1.00  0.00
ATOM   1806  C   ILE   113       9.363 -26.597   9.707  1.00  0.00
ATOM   1807  O   ILE   113      10.473 -27.147   9.642  1.00  0.00
ATOM   1808  N   GLY   114       8.949 -25.855  10.735  1.00  0.00
ATOM   1809  HN  GLY   114       8.035 -25.487  10.695  1.00  0.00
ATOM   1810  CA  GLY   114       9.788 -25.579  11.902  1.00  0.00
ATOM   1811  HA1 GLY   114       9.270 -24.872  12.536  1.00  0.00
ATOM   1812  HA2 GLY   114      10.716 -25.124  11.570  1.00  0.00
ATOM   1813  C   GLY   114      10.096 -26.827  12.718  1.00  0.00
ATOM   1814  O   GLY   114      11.252 -27.278  12.764  1.00  0.00
ATOM   1815  N   GLU   115       9.053 -27.397  13.343  1.00  0.00
ATOM   1816  HN  GLU   115       8.162 -26.994  13.241  1.00  0.00
ATOM   1817  CA  GLU   115       9.172 -28.619  14.151  1.00  0.00
ATOM   1818  HA  GLU   115       9.852 -29.295  13.644  1.00  0.00
ATOM   1819  CB  GLU   115       9.728 -28.287  15.575  1.00  0.00
ATOM   1820  HB1 GLU   115      10.550 -27.585  15.476  1.00  0.00
ATOM   1821  HB2 GLU   115      10.109 -29.202  16.018  1.00  0.00
ATOM   1822  CG  GLU   115       8.686 -27.683  16.540  1.00  0.00
ATOM   1823  HG1 GLU   115       7.840 -28.377  16.594  1.00  0.00
ATOM   1824  HG2 GLU   115       8.331 -26.745  16.126  1.00  0.00
ATOM   1825  CD  GLU   115       9.222 -27.446  17.960  1.00  0.00
ATOM   1826  OE1 GLU   115       9.196 -28.387  18.779  1.00  0.00
ATOM   1827  OE2 GLU   115       9.645 -26.314  18.276  1.00  0.00
ATOM   1828  C   GLU   115       7.789 -29.299  14.272  1.00  0.00
ATOM   1829  O   GLU   115       6.761 -28.666  13.976  1.00  0.00
ATOM   1830  N   PRO   116       7.741 -30.602  14.687  1.00  0.00
ATOM   1831  CA  PRO   116       6.494 -31.239  15.173  1.00  0.00
ATOM   1832  HA  PRO   116       5.641 -30.943  14.576  1.00  0.00
ATOM   1833  CB  PRO   116       6.790 -32.733  14.950  1.00  0.00
ATOM   1834  HB1 PRO   116       6.506 -32.996  13.942  1.00  0.00
ATOM   1835  HB2 PRO   116       6.227 -33.346  15.649  1.00  0.00
ATOM   1836  CG  PRO   116       8.272 -32.873  15.146  1.00  0.00
ATOM   1837  HG1 PRO   116       8.648 -33.718  14.577  1.00  0.00
ATOM   1838  HG2 PRO   116       8.494 -33.012  16.201  1.00  0.00
ATOM   1839  CD  PRO   116       8.876 -31.579  14.638  1.00  0.00
ATOM   1840  HD1 PRO   116       9.233 -31.695  13.621  1.00  0.00
ATOM   1841  HD2 PRO   116       9.687 -31.253  15.282  1.00  0.00
ATOM   1842  C   PRO   116       6.206 -30.918  16.661  1.00  0.00
ATOM   1843  O   PRO   116       7.129 -30.919  17.488  1.00  0.00
ATOM   1844  N   ARG   117       4.924 -30.616  16.993  1.00  0.00
ATOM   1845  HN  ARG   117       4.262 -30.532  16.275  1.00  0.00
ATOM   1846  CA  ARG   117       4.478 -30.391  18.393  1.00  0.00
ATOM   1847  HA  ARG   117       5.260 -30.770  19.040  1.00  0.00
ATOM   1848  CB  ARG   117       4.276 -28.879  18.700  1.00  0.00
ATOM   1849  HB1 ARG   117       3.834 -28.780  19.688  1.00  0.00
ATOM   1850  HB2 ARG   117       3.586 -28.466  17.969  1.00  0.00
ATOM   1851  CG  ARG   117       5.565 -28.041  18.664  1.00  0.00
ATOM   1852  HG1 ARG   117       5.961 -28.057  17.652  1.00  0.00
ATOM   1853  HG2 ARG   117       6.297 -28.484  19.334  1.00  0.00
ATOM   1854  CD  ARG   117       5.337 -26.586  19.081  1.00  0.00
ATOM   1855  HD1 ARG   117       4.955 -26.564  20.096  1.00  0.00
ATOM   1856  HD2 ARG   117       4.603 -26.141  18.414  1.00  0.00
ATOM   1857  NE  ARG   117       6.581 -25.804  19.027  1.00  0.00
ATOM   1858  HE  ARG   117       7.418 -26.293  19.188  1.00  0.00
ATOM   1859  CZ  ARG   117       6.657 -24.493  18.783  1.00  0.00
ATOM   1860  NH1 ARG   117       5.561 -23.791  18.512  1.00  0.00
ATOM   1861 HH11 ARG   117       4.663 -24.247  18.479  1.00  0.00
ATOM   1862 HH12 ARG   117       5.617 -22.807  18.348  1.00  0.00
ATOM   1863  NH2 ARG   117       7.837 -23.897  18.772  1.00  0.00
ATOM   1864 HH21 ARG   117       8.673 -24.434  18.945  1.00  0.00
ATOM   1865 HH22 ARG   117       7.911 -22.914  18.593  1.00  0.00
ATOM   1866  C   ARG   117       3.185 -31.163  18.716  1.00  0.00
ATOM   1867  O   ARG   117       2.409 -31.535  17.826  1.00  0.00
ATOM   1868  N   ILE   118       2.974 -31.375  20.032  1.00  0.00
ATOM   1869  HN  ILE   118       3.617 -30.990  20.664  1.00  0.00
ATOM   1870  CA  ILE   118       1.835 -32.123  20.603  1.00  0.00
ATOM   1871  HA  ILE   118       1.035 -32.176  19.864  1.00  0.00
ATOM   1872  CB  ILE   118       2.265 -33.596  21.008  1.00  0.00
ATOM   1873  HB  ILE   118       3.094 -33.515  21.708  1.00  0.00
ATOM   1874  CG1 ILE   118       2.754 -34.407  19.770  1.00  0.00
ATOM   1875 HG11 ILE   118       3.130 -35.368  20.099  1.00  0.00
ATOM   1876 HG12 ILE   118       3.559 -33.868  19.289  1.00  0.00
ATOM   1877  CG2 ILE   118       1.130 -34.358  21.729  1.00  0.00
ATOM   1878 HG21 ILE   118       0.866 -33.840  22.644  1.00  0.00
ATOM   1879 HG22 ILE   118       1.449 -35.363  21.972  1.00  0.00
ATOM   1880 HG23 ILE   118       0.255 -34.405  21.084  1.00  0.00
ATOM   1881  CD1 ILE   118       1.695 -34.665  18.720  1.00  0.00
ATOM   1882 HD11 ILE   118       0.912 -35.278  19.142  1.00  0.00
ATOM   1883 HD12 ILE   118       2.138 -35.173  17.878  1.00  0.00
ATOM   1884 HD13 ILE   118       1.271 -33.722  18.393  1.00  0.00
ATOM   1885  C   ILE   118       1.334 -31.368  21.850  1.00  0.00
ATOM   1886  O   ILE   118       2.152 -30.899  22.641  1.00  0.00
END
