
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  146 ( 1147),  selected  146 , name 2gex_A
# Molecule2: number of CA atoms  117 ( 1867),  selected  117 , name T0475.pdb
# PARAMETERS: 2gex_A.T0475.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S     2_A      -       -           -
LGA    T     3_A      N       2          1.675
LGA    T     4_A      S       3          2.908
LGA    A     5_A      E       4          3.212
LGA    N     6_A      I       5          1.420
LGA    K     7_A      E       6          1.973
LGA    E     8_A      L       7          3.512
LGA    R     9_A      P       8          2.469
LGA    C    10_A      V       9          0.909
LGA    L    11_A      Q      10          1.368
LGA    E    12_A      K      11          0.836
LGA    X    13_A      Q      12          0.395
LGA    V    14_A      L      13          0.789
LGA    A    15_A      E      14          0.911
LGA    A    16_A      A      15          0.804
LGA    W    17_A      Y      16          1.111
LGA    N    18_A      N      17          1.715
LGA    R    19_A      A      18          1.331
LGA    W    20_A      R      19          1.055
LGA    D    21_A      D      20          1.553
LGA    V    22_A      I      21          1.816
LGA    S    23_A      D      22          2.418
LGA    G    24_A      A      23          1.761
LGA    V    25_A      F      24          0.500
LGA    V    26_A      M      25          0.834
LGA    A    27_A      A      26          0.823
LGA    H    28_A      W      27          0.981
LGA    W    29_A      W      28          0.684
LGA    A    30_A      A      29          0.810
LGA    P    31_A      D      30          0.850
LGA    D    32_A      D      31          1.417
LGA    V    33_A      C      32          0.815
LGA    V    34_A      Q      33          1.136
LGA    H    35_A      Y      34          1.240
LGA    Y    36_A      Y      35          1.615
LGA    D    37_A      A      36          2.577
LGA    D    38_A      F      37          2.114
LGA    E    39_A      P      38          2.678
LGA    D    40_A      A      39          2.593
LGA    K    41_A      T      40          3.261
LGA    P    42_A      L      41          2.204
LGA    V    43_A      L      42          1.970
LGA    S    44_A      A      43          2.240
LGA    A    45_A      G      44          4.998
LGA    -       -      N      45           -
LGA    -       -      A      46           -
LGA    E    46_A      A      47          5.284
LGA    E    47_A      E      48          4.714
LGA    V    48_A      I      49          3.393
LGA    V    49_A      R      50          2.988
LGA    R    50_A      V      51          3.171
LGA    R    51_A      R      52          2.749
LGA    X    52_A      H      53          0.937
LGA    N    53_A      I      54          1.214
LGA    S    54_A      E      55          1.351
LGA    A    55_A      R      56          1.299
LGA    V    56_A      F      57          1.215
LGA    E    57_A      K      58          1.104
LGA    A    58_A      E      59          2.119
LGA    F    59_A      P      60          2.763
LGA    P    60_A      -       -           -
LGA    D    61_A      D      61          3.790
LGA    L    62_A      L      62          2.129
LGA    R    63_A      Y      63          1.754
LGA    L    64_A      G      64          1.259
LGA    D    65_A      E      65          1.517
LGA    V    66_A      L      66          1.466
LGA    R    67_A      L      67          0.929
LGA    S    68_A      T      68          0.929
LGA    I    69_A      R      69          0.998
LGA    V    70_A      V      70          0.989
LGA    G    71_A      I      71          0.862
LGA    E    72_A      V      72          1.758
LGA    G    73_A      G      73          1.510
LGA    D    74_A      N      74          0.870
LGA    R    75_A      V      75          0.848
LGA    V    76_A      V      76          0.928
LGA    X    77_A      I      77          1.034
LGA    L    78_A      D      78          1.598
LGA    R    79_A      H      79          0.741
LGA    I    80_A      E      80          0.561
LGA    T    81_A      T      81          0.960
LGA    C    82_A      V      82          1.513
LGA    S    83_A      T      83          1.177
LGA    A    84_A      R      84          3.932
LGA    T    85_A      -       -           -
LGA    H    86_A      -       -           -
LGA    Q    87_A      -       -           -
LGA    G    88_A      -       -           -
LGA    V    89_A      -       -           -
LGA    F    90_A      -       -           -
LGA    X    91_A      -       -           -
LGA    G    92_A      -       -           -
LGA    I    93_A      -       -           -
LGA    A    94_A      -       -           -
LGA    P    95_A      -       -           -
LGA    T    96_A      -       -           -
LGA    G    97_A      N      85           #
LGA    R    98_A      F      86          5.460
LGA    -       -      P      87           -
LGA    -       -      E      88           -
LGA    -       -      G      89           -
LGA    K    99_A      K      90          3.188
LGA    V   100_A      G      91          2.126
LGA    R   101_A      E      92          0.877
LGA    W   102_A      V      93          0.744
LGA    T   103_A      D      94          1.247
LGA    Y   104_A      V      95          1.673
LGA    L   105_A      A      96          1.114
LGA    E   106_A      C      97          1.024
LGA    E   107_A      I      98          1.031
LGA    L   108_A      Y      99          0.690
LGA    R   109_A      E     100          0.739
LGA    F   110_A      V     101          0.672
LGA    S   111_A      E     102          1.240
LGA    E   112_A      N     103          3.288
LGA    A   113_A      G     104          2.822
LGA    G   114_A      -       -           -
LGA    K   115_A      R     105          0.573
LGA    V   116_A      I     106          0.278
LGA    V   117_A      A     107          0.216
LGA    E   118_A      K     108          0.602
LGA    H   119_A      A     109          0.350
LGA    W   120_A      W     110          0.397
LGA    D   121_A      F     111          1.121
LGA    V   122_A      K     112          0.792
LGA    F   123_A      I     113          0.848
LGA    N   124_A      G     114          1.985
LGA    F   125_A      E     115          2.588
LGA    S   126_A      P     116          2.940
LGA    P   127_A      R     117          1.020
LGA    L   128_A      -       -           -
LGA    F   129_A      -       -           -
LGA    R   130_A      -       -           -
LGA    D   131_A      I     118          2.624
LGA    L   132_A      -       -           -
LGA    G   133_A      -       -           -
LGA    V   134_A      -       -           -
LGA    V   135_A      -       -           -
LGA    P   136_A      -       -           -
LGA    D   137_A      -       -           -
LGA    G   138_A      -       -           -
LGA    L   139_A      -       -           -
LGA    K   140_A      -       -           -
LGA    L   141_A      -       -           -
LGA    A   142_A      -       -           -
LGA    A   143_A      -       -           -
LGA    A   144_A      -       -           -
LGA    L   145_A      -       -           -
LGA    E   146_A      -       -           -
LGA    H   147_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  146  117    5.0    111    1.99    16.22     76.736     5.309

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.698604 * X  +   0.111556 * Y  +   0.706759 * Z  + -38.216072
  Y_new =  -0.145120 * X  +  -0.945150 * Y  +   0.292629 * Z  +   4.651295
  Z_new =   0.700638 * X  +  -0.306997 * Y  +  -0.644096 * Z  +  -3.291794 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.696814    0.444779  [ DEG:  -154.5160     25.4840 ]
  Theta =  -0.776291   -2.365302  [ DEG:   -44.4782   -135.5218 ]
  Phi   =  -0.204816    2.936777  [ DEG:   -11.7351    168.2649 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2gex_A                                        
REMARK     2: T0475.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2gex_A.T0475.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  146  117   5.0  111   1.99   16.22  76.736
REMARK  ---------------------------------------------------------- 
MOLECULE 2gex_A
HEADER    OXIDOREDUCTASE                          21-MAR-06   2GEX              
TITLE     CRYSTAL STRUCTURE OF SNOAL2 A PUTATIVE HYDROXYLASE FROM               
TITLE    2 STREPTOMYCES NOGALATER                                               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SNOL;                                                      
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: SNOAL2, PUTATIVE HYDROXYLASE;                               
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STREPTOMYCES NOGALATER;                         
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: SNOAL2;                                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET30B                                    
KEYWDS    ALPHA+BETA BARREL                                                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    P.BEINKER,B.LOHKAMP,G.SCHNEIDER                                       
REVDAT   1   18-JUL-06 2GEX    0                                                
JRNL        AUTH   P.BEINKER,B.LOHKAMP,T.PELTONEN,J.NIEMI,P.MANTSALA,           
JRNL        AUTH 2 G.SCHNEIDER                                                  
JRNL        TITL   CRYSTAL STRUCTURES OF SNOAL2 AND ACLR: TWO                   
JRNL        TITL 2 PUTATIVE HYDROXYLASES IN THE BIOSYNTHESIS OF                 
JRNL        TITL 3 AROMATIC POLYKETIDE ANTIBIOTICS                              
JRNL        REF    J.MOL.BIOL.                   V. 359   728 2006              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 2.50 ANGSTROMS.                                          
DBREF  2GEX A    1   139  UNP    Q9RN64   Q9RN64_STRNO     1    139             
DBREF  2GEX B    1   139  UNP    Q9RN64   Q9RN64_STRNO     1    139             
SEQRES   1 A  152  MSE SER THR THR ALA ASN LYS GLU ARG CYS LEU GLU MSE          
SEQRES   2 A  152  VAL ALA ALA TRP ASN ARG TRP ASP VAL SER GLY VAL VAL          
SEQRES   3 A  152  ALA HIS TRP ALA PRO ASP VAL VAL HIS TYR ASP ASP GLU          
SEQRES   4 A  152  ASP LYS PRO VAL SER ALA GLU GLU VAL VAL ARG ARG MSE          
SEQRES   5 A  152  ASN SER ALA VAL GLU ALA PHE PRO ASP LEU ARG LEU ASP          
SEQRES   6 A  152  VAL ARG SER ILE VAL GLY GLU GLY ASP ARG VAL MSE LEU          
SEQRES   7 A  152  ARG ILE THR CYS SER ALA THR HIS GLN GLY VAL PHE MSE          
SEQRES   8 A  152  GLY ILE ALA PRO THR GLY ARG LYS VAL ARG TRP THR TYR          
SEQRES   9 A  152  LEU GLU GLU LEU ARG PHE SER GLU ALA GLY LYS VAL VAL          
SEQRES  10 A  152  GLU HIS TRP ASP VAL PHE ASN PHE SER PRO LEU PHE ARG          
SEQRES  11 A  152  ASP LEU GLY VAL VAL PRO ASP GLY LEU LYS LEU ALA ALA          
SEQRES  12 A  152  ALA LEU GLU HIS HIS HIS HIS HIS HIS                          
SEQRES   1 B  152  MSE SER THR THR ALA ASN LYS GLU ARG CYS LEU GLU MSE          
SEQRES   2 B  152  VAL ALA ALA TRP ASN ARG TRP ASP VAL SER GLY VAL VAL          
SEQRES   3 B  152  ALA HIS TRP ALA PRO ASP VAL VAL HIS TYR ASP ASP GLU          
SEQRES   4 B  152  ASP LYS PRO VAL SER ALA GLU GLU VAL VAL ARG ARG MSE          
SEQRES   5 B  152  ASN SER ALA VAL GLU ALA PHE PRO ASP LEU ARG LEU ASP          
SEQRES   6 B  152  VAL ARG SER ILE VAL GLY GLU GLY ASP ARG VAL MSE LEU          
SEQRES   7 B  152  ARG ILE THR CYS SER ALA THR HIS GLN GLY VAL PHE MSE          
SEQRES   8 B  152  GLY ILE ALA PRO THR GLY ARG LYS VAL ARG TRP THR TYR          
SEQRES   9 B  152  LEU GLU GLU LEU ARG PHE SER GLU ALA GLY LYS VAL VAL          
SEQRES  10 B  152  GLU HIS TRP ASP VAL PHE ASN PHE SER PRO LEU PHE ARG          
SEQRES  11 B  152  ASP LEU GLY VAL VAL PRO ASP GLY LEU LYS LEU ALA ALA          
SEQRES  12 B  152  ALA LEU GLU HIS HIS HIS HIS HIS HIS                          
HET    MSE  A  13       8                                                       
HET    MSE  A  52       8                                                       
HET    MSE  A  77       8                                                       
HET    MSE  A  91       8                                                       
HET    MSE  B  13       8                                                       
HET    MSE  B  52       8                                                       
HET    MSE  B  77       8                                                       
HET    MSE  B  91       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    8(C5 H11 N O2 SE)                                            
FORMUL   3  HOH   *31(H2 O)                                                     
CRYST1   90.008   90.008  116.707  90.00  90.00 120.00 P 32 2 1     12          
ATOM      1  N   SER A   2       0.488  -3.592  -4.361  1.00 54.91           N  
ATOM      2  CA  SER A   2       1.461  -3.204  -3.302  1.00 55.02           C  
ATOM      3  C   SER A   2       1.734  -4.340  -2.301  1.00 55.04           C  
ATOM      4  O   SER A   2       1.240  -5.458  -2.448  1.00 55.35           O  
ATOM      5  CB  SER A   2       0.933  -1.966  -2.550  1.00 55.22           C  
ATOM      6  OG  SER A   2      -0.259  -2.278  -1.839  1.00 55.20           O  
ATOM      7  N   THR A   3       2.520  -4.022  -1.278  1.00 54.91           N  
ATOM      8  CA  THR A   3       2.777  -4.890  -0.131  1.00 54.43           C  
ATOM      9  C   THR A   3       1.486  -5.181   0.634  1.00 53.92           C  
ATOM     10  O   THR A   3       1.229  -6.318   1.024  1.00 54.12           O  
ATOM     11  CB  THR A   3       3.856  -4.225   0.784  1.00 54.39           C  
ATOM     12  OG1 THR A   3       5.112  -4.277   0.113  1.00 54.43           O  
ATOM     13  CG2 THR A   3       4.002  -4.917   2.127  1.00 54.76           C  
ATOM     14  N   THR A   4       0.670  -4.154   0.823  1.00 53.49           N  
ATOM     15  CA  THR A   4      -0.563  -4.274   1.577  1.00 53.04           C  
ATOM     16  C   THR A   4      -1.483  -5.242   0.869  1.00 52.79           C  
ATOM     17  O   THR A   4      -1.958  -6.196   1.486  1.00 53.33           O  
ATOM     18  CB  THR A   4      -1.226  -2.896   1.754  1.00 53.32           C  
ATOM     19  OG1 THR A   4      -0.476  -2.144   2.707  1.00 52.23           O  
ATOM     20  CG2 THR A   4      -2.661  -3.021   2.269  1.00 55.25           C  
ATOM     21  N   ALA A   5      -1.708  -5.015  -0.428  1.00 51.95           N  
ATOM     22  CA  ALA A   5      -2.536  -5.912  -1.231  1.00 51.01           C  
ATOM     23  C   ALA A   5      -1.966  -7.322  -1.208  1.00 50.43           C  
ATOM     24  O   ALA A   5      -2.697  -8.283  -0.991  1.00 50.69           O  
ATOM     25  CB  ALA A   5      -2.661  -5.415  -2.659  1.00 50.83           C  
ATOM     26  N   ASN A   6      -0.660  -7.445  -1.417  1.00 49.61           N  
ATOM     27  CA  ASN A   6       0.000  -8.748  -1.313  1.00 49.01           C  
ATOM     28  C   ASN A   6      -0.274  -9.461   0.016  1.00 48.87           C  
ATOM     29  O   ASN A   6      -0.586 -10.656   0.031  1.00 48.29           O  
ATOM     30  CB  ASN A   6       1.508  -8.633  -1.575  1.00 48.69           C  
ATOM     31  CG  ASN A   6       1.837  -8.293  -3.029  1.00 48.34           C  
ATOM     32  OD1 ASN A   6       0.976  -8.336  -3.907  1.00 50.25           O  
ATOM     33  ND2 ASN A   6       3.089  -7.954  -3.282  1.00 47.46           N  
ATOM     34  N   LYS A   7      -0.192  -8.740   1.133  1.00 48.91           N  
ATOM     35  CA  LYS A   7      -0.498  -9.384   2.422  1.00 49.41           C  
ATOM     36  C   LYS A   7      -1.942  -9.854   2.494  1.00 49.63           C  
ATOM     37  O   LYS A   7      -2.219 -10.948   2.958  1.00 50.01           O  
ATOM     38  CB  LYS A   7      -0.160  -8.503   3.619  1.00 49.06           C  
ATOM     39  CG  LYS A   7       1.315  -8.137   3.691  1.00 49.51           C  
ATOM     40  CD  LYS A   7       1.791  -8.019   5.107  1.00 49.55           C  
ATOM     41  CE  LYS A   7       1.336  -6.757   5.759  1.00 50.45           C  
ATOM     42  NZ  LYS A   7       1.785  -6.788   7.167  1.00 51.29           N  
ATOM     43  N   GLU A   8      -2.860  -9.028   2.012  1.00 50.13           N  
ATOM     44  CA  GLU A   8      -4.269  -9.355   2.064  1.00 50.65           C  
ATOM     45  C   GLU A   8      -4.579 -10.581   1.218  1.00 50.00           C  
ATOM     46  O   GLU A   8      -5.483 -11.364   1.537  1.00 50.04           O  
ATOM     47  CB  GLU A   8      -5.084  -8.159   1.583  1.00 51.59           C  
ATOM     48  CG  GLU A   8      -5.639  -7.292   2.693  1.00 54.59           C  
ATOM     49  CD  GLU A   8      -6.281  -6.030   2.143  1.00 60.57           C  
ATOM     50  OE1 GLU A   8      -5.518  -5.106   1.773  1.00 61.84           O  
ATOM     51  OE2 GLU A   8      -7.545  -5.962   2.062  1.00 63.37           O  
ATOM     52  N   ARG A   9      -3.837 -10.724   0.127  1.00 49.46           N  
ATOM     53  CA  ARG A   9      -3.958 -11.869  -0.770  0.50 49.37           C  
ATOM     55  C   ARG A   9      -3.599 -13.144  -0.014  1.00 49.04           C  
ATOM     56  O   ARG A   9      -4.270 -14.164  -0.126  1.00 49.08           O  
ATOM     57  CB  ARG A   9      -3.010 -11.691  -1.965  0.50 49.41           C  
ATOM     59  CG  ARG A   9      -3.602 -12.012  -3.333  0.50 49.46           C  
ATOM     61  CD  ARG A   9      -4.014 -10.752  -4.091  0.50 49.04           C  
ATOM     63  NE  ARG A   9      -2.888  -9.835  -4.265  0.50 48.86           N  
ATOM     65  CZ  ARG A   9      -2.970  -8.621  -4.811  0.50 47.87           C  
ATOM     67  NH1 ARG A   9      -4.130  -8.155  -5.257  0.50 46.51           N  
ATOM     69  NH2 ARG A   9      -1.883  -7.872  -4.907  0.50 46.24           N  
ATOM     71  N   CYS A  10      -2.519 -13.070   0.760  1.00 49.06           N  
ATOM     72  CA  CYS A  10      -2.035 -14.190   1.573  1.00 49.02           C  
ATOM     73  C   CYS A  10      -3.053 -14.574   2.631  1.00 48.41           C  
ATOM     74  O   CYS A  10      -3.235 -15.764   2.893  1.00 47.39           O  
ATOM     75  CB  CYS A  10      -0.672 -13.868   2.223  1.00 49.50           C  
ATOM     76  SG  CYS A  10       0.777 -13.768   1.062  1.00 53.01           S  
ATOM     77  N   LEU A  11      -3.727 -13.582   3.221  1.00 47.95           N  
ATOM     78  CA  LEU A  11      -4.819 -13.881   4.159  1.00 48.94           C  
ATOM     79  C   LEU A  11      -6.032 -14.532   3.478  1.00 49.38           C  
ATOM     80  O   LEU A  11      -6.738 -15.375   4.075  1.00 48.68           O  
ATOM     81  CB  LEU A  11      -5.224 -12.654   4.983  1.00 48.49           C  
ATOM     82  CG  LEU A  11      -4.062 -12.016   5.784  1.00 49.71           C  
ATOM     83  CD1 LEU A  11      -4.612 -11.016   6.763  1.00 48.52           C  
ATOM     84  CD2 LEU A  11      -3.152 -13.044   6.521  1.00 47.99           C  
ATOM     85  N   GLU A  12      -6.250 -14.162   2.222  1.00 50.43           N  
ATOM     86  CA  GLU A  12      -7.339 -14.743   1.446  1.00 52.10           C  
ATOM     87  C   GLU A  12      -7.065 -16.216   1.129  1.00 52.77           C  
ATOM     88  O   GLU A  12      -7.974 -17.053   1.220  1.00 52.70           O  
ATOM     89  CB  GLU A  12      -7.603 -13.921   0.190  1.00 52.19           C  
ATOM     90  CG  GLU A  12      -8.324 -12.618   0.493  1.00 54.92           C  
ATOM     91  CD  GLU A  12      -8.189 -11.580  -0.616  1.00 59.16           C  
ATOM     92  OE1 GLU A  12      -7.969 -11.976  -1.784  1.00 60.09           O  
ATOM     93  OE2 GLU A  12      -8.291 -10.359  -0.316  1.00 60.67           O  
HETATM   94  N   MSE A  13      -5.808 -16.547   0.829  1.00 52.91           N  
HETATM   95  CA  MSE A  13      -5.442 -17.950   0.602  1.00 55.20           C  
HETATM   96  C   MSE A  13      -5.602 -18.807   1.865  1.00 52.15           C  
HETATM   97  O   MSE A  13      -6.046 -19.948   1.789  1.00 52.60           O  
HETATM   98  CB  MSE A  13      -4.015 -18.062   0.071  1.00 53.80           C  
HETATM   99  CG  MSE A  13      -3.843 -17.510  -1.303  1.00 57.82           C  
HETATM  100 SE   MSE A  13      -1.945 -17.397  -1.763  1.00 66.40          SE  
HETATM  101  CE  MSE A  13      -1.745 -15.488  -1.699  1.00 63.43           C  
ATOM    102  N   VAL A  14      -5.211 -18.253   3.007  1.00 50.07           N  
ATOM    103  CA  VAL A  14      -5.386 -18.891   4.311  1.00 47.99           C  
ATOM    104  C   VAL A  14      -6.874 -19.049   4.607  1.00 47.46           C  
ATOM    105  O   VAL A  14      -7.285 -20.062   5.175  1.00 46.33           O  
ATOM    106  CB  VAL A  14      -4.675 -18.079   5.450  1.00 47.63           C  
ATOM    107  CG1 VAL A  14      -5.048 -18.585   6.821  1.00 44.68           C  
ATOM    108  CG2 VAL A  14      -3.140 -18.112   5.254  1.00 46.21           C  
ATOM    109  N   ALA A  15      -7.678 -18.068   4.185  1.00 47.11           N  
ATOM    110  CA  ALA A  15      -9.137 -18.143   4.382  1.00 46.81           C  
ATOM    111  C   ALA A  15      -9.708 -19.271   3.549  1.00 46.32           C  
ATOM    112  O   ALA A  15     -10.577 -20.007   4.023  1.00 45.95           O  
ATOM    113  CB  ALA A  15      -9.847 -16.792   4.083  1.00 45.86           C  
ATOM    114  N   ALA A  16      -9.178 -19.434   2.331  1.00 46.22           N  
ATOM    115  CA  ALA A  16      -9.591 -20.527   1.440  1.00 45.98           C  
ATOM    116  C   ALA A  16      -9.178 -21.909   1.984  1.00 46.47           C  
ATOM    117  O   ALA A  16      -9.942 -22.888   1.863  1.00 46.62           O  
ATOM    118  CB  ALA A  16      -9.067 -20.294   0.024  1.00 45.70           C  
ATOM    119  N   TRP A  17      -7.987 -22.001   2.590  1.00 46.36           N  
ATOM    120  CA  TRP A  17      -7.596 -23.234   3.268  1.00 46.99           C  
ATOM    121  C   TRP A  17      -8.572 -23.518   4.401  1.00 47.54           C  
ATOM    122  O   TRP A  17      -8.985 -24.652   4.608  1.00 47.00           O  
ATOM    123  CB  TRP A  17      -6.211 -23.117   3.881  1.00 47.45           C  
ATOM    124  CG  TRP A  17      -5.057 -23.571   3.042  1.00 48.21           C  
ATOM    125  CD1 TRP A  17      -4.128 -22.775   2.443  1.00 48.08           C  
ATOM    126  CD2 TRP A  17      -4.678 -24.933   2.734  1.00 49.95           C  
ATOM    127  NE1 TRP A  17      -3.206 -23.541   1.771  1.00 49.15           N  
ATOM    128  CE2 TRP A  17      -3.510 -24.867   1.933  1.00 49.35           C  
ATOM    129  CE3 TRP A  17      -5.221 -26.197   3.044  1.00 50.53           C  
ATOM    130  CZ2 TRP A  17      -2.852 -26.015   1.454  1.00 49.30           C  
ATOM    131  CZ3 TRP A  17      -4.578 -27.352   2.550  1.00 49.91           C  
ATOM    132  CH2 TRP A  17      -3.401 -27.249   1.770  1.00 49.23           C  
ATOM    133  N   ASN A  18      -8.924 -22.478   5.153  1.00 47.92           N  
ATOM    134  CA  ASN A  18      -9.795 -22.668   6.313  1.00 48.32           C  
ATOM    135  C   ASN A  18     -11.221 -23.130   6.013  1.00 48.38           C  
ATOM    136  O   ASN A  18     -11.849 -23.699   6.884  1.00 48.57           O  
ATOM    137  CB  ASN A  18      -9.695 -21.511   7.304  1.00 47.78           C  
ATOM    138  CG  ASN A  18      -8.395 -21.568   8.095  1.00 46.72           C  
ATOM    139  OD1 ASN A  18      -7.864 -22.665   8.347  1.00 46.25           O  
ATOM    140  ND2 ASN A  18      -7.865 -20.407   8.469  1.00 42.39           N  
ATOM    141  N   ARG A  19     -11.680 -22.931   4.775  1.00 49.04           N  
ATOM    142  CA  ARG A  19     -12.906 -23.557   4.236  1.00 49.72           C  
ATOM    143  C   ARG A  19     -12.590 -24.803   3.401  1.00 49.62           C  
ATOM    144  O   ARG A  19     -13.455 -25.296   2.657  1.00 50.25           O  
ATOM    145  CB  ARG A  19     -13.637 -22.637   3.260  1.00 49.39           C  
ATOM    146  CG  ARG A  19     -13.942 -21.236   3.688  1.00 51.73           C  
ATOM    147  CD  ARG A  19     -14.699 -20.487   2.505  1.00 50.96           C  
ATOM    148  NE  ARG A  19     -13.945 -20.435   1.239  1.00 51.39           N  
ATOM    149  CZ  ARG A  19     -13.238 -19.372   0.830  1.00 51.00           C  
ATOM    150  NH1 ARG A  19     -13.202 -18.282   1.596  1.00 50.69           N  
ATOM    151  NH2 ARG A  19     -12.582 -19.383  -0.341  1.00 45.77           N  
ATOM    152  N   TRP A  20     -11.352 -25.273   3.432  1.00 48.74           N  
ATOM    153  CA  TRP A  20     -11.053 -26.525   2.772  1.00 48.12           C  
ATOM    154  C   TRP A  20     -11.298 -26.377   1.283  1.00 48.07           C  
ATOM    155  O   TRP A  20     -11.747 -27.315   0.608  1.00 47.83           O  
ATOM    156  CB  TRP A  20     -11.893 -27.655   3.401  1.00 47.79           C  
ATOM    157  CG  TRP A  20     -11.840 -27.547   4.896  1.00 47.26           C  
ATOM    158  CD1 TRP A  20     -10.714 -27.619   5.683  1.00 45.10           C  
ATOM    159  CD2 TRP A  20     -12.930 -27.271   5.778  1.00 47.55           C  
ATOM    160  NE1 TRP A  20     -11.033 -27.403   6.998  1.00 46.08           N  
ATOM    161  CE2 TRP A  20     -12.390 -27.200   7.098  1.00 48.61           C  
ATOM    162  CE3 TRP A  20     -14.315 -27.077   5.593  1.00 46.85           C  
ATOM    163  CZ2 TRP A  20     -13.201 -26.948   8.242  1.00 46.99           C  
ATOM    164  CZ3 TRP A  20     -15.135 -26.845   6.741  1.00 45.29           C  
ATOM    165  CH2 TRP A  20     -14.566 -26.776   8.037  1.00 45.89           C  
ATOM    166  N   ASP A  21     -10.980 -25.190   0.768  1.00 47.89           N  
ATOM    167  CA  ASP A  21     -11.196 -24.901  -0.665  1.00 48.35           C  
ATOM    168  C   ASP A  21      -9.853 -24.712  -1.417  1.00 47.91           C  
ATOM    169  O   ASP A  21      -9.326 -23.594  -1.550  1.00 48.43           O  
ATOM    170  CB  ASP A  21     -12.184 -23.727  -0.819  1.00 47.51           C  
ATOM    171  CG  ASP A  21     -12.347 -23.245  -2.249  1.00 49.65           C  
ATOM    172  OD1 ASP A  21     -12.217 -24.027  -3.220  1.00 52.32           O  
ATOM    173  OD2 ASP A  21     -12.619 -22.033  -2.408  1.00 52.54           O  
ATOM    174  N   VAL A  22      -9.324 -25.823  -1.911  1.00 47.08           N  
ATOM    175  CA  VAL A  22      -8.034 -25.868  -2.608  1.00 46.50           C  
ATOM    176  C   VAL A  22      -7.974 -25.016  -3.867  1.00 46.67           C  
ATOM    177  O   VAL A  22      -6.958 -24.344  -4.142  1.00 48.11           O  
ATOM    178  CB  VAL A  22      -7.667 -27.301  -2.980  1.00 46.47           C  
ATOM    179  CG1 VAL A  22      -6.468 -27.326  -3.940  1.00 46.62           C  
ATOM    180  CG2 VAL A  22      -7.401 -28.139  -1.723  1.00 45.12           C  
ATOM    181  N   SER A  23      -9.037 -25.009  -4.647  1.00 46.18           N  
ATOM    182  CA  SER A  23      -9.010 -24.194  -5.857  1.00 45.87           C  
ATOM    183  C   SER A  23      -9.147 -22.704  -5.549  1.00 45.40           C  
ATOM    184  O   SER A  23      -8.800 -21.868  -6.373  1.00 45.74           O  
ATOM    185  CB  SER A  23     -10.074 -24.659  -6.840  1.00 45.53           C  
ATOM    186  OG  SER A  23     -11.347 -24.537  -6.242  1.00 48.00           O  
ATOM    187  N   GLY A  24      -9.685 -22.366  -4.381  1.00 45.43           N  
ATOM    188  CA  GLY A  24      -9.672 -20.973  -3.919  1.00 45.62           C  
ATOM    189  C   GLY A  24      -8.231 -20.525  -3.635  1.00 45.99           C  
ATOM    190  O   GLY A  24      -7.854 -19.382  -3.951  1.00 46.70           O  
ATOM    191  N   VAL A  25      -7.408 -21.415  -3.078  1.00 44.85           N  
ATOM    192  CA  VAL A  25      -5.992 -21.102  -2.946  1.00 45.36           C  
ATOM    193  C   VAL A  25      -5.311 -20.985  -4.305  1.00 45.76           C  
ATOM    194  O   VAL A  25      -4.742 -19.951  -4.645  1.00 46.23           O  
ATOM    195  CB  VAL A  25      -5.247 -22.106  -2.057  1.00 45.70           C  
ATOM    196  CG1 VAL A  25      -3.842 -21.634  -1.831  1.00 44.82           C  
ATOM    197  CG2 VAL A  25      -5.983 -22.281  -0.681  1.00 45.21           C  
ATOM    198  N   VAL A  26      -5.384 -22.043  -5.096  1.00 46.31           N  
ATOM    199  CA  VAL A  26      -4.764 -22.070  -6.433  1.00 45.65           C  
ATOM    200  C   VAL A  26      -5.149 -20.877  -7.330  1.00 45.77           C  
ATOM    201  O   VAL A  26      -4.374 -20.473  -8.218  1.00 45.49           O  
ATOM    202  CB  VAL A  26      -5.113 -23.391  -7.112  1.00 45.97           C  
ATOM    203  CG1 VAL A  26      -4.779 -23.378  -8.592  1.00 44.94           C  
ATOM    204  CG2 VAL A  26      -4.420 -24.519  -6.398  1.00 43.88           C  
ATOM    205  N   ALA A  27      -6.317 -20.284  -7.077  1.00 45.54           N  
ATOM    206  CA  ALA A  27      -6.780 -19.130  -7.888  1.00 45.27           C  
ATOM    207  C   ALA A  27      -5.874 -17.902  -7.722  1.00 45.58           C  
ATOM    208  O   ALA A  27      -5.910 -16.969  -8.557  1.00 46.26           O  
ATOM    209  CB  ALA A  27      -8.238 -18.783  -7.582  1.00 44.59           C  
ATOM    210  N   HIS A  28      -5.044 -17.904  -6.675  1.00 45.53           N  
ATOM    211  CA  HIS A  28      -4.071 -16.827  -6.453  1.00 45.61           C  
ATOM    212  C   HIS A  28      -2.724 -17.043  -7.164  1.00 45.67           C  
ATOM    213  O   HIS A  28      -1.842 -16.176  -7.112  1.00 46.12           O  
ATOM    214  CB  HIS A  28      -3.878 -16.595  -4.957  1.00 45.71           C  
ATOM    215  CG  HIS A  28      -5.073 -15.979  -4.289  1.00 48.09           C  
ATOM    216  ND1 HIS A  28      -6.107 -16.729  -3.753  1.00 49.78           N  
ATOM    217  CD2 HIS A  28      -5.406 -14.680  -4.087  1.00 48.41           C  
ATOM    218  CE1 HIS A  28      -7.020 -15.916  -3.247  1.00 50.91           C  
ATOM    219  NE2 HIS A  28      -6.623 -14.668  -3.445  1.00 50.82           N  
ATOM    220  N   TRP A  29      -2.554 -18.178  -7.842  1.00 45.61           N  
ATOM    221  CA  TRP A  29      -1.264 -18.455  -8.498  1.00 45.85           C  
ATOM    222  C   TRP A  29      -1.202 -17.924  -9.922  1.00 46.07           C  
ATOM    223  O   TRP A  29      -2.146 -18.028 -10.654  1.00 46.43           O  
ATOM    224  CB  TRP A  29      -0.947 -19.957  -8.556  1.00 44.43           C  
ATOM    225  CG  TRP A  29      -0.937 -20.694  -7.250  1.00 43.71           C  
ATOM    226  CD1 TRP A  29      -0.928 -20.161  -5.966  1.00 42.79           C  
ATOM    227  CD2 TRP A  29      -0.869 -22.103  -7.093  1.00 41.99           C  
ATOM    228  NE1 TRP A  29      -0.897 -21.170  -5.039  1.00 41.28           N  
ATOM    229  CE2 TRP A  29      -0.855 -22.372  -5.701  1.00 43.16           C  
ATOM    230  CE3 TRP A  29      -0.837 -23.178  -7.993  1.00 42.96           C  
ATOM    231  CZ2 TRP A  29      -0.837 -23.678  -5.195  1.00 42.00           C  
ATOM    232  CZ3 TRP A  29      -0.790 -24.490  -7.474  1.00 42.27           C  
ATOM    233  CH2 TRP A  29      -0.793 -24.714  -6.094  1.00 41.90           C  
ATOM    234  N   ALA A  30      -0.069 -17.391 -10.323  1.00 47.28           N  
ATOM    235  CA  ALA A  30       0.180 -17.162 -11.735  1.00 48.56           C  
ATOM    236  C   ALA A  30       0.091 -18.517 -12.443  1.00 49.67           C  
ATOM    237  O   ALA A  30       0.255 -19.554 -11.815  1.00 50.19           O  
ATOM    238  CB  ALA A  30       1.539 -16.550 -11.924  1.00 47.93           C  
ATOM    239  N   PRO A  31      -0.191 -18.529 -13.753  1.00 50.83           N  
ATOM    240  CA  PRO A  31      -0.222 -19.879 -14.337  1.00 51.53           C  
ATOM    241  C   PRO A  31       1.194 -20.457 -14.576  1.00 51.66           C  
ATOM    242  O   PRO A  31       1.329 -21.652 -14.793  1.00 52.51           O  
ATOM    243  CB  PRO A  31      -0.996 -19.680 -15.658  1.00 51.25           C  
ATOM    244  CG  PRO A  31      -0.664 -18.231 -16.061  1.00 51.48           C  
ATOM    245  CD  PRO A  31      -0.456 -17.466 -14.751  1.00 51.21           C  
ATOM    246  N   ASP A  32       2.218 -19.612 -14.537  1.00 51.38           N  
ATOM    247  CA  ASP A  32       3.621 -20.033 -14.617  1.00 51.63           C  
ATOM    248  C   ASP A  32       4.315 -19.948 -13.227  1.00 50.92           C  
ATOM    249  O   ASP A  32       5.527 -19.681 -13.128  1.00 51.36           O  
ATOM    250  CB  ASP A  32       4.352 -19.112 -15.593  1.00 51.88           C  
ATOM    251  CG  ASP A  32       4.268 -17.658 -15.158  1.00 54.65           C  
ATOM    252  OD1 ASP A  32       3.166 -17.238 -14.736  1.00 56.40           O  
ATOM    253  OD2 ASP A  32       5.291 -16.938 -15.199  1.00 58.59           O  
ATOM    254  N   VAL A  33       3.537 -20.124 -12.160  1.00 49.69           N  
ATOM    255  CA  VAL A  33       4.064 -20.141 -10.795  1.00 48.03           C  
ATOM    256  C   VAL A  33       5.077 -21.276 -10.675  1.00 47.65           C  
ATOM    257  O   VAL A  33       4.874 -22.350 -11.247  1.00 47.70           O  
ATOM    258  CB  VAL A  33       2.915 -20.349  -9.766  1.00 48.04           C  
ATOM    259  CG1 VAL A  33       2.137 -21.625 -10.046  1.00 45.60           C  
ATOM    260  CG2 VAL A  33       3.422 -20.298  -8.314  1.00 47.35           C  
ATOM    261  N   VAL A  34       6.173 -21.026  -9.968  1.00 46.66           N  
ATOM    262  CA  VAL A  34       7.116 -22.089  -9.617  1.00 46.03           C  
ATOM    263  C   VAL A  34       7.029 -22.395  -8.123  1.00 45.76           C  
ATOM    264  O   VAL A  34       7.040 -21.479  -7.301  1.00 45.80           O  
ATOM    265  CB  VAL A  34       8.578 -21.705 -10.010  1.00 46.29           C  
ATOM    266  CG1 VAL A  34       9.548 -22.853  -9.711  1.00 45.45           C  
ATOM    267  CG2 VAL A  34       8.658 -21.280 -11.506  1.00 45.44           C  
ATOM    268  N   HIS A  35       6.948 -23.672  -7.777  1.00 45.90           N  
ATOM    269  CA  HIS A  35       6.967 -24.110  -6.381  1.00 47.18           C  
ATOM    270  C   HIS A  35       8.303 -24.713  -6.009  1.00 47.98           C  
ATOM    271  O   HIS A  35       8.839 -25.535  -6.758  1.00 47.88           O  
ATOM    272  CB  HIS A  35       5.878 -25.132  -6.130  1.00 46.69           C  
ATOM    273  CG  HIS A  35       4.500 -24.594  -6.340  1.00 50.12           C  
ATOM    274  ND1 HIS A  35       3.721 -24.110  -5.304  1.00 53.02           N  
ATOM    275  CD2 HIS A  35       3.763 -24.446  -7.468  1.00 50.29           C  
ATOM    276  CE1 HIS A  35       2.563 -23.693  -5.784  1.00 52.76           C  
ATOM    277  NE2 HIS A  35       2.567 -23.879  -7.094  1.00 53.03           N  
ATOM    278  N   TYR A  36       8.843 -24.315  -4.859  1.00 49.49           N  
ATOM    279  CA  TYR A  36      10.122 -24.871  -4.395  1.00 51.94           C  
ATOM    280  C   TYR A  36      10.068 -25.679  -3.087  1.00 54.07           C  
ATOM    281  O   TYR A  36       9.272 -25.381  -2.192  1.00 54.07           O  
ATOM    282  CB  TYR A  36      11.178 -23.762  -4.247  1.00 50.95           C  
ATOM    283  CG  TYR A  36      11.505 -22.976  -5.493  1.00 48.73           C  
ATOM    284  CD1 TYR A  36      12.394 -23.465  -6.438  1.00 47.88           C  
ATOM    285  CD2 TYR A  36      10.935 -21.725  -5.712  1.00 48.41           C  
ATOM    286  CE1 TYR A  36      12.704 -22.730  -7.585  1.00 46.96           C  
ATOM    287  CE2 TYR A  36      11.232 -20.983  -6.843  1.00 46.71           C  
ATOM    288  CZ  TYR A  36      12.112 -21.486  -7.771  1.00 48.08           C  
ATOM    289  OH  TYR A  36      12.404 -20.728  -8.880  1.00 48.65           O  
ATOM    290  N   ASP A  37      10.918 -26.703  -3.008  1.00 57.05           N  
ATOM    291  CA  ASP A  37      11.443 -27.261  -1.735  1.00 60.51           C  
ATOM    292  C   ASP A  37      11.755 -26.216  -0.651  1.00 62.52           C  
ATOM    293  O   ASP A  37      11.769 -25.007  -0.908  1.00 63.17           O  
ATOM    294  CB  ASP A  37      12.800 -27.956  -1.997  1.00 60.40           C  
ATOM    295  CG  ASP A  37      12.641 -29.354  -2.525  1.00 62.06           C  
ATOM    296  OD1 ASP A  37      11.549 -29.936  -2.313  1.00 64.32           O  
ATOM    297  OD2 ASP A  37      13.585 -29.859  -3.172  1.00 61.33           O  
ATOM    298  N   ASP A  38      12.068 -26.698   0.554  1.00 64.42           N  
ATOM    299  CA  ASP A  38      12.739 -25.867   1.555  1.00 66.00           C  
ATOM    300  C   ASP A  38      14.186 -25.547   1.095  1.00 66.65           C  
ATOM    301  O   ASP A  38      14.782 -24.559   1.550  1.00 66.77           O  
ATOM    302  CB  ASP A  38      12.696 -26.524   2.954  1.00 66.07           C  
ATOM    303  CG  ASP A  38      13.411 -27.879   3.017  1.00 68.13           C  
ATOM    304  OD1 ASP A  38      13.770 -28.477   1.962  1.00 70.01           O  
ATOM    305  OD2 ASP A  38      13.619 -28.354   4.156  1.00 70.13           O  
ATOM    306  N   GLU A  39      14.700 -26.361   0.161  1.00 66.99           N  
ATOM    307  CA  GLU A  39      16.063 -26.238  -0.373  1.00 67.43           C  
ATOM    308  C   GLU A  39      16.146 -25.717  -1.821  1.00 67.05           C  
ATOM    309  O   GLU A  39      17.078 -26.072  -2.553  1.00 66.51           O  
ATOM    310  CB  GLU A  39      16.763 -27.596  -0.304  1.00 67.80           C  
ATOM    311  CG  GLU A  39      16.595 -28.306   1.023  1.00 70.37           C  
ATOM    312  CD  GLU A  39      17.919 -28.766   1.610  1.00 72.87           C  
ATOM    313  OE1 GLU A  39      18.866 -27.945   1.665  1.00 73.81           O  
ATOM    314  OE2 GLU A  39      18.005 -29.945   2.022  1.00 73.46           O  
ATOM    315  N   ASP A  40      15.172 -24.893  -2.234  1.00 66.76           N  
ATOM    316  CA  ASP A  40      15.134 -24.314  -3.615  1.00 66.25           C  
ATOM    317  C   ASP A  40      15.077 -25.251  -4.857  1.00 64.56           C  
ATOM    318  O   ASP A  40      15.424 -24.831  -5.966  1.00 64.28           O  
ATOM    319  CB  ASP A  40      16.237 -23.252  -3.808  1.00 66.82           C  
ATOM    320  CG  ASP A  40      15.766 -21.860  -3.429  1.00 69.80           C  
ATOM    321  OD1 ASP A  40      15.863 -21.498  -2.227  1.00 70.89           O  
ATOM    322  OD2 ASP A  40      15.285 -21.128  -4.340  1.00 73.30           O  
ATOM    323  N   LYS A  41      14.622 -26.493  -4.692  1.00 62.72           N  
ATOM    324  CA  LYS A  41      14.341 -27.329  -5.873  1.00 61.33           C  
ATOM    325  C   LYS A  41      12.857 -27.235  -6.350  1.00 59.63           C  
ATOM    326  O   LYS A  41      11.927 -27.283  -5.530  1.00 58.97           O  
ATOM    327  CB  LYS A  41      14.800 -28.787  -5.674  1.00 61.37           C  
ATOM    328  CG  LYS A  41      15.429 -29.484  -6.583  0.00 50.00           C  
ATOM    329  CD  LYS A  41      15.403 -31.002  -6.440  0.00 50.00           C  
ATOM    330  CE  LYS A  41      16.812 -31.594  -6.429  0.00 50.00           C  
ATOM    331  NZ  LYS A  41      17.478 -31.515  -7.760  0.00 50.00           N  
ATOM    332  N   PRO A  42      12.650 -27.045  -7.670  1.00 57.74           N  
ATOM    333  CA  PRO A  42      11.305 -26.995  -8.228  1.00 56.07           C  
ATOM    334  C   PRO A  42      10.557 -28.268  -7.933  1.00 54.65           C  
ATOM    335  O   PRO A  42      11.121 -29.343  -8.037  1.00 54.85           O  
ATOM    336  CB  PRO A  42      11.547 -26.874  -9.728  1.00 55.96           C  
ATOM    337  CG  PRO A  42      12.894 -26.251  -9.843  1.00 57.00           C  
ATOM    338  CD  PRO A  42      13.681 -26.823  -8.702  1.00 57.57           C  
ATOM    339  N   VAL A  43       9.298 -28.128  -7.541  1.00 52.88           N  
ATOM    340  CA  VAL A  43       8.392 -29.237  -7.324  1.00 51.48           C  
ATOM    341  C   VAL A  43       7.258 -29.048  -8.333  1.00 50.61           C  
ATOM    342  O   VAL A  43       6.798 -27.929  -8.539  1.00 50.31           O  
ATOM    343  CB  VAL A  43       7.809 -29.200  -5.875  1.00 51.53           C  
ATOM    344  CG1 VAL A  43       6.725 -30.278  -5.671  1.00 51.36           C  
ATOM    345  CG2 VAL A  43       8.901 -29.384  -4.867  1.00 51.57           C  
ATOM    346  N   SER A  44       6.795 -30.129  -8.951  1.00 49.75           N  
ATOM    347  CA  SER A  44       5.741 -30.015  -9.961  1.00 49.44           C  
ATOM    348  C   SER A  44       4.404 -29.524  -9.362  1.00 48.97           C  
ATOM    349  O   SER A  44       4.004 -29.931  -8.276  1.00 49.33           O  
ATOM    350  CB  SER A  44       5.552 -31.336 -10.718  1.00 49.10           C  
ATOM    351  OG  SER A  44       4.808 -32.262  -9.943  1.00 50.76           O  
ATOM    352  N   ALA A  45       3.729 -28.639 -10.082  1.00 48.47           N  
ATOM    353  CA  ALA A  45       2.407 -28.180  -9.693  1.00 48.41           C  
ATOM    354  C   ALA A  45       1.472 -29.362  -9.391  1.00 48.44           C  
ATOM    355  O   ALA A  45       0.689 -29.296  -8.454  1.00 48.53           O  
ATOM    356  CB  ALA A  45       1.817 -27.277 -10.777  1.00 47.90           C  
ATOM    357  N   GLU A  46       1.592 -30.428 -10.180  1.00 48.45           N  
ATOM    358  CA  GLU A  46       0.802 -31.637 -10.063  1.00 49.02           C  
ATOM    359  C   GLU A  46       0.914 -32.208  -8.663  1.00 49.72           C  
ATOM    360  O   GLU A  46      -0.110 -32.525  -8.039  1.00 50.30           O  
ATOM    361  CB  GLU A  46       1.277 -32.658 -11.101  1.00 48.98           C  
ATOM    362  CG  GLU A  46       0.473 -33.948 -11.190  1.00 50.23           C  
ATOM    363  CD  GLU A  46       0.910 -34.838 -12.368  0.50 49.85           C  
ATOM    364  OE1 GLU A  46       2.132 -34.960 -12.611  0.50 50.89           O  
ATOM    365  OE2 GLU A  46       0.034 -35.413 -13.053  0.50 49.62           O  
ATOM    366  N   GLU A  47       2.144 -32.318  -8.153  1.00 49.62           N  
ATOM    367  CA  GLU A  47       2.364 -32.886  -6.833  1.00 49.10           C  
ATOM    368  C   GLU A  47       1.934 -31.945  -5.701  1.00 48.50           C  
ATOM    369  O   GLU A  47       1.380 -32.392  -4.698  1.00 47.97           O  
ATOM    370  CB  GLU A  47       3.818 -33.348  -6.679  1.00 49.84           C  
ATOM    371  CG  GLU A  47       4.082 -34.751  -7.276  1.00 51.49           C  
ATOM    372  CD  GLU A  47       3.367 -35.865  -6.480  0.50 52.04           C  
ATOM    373  OE1 GLU A  47       3.290 -35.759  -5.230  0.50 51.14           O  
ATOM    374  OE2 GLU A  47       2.883 -36.839  -7.105  0.50 51.20           O  
ATOM    375  N   VAL A  48       2.171 -30.645  -5.865  1.00 47.57           N  
ATOM    376  CA  VAL A  48       1.686 -29.661  -4.902  1.00 46.80           C  
ATOM    377  C   VAL A  48       0.156 -29.756  -4.730  1.00 46.48           C  
ATOM    378  O   VAL A  48      -0.363 -29.757  -3.613  1.00 46.50           O  
ATOM    379  CB  VAL A  48       2.130 -28.212  -5.296  1.00 47.26           C  
ATOM    380  CG1 VAL A  48       1.537 -27.165  -4.356  1.00 46.52           C  
ATOM    381  CG2 VAL A  48       3.644 -28.081  -5.288  1.00 46.33           C  
ATOM    382  N   VAL A  49      -0.564 -29.862  -5.839  1.00 46.15           N  
ATOM    383  CA  VAL A  49      -2.020 -29.900  -5.775  1.00 45.78           C  
ATOM    384  C   VAL A  49      -2.517 -31.198  -5.153  1.00 46.22           C  
ATOM    385  O   VAL A  49      -3.422 -31.174  -4.328  1.00 46.40           O  
ATOM    386  CB  VAL A  49      -2.652 -29.548  -7.154  1.00 45.87           C  
ATOM    387  CG1 VAL A  49      -4.146 -29.911  -7.227  1.00 45.15           C  
ATOM    388  CG2 VAL A  49      -2.441 -28.059  -7.452  1.00 43.57           C  
ATOM    389  N   ARG A  50      -1.887 -32.312  -5.516  1.00 46.98           N  
ATOM    390  CA  ARG A  50      -2.175 -33.638  -4.969  1.00 48.08           C  
ATOM    391  C   ARG A  50      -2.085 -33.667  -3.429  1.00 49.02           C  
ATOM    392  O   ARG A  50      -3.001 -34.177  -2.750  1.00 48.84           O  
ATOM    393  CB  ARG A  50      -1.206 -34.636  -5.585  1.00 48.14           C  
ATOM    394  CG  ARG A  50      -1.479 -36.093  -5.257  1.00 51.56           C  
ATOM    395  CD  ARG A  50      -0.861 -36.999  -6.357  1.00 58.45           C  
ATOM    396  NE  ARG A  50       0.502 -37.444  -6.053  1.00 61.77           N  
ATOM    397  CZ  ARG A  50       0.795 -38.486  -5.266  0.50 61.91           C  
ATOM    398  NH1 ARG A  50       2.064 -38.816  -5.042  0.50 61.80           N  
ATOM    399  NH2 ARG A  50      -0.175 -39.200  -4.698  0.50 60.06           N  
ATOM    400  N   ARG A  51      -1.007 -33.076  -2.897  1.00 49.51           N  
ATOM    401  CA  ARG A  51      -0.791 -32.945  -1.461  1.00 50.41           C  
ATOM    402  C   ARG A  51      -1.877 -32.102  -0.793  1.00 50.70           C  
ATOM    403  O   ARG A  51      -2.420 -32.471   0.263  1.00 50.06           O  
ATOM    404  CB  ARG A  51       0.617 -32.371  -1.163  1.00 50.42           C  
HETATM  405  N   MSE A  52      -2.195 -30.974  -1.420  1.00 51.15           N  
HETATM  406  CA  MSE A  52      -3.280 -30.124  -0.934  1.00 53.25           C  
HETATM  407  C   MSE A  52      -4.629 -30.851  -0.927  1.00 50.96           C  
HETATM  408  O   MSE A  52      -5.311 -30.851   0.102  1.00 50.89           O  
HETATM  409  CB  MSE A  52      -3.357 -28.849  -1.742  1.00 52.14           C  
HETATM  410  CG  MSE A  52      -2.082 -28.041  -1.697  1.00 54.08           C  
HETATM  411 SE   MSE A  52      -2.267 -26.571  -2.998  1.00 63.95          SE  
HETATM  412  CE  MSE A  52      -3.453 -25.363  -1.888  1.00 55.73           C  
ATOM    413  N   ASN A  53      -4.986 -31.517  -2.027  1.00 49.46           N  
ATOM    414  CA  ASN A  53      -6.212 -32.326  -2.043  1.00 48.74           C  
ATOM    415  C   ASN A  53      -6.256 -33.402  -0.953  1.00 48.36           C  
ATOM    416  O   ASN A  53      -7.284 -33.591  -0.276  1.00 48.10           O  
ATOM    417  CB  ASN A  53      -6.495 -32.916  -3.425  1.00 48.26           C  
ATOM    418  CG  ASN A  53      -6.920 -31.864  -4.406  1.00 47.99           C  
ATOM    419  OD1 ASN A  53      -7.601 -30.922  -4.026  1.00 49.27           O  
ATOM    420  ND2 ASN A  53      -6.500 -31.988  -5.666  1.00 45.43           N  
ATOM    421  N   SER A  54      -5.134 -34.081  -0.773  1.00 48.19           N  
ATOM    422  CA  SER A  54      -5.052 -35.158   0.199  1.00 48.34           C  
ATOM    423  C   SER A  54      -5.244 -34.587   1.603  1.00 48.67           C  
ATOM    424  O   SER A  54      -5.963 -35.176   2.393  1.00 48.96           O  
ATOM    425  CB  SER A  54      -3.727 -35.922   0.062  1.00 48.12           C  
ATOM    426  OG  SER A  54      -3.760 -37.154   0.775  1.00 48.16           O  
ATOM    427  N   ALA A  55      -4.649 -33.424   1.894  1.00 48.70           N  
ATOM    428  CA  ALA A  55      -4.830 -32.807   3.200  1.00 49.14           C  
ATOM    429  C   ALA A  55      -6.297 -32.510   3.504  1.00 49.07           C  
ATOM    430  O   ALA A  55      -6.747 -32.714   4.617  1.00 48.58           O  
ATOM    431  CB  ALA A  55      -3.952 -31.535   3.368  1.00 48.94           C  
ATOM    432  N   VAL A  56      -7.034 -32.018   2.515  1.00 49.90           N  
ATOM    433  CA  VAL A  56      -8.471 -31.718   2.678  1.00 50.65           C  
ATOM    434  C   VAL A  56      -9.333 -32.964   2.975  1.00 51.07           C  
ATOM    435  O   VAL A  56     -10.239 -32.899   3.814  1.00 51.62           O  
ATOM    436  CB  VAL A  56      -9.032 -30.949   1.456  1.00 50.92           C  
ATOM    437  CG1 VAL A  56     -10.562 -30.939   1.464  1.00 50.04           C  
ATOM    438  CG2 VAL A  56      -8.486 -29.517   1.463  1.00 51.67           C  
ATOM    439  N   GLU A  57      -9.025 -34.069   2.301  1.00 51.16           N  
ATOM    440  CA  GLU A  57      -9.655 -35.359   2.497  1.00 52.64           C  
ATOM    441  C   GLU A  57      -9.259 -35.992   3.842  1.00 51.80           C  
ATOM    442  O   GLU A  57     -10.057 -36.665   4.520  1.00 51.16           O  
ATOM    443  CB  GLU A  57      -9.241 -36.290   1.350  1.00 52.61           C  
ATOM    444  CG  GLU A  57      -9.930 -37.667   1.348  1.00 54.94           C  
ATOM    445  CD  GLU A  57      -9.254 -38.697   0.376  1.00 57.19           C  
ATOM    446  OE1 GLU A  57      -8.555 -38.302  -0.612  1.00 57.82           O  
ATOM    447  OE2 GLU A  57      -9.435 -39.929   0.613  1.00 64.48           O  
ATOM    448  N   ALA A  58      -8.011 -35.773   4.230  1.00 51.39           N  
ATOM    449  CA  ALA A  58      -7.495 -36.395   5.426  1.00 50.40           C  
ATOM    450  C   ALA A  58      -7.944 -35.648   6.675  1.00 50.14           C  
ATOM    451  O   ALA A  58      -8.161 -36.265   7.704  1.00 50.12           O  
ATOM    452  CB  ALA A  58      -6.007 -36.472   5.364  1.00 50.39           C  
ATOM    453  N   PHE A  59      -8.103 -34.329   6.571  1.00 49.93           N  
ATOM    454  CA  PHE A  59      -8.252 -33.480   7.743  1.00 49.99           C  
ATOM    455  C   PHE A  59      -9.509 -32.627   7.673  1.00 50.90           C  
ATOM    456  O   PHE A  59      -9.426 -31.467   7.302  1.00 52.33           O  
ATOM    457  CB  PHE A  59      -7.010 -32.587   7.940  1.00 49.40           C  
ATOM    458  CG  PHE A  59      -5.706 -33.355   8.013  1.00 48.77           C  
ATOM    459  CD1 PHE A  59      -5.540 -34.401   8.903  1.00 49.09           C  
ATOM    460  CD2 PHE A  59      -4.655 -33.037   7.172  1.00 49.50           C  
ATOM    461  CE1 PHE A  59      -4.342 -35.116   8.968  1.00 49.58           C  
ATOM    462  CE2 PHE A  59      -3.460 -33.738   7.219  1.00 50.26           C  
ATOM    463  CZ  PHE A  59      -3.302 -34.794   8.109  1.00 49.81           C  
ATOM    464  N   PRO A  60     -10.670 -33.183   8.056  1.00 51.45           N  
ATOM    465  CA  PRO A  60     -11.940 -32.451   7.931  1.00 51.55           C  
ATOM    466  C   PRO A  60     -11.963 -31.167   8.739  1.00 51.48           C  
ATOM    467  O   PRO A  60     -12.716 -30.258   8.399  1.00 53.38           O  
ATOM    468  CB  PRO A  60     -12.984 -33.430   8.530  1.00 51.81           C  
ATOM    469  CG  PRO A  60     -12.174 -34.357   9.450  1.00 52.01           C  
ATOM    470  CD  PRO A  60     -10.872 -34.524   8.653  1.00 52.04           C  
ATOM    471  N   ASP A  61     -11.170 -31.093   9.810  1.00 50.42           N  
ATOM    472  CA  ASP A  61     -11.167 -29.917  10.681  1.00 48.37           C  
ATOM    473  C   ASP A  61      -9.873 -29.091  10.612  1.00 48.05           C  
ATOM    474  O   ASP A  61      -9.579 -28.337  11.537  1.00 47.43           O  
ATOM    475  CB  ASP A  61     -11.444 -30.327  12.128  1.00 47.69           C  
ATOM    476  CG  ASP A  61     -10.299 -31.133  12.763  1.00 47.65           C  
ATOM    477  OD1 ASP A  61      -9.481 -31.734  12.031  1.00 45.45           O  
ATOM    478  OD2 ASP A  61     -10.235 -31.176  14.024  1.00 49.85           O  
ATOM    479  N   LEU A  62      -9.108 -29.230   9.525  1.00 48.06           N  
ATOM    480  CA  LEU A  62      -7.826 -28.511   9.374  1.00 48.01           C  
ATOM    481  C   LEU A  62      -8.000 -27.017   9.664  1.00 48.03           C  
ATOM    482  O   LEU A  62      -8.926 -26.384   9.150  1.00 48.26           O  
ATOM    483  CB  LEU A  62      -7.296 -28.707   7.960  1.00 47.31           C  
ATOM    484  CG  LEU A  62      -6.069 -27.917   7.528  1.00 47.34           C  
ATOM    485  CD1 LEU A  62      -4.830 -28.376   8.297  1.00 47.42           C  
ATOM    486  CD2 LEU A  62      -5.841 -28.069   6.034  1.00 47.90           C  
ATOM    487  N   ARG A  63      -7.136 -26.462  10.491  1.00 47.97           N  
ATOM    488  CA  ARG A  63      -7.220 -25.047  10.857  0.50 48.94           C  
ATOM    490  C   ARG A  63      -5.838 -24.423  10.717  1.00 49.18           C  
ATOM    491  O   ARG A  63      -4.885 -24.911  11.336  1.00 49.65           O  
ATOM    492  CB  ARG A  63      -7.730 -24.894  12.306  0.50 48.81           C  
ATOM    494  CG  ARG A  63      -8.596 -23.652  12.561  0.50 49.01           C  
ATOM    496  CD  ARG A  63      -9.043 -23.517  14.024  0.50 49.36           C  
ATOM    498  NE  ARG A  63      -8.060 -22.814  14.858  0.50 51.27           N  
ATOM    500  CZ  ARG A  63      -7.391 -23.360  15.880  0.50 52.40           C  
ATOM    502  NH1 ARG A  63      -6.533 -22.623  16.563  0.50 53.51           N  
ATOM    504  NH2 ARG A  63      -7.572 -24.634  16.238  0.50 51.63           N  
ATOM    506  N   LEU A  64      -5.736 -23.325  10.010  1.00 49.31           N  
ATOM    507  CA  LEU A  64      -4.495 -22.640   9.823  1.00 49.05           C  
ATOM    508  C   LEU A  64      -4.515 -21.348  10.592  1.00 49.13           C  
ATOM    509  O   LEU A  64      -5.304 -20.509  10.342  1.00 49.70           O  
ATOM    510  CB  LEU A  64      -4.308 -22.346   8.346  1.00 48.90           C  
ATOM    511  CG  LEU A  64      -3.504 -23.296   7.480  1.00 48.94           C  
ATOM    512  CD1 LEU A  64      -4.190 -24.552   7.259  1.00 50.26           C  
ATOM    513  CD2 LEU A  64      -3.197 -22.667   6.194  1.00 44.28           C  
ATOM    514  N   ASP A  65      -3.620 -21.190  11.539  1.00 49.46           N  
ATOM    515  CA  ASP A  65      -3.640 -20.003  12.390  1.00 49.85           C  
ATOM    516  C   ASP A  65      -2.451 -19.102  12.066  1.00 48.85           C  
ATOM    517  O   ASP A  65      -1.308 -19.439  12.389  1.00 49.23           O  
ATOM    518  CB  ASP A  65      -3.601 -20.462  13.852  1.00 51.15           C  
ATOM    519  CG  ASP A  65      -3.846 -19.336  14.845  1.00 56.22           C  
ATOM    520  OD1 ASP A  65      -4.106 -18.172  14.444  1.00 61.52           O  
ATOM    521  OD2 ASP A  65      -3.782 -19.625  16.062  1.00 61.79           O  
ATOM    522  N   VAL A  66      -2.695 -17.973  11.403  1.00 47.84           N  
ATOM    523  CA  VAL A  66      -1.593 -17.069  11.083  1.00 46.85           C  
ATOM    524  C   VAL A  66      -1.029 -16.476  12.360  1.00 46.87           C  
ATOM    525  O   VAL A  66      -1.731 -15.749  13.043  1.00 47.06           O  
ATOM    526  CB  VAL A  66      -1.975 -15.954  10.047  1.00 47.17           C  
ATOM    527  CG1 VAL A  66      -0.805 -15.002   9.823  1.00 44.20           C  
ATOM    528  CG2 VAL A  66      -2.405 -16.590   8.700  1.00 45.57           C  
ATOM    529  N   ARG A  67       0.224 -16.815  12.684  1.00 46.57           N  
ATOM    530  CA  ARG A  67       0.880 -16.343  13.914  1.00 46.53           C  
ATOM    531  C   ARG A  67       1.678 -15.082  13.682  1.00 46.48           C  
ATOM    532  O   ARG A  67       1.831 -14.263  14.589  1.00 46.15           O  
ATOM    533  CB  ARG A  67       1.780 -17.422  14.511  1.00 46.63           C  
ATOM    534  CG  ARG A  67       1.037 -18.713  14.818  1.00 48.70           C  
ATOM    535  CD  ARG A  67       0.113 -18.559  16.022  1.00 49.51           C  
ATOM    536  NE  ARG A  67       0.954 -18.292  17.177  1.00 55.28           N  
ATOM    537  CZ  ARG A  67       1.717 -19.205  17.792  1.00 57.67           C  
ATOM    538  NH1 ARG A  67       1.722 -20.485  17.384  1.00 55.54           N  
ATOM    539  NH2 ARG A  67       2.477 -18.836  18.832  1.00 57.39           N  
ATOM    540  N   SER A  68       2.180 -14.929  12.459  1.00 46.58           N  
ATOM    541  CA  SER A  68       2.906 -13.747  12.074  1.00 46.76           C  
ATOM    542  C   SER A  68       2.994 -13.607  10.549  1.00 46.35           C  
ATOM    543  O   SER A  68       2.959 -14.609   9.830  1.00 47.09           O  
ATOM    544  CB  SER A  68       4.270 -13.791  12.746  1.00 47.55           C  
ATOM    545  OG  SER A  68       5.357 -13.538  11.855  1.00 50.96           O  
ATOM    546  N   ILE A  69       3.095 -12.374  10.059  1.00 45.45           N  
ATOM    547  CA  ILE A  69       3.134 -12.099   8.621  1.00 45.28           C  
ATOM    548  C   ILE A  69       3.870 -10.783   8.360  1.00 45.95           C  
ATOM    549  O   ILE A  69       3.538  -9.756   8.936  1.00 46.50           O  
ATOM    550  CB  ILE A  69       1.712 -12.119   7.957  1.00 46.06           C  
ATOM    551  CG1 ILE A  69       1.819 -11.850   6.449  1.00 46.43           C  
ATOM    552  CG2 ILE A  69       0.712 -11.125   8.631  1.00 44.40           C  
ATOM    553  CD1 ILE A  69       0.477 -11.713   5.704  1.00 43.86           C  
ATOM    554  N   VAL A  70       4.920 -10.819   7.549  1.00 46.46           N  
ATOM    555  CA  VAL A  70       5.611  -9.597   7.175  1.00 46.49           C  
ATOM    556  C   VAL A  70       5.771  -9.516   5.671  1.00 46.17           C  
ATOM    557  O   VAL A  70       6.075 -10.515   5.019  1.00 46.32           O  
ATOM    558  CB  VAL A  70       6.998  -9.435   7.857  1.00 47.11           C  
ATOM    559  CG1 VAL A  70       6.897  -9.435   9.397  1.00 47.80           C  
ATOM    560  CG2 VAL A  70       7.888 -10.492   7.430  1.00 47.90           C  
ATOM    561  N   GLY A  71       5.570  -8.326   5.121  1.00 46.09           N  
ATOM    562  CA  GLY A  71       5.797  -8.091   3.694  1.00 46.36           C  
ATOM    563  C   GLY A  71       6.770  -6.959   3.420  1.00 47.03           C  
ATOM    564  O   GLY A  71       6.882  -6.008   4.208  1.00 46.91           O  
ATOM    565  N   GLU A  72       7.501  -7.087   2.314  1.00 47.24           N  
ATOM    566  CA  GLU A  72       8.379  -6.042   1.816  1.00 48.14           C  
ATOM    567  C   GLU A  72       8.523  -6.254   0.314  1.00 48.30           C  
ATOM    568  O   GLU A  72       8.611  -7.401  -0.139  1.00 48.93           O  
ATOM    569  CB  GLU A  72       9.736  -6.081   2.515  1.00 47.55           C  
ATOM    570  CG  GLU A  72      10.676  -4.953   2.095  1.00 48.03           C  
ATOM    571  CD  GLU A  72      12.037  -4.999   2.792  1.00 50.57           C  
ATOM    572  OE1 GLU A  72      12.509  -6.102   3.159  1.00 53.73           O  
ATOM    573  OE2 GLU A  72      12.650  -3.920   2.984  1.00 56.09           O  
ATOM    574  N   GLY A  73       8.522  -5.164  -0.461  1.00 48.62           N  
ATOM    575  CA  GLY A  73       8.572  -5.244  -1.933  1.00 48.68           C  
ATOM    576  C   GLY A  73       7.522  -6.209  -2.482  1.00 49.13           C  
ATOM    577  O   GLY A  73       6.334  -6.091  -2.174  1.00 48.99           O  
ATOM    578  N   ASP A  74       7.967  -7.189  -3.260  1.00 49.19           N  
ATOM    579  CA  ASP A  74       7.076  -8.180  -3.825  1.00 49.95           C  
ATOM    580  C   ASP A  74       6.983  -9.496  -3.002  1.00 49.64           C  
ATOM    581  O   ASP A  74       6.313 -10.441  -3.419  1.00 49.52           O  
ATOM    582  CB  ASP A  74       7.440  -8.450  -5.291  1.00 50.69           C  
ATOM    583  CG  ASP A  74       8.901  -8.870  -5.483  1.00 53.68           C  
ATOM    584  OD1 ASP A  74       9.711  -8.824  -4.516  1.00 57.21           O  
ATOM    585  OD2 ASP A  74       9.249  -9.254  -6.626  1.00 56.54           O  
ATOM    586  N   ARG A  75       7.608  -9.542  -1.824  1.00 48.55           N  
ATOM    587  CA  ARG A  75       7.661 -10.787  -1.051  1.00 47.60           C  
ATOM    588  C   ARG A  75       6.833 -10.743   0.233  1.00 46.43           C  
ATOM    589  O   ARG A  75       6.694  -9.698   0.865  1.00 45.77           O  
ATOM    590  CB  ARG A  75       9.122 -11.165  -0.753  1.00 47.81           C  
ATOM    591  CG  ARG A  75       9.997 -10.962  -1.970  1.00 51.16           C  
ATOM    592  CD  ARG A  75      11.450 -11.263  -1.772  1.00 54.82           C  
ATOM    593  NE  ARG A  75      11.680 -12.685  -1.970  1.00 58.13           N  
ATOM    594  CZ  ARG A  75      12.277 -13.225  -3.022  1.00 58.41           C  
ATOM    595  NH1 ARG A  75      12.736 -12.469  -4.009  1.00 57.41           N  
ATOM    596  NH2 ARG A  75      12.422 -14.540  -3.064  1.00 60.88           N  
ATOM    597  N   VAL A  76       6.278 -11.883   0.608  1.00 45.41           N  
ATOM    598  CA  VAL A  76       5.625 -12.024   1.901  1.00 45.39           C  
ATOM    599  C   VAL A  76       6.055 -13.345   2.552  1.00 45.90           C  
ATOM    600  O   VAL A  76       6.167 -14.365   1.874  1.00 45.42           O  
ATOM    601  CB  VAL A  76       4.079 -12.020   1.764  1.00 45.15           C  
ATOM    602  CG1 VAL A  76       3.420 -12.200   3.121  1.00 43.29           C  
ATOM    603  CG2 VAL A  76       3.607 -10.740   1.101  1.00 44.97           C  
HETATM  604  N   MSE A  77       6.268 -13.330   3.860  1.00 46.20           N  
HETATM  605  CA  MSE A  77       6.534 -14.555   4.588  1.00 48.06           C  
HETATM  606  C   MSE A  77       5.510 -14.716   5.699  1.00 46.95           C  
HETATM  607  O   MSE A  77       5.087 -13.725   6.304  1.00 47.00           O  
HETATM  608  CB  MSE A  77       7.951 -14.551   5.156  1.00 47.11           C  
HETATM  609  CG  MSE A  77       9.069 -14.664   4.126  1.00 47.61           C  
HETATM  610 SE   MSE A  77      10.818 -14.855   5.056  1.00 56.83          SE  
HETATM  611  CE  MSE A  77      12.034 -14.274   3.665  1.00 49.47           C  
ATOM    612  N   LEU A  78       5.103 -15.956   5.966  1.00 46.62           N  
ATOM    613  CA  LEU A  78       4.157 -16.244   7.057  1.00 46.94           C  
ATOM    614  C   LEU A  78       4.623 -17.388   7.930  1.00 47.22           C  
ATOM    615  O   LEU A  78       5.310 -18.302   7.467  1.00 47.88           O  
ATOM    616  CB  LEU A  78       2.789 -16.616   6.517  1.00 47.17           C  
ATOM    617  CG  LEU A  78       2.031 -15.545   5.716  1.00 48.13           C  
ATOM    618  CD1 LEU A  78       2.384 -15.580   4.239  1.00 45.72           C  
ATOM    619  CD2 LEU A  78       0.538 -15.766   5.898  1.00 48.91           C  
ATOM    620  N   ARG A  79       4.287 -17.301   9.206  1.00 46.80           N  
ATOM    621  CA  ARG A  79       4.404 -18.423  10.113  1.00 46.17           C  
ATOM    622  C   ARG A  79       3.001 -18.802  10.508  1.00 46.25           C  
ATOM    623  O   ARG A  79       2.246 -17.962  11.022  1.00 46.84           O  
ATOM    624  CB  ARG A  79       5.185 -18.068  11.361  1.00 45.47           C  
ATOM    625  CG  ARG A  79       5.169 -19.185  12.392  1.00 44.50           C  
ATOM    626  CD  ARG A  79       6.237 -18.996  13.432  1.00 44.34           C  
ATOM    627  NE  ARG A  79       6.042 -17.740  14.153  1.00 45.17           N  
ATOM    628  CZ  ARG A  79       5.410 -17.625  15.318  1.00 44.63           C  
ATOM    629  NH1 ARG A  79       4.904 -18.702  15.913  1.00 41.76           N  
ATOM    630  NH2 ARG A  79       5.298 -16.425  15.881  1.00 44.97           N  
ATOM    631  N   ILE A  80       2.664 -20.061  10.260  1.00 45.84           N  
ATOM    632  CA  ILE A  80       1.318 -20.569  10.452  1.00 45.34           C  
ATOM    633  C   ILE A  80       1.357 -21.848  11.283  1.00 45.94           C  
ATOM    634  O   ILE A  80       2.106 -22.771  10.967  1.00 45.06           O  
ATOM    635  CB  ILE A  80       0.657 -20.892   9.107  1.00 44.89           C  
ATOM    636  CG1 ILE A  80       0.879 -19.762   8.116  1.00 43.32           C  
ATOM    637  CG2 ILE A  80      -0.819 -21.152   9.302  1.00 45.45           C  
ATOM    638  CD1 ILE A  80       0.017 -19.832   6.881  1.00 39.40           C  
ATOM    639  N   THR A  81       0.559 -21.875  12.349  1.00 46.79           N  
ATOM    640  CA  THR A  81       0.335 -23.078  13.133  1.00 47.95           C  
ATOM    641  C   THR A  81      -0.861 -23.845  12.540  1.00 48.76           C  
ATOM    642  O   THR A  81      -1.948 -23.258  12.291  1.00 48.69           O  
ATOM    643  CB  THR A  81       0.079 -22.749  14.633  1.00 48.07           C  
ATOM    644  OG1 THR A  81       1.223 -22.084  15.175  1.00 51.08           O  
ATOM    645  CG2 THR A  81      -0.089 -24.011  15.457  1.00 48.19           C  
ATOM    646  N   CYS A  82      -0.654 -25.146  12.311  1.00 48.46           N  
ATOM    647  CA  CYS A  82      -1.680 -26.019  11.760  1.00 48.67           C  
ATOM    648  C   CYS A  82      -2.137 -27.039  12.787  1.00 48.67           C  
ATOM    649  O   CYS A  82      -1.321 -27.556  13.580  1.00 49.10           O  
ATOM    650  CB  CYS A  82      -1.109 -26.779  10.586  1.00 48.86           C  
ATOM    651  SG  CYS A  82      -0.610 -25.728   9.219  1.00 52.42           S  
ATOM    652  N   SER A  83      -3.426 -27.369  12.771  1.00 47.39           N  
ATOM    653  CA  SER A  83      -3.885 -28.441  13.640  1.00 46.81           C  
ATOM    654  C   SER A  83      -5.019 -29.164  12.974  1.00 45.95           C  
ATOM    655  O   SER A  83      -5.736 -28.574  12.198  1.00 45.60           O  
ATOM    656  CB  SER A  83      -4.330 -27.881  14.997  1.00 46.48           C  
ATOM    657  OG  SER A  83      -5.323 -26.909  14.773  1.00 47.82           O  
ATOM    658  N   ALA A  84      -5.195 -30.441  13.289  1.00 45.68           N  
ATOM    659  CA  ALA A  84      -6.208 -31.231  12.625  1.00 45.29           C  
ATOM    660  C   ALA A  84      -6.365 -32.559  13.319  1.00 45.70           C  
ATOM    661  O   ALA A  84      -5.466 -33.006  14.054  1.00 46.36           O  
ATOM    662  CB  ALA A  84      -5.770 -31.495  11.192  1.00 45.78           C  
ATOM    663  N   THR A  85      -7.490 -33.214  13.034  1.00 45.28           N  
ATOM    664  CA  THR A  85      -7.713 -34.567  13.437  1.00 44.28           C  
ATOM    665  C   THR A  85      -7.599 -35.392  12.203  1.00 44.02           C  
ATOM    666  O   THR A  85      -8.189 -35.080  11.159  1.00 44.08           O  
ATOM    667  CB  THR A  85      -9.063 -34.710  14.091  1.00 44.14           C  
ATOM    668  OG1 THR A  85      -9.215 -33.628  15.011  1.00 47.17           O  
ATOM    669  CG2 THR A  85      -9.124 -35.990  14.918  1.00 44.42           C  
ATOM    670  N   HIS A  86      -6.790 -36.442  12.300  1.00 43.84           N  
ATOM    671  CA  HIS A  86      -6.517 -37.286  11.145  1.00 43.16           C  
ATOM    672  C   HIS A  86      -7.634 -38.334  10.972  1.00 43.35           C  
ATOM    673  O   HIS A  86      -7.624 -39.391  11.622  1.00 43.04           O  
ATOM    674  CB  HIS A  86      -5.128 -37.925  11.299  1.00 42.65           C  
ATOM    675  CG  HIS A  86      -4.683 -38.695  10.098  1.00 43.44           C  
ATOM    676  ND1 HIS A  86      -3.713 -39.667  10.161  1.00 45.78           N  
ATOM    677  CD2 HIS A  86      -5.098 -38.659   8.808  1.00 43.50           C  
ATOM    678  CE1 HIS A  86      -3.528 -40.179   8.957  1.00 45.32           C  
ATOM    679  NE2 HIS A  86      -4.365 -39.593   8.122  1.00 45.01           N  
ATOM    680  N   GLN A  87      -8.596 -38.030  10.100  1.00 44.29           N  
ATOM    681  CA  GLN A  87      -9.791 -38.860   9.946  1.00 45.32           C  
ATOM    682  C   GLN A  87      -9.983 -39.479   8.582  1.00 46.41           C  
ATOM    683  O   GLN A  87     -10.725 -40.477   8.470  1.00 47.21           O  
ATOM    684  CB  GLN A  87     -11.059 -38.124  10.396  1.00 44.90           C  
ATOM    685  CG  GLN A  87     -10.991 -37.709  11.870  1.00 45.84           C  
ATOM    686  CD  GLN A  87     -12.340 -37.304  12.426  1.00 46.87           C  
ATOM    687  OE1 GLN A  87     -12.908 -36.278  12.026  1.00 46.59           O  
ATOM    688  NE2 GLN A  87     -12.872 -38.117  13.347  1.00 44.32           N  
ATOM    689  N   GLY A  88      -9.323 -38.927   7.550  1.00 46.68           N  
ATOM    690  CA  GLY A  88      -9.294 -39.566   6.209  1.00 46.17           C  
ATOM    691  C   GLY A  88      -7.884 -40.000   5.808  1.00 46.98           C  
ATOM    692  O   GLY A  88      -6.929 -39.643   6.478  1.00 47.39           O  
ATOM    693  N   VAL A  89      -7.748 -40.764   4.719  1.00 47.20           N  
ATOM    694  CA  VAL A  89      -6.455 -41.186   4.211  1.00 47.11           C  
ATOM    695  C   VAL A  89      -5.586 -39.961   3.911  1.00 47.94           C  
ATOM    696  O   VAL A  89      -6.048 -39.002   3.285  1.00 48.74           O  
ATOM    697  CB  VAL A  89      -6.642 -42.066   2.927  1.00 47.55           C  
ATOM    698  CG1 VAL A  89      -5.319 -42.442   2.293  1.00 46.19           C  
ATOM    699  CG2 VAL A  89      -7.417 -43.345   3.261  1.00 47.56           C  
ATOM    700  N   PHE A  90      -4.327 -39.963   4.351  1.00 47.96           N  
ATOM    701  CA  PHE A  90      -3.399 -38.916   3.896  1.00 47.51           C  
ATOM    702  C   PHE A  90      -2.198 -39.502   3.180  1.00 47.55           C  
ATOM    703  O   PHE A  90      -1.440 -40.263   3.776  1.00 47.22           O  
ATOM    704  CB  PHE A  90      -2.920 -38.049   5.038  1.00 47.36           C  
ATOM    705  CG  PHE A  90      -2.103 -36.875   4.584  1.00 48.06           C  
ATOM    706  CD1 PHE A  90      -2.664 -35.899   3.757  1.00 48.20           C  
ATOM    707  CD2 PHE A  90      -0.781 -36.746   4.962  1.00 49.61           C  
ATOM    708  CE1 PHE A  90      -1.923 -34.807   3.322  1.00 46.27           C  
ATOM    709  CE2 PHE A  90      -0.022 -35.660   4.543  1.00 48.30           C  
ATOM    710  CZ  PHE A  90      -0.602 -34.685   3.714  1.00 47.83           C  
HETATM  711  N   MSE A  91      -2.035 -39.158   1.899  1.00 47.62           N  
HETATM  712  CA  MSE A  91      -0.990 -39.745   1.040  1.00 47.35           C  
HETATM  713  C   MSE A  91      -0.796 -41.245   1.249  1.00 46.67           C  
HETATM  714  O   MSE A  91       0.331 -41.684   1.472  1.00 46.79           O  
HETATM  715  CB  MSE A  91       0.358 -39.040   1.251  1.00 47.76           C  
HETATM  716  CG  MSE A  91       0.322 -37.511   1.134  1.00 52.93           C  
HETATM  717 SE   MSE A  91      -0.136 -36.859  -0.705  1.00 67.32          SE  
HETATM  718  CE  MSE A  91       1.394 -37.767  -1.794  1.00 61.74           C  
ATOM    719  N   GLY A  92      -1.869 -42.037   1.177  1.00 46.24           N  
ATOM    720  CA  GLY A  92      -1.778 -43.493   1.404  1.00 45.13           C  
ATOM    721  C   GLY A  92      -1.800 -43.925   2.880  1.00 45.82           C  
ATOM    722  O   GLY A  92      -1.941 -45.119   3.177  1.00 46.02           O  
ATOM    723  N   ILE A  93      -1.647 -42.976   3.816  1.00 44.83           N  
ATOM    724  CA  ILE A  93      -1.652 -43.316   5.229  1.00 44.07           C  
ATOM    725  C   ILE A  93      -3.081 -43.382   5.771  1.00 44.12           C  
ATOM    726  O   ILE A  93      -3.835 -42.389   5.775  1.00 43.81           O  
ATOM    727  CB  ILE A  93      -0.796 -42.365   6.118  1.00 44.54           C  
ATOM    728  CG1 ILE A  93       0.629 -42.214   5.561  1.00 43.94           C  
ATOM    729  CG2 ILE A  93      -0.756 -42.888   7.577  1.00 42.14           C  
ATOM    730  CD1 ILE A  93       1.343 -40.934   6.082  1.00 43.45           C  
ATOM    731  N   ALA A  94      -3.429 -44.581   6.214  1.00 43.64           N  
ATOM    732  CA  ALA A  94      -4.703 -44.862   6.826  1.00 43.64           C  
ATOM    733  C   ALA A  94      -4.899 -43.925   8.039  1.00 43.73           C  
ATOM    734  O   ALA A  94      -3.948 -43.681   8.799  1.00 43.10           O  
ATOM    735  CB  ALA A  94      -4.739 -46.333   7.245  1.00 42.66           C  
ATOM    736  N   PRO A  95      -6.134 -43.411   8.227  1.00 43.52           N  
ATOM    737  CA  PRO A  95      -6.437 -42.442   9.283  1.00 43.59           C  
ATOM    738  C   PRO A  95      -6.172 -43.034  10.667  1.00 43.50           C  
ATOM    739  O   PRO A  95      -6.559 -44.179  10.909  1.00 43.33           O  
ATOM    740  CB  PRO A  95      -7.937 -42.184   9.107  1.00 43.95           C  
ATOM    741  CG  PRO A  95      -8.462 -43.348   8.322  1.00 43.92           C  
ATOM    742  CD  PRO A  95      -7.328 -43.780   7.450  1.00 43.45           C  
ATOM    743  N   THR A  96      -5.502 -42.262  11.542  1.00 43.30           N  
ATOM    744  CA  THR A  96      -5.092 -42.721  12.891  1.00 43.37           C  
ATOM    745  C   THR A  96      -6.015 -42.232  14.001  1.00 42.90           C  
ATOM    746  O   THR A  96      -6.005 -42.799  15.081  1.00 41.51           O  
ATOM    747  CB  THR A  96      -3.679 -42.210  13.287  1.00 43.33           C  
ATOM    748  OG1 THR A  96      -3.661 -40.773  13.213  1.00 45.55           O  
ATOM    749  CG2 THR A  96      -2.604 -42.767  12.382  1.00 44.58           C  
ATOM    750  N   GLY A  97      -6.767 -41.153  13.732  1.00 43.09           N  
ATOM    751  CA  GLY A  97      -7.673 -40.572  14.715  1.00 43.31           C  
ATOM    752  C   GLY A  97      -6.987 -39.573  15.613  1.00 44.29           C  
ATOM    753  O   GLY A  97      -7.623 -38.940  16.447  1.00 44.74           O  
ATOM    754  N   ARG A  98      -5.682 -39.401  15.446  1.00 45.17           N  
ATOM    755  CA  ARG A  98      -4.939 -38.535  16.347  1.00 45.42           C  
ATOM    756  C   ARG A  98      -5.048 -37.049  16.034  1.00 45.52           C  
ATOM    757  O   ARG A  98      -5.297 -36.653  14.901  1.00 44.96           O  
ATOM    758  CB  ARG A  98      -3.489 -38.987  16.425  1.00 46.30           C  
ATOM    759  CG  ARG A  98      -3.308 -40.225  17.304  1.00 46.19           C  
ATOM    760  CD  ARG A  98      -1.882 -40.323  17.801  0.50 47.12           C  
ATOM    761  NE  ARG A  98      -1.780 -40.666  19.221  0.50 46.48           N  
ATOM    762  CZ  ARG A  98      -1.927 -39.788  20.211  0.50 46.58           C  
ATOM    763  NH1 ARG A  98      -2.213 -38.517  19.946  0.50 46.30           N  
ATOM    764  NH2 ARG A  98      -1.796 -40.183  21.469  0.50 46.12           N  
ATOM    765  N   LYS A  99      -4.946 -36.242  17.086  1.00 46.45           N  
ATOM    766  CA  LYS A  99      -4.868 -34.803  16.962  1.00 47.39           C  
ATOM    767  C   LYS A  99      -3.415 -34.504  16.547  1.00 47.79           C  
ATOM    768  O   LYS A  99      -2.469 -34.899  17.246  1.00 47.04           O  
ATOM    769  CB  LYS A  99      -5.228 -34.117  18.293  1.00 47.17           C  
ATOM    770  CG  LYS A  99      -5.275 -32.575  18.234  1.00 49.53           C  
ATOM    771  CD  LYS A  99      -6.649 -32.047  17.768  1.00 55.81           C  
ATOM    772  CE  LYS A  99      -6.540 -30.838  16.816  1.00 61.45           C  
ATOM    773  NZ  LYS A  99      -6.719 -29.467  17.467  1.00 63.33           N  
ATOM    774  N   VAL A 100      -3.256 -33.821  15.411  1.00 48.17           N  
ATOM    775  CA  VAL A 100      -1.938 -33.514  14.884  1.00 48.66           C  
ATOM    776  C   VAL A 100      -1.728 -32.008  14.709  1.00 49.09           C  
ATOM    777  O   VAL A 100      -2.650 -31.279  14.295  1.00 49.63           O  
ATOM    778  CB  VAL A 100      -1.619 -34.291  13.550  1.00 49.30           C  
ATOM    779  CG1 VAL A 100      -1.687 -35.815  13.758  1.00 49.99           C  
ATOM    780  CG2 VAL A 100      -2.510 -33.882  12.386  1.00 46.77           C  
ATOM    781  N   ARG A 101      -0.510 -31.563  15.036  1.00 48.78           N  
ATOM    782  CA  ARG A 101      -0.089 -30.161  14.942  1.00 48.25           C  
ATOM    783  C   ARG A 101       1.296 -30.067  14.319  1.00 47.37           C  
ATOM    784  O   ARG A 101       2.186 -30.871  14.612  1.00 46.96           O  
ATOM    785  CB  ARG A 101      -0.009 -29.524  16.329  1.00 47.94           C  
ATOM    786  CG  ARG A 101      -1.314 -29.491  17.057  1.00 51.99           C  
ATOM    787  CD  ARG A 101      -1.207 -28.762  18.379  1.00 56.15           C  
ATOM    788  NE  ARG A 101      -1.770 -29.570  19.462  1.00 60.83           N  
ATOM    789  CZ  ARG A 101      -3.074 -29.738  19.709  1.00 63.85           C  
ATOM    790  NH1 ARG A 101      -4.011 -29.161  18.947  1.00 65.35           N  
ATOM    791  NH2 ARG A 101      -3.453 -30.485  20.738  1.00 63.84           N  
ATOM    792  N   TRP A 102       1.490 -29.052  13.501  1.00 46.45           N  
ATOM    793  CA  TRP A 102       2.806 -28.716  13.028  1.00 46.61           C  
ATOM    794  C   TRP A 102       2.843 -27.230  12.724  1.00 46.87           C  
ATOM    795  O   TRP A 102       1.818 -26.556  12.704  1.00 46.88           O  
ATOM    796  CB  TRP A 102       3.190 -29.558  11.793  1.00 46.18           C  
ATOM    797  CG  TRP A 102       2.327 -29.308  10.644  1.00 45.82           C  
ATOM    798  CD1 TRP A 102       2.535 -28.404   9.660  1.00 46.00           C  
ATOM    799  CD2 TRP A 102       1.085 -29.954  10.344  1.00 48.30           C  
ATOM    800  NE1 TRP A 102       1.497 -28.429   8.753  1.00 46.21           N  
ATOM    801  CE2 TRP A 102       0.590 -29.369   9.144  1.00 46.69           C  
ATOM    802  CE3 TRP A 102       0.328 -30.970  10.972  1.00 48.21           C  
ATOM    803  CZ2 TRP A 102      -0.628 -29.755   8.557  1.00 46.83           C  
ATOM    804  CZ3 TRP A 102      -0.895 -31.359  10.382  1.00 47.21           C  
ATOM    805  CH2 TRP A 102      -1.354 -30.749   9.182  1.00 46.95           C  
ATOM    806  N   THR A 103       4.038 -26.724  12.492  1.00 47.34           N  
ATOM    807  CA  THR A 103       4.230 -25.347  12.111  1.00 47.72           C  
ATOM    808  C   THR A 103       4.646 -25.279  10.631  1.00 48.28           C  
ATOM    809  O   THR A 103       5.485 -26.038  10.142  1.00 47.78           O  
ATOM    810  CB  THR A 103       5.213 -24.686  13.075  1.00 47.41           C  
ATOM    811  OG1 THR A 103       4.533 -24.463  14.334  1.00 49.71           O  
ATOM    812  CG2 THR A 103       5.720 -23.377  12.526  1.00 46.41           C  
ATOM    813  N   TYR A 104       4.005 -24.387   9.922  1.00 49.71           N  
ATOM    814  CA  TYR A 104       4.165 -24.285   8.493  1.00 51.97           C  
ATOM    815  C   TYR A 104       4.577 -22.860   8.111  1.00 52.33           C  
ATOM    816  O   TYR A 104       3.921 -21.871   8.484  1.00 51.90           O  
ATOM    817  CB  TYR A 104       2.852 -24.657   7.829  1.00 53.25           C  
ATOM    818  CG  TYR A 104       2.817 -24.405   6.356  1.00 55.69           C  
ATOM    819  CD1 TYR A 104       3.664 -25.091   5.499  1.00 58.91           C  
ATOM    820  CD2 TYR A 104       1.896 -23.538   5.805  1.00 57.25           C  
ATOM    821  CE1 TYR A 104       3.621 -24.891   4.137  1.00 58.12           C  
ATOM    822  CE2 TYR A 104       1.855 -23.323   4.455  1.00 58.59           C  
ATOM    823  CZ  TYR A 104       2.726 -24.000   3.626  1.00 57.86           C  
ATOM    824  OH  TYR A 104       2.695 -23.799   2.252  1.00 60.27           O  
ATOM    825  N   LEU A 105       5.674 -22.775   7.370  1.00 52.10           N  
ATOM    826  CA  LEU A 105       6.304 -21.509   7.059  1.00 52.07           C  
ATOM    827  C   LEU A 105       6.330 -21.289   5.552  1.00 51.76           C  
ATOM    828  O   LEU A 105       6.742 -22.153   4.814  1.00 51.96           O  
ATOM    829  CB  LEU A 105       7.690 -21.494   7.689  1.00 51.89           C  
ATOM    830  CG  LEU A 105       7.531 -21.759   9.201  1.00 53.61           C  
ATOM    831  CD1 LEU A 105       8.334 -23.008   9.705  1.00 53.82           C  
ATOM    832  CD2 LEU A 105       7.808 -20.498  10.055  1.00 52.83           C  
ATOM    833  N   GLU A 106       5.846 -20.140   5.105  1.00 51.93           N  
ATOM    834  CA  GLU A 106       5.651 -19.855   3.681  1.00 52.19           C  
ATOM    835  C   GLU A 106       6.396 -18.596   3.230  1.00 51.05           C  
ATOM    836  O   GLU A 106       6.273 -17.563   3.860  1.00 51.38           O  
ATOM    837  CB  GLU A 106       4.181 -19.573   3.442  1.00 52.21           C  
ATOM    838  CG  GLU A 106       3.409 -20.621   2.714  1.00 57.33           C  
ATOM    839  CD  GLU A 106       2.040 -20.089   2.303  1.00 64.35           C  
ATOM    840  OE1 GLU A 106       1.580 -19.133   2.966  1.00 68.08           O  
ATOM    841  OE2 GLU A 106       1.417 -20.592   1.326  1.00 66.67           O  
ATOM    842  N   GLU A 107       7.126 -18.668   2.127  1.00 49.63           N  
ATOM    843  CA  GLU A 107       7.528 -17.461   1.432  1.00 47.73           C  
ATOM    844  C   GLU A 107       6.898 -17.390   0.049  1.00 46.69           C  
ATOM    845  O   GLU A 107       7.027 -18.311  -0.734  1.00 46.64           O  
ATOM    846  CB  GLU A 107       9.045 -17.351   1.329  1.00 47.75           C  
ATOM    847  CG  GLU A 107       9.474 -16.101   0.577  1.00 47.72           C  
ATOM    848  CD  GLU A 107      10.969 -15.885   0.567  1.00 48.49           C  
ATOM    849  OE1 GLU A 107      11.711 -16.766   1.061  1.00 48.65           O  
ATOM    850  OE2 GLU A 107      11.410 -14.824   0.063  1.00 48.19           O  
ATOM    851  N   LEU A 108       6.236 -16.275  -0.248  1.00 45.79           N  
ATOM    852  CA  LEU A 108       5.651 -16.017  -1.552  1.00 44.66           C  
ATOM    853  C   LEU A 108       6.272 -14.776  -2.209  1.00 45.10           C  
ATOM    854  O   LEU A 108       6.562 -13.785  -1.526  1.00 44.59           O  
ATOM    855  CB  LEU A 108       4.156 -15.803  -1.405  1.00 44.20           C  
ATOM    856  CG  LEU A 108       3.290 -16.915  -0.791  1.00 45.13           C  
ATOM    857  CD1 LEU A 108       3.338 -16.818   0.701  1.00 44.92           C  
ATOM    858  CD2 LEU A 108       1.817 -16.814  -1.210  1.00 43.84           C  
ATOM    859  N   ARG A 109       6.474 -14.834  -3.528  1.00 45.29           N  
ATOM    860  CA  ARG A 109       6.794 -13.652  -4.320  1.00 45.92           C  
ATOM    861  C   ARG A 109       5.622 -13.388  -5.256  1.00 46.79           C  
ATOM    862  O   ARG A 109       5.056 -14.329  -5.818  1.00 47.74           O  
ATOM    863  CB  ARG A 109       8.102 -13.816  -5.112  1.00 45.62           C  
ATOM    864  CG  ARG A 109       8.569 -12.517  -5.795  1.00 45.88           C  
ATOM    865  CD  ARG A 109       9.986 -12.552  -6.393  1.00 46.07           C  
ATOM    866  NE  ARG A 109      10.046 -13.306  -7.647  1.00 49.74           N  
ATOM    867  CZ  ARG A 109       9.725 -12.841  -8.863  1.00 50.07           C  
ATOM    868  NH1 ARG A 109       9.297 -11.591  -9.036  1.00 49.41           N  
ATOM    869  NH2 ARG A 109       9.809 -13.647  -9.917  1.00 47.94           N  
ATOM    870  N   PHE A 110       5.271 -12.113  -5.437  1.00 47.40           N  
ATOM    871  CA  PHE A 110       4.087 -11.711  -6.198  1.00 48.14           C  
ATOM    872  C   PHE A 110       4.442 -10.883  -7.415  1.00 49.08           C  
ATOM    873  O   PHE A 110       5.338 -10.053  -7.356  1.00 49.90           O  
ATOM    874  CB  PHE A 110       3.162 -10.869  -5.323  1.00 47.35           C  
ATOM    875  CG  PHE A 110       2.311 -11.667  -4.398  1.00 47.07           C  
ATOM    876  CD1 PHE A 110       2.768 -12.012  -3.142  1.00 45.98           C  
ATOM    877  CD2 PHE A 110       1.016 -12.051  -4.774  1.00 47.81           C  
ATOM    878  CE1 PHE A 110       1.962 -12.740  -2.281  1.00 46.47           C  
ATOM    879  CE2 PHE A 110       0.202 -12.770  -3.908  1.00 44.25           C  
ATOM    880  CZ  PHE A 110       0.678 -13.122  -2.671  1.00 44.82           C  
ATOM    881  N   SER A 111       3.713 -11.083  -8.506  1.00 50.01           N  
ATOM    882  CA  SER A 111       3.885 -10.264  -9.702  1.00 50.74           C  
ATOM    883  C   SER A 111       3.260  -8.882  -9.462  1.00 51.50           C  
ATOM    884  O   SER A 111       2.463  -8.712  -8.537  1.00 51.68           O  
ATOM    885  CB  SER A 111       3.220 -10.957 -10.900  1.00 50.31           C  
ATOM    886  OG  SER A 111       1.816 -10.912 -10.771  1.00 49.94           O  
ATOM    887  N   GLU A 112       3.609  -7.902 -10.296  1.00 52.48           N  
ATOM    888  CA  GLU A 112       3.046  -6.551 -10.176  1.00 53.18           C  
ATOM    889  C   GLU A 112       1.508  -6.638 -10.178  1.00 53.53           C  
ATOM    890  O   GLU A 112       0.835  -5.997  -9.369  1.00 53.38           O  
ATOM    891  CB  GLU A 112       3.572  -5.650 -11.307  1.00 53.35           C  
ATOM    892  CG  GLU A 112       3.818  -4.181 -10.916  1.00 53.82           C  
ATOM    893  CD  GLU A 112       3.646  -3.543  -9.621  0.00 50.00           C  
ATOM    894  OE1 GLU A 112       2.924  -3.521  -8.599  0.00 50.00           O  
ATOM    895  OE2 GLU A 112       4.793  -3.052  -9.652  0.00 50.00           O  
ATOM    896  N   ALA A 113       0.970  -7.474 -11.066  1.00 54.05           N  
ATOM    897  CA  ALA A 113      -0.465  -7.794 -11.118  1.00 54.44           C  
ATOM    898  C   ALA A 113      -1.044  -8.497  -9.853  1.00 54.88           C  
ATOM    899  O   ALA A 113      -2.270  -8.661  -9.728  1.00 55.55           O  
ATOM    900  CB  ALA A 113      -0.758  -8.637 -12.373  1.00 54.53           C  
ATOM    901  N   GLY A 114      -0.187  -8.951  -8.940  1.00 54.20           N  
ATOM    902  CA  GLY A 114      -0.687  -9.493  -7.680  1.00 53.49           C  
ATOM    903  C   GLY A 114      -0.973 -10.980  -7.649  1.00 52.73           C  
ATOM    904  O   GLY A 114      -1.709 -11.446  -6.787  1.00 53.01           O  
ATOM    905  N   LYS A 115      -0.382 -11.729  -8.570  1.00 51.69           N  
ATOM    906  CA  LYS A 115      -0.502 -13.183  -8.542  1.00 50.76           C  
ATOM    907  C   LYS A 115       0.796 -13.843  -8.062  1.00 49.91           C  
ATOM    908  O   LYS A 115       1.888 -13.305  -8.298  1.00 50.41           O  
ATOM    909  CB  LYS A 115      -0.910 -13.699  -9.913  1.00 50.73           C  
ATOM    910  CG  LYS A 115      -2.162 -13.037 -10.429  1.00 51.11           C  
ATOM    911  CD  LYS A 115      -3.253 -14.025 -10.798  1.00 54.12           C  
ATOM    912  CE  LYS A 115      -4.306 -14.132  -9.686  1.00 55.82           C  
ATOM    913  NZ  LYS A 115      -5.668 -14.397 -10.243  1.00 54.67           N  
ATOM    914  N   VAL A 116       0.696 -14.984  -7.376  1.00 48.35           N  
ATOM    915  CA  VAL A 116       1.918 -15.680  -6.885  1.00 46.82           C  
ATOM    916  C   VAL A 116       2.777 -16.247  -8.021  1.00 46.46           C  
ATOM    917  O   VAL A 116       2.326 -17.119  -8.771  1.00 45.99           O  
ATOM    918  CB  VAL A 116       1.588 -16.831  -5.935  1.00 46.37           C  
ATOM    919  CG1 VAL A 116       2.855 -17.509  -5.482  1.00 45.57           C  
ATOM    920  CG2 VAL A 116       0.763 -16.343  -4.750  1.00 45.04           C  
ATOM    921  N   VAL A 117       4.016 -15.775  -8.137  1.00 46.15           N  
ATOM    922  CA  VAL A 117       4.927 -16.296  -9.182  1.00 46.11           C  
ATOM    923  C   VAL A 117       5.930 -17.315  -8.637  1.00 46.07           C  
ATOM    924  O   VAL A 117       6.458 -18.140  -9.391  1.00 45.83           O  
ATOM    925  CB  VAL A 117       5.690 -15.162  -9.959  1.00 46.06           C  
ATOM    926  CG1 VAL A 117       4.764 -14.471 -10.936  1.00 45.67           C  
ATOM    927  CG2 VAL A 117       6.314 -14.140  -8.998  1.00 44.92           C  
ATOM    928  N   GLU A 118       6.180 -17.255  -7.326  1.00 46.00           N  
ATOM    929  CA  GLU A 118       7.158 -18.124  -6.666  1.00 45.96           C  
ATOM    930  C   GLU A 118       6.726 -18.425  -5.233  1.00 45.95           C  
ATOM    931  O   GLU A 118       6.307 -17.529  -4.507  1.00 45.75           O  
ATOM    932  CB  GLU A 118       8.534 -17.456  -6.655  1.00 45.90           C  
ATOM    933  CG  GLU A 118       9.271 -17.464  -7.975  1.00 45.78           C  
ATOM    934  CD  GLU A 118      10.715 -17.006  -7.827  1.00 46.83           C  
ATOM    935  OE1 GLU A 118      10.951 -15.915  -7.275  1.00 47.27           O  
ATOM    936  OE2 GLU A 118      11.627 -17.742  -8.261  1.00 49.54           O  
ATOM    937  N   HIS A 119       6.862 -19.683  -4.823  1.00 46.32           N  
ATOM    938  CA  HIS A 119       6.399 -20.143  -3.521  1.00 46.77           C  
ATOM    939  C   HIS A 119       7.371 -21.144  -2.867  1.00 46.12           C  
ATOM    940  O   HIS A 119       7.724 -22.153  -3.469  1.00 46.23           O  
ATOM    941  CB  HIS A 119       5.005 -20.795  -3.668  1.00 47.60           C  
ATOM    942  CG  HIS A 119       4.500 -21.429  -2.412  1.00 50.27           C  
ATOM    943  ND1 HIS A 119       3.345 -21.016  -1.784  1.00 56.76           N  
ATOM    944  CD2 HIS A 119       5.014 -22.413  -1.638  1.00 54.00           C  
ATOM    945  CE1 HIS A 119       3.156 -21.733  -0.688  1.00 57.42           C  
ATOM    946  NE2 HIS A 119       4.156 -22.588  -0.576  1.00 57.72           N  
ATOM    947  N   TRP A 120       7.764 -20.889  -1.629  1.00 45.39           N  
ATOM    948  CA  TRP A 120       8.593 -21.832  -0.884  1.00 45.49           C  
ATOM    949  C   TRP A 120       7.901 -22.291   0.398  1.00 46.75           C  
ATOM    950  O   TRP A 120       7.353 -21.466   1.146  1.00 47.17           O  
ATOM    951  CB  TRP A 120       9.926 -21.213  -0.494  1.00 44.04           C  
ATOM    952  CG  TRP A 120      10.858 -20.695  -1.599  1.00 43.13           C  
ATOM    953  CD1 TRP A 120      12.033 -21.269  -1.998  1.00 41.17           C  
ATOM    954  CD2 TRP A 120      10.751 -19.452  -2.332  1.00 40.44           C  
ATOM    955  NE1 TRP A 120      12.646 -20.482  -2.949  1.00 41.46           N  
ATOM    956  CE2 TRP A 120      11.881 -19.366  -3.175  1.00 40.18           C  
ATOM    957  CE3 TRP A 120       9.804 -18.410  -2.358  1.00 41.75           C  
ATOM    958  CZ2 TRP A 120      12.094 -18.285  -4.055  1.00 40.99           C  
ATOM    959  CZ3 TRP A 120      10.000 -17.337  -3.240  1.00 41.40           C  
ATOM    960  CH2 TRP A 120      11.152 -17.284  -4.072  1.00 42.41           C  
ATOM    961  N   ASP A 121       7.932 -23.605   0.653  1.00 47.58           N  
ATOM    962  CA  ASP A 121       7.335 -24.215   1.850  0.50 47.52           C  
ATOM    964  C   ASP A 121       8.433 -24.681   2.779  1.00 47.56           C  
ATOM    965  O   ASP A 121       9.329 -25.414   2.339  1.00 48.37           O  
ATOM    966  CB  ASP A 121       6.515 -25.458   1.474  0.50 47.55           C  
ATOM    968  CG  ASP A 121       5.206 -25.128   0.785  0.50 48.09           C  
ATOM    970  OD1 ASP A 121       4.815 -25.876  -0.133  0.50 49.48           O  
ATOM    972  OD2 ASP A 121       4.558 -24.130   1.150  0.50 48.08           O  
ATOM    974  N   VAL A 122       8.355 -24.295   4.049  1.00 47.04           N  
ATOM    975  CA  VAL A 122       9.253 -24.809   5.073  1.00 46.66           C  
ATOM    976  C   VAL A 122       8.392 -25.350   6.200  1.00 46.39           C  
ATOM    977  O   VAL A 122       7.385 -24.755   6.542  1.00 47.32           O  
ATOM    978  CB  VAL A 122      10.191 -23.704   5.600  1.00 47.20           C  
ATOM    979  CG1 VAL A 122      11.091 -24.224   6.724  1.00 45.95           C  
ATOM    980  CG2 VAL A 122      11.034 -23.133   4.445  1.00 47.92           C  
ATOM    981  N   PHE A 123       8.773 -26.481   6.773  1.00 46.06           N  
ATOM    982  CA  PHE A 123       8.023 -27.069   7.865  1.00 45.86           C  
ATOM    983  C   PHE A 123       8.873 -27.122   9.111  1.00 46.21           C  
ATOM    984  O   PHE A 123      10.092 -27.379   9.047  1.00 45.73           O  
ATOM    985  CB  PHE A 123       7.581 -28.498   7.526  1.00 46.54           C  
ATOM    986  CG  PHE A 123       6.528 -28.576   6.466  1.00 46.24           C  
ATOM    987  CD1 PHE A 123       6.882 -28.674   5.124  1.00 47.19           C  
ATOM    988  CD2 PHE A 123       5.175 -28.542   6.815  1.00 47.51           C  
ATOM    989  CE1 PHE A 123       5.903 -28.724   4.131  1.00 48.10           C  
ATOM    990  CE2 PHE A 123       4.179 -28.587   5.844  1.00 48.27           C  
ATOM    991  CZ  PHE A 123       4.534 -28.678   4.495  1.00 47.88           C  
ATOM    992  N   ASN A 124       8.235 -26.842  10.248  1.00 46.42           N  
ATOM    993  CA  ASN A 124       8.798 -27.256  11.520  1.00 46.91           C  
ATOM    994  C   ASN A 124       7.886 -28.246  12.258  1.00 46.10           C  
ATOM    995  O   ASN A 124       6.697 -28.005  12.459  1.00 46.39           O  
ATOM    996  CB  ASN A 124       9.217 -26.074  12.394  1.00 47.32           C  
ATOM    997  CG  ASN A 124      10.023 -26.530  13.583  1.00 50.56           C  
ATOM    998  OD1 ASN A 124       9.459 -27.059  14.548  1.00 51.87           O  
ATOM    999  ND2 ASN A 124      11.365 -26.413  13.491  1.00 53.77           N  
ATOM   1000  N   PHE A 125       8.465 -29.369  12.639  1.00 45.85           N  
ATOM   1001  CA  PHE A 125       7.720 -30.507  13.139  1.00 45.39           C  
ATOM   1002  C   PHE A 125       7.835 -30.736  14.642  1.00 46.22           C  
ATOM   1003  O   PHE A 125       7.324 -31.749  15.144  1.00 46.52           O  
ATOM   1004  CB  PHE A 125       8.163 -31.750  12.394  1.00 44.18           C  
ATOM   1005  CG  PHE A 125       7.658 -31.819  10.987  1.00 43.66           C  
ATOM   1006  CD1 PHE A 125       6.284 -31.674  10.715  1.00 39.25           C  
ATOM   1007  CD2 PHE A 125       8.544 -32.057   9.927  1.00 41.20           C  
ATOM   1008  CE1 PHE A 125       5.796 -31.751   9.427  1.00 38.69           C  
ATOM   1009  CE2 PHE A 125       8.064 -32.124   8.610  1.00 40.10           C  
ATOM   1010  CZ  PHE A 125       6.690 -31.980   8.359  1.00 41.09           C  
ATOM   1011  N   SER A 126       8.493 -29.821  15.364  1.00 46.75           N  
ATOM   1012  CA  SER A 126       8.478 -29.858  16.846  1.00 47.98           C  
ATOM   1013  C   SER A 126       7.099 -30.192  17.454  1.00 48.17           C  
ATOM   1014  O   SER A 126       7.002 -31.111  18.244  1.00 47.91           O  
ATOM   1015  CB  SER A 126       8.943 -28.538  17.435  1.00 47.55           C  
ATOM   1016  OG  SER A 126      10.286 -28.364  17.126  1.00 48.50           O  
ATOM   1017  N   PRO A 127       6.041 -29.437  17.081  1.00 48.44           N  
ATOM   1018  CA  PRO A 127       4.717 -29.707  17.676  1.00 49.31           C  
ATOM   1019  C   PRO A 127       4.207 -31.124  17.426  1.00 50.39           C  
ATOM   1020  O   PRO A 127       3.523 -31.681  18.290  1.00 50.77           O  
ATOM   1021  CB  PRO A 127       3.807 -28.651  17.028  1.00 48.60           C  
ATOM   1022  CG  PRO A 127       4.763 -27.540  16.622  1.00 48.39           C  
ATOM   1023  CD  PRO A 127       5.998 -28.284  16.164  1.00 48.06           C  
ATOM   1024  N   LEU A 128       4.568 -31.710  16.284  1.00 51.45           N  
ATOM   1025  CA  LEU A 128       4.176 -33.071  15.943  1.00 52.52           C  
ATOM   1026  C   LEU A 128       4.791 -34.104  16.877  1.00 53.77           C  
ATOM   1027  O   LEU A 128       4.140 -35.090  17.227  1.00 54.39           O  
ATOM   1028  CB  LEU A 128       4.632 -33.402  14.531  1.00 52.59           C  
ATOM   1029  CG  LEU A 128       3.707 -34.108  13.541  1.00 53.64           C  
ATOM   1030  CD1 LEU A 128       4.534 -34.928  12.561  1.00 51.56           C  
ATOM   1031  CD2 LEU A 128       2.667 -34.970  14.243  1.00 53.67           C  
ATOM   1032  N   PHE A 129       6.050 -33.904  17.257  1.00 54.58           N  
ATOM   1033  CA  PHE A 129       6.773 -34.919  18.006  1.00 55.85           C  
ATOM   1034  C   PHE A 129       6.755 -34.647  19.512  1.00 57.73           C  
ATOM   1035  O   PHE A 129       7.048 -35.525  20.308  1.00 57.74           O  
ATOM   1036  CB  PHE A 129       8.210 -35.077  17.470  1.00 55.27           C  
ATOM   1037  CG  PHE A 129       8.276 -35.567  16.041  1.00 54.00           C  
ATOM   1038  CD1 PHE A 129       7.986 -36.902  15.728  1.00 53.32           C  
ATOM   1039  CD2 PHE A 129       8.607 -34.701  15.011  1.00 51.15           C  
ATOM   1040  CE1 PHE A 129       8.031 -37.359  14.408  1.00 52.16           C  
ATOM   1041  CE2 PHE A 129       8.652 -35.144  13.695  1.00 50.92           C  
ATOM   1042  CZ  PHE A 129       8.361 -36.472  13.388  1.00 52.70           C  
ATOM   1043  N   ARG A 130       6.415 -33.424  19.896  1.00 60.18           N  
ATOM   1044  CA  ARG A 130       6.121 -33.130  21.288  1.00 62.79           C  
ATOM   1045  C   ARG A 130       4.861 -33.913  21.732  1.00 64.12           C  
ATOM   1046  O   ARG A 130       4.874 -34.584  22.774  1.00 64.15           O  
ATOM   1047  CB  ARG A 130       5.940 -31.628  21.482  1.00 62.75           C  
ATOM   1048  CG  ARG A 130       6.015 -31.214  22.927  1.00 65.29           C  
ATOM   1049  CD  ARG A 130       6.085 -29.703  23.099  1.00 69.12           C  
ATOM   1050  NE  ARG A 130       5.038 -29.023  22.346  1.00 70.53           N  
ATOM   1051  CZ  ARG A 130       5.267 -28.118  21.400  1.00 72.26           C  
ATOM   1052  NH1 ARG A 130       6.522 -27.766  21.103  1.00 71.66           N  
ATOM   1053  NH2 ARG A 130       4.236 -27.565  20.760  1.00 71.72           N  
ATOM   1054  N   ASP A 131       3.805 -33.837  20.917  1.00 65.52           N  
ATOM   1055  CA  ASP A 131       2.555 -34.595  21.108  1.00 67.39           C  
ATOM   1056  C   ASP A 131       2.734 -36.108  20.959  1.00 68.13           C  
ATOM   1057  O   ASP A 131       2.828 -36.839  21.947  1.00 68.23           O  
ATOM   1058  CB  ASP A 131       1.489 -34.182  20.069  1.00 67.61           C  
ATOM   1059  CG  ASP A 131       1.034 -32.731  20.199  1.00 68.63           C  
ATOM   1060  OD1 ASP A 131       1.440 -32.030  21.154  1.00 70.24           O  
ATOM   1061  OD2 ASP A 131       0.256 -32.295  19.321  1.00 70.34           O  
ATOM   1062  N   LEU A 132       2.759 -36.555  19.698  1.00 69.06           N  
ATOM   1063  CA  LEU A 132       2.764 -37.978  19.326  1.00 69.54           C  
ATOM   1064  C   LEU A 132       3.981 -38.708  19.858  1.00 69.92           C  
ATOM   1065  O   LEU A 132       4.091 -39.924  19.725  1.00 70.21           O  
ATOM   1066  CB  LEU A 132       2.685 -38.142  17.806  1.00 69.30           C  
ATOM   1067  CG  LEU A 132       1.663 -37.304  17.028  1.00 69.89           C  
ATOM   1068  CD1 LEU A 132       1.538 -37.893  15.634  1.00 69.95           C  
ATOM   1069  CD2 LEU A 132       0.279 -37.219  17.710  1.00 69.20           C  
ATOM   1070  N   GLY A 133       4.894 -37.945  20.448  1.00 70.41           N  
ATOM   1071  CA  GLY A 133       5.988 -38.494  21.233  1.00 71.12           C  
ATOM   1072  C   GLY A 133       6.978 -39.347  20.470  1.00 71.51           C  
ATOM   1073  O   GLY A 133       7.535 -40.293  21.046  1.00 71.95           O  
ATOM   1074  N   VAL A 134       7.199 -39.022  19.190  1.00 71.36           N  
ATOM   1075  CA  VAL A 134       8.215 -39.699  18.354  1.00 71.36           C  
ATOM   1076  C   VAL A 134       7.808 -41.145  17.978  1.00 71.08           C  
ATOM   1077  O   VAL A 134       8.651 -42.045  17.870  1.00 70.84           O  
ATOM   1078  CB  VAL A 134       9.648 -39.649  19.023  1.00 71.55           C  
ATOM   1079  CG1 VAL A 134      10.742 -40.164  18.082  1.00 71.66           C  
ATOM   1080  CG2 VAL A 134       9.989 -38.220  19.515  1.00 72.11           C  
ATOM   1081  N   VAL A 135       6.509 -41.364  17.776  1.00 70.64           N  
ATOM   1082  CA  VAL A 135       6.017 -42.699  17.411  1.00 70.11           C  
ATOM   1083  C   VAL A 135       6.146 -42.902  15.882  1.00 69.34           C  
ATOM   1084  O   VAL A 135       6.348 -41.915  15.149  1.00 69.09           O  
ATOM   1085  CB  VAL A 135       4.542 -42.957  17.908  1.00 70.38           C  
ATOM   1086  CG1 VAL A 135       4.487 -43.146  19.430  1.00 70.40           C  
ATOM   1087  CG2 VAL A 135       3.576 -41.854  17.434  1.00 70.09           C  
ATOM   1088  N   PRO A 136       6.058 -44.175  15.401  1.00 68.28           N  
ATOM   1089  CA  PRO A 136       6.010 -44.456  13.953  1.00 67.18           C  
ATOM   1090  C   PRO A 136       5.047 -43.528  13.193  1.00 65.98           C  
ATOM   1091  O   PRO A 136       5.385 -43.043  12.108  1.00 65.37           O  
ATOM   1092  CB  PRO A 136       5.515 -45.907  13.891  1.00 67.21           C  
ATOM   1093  CG  PRO A 136       6.018 -46.520  15.147  1.00 67.69           C  
ATOM   1094  CD  PRO A 136       6.029 -45.421  16.196  1.00 68.15           C  
ATOM   1095  N   ASP A 137       3.874 -43.276  13.778  1.00 64.46           N  
ATOM   1096  CA  ASP A 137       2.879 -42.396  13.178  1.00 63.34           C  
ATOM   1097  C   ASP A 137       3.414 -40.990  12.868  1.00 62.13           C  
ATOM   1098  O   ASP A 137       3.184 -40.470  11.771  1.00 62.18           O  
ATOM   1099  CB  ASP A 137       1.601 -42.345  14.032  1.00 63.34           C  
ATOM   1100  CG  ASP A 137       0.790 -43.638  13.946  1.00 64.28           C  
ATOM   1101  OD1 ASP A 137       0.957 -44.378  12.951  1.00 63.75           O  
ATOM   1102  OD2 ASP A 137      -0.015 -43.919  14.870  1.00 65.31           O  
ATOM   1103  N   GLY A 138       4.133 -40.397  13.821  1.00 60.82           N  
ATOM   1104  CA  GLY A 138       4.696 -39.062  13.664  1.00 58.62           C  
ATOM   1105  C   GLY A 138       5.628 -39.036  12.479  1.00 57.59           C  
ATOM   1106  O   GLY A 138       5.576 -38.123  11.648  1.00 57.16           O  
ATOM   1107  N   LEU A 139       6.467 -40.065  12.394  1.00 56.68           N  
ATOM   1108  CA  LEU A 139       7.462 -40.174  11.329  1.00 55.62           C  
ATOM   1109  C   LEU A 139       6.806 -40.234   9.959  1.00 54.93           C  
ATOM   1110  O   LEU A 139       7.194 -39.489   9.070  1.00 54.43           O  
ATOM   1111  CB  LEU A 139       8.374 -41.389  11.547  1.00 55.65           C  
ATOM   1112  CG  LEU A 139       9.409 -41.389  12.683  1.00 55.58           C  
ATOM   1113  CD1 LEU A 139       9.768 -42.810  13.100  0.25 55.09           C  
ATOM   1114  CD2 LEU A 139      10.658 -40.609  12.290  0.25 55.59           C  
ATOM   1115  N   LYS A 140       5.794 -41.094   9.808  1.00 54.70           N  
ATOM   1116  CA  LYS A 140       5.106 -41.284   8.528  1.00 54.85           C  
ATOM   1117  C   LYS A 140       4.363 -40.015   8.098  1.00 54.24           C  
ATOM   1118  O   LYS A 140       4.385 -39.620   6.931  1.00 54.08           O  
ATOM   1119  CB  LYS A 140       4.163 -42.493   8.573  1.00 54.66           C  
ATOM   1120  CG  LYS A 140       4.892 -43.865   8.557  1.00 56.32           C  
ATOM   1121  CD  LYS A 140       3.973 -45.026   8.097  1.00 56.35           C  
ATOM   1122  CE  LYS A 140       3.282 -45.745   9.265  1.00 58.43           C  
ATOM   1123  NZ  LYS A 140       4.146 -46.825   9.884  1.00 57.19           N  
ATOM   1124  N   LEU A 141       3.742 -39.350   9.052  1.00 53.80           N  
ATOM   1125  CA  LEU A 141       2.995 -38.150   8.738  1.00 53.76           C  
ATOM   1126  C   LEU A 141       3.898 -36.973   8.387  1.00 53.27           C  
ATOM   1127  O   LEU A 141       3.623 -36.239   7.431  1.00 52.86           O  
ATOM   1128  CB  LEU A 141       2.095 -37.800   9.898  1.00 53.95           C  
ATOM   1129  CG  LEU A 141       0.752 -37.379   9.358  1.00 55.59           C  
ATOM   1130  CD1 LEU A 141      -0.335 -37.889  10.315  1.00 59.59           C  
ATOM   1131  CD2 LEU A 141       0.713 -35.880   9.224  1.00 55.83           C  
ATOM   1132  N   ALA A 142       4.973 -36.799   9.154  1.00 52.95           N  
ATOM   1133  CA  ALA A 142       5.957 -35.766   8.846  1.00 53.25           C  
ATOM   1134  C   ALA A 142       6.564 -36.001   7.476  1.00 53.48           C  
ATOM   1135  O   ALA A 142       6.757 -35.050   6.721  1.00 53.55           O  
ATOM   1136  CB  ALA A 142       7.032 -35.692   9.897  1.00 52.92           C  
ATOM   1137  N   ALA A 143       6.818 -37.261   7.135  1.00 53.43           N  
ATOM   1138  CA  ALA A 143       7.435 -37.547   5.845  1.00 54.57           C  
ATOM   1139  C   ALA A 143       6.475 -37.295   4.680  1.00 55.29           C  
ATOM   1140  O   ALA A 143       6.922 -36.975   3.578  1.00 55.26           O  
ATOM   1141  CB  ALA A 143       8.031 -38.966   5.790  1.00 54.12           C  
ATOM   1142  N   ALA A 144       5.166 -37.403   4.933  1.00 55.89           N  
ATOM   1143  CA  ALA A 144       4.168 -37.247   3.884  1.00 56.26           C  
ATOM   1144  C   ALA A 144       3.705 -35.797   3.726  1.00 57.40           C  
ATOM   1145  O   ALA A 144       3.203 -35.410   2.667  1.00 57.68           O  
ATOM   1146  CB  ALA A 144       2.995 -38.164   4.132  1.00 56.05           C  
ATOM   1147  N   LEU A 145       3.896 -34.981   4.741  1.00 58.10           N  
ATOM   1148  CA  LEU A 145       3.579 -33.579   4.641  1.00 58.58           C  
ATOM   1149  C   LEU A 145       4.589 -32.797   3.854  1.00 59.33           C  
ATOM   1150  O   LEU A 145       4.305 -31.719   3.393  1.00 59.39           O  
ATOM   1151  CB  LEU A 145       3.408 -32.954   6.015  1.00 58.31           C  
ATOM   1152  CG  LEU A 145       2.078 -33.046   6.753  1.00 58.30           C  
ATOM   1153  CD1 LEU A 145       2.277 -32.743   8.179  1.00 57.46           C  
ATOM   1154  CD2 LEU A 145       1.026 -32.177   6.183  1.00 56.86           C  
ATOM   1155  N   GLU A 146       5.776 -33.342   3.687  1.00 60.53           N  
ATOM   1156  CA  GLU A 146       6.832 -32.620   2.949  1.00 62.07           C  
ATOM   1157  C   GLU A 146       7.344 -33.275   1.649  1.00 62.79           C  
ATOM   1158  O   GLU A 146       7.085 -34.455   1.389  1.00 63.09           O  
ATOM   1159  CB  GLU A 146       7.999 -32.291   3.877  1.00 61.92           C  
ATOM   1160  CG  GLU A 146       8.614 -33.514   4.519  1.00 63.53           C  
ATOM   1161  CD  GLU A 146       9.926 -33.227   5.215  1.00 64.94           C  
ATOM   1162  OE1 GLU A 146      10.121 -32.068   5.654  1.00 65.33           O  
ATOM   1163  OE2 GLU A 146      10.746 -34.175   5.335  1.00 64.47           O  
ATOM   1164  N   HIS A 147       8.077 -32.498   0.845  1.00 64.07           N  
ATOM   1165  CA  HIS A 147       8.656 -32.962  -0.432  1.00 64.76           C  
ATOM   1166  C   HIS A 147       9.965 -33.753  -0.240  1.00 64.87           C  
ATOM   1167  O   HIS A 147      10.182 -34.813  -0.853  1.00 64.89           O  
ATOM   1168  CB  HIS A 147       8.855 -31.763  -1.403  1.00 64.58           C  
TER    1169      HIS A 147                                                      
END
MOLECULE T0475.pdb
ATOM     20  N   ASN     2       1.831  -2.392  -0.522  1.00  0.00
ATOM     21  HN  ASN     2       1.726  -2.331   0.453  1.00  0.00
ATOM     22  CA  ASN     2       2.075  -3.725  -1.109  1.00  0.00
ATOM     23  HA  ASN     2       2.284  -3.607  -2.174  1.00  0.00
ATOM     24  CB  ASN     2       3.299  -4.390  -0.422  1.00  0.00
ATOM     25  HB1 ASN     2       3.466  -5.372  -0.859  1.00  0.00
ATOM     26  HB2 ASN     2       3.089  -4.514   0.636  1.00  0.00
ATOM     27  CG  ASN     2       4.590  -3.576  -0.565  1.00  0.00
ATOM     28  OD1 ASN     2       5.324  -3.715  -1.546  1.00  0.00
ATOM     29  ND2 ASN     2       4.857  -2.700   0.401  1.00  0.00
ATOM     30 HD21 ASN     2       4.224  -2.628   1.148  1.00  0.00
ATOM     31 HD22 ASN     2       5.675  -2.167   0.331  1.00  0.00
ATOM     32  C   ASN     2       0.785  -4.553  -0.964  1.00  0.00
ATOM     33  O   ASN     2       0.810  -5.738  -0.618  1.00  0.00
ATOM     34  N   SER     3      -0.341  -3.891  -1.292  1.00  0.00
ATOM     35  HN  SER     3      -0.247  -3.002  -1.689  1.00  0.00
ATOM     36  CA  SER     3      -1.702  -4.409  -1.095  1.00  0.00
ATOM     37  HA  SER     3      -1.797  -4.700  -0.049  1.00  0.00
ATOM     38  CB  SER     3      -2.716  -3.279  -1.383  1.00  0.00
ATOM     39  HB1 SER     3      -2.599  -2.492  -0.645  1.00  0.00
ATOM     40  HB2 SER     3      -3.729  -3.660  -1.328  1.00  0.00
ATOM     41  OG  SER     3      -2.512  -2.719  -2.675  1.00  0.00
ATOM     42  HG  SER     3      -3.361  -2.595  -3.107  1.00  0.00
ATOM     43  C   SER     3      -1.979  -5.633  -1.981  1.00  0.00
ATOM     44  O   SER     3      -2.523  -6.626  -1.511  1.00  0.00
ATOM     45  N   GLU     4      -1.554  -5.549  -3.257  1.00  0.00
ATOM     46  HN  GLU     4      -1.122  -4.715  -3.539  1.00  0.00
ATOM     47  CA  GLU     4      -1.720  -6.638  -4.252  1.00  0.00
ATOM     48  HA  GLU     4      -2.760  -6.955  -4.203  1.00  0.00
ATOM     49  CB  GLU     4      -1.434  -6.132  -5.697  1.00  0.00
ATOM     50  HB1 GLU     4      -2.105  -5.307  -5.907  1.00  0.00
ATOM     51  HB2 GLU     4      -1.659  -6.934  -6.393  1.00  0.00
ATOM     52  CG  GLU     4       0.018  -5.661  -5.984  1.00  0.00
ATOM     53  HG1 GLU     4       0.166  -5.630  -7.063  1.00  0.00
ATOM     54  HG2 GLU     4       0.703  -6.396  -5.571  1.00  0.00
ATOM     55  CD  GLU     4       0.366  -4.277  -5.399  1.00  0.00
ATOM     56  OE1 GLU     4       0.009  -3.255  -6.022  1.00  0.00
ATOM     57  OE2 GLU     4       0.991  -4.208  -4.319  1.00  0.00
ATOM     58  C   GLU     4      -0.837  -7.869  -3.943  1.00  0.00
ATOM     59  O   GLU     4      -0.931  -8.886  -4.637  1.00  0.00
ATOM     60  N   ILE     5       0.041  -7.744  -2.937  1.00  0.00
ATOM     61  HN  ILE     5       0.146  -6.866  -2.519  1.00  0.00
ATOM     62  CA  ILE     5       0.867  -8.854  -2.432  1.00  0.00
ATOM     63  HA  ILE     5       0.966  -9.608  -3.214  1.00  0.00
ATOM     64  CB  ILE     5       2.303  -8.347  -2.025  1.00  0.00
ATOM     65  HB  ILE     5       2.196  -7.811  -1.085  1.00  0.00
ATOM     66  CG1 ILE     5       2.896  -7.353  -3.082  1.00  0.00
ATOM     67 HG11 ILE     5       3.865  -7.007  -2.738  1.00  0.00
ATOM     68 HG12 ILE     5       2.244  -6.502  -3.163  1.00  0.00
ATOM     69  CG2 ILE     5       3.271  -9.523  -1.775  1.00  0.00
ATOM     70 HG21 ILE     5       4.228  -9.142  -1.435  1.00  0.00
ATOM     71 HG22 ILE     5       3.417 -10.078  -2.691  1.00  0.00
ATOM     72 HG23 ILE     5       2.862 -10.182  -1.021  1.00  0.00
ATOM     73  CD1 ILE     5       3.082  -7.904  -4.488  1.00  0.00
ATOM     74 HD11 ILE     5       2.126  -8.218  -4.887  1.00  0.00
ATOM     75 HD12 ILE     5       3.755  -8.751  -4.459  1.00  0.00
ATOM     76 HD13 ILE     5       3.501  -7.137  -5.121  1.00  0.00
ATOM     77  C   ILE     5       0.167  -9.486  -1.207  1.00  0.00
ATOM     78  O   ILE     5       0.309 -10.683  -0.936  1.00  0.00
ATOM     79  N   GLU     6      -0.598  -8.649  -0.477  1.00  0.00
ATOM     80  HN  GLU     6      -0.624  -7.699  -0.730  1.00  0.00
ATOM     81  CA  GLU     6      -1.393  -9.075   0.691  1.00  0.00
ATOM     82  HA  GLU     6      -0.790  -9.767   1.280  1.00  0.00
ATOM     83  CB  GLU     6      -1.739  -7.844   1.574  1.00  0.00
ATOM     84  HB1 GLU     6      -2.373  -8.164   2.398  1.00  0.00
ATOM     85  HB2 GLU     6      -2.291  -7.131   0.971  1.00  0.00
ATOM     86  CG  GLU     6      -0.519  -7.120   2.167  1.00  0.00
ATOM     87  HG1 GLU     6       0.145  -6.834   1.353  1.00  0.00
ATOM     88  HG2 GLU     6       0.011  -7.810   2.816  1.00  0.00
ATOM     89  CD  GLU     6      -0.894  -5.858   2.968  1.00  0.00
ATOM     90  OE1 GLU     6      -1.011  -5.932   4.215  1.00  0.00
ATOM     91  OE2 GLU     6      -1.101  -4.793   2.350  1.00  0.00
ATOM     92  C   GLU     6      -2.691  -9.790   0.261  1.00  0.00
ATOM     93  O   GLU     6      -3.153 -10.698   0.961  1.00  0.00
ATOM     94  N   LEU     7      -3.271  -9.367  -0.887  1.00  0.00
ATOM     95  HN  LEU     7      -2.808  -8.685  -1.417  1.00  0.00
ATOM     96  CA  LEU     7      -4.562  -9.911  -1.391  1.00  0.00
ATOM     97  HA  LEU     7      -5.292  -9.732  -0.607  1.00  0.00
ATOM     98  CB  LEU     7      -5.054  -9.182  -2.681  1.00  0.00
ATOM     99  HB1 LEU     7      -5.975  -9.663  -3.009  1.00  0.00
ATOM    100  HB2 LEU     7      -4.310  -9.334  -3.456  1.00  0.00
ATOM    101  CG  LEU     7      -5.325  -7.651  -2.562  1.00  0.00
ATOM    102  HG  LEU     7      -4.402  -7.168  -2.287  1.00  0.00
ATOM    103  CD1 LEU     7      -5.756  -7.043  -3.913  1.00  0.00
ATOM    104 HD11 LEU     7      -6.661  -7.526  -4.269  1.00  0.00
ATOM    105 HD12 LEU     7      -4.968  -7.181  -4.640  1.00  0.00
ATOM    106 HD13 LEU     7      -5.941  -5.982  -3.792  1.00  0.00
ATOM    107  CD2 LEU     7      -6.353  -7.346  -1.453  1.00  0.00
ATOM    108 HD21 LEU     7      -5.982  -7.713  -0.505  1.00  0.00
ATOM    109 HD22 LEU     7      -7.295  -7.830  -1.678  1.00  0.00
ATOM    110 HD23 LEU     7      -6.509  -6.276  -1.383  1.00  0.00
ATOM    111  C   LEU     7      -4.504 -11.450  -1.632  1.00  0.00
ATOM    112  O   LEU     7      -5.411 -12.157  -1.175  1.00  0.00
ATOM    113  N   PRO     8      -3.462 -12.011  -2.364  1.00  0.00
ATOM    114  CA  PRO     8      -3.309 -13.478  -2.527  1.00  0.00
ATOM    115  HA  PRO     8      -4.145 -13.893  -3.088  1.00  0.00
ATOM    116  CB  PRO     8      -1.994 -13.649  -3.366  1.00  0.00
ATOM    117  HB1 PRO     8      -2.245 -13.908  -4.388  1.00  0.00
ATOM    118  HB2 PRO     8      -1.376 -14.442  -2.953  1.00  0.00
ATOM    119  CG  PRO     8      -1.308 -12.325  -3.298  1.00  0.00
ATOM    120  HG1 PRO     8      -0.750 -12.142  -4.212  1.00  0.00
ATOM    121  HG2 PRO     8      -0.632 -12.298  -2.447  1.00  0.00
ATOM    122  CD  PRO     8      -2.402 -11.297  -3.131  1.00  0.00
ATOM    123  HD1 PRO     8      -2.780 -10.972  -4.098  1.00  0.00
ATOM    124  HD2 PRO     8      -2.035 -10.447  -2.573  1.00  0.00
ATOM    125  C   PRO     8      -3.231 -14.208  -1.181  1.00  0.00
ATOM    126  O   PRO     8      -4.115 -14.994  -0.842  1.00  0.00
ATOM    127  N   VAL     9      -2.209 -13.860  -0.401  1.00  0.00
ATOM    128  HN  VAL     9      -1.703 -13.049  -0.636  1.00  0.00
ATOM    129  CA  VAL     9      -1.812 -14.612   0.800  1.00  0.00
ATOM    130  HA  VAL     9      -1.660 -15.641   0.491  1.00  0.00
ATOM    131  CB  VAL     9      -0.455 -14.070   1.348  1.00  0.00
ATOM    132  HB  VAL     9      -0.147 -14.712   2.173  1.00  0.00
ATOM    133  CG1 VAL     9       0.641 -14.156   0.254  1.00  0.00
ATOM    134 HG11 VAL     9       0.368 -13.532  -0.588  1.00  0.00
ATOM    135 HG12 VAL     9       0.746 -15.182  -0.082  1.00  0.00
ATOM    136 HG13 VAL     9       1.587 -13.820   0.657  1.00  0.00
ATOM    137  CG2 VAL     9      -0.593 -12.627   1.896  1.00  0.00
ATOM    138 HG21 VAL     9      -0.958 -11.972   1.115  1.00  0.00
ATOM    139 HG22 VAL     9       0.366 -12.271   2.239  1.00  0.00
ATOM    140 HG23 VAL     9      -1.292 -12.614   2.725  1.00  0.00
ATOM    141  C   VAL     9      -2.901 -14.601   1.905  1.00  0.00
ATOM    142  O   VAL     9      -3.020 -15.564   2.666  1.00  0.00
ATOM    143  N   GLN    10      -3.705 -13.515   1.950  1.00  0.00
ATOM    144  HN  GLN    10      -3.532 -12.787   1.318  1.00  0.00
ATOM    145  CA  GLN    10      -4.839 -13.376   2.888  1.00  0.00
ATOM    146  HA  GLN    10      -4.480 -13.600   3.893  1.00  0.00
ATOM    147  CB  GLN    10      -5.375 -11.914   2.859  1.00  0.00
ATOM    148  HB1 GLN    10      -5.608 -11.659   1.829  1.00  0.00
ATOM    149  HB2 GLN    10      -4.587 -11.252   3.197  1.00  0.00
ATOM    150  CG  GLN    10      -6.630 -11.627   3.718  1.00  0.00
ATOM    151  HG1 GLN    10      -7.444 -12.248   3.358  1.00  0.00
ATOM    152  HG2 GLN    10      -6.905 -10.587   3.587  1.00  0.00
ATOM    153  CD  GLN    10      -6.435 -11.892   5.211  1.00  0.00
ATOM    154  OE1 GLN    10      -6.001 -11.016   5.954  1.00  0.00
ATOM    155  NE2 GLN    10      -6.762 -13.097   5.655  1.00  0.00
ATOM    156 HE21 GLN    10      -7.111 -13.751   5.008  1.00  0.00
ATOM    157 HE22 GLN    10      -6.644 -13.289   6.609  1.00  0.00
ATOM    158  C   GLN    10      -5.951 -14.368   2.514  1.00  0.00
ATOM    159  O   GLN    10      -6.354 -15.200   3.335  1.00  0.00
ATOM    160  N   LYS    11      -6.395 -14.286   1.244  1.00  0.00
ATOM    161  HN  LYS    11      -5.949 -13.656   0.636  1.00  0.00
ATOM    162  CA  LYS    11      -7.508 -15.103   0.710  1.00  0.00
ATOM    163  HA  LYS    11      -8.378 -14.924   1.338  1.00  0.00
ATOM    164  CB  LYS    11      -7.846 -14.648  -0.732  1.00  0.00
ATOM    165  HB1 LYS    11      -8.562 -15.342  -1.167  1.00  0.00
ATOM    166  HB2 LYS    11      -6.938 -14.674  -1.329  1.00  0.00
ATOM    167  CG  LYS    11      -8.439 -13.225  -0.830  1.00  0.00
ATOM    168  HG1 LYS    11      -8.591 -12.983  -1.878  1.00  0.00
ATOM    169  HG2 LYS    11      -7.731 -12.521  -0.403  1.00  0.00
ATOM    170  CD  LYS    11      -9.782 -13.097  -0.085  1.00  0.00
ATOM    171  HD1 LYS    11      -9.626 -13.325   0.969  1.00  0.00
ATOM    172  HD2 LYS    11     -10.482 -13.816  -0.497  1.00  0.00
ATOM    173  CE  LYS    11     -10.403 -11.699  -0.200  1.00  0.00
ATOM    174  HE1 LYS    11     -10.562 -11.460  -1.242  1.00  0.00
ATOM    175  HE2 LYS    11      -9.730 -10.971   0.239  1.00  0.00
ATOM    176  NZ  LYS    11     -11.702 -11.633   0.510  1.00  0.00
ATOM    177  HZ1 LYS    11     -12.109 -10.686   0.416  1.00  0.00
ATOM    178  HZ2 LYS    11     -11.567 -11.843   1.519  1.00  0.00
ATOM    179  HZ3 LYS    11     -12.367 -12.326   0.112  1.00  0.00
ATOM    180  C   LYS    11      -7.180 -16.603   0.734  1.00  0.00
ATOM    181  O   LYS    11      -8.057 -17.429   0.977  1.00  0.00
ATOM    182  N   GLN    12      -5.904 -16.925   0.497  1.00  0.00
ATOM    183  HN  GLN    12      -5.262 -16.197   0.364  1.00  0.00
ATOM    184  CA  GLN    12      -5.412 -18.308   0.438  1.00  0.00
ATOM    185  HA  GLN    12      -6.116 -18.882  -0.161  1.00  0.00
ATOM    186  CB  GLN    12      -4.038 -18.347  -0.253  1.00  0.00
ATOM    187  HB1 GLN    12      -3.615 -19.342  -0.140  1.00  0.00
ATOM    188  HB2 GLN    12      -3.378 -17.634   0.241  1.00  0.00
ATOM    189  CG  GLN    12      -4.076 -18.013  -1.754  1.00  0.00
ATOM    190  HG1 GLN    12      -4.619 -17.084  -1.892  1.00  0.00
ATOM    191  HG2 GLN    12      -4.592 -18.806  -2.280  1.00  0.00
ATOM    192  CD  GLN    12      -2.692 -17.850  -2.370  1.00  0.00
ATOM    193  OE1 GLN    12      -2.513 -17.092  -3.318  1.00  0.00
ATOM    194  NE2 GLN    12      -1.704 -18.584  -1.862  1.00  0.00
ATOM    195 HE21 GLN    12      -1.901 -19.190  -1.120  1.00  0.00
ATOM    196 HE22 GLN    12      -0.821 -18.502  -2.263  1.00  0.00
ATOM    197  C   GLN    12      -5.310 -18.928   1.840  1.00  0.00
ATOM    198  O   GLN    12      -5.658 -20.085   2.024  1.00  0.00
ATOM    199  N   LEU    13      -4.802 -18.148   2.810  1.00  0.00
ATOM    200  HN  LEU    13      -4.515 -17.235   2.577  1.00  0.00
ATOM    201  CA  LEU    13      -4.660 -18.600   4.211  1.00  0.00
ATOM    202  HA  LEU    13      -4.023 -19.485   4.218  1.00  0.00
ATOM    203  CB  LEU    13      -4.000 -17.499   5.062  1.00  0.00
ATOM    204  HB1 LEU    13      -4.586 -16.593   4.943  1.00  0.00
ATOM    205  HB2 LEU    13      -3.007 -17.308   4.661  1.00  0.00
ATOM    206  CG  LEU    13      -3.869 -17.811   6.587  1.00  0.00
ATOM    207  HG  LEU    13      -4.781 -18.277   6.921  1.00  0.00
ATOM    208  CD1 LEU    13      -2.741 -18.824   6.881  1.00  0.00
ATOM    209 HD11 LEU    13      -2.683 -19.003   7.947  1.00  0.00
ATOM    210 HD12 LEU    13      -1.792 -18.435   6.532  1.00  0.00
ATOM    211 HD13 LEU    13      -2.952 -19.760   6.376  1.00  0.00
ATOM    212  CD2 LEU    13      -3.726 -16.522   7.391  1.00  0.00
ATOM    213 HD21 LEU    13      -3.726 -16.755   8.445  1.00  0.00
ATOM    214 HD22 LEU    13      -4.561 -15.868   7.172  1.00  0.00
ATOM    215 HD23 LEU    13      -2.801 -16.024   7.132  1.00  0.00
ATOM    216  C   LEU    13      -6.039 -18.958   4.803  1.00  0.00
ATOM    217  O   LEU    13      -6.199 -20.004   5.451  1.00  0.00
ATOM    218  N   GLU    14      -7.012 -18.054   4.579  1.00  0.00
ATOM    219  HN  GLU    14      -6.762 -17.194   4.166  1.00  0.00
ATOM    220  CA  GLU    14      -8.427 -18.274   4.938  1.00  0.00
ATOM    221  HA  GLU    14      -8.482 -18.402   6.018  1.00  0.00
ATOM    222  CB  GLU    14      -9.279 -17.045   4.529  1.00  0.00
ATOM    223  HB1 GLU    14     -10.327 -17.249   4.740  1.00  0.00
ATOM    224  HB2 GLU    14      -9.167 -16.886   3.459  1.00  0.00
ATOM    225  CG  GLU    14      -8.896 -15.744   5.249  1.00  0.00
ATOM    226  HG1 GLU    14      -7.833 -15.558   5.093  1.00  0.00
ATOM    227  HG2 GLU    14      -9.070 -15.875   6.311  1.00  0.00
ATOM    228  CD  GLU    14      -9.693 -14.526   4.750  1.00  0.00
ATOM    229  OE1 GLU    14     -10.749 -14.201   5.342  1.00  0.00
ATOM    230  OE2 GLU    14      -9.272 -13.890   3.756  1.00  0.00
ATOM    231  C   GLU    14      -8.950 -19.548   4.253  1.00  0.00
ATOM    232  O   GLU    14      -9.468 -20.433   4.916  1.00  0.00
ATOM    233  N   ALA    15      -8.711 -19.634   2.933  1.00  0.00
ATOM    234  HN  ALA    15      -8.204 -18.905   2.512  1.00  0.00
ATOM    235  CA  ALA    15      -9.156 -20.758   2.076  1.00  0.00
ATOM    236  HA  ALA    15     -10.235 -20.852   2.189  1.00  0.00
ATOM    237  CB  ALA    15      -8.862 -20.438   0.601  1.00  0.00
ATOM    238  HB1 ALA    15      -7.792 -20.355   0.451  1.00  0.00
ATOM    239  HB2 ALA    15      -9.327 -19.499   0.328  1.00  0.00
ATOM    240  HB3 ALA    15      -9.255 -21.223  -0.034  1.00  0.00
ATOM    241  C   ALA    15      -8.495 -22.102   2.478  1.00  0.00
ATOM    242  O   ALA    15      -9.058 -23.168   2.217  1.00  0.00
ATOM    243  N   TYR    16      -7.294 -22.028   3.098  1.00  0.00
ATOM    244  HN  TYR    16      -6.919 -21.135   3.279  1.00  0.00
ATOM    245  CA  TYR    16      -6.514 -23.215   3.518  1.00  0.00
ATOM    246  HA  TYR    16      -6.377 -23.844   2.639  1.00  0.00
ATOM    247  CB  TYR    16      -5.116 -22.780   4.043  1.00  0.00
ATOM    248  HB1 TYR    16      -5.253 -22.145   4.912  1.00  0.00
ATOM    249  HB2 TYR    16      -4.621 -22.198   3.274  1.00  0.00
ATOM    250  CG  TYR    16      -4.166 -23.936   4.432  1.00  0.00
ATOM    251  CD1 TYR    16      -3.688 -24.087   5.742  1.00  0.00
ATOM    252  HD1 TYR    16      -3.991 -23.371   6.499  1.00  0.00
ATOM    253  CD2 TYR    16      -3.752 -24.875   3.481  1.00  0.00
ATOM    254  HD2 TYR    16      -4.105 -24.781   2.460  1.00  0.00
ATOM    255  CE1 TYR    16      -2.836 -25.128   6.080  1.00  0.00
ATOM    256  HE1 TYR    16      -2.482 -25.225   7.100  1.00  0.00
ATOM    257  CE2 TYR    16      -2.904 -25.913   3.816  1.00  0.00
ATOM    258  HE2 TYR    16      -2.602 -26.625   3.059  1.00  0.00
ATOM    259  CZ  TYR    16      -2.448 -26.037   5.113  1.00  0.00
ATOM    260  OH  TYR    16      -1.602 -27.080   5.440  1.00  0.00
ATOM    261  HH  TYR    16      -1.856 -27.442   6.292  1.00  0.00
ATOM    262  C   TYR    16      -7.276 -24.016   4.589  1.00  0.00
ATOM    263  O   TYR    16      -7.355 -25.252   4.525  1.00  0.00
ATOM    264  N   ASN    17      -7.845 -23.289   5.560  1.00  0.00
ATOM    265  HN  ASN    17      -7.732 -22.312   5.539  1.00  0.00
ATOM    266  CA  ASN    17      -8.637 -23.887   6.651  1.00  0.00
ATOM    267  HA  ASN    17      -8.283 -24.908   6.797  1.00  0.00
ATOM    268  CB  ASN    17      -8.405 -23.104   7.979  1.00  0.00
ATOM    269  HB1 ASN    17      -7.345 -23.123   8.218  1.00  0.00
ATOM    270  HB2 ASN    17      -8.938 -23.600   8.780  1.00  0.00
ATOM    271  CG  ASN    17      -8.859 -21.642   7.940  1.00  0.00
ATOM    272  OD1 ASN    17      -9.998 -21.326   8.280  1.00  0.00
ATOM    273  ND2 ASN    17      -7.969 -20.740   7.540  1.00  0.00
ATOM    274 HD21 ASN    17      -7.069 -21.047   7.289  1.00  0.00
ATOM    275 HD22 ASN    17      -8.244 -19.800   7.514  1.00  0.00
ATOM    276  C   ASN    17     -10.139 -23.952   6.270  1.00  0.00
ATOM    277  O   ASN    17     -10.847 -24.858   6.711  1.00  0.00
ATOM    278  N   ALA    18     -10.592 -23.015   5.405  1.00  0.00
ATOM    279  HN  ALA    18      -9.945 -22.382   5.033  1.00  0.00
ATOM    280  CA  ALA    18     -12.017 -22.899   4.977  1.00  0.00
ATOM    281  HA  ALA    18     -12.645 -23.109   5.841  1.00  0.00
ATOM    282  CB  ALA    18     -12.330 -21.469   4.502  1.00  0.00
ATOM    283  HB1 ALA    18     -12.057 -20.761   5.270  1.00  0.00
ATOM    284  HB2 ALA    18     -13.389 -21.372   4.287  1.00  0.00
ATOM    285  HB3 ALA    18     -11.764 -21.251   3.601  1.00  0.00
ATOM    286  C   ALA    18     -12.372 -23.904   3.864  1.00  0.00
ATOM    287  O   ALA    18     -13.549 -24.058   3.525  1.00  0.00
ATOM    288  N   ARG    19     -11.335 -24.564   3.304  1.00  0.00
ATOM    289  HN  ARG    19     -10.428 -24.285   3.558  1.00  0.00
ATOM    290  CA  ARG    19     -11.463 -25.664   2.322  1.00  0.00
ATOM    291  HA  ARG    19     -10.461 -26.039   2.155  1.00  0.00
ATOM    292  CB  ARG    19     -12.324 -26.837   2.881  1.00  0.00
ATOM    293  HB1 ARG    19     -12.258 -27.674   2.191  1.00  0.00
ATOM    294  HB2 ARG    19     -13.358 -26.514   2.925  1.00  0.00
ATOM    295  CG  ARG    19     -11.926 -27.336   4.286  1.00  0.00
ATOM    296  HG1 ARG    19     -12.522 -28.212   4.517  1.00  0.00
ATOM    297  HG2 ARG    19     -12.152 -26.559   5.010  1.00  0.00
ATOM    298  CD  ARG    19     -10.443 -27.704   4.416  1.00  0.00
ATOM    299  HD1 ARG    19      -9.841 -26.820   4.237  1.00  0.00
ATOM    300  HD2 ARG    19     -10.192 -28.462   3.681  1.00  0.00
ATOM    301  NE  ARG    19     -10.151 -28.205   5.768  1.00  0.00
ATOM    302  HE  ARG    19      -9.995 -27.527   6.467  1.00  0.00
ATOM    303  CZ  ARG    19     -10.113 -29.498   6.120  1.00  0.00
ATOM    304  NH1 ARG    19     -10.315 -30.461   5.228  1.00  0.00
ATOM    305 HH11 ARG    19     -10.508 -30.236   4.271  1.00  0.00
ATOM    306 HH12 ARG    19     -10.261 -31.424   5.505  1.00  0.00
ATOM    307  NH2 ARG    19      -9.892 -29.827   7.378  1.00  0.00
ATOM    308 HH21 ARG    19      -9.761 -29.112   8.073  1.00  0.00
ATOM    309 HH22 ARG    19      -9.844 -30.791   7.648  1.00  0.00
ATOM    310  C   ARG    19     -11.996 -25.167   0.958  1.00  0.00
ATOM    311  O   ARG    19     -12.864 -25.800   0.338  1.00  0.00
ATOM    312  N   ASP    20     -11.443 -24.037   0.485  1.00  0.00
ATOM    313  HN  ASP    20     -10.788 -23.570   1.041  1.00  0.00
ATOM    314  CA  ASP    20     -11.769 -23.468  -0.838  1.00  0.00
ATOM    315  HA  ASP    20     -12.541 -24.077  -1.307  1.00  0.00
ATOM    316  CB  ASP    20     -12.309 -22.010  -0.689  1.00  0.00
ATOM    317  HB1 ASP    20     -12.380 -21.558  -1.674  1.00  0.00
ATOM    318  HB2 ASP    20     -11.601 -21.429  -0.100  1.00  0.00
ATOM    319  CG  ASP    20     -13.689 -21.930  -0.008  1.00  0.00
ATOM    320  OD1 ASP    20     -13.750 -21.843   1.238  1.00  0.00
ATOM    321  OD2 ASP    20     -14.720 -21.948  -0.721  1.00  0.00
ATOM    322  C   ASP    20     -10.514 -23.492  -1.734  1.00  0.00
ATOM    323  O   ASP    20      -9.717 -22.558  -1.696  1.00  0.00
ATOM    324  N   ILE    21     -10.357 -24.561  -2.547  1.00  0.00
ATOM    325  HN  ILE    21     -11.052 -25.252  -2.550  1.00  0.00
ATOM    326  CA  ILE    21      -9.181 -24.730  -3.438  1.00  0.00
ATOM    327  HA  ILE    21      -8.300 -24.483  -2.847  1.00  0.00
ATOM    328  CB  ILE    21      -9.016 -26.233  -3.930  1.00  0.00
ATOM    329  HB  ILE    21     -10.004 -26.599  -4.190  1.00  0.00
ATOM    330  CG1 ILE    21      -8.453 -27.132  -2.779  1.00  0.00
ATOM    331 HG11 ILE    21      -8.531 -28.173  -3.071  1.00  0.00
ATOM    332 HG12 ILE    21      -9.039 -26.979  -1.884  1.00  0.00
ATOM    333  CG2 ILE    21      -8.127 -26.369  -5.205  1.00  0.00
ATOM    334 HG21 ILE    21      -8.582 -25.828  -6.025  1.00  0.00
ATOM    335 HG22 ILE    21      -8.032 -27.412  -5.477  1.00  0.00
ATOM    336 HG23 ILE    21      -7.143 -25.959  -5.009  1.00  0.00
ATOM    337  CD1 ILE    21      -6.996 -26.864  -2.418  1.00  0.00
ATOM    338 HD11 ILE    21      -6.719 -27.483  -1.577  1.00  0.00
ATOM    339 HD12 ILE    21      -6.874 -25.824  -2.152  1.00  0.00
ATOM    340 HD13 ILE    21      -6.361 -27.100  -3.261  1.00  0.00
ATOM    341  C   ILE    21      -9.226 -23.742  -4.620  1.00  0.00
ATOM    342  O   ILE    21      -8.175 -23.315  -5.100  1.00  0.00
ATOM    343  N   ASP    22     -10.438 -23.351  -5.061  1.00  0.00
ATOM    344  HN  ASP    22     -11.243 -23.708  -4.615  1.00  0.00
ATOM    345  CA  ASP    22     -10.607 -22.411  -6.196  1.00  0.00
ATOM    346  HA  ASP    22     -10.117 -22.864  -7.058  1.00  0.00
ATOM    347  CB  ASP    22     -12.108 -22.225  -6.538  1.00  0.00
ATOM    348  HB1 ASP    22     -12.633 -21.874  -5.655  1.00  0.00
ATOM    349  HB2 ASP    22     -12.527 -23.188  -6.818  1.00  0.00
ATOM    350  CG  ASP    22     -12.355 -21.231  -7.695  1.00  0.00
ATOM    351  OD1 ASP    22     -12.735 -20.066  -7.435  1.00  0.00
ATOM    352  OD2 ASP    22     -12.135 -21.609  -8.867  1.00  0.00
ATOM    353  C   ASP    22      -9.928 -21.047  -5.907  1.00  0.00
ATOM    354  O   ASP    22      -9.220 -20.518  -6.762  1.00  0.00
ATOM    355  N   ALA    23     -10.136 -20.511  -4.691  1.00  0.00
ATOM    356  HN  ALA    23     -10.740 -20.975  -4.074  1.00  0.00
ATOM    357  CA  ALA    23      -9.486 -19.252  -4.239  1.00  0.00
ATOM    358  HA  ALA    23      -9.458 -18.561  -5.080  1.00  0.00
ATOM    359  CB  ALA    23     -10.297 -18.602  -3.105  1.00  0.00
ATOM    360  HB1 ALA    23      -9.839 -17.662  -2.810  1.00  0.00
ATOM    361  HB2 ALA    23     -10.332 -19.265  -2.252  1.00  0.00
ATOM    362  HB3 ALA    23     -11.309 -18.413  -3.447  1.00  0.00
ATOM    363  C   ALA    23      -8.040 -19.511  -3.791  1.00  0.00
ATOM    364  O   ALA    23      -7.160 -18.659  -3.967  1.00  0.00
ATOM    365  N   PHE    24      -7.810 -20.712  -3.236  1.00  0.00
ATOM    366  HN  PHE    24      -8.575 -21.307  -3.083  1.00  0.00
ATOM    367  CA  PHE    24      -6.473 -21.176  -2.830  1.00  0.00
ATOM    368  HA  PHE    24      -6.009 -20.382  -2.243  1.00  0.00
ATOM    369  CB  PHE    24      -6.615 -22.440  -1.934  1.00  0.00
ATOM    370  HB1 PHE    24      -6.963 -23.265  -2.547  1.00  0.00
ATOM    371  HB2 PHE    24      -7.362 -22.246  -1.173  1.00  0.00
ATOM    372  CG  PHE    24      -5.339 -22.878  -1.225  1.00  0.00
ATOM    373  CD1 PHE    24      -4.521 -23.871  -1.754  1.00  0.00
ATOM    374  HD1 PHE    24      -4.808 -24.367  -2.671  1.00  0.00
ATOM    375  CD2 PHE    24      -4.940 -22.263  -0.047  1.00  0.00
ATOM    376  HD2 PHE    24      -5.561 -21.491   0.389  1.00  0.00
ATOM    377  CE1 PHE    24      -3.356 -24.232  -1.120  1.00  0.00
ATOM    378  HE1 PHE    24      -2.732 -25.002  -1.545  1.00  0.00
ATOM    379  CE2 PHE    24      -3.775 -22.635   0.590  1.00  0.00
ATOM    380  HE2 PHE    24      -3.483 -22.147   1.511  1.00  0.00
ATOM    381  CZ  PHE    24      -2.979 -23.615   0.050  1.00  0.00
ATOM    382  HZ  PHE    24      -2.058 -23.904   0.544  1.00  0.00
ATOM    383  C   PHE    24      -5.585 -21.459  -4.071  1.00  0.00
ATOM    384  O   PHE    24      -4.392 -21.704  -3.933  1.00  0.00
ATOM    385  N   MET    25      -6.184 -21.461  -5.282  1.00  0.00
ATOM    386  HN  MET    25      -7.161 -21.385  -5.318  1.00  0.00
ATOM    387  CA  MET    25      -5.445 -21.605  -6.559  1.00  0.00
ATOM    388  HA  MET    25      -4.407 -21.823  -6.325  1.00  0.00
ATOM    389  CB  MET    25      -6.016 -22.776  -7.413  1.00  0.00
ATOM    390  HB1 MET    25      -7.067 -22.579  -7.602  1.00  0.00
ATOM    391  HB2 MET    25      -5.940 -23.689  -6.834  1.00  0.00
ATOM    392  CG  MET    25      -5.310 -23.025  -8.775  1.00  0.00
ATOM    393  HG1 MET    25      -5.016 -22.072  -9.200  1.00  0.00
ATOM    394  HG2 MET    25      -6.019 -23.489  -9.446  1.00  0.00
ATOM    395  SD  MET    25      -3.840 -24.101  -8.708  1.00  0.00
ATOM    396  CE  MET    25      -2.690 -23.286  -7.583  1.00  0.00
ATOM    397  HE1 MET    25      -1.756 -23.833  -7.570  1.00  0.00
ATOM    398  HE2 MET    25      -3.107 -23.276  -6.587  1.00  0.00
ATOM    399  HE3 MET    25      -2.510 -22.271  -7.910  1.00  0.00
ATOM    400  C   MET    25      -5.483 -20.303  -7.374  1.00  0.00
ATOM    401  O   MET    25      -4.536 -20.015  -8.120  1.00  0.00
ATOM    402  N   ALA    26      -6.576 -19.524  -7.206  1.00  0.00
ATOM    403  HN  ALA    26      -7.206 -19.764  -6.502  1.00  0.00
ATOM    404  CA  ALA    26      -6.870 -18.324  -8.030  1.00  0.00
ATOM    405  HA  ALA    26      -7.098 -18.668  -9.039  1.00  0.00
ATOM    406  CB  ALA    26      -8.111 -17.596  -7.486  1.00  0.00
ATOM    407  HB1 ALA    26      -8.955 -18.274  -7.463  1.00  0.00
ATOM    408  HB2 ALA    26      -8.354 -16.752  -8.122  1.00  0.00
ATOM    409  HB3 ALA    26      -7.918 -17.241  -6.478  1.00  0.00
ATOM    410  C   ALA    26      -5.690 -17.354  -8.081  1.00  0.00
ATOM    411  O   ALA    26      -5.165 -17.037  -9.147  1.00  0.00
ATOM    412  N   TRP    27      -5.237 -16.978  -6.894  1.00  0.00
ATOM    413  HN  TRP    27      -5.569 -17.449  -6.099  1.00  0.00
ATOM    414  CA  TRP    27      -4.272 -15.899  -6.699  1.00  0.00
ATOM    415  HA  TRP    27      -4.541 -15.083  -7.366  1.00  0.00
ATOM    416  CB  TRP    27      -4.404 -15.411  -5.253  1.00  0.00
ATOM    417  HB1 TRP    27      -3.650 -14.657  -5.074  1.00  0.00
ATOM    418  HB2 TRP    27      -4.223 -16.240  -4.578  1.00  0.00
ATOM    419  CG  TRP    27      -5.746 -14.806  -4.899  1.00  0.00
ATOM    420  CD1 TRP    27      -6.813 -15.425  -4.298  1.00  0.00
ATOM    421  HD1 TRP    27      -6.834 -16.466  -4.002  1.00  0.00
ATOM    422  CD2 TRP    27      -6.140 -13.442  -5.103  1.00  0.00
ATOM    423  NE1 TRP    27      -7.838 -14.529  -4.128  1.00  0.00
ATOM    424  HE1 TRP    27      -8.707 -14.731  -3.721  1.00  0.00
ATOM    425  CE2 TRP    27      -7.451 -13.309  -4.615  1.00  0.00
ATOM    426  CE3 TRP    27      -5.497 -12.321  -5.646  1.00  0.00
ATOM    427  HE3 TRP    27      -4.487 -12.389  -6.033  1.00  0.00
ATOM    428  CZ2 TRP    27      -8.137 -12.102  -4.667  1.00  0.00
ATOM    429  HZ2 TRP    27      -9.148 -12.004  -4.298  1.00  0.00
ATOM    430  CZ3 TRP    27      -6.182 -11.125  -5.699  1.00  0.00
ATOM    431  HZ3 TRP    27      -5.704 -10.246  -6.113  1.00  0.00
ATOM    432  CH2 TRP    27      -7.489 -11.021  -5.207  1.00  0.00
ATOM    433  HH2 TRP    27      -7.991 -10.060  -5.267  1.00  0.00
ATOM    434  C   TRP    27      -2.813 -16.314  -7.008  1.00  0.00
ATOM    435  O   TRP    27      -1.888 -15.520  -6.805  1.00  0.00
ATOM    436  N   TRP    28      -2.618 -17.549  -7.499  1.00  0.00
ATOM    437  HN  TRP    28      -3.388 -18.151  -7.573  1.00  0.00
ATOM    438  CA  TRP    28      -1.309 -18.047  -7.951  1.00  0.00
ATOM    439  HA  TRP    28      -0.524 -17.501  -7.429  1.00  0.00
ATOM    440  CB  TRP    28      -1.163 -19.564  -7.650  1.00  0.00
ATOM    441  HB1 TRP    28      -0.191 -19.902  -7.996  1.00  0.00
ATOM    442  HB2 TRP    28      -1.929 -20.106  -8.194  1.00  0.00
ATOM    443  CG  TRP    28      -1.297 -19.941  -6.191  1.00  0.00
ATOM    444  CD1 TRP    28      -2.412 -19.826  -5.411  1.00  0.00
ATOM    445  HD1 TRP    28      -3.365 -19.415  -5.743  1.00  0.00
ATOM    446  CD2 TRP    28      -0.291 -20.536  -5.349  1.00  0.00
ATOM    447  NE1 TRP    28      -2.155 -20.305  -4.159  1.00  0.00
ATOM    448  HE1 TRP    28      -2.801 -20.329  -3.422  1.00  0.00
ATOM    449  CE2 TRP    28      -0.869 -20.737  -4.089  1.00  0.00
ATOM    450  CE3 TRP    28       1.037 -20.908  -5.540  1.00  0.00
ATOM    451  HE3 TRP    28       1.520 -20.774  -6.499  1.00  0.00
ATOM    452  CZ2 TRP    28      -0.174 -21.298  -3.021  1.00  0.00
ATOM    453  HZ2 TRP    28      -0.632 -21.445  -2.052  1.00  0.00
ATOM    454  CZ3 TRP    28       1.731 -21.467  -4.485  1.00  0.00
ATOM    455  HZ3 TRP    28       2.764 -21.760  -4.617  1.00  0.00
ATOM    456  CH2 TRP    28       1.127 -21.653  -3.235  1.00  0.00
ATOM    457  HH2 TRP    28       1.710 -22.092  -2.434  1.00  0.00
ATOM    458  C   TRP    28      -1.162 -17.807  -9.463  1.00  0.00
ATOM    459  O   TRP    28      -2.148 -17.552 -10.168  1.00  0.00
ATOM    460  N   ALA    29       0.084 -17.865  -9.940  1.00  0.00
ATOM    461  HN  ALA    29       0.820 -17.910  -9.299  1.00  0.00
ATOM    462  CA  ALA    29       0.402 -17.858 -11.384  1.00  0.00
ATOM    463  HA  ALA    29      -0.268 -17.158 -11.880  1.00  0.00
ATOM    464  CB  ALA    29       1.851 -17.391 -11.618  1.00  0.00
ATOM    465  HB1 ALA    29       1.980 -16.392 -11.220  1.00  0.00
ATOM    466  HB2 ALA    29       2.066 -17.379 -12.680  1.00  0.00
ATOM    467  HB3 ALA    29       2.542 -18.065 -11.123  1.00  0.00
ATOM    468  C   ALA    29       0.186 -19.261 -11.971  1.00  0.00
ATOM    469  O   ALA    29       0.322 -20.257 -11.255  1.00  0.00
ATOM    470  N   ASP    30      -0.136 -19.337 -13.276  1.00  0.00
ATOM    471  HN  ASP    30      -0.232 -18.505 -13.787  1.00  0.00
ATOM    472  CA  ASP    30      -0.360 -20.632 -13.968  1.00  0.00
ATOM    473  HA  ASP    30      -1.069 -21.201 -13.371  1.00  0.00
ATOM    474  CB  ASP    30      -0.975 -20.409 -15.375  1.00  0.00
ATOM    475  HB1 ASP    30      -0.286 -19.812 -15.967  1.00  0.00
ATOM    476  HB2 ASP    30      -1.901 -19.854 -15.268  1.00  0.00
ATOM    477  CG  ASP    30      -1.287 -21.721 -16.139  1.00  0.00
ATOM    478  OD1 ASP    30      -0.682 -21.975 -17.205  1.00  0.00
ATOM    479  OD2 ASP    30      -2.136 -22.508 -15.671  1.00  0.00
ATOM    480  C   ASP    30       0.946 -21.444 -14.073  1.00  0.00
ATOM    481  O   ASP    30       0.921 -22.672 -14.123  1.00  0.00
ATOM    482  N   ASP    31       2.086 -20.743 -14.091  1.00  0.00
ATOM    483  HN  ASP    31       2.032 -19.765 -14.057  1.00  0.00
ATOM    484  CA  ASP    31       3.425 -21.361 -14.163  1.00  0.00
ATOM    485  HA  ASP    31       3.309 -22.413 -14.416  1.00  0.00
ATOM    486  CB  ASP    31       4.258 -20.668 -15.283  1.00  0.00
ATOM    487  HB1 ASP    31       3.670 -20.644 -16.196  1.00  0.00
ATOM    488  HB2 ASP    31       5.148 -21.261 -15.470  1.00  0.00
ATOM    489  CG  ASP    31       4.679 -19.220 -14.947  1.00  0.00
ATOM    490  OD1 ASP    31       5.893 -18.910 -14.968  1.00  0.00
ATOM    491  OD2 ASP    31       3.794 -18.390 -14.651  1.00  0.00
ATOM    492  C   ASP    31       4.145 -21.271 -12.798  1.00  0.00
ATOM    493  O   ASP    31       5.368 -21.436 -12.735  1.00  0.00
ATOM    494  N   CYS    32       3.372 -21.042 -11.708  1.00  0.00
ATOM    495  HN  CYS    32       2.397 -21.033 -11.820  1.00  0.00
ATOM    496  CA  CYS    32       3.929 -20.815 -10.357  1.00  0.00
ATOM    497  HA  CYS    32       4.586 -19.948 -10.425  1.00  0.00
ATOM    498  CB  CYS    32       2.822 -20.500  -9.334  1.00  0.00
ATOM    499  HB1 CYS    32       2.121 -21.327  -9.285  1.00  0.00
ATOM    500  HB2 CYS    32       2.292 -19.608  -9.643  1.00  0.00
ATOM    501  SG  CYS    32       3.442 -20.205  -7.661  1.00  0.00
ATOM    502  HG  CYS    32       3.893 -18.961  -7.609  1.00  0.00
ATOM    503  C   CYS    32       4.746 -22.018  -9.858  1.00  0.00
ATOM    504  O   CYS    32       4.315 -23.164  -9.982  1.00  0.00
ATOM    505  N   GLN    33       5.931 -21.735  -9.310  1.00  0.00
ATOM    506  HN  GLN    33       6.211 -20.795  -9.266  1.00  0.00
ATOM    507  CA  GLN    33       6.820 -22.757  -8.747  1.00  0.00
ATOM    508  HA  GLN    33       6.676 -23.687  -9.300  1.00  0.00
ATOM    509  CB  GLN    33       8.293 -22.308  -8.888  1.00  0.00
ATOM    510  HB1 GLN    33       8.940 -23.107  -8.534  1.00  0.00
ATOM    511  HB2 GLN    33       8.455 -21.432  -8.264  1.00  0.00
ATOM    512  CG  GLN    33       8.708 -21.948 -10.324  1.00  0.00
ATOM    513  HG1 GLN    33       9.714 -21.544 -10.306  1.00  0.00
ATOM    514  HG2 GLN    33       8.029 -21.185 -10.687  1.00  0.00
ATOM    515  CD  GLN    33       8.666 -23.115 -11.312  1.00  0.00
ATOM    516  OE1 GLN    33       9.627 -23.873 -11.448  1.00  0.00
ATOM    517  NE2 GLN    33       7.557 -23.249 -12.021  1.00  0.00
ATOM    518 HE21 GLN    33       6.829 -22.608 -11.869  1.00  0.00
ATOM    519 HE22 GLN    33       7.515 -23.970 -12.683  1.00  0.00
ATOM    520  C   GLN    33       6.458 -22.984  -7.273  1.00  0.00
ATOM    521  O   GLN    33       6.003 -22.058  -6.590  1.00  0.00
ATOM    522  N   TYR    34       6.660 -24.215  -6.795  1.00  0.00
ATOM    523  HN  TYR    34       7.018 -24.897  -7.399  1.00  0.00
ATOM    524  CA  TYR    34       6.366 -24.598  -5.412  1.00  0.00
ATOM    525  HA  TYR    34       6.364 -23.697  -4.801  1.00  0.00
ATOM    526  CB  TYR    34       4.974 -25.271  -5.320  1.00  0.00
ATOM    527  HB1 TYR    34       5.006 -26.231  -5.824  1.00  0.00
ATOM    528  HB2 TYR    34       4.250 -24.644  -5.830  1.00  0.00
ATOM    529  CG  TYR    34       4.468 -25.493  -3.889  1.00  0.00
ATOM    530  CD1 TYR    34       4.474 -26.760  -3.296  1.00  0.00
ATOM    531  HD1 TYR    34       4.842 -27.610  -3.864  1.00  0.00
ATOM    532  CD2 TYR    34       3.989 -24.416  -3.132  1.00  0.00
ATOM    533  HD2 TYR    34       3.970 -23.424  -3.573  1.00  0.00
ATOM    534  CE1 TYR    34       4.013 -26.943  -2.007  1.00  0.00
ATOM    535  HE1 TYR    34       4.024 -27.931  -1.565  1.00  0.00
ATOM    536  CE2 TYR    34       3.532 -24.598  -1.845  1.00  0.00
ATOM    537  HE2 TYR    34       3.165 -23.751  -1.278  1.00  0.00
ATOM    538  CZ  TYR    34       3.548 -25.860  -1.285  1.00  0.00
ATOM    539  OH  TYR    34       3.076 -26.040  -0.005  1.00  0.00
ATOM    540  HH  TYR    34       3.708 -26.559   0.500  1.00  0.00
ATOM    541  C   TYR    34       7.470 -25.531  -4.911  1.00  0.00
ATOM    542  O   TYR    34       7.623 -26.639  -5.427  1.00  0.00
ATOM    543  N   TYR    35       8.258 -25.050  -3.939  1.00  0.00
ATOM    544  HN  TYR    35       8.090 -24.143  -3.617  1.00  0.00
ATOM    545  CA  TYR    35       9.360 -25.806  -3.322  1.00  0.00
ATOM    546  HA  TYR    35       9.523 -26.709  -3.909  1.00  0.00
ATOM    547  CB  TYR    35      10.675 -24.980  -3.310  1.00  0.00
ATOM    548  HB1 TYR    35      11.435 -25.539  -2.770  1.00  0.00
ATOM    549  HB2 TYR    35      10.501 -24.053  -2.779  1.00  0.00
ATOM    550  CG  TYR    35      11.248 -24.622  -4.699  1.00  0.00
ATOM    551  CD1 TYR    35      12.419 -25.220  -5.176  1.00  0.00
ATOM    552  HD1 TYR    35      12.920 -25.960  -4.560  1.00  0.00
ATOM    553  CD2 TYR    35      10.630 -23.674  -5.519  1.00  0.00
ATOM    554  HD2 TYR    35       9.721 -23.191  -5.173  1.00  0.00
ATOM    555  CE1 TYR    35      12.942 -24.893  -6.412  1.00  0.00
ATOM    556  HE1 TYR    35      13.843 -25.374  -6.758  1.00  0.00
ATOM    557  CE2 TYR    35      11.150 -23.347  -6.756  1.00  0.00
ATOM    558  HE2 TYR    35      10.646 -22.616  -7.370  1.00  0.00
ATOM    559  CZ  TYR    35      12.306 -23.952  -7.197  1.00  0.00
ATOM    560  OH  TYR    35      12.820 -23.623  -8.433  1.00  0.00
ATOM    561  HH  TYR    35      13.041 -24.430  -8.909  1.00  0.00
ATOM    562  C   TYR    35       9.000 -26.224  -1.887  1.00  0.00
ATOM    563  O   TYR    35       8.172 -25.588  -1.222  1.00  0.00
ATOM    564  N   ALA    36       9.647 -27.307  -1.441  1.00  0.00
ATOM    565  HN  ALA    36      10.233 -27.776  -2.069  1.00  0.00
ATOM    566  CA  ALA    36       9.560 -27.833  -0.072  1.00  0.00
ATOM    567  HA  ALA    36       8.812 -27.261   0.480  1.00  0.00
ATOM    568  CB  ALA    36       9.131 -29.308  -0.103  1.00  0.00
ATOM    569  HB1 ALA    36       8.176 -29.395  -0.605  1.00  0.00
ATOM    570  HB2 ALA    36       9.038 -29.687   0.907  1.00  0.00
ATOM    571  HB3 ALA    36       9.868 -29.893  -0.640  1.00  0.00
ATOM    572  C   ALA    36      10.919 -27.677   0.619  1.00  0.00
ATOM    573  O   ALA    36      11.950 -27.634  -0.064  1.00  0.00
ATOM    574  N   PHE    37      10.898 -27.616   1.965  1.00  0.00
ATOM    575  HN  PHE    37      10.028 -27.690   2.410  1.00  0.00
ATOM    576  CA  PHE    37      12.100 -27.441   2.814  1.00  0.00
ATOM    577  HA  PHE    37      12.490 -26.449   2.624  1.00  0.00
ATOM    578  CB  PHE    37      11.685 -27.538   4.308  1.00  0.00
ATOM    579  HB1 PHE    37      11.206 -28.496   4.474  1.00  0.00
ATOM    580  HB2 PHE    37      10.960 -26.758   4.518  1.00  0.00
ATOM    581  CG  PHE    37      12.829 -27.390   5.318  1.00  0.00
ATOM    582  CD1 PHE    37      13.502 -26.179   5.459  1.00  0.00
ATOM    583  HD1 PHE    37      13.222 -25.338   4.834  1.00  0.00
ATOM    584  CD2 PHE    37      13.216 -28.454   6.136  1.00  0.00
ATOM    585  HD2 PHE    37      12.715 -29.408   6.039  1.00  0.00
ATOM    586  CE1 PHE    37      14.520 -26.033   6.380  1.00  0.00
ATOM    587  HE1 PHE    37      15.030 -25.081   6.474  1.00  0.00
ATOM    588  CE2 PHE    37      14.239 -28.307   7.056  1.00  0.00
ATOM    589  HE2 PHE    37      14.527 -29.141   7.681  1.00  0.00
ATOM    590  CZ  PHE    37      14.888 -27.095   7.179  1.00  0.00
ATOM    591  HZ  PHE    37      15.684 -26.978   7.901  1.00  0.00
ATOM    592  C   PHE    37      13.194 -28.502   2.500  1.00  0.00
ATOM    593  O   PHE    37      12.892 -29.697   2.556  1.00  0.00
ATOM    594  N   PRO    38      14.479 -28.106   2.177  1.00  0.00
ATOM    595  CA  PRO    38      14.924 -26.691   2.008  1.00  0.00
ATOM    596  HA  PRO    38      14.537 -26.075   2.819  1.00  0.00
ATOM    597  CB  PRO    38      16.467 -26.797   2.147  1.00  0.00
ATOM    598  HB1 PRO    38      16.750 -26.680   3.192  1.00  0.00
ATOM    599  HB2 PRO    38      16.955 -26.023   1.563  1.00  0.00
ATOM    600  CG  PRO    38      16.797 -28.171   1.643  1.00  0.00
ATOM    601  HG1 PRO    38      17.713 -28.531   2.101  1.00  0.00
ATOM    602  HG2 PRO    38      16.911 -28.148   0.562  1.00  0.00
ATOM    603  CD  PRO    38      15.623 -29.050   2.037  1.00  0.00
ATOM    604  HD1 PRO    38      15.819 -29.546   2.982  1.00  0.00
ATOM    605  HD2 PRO    38      15.416 -29.784   1.272  1.00  0.00
ATOM    606  C   PRO    38      14.491 -26.046   0.650  1.00  0.00
ATOM    607  O   PRO    38      13.769 -25.041   0.647  1.00  0.00
ATOM    608  N   ALA    39      14.901 -26.646  -0.492  1.00  0.00
ATOM    609  HN  ALA    39      15.417 -27.473  -0.427  1.00  0.00
ATOM    610  CA  ALA    39      14.593 -26.127  -1.842  1.00  0.00
ATOM    611  HA  ALA    39      13.665 -25.552  -1.792  1.00  0.00
ATOM    612  CB  ALA    39      15.713 -25.178  -2.326  1.00  0.00
ATOM    613  HB1 ALA    39      15.457 -24.768  -3.297  1.00  0.00
ATOM    614  HB2 ALA    39      16.645 -25.720  -2.403  1.00  0.00
ATOM    615  HB3 ALA    39      15.834 -24.365  -1.618  1.00  0.00
ATOM    616  C   ALA    39      14.388 -27.300  -2.818  1.00  0.00
ATOM    617  O   ALA    39      15.294 -27.665  -3.577  1.00  0.00
ATOM    618  N   THR    40      13.197 -27.913  -2.761  1.00  0.00
ATOM    619  HN  THR    40      12.521 -27.561  -2.142  1.00  0.00
ATOM    620  CA  THR    40      12.851 -29.096  -3.572  1.00  0.00
ATOM    621  HA  THR    40      13.657 -29.283  -4.280  1.00  0.00
ATOM    622  CB  THR    40      12.707 -30.356  -2.654  1.00  0.00
ATOM    623  HB  THR    40      11.946 -30.151  -1.903  1.00  0.00
ATOM    624  OG1 THR    40      13.957 -30.590  -1.979  1.00  0.00
ATOM    625  HG1 THR    40      13.879 -30.308  -1.067  1.00  0.00
ATOM    626  CG2 THR    40      12.296 -31.623  -3.435  1.00  0.00
ATOM    627 HG21 THR    40      13.015 -31.819  -4.220  1.00  0.00
ATOM    628 HG22 THR    40      11.315 -31.481  -3.876  1.00  0.00
ATOM    629 HG23 THR    40      12.264 -32.471  -2.765  1.00  0.00
ATOM    630  C   THR    40      11.555 -28.827  -4.355  1.00  0.00
ATOM    631  O   THR    40      10.466 -28.807  -3.771  1.00  0.00
ATOM    632  N   LEU    41      11.690 -28.604  -5.676  1.00  0.00
ATOM    633  HN  LEU    41      12.579 -28.711  -6.077  1.00  0.00
ATOM    634  CA  LEU    41      10.568 -28.232  -6.559  1.00  0.00
ATOM    635  HA  LEU    41      10.075 -27.367  -6.120  1.00  0.00
ATOM    636  CB  LEU    41      11.113 -27.835  -7.964  1.00  0.00
ATOM    637  HB1 LEU    41      11.598 -28.707  -8.395  1.00  0.00
ATOM    638  HB2 LEU    41      11.871 -27.070  -7.827  1.00  0.00
ATOM    639  CG  LEU    41      10.063 -27.304  -8.992  1.00  0.00
ATOM    640  HG  LEU    41       9.269 -28.028  -9.069  1.00  0.00
ATOM    641  CD1 LEU    41       9.414 -25.991  -8.514  1.00  0.00
ATOM    642 HD11 LEU    41      10.169 -25.224  -8.402  1.00  0.00
ATOM    643 HD12 LEU    41       8.924 -26.152  -7.563  1.00  0.00
ATOM    644 HD13 LEU    41       8.676 -25.665  -9.237  1.00  0.00
ATOM    645  CD2 LEU    41      10.680 -27.145 -10.400  1.00  0.00
ATOM    646 HD21 LEU    41      11.474 -26.407 -10.375  1.00  0.00
ATOM    647 HD22 LEU    41       9.918 -26.826 -11.099  1.00  0.00
ATOM    648 HD23 LEU    41      11.084 -28.094 -10.729  1.00  0.00
ATOM    649  C   LEU    41       9.549 -29.387  -6.673  1.00  0.00
ATOM    650  O   LEU    41       9.794 -30.377  -7.366  1.00  0.00
ATOM    651  N   LEU    42       8.424 -29.257  -5.947  1.00  0.00
ATOM    652  HN  LEU    42       8.353 -28.502  -5.331  1.00  0.00
ATOM    653  CA  LEU    42       7.306 -30.217  -6.004  1.00  0.00
ATOM    654  HA  LEU    42       7.720 -31.215  -6.065  1.00  0.00
ATOM    655  CB  LEU    42       6.422 -30.119  -4.726  1.00  0.00
ATOM    656  HB1 LEU    42       5.673 -30.904  -4.778  1.00  0.00
ATOM    657  HB2 LEU    42       5.906 -29.161  -4.745  1.00  0.00
ATOM    658  CG  LEU    42       7.155 -30.235  -3.352  1.00  0.00
ATOM    659  HG  LEU    42       7.771 -29.352  -3.218  1.00  0.00
ATOM    660  CD1 LEU    42       6.145 -30.250  -2.183  1.00  0.00
ATOM    661 HD11 LEU    42       5.491 -31.112  -2.265  1.00  0.00
ATOM    662 HD12 LEU    42       5.550 -29.348  -2.206  1.00  0.00
ATOM    663 HD13 LEU    42       6.679 -30.295  -1.243  1.00  0.00
ATOM    664  CD2 LEU    42       8.099 -31.459  -3.304  1.00  0.00
ATOM    665 HD21 LEU    42       8.577 -31.515  -2.336  1.00  0.00
ATOM    666 HD22 LEU    42       8.861 -31.355  -4.065  1.00  0.00
ATOM    667 HD23 LEU    42       7.537 -32.369  -3.483  1.00  0.00
ATOM    668  C   LEU    42       6.434 -29.958  -7.246  1.00  0.00
ATOM    669  O   LEU    42       5.915 -30.902  -7.860  1.00  0.00
ATOM    670  N   ALA    43       6.281 -28.670  -7.605  1.00  0.00
ATOM    671  HN  ALA    43       6.814 -27.988  -7.142  1.00  0.00
ATOM    672  CA  ALA    43       5.338 -28.239  -8.656  1.00  0.00
ATOM    673  HA  ALA    43       5.126 -29.084  -9.309  1.00  0.00
ATOM    674  CB  ALA    43       4.025 -27.815  -7.996  1.00  0.00
ATOM    675  HB1 ALA    43       3.306 -27.524  -8.754  1.00  0.00
ATOM    676  HB2 ALA    43       4.205 -26.979  -7.333  1.00  0.00
ATOM    677  HB3 ALA    43       3.620 -28.641  -7.424  1.00  0.00
ATOM    678  C   ALA    43       5.919 -27.088  -9.495  1.00  0.00
ATOM    679  O   ALA    43       6.235 -26.030  -8.953  1.00  0.00
ATOM    680  N   GLY    44       6.037 -27.307 -10.819  1.00  0.00
ATOM    681  HN  GLY    44       5.759 -28.179 -11.171  1.00  0.00
ATOM    682  CA  GLY    44       6.553 -26.303 -11.758  1.00  0.00
ATOM    683  HA1 GLY    44       7.207 -26.802 -12.463  1.00  0.00
ATOM    684  HA2 GLY    44       7.132 -25.564 -11.218  1.00  0.00
ATOM    685  C   GLY    44       5.441 -25.590 -12.533  1.00  0.00
ATOM    686  O   GLY    44       5.641 -25.190 -13.688  1.00  0.00
ATOM    687  N   ASN    45       4.307 -25.374 -11.842  1.00  0.00
ATOM    688  HN  ASN    45       4.350 -25.502 -10.870  1.00  0.00
ATOM    689  CA  ASN    45       3.029 -24.853 -12.409  1.00  0.00
ATOM    690  HA  ASN    45       3.173 -23.789 -12.573  1.00  0.00
ATOM    691  CB  ASN    45       2.606 -25.511 -13.767  1.00  0.00
ATOM    692  HB1 ASN    45       3.409 -25.382 -14.484  1.00  0.00
ATOM    693  HB2 ASN    45       1.735 -24.993 -14.147  1.00  0.00
ATOM    694  CG  ASN    45       2.271 -27.002 -13.667  1.00  0.00
ATOM    695  OD1 ASN    45       1.137 -27.384 -13.375  1.00  0.00
ATOM    696  ND2 ASN    45       3.246 -27.850 -13.945  1.00  0.00
ATOM    697 HD21 ASN    45       4.118 -27.483 -14.196  1.00  0.00
ATOM    698 HD22 ASN    45       3.059 -28.809 -13.885  1.00  0.00
ATOM    699  C   ASN    45       1.893 -25.018 -11.376  1.00  0.00
ATOM    700  O   ASN    45       1.989 -25.849 -10.466  1.00  0.00
ATOM    701  N   ALA    46       0.798 -24.256 -11.582  1.00  0.00
ATOM    702  HN  ALA    46       0.750 -23.746 -12.414  1.00  0.00
ATOM    703  CA  ALA    46      -0.338 -24.151 -10.638  1.00  0.00
ATOM    704  HA  ALA    46       0.060 -23.852  -9.672  1.00  0.00
ATOM    705  CB  ALA    46      -1.298 -23.046 -11.110  1.00  0.00
ATOM    706  HB1 ALA    46      -2.094 -22.908 -10.387  1.00  0.00
ATOM    707  HB2 ALA    46      -1.728 -23.316 -12.068  1.00  0.00
ATOM    708  HB3 ALA    46      -0.757 -22.114 -11.218  1.00  0.00
ATOM    709  C   ALA    46      -1.103 -25.482 -10.467  1.00  0.00
ATOM    710  O   ALA    46      -1.540 -25.816  -9.361  1.00  0.00
ATOM    711  N   ALA    47      -1.235 -26.238 -11.569  1.00  0.00
ATOM    712  HN  ALA    47      -0.755 -25.965 -12.382  1.00  0.00
ATOM    713  CA  ALA    47      -2.052 -27.468 -11.611  1.00  0.00
ATOM    714  HA  ALA    47      -3.072 -27.190 -11.352  1.00  0.00
ATOM    715  CB  ALA    47      -2.072 -28.062 -13.023  1.00  0.00
ATOM    716  HB1 ALA    47      -1.077 -28.410 -13.288  1.00  0.00
ATOM    717  HB2 ALA    47      -2.388 -27.309 -13.732  1.00  0.00
ATOM    718  HB3 ALA    47      -2.766 -28.896 -13.059  1.00  0.00
ATOM    719  C   ALA    47      -1.556 -28.516 -10.610  1.00  0.00
ATOM    720  O   ALA    47      -2.352 -29.223  -9.997  1.00  0.00
ATOM    721  N   GLU    48      -0.233 -28.614 -10.469  1.00  0.00
ATOM    722  HN  GLU    48       0.342 -28.017 -11.000  1.00  0.00
ATOM    723  CA  GLU    48       0.402 -29.568  -9.545  1.00  0.00
ATOM    724  HA  GLU    48      -0.139 -30.512  -9.619  1.00  0.00
ATOM    725  CB  GLU    48       1.867 -29.812  -9.970  1.00  0.00
ATOM    726  HB1 GLU    48       2.267 -30.649  -9.402  1.00  0.00
ATOM    727  HB2 GLU    48       2.450 -28.928  -9.739  1.00  0.00
ATOM    728  CG  GLU    48       2.051 -30.115 -11.465  1.00  0.00
ATOM    729  HG1 GLU    48       1.758 -29.236 -12.036  1.00  0.00
ATOM    730  HG2 GLU    48       1.391 -30.934 -11.741  1.00  0.00
ATOM    731  CD  GLU    48       3.504 -30.470 -11.823  1.00  0.00
ATOM    732  OE1 GLU    48       4.355 -29.560 -11.862  1.00  0.00
ATOM    733  OE2 GLU    48       3.797 -31.653 -12.083  1.00  0.00
ATOM    734  C   GLU    48       0.311 -29.068  -8.083  1.00  0.00
ATOM    735  O   GLU    48       0.176 -29.872  -7.152  1.00  0.00
ATOM    736  N   ILE    49       0.366 -27.724  -7.907  1.00  0.00
ATOM    737  HN  ILE    49       0.462 -27.157  -8.704  1.00  0.00
ATOM    738  CA  ILE    49       0.289 -27.064  -6.580  1.00  0.00
ATOM    739  HA  ILE    49       1.096 -27.457  -5.965  1.00  0.00
ATOM    740  CB  ILE    49       0.469 -25.495  -6.690  1.00  0.00
ATOM    741  HB  ILE    49      -0.315 -25.121  -7.346  1.00  0.00
ATOM    742  CG1 ILE    49       1.846 -25.144  -7.321  1.00  0.00
ATOM    743 HG11 ILE    49       1.937 -25.649  -8.277  1.00  0.00
ATOM    744 HG12 ILE    49       2.634 -25.501  -6.672  1.00  0.00
ATOM    745  CG2 ILE    49       0.297 -24.792  -5.316  1.00  0.00
ATOM    746 HG21 ILE    49       1.051 -25.147  -4.623  1.00  0.00
ATOM    747 HG22 ILE    49      -0.685 -25.006  -4.913  1.00  0.00
ATOM    748 HG23 ILE    49       0.399 -23.721  -5.439  1.00  0.00
ATOM    749  CD1 ILE    49       2.103 -23.670  -7.561  1.00  0.00
ATOM    750 HD11 ILE    49       1.338 -23.263  -8.208  1.00  0.00
ATOM    751 HD12 ILE    49       3.069 -23.547  -8.031  1.00  0.00
ATOM    752 HD13 ILE    49       2.098 -23.141  -6.619  1.00  0.00
ATOM    753  C   ILE    49      -1.055 -27.367  -5.898  1.00  0.00
ATOM    754  O   ILE    49      -1.088 -27.781  -4.727  1.00  0.00
ATOM    755  N   ARG    50      -2.158 -27.149  -6.646  1.00  0.00
ATOM    756  HN  ARG    50      -2.046 -26.855  -7.582  1.00  0.00
ATOM    757  CA  ARG    50      -3.520 -27.338  -6.116  1.00  0.00
ATOM    758  HA  ARG    50      -3.600 -26.716  -5.224  1.00  0.00
ATOM    759  CB  ARG    50      -4.611 -26.869  -7.122  1.00  0.00
ATOM    760  HB1 ARG    50      -4.481 -25.804  -7.291  1.00  0.00
ATOM    761  HB2 ARG    50      -5.590 -27.021  -6.675  1.00  0.00
ATOM    762  CG  ARG    50      -4.592 -27.580  -8.493  1.00  0.00
ATOM    763  HG1 ARG    50      -4.813 -28.633  -8.340  1.00  0.00
ATOM    764  HG2 ARG    50      -3.598 -27.490  -8.915  1.00  0.00
ATOM    765  CD  ARG    50      -5.596 -27.004  -9.492  1.00  0.00
ATOM    766  HD1 ARG    50      -5.375 -25.950  -9.646  1.00  0.00
ATOM    767  HD2 ARG    50      -6.595 -27.100  -9.080  1.00  0.00
ATOM    768  NE  ARG    50      -5.558 -27.703 -10.798  1.00  0.00
ATOM    769  HE  ARG    50      -5.351 -28.667 -10.777  1.00  0.00
ATOM    770  CZ  ARG    50      -5.793 -27.131 -11.995  1.00  0.00
ATOM    771  NH1 ARG    50      -6.067 -25.835 -12.087  1.00  0.00
ATOM    772 HH11 ARG    50      -6.107 -25.271 -11.264  1.00  0.00
ATOM    773 HH12 ARG    50      -6.224 -25.413 -12.988  1.00  0.00
ATOM    774  NH2 ARG    50      -5.749 -27.866 -13.097  1.00  0.00
ATOM    775 HH21 ARG    50      -5.543 -28.847 -13.045  1.00  0.00
ATOM    776 HH22 ARG    50      -5.925 -27.449 -13.992  1.00  0.00
ATOM    777  C   ARG    50      -3.740 -28.803  -5.705  1.00  0.00
ATOM    778  O   ARG    50      -4.128 -29.045  -4.574  1.00  0.00
ATOM    779  N   VAL    51      -3.408 -29.760  -6.610  1.00  0.00
ATOM    780  HN  VAL    51      -2.984 -29.477  -7.452  1.00  0.00
ATOM    781  CA  VAL    51      -3.637 -31.211  -6.391  1.00  0.00
ATOM    782  HA  VAL    51      -4.704 -31.352  -6.235  1.00  0.00
ATOM    783  CB  VAL    51      -3.214 -32.066  -7.648  1.00  0.00
ATOM    784  HB  VAL    51      -2.162 -31.866  -7.847  1.00  0.00
ATOM    785  CG1 VAL    51      -3.369 -33.593  -7.393  1.00  0.00
ATOM    786 HG11 VAL    51      -4.403 -33.823  -7.163  1.00  0.00
ATOM    787 HG12 VAL    51      -2.745 -33.892  -6.559  1.00  0.00
ATOM    788 HG13 VAL    51      -3.067 -34.144  -8.275  1.00  0.00
ATOM    789  CG2 VAL    51      -4.019 -31.637  -8.900  1.00  0.00
ATOM    790 HG21 VAL    51      -5.072 -31.835  -8.747  1.00  0.00
ATOM    791 HG22 VAL    51      -3.674 -32.188  -9.766  1.00  0.00
ATOM    792 HG23 VAL    51      -3.881 -30.576  -9.080  1.00  0.00
ATOM    793  C   VAL    51      -2.891 -31.695  -5.136  1.00  0.00
ATOM    794  O   VAL    51      -3.461 -32.419  -4.314  1.00  0.00
ATOM    795  N   ARG    52      -1.635 -31.228  -4.987  1.00  0.00
ATOM    796  HN  ARG    52      -1.264 -30.665  -5.700  1.00  0.00
ATOM    797  CA  ARG    52      -0.787 -31.528  -3.816  1.00  0.00
ATOM    798  HA  ARG    52      -0.610 -32.599  -3.805  1.00  0.00
ATOM    799  CB  ARG    52       0.581 -30.793  -3.923  1.00  0.00
ATOM    800  HB1 ARG    52       0.399 -29.724  -3.949  1.00  0.00
ATOM    801  HB2 ARG    52       1.051 -31.077  -4.858  1.00  0.00
ATOM    802  CG  ARG    52       1.589 -31.090  -2.777  1.00  0.00
ATOM    803  HG1 ARG    52       1.032 -31.227  -1.851  1.00  0.00
ATOM    804  HG2 ARG    52       2.244 -30.234  -2.662  1.00  0.00
ATOM    805  CD  ARG    52       2.462 -32.347  -3.023  1.00  0.00
ATOM    806  HD1 ARG    52       3.163 -32.435  -2.209  1.00  0.00
ATOM    807  HD2 ARG    52       3.018 -32.207  -3.944  1.00  0.00
ATOM    808  NE  ARG    52       1.695 -33.613  -3.138  1.00  0.00
ATOM    809  HE  ARG    52       0.724 -33.541  -3.267  1.00  0.00
ATOM    810  CZ  ARG    52       2.234 -34.846  -3.134  1.00  0.00
ATOM    811  NH1 ARG    52       3.523 -35.031  -2.888  1.00  0.00
ATOM    812 HH11 ARG    52       4.121 -34.248  -2.699  1.00  0.00
ATOM    813 HH12 ARG    52       3.910 -35.958  -2.895  1.00  0.00
ATOM    814  NH2 ARG    52       1.462 -35.896  -3.349  1.00  0.00
ATOM    815 HH21 ARG    52       0.479 -35.774  -3.517  1.00  0.00
ATOM    816 HH22 ARG    52       1.850 -36.820  -3.358  1.00  0.00
ATOM    817  C   ARG    52      -1.503 -31.133  -2.509  1.00  0.00
ATOM    818  O   ARG    52      -1.497 -31.883  -1.526  1.00  0.00
ATOM    819  N   HIS    53      -2.128 -29.944  -2.525  1.00  0.00
ATOM    820  HN  HIS    53      -2.103 -29.412  -3.355  1.00  0.00
ATOM    821  CA  HIS    53      -2.855 -29.406  -1.362  1.00  0.00
ATOM    822  HA  HIS    53      -2.267 -29.645  -0.476  1.00  0.00
ATOM    823  CB  HIS    53      -2.965 -27.871  -1.457  1.00  0.00
ATOM    824  HB1 HIS    53      -3.635 -27.503  -0.681  1.00  0.00
ATOM    825  HB2 HIS    53      -3.366 -27.600  -2.427  1.00  0.00
ATOM    826  CG  HIS    53      -1.648 -27.161  -1.283  1.00  0.00
ATOM    827  ND1 HIS    53      -1.079 -26.368  -2.258  1.00  0.00
ATOM    828  HD1 HIS    53      -1.440 -26.224  -3.161  1.00  0.00
ATOM    829  CD2 HIS    53      -0.817 -27.093  -0.214  1.00  0.00
ATOM    830  HD2 HIS    53      -0.952 -27.596   0.738  1.00  0.00
ATOM    831  CE1 HIS    53       0.038 -25.842  -1.797  1.00  0.00
ATOM    832  HE1 HIS    53       0.695 -25.175  -2.338  1.00  0.00
ATOM    833  NE2 HIS    53       0.216 -26.263  -0.560  1.00  0.00
ATOM    834  HE2 HIS    53       0.983 -26.034   0.015  1.00  0.00
ATOM    835  C   HIS    53      -4.242 -30.048  -1.190  1.00  0.00
ATOM    836  O   HIS    53      -4.702 -30.155  -0.073  1.00  0.00
ATOM    837  N   ILE    54      -4.888 -30.480  -2.288  1.00  0.00
ATOM    838  HN  ILE    54      -4.454 -30.385  -3.158  1.00  0.00
ATOM    839  CA  ILE    54      -6.223 -31.128  -2.237  1.00  0.00
ATOM    840  HA  ILE    54      -6.912 -30.438  -1.750  1.00  0.00
ATOM    841  CB  ILE    54      -6.754 -31.421  -3.692  1.00  0.00
ATOM    842  HB  ILE    54      -5.970 -31.954  -4.221  1.00  0.00
ATOM    843  CG1 ILE    54      -7.043 -30.094  -4.455  1.00  0.00
ATOM    844 HG11 ILE    54      -6.175 -29.451  -4.396  1.00  0.00
ATOM    845 HG12 ILE    54      -7.875 -29.586  -3.988  1.00  0.00
ATOM    846  CG2 ILE    54      -8.005 -32.322  -3.689  1.00  0.00
ATOM    847 HG21 ILE    54      -8.326 -32.509  -4.706  1.00  0.00
ATOM    848 HG22 ILE    54      -8.805 -31.837  -3.149  1.00  0.00
ATOM    849 HG23 ILE    54      -7.775 -33.267  -3.209  1.00  0.00
ATOM    850  CD1 ILE    54      -7.383 -30.256  -5.923  1.00  0.00
ATOM    851 HD11 ILE    54      -6.574 -30.774  -6.425  1.00  0.00
ATOM    852 HD12 ILE    54      -7.516 -29.281  -6.368  1.00  0.00
ATOM    853 HD13 ILE    54      -8.294 -30.825  -6.023  1.00  0.00
ATOM    854  C   ILE    54      -6.139 -32.425  -1.408  1.00  0.00
ATOM    855  O   ILE    54      -7.042 -32.737  -0.627  1.00  0.00
ATOM    856  N   GLU    55      -5.011 -33.137  -1.584  1.00  0.00
ATOM    857  HN  GLU    55      -4.387 -32.842  -2.287  1.00  0.00
ATOM    858  CA  GLU    55      -4.661 -34.337  -0.799  1.00  0.00
ATOM    859  HA  GLU    55      -5.442 -35.081  -0.961  1.00  0.00
ATOM    860  CB  GLU    55      -3.309 -34.900  -1.311  1.00  0.00
ATOM    861  HB1 GLU    55      -3.057 -35.796  -0.746  1.00  0.00
ATOM    862  HB2 GLU    55      -2.533 -34.154  -1.141  1.00  0.00
ATOM    863  CG  GLU    55      -3.303 -35.260  -2.811  1.00  0.00
ATOM    864  HG1 GLU    55      -3.646 -34.396  -3.377  1.00  0.00
ATOM    865  HG2 GLU    55      -3.998 -36.075  -2.980  1.00  0.00
ATOM    866  CD  GLU    55      -1.912 -35.671  -3.321  1.00  0.00
ATOM    867  OE1 GLU    55      -1.504 -36.835  -3.108  1.00  0.00
ATOM    868  OE2 GLU    55      -1.201 -34.826  -3.908  1.00  0.00
ATOM    869  C   GLU    55      -4.589 -34.001   0.707  1.00  0.00
ATOM    870  O   GLU    55      -5.053 -34.776   1.547  1.00  0.00
ATOM    871  N   ARG    56      -4.022 -32.822   1.019  1.00  0.00
ATOM    872  HN  ARG    56      -3.640 -32.283   0.290  1.00  0.00
ATOM    873  CA  ARG    56      -3.933 -32.309   2.403  1.00  0.00
ATOM    874  HA  ARG    56      -3.552 -33.117   3.025  1.00  0.00
ATOM    875  CB  ARG    56      -2.925 -31.123   2.465  1.00  0.00
ATOM    876  HB1 ARG    56      -3.324 -30.300   1.880  1.00  0.00
ATOM    877  HB2 ARG    56      -1.991 -31.438   2.009  1.00  0.00
ATOM    878  CG  ARG    56      -2.610 -30.595   3.886  1.00  0.00
ATOM    879  HG1 ARG    56      -3.521 -30.187   4.312  1.00  0.00
ATOM    880  HG2 ARG    56      -1.874 -29.805   3.809  1.00  0.00
ATOM    881  CD  ARG    56      -2.065 -31.690   4.833  1.00  0.00
ATOM    882  HD1 ARG    56      -2.833 -32.446   4.967  1.00  0.00
ATOM    883  HD2 ARG    56      -1.841 -31.244   5.798  1.00  0.00
ATOM    884  NE  ARG    56      -0.838 -32.328   4.315  1.00  0.00
ATOM    885  HE  ARG    56      -0.259 -31.772   3.752  1.00  0.00
ATOM    886  CZ  ARG    56      -0.454 -33.590   4.565  1.00  0.00
ATOM    887  NH1 ARG    56      -1.223 -34.418   5.262  1.00  0.00
ATOM    888 HH11 ARG    56      -2.117 -34.112   5.603  1.00  0.00
ATOM    889 HH12 ARG    56      -0.919 -35.355   5.446  1.00  0.00
ATOM    890  NH2 ARG    56       0.694 -34.032   4.076  1.00  0.00
ATOM    891 HH21 ARG    56       1.269 -33.433   3.517  1.00  0.00
ATOM    892 HH22 ARG    56       0.996 -34.974   4.261  1.00  0.00
ATOM    893  C   ARG    56      -5.334 -31.891   2.936  1.00  0.00
ATOM    894  O   ARG    56      -5.620 -32.033   4.128  1.00  0.00
ATOM    895  N   PHE    57      -6.204 -31.392   2.029  1.00  0.00
ATOM    896  HN  PHE    57      -5.910 -31.324   1.097  1.00  0.00
ATOM    897  CA  PHE    57      -7.585 -30.948   2.363  1.00  0.00
ATOM    898  HA  PHE    57      -7.532 -30.378   3.288  1.00  0.00
ATOM    899  CB  PHE    57      -8.155 -30.015   1.240  1.00  0.00
ATOM    900  HB1 PHE    57      -9.239 -29.995   1.315  1.00  0.00
ATOM    901  HB2 PHE    57      -7.892 -30.433   0.277  1.00  0.00
ATOM    902  CG  PHE    57      -7.661 -28.555   1.239  1.00  0.00
ATOM    903  CD1 PHE    57      -6.323 -28.234   1.443  1.00  0.00
ATOM    904  HD1 PHE    57      -5.612 -29.028   1.633  1.00  0.00
ATOM    905  CD2 PHE    57      -8.549 -27.500   0.998  1.00  0.00
ATOM    906  HD2 PHE    57      -9.600 -27.716   0.836  1.00  0.00
ATOM    907  CE1 PHE    57      -5.887 -26.925   1.408  1.00  0.00
ATOM    908  HE1 PHE    57      -4.841 -26.702   1.568  1.00  0.00
ATOM    909  CE2 PHE    57      -8.111 -26.188   0.969  1.00  0.00
ATOM    910  HE2 PHE    57      -8.813 -25.386   0.782  1.00  0.00
ATOM    911  CZ  PHE    57      -6.779 -25.904   1.172  1.00  0.00
ATOM    912  HZ  PHE    57      -6.434 -24.879   1.146  1.00  0.00
ATOM    913  C   PHE    57      -8.536 -32.152   2.606  1.00  0.00
ATOM    914  O   PHE    57      -9.682 -31.953   3.023  1.00  0.00
ATOM    915  N   LYS    58      -8.074 -33.393   2.318  1.00  0.00
ATOM    916  HN  LYS    58      -7.206 -33.481   1.866  1.00  0.00
ATOM    917  CA  LYS    58      -8.839 -34.627   2.627  1.00  0.00
ATOM    918  HA  LYS    58      -9.859 -34.477   2.281  1.00  0.00
ATOM    919  CB  LYS    58      -8.243 -35.850   1.885  1.00  0.00
ATOM    920  HB1 LYS    58      -8.840 -36.730   2.113  1.00  0.00
ATOM    921  HB2 LYS    58      -7.231 -36.015   2.245  1.00  0.00
ATOM    922  CG  LYS    58      -8.181 -35.689   0.356  1.00  0.00
ATOM    923  HG1 LYS    58      -7.812 -36.613  -0.078  1.00  0.00
ATOM    924  HG2 LYS    58      -7.483 -34.889   0.124  1.00  0.00
ATOM    925  CD  LYS    58      -9.552 -35.346  -0.276  1.00  0.00
ATOM    926  HD1 LYS    58      -9.987 -34.502   0.249  1.00  0.00
ATOM    927  HD2 LYS    58     -10.211 -36.201  -0.182  1.00  0.00
ATOM    928  CE  LYS    58      -9.426 -34.987  -1.757  1.00  0.00
ATOM    929  HE1 LYS    58      -9.070 -35.848  -2.300  1.00  0.00
ATOM    930  HE2 LYS    58      -8.711 -34.181  -1.866  1.00  0.00
ATOM    931  NZ  LYS    58     -10.715 -34.548  -2.334  1.00  0.00
ATOM    932  HZ1 LYS    58     -11.058 -33.699  -1.837  1.00  0.00
ATOM    933  HZ2 LYS    58     -11.426 -35.302  -2.237  1.00  0.00
ATOM    934  HZ3 LYS    58     -10.596 -34.324  -3.338  1.00  0.00
ATOM    935  C   LYS    58      -8.880 -34.902   4.139  1.00  0.00
ATOM    936  O   LYS    58      -9.810 -35.558   4.624  1.00  0.00
ATOM    937  N   GLU    59      -7.848 -34.424   4.866  1.00  0.00
ATOM    938  HN  GLU    59      -7.096 -34.001   4.395  1.00  0.00
ATOM    939  CA  GLU    59      -7.802 -34.505   6.334  1.00  0.00
ATOM    940  HA  GLU    59      -8.011 -35.534   6.612  1.00  0.00
ATOM    941  CB  GLU    59      -6.395 -34.117   6.888  1.00  0.00
ATOM    942  HB1 GLU    59      -6.483 -33.914   7.951  1.00  0.00
ATOM    943  HB2 GLU    59      -6.068 -33.205   6.395  1.00  0.00
ATOM    944  CG  GLU    59      -5.294 -35.190   6.700  1.00  0.00
ATOM    945  HG1 GLU    59      -5.636 -36.116   7.159  1.00  0.00
ATOM    946  HG2 GLU    59      -4.403 -34.863   7.228  1.00  0.00
ATOM    947  CD  GLU    59      -4.917 -35.468   5.229  1.00  0.00
ATOM    948  OE1 GLU    59      -5.500 -36.392   4.608  1.00  0.00
ATOM    949  OE2 GLU    59      -4.030 -34.772   4.698  1.00  0.00
ATOM    950  C   GLU    59      -8.893 -33.597   6.933  1.00  0.00
ATOM    951  O   GLU    59      -8.849 -32.384   6.724  1.00  0.00
ATOM    952  N   PRO    60      -9.906 -34.161   7.674  1.00  0.00
ATOM    953  CA  PRO    60     -10.942 -33.342   8.356  1.00  0.00
ATOM    954  HA  PRO    60     -11.427 -32.665   7.661  1.00  0.00
ATOM    955  CB  PRO    60     -11.959 -34.398   8.862  1.00  0.00
ATOM    956  HB1 PRO    60     -12.746 -34.531   8.122  1.00  0.00
ATOM    957  HB2 PRO    60     -12.407 -34.076   9.797  1.00  0.00
ATOM    958  CG  PRO    60     -11.148 -35.653   9.029  1.00  0.00
ATOM    959  HG1 PRO    60     -11.783 -36.527   8.927  1.00  0.00
ATOM    960  HG2 PRO    60     -10.668 -35.659  10.006  1.00  0.00
ATOM    961  CD  PRO    60     -10.112 -35.619   7.924  1.00  0.00
ATOM    962  HD1 PRO    60     -10.484 -36.107   7.030  1.00  0.00
ATOM    963  HD2 PRO    60      -9.189 -36.089   8.251  1.00  0.00
ATOM    964  C   PRO    60     -10.324 -32.526   9.518  1.00  0.00
ATOM    965  O   PRO    60     -10.854 -31.489   9.933  1.00  0.00
ATOM    966  N   ASP    61      -9.169 -33.022   9.991  1.00  0.00
ATOM    967  HN  ASP    61      -8.815 -33.826   9.561  1.00  0.00
ATOM    968  CA  ASP    61      -8.383 -32.455  11.093  1.00  0.00
ATOM    969  HA  ASP    61      -9.070 -32.015  11.810  1.00  0.00
ATOM    970  CB  ASP    61      -7.609 -33.601  11.794  1.00  0.00
ATOM    971  HB1 ASP    61      -8.322 -34.253  12.287  1.00  0.00
ATOM    972  HB2 ASP    61      -6.956 -33.183  12.556  1.00  0.00
ATOM    973  CG  ASP    61      -6.756 -34.455  10.824  1.00  0.00
ATOM    974  OD1 ASP    61      -5.547 -34.192  10.674  1.00  0.00
ATOM    975  OD2 ASP    61      -7.305 -35.406  10.215  1.00  0.00
ATOM    976  C   ASP    61      -7.413 -31.352  10.623  1.00  0.00
ATOM    977  O   ASP    61      -6.754 -30.720  11.462  1.00  0.00
ATOM    978  N   LEU    62      -7.318 -31.129   9.291  1.00  0.00
ATOM    979  HN  LEU    62      -7.811 -31.708   8.679  1.00  0.00
ATOM    980  CA  LEU    62      -6.494 -30.040   8.727  1.00  0.00
ATOM    981  HA  LEU    62      -5.474 -30.172   9.090  1.00  0.00
ATOM    982  CB  LEU    62      -6.475 -30.062   7.168  1.00  0.00
ATOM    983  HB1 LEU    62      -7.502 -30.058   6.817  1.00  0.00
ATOM    984  HB2 LEU    62      -6.010 -30.990   6.844  1.00  0.00
ATOM    985  CG  LEU    62      -5.719 -28.856   6.503  1.00  0.00
ATOM    986  HG  LEU    62      -6.098 -27.939   6.942  1.00  0.00
ATOM    987  CD1 LEU    62      -4.214 -28.898   6.824  1.00  0.00
ATOM    988 HD11 LEU    62      -3.776 -29.810   6.436  1.00  0.00
ATOM    989 HD12 LEU    62      -4.069 -28.860   7.897  1.00  0.00
ATOM    990 HD13 LEU    62      -3.724 -28.045   6.374  1.00  0.00
ATOM    991  CD2 LEU    62      -5.976 -28.767   4.987  1.00  0.00
ATOM    992 HD21 LEU    62      -5.614 -29.663   4.497  1.00  0.00
ATOM    993 HD22 LEU    62      -5.466 -27.904   4.578  1.00  0.00
ATOM    994 HD23 LEU    62      -7.039 -28.667   4.805  1.00  0.00
ATOM    995  C   LEU    62      -7.024 -28.673   9.193  1.00  0.00
ATOM    996  O   LEU    62      -8.181 -28.332   8.930  1.00  0.00
ATOM    997  N   TYR    63      -6.169 -27.902   9.876  1.00  0.00
ATOM    998  HN  TYR    63      -5.303 -28.282  10.141  1.00  0.00
ATOM    999  CA  TYR    63      -6.484 -26.522  10.257  1.00  0.00
ATOM   1000  HA  TYR    63      -7.120 -26.093   9.484  1.00  0.00
ATOM   1001  CB  TYR    63      -7.248 -26.497  11.610  1.00  0.00
ATOM   1002  HB1 TYR    63      -6.596 -26.860  12.393  1.00  0.00
ATOM   1003  HB2 TYR    63      -8.108 -27.157  11.545  1.00  0.00
ATOM   1004  CG  TYR    63      -7.756 -25.106  12.011  1.00  0.00
ATOM   1005  CD1 TYR    63      -8.895 -24.564  11.412  1.00  0.00
ATOM   1006  HD1 TYR    63      -9.432 -25.148  10.672  1.00  0.00
ATOM   1007  CD2 TYR    63      -7.089 -24.331  12.963  1.00  0.00
ATOM   1008  HD2 TYR    63      -6.204 -24.733  13.447  1.00  0.00
ATOM   1009  CE1 TYR    63      -9.355 -23.305  11.754  1.00  0.00
ATOM   1010  HE1 TYR    63     -10.241 -22.910  11.279  1.00  0.00
ATOM   1011  CE2 TYR    63      -7.548 -23.074  13.309  1.00  0.00
ATOM   1012  HE2 TYR    63      -7.014 -22.493  14.052  1.00  0.00
ATOM   1013  CZ  TYR    63      -8.674 -22.562  12.699  1.00  0.00
ATOM   1014  OH  TYR    63      -9.124 -21.307  13.039  1.00  0.00
ATOM   1015  HH  TYR    63      -8.371 -20.697  13.085  1.00  0.00
ATOM   1016  C   TYR    63      -5.186 -25.702  10.342  1.00  0.00
ATOM   1017  O   TYR    63      -4.316 -26.004  11.162  1.00  0.00
ATOM   1018  N   GLY    64      -5.066 -24.667   9.493  1.00  0.00
ATOM   1019  HN  GLY    64      -5.752 -24.532   8.814  1.00  0.00
ATOM   1020  CA  GLY    64      -3.939 -23.738   9.559  1.00  0.00
ATOM   1021  HA1 GLY    64      -3.723 -23.383   8.558  1.00  0.00
ATOM   1022  HA2 GLY    64      -3.058 -24.241   9.944  1.00  0.00
ATOM   1023  C   GLY    64      -4.286 -22.551  10.439  1.00  0.00
ATOM   1024  O   GLY    64      -5.040 -21.668  10.015  1.00  0.00
ATOM   1025  N   GLU    65      -3.767 -22.554  11.678  1.00  0.00
ATOM   1026  HN  GLU    65      -3.223 -23.324  11.955  1.00  0.00
ATOM   1027  CA  GLU    65      -3.981 -21.460  12.641  1.00  0.00
ATOM   1028  HA  GLU    65      -4.893 -20.934  12.359  1.00  0.00
ATOM   1029  CB  GLU    65      -4.157 -22.022  14.079  1.00  0.00
ATOM   1030  HB1 GLU    65      -3.276 -22.602  14.337  1.00  0.00
ATOM   1031  HB2 GLU    65      -5.016 -22.682  14.086  1.00  0.00
ATOM   1032  CG  GLU    65      -4.365 -20.940  15.164  1.00  0.00
ATOM   1033  HG1 GLU    65      -5.112 -20.237  14.811  1.00  0.00
ATOM   1034  HG2 GLU    65      -3.430 -20.404  15.301  1.00  0.00
ATOM   1035  CD  GLU    65      -4.810 -21.501  16.529  1.00  0.00
ATOM   1036  OE1 GLU    65      -3.973 -22.103  17.236  1.00  0.00
ATOM   1037  OE2 GLU    65      -5.989 -21.319  16.912  1.00  0.00
ATOM   1038  C   GLU    65      -2.805 -20.484  12.573  1.00  0.00
ATOM   1039  O   GLU    65      -1.716 -20.782  13.081  1.00  0.00
ATOM   1040  N   LEU    66      -3.025 -19.335  11.914  1.00  0.00
ATOM   1041  HN  LEU    66      -3.920 -19.164  11.554  1.00  0.00
ATOM   1042  CA  LEU    66      -1.977 -18.329  11.725  1.00  0.00
ATOM   1043  HA  LEU    66      -1.106 -18.842  11.325  1.00  0.00
ATOM   1044  CB  LEU    66      -2.394 -17.227  10.735  1.00  0.00
ATOM   1045  HB1 LEU    66      -3.212 -16.659  11.175  1.00  0.00
ATOM   1046  HB2 LEU    66      -2.770 -17.702   9.831  1.00  0.00
ATOM   1047  CG  LEU    66      -1.236 -16.235  10.348  1.00  0.00
ATOM   1048  HG  LEU    66      -0.560 -16.154  11.204  1.00  0.00
ATOM   1049  CD1 LEU    66      -0.385 -16.773   9.174  1.00  0.00
ATOM   1050 HD11 LEU    66       0.388 -16.056   8.929  1.00  0.00
ATOM   1051 HD12 LEU    66      -1.017 -16.932   8.304  1.00  0.00
ATOM   1052 HD13 LEU    66       0.076 -17.713   9.455  1.00  0.00
ATOM   1053  CD2 LEU    66      -1.774 -14.828  10.053  1.00  0.00
ATOM   1054 HD21 LEU    66      -2.436 -14.862   9.196  1.00  0.00
ATOM   1055 HD22 LEU    66      -0.950 -14.162   9.843  1.00  0.00
ATOM   1056 HD23 LEU    66      -2.318 -14.458  10.911  1.00  0.00
ATOM   1057  C   LEU    66      -1.596 -17.678  13.066  1.00  0.00
ATOM   1058  O   LEU    66      -2.457 -17.389  13.903  1.00  0.00
ATOM   1059  N   LEU    67      -0.296 -17.458  13.229  1.00  0.00
ATOM   1060  HN  LEU    67       0.304 -17.721  12.501  1.00  0.00
ATOM   1061  CA  LEU    67       0.300 -16.857  14.426  1.00  0.00
ATOM   1062  HA  LEU    67      -0.420 -16.849  15.242  1.00  0.00
ATOM   1063  CB  LEU    67       1.533 -17.710  14.815  1.00  0.00
ATOM   1064  HB1 LEU    67       1.818 -17.465  15.834  1.00  0.00
ATOM   1065  HB2 LEU    67       2.362 -17.437  14.158  1.00  0.00
ATOM   1066  CG  LEU    67       1.325 -19.248  14.715  1.00  0.00
ATOM   1067  HG  LEU    67       0.803 -19.457  13.785  1.00  0.00
ATOM   1068  CD1 LEU    67       2.662 -19.982  14.639  1.00  0.00
ATOM   1069 HD11 LEU    67       3.244 -19.789  15.531  1.00  0.00
ATOM   1070 HD12 LEU    67       3.205 -19.626  13.771  1.00  0.00
ATOM   1071 HD13 LEU    67       2.493 -21.046  14.539  1.00  0.00
ATOM   1072  CD2 LEU    67       0.450 -19.774  15.865  1.00  0.00
ATOM   1073 HD21 LEU    67      -0.520 -19.295  15.822  1.00  0.00
ATOM   1074 HD22 LEU    67       0.919 -19.555  16.815  1.00  0.00
ATOM   1075 HD23 LEU    67       0.324 -20.845  15.765  1.00  0.00
ATOM   1076  C   LEU    67       0.747 -15.437  14.081  1.00  0.00
ATOM   1077  O   LEU    67       0.355 -14.454  14.717  1.00  0.00
ATOM   1078  N   THR    68       1.537 -15.371  13.005  1.00  0.00
ATOM   1079  HN  THR    68       1.670 -16.197  12.483  1.00  0.00
ATOM   1080  CA  THR    68       2.230 -14.158  12.560  1.00  0.00
ATOM   1081  HA  THR    68       1.645 -13.294  12.870  1.00  0.00
ATOM   1082  CB  THR    68       3.651 -14.075  13.235  1.00  0.00
ATOM   1083  HB  THR    68       4.168 -15.016  13.050  1.00  0.00
ATOM   1084  OG1 THR    68       3.499 -13.930  14.661  1.00  0.00
ATOM   1085  HG1 THR    68       3.252 -13.020  14.868  1.00  0.00
ATOM   1086  CG2 THR    68       4.528 -12.927  12.695  1.00  0.00
ATOM   1087 HG21 THR    68       4.726 -13.084  11.641  1.00  0.00
ATOM   1088 HG22 THR    68       5.465 -12.902  13.233  1.00  0.00
ATOM   1089 HG23 THR    68       4.015 -11.981  12.824  1.00  0.00
ATOM   1090  C   THR    68       2.355 -14.164  11.029  1.00  0.00
ATOM   1091  O   THR    68       2.523 -15.218  10.420  1.00  0.00
ATOM   1092  N   ARG    69       2.257 -12.973  10.430  1.00  0.00
ATOM   1093  HN  ARG    69       2.025 -12.200  10.978  1.00  0.00
ATOM   1094  CA  ARG    69       2.482 -12.752   9.001  1.00  0.00
ATOM   1095  HA  ARG    69       3.107 -13.561   8.627  1.00  0.00
ATOM   1096  CB  ARG    69       1.137 -12.746   8.221  1.00  0.00
ATOM   1097  HB1 ARG    69       0.721 -13.750   8.239  1.00  0.00
ATOM   1098  HB2 ARG    69       1.324 -12.469   7.189  1.00  0.00
ATOM   1099  CG  ARG    69       0.092 -11.782   8.808  1.00  0.00
ATOM   1100  HG1 ARG    69       0.529 -10.788   8.858  1.00  0.00
ATOM   1101  HG2 ARG    69      -0.149 -12.105   9.814  1.00  0.00
ATOM   1102  CD  ARG    69      -1.205 -11.704   8.003  1.00  0.00
ATOM   1103  HD1 ARG    69      -1.619 -12.701   7.892  1.00  0.00
ATOM   1104  HD2 ARG    69      -0.986 -11.296   7.020  1.00  0.00
ATOM   1105  NE  ARG    69      -2.195 -10.844   8.682  1.00  0.00
ATOM   1106  HE  ARG    69      -2.097 -10.746   9.658  1.00  0.00
ATOM   1107  CZ  ARG    69      -3.204 -10.199   8.083  1.00  0.00
ATOM   1108  NH1 ARG    69      -3.389 -10.298   6.771  1.00  0.00
ATOM   1109 HH11 ARG    69      -2.775 -10.859   6.216  1.00  0.00
ATOM   1110 HH12 ARG    69      -4.145  -9.809   6.327  1.00  0.00
ATOM   1111  NH2 ARG    69      -4.023  -9.449   8.808  1.00  0.00
ATOM   1112 HH21 ARG    69      -3.895  -9.373   9.800  1.00  0.00
ATOM   1113 HH22 ARG    69      -4.775  -8.947   8.368  1.00  0.00
ATOM   1114  C   ARG    69       3.235 -11.423   8.819  1.00  0.00
ATOM   1115  O   ARG    69       2.846 -10.392   9.386  1.00  0.00
ATOM   1116  N   VAL    70       4.342 -11.464   8.066  1.00  0.00
ATOM   1117  HN  VAL    70       4.627 -12.333   7.703  1.00  0.00
ATOM   1118  CA  VAL    70       5.139 -10.268   7.727  1.00  0.00
ATOM   1119  HA  VAL    70       4.607  -9.388   8.089  1.00  0.00
ATOM   1120  CB  VAL    70       6.573 -10.288   8.399  1.00  0.00
ATOM   1121  HB  VAL    70       7.070  -9.362   8.142  1.00  0.00
ATOM   1122  CG1 VAL    70       6.464 -10.341   9.939  1.00  0.00
ATOM   1123 HG11 VAL    70       5.949 -11.249  10.237  1.00  0.00
ATOM   1124 HG12 VAL    70       5.908  -9.485  10.300  1.00  0.00
ATOM   1125 HG13 VAL    70       7.453 -10.331  10.382  1.00  0.00
ATOM   1126  CG2 VAL    70       7.456 -11.443   7.878  1.00  0.00
ATOM   1127 HG21 VAL    70       7.015 -12.395   8.154  1.00  0.00
ATOM   1128 HG22 VAL    70       8.449 -11.375   8.305  1.00  0.00
ATOM   1129 HG23 VAL    70       7.533 -11.390   6.797  1.00  0.00
ATOM   1130  C   VAL    70       5.254 -10.159   6.205  1.00  0.00
ATOM   1131  O   VAL    70       5.202 -11.171   5.510  1.00  0.00
ATOM   1132  N   ILE    71       5.408  -8.934   5.688  1.00  0.00
ATOM   1133  HN  ILE    71       5.460  -8.167   6.296  1.00  0.00
ATOM   1134  CA  ILE    71       5.504  -8.694   4.237  1.00  0.00
ATOM   1135  HA  ILE    71       5.712  -9.652   3.753  1.00  0.00
ATOM   1136  CB  ILE    71       4.140  -8.162   3.640  1.00  0.00
ATOM   1137  HB  ILE    71       3.419  -8.972   3.729  1.00  0.00
ATOM   1138  CG1 ILE    71       4.286  -7.810   2.124  1.00  0.00
ATOM   1139 HG11 ILE    71       4.695  -8.665   1.597  1.00  0.00
ATOM   1140 HG12 ILE    71       4.961  -6.973   2.010  1.00  0.00
ATOM   1141  CG2 ILE    71       3.573  -6.976   4.453  1.00  0.00
ATOM   1142 HG21 ILE    71       3.444  -7.275   5.485  1.00  0.00
ATOM   1143 HG22 ILE    71       2.614  -6.672   4.050  1.00  0.00
ATOM   1144 HG23 ILE    71       4.260  -6.140   4.406  1.00  0.00
ATOM   1145  CD1 ILE    71       2.987  -7.439   1.443  1.00  0.00
ATOM   1146 HD11 ILE    71       2.543  -6.583   1.935  1.00  0.00
ATOM   1147 HD12 ILE    71       2.301  -8.274   1.484  1.00  0.00
ATOM   1148 HD13 ILE    71       3.185  -7.192   0.410  1.00  0.00
ATOM   1149  C   ILE    71       6.677  -7.743   3.926  1.00  0.00
ATOM   1150  O   ILE    71       6.729  -6.606   4.414  1.00  0.00
ATOM   1151  N   VAL    72       7.647  -8.257   3.143  1.00  0.00
ATOM   1152  HN  VAL    72       7.561  -9.189   2.860  1.00  0.00
ATOM   1153  CA  VAL    72       8.823  -7.508   2.680  1.00  0.00
ATOM   1154  HA  VAL    72       8.838  -6.531   3.166  1.00  0.00
ATOM   1155  CB  VAL    72      10.159  -8.271   3.052  1.00  0.00
ATOM   1156  HB  VAL    72      10.197  -9.188   2.462  1.00  0.00
ATOM   1157  CG1 VAL    72      11.412  -7.431   2.695  1.00  0.00
ATOM   1158 HG11 VAL    72      11.407  -6.504   3.256  1.00  0.00
ATOM   1159 HG12 VAL    72      11.416  -7.203   1.634  1.00  0.00
ATOM   1160 HG13 VAL    72      12.309  -7.988   2.937  1.00  0.00
ATOM   1161  CG2 VAL    72      10.166  -8.680   4.549  1.00  0.00
ATOM   1162 HG21 VAL    72      11.070  -9.230   4.774  1.00  0.00
ATOM   1163 HG22 VAL    72       9.307  -9.308   4.762  1.00  0.00
ATOM   1164 HG23 VAL    72      10.121  -7.794   5.173  1.00  0.00
ATOM   1165  C   VAL    72       8.709  -7.316   1.152  1.00  0.00
ATOM   1166  O   VAL    72       9.061  -8.215   0.377  1.00  0.00
ATOM   1167  N   GLY    73       8.172  -6.154   0.742  1.00  0.00
ATOM   1168  HN  GLY    73       7.902  -5.501   1.421  1.00  0.00
ATOM   1169  CA  GLY    73       7.972  -5.828  -0.676  1.00  0.00
ATOM   1170  HA1 GLY    73       8.932  -5.852  -1.185  1.00  0.00
ATOM   1171  HA2 GLY    73       7.580  -4.822  -0.740  1.00  0.00
ATOM   1172  C   GLY    73       6.996  -6.771  -1.386  1.00  0.00
ATOM   1173  O   GLY    73       5.793  -6.767  -1.097  1.00  0.00
ATOM   1174  N   ASN    74       7.526  -7.594  -2.308  1.00  0.00
ATOM   1175  HN  ASN    74       8.498  -7.567  -2.448  1.00  0.00
ATOM   1176  CA  ASN    74       6.729  -8.548  -3.117  1.00  0.00
ATOM   1177  HA  ASN    74       5.713  -8.166  -3.186  1.00  0.00
ATOM   1178  CB  ASN    74       7.314  -8.665  -4.555  1.00  0.00
ATOM   1179  HB1 ASN    74       7.322  -7.683  -5.010  1.00  0.00
ATOM   1180  HB2 ASN    74       6.675  -9.315  -5.146  1.00  0.00
ATOM   1181  CG  ASN    74       8.750  -9.214  -4.594  1.00  0.00
ATOM   1182  OD1 ASN    74       9.585  -8.891  -3.742  1.00  0.00
ATOM   1183  ND2 ASN    74       9.037 -10.074  -5.557  1.00  0.00
ATOM   1184 HD21 ASN    74       8.325 -10.315  -6.189  1.00  0.00
ATOM   1185 HD22 ASN    74       9.943 -10.438  -5.598  1.00  0.00
ATOM   1186  C   ASN    74       6.680  -9.946  -2.463  1.00  0.00
ATOM   1187  O   ASN    74       6.224 -10.908  -3.082  1.00  0.00
ATOM   1188  N   VAL    75       7.108 -10.034  -1.201  1.00  0.00
ATOM   1189  HN  VAL    75       7.260  -9.199  -0.708  1.00  0.00
ATOM   1190  CA  VAL    75       7.309 -11.315  -0.489  1.00  0.00
ATOM   1191  HA  VAL    75       6.945 -12.129  -1.117  1.00  0.00
ATOM   1192  CB  VAL    75       8.848 -11.555  -0.195  1.00  0.00
ATOM   1193  HB  VAL    75       9.218 -10.684   0.349  1.00  0.00
ATOM   1194  CG1 VAL    75       9.087 -12.801   0.696  1.00  0.00
ATOM   1195 HG11 VAL    75       8.592 -12.672   1.653  1.00  0.00
ATOM   1196 HG12 VAL    75      10.147 -12.937   0.863  1.00  0.00
ATOM   1197 HG13 VAL    75       8.687 -13.683   0.207  1.00  0.00
ATOM   1198  CG2 VAL    75       9.662 -11.661  -1.510  1.00  0.00
ATOM   1199 HG21 VAL    75       9.314 -12.507  -2.091  1.00  0.00
ATOM   1200 HG22 VAL    75      10.714 -11.794  -1.282  1.00  0.00
ATOM   1201 HG23 VAL    75       9.541 -10.755  -2.094  1.00  0.00
ATOM   1202  C   VAL    75       6.515 -11.301   0.828  1.00  0.00
ATOM   1203  O   VAL    75       6.544 -10.301   1.540  1.00  0.00
ATOM   1204  N   VAL    76       5.783 -12.395   1.139  1.00  0.00
ATOM   1205  HN  VAL    76       5.728 -13.126   0.488  1.00  0.00
ATOM   1206  CA  VAL    76       5.064 -12.541   2.428  1.00  0.00
ATOM   1207  HA  VAL    76       5.338 -11.701   3.071  1.00  0.00
ATOM   1208  CB  VAL    76       3.493 -12.528   2.262  1.00  0.00
ATOM   1209  HB  VAL    76       3.200 -13.449   1.754  1.00  0.00
ATOM   1210  CG1 VAL    76       2.783 -12.508   3.646  1.00  0.00
ATOM   1211 HG11 VAL    76       1.711 -12.534   3.510  1.00  0.00
ATOM   1212 HG12 VAL    76       3.049 -11.606   4.184  1.00  0.00
ATOM   1213 HG13 VAL    76       3.086 -13.371   4.232  1.00  0.00
ATOM   1214  CG2 VAL    76       3.019 -11.344   1.389  1.00  0.00
ATOM   1215 HG21 VAL    76       3.486 -11.397   0.411  1.00  0.00
ATOM   1216 HG22 VAL    76       3.288 -10.408   1.859  1.00  0.00
ATOM   1217 HG23 VAL    76       1.945 -11.385   1.269  1.00  0.00
ATOM   1218  C   VAL    76       5.475 -13.854   3.126  1.00  0.00
ATOM   1219  O   VAL    76       5.559 -14.898   2.492  1.00  0.00
ATOM   1220  N   ILE    77       5.734 -13.766   4.433  1.00  0.00
ATOM   1221  HN  ILE    77       5.813 -12.878   4.816  1.00  0.00
ATOM   1222  CA  ILE    77       5.916 -14.910   5.337  1.00  0.00
ATOM   1223  HA  ILE    77       6.176 -15.798   4.765  1.00  0.00
ATOM   1224  CB  ILE    77       7.073 -14.588   6.362  1.00  0.00
ATOM   1225  HB  ILE    77       6.847 -13.610   6.770  1.00  0.00
ATOM   1226  CG1 ILE    77       8.463 -14.486   5.659  1.00  0.00
ATOM   1227 HG11 ILE    77       9.137 -13.928   6.297  1.00  0.00
ATOM   1228 HG12 ILE    77       8.355 -13.959   4.723  1.00  0.00
ATOM   1229  CG2 ILE    77       7.119 -15.560   7.574  1.00  0.00
ATOM   1230 HG21 ILE    77       7.923 -15.265   8.242  1.00  0.00
ATOM   1231 HG22 ILE    77       7.286 -16.571   7.234  1.00  0.00
ATOM   1232 HG23 ILE    77       6.178 -15.513   8.111  1.00  0.00
ATOM   1233  CD1 ILE    77       9.122 -15.813   5.355  1.00  0.00
ATOM   1234 HD11 ILE    77       8.436 -16.442   4.804  1.00  0.00
ATOM   1235 HD12 ILE    77       9.395 -16.301   6.279  1.00  0.00
ATOM   1236 HD13 ILE    77      10.007 -15.641   4.763  1.00  0.00
ATOM   1237  C   ILE    77       4.599 -15.127   6.100  1.00  0.00
ATOM   1238  O   ILE    77       4.265 -14.325   6.974  1.00  0.00
ATOM   1239  N   ASP    78       3.831 -16.161   5.735  1.00  0.00
ATOM   1240  HN  ASP    78       4.024 -16.623   4.895  1.00  0.00
ATOM   1241  CA  ASP    78       2.693 -16.628   6.545  1.00  0.00
ATOM   1242  HA  ASP    78       2.361 -15.800   7.176  1.00  0.00
ATOM   1243  CB  ASP    78       1.495 -17.090   5.663  1.00  0.00
ATOM   1244  HB1 ASP    78       0.808 -17.681   6.263  1.00  0.00
ATOM   1245  HB2 ASP    78       1.871 -17.715   4.859  1.00  0.00
ATOM   1246  CG  ASP    78       0.722 -15.907   5.051  1.00  0.00
ATOM   1247  OD1 ASP    78      -0.279 -15.444   5.664  1.00  0.00
ATOM   1248  OD2 ASP    78       1.123 -15.426   3.972  1.00  0.00
ATOM   1249  C   ASP    78       3.178 -17.755   7.453  1.00  0.00
ATOM   1250  O   ASP    78       3.447 -18.863   6.993  1.00  0.00
ATOM   1251  N   HIS    79       3.324 -17.435   8.743  1.00  0.00
ATOM   1252  HN  HIS    79       3.119 -16.519   9.012  1.00  0.00
ATOM   1253  CA  HIS    79       3.748 -18.381   9.770  1.00  0.00
ATOM   1254  HA  HIS    79       4.225 -19.233   9.284  1.00  0.00
ATOM   1255  CB  HIS    79       4.778 -17.711  10.721  1.00  0.00
ATOM   1256  HB1 HIS    79       4.334 -16.814  11.146  1.00  0.00
ATOM   1257  HB2 HIS    79       5.650 -17.421  10.147  1.00  0.00
ATOM   1258  CG  HIS    79       5.266 -18.576  11.867  1.00  0.00
ATOM   1259  ND1 HIS    79       5.141 -19.954  11.901  1.00  0.00
ATOM   1260  HD1 HIS    79       4.729 -20.508  11.208  1.00  0.00
ATOM   1261  CD2 HIS    79       5.881 -18.238  13.023  1.00  0.00
ATOM   1262  HD2 HIS    79       6.149 -17.237  13.337  1.00  0.00
ATOM   1263  CE1 HIS    79       5.651 -20.417  13.021  1.00  0.00
ATOM   1264  HE1 HIS    79       5.647 -21.450  13.340  1.00  0.00
ATOM   1265  NE2 HIS    79       6.108 -19.397  13.721  1.00  0.00
ATOM   1266  HE2 HIS    79       6.411 -19.446  14.651  1.00  0.00
ATOM   1267  C   HIS    79       2.505 -18.858  10.529  1.00  0.00
ATOM   1268  O   HIS    79       1.921 -18.112  11.330  1.00  0.00
ATOM   1269  N   GLU    80       2.124 -20.108  10.258  1.00  0.00
ATOM   1270  HN  GLU    80       2.686 -20.635   9.644  1.00  0.00
ATOM   1271  CA  GLU    80       0.924 -20.760  10.804  1.00  0.00
ATOM   1272  HA  GLU    80       0.514 -20.115  11.578  1.00  0.00
ATOM   1273  CB  GLU    80      -0.175 -20.959   9.682  1.00  0.00
ATOM   1274  HB1 GLU    80      -0.900 -20.154   9.758  1.00  0.00
ATOM   1275  HB2 GLU    80      -0.700 -21.893   9.862  1.00  0.00
ATOM   1276  CG  GLU    80       0.335 -20.987   8.215  1.00  0.00
ATOM   1277  HG1 GLU    80       0.813 -20.034   8.008  1.00  0.00
ATOM   1278  HG2 GLU    80      -0.520 -21.089   7.549  1.00  0.00
ATOM   1279  CD  GLU    80       1.327 -22.123   7.905  1.00  0.00
ATOM   1280  OE1 GLU    80       0.900 -23.297   7.853  1.00  0.00
ATOM   1281  OE2 GLU    80       2.529 -21.843   7.704  1.00  0.00
ATOM   1282  C   GLU    80       1.303 -22.088  11.480  1.00  0.00
ATOM   1283  O   GLU    80       2.444 -22.541  11.390  1.00  0.00
ATOM   1284  N   THR    81       0.341 -22.666  12.209  1.00  0.00
ATOM   1285  HN  THR    81      -0.501 -22.191  12.319  1.00  0.00
ATOM   1286  CA  THR    81       0.474 -23.983  12.842  1.00  0.00
ATOM   1287  HA  THR    81       1.480 -24.371  12.650  1.00  0.00
ATOM   1288  CB  THR    81       0.261 -23.908  14.389  1.00  0.00
ATOM   1289  HB  THR    81      -0.787 -23.710  14.592  1.00  0.00
ATOM   1290  OG1 THR    81       1.039 -22.837  14.930  1.00  0.00
ATOM   1291  HG1 THR    81       1.976 -23.062  14.888  1.00  0.00
ATOM   1292  CG2 THR    81       0.660 -25.216  15.097  1.00  0.00
ATOM   1293 HG21 THR    81       0.482 -25.123  16.161  1.00  0.00
ATOM   1294 HG22 THR    81       1.711 -25.421  14.928  1.00  0.00
ATOM   1295 HG23 THR    81       0.070 -26.040  14.711  1.00  0.00
ATOM   1296  C   THR    81      -0.563 -24.926  12.218  1.00  0.00
ATOM   1297  O   THR    81      -1.772 -24.750  12.420  1.00  0.00
ATOM   1298  N   VAL    82      -0.083 -25.896  11.437  1.00  0.00
ATOM   1299  HN  VAL    82       0.879 -25.935  11.288  1.00  0.00
ATOM   1300  CA  VAL    82      -0.929 -26.888  10.775  1.00  0.00
ATOM   1301  HA  VAL    82      -1.840 -26.394  10.432  1.00  0.00
ATOM   1302  CB  VAL    82      -0.208 -27.516   9.527  1.00  0.00
ATOM   1303  HB  VAL    82       0.646 -28.088   9.892  1.00  0.00
ATOM   1304  CG1 VAL    82      -1.137 -28.498   8.783  1.00  0.00
ATOM   1305 HG11 VAL    82      -1.435 -29.296   9.457  1.00  0.00
ATOM   1306 HG12 VAL    82      -0.621 -28.927   7.934  1.00  0.00
ATOM   1307 HG13 VAL    82      -2.021 -27.976   8.438  1.00  0.00
ATOM   1308  CG2 VAL    82       0.337 -26.425   8.585  1.00  0.00
ATOM   1309 HG21 VAL    82       0.824 -26.885   7.735  1.00  0.00
ATOM   1310 HG22 VAL    82       1.059 -25.812   9.117  1.00  0.00
ATOM   1311 HG23 VAL    82      -0.475 -25.799   8.238  1.00  0.00
ATOM   1312  C   VAL    82      -1.296 -28.010  11.758  1.00  0.00
ATOM   1313  O   VAL    82      -0.461 -28.864  12.069  1.00  0.00
ATOM   1314  N   THR    83      -2.536 -27.975  12.262  1.00  0.00
ATOM   1315  HN  THR    83      -3.078 -27.181  12.119  1.00  0.00
ATOM   1316  CA  THR    83      -3.105 -29.082  13.035  1.00  0.00
ATOM   1317  HA  THR    83      -2.412 -29.323  13.839  1.00  0.00
ATOM   1318  CB  THR    83      -4.481 -28.685  13.668  1.00  0.00
ATOM   1319  HB  THR    83      -5.160 -28.404  12.867  1.00  0.00
ATOM   1320  OG1 THR    83      -4.309 -27.544  14.529  1.00  0.00
ATOM   1321  HG1 THR    83      -3.679 -26.932  14.133  1.00  0.00
ATOM   1322  CG2 THR    83      -5.123 -29.845  14.468  1.00  0.00
ATOM   1323 HG21 THR    83      -4.452 -30.164  15.257  1.00  0.00
ATOM   1324 HG22 THR    83      -5.319 -30.683  13.809  1.00  0.00
ATOM   1325 HG23 THR    83      -6.058 -29.516  14.906  1.00  0.00
ATOM   1326  C   THR    83      -3.273 -30.305  12.114  1.00  0.00
ATOM   1327  O   THR    83      -3.958 -30.228  11.087  1.00  0.00
ATOM   1328  N   ARG    84      -2.578 -31.394  12.467  1.00  0.00
ATOM   1329  HN  ARG    84      -1.972 -31.324  13.232  1.00  0.00
ATOM   1330  CA  ARG    84      -2.657 -32.694  11.781  1.00  0.00
ATOM   1331  HA  ARG    84      -3.432 -32.655  11.018  1.00  0.00
ATOM   1332  CB  ARG    84      -1.281 -33.031  11.121  1.00  0.00
ATOM   1333  HB1 ARG    84      -1.383 -33.960  10.565  1.00  0.00
ATOM   1334  HB2 ARG    84      -0.548 -33.183  11.909  1.00  0.00
ATOM   1335  CG  ARG    84      -0.732 -31.946  10.157  1.00  0.00
ATOM   1336  HG1 ARG    84      -0.660 -31.004  10.698  1.00  0.00
ATOM   1337  HG2 ARG    84      -1.423 -31.826   9.334  1.00  0.00
ATOM   1338  CD  ARG    84       0.658 -32.295   9.587  1.00  0.00
ATOM   1339  HD1 ARG    84       0.579 -33.224   9.033  1.00  0.00
ATOM   1340  HD2 ARG    84       1.346 -32.434  10.413  1.00  0.00
ATOM   1341  NE  ARG    84       1.205 -31.246   8.692  1.00  0.00
ATOM   1342  HE  ARG    84       0.848 -30.336   8.810  1.00  0.00
ATOM   1343  CZ  ARG    84       2.180 -31.435   7.775  1.00  0.00
ATOM   1344  NH1 ARG    84       2.668 -32.650   7.536  1.00  0.00
ATOM   1345 HH11 ARG    84       2.318 -33.441   8.044  1.00  0.00
ATOM   1346 HH12 ARG    84       3.395 -32.782   6.857  1.00  0.00
ATOM   1347  NH2 ARG    84       2.654 -30.397   7.089  1.00  0.00
ATOM   1348 HH21 ARG    84       2.292 -29.477   7.252  1.00  0.00
ATOM   1349 HH22 ARG    84       3.387 -30.528   6.414  1.00  0.00
ATOM   1350  C   ARG    84      -3.039 -33.762  12.825  1.00  0.00
ATOM   1351  O   ARG    84      -3.453 -33.417  13.938  1.00  0.00
ATOM   1352  N   ASN    85      -2.949 -35.050  12.453  1.00  0.00
ATOM   1353  HN  ASN    85      -2.807 -35.252  11.503  1.00  0.00
ATOM   1354  CA  ASN    85      -3.068 -36.183  13.401  1.00  0.00
ATOM   1355  HA  ASN    85      -3.227 -35.777  14.401  1.00  0.00
ATOM   1356  CB  ASN    85      -4.278 -37.105  13.042  1.00  0.00
ATOM   1357  HB1 ASN    85      -4.060 -38.119  13.370  1.00  0.00
ATOM   1358  HB2 ASN    85      -4.403 -37.118  11.968  1.00  0.00
ATOM   1359  CG  ASN    85      -5.617 -36.685  13.664  1.00  0.00
ATOM   1360  OD1 ASN    85      -6.453 -37.533  13.983  1.00  0.00
ATOM   1361  ND2 ASN    85      -5.859 -35.394  13.817  1.00  0.00
ATOM   1362 HD21 ASN    85      -5.182 -34.752  13.529  1.00  0.00
ATOM   1363 HD22 ASN    85      -6.711 -35.132  14.223  1.00  0.00
ATOM   1364  C   ASN    85      -1.755 -36.982  13.410  1.00  0.00
ATOM   1365  O   ASN    85      -1.404 -37.632  12.418  1.00  0.00
ATOM   1366  N   PHE    86      -1.007 -36.881  14.523  1.00  0.00
ATOM   1367  HN  PHE    86      -1.294 -36.250  15.215  1.00  0.00
ATOM   1368  CA  PHE    86       0.217 -37.682  14.766  1.00  0.00
ATOM   1369  HA  PHE    86       0.519 -38.136  13.820  1.00  0.00
ATOM   1370  CB  PHE    86       1.375 -36.779  15.290  1.00  0.00
ATOM   1371  HB1 PHE    86       2.135 -37.406  15.746  1.00  0.00
ATOM   1372  HB2 PHE    86       0.983 -36.113  16.047  1.00  0.00
ATOM   1373  CG  PHE    86       2.077 -35.904  14.242  1.00  0.00
ATOM   1374  CD1 PHE    86       3.156 -35.097  14.611  1.00  0.00
ATOM   1375  HD1 PHE    86       3.492 -35.097  15.642  1.00  0.00
ATOM   1376  CD2 PHE    86       1.674 -35.879  12.903  1.00  0.00
ATOM   1377  HD2 PHE    86       0.841 -36.492  12.584  1.00  0.00
ATOM   1378  CE1 PHE    86       3.798 -34.301  13.681  1.00  0.00
ATOM   1379  HE1 PHE    86       4.630 -33.680  13.983  1.00  0.00
ATOM   1380  CE2 PHE    86       2.321 -35.081  11.980  1.00  0.00
ATOM   1381  HE2 PHE    86       1.997 -35.076  10.951  1.00  0.00
ATOM   1382  CZ  PHE    86       3.381 -34.297  12.368  1.00  0.00
ATOM   1383  HZ  PHE    86       3.888 -33.670  11.641  1.00  0.00
ATOM   1384  C   PHE    86      -0.083 -38.813  15.772  1.00  0.00
ATOM   1385  O   PHE    86      -0.908 -38.631  16.671  1.00  0.00
ATOM   1386  N   PRO    87       0.586 -40.007  15.644  1.00  0.00
ATOM   1387  CA  PRO    87       0.304 -41.188  16.506  1.00  0.00
ATOM   1388  HA  PRO    87      -0.753 -41.430  16.487  1.00  0.00
ATOM   1389  CB  PRO    87       1.090 -42.324  15.810  1.00  0.00
ATOM   1390  HB1 PRO    87       0.450 -42.828  15.088  1.00  0.00
ATOM   1391  HB2 PRO    87       1.439 -43.050  16.538  1.00  0.00
ATOM   1392  CG  PRO    87       2.225 -41.625  15.135  1.00  0.00
ATOM   1393  HG1 PRO    87       2.594 -42.216  14.303  1.00  0.00
ATOM   1394  HG2 PRO    87       3.031 -41.449  15.847  1.00  0.00
ATOM   1395  CD  PRO    87       1.650 -40.316  14.643  1.00  0.00
ATOM   1396  HD1 PRO    87       1.221 -40.430  13.654  1.00  0.00
ATOM   1397  HD2 PRO    87       2.411 -39.543  14.634  1.00  0.00
ATOM   1398  C   PRO    87       0.735 -41.013  17.986  1.00  0.00
ATOM   1399  O   PRO    87       0.406 -41.861  18.826  1.00  0.00
ATOM   1400  N   GLU    88       1.487 -39.932  18.296  1.00  0.00
ATOM   1401  HN  GLU    88       1.811 -39.361  17.568  1.00  0.00
ATOM   1402  CA  GLU    88       1.846 -39.587  19.694  1.00  0.00
ATOM   1403  HA  GLU    88       1.801 -40.508  20.274  1.00  0.00
ATOM   1404  CB  GLU    88       3.298 -39.019  19.810  1.00  0.00
ATOM   1405  HB1 GLU    88       3.992 -39.824  19.590  1.00  0.00
ATOM   1406  HB2 GLU    88       3.468 -38.713  20.839  1.00  0.00
ATOM   1407  CG  GLU    88       3.637 -37.816  18.889  1.00  0.00
ATOM   1408  HG1 GLU    88       4.235 -37.099  19.455  1.00  0.00
ATOM   1409  HG2 GLU    88       2.711 -37.325  18.599  1.00  0.00
ATOM   1410  CD  GLU    88       4.401 -38.201  17.607  1.00  0.00
ATOM   1411  OE1 GLU    88       3.776 -38.731  16.671  1.00  0.00
ATOM   1412  OE2 GLU    88       5.635 -37.981  17.541  1.00  0.00
ATOM   1413  C   GLU    88       0.823 -38.610  20.322  1.00  0.00
ATOM   1414  O   GLU    88       0.815 -38.439  21.545  1.00  0.00
ATOM   1415  N   GLY    89      -0.036 -37.962  19.498  1.00  0.00
ATOM   1416  HN  GLY    89       0.070 -38.056  18.526  1.00  0.00
ATOM   1417  CA  GLY    89      -1.120 -37.115  20.036  1.00  0.00
ATOM   1418  HA1 GLY    89      -0.733 -36.528  20.864  1.00  0.00
ATOM   1419  HA2 GLY    89      -1.902 -37.760  20.417  1.00  0.00
ATOM   1420  C   GLY    89      -1.738 -36.173  19.008  1.00  0.00
ATOM   1421  O   GLY    89      -2.265 -36.634  17.995  1.00  0.00
ATOM   1422  N   LYS    90      -1.688 -34.849  19.296  1.00  0.00
ATOM   1423  HN  LYS    90      -1.292 -34.580  20.148  1.00  0.00
ATOM   1424  CA  LYS    90      -2.228 -33.784  18.429  1.00  0.00
ATOM   1425  HA  LYS    90      -3.308 -33.929  18.384  1.00  0.00
ATOM   1426  CB  LYS    90      -1.953 -32.399  19.091  1.00  0.00
ATOM   1427  HB1 LYS    90      -0.889 -32.329  19.303  1.00  0.00
ATOM   1428  HB2 LYS    90      -2.482 -32.361  20.036  1.00  0.00
ATOM   1429  CG  LYS    90      -2.358 -31.147  18.270  1.00  0.00
ATOM   1430  HG1 LYS    90      -1.761 -31.127  17.361  1.00  0.00
ATOM   1431  HG2 LYS    90      -2.120 -30.263  18.854  1.00  0.00
ATOM   1432  CD  LYS    90      -3.857 -31.081  17.883  1.00  0.00
ATOM   1433  HD1 LYS    90      -4.078 -31.901  17.205  1.00  0.00
ATOM   1434  HD2 LYS    90      -4.036 -30.146  17.364  1.00  0.00
ATOM   1435  CE  LYS    90      -4.812 -31.157  19.088  1.00  0.00
ATOM   1436  HE1 LYS    90      -4.460 -30.494  19.864  1.00  0.00
ATOM   1437  HE2 LYS    90      -4.825 -32.172  19.468  1.00  0.00
ATOM   1438  NZ  LYS    90      -6.199 -30.777  18.717  1.00  0.00
ATOM   1439  HZ1 LYS    90      -6.576 -31.434  18.006  1.00  0.00
ATOM   1440  HZ2 LYS    90      -6.210 -29.813  18.321  1.00  0.00
ATOM   1441  HZ3 LYS    90      -6.816 -30.796  19.553  1.00  0.00
ATOM   1442  C   LYS    90      -1.669 -33.871  16.986  1.00  0.00
ATOM   1443  O   LYS    90      -2.296 -34.497  16.132  1.00  0.00
ATOM   1444  N   GLY    91      -0.478 -33.289  16.736  1.00  0.00
ATOM   1445  HN  GLY    91       0.003 -32.854  17.467  1.00  0.00
ATOM   1446  CA  GLY    91       0.113 -33.291  15.396  1.00  0.00
ATOM   1447  HA1 GLY    91      -0.475 -33.914  14.730  1.00  0.00
ATOM   1448  HA2 GLY    91       1.103 -33.721  15.472  1.00  0.00
ATOM   1449  C   GLY    91       0.249 -31.907  14.791  1.00  0.00
ATOM   1450  O   GLY    91       0.259 -31.760  13.567  1.00  0.00
ATOM   1451  N   GLU    92       0.402 -30.891  15.643  1.00  0.00
ATOM   1452  HN  GLU    92       0.538 -31.090  16.594  1.00  0.00
ATOM   1453  CA  GLU    92       0.411 -29.488  15.201  1.00  0.00
ATOM   1454  HA  GLU    92      -0.198 -29.405  14.301  1.00  0.00
ATOM   1455  CB  GLU    92      -0.210 -28.587  16.309  1.00  0.00
ATOM   1456  HB1 GLU    92      -1.247 -28.882  16.459  1.00  0.00
ATOM   1457  HB2 GLU    92      -0.200 -27.559  15.966  1.00  0.00
ATOM   1458  CG  GLU    92       0.511 -28.654  17.679  1.00  0.00
ATOM   1459  HG1 GLU    92       1.559 -28.392  17.534  1.00  0.00
ATOM   1460  HG2 GLU    92       0.465 -29.680  18.035  1.00  0.00
ATOM   1461  CD  GLU    92      -0.076 -27.730  18.754  1.00  0.00
ATOM   1462  OE1 GLU    92      -0.596 -28.231  19.775  1.00  0.00
ATOM   1463  OE2 GLU    92       0.010 -26.494  18.591  1.00  0.00
ATOM   1464  C   GLU    92       1.855 -29.069  14.862  1.00  0.00
ATOM   1465  O   GLU    92       2.758 -29.163  15.701  1.00  0.00
ATOM   1466  N   VAL    93       2.091 -28.670  13.592  1.00  0.00
ATOM   1467  HN  VAL    93       1.333 -28.599  12.963  1.00  0.00
ATOM   1468  CA  VAL    93       3.437 -28.330  13.109  1.00  0.00
ATOM   1469  HA  VAL    93       4.136 -28.473  13.938  1.00  0.00
ATOM   1470  CB  VAL    93       3.893 -29.287  11.940  1.00  0.00
ATOM   1471  HB  VAL    93       4.913 -29.019  11.665  1.00  0.00
ATOM   1472  CG1 VAL    93       3.922 -30.751  12.432  1.00  0.00
ATOM   1473 HG11 VAL    93       2.920 -31.068  12.705  1.00  0.00
ATOM   1474 HG12 VAL    93       4.560 -30.833  13.302  1.00  0.00
ATOM   1475 HG13 VAL    93       4.300 -31.398  11.653  1.00  0.00
ATOM   1476  CG2 VAL    93       3.006 -29.154  10.680  1.00  0.00
ATOM   1477 HG21 VAL    93       1.980 -29.407  10.925  1.00  0.00
ATOM   1478 HG22 VAL    93       3.360 -29.821   9.903  1.00  0.00
ATOM   1479 HG23 VAL    93       3.042 -28.135  10.314  1.00  0.00
ATOM   1480  C   VAL    93       3.493 -26.853  12.707  1.00  0.00
ATOM   1481  O   VAL    93       2.693 -26.383  11.896  1.00  0.00
ATOM   1482  N   ASP    94       4.421 -26.119  13.325  1.00  0.00
ATOM   1483  HN  ASP    94       5.019 -26.570  13.963  1.00  0.00
ATOM   1484  CA  ASP    94       4.590 -24.676  13.099  1.00  0.00
ATOM   1485  HA  ASP    94       3.610 -24.233  12.925  1.00  0.00
ATOM   1486  CB  ASP    94       5.220 -24.007  14.345  1.00  0.00
ATOM   1487  HB1 ASP    94       5.388 -22.954  14.128  1.00  0.00
ATOM   1488  HB2 ASP    94       6.183 -24.469  14.550  1.00  0.00
ATOM   1489  CG  ASP    94       4.342 -24.122  15.607  1.00  0.00
ATOM   1490  OD1 ASP    94       4.199 -25.244  16.141  1.00  0.00
ATOM   1491  OD2 ASP    94       3.815 -23.093  16.083  1.00  0.00
ATOM   1492  C   ASP    94       5.467 -24.462  11.857  1.00  0.00
ATOM   1493  O   ASP    94       6.667 -24.705  11.899  1.00  0.00
ATOM   1494  N   VAL    95       4.844 -24.006  10.764  1.00  0.00
ATOM   1495  HN  VAL    95       3.900 -23.767  10.842  1.00  0.00
ATOM   1496  CA  VAL    95       5.474 -23.850   9.440  1.00  0.00
ATOM   1497  HA  VAL    95       6.475 -24.278   9.461  1.00  0.00
ATOM   1498  CB  VAL    95       4.616 -24.600   8.339  1.00  0.00
ATOM   1499  HB  VAL    95       3.704 -24.046   8.214  1.00  0.00
ATOM   1500  CG1 VAL    95       5.309 -24.625   6.956  1.00  0.00
ATOM   1501 HG11 VAL    95       5.489 -23.609   6.618  1.00  0.00
ATOM   1502 HG12 VAL    95       4.680 -25.130   6.235  1.00  0.00
ATOM   1503 HG13 VAL    95       6.254 -25.146   7.033  1.00  0.00
ATOM   1504  CG2 VAL    95       4.215 -26.020   8.799  1.00  0.00
ATOM   1505 HG21 VAL    95       3.629 -25.959   9.713  1.00  0.00
ATOM   1506 HG22 VAL    95       5.102 -26.609   8.986  1.00  0.00
ATOM   1507 HG23 VAL    95       3.621 -26.503   8.031  1.00  0.00
ATOM   1508  C   VAL    95       5.557 -22.353   9.085  1.00  0.00
ATOM   1509  O   VAL    95       4.736 -21.559   9.544  1.00  0.00
ATOM   1510  N   ALA    96       6.583 -21.973   8.314  1.00  0.00
ATOM   1511  HN  ALA    96       7.309 -22.602   8.168  1.00  0.00
ATOM   1512  CA  ALA    96       6.671 -20.654   7.672  1.00  0.00
ATOM   1513  HA  ALA    96       5.835 -20.037   8.010  1.00  0.00
ATOM   1514  CB  ALA    96       7.980 -19.942   8.058  1.00  0.00
ATOM   1515  HB1 ALA    96       8.015 -19.803   9.132  1.00  0.00
ATOM   1516  HB2 ALA    96       8.025 -18.974   7.577  1.00  0.00
ATOM   1517  HB3 ALA    96       8.833 -20.535   7.748  1.00  0.00
ATOM   1518  C   ALA    96       6.565 -20.844   6.153  1.00  0.00
ATOM   1519  O   ALA    96       7.519 -21.300   5.508  1.00  0.00
ATOM   1520  N   CYS    97       5.387 -20.537   5.597  1.00  0.00
ATOM   1521  HN  CYS    97       4.653 -20.258   6.180  1.00  0.00
ATOM   1522  CA  CYS    97       5.136 -20.600   4.158  1.00  0.00
ATOM   1523  HA  CYS    97       5.833 -21.314   3.713  1.00  0.00
ATOM   1524  CB  CYS    97       3.695 -21.078   3.890  1.00  0.00
ATOM   1525  HB1 CYS    97       3.517 -21.101   2.822  1.00  0.00
ATOM   1526  HB2 CYS    97       2.997 -20.395   4.352  1.00  0.00
ATOM   1527  SG  CYS    97       3.345 -22.732   4.533  1.00  0.00
ATOM   1528  HG  CYS    97       2.775 -22.594   5.722  1.00  0.00
ATOM   1529  C   CYS    97       5.387 -19.209   3.562  1.00  0.00
ATOM   1530  O   CYS    97       4.641 -18.262   3.822  1.00  0.00
ATOM   1531  N   ILE    98       6.480 -19.101   2.804  1.00  0.00
ATOM   1532  HN  ILE    98       7.002 -19.913   2.642  1.00  0.00
ATOM   1533  CA  ILE    98       6.934 -17.849   2.180  1.00  0.00
ATOM   1534  HA  ILE    98       6.455 -17.017   2.702  1.00  0.00
ATOM   1535  CB  ILE    98       8.501 -17.678   2.336  1.00  0.00
ATOM   1536  HB  ILE    98       8.687 -17.488   3.387  1.00  0.00
ATOM   1537  CG1 ILE    98       9.025 -16.440   1.527  1.00  0.00
ATOM   1538 HG11 ILE    98       8.550 -15.545   1.910  1.00  0.00
ATOM   1539 HG12 ILE    98       8.756 -16.554   0.485  1.00  0.00
ATOM   1540  CG2 ILE    98       9.270 -18.977   1.998  1.00  0.00
ATOM   1541 HG21 ILE    98      10.334 -18.829   2.137  1.00  0.00
ATOM   1542 HG22 ILE    98       9.081 -19.261   0.972  1.00  0.00
ATOM   1543 HG23 ILE    98       8.935 -19.778   2.650  1.00  0.00
ATOM   1544  CD1 ILE    98      10.530 -16.210   1.574  1.00  0.00
ATOM   1545 HD11 ILE    98      11.047 -17.061   1.148  1.00  0.00
ATOM   1546 HD12 ILE    98      10.849 -16.068   2.596  1.00  0.00
ATOM   1547 HD13 ILE    98      10.770 -15.325   1.000  1.00  0.00
ATOM   1548  C   ILE    98       6.500 -17.817   0.702  1.00  0.00
ATOM   1549  O   ILE    98       6.639 -18.801  -0.012  1.00  0.00
ATOM   1550  N   TYR    99       5.959 -16.675   0.255  1.00  0.00
ATOM   1551  HN  TYR    99       5.921 -15.917   0.861  1.00  0.00
ATOM   1552  CA  TYR    99       5.429 -16.498  -1.110  1.00  0.00
ATOM   1553  HA  TYR    99       5.624 -17.406  -1.680  1.00  0.00
ATOM   1554  CB  TYR    99       3.895 -16.233  -1.087  1.00  0.00
ATOM   1555  HB1 TYR    99       3.512 -16.290  -2.104  1.00  0.00
ATOM   1556  HB2 TYR    99       3.708 -15.233  -0.706  1.00  0.00
ATOM   1557  CG  TYR    99       3.089 -17.221  -0.227  1.00  0.00
ATOM   1558  CD1 TYR    99       2.606 -18.425  -0.749  1.00  0.00
ATOM   1559  HD1 TYR    99       2.793 -18.660  -1.787  1.00  0.00
ATOM   1560  CD2 TYR    99       2.826 -16.947   1.118  1.00  0.00
ATOM   1561  HD2 TYR    99       3.189 -16.020   1.550  1.00  0.00
ATOM   1562  CE1 TYR    99       1.893 -19.310   0.036  1.00  0.00
ATOM   1563  HE1 TYR    99       1.530 -20.238  -0.389  1.00  0.00
ATOM   1564  CE2 TYR    99       2.112 -17.830   1.902  1.00  0.00
ATOM   1565  HE2 TYR    99       1.922 -17.591   2.943  1.00  0.00
ATOM   1566  CZ  TYR    99       1.647 -19.007   1.361  1.00  0.00
ATOM   1567  OH  TYR    99       0.941 -19.891   2.150  1.00  0.00
ATOM   1568  HH  TYR    99       0.481 -19.401   2.843  1.00  0.00
ATOM   1569  C   TYR    99       6.133 -15.323  -1.793  1.00  0.00
ATOM   1570  O   TYR    99       6.636 -14.416  -1.131  1.00  0.00
ATOM   1571  N   GLU   100       6.140 -15.362  -3.120  1.00  0.00
ATOM   1572  HN  GLU   100       5.799 -16.168  -3.552  1.00  0.00
ATOM   1573  CA  GLU   100       6.635 -14.292  -3.986  1.00  0.00
ATOM   1574  HA  GLU   100       6.837 -13.403  -3.389  1.00  0.00
ATOM   1575  CB  GLU   100       7.924 -14.756  -4.689  1.00  0.00
ATOM   1576  HB1 GLU   100       7.710 -15.675  -5.228  1.00  0.00
ATOM   1577  HB2 GLU   100       8.666 -14.976  -3.929  1.00  0.00
ATOM   1578  CG  GLU   100       8.539 -13.747  -5.672  1.00  0.00
ATOM   1579  HG1 GLU   100       9.022 -12.957  -5.104  1.00  0.00
ATOM   1580  HG2 GLU   100       7.746 -13.305  -6.273  1.00  0.00
ATOM   1581  CD  GLU   100       9.573 -14.401  -6.605  1.00  0.00
ATOM   1582  OE1 GLU   100      10.791 -14.386  -6.294  1.00  0.00
ATOM   1583  OE2 GLU   100       9.166 -14.934  -7.661  1.00  0.00
ATOM   1584  C   GLU   100       5.548 -13.992  -5.020  1.00  0.00
ATOM   1585  O   GLU   100       5.161 -14.879  -5.779  1.00  0.00
ATOM   1586  N   VAL   101       5.052 -12.755  -5.023  1.00  0.00
ATOM   1587  HN  VAL   101       5.439 -12.110  -4.407  1.00  0.00
ATOM   1588  CA  VAL   101       3.972 -12.303  -5.902  1.00  0.00
ATOM   1589  HA  VAL   101       3.516 -13.172  -6.376  1.00  0.00
ATOM   1590  CB  VAL   101       2.862 -11.562  -5.069  1.00  0.00
ATOM   1591  HB  VAL   101       3.329 -10.703  -4.590  1.00  0.00
ATOM   1592  CG1 VAL   101       1.715 -11.036  -5.970  1.00  0.00
ATOM   1593 HG11 VAL   101       1.243 -11.864  -6.486  1.00  0.00
ATOM   1594 HG12 VAL   101       2.108 -10.340  -6.704  1.00  0.00
ATOM   1595 HG13 VAL   101       0.975 -10.526  -5.364  1.00  0.00
ATOM   1596  CG2 VAL   101       2.309 -12.478  -3.948  1.00  0.00
ATOM   1597 HG21 VAL   101       1.829 -13.343  -4.391  1.00  0.00
ATOM   1598 HG22 VAL   101       1.583 -11.934  -3.354  1.00  0.00
ATOM   1599 HG23 VAL   101       3.117 -12.808  -3.305  1.00  0.00
ATOM   1600  C   VAL   101       4.542 -11.376  -6.989  1.00  0.00
ATOM   1601  O   VAL   101       5.094 -10.313  -6.680  1.00  0.00
ATOM   1602  N   GLU   102       4.414 -11.797  -8.255  1.00  0.00
ATOM   1603  HN  GLU   102       4.015 -12.676  -8.413  1.00  0.00
ATOM   1604  CA  GLU   102       4.833 -11.014  -9.426  1.00  0.00
ATOM   1605  HA  GLU   102       5.103 -10.015  -9.088  1.00  0.00
ATOM   1606  CB  GLU   102       6.062 -11.670 -10.097  1.00  0.00
ATOM   1607  HB1 GLU   102       5.778 -12.660 -10.438  1.00  0.00
ATOM   1608  HB2 GLU   102       6.847 -11.774  -9.356  1.00  0.00
ATOM   1609  CG  GLU   102       6.631 -10.893 -11.295  1.00  0.00
ATOM   1610  HG1 GLU   102       6.831  -9.871 -10.984  1.00  0.00
ATOM   1611  HG2 GLU   102       5.880 -10.874 -12.075  1.00  0.00
ATOM   1612  CD  GLU   102       7.921 -11.503 -11.871  1.00  0.00
ATOM   1613  OE1 GLU   102       7.840 -12.466 -12.663  1.00  0.00
ATOM   1614  OE2 GLU   102       9.026 -11.036 -11.517  1.00  0.00
ATOM   1615  C   GLU   102       3.654 -10.904 -10.411  1.00  0.00
ATOM   1616  O   GLU   102       2.986 -11.901 -10.698  1.00  0.00
ATOM   1617  N   ASN   103       3.415  -9.671 -10.900  1.00  0.00
ATOM   1618  HN  ASN   103       4.039  -8.959 -10.649  1.00  0.00
ATOM   1619  CA  ASN   103       2.282  -9.312 -11.789  1.00  0.00
ATOM   1620  HA  ASN   103       2.366  -8.247 -11.968  1.00  0.00
ATOM   1621  CB  ASN   103       2.369 -10.049 -13.169  1.00  0.00
ATOM   1622  HB1 ASN   103       1.503  -9.781 -13.766  1.00  0.00
ATOM   1623  HB2 ASN   103       2.346 -11.118 -12.998  1.00  0.00
ATOM   1624  CG  ASN   103       3.638  -9.702 -13.971  1.00  0.00
ATOM   1625  OD1 ASN   103       3.676  -8.714 -14.704  1.00  0.00
ATOM   1626  ND2 ASN   103       4.669 -10.528 -13.866  1.00  0.00
ATOM   1627 HD21 ASN   103       4.576 -11.319 -13.290  1.00  0.00
ATOM   1628 HD22 ASN   103       5.485 -10.318 -14.365  1.00  0.00
ATOM   1629  C   ASN   103       0.907  -9.560 -11.102  1.00  0.00
ATOM   1630  O   ASN   103      -0.110  -9.771 -11.776  1.00  0.00
ATOM   1631  N   GLY   104       0.884  -9.459  -9.754  1.00  0.00
ATOM   1632  HN  GLY   104       1.727  -9.269  -9.290  1.00  0.00
ATOM   1633  CA  GLY   104      -0.350  -9.611  -8.961  1.00  0.00
ATOM   1634  HA1 GLY   104      -1.184  -9.203  -9.520  1.00  0.00
ATOM   1635  HA2 GLY   104      -0.237  -9.035  -8.053  1.00  0.00
ATOM   1636  C   GLY   104      -0.682 -11.057  -8.573  1.00  0.00
ATOM   1637  O   GLY   104      -1.597 -11.294  -7.775  1.00  0.00
ATOM   1638  N   ARG   105       0.078 -12.022  -9.117  1.00  0.00
ATOM   1639  HN  ARG   105       0.847 -11.758  -9.666  1.00  0.00
ATOM   1640  CA  ARG   105      -0.132 -13.466  -8.876  1.00  0.00
ATOM   1641  HA  ARG   105      -0.949 -13.597  -8.168  1.00  0.00
ATOM   1642  CB  ARG   105      -0.469 -14.204 -10.201  1.00  0.00
ATOM   1643  HB1 ARG   105      -0.617 -15.260  -9.986  1.00  0.00
ATOM   1644  HB2 ARG   105       0.373 -14.106 -10.876  1.00  0.00
ATOM   1645  CG  ARG   105      -1.723 -13.684 -10.940  1.00  0.00
ATOM   1646  HG1 ARG   105      -1.778 -14.170 -11.911  1.00  0.00
ATOM   1647  HG2 ARG   105      -1.617 -12.616 -11.093  1.00  0.00
ATOM   1648  CD  ARG   105      -3.043 -13.942 -10.190  1.00  0.00
ATOM   1649  HD1 ARG   105      -2.951 -13.596  -9.168  1.00  0.00
ATOM   1650  HD2 ARG   105      -3.248 -15.009 -10.193  1.00  0.00
ATOM   1651  NE  ARG   105      -4.156 -13.215 -10.838  1.00  0.00
ATOM   1652  HE  ARG   105      -3.928 -12.348 -11.233  1.00  0.00
ATOM   1653  CZ  ARG   105      -5.432 -13.615 -10.931  1.00  0.00
ATOM   1654  NH1 ARG   105      -5.830 -14.779 -10.457  1.00  0.00
ATOM   1655 HH11 ARG   105      -5.176 -15.394 -10.017  1.00  0.00
ATOM   1656 HH12 ARG   105      -6.792 -15.061 -10.546  1.00  0.00
ATOM   1657  NH2 ARG   105      -6.311 -12.827 -11.526  1.00  0.00
ATOM   1658 HH21 ARG   105      -6.021 -11.944 -11.902  1.00  0.00
ATOM   1659 HH22 ARG   105      -7.269 -13.112 -11.617  1.00  0.00
ATOM   1660  C   ARG   105       1.146 -14.039  -8.272  1.00  0.00
ATOM   1661  O   ARG   105       2.232 -13.543  -8.565  1.00  0.00
ATOM   1662  N   ILE   106       1.022 -15.070  -7.430  1.00  0.00
ATOM   1663  HN  ILE   106       0.127 -15.399  -7.216  1.00  0.00
ATOM   1664  CA  ILE   106       2.186 -15.718  -6.820  1.00  0.00
ATOM   1665  HA  ILE   106       2.800 -14.933  -6.371  1.00  0.00
ATOM   1666  CB  ILE   106       1.775 -16.720  -5.683  1.00  0.00
ATOM   1667  HB  ILE   106       1.107 -17.458  -6.117  1.00  0.00
ATOM   1668  CG1 ILE   106       1.012 -15.962  -4.557  1.00  0.00
ATOM   1669 HG11 ILE   106       0.097 -15.544  -4.965  1.00  0.00
ATOM   1670 HG12 ILE   106       1.631 -15.156  -4.189  1.00  0.00
ATOM   1671  CG2 ILE   106       3.001 -17.477  -5.105  1.00  0.00
ATOM   1672 HG21 ILE   106       3.696 -16.769  -4.671  1.00  0.00
ATOM   1673 HG22 ILE   106       3.498 -18.025  -5.896  1.00  0.00
ATOM   1674 HG23 ILE   106       2.677 -18.174  -4.342  1.00  0.00
ATOM   1675  CD1 ILE   106       0.637 -16.813  -3.369  1.00  0.00
ATOM   1676 HD11 ILE   106       0.046 -17.658  -3.701  1.00  0.00
ATOM   1677 HD12 ILE   106       0.058 -16.222  -2.674  1.00  0.00
ATOM   1678 HD13 ILE   106       1.531 -17.170  -2.877  1.00  0.00
ATOM   1679  C   ILE   106       3.015 -16.423  -7.904  1.00  0.00
ATOM   1680  O   ILE   106       2.582 -17.414  -8.479  1.00  0.00
ATOM   1681  N   ALA   107       4.199 -15.862  -8.177  1.00  0.00
ATOM   1682  HN  ALA   107       4.455 -15.062  -7.676  1.00  0.00
ATOM   1683  CA  ALA   107       5.130 -16.371  -9.187  1.00  0.00
ATOM   1684  HA  ALA   107       4.568 -16.617 -10.084  1.00  0.00
ATOM   1685  CB  ALA   107       6.154 -15.279  -9.543  1.00  0.00
ATOM   1686  HB1 ALA   107       5.640 -14.397  -9.917  1.00  0.00
ATOM   1687  HB2 ALA   107       6.832 -15.640 -10.305  1.00  0.00
ATOM   1688  HB3 ALA   107       6.723 -15.006  -8.660  1.00  0.00
ATOM   1689  C   ALA   107       5.851 -17.624  -8.674  1.00  0.00
ATOM   1690  O   ALA   107       6.074 -18.580  -9.430  1.00  0.00
ATOM   1691  N   LYS   108       6.194 -17.607  -7.375  1.00  0.00
ATOM   1692  HN  LYS   108       5.915 -16.832  -6.831  1.00  0.00
ATOM   1693  CA  LYS   108       6.942 -18.685  -6.701  1.00  0.00
ATOM   1694  HA  LYS   108       6.708 -19.631  -7.187  1.00  0.00
ATOM   1695  CB  LYS   108       8.472 -18.426  -6.773  1.00  0.00
ATOM   1696  HB1 LYS   108       8.980 -19.140  -6.128  1.00  0.00
ATOM   1697  HB2 LYS   108       8.670 -17.427  -6.397  1.00  0.00
ATOM   1698  CG  LYS   108       9.079 -18.538  -8.184  1.00  0.00
ATOM   1699  HG1 LYS   108       8.475 -17.946  -8.865  1.00  0.00
ATOM   1700  HG2 LYS   108       9.045 -19.574  -8.498  1.00  0.00
ATOM   1701  CD  LYS   108      10.537 -18.048  -8.262  1.00  0.00
ATOM   1702  HD1 LYS   108      11.166 -18.699  -7.662  1.00  0.00
ATOM   1703  HD2 LYS   108      10.592 -17.037  -7.867  1.00  0.00
ATOM   1704  CE  LYS   108      11.059 -18.041  -9.707  1.00  0.00
ATOM   1705  HE1 LYS   108      10.418 -17.410 -10.314  1.00  0.00
ATOM   1706  HE2 LYS   108      11.037 -19.050 -10.101  1.00  0.00
ATOM   1707  NZ  LYS   108      12.447 -17.533  -9.804  1.00  0.00
ATOM   1708  HZ1 LYS   108      12.491 -16.547  -9.472  1.00  0.00
ATOM   1709  HZ2 LYS   108      12.773 -17.570 -10.790  1.00  0.00
ATOM   1710  HZ3 LYS   108      13.078 -18.110  -9.219  1.00  0.00
ATOM   1711  C   LYS   108       6.513 -18.750  -5.239  1.00  0.00
ATOM   1712  O   LYS   108       6.220 -17.721  -4.642  1.00  0.00
ATOM   1713  N   ALA   109       6.502 -19.953  -4.665  1.00  0.00
ATOM   1714  HN  ALA   109       6.737 -20.734  -5.208  1.00  0.00
ATOM   1715  CA  ALA   109       6.172 -20.164  -3.255  1.00  0.00
ATOM   1716  HA  ALA   109       6.435 -19.255  -2.705  1.00  0.00
ATOM   1717  CB  ALA   109       4.675 -20.420  -3.061  1.00  0.00
ATOM   1718  HB1 ALA   109       4.110 -19.584  -3.452  1.00  0.00
ATOM   1719  HB2 ALA   109       4.451 -20.530  -2.004  1.00  0.00
ATOM   1720  HB3 ALA   109       4.380 -21.325  -3.582  1.00  0.00
ATOM   1721  C   ALA   109       6.998 -21.320  -2.707  1.00  0.00
ATOM   1722  O   ALA   109       7.227 -22.318  -3.385  1.00  0.00
ATOM   1723  N   TRP   110       7.465 -21.142  -1.486  1.00  0.00
ATOM   1724  HN  TRP   110       7.229 -20.320  -1.027  1.00  0.00
ATOM   1725  CA  TRP   110       8.314 -22.088  -0.766  1.00  0.00
ATOM   1726  HA  TRP   110       8.312 -23.046  -1.280  1.00  0.00
ATOM   1727  CB  TRP   110       9.773 -21.523  -0.680  1.00  0.00
ATOM   1728  HB1 TRP   110      10.456 -22.341  -0.472  1.00  0.00
ATOM   1729  HB2 TRP   110       9.837 -20.806   0.130  1.00  0.00
ATOM   1730  CG  TRP   110      10.254 -20.819  -1.942  1.00  0.00
ATOM   1731  CD1 TRP   110      10.829 -21.392  -3.027  1.00  0.00
ATOM   1732  HD1 TRP   110      11.029 -22.441  -3.116  1.00  0.00
ATOM   1733  CD2 TRP   110      10.173 -19.414  -2.249  1.00  0.00
ATOM   1734  NE1 TRP   110      11.114 -20.458  -3.978  1.00  0.00
ATOM   1735  HE1 TRP   110      11.535 -20.638  -4.845  1.00  0.00
ATOM   1736  CE2 TRP   110      10.722 -19.236  -3.527  1.00  0.00
ATOM   1737  CE3 TRP   110       9.684 -18.298  -1.572  1.00  0.00
ATOM   1738  HE3 TRP   110       9.250 -18.392  -0.588  1.00  0.00
ATOM   1739  CZ2 TRP   110      10.812 -17.991  -4.134  1.00  0.00
ATOM   1740  HZ2 TRP   110      11.239 -17.864  -5.121  1.00  0.00
ATOM   1741  CZ3 TRP   110       9.770 -17.060  -2.173  1.00  0.00
ATOM   1742  HZ3 TRP   110       9.399 -16.182  -1.657  1.00  0.00
ATOM   1743  CH2 TRP   110      10.328 -16.917  -3.446  1.00  0.00
ATOM   1744  HH2 TRP   110      10.376 -15.926  -3.883  1.00  0.00
ATOM   1745  C   TRP   110       7.708 -22.259   0.635  1.00  0.00
ATOM   1746  O   TRP   110       6.983 -21.371   1.105  1.00  0.00
ATOM   1747  N   PHE   111       7.969 -23.381   1.302  1.00  0.00
ATOM   1748  HN  PHE   111       8.426 -24.118   0.848  1.00  0.00
ATOM   1749  CA  PHE   111       7.574 -23.541   2.713  1.00  0.00
ATOM   1750  HA  PHE   111       7.517 -22.541   3.155  1.00  0.00
ATOM   1751  CB  PHE   111       6.172 -24.216   2.858  1.00  0.00
ATOM   1752  HB1 PHE   111       5.495 -23.767   2.137  1.00  0.00
ATOM   1753  HB2 PHE   111       5.784 -24.007   3.851  1.00  0.00
ATOM   1754  CG  PHE   111       6.127 -25.733   2.651  1.00  0.00
ATOM   1755  CD1 PHE   111       6.113 -26.601   3.748  1.00  0.00
ATOM   1756  HD1 PHE   111       6.134 -26.191   4.750  1.00  0.00
ATOM   1757  CD2 PHE   111       6.102 -26.292   1.375  1.00  0.00
ATOM   1758  HD2 PHE   111       6.113 -25.645   0.507  1.00  0.00
ATOM   1759  CE1 PHE   111       6.072 -27.967   3.576  1.00  0.00
ATOM   1760  HE1 PHE   111       6.066 -28.618   4.446  1.00  0.00
ATOM   1761  CE2 PHE   111       6.058 -27.666   1.203  1.00  0.00
ATOM   1762  HE2 PHE   111       6.036 -28.085   0.203  1.00  0.00
ATOM   1763  CZ  PHE   111       6.044 -28.503   2.302  1.00  0.00
ATOM   1764  HZ  PHE   111       6.010 -29.578   2.166  1.00  0.00
ATOM   1765  C   PHE   111       8.658 -24.311   3.463  1.00  0.00
ATOM   1766  O   PHE   111       9.311 -25.203   2.897  1.00  0.00
ATOM   1767  N   LYS   112       8.853 -23.944   4.733  1.00  0.00
ATOM   1768  HN  LYS   112       8.345 -23.179   5.081  1.00  0.00
ATOM   1769  CA  LYS   112       9.775 -24.624   5.639  1.00  0.00
ATOM   1770  HA  LYS   112      10.080 -25.557   5.172  1.00  0.00
ATOM   1771  CB  LYS   112      11.048 -23.763   5.904  1.00  0.00
ATOM   1772  HB1 LYS   112      11.567 -23.625   4.959  1.00  0.00
ATOM   1773  HB2 LYS   112      11.705 -24.320   6.568  1.00  0.00
ATOM   1774  CG  LYS   112      10.812 -22.366   6.527  1.00  0.00
ATOM   1775  HG1 LYS   112      10.194 -22.481   7.412  1.00  0.00
ATOM   1776  HG2 LYS   112      10.289 -21.745   5.807  1.00  0.00
ATOM   1777  CD  LYS   112      12.137 -21.673   6.926  1.00  0.00
ATOM   1778  HD1 LYS   112      12.744 -21.538   6.035  1.00  0.00
ATOM   1779  HD2 LYS   112      12.672 -22.314   7.619  1.00  0.00
ATOM   1780  CE  LYS   112      11.934 -20.306   7.597  1.00  0.00
ATOM   1781  HE1 LYS   112      11.281 -20.419   8.454  1.00  0.00
ATOM   1782  HE2 LYS   112      11.476 -19.624   6.889  1.00  0.00
ATOM   1783  NZ  LYS   112      13.224 -19.721   8.052  1.00  0.00
ATOM   1784  HZ1 LYS   112      13.667 -20.339   8.762  1.00  0.00
ATOM   1785  HZ2 LYS   112      13.065 -18.784   8.468  1.00  0.00
ATOM   1786  HZ3 LYS   112      13.871 -19.623   7.246  1.00  0.00
ATOM   1787  C   LYS   112       9.041 -24.961   6.939  1.00  0.00
ATOM   1788  O   LYS   112       8.473 -24.080   7.585  1.00  0.00
ATOM   1789  N   ILE   113       9.040 -26.250   7.322  1.00  0.00
ATOM   1790  HN  ILE   113       9.508 -26.906   6.774  1.00  0.00
ATOM   1791  CA  ILE   113       8.370 -26.703   8.547  1.00  0.00
ATOM   1792  HA  ILE   113       7.521 -26.041   8.731  1.00  0.00
ATOM   1793  CB  ILE   113       7.816 -28.165   8.418  1.00  0.00
ATOM   1794  HB  ILE   113       8.638 -28.807   8.123  1.00  0.00
ATOM   1795  CG1 ILE   113       6.712 -28.224   7.318  1.00  0.00
ATOM   1796 HG11 ILE   113       7.049 -27.713   6.424  1.00  0.00
ATOM   1797 HG12 ILE   113       5.829 -27.716   7.680  1.00  0.00
ATOM   1798  CG2 ILE   113       7.259 -28.692   9.777  1.00  0.00
ATOM   1799 HG21 ILE   113       6.885 -29.702   9.653  1.00  0.00
ATOM   1800 HG22 ILE   113       6.450 -28.056  10.113  1.00  0.00
ATOM   1801 HG23 ILE   113       8.045 -28.690  10.523  1.00  0.00
ATOM   1802  CD1 ILE   113       6.289 -29.624   6.937  1.00  0.00
ATOM   1803 HD11 ILE   113       7.147 -30.184   6.587  1.00  0.00
ATOM   1804 HD12 ILE   113       5.550 -29.574   6.153  1.00  0.00
ATOM   1805 HD13 ILE   113       5.865 -30.117   7.799  1.00  0.00
ATOM   1806  C   ILE   113       9.363 -26.597   9.707  1.00  0.00
ATOM   1807  O   ILE   113      10.473 -27.147   9.642  1.00  0.00
ATOM   1808  N   GLY   114       8.949 -25.855  10.735  1.00  0.00
ATOM   1809  HN  GLY   114       8.035 -25.487  10.695  1.00  0.00
ATOM   1810  CA  GLY   114       9.788 -25.579  11.902  1.00  0.00
ATOM   1811  HA1 GLY   114       9.270 -24.872  12.536  1.00  0.00
ATOM   1812  HA2 GLY   114      10.716 -25.124  11.570  1.00  0.00
ATOM   1813  C   GLY   114      10.096 -26.827  12.718  1.00  0.00
ATOM   1814  O   GLY   114      11.252 -27.278  12.764  1.00  0.00
ATOM   1815  N   GLU   115       9.053 -27.397  13.343  1.00  0.00
ATOM   1816  HN  GLU   115       8.162 -26.994  13.241  1.00  0.00
ATOM   1817  CA  GLU   115       9.172 -28.619  14.151  1.00  0.00
ATOM   1818  HA  GLU   115       9.852 -29.295  13.644  1.00  0.00
ATOM   1819  CB  GLU   115       9.728 -28.287  15.575  1.00  0.00
ATOM   1820  HB1 GLU   115      10.550 -27.585  15.476  1.00  0.00
ATOM   1821  HB2 GLU   115      10.109 -29.202  16.018  1.00  0.00
ATOM   1822  CG  GLU   115       8.686 -27.683  16.540  1.00  0.00
ATOM   1823  HG1 GLU   115       7.840 -28.377  16.594  1.00  0.00
ATOM   1824  HG2 GLU   115       8.331 -26.745  16.126  1.00  0.00
ATOM   1825  CD  GLU   115       9.222 -27.446  17.960  1.00  0.00
ATOM   1826  OE1 GLU   115       9.196 -28.387  18.779  1.00  0.00
ATOM   1827  OE2 GLU   115       9.645 -26.314  18.276  1.00  0.00
ATOM   1828  C   GLU   115       7.789 -29.299  14.272  1.00  0.00
ATOM   1829  O   GLU   115       6.761 -28.666  13.976  1.00  0.00
ATOM   1830  N   PRO   116       7.741 -30.602  14.687  1.00  0.00
ATOM   1831  CA  PRO   116       6.494 -31.239  15.173  1.00  0.00
ATOM   1832  HA  PRO   116       5.641 -30.943  14.576  1.00  0.00
ATOM   1833  CB  PRO   116       6.790 -32.733  14.950  1.00  0.00
ATOM   1834  HB1 PRO   116       6.506 -32.996  13.942  1.00  0.00
ATOM   1835  HB2 PRO   116       6.227 -33.346  15.649  1.00  0.00
ATOM   1836  CG  PRO   116       8.272 -32.873  15.146  1.00  0.00
ATOM   1837  HG1 PRO   116       8.648 -33.718  14.577  1.00  0.00
ATOM   1838  HG2 PRO   116       8.494 -33.012  16.201  1.00  0.00
ATOM   1839  CD  PRO   116       8.876 -31.579  14.638  1.00  0.00
ATOM   1840  HD1 PRO   116       9.233 -31.695  13.621  1.00  0.00
ATOM   1841  HD2 PRO   116       9.687 -31.253  15.282  1.00  0.00
ATOM   1842  C   PRO   116       6.206 -30.918  16.661  1.00  0.00
ATOM   1843  O   PRO   116       7.129 -30.919  17.488  1.00  0.00
ATOM   1844  N   ARG   117       4.924 -30.616  16.993  1.00  0.00
ATOM   1845  HN  ARG   117       4.262 -30.532  16.275  1.00  0.00
ATOM   1846  CA  ARG   117       4.478 -30.391  18.393  1.00  0.00
ATOM   1847  HA  ARG   117       5.260 -30.770  19.040  1.00  0.00
ATOM   1848  CB  ARG   117       4.276 -28.879  18.700  1.00  0.00
ATOM   1849  HB1 ARG   117       3.834 -28.780  19.688  1.00  0.00
ATOM   1850  HB2 ARG   117       3.586 -28.466  17.969  1.00  0.00
ATOM   1851  CG  ARG   117       5.565 -28.041  18.664  1.00  0.00
ATOM   1852  HG1 ARG   117       5.961 -28.057  17.652  1.00  0.00
ATOM   1853  HG2 ARG   117       6.297 -28.484  19.334  1.00  0.00
ATOM   1854  CD  ARG   117       5.337 -26.586  19.081  1.00  0.00
ATOM   1855  HD1 ARG   117       4.955 -26.564  20.096  1.00  0.00
ATOM   1856  HD2 ARG   117       4.603 -26.141  18.414  1.00  0.00
ATOM   1857  NE  ARG   117       6.581 -25.804  19.027  1.00  0.00
ATOM   1858  HE  ARG   117       7.418 -26.293  19.188  1.00  0.00
ATOM   1859  CZ  ARG   117       6.657 -24.493  18.783  1.00  0.00
ATOM   1860  NH1 ARG   117       5.561 -23.791  18.512  1.00  0.00
ATOM   1861 HH11 ARG   117       4.663 -24.247  18.479  1.00  0.00
ATOM   1862 HH12 ARG   117       5.617 -22.807  18.348  1.00  0.00
ATOM   1863  NH2 ARG   117       7.837 -23.897  18.772  1.00  0.00
ATOM   1864 HH21 ARG   117       8.673 -24.434  18.945  1.00  0.00
ATOM   1865 HH22 ARG   117       7.911 -22.914  18.593  1.00  0.00
ATOM   1866  C   ARG   117       3.185 -31.163  18.716  1.00  0.00
ATOM   1867  O   ARG   117       2.409 -31.535  17.826  1.00  0.00
ATOM   1868  N   ILE   118       2.974 -31.375  20.032  1.00  0.00
ATOM   1869  HN  ILE   118       3.617 -30.990  20.664  1.00  0.00
ATOM   1870  CA  ILE   118       1.835 -32.123  20.603  1.00  0.00
ATOM   1871  HA  ILE   118       1.035 -32.176  19.864  1.00  0.00
ATOM   1872  CB  ILE   118       2.265 -33.596  21.008  1.00  0.00
ATOM   1873  HB  ILE   118       3.094 -33.515  21.708  1.00  0.00
ATOM   1874  CG1 ILE   118       2.754 -34.407  19.770  1.00  0.00
ATOM   1875 HG11 ILE   118       3.130 -35.368  20.099  1.00  0.00
ATOM   1876 HG12 ILE   118       3.559 -33.868  19.289  1.00  0.00
ATOM   1877  CG2 ILE   118       1.130 -34.358  21.729  1.00  0.00
ATOM   1878 HG21 ILE   118       0.866 -33.840  22.644  1.00  0.00
ATOM   1879 HG22 ILE   118       1.449 -35.363  21.972  1.00  0.00
ATOM   1880 HG23 ILE   118       0.255 -34.405  21.084  1.00  0.00
ATOM   1881  CD1 ILE   118       1.695 -34.665  18.720  1.00  0.00
ATOM   1882 HD11 ILE   118       0.912 -35.278  19.142  1.00  0.00
ATOM   1883 HD12 ILE   118       2.138 -35.173  17.878  1.00  0.00
ATOM   1884 HD13 ILE   118       1.271 -33.722  18.393  1.00  0.00
ATOM   1885  C   ILE   118       1.334 -31.368  21.850  1.00  0.00
ATOM   1886  O   ILE   118       2.152 -30.899  22.641  1.00  0.00
END
