
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   70 ( 1194),  selected   70 , name 1q1v_A
# Molecule2: number of CA atoms   87 ( 1451),  selected   87 , name T0476.pdb
# PARAMETERS: 1q1v_A.T0476.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    D   309_A      A       2           -
LGA    E   310_A      K       3           -
LGA    P   311_A      C       4           -
LGA    L   312_A      -       -           -
LGA    I   313_A      -       -           -
LGA    K   314_A      -       -           -
LGA    K   315_A      -       -           -
LGA    L   316_A      P       5           #
LGA    K   317_A      I       6          3.916
LGA    K   318_A      C       7          5.959
LGA    P   319_A      G       8          5.777
LGA    P   320_A      S       9           #
LGA    T   321_A      P      10          2.890
LGA    D   322_A      L      11          3.889
LGA    E   323_A      K      12          1.569
LGA    E   324_A      -       -           -
LGA    L   325_A      W      13          3.972
LGA    K   326_A      E      14          3.705
LGA    E   327_A      E      15          2.810
LGA    T   328_A      L      16          2.814
LGA    I   329_A      I      17          3.351
LGA    K   330_A      E      18          3.328
LGA    K   331_A      E      19          3.856
LGA    L   332_A      M      20          3.991
LGA    L   333_A      L      21          4.364
LGA    A   334_A      I      22          3.939
LGA    S   335_A      I      23          1.732
LGA    -       -      E      24           -
LGA    A   336_A      N      25          3.084
LGA    N   337_A      F      26          4.667
LGA    L   338_A      E      27          3.211
LGA    E   339_A      E      28          5.813
LGA    E   340_A      I      29          5.493
LGA    V   341_A      V      30          2.785
LGA    -       -      K      31           -
LGA    T   342_A      D      32          1.416
LGA    M   343_A      R      33          1.209
LGA    K   344_A      E      34          1.580
LGA    Q   345_A      R      35          1.970
LGA    I   346_A      F      36          1.627
LGA    C   347_A      L      37          0.768
LGA    K   348_A      A      38          1.667
LGA    K   349_A      Q      39          2.095
LGA    V   350_A      V      40          1.829
LGA    Y   351_A      E      41          2.085
LGA    E   352_A      E      42          3.382
LGA    -       -      F      43           -
LGA    N   353_A      V      44          2.935
LGA    -       -      F      45           -
LGA    -       -      K      46           -
LGA    -       -      C      47           -
LGA    -       -      P      48           -
LGA    -       -      V      49           -
LGA    -       -      C      50           -
LGA    -       -      G      51           -
LGA    -       -      E      52           -
LGA    -       -      E      53           -
LGA    -       -      F      54           -
LGA    -       -      Y      55           -
LGA    Y   354_A      G      56          2.270
LGA    P   355_A      K      57          3.145
LGA    T   356_A      T      58          2.851
LGA    Y   357_A      L      59          2.592
LGA    D   358_A      P      60          2.416
LGA    L   359_A      -       -           -
LGA    T   360_A      R      61          2.148
LGA    E   361_A      R      62          2.202
LGA    R   362_A      E      63          2.176
LGA    K   363_A      A      64          2.144
LGA    D   364_A      E      65          1.742
LGA    F   365_A      K      66          1.645
LGA    I   366_A      V      67          2.467
LGA    K   367_A      F      68          3.240
LGA    T   368_A      E      69          2.025
LGA    T   369_A      L      70          2.140
LGA    V   370_A      L      71          3.600
LGA    K   371_A      N      72          3.635
LGA    E   372_A      D      73          2.597
LGA    L   373_A      F      74          4.026
LGA    I   374_A      -       -           -
LGA    S   375_A      K      75          3.830
LGA    L   376_A      G      76          3.659
LGA    -       -      G      77           -
LGA    E   377_A      I      78          3.520
LGA    H   378_A      D      79           #
LGA    -       -      W      80           -
LGA    -       -      E      81           -
LGA    -       -      N      82           -
LGA    -       -      K      83           -
LGA    -       -      R      84           -
LGA    -       -      V      85           -
LGA    -       -      K      86           -
LGA    -       -      L      87           -
LGA    -       -      K      88           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   70   87    5.0     57    3.20    14.04     41.742     1.729

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.840783 * X  +   0.421312 * Y  +  -0.339971 * Z  +  -8.662484
  Y_new =   0.302018 * X  +  -0.886207 * Y  +  -0.351316 * Z  +  -9.499293
  Z_new =  -0.449298 * X  +   0.192703 * Y  +  -0.872351 * Z  +  -6.729710 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.924184   -0.217409  [ DEG:   167.5434    -12.4566 ]
  Theta =   0.465980    2.675613  [ DEG:    26.6987    153.3013 ]
  Phi   =   0.344857   -2.796736  [ DEG:    19.7588   -160.2412 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1q1v_A                                        
REMARK     2: T0476.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1q1v_A.T0476.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   70   87   5.0   57   3.20   14.04  41.742
REMARK  ---------------------------------------------------------- 
MOLECULE 1q1v_A
HEADER    DNA BINDING PROTEIN                     22-JUL-03   1Q1V              
TITLE     STRUCTURE OF THE ONCOPROTEIN DEK: A PUTATIVE DNA-BINDING              
TITLE    2 DOMAIN RELATED TO THE WINGED HELIX MOTIF                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: DEK PROTEIN;                                               
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: RESIDUES 309-378;                                          
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: DEK;                                                           
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)RIL;                              
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET28C                                    
KEYWDS    WINGED-HELIX MOTIF                                                    
EXPDTA    NMR, 10 STRUCTURES                                                    
AUTHOR    M.DEVANY,N.P.KOTHARU,H.MATSUO                                         
REVDAT   1   10-AUG-04 1Q1V    0                                                
JRNL        AUTH   M.DEVANY,N.P.KOTHARU,H.MATSUO                                
JRNL        TITL   SOLUTION NMR STRUCTURE OF THE C-TERMINAL DOMAIN OF           
JRNL        TITL 2 THE HUMAN PROTEIN DEK                                        
JRNL        REF    PROTEIN SCI.                  V.  13  2252 2004              
JRNL        REFN   ASTM PRCIEI  US ISSN 0961-8368                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1Q1V A  309   375  UNP    P35659   DEK_HUMAN      309    375             
SEQRES   1 A   70  ASP GLU PRO LEU ILE LYS LYS LEU LYS LYS PRO PRO THR          
SEQRES   2 A   70  ASP GLU GLU LEU LYS GLU THR ILE LYS LYS LEU LEU ALA          
SEQRES   3 A   70  SER ALA ASN LEU GLU GLU VAL THR MET LYS GLN ILE CYS          
SEQRES   4 A   70  LYS LYS VAL TYR GLU ASN TYR PRO THR TYR ASP LEU THR          
SEQRES   5 A   70  GLU ARG LYS ASP PHE ILE LYS THR THR VAL LYS GLU LEU          
SEQRES   6 A   70  ILE SER LEU GLU HIS                                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1         309          
MODEL        1                                                                  
ATOM      1  N   ASP A 309      15.697 -30.267 -15.233  1.00  0.00           N  
ATOM      2  CA  ASP A 309      15.704 -28.870 -14.703  1.00  0.00           C  
ATOM      3  C   ASP A 309      16.737 -28.028 -15.457  1.00  0.00           C  
ATOM      4  O   ASP A 309      17.838 -28.470 -15.720  1.00  0.00           O  
ATOM      5  CB  ASP A 309      16.093 -29.001 -13.228  1.00  0.00           C  
ATOM      6  CG  ASP A 309      14.982 -29.726 -12.468  1.00  0.00           C  
ATOM      7  OD1 ASP A 309      13.919 -29.905 -13.039  1.00  0.00           O  
ATOM      8  OD2 ASP A 309      15.212 -30.090 -11.326  1.00  0.00           O  
ATOM      9  HA  ASP A 309      14.800 -28.402 -14.830  1.00  0.00           H  
ATOM     10  HB2 ASP A 309      17.012 -29.564 -13.149  1.00  0.00           H  
ATOM     11  HB3 ASP A 309      16.235 -28.018 -12.806  1.00  0.00           H  
ATOM     12  H1  ASP A 309      14.716 -30.596 -15.329  1.00  0.00           H  
ATOM     13  H2  ASP A 309      16.212 -30.892 -14.577  1.00  0.00           H  
ATOM     14  H3  ASP A 309      16.159 -30.287 -16.164  1.00  0.00           H  
ATOM     15  N   GLU A 310      16.395 -26.818 -15.806  1.00  0.00           N  
ATOM     16  CA  GLU A 310      17.364 -25.955 -16.541  1.00  0.00           C  
ATOM     17  C   GLU A 310      16.768 -24.564 -16.792  1.00  0.00           C  
ATOM     18  O   GLU A 310      17.320 -23.569 -16.365  1.00  0.00           O  
ATOM     19  CB  GLU A 310      17.616 -26.678 -17.865  1.00  0.00           C  
ATOM     20  CG  GLU A 310      19.074 -27.134 -17.928  1.00  0.00           C  
ATOM     21  CD  GLU A 310      19.338 -27.816 -19.272  1.00  0.00           C  
ATOM     22  OE1 GLU A 310      18.958 -27.251 -20.285  1.00  0.00           O  
ATOM     23  OE2 GLU A 310      19.915 -28.890 -19.266  1.00  0.00           O  
ATOM     24  H   GLU A 310      15.503 -26.476 -15.583  1.00  0.00           H  
ATOM     25  HA  GLU A 310      18.285 -25.873 -15.989  1.00  0.00           H  
ATOM     26  HB2 GLU A 310      16.966 -27.538 -17.935  1.00  0.00           H  
ATOM     27  HB3 GLU A 310      17.416 -26.007 -18.687  1.00  0.00           H  
ATOM     28  HG2 GLU A 310      19.724 -26.277 -17.825  1.00  0.00           H  
ATOM     29  HG3 GLU A 310      19.269 -27.833 -17.128  1.00  0.00           H  
ATOM     30  N   PRO A 311      15.661 -24.540 -17.486  1.00  0.00           N  
ATOM     31  CA  PRO A 311      14.990 -23.253 -17.803  1.00  0.00           C  
ATOM     32  C   PRO A 311      14.337 -22.661 -16.549  1.00  0.00           C  
ATOM     33  O   PRO A 311      14.170 -21.464 -16.433  1.00  0.00           O  
ATOM     34  CB  PRO A 311      13.936 -23.642 -18.834  1.00  0.00           C  
ATOM     35  CG  PRO A 311      13.663 -25.089 -18.583  1.00  0.00           C  
ATOM     36  CD  PRO A 311      14.933 -25.692 -18.036  1.00  0.00           C  
ATOM     37  HA  PRO A 311      15.691 -22.556 -18.234  1.00  0.00           H  
ATOM     38  HB2 PRO A 311      13.039 -23.056 -18.691  1.00  0.00           H  
ATOM     39  HB3 PRO A 311      14.321 -23.507 -19.834  1.00  0.00           H  
ATOM     40  HG2 PRO A 311      12.862 -25.193 -17.863  1.00  0.00           H  
ATOM     41  HG3 PRO A 311      13.396 -25.582 -19.506  1.00  0.00           H  
ATOM     42  HD2 PRO A 311      14.705 -26.409 -17.261  1.00  0.00           H  
ATOM     43  HD3 PRO A 311      15.504 -26.151 -18.827  1.00  0.00           H  
ATOM     44  N   LEU A 312      13.965 -23.490 -15.611  1.00  0.00           N  
ATOM     45  CA  LEU A 312      13.322 -22.970 -14.369  1.00  0.00           C  
ATOM     46  C   LEU A 312      14.327 -22.156 -13.550  1.00  0.00           C  
ATOM     47  O   LEU A 312      15.313 -22.676 -13.067  1.00  0.00           O  
ATOM     48  CB  LEU A 312      12.885 -24.215 -13.599  1.00  0.00           C  
ATOM     49  CG  LEU A 312      11.396 -24.111 -13.267  1.00  0.00           C  
ATOM     50  CD1 LEU A 312      10.749 -25.493 -13.372  1.00  0.00           C  
ATOM     51  CD2 LEU A 312      11.228 -23.577 -11.843  1.00  0.00           C  
ATOM     52  H   LEU A 312      14.108 -24.453 -15.722  1.00  0.00           H  
ATOM     53  HA  LEU A 312      12.462 -22.368 -14.615  1.00  0.00           H  
ATOM     54  HB2 LEU A 312      13.060 -25.092 -14.205  1.00  0.00           H  
ATOM     55  HB3 LEU A 312      13.452 -24.290 -12.683  1.00  0.00           H  
ATOM     56  HG  LEU A 312      10.920 -23.437 -13.964  1.00  0.00           H  
ATOM     57 HD11 LEU A 312      11.513 -26.237 -13.542  1.00  0.00           H  
ATOM     58 HD12 LEU A 312      10.050 -25.501 -14.196  1.00  0.00           H  
ATOM     59 HD13 LEU A 312      10.226 -25.717 -12.454  1.00  0.00           H  
ATOM     60 HD21 LEU A 312      11.348 -24.387 -11.138  1.00  0.00           H  
ATOM     61 HD22 LEU A 312      10.244 -23.147 -11.733  1.00  0.00           H  
ATOM     62 HD23 LEU A 312      11.975 -22.821 -11.652  1.00  0.00           H  
ATOM     63  N   ILE A 313      14.085 -20.884 -13.390  1.00  0.00           N  
ATOM     64  CA  ILE A 313      15.028 -20.037 -12.602  1.00  0.00           C  
ATOM     65  C   ILE A 313      14.250 -19.080 -11.694  1.00  0.00           C  
ATOM     66  O   ILE A 313      14.443 -19.053 -10.495  1.00  0.00           O  
ATOM     67  CB  ILE A 313      15.825 -19.257 -13.647  1.00  0.00           C  
ATOM     68  CG1 ILE A 313      16.855 -20.180 -14.298  1.00  0.00           C  
ATOM     69  CG2 ILE A 313      16.546 -18.088 -12.973  1.00  0.00           C  
ATOM     70  CD1 ILE A 313      17.141 -19.700 -15.720  1.00  0.00           C  
ATOM     71  H   ILE A 313      13.283 -20.483 -13.787  1.00  0.00           H  
ATOM     72  HA  ILE A 313      15.691 -20.656 -12.019  1.00  0.00           H  
ATOM     73  HB  ILE A 313      15.152 -18.875 -14.401  1.00  0.00           H  
ATOM     74 HG12 ILE A 313      17.768 -20.164 -13.720  1.00  0.00           H  
ATOM     75 HG13 ILE A 313      16.467 -21.188 -14.331  1.00  0.00           H  
ATOM     76 HG21 ILE A 313      17.399 -17.801 -13.569  1.00  0.00           H  
ATOM     77 HG22 ILE A 313      16.878 -18.388 -11.990  1.00  0.00           H  
ATOM     78 HG23 ILE A 313      15.871 -17.249 -12.885  1.00  0.00           H  
ATOM     79 HD11 ILE A 313      17.930 -18.963 -15.700  1.00  0.00           H  
ATOM     80 HD12 ILE A 313      16.248 -19.259 -16.139  1.00  0.00           H  
ATOM     81 HD13 ILE A 313      17.448 -20.537 -16.328  1.00  0.00           H  
ATOM     82  N   LYS A 314      13.375 -18.294 -12.258  1.00  0.00           N  
ATOM     83  CA  LYS A 314      12.590 -17.337 -11.426  1.00  0.00           C  
ATOM     84  C   LYS A 314      13.531 -16.376 -10.696  1.00  0.00           C  
ATOM     85  O   LYS A 314      14.174 -16.735  -9.729  1.00  0.00           O  
ATOM     86  CB  LYS A 314      11.832 -18.212 -10.426  1.00  0.00           C  
ATOM     87  CG  LYS A 314      10.341 -18.206 -10.769  1.00  0.00           C  
ATOM     88  CD  LYS A 314       9.705 -19.518 -10.305  1.00  0.00           C  
ATOM     89  CE  LYS A 314       9.149 -19.342  -8.889  1.00  0.00           C  
ATOM     90  NZ  LYS A 314       8.908 -20.727  -8.393  1.00  0.00           N  
ATOM     91  H   LYS A 314      13.236 -18.330 -13.227  1.00  0.00           H  
ATOM     92  HA  LYS A 314      11.892 -16.789 -12.040  1.00  0.00           H  
ATOM     93  HB2 LYS A 314      12.210 -19.224 -10.475  1.00  0.00           H  
ATOM     94  HB3 LYS A 314      11.972 -17.823  -9.430  1.00  0.00           H  
ATOM     95  HG2 LYS A 314       9.861 -17.375 -10.272  1.00  0.00           H  
ATOM     96  HG3 LYS A 314      10.218 -18.108 -11.837  1.00  0.00           H  
ATOM     97  HD2 LYS A 314       8.902 -19.786 -10.976  1.00  0.00           H  
ATOM     98  HD3 LYS A 314      10.450 -20.298 -10.303  1.00  0.00           H  
ATOM     99  HE2 LYS A 314       9.873 -18.838  -8.263  1.00  0.00           H  
ATOM    100  HE3 LYS A 314       8.223 -18.793  -8.913  1.00  0.00           H  
ATOM    101  HZ1 LYS A 314       8.029 -20.749  -7.840  1.00  0.00           H  
ATOM    102  HZ2 LYS A 314       9.705 -21.024  -7.793  1.00  0.00           H  
ATOM    103  HZ3 LYS A 314       8.823 -21.375  -9.201  1.00  0.00           H  
ATOM    104  N   LYS A 315      13.617 -15.157 -11.153  1.00  0.00           N  
ATOM    105  CA  LYS A 315      14.519 -14.173 -10.486  1.00  0.00           C  
ATOM    106  C   LYS A 315      13.722 -12.945 -10.038  1.00  0.00           C  
ATOM    107  O   LYS A 315      14.123 -12.224  -9.147  1.00  0.00           O  
ATOM    108  CB  LYS A 315      15.542 -13.786 -11.555  1.00  0.00           C  
ATOM    109  CG  LYS A 315      14.811 -13.357 -12.829  1.00  0.00           C  
ATOM    110  CD  LYS A 315      15.823 -12.816 -13.840  1.00  0.00           C  
ATOM    111  CE  LYS A 315      16.592 -13.981 -14.468  1.00  0.00           C  
ATOM    112  NZ  LYS A 315      15.815 -14.349 -15.685  1.00  0.00           N  
ATOM    113  H   LYS A 315      13.091 -14.888 -11.935  1.00  0.00           H  
ATOM    114  HA  LYS A 315      15.019 -14.627  -9.645  1.00  0.00           H  
ATOM    115  HB2 LYS A 315      16.147 -12.967 -11.194  1.00  0.00           H  
ATOM    116  HB3 LYS A 315      16.173 -14.634 -11.773  1.00  0.00           H  
ATOM    117  HG2 LYS A 315      14.297 -14.208 -13.252  1.00  0.00           H  
ATOM    118  HG3 LYS A 315      14.095 -12.585 -12.592  1.00  0.00           H  
ATOM    119  HD2 LYS A 315      15.302 -12.269 -14.613  1.00  0.00           H  
ATOM    120  HD3 LYS A 315      16.516 -12.159 -13.339  1.00  0.00           H  
ATOM    121  HE2 LYS A 315      17.592 -13.667 -14.737  1.00  0.00           H  
ATOM    122  HE3 LYS A 315      16.631 -14.817 -13.786  1.00  0.00           H  
ATOM    123  HZ1 LYS A 315      16.470 -14.614 -16.447  1.00  0.00           H  
ATOM    124  HZ2 LYS A 315      15.240 -13.536 -15.987  1.00  0.00           H  
ATOM    125  HZ3 LYS A 315      15.193 -15.153 -15.469  1.00  0.00           H  
ATOM    126  N   LEU A 316      12.595 -12.701 -10.651  1.00  0.00           N  
ATOM    127  CA  LEU A 316      11.775 -11.518 -10.263  1.00  0.00           C  
ATOM    128  C   LEU A 316      10.778 -11.899  -9.164  1.00  0.00           C  
ATOM    129  O   LEU A 316      10.003 -12.823  -9.307  1.00  0.00           O  
ATOM    130  CB  LEU A 316      11.038 -11.115 -11.540  1.00  0.00           C  
ATOM    131  CG  LEU A 316      11.583  -9.778 -12.042  1.00  0.00           C  
ATOM    132  CD1 LEU A 316      12.522 -10.021 -13.225  1.00  0.00           C  
ATOM    133  CD2 LEU A 316      10.420  -8.888 -12.491  1.00  0.00           C  
ATOM    134  H   LEU A 316      12.290 -13.293 -11.368  1.00  0.00           H  
ATOM    135  HA  LEU A 316      12.409 -10.711  -9.933  1.00  0.00           H  
ATOM    136  HB2 LEU A 316      11.186 -11.873 -12.295  1.00  0.00           H  
ATOM    137  HB3 LEU A 316       9.983 -11.017 -11.330  1.00  0.00           H  
ATOM    138  HG  LEU A 316      12.127  -9.290 -11.247  1.00  0.00           H  
ATOM    139 HD11 LEU A 316      12.977 -10.996 -13.129  1.00  0.00           H  
ATOM    140 HD12 LEU A 316      13.293  -9.265 -13.234  1.00  0.00           H  
ATOM    141 HD13 LEU A 316      11.962  -9.975 -14.146  1.00  0.00           H  
ATOM    142 HD21 LEU A 316      10.135  -9.149 -13.499  1.00  0.00           H  
ATOM    143 HD22 LEU A 316      10.726  -7.854 -12.460  1.00  0.00           H  
ATOM    144 HD23 LEU A 316       9.579  -9.036 -11.831  1.00  0.00           H  
ATOM    145  N   LYS A 317      10.793 -11.189  -8.069  1.00  0.00           N  
ATOM    146  CA  LYS A 317       9.847 -11.504  -6.961  1.00  0.00           C  
ATOM    147  C   LYS A 317       9.774 -10.329  -5.981  1.00  0.00           C  
ATOM    148  O   LYS A 317      10.264 -10.402  -4.872  1.00  0.00           O  
ATOM    149  CB  LYS A 317      10.435 -12.737  -6.276  1.00  0.00           C  
ATOM    150  CG  LYS A 317      11.842 -12.416  -5.767  1.00  0.00           C  
ATOM    151  CD  LYS A 317      12.718 -13.666  -5.865  1.00  0.00           C  
ATOM    152  CE  LYS A 317      12.026 -14.830  -5.151  1.00  0.00           C  
ATOM    153  NZ  LYS A 317      12.207 -14.562  -3.695  1.00  0.00           N  
ATOM    154  H   LYS A 317      11.426 -10.447  -7.976  1.00  0.00           H  
ATOM    155  HA  LYS A 317       8.868 -11.731  -7.352  1.00  0.00           H  
ATOM    156  HB2 LYS A 317       9.807 -13.022  -5.443  1.00  0.00           H  
ATOM    157  HB3 LYS A 317      10.488 -13.552  -6.983  1.00  0.00           H  
ATOM    158  HG2 LYS A 317      12.270 -11.626  -6.369  1.00  0.00           H  
ATOM    159  HG3 LYS A 317      11.789 -12.096  -4.738  1.00  0.00           H  
ATOM    160  HD2 LYS A 317      12.870 -13.919  -6.905  1.00  0.00           H  
ATOM    161  HD3 LYS A 317      13.671 -13.475  -5.397  1.00  0.00           H  
ATOM    162  HE2 LYS A 317      10.974 -14.852  -5.404  1.00  0.00           H  
ATOM    163  HE3 LYS A 317      12.495 -15.765  -5.416  1.00  0.00           H  
ATOM    164  HZ1 LYS A 317      12.564 -13.596  -3.557  1.00  0.00           H  
ATOM    165  HZ2 LYS A 317      12.888 -15.245  -3.301  1.00  0.00           H  
ATOM    166  HZ3 LYS A 317      11.294 -14.663  -3.208  1.00  0.00           H  
ATOM    167  N   LYS A 318       9.167  -9.246  -6.383  1.00  0.00           N  
ATOM    168  CA  LYS A 318       9.066  -8.067  -5.474  1.00  0.00           C  
ATOM    169  C   LYS A 318       7.615  -7.586  -5.388  1.00  0.00           C  
ATOM    170  O   LYS A 318       6.813  -7.871  -6.255  1.00  0.00           O  
ATOM    171  CB  LYS A 318       9.952  -6.998  -6.115  1.00  0.00           C  
ATOM    172  CG  LYS A 318      11.383  -7.525  -6.234  1.00  0.00           C  
ATOM    173  CD  LYS A 318      12.185  -6.627  -7.177  1.00  0.00           C  
ATOM    174  CE  LYS A 318      13.625  -7.139  -7.273  1.00  0.00           C  
ATOM    175  NZ  LYS A 318      13.511  -8.507  -7.853  1.00  0.00           N  
ATOM    176  H   LYS A 318       8.779  -9.206  -7.282  1.00  0.00           H  
ATOM    177  HA  LYS A 318       9.440  -8.316  -4.493  1.00  0.00           H  
ATOM    178  HB2 LYS A 318       9.573  -6.758  -7.099  1.00  0.00           H  
ATOM    179  HB3 LYS A 318       9.947  -6.111  -5.501  1.00  0.00           H  
ATOM    180  HG2 LYS A 318      11.848  -7.527  -5.258  1.00  0.00           H  
ATOM    181  HG3 LYS A 318      11.366  -8.531  -6.626  1.00  0.00           H  
ATOM    182  HD2 LYS A 318      11.731  -6.640  -8.158  1.00  0.00           H  
ATOM    183  HD3 LYS A 318      12.189  -5.618  -6.797  1.00  0.00           H  
ATOM    184  HE2 LYS A 318      14.207  -6.499  -7.921  1.00  0.00           H  
ATOM    185  HE3 LYS A 318      14.071  -7.190  -6.292  1.00  0.00           H  
ATOM    186  HZ1 LYS A 318      12.633  -8.579  -8.406  1.00  0.00           H  
ATOM    187  HZ2 LYS A 318      13.498  -9.209  -7.086  1.00  0.00           H  
ATOM    188  HZ3 LYS A 318      14.324  -8.688  -8.474  1.00  0.00           H  
ATOM    189  N   PRO A 319       7.327  -6.870  -4.333  1.00  0.00           N  
ATOM    190  CA  PRO A 319       5.958  -6.339  -4.121  1.00  0.00           C  
ATOM    191  C   PRO A 319       5.677  -5.178  -5.079  1.00  0.00           C  
ATOM    192  O   PRO A 319       6.551  -4.385  -5.368  1.00  0.00           O  
ATOM    193  CB  PRO A 319       5.982  -5.856  -2.674  1.00  0.00           C  
ATOM    194  CG  PRO A 319       7.423  -5.570  -2.383  1.00  0.00           C  
ATOM    195  CD  PRO A 319       8.242  -6.491  -3.252  1.00  0.00           C  
ATOM    196  HA  PRO A 319       5.224  -7.119  -4.238  1.00  0.00           H  
ATOM    197  HB2 PRO A 319       5.389  -4.958  -2.568  1.00  0.00           H  
ATOM    198  HB3 PRO A 319       5.620  -6.628  -2.013  1.00  0.00           H  
ATOM    199  HG2 PRO A 319       7.648  -4.540  -2.618  1.00  0.00           H  
ATOM    200  HG3 PRO A 319       7.635  -5.767  -1.343  1.00  0.00           H  
ATOM    201  HD2 PRO A 319       9.104  -5.970  -3.645  1.00  0.00           H  
ATOM    202  HD3 PRO A 319       8.545  -7.366  -2.698  1.00  0.00           H  
ATOM    203  N   PRO A 320       4.456  -5.121  -5.539  1.00  0.00           N  
ATOM    204  CA  PRO A 320       4.044  -4.047  -6.476  1.00  0.00           C  
ATOM    205  C   PRO A 320       3.898  -2.715  -5.734  1.00  0.00           C  
ATOM    206  O   PRO A 320       3.195  -2.617  -4.746  1.00  0.00           O  
ATOM    207  CB  PRO A 320       2.695  -4.531  -7.001  1.00  0.00           C  
ATOM    208  CG  PRO A 320       2.169  -5.445  -5.939  1.00  0.00           C  
ATOM    209  CD  PRO A 320       3.357  -6.042  -5.231  1.00  0.00           C  
ATOM    210  HA  PRO A 320       4.747  -3.959  -7.288  1.00  0.00           H  
ATOM    211  HB2 PRO A 320       2.027  -3.693  -7.144  1.00  0.00           H  
ATOM    212  HB3 PRO A 320       2.823  -5.073  -7.925  1.00  0.00           H  
ATOM    213  HG2 PRO A 320       1.562  -4.886  -5.241  1.00  0.00           H  
ATOM    214  HG3 PRO A 320       1.582  -6.232  -6.389  1.00  0.00           H  
ATOM    215  HD2 PRO A 320       3.179  -6.082  -4.166  1.00  0.00           H  
ATOM    216  HD3 PRO A 320       3.576  -7.025  -5.619  1.00  0.00           H  
ATOM    217  N   THR A 321       4.557  -1.690  -6.201  1.00  0.00           N  
ATOM    218  CA  THR A 321       4.459  -0.364  -5.524  1.00  0.00           C  
ATOM    219  C   THR A 321       2.993   0.059  -5.389  1.00  0.00           C  
ATOM    220  O   THR A 321       2.123  -0.456  -6.065  1.00  0.00           O  
ATOM    221  CB  THR A 321       5.213   0.603  -6.438  1.00  0.00           C  
ATOM    222  OG1 THR A 321       5.246   1.890  -5.839  1.00  0.00           O  
ATOM    223  CG2 THR A 321       4.506   0.685  -7.791  1.00  0.00           C  
ATOM    224  H   THR A 321       5.118  -1.792  -6.998  1.00  0.00           H  
ATOM    225  HA  THR A 321       4.932  -0.399  -4.555  1.00  0.00           H  
ATOM    226  HB  THR A 321       6.222   0.248  -6.585  1.00  0.00           H  
ATOM    227  HG1 THR A 321       5.512   2.523  -6.510  1.00  0.00           H  
ATOM    228 HG21 THR A 321       5.153   1.170  -8.507  1.00  0.00           H  
ATOM    229 HG22 THR A 321       3.594   1.254  -7.687  1.00  0.00           H  
ATOM    230 HG23 THR A 321       4.272  -0.311  -8.136  1.00  0.00           H  
ATOM    231  N   ASP A 322       2.713   0.995  -4.522  1.00  0.00           N  
ATOM    232  CA  ASP A 322       1.304   1.450  -4.343  1.00  0.00           C  
ATOM    233  C   ASP A 322       0.677   1.778  -5.702  1.00  0.00           C  
ATOM    234  O   ASP A 322      -0.487   1.522  -5.937  1.00  0.00           O  
ATOM    235  CB  ASP A 322       1.393   2.708  -3.473  1.00  0.00           C  
ATOM    236  CG  ASP A 322       2.556   3.584  -3.944  1.00  0.00           C  
ATOM    237  OD1 ASP A 322       2.988   3.405  -5.071  1.00  0.00           O  
ATOM    238  OD2 ASP A 322       2.997   4.416  -3.170  1.00  0.00           O  
ATOM    239  H   ASP A 322       3.429   1.397  -3.989  1.00  0.00           H  
ATOM    240  HA  ASP A 322       0.726   0.693  -3.837  1.00  0.00           H  
ATOM    241  HB2 ASP A 322       0.470   3.264  -3.551  1.00  0.00           H  
ATOM    242  HB3 ASP A 322       1.555   2.422  -2.445  1.00  0.00           H  
ATOM    243  N   GLU A 323       1.441   2.337  -6.602  1.00  0.00           N  
ATOM    244  CA  GLU A 323       0.885   2.674  -7.943  1.00  0.00           C  
ATOM    245  C   GLU A 323       0.273   1.422  -8.578  1.00  0.00           C  
ATOM    246  O   GLU A 323      -0.756   1.480  -9.222  1.00  0.00           O  
ATOM    247  CB  GLU A 323       2.082   3.161  -8.758  1.00  0.00           C  
ATOM    248  CG  GLU A 323       1.608   4.163  -9.816  1.00  0.00           C  
ATOM    249  CD  GLU A 323       1.948   5.583  -9.364  1.00  0.00           C  
ATOM    250  OE1 GLU A 323       3.086   5.807  -8.987  1.00  0.00           O  
ATOM    251  OE2 GLU A 323       1.064   6.424  -9.403  1.00  0.00           O  
ATOM    252  H   GLU A 323       2.378   2.533  -6.397  1.00  0.00           H  
ATOM    253  HA  GLU A 323       0.147   3.455  -7.861  1.00  0.00           H  
ATOM    254  HB2 GLU A 323       2.793   3.641  -8.102  1.00  0.00           H  
ATOM    255  HB3 GLU A 323       2.553   2.322  -9.248  1.00  0.00           H  
ATOM    256  HG2 GLU A 323       2.101   3.954 -10.754  1.00  0.00           H  
ATOM    257  HG3 GLU A 323       0.540   4.072  -9.941  1.00  0.00           H  
ATOM    258  N   GLU A 324       0.899   0.291  -8.399  1.00  0.00           N  
ATOM    259  CA  GLU A 324       0.353  -0.966  -8.987  1.00  0.00           C  
ATOM    260  C   GLU A 324      -0.812  -1.475  -8.134  1.00  0.00           C  
ATOM    261  O   GLU A 324      -1.903  -1.692  -8.621  1.00  0.00           O  
ATOM    262  CB  GLU A 324       1.516  -1.958  -8.953  1.00  0.00           C  
ATOM    263  CG  GLU A 324       2.257  -1.922 -10.292  1.00  0.00           C  
ATOM    264  CD  GLU A 324       2.816  -3.311 -10.605  1.00  0.00           C  
ATOM    265  OE1 GLU A 324       3.832  -3.662 -10.030  1.00  0.00           O  
ATOM    266  OE2 GLU A 324       2.216  -4.000 -11.414  1.00  0.00           O  
ATOM    267  H   GLU A 324       1.726   0.266  -7.874  1.00  0.00           H  
ATOM    268  HA  GLU A 324       0.035  -0.802 -10.004  1.00  0.00           H  
ATOM    269  HB2 GLU A 324       2.196  -1.690  -8.157  1.00  0.00           H  
ATOM    270  HB3 GLU A 324       1.135  -2.954  -8.783  1.00  0.00           H  
ATOM    271  HG2 GLU A 324       1.574  -1.622 -11.073  1.00  0.00           H  
ATOM    272  HG3 GLU A 324       3.070  -1.214 -10.233  1.00  0.00           H  
ATOM    273  N   LEU A 325      -0.590  -1.664  -6.862  1.00  0.00           N  
ATOM    274  CA  LEU A 325      -1.687  -2.155  -5.980  1.00  0.00           C  
ATOM    275  C   LEU A 325      -2.952  -1.326  -6.211  1.00  0.00           C  
ATOM    276  O   LEU A 325      -3.982  -1.841  -6.598  1.00  0.00           O  
ATOM    277  CB  LEU A 325      -1.172  -1.964  -4.554  1.00  0.00           C  
ATOM    278  CG  LEU A 325      -0.302  -3.157  -4.160  1.00  0.00           C  
ATOM    279  CD1 LEU A 325       0.239  -2.950  -2.745  1.00  0.00           C  
ATOM    280  CD2 LEU A 325      -1.145  -4.435  -4.201  1.00  0.00           C  
ATOM    281  H   LEU A 325       0.297  -1.481  -6.485  1.00  0.00           H  
ATOM    282  HA  LEU A 325      -1.882  -3.199  -6.166  1.00  0.00           H  
ATOM    283  HB2 LEU A 325      -0.587  -1.057  -4.502  1.00  0.00           H  
ATOM    284  HB3 LEU A 325      -2.009  -1.891  -3.875  1.00  0.00           H  
ATOM    285  HG  LEU A 325       0.523  -3.245  -4.852  1.00  0.00           H  
ATOM    286 HD11 LEU A 325       0.536  -1.918  -2.621  1.00  0.00           H  
ATOM    287 HD12 LEU A 325       1.093  -3.592  -2.588  1.00  0.00           H  
ATOM    288 HD13 LEU A 325      -0.530  -3.192  -2.026  1.00  0.00           H  
ATOM    289 HD21 LEU A 325      -0.651  -5.172  -4.819  1.00  0.00           H  
ATOM    290 HD22 LEU A 325      -2.117  -4.214  -4.612  1.00  0.00           H  
ATOM    291 HD23 LEU A 325      -1.256  -4.823  -3.199  1.00  0.00           H  
ATOM    292  N   LYS A 326      -2.880  -0.043  -5.984  1.00  0.00           N  
ATOM    293  CA  LYS A 326      -4.080   0.816  -6.199  1.00  0.00           C  
ATOM    294  C   LYS A 326      -4.674   0.542  -7.581  1.00  0.00           C  
ATOM    295  O   LYS A 326      -5.864   0.358  -7.729  1.00  0.00           O  
ATOM    296  CB  LYS A 326      -3.563   2.252  -6.107  1.00  0.00           C  
ATOM    297  CG  LYS A 326      -4.713   3.187  -5.726  1.00  0.00           C  
ATOM    298  CD  LYS A 326      -5.600   3.434  -6.950  1.00  0.00           C  
ATOM    299  CE  LYS A 326      -6.601   4.547  -6.638  1.00  0.00           C  
ATOM    300  NZ  LYS A 326      -6.507   5.485  -7.791  1.00  0.00           N  
ATOM    301  H   LYS A 326      -2.040   0.355  -5.677  1.00  0.00           H  
ATOM    302  HA  LYS A 326      -4.813   0.638  -5.430  1.00  0.00           H  
ATOM    303  HB2 LYS A 326      -2.790   2.307  -5.356  1.00  0.00           H  
ATOM    304  HB3 LYS A 326      -3.159   2.552  -7.062  1.00  0.00           H  
ATOM    305  HG2 LYS A 326      -5.300   2.733  -4.942  1.00  0.00           H  
ATOM    306  HG3 LYS A 326      -4.313   4.126  -5.379  1.00  0.00           H  
ATOM    307  HD2 LYS A 326      -4.982   3.728  -7.787  1.00  0.00           H  
ATOM    308  HD3 LYS A 326      -6.134   2.530  -7.197  1.00  0.00           H  
ATOM    309  HE2 LYS A 326      -7.602   4.141  -6.561  1.00  0.00           H  
ATOM    310  HE3 LYS A 326      -6.330   5.055  -5.726  1.00  0.00           H  
ATOM    311  HZ1 LYS A 326      -7.449   5.869  -8.005  1.00  0.00           H  
ATOM    312  HZ2 LYS A 326      -6.142   4.976  -8.622  1.00  0.00           H  
ATOM    313  HZ3 LYS A 326      -5.865   6.266  -7.551  1.00  0.00           H  
ATOM    314  N   GLU A 327      -3.854   0.509  -8.596  1.00  0.00           N  
ATOM    315  CA  GLU A 327      -4.376   0.243  -9.965  1.00  0.00           C  
ATOM    316  C   GLU A 327      -5.258  -1.008  -9.955  1.00  0.00           C  
ATOM    317  O   GLU A 327      -6.375  -0.996 -10.431  1.00  0.00           O  
ATOM    318  CB  GLU A 327      -3.132   0.016 -10.826  1.00  0.00           C  
ATOM    319  CG  GLU A 327      -3.555  -0.359 -12.248  1.00  0.00           C  
ATOM    320  CD  GLU A 327      -3.753   0.913 -13.075  1.00  0.00           C  
ATOM    321  OE1 GLU A 327      -3.363   1.970 -12.604  1.00  0.00           O  
ATOM    322  OE2 GLU A 327      -4.290   0.809 -14.166  1.00  0.00           O  
ATOM    323  H   GLU A 327      -2.895   0.657  -8.456  1.00  0.00           H  
ATOM    324  HA  GLU A 327      -4.929   1.093 -10.332  1.00  0.00           H  
ATOM    325  HB2 GLU A 327      -2.544   0.923 -10.852  1.00  0.00           H  
ATOM    326  HB3 GLU A 327      -2.544  -0.784 -10.405  1.00  0.00           H  
ATOM    327  HG2 GLU A 327      -2.787  -0.969 -12.701  1.00  0.00           H  
ATOM    328  HG3 GLU A 327      -4.483  -0.911 -12.214  1.00  0.00           H  
ATOM    329  N   THR A 328      -4.766  -2.087  -9.410  1.00  0.00           N  
ATOM    330  CA  THR A 328      -5.577  -3.338  -9.363  1.00  0.00           C  
ATOM    331  C   THR A 328      -6.955  -3.051  -8.755  1.00  0.00           C  
ATOM    332  O   THR A 328      -7.977  -3.382  -9.322  1.00  0.00           O  
ATOM    333  CB  THR A 328      -4.783  -4.290  -8.470  1.00  0.00           C  
ATOM    334  OG1 THR A 328      -3.527  -4.568  -9.074  1.00  0.00           O  
ATOM    335  CG2 THR A 328      -5.562  -5.593  -8.284  1.00  0.00           C  
ATOM    336  H   THR A 328      -3.863  -2.075  -9.028  1.00  0.00           H  
ATOM    337  HA  THR A 328      -5.680  -3.757 -10.351  1.00  0.00           H  
ATOM    338  HB  THR A 328      -4.625  -3.831  -7.506  1.00  0.00           H  
ATOM    339  HG1 THR A 328      -3.291  -3.819  -9.625  1.00  0.00           H  
ATOM    340 HG21 THR A 328      -6.331  -5.663  -9.041  1.00  0.00           H  
ATOM    341 HG22 THR A 328      -6.019  -5.606  -7.306  1.00  0.00           H  
ATOM    342 HG23 THR A 328      -4.889  -6.432  -8.378  1.00  0.00           H  
ATOM    343  N   ILE A 329      -6.986  -2.435  -7.604  1.00  0.00           N  
ATOM    344  CA  ILE A 329      -8.296  -2.126  -6.961  1.00  0.00           C  
ATOM    345  C   ILE A 329      -9.102  -1.170  -7.840  1.00  0.00           C  
ATOM    346  O   ILE A 329     -10.242  -1.427  -8.170  1.00  0.00           O  
ATOM    347  CB  ILE A 329      -7.939  -1.460  -5.636  1.00  0.00           C  
ATOM    348  CG1 ILE A 329      -7.049  -2.397  -4.816  1.00  0.00           C  
ATOM    349  CG2 ILE A 329      -9.221  -1.164  -4.857  1.00  0.00           C  
ATOM    350  CD1 ILE A 329      -5.958  -1.585  -4.117  1.00  0.00           C  
ATOM    351  H   ILE A 329      -6.150  -2.175  -7.165  1.00  0.00           H  
ATOM    352  HA  ILE A 329      -8.851  -3.033  -6.781  1.00  0.00           H  
ATOM    353  HB  ILE A 329      -7.413  -0.535  -5.826  1.00  0.00           H  
ATOM    354 HG12 ILE A 329      -7.649  -2.908  -4.077  1.00  0.00           H  
ATOM    355 HG13 ILE A 329      -6.590  -3.122  -5.472  1.00  0.00           H  
ATOM    356 HG21 ILE A 329      -9.199  -1.691  -3.914  1.00  0.00           H  
ATOM    357 HG22 ILE A 329     -10.074  -1.494  -5.433  1.00  0.00           H  
ATOM    358 HG23 ILE A 329      -9.297  -0.103  -4.677  1.00  0.00           H  
ATOM    359 HD11 ILE A 329      -5.026  -1.702  -4.649  1.00  0.00           H  
ATOM    360 HD12 ILE A 329      -5.841  -1.937  -3.103  1.00  0.00           H  
ATOM    361 HD13 ILE A 329      -6.238  -0.542  -4.106  1.00  0.00           H  
ATOM    362  N   LYS A 330      -8.518  -0.069  -8.226  1.00  0.00           N  
ATOM    363  CA  LYS A 330      -9.247   0.901  -9.089  1.00  0.00           C  
ATOM    364  C   LYS A 330     -10.005   0.146 -10.184  1.00  0.00           C  
ATOM    365  O   LYS A 330     -11.026   0.591 -10.670  1.00  0.00           O  
ATOM    366  CB  LYS A 330      -8.156   1.787  -9.696  1.00  0.00           C  
ATOM    367  CG  LYS A 330      -8.708   2.513 -10.925  1.00  0.00           C  
ATOM    368  CD  LYS A 330      -8.282   1.769 -12.191  1.00  0.00           C  
ATOM    369  CE  LYS A 330      -8.974   2.390 -13.407  1.00  0.00           C  
ATOM    370  NZ  LYS A 330      -7.879   3.035 -14.184  1.00  0.00           N  
ATOM    371  H   LYS A 330      -7.598   0.118  -7.952  1.00  0.00           H  
ATOM    372  HA  LYS A 330      -9.925   1.499  -8.501  1.00  0.00           H  
ATOM    373  HB2 LYS A 330      -7.833   2.511  -8.963  1.00  0.00           H  
ATOM    374  HB3 LYS A 330      -7.319   1.173  -9.990  1.00  0.00           H  
ATOM    375  HG2 LYS A 330      -9.786   2.546 -10.870  1.00  0.00           H  
ATOM    376  HG3 LYS A 330      -8.317   3.520 -10.953  1.00  0.00           H  
ATOM    377  HD2 LYS A 330      -7.209   1.844 -12.310  1.00  0.00           H  
ATOM    378  HD3 LYS A 330      -8.564   0.730 -12.111  1.00  0.00           H  
ATOM    379  HE2 LYS A 330      -9.456   1.622 -13.997  1.00  0.00           H  
ATOM    380  HE3 LYS A 330      -9.691   3.132 -13.093  1.00  0.00           H  
ATOM    381  HZ1 LYS A 330      -7.096   3.278 -13.545  1.00  0.00           H  
ATOM    382  HZ2 LYS A 330      -8.240   3.900 -14.637  1.00  0.00           H  
ATOM    383  HZ3 LYS A 330      -7.536   2.378 -14.912  1.00  0.00           H  
ATOM    384  N   LYS A 331      -9.513  -1.000 -10.565  1.00  0.00           N  
ATOM    385  CA  LYS A 331     -10.204  -1.794 -11.619  1.00  0.00           C  
ATOM    386  C   LYS A 331     -11.369  -2.569 -10.999  1.00  0.00           C  
ATOM    387  O   LYS A 331     -12.382  -2.800 -11.630  1.00  0.00           O  
ATOM    388  CB  LYS A 331      -9.139  -2.756 -12.149  1.00  0.00           C  
ATOM    389  CG  LYS A 331      -9.314  -2.935 -13.658  1.00  0.00           C  
ATOM    390  CD  LYS A 331      -8.078  -2.402 -14.382  1.00  0.00           C  
ATOM    391  CE  LYS A 331      -8.441  -1.123 -15.142  1.00  0.00           C  
ATOM    392  NZ  LYS A 331      -9.018  -1.590 -16.434  1.00  0.00           N  
ATOM    393  H   LYS A 331      -8.691  -1.342 -10.154  1.00  0.00           H  
ATOM    394  HA  LYS A 331     -10.553  -1.153 -12.413  1.00  0.00           H  
ATOM    395  HB2 LYS A 331      -8.158  -2.352 -11.945  1.00  0.00           H  
ATOM    396  HB3 LYS A 331      -9.244  -3.714 -11.660  1.00  0.00           H  
ATOM    397  HG2 LYS A 331      -9.441  -3.984 -13.883  1.00  0.00           H  
ATOM    398  HG3 LYS A 331     -10.185  -2.388 -13.986  1.00  0.00           H  
ATOM    399  HD2 LYS A 331      -7.304  -2.185 -13.661  1.00  0.00           H  
ATOM    400  HD3 LYS A 331      -7.721  -3.144 -15.081  1.00  0.00           H  
ATOM    401  HE2 LYS A 331      -9.170  -0.551 -14.584  1.00  0.00           H  
ATOM    402  HE3 LYS A 331      -7.558  -0.532 -15.325  1.00  0.00           H  
ATOM    403  HZ1 LYS A 331      -8.684  -0.978 -17.204  1.00  0.00           H  
ATOM    404  HZ2 LYS A 331     -10.057  -1.547 -16.382  1.00  0.00           H  
ATOM    405  HZ3 LYS A 331      -8.720  -2.568 -16.617  1.00  0.00           H  
ATOM    406  N   LEU A 332     -11.232  -2.962  -9.763  1.00  0.00           N  
ATOM    407  CA  LEU A 332     -12.329  -3.715  -9.092  1.00  0.00           C  
ATOM    408  C   LEU A 332     -13.553  -2.812  -8.916  1.00  0.00           C  
ATOM    409  O   LEU A 332     -14.607  -3.058  -9.468  1.00  0.00           O  
ATOM    410  CB  LEU A 332     -11.760  -4.115  -7.730  1.00  0.00           C  
ATOM    411  CG  LEU A 332     -10.461  -4.900  -7.924  1.00  0.00           C  
ATOM    412  CD1 LEU A 332      -9.862  -5.246  -6.558  1.00  0.00           C  
ATOM    413  CD2 LEU A 332     -10.754  -6.188  -8.694  1.00  0.00           C  
ATOM    414  H   LEU A 332     -10.409  -2.758  -9.274  1.00  0.00           H  
ATOM    415  HA  LEU A 332     -12.587  -4.596  -9.658  1.00  0.00           H  
ATOM    416  HB2 LEU A 332     -11.561  -3.226  -7.147  1.00  0.00           H  
ATOM    417  HB3 LEU A 332     -12.474  -4.734  -7.208  1.00  0.00           H  
ATOM    418  HG  LEU A 332      -9.756  -4.299  -8.481  1.00  0.00           H  
ATOM    419 HD11 LEU A 332      -8.786  -5.283  -6.635  1.00  0.00           H  
ATOM    420 HD12 LEU A 332     -10.234  -6.206  -6.236  1.00  0.00           H  
ATOM    421 HD13 LEU A 332     -10.146  -4.491  -5.839  1.00  0.00           H  
ATOM    422 HD21 LEU A 332     -10.986  -5.950  -9.720  1.00  0.00           H  
ATOM    423 HD22 LEU A 332     -11.596  -6.693  -8.242  1.00  0.00           H  
ATOM    424 HD23 LEU A 332      -9.888  -6.833  -8.660  1.00  0.00           H  
ATOM    425  N   LEU A 333     -13.419  -1.763  -8.150  1.00  0.00           N  
ATOM    426  CA  LEU A 333     -14.571  -0.839  -7.937  1.00  0.00           C  
ATOM    427  C   LEU A 333     -15.099  -0.333  -9.281  1.00  0.00           C  
ATOM    428  O   LEU A 333     -16.289  -0.165  -9.470  1.00  0.00           O  
ATOM    429  CB  LEU A 333     -14.002   0.318  -7.114  1.00  0.00           C  
ATOM    430  CG  LEU A 333     -12.871   0.991  -7.893  1.00  0.00           C  
ATOM    431  CD1 LEU A 333     -13.454   2.060  -8.818  1.00  0.00           C  
ATOM    432  CD2 LEU A 333     -11.895   1.645  -6.911  1.00  0.00           C  
ATOM    433  H   LEU A 333     -12.561  -1.582  -7.714  1.00  0.00           H  
ATOM    434  HA  LEU A 333     -15.354  -1.333  -7.384  1.00  0.00           H  
ATOM    435  HB2 LEU A 333     -14.784   1.038  -6.919  1.00  0.00           H  
ATOM    436  HB3 LEU A 333     -13.618  -0.059  -6.179  1.00  0.00           H  
ATOM    437  HG  LEU A 333     -12.350   0.251  -8.483  1.00  0.00           H  
ATOM    438 HD11 LEU A 333     -13.090   3.032  -8.519  1.00  0.00           H  
ATOM    439 HD12 LEU A 333     -14.532   2.043  -8.754  1.00  0.00           H  
ATOM    440 HD13 LEU A 333     -13.150   1.860  -9.835  1.00  0.00           H  
ATOM    441 HD21 LEU A 333     -11.006   1.037  -6.828  1.00  0.00           H  
ATOM    442 HD22 LEU A 333     -12.363   1.733  -5.942  1.00  0.00           H  
ATOM    443 HD23 LEU A 333     -11.627   2.627  -7.271  1.00  0.00           H  
ATOM    444  N   ALA A 334     -14.223  -0.083 -10.216  1.00  0.00           N  
ATOM    445  CA  ALA A 334     -14.672   0.418 -11.548  1.00  0.00           C  
ATOM    446  C   ALA A 334     -15.597  -0.600 -12.220  1.00  0.00           C  
ATOM    447  O   ALA A 334     -16.238  -0.309 -13.211  1.00  0.00           O  
ATOM    448  CB  ALA A 334     -13.386   0.585 -12.358  1.00  0.00           C  
ATOM    449  H   ALA A 334     -13.270  -0.223 -10.042  1.00  0.00           H  
ATOM    450  HA  ALA A 334     -15.169   1.368 -11.446  1.00  0.00           H  
ATOM    451  HB1 ALA A 334     -12.895   1.502 -12.066  1.00  0.00           H  
ATOM    452  HB2 ALA A 334     -13.627   0.626 -13.411  1.00  0.00           H  
ATOM    453  HB3 ALA A 334     -12.730  -0.250 -12.170  1.00  0.00           H  
ATOM    454  N   SER A 335     -15.672  -1.793 -11.696  1.00  0.00           N  
ATOM    455  CA  SER A 335     -16.556  -2.823 -12.313  1.00  0.00           C  
ATOM    456  C   SER A 335     -17.662  -3.230 -11.335  1.00  0.00           C  
ATOM    457  O   SER A 335     -18.303  -4.249 -11.500  1.00  0.00           O  
ATOM    458  CB  SER A 335     -15.639  -4.009 -12.608  1.00  0.00           C  
ATOM    459  OG  SER A 335     -15.084  -4.485 -11.390  1.00  0.00           O  
ATOM    460  H   SER A 335     -15.147  -2.012 -10.898  1.00  0.00           H  
ATOM    461  HA  SER A 335     -16.983  -2.450 -13.230  1.00  0.00           H  
ATOM    462  HB2 SER A 335     -16.205  -4.798 -13.073  1.00  0.00           H  
ATOM    463  HB3 SER A 335     -14.849  -3.693 -13.278  1.00  0.00           H  
ATOM    464  HG  SER A 335     -14.251  -4.029 -11.245  1.00  0.00           H  
ATOM    465  N   ALA A 336     -17.891  -2.442 -10.321  1.00  0.00           N  
ATOM    466  CA  ALA A 336     -18.956  -2.790  -9.337  1.00  0.00           C  
ATOM    467  C   ALA A 336     -19.433  -1.532  -8.608  1.00  0.00           C  
ATOM    468  O   ALA A 336     -18.746  -0.532  -8.558  1.00  0.00           O  
ATOM    469  CB  ALA A 336     -18.288  -3.756  -8.357  1.00  0.00           C  
ATOM    470  H   ALA A 336     -17.363  -1.626 -10.205  1.00  0.00           H  
ATOM    471  HA  ALA A 336     -19.781  -3.277  -9.830  1.00  0.00           H  
ATOM    472  HB1 ALA A 336     -18.780  -4.715  -8.405  1.00  0.00           H  
ATOM    473  HB2 ALA A 336     -18.365  -3.361  -7.354  1.00  0.00           H  
ATOM    474  HB3 ALA A 336     -17.247  -3.870  -8.619  1.00  0.00           H  
ATOM    475  N   ASN A 337     -20.606  -1.576  -8.037  1.00  0.00           N  
ATOM    476  CA  ASN A 337     -21.122  -0.381  -7.308  1.00  0.00           C  
ATOM    477  C   ASN A 337     -20.354  -0.198  -5.997  1.00  0.00           C  
ATOM    478  O   ASN A 337     -20.262  -1.101  -5.188  1.00  0.00           O  
ATOM    479  CB  ASN A 337     -22.594  -0.686  -7.033  1.00  0.00           C  
ATOM    480  CG  ASN A 337     -23.462  -0.009  -8.095  1.00  0.00           C  
ATOM    481  OD1 ASN A 337     -23.082   1.003  -8.653  1.00  0.00           O  
ATOM    482  ND2 ASN A 337     -24.620  -0.527  -8.401  1.00  0.00           N  
ATOM    483  H   ASN A 337     -21.146  -2.392  -8.083  1.00  0.00           H  
ATOM    484  HA  ASN A 337     -21.035   0.501  -7.922  1.00  0.00           H  
ATOM    485  HB2 ASN A 337     -22.753  -1.754  -7.065  1.00  0.00           H  
ATOM    486  HB3 ASN A 337     -22.863  -0.310  -6.058  1.00  0.00           H  
ATOM    487 HD21 ASN A 337     -24.926  -1.342  -7.953  1.00  0.00           H  
ATOM    488 HD22 ASN A 337     -25.185  -0.100  -9.080  1.00  0.00           H  
ATOM    489  N   LEU A 338     -19.796   0.961  -5.786  1.00  0.00           N  
ATOM    490  CA  LEU A 338     -19.024   1.206  -4.532  1.00  0.00           C  
ATOM    491  C   LEU A 338     -19.870   0.869  -3.301  1.00  0.00           C  
ATOM    492  O   LEU A 338     -19.430   0.175  -2.407  1.00  0.00           O  
ATOM    493  CB  LEU A 338     -18.688   2.699  -4.559  1.00  0.00           C  
ATOM    494  CG  LEU A 338     -17.963   3.045  -5.861  1.00  0.00           C  
ATOM    495  CD1 LEU A 338     -17.325   4.429  -5.738  1.00  0.00           C  
ATOM    496  CD2 LEU A 338     -16.872   2.007  -6.136  1.00  0.00           C  
ATOM    497  H   LEU A 338     -19.880   1.671  -6.454  1.00  0.00           H  
ATOM    498  HA  LEU A 338     -18.115   0.627  -4.533  1.00  0.00           H  
ATOM    499  HB2 LEU A 338     -19.602   3.273  -4.491  1.00  0.00           H  
ATOM    500  HB3 LEU A 338     -18.050   2.939  -3.721  1.00  0.00           H  
ATOM    501  HG  LEU A 338     -18.671   3.051  -6.678  1.00  0.00           H  
ATOM    502 HD11 LEU A 338     -17.595   5.029  -6.593  1.00  0.00           H  
ATOM    503 HD12 LEU A 338     -16.250   4.327  -5.696  1.00  0.00           H  
ATOM    504 HD13 LEU A 338     -17.675   4.909  -4.837  1.00  0.00           H  
ATOM    505 HD21 LEU A 338     -16.235   2.357  -6.936  1.00  0.00           H  
ATOM    506 HD22 LEU A 338     -17.329   1.071  -6.424  1.00  0.00           H  
ATOM    507 HD23 LEU A 338     -16.282   1.859  -5.244  1.00  0.00           H  
ATOM    508  N   GLU A 339     -21.077   1.363  -3.242  1.00  0.00           N  
ATOM    509  CA  GLU A 339     -21.940   1.076  -2.059  1.00  0.00           C  
ATOM    510  C   GLU A 339     -22.343  -0.402  -2.030  1.00  0.00           C  
ATOM    511  O   GLU A 339     -22.865  -0.889  -1.048  1.00  0.00           O  
ATOM    512  CB  GLU A 339     -23.173   1.962  -2.240  1.00  0.00           C  
ATOM    513  CG  GLU A 339     -23.644   2.462  -0.873  1.00  0.00           C  
ATOM    514  CD  GLU A 339     -24.862   3.370  -1.051  1.00  0.00           C  
ATOM    515  OE1 GLU A 339     -25.938   2.845  -1.284  1.00  0.00           O  
ATOM    516  OE2 GLU A 339     -24.697   4.575  -0.952  1.00  0.00           O  
ATOM    517  H   GLU A 339     -21.412   1.927  -3.969  1.00  0.00           H  
ATOM    518  HA  GLU A 339     -21.429   1.343  -1.149  1.00  0.00           H  
ATOM    519  HB2 GLU A 339     -22.921   2.805  -2.867  1.00  0.00           H  
ATOM    520  HB3 GLU A 339     -23.962   1.391  -2.703  1.00  0.00           H  
ATOM    521  HG2 GLU A 339     -23.910   1.618  -0.254  1.00  0.00           H  
ATOM    522  HG3 GLU A 339     -22.848   3.019  -0.400  1.00  0.00           H  
ATOM    523  N   GLU A 340     -22.104  -1.119  -3.093  1.00  0.00           N  
ATOM    524  CA  GLU A 340     -22.479  -2.563  -3.112  1.00  0.00           C  
ATOM    525  C   GLU A 340     -21.230  -3.438  -2.977  1.00  0.00           C  
ATOM    526  O   GLU A 340     -21.299  -4.649  -3.055  1.00  0.00           O  
ATOM    527  CB  GLU A 340     -23.153  -2.784  -4.464  1.00  0.00           C  
ATOM    528  CG  GLU A 340     -24.468  -3.539  -4.259  1.00  0.00           C  
ATOM    529  CD  GLU A 340     -24.874  -4.223  -5.565  1.00  0.00           C  
ATOM    530  OE1 GLU A 340     -24.000  -4.472  -6.379  1.00  0.00           O  
ATOM    531  OE2 GLU A 340     -26.055  -4.484  -5.731  1.00  0.00           O  
ATOM    532  H   GLU A 340     -21.681  -0.712  -3.878  1.00  0.00           H  
ATOM    533  HA  GLU A 340     -23.175  -2.778  -2.316  1.00  0.00           H  
ATOM    534  HB2 GLU A 340     -23.354  -1.828  -4.927  1.00  0.00           H  
ATOM    535  HB3 GLU A 340     -22.503  -3.364  -5.103  1.00  0.00           H  
ATOM    536  HG2 GLU A 340     -24.338  -4.283  -3.488  1.00  0.00           H  
ATOM    537  HG3 GLU A 340     -25.240  -2.845  -3.964  1.00  0.00           H  
ATOM    538  N   VAL A 341     -20.091  -2.836  -2.772  1.00  0.00           N  
ATOM    539  CA  VAL A 341     -18.843  -3.635  -2.626  1.00  0.00           C  
ATOM    540  C   VAL A 341     -18.408  -3.656  -1.159  1.00  0.00           C  
ATOM    541  O   VAL A 341     -18.636  -2.718  -0.420  1.00  0.00           O  
ATOM    542  CB  VAL A 341     -17.803  -2.912  -3.483  1.00  0.00           C  
ATOM    543  CG1 VAL A 341     -16.425  -3.533  -3.247  1.00  0.00           C  
ATOM    544  CG2 VAL A 341     -18.175  -3.051  -4.961  1.00  0.00           C  
ATOM    545  H   VAL A 341     -20.056  -1.862  -2.706  1.00  0.00           H  
ATOM    546  HA  VAL A 341     -18.990  -4.639  -2.991  1.00  0.00           H  
ATOM    547  HB  VAL A 341     -17.778  -1.867  -3.214  1.00  0.00           H  
ATOM    548 HG11 VAL A 341     -15.941  -3.708  -4.196  1.00  0.00           H  
ATOM    549 HG12 VAL A 341     -16.536  -4.467  -2.720  1.00  0.00           H  
ATOM    550 HG13 VAL A 341     -15.822  -2.856  -2.658  1.00  0.00           H  
ATOM    551 HG21 VAL A 341     -19.139  -3.533  -5.047  1.00  0.00           H  
ATOM    552 HG22 VAL A 341     -17.429  -3.648  -5.465  1.00  0.00           H  
ATOM    553 HG23 VAL A 341     -18.220  -2.072  -5.415  1.00  0.00           H  
ATOM    554  N   THR A 342     -17.788  -4.717  -0.732  1.00  0.00           N  
ATOM    555  CA  THR A 342     -17.343  -4.798   0.689  1.00  0.00           C  
ATOM    556  C   THR A 342     -15.840  -5.078   0.763  1.00  0.00           C  
ATOM    557  O   THR A 342     -15.239  -5.555  -0.180  1.00  0.00           O  
ATOM    558  CB  THR A 342     -18.137  -5.960   1.290  1.00  0.00           C  
ATOM    559  OG1 THR A 342     -17.953  -7.120   0.489  1.00  0.00           O  
ATOM    560  CG2 THR A 342     -19.622  -5.598   1.333  1.00  0.00           C  
ATOM    561  H   THR A 342     -17.619  -5.462  -1.344  1.00  0.00           H  
ATOM    562  HA  THR A 342     -17.581  -3.884   1.210  1.00  0.00           H  
ATOM    563  HB  THR A 342     -17.789  -6.155   2.292  1.00  0.00           H  
ATOM    564  HG1 THR A 342     -17.257  -7.648   0.887  1.00  0.00           H  
ATOM    565 HG21 THR A 342     -20.014  -5.805   2.319  1.00  0.00           H  
ATOM    566 HG22 THR A 342     -20.158  -6.186   0.602  1.00  0.00           H  
ATOM    567 HG23 THR A 342     -19.744  -4.548   1.111  1.00  0.00           H  
ATOM    568  N   MET A 343     -15.232  -4.786   1.880  1.00  0.00           N  
ATOM    569  CA  MET A 343     -13.768  -5.034   2.022  1.00  0.00           C  
ATOM    570  C   MET A 343     -13.445  -6.498   1.716  1.00  0.00           C  
ATOM    571  O   MET A 343     -12.360  -6.827   1.281  1.00  0.00           O  
ATOM    572  CB  MET A 343     -13.455  -4.710   3.484  1.00  0.00           C  
ATOM    573  CG  MET A 343     -14.511  -5.351   4.387  1.00  0.00           C  
ATOM    574  SD  MET A 343     -13.812  -5.619   6.035  1.00  0.00           S  
ATOM    575  CE  MET A 343     -14.884  -4.461   6.924  1.00  0.00           C  
ATOM    576  H   MET A 343     -15.736  -4.403   2.626  1.00  0.00           H  
ATOM    577  HA  MET A 343     -13.208  -4.378   1.372  1.00  0.00           H  
ATOM    578  HB2 MET A 343     -12.480  -5.100   3.737  1.00  0.00           H  
ATOM    579  HB3 MET A 343     -13.464  -3.640   3.626  1.00  0.00           H  
ATOM    580  HG2 MET A 343     -15.366  -4.697   4.461  1.00  0.00           H  
ATOM    581  HG3 MET A 343     -14.817  -6.299   3.968  1.00  0.00           H  
ATOM    582  HE1 MET A 343     -14.595  -4.432   7.967  1.00  0.00           H  
ATOM    583  HE2 MET A 343     -15.908  -4.784   6.846  1.00  0.00           H  
ATOM    584  HE3 MET A 343     -14.785  -3.475   6.491  1.00  0.00           H  
ATOM    585  N   LYS A 344     -14.380  -7.380   1.941  1.00  0.00           N  
ATOM    586  CA  LYS A 344     -14.128  -8.824   1.667  1.00  0.00           C  
ATOM    587  C   LYS A 344     -13.932  -9.055   0.166  1.00  0.00           C  
ATOM    588  O   LYS A 344     -13.054  -9.785  -0.249  1.00  0.00           O  
ATOM    589  CB  LYS A 344     -15.384  -9.543   2.161  1.00  0.00           C  
ATOM    590  CG  LYS A 344     -15.251 -11.042   1.893  1.00  0.00           C  
ATOM    591  CD  LYS A 344     -16.022 -11.822   2.958  1.00  0.00           C  
ATOM    592  CE  LYS A 344     -15.590 -13.290   2.930  1.00  0.00           C  
ATOM    593  NZ  LYS A 344     -16.754 -14.024   2.359  1.00  0.00           N  
ATOM    594  H   LYS A 344     -15.248  -7.093   2.295  1.00  0.00           H  
ATOM    595  HA  LYS A 344     -13.267  -9.167   2.218  1.00  0.00           H  
ATOM    596  HB2 LYS A 344     -15.500  -9.374   3.221  1.00  0.00           H  
ATOM    597  HB3 LYS A 344     -16.247  -9.161   1.638  1.00  0.00           H  
ATOM    598  HG2 LYS A 344     -15.655 -11.271   0.916  1.00  0.00           H  
ATOM    599  HG3 LYS A 344     -14.209 -11.325   1.926  1.00  0.00           H  
ATOM    600  HD2 LYS A 344     -15.813 -11.403   3.933  1.00  0.00           H  
ATOM    601  HD3 LYS A 344     -17.081 -11.757   2.758  1.00  0.00           H  
ATOM    602  HE2 LYS A 344     -14.720 -13.411   2.299  1.00  0.00           H  
ATOM    603  HE3 LYS A 344     -15.384 -13.641   3.929  1.00  0.00           H  
ATOM    604  HZ1 LYS A 344     -16.455 -14.973   2.066  1.00  0.00           H  
ATOM    605  HZ2 LYS A 344     -17.120 -13.504   1.535  1.00  0.00           H  
ATOM    606  HZ3 LYS A 344     -17.501 -14.104   3.079  1.00  0.00           H  
ATOM    607  N   GLN A 345     -14.743  -8.439  -0.652  1.00  0.00           N  
ATOM    608  CA  GLN A 345     -14.600  -8.628  -2.125  1.00  0.00           C  
ATOM    609  C   GLN A 345     -13.280  -8.023  -2.612  1.00  0.00           C  
ATOM    610  O   GLN A 345     -12.633  -8.553  -3.494  1.00  0.00           O  
ATOM    611  CB  GLN A 345     -15.789  -7.886  -2.737  1.00  0.00           C  
ATOM    612  CG  GLN A 345     -17.072  -8.681  -2.491  1.00  0.00           C  
ATOM    613  CD  GLN A 345     -17.884  -8.760  -3.785  1.00  0.00           C  
ATOM    614  OE1 GLN A 345     -18.228  -9.833  -4.237  1.00  0.00           O  
ATOM    615  NE2 GLN A 345     -18.208  -7.657  -4.405  1.00  0.00           N  
ATOM    616  H   GLN A 345     -15.446  -7.855  -0.298  1.00  0.00           H  
ATOM    617  HA  GLN A 345     -14.651  -9.676  -2.377  1.00  0.00           H  
ATOM    618  HB2 GLN A 345     -15.876  -6.910  -2.282  1.00  0.00           H  
ATOM    619  HB3 GLN A 345     -15.635  -7.775  -3.800  1.00  0.00           H  
ATOM    620  HG2 GLN A 345     -16.818  -9.680  -2.162  1.00  0.00           H  
ATOM    621  HG3 GLN A 345     -17.659  -8.191  -1.728  1.00  0.00           H  
ATOM    622 HE21 GLN A 345     -17.931  -6.791  -4.039  1.00  0.00           H  
ATOM    623 HE22 GLN A 345     -18.728  -7.695  -5.234  1.00  0.00           H  
ATOM    624  N   ILE A 346     -12.878  -6.919  -2.045  1.00  0.00           N  
ATOM    625  CA  ILE A 346     -11.600  -6.283  -2.478  1.00  0.00           C  
ATOM    626  C   ILE A 346     -10.423  -7.223  -2.216  1.00  0.00           C  
ATOM    627  O   ILE A 346      -9.580  -7.430  -3.066  1.00  0.00           O  
ATOM    628  CB  ILE A 346     -11.480  -5.022  -1.623  1.00  0.00           C  
ATOM    629  CG1 ILE A 346     -12.602  -4.048  -1.992  1.00  0.00           C  
ATOM    630  CG2 ILE A 346     -10.125  -4.359  -1.878  1.00  0.00           C  
ATOM    631  CD1 ILE A 346     -12.693  -3.920  -3.513  1.00  0.00           C  
ATOM    632  H   ILE A 346     -13.415  -6.508  -1.336  1.00  0.00           H  
ATOM    633  HA  ILE A 346     -11.647  -6.017  -3.522  1.00  0.00           H  
ATOM    634  HB  ILE A 346     -11.559  -5.287  -0.579  1.00  0.00           H  
ATOM    635 HG12 ILE A 346     -13.541  -4.416  -1.603  1.00  0.00           H  
ATOM    636 HG13 ILE A 346     -12.392  -3.080  -1.563  1.00  0.00           H  
ATOM    637 HG21 ILE A 346     -10.006  -3.516  -1.213  1.00  0.00           H  
ATOM    638 HG22 ILE A 346     -10.076  -4.020  -2.901  1.00  0.00           H  
ATOM    639 HG23 ILE A 346      -9.336  -5.074  -1.698  1.00  0.00           H  
ATOM    640 HD11 ILE A 346     -13.370  -3.118  -3.767  1.00  0.00           H  
ATOM    641 HD12 ILE A 346     -13.059  -4.846  -3.932  1.00  0.00           H  
ATOM    642 HD13 ILE A 346     -11.714  -3.705  -3.916  1.00  0.00           H  
ATOM    643  N   CYS A 347     -10.357  -7.793  -1.044  1.00  0.00           N  
ATOM    644  CA  CYS A 347      -9.232  -8.720  -0.729  1.00  0.00           C  
ATOM    645  C   CYS A 347      -9.257  -9.927  -1.672  1.00  0.00           C  
ATOM    646  O   CYS A 347      -8.233 -10.378  -2.143  1.00  0.00           O  
ATOM    647  CB  CYS A 347      -9.474  -9.161   0.715  1.00  0.00           C  
ATOM    648  SG  CYS A 347      -8.580  -8.057   1.838  1.00  0.00           S  
ATOM    649  H   CYS A 347     -11.047  -7.614  -0.371  1.00  0.00           H  
ATOM    650  HA  CYS A 347      -8.288  -8.204  -0.803  1.00  0.00           H  
ATOM    651  HB2 CYS A 347     -10.531  -9.119   0.933  1.00  0.00           H  
ATOM    652  HB3 CYS A 347      -9.119 -10.172   0.846  1.00  0.00           H  
ATOM    653  HG  CYS A 347      -9.030  -8.071   2.685  1.00  0.00           H  
ATOM    654  N   LYS A 348     -10.419 -10.451  -1.951  1.00  0.00           N  
ATOM    655  CA  LYS A 348     -10.505 -11.630  -2.862  1.00  0.00           C  
ATOM    656  C   LYS A 348      -9.967 -11.267  -4.250  1.00  0.00           C  
ATOM    657  O   LYS A 348      -9.026 -11.862  -4.736  1.00  0.00           O  
ATOM    658  CB  LYS A 348     -11.994 -11.968  -2.938  1.00  0.00           C  
ATOM    659  CG  LYS A 348     -12.458 -12.543  -1.599  1.00  0.00           C  
ATOM    660  CD  LYS A 348     -11.817 -13.915  -1.380  1.00  0.00           C  
ATOM    661  CE  LYS A 348     -12.895 -14.999  -1.444  1.00  0.00           C  
ATOM    662  NZ  LYS A 348     -13.012 -15.341  -2.888  1.00  0.00           N  
ATOM    663  H   LYS A 348     -11.234 -10.073  -1.561  1.00  0.00           H  
ATOM    664  HA  LYS A 348      -9.957 -12.464  -2.452  1.00  0.00           H  
ATOM    665  HB2 LYS A 348     -12.556 -11.073  -3.161  1.00  0.00           H  
ATOM    666  HB3 LYS A 348     -12.157 -12.699  -3.716  1.00  0.00           H  
ATOM    667  HG2 LYS A 348     -12.163 -11.876  -0.801  1.00  0.00           H  
ATOM    668  HG3 LYS A 348     -13.532 -12.646  -1.604  1.00  0.00           H  
ATOM    669  HD2 LYS A 348     -11.079 -14.094  -2.150  1.00  0.00           H  
ATOM    670  HD3 LYS A 348     -11.340 -13.941  -0.413  1.00  0.00           H  
ATOM    671  HE2 LYS A 348     -12.589 -15.865  -0.872  1.00  0.00           H  
ATOM    672  HE3 LYS A 348     -13.835 -14.618  -1.078  1.00  0.00           H  
ATOM    673  HZ1 LYS A 348     -12.082 -15.246  -3.344  1.00  0.00           H  
ATOM    674  HZ2 LYS A 348     -13.689 -14.696  -3.344  1.00  0.00           H  
ATOM    675  HZ3 LYS A 348     -13.344 -16.321  -2.988  1.00  0.00           H  
ATOM    676  N   LYS A 349     -10.562 -10.300  -4.894  1.00  0.00           N  
ATOM    677  CA  LYS A 349     -10.087  -9.903  -6.251  1.00  0.00           C  
ATOM    678  C   LYS A 349      -8.631  -9.438  -6.188  1.00  0.00           C  
ATOM    679  O   LYS A 349      -7.777  -9.929  -6.905  1.00  0.00           O  
ATOM    680  CB  LYS A 349     -11.000  -8.751  -6.669  1.00  0.00           C  
ATOM    681  CG  LYS A 349     -12.130  -9.287  -7.551  1.00  0.00           C  
ATOM    682  CD  LYS A 349     -13.147 -10.030  -6.684  1.00  0.00           C  
ATOM    683  CE  LYS A 349     -14.429  -9.202  -6.579  1.00  0.00           C  
ATOM    684  NZ  LYS A 349     -15.333 -10.002  -5.709  1.00  0.00           N  
ATOM    685  H   LYS A 349     -11.322  -9.835  -4.485  1.00  0.00           H  
ATOM    686  HA  LYS A 349     -10.191 -10.726  -6.942  1.00  0.00           H  
ATOM    687  HB2 LYS A 349     -11.420  -8.288  -5.788  1.00  0.00           H  
ATOM    688  HB3 LYS A 349     -10.431  -8.021  -7.222  1.00  0.00           H  
ATOM    689  HG2 LYS A 349     -12.617  -8.465  -8.054  1.00  0.00           H  
ATOM    690  HG3 LYS A 349     -11.722  -9.966  -8.285  1.00  0.00           H  
ATOM    691  HD2 LYS A 349     -13.371 -10.988  -7.131  1.00  0.00           H  
ATOM    692  HD3 LYS A 349     -12.736 -10.180  -5.696  1.00  0.00           H  
ATOM    693  HE2 LYS A 349     -14.218  -8.240  -6.126  1.00  0.00           H  
ATOM    694  HE3 LYS A 349     -14.872  -9.070  -7.554  1.00  0.00           H  
ATOM    695  HZ1 LYS A 349     -16.321  -9.731  -5.892  1.00  0.00           H  
ATOM    696  HZ2 LYS A 349     -15.103  -9.822  -4.710  1.00  0.00           H  
ATOM    697  HZ3 LYS A 349     -15.210 -11.013  -5.917  1.00  0.00           H  
ATOM    698  N   VAL A 350      -8.339  -8.491  -5.338  1.00  0.00           N  
ATOM    699  CA  VAL A 350      -6.939  -7.992  -5.229  1.00  0.00           C  
ATOM    700  C   VAL A 350      -5.960  -9.168  -5.260  1.00  0.00           C  
ATOM    701  O   VAL A 350      -5.096  -9.245  -6.110  1.00  0.00           O  
ATOM    702  CB  VAL A 350      -6.876  -7.277  -3.879  1.00  0.00           C  
ATOM    703  CG1 VAL A 350      -5.414  -7.062  -3.482  1.00  0.00           C  
ATOM    704  CG2 VAL A 350      -7.577  -5.922  -3.991  1.00  0.00           C  
ATOM    705  H   VAL A 350      -9.041  -8.108  -4.771  1.00  0.00           H  
ATOM    706  HA  VAL A 350      -6.721  -7.299  -6.025  1.00  0.00           H  
ATOM    707  HB  VAL A 350      -7.368  -7.880  -3.129  1.00  0.00           H  
ATOM    708 HG11 VAL A 350      -5.370  -6.502  -2.561  1.00  0.00           H  
ATOM    709 HG12 VAL A 350      -4.908  -6.513  -4.261  1.00  0.00           H  
ATOM    710 HG13 VAL A 350      -4.934  -8.019  -3.346  1.00  0.00           H  
ATOM    711 HG21 VAL A 350      -8.251  -5.796  -3.154  1.00  0.00           H  
ATOM    712 HG22 VAL A 350      -8.138  -5.880  -4.913  1.00  0.00           H  
ATOM    713 HG23 VAL A 350      -6.841  -5.132  -3.981  1.00  0.00           H  
ATOM    714  N   TYR A 351      -6.091 -10.090  -4.345  1.00  0.00           N  
ATOM    715  CA  TYR A 351      -5.170 -11.260  -4.333  1.00  0.00           C  
ATOM    716  C   TYR A 351      -5.116 -11.886  -5.729  1.00  0.00           C  
ATOM    717  O   TYR A 351      -4.064 -12.243  -6.221  1.00  0.00           O  
ATOM    718  CB  TYR A 351      -5.778 -12.239  -3.327  1.00  0.00           C  
ATOM    719  CG  TYR A 351      -5.895 -11.579  -1.970  1.00  0.00           C  
ATOM    720  CD1 TYR A 351      -5.164 -10.420  -1.679  1.00  0.00           C  
ATOM    721  CD2 TYR A 351      -6.739 -12.134  -1.000  1.00  0.00           C  
ATOM    722  CE1 TYR A 351      -5.277  -9.818  -0.422  1.00  0.00           C  
ATOM    723  CE2 TYR A 351      -6.853 -11.530   0.259  1.00  0.00           C  
ATOM    724  CZ  TYR A 351      -6.121 -10.373   0.548  1.00  0.00           C  
ATOM    725  OH  TYR A 351      -6.232  -9.780   1.788  1.00  0.00           O  
ATOM    726  H   TYR A 351      -6.797 -10.014  -3.669  1.00  0.00           H  
ATOM    727  HA  TYR A 351      -4.185 -10.963  -4.013  1.00  0.00           H  
ATOM    728  HB2 TYR A 351      -6.758 -12.538  -3.666  1.00  0.00           H  
ATOM    729  HB3 TYR A 351      -5.144 -13.110  -3.248  1.00  0.00           H  
ATOM    730  HD1 TYR A 351      -4.512  -9.990  -2.427  1.00  0.00           H  
ATOM    731  HD2 TYR A 351      -7.304 -13.027  -1.222  1.00  0.00           H  
ATOM    732  HE1 TYR A 351      -4.713  -8.923  -0.198  1.00  0.00           H  
ATOM    733  HE2 TYR A 351      -7.503 -11.959   1.007  1.00  0.00           H  
ATOM    734  HH  TYR A 351      -6.348 -10.474   2.441  1.00  0.00           H  
ATOM    735  N   GLU A 352      -6.244 -12.014  -6.373  1.00  0.00           N  
ATOM    736  CA  GLU A 352      -6.258 -12.607  -7.740  1.00  0.00           C  
ATOM    737  C   GLU A 352      -5.137 -11.996  -8.579  1.00  0.00           C  
ATOM    738  O   GLU A 352      -4.448 -12.683  -9.308  1.00  0.00           O  
ATOM    739  CB  GLU A 352      -7.626 -12.241  -8.318  1.00  0.00           C  
ATOM    740  CG  GLU A 352      -8.094 -13.350  -9.261  1.00  0.00           C  
ATOM    741  CD  GLU A 352      -8.574 -12.735 -10.576  1.00  0.00           C  
ATOM    742  OE1 GLU A 352      -9.664 -12.186 -10.589  1.00  0.00           O  
ATOM    743  OE2 GLU A 352      -7.843 -12.821 -11.548  1.00  0.00           O  
ATOM    744  H   GLU A 352      -7.081 -11.714  -5.960  1.00  0.00           H  
ATOM    745  HA  GLU A 352      -6.153 -13.679  -7.688  1.00  0.00           H  
ATOM    746  HB2 GLU A 352      -8.337 -12.125  -7.513  1.00  0.00           H  
ATOM    747  HB3 GLU A 352      -7.548 -11.314  -8.867  1.00  0.00           H  
ATOM    748  HG2 GLU A 352      -7.274 -14.026  -9.456  1.00  0.00           H  
ATOM    749  HG3 GLU A 352      -8.908 -13.892  -8.802  1.00  0.00           H  
ATOM    750  N   ASN A 353      -4.943 -10.710  -8.478  1.00  0.00           N  
ATOM    751  CA  ASN A 353      -3.861 -10.054  -9.265  1.00  0.00           C  
ATOM    752  C   ASN A 353      -2.550 -10.082  -8.474  1.00  0.00           C  
ATOM    753  O   ASN A 353      -1.487  -9.817  -9.000  1.00  0.00           O  
ATOM    754  CB  ASN A 353      -4.335  -8.615  -9.469  1.00  0.00           C  
ATOM    755  CG  ASN A 353      -4.123  -8.210 -10.929  1.00  0.00           C  
ATOM    756  OD1 ASN A 353      -4.725  -8.773 -11.822  1.00  0.00           O  
ATOM    757  ND2 ASN A 353      -3.285  -7.251 -11.211  1.00  0.00           N  
ATOM    758  H   ASN A 353      -5.507 -10.175  -7.880  1.00  0.00           H  
ATOM    759  HA  ASN A 353      -3.738 -10.543 -10.219  1.00  0.00           H  
ATOM    760  HB2 ASN A 353      -5.386  -8.545  -9.224  1.00  0.00           H  
ATOM    761  HB3 ASN A 353      -3.770  -7.955  -8.829  1.00  0.00           H  
ATOM    762 HD21 ASN A 353      -2.799  -6.797 -10.491  1.00  0.00           H  
ATOM    763 HD22 ASN A 353      -3.141  -6.985 -12.143  1.00  0.00           H  
ATOM    764  N   TYR A 354      -2.619 -10.403  -7.210  1.00  0.00           N  
ATOM    765  CA  TYR A 354      -1.382 -10.450  -6.380  1.00  0.00           C  
ATOM    766  C   TYR A 354      -1.273 -11.805  -5.674  1.00  0.00           C  
ATOM    767  O   TYR A 354      -1.193 -11.872  -4.465  1.00  0.00           O  
ATOM    768  CB  TYR A 354      -1.547  -9.322  -5.363  1.00  0.00           C  
ATOM    769  CG  TYR A 354      -1.475  -7.993  -6.076  1.00  0.00           C  
ATOM    770  CD1 TYR A 354      -0.440  -7.745  -6.985  1.00  0.00           C  
ATOM    771  CD2 TYR A 354      -2.444  -7.012  -5.833  1.00  0.00           C  
ATOM    772  CE1 TYR A 354      -0.372  -6.515  -7.650  1.00  0.00           C  
ATOM    773  CE2 TYR A 354      -2.376  -5.782  -6.500  1.00  0.00           C  
ATOM    774  CZ  TYR A 354      -1.340  -5.534  -7.408  1.00  0.00           C  
ATOM    775  OH  TYR A 354      -1.273  -4.322  -8.063  1.00  0.00           O  
ATOM    776  H   TYR A 354      -3.486 -10.612  -6.807  1.00  0.00           H  
ATOM    777  HA  TYR A 354      -0.511 -10.271  -6.991  1.00  0.00           H  
ATOM    778  HB2 TYR A 354      -2.504  -9.416  -4.871  1.00  0.00           H  
ATOM    779  HB3 TYR A 354      -0.757  -9.378  -4.629  1.00  0.00           H  
ATOM    780  HD1 TYR A 354       0.307  -8.502  -7.171  1.00  0.00           H  
ATOM    781  HD2 TYR A 354      -3.243  -7.203  -5.132  1.00  0.00           H  
ATOM    782  HE1 TYR A 354       0.427  -6.324  -8.351  1.00  0.00           H  
ATOM    783  HE2 TYR A 354      -3.122  -5.024  -6.312  1.00  0.00           H  
ATOM    784  HH  TYR A 354      -1.047  -4.493  -8.981  1.00  0.00           H  
ATOM    785  N   PRO A 355      -1.278 -12.845  -6.464  1.00  0.00           N  
ATOM    786  CA  PRO A 355      -1.180 -14.220  -5.919  1.00  0.00           C  
ATOM    787  C   PRO A 355       0.253 -14.515  -5.468  1.00  0.00           C  
ATOM    788  O   PRO A 355       0.493 -14.899  -4.341  1.00  0.00           O  
ATOM    789  CB  PRO A 355      -1.569 -15.102  -7.101  1.00  0.00           C  
ATOM    790  CG  PRO A 355      -1.259 -14.287  -8.316  1.00  0.00           C  
ATOM    791  CD  PRO A 355      -1.374 -12.835  -7.928  1.00  0.00           C  
ATOM    792  HA  PRO A 355      -1.874 -14.359  -5.106  1.00  0.00           H  
ATOM    793  HB2 PRO A 355      -0.983 -16.011  -7.095  1.00  0.00           H  
ATOM    794  HB3 PRO A 355      -2.622 -15.331  -7.068  1.00  0.00           H  
ATOM    795  HG2 PRO A 355      -0.255 -14.502  -8.655  1.00  0.00           H  
ATOM    796  HG3 PRO A 355      -1.968 -14.509  -9.099  1.00  0.00           H  
ATOM    797  HD2 PRO A 355      -0.562 -12.264  -8.359  1.00  0.00           H  
ATOM    798  HD3 PRO A 355      -2.327 -12.433  -8.235  1.00  0.00           H  
ATOM    799  N   THR A 356       1.207 -14.340  -6.341  1.00  0.00           N  
ATOM    800  CA  THR A 356       2.623 -14.612  -5.963  1.00  0.00           C  
ATOM    801  C   THR A 356       3.185 -13.443  -5.149  1.00  0.00           C  
ATOM    802  O   THR A 356       4.213 -12.884  -5.475  1.00  0.00           O  
ATOM    803  CB  THR A 356       3.366 -14.751  -7.293  1.00  0.00           C  
ATOM    804  OG1 THR A 356       3.403 -13.490  -7.947  1.00  0.00           O  
ATOM    805  CG2 THR A 356       2.644 -15.769  -8.180  1.00  0.00           C  
ATOM    806  H   THR A 356       0.992 -14.031  -7.246  1.00  0.00           H  
ATOM    807  HA  THR A 356       2.693 -15.531  -5.403  1.00  0.00           H  
ATOM    808  HB  THR A 356       4.373 -15.090  -7.109  1.00  0.00           H  
ATOM    809  HG1 THR A 356       3.448 -13.648  -8.893  1.00  0.00           H  
ATOM    810 HG21 THR A 356       2.915 -15.601  -9.212  1.00  0.00           H  
ATOM    811 HG22 THR A 356       1.576 -15.653  -8.065  1.00  0.00           H  
ATOM    812 HG23 THR A 356       2.932 -16.768  -7.890  1.00  0.00           H  
ATOM    813  N   TYR A 357       2.518 -13.070  -4.090  1.00  0.00           N  
ATOM    814  CA  TYR A 357       3.011 -11.937  -3.256  1.00  0.00           C  
ATOM    815  C   TYR A 357       2.534 -12.092  -1.810  1.00  0.00           C  
ATOM    816  O   TYR A 357       1.496 -12.667  -1.547  1.00  0.00           O  
ATOM    817  CB  TYR A 357       2.394 -10.685  -3.881  1.00  0.00           C  
ATOM    818  CG  TYR A 357       3.071 -10.385  -5.198  1.00  0.00           C  
ATOM    819  CD1 TYR A 357       4.467 -10.307  -5.267  1.00  0.00           C  
ATOM    820  CD2 TYR A 357       2.301 -10.181  -6.347  1.00  0.00           C  
ATOM    821  CE1 TYR A 357       5.091 -10.024  -6.488  1.00  0.00           C  
ATOM    822  CE2 TYR A 357       2.924  -9.898  -7.568  1.00  0.00           C  
ATOM    823  CZ  TYR A 357       4.320  -9.819  -7.639  1.00  0.00           C  
ATOM    824  OH  TYR A 357       4.934  -9.539  -8.842  1.00  0.00           O  
ATOM    825  H   TYR A 357       1.690 -13.534  -3.846  1.00  0.00           H  
ATOM    826  HA  TYR A 357       4.087 -11.877  -3.297  1.00  0.00           H  
ATOM    827  HB2 TYR A 357       1.340 -10.852  -4.050  1.00  0.00           H  
ATOM    828  HB3 TYR A 357       2.523  -9.849  -3.213  1.00  0.00           H  
ATOM    829  HD1 TYR A 357       5.062 -10.464  -4.380  1.00  0.00           H  
ATOM    830  HD2 TYR A 357       1.223 -10.242  -6.293  1.00  0.00           H  
ATOM    831  HE1 TYR A 357       6.168  -9.964  -6.543  1.00  0.00           H  
ATOM    832  HE2 TYR A 357       2.328  -9.741  -8.455  1.00  0.00           H  
ATOM    833  HH  TYR A 357       5.650 -10.169  -8.963  1.00  0.00           H  
ATOM    834  N   ASP A 358       3.277 -11.573  -0.873  1.00  0.00           N  
ATOM    835  CA  ASP A 358       2.862 -11.677   0.556  1.00  0.00           C  
ATOM    836  C   ASP A 358       2.234 -10.356   1.003  1.00  0.00           C  
ATOM    837  O   ASP A 358       2.652  -9.753   1.973  1.00  0.00           O  
ATOM    838  CB  ASP A 358       4.153 -11.945   1.328  1.00  0.00           C  
ATOM    839  CG  ASP A 358       4.545 -13.416   1.175  1.00  0.00           C  
ATOM    840  OD1 ASP A 358       3.722 -14.182   0.704  1.00  0.00           O  
ATOM    841  OD2 ASP A 358       5.662 -13.751   1.532  1.00  0.00           O  
ATOM    842  H   ASP A 358       4.106 -11.105  -1.109  1.00  0.00           H  
ATOM    843  HA  ASP A 358       2.169 -12.492   0.692  1.00  0.00           H  
ATOM    844  HB2 ASP A 358       4.942 -11.318   0.938  1.00  0.00           H  
ATOM    845  HB3 ASP A 358       4.000 -11.722   2.373  1.00  0.00           H  
ATOM    846  N   LEU A 359       1.240  -9.895   0.294  1.00  0.00           N  
ATOM    847  CA  LEU A 359       0.592  -8.605   0.664  1.00  0.00           C  
ATOM    848  C   LEU A 359       0.064  -8.651   2.101  1.00  0.00           C  
ATOM    849  O   LEU A 359      -1.017  -9.138   2.363  1.00  0.00           O  
ATOM    850  CB  LEU A 359      -0.566  -8.444  -0.320  1.00  0.00           C  
ATOM    851  CG  LEU A 359      -0.264  -7.294  -1.282  1.00  0.00           C  
ATOM    852  CD1 LEU A 359       0.044  -6.028  -0.485  1.00  0.00           C  
ATOM    853  CD2 LEU A 359       0.944  -7.658  -2.149  1.00  0.00           C  
ATOM    854  H   LEU A 359       0.927 -10.392  -0.489  1.00  0.00           H  
ATOM    855  HA  LEU A 359       1.286  -7.789   0.547  1.00  0.00           H  
ATOM    856  HB2 LEU A 359      -0.694  -9.359  -0.878  1.00  0.00           H  
ATOM    857  HB3 LEU A 359      -1.470  -8.224   0.226  1.00  0.00           H  
ATOM    858  HG  LEU A 359      -1.123  -7.119  -1.915  1.00  0.00           H  
ATOM    859 HD11 LEU A 359      -0.616  -5.233  -0.803  1.00  0.00           H  
ATOM    860 HD12 LEU A 359       1.069  -5.734  -0.657  1.00  0.00           H  
ATOM    861 HD13 LEU A 359      -0.104  -6.219   0.567  1.00  0.00           H  
ATOM    862 HD21 LEU A 359       0.729  -8.558  -2.706  1.00  0.00           H  
ATOM    863 HD22 LEU A 359       1.804  -7.822  -1.517  1.00  0.00           H  
ATOM    864 HD23 LEU A 359       1.151  -6.850  -2.836  1.00  0.00           H  
ATOM    865  N   THR A 360       0.816  -8.130   3.028  1.00  0.00           N  
ATOM    866  CA  THR A 360       0.358  -8.118   4.447  1.00  0.00           C  
ATOM    867  C   THR A 360       0.054  -6.677   4.859  1.00  0.00           C  
ATOM    868  O   THR A 360      -1.066  -6.330   5.186  1.00  0.00           O  
ATOM    869  CB  THR A 360       1.528  -8.678   5.261  1.00  0.00           C  
ATOM    870  OG1 THR A 360       2.584  -9.050   4.385  1.00  0.00           O  
ATOM    871  CG2 THR A 360       1.062  -9.901   6.051  1.00  0.00           C  
ATOM    872  H   THR A 360       1.679  -7.730   2.792  1.00  0.00           H  
ATOM    873  HA  THR A 360      -0.516  -8.741   4.570  1.00  0.00           H  
ATOM    874  HB  THR A 360       1.880  -7.924   5.948  1.00  0.00           H  
ATOM    875  HG1 THR A 360       2.285  -9.795   3.859  1.00  0.00           H  
ATOM    876 HG21 THR A 360       1.885 -10.287   6.636  1.00  0.00           H  
ATOM    877 HG22 THR A 360       0.719 -10.662   5.366  1.00  0.00           H  
ATOM    878 HG23 THR A 360       0.255  -9.618   6.710  1.00  0.00           H  
ATOM    879  N   GLU A 361       1.043  -5.828   4.818  1.00  0.00           N  
ATOM    880  CA  GLU A 361       0.820  -4.402   5.178  1.00  0.00           C  
ATOM    881  C   GLU A 361       0.155  -3.689   4.003  1.00  0.00           C  
ATOM    882  O   GLU A 361      -0.869  -3.045   4.147  1.00  0.00           O  
ATOM    883  CB  GLU A 361       2.214  -3.830   5.442  1.00  0.00           C  
ATOM    884  CG  GLU A 361       2.279  -3.280   6.867  1.00  0.00           C  
ATOM    885  CD  GLU A 361       2.499  -4.430   7.851  1.00  0.00           C  
ATOM    886  OE1 GLU A 361       2.548  -5.565   7.403  1.00  0.00           O  
ATOM    887  OE2 GLU A 361       2.614  -4.159   9.035  1.00  0.00           O  
ATOM    888  H   GLU A 361       1.931  -6.128   4.530  1.00  0.00           H  
ATOM    889  HA  GLU A 361       0.210  -4.324   6.066  1.00  0.00           H  
ATOM    890  HB2 GLU A 361       2.951  -4.612   5.323  1.00  0.00           H  
ATOM    891  HB3 GLU A 361       2.416  -3.035   4.741  1.00  0.00           H  
ATOM    892  HG2 GLU A 361       3.098  -2.578   6.945  1.00  0.00           H  
ATOM    893  HG3 GLU A 361       1.352  -2.780   7.103  1.00  0.00           H  
ATOM    894  N   ARG A 362       0.715  -3.819   2.830  1.00  0.00           N  
ATOM    895  CA  ARG A 362       0.098  -3.171   1.643  1.00  0.00           C  
ATOM    896  C   ARG A 362      -1.318  -3.717   1.471  1.00  0.00           C  
ATOM    897  O   ARG A 362      -2.179  -3.081   0.897  1.00  0.00           O  
ATOM    898  CB  ARG A 362       0.984  -3.567   0.462  1.00  0.00           C  
ATOM    899  CG  ARG A 362       2.024  -2.473   0.210  1.00  0.00           C  
ATOM    900  CD  ARG A 362       3.425  -3.034   0.459  1.00  0.00           C  
ATOM    901  NE  ARG A 362       3.955  -2.246   1.606  1.00  0.00           N  
ATOM    902  CZ  ARG A 362       5.143  -2.503   2.081  1.00  0.00           C  
ATOM    903  NH1 ARG A 362       6.201  -2.279   1.348  1.00  0.00           N  
ATOM    904  NH2 ARG A 362       5.275  -2.983   3.286  1.00  0.00           N  
ATOM    905  H   ARG A 362       1.529  -4.355   2.730  1.00  0.00           H  
ATOM    906  HA  ARG A 362       0.083  -2.098   1.758  1.00  0.00           H  
ATOM    907  HB2 ARG A 362       1.485  -4.498   0.686  1.00  0.00           H  
ATOM    908  HB3 ARG A 362       0.373  -3.691  -0.420  1.00  0.00           H  
ATOM    909  HG2 ARG A 362       1.947  -2.135  -0.813  1.00  0.00           H  
ATOM    910  HG3 ARG A 362       1.845  -1.646   0.878  1.00  0.00           H  
ATOM    911  HD2 ARG A 362       3.370  -4.084   0.713  1.00  0.00           H  
ATOM    912  HD3 ARG A 362       4.049  -2.887  -0.409  1.00  0.00           H  
ATOM    913  HE  ARG A 362       3.411  -1.538   2.005  1.00  0.00           H  
ATOM    914 HH11 ARG A 362       6.099  -1.911   0.424  1.00  0.00           H  
ATOM    915 HH12 ARG A 362       7.111  -2.476   1.712  1.00  0.00           H  
ATOM    916 HH21 ARG A 362       4.464  -3.155   3.846  1.00  0.00           H  
ATOM    917 HH22 ARG A 362       6.185  -3.178   3.650  1.00  0.00           H  
ATOM    918  N   LYS A 363      -1.567  -4.892   1.987  1.00  0.00           N  
ATOM    919  CA  LYS A 363      -2.928  -5.479   1.880  1.00  0.00           C  
ATOM    920  C   LYS A 363      -3.892  -4.650   2.727  1.00  0.00           C  
ATOM    921  O   LYS A 363      -4.883  -4.144   2.240  1.00  0.00           O  
ATOM    922  CB  LYS A 363      -2.801  -6.897   2.436  1.00  0.00           C  
ATOM    923  CG  LYS A 363      -4.184  -7.546   2.507  1.00  0.00           C  
ATOM    924  CD  LYS A 363      -4.608  -7.687   3.970  1.00  0.00           C  
ATOM    925  CE  LYS A 363      -3.661  -8.652   4.686  1.00  0.00           C  
ATOM    926  NZ  LYS A 363      -4.488  -9.283   5.751  1.00  0.00           N  
ATOM    927  H   LYS A 363      -0.859  -5.379   2.458  1.00  0.00           H  
ATOM    928  HA  LYS A 363      -3.253  -5.508   0.853  1.00  0.00           H  
ATOM    929  HB2 LYS A 363      -2.162  -7.479   1.788  1.00  0.00           H  
ATOM    930  HB3 LYS A 363      -2.372  -6.860   3.426  1.00  0.00           H  
ATOM    931  HG2 LYS A 363      -4.898  -6.928   1.981  1.00  0.00           H  
ATOM    932  HG3 LYS A 363      -4.148  -8.522   2.050  1.00  0.00           H  
ATOM    933  HD2 LYS A 363      -4.570  -6.719   4.451  1.00  0.00           H  
ATOM    934  HD3 LYS A 363      -5.615  -8.073   4.017  1.00  0.00           H  
ATOM    935  HE2 LYS A 363      -3.297  -9.400   3.994  1.00  0.00           H  
ATOM    936  HE3 LYS A 363      -2.838  -8.112   5.127  1.00  0.00           H  
ATOM    937  HZ1 LYS A 363      -3.891  -9.492   6.576  1.00  0.00           H  
ATOM    938  HZ2 LYS A 363      -4.903 -10.166   5.389  1.00  0.00           H  
ATOM    939  HZ3 LYS A 363      -5.248  -8.632   6.033  1.00  0.00           H  
ATOM    940  N   ASP A 364      -3.597  -4.487   3.990  1.00  0.00           N  
ATOM    941  CA  ASP A 364      -4.491  -3.664   4.850  1.00  0.00           C  
ATOM    942  C   ASP A 364      -4.813  -2.362   4.117  1.00  0.00           C  
ATOM    943  O   ASP A 364      -5.882  -1.801   4.256  1.00  0.00           O  
ATOM    944  CB  ASP A 364      -3.684  -3.386   6.118  1.00  0.00           C  
ATOM    945  CG  ASP A 364      -3.696  -4.626   7.014  1.00  0.00           C  
ATOM    946  OD1 ASP A 364      -4.344  -5.592   6.647  1.00  0.00           O  
ATOM    947  OD2 ASP A 364      -3.058  -4.589   8.053  1.00  0.00           O  
ATOM    948  H   ASP A 364      -2.785  -4.889   4.363  1.00  0.00           H  
ATOM    949  HA  ASP A 364      -5.394  -4.203   5.089  1.00  0.00           H  
ATOM    950  HB2 ASP A 364      -2.666  -3.146   5.850  1.00  0.00           H  
ATOM    951  HB3 ASP A 364      -4.123  -2.556   6.652  1.00  0.00           H  
ATOM    952  N   PHE A 365      -3.891  -1.891   3.320  1.00  0.00           N  
ATOM    953  CA  PHE A 365      -4.131  -0.638   2.552  1.00  0.00           C  
ATOM    954  C   PHE A 365      -5.188  -0.903   1.473  1.00  0.00           C  
ATOM    955  O   PHE A 365      -6.196  -0.230   1.397  1.00  0.00           O  
ATOM    956  CB  PHE A 365      -2.763  -0.294   1.940  1.00  0.00           C  
ATOM    957  CG  PHE A 365      -2.931   0.364   0.587  1.00  0.00           C  
ATOM    958  CD1 PHE A 365      -3.482   1.645   0.493  1.00  0.00           C  
ATOM    959  CD2 PHE A 365      -2.534  -0.315  -0.572  1.00  0.00           C  
ATOM    960  CE1 PHE A 365      -3.637   2.250  -0.760  1.00  0.00           C  
ATOM    961  CE2 PHE A 365      -2.686   0.288  -1.825  1.00  0.00           C  
ATOM    962  CZ  PHE A 365      -3.239   1.572  -1.918  1.00  0.00           C  
ATOM    963  H   PHE A 365      -3.044  -2.372   3.217  1.00  0.00           H  
ATOM    964  HA  PHE A 365      -4.454   0.153   3.212  1.00  0.00           H  
ATOM    965  HB2 PHE A 365      -2.240   0.383   2.599  1.00  0.00           H  
ATOM    966  HB3 PHE A 365      -2.185  -1.199   1.828  1.00  0.00           H  
ATOM    967  HD1 PHE A 365      -3.790   2.168   1.387  1.00  0.00           H  
ATOM    968  HD2 PHE A 365      -2.107  -1.306  -0.498  1.00  0.00           H  
ATOM    969  HE1 PHE A 365      -4.062   3.241  -0.833  1.00  0.00           H  
ATOM    970  HE2 PHE A 365      -2.380  -0.233  -2.718  1.00  0.00           H  
ATOM    971  HZ  PHE A 365      -3.357   2.040  -2.886  1.00  0.00           H  
ATOM    972  N   ILE A 366      -4.966  -1.889   0.645  1.00  0.00           N  
ATOM    973  CA  ILE A 366      -5.959  -2.205  -0.419  1.00  0.00           C  
ATOM    974  C   ILE A 366      -7.371  -2.164   0.172  1.00  0.00           C  
ATOM    975  O   ILE A 366      -8.167  -1.304  -0.142  1.00  0.00           O  
ATOM    976  CB  ILE A 366      -5.605  -3.622  -0.879  1.00  0.00           C  
ATOM    977  CG1 ILE A 366      -4.408  -3.567  -1.831  1.00  0.00           C  
ATOM    978  CG2 ILE A 366      -6.801  -4.243  -1.606  1.00  0.00           C  
ATOM    979  CD1 ILE A 366      -3.555  -4.826  -1.659  1.00  0.00           C  
ATOM    980  H   ILE A 366      -4.149  -2.426   0.729  1.00  0.00           H  
ATOM    981  HA  ILE A 366      -5.869  -1.513  -1.240  1.00  0.00           H  
ATOM    982  HB  ILE A 366      -5.356  -4.228  -0.018  1.00  0.00           H  
ATOM    983 HG12 ILE A 366      -4.762  -3.510  -2.850  1.00  0.00           H  
ATOM    984 HG13 ILE A 366      -3.811  -2.696  -1.606  1.00  0.00           H  
ATOM    985 HG21 ILE A 366      -7.675  -4.187  -0.974  1.00  0.00           H  
ATOM    986 HG22 ILE A 366      -6.587  -5.277  -1.834  1.00  0.00           H  
ATOM    987 HG23 ILE A 366      -6.984  -3.703  -2.523  1.00  0.00           H  
ATOM    988 HD11 ILE A 366      -4.157  -5.612  -1.225  1.00  0.00           H  
ATOM    989 HD12 ILE A 366      -2.721  -4.609  -1.006  1.00  0.00           H  
ATOM    990 HD13 ILE A 366      -3.186  -5.145  -2.622  1.00  0.00           H  
ATOM    991  N   LYS A 367      -7.681  -3.091   1.037  1.00  0.00           N  
ATOM    992  CA  LYS A 367      -9.034  -3.111   1.660  1.00  0.00           C  
ATOM    993  C   LYS A 367      -9.427  -1.703   2.111  1.00  0.00           C  
ATOM    994  O   LYS A 367     -10.542  -1.262   1.908  1.00  0.00           O  
ATOM    995  CB  LYS A 367      -8.893  -4.043   2.864  1.00  0.00           C  
ATOM    996  CG  LYS A 367     -10.132  -3.926   3.754  1.00  0.00           C  
ATOM    997  CD  LYS A 367      -9.710  -3.509   5.164  1.00  0.00           C  
ATOM    998  CE  LYS A 367      -9.284  -2.039   5.156  1.00  0.00           C  
ATOM    999  NZ  LYS A 367      -9.517  -1.566   6.550  1.00  0.00           N  
ATOM   1000  H   LYS A 367      -7.021  -3.773   1.280  1.00  0.00           H  
ATOM   1001  HA  LYS A 367      -9.763  -3.507   0.970  1.00  0.00           H  
ATOM   1002  HB2 LYS A 367      -8.790  -5.063   2.521  1.00  0.00           H  
ATOM   1003  HB3 LYS A 367      -8.018  -3.766   3.432  1.00  0.00           H  
ATOM   1004  HG2 LYS A 367     -10.802  -3.185   3.343  1.00  0.00           H  
ATOM   1005  HG3 LYS A 367     -10.632  -4.882   3.799  1.00  0.00           H  
ATOM   1006  HD2 LYS A 367     -10.541  -3.640   5.842  1.00  0.00           H  
ATOM   1007  HD3 LYS A 367      -8.880  -4.119   5.488  1.00  0.00           H  
ATOM   1008  HE2 LYS A 367      -8.239  -1.953   4.896  1.00  0.00           H  
ATOM   1009  HE3 LYS A 367      -9.893  -1.474   4.467  1.00  0.00           H  
ATOM   1010  HZ1 LYS A 367     -10.498  -1.235   6.644  1.00  0.00           H  
ATOM   1011  HZ2 LYS A 367      -8.863  -0.784   6.763  1.00  0.00           H  
ATOM   1012  HZ3 LYS A 367      -9.351  -2.348   7.214  1.00  0.00           H  
ATOM   1013  N   THR A 368      -8.520  -0.995   2.725  1.00  0.00           N  
ATOM   1014  CA  THR A 368      -8.841   0.384   3.195  1.00  0.00           C  
ATOM   1015  C   THR A 368      -9.049   1.325   2.004  1.00  0.00           C  
ATOM   1016  O   THR A 368      -9.771   2.298   2.093  1.00  0.00           O  
ATOM   1017  CB  THR A 368      -7.623   0.815   4.014  1.00  0.00           C  
ATOM   1018  OG1 THR A 368      -7.531   0.009   5.181  1.00  0.00           O  
ATOM   1019  CG2 THR A 368      -7.768   2.283   4.416  1.00  0.00           C  
ATOM   1020  H   THR A 368      -7.629  -1.370   2.882  1.00  0.00           H  
ATOM   1021  HA  THR A 368      -9.717   0.372   3.822  1.00  0.00           H  
ATOM   1022  HB  THR A 368      -6.730   0.695   3.422  1.00  0.00           H  
ATOM   1023  HG1 THR A 368      -6.679   0.177   5.591  1.00  0.00           H  
ATOM   1024 HG21 THR A 368      -7.123   2.891   3.800  1.00  0.00           H  
ATOM   1025 HG22 THR A 368      -7.492   2.400   5.453  1.00  0.00           H  
ATOM   1026 HG23 THR A 368      -8.794   2.593   4.278  1.00  0.00           H  
ATOM   1027  N   THR A 369      -8.425   1.050   0.889  1.00  0.00           N  
ATOM   1028  CA  THR A 369      -8.598   1.943  -0.295  1.00  0.00           C  
ATOM   1029  C   THR A 369     -10.062   1.932  -0.750  1.00  0.00           C  
ATOM   1030  O   THR A 369     -10.622   2.952  -1.097  1.00  0.00           O  
ATOM   1031  CB  THR A 369      -7.654   1.372  -1.373  1.00  0.00           C  
ATOM   1032  OG1 THR A 369      -7.030   2.446  -2.061  1.00  0.00           O  
ATOM   1033  CG2 THR A 369      -8.422   0.506  -2.381  1.00  0.00           C  
ATOM   1034  H   THR A 369      -7.845   0.263   0.831  1.00  0.00           H  
ATOM   1035  HA  THR A 369      -8.299   2.949  -0.045  1.00  0.00           H  
ATOM   1036  HB  THR A 369      -6.896   0.767  -0.896  1.00  0.00           H  
ATOM   1037  HG1 THR A 369      -7.688   3.132  -2.199  1.00  0.00           H  
ATOM   1038 HG21 THR A 369      -9.223   1.086  -2.818  1.00  0.00           H  
ATOM   1039 HG22 THR A 369      -8.836  -0.354  -1.878  1.00  0.00           H  
ATOM   1040 HG23 THR A 369      -7.750   0.178  -3.160  1.00  0.00           H  
ATOM   1041  N   VAL A 370     -10.684   0.787  -0.745  1.00  0.00           N  
ATOM   1042  CA  VAL A 370     -12.109   0.714  -1.173  1.00  0.00           C  
ATOM   1043  C   VAL A 370     -13.023   1.136  -0.019  1.00  0.00           C  
ATOM   1044  O   VAL A 370     -13.926   1.929  -0.189  1.00  0.00           O  
ATOM   1045  CB  VAL A 370     -12.338  -0.751  -1.533  1.00  0.00           C  
ATOM   1046  CG1 VAL A 370     -13.766  -0.933  -2.051  1.00  0.00           C  
ATOM   1047  CG2 VAL A 370     -11.344  -1.168  -2.619  1.00  0.00           C  
ATOM   1048  H   VAL A 370     -10.214  -0.026  -0.459  1.00  0.00           H  
ATOM   1049  HA  VAL A 370     -12.276   1.337  -2.036  1.00  0.00           H  
ATOM   1050  HB  VAL A 370     -12.193  -1.366  -0.656  1.00  0.00           H  
ATOM   1051 HG11 VAL A 370     -14.346  -0.051  -1.825  1.00  0.00           H  
ATOM   1052 HG12 VAL A 370     -14.215  -1.792  -1.574  1.00  0.00           H  
ATOM   1053 HG13 VAL A 370     -13.745  -1.086  -3.120  1.00  0.00           H  
ATOM   1054 HG21 VAL A 370     -11.850  -1.210  -3.572  1.00  0.00           H  
ATOM   1055 HG22 VAL A 370     -10.938  -2.140  -2.383  1.00  0.00           H  
ATOM   1056 HG23 VAL A 370     -10.542  -0.447  -2.669  1.00  0.00           H  
ATOM   1057  N   LYS A 371     -12.789   0.615   1.154  1.00  0.00           N  
ATOM   1058  CA  LYS A 371     -13.642   0.990   2.318  1.00  0.00           C  
ATOM   1059  C   LYS A 371     -13.673   2.513   2.476  1.00  0.00           C  
ATOM   1060  O   LYS A 371     -14.662   3.083   2.894  1.00  0.00           O  
ATOM   1061  CB  LYS A 371     -12.967   0.336   3.524  1.00  0.00           C  
ATOM   1062  CG  LYS A 371     -13.944   0.308   4.703  1.00  0.00           C  
ATOM   1063  CD  LYS A 371     -13.156   0.276   6.015  1.00  0.00           C  
ATOM   1064  CE  LYS A 371     -12.562   1.660   6.287  1.00  0.00           C  
ATOM   1065  NZ  LYS A 371     -11.545   1.439   7.353  1.00  0.00           N  
ATOM   1066  H   LYS A 371     -12.052  -0.020   1.271  1.00  0.00           H  
ATOM   1067  HA  LYS A 371     -14.640   0.601   2.197  1.00  0.00           H  
ATOM   1068  HB2 LYS A 371     -12.677  -0.674   3.272  1.00  0.00           H  
ATOM   1069  HB3 LYS A 371     -12.092   0.904   3.799  1.00  0.00           H  
ATOM   1070  HG2 LYS A 371     -14.566   1.190   4.675  1.00  0.00           H  
ATOM   1071  HG3 LYS A 371     -14.562  -0.573   4.636  1.00  0.00           H  
ATOM   1072  HD2 LYS A 371     -13.817  -0.000   6.823  1.00  0.00           H  
ATOM   1073  HD3 LYS A 371     -12.358  -0.448   5.938  1.00  0.00           H  
ATOM   1074  HE2 LYS A 371     -12.095   2.049   5.394  1.00  0.00           H  
ATOM   1075  HE3 LYS A 371     -13.326   2.335   6.640  1.00  0.00           H  
ATOM   1076  HZ1 LYS A 371     -10.991   0.586   7.135  1.00  0.00           H  
ATOM   1077  HZ2 LYS A 371     -12.024   1.318   8.268  1.00  0.00           H  
ATOM   1078  HZ3 LYS A 371     -10.907   2.259   7.400  1.00  0.00           H  
ATOM   1079  N   GLU A 372     -12.601   3.176   2.138  1.00  0.00           N  
ATOM   1080  CA  GLU A 372     -12.574   4.661   2.263  1.00  0.00           C  
ATOM   1081  C   GLU A 372     -13.238   5.290   1.040  1.00  0.00           C  
ATOM   1082  O   GLU A 372     -13.791   6.369   1.104  1.00  0.00           O  
ATOM   1083  CB  GLU A 372     -11.091   5.031   2.323  1.00  0.00           C  
ATOM   1084  CG  GLU A 372     -10.660   5.175   3.784  1.00  0.00           C  
ATOM   1085  CD  GLU A 372      -9.332   5.933   3.852  1.00  0.00           C  
ATOM   1086  OE1 GLU A 372      -9.301   7.075   3.423  1.00  0.00           O  
ATOM   1087  OE2 GLU A 372      -8.369   5.359   4.334  1.00  0.00           O  
ATOM   1088  H   GLU A 372     -11.817   2.698   1.796  1.00  0.00           H  
ATOM   1089  HA  GLU A 372     -13.072   4.973   3.167  1.00  0.00           H  
ATOM   1090  HB2 GLU A 372     -10.507   4.256   1.848  1.00  0.00           H  
ATOM   1091  HB3 GLU A 372     -10.933   5.967   1.809  1.00  0.00           H  
ATOM   1092  HG2 GLU A 372     -11.415   5.721   4.331  1.00  0.00           H  
ATOM   1093  HG3 GLU A 372     -10.535   4.195   4.222  1.00  0.00           H  
ATOM   1094  N   LEU A 373     -13.197   4.614  -0.073  1.00  0.00           N  
ATOM   1095  CA  LEU A 373     -13.836   5.156  -1.299  1.00  0.00           C  
ATOM   1096  C   LEU A 373     -15.349   4.954  -1.194  1.00  0.00           C  
ATOM   1097  O   LEU A 373     -16.126   5.630  -1.838  1.00  0.00           O  
ATOM   1098  CB  LEU A 373     -13.225   4.338  -2.448  1.00  0.00           C  
ATOM   1099  CG  LEU A 373     -14.266   4.082  -3.543  1.00  0.00           C  
ATOM   1100  CD1 LEU A 373     -13.558   3.892  -4.886  1.00  0.00           C  
ATOM   1101  CD2 LEU A 373     -15.057   2.819  -3.200  1.00  0.00           C  
ATOM   1102  H   LEU A 373     -12.758   3.738  -0.100  1.00  0.00           H  
ATOM   1103  HA  LEU A 373     -13.599   6.202  -1.418  1.00  0.00           H  
ATOM   1104  HB2 LEU A 373     -12.393   4.882  -2.870  1.00  0.00           H  
ATOM   1105  HB3 LEU A 373     -12.875   3.392  -2.065  1.00  0.00           H  
ATOM   1106  HG  LEU A 373     -14.939   4.927  -3.607  1.00  0.00           H  
ATOM   1107 HD11 LEU A 373     -13.538   4.831  -5.418  1.00  0.00           H  
ATOM   1108 HD12 LEU A 373     -14.089   3.156  -5.471  1.00  0.00           H  
ATOM   1109 HD13 LEU A 373     -12.547   3.553  -4.714  1.00  0.00           H  
ATOM   1110 HD21 LEU A 373     -14.910   2.079  -3.974  1.00  0.00           H  
ATOM   1111 HD22 LEU A 373     -16.106   3.059  -3.125  1.00  0.00           H  
ATOM   1112 HD23 LEU A 373     -14.708   2.424  -2.255  1.00  0.00           H  
ATOM   1113  N   ILE A 374     -15.768   4.027  -0.377  1.00  0.00           N  
ATOM   1114  CA  ILE A 374     -17.224   3.779  -0.218  1.00  0.00           C  
ATOM   1115  C   ILE A 374     -17.796   4.717   0.846  1.00  0.00           C  
ATOM   1116  O   ILE A 374     -18.963   5.055   0.830  1.00  0.00           O  
ATOM   1117  CB  ILE A 374     -17.336   2.322   0.232  1.00  0.00           C  
ATOM   1118  CG1 ILE A 374     -16.880   1.403  -0.904  1.00  0.00           C  
ATOM   1119  CG2 ILE A 374     -18.790   2.008   0.587  1.00  0.00           C  
ATOM   1120  CD1 ILE A 374     -17.275  -0.040  -0.585  1.00  0.00           C  
ATOM   1121  H   ILE A 374     -15.122   3.497   0.136  1.00  0.00           H  
ATOM   1122  HA  ILE A 374     -17.729   3.916  -1.157  1.00  0.00           H  
ATOM   1123  HB  ILE A 374     -16.711   2.165   1.099  1.00  0.00           H  
ATOM   1124 HG12 ILE A 374     -17.350   1.711  -1.826  1.00  0.00           H  
ATOM   1125 HG13 ILE A 374     -15.807   1.466  -1.009  1.00  0.00           H  
ATOM   1126 HG21 ILE A 374     -19.298   1.620  -0.282  1.00  0.00           H  
ATOM   1127 HG22 ILE A 374     -19.283   2.910   0.919  1.00  0.00           H  
ATOM   1128 HG23 ILE A 374     -18.817   1.272   1.377  1.00  0.00           H  
ATOM   1129 HD11 ILE A 374     -16.870  -0.699  -1.339  1.00  0.00           H  
ATOM   1130 HD12 ILE A 374     -18.351  -0.125  -0.573  1.00  0.00           H  
ATOM   1131 HD13 ILE A 374     -16.881  -0.316   0.382  1.00  0.00           H  
ATOM   1132  N   SER A 375     -16.978   5.144   1.770  1.00  0.00           N  
ATOM   1133  CA  SER A 375     -17.468   6.061   2.836  1.00  0.00           C  
ATOM   1134  C   SER A 375     -17.189   7.516   2.452  1.00  0.00           C  
ATOM   1135  O   SER A 375     -17.915   8.417   2.823  1.00  0.00           O  
ATOM   1136  CB  SER A 375     -16.678   5.675   4.086  1.00  0.00           C  
ATOM   1137  OG  SER A 375     -17.160   6.421   5.195  1.00  0.00           O  
ATOM   1138  H   SER A 375     -16.040   4.858   1.763  1.00  0.00           H  
ATOM   1139  HA  SER A 375     -18.523   5.911   3.007  1.00  0.00           H  
ATOM   1140  HB2 SER A 375     -16.803   4.623   4.284  1.00  0.00           H  
ATOM   1141  HB3 SER A 375     -15.628   5.885   3.927  1.00  0.00           H  
ATOM   1142  HG  SER A 375     -17.836   5.899   5.632  1.00  0.00           H  
ATOM   1143  N   LEU A 376     -16.140   7.756   1.712  1.00  0.00           N  
ATOM   1144  CA  LEU A 376     -15.816   9.155   1.309  1.00  0.00           C  
ATOM   1145  C   LEU A 376     -16.024   9.343  -0.197  1.00  0.00           C  
ATOM   1146  O   LEU A 376     -15.704  10.374  -0.753  1.00  0.00           O  
ATOM   1147  CB  LEU A 376     -14.342   9.339   1.674  1.00  0.00           C  
ATOM   1148  CG  LEU A 376     -14.195  10.535   2.614  1.00  0.00           C  
ATOM   1149  CD1 LEU A 376     -12.941  10.360   3.474  1.00  0.00           C  
ATOM   1150  CD2 LEU A 376     -14.070  11.817   1.789  1.00  0.00           C  
ATOM   1151  H   LEU A 376     -15.564   7.017   1.424  1.00  0.00           H  
ATOM   1152  HA  LEU A 376     -16.420   9.855   1.863  1.00  0.00           H  
ATOM   1153  HB2 LEU A 376     -13.977   8.447   2.162  1.00  0.00           H  
ATOM   1154  HB3 LEU A 376     -13.769   9.519   0.776  1.00  0.00           H  
ATOM   1155  HG  LEU A 376     -15.063  10.599   3.255  1.00  0.00           H  
ATOM   1156 HD11 LEU A 376     -12.068  10.614   2.893  1.00  0.00           H  
ATOM   1157 HD12 LEU A 376     -12.870   9.333   3.801  1.00  0.00           H  
ATOM   1158 HD13 LEU A 376     -13.002  11.008   4.336  1.00  0.00           H  
ATOM   1159 HD21 LEU A 376     -15.053  12.153   1.496  1.00  0.00           H  
ATOM   1160 HD22 LEU A 376     -13.477  11.621   0.908  1.00  0.00           H  
ATOM   1161 HD23 LEU A 376     -13.590  12.581   2.384  1.00  0.00           H  
ATOM   1162  N   GLU A 377     -16.560   8.356  -0.860  1.00  0.00           N  
ATOM   1163  CA  GLU A 377     -16.790   8.483  -2.328  1.00  0.00           C  
ATOM   1164  C   GLU A 377     -17.771   7.408  -2.803  1.00  0.00           C  
ATOM   1165  O   GLU A 377     -17.684   6.919  -3.912  1.00  0.00           O  
ATOM   1166  CB  GLU A 377     -15.415   8.278  -2.966  1.00  0.00           C  
ATOM   1167  CG  GLU A 377     -14.827   9.636  -3.355  1.00  0.00           C  
ATOM   1168  CD  GLU A 377     -13.838   9.452  -4.506  1.00  0.00           C  
ATOM   1169  OE1 GLU A 377     -12.836   8.787  -4.301  1.00  0.00           O  
ATOM   1170  OE2 GLU A 377     -14.099   9.979  -5.575  1.00  0.00           O  
ATOM   1171  H   GLU A 377     -16.813   7.532  -0.394  1.00  0.00           H  
ATOM   1172  HA  GLU A 377     -17.164   9.465  -2.568  1.00  0.00           H  
ATOM   1173  HB2 GLU A 377     -14.760   7.788  -2.260  1.00  0.00           H  
ATOM   1174  HB3 GLU A 377     -15.516   7.664  -3.850  1.00  0.00           H  
ATOM   1175  HG2 GLU A 377     -15.622  10.297  -3.664  1.00  0.00           H  
ATOM   1176  HG3 GLU A 377     -14.313  10.061  -2.506  1.00  0.00           H  
ATOM   1177  N   HIS A 378     -18.703   7.037  -1.970  1.00  0.00           N  
ATOM   1178  CA  HIS A 378     -19.691   5.996  -2.372  1.00  0.00           C  
ATOM   1179  C   HIS A 378     -20.173   6.248  -3.802  1.00  0.00           C  
ATOM   1180  O   HIS A 378     -20.244   5.293  -4.560  1.00  0.00           O  
ATOM   1181  CB  HIS A 378     -20.848   6.143  -1.382  1.00  0.00           C  
ATOM   1182  CG  HIS A 378     -21.219   7.595  -1.251  1.00  0.00           C  
ATOM   1183  ND1 HIS A 378     -22.273   8.158  -1.955  1.00  0.00           N  
ATOM   1184  CD2 HIS A 378     -20.686   8.614  -0.500  1.00  0.00           C  
ATOM   1185  CE1 HIS A 378     -22.340   9.458  -1.615  1.00  0.00           C  
ATOM   1186  NE2 HIS A 378     -21.394   9.788  -0.731  1.00  0.00           N  
ATOM   1187  OXT HIS A 378     -20.463   7.390  -4.117  1.00  0.00           O  
ATOM   1188  H   HIS A 378     -18.754   7.445  -1.080  1.00  0.00           H  
ATOM   1189  HA  HIS A 378     -19.256   5.013  -2.287  1.00  0.00           H  
ATOM   1190  HB2 HIS A 378     -21.701   5.584  -1.740  1.00  0.00           H  
ATOM   1191  HB3 HIS A 378     -20.548   5.761  -0.418  1.00  0.00           H  
ATOM   1192  HD1 HIS A 378     -22.861   7.693  -2.585  1.00  0.00           H  
ATOM   1193  HD2 HIS A 378     -19.844   8.517   0.170  1.00  0.00           H  
ATOM   1194  HE1 HIS A 378     -23.069  10.151  -2.009  1.00  0.00           H  
TER    1195      HIS A 378                                                      
END
MOLECULE T0476.pdb
ATOM     20  N   ALA     2       2.300  -1.329  -3.219  1.00  1.00          
ATOM     21  HN  ALA     2       2.119  -0.600  -3.850  1.00  1.00          
ATOM     22  CA  ALA     2       2.425  -2.698  -3.762  1.00  1.00          
ATOM     23  HA  ALA     2       2.430  -3.385  -2.927  1.00  1.00          
ATOM     24  CB  ALA     2       1.232  -3.027  -4.654  1.00  1.00          
ATOM     25  HB1 ALA     2       0.366  -3.248  -4.041  1.00  1.00          
ATOM     26  HB2 ALA     2       1.466  -3.884  -5.266  1.00  1.00          
ATOM     27  HB3 ALA     2       1.012  -2.181  -5.288  1.00  1.00          
ATOM     28  C   ALA     2       3.737  -2.860  -4.536  1.00  1.00          
ATOM     29  O   ALA     2       4.162  -1.925  -5.237  1.00  1.00          
ATOM     30  N   LYS     3       4.348  -4.064  -4.398  1.00  1.00          
ATOM     31  HN  LYS     3       3.910  -4.743  -3.851  1.00  1.00          
ATOM     32  CA  LYS     3       5.630  -4.420  -5.036  1.00  1.00          
ATOM     33  HA  LYS     3       5.927  -3.593  -5.664  1.00  1.00          
ATOM     34  CB  LYS     3       6.703  -4.642  -3.963  1.00  1.00          
ATOM     35  HB1 LYS     3       7.090  -5.646  -4.059  1.00  1.00          
ATOM     36  HB2 LYS     3       6.247  -4.534  -2.991  1.00  1.00          
ATOM     37  CG  LYS     3       7.866  -3.669  -4.054  1.00  1.00          
ATOM     38  HG1 LYS     3       7.478  -2.663  -4.070  1.00  1.00          
ATOM     39  HG2 LYS     3       8.415  -3.861  -4.963  1.00  1.00          
ATOM     40  CD  LYS     3       8.812  -3.819  -2.864  1.00  1.00          
ATOM     41  HD1 LYS     3       9.239  -4.812  -2.884  1.00  1.00          
ATOM     42  HD2 LYS     3       8.242  -3.692  -1.954  1.00  1.00          
ATOM     43  CE  LYS     3       9.950  -2.788  -2.891  1.00  1.00          
ATOM     44  HE1 LYS     3      10.366  -2.698  -1.895  1.00  1.00          
ATOM     45  HE2 LYS     3       9.543  -1.834  -3.190  1.00  1.00          
ATOM     46  NZ  LYS     3      11.048  -3.157  -3.838  1.00  1.00          
ATOM     47  HZ1 LYS     3      10.919  -4.134  -4.171  1.00  1.00          
ATOM     48  HZ2 LYS     3      11.970  -3.084  -3.363  1.00  1.00          
ATOM     49  HZ3 LYS     3      11.041  -2.517  -4.658  1.00  1.00          
ATOM     50  C   LYS     3       5.489  -5.670  -5.903  1.00  1.00          
ATOM     51  O   LYS     3       4.818  -6.637  -5.496  1.00  1.00          
ATOM     52  N   CYS     4       6.139  -5.626  -7.110  1.00  1.00          
ATOM     53  HN  CYS     4       6.610  -4.798  -7.337  1.00  1.00          
ATOM     54  CA  CYS     4       6.151  -6.739  -8.115  1.00  1.00          
ATOM     55  HA  CYS     4       5.134  -7.092  -8.210  1.00  1.00          
ATOM     56  HB1 CYS     4       7.690  -6.064  -9.456  1.00  1.00          
ATOM     57  HB2 CYS     4       6.138  -5.314  -9.733  1.00  1.00          
ATOM     58  C   CYS     4       7.052  -7.958  -7.664  1.00  1.00          
ATOM     59  O   CYS     4       8.242  -7.720  -7.359  1.00  1.00          
ATOM     60  CB  CYS     4       6.628  -6.236  -9.499  1.00  1.00          
ATOM     61  SG  CYS     4       6.315  -7.399 -10.876  1.00  1.00          
ATOM     62  ZN  CYS     4       7.178  -6.267 -12.689  1.00  1.00          
ATOM     63  N   PRO     5       6.504  -9.279  -7.551  1.00  1.00          
ATOM     64  CA  PRO     5       7.350 -10.468  -7.168  1.00  1.00          
ATOM     65  HA  PRO     5       7.965 -10.222  -6.313  1.00  1.00          
ATOM     66  CB  PRO     5       6.300 -11.538  -6.750  1.00  1.00          
ATOM     67  HB1 PRO     5       6.133 -11.486  -5.679  1.00  1.00          
ATOM     68  HB2 PRO     5       6.670 -12.522  -7.004  1.00  1.00          
ATOM     69  CG  PRO     5       5.042 -11.205  -7.513  1.00  1.00          
ATOM     70  HG1 PRO     5       4.168 -11.526  -6.955  1.00  1.00          
ATOM     71  HG2 PRO     5       5.061 -11.696  -8.482  1.00  1.00          
ATOM     72  CD  PRO     5       5.048  -9.697  -7.681  1.00  1.00          
ATOM     73  HD1 PRO     5       4.459  -9.227  -6.903  1.00  1.00          
ATOM     74  HD2 PRO     5       4.661  -9.417  -8.652  1.00  1.00          
ATOM     75  C   PRO     5       8.310 -10.999  -8.302  1.00  1.00          
ATOM     76  O   PRO     5       9.092 -11.941  -8.056  1.00  1.00          
ATOM     77  N   ILE     6       8.243 -10.351  -9.506  1.00  1.00          
ATOM     78  HN  ILE     6       7.662  -9.568  -9.601  1.00  1.00          
ATOM     79  CA  ILE     6       9.041 -10.718 -10.711  1.00  1.00          
ATOM     80  HA  ILE     6       9.414 -11.721 -10.556  1.00  1.00          
ATOM     81  CB  ILE     6       8.166 -10.709 -12.075  1.00  1.00          
ATOM     82  HB  ILE     6       8.010  -9.665 -12.339  1.00  1.00          
ATOM     83  CG1 ILE     6       6.780 -11.397 -11.928  1.00  1.00          
ATOM     84 HG11 ILE     6       6.684 -11.787 -10.923  1.00  1.00          
ATOM     85 HG12 ILE     6       6.717 -12.214 -12.630  1.00  1.00          
ATOM     86  CG2 ILE     6       8.885 -11.402 -13.266  1.00  1.00          
ATOM     87 HG21 ILE     6       8.195 -11.508 -14.089  1.00  1.00          
ATOM     88 HG22 ILE     6       9.234 -12.376 -12.960  1.00  1.00          
ATOM     89 HG23 ILE     6       9.727 -10.799 -13.576  1.00  1.00          
ATOM     90  CD1 ILE     6       5.603 -10.477 -12.185  1.00  1.00          
ATOM     91 HD11 ILE     6       5.734  -9.980 -13.135  1.00  1.00          
ATOM     92 HD12 ILE     6       5.545  -9.738 -11.398  1.00  1.00          
ATOM     93 HD13 ILE     6       4.690 -11.054 -12.203  1.00  1.00          
ATOM     94  C   ILE     6      10.267  -9.754 -10.836  1.00  1.00          
ATOM     95  O   ILE     6      11.410 -10.247 -10.885  1.00  1.00          
ATOM     96  N   CYS     7       9.997  -8.409 -10.880  1.00  1.00          
ATOM     97  HN  CYS     7       9.068  -8.099 -10.752  1.00  1.00          
ATOM     98  CA  CYS     7      11.045  -7.379 -11.052  1.00  1.00          
ATOM     99  HA  CYS     7      11.937  -7.900 -11.371  1.00  1.00          
ATOM    100  HB1 CYS     7      10.463  -6.971 -13.068  1.00  1.00          
ATOM    101  HB2 CYS     7      11.466  -5.723 -12.357  1.00  1.00          
ATOM    102  C   CYS     7      11.386  -6.643  -9.742  1.00  1.00          
ATOM    103  O   CYS     7      12.579  -6.407  -9.475  1.00  1.00          
ATOM    104  CB  CYS     7      10.644  -6.397 -12.176  1.00  1.00          
ATOM    105  SG  CYS     7       9.154  -5.367 -11.862  1.00  1.00          
ATOM    106  N   GLY     8      10.326  -6.300  -8.947  1.00  1.00          
ATOM    107  HN  GLY     8       9.429  -6.536  -9.259  1.00  1.00          
ATOM    108  CA  GLY     8      10.463  -5.587  -7.658  1.00  1.00          
ATOM    109  HA1 GLY     8      11.409  -5.858  -7.215  1.00  1.00          
ATOM    110  HA2 GLY     8       9.671  -5.911  -7.002  1.00  1.00          
ATOM    111  C   GLY     8      10.398  -4.062  -7.773  1.00  1.00          
ATOM    112  O   GLY     8      11.113  -3.371  -7.024  1.00  1.00          
ATOM    113  N   SER     9       9.543  -3.559  -8.714  1.00  1.00          
ATOM    114  HN  SER     9       9.028  -4.201  -9.268  1.00  1.00          
ATOM    115  CA  SER     9       9.353  -2.108  -8.955  1.00  1.00          
ATOM    116  HA  SER     9      10.245  -1.616  -8.608  1.00  1.00          
ATOM    117  CB  SER     9       9.190  -1.838 -10.450  1.00  1.00          
ATOM    118  HB1 SER     9       8.515  -1.007 -10.590  1.00  1.00          
ATOM    119  HB2 SER     9       8.784  -2.717 -10.929  1.00  1.00          
ATOM    120  OG  SER     9      10.434  -1.523 -11.050  1.00  1.00          
ATOM    121  HG  SER     9      11.071  -1.296 -10.369  1.00  1.00          
ATOM    122  C   SER     9       8.118  -1.543  -8.168  1.00  1.00          
ATOM    123  O   SER     9       7.155  -2.318  -7.998  1.00  1.00          
ATOM    124  N   PRO    10       8.068  -0.182  -7.677  1.00  1.00          
ATOM    125  CA  PRO    10       6.894   0.366  -6.898  1.00  1.00          
ATOM    126  HA  PRO    10       6.675  -0.274  -6.053  1.00  1.00          
ATOM    127  CB  PRO    10       7.377   1.745  -6.389  1.00  1.00          
ATOM    128  HB1 PRO    10       7.094   1.885  -5.351  1.00  1.00          
ATOM    129  HB2 PRO    10       6.922   2.521  -6.992  1.00  1.00          
ATOM    130  CG  PRO    10       8.860   1.719  -6.557  1.00  1.00          
ATOM    131  HG1 PRO    10       9.323   1.230  -5.709  1.00  1.00          
ATOM    132  HG2 PRO    10       9.246   2.726  -6.667  1.00  1.00          
ATOM    133  CD  PRO    10       9.089   0.921  -7.810  1.00  1.00          
ATOM    134  HD1 PRO    10      10.092   0.531  -7.830  1.00  1.00          
ATOM    135  HD2 PRO    10       8.896   1.526  -8.686  1.00  1.00          
ATOM    136  C   PRO    10       5.597   0.545  -7.715  1.00  1.00          
ATOM    137  O   PRO    10       5.643   0.957  -8.890  1.00  1.00          
ATOM    138  N   LEU    11       4.473   0.213  -7.043  1.00  1.00          
ATOM    139  HN  LEU    11       4.572  -0.110  -6.123  1.00  1.00          
ATOM    140  CA  LEU    11       3.105   0.301  -7.592  1.00  1.00          
ATOM    141  HA  LEU    11       3.157   0.823  -8.536  1.00  1.00          
ATOM    142  CB  LEU    11       2.505  -1.103  -7.823  1.00  1.00          
ATOM    143  HB1 LEU    11       1.435  -0.986  -7.961  1.00  1.00          
ATOM    144  HB2 LEU    11       2.671  -1.689  -6.932  1.00  1.00          
ATOM    145  CG  LEU    11       3.057  -1.892  -9.022  1.00  1.00          
ATOM    146  HG  LEU    11       4.007  -1.471  -9.320  1.00  1.00          
ATOM    147  CD1 LEU    11       3.294  -3.342  -8.631  1.00  1.00          
ATOM    148 HD11 LEU    11       2.387  -3.756  -8.216  1.00  1.00          
ATOM    149 HD12 LEU    11       4.082  -3.393  -7.896  1.00  1.00          
ATOM    150 HD13 LEU    11       3.580  -3.909  -9.505  1.00  1.00          
ATOM    151  CD2 LEU    11       2.100  -1.814 -10.209  1.00  1.00          
ATOM    152 HD21 LEU    11       1.811  -0.785 -10.370  1.00  1.00          
ATOM    153 HD22 LEU    11       1.222  -2.406 -10.003  1.00  1.00          
ATOM    154 HD23 LEU    11       2.591  -2.193 -11.094  1.00  1.00          
ATOM    155  C   LEU    11       2.200   1.084  -6.640  1.00  1.00          
ATOM    156  O   LEU    11       2.354   0.979  -5.405  1.00  1.00          
ATOM    157  N   LYS    12       1.248   1.846  -7.239  1.00  1.00          
ATOM    158  HN  LYS    12       1.205   1.847  -8.218  1.00  1.00          
ATOM    159  CA  LYS    12       0.268   2.672  -6.500  1.00  1.00          
ATOM    160  HA  LYS    12       0.655   2.832  -5.504  1.00  1.00          
ATOM    161  CB  LYS    12       0.071   4.039  -7.188  1.00  1.00          
ATOM    162  HB1 LYS    12      -0.862   4.462  -6.847  1.00  1.00          
ATOM    163  HB2 LYS    12       0.009   3.879  -8.253  1.00  1.00          
ATOM    164  CG  LYS    12       1.177   5.060  -6.932  1.00  1.00          
ATOM    165  HG1 LYS    12       2.125   4.636  -7.231  1.00  1.00          
ATOM    166  HG2 LYS    12       1.202   5.296  -5.878  1.00  1.00          
ATOM    167  CD  LYS    12       0.933   6.337  -7.719  1.00  1.00          
ATOM    168  HD1 LYS    12       0.002   6.777  -7.392  1.00  1.00          
ATOM    169  HD2 LYS    12       0.868   6.093  -8.769  1.00  1.00          
ATOM    170  CE  LYS    12       2.054   7.343  -7.518  1.00  1.00          
ATOM    171  HE1 LYS    12       2.989   6.884  -7.799  1.00  1.00          
ATOM    172  HE2 LYS    12       2.087   7.622  -6.476  1.00  1.00          
ATOM    173  NZ  LYS    12       1.848   8.568  -8.341  1.00  1.00          
ATOM    174  HZ1 LYS    12       0.845   8.844  -8.326  1.00  1.00          
ATOM    175  HZ2 LYS    12       2.133   8.389  -9.324  1.00  1.00          
ATOM    176  HZ3 LYS    12       2.418   9.351  -7.963  1.00  1.00          
ATOM    177  C   LYS    12      -1.081   1.956  -6.396  1.00  1.00          
ATOM    178  O   LYS    12      -1.559   1.377  -7.390  1.00  1.00          
ATOM    179  N   TRP    13      -1.672   1.996  -5.160  1.00  1.00          
ATOM    180  HN  TRP    13      -1.181   2.442  -4.438  1.00  1.00          
ATOM    181  CA  TRP    13      -3.017   1.404  -4.824  1.00  1.00          
ATOM    182  HA  TRP    13      -3.015   0.400  -5.221  1.00  1.00          
ATOM    183  CB  TRP    13      -3.201   1.310  -3.305  1.00  1.00          
ATOM    184  HB1 TRP    13      -4.256   1.293  -3.074  1.00  1.00          
ATOM    185  HB2 TRP    13      -2.746   2.171  -2.837  1.00  1.00          
ATOM    186  CG  TRP    13      -2.569   0.062  -2.712  1.00  1.00          
ATOM    187  CD1 TRP    13      -1.316  -0.023  -2.173  1.00  1.00          
ATOM    188  HD1 TRP    13      -0.631   0.809  -2.108  1.00  1.00          
ATOM    189  CD2 TRP    13      -3.138  -1.276  -2.597  1.00  1.00          
ATOM    190  NE1 TRP    13      -1.061  -1.302  -1.745  1.00  1.00          
ATOM    191  HE1 TRP    13      -0.226  -1.604  -1.327  1.00  1.00          
ATOM    192  CE2 TRP    13      -2.156  -2.089  -1.988  1.00  1.00          
ATOM    193  CE3 TRP    13      -4.371  -1.874  -2.944  1.00  1.00          
ATOM    194  HE3 TRP    13      -5.157  -1.299  -3.410  1.00  1.00          
ATOM    195  CZ2 TRP    13      -2.361  -3.447  -1.724  1.00  1.00          
ATOM    196  HZ2 TRP    13      -1.601  -4.066  -1.262  1.00  1.00          
ATOM    197  CZ3 TRP    13      -4.566  -3.216  -2.675  1.00  1.00          
ATOM    198  HZ3 TRP    13      -5.504  -3.685  -2.935  1.00  1.00          
ATOM    199  CH2 TRP    13      -3.565  -3.989  -2.072  1.00  1.00          
ATOM    200  HH2 TRP    13      -3.762  -5.034  -1.877  1.00  1.00          
ATOM    201  C   TRP    13      -4.207   2.161  -5.486  1.00  1.00          
ATOM    202  O   TRP    13      -5.280   1.571  -5.690  1.00  1.00          
ATOM    203  N   GLU    14      -3.968   3.482  -5.801  1.00  1.00          
ATOM    204  HN  GLU    14      -3.096   3.848  -5.548  1.00  1.00          
ATOM    205  CA  GLU    14      -4.922   4.411  -6.497  1.00  1.00          
ATOM    206  HA  GLU    14      -5.875   4.335  -5.994  1.00  1.00          
ATOM    207  CB  GLU    14      -4.427   5.865  -6.398  1.00  1.00          
ATOM    208  HB1 GLU    14      -4.913   6.447  -7.167  1.00  1.00          
ATOM    209  HB2 GLU    14      -3.361   5.878  -6.573  1.00  1.00          
ATOM    210  CG  GLU    14      -4.688   6.541  -5.055  1.00  1.00          
ATOM    211  HG1 GLU    14      -4.184   5.982  -4.281  1.00  1.00          
ATOM    212  HG2 GLU    14      -5.752   6.539  -4.866  1.00  1.00          
ATOM    213  CD  GLU    14      -4.193   7.975  -5.018  1.00  1.00          
ATOM    214  OE1 GLU    14      -4.994   8.888  -5.307  1.00  1.00          
ATOM    215  OE2 GLU    14      -3.003   8.183  -4.699  1.00  1.00          
ATOM    216  C   GLU    14      -5.129   4.058  -8.000  1.00  1.00          
ATOM    217  O   GLU    14      -6.217   4.314  -8.541  1.00  1.00          
ATOM    218  N   GLU    15      -4.055   3.473  -8.649  1.00  1.00          
ATOM    219  HN  GLU    15      -3.230   3.319  -8.128  1.00  1.00          
ATOM    220  CA  GLU    15      -4.048   3.031 -10.086  1.00  1.00          
ATOM    221  HA  GLU    15      -4.509   3.819 -10.662  1.00  1.00          
ATOM    222  CB  GLU    15      -2.604   2.844 -10.589  1.00  1.00          
ATOM    223  HB1 GLU    15      -2.622   2.205 -11.460  1.00  1.00          
ATOM    224  HB2 GLU    15      -2.029   2.360  -9.813  1.00  1.00          
ATOM    225  CG  GLU    15      -1.895   4.143 -10.965  1.00  1.00          
ATOM    226  HG1 GLU    15      -1.851   4.779 -10.092  1.00  1.00          
ATOM    227  HG2 GLU    15      -2.462   4.638 -11.739  1.00  1.00          
ATOM    228  CD  GLU    15      -0.482   3.918 -11.472  1.00  1.00          
ATOM    229  OE1 GLU    15      -0.304   3.799 -12.703  1.00  1.00          
ATOM    230  OE2 GLU    15       0.448   3.863 -10.638  1.00  1.00          
ATOM    231  C   GLU    15      -4.856   1.726 -10.327  1.00  1.00          
ATOM    232  O   GLU    15      -5.487   1.583 -11.386  1.00  1.00          
ATOM    233  N   LEU    16      -4.815   0.793  -9.313  1.00  1.00          
ATOM    234  HN  LEU    16      -4.272   1.013  -8.527  1.00  1.00          
ATOM    235  CA  LEU    16      -5.531  -0.525  -9.302  1.00  1.00          
ATOM    236  HA  LEU    16      -5.286  -1.030 -10.224  1.00  1.00          
ATOM    237  CB  LEU    16      -5.014  -1.371  -8.126  1.00  1.00          
ATOM    238  HB1 LEU    16      -5.761  -2.115  -7.894  1.00  1.00          
ATOM    239  HB2 LEU    16      -4.901  -0.721  -7.271  1.00  1.00          
ATOM    240  CG  LEU    16      -3.682  -2.089  -8.365  1.00  1.00          
ATOM    241  HG  LEU    16      -3.230  -1.706  -9.269  1.00  1.00          
ATOM    242  CD1 LEU    16      -2.723  -1.829  -7.213  1.00  1.00          
ATOM    243 HD11 LEU    16      -2.434  -0.789  -7.217  1.00  1.00          
ATOM    244 HD12 LEU    16      -1.845  -2.446  -7.329  1.00  1.00          
ATOM    245 HD13 LEU    16      -3.209  -2.064  -6.275  1.00  1.00          
ATOM    246  CD2 LEU    16      -3.906  -3.581  -8.543  1.00  1.00          
ATOM    247 HD21 LEU    16      -4.651  -3.744  -9.307  1.00  1.00          
ATOM    248 HD22 LEU    16      -4.247  -4.007  -7.610  1.00  1.00          
ATOM    249 HD23 LEU    16      -2.980  -4.051  -8.836  1.00  1.00          
ATOM    250  C   LEU    16      -7.082  -0.392  -9.222  1.00  1.00          
ATOM    251  O   LEU    16      -7.797  -1.152  -9.894  1.00  1.00          
ATOM    252  N   ILE    17      -7.564   0.589  -8.376  1.00  1.00          
ATOM    253  HN  ILE    17      -6.905   1.114  -7.878  1.00  1.00          
ATOM    254  CA  ILE    17      -9.021   0.920  -8.154  1.00  1.00          
ATOM    255  HA  ILE    17      -9.547  -0.023  -8.086  1.00  1.00          
ATOM    256  CB  ILE    17      -9.283   1.731  -6.766  1.00  1.00          
ATOM    257  HB  ILE    17      -9.012   2.758  -6.972  1.00  1.00          
ATOM    258  CG1 ILE    17      -8.423   1.252  -5.486  1.00  1.00          
ATOM    259 HG11 ILE    17      -8.829   1.751  -4.615  1.00  1.00          
ATOM    260 HG12 ILE    17      -7.411   1.598  -5.620  1.00  1.00          
ATOM    261  CG2 ILE    17     -10.798   1.759  -6.372  1.00  1.00          
ATOM    262 HG21 ILE    17     -11.113   0.765  -6.095  1.00  1.00          
ATOM    263 HG22 ILE    17     -11.380   2.095  -7.220  1.00  1.00          
ATOM    264 HG23 ILE    17     -10.945   2.433  -5.542  1.00  1.00          
ATOM    265  CD1 ILE    17      -8.315  -0.266  -5.133  1.00  1.00          
ATOM    266 HD11 ILE    17      -8.367  -0.391  -4.061  1.00  1.00          
ATOM    267 HD12 ILE    17      -7.375  -0.655  -5.494  1.00  1.00          
ATOM    268 HD13 ILE    17      -9.128  -0.801  -5.599  1.00  1.00          
ATOM    269  C   ILE    17      -9.605   1.706  -9.392  1.00  1.00          
ATOM    270  O   ILE    17     -10.742   1.429  -9.806  1.00  1.00          
ATOM    271  N   GLU    18      -8.789   2.673  -9.944  1.00  1.00          
ATOM    272  HN  GLU    18      -7.909   2.811  -9.536  1.00  1.00          
ATOM    273  CA  GLU    18      -9.137   3.532 -11.124  1.00  1.00          
ATOM    274  HA  GLU    18     -10.094   3.986 -10.916  1.00  1.00          
ATOM    275  CB  GLU    18      -8.092   4.649 -11.264  1.00  1.00          
ATOM    276  HB1 GLU    18      -7.478   4.443 -12.126  1.00  1.00          
ATOM    277  HB2 GLU    18      -7.468   4.653 -10.384  1.00  1.00          
ATOM    278  CG  GLU    18      -8.691   6.039 -11.426  1.00  1.00          
ATOM    279  HG1 GLU    18      -9.296   6.259 -10.558  1.00  1.00          
ATOM    280  HG2 GLU    18      -9.313   6.049 -12.308  1.00  1.00          
ATOM    281  CD  GLU    18      -7.632   7.113 -11.566  1.00  1.00          
ATOM    282  OE1 GLU    18      -7.356   7.526 -12.712  1.00  1.00          
ATOM    283  OE2 GLU    18      -7.077   7.544 -10.532  1.00  1.00          
ATOM    284  C   GLU    18      -9.252   2.738 -12.462  1.00  1.00          
ATOM    285  O   GLU    18     -10.109   3.070 -13.297  1.00  1.00          
ATOM    286  N   GLU    19      -8.371   1.695 -12.623  1.00  1.00          
ATOM    287  HN  GLU    19      -7.726   1.518 -11.907  1.00  1.00          
ATOM    288  CA  GLU    19      -8.326   0.776 -13.795  1.00  1.00          
ATOM    289  HA  GLU    19      -8.483   1.363 -14.687  1.00  1.00          
ATOM    290  CB  GLU    19      -6.951   0.112 -13.876  1.00  1.00          
ATOM    291  HB1 GLU    19      -7.044  -0.762 -14.480  1.00  1.00          
ATOM    292  HB2 GLU    19      -6.669  -0.194 -12.881  1.00  1.00          
ATOM    293  CG  GLU    19      -5.837   0.985 -14.458  1.00  1.00          
ATOM    294  HG1 GLU    19      -5.715   1.857 -13.831  1.00  1.00          
ATOM    295  HG2 GLU    19      -6.124   1.295 -15.452  1.00  1.00          
ATOM    296  CD  GLU    19      -4.511   0.255 -14.541  1.00  1.00          
ATOM    297  OE1 GLU    19      -3.762   0.268 -13.542  1.00  1.00          
ATOM    298  OE2 GLU    19      -4.221  -0.332 -15.606  1.00  1.00          
ATOM    299  C   GLU    19      -9.394  -0.352 -13.738  1.00  1.00          
ATOM    300  O   GLU    19      -9.772  -0.895 -14.796  1.00  1.00          
ATOM    301  N   MET    20      -9.869  -0.662 -12.495  1.00  1.00          
ATOM    302  HN  MET    20      -9.596  -0.098 -11.738  1.00  1.00          
ATOM    303  CA  MET    20     -10.851  -1.732 -12.224  1.00  1.00          
ATOM    304  HA  MET    20     -10.869  -2.350 -13.108  1.00  1.00          
ATOM    305  CB  MET    20     -10.362  -2.600 -11.039  1.00  1.00          
ATOM    306  HB1 MET    20     -11.204  -3.141 -10.644  1.00  1.00          
ATOM    307  HB2 MET    20      -9.976  -1.948 -10.271  1.00  1.00          
ATOM    308  CG  MET    20      -9.271  -3.611 -11.399  1.00  1.00          
ATOM    309  HG1 MET    20      -8.427  -3.078 -11.810  1.00  1.00          
ATOM    310  HG2 MET    20      -9.661  -4.290 -12.143  1.00  1.00          
ATOM    311  SD  MET    20      -8.712  -4.575  -9.980  1.00  1.00          
ATOM    312  CE  MET    20      -9.788  -6.004 -10.086  1.00  1.00          
ATOM    313  HE1 MET    20      -9.826  -6.498  -9.128  1.00  1.00          
ATOM    314  HE2 MET    20      -9.405  -6.688 -10.829  1.00  1.00          
ATOM    315  HE3 MET    20     -10.781  -5.687 -10.369  1.00  1.00          
ATOM    316  C   MET    20     -12.301  -1.185 -11.975  1.00  1.00          
ATOM    317  O   MET    20     -13.238  -1.979 -11.741  1.00  1.00          
ATOM    318  N   LEU    21     -12.478   0.177 -12.072  1.00  1.00          
ATOM    319  HN  LEU    21     -11.693   0.723 -12.292  1.00  1.00          
ATOM    320  CA  LEU    21     -13.782   0.887 -11.867  1.00  1.00          
ATOM    321  HA  LEU    21     -14.289   0.374 -11.064  1.00  1.00          
ATOM    322  CB  LEU    21     -13.467   2.336 -11.407  1.00  1.00          
ATOM    323  HB1 LEU    21     -13.584   2.989 -12.261  1.00  1.00          
ATOM    324  HB2 LEU    21     -12.435   2.372 -11.093  1.00  1.00          
ATOM    325  CG  LEU    21     -14.335   2.892 -10.262  1.00  1.00          
ATOM    326  HG  LEU    21     -15.254   2.327 -10.201  1.00  1.00          
ATOM    327  CD1 LEU    21     -13.620   2.772  -8.918  1.00  1.00          
ATOM    328 HD11 LEU    21     -12.795   3.469  -8.885  1.00  1.00          
ATOM    329 HD12 LEU    21     -13.246   1.766  -8.798  1.00  1.00          
ATOM    330 HD13 LEU    21     -14.313   2.996  -8.120  1.00  1.00          
ATOM    331  CD2 LEU    21     -14.700   4.342 -10.537  1.00  1.00          
ATOM    332 HD21 LEU    21     -15.350   4.393 -11.397  1.00  1.00          
ATOM    333 HD22 LEU    21     -13.801   4.908 -10.730  1.00  1.00          
ATOM    334 HD23 LEU    21     -15.207   4.754  -9.677  1.00  1.00          
ATOM    335  C   LEU    21     -14.727   0.863 -13.135  1.00  1.00          
ATOM    336  O   LEU    21     -15.767   1.563 -13.176  1.00  1.00          
ATOM    337  N   ILE    22     -14.367  -0.011 -14.121  1.00  1.00          
ATOM    338  HN  ILE    22     -13.573  -0.559 -13.970  1.00  1.00          
ATOM    339  CA  ILE    22     -15.104  -0.215 -15.411  1.00  1.00          
ATOM    340  HA  ILE    22     -15.610   0.719 -15.613  1.00  1.00          
ATOM    341  CB  ILE    22     -14.139  -0.497 -16.648  1.00  1.00          
ATOM    342  HB  ILE    22     -14.761  -0.873 -17.439  1.00  1.00          
ATOM    343  CG1 ILE    22     -12.992  -1.534 -16.396  1.00  1.00          
ATOM    344 HG11 ILE    22     -13.044  -1.877 -15.372  1.00  1.00          
ATOM    345 HG12 ILE    22     -12.038  -1.053 -16.559  1.00  1.00          
ATOM    346  CG2 ILE    22     -13.533   0.810 -17.141  1.00  1.00          
ATOM    347 HG21 ILE    22     -12.992   1.277 -16.331  1.00  1.00          
ATOM    348 HG22 ILE    22     -14.317   1.471 -17.478  1.00  1.00          
ATOM    349 HG23 ILE    22     -12.856   0.608 -17.957  1.00  1.00          
ATOM    350  CD1 ILE    22     -13.061  -2.746 -17.301  1.00  1.00          
ATOM    351 HD11 ILE    22     -12.869  -2.447 -18.322  1.00  1.00          
ATOM    352 HD12 ILE    22     -14.045  -3.187 -17.235  1.00  1.00          
ATOM    353 HD13 ILE    22     -12.320  -3.470 -16.994  1.00  1.00          
ATOM    354  C   ILE    22     -16.215  -1.322 -15.323  1.00  1.00          
ATOM    355  O   ILE    22     -17.017  -1.469 -16.268  1.00  1.00          
ATOM    356  N   ILE    23     -16.246  -2.055 -14.171  1.00  1.00          
ATOM    357  HN  ILE    23     -15.585  -1.830 -13.484  1.00  1.00          
ATOM    358  CA  ILE    23     -17.214  -3.161 -13.879  1.00  1.00          
ATOM    359  HA  ILE    23     -17.643  -3.471 -14.825  1.00  1.00          
ATOM    360  CB  ILE    23     -16.551  -4.456 -13.175  1.00  1.00          
ATOM    361  HB  ILE    23     -16.448  -4.234 -12.120  1.00  1.00          
ATOM    362  CG1 ILE    23     -15.152  -4.836 -13.744  1.00  1.00          
ATOM    363 HG11 ILE    23     -14.885  -4.128 -14.517  1.00  1.00          
ATOM    364 HG12 ILE    23     -15.205  -5.823 -14.174  1.00  1.00          
ATOM    365  CG2 ILE    23     -17.446  -5.719 -13.302  1.00  1.00          
ATOM    366 HG21 ILE    23     -17.422  -6.076 -14.321  1.00  1.00          
ATOM    367 HG22 ILE    23     -18.461  -5.469 -13.032  1.00  1.00          
ATOM    368 HG23 ILE    23     -17.079  -6.490 -12.640  1.00  1.00          
ATOM    369  CD1 ILE    23     -14.038  -4.841 -12.711  1.00  1.00          
ATOM    370 HD11 ILE    23     -14.212  -5.629 -11.994  1.00  1.00          
ATOM    371 HD12 ILE    23     -14.012  -3.887 -12.201  1.00  1.00          
ATOM    372 HD13 ILE    23     -13.090  -5.007 -13.204  1.00  1.00          
ATOM    373  C   ILE    23     -18.357  -2.596 -12.990  1.00  1.00          
ATOM    374  O   ILE    23     -18.095  -1.832 -12.042  1.00  1.00          
ATOM    375  N   GLU    24     -19.615  -3.011 -13.335  1.00  1.00          
ATOM    376  HN  GLU    24     -19.700  -3.609 -14.107  1.00  1.00          
ATOM    377  CA  GLU    24     -20.878  -2.622 -12.613  1.00  1.00          
ATOM    378  HA  GLU    24     -20.795  -1.568 -12.408  1.00  1.00          
ATOM    379  CB  GLU    24     -22.112  -2.847 -13.495  1.00  1.00          
ATOM    380  HB1 GLU    24     -22.982  -2.924 -12.859  1.00  1.00          
ATOM    381  HB2 GLU    24     -21.989  -3.775 -14.032  1.00  1.00          
ATOM    382  CG  GLU    24     -22.360  -1.739 -14.511  1.00  1.00          
ATOM    383  HG1 GLU    24     -21.510  -1.680 -15.176  1.00  1.00          
ATOM    384  HG2 GLU    24     -22.468  -0.802 -13.983  1.00  1.00          
ATOM    385  CD  GLU    24     -23.610  -1.974 -15.337  1.00  1.00          
ATOM    386  OE1 GLU    24     -23.513  -2.654 -16.379  1.00  1.00          
ATOM    387  OE2 GLU    24     -24.686  -1.479 -14.939  1.00  1.00          
ATOM    388  C   GLU    24     -21.069  -3.339 -11.252  1.00  1.00          
ATOM    389  O   GLU    24     -21.730  -2.783 -10.360  1.00  1.00          
ATOM    390  N   ASN    25     -20.478  -4.575 -11.123  1.00  1.00          
ATOM    391  HN  ASN    25     -20.016  -4.937 -11.907  1.00  1.00          
ATOM    392  CA  ASN    25     -20.485  -5.413  -9.877  1.00  1.00          
ATOM    393  HA  ASN    25     -21.503  -5.455  -9.519  1.00  1.00          
ATOM    394  CB  ASN    25     -20.018  -6.835 -10.202  1.00  1.00          
ATOM    395  HB1 ASN    25     -19.629  -7.294  -9.305  1.00  1.00          
ATOM    396  HB2 ASN    25     -19.237  -6.792 -10.946  1.00  1.00          
ATOM    397  CG  ASN    25     -21.139  -7.703 -10.735  1.00  1.00          
ATOM    398  OD1 ASN    25     -21.366  -7.775 -11.943  1.00  1.00          
ATOM    399  ND2 ASN    25     -21.847  -8.370  -9.832  1.00  1.00          
ATOM    400 HD21 ASN    25     -21.609  -8.265  -8.887  1.00  1.00          
ATOM    401 HD22 ASN    25     -22.580  -8.940 -10.146  1.00  1.00          
ATOM    402  C   ASN    25     -19.587  -4.826  -8.745  1.00  1.00          
ATOM    403  O   ASN    25     -19.800  -5.128  -7.561  1.00  1.00          
ATOM    404  N   PHE    26     -18.579  -3.974  -9.164  1.00  1.00          
ATOM    405  HN  PHE    26     -18.479  -3.886 -10.131  1.00  1.00          
ATOM    406  CA  PHE    26     -17.585  -3.264  -8.287  1.00  1.00          
ATOM    407  HA  PHE    26     -17.010  -4.031  -7.794  1.00  1.00          
ATOM    408  CB  PHE    26     -16.615  -2.431  -9.145  1.00  1.00          
ATOM    409  HB1 PHE    26     -16.916  -1.401  -9.104  1.00  1.00          
ATOM    410  HB2 PHE    26     -16.679  -2.767 -10.166  1.00  1.00          
ATOM    411  CG  PHE    26     -15.159  -2.522  -8.700  1.00  1.00          
ATOM    412  CD1 PHE    26     -14.630  -1.587  -7.813  1.00  1.00          
ATOM    413  HD1 PHE    26     -15.259  -0.786  -7.451  1.00  1.00          
ATOM    414  CD2 PHE    26     -14.325  -3.548  -9.152  1.00  1.00          
ATOM    415  HD2 PHE    26     -14.718  -4.283  -9.840  1.00  1.00          
ATOM    416  CE1 PHE    26     -13.316  -1.672  -7.392  1.00  1.00          
ATOM    417  HE1 PHE    26     -12.922  -0.940  -6.702  1.00  1.00          
ATOM    418  CE2 PHE    26     -13.012  -3.634  -8.730  1.00  1.00          
ATOM    419  HE2 PHE    26     -12.384  -4.438  -9.082  1.00  1.00          
ATOM    420  CZ  PHE    26     -12.508  -2.696  -7.849  1.00  1.00          
ATOM    421  HZ  PHE    26     -11.480  -2.761  -7.520  1.00  1.00          
ATOM    422  C   PHE    26     -18.221  -2.379  -7.186  1.00  1.00          
ATOM    423  O   PHE    26     -17.657  -2.266  -6.085  1.00  1.00          
ATOM    424  N   GLU    27     -19.401  -1.766  -7.527  1.00  1.00          
ATOM    425  HN  GLU    27     -19.712  -1.879  -8.450  1.00  1.00          
ATOM    426  CA  GLU    27     -20.248  -0.926  -6.599  1.00  1.00          
ATOM    427  HA  GLU    27     -19.621  -0.140  -6.211  1.00  1.00          
ATOM    428  CB  GLU    27     -21.426  -0.290  -7.359  1.00  1.00          
ATOM    429  HB1 GLU    27     -22.166   0.029  -6.640  1.00  1.00          
ATOM    430  HB2 GLU    27     -21.866  -1.036  -8.002  1.00  1.00          
ATOM    431  CG  GLU    27     -21.055   0.915  -8.220  1.00  1.00          
ATOM    432  HG1 GLU    27     -20.294   0.616  -8.927  1.00  1.00          
ATOM    433  HG2 GLU    27     -20.662   1.691  -7.579  1.00  1.00          
ATOM    434  CD  GLU    27     -22.238   1.474  -8.985  1.00  1.00          
ATOM    435  OE1 GLU    27     -22.504   0.988 -10.104  1.00  1.00          
ATOM    436  OE2 GLU    27     -22.900   2.396  -8.465  1.00  1.00          
ATOM    437  C   GLU    27     -20.810  -1.753  -5.397  1.00  1.00          
ATOM    438  O   GLU    27     -21.054  -1.194  -4.316  1.00  1.00          
ATOM    439  N   GLU    28     -20.997  -3.093  -5.650  1.00  1.00          
ATOM    440  HN  GLU    28     -20.774  -3.414  -6.558  1.00  1.00          
ATOM    441  CA  GLU    28     -21.472  -4.102  -4.659  1.00  1.00          
ATOM    442  HA  GLU    28     -22.153  -3.600  -3.987  1.00  1.00          
ATOM    443  CB  GLU    28     -22.229  -5.230  -5.379  1.00  1.00          
ATOM    444  HB1 GLU    28     -22.140  -6.133  -4.791  1.00  1.00          
ATOM    445  HB2 GLU    28     -21.762  -5.395  -6.343  1.00  1.00          
ATOM    446  CG  GLU    28     -23.724  -4.942  -5.591  1.00  1.00          
ATOM    447  HG1 GLU    28     -24.047  -5.388  -6.524  1.00  1.00          
ATOM    448  HG2 GLU    28     -23.864  -3.873  -5.642  1.00  1.00          
ATOM    449  CD  GLU    28     -24.602  -5.487  -4.473  1.00  1.00          
ATOM    450  OE1 GLU    28     -24.852  -6.711  -4.457  1.00  1.00          
ATOM    451  OE2 GLU    28     -25.035  -4.688  -3.616  1.00  1.00          
ATOM    452  C   GLU    28     -20.313  -4.697  -3.816  1.00  1.00          
ATOM    453  O   GLU    28     -20.512  -4.990  -2.625  1.00  1.00          
ATOM    454  N   ILE    29     -19.100  -4.858  -4.465  1.00  1.00          
ATOM    455  HN  ILE    29     -19.056  -4.577  -5.402  1.00  1.00          
ATOM    456  CA  ILE    29     -17.826  -5.391  -3.839  1.00  1.00          
ATOM    457  HA  ILE    29     -18.119  -6.251  -3.247  1.00  1.00          
ATOM    458  CB  ILE    29     -16.741  -5.905  -4.933  1.00  1.00          
ATOM    459  HB  ILE    29     -16.436  -5.047  -5.515  1.00  1.00          
ATOM    460  CG1 ILE    29     -17.347  -6.982  -5.891  1.00  1.00          
ATOM    461 HG11 ILE    29     -18.421  -6.990  -5.770  1.00  1.00          
ATOM    462 HG12 ILE    29     -16.959  -7.948  -5.606  1.00  1.00          
ATOM    463  CG2 ILE    29     -15.462  -6.544  -4.282  1.00  1.00          
ATOM    464 HG21 ILE    29     -14.576  -6.253  -4.832  1.00  1.00          
ATOM    465 HG22 ILE    29     -15.553  -7.620  -4.293  1.00  1.00          
ATOM    466 HG23 ILE    29     -15.380  -6.204  -3.259  1.00  1.00          
ATOM    467  CD1 ILE    29     -17.050  -6.801  -7.383  1.00  1.00          
ATOM    468 HD11 ILE    29     -16.128  -6.252  -7.511  1.00  1.00          
ATOM    469 HD12 ILE    29     -17.859  -6.262  -7.849  1.00  1.00          
ATOM    470 HD13 ILE    29     -16.953  -7.772  -7.848  1.00  1.00          
ATOM    471  C   ILE    29     -17.214  -4.327  -2.842  1.00  1.00          
ATOM    472  O   ILE    29     -16.719  -4.716  -1.772  1.00  1.00          
ATOM    473  N   VAL    30     -17.268  -3.006  -3.232  1.00  1.00          
ATOM    474  HN  VAL    30     -17.681  -2.807  -4.098  1.00  1.00          
ATOM    475  CA  VAL    30     -16.734  -1.828  -2.423  1.00  1.00          
ATOM    476  HA  VAL    30     -15.699  -2.078  -2.227  1.00  1.00          
ATOM    477  CB  VAL    30     -16.721  -0.442  -3.218  1.00  1.00          
ATOM    478  HB  VAL    30     -16.463   0.331  -2.501  1.00  1.00          
ATOM    479  CG1 VAL    30     -15.615  -0.442  -4.273  1.00  1.00          
ATOM    480 HG11 VAL    30     -15.795  -1.240  -4.979  1.00  1.00          
ATOM    481 HG12 VAL    30     -14.659  -0.591  -3.794  1.00  1.00          
ATOM    482 HG13 VAL    30     -15.614   0.505  -4.794  1.00  1.00          
ATOM    483  CG2 VAL    30     -18.069  -0.038  -3.897  1.00  1.00          
ATOM    484 HG21 VAL    30     -18.619  -0.929  -4.165  1.00  1.00          
ATOM    485 HG22 VAL    30     -17.860   0.536  -4.785  1.00  1.00          
ATOM    486 HG23 VAL    30     -18.665   0.560  -3.215  1.00  1.00          
ATOM    487  C   VAL    30     -17.415  -1.633  -1.014  1.00  1.00          
ATOM    488  O   VAL    30     -16.859  -0.932  -0.153  1.00  1.00          
ATOM    489  N   LYS    31     -18.636  -2.226  -0.863  1.00  1.00          
ATOM    490  HN  LYS    31     -19.028  -2.656  -1.650  1.00  1.00          
ATOM    491  CA  LYS    31     -19.444  -2.219   0.392  1.00  1.00          
ATOM    492  HA  LYS    31     -19.268  -1.274   0.885  1.00  1.00          
ATOM    493  CB  LYS    31     -20.940  -2.313   0.040  1.00  1.00          
ATOM    494  HB1 LYS    31     -21.470  -2.734   0.881  1.00  1.00          
ATOM    495  HB2 LYS    31     -21.052  -2.971  -0.812  1.00  1.00          
ATOM    496  CG  LYS    31     -21.584  -0.977  -0.315  1.00  1.00          
ATOM    497  HG1 LYS    31     -21.051  -0.540  -1.148  1.00  1.00          
ATOM    498  HG2 LYS    31     -21.524  -0.319   0.538  1.00  1.00          
ATOM    499  CD  LYS    31     -23.045  -1.151  -0.700  1.00  1.00          
ATOM    500  HD1 LYS    31     -23.576  -1.590   0.132  1.00  1.00          
ATOM    501  HD2 LYS    31     -23.107  -1.807  -1.556  1.00  1.00          
ATOM    502  CE  LYS    31     -23.687   0.179  -1.051  1.00  1.00          
ATOM    503  HE1 LYS    31     -23.146   0.619  -1.876  1.00  1.00          
ATOM    504  HE2 LYS    31     -23.625   0.831  -0.192  1.00  1.00          
ATOM    505  NZ  LYS    31     -25.115   0.020  -1.436  1.00  1.00          
ATOM    506  HZ1 LYS    31     -25.704   0.696  -0.909  1.00  1.00          
ATOM    507  HZ2 LYS    31     -25.437  -0.944  -1.220  1.00  1.00          
ATOM    508  HZ3 LYS    31     -25.232   0.194  -2.454  1.00  1.00          
ATOM    509  C   LYS    31     -19.066  -3.363   1.384  1.00  1.00          
ATOM    510  O   LYS    31     -19.371  -3.241   2.589  1.00  1.00          
ATOM    511  N   ASP    32     -18.396  -4.444   0.865  1.00  1.00          
ATOM    512  HN  ASP    32     -18.170  -4.432  -0.083  1.00  1.00          
ATOM    513  CA  ASP    32     -17.971  -5.618   1.658  1.00  1.00          
ATOM    514  HA  ASP    32     -18.111  -5.363   2.699  1.00  1.00          
ATOM    515  CB  ASP    32     -18.850  -6.851   1.334  1.00  1.00          
ATOM    516  HB1 ASP    32     -18.332  -7.743   1.651  1.00  1.00          
ATOM    517  HB2 ASP    32     -19.015  -6.897   0.269  1.00  1.00          
ATOM    518  CG  ASP    32     -20.200  -6.811   2.024  1.00  1.00          
ATOM    519  OD1 ASP    32     -20.245  -7.024   3.253  1.00  1.00          
ATOM    520  OD2 ASP    32     -21.210  -6.566   1.333  1.00  1.00          
ATOM    521  C   ASP    32     -16.477  -5.937   1.447  1.00  1.00          
ATOM    522  O   ASP    32     -16.038  -6.313   0.338  1.00  1.00          
ATOM    523  N   ARG    33     -15.696  -5.696   2.541  1.00  1.00          
ATOM    524  HN  ARG    33     -16.114  -5.203   3.272  1.00  1.00          
ATOM    525  CA  ARG    33     -14.203  -5.966   2.657  1.00  1.00          
ATOM    526  HA  ARG    33     -13.747  -5.429   1.839  1.00  1.00          
ATOM    527  CB  ARG    33     -13.602  -5.390   3.997  1.00  1.00          
ATOM    528  HB1 ARG    33     -13.539  -4.316   3.898  1.00  1.00          
ATOM    529  HB2 ARG    33     -12.598  -5.775   4.096  1.00  1.00          
ATOM    530  CG  ARG    33     -14.364  -5.685   5.329  1.00  1.00          
ATOM    531  HG1 ARG    33     -13.681  -6.081   6.070  1.00  1.00          
ATOM    532  HG2 ARG    33     -15.143  -6.407   5.134  1.00  1.00          
ATOM    533  CD  ARG    33     -14.998  -4.414   5.870  1.00  1.00          
ATOM    534  HD1 ARG    33     -15.615  -3.981   5.098  1.00  1.00          
ATOM    535  HD2 ARG    33     -14.211  -3.721   6.131  1.00  1.00          
ATOM    536  NE  ARG    33     -15.833  -4.661   7.070  1.00  1.00          
ATOM    537  HE  ARG    33     -15.828  -5.580   7.413  1.00  1.00          
ATOM    538  CZ  ARG    33     -16.606  -3.750   7.740  1.00  1.00          
ATOM    539  NH1 ARG    33     -16.704  -2.449   7.390  1.00  1.00          
ATOM    540 HH11 ARG    33     -16.194  -2.102   6.603  1.00  1.00          
ATOM    541 HH12 ARG    33     -17.284  -1.831   7.920  1.00  1.00          
ATOM    542  NH2 ARG    33     -17.294  -4.164   8.792  1.00  1.00          
ATOM    543 HH21 ARG    33     -17.242  -5.121   9.077  1.00  1.00          
ATOM    544 HH22 ARG    33     -17.866  -3.520   9.300  1.00  1.00          
ATOM    545  C   ARG    33     -13.775  -7.453   2.472  1.00  1.00          
ATOM    546  O   ARG    33     -12.675  -7.709   1.954  1.00  1.00          
ATOM    547  N   GLU    34     -14.667  -8.401   2.897  1.00  1.00          
ATOM    548  HN  GLU    34     -15.495  -8.092   3.316  1.00  1.00          
ATOM    549  CA  GLU    34     -14.475  -9.886   2.784  1.00  1.00          
ATOM    550  HA  GLU    34     -13.504 -10.117   3.193  1.00  1.00          
ATOM    551  CB  GLU    34     -15.540 -10.592   3.625  1.00  1.00          
ATOM    552  HB1 GLU    34     -16.262 -11.039   2.963  1.00  1.00          
ATOM    553  HB2 GLU    34     -16.036  -9.854   4.236  1.00  1.00          
ATOM    554  CG  GLU    34     -14.990 -11.675   4.546  1.00  1.00          
ATOM    555  HG1 GLU    34     -14.239 -11.239   5.188  1.00  1.00          
ATOM    556  HG2 GLU    34     -14.541 -12.449   3.942  1.00  1.00          
ATOM    557  CD  GLU    34     -16.066 -12.303   5.413  1.00  1.00          
ATOM    558  OE1 GLU    34     -16.255 -11.841   6.559  1.00  1.00          
ATOM    559  OE2 GLU    34     -16.719 -13.259   4.945  1.00  1.00          
ATOM    560  C   GLU    34     -14.514 -10.404   1.313  1.00  1.00          
ATOM    561  O   GLU    34     -13.832 -11.393   0.994  1.00  1.00          
ATOM    562  N   ARG    35     -15.331  -9.710   0.452  1.00  1.00          
ATOM    563  HN  ARG    35     -15.848  -8.961   0.818  1.00  1.00          
ATOM    564  CA  ARG    35     -15.478  -9.994  -1.009  1.00  1.00          
ATOM    565  HA  ARG    35     -15.418 -11.066  -1.131  1.00  1.00          
ATOM    566  CB  ARG    35     -16.844  -9.520  -1.541  1.00  1.00          
ATOM    567  HB1 ARG    35     -16.792  -9.468  -2.618  1.00  1.00          
ATOM    568  HB2 ARG    35     -17.038  -8.531  -1.156  1.00  1.00          
ATOM    569  CG  ARG    35     -18.031 -10.418  -1.163  1.00  1.00          
ATOM    570  HG1 ARG    35     -18.078 -10.489  -0.085  1.00  1.00          
ATOM    571  HG2 ARG    35     -17.868 -11.400  -1.579  1.00  1.00          
ATOM    572  CD  ARG    35     -19.369  -9.878  -1.689  1.00  1.00          
ATOM    573  HD1 ARG    35     -19.407  -8.815  -1.500  1.00  1.00          
ATOM    574  HD2 ARG    35     -20.176 -10.363  -1.158  1.00  1.00          
ATOM    575  NE  ARG    35     -19.561 -10.110  -3.154  1.00  1.00          
ATOM    576  HE  ARG    35     -18.986 -10.795  -3.555  1.00  1.00          
ATOM    577  CZ  ARG    35     -20.439  -9.469  -3.988  1.00  1.00          
ATOM    578  NH1 ARG    35     -21.296  -8.515  -3.576  1.00  1.00          
ATOM    579 HH11 ARG    35     -21.313  -8.240  -2.614  1.00  1.00          
ATOM    580 HH12 ARG    35     -21.916  -8.082  -4.230  1.00  1.00          
ATOM    581  NH2 ARG    35     -20.453  -9.807  -5.271  1.00  1.00          
ATOM    582 HH21 ARG    35     -19.831 -10.513  -5.608  1.00  1.00          
ATOM    583 HH22 ARG    35     -21.085  -9.354  -5.900  1.00  1.00          
ATOM    584  C   ARG    35     -14.353  -9.351  -1.865  1.00  1.00          
ATOM    585  O   ARG    35     -13.937  -9.953  -2.870  1.00  1.00          
ATOM    586  N   PHE    36     -13.872  -8.120  -1.439  1.00  1.00          
ATOM    587  HN  PHE    36     -14.272  -7.734  -0.632  1.00  1.00          
ATOM    588  CA  PHE    36     -12.788  -7.335  -2.119  1.00  1.00          
ATOM    589  HA  PHE    36     -13.032  -7.321  -3.175  1.00  1.00          
ATOM    590  CB  PHE    36     -12.768  -5.860  -1.604  1.00  1.00          
ATOM    591  HB1 PHE    36     -12.121  -5.808  -0.739  1.00  1.00          
ATOM    592  HB2 PHE    36     -13.766  -5.584  -1.306  1.00  1.00          
ATOM    593  CG  PHE    36     -12.276  -4.810  -2.611  1.00  1.00          
ATOM    594  CD1 PHE    36     -13.182  -4.017  -3.308  1.00  1.00          
ATOM    595  HD1 PHE    36     -14.239  -4.142  -3.138  1.00  1.00          
ATOM    596  CD2 PHE    36     -10.912  -4.619  -2.851  1.00  1.00          
ATOM    597  HD2 PHE    36     -10.191  -5.227  -2.322  1.00  1.00          
ATOM    598  CE1 PHE    36     -12.745  -3.066  -4.213  1.00  1.00          
ATOM    599  HE1 PHE    36     -13.462  -2.457  -4.749  1.00  1.00          
ATOM    600  CE2 PHE    36     -10.477  -3.670  -3.756  1.00  1.00          
ATOM    601  HE2 PHE    36      -9.420  -3.537  -3.933  1.00  1.00          
ATOM    602  CZ  PHE    36     -11.394  -2.894  -4.437  1.00  1.00          
ATOM    603  HZ  PHE    36     -11.055  -2.152  -5.144  1.00  1.00          
ATOM    604  C   PHE    36     -11.381  -7.994  -1.962  1.00  1.00          
ATOM    605  O   PHE    36     -10.656  -8.096  -2.957  1.00  1.00          
ATOM    606  N   LEU    37     -11.045  -8.465  -0.705  1.00  1.00          
ATOM    607  HN  LEU    37     -11.712  -8.391   0.008  1.00  1.00          
ATOM    608  CA  LEU    37      -9.748  -9.152  -0.357  1.00  1.00          
ATOM    609  HA  LEU    37      -8.952  -8.547  -0.765  1.00  1.00          
ATOM    610  CB  LEU    37      -9.569  -9.231   1.169  1.00  1.00          
ATOM    611  HB1 LEU    37      -8.934 -10.076   1.387  1.00  1.00          
ATOM    612  HB2 LEU    37     -10.538  -9.411   1.609  1.00  1.00          
ATOM    613  CG  LEU    37      -8.960  -7.990   1.838  1.00  1.00          
ATOM    614  HG  LEU    37      -9.017  -7.151   1.159  1.00  1.00          
ATOM    615  CD1 LEU    37      -9.735  -7.625   3.094  1.00  1.00          
ATOM    616 HD11 LEU    37      -9.264  -6.779   3.570  1.00  1.00          
ATOM    617 HD12 LEU    37      -9.736  -8.465   3.774  1.00  1.00          
ATOM    618 HD13 LEU    37     -10.751  -7.371   2.833  1.00  1.00          
ATOM    619  CD2 LEU    37      -7.493  -8.232   2.176  1.00  1.00          
ATOM    620 HD21 LEU    37      -7.421  -8.983   2.948  1.00  1.00          
ATOM    621 HD22 LEU    37      -7.048  -7.312   2.526  1.00  1.00          
ATOM    622 HD23 LEU    37      -6.971  -8.571   1.294  1.00  1.00          
ATOM    623  C   LEU    37      -9.625 -10.575  -0.974  1.00  1.00          
ATOM    624  O   LEU    37      -8.521 -10.988  -1.362  1.00  1.00          
ATOM    625  N   ALA    38     -10.798 -11.295  -1.035  1.00  1.00          
ATOM    626  HN  ALA    38     -11.594 -10.860  -0.661  1.00  1.00          
ATOM    627  CA  ALA    38     -10.947 -12.662  -1.630  1.00  1.00          
ATOM    628  HA  ALA    38     -10.133 -13.267  -1.257  1.00  1.00          
ATOM    629  CB  ALA    38     -12.249 -13.289  -1.162  1.00  1.00          
ATOM    630  HB1 ALA    38     -13.082 -12.721  -1.550  1.00  1.00          
ATOM    631  HB2 ALA    38     -12.280 -13.285  -0.084  1.00  1.00          
ATOM    632  HB3 ALA    38     -12.308 -14.305  -1.522  1.00  1.00          
ATOM    633  C   ALA    38     -10.885 -12.664  -3.184  1.00  1.00          
ATOM    634  O   ALA    38     -10.445 -13.661  -3.780  1.00  1.00          
ATOM    635  N   GLN    39     -11.334 -11.518  -3.802  1.00  1.00          
ATOM    636  HN  GLN    39     -11.679 -10.803  -3.227  1.00  1.00          
ATOM    637  CA  GLN    39     -11.334 -11.274  -5.273  1.00  1.00          
ATOM    638  HA  GLN    39     -11.622 -12.199  -5.749  1.00  1.00          
ATOM    639  CB  GLN    39     -12.363 -10.202  -5.635  1.00  1.00          
ATOM    640  HB1 GLN    39     -11.849  -9.350  -6.053  1.00  1.00          
ATOM    641  HB2 GLN    39     -12.880  -9.896  -4.736  1.00  1.00          
ATOM    642  CG  GLN    39     -13.400 -10.677  -6.644  1.00  1.00          
ATOM    643  HG1 GLN    39     -13.877 -11.568  -6.261  1.00  1.00          
ATOM    644  HG2 GLN    39     -12.897 -10.910  -7.571  1.00  1.00          
ATOM    645  CD  GLN    39     -14.469  -9.637  -6.925  1.00  1.00          
ATOM    646  OE1 GLN    39     -15.366  -9.414  -6.110  1.00  1.00          
ATOM    647  NE2 GLN    39     -14.376  -8.993  -8.084  1.00  1.00          
ATOM    648 HE21 GLN    39     -13.634  -9.222  -8.682  1.00  1.00          
ATOM    649 HE22 GLN    39     -15.051  -8.313  -8.293  1.00  1.00          
ATOM    650  C   GLN    39      -9.942 -10.870  -5.820  1.00  1.00          
ATOM    651  O   GLN    39      -9.610 -11.243  -6.947  1.00  1.00          
ATOM    652  N   VAL    40      -9.143 -10.104  -4.991  1.00  1.00          
ATOM    653  HN  VAL    40      -9.520  -9.838  -4.126  1.00  1.00          
ATOM    654  CA  VAL    40      -7.728  -9.640  -5.307  1.00  1.00          
ATOM    655  HA  VAL    40      -7.751  -9.261  -6.322  1.00  1.00          
ATOM    656  CB  VAL    40      -7.265  -8.421  -4.339  1.00  1.00          
ATOM    657  HB  VAL    40      -7.399  -8.743  -3.318  1.00  1.00          
ATOM    658  CG1 VAL    40      -5.795  -7.949  -4.503  1.00  1.00          
ATOM    659 HG11 VAL    40      -5.139  -8.808  -4.525  1.00  1.00          
ATOM    660 HG12 VAL    40      -5.525  -7.310  -3.674  1.00  1.00          
ATOM    661 HG13 VAL    40      -5.699  -7.397  -5.425  1.00  1.00          
ATOM    662  CG2 VAL    40      -8.144  -7.179  -4.545  1.00  1.00          
ATOM    663 HG21 VAL    40      -7.837  -6.403  -3.859  1.00  1.00          
ATOM    664 HG22 VAL    40      -9.177  -7.436  -4.359  1.00  1.00          
ATOM    665 HG23 VAL    40      -8.038  -6.826  -5.560  1.00  1.00          
ATOM    666  C   VAL    40      -6.740 -10.881  -5.289  1.00  1.00          
ATOM    667  O   VAL    40      -5.847 -10.964  -6.145  1.00  1.00          
ATOM    668  N   GLU    41      -6.948 -11.810  -4.291  1.00  1.00          
ATOM    669  HN  GLU    41      -7.679 -11.648  -3.658  1.00  1.00          
ATOM    670  CA  GLU    41      -6.156 -13.082  -4.095  1.00  1.00          
ATOM    671  HA  GLU    41      -5.108 -12.825  -4.137  1.00  1.00          
ATOM    672  CB  GLU    41      -6.452 -13.705  -2.709  1.00  1.00          
ATOM    673  HB1 GLU    41      -6.060 -14.711  -2.697  1.00  1.00          
ATOM    674  HB2 GLU    41      -7.523 -13.753  -2.579  1.00  1.00          
ATOM    675  CG  GLU    41      -5.870 -12.953  -1.514  1.00  1.00          
ATOM    676  HG1 GLU    41      -6.341 -11.983  -1.456  1.00  1.00          
ATOM    677  HG2 GLU    41      -4.807 -12.831  -1.658  1.00  1.00          
ATOM    678  CD  GLU    41      -6.102 -13.679  -0.203  1.00  1.00          
ATOM    679  OE1 GLU    41      -5.208 -14.441   0.221  1.00  1.00          
ATOM    680  OE2 GLU    41      -7.181 -13.490   0.398  1.00  1.00          
ATOM    681  C   GLU    41      -6.445 -14.160  -5.187  1.00  1.00          
ATOM    682  O   GLU    41      -5.529 -14.908  -5.569  1.00  1.00          
ATOM    683  N   GLU    42      -7.733 -14.199  -5.664  1.00  1.00          
ATOM    684  HN  GLU    42      -8.370 -13.556  -5.289  1.00  1.00          
ATOM    685  CA  GLU    42      -8.241 -15.144  -6.708  1.00  1.00          
ATOM    686  HA  GLU    42      -7.747 -16.091  -6.555  1.00  1.00          
ATOM    687  CB  GLU    42      -9.754 -15.348  -6.525  1.00  1.00          
ATOM    688  HB1 GLU    42     -10.174 -15.660  -7.470  1.00  1.00          
ATOM    689  HB2 GLU    42     -10.193 -14.399  -6.246  1.00  1.00          
ATOM    690  CG  GLU    42     -10.128 -16.400  -5.465  1.00  1.00          
ATOM    691  HG1 GLU    42     -11.041 -16.098  -4.963  1.00  1.00          
ATOM    692  HG2 GLU    42      -9.329 -16.457  -4.741  1.00  1.00          
ATOM    693  CD  GLU    42     -10.343 -17.788  -6.050  1.00  1.00          
ATOM    694  OE1 GLU    42     -11.404 -18.017  -6.671  1.00  1.00          
ATOM    695  OE2 GLU    42      -9.448 -18.645  -5.886  1.00  1.00          
ATOM    696  C   GLU    42      -7.966 -14.678  -8.166  1.00  1.00          
ATOM    697  O   GLU    42      -7.851 -15.532  -9.064  1.00  1.00          
ATOM    698  N   PHE    43      -7.863 -13.330  -8.362  1.00  1.00          
ATOM    699  HN  PHE    43      -7.937 -12.758  -7.569  1.00  1.00          
ATOM    700  CA  PHE    43      -7.604 -12.686  -9.673  1.00  1.00          
ATOM    701  HA  PHE    43      -7.862 -13.398 -10.445  1.00  1.00          
ATOM    702  CB  PHE    43      -8.487 -11.424  -9.835  1.00  1.00          
ATOM    703  HB1 PHE    43      -7.853 -10.550  -9.784  1.00  1.00          
ATOM    704  HB2 PHE    43      -9.194 -11.389  -9.022  1.00  1.00          
ATOM    705  CG  PHE    43      -9.276 -11.347 -11.127  1.00  1.00          
ATOM    706  CD1 PHE    43     -10.564 -11.868 -11.206  1.00  1.00          
ATOM    707  HD1 PHE    43     -10.997 -12.342 -10.337  1.00  1.00          
ATOM    708  CD2 PHE    43      -8.737 -10.740 -12.258  1.00  1.00          
ATOM    709  HD2 PHE    43      -7.740 -10.329 -12.214  1.00  1.00          
ATOM    710  CE1 PHE    43     -11.290 -11.788 -12.379  1.00  1.00          
ATOM    711  HE1 PHE    43     -12.288 -12.196 -12.425  1.00  1.00          
ATOM    712  CE2 PHE    43      -9.462 -10.660 -13.432  1.00  1.00          
ATOM    713  HE2 PHE    43      -9.031 -10.188 -14.303  1.00  1.00          
ATOM    714  CZ  PHE    43     -10.739 -11.184 -13.492  1.00  1.00          
ATOM    715  HZ  PHE    43     -11.306 -11.121 -14.409  1.00  1.00          
ATOM    716  C   PHE    43      -6.116 -12.316  -9.823  1.00  1.00          
ATOM    717  O   PHE    43      -5.436 -12.046  -8.809  1.00  1.00          
ATOM    718  N   VAL    44      -5.646 -12.290 -11.099  1.00  1.00          
ATOM    719  HN  VAL    44      -6.276 -12.457 -11.830  1.00  1.00          
ATOM    720  CA  VAL    44      -4.253 -11.972 -11.451  1.00  1.00          
ATOM    721  HA  VAL    44      -3.713 -11.937 -10.512  1.00  1.00          
ATOM    722  CB  VAL    44      -3.627 -13.177 -12.308  1.00  1.00          
ATOM    723  HB  VAL    44      -4.051 -14.083 -11.887  1.00  1.00          
ATOM    724  CG1 VAL    44      -3.969 -13.214 -13.814  1.00  1.00          
ATOM    725 HG11 VAL    44      -5.012 -12.979 -13.954  1.00  1.00          
ATOM    726 HG12 VAL    44      -3.761 -14.197 -14.212  1.00  1.00          
ATOM    727 HG13 VAL    44      -3.357 -12.481 -14.331  1.00  1.00          
ATOM    728  CG2 VAL    44      -2.115 -13.281 -12.114  1.00  1.00          
ATOM    729 HG21 VAL    44      -1.894 -13.608 -11.106  1.00  1.00          
ATOM    730 HG22 VAL    44      -1.667 -12.313 -12.281  1.00  1.00          
ATOM    731 HG23 VAL    44      -1.711 -13.991 -12.820  1.00  1.00          
ATOM    732  C   VAL    44      -4.173 -10.529 -12.072  1.00  1.00          
ATOM    733  O   VAL    44      -5.123 -10.090 -12.753  1.00  1.00          
ATOM    734  N   PHE    45      -3.024  -9.853 -11.825  1.00  1.00          
ATOM    735  HN  PHE    45      -2.310 -10.311 -11.336  1.00  1.00          
ATOM    736  CA  PHE    45      -2.760  -8.460 -12.291  1.00  1.00          
ATOM    737  HA  PHE    45      -3.609  -8.149 -12.882  1.00  1.00          
ATOM    738  CB  PHE    45      -2.596  -7.484 -11.088  1.00  1.00          
ATOM    739  HB1 PHE    45      -2.402  -6.494 -11.480  1.00  1.00          
ATOM    740  HB2 PHE    45      -1.745  -7.793 -10.507  1.00  1.00          
ATOM    741  CG  PHE    45      -3.782  -7.372 -10.139  1.00  1.00          
ATOM    742  CD1 PHE    45      -3.855  -8.180  -9.013  1.00  1.00          
ATOM    743  HD1 PHE    45      -3.068  -8.895  -8.822  1.00  1.00          
ATOM    744  CD2 PHE    45      -4.802  -6.457 -10.368  1.00  1.00          
ATOM    745  HD2 PHE    45      -4.759  -5.823 -11.241  1.00  1.00          
ATOM    746  CE1 PHE    45      -4.918  -8.079  -8.137  1.00  1.00          
ATOM    747  HE1 PHE    45      -4.959  -8.717  -7.266  1.00  1.00          
ATOM    748  CE2 PHE    45      -5.869  -6.355  -9.495  1.00  1.00          
ATOM    749  HE2 PHE    45      -6.657  -5.640  -9.685  1.00  1.00          
ATOM    750  CZ  PHE    45      -5.927  -7.166  -8.377  1.00  1.00          
ATOM    751  HZ  PHE    45      -6.758  -7.085  -7.691  1.00  1.00          
ATOM    752  C   PHE    45      -1.496  -8.411 -13.176  1.00  1.00          
ATOM    753  O   PHE    45      -0.585  -9.239 -13.001  1.00  1.00          
ATOM    754  N   LYS    46      -1.461  -7.419 -14.111  1.00  1.00          
ATOM    755  HN  LYS    46      -2.215  -6.796 -14.144  1.00  1.00          
ATOM    756  CA  LYS    46      -0.337  -7.215 -15.069  1.00  1.00          
ATOM    757  HA  LYS    46       0.244  -8.125 -15.090  1.00  1.00          
ATOM    758  CB  LYS    46      -0.874  -6.933 -16.487  1.00  1.00          
ATOM    759  HB1 LYS    46      -0.082  -6.487 -17.073  1.00  1.00          
ATOM    760  HB2 LYS    46      -1.688  -6.229 -16.413  1.00  1.00          
ATOM    761  CG  LYS    46      -1.381  -8.167 -17.233  1.00  1.00          
ATOM    762  HG1 LYS    46      -2.151  -8.641 -16.640  1.00  1.00          
ATOM    763  HG2 LYS    46      -0.560  -8.855 -17.375  1.00  1.00          
ATOM    764  CD  LYS    46      -1.959  -7.804 -18.591  1.00  1.00          
ATOM    765  HD1 LYS    46      -1.178  -7.371 -19.200  1.00  1.00          
ATOM    766  HD2 LYS    46      -2.751  -7.084 -18.453  1.00  1.00          
ATOM    767  CE  LYS    46      -2.519  -9.025 -19.303  1.00  1.00          
ATOM    768  HE1 LYS    46      -3.269  -9.481 -18.671  1.00  1.00          
ATOM    769  HE2 LYS    46      -1.717  -9.728 -19.471  1.00  1.00          
ATOM    770  NZ  LYS    46      -3.136  -8.676 -20.612  1.00  1.00          
ATOM    771  HZ1 LYS    46      -2.398  -8.563 -21.336  1.00  1.00          
ATOM    772  HZ2 LYS    46      -3.666  -7.785 -20.532  1.00  1.00          
ATOM    773  HZ3 LYS    46      -3.789  -9.428 -20.912  1.00  1.00          
ATOM    774  C   LYS    46       0.572  -6.065 -14.623  1.00  1.00          
ATOM    775  O   LYS    46       0.070  -5.042 -14.119  1.00  1.00          
ATOM    776  N   CYS    47       1.910  -6.257 -14.833  1.00  1.00          
ATOM    777  HN  CYS    47       2.196  -7.098 -15.249  1.00  1.00          
ATOM    778  CA  CYS    47       2.953  -5.266 -14.472  1.00  1.00          
ATOM    779  HA  CYS    47       2.533  -4.623 -13.712  1.00  1.00          
ATOM    780  HB1 CYS    47       4.711  -6.497 -14.684  1.00  1.00          
ATOM    781  HB2 CYS    47       3.904  -6.672 -13.134  1.00  1.00          
ATOM    782  C   CYS    47       3.345  -4.372 -15.704  1.00  1.00          
ATOM    783  O   CYS    47       3.766  -4.951 -16.732  1.00  1.00          
ATOM    784  CB  CYS    47       4.208  -5.966 -13.888  1.00  1.00          
ATOM    785  SG  CYS    47       5.427  -4.827 -13.126  1.00  1.00          
ATOM    786  N   PRO    48       3.164  -2.947 -15.672  1.00  1.00          
ATOM    787  CA  PRO    48       3.583  -2.056 -16.816  1.00  1.00          
ATOM    788  HA  PRO    48       3.246  -2.481 -17.754  1.00  1.00          
ATOM    789  CB  PRO    48       2.813  -0.732 -16.554  1.00  1.00          
ATOM    790  HB1 PRO    48       1.880  -0.736 -17.109  1.00  1.00          
ATOM    791  HB2 PRO    48       3.419   0.101 -16.888  1.00  1.00          
ATOM    792  CG  PRO    48       2.565  -0.676 -15.066  1.00  1.00          
ATOM    793  HG1 PRO    48       1.637  -0.148 -14.863  1.00  1.00          
ATOM    794  HG2 PRO    48       3.389  -0.167 -14.575  1.00  1.00          
ATOM    795  CD  PRO    48       2.475  -2.119 -14.597  1.00  1.00          
ATOM    796  HD1 PRO    48       1.438  -2.422 -14.504  1.00  1.00          
ATOM    797  HD2 PRO    48       2.978  -2.245 -13.647  1.00  1.00          
ATOM    798  C   PRO    48       5.134  -1.808 -16.941  1.00  1.00          
ATOM    799  O   PRO    48       5.580  -1.215 -17.942  1.00  1.00          
ATOM    800  N   VAL    49       5.914  -2.285 -15.914  1.00  1.00          
ATOM    801  HN  VAL    49       5.466  -2.773 -15.190  1.00  1.00          
ATOM    802  CA  VAL    49       7.410  -2.126 -15.828  1.00  1.00          
ATOM    803  HA  VAL    49       7.655  -1.220 -16.367  1.00  1.00          
ATOM    804  CB  VAL    49       7.997  -1.978 -14.329  1.00  1.00          
ATOM    805  HB  VAL    49       8.270  -2.973 -13.995  1.00  1.00          
ATOM    806  CG1 VAL    49       9.286  -1.133 -14.304  1.00  1.00          
ATOM    807 HG11 VAL    49       9.728  -1.179 -13.319  1.00  1.00          
ATOM    808 HG12 VAL    49       9.051  -0.107 -14.545  1.00  1.00          
ATOM    809 HG13 VAL    49       9.985  -1.521 -15.031  1.00  1.00          
ATOM    810  CG2 VAL    49       7.014  -1.365 -13.292  1.00  1.00          
ATOM    811 HG21 VAL    49       7.520  -0.592 -12.735  1.00  1.00          
ATOM    812 HG22 VAL    49       6.661  -2.128 -12.608  1.00  1.00          
ATOM    813 HG23 VAL    49       6.169  -0.937 -13.811  1.00  1.00          
ATOM    814  C   VAL    49       8.125  -3.313 -16.556  1.00  1.00          
ATOM    815  O   VAL    49       8.993  -3.056 -17.414  1.00  1.00          
ATOM    816  N   CYS    50       7.739  -4.573 -16.193  1.00  1.00          
ATOM    817  HN  CYS    50       7.043  -4.666 -15.510  1.00  1.00          
ATOM    818  CA  CYS    50       8.316  -5.799 -16.777  1.00  1.00          
ATOM    819  HA  CYS    50       9.232  -5.497 -17.267  1.00  1.00          
ATOM    820  HB1 CYS    50       9.375  -6.333 -15.000  1.00  1.00          
ATOM    821  HB2 CYS    50       9.172  -7.660 -16.127  1.00  1.00          
ATOM    822  C   CYS    50       7.403  -6.411 -17.860  1.00  1.00          
ATOM    823  O   CYS    50       7.904  -6.697 -18.965  1.00  1.00          
ATOM    824  CB  CYS    50       8.686  -6.811 -15.671  1.00  1.00          
ATOM    825  SG  CYS    50       7.291  -7.452 -14.676  1.00  1.00          
ATOM    826  N   GLY    51       6.086  -6.606 -17.531  1.00  1.00          
ATOM    827  HN  GLY    51       5.807  -6.447 -16.602  1.00  1.00          
ATOM    828  CA  GLY    51       5.095  -7.163 -18.482  1.00  1.00          
ATOM    829  HA1 GLY    51       5.587  -7.312 -19.433  1.00  1.00          
ATOM    830  HA2 GLY    51       4.309  -6.438 -18.617  1.00  1.00          
ATOM    831  C   GLY    51       4.452  -8.493 -18.053  1.00  1.00          
ATOM    832  O   GLY    51       3.428  -8.877 -18.644  1.00  1.00          
ATOM    833  N   GLU    52       5.054  -9.183 -17.026  1.00  1.00          
ATOM    834  HN  GLU    52       5.868  -8.795 -16.642  1.00  1.00          
ATOM    835  CA  GLU    52       4.571 -10.482 -16.473  1.00  1.00          
ATOM    836  HA  GLU    52       4.185 -11.058 -17.302  1.00  1.00          
ATOM    837  CB  GLU    52       5.752 -11.251 -15.856  1.00  1.00          
ATOM    838  HB1 GLU    52       5.394 -11.825 -15.014  1.00  1.00          
ATOM    839  HB2 GLU    52       6.489 -10.542 -15.511  1.00  1.00          
ATOM    840  CG  GLU    52       6.425 -12.204 -16.834  1.00  1.00          
ATOM    841  HG1 GLU    52       6.781 -11.636 -17.680  1.00  1.00          
ATOM    842  HG2 GLU    52       5.697 -12.928 -17.168  1.00  1.00          
ATOM    843  CD  GLU    52       7.596 -12.946 -16.222  1.00  1.00          
ATOM    844  OE1 GLU    52       8.722 -12.408 -16.254  1.00  1.00          
ATOM    845  OE2 GLU    52       7.387 -14.067 -15.710  1.00  1.00          
ATOM    846  C   GLU    52       3.428 -10.301 -15.440  1.00  1.00          
ATOM    847  O   GLU    52       3.339  -9.245 -14.787  1.00  1.00          
ATOM    848  N   GLU    53       2.574 -11.365 -15.317  1.00  1.00          
ATOM    849  HN  GLU    53       2.767 -12.169 -15.843  1.00  1.00          
ATOM    850  CA  GLU    53       1.381 -11.411 -14.420  1.00  1.00          
ATOM    851  HA  GLU    53       0.974 -10.414 -14.346  1.00  1.00          
ATOM    852  CB  GLU    53       0.304 -12.324 -15.040  1.00  1.00          
ATOM    853  HB1 GLU    53      -0.391 -12.615 -14.270  1.00  1.00          
ATOM    854  HB2 GLU    53       0.784 -13.211 -15.429  1.00  1.00          
ATOM    855  CG  GLU    53      -0.490 -11.674 -16.179  1.00  1.00          
ATOM    856  HG1 GLU    53       0.205 -11.287 -16.910  1.00  1.00          
ATOM    857  HG2 GLU    53      -1.072 -10.861 -15.773  1.00  1.00          
ATOM    858  CD  GLU    53      -1.434 -12.638 -16.870  1.00  1.00          
ATOM    859  OE1 GLU    53      -0.962 -13.427 -17.715  1.00  1.00          
ATOM    860  OE2 GLU    53      -2.647 -12.589 -16.586  1.00  1.00          
ATOM    861  C   GLU    53       1.742 -11.898 -13.004  1.00  1.00          
ATOM    862  O   GLU    53       2.536 -12.846 -12.861  1.00  1.00          
ATOM    863  N   PHE    54       1.139 -11.222 -11.991  1.00  1.00          
ATOM    864  HN  PHE    54       0.487 -10.527 -12.219  1.00  1.00          
ATOM    865  CA  PHE    54       1.337 -11.502 -10.546  1.00  1.00          
ATOM    866  HA  PHE    54       1.840 -12.458 -10.483  1.00  1.00          
ATOM    867  CB  PHE    54       2.251 -10.415  -9.864  1.00  1.00          
ATOM    868  HB1 PHE    54       3.228 -10.459 -10.326  1.00  1.00          
ATOM    869  HB2 PHE    54       2.361 -10.669  -8.822  1.00  1.00          
ATOM    870  CG  PHE    54       1.785  -8.954  -9.918  1.00  1.00          
ATOM    871  CD1 PHE    54       0.995  -8.436  -8.904  1.00  1.00          
ATOM    872  HD1 PHE    54       0.722  -9.067  -8.071  1.00  1.00          
ATOM    873  CD2 PHE    54       2.129  -8.132 -10.980  1.00  1.00          
ATOM    874  HD2 PHE    54       2.747  -8.523 -11.775  1.00  1.00          
ATOM    875  CE1 PHE    54       0.556  -7.126  -8.947  1.00  1.00          
ATOM    876  HE1 PHE    54      -0.059  -6.735  -8.150  1.00  1.00          
ATOM    877  CE2 PHE    54       1.694  -6.820 -11.026  1.00  1.00          
ATOM    878  HE2 PHE    54       1.965  -6.188 -11.856  1.00  1.00          
ATOM    879  CZ  PHE    54       0.905  -6.318 -10.009  1.00  1.00          
ATOM    880  HZ  PHE    54       0.563  -5.295 -10.046  1.00  1.00          
ATOM    881  C   PHE    54      -0.034 -11.653  -9.849  1.00  1.00          
ATOM    882  O   PHE    54      -0.969 -10.889 -10.162  1.00  1.00          
ATOM    883  N   TYR    55      -0.119 -12.615  -8.898  1.00  1.00          
ATOM    884  HN  TYR    55       0.686 -13.125  -8.672  1.00  1.00          
ATOM    885  CA  TYR    55      -1.363 -12.935  -8.148  1.00  1.00          
ATOM    886  HA  TYR    55      -2.197 -12.602  -8.746  1.00  1.00          
ATOM    887  CB  TYR    55      -1.477 -14.469  -7.949  1.00  1.00          
ATOM    888  HB1 TYR    55      -2.236 -14.667  -7.207  1.00  1.00          
ATOM    889  HB2 TYR    55      -0.532 -14.841  -7.584  1.00  1.00          
ATOM    890  CG  TYR    55      -1.827 -15.271  -9.202  1.00  1.00          
ATOM    891  CD1 TYR    55      -0.826 -15.803 -10.011  1.00  1.00          
ATOM    892  HD1 TYR    55       0.206 -15.632  -9.747  1.00  1.00          
ATOM    893  CD2 TYR    55      -3.152 -15.506  -9.566  1.00  1.00          
ATOM    894  HD2 TYR    55      -3.945 -15.100  -8.957  1.00  1.00          
ATOM    895  CE1 TYR    55      -1.135 -16.542 -11.138  1.00  1.00          
ATOM    896  HE1 TYR    55      -0.342 -16.947 -11.751  1.00  1.00          
ATOM    897  CE2 TYR    55      -3.465 -16.242 -10.694  1.00  1.00          
ATOM    898  HE2 TYR    55      -4.498 -16.413 -10.957  1.00  1.00          
ATOM    899  CZ  TYR    55      -2.453 -16.758 -11.475  1.00  1.00          
ATOM    900  OH  TYR    55      -2.762 -17.493 -12.597  1.00  1.00          
ATOM    901  HH  TYR    55      -3.405 -18.168 -12.371  1.00  1.00          
ATOM    902  C   TYR    55      -1.424 -12.224  -6.782  1.00  1.00          
ATOM    903  O   TYR    55      -0.370 -11.935  -6.183  1.00  1.00          
ATOM    904  N   GLY    56      -2.689 -11.949  -6.310  1.00  1.00          
ATOM    905  HN  GLY    56      -3.450 -12.205  -6.872  1.00  1.00          
ATOM    906  CA  GLY    56      -2.969 -11.294  -4.993  1.00  1.00          
ATOM    907  HA1 GLY    56      -3.977 -10.905  -5.012  1.00  1.00          
ATOM    908  HA2 GLY    56      -2.288 -10.464  -4.875  1.00  1.00          
ATOM    909  C   GLY    56      -2.816 -12.227  -3.760  1.00  1.00          
ATOM    910  O   GLY    56      -2.881 -11.750  -2.615  1.00  1.00          
ATOM    911  N   LYS    57      -2.617 -13.552  -4.048  1.00  1.00          
ATOM    912  HN  LYS    57      -2.606 -13.783  -5.000  1.00  1.00          
ATOM    913  CA  LYS    57      -2.389 -14.631  -3.044  1.00  1.00          
ATOM    914  HA  LYS    57      -2.947 -14.368  -2.158  1.00  1.00          
ATOM    915  CB  LYS    57      -2.919 -15.974  -3.588  1.00  1.00          
ATOM    916  HB1 LYS    57      -2.089 -16.532  -3.999  1.00  1.00          
ATOM    917  HB2 LYS    57      -3.626 -15.772  -4.378  1.00  1.00          
ATOM    918  CG  LYS    57      -3.613 -16.853  -2.543  1.00  1.00          
ATOM    919  HG1 LYS    57      -4.380 -16.276  -2.050  1.00  1.00          
ATOM    920  HG2 LYS    57      -2.882 -17.174  -1.816  1.00  1.00          
ATOM    921  CD  LYS    57      -4.252 -18.086  -3.178  1.00  1.00          
ATOM    922  HD1 LYS    57      -3.482 -18.648  -3.689  1.00  1.00          
ATOM    923  HD2 LYS    57      -4.994 -17.762  -3.892  1.00  1.00          
ATOM    924  CE  LYS    57      -4.928 -18.985  -2.136  1.00  1.00          
ATOM    925  HE1 LYS    57      -4.326 -18.991  -1.240  1.00  1.00          
ATOM    926  HE2 LYS    57      -4.997 -19.992  -2.525  1.00  1.00          
ATOM    927  NZ  LYS    57      -6.303 -18.515  -1.790  1.00  1.00          
ATOM    928  HZ1 LYS    57      -6.733 -19.150  -1.086  1.00  1.00          
ATOM    929  HZ2 LYS    57      -6.901 -18.503  -2.640  1.00  1.00          
ATOM    930  HZ3 LYS    57      -6.264 -17.553  -1.395  1.00  1.00          
ATOM    931  C   LYS    57      -0.874 -14.755  -2.662  1.00  1.00          
ATOM    932  O   LYS    57      -0.554 -15.326  -1.604  1.00  1.00          
ATOM    933  N   THR    58       0.013 -14.210  -3.547  1.00  1.00          
ATOM    934  HN  THR    58      -0.349 -13.780  -4.350  1.00  1.00          
ATOM    935  CA  THR    58       1.493 -14.204  -3.378  1.00  1.00          
ATOM    936  HA  THR    58       1.736 -14.989  -2.675  1.00  1.00          
ATOM    937  CB  THR    58       2.235 -14.516  -4.729  1.00  1.00          
ATOM    938  HB  THR    58       3.276 -14.255  -4.602  1.00  1.00          
ATOM    939  OG1 THR    58       1.700 -13.726  -5.798  1.00  1.00          
ATOM    940  HG1 THR    58       0.791 -13.491  -5.598  1.00  1.00          
ATOM    941  CG2 THR    58       2.157 -15.999  -5.108  1.00  1.00          
ATOM    942 HG21 THR    58       2.463 -16.606  -4.270  1.00  1.00          
ATOM    943 HG22 THR    58       2.810 -16.189  -5.947  1.00  1.00          
ATOM    944 HG23 THR    58       1.138 -16.245  -5.381  1.00  1.00          
ATOM    945  C   THR    58       2.013 -12.847  -2.784  1.00  1.00          
ATOM    946  O   THR    58       3.244 -12.651  -2.648  1.00  1.00          
ATOM    947  N   LEU    59       1.051 -11.941  -2.376  1.00  1.00          
ATOM    948  HN  LEU    59       0.111 -12.217  -2.445  1.00  1.00          
ATOM    949  CA  LEU    59       1.347 -10.603  -1.784  1.00  1.00          
ATOM    950  HA  LEU    59       2.256 -10.253  -2.244  1.00  1.00          
ATOM    951  CB  LEU    59       0.194  -9.605  -2.082  1.00  1.00          
ATOM    952  HB1 LEU    59      -0.209  -9.264  -1.136  1.00  1.00          
ATOM    953  HB2 LEU    59      -0.585 -10.141  -2.603  1.00  1.00          
ATOM    954  CG  LEU    59       0.539  -8.353  -2.918  1.00  1.00          
ATOM    955  HG  LEU    59       1.597  -8.149  -2.859  1.00  1.00          
ATOM    956  CD1 LEU    59       0.179  -8.558  -4.386  1.00  1.00          
ATOM    957 HD11 LEU    59       0.648  -7.790  -4.982  1.00  1.00          
ATOM    958 HD12 LEU    59      -0.893  -8.502  -4.506  1.00  1.00          
ATOM    959 HD13 LEU    59       0.528  -9.529  -4.710  1.00  1.00          
ATOM    960  CD2 LEU    59      -0.199  -7.140  -2.364  1.00  1.00          
ATOM    961 HD21 LEU    59      -0.085  -6.307  -3.043  1.00  1.00          
ATOM    962 HD22 LEU    59       0.213  -6.878  -1.401  1.00  1.00          
ATOM    963 HD23 LEU    59      -1.248  -7.374  -2.255  1.00  1.00          
ATOM    964  C   LEU    59       1.576 -10.701  -0.224  1.00  1.00          
ATOM    965  O   LEU    59       1.091 -11.689   0.366  1.00  1.00          
ATOM    966  N   PRO    60       2.291  -9.689   0.512  1.00  1.00          
ATOM    967  CA  PRO    60       2.542  -9.770   2.005  1.00  1.00          
ATOM    968  HA  PRO    60       3.000 -10.718   2.259  1.00  1.00          
ATOM    969  CB  PRO    60       3.541  -8.618   2.284  1.00  1.00          
ATOM    970  HB1 PRO    60       4.331  -8.957   2.948  1.00  1.00          
ATOM    971  HB2 PRO    60       3.013  -7.795   2.748  1.00  1.00          
ATOM    972  CG  PRO    60       4.076  -8.238   0.941  1.00  1.00          
ATOM    973  HG1 PRO    60       4.889  -8.898   0.663  1.00  1.00          
ATOM    974  HG2 PRO    60       4.412  -7.208   0.945  1.00  1.00          
ATOM    975  CD  PRO    60       2.916  -8.416   0.005  1.00  1.00          
ATOM    976  HD1 PRO    60       3.258  -8.528  -1.012  1.00  1.00          
ATOM    977  HD2 PRO    60       2.228  -7.584   0.088  1.00  1.00          
ATOM    978  C   PRO    60       1.277  -9.594   2.870  1.00  1.00          
ATOM    979  O   PRO    60       0.309  -8.953   2.429  1.00  1.00          
ATOM    980  N   ARG    61       1.326 -10.175   4.109  1.00  1.00          
ATOM    981  HN  ARG    61       2.150 -10.644   4.354  1.00  1.00          
ATOM    982  CA  ARG    61       0.215 -10.152   5.121  1.00  1.00          
ATOM    983  HA  ARG    61      -0.676 -10.465   4.596  1.00  1.00          
ATOM    984  CB  ARG    61       0.482 -11.181   6.232  1.00  1.00          
ATOM    985  HB1 ARG    61      -0.032 -10.867   7.128  1.00  1.00          
ATOM    986  HB2 ARG    61       1.544 -11.214   6.428  1.00  1.00          
ATOM    987  CG  ARG    61       0.014 -12.587   5.877  1.00  1.00          
ATOM    988  HG1 ARG    61       0.531 -12.912   4.985  1.00  1.00          
ATOM    989  HG2 ARG    61      -1.048 -12.565   5.687  1.00  1.00          
ATOM    990  CD  ARG    61       0.286 -13.582   6.994  1.00  1.00          
ATOM    991  HD1 ARG    61      -0.206 -13.242   7.892  1.00  1.00          
ATOM    992  HD2 ARG    61       1.352 -13.636   7.163  1.00  1.00          
ATOM    993  NE  ARG    61      -0.219 -14.938   6.652  1.00  1.00          
ATOM    994  HE  ARG    61      -0.687 -15.011   5.795  1.00  1.00          
ATOM    995  CZ  ARG    61      -0.105 -16.080   7.398  1.00  1.00          
ATOM    996  NH1 ARG    61       0.508 -16.135   8.596  1.00  1.00          
ATOM    997 HH11 ARG    61       0.912 -15.309   8.988  1.00  1.00          
ATOM    998 HH12 ARG    61       0.558 -17.001   9.092  1.00  1.00          
ATOM    999  NH2 ARG    61      -0.629 -17.199   6.917  1.00  1.00          
ATOM   1000 HH21 ARG    61      -1.095 -17.194   6.032  1.00  1.00          
ATOM   1001 HH22 ARG    61      -0.562 -18.048   7.442  1.00  1.00          
ATOM   1002  C   ARG    61      -0.090  -8.754   5.739  1.00  1.00          
ATOM   1003  O   ARG    61      -1.190  -8.561   6.297  1.00  1.00          
ATOM   1004  N   ARG    62       0.883  -7.787   5.613  1.00  1.00          
ATOM   1005  HN  ARG    62       1.677  -7.969   5.070  1.00  1.00          
ATOM   1006  CA  ARG    62       0.757  -6.390   6.122  1.00  1.00          
ATOM   1007  HA  ARG    62       0.193  -6.431   7.042  1.00  1.00          
ATOM   1008  CB  ARG    62       2.140  -5.819   6.419  1.00  1.00          
ATOM   1009  HB1 ARG    62       2.128  -4.758   6.227  1.00  1.00          
ATOM   1010  HB2 ARG    62       2.860  -6.289   5.765  1.00  1.00          
ATOM   1011  CG  ARG    62       2.583  -6.042   7.863  1.00  1.00          
ATOM   1012  HG1 ARG    62       2.496  -7.095   8.091  1.00  1.00          
ATOM   1013  HG2 ARG    62       1.927  -5.480   8.515  1.00  1.00          
ATOM   1014  CD  ARG    62       4.030  -5.600   8.114  1.00  1.00          
ATOM   1015  HD1 ARG    62       4.186  -5.502   9.181  1.00  1.00          
ATOM   1016  HD2 ARG    62       4.183  -4.639   7.644  1.00  1.00          
ATOM   1017  NE  ARG    62       5.037  -6.563   7.573  1.00  1.00          
ATOM   1018  HE  ARG    62       4.687  -7.438   7.301  1.00  1.00          
ATOM   1019  CZ  ARG    62       6.378  -6.352   7.404  1.00  1.00          
ATOM   1020  NH1 ARG    62       7.002  -5.209   7.753  1.00  1.00          
ATOM   1021 HH11 ARG    62       6.480  -4.459   8.159  1.00  1.00          
ATOM   1022 HH12 ARG    62       7.986  -5.112   7.606  1.00  1.00          
ATOM   1023  NH2 ARG    62       7.109  -7.325   6.880  1.00  1.00          
ATOM   1024 HH21 ARG    62       6.677  -8.189   6.618  1.00  1.00          
ATOM   1025 HH22 ARG    62       8.091  -7.197   6.744  1.00  1.00          
ATOM   1026  C   ARG    62      -0.001  -5.469   5.128  1.00  1.00          
ATOM   1027  O   ARG    62      -0.718  -4.554   5.566  1.00  1.00          
ATOM   1028  N   GLU    63       0.185  -5.737   3.781  1.00  1.00          
ATOM   1029  HN  GLU    63       0.812  -6.451   3.540  1.00  1.00          
ATOM   1030  CA  GLU    63      -0.483  -5.013   2.644  1.00  1.00          
ATOM   1031  HA  GLU    63      -0.363  -3.958   2.832  1.00  1.00          
ATOM   1032  CB  GLU    63       0.205  -5.347   1.315  1.00  1.00          
ATOM   1033  HB1 GLU    63      -0.504  -5.212   0.514  1.00  1.00          
ATOM   1034  HB2 GLU    63       0.520  -6.379   1.336  1.00  1.00          
ATOM   1035  CG  GLU    63       1.430  -4.481   1.023  1.00  1.00          
ATOM   1036  HG1 GLU    63       2.159  -4.643   1.802  1.00  1.00          
ATOM   1037  HG2 GLU    63       1.126  -3.445   1.029  1.00  1.00          
ATOM   1038  CD  GLU    63       2.082  -4.780  -0.322  1.00  1.00          
ATOM   1039  OE1 GLU    63       3.211  -5.309  -0.323  1.00  1.00          
ATOM   1040  OE2 GLU    63       1.478  -4.459  -1.374  1.00  1.00          
ATOM   1041  C   GLU    63      -2.004  -5.306   2.532  1.00  1.00          
ATOM   1042  O   GLU    63      -2.757  -4.448   2.046  1.00  1.00          
ATOM   1043  N   ALA    64      -2.424  -6.543   2.991  1.00  1.00          
ATOM   1044  HN  ALA    64      -1.733  -7.165   3.292  1.00  1.00          
ATOM   1045  CA  ALA    64      -3.851  -7.021   3.050  1.00  1.00          
ATOM   1046  HA  ALA    64      -4.267  -6.928   2.057  1.00  1.00          
ATOM   1047  CB  ALA    64      -3.891  -8.493   3.436  1.00  1.00          
ATOM   1048  HB1 ALA    64      -4.908  -8.853   3.373  1.00  1.00          
ATOM   1049  HB2 ALA    64      -3.528  -8.612   4.446  1.00  1.00          
ATOM   1050  HB3 ALA    64      -3.268  -9.059   2.760  1.00  1.00          
ATOM   1051  C   ALA    64      -4.728  -6.188   4.032  1.00  1.00          
ATOM   1052  O   ALA    64      -5.934  -6.023   3.800  1.00  1.00          
ATOM   1053  N   GLU    65      -4.064  -5.680   5.132  1.00  1.00          
ATOM   1054  HN  GLU    65      -3.124  -5.930   5.241  1.00  1.00          
ATOM   1055  CA  GLU    65      -4.661  -4.777   6.179  1.00  1.00          
ATOM   1056  HA  GLU    65      -5.616  -5.197   6.458  1.00  1.00          
ATOM   1057  CB  GLU    65      -3.764  -4.716   7.427  1.00  1.00          
ATOM   1058  HB1 GLU    65      -4.016  -3.828   7.989  1.00  1.00          
ATOM   1059  HB2 GLU    65      -2.735  -4.649   7.110  1.00  1.00          
ATOM   1060  CG  GLU    65      -3.898  -5.921   8.355  1.00  1.00          
ATOM   1061  HG1 GLU    65      -3.647  -6.815   7.801  1.00  1.00          
ATOM   1062  HG2 GLU    65      -4.921  -5.986   8.695  1.00  1.00          
ATOM   1063  CD  GLU    65      -2.989  -5.830   9.566  1.00  1.00          
ATOM   1064  OE1 GLU    65      -1.820  -6.254   9.463  1.00  1.00          
ATOM   1065  OE2 GLU    65      -3.448  -5.334  10.617  1.00  1.00          
ATOM   1066  C   GLU    65      -4.904  -3.336   5.637  1.00  1.00          
ATOM   1067  O   GLU    65      -5.807  -2.638   6.122  1.00  1.00          
ATOM   1068  N   LYS    66      -4.061  -2.925   4.618  1.00  1.00          
ATOM   1069  HN  LYS    66      -3.348  -3.544   4.353  1.00  1.00          
ATOM   1070  CA  LYS    66      -4.141  -1.614   3.877  1.00  1.00          
ATOM   1071  HA  LYS    66      -4.193  -0.833   4.622  1.00  1.00          
ATOM   1072  CB  LYS    66      -2.892  -1.379   3.008  1.00  1.00          
ATOM   1073  HB1 LYS    66      -3.119  -0.611   2.282  1.00  1.00          
ATOM   1074  HB2 LYS    66      -2.660  -2.293   2.484  1.00  1.00          
ATOM   1075  CG  LYS    66      -1.646  -0.949   3.780  1.00  1.00          
ATOM   1076  HG1 LYS    66      -1.381  -1.727   4.480  1.00  1.00          
ATOM   1077  HG2 LYS    66      -1.860  -0.036   4.316  1.00  1.00          
ATOM   1078  CD  LYS    66      -0.473  -0.706   2.844  1.00  1.00          
ATOM   1079  HD1 LYS    66      -0.743   0.062   2.135  1.00  1.00          
ATOM   1080  HD2 LYS    66      -0.248  -1.620   2.318  1.00  1.00          
ATOM   1081  CE  LYS    66       0.761  -0.260   3.609  1.00  1.00          
ATOM   1082  HE1 LYS    66       1.028  -1.032   4.317  1.00  1.00          
ATOM   1083  HE2 LYS    66       0.530   0.650   4.140  1.00  1.00          
ATOM   1084  NZ  LYS    66       1.917  -0.012   2.706  1.00  1.00          
ATOM   1085  HZ1 LYS    66       2.282   0.951   2.850  1.00  1.00          
ATOM   1086  HZ2 LYS    66       1.625  -0.116   1.714  1.00  1.00          
ATOM   1087  HZ3 LYS    66       2.677  -0.693   2.905  1.00  1.00          
ATOM   1088  C   LYS    66      -5.405  -1.510   2.980  1.00  1.00          
ATOM   1089  O   LYS    66      -5.903  -0.399   2.742  1.00  1.00          
ATOM   1090  N   VAL    67      -5.900  -2.708   2.492  1.00  1.00          
ATOM   1091  HN  VAL    67      -5.401  -3.522   2.717  1.00  1.00          
ATOM   1092  CA  VAL    67      -7.146  -2.879   1.637  1.00  1.00          
ATOM   1093  HA  VAL    67      -7.070  -2.150   0.837  1.00  1.00          
ATOM   1094  CB  VAL    67      -7.300  -4.336   0.963  1.00  1.00          
ATOM   1095  HB  VAL    67      -7.701  -5.001   1.715  1.00  1.00          
ATOM   1096  CG1 VAL    67      -8.282  -4.338  -0.231  1.00  1.00          
ATOM   1097 HG11 VAL    67      -9.277  -4.113   0.123  1.00  1.00          
ATOM   1098 HG12 VAL    67      -8.276  -5.309  -0.702  1.00  1.00          
ATOM   1099 HG13 VAL    67      -7.977  -3.587  -0.947  1.00  1.00          
ATOM   1100  CG2 VAL    67      -5.971  -4.936   0.462  1.00  1.00          
ATOM   1101 HG21 VAL    67      -5.627  -4.378  -0.397  1.00  1.00          
ATOM   1102 HG22 VAL    67      -6.123  -5.968   0.185  1.00  1.00          
ATOM   1103 HG23 VAL    67      -5.232  -4.879   1.248  1.00  1.00          
ATOM   1104  C   VAL    67      -8.421  -2.511   2.492  1.00  1.00          
ATOM   1105  O   VAL    67      -9.346  -1.894   1.965  1.00  1.00          
ATOM   1106  N   PHE    68      -8.439  -2.927   3.807  1.00  1.00          
ATOM   1107  HN  PHE    68      -7.742  -3.540   4.124  1.00  1.00          
ATOM   1108  CA  PHE    68      -9.503  -2.592   4.824  1.00  1.00          
ATOM   1109  HA  PHE    68     -10.443  -3.012   4.483  1.00  1.00          
ATOM   1110  CB  PHE    68      -9.123  -3.235   6.174  1.00  1.00          
ATOM   1111  HB1 PHE    68      -9.193  -2.480   6.944  1.00  1.00          
ATOM   1112  HB2 PHE    68      -8.101  -3.576   6.116  1.00  1.00          
ATOM   1113  CG  PHE    68      -9.968  -4.414   6.608  1.00  1.00          
ATOM   1114  CD1 PHE    68      -9.597  -5.713   6.280  1.00  1.00          
ATOM   1115  HD1 PHE    68      -8.704  -5.875   5.696  1.00  1.00          
ATOM   1116  CD2 PHE    68     -11.119  -4.226   7.366  1.00  1.00          
ATOM   1117  HD2 PHE    68     -11.420  -3.224   7.631  1.00  1.00          
ATOM   1118  CE1 PHE    68     -10.354  -6.794   6.695  1.00  1.00          
ATOM   1119  HE1 PHE    68     -10.053  -7.798   6.434  1.00  1.00          
ATOM   1120  CE2 PHE    68     -11.878  -5.303   7.780  1.00  1.00          
ATOM   1121  HE2 PHE    68     -12.771  -5.141   8.365  1.00  1.00          
ATOM   1122  CZ  PHE    68     -11.496  -6.588   7.445  1.00  1.00          
ATOM   1123  HZ  PHE    68     -12.089  -7.430   7.769  1.00  1.00          
ATOM   1124  C   PHE    68      -9.679  -1.054   5.056  1.00  1.00          
ATOM   1125  O   PHE    68     -10.775  -0.605   5.420  1.00  1.00          
ATOM   1126  N   GLU    69      -8.551  -0.285   4.832  1.00  1.00          
ATOM   1127  HN  GLU    69      -7.763  -0.745   4.481  1.00  1.00          
ATOM   1128  CA  GLU    69      -8.443   1.192   5.008  1.00  1.00          
ATOM   1129  HA  GLU    69      -8.881   1.428   5.967  1.00  1.00          
ATOM   1130  CB  GLU    69      -6.947   1.586   5.046  1.00  1.00          
ATOM   1131  HB1 GLU    69      -6.628   1.823   4.042  1.00  1.00          
ATOM   1132  HB2 GLU    69      -6.379   0.739   5.399  1.00  1.00          
ATOM   1133  CG  GLU    69      -6.622   2.781   5.946  1.00  1.00          
ATOM   1134  HG1 GLU    69      -6.989   2.573   6.940  1.00  1.00          
ATOM   1135  HG2 GLU    69      -7.132   3.648   5.551  1.00  1.00          
ATOM   1136  CD  GLU    69      -5.134   3.083   6.022  1.00  1.00          
ATOM   1137  OE1 GLU    69      -4.595   3.674   5.062  1.00  1.00          
ATOM   1138  OE2 GLU    69      -4.509   2.732   7.046  1.00  1.00          
ATOM   1139  C   GLU    69      -9.214   1.994   3.916  1.00  1.00          
ATOM   1140  O   GLU    69      -9.885   2.978   4.264  1.00  1.00          
ATOM   1141  N   LEU    70      -9.110   1.556   2.607  1.00  1.00          
ATOM   1142  HN  LEU    70      -8.516   0.805   2.412  1.00  1.00          
ATOM   1143  CA  LEU    70      -9.829   2.185   1.439  1.00  1.00          
ATOM   1144  HA  LEU    70      -9.645   3.250   1.524  1.00  1.00          
ATOM   1145  CB  LEU    70      -9.287   1.700   0.048  1.00  1.00          
ATOM   1146  HB1 LEU    70      -8.383   2.242  -0.168  1.00  1.00          
ATOM   1147  HB2 LEU    70     -10.013   1.983  -0.674  1.00  1.00          
ATOM   1148  CG  LEU    70      -8.996   0.195  -0.186  1.00  1.00          
ATOM   1149  HG  LEU    70      -8.749  -0.268   0.759  1.00  1.00          
ATOM   1150  CD1 LEU    70     -10.218  -0.516  -0.756  1.00  1.00          
ATOM   1151 HD11 LEU    70     -10.060  -1.586  -0.739  1.00  1.00          
ATOM   1152 HD12 LEU    70     -10.377  -0.191  -1.773  1.00  1.00          
ATOM   1153 HD13 LEU    70     -11.085  -0.270  -0.160  1.00  1.00          
ATOM   1154  CD2 LEU    70      -7.806   0.024  -1.121  1.00  1.00          
ATOM   1155 HD21 LEU    70      -7.757  -1.002  -1.460  1.00  1.00          
ATOM   1156 HD22 LEU    70      -6.895   0.273  -0.598  1.00  1.00          
ATOM   1157 HD23 LEU    70      -7.922   0.677  -1.972  1.00  1.00          
ATOM   1158  C   LEU    70     -11.373   1.987   1.512  1.00  1.00          
ATOM   1159  O   LEU    70     -12.134   2.895   1.140  1.00  1.00          
ATOM   1160  N   LEU    71     -11.784   0.771   2.002  1.00  1.00          
ATOM   1161  HN  LEU    71     -11.086   0.116   2.213  1.00  1.00          
ATOM   1162  CA  LEU    71     -13.199   0.356   2.240  1.00  1.00          
ATOM   1163  HA  LEU    71     -13.763   0.606   1.357  1.00  1.00          
ATOM   1164  CB  LEU    71     -13.260  -1.167   2.456  1.00  1.00          
ATOM   1165  HB1 LEU    71     -14.146  -1.382   3.034  1.00  1.00          
ATOM   1166  HB2 LEU    71     -12.397  -1.456   3.040  1.00  1.00          
ATOM   1167  CG  LEU    71     -13.288  -2.029   1.183  1.00  1.00          
ATOM   1168  HG  LEU    71     -13.164  -1.397   0.318  1.00  1.00          
ATOM   1169  CD1 LEU    71     -12.147  -3.033   1.182  1.00  1.00          
ATOM   1170 HD11 LEU    71     -11.205  -2.503   1.168  1.00  1.00          
ATOM   1171 HD12 LEU    71     -12.220  -3.658   0.306  1.00  1.00          
ATOM   1172 HD13 LEU    71     -12.198  -3.644   2.067  1.00  1.00          
ATOM   1173  CD2 LEU    71     -14.623  -2.746   1.055  1.00  1.00          
ATOM   1174 HD21 LEU    71     -14.602  -3.393   0.190  1.00  1.00          
ATOM   1175 HD22 LEU    71     -15.409  -2.015   0.936  1.00  1.00          
ATOM   1176 HD23 LEU    71     -14.814  -3.335   1.940  1.00  1.00          
ATOM   1177  C   LEU    71     -13.856   1.087   3.457  1.00  1.00          
ATOM   1178  O   LEU    71     -15.050   1.425   3.397  1.00  1.00          
ATOM   1179  N   ASN    72     -13.034   1.313   4.541  1.00  1.00          
ATOM   1180  HN  ASN    72     -12.098   1.021   4.473  1.00  1.00          
ATOM   1181  CA  ASN    72     -13.440   1.994   5.806  1.00  1.00          
ATOM   1182  HA  ASN    72     -14.442   1.664   6.041  1.00  1.00          
ATOM   1183  CB  ASN    72     -12.512   1.554   6.941  1.00  1.00          
ATOM   1184  HB1 ASN    72     -12.456   2.341   7.678  1.00  1.00          
ATOM   1185  HB2 ASN    72     -11.526   1.373   6.539  1.00  1.00          
ATOM   1186  CG  ASN    72     -12.988   0.287   7.626  1.00  1.00          
ATOM   1187  OD1 ASN    72     -12.934  -0.803   7.055  1.00  1.00          
ATOM   1188  ND2 ASN    72     -13.458   0.424   8.859  1.00  1.00          
ATOM   1189 HD21 ASN    72     -13.474   1.322   9.251  1.00  1.00          
ATOM   1190 HD22 ASN    72     -13.769  -0.379   9.327  1.00  1.00          
ATOM   1191  C   ASN    72     -13.448   3.544   5.718  1.00  1.00          
ATOM   1192  O   ASN    72     -14.280   4.182   6.390  1.00  1.00          
ATOM   1193  N   ASP    73     -12.524   4.111   4.883  1.00  1.00          
ATOM   1194  HN  ASP    73     -11.957   3.514   4.357  1.00  1.00          
ATOM   1195  CA  ASP    73     -12.367   5.571   4.687  1.00  1.00          
ATOM   1196  HA  ASP    73     -12.853   6.050   5.527  1.00  1.00          
ATOM   1197  CB  ASP    73     -10.859   5.931   4.724  1.00  1.00          
ATOM   1198  HB1 ASP    73     -10.475   5.915   3.716  1.00  1.00          
ATOM   1199  HB2 ASP    73     -10.336   5.195   5.314  1.00  1.00          
ATOM   1200  CG  ASP    73     -10.590   7.305   5.323  1.00  1.00          
ATOM   1201  OD1 ASP    73     -10.854   8.315   4.635  1.00  1.00          
ATOM   1202  OD2 ASP    73     -10.116   7.368   6.477  1.00  1.00          
ATOM   1203  C   ASP    73     -13.099   6.036   3.387  1.00  1.00          
ATOM   1204  O   ASP    73     -12.512   6.625   2.440  1.00  1.00          
ATOM   1205  N   PHE    74     -14.424   5.737   3.388  1.00  1.00          
ATOM   1206  HN  PHE    74     -14.759   5.233   4.154  1.00  1.00          
ATOM   1207  CA  PHE    74     -15.377   6.081   2.304  1.00  1.00          
ATOM   1208  HA  PHE    74     -14.812   6.156   1.388  1.00  1.00          
ATOM   1209  CB  PHE    74     -16.431   4.965   2.145  1.00  1.00          
ATOM   1210  HB1 PHE    74     -17.407   5.374   2.368  1.00  1.00          
ATOM   1211  HB2 PHE    74     -16.214   4.177   2.849  1.00  1.00          
ATOM   1212  CG  PHE    74     -16.497   4.340   0.761  1.00  1.00          
ATOM   1213  CD1 PHE    74     -15.668   3.275   0.408  1.00  1.00          
ATOM   1214  HD1 PHE    74     -14.959   2.895   1.129  1.00  1.00          
ATOM   1215  CD2 PHE    74     -17.401   4.812  -0.184  1.00  1.00          
ATOM   1216  HD2 PHE    74     -18.053   5.635   0.071  1.00  1.00          
ATOM   1217  CE1 PHE    74     -15.740   2.707  -0.849  1.00  1.00          
ATOM   1218  HE1 PHE    74     -15.090   1.884  -1.108  1.00  1.00          
ATOM   1219  CE2 PHE    74     -17.473   4.245  -1.443  1.00  1.00          
ATOM   1220  HE2 PHE    74     -18.179   4.624  -2.166  1.00  1.00          
ATOM   1221  CZ  PHE    74     -16.643   3.192  -1.774  1.00  1.00          
ATOM   1222  HZ  PHE    74     -16.700   2.748  -2.757  1.00  1.00          
ATOM   1223  C   PHE    74     -16.064   7.430   2.566  1.00  1.00          
ATOM   1224  O   PHE    74     -16.342   7.781   3.723  1.00  1.00          
ATOM   1225  N   LYS    75     -16.345   8.186   1.442  1.00  1.00          
ATOM   1226  HN  LYS    75     -16.106   7.786   0.580  1.00  1.00          
ATOM   1227  CA  LYS    75     -16.981   9.574   1.391  1.00  1.00          
ATOM   1228  HA  LYS    75     -17.230   9.733   0.349  1.00  1.00          
ATOM   1229  CB  LYS    75     -18.306   9.741   2.220  1.00  1.00          
ATOM   1230  HB1 LYS    75     -18.359  10.754   2.591  1.00  1.00          
ATOM   1231  HB2 LYS    75     -18.277   9.063   3.062  1.00  1.00          
ATOM   1232  CG  LYS    75     -19.570   9.455   1.426  1.00  1.00          
ATOM   1233  HG1 LYS    75     -19.478   8.486   0.959  1.00  1.00          
ATOM   1234  HG2 LYS    75     -19.687  10.215   0.667  1.00  1.00          
ATOM   1235  CD  LYS    75     -20.801   9.459   2.327  1.00  1.00          
ATOM   1236  HD1 LYS    75     -20.853  10.410   2.838  1.00  1.00          
ATOM   1237  HD2 LYS    75     -20.699   8.665   3.055  1.00  1.00          
ATOM   1238  CE  LYS    75     -22.093   9.254   1.530  1.00  1.00          
ATOM   1239  HE1 LYS    75     -22.855   8.851   2.184  1.00  1.00          
ATOM   1240  HE2 LYS    75     -21.897   8.551   0.734  1.00  1.00          
ATOM   1241  NZ  LYS    75     -22.595  10.528   0.935  1.00  1.00          
ATOM   1242  HZ1 LYS    75     -22.066  10.752   0.068  1.00  1.00          
ATOM   1243  HZ2 LYS    75     -22.473  11.309   1.612  1.00  1.00          
ATOM   1244  HZ3 LYS    75     -23.603  10.441   0.702  1.00  1.00          
ATOM   1245  C   LYS    75     -15.957  10.674   1.761  1.00  1.00          
ATOM   1246  O   LYS    75     -15.480  10.734   2.919  1.00  1.00          
ATOM   1247  N   GLY    76     -15.614  11.494   0.732  1.00  1.00          
ATOM   1248  HN  GLY    76     -16.034  11.341  -0.140  1.00  1.00          
ATOM   1249  CA  GLY    76     -14.651  12.595   0.866  1.00  1.00          
ATOM   1250  HA1 GLY    76     -13.866  12.287   1.541  1.00  1.00          
ATOM   1251  HA2 GLY    76     -15.157  13.450   1.290  1.00  1.00          
ATOM   1252  C   GLY    76     -14.025  12.999  -0.458  1.00  1.00          
ATOM   1253  O   GLY    76     -14.391  14.058  -1.005  1.00  1.00          
ATOM   1254  N   GLY    77     -13.089  12.142  -0.950  1.00  1.00          
ATOM   1255  HN  GLY    77     -12.885  11.334  -0.436  1.00  1.00          
ATOM   1256  CA  GLY    77     -12.365  12.375  -2.221  1.00  1.00          
ATOM   1257  HA1 GLY    77     -11.311  12.461  -1.997  1.00  1.00          
ATOM   1258  HA2 GLY    77     -12.700  13.311  -2.639  1.00  1.00          
ATOM   1259  C   GLY    77     -12.541  11.287  -3.285  1.00  1.00          
ATOM   1260  O   GLY    77     -11.601  11.072  -4.073  1.00  1.00          
ATOM   1261  N   ILE    78     -13.729  10.616  -3.301  1.00  1.00          
ATOM   1262  HN  ILE    78     -14.405  10.858  -2.636  1.00  1.00          
ATOM   1263  CA  ILE    78     -14.055   9.535  -4.278  1.00  1.00          
ATOM   1264  HA  ILE    78     -13.224   9.468  -4.971  1.00  1.00          
ATOM   1265  CB  ILE    78     -14.285   8.078  -3.623  1.00  1.00          
ATOM   1266  HB  ILE    78     -15.313   8.025  -3.295  1.00  1.00          
ATOM   1267  CG1 ILE    78     -13.357   7.776  -2.416  1.00  1.00          
ATOM   1268 HG11 ILE    78     -12.680   8.609  -2.276  1.00  1.00          
ATOM   1269 HG12 ILE    78     -12.785   6.885  -2.622  1.00  1.00          
ATOM   1270  CG2 ILE    78     -14.062   6.944  -4.653  1.00  1.00          
ATOM   1271 HG21 ILE    78     -14.611   7.167  -5.557  1.00  1.00          
ATOM   1272 HG22 ILE    78     -14.412   6.008  -4.242  1.00  1.00          
ATOM   1273 HG23 ILE    78     -13.009   6.865  -4.881  1.00  1.00          
ATOM   1274  CD1 ILE    78     -14.104   7.558  -1.118  1.00  1.00          
ATOM   1275 HD11 ILE    78     -14.678   8.442  -0.880  1.00  1.00          
ATOM   1276 HD12 ILE    78     -13.398   7.364  -0.324  1.00  1.00          
ATOM   1277 HD13 ILE    78     -14.770   6.714  -1.222  1.00  1.00          
ATOM   1278  C   ILE    78     -15.308   9.982  -5.069  1.00  1.00          
ATOM   1279  O   ILE    78     -16.370  10.216  -4.462  1.00  1.00          
ATOM   1280  N   ASP    79     -15.134  10.090  -6.412  1.00  1.00          
ATOM   1281  HN  ASP    79     -14.247   9.892  -6.779  1.00  1.00          
ATOM   1282  CA  ASP    79     -16.200  10.488  -7.355  1.00  1.00          
ATOM   1283  HA  ASP    79     -17.123  10.546  -6.796  1.00  1.00          
ATOM   1284  CB  ASP    79     -15.902  11.868  -7.968  1.00  1.00          
ATOM   1285  HB1 ASP    79     -16.448  11.965  -8.894  1.00  1.00          
ATOM   1286  HB2 ASP    79     -14.845  11.943  -8.171  1.00  1.00          
ATOM   1287  CG  ASP    79     -16.299  13.014  -7.052  1.00  1.00          
ATOM   1288  OD1 ASP    79     -15.392  13.678  -6.508  1.00  1.00          
ATOM   1289  OD2 ASP    79     -17.516  13.251  -6.884  1.00  1.00          
ATOM   1290  C   ASP    79     -16.367   9.439  -8.456  1.00  1.00          
ATOM   1291  O   ASP    79     -15.369   9.004  -9.067  1.00  1.00          
ATOM   1292  N   TRP    80     -17.649   9.026  -8.669  1.00  1.00          
ATOM   1293  HN  TRP    80     -18.351   9.424  -8.112  1.00  1.00          
ATOM   1294  CA  TRP    80     -18.065   8.009  -9.693  1.00  1.00          
ATOM   1295  HA  TRP    80     -17.284   7.264  -9.721  1.00  1.00          
ATOM   1296  CB  TRP    80     -19.368   7.313  -9.266  1.00  1.00          
ATOM   1297  HB1 TRP    80     -19.786   6.791 -10.114  1.00  1.00          
ATOM   1298  HB2 TRP    80     -20.071   8.058  -8.923  1.00  1.00          
ATOM   1299  CG  TRP    80     -19.169   6.307  -8.145  1.00  1.00          
ATOM   1300  CD1 TRP    80     -19.391   6.544  -6.819  1.00  1.00          
ATOM   1301  HD1 TRP    80     -19.745   7.485  -6.425  1.00  1.00          
ATOM   1302  CD2 TRP    80     -18.703   4.930  -8.229  1.00  1.00          
ATOM   1303  NE1 TRP    80     -19.095   5.430  -6.076  1.00  1.00          
ATOM   1304  HE1 TRP    80     -19.175   5.361  -5.101  1.00  1.00          
ATOM   1305  CE2 TRP    80     -18.674   4.429  -6.910  1.00  1.00          
ATOM   1306  CE3 TRP    80     -18.306   4.066  -9.277  1.00  1.00          
ATOM   1307  HE3 TRP    80     -18.313   4.397 -10.304  1.00  1.00          
ATOM   1308  CZ2 TRP    80     -18.271   3.129  -6.610  1.00  1.00          
ATOM   1309  HZ2 TRP    80     -18.253   2.759  -5.596  1.00  1.00          
ATOM   1310  CZ3 TRP    80     -17.909   2.777  -8.969  1.00  1.00          
ATOM   1311  HZ3 TRP    80     -17.604   2.102  -9.759  1.00  1.00          
ATOM   1312  CH2 TRP    80     -17.894   2.321  -7.647  1.00  1.00          
ATOM   1313  HH2 TRP    80     -17.575   1.308  -7.453  1.00  1.00          
ATOM   1314  C   TRP    80     -18.210   8.581 -11.130  1.00  1.00          
ATOM   1315  O   TRP    80     -17.950   7.851 -12.102  1.00  1.00          
ATOM   1316  N   GLU    81     -18.632   9.883 -11.229  1.00  1.00          
ATOM   1317  HN  GLU    81     -18.821  10.362 -10.396  1.00  1.00          
ATOM   1318  CA  GLU    81     -18.823  10.631 -12.519  1.00  1.00          
ATOM   1319  HA  GLU    81     -19.262   9.941 -13.225  1.00  1.00          
ATOM   1320  CB  GLU    81     -19.801  11.809 -12.323  1.00  1.00          
ATOM   1321  HB1 GLU    81     -19.668  12.505 -13.137  1.00  1.00          
ATOM   1322  HB2 GLU    81     -19.558  12.308 -11.397  1.00  1.00          
ATOM   1323  CG  GLU    81     -21.276  11.411 -12.273  1.00  1.00          
ATOM   1324  HG1 GLU    81     -21.414  10.696 -11.476  1.00  1.00          
ATOM   1325  HG2 GLU    81     -21.544  10.955 -13.215  1.00  1.00          
ATOM   1326  CD  GLU    81     -22.191  12.596 -12.029  1.00  1.00          
ATOM   1327  OE1 GLU    81     -22.409  12.944 -10.849  1.00  1.00          
ATOM   1328  OE2 GLU    81     -22.693  13.174 -13.017  1.00  1.00          
ATOM   1329  C   GLU    81     -17.492  11.159 -13.127  1.00  1.00          
ATOM   1330  O   GLU    81     -17.354  11.175 -14.364  1.00  1.00          
ATOM   1331  N   ASN    82     -16.547  11.581 -12.234  1.00  1.00          
ATOM   1332  HN  ASN    82     -16.764  11.528 -11.281  1.00  1.00          
ATOM   1333  CA  ASN    82     -15.209  12.112 -12.609  1.00  1.00          
ATOM   1334  HA  ASN    82     -15.290  12.507 -13.611  1.00  1.00          
ATOM   1335  CB  ASN    82     -14.834  13.262 -11.661  1.00  1.00          
ATOM   1336  HB1 ASN    82     -13.760  13.375 -11.649  1.00  1.00          
ATOM   1337  HB2 ASN    82     -15.177  13.023 -10.665  1.00  1.00          
ATOM   1338  CG  ASN    82     -15.451  14.585 -12.077  1.00  1.00          
ATOM   1339  OD1 ASN    82     -16.545  14.941 -11.636  1.00  1.00          
ATOM   1340  ND2 ASN    82     -14.753  15.321 -12.936  1.00  1.00          
ATOM   1341 HD21 ASN    82     -13.892  14.972 -13.249  1.00  1.00          
ATOM   1342 HD22 ASN    82     -15.129  16.179 -13.222  1.00  1.00          
ATOM   1343  C   ASN    82     -14.090  11.029 -12.597  1.00  1.00          
ATOM   1344  O   ASN    82     -13.014  11.254 -13.179  1.00  1.00          
ATOM   1345  N   LYS    83     -14.365   9.822 -11.944  1.00  1.00          
ATOM   1346  HN  LYS    83     -15.254   9.736 -11.541  1.00  1.00          
ATOM   1347  CA  LYS    83     -13.433   8.623 -11.790  1.00  1.00          
ATOM   1348  HA  LYS    83     -13.974   7.939 -11.145  1.00  1.00          
ATOM   1349  CB  LYS    83     -13.206   7.870 -13.151  1.00  1.00          
ATOM   1350  HB1 LYS    83     -12.300   7.286 -13.080  1.00  1.00          
ATOM   1351  HB2 LYS    83     -13.089   8.602 -13.935  1.00  1.00          
ATOM   1352  CG  LYS    83     -14.343   6.943 -13.540  1.00  1.00          
ATOM   1353  HG1 LYS    83     -15.259   7.512 -13.597  1.00  1.00          
ATOM   1354  HG2 LYS    83     -14.440   6.172 -12.788  1.00  1.00          
ATOM   1355  CD  LYS    83     -14.081   6.286 -14.884  1.00  1.00          
ATOM   1356  HD1 LYS    83     -13.142   5.753 -14.838  1.00  1.00          
ATOM   1357  HD2 LYS    83     -14.024   7.054 -15.642  1.00  1.00          
ATOM   1358  CE  LYS    83     -15.187   5.313 -15.253  1.00  1.00          
ATOM   1359  HE1 LYS    83     -16.123   5.849 -15.296  1.00  1.00          
ATOM   1360  HE2 LYS    83     -15.244   4.548 -14.492  1.00  1.00          
ATOM   1361  NZ  LYS    83     -14.938   4.664 -16.569  1.00  1.00          
ATOM   1362  HZ1 LYS    83     -13.954   4.827 -16.866  1.00  1.00          
ATOM   1363  HZ2 LYS    83     -15.576   5.060 -17.288  1.00  1.00          
ATOM   1364  HZ3 LYS    83     -15.103   3.640 -16.498  1.00  1.00          
ATOM   1365  C   LYS    83     -12.093   8.949 -11.022  1.00  1.00          
ATOM   1366  O   LYS    83     -10.958   8.649 -11.484  1.00  1.00          
ATOM   1367  N   ARG    84     -12.280   9.578  -9.829  1.00  1.00          
ATOM   1368  HN  ARG    84     -13.197   9.781  -9.556  1.00  1.00          
ATOM   1369  CA  ARG    84     -11.177   9.973  -8.915  1.00  1.00          
ATOM   1370  HA  ARG    84     -10.248   9.735  -9.415  1.00  1.00          
ATOM   1371  CB  ARG    84     -11.199  11.488  -8.602  1.00  1.00          
ATOM   1372  HB1 ARG    84     -10.545  11.673  -7.762  1.00  1.00          
ATOM   1373  HB2 ARG    84     -12.204  11.766  -8.325  1.00  1.00          
ATOM   1374  CG  ARG    84     -10.759  12.395  -9.761  1.00  1.00          
ATOM   1375  HG1 ARG    84     -11.394  12.192 -10.613  1.00  1.00          
ATOM   1376  HG2 ARG    84      -9.736  12.160 -10.014  1.00  1.00          
ATOM   1377  CD  ARG    84     -10.846  13.887  -9.411  1.00  1.00          
ATOM   1378  HD1 ARG    84     -11.771  14.060  -8.880  1.00  1.00          
ATOM   1379  HD2 ARG    84     -10.850  14.462 -10.328  1.00  1.00          
ATOM   1380  NE  ARG    84      -9.710  14.353  -8.562  1.00  1.00          
ATOM   1381  HE  ARG    84      -9.050  13.668  -8.321  1.00  1.00          
ATOM   1382  CZ  ARG    84      -9.489  15.622  -8.092  1.00  1.00          
ATOM   1383  NH1 ARG    84     -10.311  16.662  -8.334  1.00  1.00          
ATOM   1384 HH11 ARG    84     -11.137  16.530  -8.883  1.00  1.00          
ATOM   1385 HH12 ARG    84     -10.096  17.567  -7.966  1.00  1.00          
ATOM   1386  NH2 ARG    84      -8.407  15.842  -7.358  1.00  1.00          
ATOM   1387 HH21 ARG    84      -7.777  15.091  -7.158  1.00  1.00          
ATOM   1388 HH22 ARG    84      -8.220  16.759  -7.004  1.00  1.00          
ATOM   1389  C   ARG    84     -11.241   9.161  -7.617  1.00  1.00          
ATOM   1390  O   ARG    84     -12.313   9.074  -6.983  1.00  1.00          
ATOM   1391  N   VAL    85     -10.077   8.561  -7.263  1.00  1.00          
ATOM   1392  HN  VAL    85      -9.301   8.687  -7.846  1.00  1.00          
ATOM   1393  CA  VAL    85      -9.904   7.718  -6.039  1.00  1.00          
ATOM   1394  HA  VAL    85     -10.812   7.810  -5.456  1.00  1.00          
ATOM   1395  CB  VAL    85      -9.646   6.150  -6.330  1.00  1.00          
ATOM   1396  HB  VAL    85      -8.581   6.030  -6.499  1.00  1.00          
ATOM   1397  CG1 VAL    85     -10.035   5.258  -5.126  1.00  1.00          
ATOM   1398 HG11 VAL    85     -11.101   5.079  -5.142  1.00  1.00          
ATOM   1399 HG12 VAL    85      -9.770   5.759  -4.207  1.00  1.00          
ATOM   1400 HG13 VAL    85      -9.511   4.313  -5.184  1.00  1.00          
ATOM   1401  CG2 VAL    85     -10.393   5.597  -7.571  1.00  1.00          
ATOM   1402 HG21 VAL    85     -10.481   6.377  -8.314  1.00  1.00          
ATOM   1403 HG22 VAL    85     -11.379   5.269  -7.279  1.00  1.00          
ATOM   1404 HG23 VAL    85      -9.849   4.761  -7.991  1.00  1.00          
ATOM   1405  C   VAL    85      -8.733   8.306  -5.209  1.00  1.00          
ATOM   1406  O   VAL    85      -7.655   8.571  -5.773  1.00  1.00          
ATOM   1407  N   LYS    86      -8.991   8.498  -3.887  1.00  1.00          
ATOM   1408  HN  LYS    86      -9.890   8.294  -3.556  1.00  1.00          
ATOM   1409  CA  LYS    86      -8.000   9.027  -2.925  1.00  1.00          
ATOM   1410  HA  LYS    86      -7.071   9.173  -3.455  1.00  1.00          
ATOM   1411  CB  LYS    86      -8.473  10.381  -2.362  1.00  1.00          
ATOM   1412  HB1 LYS    86      -8.009  10.529  -1.398  1.00  1.00          
ATOM   1413  HB2 LYS    86      -9.545  10.332  -2.223  1.00  1.00          
ATOM   1414  CG  LYS    86      -8.139  11.597  -3.250  1.00  1.00          
ATOM   1415  HG1 LYS    86      -8.972  12.293  -3.242  1.00  1.00          
ATOM   1416  HG2 LYS    86      -7.974  11.254  -4.259  1.00  1.00          
ATOM   1417  CD  LYS    86      -6.886  12.335  -2.776  1.00  1.00          
ATOM   1418  HD1 LYS    86      -6.049  11.653  -2.800  1.00  1.00          
ATOM   1419  HD2 LYS    86      -7.043  12.682  -1.765  1.00  1.00          
ATOM   1420  CE  LYS    86      -6.575  13.533  -3.661  1.00  1.00          
ATOM   1421  HE1 LYS    86      -7.425  14.199  -3.653  1.00  1.00          
ATOM   1422  HE2 LYS    86      -6.402  13.184  -4.668  1.00  1.00          
ATOM   1423  NZ  LYS    86      -5.372  14.274  -3.191  1.00  1.00          
ATOM   1424  HZ1 LYS    86      -5.657  15.075  -2.592  1.00  1.00          
ATOM   1425  HZ2 LYS    86      -4.837  14.638  -4.005  1.00  1.00          
ATOM   1426  HZ3 LYS    86      -4.756  13.644  -2.640  1.00  1.00          
ATOM   1427  C   LYS    86      -7.759   8.043  -1.773  1.00  1.00          
ATOM   1428  O   LYS    86      -8.720   7.452  -1.243  1.00  1.00          
ATOM   1429  N   LEU    87      -6.457   7.890  -1.420  1.00  1.00          
ATOM   1430  HN  LEU    87      -5.788   8.401  -1.914  1.00  1.00          
ATOM   1431  CA  LEU    87      -5.975   7.022  -0.331  1.00  1.00          
ATOM   1432  HA  LEU    87      -6.839   6.619   0.176  1.00  1.00          
ATOM   1433  CB  LEU    87      -5.117   5.864  -0.882  1.00  1.00          
ATOM   1434  HB1 LEU    87      -4.350   5.647  -0.155  1.00  1.00          
ATOM   1435  HB2 LEU    87      -4.637   6.212  -1.785  1.00  1.00          
ATOM   1436  CG  LEU    87      -5.861   4.550  -1.208  1.00  1.00          
ATOM   1437  HG  LEU    87      -6.926   4.721  -1.180  1.00  1.00          
ATOM   1438  CD1 LEU    87      -5.511   4.050  -2.604  1.00  1.00          
ATOM   1439 HD11 LEU    87      -5.965   4.693  -3.341  1.00  1.00          
ATOM   1440 HD12 LEU    87      -5.887   3.044  -2.725  1.00  1.00          
ATOM   1441 HD13 LEU    87      -4.438   4.049  -2.733  1.00  1.00          
ATOM   1442  CD2 LEU    87      -5.525   3.478  -0.176  1.00  1.00          
ATOM   1443 HD21 LEU    87      -5.823   3.815   0.806  1.00  1.00          
ATOM   1444 HD22 LEU    87      -4.462   3.285  -0.184  1.00  1.00          
ATOM   1445 HD23 LEU    87      -6.051   2.566  -0.418  1.00  1.00          
ATOM   1446  C   LEU    87      -5.175   7.851   0.674  1.00  1.00          
ATOM   1447  O   LEU    87      -4.291   8.640   0.276  1.00  1.00          
ATOM   1448  N   LYS    88      -5.529   7.665   1.963  1.00  1.00          
ATOM   1449  HN  LYS    88      -6.253   7.036   2.148  1.00  1.00          
ATOM   1450  HA  LYS    88      -4.275   9.146   2.707  1.00  1.00          
ATOM   1451  CB  LYS    88      -5.962   8.982   4.017  1.00  1.00          
ATOM   1452  HB1 LYS    88      -5.562   9.062   5.017  1.00  1.00          
ATOM   1453  HB2 LYS    88      -6.824   8.332   4.036  1.00  1.00          
ATOM   1454  CG  LYS    88      -6.418  10.364   3.571  1.00  1.00          
ATOM   1455  HG1 LYS    88      -6.771  10.305   2.552  1.00  1.00          
ATOM   1456  HG2 LYS    88      -5.579  11.042   3.624  1.00  1.00          
ATOM   1457  CD  LYS    88      -7.543  10.896   4.457  1.00  1.00          
ATOM   1458  HD1 LYS    88      -7.194  10.910   5.482  1.00  1.00          
ATOM   1459  HD2 LYS    88      -8.391  10.233   4.375  1.00  1.00          
ATOM   1460  CE  LYS    88      -7.980  12.309   4.053  1.00  1.00          
ATOM   1461  HE1 LYS    88      -7.103  12.879   3.782  1.00  1.00          
ATOM   1462  HE2 LYS    88      -8.465  12.784   4.896  1.00  1.00          
ATOM   1463  NZ  LYS    88      -8.931  12.307   2.900  1.00  1.00          
ATOM   1464  HZ1 LYS    88      -8.916  11.381   2.426  1.00  1.00          
ATOM   1465  HZ2 LYS    88      -8.663  13.040   2.213  1.00  1.00          
ATOM   1466  HZ3 LYS    88      -9.898  12.499   3.233  1.00  1.00          
ATOM   1467  CA  LYS    88      -4.895   8.357   3.108  1.00  1.00          
ATOM   1468  C   LYS    88      -4.008   7.403   3.912  1.00  1.00          
ATOM   1469  OT1 LYS    88      -4.429   6.247   4.147  1.00  1.00          
ATOM   1470  OT2 LYS    88      -2.897   7.822   4.299  1.00  1.00          
END
