
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  116 (  901),  selected  116 , name 2rld_C
# Molecule2: number of CA atoms  134 ( 1120),  selected  134 , name T0478_4_137.pdb
# PARAMETERS: 2rld_C.T0478_4_137.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      D       4           -
LGA    -       -      T       5           -
LGA    -       -      G       6           -
LGA    -       -      V       7           -
LGA    X     1_C      T       8          4.342
LGA    R     2_C      S       9          4.170
LGA    E     3_C      V      10          2.170
LGA    D     4_C      M      11          3.535
LGA    X     5_C      F      12           -
LGA    -       -      V      13           -
LGA    -       -      E      14           -
LGA    K     6_C      R      15          2.946
LGA    D     7_C      S      16          2.191
LGA    N     8_C      L      17          4.280
LGA    V     9_C      N      18          3.562
LGA    V    10_C      E      19          1.503
LGA    K    11_C      I      20          2.783
LGA    -       -      R      21           -
LGA    D    12_C      F      22          1.342
LGA    K    13_C      W      23          2.209
LGA    S    14_C      S      24          1.705
LGA    L    15_C      R      25          0.858
LGA    E    16_C      I      26          2.529
LGA    F    17_C      M      27          2.561
LGA    A    18_C      K      28          1.107
LGA    V    19_C      E      29          1.573
LGA    R    20_C      X      30          2.303
LGA    I    21_C      S      31          1.428
LGA    V    22_C      F      32          1.179
LGA    N    23_C      F      33          1.803
LGA    L    24_C      L      34          1.308
LGA    Y    25_C      R      35          1.582
LGA    K    26_C      L      36          2.474
LGA    F    27_C      G      37          2.152
LGA    L    28_C      F      38          1.669
LGA    V    29_C      -       -           -
LGA    N    30_C      -       -           -
LGA    E    31_C      R      39          3.526
LGA    Q    32_C      C      40          5.048
LGA    K    33_C      E      41          2.756
LGA    E    34_C      D      42          1.387
LGA    F    35_C      T      43          1.139
LGA    V    36_C      Q      44          0.758
LGA    X    37_C      L      45          2.362
LGA    S    38_C      I      46          2.798
LGA    K    39_C      E      47          1.705
LGA    Q    40_C      E      48          1.795
LGA    I    41_C      A      49          3.102
LGA    L    42_C      N      50          2.856
LGA    R    43_C      Q      51          1.776
LGA    S    44_C      F      52          2.722
LGA    G    45_C      Y      53          4.862
LGA    T    46_C      R      54          4.504
LGA    S    47_C      L      55          1.789
LGA    I    48_C      F      56          3.556
LGA    G    49_C      E      57          5.238
LGA    A    50_C      X      58          2.602
LGA    N    51_C      I      59          2.652
LGA    -       -      E      60           -
LGA    -       -      Q      61           -
LGA    I    52_C      I      62           #
LGA    R    53_C      A      63          1.877
LGA    E    54_C      X      64           #
LGA    A    55_C      -       -           -
LGA    E    56_C      -       -           -
LGA    Q    57_C      S      65          4.291
LGA    A    58_C      Y      66          5.604
LGA    -       -      T      67           -
LGA    -       -      N      68           -
LGA    -       -      E      69           -
LGA    Q    59_C      T      70          4.958
LGA    S    60_C      D      71          2.603
LGA    R    61_C      P      72          1.936
LGA    A    62_C      E      73          1.751
LGA    D    63_C      Q      74          1.868
LGA    F    64_C      I      75          1.706
LGA    I    65_C      K      76          1.390
LGA    N    66_C      R      77          1.224
LGA    K    67_C      F      78          1.696
LGA    L    68_C      N      79          1.727
LGA    N    69_C      A      80          1.404
LGA    I    70_C      E      81          1.358
LGA    A    71_C      V      82          1.034
LGA    L    72_C      Q      83          1.059
LGA    K    73_C      Q      84          1.211
LGA    E    74_C      A      85          1.093
LGA    A    75_C      A      86          0.860
LGA    N    76_C      T      87          0.916
LGA    E    77_C      N      88          0.994
LGA    T    78_C      I      89          0.645
LGA    E    79_C      W      90          1.092
LGA    Y    80_C      G      91          1.259
LGA    W    81_C      F      92          0.970
LGA    L    82_C      K      93          0.898
LGA    E    83_C      R      94          1.127
LGA    L    84_C      K      95          1.038
LGA    L    85_C      I      96          0.817
LGA    I    86_C      L      97          1.130
LGA    R    87_C      G      98          0.857
LGA    T    88_C      L      99          1.145
LGA    E    89_C      I     100          1.304
LGA    -       -      L     101           -
LGA    -       -      T     102           -
LGA    -       -      C     103           -
LGA    -       -      K     104           -
LGA    Y    90_C      L     105          4.667
LGA    -       -      P     106           -
LGA    -       -      G     107           -
LGA    -       -      Q     108           -
LGA    -       -      N     109           -
LGA    I    91_C      N     110          4.279
LGA    T    92_C      F     111          3.466
LGA    R    93_C      P     112          2.082
LGA    E    94_C      L     113          0.989
LGA    Q    95_C      L     114          1.923
LGA    Y    96_C      V     115          1.634
LGA    E    97_C      D     116          1.725
LGA    S    98_C      X     117          1.832
LGA    I    99_C      T     118          1.040
LGA    N   100_C      S     119          0.855
LGA    N   101_C      R     120          1.489
LGA    D   102_C      E     121          1.525
LGA    S   103_C      A     122          0.964
LGA    T   104_C      D     123          1.262
LGA    E   105_C      Y     124          1.720
LGA    I   106_C      F     125          1.094
LGA    N   107_C      R     126          0.796
LGA    K   108_C      K     127          1.876
LGA    L   109_C      R     128          1.895
LGA    L   110_C      L     129          1.520
LGA    I   111_C      I     130          1.439
LGA    S   112_C      Q     131          1.877
LGA    I   113_C      L     132          1.902
LGA    I   114_C      N     133          1.760
LGA    K   115_C      E     134          1.756
LGA    T   116_C      G     135          2.281
LGA    -       -      K     136           -
LGA    -       -      L     137           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  116  134    5.0    109    2.36     5.50     59.870     4.428

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.361523 * X  +  -0.850406 * Y  +   0.382245 * Z  +  17.444983
  Y_new =   0.302220 * X  +  -0.280954 * Y  +  -0.910894 * Z  +  90.035309
  Z_new =   0.882023 * X  +   0.444831 * Y  +   0.155438 * Z  +  32.272854 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.234627   -1.906965  [ DEG:    70.7389   -109.2611 ]
  Theta =  -1.080138   -2.061454  [ DEG:   -61.8874   -118.1126 ]
  Phi   =   0.696289   -2.445304  [ DEG:    39.8944   -140.1056 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2rld_C                                        
REMARK     2: T0478_4_137.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2rld_C.T0478_4_137.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  116  134   5.0  109   2.36    5.50  59.870
REMARK  ---------------------------------------------------------- 
MOLECULE 2rld_C
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   18-OCT-07   2RLD              
TITLE     CRYSTAL STRUCTURE OF UNCHARACTERIZED PROTEIN (NP_809265.1)            
TITLE    2 FROM BACTEROIDES THETAIOTAOMICRON VPI-5482 AT 1.70 A                 
TITLE    3 RESOLUTION                                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UNCHARACTERIZED PROTEIN;                                   
COMPND   3 CHAIN: A, B, C, D, E;                                                
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACTEROIDES THETAIOTAOMICRON VPI-5482;          
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: VPI-5482, DSM 2079, NCTC 10582, E50;                         
SOURCE   5 ATCC: 29148;                                                         
SOURCE   6 GENE: NP_809265.1, BT_0352;                                          
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    NP_809265.1, UNCHARACTERIZED PROTEIN, STRUCTURAL GENOMICS,            
KEYWDS   2 JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG, PROTEIN                  
KEYWDS   3 STRUCTURE INITIATIVE, PSI-2, STRUCTURAL GENOMICS, UNKNOWN            
KEYWDS   4 FUNCTION                                                             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   30-OCT-07 2RLD    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF UNCHARACTERIZED PROTEIN                 
JRNL        TITL 2 (NP_809265.1) FROM BACTEROIDES THETAIOTAOMICRON              
JRNL        TITL 3 VPI-5482 AT 1.70 A RESOLUTION                                
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.70 ANGSTROMS.                                          
DBREF  2RLD A    1   120  UNP    Q8AAW0   Q8AAW0_BACTN     1    120             
DBREF  2RLD B    1   120  UNP    Q8AAW0   Q8AAW0_BACTN     1    120             
DBREF  2RLD C    1   120  UNP    Q8AAW0   Q8AAW0_BACTN     1    120             
DBREF  2RLD D    1   120  UNP    Q8AAW0   Q8AAW0_BACTN     1    120             
DBREF  2RLD E    1   120  UNP    Q8AAW0   Q8AAW0_BACTN     1    120             
SEQRES   1 A  121  GLY MSE ARG GLU ASP MSE LYS ASP ASN VAL VAL LYS ASP          
SEQRES   2 A  121  LYS SER LEU GLU PHE ALA VAL ARG ILE VAL ASN LEU TYR          
SEQRES   3 A  121  LYS PHE LEU VAL ASN GLU GLN LYS GLU PHE VAL MSE SER          
SEQRES   4 A  121  LYS GLN ILE LEU ARG SER GLY THR SER ILE GLY ALA ASN          
SEQRES   5 A  121  ILE ARG GLU ALA GLU GLN ALA GLN SER ARG ALA ASP PHE          
SEQRES   6 A  121  ILE ASN LYS LEU ASN ILE ALA LEU LYS GLU ALA ASN GLU          
SEQRES   7 A  121  THR GLU TYR TRP LEU GLU LEU LEU ILE ARG THR GLU TYR          
SEQRES   8 A  121  ILE THR ARG GLU GLN TYR GLU SER ILE ASN ASN ASP SER          
SEQRES   9 A  121  THR GLU ILE ASN LYS LEU LEU ILE SER ILE ILE LYS THR          
SEQRES  10 A  121  THR LYS ASN ASN                                              
SEQRES   1 B  121  GLY MSE ARG GLU ASP MSE LYS ASP ASN VAL VAL LYS ASP          
SEQRES   2 B  121  LYS SER LEU GLU PHE ALA VAL ARG ILE VAL ASN LEU TYR          
SEQRES   3 B  121  LYS PHE LEU VAL ASN GLU GLN LYS GLU PHE VAL MSE SER          
SEQRES   4 B  121  LYS GLN ILE LEU ARG SER GLY THR SER ILE GLY ALA ASN          
SEQRES   5 B  121  ILE ARG GLU ALA GLU GLN ALA GLN SER ARG ALA ASP PHE          
SEQRES   6 B  121  ILE ASN LYS LEU ASN ILE ALA LEU LYS GLU ALA ASN GLU          
SEQRES   7 B  121  THR GLU TYR TRP LEU GLU LEU LEU ILE ARG THR GLU TYR          
SEQRES   8 B  121  ILE THR ARG GLU GLN TYR GLU SER ILE ASN ASN ASP SER          
SEQRES   9 B  121  THR GLU ILE ASN LYS LEU LEU ILE SER ILE ILE LYS THR          
SEQRES  10 B  121  THR LYS ASN ASN                                              
SEQRES   1 C  121  GLY MSE ARG GLU ASP MSE LYS ASP ASN VAL VAL LYS ASP          
SEQRES   2 C  121  LYS SER LEU GLU PHE ALA VAL ARG ILE VAL ASN LEU TYR          
SEQRES   3 C  121  LYS PHE LEU VAL ASN GLU GLN LYS GLU PHE VAL MSE SER          
SEQRES   4 C  121  LYS GLN ILE LEU ARG SER GLY THR SER ILE GLY ALA ASN          
SEQRES   5 C  121  ILE ARG GLU ALA GLU GLN ALA GLN SER ARG ALA ASP PHE          
SEQRES   6 C  121  ILE ASN LYS LEU ASN ILE ALA LEU LYS GLU ALA ASN GLU          
SEQRES   7 C  121  THR GLU TYR TRP LEU GLU LEU LEU ILE ARG THR GLU TYR          
SEQRES   8 C  121  ILE THR ARG GLU GLN TYR GLU SER ILE ASN ASN ASP SER          
SEQRES   9 C  121  THR GLU ILE ASN LYS LEU LEU ILE SER ILE ILE LYS THR          
SEQRES  10 C  121  THR LYS ASN ASN                                              
SEQRES   1 D  121  GLY MSE ARG GLU ASP MSE LYS ASP ASN VAL VAL LYS ASP          
SEQRES   2 D  121  LYS SER LEU GLU PHE ALA VAL ARG ILE VAL ASN LEU TYR          
SEQRES   3 D  121  LYS PHE LEU VAL ASN GLU GLN LYS GLU PHE VAL MSE SER          
SEQRES   4 D  121  LYS GLN ILE LEU ARG SER GLY THR SER ILE GLY ALA ASN          
SEQRES   5 D  121  ILE ARG GLU ALA GLU GLN ALA GLN SER ARG ALA ASP PHE          
SEQRES   6 D  121  ILE ASN LYS LEU ASN ILE ALA LEU LYS GLU ALA ASN GLU          
SEQRES   7 D  121  THR GLU TYR TRP LEU GLU LEU LEU ILE ARG THR GLU TYR          
SEQRES   8 D  121  ILE THR ARG GLU GLN TYR GLU SER ILE ASN ASN ASP SER          
SEQRES   9 D  121  THR GLU ILE ASN LYS LEU LEU ILE SER ILE ILE LYS THR          
SEQRES  10 D  121  THR LYS ASN ASN                                              
SEQRES   1 E  121  GLY MSE ARG GLU ASP MSE LYS ASP ASN VAL VAL LYS ASP          
SEQRES   2 E  121  LYS SER LEU GLU PHE ALA VAL ARG ILE VAL ASN LEU TYR          
SEQRES   3 E  121  LYS PHE LEU VAL ASN GLU GLN LYS GLU PHE VAL MSE SER          
SEQRES   4 E  121  LYS GLN ILE LEU ARG SER GLY THR SER ILE GLY ALA ASN          
SEQRES   5 E  121  ILE ARG GLU ALA GLU GLN ALA GLN SER ARG ALA ASP PHE          
SEQRES   6 E  121  ILE ASN LYS LEU ASN ILE ALA LEU LYS GLU ALA ASN GLU          
SEQRES   7 E  121  THR GLU TYR TRP LEU GLU LEU LEU ILE ARG THR GLU TYR          
SEQRES   8 E  121  ILE THR ARG GLU GLN TYR GLU SER ILE ASN ASN ASP SER          
SEQRES   9 E  121  THR GLU ILE ASN LYS LEU LEU ILE SER ILE ILE LYS THR          
SEQRES  10 E  121  THR LYS ASN ASN                                              
HET    MSE  A   1       8                                                       
HET    MSE  A   5      13                                                       
HET    MSE  A  37       8                                                       
HET    MSE  B   5       8                                                       
HET    MSE  B  37       8                                                       
HET    MSE  C   1       5                                                       
HET    MSE  C   5       5                                                       
HET    MSE  C  37       8                                                       
HET    MSE  D  37       8                                                       
HET    MSE  E  37       8                                                       
HET     CA  D 121       1                                                       
HET     CA  A 121       1                                                       
HET     CA  C 121       1                                                       
HET     CL  A 122       1                                                       
HET     CL  D 122       1                                                       
HET    EDO  B 121       4                                                       
HET    EDO  A 123       4                                                       
HET    EDO  C 122       4                                                       
HET    EDO  C 123       4                                                       
HET    EDO  B 122       4                                                       
HET    EDO  A 124       4                                                       
HET    EDO  B 123       4                                                       
HET    EDO  A 125       4                                                       
HET    EDO  B 124       4                                                       
HET    EDO  E 121       4                                                       
HET    EDO  A 126       4                                                       
HET    EDO  D 123       4                                                       
HET    EDO  B 125       4                                                       
HET    EDO  A 127       4                                                       
HET    EDO  E 122       4                                                       
HET    EDO  E 123       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      CA CALCIUM ION                                                      
HETNAM      CL CHLORIDE ION                                                     
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    10(C5 H11 N O2 SE)                                           
FORMUL   6   CA    3(CA 2+)                                                     
FORMUL   9   CL    2(CL 1-)                                                     
FORMUL  11  EDO    16(C2 H6 O2)                                                 
FORMUL  27  HOH   *518(H2 O)                                                    
CRYST1   57.238   83.823   63.923  90.00  97.42  90.00 P 1 21 1     10          
HETATM 1929  N   MSE C   1      14.124  83.760 104.826  1.00 44.73           N  
HETATM 1930  CA  MSE C   1      12.843  84.136 104.147  1.00 43.59           C  
HETATM 1931  C   MSE C   1      11.770  84.511 105.166  1.00 42.98           C  
HETATM 1932  O   MSE C   1      11.790  84.021 106.305  1.00 43.06           O  
HETATM 1933  CB  MSE C   1      12.334  82.977 103.280  1.00 44.17           C  
ATOM   1934  N   ARG C   2      10.843  85.378 104.745  1.00 42.00           N  
ATOM   1935  CA  ARG C   2       9.690  85.786 105.567  1.00 40.74           C  
ATOM   1936  C   ARG C   2       8.956  84.552 106.104  1.00 40.89           C  
ATOM   1937  O   ARG C   2       8.593  83.652 105.331  1.00 41.05           O  
ATOM   1938  CB  ARG C   2       8.725  86.656 104.753  1.00 38.99           C  
ATOM   1939  N   GLU C   3       8.757  84.508 107.424  1.00 39.52           N  
ATOM   1940  CA  GLU C   3       8.217  83.317 108.099  1.00 38.05           C  
ATOM   1941  C   GLU C   3       6.830  82.926 107.586  1.00 35.64           C  
ATOM   1942  O   GLU C   3       6.553  81.737 107.384  1.00 34.06           O  
ATOM   1943  CB  GLU C   3       8.172  83.529 109.617  1.00 38.61           C  
ATOM   1944  N   ASP C   4       5.986  83.932 107.360  1.00 33.23           N  
ATOM   1945  CA  ASP C   4       4.625  83.721 106.868  1.00 32.40           C  
ATOM   1946  C   ASP C   4       4.576  82.920 105.569  1.00 31.24           C  
ATOM   1947  O   ASP C   4       3.643  82.163 105.354  1.00 31.60           O  
ATOM   1948  CB  ASP C   4       3.929  85.057 106.636  1.00 32.11           C  
HETATM 1949  N   MSE C   5       5.582  83.098 104.715  1.00 31.75           N  
HETATM 1950  CA  MSE C   5       5.579  82.533 103.359  1.00 30.68           C  
HETATM 1951  C   MSE C   5       6.004  81.067 103.299  1.00 31.34           C  
HETATM 1952  O   MSE C   5       5.746  80.393 102.293  1.00 29.85           O  
HETATM 1953  CB  MSE C   5       6.505  83.357 102.452  1.00 30.73           C  
ATOM   1954  N   LYS C   6       6.648  80.574 104.360  1.00 30.55           N  
ATOM   1955  CA  LYS C   6       7.335  79.291 104.284  1.00 31.61           C  
ATOM   1956  C   LYS C   6       6.459  78.161 103.733  1.00 32.41           C  
ATOM   1957  O   LYS C   6       6.953  77.325 102.972  1.00 32.70           O  
ATOM   1958  CB  LYS C   6       7.981  78.900 105.627  1.00 32.20           C  
ATOM   1959  CG  LYS C   6       9.360  79.536 105.868  1.00 30.59           C  
ATOM   1960  N   ASP C   7       5.172  78.150 104.088  1.00 31.69           N  
ATOM   1961  CA  ASP C   7       4.269  77.087 103.630  1.00 31.23           C  
ATOM   1962  C   ASP C   7       3.909  77.228 102.148  1.00 28.96           C  
ATOM   1963  O   ASP C   7       3.830  76.237 101.422  1.00 26.01           O  
ATOM   1964  CB  ASP C   7       2.992  77.043 104.472  1.00 31.72           C  
ATOM   1965  CG  ASP C   7       2.147  78.284 104.299  1.00 32.91           C  
ATOM   1966  OD1 ASP C   7       2.561  79.341 104.806  1.00 32.32           O  
ATOM   1967  OD2 ASP C   7       1.101  78.214 103.618  1.00 46.60           O  
ATOM   1968  N   ASN C   8       3.696  78.457 101.694  1.00 29.66           N  
ATOM   1969  CA  ASN C   8       3.320  78.682 100.290  1.00 28.18           C  
ATOM   1970  C   ASN C   8       4.482  78.404  99.357  1.00 26.55           C  
ATOM   1971  O   ASN C   8       4.302  77.895  98.241  1.00 26.99           O  
ATOM   1972  CB  ASN C   8       2.872  80.127 100.063  1.00 30.99           C  
ATOM   1973  CG  ASN C   8       1.863  80.578 101.071  1.00 29.19           C  
ATOM   1974  OD1 ASN C   8       2.203  80.767 102.241  1.00 34.89           O  
ATOM   1975  ND2 ASN C   8       0.620  80.742 100.643  1.00 30.94           N  
ATOM   1976  N   VAL C   9       5.673  78.787  99.810  1.00 25.13           N  
ATOM   1977  CA  VAL C   9       6.888  78.534  99.058  1.00 23.76           C  
ATOM   1978  C   VAL C   9       7.240  77.050  99.015  1.00 21.52           C  
ATOM   1979  O   VAL C   9       7.653  76.553  97.969  1.00 21.53           O  
ATOM   1980  CB  VAL C   9       8.072  79.339  99.620  1.00 23.94           C  
ATOM   1981  CG1 VAL C   9       9.405  78.855  99.008  1.00 20.01           C  
ATOM   1982  CG2 VAL C   9       7.846  80.826  99.366  1.00 24.44           C  
ATOM   1983  N   VAL C  10       7.065  76.324 100.116  1.00 20.49           N  
ATOM   1984  CA  VAL C  10       7.414  74.899 100.093  1.00 20.19           C  
ATOM   1985  C   VAL C  10       6.457  74.106  99.188  1.00 21.39           C  
ATOM   1986  O   VAL C  10       6.872  73.128  98.571  1.00 19.49           O  
ATOM   1987  CB  VAL C  10       7.507  74.266 101.511  1.00 21.00           C  
ATOM   1988  CG1 VAL C  10       6.117  74.009 102.107  1.00 19.63           C  
ATOM   1989  CG2 VAL C  10       8.326  72.981 101.450  1.00 18.91           C  
ATOM   1990  N   LYS C  11       5.198  74.530  99.103  1.00 20.58           N  
ATOM   1991  CA  LYS C  11       4.256  73.933  98.162  1.00 20.56           C  
ATOM   1992  C   LYS C  11       4.760  74.099  96.739  1.00 19.63           C  
ATOM   1993  O   LYS C  11       4.881  73.117  96.005  1.00 20.22           O  
ATOM   1994  CB  LYS C  11       2.869  74.573  98.287  1.00 21.63           C  
ATOM   1995  CG  LYS C  11       1.876  74.083  97.248  1.00 26.24           C  
ATOM   1996  N   ASP C  12       5.032  75.337  96.324  1.00 17.69           N  
ATOM   1997  CA  ASP C  12       5.534  75.557  94.966  1.00 19.88           C  
ATOM   1998  C   ASP C  12       6.846  74.787  94.703  1.00 16.92           C  
ATOM   1999  O   ASP C  12       7.022  74.172  93.649  1.00 17.57           O  
ATOM   2000  CB  ASP C  12       5.751  77.040  94.679  1.00 20.40           C  
ATOM   2001  CG  ASP C  12       6.285  77.278  93.270  1.00 28.22           C  
ATOM   2002  OD1 ASP C  12       5.553  76.986  92.312  1.00 31.19           O  
ATOM   2003  OD2 ASP C  12       7.449  77.716  93.115  1.00 41.12           O  
ATOM   2004  N   LYS C  13       7.760  74.806  95.667  1.00 18.48           N  
ATOM   2005  CA  LYS C  13       9.023  74.079  95.486  1.00 18.59           C  
ATOM   2006  C   LYS C  13       8.788  72.590  95.319  1.00 16.74           C  
ATOM   2007  O   LYS C  13       9.494  71.938  94.562  1.00 17.28           O  
ATOM   2008  CB  LYS C  13       9.958  74.301  96.671  1.00 20.73           C  
ATOM   2009  CG  LYS C  13      10.370  75.739  96.856  1.00 24.19           C  
ATOM   2010  CD  LYS C  13      11.276  76.239  95.772  1.00 34.36           C  
ATOM   2011  CE  LYS C  13      12.043  77.478  96.257  1.00 37.47           C  
ATOM   2012  NZ  LYS C  13      12.764  78.139  95.144  1.00 39.10           N  
ATOM   2013  N   SER C  14       7.816  72.045  96.056  1.00 16.51           N  
ATOM   2014  CA  SER C  14       7.522  70.615  95.986  1.00 17.31           C  
ATOM   2015  C   SER C  14       6.941  70.210  94.631  1.00 17.51           C  
ATOM   2016  O   SER C  14       7.219  69.104  94.129  1.00 16.84           O  
ATOM   2017  CB  SER C  14       6.621  70.202  97.161  1.00 19.10           C  
ATOM   2018  OG  SER C  14       5.275  70.660  97.018  1.00 18.07           O  
ATOM   2019  N   LEU C  15       6.145  71.091  94.025  1.00 15.95           N  
ATOM   2020  CA  LEU C  15       5.573  70.814  92.701  1.00 17.85           C  
ATOM   2021  C   LEU C  15       6.655  70.860  91.621  1.00 17.24           C  
ATOM   2022  O   LEU C  15       6.744  69.975  90.746  1.00 17.34           O  
ATOM   2023  CB  LEU C  15       4.441  71.788  92.419  1.00 16.45           C  
ATOM   2024  CG  LEU C  15       3.142  71.523  93.167  1.00 19.48           C  
ATOM   2025  CD1 LEU C  15       2.230  72.774  93.194  1.00 22.04           C  
ATOM   2026  CD2 LEU C  15       2.400  70.343  92.521  1.00 23.28           C  
ATOM   2027  N   GLU C  16       7.512  71.878  91.690  1.00 16.67           N  
ATOM   2028  CA  GLU C  16       8.653  71.949  90.793  1.00 17.25           C  
ATOM   2029  C   GLU C  16       9.529  70.706  90.954  1.00 16.52           C  
ATOM   2030  O   GLU C  16      10.007  70.123  89.975  1.00 15.58           O  
ATOM   2031  CB  GLU C  16       9.460  73.225  91.032  1.00 17.06           C  
ATOM   2032  CG  GLU C  16       8.723  74.517  90.641  1.00 21.10           C  
ATOM   2033  CD  GLU C  16       8.236  74.549  89.197  1.00 31.39           C  
ATOM   2034  OE1 GLU C  16       8.962  74.123  88.270  1.00 34.50           O  
ATOM   2035  OE2 GLU C  16       7.103  75.007  88.990  1.00 36.92           O  
ATOM   2036  N   PHE C  17       9.710  70.275  92.198  1.00 16.77           N  
ATOM   2037  CA  PHE C  17      10.554  69.105  92.463  1.00 17.10           C  
ATOM   2038  C   PHE C  17       9.943  67.822  91.896  1.00 16.98           C  
ATOM   2039  O   PHE C  17      10.653  67.000  91.314  1.00 16.45           O  
ATOM   2040  CB  PHE C  17      10.793  68.936  93.959  1.00 16.76           C  
ATOM   2041  CG  PHE C  17      11.805  67.866  94.292  1.00 15.04           C  
ATOM   2042  CD1 PHE C  17      13.152  68.069  94.034  1.00 19.25           C  
ATOM   2043  CD2 PHE C  17      11.403  66.670  94.857  1.00 17.23           C  
ATOM   2044  CE1 PHE C  17      14.089  67.117  94.352  1.00 17.28           C  
ATOM   2045  CE2 PHE C  17      12.355  65.690  95.183  1.00 20.41           C  
ATOM   2046  CZ  PHE C  17      13.689  65.919  94.938  1.00 17.37           C  
ATOM   2047  N   ALA C  18       8.632  67.643  92.070  1.00 17.34           N  
ATOM   2048  CA  ALA C  18       7.917  66.504  91.514  1.00 15.27           C  
ATOM   2049  C   ALA C  18       8.205  66.410  90.009  1.00 14.67           C  
ATOM   2050  O   ALA C  18       8.457  65.326  89.467  1.00 15.22           O  
ATOM   2051  CB  ALA C  18       6.381  66.639  91.797  1.00 15.10           C  
ATOM   2052  N   VAL C  19       8.208  67.552  89.330  1.00 15.56           N  
ATOM   2053  CA  VAL C  19       8.438  67.559  87.888  1.00 16.05           C  
ATOM   2054  C   VAL C  19       9.900  67.088  87.579  1.00 15.08           C  
ATOM   2055  O   VAL C  19      10.147  66.283  86.668  1.00 16.24           O  
ATOM   2056  CB  VAL C  19       8.192  68.952  87.296  1.00 15.51           C  
ATOM   2057  CG1 VAL C  19       8.720  69.011  85.850  1.00 18.47           C  
ATOM   2058  CG2 VAL C  19       6.661  69.356  87.373  1.00 17.36           C  
ATOM   2059  N   ARG C  20      10.850  67.574  88.350  1.00 16.65           N  
ATOM   2060  CA  ARG C  20      12.224  67.139  88.197  1.00 16.04           C  
ATOM   2061  C   ARG C  20      12.330  65.627  88.449  1.00 15.63           C  
ATOM   2062  O   ARG C  20      13.062  64.925  87.742  1.00 15.30           O  
ATOM   2063  CB  ARG C  20      13.135  67.890  89.155  1.00 18.11           C  
ATOM   2064  CG  ARG C  20      13.221  69.395  88.867  1.00 16.66           C  
ATOM   2065  CD  ARG C  20      14.571  69.950  89.349  1.00 21.83           C  
ATOM   2066  NE  ARG C  20      15.693  69.496  88.529  1.00 20.04           N  
ATOM   2067  CZ  ARG C  20      16.975  69.651  88.866  1.00 21.47           C  
ATOM   2068  NH1 ARG C  20      17.303  70.233  90.017  1.00 19.07           N  
ATOM   2069  NH2 ARG C  20      17.930  69.194  88.071  1.00 21.27           N  
ATOM   2070  N   ILE C  21      11.602  65.125  89.449  1.00 13.67           N  
ATOM   2071  CA  ILE C  21      11.601  63.701  89.740  1.00 14.99           C  
ATOM   2072  C   ILE C  21      11.009  62.888  88.581  1.00 15.18           C  
ATOM   2073  O   ILE C  21      11.522  61.802  88.227  1.00 15.60           O  
ATOM   2074  CB  ILE C  21      10.916  63.427  91.095  1.00 16.82           C  
ATOM   2075  CG1 ILE C  21      11.810  63.936  92.231  1.00 18.21           C  
ATOM   2076  CG2 ILE C  21      10.569  61.910  91.235  1.00 16.06           C  
ATOM   2077  CD1 ILE C  21      13.132  63.118  92.367  1.00 17.76           C  
ATOM   2078  N   VAL C  22       9.956  63.405  87.966  1.00 16.66           N  
ATOM   2079  CA  VAL C  22       9.421  62.756  86.763  1.00 16.19           C  
ATOM   2080  C   VAL C  22      10.474  62.687  85.663  1.00 16.70           C  
ATOM   2081  O   VAL C  22      10.648  61.648  85.000  1.00 17.06           O  
ATOM   2082  CB  VAL C  22       8.120  63.413  86.271  1.00 15.80           C  
ATOM   2083  CG1 VAL C  22       7.692  62.904  84.912  1.00 19.01           C  
ATOM   2084  CG2 VAL C  22       7.007  63.169  87.240  1.00 16.26           C  
ATOM   2085  N   ASN C  23      11.170  63.789  85.431  1.00 15.42           N  
ATOM   2086  CA  ASN C  23      12.245  63.776  84.426  1.00 17.86           C  
ATOM   2087  C   ASN C  23      13.374  62.801  84.746  1.00 15.76           C  
ATOM   2088  O   ASN C  23      13.905  62.114  83.843  1.00 18.12           O  
ATOM   2089  CB  ASN C  23      12.777  65.198  84.227  1.00 19.22           C  
ATOM   2090  CG  ASN C  23      11.806  66.089  83.467  1.00 21.96           C  
ATOM   2091  OD1 ASN C  23      10.941  65.612  82.736  1.00 22.24           O  
ATOM   2092  ND2 ASN C  23      11.969  67.402  83.625  1.00 24.64           N  
ATOM   2093  N   LEU C  24      13.753  62.719  86.022  1.00 15.99           N  
ATOM   2094  CA  LEU C  24      14.755  61.778  86.458  1.00 16.25           C  
ATOM   2095  C   LEU C  24      14.306  60.352  86.226  1.00 16.55           C  
ATOM   2096  O   LEU C  24      15.108  59.503  85.852  1.00 15.86           O  
ATOM   2097  CB  LEU C  24      15.086  61.982  87.935  1.00 15.20           C  
ATOM   2098  CG  LEU C  24      16.134  61.024  88.509  1.00 14.61           C  
ATOM   2099  CD1 LEU C  24      17.508  61.172  87.796  1.00 17.21           C  
ATOM   2100  CD2 LEU C  24      16.260  61.225  90.037  1.00 17.29           C  
ATOM   2101  N   TYR C  25      13.042  60.079  86.510  1.00 15.76           N  
ATOM   2102  CA  TYR C  25      12.472  58.752  86.258  1.00 16.00           C  
ATOM   2103  C   TYR C  25      12.581  58.359  84.811  1.00 16.51           C  
ATOM   2104  O   TYR C  25      13.062  57.258  84.481  1.00 15.64           O  
ATOM   2105  CB  TYR C  25      11.026  58.705  86.721  1.00 16.36           C  
ATOM   2106  CG  TYR C  25      10.369  57.386  86.457  1.00 16.01           C  
ATOM   2107  CD1 TYR C  25      10.597  56.310  87.287  1.00 16.19           C  
ATOM   2108  CD2 TYR C  25       9.540  57.214  85.367  1.00 16.47           C  
ATOM   2109  CE1 TYR C  25      10.028  55.098  87.047  1.00 16.97           C  
ATOM   2110  CE2 TYR C  25       8.933  56.012  85.129  1.00 16.28           C  
ATOM   2111  CZ  TYR C  25       9.176  54.953  85.960  1.00 16.25           C  
ATOM   2112  OH  TYR C  25       8.587  53.729  85.733  1.00 23.09           O  
ATOM   2113  N   LYS C  26      12.185  59.264  83.925  1.00 16.28           N  
ATOM   2114  CA  LYS C  26      12.330  59.021  82.480  1.00 15.82           C  
ATOM   2115  C   LYS C  26      13.771  58.726  82.068  1.00 17.55           C  
ATOM   2116  O   LYS C  26      14.029  57.795  81.309  1.00 15.68           O  
ATOM   2117  CB  LYS C  26      11.803  60.223  81.696  1.00 16.16           C  
ATOM   2118  CG  LYS C  26      10.324  60.434  81.808  1.00 18.88           C  
ATOM   2119  CD  LYS C  26       9.932  61.775  81.213  1.00 21.32           C  
ATOM   2120  CE  LYS C  26       9.908  61.767  79.730  1.00 25.60           C  
ATOM   2121  NZ  LYS C  26       9.717  63.167  79.145  1.00 24.38           N  
ATOM   2122  N   PHE C  27      14.706  59.532  82.582  1.00 14.98           N  
ATOM   2123  CA  PHE C  27      16.129  59.339  82.342  1.00 15.38           C  
ATOM   2124  C   PHE C  27      16.569  57.954  82.763  1.00 15.01           C  
ATOM   2125  O   PHE C  27      17.183  57.236  81.968  1.00 15.81           O  
ATOM   2126  CB  PHE C  27      16.927  60.401  83.089  1.00 15.45           C  
ATOM   2127  CG  PHE C  27      18.411  60.185  83.047  1.00 15.28           C  
ATOM   2128  CD1 PHE C  27      19.152  60.548  81.922  1.00 18.63           C  
ATOM   2129  CD2 PHE C  27      19.067  59.651  84.123  1.00 15.36           C  
ATOM   2130  CE1 PHE C  27      20.535  60.352  81.869  1.00 18.95           C  
ATOM   2131  CE2 PHE C  27      20.473  59.457  84.074  1.00 18.06           C  
ATOM   2132  CZ  PHE C  27      21.188  59.828  82.938  1.00 17.47           C  
ATOM   2133  N   LEU C  28      16.218  57.564  83.993  1.00 15.65           N  
ATOM   2134  CA  LEU C  28      16.663  56.294  84.540  1.00 14.96           C  
ATOM   2135  C   LEU C  28      16.095  55.130  83.745  1.00 17.90           C  
ATOM   2136  O   LEU C  28      16.819  54.205  83.388  1.00 18.07           O  
ATOM   2137  CB  LEU C  28      16.294  56.166  86.015  1.00 12.41           C  
ATOM   2138  CG  LEU C  28      17.054  57.084  86.970  1.00 16.39           C  
ATOM   2139  CD1 LEU C  28      16.385  57.031  88.339  1.00 13.34           C  
ATOM   2140  CD2 LEU C  28      18.535  56.694  86.980  1.00 19.68           C  
ATOM   2141  N   VAL C  29      14.804  55.185  83.443  1.00 15.05           N  
ATOM   2142  CA  VAL C  29      14.177  54.078  82.735  1.00 14.09           C  
ATOM   2143  C   VAL C  29      14.614  54.022  81.268  1.00 15.16           C  
ATOM   2144  O   VAL C  29      15.025  52.970  80.788  1.00 17.22           O  
ATOM   2145  CB  VAL C  29      12.612  54.147  82.864  1.00 16.68           C  
ATOM   2146  CG1 VAL C  29      11.992  53.107  81.985  1.00 18.05           C  
ATOM   2147  CG2 VAL C  29      12.196  53.986  84.366  1.00 15.90           C  
ATOM   2148  N   ASN C  30      14.513  55.144  80.570  1.00 16.27           N  
ATOM   2149  CA  ASN C  30      14.698  55.167  79.110  1.00 17.32           C  
ATOM   2150  C   ASN C  30      16.159  55.136  78.687  1.00 16.67           C  
ATOM   2151  O   ASN C  30      16.520  54.426  77.722  1.00 19.70           O  
ATOM   2152  CB  ASN C  30      14.019  56.380  78.481  1.00 18.42           C  
ATOM   2153  CG  ASN C  30      12.517  56.349  78.637  1.00 21.87           C  
ATOM   2154  OD1 ASN C  30      11.898  55.290  78.576  1.00 23.19           O  
ATOM   2155  ND2 ASN C  30      11.927  57.509  78.855  1.00 22.60           N  
ATOM   2156  N   GLU C  31      17.002  55.850  79.426  1.00 18.49           N  
ATOM   2157  CA  GLU C  31      18.411  55.944  79.083  0.50 19.94           C  
ATOM   2159  C   GLU C  31      19.273  54.944  79.859  1.00 18.80           C  
ATOM   2160  O   GLU C  31      20.129  54.280  79.269  1.00 20.09           O  
ATOM   2161  CB  GLU C  31      18.885  57.388  79.259  0.50 20.52           C  
ATOM   2163  CG  GLU C  31      17.937  58.377  78.591  0.50 22.51           C  
ATOM   2165  CD  GLU C  31      18.444  59.791  78.595  0.50 24.39           C  
ATOM   2167  OE1 GLU C  31      19.658  59.991  78.368  0.50 26.74           O  
ATOM   2169  OE2 GLU C  31      17.622  60.701  78.817  0.50 21.11           O  
ATOM   2171  N   GLN C  32      19.040  54.814  81.161  1.00 17.64           N  
ATOM   2172  CA  GLN C  32      19.859  53.920  81.977  1.00 17.07           C  
ATOM   2173  C   GLN C  32      19.280  52.506  82.115  1.00 17.29           C  
ATOM   2174  O   GLN C  32      19.956  51.634  82.649  1.00 19.64           O  
ATOM   2175  CB  GLN C  32      20.131  54.504  83.365  1.00 16.83           C  
ATOM   2176  CG  GLN C  32      20.691  55.899  83.386  1.00 18.29           C  
ATOM   2177  CD  GLN C  32      22.140  55.971  82.914  1.00 25.54           C  
ATOM   2178  OE1 GLN C  32      22.452  55.578  81.799  1.00 26.99           O  
ATOM   2179  NE2 GLN C  32      23.030  56.479  83.765  1.00 23.41           N  
ATOM   2180  N   LYS C  33      18.069  52.277  81.607  1.00 16.91           N  
ATOM   2181  CA  LYS C  33      17.405  50.971  81.711  1.00 16.62           C  
ATOM   2182  C   LYS C  33      17.359  50.460  83.158  1.00 17.96           C  
ATOM   2183  O   LYS C  33      17.544  49.277  83.402  1.00 20.81           O  
ATOM   2184  CB  LYS C  33      18.074  49.938  80.796  1.00 16.90           C  
ATOM   2185  CG  LYS C  33      18.328  50.453  79.398  1.00 18.35           C  
ATOM   2186  CD  LYS C  33      17.088  50.998  78.748  1.00 19.87           C  
ATOM   2187  CE  LYS C  33      17.316  51.249  77.255  1.00 27.93           C  
ATOM   2188  NZ  LYS C  33      16.167  51.987  76.678  1.00 24.67           N  
ATOM   2189  N   GLU C  34      17.084  51.375  84.090  1.00 15.47           N  
ATOM   2190  CA  GLU C  34      16.976  51.096  85.512  1.00 15.65           C  
ATOM   2191  C   GLU C  34      15.534  51.239  85.962  1.00 17.67           C  
ATOM   2192  O   GLU C  34      14.919  52.317  85.848  1.00 17.58           O  
ATOM   2193  CB  GLU C  34      17.908  52.028  86.294  1.00 18.35           C  
ATOM   2194  CG  GLU C  34      18.271  51.523  87.686  1.00 18.27           C  
ATOM   2195  CD  GLU C  34      17.090  51.471  88.661  1.00 20.18           C  
ATOM   2196  OE1 GLU C  34      16.378  52.499  88.769  1.00 23.30           O  
ATOM   2197  OE2 GLU C  34      16.887  50.399  89.309  1.00 20.99           O  
ATOM   2198  N   PHE C  35      14.992  50.145  86.488  1.00 18.05           N  
ATOM   2199  CA  PHE C  35      13.559  50.021  86.703  1.00 18.55           C  
ATOM   2200  C   PHE C  35      13.151  49.898  88.158  1.00 20.96           C  
ATOM   2201  O   PHE C  35      11.988  50.067  88.472  1.00 24.88           O  
ATOM   2202  CB  PHE C  35      13.054  48.806  85.938  1.00 21.55           C  
ATOM   2203  CG  PHE C  35      13.324  48.874  84.461  1.00 23.21           C  
ATOM   2204  CD1 PHE C  35      12.671  49.805  83.688  1.00 33.34           C  
ATOM   2205  CD2 PHE C  35      14.231  48.039  83.868  1.00 29.78           C  
ATOM   2206  CE1 PHE C  35      12.913  49.890  82.335  1.00 32.25           C  
ATOM   2207  CE2 PHE C  35      14.477  48.119  82.505  1.00 32.12           C  
ATOM   2208  CZ  PHE C  35      13.814  49.055  81.749  1.00 29.98           C  
ATOM   2209  N   VAL C  36      14.093  49.620  89.046  1.00 18.90           N  
ATOM   2210  CA  VAL C  36      13.762  49.307  90.442  1.00 18.27           C  
ATOM   2211  C   VAL C  36      13.906  50.558  91.324  1.00 17.75           C  
ATOM   2212  O   VAL C  36      12.929  51.024  91.921  1.00 19.82           O  
ATOM   2213  CB  VAL C  36      14.656  48.126  90.967  1.00 20.73           C  
ATOM   2214  CG1 VAL C  36      14.492  47.929  92.486  1.00 18.49           C  
ATOM   2215  CG2 VAL C  36      14.296  46.837  90.255  1.00 21.61           C  
HETATM 2216  N   MSE C  37      15.107  51.133  91.371  1.00 17.96           N  
HETATM 2217  CA  MSE C  37      15.319  52.323  92.153  1.00 20.02           C  
HETATM 2218  C   MSE C  37      14.503  53.502  91.611  1.00 17.50           C  
HETATM 2219  O   MSE C  37      13.948  54.308  92.373  1.00 18.21           O  
HETATM 2220  CB  MSE C  37      16.822  52.618  92.272  1.00 22.11           C  
HETATM 2221  CG  MSE C  37      17.569  51.452  92.837  1.00 22.98           C  
HETATM 2222 SE   MSE C  37      19.447  51.889  93.057  0.75 30.84          SE  
HETATM 2223  CE  MSE C  37      20.016  51.725  91.124  1.00 20.24           C  
ATOM   2224  N   SER C  38      14.397  53.562  90.286  1.00 17.52           N  
ATOM   2225  CA  SER C  38      13.643  54.605  89.612  1.00 16.83           C  
ATOM   2226  C   SER C  38      12.189  54.629  90.077  1.00 17.01           C  
ATOM   2227  O   SER C  38      11.628  55.715  90.350  1.00 17.43           O  
ATOM   2228  CB  SER C  38      13.741  54.409  88.103  1.00 18.22           C  
ATOM   2229  OG  SER C  38      13.207  53.171  87.687  1.00 16.94           O  
ATOM   2230  N   LYS C  39      11.567  53.463  90.194  1.00 16.68           N  
ATOM   2231  CA  LYS C  39      10.165  53.440  90.631  1.00 18.99           C  
ATOM   2232  C   LYS C  39      10.024  53.896  92.073  1.00 18.09           C  
ATOM   2233  O   LYS C  39       9.087  54.638  92.417  1.00 19.21           O  
ATOM   2234  CB  LYS C  39       9.568  52.052  90.465  1.00 20.07           C  
ATOM   2235  CG  LYS C  39       9.687  51.497  89.108  1.00 29.21           C  
ATOM   2236  N   GLN C  40      10.985  53.521  92.905  1.00 16.83           N  
ATOM   2237  CA  GLN C  40      10.963  53.900  94.317  1.00 16.00           C  
ATOM   2238  C   GLN C  40      11.055  55.411  94.455  1.00 15.84           C  
ATOM   2239  O   GLN C  40      10.277  56.027  95.179  1.00 16.41           O  
ATOM   2240  CB  GLN C  40      12.086  53.254  95.089  1.00 16.79           C  
ATOM   2241  CG  GLN C  40      12.016  51.752  95.176  1.00 17.32           C  
ATOM   2242  CD  GLN C  40      11.193  51.274  96.320  1.00 26.39           C  
ATOM   2243  OE1 GLN C  40      10.165  51.872  96.646  1.00 28.98           O  
ATOM   2244  NE2 GLN C  40      11.629  50.182  96.949  1.00 29.76           N  
ATOM   2245  N   ILE C  41      11.966  56.033  93.709  1.00 16.05           N  
ATOM   2246  CA  ILE C  41      12.184  57.469  93.854  1.00 16.07           C  
ATOM   2247  C   ILE C  41      11.118  58.290  93.148  1.00 17.08           C  
ATOM   2248  O   ILE C  41      10.829  59.418  93.568  1.00 17.59           O  
ATOM   2249  CB  ILE C  41      13.620  57.886  93.403  1.00 16.90           C  
ATOM   2250  CG1 ILE C  41      13.975  59.240  94.022  1.00 16.91           C  
ATOM   2251  CG2 ILE C  41      13.777  57.877  91.888  1.00 17.58           C  
ATOM   2252  CD1 ILE C  41      15.346  59.774  93.639  1.00 15.47           C  
ATOM   2253  N   LEU C  42      10.513  57.750  92.091  1.00 16.55           N  
ATOM   2254  CA  LEU C  42       9.348  58.402  91.502  1.00 15.29           C  
ATOM   2255  C   LEU C  42       8.260  58.564  92.548  1.00 15.88           C  
ATOM   2256  O   LEU C  42       7.674  59.636  92.701  1.00 16.29           O  
ATOM   2257  CB  LEU C  42       8.813  57.577  90.336  1.00 14.80           C  
ATOM   2258  CG  LEU C  42       7.532  58.120  89.701  1.00 17.36           C  
ATOM   2259  CD1 LEU C  42       7.724  59.516  89.105  1.00 13.94           C  
ATOM   2260  CD2 LEU C  42       7.054  57.103  88.650  1.00 13.58           C  
ATOM   2261  N   ARG C  43       8.024  57.500  93.304  1.00 16.80           N  
ATOM   2262  CA  ARG C  43       7.015  57.523  94.353  0.50 17.14           C  
ATOM   2264  C   ARG C  43       7.370  58.478  95.497  1.00 17.98           C  
ATOM   2265  O   ARG C  43       6.565  59.353  95.868  1.00 17.96           O  
ATOM   2266  CB  ARG C  43       6.776  56.116  94.902  0.50 16.60           C  
ATOM   2268  CG  ARG C  43       5.668  56.042  95.958  0.50 17.05           C  
ATOM   2270  N   SER C  44       8.562  58.345  96.060  1.00 17.81           N  
ATOM   2271  CA  SER C  44       8.910  59.161  97.205  1.00 17.15           C  
ATOM   2272  C   SER C  44       9.025  60.626  96.803  1.00 15.72           C  
ATOM   2273  O   SER C  44       8.489  61.487  97.486  1.00 17.18           O  
ATOM   2274  CB  SER C  44      10.175  58.644  97.922  1.00 16.69           C  
ATOM   2275  OG  SER C  44      11.371  58.793  97.172  1.00 15.95           O  
ATOM   2276  N   GLY C  45       9.621  60.895  95.647  1.00 14.54           N  
ATOM   2277  CA  GLY C  45       9.913  62.270  95.233  1.00 16.03           C  
ATOM   2278  C   GLY C  45       8.651  63.056  94.900  1.00 16.17           C  
ATOM   2279  O   GLY C  45       8.580  64.255  95.140  1.00 16.17           O  
ATOM   2280  N   THR C  46       7.668  62.389  94.318  1.00 15.81           N  
ATOM   2281  CA  THR C  46       6.399  63.048  93.988  1.00 16.14           C  
ATOM   2282  C   THR C  46       5.436  63.081  95.165  1.00 18.12           C  
ATOM   2283  O   THR C  46       4.537  63.947  95.227  1.00 17.27           O  
ATOM   2284  CB  THR C  46       5.703  62.377  92.745  1.00 15.18           C  
ATOM   2285  OG1 THR C  46       5.414  61.015  93.060  1.00 15.05           O  
ATOM   2286  CG2 THR C  46       6.593  62.504  91.493  1.00 16.19           C  
ATOM   2287  N   SER C  47       5.657  62.208  96.151  1.00 16.20           N  
ATOM   2288  CA  SER C  47       4.790  62.132  97.337  1.00 18.28           C  
ATOM   2289  C   SER C  47       5.047  63.288  98.315  1.00 17.48           C  
ATOM   2290  O   SER C  47       4.191  63.593  99.146  1.00 18.59           O  
ATOM   2291  CB  SER C  47       4.948  60.795  98.055  1.00 19.41           C  
ATOM   2292  OG  SER C  47       4.461  59.708  97.260  1.00 19.73           O  
ATOM   2293  N   ILE C  48       6.230  63.897  98.248  1.00 17.17           N  
ATOM   2294  CA  ILE C  48       6.520  65.093  99.066  1.00 17.50           C  
ATOM   2295  C   ILE C  48       5.399  66.132  98.818  1.00 17.22           C  
ATOM   2296  O   ILE C  48       4.675  66.522  99.742  1.00 17.09           O  
ATOM   2297  CB  ILE C  48       7.905  65.702  98.726  1.00 16.99           C  
ATOM   2298  CG1 ILE C  48       9.029  64.665  98.885  1.00 18.96           C  
ATOM   2299  CG2 ILE C  48       8.226  66.946  99.594  1.00 19.79           C  
ATOM   2300  CD1 ILE C  48      10.379  65.153  98.340  1.00 17.60           C  
ATOM   2301  N   GLY C  49       5.194  66.514  97.551  1.00 17.81           N  
ATOM   2302  CA  GLY C  49       4.161  67.528  97.206  1.00 17.29           C  
ATOM   2303  C   GLY C  49       2.749  67.082  97.534  1.00 16.43           C  
ATOM   2304  O   GLY C  49       1.916  67.892  97.965  1.00 17.75           O  
ATOM   2305  N   ALA C  50       2.467  65.798  97.324  1.00 17.43           N  
ATOM   2306  CA  ALA C  50       1.144  65.268  97.587  1.00 17.84           C  
ATOM   2307  C   ALA C  50       0.772  65.405  99.090  1.00 18.07           C  
ATOM   2308  O   ALA C  50      -0.353  65.747  99.437  1.00 20.73           O  
ATOM   2309  CB  ALA C  50       1.045  63.810  97.128  1.00 18.37           C  
ATOM   2310  N   ASN C  51       1.714  65.140  99.968  1.00 18.51           N  
ATOM   2311  CA  ASN C  51       1.453  65.288 101.386  1.00 18.27           C  
ATOM   2312  C   ASN C  51       1.357  66.727 101.814  1.00 19.74           C  
ATOM   2313  O   ASN C  51       0.577  67.046 102.725  1.00 21.76           O  
ATOM   2314  CB  ASN C  51       2.519  64.565 102.206  1.00 18.34           C  
ATOM   2315  CG  ASN C  51       2.249  63.085 102.267  1.00 22.35           C  
ATOM   2316  OD1 ASN C  51       1.401  62.654 103.062  1.00 26.67           O  
ATOM   2317  ND2 ASN C  51       2.943  62.297 101.432  1.00 20.89           N  
ATOM   2318  N   ILE C  52       2.131  67.607 101.173  1.00 18.13           N  
ATOM   2319  CA  ILE C  52       2.034  69.036 101.471  1.00 18.69           C  
ATOM   2320  C   ILE C  52       0.631  69.502 101.101  1.00 21.22           C  
ATOM   2321  O   ILE C  52       0.001  70.256 101.845  1.00 20.71           O  
ATOM   2322  CB  ILE C  52       3.119  69.864 100.745  1.00 18.00           C  
ATOM   2323  CG1 ILE C  52       4.508  69.483 101.302  1.00 19.33           C  
ATOM   2324  CG2 ILE C  52       2.859  71.353 100.949  1.00 19.27           C  
ATOM   2325  CD1 ILE C  52       5.728  69.989 100.502  1.00 18.86           C  
ATOM   2326  N   ARG C  53       0.129  69.016  99.969  1.00 22.24           N  
ATOM   2327  CA  ARG C  53      -1.246  69.293  99.558  1.00 23.29           C  
ATOM   2328  C   ARG C  53      -2.278  68.774 100.568  1.00 22.82           C  
ATOM   2329  O   ARG C  53      -3.304  69.448 100.816  1.00 24.29           O  
ATOM   2330  CB  ARG C  53      -1.528  68.721  98.163  1.00 22.27           C  
ATOM   2331  CG  ARG C  53      -2.846  69.205  97.564  1.00 24.78           C  
ATOM   2332  CD  ARG C  53      -3.111  68.634  96.179  1.00 25.66           C  
ATOM   2333  NE  ARG C  53      -4.116  69.420  95.490  1.00 24.46           N  
ATOM   2334  CZ  ARG C  53      -5.429  69.275  95.611  1.00 26.87           C  
ATOM   2335  NH1 ARG C  53      -5.943  68.331  96.378  1.00 26.99           N  
ATOM   2336  NH2 ARG C  53      -6.232  70.080  94.933  1.00 26.20           N  
ATOM   2337  N   GLU C  54      -2.047  67.594 101.145  1.00 22.46           N  
ATOM   2338  CA  GLU C  54      -2.942  67.108 102.203  1.00 23.03           C  
ATOM   2339  C   GLU C  54      -2.853  68.019 103.410  1.00 22.42           C  
ATOM   2340  O   GLU C  54      -3.886  68.345 104.013  1.00 21.35           O  
ATOM   2341  CB  GLU C  54      -2.619  65.674 102.629  1.00 25.30           C  
ATOM   2342  CG  GLU C  54      -3.125  64.617 101.666  1.00 27.86           C  
ATOM   2343  CD  GLU C  54      -3.119  63.201 102.254  1.00 32.99           C  
ATOM   2344  OE1 GLU C  54      -2.891  63.045 103.483  1.00 41.94           O  
ATOM   2345  OE2 GLU C  54      -3.360  62.234 101.482  1.00 45.13           O  
ATOM   2346  N   ALA C  55      -1.628  68.425 103.771  1.00 21.99           N  
ATOM   2347  CA  ALA C  55      -1.407  69.330 104.917  1.00 23.53           C  
ATOM   2348  C   ALA C  55      -2.242  70.597 104.797  1.00 23.06           C  
ATOM   2349  O   ALA C  55      -2.889  71.037 105.767  1.00 23.42           O  
ATOM   2350  CB  ALA C  55       0.072  69.690 105.055  1.00 22.03           C  
ATOM   2351  N   GLU C  56      -2.251  71.175 103.605  1.00 23.93           N  
ATOM   2352  CA  GLU C  56      -2.957  72.446 103.375  1.00 27.59           C  
ATOM   2353  C   GLU C  56      -4.468  72.298 103.616  1.00 27.61           C  
ATOM   2354  O   GLU C  56      -5.161  73.281 103.893  1.00 25.84           O  
ATOM   2355  CB  GLU C  56      -2.698  72.966 101.954  1.00 28.51           C  
ATOM   2356  CG  GLU C  56      -1.210  73.249 101.612  1.00 33.77           C  
ATOM   2357  CD  GLU C  56      -0.726  74.682 101.883  1.00 45.30           C  
ATOM   2358  OE1 GLU C  56      -1.548  75.585 102.154  1.00 52.38           O  
ATOM   2359  OE2 GLU C  56       0.499  74.913 101.795  1.00 51.52           O  
ATOM   2360  N   GLN C  57      -4.959  71.064 103.536  1.00 26.98           N  
ATOM   2361  CA  GLN C  57      -6.373  70.754 103.723  1.00 26.60           C  
ATOM   2362  C   GLN C  57      -6.721  70.288 105.128  1.00 27.39           C  
ATOM   2363  O   GLN C  57      -7.873  69.928 105.388  1.00 27.35           O  
ATOM   2364  CB  GLN C  57      -6.790  69.697 102.708  1.00 26.09           C  
ATOM   2365  CG  GLN C  57      -6.849  70.246 101.285  1.00 29.51           C  
ATOM   2366  CD  GLN C  57      -7.074  69.166 100.257  1.00 29.74           C  
ATOM   2367  OE1 GLN C  57      -6.181  68.393  99.965  1.00 32.51           O  
ATOM   2368  NE2 GLN C  57      -8.277  69.112  99.703  1.00 31.44           N  
ATOM   2369  N   ALA C  58      -5.739  70.311 106.028  1.00 27.24           N  
ATOM   2370  CA  ALA C  58      -5.913  69.821 107.400  1.00 27.84           C  
ATOM   2371  C   ALA C  58      -7.013  70.566 108.127  1.00 28.07           C  
ATOM   2372  O   ALA C  58      -7.153  71.782 107.965  1.00 26.51           O  
ATOM   2373  CB  ALA C  58      -4.620  69.952 108.182  1.00 26.40           C  
ATOM   2374  N   GLN C  59      -7.772  69.834 108.942  1.00 29.60           N  
ATOM   2375  CA  GLN C  59      -8.842  70.417 109.750  1.00 30.64           C  
ATOM   2376  C   GLN C  59      -8.301  70.926 111.084  1.00 30.29           C  
ATOM   2377  O   GLN C  59      -8.972  71.676 111.771  1.00 30.93           O  
ATOM   2378  CB  GLN C  59      -9.970  69.402 109.992  1.00 30.42           C  
ATOM   2379  N   SER C  60      -7.087  70.505 111.432  1.00 30.54           N  
ATOM   2380  CA  SER C  60      -6.399  70.961 112.635  1.00 30.60           C  
ATOM   2381  C   SER C  60      -4.955  71.318 112.309  1.00 30.34           C  
ATOM   2382  O   SER C  60      -4.401  70.842 111.321  1.00 29.24           O  
ATOM   2383  CB  SER C  60      -6.427  69.867 113.721  1.00 30.69           C  
ATOM   2384  OG  SER C  60      -6.124  68.581 113.198  1.00 33.25           O  
ATOM   2385  N   ARG C  61      -4.346  72.152 113.149  1.00 30.48           N  
ATOM   2386  CA  ARG C  61      -2.910  72.423 113.057  1.00 30.34           C  
ATOM   2387  C   ARG C  61      -2.110  71.150 113.359  1.00 30.65           C  
ATOM   2388  O   ARG C  61      -1.008  70.964 112.834  1.00 28.66           O  
ATOM   2389  CB  ARG C  61      -2.505  73.543 114.020  1.00 30.16           C  
ATOM   2390  N   ALA C  62      -2.670  70.290 114.215  1.00 30.12           N  
ATOM   2391  CA  ALA C  62      -2.081  68.992 114.542  1.00 29.75           C  
ATOM   2392  C   ALA C  62      -1.954  68.145 113.298  1.00 28.97           C  
ATOM   2393  O   ALA C  62      -0.884  67.607 113.022  1.00 28.38           O  
ATOM   2394  CB  ALA C  62      -2.938  68.269 115.577  1.00 30.68           C  
ATOM   2395  N   ASP C  63      -3.057  68.031 112.557  1.00 28.00           N  
ATOM   2396  CA  ASP C  63      -3.103  67.242 111.329  1.00 26.81           C  
ATOM   2397  C   ASP C  63      -2.195  67.853 110.267  1.00 25.33           C  
ATOM   2398  O   ASP C  63      -1.523  67.143 109.522  1.00 25.38           O  
ATOM   2399  CB  ASP C  63      -4.542  67.170 110.817  1.00 28.90           C  
ATOM   2400  N   PHE C  64      -2.188  69.178 110.192  1.00 23.86           N  
ATOM   2401  CA  PHE C  64      -1.264  69.912 109.328  1.00 22.99           C  
ATOM   2402  C   PHE C  64       0.208  69.536 109.563  1.00 21.69           C  
ATOM   2403  O   PHE C  64       0.918  69.158 108.623  1.00 18.52           O  
ATOM   2404  CB  PHE C  64      -1.457  71.398 109.570  1.00 21.37           C  
ATOM   2405  CG  PHE C  64      -0.466  72.280 108.875  1.00 19.54           C  
ATOM   2406  CD1 PHE C  64      -0.594  72.566 107.532  1.00 22.60           C  
ATOM   2407  CD2 PHE C  64       0.550  72.895 109.591  1.00 26.53           C  
ATOM   2408  CE1 PHE C  64       0.293  73.417 106.900  1.00 22.24           C  
ATOM   2409  CE2 PHE C  64       1.445  73.740 108.966  1.00 24.49           C  
ATOM   2410  CZ  PHE C  64       1.318  74.006 107.625  1.00 25.34           C  
ATOM   2411  N   ILE C  65       0.660  69.652 110.806  1.00 22.12           N  
ATOM   2412  CA  ILE C  65       2.046  69.319 111.152  1.00 21.70           C  
ATOM   2413  C   ILE C  65       2.343  67.862 110.823  1.00 22.94           C  
ATOM   2414  O   ILE C  65       3.422  67.535 110.277  1.00 21.74           O  
ATOM   2415  CB  ILE C  65       2.347  69.608 112.664  1.00 22.88           C  
ATOM   2416  CG1 ILE C  65       2.312  71.111 112.944  1.00 23.58           C  
ATOM   2417  CG2 ILE C  65       3.704  69.079 113.070  1.00 22.36           C  
ATOM   2418  CD1 ILE C  65       3.356  71.923 112.197  1.00 25.70           C  
ATOM   2419  N   ASN C  66       1.395  66.981 111.119  1.00 22.46           N  
ATOM   2420  CA  ASN C  66       1.592  65.558 110.841  1.00 24.36           C  
ATOM   2421  C   ASN C  66       1.747  65.233 109.349  1.00 23.35           C  
ATOM   2422  O   ASN C  66       2.613  64.437 108.954  1.00 25.00           O  
ATOM   2423  CB  ASN C  66       0.480  64.720 111.481  1.00 27.09           C  
ATOM   2424  CG  ASN C  66       0.716  64.493 112.978  1.00 27.28           C  
ATOM   2425  OD1 ASN C  66       0.967  65.439 113.727  1.00 43.80           O  
ATOM   2426  ND2 ASN C  66       0.655  63.239 113.409  1.00 39.60           N  
ATOM   2427  N   LYS C  67       0.929  65.863 108.516  1.00 22.80           N  
ATOM   2428  CA  LYS C  67       1.068  65.687 107.075  1.00 22.03           C  
ATOM   2429  C   LYS C  67       2.407  66.256 106.590  1.00 20.94           C  
ATOM   2430  O   LYS C  67       3.055  65.671 105.708  1.00 20.19           O  
ATOM   2431  CB  LYS C  67      -0.119  66.310 106.334  1.00 22.84           C  
ATOM   2432  CG  LYS C  67      -1.430  65.574 106.601  1.00 25.79           C  
ATOM   2433  CD  LYS C  67      -1.410  64.186 106.004  1.00 31.67           C  
ATOM   2434  N   LEU C  68       2.857  67.366 107.182  1.00 19.48           N  
ATOM   2435  CA  LEU C  68       4.164  67.902 106.817  1.00 19.19           C  
ATOM   2436  C   LEU C  68       5.284  66.950 107.234  1.00 18.53           C  
ATOM   2437  O   LEU C  68       6.311  66.837 106.551  1.00 20.22           O  
ATOM   2438  CB  LEU C  68       4.384  69.278 107.422  1.00 17.83           C  
ATOM   2439  CG  LEU C  68       3.535  70.440 106.889  1.00 16.83           C  
ATOM   2440  CD1 LEU C  68       4.088  71.754 107.420  1.00 19.59           C  
ATOM   2441  CD2 LEU C  68       3.493  70.436 105.363  1.00 18.75           C  
ATOM   2442  N   ASN C  69       5.097  66.262 108.355  1.00 19.18           N  
ATOM   2443  CA  ASN C  69       6.080  65.282 108.800  1.00 18.08           C  
ATOM   2444  C   ASN C  69       6.169  64.104 107.850  1.00 17.94           C  
ATOM   2445  O   ASN C  69       7.265  63.575 107.627  1.00 17.45           O  
ATOM   2446  CB  ASN C  69       5.742  64.776 110.195  1.00 19.87           C  
ATOM   2447  CG  ASN C  69       6.864  63.917 110.797  1.00 27.17           C  
ATOM   2448  OD1 ASN C  69       6.697  62.711 110.984  1.00 35.48           O  
ATOM   2449  ND2 ASN C  69       8.007  64.546 111.114  1.00 31.41           N  
ATOM   2450  N   ILE C  70       5.030  63.692 107.283  1.00 18.07           N  
ATOM   2451  CA  ILE C  70       5.055  62.665 106.223  1.00 19.76           C  
ATOM   2452  C   ILE C  70       5.765  63.190 104.959  1.00 18.72           C  
ATOM   2453  O   ILE C  70       6.559  62.463 104.349  1.00 18.94           O  
ATOM   2454  CB  ILE C  70       3.650  62.167 105.840  1.00 19.75           C  
ATOM   2455  CG1 ILE C  70       2.918  61.578 107.050  1.00 24.21           C  
ATOM   2456  CG2 ILE C  70       3.737  61.082 104.731  1.00 19.86           C  
ATOM   2457  CD1 ILE C  70       1.436  61.299 106.767  1.00 23.97           C  
ATOM   2458  N   ALA C  71       5.546  64.457 104.600  1.00 18.05           N  
ATOM   2459  CA  ALA C  71       6.304  65.084 103.486  1.00 16.85           C  
ATOM   2460  C   ALA C  71       7.815  65.040 103.748  1.00 16.45           C  
ATOM   2461  O   ALA C  71       8.614  64.708 102.867  1.00 18.57           O  
ATOM   2462  CB  ALA C  71       5.854  66.541 103.277  1.00 14.30           C  
ATOM   2463  N   LEU C  72       8.197  65.352 104.989  1.00 16.95           N  
ATOM   2464  CA  LEU C  72       9.603  65.305 105.368  1.00 16.62           C  
ATOM   2465  C   LEU C  72      10.193  63.883 105.257  1.00 17.09           C  
ATOM   2466  O   LEU C  72      11.353  63.694 104.865  1.00 15.16           O  
ATOM   2467  CB  LEU C  72       9.757  65.815 106.794  1.00 18.58           C  
ATOM   2468  CG  LEU C  72      11.175  65.867 107.337  1.00 18.39           C  
ATOM   2469  CD1 LEU C  72      12.092  66.640 106.383  1.00 17.65           C  
ATOM   2470  CD2 LEU C  72      11.142  66.478 108.734  1.00 18.63           C  
ATOM   2471  N   LYS C  73       9.386  62.894 105.620  1.00 15.46           N  
ATOM   2472  CA  LYS C  73       9.785  61.498 105.515  1.00 15.87           C  
ATOM   2473  C   LYS C  73      10.097  61.160 104.079  1.00 16.14           C  
ATOM   2474  O   LYS C  73      11.107  60.498 103.755  1.00 16.45           O  
ATOM   2475  CB  LYS C  73       8.655  60.600 105.985  1.00 17.15           C  
ATOM   2476  CG  LYS C  73       8.962  59.106 105.922  1.00 21.73           C  
ATOM   2477  CD  LYS C  73       7.834  58.284 106.547  1.00 20.98           C  
ATOM   2478  CE  LYS C  73       6.561  58.236 105.656  1.00 26.15           C  
ATOM   2479  NZ  LYS C  73       6.748  57.268 104.531  1.00 28.23           N  
ATOM   2480  N   GLU C  74       9.193  61.592 103.219  1.00 15.97           N  
ATOM   2481  CA  GLU C  74       9.311  61.323 101.776  1.00 15.67           C  
ATOM   2482  C   GLU C  74      10.538  62.040 101.185  1.00 17.40           C  
ATOM   2483  O   GLU C  74      11.264  61.482 100.355  1.00 16.08           O  
ATOM   2484  CB  GLU C  74       8.014  61.714 101.065  1.00 17.47           C  
ATOM   2485  CG  GLU C  74       6.775  60.895 101.461  1.00 20.27           C  
ATOM   2486  CD  GLU C  74       6.796  59.431 101.014  1.00 25.06           C  
ATOM   2487  OE1 GLU C  74       7.812  58.937 100.483  1.00 24.46           O  
ATOM   2488  OE2 GLU C  74       5.743  58.774 101.176  1.00 33.53           O  
ATOM   2489  N   ALA C  75      10.803  63.257 101.637  1.00 17.30           N  
ATOM   2490  CA  ALA C  75      12.024  63.990 101.251  1.00 16.29           C  
ATOM   2491  C   ALA C  75      13.281  63.217 101.664  1.00 14.93           C  
ATOM   2492  O   ALA C  75      14.225  63.076 100.872  1.00 15.55           O  
ATOM   2493  CB  ALA C  75      12.020  65.382 101.873  1.00 15.35           C  
ATOM   2494  N   ASN C  76      13.275  62.684 102.880  1.00 17.41           N  
ATOM   2495  CA  ASN C  76      14.411  61.920 103.348  0.50 14.51           C  
ATOM   2497  C   ASN C  76      14.594  60.621 102.607  1.00 15.66           C  
ATOM   2498  O   ASN C  76      15.731  60.273 102.254  1.00 17.61           O  
ATOM   2499  CB  ASN C  76      14.333  61.689 104.839  0.50 15.13           C  
ATOM   2501  CG  ASN C  76      14.907  62.835 105.596  0.50 13.17           C  
ATOM   2503  OD1 ASN C  76      16.131  62.935 105.726  0.50 16.26           O  
ATOM   2505  ND2 ASN C  76      14.052  63.732 106.070  0.50 17.28           N  
ATOM   2507  N   GLU C  77      13.500  59.929 102.303  1.00 15.56           N  
ATOM   2508  CA  GLU C  77      13.635  58.697 101.500  1.00 13.58           C  
ATOM   2509  C   GLU C  77      14.190  59.011 100.109  1.00 16.22           C  
ATOM   2510  O   GLU C  77      15.053  58.289  99.586  1.00 16.65           O  
ATOM   2511  CB  GLU C  77      12.304  57.962 101.391  1.00 14.90           C  
ATOM   2512  CG  GLU C  77      12.510  56.597 100.753  1.00 15.14           C  
ATOM   2513  CD  GLU C  77      11.248  55.840 100.444  1.00 21.00           C  
ATOM   2514  OE1 GLU C  77      10.216  56.085 101.110  1.00 25.51           O  
ATOM   2515  OE2 GLU C  77      11.309  54.988  99.528  1.00 17.47           O  
ATOM   2516  N   THR C  78      13.714  60.096  99.530  1.00 15.41           N  
ATOM   2517  CA  THR C  78      14.158  60.521  98.195  1.00 15.08           C  
ATOM   2518  C   THR C  78      15.673  60.770  98.233  1.00 15.60           C  
ATOM   2519  O   THR C  78      16.389  60.393  97.317  1.00 15.68           O  
ATOM   2520  CB  THR C  78      13.399  61.800  97.742  1.00 17.74           C  
ATOM   2521  OG1 THR C  78      11.986  61.537  97.674  1.00 15.73           O  
ATOM   2522  CG2 THR C  78      13.893  62.289  96.377  1.00 17.87           C  
ATOM   2523  N   GLU C  79      16.137  61.422  99.290  1.00 15.86           N  
ATOM   2524  CA  GLU C  79      17.579  61.704  99.475  1.00 13.46           C  
ATOM   2525  C   GLU C  79      18.393  60.407  99.570  1.00 15.41           C  
ATOM   2526  O   GLU C  79      19.501  60.317  99.058  1.00 16.06           O  
ATOM   2527  CB  GLU C  79      17.750  62.655 100.666  1.00 17.76           C  
ATOM   2528  CG  GLU C  79      17.301  64.078 100.248  1.00 20.85           C  
ATOM   2529  CD  GLU C  79      16.593  64.888 101.323  1.00 26.56           C  
ATOM   2530  OE1 GLU C  79      16.683  64.523 102.515  1.00 22.78           O  
ATOM   2531  OE2 GLU C  79      15.928  65.889 100.950  1.00 25.68           O  
ATOM   2532  N   TYR C  80      17.823  59.398 100.210  1.00 14.82           N  
ATOM   2533  CA  TYR C  80      18.433  58.066 100.257  1.00 15.66           C  
ATOM   2534  C   TYR C  80      18.595  57.523  98.851  1.00 15.10           C  
ATOM   2535  O   TYR C  80      19.687  57.099  98.453  1.00 14.79           O  
ATOM   2536  CB  TYR C  80      17.551  57.109 101.081  1.00 15.97           C  
ATOM   2537  CG  TYR C  80      17.943  55.622 100.988  1.00 14.36           C  
ATOM   2538  CD1 TYR C  80      18.975  55.097 101.737  1.00 18.52           C  
ATOM   2539  CD2 TYR C  80      17.245  54.773 100.157  1.00 19.01           C  
ATOM   2540  CE1 TYR C  80      19.316  53.732 101.642  1.00 16.12           C  
ATOM   2541  CE2 TYR C  80      17.583  53.418 100.028  1.00 16.79           C  
ATOM   2542  CZ  TYR C  80      18.623  52.913 100.765  1.00 16.85           C  
ATOM   2543  OH  TYR C  80      18.904  51.566 100.666  1.00 18.02           O  
ATOM   2544  N   TRP C  81      17.510  57.537  98.082  1.00 14.50           N  
ATOM   2545  CA  TRP C  81      17.590  56.981  96.714  1.00 14.09           C  
ATOM   2546  C   TRP C  81      18.580  57.778  95.866  1.00 16.04           C  
ATOM   2547  O   TRP C  81      19.353  57.187  95.104  1.00 13.85           O  
ATOM   2548  CB  TRP C  81      16.205  56.895  96.017  1.00 15.74           C  
ATOM   2549  CG  TRP C  81      15.283  55.899  96.677  1.00 14.48           C  
ATOM   2550  CD1 TRP C  81      14.130  56.166  97.381  1.00 16.14           C  
ATOM   2551  CD2 TRP C  81      15.469  54.483  96.730  1.00 13.54           C  
ATOM   2552  NE1 TRP C  81      13.589  54.980  97.855  1.00 17.17           N  
ATOM   2553  CE2 TRP C  81      14.398  53.943  97.481  1.00 14.66           C  
ATOM   2554  CE3 TRP C  81      16.453  53.613  96.217  1.00 14.49           C  
ATOM   2555  CZ2 TRP C  81      14.278  52.585  97.727  1.00 17.62           C  
ATOM   2556  CZ3 TRP C  81      16.309  52.261  96.438  1.00 17.65           C  
ATOM   2557  CH2 TRP C  81      15.234  51.759  97.202  1.00 15.58           C  
ATOM   2558  N   LEU C  82      18.616  59.100  96.038  1.00 14.90           N  
ATOM   2559  CA  LEU C  82      19.563  59.905  95.256  1.00 14.34           C  
ATOM   2560  C   LEU C  82      21.008  59.516  95.592  1.00 15.55           C  
ATOM   2561  O   LEU C  82      21.884  59.432  94.731  1.00 15.99           O  
ATOM   2562  CB  LEU C  82      19.340  61.386  95.518  1.00 17.41           C  
ATOM   2563  CG  LEU C  82      18.084  61.997  94.897  1.00 18.15           C  
ATOM   2564  CD1 LEU C  82      17.873  63.425  95.420  1.00 19.84           C  
ATOM   2565  CD2 LEU C  82      18.129  61.965  93.328  1.00 18.72           C  
ATOM   2566  N   GLU C  83      21.274  59.317  96.867  1.00 14.45           N  
ATOM   2567  CA  GLU C  83      22.613  58.955  97.301  1.00 16.41           C  
ATOM   2568  C   GLU C  83      23.021  57.603  96.720  1.00 15.02           C  
ATOM   2569  O   GLU C  83      24.152  57.400  96.241  1.00 14.33           O  
ATOM   2570  CB  GLU C  83      22.648  58.888  98.827  1.00 16.73           C  
ATOM   2571  CG  GLU C  83      24.068  58.745  99.372  1.00 24.64           C  
ATOM   2572  CD  GLU C  83      24.147  58.791 100.904  1.00 28.59           C  
ATOM   2573  OE1 GLU C  83      23.147  59.167 101.566  1.00 31.02           O  
ATOM   2574  OE2 GLU C  83      25.232  58.463 101.428  1.00 33.10           O  
ATOM   2575  N   LEU C  84      22.097  56.652  96.783  1.00 15.55           N  
ATOM   2576  CA  LEU C  84      22.334  55.342  96.162  1.00 14.43           C  
ATOM   2577  C   LEU C  84      22.611  55.445  94.657  1.00 14.65           C  
ATOM   2578  O   LEU C  84      23.537  54.809  94.142  1.00 16.42           O  
ATOM   2579  CB  LEU C  84      21.146  54.414  96.439  1.00 15.47           C  
ATOM   2580  CG  LEU C  84      21.312  52.944  96.103  1.00 18.20           C  
ATOM   2581  CD1 LEU C  84      22.634  52.355  96.583  1.00 17.66           C  
ATOM   2582  CD2 LEU C  84      20.099  52.191  96.665  1.00 17.42           C  
ATOM   2583  N   LEU C  85      21.825  56.253  93.963  1.00 16.30           N  
ATOM   2584  CA  LEU C  85      22.017  56.444  92.531  1.00 15.28           C  
ATOM   2585  C   LEU C  85      23.382  57.050  92.156  1.00 16.27           C  
ATOM   2586  O   LEU C  85      24.014  56.574  91.235  1.00 17.14           O  
ATOM   2587  CB  LEU C  85      20.875  57.264  91.936  1.00 15.87           C  
ATOM   2588  CG  LEU C  85      19.482  56.606  91.925  1.00 15.79           C  
ATOM   2589  CD1 LEU C  85      18.379  57.644  91.695  1.00 14.57           C  
ATOM   2590  CD2 LEU C  85      19.451  55.492  90.815  1.00 18.26           C  
ATOM   2591  N   ILE C  86      23.864  58.060  92.889  1.00 16.30           N  
ATOM   2592  CA  ILE C  86      25.222  58.583  92.611  1.00 14.97           C  
ATOM   2593  C   ILE C  86      26.297  57.578  92.976  1.00 14.63           C  
ATOM   2594  O   ILE C  86      27.245  57.384  92.226  1.00 14.24           O  
ATOM   2595  CB  ILE C  86      25.481  59.991  93.256  1.00 16.64           C  
ATOM   2596  CG1 ILE C  86      26.838  60.575  92.796  1.00 20.18           C  
ATOM   2597  CG2 ILE C  86      25.430  59.941  94.772  1.00 14.17           C  
ATOM   2598  CD1 ILE C  86      26.934  60.802  91.327  1.00 26.72           C  
ATOM   2599  N   ARG C  87      26.146  56.891  94.112  1.00 15.15           N  
ATOM   2600  CA  ARG C  87      27.161  55.896  94.509  1.00 14.45           C  
ATOM   2601  C   ARG C  87      27.267  54.727  93.548  1.00 16.07           C  
ATOM   2602  O   ARG C  87      28.333  54.162  93.385  1.00 17.39           O  
ATOM   2603  CB  ARG C  87      26.895  55.385  95.924  1.00 15.06           C  
ATOM   2604  CG  ARG C  87      27.121  56.455  96.993  1.00 15.55           C  
ATOM   2605  CD  ARG C  87      28.597  56.637  97.290  1.00 20.23           C  
ATOM   2606  NE  ARG C  87      29.274  55.368  97.577  1.00 23.64           N  
ATOM   2607  CZ  ARG C  87      29.239  54.748  98.747  1.00 25.94           C  
ATOM   2608  NH1 ARG C  87      28.533  55.236  99.757  1.00 23.80           N  
ATOM   2609  NH2 ARG C  87      29.888  53.616  98.896  1.00 26.21           N  
ATOM   2610  N   THR C  88      26.178  54.392  92.870  1.00 14.47           N  
ATOM   2611  CA  THR C  88      26.204  53.314  91.881  1.00 14.80           C  
ATOM   2612  C   THR C  88      26.272  53.811  90.416  1.00 15.68           C  
ATOM   2613  O   THR C  88      26.094  53.024  89.503  1.00 16.92           O  
ATOM   2614  CB  THR C  88      24.993  52.393  92.068  1.00 15.41           C  
ATOM   2615  OG1 THR C  88      23.779  53.156  91.998  1.00 15.83           O  
ATOM   2616  CG2 THR C  88      25.076  51.683  93.420  1.00 16.01           C  
ATOM   2617  N   GLU C  89      26.560  55.093  90.213  1.00 15.62           N  
ATOM   2618  CA  GLU C  89      26.890  55.660  88.908  1.00 17.62           C  
ATOM   2619  C   GLU C  89      25.720  55.690  87.914  1.00 15.94           C  
ATOM   2620  O   GLU C  89      25.930  55.799  86.696  1.00 18.32           O  
ATOM   2621  CB  GLU C  89      28.133  54.988  88.322  1.00 16.41           C  
ATOM   2622  CG  GLU C  89      29.368  55.105  89.271  1.00 20.10           C  
ATOM   2623  CD  GLU C  89      30.591  54.338  88.794  1.00 23.51           C  
ATOM   2624  OE1 GLU C  89      30.659  53.979  87.607  1.00 31.46           O  
ATOM   2625  OE2 GLU C  89      31.481  54.107  89.621  1.00 33.90           O  
ATOM   2626  N   TYR C  90      24.502  55.639  88.445  1.00 16.54           N  
ATOM   2627  CA  TYR C  90      23.302  55.846  87.623  1.00 16.23           C  
ATOM   2628  C   TYR C  90      23.048  57.306  87.275  1.00 17.73           C  
ATOM   2629  O   TYR C  90      22.415  57.595  86.271  1.00 19.40           O  
ATOM   2630  CB  TYR C  90      22.067  55.201  88.260  1.00 17.84           C  
ATOM   2631  CG  TYR C  90      22.057  53.723  88.001  1.00 17.69           C  
ATOM   2632  CD1 TYR C  90      21.557  53.214  86.798  1.00 19.77           C  
ATOM   2633  CD2 TYR C  90      22.564  52.834  88.932  1.00 20.99           C  
ATOM   2634  CE1 TYR C  90      21.580  51.832  86.532  1.00 22.42           C  
ATOM   2635  CE2 TYR C  90      22.614  51.450  88.676  1.00 19.45           C  
ATOM   2636  CZ  TYR C  90      22.102  50.961  87.481  1.00 24.91           C  
ATOM   2637  OH  TYR C  90      22.104  49.594  87.261  1.00 28.33           O  
ATOM   2638  N   ILE C  91      23.539  58.223  88.098  1.00 18.19           N  
ATOM   2639  CA  ILE C  91      23.478  59.655  87.797  1.00 17.06           C  
ATOM   2640  C   ILE C  91      24.858  60.268  88.022  1.00 17.43           C  
ATOM   2641  O   ILE C  91      25.686  59.731  88.801  1.00 18.93           O  
ATOM   2642  CB  ILE C  91      22.440  60.399  88.664  1.00 15.18           C  
ATOM   2643  CG1 ILE C  91      22.745  60.233  90.168  1.00 17.55           C  
ATOM   2644  CG2 ILE C  91      20.988  59.967  88.273  1.00 18.21           C  
ATOM   2645  CD1 ILE C  91      21.833  61.066  91.043  1.00 14.73           C  
ATOM   2646  N   THR C  92      25.128  61.379  87.318  1.00 18.31           N  
ATOM   2647  CA  THR C  92      26.397  62.083  87.441  1.00 19.61           C  
ATOM   2648  C   THR C  92      26.417  62.898  88.722  1.00 18.34           C  
ATOM   2649  O   THR C  92      25.373  63.131  89.323  1.00 17.64           O  
ATOM   2650  CB  THR C  92      26.611  63.061  86.245  1.00 20.30           C  
ATOM   2651  OG1 THR C  92      25.605  64.085  86.277  1.00 19.12           O  
ATOM   2652  CG2 THR C  92      26.511  62.328  84.914  1.00 21.79           C  
ATOM   2653  N   ARG C  93      27.594  63.373  89.121  1.00 20.38           N  
ATOM   2654  CA  ARG C  93      27.691  64.223  90.309  1.00 19.52           C  
ATOM   2655  C   ARG C  93      26.898  65.507  90.096  1.00 17.92           C  
ATOM   2656  O   ARG C  93      26.270  66.012  91.019  1.00 18.71           O  
ATOM   2657  CB  ARG C  93      29.162  64.524  90.641  1.00 21.52           C  
ATOM   2658  CG  ARG C  93      29.388  65.581  91.729  1.00 31.08           C  
ATOM   2659  CD  ARG C  93      28.815  65.215  93.089  1.00 43.16           C  
ATOM   2660  NE  ARG C  93      29.456  64.055  93.709  1.00 48.75           N  
ATOM   2661  CZ  ARG C  93      29.289  63.689  94.981  1.00 49.47           C  
ATOM   2662  NH1 ARG C  93      28.511  64.391  95.799  1.00 49.14           N  
ATOM   2663  NH2 ARG C  93      29.915  62.618  95.448  1.00 49.60           N  
ATOM   2664  N   GLU C  94      26.898  66.010  88.862  1.00 17.74           N  
ATOM   2665  CA  GLU C  94      26.129  67.215  88.500  1.00 21.37           C  
ATOM   2666  C   GLU C  94      24.645  67.009  88.676  1.00 18.66           C  
ATOM   2667  O   GLU C  94      23.936  67.877  89.220  1.00 20.09           O  
ATOM   2668  CB  GLU C  94      26.402  67.607  87.043  1.00 21.39           C  
ATOM   2669  CG  GLU C  94      25.731  68.889  86.605  1.00 28.51           C  
ATOM   2670  CD  GLU C  94      25.933  69.209  85.115  1.00 31.19           C  
ATOM   2671  OE1 GLU C  94      26.610  68.435  84.391  1.00 30.01           O  
ATOM   2672  OE2 GLU C  94      25.388  70.249  84.666  1.00 41.47           O  
ATOM   2673  N   GLN C  95      24.151  65.862  88.221  1.00 18.29           N  
ATOM   2674  CA  GLN C  95      22.736  65.548  88.382  1.00 17.99           C  
ATOM   2675  C   GLN C  95      22.395  65.418  89.868  1.00 16.39           C  
ATOM   2676  O   GLN C  95      21.401  65.980  90.341  1.00 16.49           O  
ATOM   2677  CB  GLN C  95      22.353  64.270  87.626  1.00 19.42           C  
ATOM   2678  CG  GLN C  95      22.296  64.403  86.109  1.00 20.23           C  
ATOM   2679  CD  GLN C  95      22.133  63.049  85.409  1.00 22.30           C  
ATOM   2680  OE1 GLN C  95      22.954  62.144  85.590  1.00 20.10           O  
ATOM   2681  NE2 GLN C  95      21.067  62.908  84.606  1.00 24.98           N  
ATOM   2682  N   TYR C  96      23.237  64.681  90.576  1.00 15.72           N  
ATOM   2683  CA  TYR C  96      23.050  64.456  92.010  1.00 16.57           C  
ATOM   2684  C   TYR C  96      22.945  65.782  92.759  1.00 16.75           C  
ATOM   2685  O   TYR C  96      21.959  66.032  93.478  1.00 16.13           O  
ATOM   2686  CB  TYR C  96      24.205  63.623  92.580  1.00 18.01           C  
ATOM   2687  CG  TYR C  96      24.118  63.513  94.087  1.00 16.27           C  
ATOM   2688  CD1 TYR C  96      23.145  62.718  94.685  1.00 15.30           C  
ATOM   2689  CD2 TYR C  96      24.990  64.208  94.910  1.00 22.19           C  
ATOM   2690  CE1 TYR C  96      23.035  62.627  96.064  1.00 21.80           C  
ATOM   2691  CE2 TYR C  96      24.894  64.115  96.312  1.00 24.70           C  
ATOM   2692  CZ  TYR C  96      23.903  63.326  96.874  1.00 22.77           C  
ATOM   2693  OH  TYR C  96      23.780  63.210  98.252  1.00 22.25           O  
ATOM   2694  N   GLU C  97      23.955  66.634  92.586  1.00 17.01           N  
ATOM   2695  CA  GLU C  97      24.017  67.880  93.349  1.00 17.48           C  
ATOM   2696  C   GLU C  97      22.823  68.766  93.060  1.00 17.84           C  
ATOM   2697  O   GLU C  97      22.246  69.328  93.973  1.00 17.83           O  
ATOM   2698  CB  GLU C  97      25.327  68.623  93.101  1.00 17.92           C  
ATOM   2699  CG  GLU C  97      26.501  67.895  93.731  1.00 19.54           C  
ATOM   2700  CD  GLU C  97      27.754  68.738  93.865  1.00 27.75           C  
ATOM   2701  OE1 GLU C  97      27.861  69.808  93.213  1.00 31.95           O  
ATOM   2702  OE2 GLU C  97      28.643  68.307  94.634  1.00 33.38           O  
ATOM   2703  N   SER C  98      22.457  68.876  91.787  1.00 17.56           N  
ATOM   2704  CA  SER C  98      21.348  69.717  91.374  1.00 17.82           C  
ATOM   2705  C   SER C  98      20.035  69.297  92.027  1.00 17.71           C  
ATOM   2706  O   SER C  98      19.332  70.126  92.592  1.00 17.86           O  
ATOM   2707  CB  SER C  98      21.223  69.678  89.847  1.00 18.03           C  
ATOM   2708  OG  SER C  98      20.252  70.597  89.388  1.00 18.80           O  
ATOM   2709  N   ILE C  99      19.726  68.005  91.962  1.00 17.32           N  
ATOM   2710  CA  ILE C  99      18.440  67.488  92.420  1.00 18.86           C  
ATOM   2711  C   ILE C  99      18.467  67.407  93.940  1.00 19.02           C  
ATOM   2712  O   ILE C  99      17.498  67.766  94.606  1.00 18.21           O  
ATOM   2713  CB  ILE C  99      18.107  66.101  91.792  1.00 17.40           C  
ATOM   2714  CG1 ILE C  99      18.051  66.211  90.278  1.00 20.71           C  
ATOM   2715  CG2 ILE C  99      16.786  65.585  92.307  1.00 21.58           C  
ATOM   2716  CD1 ILE C  99      18.018  64.872  89.560  1.00 23.82           C  
ATOM   2717  N   ASN C 100      19.593  66.975  94.498  1.00 19.27           N  
ATOM   2718  CA  ASN C 100      19.678  66.836  95.949  1.00 17.76           C  
ATOM   2719  C   ASN C 100      19.603  68.178  96.679  1.00 18.82           C  
ATOM   2720  O   ASN C 100      19.039  68.261  97.763  1.00 19.28           O  
ATOM   2721  CB  ASN C 100      20.949  66.085  96.355  1.00 20.04           C  
ATOM   2722  CG  ASN C 100      20.963  65.736  97.836  1.00 19.73           C  
ATOM   2723  OD1 ASN C 100      20.171  64.917  98.294  1.00 25.82           O  
ATOM   2724  ND2 ASN C 100      21.858  66.360  98.585  1.00 30.01           N  
ATOM   2725  N   ASN C 101      20.168  69.219  96.083  1.00 17.55           N  
ATOM   2726  CA  ASN C 101      20.088  70.556  96.639  1.00 17.71           C  
ATOM   2727  C   ASN C 101      18.643  71.037  96.676  1.00 18.80           C  
ATOM   2728  O   ASN C 101      18.237  71.663  97.642  1.00 17.55           O  
ATOM   2729  CB  ASN C 101      20.936  71.534  95.831  1.00 18.71           C  
ATOM   2730  CG  ASN C 101      22.419  71.394  96.112  1.00 21.23           C  
ATOM   2731  OD1 ASN C 101      22.823  70.742  97.086  1.00 25.78           O  
ATOM   2732  ND2 ASN C 101      23.242  71.992  95.253  1.00 22.27           N  
ATOM   2733  N   ASP C 102      17.867  70.728  95.640  1.00 19.88           N  
ATOM   2734  CA  ASP C 102      16.442  71.079  95.646  1.00 18.06           C  
ATOM   2735  C   ASP C 102      15.690  70.295  96.740  1.00 18.59           C  
ATOM   2736  O   ASP C 102      14.769  70.827  97.399  1.00 18.59           O  
ATOM   2737  CB  ASP C 102      15.830  70.818  94.265  1.00 17.27           C  
ATOM   2738  CG  ASP C 102      16.254  71.837  93.221  1.00 19.40           C  
ATOM   2739  OD1 ASP C 102      16.922  72.816  93.587  1.00 19.83           O  
ATOM   2740  OD2 ASP C 102      15.870  71.688  92.029  1.00 20.83           O  
ATOM   2741  N   SER C 103      16.050  69.025  96.902  1.00 17.93           N  
ATOM   2742  CA  SER C 103      15.439  68.165  97.928  1.00 17.89           C  
ATOM   2743  C   SER C 103      15.707  68.711  99.311  1.00 20.50           C  
ATOM   2744  O   SER C 103      14.794  68.874 100.130  1.00 22.50           O  
ATOM   2745  CB  SER C 103      15.937  66.722  97.810  1.00 22.08           C  
ATOM   2746  OG  SER C 103      14.962  65.810  98.316  1.00 24.98           O  
ATOM   2747  N   THR C 104      16.961  69.058  99.565  1.00 20.96           N  
ATOM   2748  CA  THR C 104      17.348  69.441 100.907  1.00 20.74           C  
ATOM   2749  C   THR C 104      16.810  70.839 101.255  1.00 20.21           C  
ATOM   2750  O   THR C 104      16.535  71.147 102.428  1.00 19.55           O  
ATOM   2751  CB  THR C 104      18.875  69.312 101.098  1.00 22.25           C  
ATOM   2752  OG1 THR C 104      19.546  70.080 100.107  1.00 26.42           O  
ATOM   2753  CG2 THR C 104      19.308  67.858 100.951  1.00 22.12           C  
ATOM   2754  N   GLU C 105      16.627  71.682 100.240  1.00 21.52           N  
ATOM   2755  CA  GLU C 105      15.929  72.958 100.430  1.00 21.74           C  
ATOM   2756  C   GLU C 105      14.526  72.719 100.977  1.00 19.79           C  
ATOM   2757  O   GLU C 105      14.062  73.459 101.824  1.00 22.00           O  
ATOM   2758  CB  GLU C 105      15.866  73.735  99.110  1.00 22.07           C  
ATOM   2759  CG  GLU C 105      15.075  75.022  99.163  1.00 25.32           C  
ATOM   2760  CD  GLU C 105      15.042  75.753  97.819  1.00 28.43           C  
ATOM   2761  OE1 GLU C 105      15.073  75.083  96.753  1.00 26.80           O  
ATOM   2762  OE2 GLU C 105      14.996  77.003  97.831  1.00 34.02           O  
ATOM   2763  N   ILE C 106      13.836  71.692 100.465  1.00 19.89           N  
ATOM   2764  CA  ILE C 106      12.496  71.349 100.940  1.00 19.64           C  
ATOM   2765  C   ILE C 106      12.530  70.825 102.376  1.00 19.76           C  
ATOM   2766  O   ILE C 106      11.671  71.198 103.195  1.00 17.44           O  
ATOM   2767  CB  ILE C 106      11.781  70.350  99.959  1.00 18.63           C  
ATOM   2768  CG1 ILE C 106      11.436  71.063  98.650  1.00 20.64           C  
ATOM   2769  CG2 ILE C 106      10.541  69.701 100.591  1.00 20.84           C  
ATOM   2770  CD1 ILE C 106      11.020  70.130  97.542  1.00 19.98           C  
ATOM   2771  N   ASN C 107      13.519  69.985 102.693  1.00 19.60           N  
ATOM   2772  CA  ASN C 107      13.730  69.548 104.077  1.00 20.10           C  
ATOM   2773  C   ASN C 107      13.747  70.724 105.057  1.00 20.43           C  
ATOM   2774  O   ASN C 107      13.088  70.714 106.099  1.00 20.34           O  
ATOM   2775  CB  ASN C 107      15.068  68.836 104.225  1.00 19.61           C  
ATOM   2776  CG  ASN C 107      15.054  67.430 103.697  1.00 22.88           C  
ATOM   2777  OD1 ASN C 107      14.418  67.140 102.698  1.00 26.97           O  
ATOM   2778  ND2 ASN C 107      15.780  66.538 104.377  1.00 29.35           N  
ATOM   2779  N   LYS C 108      14.529  71.732 104.698  1.00 20.40           N  
ATOM   2780  CA  LYS C 108      14.808  72.869 105.572  1.00 21.97           C  
ATOM   2781  C   LYS C 108      13.515  73.643 105.856  1.00 21.95           C  
ATOM   2782  O   LYS C 108      13.217  73.994 107.004  1.00 21.97           O  
ATOM   2783  CB  LYS C 108      15.827  73.754 104.870  1.00 23.26           C  
ATOM   2784  CG  LYS C 108      16.271  74.977 105.633  1.00 24.31           C  
ATOM   2785  CD  LYS C 108      17.222  75.818 104.791  1.00 28.75           C  
ATOM   2786  CE  LYS C 108      16.602  76.210 103.458  1.00 30.41           C  
ATOM   2787  NZ  LYS C 108      16.956  77.588 103.044  1.00 30.01           N  
ATOM   2788  N   LEU C 109      12.738  73.886 104.804  1.00 20.63           N  
ATOM   2789  CA  LEU C 109      11.498  74.637 104.944  1.00 21.02           C  
ATOM   2790  C   LEU C 109      10.466  73.837 105.764  1.00 21.58           C  
ATOM   2791  O   LEU C 109       9.794  74.383 106.669  1.00 19.57           O  
ATOM   2792  CB  LEU C 109      10.952  74.977 103.556  1.00 21.79           C  
ATOM   2793  CG  LEU C 109      11.869  75.875 102.710  1.00 23.54           C  
ATOM   2794  CD1 LEU C 109      11.428  75.950 101.232  1.00 22.13           C  
ATOM   2795  CD2 LEU C 109      11.926  77.256 103.342  1.00 25.18           C  
ATOM   2796  N   LEU C 110      10.355  72.538 105.470  1.00 19.82           N  
ATOM   2797  CA  LEU C 110       9.426  71.696 106.236  1.00 20.42           C  
ATOM   2798  C   LEU C 110       9.779  71.672 107.719  1.00 19.80           C  
ATOM   2799  O   LEU C 110       8.908  71.788 108.586  1.00 22.32           O  
ATOM   2800  CB  LEU C 110       9.384  70.277 105.693  1.00 18.12           C  
ATOM   2801  CG  LEU C 110       8.796  70.121 104.292  1.00 17.60           C  
ATOM   2802  CD1 LEU C 110       9.127  68.724 103.779  1.00 20.47           C  
ATOM   2803  CD2 LEU C 110       7.292  70.360 104.305  1.00 17.92           C  
ATOM   2804  N   ILE C 111      11.066  71.574 108.018  1.00 21.92           N  
ATOM   2805  CA  ILE C 111      11.497  71.543 109.410  1.00 21.38           C  
ATOM   2806  C   ILE C 111      11.172  72.861 110.118  1.00 23.70           C  
ATOM   2807  O   ILE C 111      10.709  72.866 111.279  1.00 24.04           O  
ATOM   2808  CB  ILE C 111      12.994  71.200 109.533  1.00 21.16           C  
ATOM   2809  CG1 ILE C 111      13.209  69.741 109.133  1.00 22.95           C  
ATOM   2810  CG2 ILE C 111      13.487  71.454 110.983  1.00 21.38           C  
ATOM   2811  CD1 ILE C 111      14.619  69.407 108.732  1.00 23.81           C  
ATOM   2812  N   SER C 112      11.383  73.977 109.421  1.00 24.58           N  
ATOM   2813  CA  SER C 112      11.091  75.295 109.977  0.50 25.92           C  
ATOM   2815  C   SER C 112       9.618  75.402 110.354  1.00 25.29           C  
ATOM   2816  O   SER C 112       9.270  75.727 111.483  1.00 23.38           O  
ATOM   2817  CB  SER C 112      11.447  76.393 108.970  0.50 27.19           C  
ATOM   2819  OG  SER C 112      11.325  77.676 109.556  0.50 27.48           O  
ATOM   2821  N   ILE C 113       8.751  75.117 109.397  1.00 22.92           N  
ATOM   2822  CA  ILE C 113       7.320  75.142 109.644  1.00 23.36           C  
ATOM   2823  C   ILE C 113       6.998  74.241 110.852  1.00 24.33           C  
ATOM   2824  O   ILE C 113       6.407  74.686 111.853  1.00 24.15           O  
ATOM   2825  CB  ILE C 113       6.546  74.674 108.401  1.00 21.81           C  
ATOM   2826  CG1 ILE C 113       6.692  75.690 107.262  1.00 22.61           C  
ATOM   2827  CG2 ILE C 113       5.076  74.459 108.730  1.00 21.42           C  
ATOM   2828  CD1 ILE C 113       6.438  75.114 105.898  1.00 23.14           C  
ATOM   2829  N   ILE C 114       7.437  72.988 110.774  1.00 23.34           N  
ATOM   2830  CA  ILE C 114       7.132  71.995 111.804  1.00 24.57           C  
ATOM   2831  C   ILE C 114       7.604  72.452 113.180  1.00 27.84           C  
ATOM   2832  O   ILE C 114       6.878  72.310 114.171  1.00 28.86           O  
ATOM   2833  CB  ILE C 114       7.745  70.626 111.469  1.00 24.96           C  
ATOM   2834  CG1 ILE C 114       7.033  70.034 110.242  1.00 23.79           C  
ATOM   2835  CG2 ILE C 114       7.625  69.672 112.681  1.00 23.89           C  
ATOM   2836  CD1 ILE C 114       7.836  68.994 109.484  1.00 22.53           C  
ATOM   2837  N   LYS C 115       8.802  73.028 113.217  1.00 29.84           N  
ATOM   2838  CA  LYS C 115       9.414  73.498 114.449  1.00 31.09           C  
ATOM   2839  C   LYS C 115       8.916  74.898 114.842  1.00 33.36           C  
ATOM   2840  O   LYS C 115       8.998  75.281 116.012  1.00 34.87           O  
ATOM   2841  CB  LYS C 115      10.940  73.479 114.295  1.00 30.25           C  
ATOM   2842  N   THR C 116       8.396  75.653 113.877  1.00 35.39           N  
ATOM   2843  CA  THR C 116       7.920  77.014 114.119  1.00 37.06           C  
ATOM   2844  C   THR C 116       6.649  77.021 114.965  1.00 37.88           C  
ATOM   2845  O   THR C 116       5.901  77.999 114.967  1.00 40.22           O  
ATOM   2846  CB  THR C 116       7.633  77.764 112.799  1.00 36.96           C  
TER    2847      THR C 116                                                      
END
MOLECULE T0478_4_137.pdb
ATOM      1  N   ASP     4       4.583  90.045  96.477  1.00 46.14          
ATOM      2  CA  ASP     4       4.507  89.250  97.769  1.00 46.88          
ATOM      3  C   ASP     4       3.473  88.149  97.680  1.00 46.81          
ATOM      4  O   ASP     4       2.251  88.418  97.704  1.00 47.19          
ATOM      5  CB  ASP     4       4.217  90.115  99.002  1.00 47.14          
ATOM      6  CG  ASP     4       4.106  89.277 100.294  1.00 49.60          
ATOM      7  OD1 ASP     4       4.261  88.031 100.209  1.00 52.13          
ATOM      8  OD2 ASP     4       3.861  89.853 101.391  1.00 50.11          
ATOM      9  N   THR     5       3.945  86.901  97.569  1.00 45.73          
ATOM     10  CA  THR     5       3.014  85.791  97.370  1.00 43.86          
ATOM     11  C   THR     5       3.155  84.703  98.446  1.00 42.88          
ATOM     12  O   THR     5       2.807  83.555  98.195  1.00 43.23          
ATOM     13  CB  THR     5       3.203  85.199  95.964  1.00 44.39          
ATOM     14  OG1 THR     5       4.219  84.162  95.995  1.00 43.91          
ATOM     15  CG2 THR     5       3.653  86.329  94.994  1.00 42.87          
ATOM     16  N   GLY     6       3.647  85.065  99.639  1.00 41.82          
ATOM     17  CA  GLY     6       3.749  84.115 100.761  1.00 41.38          
ATOM     18  C   GLY     6       5.131  83.471 100.962  1.00 40.88          
ATOM     19  O   GLY     6       5.359  82.746 101.949  1.00 41.55          
ATOM     20  N   VAL     7       6.058  83.715 100.044  1.00 39.35          
ATOM     21  CA  VAL     7       7.346  83.016 100.066  1.00 39.01          
ATOM     22  C   VAL     7       8.140  83.267 101.350  1.00 37.94          
ATOM     23  O   VAL     7       8.922  82.425 101.792  1.00 37.31          
ATOM     24  CB  VAL     7       8.220  83.413  98.851  1.00 38.91          
ATOM     25  CG1 VAL     7       9.666  82.818  98.964  1.00 39.41          
ATOM     26  CG2 VAL     7       7.568  82.980  97.583  1.00 39.41          
ATOM     27  N   THR     8       7.910  84.426 101.944  1.00 37.37          
ATOM     28  CA  THR     8       8.703  84.896 103.082  1.00 38.13          
ATOM     29  C   THR     8       7.798  85.065 104.327  1.00 38.06          
ATOM     30  O   THR     8       8.196  85.651 105.317  1.00 37.56          
ATOM     31  CB  THR     8       9.436  86.247 102.776  1.00 38.11          
ATOM     32  OG1 THR     8       8.472  87.213 102.346  1.00 39.04          
ATOM     33  CG2 THR     8      10.541  86.066 101.678  1.00 37.14          
ATOM     34  N   SER     9       6.585  84.542 104.260  1.00 37.68          
ATOM     35  CA  SER     9       5.682  84.653 105.375  1.00 38.73          
ATOM     36  C   SER     9       6.278  84.061 106.641  1.00 38.82          
ATOM     37  O   SER     9       6.941  83.050 106.594  1.00 39.70          
ATOM     38  CB  SER     9       4.375  83.918 105.105  1.00 37.74          
ATOM     39  OG  SER     9       3.563  84.197 106.216  1.00 38.73          
ATOM     40  N   VAL    10       6.016  84.679 107.780  1.00 39.19          
ATOM     41  CA  VAL    10       6.419  84.087 109.038  1.00 39.26          
ATOM     42  C   VAL    10       5.217  83.395 109.738  1.00 39.93          
ATOM     43  O   VAL    10       5.415  82.637 110.667  1.00 41.04          
ATOM     44  CB  VAL    10       7.166  85.103 109.942  1.00 40.00          
ATOM     45  CG1 VAL    10       8.547  85.534 109.298  1.00 39.05          
ATOM     46  CG2 VAL    10       6.305  86.325 110.259  1.00 38.98          
ATOM     47  N   MET    11       3.989  83.582 109.239  1.00 39.39          
ATOM     48  CA  MET    11       2.813  82.859 109.778  1.00 39.00          
ATOM     49  C   MET    11       2.973  81.393 109.487  1.00 38.60          
ATOM     50  O   MET    11       3.159  80.997 108.330  1.00 38.96          
ATOM     51  CB  MET    11       1.467  83.324 109.167  1.00 39.16          
ATOM     52  CG  MET    11       1.150  84.825 109.220  1.00 39.46          
ATOM     53  SD  MET    11      -0.657  85.154 109.119  1.00 40.60          
ATOM     54  CE  MET    11      -1.095  84.252 107.659  1.00 41.80          
ATOM     55  N   PHE    12       2.873  80.568 110.523  1.00 37.85          
ATOM     56  CA  PHE    12       3.286  79.168 110.422  1.00 36.77          
ATOM     57  C   PHE    12       2.520  78.420 109.339  1.00 35.98          
ATOM     58  O   PHE    12       3.096  77.611 108.567  1.00 35.26          
ATOM     59  CB  PHE    12       3.128  78.498 111.804  1.00 37.68          
ATOM     60  CG  PHE    12       3.323  76.997 111.808  1.00 37.24          
ATOM     61  CD1 PHE    12       4.613  76.445 111.810  1.00 40.00          
ATOM     62  CD2 PHE    12       2.223  76.147 111.889  1.00 37.43          
ATOM     63  CE1 PHE    12       4.802  75.076 111.854  1.00 37.89          
ATOM     64  CE2 PHE    12       2.380  74.768 111.887  1.00 35.92          
ATOM     65  CZ  PHE    12       3.644  74.231 111.865  1.00 37.29          
ATOM     66  N   VAL    13       1.214  78.636 109.268  1.00 35.38          
ATOM     67  CA  VAL    13       0.457  77.821 108.323  1.00 35.71          
ATOM     68  C   VAL    13       0.703  78.270 106.915  1.00 36.00          
ATOM     69  O   VAL    13       1.021  77.465 106.026  1.00 36.75          
ATOM     70  CB  VAL    13      -1.032  77.704 108.600  1.00 35.30          
ATOM     71  CG1 VAL    13      -1.601  76.709 107.656  1.00 35.80          
ATOM     72  CG2 VAL    13      -1.239  77.206 109.962  1.00 36.71          
ATOM     73  N   GLU    14       0.578  79.562 106.710  1.00 35.83          
ATOM     74  CA  GLU    14       0.760  80.082 105.395  1.00 36.87          
ATOM     75  C   GLU    14       2.133  79.687 104.847  1.00 35.03          
ATOM     76  O   GLU    14       2.247  79.204 103.738  1.00 35.05          
ATOM     77  CB  GLU    14       0.668  81.584 105.476  1.00 37.90          
ATOM     78  CG  GLU    14       0.285  82.217 104.182  1.00 43.27          
ATOM     79  CD  GLU    14       0.401  83.730 104.242  1.00 49.49          
ATOM     80  OE1 GLU    14      -0.312  84.383 103.436  1.00 50.70          
ATOM     81  OE2 GLU    14       1.202  84.252 105.086  1.00 47.99          
ATOM     82  N   ARG    15       3.190  79.929 105.620  1.00 34.66          
ATOM     83  CA  ARG    15       4.545  79.657 105.156  1.00 32.82          
ATOM     84  C   ARG    15       4.719  78.171 104.796  1.00 33.56          
ATOM     85  O   ARG    15       5.270  77.825 103.720  1.00 35.21          
ATOM     86  CB  ARG    15       5.543  80.074 106.236  1.00 32.62          
ATOM     87  CG  ARG    15       7.017  79.865 105.857  1.00 31.87          
ATOM     88  CD  ARG    15       7.509  80.625 104.638  1.00 29.69          
ATOM     89  NE  ARG    15       8.983  80.522 104.442  1.00 35.70          
ATOM     90  CZ  ARG    15       9.874  81.336 104.995  1.00 32.27          
ATOM     91  NH1 ARG    15       9.461  82.288 105.810  1.00 33.24          
ATOM     92  NH2 ARG    15      11.158  81.198 104.747  1.00 34.49          
ATOM     93  N   SER    16       4.247  77.296 105.671  1.00 32.39          
ATOM     94  CA  SER    16       4.236  75.836 105.429  1.00 33.38          
ATOM     95  C   SER    16       3.592  75.427 104.104  1.00 33.98          
ATOM     96  O   SER    16       4.169  74.707 103.307  1.00 35.04          
ATOM     97  CB  SER    16       3.496  75.097 106.567  1.00 32.09          
ATOM     98  OG  SER    16       4.105  75.355 107.818  1.00 31.47          
ATOM     99  N   LEU    17       2.360  75.840 103.893  1.00 34.43          
ATOM    100  CA  LEU    17       1.698  75.497 102.645  1.00 34.59          
ATOM    101  C   LEU    17       2.495  76.066 101.447  1.00 34.53          
ATOM    102  O   LEU    17       2.768  75.353 100.484  1.00 33.99          
ATOM    103  CB  LEU    17       0.247  76.017 102.658  1.00 33.43          
ATOM    104  CG  LEU    17      -0.715  75.328 103.634  1.00 34.97          
ATOM    105  CD1 LEU    17      -2.168  75.869 103.470  1.00 31.76          
ATOM    106  CD2 LEU    17      -0.702  73.776 103.492  1.00 35.30          
ATOM    107  N   ASN    18       2.836  77.359 101.490  1.00 35.38          
ATOM    108  CA  ASN    18       3.647  77.938 100.411  1.00 35.68          
ATOM    109  C   ASN    18       4.889  77.081 100.125  1.00 35.98          
ATOM    110  O   ASN    18       5.207  76.800  98.961  1.00 36.78          
ATOM    111  CB  ASN    18       4.075  79.379 100.735  1.00 35.56          
ATOM    112  CG  ASN    18       4.758  80.079  99.542  1.00 33.52          
ATOM    113  OD1 ASN    18       5.854  79.712  99.148  1.00 36.01          
ATOM    114  ND2 ASN    18       4.114  81.071  98.981  1.00 28.69          
ATOM    115  N   GLU    19       5.599  76.674 101.176  1.00 35.82          
ATOM    116  CA  GLU    19       6.877  75.974 100.996  1.00 35.42          
ATOM    117  C   GLU    19       6.634  74.567 100.429  1.00 35.90          
ATOM    118  O   GLU    19       7.410  74.030  99.603  1.00 34.35          
ATOM    119  CB  GLU    19       7.574  75.902 102.342  1.00 35.22          
ATOM    120  CG  GLU    19       8.058  77.265 102.835  1.00 36.63          
ATOM    121  CD  GLU    19       9.467  77.593 102.310  1.00 37.87          
ATOM    122  OE1 GLU    19      10.195  78.413 102.913  1.00 38.05          
ATOM    123  OE2 GLU    19       9.852  77.026 101.273  1.00 38.91          
ATOM    124  N   ILE    20       5.512  73.986 100.845  1.00 35.75          
ATOM    125  CA  ILE    20       5.198  72.621 100.428  1.00 35.97          
ATOM    126  C   ILE    20       4.575  72.590  99.070  1.00 36.23          
ATOM    127  O   ILE    20       4.924  71.749  98.279  1.00 37.91          
ATOM    128  CB  ILE    20       4.297  71.899 101.437  1.00 35.78          
ATOM    129  CG1 ILE    20       5.121  71.650 102.711  1.00 35.25          
ATOM    130  CG2 ILE    20       3.714  70.613 100.811  1.00 32.72          
ATOM    131  CD  ILE    20       4.366  71.207 103.913  1.00 30.90          
ATOM    132  N   ARG    21       3.623  73.472  98.807  1.00 36.48          
ATOM    133  CA  ARG    21       3.145  73.683  97.453  1.00 37.14          
ATOM    134  C   ARG    21       4.323  73.865  96.484  1.00 36.76          
ATOM    135  O   ARG    21       4.411  73.201  95.473  1.00 37.64          
ATOM    136  CB  ARG    21       2.206  74.891  97.385  1.00 36.62          
ATOM    137  CG  ARG    21       0.877  74.622  98.079  1.00 40.39          
ATOM    138  CD  ARG    21      -0.009  75.854  98.182  1.00 44.72          
ATOM    139  NE  ARG    21      -1.222  75.589  98.960  1.00 47.00          
ATOM    140  CZ  ARG    21      -2.113  76.525  99.291  1.00 47.16          
ATOM    141  NH1 ARG    21      -1.920  77.776  98.894  1.00 45.33          
ATOM    142  NH2 ARG    21      -3.183  76.226 100.024  1.00 44.99          
ATOM    143  N   PHE    22       5.261  74.729  96.805  1.00 36.04          
ATOM    144  CA  PHE    22       6.328  74.933  95.849  1.00 35.37          
ATOM    145  C   PHE    22       7.287  73.748  95.748  1.00 35.43          
ATOM    146  O   PHE    22       7.591  73.285  94.661  1.00 35.78          
ATOM    147  CB  PHE    22       7.103  76.205  96.148  1.00 33.77          
ATOM    148  CG  PHE    22       8.146  76.525  95.098  1.00 32.20          
ATOM    149  CD1 PHE    22       7.774  77.157  93.905  1.00 26.76          
ATOM    150  CD2 PHE    22       9.487  76.192  95.298  1.00 24.96          
ATOM    151  CE1 PHE    22       8.695  77.449  92.945  1.00 26.38          
ATOM    152  CE2 PHE    22      10.445  76.491  94.337  1.00 23.72          
ATOM    153  CZ  PHE    22      10.087  77.125  93.193  1.00 26.85          
ATOM    154  N   TRP    23       7.789  73.263  96.863  1.00 35.94          
ATOM    155  CA  TRP    23       8.910  72.293  96.781  1.00 36.37          
ATOM    156  C   TRP    23       8.421  70.881  96.503  1.00 36.04          
ATOM    157  O   TRP    23       9.097  70.098  95.882  1.00 36.16          
ATOM    158  CB  TRP    23       9.760  72.340  98.036  1.00 35.58          
ATOM    159  CG  TRP    23      10.530  73.603  98.205  1.00 38.22          
ATOM    160  CD1 TRP    23      10.253  74.638  99.080  1.00 38.15          
ATOM    161  CD2 TRP    23      11.745  73.976  97.520  1.00 39.83          
ATOM    162  NE1 TRP    23      11.196  75.641  98.944  1.00 39.49          
ATOM    163  CE2 TRP    23      12.134  75.254  98.016  1.00 41.58          
ATOM    164  CE3 TRP    23      12.538  73.362  96.544  1.00 39.67          
ATOM    165  CZ2 TRP    23      13.294  75.917  97.563  1.00 41.60          
ATOM    166  CZ3 TRP    23      13.681  74.028  96.087  1.00 42.06          
ATOM    167  CH2 TRP    23      14.048  75.297  96.598  1.00 41.88          
ATOM    168  N   SER    24       7.211  70.575  96.919  1.00 36.64          
ATOM    169  CA  SER    24       6.650  69.279  96.587  1.00 37.09          
ATOM    170  C   SER    24       6.578  69.151  95.069  1.00 36.28          
ATOM    171  O   SER    24       6.971  68.139  94.487  1.00 38.18          
ATOM    172  CB  SER    24       5.294  69.080  97.270  1.00 36.70          
ATOM    173  OG  SER    24       4.269  69.801  96.600  1.00 39.91          
ATOM    174  N   ARG    25       6.132  70.197  94.399  1.00 35.08          
ATOM    175  CA  ARG    25       6.066  70.154  92.938  1.00 33.29          
ATOM    176  C   ARG    25       7.488  70.014  92.386  1.00 31.67          
ATOM    177  O   ARG    25       7.758  69.274  91.467  1.00 30.37          
ATOM    178  CB  ARG    25       5.370  71.422  92.393  1.00 32.54          
ATOM    179  CG  ARG    25       5.532  71.560  90.904  1.00 30.15          
ATOM    180  CD  ARG    25       4.854  72.771  90.317  1.00 31.77          
ATOM    181  NE  ARG    25       4.757  72.630  88.864  1.00 37.29          
ATOM    182  CZ  ARG    25       4.094  73.463  88.061  1.00 39.83          
ATOM    183  NH1 ARG    25       3.434  74.484  88.572  1.00 40.37          
ATOM    184  NH2 ARG    25       4.087  73.267  86.747  1.00 39.63          
ATOM    185  N   ILE    26       8.424  70.739  92.971  1.00 32.66          
ATOM    186  CA  ILE    26       9.806  70.568  92.570  1.00 31.21          
ATOM    187  C   ILE    26      10.259  69.107  92.688  1.00 32.40          
ATOM    188  O   ILE    26      10.746  68.552  91.716  1.00 33.83          
ATOM    189  CB  ILE    26      10.698  71.552  93.308  1.00 31.06          
ATOM    190  CG1 ILE    26      10.380  72.996  92.852  1.00 28.93          
ATOM    191  CG2 ILE    26      12.162  71.188  93.177  1.00 27.83          
ATOM    192  CD  ILE    26      10.759  73.372  91.467  1.00 26.11          
ATOM    193  N   MET    27      10.085  68.461  93.842  1.00 33.02          
ATOM    194  CA  MET    27      10.621  67.093  94.046  1.00 32.68          
ATOM    195  C   MET    27       9.919  66.141  93.132  1.00 33.22          
ATOM    196  O   MET    27      10.510  65.194  92.626  1.00 34.14          
ATOM    197  CB  MET    27      10.395  66.605  95.480  1.00 33.16          
ATOM    198  CG  MET    27      10.958  67.461  96.560  1.00 32.13          
ATOM    199  SD  MET    27      12.726  67.233  96.767  1.00 33.07          
ATOM    200  CE  MET    27      13.273  68.931  96.755  1.00 30.66          
ATOM    201  N   LYS    28       8.631  66.364  92.935  1.00 32.51          
ATOM    202  CA  LYS    28       7.905  65.516  92.014  1.00 33.06          
ATOM    203  C   LYS    28       8.566  65.606  90.629  1.00 34.43          
ATOM    204  O   LYS    28       8.714  64.586  89.938  1.00 34.63          
ATOM    205  CB  LYS    28       6.411  65.920  91.960  1.00 32.00          
ATOM    206  CG  LYS    28       5.694  65.378  90.792  1.00 33.78          
ATOM    207  CD  LYS    28       4.244  65.926  90.757  1.00 36.27          
ATOM    208  CE  LYS    28       4.075  66.955  89.638  1.00 36.39          
ATOM    209  NZ  LYS    28       3.062  68.013  89.975  1.00 39.01          
ATOM    210  N   GLU    29       8.969  66.817  90.207  1.00 34.94          
ATOM    211  CA  GLU    29       9.528  66.974  88.859  1.00 35.47          
ATOM    212  C   GLU    29      10.932  66.374  88.780  1.00 35.96          
ATOM    213  O   GLU    29      11.260  65.681  87.809  1.00 36.44          
ATOM    214  CB  GLU    29       9.454  68.423  88.391  1.00 35.74          
ATOM    215  CG  GLU    29       7.968  68.918  88.262  1.00 37.91          
ATOM    216  CD  GLU    29       7.837  70.424  87.914  1.00 39.92          
ATOM    217  OE1 GLU    29       6.784  70.804  87.350  1.00 42.17          
ATOM    218  OE2 GLU    29       8.778  71.214  88.197  1.00 40.27          
ATOM    219  N   HSD    30      11.748  66.573  89.807  1.00 35.06          
ATOM    220  CA  HSD    30      13.004  65.803  89.903  1.00 36.03          
ATOM    221  C   HSD    30      12.792  64.322  89.708  1.00 36.88          
ATOM    222  O   HSD    30      13.683  63.663  89.201  1.00 37.05          
ATOM    223  CB  HSD    30      13.686  65.955  91.266  1.00 35.52          
ATOM    224  CG  HSD    30      14.143  67.350  91.553  1.00 37.64          
ATOM    225  ND1 HSD    30      14.497  67.779  92.813  1.00 40.40          
ATOM    226  CD2 HSD    30      14.284  68.416  90.742  1.00 37.37          
ATOM    227  CE1 HSD    30      14.869  69.039  92.754  1.00 40.80          
ATOM    228  NE2 HSD    30      14.731  69.454  91.512  1.00 39.02          
ATOM    229  N   SER    31      11.651  63.780  90.155  1.00 37.18          
ATOM    230  CA  SER    31      11.450  62.324  90.089  1.00 38.80          
ATOM    231  C   SER    31      11.303  61.870  88.632  1.00 39.95          
ATOM    232  O   SER    31      11.711  60.778  88.244  1.00 40.95          
ATOM    233  CB  SER    31      10.203  61.895  90.874  1.00 38.47          
ATOM    234  OG  SER    31      10.294  62.174  92.266  1.00 38.17          
ATOM    235  N   PHE    32      10.702  62.734  87.833  1.00 40.62          
ATOM    236  CA  PHE    32      10.518  62.508  86.411  1.00 40.74          
ATOM    237  C   PHE    32      11.875  62.734  85.701  1.00 40.69          
ATOM    238  O   PHE    32      12.374  61.821  85.051  1.00 41.55          
ATOM    239  CB  PHE    32       9.431  63.448  85.941  1.00 40.05          
ATOM    240  CG  PHE    32       9.279  63.533  84.466  1.00 43.21          
ATOM    241  CD1 PHE    32       8.890  62.445  83.728  1.00 47.75          
ATOM    242  CD2 PHE    32       9.455  64.734  83.805  1.00 44.25          
ATOM    243  CE1 PHE    32       8.717  62.564  82.324  1.00 46.19          
ATOM    244  CE2 PHE    32       9.288  64.846  82.449  1.00 40.56          
ATOM    245  CZ  PHE    32       8.929  63.766  81.704  1.00 41.09          
ATOM    246  N   PHE    33      12.490  63.904  85.866  1.00 39.49          
ATOM    247  CA  PHE    33      13.794  64.196  85.247  1.00 39.20          
ATOM    248  C   PHE    33      14.807  63.091  85.504  1.00 38.70          
ATOM    249  O   PHE    33      15.528  62.672  84.589  1.00 38.82          
ATOM    250  CB  PHE    33      14.404  65.496  85.775  1.00 38.63          
ATOM    251  CG  PHE    33      13.501  66.720  85.647  1.00 40.06          
ATOM    252  CD1 PHE    33      12.638  66.874  84.549  1.00 40.47          
ATOM    253  CD2 PHE    33      13.535  67.728  86.614  1.00 38.75          
ATOM    254  CE1 PHE    33      11.851  67.985  84.435  1.00 38.64          
ATOM    255  CE2 PHE    33      12.718  68.865  86.503  1.00 38.04          
ATOM    256  CZ  PHE    33      11.891  68.995  85.433  1.00 38.31          
ATOM    257  N   LEU    34      14.877  62.613  86.732  1.00 38.01          
ATOM    258  CA  LEU    34      15.904  61.615  87.061  1.00 39.44          
ATOM    259  C   LEU    34      15.596  60.344  86.342  1.00 39.73          
ATOM    260  O   LEU    34      16.526  59.605  85.947  1.00 39.90          
ATOM    261  CB  LEU    34      16.029  61.316  88.552  1.00 38.84          
ATOM    262  CG  LEU    34      16.682  62.440  89.346  1.00 39.87          
ATOM    263  CD1 LEU    34      16.087  62.494  90.748  1.00 41.34          
ATOM    264  CD2 LEU    34      18.200  62.310  89.382  1.00 42.23          
ATOM    265  N   ARG    35      14.301  60.098  86.142  1.00 38.93          
ATOM    266  CA  ARG    35      13.929  58.832  85.647  1.00 38.75          
ATOM    267  C   ARG    35      14.392  58.807  84.232  1.00 38.69          
ATOM    268  O   ARG    35      14.776  57.737  83.746  1.00 38.03          
ATOM    269  CB  ARG    35      12.414  58.549  85.735  1.00 39.76          
ATOM    270  CG  ARG    35      11.962  57.637  84.573  1.00 40.12          
ATOM    271  CD  ARG    35      10.646  56.994  84.753  1.00 41.13          
ATOM    272  NE  ARG    35       9.551  57.873  84.375  1.00 40.50          
ATOM    273  CZ  ARG    35       9.216  58.203  83.144  1.00 40.40          
ATOM    274  NH1 ARG    35       9.875  57.724  82.104  1.00 39.95          
ATOM    275  NH2 ARG    35       8.193  59.017  82.957  1.00 42.97          
ATOM    276  N   LEU    36      14.362  59.981  83.584  1.00 38.82          
ATOM    277  CA  LEU    36      14.525  60.102  82.112  1.00 39.94          
ATOM    278  C   LEU    36      15.944  59.769  81.728  1.00 40.98          
ATOM    279  O   LEU    36      16.204  59.338  80.596  1.00 42.05          
ATOM    280  CB  LEU    36      14.122  61.488  81.561  1.00 39.19          
ATOM    281  CG  LEU    36      12.608  61.724  81.282  1.00 39.98          
ATOM    282  CD1 LEU    36      12.288  63.135  80.789  1.00 40.32          
ATOM    283  CD2 LEU    36      12.056  60.776  80.272  1.00 39.23          
ATOM    284  N   GLY    37      16.844  59.937  82.696  1.00 41.32          
ATOM    285  CA  GLY    37      18.247  59.683  82.507  1.00 42.27          
ATOM    286  C   GLY    37      18.702  58.289  82.881  1.00 42.43          
ATOM    287  O   GLY    37      19.850  57.958  82.675  1.00 42.90          
ATOM    288  N   PHE    38      17.807  57.478  83.425  1.00 42.66          
ATOM    289  CA  PHE    38      18.083  56.056  83.696  1.00 43.61          
ATOM    290  C   PHE    38      18.151  55.200  82.421  1.00 44.11          
ATOM    291  O   PHE    38      17.408  55.438  81.484  1.00 44.99          
ATOM    292  CB  PHE    38      16.974  55.478  84.591  1.00 43.02          
ATOM    293  CG  PHE    38      16.959  56.035  85.972  1.00 42.10          
ATOM    294  CD1 PHE    38      18.125  56.533  86.542  1.00 43.15          
ATOM    295  CD2 PHE    38      15.792  56.016  86.723  1.00 40.97          
ATOM    296  CE1 PHE    38      18.117  57.042  87.849  1.00 43.02          
ATOM    297  CE2 PHE    38      15.755  56.510  88.000  1.00 40.74          
ATOM    298  CZ  PHE    38      16.916  57.016  88.582  1.00 43.01          
ATOM    299  N   ARG    39      19.005  54.187  82.385  1.00 45.53          
ATOM    300  CA  ARG    39      18.996  53.232  81.259  1.00 46.05          
ATOM    301  C   ARG    39      17.692  52.496  81.290  1.00 47.38          
ATOM    302  O   ARG    39      17.115  52.335  82.351  1.00 48.36          
ATOM    303  CB  ARG    39      20.134  52.227  81.396  1.00 45.42          
ATOM    304  CG  ARG    39      21.464  52.918  81.508  1.00 45.62          
ATOM    305  CD  ARG    39      22.576  51.965  81.546  1.00 44.51          
ATOM    306  NE  ARG    39      22.373  51.016  82.629  1.00 47.91          
ATOM    307  CZ  ARG    39      23.349  50.318  83.221  1.00 47.81          
ATOM    308  NH1 ARG    39      24.634  50.471  82.860  1.00 45.48          
ATOM    309  NH2 ARG    39      23.033  49.467  84.182  1.00 45.87          
ATOM    310  N   CYS    40      17.226  52.001  80.151  1.00 49.02          
ATOM    311  CA  CYS    40      15.914  51.385  80.108  1.00 50.99          
ATOM    312  C   CYS    40      15.869  50.090  80.867  1.00 51.63          
ATOM    313  O   CYS    40      14.788  49.569  81.146  1.00 52.25          
ATOM    314  CB  CYS    40      15.491  51.112  78.672  1.00 51.18          
ATOM    315  SG  CYS    40      14.999  52.593  77.756  1.00 55.43          
ATOM    316  N   GLU    41      17.033  49.550  81.196  1.00 52.59          
ATOM    317  CA  GLU    41      17.078  48.236  81.801  1.00 54.26          
ATOM    318  C   GLU    41      17.074  48.301  83.329  1.00 54.18          
ATOM    319  O   GLU    41      16.887  47.286  83.991  1.00 54.61          
ATOM    320  CB  GLU    41      18.266  47.431  81.248  1.00 54.97          
ATOM    321  CG  GLU    41      19.624  47.597  81.960  1.00 59.17          
ATOM    322  CD  GLU    41      20.769  47.818  80.973  1.00 65.01          
ATOM    323  OE1 GLU    41      20.638  48.743  80.129  1.00 67.22          
ATOM    324  OE2 GLU    41      21.791  47.083  81.044  1.00 67.27          
ATOM    325  N   ASP    42      17.275  49.506  83.874  1.00 54.20          
ATOM    326  CA  ASP    42      17.301  49.761  85.320  1.00 53.48          
ATOM    327  C   ASP    42      15.905  49.897  85.866  1.00 53.47          
ATOM    328  O   ASP    42      15.547  50.965  86.320  1.00 53.73          
ATOM    329  CB  ASP    42      18.008  51.082  85.590  1.00 53.00          
ATOM    330  CG  ASP    42      19.430  51.089  85.081  1.00 52.75          
ATOM    331  OD1 ASP    42      20.143  50.091  85.350  1.00 51.50          
ATOM    332  OD2 ASP    42      19.829  52.081  84.415  1.00 51.91          
ATOM    333  N   THR    43      15.101  48.847  85.815  1.00 53.15          
ATOM    334  CA  THR    43      13.717  48.988  86.251  1.00 53.39          
ATOM    335  C   THR    43      13.522  49.161  87.756  1.00 52.62          
ATOM    336  O   THR    43      12.447  49.573  88.168  1.00 52.51          
ATOM    337  CB  THR    43      12.803  47.834  85.787  1.00 53.85          
ATOM    338  OG1 THR    43      13.131  46.634  86.499  1.00 54.42          
ATOM    339  CG2 THR    43      12.920  47.614  84.266  1.00 55.52          
ATOM    340  N   GLN    44      14.518  48.832  88.576  1.00 51.98          
ATOM    341  CA  GLN    44      14.321  49.023  90.015  1.00 52.24          
ATOM    342  C   GLN    44      14.231  50.512  90.244  1.00 50.10          
ATOM    343  O   GLN    44      13.197  51.007  90.697  1.00 50.99          
ATOM    344  CB  GLN    44      15.453  48.443  90.874  1.00 53.28          
ATOM    345  CG  GLN    44      15.523  46.940  90.913  1.00 59.60          
ATOM    346  CD  GLN    44      14.226  46.298  91.432  1.00 67.06          
ATOM    347  OE1 GLN    44      13.526  45.607  90.682  1.00 68.99          
ATOM    348  NE2 GLN    44      13.897  46.545  92.715  1.00 69.95          
ATOM    349  N   LEU    45      15.323  51.203  89.911  1.00 47.47          
ATOM    350  CA  LEU    45      15.400  52.683  89.820  1.00 45.11          
ATOM    351  C   LEU    45      14.191  53.345  89.139  1.00 43.33          
ATOM    352  O   LEU    45      13.562  54.191  89.713  1.00 42.75          
ATOM    353  CB  LEU    45      16.679  53.083  89.108  1.00 44.04          
ATOM    354  CG  LEU    45      17.951  52.526  89.754  1.00 44.35          
ATOM    355  CD1 LEU    45      19.176  52.984  88.955  1.00 42.64          
ATOM    356  CD2 LEU    45      18.089  52.885  91.257  1.00 43.40          
ATOM    357  N   ILE    46      13.841  52.912  87.943  1.00 42.71          
ATOM    358  CA  ILE    46      12.704  53.518  87.211  1.00 42.89          
ATOM    359  C   ILE    46      11.428  53.480  88.047  1.00 42.13          
ATOM    360  O   ILE    46      10.714  54.481  88.157  1.00 40.45          
ATOM    361  CB  ILE    46      12.479  52.881  85.823  1.00 42.88          
ATOM    362  CG1 ILE    46      13.654  53.227  84.880  1.00 43.54          
ATOM    363  CG2 ILE    46      11.146  53.339  85.218  1.00 44.11          
ATOM    364  CD  ILE    46      13.698  52.387  83.549  1.00 40.47          
ATOM    365  N   GLU    47      11.200  52.324  88.678  1.00 42.13          
ATOM    366  CA  GLU    47      10.087  52.118  89.558  1.00 42.12          
ATOM    367  C   GLU    47      10.238  52.946  90.814  1.00 40.86          
ATOM    368  O   GLU    47       9.286  53.552  91.242  1.00 40.08          
ATOM    369  CB  GLU    47       9.911  50.621  89.892  1.00 43.39          
ATOM    370  CG  GLU    47       9.087  49.805  88.849  1.00 48.38          
ATOM    371  CD  GLU    47       9.150  48.240  89.056  1.00 57.33          
ATOM    372  OE1 GLU    47       9.853  47.737  89.991  1.00 59.44          
ATOM    373  OE2 GLU    47       8.486  47.507  88.267  1.00 59.70          
ATOM    374  N   GLU    48      11.429  52.997  91.409  1.00 40.64          
ATOM    375  CA  GLU    48      11.564  53.762  92.631  1.00 41.19          
ATOM    376  C   GLU    48      11.344  55.274  92.401  1.00 41.68          
ATOM    377  O   GLU    48      10.761  55.960  93.246  1.00 42.88          
ATOM    378  CB  GLU    48      12.880  53.456  93.319  1.00 41.19          
ATOM    379  CG  GLU    48      12.915  53.941  94.754  1.00 45.25          
ATOM    380  CD  GLU    48      14.256  53.628  95.433  1.00 51.59          
ATOM    381  OE1 GLU    48      15.046  52.844  94.841  1.00 52.87          
ATOM    382  OE2 GLU    48      14.515  54.157  96.551  1.00 53.21          
ATOM    383  N   ALA    49      11.792  55.777  91.246  1.00 40.83          
ATOM    384  CA  ALA    49      11.556  57.138  90.835  1.00 40.14          
ATOM    385  C   ALA    49      10.078  57.373  90.587  1.00 40.41          
ATOM    386  O   ALA    49       9.571  58.452  90.859  1.00 39.44          
ATOM    387  CB  ALA    49      12.323  57.433  89.562  1.00 39.44          
ATOM    388  N   ASN    50       9.378  56.396  90.037  1.00 41.22          
ATOM    389  CA  ASN    50       7.970  56.648  89.718  1.00 43.04          
ATOM    390  C   ASN    50       7.158  56.760  91.003  1.00 43.93          
ATOM    391  O   ASN    50       6.110  57.429  91.054  1.00 44.09          
ATOM    392  CB  ASN    50       7.408  55.565  88.823  1.00 42.41          
ATOM    393  CG  ASN    50       8.063  55.552  87.464  1.00 43.92          
ATOM    394  OD1 ASN    50       8.232  56.592  86.813  1.00 42.62          
ATOM    395  ND2 ASN    50       8.459  54.372  87.032  1.00 44.19          
ATOM    396  N   GLN    51       7.673  56.103  92.040  1.00 44.83          
ATOM    397  CA  GLN    51       7.004  56.085  93.312  1.00 45.78          
ATOM    398  C   GLN    51       7.220  57.421  93.968  1.00 44.58          
ATOM    399  O   GLN    51       6.270  58.056  94.372  1.00 45.10          
ATOM    400  CB  GLN    51       7.512  54.933  94.175  1.00 47.16          
ATOM    401  CG  GLN    51       6.934  53.592  93.740  1.00 52.25          
ATOM    402  CD  GLN    51       6.762  52.653  94.904  1.00 62.25          
ATOM    403  OE1 GLN    51       7.751  52.297  95.579  1.00 65.94          
ATOM    404  NE2 GLN    51       5.496  52.241  95.170  1.00 63.76          
ATOM    405  N   PHE    52       8.451  57.893  94.009  1.00 42.97          
ATOM    406  CA  PHE    52       8.659  59.246  94.496  1.00 41.96          
ATOM    407  C   PHE    52       7.828  60.279  93.679  1.00 42.31          
ATOM    408  O   PHE    52       7.363  61.301  94.209  1.00 43.05          
ATOM    409  CB  PHE    52      10.152  59.560  94.508  1.00 40.95          
ATOM    410  CG  PHE    52      10.857  59.000  95.711  1.00 39.04          
ATOM    411  CD1 PHE    52      10.545  59.465  96.984  1.00 36.10          
ATOM    412  CD2 PHE    52      11.785  57.973  95.585  1.00 37.82          
ATOM    413  CE1 PHE    52      11.190  58.969  98.097  1.00 37.80          
ATOM    414  CE2 PHE    52      12.428  57.434  96.716  1.00 34.76          
ATOM    415  CZ  PHE    52      12.131  57.921  97.967  1.00 35.31          
ATOM    416  N   TYR    53       7.615  60.017  92.395  1.00 41.24          
ATOM    417  CA  TYR    53       6.934  61.004  91.605  1.00 41.48          
ATOM    418  C   TYR    53       5.510  61.041  92.162  1.00 41.92          
ATOM    419  O   TYR    53       4.938  62.103  92.396  1.00 42.45          
ATOM    420  CB  TYR    53       6.924  60.632  90.112  1.00 40.77          
ATOM    421  CG  TYR    53       6.034  61.578  89.285  1.00 39.51          
ATOM    422  CD1 TYR    53       6.602  62.620  88.562  1.00 38.34          
ATOM    423  CD2 TYR    53       4.664  61.426  89.237  1.00 36.09          
ATOM    424  CE1 TYR    53       5.866  63.459  87.830  1.00 38.34          
ATOM    425  CE2 TYR    53       3.874  62.286  88.469  1.00 35.85          
ATOM    426  CZ  TYR    53       4.496  63.315  87.765  1.00 39.07          
ATOM    427  OH  TYR    53       3.802  64.269  87.028  1.00 37.42          
ATOM    428  N   ARG    54       4.968  59.857  92.403  1.00 42.05          
ATOM    429  CA  ARG    54       3.615  59.672  92.921  1.00 42.23          
ATOM    430  C   ARG    54       3.415  60.237  94.371  1.00 41.66          
ATOM    431  O   ARG    54       2.357  60.777  94.712  1.00 41.57          
ATOM    432  CB  ARG    54       3.254  58.180  92.804  1.00 42.21          
ATOM    433  CG  ARG    54       2.953  57.763  91.325  1.00 45.21          
ATOM    434  CD  ARG    54       1.545  58.195  90.935  1.00 49.29          
ATOM    435  NE  ARG    54       1.397  58.842  89.618  1.00 56.82          
ATOM    436  CZ  ARG    54       0.794  58.306  88.547  1.00 57.97          
ATOM    437  NH1 ARG    54       0.296  57.068  88.600  1.00 59.94          
ATOM    438  NH2 ARG    54       0.697  59.004  87.407  1.00 57.22          
ATOM    439  N   LEU    55       4.427  60.112  95.205  1.00 40.48          
ATOM    440  CA  LEU    55       4.336  60.594  96.545  1.00 40.87          
ATOM    441  C   LEU    55       4.167  62.114  96.547  1.00 41.21          
ATOM    442  O   LEU    55       3.151  62.646  97.068  1.00 42.66          
ATOM    443  CB  LEU    55       5.611  60.233  97.322  1.00 40.39          
ATOM    444  CG  LEU    55       5.730  60.632  98.797  1.00 38.36          
ATOM    445  CD1 LEU    55       4.505  60.194  99.592  1.00 33.47          
ATOM    446  CD2 LEU    55       6.975  60.051  99.402  1.00 33.79          
ATOM    447  N   PHE    56       5.162  62.805  95.990  1.00 39.58          
ATOM    448  CA  PHE    56       5.112  64.281  95.903  1.00 38.01          
ATOM    449  C   PHE    56       3.938  64.862  95.108  1.00 37.14          
ATOM    450  O   PHE    56       3.411  65.886  95.458  1.00 36.83          
ATOM    451  CB  PHE    56       6.476  64.812  95.499  1.00 37.38          
ATOM    452  CG  PHE    56       7.507  64.636  96.598  1.00 36.28          
ATOM    453  CD1 PHE    56       7.471  65.464  97.728  1.00 36.42          
ATOM    454  CD2 PHE    56       8.401  63.574  96.583  1.00 31.77          
ATOM    455  CE1 PHE    56       8.391  65.293  98.781  1.00 35.08          
ATOM    456  CE2 PHE    56       9.314  63.418  97.613  1.00 34.56          
ATOM    457  CZ  PHE    56       9.308  64.280  98.720  1.00 31.43          
ATOM    458  N   GLU    57       3.524  64.194  94.048  1.00 37.18          
ATOM    459  CA  GLU    57       2.239  64.512  93.379  1.00 37.48          
ATOM    460  C   GLU    57       1.112  64.480  94.410  1.00 37.06          
ATOM    461  O   GLU    57       0.261  65.375  94.450  1.00 37.81          
ATOM    462  CB  GLU    57       1.948  63.486  92.259  1.00 36.91          
ATOM    463  CG  GLU    57       0.922  63.952  91.210  1.00 40.84          
ATOM    464  CD  GLU    57       0.375  62.827  90.266  1.00 42.60          
ATOM    465  OE1 GLU    57       0.116  61.662  90.693  1.00 44.29          
ATOM    466  OE2 GLU    57       0.174  63.131  89.075  1.00 45.92          
ATOM    467  N   HSD    58       1.109  63.468  95.278  1.00 36.58          
ATOM    468  CA  HSD    58       0.028  63.336  96.248  1.00 37.40          
ATOM    469  C   HSD    58       0.053  64.485  97.284  1.00 37.17          
ATOM    470  O   HSD    58      -0.945  65.200  97.511  1.00 36.83          
ATOM    471  CB  HSD    58       0.118  61.975  96.922  1.00 37.41          
ATOM    472  CG  HSD    58      -0.999  61.692  97.885  1.00 39.68          
ATOM    473  ND1 HSD    58      -2.337  61.795  97.534  1.00 41.03          
ATOM    474  CD2 HSD    58      -0.975  61.279  99.179  1.00 37.07          
ATOM    475  CE1 HSD    58      -3.087  61.451  98.570  1.00 40.06          
ATOM    476  NE2 HSD    58      -2.287  61.138  99.579  1.00 41.35          
ATOM    477  N   ILE    59       1.218  64.648  97.885  1.00 36.83          
ATOM    478  CA  ILE    59       1.505  65.760  98.777  1.00 36.63          
ATOM    479  C   ILE    59       1.203  67.129  98.215  1.00 37.71          
ATOM    480  O   ILE    59       0.723  68.018  98.933  1.00 38.83          
ATOM    481  CB  ILE    59       2.985  65.771  99.123  1.00 35.68          
ATOM    482  CG1 ILE    59       3.252  64.616 100.078  1.00 33.34          
ATOM    483  CG2 ILE    59       3.340  67.115  99.697  1.00 33.94          
ATOM    484  CD  ILE    59       4.684  64.285 100.221  1.00 34.71          
ATOM    485  N   GLU    60       1.518  67.332  96.945  1.00 38.54          
ATOM    486  CA  GLU    60       1.225  68.608  96.310  1.00 39.07          
ATOM    487  C   GLU    60      -0.306  68.811  96.254  1.00 40.30          
ATOM    488  O   GLU    60      -0.781  69.914  96.488  1.00 41.47          
ATOM    489  CB  GLU    60       1.845  68.646  94.905  1.00 38.47          
ATOM    490  CG  GLU    60       1.549  69.916  94.083  1.00 37.93          
ATOM    491  CD  GLU    60       2.010  69.819  92.590  1.00 40.88          
ATOM    492  OE1 GLU    60       2.262  68.689  92.048  1.00 39.64          
ATOM    493  OE2 GLU    60       2.126  70.891  91.953  1.00 40.93          
ATOM    494  N   GLN    61      -1.076  67.776  95.926  1.00 40.80          
ATOM    495  CA  GLN    61      -2.545  67.925  95.869  1.00 42.83          
ATOM    496  C   GLN    61      -3.140  68.196  97.251  1.00 43.75          
ATOM    497  O   GLN    61      -4.182  68.810  97.370  1.00 44.46          
ATOM    498  CB  GLN    61      -3.232  66.694  95.267  1.00 42.13          
ATOM    499  N   ILE    62      -2.461  67.751  98.299  1.00 44.37          
ATOM    500  CA  ILE    62      -3.020  67.901  99.614  1.00 44.43          
ATOM    501  C   ILE    62      -2.653  69.261 100.131  1.00 45.04          
ATOM    502  O   ILE    62      -3.449  69.911 100.766  1.00 44.87          
ATOM    503  CB  ILE    62      -2.462  66.890 100.550  1.00 44.85          
ATOM    504  CG1 ILE    62      -2.938  65.468 100.165  1.00 44.74          
ATOM    505  CG2 ILE    62      -2.838  67.273 101.956  1.00 44.70          
ATOM    506  CD  ILE    62      -2.075  64.362 100.789  1.00 43.48          
ATOM    507  N   ALA    63      -1.421  69.685  99.860  1.00 45.62          
ATOM    508  CA  ALA    63      -0.995  71.034 100.214  1.00 45.76          
ATOM    509  C   ALA    63      -1.954  72.041  99.596  1.00 45.84          
ATOM    510  O   ALA    63      -2.299  73.044 100.204  1.00 45.77          
ATOM    511  CB  ALA    63       0.438  71.291  99.771  1.00 44.84          
ATOM    512  N   HSD    64      -2.409  71.746  98.391  1.00 46.80          
ATOM    513  CA  HSD    64      -3.275  72.659  97.662  1.00 47.53          
ATOM    514  C   HSD    64      -4.724  72.610  98.125  1.00 48.74          
ATOM    515  O   HSD    64      -5.512  73.476  97.713  1.00 48.95          
ATOM    516  CB  HSD    64      -3.216  72.380  96.163  1.00 47.03          
ATOM    517  CG  HSD    64      -2.186  73.185  95.450  1.00 46.29          
ATOM    518  ND1 HSD    64      -2.379  74.509  95.107  1.00 44.50          
ATOM    519  CD2 HSD    64      -0.939  72.864  95.048  1.00 44.12          
ATOM    520  CE1 HSD    64      -1.301  74.954  94.489  1.00 46.89          
ATOM    521  NE2 HSD    64      -0.407  73.980  94.456  1.00 44.85          
ATOM    522  N   SER    65      -5.054  71.610  98.962  1.00 49.26          
ATOM    523  CA  SER    65      -6.411  71.412  99.483  1.00 49.99          
ATOM    524  C   SER    65      -6.530  72.090 100.820  1.00 50.98          
ATOM    525  O   SER    65      -7.635  72.393 101.276  1.00 51.69          
ATOM    526  CB  SER    65      -6.703  69.919  99.689  1.00 50.37          
ATOM    527  OG  SER    65      -6.174  69.417 100.929  1.00 49.15          
ATOM    528  N   TYR    66      -5.389  72.273 101.481  1.00 50.96          
ATOM    529  CA  TYR    66      -5.359  72.926 102.768  1.00 51.41          
ATOM    530  C   TYR    66      -5.411  74.446 102.519  1.00 52.60          
ATOM    531  O   TYR    66      -5.177  74.918 101.391  1.00 51.59          
ATOM    532  CB  TYR    66      -4.101  72.541 103.556  1.00 51.28          
ATOM    533  CG  TYR    66      -4.048  71.115 104.117  1.00 51.37          
ATOM    534  CD1 TYR    66      -5.195  70.336 104.290  1.00 51.02          
ATOM    535  CD2 TYR    66      -2.850  70.567 104.515  1.00 50.70          
ATOM    536  CE1 TYR    66      -5.120  69.042 104.820  1.00 48.58          
ATOM    537  CE2 TYR    66      -2.771  69.276 105.051  1.00 49.33          
ATOM    538  CZ  TYR    66      -3.903  68.522 105.207  1.00 49.63          
ATOM    539  OH  TYR    66      -3.780  67.241 105.748  1.00 47.18          
ATOM    540  N   THR    67      -5.761  75.197 103.566  1.00 53.63          
ATOM    541  CA  THR    67      -5.943  76.626 103.458  1.00 54.72          
ATOM    542  C   THR    67      -5.281  77.232 104.659  1.00 54.33          
ATOM    543  O   THR    67      -4.717  76.515 105.457  1.00 54.74          
ATOM    544  CB  THR    67      -7.439  77.016 103.441  1.00 55.25          
ATOM    545  OG1 THR    67      -8.006  76.816 104.747  1.00 57.97          
ATOM    546  CG2 THR    67      -8.197  76.163 102.443  1.00 56.19          
ATOM    547  N   ASN    68      -5.302  78.554 104.771  1.00 54.86          
ATOM    548  CA  ASN    68      -4.676  79.218 105.894  1.00 55.08          
ATOM    549  C   ASN    68      -5.503  78.949 107.148  1.00 55.48          
ATOM    550  O   ASN    68      -4.993  79.087 108.272  1.00 56.19          
ATOM    551  CB  ASN    68      -4.524  80.712 105.639  1.00 55.48          
ATOM    552  CG  ASN    68      -3.440  81.042 104.574  1.00 58.55          
ATOM    553  OD1 ASN    68      -2.858  80.145 103.921  1.00 58.64          
ATOM    554  ND2 ASN    68      -3.169  82.349 104.400  1.00 59.36          
ATOM    555  N   GLU    69      -6.754  78.513 106.961  1.00 54.85          
ATOM    556  CA  GLU    69      -7.657  78.254 108.081  1.00 55.71          
ATOM    557  C   GLU    69      -7.535  76.850 108.661  1.00 54.91          
ATOM    558  O   GLU    69      -8.184  76.528 109.649  1.00 55.07          
ATOM    559  CB  GLU    69      -9.128  78.489 107.673  1.00 56.48          
ATOM    560  CG  GLU    69      -9.704  79.920 107.865  1.00 59.10          
ATOM    561  CD  GLU    69     -11.245  79.983 107.592  1.00 64.49          
ATOM    562  OE1 GLU    69     -11.870  78.907 107.354  1.00 64.90          
ATOM    563  OE2 GLU    69     -11.833  81.098 107.615  1.00 64.52          
ATOM    564  N   THR    70      -6.725  76.004 108.047  1.00 54.38          
ATOM    565  CA  THR    70      -6.535  74.633 108.531  1.00 53.86          
ATOM    566  C   THR    70      -5.871  74.547 109.925  1.00 54.35          
ATOM    567  O   THR    70      -5.033  75.379 110.264  1.00 54.66          
ATOM    568  CB  THR    70      -5.690  73.866 107.532  1.00 53.50          
ATOM    569  OG1 THR    70      -6.415  73.750 106.309  1.00 50.67          
ATOM    570  CG2 THR    70      -5.323  72.492 108.067  1.00 53.35          
ATOM    571  N   ASP    71      -6.242  73.543 110.728  1.00 54.79          
ATOM    572  CA  ASP    71      -5.744  73.425 112.112  1.00 54.45          
ATOM    573  C   ASP    71      -4.217  73.232 112.147  1.00 54.12          
ATOM    574  O   ASP    71      -3.659  72.301 111.558  1.00 54.01          
ATOM    575  CB  ASP    71      -6.528  72.344 112.886  1.00 55.08          
ATOM    576  CG  ASP    71      -5.834  71.875 114.212  1.00 58.00          
ATOM    577  OD1 ASP    71      -5.151  72.662 114.896  1.00 60.02          
ATOM    578  OD2 ASP    71      -6.002  70.686 114.605  1.00 61.15          
ATOM    579  N   PRO    72      -3.532  74.149 112.837  1.00 53.70          
ATOM    580  CA  PRO    72      -2.100  74.180 112.978  1.00 53.03          
ATOM    581  C   PRO    72      -1.539  72.875 113.461  1.00 52.68          
ATOM    582  O   PRO    72      -0.342  72.656 113.376  1.00 52.57          
ATOM    583  CB  PRO    72      -1.891  75.230 114.066  1.00 53.55          
ATOM    584  CG  PRO    72      -3.038  76.166 113.886  1.00 53.33          
ATOM    585  CD  PRO    72      -4.180  75.308 113.480  1.00 53.48          
ATOM    586  N   GLU    73      -2.390  72.022 114.009  1.00 52.53          
ATOM    587  CA  GLU    73      -1.929  70.735 114.459  1.00 51.53          
ATOM    588  C   GLU    73      -1.884  69.780 113.280  1.00 50.48          
ATOM    589  O   GLU    73      -0.930  69.029 113.127  1.00 49.54          
ATOM    590  CB  GLU    73      -2.774  70.240 115.629  1.00 52.06          
ATOM    591  CG  GLU    73      -2.546  71.080 116.900  1.00 55.18          
ATOM    592  CD  GLU    73      -1.095  70.993 117.414  1.00 58.25          
ATOM    593  OE1 GLU    73      -0.562  69.853 117.470  1.00 56.20          
ATOM    594  OE2 GLU    73      -0.499  72.065 117.754  1.00 59.20          
ATOM    595  N   GLN    74      -2.882  69.850 112.413  1.00 49.96          
ATOM    596  CA  GLN    74      -2.821  69.084 111.193  1.00 50.50          
ATOM    597  C   GLN    74      -1.514  69.451 110.424  1.00 49.02          
ATOM    598  O   GLN    74      -0.651  68.599 110.197  1.00 48.70          
ATOM    599  CB  GLN    74      -4.087  69.329 110.362  1.00 52.00          
ATOM    600  CG  GLN    74      -4.418  68.191 109.395  1.00 56.69          
ATOM    601  CD  GLN    74      -3.714  66.863 109.777  1.00 63.42          
ATOM    602  OE1 GLN    74      -4.088  66.183 110.764  1.00 65.44          
ATOM    603  NE2 GLN    74      -2.698  66.488 108.982  1.00 63.31          
ATOM    604  N   ILE    75      -1.379  70.719 110.055  1.00 46.94          
ATOM    605  CA  ILE    75      -0.188  71.235 109.377  1.00 45.61          
ATOM    606  C   ILE    75       1.111  70.773 110.010  1.00 44.93          
ATOM    607  O   ILE    75       2.065  70.456 109.325  1.00 44.60          
ATOM    608  CB  ILE    75      -0.165  72.764 109.444  1.00 45.76          
ATOM    609  CG1 ILE    75      -1.349  73.302 108.672  1.00 44.92          
ATOM    610  CG2 ILE    75       1.165  73.324 108.944  1.00 43.78          
ATOM    611  CD  ILE    75      -1.533  72.582 107.383  1.00 47.68          
ATOM    612  N   LYS    76       1.157  70.765 111.324  1.00 44.04          
ATOM    613  CA  LYS    76       2.367  70.381 111.989  1.00 44.75          
ATOM    614  C   LYS    76       2.695  68.913 111.722  1.00 44.13          
ATOM    615  O   LYS    76       3.860  68.580 111.544  1.00 43.10          
ATOM    616  CB  LYS    76       2.285  70.697 113.482  1.00 45.26          
ATOM    617  CG  LYS    76       3.625  70.597 114.200  1.00 47.39          
ATOM    618  CD  LYS    76       3.432  70.562 115.703  1.00 51.24          
ATOM    619  CE  LYS    76       4.655  69.927 116.408  1.00 55.63          
ATOM    620  NZ  LYS    76       5.822  70.861 116.600  1.00 55.36          
ATOM    621  N   ARG    77       1.681  68.051 111.686  1.00 43.67          
ATOM    622  CA  ARG    77       1.893  66.614 111.382  1.00 44.68          
ATOM    623  C   ARG    77       2.223  66.382 109.890  1.00 44.01          
ATOM    624  O   ARG    77       3.053  65.536 109.528  1.00 44.89          
ATOM    625  CB  ARG    77       0.655  65.770 111.746  1.00 45.09          
ATOM    626  CG  ARG    77       0.415  65.520 113.253  1.00 49.87          
ATOM    627  CD  ARG    77      -0.719  64.496 113.553  1.00 54.34          
ATOM    628  NE  ARG    77      -2.018  64.854 112.964  1.00 58.76          
ATOM    629  CZ  ARG    77      -2.944  65.617 113.545  1.00 59.57          
ATOM    630  NH1 ARG    77      -2.737  66.118 114.769  1.00 59.35          
ATOM    631  NH2 ARG    77      -4.088  65.872 112.902  1.00 59.46          
ATOM    632  N   PHE    78       1.514  67.103 109.039  1.00 42.94          
ATOM    633  CA  PHE    78       1.760  67.134 107.625  1.00 42.32          
ATOM    634  C   PHE    78       3.216  67.505 107.363  1.00 41.94          
ATOM    635  O   PHE    78       3.888  66.830 106.638  1.00 42.08          
ATOM    636  CB  PHE    78       0.810  68.157 107.025  1.00 41.97          
ATOM    637  CG  PHE    78       0.777  68.167 105.532  1.00 41.83          
ATOM    638  CD1 PHE    78       0.750  66.971 104.800  1.00 40.31          
ATOM    639  CD2 PHE    78       0.715  69.373 104.849  1.00 38.91          
ATOM    640  CE1 PHE    78       0.701  66.991 103.424  1.00 38.27          
ATOM    641  CE2 PHE    78       0.647  69.398 103.472  1.00 37.94          
ATOM    642  CZ  PHE    78       0.661  68.219 102.761  1.00 38.60          
ATOM    643  N   ASN    79       3.713  68.548 108.003  1.00 42.03          
ATOM    644  CA  ASN    79       5.086  68.971 107.811  1.00 42.77          
ATOM    645  C   ASN    79       6.072  67.887 108.137  1.00 43.29          
ATOM    646  O   ASN    79       7.072  67.711 107.428  1.00 43.64          
ATOM    647  CB  ASN    79       5.427  70.166 108.706  1.00 43.32          
ATOM    648  CG  ASN    79       4.881  71.468 108.172  1.00 42.94          
ATOM    649  OD1 ASN    79       4.304  71.497 107.097  1.00 42.62          
ATOM    650  ND2 ASN    79       5.044  72.549 108.939  1.00 42.78          
ATOM    651  N   ALA    80       5.825  67.190 109.247  1.00 43.68          
ATOM    652  CA  ALA    80       6.743  66.131 109.700  1.00 42.86          
ATOM    653  C   ALA    80       6.701  64.879 108.792  1.00 42.78          
ATOM    654  O   ALA    80       7.757  64.224 108.595  1.00 42.22          
ATOM    655  CB  ALA    80       6.481  65.773 111.146  1.00 43.19          
ATOM    656  N   GLU    81       5.516  64.553 108.261  1.00 41.62          
ATOM    657  CA  GLU    81       5.401  63.586 107.160  1.00 43.34          
ATOM    658  C   GLU    81       6.166  64.065 105.919  1.00 42.91          
ATOM    659  O   GLU    81       7.012  63.340 105.372  1.00 43.00          
ATOM    660  CB  GLU    81       3.942  63.331 106.722  1.00 43.57          
ATOM    661  CG  GLU    81       3.106  62.610 107.756  1.00 48.20          
ATOM    662  CD  GLU    81       1.619  62.746 107.508  1.00 53.76          
ATOM    663  OE1 GLU    81       1.235  62.930 106.333  1.00 57.17          
ATOM    664  OE2 GLU    81       0.829  62.677 108.490  1.00 57.87          
ATOM    665  N   VAL    82       5.873  65.283 105.472  1.00 42.61          
ATOM    666  CA  VAL    82       6.512  65.765 104.235  1.00 41.61          
ATOM    667  C   VAL    82       8.017  65.801 104.470  1.00 41.77          
ATOM    668  O   VAL    82       8.767  65.579 103.558  1.00 42.22          
ATOM    669  CB  VAL    82       5.960  67.126 103.731  1.00 40.34          
ATOM    670  CG1 VAL    82       6.776  67.633 102.543  1.00 38.99          
ATOM    671  CG2 VAL    82       4.494  66.982 103.392  1.00 39.92          
ATOM    672  N   GLN    83       8.451  66.036 105.702  1.00 42.53          
ATOM    673  CA  GLN    83       9.872  66.114 105.995  1.00 43.77          
ATOM    674  C   GLN    83      10.557  64.743 105.940  1.00 44.90          
ATOM    675  O   GLN    83      11.731  64.640 105.572  1.00 44.31          
ATOM    676  CB  GLN    83      10.061  66.740 107.356  1.00 44.13          
ATOM    677  CG  GLN    83      11.481  66.874 107.810  1.00 46.58          
ATOM    678  CD  GLN    83      11.591  66.941 109.344  1.00 52.85          
ATOM    679  OE1 GLN    83      12.414  66.234 109.939  1.00 56.44          
ATOM    680  NE2 GLN    83      10.746  67.760 109.989  1.00 49.93          
ATOM    681  N   GLN    84       9.824  63.681 106.294  1.00 45.52          
ATOM    682  CA  GLN    84      10.370  62.329 106.175  1.00 45.68          
ATOM    683  C   GLN    84      10.459  61.993 104.696  1.00 45.67          
ATOM    684  O   GLN    84      11.435  61.380 104.240  1.00 47.18          
ATOM    685  CB  GLN    84       9.483  61.302 106.901  1.00 46.21          
ATOM    686  CG  GLN    84       9.994  59.874 106.872  1.00 46.51          
ATOM    687  CD  GLN    84      11.414  59.743 107.433  1.00 51.56          
ATOM    688  OE1 GLN    84      11.715  60.252 108.512  1.00 56.03          
ATOM    689  NE2 GLN    84      12.285  59.048 106.705  1.00 50.36          
ATOM    690  N   ALA    85       9.435  62.374 103.937  1.00 44.21          
ATOM    691  CA  ALA    85       9.457  62.136 102.493  1.00 42.22          
ATOM    692  C   ALA    85      10.688  62.805 101.884  1.00 41.35          
ATOM    693  O   ALA    85      11.393  62.206 101.089  1.00 41.98          
ATOM    694  CB  ALA    85       8.200  62.638 101.849  1.00 40.60          
ATOM    695  N   ALA    86      10.962  64.041 102.262  1.00 39.83          
ATOM    696  CA  ALA    86      12.079  64.742 101.664  1.00 39.79          
ATOM    697  C   ALA    86      13.415  64.057 102.032  1.00 39.89          
ATOM    698  O   ALA    86      14.356  64.031 101.243  1.00 39.72          
ATOM    699  CB  ALA    86      12.057  66.235 102.057  1.00 38.26          
ATOM    700  N   THR    87      13.474  63.475 103.228  1.00 40.64          
ATOM    701  CA  THR    87      14.654  62.736 103.685  1.00 40.76          
ATOM    702  C   THR    87      14.773  61.439 102.891  1.00 40.77          
ATOM    703  O   THR    87      15.858  60.975 102.576  1.00 40.05          
ATOM    704  CB  THR    87      14.543  62.413 105.173  1.00 40.67          
ATOM    705  OG1 THR    87      14.827  63.589 105.930  1.00 41.05          
ATOM    706  CG2 THR    87      15.534  61.349 105.564  1.00 40.78          
ATOM    707  N   ASN    88      13.642  60.841 102.569  1.00 40.34          
ATOM    708  CA  ASN    88      13.687  59.647 101.788  1.00 41.23          
ATOM    709  C   ASN    88      14.213  59.918 100.342  1.00 41.13          
ATOM    710  O   ASN    88      15.202  59.318  99.899  1.00 41.27          
ATOM    711  CB  ASN    88      12.297  58.995 101.786  1.00 41.80          
ATOM    712  CG  ASN    88      11.912  58.436 103.166  1.00 44.44          
ATOM    713  OD1 ASN    88      12.766  58.335 104.070  1.00 44.54          
ATOM    714  ND2 ASN    88      10.615  58.098 103.335  1.00 41.81          
ATOM    715  N   ILE    89      13.557  60.818  99.611  1.00 39.96          
ATOM    716  CA  ILE    89      14.053  61.152  98.276  1.00 38.73          
ATOM    717  C   ILE    89      15.520  61.618  98.322  1.00 37.85          
ATOM    718  O   ILE    89      16.338  61.235  97.487  1.00 37.12          
ATOM    719  CB  ILE    89      13.143  62.130  97.543  1.00 38.67          
ATOM    720  CG1 ILE    89      13.416  62.060  96.041  1.00 38.91          
ATOM    721  CG2 ILE    89      13.271  63.553  98.079  1.00 36.12          
ATOM    722  CD  ILE    89      12.236  62.597  95.211  1.00 33.69          
ATOM    723  N   TRP    90      15.878  62.401  99.321  1.00 37.61          
ATOM    724  CA  TRP    90      17.314  62.763  99.456  1.00 37.20          
ATOM    725  C   TRP    90      18.220  61.499  99.422  1.00 38.20          
ATOM    726  O   TRP    90      19.094  61.369  98.559  1.00 37.39          
ATOM    727  CB  TRP    90      17.537  63.564 100.719  1.00 35.71          
ATOM    728  CG  TRP    90      18.968  63.964 100.923  1.00 33.89          
ATOM    729  CD1 TRP    90      19.606  65.070 100.415  1.00 32.67          
ATOM    730  CD2 TRP    90      19.924  63.266 101.705  1.00 32.04          
ATOM    731  NE1 TRP    90      20.918  65.103 100.871  1.00 35.75          
ATOM    732  CE2 TRP    90      21.130  64.003 101.663  1.00 34.66          
ATOM    733  CE3 TRP    90      19.873  62.082 102.473  1.00 36.95          
ATOM    734  CZ2 TRP    90      22.294  63.580 102.320  1.00 36.71          
ATOM    735  CZ3 TRP    90      21.043  61.671 103.161  1.00 37.02          
ATOM    736  CH2 TRP    90      22.236  62.408 103.056  1.00 34.41          
ATOM    737  N   GLY    91      17.977  60.544 100.328  1.00 38.51          
ATOM    738  CA  GLY    91      18.747  59.284 100.312  1.00 39.66          
ATOM    739  C   GLY    91      18.753  58.490  98.998  1.00 40.11          
ATOM    740  O   GLY    91      19.773  57.893  98.641  1.00 40.68          
ATOM    741  N   PHE    92      17.611  58.447  98.301  1.00 40.08          
ATOM    742  CA  PHE    92      17.503  57.921  96.935  1.00 39.63          
ATOM    743  C   PHE    92      18.454  58.630  95.965  1.00 39.80          
ATOM    744  O   PHE    92      19.190  57.993  95.230  1.00 40.09          
ATOM    745  CB  PHE    92      16.053  58.104  96.453  1.00 40.44          
ATOM    746  CG  PHE    92      15.814  57.618  95.073  1.00 40.35          
ATOM    747  CD1 PHE    92      16.210  56.338  94.704  1.00 42.31          
ATOM    748  CD2 PHE    92      15.171  58.428  94.134  1.00 42.07          
ATOM    749  CE1 PHE    92      15.983  55.882  93.396  1.00 43.31          
ATOM    750  CE2 PHE    92      14.940  57.989  92.826  1.00 41.47          
ATOM    751  CZ  PHE    92      15.343  56.735  92.457  1.00 42.68          
ATOM    752  N   LYS    93      18.428  59.960  95.957  1.00 39.22          
ATOM    753  CA  LYS    93      19.308  60.751  95.096  1.00 38.78          
ATOM    754  C   LYS    93      20.803  60.504  95.361  1.00 38.47          
ATOM    755  O   LYS    93      21.614  60.483  94.448  1.00 37.23          
ATOM    756  CB  LYS    93      19.002  62.244  95.295  1.00 38.73          
ATOM    757  CG  LYS    93      17.682  62.637  94.661  1.00 37.27          
ATOM    758  CD  LYS    93      17.178  63.988  95.168  1.00 36.82          
ATOM    759  CE  LYS    93      15.896  64.396  94.425  1.00 35.23          
ATOM    760  NZ  LYS    93      15.524  65.748  94.840  1.00 33.93          
ATOM    761  N   ARG    94      21.145  60.339  96.623  1.00 39.27          
ATOM    762  CA  ARG    94      22.514  60.052  97.063  1.00 41.04          
ATOM    763  C   ARG    94      22.986  58.673  96.629  1.00 41.43          
ATOM    764  O   ARG    94      24.196  58.459  96.394  1.00 41.24          
ATOM    765  CB  ARG    94      22.549  60.136  98.580  1.00 40.99          
ATOM    766  CG  ARG    94      22.400  61.541  99.027  1.00 40.84          
ATOM    767  CD  ARG    94      23.791  62.083  99.158  1.00 41.04          
ATOM    768  NE  ARG    94      23.936  63.267  98.360  1.00 41.26          
ATOM    769  CZ  ARG    94      25.066  63.951  98.152  1.00 42.02          
ATOM    770  NH1 ARG    94      26.253  63.627  98.687  1.00 36.42          
ATOM    771  NH2 ARG    94      24.973  65.024  97.395  1.00 42.90          
ATOM    772  N   LYS    95      22.009  57.759  96.548  1.00 41.56          
ATOM    773  CA  LYS    95      22.208  56.372  96.141  1.00 42.54          
ATOM    774  C   LYS    95      22.515  56.363  94.670  1.00 41.92          
ATOM    775  O   LYS    95      23.559  55.840  94.239  1.00 43.25          
ATOM    776  CB  LYS    95      20.940  55.519  96.407  1.00 42.63          
ATOM    777  CG  LYS    95      20.957  54.132  95.698  1.00 44.82          
ATOM    778  CD  LYS    95      19.834  53.122  96.150  1.00 43.84          
ATOM    779  CE  LYS    95      18.433  53.513  95.659  1.00 45.44          
ATOM    780  NZ  LYS    95      17.355  52.433  95.756  1.00 42.75          
ATOM    781  N   ILE    96      21.603  56.955  93.904  1.00 41.15          
ATOM    782  CA  ILE    96      21.847  57.242  92.485  1.00 39.83          
ATOM    783  C   ILE    96      23.196  57.902  92.301  1.00 38.86          
ATOM    784  O   ILE    96      24.036  57.419  91.554  1.00 38.62          
ATOM    785  CB  ILE    96      20.820  58.169  91.923  1.00 40.03          
ATOM    786  CG1 ILE    96      19.434  57.533  91.993  1.00 39.84          
ATOM    787  CG2 ILE    96      21.144  58.455  90.494  1.00 39.98          
ATOM    788  CD  ILE    96      18.335  58.616  91.898  1.00 43.19          
ATOM    789  N   LEU    97      23.445  58.991  93.002  1.00 38.42          
ATOM    790  CA  LEU    97      24.769  59.582  92.884  1.00 37.92          
ATOM    791  C   LEU    97      25.889  58.512  93.040  1.00 37.78          
ATOM    792  O   LEU    97      26.740  58.385  92.181  1.00 37.73          
ATOM    793  CB  LEU    97      24.939  60.733  93.855  1.00 37.52          
ATOM    794  CG  LEU    97      26.284  61.465  93.679  1.00 38.92          
ATOM    795  CD1 LEU    97      26.431  62.032  92.231  1.00 35.01          
ATOM    796  CD2 LEU    97      26.464  62.545  94.771  1.00 37.38          
ATOM    797  N   GLY    98      25.865  57.747  94.134  1.00 38.87          
ATOM    798  CA  GLY    98      26.854  56.692  94.422  1.00 39.20          
ATOM    799  C   GLY    98      27.138  55.682  93.327  1.00 40.01          
ATOM    800  O   GLY    98      28.293  55.317  93.082  1.00 39.21          
ATOM    801  N   LEU    99      26.060  55.249  92.688  1.00 40.56          
ATOM    802  CA  LEU    99      26.057  54.387  91.510  1.00 41.94          
ATOM    803  C   LEU    99      26.735  55.007  90.289  1.00 43.12          
ATOM    804  O   LEU    99      27.319  54.312  89.462  1.00 44.41          
ATOM    805  CB  LEU    99      24.585  54.086  91.127  1.00 41.37          
ATOM    806  CG  LEU    99      23.908  53.023  91.996  1.00 42.74          
ATOM    807  CD1 LEU    99      22.475  52.665  91.629  1.00 39.82          
ATOM    808  CD2 LEU    99      24.784  51.788  92.032  1.00 43.57          
ATOM    809  N   ILE   100      26.625  56.313  90.136  1.00 43.69          
ATOM    810  CA  ILE   100      27.078  56.950  88.922  1.00 44.07          
ATOM    811  C   ILE   100      28.567  57.222  89.153  1.00 45.29          
ATOM    812  O   ILE   100      29.391  57.036  88.268  1.00 45.44          
ATOM    813  CB  ILE   100      26.321  58.291  88.719  1.00 43.47          
ATOM    814  CG1 ILE   100      24.914  58.069  88.155  1.00 42.87          
ATOM    815  CG2 ILE   100      27.118  59.258  87.874  1.00 42.98          
ATOM    816  CD  ILE   100      23.974  59.362  88.313  1.00 39.03          
ATOM    817  N   LEU   101      28.897  57.648  90.366  1.00 45.71          
ATOM    818  CA  LEU   101      30.284  57.906  90.719  1.00 46.43          
ATOM    819  C   LEU   101      31.135  56.638  90.805  1.00 47.04          
ATOM    820  O   LEU   101      32.350  56.719  90.805  1.00 47.19          
ATOM    821  CB  LEU   101      30.342  58.685  92.027  1.00 45.68          
ATOM    822  CG  LEU   101      29.641  60.052  91.927  1.00 45.69          
ATOM    823  CD1 LEU   101      29.813  60.871  93.189  1.00 44.40          
ATOM    824  CD2 LEU   101      30.152  60.842  90.731  1.00 41.39          
ATOM    825  N   THR   102      30.513  55.467  90.874  1.00 48.39          
ATOM    826  CA  THR   102      31.300  54.225  90.901  1.00 49.46          
ATOM    827  C   THR   102      31.182  53.574  89.525  1.00 50.65          
ATOM    828  O   THR   102      31.585  52.430  89.310  1.00 51.38          
ATOM    829  CB  THR   102      30.818  53.249  91.994  1.00 49.20          
ATOM    830  OG1 THR   102      29.391  53.118  91.907  1.00 49.80          
ATOM    831  CG2 THR   102      31.193  53.764  93.374  1.00 46.85          
ATOM    832  N   CYS   103      30.617  54.340  88.601  1.00 51.01          
ATOM    833  CA  CYS   103      30.467  53.926  87.228  1.00 51.45          
ATOM    834  C   CYS   103      29.852  52.542  87.188  1.00 51.34          
ATOM    835  O   CYS   103      30.255  51.673  86.404  1.00 51.79          
ATOM    836  CB  CYS   103      31.799  53.999  86.475  1.00 52.67          
ATOM    837  SG  CYS   103      33.034  55.265  87.075  1.00 55.42          
ATOM    838  N   LYS   104      28.855  52.341  88.039  1.00 50.45          
ATOM    839  CA  LYS   104      28.061  51.126  88.007  1.00 50.22          
ATOM    840  C   LYS   104      26.919  51.196  86.991  1.00 49.23          
ATOM    841  O   LYS   104      26.247  50.205  86.790  1.00 50.12          
ATOM    842  CB  LYS   104      27.524  50.765  89.408  1.00 50.16          
ATOM    843  CG  LYS   104      28.611  50.717  90.531  1.00 52.94          
ATOM    844  CD  LYS   104      29.403  49.348  90.639  1.00 54.14          
ATOM    845  CE  LYS   104      30.714  49.334  89.781  1.00 56.96          
ATOM    846  NZ  LYS   104      31.843  48.488  90.300  1.00 51.77          
ATOM    847  N   LEU   105      26.695  52.342  86.347  1.00 48.77          
ATOM    848  CA  LEU   105      25.598  52.477  85.351  1.00 47.98          
ATOM    849  C   LEU   105      26.050  53.033  83.976  1.00 48.56          
ATOM    850  O   LEU   105      25.531  54.044  83.512  1.00 48.72          
ATOM    851  CB  LEU   105      24.421  53.330  85.885  1.00 47.64          
ATOM    852  CG  LEU   105      23.637  53.019  87.199  1.00 46.64          
ATOM    853  CD1 LEU   105      22.840  54.242  87.720  1.00 41.48          
ATOM    854  CD2 LEU   105      22.726  51.786  87.118  1.00 42.28          
ATOM    855  N   PRO   106      26.993  52.352  83.289  1.00 48.51          
ATOM    856  CA  PRO   106      27.512  52.990  82.080  1.00 47.34          
ATOM    857  C   PRO   106      26.372  53.209  81.085  1.00 46.33          
ATOM    858  O   PRO   106      25.588  52.300  80.898  1.00 46.57          
ATOM    859  CB  PRO   106      28.494  51.953  81.534  1.00 47.90          
ATOM    860  CG  PRO   106      28.710  50.948  82.615  1.00 47.70          
ATOM    861  CD  PRO   106      27.447  50.949  83.415  1.00 48.63          
ATOM    862  N   GLY   107      26.272  54.404  80.483  1.00 44.91          
ATOM    863  CA  GLY   107      25.227  54.708  79.496  1.00 42.93          
ATOM    864  C   GLY   107      23.985  55.468  79.968  1.00 42.10          
ATOM    865  O   GLY   107      23.108  55.778  79.174  1.00 40.72          
ATOM    866  N   GLN   108      23.902  55.761  81.267  1.00 41.69          
ATOM    867  CA  GLN   108      22.855  56.605  81.838  1.00 40.77          
ATOM    868  C   GLN   108      23.177  58.099  81.584  1.00 41.04          
ATOM    869  O   GLN   108      24.309  58.444  81.209  1.00 40.29          
ATOM    870  CB  GLN   108      22.698  56.325  83.330  1.00 40.87          
ATOM    871  CG  GLN   108      23.915  56.773  84.152  1.00 41.17          
ATOM    872  CD  GLN   108      23.807  58.220  84.609  1.00 42.55          
ATOM    873  OE1 GLN   108      22.696  58.738  84.840  1.00 43.97          
ATOM    874  NE2 GLN   108      24.955  58.869  84.788  1.00 40.06          
ATOM    875  N   ASN   109      22.171  58.961  81.776  1.00 40.69          
ATOM    876  CA  ASN   109      22.204  60.355  81.323  1.00 40.54          
ATOM    877  C   ASN   109      21.997  61.477  82.382  1.00 39.63          
ATOM    878  O   ASN   109      21.956  62.648  82.031  1.00 39.00          
ATOM    879  CB  ASN   109      21.188  60.527  80.197  1.00 41.08          
ATOM    880  CG  ASN   109      21.638  59.870  78.888  1.00 45.83          
ATOM    881  OD1 ASN   109      22.768  60.127  78.402  1.00 50.51          
ATOM    882  ND2 ASN   109      20.742  59.055  78.269  1.00 47.79          
ATOM    883  N   ASN   110      21.841  61.122  83.659  1.00 38.29          
ATOM    884  CA  ASN   110      21.787  62.114  84.730  1.00 36.48          
ATOM    885  C   ASN   110      23.229  62.602  85.061  1.00 36.55          
ATOM    886  O   ASN   110      24.119  61.774  85.303  1.00 34.03          
ATOM    887  CB  ASN   110      21.115  61.468  85.965  1.00 35.92          
ATOM    888  CG  ASN   110      19.670  61.055  85.687  1.00 36.03          
ATOM    889  OD1 ASN   110      18.940  61.792  85.043  1.00 34.97          
ATOM    890  ND2 ASN   110      19.262  59.877  86.164  1.00 31.60          
ATOM    891  N   PHE   111      23.469  63.922  85.062  1.00 36.01          
ATOM    892  CA  PHE   111      24.817  64.421  85.428  1.00 35.80          
ATOM    893  C   PHE   111      25.001  64.201  86.909  1.00 35.24          
ATOM    894  O   PHE   111      24.083  64.367  87.675  1.00 35.20          
ATOM    895  CB  PHE   111      25.014  65.933  85.166  1.00 37.24          
ATOM    896  CG  PHE   111      25.201  66.315  83.700  1.00 39.98          
ATOM    897  CD1 PHE   111      26.316  65.884  82.980  1.00 41.90          
ATOM    898  CD2 PHE   111      24.278  67.125  83.064  1.00 41.84          
ATOM    899  CE1 PHE   111      26.475  66.218  81.655  1.00 38.83          
ATOM    900  CE2 PHE   111      24.454  67.471  81.744  1.00 40.90          
ATOM    901  CZ  PHE   111      25.550  67.007  81.041  1.00 38.06          
ATOM    902  N   PRO   112      26.213  63.849  87.331  1.00 35.33          
ATOM    903  CA  PRO   112      26.368  63.775  88.765  1.00 34.39          
ATOM    904  C   PRO   112      26.138  65.126  89.454  1.00 34.32          
ATOM    905  O   PRO   112      25.682  65.158  90.606  1.00 34.62          
ATOM    906  CB  PRO   112      27.831  63.324  88.937  1.00 35.44          
ATOM    907  CG  PRO   112      28.170  62.600  87.599  1.00 34.33          
ATOM    908  CD  PRO   112      27.385  63.331  86.569  1.00 34.90          
ATOM    909  N   LEU   113      26.480  66.236  88.810  1.00 33.62          
ATOM    910  CA  LEU   113      26.238  67.520  89.434  1.00 33.31          
ATOM    911  C   LEU   113      24.731  67.737  89.527  1.00 33.42          
ATOM    912  O   LEU   113      24.217  68.244  90.525  1.00 33.26          
ATOM    913  CB  LEU   113      26.904  68.663  88.633  1.00 33.30          
ATOM    914  CG  LEU   113      26.538  70.060  89.158  1.00 34.33          
ATOM    915  CD1 LEU   113      26.987  70.224  90.636  1.00 35.64          
ATOM    916  CD2 LEU   113      27.021  71.216  88.258  1.00 34.94          
ATOM    917  N   LEU   114      24.004  67.324  88.513  1.00 33.48          
ATOM    918  CA  LEU   114      22.548  67.447  88.623  1.00 35.81          
ATOM    919  C   LEU   114      21.965  66.642  89.797  1.00 35.88          
ATOM    920  O   LEU   114      21.280  67.188  90.660  1.00 36.20          
ATOM    921  CB  LEU   114      21.876  67.047  87.333  1.00 35.22          
ATOM    922  CG  LEU   114      20.410  67.090  87.673  1.00 40.72          
ATOM    923  CD1 LEU   114      19.591  67.690  86.508  1.00 39.08          
ATOM    924  CD2 LEU   114      19.997  65.670  87.988  1.00 45.06          
ATOM    925  N   VAL   115      22.280  65.348  89.869  1.00 36.30          
ATOM    926  CA  VAL   115      21.787  64.536  90.976  1.00 35.35          
ATOM    927  C   VAL   115      22.099  65.209  92.337  1.00 35.26          
ATOM    928  O   VAL   115      21.211  65.377  93.180  1.00 35.26          
ATOM    929  CB  VAL   115      22.323  63.064  90.914  1.00 36.39          
ATOM    930  CG1 VAL   115      21.737  62.261  92.023  1.00 35.75          
ATOM    931  CG2 VAL   115      22.013  62.381  89.584  1.00 33.78          
ATOM    932  N   ASP   116      23.347  65.631  92.534  1.00 35.01          
ATOM    933  CA  ASP   116      23.749  66.235  93.793  1.00 35.34          
ATOM    934  C   ASP   116      23.004  67.573  94.079  1.00 35.85          
ATOM    935  O   ASP   116      22.677  67.902  95.223  1.00 37.06          
ATOM    936  CB  ASP   116      25.262  66.481  93.834  1.00 34.86          
ATOM    937  CG  ASP   116      25.628  67.374  94.965  1.00 36.75          
ATOM    938  OD1 ASP   116      25.477  66.939  96.114  1.00 35.74          
ATOM    939  OD2 ASP   116      25.968  68.552  94.746  1.00 41.41          
ATOM    940  N   HSD   117      22.783  68.349  93.035  1.00 35.61          
ATOM    941  CA  HSD   117      22.011  69.563  93.075  1.00 35.36          
ATOM    942  C   HSD   117      20.535  69.286  93.455  1.00 36.21          
ATOM    943  O   HSD   117      19.890  70.079  94.132  1.00 36.19          
ATOM    944  CB  HSD   117      22.114  70.135  91.661  1.00 34.04          
ATOM    945  CG  HSD   117      21.209  71.288  91.369  1.00 35.33          
ATOM    946  ND1 HSD   117      21.688  72.549  91.036  1.00 34.44          
ATOM    947  CD2 HSD   117      19.862  71.354  91.266  1.00 28.74          
ATOM    948  CE1 HSD   117      20.658  73.332  90.753  1.00 31.84          
ATOM    949  NE2 HSD   117      19.548  72.630  90.884  1.00 27.66          
ATOM    950  N   THR   118      19.971  68.188  92.983  1.00 36.51          
ATOM    951  CA  THR   118      18.581  67.907  93.361  1.00 36.47          
ATOM    952  C   THR   118      18.541  67.469  94.822  1.00 36.06          
ATOM    953  O   THR   118      17.512  67.568  95.440  1.00 35.31          
ATOM    954  CB  THR   118      17.904  66.840  92.501  1.00 35.90          
ATOM    955  OG1 THR   118      18.694  65.631  92.473  1.00 35.32          
ATOM    956  CG2 THR   118      17.674  67.353  91.093  1.00 37.21          
ATOM    957  N   SER   119      19.682  67.023  95.365  1.00 35.84          
ATOM    958  CA  SER   119      19.708  66.530  96.747  1.00 35.51          
ATOM    959  C   SER   119      19.920  67.680  97.686  1.00 36.09          
ATOM    960  O   SER   119      19.536  67.660  98.855  1.00 37.64          
ATOM    961  CB  SER   119      20.727  65.378  96.961  1.00 34.98          
ATOM    962  OG  SER   119      22.100  65.772  97.034  1.00 32.05          
ATOM    963  N   ARG   120      20.510  68.730  97.152  1.00 37.16          
ATOM    964  CA  ARG   120      20.623  69.962  97.895  1.00 36.64          
ATOM    965  C   ARG   120      19.304  70.701  97.971  1.00 36.65          
ATOM    966  O   ARG   120      19.064  71.327  98.958  1.00 38.54          
ATOM    967  CB  ARG   120      21.683  70.841  97.278  1.00 36.89          
ATOM    968  CG  ARG   120      23.133  70.450  97.713  1.00 35.82          
ATOM    969  CD  ARG   120      24.065  71.419  97.081  1.00 34.74          
ATOM    970  NE  ARG   120      24.490  70.966  95.741  1.00 37.50          
ATOM    971  CZ  ARG   120      24.513  71.703  94.632  1.00 33.33          
ATOM    972  NH1 ARG   120      24.976  71.150  93.523  1.00 34.71          
ATOM    973  NH2 ARG   120      24.106  72.977  94.621  1.00 31.41          
ATOM    974  N   GLU   121      18.468  70.656  96.936  1.00 36.62          
ATOM    975  CA  GLU   121      17.153  71.298  96.977  1.00 36.63          
ATOM    976  C   GLU   121      16.284  70.518  97.956  1.00 37.51          
ATOM    977  O   GLU   121      15.562  71.104  98.772  1.00 37.39          
ATOM    978  CB  GLU   121      16.518  71.399  95.575  1.00 36.80          
ATOM    979  CG  GLU   121      17.279  72.351  94.592  1.00 38.55          
ATOM    980  CD  GLU   121      16.568  72.571  93.263  1.00 45.78          
ATOM    981  OE1 GLU   121      15.576  71.859  92.904  1.00 47.09          
ATOM    982  OE2 GLU   121      17.007  73.488  92.555  1.00 49.54          
ATOM    983  N   ALA   122      16.390  69.182  97.903  1.00 38.36          
ATOM    984  CA  ALA   122      15.723  68.274  98.843  1.00 38.04          
ATOM    985  C   ALA   122      16.091  68.526 100.284  1.00 38.25          
ATOM    986  O   ALA   122      15.221  68.566 101.144  1.00 38.55          
ATOM    987  CB  ALA   122      15.989  66.813  98.466  1.00 38.84          
ATOM    988  N   ASP   123      17.385  68.667 100.561  1.00 39.00          
ATOM    989  CA  ASP   123      17.872  68.907 101.924  1.00 38.46          
ATOM    990  C   ASP   123      17.361  70.254 102.442  1.00 38.16          
ATOM    991  O   ASP   123      16.998  70.386 103.636  1.00 38.32          
ATOM    992  CB  ASP   123      19.401  68.912 101.930  1.00 39.24          
ATOM    993  CG  ASP   123      19.990  68.979 103.352  1.00 41.37          
ATOM    994  OD1 ASP   123      19.531  68.237 104.248  1.00 42.00          
ATOM    995  OD2 ASP   123      20.921  69.777 103.577  1.00 45.04          
ATOM    996  N   TYR   124      17.309  71.237 101.543  1.00 36.67          
ATOM    997  CA  TYR   124      16.778  72.573 101.875  1.00 36.75          
ATOM    998  C   TYR   124      15.256  72.542 102.239  1.00 36.87          
ATOM    999  O   TYR   124      14.800  73.227 103.156  1.00 36.73          
ATOM   1000  CB  TYR   124      17.080  73.540 100.699  1.00 36.28          
ATOM   1001  CG  TYR   124      16.459  74.942 100.794  1.00 36.69          
ATOM   1002  CD1 TYR   124      17.232  76.076 101.069  1.00 32.62          
ATOM   1003  CD2 TYR   124      15.103  75.115 100.608  1.00 34.40          
ATOM   1004  CE1 TYR   124      16.638  77.339 101.165  1.00 34.02          
ATOM   1005  CE2 TYR   124      14.512  76.342 100.685  1.00 33.41          
ATOM   1006  CZ  TYR   124      15.254  77.451 100.949  1.00 34.54          
ATOM   1007  OH  TYR   124      14.585  78.657 100.983  1.00 34.61          
ATOM   1008  N   PHE   125      14.484  71.730 101.527  1.00 36.53          
ATOM   1009  CA  PHE   125      13.081  71.497 101.852  1.00 37.39          
ATOM   1010  C   PHE   125      13.040  70.876 103.269  1.00 38.59          
ATOM   1011  O   PHE   125      12.219  71.235 104.142  1.00 38.37          
ATOM   1012  CB  PHE   125      12.539  70.527 100.793  1.00 36.44          
ATOM   1013  CG  PHE   125      11.037  70.347 100.790  1.00 36.67          
ATOM   1014  CD1 PHE   125      10.205  71.222 101.436  1.00 34.91          
ATOM   1015  CD2 PHE   125      10.469  69.311 100.055  1.00 32.54          
ATOM   1016  CE1 PHE   125       8.843  71.054 101.378  1.00 34.70          
ATOM   1017  CE2 PHE   125       9.142  69.138  99.997  1.00 34.21          
ATOM   1018  CZ  PHE   125       8.309  69.997 100.667  1.00 35.50          
ATOM   1019  N   ARG   126      13.941  69.919 103.479  1.00 38.99          
ATOM   1020  CA  ARG   126      14.008  69.165 104.717  1.00 40.36          
ATOM   1021  C   ARG   126      14.208  70.138 105.873  1.00 39.77          
ATOM   1022  O   ARG   126      13.397  70.223 106.773  1.00 39.75          
ATOM   1023  CB  ARG   126      15.209  68.217 104.626  1.00 40.86          
ATOM   1024  CG  ARG   126      15.137  67.030 105.519  1.00 44.34          
ATOM   1025  CD  ARG   126      16.490  66.286 105.498  1.00 49.32          
ATOM   1026  NE  ARG   126      17.628  67.127 105.877  1.00 51.64          
ATOM   1027  CZ  ARG   126      17.996  67.382 107.138  1.00 52.27          
ATOM   1028  NH1 ARG   126      17.302  66.863 108.153  1.00 53.32          
ATOM   1029  NH2 ARG   126      19.060  68.144 107.388  1.00 49.46          
ATOM   1030  N   LYS   127      15.290  70.896 105.809  1.00 39.72          
ATOM   1031  CA  LYS   127      15.641  71.794 106.864  1.00 40.75          
ATOM   1032  C   LYS   127      14.601  72.926 107.068  1.00 40.65          
ATOM   1033  O   LYS   127      14.348  73.359 108.176  1.00 40.88          
ATOM   1034  CB  LYS   127      17.025  72.347 106.587  1.00 40.71          
ATOM   1035  CG  LYS   127      18.023  71.245 106.318  1.00 45.36          
ATOM   1036  CD  LYS   127      19.405  71.602 106.870  1.00 48.54          
ATOM   1037  CE  LYS   127      20.307  72.056 105.767  1.00 54.06          
ATOM   1038  NZ  LYS   127      20.088  73.493 105.509  1.00 57.21          
ATOM   1039  N   ARG   128      13.997  73.394 105.994  1.00 39.96          
ATOM   1040  CA  ARG   128      12.951  74.379 106.133  1.00 40.30          
ATOM   1041  C   ARG   128      11.730  73.870 106.938  1.00 39.97          
ATOM   1042  O   ARG   128      11.160  74.584 107.747  1.00 39.02          
ATOM   1043  CB  ARG   128      12.543  74.936 104.756  1.00 39.12          
ATOM   1044  CG  ARG   128      11.353  75.862 104.782  1.00 37.24          
ATOM   1045  CD  ARG   128      11.573  77.128 105.570  1.00 35.06          
ATOM   1046  NE  ARG   128      12.967  77.572 105.585  1.00 35.73          
ATOM   1047  CZ  ARG   128      13.555  78.283 104.623  1.00 35.30          
ATOM   1048  NH1 ARG   128      12.871  78.629 103.525  1.00 28.44          
ATOM   1049  NH2 ARG   128      14.848  78.614 104.759  1.00 28.19          
ATOM   1050  N   LEU   129      11.363  72.619 106.760  1.00 40.76          
ATOM   1051  CA  LEU   129      10.189  72.135 107.475  1.00 40.93          
ATOM   1052  C   LEU   129      10.540  71.944 108.961  1.00 40.95          
ATOM   1053  O   LEU   129       9.749  72.252 109.828  1.00 40.55          
ATOM   1054  CB  LEU   129       9.678  70.851 106.830  1.00 41.13          
ATOM   1055  CG  LEU   129       9.108  70.980 105.419  1.00 41.59          
ATOM   1056  CD1 LEU   129       9.372  69.708 104.597  1.00 41.20          
ATOM   1057  CD2 LEU   129       7.613  71.278 105.507  1.00 42.59          
ATOM   1058  N   ILE   130      11.758  71.494 109.247  1.00 41.21          
ATOM   1059  CA  ILE   130      12.267  71.482 110.625  1.00 41.28          
ATOM   1060  C   ILE   130      12.267  72.880 111.301  1.00 41.84          
ATOM   1061  O   ILE   130      11.825  73.015 112.433  1.00 42.92          
ATOM   1062  CB  ILE   130      13.682  70.785 110.733  1.00 41.65          
ATOM   1063  CG1 ILE   130      13.616  69.345 110.222  1.00 40.78          
ATOM   1064  CG2 ILE   130      14.267  70.845 112.172  1.00 39.84          
ATOM   1065  CD  ILE   130      14.996  68.651 110.090  1.00 44.49          
ATOM   1066  N   GLN   131      12.738  73.918 110.615  1.00 41.63          
ATOM   1067  CA  GLN   131      12.596  75.304 111.098  1.00 41.16          
ATOM   1068  C   GLN   131      11.147  75.612 111.416  1.00 40.13          
ATOM   1069  O   GLN   131      10.822  76.092 112.480  1.00 41.15          
ATOM   1070  CB  GLN   131      13.060  76.305 110.029  1.00 41.57          
ATOM   1071  CG  GLN   131      14.502  76.161 109.535  1.00 43.01          
ATOM   1072  CD  GLN   131      14.975  77.448 108.839  1.00 44.04          
ATOM   1073  OE1 GLN   131      14.287  77.986 107.967  1.00 45.45          
ATOM   1074  NE2 GLN   131      16.126  77.955 109.246  1.00 41.28          
ATOM   1075  N   LEU   132      10.257  75.339 110.483  1.00 39.94          
ATOM   1076  CA  LEU   132       8.826  75.605 110.710  1.00 39.37          
ATOM   1077  C   LEU   132       8.281  74.890 111.937  1.00 39.46          
ATOM   1078  O   LEU   132       7.740  75.537 112.815  1.00 38.90          
ATOM   1079  CB  LEU   132       7.979  75.299 109.465  1.00 39.18          
ATOM   1080  CG  LEU   132       8.198  76.323 108.352  1.00 37.92          
ATOM   1081  CD1 LEU   132       7.693  75.805 107.026  1.00 41.02          
ATOM   1082  CD2 LEU   132       7.515  77.640 108.728  1.00 37.49          
ATOM   1083  N   ASN   133       8.445  73.573 112.011  1.00 40.24          
ATOM   1084  CA  ASN   133       7.926  72.806 113.149  1.00 41.38          
ATOM   1085  C   ASN   133       8.593  73.180 114.476  1.00 43.14          
ATOM   1086  O   ASN   133       7.929  73.315 115.486  1.00 43.98          
ATOM   1087  CB  ASN   133       8.017  71.304 112.893  1.00 40.96          
ATOM   1088  CG  ASN   133       6.760  70.748 112.262  1.00 41.54          
ATOM   1089  OD1 ASN   133       5.820  71.496 111.957  1.00 44.77          
ATOM   1090  ND2 ASN   133       6.719  69.441 112.070  1.00 39.43          
ATOM   1091  N   GLU   134       9.897  73.415 114.468  1.00 44.15          
ATOM   1092  CA  GLU   134      10.613  73.766 115.704  1.00 45.22          
ATOM   1093  C   GLU   134      10.466  75.249 116.064  1.00 46.03          
ATOM   1094  O   GLU   134      10.912  75.685 117.129  1.00 46.22          
ATOM   1095  CB  GLU   134      12.103  73.391 115.580  1.00 44.25          
ATOM   1096  CG  GLU   134      12.323  71.917 115.775  1.00 46.44          
ATOM   1097  CD  GLU   134      13.793  71.476 115.606  1.00 53.53          
ATOM   1098  OE1 GLU   134      14.726  72.357 115.547  1.00 52.22          
ATOM   1099  OE2 GLU   134      14.001  70.218 115.512  1.00 53.24          
ATOM   1100  N   GLY   135       9.860  76.031 115.173  1.00 46.12          
ATOM   1101  CA  GLY   135       9.751  77.481 115.398  1.00 46.06          
ATOM   1102  C   GLY   135      11.077  78.239 115.313  1.00 46.11          
ATOM   1103  O   GLY   135      11.368  79.091 116.133  1.00 45.62          
ATOM   1104  N   LYS   136      11.878  77.958 114.292  1.00 46.12          
ATOM   1105  CA  LYS   136      13.207  78.551 114.207  1.00 46.07          
ATOM   1106  C   LYS   136      13.608  79.010 112.797  1.00 45.28          
ATOM   1107  O   LYS   136      14.695  78.698 112.324  1.00 44.58          
ATOM   1108  CB  LYS   136      14.202  77.545 114.778  1.00 46.47          
ATOM   1109  CG  LYS   136      13.776  77.170 116.171  1.00 48.92          
ATOM   1110  CD  LYS   136      14.452  75.899 116.696  1.00 53.64          
ATOM   1111  CE  LYS   136      15.969  76.064 116.805  1.00 54.09          
ATOM   1112  NZ  LYS   136      16.483  74.912 117.602  1.00 55.81          
ATOM   1113  N   LEU   137      12.700  79.717 112.127  1.00 45.41          
ATOM   1114  CA  LEU   137      13.029  80.454 110.905  1.00 45.31          
ATOM   1115  C   LEU   137      14.118  81.448 111.287  1.00 45.52          
ATOM   1116  O   LEU   137      14.110  81.960 112.404  1.00 45.39          
ATOM   1117  CB  LEU   137      11.809  81.232 110.399  1.00 44.94          
ATOM   1118  CG  LEU   137      10.536  80.451 110.103  1.00 43.39          
ATOM   1119  CD1 LEU   137       9.476  81.424 109.741  1.00 40.45          
ATOM   1120  CD2 LEU   137      10.772  79.430 108.993  1.00 42.72          
END
