
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  224 ( 1819),  selected  224 , name 1xly_A
# Molecule2: number of CA atoms  130 ( 1063),  selected  130 , name T0478_138_267.pdb
# PARAMETERS: 1xly_A.T0478_138_267.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    D     6_A      -       -           -
LGA    I     7_A      -       -           -
LGA    K     8_A      -       -           -
LGA    V     9_A      -       -           -
LGA    T    10_A      -       -           -
LGA    P    11_A      -       -           -
LGA    G    12_A      -       -           -
LGA    T    13_A      -       -           -
LGA    S    14_A      -       -           -
LGA    E    15_A      D     138           #
LGA    -       -      A     139           -
LGA    L    16_A      L     140           #
LGA    V    17_A      P     141          3.787
LGA    E    18_A      D     142          4.780
LGA    Q    19_A      A     143          4.846
LGA    I    20_A      I     144          2.678
LGA    L    21_A      I     145          0.784
LGA    A    22_A      K     146          1.720
LGA    L    23_A      E     147          1.013
LGA    L    24_A      N     148          0.374
LGA    S    25_A      V     149          0.867
LGA    R    26_A      F     150          0.626
LGA    Y    27_A      F     151          0.845
LGA    L    28_A      L     152          0.698
LGA    S    29_A      R     153          0.848
LGA    S    30_A      I     154          0.957
LGA    Y    31_A      M     155          1.653
LGA    I    32_A      A     156          1.680
LGA    H    33_A      D     157          2.028
LGA    V    34_A      X     158          2.697
LGA    L    35_A      A     159          2.561
LGA    N    36_A      K     160          1.929
LGA    K    37_A      F     161          2.344
LGA    F    38_A      I     162          2.638
LGA    I    39_A      G     163          1.507
LGA    S    40_A      X     164          1.860
LGA    H    41_A      L     165          2.375
LGA    L    42_A      L     166          2.349
LGA    R    43_A      -       -           -
LGA    R    44_A      -       -           -
LGA    V    45_A      D     167          1.406
LGA    A    46_A      P     168          3.597
LGA    T    47_A      S     169          3.197
LGA    L    48_A      E     170          1.387
LGA    R    49_A      R     171          1.473
LGA    F    50_A      K     172          1.299
LGA    E    51_A      L     173          0.463
LGA    R    52_A      V     174          0.853
LGA    T    53_A      D     175          0.896
LGA    T    54_A      T     176          0.614
LGA    L    55_A      A     177          1.033
LGA    I    56_A      R     178          0.731
LGA    K    57_A      N     179          0.431
LGA    F    58_A      F     180          0.775
LGA    V    59_A      S     181          1.143
LGA    K    60_A      N     182          0.663
LGA    K    61_A      D     183          0.741
LGA    L    62_A      F     184          0.715
LGA    R    63_A      D     185          1.008
LGA    F    64_A      E     186          0.474
LGA    Y    65_A      L     187          0.845
LGA    N    66_A      M     188          0.654
LGA    D    67_A      Y     189          0.752
LGA    S    68_A      Q     190          1.083
LGA    V    69_A      A     191          0.907
LGA    L    70_A      I     192          0.587
LGA    S    71_A      D     193          1.188
LGA    Y    72_A      L     194          2.135
LGA    -       -      E     195           -
LGA    -       -      S     196           -
LGA    N    73_A      M     197          0.548
LGA    A    74_A      K     198          2.335
LGA    S    75_A      P     199          4.433
LGA    E    76_A      Q     200          4.749
LGA    F    77_A      S     201          4.486
LGA    I    78_A      -       -           -
LGA    N    79_A      -       -           -
LGA    E    80_A      -       -           -
LGA    G    81_A      -       -           -
LGA    K    82_A      -       -           -
LGA    N    83_A      -       -           -
LGA    E    84_A      -       -           -
LGA    L    85_A      -       -           -
LGA    D    86_A      -       -           -
LGA    P    87_A      -       -           -
LGA    E    88_A      -       -           -
LGA    A    89_A      -       -           -
LGA    D    90_A      -       -           -
LGA    S    91_A      -       -           -
LGA    F    92_A      -       -           -
LGA    D    93_A      -       -           -
LGA    K    94_A      -       -           -
LGA    V    95_A      Q     202          5.025
LGA    I    96_A      T     203          3.348
LGA    L    97_A      A     204          2.664
LGA    -       -      P     205           -
LGA    P    98_A      L     206          1.185
LGA    I    99_A      L     207          0.637
LGA    A   100_A      D     208          1.910
LGA    S   101_A      Q     209          1.672
LGA    M   102_A      F     210          0.852
LGA    F   103_A      L     211          0.993
LGA    V   104_A      D     212          2.057
LGA    K   105_A      Q     213          1.744
LGA    S   106_A      N     214          0.842
LGA    V   107_A      R     215          1.751
LGA    E   108_A      V     216          2.098
LGA    T   109_A      S     217          1.307
LGA    F   110_A      V     218          0.777
LGA    D   111_A      A     219          0.612
LGA    L   112_A      S     220          1.007
LGA    L   113_A      L     221          1.084
LGA    N   114_A      R     222          0.741
LGA    Y   115_A      D     223          0.598
LGA    Y   116_A      F     224          1.179
LGA    L   117_A      K     225          1.383
LGA    T   118_A      K     226          1.223
LGA    Q   119_A      T     227          2.023
LGA    S   120_A      -       -           -
LGA    L   121_A      A     228          2.291
LGA    Q   122_A      R     229          2.955
LGA    K   123_A      D     230          3.596
LGA    E   124_A      L     231          3.622
LGA    I   125_A      I     232          4.008
LGA    -       -      E     233           -
LGA    L   126_A      Q     234          3.703
LGA    S   127_A      C     235          4.565
LGA    K   128_A      K     236          3.325
LGA    T   129_A      I     237          4.115
LGA    L   130_A      K     238           #
LGA    N   131_A      -       -           -
LGA    E   132_A      S     239           #
LGA    D   133_A      I     240          4.972
LGA    L   134_A      I     241          2.124
LGA    T   135_A      X     242          4.548
LGA    L   136_A      P     243          3.808
LGA    T   137_A      L     244          1.687
LGA    A   138_A      L     245           -
LGA    E   139_A      A     246           -
LGA    -       -      D     247           -
LGA    S   140_A      X     248          1.569
LGA    I   141_A      V     249           #
LGA    L   142_A      F     250           #
LGA    A   143_A      R     251          2.633
LGA    I   144_A      E     252          3.046
LGA    D   145_A      A     253           #
LGA    D   146_A      D     254          4.804
LGA    T   147_A      R     255          0.657
LGA    Y   148_A      F     256          3.600
LGA    N   149_A      L     257          4.689
LGA    H   150_A      E     258          2.476
LGA    F   151_A      I     259          1.290
LGA    V   152_A      I     260          3.672
LGA    -       -      D     261           -
LGA    K   153_A      M     262          1.610
LGA    F   154_A      Y     263          2.291
LGA    S   155_A      D     264          1.845
LGA    Q   156_A      V     265          1.411
LGA    W   157_A      X     266          1.540
LGA    M   158_A      L     267          1.813
LGA    I   159_A      -       -           -
LGA    E   160_A      -       -           -
LGA    S   161_A      -       -           -
LGA    L   162_A      -       -           -
LGA    R   163_A      -       -           -
LGA    I   164_A      -       -           -
LGA    G   165_A      -       -           -
LGA    S   166_A      -       -           -
LGA    N   167_A      -       -           -
LGA    L   168_A      -       -           -
LGA    L   169_A      -       -           -
LGA    D   170_A      -       -           -
LGA    L   171_A      -       -           -
LGA    E   172_A      -       -           -
LGA    V   173_A      -       -           -
LGA    V   174_A      -       -           -
LGA    Q   175_A      -       -           -
LGA    F   176_A      -       -           -
LGA    A   177_A      -       -           -
LGA    I   178_A      -       -           -
LGA    K   179_A      -       -           -
LGA    S   180_A      -       -           -
LGA    A   181_A      -       -           -
LGA    D   182_A      -       -           -
LGA    E   183_A      -       -           -
LGA    D   192_A      -       -           -
LGA    N   193_A      -       -           -
LGA    I   194_A      -       -           -
LGA    F   195_A      -       -           -
LGA    L   196_A      -       -           -
LGA    Q   197_A      -       -           -
LGA    E   198_A      -       -           -
LGA    I   199_A      -       -           -
LGA    L   200_A      -       -           -
LGA    P   201_A      -       -           -
LGA    V   202_A      -       -           -
LGA    N   203_A      -       -           -
LGA    S   204_A      -       -           -
LGA    E   205_A      -       -           -
LGA    E   206_A      -       -           -
LGA    E   207_A      -       -           -
LGA    F   208_A      -       -           -
LGA    Q   209_A      -       -           -
LGA    T   210_A      -       -           -
LGA    L   211_A      -       -           -
LGA    S   212_A      -       -           -
LGA    A   213_A      -       -           -
LGA    A   214_A      -       -           -
LGA    W   215_A      -       -           -
LGA    H   216_A      -       -           -
LGA    S   217_A      -       -           -
LGA    I   218_A      -       -           -
LGA    L   219_A      -       -           -
LGA    D   220_A      -       -           -
LGA    G   221_A      -       -           -
LGA    K   222_A      -       -           -
LGA    L   223_A      -       -           -
LGA    S   224_A      -       -           -
LGA    A   225_A      -       -           -
LGA    L   226_A      -       -           -
LGA    D   227_A      -       -           -
LGA    E   228_A      -       -           -
LGA    E   229_A      -       -           -
LGA    F   230_A      -       -           -
LGA    D   231_A      -       -           -
LGA    V   232_A      -       -           -
LGA    V   233_A      -       -           -
LGA    A   234_A      -       -           -
LGA    T   235_A      -       -           -
LGA    K   236_A      -       -           -
LGA    W   237_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  224  130    5.0    114    2.36     8.77     66.852     4.625

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.418111 * X  +   0.581845 * Y  +   0.697595 * Z  + -42.802891
  Y_new =  -0.724085 * X  +   0.677187 * Y  +  -0.130835 * Z  +  61.441963
  Z_new =  -0.548529 * X  +  -0.450415 * Y  +   0.704445 * Z  + 123.681747 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.568880    2.572713  [ DEG:   -32.5944    147.4056 ]
  Theta =   0.580604    2.560989  [ DEG:    33.2661    146.7339 ]
  Phi   =  -1.047135    2.094458  [ DEG:   -59.9964    120.0036 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1xly_A                                        
REMARK     2: T0478_138_267.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1xly_A.T0478_138_267.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  224  130   5.0  114   2.36    8.77  66.852
REMARK  ---------------------------------------------------------- 
MOLECULE 1xly_A
HEADER    RNA BINDING PROTEIN                     30-SEP-04   1XLY              
TITLE     X-RAY STRUCTURE OF THE RNA-BINDING PROTEIN SHE2P                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SHE2P;                                                     
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: SHE2, YKL130C;                                              
COMPND   5 ENGINEERED: YES;                                                     
COMPND   6 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE   3 ORGANISM_COMMON: YEAST;                                              
SOURCE   4 GENE: SHE2, YKL130C;                                                 
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21-DE3*;                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PGEX-6P1                                  
KEYWDS    BASIC HELICAL HAIRPIN, FIVE HELIX BUNDLE, DIMER, RNA-                 
KEYWDS   2 BINDING PROTEIN                                                      
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    D.NIESSING,S.HUETTELMAIER,D.ZENKLUSEN,R.H.SINGER,S.K.BURLEY           
REVDAT   1   16-NOV-04 1XLY    0                                                
JRNL        AUTH   D.NIESSING,S.HUETTELMAIER,D.ZENKLUSEN,R.H.SINGER,            
JRNL        AUTH 2 S.K.BURLEY                                                   
JRNL        TITL   SHE2P IS A NOVEL RNA BINDING PROTEIN WITH A BASIC            
JRNL        TITL 2 HELICAL HAIRPIN MOTIF                                        
JRNL        REF    CELL (CAMBRIDGE,MASS.)        V. 119   491 2004              
JRNL        REFN   ASTM CELLB5  US ISSN 0092-8674                               
REMARK   2 RESOLUTION. 1.95 ANGSTROMS.                                          
DBREF  1XLY A    6   239  UNP    P36068   YKN0_YEAST       6    239             
DBREF  1XLY B    6   239  UNP    P36068   YKN0_YEAST       6    239             
SEQRES   1 A  234  ASP ILE LYS VAL THR PRO GLY THR SER GLU LEU VAL GLU          
SEQRES   2 A  234  GLN ILE LEU ALA LEU LEU SER ARG TYR LEU SER SER TYR          
SEQRES   3 A  234  ILE HIS VAL LEU ASN LYS PHE ILE SER HIS LEU ARG ARG          
SEQRES   4 A  234  VAL ALA THR LEU ARG PHE GLU ARG THR THR LEU ILE LYS          
SEQRES   5 A  234  PHE VAL LYS LYS LEU ARG PHE TYR ASN ASP SER VAL LEU          
SEQRES   6 A  234  SER TYR ASN ALA SER GLU PHE ILE ASN GLU GLY LYS ASN          
SEQRES   7 A  234  GLU LEU ASP PRO GLU ALA ASP SER PHE ASP LYS VAL ILE          
SEQRES   8 A  234  LEU PRO ILE ALA SER MET PHE VAL LYS SER VAL GLU THR          
SEQRES   9 A  234  PHE ASP LEU LEU ASN TYR TYR LEU THR GLN SER LEU GLN          
SEQRES  10 A  234  LYS GLU ILE LEU SER LYS THR LEU ASN GLU ASP LEU THR          
SEQRES  11 A  234  LEU THR ALA GLU SER ILE LEU ALA ILE ASP ASP THR TYR          
SEQRES  12 A  234  ASN HIS PHE VAL LYS PHE SER GLN TRP MET ILE GLU SER          
SEQRES  13 A  234  LEU ARG ILE GLY SER ASN LEU LEU ASP LEU GLU VAL VAL          
SEQRES  14 A  234  GLN PHE ALA ILE LYS SER ALA ASP GLU ASP GLY THR ASN          
SEQRES  15 A  234  ILE GLY GLU THR ASP ASN ILE PHE LEU GLN GLU ILE LEU          
SEQRES  16 A  234  PRO VAL ASN SER GLU GLU GLU PHE GLN THR LEU SER ALA          
SEQRES  17 A  234  ALA TRP HIS SER ILE LEU ASP GLY LYS LEU SER ALA LEU          
SEQRES  18 A  234  ASP GLU GLU PHE ASP VAL VAL ALA THR LYS TRP HIS ASP          
SEQRES   1 B  234  ASP ILE LYS VAL THR PRO GLY THR SER GLU LEU VAL GLU          
SEQRES   2 B  234  GLN ILE LEU ALA LEU LEU SER ARG TYR LEU SER SER TYR          
SEQRES   3 B  234  ILE HIS VAL LEU ASN LYS PHE ILE SER HIS LEU ARG ARG          
SEQRES   4 B  234  VAL ALA THR LEU ARG PHE GLU ARG THR THR LEU ILE LYS          
SEQRES   5 B  234  PHE VAL LYS LYS LEU ARG PHE TYR ASN ASP SER VAL LEU          
SEQRES   6 B  234  SER TYR ASN ALA SER GLU PHE ILE ASN GLU GLY LYS ASN          
SEQRES   7 B  234  GLU LEU ASP PRO GLU ALA ASP SER PHE ASP LYS VAL ILE          
SEQRES   8 B  234  LEU PRO ILE ALA SER MET PHE VAL LYS SER VAL GLU THR          
SEQRES   9 B  234  PHE ASP LEU LEU ASN TYR TYR LEU THR GLN SER LEU GLN          
SEQRES  10 B  234  LYS GLU ILE LEU SER LYS THR LEU ASN GLU ASP LEU THR          
SEQRES  11 B  234  LEU THR ALA GLU SER ILE LEU ALA ILE ASP ASP THR TYR          
SEQRES  12 B  234  ASN HIS PHE VAL LYS PHE SER GLN TRP MET ILE GLU SER          
SEQRES  13 B  234  LEU ARG ILE GLY SER ASN LEU LEU ASP LEU GLU VAL VAL          
SEQRES  14 B  234  GLN PHE ALA ILE LYS SER ALA ASP GLU ASP GLY THR ASN          
SEQRES  15 B  234  ILE GLY GLU THR ASP ASN ILE PHE LEU GLN GLU ILE LEU          
SEQRES  16 B  234  PRO VAL ASN SER GLU GLU GLU PHE GLN THR LEU SER ALA          
SEQRES  17 B  234  ALA TRP HIS SER ILE LEU ASP GLY LYS LEU SER ALA LEU          
SEQRES  18 B  234  ASP GLU GLU PHE ASP VAL VAL ALA THR LYS TRP HIS ASP          
FORMUL   3  HOH   *302(H2 O)                                                    
CRYST1   97.199  103.647   56.733  90.00 110.51  90.00 C 1 2 1       8          
ATOM      1  N   ASP A   6      20.394 104.353 115.968  1.00 79.85           N  
ATOM      2  CA  ASP A   6      19.545 103.929 117.135  1.00 80.01           C  
ATOM      3  C   ASP A   6      19.806 102.473 117.557  1.00 77.18           C  
ATOM      4  O   ASP A   6      20.426 102.224 118.601  1.00 77.53           O  
ATOM      5  CB  ASP A   6      18.053 104.078 116.826  1.00 82.41           C  
ATOM      6  CG  ASP A   6      17.658 105.508 116.477  1.00 88.03           C  
ATOM      7  OD1 ASP A   6      17.993 106.435 117.268  1.00 91.92           O  
ATOM      8  OD2 ASP A   6      16.995 105.792 115.438  1.00 90.90           O  
ATOM      9  N   ILE A   7      19.304 101.519 116.778  1.00 73.13           N  
ATOM     10  CA  ILE A   7      19.527 100.117 117.105  1.00 70.67           C  
ATOM     11  C   ILE A   7      21.006  99.798 116.937  1.00 68.54           C  
ATOM     12  O   ILE A   7      21.626 100.174 115.948  1.00 66.40           O  
ATOM     13  CB  ILE A   7      18.661  99.150 116.277  1.00 70.55           C  
ATOM     14  CG1 ILE A   7      17.169  99.496 116.407  1.00 69.00           C  
ATOM     15  CG2 ILE A   7      18.957  97.691 116.704  1.00 70.24           C  
ATOM     16  CD1 ILE A   7      16.303  98.774 115.379  1.00 70.29           C  
ATOM     17  N   LYS A   8      21.560  99.143 117.947  1.00 67.82           N  
ATOM     18  CA  LYS A   8      22.970  98.795 117.947  1.00 66.94           C  
ATOM     19  C   LYS A   8      23.160  97.301 117.666  1.00 65.98           C  
ATOM     20  O   LYS A   8      22.281  96.490 117.977  1.00 64.09           O  
ATOM     21  CB  LYS A   8      23.625  99.226 119.274  1.00 67.25           C  
ATOM     22  CG  LYS A   8      23.574 100.756 119.520  1.00 66.97           C  
ATOM     23  CD  LYS A   8      24.277 101.547 118.383  1.00 68.27           C  
ATOM     24  CE  LYS A   8      24.797 102.928 118.807  1.00 66.65           C  
ATOM     25  NZ  LYS A   8      25.493 103.553 117.657  1.00 61.55           N  
ATOM     26  N   VAL A   9      24.301  96.953 117.065  1.00 64.89           N  
ATOM     27  CA  VAL A   9      24.643  95.538 116.864  1.00 65.26           C  
ATOM     28  C   VAL A   9      24.931  94.841 118.194  1.00 66.44           C  
ATOM     29  O   VAL A   9      25.396  95.478 119.157  1.00 66.75           O  
ATOM     30  CB  VAL A   9      25.847  95.347 115.920  1.00 64.34           C  
ATOM     31  CG1 VAL A   9      25.564  96.027 114.560  1.00 61.63           C  
ATOM     32  CG2 VAL A   9      27.166  95.843 116.571  1.00 64.11           C  
ATOM     33  N   THR A  10      24.668  93.546 118.245  1.00 66.75           N  
ATOM     34  CA  THR A  10      24.989  92.749 119.419  1.00 68.65           C  
ATOM     35  C   THR A  10      25.941  91.603 119.078  1.00 68.62           C  
ATOM     36  O   THR A  10      26.449  91.570 117.961  1.00 68.23           O  
ATOM     37  CB  THR A  10      23.699  92.267 120.084  1.00 68.93           C  
ATOM     38  OG1 THR A  10      23.060  91.297 119.236  1.00 69.52           O  
ATOM     39  CG2 THR A  10      22.709  93.464 120.185  1.00 70.55           C  
ATOM     40  N   PRO A  11      26.226  90.692 120.027  1.00 68.56           N  
ATOM     41  CA  PRO A  11      27.154  89.581 119.749  1.00 67.27           C  
ATOM     42  C   PRO A  11      26.533  88.428 118.916  1.00 64.62           C  
ATOM     43  O   PRO A  11      27.315  87.619 118.408  1.00 65.05           O  
ATOM     44  CB  PRO A  11      27.584  89.131 121.164  1.00 68.66           C  
ATOM     45  CG  PRO A  11      27.040  90.225 122.099  1.00 68.80           C  
ATOM     46  CD  PRO A  11      25.757  90.649 121.431  1.00 68.24           C  
ATOM     47  N   GLY A  12      25.196  88.359 118.818  1.00 61.59           N  
ATOM     48  CA  GLY A  12      24.463  87.507 117.867  1.00 58.72           C  
ATOM     49  C   GLY A  12      24.323  88.064 116.413  1.00 56.87           C  
ATOM     50  O   GLY A  12      24.021  87.318 115.513  1.00 56.13           O  
ATOM     51  N   THR A  13      24.579  89.345 116.172  1.00 54.32           N  
ATOM     52  CA  THR A  13      24.416  89.936 114.841  1.00 53.22           C  
ATOM     53  C   THR A  13      25.260  89.258 113.729  1.00 53.00           C  
ATOM     54  O   THR A  13      24.749  89.007 112.639  1.00 51.33           O  
ATOM     55  CB  THR A  13      24.791  91.420 114.851  1.00 54.01           C  
ATOM     56  OG1 THR A  13      24.060  92.099 115.871  1.00 52.99           O  
ATOM     57  CG2 THR A  13      24.317  92.118 113.491  1.00 50.21           C  
ATOM     58  N   SER A  14      26.547  89.012 113.992  1.00 51.32           N  
ATOM     59  CA  SER A  14      27.348  88.439 112.938  1.00 51.74           C  
ATOM     60  C   SER A  14      26.718  87.112 112.485  1.00 48.38           C  
ATOM     61  O   SER A  14      26.654  86.851 111.302  1.00 46.81           O  
ATOM     62  CB  SER A  14      28.838  88.327 113.316  1.00 53.76           C  
ATOM     63  OG  SER A  14      28.961  87.353 114.322  1.00 57.97           O  
ATOM     64  N   GLU A  15      26.230  86.302 113.416  1.00 47.41           N  
ATOM     65  CA  GLU A  15      25.504  85.073 113.105  1.00 48.43           C  
ATOM     66  C   GLU A  15      24.261  85.348 112.219  1.00 48.20           C  
ATOM     67  O   GLU A  15      23.943  84.631 111.264  1.00 45.47           O  
ATOM     68  CB  GLU A  15      25.017  84.384 114.388  1.00 49.68           C  
ATOM     69  CG  GLU A  15      24.274  83.030 114.127  1.00 60.60           C  
ATOM     70  CD  GLU A  15      23.941  82.148 115.370  1.00 69.23           C  
ATOM     71  OE1 GLU A  15      23.254  82.621 116.334  1.00 70.11           O  
ATOM     72  OE2 GLU A  15      24.339  80.930 115.372  1.00 73.79           O  
ATOM     73  N   LEU A  16      23.517  86.384 112.565  1.00 45.43           N  
ATOM     74  CA  LEU A  16      22.287  86.592 111.830  1.00 42.29           C  
ATOM     75  C   LEU A  16      22.688  86.946 110.347  1.00 39.07           C  
ATOM     76  O   LEU A  16      22.053  86.441 109.401  1.00 38.94           O  
ATOM     77  CB  LEU A  16      21.514  87.739 112.489  1.00 43.29           C  
ATOM     78  CG  LEU A  16      20.342  88.237 111.596  1.00 41.31           C  
ATOM     79  CD1 LEU A  16      19.340  87.169 111.298  1.00 50.39           C  
ATOM     80  CD2 LEU A  16      19.691  89.325 112.371  1.00 53.42           C  
ATOM     81  N   VAL A  17      23.708  87.805 110.184  1.00 39.46           N  
ATOM     82  CA  VAL A  17      24.142  88.253 108.862  1.00 40.16           C  
ATOM     83  C   VAL A  17      24.574  87.019 108.033  1.00 41.91           C  
ATOM     84  O   VAL A  17      24.270  86.902 106.836  1.00 38.68           O  
ATOM     85  CB  VAL A  17      25.256  89.332 108.996  1.00 41.94           C  
ATOM     86  CG1 VAL A  17      26.027  89.626 107.642  1.00 42.52           C  
ATOM     87  CG2 VAL A  17      24.677  90.684 109.545  1.00 43.57           C  
ATOM     88  N   GLU A  18      25.294  86.079 108.664  1.00 41.31           N  
ATOM     89  CA  GLU A  18      25.774  84.899 107.916  1.00 42.93           C  
ATOM     90  C   GLU A  18      24.651  83.980 107.518  1.00 42.62           C  
ATOM     91  O   GLU A  18      24.684  83.412 106.437  1.00 39.67           O  
ATOM     92  CB  GLU A  18      26.833  84.156 108.757  1.00 44.03           C  
ATOM     93  CG  GLU A  18      27.877  85.262 109.022  1.00 51.69           C  
ATOM     94  CD  GLU A  18      29.299  84.802 109.271  1.00 60.88           C  
ATOM     95  OE1 GLU A  18      29.456  84.086 110.315  1.00 64.23           O  
ATOM     96  OE2 GLU A  18      30.237  85.252 108.498  1.00 53.40           O  
ATOM     97  N   GLN A  19      23.626  83.877 108.366  1.00 42.23           N  
ATOM     98  CA  GLN A  19      22.438  83.111 107.998  1.00 44.16           C  
ATOM     99  C   GLN A  19      21.653  83.729 106.834  1.00 40.30           C  
ATOM    100  O   GLN A  19      21.119  83.031 105.991  1.00 39.92           O  
ATOM    101  CB  GLN A  19      21.526  82.919 109.229  1.00 44.93           C  
ATOM    102  CG  GLN A  19      22.163  81.974 110.281  1.00 52.93           C  
ATOM    103  CD  GLN A  19      21.556  82.087 111.696  1.00 62.02           C  
ATOM    104  OE1 GLN A  19      21.756  81.182 112.528  1.00 68.31           O  
ATOM    105  NE2 GLN A  19      20.859  83.195 111.983  1.00 65.31           N  
ATOM    106  N   ILE A  20      21.536  85.047 106.831  1.00 40.78           N  
ATOM    107  CA  ILE A  20      20.876  85.704 105.724  1.00 37.27           C  
ATOM    108  C   ILE A  20      21.667  85.514 104.433  1.00 38.18           C  
ATOM    109  O   ILE A  20      21.083  85.149 103.402  1.00 35.15           O  
ATOM    110  CB  ILE A  20      20.678  87.205 106.077  1.00 41.31           C  
ATOM    111  CG1 ILE A  20      19.663  87.350 107.247  1.00 40.03           C  
ATOM    112  CG2 ILE A  20      20.186  87.934 104.853  1.00 39.39           C  
ATOM    113  CD1 ILE A  20      19.739  88.702 107.865  1.00 41.59           C  
ATOM    114  N   LEU A  21      23.002  85.702 104.500  1.00 38.08           N  
ATOM    115  CA  LEU A  21      23.829  85.509 103.330  1.00 40.23           C  
ATOM    116  C   LEU A  21      23.823  84.057 102.864  1.00 38.31           C  
ATOM    117  O   LEU A  21      24.000  83.779 101.640  1.00 37.70           O  
ATOM    118  CB  LEU A  21      25.273  85.987 103.536  1.00 39.07           C  
ATOM    119  CG  LEU A  21      25.467  87.498 103.549  1.00 43.57           C  
ATOM    120  CD1 LEU A  21      26.887  87.847 103.992  1.00 43.98           C  
ATOM    121  CD2 LEU A  21      25.107  88.123 102.143  1.00 43.15           C  
ATOM    122  N   ALA A  22      23.660  83.125 103.796  1.00 40.26           N  
ATOM    123  CA  ALA A  22      23.613  81.656 103.417  1.00 37.56           C  
ATOM    124  C   ALA A  22      22.401  81.360 102.560  1.00 38.22           C  
ATOM    125  O   ALA A  22      22.445  80.534 101.724  1.00 34.89           O  
ATOM    126  CB  ALA A  22      23.568  80.699 104.656  1.00 40.54           C  
ATOM    127  N   LEU A  23      21.257  81.991 102.822  1.00 34.07           N  
ATOM    128  CA  LEU A  23      20.141  81.832 101.891  1.00 35.13           C  
ATOM    129  C   LEU A  23      20.438  82.263 100.488  1.00 32.26           C  
ATOM    130  O   LEU A  23      20.034  81.574  99.581  1.00 33.89           O  
ATOM    131  CB  LEU A  23      18.912  82.675 102.319  1.00 35.76           C  
ATOM    132  CG  LEU A  23      18.341  82.275 103.657  1.00 44.02           C  
ATOM    133  CD1 LEU A  23      17.254  83.324 104.118  1.00 42.89           C  
ATOM    134  CD2 LEU A  23      17.783  80.858 103.458  1.00 45.68           C  
ATOM    135  N   LEU A  24      21.051  83.432 100.318  1.00 31.94           N  
ATOM    136  CA  LEU A  24      21.474  83.926  99.002  1.00 32.12           C  
ATOM    137  C   LEU A  24      22.455  82.947  98.345  1.00 33.38           C  
ATOM    138  O   LEU A  24      22.344  82.631  97.162  1.00 33.87           O  
ATOM    139  CB  LEU A  24      22.060  85.346  99.110  1.00 31.12           C  
ATOM    140  CG  LEU A  24      22.463  85.993  97.800  1.00 35.94           C  
ATOM    141  CD1 LEU A  24      21.434  85.954  96.736  1.00 39.03           C  
ATOM    142  CD2 LEU A  24      23.043  87.439  98.064  1.00 34.41           C  
ATOM    143  N   SER A  25      23.419  82.495  99.113  1.00 33.96           N  
ATOM    144  CA  SER A  25      24.317  81.439  98.525  1.00 33.23           C  
ATOM    145  C   SER A  25      23.532  80.215  97.993  1.00 32.62           C  
ATOM    146  O   SER A  25      23.754  79.732  96.878  1.00 32.31           O  
ATOM    147  CB  SER A  25      25.274  81.017  99.599  1.00 31.93           C  
ATOM    148  OG  SER A  25      26.153  79.963  98.999  1.00 36.77           O  
ATOM    149  N   ARG A  26      22.491  79.763  98.768  1.00 34.83           N  
ATOM    150  CA  ARG A  26      21.672  78.637  98.336  1.00 37.08           C  
ATOM    151  C   ARG A  26      20.871  78.974  97.088  1.00 32.89           C  
ATOM    152  O   ARG A  26      20.693  78.133  96.219  1.00 34.70           O  
ATOM    153  CB  ARG A  26      20.756  78.225  99.493  1.00 34.00           C  
ATOM    154  CG  ARG A  26      19.738  77.154  99.125  1.00 44.90           C  
ATOM    155  CD  ARG A  26      19.187  76.371 100.379  1.00 51.11           C  
ATOM    156  NE  ARG A  26      18.522  75.157  99.892  1.00 61.01           N  
ATOM    157  CZ  ARG A  26      17.374  74.698 100.387  1.00 61.89           C  
ATOM    158  NH1 ARG A  26      16.795  75.350 101.380  1.00 57.64           N  
ATOM    159  NH2 ARG A  26      16.820  73.598  99.878  1.00 62.81           N  
ATOM    160  N   TYR A  27      20.343  80.202  96.998  1.00 34.36           N  
ATOM    161  CA  TYR A  27      19.637  80.545  95.776  1.00 29.74           C  
ATOM    162  C   TYR A  27      20.623  80.533  94.545  1.00 33.17           C  
ATOM    163  O   TYR A  27      20.345  79.907  93.499  1.00 34.38           O  
ATOM    164  CB  TYR A  27      19.156  81.993  95.997  1.00 33.22           C  
ATOM    165  CG  TYR A  27      18.182  82.543  95.013  1.00 30.95           C  
ATOM    166  CD1 TYR A  27      17.830  83.914  95.089  1.00 34.17           C  
ATOM    167  CD2 TYR A  27      17.558  81.745  94.036  1.00 35.67           C  
ATOM    168  CE1 TYR A  27      16.972  84.469  94.259  1.00 37.14           C  
ATOM    169  CE2 TYR A  27      16.639  82.390  93.109  1.00 36.75           C  
ATOM    170  CZ  TYR A  27      16.376  83.731  93.308  1.00 40.69           C  
ATOM    171  OH  TYR A  27      15.527  84.412  92.484  1.00 43.88           O  
ATOM    172  N   LEU A  28      21.798  81.156  94.699  1.00 32.55           N  
ATOM    173  CA  LEU A  28      22.808  81.241  93.633  1.00 32.17           C  
ATOM    174  C   LEU A  28      23.256  79.824  93.239  1.00 35.23           C  
ATOM    175  O   LEU A  28      23.335  79.517  92.046  1.00 34.47           O  
ATOM    176  CB  LEU A  28      24.081  82.073  94.130  1.00 27.54           C  
ATOM    177  CG  LEU A  28      23.834  83.642  94.328  1.00 30.11           C  
ATOM    178  CD1 LEU A  28      24.976  84.284  95.134  1.00 36.83           C  
ATOM    179  CD2 LEU A  28      23.694  84.305  92.987  1.00 36.08           C  
ATOM    180  N   SER A  29      23.607  79.021  94.259  1.00 34.59           N  
ATOM    181  CA  SER A  29      24.115  77.582  94.053  1.00 35.86           C  
ATOM    182  C   SER A  29      23.125  76.697  93.344  1.00 39.97           C  
ATOM    183  O   SER A  29      23.515  75.866  92.534  1.00 37.42           O  
ATOM    184  CB  SER A  29      24.507  76.937  95.407  1.00 37.87           C  
ATOM    185  OG  SER A  29      25.444  77.821  95.958  1.00 45.26           O  
ATOM    186  N   SER A  30      21.817  76.879  93.593  1.00 36.92           N  
ATOM    187  CA  SER A  30      20.806  76.137  92.856  1.00 40.35           C  
ATOM    188  C   SER A  30      20.758  76.411  91.362  1.00 37.72           C  
ATOM    189  O   SER A  30      20.575  75.485  90.608  1.00 36.85           O  
ATOM    190  CB  SER A  30      19.382  76.456  93.352  1.00 40.14           C  
ATOM    191  OG  SER A  30      19.284  76.303  94.745  1.00 54.92           O  
ATOM    192  N   TYR A  31      20.784  77.676  90.928  1.00 36.56           N  
ATOM    193  CA  TYR A  31      20.916  77.959  89.517  1.00 34.07           C  
ATOM    194  C   TYR A  31      22.292  77.449  88.983  1.00 32.80           C  
ATOM    195  O   TYR A  31      22.394  76.891  87.916  1.00 32.97           O  
ATOM    196  CB  TYR A  31      20.946  79.443  89.411  1.00 36.13           C  
ATOM    197  CG  TYR A  31      19.543  79.964  89.254  1.00 36.12           C  
ATOM    198  CD1 TYR A  31      18.646  79.843  90.308  1.00 36.84           C  
ATOM    199  CD2 TYR A  31      19.166  80.620  88.111  1.00 38.65           C  
ATOM    200  CE1 TYR A  31      17.289  80.380  90.162  1.00 37.12           C  
ATOM    201  CE2 TYR A  31      17.835  81.123  87.946  1.00 37.13           C  
ATOM    202  CZ  TYR A  31      16.936  80.991  88.985  1.00 37.07           C  
ATOM    203  OH  TYR A  31      15.624  81.483  88.796  1.00 42.88           O  
ATOM    204  N   ILE A  32      23.324  77.682  89.769  1.00 30.77           N  
ATOM    205  CA  ILE A  32      24.656  77.259  89.223  1.00 32.92           C  
ATOM    206  C   ILE A  32      24.488  75.763  88.794  1.00 33.37           C  
ATOM    207  O   ILE A  32      24.813  75.391  87.667  1.00 35.89           O  
ATOM    208  CB  ILE A  32      25.744  77.512  90.235  1.00 31.98           C  
ATOM    209  CG1 ILE A  32      26.065  79.025  90.321  1.00 30.94           C  
ATOM    210  CG2 ILE A  32      27.136  76.843  89.746  1.00 29.72           C  
ATOM    211  CD1 ILE A  32      26.727  79.489  91.611  1.00 31.56           C  
ATOM    212  N   HIS A  33      23.967  74.969  89.698  1.00 35.43           N  
ATOM    213  CA  HIS A  33      23.787  73.491  89.513  1.00 39.05           C  
ATOM    214  C   HIS A  33      22.919  73.163  88.315  1.00 37.39           C  
ATOM    215  O   HIS A  33      23.292  72.388  87.473  1.00 35.34           O  
ATOM    216  CB  HIS A  33      23.131  72.916  90.765  1.00 42.59           C  
ATOM    217  CG  HIS A  33      23.131  71.407  90.857  1.00 53.26           C  
ATOM    218  ND1 HIS A  33      24.279  70.670  91.118  1.00 60.82           N  
ATOM    219  CD2 HIS A  33      22.116  70.508  90.804  1.00 55.50           C  
ATOM    220  CE1 HIS A  33      23.976  69.383  91.179  1.00 60.62           C  
ATOM    221  NE2 HIS A  33      22.670  69.259  91.004  1.00 66.24           N  
ATOM    222  N   VAL A  34      21.706  73.737  88.206  1.00 33.83           N  
ATOM    223  CA  VAL A  34      20.963  73.335  87.097  1.00 32.56           C  
ATOM    224  C   VAL A  34      21.502  73.941  85.792  1.00 30.60           C  
ATOM    225  O   VAL A  34      21.358  73.349  84.718  1.00 35.69           O  
ATOM    226  CB  VAL A  34      19.454  73.710  87.297  1.00 32.24           C  
ATOM    227  CG1 VAL A  34      19.325  75.179  86.966  1.00 35.39           C  
ATOM    228  CG2 VAL A  34      18.634  72.849  86.346  1.00 33.37           C  
ATOM    229  N   LEU A  35      22.030  75.160  85.793  1.00 30.89           N  
ATOM    230  CA  LEU A  35      22.449  75.652  84.535  1.00 28.93           C  
ATOM    231  C   LEU A  35      23.793  74.919  84.110  1.00 31.10           C  
ATOM    232  O   LEU A  35      24.043  74.728  82.964  1.00 31.14           O  
ATOM    233  CB  LEU A  35      22.906  77.061  84.725  1.00 29.88           C  
ATOM    234  CG  LEU A  35      21.596  77.934  84.896  1.00 34.29           C  
ATOM    235  CD1 LEU A  35      22.016  79.389  85.103  1.00 37.71           C  
ATOM    236  CD2 LEU A  35      20.719  77.720  83.695  1.00 41.65           C  
ATOM    237  N   ASN A  36      24.602  74.590  85.048  1.00 31.39           N  
ATOM    238  CA  ASN A  36      25.849  73.754  84.637  1.00 32.08           C  
ATOM    239  C   ASN A  36      25.385  72.489  83.847  1.00 34.07           C  
ATOM    240  O   ASN A  36      25.970  72.114  82.828  1.00 36.92           O  
ATOM    241  CB  ASN A  36      26.490  73.271  85.895  1.00 35.53           C  
ATOM    242  CG  ASN A  36      27.541  74.213  86.483  1.00 40.06           C  
ATOM    243  OD1 ASN A  36      27.982  75.177  85.873  1.00 43.56           O  
ATOM    244  ND2 ASN A  36      27.956  73.880  87.753  1.00 45.32           N  
ATOM    245  N   LYS A  37      24.335  71.812  84.332  1.00 36.54           N  
ATOM    246  CA  LYS A  37      23.768  70.632  83.674  1.00 36.39           C  
ATOM    247  C   LYS A  37      23.163  70.934  82.321  1.00 35.77           C  
ATOM    248  O   LYS A  37      23.380  70.221  81.365  1.00 32.97           O  
ATOM    249  CB  LYS A  37      22.667  69.986  84.511  1.00 38.74           C  
ATOM    250  CG  LYS A  37      23.141  69.327  85.759  1.00 43.58           C  
ATOM    251  CD  LYS A  37      21.943  68.970  86.636  1.00 51.40           C  
ATOM    252  CE  LYS A  37      22.348  68.259  87.959  1.00 56.34           C  
ATOM    253  NZ  LYS A  37      21.118  68.511  88.813  1.00 64.44           N  
ATOM    254  N   PHE A  38      22.340  71.985  82.238  1.00 33.75           N  
ATOM    255  CA  PHE A  38      21.843  72.384  80.927  1.00 30.52           C  
ATOM    256  C   PHE A  38      22.895  72.803  79.958  1.00 30.03           C  
ATOM    257  O   PHE A  38      22.770  72.483  78.791  1.00 33.56           O  
ATOM    258  CB  PHE A  38      20.836  73.604  81.173  1.00 33.47           C  
ATOM    259  CG  PHE A  38      20.057  73.954  79.977  1.00 35.88           C  
ATOM    260  CD1 PHE A  38      19.373  72.957  79.270  1.00 39.79           C  
ATOM    261  CD2 PHE A  38      19.889  75.307  79.623  1.00 38.62           C  
ATOM    262  CE1 PHE A  38      18.622  73.265  78.134  1.00 43.60           C  
ATOM    263  CE2 PHE A  38      19.105  75.652  78.465  1.00 39.75           C  
ATOM    264  CZ  PHE A  38      18.465  74.665  77.742  1.00 38.81           C  
ATOM    265  N   ILE A  39      23.897  73.609  80.374  1.00 31.71           N  
ATOM    266  CA  ILE A  39      24.956  74.043  79.502  1.00 32.16           C  
ATOM    267  C   ILE A  39      25.704  72.792  79.030  1.00 32.58           C  
ATOM    268  O   ILE A  39      26.079  72.682  77.846  1.00 33.73           O  
ATOM    269  CB  ILE A  39      25.904  75.029  80.252  1.00 30.54           C  
ATOM    270  CG1 ILE A  39      25.206  76.409  80.428  1.00 33.80           C  
ATOM    271  CG2 ILE A  39      27.238  75.175  79.598  1.00 29.24           C  
ATOM    272  CD1 ILE A  39      25.874  77.212  81.644  1.00 30.87           C  
ATOM    273  N   SER A  40      25.905  71.864  79.920  1.00 33.39           N  
ATOM    274  CA  SER A  40      26.654  70.635  79.458  1.00 33.06           C  
ATOM    275  C   SER A  40      25.824  69.862  78.358  1.00 35.98           C  
ATOM    276  O   SER A  40      26.328  69.493  77.309  1.00 33.87           O  
ATOM    277  CB  SER A  40      26.834  69.709  80.643  1.00 34.34           C  
ATOM    278  OG  SER A  40      27.482  68.546  80.172  1.00 39.31           O  
ATOM    279  N   HIS A  41      24.533  69.658  78.577  1.00 33.44           N  
ATOM    280  CA  HIS A  41      23.646  69.003  77.589  1.00 35.94           C  
ATOM    281  C   HIS A  41      23.645  69.792  76.237  1.00 35.09           C  
ATOM    282  O   HIS A  41      23.565  69.200  75.143  1.00 35.65           O  
ATOM    283  CB  HIS A  41      22.138  69.015  78.137  1.00 38.15           C  
ATOM    284  CG  HIS A  41      21.198  68.164  77.339  1.00 42.01           C  
ATOM    285  ND1 HIS A  41      21.481  66.841  77.047  1.00 41.52           N  
ATOM    286  CD2 HIS A  41      20.017  68.440  76.719  1.00 41.41           C  
ATOM    287  CE1 HIS A  41      20.509  66.335  76.317  1.00 44.65           C  
ATOM    288  NE2 HIS A  41      19.589  67.268  76.134  1.00 42.23           N  
ATOM    289  N   LEU A  42      23.695  71.127  76.313  1.00 34.98           N  
ATOM    290  CA  LEU A  42      23.548  71.957  75.136  1.00 35.50           C  
ATOM    291  C   LEU A  42      24.853  71.782  74.317  1.00 33.59           C  
ATOM    292  O   LEU A  42      24.929  72.099  73.120  1.00 32.29           O  
ATOM    293  CB  LEU A  42      23.314  73.435  75.538  1.00 33.37           C  
ATOM    294  CG  LEU A  42      21.880  73.827  75.970  1.00 35.18           C  
ATOM    295  CD1 LEU A  42      21.963  75.302  76.203  1.00 38.31           C  
ATOM    296  CD2 LEU A  42      20.987  73.378  74.855  1.00 35.00           C  
ATOM    297  N   ARG A  43      25.882  71.079  74.872  1.00 34.53           N  
ATOM    298  CA  ARG A  43      26.960  70.853  73.969  1.00 30.77           C  
ATOM    299  C   ARG A  43      26.548  70.043  72.760  1.00 30.58           C  
ATOM    300  O   ARG A  43      27.212  70.080  71.716  1.00 34.18           O  
ATOM    301  CB  ARG A  43      28.178  70.152  74.721  1.00 32.99           C  
ATOM    302  CG  ARG A  43      27.898  68.700  74.890  1.00 35.34           C  
ATOM    303  CD  ARG A  43      28.780  68.113  76.101  1.00 42.06           C  
ATOM    304  NE  ARG A  43      28.772  66.669  76.094  1.00 45.54           N  
ATOM    305  CZ  ARG A  43      27.777  65.979  76.627  1.00 50.95           C  
ATOM    306  NH1 ARG A  43      26.769  66.633  77.225  1.00 45.65           N  
ATOM    307  NH2 ARG A  43      27.775  64.644  76.570  1.00 48.95           N  
ATOM    308  N   ARG A  44      25.503  69.233  72.864  1.00 30.85           N  
ATOM    309  CA  ARG A  44      25.127  68.345  71.779  1.00 34.02           C  
ATOM    310  C   ARG A  44      24.282  68.955  70.698  1.00 36.29           C  
ATOM    311  O   ARG A  44      24.061  68.304  69.694  1.00 37.61           O  
ATOM    312  CB  ARG A  44      24.284  67.179  72.312  1.00 33.11           C  
ATOM    313  CG  ARG A  44      24.834  66.476  73.488  1.00 41.09           C  
ATOM    314  CD  ARG A  44      23.923  65.357  73.977  1.00 51.45           C  
ATOM    315  NE  ARG A  44      24.711  64.391  74.757  1.00 61.35           N  
ATOM    316  CZ  ARG A  44      24.228  63.470  75.587  1.00 66.25           C  
ATOM    317  NH1 ARG A  44      22.905  63.339  75.787  1.00 69.85           N  
ATOM    318  NH2 ARG A  44      25.072  62.668  76.234  1.00 64.92           N  
ATOM    319  N   VAL A  45      23.793  70.182  70.944  1.00 34.44           N  
ATOM    320  CA  VAL A  45      22.849  70.866  70.027  1.00 34.67           C  
ATOM    321  C   VAL A  45      23.581  71.997  69.304  1.00 34.19           C  
ATOM    322  O   VAL A  45      23.846  73.040  69.859  1.00 37.20           O  
ATOM    323  CB  VAL A  45      21.664  71.447  70.817  1.00 33.95           C  
ATOM    324  CG1 VAL A  45      20.628  71.970  69.796  1.00 36.48           C  
ATOM    325  CG2 VAL A  45      20.953  70.382  71.763  1.00 32.88           C  
ATOM    326  N   ALA A  46      23.867  71.818  68.044  1.00 34.04           N  
ATOM    327  CA  ALA A  46      24.778  72.688  67.384  1.00 36.00           C  
ATOM    328  C   ALA A  46      24.172  74.023  67.095  1.00 36.87           C  
ATOM    329  O   ALA A  46      24.902  74.993  67.079  1.00 41.28           O  
ATOM    330  CB  ALA A  46      25.377  71.980  66.060  1.00 39.77           C  
ATOM    331  N   THR A  47      22.854  74.115  67.006  1.00 32.96           N  
ATOM    332  CA  THR A  47      22.270  75.461  66.700  1.00 35.75           C  
ATOM    333  C   THR A  47      22.102  76.395  67.900  1.00 35.52           C  
ATOM    334  O   THR A  47      21.539  77.547  67.803  1.00 34.61           O  
ATOM    335  CB  THR A  47      20.922  75.199  66.078  1.00 33.11           C  
ATOM    336  OG1 THR A  47      20.069  74.463  66.991  1.00 34.77           O  
ATOM    337  CG2 THR A  47      21.185  74.337  64.884  1.00 37.68           C  
ATOM    338  N   LEU A  48      22.432  75.898  69.092  1.00 33.44           N  
ATOM    339  CA  LEU A  48      22.265  76.707  70.288  1.00 31.38           C  
ATOM    340  C   LEU A  48      23.598  77.146  70.825  1.00 34.85           C  
ATOM    341  O   LEU A  48      23.671  77.449  71.989  1.00 33.84           O  
ATOM    342  CB  LEU A  48      21.422  75.950  71.376  1.00 33.38           C  
ATOM    343  CG  LEU A  48      20.007  75.573  70.986  1.00 33.25           C  
ATOM    344  CD1 LEU A  48      19.240  74.605  72.079  1.00 30.32           C  
ATOM    345  CD2 LEU A  48      19.150  76.884  70.811  1.00 37.87           C  
ATOM    346  N   ARG A  49      24.656  77.053  69.985  1.00 34.34           N  
ATOM    347  CA  ARG A  49      26.031  77.466  70.306  1.00 34.57           C  
ATOM    348  C   ARG A  49      26.144  78.766  71.050  1.00 36.86           C  
ATOM    349  O   ARG A  49      26.890  78.856  72.004  1.00 31.20           O  
ATOM    350  CB  ARG A  49      26.752  77.797  68.982  1.00 41.36           C  
ATOM    351  CG  ARG A  49      27.521  76.777  68.362  1.00 48.17           C  
ATOM    352  CD  ARG A  49      27.991  77.247  66.933  1.00 50.66           C  
ATOM    353  NE  ARG A  49      27.038  77.997  66.077  1.00 52.62           N  
ATOM    354  CZ  ARG A  49      27.357  78.414  64.840  1.00 51.21           C  
ATOM    355  NH1 ARG A  49      28.568  78.116  64.370  1.00 42.47           N  
ATOM    356  NH2 ARG A  49      26.497  79.118  64.071  1.00 48.48           N  
ATOM    357  N   PHE A  50      25.421  79.828  70.563  1.00 30.76           N  
ATOM    358  CA  PHE A  50      25.579  81.141  71.146  1.00 34.38           C  
ATOM    359  C   PHE A  50      24.665  81.446  72.327  1.00 32.28           C  
ATOM    360  O   PHE A  50      25.090  82.143  73.202  1.00 31.16           O  
ATOM    361  CB  PHE A  50      25.475  82.275  70.055  1.00 31.83           C  
ATOM    362  CG  PHE A  50      26.372  81.989  68.861  1.00 35.65           C  
ATOM    363  CD1 PHE A  50      25.838  81.991  67.569  1.00 34.94           C  
ATOM    364  CD2 PHE A  50      27.681  81.549  69.045  1.00 35.55           C  
ATOM    365  CE1 PHE A  50      26.548  81.682  66.491  1.00 42.43           C  
ATOM    366  CE2 PHE A  50      28.422  81.161  67.912  1.00 38.48           C  
ATOM    367  CZ  PHE A  50      27.851  81.249  66.625  1.00 38.00           C  
ATOM    368  N   GLU A  51      23.520  80.806  72.412  1.00 33.29           N  
ATOM    369  CA  GLU A  51      22.727  80.824  73.651  1.00 32.00           C  
ATOM    370  C   GLU A  51      23.514  80.158  74.761  1.00 34.57           C  
ATOM    371  O   GLU A  51      23.482  80.537  75.883  1.00 34.45           O  
ATOM    372  CB  GLU A  51      21.461  80.032  73.369  1.00 36.73           C  
ATOM    373  CG  GLU A  51      20.510  80.746  72.373  1.00 40.83           C  
ATOM    374  CD  GLU A  51      20.814  80.415  70.904  1.00 44.94           C  
ATOM    375  OE1 GLU A  51      21.781  79.599  70.587  1.00 39.35           O  
ATOM    376  OE2 GLU A  51      20.040  80.926  70.047  1.00 40.57           O  
ATOM    377  N   ARG A  52      24.254  79.104  74.412  1.00 32.99           N  
ATOM    378  CA  ARG A  52      25.003  78.402  75.401  1.00 33.05           C  
ATOM    379  C   ARG A  52      26.077  79.284  76.000  1.00 32.37           C  
ATOM    380  O   ARG A  52      26.185  79.337  77.246  1.00 31.81           O  
ATOM    381  CB  ARG A  52      25.552  77.107  74.773  1.00 33.22           C  
ATOM    382  CG  ARG A  52      26.457  76.377  75.730  1.00 38.02           C  
ATOM    383  CD  ARG A  52      26.889  75.014  75.051  1.00 40.48           C  
ATOM    384  NE  ARG A  52      27.705  74.284  75.992  1.00 47.32           N  
ATOM    385  CZ  ARG A  52      28.988  74.511  76.132  1.00 49.59           C  
ATOM    386  NH1 ARG A  52      29.578  75.458  75.395  1.00 50.46           N  
ATOM    387  NH2 ARG A  52      29.666  73.802  77.042  1.00 48.80           N  
ATOM    388  N   THR A  53      26.760  80.072  75.155  1.00 34.28           N  
ATOM    389  CA  THR A  53      27.750  81.015  75.666  1.00 35.26           C  
ATOM    390  C   THR A  53      27.205  82.150  76.455  1.00 32.14           C  
ATOM    391  O   THR A  53      27.830  82.621  77.397  1.00 30.41           O  
ATOM    392  CB  THR A  53      28.693  81.546  74.597  1.00 37.22           C  
ATOM    393  OG1 THR A  53      27.953  82.111  73.542  1.00 39.35           O  
ATOM    394  CG2 THR A  53      29.508  80.359  73.900  1.00 36.64           C  
ATOM    395  N   THR A  54      25.979  82.643  76.082  1.00 31.50           N  
ATOM    396  CA  THR A  54      25.360  83.501  77.001  1.00 28.54           C  
ATOM    397  C   THR A  54      25.055  82.931  78.332  1.00 28.54           C  
ATOM    398  O   THR A  54      25.305  83.604  79.326  1.00 30.64           O  
ATOM    399  CB  THR A  54      23.994  83.936  76.342  1.00 30.18           C  
ATOM    400  OG1 THR A  54      24.304  84.506  75.073  1.00 28.20           O  
ATOM    401  CG2 THR A  54      23.402  85.019  77.125  1.00 34.42           C  
ATOM    402  N   LEU A  55      24.534  81.697  78.401  1.00 27.14           N  
ATOM    403  CA  LEU A  55      24.230  81.143  79.706  1.00 29.42           C  
ATOM    404  C   LEU A  55      25.521  80.973  80.469  1.00 30.75           C  
ATOM    405  O   LEU A  55      25.545  81.144  81.696  1.00 29.74           O  
ATOM    406  CB  LEU A  55      23.609  79.737  79.533  1.00 29.83           C  
ATOM    407  CG  LEU A  55      22.126  79.852  79.051  1.00 31.50           C  
ATOM    408  CD1 LEU A  55      21.603  78.417  78.745  1.00 41.06           C  
ATOM    409  CD2 LEU A  55      21.233  80.609  80.043  1.00 40.65           C  
ATOM    410  N   ILE A  56      26.585  80.542  79.760  1.00 30.83           N  
ATOM    411  CA  ILE A  56      27.856  80.467  80.491  1.00 28.37           C  
ATOM    412  C   ILE A  56      28.400  81.809  81.084  1.00 27.71           C  
ATOM    413  O   ILE A  56      28.804  81.881  82.256  1.00 29.10           O  
ATOM    414  CB  ILE A  56      28.917  79.892  79.518  1.00 31.02           C  
ATOM    415  CG1 ILE A  56      28.673  78.383  79.305  1.00 30.76           C  
ATOM    416  CG2 ILE A  56      30.449  80.097  80.131  1.00 31.22           C  
ATOM    417  CD1 ILE A  56      29.712  77.812  78.119  1.00 31.05           C  
ATOM    418  N   LYS A  57      28.210  82.886  80.346  1.00 31.06           N  
ATOM    419  CA  LYS A  57      28.404  84.206  80.923  1.00 30.62           C  
ATOM    420  C   LYS A  57      27.622  84.388  82.245  1.00 29.96           C  
ATOM    421  O   LYS A  57      28.190  84.919  83.236  1.00 29.25           O  
ATOM    422  CB  LYS A  57      28.190  85.327  79.844  1.00 30.57           C  
ATOM    423  CG  LYS A  57      28.462  86.741  80.340  1.00 33.40           C  
ATOM    424  CD  LYS A  57      30.012  86.981  80.485  1.00 33.80           C  
ATOM    425  CE  LYS A  57      30.247  88.406  80.989  1.00 37.10           C  
ATOM    426  NZ  LYS A  57      31.566  88.496  81.605  1.00 41.34           N  
ATOM    427  N   PHE A  58      26.321  84.108  82.234  1.00 32.43           N  
ATOM    428  CA  PHE A  58      25.498  84.352  83.412  1.00 29.36           C  
ATOM    429  C   PHE A  58      25.971  83.405  84.515  1.00 30.69           C  
ATOM    430  O   PHE A  58      26.085  83.807  85.661  1.00 31.33           O  
ATOM    431  CB  PHE A  58      24.124  83.929  83.112  1.00 29.92           C  
ATOM    432  CG  PHE A  58      23.264  85.110  82.574  1.00 30.34           C  
ATOM    433  CD1 PHE A  58      22.934  85.127  81.208  1.00 33.32           C  
ATOM    434  CD2 PHE A  58      22.925  86.147  83.409  1.00 35.85           C  
ATOM    435  CE1 PHE A  58      22.091  86.252  80.713  1.00 43.24           C  
ATOM    436  CE2 PHE A  58      22.110  87.208  82.954  1.00 29.75           C  
ATOM    437  CZ  PHE A  58      21.776  87.248  81.650  1.00 30.53           C  
ATOM    438  N   VAL A  59      26.248  82.144  84.176  1.00 34.63           N  
ATOM    439  CA  VAL A  59      26.772  81.314  85.270  1.00 33.34           C  
ATOM    440  C   VAL A  59      28.042  81.754  85.919  1.00 31.43           C  
ATOM    441  O   VAL A  59      28.172  81.603  87.121  1.00 31.07           O  
ATOM    442  CB  VAL A  59      26.776  79.762  85.009  1.00 34.82           C  
ATOM    443  CG1 VAL A  59      25.442  79.427  84.536  1.00 38.72           C  
ATOM    444  CG2 VAL A  59      27.827  79.334  83.974  1.00 43.63           C  
ATOM    445  N   LYS A  60      28.987  82.237  85.131  1.00 34.89           N  
ATOM    446  CA  LYS A  60      30.252  82.773  85.698  1.00 34.89           C  
ATOM    447  C   LYS A  60      29.958  83.894  86.657  1.00 34.32           C  
ATOM    448  O   LYS A  60      30.577  84.061  87.707  1.00 28.21           O  
ATOM    449  CB  LYS A  60      31.173  83.277  84.600  1.00 36.58           C  
ATOM    450  CG  LYS A  60      31.803  82.079  83.871  1.00 39.81           C  
ATOM    451  CD  LYS A  60      32.492  82.561  82.594  1.00 42.53           C  
ATOM    452  CE  LYS A  60      33.464  81.383  82.129  1.00 46.49           C  
ATOM    453  NZ  LYS A  60      33.987  81.609  80.721  1.00 51.26           N  
ATOM    454  N   LYS A  61      28.933  84.719  86.310  1.00 30.56           N  
ATOM    455  CA  LYS A  61      28.639  85.775  87.242  1.00 29.21           C  
ATOM    456  C   LYS A  61      28.042  85.301  88.580  1.00 30.08           C  
ATOM    457  O   LYS A  61      28.461  85.798  89.653  1.00 30.96           O  
ATOM    458  CB  LYS A  61      27.642  86.802  86.480  1.00 30.97           C  
ATOM    459  CG  LYS A  61      27.318  88.047  87.352  1.00 34.68           C  
ATOM    460  CD  LYS A  61      28.377  89.176  87.243  1.00 35.72           C  
ATOM    461  CE  LYS A  61      28.678  89.688  85.841  1.00 36.40           C  
ATOM    462  NZ  LYS A  61      30.211  90.050  85.788  1.00 41.47           N  
ATOM    463  N   LEU A  62      27.068  84.373  88.522  1.00 28.27           N  
ATOM    464  CA  LEU A  62      26.430  83.850  89.675  1.00 28.35           C  
ATOM    465  C   LEU A  62      27.467  83.128  90.540  1.00 32.24           C  
ATOM    466  O   LEU A  62      27.443  83.233  91.745  1.00 26.79           O  
ATOM    467  CB  LEU A  62      25.409  82.765  89.278  1.00 28.19           C  
ATOM    468  CG  LEU A  62      24.208  83.098  88.404  1.00 36.28           C  
ATOM    469  CD1 LEU A  62      23.151  81.981  88.399  1.00 34.98           C  
ATOM    470  CD2 LEU A  62      23.681  84.425  88.932  1.00 31.13           C  
ATOM    471  N   ARG A  63      28.365  82.407  89.874  1.00 30.31           N  
ATOM    472  CA  ARG A  63      29.450  81.784  90.709  1.00 32.32           C  
ATOM    473  C   ARG A  63      30.311  82.812  91.359  1.00 29.93           C  
ATOM    474  O   ARG A  63      30.780  82.617  92.489  1.00 36.99           O  
ATOM    475  CB  ARG A  63      30.396  81.014  89.767  1.00 30.90           C  
ATOM    476  CG  ARG A  63      30.027  79.632  89.448  1.00 41.90           C  
ATOM    477  CD  ARG A  63      31.185  78.923  88.594  1.00 44.95           C  
ATOM    478  NE  ARG A  63      30.650  77.748  87.921  1.00 51.32           N  
ATOM    479  CZ  ARG A  63      31.296  77.066  86.987  1.00 57.65           C  
ATOM    480  NH1 ARG A  63      32.532  77.413  86.601  1.00 53.10           N  
ATOM    481  NH2 ARG A  63      30.690  76.020  86.423  1.00 60.58           N  
ATOM    482  N   PHE A  64      30.632  83.894  90.637  1.00 34.09           N  
ATOM    483  CA  PHE A  64      31.343  84.980  91.263  1.00 31.56           C  
ATOM    484  C   PHE A  64      30.657  85.543  92.449  1.00 32.40           C  
ATOM    485  O   PHE A  64      31.229  85.718  93.543  1.00 29.56           O  
ATOM    486  CB  PHE A  64      31.776  86.096  90.262  1.00 33.79           C  
ATOM    487  CG  PHE A  64      32.424  87.263  90.959  1.00 39.11           C  
ATOM    488  CD1 PHE A  64      33.740  87.161  91.482  1.00 36.72           C  
ATOM    489  CD2 PHE A  64      31.725  88.457  91.162  1.00 35.86           C  
ATOM    490  CE1 PHE A  64      34.351  88.254  92.143  1.00 36.26           C  
ATOM    491  CE2 PHE A  64      32.339  89.559  91.832  1.00 36.46           C  
ATOM    492  CZ  PHE A  64      33.642  89.446  92.337  1.00 43.29           C  
ATOM    493  N   TYR A  65      29.354  85.878  92.308  1.00 31.25           N  
ATOM    494  CA  TYR A  65      28.618  86.283  93.539  1.00 31.15           C  
ATOM    495  C   TYR A  65      28.574  85.279  94.687  1.00 32.15           C  
ATOM    496  O   TYR A  65      28.666  85.641  95.838  1.00 33.95           O  
ATOM    497  CB  TYR A  65      27.137  86.513  93.179  1.00 29.66           C  
ATOM    498  CG  TYR A  65      26.883  87.684  92.198  1.00 32.65           C  
ATOM    499  CD1 TYR A  65      25.609  87.843  91.592  1.00 39.15           C  
ATOM    500  CD2 TYR A  65      27.830  88.662  91.981  1.00 34.75           C  
ATOM    501  CE1 TYR A  65      25.361  88.857  90.697  1.00 41.77           C  
ATOM    502  CE2 TYR A  65      27.596  89.697  91.003  1.00 39.81           C  
ATOM    503  CZ  TYR A  65      26.325  89.776  90.425  1.00 44.97           C  
ATOM    504  OH  TYR A  65      26.045  90.811  89.537  1.00 45.83           O  
ATOM    505  N   ASN A  66      28.385  84.008  94.357  1.00 31.65           N  
ATOM    506  CA  ASN A  66      28.315  83.017  95.365  1.00 34.37           C  
ATOM    507  C   ASN A  66      29.694  82.918  96.050  1.00 32.00           C  
ATOM    508  O   ASN A  66      29.741  82.826  97.273  1.00 30.21           O  
ATOM    509  CB  ASN A  66      27.966  81.684  94.715  1.00 32.66           C  
ATOM    510  CG  ASN A  66      27.719  80.621  95.683  1.00 41.39           C  
ATOM    511  OD1 ASN A  66      28.296  79.523  95.592  1.00 40.62           O  
ATOM    512  ND2 ASN A  66      26.857  80.877  96.601  1.00 32.48           N  
ATOM    513  N   ASP A  67      30.737  82.815  95.281  1.00 35.04           N  
ATOM    514  CA  ASP A  67      32.107  82.819  95.921  1.00 36.66           C  
ATOM    515  C   ASP A  67      32.360  84.114  96.811  1.00 37.63           C  
ATOM    516  O   ASP A  67      32.872  84.036  97.923  1.00 36.36           O  
ATOM    517  CB  ASP A  67      33.173  82.830  94.809  1.00 38.77           C  
ATOM    518  CG  ASP A  67      33.333  81.491  94.099  1.00 40.85           C  
ATOM    519  OD1 ASP A  67      32.693  80.437  94.478  1.00 45.20           O  
ATOM    520  OD2 ASP A  67      33.975  81.461  93.014  1.00 45.19           O  
ATOM    521  N   SER A  68      31.879  85.306  96.386  1.00 34.58           N  
ATOM    522  CA  SER A  68      31.995  86.483  97.223  1.00 33.51           C  
ATOM    523  C   SER A  68      31.194  86.335  98.554  1.00 33.99           C  
ATOM    524  O   SER A  68      31.682  86.719  99.643  1.00 33.26           O  
ATOM    525  CB  SER A  68      31.468  87.731  96.434  1.00 32.10           C  
ATOM    526  OG  SER A  68      32.292  87.764  95.283  1.00 38.59           O  
ATOM    527  N   VAL A  69      29.911  85.939  98.464  1.00 34.20           N  
ATOM    528  CA  VAL A  69      29.113  85.739  99.652  1.00 34.44           C  
ATOM    529  C   VAL A  69      29.746  84.736 100.662  1.00 36.95           C  
ATOM    530  O   VAL A  69      29.751  84.941 101.882  1.00 35.05           O  
ATOM    531  CB  VAL A  69      27.661  85.315  99.192  1.00 37.81           C  
ATOM    532  CG1 VAL A  69      26.876  84.752 100.268  1.00 37.75           C  
ATOM    533  CG2 VAL A  69      26.905  86.614  98.647  1.00 37.50           C  
ATOM    534  N   LEU A  70      30.297  83.665 100.122  1.00 35.83           N  
ATOM    535  CA  LEU A  70      30.820  82.635 100.997  1.00 38.66           C  
ATOM    536  C   LEU A  70      32.198  83.037 101.582  1.00 38.61           C  
ATOM    537  O   LEU A  70      32.756  82.299 102.425  1.00 41.26           O  
ATOM    538  CB  LEU A  70      31.008  81.361 100.162  1.00 38.93           C  
ATOM    539  CG  LEU A  70      29.651  80.618  99.896  1.00 43.74           C  
ATOM    540  CD1 LEU A  70      29.825  79.361  99.091  1.00 50.15           C  
ATOM    541  CD2 LEU A  70      28.783  80.342 101.140  1.00 47.94           C  
ATOM    542  N   SER A  71      32.798  84.076 101.032  1.00 39.16           N  
ATOM    543  CA  SER A  71      34.049  84.626 101.535  1.00 41.45           C  
ATOM    544  C   SER A  71      33.859  85.736 102.508  1.00 42.42           C  
ATOM    545  O   SER A  71      34.838  86.161 103.099  1.00 38.72           O  
ATOM    546  CB  SER A  71      34.929  85.196 100.403  1.00 43.95           C  
ATOM    547  OG  SER A  71      35.397  84.175  99.558  1.00 44.57           O  
ATOM    548  N   TYR A  72      32.619  86.235 102.685  1.00 39.04           N  
ATOM    549  CA  TYR A  72      32.439  87.390 103.536  1.00 40.53           C  
ATOM    550  C   TYR A  72      32.496  86.987 104.988  1.00 36.32           C  
ATOM    551  O   TYR A  72      31.763  86.158 105.457  1.00 37.66           O  
ATOM    552  CB  TYR A  72      31.076  88.087 103.174  1.00 37.34           C  
ATOM    553  CG  TYR A  72      30.740  89.325 103.861  1.00 41.02           C  
ATOM    554  CD1 TYR A  72      31.351  90.539 103.459  1.00 42.48           C  
ATOM    555  CD2 TYR A  72      29.745  89.332 104.870  1.00 40.24           C  
ATOM    556  CE1 TYR A  72      30.994  91.734 104.034  1.00 42.16           C  
ATOM    557  CE2 TYR A  72      29.397  90.549 105.516  1.00 42.18           C  
ATOM    558  CZ  TYR A  72      30.020  91.749 105.055  1.00 41.66           C  
ATOM    559  OH  TYR A  72      29.727  92.996 105.547  1.00 42.81           O  
ATOM    560  N   ASN A  73      33.417  87.586 105.711  1.00 37.26           N  
ATOM    561  CA  ASN A  73      33.556  87.304 107.127  1.00 40.32           C  
ATOM    562  C   ASN A  73      32.805  88.423 107.855  1.00 40.29           C  
ATOM    563  O   ASN A  73      33.358  89.527 107.973  1.00 42.05           O  
ATOM    564  CB  ASN A  73      35.059  87.368 107.477  1.00 39.93           C  
ATOM    565  CG  ASN A  73      35.325  86.977 108.916  1.00 44.19           C  
ATOM    566  OD1 ASN A  73      34.512  86.305 109.529  1.00 44.66           O  
ATOM    567  ND2 ASN A  73      36.484  87.352 109.438  1.00 46.55           N  
ATOM    568  N   ALA A  74      31.533  88.205 108.211  1.00 41.28           N  
ATOM    569  CA  ALA A  74      30.687  89.329 108.704  1.00 42.83           C  
ATOM    570  C   ALA A  74      31.302  90.106 109.881  1.00 44.55           C  
ATOM    571  O   ALA A  74      31.211  91.383 109.942  1.00 45.17           O  
ATOM    572  CB  ALA A  74      29.277  88.833 109.099  1.00 41.34           C  
ATOM    573  N   SER A  75      31.905  89.344 110.801  1.00 44.95           N  
ATOM    574  CA  SER A  75      32.715  89.828 111.931  1.00 49.86           C  
ATOM    575  C   SER A  75      33.710  90.956 111.613  1.00 51.85           C  
ATOM    576  O   SER A  75      33.842  91.926 112.384  1.00 52.46           O  
ATOM    577  CB  SER A  75      33.571  88.646 112.480  1.00 51.81           C  
ATOM    578  OG  SER A  75      32.761  87.823 113.257  1.00 56.97           O  
ATOM    579  N   GLU A  76      34.439  90.823 110.516  1.00 51.59           N  
ATOM    580  CA  GLU A  76      35.364  91.858 110.083  1.00 53.62           C  
ATOM    581  C   GLU A  76      34.666  93.235 109.946  1.00 53.74           C  
ATOM    582  O   GLU A  76      35.312  94.256 110.084  1.00 52.19           O  
ATOM    583  CB  GLU A  76      36.054  91.471 108.744  1.00 54.50           C  
ATOM    584  CG  GLU A  76      36.845  92.604 108.046  1.00 57.84           C  
ATOM    585  CD  GLU A  76      37.597  92.197 106.754  1.00 59.69           C  
ATOM    586  OE1 GLU A  76      37.683  90.976 106.447  1.00 58.85           O  
ATOM    587  OE2 GLU A  76      38.086  93.121 106.031  1.00 59.36           O  
ATOM    588  N   PHE A  77      33.363  93.260 109.660  1.00 54.19           N  
ATOM    589  CA  PHE A  77      32.704  94.512 109.264  1.00 53.25           C  
ATOM    590  C   PHE A  77      31.776  94.955 110.395  1.00 54.06           C  
ATOM    591  O   PHE A  77      31.004  95.943 110.272  1.00 53.65           O  
ATOM    592  CB  PHE A  77      32.001  94.308 107.911  1.00 54.25           C  
ATOM    593  CG  PHE A  77      32.983  94.015 106.774  1.00 54.08           C  
ATOM    594  CD1 PHE A  77      33.303  92.671 106.425  1.00 55.04           C  
ATOM    595  CD2 PHE A  77      33.632  95.062 106.105  1.00 52.28           C  
ATOM    596  CE1 PHE A  77      34.247  92.392 105.390  1.00 57.32           C  
ATOM    597  CE2 PHE A  77      34.587  94.788 105.054  1.00 57.38           C  
ATOM    598  CZ  PHE A  77      34.906  93.440 104.729  1.00 56.52           C  
ATOM    599  N   ILE A  78      31.852  94.224 111.505  1.00 51.73           N  
ATOM    600  CA  ILE A  78      30.936  94.492 112.589  1.00 53.66           C  
ATOM    601  C   ILE A  78      31.727  94.848 113.864  1.00 57.63           C  
ATOM    602  O   ILE A  78      32.414  93.997 114.434  1.00 54.88           O  
ATOM    603  CB  ILE A  78      30.003  93.314 112.788  1.00 52.25           C  
ATOM    604  CG1 ILE A  78      29.161  93.057 111.522  1.00 49.18           C  
ATOM    605  CG2 ILE A  78      29.142  93.481 114.023  1.00 54.25           C  
ATOM    606  CD1 ILE A  78      28.191  91.826 111.709  1.00 48.58           C  
ATOM    607  N   ASN A  79      31.670  96.133 114.241  1.00 60.37           N  
ATOM    608  CA  ASN A  79      32.206  96.594 115.518  1.00 65.80           C  
ATOM    609  C   ASN A  79      31.137  96.708 116.594  1.00 67.10           C  
ATOM    610  O   ASN A  79      30.358  97.672 116.655  1.00 68.47           O  
ATOM    611  CB  ASN A  79      32.997  97.903 115.408  1.00 65.46           C  
ATOM    612  CG  ASN A  79      33.877  98.148 116.662  1.00 69.09           C  
ATOM    613  OD1 ASN A  79      35.036  97.792 116.683  1.00 67.52           O  
ATOM    614  ND2 ASN A  79      33.281  98.725 117.724  1.00 71.73           N  
ATOM    615  N   GLU A  80      31.102  95.700 117.442  1.00 71.33           N  
ATOM    616  CA  GLU A  80      30.277  95.720 118.628  1.00 75.41           C  
ATOM    617  C   GLU A  80      30.894  96.632 119.697  1.00 78.28           C  
ATOM    618  O   GLU A  80      31.932  97.279 119.473  1.00 78.66           O  
ATOM    619  CB  GLU A  80      30.164  94.315 119.191  1.00 75.46           C  
ATOM    620  CG  GLU A  80      30.804  93.215 118.380  1.00 77.64           C  
ATOM    621  CD  GLU A  80      30.503  91.882 119.022  1.00 81.86           C  
ATOM    622  OE1 GLU A  80      29.570  91.862 119.857  1.00 84.23           O  
ATOM    623  OE2 GLU A  80      31.179  90.868 118.723  1.00 83.16           O  
ATOM    624  N   GLY A  81      30.262  96.681 120.867  1.00 81.64           N  
ATOM    625  CA  GLY A  81      30.888  97.311 122.023  1.00 86.69           C  
ATOM    626  C   GLY A  81      31.454  96.300 123.014  1.00 89.67           C  
ATOM    627  O   GLY A  81      31.974  95.234 122.619  1.00 89.74           O  
ATOM    628  N   LYS A  82      31.386  96.655 124.300  1.00 91.80           N  
ATOM    629  CA  LYS A  82      31.473  95.677 125.385  1.00 94.66           C  
ATOM    630  C   LYS A  82      30.035  95.542 125.919  1.00 96.89           C  
ATOM    631  O   LYS A  82      29.629  94.496 126.449  1.00 97.14           O  
ATOM    632  CB  LYS A  82      32.397  96.187 126.492  1.00 51.94           C  
ATOM    633  CG  LYS A  82      33.822  96.454 126.038  1.00 51.94           C  
ATOM    634  CD  LYS A  82      34.683  96.955 127.186  1.00 51.94           C  
ATOM    635  CE  LYS A  82      36.110  97.219 126.732  1.00 51.94           C  
ATOM    636  NZ  LYS A  82      36.966  97.712 127.847  1.00 51.94           N  
ATOM    637  N   ASN A  83      29.282  96.628 125.737  1.00 98.08           N  
ATOM    638  CA  ASN A  83      27.892  96.783 126.159  1.00 99.23           C  
ATOM    639  C   ASN A  83      27.619  98.230 125.782  1.00100.17           C  
ATOM    640  O   ASN A  83      27.834  99.135 126.594  1.00100.21           O  
ATOM    641  CB  ASN A  83      27.745  96.557 127.675  1.00 51.94           C  
ATOM    642  CG  ASN A  83      28.735  97.370 128.487  1.00 51.94           C  
ATOM    643  OD1 ASN A  83      29.948  97.223 128.336  1.00 51.94           O  
ATOM    644  ND2 ASN A  83      28.221  98.234 129.354  1.00 51.94           N  
ATOM    645  N   GLU A  84      27.192  98.443 124.533  1.00100.45           N  
ATOM    646  CA  GLU A  84      27.088  99.786 123.931  1.00100.92           C  
ATOM    647  C   GLU A  84      28.221 100.746 124.332  1.00100.29           C  
ATOM    648  O   GLU A  84      27.985 101.702 125.093  1.00 99.90           O  
ATOM    649  CB  GLU A  84      25.711 100.451 124.164  1.00100.95           C  
ATOM    650  CG  GLU A  84      24.587  99.506 124.585  1.00102.77           C  
ATOM    651  CD  GLU A  84      24.137  99.721 126.035  1.00103.95           C  
ATOM    652  OE1 GLU A  84      24.918 100.282 126.833  1.00103.30           O  
ATOM    653  OE2 GLU A  84      22.990  99.341 126.385  1.00104.77           O  
ATOM    654  N   LEU A  85      29.440 100.467 123.836  1.00 99.50           N  
ATOM    655  CA  LEU A  85      30.529 101.447 123.859  1.00 98.79           C  
ATOM    656  C   LEU A  85      30.003 102.694 123.144  1.00 98.20           C  
ATOM    657  O   LEU A  85      29.870 102.707 121.917  1.00 98.24           O  
ATOM    658  CB  LEU A  85      31.817 100.929 123.181  1.00 99.20           C  
ATOM    659  CG  LEU A  85      32.656  99.764 123.748  1.00100.29           C  
ATOM    660  CD1 LEU A  85      33.946  99.638 122.957  1.00100.77           C  
ATOM    661  CD2 LEU A  85      32.974  99.838 125.263  1.00101.91           C  
ATOM    662  N   ASP A  86      29.665 103.713 123.938  1.00 97.61           N  
ATOM    663  CA  ASP A  86      28.970 104.915 123.471  1.00 96.43           C  
ATOM    664  C   ASP A  86      29.108 105.142 121.964  1.00 95.31           C  
ATOM    665  O   ASP A  86      28.251 104.685 121.178  1.00 96.30           O  
ATOM    666  CB  ASP A  86      29.381 106.144 124.307  1.00 51.94           C  
ATOM    667  CG  ASP A  86      29.057 105.982 125.779  1.00 51.94           C  
ATOM    668  OD1 ASP A  86      29.580 105.035 126.404  1.00 51.94           O  
ATOM    669  OD2 ASP A  86      28.279 106.802 126.312  1.00 51.94           O  
ATOM    670  N   PRO A  87      30.205 105.809 121.576  1.00 93.10           N  
ATOM    671  CA  PRO A  87      30.442 106.261 120.190  1.00 89.59           C  
ATOM    672  C   PRO A  87      30.942 105.213 119.162  1.00 86.66           C  
ATOM    673  O   PRO A  87      30.952 105.563 117.973  1.00 86.73           O  
ATOM    674  CB  PRO A  87      31.452 107.377 120.383  1.00 51.94           C  
ATOM    675  CG  PRO A  87      32.376 106.765 121.376  1.00 51.94           C  
ATOM    676  CD  PRO A  87      31.464 105.997 122.342  1.00 51.94           C  
ATOM    677  N   GLU A  88      31.334 104.001 119.590  1.00 82.88           N  
ATOM    678  CA  GLU A  88      31.939 102.986 118.691  1.00 79.02           C  
ATOM    679  C   GLU A  88      31.118 101.703 118.324  1.00 76.12           C  
ATOM    680  O   GLU A  88      31.450 101.034 117.338  1.00 75.68           O  
ATOM    681  CB  GLU A  88      33.322 102.571 119.211  1.00 79.30           C  
ATOM    682  CG  GLU A  88      34.361 103.673 119.170  1.00 79.94           C  
ATOM    683  CD  GLU A  88      35.789 103.166 118.949  1.00 81.64           C  
ATOM    684  OE1 GLU A  88      36.012 101.922 118.884  1.00 80.90           O  
ATOM    685  OE2 GLU A  88      36.707 104.022 118.840  1.00 81.64           O  
ATOM    686  N   ALA A  89      30.093 101.334 119.100  1.00 72.57           N  
ATOM    687  CA  ALA A  89      29.248 100.196 118.702  1.00 69.88           C  
ATOM    688  C   ALA A  89      28.564 100.575 117.394  1.00 67.59           C  
ATOM    689  O   ALA A  89      27.958 101.677 117.275  1.00 66.85           O  
ATOM    690  CB  ALA A  89      28.214  99.816 119.763  1.00 69.04           C  
ATOM    691  N   ASP A  90      28.682  99.669 116.417  1.00 64.74           N  
ATOM    692  CA  ASP A  90      28.031  99.849 115.120  1.00 62.63           C  
ATOM    693  C   ASP A  90      26.499  99.874 115.231  1.00 59.21           C  
ATOM    694  O   ASP A  90      25.882  99.142 115.995  1.00 57.44           O  
ATOM    695  CB  ASP A  90      28.492  98.806 114.099  1.00 62.81           C  
ATOM    696  CG  ASP A  90      29.853  99.149 113.465  1.00 67.50           C  
ATOM    697  OD1 ASP A  90      30.201 100.351 113.337  1.00 69.93           O  
ATOM    698  OD2 ASP A  90      30.646  98.262 113.046  1.00 67.87           O  
ATOM    699  N   SER A  91      25.904 100.772 114.466  1.00 57.19           N  
ATOM    700  CA  SER A  91      24.472 100.807 114.307  1.00 56.56           C  
ATOM    701  C   SER A  91      24.080  99.585 113.465  1.00 54.86           C  
ATOM    702  O   SER A  91      24.779  99.238 112.533  1.00 52.62           O  
ATOM    703  CB  SER A  91      24.086 102.101 113.603  1.00 58.35           C  
ATOM    704  OG  SER A  91      24.303 103.230 114.466  1.00 61.59           O  
ATOM    705  N   PHE A  92      22.968  98.962 113.821  1.00 51.97           N  
ATOM    706  CA  PHE A  92      22.418  97.827 113.114  1.00 50.92           C  
ATOM    707  C   PHE A  92      22.101  98.123 111.662  1.00 51.23           C  
ATOM    708  O   PHE A  92      22.505  97.353 110.779  1.00 49.13           O  
ATOM    709  CB  PHE A  92      21.191  97.314 113.832  1.00 50.56           C  
ATOM    710  CG  PHE A  92      20.715  96.004 113.333  1.00 51.38           C  
ATOM    711  CD1 PHE A  92      21.495  94.845 113.521  1.00 55.52           C  
ATOM    712  CD2 PHE A  92      19.509  95.900 112.675  1.00 52.47           C  
ATOM    713  CE1 PHE A  92      21.051  93.628 113.061  1.00 53.28           C  
ATOM    714  CE2 PHE A  92      19.036  94.705 112.217  1.00 51.70           C  
ATOM    715  CZ  PHE A  92      19.822  93.551 112.392  1.00 56.39           C  
ATOM    716  N   ASP A  93      21.352  99.211 111.400  1.00 51.59           N  
ATOM    717  CA  ASP A  93      21.030  99.548 110.038  1.00 51.87           C  
ATOM    718  C   ASP A  93      22.288  99.618 109.179  1.00 52.47           C  
ATOM    719  O   ASP A  93      22.263  99.169 108.018  1.00 53.64           O  
ATOM    720  CB  ASP A  93      20.067 100.735 109.908  1.00 54.53           C  
ATOM    721  CG  ASP A  93      20.568 102.032 110.537  1.00 61.51           C  
ATOM    722  OD1 ASP A  93      21.792 102.238 110.747  1.00 61.09           O  
ATOM    723  OD2 ASP A  93      19.745 102.962 110.811  1.00 67.30           O  
ATOM    724  N   LYS A  94      23.397 100.098 109.738  1.00 49.50           N  
ATOM    725  CA  LYS A  94      24.630 100.199 108.944  1.00 50.63           C  
ATOM    726  C   LYS A  94      25.233  98.818 108.686  1.00 47.87           C  
ATOM    727  O   LYS A  94      25.904  98.605 107.662  1.00 49.84           O  
ATOM    728  CB  LYS A  94      25.689 101.083 109.646  1.00 51.86           C  
ATOM    729  CG  LYS A  94      26.283 100.566 110.944  1.00 51.94           C  
ATOM    730  CD  LYS A  94      27.589 101.270 111.290  1.00 51.94           C  
ATOM    731  CE  LYS A  94      28.776 100.621 110.586  1.00 51.94           C  
ATOM    732  NZ  LYS A  94      28.582 100.512 109.113  1.00 51.94           N  
ATOM    733  N   VAL A  95      25.017  97.886 109.579  1.00 47.47           N  
ATOM    734  CA  VAL A  95      25.559  96.523 109.336  1.00 47.92           C  
ATOM    735  C   VAL A  95      24.753  95.768 108.232  1.00 46.64           C  
ATOM    736  O   VAL A  95      25.331  95.083 107.369  1.00 43.63           O  
ATOM    737  CB  VAL A  95      25.698  95.720 110.642  1.00 49.20           C  
ATOM    738  CG1 VAL A  95      26.000  94.280 110.350  1.00 49.94           C  
ATOM    739  CG2 VAL A  95      26.900  96.319 111.488  1.00 49.28           C  
ATOM    740  N   ILE A  96      23.439  95.950 108.233  1.00 43.07           N  
ATOM    741  CA  ILE A  96      22.614  95.351 107.226  1.00 42.75           C  
ATOM    742  C   ILE A  96      22.712  95.964 105.790  1.00 42.17           C  
ATOM    743  O   ILE A  96      22.450  95.246 104.815  1.00 40.86           O  
ATOM    744  CB  ILE A  96      21.108  95.305 107.709  1.00 44.25           C  
ATOM    745  CG1 ILE A  96      20.947  94.366 108.942  1.00 43.50           C  
ATOM    746  CG2 ILE A  96      20.124  95.005 106.471  1.00 43.24           C  
ATOM    747  CD1 ILE A  96      21.356  92.831 108.713  1.00 49.81           C  
ATOM    748  N   LEU A  97      23.047  97.243 105.650  1.00 40.14           N  
ATOM    749  CA  LEU A  97      23.033  97.923 104.339  1.00 43.76           C  
ATOM    750  C   LEU A  97      23.846  97.182 103.211  1.00 43.58           C  
ATOM    751  O   LEU A  97      23.407  96.975 102.095  1.00 43.21           O  
ATOM    752  CB  LEU A  97      23.614  99.326 104.504  1.00 42.84           C  
ATOM    753  CG  LEU A  97      23.486 100.359 103.370  1.00 52.19           C  
ATOM    754  CD1 LEU A  97      22.016 100.563 102.831  1.00 52.11           C  
ATOM    755  CD2 LEU A  97      23.974 101.709 103.845  1.00 51.63           C  
ATOM    756  N   PRO A  98      25.083  96.833 103.510  1.00 42.55           N  
ATOM    757  CA  PRO A  98      25.888  96.114 102.506  1.00 41.14           C  
ATOM    758  C   PRO A  98      25.236  94.759 102.102  1.00 38.15           C  
ATOM    759  O   PRO A  98      25.374  94.338 100.949  1.00 38.83           O  
ATOM    760  CB  PRO A  98      27.252  95.894 103.202  1.00 41.35           C  
ATOM    761  CG  PRO A  98      27.207  96.582 104.513  1.00 44.39           C  
ATOM    762  CD  PRO A  98      25.777  97.113 104.784  1.00 42.36           C  
ATOM    763  N   ILE A  99      24.599  94.077 103.057  1.00 37.34           N  
ATOM    764  CA  ILE A  99      23.916  92.810 102.797  1.00 37.42           C  
ATOM    765  C   ILE A  99      22.731  93.052 101.878  1.00 37.76           C  
ATOM    766  O   ILE A  99      22.506  92.352 100.891  1.00 36.02           O  
ATOM    767  CB  ILE A  99      23.430  92.121 104.102  1.00 38.42           C  
ATOM    768  CG1 ILE A  99      24.506  91.932 105.243  1.00 45.55           C  
ATOM    769  CG2 ILE A  99      22.649  90.795 103.773  1.00 37.69           C  
ATOM    770  CD1 ILE A  99      25.941  91.976 104.896  1.00 47.94           C  
ATOM    771  N   ALA A 100      21.896  94.020 102.253  1.00 38.65           N  
ATOM    772  CA  ALA A 100      20.779  94.416 101.381  1.00 39.70           C  
ATOM    773  C   ALA A 100      21.187  94.826 100.002  1.00 39.17           C  
ATOM    774  O   ALA A 100      20.537  94.426  99.039  1.00 38.04           O  
ATOM    775  CB  ALA A 100      19.939  95.534 102.054  1.00 39.70           C  
ATOM    776  N   SER A 101      22.276  95.599  99.908  1.00 38.97           N  
ATOM    777  CA  SER A 101      22.927  95.929  98.627  1.00 40.25           C  
ATOM    778  C   SER A 101      23.288  94.682  97.787  1.00 38.41           C  
ATOM    779  O   SER A 101      22.986  94.598  96.593  1.00 38.46           O  
ATOM    780  CB  SER A 101      24.185  96.760  98.935  1.00 37.52           C  
ATOM    781  OG  SER A 101      24.986  96.918  97.780  1.00 47.78           O  
ATOM    782  N   MET A 102      23.888  93.697  98.439  1.00 37.00           N  
ATOM    783  CA  MET A 102      24.229  92.457  97.715  1.00 37.91           C  
ATOM    784  C   MET A 102      22.935  91.710  97.236  1.00 35.34           C  
ATOM    785  O   MET A 102      22.845  91.220  96.101  1.00 32.69           O  
ATOM    786  CB  MET A 102      25.086  91.564  98.656  1.00 38.08           C  
ATOM    787  CG  MET A 102      25.565  90.328  97.965  1.00 37.01           C  
ATOM    788  SD  MET A 102      26.903  90.652  96.754  1.00 40.30           S  
ATOM    789  CE  MET A 102      26.676  89.141  95.772  1.00 33.67           C  
ATOM    790  N   PHE A 103      21.897  91.737  98.074  1.00 35.67           N  
ATOM    791  CA  PHE A 103      20.642  91.134  97.679  1.00 35.06           C  
ATOM    792  C   PHE A 103      20.090  91.814  96.486  1.00 31.10           C  
ATOM    793  O   PHE A 103      19.580  91.130  95.554  1.00 33.37           O  
ATOM    794  CB  PHE A 103      19.597  91.083  98.830  1.00 33.33           C  
ATOM    795  CG  PHE A 103      19.647  89.850  99.650  1.00 32.91           C  
ATOM    796  CD1 PHE A 103      20.784  89.566 100.430  1.00 36.08           C  
ATOM    797  CD2 PHE A 103      18.654  88.952  99.596  1.00 32.86           C  
ATOM    798  CE1 PHE A 103      20.848  88.380 101.202  1.00 32.45           C  
ATOM    799  CE2 PHE A 103      18.679  87.740 100.353  1.00 38.73           C  
ATOM    800  CZ  PHE A 103      19.795  87.437 101.177  1.00 36.49           C  
ATOM    801  N   VAL A 104      20.057  93.140  96.543  1.00 36.56           N  
ATOM    802  CA  VAL A 104      19.491  93.926  95.406  1.00 34.60           C  
ATOM    803  C   VAL A 104      20.235  93.648  94.091  1.00 35.34           C  
ATOM    804  O   VAL A 104      19.637  93.324  93.088  1.00 31.33           O  
ATOM    805  CB  VAL A 104      19.416  95.430  95.742  1.00 36.86           C  
ATOM    806  CG1 VAL A 104      19.129  96.321  94.497  1.00 34.58           C  
ATOM    807  CG2 VAL A 104      18.264  95.610  96.798  1.00 38.55           C  
ATOM    808  N   LYS A 105      21.574  93.653  94.129  1.00 36.24           N  
ATOM    809  CA  LYS A 105      22.335  93.441  92.914  1.00 35.60           C  
ATOM    810  C   LYS A 105      22.031  92.001  92.428  1.00 32.42           C  
ATOM    811  O   LYS A 105      21.923  91.770  91.227  1.00 33.11           O  
ATOM    812  CB  LYS A 105      23.855  93.611  93.216  1.00 36.69           C  
ATOM    813  CG  LYS A 105      24.799  93.080  92.076  1.00 36.86           C  
ATOM    814  CD  LYS A 105      26.235  93.429  92.454  1.00 38.59           C  
ATOM    815  CE  LYS A 105      26.771  92.338  93.381  1.00 40.18           C  
ATOM    816  NZ  LYS A 105      28.152  92.639  93.923  1.00 44.54           N  
ATOM    817  N   SER A 106      21.964  91.023  93.339  1.00 32.48           N  
ATOM    818  CA  SER A 106      21.721  89.648  92.925  1.00 32.52           C  
ATOM    819  C   SER A 106      20.308  89.457  92.409  1.00 34.75           C  
ATOM    820  O   SER A 106      20.087  88.820  91.408  1.00 34.70           O  
ATOM    821  CB  SER A 106      21.846  88.707  94.149  1.00 36.87           C  
ATOM    822  OG  SER A 106      23.227  88.695  94.586  1.00 35.55           O  
ATOM    823  N   VAL A 107      19.324  90.052  93.082  1.00 34.44           N  
ATOM    824  CA  VAL A 107      17.966  89.985  92.514  1.00 34.46           C  
ATOM    825  C   VAL A 107      17.843  90.565  91.106  1.00 31.59           C  
ATOM    826  O   VAL A 107      17.186  89.997  90.264  1.00 32.96           O  
ATOM    827  CB  VAL A 107      16.984  90.617  93.562  1.00 38.39           C  
ATOM    828  CG1 VAL A 107      15.629  90.867  92.907  1.00 41.91           C  
ATOM    829  CG2 VAL A 107      16.875  89.598  94.763  1.00 42.38           C  
ATOM    830  N   GLU A 108      18.433  91.706  90.826  1.00 35.39           N  
ATOM    831  CA  GLU A 108      18.380  92.294  89.484  1.00 35.70           C  
ATOM    832  C   GLU A 108      19.110  91.413  88.454  1.00 34.63           C  
ATOM    833  O   GLU A 108      18.660  91.264  87.322  1.00 33.04           O  
ATOM    834  CB  GLU A 108      18.935  93.727  89.416  1.00 35.63           C  
ATOM    835  CG  GLU A 108      18.216  94.787  90.313  1.00 40.07           C  
ATOM    836  CD  GLU A 108      16.729  95.071  89.885  1.00 43.51           C  
ATOM    837  OE1 GLU A 108      16.027  94.206  89.276  1.00 45.74           O  
ATOM    838  OE2 GLU A 108      16.235  96.146  90.228  1.00 44.63           O  
ATOM    839  N   THR A 109      20.176  90.714  88.859  1.00 32.45           N  
ATOM    840  CA  THR A 109      20.739  89.756  87.915  1.00 29.51           C  
ATOM    841  C   THR A 109      19.762  88.638  87.610  1.00 30.17           C  
ATOM    842  O   THR A 109      19.629  88.233  86.465  1.00 30.93           O  
ATOM    843  CB  THR A 109      22.063  89.164  88.627  1.00 30.20           C  
ATOM    844  OG1 THR A 109      22.892  90.299  88.847  1.00 38.32           O  
ATOM    845  CG2 THR A 109      22.927  88.348  87.646  1.00 31.86           C  
ATOM    846  N   PHE A 110      19.087  88.084  88.645  1.00 30.08           N  
ATOM    847  CA  PHE A 110      18.224  86.938  88.470  1.00 30.78           C  
ATOM    848  C   PHE A 110      17.050  87.437  87.649  1.00 30.50           C  
ATOM    849  O   PHE A 110      16.501  86.696  86.885  1.00 33.27           O  
ATOM    850  CB  PHE A 110      17.645  86.510  89.845  1.00 30.84           C  
ATOM    851  CG  PHE A 110      18.509  85.532  90.576  1.00 28.49           C  
ATOM    852  CD1 PHE A 110      19.055  85.905  91.796  1.00 28.16           C  
ATOM    853  CD2 PHE A 110      18.765  84.248  90.043  1.00 40.82           C  
ATOM    854  CE1 PHE A 110      19.884  84.993  92.531  1.00 41.14           C  
ATOM    855  CE2 PHE A 110      19.561  83.379  90.778  1.00 34.94           C  
ATOM    856  CZ  PHE A 110      20.130  83.805  91.989  1.00 31.95           C  
ATOM    857  N   ASP A 111      16.700  88.710  87.813  1.00 31.29           N  
ATOM    858  CA  ASP A 111      15.558  89.216  86.926  1.00 31.22           C  
ATOM    859  C   ASP A 111      15.947  89.061  85.431  1.00 33.94           C  
ATOM    860  O   ASP A 111      15.138  88.569  84.624  1.00 33.47           O  
ATOM    861  CB  ASP A 111      15.320  90.667  87.239  1.00 31.95           C  
ATOM    862  CG  ASP A 111      14.077  91.173  86.500  1.00 37.68           C  
ATOM    863  OD1 ASP A 111      13.997  92.361  86.126  1.00 38.77           O  
ATOM    864  OD2 ASP A 111      13.220  90.334  86.210  1.00 38.40           O  
ATOM    865  N   LEU A 112      17.173  89.469  85.054  1.00 32.21           N  
ATOM    866  CA  LEU A 112      17.653  89.445  83.673  1.00 32.31           C  
ATOM    867  C   LEU A 112      17.811  88.002  83.260  1.00 33.06           C  
ATOM    868  O   LEU A 112      17.417  87.563  82.170  1.00 31.80           O  
ATOM    869  CB  LEU A 112      19.025  90.204  83.595  1.00 33.03           C  
ATOM    870  CG  LEU A 112      19.070  91.708  83.860  1.00 35.98           C  
ATOM    871  CD1 LEU A 112      20.494  92.161  83.871  1.00 35.56           C  
ATOM    872  CD2 LEU A 112      18.325  92.383  82.664  1.00 33.95           C  
ATOM    873  N   LEU A 113      18.453  87.228  84.130  1.00 31.25           N  
ATOM    874  CA  LEU A 113      18.645  85.812  83.743  1.00 30.17           C  
ATOM    875  C   LEU A 113      17.292  85.016  83.612  1.00 30.69           C  
ATOM    876  O   LEU A 113      17.118  84.275  82.669  1.00 31.54           O  
ATOM    877  CB  LEU A 113      19.534  85.139  84.805  1.00 29.23           C  
ATOM    878  CG  LEU A 113      19.724  83.624  84.573  1.00 32.71           C  
ATOM    879  CD1 LEU A 113      20.280  83.366  83.221  1.00 33.63           C  
ATOM    880  CD2 LEU A 113      20.627  83.087  85.725  1.00 32.50           C  
ATOM    881  N   ASN A 114      16.382  85.147  84.576  1.00 31.84           N  
ATOM    882  CA  ASN A 114      15.057  84.527  84.454  1.00 34.83           C  
ATOM    883  C   ASN A 114      14.365  84.868  83.193  1.00 28.89           C  
ATOM    884  O   ASN A 114      13.721  84.032  82.604  1.00 30.62           O  
ATOM    885  CB  ASN A 114      14.123  85.009  85.604  1.00 34.32           C  
ATOM    886  CG  ASN A 114      14.501  84.427  86.923  1.00 43.22           C  
ATOM    887  OD1 ASN A 114      14.024  84.905  88.013  1.00 40.94           O  
ATOM    888  ND2 ASN A 114      15.385  83.427  86.885  1.00 33.68           N  
ATOM    889  N   TYR A 115      14.398  86.117  82.823  1.00 32.95           N  
ATOM    890  CA  TYR A 115      13.721  86.540  81.585  1.00 35.32           C  
ATOM    891  C   TYR A 115      14.427  85.880  80.343  1.00 36.43           C  
ATOM    892  O   TYR A 115      13.790  85.237  79.470  1.00 35.79           O  
ATOM    893  CB  TYR A 115      13.743  88.086  81.443  1.00 35.61           C  
ATOM    894  CG  TYR A 115      12.978  88.497  80.188  1.00 37.17           C  
ATOM    895  CD1 TYR A 115      11.569  88.675  80.217  1.00 43.06           C  
ATOM    896  CD2 TYR A 115      13.624  88.583  78.977  1.00 36.38           C  
ATOM    897  CE1 TYR A 115      10.854  88.963  79.034  1.00 43.88           C  
ATOM    898  CE2 TYR A 115      12.919  88.813  77.752  1.00 38.43           C  
ATOM    899  CZ  TYR A 115      11.518  89.073  77.853  1.00 43.72           C  
ATOM    900  OH  TYR A 115      10.804  89.332  76.723  1.00 45.52           O  
ATOM    901  N   TYR A 116      15.748  85.892  80.328  1.00 33.46           N  
ATOM    902  CA  TYR A 116      16.419  85.225  79.220  1.00 33.13           C  
ATOM    903  C   TYR A 116      16.043  83.701  79.222  1.00 30.49           C  
ATOM    904  O   TYR A 116      15.664  83.119  78.182  1.00 31.77           O  
ATOM    905  CB  TYR A 116      17.954  85.387  79.366  1.00 35.03           C  
ATOM    906  CG  TYR A 116      18.677  84.752  78.227  1.00 33.64           C  
ATOM    907  CD1 TYR A 116      18.656  85.333  76.959  1.00 35.31           C  
ATOM    908  CD2 TYR A 116      19.443  83.601  78.418  1.00 38.33           C  
ATOM    909  CE1 TYR A 116      19.347  84.769  75.848  1.00 36.61           C  
ATOM    910  CE2 TYR A 116      20.109  83.042  77.346  1.00 34.15           C  
ATOM    911  CZ  TYR A 116      20.026  83.559  76.089  1.00 35.30           C  
ATOM    912  OH  TYR A 116      20.704  83.091  75.050  1.00 39.24           O  
ATOM    913  N   LEU A 117      16.102  83.083  80.380  1.00 32.80           N  
ATOM    914  CA  LEU A 117      16.083  81.607  80.470  1.00 33.25           C  
ATOM    915  C   LEU A 117      14.611  81.086  80.281  1.00 36.33           C  
ATOM    916  O   LEU A 117      14.368  80.131  79.510  1.00 36.79           O  
ATOM    917  CB  LEU A 117      16.635  81.203  81.837  1.00 36.87           C  
ATOM    918  CG  LEU A 117      16.520  79.752  82.250  1.00 40.93           C  
ATOM    919  CD1 LEU A 117      17.484  79.039  81.254  1.00 41.46           C  
ATOM    920  CD2 LEU A 117      16.948  79.650  83.829  1.00 42.89           C  
ATOM    921  N   THR A 118      13.638  81.859  80.775  1.00 35.42           N  
ATOM    922  CA  THR A 118      12.249  81.385  80.759  1.00 36.69           C  
ATOM    923  C   THR A 118      11.390  81.993  79.713  1.00 38.90           C  
ATOM    924  O   THR A 118      10.337  81.423  79.410  1.00 38.04           O  
ATOM    925  CB  THR A 118      11.488  81.605  82.154  1.00 35.78           C  
ATOM    926  OG1 THR A 118      11.230  83.032  82.340  1.00 36.25           O  
ATOM    927  CG2 THR A 118      12.325  81.178  83.359  1.00 37.12           C  
ATOM    928  N   GLN A 119      11.772  83.126  79.153  1.00 37.54           N  
ATOM    929  CA  GLN A 119      11.025  83.673  78.085  1.00 39.27           C  
ATOM    930  C   GLN A 119      11.754  83.537  76.766  1.00 39.90           C  
ATOM    931  O   GLN A 119      11.412  82.658  75.972  1.00 39.86           O  
ATOM    932  CB  GLN A 119      10.638  85.112  78.422  1.00 39.90           C  
ATOM    933  CG  GLN A 119       9.885  85.187  79.775  1.00 44.12           C  
ATOM    934  CD  GLN A 119       8.423  84.703  79.664  1.00 58.42           C  
ATOM    935  OE1 GLN A 119       7.711  85.080  78.708  1.00 62.09           O  
ATOM    936  NE2 GLN A 119       7.986  83.848  80.608  1.00 62.76           N  
ATOM    937  N   SER A 120      12.779  84.364  76.560  1.00 36.49           N  
ATOM    938  CA  SER A 120      13.441  84.542  75.259  1.00 37.77           C  
ATOM    939  C   SER A 120      13.984  83.231  74.776  1.00 36.58           C  
ATOM    940  O   SER A 120      13.813  82.872  73.614  1.00 35.44           O  
ATOM    941  CB  SER A 120      14.689  85.439  75.419  1.00 37.66           C  
ATOM    942  OG  SER A 120      14.222  86.730  75.664  1.00 46.78           O  
ATOM    943  N   LEU A 121      14.739  82.576  75.634  1.00 34.86           N  
ATOM    944  CA  LEU A 121      15.447  81.332  75.215  1.00 34.20           C  
ATOM    945  C   LEU A 121      14.449  80.238  74.932  1.00 33.88           C  
ATOM    946  O   LEU A 121      14.633  79.403  74.045  1.00 34.70           O  
ATOM    947  CB  LEU A 121      16.404  80.899  76.341  1.00 33.66           C  
ATOM    948  CG  LEU A 121      17.173  79.611  76.070  1.00 38.19           C  
ATOM    949  CD1 LEU A 121      18.062  79.759  74.776  1.00 37.65           C  
ATOM    950  CD2 LEU A 121      18.022  79.406  77.287  1.00 40.88           C  
ATOM    951  N   GLN A 122      13.380  80.173  75.722  1.00 33.70           N  
ATOM    952  CA  GLN A 122      12.440  79.102  75.475  1.00 32.02           C  
ATOM    953  C   GLN A 122      11.842  79.214  74.084  1.00 32.82           C  
ATOM    954  O   GLN A 122      11.573  78.203  73.411  1.00 30.09           O  
ATOM    955  CB  GLN A 122      11.321  79.132  76.565  1.00 33.89           C  
ATOM    956  CG  GLN A 122      11.796  78.945  77.981  1.00 37.20           C  
ATOM    957  CD  GLN A 122      12.500  77.618  78.127  1.00 41.25           C  
ATOM    958  OE1 GLN A 122      11.869  76.568  77.984  1.00 41.92           O  
ATOM    959  NE2 GLN A 122      13.800  77.657  78.381  1.00 40.05           N  
ATOM    960  N   LYS A 123      11.385  80.443  73.726  1.00 32.95           N  
ATOM    961  CA  LYS A 123      10.895  80.626  72.398  1.00 34.56           C  
ATOM    962  C   LYS A 123      11.941  80.316  71.356  1.00 35.99           C  
ATOM    963  O   LYS A 123      11.601  79.747  70.348  1.00 35.19           O  
ATOM    964  CB  LYS A 123      10.405  82.043  72.241  1.00 35.85           C  
ATOM    965  CG  LYS A 123       9.340  82.228  73.260  1.00 37.38           C  
ATOM    966  CD  LYS A 123       8.757  83.648  73.260  1.00 48.53           C  
ATOM    967  CE  LYS A 123       7.402  83.513  74.007  1.00 54.30           C  
ATOM    968  NZ  LYS A 123       6.540  84.760  73.877  1.00 66.47           N  
ATOM    969  N   GLU A 124      13.180  80.748  71.582  1.00 30.93           N  
ATOM    970  CA  GLU A 124      14.186  80.522  70.590  1.00 32.92           C  
ATOM    971  C   GLU A 124      14.426  79.030  70.425  1.00 30.97           C  
ATOM    972  O   GLU A 124      14.627  78.537  69.283  1.00 32.93           O  
ATOM    973  CB  GLU A 124      15.508  81.326  70.931  1.00 29.18           C  
ATOM    974  CG  GLU A 124      16.523  81.247  69.808  1.00 34.16           C  
ATOM    975  CD  GLU A 124      16.062  82.157  68.683  1.00 41.07           C  
ATOM    976  OE1 GLU A 124      15.636  83.287  69.016  1.00 46.57           O  
ATOM    977  OE2 GLU A 124      16.051  81.793  67.511  1.00 41.63           O  
ATOM    978  N   ILE A 125      14.395  78.312  71.537  1.00 32.00           N  
ATOM    979  CA  ILE A 125      14.684  76.818  71.428  1.00 31.66           C  
ATOM    980  C   ILE A 125      13.602  76.151  70.648  1.00 33.54           C  
ATOM    981  O   ILE A 125      13.859  75.314  69.762  1.00 32.00           O  
ATOM    982  CB  ILE A 125      14.746  76.207  72.843  1.00 32.20           C  
ATOM    983  CG1 ILE A 125      16.017  76.725  73.555  1.00 33.31           C  
ATOM    984  CG2 ILE A 125      14.546  74.696  72.863  1.00 29.66           C  
ATOM    985  CD1 ILE A 125      15.955  76.245  75.056  1.00 37.01           C  
ATOM    986  N   LEU A 126      12.355  76.616  70.860  1.00 35.37           N  
ATOM    987  CA  LEU A 126      11.280  75.983  70.116  1.00 34.36           C  
ATOM    988  C   LEU A 126      11.371  76.338  68.623  1.00 33.79           C  
ATOM    989  O   LEU A 126      11.086  75.447  67.726  1.00 37.24           O  
ATOM    990  CB  LEU A 126       9.901  76.371  70.749  1.00 34.47           C  
ATOM    991  CG  LEU A 126       9.640  75.605  72.031  1.00 40.07           C  
ATOM    992  CD1 LEU A 126       8.243  75.927  72.613  1.00 45.64           C  
ATOM    993  CD2 LEU A 126       9.785  74.057  71.862  1.00 39.76           C  
ATOM    994  N   SER A 127      11.719  77.611  68.339  1.00 33.07           N  
ATOM    995  CA  SER A 127      11.769  78.107  66.974  1.00 33.53           C  
ATOM    996  C   SER A 127      12.898  77.399  66.202  1.00 35.02           C  
ATOM    997  O   SER A 127      12.704  77.088  65.054  1.00 32.06           O  
ATOM    998  CB  SER A 127      12.003  79.642  66.896  1.00 36.46           C  
ATOM    999  OG  SER A 127      12.469  79.962  65.594  1.00 43.42           O  
ATOM   1000  N   LYS A 128      13.994  77.058  66.896  1.00 33.29           N  
ATOM   1001  CA  LYS A 128      15.173  76.460  66.215  1.00 36.26           C  
ATOM   1002  C   LYS A 128      15.134  74.916  66.081  1.00 34.75           C  
ATOM   1003  O   LYS A 128      15.740  74.317  65.127  1.00 35.44           O  
ATOM   1004  CB  LYS A 128      16.435  76.819  67.053  1.00 33.88           C  
ATOM   1005  CG  LYS A 128      16.907  78.221  66.747  1.00 36.09           C  
ATOM   1006  CD  LYS A 128      18.268  78.395  67.483  1.00 38.94           C  
ATOM   1007  CE  LYS A 128      18.978  79.674  66.886  1.00 41.43           C  
ATOM   1008  NZ  LYS A 128      20.295  79.887  67.573  1.00 42.77           N  
ATOM   1009  N   THR A 129      14.453  74.297  67.008  1.00 34.71           N  
ATOM   1010  CA  THR A 129      14.490  72.842  67.135  1.00 35.05           C  
ATOM   1011  C   THR A 129      13.150  72.156  67.206  1.00 36.35           C  
ATOM   1012  O   THR A 129      13.093  70.958  67.044  1.00 31.74           O  
ATOM   1013  CB  THR A 129      15.214  72.447  68.447  1.00 33.13           C  
ATOM   1014  OG1 THR A 129      14.489  72.831  69.638  1.00 32.62           O  
ATOM   1015  CG2 THR A 129      16.636  73.090  68.585  1.00 34.64           C  
ATOM   1016  N   LEU A 130      12.071  72.897  67.497  1.00 33.84           N  
ATOM   1017  CA  LEU A 130      10.824  72.192  67.881  1.00 37.24           C  
ATOM   1018  C   LEU A 130      10.906  71.162  69.061  1.00 37.34           C  
ATOM   1019  O   LEU A 130      10.013  70.316  69.253  1.00 38.96           O  
ATOM   1020  CB  LEU A 130      10.206  71.539  66.620  1.00 37.44           C  
ATOM   1021  CG  LEU A 130       9.288  72.434  65.781  1.00 39.98           C  
ATOM   1022  CD1 LEU A 130       8.607  71.533  64.672  1.00 42.39           C  
ATOM   1023  CD2 LEU A 130       8.210  73.080  66.640  1.00 42.85           C  
ATOM   1024  N   ASN A 131      11.974  71.216  69.831  1.00 35.85           N  
ATOM   1025  CA  ASN A 131      12.330  70.129  70.676  1.00 31.25           C  
ATOM   1026  C   ASN A 131      11.985  70.415  72.120  1.00 32.67           C  
ATOM   1027  O   ASN A 131      12.689  71.155  72.865  1.00 32.40           O  
ATOM   1028  CB  ASN A 131      13.825  69.643  70.448  1.00 36.09           C  
ATOM   1029  CG  ASN A 131      14.101  68.381  71.240  1.00 37.39           C  
ATOM   1030  OD1 ASN A 131      13.264  68.048  72.089  1.00 38.61           O  
ATOM   1031  ND2 ASN A 131      15.251  67.709  71.041  1.00 35.75           N  
ATOM   1032  N   GLU A 132      10.819  69.884  72.543  1.00 38.23           N  
ATOM   1033  CA  GLU A 132      10.264  70.194  73.889  1.00 40.30           C  
ATOM   1034  C   GLU A 132      11.067  69.592  74.991  1.00 42.00           C  
ATOM   1035  O   GLU A 132      11.030  70.069  76.133  1.00 42.47           O  
ATOM   1036  CB  GLU A 132       8.784  69.733  74.037  1.00 46.94           C  
ATOM   1037  CG  GLU A 132       7.782  70.791  73.531  1.00 56.32           C  
ATOM   1038  CD  GLU A 132       6.370  70.208  73.380  1.00 69.06           C  
ATOM   1039  OE1 GLU A 132       5.988  69.357  74.226  1.00 71.47           O  
ATOM   1040  OE2 GLU A 132       5.634  70.575  72.412  1.00 74.82           O  
ATOM   1041  N   ASP A 133      11.837  68.567  74.678  1.00 39.25           N  
ATOM   1042  CA  ASP A 133      12.780  68.124  75.640  1.00 41.85           C  
ATOM   1043  C   ASP A 133      13.840  69.133  76.076  1.00 41.24           C  
ATOM   1044  O   ASP A 133      14.482  68.927  77.090  1.00 45.82           O  
ATOM   1045  CB  ASP A 133      13.556  66.924  75.118  1.00 41.52           C  
ATOM   1046  CG  ASP A 133      12.698  65.667  74.948  1.00 50.46           C  
ATOM   1047  OD1 ASP A 133      11.498  65.604  75.404  1.00 49.40           O  
ATOM   1048  OD2 ASP A 133      13.205  64.683  74.351  1.00 51.50           O  
ATOM   1049  N   LEU A 134      14.137  70.120  75.266  1.00 39.29           N  
ATOM   1050  CA  LEU A 134      15.133  71.125  75.637  1.00 37.43           C  
ATOM   1051  C   LEU A 134      14.520  72.303  76.406  1.00 38.66           C  
ATOM   1052  O   LEU A 134      15.223  73.229  76.779  1.00 39.95           O  
ATOM   1053  CB  LEU A 134      15.787  71.637  74.345  1.00 37.73           C  
ATOM   1054  CG  LEU A 134      16.551  70.560  73.532  1.00 39.74           C  
ATOM   1055  CD1 LEU A 134      16.999  71.122  72.111  1.00 36.00           C  
ATOM   1056  CD2 LEU A 134      17.785  70.107  74.395  1.00 43.92           C  
ATOM   1057  N   THR A 135      13.215  72.281  76.611  1.00 37.61           N  
ATOM   1058  CA  THR A 135      12.556  73.393  77.312  1.00 39.95           C  
ATOM   1059  C   THR A 135      12.333  73.110  78.815  1.00 41.21           C  
ATOM   1060  O   THR A 135      12.399  71.974  79.284  1.00 41.97           O  
ATOM   1061  CB  THR A 135      11.220  73.780  76.616  1.00 41.61           C  
ATOM   1062  OG1 THR A 135      10.311  72.681  76.664  1.00 45.38           O  
ATOM   1063  CG2 THR A 135      11.504  73.994  75.133  1.00 40.69           C  
ATOM   1064  N   LEU A 136      12.096  74.162  79.552  1.00 40.45           N  
ATOM   1065  CA  LEU A 136      11.771  74.037  80.945  1.00 40.18           C  
ATOM   1066  C   LEU A 136      10.323  73.600  81.024  1.00 46.04           C  
ATOM   1067  O   LEU A 136       9.493  73.967  80.221  1.00 47.46           O  
ATOM   1068  CB  LEU A 136      11.880  75.359  81.630  1.00 38.42           C  
ATOM   1069  CG  LEU A 136      13.260  76.033  81.716  1.00 39.78           C  
ATOM   1070  CD1 LEU A 136      13.249  77.447  82.296  1.00 39.44           C  
ATOM   1071  CD2 LEU A 136      14.216  75.134  82.515  1.00 43.16           C  
ATOM   1072  N   THR A 137      10.029  72.891  82.084  1.00 46.66           N  
ATOM   1073  CA  THR A 137       8.688  72.533  82.431  1.00 49.42           C  
ATOM   1074  C   THR A 137       7.886  73.766  82.899  1.00 49.09           C  
ATOM   1075  O   THR A 137       8.421  74.787  83.402  1.00 43.10           O  
ATOM   1076  CB  THR A 137       8.996  71.551  83.524  1.00 51.34           C  
ATOM   1077  OG1 THR A 137       8.565  70.209  83.210  1.00 56.44           O  
ATOM   1078  CG2 THR A 137       8.613  72.009  84.776  1.00 49.63           C  
ATOM   1079  N   ALA A 138       6.576  73.703  82.762  1.00 48.16           N  
ATOM   1080  CA  ALA A 138       5.806  74.806  83.260  1.00 47.99           C  
ATOM   1081  C   ALA A 138       5.942  74.931  84.796  1.00 49.47           C  
ATOM   1082  O   ALA A 138       5.904  76.035  85.328  1.00 48.63           O  
ATOM   1083  CB  ALA A 138       4.355  74.671  82.848  1.00 52.98           C  
ATOM   1084  N   GLU A 139       6.200  73.820  85.501  1.00 48.39           N  
ATOM   1085  CA  GLU A 139       6.249  73.907  86.931  1.00 49.07           C  
ATOM   1086  C   GLU A 139       7.563  74.550  87.335  1.00 47.33           C  
ATOM   1087  O   GLU A 139       7.620  75.251  88.335  1.00 45.29           O  
ATOM   1088  CB  GLU A 139       6.063  72.538  87.633  1.00 51.03           C  
ATOM   1089  CG  GLU A 139       4.820  71.752  87.202  1.00 58.08           C  
ATOM   1090  CD  GLU A 139       5.046  71.093  85.844  1.00 64.50           C  
ATOM   1091  OE1 GLU A 139       5.794  70.046  85.753  1.00 69.10           O  
ATOM   1092  OE2 GLU A 139       4.535  71.663  84.861  1.00 63.63           O  
ATOM   1093  N   SER A 140       8.632  74.340  86.563  1.00 45.60           N  
ATOM   1094  CA  SER A 140       9.900  74.967  86.933  1.00 40.22           C  
ATOM   1095  C   SER A 140       9.752  76.473  86.741  1.00 39.62           C  
ATOM   1096  O   SER A 140      10.218  77.217  87.542  1.00 40.69           O  
ATOM   1097  CB  SER A 140      11.045  74.364  86.161  1.00 40.76           C  
ATOM   1098  OG  SER A 140      10.907  74.605  84.764  1.00 42.02           O  
ATOM   1099  N   ILE A 141       9.114  76.934  85.689  1.00 36.89           N  
ATOM   1100  CA  ILE A 141       9.072  78.405  85.494  1.00 41.29           C  
ATOM   1101  C   ILE A 141       8.282  79.003  86.674  1.00 43.01           C  
ATOM   1102  O   ILE A 141       8.669  79.979  87.295  1.00 42.59           O  
ATOM   1103  CB  ILE A 141       8.464  78.740  84.147  1.00 37.55           C  
ATOM   1104  CG1 ILE A 141       9.440  78.181  83.086  1.00 41.24           C  
ATOM   1105  CG2 ILE A 141       8.199  80.269  83.986  1.00 38.29           C  
ATOM   1106  CD1 ILE A 141       8.970  78.142  81.589  1.00 37.62           C  
ATOM   1107  N   LEU A 142       7.183  78.344  87.016  1.00 45.87           N  
ATOM   1108  CA  LEU A 142       6.378  78.779  88.162  1.00 47.06           C  
ATOM   1109  C   LEU A 142       7.240  78.864  89.423  1.00 43.93           C  
ATOM   1110  O   LEU A 142       7.200  79.856  90.113  1.00 42.61           O  
ATOM   1111  CB  LEU A 142       5.212  77.800  88.356  1.00 49.45           C  
ATOM   1112  CG  LEU A 142       3.770  78.280  88.064  1.00 56.57           C  
ATOM   1113  CD1 LEU A 142       3.577  79.361  86.985  1.00 56.69           C  
ATOM   1114  CD2 LEU A 142       2.731  77.037  87.913  1.00 55.31           C  
ATOM   1115  N   ALA A 143       8.042  77.827  89.723  1.00 42.77           N  
ATOM   1116  CA  ALA A 143       8.890  77.874  90.891  1.00 39.62           C  
ATOM   1117  C   ALA A 143       9.980  78.977  90.780  1.00 37.76           C  
ATOM   1118  O   ALA A 143      10.378  79.552  91.780  1.00 42.72           O  
ATOM   1119  CB  ALA A 143       9.601  76.496  91.095  1.00 39.21           C  
ATOM   1120  N   ILE A 144      10.484  79.227  89.570  1.00 35.42           N  
ATOM   1121  CA  ILE A 144      11.486  80.292  89.402  1.00 35.43           C  
ATOM   1122  C   ILE A 144      10.808  81.595  89.739  1.00 36.33           C  
ATOM   1123  O   ILE A 144      11.352  82.415  90.424  1.00 35.88           O  
ATOM   1124  CB  ILE A 144      11.984  80.289  87.933  1.00 32.54           C  
ATOM   1125  CG1 ILE A 144      13.011  79.153  87.821  1.00 34.68           C  
ATOM   1126  CG2 ILE A 144      12.578  81.585  87.561  1.00 32.35           C  
ATOM   1127  CD1 ILE A 144      13.281  78.759  86.356  1.00 37.07           C  
ATOM   1128  N   ASP A 145       9.609  81.798  89.208  1.00 35.76           N  
ATOM   1129  CA  ASP A 145       8.987  83.134  89.430  1.00 39.49           C  
ATOM   1130  C   ASP A 145       8.662  83.325  90.933  1.00 39.17           C  
ATOM   1131  O   ASP A 145       8.827  84.404  91.484  1.00 41.25           O  
ATOM   1132  CB  ASP A 145       7.717  83.228  88.593  1.00 41.61           C  
ATOM   1133  CG  ASP A 145       7.993  83.551  87.107  1.00 54.12           C  
ATOM   1134  OD1 ASP A 145       9.205  83.745  86.668  1.00 55.60           O  
ATOM   1135  OD2 ASP A 145       7.022  83.623  86.274  1.00 58.19           O  
ATOM   1136  N   ASP A 146       8.300  82.236  91.592  1.00 39.78           N  
ATOM   1137  CA  ASP A 146       7.818  82.283  92.995  1.00 40.96           C  
ATOM   1138  C   ASP A 146       8.986  82.580  93.865  1.00 39.60           C  
ATOM   1139  O   ASP A 146       8.928  83.386  94.836  1.00 37.73           O  
ATOM   1140  CB  ASP A 146       7.169  80.941  93.366  1.00 44.04           C  
ATOM   1141  CG  ASP A 146       6.388  80.993  94.695  1.00 45.56           C  
ATOM   1142  OD1 ASP A 146       5.906  82.072  95.078  1.00 46.99           O  
ATOM   1143  OD2 ASP A 146       6.175  79.993  95.390  1.00 48.37           O  
ATOM   1144  N   THR A 147      10.110  81.893  93.576  1.00 35.40           N  
ATOM   1145  CA  THR A 147      11.242  82.198  94.406  1.00 37.08           C  
ATOM   1146  C   THR A 147      11.739  83.560  94.222  1.00 34.66           C  
ATOM   1147  O   THR A 147      12.120  84.246  95.173  1.00 39.03           O  
ATOM   1148  CB  THR A 147      12.387  81.275  93.917  1.00 37.03           C  
ATOM   1149  OG1 THR A 147      11.855  79.973  94.006  1.00 39.24           O  
ATOM   1150  CG2 THR A 147      13.508  81.343  94.847  1.00 37.95           C  
ATOM   1151  N   TYR A 148      11.807  83.990  92.979  1.00 36.17           N  
ATOM   1152  CA  TYR A 148      12.280  85.317  92.756  1.00 35.22           C  
ATOM   1153  C   TYR A 148      11.362  86.338  93.505  1.00 37.15           C  
ATOM   1154  O   TYR A 148      11.847  87.333  94.113  1.00 36.89           O  
ATOM   1155  CB  TYR A 148      12.198  85.603  91.259  1.00 36.35           C  
ATOM   1156  CG  TYR A 148      12.360  87.047  90.841  1.00 33.85           C  
ATOM   1157  CD1 TYR A 148      13.636  87.633  90.698  1.00 31.48           C  
ATOM   1158  CD2 TYR A 148      11.238  87.870  90.584  1.00 34.85           C  
ATOM   1159  CE1 TYR A 148      13.785  88.994  90.295  1.00 33.37           C  
ATOM   1160  CE2 TYR A 148      11.414  89.148  90.207  1.00 35.50           C  
ATOM   1161  CZ  TYR A 148      12.625  89.730  90.055  1.00 38.54           C  
ATOM   1162  OH  TYR A 148      12.787  91.057  89.671  1.00 36.42           O  
ATOM   1163  N   ASN A 149      10.040  86.180  93.354  1.00 35.35           N  
ATOM   1164  CA  ASN A 149       9.174  87.184  93.997  1.00 36.83           C  
ATOM   1165  C   ASN A 149       9.407  87.232  95.520  1.00 34.52           C  
ATOM   1166  O   ASN A 149       9.453  88.273  96.117  1.00 37.59           O  
ATOM   1167  CB  ASN A 149       7.692  86.851  93.702  1.00 36.09           C  
ATOM   1168  CG  ASN A 149       7.296  87.071  92.253  1.00 38.78           C  
ATOM   1169  OD1 ASN A 149       7.914  87.866  91.498  1.00 42.25           O  
ATOM   1170  ND2 ASN A 149       6.218  86.341  91.826  1.00 40.25           N  
ATOM   1171  N   HIS A 150       9.651  86.104  96.148  1.00 37.17           N  
ATOM   1172  CA  HIS A 150       9.885  86.100  97.571  1.00 38.36           C  
ATOM   1173  C   HIS A 150      11.246  86.657  97.986  1.00 37.17           C  
ATOM   1174  O   HIS A 150      11.367  87.204  99.082  1.00 35.15           O  
ATOM   1175  CB  HIS A 150       9.642  84.699  98.111  1.00 40.77           C  
ATOM   1176  CG  HIS A 150       8.193  84.407  98.258  1.00 44.87           C  
ATOM   1177  ND1 HIS A 150       7.417  83.929  97.218  1.00 47.05           N  
ATOM   1178  CD2 HIS A 150       7.341  84.627  99.298  1.00 51.17           C  
ATOM   1179  CE1 HIS A 150       6.152  83.850  97.621  1.00 52.32           C  
ATOM   1180  NE2 HIS A 150       6.080  84.263  98.876  1.00 51.32           N  
ATOM   1181  N   PHE A 151      12.310  86.502  97.163  1.00 39.20           N  
ATOM   1182  CA  PHE A 151      13.566  87.138  97.507  1.00 33.98           C  
ATOM   1183  C   PHE A 151      13.425  88.674  97.307  1.00 34.36           C  
ATOM   1184  O   PHE A 151      14.037  89.451  97.983  1.00 34.27           O  
ATOM   1185  CB  PHE A 151      14.699  86.639  96.623  1.00 36.21           C  
ATOM   1186  CG  PHE A 151      15.403  85.427  97.258  1.00 32.56           C  
ATOM   1187  CD1 PHE A 151      14.828  84.189  97.167  1.00 34.97           C  
ATOM   1188  CD2 PHE A 151      16.537  85.616  98.058  1.00 36.46           C  
ATOM   1189  CE1 PHE A 151      15.509  83.018  97.754  1.00 33.84           C  
ATOM   1190  CE2 PHE A 151      17.161  84.513  98.713  1.00 33.47           C  
ATOM   1191  CZ  PHE A 151      16.583  83.234  98.565  1.00 30.48           C  
ATOM   1192  N   VAL A 152      12.688  89.055  96.303  1.00 33.19           N  
ATOM   1193  CA  VAL A 152      12.455  90.482  96.080  1.00 35.92           C  
ATOM   1194  C   VAL A 152      11.745  90.999  97.353  1.00 35.92           C  
ATOM   1195  O   VAL A 152      12.145  92.013  97.907  1.00 40.48           O  
ATOM   1196  CB  VAL A 152      11.533  90.714  94.905  1.00 35.62           C  
ATOM   1197  CG1 VAL A 152      10.935  92.140  94.926  1.00 35.56           C  
ATOM   1198  CG2 VAL A 152      12.221  90.445  93.538  1.00 36.54           C  
ATOM   1199  N   LYS A 153      10.659  90.352  97.764  1.00 40.96           N  
ATOM   1200  CA  LYS A 153       9.908  90.837  98.970  1.00 39.27           C  
ATOM   1201  C   LYS A 153      10.776  90.781 100.214  1.00 40.12           C  
ATOM   1202  O   LYS A 153      10.795  91.716 101.016  1.00 38.28           O  
ATOM   1203  CB  LYS A 153       8.635  90.037  99.191  1.00 40.16           C  
ATOM   1204  CG  LYS A 153       7.798  90.581 100.345  1.00 48.24           C  
ATOM   1205  CD  LYS A 153       7.363  92.047 100.035  1.00 53.35           C  
ATOM   1206  CE  LYS A 153       6.380  92.637 101.086  1.00 57.61           C  
ATOM   1207  NZ  LYS A 153       5.926  94.010 100.611  1.00 56.79           N  
ATOM   1208  N   PHE A 154      11.585  89.711 100.376  1.00 36.42           N  
ATOM   1209  CA  PHE A 154      12.483  89.730 101.503  1.00 36.33           C  
ATOM   1210  C   PHE A 154      13.380  90.922 101.493  1.00 36.58           C  
ATOM   1211  O   PHE A 154      13.624  91.526 102.548  1.00 37.17           O  
ATOM   1212  CB  PHE A 154      13.273  88.388 101.593  1.00 37.57           C  
ATOM   1213  CG  PHE A 154      14.263  88.358 102.645  1.00 40.26           C  
ATOM   1214  CD1 PHE A 154      13.881  88.405 104.018  1.00 40.28           C  
ATOM   1215  CD2 PHE A 154      15.618  88.187 102.319  1.00 44.17           C  
ATOM   1216  CE1 PHE A 154      14.879  88.328 105.043  1.00 40.80           C  
ATOM   1217  CE2 PHE A 154      16.596  88.118 103.319  1.00 42.07           C  
ATOM   1218  CZ  PHE A 154      16.220  88.179 104.689  1.00 39.96           C  
ATOM   1219  N   SER A 155      13.952  91.249 100.328  1.00 38.45           N  
ATOM   1220  CA  SER A 155      14.913  92.323 100.216  1.00 38.13           C  
ATOM   1221  C   SER A 155      14.155  93.646 100.557  1.00 39.13           C  
ATOM   1222  O   SER A 155      14.629  94.478 101.285  1.00 34.40           O  
ATOM   1223  CB  SER A 155      15.443  92.382  98.753  1.00 39.48           C  
ATOM   1224  OG  SER A 155      16.186  91.150  98.423  1.00 42.60           O  
ATOM   1225  N   GLN A 156      12.986  93.828  99.976  1.00 41.86           N  
ATOM   1226  CA  GLN A 156      12.219  95.031 100.301  1.00 43.94           C  
ATOM   1227  C   GLN A 156      12.023  95.087 101.826  1.00 43.57           C  
ATOM   1228  O   GLN A 156      12.185  96.131 102.404  1.00 47.94           O  
ATOM   1229  CB  GLN A 156      10.872  94.949  99.584  1.00 44.54           C  
ATOM   1230  CG  GLN A 156      10.028  96.155  99.803  1.00 52.69           C  
ATOM   1231  CD  GLN A 156       8.632  95.966  99.293  1.00 57.39           C  
ATOM   1232  OE1 GLN A 156       8.094  94.855  99.288  1.00 62.54           O  
ATOM   1233  NE2 GLN A 156       8.052  97.047  98.807  1.00 61.55           N  
ATOM   1234  N   TRP A 157      11.696  93.949 102.457  1.00 43.76           N  
ATOM   1235  CA  TRP A 157      11.441  93.839 103.894  1.00 41.38           C  
ATOM   1236  C   TRP A 157      12.614  94.292 104.748  1.00 45.57           C  
ATOM   1237  O   TRP A 157      12.467  95.180 105.617  1.00 42.56           O  
ATOM   1238  CB  TRP A 157      10.901  92.442 104.320  1.00 44.23           C  
ATOM   1239  CG  TRP A 157      10.838  92.435 105.814  1.00 48.92           C  
ATOM   1240  CD1 TRP A 157       9.874  93.094 106.623  1.00 48.53           C  
ATOM   1241  CD2 TRP A 157      11.841  91.947 106.702  1.00 46.92           C  
ATOM   1242  NE1 TRP A 157      10.268  93.018 107.938  1.00 50.37           N  
ATOM   1243  CE2 TRP A 157      11.466  92.337 108.023  1.00 48.27           C  
ATOM   1244  CE3 TRP A 157      13.075  91.297 106.522  1.00 43.69           C  
ATOM   1245  CZ2 TRP A 157      12.233  92.002 109.147  1.00 50.65           C  
ATOM   1246  CZ3 TRP A 157      13.852  90.991 107.646  1.00 46.88           C  
ATOM   1247  CH2 TRP A 157      13.432  91.331 108.947  1.00 48.34           C  
ATOM   1248  N   MET A 158      13.825  93.739 104.492  1.00 39.48           N  
ATOM   1249  CA  MET A 158      14.984  94.243 105.164  1.00 39.14           C  
ATOM   1250  C   MET A 158      15.217  95.737 105.029  1.00 40.65           C  
ATOM   1251  O   MET A 158      15.577  96.410 106.020  1.00 43.06           O  
ATOM   1252  CB  MET A 158      16.214  93.510 104.565  1.00 37.27           C  
ATOM   1253  CG  MET A 158      16.071  92.089 104.864  1.00 35.96           C  
ATOM   1254  SD  MET A 158      17.957  91.468 104.651  1.00 47.57           S  
ATOM   1255  CE  MET A 158      18.017  91.438 102.886  1.00 38.03           C  
ATOM   1256  N   ILE A 159      15.050  96.258 103.821  1.00 39.32           N  
ATOM   1257  CA  ILE A 159      15.459  97.600 103.527  1.00 41.51           C  
ATOM   1258  C   ILE A 159      14.456  98.580 104.201  1.00 44.15           C  
ATOM   1259  O   ILE A 159      14.866  99.496 104.968  1.00 41.71           O  
ATOM   1260  CB  ILE A 159      15.489  97.766 102.020  1.00 43.24           C  
ATOM   1261  CG1 ILE A 159      16.796  97.117 101.481  1.00 39.51           C  
ATOM   1262  CG2 ILE A 159      15.476  99.188 101.614  1.00 39.99           C  
ATOM   1263  CD1 ILE A 159      16.811  96.999  99.911  1.00 41.24           C  
ATOM   1264  N   GLU A 160      13.163  98.311 103.976  1.00 45.30           N  
ATOM   1265  CA  GLU A 160      12.091  99.186 104.510  1.00 48.60           C  
ATOM   1266  C   GLU A 160      11.890  99.054 106.017  1.00 49.11           C  
ATOM   1267  O   GLU A 160      11.695 100.045 106.657  1.00 50.48           O  
ATOM   1268  CB  GLU A 160      10.771  98.926 103.783  1.00 47.88           C  
ATOM   1269  CG  GLU A 160      10.769  99.449 102.375  1.00 55.93           C  
ATOM   1270  CD  GLU A 160      10.930 100.967 102.320  1.00 65.94           C  
ATOM   1271  OE1 GLU A 160      12.007 101.471 101.926  1.00 66.14           O  
ATOM   1272  OE2 GLU A 160       9.941 101.681 102.679  1.00 74.17           O  
ATOM   1273  N   SER A 161      12.020  97.852 106.606  1.00 48.16           N  
ATOM   1274  CA  SER A 161      11.907  97.711 108.045  1.00 47.48           C  
ATOM   1275  C   SER A 161      13.028  98.445 108.798  1.00 49.24           C  
ATOM   1276  O   SER A 161      12.847  98.797 109.942  1.00 48.14           O  
ATOM   1277  CB  SER A 161      11.783  96.235 108.504  1.00 47.14           C  
ATOM   1278  OG  SER A 161      13.076  95.610 108.547  1.00 49.00           O  
ATOM   1279  N   LEU A 162      14.172  98.708 108.155  1.00 47.24           N  
ATOM   1280  CA  LEU A 162      15.240  99.506 108.749  1.00 47.08           C  
ATOM   1281  C   LEU A 162      15.229 100.933 108.257  1.00 47.73           C  
ATOM   1282  O   LEU A 162      16.080 101.701 108.637  1.00 48.51           O  
ATOM   1283  CB  LEU A 162      16.642  98.885 108.482  1.00 46.30           C  
ATOM   1284  CG  LEU A 162      16.699  97.465 109.087  1.00 46.94           C  
ATOM   1285  CD1 LEU A 162      17.968  96.733 108.797  1.00 49.49           C  
ATOM   1286  CD2 LEU A 162      16.443  97.445 110.637  1.00 51.05           C  
ATOM   1287  N   ARG A 163      14.293 101.290 107.384  1.00 49.69           N  
ATOM   1288  CA  ARG A 163      14.311 102.620 106.787  1.00 51.17           C  
ATOM   1289  C   ARG A 163      15.657 102.945 106.164  1.00 51.83           C  
ATOM   1290  O   ARG A 163      16.124 104.070 106.305  1.00 49.76           O  
ATOM   1291  CB  ARG A 163      13.968 103.684 107.849  1.00 54.12           C  
ATOM   1292  CG  ARG A 163      12.474 103.747 108.129  1.00 62.41           C  
ATOM   1293  CD  ARG A 163      12.016 105.062 108.817  1.00 74.71           C  
ATOM   1294  NE  ARG A 163      12.824 105.380 110.005  1.00 82.58           N  
ATOM   1295  CZ  ARG A 163      12.336 105.585 111.232  1.00 85.94           C  
ATOM   1296  NH1 ARG A 163      11.021 105.519 111.459  1.00 86.88           N  
ATOM   1297  NH2 ARG A 163      13.168 105.874 112.235  1.00 85.84           N  
ATOM   1298  N   ILE A 164      16.284 101.973 105.479  1.00 49.72           N  
ATOM   1299  CA  ILE A 164      17.545 102.253 104.759  1.00 48.27           C  
ATOM   1300  C   ILE A 164      17.345 102.458 103.243  1.00 48.76           C  
ATOM   1301  O   ILE A 164      18.304 102.518 102.486  1.00 48.86           O  
ATOM   1302  CB  ILE A 164      18.643 101.168 105.076  1.00 49.65           C  
ATOM   1303  CG1 ILE A 164      18.178  99.757 104.739  1.00 47.93           C  
ATOM   1304  CG2 ILE A 164      19.019 101.239 106.578  1.00 52.06           C  
ATOM   1305  CD1 ILE A 164      19.200  98.634 105.232  1.00 48.91           C  
ATOM   1306  N   GLY A 165      16.099 102.602 102.815  1.00 46.08           N  
ATOM   1307  CA  GLY A 165      15.791 102.613 101.403  1.00 49.47           C  
ATOM   1308  C   GLY A 165      16.138 103.932 100.761  1.00 51.12           C  
ATOM   1309  O   GLY A 165      16.271 104.941 101.445  1.00 53.21           O  
ATOM   1310  N   SER A 166      16.328 103.920  99.452  1.00 51.68           N  
ATOM   1311  CA  SER A 166      16.643 105.133  98.689  1.00 50.86           C  
ATOM   1312  C   SER A 166      16.426 104.751  97.249  1.00 51.00           C  
ATOM   1313  O   SER A 166      16.284 103.545  96.960  1.00 48.14           O  
ATOM   1314  CB  SER A 166      18.062 105.630  98.914  1.00 51.86           C  
ATOM   1315  OG  SER A 166      19.042 104.769  98.335  1.00 55.48           O  
ATOM   1316  N   ASN A 167      16.325 105.748  96.359  1.00 47.73           N  
ATOM   1317  CA  ASN A 167      16.293 105.470  94.941  1.00 49.41           C  
ATOM   1318  C   ASN A 167      17.377 104.430  94.486  1.00 48.50           C  
ATOM   1319  O   ASN A 167      17.168 103.669  93.553  1.00 48.46           O  
ATOM   1320  CB  ASN A 167      16.529 106.774  94.218  1.00 50.74           C  
ATOM   1321  CG  ASN A 167      15.396 107.785  94.491  1.00 58.07           C  
ATOM   1322  OD1 ASN A 167      14.380 107.724  93.852  1.00 63.75           O  
ATOM   1323  ND2 ASN A 167      15.565 108.639  95.495  1.00 62.00           N  
ATOM   1324  N   LEU A 168      18.528 104.476  95.122  1.00 46.44           N  
ATOM   1325  CA  LEU A 168      19.674 103.682  94.694  1.00 48.01           C  
ATOM   1326  C   LEU A 168      19.601 102.229  95.163  1.00 48.50           C  
ATOM   1327  O   LEU A 168      20.458 101.407  94.794  1.00 53.49           O  
ATOM   1328  CB  LEU A 168      20.941 104.338  95.240  1.00 47.95           C  
ATOM   1329  CG  LEU A 168      21.182 105.806  94.859  1.00 51.36           C  
ATOM   1330  CD1 LEU A 168      22.576 106.233  95.315  1.00 53.93           C  
ATOM   1331  CD2 LEU A 168      21.022 106.091  93.363  1.00 49.94           C  
ATOM   1332  N   LEU A 169      18.648 101.910  96.021  1.00 44.62           N  
ATOM   1333  CA  LEU A 169      18.522 100.582  96.562  1.00 46.40           C  
ATOM   1334  C   LEU A 169      17.135 100.031  96.082  1.00 45.75           C  
ATOM   1335  O   LEU A 169      16.722  98.909  96.377  1.00 47.97           O  
ATOM   1336  CB  LEU A 169      18.707 100.684  98.079  1.00 44.45           C  
ATOM   1337  CG  LEU A 169      19.478  99.714  98.925  1.00 53.39           C  
ATOM   1338  CD1 LEU A 169      20.854  99.501  98.372  1.00 48.97           C  
ATOM   1339  CD2 LEU A 169      19.536 100.080 100.405  1.00 51.26           C  
ATOM   1340  N   ASP A 170      16.407 100.820  95.282  1.00 44.55           N  
ATOM   1341  CA  ASP A 170      15.103 100.352  94.814  1.00 44.11           C  
ATOM   1342  C   ASP A 170      15.275  99.230  93.758  1.00 41.51           C  
ATOM   1343  O   ASP A 170      16.153  99.302  92.898  1.00 40.84           O  
ATOM   1344  CB  ASP A 170      14.310 101.487  94.098  1.00 45.08           C  
ATOM   1345  CG  ASP A 170      13.660 102.500  95.054  1.00 49.63           C  
ATOM   1346  OD1 ASP A 170      13.421 102.233  96.273  1.00 49.29           O  
ATOM   1347  OD2 ASP A 170      13.326 103.608  94.608  1.00 49.17           O  
ATOM   1348  N   LEU A 171      14.371  98.254  93.803  1.00 38.92           N  
ATOM   1349  CA  LEU A 171      14.230  97.227  92.787  1.00 40.98           C  
ATOM   1350  C   LEU A 171      13.239  97.601  91.721  1.00 40.73           C  
ATOM   1351  O   LEU A 171      12.114  98.033  92.067  1.00 42.58           O  
ATOM   1352  CB  LEU A 171      13.738  95.980  93.455  1.00 38.72           C  
ATOM   1353  CG  LEU A 171      14.843  95.285  94.294  1.00 43.68           C  
ATOM   1354  CD1 LEU A 171      14.172  94.317  95.148  1.00 41.52           C  
ATOM   1355  CD2 LEU A 171      15.788  94.579  93.301  1.00 37.96           C  
ATOM   1356  N   GLU A 172      13.625  97.358  90.471  1.00 41.44           N  
ATOM   1357  CA  GLU A 172      12.765  97.507  89.276  1.00 40.24           C  
ATOM   1358  C   GLU A 172      11.394  96.987  89.398  1.00 43.91           C  
ATOM   1359  O   GLU A 172      10.422  97.791  89.199  1.00 40.99           O  
ATOM   1360  CB  GLU A 172      13.393  97.109  87.951  1.00 41.37           C  
ATOM   1361  CG  GLU A 172      12.665  97.655  86.708  1.00 43.89           C  
ATOM   1362  CD  GLU A 172      13.124  97.045  85.394  1.00 52.65           C  
ATOM   1363  OE1 GLU A 172      14.104  96.255  85.381  1.00 49.18           O  
ATOM   1364  OE2 GLU A 172      12.500  97.311  84.351  1.00 49.88           O  
ATOM   1365  N   VAL A 173      11.254  95.737  89.783  1.00 37.46           N  
ATOM   1366  CA  VAL A 173       9.960  95.114  89.782  1.00 41.74           C  
ATOM   1367  C   VAL A 173       8.990  95.774  90.835  1.00 46.20           C  
ATOM   1368  O   VAL A 173       7.778  95.772  90.620  1.00 44.72           O  
ATOM   1369  CB  VAL A 173       9.982  93.572  89.964  1.00 42.44           C  
ATOM   1370  CG1 VAL A 173      10.315  93.149  91.393  1.00 43.40           C  
ATOM   1371  CG2 VAL A 173       8.688  92.941  89.506  1.00 43.34           C  
ATOM   1372  N   VAL A 174       9.535  96.266  91.944  1.00 46.64           N  
ATOM   1373  CA  VAL A 174       8.734  96.820  93.044  1.00 48.57           C  
ATOM   1374  C   VAL A 174       8.262  98.203  92.565  1.00 49.59           C  
ATOM   1375  O   VAL A 174       7.059  98.544  92.619  1.00 50.08           O  
ATOM   1376  CB  VAL A 174       9.573  96.927  94.370  1.00 47.15           C  
ATOM   1377  CG1 VAL A 174       8.845  97.879  95.405  1.00 52.54           C  
ATOM   1378  CG2 VAL A 174       9.808  95.553  94.972  1.00 47.56           C  
ATOM   1379  N   GLN A 175       9.205  98.988  92.060  1.00 48.14           N  
ATOM   1380  CA  GLN A 175       8.859 100.291  91.500  1.00 50.46           C  
ATOM   1381  C   GLN A 175       7.846 100.217  90.375  1.00 52.73           C  
ATOM   1382  O   GLN A 175       6.959 101.130  90.259  1.00 52.33           O  
ATOM   1383  CB  GLN A 175      10.103 101.076  91.066  1.00 48.93           C  
ATOM   1384  CG  GLN A 175      10.991 101.478  92.284  1.00 51.00           C  
ATOM   1385  CD  GLN A 175      10.230 102.412  93.249  1.00 55.63           C  
ATOM   1386  OE1 GLN A 175       9.864 103.515  92.844  1.00 54.49           O  
ATOM   1387  NE2 GLN A 175       9.986 101.964  94.497  1.00 49.46           N  
ATOM   1388  N   PHE A 176       7.985  99.178  89.540  1.00 51.54           N  
ATOM   1389  CA  PHE A 176       7.034  98.880  88.490  1.00 53.97           C  
ATOM   1390  C   PHE A 176       5.632  98.605  89.049  1.00 55.91           C  
ATOM   1391  O   PHE A 176       4.668  99.158  88.517  1.00 53.87           O  
ATOM   1392  CB  PHE A 176       7.489  97.728  87.625  1.00 52.92           C  
ATOM   1393  CG  PHE A 176       6.592  97.464  86.476  1.00 57.97           C  
ATOM   1394  CD1 PHE A 176       6.485  98.378  85.441  1.00 61.13           C  
ATOM   1395  CD2 PHE A 176       5.814  96.303  86.427  1.00 62.05           C  
ATOM   1396  CE1 PHE A 176       5.617  98.114  84.358  1.00 63.83           C  
ATOM   1397  CE2 PHE A 176       4.956  96.060  85.352  1.00 61.94           C  
ATOM   1398  CZ  PHE A 176       4.872  96.959  84.326  1.00 61.29           C  
ATOM   1399  N   ALA A 177       5.522  97.751  90.080  1.00 56.03           N  
ATOM   1400  CA  ALA A 177       4.260  97.461  90.736  1.00 59.23           C  
ATOM   1401  C   ALA A 177       3.660  98.738  91.350  1.00 62.94           C  
ATOM   1402  O   ALA A 177       2.449  98.962  91.247  1.00 63.52           O  
ATOM   1403  CB  ALA A 177       4.430  96.458  91.799  1.00 57.57           C  
ATOM   1404  N   ILE A 178       4.497  99.540  91.999  1.00 65.29           N  
ATOM   1405  CA  ILE A 178       4.061 100.808  92.563  1.00 68.93           C  
ATOM   1406  C   ILE A 178       3.528 101.665  91.424  1.00 72.41           C  
ATOM   1407  O   ILE A 178       2.318 101.838  91.354  1.00 74.24           O  
ATOM   1408  CB  ILE A 178       5.159 101.485  93.474  1.00 68.19           C  
ATOM   1409  CG1 ILE A 178       5.333 100.666  94.756  1.00 66.33           C  
ATOM   1410  CG2 ILE A 178       4.781 102.920  93.835  1.00 68.44           C  
ATOM   1411  CD1 ILE A 178       6.683 100.839  95.484  1.00 67.51           C  
ATOM   1412  N   LYS A 179       4.384 102.124  90.511  1.00 75.10           N  
ATOM   1413  CA  LYS A 179       3.970 102.939  89.345  1.00 79.36           C  
ATOM   1414  C   LYS A 179       2.718 102.446  88.597  1.00 81.22           C  
ATOM   1415  O   LYS A 179       2.003 103.234  87.940  1.00 81.78           O  
ATOM   1416  CB  LYS A 179       5.124 103.132  88.344  1.00 79.79           C  
ATOM   1417  CG  LYS A 179       5.155 104.505  87.712  1.00 82.69           C  
ATOM   1418  CD  LYS A 179       5.772 104.502  86.299  1.00 85.50           C  
ATOM   1419  CE  LYS A 179       4.780 105.045  85.267  1.00 87.02           C  
ATOM   1420  NZ  LYS A 179       5.374 105.158  83.903  1.00 88.21           N  
ATOM   1421  N   SER A 180       2.449 101.153  88.706  1.00 83.11           N  
ATOM   1422  CA  SER A 180       1.201 100.605  88.233  1.00 85.55           C  
ATOM   1423  C   SER A 180       0.071 100.929  89.241  1.00 88.31           C  
ATOM   1424  O   SER A 180      -0.900 100.174  89.347  1.00 88.68           O  
ATOM   1425  CB  SER A 180       1.342  99.108  87.924  1.00 84.69           C  
ATOM   1426  OG  SER A 180       2.181  98.900  86.789  1.00 83.20           O  
ATOM   1427  N   ALA A 181       0.241 102.046  89.978  1.00 91.61           N  
ATOM   1428  CA  ALA A 181      -0.824 102.753  90.740  1.00 94.41           C  
ATOM   1429  C   ALA A 181      -1.400 103.871  89.872  1.00 96.12           C  
ATOM   1430  O   ALA A 181      -1.183 105.064  90.124  1.00 95.70           O  
ATOM   1431  CB  ALA A 181      -0.295 103.337  92.061  1.00 94.45           C  
ATOM   1432  N   ASP A 182      -2.095 103.433  88.824  1.00 98.81           N  
ATOM   1433  CA  ASP A 182      -2.857 104.260  87.904  1.00101.35           C  
ATOM   1434  C   ASP A 182      -4.227 103.614  87.853  1.00102.62           C  
ATOM   1435  O   ASP A 182      -4.955 103.727  86.863  1.00103.03           O  
ATOM   1436  CB  ASP A 182      -2.214 104.243  86.517  1.00101.73           C  
ATOM   1437  CG  ASP A 182      -0.912 105.019  86.469  1.00102.87           C  
ATOM   1438  OD1 ASP A 182      -0.644 105.798  87.413  1.00103.81           O  
ATOM   1439  OD2 ASP A 182      -0.093 104.915  85.526  1.00103.45           O  
ATOM   1440  N   GLU A 183      -4.547 102.905  88.935  1.00104.06           N  
ATOM   1441  CA  GLU A 183      -5.839 102.253  89.129  1.00105.26           C  
ATOM   1442  C   GLU A 183      -6.198 102.273  90.617  1.00105.00           C  
ATOM   1443  O   GLU A 183      -5.918 103.253  91.315  1.00104.56           O  
ATOM   1444  CB  GLU A 183      -5.809 100.816  88.587  1.00105.85           C  
ATOM   1445  CG  GLU A 183      -4.580 100.508  87.733  1.00107.45           C  
ATOM   1446  CD  GLU A 183      -4.844  99.476  86.648  1.00109.49           C  
ATOM   1447  OE1 GLU A 183      -5.600  99.781  85.692  1.00110.29           O  
ATOM   1448  OE2 GLU A 183      -4.288  98.358  86.747  1.00109.30           O  
ATOM   1449  N   ASP A 192      -3.680  89.790  96.712  1.00 84.34           N  
ATOM   1450  CA  ASP A 192      -2.544  88.885  96.537  1.00 84.92           C  
ATOM   1451  C   ASP A 192      -1.341  89.634  95.968  1.00 83.32           C  
ATOM   1452  O   ASP A 192      -0.477  89.028  95.319  1.00 83.79           O  
ATOM   1453  CB  ASP A 192      -2.910  87.750  95.581  1.00 85.98           C  
ATOM   1454  CG  ASP A 192      -3.651  86.613  96.274  1.00 89.76           C  
ATOM   1455  OD1 ASP A 192      -3.423  86.370  97.495  1.00 90.33           O  
ATOM   1456  OD2 ASP A 192      -4.485  85.911  95.650  1.00 91.01           O  
ATOM   1457  N   ASN A 193      -1.313  90.938  96.269  1.00 80.79           N  
ATOM   1458  CA  ASN A 193      -0.586  92.004  95.564  1.00 78.06           C  
ATOM   1459  C   ASN A 193       0.833  92.260  96.175  1.00 75.37           C  
ATOM   1460  O   ASN A 193       1.103  93.312  96.777  1.00 72.07           O  
ATOM   1461  CB  ASN A 193      -1.469  93.297  95.556  1.00 79.66           C  
ATOM   1462  CG  ASN A 193      -2.838  93.190  96.411  1.00 82.42           C  
ATOM   1463  OD1 ASN A 193      -3.051  92.288  97.254  1.00 83.48           O  
ATOM   1464  ND2 ASN A 193      -3.738  94.156  96.176  1.00 82.25           N  
ATOM   1465  N   ILE A 194       1.713  91.268  96.046  1.00 72.09           N  
ATOM   1466  CA  ILE A 194       2.835  91.084  96.994  1.00 69.91           C  
ATOM   1467  C   ILE A 194       3.779  92.261  97.261  1.00 66.64           C  
ATOM   1468  O   ILE A 194       4.183  92.502  98.398  1.00 65.13           O  
ATOM   1469  CB  ILE A 194       3.618  89.773  96.680  1.00 71.45           C  
ATOM   1470  CG1 ILE A 194       4.935  89.718  97.497  1.00 70.17           C  
ATOM   1471  CG2 ILE A 194       3.737  89.563  95.092  1.00 72.72           C  
ATOM   1472  CD1 ILE A 194       5.437  88.333  97.813  1.00 70.67           C  
ATOM   1473  N   PHE A 195       4.090  93.026  96.232  1.00 64.37           N  
ATOM   1474  CA  PHE A 195       5.073  94.098  96.361  1.00 64.66           C  
ATOM   1475  C   PHE A 195       4.487  95.407  96.809  1.00 68.14           C  
ATOM   1476  O   PHE A 195       5.199  96.361  97.094  1.00 66.77           O  
ATOM   1477  CB  PHE A 195       5.685  94.345  95.006  1.00 61.02           C  
ATOM   1478  CG  PHE A 195       6.360  93.158  94.423  1.00 54.50           C  
ATOM   1479  CD1 PHE A 195       6.213  92.882  93.082  1.00 54.40           C  
ATOM   1480  CD2 PHE A 195       7.145  92.317  95.210  1.00 52.95           C  
ATOM   1481  CE1 PHE A 195       6.835  91.786  92.497  1.00 54.59           C  
ATOM   1482  CE2 PHE A 195       7.782  91.175  94.635  1.00 48.53           C  
ATOM   1483  CZ  PHE A 195       7.638  90.924  93.302  1.00 49.72           C  
ATOM   1484  N   LEU A 196       3.165  95.459  96.843  1.00 73.96           N  
ATOM   1485  CA  LEU A 196       2.505  96.718  96.529  1.00 79.83           C  
ATOM   1486  C   LEU A 196       2.417  97.745  97.641  1.00 83.50           C  
ATOM   1487  O   LEU A 196       3.337  98.559  97.843  1.00 86.27           O  
ATOM   1488  CB  LEU A 196       1.129  96.475  95.912  1.00 79.48           C  
ATOM   1489  CG  LEU A 196       0.847  97.513  94.839  1.00 81.02           C  
ATOM   1490  CD1 LEU A 196       2.079  98.435  94.550  1.00 79.97           C  
ATOM   1491  CD2 LEU A 196       0.338  96.795  93.614  1.00 81.89           C  
ATOM   1492  N   GLN A 197       1.259  97.763  98.288  1.00 86.62           N  
ATOM   1493  CA  GLN A 197       0.974  98.674  99.380  1.00 89.04           C  
ATOM   1494  C   GLN A 197       0.806  97.664 100.497  1.00 90.86           C  
ATOM   1495  O   GLN A 197       0.099  97.924 101.511  1.00 91.54           O  
ATOM   1496  CB  GLN A 197      -0.334  99.427  99.102  1.00 51.94           C  
ATOM   1497  CG  GLN A 197      -0.461 100.793  99.773  1.00 51.94           C  
ATOM   1498  CD  GLN A 197      -1.188 100.749 101.106  1.00 51.94           C  
ATOM   1499  OE1 GLN A 197      -0.687 100.200 102.085  1.00 51.94           O  
ATOM   1500  NE2 GLN A 197      -2.380 101.332 101.144  1.00 51.94           N  
ATOM   1501  N   GLU A 198       1.407  96.480 100.260  1.00 90.11           N  
ATOM   1502  CA  GLU A 198       1.687  95.560 101.333  1.00 89.05           C  
ATOM   1503  C   GLU A 198       2.886  96.268 101.927  1.00 87.48           C  
ATOM   1504  O   GLU A 198       3.994  96.161 101.427  1.00 86.86           O  
ATOM   1505  CB  GLU A 198       1.962  94.159 100.806  1.00 89.62           C  
ATOM   1506  CG  GLU A 198       0.672  93.387 100.517  1.00 92.83           C  
ATOM   1507  CD  GLU A 198       0.777  91.868 100.707  1.00 96.16           C  
ATOM   1508  OE1 GLU A 198       1.771  91.373 101.307  1.00 96.35           O  
ATOM   1509  OE2 GLU A 198      -0.157  91.156 100.252  1.00 96.32           O  
ATOM   1510  N   ILE A 199       2.599  97.100 102.929  1.00 86.64           N  
ATOM   1511  CA  ILE A 199       3.595  97.944 103.590  1.00 84.77           C  
ATOM   1512  C   ILE A 199       4.207  97.182 104.754  1.00 82.70           C  
ATOM   1513  O   ILE A 199       3.801  96.058 105.053  1.00 81.51           O  
ATOM   1514  CB  ILE A 199       2.948  99.282 104.108  1.00 51.94           C  
ATOM   1515  CG1 ILE A 199       2.053  99.915 103.021  1.00 51.94           C  
ATOM   1516  CG2 ILE A 199       4.035 100.272 104.557  1.00 51.94           C  
ATOM   1517  CD1 ILE A 199       2.736 100.301 101.685  1.00 51.94           C  
ATOM   1518  N   LEU A 200       5.190  97.805 105.390  1.00 82.25           N  
ATOM   1519  CA  LEU A 200       5.799  97.284 106.610  1.00 82.28           C  
ATOM   1520  C   LEU A 200       6.399  98.417 107.429  1.00 82.63           C  
ATOM   1521  O   LEU A 200       6.708  99.477 106.852  1.00 81.13           O  
ATOM   1522  CB  LEU A 200       6.906  96.310 106.245  1.00 83.51           C  
ATOM   1523  CG  LEU A 200       8.161  96.996 105.705  1.00 80.82           C  
ATOM   1524  CD1 LEU A 200       9.267  96.036 105.829  1.00 83.00           C  
ATOM   1525  CD2 LEU A 200       7.913  97.401 104.277  1.00 82.79           C  
ATOM   1526  N   PRO A 201       6.548  98.200 108.755  1.00 84.25           N  
ATOM   1527  CA  PRO A 201       7.036  99.232 109.700  1.00 84.61           C  
ATOM   1528  C   PRO A 201       8.331  99.127 110.584  1.00 84.03           C  
ATOM   1529  O   PRO A 201       9.025 100.141 110.693  1.00 83.84           O  
ATOM   1530  CB  PRO A 201       5.839  99.297 110.676  1.00 85.07           C  
ATOM   1531  CG  PRO A 201       5.203  97.804 110.580  1.00 84.57           C  
ATOM   1532  CD  PRO A 201       6.014  97.042 109.503  1.00 84.52           C  
ATOM   1533  N   VAL A 202       8.621  97.967 111.193  1.00 84.31           N  
ATOM   1534  CA  VAL A 202       9.004  97.871 112.645  1.00 82.36           C  
ATOM   1535  C   VAL A 202      10.482  97.820 113.176  1.00 81.62           C  
ATOM   1536  O   VAL A 202      11.347  98.005 112.365  1.00 79.44           O  
ATOM   1537  CB  VAL A 202       8.122  96.776 113.356  1.00 83.42           C  
ATOM   1538  CG1 VAL A 202       6.880  97.413 114.046  1.00 84.95           C  
ATOM   1539  CG2 VAL A 202       7.708  95.638 112.382  1.00 81.94           C  
ATOM   1540  N   ASN A 203      10.715  97.400 114.467  1.00 81.40           N  
ATOM   1541  CA  ASN A 203      11.347  98.173 115.633  1.00 79.58           C  
ATOM   1542  C   ASN A 203      12.505  97.829 116.698  1.00 78.53           C  
ATOM   1543  O   ASN A 203      12.724  98.657 117.607  1.00 78.51           O  
ATOM   1544  CB  ASN A 203      10.175  98.613 116.560  1.00 81.65           C  
ATOM   1545  CG  ASN A 203       9.783 100.084 116.391  1.00 82.69           C  
ATOM   1546  OD1 ASN A 203      10.638 100.981 116.418  1.00 83.21           O  
ATOM   1547  ND2 ASN A 203       8.480 100.334 116.219  1.00 82.83           N  
ATOM   1548  N   SER A 204      13.198  96.677 116.660  1.00 75.51           N  
ATOM   1549  CA  SER A 204      14.415  96.428 117.498  1.00 71.32           C  
ATOM   1550  C   SER A 204      15.247  95.308 116.861  1.00 69.23           C  
ATOM   1551  O   SER A 204      14.720  94.667 115.981  1.00 66.46           O  
ATOM   1552  CB  SER A 204      14.021  95.993 118.890  1.00 71.83           C  
ATOM   1553  OG  SER A 204      14.013  94.584 118.978  1.00 70.49           O  
ATOM   1554  N   GLU A 205      16.486  95.027 117.293  1.00 67.45           N  
ATOM   1555  CA  GLU A 205      17.227  93.882 116.673  1.00 67.33           C  
ATOM   1556  C   GLU A 205      16.557  92.539 116.955  1.00 66.15           C  
ATOM   1557  O   GLU A 205      16.540  91.651 116.098  1.00 64.70           O  
ATOM   1558  CB  GLU A 205      18.746  93.784 116.996  1.00 69.44           C  
ATOM   1559  CG  GLU A 205      19.491  92.685 116.168  1.00 71.32           C  
ATOM   1560  CD  GLU A 205      20.927  92.388 116.611  1.00 77.41           C  
ATOM   1561  OE1 GLU A 205      21.548  91.386 116.125  1.00 78.74           O  
ATOM   1562  OE2 GLU A 205      21.456  93.159 117.457  1.00 79.47           O  
ATOM   1563  N   GLU A 206      16.048  92.387 118.170  1.00 64.72           N  
ATOM   1564  CA  GLU A 206      15.187  91.261 118.526  1.00 62.19           C  
ATOM   1565  C   GLU A 206      13.967  91.116 117.590  1.00 58.94           C  
ATOM   1566  O   GLU A 206      13.634  90.022 117.155  1.00 56.98           O  
ATOM   1567  CB  GLU A 206      14.797  91.424 119.993  1.00 51.94           C  
ATOM   1568  CG  GLU A 206      15.975  91.404 120.968  1.00 51.94           C  
ATOM   1569  CD  GLU A 206      16.747  90.086 120.981  1.00 51.94           C  
ATOM   1570  OE1 GLU A 206      17.725  89.987 121.751  1.00 51.94           O  
ATOM   1571  OE2 GLU A 206      16.388  89.151 120.230  1.00 51.94           O  
ATOM   1572  N   GLU A 207      13.295  92.212 117.271  1.00 58.24           N  
ATOM   1573  CA  GLU A 207      12.135  92.092 116.418  1.00 56.48           C  
ATOM   1574  C   GLU A 207      12.557  91.777 114.942  1.00 53.35           C  
ATOM   1575  O   GLU A 207      11.927  90.974 114.262  1.00 51.87           O  
ATOM   1576  CB  GLU A 207      11.279  93.343 116.512  1.00 58.53           C  
ATOM   1577  CG  GLU A 207       9.982  93.125 115.797  1.00 63.09           C  
ATOM   1578  CD  GLU A 207       9.146  94.374 115.709  1.00 69.57           C  
ATOM   1579  OE1 GLU A 207       9.386  95.333 116.492  1.00 70.07           O  
ATOM   1580  OE2 GLU A 207       8.240  94.373 114.853  1.00 72.33           O  
ATOM   1581  N   PHE A 208      13.660  92.378 114.506  1.00 51.55           N  
ATOM   1582  CA  PHE A 208      14.266  92.038 113.235  1.00 49.34           C  
ATOM   1583  C   PHE A 208      14.593  90.554 113.202  1.00 49.89           C  
ATOM   1584  O   PHE A 208      14.344  89.908 112.186  1.00 49.02           O  
ATOM   1585  CB  PHE A 208      15.542  92.848 112.964  1.00 48.30           C  
ATOM   1586  CG  PHE A 208      16.018  92.766 111.544  1.00 44.86           C  
ATOM   1587  CD1 PHE A 208      15.598  93.695 110.627  1.00 43.74           C  
ATOM   1588  CD2 PHE A 208      16.899  91.770 111.140  1.00 45.67           C  
ATOM   1589  CE1 PHE A 208      16.041  93.665 109.290  1.00 45.60           C  
ATOM   1590  CE2 PHE A 208      17.355  91.692 109.830  1.00 45.09           C  
ATOM   1591  CZ  PHE A 208      16.924  92.640 108.882  1.00 46.61           C  
ATOM   1592  N   GLN A 209      15.163  90.024 114.287  1.00 50.21           N  
ATOM   1593  CA  GLN A 209      15.684  88.638 114.267  1.00 52.38           C  
ATOM   1594  C   GLN A 209      14.474  87.682 114.107  1.00 52.42           C  
ATOM   1595  O   GLN A 209      14.535  86.676 113.404  1.00 55.67           O  
ATOM   1596  CB  GLN A 209      16.465  88.298 115.536  1.00 52.86           C  
ATOM   1597  CG  GLN A 209      17.782  89.010 115.793  1.00 57.09           C  
ATOM   1598  CD  GLN A 209      18.978  87.964 115.803  1.00 65.41           C  
ATOM   1599  OE1 GLN A 209      18.740  86.762 115.493  1.00 63.28           O  
ATOM   1600  NE2 GLN A 209      20.232  88.428 116.108  1.00 61.26           N  
ATOM   1601  N   THR A 210      13.359  88.034 114.733  1.00 50.35           N  
ATOM   1602  CA  THR A 210      12.171  87.225 114.696  1.00 48.90           C  
ATOM   1603  C   THR A 210      11.560  87.121 113.303  1.00 45.93           C  
ATOM   1604  O   THR A 210      11.159  86.035 112.855  1.00 43.50           O  
ATOM   1605  CB  THR A 210      11.140  87.799 115.711  1.00 50.07           C  
ATOM   1606  OG1 THR A 210      11.562  87.421 117.025  1.00 54.80           O  
ATOM   1607  CG2 THR A 210       9.782  87.178 115.541  1.00 47.89           C  
ATOM   1608  N   LEU A 211      11.413  88.265 112.666  1.00 45.68           N  
ATOM   1609  CA  LEU A 211      10.809  88.297 111.363  1.00 46.03           C  
ATOM   1610  C   LEU A 211      11.760  87.660 110.362  1.00 46.10           C  
ATOM   1611  O   LEU A 211      11.321  87.078 109.421  1.00 43.63           O  
ATOM   1612  CB  LEU A 211      10.518  89.732 110.954  1.00 48.46           C  
ATOM   1613  CG  LEU A 211       9.337  90.324 111.711  1.00 52.04           C  
ATOM   1614  CD1 LEU A 211       9.288  91.852 111.524  1.00 52.18           C  
ATOM   1615  CD2 LEU A 211       8.118  89.672 111.151  1.00 54.61           C  
ATOM   1616  N   SER A 212      13.072  87.705 110.637  1.00 45.38           N  
ATOM   1617  CA  SER A 212      14.011  87.188 109.668  1.00 47.33           C  
ATOM   1618  C   SER A 212      14.069  85.678 109.914  1.00 46.57           C  
ATOM   1619  O   SER A 212      14.287  84.917 108.973  1.00 44.79           O  
ATOM   1620  CB  SER A 212      15.357  87.973 109.685  1.00 48.37           C  
ATOM   1621  OG  SER A 212      16.237  87.369 110.590  1.00 55.85           O  
ATOM   1622  N   ALA A 213      13.746  85.227 111.137  1.00 44.76           N  
ATOM   1623  CA  ALA A 213      13.556  83.788 111.337  1.00 44.18           C  
ATOM   1624  C   ALA A 213      12.367  83.221 110.533  1.00 43.06           C  
ATOM   1625  O   ALA A 213      12.456  82.158 109.966  1.00 41.37           O  
ATOM   1626  CB  ALA A 213      13.420  83.434 112.864  1.00 44.70           C  
ATOM   1627  N   ALA A 214      11.230  83.919 110.531  1.00 41.28           N  
ATOM   1628  CA  ALA A 214      10.093  83.549 109.702  1.00 43.40           C  
ATOM   1629  C   ALA A 214      10.485  83.566 108.176  1.00 42.48           C  
ATOM   1630  O   ALA A 214      10.188  82.626 107.457  1.00 41.59           O  
ATOM   1631  CB  ALA A 214       8.940  84.582 109.891  1.00 43.12           C  
ATOM   1632  N   TRP A 215      11.056  84.678 107.714  1.00 43.06           N  
ATOM   1633  CA  TRP A 215      11.487  84.790 106.289  1.00 43.00           C  
ATOM   1634  C   TRP A 215      12.497  83.658 105.921  1.00 43.15           C  
ATOM   1635  O   TRP A 215      12.441  83.056 104.871  1.00 45.98           O  
ATOM   1636  CB  TRP A 215      12.162  86.143 106.082  1.00 42.38           C  
ATOM   1637  CG  TRP A 215      11.157  87.186 105.671  1.00 44.04           C  
ATOM   1638  CD1 TRP A 215      10.769  88.266 106.381  1.00 47.09           C  
ATOM   1639  CD2 TRP A 215      10.482  87.253 104.415  1.00 45.82           C  
ATOM   1640  NE1 TRP A 215       9.842  89.000 105.660  1.00 51.16           N  
ATOM   1641  CE2 TRP A 215       9.632  88.377 104.457  1.00 50.31           C  
ATOM   1642  CE3 TRP A 215      10.499  86.461 103.247  1.00 45.76           C  
ATOM   1643  CZ2 TRP A 215       8.837  88.740 103.392  1.00 52.07           C  
ATOM   1644  CZ3 TRP A 215       9.678  86.814 102.201  1.00 51.02           C  
ATOM   1645  CH2 TRP A 215       8.857  87.935 102.281  1.00 52.86           C  
ATOM   1646  N   HIS A 216      13.386  83.360 106.817  1.00 45.11           N  
ATOM   1647  CA  HIS A 216      14.343  82.260 106.562  1.00 44.75           C  
ATOM   1648  C   HIS A 216      13.585  81.021 106.231  1.00 45.66           C  
ATOM   1649  O   HIS A 216      13.942  80.264 105.301  1.00 45.32           O  
ATOM   1650  CB  HIS A 216      15.148  82.009 107.782  1.00 47.13           C  
ATOM   1651  CG  HIS A 216      16.294  81.076 107.563  1.00 54.72           C  
ATOM   1652  ND1 HIS A 216      16.195  79.714 107.765  1.00 61.32           N  
ATOM   1653  CD2 HIS A 216      17.566  81.308 107.147  1.00 58.36           C  
ATOM   1654  CE1 HIS A 216      17.356  79.144 107.476  1.00 62.00           C  
ATOM   1655  NE2 HIS A 216      18.207  80.092 107.108  1.00 61.55           N  
ATOM   1656  N   SER A 217      12.515  80.755 106.997  1.00 43.72           N  
ATOM   1657  CA  SER A 217      11.762  79.552 106.785  1.00 41.43           C  
ATOM   1658  C   SER A 217      10.944  79.600 105.469  1.00 39.09           C  
ATOM   1659  O   SER A 217      10.800  78.625 104.760  1.00 42.52           O  
ATOM   1660  CB  SER A 217      10.865  79.329 108.045  1.00 45.02           C  
ATOM   1661  OG  SER A 217      10.121  78.141 107.874  1.00 49.58           O  
ATOM   1662  N   ILE A 218      10.338  80.722 105.148  1.00 38.69           N  
ATOM   1663  CA  ILE A 218       9.604  80.840 103.912  1.00 40.15           C  
ATOM   1664  C   ILE A 218      10.619  80.642 102.681  1.00 41.31           C  
ATOM   1665  O   ILE A 218      10.360  79.883 101.716  1.00 40.65           O  
ATOM   1666  CB  ILE A 218       9.060  82.271 103.846  1.00 43.79           C  
ATOM   1667  CG1 ILE A 218       7.889  82.472 104.847  1.00 43.89           C  
ATOM   1668  CG2 ILE A 218       8.574  82.583 102.431  1.00 42.56           C  
ATOM   1669  CD1 ILE A 218       7.535  83.951 105.120  1.00 45.90           C  
ATOM   1670  N   LEU A 219      11.774  81.284 102.775  1.00 40.21           N  
ATOM   1671  CA  LEU A 219      12.756  81.220 101.670  1.00 41.44           C  
ATOM   1672  C   LEU A 219      13.370  79.827 101.563  1.00 42.76           C  
ATOM   1673  O   LEU A 219      13.528  79.280 100.471  1.00 45.10           O  
ATOM   1674  CB  LEU A 219      13.832  82.325 101.810  1.00 37.91           C  
ATOM   1675  CG  LEU A 219      13.132  83.718 101.732  1.00 39.85           C  
ATOM   1676  CD1 LEU A 219      14.214  84.759 101.926  1.00 45.83           C  
ATOM   1677  CD2 LEU A 219      12.374  83.894 100.452  1.00 39.39           C  
ATOM   1678  N   ASP A 220      13.630  79.227 102.693  1.00 43.47           N  
ATOM   1679  CA  ASP A 220      14.130  77.851 102.681  1.00 47.26           C  
ATOM   1680  C   ASP A 220      13.137  76.873 102.004  1.00 46.86           C  
ATOM   1681  O   ASP A 220      13.539  75.974 101.203  1.00 45.29           O  
ATOM   1682  CB  ASP A 220      14.518  77.383 104.104  1.00 50.85           C  
ATOM   1683  CG  ASP A 220      15.461  76.202 104.060  1.00 61.36           C  
ATOM   1684  OD1 ASP A 220      16.661  76.462 103.779  1.00 72.71           O  
ATOM   1685  OD2 ASP A 220      15.106  75.001 104.173  1.00 66.83           O  
ATOM   1686  N   GLY A 221      11.841  77.041 102.285  1.00 44.26           N  
ATOM   1687  CA  GLY A 221      10.816  76.287 101.569  1.00 44.63           C  
ATOM   1688  C   GLY A 221      10.719  76.594 100.047  1.00 44.01           C  
ATOM   1689  O   GLY A 221      10.497  75.701  99.238  1.00 41.54           O  
ATOM   1690  N   LYS A 222      10.741  77.864  99.665  1.00 42.81           N  
ATOM   1691  CA  LYS A 222      10.792  78.179  98.241  1.00 42.20           C  
ATOM   1692  C   LYS A 222      12.007  77.501  97.540  1.00 41.50           C  
ATOM   1693  O   LYS A 222      11.883  76.987  96.446  1.00 44.93           O  
ATOM   1694  CB  LYS A 222      10.902  79.674  98.069  1.00 41.14           C  
ATOM   1695  CG  LYS A 222       9.650  80.472  98.548  1.00 42.30           C  
ATOM   1696  CD  LYS A 222       8.342  79.811  98.116  1.00 43.28           C  
ATOM   1697  CE  LYS A 222       7.128  80.719  98.535  1.00 48.33           C  
ATOM   1698  NZ  LYS A 222       5.898  79.970  98.148  1.00 48.02           N  
ATOM   1699  N   LEU A 223      13.146  77.576  98.174  1.00 38.51           N  
ATOM   1700  CA  LEU A 223      14.382  76.986  97.610  1.00 42.72           C  
ATOM   1701  C   LEU A 223      14.331  75.479  97.496  1.00 44.86           C  
ATOM   1702  O   LEU A 223      14.869  74.913  96.535  1.00 45.32           O  
ATOM   1703  CB  LEU A 223      15.573  77.459  98.387  1.00 38.25           C  
ATOM   1704  CG  LEU A 223      15.724  79.014  98.192  1.00 34.16           C  
ATOM   1705  CD1 LEU A 223      16.628  79.705  99.177  1.00 37.38           C  
ATOM   1706  CD2 LEU A 223      16.156  79.317  96.693  1.00 39.48           C  
ATOM   1707  N   SER A 224      13.691  74.799  98.453  1.00 44.94           N  
ATOM   1708  CA  SER A 224      13.551  73.316  98.296  1.00 44.96           C  
ATOM   1709  C   SER A 224      12.583  73.018  97.208  1.00 43.46           C  
ATOM   1710  O   SER A 224      12.758  72.113  96.429  1.00 43.66           O  
ATOM   1711  CB  SER A 224      13.161  72.596  99.642  1.00 44.53           C  
ATOM   1712  OG  SER A 224      14.158  72.982 100.614  1.00 47.77           O  
ATOM   1713  N   ALA A 225      11.527  73.813  97.078  1.00 41.76           N  
ATOM   1714  CA  ALA A 225      10.661  73.531  95.984  1.00 43.06           C  
ATOM   1715  C   ALA A 225      11.370  73.726  94.628  1.00 44.72           C  
ATOM   1716  O   ALA A 225      11.118  72.959  93.703  1.00 44.85           O  
ATOM   1717  CB  ALA A 225       9.367  74.440  96.036  1.00 42.49           C  
ATOM   1718  N   LEU A 226      12.203  74.781  94.518  1.00 44.67           N  
ATOM   1719  CA  LEU A 226      12.889  75.148  93.280  1.00 43.33           C  
ATOM   1720  C   LEU A 226      13.795  73.994  92.889  1.00 42.32           C  
ATOM   1721  O   LEU A 226      13.832  73.603  91.747  1.00 40.85           O  
ATOM   1722  CB  LEU A 226      13.819  76.344  93.538  1.00 41.90           C  
ATOM   1723  CG  LEU A 226      14.146  77.469  92.504  1.00 42.89           C  
ATOM   1724  CD1 LEU A 226      15.502  78.214  92.671  1.00 39.04           C  
ATOM   1725  CD2 LEU A 226      13.639  77.337  91.135  1.00 43.41           C  
ATOM   1726  N   ASP A 227      14.586  73.553  93.853  1.00 46.21           N  
ATOM   1727  CA  ASP A 227      15.510  72.420  93.690  1.00 49.44           C  
ATOM   1728  C   ASP A 227      14.815  71.185  93.233  1.00 52.00           C  
ATOM   1729  O   ASP A 227      15.405  70.405  92.441  1.00 51.08           O  
ATOM   1730  CB  ASP A 227      16.147  72.067  95.001  1.00 51.50           C  
ATOM   1731  CG  ASP A 227      17.247  73.023  95.369  1.00 56.72           C  
ATOM   1732  OD1 ASP A 227      17.587  73.875  94.517  1.00 61.47           O  
ATOM   1733  OD2 ASP A 227      17.834  72.972  96.477  1.00 60.82           O  
ATOM   1734  N   GLU A 228      13.575  70.990  93.718  1.00 50.54           N  
ATOM   1735  CA  GLU A 228      12.844  69.812  93.301  1.00 49.81           C  
ATOM   1736  C   GLU A 228      12.422  69.983  91.842  1.00 48.67           C  
ATOM   1737  O   GLU A 228      12.548  69.069  91.071  1.00 48.07           O  
ATOM   1738  CB  GLU A 228      11.643  69.508  94.207  1.00 49.66           C  
ATOM   1739  CG  GLU A 228      10.836  68.266  93.835  1.00 51.94           C  
ATOM   1740  CD  GLU A 228      11.625  66.983  93.996  1.00 51.94           C  
ATOM   1741  OE1 GLU A 228      12.051  66.686  95.131  1.00 51.94           O  
ATOM   1742  OE2 GLU A 228      11.819  66.273  92.988  1.00 51.94           O  
ATOM   1743  N   GLU A 229      11.859  71.125  91.471  1.00 48.70           N  
ATOM   1744  CA  GLU A 229      11.544  71.340  90.078  1.00 46.65           C  
ATOM   1745  C   GLU A 229      12.831  71.274  89.197  1.00 44.22           C  
ATOM   1746  O   GLU A 229      12.780  70.773  88.085  1.00 42.59           O  
ATOM   1747  CB  GLU A 229      10.844  72.657  89.847  1.00 48.41           C  
ATOM   1748  CG  GLU A 229       9.385  72.777  90.342  1.00 51.94           C  
ATOM   1749  CD  GLU A 229       8.532  71.518  90.206  1.00 57.40           C  
ATOM   1750  OE1 GLU A 229       8.567  70.869  89.144  1.00 56.84           O  
ATOM   1751  OE2 GLU A 229       7.799  71.163  91.174  1.00 60.31           O  
ATOM   1752  N   PHE A 230      13.933  71.818  89.675  1.00 46.18           N  
ATOM   1753  CA  PHE A 230      15.172  71.795  88.902  1.00 48.53           C  
ATOM   1754  C   PHE A 230      15.592  70.335  88.711  1.00 50.64           C  
ATOM   1755  O   PHE A 230      16.103  69.978  87.630  1.00 51.95           O  
ATOM   1756  CB  PHE A 230      16.287  72.590  89.589  1.00 47.51           C  
ATOM   1757  CG  PHE A 230      16.239  74.094  89.334  1.00 40.45           C  
ATOM   1758  CD1 PHE A 230      17.070  74.947  90.031  1.00 38.62           C  
ATOM   1759  CD2 PHE A 230      15.402  74.626  88.398  1.00 42.95           C  
ATOM   1760  CE1 PHE A 230      17.002  76.327  89.853  1.00 43.69           C  
ATOM   1761  CE2 PHE A 230      15.355  75.929  88.186  1.00 40.51           C  
ATOM   1762  CZ  PHE A 230      16.187  76.814  88.881  1.00 35.38           C  
ATOM   1763  N   ASP A 231      15.420  69.496  89.743  1.00 51.85           N  
ATOM   1764  CA  ASP A 231      15.834  68.061  89.607  1.00 53.70           C  
ATOM   1765  C   ASP A 231      14.974  67.371  88.594  1.00 50.73           C  
ATOM   1766  O   ASP A 231      15.459  66.561  87.865  1.00 49.36           O  
ATOM   1767  CB  ASP A 231      15.782  67.258  90.912  1.00 55.61           C  
ATOM   1768  CG  ASP A 231      16.836  67.701  91.885  1.00 63.40           C  
ATOM   1769  OD1 ASP A 231      17.935  68.081  91.398  1.00 70.90           O  
ATOM   1770  OD2 ASP A 231      16.660  67.741  93.133  1.00 65.49           O  
ATOM   1771  N   VAL A 232      13.695  67.744  88.531  1.00 49.53           N  
ATOM   1772  CA  VAL A 232      12.781  67.142  87.592  1.00 48.60           C  
ATOM   1773  C   VAL A 232      13.132  67.561  86.145  1.00 49.71           C  
ATOM   1774  O   VAL A 232      13.168  66.720  85.258  1.00 50.06           O  
ATOM   1775  CB  VAL A 232      11.271  67.490  87.935  1.00 48.29           C  
ATOM   1776  CG1 VAL A 232      10.328  67.251  86.753  1.00 51.36           C  
ATOM   1777  CG2 VAL A 232      10.785  66.694  89.157  1.00 50.72           C  
ATOM   1778  N   VAL A 233      13.342  68.846  85.878  1.00 45.43           N  
ATOM   1779  CA  VAL A 233      13.610  69.245  84.533  1.00 46.62           C  
ATOM   1780  C   VAL A 233      14.929  68.638  84.042  1.00 45.78           C  
ATOM   1781  O   VAL A 233      15.033  68.288  82.878  1.00 49.26           O  
ATOM   1782  CB  VAL A 233      13.744  70.780  84.343  1.00 46.79           C  
ATOM   1783  CG1 VAL A 233      12.483  71.512  84.721  1.00 51.10           C  
ATOM   1784  CG2 VAL A 233      14.929  71.327  85.102  1.00 49.34           C  
ATOM   1785  N   ALA A 234      15.898  68.486  84.918  1.00 45.08           N  
ATOM   1786  CA  ALA A 234      17.227  68.004  84.485  1.00 48.89           C  
ATOM   1787  C   ALA A 234      17.206  66.518  84.168  1.00 51.02           C  
ATOM   1788  O   ALA A 234      18.146  66.008  83.551  1.00 52.22           O  
ATOM   1789  CB  ALA A 234      18.294  68.319  85.504  1.00 46.40           C  
ATOM   1790  N   THR A 235      16.123  65.856  84.580  1.00 52.31           N  
ATOM   1791  CA  THR A 235      15.739  64.498  84.154  1.00 56.19           C  
ATOM   1792  C   THR A 235      15.702  64.378  82.648  1.00 56.02           C  
ATOM   1793  O   THR A 235      16.182  63.403  82.093  1.00 57.27           O  
ATOM   1794  CB  THR A 235      14.319  64.182  84.721  1.00 55.10           C  
ATOM   1795  OG1 THR A 235      14.459  63.738  86.079  1.00 59.15           O  
ATOM   1796  CG2 THR A 235      13.684  63.050  84.028  1.00 59.79           C  
ATOM   1797  N   LYS A 236      15.102  65.373  81.994  1.00 56.98           N  
ATOM   1798  CA  LYS A 236      14.963  65.372  80.559  1.00 56.00           C  
ATOM   1799  C   LYS A 236      16.291  65.416  79.818  1.00 55.59           C  
ATOM   1800  O   LYS A 236      16.219  65.292  78.603  1.00 58.35           O  
ATOM   1801  CB  LYS A 236      14.186  66.598  80.042  1.00 57.41           C  
ATOM   1802  CG  LYS A 236      12.796  66.950  80.556  1.00 58.80           C  
ATOM   1803  CD  LYS A 236      12.722  68.504  80.359  1.00 64.90           C  
ATOM   1804  CE  LYS A 236      11.333  69.054  80.340  1.00 62.47           C  
ATOM   1805  NZ  LYS A 236      10.921  69.476  78.977  1.00 59.14           N  
ATOM   1806  N   TRP A 237      17.450  65.645  80.484  1.00 52.97           N  
ATOM   1807  CA  TRP A 237      18.736  65.996  79.815  1.00 52.41           C  
ATOM   1808  C   TRP A 237      19.810  64.936  80.005  1.00 55.35           C  
ATOM   1809  O   TRP A 237      20.855  65.222  80.639  1.00 57.64           O  
ATOM   1810  CB  TRP A 237      19.328  67.372  80.287  1.00 49.98           C  
ATOM   1811  CG  TRP A 237      18.290  68.591  80.170  1.00 45.66           C  
ATOM   1812  CD1 TRP A 237      17.261  68.713  79.278  1.00 48.38           C  
ATOM   1813  CD2 TRP A 237      18.238  69.737  80.980  1.00 46.14           C  
ATOM   1814  NE1 TRP A 237      16.576  69.898  79.481  1.00 50.90           N  
ATOM   1815  CE2 TRP A 237      17.129  70.521  80.560  1.00 48.95           C  
ATOM   1816  CE3 TRP A 237      18.976  70.169  82.082  1.00 48.71           C  
ATOM   1817  CZ2 TRP A 237      16.804  71.740  81.153  1.00 55.23           C  
ATOM   1818  CZ3 TRP A 237      18.661  71.313  82.669  1.00 48.98           C  
ATOM   1819  CH2 TRP A 237      17.567  72.112  82.233  1.00 52.21           C  
TER    1820      TRP A 237                                                      
END
MOLECULE T0478_138_267.pdb
ATOM   1121  N   ASP   138      15.040  81.714 110.368  1.00 45.58          
ATOM   1122  CA  ASP   138      16.230  82.548 110.663  1.00 45.87          
ATOM   1123  C   ASP   138      15.852  84.016 110.769  1.00 45.10          
ATOM   1124  O   ASP   138      14.864  84.433 110.134  1.00 44.87          
ATOM   1125  CB  ASP   138      17.257  82.385 109.544  1.00 46.10          
ATOM   1126  CG  ASP   138      17.911  81.008 109.553  1.00 49.57          
ATOM   1127  OD1 ASP   138      18.669  80.727 110.517  1.00 49.14          
ATOM   1128  OD2 ASP   138      17.655  80.213 108.601  1.00 52.78          
ATOM   1129  N   ALA   139      16.613  84.786 111.564  1.00 43.27          
ATOM   1130  CA  ALA   139      16.452  86.237 111.613  1.00 42.60          
ATOM   1131  C   ALA   139      16.934  86.838 110.292  1.00 43.26          
ATOM   1132  O   ALA   139      17.769  86.235 109.618  1.00 43.42          
ATOM   1133  CB  ALA   139      17.218  86.844 112.770  1.00 41.93          
ATOM   1134  N   LEU   140      16.423  88.024 109.934  1.00 42.66          
ATOM   1135  CA  LEU   140      16.670  88.601 108.620  1.00 42.23          
ATOM   1136  C   LEU   140      18.154  88.621 108.146  1.00 41.65          
ATOM   1137  O   LEU   140      18.440  88.253 107.016  1.00 41.90          
ATOM   1138  CB  LEU   140      15.984  89.965 108.503  1.00 42.36          
ATOM   1139  CG  LEU   140      16.203  90.730 107.186  1.00 43.56          
ATOM   1140  CD1 LEU   140      15.427  90.137 106.035  1.00 40.46          
ATOM   1141  CD2 LEU   140      15.881  92.201 107.320  1.00 43.67          
ATOM   1142  N   PRO   141      19.106  89.030 109.004  1.00 41.42          
ATOM   1143  CA  PRO   141      20.469  89.087 108.466  1.00 41.37          
ATOM   1144  C   PRO   141      21.064  87.712 108.067  1.00 41.50          
ATOM   1145  O   PRO   141      21.768  87.599 107.049  1.00 40.11          
ATOM   1146  CB  PRO   141      21.291  89.741 109.596  1.00 41.72          
ATOM   1147  CG  PRO   141      20.341  90.185 110.620  1.00 41.83          
ATOM   1148  CD  PRO   141      19.032  89.459 110.412  1.00 40.93          
ATOM   1149  N   ASP   142      20.787  86.690 108.873  1.00 41.36          
ATOM   1150  CA  ASP   142      21.047  85.300 108.498  1.00 41.77          
ATOM   1151  C   ASP   142      20.293  84.742 107.308  1.00 40.91          
ATOM   1152  O   ASP   142      20.852  83.956 106.554  1.00 41.00          
ATOM   1153  CB  ASP   142      20.723  84.409 109.665  1.00 42.77          
ATOM   1154  CG  ASP   142      21.879  84.296 110.579  1.00 47.80          
ATOM   1155  OD1 ASP   142      22.791  83.493 110.242  1.00 53.89          
ATOM   1156  OD2 ASP   142      21.882  85.025 111.595  1.00 49.00          
ATOM   1157  N   ALA   143      19.012  85.078 107.186  1.00 39.57          
ATOM   1158  CA  ALA   143      18.239  84.595 106.090  1.00 38.75          
ATOM   1159  C   ALA   143      18.858  85.181 104.820  1.00 38.96          
ATOM   1160  O   ALA   143      18.996  84.506 103.828  1.00 39.36          
ATOM   1161  CB  ALA   143      16.796  85.020 106.243  1.00 38.14          
ATOM   1162  N   ILE   144      19.270  86.432 104.864  1.00 39.12          
ATOM   1163  CA  ILE   144      19.797  87.071 103.690  1.00 39.66          
ATOM   1164  C   ILE   144      21.048  86.334 103.234  1.00 40.81          
ATOM   1165  O   ILE   144      21.179  85.958 102.056  1.00 41.14          
ATOM   1166  CB  ILE   144      20.169  88.511 103.971  1.00 39.22          
ATOM   1167  CG1 ILE   144      18.916  89.387 104.041  1.00 40.15          
ATOM   1168  CG2 ILE   144      21.075  89.026 102.895  1.00 40.12          
ATOM   1169  CD  ILE   144      19.176  90.767 104.617  1.00 35.25          
ATOM   1170  N   ILE   145      21.974  86.114 104.155  1.00 40.49          
ATOM   1171  CA  ILE   145      23.184  85.440 103.770  1.00 41.50          
ATOM   1172  C   ILE   145      22.927  83.991 103.363  1.00 41.39          
ATOM   1173  O   ILE   145      23.310  83.567 102.282  1.00 41.80          
ATOM   1174  CB  ILE   145      24.299  85.506 104.856  1.00 41.78          
ATOM   1175  CG1 ILE   145      25.081  86.804 104.658  1.00 42.98          
ATOM   1176  CG2 ILE   145      25.230  84.333 104.646  1.00 41.68          
ATOM   1177  CD  ILE   145      26.028  87.196 105.784  1.00 44.38          
ATOM   1178  N   LYS   146      22.262  83.251 104.231  1.00 41.16          
ATOM   1179  CA  LYS   146      22.009  81.860 104.004  1.00 40.47          
ATOM   1180  C   LYS   146      21.234  81.527 102.725  1.00 40.27          
ATOM   1181  O   LYS   146      21.525  80.547 102.066  1.00 40.67          
ATOM   1182  CB  LYS   146      21.302  81.288 105.228  1.00 40.50          
ATOM   1183  CG  LYS   146      22.296  80.943 106.339  1.00 41.61          
ATOM   1184  CD  LYS   146      21.627  80.324 107.601  1.00 42.47          
ATOM   1185  CE  LYS   146      21.106  78.899 107.385  1.00 40.71          
ATOM   1186  NZ  LYS   146      20.212  78.492 108.538  1.00 43.00          
ATOM   1187  N   GLU   147      20.210  82.286 102.404  1.00 39.57          
ATOM   1188  CA  GLU   147      19.433  82.021 101.191  1.00 39.50          
ATOM   1189  C   GLU   147      20.244  82.372  99.929  1.00 38.54          
ATOM   1190  O   GLU   147      20.184  81.660  98.927  1.00 38.77          
ATOM   1191  CB  GLU   147      18.122  82.836 101.208  1.00 39.27          
ATOM   1192  CG  GLU   147      17.229  82.505 102.411  1.00 42.25          
ATOM   1193  CD  GLU   147      16.430  81.197 102.228  1.00 45.53          
ATOM   1194  OE1 GLU   147      15.624  80.866 103.127  1.00 47.81          
ATOM   1195  OE2 GLU   147      16.582  80.518 101.182  1.00 45.79          
ATOM   1196  N   ASN   148      21.001  83.464  99.966  1.00 36.99          
ATOM   1197  CA  ASN   148      21.768  83.827  98.793  1.00 35.95          
ATOM   1198  C   ASN   148      22.830  82.812  98.489  1.00 35.81          
ATOM   1199  O   ASN   148      22.930  82.379  97.387  1.00 36.79          
ATOM   1200  CB  ASN   148      22.328  85.237  98.897  1.00 35.42          
ATOM   1201  CG  ASN   148      21.300  86.302  98.535  1.00 36.15          
ATOM   1202  OD1 ASN   148      21.272  86.790  97.417  1.00 37.77          
ATOM   1203  ND2 ASN   148      20.434  86.648  99.480  1.00 38.10          
ATOM   1204  N   VAL   149      23.618  82.430  99.474  1.00 36.75          
ATOM   1205  CA  VAL   149      24.575  81.330  99.346  1.00 37.63          
ATOM   1206  C   VAL   149      23.926  80.060  98.773  1.00 38.22          
ATOM   1207  O   VAL   149      24.416  79.495  97.809  1.00 39.53          
ATOM   1208  CB  VAL   149      25.231  81.000 100.721  1.00 38.17          
ATOM   1209  CG1 VAL   149      25.993  79.701 100.654  1.00 37.22          
ATOM   1210  CG2 VAL   149      26.143  82.163 101.183  1.00 37.52          
ATOM   1211  N   PHE   150      22.807  79.616  99.322  1.00 37.55          
ATOM   1212  CA  PHE   150      22.133  78.480  98.730  1.00 36.83          
ATOM   1213  C   PHE   150      21.714  78.749  97.265  1.00 36.87          
ATOM   1214  O   PHE   150      22.089  77.989  96.374  1.00 36.79          
ATOM   1215  CB  PHE   150      20.935  78.035  99.579  1.00 35.87          
ATOM   1216  CG  PHE   150      19.984  77.085  98.862  1.00 36.96          
ATOM   1217  CD1 PHE   150      20.288  75.759  98.701  1.00 36.23          
ATOM   1218  CD2 PHE   150      18.759  77.526  98.386  1.00 39.93          
ATOM   1219  CE1 PHE   150      19.423  74.915  98.060  1.00 34.92          
ATOM   1220  CE2 PHE   150      17.886  76.664  97.739  1.00 37.78          
ATOM   1221  CZ  PHE   150      18.224  75.370  97.590  1.00 38.25          
ATOM   1222  N   PHE   151      20.952  79.819  97.004  1.00 36.72          
ATOM   1223  CA  PHE   151      20.297  80.025  95.688  1.00 35.51          
ATOM   1224  C   PHE   151      21.261  80.523  94.566  1.00 35.60          
ATOM   1225  O   PHE   151      21.074  80.213  93.396  1.00 34.93          
ATOM   1226  CB  PHE   151      19.151  81.014  95.838  1.00 35.96          
ATOM   1227  CG  PHE   151      17.837  80.401  96.208  1.00 37.00          
ATOM   1228  CD1 PHE   151      17.088  79.705  95.262  1.00 40.87          
ATOM   1229  CD2 PHE   151      17.306  80.562  97.485  1.00 37.73          
ATOM   1230  CE1 PHE   151      15.806  79.147  95.574  1.00 39.31          
ATOM   1231  CE2 PHE   151      16.053  80.019  97.818  1.00 36.20          
ATOM   1232  CZ  PHE   151      15.300  79.303  96.862  1.00 38.34          
ATOM   1233  N   LEU   152      22.318  81.265  94.915  1.00 35.36          
ATOM   1234  CA  LEU   152      23.317  81.637  93.899  1.00 35.09          
ATOM   1235  C   LEU   152      23.997  80.387  93.325  1.00 35.76          
ATOM   1236  O   LEU   152      24.300  80.341  92.126  1.00 37.03          
ATOM   1237  CB  LEU   152      24.353  82.631  94.435  1.00 34.49          
ATOM   1238  CG  LEU   152      23.815  84.011  94.851  1.00 36.42          
ATOM   1239  CD1 LEU   152      24.911  84.779  95.605  1.00 36.16          
ATOM   1240  CD2 LEU   152      23.169  84.855  93.648  1.00 28.34          
ATOM   1241  N   ARG   153      24.185  79.363  94.160  1.00 34.90          
ATOM   1242  CA  ARG   153      24.717  78.079  93.721  1.00 34.64          
ATOM   1243  C   ARG   153      23.680  77.360  92.802  1.00 34.38          
ATOM   1244  O   ARG   153      23.997  76.879  91.710  1.00 35.70          
ATOM   1245  CB  ARG   153      25.120  77.231  94.955  1.00 34.57          
ATOM   1246  CG  ARG   153      25.849  75.955  94.587  1.00 37.81          
ATOM   1247  CD  ARG   153      26.508  75.275  95.767  1.00 41.68          
ATOM   1248  NE  ARG   153      27.317  74.099  95.362  1.00 43.99          
ATOM   1249  CZ  ARG   153      27.835  73.213  96.221  1.00 43.27          
ATOM   1250  NH1 ARG   153      27.614  73.335  97.527  1.00 38.50          
ATOM   1251  NH2 ARG   153      28.547  72.183  95.784  1.00 43.56          
ATOM   1252  N   ILE   154      22.419  77.346  93.218  1.00 33.12          
ATOM   1253  CA  ILE   154      21.366  76.771  92.408  1.00 31.74          
ATOM   1254  C   ILE   154      21.323  77.412  90.994  1.00 31.97          
ATOM   1255  O   ILE   154      21.248  76.729  89.951  1.00 32.34          
ATOM   1256  CB  ILE   154      20.053  76.962  93.135  1.00 30.77          
ATOM   1257  CG1 ILE   154      20.000  76.138  94.457  1.00 29.63          
ATOM   1258  CG2 ILE   154      18.944  76.610  92.265  1.00 29.73          
ATOM   1259  CD  ILE   154      20.535  74.692  94.422  1.00 24.57          
ATOM   1260  N   MET   155      21.384  78.746  90.972  1.00 32.10          
ATOM   1261  CA  MET   155      21.431  79.512  89.756  1.00 30.15          
ATOM   1262  C   MET   155      22.658  79.205  88.929  1.00 30.64          
ATOM   1263  O   MET   155      22.579  79.190  87.718  1.00 30.42          
ATOM   1264  CB  MET   155      21.380  81.023  90.085  1.00 31.10          
ATOM   1265  CG  MET   155      20.094  81.570  90.736  1.00 30.70          
ATOM   1266  SD  MET   155      18.594  81.405  89.759  1.00 29.53          
ATOM   1267  CE  MET   155      17.743  80.027  90.556  1.00 33.00          
ATOM   1268  N   ALA   156      23.823  79.023  89.559  1.00 31.11          
ATOM   1269  CA  ALA   156      25.064  78.832  88.800  1.00 30.95          
ATOM   1270  C   ALA   156      25.024  77.445  88.206  1.00 31.71          
ATOM   1271  O   ALA   156      25.444  77.237  87.077  1.00 32.16          
ATOM   1272  CB  ALA   156      26.307  78.968  89.721  1.00 30.67          
ATOM   1273  N   ASP   157      24.544  76.473  88.975  1.00 32.22          
ATOM   1274  CA  ASP   157      24.353  75.104  88.421  1.00 32.73          
ATOM   1275  C   ASP   157      23.394  75.154  87.200  1.00 32.59          
ATOM   1276  O   ASP   157      23.646  74.500  86.189  1.00 32.68          
ATOM   1277  CB  ASP   157      23.746  74.164  89.466  1.00 31.03          
ATOM   1278  CG  ASP   157      24.681  73.839  90.605  1.00 36.56          
ATOM   1279  OD1 ASP   157      25.935  74.093  90.550  1.00 33.08          
ATOM   1280  OD2 ASP   157      24.138  73.268  91.584  1.00 42.31          
ATOM   1281  N   HSD   158      22.263  75.862  87.317  1.00 32.58          
ATOM   1282  CA  HSD   158      21.267  75.865  86.212  1.00 33.67          
ATOM   1283  C   HSD   158      21.812  76.386  84.905  1.00 34.27          
ATOM   1284  O   HSD   158      21.474  75.891  83.859  1.00 36.41          
ATOM   1285  CB  HSD   158      20.048  76.710  86.541  1.00 33.62          
ATOM   1286  CG  HSD   158      19.214  76.152  87.644  1.00 35.35          
ATOM   1287  ND1 HSD   158      18.549  76.950  88.546  1.00 38.91          
ATOM   1288  CD2 HSD   158      18.948  74.878  88.003  1.00 34.79          
ATOM   1289  CE1 HSD   158      17.885  76.188  89.397  1.00 38.31          
ATOM   1290  NE2 HSD   158      18.142  74.926  89.112  1.00 37.21          
ATOM   1291  N   ALA   159      22.637  77.413  84.955  1.00 34.98          
ATOM   1292  CA  ALA   159      23.142  77.995  83.765  1.00 35.22          
ATOM   1293  C   ALA   159      24.129  77.008  83.120  1.00 36.05          
ATOM   1294  O   ALA   159      24.337  77.007  81.904  1.00 36.49          
ATOM   1295  CB  ALA   159      23.767  79.320  84.087  1.00 35.70          
ATOM   1296  N   LYS   160      24.704  76.105  83.900  1.00 36.27          
ATOM   1297  CA  LYS   160      25.509  75.037  83.237  1.00 36.63          
ATOM   1298  C   LYS   160      24.617  73.922  82.701  1.00 35.70          
ATOM   1299  O   LYS   160      24.758  73.460  81.592  1.00 36.30          
ATOM   1300  CB  LYS   160      26.550  74.460  84.187  1.00 37.31          
ATOM   1301  CG  LYS   160      27.457  75.480  84.775  1.00 36.11          
ATOM   1302  CD  LYS   160      28.391  74.850  85.757  1.00 36.24          
ATOM   1303  CE  LYS   160      29.345  75.881  86.264  1.00 39.40          
ATOM   1304  NZ  LYS   160      28.604  76.896  87.094  1.00 37.17          
ATOM   1305  N   PHE   161      23.653  73.512  83.483  1.00 35.63          
ATOM   1306  CA  PHE   161      22.675  72.581  82.967  1.00 35.34          
ATOM   1307  C   PHE   161      22.119  73.093  81.635  1.00 35.19          
ATOM   1308  O   PHE   161      21.964  72.347  80.685  1.00 37.17          
ATOM   1309  CB  PHE   161      21.547  72.339  83.984  1.00 34.81          
ATOM   1310  CG  PHE   161      22.021  71.846  85.329  1.00 34.67          
ATOM   1311  CD1 PHE   161      23.239  71.194  85.469  1.00 36.02          
ATOM   1312  CD2 PHE   161      21.214  71.986  86.469  1.00 35.90          
ATOM   1313  CE1 PHE   161      23.701  70.698  86.771  1.00 35.61          
ATOM   1314  CE2 PHE   161      21.650  71.517  87.745  1.00 33.40          
ATOM   1315  CZ  PHE   161      22.908  70.880  87.886  1.00 33.62          
ATOM   1316  N   ILE   162      21.851  74.379  81.514  1.00 34.48          
ATOM   1317  CA  ILE   162      21.309  74.876  80.247  1.00 32.33          
ATOM   1318  C   ILE   162      22.447  74.848  79.245  1.00 30.98          
ATOM   1319  O   ILE   162      22.325  74.305  78.154  1.00 30.63          
ATOM   1320  CB  ILE   162      20.722  76.327  80.448  1.00 33.26          
ATOM   1321  CG1 ILE   162      19.564  76.297  81.447  1.00 34.68          
ATOM   1322  CG2 ILE   162      20.358  76.974  79.123  1.00 31.44          
ATOM   1323  CD  ILE   162      18.934  77.711  81.788  1.00 35.43          
ATOM   1324  N   GLY   163      23.619  75.366  79.635  1.00 30.82          
ATOM   1325  CA  GLY   163      24.782  75.333  78.742  1.00 27.80          
ATOM   1326  C   GLY   163      25.039  73.968  78.160  1.00 28.42          
ATOM   1327  O   GLY   163      25.347  73.833  76.985  1.00 28.60          
ATOM   1328  N   HSD   164      24.953  72.936  78.990  1.00 29.19          
ATOM   1329  CA  HSD   164      25.325  71.574  78.557  1.00 30.68          
ATOM   1330  C   HSD   164      24.203  70.896  77.784  1.00 31.47          
ATOM   1331  O   HSD   164      24.481  70.107  76.912  1.00 33.24          
ATOM   1332  CB  HSD   164      25.735  70.692  79.767  1.00 30.09          
ATOM   1333  CG  HSD   164      27.095  71.029  80.305  1.00 31.98          
ATOM   1334  ND1 HSD   164      28.110  70.098  80.436  1.00 32.42          
ATOM   1335  CD2 HSD   164      27.611  72.213  80.715  1.00 32.58          
ATOM   1336  CE1 HSD   164      29.195  70.702  80.901  1.00 34.46          
ATOM   1337  NE2 HSD   164      28.920  71.988  81.077  1.00 34.48          
ATOM   1338  N   LEU   165      22.944  71.199  78.094  1.00 32.56          
ATOM   1339  CA  LEU   165      21.808  70.502  77.460  1.00 33.05          
ATOM   1340  C   LEU   165      21.272  71.157  76.160  1.00 33.28          
ATOM   1341  O   LEU   165      20.489  70.561  75.405  1.00 34.32          
ATOM   1342  CB  LEU   165      20.690  70.343  78.479  1.00 32.81          
ATOM   1343  CG  LEU   165      20.457  69.125  79.386  1.00 34.49          
ATOM   1344  CD1 LEU   165      21.306  67.844  79.081  1.00 32.26          
ATOM   1345  CD2 LEU   165      20.462  69.528  80.832  1.00 34.95          
ATOM   1346  N   LEU   166      21.654  72.395  75.920  1.00 33.15          
ATOM   1347  CA  LEU   166      21.511  72.994  74.596  1.00 32.58          
ATOM   1348  C   LEU   166      22.364  72.194  73.579  1.00 33.76          
ATOM   1349  O   LEU   166      23.492  71.737  73.907  1.00 33.94          
ATOM   1350  CB  LEU   166      21.950  74.474  74.605  1.00 31.30          
ATOM   1351  CG  LEU   166      20.999  75.521  75.206  1.00 29.39          
ATOM   1352  CD1 LEU   166      21.648  76.829  75.352  1.00 24.85          
ATOM   1353  CD2 LEU   166      19.784  75.714  74.283  1.00 30.49          
ATOM   1354  N   ASP   167      21.830  72.027  72.358  1.00 32.65          
ATOM   1355  CA  ASP   167      22.628  71.493  71.266  1.00 32.19          
ATOM   1356  C   ASP   167      23.824  72.408  71.053  1.00 32.14          
ATOM   1357  O   ASP   167      23.696  73.656  71.076  1.00 32.16          
ATOM   1358  CB  ASP   167      21.824  71.492  69.996  1.00 30.98          
ATOM   1359  CG  ASP   167      22.476  70.688  68.893  1.00 31.96          
ATOM   1360  OD1 ASP   167      22.556  69.443  69.019  1.00 33.21          
ATOM   1361  OD2 ASP   167      22.832  71.269  67.838  1.00 30.74          
ATOM   1362  N   PRO   168      24.978  71.806  70.801  1.00 31.53          
ATOM   1363  CA  PRO   168      26.215  72.554  70.679  1.00 30.56          
ATOM   1364  C   PRO   168      26.171  73.408  69.390  1.00 32.57          
ATOM   1365  O   PRO   168      27.052  74.254  69.167  1.00 31.61          
ATOM   1366  CB  PRO   168      27.278  71.441  70.596  1.00 30.40          
ATOM   1367  CG  PRO   168      26.651  70.245  71.230  1.00 27.00          
ATOM   1368  CD  PRO   168      25.203  70.345  70.805  1.00 31.70          
ATOM   1369  N   SER   169      25.159  73.185  68.532  1.00 31.56          
ATOM   1370  CA  SER   169      25.038  73.994  67.340  1.00 31.29          
ATOM   1371  C   SER   169      24.308  75.329  67.653  1.00 32.30          
ATOM   1372  O   SER   169      24.077  76.179  66.752  1.00 31.95          
ATOM   1373  CB  SER   169      24.237  73.235  66.289  1.00 30.78          
ATOM   1374  OG  SER   169      22.848  73.324  66.611  1.00 28.80          
ATOM   1375  N   GLU   170      23.889  75.497  68.904  1.00 32.65          
ATOM   1376  CA  GLU   170      23.224  76.755  69.287  1.00 32.83          
ATOM   1377  C   GLU   170      24.305  77.570  69.990  1.00 32.03          
ATOM   1378  O   GLU   170      24.282  77.721  71.229  1.00 30.62          
ATOM   1379  CB  GLU   170      22.015  76.517  70.220  1.00 33.20          
ATOM   1380  CG  GLU   170      20.883  75.742  69.599  1.00 35.37          
ATOM   1381  CD  GLU   170      19.964  76.628  68.732  1.00 41.36          
ATOM   1382  OE1 GLU   170      20.168  77.872  68.664  1.00 43.97          
ATOM   1383  OE2 GLU   170      19.011  76.093  68.114  1.00 44.29          
ATOM   1384  N   ARG   171      25.248  78.060  69.182  1.00 31.72          
ATOM   1385  CA  ARG   171      26.475  78.723  69.681  1.00 32.79          
ATOM   1386  C   ARG   171      26.165  80.011  70.422  1.00 33.01          
ATOM   1387  O   ARG   171      26.712  80.261  71.486  1.00 32.87          
ATOM   1388  CB  ARG   171      27.439  79.025  68.531  1.00 30.94          
ATOM   1389  CG  ARG   171      27.905  77.771  67.858  1.00 32.75          
ATOM   1390  CD  ARG   171      28.556  78.085  66.550  1.00 32.73          
ATOM   1391  NE  ARG   171      29.166  76.876  66.013  1.00 35.50          
ATOM   1392  CZ  ARG   171      30.458  76.565  66.178  1.00 38.36          
ATOM   1393  NH1 ARG   171      31.278  77.357  66.877  1.00 33.16          
ATOM   1394  NH2 ARG   171      30.938  75.457  65.632  1.00 40.49          
ATOM   1395  N   LYS   172      25.275  80.821  69.859  1.00 32.97          
ATOM   1396  CA  LYS   172      24.909  82.056  70.513  1.00 34.25          
ATOM   1397  C   LYS   172      24.342  81.787  71.903  1.00 33.89          
ATOM   1398  O   LYS   172      24.881  82.262  72.902  1.00 33.98          
ATOM   1399  CB  LYS   172      23.921  82.817  69.629  1.00 35.35          
ATOM   1400  CG  LYS   172      23.384  84.111  70.221  1.00 39.92          
ATOM   1401  CD  LYS   172      24.461  85.188  70.359  1.00 47.90          
ATOM   1402  CE  LYS   172      23.900  86.493  70.904  1.00 49.36          
ATOM   1403  NZ  LYS   172      25.027  87.256  71.473  1.00 49.88          
ATOM   1404  N   LEU   173      23.285  80.989  71.972  1.00 33.35          
ATOM   1405  CA  LEU   173      22.641  80.631  73.238  1.00 33.25          
ATOM   1406  C   LEU   173      23.532  79.883  74.239  1.00 33.27          
ATOM   1407  O   LEU   173      23.439  80.131  75.431  1.00 33.00          
ATOM   1408  CB  LEU   173      21.419  79.758  72.970  1.00 33.12          
ATOM   1409  CG  LEU   173      20.317  80.456  72.191  1.00 32.94          
ATOM   1410  CD1 LEU   173      19.218  79.434  71.998  1.00 34.36          
ATOM   1411  CD2 LEU   173      19.801  81.657  73.003  1.00 32.64          
ATOM   1412  N   VAL   174      24.336  78.927  73.763  1.00 34.48          
ATOM   1413  CA  VAL   174      25.307  78.254  74.618  1.00 33.90          
ATOM   1414  C   VAL   174      26.267  79.318  75.111  1.00 34.97          
ATOM   1415  O   VAL   174      26.691  79.272  76.255  1.00 36.03          
ATOM   1416  CB  VAL   174      26.139  77.181  73.888  1.00 34.54          
ATOM   1417  CG1 VAL   174      27.324  76.760  74.740  1.00 30.95          
ATOM   1418  CG2 VAL   174      25.303  75.937  73.518  1.00 32.91          
ATOM   1419  N   ASP   175      26.628  80.299  74.294  1.00 35.67          
ATOM   1420  CA  ASP   175      27.554  81.331  74.851  1.00 37.21          
ATOM   1421  C   ASP   175      26.879  82.176  75.943  1.00 36.14          
ATOM   1422  O   ASP   175      27.507  82.580  76.918  1.00 35.58          
ATOM   1423  CB  ASP   175      28.143  82.245  73.773  1.00 38.38          
ATOM   1424  CG  ASP   175      29.279  83.129  74.314  1.00 44.70          
ATOM   1425  OD1 ASP   175      30.366  82.564  74.644  1.00 49.80          
ATOM   1426  OD2 ASP   175      29.094  84.387  74.425  1.00 48.60          
ATOM   1427  N   THR   176      25.585  82.415  75.789  1.00 35.27          
ATOM   1428  CA  THR   176      24.882  83.205  76.754  1.00 35.40          
ATOM   1429  C   THR   176      24.768  82.411  78.053  1.00 35.65          
ATOM   1430  O   THR   176      25.034  82.936  79.136  1.00 35.72          
ATOM   1431  CB  THR   176      23.510  83.564  76.226  1.00 36.01          
ATOM   1432  OG1 THR   176      23.653  84.245  74.968  1.00 36.23          
ATOM   1433  CG2 THR   176      22.779  84.443  77.209  1.00 36.24          
ATOM   1434  N   ALA   177      24.408  81.135  77.945  1.00 34.29          
ATOM   1435  CA  ALA   177      24.355  80.297  79.127  1.00 33.58          
ATOM   1436  C   ALA   177      25.674  80.438  79.863  1.00 33.02          
ATOM   1437  O   ALA   177      25.669  80.730  81.033  1.00 33.97          
ATOM   1438  CB  ALA   177      24.076  78.848  78.778  1.00 31.83          
ATOM   1439  N   ARG   178      26.799  80.273  79.179  1.00 33.42          
ATOM   1440  CA  ARG   178      28.134  80.325  79.830  1.00 34.65          
ATOM   1441  C   ARG   178      28.415  81.645  80.542  1.00 34.04          
ATOM   1442  O   ARG   178      29.048  81.656  81.596  1.00 34.83          
ATOM   1443  CB  ARG   178      29.252  80.030  78.805  1.00 35.48          
ATOM   1444  CG  ARG   178      30.657  80.272  79.307  1.00 42.13          
ATOM   1445  CD  ARG   178      31.708  79.985  78.259  1.00 52.54          
ATOM   1446  NE  ARG   178      33.012  80.544  78.645  1.00 61.90          
ATOM   1447  CZ  ARG   178      33.348  81.845  78.583  1.00 65.37          
ATOM   1448  NH1 ARG   178      32.486  82.780  78.163  1.00 64.21          
ATOM   1449  NH2 ARG   178      34.562  82.226  78.961  1.00 66.87          
ATOM   1450  N   ASN   179      27.982  82.760  79.960  1.00 33.38          
ATOM   1451  CA  ASN   179      28.177  84.048  80.593  1.00 34.01          
ATOM   1452  C   ASN   179      27.398  84.153  81.920  1.00 33.84          
ATOM   1453  O   ASN   179      27.935  84.607  82.908  1.00 35.72          
ATOM   1454  CB  ASN   179      27.833  85.197  79.665  1.00 33.36          
ATOM   1455  CG  ASN   179      28.828  85.382  78.547  1.00 37.32          
ATOM   1456  OD1 ASN   179      30.026  85.050  78.652  1.00 37.85          
ATOM   1457  ND2 ASN   179      28.332  85.918  77.440  1.00 38.66          
ATOM   1458  N   PHE   180      26.146  83.717  81.952  1.00 33.49          
ATOM   1459  CA  PHE   180      25.408  83.617  83.182  1.00 32.38          
ATOM   1460  C   PHE   180      26.108  82.695  84.152  1.00 33.70          
ATOM   1461  O   PHE   180      26.207  83.002  85.334  1.00 33.37          
ATOM   1462  CB  PHE   180      24.027  83.053  82.908  1.00 31.91          
ATOM   1463  CG  PHE   180      23.066  84.092  82.432  1.00 31.48          
ATOM   1464  CD1 PHE   180      22.770  85.203  83.232  1.00 32.14          
ATOM   1465  CD2 PHE   180      22.529  84.022  81.202  1.00 26.73          
ATOM   1466  CE1 PHE   180      21.923  86.187  82.799  1.00 34.54          
ATOM   1467  CE2 PHE   180      21.644  85.036  80.764  1.00 31.39          
ATOM   1468  CZ  PHE   180      21.350  86.099  81.566  1.00 29.88          
ATOM   1469  N   SER   181      26.522  81.522  83.666  1.00 34.68          
ATOM   1470  CA  SER   181      27.215  80.570  84.524  1.00 35.67          
ATOM   1471  C   SER   181      28.416  81.250  85.211  1.00 35.74          
ATOM   1472  O   SER   181      28.569  81.100  86.414  1.00 36.52          
ATOM   1473  CB  SER   181      27.669  79.345  83.738  1.00 35.73          
ATOM   1474  OG  SER   181      28.551  78.609  84.547  1.00 34.10          
ATOM   1475  N   ASN   182      29.205  82.046  84.480  1.00 35.86          
ATOM   1476  CA  ASN   182      30.391  82.738  85.051  1.00 36.69          
ATOM   1477  C   ASN   182      29.987  83.863  86.021  1.00 38.32          
ATOM   1478  O   ASN   182      30.717  84.162  86.982  1.00 38.20          
ATOM   1479  CB  ASN   182      31.273  83.410  83.986  1.00 36.52          
ATOM   1480  CG  ASN   182      31.972  82.430  83.027  1.00 38.44          
ATOM   1481  OD1 ASN   182      32.539  82.847  81.993  1.00 37.99          
ATOM   1482  ND2 ASN   182      31.924  81.146  83.340  1.00 38.87          
ATOM   1483  N   ASP   183      28.852  84.511  85.751  1.00 39.08          
ATOM   1484  CA  ASP   183      28.392  85.639  86.557  1.00 39.96          
ATOM   1485  C   ASP   183      28.039  85.127  87.961  1.00 40.07          
ATOM   1486  O   ASP   183      28.444  85.696  89.000  1.00 39.11          
ATOM   1487  CB  ASP   183      27.150  86.262  85.908  1.00 40.86          
ATOM   1488  CG  ASP   183      27.493  87.238  84.783  1.00 45.25          
ATOM   1489  OD1 ASP   183      28.707  87.527  84.610  1.00 45.91          
ATOM   1490  OD2 ASP   183      26.539  87.731  84.082  1.00 48.29          
ATOM   1491  N   PHE   184      27.299  84.026  87.979  1.00 39.47          
ATOM   1492  CA  PHE   184      26.830  83.479  89.213  1.00 39.05          
ATOM   1493  C   PHE   184      27.918  82.736  89.942  1.00 38.90          
ATOM   1494  O   PHE   184      27.894  82.691  91.165  1.00 39.59          
ATOM   1495  CB  PHE   184      25.606  82.607  88.989  1.00 37.65          
ATOM   1496  CG  PHE   184      24.334  83.396  88.889  1.00 37.50          
ATOM   1497  CD1 PHE   184      23.638  83.762  90.038  1.00 36.68          
ATOM   1498  CD2 PHE   184      23.847  83.798  87.663  1.00 34.67          
ATOM   1499  CE1 PHE   184      22.459  84.505  89.960  1.00 38.45          
ATOM   1500  CE2 PHE   184      22.678  84.551  87.570  1.00 37.65          
ATOM   1501  CZ  PHE   184      21.966  84.885  88.714  1.00 38.28          
ATOM   1502  N   ASP   185      28.878  82.156  89.228  1.00 39.48          
ATOM   1503  CA  ASP   185      30.069  81.633  89.928  1.00 39.10          
ATOM   1504  C   ASP   185      30.528  82.759  90.798  1.00 39.43          
ATOM   1505  O   ASP   185      30.616  82.615  92.011  1.00 40.10          
ATOM   1506  CB  ASP   185      31.207  81.269  88.989  1.00 39.05          
ATOM   1507  CG  ASP   185      31.093  79.859  88.360  1.00 39.64          
ATOM   1508  OD1 ASP   185      30.115  79.131  88.621  1.00 37.88          
ATOM   1509  OD2 ASP   185      32.039  79.487  87.580  1.00 39.49          
ATOM   1510  N   GLU   186      30.774  83.905  90.168  1.00 39.75          
ATOM   1511  CA  GLU   186      31.296  85.114  90.811  1.00 40.52          
ATOM   1512  C   GLU   186      30.432  85.734  91.946  1.00 39.69          
ATOM   1513  O   GLU   186      30.945  86.148  92.961  1.00 38.66          
ATOM   1514  CB  GLU   186      31.510  86.168  89.741  1.00 41.03          
ATOM   1515  CG  GLU   186      32.791  86.940  89.926  1.00 47.44          
ATOM   1516  CD  GLU   186      32.787  88.269  89.173  1.00 52.24          
ATOM   1517  OE1 GLU   186      31.672  88.740  88.798  1.00 51.05          
ATOM   1518  OE2 GLU   186      33.910  88.808  88.951  1.00 51.48          
ATOM   1519  N   LEU   187      29.127  85.827  91.740  1.00 38.67          
ATOM   1520  CA  LEU   187      28.220  86.196  92.799  1.00 38.18          
ATOM   1521  C   LEU   187      28.222  85.220  93.996  1.00 38.61          
ATOM   1522  O   LEU   187      28.081  85.657  95.160  1.00 38.10          
ATOM   1523  CB  LEU   187      26.785  86.310  92.274  1.00 37.27          
ATOM   1524  CG  LEU   187      26.542  87.440  91.311  1.00 35.64          
ATOM   1525  CD1 LEU   187      25.082  87.438  91.017  1.00 32.83          
ATOM   1526  CD2 LEU   187      27.010  88.775  91.896  1.00 32.69          
ATOM   1527  N   MET   188      28.304  83.918  93.697  1.00 38.69          
ATOM   1528  CA  MET   188      28.411  82.890  94.730  1.00 38.71          
ATOM   1529  C   MET   188      29.705  83.062  95.510  1.00 39.32          
ATOM   1530  O   MET   188      29.726  82.902  96.737  1.00 39.80          
ATOM   1531  CB  MET   188      28.375  81.484  94.133  1.00 38.04          
ATOM   1532  CG  MET   188      28.173  80.339  95.144  1.00 40.86          
ATOM   1533  SD  MET   188      28.539  78.681  94.431  1.00 43.30          
ATOM   1534  CE  MET   188      30.320  78.859  94.404  1.00 46.35          
ATOM   1535  N   TYR   189      30.800  83.359  94.832  1.00 40.21          
ATOM   1536  CA  TYR   189      32.027  83.486  95.584  1.00 42.08          
ATOM   1537  C   TYR   189      32.004  84.764  96.421  1.00 41.58          
ATOM   1538  O   TYR   189      32.632  84.835  97.453  1.00 42.12          
ATOM   1539  CB  TYR   189      33.273  83.418  94.692  1.00 43.73          
ATOM   1540  CG  TYR   189      34.535  83.048  95.478  1.00 50.34          
ATOM   1541  CD1 TYR   189      34.632  83.301  96.860  1.00 54.83          
ATOM   1542  CD2 TYR   189      35.640  82.472  94.848  1.00 56.38          
ATOM   1543  CE1 TYR   189      35.775  82.978  97.583  1.00 57.35          
ATOM   1544  CE2 TYR   189      36.811  82.166  95.570  1.00 57.43          
ATOM   1545  CZ  TYR   189      36.862  82.423  96.928  1.00 59.03          
ATOM   1546  OH  TYR   189      38.007  82.124  97.631  1.00 61.19          
ATOM   1547  N   GLN   190      31.257  85.776  95.992  1.00 41.03          
ATOM   1548  CA  GLN   190      31.114  86.965  96.818  1.00 39.72          
ATOM   1549  C   GLN   190      30.346  86.605  98.085  1.00 39.37          
ATOM   1550  O   GLN   190      30.758  87.010  99.186  1.00 37.96          
ATOM   1551  CB  GLN   190      30.447  88.108  96.050  1.00 39.72          
ATOM   1552  CG  GLN   190      31.440  88.905  95.231  1.00 38.26          
ATOM   1553  CD  GLN   190      30.804  90.034  94.437  1.00 39.05          
ATOM   1554  OE1 GLN   190      31.490  90.928  93.947  1.00 41.43          
ATOM   1555  NE2 GLN   190      29.514  89.984  94.285  1.00 35.26          
ATOM   1556  N   ALA   191      29.270  85.815  97.938  1.00 38.03          
ATOM   1557  CA  ALA   191      28.482  85.386  99.104  1.00 38.87          
ATOM   1558  C   ALA   191      29.259  84.510 100.092  1.00 39.85          
ATOM   1559  O   ALA   191      29.055  84.588 101.282  1.00 38.77          
ATOM   1560  CB  ALA   191      27.154  84.683  98.689  1.00 38.51          
ATOM   1561  N   ILE   192      30.130  83.643  99.582  1.00 41.25          
ATOM   1562  CA  ILE   192      30.892  82.790 100.436  1.00 42.32          
ATOM   1563  C   ILE   192      31.748  83.678 101.322  1.00 42.19          
ATOM   1564  O   ILE   192      31.715  83.531 102.519  1.00 42.64          
ATOM   1565  CB  ILE   192      31.745  81.801  99.599  1.00 42.95          
ATOM   1566  CG1 ILE   192      30.828  80.762  98.944  1.00 45.21          
ATOM   1567  CG2 ILE   192      32.849  81.156 100.453  1.00 43.92          
ATOM   1568  CD  ILE   192      31.441  80.074  97.686  1.00 47.75          
ATOM   1569  N   ASP   193      32.516  84.587 100.737  1.00 42.40          
ATOM   1570  CA  ASP   193      33.291  85.540 101.509  1.00 42.90          
ATOM   1571  C   ASP   193      32.439  86.336 102.529  1.00 42.89          
ATOM   1572  O   ASP   193      32.834  86.490 103.699  1.00 40.18          
ATOM   1573  CB  ASP   193      34.045  86.471 100.568  1.00 43.55          
ATOM   1574  CG  ASP   193      35.323  85.810  99.974  1.00 47.26          
ATOM   1575  OD1 ASP   193      35.827  84.796 100.551  1.00 46.34          
ATOM   1576  OD2 ASP   193      35.809  86.312  98.929  1.00 48.52          
ATOM   1577  N   LEU   194      31.263  86.808 102.087  1.00 42.95          
ATOM   1578  CA  LEU   194      30.400  87.599 102.938  1.00 44.09          
ATOM   1579  C   LEU   194      30.038  86.730 104.110  1.00 44.61          
ATOM   1580  O   LEU   194      30.001  87.189 105.239  1.00 44.64          
ATOM   1581  CB  LEU   194      29.124  88.052 102.209  1.00 44.93          
ATOM   1582  CG  LEU   194      28.760  89.536 102.010  1.00 45.93          
ATOM   1583  CD1 LEU   194      27.233  89.759 102.174  1.00 47.95          
ATOM   1584  CD2 LEU   194      29.490  90.453 102.934  1.00 46.58          
ATOM   1585  N   GLU   195      29.816  85.451 103.842  1.00 45.17          
ATOM   1586  CA  GLU   195      29.312  84.527 104.837  1.00 45.91          
ATOM   1587  C   GLU   195      30.390  84.206 105.872  1.00 45.81          
ATOM   1588  O   GLU   195      30.115  84.066 107.071  1.00 46.65          
ATOM   1589  CB  GLU   195      28.876  83.265 104.127  1.00 46.65          
ATOM   1590  CG  GLU   195      27.681  82.589 104.714  1.00 50.58          
ATOM   1591  CD  GLU   195      28.028  81.275 105.326  1.00 58.14          
ATOM   1592  OE1 GLU   195      27.366  80.266 104.927  1.00 61.46          
ATOM   1593  OE2 GLU   195      28.966  81.260 106.179  1.00 59.12          
ATOM   1594  N   SER   196      31.622  84.096 105.398  1.00 44.54          
ATOM   1595  CA  SER   196      32.757  83.845 106.257  1.00 43.80          
ATOM   1596  C   SER   196      33.031  85.050 107.134  1.00 43.45          
ATOM   1597  O   SER   196      33.396  84.893 108.286  1.00 43.53          
ATOM   1598  CB  SER   196      33.964  83.507 105.405  1.00 43.50          
ATOM   1599  OG  SER   196      33.720  82.225 104.808  1.00 45.94          
ATOM   1600  N   MET   197      32.843  86.254 106.579  1.00 42.56          
ATOM   1601  CA  MET   197      33.071  87.479 107.312  1.00 41.22          
ATOM   1602  C   MET   197      31.934  87.793 108.266  1.00 42.25          
ATOM   1603  O   MET   197      31.901  88.889 108.857  1.00 43.38          
ATOM   1604  CB  MET   197      33.302  88.675 106.384  1.00 40.11          
ATOM   1605  CG  MET   197      34.582  88.638 105.607  1.00 34.85          
ATOM   1606  SD  MET   197      34.623  90.017 104.472  1.00 33.66          
ATOM   1607  CE  MET   197      36.086  89.700 103.497  1.00 37.50          
ATOM   1608  N   LYS   198      31.004  86.872 108.450  1.00 42.69          
ATOM   1609  CA  LYS   198      29.882  87.223 109.310  1.00 44.75          
ATOM   1610  C   LYS   198      30.295  86.867 110.743  1.00 45.33          
ATOM   1611  O   LYS   198      31.259  86.109 110.920  1.00 46.91          
ATOM   1612  CB  LYS   198      28.596  86.537 108.863  1.00 44.58          
ATOM   1613  CG  LYS   198      28.355  85.235 109.548  1.00 46.60          
ATOM   1614  CD  LYS   198      27.299  84.427 108.822  1.00 50.04          
ATOM   1615  CE  LYS   198      27.039  83.088 109.531  1.00 51.74          
ATOM   1616  NZ  LYS   198      25.586  82.727 109.360  1.00 55.90          
ATOM   1617  N   PRO   199      29.636  87.440 111.773  1.00 45.22          
ATOM   1618  CA  PRO   199      28.523  88.394 111.778  1.00 44.46          
ATOM   1619  C   PRO   199      28.969  89.850 111.553  1.00 43.69          
ATOM   1620  O   PRO   199      28.141  90.729 111.346  1.00 42.99          
ATOM   1621  CB  PRO   199      27.918  88.220 113.176  1.00 44.79          
ATOM   1622  CG  PRO   199      29.061  87.740 114.053  1.00 44.85          
ATOM   1623  CD  PRO   199      30.051  87.044 113.144  1.00 45.32          
ATOM   1624  N   GLN   200      30.271  90.092 111.563  1.00 42.76          
ATOM   1625  CA  GLN   200      30.782  91.399 111.243  1.00 42.96          
ATOM   1626  C   GLN   200      30.254  91.988 109.917  1.00 43.43          
ATOM   1627  O   GLN   200      30.135  93.202 109.777  1.00 44.10          
ATOM   1628  CB  GLN   200      32.307  91.348 111.162  1.00 42.74          
ATOM   1629  CG  GLN   200      33.016  91.223 112.501  1.00 43.69          
ATOM   1630  CD  GLN   200      32.928  89.821 113.123  1.00 44.22          
ATOM   1631  OE1 GLN   200      32.724  88.786 112.442  1.00 39.34          
ATOM   1632  NE2 GLN   200      33.072  89.793 114.433  1.00 42.79          
ATOM   1633  N   SER   201      29.995  91.148 108.915  1.00 42.82          
ATOM   1634  CA  SER   201      29.673  91.659 107.592  1.00 41.89          
ATOM   1635  C   SER   201      28.192  91.947 107.499  1.00 41.94          
ATOM   1636  O   SER   201      27.722  92.536 106.518  1.00 42.01          
ATOM   1637  CB  SER   201      30.054  90.621 106.518  1.00 40.83          
ATOM   1638  OG  SER   201      29.329  89.426 106.763  1.00 38.85          
ATOM   1639  N   GLN   202      27.441  91.482 108.493  1.00 41.86          
ATOM   1640  CA  GLN   202      25.974  91.594 108.455  1.00 40.97          
ATOM   1641  C   GLN   202      25.465  92.995 108.846  1.00 40.82          
ATOM   1642  O   GLN   202      24.464  93.132 109.579  1.00 40.14          
ATOM   1643  CB  GLN   202      25.353  90.491 109.300  1.00 40.56          
ATOM   1644  CG  GLN   202      25.626  89.134 108.715  1.00 41.93          
ATOM   1645  CD  GLN   202      25.092  87.989 109.533  1.00 44.61          
ATOM   1646  OE1 GLN   202      25.626  87.665 110.603  1.00 48.41          
ATOM   1647  NE2 GLN   202      24.049  87.341 109.023  1.00 45.84          
ATOM   1648  N   THR   203      26.165  94.026 108.353  1.00 39.98          
ATOM   1649  CA  THR   203      25.714  95.415 108.489  1.00 39.52          
ATOM   1650  C   THR   203      24.626  95.644 107.443  1.00 40.21          
ATOM   1651  O   THR   203      24.617  94.993 106.403  1.00 40.13          
ATOM   1652  CB  THR   203      26.867  96.451 108.235  1.00 39.00          
ATOM   1653  OG1 THR   203      27.205  96.448 106.850  1.00 37.48          
ATOM   1654  CG2 THR   203      28.161  96.167 109.068  1.00 37.03          
ATOM   1655  N   ALA   204      23.718  96.582 107.692  1.00 40.85          
ATOM   1656  CA  ALA   204      22.635  96.852 106.745  1.00 41.10          
ATOM   1657  C   ALA   204      23.168  97.409 105.415  1.00 41.43          
ATOM   1658  O   ALA   204      22.655  97.064 104.360  1.00 41.76          
ATOM   1659  CB  ALA   204      21.582  97.817 107.365  1.00 41.70          
ATOM   1660  N   PRO   205      24.229  98.247 105.450  1.00 41.26          
ATOM   1661  CA  PRO   205      24.731  98.722 104.174  1.00 40.41          
ATOM   1662  C   PRO   205      25.357  97.631 103.299  1.00 40.56          
ATOM   1663  O   PRO   205      25.117  97.618 102.108  1.00 40.50          
ATOM   1664  CB  PRO   205      25.764  99.785 104.574  1.00 40.10          
ATOM   1665  CG  PRO   205      25.387 100.206 105.921  1.00 40.88          
ATOM   1666  CD  PRO   205      24.878  98.944 106.578  1.00 41.51          
ATOM   1667  N   LEU   206      26.152  96.729 103.879  1.00 41.41          
ATOM   1668  CA  LEU   206      26.737  95.575 103.133  1.00 41.70          
ATOM   1669  C   LEU   206      25.703  94.558 102.607  1.00 41.64          
ATOM   1670  O   LEU   206      25.826  94.098 101.492  1.00 41.73          
ATOM   1671  CB  LEU   206      27.829  94.876 103.950  1.00 40.89          
ATOM   1672  CG  LEU   206      29.070  95.728 104.212  1.00 39.91          
ATOM   1673  CD1 LEU   206      29.808  95.204 105.398  1.00 41.05          
ATOM   1674  CD2 LEU   206      29.968  95.730 102.993  1.00 36.85          
ATOM   1675  N   LEU   207      24.682  94.232 103.388  1.00 41.93          
ATOM   1676  CA  LEU   207      23.592  93.347 102.908  1.00 42.74          
ATOM   1677  C   LEU   207      22.698  93.972 101.857  1.00 42.61          
ATOM   1678  O   LEU   207      22.098  93.285 101.048  1.00 43.65          
ATOM   1679  CB  LEU   207      22.687  92.897 104.068  1.00 41.87          
ATOM   1680  CG  LEU   207      23.329  92.043 105.173  1.00 43.67          
ATOM   1681  CD1 LEU   207      22.325  91.807 106.294  1.00 44.14          
ATOM   1682  CD2 LEU   207      23.867  90.725 104.655  1.00 41.85          
ATOM   1683  N   ASP   208      22.543  95.282 101.928  1.00 42.93          
ATOM   1684  CA  ASP   208      21.744  96.013 100.972  1.00 42.43          
ATOM   1685  C   ASP   208      22.455  96.022  99.607  1.00 41.44          
ATOM   1686  O   ASP   208      21.831  95.755  98.579  1.00 40.32          
ATOM   1687  CB  ASP   208      21.519  97.426 101.535  1.00 43.87          
ATOM   1688  CG  ASP   208      20.793  98.337 100.588  1.00 48.46          
ATOM   1689  OD1 ASP   208      19.835  97.877  99.921  1.00 56.34          
ATOM   1690  OD2 ASP   208      21.166  99.531 100.529  1.00 51.53          
ATOM   1691  N   GLN   209      23.767  96.295  99.597  1.00 39.64          
ATOM   1692  CA  GLN   209      24.554  96.215  98.369  1.00 39.07          
ATOM   1693  C   GLN   209      24.641  94.780  97.780  1.00 38.76          
ATOM   1694  O   GLN   209      24.442  94.560  96.587  1.00 38.96          
ATOM   1695  CB  GLN   209      25.951  96.794  98.597  1.00 39.16          
ATOM   1696  CG  GLN   209      26.901  96.581  97.408  1.00 40.28          
ATOM   1697  CD  GLN   209      26.650  97.517  96.211  1.00 41.28          
ATOM   1698  OE1 GLN   209      27.319  97.410  95.163  1.00 44.18          
ATOM   1699  NE2 GLN   209      25.720  98.446  96.368  1.00 40.87          
ATOM   1700  N   PHE   210      24.945  93.811  98.625  1.00 38.71          
ATOM   1701  CA  PHE   210      24.846  92.381  98.297  1.00 38.52          
ATOM   1702  C   PHE   210      23.564  92.063  97.517  1.00 38.81          
ATOM   1703  O   PHE   210      23.640  91.587  96.385  1.00 38.68          
ATOM   1704  CB  PHE   210      24.838  91.606  99.606  1.00 38.49          
ATOM   1705  CG  PHE   210      24.846  90.132  99.458  1.00 40.01          
ATOM   1706  CD1 PHE   210      25.834  89.497  98.704  1.00 42.66          
ATOM   1707  CD2 PHE   210      23.922  89.358 100.144  1.00 39.68          
ATOM   1708  CE1 PHE   210      25.889  88.111  98.619  1.00 43.83          
ATOM   1709  CE2 PHE   210      23.956  87.957 100.060  1.00 40.76          
ATOM   1710  CZ  PHE   210      24.938  87.333  99.311  1.00 43.95          
ATOM   1711  N   LEU   211      22.402  92.300  98.126  1.00 38.08          
ATOM   1712  CA  LEU   211      21.130  91.975  97.480  1.00 39.54          
ATOM   1713  C   LEU   211      20.966  92.718  96.183  1.00 40.24          
ATOM   1714  O   LEU   211      20.451  92.191  95.207  1.00 41.15          
ATOM   1715  CB  LEU   211      19.933  92.291  98.385  1.00 38.28          
ATOM   1716  CG  LEU   211      19.678  91.405  99.603  1.00 39.40          
ATOM   1717  CD1 LEU   211      18.552  91.999 100.467  1.00 37.65          
ATOM   1718  CD2 LEU   211      19.371  89.924  99.210  1.00 33.77          
ATOM   1719  N   ASP   212      21.381  93.966  96.188  1.00 41.98          
ATOM   1720  CA  ASP   212      21.302  94.826  95.030  1.00 43.93          
ATOM   1721  C   ASP   212      21.989  94.250  93.780  1.00 44.11          
ATOM   1722  O   ASP   212      21.370  94.102  92.689  1.00 44.18          
ATOM   1723  CB  ASP   212      21.975  96.137  95.402  1.00 44.85          
ATOM   1724  CG  ASP   212      21.044  97.290  95.323  1.00 51.67          
ATOM   1725  OD1 ASP   212      21.358  98.184  94.492  1.00 57.38          
ATOM   1726  OD2 ASP   212      19.987  97.277  96.045  1.00 57.78          
ATOM   1727  N   GLN   213      23.285  93.989  93.937  1.00 43.77          
ATOM   1728  CA  GLN   213      24.069  93.259  92.970  1.00 44.34          
ATOM   1729  C   GLN   213      23.451  91.904  92.628  1.00 43.88          
ATOM   1730  O   GLN   213      23.334  91.550  91.476  1.00 44.90          
ATOM   1731  CB  GLN   213      25.482  93.011  93.520  1.00 44.63          
ATOM   1732  CG  GLN   213      26.448  94.129  93.295  1.00 46.85          
ATOM   1733  CD  GLN   213      27.905  93.650  93.403  1.00 50.14          
ATOM   1734  OE1 GLN   213      28.144  92.530  93.846  1.00 51.58          
ATOM   1735  NE2 GLN   213      28.871  94.486  92.982  1.00 45.46          
ATOM   1736  N   ASN   214      23.079  91.126  93.625  1.00 43.26          
ATOM   1737  CA  ASN   214      22.420  89.868  93.339  1.00 42.90          
ATOM   1738  C   ASN   214      21.183  90.029  92.438  1.00 42.62          
ATOM   1739  O   ASN   214      21.000  89.232  91.515  1.00 42.68          
ATOM   1740  CB  ASN   214      22.107  89.103  94.636  1.00 41.79          
ATOM   1741  CG  ASN   214      23.366  88.768  95.412  1.00 44.58          
ATOM   1742  OD1 ASN   214      24.466  89.141  95.003  1.00 44.53          
ATOM   1743  ND2 ASN   214      23.222  88.057  96.528  1.00 45.55          
ATOM   1744  N   ARG   215      20.366  91.067  92.680  1.00 42.19          
ATOM   1745  CA  ARG   215      19.087  91.214  91.970  1.00 41.92          
ATOM   1746  C   ARG   215      19.185  91.354  90.471  1.00 42.27          
ATOM   1747  O   ARG   215      18.322  90.856  89.728  1.00 42.91          
ATOM   1748  CB  ARG   215      18.279  92.388  92.478  1.00 41.19          
ATOM   1749  CG  ARG   215      16.826  92.135  92.146  1.00 42.40          
ATOM   1750  CD  ARG   215      16.091  93.324  91.658  1.00 40.50          
ATOM   1751  NE  ARG   215      14.664  93.036  91.713  1.00 38.86          
ATOM   1752  CZ  ARG   215      13.852  92.992  90.656  1.00 39.64          
ATOM   1753  NH1 ARG   215      14.306  93.251  89.428  1.00 40.37          
ATOM   1754  NH2 ARG   215      12.568  92.699  90.822  1.00 39.37          
ATOM   1755  N   VAL   216      20.190  92.097  90.007  1.00 42.32          
ATOM   1756  CA  VAL   216      20.267  92.382  88.572  1.00 42.34          
ATOM   1757  C   VAL   216      20.579  91.100  87.795  1.00 41.17          
ATOM   1758  O   VAL   216      20.035  90.873  86.737  1.00 39.92          
ATOM   1759  CB  VAL   216      21.248  93.574  88.213  1.00 42.59          
ATOM   1760  CG1 VAL   216      21.239  94.647  89.302  1.00 43.45          
ATOM   1761  CG2 VAL   216      22.639  93.097  87.993  1.00 44.41          
ATOM   1762  N   SER   217      21.478  90.270  88.332  1.00 40.80          
ATOM   1763  CA  SER   217      21.784  89.003  87.692  1.00 39.83          
ATOM   1764  C   SER   217      20.601  88.011  87.741  1.00 38.66          
ATOM   1765  O   SER   217      20.314  87.355  86.748  1.00 38.34          
ATOM   1766  CB  SER   217      23.049  88.400  88.294  1.00 41.19          
ATOM   1767  OG  SER   217      24.196  89.130  87.899  1.00 40.44          
ATOM   1768  N   VAL   218      19.913  87.931  88.876  1.00 36.55          
ATOM   1769  CA  VAL   218      18.756  87.056  89.024  1.00 36.35          
ATOM   1770  C   VAL   218      17.567  87.403  88.119  1.00 36.19          
ATOM   1771  O   VAL   218      17.027  86.525  87.441  1.00 36.51          
ATOM   1772  CB  VAL   218      18.261  87.011  90.494  1.00 37.04          
ATOM   1773  CG1 VAL   218      17.085  86.065  90.603  1.00 35.61          
ATOM   1774  CG2 VAL   218      19.379  86.565  91.408  1.00 33.79          
ATOM   1775  N   ALA   219      17.165  88.668  88.094  1.00 36.12          
ATOM   1776  CA  ALA   219      16.103  89.111  87.185  1.00 36.91          
ATOM   1777  C   ALA   219      16.550  88.794  85.750  1.00 37.54          
ATOM   1778  O   ALA   219      15.751  88.341  84.899  1.00 38.19          
ATOM   1779  CB  ALA   219      15.857  90.617  87.328  1.00 35.74          
ATOM   1780  N   SER   220      17.824  89.022  85.455  1.00 36.13          
ATOM   1781  CA  SER   220      18.248  88.754  84.101  1.00 37.00          
ATOM   1782  C   SER   220      18.247  87.235  83.745  1.00 36.84          
ATOM   1783  O   SER   220      17.787  86.859  82.664  1.00 35.71          
ATOM   1784  CB  SER   220      19.593  89.393  83.866  1.00 37.73          
ATOM   1785  OG  SER   220      19.716  89.763  82.513  1.00 43.51          
ATOM   1786  N   LEU   221      18.748  86.362  84.633  1.00 36.19          
ATOM   1787  CA  LEU   221      18.682  84.918  84.356  1.00 36.50          
ATOM   1788  C   LEU   221      17.226  84.460  84.271  1.00 36.18          
ATOM   1789  O   LEU   221      16.877  83.640  83.459  1.00 36.56          
ATOM   1790  CB  LEU   221      19.378  84.105  85.427  1.00 35.80          
ATOM   1791  CG  LEU   221      19.650  82.623  85.175  1.00 36.70          
ATOM   1792  CD1 LEU   221      20.152  82.296  83.761  1.00 33.08          
ATOM   1793  CD2 LEU   221      20.654  82.046  86.242  1.00 38.20          
ATOM   1794  N   ARG   222      16.399  84.990  85.142  1.00 36.66          
ATOM   1795  CA  ARG   222      14.970  84.670  85.176  1.00 37.31          
ATOM   1796  C   ARG   222      14.361  84.915  83.822  1.00 36.40          
ATOM   1797  O   ARG   222      13.642  84.085  83.290  1.00 35.54          
ATOM   1798  CB  ARG   222      14.270  85.559  86.203  1.00 36.68          
ATOM   1799  CG  ARG   222      13.098  84.895  86.843  1.00 40.32          
ATOM   1800  CD  ARG   222      11.966  85.855  87.103  1.00 43.39          
ATOM   1801  NE  ARG   222      11.553  86.421  85.838  1.00 50.01          
ATOM   1802  CZ  ARG   222      10.304  86.755  85.531  1.00 54.00          
ATOM   1803  NH1 ARG   222      10.034  87.282  84.325  1.00 54.78          
ATOM   1804  NH2 ARG   222       9.331  86.545  86.420  1.00 52.33          
ATOM   1805  N   ASP   223      14.686  86.074  83.263  1.00 37.24          
ATOM   1806  CA  ASP   223      14.191  86.476  81.949  1.00 37.39          
ATOM   1807  C   ASP   223      14.747  85.575  80.845  1.00 36.07          
ATOM   1808  O   ASP   223      14.025  85.213  79.913  1.00 34.91          
ATOM   1809  CB  ASP   223      14.573  87.923  81.645  1.00 38.92          
ATOM   1810  CG  ASP   223      13.808  88.948  82.501  1.00 43.63          
ATOM   1811  OD1 ASP   223      13.358  88.628  83.633  1.00 49.75          
ATOM   1812  OD2 ASP   223      13.700  90.113  82.046  1.00 49.26          
ATOM   1813  N   PHE   224      16.027  85.216  80.957  1.00 34.55          
ATOM   1814  CA  PHE   224      16.663  84.349  79.969  1.00 33.87          
ATOM   1815  C   PHE   224      15.997  82.996  80.002  1.00 33.67          
ATOM   1816  O   PHE   224      15.683  82.430  78.970  1.00 33.74          
ATOM   1817  CB  PHE   224      18.145  84.181  80.254  1.00 33.22          
ATOM   1818  CG  PHE   224      18.840  83.207  79.331  1.00 35.65          
ATOM   1819  CD1 PHE   224      18.970  83.492  77.962  1.00 35.80          
ATOM   1820  CD2 PHE   224      19.406  82.023  79.822  1.00 35.74          
ATOM   1821  CE1 PHE   224      19.634  82.604  77.109  1.00 36.62          
ATOM   1822  CE2 PHE   224      20.072  81.125  78.975  1.00 33.30          
ATOM   1823  CZ  PHE   224      20.180  81.403  77.627  1.00 35.41          
ATOM   1824  N   LYS   225      15.759  82.481  81.202  1.00 33.54          
ATOM   1825  CA  LYS   225      15.122  81.183  81.371  1.00 33.48          
ATOM   1826  C   LYS   225      13.673  81.193  80.875  1.00 34.42          
ATOM   1827  O   LYS   225      13.233  80.215  80.321  1.00 34.79          
ATOM   1828  CB  LYS   225      15.119  80.779  82.837  1.00 33.04          
ATOM   1829  CG  LYS   225      16.318  80.021  83.345  1.00 32.74          
ATOM   1830  CD  LYS   225      16.351  80.129  84.876  1.00 30.25          
ATOM   1831  CE  LYS   225      17.541  79.454  85.510  1.00 30.52          
ATOM   1832  NZ  LYS   225      17.311  79.305  87.011  1.00 25.84          
ATOM   1833  N   LYS   226      12.917  82.260  81.106  1.00 36.01          
ATOM   1834  CA  LYS   226      11.543  82.359  80.542  1.00 38.40          
ATOM   1835  C   LYS   226      11.597  82.375  79.010  1.00 38.75          
ATOM   1836  O   LYS   226      10.764  81.783  78.317  1.00 38.71          
ATOM   1837  CB  LYS   226      10.869  83.655  80.996  1.00 38.65          
ATOM   1838  CG  LYS   226       9.328  83.634  80.965  1.00 43.13          
ATOM   1839  CD  LYS   226       8.767  85.054  80.759  1.00 49.39          
ATOM   1840  CE  LYS   226       7.753  85.451  81.834  1.00 54.15          
ATOM   1841  NZ  LYS   226       6.413  84.774  81.680  1.00 59.22          
ATOM   1842  N   THR   227      12.568  83.097  78.468  1.00 38.37          
ATOM   1843  CA  THR   227      12.669  83.165  77.022  1.00 38.59          
ATOM   1844  C   THR   227      13.017  81.792  76.423  1.00 38.06          
ATOM   1845  O   THR   227      12.423  81.352  75.443  1.00 38.51          
ATOM   1846  CB  THR   227      13.710  84.196  76.631  1.00 38.17          
ATOM   1847  OG1 THR   227      13.214  85.507  76.965  1.00 39.62          
ATOM   1848  CG2 THR   227      14.027  84.093  75.150  1.00 39.87          
ATOM   1849  N   ALA   228      13.969  81.105  77.029  1.00 37.72          
ATOM   1850  CA  ALA   228      14.377  79.801  76.541  1.00 37.08          
ATOM   1851  C   ALA   228      13.260  78.807  76.733  1.00 36.48          
ATOM   1852  O   ALA   228      13.060  77.955  75.898  1.00 37.31          
ATOM   1853  CB  ALA   228      15.611  79.323  77.259  1.00 36.66          
ATOM   1854  N   ARG   229      12.597  78.844  77.874  1.00 35.79          
ATOM   1855  CA  ARG   229      11.417  78.037  78.035  1.00 36.32          
ATOM   1856  C   ARG   229      10.511  78.212  76.824  1.00 36.55          
ATOM   1857  O   ARG   229      10.219  77.228  76.171  1.00 38.02          
ATOM   1858  CB  ARG   229      10.622  78.377  79.308  1.00 35.97          
ATOM   1859  CG  ARG   229       9.277  77.583  79.390  1.00 35.71          
ATOM   1860  CD  ARG   229       8.416  78.165  80.501  1.00 34.61          
ATOM   1861  NE  ARG   229       7.878  79.459  80.089  1.00 36.34          
ATOM   1862  CZ  ARG   229       7.177  80.252  80.897  1.00 40.12          
ATOM   1863  NH1 ARG   229       6.729  81.406  80.451  1.00 38.47          
ATOM   1864  NH2 ARG   229       6.934  79.895  82.165  1.00 38.47          
ATOM   1865  N   ASP   230      10.061  79.437  76.535  1.00 36.04          
ATOM   1866  CA  ASP   230       9.160  79.700  75.409  1.00 36.95          
ATOM   1867  C   ASP   230       9.704  79.263  74.038  1.00 36.45          
ATOM   1868  O   ASP   230       8.960  78.753  73.187  1.00 35.99          
ATOM   1869  CB  ASP   230       8.792  81.182  75.346  1.00 37.70          
ATOM   1870  CG  ASP   230       7.985  81.662  76.575  1.00 41.70          
ATOM   1871  OD1 ASP   230       7.513  80.817  77.400  1.00 42.03          
ATOM   1872  OD2 ASP   230       7.855  82.928  76.714  1.00 48.38          
ATOM   1873  N   LEU   231      11.003  79.428  73.810  1.00 36.24          
ATOM   1874  CA  LEU   231      11.596  78.933  72.561  1.00 36.02          
ATOM   1875  C   LEU   231      11.598  77.408  72.455  1.00 35.72          
ATOM   1876  O   LEU   231      11.459  76.864  71.362  1.00 34.65          
ATOM   1877  CB  LEU   231      12.995  79.471  72.362  1.00 36.62          
ATOM   1878  CG  LEU   231      13.191  80.988  72.301  1.00 38.53          
ATOM   1879  CD1 LEU   231      14.708  81.288  72.295  1.00 36.72          
ATOM   1880  CD2 LEU   231      12.489  81.612  71.103  1.00 36.13          
ATOM   1881  N   ILE   232      11.736  76.708  73.573  1.00 35.63          
ATOM   1882  CA  ILE   232      11.661  75.235  73.529  1.00 37.41          
ATOM   1883  C   ILE   232      10.215  74.730  73.294  1.00 38.45          
ATOM   1884  O   ILE   232      10.002  73.795  72.514  1.00 39.03          
ATOM   1885  CB  ILE   232      12.247  74.603  74.804  1.00 37.23          
ATOM   1886  CG1 ILE   232      13.686  75.060  74.983  1.00 37.75          
ATOM   1887  CG2 ILE   232      12.202  73.077  74.734  1.00 36.36          
ATOM   1888  CD  ILE   232      14.162  74.877  76.363  1.00 39.09          
ATOM   1889  N   GLU   233       9.234  75.365  73.938  1.00 39.33          
ATOM   1890  CA  GLU   233       7.824  74.950  73.802  1.00 40.84          
ATOM   1891  C   GLU   233       7.370  75.097  72.376  1.00 41.56          
ATOM   1892  O   GLU   233       6.665  74.260  71.872  1.00 42.64          
ATOM   1893  CB  GLU   233       6.920  75.757  74.707  1.00 40.06          
ATOM   1894  CG  GLU   233       7.103  75.400  76.164  1.00 42.72          
ATOM   1895  CD  GLU   233       6.342  76.328  77.126  1.00 47.16          
ATOM   1896  OE1 GLU   233       5.861  77.425  76.683  1.00 49.88          
ATOM   1897  OE2 GLU   233       6.225  75.935  78.324  1.00 45.09          
ATOM   1898  N   GLN   234       7.838  76.158  71.737  1.00 42.77          
ATOM   1899  CA  GLN   234       7.617  76.478  70.338  1.00 42.86          
ATOM   1900  C   GLN   234       8.485  75.704  69.315  1.00 43.01          
ATOM   1901  O   GLN   234       8.212  75.749  68.120  1.00 42.42          
ATOM   1902  CB  GLN   234       7.800  77.995  70.154  1.00 43.01          
ATOM   1903  CG  GLN   234       6.906  78.790  71.046  1.00 45.96          
ATOM   1904  CD  GLN   234       6.790  80.256  70.647  1.00 50.65          
ATOM   1905  OE1 GLN   234       5.800  80.655  70.022  1.00 55.81          
ATOM   1906  NE2 GLN   234       7.779  81.066  71.014  1.00 47.86          
ATOM   1907  N   CYS   235       9.533  75.016  69.774  1.00 43.89          
ATOM   1908  CA  CYS   235      10.357  74.209  68.884  1.00 44.43          
ATOM   1909  C   CYS   235      11.249  75.073  68.019  1.00 42.74          
ATOM   1910  O   CYS   235      11.472  74.759  66.837  1.00 41.08          
ATOM   1911  CB  CYS   235       9.455  73.438  67.956  1.00 45.55          
ATOM   1912  SG  CYS   235       8.636  72.171  68.876  1.00 57.19          
ATOM   1913  N   LYS   236      11.702  76.168  68.616  1.00 40.52          
ATOM   1914  CA  LYS   236      12.418  77.194  67.927  1.00 39.58          
ATOM   1915  C   LYS   236      13.927  77.061  68.121  1.00 38.78          
ATOM   1916  O   LYS   236      14.691  77.509  67.297  1.00 39.58          
ATOM   1917  CB  LYS   236      11.908  78.568  68.356  1.00 39.26          
ATOM   1918  CG  LYS   236      10.668  79.003  67.637  1.00 39.13          
ATOM   1919  CD  LYS   236      10.315  80.413  67.990  1.00 41.11          
ATOM   1920  CE  LYS   236       9.434  81.012  66.895  1.00 43.44          
ATOM   1921  NZ  LYS   236       9.027  82.408  67.261  1.00 45.36          
ATOM   1922  N   ILE   237      14.361  76.416  69.175  1.00 38.02          
ATOM   1923  CA  ILE   237      15.791  76.094  69.295  1.00 38.03          
ATOM   1924  C   ILE   237      16.067  74.575  69.384  1.00 38.18          
ATOM   1925  O   ILE   237      15.137  73.766  69.506  1.00 38.27          
ATOM   1926  CB  ILE   237      16.438  76.805  70.478  1.00 37.23          
ATOM   1927  CG1 ILE   237      15.857  76.263  71.785  1.00 36.56          
ATOM   1928  CG2 ILE   237      16.256  78.324  70.351  1.00 37.08          
ATOM   1929  CD  ILE   237      16.588  76.838  73.015  1.00 31.73          
ATOM   1930  N   LYS   238      17.351  74.214  69.360  1.00 37.31          
ATOM   1931  CA  LYS   238      17.737  72.841  69.342  1.00 36.14          
ATOM   1932  C   LYS   238      18.390  72.501  70.636  1.00 36.38          
ATOM   1933  O   LYS   238      19.359  73.140  71.085  1.00 38.42          
ATOM   1934  CB  LYS   238      18.669  72.568  68.170  1.00 37.03          
ATOM   1935  CG  LYS   238      18.035  72.927  66.829  1.00 35.45          
ATOM   1936  CD  LYS   238      18.831  72.414  65.696  1.00 35.38          
ATOM   1937  CE  LYS   238      19.460  73.518  64.928  1.00 37.62          
ATOM   1938  NZ  LYS   238      20.472  74.077  65.782  1.00 40.96          
ATOM   1939  N   SER   239      17.865  71.467  71.249  1.00 34.86          
ATOM   1940  CA  SER   239      18.331  71.074  72.532  1.00 34.29          
ATOM   1941  C   SER   239      17.754  69.722  72.877  1.00 34.16          
ATOM   1942  O   SER   239      16.826  69.199  72.206  1.00 32.93          
ATOM   1943  CB  SER   239      17.850  72.108  73.591  1.00 35.56          
ATOM   1944  OG  SER   239      16.481  71.929  73.976  1.00 32.41          
ATOM   1945  N   ILE   240      18.269  69.194  73.979  1.00 34.06          
ATOM   1946  CA  ILE   240      17.652  68.049  74.651  1.00 33.92          
ATOM   1947  C   ILE   240      17.099  68.467  76.004  1.00 34.86          
ATOM   1948  O   ILE   240      17.135  67.681  76.955  1.00 36.49          
ATOM   1949  CB  ILE   240      18.656  66.872  74.847  1.00 33.25          
ATOM   1950  CG1 ILE   240      19.912  67.343  75.547  1.00 31.26          
ATOM   1951  CG2 ILE   240      19.095  66.301  73.535  1.00 30.82          
ATOM   1952  CD  ILE   240      20.877  66.181  75.769  1.00 23.52          
ATOM   1953  N   ILE   241      16.615  69.705  76.101  1.00 34.84          
ATOM   1954  CA  ILE   241      16.033  70.224  77.337  1.00 34.52          
ATOM   1955  C   ILE   241      14.536  69.945  77.259  1.00 36.36          
ATOM   1956  O   ILE   241      13.871  70.399  76.325  1.00 36.97          
ATOM   1957  CB  ILE   241      16.213  71.755  77.445  1.00 34.70          
ATOM   1958  CG1 ILE   241      17.698  72.142  77.494  1.00 32.68          
ATOM   1959  CG2 ILE   241      15.499  72.350  78.679  1.00 32.56          
ATOM   1960  CD  ILE   241      17.896  73.641  77.407  1.00 27.44          
ATOM   1961  N   HSD   242      14.017  69.189  78.218  1.00 36.14          
ATOM   1962  CA  HSD   242      12.618  68.948  78.272  1.00 37.06          
ATOM   1963  C   HSD   242      12.002  70.295  78.647  1.00 37.20          
ATOM   1964  O   HSD   242      12.524  71.019  79.507  1.00 37.50          
ATOM   1965  CB  HSD   242      12.297  67.873  79.325  1.00 36.82          
ATOM   1966  CG  HSD   242      10.897  67.362  79.232  1.00 37.87          
ATOM   1967  ND1 HSD   242       9.803  68.133  79.570  1.00 39.24          
ATOM   1968  CD2 HSD   242      10.401  66.173  78.801  1.00 39.12          
ATOM   1969  CE1 HSD   242       8.694  67.443  79.350  1.00 36.45          
ATOM   1970  NE2 HSD   242       9.030  66.251  78.886  1.00 37.56          
ATOM   1971  N   PRO   243      10.878  70.634  78.018  1.00 36.62          
ATOM   1972  CA  PRO   243      10.236  71.917  78.178  1.00 36.23          
ATOM   1973  C   PRO   243       9.830  72.126  79.635  1.00 36.42          
ATOM   1974  O   PRO   243       9.776  73.259  80.135  1.00 36.36          
ATOM   1975  CB  PRO   243       9.013  71.801  77.280  1.00 36.42          
ATOM   1976  CG  PRO   243       9.317  70.740  76.323  1.00 36.44          
ATOM   1977  CD  PRO   243      10.219  69.792  77.017  1.00 37.50          
ATOM   1978  N   LEU   244       9.590  71.023  80.333  1.00 36.56          
ATOM   1979  CA  LEU   244       9.218  71.098  81.720  1.00 36.32          
ATOM   1980  C   LEU   244      10.440  71.359  82.577  1.00 35.27          
ATOM   1981  O   LEU   244      10.299  71.944  83.638  1.00 35.70          
ATOM   1982  CB  LEU   244       8.536  69.805  82.134  1.00 37.38          
ATOM   1983  CG  LEU   244       8.170  69.602  83.596  1.00 39.63          
ATOM   1984  CD1 LEU   244       7.251  70.749  84.101  1.00 38.62          
ATOM   1985  CD2 LEU   244       7.510  68.211  83.729  1.00 42.95          
ATOM   1986  N   LEU   245      11.634  70.938  82.137  1.00 34.60          
ATOM   1987  CA  LEU   245      12.861  71.265  82.907  1.00 33.50          
ATOM   1988  C   LEU   245      13.092  72.765  82.777  1.00 33.76          
ATOM   1989  O   LEU   245      13.370  73.445  83.766  1.00 33.93          
ATOM   1990  CB  LEU   245      14.088  70.493  82.429  1.00 32.88          
ATOM   1991  CG  LEU   245      15.475  70.839  83.028  1.00 33.28          
ATOM   1992  CD1 LEU   245      15.485  70.701  84.556  1.00 29.82          
ATOM   1993  CD2 LEU   245      16.595  69.942  82.416  1.00 34.28          
ATOM   1994  N   ALA   246      12.938  73.294  81.568  1.00 33.30          
ATOM   1995  CA  ALA   246      13.101  74.733  81.381  1.00 34.49          
ATOM   1996  C   ALA   246      12.147  75.568  82.282  1.00 34.88          
ATOM   1997  O   ALA   246      12.519  76.583  82.845  1.00 34.31          
ATOM   1998  CB  ALA   246      12.936  75.105  79.897  1.00 34.35          
ATOM   1999  N   ASP   247      10.902  75.132  82.401  1.00 35.61          
ATOM   2000  CA  ASP   247       9.969  75.850  83.216  1.00 35.71          
ATOM   2001  C   ASP   247      10.263  75.690  84.725  1.00 35.92          
ATOM   2002  O   ASP   247      10.024  76.618  85.537  1.00 35.06          
ATOM   2003  CB  ASP   247       8.574  75.349  82.912  1.00 36.17          
ATOM   2004  CG  ASP   247       7.563  75.942  83.855  1.00 39.07          
ATOM   2005  OD1 ASP   247       7.541  77.197  83.937  1.00 40.29          
ATOM   2006  OD2 ASP   247       6.852  75.166  84.543  1.00 39.88          
ATOM   2007  N   HSD   248      10.792  74.514  85.079  1.00 35.87          
ATOM   2008  CA  HSD   248      11.132  74.125  86.450  1.00 35.69          
ATOM   2009  C   HSD   248      12.263  75.031  86.986  1.00 36.66          
ATOM   2010  O   HSD   248      12.203  75.528  88.125  1.00 37.02          
ATOM   2011  CB  HSD   248      11.570  72.667  86.395  1.00 34.87          
ATOM   2012  CG  HSD   248      12.070  72.103  87.691  1.00 35.56          
ATOM   2013  ND1 HSD   248      11.320  71.249  88.464  1.00 37.72          
ATOM   2014  CD2 HSD   248      13.270  72.209  88.314  1.00 37.44          
ATOM   2015  CE1 HSD   248      12.025  70.878  89.526  1.00 41.14          
ATOM   2016  NE2 HSD   248      13.208  71.451  89.468  1.00 35.16          
ATOM   2017  N   VAL   249      13.310  75.232  86.192  1.00 36.44          
ATOM   2018  CA  VAL   249      14.362  76.169  86.627  1.00 36.33          
ATOM   2019  C   VAL   249      13.953  77.652  86.480  1.00 36.69          
ATOM   2020  O   VAL   249      14.546  78.497  87.102  1.00 35.53          
ATOM   2021  CB  VAL   249      15.723  75.919  85.930  1.00 36.78          
ATOM   2022  CG1 VAL   249      16.161  74.460  86.084  1.00 35.72          
ATOM   2023  CG2 VAL   249      15.705  76.374  84.458  1.00 35.06          
ATOM   2024  N   PHE   250      12.936  77.975  85.659  1.00 36.70          
ATOM   2025  CA  PHE   250      12.374  79.328  85.680  1.00 35.79          
ATOM   2026  C   PHE   250      11.635  79.596  87.004  1.00 36.26          
ATOM   2027  O   PHE   250      11.711  80.693  87.575  1.00 36.29          
ATOM   2028  CB  PHE   250      11.398  79.556  84.524  1.00 36.25          
ATOM   2029  CG  PHE   250      10.543  80.758  84.719  1.00 36.32          
ATOM   2030  CD1 PHE   250      11.047  82.012  84.520  1.00 36.74          
ATOM   2031  CD2 PHE   250       9.241  80.633  85.162  1.00 39.08          
ATOM   2032  CE1 PHE   250      10.242  83.132  84.724  1.00 40.60          
ATOM   2033  CE2 PHE   250       8.427  81.751  85.359  1.00 41.35          
ATOM   2034  CZ  PHE   250       8.923  82.994  85.138  1.00 38.23          
ATOM   2035  N   ARG   251      10.918  78.597  87.512  1.00 36.02          
ATOM   2036  CA  ARG   251      10.157  78.784  88.770  1.00 35.38          
ATOM   2037  C   ARG   251      11.132  78.902  89.929  1.00 34.84          
ATOM   2038  O   ARG   251      10.931  79.669  90.861  1.00 34.77          
ATOM   2039  CB  ARG   251       9.191  77.627  89.038  1.00 35.12          
ATOM   2040  CG  ARG   251       7.777  77.884  88.516  1.00 36.72          
ATOM   2041  CD  ARG   251       6.858  76.641  88.670  1.00 35.43          
ATOM   2042  NE  ARG   251       7.067  75.686  87.583  1.00 36.83          
ATOM   2043  CZ  ARG   251       7.522  74.448  87.760  1.00 40.78          
ATOM   2044  NH1 ARG   251       7.709  73.648  86.721  1.00 38.52          
ATOM   2045  NH2 ARG   251       7.799  73.997  88.992  1.00 43.99          
ATOM   2046  N   GLU   252      12.194  78.131  89.899  1.00 34.34          
ATOM   2047  CA  GLU   252      13.154  78.286  90.973  1.00 34.62          
ATOM   2048  C   GLU   252      13.826  79.662  90.951  1.00 35.13          
ATOM   2049  O   GLU   252      13.900  80.294  91.972  1.00 36.45          
ATOM   2050  CB  GLU   252      14.192  77.157  90.970  1.00 34.99          
ATOM   2051  CG  GLU   252      13.601  75.786  91.138  1.00 36.07          
ATOM   2052  CD  GLU   252      14.628  74.710  90.966  1.00 37.48          
ATOM   2053  OE1 GLU   252      15.786  75.014  90.610  1.00 40.01          
ATOM   2054  OE2 GLU   252      14.298  73.560  91.241  1.00 38.45          
ATOM   2055  N   ALA   253      14.323  80.158  89.814  1.00 35.77          
ATOM   2056  CA  ALA   253      14.842  81.553  89.768  1.00 35.93          
ATOM   2057  C   ALA   253      13.821  82.592  90.243  1.00 36.75          
ATOM   2058  O   ALA   253      14.150  83.518  90.989  1.00 38.07          
ATOM   2059  CB  ALA   253      15.300  81.926  88.349  1.00 36.11          
ATOM   2060  N   ASP   254      12.586  82.459  89.776  1.00 37.16          
ATOM   2061  CA  ASP   254      11.516  83.352  90.120  1.00 37.28          
ATOM   2062  C   ASP   254      11.308  83.426  91.630  1.00 36.89          
ATOM   2063  O   ASP   254      11.192  84.516  92.199  1.00 36.76          
ATOM   2064  CB  ASP   254      10.249  82.905  89.414  1.00 38.58          
ATOM   2065  CG  ASP   254       9.113  83.882  89.605  1.00 43.22          
ATOM   2066  OD1 ASP   254       9.156  84.971  88.982  1.00 45.67          
ATOM   2067  OD2 ASP   254       8.185  83.561  90.383  1.00 48.43          
ATOM   2068  N   ARG   255      11.281  82.274  92.304  1.00 35.85          
ATOM   2069  CA  ARG   255      11.165  82.274  93.758  1.00 33.07          
ATOM   2070  C   ARG   255      12.380  82.983  94.402  1.00 33.19          
ATOM   2071  O   ARG   255      12.234  83.723  95.358  1.00 32.67          
ATOM   2072  CB  ARG   255      11.060  80.834  94.257  1.00 31.91          
ATOM   2073  CG  ARG   255      10.845  80.732  95.763  1.00 32.32          
ATOM   2074  CD  ARG   255      10.555  79.306  96.159  1.00 34.94          
ATOM   2075  NE  ARG   255      10.201  79.086  97.564  1.00 33.77          
ATOM   2076  CZ  ARG   255       8.937  79.067  98.013  1.00 32.26          
ATOM   2077  NH1 ARG   255       7.943  79.341  97.204  1.00 29.83          
ATOM   2078  NH2 ARG   255       8.682  78.845  99.287  1.00 32.00          
ATOM   2079  N   PHE   256      13.593  82.717  93.911  1.00 32.38          
ATOM   2080  CA  PHE   256      14.789  83.395  94.481  1.00 32.50          
ATOM   2081  C   PHE   256      14.597  84.895  94.349  1.00 32.63          
ATOM   2082  O   PHE   256      14.967  85.660  95.227  1.00 32.63          
ATOM   2083  CB  PHE   256      16.050  82.927  93.741  1.00 30.74          
ATOM   2084  CG  PHE   256      17.341  83.513  94.250  1.00 31.35          
ATOM   2085  CD1 PHE   256      17.474  83.952  95.544  1.00 32.13          
ATOM   2086  CD2 PHE   256      18.460  83.557  93.430  1.00 29.54          
ATOM   2087  CE1 PHE   256      18.651  84.420  95.991  1.00 31.71          
ATOM   2088  CE2 PHE   256      19.627  84.065  93.859  1.00 27.31          
ATOM   2089  CZ  PHE   256      19.723  84.496  95.142  1.00 32.30          
ATOM   2090  N   LEU   257      13.983  85.316  93.248  1.00 33.93          
ATOM   2091  CA  LEU   257      13.744  86.731  93.050  1.00 35.81          
ATOM   2092  C   LEU   257      12.745  87.343  94.061  1.00 37.41          
ATOM   2093  O   LEU   257      12.982  88.459  94.519  1.00 39.01          
ATOM   2094  CB  LEU   257      13.376  87.033  91.590  1.00 35.03          
ATOM   2095  CG  LEU   257      13.359  88.491  91.156  1.00 33.06          
ATOM   2096  CD1 LEU   257      14.749  89.190  91.187  1.00 29.17          
ATOM   2097  CD2 LEU   257      12.670  88.600  89.760  1.00 33.69          
ATOM   2098  N   GLU   258      11.660  86.643  94.416  1.00 38.61          
ATOM   2099  CA  GLU   258      10.757  87.107  95.483  1.00 39.83          
ATOM   2100  C   GLU   258      11.582  87.263  96.774  1.00 39.75          
ATOM   2101  O   GLU   258      11.575  88.310  97.420  1.00 39.64          
ATOM   2102  CB  GLU   258       9.660  86.073  95.790  1.00 40.69          
ATOM   2103  CG  GLU   258       8.296  86.277  95.163  1.00 45.44          
ATOM   2104  CD  GLU   258       7.139  86.068  96.158  1.00 50.39          
ATOM   2105  OE1 GLU   258       7.328  86.256  97.381  1.00 52.39          
ATOM   2106  OE2 GLU   258       6.015  85.743  95.718  1.00 53.30          
ATOM   2107  N   ILE   259      12.280  86.198  97.167  1.00 38.54          
ATOM   2108  CA  ILE   259      13.123  86.262  98.343  1.00 37.65          
ATOM   2109  C   ILE   259      14.043  87.487  98.318  1.00 38.23          
ATOM   2110  O   ILE   259      14.120  88.224  99.310  1.00 37.96          
ATOM   2111  CB  ILE   259      13.917  84.958  98.573  1.00 37.24          
ATOM   2112  CG1 ILE   259      12.977  83.779  98.775  1.00 34.24          
ATOM   2113  CG2 ILE   259      14.864  85.092  99.793  1.00 39.48          
ATOM   2114  CD  ILE   259      13.655  82.429  98.750  1.00 31.82          
ATOM   2115  N   ILE   260      14.712  87.751  97.196  1.00 38.49          
ATOM   2116  CA  ILE   260      15.603  88.918  97.140  1.00 38.41          
ATOM   2117  C   ILE   260      14.810  90.244  97.297  1.00 38.28          
ATOM   2118  O   ILE   260      15.168  91.134  98.079  1.00 37.09          
ATOM   2119  CB  ILE   260      16.421  88.952  95.821  1.00 38.67          
ATOM   2120  CG1 ILE   260      17.556  87.928  95.823  1.00 38.89          
ATOM   2121  CG2 ILE   260      17.077  90.320  95.630  1.00 39.79          
ATOM   2122  CD  ILE   260      18.273  87.891  94.528  1.00 35.72          
ATOM   2123  N   ASP   261      13.726  90.373  96.548  1.00 38.48          
ATOM   2124  CA  ASP   261      12.895  91.568  96.647  1.00 38.40          
ATOM   2125  C   ASP   261      12.231  91.753  98.019  1.00 38.68          
ATOM   2126  O   ASP   261      12.158  92.873  98.522  1.00 39.09          
ATOM   2127  CB  ASP   261      11.866  91.575  95.534  1.00 38.58          
ATOM   2128  CG  ASP   261      12.481  91.894  94.182  1.00 40.77          
ATOM   2129  OD1 ASP   261      13.670  92.342  94.133  1.00 41.03          
ATOM   2130  OD2 ASP   261      11.771  91.710  93.162  1.00 38.77          
ATOM   2131  N   MET   262      11.743  90.683  98.641  1.00 39.47          
ATOM   2132  CA  MET   262      11.163  90.817  99.979  1.00 39.79          
ATOM   2133  C   MET   262      12.221  91.140 101.026  1.00 41.29          
ATOM   2134  O   MET   262      11.989  91.976 101.920  1.00 41.10          
ATOM   2135  CB  MET   262      10.379  89.602 100.380  1.00 39.20          
ATOM   2136  CG  MET   262       9.088  89.311  99.509  1.00 41.06          
ATOM   2137  SD  MET   262       7.840  90.569  99.560  1.00 45.29          
ATOM   2138  CE  MET   262       8.180  91.327  97.969  1.00 50.88          
ATOM   2139  N   TYR   263      13.399  90.545 100.921  1.00 42.34          
ATOM   2140  CA  TYR   263      14.416  90.885 101.927  1.00 45.02          
ATOM   2141  C   TYR   263      14.825  92.330 101.786  1.00 46.06          
ATOM   2142  O   TYR   263      14.997  93.046 102.749  1.00 46.00          
ATOM   2143  CB  TYR   263      15.628  89.944 101.888  1.00 44.88          
ATOM   2144  CG  TYR   263      15.300  88.574 102.460  1.00 47.26          
ATOM   2145  CD1 TYR   263      14.210  88.408 103.285  1.00 49.66          
ATOM   2146  CD2 TYR   263      16.082  87.471 102.190  1.00 49.99          
ATOM   2147  CE1 TYR   263      13.890  87.202 103.800  1.00 52.17          
ATOM   2148  CE2 TYR   263      15.767  86.228 102.725  1.00 52.26          
ATOM   2149  CZ  TYR   263      14.673  86.115 103.531  1.00 52.86          
ATOM   2150  OH  TYR   263      14.318  84.906 104.078  1.00 56.78          
ATOM   2151  N   ASP   264      14.943  92.764 100.553  1.00 48.43          
ATOM   2152  CA  ASP   264      15.246  94.137 100.246  1.00 50.62          
ATOM   2153  C   ASP   264      14.287  95.120 100.937  1.00 51.70          
ATOM   2154  O   ASP   264      14.738  96.076 101.552  1.00 51.66          
ATOM   2155  CB  ASP   264      15.202  94.312  98.742  1.00 50.56          
ATOM   2156  CG  ASP   264      15.676  95.656  98.323  1.00 54.80          
ATOM   2157  OD1 ASP   264      16.922  95.811  98.218  1.00 58.40          
ATOM   2158  OD2 ASP   264      14.805  96.551  98.118  1.00 55.68          
ATOM   2159  N   VAL   265      12.978  94.875 100.842  1.00 52.89          
ATOM   2160  CA  VAL   265      11.975  95.695 101.522  1.00 54.42          
ATOM   2161  C   VAL   265      12.188  95.709 103.043  1.00 55.96          
ATOM   2162  O   VAL   265      12.361  96.784 103.663  1.00 55.94          
ATOM   2163  CB  VAL   265      10.530  95.207 101.223  1.00 53.98          
ATOM   2164  CG1 VAL   265       9.519  95.961 102.068  1.00 54.02          
ATOM   2165  CG2 VAL   265      10.217  95.379  99.766  1.00 54.30          
ATOM   2166  N   HSD   266      12.169  94.516 103.636  1.00 57.26          
ATOM   2167  CA  HSD   266      12.274  94.378 105.072  1.00 59.17          
ATOM   2168  C   HSD   266      13.520  95.172 105.471  1.00 59.86          
ATOM   2169  O   HSD   266      13.504  95.878 106.469  1.00 60.51          
ATOM   2170  CB  HSD   266      12.354  92.891 105.504  1.00 59.73          
ATOM   2171  CG  HSD   266      11.102  92.086 105.233  1.00 62.65          
ATOM   2172  ND1 HSD   266       9.986  92.609 104.606  1.00 65.72          
ATOM   2173  CD2 HSD   266      10.807  90.784 105.486  1.00 64.90          
ATOM   2174  CE1 HSD   266       9.048  91.680 104.517  1.00 65.77          
ATOM   2175  NE2 HSD   266       9.526  90.558 105.030  1.00 66.17          
ATOM   2176  N   LEU   267      14.571  95.091 104.645  1.00 60.20          
ATOM   2177  CA  LEU   267      15.831  95.816 104.858  1.00 60.13          
ATOM   2178  C   LEU   267      15.701  97.281 104.418  1.00 60.70          
ATOM   2179  O   LEU   267      15.840  98.206 105.225  1.00 60.80          
ATOM   2180  CB  LEU   267      16.996  95.143 104.095  1.00 59.56          
ATOM   2181  CG  LEU   267      18.401  95.350 104.679  1.00 59.35          
ATOM   2182  CD1 LEU   267      18.460  94.832 106.103  1.00 59.73          
ATOM   2183  CD2 LEU   267      19.539  94.737 103.847  1.00 57.90          
END
