
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  142 ( 1080),  selected  142 , name 1q4s_A
# Molecule2: number of CA atoms  125 (  918),  selected  125 , name T0479.pdb
# PARAMETERS: 1q4s_A.T0479.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A    10_A      T       6          5.357
LGA    T    11_A      D       7          2.811
LGA    G    12_A      -       -           -
LGA    G    13_A      -       -           -
LGA    N    14_A      -       -           -
LGA    L    15_A      F       8          1.727
LGA    P    16_A      F       9          1.633
LGA    D    17_A      G      10          2.305
LGA    V    18_A      -       -           -
LGA    A    19_A      -       -           -
LGA    S    20_A      -       -           -
LGA    H    21_A      -       -           -
LGA    Y    22_A      L      11          5.429
LGA    P    23_A      -       -           -
LGA    V    24_A      -       -           -
LGA    A    25_A      T      12          4.332
LGA    Y    26_A      I      13          4.819
LGA    E    27_A      -       -           -
LGA    Q    28_A      -       -           -
LGA    T    29_A      P      14          1.414
LGA    L    30_A      F      15          1.540
LGA    D    31_A      M      16          0.867
LGA    G    32_A      Q      17          0.932
LGA    T    33_A      L      18          0.949
LGA    V    34_A      L      19          1.042
LGA    G    35_A      G      20          1.113
LGA    F    36_A      V      21          1.151
LGA    V    37_A      V      22          1.029
LGA    I    38_A      P      23          1.322
LGA    D    39_A      E      24          0.788
LGA    E    40_A      H      25          1.838
LGA    M    41_A      S      26          1.527
LGA    T    42_A      G      27          1.312
LGA    P    43_A      N      28          2.514
LGA    E    44_A      G      29          1.239
LGA    R    45_A      T      30          0.964
LGA    A    46_A      A      31          0.934
LGA    T    47_A      R      32          0.768
LGA    A    48_A      T      33          0.767
LGA    S    49_A      R      34          0.817
LGA    V    50_A      L      35          0.842
LGA    E    51_A      P      36          1.014
LGA    V    52_A      A      37          1.621
LGA    T    53_A      R      38          0.957
LGA    D    54_A      A      39          1.253
LGA    T    55_A      D      40          1.709
LGA    L    56_A      L      41          1.537
LGA    R    57_A      V      42          0.958
LGA    Q    58_A      N      43          1.869
LGA    R    59_A      S      44          2.467
LGA    W    60_A      R      45          2.491
LGA    G    61_A      G      46          0.844
LGA    L    62_A      D      47          1.009
LGA    V    63_A      I      48          0.817
LGA    H    64_A      H      49          0.580
LGA    G    65_A      G      50          0.816
LGA    G    66_A      G      51          0.706
LGA    A    67_A      T      52          1.186
LGA    Y    68_A      L      53          1.142
LGA    C    69_A      M      54          0.660
LGA    A    70_A      S      55          0.876
LGA    L    71_A      V      56          0.962
LGA    A    72_A      L      57          0.997
LGA    E    73_A      D      58          0.347
LGA    M    74_A      F      59          0.340
LGA    L    75_A      T      60          0.718
LGA    A    76_A      L      61          1.358
LGA    T    77_A      G      62          1.336
LGA    E    78_A      A      63          2.717
LGA    A    79_A      A      64          2.955
LGA    T    80_A      I      65          1.963
LGA    V    81_A      R      66          2.582
LGA    A    82_A      G      67          2.730
LGA    V    83_A      D      68          3.198
LGA    V    84_A      T      69          3.812
LGA    H    85_A      P      70          3.952
LGA    E    86_A      E      71          1.848
LGA    K    87_A      -       -           -
LGA    G    88_A      -       -           -
LGA    M    89_A      V      72          3.426
LGA    M    90_A      G      73          1.724
LGA    A    91_A      V      74          0.818
LGA    V    92_A      A      75          0.870
LGA    G    93_A      T      76          1.015
LGA    Q    94_A      I      77          1.072
LGA    S    95_A      D      78          1.212
LGA    N    96_A      M      79          1.166
LGA    H    97_A      N      80          0.637
LGA    T    98_A      T      81          0.589
LGA    S    99_A      S      82          0.295
LGA    F   100_A      F      83          0.269
LGA    F   101_A      M      84          0.387
LGA    R   102_A      S      85          0.494
LGA    P   103_A      P      86          0.339
LGA    V   104_A      G      87          1.654
LGA    K   105_A      R      88          3.123
LGA    E   106_A      G      89          2.832
LGA    G   107_A      -       -           -
LGA    H   108_A      D      90          0.975
LGA    V   109_A      L      91          1.277
LGA    R   110_A      V      92          0.837
LGA    A   111_A      I      93          0.796
LGA    E   112_A      E      94          0.798
LGA    A   113_A      T      95          0.294
LGA    V   114_A      R      96          1.373
LGA    R   115_A      C      97          1.502
LGA    I   116_A      L      98          0.849
LGA    H   117_A      R      99          0.819
LGA    A   118_A      R     100          1.000
LGA    G   119_A      G     101          1.249
LGA    S   120_A      A     102          1.327
LGA    T   121_A      S     103          1.268
LGA    T   122_A      I     104          1.412
LGA    W   123_A      A     105          1.341
LGA    F   124_A      F     106          1.371
LGA    W   125_A      C     107          1.451
LGA    D   126_A      E     108          1.262
LGA    V   127_A      G     109          0.506
LGA    S   128_A      E     110          0.981
LGA    L   129_A      I     111          0.623
LGA    R   130_A      R     112          0.353
LGA    D   131_A      D     113          0.618
LGA    D   132_A      S     114          0.720
LGA    A   133_A      A     115          0.120
LGA    G   134_A      G     116          0.212
LGA    R   135_A      E     117          0.297
LGA    L   136_A      L     118          0.661
LGA    C   137_A      V     119          1.080
LGA    A   138_A      A     120          0.606
LGA    V   139_A      K     121          0.137
LGA    S   140_A      A     122          0.573
LGA    S   141_A      T     123          0.414
LGA    M   142_A      A     124          1.682
LGA    S   143_A      T     125          1.377
LGA    I   144_A      F     126          1.381
LGA    A   145_A      K     127          1.099
LGA    V   146_A      I     128          0.871
LGA    R   147_A      I     129          2.150
LGA    P   148_A      Q     130          2.226
LGA    R   149_A      -       -           -
LGA    R   150_A      -       -           -
LGA    D   151_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  142  125    5.0    125    1.71    18.40     92.537     6.913

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.613605 * X  +   0.349813 * Y  +  -0.707898 * Z  +  71.288338
  Y_new =  -0.628250 * X  +  -0.759363 * Y  +   0.169322 * Z  + 119.193016
  Z_new =  -0.478320 * X  +   0.548634 * Y  +   0.685719 * Z  +  56.449368 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.674793   -2.466800  [ DEG:    38.6628   -141.3372 ]
  Theta =   0.498741    2.642852  [ DEG:    28.5757    151.4243 ]
  Phi   =  -2.344402    0.797191  [ DEG:  -134.3243     45.6757 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1q4s_A                                        
REMARK     2: T0479.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1q4s_A.T0479.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  142  125   5.0  125   1.71   18.40  92.537
REMARK  ---------------------------------------------------------- 
MOLECULE 1q4s_A
HEADER    HYDROLASE                               04-AUG-03   1Q4S              
TITLE     CRYSTAL STRUCTURE OF ARTHROBACTER SP. STRAIN SU 4-                    
TITLE    2 HYDROXYBENZOYL COA THIOESTERASE COMPLEXED WITH COA AND 4-            
TITLE    3 HYDROXYBENZOIC ACID                                                  
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: THIOESTERASE;                                              
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: FCBC2, 4-CHLOROBENZOATE THIOSTERASE;                        
COMPND   5 EC: 3.1.2.23;                                                        
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ARTHROBACTER SP.;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: SU;                                                          
SOURCE   5 GENE: FCBC;                                                          
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET23B                                    
KEYWDS    THIOESTERASE, HOT-DOG                                                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.B.THODEN,Z.ZHUANG,D.DUNAWAY-MARIANO,H.M.HOLDEN                      
REVDAT   2   11-NOV-03 1Q4S    1       JRNL                                     
REVDAT   1   23-SEP-03 1Q4S    0                                                
JRNL        AUTH   J.B.THODEN,Z.ZHUANG,D.DUNAWAY-MARIANO,H.M.HOLDEN             
JRNL        TITL   THE STRUCTURE OF 4-HYDROXYBENZOYL-COA THIOESTERASE           
JRNL        TITL 2 FROM ARTHROBACTER SP. STRAIN SU                              
JRNL        REF    J.BIOL.CHEM.                  V. 278 43709 2003              
JRNL        REFN   ASTM JBCHA3  US ISSN 0021-9258                               
REMARK   2 RESOLUTION. 1.95 ANGSTROMS.                                          
DBREF  1Q4S A    1   151  UNP    Q04416   Q04416_9MICC     1    151             
DBREF  1Q4S B    1   151  UNP    Q04416   Q04416_9MICC     1    151             
SEQRES   1 A  151  MET HIS ARG THR SER ASN GLY SER HIS ALA THR GLY GLY          
SEQRES   2 A  151  ASN LEU PRO ASP VAL ALA SER HIS TYR PRO VAL ALA TYR          
SEQRES   3 A  151  GLU GLN THR LEU ASP GLY THR VAL GLY PHE VAL ILE ASP          
SEQRES   4 A  151  GLU MET THR PRO GLU ARG ALA THR ALA SER VAL GLU VAL          
SEQRES   5 A  151  THR ASP THR LEU ARG GLN ARG TRP GLY LEU VAL HIS GLY          
SEQRES   6 A  151  GLY ALA TYR CYS ALA LEU ALA GLU MET LEU ALA THR GLU          
SEQRES   7 A  151  ALA THR VAL ALA VAL VAL HIS GLU LYS GLY MET MET ALA          
SEQRES   8 A  151  VAL GLY GLN SER ASN HIS THR SER PHE PHE ARG PRO VAL          
SEQRES   9 A  151  LYS GLU GLY HIS VAL ARG ALA GLU ALA VAL ARG ILE HIS          
SEQRES  10 A  151  ALA GLY SER THR THR TRP PHE TRP ASP VAL SER LEU ARG          
SEQRES  11 A  151  ASP ASP ALA GLY ARG LEU CYS ALA VAL SER SER MET SER          
SEQRES  12 A  151  ILE ALA VAL ARG PRO ARG ARG ASP                              
SEQRES   1 B  151  MET HIS ARG THR SER ASN GLY SER HIS ALA THR GLY GLY          
SEQRES   2 B  151  ASN LEU PRO ASP VAL ALA SER HIS TYR PRO VAL ALA TYR          
SEQRES   3 B  151  GLU GLN THR LEU ASP GLY THR VAL GLY PHE VAL ILE ASP          
SEQRES   4 B  151  GLU MET THR PRO GLU ARG ALA THR ALA SER VAL GLU VAL          
SEQRES   5 B  151  THR ASP THR LEU ARG GLN ARG TRP GLY LEU VAL HIS GLY          
SEQRES   6 B  151  GLY ALA TYR CYS ALA LEU ALA GLU MET LEU ALA THR GLU          
SEQRES   7 B  151  ALA THR VAL ALA VAL VAL HIS GLU LYS GLY MET MET ALA          
SEQRES   8 B  151  VAL GLY GLN SER ASN HIS THR SER PHE PHE ARG PRO VAL          
SEQRES   9 B  151  LYS GLU GLY HIS VAL ARG ALA GLU ALA VAL ARG ILE HIS          
SEQRES  10 B  151  ALA GLY SER THR THR TRP PHE TRP ASP VAL SER LEU ARG          
SEQRES  11 B  151  ASP ASP ALA GLY ARG LEU CYS ALA VAL SER SER MET SER          
SEQRES  12 B  151  ILE ALA VAL ARG PRO ARG ARG ASP                              
HET    COA    270      48                                                       
HET    COA    271      48                                                       
HET    PHB    272      10                                                       
HET    PHB    273      10                                                       
HETNAM     COA COENZYME A                                                       
HETNAM     PHB P-HYDROXYBENZOIC ACID                                            
FORMUL   3  COA    2(C21 H36 N7 O16 P3 S)                                       
FORMUL   5  PHB    2(C7 H6 O3)                                                  
FORMUL   7  HOH   *241(H2 O)                                                    
CRYST1  113.100  113.100   60.100  90.00  90.00 120.00 P 32 2 1     12          
ATOM      1  N   ALA A  10      28.854  56.112  34.334  1.00 88.88           N  
ATOM      2  CA  ALA A  10      29.980  56.120  35.253  1.00 87.31           C  
ATOM      3  C   ALA A  10      31.186  55.398  34.646  1.00 98.79           C  
ATOM      4  O   ALA A  10      31.034  54.569  33.743  1.00 98.90           O  
ATOM      5  CB  ALA A  10      29.564  55.555  36.582  1.00 85.05           C  
ATOM      6  N   THR A  11      32.380  55.731  35.140  1.00 92.50           N  
ATOM      7  CA  THR A  11      33.621  55.143  34.641  1.00 93.25           C  
ATOM      8  C   THR A  11      34.756  55.410  35.631  1.00100.00           C  
ATOM      9  O   THR A  11      35.934  55.077  35.369  1.00100.00           O  
ATOM     10  CB  THR A  11      33.925  55.595  33.172  1.00100.00           C  
ATOM     11  OG1 THR A  11      34.128  54.498  32.276  1.00100.00           O  
ATOM     12  CG2 THR A  11      35.013  56.678  33.063  1.00100.00           C  
ATOM     13  N   GLY A  12      34.345  56.029  36.767  1.00 93.24           N  
ATOM     14  CA  GLY A  12      35.210  56.391  37.908  1.00 87.26           C  
ATOM     15  C   GLY A  12      35.484  55.149  38.779  1.00 71.32           C  
ATOM     16  O   GLY A  12      36.611  54.897  39.277  1.00 68.53           O  
ATOM     17  N   GLY A  13      34.419  54.344  38.918  1.00 47.81           N  
ATOM     18  CA  GLY A  13      34.489  53.098  39.647  1.00 43.20           C  
ATOM     19  C   GLY A  13      34.390  51.995  38.605  1.00 44.44           C  
ATOM     20  O   GLY A  13      34.494  50.794  38.858  1.00 39.04           O  
ATOM     21  N   ASN A  14      34.190  52.491  37.391  1.00 41.02           N  
ATOM     22  CA  ASN A  14      34.074  51.700  36.209  1.00 38.36           C  
ATOM     23  C   ASN A  14      32.717  51.018  36.072  1.00 40.82           C  
ATOM     24  O   ASN A  14      32.522  49.997  35.412  1.00 39.08           O  
ATOM     25  CB  ASN A  14      35.317  50.857  35.875  1.00 41.08           C  
ATOM     26  CG  ASN A  14      35.195  50.345  34.455  1.00 77.10           C  
ATOM     27  OD1 ASN A  14      34.807  51.098  33.540  1.00 84.68           O  
ATOM     28  ND2 ASN A  14      35.457  49.051  34.278  1.00 81.13           N  
ATOM     29  N   LEU A  15      31.752  51.626  36.726  1.00 37.02           N  
ATOM     30  CA  LEU A  15      30.415  51.115  36.661  1.00 34.31           C  
ATOM     31  C   LEU A  15      29.921  51.212  35.222  1.00 45.14           C  
ATOM     32  O   LEU A  15      30.377  52.063  34.460  1.00 41.71           O  
ATOM     33  CB  LEU A  15      29.489  51.852  37.663  1.00 32.30           C  
ATOM     34  CG  LEU A  15      29.515  51.162  39.038  1.00 32.59           C  
ATOM     35  CD1 LEU A  15      30.905  51.180  39.696  1.00 26.20           C  
ATOM     36  CD2 LEU A  15      28.460  51.770  39.959  1.00 31.66           C  
ATOM     37  N   PRO A  16      28.976  50.335  34.842  1.00 45.28           N  
ATOM     38  CA  PRO A  16      28.451  50.316  33.480  1.00 40.30           C  
ATOM     39  C   PRO A  16      27.870  51.633  33.016  1.00 42.74           C  
ATOM     40  O   PRO A  16      26.974  52.190  33.681  1.00 43.45           O  
ATOM     41  CB  PRO A  16      27.342  49.245  33.464  1.00 39.87           C  
ATOM     42  CG  PRO A  16      27.184  48.704  34.873  1.00 41.71           C  
ATOM     43  CD  PRO A  16      28.326  49.281  35.687  1.00 39.16           C  
ATOM     44  N   ASP A  17      28.323  52.125  31.850  1.00 44.10           N  
ATOM     45  CA  ASP A  17      27.717  53.374  31.435  1.00 47.15           C  
ATOM     46  C   ASP A  17      26.521  53.150  30.584  1.00 40.92           C  
ATOM     47  O   ASP A  17      26.563  52.934  29.403  1.00 43.79           O  
ATOM     48  CB  ASP A  17      28.684  54.486  30.996  0.50 53.82           C  
ATOM     50  CG  ASP A  17      28.993  54.506  29.532  0.50 78.05           C  
ATOM     52  OD1 ASP A  17      28.665  53.623  28.762  0.50 77.21           O  
ATOM     54  OD2 ASP A  17      29.666  55.575  29.187  0.50 97.05           O  
ATOM     56  N   VAL A  18      25.425  53.137  31.250  1.00 34.71           N  
ATOM     57  CA  VAL A  18      24.204  52.832  30.608  1.00 31.44           C  
ATOM     58  C   VAL A  18      23.372  54.059  30.482  1.00 34.54           C  
ATOM     59  O   VAL A  18      22.332  54.045  29.840  1.00 39.07           O  
ATOM     60  CB  VAL A  18      23.483  51.747  31.448  1.00 34.06           C  
ATOM     61  CG1 VAL A  18      24.381  50.538  31.623  1.00 27.53           C  
ATOM     62  CG2 VAL A  18      23.161  52.266  32.850  1.00 36.38           C  
ATOM     63  N   ALA A  19      23.814  55.118  31.126  1.00 38.21           N  
ATOM     64  CA  ALA A  19      23.042  56.340  31.052  1.00 38.80           C  
ATOM     65  C   ALA A  19      23.953  57.533  30.815  1.00 52.35           C  
ATOM     66  O   ALA A  19      25.174  57.449  30.995  1.00 48.66           O  
ATOM     67  CB  ALA A  19      22.208  56.534  32.305  1.00 38.20           C  
ATOM     68  N   SER A  20      23.334  58.642  30.406  1.00 59.42           N  
ATOM     69  CA  SER A  20      24.033  59.908  30.143  1.00 63.59           C  
ATOM     70  C   SER A  20      24.463  60.577  31.451  1.00 66.86           C  
ATOM     71  O   SER A  20      25.596  61.049  31.583  1.00 68.81           O  
ATOM     72  CB  SER A  20      23.168  60.870  29.326  1.00 70.98           C  
ATOM     73  OG  SER A  20      21.796  60.636  29.592  1.00100.00           O  
ATOM     74  N   HIS A  21      23.526  60.580  32.414  1.00 60.62           N  
ATOM     75  CA  HIS A  21      23.706  61.152  33.735  1.00 62.89           C  
ATOM     76  C   HIS A  21      23.217  60.201  34.829  1.00 47.48           C  
ATOM     77  O   HIS A  21      22.442  59.287  34.559  1.00 49.44           O  
ATOM     78  CB  HIS A  21      22.988  62.516  33.816  1.00 73.21           C  
ATOM     79  CG  HIS A  21      21.500  62.330  33.720  1.00 87.47           C  
ATOM     80  ND1 HIS A  21      20.705  62.253  34.868  1.00 96.54           N  
ATOM     81  CD2 HIS A  21      20.688  62.168  32.623  1.00 97.36           C  
ATOM     82  CE1 HIS A  21      19.444  62.059  34.442  1.00 99.70           C  
ATOM     83  NE2 HIS A  21      19.395  62.002  33.098  1.00 99.71           N  
ATOM     84  N   TYR A  22      23.694  60.424  36.057  1.00 38.90           N  
ATOM     85  CA  TYR A  22      23.366  59.675  37.271  1.00 39.11           C  
ATOM     86  C   TYR A  22      23.126  60.637  38.414  1.00 46.85           C  
ATOM     87  O   TYR A  22      23.831  61.644  38.588  1.00 47.17           O  
ATOM     88  CB  TYR A  22      24.454  58.683  37.707  1.00 40.14           C  
ATOM     89  CG  TYR A  22      24.870  57.846  36.549  1.00 41.91           C  
ATOM     90  CD1 TYR A  22      25.940  58.212  35.738  1.00 48.32           C  
ATOM     91  CD2 TYR A  22      24.126  56.719  36.206  1.00 38.97           C  
ATOM     92  CE1 TYR A  22      26.281  57.436  34.622  1.00 49.42           C  
ATOM     93  CE2 TYR A  22      24.442  55.941  35.096  1.00 40.65           C  
ATOM     94  CZ  TYR A  22      25.544  56.291  34.320  1.00 49.28           C  
ATOM     95  OH  TYR A  22      25.860  55.479  33.262  1.00 39.31           O  
ATOM     96  N   PRO A  23      22.125  60.294  39.209  1.00 38.32           N  
ATOM     97  CA  PRO A  23      21.758  61.119  40.344  1.00 33.56           C  
ATOM     98  C   PRO A  23      22.891  61.499  41.291  1.00 41.64           C  
ATOM     99  O   PRO A  23      22.915  62.608  41.857  1.00 43.69           O  
ATOM    100  CB  PRO A  23      20.655  60.330  41.027  1.00 32.92           C  
ATOM    101  CG  PRO A  23      20.034  59.482  39.910  1.00 36.64           C  
ATOM    102  CD  PRO A  23      21.129  59.222  38.907  1.00 31.43           C  
ATOM    103  N   VAL A  24      23.816  60.552  41.469  1.00 34.33           N  
ATOM    104  CA  VAL A  24      24.931  60.725  42.354  1.00 30.73           C  
ATOM    105  C   VAL A  24      26.212  60.291  41.694  1.00 34.47           C  
ATOM    106  O   VAL A  24      26.349  59.236  41.085  1.00 32.62           O  
ATOM    107  CB  VAL A  24      24.723  59.989  43.685  1.00 29.79           C  
ATOM    108  CG1 VAL A  24      25.884  60.255  44.650  1.00 26.20           C  
ATOM    109  CG2 VAL A  24      23.370  60.335  44.302  1.00 26.44           C  
ATOM    110  N   ALA A  25      27.180  61.150  41.835  1.00 33.59           N  
ATOM    111  CA  ALA A  25      28.473  60.886  41.286  1.00 34.28           C  
ATOM    112  C   ALA A  25      29.231  59.889  42.132  1.00 34.29           C  
ATOM    113  O   ALA A  25      29.159  59.853  43.357  1.00 35.54           O  
ATOM    114  CB  ALA A  25      29.278  62.171  41.189  1.00 35.61           C  
ATOM    115  N   TYR A  26      30.005  59.108  41.419  1.00 35.46           N  
ATOM    116  CA  TYR A  26      30.835  58.051  41.959  1.00 35.94           C  
ATOM    117  C   TYR A  26      31.636  58.378  43.207  1.00 35.47           C  
ATOM    118  O   TYR A  26      31.623  57.670  44.223  1.00 33.49           O  
ATOM    119  CB  TYR A  26      31.798  57.524  40.874  1.00 33.77           C  
ATOM    120  CG  TYR A  26      32.779  56.535  41.465  1.00 33.25           C  
ATOM    121  CD1 TYR A  26      32.359  55.242  41.787  1.00 30.77           C  
ATOM    122  CD2 TYR A  26      34.103  56.889  41.728  1.00 33.04           C  
ATOM    123  CE1 TYR A  26      33.252  54.331  42.352  1.00 28.40           C  
ATOM    124  CE2 TYR A  26      35.016  55.994  42.289  1.00 30.90           C  
ATOM    125  CZ  TYR A  26      34.567  54.711  42.610  1.00 33.57           C  
ATOM    126  OH  TYR A  26      35.429  53.813  43.181  1.00 29.92           O  
ATOM    127  N   GLU A  27      32.429  59.422  43.099  1.00 35.08           N  
ATOM    128  CA  GLU A  27      33.274  59.730  44.217  1.00 34.63           C  
ATOM    129  C   GLU A  27      32.445  60.046  45.446  1.00 30.78           C  
ATOM    130  O   GLU A  27      32.904  59.942  46.575  1.00 30.53           O  
ATOM    131  CB  GLU A  27      34.398  60.744  43.840  1.00 38.31           C  
ATOM    132  CG  GLU A  27      35.839  60.255  44.194  1.00 77.00           C  
ATOM    133  CD  GLU A  27      36.612  59.499  43.100  1.00100.00           C  
ATOM    134  OE1 GLU A  27      36.388  59.640  41.896  1.00100.00           O  
ATOM    135  OE2 GLU A  27      37.585  58.741  43.568  1.00 87.18           O  
ATOM    136  N   GLN A  28      31.186  60.406  45.210  1.00 30.51           N  
ATOM    137  CA  GLN A  28      30.307  60.760  46.326  1.00 32.41           C  
ATOM    138  C   GLN A  28      29.452  59.612  46.855  1.00 41.36           C  
ATOM    139  O   GLN A  28      28.857  59.670  47.937  1.00 39.14           O  
ATOM    140  CB  GLN A  28      29.440  61.996  45.994  1.00 33.31           C  
ATOM    141  CG  GLN A  28      30.210  63.350  46.154  1.00 44.55           C  
ATOM    142  CD  GLN A  28      31.371  63.577  45.177  1.00 87.97           C  
ATOM    143  OE1 GLN A  28      32.566  63.498  45.550  1.00 87.74           O  
ATOM    144  NE2 GLN A  28      31.031  63.884  43.923  1.00 76.23           N  
ATOM    145  N   THR A  29      29.366  58.546  46.095  1.00 35.47           N  
ATOM    146  CA  THR A  29      28.556  57.458  46.577  1.00 30.79           C  
ATOM    147  C   THR A  29      29.333  56.660  47.606  1.00 27.07           C  
ATOM    148  O   THR A  29      30.543  56.796  47.814  1.00 27.38           O  
ATOM    149  CB  THR A  29      28.223  56.511  45.397  1.00 28.98           C  
ATOM    150  OG1 THR A  29      29.446  56.012  44.873  1.00 32.62           O  
ATOM    151  CG2 THR A  29      27.377  57.174  44.296  1.00 25.08           C  
ATOM    152  N   LEU A  30      28.612  55.747  48.217  1.00 27.73           N  
ATOM    153  CA  LEU A  30      29.240  54.846  49.161  1.00 25.82           C  
ATOM    154  C   LEU A  30      30.341  54.080  48.418  1.00 24.83           C  
ATOM    155  O   LEU A  30      31.464  53.868  48.886  1.00 24.29           O  
ATOM    156  CB  LEU A  30      28.185  53.828  49.633  1.00 27.74           C  
ATOM    157  CG  LEU A  30      28.886  52.649  50.298  1.00 35.78           C  
ATOM    158  CD1 LEU A  30      29.822  53.236  51.333  1.00 43.57           C  
ATOM    159  CD2 LEU A  30      27.901  51.727  50.986  1.00 32.18           C  
ATOM    160  N   ASP A  31      30.021  53.615  47.215  1.00 21.51           N  
ATOM    161  CA  ASP A  31      31.017  52.873  46.474  1.00 21.02           C  
ATOM    162  C   ASP A  31      32.309  53.637  46.238  1.00 28.01           C  
ATOM    163  O   ASP A  31      33.401  53.073  46.447  1.00 27.13           O  
ATOM    164  CB  ASP A  31      30.438  52.365  45.159  1.00 24.02           C  
ATOM    165  CG  ASP A  31      29.134  51.613  45.324  1.00 28.14           C  
ATOM    166  OD1 ASP A  31      29.043  50.418  45.515  1.00 29.04           O  
ATOM    167  OD2 ASP A  31      28.097  52.395  45.261  1.00 27.78           O  
ATOM    168  N   GLY A  32      32.150  54.900  45.783  1.00 24.35           N  
ATOM    169  CA  GLY A  32      33.288  55.769  45.506  1.00 23.42           C  
ATOM    170  C   GLY A  32      34.005  56.073  46.796  1.00 26.78           C  
ATOM    171  O   GLY A  32      35.194  56.100  46.924  1.00 26.74           O  
ATOM    172  N   THR A  33      33.228  56.308  47.807  1.00 25.27           N  
ATOM    173  CA  THR A  33      33.770  56.600  49.101  1.00 22.16           C  
ATOM    174  C   THR A  33      34.681  55.506  49.596  1.00 29.54           C  
ATOM    175  O   THR A  33      35.770  55.788  50.093  1.00 28.61           O  
ATOM    176  CB  THR A  33      32.638  56.794  50.115  1.00 26.16           C  
ATOM    177  OG1 THR A  33      31.853  57.863  49.732  1.00 29.63           O  
ATOM    178  CG2 THR A  33      33.193  57.048  51.500  1.00 30.33           C  
ATOM    179  N   VAL A  34      34.240  54.248  49.511  1.00 24.68           N  
ATOM    180  CA  VAL A  34      35.078  53.162  49.995  1.00 23.83           C  
ATOM    181  C   VAL A  34      36.058  52.682  48.948  1.00 30.05           C  
ATOM    182  O   VAL A  34      36.976  51.956  49.284  1.00 27.82           O  
ATOM    183  CB  VAL A  34      34.360  52.001  50.648  1.00 27.26           C  
ATOM    184  CG1 VAL A  34      33.542  52.532  51.835  1.00 27.07           C  
ATOM    185  CG2 VAL A  34      33.453  51.388  49.563  1.00 28.40           C  
ATOM    186  N   GLY A  35      35.863  53.092  47.694  1.00 29.30           N  
ATOM    187  CA  GLY A  35      36.802  52.744  46.653  1.00 29.23           C  
ATOM    188  C   GLY A  35      36.564  51.470  45.895  1.00 35.71           C  
ATOM    189  O   GLY A  35      37.529  50.821  45.488  1.00 29.97           O  
ATOM    190  N   PHE A  36      35.302  51.115  45.665  1.00 33.16           N  
ATOM    191  CA  PHE A  36      35.071  49.895  44.914  1.00 27.36           C  
ATOM    192  C   PHE A  36      35.342  50.141  43.424  1.00 29.81           C  
ATOM    193  O   PHE A  36      34.918  51.145  42.886  1.00 32.49           O  
ATOM    194  CB  PHE A  36      33.599  49.463  44.989  1.00 24.86           C  
ATOM    195  CG  PHE A  36      33.061  49.008  46.325  1.00 25.99           C  
ATOM    196  CD1 PHE A  36      33.879  48.441  47.301  1.00 26.79           C  
ATOM    197  CD2 PHE A  36      31.685  49.096  46.575  1.00 31.17           C  
ATOM    198  CE1 PHE A  36      33.335  47.998  48.511  1.00 26.41           C  
ATOM    199  CE2 PHE A  36      31.114  48.676  47.770  1.00 25.53           C  
ATOM    200  CZ  PHE A  36      31.966  48.153  48.742  1.00 22.93           C  
ATOM    201  N   VAL A  37      35.981  49.198  42.736  1.00 30.61           N  
ATOM    202  CA  VAL A  37      36.228  49.342  41.313  1.00 32.71           C  
ATOM    203  C   VAL A  37      35.882  48.088  40.524  1.00 32.31           C  
ATOM    204  O   VAL A  37      36.375  46.982  40.786  1.00 32.64           O  
ATOM    205  CB  VAL A  37      37.690  49.652  41.083  1.00 40.67           C  
ATOM    206  CG1 VAL A  37      37.916  49.819  39.582  1.00 40.30           C  
ATOM    207  CG2 VAL A  37      37.957  50.975  41.792  1.00 41.51           C  
ATOM    208  N   ILE A  38      35.045  48.259  39.524  1.00 25.53           N  
ATOM    209  CA  ILE A  38      34.699  47.095  38.722  1.00 27.68           C  
ATOM    210  C   ILE A  38      35.809  46.768  37.763  1.00 36.35           C  
ATOM    211  O   ILE A  38      36.347  47.670  37.141  1.00 37.16           O  
ATOM    212  CB  ILE A  38      33.388  47.246  37.977  1.00 29.04           C  
ATOM    213  CG1 ILE A  38      32.319  46.911  39.007  1.00 29.75           C  
ATOM    214  CG2 ILE A  38      33.305  46.238  36.830  1.00 27.54           C  
ATOM    215  CD1 ILE A  38      31.029  47.569  38.648  1.00 31.17           C  
ATOM    216  N   ASP A  39      36.187  45.500  37.672  1.00 34.40           N  
ATOM    217  CA  ASP A  39      37.230  45.137  36.722  1.00 31.22           C  
ATOM    218  C   ASP A  39      36.581  44.602  35.450  1.00 42.13           C  
ATOM    219  O   ASP A  39      36.392  45.333  34.487  1.00 46.96           O  
ATOM    220  CB  ASP A  39      38.352  44.210  37.203  1.00 33.19           C  
ATOM    221  CG  ASP A  39      39.375  43.918  36.106  1.00 58.59           C  
ATOM    222  OD1 ASP A  39      39.315  44.351  34.955  1.00 63.27           O  
ATOM    223  OD2 ASP A  39      40.363  43.168  36.531  1.00 75.22           O  
ATOM    224  N   GLU A  40      36.239  43.312  35.443  1.00 33.84           N  
ATOM    225  CA  GLU A  40      35.604  42.723  34.283  1.00 26.47           C  
ATOM    226  C   GLU A  40      34.115  42.751  34.417  1.00 29.07           C  
ATOM    227  O   GLU A  40      33.538  42.685  35.497  1.00 27.83           O  
ATOM    228  CB  GLU A  40      36.024  41.279  34.094  1.00 29.16           C  
ATOM    229  CG  GLU A  40      37.535  41.065  33.931  1.00 43.01           C  
ATOM    230  CD  GLU A  40      37.858  39.611  33.673  1.00 78.68           C  
ATOM    231  OE1 GLU A  40      38.635  38.948  34.348  1.00 73.43           O  
ATOM    232  OE2 GLU A  40      37.204  39.118  32.641  1.00 97.09           O  
ATOM    233  N   MET A  41      33.466  42.811  33.290  1.00 32.48           N  
ATOM    234  CA  MET A  41      32.045  42.835  33.362  1.00 29.86           C  
ATOM    235  C   MET A  41      31.401  42.274  32.130  1.00 39.37           C  
ATOM    236  O   MET A  41      31.505  42.899  31.083  1.00 41.81           O  
ATOM    237  CB  MET A  41      31.662  44.274  33.556  1.00 33.59           C  
ATOM    238  CG  MET A  41      30.251  44.553  33.147  1.00 40.66           C  
ATOM    239  SD  MET A  41      29.142  44.235  34.511  1.00 45.25           S  
ATOM    240  CE  MET A  41      29.683  45.318  35.854  1.00 35.65           C  
ATOM    241  N   THR A  42      30.757  41.096  32.279  1.00 38.36           N  
ATOM    242  CA  THR A  42      30.038  40.396  31.208  1.00 38.00           C  
ATOM    243  C   THR A  42      28.655  40.028  31.716  1.00 39.51           C  
ATOM    244  O   THR A  42      28.380  40.170  32.904  1.00 39.29           O  
ATOM    245  CB  THR A  42      30.771  39.167  30.655  1.00 37.11           C  
ATOM    246  OG1 THR A  42      30.741  38.128  31.614  1.00 41.11           O  
ATOM    247  CG2 THR A  42      32.224  39.539  30.408  1.00 33.23           C  
ATOM    248  N   PRO A  43      27.808  39.570  30.814  1.00 36.48           N  
ATOM    249  CA  PRO A  43      26.443  39.210  31.123  1.00 34.89           C  
ATOM    250  C   PRO A  43      26.340  38.057  32.074  1.00 33.38           C  
ATOM    251  O   PRO A  43      25.371  37.945  32.805  1.00 32.34           O  
ATOM    252  CB  PRO A  43      25.768  38.871  29.801  1.00 36.69           C  
ATOM    253  CG  PRO A  43      26.645  39.511  28.737  1.00 37.96           C  
ATOM    254  CD  PRO A  43      28.039  39.582  29.350  1.00 36.92           C  
ATOM    255  N   GLU A  44      27.346  37.217  32.075  1.00 25.25           N  
ATOM    256  CA  GLU A  44      27.310  36.129  32.993  1.00 28.69           C  
ATOM    257  C   GLU A  44      28.377  36.223  34.036  1.00 30.11           C  
ATOM    258  O   GLU A  44      28.433  35.378  34.920  1.00 31.76           O  
ATOM    259  CB  GLU A  44      27.524  34.792  32.312  1.00 35.24           C  
ATOM    260  CG  GLU A  44      26.197  34.121  31.970  1.00 61.73           C  
ATOM    261  CD  GLU A  44      26.200  33.765  30.519  1.00100.00           C  
ATOM    262  OE1 GLU A  44      26.481  34.589  29.657  1.00100.00           O  
ATOM    263  OE2 GLU A  44      25.947  32.490  30.318  1.00100.00           O  
ATOM    264  N   ARG A  45      29.242  37.213  33.957  1.00 25.40           N  
ATOM    265  CA  ARG A  45      30.253  37.229  34.984  1.00 24.74           C  
ATOM    266  C   ARG A  45      30.898  38.568  35.132  1.00 30.76           C  
ATOM    267  O   ARG A  45      31.074  39.260  34.150  1.00 31.82           O  
ATOM    268  CB  ARG A  45      31.273  36.198  34.649  1.00 28.41           C  
ATOM    269  CG  ARG A  45      32.403  36.158  35.633  1.00 32.37           C  
ATOM    270  CD  ARG A  45      33.543  35.296  35.086  1.00 38.57           C  
ATOM    271  NE  ARG A  45      34.878  35.770  35.486  1.00 75.91           N  
ATOM    272  CZ  ARG A  45      35.618  36.679  34.851  1.00 87.18           C  
ATOM    273  NH1 ARG A  45      35.203  37.291  33.722  1.00 68.64           N  
ATOM    274  NH2 ARG A  45      36.815  36.961  35.376  1.00 86.25           N  
ATOM    275  N   ALA A  46      31.204  38.917  36.371  1.00 29.98           N  
ATOM    276  CA  ALA A  46      31.802  40.221  36.632  1.00 26.28           C  
ATOM    277  C   ALA A  46      32.707  40.179  37.833  1.00 31.52           C  
ATOM    278  O   ALA A  46      32.566  39.352  38.743  1.00 27.37           O  
ATOM    279  CB  ALA A  46      30.747  41.303  36.793  1.00 22.60           C  
ATOM    280  N   THR A  47      33.665  41.090  37.801  1.00 30.89           N  
ATOM    281  CA  THR A  47      34.635  41.199  38.873  1.00 29.90           C  
ATOM    282  C   THR A  47      34.832  42.649  39.335  1.00 30.30           C  
ATOM    283  O   THR A  47      34.572  43.626  38.623  1.00 28.77           O  
ATOM    284  CB  THR A  47      35.979  40.518  38.526  1.00 38.71           C  
ATOM    285  OG1 THR A  47      36.673  41.260  37.521  1.00 35.02           O  
ATOM    286  CG2 THR A  47      35.760  39.069  38.085  1.00 28.22           C  
ATOM    287  N   ALA A  48      35.282  42.748  40.577  1.00 28.59           N  
ATOM    288  CA  ALA A  48      35.547  44.006  41.227  1.00 27.54           C  
ATOM    289  C   ALA A  48      36.460  43.779  42.433  1.00 30.50           C  
ATOM    290  O   ALA A  48      36.650  42.653  42.926  1.00 28.20           O  
ATOM    291  CB  ALA A  48      34.265  44.742  41.578  1.00 26.60           C  
ATOM    292  N   SER A  49      37.108  44.869  42.870  1.00 33.64           N  
ATOM    293  CA  SER A  49      38.029  44.797  43.999  1.00 33.75           C  
ATOM    294  C   SER A  49      38.092  46.136  44.705  1.00 34.38           C  
ATOM    295  O   SER A  49      37.546  47.136  44.207  1.00 29.84           O  
ATOM    296  CB  SER A  49      39.446  44.382  43.627  1.00 40.40           C  
ATOM    297  OG  SER A  49      39.894  45.326  42.655  1.00 42.40           O  
ATOM    298  N   VAL A  50      38.779  46.093  45.856  1.00 26.98           N  
ATOM    299  CA  VAL A  50      38.928  47.260  46.683  1.00 24.73           C  
ATOM    300  C   VAL A  50      40.149  47.067  47.539  1.00 29.57           C  
ATOM    301  O   VAL A  50      40.504  45.984  47.995  1.00 28.27           O  
ATOM    302  CB  VAL A  50      37.675  47.492  47.554  1.00 25.01           C  
ATOM    303  CG1 VAL A  50      37.388  46.258  48.427  1.00 24.71           C  
ATOM    304  CG2 VAL A  50      37.756  48.755  48.399  1.00 21.01           C  
ATOM    305  N   GLU A  51      40.815  48.167  47.735  1.00 31.76           N  
ATOM    306  CA  GLU A  51      41.967  48.146  48.569  1.00 30.31           C  
ATOM    307  C   GLU A  51      41.507  48.417  49.988  1.00 28.12           C  
ATOM    308  O   GLU A  51      40.772  49.375  50.232  1.00 30.13           O  
ATOM    309  CB  GLU A  51      42.895  49.278  48.115  1.00 33.33           C  
ATOM    310  CG  GLU A  51      44.173  49.361  48.976  1.00 48.16           C  
ATOM    311  CD  GLU A  51      45.104  50.438  48.489  1.00 69.72           C  
ATOM    312  OE1 GLU A  51      46.304  50.441  48.707  1.00100.00           O  
ATOM    313  OE2 GLU A  51      44.485  51.367  47.791  1.00 94.88           O  
ATOM    314  N   VAL A  52      41.912  47.586  50.934  1.00 26.18           N  
ATOM    315  CA  VAL A  52      41.511  47.788  52.324  1.00 26.99           C  
ATOM    316  C   VAL A  52      42.188  49.001  52.944  1.00 34.70           C  
ATOM    317  O   VAL A  52      43.411  49.118  52.859  1.00 30.62           O  
ATOM    318  CB  VAL A  52      41.880  46.591  53.182  1.00 23.23           C  
ATOM    319  CG1 VAL A  52      41.467  46.846  54.642  1.00 22.92           C  
ATOM    320  CG2 VAL A  52      41.180  45.379  52.565  1.00 24.50           C  
ATOM    321  N   THR A  53      41.387  49.860  53.568  1.00 27.78           N  
ATOM    322  CA  THR A  53      41.876  51.021  54.271  1.00 27.15           C  
ATOM    323  C   THR A  53      40.988  51.077  55.478  1.00 27.73           C  
ATOM    324  O   THR A  53      40.088  50.270  55.587  1.00 27.90           O  
ATOM    325  CB  THR A  53      41.792  52.363  53.502  1.00 27.90           C  
ATOM    326  OG1 THR A  53      40.434  52.709  53.437  1.00 30.23           O  
ATOM    327  CG2 THR A  53      42.379  52.327  52.074  1.00 17.34           C  
ATOM    328  N   ASP A  54      41.208  52.028  56.355  1.00 22.78           N  
ATOM    329  CA  ASP A  54      40.389  52.116  57.546  1.00 21.19           C  
ATOM    330  C   ASP A  54      38.921  52.269  57.266  1.00 23.74           C  
ATOM    331  O   ASP A  54      38.081  51.784  58.036  1.00 24.08           O  
ATOM    332  CB  ASP A  54      40.878  53.203  58.510  1.00 23.49           C  
ATOM    333  CG  ASP A  54      42.089  52.764  59.340  1.00 37.57           C  
ATOM    334  OD1 ASP A  54      42.440  51.595  59.428  1.00 30.99           O  
ATOM    335  OD2 ASP A  54      42.730  53.749  59.962  1.00 33.94           O  
ATOM    336  N   THR A  55      38.653  52.995  56.181  1.00 22.96           N  
ATOM    337  CA  THR A  55      37.298  53.277  55.704  1.00 22.71           C  
ATOM    338  C   THR A  55      36.445  52.000  55.470  1.00 24.33           C  
ATOM    339  O   THR A  55      35.209  51.994  55.517  1.00 19.59           O  
ATOM    340  CB  THR A  55      37.372  54.068  54.376  1.00 30.00           C  
ATOM    341  OG1 THR A  55      38.289  55.126  54.475  1.00 34.76           O  
ATOM    342  CG2 THR A  55      35.995  54.629  54.019  1.00 37.26           C  
ATOM    343  N   LEU A  56      37.142  50.921  55.170  1.00 23.96           N  
ATOM    344  CA  LEU A  56      36.550  49.615  54.919  1.00 25.07           C  
ATOM    345  C   LEU A  56      36.497  48.790  56.191  1.00 31.27           C  
ATOM    346  O   LEU A  56      35.879  47.727  56.220  1.00 26.78           O  
ATOM    347  CB  LEU A  56      37.427  48.837  53.902  1.00 23.44           C  
ATOM    348  CG  LEU A  56      36.636  47.871  52.996  1.00 31.42           C  
ATOM    349  CD1 LEU A  56      35.646  48.607  52.071  1.00 24.35           C  
ATOM    350  CD2 LEU A  56      37.548  46.961  52.160  1.00 26.52           C  
ATOM    351  N   ARG A  57      37.176  49.239  57.258  1.00 25.25           N  
ATOM    352  CA  ARG A  57      37.156  48.406  58.448  1.00 21.04           C  
ATOM    353  C   ARG A  57      36.195  48.861  59.521  1.00 22.40           C  
ATOM    354  O   ARG A  57      35.608  49.955  59.466  1.00 23.81           O  
ATOM    355  CB  ARG A  57      38.517  48.296  59.109  1.00 24.48           C  
ATOM    356  CG  ARG A  57      39.723  48.167  58.156  1.00 24.58           C  
ATOM    357  CD  ARG A  57      41.058  48.207  58.952  1.00 24.18           C  
ATOM    358  NE  ARG A  57      42.170  47.628  58.197  1.00 24.62           N  
ATOM    359  CZ  ARG A  57      43.074  48.309  57.483  1.00 31.04           C  
ATOM    360  NH1 ARG A  57      43.096  49.630  57.400  1.00 29.51           N  
ATOM    361  NH2 ARG A  57      44.017  47.648  56.815  1.00 27.39           N  
ATOM    362  N   GLN A  58      36.075  47.977  60.511  1.00 21.04           N  
ATOM    363  CA  GLN A  58      35.269  48.241  61.696  1.00 23.31           C  
ATOM    364  C   GLN A  58      36.280  48.630  62.781  1.00 28.18           C  
ATOM    365  O   GLN A  58      37.501  48.650  62.522  1.00 24.93           O  
ATOM    366  CB  GLN A  58      34.357  47.083  62.146  1.00 24.84           C  
ATOM    367  CG  GLN A  58      34.796  45.687  61.631  1.00 26.41           C  
ATOM    368  CD  GLN A  58      35.671  44.940  62.589  1.00 29.66           C  
ATOM    369  OE1 GLN A  58      36.674  45.460  63.052  1.00 23.38           O  
ATOM    370  NE2 GLN A  58      35.309  43.705  62.902  1.00 24.83           N  
ATOM    371  N   ARG A  59      35.828  48.958  63.983  1.00 25.74           N  
ATOM    372  CA  ARG A  59      36.746  49.415  65.047  1.00 26.92           C  
ATOM    373  C   ARG A  59      37.817  48.423  65.501  1.00 33.12           C  
ATOM    374  O   ARG A  59      38.874  48.810  66.045  1.00 30.30           O  
ATOM    375  CB  ARG A  59      36.001  50.017  66.254  1.00 24.33           C  
ATOM    376  CG  ARG A  59      35.171  48.991  67.045  1.00 22.71           C  
ATOM    377  CD  ARG A  59      34.654  49.678  68.281  1.00 23.66           C  
ATOM    378  NE  ARG A  59      33.771  48.852  69.071  1.00 26.37           N  
ATOM    379  CZ  ARG A  59      33.335  49.162  70.297  1.00 30.42           C  
ATOM    380  NH1 ARG A  59      33.703  50.281  70.935  1.00 27.46           N  
ATOM    381  NH2 ARG A  59      32.521  48.295  70.900  1.00 22.09           N  
ATOM    382  N   TRP A  60      37.529  47.142  65.278  1.00 29.26           N  
ATOM    383  CA  TRP A  60      38.434  46.088  65.675  1.00 24.30           C  
ATOM    384  C   TRP A  60      39.531  45.816  64.689  1.00 25.43           C  
ATOM    385  O   TRP A  60      40.281  44.896  64.913  1.00 27.97           O  
ATOM    386  CB  TRP A  60      37.695  44.812  66.017  1.00 22.37           C  
ATOM    387  CG  TRP A  60      36.563  45.127  66.946  1.00 25.09           C  
ATOM    388  CD1 TRP A  60      35.230  45.307  66.659  1.00 26.74           C  
ATOM    389  CD2 TRP A  60      36.706  45.282  68.352  1.00 27.14           C  
ATOM    390  NE1 TRP A  60      34.519  45.554  67.805  1.00 25.02           N  
ATOM    391  CE2 TRP A  60      35.410  45.547  68.865  1.00 29.27           C  
ATOM    392  CE3 TRP A  60      37.826  45.196  69.216  1.00 30.06           C  
ATOM    393  CZ2 TRP A  60      35.239  45.748  70.250  1.00 31.23           C  
ATOM    394  CZ3 TRP A  60      37.648  45.410  70.570  1.00 31.73           C  
ATOM    395  CH2 TRP A  60      36.360  45.675  71.083  1.00 32.66           C  
ATOM    396  N   GLY A  61      39.650  46.605  63.630  1.00 23.03           N  
ATOM    397  CA  GLY A  61      40.753  46.391  62.715  1.00 21.46           C  
ATOM    398  C   GLY A  61      40.481  45.459  61.548  1.00 26.64           C  
ATOM    399  O   GLY A  61      41.353  45.326  60.678  1.00 27.67           O  
ATOM    400  N   LEU A  62      39.301  44.826  61.496  1.00 24.99           N  
ATOM    401  CA  LEU A  62      39.000  43.927  60.374  1.00 22.94           C  
ATOM    402  C   LEU A  62      38.064  44.525  59.346  1.00 27.90           C  
ATOM    403  O   LEU A  62      37.300  45.452  59.654  1.00 29.03           O  
ATOM    404  CB  LEU A  62      38.402  42.579  60.811  1.00 23.73           C  
ATOM    405  CG  LEU A  62      39.207  41.889  61.934  1.00 36.33           C  
ATOM    406  CD1 LEU A  62      38.431  40.648  62.365  1.00 42.32           C  
ATOM    407  CD2 LEU A  62      40.599  41.483  61.449  1.00 37.20           C  
ATOM    408  N   VAL A  63      38.110  43.966  58.109  1.00 26.91           N  
ATOM    409  CA  VAL A  63      37.186  44.432  57.085  1.00 24.88           C  
ATOM    410  C   VAL A  63      35.774  44.205  57.612  1.00 24.88           C  
ATOM    411  O   VAL A  63      35.421  43.129  58.080  1.00 22.53           O  
ATOM    412  CB  VAL A  63      37.351  43.714  55.767  1.00 21.82           C  
ATOM    413  CG1 VAL A  63      36.182  44.048  54.842  1.00 18.40           C  
ATOM    414  CG2 VAL A  63      38.681  44.175  55.197  1.00 20.74           C  
ATOM    415  N   HIS A  64      35.017  45.267  57.585  1.00 21.84           N  
ATOM    416  CA  HIS A  64      33.661  45.265  58.071  1.00 23.64           C  
ATOM    417  C   HIS A  64      32.779  44.263  57.326  1.00 26.88           C  
ATOM    418  O   HIS A  64      32.794  44.123  56.109  1.00 25.79           O  
ATOM    419  CB  HIS A  64      33.144  46.696  57.848  1.00 22.23           C  
ATOM    420  CG  HIS A  64      31.908  47.046  58.598  1.00 24.15           C  
ATOM    421  ND1 HIS A  64      30.682  46.380  58.390  1.00 25.96           N  
ATOM    422  CD2 HIS A  64      31.733  48.010  59.546  1.00 21.60           C  
ATOM    423  CE1 HIS A  64      29.803  46.951  59.210  1.00 22.57           C  
ATOM    424  NE2 HIS A  64      30.404  47.948  59.904  1.00 22.02           N  
ATOM    425  N   GLY A  65      31.965  43.567  58.074  1.00 22.89           N  
ATOM    426  CA  GLY A  65      31.102  42.605  57.431  1.00 20.23           C  
ATOM    427  C   GLY A  65      30.325  43.302  56.345  1.00 26.90           C  
ATOM    428  O   GLY A  65      30.199  42.779  55.225  1.00 23.49           O  
ATOM    429  N   GLY A  66      29.814  44.498  56.662  1.00 21.49           N  
ATOM    430  CA  GLY A  66      29.026  45.199  55.682  1.00 16.47           C  
ATOM    431  C   GLY A  66      29.814  45.509  54.416  1.00 20.50           C  
ATOM    432  O   GLY A  66      29.210  45.734  53.366  1.00 19.71           O  
ATOM    433  N   ALA A  67      31.154  45.545  54.517  1.00 23.66           N  
ATOM    434  CA  ALA A  67      31.967  45.865  53.337  1.00 25.69           C  
ATOM    435  C   ALA A  67      31.810  44.797  52.262  1.00 25.97           C  
ATOM    436  O   ALA A  67      31.623  45.085  51.068  1.00 23.02           O  
ATOM    437  CB  ALA A  67      33.433  46.004  53.715  1.00 23.42           C  
ATOM    438  N   TYR A  68      31.894  43.561  52.712  1.00 21.36           N  
ATOM    439  CA  TYR A  68      31.719  42.473  51.773  1.00 21.76           C  
ATOM    440  C   TYR A  68      30.303  42.471  51.194  1.00 27.53           C  
ATOM    441  O   TYR A  68      30.111  42.301  49.981  1.00 26.76           O  
ATOM    442  CB  TYR A  68      31.945  41.124  52.446  1.00 20.34           C  
ATOM    443  CG  TYR A  68      33.266  40.945  53.197  1.00 23.27           C  
ATOM    444  CD1 TYR A  68      33.392  41.222  54.560  1.00 24.46           C  
ATOM    445  CD2 TYR A  68      34.374  40.381  52.554  1.00 22.81           C  
ATOM    446  CE1 TYR A  68      34.589  41.012  55.264  1.00 21.19           C  
ATOM    447  CE2 TYR A  68      35.569  40.139  53.237  1.00 23.38           C  
ATOM    448  CZ  TYR A  68      35.683  40.457  54.598  1.00 25.09           C  
ATOM    449  OH  TYR A  68      36.852  40.170  55.270  1.00 23.05           O  
ATOM    450  N   CYS A  69      29.289  42.650  52.062  1.00 21.96           N  
ATOM    451  CA  CYS A  69      27.922  42.668  51.573  1.00 20.21           C  
ATOM    452  C   CYS A  69      27.758  43.697  50.478  1.00 24.66           C  
ATOM    453  O   CYS A  69      27.116  43.423  49.476  1.00 19.65           O  
ATOM    454  CB  CYS A  69      26.885  43.049  52.671  1.00 21.44           C  
ATOM    455  SG  CYS A  69      26.896  41.926  54.091  1.00 25.72           S  
ATOM    456  N   ALA A  70      28.315  44.916  50.718  1.00 23.19           N  
ATOM    457  CA  ALA A  70      28.176  46.022  49.784  1.00 23.76           C  
ATOM    458  C   ALA A  70      28.852  45.822  48.435  1.00 22.21           C  
ATOM    459  O   ALA A  70      28.341  46.210  47.369  1.00 23.80           O  
ATOM    460  CB  ALA A  70      28.585  47.345  50.406  1.00 24.72           C  
ATOM    461  N   LEU A  71      30.019  45.221  48.486  1.00 18.17           N  
ATOM    462  CA  LEU A  71      30.761  44.972  47.257  1.00 17.72           C  
ATOM    463  C   LEU A  71      29.974  43.992  46.380  1.00 25.54           C  
ATOM    464  O   LEU A  71      29.747  44.197  45.188  1.00 27.07           O  
ATOM    465  CB  LEU A  71      32.164  44.425  47.631  1.00 20.01           C  
ATOM    466  CG  LEU A  71      33.063  44.110  46.425  1.00 25.53           C  
ATOM    467  CD1 LEU A  71      33.058  45.257  45.443  1.00 24.26           C  
ATOM    468  CD2 LEU A  71      34.500  43.855  46.833  1.00 22.37           C  
ATOM    469  N   ALA A  72      29.514  42.932  47.034  1.00 21.84           N  
ATOM    470  CA  ALA A  72      28.734  41.906  46.391  1.00 22.43           C  
ATOM    471  C   ALA A  72      27.480  42.529  45.872  1.00 30.00           C  
ATOM    472  O   ALA A  72      27.077  42.219  44.740  1.00 25.53           O  
ATOM    473  CB  ALA A  72      28.319  40.827  47.377  1.00 20.81           C  
ATOM    474  N   GLU A  73      26.873  43.388  46.707  1.00 19.93           N  
ATOM    475  CA  GLU A  73      25.632  44.034  46.304  1.00 19.93           C  
ATOM    476  C   GLU A  73      25.744  44.845  45.016  1.00 31.17           C  
ATOM    477  O   GLU A  73      24.978  44.680  44.041  1.00 27.01           O  
ATOM    478  CB  GLU A  73      25.109  44.950  47.409  1.00 21.47           C  
ATOM    479  CG  GLU A  73      23.813  45.669  46.970  1.00 25.78           C  
ATOM    480  CD  GLU A  73      22.516  45.018  47.439  1.00 27.42           C  
ATOM    481  OE1 GLU A  73      21.444  45.376  47.011  1.00 25.67           O  
ATOM    482  OE2 GLU A  73      22.635  44.058  48.343  1.00 23.23           O  
ATOM    483  N   MET A  74      26.687  45.784  45.046  1.00 29.17           N  
ATOM    484  CA  MET A  74      26.887  46.642  43.899  1.00 26.15           C  
ATOM    485  C   MET A  74      27.217  45.810  42.631  1.00 28.16           C  
ATOM    486  O   MET A  74      26.656  45.994  41.531  1.00 30.17           O  
ATOM    487  CB  MET A  74      27.980  47.713  44.239  1.00 24.42           C  
ATOM    488  CG  MET A  74      28.243  48.687  43.083  1.00 25.77           C  
ATOM    489  SD  MET A  74      29.420  48.023  41.839  1.00 27.82           S  
ATOM    490  CE  MET A  74      30.975  48.201  42.761  1.00 25.79           C  
ATOM    491  N   LEU A  75      28.169  44.881  42.793  1.00 23.29           N  
ATOM    492  CA  LEU A  75      28.606  44.065  41.671  1.00 24.47           C  
ATOM    493  C   LEU A  75      27.477  43.296  40.973  1.00 32.31           C  
ATOM    494  O   LEU A  75      27.288  43.390  39.764  1.00 28.99           O  
ATOM    495  CB  LEU A  75      29.864  43.204  42.008  1.00 19.98           C  
ATOM    496  CG  LEU A  75      30.485  42.410  40.849  1.00 24.49           C  
ATOM    497  CD1 LEU A  75      31.150  43.327  39.833  1.00 23.13           C  
ATOM    498  CD2 LEU A  75      31.512  41.404  41.393  1.00 28.59           C  
ATOM    499  N   ALA A  76      26.710  42.532  41.741  1.00 26.21           N  
ATOM    500  CA  ALA A  76      25.641  41.741  41.162  1.00 20.87           C  
ATOM    501  C   ALA A  76      24.599  42.613  40.534  1.00 22.43           C  
ATOM    502  O   ALA A  76      24.065  42.325  39.452  1.00 22.07           O  
ATOM    503  CB  ALA A  76      25.055  40.776  42.218  1.00 18.30           C  
ATOM    504  N   THR A  77      24.310  43.697  41.250  1.00 23.59           N  
ATOM    505  CA  THR A  77      23.298  44.611  40.766  1.00 23.21           C  
ATOM    506  C   THR A  77      23.714  45.350  39.519  1.00 29.55           C  
ATOM    507  O   THR A  77      22.971  45.407  38.532  1.00 26.74           O  
ATOM    508  CB  THR A  77      22.763  45.587  41.826  1.00 25.94           C  
ATOM    509  OG1 THR A  77      22.376  44.862  42.976  1.00 26.51           O  
ATOM    510  CG2 THR A  77      21.524  46.270  41.249  1.00 19.87           C  
ATOM    511  N   GLU A  78      24.904  45.919  39.559  1.00 27.83           N  
ATOM    512  CA  GLU A  78      25.361  46.623  38.378  1.00 26.07           C  
ATOM    513  C   GLU A  78      25.546  45.660  37.208  1.00 23.41           C  
ATOM    514  O   GLU A  78      25.279  45.989  36.067  1.00 26.69           O  
ATOM    515  CB  GLU A  78      26.605  47.460  38.698  1.00 26.73           C  
ATOM    516  CG  GLU A  78      26.192  48.704  39.499  1.00 23.03           C  
ATOM    517  CD  GLU A  78      25.352  49.652  38.681  1.00 36.89           C  
ATOM    518  OE1 GLU A  78      25.119  49.503  37.498  1.00 33.00           O  
ATOM    519  OE2 GLU A  78      24.878  50.680  39.355  1.00 30.00           O  
ATOM    520  N   ALA A  79      25.993  44.452  37.495  1.00 23.46           N  
ATOM    521  CA  ALA A  79      26.148  43.471  36.439  1.00 21.45           C  
ATOM    522  C   ALA A  79      24.833  43.177  35.703  1.00 32.49           C  
ATOM    523  O   ALA A  79      24.765  42.893  34.491  1.00 32.00           O  
ATOM    524  CB  ALA A  79      26.784  42.217  36.977  1.00 20.54           C  
ATOM    525  N   THR A  80      23.750  43.256  36.448  1.00 30.65           N  
ATOM    526  CA  THR A  80      22.419  43.018  35.892  1.00 32.01           C  
ATOM    527  C   THR A  80      21.996  44.252  35.107  1.00 35.95           C  
ATOM    528  O   THR A  80      21.501  44.184  33.977  1.00 32.55           O  
ATOM    529  CB  THR A  80      21.438  42.679  37.031  1.00 26.33           C  
ATOM    530  OG1 THR A  80      22.025  41.645  37.823  1.00 28.11           O  
ATOM    531  CG2 THR A  80      20.073  42.297  36.476  1.00 23.93           C  
ATOM    532  N   VAL A  81      22.234  45.401  35.731  1.00 27.59           N  
ATOM    533  CA  VAL A  81      21.935  46.690  35.107  1.00 27.80           C  
ATOM    534  C   VAL A  81      22.589  46.753  33.732  1.00 33.23           C  
ATOM    535  O   VAL A  81      21.993  47.145  32.746  1.00 32.37           O  
ATOM    536  CB  VAL A  81      22.514  47.857  35.919  1.00 31.48           C  
ATOM    537  CG1 VAL A  81      22.584  49.105  35.040  1.00 30.67           C  
ATOM    538  CG2 VAL A  81      21.699  48.129  37.190  1.00 29.78           C  
ATOM    539  N   ALA A  82      23.854  46.369  33.676  1.00 35.07           N  
ATOM    540  CA  ALA A  82      24.534  46.404  32.399  1.00 33.74           C  
ATOM    541  C   ALA A  82      23.695  45.764  31.266  1.00 48.91           C  
ATOM    542  O   ALA A  82      23.693  46.236  30.126  1.00 53.63           O  
ATOM    543  CB  ALA A  82      25.960  45.858  32.495  1.00 28.67           C  
ATOM    544  N   VAL A  83      22.955  44.696  31.561  1.00 35.59           N  
ATOM    545  CA  VAL A  83      22.209  44.071  30.510  1.00 30.30           C  
ATOM    546  C   VAL A  83      20.801  44.624  30.312  1.00 34.04           C  
ATOM    547  O   VAL A  83      20.320  44.825  29.192  1.00 36.23           O  
ATOM    548  CB  VAL A  83      22.180  42.558  30.789  1.00 31.09           C  
ATOM    549  CG1 VAL A  83      21.322  41.840  29.768  1.00 30.99           C  
ATOM    550  CG2 VAL A  83      23.579  41.930  30.851  1.00 28.00           C  
ATOM    551  N   VAL A  84      20.086  44.834  31.396  1.00 31.04           N  
ATOM    552  CA  VAL A  84      18.687  45.226  31.248  1.00 29.97           C  
ATOM    553  C   VAL A  84      18.296  46.667  31.159  1.00 31.85           C  
ATOM    554  O   VAL A  84      17.145  46.954  30.863  1.00 32.99           O  
ATOM    555  CB  VAL A  84      17.848  44.578  32.352  1.00 33.52           C  
ATOM    556  CG1 VAL A  84      18.213  43.105  32.552  1.00 31.00           C  
ATOM    557  CG2 VAL A  84      18.045  45.335  33.677  1.00 32.26           C  
ATOM    558  N   HIS A  85      19.205  47.557  31.489  1.00 30.15           N  
ATOM    559  CA  HIS A  85      18.885  48.965  31.472  1.00 35.26           C  
ATOM    560  C   HIS A  85      18.417  49.352  30.100  1.00 40.10           C  
ATOM    561  O   HIS A  85      17.385  49.977  29.872  1.00 35.12           O  
ATOM    562  CB  HIS A  85      20.120  49.811  31.781  1.00 39.15           C  
ATOM    563  CG  HIS A  85      19.740  51.235  32.045  1.00 48.24           C  
ATOM    564  ND1 HIS A  85      19.864  52.229  31.077  1.00 52.95           N  
ATOM    565  CD2 HIS A  85      19.214  51.817  33.166  1.00 50.78           C  
ATOM    566  CE1 HIS A  85      19.426  53.371  31.626  1.00 51.00           C  
ATOM    567  NE2 HIS A  85      19.033  53.159  32.881  1.00 50.70           N  
ATOM    568  N   GLU A  86      19.242  48.939  29.180  1.00 42.08           N  
ATOM    569  CA  GLU A  86      18.984  49.195  27.798  1.00 45.52           C  
ATOM    570  C   GLU A  86      17.725  48.495  27.380  1.00 53.98           C  
ATOM    571  O   GLU A  86      17.183  48.745  26.309  1.00 57.44           O  
ATOM    572  CB  GLU A  86      20.151  48.722  26.916  1.00 47.69           C  
ATOM    573  CG  GLU A  86      19.921  47.327  26.317  1.00 51.55           C  
ATOM    574  CD  GLU A  86      21.191  46.805  25.706  1.00100.00           C  
ATOM    575  OE1 GLU A  86      22.104  47.528  25.317  1.00100.00           O  
ATOM    576  OE2 GLU A  86      21.230  45.502  25.672  1.00100.00           O  
ATOM    577  N   LYS A  87      17.251  47.596  28.216  1.00 49.43           N  
ATOM    578  CA  LYS A  87      16.044  46.910  27.832  1.00 44.20           C  
ATOM    579  C   LYS A  87      14.864  47.521  28.491  1.00 46.53           C  
ATOM    580  O   LYS A  87      13.794  46.913  28.497  1.00 47.30           O  
ATOM    581  CB  LYS A  87      16.044  45.432  28.104  1.00 42.79           C  
ATOM    582  CG  LYS A  87      17.271  44.712  27.581  1.00 55.65           C  
ATOM    583  CD  LYS A  87      17.199  43.227  27.887  1.00 64.77           C  
ATOM    584  CE  LYS A  87      18.204  42.413  27.086  1.00 82.20           C  
ATOM    585  NZ  LYS A  87      19.325  43.234  26.600  1.00100.00           N  
ATOM    586  N   GLY A  88      15.087  48.706  29.052  1.00 42.29           N  
ATOM    587  CA  GLY A  88      14.012  49.400  29.722  1.00 43.95           C  
ATOM    588  C   GLY A  88      13.660  48.861  31.105  1.00 50.48           C  
ATOM    589  O   GLY A  88      12.572  49.127  31.634  1.00 47.26           O  
ATOM    590  N   MET A  89      14.573  48.109  31.711  1.00 45.36           N  
ATOM    591  CA  MET A  89      14.255  47.619  33.020  1.00 39.08           C  
ATOM    592  C   MET A  89      15.152  48.300  33.994  1.00 36.54           C  
ATOM    593  O   MET A  89      16.160  48.921  33.662  1.00 35.35           O  
ATOM    594  CB  MET A  89      14.571  46.128  33.166  1.00 39.61           C  
ATOM    595  CG  MET A  89      14.176  45.298  31.976  1.00 45.23           C  
ATOM    596  SD  MET A  89      12.388  45.319  31.785  1.00 51.85           S  
ATOM    597  CE  MET A  89      11.798  44.540  33.308  1.00 48.27           C  
ATOM    598  N   MET A  90      14.749  48.123  35.217  1.00 35.75           N  
ATOM    599  CA  MET A  90      15.518  48.578  36.330  1.00 41.59           C  
ATOM    600  C   MET A  90      15.779  47.313  37.138  1.00 37.30           C  
ATOM    601  O   MET A  90      15.028  46.304  37.028  1.00 30.78           O  
ATOM    602  CB  MET A  90      14.877  49.710  37.124  1.00 48.23           C  
ATOM    603  CG  MET A  90      13.582  49.306  37.758  1.00 57.60           C  
ATOM    604  SD  MET A  90      13.972  48.678  39.386  1.00 71.01           S  
ATOM    605  CE  MET A  90      12.659  49.514  40.308  1.00 67.96           C  
ATOM    606  N   ALA A  91      16.891  47.359  37.876  1.00 33.39           N  
ATOM    607  CA  ALA A  91      17.316  46.242  38.723  1.00 29.57           C  
ATOM    608  C   ALA A  91      17.787  46.742  40.063  1.00 30.11           C  
ATOM    609  O   ALA A  91      18.564  47.695  40.119  1.00 31.55           O  
ATOM    610  CB  ALA A  91      18.412  45.427  38.043  1.00 28.14           C  
ATOM    611  N   VAL A  92      17.293  46.118  41.134  1.00 25.78           N  
ATOM    612  CA  VAL A  92      17.683  46.484  42.484  1.00 24.00           C  
ATOM    613  C   VAL A  92      17.885  45.220  43.278  1.00 28.76           C  
ATOM    614  O   VAL A  92      17.226  44.212  43.030  1.00 27.31           O  
ATOM    615  CB  VAL A  92      16.609  47.265  43.202  1.00 27.07           C  
ATOM    616  CG1 VAL A  92      16.414  48.594  42.513  1.00 27.68           C  
ATOM    617  CG2 VAL A  92      15.316  46.458  43.146  1.00 24.76           C  
ATOM    618  N   GLY A  93      18.792  45.277  44.238  1.00 25.58           N  
ATOM    619  CA  GLY A  93      18.989  44.112  45.056  1.00 19.98           C  
ATOM    620  C   GLY A  93      17.668  43.796  45.758  1.00 26.63           C  
ATOM    621  O   GLY A  93      16.941  44.672  46.227  1.00 25.90           O  
ATOM    622  N   GLN A  94      17.348  42.518  45.841  1.00 26.20           N  
ATOM    623  CA  GLN A  94      16.132  42.070  46.504  1.00 24.50           C  
ATOM    624  C   GLN A  94      16.493  41.270  47.765  1.00 24.12           C  
ATOM    625  O   GLN A  94      15.842  41.309  48.821  1.00 23.01           O  
ATOM    626  CB  GLN A  94      15.412  41.150  45.527  1.00 26.20           C  
ATOM    627  CG  GLN A  94      14.056  40.827  46.104  1.00 50.59           C  
ATOM    628  CD  GLN A  94      13.073  40.379  45.063  1.00 63.80           C  
ATOM    629  OE1 GLN A  94      11.845  40.569  45.284  1.00 43.22           O  
ATOM    630  NE2 GLN A  94      13.614  39.776  43.991  1.00 32.32           N  
ATOM    631  N   SER A  95      17.556  40.498  47.648  1.00 18.51           N  
ATOM    632  CA  SER A  95      18.040  39.704  48.766  1.00 18.37           C  
ATOM    633  C   SER A  95      19.540  39.559  48.650  1.00 23.29           C  
ATOM    634  O   SER A  95      20.049  39.324  47.540  1.00 26.24           O  
ATOM    635  CB  SER A  95      17.385  38.323  48.848  1.00 23.75           C  
ATOM    636  OG  SER A  95      18.042  37.513  49.814  1.00 24.96           O  
ATOM    637  N   ASN A  96      20.209  39.709  49.802  1.00 18.66           N  
ATOM    638  CA  ASN A  96      21.645  39.597  49.905  1.00 17.72           C  
ATOM    639  C   ASN A  96      21.967  38.807  51.140  1.00 24.38           C  
ATOM    640  O   ASN A  96      21.741  39.249  52.297  1.00 22.37           O  
ATOM    641  CB  ASN A  96      22.365  40.973  49.974  1.00 18.42           C  
ATOM    642  CG  ASN A  96      23.888  40.971  50.188  1.00 23.84           C  
ATOM    643  OD1 ASN A  96      24.541  39.984  50.676  1.00 20.25           O  
ATOM    644  ND2 ASN A  96      24.461  42.153  49.872  1.00 22.88           N  
ATOM    645  N   HIS A  97      22.489  37.618  50.855  1.00 21.31           N  
ATOM    646  CA  HIS A  97      22.883  36.674  51.885  1.00 19.32           C  
ATOM    647  C   HIS A  97      24.374  36.416  51.811  1.00 24.69           C  
ATOM    648  O   HIS A  97      24.828  35.694  50.909  1.00 19.95           O  
ATOM    649  CB  HIS A  97      22.092  35.343  51.816  1.00 17.97           C  
ATOM    650  CG  HIS A  97      22.460  34.393  52.961  1.00 24.34           C  
ATOM    651  ND1 HIS A  97      22.060  33.038  52.987  1.00 24.62           N  
ATOM    652  CD2 HIS A  97      23.216  34.612  54.110  1.00 24.71           C  
ATOM    653  CE1 HIS A  97      22.582  32.494  54.112  1.00 22.56           C  
ATOM    654  NE2 HIS A  97      23.283  33.409  54.799  1.00 22.73           N  
ATOM    655  N   THR A  98      25.104  37.039  52.755  1.00 19.29           N  
ATOM    656  CA  THR A  98      26.556  36.931  52.831  1.00 17.72           C  
ATOM    657  C   THR A  98      26.964  36.151  54.061  1.00 22.26           C  
ATOM    658  O   THR A  98      26.417  36.340  55.145  1.00 24.62           O  
ATOM    659  CB  THR A  98      27.168  38.362  52.789  1.00 20.39           C  
ATOM    660  OG1 THR A  98      26.741  39.072  51.630  1.00 20.12           O  
ATOM    661  CG2 THR A  98      28.694  38.369  52.881  1.00 21.91           C  
ATOM    662  N   SER A  99      27.882  35.217  53.850  1.00 19.02           N  
ATOM    663  CA  SER A  99      28.411  34.356  54.874  1.00 21.25           C  
ATOM    664  C   SER A  99      29.896  34.603  54.987  1.00 28.78           C  
ATOM    665  O   SER A  99      30.597  34.630  53.972  1.00 23.39           O  
ATOM    666  CB  SER A  99      28.151  32.899  54.553  1.00 19.89           C  
ATOM    667  OG  SER A  99      26.778  32.742  54.378  1.00 21.28           O  
ATOM    668  N   PHE A 100      30.384  34.759  56.218  1.00 28.62           N  
ATOM    669  CA  PHE A 100      31.790  35.087  56.486  1.00 23.85           C  
ATOM    670  C   PHE A 100      32.625  33.902  56.960  1.00 29.44           C  
ATOM    671  O   PHE A 100      32.358  33.375  58.038  1.00 25.74           O  
ATOM    672  CB  PHE A 100      31.801  36.212  57.541  1.00 19.75           C  
ATOM    673  CG  PHE A 100      30.837  37.342  57.163  1.00 25.67           C  
ATOM    674  CD1 PHE A 100      29.606  37.476  57.817  1.00 26.05           C  
ATOM    675  CD2 PHE A 100      31.161  38.290  56.185  1.00 22.25           C  
ATOM    676  CE1 PHE A 100      28.712  38.494  57.494  1.00 24.05           C  
ATOM    677  CE2 PHE A 100      30.295  39.340  55.858  1.00 21.22           C  
ATOM    678  CZ  PHE A 100      29.061  39.426  56.510  1.00 21.50           C  
ATOM    679  N   PHE A 101      33.633  33.513  56.149  1.00 23.58           N  
ATOM    680  CA  PHE A 101      34.507  32.375  56.439  1.00 22.82           C  
ATOM    681  C   PHE A 101      35.837  32.714  57.105  1.00 29.05           C  
ATOM    682  O   PHE A 101      36.294  31.975  57.961  1.00 23.17           O  
ATOM    683  CB  PHE A 101      34.810  31.515  55.180  1.00 19.08           C  
ATOM    684  CG  PHE A 101      33.558  31.122  54.420  1.00 23.41           C  
ATOM    685  CD1 PHE A 101      32.366  30.821  55.086  1.00 23.56           C  
ATOM    686  CD2 PHE A 101      33.565  31.056  53.021  1.00 24.02           C  
ATOM    687  CE1 PHE A 101      31.231  30.459  54.351  1.00 25.84           C  
ATOM    688  CE2 PHE A 101      32.441  30.700  52.266  1.00 24.66           C  
ATOM    689  CZ  PHE A 101      31.262  30.409  52.950  1.00 24.70           C  
ATOM    690  N   ARG A 102      36.469  33.791  56.645  1.00 27.14           N  
ATOM    691  CA  ARG A 102      37.755  34.182  57.149  1.00 22.23           C  
ATOM    692  C   ARG A 102      37.821  35.672  57.001  1.00 25.79           C  
ATOM    693  O   ARG A 102      37.438  36.238  55.996  1.00 27.37           O  
ATOM    694  CB  ARG A 102      38.865  33.544  56.301  1.00 21.95           C  
ATOM    695  CG  ARG A 102      40.233  34.218  56.449  1.00 41.88           C  
ATOM    696  CD  ARG A 102      41.312  33.519  55.623  1.00 42.66           C  
ATOM    697  NE  ARG A 102      41.042  32.105  55.769  1.00 90.98           N  
ATOM    698  CZ  ARG A 102      41.650  31.335  56.659  1.00100.00           C  
ATOM    699  NH1 ARG A 102      42.564  31.850  57.500  1.00 72.50           N  
ATOM    700  NH2 ARG A 102      41.341  30.037  56.757  1.00 96.95           N  
ATOM    701  N   PRO A 103      38.345  36.310  58.020  1.00 30.27           N  
ATOM    702  CA  PRO A 103      38.464  37.771  58.079  1.00 30.54           C  
ATOM    703  C   PRO A 103      39.592  38.328  57.249  1.00 33.29           C  
ATOM    704  O   PRO A 103      40.552  37.620  56.944  1.00 31.74           O  
ATOM    705  CB  PRO A 103      38.836  38.078  59.530  1.00 29.88           C  
ATOM    706  CG  PRO A 103      39.355  36.748  60.110  1.00 35.01           C  
ATOM    707  CD  PRO A 103      38.836  35.618  59.235  1.00 29.45           C  
ATOM    708  N   VAL A 104      39.491  39.606  56.919  1.00 24.92           N  
ATOM    709  CA  VAL A 104      40.592  40.190  56.181  1.00 25.20           C  
ATOM    710  C   VAL A 104      41.048  41.376  57.037  1.00 32.82           C  
ATOM    711  O   VAL A 104      40.195  42.126  57.533  1.00 27.48           O  
ATOM    712  CB  VAL A 104      40.155  40.641  54.790  1.00 27.51           C  
ATOM    713  CG1 VAL A 104      41.272  41.403  54.077  1.00 25.96           C  
ATOM    714  CG2 VAL A 104      39.683  39.459  53.946  1.00 28.34           C  
ATOM    715  N   LYS A 105      42.368  41.539  57.235  1.00 29.81           N  
ATOM    716  CA  LYS A 105      42.882  42.647  58.022  1.00 28.95           C  
ATOM    717  C   LYS A 105      43.451  43.737  57.112  1.00 29.11           C  
ATOM    718  O   LYS A 105      43.337  44.933  57.351  1.00 29.42           O  
ATOM    719  CB  LYS A 105      43.867  42.165  59.074  1.00 31.21           C  
ATOM    720  CG  LYS A 105      44.288  43.257  60.042  1.00 46.63           C  
ATOM    721  CD  LYS A 105      45.250  42.738  61.098  1.00 49.05           C  
ATOM    722  CE  LYS A 105      45.076  43.403  62.456  1.00 69.99           C  
ATOM    723  NZ  LYS A 105      44.677  44.819  62.354  1.00 68.71           N  
ATOM    724  N   GLU A 106      44.068  43.315  56.017  1.00 24.48           N  
ATOM    725  CA  GLU A 106      44.644  44.273  55.084  1.00 24.34           C  
ATOM    726  C   GLU A 106      44.816  43.654  53.680  1.00 30.81           C  
ATOM    727  O   GLU A 106      44.595  42.443  53.502  1.00 34.44           O  
ATOM    728  CB  GLU A 106      45.979  44.813  55.644  1.00 23.91           C  
ATOM    729  CG  GLU A 106      47.060  43.730  55.623  1.00 33.93           C  
ATOM    730  CD  GLU A 106      48.450  44.204  56.009  1.00 39.24           C  
ATOM    731  OE1 GLU A 106      49.335  44.587  55.241  1.00 44.56           O  
ATOM    732  OE2 GLU A 106      48.617  44.110  57.285  1.00 28.85           O  
ATOM    733  N   GLY A 107      45.198  44.497  52.705  1.00 27.21           N  
ATOM    734  CA  GLY A 107      45.407  44.123  51.304  1.00 23.70           C  
ATOM    735  C   GLY A 107      44.242  44.618  50.484  1.00 28.47           C  
ATOM    736  O   GLY A 107      43.973  45.810  50.471  1.00 30.55           O  
ATOM    737  N   HIS A 108      43.564  43.677  49.826  1.00 32.93           N  
ATOM    738  CA  HIS A 108      42.378  43.930  49.025  1.00 34.09           C  
ATOM    739  C   HIS A 108      41.389  42.815  49.240  1.00 31.26           C  
ATOM    740  O   HIS A 108      41.714  41.777  49.800  1.00 26.77           O  
ATOM    741  CB  HIS A 108      42.632  43.836  47.507  1.00 37.78           C  
ATOM    742  CG  HIS A 108      43.678  44.776  47.082  1.00 41.38           C  
ATOM    743  ND1 HIS A 108      45.010  44.568  47.447  1.00 41.57           N  
ATOM    744  CD2 HIS A 108      43.568  45.920  46.366  1.00 41.29           C  
ATOM    745  CE1 HIS A 108      45.683  45.574  46.930  1.00 40.05           C  
ATOM    746  NE2 HIS A 108      44.857  46.406  46.283  1.00 40.34           N  
ATOM    747  N   VAL A 109      40.205  43.074  48.707  1.00 32.56           N  
ATOM    748  CA  VAL A 109      39.104  42.145  48.649  1.00 30.10           C  
ATOM    749  C   VAL A 109      38.746  42.130  47.193  1.00 30.07           C  
ATOM    750  O   VAL A 109      38.566  43.186  46.566  1.00 27.26           O  
ATOM    751  CB  VAL A 109      37.882  42.514  49.488  1.00 29.08           C  
ATOM    752  CG1 VAL A 109      36.807  41.424  49.321  1.00 25.29           C  
ATOM    753  CG2 VAL A 109      38.311  42.616  50.955  1.00 26.40           C  
ATOM    754  N   ARG A 110      38.729  40.935  46.664  1.00 26.78           N  
ATOM    755  CA  ARG A 110      38.413  40.786  45.263  1.00 29.02           C  
ATOM    756  C   ARG A 110      37.170  39.953  45.127  1.00 29.44           C  
ATOM    757  O   ARG A 110      37.095  38.831  45.619  1.00 28.24           O  
ATOM    758  CB  ARG A 110      39.549  40.076  44.568  1.00 34.00           C  
ATOM    759  CG  ARG A 110      40.833  40.898  44.586  1.00 40.98           C  
ATOM    760  CD  ARG A 110      42.053  40.028  44.250  1.00 40.66           C  
ATOM    761  NE  ARG A 110      42.135  38.780  45.048  1.00100.00           N  
ATOM    762  CZ  ARG A 110      42.864  37.650  44.805  1.00100.00           C  
ATOM    763  NH1 ARG A 110      43.681  37.508  43.752  1.00100.00           N  
ATOM    764  NH2 ARG A 110      42.776  36.622  45.662  1.00 71.59           N  
ATOM    765  N   ALA A 111      36.207  40.505  44.426  1.00 25.36           N  
ATOM    766  CA  ALA A 111      34.947  39.808  44.276  1.00 24.90           C  
ATOM    767  C   ALA A 111      34.710  39.307  42.891  1.00 34.65           C  
ATOM    768  O   ALA A 111      35.028  39.975  41.914  1.00 35.24           O  
ATOM    769  CB  ALA A 111      33.783  40.737  44.628  1.00 21.89           C  
ATOM    770  N   GLU A 112      34.099  38.136  42.811  1.00 35.27           N  
ATOM    771  CA  GLU A 112      33.757  37.576  41.508  1.00 33.70           C  
ATOM    772  C   GLU A 112      32.325  37.106  41.536  1.00 28.63           C  
ATOM    773  O   GLU A 112      31.952  36.204  42.302  1.00 26.37           O  
ATOM    774  CB  GLU A 112      34.642  36.382  41.068  1.00 33.33           C  
ATOM    775  CG  GLU A 112      34.173  35.771  39.727  1.00 37.74           C  
ATOM    776  CD  GLU A 112      35.122  34.714  39.231  1.00 47.45           C  
ATOM    777  OE1 GLU A 112      35.260  33.657  39.792  1.00 74.03           O  
ATOM    778  OE2 GLU A 112      35.847  35.077  38.203  1.00 62.66           O  
ATOM    779  N   ALA A 113      31.544  37.725  40.685  1.00 25.57           N  
ATOM    780  CA  ALA A 113      30.147  37.375  40.578  1.00 25.23           C  
ATOM    781  C   ALA A 113      29.921  36.529  39.344  1.00 29.34           C  
ATOM    782  O   ALA A 113      30.308  36.905  38.234  1.00 28.19           O  
ATOM    783  CB  ALA A 113      29.304  38.636  40.464  1.00 24.04           C  
ATOM    784  N   VAL A 114      29.274  35.392  39.560  1.00 25.87           N  
ATOM    785  CA  VAL A 114      28.947  34.453  38.486  1.00 24.79           C  
ATOM    786  C   VAL A 114      27.440  34.315  38.360  1.00 30.61           C  
ATOM    787  O   VAL A 114      26.752  33.977  39.335  1.00 26.76           O  
ATOM    788  CB  VAL A 114      29.535  33.111  38.846  1.00 31.17           C  
ATOM    789  CG1 VAL A 114      29.025  32.064  37.846  1.00 29.78           C  
ATOM    790  CG2 VAL A 114      31.064  33.266  38.868  1.00 29.33           C  
ATOM    791  N   ARG A 115      26.895  34.608  37.197  1.00 24.42           N  
ATOM    792  CA  ARG A 115      25.461  34.534  37.106  1.00 25.32           C  
ATOM    793  C   ARG A 115      24.933  33.110  37.093  1.00 33.04           C  
ATOM    794  O   ARG A 115      25.428  32.263  36.334  1.00 27.98           O  
ATOM    795  CB  ARG A 115      25.001  35.264  35.872  1.00 22.70           C  
ATOM    796  CG  ARG A 115      23.502  35.397  35.833  1.00 23.57           C  
ATOM    797  CD  ARG A 115      23.133  36.182  34.607  1.00 33.73           C  
ATOM    798  NE  ARG A 115      22.953  35.302  33.462  1.00 38.20           N  
ATOM    799  CZ  ARG A 115      22.850  35.726  32.202  1.00 42.94           C  
ATOM    800  NH1 ARG A 115      22.951  36.993  31.833  1.00 30.95           N  
ATOM    801  NH2 ARG A 115      22.651  34.843  31.248  1.00 48.63           N  
ATOM    802  N   ILE A 116      23.911  32.847  37.915  1.00 27.09           N  
ATOM    803  CA  ILE A 116      23.394  31.506  37.913  1.00 28.96           C  
ATOM    804  C   ILE A 116      21.965  31.352  37.410  1.00 30.43           C  
ATOM    805  O   ILE A 116      21.499  30.281  37.026  1.00 25.73           O  
ATOM    806  CB  ILE A 116      23.631  30.724  39.189  1.00 32.56           C  
ATOM    807  CG1 ILE A 116      22.828  31.305  40.342  1.00 29.43           C  
ATOM    808  CG2 ILE A 116      25.119  30.570  39.495  1.00 30.68           C  
ATOM    809  CD1 ILE A 116      22.749  30.285  41.467  1.00 30.77           C  
ATOM    810  N   HIS A 117      21.264  32.433  37.401  1.00 26.11           N  
ATOM    811  CA  HIS A 117      19.926  32.343  36.939  1.00 22.98           C  
ATOM    812  C   HIS A 117      19.508  33.715  36.412  1.00 25.81           C  
ATOM    813  O   HIS A 117      19.772  34.750  37.003  1.00 26.98           O  
ATOM    814  CB  HIS A 117      19.076  31.809  38.103  1.00 23.72           C  
ATOM    815  CG  HIS A 117      17.658  31.945  37.758  1.00 31.70           C  
ATOM    816  ND1 HIS A 117      17.098  31.171  36.739  1.00 37.81           N  
ATOM    817  CD2 HIS A 117      16.703  32.792  38.242  1.00 38.37           C  
ATOM    818  CE1 HIS A 117      15.814  31.549  36.646  1.00 37.10           C  
ATOM    819  NE2 HIS A 117      15.538  32.524  37.531  1.00 36.73           N  
ATOM    820  N   ALA A 118      18.908  33.754  35.244  1.00 23.68           N  
ATOM    821  CA  ALA A 118      18.470  34.998  34.651  1.00 24.14           C  
ATOM    822  C   ALA A 118      16.985  34.898  34.275  1.00 37.29           C  
ATOM    823  O   ALA A 118      16.649  34.685  33.103  1.00 38.46           O  
ATOM    824  CB  ALA A 118      19.299  35.358  33.421  1.00 23.31           C  
ATOM    825  N   GLY A 119      16.092  35.048  35.268  1.00 25.90           N  
ATOM    826  CA  GLY A 119      14.680  34.992  34.973  1.00 23.38           C  
ATOM    827  C   GLY A 119      14.146  36.334  34.510  1.00 31.39           C  
ATOM    828  O   GLY A 119      14.860  37.328  34.432  1.00 35.92           O  
ATOM    829  N   SER A 120      12.862  36.400  34.233  1.00 31.02           N  
ATOM    830  CA  SER A 120      12.309  37.676  33.811  1.00 32.05           C  
ATOM    831  C   SER A 120      12.127  38.670  34.954  1.00 33.85           C  
ATOM    832  O   SER A 120      12.106  39.880  34.760  1.00 37.70           O  
ATOM    833  CB  SER A 120      10.995  37.483  33.063  1.00 33.70           C  
ATOM    834  OG  SER A 120      10.018  36.906  33.915  1.00 54.52           O  
ATOM    835  N   THR A 121      11.980  38.177  36.162  1.00 26.38           N  
ATOM    836  CA  THR A 121      11.773  39.093  37.247  1.00 26.96           C  
ATOM    837  C   THR A 121      12.909  39.057  38.243  1.00 32.69           C  
ATOM    838  O   THR A 121      12.995  39.939  39.076  1.00 29.60           O  
ATOM    839  CB  THR A 121      10.435  38.830  37.949  1.00 23.13           C  
ATOM    840  OG1 THR A 121      10.407  37.523  38.517  1.00 32.35           O  
ATOM    841  CG2 THR A 121       9.340  38.966  36.917  1.00 24.82           C  
ATOM    842  N   THR A 122      13.758  38.025  38.151  1.00 29.53           N  
ATOM    843  CA  THR A 122      14.854  37.909  39.085  1.00 28.06           C  
ATOM    844  C   THR A 122      16.102  37.292  38.464  1.00 30.28           C  
ATOM    845  O   THR A 122      16.050  36.293  37.766  1.00 28.59           O  
ATOM    846  CB  THR A 122      14.418  36.950  40.243  1.00 29.14           C  
ATOM    847  OG1 THR A 122      13.178  37.263  40.843  1.00 29.11           O  
ATOM    848  CG2 THR A 122      15.477  36.832  41.328  1.00 38.10           C  
ATOM    849  N   TRP A 123      17.254  37.856  38.763  1.00 26.38           N  
ATOM    850  CA  TRP A 123      18.517  37.278  38.329  1.00 24.02           C  
ATOM    851  C   TRP A 123      19.234  36.877  39.611  1.00 30.43           C  
ATOM    852  O   TRP A 123      19.098  37.509  40.672  1.00 30.34           O  
ATOM    853  CB  TRP A 123      19.448  38.254  37.609  1.00 23.47           C  
ATOM    854  CG  TRP A 123      19.040  38.530  36.202  1.00 26.14           C  
ATOM    855  CD1 TRP A 123      17.789  38.519  35.709  1.00 28.34           C  
ATOM    856  CD2 TRP A 123      19.915  38.886  35.134  1.00 26.59           C  
ATOM    857  NE1 TRP A 123      17.815  38.822  34.379  1.00 28.55           N  
ATOM    858  CE2 TRP A 123      19.105  39.057  33.994  1.00 29.95           C  
ATOM    859  CE3 TRP A 123      21.304  39.087  35.067  1.00 29.61           C  
ATOM    860  CZ2 TRP A 123      19.650  39.429  32.763  1.00 28.38           C  
ATOM    861  CZ3 TRP A 123      21.861  39.463  33.867  1.00 32.40           C  
ATOM    862  CH2 TRP A 123      21.032  39.622  32.738  1.00 34.00           C  
ATOM    863  N   PHE A 124      20.045  35.855  39.525  1.00 26.85           N  
ATOM    864  CA  PHE A 124      20.751  35.385  40.690  1.00 23.06           C  
ATOM    865  C   PHE A 124      22.225  35.198  40.410  1.00 23.92           C  
ATOM    866  O   PHE A 124      22.624  34.586  39.415  1.00 25.44           O  
ATOM    867  CB  PHE A 124      20.060  34.086  41.156  1.00 22.85           C  
ATOM    868  CG  PHE A 124      20.378  33.710  42.587  1.00 29.78           C  
ATOM    869  CD1 PHE A 124      19.421  33.911  43.583  1.00 27.27           C  
ATOM    870  CD2 PHE A 124      21.618  33.151  42.937  1.00 30.51           C  
ATOM    871  CE1 PHE A 124      19.708  33.549  44.904  1.00 31.15           C  
ATOM    872  CE2 PHE A 124      21.925  32.785  44.246  1.00 31.54           C  
ATOM    873  CZ  PHE A 124      20.945  32.981  45.223  1.00 32.25           C  
ATOM    874  N   TRP A 125      23.027  35.755  41.309  1.00 19.64           N  
ATOM    875  CA  TRP A 125      24.462  35.682  41.189  1.00 19.68           C  
ATOM    876  C   TRP A 125      25.085  35.164  42.459  1.00 22.56           C  
ATOM    877  O   TRP A 125      24.661  35.502  43.577  1.00 25.39           O  
ATOM    878  CB  TRP A 125      25.054  37.095  40.973  1.00 21.05           C  
ATOM    879  CG  TRP A 125      24.552  37.872  39.763  1.00 25.31           C  
ATOM    880  CD1 TRP A 125      23.351  38.531  39.662  1.00 28.04           C  
ATOM    881  CD2 TRP A 125      25.268  38.144  38.503  1.00 25.39           C  
ATOM    882  NE1 TRP A 125      23.245  39.116  38.413  1.00 29.50           N  
ATOM    883  CE2 TRP A 125      24.406  38.909  37.683  1.00 28.84           C  
ATOM    884  CE3 TRP A 125      26.524  37.763  37.976  1.00 26.23           C  
ATOM    885  CZ2 TRP A 125      24.786  39.327  36.392  1.00 26.51           C  
ATOM    886  CZ3 TRP A 125      26.873  38.124  36.692  1.00 23.81           C  
ATOM    887  CH2 TRP A 125      26.019  38.922  35.921  1.00 23.18           C  
ATOM    888  N   ASP A 126      26.113  34.356  42.257  1.00 20.31           N  
ATOM    889  CA  ASP A 126      26.919  33.836  43.337  1.00 24.07           C  
ATOM    890  C   ASP A 126      28.180  34.677  43.413  1.00 29.94           C  
ATOM    891  O   ASP A 126      28.954  34.727  42.465  1.00 28.57           O  
ATOM    892  CB  ASP A 126      27.366  32.392  43.121  1.00 22.74           C  
ATOM    893  CG  ASP A 126      26.326  31.368  43.500  1.00 38.01           C  
ATOM    894  OD1 ASP A 126      25.318  31.572  44.187  1.00 41.32           O  
ATOM    895  OD2 ASP A 126      26.661  30.207  43.009  1.00 37.64           O  
ATOM    896  N   VAL A 127      28.401  35.352  44.525  1.00 25.49           N  
ATOM    897  CA  VAL A 127      29.590  36.147  44.605  1.00 21.59           C  
ATOM    898  C   VAL A 127      30.577  35.549  45.587  1.00 27.84           C  
ATOM    899  O   VAL A 127      30.215  35.173  46.712  1.00 26.29           O  
ATOM    900  CB  VAL A 127      29.237  37.569  45.021  1.00 24.67           C  
ATOM    901  CG1 VAL A 127      30.445  38.503  44.890  1.00 24.15           C  
ATOM    902  CG2 VAL A 127      28.065  38.086  44.195  1.00 21.58           C  
ATOM    903  N   SER A 128      31.828  35.508  45.128  1.00 26.25           N  
ATOM    904  CA  SER A 128      32.978  35.047  45.905  1.00 24.99           C  
ATOM    905  C   SER A 128      33.848  36.222  46.279  1.00 26.05           C  
ATOM    906  O   SER A 128      34.158  37.039  45.427  1.00 30.47           O  
ATOM    907  CB  SER A 128      33.855  34.098  45.113  1.00 25.23           C  
ATOM    908  OG  SER A 128      33.128  32.894  45.022  1.00 33.38           O  
ATOM    909  N   LEU A 129      34.266  36.294  47.524  1.00 19.78           N  
ATOM    910  CA  LEU A 129      35.119  37.402  47.942  1.00 24.91           C  
ATOM    911  C   LEU A 129      36.406  36.827  48.509  1.00 28.34           C  
ATOM    912  O   LEU A 129      36.399  36.095  49.502  1.00 28.82           O  
ATOM    913  CB  LEU A 129      34.409  38.407  48.899  1.00 24.22           C  
ATOM    914  CG  LEU A 129      33.144  39.019  48.256  1.00 29.48           C  
ATOM    915  CD1 LEU A 129      31.847  38.373  48.758  1.00 28.56           C  
ATOM    916  CD2 LEU A 129      33.069  40.524  48.451  1.00 28.30           C  
ATOM    917  N   ARG A 130      37.515  37.127  47.836  1.00 26.46           N  
ATOM    918  CA  ARG A 130      38.799  36.595  48.248  1.00 24.35           C  
ATOM    919  C   ARG A 130      39.802  37.628  48.698  1.00 21.64           C  
ATOM    920  O   ARG A 130      39.701  38.808  48.396  1.00 21.37           O  
ATOM    921  CB  ARG A 130      39.427  35.805  47.108  1.00 25.00           C  
ATOM    922  CG  ARG A 130      38.458  34.788  46.530  1.00 31.77           C  
ATOM    923  CD  ARG A 130      39.130  33.905  45.483  1.00 27.09           C  
ATOM    924  NE  ARG A 130      38.248  32.781  45.137  1.00 32.77           N  
ATOM    925  CZ  ARG A 130      38.186  31.570  45.744  1.00 54.01           C  
ATOM    926  NH1 ARG A 130      38.976  31.159  46.748  1.00 35.26           N  
ATOM    927  NH2 ARG A 130      37.283  30.697  45.287  1.00 48.90           N  
ATOM    928  N   ASP A 131      40.804  37.121  49.420  1.00 26.74           N  
ATOM    929  CA  ASP A 131      41.882  37.977  49.895  1.00 25.12           C  
ATOM    930  C   ASP A 131      43.018  37.941  48.889  1.00 35.67           C  
ATOM    931  O   ASP A 131      42.937  37.270  47.862  1.00 30.83           O  
ATOM    932  CB  ASP A 131      42.430  37.586  51.259  1.00 22.87           C  
ATOM    933  CG  ASP A 131      42.938  36.165  51.260  1.00 32.33           C  
ATOM    934  OD1 ASP A 131      43.330  35.552  50.290  1.00 30.76           O  
ATOM    935  OD2 ASP A 131      42.850  35.621  52.431  1.00 30.84           O  
ATOM    936  N   ASP A 132      44.082  38.641  49.235  1.00 36.46           N  
ATOM    937  CA  ASP A 132      45.233  38.723  48.374  1.00 32.16           C  
ATOM    938  C   ASP A 132      45.918  37.360  48.145  1.00 42.58           C  
ATOM    939  O   ASP A 132      46.517  37.127  47.102  1.00 37.26           O  
ATOM    940  CB  ASP A 132      46.134  39.915  48.726  1.00 32.01           C  
ATOM    941  CG  ASP A 132      45.604  41.236  48.199  1.00 45.70           C  
ATOM    942  OD1 ASP A 132      44.665  41.297  47.393  1.00 51.58           O  
ATOM    943  OD2 ASP A 132      46.263  42.307  48.670  1.00 47.46           O  
ATOM    944  N   ALA A 133      45.784  36.421  49.093  1.00 37.66           N  
ATOM    945  CA  ALA A 133      46.354  35.092  48.961  1.00 33.34           C  
ATOM    946  C   ALA A 133      45.438  34.203  48.106  1.00 37.04           C  
ATOM    947  O   ALA A 133      45.714  33.044  47.775  1.00 37.69           O  
ATOM    948  CB  ALA A 133      46.568  34.498  50.351  1.00 30.29           C  
ATOM    949  N   GLY A 134      44.303  34.762  47.736  1.00 34.08           N  
ATOM    950  CA  GLY A 134      43.366  33.993  46.952  1.00 33.76           C  
ATOM    951  C   GLY A 134      42.408  33.187  47.828  1.00 36.97           C  
ATOM    952  O   GLY A 134      41.542  32.488  47.314  1.00 39.02           O  
ATOM    953  N   ARG A 135      42.509  33.271  49.148  1.00 29.75           N  
ATOM    954  CA  ARG A 135      41.575  32.527  49.972  1.00 28.98           C  
ATOM    955  C   ARG A 135      40.170  33.097  49.915  1.00 29.97           C  
ATOM    956  O   ARG A 135      39.962  34.310  49.764  1.00 27.39           O  
ATOM    957  CB  ARG A 135      42.016  32.561  51.409  1.00 31.74           C  
ATOM    958  CG  ARG A 135      43.426  32.027  51.527  1.00 35.93           C  
ATOM    959  CD  ARG A 135      43.933  32.245  52.936  1.00 50.96           C  
ATOM    960  NE  ARG A 135      44.568  33.549  53.089  1.00 89.79           N  
ATOM    961  CZ  ARG A 135      45.139  34.009  54.204  1.00100.00           C  
ATOM    962  NH1 ARG A 135      45.158  33.309  55.347  1.00 82.71           N  
ATOM    963  NH2 ARG A 135      45.687  35.227  54.159  1.00 81.27           N  
ATOM    964  N   LEU A 136      39.229  32.175  50.055  1.00 27.27           N  
ATOM    965  CA  LEU A 136      37.795  32.469  50.052  1.00 28.89           C  
ATOM    966  C   LEU A 136      37.430  33.014  51.438  1.00 26.64           C  
ATOM    967  O   LEU A 136      37.390  32.279  52.416  1.00 24.74           O  
ATOM    968  CB  LEU A 136      36.945  31.207  49.658  1.00 25.85           C  
ATOM    969  CG  LEU A 136      35.447  31.508  49.518  1.00 22.97           C  
ATOM    970  CD1 LEU A 136      35.165  32.451  48.372  1.00 18.10           C  
ATOM    971  CD2 LEU A 136      34.650  30.239  49.280  1.00 23.96           C  
ATOM    972  N   CYS A 137      37.202  34.308  51.540  1.00 24.66           N  
ATOM    973  CA  CYS A 137      36.924  34.860  52.862  1.00 24.65           C  
ATOM    974  C   CYS A 137      35.451  34.997  53.149  1.00 28.22           C  
ATOM    975  O   CYS A 137      35.021  34.932  54.306  1.00 25.39           O  
ATOM    976  CB  CYS A 137      37.660  36.213  53.015  1.00 26.36           C  
ATOM    977  SG  CYS A 137      39.443  35.927  52.921  1.00 28.78           S  
ATOM    978  N   ALA A 138      34.710  35.196  52.053  1.00 26.24           N  
ATOM    979  CA  ALA A 138      33.277  35.330  52.142  1.00 27.38           C  
ATOM    980  C   ALA A 138      32.589  35.042  50.805  1.00 28.10           C  
ATOM    981  O   ALA A 138      33.214  35.114  49.746  1.00 23.36           O  
ATOM    982  CB  ALA A 138      32.907  36.711  52.672  1.00 27.83           C  
ATOM    983  N   VAL A 139      31.285  34.723  50.887  1.00 21.30           N  
ATOM    984  CA  VAL A 139      30.409  34.478  49.752  1.00 21.09           C  
ATOM    985  C   VAL A 139      29.098  35.201  49.969  1.00 26.35           C  
ATOM    986  O   VAL A 139      28.629  35.380  51.105  1.00 24.44           O  
ATOM    987  CB  VAL A 139      30.060  32.983  49.547  1.00 25.72           C  
ATOM    988  CG1 VAL A 139      31.263  32.213  49.005  1.00 24.64           C  
ATOM    989  CG2 VAL A 139      29.482  32.335  50.808  1.00 20.79           C  
ATOM    990  N   SER A 140      28.479  35.580  48.866  1.00 22.74           N  
ATOM    991  CA  SER A 140      27.196  36.231  48.957  1.00 21.53           C  
ATOM    992  C   SER A 140      26.294  35.683  47.881  1.00 28.46           C  
ATOM    993  O   SER A 140      26.682  35.629  46.677  1.00 23.29           O  
ATOM    994  CB  SER A 140      27.340  37.748  48.758  1.00 24.30           C  
ATOM    995  OG  SER A 140      26.108  38.432  48.655  1.00 26.59           O  
ATOM    996  N   SER A 141      25.089  35.323  48.310  1.00 20.36           N  
ATOM    997  CA  SER A 141      24.090  34.911  47.319  1.00 21.90           C  
ATOM    998  C   SER A 141      23.253  36.157  47.015  1.00 26.13           C  
ATOM    999  O   SER A 141      22.559  36.719  47.895  1.00 22.14           O  
ATOM   1000  CB  SER A 141      23.188  33.798  47.790  1.00 26.14           C  
ATOM   1001  OG  SER A 141      24.010  32.690  48.013  1.00 25.73           O  
ATOM   1002  N   MET A 142      23.320  36.623  45.773  1.00 18.84           N  
ATOM   1003  CA  MET A 142      22.596  37.844  45.504  1.00 20.04           C  
ATOM   1004  C   MET A 142      21.405  37.635  44.620  1.00 25.95           C  
ATOM   1005  O   MET A 142      21.527  37.054  43.546  1.00 26.51           O  
ATOM   1006  CB  MET A 142      23.555  38.842  44.800  1.00 22.49           C  
ATOM   1007  CG  MET A 142      24.652  39.402  45.703  1.00 23.11           C  
ATOM   1008  SD  MET A 142      23.951  40.523  46.951  1.00 24.68           S  
ATOM   1009  CE  MET A 142      22.623  41.384  46.037  1.00 17.81           C  
ATOM   1010  N   SER A 143      20.258  38.109  45.075  1.00 18.30           N  
ATOM   1011  CA  SER A 143      19.050  37.986  44.294  1.00 20.41           C  
ATOM   1012  C   SER A 143      18.664  39.386  43.868  1.00 26.45           C  
ATOM   1013  O   SER A 143      18.505  40.260  44.730  1.00 27.35           O  
ATOM   1014  CB  SER A 143      17.954  37.329  45.109  1.00 21.89           C  
ATOM   1015  OG  SER A 143      16.849  37.094  44.278  1.00 36.16           O  
ATOM   1016  N   ILE A 144      18.570  39.588  42.554  1.00 22.58           N  
ATOM   1017  CA  ILE A 144      18.259  40.888  41.984  1.00 23.31           C  
ATOM   1018  C   ILE A 144      16.889  40.948  41.356  1.00 28.74           C  
ATOM   1019  O   ILE A 144      16.620  40.161  40.453  1.00 26.33           O  
ATOM   1020  CB  ILE A 144      19.322  41.305  40.941  1.00 27.40           C  
ATOM   1021  CG1 ILE A 144      20.740  40.962  41.414  1.00 28.78           C  
ATOM   1022  CG2 ILE A 144      19.206  42.795  40.552  1.00 23.01           C  
ATOM   1023  CD1 ILE A 144      21.197  41.668  42.683  1.00 20.44           C  
ATOM   1024  N   ALA A 145      16.039  41.873  41.821  1.00 22.23           N  
ATOM   1025  CA  ALA A 145      14.721  41.995  41.194  1.00 25.34           C  
ATOM   1026  C   ALA A 145      14.851  42.754  39.874  1.00 28.59           C  
ATOM   1027  O   ALA A 145      15.586  43.750  39.789  1.00 30.48           O  
ATOM   1028  CB  ALA A 145      13.749  42.745  42.101  1.00 25.16           C  
ATOM   1029  N   VAL A 146      14.151  42.323  38.826  1.00 25.35           N  
ATOM   1030  CA  VAL A 146      14.271  43.056  37.574  1.00 24.39           C  
ATOM   1031  C   VAL A 146      12.913  43.549  37.221  1.00 34.27           C  
ATOM   1032  O   VAL A 146      11.978  42.736  37.251  1.00 30.98           O  
ATOM   1033  CB  VAL A 146      14.688  42.146  36.438  1.00 28.49           C  
ATOM   1034  CG1 VAL A 146      14.477  42.911  35.134  1.00 29.32           C  
ATOM   1035  CG2 VAL A 146      16.142  41.805  36.614  1.00 23.86           C  
ATOM   1036  N   ARG A 147      12.810  44.848  36.927  1.00 30.55           N  
ATOM   1037  CA  ARG A 147      11.514  45.387  36.610  1.00 29.92           C  
ATOM   1038  C   ARG A 147      11.649  46.516  35.625  1.00 41.31           C  
ATOM   1039  O   ARG A 147      12.720  47.062  35.371  1.00 42.86           O  
ATOM   1040  CB  ARG A 147      10.790  45.952  37.835  1.00 29.04           C  
ATOM   1041  CG  ARG A 147      10.746  45.064  39.100  1.00 29.92           C  
ATOM   1042  CD  ARG A 147       9.550  44.107  39.158  1.00 27.66           C  
ATOM   1043  NE  ARG A 147       9.346  43.320  40.396  1.00 33.89           N  
ATOM   1044  CZ  ARG A 147       9.995  42.178  40.730  1.00 30.82           C  
ATOM   1045  NH1 ARG A 147      10.950  41.653  39.945  1.00 28.56           N  
ATOM   1046  NH2 ARG A 147       9.693  41.549  41.892  1.00 27.69           N  
ATOM   1047  N   PRO A 148      10.516  46.876  35.077  1.00 46.38           N  
ATOM   1048  CA  PRO A 148      10.474  47.968  34.110  1.00 48.19           C  
ATOM   1049  C   PRO A 148      10.615  49.301  34.839  1.00 55.41           C  
ATOM   1050  O   PRO A 148       9.994  49.443  35.892  1.00 57.76           O  
ATOM   1051  CB  PRO A 148       9.096  47.854  33.453  1.00 50.07           C  
ATOM   1052  CG  PRO A 148       8.329  46.717  34.134  1.00 49.00           C  
ATOM   1053  CD  PRO A 148       9.248  46.095  35.168  1.00 43.21           C  
ATOM   1054  N   ARG A 149      11.438  50.248  34.312  1.00 56.79           N  
ATOM   1055  CA  ARG A 149      11.669  51.570  34.929  1.00 56.70           C  
ATOM   1056  C   ARG A 149      10.377  52.337  35.045  1.00 67.99           C  
ATOM   1057  O   ARG A 149       9.677  52.414  34.044  1.00 71.82           O  
ATOM   1058  CB  ARG A 149      12.591  52.376  34.052  1.00 46.78           C  
ATOM   1059  CG  ARG A 149      13.938  51.702  33.890  1.00 59.33           C  
ATOM   1060  CD  ARG A 149      15.074  52.687  34.070  1.00 69.07           C  
ATOM   1061  NE  ARG A 149      15.391  53.326  32.806  1.00 81.17           N  
ATOM   1062  CZ  ARG A 149      15.766  52.635  31.736  1.00 92.91           C  
ATOM   1063  NH1 ARG A 149      15.883  51.308  31.777  1.00 58.82           N  
ATOM   1064  NH2 ARG A 149      16.047  53.279  30.595  1.00 94.45           N  
ATOM   1065  N   ARG A 150      10.031  52.882  36.217  1.00 69.89           N  
ATOM   1066  CA  ARG A 150       8.757  53.605  36.296  1.00 75.38           C  
ATOM   1067  C   ARG A 150       8.738  54.838  35.392  1.00 93.55           C  
ATOM   1068  O   ARG A 150       7.684  55.342  34.926  1.00 99.11           O  
ATOM   1069  CB  ARG A 150       8.554  54.081  37.711  1.00 78.91           C  
ATOM   1070  CG  ARG A 150       8.581  52.933  38.675  1.00 87.92           C  
ATOM   1071  CD  ARG A 150       8.004  53.345  40.010  1.00 97.78           C  
ATOM   1072  NE  ARG A 150       7.123  52.325  40.566  1.00 69.73           N  
ATOM   1073  CZ  ARG A 150       6.586  52.363  41.783  1.00 83.46           C  
ATOM   1074  NH1 ARG A 150       6.788  53.385  42.622  1.00 67.89           N  
ATOM   1075  NH2 ARG A 150       5.811  51.336  42.152  1.00 70.26           N  
ATOM   1076  N   ASP A 151       9.981  55.301  35.198  1.00 91.32           N  
ATOM   1077  CA  ASP A 151      10.414  56.470  34.440  1.00 88.87           C  
ATOM   1078  C   ASP A 151      11.216  56.115  33.169  1.00100.00           C  
ATOM   1079  O   ASP A 151      10.614  55.987  32.056  1.00100.00           O  
ATOM   1080  CB  ASP A 151      11.262  57.365  35.398  1.00 91.07           C  
ATOM   1081  CG  ASP A 151      12.253  56.610  36.291  1.00100.00           C  
ATOM   1082  OD1 ASP A 151      12.726  55.480  36.031  1.00100.00           O  
ATOM   1083  OD2 ASP A 151      12.599  57.249  37.410  1.00100.00           O  
ATOM   1084  OXT ASP A 151      12.481  55.941  33.230  1.00100.00           O  
TER    1085      ASP A 151                                                      
END
MOLECULE T0479.pdb
ATOM      1  N   THR     6      34.108  56.591  39.835  1.00 82.67           N  
ATOM      2  CA  THR     6      32.687  57.041  39.783  1.00 84.71           C  
ATOM      3  C   THR     6      31.847  56.242  38.792  1.00 84.83           C  
ATOM      4  O   THR     6      30.746  55.797  39.120  1.00 87.33           O  
ATOM      5  CB  THR     6      32.594  58.552  39.443  1.00 84.63           C  
ATOM      6  OG1 THR     6      32.669  59.310  40.659  1.00 80.59           O  
ATOM      7  CG2 THR     6      31.288  58.884  38.714  1.00 85.06           C  
ATOM      8  N   ASP     7      32.357  56.052  37.583  1.00 82.92           N  
ATOM      9  CA  ASP     7      31.608  55.292  36.597  1.00 82.53           C  
ATOM     10  C   ASP     7      31.505  53.876  37.126  1.00 82.43           C  
ATOM     11  O   ASP     7      32.507  53.164  37.202  1.00 83.40           O  
ATOM     12  CB  ASP     7      32.337  55.281  35.254  1.00 83.34           C  
ATOM     13  CG  ASP     7      31.398  55.058  34.080  1.00 83.13           C  
ATOM     14  OD1 ASP     7      31.411  55.902  33.161  1.00 90.62           O  
ATOM     15  OD2 ASP     7      30.652  54.052  34.068  1.00 82.94           O  
ATOM     16  N   PHE     8      30.302  53.477  37.524  1.00 81.00           N  
ATOM     17  CA  PHE     8      30.095  52.129  38.022  1.00 78.25           C  
ATOM     18  C   PHE     8      29.206  51.420  37.035  1.00 78.12           C  
ATOM     19  O   PHE     8      27.993  51.364  37.192  1.00 78.37           O  
ATOM     20  CB  PHE     8      29.455  52.141  39.411  1.00 77.96           C  
ATOM     21  CG  PHE     8      30.418  52.466  40.517  1.00 75.33           C  
ATOM     22  CD1 PHE     8      30.264  53.616  41.272  1.00 73.58           C  
ATOM     23  CD2 PHE     8      31.496  51.628  40.791  1.00 69.75           C  
ATOM     24  CE1 PHE     8      31.172  53.932  42.287  1.00 72.35           C  
ATOM     25  CE2 PHE     8      32.404  51.929  41.799  1.00 67.03           C  
ATOM     26  CZ  PHE     8      32.243  53.085  42.549  1.00 69.31           C  
ATOM     27  N   PHE     9      29.835  50.909  35.989  1.00 79.06           N  
ATOM     28  CA  PHE     9      29.150  50.169  34.948  1.00 79.09           C  
ATOM     29  C   PHE     9      27.978  50.911  34.325  1.00 79.86           C  
ATOM     30  O   PHE     9      26.979  50.298  33.945  1.00 80.70           O  
ATOM     31  CB  PHE     9      28.690  48.836  35.517  1.00 79.01           C  
ATOM     32  CG  PHE     9      29.776  48.084  36.228  1.00 77.86           C  
ATOM     33  CD1 PHE     9      30.883  47.602  35.536  1.00 80.20           C  
ATOM     34  CD2 PHE     9      29.691  47.850  37.594  1.00 75.84           C  
ATOM     35  CE1 PHE     9      31.889  46.890  36.201  1.00 77.51           C  
ATOM     36  CE2 PHE     9      30.689  47.142  38.263  1.00 74.21           C  
ATOM     37  CZ  PHE     9      31.788  46.661  37.567  1.00 74.96           C  
ATOM     38  N   GLY    10      28.102  52.230  34.216  1.00 81.37           N  
ATOM     39  CA  GLY    10      27.041  53.016  33.610  1.00 81.99           C  
ATOM     40  C   GLY    10      26.223  53.898  34.534  1.00 82.45           C  
ATOM     41  O   GLY    10      25.148  54.363  34.148  1.00 83.24           O  
ATOM     42  N   LEU    11      26.724  54.138  35.742  1.00 81.84           N  
ATOM     43  CA  LEU    11      26.015  54.971  36.704  1.00 80.93           C  
ATOM     44  C   LEU    11      26.885  55.422  37.864  1.00 81.11           C  
ATOM     45  O   LEU    11      27.854  54.752  38.224  1.00 81.55           O  
ATOM     46  CB  LEU    11      24.792  54.226  37.245  1.00 82.16           C  
ATOM     47  CG  LEU    11      24.869  52.706  37.388  1.00 80.12           C  
ATOM     48  CD1 LEU    11      24.789  52.279  38.854  1.00 80.11           C  
ATOM     49  CD2 LEU    11      23.717  52.108  36.594  1.00 78.58           C  
ATOM     50  N   THR    12      26.541  56.567  38.444  1.00 81.94           N  
ATOM     51  CA  THR    12      27.287  57.083  39.583  1.00 81.54           C  
ATOM     52  C   THR    12      26.555  56.700  40.869  1.00 80.32           C  
ATOM     53  O   THR    12      25.343  56.884  40.994  1.00 80.81           O  
ATOM     54  CB  THR    12      27.491  58.640  39.490  1.00 82.25           C  
ATOM     55  OG1 THR    12      27.647  59.186  40.808  1.00 81.93           O  
ATOM     56  CG2 THR    12      26.328  59.308  38.779  1.00 80.77           C  
ATOM     57  N   ILE    13      27.311  56.133  41.803  1.00 78.25           N  
ATOM     58  CA  ILE    13      26.793  55.681  43.085  1.00 73.63           C  
ATOM     59  C   ILE    13      27.597  56.362  44.187  1.00 72.82           C  
ATOM     60  O   ILE    13      28.654  55.878  44.583  1.00 73.86           O  
ATOM     61  CB  ILE    13      26.945  54.157  43.209  1.00 72.50           C  
ATOM     62  CG1 ILE    13      26.386  53.476  41.959  1.00 70.72           C  
ATOM     63  CG2 ILE    13      26.218  53.660  44.444  1.00 69.64           C  
ATOM     64  CD1 ILE    13      26.615  51.973  41.912  1.00 66.94           C  
ATOM     65  N   PRO    14      27.097  57.496  44.701  1.00 71.54           N  
ATOM     66  CA  PRO    14      27.744  58.277  45.759  1.00 70.83           C  
ATOM     67  C   PRO    14      28.279  57.487  46.948  1.00 70.92           C  
ATOM     68  O   PRO    14      29.261  57.894  47.573  1.00 72.37           O  
ATOM     69  CB  PRO    14      26.659  59.259  46.170  1.00 70.62           C  
ATOM     70  CG  PRO    14      25.953  59.505  44.881  1.00 70.49           C  
ATOM     71  CD  PRO    14      25.818  58.114  44.315  1.00 70.58           C  
ATOM     72  N   PHE    15      27.644  56.369  47.277  1.00 70.30           N  
ATOM     73  CA  PHE    15      28.112  55.580  48.413  1.00 68.63           C  
ATOM     74  C   PHE    15      29.290  54.712  47.992  1.00 69.27           C  
ATOM     75  O   PHE    15      30.270  54.582  48.727  1.00 68.96           O  
ATOM     76  CB  PHE    15      26.985  54.703  48.979  1.00 66.76           C  
ATOM     77  CG  PHE    15      27.407  53.863  50.158  1.00 62.75           C  
ATOM     78  CD1 PHE    15      27.964  54.455  51.288  1.00 65.47           C  
ATOM     79  CD2 PHE    15      27.258  52.480  50.135  1.00 60.04           C  
ATOM     80  CE1 PHE    15      28.366  53.683  52.381  1.00 63.65           C  
ATOM     81  CE2 PHE    15      27.656  51.697  51.219  1.00 59.43           C  
ATOM     82  CZ  PHE    15      28.212  52.301  52.347  1.00 57.78           C  
ATOM     83  N   MET    16      29.191  54.120  46.806  1.00 68.50           N  
ATOM     84  CA  MET    16      30.266  53.276  46.314  1.00 69.92           C  
ATOM     85  C   MET    16      31.532  54.105  46.109  1.00 70.28           C  
ATOM     86  O   MET    16      32.628  53.687  46.484  1.00 69.63           O  
ATOM     87  CB  MET    16      29.843  52.593  45.012  1.00 68.25           C  
ATOM     88  CG  MET    16      28.836  51.462  45.210  1.00 71.30           C  
ATOM     89  SD  MET    16      29.518  49.996  46.318  1.00 82.26          SE  
ATOM     90  CE  MET    16      28.397  50.232  47.881  1.00 81.23           C  
ATOM     91  N   GLN    17      31.367  55.287  45.525  1.00 71.35           N  
ATOM     92  CA  GLN    17      32.486  56.187  45.280  1.00 73.14           C  
ATOM     93  C   GLN    17      33.152  56.495  46.615  1.00 72.71           C  
ATOM     94  O   GLN    17      34.353  56.744  46.677  1.00 72.94           O  
ATOM     95  CB  GLN    17      31.983  57.490  44.639  1.00 74.17           C  
ATOM     96  CG  GLN    17      33.075  58.494  44.271  1.00 78.87           C  
ATOM     97  CD  GLN    17      32.597  59.942  44.333  1.00 85.45           C  
ATOM     98  OE1 GLN    17      31.612  60.318  43.696  1.00 90.09           O  
ATOM     99  NE2 GLN    17      33.302  60.762  45.105  1.00 86.55           N  
ATOM    100  N   LEU    18      32.356  56.466  47.683  1.00 72.85           N  
ATOM    101  CA  LEU    18      32.837  56.759  49.032  1.00 71.27           C  
ATOM    102  C   LEU    18      33.668  55.626  49.622  1.00 71.30           C  
ATOM    103  O   LEU    18      34.567  55.862  50.431  1.00 70.93           O  
ATOM    104  CB  LEU    18      31.647  57.058  49.950  1.00 70.66           C  
ATOM    105  CG  LEU    18      31.844  57.860  51.244  1.00 69.80           C  
ATOM    106  CD1 LEU    18      31.930  56.948  52.446  1.00 73.18           C  
ATOM    107  CD2 LEU    18      33.078  58.730  51.117  1.00 67.63           C  
ATOM    108  N   LEU    19      33.362  54.396  49.214  1.00 71.25           N  
ATOM    109  CA  LEU    19      34.081  53.224  49.701  1.00 71.47           C  
ATOM    110  C   LEU    19      35.415  53.043  48.998  1.00 73.05           C  
ATOM    111  O   LEU    19      36.224  52.201  49.390  1.00 73.88           O  
ATOM    112  CB  LEU    19      33.246  51.963  49.496  1.00 70.20           C  
ATOM    113  CG  LEU    19      32.009  51.732  50.363  1.00 69.28           C  
ATOM    114  CD1 LEU    19      31.332  50.437  49.937  1.00 64.95           C  
ATOM    115  CD2 LEU    19      32.405  51.662  51.830  1.00 66.56           C  
ATOM    116  N   GLY    20      35.643  53.827  47.951  1.00 74.73           N  
ATOM    117  CA  GLY    20      36.885  53.704  47.211  1.00 75.28           C  
ATOM    118  C   GLY    20      36.969  52.336  46.555  1.00 76.69           C  
ATOM    119  O   GLY    20      37.965  51.628  46.709  1.00 76.35           O  
ATOM    120  N   VAL    21      35.913  51.954  45.839  1.00 75.90           N  
ATOM    121  CA  VAL    21      35.890  50.665  45.161  1.00 74.91           C  
ATOM    122  C   VAL    21      36.060  50.871  43.656  1.00 74.23           C  
ATOM    123  O   VAL    21      35.609  51.876  43.102  1.00 74.26           O  
ATOM    124  CB  VAL    21      34.569  49.882  45.455  1.00 75.48           C  
ATOM    125  CG1 VAL    21      33.353  50.705  45.059  1.00 75.56           C  
ATOM    126  CG2 VAL    21      34.576  48.554  44.708  1.00 75.52           C  
ATOM    127  N   VAL    22      36.712  49.920  42.997  1.00 73.26           N  
ATOM    128  CA  VAL    22      36.955  50.026  41.563  1.00 71.22           C  
ATOM    129  C   VAL    22      36.297  48.933  40.714  1.00 69.51           C  
ATOM    130  O   VAL    22      36.493  47.745  40.956  1.00 69.28           O  
ATOM    131  CB  VAL    22      38.481  50.019  41.277  1.00 71.44           C  
ATOM    132  CG1 VAL    22      38.734  50.139  39.788  1.00 72.67           C  
ATOM    133  CG2 VAL    22      39.153  51.152  42.024  1.00 68.35           C  
ATOM    134  N   PRO    23      35.488  49.332  39.713  1.00 68.68           N  
ATOM    135  CA  PRO    23      34.795  48.412  38.803  1.00 69.35           C  
ATOM    136  C   PRO    23      35.821  47.787  37.856  1.00 70.07           C  
ATOM    137  O   PRO    23      36.584  48.493  37.208  1.00 70.33           O  
ATOM    138  CB  PRO    23      33.787  49.320  38.085  1.00 68.77           C  
ATOM    139  CG  PRO    23      34.445  50.640  38.103  1.00 69.37           C  
ATOM    140  CD  PRO    23      35.035  50.715  39.491  1.00 68.21           C  
ATOM    141  N   GLU    24      35.827  46.463  37.774  1.00 71.08           N  
ATOM    142  CA  GLU    24      36.811  45.762  36.956  1.00 71.52           C  
ATOM    143  C   GLU    24      36.266  45.026  35.724  1.00 71.28           C  
ATOM    144  O   GLU    24      37.016  44.737  34.787  1.00 72.41           O  
ATOM    145  CB  GLU    24      37.571  44.789  37.863  1.00 71.19           C  
ATOM    146  CG  GLU    24      39.055  44.645  37.574  1.00 74.13           C  
ATOM    147  CD  GLU    24      39.917  44.750  38.828  1.00 77.25           C  
ATOM    148  OE1 GLU    24      40.224  45.885  39.255  1.00 83.15           O  
ATOM    149  OE2 GLU    24      40.295  43.699  39.387  1.00 77.85           O  
ATOM    150  N   HIS    25      34.967  44.735  35.719  1.00 70.76           N  
ATOM    151  CA  HIS    25      34.342  44.017  34.613  1.00 68.54           C  
ATOM    152  C   HIS    25      32.855  43.809  34.849  1.00 68.40           C  
ATOM    153  O   HIS    25      32.388  43.788  35.984  1.00 69.03           O  
ATOM    154  CB  HIS    25      35.002  42.646  34.430  1.00 67.13           C  
ATOM    155  CG  HIS    25      34.233  41.710  33.551  1.00 66.67           C  
ATOM    156  ND1 HIS    25      34.002  40.394  33.883  1.00 64.69           N  
ATOM    157  CD2 HIS    25      33.623  41.902  32.352  1.00 67.64           C  
ATOM    158  CE1 HIS    25      33.284  39.814  32.935  1.00 66.58           C  
ATOM    159  NE2 HIS    25      33.043  40.713  31.996  1.00 67.15           N  
ATOM    160  N   SER    26      32.122  43.645  33.755  1.00 68.39           N  
ATOM    161  CA  SER    26      30.692  43.402  33.785  1.00 67.02           C  
ATOM    162  C   SER    26      30.240  43.026  32.388  1.00 66.04           C  
ATOM    163  O   SER    26      30.387  43.804  31.449  1.00 68.32           O  
ATOM    164  CB  SER    26      29.936  44.647  34.243  1.00 68.40           C  
ATOM    165  OG  SER    26      28.563  44.537  33.896  1.00 69.94           O  
ATOM    166  N   GLY    27      29.690  41.828  32.252  1.00 63.41           N  
ATOM    167  CA  GLY    27      29.224  41.394  30.954  1.00 59.63           C  
ATOM    168  C   GLY    27      29.182  39.889  30.902  1.00 57.60           C  
ATOM    169  O   GLY    27      29.900  39.221  31.635  1.00 59.65           O  
ATOM    170  N   ASN    28      28.337  39.354  30.032  1.00 58.55           N  
ATOM    171  CA  ASN    28      28.200  37.912  29.878  1.00 59.88           C  
ATOM    172  C   ASN    28      27.865  37.168  31.165  1.00 60.45           C  
ATOM    173  O   ASN    28      28.385  36.085  31.409  1.00 58.08           O  
ATOM    174  CB  ASN    28      29.481  37.352  29.275  1.00 61.54           C  
ATOM    175  CG  ASN    28      29.808  37.982  27.943  1.00 59.96           C  
ATOM    176  OD1 ASN    28      29.020  37.900  27.004  1.00 57.88           O  
ATOM    177  ND2 ASN    28      30.971  38.636  27.858  1.00 52.70           N  
ATOM    178  N   GLY    29      27.005  37.764  31.984  1.00 58.42           N  
ATOM    179  CA  GLY    29      26.598  37.118  33.217  1.00 59.39           C  
ATOM    180  C   GLY    29      27.591  37.028  34.362  1.00 58.49           C  
ATOM    181  O   GLY    29      27.400  36.212  35.263  1.00 58.96           O  
ATOM    182  N   THR    30      28.647  37.836  34.339  1.00 55.83           N  
ATOM    183  CA  THR    30      29.626  37.818  35.419  1.00 55.20           C  
ATOM    184  C   THR    30      30.039  39.253  35.687  1.00 54.78           C  
ATOM    185  O   THR    30      29.687  40.152  34.930  1.00 56.63           O  
ATOM    186  CB  THR    30      30.904  37.026  35.054  1.00 55.53           C  
ATOM    187  OG1 THR    30      31.572  37.684  33.977  1.00 59.89           O  
ATOM    188  CG2 THR    30      30.580  35.605  34.655  1.00 55.82           C  
ATOM    189  N   ALA    31      30.784  39.474  36.764  1.00 51.78           N  
ATOM    190  CA  ALA    31      31.237  40.818  37.076  1.00 52.61           C  
ATOM    191  C   ALA    31      32.450  40.790  38.010  1.00 53.18           C  
ATOM    192  O   ALA    31      32.691  39.810  38.709  1.00 52.70           O  
ATOM    193  CB  ALA    31      30.097  41.623  37.693  1.00 51.77           C  
ATOM    194  N   ARG    32      33.225  41.869  38.002  1.00 53.91           N  
ATOM    195  CA  ARG    32      34.407  41.932  38.849  1.00 55.41           C  
ATOM    196  C   ARG    32      34.550  43.326  39.411  1.00 54.45           C  
ATOM    197  O   ARG    32      34.304  44.324  38.727  1.00 51.64           O  
ATOM    198  CB  ARG    32      35.682  41.577  38.061  1.00 56.29           C  
ATOM    199  CG  ARG    32      36.710  40.769  38.870  1.00 60.83           C  
ATOM    200  CD  ARG    32      38.165  41.219  38.659  1.00 68.82           C  
ATOM    201  NE  ARG    32      38.433  41.696  37.302  1.00 67.14           N  
ATOM    202  CZ  ARG    32      38.391  40.946  36.205  1.00 66.56           C  
ATOM    203  NH1 ARG    32      38.096  39.654  36.281  1.00 67.50           N  
ATOM    204  NH2 ARG    32      38.623  41.502  35.025  1.00 69.78           N  
ATOM    205  N   THR    33      34.960  43.386  40.667  1.00 54.04           N  
ATOM    206  CA  THR    33      35.150  44.655  41.328  1.00 54.88           C  
ATOM    207  C   THR    33      36.340  44.494  42.275  1.00 55.51           C  
ATOM    208  O   THR    33      36.741  43.371  42.579  1.00 52.87           O  
ATOM    209  CB  THR    33      33.852  45.066  42.075  1.00 55.35           C  
ATOM    210  OG1 THR    33      33.558  46.442  41.790  1.00 60.23           O  
ATOM    211  CG2 THR    33      33.996  44.881  43.573  1.00 52.69           C  
ATOM    212  N   ARG    34      36.904  45.603  42.744  1.00 58.33           N  
ATOM    213  CA  ARG    34      38.070  45.520  43.620  1.00 61.57           C  
ATOM    214  C   ARG    34      38.011  46.499  44.783  1.00 61.13           C  
ATOM    215  O   ARG    34      37.666  47.668  44.602  1.00 62.13           O  
ATOM    216  CB  ARG    34      39.332  45.759  42.779  1.00 63.11           C  
ATOM    217  CG  ARG    34      40.654  45.547  43.495  1.00 67.81           C  
ATOM    218  CD  ARG    34      41.235  46.851  44.018  1.00 80.63           C  
ATOM    219  NE  ARG    34      42.681  46.919  43.799  1.00 88.82           N  
ATOM    220  CZ  ARG    34      43.252  46.975  42.600  1.00 92.25           C  
ATOM    221  NH1 ARG    34      42.495  46.976  41.508  1.00 90.51           N  
ATOM    222  NH2 ARG    34      44.577  47.025  42.491  1.00 94.91           N  
ATOM    223  N   LEU    35      38.362  46.027  45.976  1.00 60.79           N  
ATOM    224  CA  LEU    35      38.335  46.890  47.153  1.00 61.51           C  
ATOM    225  C   LEU    35      39.714  47.210  47.733  1.00 62.84           C  
ATOM    226  O   LEU    35      40.231  46.501  48.599  1.00 62.23           O  
ATOM    227  CB  LEU    35      37.448  46.280  48.255  1.00 59.96           C  
ATOM    228  CG  LEU    35      37.249  47.164  49.495  1.00 60.64           C  
ATOM    229  CD1 LEU    35      36.531  48.452  49.101  1.00 59.80           C  
ATOM    230  CD2 LEU    35      36.457  46.414  50.561  1.00 58.70           C  
ATOM    231  N   PRO    36      40.331  48.295  47.251  1.00 65.05           N  
ATOM    232  CA  PRO    36      41.650  48.673  47.763  1.00 67.72           C  
ATOM    233  C   PRO    36      41.585  48.959  49.265  1.00 70.63           C  
ATOM    234  O   PRO    36      40.669  49.627  49.738  1.00 71.74           O  
ATOM    235  CB  PRO    36      42.014  49.907  46.923  1.00 67.73           C  
ATOM    236  CG  PRO    36      40.688  50.407  46.404  1.00 66.37           C  
ATOM    237  CD  PRO    36      39.927  49.153  46.126  1.00 64.71           C  
ATOM    238  N   ALA    37      42.554  48.433  50.005  1.00 72.73           N  
ATOM    239  CA  ALA    37      42.600  48.610  51.448  1.00 74.97           C  
ATOM    240  C   ALA    37      42.575  50.073  51.880  1.00 78.06           C  
ATOM    241  O   ALA    37      43.148  50.945  51.224  1.00 79.38           O  
ATOM    242  CB  ALA    37      43.831  47.931  52.011  1.00 75.09           C  
ATOM    243  N   ARG    38      41.900  50.325  52.996  1.00 79.16           N  
ATOM    244  CA  ARG    38      41.790  51.660  53.563  1.00 78.26           C  
ATOM    245  C   ARG    38      41.540  51.448  55.042  1.00 77.89           C  
ATOM    246  O   ARG    38      41.137  50.362  55.451  1.00 78.49           O  
ATOM    247  CB  ARG    38      40.625  52.421  52.930  1.00 77.89           C  
ATOM    248  CG  ARG    38      40.756  53.926  53.029  1.00 79.53           C  
ATOM    249  CD  ARG    38      40.565  54.586  51.666  1.00 82.14           C  
ATOM    250  NE  ARG    38      39.190  54.513  51.173  1.00 81.39           N  
ATOM    251  CZ  ARG    38      38.162  55.157  51.718  1.00 84.11           C  
ATOM    252  NH1 ARG    38      38.346  55.925  52.782  1.00 89.00           N  
ATOM    253  NH2 ARG    38      36.949  55.048  51.192  1.00 82.94           N  
ATOM    254  N   ALA    39      41.789  52.471  55.843  1.00 78.61           N  
ATOM    255  CA  ALA    39      41.587  52.371  57.281  1.00 78.25           C  
ATOM    256  C   ALA    39      40.191  52.864  57.650  1.00 77.22           C  
ATOM    257  O   ALA    39      39.693  52.599  58.737  1.00 76.90           O  
ATOM    258  CB  ALA    39      42.655  53.188  58.002  1.00 79.37           C  
ATOM    259  N   ASP    40      39.573  53.583  56.716  1.00 77.54           N  
ATOM    260  CA  ASP    40      38.217  54.117  56.874  1.00 77.22           C  
ATOM    261  C   ASP    40      37.272  52.931  56.852  1.00 76.30           C  
ATOM    262  O   ASP    40      36.191  52.953  57.435  1.00 76.53           O  
ATOM    263  CB  ASP    40      37.834  54.985  55.677  1.00 77.80           C  
ATOM    264  CG  ASP    40      38.088  56.456  55.898  1.00 85.99           C  
ATOM    265  OD1 ASP    40      39.237  56.832  56.212  1.00 98.38           O  
ATOM    266  OD2 ASP    40      37.132  57.245  55.730  1.00 90.77           O  
ATOM    267  N   LEU    41      37.705  51.895  56.151  1.00 75.06           N  
ATOM    268  CA  LEU    41      36.892  50.708  55.945  1.00 72.63           C  
ATOM    269  C   LEU    41      37.057  49.515  56.884  1.00 71.44           C  
ATOM    270  O   LEU    41      36.544  48.441  56.592  1.00 70.58           O  
ATOM    271  CB  LEU    41      37.106  50.251  54.505  1.00 71.79           C  
ATOM    272  CG  LEU    41      37.033  51.397  53.492  1.00 68.81           C  
ATOM    273  CD1 LEU    41      37.246  50.882  52.077  1.00 64.95           C  
ATOM    274  CD2 LEU    41      35.679  52.077  53.620  1.00 69.58           C  
ATOM    275  N   VAL    42      37.726  49.703  58.018  1.00 71.99           N  
ATOM    276  CA  VAL    42      37.962  48.591  58.931  1.00 72.06           C  
ATOM    277  C   VAL    42      37.052  48.400  60.152  1.00 73.10           C  
ATOM    278  O   VAL    42      36.355  49.307  60.612  1.00 73.13           O  
ATOM    279  CB  VAL    42      39.415  48.608  59.414  1.00 72.55           C  
ATOM    280  CG1 VAL    42      40.361  48.501  58.217  1.00 71.29           C  
ATOM    281  CG2 VAL    42      39.678  49.895  60.186  1.00 74.55           C  
ATOM    282  N   ASN    43      37.100  47.174  60.660  1.00 73.75           N  
ATOM    283  CA  ASN    43      36.350  46.720  61.813  1.00 73.70           C  
ATOM    284  C   ASN    43      37.045  47.260  63.050  1.00 75.36           C  
ATOM    285  O   ASN    43      37.844  48.190  62.959  1.00 75.86           O  
ATOM    286  CB  ASN    43      36.381  45.198  61.840  1.00 73.88           C  
ATOM    287  CG  ASN    43      35.532  44.622  62.932  1.00 76.44           C  
ATOM    288  OD1 ASN    43      35.791  43.522  63.420  1.00 79.26           O  
ATOM    289  ND2 ASN    43      34.499  45.351  63.318  1.00 79.28           N  
ATOM    290  N   SER    44      36.739  46.673  64.203  1.00 76.37           N  
ATOM    291  CA  SER    44      37.373  47.063  65.452  1.00 76.63           C  
ATOM    292  C   SER    44      38.514  46.077  65.656  1.00 77.43           C  
ATOM    293  O   SER    44      39.480  46.368  66.354  1.00 77.64           O  
ATOM    294  CB  SER    44      36.383  46.991  66.626  1.00 76.83           C  
ATOM    295  OG  SER    44      35.894  45.674  66.832  1.00 76.34           O  
ATOM    296  N   ARG    45      38.392  44.904  65.036  1.00 77.30           N  
ATOM    297  CA  ARG    45      39.433  43.875  65.118  1.00 76.19           C  
ATOM    298  C   ARG    45      40.462  44.192  64.038  1.00 73.76           C  
ATOM    299  O   ARG    45      41.314  43.367  63.710  1.00 75.30           O  
ATOM    300  CB  ARG    45      38.855  42.474  64.863  1.00 77.62           C  
ATOM    301  CG  ARG    45      37.828  41.992  65.884  1.00 82.48           C  
ATOM    302  CD  ARG    45      38.476  41.651  67.218  1.00 89.78           C  
ATOM    303  NE  ARG    45      39.206  40.385  67.175  1.00 94.62           N  
ATOM    304  CZ  ARG    45      40.475  40.232  67.546  1.00 94.99           C  
ATOM    305  NH1 ARG    45      41.173  41.271  67.991  1.00 94.14           N  
ATOM    306  NH2 ARG    45      41.045  39.035  67.474  1.00 94.64           N  
ATOM    307  N   GLY    46      40.366  45.394  63.480  1.00 71.52           N  
ATOM    308  CA  GLY    46      41.294  45.803  62.441  1.00 69.47           C  
ATOM    309  C   GLY    46      40.961  45.261  61.065  1.00 69.13           C  
ATOM    310  O   GLY    46      41.449  45.783  60.068  1.00 70.07           O  
ATOM    311  N   ASP    47      40.134  44.215  61.018  1.00 68.65           N  
ATOM    312  CA  ASP    47      39.722  43.582  59.760  1.00 66.23           C  
ATOM    313  C   ASP    47      38.785  44.479  58.971  1.00 65.33           C  
ATOM    314  O   ASP    47      38.190  45.397  59.522  1.00 66.99           O  
ATOM    315  CB  ASP    47      38.988  42.269  60.021  1.00 65.80           C  
ATOM    316  CG  ASP    47      39.787  41.304  60.856  1.00 65.95           C  
ATOM    317  OD1 ASP    47      41.015  41.207  60.634  1.00 62.58           O  
ATOM    318  OD2 ASP    47      39.174  40.625  61.720  1.00 64.21           O  
ATOM    319  N   ILE    48      38.643  44.207  57.679  1.00 63.90           N  
ATOM    320  CA  ILE    48      37.734  44.994  56.859  1.00 63.50           C  
ATOM    321  C   ILE    48      36.328  44.661  57.367  1.00 62.00           C  
ATOM    322  O   ILE    48      35.976  43.489  57.484  1.00 61.57           O  
ATOM    323  CB  ILE    48      37.863  44.625  55.362  1.00 63.31           C  
ATOM    324  CG1 ILE    48      39.299  44.867  54.879  1.00 65.41           C  
ATOM    325  CG2 ILE    48      36.910  45.476  54.528  1.00 61.38           C  
ATOM    326  CD1 ILE    48      39.634  46.327  54.571  1.00 65.73           C  
ATOM    327  N   HIS    49      35.538  45.690  57.683  1.00 60.23           N  
ATOM    328  CA  HIS    49      34.170  45.510  58.203  1.00 57.44           C  
ATOM    329  C   HIS    49      33.256  44.751  57.240  1.00 54.86           C  
ATOM    330  O   HIS    49      33.157  45.102  56.068  1.00 54.28           O  
ATOM    331  CB  HIS    49      33.552  46.876  58.544  1.00 56.59           C  
ATOM    332  CG  HIS    49      32.349  46.792  59.433  1.00 56.51           C  
ATOM    333  ND1 HIS    49      31.101  46.436  58.975  1.00 58.06           N  
ATOM    334  CD2 HIS    49      32.216  46.972  60.772  1.00 61.56           C  
ATOM    335  CE1 HIS    49      30.251  46.396  59.986  1.00 60.97           C  
ATOM    336  NE2 HIS    49      30.905  46.718  61.088  1.00 65.28           N  
ATOM    337  N   GLY    50      32.595  43.716  57.755  1.00 54.28           N  
ATOM    338  CA  GLY    50      31.695  42.898  56.953  1.00 55.82           C  
ATOM    339  C   GLY    50      30.656  43.682  56.173  1.00 54.65           C  
ATOM    340  O   GLY    50      30.128  43.208  55.164  1.00 55.18           O  
ATOM    341  N   GLY    51      30.357  44.883  56.655  1.00 54.63           N  
ATOM    342  CA  GLY    51      29.398  45.719  55.981  1.00 55.34           C  
ATOM    343  C   GLY    51      30.061  46.240  54.732  1.00 57.54           C  
ATOM    344  O   GLY    51      29.413  46.409  53.698  1.00 58.76           O  
ATOM    345  N   THR    52      31.360  46.505  54.826  1.00 56.93           N  
ATOM    346  CA  THR    52      32.106  46.994  53.672  1.00 57.73           C  
ATOM    347  C   THR    52      32.002  45.906  52.619  1.00 55.49           C  
ATOM    348  O   THR    52      31.862  46.185  51.438  1.00 57.15           O  
ATOM    349  CB  THR    52      33.609  47.206  53.980  1.00 59.07           C  
ATOM    350  OG1 THR    52      33.767  47.832  55.261  1.00 64.70           O  
ATOM    351  CG2 THR    52      34.239  48.102  52.924  1.00 58.87           C  
ATOM    352  N   LEU    53      32.051  44.658  53.070  1.00 54.28           N  
ATOM    353  CA  LEU    53      31.973  43.510  52.177  1.00 54.38           C  
ATOM    354  C   LEU    53      30.628  43.370  51.465  1.00 55.08           C  
ATOM    355  O   LEU    53      30.581  43.246  50.238  1.00 56.03           O  
ATOM    356  CB  LEU    53      32.288  42.239  52.961  1.00 54.43           C  
ATOM    357  CG  LEU    53      33.572  42.304  53.795  1.00 52.99           C  
ATOM    358  CD1 LEU    53      33.880  40.929  54.383  1.00 55.86           C  
ATOM    359  CD2 LEU    53      34.726  42.774  52.925  1.00 55.19           C  
ATOM    360  N   MET    54      29.541  43.384  52.236  1.00 54.80           N  
ATOM    361  CA  MET    54      28.196  43.260  51.675  1.00 52.43           C  
ATOM    362  C   MET    54      27.894  44.435  50.724  1.00 52.03           C  
ATOM    363  O   MET    54      27.197  44.277  49.717  1.00 48.73           O  
ATOM    364  CB  MET    54      27.156  43.206  52.810  1.00 52.54           C  
ATOM    365  CG  MET    54      27.322  42.027  53.796  1.00 57.30           C  
ATOM    366  SD  MET    54      26.081  42.067  55.318  1.00 62.48          SE  
ATOM    367  CE  MET    54      25.966  40.226  55.821  1.00 55.10           C  
ATOM    368  N   SER    55      28.438  45.609  51.036  1.00 53.67           N  
ATOM    369  CA  SER    55      28.202  46.791  50.202  1.00 55.48           C  
ATOM    370  C   SER    55      28.807  46.581  48.826  1.00 56.00           C  
ATOM    371  O   SER    55      28.170  46.835  47.805  1.00 52.23           O  
ATOM    372  CB  SER    55      28.831  48.041  50.829  1.00 53.38           C  
ATOM    373  OG  SER    55      28.419  48.209  52.174  1.00 55.87           O  
ATOM    374  N   VAL    56      30.047  46.109  48.807  1.00 57.92           N  
ATOM    375  CA  VAL    56      30.719  45.889  47.547  1.00 57.30           C  
ATOM    376  C   VAL    56      30.127  44.653  46.873  1.00 57.04           C  
ATOM    377  O   VAL    56      30.051  44.578  45.648  1.00 58.85           O  
ATOM    378  CB  VAL    56      32.257  45.762  47.761  1.00 57.64           C  
ATOM    379  CG1 VAL    56      32.630  44.379  48.254  1.00 55.71           C  
ATOM    380  CG2 VAL    56      32.981  46.111  46.492  1.00 58.95           C  
ATOM    381  N   LEU    57      29.675  43.694  47.676  1.00 57.70           N  
ATOM    382  CA  LEU    57      29.079  42.484  47.127  1.00 57.43           C  
ATOM    383  C   LEU    57      27.716  42.797  46.524  1.00 58.80           C  
ATOM    384  O   LEU    57      27.326  42.216  45.516  1.00 60.67           O  
ATOM    385  CB  LEU    57      28.945  41.418  48.217  1.00 57.54           C  
ATOM    386  CG  LEU    57      30.007  40.319  48.211  1.00 55.85           C  
ATOM    387  CD1 LEU    57      29.865  39.434  49.442  1.00 48.35           C  
ATOM    388  CD2 LEU    57      29.846  39.493  46.940  1.00 48.05           C  
ATOM    389  N   ASP    58      26.994  43.728  47.139  1.00 58.06           N  
ATOM    390  CA  ASP    58      25.681  44.110  46.639  1.00 59.20           C  
ATOM    391  C   ASP    58      25.877  44.738  45.273  1.00 57.88           C  
ATOM    392  O   ASP    58      25.250  44.358  44.288  1.00 58.06           O  
ATOM    393  CB  ASP    58      25.027  45.123  47.585  1.00 60.09           C  
ATOM    394  CG  ASP    58      23.591  45.424  47.210  1.00 60.92           C  
ATOM    395  OD1 ASP    58      23.009  44.637  46.434  1.00 64.05           O  
ATOM    396  OD2 ASP    58      23.040  46.430  47.701  1.00 63.82           O  
ATOM    397  N   PHE    59      26.770  45.715  45.241  1.00 59.00           N  
ATOM    398  CA  PHE    59      27.117  46.424  44.024  1.00 59.42           C  
ATOM    399  C   PHE    59      27.459  45.465  42.876  1.00 58.46           C  
ATOM    400  O   PHE    59      26.895  45.545  41.786  1.00 59.38           O  
ATOM    401  CB  PHE    59      28.309  47.339  44.319  1.00 60.78           C  
ATOM    402  CG  PHE    59      28.934  47.934  43.095  1.00 69.86           C  
ATOM    403  CD1 PHE    59      28.140  48.503  42.108  1.00 72.66           C  
ATOM    404  CD2 PHE    59      30.314  47.908  42.921  1.00 75.70           C  
ATOM    405  CE1 PHE    59      28.704  49.034  40.960  1.00 84.13           C  
ATOM    406  CE2 PHE    59      30.892  48.439  41.777  1.00 85.16           C  
ATOM    407  CZ  PHE    59      30.082  49.004  40.791  1.00 89.23           C  
ATOM    408  N   THR    60      28.375  44.543  43.147  1.00 57.19           N  
ATOM    409  CA  THR    60      28.852  43.592  42.152  1.00 55.36           C  
ATOM    410  C   THR    60      27.902  42.472  41.730  1.00 55.78           C  
ATOM    411  O   THR    60      28.014  41.949  40.625  1.00 56.93           O  
ATOM    412  CB  THR    60      30.174  42.972  42.627  1.00 54.97           C  
ATOM    413  OG1 THR    60      31.009  44.011  43.157  1.00 51.98           O  
ATOM    414  CG2 THR    60      30.902  42.282  41.454  1.00 50.54           C  
ATOM    415  N   LEU    61      26.978  42.091  42.601  1.00 54.16           N  
ATOM    416  CA  LEU    61      26.039  41.039  42.254  1.00 53.20           C  
ATOM    417  C   LEU    61      25.080  41.575  41.195  1.00 53.73           C  
ATOM    418  O   LEU    61      24.756  40.893  40.222  1.00 52.67           O  
ATOM    419  CB  LEU    61      25.279  40.571  43.504  1.00 52.15           C  
ATOM    420  CG  LEU    61      26.060  39.700  44.497  1.00 50.32           C  
ATOM    421  CD1 LEU    61      25.558  39.942  45.918  1.00 49.21           C  
ATOM    422  CD2 LEU    61      25.916  38.227  44.122  1.00 47.40           C  
ATOM    423  N   GLY    62      24.633  42.808  41.379  1.00 55.99           N  
ATOM    424  CA  GLY    62      23.719  43.392  40.417  1.00 59.26           C  
ATOM    425  C   GLY    62      24.385  43.577  39.065  1.00 60.09           C  
ATOM    426  O   GLY    62      23.770  43.381  38.018  1.00 61.11           O  
ATOM    427  N   ALA    63      25.659  43.950  39.095  1.00 60.63           N  
ATOM    428  CA  ALA    63      26.419  44.172  37.873  1.00 61.18           C  
ATOM    429  C   ALA    63      26.460  42.954  36.957  1.00 60.04           C  
ATOM    430  O   ALA    63      26.575  43.105  35.750  1.00 61.51           O  
ATOM    431  CB  ALA    63      27.832  44.617  38.219  1.00 61.48           C  
ATOM    432  N   ALA    64      26.374  41.752  37.518  1.00 59.72           N  
ATOM    433  CA  ALA    64      26.404  40.539  36.700  1.00 59.00           C  
ATOM    434  C   ALA    64      25.120  40.380  35.901  1.00 61.13           C  
ATOM    435  O   ALA    64      25.025  39.523  35.024  1.00 60.65           O  
ATOM    436  CB  ALA    64      26.618  39.321  37.568  1.00 57.86           C  
ATOM    437  N   ILE    65      24.122  41.196  36.221  1.00 63.34           N  
ATOM    438  CA  ILE    65      22.853  41.143  35.506  1.00 64.35           C  
ATOM    439  C   ILE    65      22.854  42.255  34.466  1.00 65.13           C  
ATOM    440  O   ILE    65      22.716  41.997  33.278  1.00 63.47           O  
ATOM    441  CB  ILE    65      21.633  41.375  36.431  1.00 64.03           C  
ATOM    442  CG1 ILE    65      21.603  40.354  37.561  1.00 61.72           C  
ATOM    443  CG2 ILE    65      20.343  41.247  35.626  1.00 64.35           C  
ATOM    444  CD1 ILE    65      20.632  40.736  38.678  1.00 58.41           C  
ATOM    445  N   ARG    66      23.034  43.498  34.908  1.00 65.61           N  
ATOM    446  CA  ARG    66      22.991  44.625  33.971  1.00 66.75           C  
ATOM    447  C   ARG    66      24.286  45.044  33.265  1.00 65.81           C  
ATOM    448  O   ARG    66      24.657  46.225  33.243  1.00 67.92           O  
ATOM    449  CB  ARG    66      22.348  45.832  34.650  1.00 67.01           C  
ATOM    450  CG  ARG    66      22.930  46.224  35.983  1.00 70.89           C  
ATOM    451  CD  ARG    66      22.388  47.577  36.376  1.00 79.03           C  
ATOM    452  NE  ARG    66      22.696  48.583  35.361  1.00 84.60           N  
ATOM    453  CZ  ARG    66      23.885  49.155  35.206  1.00 86.35           C  
ATOM    454  NH1 ARG    66      24.893  48.825  36.008  1.00 83.77           N  
ATOM    455  NH2 ARG    66      24.062  50.059  34.249  1.00 83.22           N  
ATOM    456  N   GLY    67      24.948  44.056  32.671  1.00 61.55           N  
ATOM    457  CA  GLY    67      26.180  44.278  31.929  1.00 63.66           C  
ATOM    458  C   GLY    67      25.815  43.701  30.583  1.00 65.46           C  
ATOM    459  O   GLY    67      26.284  44.135  29.526  1.00 66.44           O  
ATOM    460  N   ASP    68      24.954  42.686  30.653  1.00 33.74           N  
ATOM    461  CA  ASP    68      24.422  42.009  29.472  1.00 33.21           C  
ATOM    462  C   ASP    68      23.369  42.986  28.987  1.00 36.28           C  
ATOM    463  O   ASP    68      22.870  42.874  27.855  1.00 71.16           O  
ATOM    464  CB  ASP    68      23.781  40.681  29.867  1.00 30.38           C  
ATOM    465  CG  ASP    68      24.819  39.640  30.230  1.00 34.25           C  
ATOM    466  OD1 ASP    68      26.007  39.875  29.876  1.00 35.02           O  
ATOM    467  OD2 ASP    68      24.481  38.589  30.842  1.00 33.10           O  
ATOM    468  N   THR    69      23.038  43.948  29.865  1.00 35.66           N  
ATOM    469  CA  THR    69      22.075  44.989  29.518  1.00 34.35           C  
ATOM    470  C   THR    69      21.996  46.196  30.461  1.00 37.99           C  
ATOM    471  O   THR    69      21.239  46.188  31.440  1.00 71.48           O  
ATOM    472  CB  THR    69      20.667  44.439  29.417  1.00 32.31           C  
ATOM    473  OG1 THR    69      20.701  43.139  28.797  1.00 33.54           O  
ATOM    474  CG2 THR    69      19.833  45.393  28.545  1.00 35.19           C  
ATOM    475  N   PRO    70      22.791  47.243  30.187  1.00 71.09           N  
ATOM    476  CA  PRO    70      22.777  48.455  31.019  1.00 70.65           C  
ATOM    477  C   PRO    70      21.468  49.209  30.766  1.00 70.27           C  
ATOM    478  O   PRO    70      21.241  50.307  31.275  1.00 69.44           O  
ATOM    479  CB  PRO    70      24.015  49.227  30.537  1.00 71.09           C  
ATOM    480  CG  PRO    70      24.252  48.684  29.133  1.00 72.04           C  
ATOM    481  CD  PRO    70      23.974  47.218  29.308  1.00 71.20           C  
ATOM    482  N   GLU    71      20.607  48.581  29.972  1.00 71.09           N  
ATOM    483  CA  GLU    71      19.312  49.150  29.616  1.00 75.30           C  
ATOM    484  C   GLU    71      18.296  48.896  30.714  1.00 78.01           C  
ATOM    485  O   GLU    71      17.318  49.623  30.850  1.00 79.60           O  
ATOM    486  CB  GLU    71      18.815  48.533  28.315  1.00 75.45           C  
ATOM    487  N   VAL    72      18.552  47.858  31.502  1.00 80.19           N  
ATOM    488  CA  VAL    72      17.645  47.444  32.562  1.00 79.15           C  
ATOM    489  C   VAL    72      17.993  47.917  33.969  1.00 79.08           C  
ATOM    490  O   VAL    72      19.128  48.300  34.268  1.00 80.56           O  
ATOM    491  CB  VAL    72      17.540  45.919  32.569  1.00 78.95           C  
ATOM    492  CG1 VAL    72      18.800  45.316  33.164  1.00 78.97           C  
ATOM    493  CG2 VAL    72      16.306  45.478  33.315  1.00 79.92           C  
ATOM    494  N   GLY    73      16.994  47.891  34.840  1.00 77.79           N  
ATOM    495  CA  GLY    73      17.215  48.295  36.213  1.00 74.50           C  
ATOM    496  C   GLY    73      17.176  47.054  37.076  1.00 72.12           C  
ATOM    497  O   GLY    73      16.435  46.124  36.778  1.00 71.30           O  
ATOM    498  N   VAL    74      18.000  47.009  38.115  1.00 69.87           N  
ATOM    499  CA  VAL    74      17.980  45.867  39.021  1.00 67.33           C  
ATOM    500  C   VAL    74      17.924  46.378  40.446  1.00 65.07           C  
ATOM    501  O   VAL    74      18.701  47.252  40.840  1.00 64.68           O  
ATOM    502  CB  VAL    74      19.230  44.925  38.893  1.00 66.36           C  
ATOM    503  CG1 VAL    74      19.382  44.433  37.469  1.00 67.21           C  
ATOM    504  CG2 VAL    74      20.488  45.624  39.395  1.00 66.08           C  
ATOM    505  N   ALA    75      16.990  45.844  41.216  1.00 62.21           N  
ATOM    506  CA  ALA    75      16.860  46.233  42.612  1.00 59.82           C  
ATOM    507  C   ALA    75      17.039  44.956  43.415  1.00 57.48           C  
ATOM    508  O   ALA    75      16.521  43.898  43.035  1.00 55.79           O  
ATOM    509  CB  ALA    75      15.487  46.840  42.869  1.00 59.11           C  
ATOM    510  N   THR    76      17.802  45.046  44.501  1.00 57.35           N  
ATOM    511  CA  THR    76      18.046  43.886  45.356  1.00 54.95           C  
ATOM    512  C   THR    76      16.774  43.588  46.149  1.00 54.39           C  
ATOM    513  O   THR    76      16.188  44.504  46.720  1.00 55.28           O  
ATOM    514  CB  THR    76      19.146  44.179  46.376  1.00 54.73           C  
ATOM    515  OG1 THR    76      20.137  45.028  45.789  1.00 53.12           O  
ATOM    516  CG2 THR    76      19.791  42.875  46.837  1.00 48.76           C  
ATOM    517  N   ILE    77      16.351  42.339  46.161  1.00 54.78           N  
ATOM    518  CA  ILE    77      15.153  41.933  46.919  1.00 53.95           C  
ATOM    519  C   ILE    77      15.629  41.454  48.293  1.00 53.85           C  
ATOM    520  O   ILE    77      15.225  41.980  49.326  1.00 53.87           O  
ATOM    521  CB  ILE    77      14.389  40.777  46.214  1.00 53.06           C  
ATOM    522  CG1 ILE    77      13.793  41.277  44.891  1.00 49.37           C  
ATOM    523  CG2 ILE    77      13.299  40.243  47.112  1.00 51.41           C  
ATOM    524  CD1 ILE    77      13.302  40.153  43.972  1.00 50.91           C  
ATOM    525  N   ASP    78      16.508  40.458  48.278  1.00 55.39           N  
ATOM    526  CA  ASP    78      17.093  39.904  49.496  1.00 55.89           C  
ATOM    527  C   ASP    78      18.510  39.412  49.202  1.00 54.38           C  
ATOM    528  O   ASP    78      18.835  39.076  48.067  1.00 53.61           O  
ATOM    529  CB  ASP    78      16.253  38.747  50.015  1.00 54.72           C  
ATOM    530  CG  ASP    78      16.001  37.701  48.953  1.00 59.69           C  
ATOM    531  OD1 ASP    78      14.817  37.481  48.619  1.00 61.41           O  
ATOM    532  OD2 ASP    78      16.980  37.107  48.448  1.00 60.49           O  
ATOM    533  N   MET    79      19.342  39.374  50.239  1.00 55.52           N  
ATOM    534  CA  MET    79      20.716  38.921  50.105  1.00 55.94           C  
ATOM    535  C   MET    79      21.201  38.170  51.340  1.00 55.05           C  
ATOM    536  O   MET    79      20.918  38.560  52.478  1.00 54.67           O  
ATOM    537  CB  MET    79      21.634  40.112  49.844  1.00 57.77           C  
ATOM    538  CG  MET    79      23.104  39.746  49.644  1.00 61.43           C  
ATOM    539  SD  MET    79      24.188  41.319  49.288  1.00 69.63          SE  
ATOM    540  CE  MET    79      23.137  41.999  47.825  1.00 68.28           C  
ATOM    541  N   ASN    80      21.939  37.097  51.098  1.00 55.10           N  
ATOM    542  CA  ASN    80      22.491  36.243  52.142  1.00 53.44           C  
ATOM    543  C   ASN    80      24.026  36.260  52.038  1.00 52.11           C  
ATOM    544  O   ASN    80      24.590  36.005  50.981  1.00 50.58           O  
ATOM    545  CB  ASN    80      21.935  34.822  51.964  1.00 53.41           C  
ATOM    546  CG  ASN    80      22.277  33.905  53.126  1.00 54.82           C  
ATOM    547  OD1 ASN    80      23.412  33.444  53.253  1.00 56.64           O  
ATOM    548  ND2 ASN    80      21.297  33.642  53.982  1.00 54.68           N  
ATOM    549  N   THR    81      24.690  36.577  53.140  1.00 52.31           N  
ATOM    550  CA  THR    81      26.142  36.657  53.148  1.00 51.58           C  
ATOM    551  C   THR    81      26.772  35.788  54.236  1.00 50.18           C  
ATOM    552  O   THR    81      26.372  35.825  55.406  1.00 47.55           O  
ATOM    553  CB  THR    81      26.595  38.130  53.333  1.00 50.52           C  
ATOM    554  OG1 THR    81      25.786  38.979  52.513  1.00 53.11           O  
ATOM    555  CG2 THR    81      28.056  38.313  52.912  1.00 51.60           C  
ATOM    556  N   SER    82      27.756  34.999  53.822  1.00 49.70           N  
ATOM    557  CA  SER    82      28.486  34.119  54.715  1.00 48.38           C  
ATOM    558  C   SER    82      29.867  34.719  54.962  1.00 49.69           C  
ATOM    559  O   SER    82      30.508  35.220  54.032  1.00 49.83           O  
ATOM    560  CB  SER    82      28.605  32.733  54.090  1.00 47.04           C  
ATOM    561  OG  SER    82      27.380  32.035  54.219  1.00 47.27           O  
ATOM    562  N   PHE    83      30.305  34.683  56.217  1.00 48.39           N  
ATOM    563  CA  PHE    83      31.596  35.233  56.601  1.00 52.04           C  
ATOM    564  C   PHE    83      32.540  34.094  56.982  1.00 53.41           C  
ATOM    565  O   PHE    83      32.405  33.475  58.034  1.00 51.27           O  
ATOM    566  CB  PHE    83      31.401  36.230  57.751  1.00 52.31           C  
ATOM    567  CG  PHE    83      30.568  37.417  57.369  1.00 48.98           C  
ATOM    568  CD1 PHE    83      31.084  38.398  56.533  1.00 47.82           C  
ATOM    569  CD2 PHE    83      29.237  37.511  57.769  1.00 47.87           C  
ATOM    570  CE1 PHE    83      30.289  39.456  56.094  1.00 48.23           C  
ATOM    571  CE2 PHE    83      28.431  38.571  57.331  1.00 50.92           C  
ATOM    572  CZ  PHE    83      28.956  39.538  56.494  1.00 47.91           C  
ATOM    573  N   MET    84      33.502  33.828  56.103  1.00 56.89           N  
ATOM    574  CA  MET    84      34.440  32.731  56.301  1.00 59.89           C  
ATOM    575  C   MET    84      35.791  33.067  56.893  1.00 60.24           C  
ATOM    576  O   MET    84      36.319  32.314  57.712  1.00 60.94           O  
ATOM    577  CB  MET    84      34.684  32.014  54.981  1.00 60.79           C  
ATOM    578  CG  MET    84      33.579  31.076  54.553  1.00 67.59           C  
ATOM    579  SD  MET    84      32.327  31.852  53.306  1.00 82.87          SE  
ATOM    580  CE  MET    84      31.428  30.224  52.768  1.00 74.13           C  
ATOM    581  N   SER    85      36.350  34.189  56.463  1.00 62.74           N  
ATOM    582  CA  SER    85      37.663  34.601  56.904  1.00 65.29           C  
ATOM    583  C   SER    85      37.779  36.104  56.991  1.00 67.79           C  
ATOM    584  O   SER    85      37.254  36.828  56.149  1.00 68.96           O  
ATOM    585  CB  SER    85      38.706  34.086  55.915  1.00 65.16           C  
ATOM    586  OG  SER    85      38.545  32.696  55.708  1.00 67.38           O  
ATOM    587  N   PRO    86      38.474  36.593  58.021  1.00 68.91           N  
ATOM    588  CA  PRO    86      38.650  38.034  58.184  1.00 69.20           C  
ATOM    589  C   PRO    86      39.234  38.589  56.898  1.00 69.57           C  
ATOM    590  O   PRO    86      40.109  37.973  56.303  1.00 69.70           O  
ATOM    591  CB  PRO    86      39.628  38.129  59.352  1.00 70.10           C  
ATOM    592  CG  PRO    86      39.254  36.938  60.189  1.00 69.38           C  
ATOM    593  CD  PRO    86      39.057  35.851  59.154  1.00 68.26           C  
ATOM    594  N   GLY    87      38.742  39.745  56.469  1.00 71.21           N  
ATOM    595  CA  GLY    87      39.238  40.352  55.246  1.00 70.14           C  
ATOM    596  C   GLY    87      40.309  41.386  55.524  1.00 71.08           C  
ATOM    597  O   GLY    87      40.143  42.241  56.393  1.00 70.15           O  
ATOM    598  N   ARG    88      41.409  41.313  54.778  1.00 72.20           N  
ATOM    599  CA  ARG    88      42.517  42.243  54.947  1.00 71.33           C  
ATOM    600  C   ARG    88      43.218  42.528  53.626  1.00 71.05           C  
ATOM    601  O   ARG    88      43.272  41.670  52.749  1.00 71.84           O  
ATOM    602  CB  ARG    88      43.516  41.671  55.954  1.00 72.66           C  
ATOM    603  CG  ARG    88      42.998  41.644  57.382  1.00 72.27           C  
ATOM    604  CD  ARG    88      43.927  40.870  58.295  1.00 76.68           C  
ATOM    605  NE  ARG    88      43.204  39.848  59.050  1.00 79.59           N  
ATOM    606  CZ  ARG    88      43.741  39.114  60.017  1.00 79.58           C  
ATOM    607  NH1 ARG    88      45.013  39.287  60.351  1.00 82.63           N  
ATOM    608  NH2 ARG    88      43.008  38.207  60.651  1.00 78.13           N  
ATOM    609  N   GLY    89      43.758  43.735  53.488  1.00 70.69           N  
ATOM    610  CA  GLY    89      44.446  44.101  52.264  1.00 71.85           C  
ATOM    611  C   GLY    89      43.462  44.226  51.121  1.00 73.12           C  
ATOM    612  O   GLY    89      42.256  44.199  51.342  1.00 73.84           O  
ATOM    613  N   ASP    90      43.970  44.370  49.901  1.00 72.73           N  
ATOM    614  CA  ASP    90      43.117  44.490  48.723  1.00 72.06           C  
ATOM    615  C   ASP    90      42.302  43.219  48.534  1.00 70.71           C  
ATOM    616  O   ASP    90      42.810  42.110  48.713  1.00 71.10           O  
ATOM    617  CB  ASP    90      43.955  44.724  47.462  1.00 73.55           C  
ATOM    618  CG  ASP    90      44.353  46.179  47.277  1.00 74.11           C  
ATOM    619  OD1 ASP    90      44.944  46.770  48.208  1.00 73.77           O  
ATOM    620  OD2 ASP    90      44.085  46.727  46.188  1.00 75.54           O  
ATOM    621  N   LEU    91      41.039  43.384  48.161  1.00 68.33           N  
ATOM    622  CA  LEU    91      40.155  42.244  47.931  1.00 64.69           C  
ATOM    623  C   LEU    91      39.545  42.356  46.539  1.00 63.47           C  
ATOM    624  O   LEU    91      39.327  43.463  46.031  1.00 61.92           O  
ATOM    625  CB  LEU    91      39.041  42.216  48.972  1.00 63.68           C  
ATOM    626  CG  LEU    91      39.459  42.248  50.440  1.00 59.55           C  
ATOM    627  CD1 LEU    91      38.233  42.541  51.291  1.00 60.67           C  
ATOM    628  CD2 LEU    91      40.101  40.933  50.843  1.00 56.88           C  
ATOM    629  N   VAL    92      39.282  41.211  45.920  1.00 61.53           N  
ATOM    630  CA  VAL    92      38.691  41.204  44.593  1.00 60.01           C  
ATOM    631  C   VAL    92      37.337  40.527  44.720  1.00 57.88           C  
ATOM    632  O   VAL    92      37.203  39.510  45.393  1.00 55.94           O  
ATOM    633  CB  VAL    92      39.602  40.457  43.559  1.00 59.18           C  
ATOM    634  CG1 VAL    92      39.536  38.961  43.765  1.00 62.89           C  
ATOM    635  CG2 VAL    92      39.200  40.833  42.151  1.00 60.68           C  
ATOM    636  N   ILE    93      36.331  41.116  44.085  1.00 58.48           N  
ATOM    637  CA  ILE    93      34.974  40.592  44.144  1.00 57.13           C  
ATOM    638  C   ILE    93      34.493  40.141  42.774  1.00 55.90           C  
ATOM    639  O   ILE    93      34.531  40.904  41.809  1.00 56.68           O  
ATOM    640  CB  ILE    93      34.014  41.662  44.710  1.00 57.13           C  
ATOM    641  CG1 ILE    93      34.526  42.132  46.072  1.00 54.80           C  
ATOM    642  CG2 ILE    93      32.602  41.107  44.837  1.00 53.88           C  
ATOM    643  CD1 ILE    93      35.587  43.210  45.997  1.00 48.07           C  
ATOM    644  N   GLU    94      34.035  38.898  42.698  1.00 56.37           N  
ATOM    645  CA  GLU    94      33.559  38.346  41.436  1.00 56.42           C  
ATOM    646  C   GLU    94      32.210  37.645  41.589  1.00 55.31           C  
ATOM    647  O   GLU    94      32.034  36.791  42.451  1.00 54.64           O  
ATOM    648  CB  GLU    94      34.588  37.364  40.873  1.00 58.89           C  
ATOM    649  CG  GLU    94      35.954  37.969  40.620  1.00 62.05           C  
ATOM    650  CD  GLU    94      36.781  37.142  39.657  1.00 69.04           C  
ATOM    651  OE1 GLU    94      37.265  37.703  38.646  1.00 67.11           O  
ATOM    652  OE2 GLU    94      36.945  35.932  39.908  1.00 70.83           O  
ATOM    653  N   THR    95      31.272  38.000  40.720  1.00 55.95           N  
ATOM    654  CA  THR    95      29.928  37.445  40.761  1.00 55.64           C  
ATOM    655  C   THR    95      29.519  36.789  39.450  1.00 57.43           C  
ATOM    656  O   THR    95      30.160  36.987  38.421  1.00 59.47           O  
ATOM    657  CB  THR    95      28.905  38.544  41.078  1.00 55.35           C  
ATOM    658  OG1 THR    95      29.008  39.593  40.104  1.00 53.07           O  
ATOM    659  CG2 THR    95      29.155  39.118  42.467  1.00 51.92           C  
ATOM    660  N   ARG    96      28.447  36.006  39.500  1.00 58.84           N  
ATOM    661  CA  ARG    96      27.907  35.334  38.318  1.00 58.70           C  
ATOM    662  C   ARG    96      26.393  35.235  38.479  1.00 57.98           C  
ATOM    663  O   ARG    96      25.894  35.043  39.589  1.00 57.43           O  
ATOM    664  CB  ARG    96      28.516  33.928  38.154  1.00 60.02           C  
ATOM    665  CG  ARG    96      28.151  32.917  39.244  1.00 64.39           C  
ATOM    666  CD  ARG    96      29.294  31.922  39.471  1.00 73.23           C  
ATOM    667  NE  ARG    96      30.532  32.618  39.831  1.00 79.38           N  
ATOM    668  CZ  ARG    96      31.044  32.700  41.058  1.00 77.77           C  
ATOM    669  NH1 ARG    96      30.442  32.122  42.088  1.00 75.44           N  
ATOM    670  NH2 ARG    96      32.164  33.384  41.255  1.00 77.42           N  
ATOM    671  N   CYS    97      25.664  35.390  37.378  1.00 57.49           N  
ATOM    672  CA  CYS    97      24.211  35.306  37.416  1.00 55.67           C  
ATOM    673  C   CYS    97      23.878  33.840  37.260  1.00 55.73           C  
ATOM    674  O   CYS    97      24.382  33.193  36.350  1.00 58.61           O  
ATOM    675  CB  CYS    97      23.593  36.101  36.269  1.00 56.18           C  
ATOM    676  SG  CYS    97      21.779  36.147  36.286  1.00 57.01           S  
ATOM    677  N   LEU    98      23.040  33.313  38.146  1.00 54.26           N  
ATOM    678  CA  LEU    98      22.664  31.897  38.098  1.00 52.21           C  
ATOM    679  C   LEU    98      21.433  31.641  37.250  1.00 49.03           C  
ATOM    680  O   LEU    98      21.256  30.560  36.704  1.00 46.12           O  
ATOM    681  CB  LEU    98      22.395  31.381  39.504  1.00 54.15           C  
ATOM    682  CG  LEU    98      23.539  31.416  40.510  1.00 54.58           C  
ATOM    683  CD1 LEU    98      22.973  31.175  41.898  1.00 46.73           C  
ATOM    684  CD2 LEU    98      24.594  30.369  40.145  1.00 56.93           C  
ATOM    685  N   ARG    99      20.568  32.644  37.178  1.00 50.48           N  
ATOM    686  CA  ARG    99      19.344  32.557  36.404  1.00 52.49           C  
ATOM    687  C   ARG    99      18.757  33.938  36.190  1.00 52.82           C  
ATOM    688  O   ARG    99      18.828  34.807  37.056  1.00 53.75           O  
ATOM    689  CB  ARG    99      18.304  31.676  37.102  1.00 54.06           C  
ATOM    690  CG  ARG    99      16.945  31.789  36.431  1.00 57.29           C  
ATOM    691  CD  ARG    99      16.145  30.500  36.429  1.00 65.87           C  
ATOM    692  NE  ARG    99      15.023  30.617  35.497  1.00 70.54           N  
ATOM    693  CZ  ARG    99      14.103  31.574  35.559  1.00 67.79           C  
ATOM    694  NH1 ARG    99      14.164  32.496  36.511  1.00 71.10           N  
ATOM    695  NH2 ARG    99      13.132  31.624  34.661  1.00 70.62           N  
ATOM    696  N   ARG   100      18.160  34.132  35.030  1.00 56.24           N  
ATOM    697  CA  ARG   100      17.563  35.413  34.713  1.00 58.79           C  
ATOM    698  C   ARG   100      16.166  35.176  34.156  1.00 59.48           C  
ATOM    699  O   ARG   100      15.992  34.445  33.179  1.00 62.14           O  
ATOM    700  CB  ARG   100      18.432  36.142  33.687  1.00 59.79           C  
ATOM    701  CG  ARG   100      18.455  37.650  33.842  1.00 59.96           C  
ATOM    702  CD  ARG   100      19.412  38.262  32.846  1.00 63.35           C  
ATOM    703  NE  ARG   100      19.086  39.652  32.554  1.00 71.63           N  
ATOM    704  CZ  ARG   100      19.996  40.602  32.363  1.00 73.15           C  
ATOM    705  NH1 ARG   100      21.288  40.302  32.445  1.00 66.78           N  
ATOM    706  NH2 ARG   100      19.618  41.842  32.072  1.00 77.98           N  
ATOM    707  N   GLY   101      15.171  35.778  34.797  1.00 59.68           N  
ATOM    708  CA  GLY   101      13.807  35.625  34.342  1.00 60.36           C  
ATOM    709  C   GLY   101      13.387  36.942  33.748  1.00 59.99           C  
ATOM    710  O   GLY   101      14.216  37.825  33.555  1.00 59.70           O  
ATOM    711  N   ALA   102      12.107  37.086  33.444  1.00 61.31           N  
ATOM    712  CA  ALA   102      11.638  38.337  32.876  1.00 62.56           C  
ATOM    713  C   ALA   102      11.613  39.373  33.981  1.00 63.18           C  
ATOM    714  O   ALA   102      11.869  40.556  33.752  1.00 65.06           O  
ATOM    715  CB  ALA   102      10.259  38.155  32.296  1.00 62.57           C  
ATOM    716  N   SER   103      11.327  38.907  35.191  1.00 63.17           N  
ATOM    717  CA  SER   103      11.222  39.792  36.345  1.00 63.30           C  
ATOM    718  C   SER   103      12.206  39.558  37.492  1.00 60.88           C  
ATOM    719  O   SER   103      12.620  40.507  38.152  1.00 59.41           O  
ATOM    720  CB  SER   103       9.791  39.713  36.886  1.00 65.59           C  
ATOM    721  OG  SER   103       9.628  40.516  38.041  1.00 72.67           O  
ATOM    722  N   ILE   104      12.576  38.294  37.712  1.00 60.81           N  
ATOM    723  CA  ILE   104      13.469  37.891  38.813  1.00 58.72           C  
ATOM    724  C   ILE   104      14.853  37.356  38.406  1.00 59.10           C  
ATOM    725  O   ILE   104      14.965  36.490  37.540  1.00 56.77           O  
ATOM    726  CB  ILE   104      12.793  36.791  39.674  1.00 58.71           C  
ATOM    727  CG1 ILE   104      11.414  37.255  40.143  1.00 54.91           C  
ATOM    728  CG2 ILE   104      13.657  36.457  40.872  1.00 56.87           C  
ATOM    729  CD1 ILE   104      11.455  38.329  41.208  1.00 53.11           C  
ATOM    730  N   ALA   105      15.897  37.851  39.069  1.00 57.55           N  
ATOM    731  CA  ALA   105      17.265  37.408  38.791  1.00 55.87           C  
ATOM    732  C   ALA   105      17.959  36.863  40.039  1.00 53.73           C  
ATOM    733  O   ALA   105      17.839  37.433  41.119  1.00 52.30           O  
ATOM    734  CB  ALA   105      18.079  38.563  38.209  1.00 55.98           C  
ATOM    735  N   PHE   106      18.697  35.765  39.878  1.00 54.37           N  
ATOM    736  CA  PHE   106      19.435  35.138  40.984  1.00 54.66           C  
ATOM    737  C   PHE   106      20.934  35.283  40.757  1.00 56.10           C  
ATOM    738  O   PHE   106      21.431  35.012  39.668  1.00 58.87           O  
ATOM    739  CB  PHE   106      19.118  33.647  41.074  1.00 51.44           C  
ATOM    740  CG  PHE   106      17.710  33.342  41.483  1.00 50.85           C  
ATOM    741  CD1 PHE   106      17.320  33.428  42.822  1.00 44.53           C  
ATOM    742  CD2 PHE   106      16.763  32.968  40.527  1.00 46.72           C  
ATOM    743  CE1 PHE   106      16.002  33.144  43.214  1.00 39.63           C  
ATOM    744  CE2 PHE   106      15.439  32.684  40.904  1.00 47.44           C  
ATOM    745  CZ  PHE   106      15.059  32.773  42.253  1.00 49.21           C  
ATOM    746  N   CYS   107      21.658  35.694  41.788  1.00 59.42           N  
ATOM    747  CA  CYS   107      23.103  35.859  41.666  1.00 60.48           C  
ATOM    748  C   CYS   107      23.868  35.361  42.879  1.00 58.89           C  
ATOM    749  O   CYS   107      23.320  35.228  43.968  1.00 58.15           O  
ATOM    750  CB  CYS   107      23.451  37.333  41.430  1.00 59.77           C  
ATOM    751  SG  CYS   107      22.814  38.008  39.875  1.00 68.43           S  
ATOM    752  N   GLU   108      25.142  35.060  42.670  1.00 58.74           N  
ATOM    753  CA  GLU   108      26.014  34.615  43.746  1.00 57.79           C  
ATOM    754  C   GLU   108      27.394  35.209  43.505  1.00 56.15           C  
ATOM    755  O   GLU   108      27.675  35.741  42.435  1.00 56.27           O  
ATOM    756  CB  GLU   108      26.088  33.090  43.809  1.00 56.81           C  
ATOM    757  CG  GLU   108      26.431  32.413  42.505  1.00 59.58           C  
ATOM    758  CD  GLU   108      27.160  31.110  42.723  1.00 56.82           C  
ATOM    759  OE1 GLU   108      26.776  30.354  43.640  1.00 62.65           O  
ATOM    760  OE2 GLU   108      28.122  30.847  41.975  1.00 63.95           O  
ATOM    761  N   GLY   109      28.252  35.143  44.510  1.00 55.69           N  
ATOM    762  CA  GLY   109      29.573  35.711  44.349  1.00 56.85           C  
ATOM    763  C   GLY   109      30.464  35.456  45.541  1.00 56.87           C  
ATOM    764  O   GLY   109      30.046  34.847  46.526  1.00 54.75           O  
ATOM    765  N   GLU   110      31.693  35.955  45.459  1.00 57.17           N  
ATOM    766  CA  GLU   110      32.664  35.744  46.520  1.00 58.54           C  
ATOM    767  C   GLU   110      33.738  36.825  46.563  1.00 56.41           C  
ATOM    768  O   GLU   110      34.023  37.483  45.560  1.00 57.20           O  
ATOM    769  CB  GLU   110      33.321  34.376  46.325  1.00 58.69           C  
ATOM    770  CG  GLU   110      33.367  33.958  44.854  1.00 67.99           C  
ATOM    771  CD  GLU   110      34.447  32.940  44.547  1.00 76.41           C  
ATOM    772  OE1 GLU   110      34.343  31.793  45.033  1.00 83.23           O  
ATOM    773  OE2 GLU   110      35.399  33.295  43.814  1.00 76.64           O  
ATOM    774  N   ILE   111      34.327  36.997  47.741  1.00 55.20           N  
ATOM    775  CA  ILE   111      35.387  37.964  47.944  1.00 53.99           C  
ATOM    776  C   ILE   111      36.631  37.171  48.334  1.00 53.91           C  
ATOM    777  O   ILE   111      36.563  36.255  49.158  1.00 52.14           O  
ATOM    778  CB  ILE   111      35.039  38.952  49.079  1.00 55.99           C  
ATOM    779  CG1 ILE   111      33.687  39.618  48.794  1.00 50.38           C  
ATOM    780  CG2 ILE   111      36.146  40.007  49.213  1.00 52.86           C  
ATOM    781  CD1 ILE   111      33.182  40.488  49.915  1.00 44.32           C  
ATOM    782  N   ARG   112      37.767  37.512  47.740  1.00 54.95           N  
ATOM    783  CA  ARG   112      39.004  36.802  48.049  1.00 57.36           C  
ATOM    784  C   ARG   112      40.111  37.804  48.309  1.00 58.33           C  
ATOM    785  O   ARG   112      40.093  38.914  47.770  1.00 58.61           O  
ATOM    786  CB  ARG   112      39.401  35.876  46.890  1.00 55.02           C  
ATOM    787  CG  ARG   112      38.240  35.058  46.326  1.00 58.53           C  
ATOM    788  CD  ARG   112      38.714  33.889  45.468  1.00 59.84           C  
ATOM    789  NE  ARG   112      38.967  32.697  46.276  1.00 55.17           N  
ATOM    790  CZ  ARG   112      38.262  31.576  46.185  1.00 56.50           C  
ATOM    791  NH1 ARG   112      37.268  31.499  45.312  1.00 57.16           N  
ATOM    792  NH2 ARG   112      38.530  30.546  46.983  1.00 53.22           N  
ATOM    793  N   ASP   113      41.065  37.418  49.149  1.00 59.75           N  
ATOM    794  CA  ASP   113      42.187  38.293  49.460  1.00 61.42           C  
ATOM    795  C   ASP   113      43.326  38.045  48.482  1.00 61.61           C  
ATOM    796  O   ASP   113      43.249  37.151  47.643  1.00 61.62           O  
ATOM    797  CB  ASP   113      42.678  38.072  50.899  1.00 63.46           C  
ATOM    798  CG  ASP   113      42.922  36.614  51.225  1.00 62.82           C  
ATOM    799  OD1 ASP   113      43.513  35.895  50.390  1.00 71.52           O  
ATOM    800  OD2 ASP   113      42.531  36.189  52.327  1.00 61.21           O  
ATOM    801  N   SER   114      44.375  38.852  48.590  1.00 63.28           N  
ATOM    802  CA  SER   114      45.539  38.730  47.722  1.00 64.00           C  
ATOM    803  C   SER   114      46.053  37.295  47.693  1.00 65.13           C  
ATOM    804  O   SER   114      46.604  36.850  46.693  1.00 66.04           O  
ATOM    805  CB  SER   114      46.643  39.679  48.204  1.00 65.13           C  
ATOM    806  OG  SER   114      46.817  39.600  49.612  1.00 60.56           O  
ATOM    807  N   ALA   115      45.849  36.572  48.792  1.00 66.03           N  
ATOM    808  CA  ALA   115      46.287  35.183  48.918  1.00 65.08           C  
ATOM    809  C   ALA   115      45.301  34.190  48.297  1.00 65.99           C  
ATOM    810  O   ALA   115      45.504  32.977  48.367  1.00 66.38           O  
ATOM    811  CB  ALA   115      46.511  34.846  50.396  1.00 65.09           C  
ATOM    812  N   GLY   116      44.227  34.714  47.707  1.00 66.72           N  
ATOM    813  CA  GLY   116      43.228  33.874  47.061  1.00 64.83           C  
ATOM    814  C   GLY   116      42.303  33.078  47.968  1.00 64.48           C  
ATOM    815  O   GLY   116      41.588  32.188  47.501  1.00 63.85           O  
ATOM    816  N   GLU   117      42.304  33.389  49.259  1.00 63.88           N  
ATOM    817  CA  GLU   117      41.458  32.672  50.204  1.00 64.34           C  
ATOM    818  C   GLU   117      40.067  33.306  50.290  1.00 62.51           C  
ATOM    819  O   GLU   117      39.922  34.529  50.216  1.00 62.86           O  
ATOM    820  CB  GLU   117      42.115  32.656  51.587  1.00 65.37           C  
ATOM    821  CG  GLU   117      42.256  31.277  52.213  1.00 66.65           C  
ATOM    822  CD  GLU   117      43.127  30.333  51.389  1.00 73.09           C  
ATOM    823  OE1 GLU   117      44.185  30.772  50.883  1.00 72.72           O  
ATOM    824  OE2 GLU   117      42.761  29.144  51.258  1.00 73.02           O  
ATOM    825  N   LEU   118      39.053  32.461  50.444  1.00 59.68           N  
ATOM    826  CA  LEU   118      37.671  32.909  50.529  1.00 59.25           C  
ATOM    827  C   LEU   118      37.402  33.732  51.794  1.00 58.30           C  
ATOM    828  O   LEU   118      37.537  33.241  52.920  1.00 54.60           O  
ATOM    829  CB  LEU   118      36.729  31.695  50.472  1.00 60.95           C  
ATOM    830  CG  LEU   118      35.239  31.901  50.169  1.00 59.70           C  
ATOM    831  CD1 LEU   118      35.060  32.717  48.881  1.00 53.79           C  
ATOM    832  CD2 LEU   118      34.574  30.539  50.026  1.00 56.32           C  
ATOM    833  N   VAL   119      37.034  34.994  51.588  1.00 57.09           N  
ATOM    834  CA  VAL   119      36.725  35.905  52.679  1.00 56.54           C  
ATOM    835  C   VAL   119      35.238  35.783  53.006  1.00 54.43           C  
ATOM    836  O   VAL   119      34.868  35.530  54.149  1.00 55.22           O  
ATOM    837  CB  VAL   119      37.065  37.375  52.296  1.00 56.87           C  
ATOM    838  CG1 VAL   119      36.539  38.330  53.353  1.00 56.66           C  
ATOM    839  CG2 VAL   119      38.580  37.534  52.157  1.00 57.01           C  
ATOM    840  N   ALA   120      34.393  35.949  51.996  1.00 53.42           N  
ATOM    841  CA  ALA   120      32.947  35.838  52.174  1.00 54.17           C  
ATOM    842  C   ALA   120      32.283  35.429  50.873  1.00 52.69           C  
ATOM    843  O   ALA   120      32.813  35.685  49.804  1.00 54.05           O  
ATOM    844  CB  ALA   120      32.370  37.164  52.656  1.00 51.04           C  
ATOM    845  N   LYS   121      31.128  34.785  50.974  1.00 53.82           N  
ATOM    846  CA  LYS   121      30.365  34.361  49.807  1.00 53.64           C  
ATOM    847  C   LYS   121      28.933  34.842  50.040  1.00 53.35           C  
ATOM    848  O   LYS   121      28.452  34.835  51.174  1.00 51.67           O  
ATOM    849  CB  LYS   121      30.399  32.838  49.663  1.00 53.76           C  
ATOM    850  CG  LYS   121      30.210  32.357  48.236  1.00 60.50           C  
ATOM    851  CD  LYS   121      30.881  31.005  48.023  1.00 69.99           C  
ATOM    852  CE  LYS   121      30.995  30.643  46.543  1.00 72.37           C  
ATOM    853  NZ  LYS   121      29.668  30.515  45.889  1.00 75.53           N  
ATOM    854  N   ALA   122      28.257  35.258  48.969  1.00 52.17           N  
ATOM    855  CA  ALA   122      26.894  35.764  49.095  1.00 50.01           C  
ATOM    856  C   ALA   122      25.981  35.395  47.937  1.00 47.99           C  
ATOM    857  O   ALA   122      26.429  35.170  46.821  1.00 47.40           O  
ATOM    858  CB  ALA   122      26.921  37.286  49.260  1.00 47.87           C  
ATOM    859  N   THR   123      24.690  35.305  48.219  1.00 48.48           N  
ATOM    860  CA  THR   123      23.720  35.027  47.175  1.00 50.18           C  
ATOM    861  C   THR   123      22.708  36.170  47.283  1.00 50.64           C  
ATOM    862  O   THR   123      22.557  36.775  48.351  1.00 49.94           O  
ATOM    863  CB  THR   123      23.031  33.656  47.369  1.00 48.58           C  
ATOM    864  OG1 THR   123      22.423  33.601  48.666  1.00 52.63           O  
ATOM    865  CG2 THR   123      24.043  32.516  47.217  1.00 48.88           C  
ATOM    866  N   ALA   124      22.047  36.491  46.176  1.00 50.30           N  
ATOM    867  CA  ALA   124      21.073  37.577  46.166  1.00 49.15           C  
ATOM    868  C   ALA   124      19.970  37.360  45.144  1.00 50.23           C  
ATOM    869  O   ALA   124      20.143  36.646  44.150  1.00 48.07           O  
ATOM    870  CB  ALA   124      21.767  38.900  45.896  1.00 49.07           C  
ATOM    871  N   THR   125      18.823  37.969  45.410  1.00 49.61           N  
ATOM    872  CA  THR   125      17.695  37.868  44.509  1.00 49.31           C  
ATOM    873  C   THR   125      17.456  39.292  44.042  1.00 47.89           C  
ATOM    874  O   THR   125      17.596  40.240  44.816  1.00 47.69           O  
ATOM    875  CB  THR   125      16.435  37.301  45.215  1.00 48.47           C  
ATOM    876  OG1 THR   125      16.746  36.048  45.841  1.00 46.66           O  
ATOM    877  CG2 THR   125      15.350  37.055  44.207  1.00 49.82           C  
ATOM    878  N   PHE   126      17.099  39.452  42.777  1.00 47.83           N  
ATOM    879  CA  PHE   126      16.909  40.798  42.258  1.00 49.42           C  
ATOM    880  C   PHE   126      15.630  41.041  41.484  1.00 49.91           C  
ATOM    881  O   PHE   126      15.075  40.134  40.859  1.00 48.27           O  
ATOM    882  CB  PHE   126      18.075  41.197  41.342  1.00 47.90           C  
ATOM    883  CG  PHE   126      19.377  41.440  42.062  1.00 46.56           C  
ATOM    884  CD1 PHE   126      20.242  40.387  42.367  1.00 46.64           C  
ATOM    885  CD2 PHE   126      19.758  42.734  42.399  1.00 40.34           C  
ATOM    886  CE1 PHE   126      21.478  40.634  42.997  1.00 45.60           C  
ATOM    887  CE2 PHE   126      20.988  42.991  43.028  1.00 42.33           C  
ATOM    888  CZ  PHE   126      21.849  41.935  43.324  1.00 39.69           C  
ATOM    889  N   LYS   127      15.173  42.290  41.522  1.00 53.22           N  
ATOM    890  CA  LYS   127      14.003  42.701  40.755  1.00 57.90           C  
ATOM    891  C   LYS   127      14.625  43.362  39.520  1.00 59.78           C  
ATOM    892  O   LYS   127      15.464  44.259  39.659  1.00 58.23           O  
ATOM    893  CB  LYS   127      13.184  43.727  41.536  1.00 56.86           C  
ATOM    894  N   ILE   128      14.283  42.901  38.321  1.00 63.95           N  
ATOM    895  CA  ILE   128      14.820  43.588  37.157  1.00 68.16           C  
ATOM    896  C   ILE   128      13.707  44.524  36.743  1.00 71.94           C  
ATOM    897  O   ILE   128      12.611  44.095  36.375  1.00 71.60           O  
ATOM    898  CB  ILE   128      15.243  42.644  35.982  1.00 67.37           C  
ATOM    899  CG1 ILE   128      14.467  41.327  36.011  1.00 63.20           C  
ATOM    900  CG2 ILE   128      16.746  42.394  36.053  1.00 68.21           C  
ATOM    901  CD1 ILE   128      15.170  40.208  35.236  1.00 60.33           C  
ATOM    902  N   ILE   129      14.000  45.816  36.858  1.00 75.65           N  
ATOM    903  CA  ILE   129      13.054  46.886  36.560  1.00 79.11           C  
ATOM    904  C   ILE   129      12.728  47.158  35.092  1.00 82.21           C  
ATOM    905  O   ILE   129      13.085  48.203  34.556  1.00 82.94           O  
ATOM    906  CB  ILE   129      13.512  48.223  37.209  1.00 79.07           C  
ATOM    907  CG1 ILE   129      13.778  48.023  38.711  1.00 78.47           C  
ATOM    908  CG2 ILE   129      12.450  49.294  37.007  1.00 79.06           C  
ATOM    909  CD1 ILE   129      12.657  47.332  39.458  1.00 77.73           C  
ATOM    910  N   GLN   130      12.055  46.203  34.453  1.00 85.92           N  
ATOM    911  CA  GLN   130      11.596  46.349  33.074  1.00 88.00           C  
ATOM    912  C   GLN   130      10.817  45.148  32.564  1.00 88.85           C  
ATOM    913  O   GLN   130       9.657  45.373  32.160  1.00 89.20           O  
ATOM    914  CB  GLN   130      12.742  46.702  32.114  1.00 87.61           C  
ATOM    915  CG  GLN   130      12.373  47.924  31.257  1.00 87.70           C  
ATOM    916  CD  GLN   130      11.656  49.016  32.066  1.00 85.68           C  
ATOM    917  OE1 GLN   130      10.611  48.772  32.678  1.00 80.72           O  
ATOM    918  NE2 GLN   130      12.217  50.224  32.065  1.00 84.66           N  
END
