
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  138 ( 1062),  selected  138 , name 1sbk_A
# Molecule2: number of CA atoms  125 (  918),  selected  125 , name T0479.pdb
# PARAMETERS: 1sbk_A.T0479.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_A      -       -           -
LGA    I     2_A      -       -           -
LGA    W     3_A      -       -           -
LGA    K     4_A      -       -           -
LGA    R     5_A      -       -           -
LGA    K     6_A      -       -           -
LGA    I     7_A      -       -           -
LGA    T     8_A      -       -           -
LGA    L     9_A      -       -           -
LGA    E    10_A      -       -           -
LGA    A    11_A      -       -           -
LGA    L    12_A      T       6           #
LGA    N    13_A      D       7          2.867
LGA    A    14_A      F       8          5.282
LGA    -       -      F       9           -
LGA    -       -      G      10           -
LGA    X    15_A      L      11          3.034
LGA    G    16_A      T      12          3.589
LGA    E    17_A      I      13          5.670
LGA    G    18_A      -       -           -
LGA    N    19_A      P      14          0.577
LGA    X    20_A      F      15          1.016
LGA    V    21_A      M      16          1.025
LGA    G    22_A      Q      17          0.836
LGA    F    23_A      L      18          0.642
LGA    L    24_A      L      19          0.613
LGA    D    25_A      G      20          1.179
LGA    I    26_A      V      21          1.192
LGA    R    27_A      V      22          0.885
LGA    F    28_A      P      23          1.193
LGA    E    29_A      E      24          1.320
LGA    H    30_A      H      25          2.772
LGA    I    31_A      S      26          3.778
LGA    G    32_A      G      27           #
LGA    D    33_A      N      28          3.321
LGA    D    34_A      G      29          3.200
LGA    T    35_A      T      30          1.808
LGA    L    36_A      A      31          0.865
LGA    E    37_A      R      32          0.569
LGA    A    38_A      T      33          0.338
LGA    T    39_A      R      34          0.462
LGA    X    40_A      L      35          0.732
LGA    P    41_A      P      36          2.279
LGA    V    42_A      A      37          3.023
LGA    D    43_A      R      38          1.647
LGA    S    44_A      A      39          1.906
LGA    R    45_A      D      40          2.362
LGA    T    46_A      L      41          1.582
LGA    K    47_A      V      42          0.618
LGA    Q    48_A      N      43          1.035
LGA    P    49_A      S      44          2.291
LGA    F    50_A      R      45          2.764
LGA    G    51_A      G      46          1.138
LGA    L    52_A      D      47          0.578
LGA    L    53_A      I      48          0.745
LGA    H    54_A      H      49          0.374
LGA    G    55_A      G      50          0.627
LGA    G    56_A      G      51          0.780
LGA    A    57_A      T      52          0.825
LGA    S    58_A      L      53          0.728
LGA    V    59_A      M      54          0.575
LGA    V    60_A      S      55          0.639
LGA    L    61_A      V      56          0.910
LGA    A    62_A      L      57          0.772
LGA    E    63_A      D      58          0.525
LGA    S    64_A      F      59          0.295
LGA    I    65_A      T      60          0.581
LGA    G    66_A      L      61          1.070
LGA    S    67_A      G      62          1.516
LGA    V    68_A      A      63          2.487
LGA    A    69_A      A      64          2.463
LGA    G    70_A      I      65          1.960
LGA    Y    71_A      R      66          2.522
LGA    L    72_A      G      67          2.673
LGA    C    73_A      D      68          3.789
LGA    T    74_A      T      69          4.171
LGA    E    75_A      P      70           #
LGA    G    76_A      E      71          3.308
LGA    E    77_A      -       -           -
LGA    Q    78_A      V      72          3.441
LGA    K    79_A      G      73          1.368
LGA    V    80_A      V      74          0.957
LGA    V    81_A      A      75          0.536
LGA    G    82_A      T      76          0.222
LGA    L    83_A      I      77          0.042
LGA    E    84_A      D      78          0.473
LGA    I    85_A      M      79          0.258
LGA    N    86_A      N      80          0.588
LGA    A    87_A      T      81          0.663
LGA    N    88_A      S      82          0.349
LGA    H    89_A      F      83          0.289
LGA    V    90_A      M      84          0.155
LGA    R    91_A      S      85          0.579
LGA    S    92_A      P      86          0.521
LGA    A    93_A      G      87          1.673
LGA    R    94_A      R      88          2.328
LGA    E    95_A      G      89          2.068
LGA    G    96_A      -       -           -
LGA    R    97_A      D      90          1.069
LGA    V    98_A      L      91          0.552
LGA    R    99_A      V      92          0.604
LGA    G   100_A      I      93          0.640
LGA    V   101_A      E      94          0.609
LGA    C   102_A      T      95          0.517
LGA    K   103_A      R      96          0.662
LGA    P   104_A      C      97          1.267
LGA    L   105_A      L      98          1.100
LGA    H   106_A      R      99          0.972
LGA    L   107_A      R     100          1.157
LGA    G   108_A      G     101          1.082
LGA    S   109_A      A     102          0.960
LGA    R   110_A      S     103          0.647
LGA    H   111_A      I     104          0.713
LGA    Q   112_A      A     105          0.654
LGA    V   113_A      F     106          0.579
LGA    W   114_A      C     107          0.665
LGA    Q   115_A      E     108          0.603
LGA    I   116_A      G     109          0.962
LGA    E   117_A      E     110          0.899
LGA    I   118_A      I     111          0.721
LGA    F   119_A      R     112          0.309
LGA    D   120_A      D     113          0.624
LGA    E   121_A      S     114          1.000
LGA    K   122_A      A     115          0.831
LGA    G   123_A      G     116          0.587
LGA    R   124_A      E     117          0.485
LGA    L   125_A      L     118          0.489
LGA    C   126_A      V     119          0.350
LGA    C   127_A      A     120          0.437
LGA    S   128_A      K     121          0.345
LGA    S   129_A      A     122          0.362
LGA    R   130_A      T     123          0.488
LGA    L   131_A      A     124          1.055
LGA    T   132_A      T     125          0.465
LGA    T   133_A      F     126          0.098
LGA    A   134_A      K     127          0.896
LGA    I   135_A      I     128          1.264
LGA    L   136_A      I     129          1.983
LGA    L   137_A      Q     130          3.671
LGA    E   138_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  138  125    5.0    120    1.70    19.17     89.965     6.681

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.641042 * X  +   0.762246 * Y  +  -0.089702 * Z  +  25.633039
  Y_new =   0.564701 * X  +   0.547574 * Y  +   0.617475 * Z  +  16.410027
  Z_new =   0.519787 * X  +   0.345172 * Y  +  -0.781459 * Z  +  67.240410 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.725661   -0.415932  [ DEG:   156.1689    -23.8311 ]
  Theta =  -0.546601   -2.594991  [ DEG:   -31.3179   -148.6821 ]
  Phi   =   2.419424   -0.722169  [ DEG:   138.6228    -41.3772 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1sbk_A                                        
REMARK     2: T0479.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1sbk_A.T0479.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  138  125   5.0  120   1.70   19.17  89.965
REMARK  ---------------------------------------------------------- 
MOLECULE 1sbk_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   10-FEB-04   1SBK              
TITLE     X-RAY STRUCTURE OF YDII_ECOLI NORTHEAST STRUCTURAL GENOMICS           
TITLE    2 CONSORTIUM TARGET ER29.                                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN YDII;                                 
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ESCHERICHIA COLI;                               
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: YDII, B1686;                                                   
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET21D                                    
KEYWDS    ER29, YDII, STRUCTURAL GENOMICS, PSI, PROTEIN STRUCTURE               
KEYWDS   2 INITIATIVE, NORTHEAST STRUCTURAL GENOMICS CONSORTIUM, NESG           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.P.KUZIN,W.EDSTROM,S.M.VOROBIEV,I.LEE,F.FOROUHAR,L.MA,               
AUTHOR   2 Y.CHIANG,X.RONG,T.B.ACTON,G.T.MONTELIONE,J.F.HUNT,L.TONG,            
AUTHOR   3 NORTHEAST STRUCTURAL GENOMICS CONSORTIUM (NESG)                      
REVDAT   2   25-JAN-05 1SBK    1       AUTHOR KEYWDS REMARK                     
REVDAT   1   24-FEB-04 1SBK    0                                                
JRNL        AUTH   A.P.KUZIN,W.EDSTROM,S.M.VOROBIEV,I.LEE,F.FOROUHAR,           
JRNL        AUTH 2 L.MA,Y.CHIANG,X.RONG,T.B.ACTON,G.T.MONTELIONE,               
JRNL        AUTH 3 J.F.HUNT,L.TONG                                              
JRNL        TITL   X-RAY STRUCTURE OF YDII_ECOLI NORTHEAST STRUCTURAL           
JRNL        TITL 2 GENOMICS CONSORTIUM TARGET ER29                              
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  1SBK A    1   136  UNP    P77781   YDII_ECOLI       1    136             
DBREF  1SBK B    1   136  UNP    P77781   YDII_ECOLI       1    136             
DBREF  1SBK C    1   136  UNP    P77781   YDII_ECOLI       1    136             
DBREF  1SBK D    1   136  UNP    P77781   YDII_ECOLI       1    136             
SEQRES   1 A  144  MSE ILE TRP LYS ARG LYS ILE THR LEU GLU ALA LEU ASN          
SEQRES   2 A  144  ALA MSE GLY GLU GLY ASN MSE VAL GLY PHE LEU ASP ILE          
SEQRES   3 A  144  ARG PHE GLU HIS ILE GLY ASP ASP THR LEU GLU ALA THR          
SEQRES   4 A  144  MSE PRO VAL ASP SER ARG THR LYS GLN PRO PHE GLY LEU          
SEQRES   5 A  144  LEU HIS GLY GLY ALA SER VAL VAL LEU ALA GLU SER ILE          
SEQRES   6 A  144  GLY SER VAL ALA GLY TYR LEU CYS THR GLU GLY GLU GLN          
SEQRES   7 A  144  LYS VAL VAL GLY LEU GLU ILE ASN ALA ASN HIS VAL ARG          
SEQRES   8 A  144  SER ALA ARG GLU GLY ARG VAL ARG GLY VAL CYS LYS PRO          
SEQRES   9 A  144  LEU HIS LEU GLY SER ARG HIS GLN VAL TRP GLN ILE GLU          
SEQRES  10 A  144  ILE PHE ASP GLU LYS GLY ARG LEU CYS CYS SER SER ARG          
SEQRES  11 A  144  LEU THR THR ALA ILE LEU LEU GLU HIS HIS HIS HIS HIS          
SEQRES  12 A  144  HIS                                                          
SEQRES   1 B  144  MSE ILE TRP LYS ARG LYS ILE THR LEU GLU ALA LEU ASN          
SEQRES   2 B  144  ALA MSE GLY GLU GLY ASN MSE VAL GLY PHE LEU ASP ILE          
SEQRES   3 B  144  ARG PHE GLU HIS ILE GLY ASP ASP THR LEU GLU ALA THR          
SEQRES   4 B  144  MSE PRO VAL ASP SER ARG THR LYS GLN PRO PHE GLY LEU          
SEQRES   5 B  144  LEU HIS GLY GLY ALA SER VAL VAL LEU ALA GLU SER ILE          
SEQRES   6 B  144  GLY SER VAL ALA GLY TYR LEU CYS THR GLU GLY GLU GLN          
SEQRES   7 B  144  LYS VAL VAL GLY LEU GLU ILE ASN ALA ASN HIS VAL ARG          
SEQRES   8 B  144  SER ALA ARG GLU GLY ARG VAL ARG GLY VAL CYS LYS PRO          
SEQRES   9 B  144  LEU HIS LEU GLY SER ARG HIS GLN VAL TRP GLN ILE GLU          
SEQRES  10 B  144  ILE PHE ASP GLU LYS GLY ARG LEU CYS CYS SER SER ARG          
SEQRES  11 B  144  LEU THR THR ALA ILE LEU LEU GLU HIS HIS HIS HIS HIS          
SEQRES  12 B  144  HIS                                                          
SEQRES   1 C  144  MSE ILE TRP LYS ARG LYS ILE THR LEU GLU ALA LEU ASN          
SEQRES   2 C  144  ALA MSE GLY GLU GLY ASN MSE VAL GLY PHE LEU ASP ILE          
SEQRES   3 C  144  ARG PHE GLU HIS ILE GLY ASP ASP THR LEU GLU ALA THR          
SEQRES   4 C  144  MSE PRO VAL ASP SER ARG THR LYS GLN PRO PHE GLY LEU          
SEQRES   5 C  144  LEU HIS GLY GLY ALA SER VAL VAL LEU ALA GLU SER ILE          
SEQRES   6 C  144  GLY SER VAL ALA GLY TYR LEU CYS THR GLU GLY GLU GLN          
SEQRES   7 C  144  LYS VAL VAL GLY LEU GLU ILE ASN ALA ASN HIS VAL ARG          
SEQRES   8 C  144  SER ALA ARG GLU GLY ARG VAL ARG GLY VAL CYS LYS PRO          
SEQRES   9 C  144  LEU HIS LEU GLY SER ARG HIS GLN VAL TRP GLN ILE GLU          
SEQRES  10 C  144  ILE PHE ASP GLU LYS GLY ARG LEU CYS CYS SER SER ARG          
SEQRES  11 C  144  LEU THR THR ALA ILE LEU LEU GLU HIS HIS HIS HIS HIS          
SEQRES  12 C  144  HIS                                                          
SEQRES   1 D  144  MSE ILE TRP LYS ARG LYS ILE THR LEU GLU ALA LEU ASN          
SEQRES   2 D  144  ALA MSE GLY GLU GLY ASN MSE VAL GLY PHE LEU ASP ILE          
SEQRES   3 D  144  ARG PHE GLU HIS ILE GLY ASP ASP THR LEU GLU ALA THR          
SEQRES   4 D  144  MSE PRO VAL ASP SER ARG THR LYS GLN PRO PHE GLY LEU          
SEQRES   5 D  144  LEU HIS GLY GLY ALA SER VAL VAL LEU ALA GLU SER ILE          
SEQRES   6 D  144  GLY SER VAL ALA GLY TYR LEU CYS THR GLU GLY GLU GLN          
SEQRES   7 D  144  LYS VAL VAL GLY LEU GLU ILE ASN ALA ASN HIS VAL ARG          
SEQRES   8 D  144  SER ALA ARG GLU GLY ARG VAL ARG GLY VAL CYS LYS PRO          
SEQRES   9 D  144  LEU HIS LEU GLY SER ARG HIS GLN VAL TRP GLN ILE GLU          
SEQRES  10 D  144  ILE PHE ASP GLU LYS GLY ARG LEU CYS CYS SER SER ARG          
SEQRES  11 D  144  LEU THR THR ALA ILE LEU LEU GLU HIS HIS HIS HIS HIS          
SEQRES  12 D  144  HIS                                                          
HET    MSE  A   1       8                                                       
HET    MSE  A  15       8                                                       
HET    MSE  A  20       8                                                       
HET    MSE  A  40       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  15       8                                                       
HET    MSE  B  20       8                                                       
HET    MSE  B  40       8                                                       
HET    MSE  C   1       8                                                       
HET    MSE  C  15       8                                                       
HET    MSE  C  20       8                                                       
HET    MSE  C  40       8                                                       
HET    MSE  D   1       8                                                       
HET    MSE  D  15       8                                                       
HET    MSE  D  20       8                                                       
HET    MSE  D  40       8                                                       
HET    SO4    801       5                                                       
HET    SO4    802       5                                                       
HET    SO4    803       5                                                       
HET    SO4    804       5                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     SO4 SULFATE ION                                                      
FORMUL   1  MSE    16(C5 H11 N O2 SE)                                           
FORMUL   5  SO4    4(O4 S 2-)                                                   
FORMUL   9  HOH   *425(H2 O)                                                    
CRYST1   46.642   61.196   93.008  90.00 104.66  90.00 P 1 21 1      8          
HETATM    1  N   MSE A   1      27.574  36.194  25.370  1.00 37.82           N  
HETATM    2  CA  MSE A   1      27.554  36.919  26.672  1.00 37.47           C  
HETATM    3  C   MSE A   1      26.126  37.153  27.146  1.00 34.57           C  
HETATM    4  O   MSE A   1      25.205  37.260  26.336  1.00 34.28           O  
HETATM    5  CB  MSE A   1      28.294  38.256  26.541  1.00 42.82           C  
HETATM    6  CG  MSE A   1      27.814  39.129  25.388  1.00 49.52           C  
HETATM    7 SE   MSE A   1      28.836  40.770  25.195  1.00 59.52          SE  
HETATM    8  CE  MSE A   1      27.397  42.049  25.384  1.00 56.64           C  
ATOM      9  N   ILE A   2      25.953  37.230  28.463  1.00 30.84           N  
ATOM     10  CA  ILE A   2      24.643  37.442  29.066  1.00 27.01           C  
ATOM     11  C   ILE A   2      24.283  38.924  29.150  1.00 25.95           C  
ATOM     12  O   ILE A   2      23.173  39.278  29.532  1.00 24.49           O  
ATOM     13  CB  ILE A   2      24.583  36.839  30.492  1.00 25.60           C  
ATOM     14  CG1 ILE A   2      25.591  37.536  31.410  1.00 24.64           C  
ATOM     15  CG2 ILE A   2      24.896  35.357  30.433  1.00 25.64           C  
ATOM     16  CD1 ILE A   2      25.500  37.122  32.869  1.00 23.95           C  
ATOM     17  N   TRP A   3      25.223  39.787  28.784  1.00 24.26           N  
ATOM     18  CA  TRP A   3      24.999  41.224  28.835  1.00 24.20           C  
ATOM     19  C   TRP A   3      24.050  41.710  27.750  1.00 23.88           C  
ATOM     20  O   TRP A   3      24.045  41.185  26.639  1.00 22.04           O  
ATOM     21  CB  TRP A   3      26.333  41.960  28.695  1.00 23.76           C  
ATOM     22  CG  TRP A   3      27.427  41.338  29.500  1.00 21.90           C  
ATOM     23  CD1 TRP A   3      28.644  40.936  29.045  1.00 22.56           C  
ATOM     24  CD2 TRP A   3      27.390  41.017  30.894  1.00 23.26           C  
ATOM     25  NE1 TRP A   3      29.373  40.375  30.070  1.00 21.79           N  
ATOM     26  CE2 TRP A   3      28.624  40.413  31.216  1.00 22.26           C  
ATOM     27  CE3 TRP A   3      26.431  41.182  31.906  1.00 22.80           C  
ATOM     28  CZ2 TRP A   3      28.926  39.969  32.511  1.00 22.95           C  
ATOM     29  CZ3 TRP A   3      26.737  40.738  33.200  1.00 23.21           C  
ATOM     30  CH2 TRP A   3      27.972  40.140  33.484  1.00 22.58           C  
ATOM     31  N   LYS A   4      23.246  42.714  28.087  1.00 24.75           N  
ATOM     32  CA  LYS A   4      22.320  43.302  27.128  1.00 25.38           C  
ATOM     33  C   LYS A   4      22.688  44.757  26.871  1.00 25.44           C  
ATOM     34  O   LYS A   4      22.397  45.294  25.802  1.00 26.92           O  
ATOM     35  CB  LYS A   4      20.877  43.213  27.630  1.00 25.23           C  
ATOM     36  CG  LYS A   4      20.248  41.837  27.463  1.00 24.72           C  
ATOM     37  CD  LYS A   4      18.757  41.873  27.748  1.00 25.98           C  
ATOM     38  CE  LYS A   4      18.109  40.526  27.467  1.00 27.82           C  
ATOM     39  NZ  LYS A   4      16.638  40.558  27.715  1.00 30.20           N  
ATOM     40  N   ARG A   5      23.325  45.393  27.853  1.00 24.89           N  
ATOM     41  CA  ARG A   5      23.746  46.788  27.724  1.00 26.32           C  
ATOM     42  C   ARG A   5      25.238  46.847  27.438  1.00 27.37           C  
ATOM     43  O   ARG A   5      26.036  46.216  28.129  1.00 28.49           O  
ATOM     44  CB  ARG A   5      23.482  47.572  29.015  1.00 24.98           C  
ATOM     45  CG  ARG A   5      22.030  47.728  29.408  1.00 22.79           C  
ATOM     46  CD  ARG A   5      21.919  48.462  30.742  1.00 17.41           C  
ATOM     47  NE  ARG A   5      20.603  48.296  31.352  1.00 16.64           N  
ATOM     48  CZ  ARG A   5      19.584  49.140  31.207  1.00 17.48           C  
ATOM     49  NH1 ARG A   5      19.716  50.242  30.473  1.00 14.27           N  
ATOM     50  NH2 ARG A   5      18.422  48.871  31.788  1.00 13.94           N  
ATOM     51  N   LYS A   6      25.612  47.612  26.420  1.00 28.64           N  
ATOM     52  CA  LYS A   6      27.012  47.762  26.063  1.00 28.78           C  
ATOM     53  C   LYS A   6      27.580  48.970  26.808  1.00 28.67           C  
ATOM     54  O   LYS A   6      27.468  50.110  26.352  1.00 27.09           O  
ATOM     55  CB  LYS A   6      27.151  47.944  24.546  1.00 31.85           C  
ATOM     56  CG  LYS A   6      26.889  46.672  23.744  1.00 34.09           C  
ATOM     57  CD  LYS A   6      26.913  46.918  22.232  1.00 36.80           C  
ATOM     58  CE  LYS A   6      25.560  47.388  21.704  1.00 37.21           C  
ATOM     59  NZ  LYS A   6      25.108  48.669  22.313  1.00 40.06           N  
ATOM     60  N   ILE A   7      28.182  48.713  27.964  1.00 27.33           N  
ATOM     61  CA  ILE A   7      28.764  49.776  28.775  1.00 27.08           C  
ATOM     62  C   ILE A   7      30.142  49.362  29.284  1.00 26.36           C  
ATOM     63  O   ILE A   7      30.312  48.265  29.817  1.00 25.91           O  
ATOM     64  CB  ILE A   7      27.844  50.119  29.971  1.00 28.11           C  
ATOM     65  CG1 ILE A   7      28.465  51.234  30.807  1.00 29.17           C  
ATOM     66  CG2 ILE A   7      27.617  48.883  30.831  1.00 31.31           C  
ATOM     67  CD1 ILE A   7      27.562  51.724  31.912  1.00 30.57           C  
ATOM     68  N   THR A   8      31.121  50.248  29.115  1.00 24.51           N  
ATOM     69  CA  THR A   8      32.495  49.971  29.529  1.00 22.04           C  
ATOM     70  C   THR A   8      32.707  50.075  31.035  1.00 21.62           C  
ATOM     71  O   THR A   8      31.915  50.700  31.741  1.00 19.24           O  
ATOM     72  CB  THR A   8      33.492  50.949  28.862  1.00 20.83           C  
ATOM     73  OG1 THR A   8      33.360  52.249  29.458  1.00 19.96           O  
ATOM     74  CG2 THR A   8      33.220  51.053  27.370  1.00 20.49           C  
ATOM     75  N   LEU A   9      33.790  49.465  31.516  1.00 20.31           N  
ATOM     76  CA  LEU A   9      34.133  49.506  32.932  1.00 20.94           C  
ATOM     77  C   LEU A   9      34.380  50.956  33.317  1.00 20.71           C  
ATOM     78  O   LEU A   9      34.069  51.370  34.430  1.00 20.64           O  
ATOM     79  CB  LEU A   9      35.400  48.684  33.208  1.00 20.83           C  
ATOM     80  CG  LEU A   9      35.356  47.197  32.838  1.00 21.11           C  
ATOM     81  CD1 LEU A   9      36.699  46.532  33.155  1.00 22.07           C  
ATOM     82  CD2 LEU A   9      34.232  46.527  33.611  1.00 20.19           C  
ATOM     83  N   GLU A  10      34.946  51.719  32.388  1.00 21.20           N  
ATOM     84  CA  GLU A  10      35.223  53.131  32.627  1.00 21.40           C  
ATOM     85  C   GLU A  10      33.918  53.811  33.028  1.00 20.08           C  
ATOM     86  O   GLU A  10      33.849  54.493  34.048  1.00 17.89           O  
ATOM     87  CB  GLU A  10      35.787  53.775  31.358  1.00 25.50           C  
ATOM     88  CG  GLU A  10      36.206  55.229  31.507  1.00 31.96           C  
ATOM     89  CD  GLU A  10      36.585  55.862  30.177  1.00 35.02           C  
ATOM     90  OE1 GLU A  10      37.068  57.014  30.180  1.00 37.24           O  
ATOM     91  OE2 GLU A  10      36.395  55.210  29.128  1.00 37.49           O  
ATOM     92  N   ALA A  11      32.883  53.604  32.219  1.00 19.06           N  
ATOM     93  CA  ALA A  11      31.566  54.178  32.479  1.00 20.16           C  
ATOM     94  C   ALA A  11      31.006  53.660  33.802  1.00 19.62           C  
ATOM     95  O   ALA A  11      30.429  54.419  34.573  1.00 20.39           O  
ATOM     96  CB  ALA A  11      30.610  53.839  31.336  1.00 19.87           C  
ATOM     97  N   LEU A  12      31.183  52.365  34.057  1.00 20.56           N  
ATOM     98  CA  LEU A  12      30.712  51.738  35.296  1.00 20.32           C  
ATOM     99  C   LEU A  12      31.308  52.438  36.511  1.00 19.65           C  
ATOM    100  O   LEU A  12      30.589  52.848  37.432  1.00 19.53           O  
ATOM    101  CB  LEU A  12      31.109  50.259  35.317  1.00 22.16           C  
ATOM    102  CG  LEU A  12      30.165  49.250  34.659  1.00 22.85           C  
ATOM    103  CD1 LEU A  12      30.936  48.031  34.163  1.00 22.50           C  
ATOM    104  CD2 LEU A  12      29.112  48.839  35.676  1.00 27.47           C  
ATOM    105  N   ASN A  13      32.628  52.567  36.521  1.00 19.32           N  
ATOM    106  CA  ASN A  13      33.297  53.219  37.632  1.00 19.88           C  
ATOM    107  C   ASN A  13      32.861  54.673  37.734  1.00 20.05           C  
ATOM    108  O   ASN A  13      32.675  55.199  38.829  1.00 20.75           O  
ATOM    109  CB  ASN A  13      34.813  53.121  37.459  1.00 20.19           C  
ATOM    110  CG  ASN A  13      35.324  51.720  37.690  1.00 20.18           C  
ATOM    111  OD1 ASN A  13      35.006  51.097  38.703  1.00 20.57           O  
ATOM    112  ND2 ASN A  13      36.118  51.212  36.755  1.00 19.68           N  
ATOM    113  N   ALA A  14      32.687  55.317  36.584  1.00 20.99           N  
ATOM    114  CA  ALA A  14      32.263  56.714  36.548  1.00 21.53           C  
ATOM    115  C   ALA A  14      30.929  56.897  37.270  1.00 21.17           C  
ATOM    116  O   ALA A  14      30.732  57.871  37.995  1.00 21.16           O  
ATOM    117  CB  ALA A  14      32.135  57.177  35.104  1.00 22.00           C  
HETATM  118  N   MSE A  15      30.023  55.946  37.073  1.00 22.47           N  
HETATM  119  CA  MSE A  15      28.699  56.001  37.676  1.00 23.61           C  
HETATM  120  C   MSE A  15      28.693  55.864  39.201  1.00 21.84           C  
HETATM  121  O   MSE A  15      27.706  56.204  39.848  1.00 21.33           O  
HETATM  122  CB  MSE A  15      27.808  54.924  37.053  1.00 27.49           C  
HETATM  123  CG  MSE A  15      27.736  54.996  35.532  1.00 33.18           C  
HETATM  124 SE   MSE A  15      26.515  53.716  34.736  1.00 41.24          SE  
HETATM  125  CE  MSE A  15      27.207  52.098  35.531  1.00 36.97           C  
ATOM    126  N   GLY A  16      29.793  55.375  39.767  1.00 19.44           N  
ATOM    127  CA  GLY A  16      29.882  55.209  41.208  1.00 18.83           C  
ATOM    128  C   GLY A  16      30.376  56.444  41.942  1.00 18.47           C  
ATOM    129  O   GLY A  16      30.240  56.554  43.163  1.00 16.40           O  
ATOM    130  N   GLU A  17      30.964  57.376  41.198  1.00 19.90           N  
ATOM    131  CA  GLU A  17      31.467  58.613  41.782  1.00 20.07           C  
ATOM    132  C   GLU A  17      30.291  59.431  42.306  1.00 19.55           C  
ATOM    133  O   GLU A  17      29.292  59.600  41.612  1.00 19.81           O  
ATOM    134  CB  GLU A  17      32.235  59.418  40.728  1.00 21.33           C  
ATOM    135  CG  GLU A  17      33.456  58.698  40.173  1.00 23.60           C  
ATOM    136  CD  GLU A  17      34.501  58.436  41.245  1.00 23.99           C  
ATOM    137  OE1 GLU A  17      35.034  59.417  41.813  1.00 22.55           O  
ATOM    138  OE2 GLU A  17      34.788  57.249  41.522  1.00 26.15           O  
ATOM    139  N   GLY A  18      30.404  59.929  43.531  1.00 18.50           N  
ATOM    140  CA  GLY A  18      29.325  60.717  44.095  1.00 17.98           C  
ATOM    141  C   GLY A  18      28.389  59.895  44.956  1.00 17.43           C  
ATOM    142  O   GLY A  18      27.478  60.438  45.584  1.00 17.20           O  
ATOM    143  N   ASN A  19      28.595  58.580  44.976  1.00 16.11           N  
ATOM    144  CA  ASN A  19      27.769  57.702  45.798  1.00 14.93           C  
ATOM    145  C   ASN A  19      28.619  56.681  46.558  1.00 14.64           C  
ATOM    146  O   ASN A  19      29.851  56.714  46.480  1.00 13.26           O  
ATOM    147  CB  ASN A  19      26.684  57.022  44.949  1.00 15.88           C  
ATOM    148  CG  ASN A  19      27.232  56.361  43.705  1.00 17.00           C  
ATOM    149  OD1 ASN A  19      27.787  55.265  43.761  1.00 15.88           O  
ATOM    150  ND2 ASN A  19      27.080  57.030  42.567  1.00 15.63           N  
HETATM  151  N   MSE A  20      27.968  55.788  47.301  1.00 14.56           N  
HETATM  152  CA  MSE A  20      28.677  54.793  48.109  1.00 16.55           C  
HETATM  153  C   MSE A  20      29.807  54.026  47.418  1.00 15.12           C  
HETATM  154  O   MSE A  20      30.862  53.811  48.013  1.00 15.18           O  
HETATM  155  CB  MSE A  20      27.686  53.797  48.717  1.00 17.41           C  
HETATM  156  CG  MSE A  20      28.338  52.771  49.638  1.00 17.28           C  
HETATM  157 SE   MSE A  20      27.037  51.924  50.780  1.00 27.31          SE  
HETATM  158  CE  MSE A  20      27.850  52.222  52.505  1.00 18.18           C  
ATOM    159  N   VAL A  21      29.595  53.614  46.173  1.00 15.71           N  
ATOM    160  CA  VAL A  21      30.617  52.876  45.438  1.00 16.96           C  
ATOM    161  C   VAL A  21      31.929  53.651  45.334  1.00 17.53           C  
ATOM    162  O   VAL A  21      33.010  53.111  45.589  1.00 17.20           O  
ATOM    163  CB  VAL A  21      30.125  52.524  44.021  1.00 17.90           C  
ATOM    164  CG1 VAL A  21      31.230  51.846  43.230  1.00 15.40           C  
ATOM    165  CG2 VAL A  21      28.899  51.620  44.118  1.00 20.84           C  
ATOM    166  N   GLY A  22      31.839  54.922  44.965  1.00 18.81           N  
ATOM    167  CA  GLY A  22      33.039  55.735  44.846  1.00 18.02           C  
ATOM    168  C   GLY A  22      33.642  56.043  46.204  1.00 18.27           C  
ATOM    169  O   GLY A  22      34.855  56.107  46.355  1.00 17.67           O  
ATOM    170  N   PHE A  23      32.781  56.224  47.198  1.00 18.88           N  
ATOM    171  CA  PHE A  23      33.211  56.534  48.560  1.00 17.91           C  
ATOM    172  C   PHE A  23      34.093  55.445  49.180  1.00 18.09           C  
ATOM    173  O   PHE A  23      35.012  55.741  49.954  1.00 18.03           O  
ATOM    174  CB  PHE A  23      31.971  56.756  49.425  1.00 18.93           C  
ATOM    175  CG  PHE A  23      32.269  57.121  50.848  1.00 19.31           C  
ATOM    176  CD1 PHE A  23      32.909  58.318  51.162  1.00 19.74           C  
ATOM    177  CD2 PHE A  23      31.883  56.271  51.886  1.00 19.46           C  
ATOM    178  CE1 PHE A  23      33.155  58.669  52.495  1.00 19.95           C  
ATOM    179  CE2 PHE A  23      32.124  56.612  53.223  1.00 18.27           C  
ATOM    180  CZ  PHE A  23      32.763  57.812  53.528  1.00 20.64           C  
ATOM    181  N   LEU A  24      33.803  54.188  48.847  1.00 17.10           N  
ATOM    182  CA  LEU A  24      34.562  53.048  49.364  1.00 14.93           C  
ATOM    183  C   LEU A  24      35.623  52.585  48.367  1.00 15.19           C  
ATOM    184  O   LEU A  24      36.261  51.554  48.563  1.00 17.01           O  
ATOM    185  CB  LEU A  24      33.613  51.883  49.676  1.00 12.60           C  
ATOM    186  CG  LEU A  24      32.554  52.110  50.758  1.00 10.50           C  
ATOM    187  CD1 LEU A  24      31.691  50.862  50.910  1.00  6.75           C  
ATOM    188  CD2 LEU A  24      33.238  52.458  52.072  1.00  6.81           C  
ATOM    189  N   ASP A  25      35.801  53.353  47.298  1.00 15.48           N  
ATOM    190  CA  ASP A  25      36.764  53.036  46.248  1.00 15.94           C  
ATOM    191  C   ASP A  25      36.565  51.636  45.659  1.00 15.92           C  
ATOM    192  O   ASP A  25      37.536  50.917  45.399  1.00 16.07           O  
ATOM    193  CB  ASP A  25      38.207  53.182  46.759  1.00 16.55           C  
ATOM    194  CG  ASP A  25      39.234  53.004  45.653  1.00 17.72           C  
ATOM    195  OD1 ASP A  25      38.994  53.518  44.543  1.00 19.25           O  
ATOM    196  OD2 ASP A  25      40.278  52.360  45.895  1.00 16.53           O  
ATOM    197  N   ILE A  26      35.304  51.246  45.475  1.00 15.28           N  
ATOM    198  CA  ILE A  26      34.975  49.955  44.877  1.00 14.64           C  
ATOM    199  C   ILE A  26      35.174  50.184  43.381  1.00 15.08           C  
ATOM    200  O   ILE A  26      34.588  51.103  42.819  1.00 13.01           O  
ATOM    201  CB  ILE A  26      33.492  49.558  45.146  1.00 14.43           C  
ATOM    202  CG1 ILE A  26      33.311  49.146  46.611  1.00 12.17           C  
ATOM    203  CG2 ILE A  26      33.074  48.423  44.208  1.00 13.64           C  
ATOM    204  CD1 ILE A  26      31.856  49.017  47.050  1.00 13.49           C  
ATOM    205  N   ARG A  27      35.993  49.355  42.742  1.00 15.52           N  
ATOM    206  CA  ARG A  27      36.268  49.525  41.318  1.00 16.91           C  
ATOM    207  C   ARG A  27      36.037  48.273  40.482  1.00 16.39           C  
ATOM    208  O   ARG A  27      36.516  47.193  40.826  1.00 12.02           O  
ATOM    209  CB  ARG A  27      37.725  49.961  41.110  1.00 20.46           C  
ATOM    210  CG  ARG A  27      38.169  51.141  41.946  1.00 25.71           C  
ATOM    211  CD  ARG A  27      39.638  51.453  41.702  1.00 30.89           C  
ATOM    212  NE  ARG A  27      40.444  50.235  41.685  1.00 32.80           N  
ATOM    213  CZ  ARG A  27      41.771  50.206  41.741  1.00 33.19           C  
ATOM    214  NH1 ARG A  27      42.462  51.335  41.821  1.00 32.06           N  
ATOM    215  NH2 ARG A  27      42.408  49.041  41.726  1.00 32.56           N  
ATOM    216  N   PHE A  28      35.315  48.425  39.374  1.00 15.16           N  
ATOM    217  CA  PHE A  28      35.088  47.301  38.480  1.00 15.19           C  
ATOM    218  C   PHE A  28      36.343  47.162  37.632  1.00 17.57           C  
ATOM    219  O   PHE A  28      36.811  48.135  37.034  1.00 18.09           O  
ATOM    220  CB  PHE A  28      33.868  47.549  37.601  1.00 13.05           C  
ATOM    221  CG  PHE A  28      32.575  47.556  38.367  1.00 11.93           C  
ATOM    222  CD1 PHE A  28      32.088  48.729  38.940  1.00 12.72           C  
ATOM    223  CD2 PHE A  28      31.869  46.371  38.564  1.00 13.12           C  
ATOM    224  CE1 PHE A  28      30.914  48.718  39.710  1.00 12.18           C  
ATOM    225  CE2 PHE A  28      30.701  46.346  39.330  1.00  9.95           C  
ATOM    226  CZ  PHE A  28      30.221  47.520  39.899  1.00  9.84           C  
ATOM    227  N   GLU A  29      36.895  45.956  37.581  1.00 19.90           N  
ATOM    228  CA  GLU A  29      38.126  45.739  36.838  1.00 21.07           C  
ATOM    229  C   GLU A  29      38.065  44.731  35.706  1.00 20.79           C  
ATOM    230  O   GLU A  29      38.977  44.678  34.888  1.00 20.28           O  
ATOM    231  CB  GLU A  29      39.236  45.345  37.806  1.00 23.11           C  
ATOM    232  CG  GLU A  29      39.475  46.393  38.884  1.00 28.49           C  
ATOM    233  CD  GLU A  29      40.735  46.157  39.679  1.00 30.11           C  
ATOM    234  OE1 GLU A  29      40.936  46.866  40.688  1.00 30.18           O  
ATOM    235  OE2 GLU A  29      41.526  45.267  39.296  1.00 32.29           O  
ATOM    236  N   HIS A  30      37.004  43.935  35.644  1.00 20.98           N  
ATOM    237  CA  HIS A  30      36.899  42.946  34.583  1.00 22.20           C  
ATOM    238  C   HIS A  30      35.477  42.477  34.344  1.00 22.66           C  
ATOM    239  O   HIS A  30      34.671  42.386  35.268  1.00 22.11           O  
ATOM    240  CB  HIS A  30      37.795  41.739  34.895  1.00 26.71           C  
ATOM    241  CG  HIS A  30      37.690  40.627  33.899  1.00 31.01           C  
ATOM    242  ND1 HIS A  30      36.579  39.812  33.799  1.00 34.86           N  
ATOM    243  CD2 HIS A  30      38.552  40.194  32.947  1.00 33.61           C  
ATOM    244  CE1 HIS A  30      36.764  38.931  32.836  1.00 34.04           C  
ATOM    245  NE2 HIS A  30      37.955  39.140  32.302  1.00 34.55           N  
ATOM    246  N   ILE A  31      35.183  42.194  33.082  1.00 23.46           N  
ATOM    247  CA  ILE A  31      33.879  41.705  32.671  1.00 24.05           C  
ATOM    248  C   ILE A  31      34.118  40.663  31.586  1.00 24.76           C  
ATOM    249  O   ILE A  31      34.822  40.921  30.610  1.00 26.90           O  
ATOM    250  CB  ILE A  31      32.997  42.860  32.132  1.00 24.23           C  
ATOM    251  CG1 ILE A  31      31.640  42.318  31.665  1.00 23.41           C  
ATOM    252  CG2 ILE A  31      33.710  43.577  31.002  1.00 24.20           C  
ATOM    253  CD1 ILE A  31      30.591  43.397  31.448  1.00 21.32           C  
ATOM    254  N   GLY A  32      33.564  39.472  31.781  1.00 26.17           N  
ATOM    255  CA  GLY A  32      33.730  38.407  30.807  1.00 25.73           C  
ATOM    256  C   GLY A  32      32.393  38.093  30.169  1.00 25.40           C  
ATOM    257  O   GLY A  32      31.445  38.861  30.323  1.00 24.63           O  
ATOM    258  N   ASP A  33      32.307  36.980  29.451  1.00 23.88           N  
ATOM    259  CA  ASP A  33      31.058  36.595  28.817  1.00 24.62           C  
ATOM    260  C   ASP A  33      29.935  36.454  29.840  1.00 24.43           C  
ATOM    261  O   ASP A  33      28.792  36.815  29.558  1.00 23.37           O  
ATOM    262  CB  ASP A  33      31.232  35.274  28.070  1.00 27.46           C  
ATOM    263  CG  ASP A  33      32.122  35.409  26.855  1.00 29.95           C  
ATOM    264  OD1 ASP A  33      32.454  34.370  26.246  1.00 33.94           O  
ATOM    265  OD2 ASP A  33      32.479  36.554  26.508  1.00 31.33           O  
ATOM    266  N   ASP A  34      30.258  35.933  31.022  1.00 23.69           N  
ATOM    267  CA  ASP A  34      29.248  35.748  32.061  1.00 23.73           C  
ATOM    268  C   ASP A  34      29.741  36.074  33.467  1.00 22.05           C  
ATOM    269  O   ASP A  34      29.194  35.558  34.439  1.00 24.11           O  
ATOM    270  CB  ASP A  34      28.733  34.306  32.056  1.00 25.69           C  
ATOM    271  CG  ASP A  34      29.703  33.343  32.715  1.00 26.05           C  
ATOM    272  OD1 ASP A  34      30.814  33.164  32.188  1.00 25.15           O  
ATOM    273  OD2 ASP A  34      29.358  32.774  33.771  1.00 29.83           O  
ATOM    274  N   THR A  35      30.766  36.912  33.592  1.00 20.53           N  
ATOM    275  CA  THR A  35      31.270  37.258  34.917  1.00 19.85           C  
ATOM    276  C   THR A  35      31.650  38.730  35.051  1.00 19.97           C  
ATOM    277  O   THR A  35      32.036  39.378  34.076  1.00 19.52           O  
ATOM    278  CB  THR A  35      32.505  36.385  35.305  1.00 21.10           C  
ATOM    279  OG1 THR A  35      33.573  36.613  34.379  1.00 21.12           O  
ATOM    280  CG2 THR A  35      32.146  34.910  35.286  1.00 18.45           C  
ATOM    281  N   LEU A  36      31.524  39.258  36.264  1.00 18.36           N  
ATOM    282  CA  LEU A  36      31.881  40.644  36.525  1.00 17.28           C  
ATOM    283  C   LEU A  36      32.715  40.666  37.801  1.00 19.21           C  
ATOM    284  O   LEU A  36      32.355  40.047  38.803  1.00 19.82           O  
ATOM    285  CB  LEU A  36      30.630  41.507  36.698  1.00 14.69           C  
ATOM    286  CG  LEU A  36      30.862  43.021  36.776  1.00 12.67           C  
ATOM    287  CD1 LEU A  36      31.428  43.527  35.450  1.00 10.27           C  
ATOM    288  CD2 LEU A  36      29.555  43.731  37.091  1.00  9.13           C  
ATOM    289  N   GLU A  37      33.833  41.378  37.755  1.00 20.01           N  
ATOM    290  CA  GLU A  37      34.730  41.466  38.899  1.00 18.88           C  
ATOM    291  C   GLU A  37      35.020  42.903  39.301  1.00 17.08           C  
ATOM    292  O   GLU A  37      35.189  43.779  38.453  1.00 16.94           O  
ATOM    293  CB  GLU A  37      36.046  40.759  38.582  1.00 21.77           C  
ATOM    294  CG  GLU A  37      35.915  39.256  38.371  1.00 25.15           C  
ATOM    295  CD  GLU A  37      37.182  38.652  37.814  1.00 29.11           C  
ATOM    296  OE1 GLU A  37      38.264  38.915  38.387  1.00 31.54           O  
ATOM    297  OE2 GLU A  37      37.102  37.918  36.808  1.00 31.20           O  
ATOM    298  N   ALA A  38      35.071  43.133  40.606  1.00 13.91           N  
ATOM    299  CA  ALA A  38      35.353  44.451  41.151  1.00 13.61           C  
ATOM    300  C   ALA A  38      36.232  44.251  42.375  1.00 13.83           C  
ATOM    301  O   ALA A  38      36.228  43.177  42.975  1.00 13.24           O  
ATOM    302  CB  ALA A  38      34.053  45.154  41.534  1.00 12.50           C  
ATOM    303  N   THR A  39      36.997  45.277  42.731  1.00 13.57           N  
ATOM    304  CA  THR A  39      37.878  45.193  43.885  1.00 13.22           C  
ATOM    305  C   THR A  39      37.500  46.259  44.883  1.00 12.24           C  
ATOM    306  O   THR A  39      36.837  47.237  44.544  1.00 12.30           O  
ATOM    307  CB  THR A  39      39.355  45.397  43.496  1.00 12.11           C  
ATOM    308  OG1 THR A  39      39.514  46.679  42.867  1.00 12.82           O  
ATOM    309  CG2 THR A  39      39.806  44.291  42.556  1.00 12.65           C  
HETATM  310  N   MSE A  40      37.915  46.060  46.124  1.00 11.51           N  
HETATM  311  CA  MSE A  40      37.615  47.016  47.178  1.00 12.99           C  
HETATM  312  C   MSE A  40      38.744  46.985  48.192  1.00 11.82           C  
HETATM  313  O   MSE A  40      39.183  45.918  48.615  1.00 10.10           O  
HETATM  314  CB  MSE A  40      36.280  46.673  47.857  1.00 14.73           C  
HETATM  315  CG  MSE A  40      35.852  47.683  48.914  1.00 18.12           C  
HETATM  316 SE   MSE A  40      34.297  47.172  49.926  1.00 29.06          SE  
HETATM  317  CE  MSE A  40      35.082  45.748  50.957  1.00 26.14           C  
ATOM    318  N   PRO A  41      39.236  48.165  48.592  1.00 13.65           N  
ATOM    319  CA  PRO A  41      40.324  48.232  49.563  1.00 14.37           C  
ATOM    320  C   PRO A  41      39.880  47.903  50.980  1.00 15.54           C  
ATOM    321  O   PRO A  41      38.703  48.022  51.337  1.00 16.39           O  
ATOM    322  CB  PRO A  41      40.798  49.672  49.444  1.00 13.31           C  
ATOM    323  CG  PRO A  41      39.513  50.402  49.224  1.00 15.26           C  
ATOM    324  CD  PRO A  41      38.799  49.518  48.201  1.00 13.04           C  
ATOM    325  N   VAL A  42      40.838  47.466  51.780  1.00 17.14           N  
ATOM    326  CA  VAL A  42      40.580  47.166  53.172  1.00 17.98           C  
ATOM    327  C   VAL A  42      41.277  48.306  53.909  1.00 18.52           C  
ATOM    328  O   VAL A  42      42.411  48.162  54.361  1.00 19.30           O  
ATOM    329  CB  VAL A  42      41.211  45.817  53.573  1.00 18.81           C  
ATOM    330  CG1 VAL A  42      40.876  45.498  55.012  1.00 21.08           C  
ATOM    331  CG2 VAL A  42      40.716  44.714  52.650  1.00 20.82           C  
ATOM    332  N   ASP A  43      40.605  49.451  53.997  1.00 20.93           N  
ATOM    333  CA  ASP A  43      41.172  50.611  54.672  1.00 19.70           C  
ATOM    334  C   ASP A  43      40.257  51.233  55.733  1.00 19.63           C  
ATOM    335  O   ASP A  43      39.265  50.638  56.146  1.00 18.88           O  
ATOM    336  CB  ASP A  43      41.585  51.676  53.644  1.00 21.48           C  
ATOM    337  CG  ASP A  43      40.447  52.088  52.733  1.00 20.80           C  
ATOM    338  OD1 ASP A  43      39.279  52.012  53.160  1.00 21.77           O  
ATOM    339  OD2 ASP A  43      40.724  52.506  51.589  1.00 21.63           O  
ATOM    340  N   SER A  44      40.603  52.441  56.166  1.00 20.13           N  
ATOM    341  CA  SER A  44      39.845  53.140  57.200  1.00 20.38           C  
ATOM    342  C   SER A  44      38.338  53.240  56.971  1.00 19.84           C  
ATOM    343  O   SER A  44      37.567  53.252  57.929  1.00 19.97           O  
ATOM    344  CB  SER A  44      40.416  54.545  57.409  1.00 22.60           C  
ATOM    345  OG  SER A  44      40.429  55.264  56.192  1.00 27.12           O  
ATOM    346  N   ARG A  45      37.917  53.318  55.713  1.00 17.59           N  
ATOM    347  CA  ARG A  45      36.499  53.420  55.411  1.00 17.36           C  
ATOM    348  C   ARG A  45      35.792  52.075  55.288  1.00 14.48           C  
ATOM    349  O   ARG A  45      34.574  52.031  55.140  1.00 14.05           O  
ATOM    350  CB  ARG A  45      36.287  54.221  54.128  1.00 18.25           C  
ATOM    351  CG  ARG A  45      36.486  55.715  54.303  1.00 19.18           C  
ATOM    352  CD  ARG A  45      36.247  56.442  52.987  1.00 19.45           C  
ATOM    353  NE  ARG A  45      36.586  57.854  53.081  1.00 19.94           N  
ATOM    354  CZ  ARG A  45      36.533  58.706  52.062  1.00 20.69           C  
ATOM    355  NH1 ARG A  45      36.863  59.978  52.248  1.00 19.32           N  
ATOM    356  NH2 ARG A  45      36.150  58.284  50.860  1.00 17.05           N  
ATOM    357  N   THR A  46      36.547  50.984  55.355  1.00 13.06           N  
ATOM    358  CA  THR A  46      35.955  49.649  55.236  1.00 16.05           C  
ATOM    359  C   THR A  46      36.304  48.724  56.402  1.00 16.07           C  
ATOM    360  O   THR A  46      35.773  47.614  56.500  1.00 18.57           O  
ATOM    361  CB  THR A  46      36.373  48.963  53.904  1.00 13.65           C  
ATOM    362  OG1 THR A  46      37.801  48.845  53.844  1.00 19.25           O  
ATOM    363  CG2 THR A  46      35.893  49.784  52.707  1.00 15.06           C  
ATOM    364  N   LYS A  47      37.180  49.194  57.286  1.00 17.52           N  
ATOM    365  CA  LYS A  47      37.608  48.425  58.453  1.00 18.48           C  
ATOM    366  C   LYS A  47      36.735  48.629  59.693  1.00 19.23           C  
ATOM    367  O   LYS A  47      36.050  49.645  59.833  1.00 18.02           O  
ATOM    368  CB  LYS A  47      39.047  48.793  58.826  1.00 19.11           C  
ATOM    369  CG  LYS A  47      40.131  48.203  57.943  1.00 17.40           C  
ATOM    370  CD  LYS A  47      41.491  48.701  58.409  1.00 16.39           C  
ATOM    371  CE  LYS A  47      42.630  48.100  57.612  1.00 19.78           C  
ATOM    372  NZ  LYS A  47      43.940  48.676  58.024  1.00 20.56           N  
ATOM    373  N   GLN A  48      36.765  47.642  60.584  1.00 20.84           N  
ATOM    374  CA  GLN A  48      36.026  47.703  61.845  1.00 23.01           C  
ATOM    375  C   GLN A  48      37.003  48.378  62.812  1.00 23.17           C  
ATOM    376  O   GLN A  48      38.147  48.642  62.443  1.00 24.17           O  
ATOM    377  CB  GLN A  48      35.686  46.296  62.337  1.00 25.97           C  
ATOM    378  CG  GLN A  48      36.918  45.436  62.570  1.00 30.51           C  
ATOM    379  CD  GLN A  48      36.624  44.187  63.365  1.00 32.35           C  
ATOM    380  OE1 GLN A  48      37.531  43.426  63.690  1.00 36.53           O  
ATOM    381  NE2 GLN A  48      35.354  43.966  63.684  1.00 34.55           N  
ATOM    382  N   PRO A  49      36.584  48.647  64.059  1.00 22.65           N  
ATOM    383  CA  PRO A  49      37.502  49.305  64.997  1.00 23.49           C  
ATOM    384  C   PRO A  49      38.842  48.606  65.230  1.00 24.33           C  
ATOM    385  O   PRO A  49      39.847  49.262  65.517  1.00 23.60           O  
ATOM    386  CB  PRO A  49      36.679  49.402  66.278  1.00 23.12           C  
ATOM    387  CG  PRO A  49      35.275  49.509  65.770  1.00 22.30           C  
ATOM    388  CD  PRO A  49      35.253  48.472  64.669  1.00 22.78           C  
ATOM    389  N   PHE A  50      38.869  47.285  65.091  1.00 25.75           N  
ATOM    390  CA  PHE A  50      40.094  46.549  65.339  1.00 26.99           C  
ATOM    391  C   PHE A  50      40.956  46.200  64.130  1.00 26.79           C  
ATOM    392  O   PHE A  50      41.752  45.263  64.181  1.00 27.57           O  
ATOM    393  CB  PHE A  50      39.765  45.296  66.146  1.00 30.96           C  
ATOM    394  CG  PHE A  50      39.028  45.591  67.422  1.00 33.21           C  
ATOM    395  CD1 PHE A  50      39.568  46.469  68.366  1.00 34.77           C  
ATOM    396  CD2 PHE A  50      37.799  44.991  67.691  1.00 34.58           C  
ATOM    397  CE1 PHE A  50      38.888  46.756  69.556  1.00 34.71           C  
ATOM    398  CE2 PHE A  50      37.106  45.270  68.882  1.00 36.17           C  
ATOM    399  CZ  PHE A  50      37.660  46.151  69.818  1.00 36.79           C  
ATOM    400  N   GLY A  51      40.795  46.950  63.044  1.00 25.89           N  
ATOM    401  CA  GLY A  51      41.614  46.729  61.863  1.00 24.00           C  
ATOM    402  C   GLY A  51      41.217  45.653  60.874  1.00 23.89           C  
ATOM    403  O   GLY A  51      41.872  45.499  59.843  1.00 23.10           O  
ATOM    404  N   LEU A  52      40.158  44.908  61.173  1.00 23.52           N  
ATOM    405  CA  LEU A  52      39.697  43.863  60.264  1.00 23.31           C  
ATOM    406  C   LEU A  52      38.673  44.456  59.299  1.00 21.63           C  
ATOM    407  O   LEU A  52      37.999  45.428  59.621  1.00 21.34           O  
ATOM    408  CB  LEU A  52      39.044  42.715  61.041  1.00 24.11           C  
ATOM    409  CG  LEU A  52      39.860  41.846  62.009  1.00 25.49           C  
ATOM    410  CD1 LEU A  52      38.919  40.881  62.714  1.00 27.32           C  
ATOM    411  CD2 LEU A  52      40.937  41.077  61.265  1.00 23.73           C  
ATOM    412  N   LEU A  53      38.570  43.866  58.115  1.00 21.98           N  
ATOM    413  CA  LEU A  53      37.610  44.303  57.110  1.00 20.42           C  
ATOM    414  C   LEU A  53      36.213  44.157  57.728  1.00 19.29           C  
ATOM    415  O   LEU A  53      35.884  43.116  58.288  1.00 16.23           O  
ATOM    416  CB  LEU A  53      37.717  43.405  55.873  1.00 21.59           C  
ATOM    417  CG  LEU A  53      37.251  43.918  54.504  1.00 23.66           C  
ATOM    418  CD1 LEU A  53      37.046  42.728  53.579  1.00 24.26           C  
ATOM    419  CD2 LEU A  53      35.963  44.696  54.628  1.00 24.83           C  
ATOM    420  N   HIS A  54      35.396  45.199  57.629  1.00 18.39           N  
ATOM    421  CA  HIS A  54      34.047  45.157  58.182  1.00 15.63           C  
ATOM    422  C   HIS A  54      33.189  44.243  57.303  1.00 15.14           C  
ATOM    423  O   HIS A  54      33.107  44.432  56.090  1.00 14.77           O  
ATOM    424  CB  HIS A  54      33.469  46.573  58.218  1.00 18.18           C  
ATOM    425  CG  HIS A  54      32.213  46.707  59.022  1.00 18.24           C  
ATOM    426  ND1 HIS A  54      31.089  45.950  58.786  1.00 18.87           N  
ATOM    427  CD2 HIS A  54      31.882  47.578  60.007  1.00 18.55           C  
ATOM    428  CE1 HIS A  54      30.115  46.349  59.584  1.00 19.93           C  
ATOM    429  NE2 HIS A  54      30.569  47.336  60.334  1.00 19.24           N  
ATOM    430  N   GLY A  55      32.560  43.248  57.924  1.00 14.92           N  
ATOM    431  CA  GLY A  55      31.724  42.316  57.185  1.00 12.90           C  
ATOM    432  C   GLY A  55      30.685  43.038  56.354  1.00 14.13           C  
ATOM    433  O   GLY A  55      30.288  42.559  55.293  1.00 13.25           O  
ATOM    434  N   GLY A  56      30.238  44.193  56.844  1.00 11.94           N  
ATOM    435  CA  GLY A  56      29.251  44.964  56.112  1.00 11.65           C  
ATOM    436  C   GLY A  56      29.806  45.463  54.793  1.00 11.23           C  
ATOM    437  O   GLY A  56      29.069  45.578  53.803  1.00 12.34           O  
ATOM    438  N   ALA A  57      31.107  45.753  54.776  1.00 11.02           N  
ATOM    439  CA  ALA A  57      31.778  46.243  53.576  1.00 10.85           C  
ATOM    440  C   ALA A  57      31.790  45.173  52.493  1.00 11.04           C  
ATOM    441  O   ALA A  57      31.667  45.478  51.303  1.00 11.31           O  
ATOM    442  CB  ALA A  57      33.215  46.671  53.903  1.00  8.95           C  
ATOM    443  N   SER A  58      31.959  43.923  52.910  1.00 10.06           N  
ATOM    444  CA  SER A  58      31.979  42.811  51.973  1.00 10.62           C  
ATOM    445  C   SER A  58      30.616  42.648  51.305  1.00 10.65           C  
ATOM    446  O   SER A  58      30.533  42.315  50.127  1.00 11.94           O  
ATOM    447  CB  SER A  58      32.356  41.514  52.689  1.00 12.68           C  
ATOM    448  OG  SER A  58      33.679  41.581  53.188  1.00 14.92           O  
ATOM    449  N   VAL A  59      29.543  42.869  52.052  1.00  9.57           N  
ATOM    450  CA  VAL A  59      28.225  42.728  51.456  1.00 10.09           C  
ATOM    451  C   VAL A  59      27.944  43.888  50.506  1.00 12.30           C  
ATOM    452  O   VAL A  59      27.259  43.724  49.491  1.00 11.33           O  
ATOM    453  CB  VAL A  59      27.129  42.667  52.514  1.00  9.01           C  
ATOM    454  CG1 VAL A  59      25.773  42.631  51.839  1.00  6.95           C  
ATOM    455  CG2 VAL A  59      27.319  41.427  53.384  1.00 10.31           C  
ATOM    456  N   VAL A  60      28.466  45.066  50.829  1.00 11.79           N  
ATOM    457  CA  VAL A  60      28.272  46.208  49.950  1.00 11.03           C  
ATOM    458  C   VAL A  60      28.925  45.890  48.607  1.00 11.04           C  
ATOM    459  O   VAL A  60      28.349  46.129  47.545  1.00 11.45           O  
ATOM    460  CB  VAL A  60      28.921  47.475  50.521  1.00 11.38           C  
ATOM    461  CG1 VAL A  60      28.874  48.583  49.485  1.00  8.71           C  
ATOM    462  CG2 VAL A  60      28.198  47.905  51.791  1.00  9.25           C  
ATOM    463  N   LEU A  61      30.135  45.346  48.655  1.00 11.45           N  
ATOM    464  CA  LEU A  61      30.838  44.994  47.430  1.00 13.29           C  
ATOM    465  C   LEU A  61      30.059  43.940  46.655  1.00 14.19           C  
ATOM    466  O   LEU A  61      29.919  44.027  45.430  1.00 12.87           O  
ATOM    467  CB  LEU A  61      32.230  44.457  47.752  1.00 14.12           C  
ATOM    468  CG  LEU A  61      33.035  43.963  46.541  1.00 11.97           C  
ATOM    469  CD1 LEU A  61      33.238  45.096  45.542  1.00 12.59           C  
ATOM    470  CD2 LEU A  61      34.365  43.426  47.026  1.00 12.15           C  
ATOM    471  N   ALA A  62      29.541  42.951  47.380  1.00 13.56           N  
ATOM    472  CA  ALA A  62      28.790  41.866  46.764  1.00 12.80           C  
ATOM    473  C   ALA A  62      27.491  42.365  46.155  1.00 13.57           C  
ATOM    474  O   ALA A  62      27.149  42.006  45.028  1.00 13.55           O  
ATOM    475  CB  ALA A  62      28.508  40.777  47.796  1.00 14.91           C  
ATOM    476  N   GLU A  63      26.759  43.193  46.891  1.00 14.16           N  
ATOM    477  CA  GLU A  63      25.506  43.698  46.365  1.00 13.39           C  
ATOM    478  C   GLU A  63      25.752  44.700  45.247  1.00 10.84           C  
ATOM    479  O   GLU A  63      24.972  44.780  44.305  1.00 11.08           O  
ATOM    480  CB  GLU A  63      24.661  44.346  47.464  1.00 15.82           C  
ATOM    481  CG  GLU A  63      23.219  44.560  47.015  1.00 20.83           C  
ATOM    482  CD  GLU A  63      22.268  44.792  48.161  1.00 22.22           C  
ATOM    483  OE1 GLU A  63      22.405  44.108  49.196  1.00 24.16           O  
ATOM    484  OE2 GLU A  63      21.368  45.651  48.013  1.00 27.70           O  
ATOM    485  N   SER A  64      26.836  45.462  45.346  1.00 12.49           N  
ATOM    486  CA  SER A  64      27.150  46.448  44.316  1.00 11.00           C  
ATOM    487  C   SER A  64      27.417  45.767  42.990  1.00 11.78           C  
ATOM    488  O   SER A  64      26.904  46.195  41.949  1.00 11.11           O  
ATOM    489  CB  SER A  64      28.374  47.279  44.701  1.00  9.35           C  
ATOM    490  OG  SER A  64      28.056  48.200  45.717  1.00 14.05           O  
ATOM    491  N   ILE A  65      28.213  44.700  43.030  1.00  9.59           N  
ATOM    492  CA  ILE A  65      28.568  43.973  41.818  1.00  9.58           C  
ATOM    493  C   ILE A  65      27.356  43.239  41.249  1.00 10.27           C  
ATOM    494  O   ILE A  65      27.057  43.350  40.067  1.00  9.08           O  
ATOM    495  CB  ILE A  65      29.697  42.950  42.090  1.00  9.68           C  
ATOM    496  CG1 ILE A  65      30.937  43.680  42.623  1.00  9.04           C  
ATOM    497  CG2 ILE A  65      30.035  42.190  40.804  1.00  8.20           C  
ATOM    498  CD1 ILE A  65      32.107  42.773  42.943  1.00 10.59           C  
ATOM    499  N   GLY A  66      26.664  42.498  42.108  1.00 10.94           N  
ATOM    500  CA  GLY A  66      25.491  41.757  41.681  1.00 12.07           C  
ATOM    501  C   GLY A  66      24.412  42.602  41.042  1.00 12.05           C  
ATOM    502  O   GLY A  66      23.804  42.191  40.052  1.00 12.27           O  
ATOM    503  N   SER A  67      24.160  43.783  41.593  1.00 12.53           N  
ATOM    504  CA  SER A  67      23.124  44.643  41.033  1.00 14.61           C  
ATOM    505  C   SER A  67      23.502  45.283  39.696  1.00 11.98           C  
ATOM    506  O   SER A  67      22.652  45.419  38.819  1.00  9.36           O  
ATOM    507  CB  SER A  67      22.726  45.719  42.043  1.00 15.26           C  
ATOM    508  OG  SER A  67      23.856  46.436  42.499  1.00 21.26           O  
ATOM    509  N   VAL A  68      24.760  45.681  39.529  1.00 12.59           N  
ATOM    510  CA  VAL A  68      25.148  46.275  38.253  1.00 11.58           C  
ATOM    511  C   VAL A  68      25.182  45.194  37.179  1.00 11.55           C  
ATOM    512  O   VAL A  68      24.833  45.454  36.037  1.00  8.14           O  
ATOM    513  CB  VAL A  68      26.522  46.985  38.321  1.00 16.07           C  
ATOM    514  CG1 VAL A  68      26.457  48.148  39.293  1.00 13.23           C  
ATOM    515  CG2 VAL A  68      27.595  46.017  38.729  1.00 19.36           C  
ATOM    516  N   ALA A  69      25.597  43.982  37.550  1.00 11.16           N  
ATOM    517  CA  ALA A  69      25.633  42.876  36.597  1.00 12.24           C  
ATOM    518  C   ALA A  69      24.202  42.605  36.146  1.00 12.49           C  
ATOM    519  O   ALA A  69      23.933  42.479  34.955  1.00 15.74           O  
ATOM    520  CB  ALA A  69      26.229  41.628  37.249  1.00 11.70           C  
ATOM    521  N   GLY A  70      23.283  42.531  37.105  1.00 12.68           N  
ATOM    522  CA  GLY A  70      21.892  42.295  36.768  1.00 12.76           C  
ATOM    523  C   GLY A  70      21.351  43.393  35.872  1.00 13.65           C  
ATOM    524  O   GLY A  70      20.614  43.133  34.916  1.00 13.96           O  
ATOM    525  N   TYR A  71      21.720  44.629  36.194  1.00 13.40           N  
ATOM    526  CA  TYR A  71      21.304  45.805  35.429  1.00 13.25           C  
ATOM    527  C   TYR A  71      21.842  45.663  34.011  1.00 13.72           C  
ATOM    528  O   TYR A  71      21.127  45.877  33.036  1.00 14.02           O  
ATOM    529  CB  TYR A  71      21.856  47.067  36.100  1.00 13.38           C  
ATOM    530  CG  TYR A  71      21.796  48.322  35.264  1.00 15.87           C  
ATOM    531  CD1 TYR A  71      20.611  49.038  35.115  1.00 16.22           C  
ATOM    532  CD2 TYR A  71      22.942  48.818  34.650  1.00 15.13           C  
ATOM    533  CE1 TYR A  71      20.576  50.235  34.370  1.00 14.34           C  
ATOM    534  CE2 TYR A  71      22.916  50.000  33.909  1.00 14.92           C  
ATOM    535  CZ  TYR A  71      21.737  50.707  33.775  1.00 13.26           C  
ATOM    536  OH  TYR A  71      21.735  51.895  33.074  1.00 10.59           O  
ATOM    537  N   LEU A  72      23.112  45.291  33.901  1.00 15.88           N  
ATOM    538  CA  LEU A  72      23.723  45.093  32.593  1.00 17.21           C  
ATOM    539  C   LEU A  72      22.995  44.001  31.806  1.00 17.82           C  
ATOM    540  O   LEU A  72      23.168  43.887  30.591  1.00 17.38           O  
ATOM    541  CB  LEU A  72      25.201  44.730  32.745  1.00 18.40           C  
ATOM    542  CG  LEU A  72      26.229  45.868  32.690  1.00 19.44           C  
ATOM    543  CD1 LEU A  72      25.716  47.099  33.418  1.00 22.07           C  
ATOM    544  CD2 LEU A  72      27.541  45.383  33.290  1.00 17.83           C  
ATOM    545  N   CYS A  73      22.187  43.190  32.490  1.00 16.58           N  
ATOM    546  CA  CYS A  73      21.441  42.136  31.807  1.00 17.73           C  
ATOM    547  C   CYS A  73      19.997  42.522  31.501  1.00 18.62           C  
ATOM    548  O   CYS A  73      19.169  41.661  31.197  1.00 20.32           O  
ATOM    549  CB  CYS A  73      21.472  40.834  32.616  1.00 15.04           C  
ATOM    550  SG  CYS A  73      23.099  40.043  32.631  1.00 15.68           S  
ATOM    551  N   THR A  74      19.693  43.811  31.610  1.00 18.62           N  
ATOM    552  CA  THR A  74      18.360  44.326  31.295  1.00 18.76           C  
ATOM    553  C   THR A  74      18.518  45.302  30.126  1.00 19.34           C  
ATOM    554  O   THR A  74      19.627  45.474  29.611  1.00 19.63           O  
ATOM    555  CB  THR A  74      17.722  45.066  32.496  1.00 19.19           C  
ATOM    556  OG1 THR A  74      18.564  46.153  32.908  1.00 19.25           O  
ATOM    557  CG2 THR A  74      17.517  44.110  33.656  1.00 17.85           C  
ATOM    558  N   GLU A  75      17.426  45.942  29.714  1.00 20.31           N  
ATOM    559  CA  GLU A  75      17.468  46.881  28.593  1.00 21.31           C  
ATOM    560  C   GLU A  75      16.728  48.195  28.842  1.00 20.33           C  
ATOM    561  O   GLU A  75      15.735  48.238  29.567  1.00 17.31           O  
ATOM    562  CB  GLU A  75      16.879  46.221  27.341  1.00 24.74           C  
ATOM    563  CG  GLU A  75      17.728  45.101  26.761  1.00 30.50           C  
ATOM    564  CD  GLU A  75      16.979  44.278  25.730  1.00 34.09           C  
ATOM    565  OE1 GLU A  75      17.630  43.496  25.000  1.00 36.11           O  
ATOM    566  OE2 GLU A  75      15.736  44.407  25.655  1.00 36.09           O  
ATOM    567  N   GLY A  76      17.232  49.262  28.225  1.00 19.61           N  
ATOM    568  CA  GLY A  76      16.618  50.579  28.334  1.00 22.10           C  
ATOM    569  C   GLY A  76      16.149  51.060  29.693  1.00 22.20           C  
ATOM    570  O   GLY A  76      16.936  51.170  30.631  1.00 22.98           O  
ATOM    571  N   GLU A  77      14.858  51.358  29.798  1.00 23.22           N  
ATOM    572  CA  GLU A  77      14.289  51.856  31.046  1.00 24.58           C  
ATOM    573  C   GLU A  77      14.177  50.807  32.146  1.00 24.00           C  
ATOM    574  O   GLU A  77      13.842  51.133  33.285  1.00 23.15           O  
ATOM    575  CB  GLU A  77      12.912  52.480  30.796  1.00 26.96           C  
ATOM    576  CG  GLU A  77      12.924  53.614  29.782  1.00 28.77           C  
ATOM    577  CD  GLU A  77      11.840  54.638  30.046  1.00 30.78           C  
ATOM    578  OE1 GLU A  77      12.006  55.453  30.978  1.00 30.00           O  
ATOM    579  OE2 GLU A  77      10.817  54.617  29.329  1.00 32.24           O  
ATOM    580  N   GLN A  78      14.443  49.549  31.810  1.00 22.71           N  
ATOM    581  CA  GLN A  78      14.382  48.503  32.819  1.00 20.83           C  
ATOM    582  C   GLN A  78      15.397  48.821  33.904  1.00 21.10           C  
ATOM    583  O   GLN A  78      16.461  49.395  33.636  1.00 20.40           O  
ATOM    584  CB  GLN A  78      14.682  47.135  32.215  1.00 19.52           C  
ATOM    585  CG  GLN A  78      13.477  46.432  31.624  1.00 17.75           C  
ATOM    586  CD  GLN A  78      13.832  45.071  31.071  1.00 17.24           C  
ATOM    587  OE1 GLN A  78      13.039  44.127  31.144  1.00 14.44           O  
ATOM    588  NE2 GLN A  78      15.028  44.962  30.507  1.00 14.16           N  
ATOM    589  N   LYS A  79      15.053  48.454  35.129  1.00 21.21           N  
ATOM    590  CA  LYS A  79      15.909  48.698  36.274  1.00 21.05           C  
ATOM    591  C   LYS A  79      15.935  47.440  37.135  1.00 20.09           C  
ATOM    592  O   LYS A  79      15.039  46.610  37.052  1.00 17.59           O  
ATOM    593  CB  LYS A  79      15.364  49.884  37.076  1.00 22.97           C  
ATOM    594  CG  LYS A  79      16.386  50.505  37.992  1.00 28.85           C  
ATOM    595  CD  LYS A  79      17.624  50.924  37.204  1.00 29.86           C  
ATOM    596  CE  LYS A  79      18.880  50.632  38.003  1.00 31.40           C  
ATOM    597  NZ  LYS A  79      18.945  49.186  38.391  1.00 29.80           N  
ATOM    598  N   VAL A  80      16.966  47.292  37.957  1.00 19.34           N  
ATOM    599  CA  VAL A  80      17.079  46.117  38.815  1.00 18.92           C  
ATOM    600  C   VAL A  80      17.138  46.521  40.283  1.00 18.67           C  
ATOM    601  O   VAL A  80      17.851  47.456  40.648  1.00 18.07           O  
ATOM    602  CB  VAL A  80      18.337  45.292  38.451  1.00 19.52           C  
ATOM    603  CG1 VAL A  80      18.485  44.107  39.388  1.00 19.77           C  
ATOM    604  CG2 VAL A  80      18.231  44.812  37.015  1.00 20.21           C  
ATOM    605  N   VAL A  81      16.382  45.817  41.120  1.00 18.15           N  
ATOM    606  CA  VAL A  81      16.340  46.121  42.545  1.00 16.81           C  
ATOM    607  C   VAL A  81      16.693  44.888  43.366  1.00 15.07           C  
ATOM    608  O   VAL A  81      16.272  43.780  43.038  1.00 16.64           O  
ATOM    609  CB  VAL A  81      14.937  46.597  42.975  1.00 15.99           C  
ATOM    610  CG1 VAL A  81      14.994  47.148  44.383  1.00 20.50           C  
ATOM    611  CG2 VAL A  81      14.420  47.640  42.016  1.00 19.05           C  
ATOM    612  N   GLY A  82      17.472  45.090  44.427  1.00 14.13           N  
ATOM    613  CA  GLY A  82      17.861  43.988  45.289  1.00 11.62           C  
ATOM    614  C   GLY A  82      16.713  43.634  46.207  1.00 13.68           C  
ATOM    615  O   GLY A  82      16.267  44.465  46.995  1.00 14.02           O  
ATOM    616  N   LEU A  83      16.240  42.397  46.104  1.00 12.55           N  
ATOM    617  CA  LEU A  83      15.120  41.910  46.907  1.00 13.20           C  
ATOM    618  C   LEU A  83      15.572  41.176  48.169  1.00 13.83           C  
ATOM    619  O   LEU A  83      15.019  41.360  49.250  1.00 12.86           O  
ATOM    620  CB  LEU A  83      14.277  40.959  46.052  1.00 14.29           C  
ATOM    621  CG  LEU A  83      12.755  41.084  46.024  1.00 16.77           C  
ATOM    622  CD1 LEU A  83      12.334  42.537  45.799  1.00 15.06           C  
ATOM    623  CD2 LEU A  83      12.226  40.179  44.907  1.00 15.10           C  
ATOM    624  N   GLU A  84      16.578  40.329  48.026  1.00 14.39           N  
ATOM    625  CA  GLU A  84      17.064  39.571  49.161  1.00 15.37           C  
ATOM    626  C   GLU A  84      18.525  39.254  48.957  1.00 14.32           C  
ATOM    627  O   GLU A  84      18.929  38.876  47.863  1.00 13.28           O  
ATOM    628  CB  GLU A  84      16.265  38.274  49.291  1.00 17.59           C  
ATOM    629  CG  GLU A  84      17.107  37.052  49.586  1.00 23.39           C  
ATOM    630  CD  GLU A  84      17.479  36.943  51.043  1.00 24.34           C  
ATOM    631  OE1 GLU A  84      18.251  36.029  51.391  1.00 29.62           O  
ATOM    632  OE2 GLU A  84      16.989  37.763  51.845  1.00 29.57           O  
ATOM    633  N   ILE A  85      19.314  39.424  50.014  1.00 13.71           N  
ATOM    634  CA  ILE A  85      20.734  39.129  49.953  1.00 15.65           C  
ATOM    635  C   ILE A  85      21.180  38.418  51.225  1.00 15.47           C  
ATOM    636  O   ILE A  85      20.642  38.657  52.309  1.00 14.52           O  
ATOM    637  CB  ILE A  85      21.581  40.408  49.802  1.00 18.56           C  
ATOM    638  CG1 ILE A  85      23.030  40.033  49.488  1.00 19.61           C  
ATOM    639  CG2 ILE A  85      21.554  41.217  51.102  1.00 15.77           C  
ATOM    640  CD1 ILE A  85      23.874  41.200  49.026  1.00 24.13           C  
ATOM    641  N   ASN A  86      22.145  37.520  51.079  1.00 14.32           N  
ATOM    642  CA  ASN A  86      22.689  36.792  52.219  1.00 13.93           C  
ATOM    643  C   ASN A  86      24.154  36.514  51.934  1.00 13.13           C  
ATOM    644  O   ASN A  86      24.571  36.432  50.776  1.00  9.15           O  
ATOM    645  CB  ASN A  86      21.912  35.480  52.466  1.00 16.81           C  
ATOM    646  CG  ASN A  86      21.848  34.591  51.243  1.00 17.34           C  
ATOM    647  OD1 ASN A  86      22.849  33.996  50.841  1.00 22.19           O  
ATOM    648  ND2 ASN A  86      20.667  34.494  50.642  1.00 17.25           N  
ATOM    649  N   ALA A  87      24.950  36.393  52.988  1.00 11.72           N  
ATOM    650  CA  ALA A  87      26.362  36.144  52.789  1.00  9.71           C  
ATOM    651  C   ALA A  87      26.967  35.388  53.956  1.00 10.49           C  
ATOM    652  O   ALA A  87      26.520  35.521  55.094  1.00  8.79           O  
ATOM    653  CB  ALA A  87      27.094  37.463  52.590  1.00 10.68           C  
ATOM    654  N   ASN A  88      27.974  34.576  53.654  1.00  9.01           N  
ATOM    655  CA  ASN A  88      28.672  33.825  54.680  1.00  9.43           C  
ATOM    656  C   ASN A  88      30.070  34.392  54.845  1.00  9.94           C  
ATOM    657  O   ASN A  88      30.833  34.486  53.884  1.00  9.49           O  
ATOM    658  CB  ASN A  88      28.761  32.346  54.304  1.00  9.82           C  
ATOM    659  CG  ASN A  88      27.473  31.601  54.582  1.00 11.50           C  
ATOM    660  OD1 ASN A  88      27.281  31.037  55.664  1.00 10.05           O  
ATOM    661  ND2 ASN A  88      26.574  31.614  53.614  1.00  7.78           N  
ATOM    662  N   HIS A  89      30.392  34.799  56.065  1.00 10.60           N  
ATOM    663  CA  HIS A  89      31.714  35.322  56.353  1.00 12.99           C  
ATOM    664  C   HIS A  89      32.526  34.114  56.789  1.00 15.37           C  
ATOM    665  O   HIS A  89      32.234  33.492  57.807  1.00 15.26           O  
ATOM    666  CB  HIS A  89      31.635  36.358  57.473  1.00 15.20           C  
ATOM    667  CG  HIS A  89      30.732  37.506  57.154  1.00 15.41           C  
ATOM    668  ND1 HIS A  89      29.610  37.799  57.898  1.00 17.18           N  
ATOM    669  CD2 HIS A  89      30.767  38.417  56.154  1.00 15.99           C  
ATOM    670  CE1 HIS A  89      28.993  38.841  57.369  1.00 17.77           C  
ATOM    671  NE2 HIS A  89      29.676  39.234  56.308  1.00 15.38           N  
ATOM    672  N   VAL A  90      33.541  33.768  56.007  1.00 18.27           N  
ATOM    673  CA  VAL A  90      34.346  32.613  56.339  1.00 20.19           C  
ATOM    674  C   VAL A  90      35.798  32.965  56.624  1.00 21.48           C  
ATOM    675  O   VAL A  90      36.488  32.226  57.307  1.00 21.23           O  
ATOM    676  CB  VAL A  90      34.284  31.561  55.207  1.00 21.69           C  
ATOM    677  CG1 VAL A  90      32.834  31.244  54.875  1.00 21.41           C  
ATOM    678  CG2 VAL A  90      35.009  32.066  53.976  1.00 20.87           C  
ATOM    679  N   ARG A  91      36.258  34.103  56.120  1.00 22.46           N  
ATOM    680  CA  ARG A  91      37.640  34.509  56.333  1.00 24.36           C  
ATOM    681  C   ARG A  91      37.767  36.015  56.514  1.00 24.88           C  
ATOM    682  O   ARG A  91      37.142  36.791  55.797  1.00 23.99           O  
ATOM    683  CB  ARG A  91      38.503  34.069  55.146  1.00 27.74           C  
ATOM    684  CG  ARG A  91      39.972  34.460  55.237  1.00 29.64           C  
ATOM    685  CD  ARG A  91      40.837  33.295  55.684  1.00 32.23           C  
ATOM    686  NE  ARG A  91      40.769  32.176  54.742  1.00 35.09           N  
ATOM    687  CZ  ARG A  91      41.522  31.082  54.819  1.00 35.78           C  
ATOM    688  NH1 ARG A  91      42.412  30.950  55.795  1.00 36.66           N  
ATOM    689  NH2 ARG A  91      41.385  30.116  53.922  1.00 37.76           N  
ATOM    690  N   SER A  92      38.590  36.418  57.473  1.00 26.23           N  
ATOM    691  CA  SER A  92      38.822  37.831  57.736  1.00 26.12           C  
ATOM    692  C   SER A  92      39.881  38.360  56.768  1.00 24.91           C  
ATOM    693  O   SER A  92      40.665  37.590  56.211  1.00 25.58           O  
ATOM    694  CB  SER A  92      39.291  38.022  59.182  1.00 27.77           C  
ATOM    695  OG  SER A  92      40.469  37.275  59.441  1.00 30.30           O  
ATOM    696  N   ALA A  93      39.890  39.673  56.564  1.00 23.39           N  
ATOM    697  CA  ALA A  93      40.853  40.322  55.681  1.00 21.61           C  
ATOM    698  C   ALA A  93      41.380  41.523  56.455  1.00 22.84           C  
ATOM    699  O   ALA A  93      40.621  42.161  57.189  1.00 22.27           O  
ATOM    700  CB  ALA A  93      40.176  40.768  54.398  1.00 18.85           C  
ATOM    701  N   ARG A  94      42.665  41.831  56.303  1.00 23.49           N  
ATOM    702  CA  ARG A  94      43.247  42.944  57.044  1.00 25.76           C  
ATOM    703  C   ARG A  94      43.963  44.010  56.227  1.00 24.24           C  
ATOM    704  O   ARG A  94      44.213  45.103  56.738  1.00 23.36           O  
ATOM    705  CB  ARG A  94      44.229  42.428  58.101  1.00 28.88           C  
ATOM    706  CG  ARG A  94      43.616  41.608  59.218  1.00 33.88           C  
ATOM    707  CD  ARG A  94      43.162  40.239  58.738  1.00 37.50           C  
ATOM    708  NE  ARG A  94      44.227  39.495  58.071  1.00 41.06           N  
ATOM    709  CZ  ARG A  94      45.380  39.151  58.642  1.00 41.69           C  
ATOM    710  NH1 ARG A  94      45.630  39.483  59.904  1.00 41.81           N  
ATOM    711  NH2 ARG A  94      46.284  38.468  57.948  1.00 41.90           N  
ATOM    712  N   GLU A  95      44.298  43.712  54.976  1.00 23.56           N  
ATOM    713  CA  GLU A  95      45.017  44.689  54.162  1.00 23.79           C  
ATOM    714  C   GLU A  95      44.832  44.533  52.657  1.00 21.96           C  
ATOM    715  O   GLU A  95      44.149  43.620  52.192  1.00 23.20           O  
ATOM    716  CB  GLU A  95      46.509  44.633  54.498  1.00 25.90           C  
ATOM    717  CG  GLU A  95      47.101  43.231  54.430  1.00 28.40           C  
ATOM    718  CD  GLU A  95      48.624  43.214  54.557  1.00 30.95           C  
ATOM    719  OE1 GLU A  95      49.314  43.606  53.592  1.00 32.10           O  
ATOM    720  OE2 GLU A  95      49.128  42.815  55.627  1.00 33.10           O  
ATOM    721  N   GLY A  96      45.465  45.425  51.901  1.00 19.70           N  
ATOM    722  CA  GLY A  96      45.369  45.382  50.455  1.00 19.13           C  
ATOM    723  C   GLY A  96      43.940  45.557  49.978  1.00 17.38           C  
ATOM    724  O   GLY A  96      43.152  46.266  50.601  1.00 15.98           O  
ATOM    725  N   ARG A  97      43.605  44.901  48.871  1.00 17.01           N  
ATOM    726  CA  ARG A  97      42.262  44.982  48.310  1.00 15.30           C  
ATOM    727  C   ARG A  97      41.670  43.585  48.162  1.00 15.81           C  
ATOM    728  O   ARG A  97      42.386  42.629  47.857  1.00 14.35           O  
ATOM    729  CB  ARG A  97      42.305  45.641  46.930  1.00 17.53           C  
ATOM    730  CG  ARG A  97      42.965  47.011  46.887  1.00 16.75           C  
ATOM    731  CD  ARG A  97      43.079  47.506  45.456  1.00 17.78           C  
ATOM    732  NE  ARG A  97      41.774  47.763  44.847  1.00 15.50           N  
ATOM    733  CZ  ARG A  97      41.030  48.833  45.104  1.00 16.37           C  
ATOM    734  NH1 ARG A  97      41.462  49.755  45.958  1.00 14.54           N  
ATOM    735  NH2 ARG A  97      39.855  48.982  44.511  1.00 17.25           N  
ATOM    736  N   VAL A  98      40.366  43.463  48.393  1.00 14.21           N  
ATOM    737  CA  VAL A  98      39.693  42.177  48.226  1.00 13.42           C  
ATOM    738  C   VAL A  98      39.090  42.194  46.829  1.00 14.24           C  
ATOM    739  O   VAL A  98      38.871  43.267  46.255  1.00 11.84           O  
ATOM    740  CB  VAL A  98      38.583  41.958  49.274  1.00 14.57           C  
ATOM    741  CG1 VAL A  98      39.215  41.782  50.660  1.00 11.34           C  
ATOM    742  CG2 VAL A  98      37.614  43.132  49.266  1.00 12.63           C  
ATOM    743  N   ARG A  99      38.822  41.014  46.285  1.00 13.89           N  
ATOM    744  CA  ARG A  99      38.290  40.912  44.937  1.00 14.27           C  
ATOM    745  C   ARG A  99      37.002  40.103  44.886  1.00 13.63           C  
ATOM    746  O   ARG A  99      36.960  38.953  45.313  1.00 13.10           O  
ATOM    747  CB  ARG A  99      39.341  40.265  44.036  1.00 17.66           C  
ATOM    748  CG  ARG A  99      39.089  40.429  42.560  1.00 20.46           C  
ATOM    749  CD  ARG A  99      40.127  39.681  41.738  1.00 23.27           C  
ATOM    750  NE  ARG A  99      40.144  40.189  40.372  1.00 28.94           N  
ATOM    751  CZ  ARG A  99      40.671  41.359  40.030  1.00 28.53           C  
ATOM    752  NH1 ARG A  99      41.232  42.124  40.957  1.00 32.81           N  
ATOM    753  NH2 ARG A  99      40.603  41.776  38.777  1.00 29.59           N  
ATOM    754  N   GLY A 100      35.952  40.715  44.352  1.00 14.48           N  
ATOM    755  CA  GLY A 100      34.676  40.034  44.245  1.00 12.42           C  
ATOM    756  C   GLY A 100      34.409  39.595  42.823  1.00 12.56           C  
ATOM    757  O   GLY A 100      34.547  40.384  41.892  1.00 12.81           O  
ATOM    758  N   VAL A 101      34.043  38.329  42.657  1.00 12.32           N  
ATOM    759  CA  VAL A 101      33.746  37.774  41.339  1.00 15.09           C  
ATOM    760  C   VAL A 101      32.270  37.397  41.355  1.00 14.44           C  
ATOM    761  O   VAL A 101      31.841  36.637  42.213  1.00 13.58           O  
ATOM    762  CB  VAL A 101      34.590  36.509  41.060  1.00 16.48           C  
ATOM    763  CG1 VAL A 101      34.378  36.035  39.632  1.00 17.95           C  
ATOM    764  CG2 VAL A 101      36.051  36.804  41.301  1.00 14.79           C  
ATOM    765  N   CYS A 102      31.504  37.933  40.407  1.00 15.47           N  
ATOM    766  CA  CYS A 102      30.065  37.690  40.327  1.00 14.38           C  
ATOM    767  C   CYS A 102      29.674  36.856  39.110  1.00 15.83           C  
ATOM    768  O   CYS A 102      30.088  37.151  37.983  1.00 14.14           O  
ATOM    769  CB  CYS A 102      29.335  39.038  40.294  1.00 16.45           C  
ATOM    770  SG  CYS A 102      27.545  38.958  40.126  1.00 15.56           S  
ATOM    771  N   LYS A 103      28.872  35.817  39.345  1.00 14.19           N  
ATOM    772  CA  LYS A 103      28.420  34.917  38.283  1.00 17.99           C  
ATOM    773  C   LYS A 103      26.912  34.622  38.435  1.00 16.39           C  
ATOM    774  O   LYS A 103      26.392  34.552  39.557  1.00 18.09           O  
ATOM    775  CB  LYS A 103      29.235  33.616  38.359  1.00 20.52           C  
ATOM    776  CG  LYS A 103      28.894  32.558  37.331  1.00 28.05           C  
ATOM    777  CD  LYS A 103      29.563  31.224  37.677  1.00 31.34           C  
ATOM    778  CE  LYS A 103      28.886  30.555  38.871  1.00 32.53           C  
ATOM    779  NZ  LYS A 103      27.473  30.172  38.554  1.00 33.42           N  
ATOM    780  N   PRO A 104      26.193  34.442  37.312  1.00 16.15           N  
ATOM    781  CA  PRO A 104      24.757  34.163  37.414  1.00 15.76           C  
ATOM    782  C   PRO A 104      24.388  32.732  37.810  1.00 16.45           C  
ATOM    783  O   PRO A 104      25.065  31.776  37.434  1.00 14.77           O  
ATOM    784  CB  PRO A 104      24.238  34.515  36.023  1.00 15.48           C  
ATOM    785  CG  PRO A 104      25.369  34.107  35.141  1.00 17.14           C  
ATOM    786  CD  PRO A 104      26.587  34.627  35.899  1.00 15.05           C  
ATOM    787  N   LEU A 105      23.313  32.609  38.586  1.00 15.56           N  
ATOM    788  CA  LEU A 105      22.796  31.315  39.022  1.00 17.14           C  
ATOM    789  C   LEU A 105      21.477  31.090  38.291  1.00 18.08           C  
ATOM    790  O   LEU A 105      21.089  29.954  38.003  1.00 20.18           O  
ATOM    791  CB  LEU A 105      22.542  31.305  40.530  1.00 19.85           C  
ATOM    792  CG  LEU A 105      23.724  31.271  41.505  1.00 22.15           C  
ATOM    793  CD1 LEU A 105      23.167  31.168  42.919  1.00 22.75           C  
ATOM    794  CD2 LEU A 105      24.645  30.091  41.212  1.00 23.00           C  
ATOM    795  N   HIS A 106      20.800  32.197  37.999  1.00 16.05           N  
ATOM    796  CA  HIS A 106      19.528  32.195  37.287  1.00 15.75           C  
ATOM    797  C   HIS A 106      19.246  33.569  36.695  1.00 14.77           C  
ATOM    798  O   HIS A 106      19.362  34.588  37.382  1.00 13.64           O  
ATOM    799  CB  HIS A 106      18.369  31.814  38.214  1.00 17.41           C  
ATOM    800  CG  HIS A 106      17.020  32.010  37.594  1.00 16.19           C  
ATOM    801  ND1 HIS A 106      16.603  31.305  36.486  1.00 15.30           N  
ATOM    802  CD2 HIS A 106      16.011  32.861  37.899  1.00 15.27           C  
ATOM    803  CE1 HIS A 106      15.397  31.712  36.134  1.00 17.18           C  
ATOM    804  NE2 HIS A 106      15.015  32.657  36.978  1.00 17.34           N  
ATOM    805  N   LEU A 107      18.886  33.592  35.418  1.00 14.29           N  
ATOM    806  CA  LEU A 107      18.568  34.840  34.738  1.00 16.15           C  
ATOM    807  C   LEU A 107      17.173  34.729  34.131  1.00 18.05           C  
ATOM    808  O   LEU A 107      16.974  34.031  33.134  1.00 19.32           O  
ATOM    809  CB  LEU A 107      19.597  35.127  33.640  1.00 17.10           C  
ATOM    810  CG  LEU A 107      21.017  35.456  34.120  1.00 17.73           C  
ATOM    811  CD1 LEU A 107      21.940  35.625  32.922  1.00 16.00           C  
ATOM    812  CD2 LEU A 107      20.985  36.724  34.975  1.00 15.25           C  
ATOM    813  N   GLY A 108      16.207  35.414  34.739  1.00 16.26           N  
ATOM    814  CA  GLY A 108      14.849  35.353  34.241  1.00 16.65           C  
ATOM    815  C   GLY A 108      14.334  36.674  33.711  1.00 16.62           C  
ATOM    816  O   GLY A 108      15.047  37.677  33.721  1.00 17.12           O  
ATOM    817  N   SER A 109      13.087  36.667  33.255  1.00 16.32           N  
ATOM    818  CA  SER A 109      12.455  37.860  32.714  1.00 18.47           C  
ATOM    819  C   SER A 109      12.097  38.863  33.802  1.00 17.28           C  
ATOM    820  O   SER A 109      12.042  40.067  33.548  1.00 16.83           O  
ATOM    821  CB  SER A 109      11.186  37.475  31.954  1.00 20.23           C  
ATOM    822  OG  SER A 109      10.308  36.754  32.803  1.00 24.04           O  
ATOM    823  N   ARG A 110      11.851  38.369  35.012  1.00 15.98           N  
ATOM    824  CA  ARG A 110      11.482  39.247  36.111  1.00 15.65           C  
ATOM    825  C   ARG A 110      12.398  39.125  37.330  1.00 12.93           C  
ATOM    826  O   ARG A 110      12.348  39.962  38.226  1.00 13.31           O  
ATOM    827  CB  ARG A 110      10.036  38.976  36.540  1.00 18.59           C  
ATOM    828  CG  ARG A 110       9.061  38.814  35.383  1.00 25.05           C  
ATOM    829  CD  ARG A 110       7.633  38.675  35.886  1.00 28.92           C  
ATOM    830  NE  ARG A 110       7.498  37.634  36.902  1.00 33.22           N  
ATOM    831  CZ  ARG A 110       7.694  36.337  36.685  1.00 34.34           C  
ATOM    832  NH1 ARG A 110       8.040  35.904  35.481  1.00 35.17           N  
ATOM    833  NH2 ARG A 110       7.536  35.469  37.679  1.00 35.86           N  
ATOM    834  N   HIS A 111      13.226  38.086  37.377  1.00 11.28           N  
ATOM    835  CA  HIS A 111      14.118  37.920  38.521  1.00 11.52           C  
ATOM    836  C   HIS A 111      15.454  37.306  38.133  1.00 10.15           C  
ATOM    837  O   HIS A 111      15.567  36.616  37.124  1.00 12.01           O  
ATOM    838  CB  HIS A 111      13.458  37.042  39.586  1.00 11.58           C  
ATOM    839  CG  HIS A 111      12.055  37.444  39.917  1.00 12.27           C  
ATOM    840  ND1 HIS A 111      11.755  38.444  40.818  1.00 13.87           N  
ATOM    841  CD2 HIS A 111      10.871  37.007  39.433  1.00  9.78           C  
ATOM    842  CE1 HIS A 111      10.446  38.601  40.874  1.00 11.62           C  
ATOM    843  NE2 HIS A 111       9.886  37.741  40.044  1.00 12.67           N  
ATOM    844  N   GLN A 112      16.460  37.557  38.960  1.00 10.10           N  
ATOM    845  CA  GLN A 112      17.791  37.026  38.726  1.00 10.62           C  
ATOM    846  C   GLN A 112      18.374  36.568  40.053  1.00 10.10           C  
ATOM    847  O   GLN A 112      17.982  37.044  41.122  1.00 10.81           O  
ATOM    848  CB  GLN A 112      18.711  38.107  38.155  1.00 11.48           C  
ATOM    849  CG  GLN A 112      18.251  38.734  36.873  1.00  9.28           C  
ATOM    850  CD  GLN A 112      18.968  40.040  36.609  1.00 13.20           C  
ATOM    851  OE1 GLN A 112      19.135  40.453  35.457  1.00 12.28           O  
ATOM    852  NE2 GLN A 112      19.390  40.708  37.681  1.00  7.22           N  
ATOM    853  N   VAL A 113      19.310  35.636  39.985  1.00  9.26           N  
ATOM    854  CA  VAL A 113      19.978  35.166  41.182  1.00  9.42           C  
ATOM    855  C   VAL A 113      21.464  35.211  40.846  1.00 11.13           C  
ATOM    856  O   VAL A 113      21.911  34.576  39.888  1.00 10.92           O  
ATOM    857  CB  VAL A 113      19.533  33.737  41.558  1.00 11.98           C  
ATOM    858  CG1 VAL A 113      20.149  33.322  42.904  1.00  8.29           C  
ATOM    859  CG2 VAL A 113      18.011  33.691  41.646  1.00 13.73           C  
ATOM    860  N   TRP A 114      22.211  35.996  41.617  1.00 11.31           N  
ATOM    861  CA  TRP A 114      23.642  36.155  41.414  1.00 10.91           C  
ATOM    862  C   TRP A 114      24.420  35.626  42.601  1.00 11.68           C  
ATOM    863  O   TRP A 114      23.991  35.785  43.746  1.00 11.19           O  
ATOM    864  CB  TRP A 114      24.001  37.639  41.232  1.00 10.61           C  
ATOM    865  CG  TRP A 114      23.359  38.290  40.042  1.00  9.19           C  
ATOM    866  CD1 TRP A 114      22.176  38.961  40.014  1.00  9.91           C  
ATOM    867  CD2 TRP A 114      23.859  38.302  38.704  1.00 11.94           C  
ATOM    868  NE1 TRP A 114      21.902  39.395  38.738  1.00  9.87           N  
ATOM    869  CE2 TRP A 114      22.921  39.001  37.912  1.00 10.79           C  
ATOM    870  CE3 TRP A 114      25.011  37.786  38.093  1.00 10.44           C  
ATOM    871  CZ2 TRP A 114      23.099  39.198  36.540  1.00 10.06           C  
ATOM    872  CZ3 TRP A 114      25.187  37.982  36.723  1.00 12.20           C  
ATOM    873  CH2 TRP A 114      24.234  38.683  35.965  1.00  8.13           C  
ATOM    874  N   GLN A 115      25.571  35.020  42.320  1.00 12.19           N  
ATOM    875  CA  GLN A 115      26.450  34.482  43.350  1.00 12.16           C  
ATOM    876  C   GLN A 115      27.730  35.302  43.311  1.00 12.21           C  
ATOM    877  O   GLN A 115      28.337  35.447  42.247  1.00 10.26           O  
ATOM    878  CB  GLN A 115      26.806  33.023  43.059  1.00 17.05           C  
ATOM    879  CG  GLN A 115      27.686  32.399  44.141  1.00 22.61           C  
ATOM    880  CD  GLN A 115      28.495  31.211  43.640  1.00 26.43           C  
ATOM    881  OE1 GLN A 115      29.392  31.360  42.804  1.00 29.24           O  
ATOM    882  NE2 GLN A 115      28.186  30.027  44.153  1.00 27.04           N  
ATOM    883  N   ILE A 116      28.145  35.843  44.456  1.00  8.63           N  
ATOM    884  CA  ILE A 116      29.360  36.638  44.492  1.00 12.47           C  
ATOM    885  C   ILE A 116      30.383  36.049  45.471  1.00 14.24           C  
ATOM    886  O   ILE A 116      30.088  35.856  46.653  1.00 14.91           O  
ATOM    887  CB  ILE A 116      29.067  38.105  44.904  1.00 11.48           C  
ATOM    888  CG1 ILE A 116      27.974  38.708  44.013  1.00  9.73           C  
ATOM    889  CG2 ILE A 116      30.343  38.928  44.795  1.00 12.13           C  
ATOM    890  CD1 ILE A 116      26.543  38.393  44.448  1.00  4.41           C  
ATOM    891  N   GLU A 117      31.572  35.740  44.966  1.00 14.18           N  
ATOM    892  CA  GLU A 117      32.628  35.193  45.811  1.00 18.37           C  
ATOM    893  C   GLU A 117      33.691  36.272  45.913  1.00 17.34           C  
ATOM    894  O   GLU A 117      34.160  36.787  44.897  1.00 16.50           O  
ATOM    895  CB  GLU A 117      33.237  33.928  45.194  1.00 22.61           C  
ATOM    896  CG  GLU A 117      32.236  32.842  44.811  1.00 28.09           C  
ATOM    897  CD  GLU A 117      31.376  32.390  45.970  1.00 32.85           C  
ATOM    898  OE1 GLU A 117      30.472  33.151  46.374  1.00 36.52           O  
ATOM    899  OE2 GLU A 117      31.609  31.275  46.485  1.00 37.13           O  
ATOM    900  N   ILE A 118      34.055  36.617  47.142  1.00 17.31           N  
ATOM    901  CA  ILE A 118      35.051  37.649  47.389  1.00 17.53           C  
ATOM    902  C   ILE A 118      36.304  37.037  48.018  1.00 17.49           C  
ATOM    903  O   ILE A 118      36.221  36.327  49.022  1.00 16.40           O  
ATOM    904  CB  ILE A 118      34.477  38.732  48.322  1.00 16.76           C  
ATOM    905  CG1 ILE A 118      33.218  39.335  47.693  1.00 15.11           C  
ATOM    906  CG2 ILE A 118      35.518  39.810  48.577  1.00 17.09           C  
ATOM    907  CD1 ILE A 118      32.493  40.325  48.582  1.00 16.96           C  
ATOM    908  N   PHE A 119      37.463  37.335  47.433  1.00 17.54           N  
ATOM    909  CA  PHE A 119      38.730  36.780  47.908  1.00 17.48           C  
ATOM    910  C   PHE A 119      39.735  37.824  48.375  1.00 17.76           C  
ATOM    911  O   PHE A 119      39.710  38.968  47.914  1.00 18.45           O  
ATOM    912  CB  PHE A 119      39.370  35.961  46.794  1.00 16.64           C  
ATOM    913  CG  PHE A 119      38.429  35.000  46.135  1.00 15.73           C  
ATOM    914  CD1 PHE A 119      37.613  35.413  45.080  1.00 15.74           C  
ATOM    915  CD2 PHE A 119      38.355  33.676  46.567  1.00 12.46           C  
ATOM    916  CE1 PHE A 119      36.730  34.514  44.467  1.00 13.92           C  
ATOM    917  CE2 PHE A 119      37.481  32.772  45.967  1.00 11.33           C  
ATOM    918  CZ  PHE A 119      36.671  33.189  44.914  1.00 13.39           C  
ATOM    919  N   ASP A 120      40.633  37.435  49.277  1.00 17.59           N  
ATOM    920  CA  ASP A 120      41.640  38.378  49.748  1.00 19.42           C  
ATOM    921  C   ASP A 120      42.775  38.440  48.728  1.00 19.08           C  
ATOM    922  O   ASP A 120      42.746  37.726  47.721  1.00 19.12           O  
ATOM    923  CB  ASP A 120      42.174  37.980  51.132  1.00 19.09           C  
ATOM    924  CG  ASP A 120      42.783  36.601  51.154  1.00 18.27           C  
ATOM    925  OD1 ASP A 120      43.298  36.150  50.110  1.00 18.41           O  
ATOM    926  OD2 ASP A 120      42.765  35.970  52.233  1.00 18.00           O  
ATOM    927  N   GLU A 121      43.776  39.281  48.976  1.00 19.40           N  
ATOM    928  CA  GLU A 121      44.878  39.416  48.026  1.00 20.65           C  
ATOM    929  C   GLU A 121      45.618  38.113  47.727  1.00 21.50           C  
ATOM    930  O   GLU A 121      46.197  37.961  46.649  1.00 20.58           O  
ATOM    931  CB  GLU A 121      45.877  40.483  48.494  1.00 22.19           C  
ATOM    932  CG  GLU A 121      46.440  40.268  49.887  1.00 24.89           C  
ATOM    933  CD  GLU A 121      47.510  41.283  50.239  1.00 26.37           C  
ATOM    934  OE1 GLU A 121      48.002  41.267  51.388  1.00 29.44           O  
ATOM    935  OE2 GLU A 121      47.866  42.099  49.363  1.00 28.11           O  
ATOM    936  N   LYS A 122      45.594  37.175  48.671  1.00 21.91           N  
ATOM    937  CA  LYS A 122      46.261  35.889  48.481  1.00 22.58           C  
ATOM    938  C   LYS A 122      45.338  34.820  47.889  1.00 22.08           C  
ATOM    939  O   LYS A 122      45.647  33.628  47.932  1.00 21.95           O  
ATOM    940  CB  LYS A 122      46.861  35.398  49.802  1.00 23.88           C  
ATOM    941  CG  LYS A 122      47.972  36.295  50.329  1.00 25.55           C  
ATOM    942  CD  LYS A 122      49.190  35.489  50.753  1.00 29.00           C  
ATOM    943  CE  LYS A 122      48.936  34.686  52.015  1.00 29.92           C  
ATOM    944  NZ  LYS A 122      48.851  35.562  53.210  1.00 31.28           N  
ATOM    945  N   GLY A 123      44.206  35.256  47.341  1.00 21.75           N  
ATOM    946  CA  GLY A 123      43.270  34.341  46.708  1.00 20.08           C  
ATOM    947  C   GLY A 123      42.376  33.472  47.575  1.00 20.24           C  
ATOM    948  O   GLY A 123      41.692  32.594  47.052  1.00 21.52           O  
ATOM    949  N   ARG A 124      42.365  33.704  48.885  1.00 18.88           N  
ATOM    950  CA  ARG A 124      41.536  32.915  49.792  1.00 17.51           C  
ATOM    951  C   ARG A 124      40.114  33.455  49.873  1.00 17.18           C  
ATOM    952  O   ARG A 124      39.902  34.665  49.871  1.00 15.48           O  
ATOM    953  CB  ARG A 124      42.153  32.899  51.193  1.00 17.92           C  
ATOM    954  CG  ARG A 124      43.487  32.169  51.280  1.00 22.22           C  
ATOM    955  CD  ARG A 124      44.155  32.378  52.641  1.00 24.63           C  
ATOM    956  NE  ARG A 124      44.494  33.780  52.878  1.00 27.12           N  
ATOM    957  CZ  ARG A 124      45.179  34.220  53.930  1.00 29.55           C  
ATOM    958  NH1 ARG A 124      45.437  35.515  54.062  1.00 27.02           N  
ATOM    959  NH2 ARG A 124      45.603  33.368  54.857  1.00 30.64           N  
ATOM    960  N   LEU A 125      39.141  32.550  49.948  1.00 16.27           N  
ATOM    961  CA  LEU A 125      37.737  32.947  50.046  1.00 15.70           C  
ATOM    962  C   LEU A 125      37.459  33.619  51.388  1.00 15.87           C  
ATOM    963  O   LEU A 125      37.687  33.023  52.446  1.00 13.64           O  
ATOM    964  CB  LEU A 125      36.834  31.716  49.900  1.00 17.20           C  
ATOM    965  CG  LEU A 125      35.328  31.931  50.090  1.00 18.25           C  
ATOM    966  CD1 LEU A 125      34.821  32.945  49.077  1.00 17.82           C  
ATOM    967  CD2 LEU A 125      34.587  30.607  49.935  1.00 19.14           C  
ATOM    968  N   CYS A 126      36.968  34.857  51.352  1.00 12.96           N  
ATOM    969  CA  CYS A 126      36.658  35.576  52.584  1.00 15.66           C  
ATOM    970  C   CYS A 126      35.156  35.692  52.783  1.00 14.69           C  
ATOM    971  O   CYS A 126      34.664  35.620  53.906  1.00 12.92           O  
ATOM    972  CB  CYS A 126      37.269  36.973  52.568  1.00 15.69           C  
ATOM    973  SG  CYS A 126      39.055  36.972  52.667  1.00 19.59           S  
ATOM    974  N   CYS A 127      34.430  35.868  51.685  1.00 12.42           N  
ATOM    975  CA  CYS A 127      32.989  35.988  51.766  1.00 12.27           C  
ATOM    976  C   CYS A 127      32.328  35.423  50.522  1.00 12.71           C  
ATOM    977  O   CYS A 127      32.791  35.641  49.405  1.00 12.37           O  
ATOM    978  CB  CYS A 127      32.584  37.459  51.943  1.00 11.78           C  
ATOM    979  SG  CYS A 127      30.799  37.748  52.152  1.00 19.75           S  
ATOM    980  N   SER A 128      31.260  34.660  50.730  1.00 14.64           N  
ATOM    981  CA  SER A 128      30.490  34.091  49.633  1.00 13.64           C  
ATOM    982  C   SER A 128      29.076  34.627  49.827  1.00 13.31           C  
ATOM    983  O   SER A 128      28.531  34.577  50.936  1.00 11.71           O  
ATOM    984  CB  SER A 128      30.484  32.563  49.691  1.00 13.64           C  
ATOM    985  OG  SER A 128      29.739  32.045  48.598  1.00 17.58           O  
ATOM    986  N   SER A 129      28.478  35.123  48.754  1.00 12.49           N  
ATOM    987  CA  SER A 129      27.160  35.713  48.856  1.00 12.92           C  
ATOM    988  C   SER A 129      26.237  35.401  47.690  1.00 13.62           C  
ATOM    989  O   SER A 129      26.679  34.999  46.612  1.00 12.25           O  
ATOM    990  CB  SER A 129      27.318  37.234  49.003  1.00 14.15           C  
ATOM    991  OG  SER A 129      26.109  37.930  48.750  1.00 15.92           O  
ATOM    992  N   ARG A 130      24.942  35.572  47.929  1.00 11.96           N  
ATOM    993  CA  ARG A 130      23.945  35.353  46.891  1.00 13.89           C  
ATOM    994  C   ARG A 130      22.956  36.520  46.939  1.00 12.80           C  
ATOM    995  O   ARG A 130      22.478  36.895  48.018  1.00 12.55           O  
ATOM    996  CB  ARG A 130      23.195  34.036  47.108  1.00 13.86           C  
ATOM    997  CG  ARG A 130      22.123  33.782  46.058  1.00 17.76           C  
ATOM    998  CD  ARG A 130      21.246  32.568  46.365  1.00 18.93           C  
ATOM    999  NE  ARG A 130      21.918  31.284  46.167  1.00 22.21           N  
ATOM   1000  CZ  ARG A 130      21.287  30.112  46.194  1.00 22.38           C  
ATOM   1001  NH1 ARG A 130      19.978  30.075  46.410  1.00 21.33           N  
ATOM   1002  NH2 ARG A 130      21.952  28.978  46.009  1.00 17.62           N  
ATOM   1003  N   LEU A 131      22.674  37.097  45.775  1.00 10.58           N  
ATOM   1004  CA  LEU A 131      21.745  38.215  45.661  1.00 10.44           C  
ATOM   1005  C   LEU A 131      20.576  37.850  44.744  1.00 11.37           C  
ATOM   1006  O   LEU A 131      20.764  37.267  43.669  1.00  8.31           O  
ATOM   1007  CB  LEU A 131      22.459  39.444  45.099  1.00  9.98           C  
ATOM   1008  CG  LEU A 131      21.592  40.682  44.827  1.00 10.43           C  
ATOM   1009  CD1 LEU A 131      21.162  41.284  46.156  1.00 10.82           C  
ATOM   1010  CD2 LEU A 131      22.368  41.711  44.001  1.00  6.65           C  
ATOM   1011  N   THR A 132      19.373  38.208  45.184  1.00  9.99           N  
ATOM   1012  CA  THR A 132      18.149  37.941  44.437  1.00 11.17           C  
ATOM   1013  C   THR A 132      17.601  39.292  44.026  1.00 10.83           C  
ATOM   1014  O   THR A 132      17.388  40.165  44.866  1.00 12.53           O  
ATOM   1015  CB  THR A 132      17.111  37.206  45.318  1.00  9.56           C  
ATOM   1016  OG1 THR A 132      17.623  35.916  45.682  1.00 12.16           O  
ATOM   1017  CG2 THR A 132      15.799  37.028  44.577  1.00 10.28           C  
ATOM   1018  N   THR A 133      17.375  39.460  42.731  1.00  9.56           N  
ATOM   1019  CA  THR A 133      16.884  40.721  42.203  1.00  8.46           C  
ATOM   1020  C   THR A 133      15.551  40.611  41.479  1.00  9.95           C  
ATOM   1021  O   THR A 133      15.129  39.530  41.053  1.00  7.77           O  
ATOM   1022  CB  THR A 133      17.860  41.296  41.178  1.00  9.99           C  
ATOM   1023  OG1 THR A 133      17.940  40.385  40.079  1.00  7.36           O  
ATOM   1024  CG2 THR A 133      19.251  41.465  41.768  1.00  6.50           C  
ATOM   1025  N   ALA A 134      14.911  41.765  41.341  1.00 10.64           N  
ATOM   1026  CA  ALA A 134      13.658  41.883  40.633  1.00 10.85           C  
ATOM   1027  C   ALA A 134      13.947  42.863  39.502  1.00 11.44           C  
ATOM   1028  O   ALA A 134      14.682  43.832  39.688  1.00 11.03           O  
ATOM   1029  CB  ALA A 134      12.567  42.446  41.538  1.00 10.72           C  
ATOM   1030  N   ILE A 135      13.389  42.592  38.331  1.00 13.36           N  
ATOM   1031  CA  ILE A 135      13.563  43.461  37.172  1.00 17.12           C  
ATOM   1032  C   ILE A 135      12.277  44.267  37.108  1.00 18.42           C  
ATOM   1033  O   ILE A 135      11.195  43.687  37.073  1.00 16.30           O  
ATOM   1034  CB  ILE A 135      13.681  42.649  35.864  1.00 17.64           C  
ATOM   1035  CG1 ILE A 135      14.749  41.565  36.006  1.00 19.38           C  
ATOM   1036  CG2 ILE A 135      14.038  43.575  34.713  1.00 17.38           C  
ATOM   1037  CD1 ILE A 135      16.134  42.107  36.288  1.00 24.32           C  
ATOM   1038  N   LEU A 136      12.384  45.592  37.099  1.00 19.82           N  
ATOM   1039  CA  LEU A 136      11.190  46.433  37.062  1.00 22.57           C  
ATOM   1040  C   LEU A 136      11.235  47.540  36.018  1.00 22.92           C  
ATOM   1041  O   LEU A 136      12.294  47.910  35.523  1.00 21.35           O  
ATOM   1042  CB  LEU A 136      10.970  47.065  38.441  1.00 23.98           C  
ATOM   1043  CG  LEU A 136      10.919  46.110  39.631  1.00 24.97           C  
ATOM   1044  CD1 LEU A 136      10.947  46.907  40.920  1.00 25.44           C  
ATOM   1045  CD2 LEU A 136       9.665  45.256  39.555  1.00 25.96           C  
ATOM   1046  N   LEU A 137      10.058  48.062  35.694  1.00 26.77           N  
ATOM   1047  CA  LEU A 137       9.922  49.158  34.743  1.00 31.06           C  
ATOM   1048  C   LEU A 137       8.985  50.203  35.342  1.00 33.82           C  
ATOM   1049  O   LEU A 137       7.767  50.022  35.350  1.00 34.30           O  
ATOM   1050  CB  LEU A 137       9.341  48.675  33.409  1.00 30.84           C  
ATOM   1051  CG  LEU A 137      10.199  47.825  32.468  1.00 33.10           C  
ATOM   1052  CD1 LEU A 137      10.092  46.345  32.835  1.00 32.82           C  
ATOM   1053  CD2 LEU A 137       9.718  48.049  31.041  1.00 31.11           C  
ATOM   1054  N   GLU A 138       9.554  51.284  35.861  1.00 36.75           N  
ATOM   1055  CA  GLU A 138       8.751  52.357  36.440  1.00 40.86           C  
ATOM   1056  C   GLU A 138       9.186  53.716  35.909  1.00 42.10           C  
ATOM   1057  O   GLU A 138       9.839  53.746  34.839  1.00 42.92           O  
ATOM   1058  CB  GLU A 138       8.834  52.341  37.969  1.00 42.10           C  
ATOM   1059  CG  GLU A 138       7.907  51.335  38.639  1.00 44.01           C  
ATOM   1060  CD  GLU A 138       7.871  51.488  40.150  1.00 44.42           C  
ATOM   1061  OE1 GLU A 138       8.926  51.287  40.791  1.00 44.40           O  
ATOM   1062  OE2 GLU A 138       6.792  51.811  40.696  1.00 44.65           O  
TER    1063      GLU A 138                                                      
END
MOLECULE T0479.pdb
ATOM      1  N   THR     6      34.108  56.591  39.835  1.00 82.67           N  
ATOM      2  CA  THR     6      32.687  57.041  39.783  1.00 84.71           C  
ATOM      3  C   THR     6      31.847  56.242  38.792  1.00 84.83           C  
ATOM      4  O   THR     6      30.746  55.797  39.120  1.00 87.33           O  
ATOM      5  CB  THR     6      32.594  58.552  39.443  1.00 84.63           C  
ATOM      6  OG1 THR     6      32.669  59.310  40.659  1.00 80.59           O  
ATOM      7  CG2 THR     6      31.288  58.884  38.714  1.00 85.06           C  
ATOM      8  N   ASP     7      32.357  56.052  37.583  1.00 82.92           N  
ATOM      9  CA  ASP     7      31.608  55.292  36.597  1.00 82.53           C  
ATOM     10  C   ASP     7      31.505  53.876  37.126  1.00 82.43           C  
ATOM     11  O   ASP     7      32.507  53.164  37.202  1.00 83.40           O  
ATOM     12  CB  ASP     7      32.337  55.281  35.254  1.00 83.34           C  
ATOM     13  CG  ASP     7      31.398  55.058  34.080  1.00 83.13           C  
ATOM     14  OD1 ASP     7      31.411  55.902  33.161  1.00 90.62           O  
ATOM     15  OD2 ASP     7      30.652  54.052  34.068  1.00 82.94           O  
ATOM     16  N   PHE     8      30.302  53.477  37.524  1.00 81.00           N  
ATOM     17  CA  PHE     8      30.095  52.129  38.022  1.00 78.25           C  
ATOM     18  C   PHE     8      29.206  51.420  37.035  1.00 78.12           C  
ATOM     19  O   PHE     8      27.993  51.364  37.192  1.00 78.37           O  
ATOM     20  CB  PHE     8      29.455  52.141  39.411  1.00 77.96           C  
ATOM     21  CG  PHE     8      30.418  52.466  40.517  1.00 75.33           C  
ATOM     22  CD1 PHE     8      30.264  53.616  41.272  1.00 73.58           C  
ATOM     23  CD2 PHE     8      31.496  51.628  40.791  1.00 69.75           C  
ATOM     24  CE1 PHE     8      31.172  53.932  42.287  1.00 72.35           C  
ATOM     25  CE2 PHE     8      32.404  51.929  41.799  1.00 67.03           C  
ATOM     26  CZ  PHE     8      32.243  53.085  42.549  1.00 69.31           C  
ATOM     27  N   PHE     9      29.835  50.909  35.989  1.00 79.06           N  
ATOM     28  CA  PHE     9      29.150  50.169  34.948  1.00 79.09           C  
ATOM     29  C   PHE     9      27.978  50.911  34.325  1.00 79.86           C  
ATOM     30  O   PHE     9      26.979  50.298  33.945  1.00 80.70           O  
ATOM     31  CB  PHE     9      28.690  48.836  35.517  1.00 79.01           C  
ATOM     32  CG  PHE     9      29.776  48.084  36.228  1.00 77.86           C  
ATOM     33  CD1 PHE     9      30.883  47.602  35.536  1.00 80.20           C  
ATOM     34  CD2 PHE     9      29.691  47.850  37.594  1.00 75.84           C  
ATOM     35  CE1 PHE     9      31.889  46.890  36.201  1.00 77.51           C  
ATOM     36  CE2 PHE     9      30.689  47.142  38.263  1.00 74.21           C  
ATOM     37  CZ  PHE     9      31.788  46.661  37.567  1.00 74.96           C  
ATOM     38  N   GLY    10      28.102  52.230  34.216  1.00 81.37           N  
ATOM     39  CA  GLY    10      27.041  53.016  33.610  1.00 81.99           C  
ATOM     40  C   GLY    10      26.223  53.898  34.534  1.00 82.45           C  
ATOM     41  O   GLY    10      25.148  54.363  34.148  1.00 83.24           O  
ATOM     42  N   LEU    11      26.724  54.138  35.742  1.00 81.84           N  
ATOM     43  CA  LEU    11      26.015  54.971  36.704  1.00 80.93           C  
ATOM     44  C   LEU    11      26.885  55.422  37.864  1.00 81.11           C  
ATOM     45  O   LEU    11      27.854  54.752  38.224  1.00 81.55           O  
ATOM     46  CB  LEU    11      24.792  54.226  37.245  1.00 82.16           C  
ATOM     47  CG  LEU    11      24.869  52.706  37.388  1.00 80.12           C  
ATOM     48  CD1 LEU    11      24.789  52.279  38.854  1.00 80.11           C  
ATOM     49  CD2 LEU    11      23.717  52.108  36.594  1.00 78.58           C  
ATOM     50  N   THR    12      26.541  56.567  38.444  1.00 81.94           N  
ATOM     51  CA  THR    12      27.287  57.083  39.583  1.00 81.54           C  
ATOM     52  C   THR    12      26.555  56.700  40.869  1.00 80.32           C  
ATOM     53  O   THR    12      25.343  56.884  40.994  1.00 80.81           O  
ATOM     54  CB  THR    12      27.491  58.640  39.490  1.00 82.25           C  
ATOM     55  OG1 THR    12      27.647  59.186  40.808  1.00 81.93           O  
ATOM     56  CG2 THR    12      26.328  59.308  38.779  1.00 80.77           C  
ATOM     57  N   ILE    13      27.311  56.133  41.803  1.00 78.25           N  
ATOM     58  CA  ILE    13      26.793  55.681  43.085  1.00 73.63           C  
ATOM     59  C   ILE    13      27.597  56.362  44.187  1.00 72.82           C  
ATOM     60  O   ILE    13      28.654  55.878  44.583  1.00 73.86           O  
ATOM     61  CB  ILE    13      26.945  54.157  43.209  1.00 72.50           C  
ATOM     62  CG1 ILE    13      26.386  53.476  41.959  1.00 70.72           C  
ATOM     63  CG2 ILE    13      26.218  53.660  44.444  1.00 69.64           C  
ATOM     64  CD1 ILE    13      26.615  51.973  41.912  1.00 66.94           C  
ATOM     65  N   PRO    14      27.097  57.496  44.701  1.00 71.54           N  
ATOM     66  CA  PRO    14      27.744  58.277  45.759  1.00 70.83           C  
ATOM     67  C   PRO    14      28.279  57.487  46.948  1.00 70.92           C  
ATOM     68  O   PRO    14      29.261  57.894  47.573  1.00 72.37           O  
ATOM     69  CB  PRO    14      26.659  59.259  46.170  1.00 70.62           C  
ATOM     70  CG  PRO    14      25.953  59.505  44.881  1.00 70.49           C  
ATOM     71  CD  PRO    14      25.818  58.114  44.315  1.00 70.58           C  
ATOM     72  N   PHE    15      27.644  56.369  47.277  1.00 70.30           N  
ATOM     73  CA  PHE    15      28.112  55.580  48.413  1.00 68.63           C  
ATOM     74  C   PHE    15      29.290  54.712  47.992  1.00 69.27           C  
ATOM     75  O   PHE    15      30.270  54.582  48.727  1.00 68.96           O  
ATOM     76  CB  PHE    15      26.985  54.703  48.979  1.00 66.76           C  
ATOM     77  CG  PHE    15      27.407  53.863  50.158  1.00 62.75           C  
ATOM     78  CD1 PHE    15      27.964  54.455  51.288  1.00 65.47           C  
ATOM     79  CD2 PHE    15      27.258  52.480  50.135  1.00 60.04           C  
ATOM     80  CE1 PHE    15      28.366  53.683  52.381  1.00 63.65           C  
ATOM     81  CE2 PHE    15      27.656  51.697  51.219  1.00 59.43           C  
ATOM     82  CZ  PHE    15      28.212  52.301  52.347  1.00 57.78           C  
ATOM     83  N   MET    16      29.191  54.120  46.806  1.00 68.50           N  
ATOM     84  CA  MET    16      30.266  53.276  46.314  1.00 69.92           C  
ATOM     85  C   MET    16      31.532  54.105  46.109  1.00 70.28           C  
ATOM     86  O   MET    16      32.628  53.687  46.484  1.00 69.63           O  
ATOM     87  CB  MET    16      29.843  52.593  45.012  1.00 68.25           C  
ATOM     88  CG  MET    16      28.836  51.462  45.210  1.00 71.30           C  
ATOM     89  SD  MET    16      29.518  49.996  46.318  1.00 82.26          SE  
ATOM     90  CE  MET    16      28.397  50.232  47.881  1.00 81.23           C  
ATOM     91  N   GLN    17      31.367  55.287  45.525  1.00 71.35           N  
ATOM     92  CA  GLN    17      32.486  56.187  45.280  1.00 73.14           C  
ATOM     93  C   GLN    17      33.152  56.495  46.615  1.00 72.71           C  
ATOM     94  O   GLN    17      34.353  56.744  46.677  1.00 72.94           O  
ATOM     95  CB  GLN    17      31.983  57.490  44.639  1.00 74.17           C  
ATOM     96  CG  GLN    17      33.075  58.494  44.271  1.00 78.87           C  
ATOM     97  CD  GLN    17      32.597  59.942  44.333  1.00 85.45           C  
ATOM     98  OE1 GLN    17      31.612  60.318  43.696  1.00 90.09           O  
ATOM     99  NE2 GLN    17      33.302  60.762  45.105  1.00 86.55           N  
ATOM    100  N   LEU    18      32.356  56.466  47.683  1.00 72.85           N  
ATOM    101  CA  LEU    18      32.837  56.759  49.032  1.00 71.27           C  
ATOM    102  C   LEU    18      33.668  55.626  49.622  1.00 71.30           C  
ATOM    103  O   LEU    18      34.567  55.862  50.431  1.00 70.93           O  
ATOM    104  CB  LEU    18      31.647  57.058  49.950  1.00 70.66           C  
ATOM    105  CG  LEU    18      31.844  57.860  51.244  1.00 69.80           C  
ATOM    106  CD1 LEU    18      31.930  56.948  52.446  1.00 73.18           C  
ATOM    107  CD2 LEU    18      33.078  58.730  51.117  1.00 67.63           C  
ATOM    108  N   LEU    19      33.362  54.396  49.214  1.00 71.25           N  
ATOM    109  CA  LEU    19      34.081  53.224  49.701  1.00 71.47           C  
ATOM    110  C   LEU    19      35.415  53.043  48.998  1.00 73.05           C  
ATOM    111  O   LEU    19      36.224  52.201  49.390  1.00 73.88           O  
ATOM    112  CB  LEU    19      33.246  51.963  49.496  1.00 70.20           C  
ATOM    113  CG  LEU    19      32.009  51.732  50.363  1.00 69.28           C  
ATOM    114  CD1 LEU    19      31.332  50.437  49.937  1.00 64.95           C  
ATOM    115  CD2 LEU    19      32.405  51.662  51.830  1.00 66.56           C  
ATOM    116  N   GLY    20      35.643  53.827  47.951  1.00 74.73           N  
ATOM    117  CA  GLY    20      36.885  53.704  47.211  1.00 75.28           C  
ATOM    118  C   GLY    20      36.969  52.336  46.555  1.00 76.69           C  
ATOM    119  O   GLY    20      37.965  51.628  46.709  1.00 76.35           O  
ATOM    120  N   VAL    21      35.913  51.954  45.839  1.00 75.90           N  
ATOM    121  CA  VAL    21      35.890  50.665  45.161  1.00 74.91           C  
ATOM    122  C   VAL    21      36.060  50.871  43.656  1.00 74.23           C  
ATOM    123  O   VAL    21      35.609  51.876  43.102  1.00 74.26           O  
ATOM    124  CB  VAL    21      34.569  49.882  45.455  1.00 75.48           C  
ATOM    125  CG1 VAL    21      33.353  50.705  45.059  1.00 75.56           C  
ATOM    126  CG2 VAL    21      34.576  48.554  44.708  1.00 75.52           C  
ATOM    127  N   VAL    22      36.712  49.920  42.997  1.00 73.26           N  
ATOM    128  CA  VAL    22      36.955  50.026  41.563  1.00 71.22           C  
ATOM    129  C   VAL    22      36.297  48.933  40.714  1.00 69.51           C  
ATOM    130  O   VAL    22      36.493  47.745  40.956  1.00 69.28           O  
ATOM    131  CB  VAL    22      38.481  50.019  41.277  1.00 71.44           C  
ATOM    132  CG1 VAL    22      38.734  50.139  39.788  1.00 72.67           C  
ATOM    133  CG2 VAL    22      39.153  51.152  42.024  1.00 68.35           C  
ATOM    134  N   PRO    23      35.488  49.332  39.713  1.00 68.68           N  
ATOM    135  CA  PRO    23      34.795  48.412  38.803  1.00 69.35           C  
ATOM    136  C   PRO    23      35.821  47.787  37.856  1.00 70.07           C  
ATOM    137  O   PRO    23      36.584  48.493  37.208  1.00 70.33           O  
ATOM    138  CB  PRO    23      33.787  49.320  38.085  1.00 68.77           C  
ATOM    139  CG  PRO    23      34.445  50.640  38.103  1.00 69.37           C  
ATOM    140  CD  PRO    23      35.035  50.715  39.491  1.00 68.21           C  
ATOM    141  N   GLU    24      35.827  46.463  37.774  1.00 71.08           N  
ATOM    142  CA  GLU    24      36.811  45.762  36.956  1.00 71.52           C  
ATOM    143  C   GLU    24      36.266  45.026  35.724  1.00 71.28           C  
ATOM    144  O   GLU    24      37.016  44.737  34.787  1.00 72.41           O  
ATOM    145  CB  GLU    24      37.571  44.789  37.863  1.00 71.19           C  
ATOM    146  CG  GLU    24      39.055  44.645  37.574  1.00 74.13           C  
ATOM    147  CD  GLU    24      39.917  44.750  38.828  1.00 77.25           C  
ATOM    148  OE1 GLU    24      40.224  45.885  39.255  1.00 83.15           O  
ATOM    149  OE2 GLU    24      40.295  43.699  39.387  1.00 77.85           O  
ATOM    150  N   HIS    25      34.967  44.735  35.719  1.00 70.76           N  
ATOM    151  CA  HIS    25      34.342  44.017  34.613  1.00 68.54           C  
ATOM    152  C   HIS    25      32.855  43.809  34.849  1.00 68.40           C  
ATOM    153  O   HIS    25      32.388  43.788  35.984  1.00 69.03           O  
ATOM    154  CB  HIS    25      35.002  42.646  34.430  1.00 67.13           C  
ATOM    155  CG  HIS    25      34.233  41.710  33.551  1.00 66.67           C  
ATOM    156  ND1 HIS    25      34.002  40.394  33.883  1.00 64.69           N  
ATOM    157  CD2 HIS    25      33.623  41.902  32.352  1.00 67.64           C  
ATOM    158  CE1 HIS    25      33.284  39.814  32.935  1.00 66.58           C  
ATOM    159  NE2 HIS    25      33.043  40.713  31.996  1.00 67.15           N  
ATOM    160  N   SER    26      32.122  43.645  33.755  1.00 68.39           N  
ATOM    161  CA  SER    26      30.692  43.402  33.785  1.00 67.02           C  
ATOM    162  C   SER    26      30.240  43.026  32.388  1.00 66.04           C  
ATOM    163  O   SER    26      30.387  43.804  31.449  1.00 68.32           O  
ATOM    164  CB  SER    26      29.936  44.647  34.243  1.00 68.40           C  
ATOM    165  OG  SER    26      28.563  44.537  33.896  1.00 69.94           O  
ATOM    166  N   GLY    27      29.690  41.828  32.252  1.00 63.41           N  
ATOM    167  CA  GLY    27      29.224  41.394  30.954  1.00 59.63           C  
ATOM    168  C   GLY    27      29.182  39.889  30.902  1.00 57.60           C  
ATOM    169  O   GLY    27      29.900  39.221  31.635  1.00 59.65           O  
ATOM    170  N   ASN    28      28.337  39.354  30.032  1.00 58.55           N  
ATOM    171  CA  ASN    28      28.200  37.912  29.878  1.00 59.88           C  
ATOM    172  C   ASN    28      27.865  37.168  31.165  1.00 60.45           C  
ATOM    173  O   ASN    28      28.385  36.085  31.409  1.00 58.08           O  
ATOM    174  CB  ASN    28      29.481  37.352  29.275  1.00 61.54           C  
ATOM    175  CG  ASN    28      29.808  37.982  27.943  1.00 59.96           C  
ATOM    176  OD1 ASN    28      29.020  37.900  27.004  1.00 57.88           O  
ATOM    177  ND2 ASN    28      30.971  38.636  27.858  1.00 52.70           N  
ATOM    178  N   GLY    29      27.005  37.764  31.984  1.00 58.42           N  
ATOM    179  CA  GLY    29      26.598  37.118  33.217  1.00 59.39           C  
ATOM    180  C   GLY    29      27.591  37.028  34.362  1.00 58.49           C  
ATOM    181  O   GLY    29      27.400  36.212  35.263  1.00 58.96           O  
ATOM    182  N   THR    30      28.647  37.836  34.339  1.00 55.83           N  
ATOM    183  CA  THR    30      29.626  37.818  35.419  1.00 55.20           C  
ATOM    184  C   THR    30      30.039  39.253  35.687  1.00 54.78           C  
ATOM    185  O   THR    30      29.687  40.152  34.930  1.00 56.63           O  
ATOM    186  CB  THR    30      30.904  37.026  35.054  1.00 55.53           C  
ATOM    187  OG1 THR    30      31.572  37.684  33.977  1.00 59.89           O  
ATOM    188  CG2 THR    30      30.580  35.605  34.655  1.00 55.82           C  
ATOM    189  N   ALA    31      30.784  39.474  36.764  1.00 51.78           N  
ATOM    190  CA  ALA    31      31.237  40.818  37.076  1.00 52.61           C  
ATOM    191  C   ALA    31      32.450  40.790  38.010  1.00 53.18           C  
ATOM    192  O   ALA    31      32.691  39.810  38.709  1.00 52.70           O  
ATOM    193  CB  ALA    31      30.097  41.623  37.693  1.00 51.77           C  
ATOM    194  N   ARG    32      33.225  41.869  38.002  1.00 53.91           N  
ATOM    195  CA  ARG    32      34.407  41.932  38.849  1.00 55.41           C  
ATOM    196  C   ARG    32      34.550  43.326  39.411  1.00 54.45           C  
ATOM    197  O   ARG    32      34.304  44.324  38.727  1.00 51.64           O  
ATOM    198  CB  ARG    32      35.682  41.577  38.061  1.00 56.29           C  
ATOM    199  CG  ARG    32      36.710  40.769  38.870  1.00 60.83           C  
ATOM    200  CD  ARG    32      38.165  41.219  38.659  1.00 68.82           C  
ATOM    201  NE  ARG    32      38.433  41.696  37.302  1.00 67.14           N  
ATOM    202  CZ  ARG    32      38.391  40.946  36.205  1.00 66.56           C  
ATOM    203  NH1 ARG    32      38.096  39.654  36.281  1.00 67.50           N  
ATOM    204  NH2 ARG    32      38.623  41.502  35.025  1.00 69.78           N  
ATOM    205  N   THR    33      34.960  43.386  40.667  1.00 54.04           N  
ATOM    206  CA  THR    33      35.150  44.655  41.328  1.00 54.88           C  
ATOM    207  C   THR    33      36.340  44.494  42.275  1.00 55.51           C  
ATOM    208  O   THR    33      36.741  43.371  42.579  1.00 52.87           O  
ATOM    209  CB  THR    33      33.852  45.066  42.075  1.00 55.35           C  
ATOM    210  OG1 THR    33      33.558  46.442  41.790  1.00 60.23           O  
ATOM    211  CG2 THR    33      33.996  44.881  43.573  1.00 52.69           C  
ATOM    212  N   ARG    34      36.904  45.603  42.744  1.00 58.33           N  
ATOM    213  CA  ARG    34      38.070  45.520  43.620  1.00 61.57           C  
ATOM    214  C   ARG    34      38.011  46.499  44.783  1.00 61.13           C  
ATOM    215  O   ARG    34      37.666  47.668  44.602  1.00 62.13           O  
ATOM    216  CB  ARG    34      39.332  45.759  42.779  1.00 63.11           C  
ATOM    217  CG  ARG    34      40.654  45.547  43.495  1.00 67.81           C  
ATOM    218  CD  ARG    34      41.235  46.851  44.018  1.00 80.63           C  
ATOM    219  NE  ARG    34      42.681  46.919  43.799  1.00 88.82           N  
ATOM    220  CZ  ARG    34      43.252  46.975  42.600  1.00 92.25           C  
ATOM    221  NH1 ARG    34      42.495  46.976  41.508  1.00 90.51           N  
ATOM    222  NH2 ARG    34      44.577  47.025  42.491  1.00 94.91           N  
ATOM    223  N   LEU    35      38.362  46.027  45.976  1.00 60.79           N  
ATOM    224  CA  LEU    35      38.335  46.890  47.153  1.00 61.51           C  
ATOM    225  C   LEU    35      39.714  47.210  47.733  1.00 62.84           C  
ATOM    226  O   LEU    35      40.231  46.501  48.599  1.00 62.23           O  
ATOM    227  CB  LEU    35      37.448  46.280  48.255  1.00 59.96           C  
ATOM    228  CG  LEU    35      37.249  47.164  49.495  1.00 60.64           C  
ATOM    229  CD1 LEU    35      36.531  48.452  49.101  1.00 59.80           C  
ATOM    230  CD2 LEU    35      36.457  46.414  50.561  1.00 58.70           C  
ATOM    231  N   PRO    36      40.331  48.295  47.251  1.00 65.05           N  
ATOM    232  CA  PRO    36      41.650  48.673  47.763  1.00 67.72           C  
ATOM    233  C   PRO    36      41.585  48.959  49.265  1.00 70.63           C  
ATOM    234  O   PRO    36      40.669  49.627  49.738  1.00 71.74           O  
ATOM    235  CB  PRO    36      42.014  49.907  46.923  1.00 67.73           C  
ATOM    236  CG  PRO    36      40.688  50.407  46.404  1.00 66.37           C  
ATOM    237  CD  PRO    36      39.927  49.153  46.126  1.00 64.71           C  
ATOM    238  N   ALA    37      42.554  48.433  50.005  1.00 72.73           N  
ATOM    239  CA  ALA    37      42.600  48.610  51.448  1.00 74.97           C  
ATOM    240  C   ALA    37      42.575  50.073  51.880  1.00 78.06           C  
ATOM    241  O   ALA    37      43.148  50.945  51.224  1.00 79.38           O  
ATOM    242  CB  ALA    37      43.831  47.931  52.011  1.00 75.09           C  
ATOM    243  N   ARG    38      41.900  50.325  52.996  1.00 79.16           N  
ATOM    244  CA  ARG    38      41.790  51.660  53.563  1.00 78.26           C  
ATOM    245  C   ARG    38      41.540  51.448  55.042  1.00 77.89           C  
ATOM    246  O   ARG    38      41.137  50.362  55.451  1.00 78.49           O  
ATOM    247  CB  ARG    38      40.625  52.421  52.930  1.00 77.89           C  
ATOM    248  CG  ARG    38      40.756  53.926  53.029  1.00 79.53           C  
ATOM    249  CD  ARG    38      40.565  54.586  51.666  1.00 82.14           C  
ATOM    250  NE  ARG    38      39.190  54.513  51.173  1.00 81.39           N  
ATOM    251  CZ  ARG    38      38.162  55.157  51.718  1.00 84.11           C  
ATOM    252  NH1 ARG    38      38.346  55.925  52.782  1.00 89.00           N  
ATOM    253  NH2 ARG    38      36.949  55.048  51.192  1.00 82.94           N  
ATOM    254  N   ALA    39      41.789  52.471  55.843  1.00 78.61           N  
ATOM    255  CA  ALA    39      41.587  52.371  57.281  1.00 78.25           C  
ATOM    256  C   ALA    39      40.191  52.864  57.650  1.00 77.22           C  
ATOM    257  O   ALA    39      39.693  52.599  58.737  1.00 76.90           O  
ATOM    258  CB  ALA    39      42.655  53.188  58.002  1.00 79.37           C  
ATOM    259  N   ASP    40      39.573  53.583  56.716  1.00 77.54           N  
ATOM    260  CA  ASP    40      38.217  54.117  56.874  1.00 77.22           C  
ATOM    261  C   ASP    40      37.272  52.931  56.852  1.00 76.30           C  
ATOM    262  O   ASP    40      36.191  52.953  57.435  1.00 76.53           O  
ATOM    263  CB  ASP    40      37.834  54.985  55.677  1.00 77.80           C  
ATOM    264  CG  ASP    40      38.088  56.456  55.898  1.00 85.99           C  
ATOM    265  OD1 ASP    40      39.237  56.832  56.212  1.00 98.38           O  
ATOM    266  OD2 ASP    40      37.132  57.245  55.730  1.00 90.77           O  
ATOM    267  N   LEU    41      37.705  51.895  56.151  1.00 75.06           N  
ATOM    268  CA  LEU    41      36.892  50.708  55.945  1.00 72.63           C  
ATOM    269  C   LEU    41      37.057  49.515  56.884  1.00 71.44           C  
ATOM    270  O   LEU    41      36.544  48.441  56.592  1.00 70.58           O  
ATOM    271  CB  LEU    41      37.106  50.251  54.505  1.00 71.79           C  
ATOM    272  CG  LEU    41      37.033  51.397  53.492  1.00 68.81           C  
ATOM    273  CD1 LEU    41      37.246  50.882  52.077  1.00 64.95           C  
ATOM    274  CD2 LEU    41      35.679  52.077  53.620  1.00 69.58           C  
ATOM    275  N   VAL    42      37.726  49.703  58.018  1.00 71.99           N  
ATOM    276  CA  VAL    42      37.962  48.591  58.931  1.00 72.06           C  
ATOM    277  C   VAL    42      37.052  48.400  60.152  1.00 73.10           C  
ATOM    278  O   VAL    42      36.355  49.307  60.612  1.00 73.13           O  
ATOM    279  CB  VAL    42      39.415  48.608  59.414  1.00 72.55           C  
ATOM    280  CG1 VAL    42      40.361  48.501  58.217  1.00 71.29           C  
ATOM    281  CG2 VAL    42      39.678  49.895  60.186  1.00 74.55           C  
ATOM    282  N   ASN    43      37.100  47.174  60.660  1.00 73.75           N  
ATOM    283  CA  ASN    43      36.350  46.720  61.813  1.00 73.70           C  
ATOM    284  C   ASN    43      37.045  47.260  63.050  1.00 75.36           C  
ATOM    285  O   ASN    43      37.844  48.190  62.959  1.00 75.86           O  
ATOM    286  CB  ASN    43      36.381  45.198  61.840  1.00 73.88           C  
ATOM    287  CG  ASN    43      35.532  44.622  62.932  1.00 76.44           C  
ATOM    288  OD1 ASN    43      35.791  43.522  63.420  1.00 79.26           O  
ATOM    289  ND2 ASN    43      34.499  45.351  63.318  1.00 79.28           N  
ATOM    290  N   SER    44      36.739  46.673  64.203  1.00 76.37           N  
ATOM    291  CA  SER    44      37.373  47.063  65.452  1.00 76.63           C  
ATOM    292  C   SER    44      38.514  46.077  65.656  1.00 77.43           C  
ATOM    293  O   SER    44      39.480  46.368  66.354  1.00 77.64           O  
ATOM    294  CB  SER    44      36.383  46.991  66.626  1.00 76.83           C  
ATOM    295  OG  SER    44      35.894  45.674  66.832  1.00 76.34           O  
ATOM    296  N   ARG    45      38.392  44.904  65.036  1.00 77.30           N  
ATOM    297  CA  ARG    45      39.433  43.875  65.118  1.00 76.19           C  
ATOM    298  C   ARG    45      40.462  44.192  64.038  1.00 73.76           C  
ATOM    299  O   ARG    45      41.314  43.367  63.710  1.00 75.30           O  
ATOM    300  CB  ARG    45      38.855  42.474  64.863  1.00 77.62           C  
ATOM    301  CG  ARG    45      37.828  41.992  65.884  1.00 82.48           C  
ATOM    302  CD  ARG    45      38.476  41.651  67.218  1.00 89.78           C  
ATOM    303  NE  ARG    45      39.206  40.385  67.175  1.00 94.62           N  
ATOM    304  CZ  ARG    45      40.475  40.232  67.546  1.00 94.99           C  
ATOM    305  NH1 ARG    45      41.173  41.271  67.991  1.00 94.14           N  
ATOM    306  NH2 ARG    45      41.045  39.035  67.474  1.00 94.64           N  
ATOM    307  N   GLY    46      40.366  45.394  63.480  1.00 71.52           N  
ATOM    308  CA  GLY    46      41.294  45.803  62.441  1.00 69.47           C  
ATOM    309  C   GLY    46      40.961  45.261  61.065  1.00 69.13           C  
ATOM    310  O   GLY    46      41.449  45.783  60.068  1.00 70.07           O  
ATOM    311  N   ASP    47      40.134  44.215  61.018  1.00 68.65           N  
ATOM    312  CA  ASP    47      39.722  43.582  59.760  1.00 66.23           C  
ATOM    313  C   ASP    47      38.785  44.479  58.971  1.00 65.33           C  
ATOM    314  O   ASP    47      38.190  45.397  59.522  1.00 66.99           O  
ATOM    315  CB  ASP    47      38.988  42.269  60.021  1.00 65.80           C  
ATOM    316  CG  ASP    47      39.787  41.304  60.856  1.00 65.95           C  
ATOM    317  OD1 ASP    47      41.015  41.207  60.634  1.00 62.58           O  
ATOM    318  OD2 ASP    47      39.174  40.625  61.720  1.00 64.21           O  
ATOM    319  N   ILE    48      38.643  44.207  57.679  1.00 63.90           N  
ATOM    320  CA  ILE    48      37.734  44.994  56.859  1.00 63.50           C  
ATOM    321  C   ILE    48      36.328  44.661  57.367  1.00 62.00           C  
ATOM    322  O   ILE    48      35.976  43.489  57.484  1.00 61.57           O  
ATOM    323  CB  ILE    48      37.863  44.625  55.362  1.00 63.31           C  
ATOM    324  CG1 ILE    48      39.299  44.867  54.879  1.00 65.41           C  
ATOM    325  CG2 ILE    48      36.910  45.476  54.528  1.00 61.38           C  
ATOM    326  CD1 ILE    48      39.634  46.327  54.571  1.00 65.73           C  
ATOM    327  N   HIS    49      35.538  45.690  57.683  1.00 60.23           N  
ATOM    328  CA  HIS    49      34.170  45.510  58.203  1.00 57.44           C  
ATOM    329  C   HIS    49      33.256  44.751  57.240  1.00 54.86           C  
ATOM    330  O   HIS    49      33.157  45.102  56.068  1.00 54.28           O  
ATOM    331  CB  HIS    49      33.552  46.876  58.544  1.00 56.59           C  
ATOM    332  CG  HIS    49      32.349  46.792  59.433  1.00 56.51           C  
ATOM    333  ND1 HIS    49      31.101  46.436  58.975  1.00 58.06           N  
ATOM    334  CD2 HIS    49      32.216  46.972  60.772  1.00 61.56           C  
ATOM    335  CE1 HIS    49      30.251  46.396  59.986  1.00 60.97           C  
ATOM    336  NE2 HIS    49      30.905  46.718  61.088  1.00 65.28           N  
ATOM    337  N   GLY    50      32.595  43.716  57.755  1.00 54.28           N  
ATOM    338  CA  GLY    50      31.695  42.898  56.953  1.00 55.82           C  
ATOM    339  C   GLY    50      30.656  43.682  56.173  1.00 54.65           C  
ATOM    340  O   GLY    50      30.128  43.208  55.164  1.00 55.18           O  
ATOM    341  N   GLY    51      30.357  44.883  56.655  1.00 54.63           N  
ATOM    342  CA  GLY    51      29.398  45.719  55.981  1.00 55.34           C  
ATOM    343  C   GLY    51      30.061  46.240  54.732  1.00 57.54           C  
ATOM    344  O   GLY    51      29.413  46.409  53.698  1.00 58.76           O  
ATOM    345  N   THR    52      31.360  46.505  54.826  1.00 56.93           N  
ATOM    346  CA  THR    52      32.106  46.994  53.672  1.00 57.73           C  
ATOM    347  C   THR    52      32.002  45.906  52.619  1.00 55.49           C  
ATOM    348  O   THR    52      31.862  46.185  51.438  1.00 57.15           O  
ATOM    349  CB  THR    52      33.609  47.206  53.980  1.00 59.07           C  
ATOM    350  OG1 THR    52      33.767  47.832  55.261  1.00 64.70           O  
ATOM    351  CG2 THR    52      34.239  48.102  52.924  1.00 58.87           C  
ATOM    352  N   LEU    53      32.051  44.658  53.070  1.00 54.28           N  
ATOM    353  CA  LEU    53      31.973  43.510  52.177  1.00 54.38           C  
ATOM    354  C   LEU    53      30.628  43.370  51.465  1.00 55.08           C  
ATOM    355  O   LEU    53      30.581  43.246  50.238  1.00 56.03           O  
ATOM    356  CB  LEU    53      32.288  42.239  52.961  1.00 54.43           C  
ATOM    357  CG  LEU    53      33.572  42.304  53.795  1.00 52.99           C  
ATOM    358  CD1 LEU    53      33.880  40.929  54.383  1.00 55.86           C  
ATOM    359  CD2 LEU    53      34.726  42.774  52.925  1.00 55.19           C  
ATOM    360  N   MET    54      29.541  43.384  52.236  1.00 54.80           N  
ATOM    361  CA  MET    54      28.196  43.260  51.675  1.00 52.43           C  
ATOM    362  C   MET    54      27.894  44.435  50.724  1.00 52.03           C  
ATOM    363  O   MET    54      27.197  44.277  49.717  1.00 48.73           O  
ATOM    364  CB  MET    54      27.156  43.206  52.810  1.00 52.54           C  
ATOM    365  CG  MET    54      27.322  42.027  53.796  1.00 57.30           C  
ATOM    366  SD  MET    54      26.081  42.067  55.318  1.00 62.48          SE  
ATOM    367  CE  MET    54      25.966  40.226  55.821  1.00 55.10           C  
ATOM    368  N   SER    55      28.438  45.609  51.036  1.00 53.67           N  
ATOM    369  CA  SER    55      28.202  46.791  50.202  1.00 55.48           C  
ATOM    370  C   SER    55      28.807  46.581  48.826  1.00 56.00           C  
ATOM    371  O   SER    55      28.170  46.835  47.805  1.00 52.23           O  
ATOM    372  CB  SER    55      28.831  48.041  50.829  1.00 53.38           C  
ATOM    373  OG  SER    55      28.419  48.209  52.174  1.00 55.87           O  
ATOM    374  N   VAL    56      30.047  46.109  48.807  1.00 57.92           N  
ATOM    375  CA  VAL    56      30.719  45.889  47.547  1.00 57.30           C  
ATOM    376  C   VAL    56      30.127  44.653  46.873  1.00 57.04           C  
ATOM    377  O   VAL    56      30.051  44.578  45.648  1.00 58.85           O  
ATOM    378  CB  VAL    56      32.257  45.762  47.761  1.00 57.64           C  
ATOM    379  CG1 VAL    56      32.630  44.379  48.254  1.00 55.71           C  
ATOM    380  CG2 VAL    56      32.981  46.111  46.492  1.00 58.95           C  
ATOM    381  N   LEU    57      29.675  43.694  47.676  1.00 57.70           N  
ATOM    382  CA  LEU    57      29.079  42.484  47.127  1.00 57.43           C  
ATOM    383  C   LEU    57      27.716  42.797  46.524  1.00 58.80           C  
ATOM    384  O   LEU    57      27.326  42.216  45.516  1.00 60.67           O  
ATOM    385  CB  LEU    57      28.945  41.418  48.217  1.00 57.54           C  
ATOM    386  CG  LEU    57      30.007  40.319  48.211  1.00 55.85           C  
ATOM    387  CD1 LEU    57      29.865  39.434  49.442  1.00 48.35           C  
ATOM    388  CD2 LEU    57      29.846  39.493  46.940  1.00 48.05           C  
ATOM    389  N   ASP    58      26.994  43.728  47.139  1.00 58.06           N  
ATOM    390  CA  ASP    58      25.681  44.110  46.639  1.00 59.20           C  
ATOM    391  C   ASP    58      25.877  44.738  45.273  1.00 57.88           C  
ATOM    392  O   ASP    58      25.250  44.358  44.288  1.00 58.06           O  
ATOM    393  CB  ASP    58      25.027  45.123  47.585  1.00 60.09           C  
ATOM    394  CG  ASP    58      23.591  45.424  47.210  1.00 60.92           C  
ATOM    395  OD1 ASP    58      23.009  44.637  46.434  1.00 64.05           O  
ATOM    396  OD2 ASP    58      23.040  46.430  47.701  1.00 63.82           O  
ATOM    397  N   PHE    59      26.770  45.715  45.241  1.00 59.00           N  
ATOM    398  CA  PHE    59      27.117  46.424  44.024  1.00 59.42           C  
ATOM    399  C   PHE    59      27.459  45.465  42.876  1.00 58.46           C  
ATOM    400  O   PHE    59      26.895  45.545  41.786  1.00 59.38           O  
ATOM    401  CB  PHE    59      28.309  47.339  44.319  1.00 60.78           C  
ATOM    402  CG  PHE    59      28.934  47.934  43.095  1.00 69.86           C  
ATOM    403  CD1 PHE    59      28.140  48.503  42.108  1.00 72.66           C  
ATOM    404  CD2 PHE    59      30.314  47.908  42.921  1.00 75.70           C  
ATOM    405  CE1 PHE    59      28.704  49.034  40.960  1.00 84.13           C  
ATOM    406  CE2 PHE    59      30.892  48.439  41.777  1.00 85.16           C  
ATOM    407  CZ  PHE    59      30.082  49.004  40.791  1.00 89.23           C  
ATOM    408  N   THR    60      28.375  44.543  43.147  1.00 57.19           N  
ATOM    409  CA  THR    60      28.852  43.592  42.152  1.00 55.36           C  
ATOM    410  C   THR    60      27.902  42.472  41.730  1.00 55.78           C  
ATOM    411  O   THR    60      28.014  41.949  40.625  1.00 56.93           O  
ATOM    412  CB  THR    60      30.174  42.972  42.627  1.00 54.97           C  
ATOM    413  OG1 THR    60      31.009  44.011  43.157  1.00 51.98           O  
ATOM    414  CG2 THR    60      30.902  42.282  41.454  1.00 50.54           C  
ATOM    415  N   LEU    61      26.978  42.091  42.601  1.00 54.16           N  
ATOM    416  CA  LEU    61      26.039  41.039  42.254  1.00 53.20           C  
ATOM    417  C   LEU    61      25.080  41.575  41.195  1.00 53.73           C  
ATOM    418  O   LEU    61      24.756  40.893  40.222  1.00 52.67           O  
ATOM    419  CB  LEU    61      25.279  40.571  43.504  1.00 52.15           C  
ATOM    420  CG  LEU    61      26.060  39.700  44.497  1.00 50.32           C  
ATOM    421  CD1 LEU    61      25.558  39.942  45.918  1.00 49.21           C  
ATOM    422  CD2 LEU    61      25.916  38.227  44.122  1.00 47.40           C  
ATOM    423  N   GLY    62      24.633  42.808  41.379  1.00 55.99           N  
ATOM    424  CA  GLY    62      23.719  43.392  40.417  1.00 59.26           C  
ATOM    425  C   GLY    62      24.385  43.577  39.065  1.00 60.09           C  
ATOM    426  O   GLY    62      23.770  43.381  38.018  1.00 61.11           O  
ATOM    427  N   ALA    63      25.659  43.950  39.095  1.00 60.63           N  
ATOM    428  CA  ALA    63      26.419  44.172  37.873  1.00 61.18           C  
ATOM    429  C   ALA    63      26.460  42.954  36.957  1.00 60.04           C  
ATOM    430  O   ALA    63      26.575  43.105  35.750  1.00 61.51           O  
ATOM    431  CB  ALA    63      27.832  44.617  38.219  1.00 61.48           C  
ATOM    432  N   ALA    64      26.374  41.752  37.518  1.00 59.72           N  
ATOM    433  CA  ALA    64      26.404  40.539  36.700  1.00 59.00           C  
ATOM    434  C   ALA    64      25.120  40.380  35.901  1.00 61.13           C  
ATOM    435  O   ALA    64      25.025  39.523  35.024  1.00 60.65           O  
ATOM    436  CB  ALA    64      26.618  39.321  37.568  1.00 57.86           C  
ATOM    437  N   ILE    65      24.122  41.196  36.221  1.00 63.34           N  
ATOM    438  CA  ILE    65      22.853  41.143  35.506  1.00 64.35           C  
ATOM    439  C   ILE    65      22.854  42.255  34.466  1.00 65.13           C  
ATOM    440  O   ILE    65      22.716  41.997  33.278  1.00 63.47           O  
ATOM    441  CB  ILE    65      21.633  41.375  36.431  1.00 64.03           C  
ATOM    442  CG1 ILE    65      21.603  40.354  37.561  1.00 61.72           C  
ATOM    443  CG2 ILE    65      20.343  41.247  35.626  1.00 64.35           C  
ATOM    444  CD1 ILE    65      20.632  40.736  38.678  1.00 58.41           C  
ATOM    445  N   ARG    66      23.034  43.498  34.908  1.00 65.61           N  
ATOM    446  CA  ARG    66      22.991  44.625  33.971  1.00 66.75           C  
ATOM    447  C   ARG    66      24.286  45.044  33.265  1.00 65.81           C  
ATOM    448  O   ARG    66      24.657  46.225  33.243  1.00 67.92           O  
ATOM    449  CB  ARG    66      22.348  45.832  34.650  1.00 67.01           C  
ATOM    450  CG  ARG    66      22.930  46.224  35.983  1.00 70.89           C  
ATOM    451  CD  ARG    66      22.388  47.577  36.376  1.00 79.03           C  
ATOM    452  NE  ARG    66      22.696  48.583  35.361  1.00 84.60           N  
ATOM    453  CZ  ARG    66      23.885  49.155  35.206  1.00 86.35           C  
ATOM    454  NH1 ARG    66      24.893  48.825  36.008  1.00 83.77           N  
ATOM    455  NH2 ARG    66      24.062  50.059  34.249  1.00 83.22           N  
ATOM    456  N   GLY    67      24.948  44.056  32.671  1.00 61.55           N  
ATOM    457  CA  GLY    67      26.180  44.278  31.929  1.00 63.66           C  
ATOM    458  C   GLY    67      25.815  43.701  30.583  1.00 65.46           C  
ATOM    459  O   GLY    67      26.284  44.135  29.526  1.00 66.44           O  
ATOM    460  N   ASP    68      24.954  42.686  30.653  1.00 33.74           N  
ATOM    461  CA  ASP    68      24.422  42.009  29.472  1.00 33.21           C  
ATOM    462  C   ASP    68      23.369  42.986  28.987  1.00 36.28           C  
ATOM    463  O   ASP    68      22.870  42.874  27.855  1.00 71.16           O  
ATOM    464  CB  ASP    68      23.781  40.681  29.867  1.00 30.38           C  
ATOM    465  CG  ASP    68      24.819  39.640  30.230  1.00 34.25           C  
ATOM    466  OD1 ASP    68      26.007  39.875  29.876  1.00 35.02           O  
ATOM    467  OD2 ASP    68      24.481  38.589  30.842  1.00 33.10           O  
ATOM    468  N   THR    69      23.038  43.948  29.865  1.00 35.66           N  
ATOM    469  CA  THR    69      22.075  44.989  29.518  1.00 34.35           C  
ATOM    470  C   THR    69      21.996  46.196  30.461  1.00 37.99           C  
ATOM    471  O   THR    69      21.239  46.188  31.440  1.00 71.48           O  
ATOM    472  CB  THR    69      20.667  44.439  29.417  1.00 32.31           C  
ATOM    473  OG1 THR    69      20.701  43.139  28.797  1.00 33.54           O  
ATOM    474  CG2 THR    69      19.833  45.393  28.545  1.00 35.19           C  
ATOM    475  N   PRO    70      22.791  47.243  30.187  1.00 71.09           N  
ATOM    476  CA  PRO    70      22.777  48.455  31.019  1.00 70.65           C  
ATOM    477  C   PRO    70      21.468  49.209  30.766  1.00 70.27           C  
ATOM    478  O   PRO    70      21.241  50.307  31.275  1.00 69.44           O  
ATOM    479  CB  PRO    70      24.015  49.227  30.537  1.00 71.09           C  
ATOM    480  CG  PRO    70      24.252  48.684  29.133  1.00 72.04           C  
ATOM    481  CD  PRO    70      23.974  47.218  29.308  1.00 71.20           C  
ATOM    482  N   GLU    71      20.607  48.581  29.972  1.00 71.09           N  
ATOM    483  CA  GLU    71      19.312  49.150  29.616  1.00 75.30           C  
ATOM    484  C   GLU    71      18.296  48.896  30.714  1.00 78.01           C  
ATOM    485  O   GLU    71      17.318  49.623  30.850  1.00 79.60           O  
ATOM    486  CB  GLU    71      18.815  48.533  28.315  1.00 75.45           C  
ATOM    487  N   VAL    72      18.552  47.858  31.502  1.00 80.19           N  
ATOM    488  CA  VAL    72      17.645  47.444  32.562  1.00 79.15           C  
ATOM    489  C   VAL    72      17.993  47.917  33.969  1.00 79.08           C  
ATOM    490  O   VAL    72      19.128  48.300  34.268  1.00 80.56           O  
ATOM    491  CB  VAL    72      17.540  45.919  32.569  1.00 78.95           C  
ATOM    492  CG1 VAL    72      18.800  45.316  33.164  1.00 78.97           C  
ATOM    493  CG2 VAL    72      16.306  45.478  33.315  1.00 79.92           C  
ATOM    494  N   GLY    73      16.994  47.891  34.840  1.00 77.79           N  
ATOM    495  CA  GLY    73      17.215  48.295  36.213  1.00 74.50           C  
ATOM    496  C   GLY    73      17.176  47.054  37.076  1.00 72.12           C  
ATOM    497  O   GLY    73      16.435  46.124  36.778  1.00 71.30           O  
ATOM    498  N   VAL    74      18.000  47.009  38.115  1.00 69.87           N  
ATOM    499  CA  VAL    74      17.980  45.867  39.021  1.00 67.33           C  
ATOM    500  C   VAL    74      17.924  46.378  40.446  1.00 65.07           C  
ATOM    501  O   VAL    74      18.701  47.252  40.840  1.00 64.68           O  
ATOM    502  CB  VAL    74      19.230  44.925  38.893  1.00 66.36           C  
ATOM    503  CG1 VAL    74      19.382  44.433  37.469  1.00 67.21           C  
ATOM    504  CG2 VAL    74      20.488  45.624  39.395  1.00 66.08           C  
ATOM    505  N   ALA    75      16.990  45.844  41.216  1.00 62.21           N  
ATOM    506  CA  ALA    75      16.860  46.233  42.612  1.00 59.82           C  
ATOM    507  C   ALA    75      17.039  44.956  43.415  1.00 57.48           C  
ATOM    508  O   ALA    75      16.521  43.898  43.035  1.00 55.79           O  
ATOM    509  CB  ALA    75      15.487  46.840  42.869  1.00 59.11           C  
ATOM    510  N   THR    76      17.802  45.046  44.501  1.00 57.35           N  
ATOM    511  CA  THR    76      18.046  43.886  45.356  1.00 54.95           C  
ATOM    512  C   THR    76      16.774  43.588  46.149  1.00 54.39           C  
ATOM    513  O   THR    76      16.188  44.504  46.720  1.00 55.28           O  
ATOM    514  CB  THR    76      19.146  44.179  46.376  1.00 54.73           C  
ATOM    515  OG1 THR    76      20.137  45.028  45.789  1.00 53.12           O  
ATOM    516  CG2 THR    76      19.791  42.875  46.837  1.00 48.76           C  
ATOM    517  N   ILE    77      16.351  42.339  46.161  1.00 54.78           N  
ATOM    518  CA  ILE    77      15.153  41.933  46.919  1.00 53.95           C  
ATOM    519  C   ILE    77      15.629  41.454  48.293  1.00 53.85           C  
ATOM    520  O   ILE    77      15.225  41.980  49.326  1.00 53.87           O  
ATOM    521  CB  ILE    77      14.389  40.777  46.214  1.00 53.06           C  
ATOM    522  CG1 ILE    77      13.793  41.277  44.891  1.00 49.37           C  
ATOM    523  CG2 ILE    77      13.299  40.243  47.112  1.00 51.41           C  
ATOM    524  CD1 ILE    77      13.302  40.153  43.972  1.00 50.91           C  
ATOM    525  N   ASP    78      16.508  40.458  48.278  1.00 55.39           N  
ATOM    526  CA  ASP    78      17.093  39.904  49.496  1.00 55.89           C  
ATOM    527  C   ASP    78      18.510  39.412  49.202  1.00 54.38           C  
ATOM    528  O   ASP    78      18.835  39.076  48.067  1.00 53.61           O  
ATOM    529  CB  ASP    78      16.253  38.747  50.015  1.00 54.72           C  
ATOM    530  CG  ASP    78      16.001  37.701  48.953  1.00 59.69           C  
ATOM    531  OD1 ASP    78      14.817  37.481  48.619  1.00 61.41           O  
ATOM    532  OD2 ASP    78      16.980  37.107  48.448  1.00 60.49           O  
ATOM    533  N   MET    79      19.342  39.374  50.239  1.00 55.52           N  
ATOM    534  CA  MET    79      20.716  38.921  50.105  1.00 55.94           C  
ATOM    535  C   MET    79      21.201  38.170  51.340  1.00 55.05           C  
ATOM    536  O   MET    79      20.918  38.560  52.478  1.00 54.67           O  
ATOM    537  CB  MET    79      21.634  40.112  49.844  1.00 57.77           C  
ATOM    538  CG  MET    79      23.104  39.746  49.644  1.00 61.43           C  
ATOM    539  SD  MET    79      24.188  41.319  49.288  1.00 69.63          SE  
ATOM    540  CE  MET    79      23.137  41.999  47.825  1.00 68.28           C  
ATOM    541  N   ASN    80      21.939  37.097  51.098  1.00 55.10           N  
ATOM    542  CA  ASN    80      22.491  36.243  52.142  1.00 53.44           C  
ATOM    543  C   ASN    80      24.026  36.260  52.038  1.00 52.11           C  
ATOM    544  O   ASN    80      24.590  36.005  50.981  1.00 50.58           O  
ATOM    545  CB  ASN    80      21.935  34.822  51.964  1.00 53.41           C  
ATOM    546  CG  ASN    80      22.277  33.905  53.126  1.00 54.82           C  
ATOM    547  OD1 ASN    80      23.412  33.444  53.253  1.00 56.64           O  
ATOM    548  ND2 ASN    80      21.297  33.642  53.982  1.00 54.68           N  
ATOM    549  N   THR    81      24.690  36.577  53.140  1.00 52.31           N  
ATOM    550  CA  THR    81      26.142  36.657  53.148  1.00 51.58           C  
ATOM    551  C   THR    81      26.772  35.788  54.236  1.00 50.18           C  
ATOM    552  O   THR    81      26.372  35.825  55.406  1.00 47.55           O  
ATOM    553  CB  THR    81      26.595  38.130  53.333  1.00 50.52           C  
ATOM    554  OG1 THR    81      25.786  38.979  52.513  1.00 53.11           O  
ATOM    555  CG2 THR    81      28.056  38.313  52.912  1.00 51.60           C  
ATOM    556  N   SER    82      27.756  34.999  53.822  1.00 49.70           N  
ATOM    557  CA  SER    82      28.486  34.119  54.715  1.00 48.38           C  
ATOM    558  C   SER    82      29.867  34.719  54.962  1.00 49.69           C  
ATOM    559  O   SER    82      30.508  35.220  54.032  1.00 49.83           O  
ATOM    560  CB  SER    82      28.605  32.733  54.090  1.00 47.04           C  
ATOM    561  OG  SER    82      27.380  32.035  54.219  1.00 47.27           O  
ATOM    562  N   PHE    83      30.305  34.683  56.217  1.00 48.39           N  
ATOM    563  CA  PHE    83      31.596  35.233  56.601  1.00 52.04           C  
ATOM    564  C   PHE    83      32.540  34.094  56.982  1.00 53.41           C  
ATOM    565  O   PHE    83      32.405  33.475  58.034  1.00 51.27           O  
ATOM    566  CB  PHE    83      31.401  36.230  57.751  1.00 52.31           C  
ATOM    567  CG  PHE    83      30.568  37.417  57.369  1.00 48.98           C  
ATOM    568  CD1 PHE    83      31.084  38.398  56.533  1.00 47.82           C  
ATOM    569  CD2 PHE    83      29.237  37.511  57.769  1.00 47.87           C  
ATOM    570  CE1 PHE    83      30.289  39.456  56.094  1.00 48.23           C  
ATOM    571  CE2 PHE    83      28.431  38.571  57.331  1.00 50.92           C  
ATOM    572  CZ  PHE    83      28.956  39.538  56.494  1.00 47.91           C  
ATOM    573  N   MET    84      33.502  33.828  56.103  1.00 56.89           N  
ATOM    574  CA  MET    84      34.440  32.731  56.301  1.00 59.89           C  
ATOM    575  C   MET    84      35.791  33.067  56.893  1.00 60.24           C  
ATOM    576  O   MET    84      36.319  32.314  57.712  1.00 60.94           O  
ATOM    577  CB  MET    84      34.684  32.014  54.981  1.00 60.79           C  
ATOM    578  CG  MET    84      33.579  31.076  54.553  1.00 67.59           C  
ATOM    579  SD  MET    84      32.327  31.852  53.306  1.00 82.87          SE  
ATOM    580  CE  MET    84      31.428  30.224  52.768  1.00 74.13           C  
ATOM    581  N   SER    85      36.350  34.189  56.463  1.00 62.74           N  
ATOM    582  CA  SER    85      37.663  34.601  56.904  1.00 65.29           C  
ATOM    583  C   SER    85      37.779  36.104  56.991  1.00 67.79           C  
ATOM    584  O   SER    85      37.254  36.828  56.149  1.00 68.96           O  
ATOM    585  CB  SER    85      38.706  34.086  55.915  1.00 65.16           C  
ATOM    586  OG  SER    85      38.545  32.696  55.708  1.00 67.38           O  
ATOM    587  N   PRO    86      38.474  36.593  58.021  1.00 68.91           N  
ATOM    588  CA  PRO    86      38.650  38.034  58.184  1.00 69.20           C  
ATOM    589  C   PRO    86      39.234  38.589  56.898  1.00 69.57           C  
ATOM    590  O   PRO    86      40.109  37.973  56.303  1.00 69.70           O  
ATOM    591  CB  PRO    86      39.628  38.129  59.352  1.00 70.10           C  
ATOM    592  CG  PRO    86      39.254  36.938  60.189  1.00 69.38           C  
ATOM    593  CD  PRO    86      39.057  35.851  59.154  1.00 68.26           C  
ATOM    594  N   GLY    87      38.742  39.745  56.469  1.00 71.21           N  
ATOM    595  CA  GLY    87      39.238  40.352  55.246  1.00 70.14           C  
ATOM    596  C   GLY    87      40.309  41.386  55.524  1.00 71.08           C  
ATOM    597  O   GLY    87      40.143  42.241  56.393  1.00 70.15           O  
ATOM    598  N   ARG    88      41.409  41.313  54.778  1.00 72.20           N  
ATOM    599  CA  ARG    88      42.517  42.243  54.947  1.00 71.33           C  
ATOM    600  C   ARG    88      43.218  42.528  53.626  1.00 71.05           C  
ATOM    601  O   ARG    88      43.272  41.670  52.749  1.00 71.84           O  
ATOM    602  CB  ARG    88      43.516  41.671  55.954  1.00 72.66           C  
ATOM    603  CG  ARG    88      42.998  41.644  57.382  1.00 72.27           C  
ATOM    604  CD  ARG    88      43.927  40.870  58.295  1.00 76.68           C  
ATOM    605  NE  ARG    88      43.204  39.848  59.050  1.00 79.59           N  
ATOM    606  CZ  ARG    88      43.741  39.114  60.017  1.00 79.58           C  
ATOM    607  NH1 ARG    88      45.013  39.287  60.351  1.00 82.63           N  
ATOM    608  NH2 ARG    88      43.008  38.207  60.651  1.00 78.13           N  
ATOM    609  N   GLY    89      43.758  43.735  53.488  1.00 70.69           N  
ATOM    610  CA  GLY    89      44.446  44.101  52.264  1.00 71.85           C  
ATOM    611  C   GLY    89      43.462  44.226  51.121  1.00 73.12           C  
ATOM    612  O   GLY    89      42.256  44.199  51.342  1.00 73.84           O  
ATOM    613  N   ASP    90      43.970  44.370  49.901  1.00 72.73           N  
ATOM    614  CA  ASP    90      43.117  44.490  48.723  1.00 72.06           C  
ATOM    615  C   ASP    90      42.302  43.219  48.534  1.00 70.71           C  
ATOM    616  O   ASP    90      42.810  42.110  48.713  1.00 71.10           O  
ATOM    617  CB  ASP    90      43.955  44.724  47.462  1.00 73.55           C  
ATOM    618  CG  ASP    90      44.353  46.179  47.277  1.00 74.11           C  
ATOM    619  OD1 ASP    90      44.944  46.770  48.208  1.00 73.77           O  
ATOM    620  OD2 ASP    90      44.085  46.727  46.188  1.00 75.54           O  
ATOM    621  N   LEU    91      41.039  43.384  48.161  1.00 68.33           N  
ATOM    622  CA  LEU    91      40.155  42.244  47.931  1.00 64.69           C  
ATOM    623  C   LEU    91      39.545  42.356  46.539  1.00 63.47           C  
ATOM    624  O   LEU    91      39.327  43.463  46.031  1.00 61.92           O  
ATOM    625  CB  LEU    91      39.041  42.216  48.972  1.00 63.68           C  
ATOM    626  CG  LEU    91      39.459  42.248  50.440  1.00 59.55           C  
ATOM    627  CD1 LEU    91      38.233  42.541  51.291  1.00 60.67           C  
ATOM    628  CD2 LEU    91      40.101  40.933  50.843  1.00 56.88           C  
ATOM    629  N   VAL    92      39.282  41.211  45.920  1.00 61.53           N  
ATOM    630  CA  VAL    92      38.691  41.204  44.593  1.00 60.01           C  
ATOM    631  C   VAL    92      37.337  40.527  44.720  1.00 57.88           C  
ATOM    632  O   VAL    92      37.203  39.510  45.393  1.00 55.94           O  
ATOM    633  CB  VAL    92      39.602  40.457  43.559  1.00 59.18           C  
ATOM    634  CG1 VAL    92      39.536  38.961  43.765  1.00 62.89           C  
ATOM    635  CG2 VAL    92      39.200  40.833  42.151  1.00 60.68           C  
ATOM    636  N   ILE    93      36.331  41.116  44.085  1.00 58.48           N  
ATOM    637  CA  ILE    93      34.974  40.592  44.144  1.00 57.13           C  
ATOM    638  C   ILE    93      34.493  40.141  42.774  1.00 55.90           C  
ATOM    639  O   ILE    93      34.531  40.904  41.809  1.00 56.68           O  
ATOM    640  CB  ILE    93      34.014  41.662  44.710  1.00 57.13           C  
ATOM    641  CG1 ILE    93      34.526  42.132  46.072  1.00 54.80           C  
ATOM    642  CG2 ILE    93      32.602  41.107  44.837  1.00 53.88           C  
ATOM    643  CD1 ILE    93      35.587  43.210  45.997  1.00 48.07           C  
ATOM    644  N   GLU    94      34.035  38.898  42.698  1.00 56.37           N  
ATOM    645  CA  GLU    94      33.559  38.346  41.436  1.00 56.42           C  
ATOM    646  C   GLU    94      32.210  37.645  41.589  1.00 55.31           C  
ATOM    647  O   GLU    94      32.034  36.791  42.451  1.00 54.64           O  
ATOM    648  CB  GLU    94      34.588  37.364  40.873  1.00 58.89           C  
ATOM    649  CG  GLU    94      35.954  37.969  40.620  1.00 62.05           C  
ATOM    650  CD  GLU    94      36.781  37.142  39.657  1.00 69.04           C  
ATOM    651  OE1 GLU    94      37.265  37.703  38.646  1.00 67.11           O  
ATOM    652  OE2 GLU    94      36.945  35.932  39.908  1.00 70.83           O  
ATOM    653  N   THR    95      31.272  38.000  40.720  1.00 55.95           N  
ATOM    654  CA  THR    95      29.928  37.445  40.761  1.00 55.64           C  
ATOM    655  C   THR    95      29.519  36.789  39.450  1.00 57.43           C  
ATOM    656  O   THR    95      30.160  36.987  38.421  1.00 59.47           O  
ATOM    657  CB  THR    95      28.905  38.544  41.078  1.00 55.35           C  
ATOM    658  OG1 THR    95      29.008  39.593  40.104  1.00 53.07           O  
ATOM    659  CG2 THR    95      29.155  39.118  42.467  1.00 51.92           C  
ATOM    660  N   ARG    96      28.447  36.006  39.500  1.00 58.84           N  
ATOM    661  CA  ARG    96      27.907  35.334  38.318  1.00 58.70           C  
ATOM    662  C   ARG    96      26.393  35.235  38.479  1.00 57.98           C  
ATOM    663  O   ARG    96      25.894  35.043  39.589  1.00 57.43           O  
ATOM    664  CB  ARG    96      28.516  33.928  38.154  1.00 60.02           C  
ATOM    665  CG  ARG    96      28.151  32.917  39.244  1.00 64.39           C  
ATOM    666  CD  ARG    96      29.294  31.922  39.471  1.00 73.23           C  
ATOM    667  NE  ARG    96      30.532  32.618  39.831  1.00 79.38           N  
ATOM    668  CZ  ARG    96      31.044  32.700  41.058  1.00 77.77           C  
ATOM    669  NH1 ARG    96      30.442  32.122  42.088  1.00 75.44           N  
ATOM    670  NH2 ARG    96      32.164  33.384  41.255  1.00 77.42           N  
ATOM    671  N   CYS    97      25.664  35.390  37.378  1.00 57.49           N  
ATOM    672  CA  CYS    97      24.211  35.306  37.416  1.00 55.67           C  
ATOM    673  C   CYS    97      23.878  33.840  37.260  1.00 55.73           C  
ATOM    674  O   CYS    97      24.382  33.193  36.350  1.00 58.61           O  
ATOM    675  CB  CYS    97      23.593  36.101  36.269  1.00 56.18           C  
ATOM    676  SG  CYS    97      21.779  36.147  36.286  1.00 57.01           S  
ATOM    677  N   LEU    98      23.040  33.313  38.146  1.00 54.26           N  
ATOM    678  CA  LEU    98      22.664  31.897  38.098  1.00 52.21           C  
ATOM    679  C   LEU    98      21.433  31.641  37.250  1.00 49.03           C  
ATOM    680  O   LEU    98      21.256  30.560  36.704  1.00 46.12           O  
ATOM    681  CB  LEU    98      22.395  31.381  39.504  1.00 54.15           C  
ATOM    682  CG  LEU    98      23.539  31.416  40.510  1.00 54.58           C  
ATOM    683  CD1 LEU    98      22.973  31.175  41.898  1.00 46.73           C  
ATOM    684  CD2 LEU    98      24.594  30.369  40.145  1.00 56.93           C  
ATOM    685  N   ARG    99      20.568  32.644  37.178  1.00 50.48           N  
ATOM    686  CA  ARG    99      19.344  32.557  36.404  1.00 52.49           C  
ATOM    687  C   ARG    99      18.757  33.938  36.190  1.00 52.82           C  
ATOM    688  O   ARG    99      18.828  34.807  37.056  1.00 53.75           O  
ATOM    689  CB  ARG    99      18.304  31.676  37.102  1.00 54.06           C  
ATOM    690  CG  ARG    99      16.945  31.789  36.431  1.00 57.29           C  
ATOM    691  CD  ARG    99      16.145  30.500  36.429  1.00 65.87           C  
ATOM    692  NE  ARG    99      15.023  30.617  35.497  1.00 70.54           N  
ATOM    693  CZ  ARG    99      14.103  31.574  35.559  1.00 67.79           C  
ATOM    694  NH1 ARG    99      14.164  32.496  36.511  1.00 71.10           N  
ATOM    695  NH2 ARG    99      13.132  31.624  34.661  1.00 70.62           N  
ATOM    696  N   ARG   100      18.160  34.132  35.030  1.00 56.24           N  
ATOM    697  CA  ARG   100      17.563  35.413  34.713  1.00 58.79           C  
ATOM    698  C   ARG   100      16.166  35.176  34.156  1.00 59.48           C  
ATOM    699  O   ARG   100      15.992  34.445  33.179  1.00 62.14           O  
ATOM    700  CB  ARG   100      18.432  36.142  33.687  1.00 59.79           C  
ATOM    701  CG  ARG   100      18.455  37.650  33.842  1.00 59.96           C  
ATOM    702  CD  ARG   100      19.412  38.262  32.846  1.00 63.35           C  
ATOM    703  NE  ARG   100      19.086  39.652  32.554  1.00 71.63           N  
ATOM    704  CZ  ARG   100      19.996  40.602  32.363  1.00 73.15           C  
ATOM    705  NH1 ARG   100      21.288  40.302  32.445  1.00 66.78           N  
ATOM    706  NH2 ARG   100      19.618  41.842  32.072  1.00 77.98           N  
ATOM    707  N   GLY   101      15.171  35.778  34.797  1.00 59.68           N  
ATOM    708  CA  GLY   101      13.807  35.625  34.342  1.00 60.36           C  
ATOM    709  C   GLY   101      13.387  36.942  33.748  1.00 59.99           C  
ATOM    710  O   GLY   101      14.216  37.825  33.555  1.00 59.70           O  
ATOM    711  N   ALA   102      12.107  37.086  33.444  1.00 61.31           N  
ATOM    712  CA  ALA   102      11.638  38.337  32.876  1.00 62.56           C  
ATOM    713  C   ALA   102      11.613  39.373  33.981  1.00 63.18           C  
ATOM    714  O   ALA   102      11.869  40.556  33.752  1.00 65.06           O  
ATOM    715  CB  ALA   102      10.259  38.155  32.296  1.00 62.57           C  
ATOM    716  N   SER   103      11.327  38.907  35.191  1.00 63.17           N  
ATOM    717  CA  SER   103      11.222  39.792  36.345  1.00 63.30           C  
ATOM    718  C   SER   103      12.206  39.558  37.492  1.00 60.88           C  
ATOM    719  O   SER   103      12.620  40.507  38.152  1.00 59.41           O  
ATOM    720  CB  SER   103       9.791  39.713  36.886  1.00 65.59           C  
ATOM    721  OG  SER   103       9.628  40.516  38.041  1.00 72.67           O  
ATOM    722  N   ILE   104      12.576  38.294  37.712  1.00 60.81           N  
ATOM    723  CA  ILE   104      13.469  37.891  38.813  1.00 58.72           C  
ATOM    724  C   ILE   104      14.853  37.356  38.406  1.00 59.10           C  
ATOM    725  O   ILE   104      14.965  36.490  37.540  1.00 56.77           O  
ATOM    726  CB  ILE   104      12.793  36.791  39.674  1.00 58.71           C  
ATOM    727  CG1 ILE   104      11.414  37.255  40.143  1.00 54.91           C  
ATOM    728  CG2 ILE   104      13.657  36.457  40.872  1.00 56.87           C  
ATOM    729  CD1 ILE   104      11.455  38.329  41.208  1.00 53.11           C  
ATOM    730  N   ALA   105      15.897  37.851  39.069  1.00 57.55           N  
ATOM    731  CA  ALA   105      17.265  37.408  38.791  1.00 55.87           C  
ATOM    732  C   ALA   105      17.959  36.863  40.039  1.00 53.73           C  
ATOM    733  O   ALA   105      17.839  37.433  41.119  1.00 52.30           O  
ATOM    734  CB  ALA   105      18.079  38.563  38.209  1.00 55.98           C  
ATOM    735  N   PHE   106      18.697  35.765  39.878  1.00 54.37           N  
ATOM    736  CA  PHE   106      19.435  35.138  40.984  1.00 54.66           C  
ATOM    737  C   PHE   106      20.934  35.283  40.757  1.00 56.10           C  
ATOM    738  O   PHE   106      21.431  35.012  39.668  1.00 58.87           O  
ATOM    739  CB  PHE   106      19.118  33.647  41.074  1.00 51.44           C  
ATOM    740  CG  PHE   106      17.710  33.342  41.483  1.00 50.85           C  
ATOM    741  CD1 PHE   106      17.320  33.428  42.822  1.00 44.53           C  
ATOM    742  CD2 PHE   106      16.763  32.968  40.527  1.00 46.72           C  
ATOM    743  CE1 PHE   106      16.002  33.144  43.214  1.00 39.63           C  
ATOM    744  CE2 PHE   106      15.439  32.684  40.904  1.00 47.44           C  
ATOM    745  CZ  PHE   106      15.059  32.773  42.253  1.00 49.21           C  
ATOM    746  N   CYS   107      21.658  35.694  41.788  1.00 59.42           N  
ATOM    747  CA  CYS   107      23.103  35.859  41.666  1.00 60.48           C  
ATOM    748  C   CYS   107      23.868  35.361  42.879  1.00 58.89           C  
ATOM    749  O   CYS   107      23.320  35.228  43.968  1.00 58.15           O  
ATOM    750  CB  CYS   107      23.451  37.333  41.430  1.00 59.77           C  
ATOM    751  SG  CYS   107      22.814  38.008  39.875  1.00 68.43           S  
ATOM    752  N   GLU   108      25.142  35.060  42.670  1.00 58.74           N  
ATOM    753  CA  GLU   108      26.014  34.615  43.746  1.00 57.79           C  
ATOM    754  C   GLU   108      27.394  35.209  43.505  1.00 56.15           C  
ATOM    755  O   GLU   108      27.675  35.741  42.435  1.00 56.27           O  
ATOM    756  CB  GLU   108      26.088  33.090  43.809  1.00 56.81           C  
ATOM    757  CG  GLU   108      26.431  32.413  42.505  1.00 59.58           C  
ATOM    758  CD  GLU   108      27.160  31.110  42.723  1.00 56.82           C  
ATOM    759  OE1 GLU   108      26.776  30.354  43.640  1.00 62.65           O  
ATOM    760  OE2 GLU   108      28.122  30.847  41.975  1.00 63.95           O  
ATOM    761  N   GLY   109      28.252  35.143  44.510  1.00 55.69           N  
ATOM    762  CA  GLY   109      29.573  35.711  44.349  1.00 56.85           C  
ATOM    763  C   GLY   109      30.464  35.456  45.541  1.00 56.87           C  
ATOM    764  O   GLY   109      30.046  34.847  46.526  1.00 54.75           O  
ATOM    765  N   GLU   110      31.693  35.955  45.459  1.00 57.17           N  
ATOM    766  CA  GLU   110      32.664  35.744  46.520  1.00 58.54           C  
ATOM    767  C   GLU   110      33.738  36.825  46.563  1.00 56.41           C  
ATOM    768  O   GLU   110      34.023  37.483  45.560  1.00 57.20           O  
ATOM    769  CB  GLU   110      33.321  34.376  46.325  1.00 58.69           C  
ATOM    770  CG  GLU   110      33.367  33.958  44.854  1.00 67.99           C  
ATOM    771  CD  GLU   110      34.447  32.940  44.547  1.00 76.41           C  
ATOM    772  OE1 GLU   110      34.343  31.793  45.033  1.00 83.23           O  
ATOM    773  OE2 GLU   110      35.399  33.295  43.814  1.00 76.64           O  
ATOM    774  N   ILE   111      34.327  36.997  47.741  1.00 55.20           N  
ATOM    775  CA  ILE   111      35.387  37.964  47.944  1.00 53.99           C  
ATOM    776  C   ILE   111      36.631  37.171  48.334  1.00 53.91           C  
ATOM    777  O   ILE   111      36.563  36.255  49.158  1.00 52.14           O  
ATOM    778  CB  ILE   111      35.039  38.952  49.079  1.00 55.99           C  
ATOM    779  CG1 ILE   111      33.687  39.618  48.794  1.00 50.38           C  
ATOM    780  CG2 ILE   111      36.146  40.007  49.213  1.00 52.86           C  
ATOM    781  CD1 ILE   111      33.182  40.488  49.915  1.00 44.32           C  
ATOM    782  N   ARG   112      37.767  37.512  47.740  1.00 54.95           N  
ATOM    783  CA  ARG   112      39.004  36.802  48.049  1.00 57.36           C  
ATOM    784  C   ARG   112      40.111  37.804  48.309  1.00 58.33           C  
ATOM    785  O   ARG   112      40.093  38.914  47.770  1.00 58.61           O  
ATOM    786  CB  ARG   112      39.401  35.876  46.890  1.00 55.02           C  
ATOM    787  CG  ARG   112      38.240  35.058  46.326  1.00 58.53           C  
ATOM    788  CD  ARG   112      38.714  33.889  45.468  1.00 59.84           C  
ATOM    789  NE  ARG   112      38.967  32.697  46.276  1.00 55.17           N  
ATOM    790  CZ  ARG   112      38.262  31.576  46.185  1.00 56.50           C  
ATOM    791  NH1 ARG   112      37.268  31.499  45.312  1.00 57.16           N  
ATOM    792  NH2 ARG   112      38.530  30.546  46.983  1.00 53.22           N  
ATOM    793  N   ASP   113      41.065  37.418  49.149  1.00 59.75           N  
ATOM    794  CA  ASP   113      42.187  38.293  49.460  1.00 61.42           C  
ATOM    795  C   ASP   113      43.326  38.045  48.482  1.00 61.61           C  
ATOM    796  O   ASP   113      43.249  37.151  47.643  1.00 61.62           O  
ATOM    797  CB  ASP   113      42.678  38.072  50.899  1.00 63.46           C  
ATOM    798  CG  ASP   113      42.922  36.614  51.225  1.00 62.82           C  
ATOM    799  OD1 ASP   113      43.513  35.895  50.390  1.00 71.52           O  
ATOM    800  OD2 ASP   113      42.531  36.189  52.327  1.00 61.21           O  
ATOM    801  N   SER   114      44.375  38.852  48.590  1.00 63.28           N  
ATOM    802  CA  SER   114      45.539  38.730  47.722  1.00 64.00           C  
ATOM    803  C   SER   114      46.053  37.295  47.693  1.00 65.13           C  
ATOM    804  O   SER   114      46.604  36.850  46.693  1.00 66.04           O  
ATOM    805  CB  SER   114      46.643  39.679  48.204  1.00 65.13           C  
ATOM    806  OG  SER   114      46.817  39.600  49.612  1.00 60.56           O  
ATOM    807  N   ALA   115      45.849  36.572  48.792  1.00 66.03           N  
ATOM    808  CA  ALA   115      46.287  35.183  48.918  1.00 65.08           C  
ATOM    809  C   ALA   115      45.301  34.190  48.297  1.00 65.99           C  
ATOM    810  O   ALA   115      45.504  32.977  48.367  1.00 66.38           O  
ATOM    811  CB  ALA   115      46.511  34.846  50.396  1.00 65.09           C  
ATOM    812  N   GLY   116      44.227  34.714  47.707  1.00 66.72           N  
ATOM    813  CA  GLY   116      43.228  33.874  47.061  1.00 64.83           C  
ATOM    814  C   GLY   116      42.303  33.078  47.968  1.00 64.48           C  
ATOM    815  O   GLY   116      41.588  32.188  47.501  1.00 63.85           O  
ATOM    816  N   GLU   117      42.304  33.389  49.259  1.00 63.88           N  
ATOM    817  CA  GLU   117      41.458  32.672  50.204  1.00 64.34           C  
ATOM    818  C   GLU   117      40.067  33.306  50.290  1.00 62.51           C  
ATOM    819  O   GLU   117      39.922  34.529  50.216  1.00 62.86           O  
ATOM    820  CB  GLU   117      42.115  32.656  51.587  1.00 65.37           C  
ATOM    821  CG  GLU   117      42.256  31.277  52.213  1.00 66.65           C  
ATOM    822  CD  GLU   117      43.127  30.333  51.389  1.00 73.09           C  
ATOM    823  OE1 GLU   117      44.185  30.772  50.883  1.00 72.72           O  
ATOM    824  OE2 GLU   117      42.761  29.144  51.258  1.00 73.02           O  
ATOM    825  N   LEU   118      39.053  32.461  50.444  1.00 59.68           N  
ATOM    826  CA  LEU   118      37.671  32.909  50.529  1.00 59.25           C  
ATOM    827  C   LEU   118      37.402  33.732  51.794  1.00 58.30           C  
ATOM    828  O   LEU   118      37.537  33.241  52.920  1.00 54.60           O  
ATOM    829  CB  LEU   118      36.729  31.695  50.472  1.00 60.95           C  
ATOM    830  CG  LEU   118      35.239  31.901  50.169  1.00 59.70           C  
ATOM    831  CD1 LEU   118      35.060  32.717  48.881  1.00 53.79           C  
ATOM    832  CD2 LEU   118      34.574  30.539  50.026  1.00 56.32           C  
ATOM    833  N   VAL   119      37.034  34.994  51.588  1.00 57.09           N  
ATOM    834  CA  VAL   119      36.725  35.905  52.679  1.00 56.54           C  
ATOM    835  C   VAL   119      35.238  35.783  53.006  1.00 54.43           C  
ATOM    836  O   VAL   119      34.868  35.530  54.149  1.00 55.22           O  
ATOM    837  CB  VAL   119      37.065  37.375  52.296  1.00 56.87           C  
ATOM    838  CG1 VAL   119      36.539  38.330  53.353  1.00 56.66           C  
ATOM    839  CG2 VAL   119      38.580  37.534  52.157  1.00 57.01           C  
ATOM    840  N   ALA   120      34.393  35.949  51.996  1.00 53.42           N  
ATOM    841  CA  ALA   120      32.947  35.838  52.174  1.00 54.17           C  
ATOM    842  C   ALA   120      32.283  35.429  50.873  1.00 52.69           C  
ATOM    843  O   ALA   120      32.813  35.685  49.804  1.00 54.05           O  
ATOM    844  CB  ALA   120      32.370  37.164  52.656  1.00 51.04           C  
ATOM    845  N   LYS   121      31.128  34.785  50.974  1.00 53.82           N  
ATOM    846  CA  LYS   121      30.365  34.361  49.807  1.00 53.64           C  
ATOM    847  C   LYS   121      28.933  34.842  50.040  1.00 53.35           C  
ATOM    848  O   LYS   121      28.452  34.835  51.174  1.00 51.67           O  
ATOM    849  CB  LYS   121      30.399  32.838  49.663  1.00 53.76           C  
ATOM    850  CG  LYS   121      30.210  32.357  48.236  1.00 60.50           C  
ATOM    851  CD  LYS   121      30.881  31.005  48.023  1.00 69.99           C  
ATOM    852  CE  LYS   121      30.995  30.643  46.543  1.00 72.37           C  
ATOM    853  NZ  LYS   121      29.668  30.515  45.889  1.00 75.53           N  
ATOM    854  N   ALA   122      28.257  35.258  48.969  1.00 52.17           N  
ATOM    855  CA  ALA   122      26.894  35.764  49.095  1.00 50.01           C  
ATOM    856  C   ALA   122      25.981  35.395  47.937  1.00 47.99           C  
ATOM    857  O   ALA   122      26.429  35.170  46.821  1.00 47.40           O  
ATOM    858  CB  ALA   122      26.921  37.286  49.260  1.00 47.87           C  
ATOM    859  N   THR   123      24.690  35.305  48.219  1.00 48.48           N  
ATOM    860  CA  THR   123      23.720  35.027  47.175  1.00 50.18           C  
ATOM    861  C   THR   123      22.708  36.170  47.283  1.00 50.64           C  
ATOM    862  O   THR   123      22.557  36.775  48.351  1.00 49.94           O  
ATOM    863  CB  THR   123      23.031  33.656  47.369  1.00 48.58           C  
ATOM    864  OG1 THR   123      22.423  33.601  48.666  1.00 52.63           O  
ATOM    865  CG2 THR   123      24.043  32.516  47.217  1.00 48.88           C  
ATOM    866  N   ALA   124      22.047  36.491  46.176  1.00 50.30           N  
ATOM    867  CA  ALA   124      21.073  37.577  46.166  1.00 49.15           C  
ATOM    868  C   ALA   124      19.970  37.360  45.144  1.00 50.23           C  
ATOM    869  O   ALA   124      20.143  36.646  44.150  1.00 48.07           O  
ATOM    870  CB  ALA   124      21.767  38.900  45.896  1.00 49.07           C  
ATOM    871  N   THR   125      18.823  37.969  45.410  1.00 49.61           N  
ATOM    872  CA  THR   125      17.695  37.868  44.509  1.00 49.31           C  
ATOM    873  C   THR   125      17.456  39.292  44.042  1.00 47.89           C  
ATOM    874  O   THR   125      17.596  40.240  44.816  1.00 47.69           O  
ATOM    875  CB  THR   125      16.435  37.301  45.215  1.00 48.47           C  
ATOM    876  OG1 THR   125      16.746  36.048  45.841  1.00 46.66           O  
ATOM    877  CG2 THR   125      15.350  37.055  44.207  1.00 49.82           C  
ATOM    878  N   PHE   126      17.099  39.452  42.777  1.00 47.83           N  
ATOM    879  CA  PHE   126      16.909  40.798  42.258  1.00 49.42           C  
ATOM    880  C   PHE   126      15.630  41.041  41.484  1.00 49.91           C  
ATOM    881  O   PHE   126      15.075  40.134  40.859  1.00 48.27           O  
ATOM    882  CB  PHE   126      18.075  41.197  41.342  1.00 47.90           C  
ATOM    883  CG  PHE   126      19.377  41.440  42.062  1.00 46.56           C  
ATOM    884  CD1 PHE   126      20.242  40.387  42.367  1.00 46.64           C  
ATOM    885  CD2 PHE   126      19.758  42.734  42.399  1.00 40.34           C  
ATOM    886  CE1 PHE   126      21.478  40.634  42.997  1.00 45.60           C  
ATOM    887  CE2 PHE   126      20.988  42.991  43.028  1.00 42.33           C  
ATOM    888  CZ  PHE   126      21.849  41.935  43.324  1.00 39.69           C  
ATOM    889  N   LYS   127      15.173  42.290  41.522  1.00 53.22           N  
ATOM    890  CA  LYS   127      14.003  42.701  40.755  1.00 57.90           C  
ATOM    891  C   LYS   127      14.625  43.362  39.520  1.00 59.78           C  
ATOM    892  O   LYS   127      15.464  44.259  39.659  1.00 58.23           O  
ATOM    893  CB  LYS   127      13.184  43.727  41.536  1.00 56.86           C  
ATOM    894  N   ILE   128      14.283  42.901  38.321  1.00 63.95           N  
ATOM    895  CA  ILE   128      14.820  43.588  37.157  1.00 68.16           C  
ATOM    896  C   ILE   128      13.707  44.524  36.743  1.00 71.94           C  
ATOM    897  O   ILE   128      12.611  44.095  36.375  1.00 71.60           O  
ATOM    898  CB  ILE   128      15.243  42.644  35.982  1.00 67.37           C  
ATOM    899  CG1 ILE   128      14.467  41.327  36.011  1.00 63.20           C  
ATOM    900  CG2 ILE   128      16.746  42.394  36.053  1.00 68.21           C  
ATOM    901  CD1 ILE   128      15.170  40.208  35.236  1.00 60.33           C  
ATOM    902  N   ILE   129      14.000  45.816  36.858  1.00 75.65           N  
ATOM    903  CA  ILE   129      13.054  46.886  36.560  1.00 79.11           C  
ATOM    904  C   ILE   129      12.728  47.158  35.092  1.00 82.21           C  
ATOM    905  O   ILE   129      13.085  48.203  34.556  1.00 82.94           O  
ATOM    906  CB  ILE   129      13.512  48.223  37.209  1.00 79.07           C  
ATOM    907  CG1 ILE   129      13.778  48.023  38.711  1.00 78.47           C  
ATOM    908  CG2 ILE   129      12.450  49.294  37.007  1.00 79.06           C  
ATOM    909  CD1 ILE   129      12.657  47.332  39.458  1.00 77.73           C  
ATOM    910  N   GLN   130      12.055  46.203  34.453  1.00 85.92           N  
ATOM    911  CA  GLN   130      11.596  46.349  33.074  1.00 88.00           C  
ATOM    912  C   GLN   130      10.817  45.148  32.564  1.00 88.85           C  
ATOM    913  O   GLN   130       9.657  45.373  32.160  1.00 89.20           O  
ATOM    914  CB  GLN   130      12.742  46.702  32.114  1.00 87.61           C  
ATOM    915  CG  GLN   130      12.373  47.924  31.257  1.00 87.70           C  
ATOM    916  CD  GLN   130      11.656  49.016  32.066  1.00 85.68           C  
ATOM    917  OE1 GLN   130      10.611  48.772  32.678  1.00 80.72           O  
ATOM    918  NE2 GLN   130      12.217  50.224  32.065  1.00 84.66           N  
END
