
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  117 (  880),  selected  117 , name 1wlu_A
# Molecule2: number of CA atoms  125 (  918),  selected  125 , name T0479.pdb
# PARAMETERS: 1wlu_A.T0479.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      T       6           -
LGA    -       -      D       7           -
LGA    -       -      F       8           -
LGA    -       -      F       9           -
LGA    -       -      G      10           -
LGA    M     1_A      L      11          1.841
LGA    R     2_A      T      12          1.467
LGA    D     3_A      I      13          1.692
LGA    P     4_A      P      14          1.516
LGA    F     5_A      F      15          1.514
LGA    M     6_A      M      16          1.589
LGA    E     7_A      Q      17          1.188
LGA    A     8_A      L      18          0.956
LGA    L     9_A      L      19          0.810
LGA    G    10_A      G      20          0.856
LGA    L    11_A      V      21          0.595
LGA    K    12_A      V      22          0.626
LGA    V    13_A      P      23          1.080
LGA    L    14_A      E      24          1.191
LGA    H    15_A      H      25          1.070
LGA    L    16_A      S      26          1.312
LGA    A    17_A      G      27          0.935
LGA    P    18_A      N      28          3.048
LGA    G    19_A      G      29          2.065
LGA    E    20_A      T      30          1.665
LGA    A    21_A      A      31          0.953
LGA    V    22_A      R      32          0.344
LGA    V    23_A      T      33          0.609
LGA    A    24_A      R      34          0.283
LGA    G    25_A      L      35          1.121
LGA    E    26_A      P      36          1.712
LGA    V    27_A      A      37          2.603
LGA    R    28_A      R      38          0.861
LGA    A    29_A      A      39          0.563
LGA    D    30_A      D      40          0.780
LGA    H    31_A      L      41          0.700
LGA    L    32_A      V      42          0.937
LGA    N    33_A      N      43          1.666
LGA    L    34_A      S      44          2.224
LGA    H    35_A      R      45          2.279
LGA    G    36_A      G      46          1.850
LGA    T    37_A      D      47          1.228
LGA    A    38_A      I      48          0.874
LGA    H    39_A      H      49          0.627
LGA    G    40_A      G      50          0.801
LGA    G    41_A      G      51          0.591
LGA    F    42_A      T      52          0.383
LGA    L    43_A      L      53          0.886
LGA    Y    44_A      M      54          0.910
LGA    A    45_A      S      55          1.010
LGA    L    46_A      V      56          1.332
LGA    A    47_A      L      57          0.956
LGA    D    48_A      D      58          1.003
LGA    S    49_A      F      59          1.200
LGA    A    50_A      T      60          0.706
LGA    F    51_A      L      61          1.026
LGA    A    52_A      G      62          2.206
LGA    L    53_A      A      63          1.655
LGA    A    54_A      A      64          1.703
LGA    S    55_A      I      65          2.188
LGA    N    56_A      R      66          2.317
LGA    T    57_A      G      67          2.721
LGA    R    58_A      D      68          4.881
LGA    -       -      T      69           -
LGA    -       -      P      70           -
LGA    -       -      E      71           -
LGA    G    59_A      V      72          1.846
LGA    P    60_A      G      73          0.898
LGA    A    61_A      V      74          1.162
LGA    V    62_A      A      75          0.270
LGA    A    63_A      T      76          0.353
LGA    L    64_A      I      77          0.361
LGA    S    65_A      D      78          0.786
LGA    C    66_A      M      79          0.423
LGA    R    67_A      N      80          0.522
LGA    M    68_A      T      81          0.507
LGA    D    69_A      S      82          0.301
LGA    Y    70_A      F      83          0.629
LGA    F    71_A      M      84          0.439
LGA    R    72_A      S      85          0.407
LGA    P    73_A      P      86          0.225
LGA    L    74_A      G      87          2.013
LGA    G    75_A      R      88          3.182
LGA    A    76_A      -       -           -
LGA    G    77_A      -       -           -
LGA    A    78_A      G      89          0.505
LGA    R    79_A      D      90          0.825
LGA    V    80_A      L      91          0.300
LGA    E    81_A      V      92          1.025
LGA    A    82_A      I      93          0.967
LGA    R    83_A      E      94          0.273
LGA    A    84_A      T      95          0.817
LGA    V    85_A      R      96          0.466
LGA    E    86_A      C      97          0.892
LGA    V    87_A      L      98          0.548
LGA    N    88_A      R      99          0.831
LGA    L    89_A      R     100          0.842
LGA    S    90_A      G     101          1.151
LGA    R    91_A      A     102          1.386
LGA    R    92_A      S     103          0.820
LGA    T    93_A      I     104          0.311
LGA    A    94_A      A     105          0.601
LGA    T    95_A      F     106          0.573
LGA    Y    96_A      C     107          0.773
LGA    R    97_A      E     108          0.923
LGA    V    98_A      G     109          0.917
LGA    E    99_A      E     110          1.185
LGA    V   100_A      I     111          0.802
LGA    V   101_A      R     112          1.070
LGA    S   102_A      D     113          1.034
LGA    E   103_A      S     114          2.000
LGA    -       -      A     115           -
LGA    G   104_A      G     116          1.012
LGA    K   105_A      E     117          1.018
LGA    L   106_A      L     118          1.148
LGA    V   107_A      V     119          0.820
LGA    A   108_A      A     120          0.686
LGA    L   109_A      K     121          0.335
LGA    F   110_A      A     122          0.897
LGA    T   111_A      T     123          0.414
LGA    G   112_A      A     124          0.535
LGA    T   113_A      T     125          0.753
LGA    V   114_A      F     126          0.022
LGA    F   115_A      K     127          0.984
LGA    R   116_A      I     128          1.366
LGA    L   117_A      I     129          1.411
LGA    -       -      Q     130           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  117  125    5.0    115    1.30    24.35     87.361     8.206

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.864757 * X  +  -0.007114 * Y  +   0.502141 * Z  +  19.693735
  Y_new =  -0.502167 * X  +  -0.002425 * Y  +   0.864767 * Z  +  33.634834
  Z_new =  -0.004934 * X  +  -0.999972 * Y  +  -0.005670 * Z  +  53.582497 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.576466    1.565126  [ DEG:   -90.3249     89.6751 ]
  Theta =   0.004934    3.136658  [ DEG:     0.2827    179.7173 ]
  Phi   =  -0.526110    2.615483  [ DEG:   -30.1439    149.8561 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1wlu_A                                        
REMARK     2: T0479.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1wlu_A.T0479.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  117  125   5.0  115   1.30   24.35  87.361
REMARK  ---------------------------------------------------------- 
MOLECULE 1wlu_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   29-JUN-04   1WLU              
TITLE     CRYSTAL STRUCTURE OF TT0310 PROTEIN FROM THERMUS                      
TITLE    2 THERMOPHILUS HB8                                                     
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PHENYLACETIC ACID DEGRADATION PROTEIN PAAI;                
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: PAAI PROTEIN;                                               
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: THERMUS THERMOPHILUS;                           
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: HB8 / ATCC 27634 / DSM 579;                                  
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET11A                                    
KEYWDS    THIOESTERASE, HOT DOG FOLD, PHENYLACETIC ACID DEGRADATION,            
KEYWDS   2 STRUCTURAL GENOMICS, RIKEN STRUCTURAL GENOMICS/PROTEOMICS            
KEYWDS   3 INITIATIVE, RSGI                                                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    N.KUNISHIMA,M.SUGAHARA,M.MIYANO,RIKEN STRUCTURAL                      
AUTHOR   2 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   2   06-SEP-05 1WLU    1       JRNL                                     
REVDAT   1   05-JUL-05 1WLU    0                                                
JRNL        AUTH   N.KUNISHIMA,Y.ASADA,M.SUGAHARA,J.ISHIJIMA,Y.NODAKE,          
JRNL        AUTH 2 M.SUGAHARA,M.MIYANO,S.KURAMITSU,S.YOKOYAMA,                  
JRNL        AUTH 3 M.SUGAHARA                                                   
JRNL        TITL   A NOVEL INDUCED-FIT REACTION MECHANISM OF                    
JRNL        TITL 2 ASYMMETRIC HOT DOG THIOESTERASE PAAI                         
JRNL        REF    J.MOL.BIOL.                   V. 352   212 2005              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 1.45 ANGSTROMS.                                          
DBREF  1WLU A    1   136  UNP    Q5SJP3   Q5SJP3_THET8     1    136             
SEQRES   1 A  136  MET ARG ASP PRO PHE MET GLU ALA LEU GLY LEU LYS VAL          
SEQRES   2 A  136  LEU HIS LEU ALA PRO GLY GLU ALA VAL VAL ALA GLY GLU          
SEQRES   3 A  136  VAL ARG ALA ASP HIS LEU ASN LEU HIS GLY THR ALA HIS          
SEQRES   4 A  136  GLY GLY PHE LEU TYR ALA LEU ALA ASP SER ALA PHE ALA          
SEQRES   5 A  136  LEU ALA SER ASN THR ARG GLY PRO ALA VAL ALA LEU SER          
SEQRES   6 A  136  CYS ARG MET ASP TYR PHE ARG PRO LEU GLY ALA GLY ALA          
SEQRES   7 A  136  ARG VAL GLU ALA ARG ALA VAL GLU VAL ASN LEU SER ARG          
SEQRES   8 A  136  ARG THR ALA THR TYR ARG VAL GLU VAL VAL SER GLU GLY          
SEQRES   9 A  136  LYS LEU VAL ALA LEU PHE THR GLY THR VAL PHE ARG LEU          
SEQRES  10 A  136  GLY GLY ASP GLY ASP ASP VAL PRO ALA GLY THR GLY ASN          
SEQRES  11 A  136  LEU ALA PRO ARG GLU ALA                                      
HET     CL   1001       1                                                       
HET    GOL   1002       6                                                       
HETNAM      CL CHLORIDE ION                                                     
HETNAM     GOL GLYCEROL                                                         
FORMUL   2   CL    CL 1-                                                        
FORMUL   3  GOL    C3 H8 O3                                                     
FORMUL   4  HOH   *160(H2 O)                                                    
CRYST1   76.804   76.804  155.701  90.00  90.00  90.00 I 41 2 2     16          
ATOM      1  N   MET A   1      27.337  55.749  34.020  1.00 26.89           N  
ATOM      2  CA  MET A   1      27.217  55.012  35.311  1.00 26.35           C  
ATOM      3  C   MET A   1      28.120  55.643  36.363  1.00 25.63           C  
ATOM      4  O   MET A   1      29.344  55.652  36.228  1.00 25.82           O  
ATOM      5  CB  MET A   1      27.605  53.541  35.120  1.00 27.92           C  
ATOM      6  CG  MET A   1      27.175  52.597  36.255  1.00 29.89           C  
ATOM      7  SD  MET A   1      27.949  52.880  37.871  1.00 31.50           S  
ATOM      8  CE  MET A   1      29.463  51.930  37.704  1.00 32.19           C  
ATOM      9  N   ARG A   2      27.502  56.183  37.405  1.00 23.74           N  
ATOM     10  CA  ARG A   2      28.234  56.795  38.500  1.00 22.47           C  
ATOM     11  C   ARG A   2      27.608  56.310  39.797  1.00 20.67           C  
ATOM     12  O   ARG A   2      26.407  56.476  40.015  1.00 22.32           O  
ATOM     13  CB  ARG A   2      28.147  58.322  38.426  1.00 23.46           C  
ATOM     14  CG  ARG A   2      28.693  59.015  39.660  1.00 26.09           C  
ATOM     15  CD  ARG A   2      28.506  60.521  39.590  1.00 28.53           C  
ATOM     16  NE  ARG A   2      28.701  61.141  40.897  1.00 32.16           N  
ATOM     17  CZ  ARG A   2      29.832  61.085  41.592  1.00 32.17           C  
ATOM     18  NH1 ARG A   2      30.881  60.439  41.105  1.00 33.08           N  
ATOM     19  NH2 ARG A   2      29.910  61.664  42.783  1.00 33.77           N  
ATOM     20  N   ASP A   3      28.417  55.693  40.648  1.00 18.70           N  
ATOM     21  CA  ASP A   3      27.922  55.195  41.922  1.00 17.15           C  
ATOM     22  C   ASP A   3      28.687  55.905  43.033  1.00 16.01           C  
ATOM     23  O   ASP A   3      29.834  55.571  43.324  1.00 15.94           O  
ATOM     24  CB  ASP A   3      28.123  53.680  42.011  1.00 17.43           C  
ATOM     25  CG  ASP A   3      27.367  53.064  43.166  1.00 17.68           C  
ATOM     26  OD1 ASP A   3      27.665  53.424  44.325  1.00 16.89           O  
ATOM     27  OD2 ASP A   3      26.473  52.226  42.917  1.00 18.31           O  
ATOM     28  N   PRO A   4      28.057  56.907  43.661  1.00 16.24           N  
ATOM     29  CA  PRO A   4      28.689  57.671  44.740  1.00 15.91           C  
ATOM     30  C   PRO A   4      29.288  56.840  45.870  1.00 15.56           C  
ATOM     31  O   PRO A   4      30.392  57.125  46.329  1.00 16.32           O  
ATOM     32  CB  PRO A   4      27.563  58.581  45.222  1.00 17.37           C  
ATOM     33  CG  PRO A   4      26.785  58.827  43.967  1.00 17.54           C  
ATOM     34  CD  PRO A   4      26.716  57.443  43.362  1.00 15.80           C  
ATOM     35  N   PHE A   5      28.573  55.812  46.318  1.00 15.70           N  
ATOM     36  CA  PHE A   5      29.079  54.989  47.410  1.00 15.07           C  
ATOM     37  C   PHE A   5      30.292  54.165  46.982  1.00 14.60           C  
ATOM     38  O   PHE A   5      31.254  54.029  47.738  1.00 14.71           O  
ATOM     39  CB  PHE A   5      27.968  54.084  47.950  1.00 14.15           C  
ATOM     40  CG  PHE A   5      28.254  53.514  49.316  1.00 14.89           C  
ATOM     41  CD1 PHE A   5      28.665  54.341  50.363  1.00 15.85           C  
ATOM     42  CD2 PHE A   5      28.083  52.157  49.566  1.00 15.66           C  
ATOM     43  CE1 PHE A   5      28.898  53.819  51.639  1.00 16.82           C  
ATOM     44  CE2 PHE A   5      28.312  51.626  50.837  1.00 15.22           C  
ATOM     45  CZ  PHE A   5      28.719  52.459  51.874  1.00 16.70           C  
ATOM     46  N   MET A   6      30.257  53.611  45.773  1.00 13.87           N  
ATOM     47  CA  MET A   6      31.404  52.851  45.290  1.00 13.85           C  
ATOM     48  C   MET A   6      32.615  53.781  45.242  1.00 14.37           C  
ATOM     49  O   MET A   6      33.716  53.409  45.641  1.00 14.39           O  
ATOM     50  CB  MET A   6      31.140  52.292  43.890  1.00 14.36           C  
ATOM     51  CG  MET A   6      30.170  51.123  43.852  1.00 14.49           C  
ATOM     52  SD  MET A   6      29.959  50.485  42.183  1.00 15.42           S  
ATOM     53  CE  MET A   6      31.534  49.719  41.913  1.00 16.12           C  
ATOM     54  N   GLU A   7      32.399  54.995  44.747  1.00 15.81           N  
ATOM     55  CA  GLU A   7      33.471  55.974  44.650  1.00 16.61           C  
ATOM     56  C   GLU A   7      34.003  56.333  46.037  1.00 15.99           C  
ATOM     57  O   GLU A   7      35.216  56.400  46.247  1.00 16.84           O  
ATOM     58  CB  GLU A   7      32.965  57.229  43.936  1.00 18.00           C  
ATOM     59  CG  GLU A   7      34.010  58.316  43.764  1.00 20.64           C  
ATOM     60  CD  GLU A   7      33.474  59.515  43.011  1.00 25.24           C  
ATOM     61  OE1 GLU A   7      33.175  59.377  41.809  1.00 25.21           O  
ATOM     62  OE2 GLU A   7      33.344  60.596  43.626  1.00 29.91           O  
ATOM     63  N   ALA A   8      33.095  56.545  46.984  1.00 15.99           N  
ATOM     64  CA  ALA A   8      33.489  56.898  48.346  1.00 15.99           C  
ATOM     65  C   ALA A   8      34.300  55.790  49.014  1.00 16.68           C  
ATOM     66  O   ALA A   8      35.176  56.066  49.835  1.00 16.89           O  
ATOM     67  CB  ALA A   8      32.253  57.217  49.179  1.00 17.22           C  
ATOM     68  N   LEU A   9      34.008  54.539  48.660  1.00 15.35           N  
ATOM     69  CA  LEU A   9      34.715  53.394  49.227  1.00 15.26           C  
ATOM     70  C   LEU A   9      36.003  53.059  48.476  1.00 15.12           C  
ATOM     71  O   LEU A   9      36.746  52.168  48.884  1.00 15.94           O  
ATOM     72  CB  LEU A   9      33.803  52.164  49.239  1.00 15.77           C  
ATOM     73  CG  LEU A   9      32.578  52.226  50.151  1.00 17.88           C  
ATOM     74  CD1 LEU A   9      31.775  50.939  50.013  1.00 18.38           C  
ATOM     75  CD2 LEU A   9      33.020  52.427  51.591  1.00 19.34           C  
ATOM     76  N   GLY A  10      36.251  53.771  47.378  1.00 15.60           N  
ATOM     77  CA  GLY A  10      37.450  53.541  46.589  1.00 15.89           C  
ATOM     78  C   GLY A  10      37.399  52.294  45.725  1.00 15.55           C  
ATOM     79  O   GLY A  10      38.436  51.745  45.354  1.00 16.38           O  
ATOM     80  N   LEU A  11      36.194  51.852  45.391  1.00 15.49           N  
ATOM     81  CA  LEU A  11      36.030  50.651  44.583  1.00 15.68           C  
ATOM     82  C   LEU A  11      36.215  50.921  43.095  1.00 16.70           C  
ATOM     83  O   LEU A  11      35.955  52.026  42.611  1.00 18.74           O  
ATOM     84  CB  LEU A  11      34.648  50.040  44.831  1.00 16.00           C  
ATOM     85  CG  LEU A  11      34.289  49.802  46.301  1.00 15.82           C  
ATOM     86  CD1 LEU A  11      32.950  49.078  46.380  1.00 16.39           C  
ATOM     87  CD2 LEU A  11      35.379  48.984  46.981  1.00 15.54           C  
ATOM     88  N   LYS A  12      36.673  49.900  42.378  1.00 15.83           N  
ATOM     89  CA  LYS A  12      36.893  50.001  40.941  1.00 16.25           C  
ATOM     90  C   LYS A  12      36.340  48.759  40.260  1.00 16.19           C  
ATOM     91  O   LYS A  12      36.234  47.699  40.876  1.00 16.18           O  
ATOM     92  CB  LYS A  12      38.386  50.128  40.642  1.00 19.32           C  
ATOM     93  CG  LYS A  12      39.028  51.359  41.264  1.00 23.74           C  
ATOM     94  CD  LYS A  12      40.512  51.429  40.957  1.00 26.51           C  
ATOM     95  CE  LYS A  12      41.145  52.647  41.611  1.00 29.63           C  
ATOM     96  NZ  LYS A  12      42.597  52.752  41.304  1.00 32.74           N  
ATOM     97  N   VAL A  13      35.978  48.892  38.990  1.00 14.93           N  
ATOM     98  CA  VAL A  13      35.449  47.764  38.239  1.00 14.53           C  
ATOM     99  C   VAL A  13      36.584  47.127  37.447  1.00 14.42           C  
ATOM    100  O   VAL A  13      37.312  47.819  36.732  1.00 13.70           O  
ATOM    101  CB  VAL A  13      34.335  48.214  37.267  1.00 14.14           C  
ATOM    102  CG1 VAL A  13      33.832  47.025  36.455  1.00 16.03           C  
ATOM    103  CG2 VAL A  13      33.192  48.847  38.046  1.00 15.54           C  
ATOM    104  N   LEU A  14      36.750  45.816  37.590  1.00 13.83           N  
ATOM    105  CA  LEU A  14      37.799  45.103  36.870  1.00 14.23           C  
ATOM    106  C   LEU A  14      37.226  44.337  35.686  1.00 14.52           C  
ATOM    107  O   LEU A  14      37.967  43.891  34.811  1.00 15.95           O  
ATOM    108  CB  LEU A  14      38.538  44.134  37.797  1.00 14.79           C  
ATOM    109  CG  LEU A  14      39.230  44.741  39.019  1.00 16.43           C  
ATOM    110  CD1 LEU A  14      40.069  43.664  39.691  1.00 18.30           C  
ATOM    111  CD2 LEU A  14      40.108  45.916  38.607  1.00 19.10           C  
ATOM    112  N   HIS A  15      35.908  44.173  35.665  1.00 14.08           N  
ATOM    113  CA  HIS A  15      35.265  43.479  34.560  1.00 14.60           C  
ATOM    114  C   HIS A  15      33.762  43.682  34.578  1.00 14.72           C  
ATOM    115  O   HIS A  15      33.139  43.742  35.637  1.00 13.49           O  
ATOM    116  CB  HIS A  15      35.586  41.980  34.597  1.00 18.39           C  
ATOM    117  CG  HIS A  15      35.349  41.283  33.292  1.00 21.46           C  
ATOM    118  ND1 HIS A  15      34.135  40.728  32.950  1.00 25.07           N  
ATOM    119  CD2 HIS A  15      36.165  41.084  32.230  1.00 23.73           C  
ATOM    120  CE1 HIS A  15      34.213  40.216  31.734  1.00 24.42           C  
ATOM    121  NE2 HIS A  15      35.434  40.420  31.274  1.00 25.84           N  
ATOM    122  N   LEU A  16      33.186  43.822  33.390  1.00 14.29           N  
ATOM    123  CA  LEU A  16      31.747  43.973  33.253  1.00 14.64           C  
ATOM    124  C   LEU A  16      31.375  43.423  31.891  1.00 16.03           C  
ATOM    125  O   LEU A  16      31.917  43.846  30.870  1.00 16.18           O  
ATOM    126  CB  LEU A  16      31.318  45.438  33.363  1.00 16.35           C  
ATOM    127  CG  LEU A  16      29.799  45.655  33.358  1.00 17.42           C  
ATOM    128  CD1 LEU A  16      29.167  44.952  34.555  1.00 19.56           C  
ATOM    129  CD2 LEU A  16      29.490  47.145  33.400  1.00 19.97           C  
ATOM    130  N   ALA A  17      30.466  42.459  31.888  1.00 14.71           N  
ATOM    131  CA  ALA A  17      30.000  41.828  30.663  1.00 14.96           C  
ATOM    132  C   ALA A  17      28.586  41.346  30.946  1.00 15.46           C  
ATOM    133  O   ALA A  17      28.134  41.385  32.088  1.00 14.97           O  
ATOM    134  CB  ALA A  17      30.904  40.657  30.297  1.00 16.43           C  
ATOM    135  N   PRO A  18      27.863  40.892  29.915  1.00 15.08           N  
ATOM    136  CA  PRO A  18      26.495  40.424  30.149  1.00 14.65           C  
ATOM    137  C   PRO A  18      26.391  39.378  31.258  1.00 14.50           C  
ATOM    138  O   PRO A  18      26.975  38.296  31.164  1.00 15.68           O  
ATOM    139  CB  PRO A  18      26.087  39.875  28.786  1.00 14.50           C  
ATOM    140  CG  PRO A  18      26.832  40.778  27.841  1.00 15.48           C  
ATOM    141  CD  PRO A  18      28.199  40.840  28.481  1.00 16.34           C  
ATOM    142  N   GLY A  19      25.662  39.728  32.316  1.00 13.78           N  
ATOM    143  CA  GLY A  19      25.455  38.824  33.436  1.00 14.19           C  
ATOM    144  C   GLY A  19      26.592  38.645  34.429  1.00 14.47           C  
ATOM    145  O   GLY A  19      26.482  37.820  35.338  1.00 15.91           O  
ATOM    146  N   GLU A  20      27.676  39.401  34.288  1.00 14.45           N  
ATOM    147  CA  GLU A  20      28.796  39.246  35.207  1.00 15.84           C  
ATOM    148  C   GLU A  20      29.580  40.527  35.456  1.00 14.98           C  
ATOM    149  O   GLU A  20      29.562  41.453  34.643  1.00 15.13           O  
ATOM    150  CB  GLU A  20      29.736  38.145  34.698  1.00 18.34           C  
ATOM    151  CG  GLU A  20      30.436  38.448  33.386  1.00 21.93           C  
ATOM    152  CD  GLU A  20      31.193  37.244  32.858  1.00 23.55           C  
ATOM    153  OE1 GLU A  20      30.571  36.392  32.192  1.00 29.22           O  
ATOM    154  OE2 GLU A  20      32.405  37.139  33.127  1.00 26.99           O  
ATOM    155  N   ALA A  21      30.269  40.577  36.590  1.00 13.82           N  
ATOM    156  CA  ALA A  21      31.060  41.745  36.943  1.00 13.87           C  
ATOM    157  C   ALA A  21      32.048  41.431  38.052  1.00 14.03           C  
ATOM    158  O   ALA A  21      31.814  40.545  38.873  1.00 15.25           O  
ATOM    159  CB  ALA A  21      30.148  42.880  37.382  1.00 15.02           C  
ATOM    160  N   VAL A  22      33.163  42.150  38.054  1.00 14.00           N  
ATOM    161  CA  VAL A  22      34.173  42.006  39.091  1.00 13.94           C  
ATOM    162  C   VAL A  22      34.466  43.411  39.595  1.00 14.89           C  
ATOM    163  O   VAL A  22      34.746  44.318  38.806  1.00 14.87           O  
ATOM    164  CB  VAL A  22      35.489  41.388  38.564  1.00 14.07           C  
ATOM    165  CG1 VAL A  22      36.524  41.351  39.687  1.00 15.36           C  
ATOM    166  CG2 VAL A  22      35.240  39.982  38.036  1.00 13.90           C  
ATOM    167  N   VAL A  23      34.367  43.590  40.908  1.00 13.51           N  
ATOM    168  CA  VAL A  23      34.627  44.872  41.553  1.00 14.19           C  
ATOM    169  C   VAL A  23      35.745  44.642  42.553  1.00 15.47           C  
ATOM    170  O   VAL A  23      35.757  43.630  43.255  1.00 15.88           O  
ATOM    171  CB  VAL A  23      33.370  45.400  42.278  1.00 14.07           C  
ATOM    172  CG1 VAL A  23      33.706  46.651  43.081  1.00 15.69           C  
ATOM    173  CG2 VAL A  23      32.282  45.712  41.258  1.00 14.04           C  
ATOM    174  N   ALA A  24      36.690  45.573  42.615  1.00 14.78           N  
ATOM    175  CA  ALA A  24      37.819  45.434  43.521  1.00 15.34           C  
ATOM    176  C   ALA A  24      38.010  46.649  44.405  1.00 15.26           C  
ATOM    177  O   ALA A  24      37.573  47.754  44.081  1.00 16.04           O  
ATOM    178  CB  ALA A  24      39.093  45.178  42.722  1.00 16.50           C  
ATOM    179  N   GLY A  25      38.675  46.433  45.531  1.00 15.11           N  
ATOM    180  CA  GLY A  25      38.938  47.520  46.449  1.00 17.02           C  
ATOM    181  C   GLY A  25      40.044  47.133  47.404  1.00 17.52           C  
ATOM    182  O   GLY A  25      40.546  46.011  47.367  1.00 19.57           O  
ATOM    183  N   GLU A  26      40.440  48.074  48.247  1.00 17.54           N  
ATOM    184  CA  GLU A  26      41.473  47.814  49.233  1.00 18.82           C  
ATOM    185  C   GLU A  26      40.891  48.210  50.577  1.00 17.77           C  
ATOM    186  O   GLU A  26      40.190  49.217  50.679  1.00 18.26           O  
ATOM    187  CB  GLU A  26      42.726  48.648  48.946  1.00 20.92           C  
ATOM    188  CG  GLU A  26      43.892  48.330  49.878  1.00 26.09           C  
ATOM    189  CD  GLU A  26      45.131  49.153  49.578  1.00 29.95           C  
ATOM    190  OE1 GLU A  26      45.570  49.163  48.410  1.00 32.13           O  
ATOM    191  OE2 GLU A  26      45.670  49.782  50.511  1.00 31.74           O  
ATOM    192  N   VAL A  27      41.157  47.408  51.600  1.00 16.49           N  
ATOM    193  CA  VAL A  27      40.658  47.715  52.932  1.00 17.07           C  
ATOM    194  C   VAL A  27      41.491  48.864  53.491  1.00 16.61           C  
ATOM    195  O   VAL A  27      42.693  48.718  53.711  1.00 19.21           O  
ATOM    196  CB  VAL A  27      40.774  46.495  53.871  1.00 16.83           C  
ATOM    197  CG1 VAL A  27      40.261  46.858  55.258  1.00 17.08           C  
ATOM    198  CG2 VAL A  27      39.979  45.325  53.305  1.00 17.78           C  
ATOM    199  N   ARG A  28      40.848  50.008  53.693  1.00 16.42           N  
ATOM    200  CA  ARG A  28      41.527  51.182  54.229  1.00 17.41           C  
ATOM    201  C   ARG A  28      41.262  51.287  55.724  1.00 17.56           C  
ATOM    202  O   ARG A  28      40.456  50.538  56.280  1.00 16.90           O  
ATOM    203  CB  ARG A  28      41.034  52.449  53.527  1.00 19.97           C  
ATOM    204  CG  ARG A  28      41.213  52.430  52.018  1.00 21.57           C  
ATOM    205  CD  ARG A  28      40.694  53.709  51.370  1.00 27.56           C  
ATOM    206  NE  ARG A  28      39.322  54.012  51.767  1.00 30.16           N  
ATOM    207  CZ  ARG A  28      38.499  54.800  51.081  1.00 31.23           C  
ATOM    208  NH1 ARG A  28      38.908  55.367  49.954  1.00 30.80           N  
ATOM    209  NH2 ARG A  28      37.267  55.019  51.521  1.00 25.84           N  
ATOM    210  N   ALA A  29      41.941  52.226  56.373  1.00 17.70           N  
ATOM    211  CA  ALA A  29      41.782  52.430  57.806  1.00 18.01           C  
ATOM    212  C   ALA A  29      40.335  52.735  58.187  1.00 17.69           C  
ATOM    213  O   ALA A  29      39.855  52.283  59.228  1.00 18.38           O  
ATOM    214  CB  ALA A  29      42.692  53.564  58.268  1.00 19.18           C  
ATOM    215  N   ASP A  30      39.645  53.497  57.344  1.00 18.20           N  
ATOM    216  CA  ASP A  30      38.259  53.871  57.612  1.00 18.87           C  
ATOM    217  C   ASP A  30      37.258  52.751  57.340  1.00 17.33           C  
ATOM    218  O   ASP A  30      36.062  52.933  57.542  1.00 17.72           O  
ATOM    219  CB  ASP A  30      37.882  55.110  56.790  1.00 21.87           C  
ATOM    220  CG  ASP A  30      37.992  54.879  55.293  1.00 25.44           C  
ATOM    221  OD1 ASP A  30      39.066  54.442  54.831  1.00 28.39           O  
ATOM    222  OD2 ASP A  30      37.004  55.142  54.573  1.00 30.04           O  
ATOM    223  N   HIS A  31      37.754  51.600  56.897  1.00 16.08           N  
ATOM    224  CA  HIS A  31      36.894  50.453  56.596  1.00 15.37           C  
ATOM    225  C   HIS A  31      36.910  49.408  57.703  1.00 16.11           C  
ATOM    226  O   HIS A  31      36.214  48.397  57.615  1.00 16.31           O  
ATOM    227  CB  HIS A  31      37.336  49.797  55.289  1.00 16.13           C  
ATOM    228  CG  HIS A  31      37.241  50.700  54.101  1.00 16.09           C  
ATOM    229  ND1 HIS A  31      38.009  50.524  52.971  1.00 18.30           N  
ATOM    230  CD2 HIS A  31      36.459  51.780  53.861  1.00 18.32           C  
ATOM    231  CE1 HIS A  31      37.706  51.458  52.087  1.00 18.33           C  
ATOM    232  NE2 HIS A  31      36.769  52.232  52.602  1.00 18.38           N  
ATOM    233  N   LEU A  32      37.703  49.648  58.742  1.00 15.23           N  
ATOM    234  CA  LEU A  32      37.799  48.705  59.846  1.00 15.67           C  
ATOM    235  C   LEU A  32      36.655  48.864  60.836  1.00 16.28           C  
ATOM    236  O   LEU A  32      36.080  49.944  60.972  1.00 16.91           O  
ATOM    237  CB  LEU A  32      39.135  48.879  60.574  1.00 17.03           C  
ATOM    238  CG  LEU A  32      40.392  48.717  59.716  1.00 16.83           C  
ATOM    239  CD1 LEU A  32      41.627  48.888  60.592  1.00 18.50           C  
ATOM    240  CD2 LEU A  32      40.396  47.347  59.049  1.00 17.24           C  
ATOM    241  N   ASN A  33      36.331  47.773  61.522  1.00 16.71           N  
ATOM    242  CA  ASN A  33      35.261  47.770  62.512  1.00 17.84           C  
ATOM    243  C   ASN A  33      35.849  47.842  63.917  1.00 19.66           C  
ATOM    244  O   ASN A  33      37.044  48.083  64.088  1.00 19.93           O  
ATOM    245  CB  ASN A  33      34.418  46.500  62.381  1.00 17.94           C  
ATOM    246  CG  ASN A  33      35.252  45.241  62.476  1.00 18.68           C  
ATOM    247  OD1 ASN A  33      36.292  45.225  63.133  1.00 18.69           O  
ATOM    248  ND2 ASN A  33      34.794  44.172  61.828  1.00 19.38           N  
ATOM    249  N   LEU A  34      34.997  47.614  64.913  1.00 20.93           N  
ATOM    250  CA  LEU A  34      35.407  47.648  66.313  1.00 22.89           C  
ATOM    251  C   LEU A  34      36.372  46.514  66.653  1.00 23.79           C  
ATOM    252  O   LEU A  34      36.992  46.521  67.716  1.00 25.37           O  
ATOM    253  CB  LEU A  34      34.181  47.561  67.230  1.00 24.24           C  
ATOM    254  CG  LEU A  34      33.410  46.235  67.291  1.00 24.30           C  
ATOM    255  CD1 LEU A  34      32.352  46.326  68.385  1.00 27.07           C  
ATOM    256  CD2 LEU A  34      32.766  45.922  65.945  1.00 26.33           C  
ATOM    257  N   HIS A  35      36.491  45.542  65.751  1.00 23.53           N  
ATOM    258  CA  HIS A  35      37.382  44.402  65.961  1.00 23.93           C  
ATOM    259  C   HIS A  35      38.754  44.657  65.340  1.00 23.29           C  
ATOM    260  O   HIS A  35      39.713  43.932  65.613  1.00 24.42           O  
ATOM    261  CB  HIS A  35      36.791  43.134  65.334  1.00 25.11           C  
ATOM    262  CG  HIS A  35      35.403  42.813  65.795  1.00 26.67           C  
ATOM    263  ND1 HIS A  35      35.079  42.640  67.123  1.00 27.42           N  
ATOM    264  CD2 HIS A  35      34.261  42.600  65.097  1.00 27.01           C  
ATOM    265  CE1 HIS A  35      33.798  42.333  67.224  1.00 28.59           C  
ATOM    266  NE2 HIS A  35      33.278  42.303  66.010  1.00 27.92           N  
ATOM    267  N   GLY A  36      38.848  45.683  64.500  1.00 21.36           N  
ATOM    268  CA  GLY A  36      40.113  45.981  63.854  1.00 20.71           C  
ATOM    269  C   GLY A  36      40.268  45.219  62.548  1.00 20.12           C  
ATOM    270  O   GLY A  36      41.364  45.127  61.996  1.00 21.13           O  
ATOM    271  N   THR A  37      39.166  44.659  62.061  1.00 19.52           N  
ATOM    272  CA  THR A  37      39.172  43.914  60.807  1.00 18.69           C  
ATOM    273  C   THR A  37      38.206  44.601  59.850  1.00 16.68           C  
ATOM    274  O   THR A  37      37.457  45.488  60.256  1.00 15.93           O  
ATOM    275  CB  THR A  37      38.722  42.448  61.010  1.00 20.17           C  
ATOM    276  OG1 THR A  37      37.367  42.417  61.474  1.00 21.73           O  
ATOM    277  CG2 THR A  37      39.611  41.756  62.026  1.00 22.19           C  
ATOM    278  N   ALA A  38      38.223  44.206  58.582  1.00 15.73           N  
ATOM    279  CA  ALA A  38      37.325  44.816  57.611  1.00 15.31           C  
ATOM    280  C   ALA A  38      35.878  44.668  58.074  1.00 15.61           C  
ATOM    281  O   ALA A  38      35.415  43.561  58.352  1.00 16.72           O  
ATOM    282  CB  ALA A  38      37.515  44.171  56.246  1.00 16.59           C  
ATOM    283  N   HIS A  39      35.171  45.790  58.164  1.00 15.14           N  
ATOM    284  CA  HIS A  39      33.778  45.796  58.600  1.00 14.63           C  
ATOM    285  C   HIS A  39      32.941  44.947  57.643  1.00 14.71           C  
ATOM    286  O   HIS A  39      33.141  44.982  56.425  1.00 14.79           O  
ATOM    287  CB  HIS A  39      33.271  47.243  58.631  1.00 15.00           C  
ATOM    288  CG  HIS A  39      31.966  47.431  59.345  1.00 14.83           C  
ATOM    289  ND1 HIS A  39      30.762  46.988  58.838  1.00 15.41           N  
ATOM    290  CD2 HIS A  39      31.672  48.071  60.501  1.00 15.14           C  
ATOM    291  CE1 HIS A  39      29.784  47.355  59.648  1.00 15.85           C  
ATOM    292  NE2 HIS A  39      30.311  48.014  60.665  1.00 16.18           N  
ATOM    293  N   GLY A  40      32.013  44.174  58.199  1.00 14.59           N  
ATOM    294  CA  GLY A  40      31.167  43.329  57.373  1.00 14.56           C  
ATOM    295  C   GLY A  40      30.432  44.128  56.317  1.00 15.16           C  
ATOM    296  O   GLY A  40      30.141  43.624  55.228  1.00 15.04           O  
ATOM    297  N   GLY A  41      30.124  45.380  56.643  1.00 14.11           N  
ATOM    298  CA  GLY A  41      29.423  46.247  55.716  1.00 14.82           C  
ATOM    299  C   GLY A  41      30.279  46.647  54.531  1.00 14.38           C  
ATOM    300  O   GLY A  41      29.760  46.912  53.447  1.00 14.50           O  
ATOM    301  N   PHE A  42      31.592  46.707  54.732  1.00 14.45           N  
ATOM    302  CA  PHE A  42      32.481  47.062  53.635  1.00 13.41           C  
ATOM    303  C   PHE A  42      32.562  45.885  52.671  1.00 13.55           C  
ATOM    304  O   PHE A  42      32.459  46.059  51.456  1.00 13.46           O  
ATOM    305  CB  PHE A  42      33.884  47.399  54.142  1.00 14.32           C  
ATOM    306  CG  PHE A  42      34.879  47.609  53.039  1.00 14.13           C  
ATOM    307  CD1 PHE A  42      34.845  48.765  52.265  1.00 14.31           C  
ATOM    308  CD2 PHE A  42      35.809  46.622  52.728  1.00 14.78           C  
ATOM    309  CE1 PHE A  42      35.722  48.933  51.193  1.00 15.16           C  
ATOM    310  CE2 PHE A  42      36.689  46.781  51.659  1.00 15.21           C  
ATOM    311  CZ  PHE A  42      36.643  47.938  50.890  1.00 15.06           C  
ATOM    312  N   LEU A  43      32.751  44.684  53.213  1.00 12.86           N  
ATOM    313  CA  LEU A  43      32.837  43.495  52.376  1.00 13.05           C  
ATOM    314  C   LEU A  43      31.511  43.269  51.659  1.00 12.81           C  
ATOM    315  O   LEU A  43      31.486  42.896  50.486  1.00 13.09           O  
ATOM    316  CB  LEU A  43      33.212  42.275  53.220  1.00 13.88           C  
ATOM    317  CG  LEU A  43      34.593  42.369  53.880  1.00 14.68           C  
ATOM    318  CD1 LEU A  43      34.845  41.120  54.706  1.00 17.44           C  
ATOM    319  CD2 LEU A  43      35.674  42.538  52.815  1.00 17.46           C  
ATOM    320  N   TYR A  44      30.406  43.502  52.357  1.00 12.77           N  
ATOM    321  CA  TYR A  44      29.101  43.340  51.735  1.00 13.18           C  
ATOM    322  C   TYR A  44      28.916  44.382  50.633  1.00 13.41           C  
ATOM    323  O   TYR A  44      28.437  44.059  49.548  1.00 12.86           O  
ATOM    324  CB  TYR A  44      27.981  43.472  52.772  1.00 12.70           C  
ATOM    325  CG  TYR A  44      26.589  43.328  52.188  1.00 12.14           C  
ATOM    326  CD1 TYR A  44      25.948  44.408  51.575  1.00 13.19           C  
ATOM    327  CD2 TYR A  44      25.919  42.108  52.240  1.00 13.59           C  
ATOM    328  CE1 TYR A  44      24.673  44.273  51.029  1.00 14.52           C  
ATOM    329  CE2 TYR A  44      24.649  41.961  51.698  1.00 14.81           C  
ATOM    330  CZ  TYR A  44      24.030  43.044  51.098  1.00 15.32           C  
ATOM    331  OH  TYR A  44      22.763  42.891  50.577  1.00 19.14           O  
ATOM    332  N   ALA A  45      29.301  45.627  50.904  1.00 12.95           N  
ATOM    333  CA  ALA A  45      29.163  46.685  49.907  1.00 13.18           C  
ATOM    334  C   ALA A  45      29.917  46.315  48.635  1.00 12.80           C  
ATOM    335  O   ALA A  45      29.449  46.572  47.525  1.00 13.19           O  
ATOM    336  CB  ALA A  45      29.686  48.003  50.464  1.00 13.58           C  
ATOM    337  N   LEU A  46      31.089  45.713  48.804  1.00 13.07           N  
ATOM    338  CA  LEU A  46      31.902  45.289  47.672  1.00 12.68           C  
ATOM    339  C   LEU A  46      31.150  44.239  46.856  1.00 13.00           C  
ATOM    340  O   LEU A  46      31.010  44.364  45.640  1.00 13.50           O  
ATOM    341  CB  LEU A  46      33.225  44.706  48.173  1.00 14.50           C  
ATOM    342  CG  LEU A  46      34.190  44.177  47.114  1.00 15.57           C  
ATOM    343  CD1 LEU A  46      34.782  45.343  46.332  1.00 18.34           C  
ATOM    344  CD2 LEU A  46      35.296  43.384  47.788  1.00 17.72           C  
ATOM    345  N   ALA A  47      30.659  43.205  47.532  1.00 12.50           N  
ATOM    346  CA  ALA A  47      29.928  42.140  46.854  1.00 12.56           C  
ATOM    347  C   ALA A  47      28.646  42.665  46.224  1.00 12.88           C  
ATOM    348  O   ALA A  47      28.320  42.328  45.085  1.00 13.03           O  
ATOM    349  CB  ALA A  47      29.606  41.023  47.840  1.00 12.09           C  
ATOM    350  N   ASP A  48      27.924  43.495  46.969  1.00 12.80           N  
ATOM    351  CA  ASP A  48      26.673  44.066  46.493  1.00 13.20           C  
ATOM    352  C   ASP A  48      26.884  44.916  45.247  1.00 14.10           C  
ATOM    353  O   ASP A  48      26.029  44.952  44.362  1.00 14.04           O  
ATOM    354  CB  ASP A  48      26.038  44.918  47.593  1.00 14.66           C  
ATOM    355  CG  ASP A  48      24.663  45.409  47.219  1.00 17.48           C  
ATOM    356  OD1 ASP A  48      23.761  44.564  47.061  1.00 21.61           O  
ATOM    357  OD2 ASP A  48      24.482  46.634  47.078  1.00 18.77           O  
ATOM    358  N   SER A  49      28.019  45.603  45.180  1.00 13.59           N  
ATOM    359  CA  SER A  49      28.317  46.440  44.022  1.00 13.98           C  
ATOM    360  C   SER A  49      28.518  45.585  42.769  1.00 13.60           C  
ATOM    361  O   SER A  49      28.033  45.935  41.694  1.00 13.99           O  
ATOM    362  CB  SER A  49      29.555  47.299  44.291  1.00 14.37           C  
ATOM    363  OG  SER A  49      29.304  48.230  45.332  1.00 15.77           O  
ATOM    364  N   ALA A  50      29.228  44.468  42.906  1.00 12.60           N  
ATOM    365  CA  ALA A  50      29.446  43.573  41.771  1.00 12.22           C  
ATOM    366  C   ALA A  50      28.099  42.967  41.364  1.00 13.11           C  
ATOM    367  O   ALA A  50      27.802  42.817  40.180  1.00 13.55           O  
ATOM    368  CB  ALA A  50      30.430  42.476  42.152  1.00 12.42           C  
ATOM    369  N   PHE A  51      27.297  42.624  42.368  1.00 12.24           N  
ATOM    370  CA  PHE A  51      25.958  42.060  42.199  1.00 12.17           C  
ATOM    371  C   PHE A  51      25.076  43.048  41.427  1.00 12.44           C  
ATOM    372  O   PHE A  51      24.383  42.675  40.478  1.00 12.62           O  
ATOM    373  CB  PHE A  51      25.399  41.782  43.606  1.00 12.36           C  
ATOM    374  CG  PHE A  51      23.920  41.509  43.668  1.00 12.07           C  
ATOM    375  CD1 PHE A  51      23.362  40.404  43.037  1.00 14.74           C  
ATOM    376  CD2 PHE A  51      23.102  42.312  44.456  1.00 14.49           C  
ATOM    377  CE1 PHE A  51      22.013  40.097  43.202  1.00 16.75           C  
ATOM    378  CE2 PHE A  51      21.752  42.014  44.626  1.00 13.35           C  
ATOM    379  CZ  PHE A  51      21.210  40.903  43.999  1.00 15.70           C  
ATOM    380  N   ALA A  52      25.123  44.313  41.835  1.00 12.59           N  
ATOM    381  CA  ALA A  52      24.343  45.362  41.190  1.00 14.10           C  
ATOM    382  C   ALA A  52      24.729  45.537  39.726  1.00 14.58           C  
ATOM    383  O   ALA A  52      23.868  45.588  38.848  1.00 14.42           O  
ATOM    384  CB  ALA A  52      24.535  46.676  41.933  1.00 15.24           C  
ATOM    385  N   LEU A  53      26.027  45.631  39.462  1.00 13.94           N  
ATOM    386  CA  LEU A  53      26.486  45.811  38.093  1.00 14.60           C  
ATOM    387  C   LEU A  53      26.152  44.609  37.213  1.00 14.71           C  
ATOM    388  O   LEU A  53      25.633  44.769  36.107  1.00 15.21           O  
ATOM    389  CB  LEU A  53      27.992  46.092  38.074  1.00 15.73           C  
ATOM    390  CG  LEU A  53      28.383  47.463  38.639  1.00 17.27           C  
ATOM    391  CD1 LEU A  53      29.894  47.617  38.616  1.00 19.13           C  
ATOM    392  CD2 LEU A  53      27.720  48.570  37.824  1.00 21.21           C  
ATOM    393  N   ALA A  54      26.433  43.405  37.701  1.00 14.02           N  
ATOM    394  CA  ALA A  54      26.144  42.208  36.919  1.00 14.59           C  
ATOM    395  C   ALA A  54      24.657  42.094  36.597  1.00 14.48           C  
ATOM    396  O   ALA A  54      24.277  41.853  35.453  1.00 15.13           O  
ATOM    397  CB  ALA A  54      26.607  40.962  37.667  1.00 13.69           C  
ATOM    398  N   SER A  55      23.812  42.267  37.606  1.00 13.82           N  
ATOM    399  CA  SER A  55      22.378  42.148  37.390  1.00 13.61           C  
ATOM    400  C   SER A  55      21.807  43.221  36.470  1.00 14.64           C  
ATOM    401  O   SER A  55      20.926  42.940  35.658  1.00 15.80           O  
ATOM    402  CB  SER A  55      21.631  42.157  38.732  1.00 14.45           C  
ATOM    403  OG  SER A  55      21.861  43.353  39.460  1.00 14.44           O  
ATOM    404  N   ASN A  56      22.314  44.443  36.575  1.00 15.20           N  
ATOM    405  CA  ASN A  56      21.792  45.514  35.743  1.00 15.44           C  
ATOM    406  C   ASN A  56      22.219  45.459  34.282  1.00 16.42           C  
ATOM    407  O   ASN A  56      21.710  46.222  33.464  1.00 16.70           O  
ATOM    408  CB  ASN A  56      22.107  46.868  36.383  1.00 17.53           C  
ATOM    409  CG  ASN A  56      21.116  47.221  37.485  1.00 19.12           C  
ATOM    410  OD1 ASN A  56      20.100  47.876  37.240  1.00 20.56           O  
ATOM    411  ND2 ASN A  56      21.390  46.757  38.700  1.00 22.83           N  
ATOM    412  N   THR A  57      23.134  44.556  33.942  1.00 15.32           N  
ATOM    413  CA  THR A  57      23.533  44.419  32.540  1.00 15.90           C  
ATOM    414  C   THR A  57      22.364  43.786  31.786  1.00 16.85           C  
ATOM    415  O   THR A  57      22.331  43.802  30.557  1.00 18.51           O  
ATOM    416  CB  THR A  57      24.763  43.500  32.344  1.00 15.44           C  
ATOM    417  OG1 THR A  57      24.473  42.189  32.852  1.00 16.55           O  
ATOM    418  CG2 THR A  57      25.980  44.073  33.040  1.00 16.55           C  
ATOM    419  N   ARG A  58      21.412  43.222  32.527  1.00 16.04           N  
ATOM    420  CA  ARG A  58      20.241  42.580  31.925  1.00 16.33           C  
ATOM    421  C   ARG A  58      19.042  43.520  31.885  1.00 17.90           C  
ATOM    422  O   ARG A  58      17.995  43.179  31.332  1.00 21.87           O  
ATOM    423  CB  ARG A  58      19.839  41.334  32.722  1.00 16.29           C  
ATOM    424  CG  ARG A  58      20.924  40.286  32.890  1.00 15.83           C  
ATOM    425  CD  ARG A  58      21.461  39.813  31.551  1.00 15.17           C  
ATOM    426  NE  ARG A  58      22.216  38.572  31.688  1.00 15.18           N  
ATOM    427  CZ  ARG A  58      22.890  37.994  30.700  1.00 16.24           C  
ATOM    428  NH1 ARG A  58      22.912  38.549  29.495  1.00 18.86           N  
ATOM    429  NH2 ARG A  58      23.529  36.852  30.911  1.00 17.21           N  
ATOM    430  N   GLY A  59      19.201  44.697  32.477  1.00 17.31           N  
ATOM    431  CA  GLY A  59      18.117  45.660  32.530  1.00 18.39           C  
ATOM    432  C   GLY A  59      17.958  46.117  33.967  1.00 19.14           C  
ATOM    433  O   GLY A  59      18.528  45.500  34.868  1.00 18.53           O  
ATOM    434  N   PRO A  60      17.195  47.188  34.222  1.00 19.22           N  
ATOM    435  CA  PRO A  60      16.990  47.698  35.581  1.00 19.04           C  
ATOM    436  C   PRO A  60      16.544  46.617  36.558  1.00 17.97           C  
ATOM    437  O   PRO A  60      15.591  45.885  36.296  1.00 18.67           O  
ATOM    438  CB  PRO A  60      15.931  48.778  35.385  1.00 19.36           C  
ATOM    439  CG  PRO A  60      16.251  49.296  34.011  1.00 21.70           C  
ATOM    440  CD  PRO A  60      16.479  48.020  33.238  1.00 19.98           C  
ATOM    441  N   ALA A  61      17.237  46.533  37.688  1.00 17.87           N  
ATOM    442  CA  ALA A  61      16.914  45.535  38.699  1.00 18.04           C  
ATOM    443  C   ALA A  61      17.307  46.025  40.082  1.00 18.65           C  
ATOM    444  O   ALA A  61      18.299  46.739  40.237  1.00 20.51           O  
ATOM    445  CB  ALA A  61      17.635  44.230  38.388  1.00 19.58           C  
ATOM    446  N   VAL A  62      16.520  45.640  41.081  1.00 17.81           N  
ATOM    447  CA  VAL A  62      16.790  46.022  42.459  1.00 18.24           C  
ATOM    448  C   VAL A  62      16.821  44.773  43.326  1.00 16.25           C  
ATOM    449  O   VAL A  62      16.092  43.810  43.080  1.00 16.24           O  
ATOM    450  CB  VAL A  62      15.722  46.997  43.004  1.00 19.85           C  
ATOM    451  CG1 VAL A  62      15.797  48.319  42.248  1.00 22.83           C  
ATOM    452  CG2 VAL A  62      14.340  46.384  42.877  1.00 22.25           C  
ATOM    453  N   ALA A  63      17.669  44.796  44.344  1.00 15.72           N  
ATOM    454  CA  ALA A  63      17.807  43.656  45.234  1.00 14.17           C  
ATOM    455  C   ALA A  63      16.557  43.346  46.039  1.00 14.23           C  
ATOM    456  O   ALA A  63      15.852  44.249  46.494  1.00 13.92           O  
ATOM    457  CB  ALA A  63      18.972  43.885  46.184  1.00 15.66           C  
ATOM    458  N   LEU A  64      16.288  42.055  46.195  1.00 12.51           N  
ATOM    459  CA  LEU A  64      15.174  41.583  47.002  1.00 12.41           C  
ATOM    460  C   LEU A  64      15.773  40.965  48.263  1.00 12.24           C  
ATOM    461  O   LEU A  64      15.581  41.477  49.364  1.00 11.65           O  
ATOM    462  CB  LEU A  64      14.349  40.527  46.257  1.00 14.18           C  
ATOM    463  CG  LEU A  64      13.428  41.010  45.131  1.00 13.53           C  
ATOM    464  CD1 LEU A  64      12.767  39.808  44.475  1.00 14.84           C  
ATOM    465  CD2 LEU A  64      12.376  41.961  45.687  1.00 14.62           C  
ATOM    466  N   SER A  65      16.522  39.877  48.090  1.00 12.13           N  
ATOM    467  CA  SER A  65      17.139  39.173  49.212  1.00 12.04           C  
ATOM    468  C   SER A  65      18.584  38.798  48.928  1.00 12.09           C  
ATOM    469  O   SER A  65      18.894  38.257  47.867  1.00 12.27           O  
ATOM    470  CB  SER A  65      16.353  37.899  49.519  1.00 12.83           C  
ATOM    471  OG  SER A  65      16.899  37.233  50.645  1.00 13.33           O  
ATOM    472  N   CYS A  66      19.461  39.072  49.890  1.00 11.58           N  
ATOM    473  CA  CYS A  66      20.876  38.759  49.749  1.00 12.08           C  
ATOM    474  C   CYS A  66      21.415  38.078  50.993  1.00 12.36           C  
ATOM    475  O   CYS A  66      21.041  38.423  52.116  1.00 13.36           O  
ATOM    476  CB  CYS A  66      21.676  40.035  49.495  1.00 12.38           C  
ATOM    477  SG  CYS A  66      21.110  40.955  48.054  1.00 14.16           S  
ATOM    478  N   ARG A  67      22.295  37.106  50.783  1.00 11.24           N  
ATOM    479  CA  ARG A  67      22.920  36.374  51.876  1.00 11.34           C  
ATOM    480  C   ARG A  67      24.423  36.569  51.780  1.00 10.66           C  
ATOM    481  O   ARG A  67      25.000  36.524  50.690  1.00 11.59           O  
ATOM    482  CB  ARG A  67      22.594  34.882  51.783  1.00 11.00           C  
ATOM    483  CG  ARG A  67      23.277  34.011  52.841  1.00 12.04           C  
ATOM    484  CD  ARG A  67      22.949  32.548  52.577  1.00 11.51           C  
ATOM    485  NE  ARG A  67      23.665  31.618  53.449  1.00 11.50           N  
ATOM    486  CZ  ARG A  67      23.123  30.964  54.472  1.00 12.21           C  
ATOM    487  NH1 ARG A  67      21.841  31.128  54.780  1.00 12.16           N  
ATOM    488  NH2 ARG A  67      23.863  30.118  55.175  1.00 12.74           N  
ATOM    489  N   MET A  68      25.051  36.798  52.925  1.00 11.26           N  
ATOM    490  CA  MET A  68      26.489  36.987  52.981  1.00 11.72           C  
ATOM    491  C   MET A  68      27.061  36.017  54.010  1.00 11.31           C  
ATOM    492  O   MET A  68      26.700  36.074  55.190  1.00 10.91           O  
ATOM    493  CB  MET A  68      26.813  38.428  53.384  1.00 13.35           C  
ATOM    494  CG  MET A  68      28.291  38.759  53.393  1.00 13.75           C  
ATOM    495  SD  MET A  68      28.988  38.876  51.739  1.00 15.97           S  
ATOM    496  CE  MET A  68      30.521  39.744  52.107  1.00 15.04           C  
ATOM    497  N   ASP A  69      27.928  35.118  53.554  1.00 11.17           N  
ATOM    498  CA  ASP A  69      28.572  34.141  54.427  1.00 11.29           C  
ATOM    499  C   ASP A  69      30.042  34.529  54.539  1.00 11.76           C  
ATOM    500  O   ASP A  69      30.748  34.604  53.536  1.00 11.76           O  
ATOM    501  CB  ASP A  69      28.424  32.730  53.848  1.00 11.97           C  
ATOM    502  CG  ASP A  69      26.988  32.234  53.888  1.00 11.88           C  
ATOM    503  OD1 ASP A  69      26.376  32.276  54.976  1.00 13.07           O  
ATOM    504  OD2 ASP A  69      26.473  31.793  52.839  1.00 12.57           O  
ATOM    505  N   TYR A  70      30.488  34.782  55.765  1.00 11.33           N  
ATOM    506  CA  TYR A  70      31.864  35.206  56.032  1.00 11.41           C  
ATOM    507  C   TYR A  70      32.755  34.045  56.446  1.00 11.73           C  
ATOM    508  O   TYR A  70      32.415  33.296  57.363  1.00 12.10           O  
ATOM    509  CB  TYR A  70      31.856  36.259  57.141  1.00 12.38           C  
ATOM    510  CG  TYR A  70      31.100  37.518  56.787  1.00 12.44           C  
ATOM    511  CD1 TYR A  70      31.743  38.595  56.182  1.00 13.23           C  
ATOM    512  CD2 TYR A  70      29.740  37.636  57.063  1.00 13.72           C  
ATOM    513  CE1 TYR A  70      31.052  39.761  55.864  1.00 13.09           C  
ATOM    514  CE2 TYR A  70      29.039  38.795  56.748  1.00 14.10           C  
ATOM    515  CZ  TYR A  70      29.704  39.853  56.149  1.00 14.34           C  
ATOM    516  OH  TYR A  70      29.029  41.009  55.844  1.00 15.56           O  
ATOM    517  N   PHE A  71      33.908  33.910  55.789  1.00 12.26           N  
ATOM    518  CA  PHE A  71      34.822  32.809  56.099  1.00 12.70           C  
ATOM    519  C   PHE A  71      36.148  33.210  56.731  1.00 14.34           C  
ATOM    520  O   PHE A  71      36.652  32.509  57.610  1.00 15.75           O  
ATOM    521  CB  PHE A  71      35.135  31.992  54.840  1.00 13.28           C  
ATOM    522  CG  PHE A  71      33.922  31.566  54.066  1.00 12.11           C  
ATOM    523  CD1 PHE A  71      32.834  30.982  54.707  1.00 12.69           C  
ATOM    524  CD2 PHE A  71      33.873  31.739  52.688  1.00 13.33           C  
ATOM    525  CE1 PHE A  71      31.713  30.575  53.984  1.00 12.87           C  
ATOM    526  CE2 PHE A  71      32.758  31.336  51.958  1.00 12.83           C  
ATOM    527  CZ  PHE A  71      31.677  30.754  52.606  1.00 12.41           C  
ATOM    528  N   ARG A  72      36.720  34.319  56.272  1.00 16.05           N  
ATOM    529  CA  ARG A  72      38.014  34.766  56.779  1.00 17.35           C  
ATOM    530  C   ARG A  72      38.047  36.275  56.975  1.00 17.34           C  
ATOM    531  O   ARG A  72      37.527  37.023  56.153  1.00 17.83           O  
ATOM    532  CB  ARG A  72      39.116  34.373  55.787  1.00 19.56           C  
ATOM    533  CG  ARG A  72      39.056  32.923  55.315  1.00 22.73           C  
ATOM    534  CD  ARG A  72      39.871  32.719  54.039  1.00 26.26           C  
ATOM    535  NE  ARG A  72      41.307  32.882  54.253  1.00 30.64           N  
ATOM    536  CZ  ARG A  72      42.082  31.984  54.851  1.00 32.75           C  
ATOM    537  NH1 ARG A  72      41.563  30.848  55.300  1.00 35.43           N  
ATOM    538  NH2 ARG A  72      43.379  32.220  55.002  1.00 34.43           N  
ATOM    539  N   PRO A  73      38.661  36.741  58.072  1.00 17.43           N  
ATOM    540  CA  PRO A  73      38.743  38.181  58.327  1.00 18.13           C  
ATOM    541  C   PRO A  73      39.855  38.808  57.489  1.00 17.57           C  
ATOM    542  O   PRO A  73      40.783  38.117  57.062  1.00 18.75           O  
ATOM    543  CB  PRO A  73      39.047  38.242  59.820  1.00 19.94           C  
ATOM    544  CG  PRO A  73      39.919  37.041  60.011  1.00 21.44           C  
ATOM    545  CD  PRO A  73      39.185  35.975  59.216  1.00 19.18           C  
ATOM    546  N   LEU A  74      39.749  40.108  57.241  1.00 16.74           N  
ATOM    547  CA  LEU A  74      40.763  40.826  56.472  1.00 17.88           C  
ATOM    548  C   LEU A  74      41.226  42.053  57.242  1.00 17.31           C  
ATOM    549  O   LEU A  74      40.440  42.698  57.935  1.00 18.35           O  
ATOM    550  CB  LEU A  74      40.212  41.264  55.113  1.00 17.75           C  
ATOM    551  CG  LEU A  74      39.942  40.173  54.075  1.00 18.75           C  
ATOM    552  CD1 LEU A  74      39.431  40.821  52.801  1.00 19.51           C  
ATOM    553  CD2 LEU A  74      41.220  39.386  53.796  1.00 19.73           C  
ATOM    554  N   GLY A  75      42.509  42.371  57.117  1.00 17.82           N  
ATOM    555  CA  GLY A  75      43.044  43.526  57.811  1.00 18.59           C  
ATOM    556  C   GLY A  75      43.302  44.681  56.865  1.00 18.99           C  
ATOM    557  O   GLY A  75      43.157  44.544  55.647  1.00 18.45           O  
ATOM    558  N   ALA A  76      43.681  45.825  57.422  1.00 19.91           N  
ATOM    559  CA  ALA A  76      43.965  47.000  56.613  1.00 20.21           C  
ATOM    560  C   ALA A  76      45.033  46.672  55.579  1.00 19.52           C  
ATOM    561  O   ALA A  76      46.005  45.973  55.875  1.00 19.83           O  
ATOM    562  CB  ALA A  76      44.433  48.146  57.502  1.00 21.99           C  
ATOM    563  N   GLY A  77      44.842  47.172  54.363  1.00 18.94           N  
ATOM    564  CA  GLY A  77      45.801  46.933  53.301  1.00 18.91           C  
ATOM    565  C   GLY A  77      45.462  45.771  52.388  1.00 19.20           C  
ATOM    566  O   GLY A  77      46.020  45.649  51.298  1.00 20.43           O  
ATOM    567  N   ALA A  78      44.547  44.912  52.821  1.00 17.76           N  
ATOM    568  CA  ALA A  78      44.167  43.764  52.012  1.00 17.20           C  
ATOM    569  C   ALA A  78      43.478  44.177  50.718  1.00 17.21           C  
ATOM    570  O   ALA A  78      42.604  45.047  50.716  1.00 17.73           O  
ATOM    571  CB  ALA A  78      43.252  42.841  52.809  1.00 18.37           C  
ATOM    572  N   ARG A  79      43.899  43.558  49.620  1.00 17.80           N  
ATOM    573  CA  ARG A  79      43.311  43.803  48.309  1.00 18.71           C  
ATOM    574  C   ARG A  79      42.230  42.740  48.172  1.00 18.14           C  
ATOM    575  O   ARG A  79      42.503  41.548  48.326  1.00 19.11           O  
ATOM    576  CB  ARG A  79      44.357  43.623  47.206  1.00 21.26           C  
ATOM    577  CG  ARG A  79      45.421  44.710  47.149  1.00 27.64           C  
ATOM    578  CD  ARG A  79      44.841  46.024  46.643  1.00 32.56           C  
ATOM    579  NE  ARG A  79      45.880  47.010  46.364  1.00 36.95           N  
ATOM    580  CZ  ARG A  79      45.651  48.212  45.841  1.00 39.23           C  
ATOM    581  NH1 ARG A  79      44.414  48.582  45.539  1.00 39.36           N  
ATOM    582  NH2 ARG A  79      46.661  49.044  45.619  1.00 40.76           N  
ATOM    583  N   VAL A  80      41.008  43.165  47.884  1.00 16.66           N  
ATOM    584  CA  VAL A  80      39.903  42.226  47.770  1.00 16.32           C  
ATOM    585  C   VAL A  80      39.087  42.448  46.500  1.00 15.66           C  
ATOM    586  O   VAL A  80      38.989  43.568  45.999  1.00 15.37           O  
ATOM    587  CB  VAL A  80      38.996  42.338  49.021  1.00 18.35           C  
ATOM    588  CG1 VAL A  80      38.430  43.742  49.121  1.00 20.53           C  
ATOM    589  CG2 VAL A  80      37.894  41.296  48.978  1.00 19.05           C  
ATOM    590  N   GLU A  81      38.515  41.364  45.986  1.00 14.76           N  
ATOM    591  CA  GLU A  81      37.701  41.395  44.775  1.00 16.08           C  
ATOM    592  C   GLU A  81      36.386  40.664  44.996  1.00 14.18           C  
ATOM    593  O   GLU A  81      36.319  39.718  45.781  1.00 15.02           O  
ATOM    594  CB  GLU A  81      38.424  40.695  43.622  1.00 19.06           C  
ATOM    595  CG  GLU A  81      39.532  41.473  42.955  1.00 23.06           C  
ATOM    596  CD  GLU A  81      40.272  40.625  41.936  1.00 22.56           C  
ATOM    597  OE1 GLU A  81      39.669  39.659  41.412  1.00 24.95           O  
ATOM    598  OE2 GLU A  81      41.449  40.926  41.654  1.00 27.57           O  
ATOM    599  N   ALA A  82      35.347  41.106  44.298  1.00 13.16           N  
ATOM    600  CA  ALA A  82      34.040  40.462  44.360  1.00 13.12           C  
ATOM    601  C   ALA A  82      33.716  40.076  42.919  1.00 13.42           C  
ATOM    602  O   ALA A  82      33.603  40.939  42.043  1.00 13.76           O  
ATOM    603  CB  ALA A  82      32.994  41.413  44.908  1.00 12.94           C  
ATOM    604  N   ARG A  83      33.596  38.774  42.681  1.00 12.51           N  
ATOM    605  CA  ARG A  83      33.324  38.237  41.352  1.00 13.17           C  
ATOM    606  C   ARG A  83      31.893  37.731  41.256  1.00 13.01           C  
ATOM    607  O   ARG A  83      31.548  36.709  41.852  1.00 12.84           O  
ATOM    608  CB  ARG A  83      34.305  37.102  41.062  1.00 13.50           C  
ATOM    609  CG  ARG A  83      35.754  37.513  41.264  1.00 16.26           C  
ATOM    610  CD  ARG A  83      36.675  36.316  41.325  1.00 19.61           C  
ATOM    611  NE  ARG A  83      38.064  36.722  41.521  1.00 21.65           N  
ATOM    612  CZ  ARG A  83      39.074  35.872  41.669  1.00 21.84           C  
ATOM    613  NH1 ARG A  83      38.848  34.567  41.645  1.00 23.16           N  
ATOM    614  NH2 ARG A  83      40.309  36.330  41.831  1.00 23.83           N  
ATOM    615  N   ALA A  84      31.067  38.446  40.497  1.00 12.51           N  
ATOM    616  CA  ALA A  84      29.663  38.092  40.338  1.00 11.56           C  
ATOM    617  C   ALA A  84      29.379  37.333  39.051  1.00 13.06           C  
ATOM    618  O   ALA A  84      29.814  37.736  37.972  1.00 13.63           O  
ATOM    619  CB  ALA A  84      28.804  39.355  40.393  1.00 13.18           C  
ATOM    620  N   VAL A  85      28.654  36.227  39.181  1.00 12.52           N  
ATOM    621  CA  VAL A  85      28.270  35.411  38.037  1.00 13.33           C  
ATOM    622  C   VAL A  85      26.776  35.129  38.137  1.00 13.91           C  
ATOM    623  O   VAL A  85      26.217  35.040  39.230  1.00 14.08           O  
ATOM    624  CB  VAL A  85      29.038  34.069  37.989  1.00 14.36           C  
ATOM    625  CG1 VAL A  85      30.531  34.326  37.895  1.00 15.42           C  
ATOM    626  CG2 VAL A  85      28.708  33.225  39.207  1.00 16.41           C  
ATOM    627  N   GLU A  86      26.132  34.986  36.987  1.00 13.36           N  
ATOM    628  CA  GLU A  86      24.699  34.739  36.930  1.00 12.99           C  
ATOM    629  C   GLU A  86      24.363  33.267  37.145  1.00 13.97           C  
ATOM    630  O   GLU A  86      24.911  32.393  36.472  1.00 15.72           O  
ATOM    631  CB  GLU A  86      24.174  35.206  35.577  1.00 14.26           C  
ATOM    632  CG  GLU A  86      22.684  35.402  35.501  1.00 15.03           C  
ATOM    633  CD  GLU A  86      22.300  36.077  34.209  1.00 15.51           C  
ATOM    634  OE1 GLU A  86      22.286  35.394  33.164  1.00 16.94           O  
ATOM    635  OE2 GLU A  86      22.039  37.294  34.241  1.00 15.62           O  
ATOM    636  N   VAL A  87      23.457  33.009  38.084  1.00 13.11           N  
ATOM    637  CA  VAL A  87      23.034  31.649  38.416  1.00 14.78           C  
ATOM    638  C   VAL A  87      21.704  31.317  37.743  1.00 14.24           C  
ATOM    639  O   VAL A  87      21.493  30.200  37.269  1.00 14.95           O  
ATOM    640  CB  VAL A  87      22.886  31.486  39.956  1.00 16.18           C  
ATOM    641  CG1 VAL A  87      22.350  30.105  40.291  1.00 18.91           C  
ATOM    642  CG2 VAL A  87      24.235  31.706  40.634  1.00 19.02           C  
ATOM    643  N   ASN A  88      20.806  32.294  37.709  1.00 13.29           N  
ATOM    644  CA  ASN A  88      19.502  32.112  37.088  1.00 13.18           C  
ATOM    645  C   ASN A  88      18.961  33.436  36.590  1.00 13.88           C  
ATOM    646  O   ASN A  88      19.072  34.457  37.268  1.00 13.88           O  
ATOM    647  CB  ASN A  88      18.495  31.534  38.084  1.00 14.31           C  
ATOM    648  CG  ASN A  88      17.100  31.430  37.494  1.00 14.01           C  
ATOM    649  OD1 ASN A  88      16.811  30.517  36.721  1.00 16.25           O  
ATOM    650  ND2 ASN A  88      16.237  32.379  37.837  1.00 14.76           N  
ATOM    651  N   LEU A  89      18.380  33.415  35.396  1.00 14.57           N  
ATOM    652  CA  LEU A  89      17.780  34.607  34.823  1.00 14.61           C  
ATOM    653  C   LEU A  89      16.347  34.267  34.428  1.00 15.37           C  
ATOM    654  O   LEU A  89      16.115  33.481  33.508  1.00 16.81           O  
ATOM    655  CB  LEU A  89      18.559  35.080  33.593  1.00 15.17           C  
ATOM    656  CG  LEU A  89      18.029  36.350  32.915  1.00 15.48           C  
ATOM    657  CD1 LEU A  89      18.054  37.512  33.897  1.00 16.74           C  
ATOM    658  CD2 LEU A  89      18.876  36.673  31.691  1.00 17.58           C  
ATOM    659  N   SER A  90      15.390  34.838  35.151  1.00 15.51           N  
ATOM    660  CA  SER A  90      13.978  34.616  34.867  1.00 16.36           C  
ATOM    661  C   SER A  90      13.390  35.922  34.349  1.00 17.07           C  
ATOM    662  O   SER A  90      14.081  36.935  34.288  1.00 17.08           O  
ATOM    663  CB  SER A  90      13.235  34.165  36.129  1.00 16.02           C  
ATOM    664  OG  SER A  90      13.631  32.856  36.511  1.00 17.45           O  
ATOM    665  N   ARG A  91      12.115  35.897  33.977  1.00 19.19           N  
ATOM    666  CA  ARG A  91      11.465  37.089  33.452  1.00 20.28           C  
ATOM    667  C   ARG A  91      11.428  38.264  34.428  1.00 19.39           C  
ATOM    668  O   ARG A  91      11.773  39.387  34.059  1.00 19.97           O  
ATOM    669  CB  ARG A  91      10.041  36.749  32.999  1.00 24.02           C  
ATOM    670  CG  ARG A  91       9.244  37.942  32.484  1.00 29.47           C  
ATOM    671  CD  ARG A  91       7.934  37.488  31.853  1.00 33.76           C  
ATOM    672  NE  ARG A  91       7.071  38.608  31.489  1.00 38.11           N  
ATOM    673  CZ  ARG A  91       6.429  39.377  32.364  1.00 40.32           C  
ATOM    674  NH1 ARG A  91       6.549  39.148  33.665  1.00 41.85           N  
ATOM    675  NH2 ARG A  91       5.664  40.373  31.939  1.00 42.07           N  
ATOM    676  N   ARG A  92      11.025  38.011  35.670  1.00 18.40           N  
ATOM    677  CA  ARG A  92      10.930  39.089  36.651  1.00 18.31           C  
ATOM    678  C   ARG A  92      11.923  39.040  37.808  1.00 15.75           C  
ATOM    679  O   ARG A  92      11.920  39.926  38.663  1.00 16.45           O  
ATOM    680  CB  ARG A  92       9.506  39.161  37.217  1.00 20.20           C  
ATOM    681  CG  ARG A  92       8.423  39.403  36.168  1.00 24.77           C  
ATOM    682  CD  ARG A  92       8.786  40.550  35.231  1.00 28.17           C  
ATOM    683  NE  ARG A  92       8.997  41.816  35.929  1.00 30.79           N  
ATOM    684  CZ  ARG A  92       8.034  42.525  36.509  1.00 32.35           C  
ATOM    685  NH1 ARG A  92       6.780  42.096  36.482  1.00 34.28           N  
ATOM    686  NH2 ARG A  92       8.326  43.670  37.113  1.00 33.12           N  
ATOM    687  N   THR A  93      12.770  38.016  37.838  1.00 15.14           N  
ATOM    688  CA  THR A  93      13.769  37.889  38.896  1.00 15.02           C  
ATOM    689  C   THR A  93      15.033  37.247  38.339  1.00 13.95           C  
ATOM    690  O   THR A  93      15.007  36.615  37.287  1.00 14.62           O  
ATOM    691  CB  THR A  93      13.261  37.014  40.069  1.00 14.90           C  
ATOM    692  OG1 THR A  93      12.889  35.723  39.576  1.00 16.30           O  
ATOM    693  CG2 THR A  93      12.065  37.666  40.754  1.00 16.18           C  
ATOM    694  N   ALA A  94      16.144  37.425  39.044  1.00 13.33           N  
ATOM    695  CA  ALA A  94      17.419  36.849  38.633  1.00 12.78           C  
ATOM    696  C   ALA A  94      18.264  36.645  39.884  1.00 13.14           C  
ATOM    697  O   ALA A  94      18.127  37.384  40.859  1.00 13.16           O  
ATOM    698  CB  ALA A  94      18.137  37.774  37.646  1.00 13.25           C  
ATOM    699  N   THR A  95      19.133  35.641  39.853  1.00 12.88           N  
ATOM    700  CA  THR A  95      19.975  35.330  40.998  1.00 12.70           C  
ATOM    701  C   THR A  95      21.442  35.258  40.596  1.00 12.57           C  
ATOM    702  O   THR A  95      21.781  34.749  39.525  1.00 12.68           O  
ATOM    703  CB  THR A  95      19.524  34.000  41.636  1.00 12.05           C  
ATOM    704  OG1 THR A  95      18.172  34.138  42.089  1.00 12.44           O  
ATOM    705  CG2 THR A  95      20.417  33.628  42.816  1.00 13.55           C  
ATOM    706  N   TYR A  96      22.301  35.779  41.468  1.00 12.06           N  
ATOM    707  CA  TYR A  96      23.737  35.818  41.226  1.00 11.99           C  
ATOM    708  C   TYR A  96      24.542  35.325  42.413  1.00 11.98           C  
ATOM    709  O   TYR A  96      24.127  35.470  43.563  1.00 13.32           O  
ATOM    710  CB  TYR A  96      24.175  37.257  40.911  1.00 12.96           C  
ATOM    711  CG  TYR A  96      23.493  37.832  39.700  1.00 12.31           C  
ATOM    712  CD1 TYR A  96      22.159  38.238  39.753  1.00 12.88           C  
ATOM    713  CD2 TYR A  96      24.139  37.852  38.466  1.00 12.97           C  
ATOM    714  CE1 TYR A  96      21.481  38.632  38.604  1.00 14.18           C  
ATOM    715  CE2 TYR A  96      23.471  38.244  37.310  1.00 13.06           C  
ATOM    716  CZ  TYR A  96      22.142  38.624  37.388  1.00 14.41           C  
ATOM    717  OH  TYR A  96      21.454  38.941  36.240  1.00 15.29           O  
ATOM    718  N   ARG A  97      25.693  34.734  42.115  1.00 12.15           N  
ATOM    719  CA  ARG A  97      26.617  34.269  43.138  1.00 13.00           C  
ATOM    720  C   ARG A  97      27.815  35.201  43.052  1.00 13.26           C  
ATOM    721  O   ARG A  97      28.324  35.465  41.960  1.00 13.98           O  
ATOM    722  CB  ARG A  97      27.082  32.834  42.878  1.00 14.87           C  
ATOM    723  CG  ARG A  97      28.377  32.501  43.622  1.00 18.56           C  
ATOM    724  CD  ARG A  97      28.736  31.025  43.599  1.00 21.60           C  
ATOM    725  NE  ARG A  97      28.751  30.459  42.255  1.00 24.48           N  
ATOM    726  CZ  ARG A  97      27.759  29.742  41.734  1.00 25.01           C  
ATOM    727  NH1 ARG A  97      26.665  29.498  42.446  1.00 24.43           N  
ATOM    728  NH2 ARG A  97      27.865  29.267  40.501  1.00 26.28           N  
ATOM    729  N   VAL A  98      28.258  35.706  44.195  1.00 11.77           N  
ATOM    730  CA  VAL A  98      29.400  36.602  44.220  1.00 12.16           C  
ATOM    731  C   VAL A  98      30.460  36.090  45.182  1.00 12.97           C  
ATOM    732  O   VAL A  98      30.237  36.017  46.392  1.00 13.39           O  
ATOM    733  CB  VAL A  98      28.990  38.032  44.642  1.00 12.22           C  
ATOM    734  CG1 VAL A  98      30.189  38.967  44.539  1.00 12.86           C  
ATOM    735  CG2 VAL A  98      27.856  38.536  43.756  1.00 14.83           C  
ATOM    736  N   GLU A  99      31.609  35.716  44.635  1.00 12.66           N  
ATOM    737  CA  GLU A  99      32.710  35.233  45.452  1.00 13.04           C  
ATOM    738  C   GLU A  99      33.609  36.403  45.827  1.00 13.23           C  
ATOM    739  O   GLU A  99      34.025  37.177  44.964  1.00 13.95           O  
ATOM    740  CB  GLU A  99      33.513  34.179  44.689  1.00 13.84           C  
ATOM    741  CG  GLU A  99      32.825  32.822  44.620  1.00 15.98           C  
ATOM    742  CD  GLU A  99      33.611  31.803  43.821  1.00 20.21           C  
ATOM    743  OE1 GLU A  99      34.845  31.959  43.706  1.00 22.22           O  
ATOM    744  OE2 GLU A  99      32.994  30.839  43.319  1.00 23.55           O  
ATOM    745  N   VAL A 100      33.883  36.542  47.118  1.00 13.19           N  
ATOM    746  CA  VAL A 100      34.751  37.608  47.610  1.00 12.75           C  
ATOM    747  C   VAL A 100      36.098  36.942  47.857  1.00 13.08           C  
ATOM    748  O   VAL A 100      36.222  36.055  48.706  1.00 14.13           O  
ATOM    749  CB  VAL A 100      34.189  38.230  48.903  1.00 13.07           C  
ATOM    750  CG1 VAL A 100      35.087  39.361  49.377  1.00 13.97           C  
ATOM    751  CG2 VAL A 100      32.782  38.760  48.641  1.00 14.67           C  
ATOM    752  N   VAL A 101      37.099  37.379  47.098  1.00 13.69           N  
ATOM    753  CA  VAL A 101      38.429  36.792  47.146  1.00 14.53           C  
ATOM    754  C   VAL A 101      39.551  37.771  47.461  1.00 15.56           C  
ATOM    755  O   VAL A 101      39.534  38.919  47.020  1.00 15.88           O  
ATOM    756  CB  VAL A 101      38.740  36.121  45.784  1.00 15.53           C  
ATOM    757  CG1 VAL A 101      40.096  35.437  45.822  1.00 17.34           C  
ATOM    758  CG2 VAL A 101      37.640  35.128  45.431  1.00 16.53           C  
ATOM    759  N   SER A 102      40.530  37.308  48.229  1.00 15.52           N  
ATOM    760  CA  SER A 102      41.689  38.125  48.570  1.00 16.46           C  
ATOM    761  C   SER A 102      42.905  37.214  48.574  1.00 18.24           C  
ATOM    762  O   SER A 102      42.938  36.215  49.290  1.00 18.46           O  
ATOM    763  CB  SER A 102      41.526  38.782  49.943  1.00 16.13           C  
ATOM    764  OG  SER A 102      42.663  39.585  50.244  1.00 18.27           O  
ATOM    765  N   GLU A 103      43.892  37.559  47.755  1.00 20.67           N  
ATOM    766  CA  GLU A 103      45.118  36.777  47.647  1.00 23.73           C  
ATOM    767  C   GLU A 103      44.836  35.295  47.395  1.00 23.30           C  
ATOM    768  O   GLU A 103      45.440  34.423  48.020  1.00 24.84           O  
ATOM    769  CB  GLU A 103      45.963  36.942  48.912  1.00 25.90           C  
ATOM    770  CG  GLU A 103      46.387  38.379  49.192  1.00 30.20           C  
ATOM    771  CD  GLU A 103      47.143  39.005  48.034  1.00 33.76           C  
ATOM    772  OE1 GLU A 103      48.159  38.423  47.598  1.00 36.71           O  
ATOM    773  OE2 GLU A 103      46.724  40.084  47.560  1.00 35.64           O  
ATOM    774  N   GLY A 104      43.907  35.024  46.483  1.00 22.56           N  
ATOM    775  CA  GLY A 104      43.571  33.654  46.134  1.00 22.94           C  
ATOM    776  C   GLY A 104      42.728  32.867  47.121  1.00 22.49           C  
ATOM    777  O   GLY A 104      42.477  31.681  46.907  1.00 25.29           O  
ATOM    778  N   LYS A 105      42.286  33.509  48.197  1.00 20.64           N  
ATOM    779  CA  LYS A 105      41.470  32.827  49.198  1.00 19.53           C  
ATOM    780  C   LYS A 105      40.031  33.329  49.176  1.00 17.21           C  
ATOM    781  O   LYS A 105      39.790  34.521  48.991  1.00 16.11           O  
ATOM    782  CB  LYS A 105      42.056  33.050  50.595  1.00 21.92           C  
ATOM    783  CG  LYS A 105      43.493  32.570  50.762  1.00 26.40           C  
ATOM    784  CD  LYS A 105      43.604  31.064  50.596  1.00 29.73           C  
ATOM    785  CE  LYS A 105      45.036  30.592  50.799  1.00 32.67           C  
ATOM    786  NZ  LYS A 105      45.545  30.940  52.153  1.00 34.73           N  
ATOM    787  N   LEU A 106      39.078  32.420  49.364  1.00 16.82           N  
ATOM    788  CA  LEU A 106      37.667  32.798  49.387  1.00 15.70           C  
ATOM    789  C   LEU A 106      37.353  33.340  50.777  1.00 15.53           C  
ATOM    790  O   LEU A 106      37.250  32.588  51.748  1.00 16.46           O  
ATOM    791  CB  LEU A 106      36.774  31.595  49.077  1.00 16.16           C  
ATOM    792  CG  LEU A 106      35.275  31.892  48.945  1.00 13.32           C  
ATOM    793  CD1 LEU A 106      35.021  32.796  47.742  1.00 15.07           C  
ATOM    794  CD2 LEU A 106      34.512  30.586  48.787  1.00 16.30           C  
ATOM    795  N   VAL A 107      37.208  34.657  50.853  1.00 13.82           N  
ATOM    796  CA  VAL A 107      36.938  35.366  52.100  1.00 15.31           C  
ATOM    797  C   VAL A 107      35.464  35.341  52.500  1.00 13.64           C  
ATOM    798  O   VAL A 107      35.134  35.327  53.689  1.00 13.29           O  
ATOM    799  CB  VAL A 107      37.405  36.840  51.977  1.00 17.33           C  
ATOM    800  CG1 VAL A 107      37.015  37.633  53.214  1.00 20.07           C  
ATOM    801  CG2 VAL A 107      38.912  36.883  51.774  1.00 20.59           C  
ATOM    802  N   ALA A 108      34.582  35.337  51.506  1.00 12.93           N  
ATOM    803  CA  ALA A 108      33.146  35.327  51.762  1.00 11.65           C  
ATOM    804  C   ALA A 108      32.389  34.919  50.510  1.00 11.84           C  
ATOM    805  O   ALA A 108      32.929  34.961  49.404  1.00 12.64           O  
ATOM    806  CB  ALA A 108      32.682  36.711  52.222  1.00 12.74           C  
ATOM    807  N   LEU A 109      31.138  34.517  50.702  1.00 11.90           N  
ATOM    808  CA  LEU A 109      30.271  34.113  49.603  1.00 12.13           C  
ATOM    809  C   LEU A 109      28.964  34.883  49.729  1.00 12.44           C  
ATOM    810  O   LEU A 109      28.317  34.861  50.777  1.00 12.12           O  
ATOM    811  CB  LEU A 109      29.980  32.612  49.665  1.00 14.05           C  
ATOM    812  CG  LEU A 109      29.006  32.094  48.601  1.00 14.09           C  
ATOM    813  CD1 LEU A 109      29.647  32.201  47.227  1.00 16.24           C  
ATOM    814  CD2 LEU A 109      28.634  30.649  48.902  1.00 16.39           C  
ATOM    815  N   PHE A 110      28.582  35.552  48.649  1.00 12.54           N  
ATOM    816  CA  PHE A 110      27.363  36.348  48.600  1.00 12.38           C  
ATOM    817  C   PHE A 110      26.416  35.707  47.589  1.00 12.19           C  
ATOM    818  O   PHE A 110      26.830  35.295  46.509  1.00 13.70           O  
ATOM    819  CB  PHE A 110      27.754  37.785  48.205  1.00 12.18           C  
ATOM    820  CG  PHE A 110      26.597  38.710  47.917  1.00 12.89           C  
ATOM    821  CD1 PHE A 110      25.827  38.557  46.765  1.00 13.53           C  
ATOM    822  CD2 PHE A 110      26.345  39.799  48.749  1.00 12.87           C  
ATOM    823  CE1 PHE A 110      24.831  39.481  46.444  1.00 14.29           C  
ATOM    824  CE2 PHE A 110      25.352  40.727  48.434  1.00 15.07           C  
ATOM    825  CZ  PHE A 110      24.597  40.566  47.279  1.00 14.19           C  
ATOM    826  N   THR A 111      25.149  35.593  47.969  1.00 11.17           N  
ATOM    827  CA  THR A 111      24.128  35.016  47.104  1.00 12.05           C  
ATOM    828  C   THR A 111      22.985  36.022  47.104  1.00 12.66           C  
ATOM    829  O   THR A 111      22.456  36.355  48.161  1.00 14.43           O  
ATOM    830  CB  THR A 111      23.623  33.671  47.666  1.00 14.00           C  
ATOM    831  OG1 THR A 111      24.742  32.828  47.973  1.00 15.43           O  
ATOM    832  CG2 THR A 111      22.736  32.969  46.644  1.00 15.92           C  
ATOM    833  N   GLY A 112      22.599  36.516  45.934  1.00 12.42           N  
ATOM    834  CA  GLY A 112      21.533  37.501  45.903  1.00 12.68           C  
ATOM    835  C   GLY A 112      20.549  37.372  44.763  1.00 12.72           C  
ATOM    836  O   GLY A 112      20.892  36.905  43.678  1.00 12.21           O  
ATOM    837  N   THR A 113      19.314  37.786  45.024  1.00 12.07           N  
ATOM    838  CA  THR A 113      18.258  37.741  44.026  1.00 12.54           C  
ATOM    839  C   THR A 113      17.683  39.133  43.838  1.00 12.96           C  
ATOM    840  O   THR A 113      17.443  39.854  44.808  1.00 12.45           O  
ATOM    841  CB  THR A 113      17.141  36.779  44.457  1.00 12.03           C  
ATOM    842  OG1 THR A 113      17.655  35.442  44.455  1.00 13.27           O  
ATOM    843  CG2 THR A 113      15.952  36.865  43.504  1.00 13.63           C  
ATOM    844  N   VAL A 114      17.478  39.510  42.581  1.00 12.63           N  
ATOM    845  CA  VAL A 114      16.922  40.814  42.250  1.00 13.56           C  
ATOM    846  C   VAL A 114      15.544  40.682  41.635  1.00 13.78           C  
ATOM    847  O   VAL A 114      15.144  39.608  41.173  1.00 13.99           O  
ATOM    848  CB  VAL A 114      17.777  41.583  41.204  1.00 13.61           C  
ATOM    849  CG1 VAL A 114      19.139  41.909  41.760  1.00 15.21           C  
ATOM    850  CG2 VAL A 114      17.892  40.763  39.920  1.00 14.67           C  
ATOM    851  N   PHE A 115      14.827  41.798  41.639  1.00 14.85           N  
ATOM    852  CA  PHE A 115      13.518  41.888  41.023  1.00 15.56           C  
ATOM    853  C   PHE A 115      13.800  42.729  39.782  1.00 16.42           C  
ATOM    854  O   PHE A 115      14.406  43.797  39.880  1.00 17.53           O  
ATOM    855  CB  PHE A 115      12.533  42.610  41.944  1.00 18.13           C  
ATOM    856  CG  PHE A 115      11.179  42.824  41.330  1.00 21.19           C  
ATOM    857  CD1 PHE A 115      10.865  44.027  40.706  1.00 23.13           C  
ATOM    858  CD2 PHE A 115      10.224  41.814  41.358  1.00 22.87           C  
ATOM    859  CE1 PHE A 115       9.615  44.219  40.116  1.00 24.98           C  
ATOM    860  CE2 PHE A 115       8.973  41.995  40.772  1.00 25.01           C  
ATOM    861  CZ  PHE A 115       8.669  43.200  40.150  1.00 24.43           C  
ATOM    862  N   ARG A 116      13.398  42.231  38.618  1.00 17.29           N  
ATOM    863  CA  ARG A 116      13.631  42.951  37.371  1.00 18.25           C  
ATOM    864  C   ARG A 116      12.483  43.916  37.114  1.00 20.45           C  
ATOM    865  O   ARG A 116      11.329  43.505  36.992  1.00 20.76           O  
ATOM    866  CB  ARG A 116      13.773  41.957  36.218  1.00 18.31           C  
ATOM    867  CG  ARG A 116      14.828  40.886  36.479  1.00 19.37           C  
ATOM    868  CD  ARG A 116      14.991  39.967  35.286  1.00 18.34           C  
ATOM    869  NE  ARG A 116      15.607  40.658  34.157  1.00 17.98           N  
ATOM    870  CZ  ARG A 116      15.634  40.186  32.916  1.00 18.64           C  
ATOM    871  NH1 ARG A 116      15.075  39.016  32.635  1.00 18.91           N  
ATOM    872  NH2 ARG A 116      16.223  40.884  31.955  1.00 18.94           N  
ATOM    873  N   LEU A 117      12.814  45.201  37.045  1.00 22.30           N  
ATOM    874  CA  LEU A 117      11.823  46.251  36.831  1.00 25.52           C  
ATOM    875  C   LEU A 117      11.341  46.321  35.386  1.00 27.42           C  
ATOM    876  O   LEU A 117      11.968  45.685  34.516  1.00 28.62           O  
ATOM    877  CB  LEU A 117      12.416  47.603  37.238  1.00 26.11           C  
ATOM    878  CG  LEU A 117      12.981  47.703  38.659  1.00 27.37           C  
ATOM    879  CD1 LEU A 117      13.690  49.038  38.833  1.00 28.37           C  
ATOM    880  CD2 LEU A 117      11.859  47.548  39.674  1.00 29.13           C  
TER     881      LEU A 117                                                      
END
MOLECULE T0479.pdb
ATOM      1  N   THR     6      34.108  56.591  39.835  1.00 82.67           N  
ATOM      2  CA  THR     6      32.687  57.041  39.783  1.00 84.71           C  
ATOM      3  C   THR     6      31.847  56.242  38.792  1.00 84.83           C  
ATOM      4  O   THR     6      30.746  55.797  39.120  1.00 87.33           O  
ATOM      5  CB  THR     6      32.594  58.552  39.443  1.00 84.63           C  
ATOM      6  OG1 THR     6      32.669  59.310  40.659  1.00 80.59           O  
ATOM      7  CG2 THR     6      31.288  58.884  38.714  1.00 85.06           C  
ATOM      8  N   ASP     7      32.357  56.052  37.583  1.00 82.92           N  
ATOM      9  CA  ASP     7      31.608  55.292  36.597  1.00 82.53           C  
ATOM     10  C   ASP     7      31.505  53.876  37.126  1.00 82.43           C  
ATOM     11  O   ASP     7      32.507  53.164  37.202  1.00 83.40           O  
ATOM     12  CB  ASP     7      32.337  55.281  35.254  1.00 83.34           C  
ATOM     13  CG  ASP     7      31.398  55.058  34.080  1.00 83.13           C  
ATOM     14  OD1 ASP     7      31.411  55.902  33.161  1.00 90.62           O  
ATOM     15  OD2 ASP     7      30.652  54.052  34.068  1.00 82.94           O  
ATOM     16  N   PHE     8      30.302  53.477  37.524  1.00 81.00           N  
ATOM     17  CA  PHE     8      30.095  52.129  38.022  1.00 78.25           C  
ATOM     18  C   PHE     8      29.206  51.420  37.035  1.00 78.12           C  
ATOM     19  O   PHE     8      27.993  51.364  37.192  1.00 78.37           O  
ATOM     20  CB  PHE     8      29.455  52.141  39.411  1.00 77.96           C  
ATOM     21  CG  PHE     8      30.418  52.466  40.517  1.00 75.33           C  
ATOM     22  CD1 PHE     8      30.264  53.616  41.272  1.00 73.58           C  
ATOM     23  CD2 PHE     8      31.496  51.628  40.791  1.00 69.75           C  
ATOM     24  CE1 PHE     8      31.172  53.932  42.287  1.00 72.35           C  
ATOM     25  CE2 PHE     8      32.404  51.929  41.799  1.00 67.03           C  
ATOM     26  CZ  PHE     8      32.243  53.085  42.549  1.00 69.31           C  
ATOM     27  N   PHE     9      29.835  50.909  35.989  1.00 79.06           N  
ATOM     28  CA  PHE     9      29.150  50.169  34.948  1.00 79.09           C  
ATOM     29  C   PHE     9      27.978  50.911  34.325  1.00 79.86           C  
ATOM     30  O   PHE     9      26.979  50.298  33.945  1.00 80.70           O  
ATOM     31  CB  PHE     9      28.690  48.836  35.517  1.00 79.01           C  
ATOM     32  CG  PHE     9      29.776  48.084  36.228  1.00 77.86           C  
ATOM     33  CD1 PHE     9      30.883  47.602  35.536  1.00 80.20           C  
ATOM     34  CD2 PHE     9      29.691  47.850  37.594  1.00 75.84           C  
ATOM     35  CE1 PHE     9      31.889  46.890  36.201  1.00 77.51           C  
ATOM     36  CE2 PHE     9      30.689  47.142  38.263  1.00 74.21           C  
ATOM     37  CZ  PHE     9      31.788  46.661  37.567  1.00 74.96           C  
ATOM     38  N   GLY    10      28.102  52.230  34.216  1.00 81.37           N  
ATOM     39  CA  GLY    10      27.041  53.016  33.610  1.00 81.99           C  
ATOM     40  C   GLY    10      26.223  53.898  34.534  1.00 82.45           C  
ATOM     41  O   GLY    10      25.148  54.363  34.148  1.00 83.24           O  
ATOM     42  N   LEU    11      26.724  54.138  35.742  1.00 81.84           N  
ATOM     43  CA  LEU    11      26.015  54.971  36.704  1.00 80.93           C  
ATOM     44  C   LEU    11      26.885  55.422  37.864  1.00 81.11           C  
ATOM     45  O   LEU    11      27.854  54.752  38.224  1.00 81.55           O  
ATOM     46  CB  LEU    11      24.792  54.226  37.245  1.00 82.16           C  
ATOM     47  CG  LEU    11      24.869  52.706  37.388  1.00 80.12           C  
ATOM     48  CD1 LEU    11      24.789  52.279  38.854  1.00 80.11           C  
ATOM     49  CD2 LEU    11      23.717  52.108  36.594  1.00 78.58           C  
ATOM     50  N   THR    12      26.541  56.567  38.444  1.00 81.94           N  
ATOM     51  CA  THR    12      27.287  57.083  39.583  1.00 81.54           C  
ATOM     52  C   THR    12      26.555  56.700  40.869  1.00 80.32           C  
ATOM     53  O   THR    12      25.343  56.884  40.994  1.00 80.81           O  
ATOM     54  CB  THR    12      27.491  58.640  39.490  1.00 82.25           C  
ATOM     55  OG1 THR    12      27.647  59.186  40.808  1.00 81.93           O  
ATOM     56  CG2 THR    12      26.328  59.308  38.779  1.00 80.77           C  
ATOM     57  N   ILE    13      27.311  56.133  41.803  1.00 78.25           N  
ATOM     58  CA  ILE    13      26.793  55.681  43.085  1.00 73.63           C  
ATOM     59  C   ILE    13      27.597  56.362  44.187  1.00 72.82           C  
ATOM     60  O   ILE    13      28.654  55.878  44.583  1.00 73.86           O  
ATOM     61  CB  ILE    13      26.945  54.157  43.209  1.00 72.50           C  
ATOM     62  CG1 ILE    13      26.386  53.476  41.959  1.00 70.72           C  
ATOM     63  CG2 ILE    13      26.218  53.660  44.444  1.00 69.64           C  
ATOM     64  CD1 ILE    13      26.615  51.973  41.912  1.00 66.94           C  
ATOM     65  N   PRO    14      27.097  57.496  44.701  1.00 71.54           N  
ATOM     66  CA  PRO    14      27.744  58.277  45.759  1.00 70.83           C  
ATOM     67  C   PRO    14      28.279  57.487  46.948  1.00 70.92           C  
ATOM     68  O   PRO    14      29.261  57.894  47.573  1.00 72.37           O  
ATOM     69  CB  PRO    14      26.659  59.259  46.170  1.00 70.62           C  
ATOM     70  CG  PRO    14      25.953  59.505  44.881  1.00 70.49           C  
ATOM     71  CD  PRO    14      25.818  58.114  44.315  1.00 70.58           C  
ATOM     72  N   PHE    15      27.644  56.369  47.277  1.00 70.30           N  
ATOM     73  CA  PHE    15      28.112  55.580  48.413  1.00 68.63           C  
ATOM     74  C   PHE    15      29.290  54.712  47.992  1.00 69.27           C  
ATOM     75  O   PHE    15      30.270  54.582  48.727  1.00 68.96           O  
ATOM     76  CB  PHE    15      26.985  54.703  48.979  1.00 66.76           C  
ATOM     77  CG  PHE    15      27.407  53.863  50.158  1.00 62.75           C  
ATOM     78  CD1 PHE    15      27.964  54.455  51.288  1.00 65.47           C  
ATOM     79  CD2 PHE    15      27.258  52.480  50.135  1.00 60.04           C  
ATOM     80  CE1 PHE    15      28.366  53.683  52.381  1.00 63.65           C  
ATOM     81  CE2 PHE    15      27.656  51.697  51.219  1.00 59.43           C  
ATOM     82  CZ  PHE    15      28.212  52.301  52.347  1.00 57.78           C  
ATOM     83  N   MET    16      29.191  54.120  46.806  1.00 68.50           N  
ATOM     84  CA  MET    16      30.266  53.276  46.314  1.00 69.92           C  
ATOM     85  C   MET    16      31.532  54.105  46.109  1.00 70.28           C  
ATOM     86  O   MET    16      32.628  53.687  46.484  1.00 69.63           O  
ATOM     87  CB  MET    16      29.843  52.593  45.012  1.00 68.25           C  
ATOM     88  CG  MET    16      28.836  51.462  45.210  1.00 71.30           C  
ATOM     89  SD  MET    16      29.518  49.996  46.318  1.00 82.26          SE  
ATOM     90  CE  MET    16      28.397  50.232  47.881  1.00 81.23           C  
ATOM     91  N   GLN    17      31.367  55.287  45.525  1.00 71.35           N  
ATOM     92  CA  GLN    17      32.486  56.187  45.280  1.00 73.14           C  
ATOM     93  C   GLN    17      33.152  56.495  46.615  1.00 72.71           C  
ATOM     94  O   GLN    17      34.353  56.744  46.677  1.00 72.94           O  
ATOM     95  CB  GLN    17      31.983  57.490  44.639  1.00 74.17           C  
ATOM     96  CG  GLN    17      33.075  58.494  44.271  1.00 78.87           C  
ATOM     97  CD  GLN    17      32.597  59.942  44.333  1.00 85.45           C  
ATOM     98  OE1 GLN    17      31.612  60.318  43.696  1.00 90.09           O  
ATOM     99  NE2 GLN    17      33.302  60.762  45.105  1.00 86.55           N  
ATOM    100  N   LEU    18      32.356  56.466  47.683  1.00 72.85           N  
ATOM    101  CA  LEU    18      32.837  56.759  49.032  1.00 71.27           C  
ATOM    102  C   LEU    18      33.668  55.626  49.622  1.00 71.30           C  
ATOM    103  O   LEU    18      34.567  55.862  50.431  1.00 70.93           O  
ATOM    104  CB  LEU    18      31.647  57.058  49.950  1.00 70.66           C  
ATOM    105  CG  LEU    18      31.844  57.860  51.244  1.00 69.80           C  
ATOM    106  CD1 LEU    18      31.930  56.948  52.446  1.00 73.18           C  
ATOM    107  CD2 LEU    18      33.078  58.730  51.117  1.00 67.63           C  
ATOM    108  N   LEU    19      33.362  54.396  49.214  1.00 71.25           N  
ATOM    109  CA  LEU    19      34.081  53.224  49.701  1.00 71.47           C  
ATOM    110  C   LEU    19      35.415  53.043  48.998  1.00 73.05           C  
ATOM    111  O   LEU    19      36.224  52.201  49.390  1.00 73.88           O  
ATOM    112  CB  LEU    19      33.246  51.963  49.496  1.00 70.20           C  
ATOM    113  CG  LEU    19      32.009  51.732  50.363  1.00 69.28           C  
ATOM    114  CD1 LEU    19      31.332  50.437  49.937  1.00 64.95           C  
ATOM    115  CD2 LEU    19      32.405  51.662  51.830  1.00 66.56           C  
ATOM    116  N   GLY    20      35.643  53.827  47.951  1.00 74.73           N  
ATOM    117  CA  GLY    20      36.885  53.704  47.211  1.00 75.28           C  
ATOM    118  C   GLY    20      36.969  52.336  46.555  1.00 76.69           C  
ATOM    119  O   GLY    20      37.965  51.628  46.709  1.00 76.35           O  
ATOM    120  N   VAL    21      35.913  51.954  45.839  1.00 75.90           N  
ATOM    121  CA  VAL    21      35.890  50.665  45.161  1.00 74.91           C  
ATOM    122  C   VAL    21      36.060  50.871  43.656  1.00 74.23           C  
ATOM    123  O   VAL    21      35.609  51.876  43.102  1.00 74.26           O  
ATOM    124  CB  VAL    21      34.569  49.882  45.455  1.00 75.48           C  
ATOM    125  CG1 VAL    21      33.353  50.705  45.059  1.00 75.56           C  
ATOM    126  CG2 VAL    21      34.576  48.554  44.708  1.00 75.52           C  
ATOM    127  N   VAL    22      36.712  49.920  42.997  1.00 73.26           N  
ATOM    128  CA  VAL    22      36.955  50.026  41.563  1.00 71.22           C  
ATOM    129  C   VAL    22      36.297  48.933  40.714  1.00 69.51           C  
ATOM    130  O   VAL    22      36.493  47.745  40.956  1.00 69.28           O  
ATOM    131  CB  VAL    22      38.481  50.019  41.277  1.00 71.44           C  
ATOM    132  CG1 VAL    22      38.734  50.139  39.788  1.00 72.67           C  
ATOM    133  CG2 VAL    22      39.153  51.152  42.024  1.00 68.35           C  
ATOM    134  N   PRO    23      35.488  49.332  39.713  1.00 68.68           N  
ATOM    135  CA  PRO    23      34.795  48.412  38.803  1.00 69.35           C  
ATOM    136  C   PRO    23      35.821  47.787  37.856  1.00 70.07           C  
ATOM    137  O   PRO    23      36.584  48.493  37.208  1.00 70.33           O  
ATOM    138  CB  PRO    23      33.787  49.320  38.085  1.00 68.77           C  
ATOM    139  CG  PRO    23      34.445  50.640  38.103  1.00 69.37           C  
ATOM    140  CD  PRO    23      35.035  50.715  39.491  1.00 68.21           C  
ATOM    141  N   GLU    24      35.827  46.463  37.774  1.00 71.08           N  
ATOM    142  CA  GLU    24      36.811  45.762  36.956  1.00 71.52           C  
ATOM    143  C   GLU    24      36.266  45.026  35.724  1.00 71.28           C  
ATOM    144  O   GLU    24      37.016  44.737  34.787  1.00 72.41           O  
ATOM    145  CB  GLU    24      37.571  44.789  37.863  1.00 71.19           C  
ATOM    146  CG  GLU    24      39.055  44.645  37.574  1.00 74.13           C  
ATOM    147  CD  GLU    24      39.917  44.750  38.828  1.00 77.25           C  
ATOM    148  OE1 GLU    24      40.224  45.885  39.255  1.00 83.15           O  
ATOM    149  OE2 GLU    24      40.295  43.699  39.387  1.00 77.85           O  
ATOM    150  N   HIS    25      34.967  44.735  35.719  1.00 70.76           N  
ATOM    151  CA  HIS    25      34.342  44.017  34.613  1.00 68.54           C  
ATOM    152  C   HIS    25      32.855  43.809  34.849  1.00 68.40           C  
ATOM    153  O   HIS    25      32.388  43.788  35.984  1.00 69.03           O  
ATOM    154  CB  HIS    25      35.002  42.646  34.430  1.00 67.13           C  
ATOM    155  CG  HIS    25      34.233  41.710  33.551  1.00 66.67           C  
ATOM    156  ND1 HIS    25      34.002  40.394  33.883  1.00 64.69           N  
ATOM    157  CD2 HIS    25      33.623  41.902  32.352  1.00 67.64           C  
ATOM    158  CE1 HIS    25      33.284  39.814  32.935  1.00 66.58           C  
ATOM    159  NE2 HIS    25      33.043  40.713  31.996  1.00 67.15           N  
ATOM    160  N   SER    26      32.122  43.645  33.755  1.00 68.39           N  
ATOM    161  CA  SER    26      30.692  43.402  33.785  1.00 67.02           C  
ATOM    162  C   SER    26      30.240  43.026  32.388  1.00 66.04           C  
ATOM    163  O   SER    26      30.387  43.804  31.449  1.00 68.32           O  
ATOM    164  CB  SER    26      29.936  44.647  34.243  1.00 68.40           C  
ATOM    165  OG  SER    26      28.563  44.537  33.896  1.00 69.94           O  
ATOM    166  N   GLY    27      29.690  41.828  32.252  1.00 63.41           N  
ATOM    167  CA  GLY    27      29.224  41.394  30.954  1.00 59.63           C  
ATOM    168  C   GLY    27      29.182  39.889  30.902  1.00 57.60           C  
ATOM    169  O   GLY    27      29.900  39.221  31.635  1.00 59.65           O  
ATOM    170  N   ASN    28      28.337  39.354  30.032  1.00 58.55           N  
ATOM    171  CA  ASN    28      28.200  37.912  29.878  1.00 59.88           C  
ATOM    172  C   ASN    28      27.865  37.168  31.165  1.00 60.45           C  
ATOM    173  O   ASN    28      28.385  36.085  31.409  1.00 58.08           O  
ATOM    174  CB  ASN    28      29.481  37.352  29.275  1.00 61.54           C  
ATOM    175  CG  ASN    28      29.808  37.982  27.943  1.00 59.96           C  
ATOM    176  OD1 ASN    28      29.020  37.900  27.004  1.00 57.88           O  
ATOM    177  ND2 ASN    28      30.971  38.636  27.858  1.00 52.70           N  
ATOM    178  N   GLY    29      27.005  37.764  31.984  1.00 58.42           N  
ATOM    179  CA  GLY    29      26.598  37.118  33.217  1.00 59.39           C  
ATOM    180  C   GLY    29      27.591  37.028  34.362  1.00 58.49           C  
ATOM    181  O   GLY    29      27.400  36.212  35.263  1.00 58.96           O  
ATOM    182  N   THR    30      28.647  37.836  34.339  1.00 55.83           N  
ATOM    183  CA  THR    30      29.626  37.818  35.419  1.00 55.20           C  
ATOM    184  C   THR    30      30.039  39.253  35.687  1.00 54.78           C  
ATOM    185  O   THR    30      29.687  40.152  34.930  1.00 56.63           O  
ATOM    186  CB  THR    30      30.904  37.026  35.054  1.00 55.53           C  
ATOM    187  OG1 THR    30      31.572  37.684  33.977  1.00 59.89           O  
ATOM    188  CG2 THR    30      30.580  35.605  34.655  1.00 55.82           C  
ATOM    189  N   ALA    31      30.784  39.474  36.764  1.00 51.78           N  
ATOM    190  CA  ALA    31      31.237  40.818  37.076  1.00 52.61           C  
ATOM    191  C   ALA    31      32.450  40.790  38.010  1.00 53.18           C  
ATOM    192  O   ALA    31      32.691  39.810  38.709  1.00 52.70           O  
ATOM    193  CB  ALA    31      30.097  41.623  37.693  1.00 51.77           C  
ATOM    194  N   ARG    32      33.225  41.869  38.002  1.00 53.91           N  
ATOM    195  CA  ARG    32      34.407  41.932  38.849  1.00 55.41           C  
ATOM    196  C   ARG    32      34.550  43.326  39.411  1.00 54.45           C  
ATOM    197  O   ARG    32      34.304  44.324  38.727  1.00 51.64           O  
ATOM    198  CB  ARG    32      35.682  41.577  38.061  1.00 56.29           C  
ATOM    199  CG  ARG    32      36.710  40.769  38.870  1.00 60.83           C  
ATOM    200  CD  ARG    32      38.165  41.219  38.659  1.00 68.82           C  
ATOM    201  NE  ARG    32      38.433  41.696  37.302  1.00 67.14           N  
ATOM    202  CZ  ARG    32      38.391  40.946  36.205  1.00 66.56           C  
ATOM    203  NH1 ARG    32      38.096  39.654  36.281  1.00 67.50           N  
ATOM    204  NH2 ARG    32      38.623  41.502  35.025  1.00 69.78           N  
ATOM    205  N   THR    33      34.960  43.386  40.667  1.00 54.04           N  
ATOM    206  CA  THR    33      35.150  44.655  41.328  1.00 54.88           C  
ATOM    207  C   THR    33      36.340  44.494  42.275  1.00 55.51           C  
ATOM    208  O   THR    33      36.741  43.371  42.579  1.00 52.87           O  
ATOM    209  CB  THR    33      33.852  45.066  42.075  1.00 55.35           C  
ATOM    210  OG1 THR    33      33.558  46.442  41.790  1.00 60.23           O  
ATOM    211  CG2 THR    33      33.996  44.881  43.573  1.00 52.69           C  
ATOM    212  N   ARG    34      36.904  45.603  42.744  1.00 58.33           N  
ATOM    213  CA  ARG    34      38.070  45.520  43.620  1.00 61.57           C  
ATOM    214  C   ARG    34      38.011  46.499  44.783  1.00 61.13           C  
ATOM    215  O   ARG    34      37.666  47.668  44.602  1.00 62.13           O  
ATOM    216  CB  ARG    34      39.332  45.759  42.779  1.00 63.11           C  
ATOM    217  CG  ARG    34      40.654  45.547  43.495  1.00 67.81           C  
ATOM    218  CD  ARG    34      41.235  46.851  44.018  1.00 80.63           C  
ATOM    219  NE  ARG    34      42.681  46.919  43.799  1.00 88.82           N  
ATOM    220  CZ  ARG    34      43.252  46.975  42.600  1.00 92.25           C  
ATOM    221  NH1 ARG    34      42.495  46.976  41.508  1.00 90.51           N  
ATOM    222  NH2 ARG    34      44.577  47.025  42.491  1.00 94.91           N  
ATOM    223  N   LEU    35      38.362  46.027  45.976  1.00 60.79           N  
ATOM    224  CA  LEU    35      38.335  46.890  47.153  1.00 61.51           C  
ATOM    225  C   LEU    35      39.714  47.210  47.733  1.00 62.84           C  
ATOM    226  O   LEU    35      40.231  46.501  48.599  1.00 62.23           O  
ATOM    227  CB  LEU    35      37.448  46.280  48.255  1.00 59.96           C  
ATOM    228  CG  LEU    35      37.249  47.164  49.495  1.00 60.64           C  
ATOM    229  CD1 LEU    35      36.531  48.452  49.101  1.00 59.80           C  
ATOM    230  CD2 LEU    35      36.457  46.414  50.561  1.00 58.70           C  
ATOM    231  N   PRO    36      40.331  48.295  47.251  1.00 65.05           N  
ATOM    232  CA  PRO    36      41.650  48.673  47.763  1.00 67.72           C  
ATOM    233  C   PRO    36      41.585  48.959  49.265  1.00 70.63           C  
ATOM    234  O   PRO    36      40.669  49.627  49.738  1.00 71.74           O  
ATOM    235  CB  PRO    36      42.014  49.907  46.923  1.00 67.73           C  
ATOM    236  CG  PRO    36      40.688  50.407  46.404  1.00 66.37           C  
ATOM    237  CD  PRO    36      39.927  49.153  46.126  1.00 64.71           C  
ATOM    238  N   ALA    37      42.554  48.433  50.005  1.00 72.73           N  
ATOM    239  CA  ALA    37      42.600  48.610  51.448  1.00 74.97           C  
ATOM    240  C   ALA    37      42.575  50.073  51.880  1.00 78.06           C  
ATOM    241  O   ALA    37      43.148  50.945  51.224  1.00 79.38           O  
ATOM    242  CB  ALA    37      43.831  47.931  52.011  1.00 75.09           C  
ATOM    243  N   ARG    38      41.900  50.325  52.996  1.00 79.16           N  
ATOM    244  CA  ARG    38      41.790  51.660  53.563  1.00 78.26           C  
ATOM    245  C   ARG    38      41.540  51.448  55.042  1.00 77.89           C  
ATOM    246  O   ARG    38      41.137  50.362  55.451  1.00 78.49           O  
ATOM    247  CB  ARG    38      40.625  52.421  52.930  1.00 77.89           C  
ATOM    248  CG  ARG    38      40.756  53.926  53.029  1.00 79.53           C  
ATOM    249  CD  ARG    38      40.565  54.586  51.666  1.00 82.14           C  
ATOM    250  NE  ARG    38      39.190  54.513  51.173  1.00 81.39           N  
ATOM    251  CZ  ARG    38      38.162  55.157  51.718  1.00 84.11           C  
ATOM    252  NH1 ARG    38      38.346  55.925  52.782  1.00 89.00           N  
ATOM    253  NH2 ARG    38      36.949  55.048  51.192  1.00 82.94           N  
ATOM    254  N   ALA    39      41.789  52.471  55.843  1.00 78.61           N  
ATOM    255  CA  ALA    39      41.587  52.371  57.281  1.00 78.25           C  
ATOM    256  C   ALA    39      40.191  52.864  57.650  1.00 77.22           C  
ATOM    257  O   ALA    39      39.693  52.599  58.737  1.00 76.90           O  
ATOM    258  CB  ALA    39      42.655  53.188  58.002  1.00 79.37           C  
ATOM    259  N   ASP    40      39.573  53.583  56.716  1.00 77.54           N  
ATOM    260  CA  ASP    40      38.217  54.117  56.874  1.00 77.22           C  
ATOM    261  C   ASP    40      37.272  52.931  56.852  1.00 76.30           C  
ATOM    262  O   ASP    40      36.191  52.953  57.435  1.00 76.53           O  
ATOM    263  CB  ASP    40      37.834  54.985  55.677  1.00 77.80           C  
ATOM    264  CG  ASP    40      38.088  56.456  55.898  1.00 85.99           C  
ATOM    265  OD1 ASP    40      39.237  56.832  56.212  1.00 98.38           O  
ATOM    266  OD2 ASP    40      37.132  57.245  55.730  1.00 90.77           O  
ATOM    267  N   LEU    41      37.705  51.895  56.151  1.00 75.06           N  
ATOM    268  CA  LEU    41      36.892  50.708  55.945  1.00 72.63           C  
ATOM    269  C   LEU    41      37.057  49.515  56.884  1.00 71.44           C  
ATOM    270  O   LEU    41      36.544  48.441  56.592  1.00 70.58           O  
ATOM    271  CB  LEU    41      37.106  50.251  54.505  1.00 71.79           C  
ATOM    272  CG  LEU    41      37.033  51.397  53.492  1.00 68.81           C  
ATOM    273  CD1 LEU    41      37.246  50.882  52.077  1.00 64.95           C  
ATOM    274  CD2 LEU    41      35.679  52.077  53.620  1.00 69.58           C  
ATOM    275  N   VAL    42      37.726  49.703  58.018  1.00 71.99           N  
ATOM    276  CA  VAL    42      37.962  48.591  58.931  1.00 72.06           C  
ATOM    277  C   VAL    42      37.052  48.400  60.152  1.00 73.10           C  
ATOM    278  O   VAL    42      36.355  49.307  60.612  1.00 73.13           O  
ATOM    279  CB  VAL    42      39.415  48.608  59.414  1.00 72.55           C  
ATOM    280  CG1 VAL    42      40.361  48.501  58.217  1.00 71.29           C  
ATOM    281  CG2 VAL    42      39.678  49.895  60.186  1.00 74.55           C  
ATOM    282  N   ASN    43      37.100  47.174  60.660  1.00 73.75           N  
ATOM    283  CA  ASN    43      36.350  46.720  61.813  1.00 73.70           C  
ATOM    284  C   ASN    43      37.045  47.260  63.050  1.00 75.36           C  
ATOM    285  O   ASN    43      37.844  48.190  62.959  1.00 75.86           O  
ATOM    286  CB  ASN    43      36.381  45.198  61.840  1.00 73.88           C  
ATOM    287  CG  ASN    43      35.532  44.622  62.932  1.00 76.44           C  
ATOM    288  OD1 ASN    43      35.791  43.522  63.420  1.00 79.26           O  
ATOM    289  ND2 ASN    43      34.499  45.351  63.318  1.00 79.28           N  
ATOM    290  N   SER    44      36.739  46.673  64.203  1.00 76.37           N  
ATOM    291  CA  SER    44      37.373  47.063  65.452  1.00 76.63           C  
ATOM    292  C   SER    44      38.514  46.077  65.656  1.00 77.43           C  
ATOM    293  O   SER    44      39.480  46.368  66.354  1.00 77.64           O  
ATOM    294  CB  SER    44      36.383  46.991  66.626  1.00 76.83           C  
ATOM    295  OG  SER    44      35.894  45.674  66.832  1.00 76.34           O  
ATOM    296  N   ARG    45      38.392  44.904  65.036  1.00 77.30           N  
ATOM    297  CA  ARG    45      39.433  43.875  65.118  1.00 76.19           C  
ATOM    298  C   ARG    45      40.462  44.192  64.038  1.00 73.76           C  
ATOM    299  O   ARG    45      41.314  43.367  63.710  1.00 75.30           O  
ATOM    300  CB  ARG    45      38.855  42.474  64.863  1.00 77.62           C  
ATOM    301  CG  ARG    45      37.828  41.992  65.884  1.00 82.48           C  
ATOM    302  CD  ARG    45      38.476  41.651  67.218  1.00 89.78           C  
ATOM    303  NE  ARG    45      39.206  40.385  67.175  1.00 94.62           N  
ATOM    304  CZ  ARG    45      40.475  40.232  67.546  1.00 94.99           C  
ATOM    305  NH1 ARG    45      41.173  41.271  67.991  1.00 94.14           N  
ATOM    306  NH2 ARG    45      41.045  39.035  67.474  1.00 94.64           N  
ATOM    307  N   GLY    46      40.366  45.394  63.480  1.00 71.52           N  
ATOM    308  CA  GLY    46      41.294  45.803  62.441  1.00 69.47           C  
ATOM    309  C   GLY    46      40.961  45.261  61.065  1.00 69.13           C  
ATOM    310  O   GLY    46      41.449  45.783  60.068  1.00 70.07           O  
ATOM    311  N   ASP    47      40.134  44.215  61.018  1.00 68.65           N  
ATOM    312  CA  ASP    47      39.722  43.582  59.760  1.00 66.23           C  
ATOM    313  C   ASP    47      38.785  44.479  58.971  1.00 65.33           C  
ATOM    314  O   ASP    47      38.190  45.397  59.522  1.00 66.99           O  
ATOM    315  CB  ASP    47      38.988  42.269  60.021  1.00 65.80           C  
ATOM    316  CG  ASP    47      39.787  41.304  60.856  1.00 65.95           C  
ATOM    317  OD1 ASP    47      41.015  41.207  60.634  1.00 62.58           O  
ATOM    318  OD2 ASP    47      39.174  40.625  61.720  1.00 64.21           O  
ATOM    319  N   ILE    48      38.643  44.207  57.679  1.00 63.90           N  
ATOM    320  CA  ILE    48      37.734  44.994  56.859  1.00 63.50           C  
ATOM    321  C   ILE    48      36.328  44.661  57.367  1.00 62.00           C  
ATOM    322  O   ILE    48      35.976  43.489  57.484  1.00 61.57           O  
ATOM    323  CB  ILE    48      37.863  44.625  55.362  1.00 63.31           C  
ATOM    324  CG1 ILE    48      39.299  44.867  54.879  1.00 65.41           C  
ATOM    325  CG2 ILE    48      36.910  45.476  54.528  1.00 61.38           C  
ATOM    326  CD1 ILE    48      39.634  46.327  54.571  1.00 65.73           C  
ATOM    327  N   HIS    49      35.538  45.690  57.683  1.00 60.23           N  
ATOM    328  CA  HIS    49      34.170  45.510  58.203  1.00 57.44           C  
ATOM    329  C   HIS    49      33.256  44.751  57.240  1.00 54.86           C  
ATOM    330  O   HIS    49      33.157  45.102  56.068  1.00 54.28           O  
ATOM    331  CB  HIS    49      33.552  46.876  58.544  1.00 56.59           C  
ATOM    332  CG  HIS    49      32.349  46.792  59.433  1.00 56.51           C  
ATOM    333  ND1 HIS    49      31.101  46.436  58.975  1.00 58.06           N  
ATOM    334  CD2 HIS    49      32.216  46.972  60.772  1.00 61.56           C  
ATOM    335  CE1 HIS    49      30.251  46.396  59.986  1.00 60.97           C  
ATOM    336  NE2 HIS    49      30.905  46.718  61.088  1.00 65.28           N  
ATOM    337  N   GLY    50      32.595  43.716  57.755  1.00 54.28           N  
ATOM    338  CA  GLY    50      31.695  42.898  56.953  1.00 55.82           C  
ATOM    339  C   GLY    50      30.656  43.682  56.173  1.00 54.65           C  
ATOM    340  O   GLY    50      30.128  43.208  55.164  1.00 55.18           O  
ATOM    341  N   GLY    51      30.357  44.883  56.655  1.00 54.63           N  
ATOM    342  CA  GLY    51      29.398  45.719  55.981  1.00 55.34           C  
ATOM    343  C   GLY    51      30.061  46.240  54.732  1.00 57.54           C  
ATOM    344  O   GLY    51      29.413  46.409  53.698  1.00 58.76           O  
ATOM    345  N   THR    52      31.360  46.505  54.826  1.00 56.93           N  
ATOM    346  CA  THR    52      32.106  46.994  53.672  1.00 57.73           C  
ATOM    347  C   THR    52      32.002  45.906  52.619  1.00 55.49           C  
ATOM    348  O   THR    52      31.862  46.185  51.438  1.00 57.15           O  
ATOM    349  CB  THR    52      33.609  47.206  53.980  1.00 59.07           C  
ATOM    350  OG1 THR    52      33.767  47.832  55.261  1.00 64.70           O  
ATOM    351  CG2 THR    52      34.239  48.102  52.924  1.00 58.87           C  
ATOM    352  N   LEU    53      32.051  44.658  53.070  1.00 54.28           N  
ATOM    353  CA  LEU    53      31.973  43.510  52.177  1.00 54.38           C  
ATOM    354  C   LEU    53      30.628  43.370  51.465  1.00 55.08           C  
ATOM    355  O   LEU    53      30.581  43.246  50.238  1.00 56.03           O  
ATOM    356  CB  LEU    53      32.288  42.239  52.961  1.00 54.43           C  
ATOM    357  CG  LEU    53      33.572  42.304  53.795  1.00 52.99           C  
ATOM    358  CD1 LEU    53      33.880  40.929  54.383  1.00 55.86           C  
ATOM    359  CD2 LEU    53      34.726  42.774  52.925  1.00 55.19           C  
ATOM    360  N   MET    54      29.541  43.384  52.236  1.00 54.80           N  
ATOM    361  CA  MET    54      28.196  43.260  51.675  1.00 52.43           C  
ATOM    362  C   MET    54      27.894  44.435  50.724  1.00 52.03           C  
ATOM    363  O   MET    54      27.197  44.277  49.717  1.00 48.73           O  
ATOM    364  CB  MET    54      27.156  43.206  52.810  1.00 52.54           C  
ATOM    365  CG  MET    54      27.322  42.027  53.796  1.00 57.30           C  
ATOM    366  SD  MET    54      26.081  42.067  55.318  1.00 62.48          SE  
ATOM    367  CE  MET    54      25.966  40.226  55.821  1.00 55.10           C  
ATOM    368  N   SER    55      28.438  45.609  51.036  1.00 53.67           N  
ATOM    369  CA  SER    55      28.202  46.791  50.202  1.00 55.48           C  
ATOM    370  C   SER    55      28.807  46.581  48.826  1.00 56.00           C  
ATOM    371  O   SER    55      28.170  46.835  47.805  1.00 52.23           O  
ATOM    372  CB  SER    55      28.831  48.041  50.829  1.00 53.38           C  
ATOM    373  OG  SER    55      28.419  48.209  52.174  1.00 55.87           O  
ATOM    374  N   VAL    56      30.047  46.109  48.807  1.00 57.92           N  
ATOM    375  CA  VAL    56      30.719  45.889  47.547  1.00 57.30           C  
ATOM    376  C   VAL    56      30.127  44.653  46.873  1.00 57.04           C  
ATOM    377  O   VAL    56      30.051  44.578  45.648  1.00 58.85           O  
ATOM    378  CB  VAL    56      32.257  45.762  47.761  1.00 57.64           C  
ATOM    379  CG1 VAL    56      32.630  44.379  48.254  1.00 55.71           C  
ATOM    380  CG2 VAL    56      32.981  46.111  46.492  1.00 58.95           C  
ATOM    381  N   LEU    57      29.675  43.694  47.676  1.00 57.70           N  
ATOM    382  CA  LEU    57      29.079  42.484  47.127  1.00 57.43           C  
ATOM    383  C   LEU    57      27.716  42.797  46.524  1.00 58.80           C  
ATOM    384  O   LEU    57      27.326  42.216  45.516  1.00 60.67           O  
ATOM    385  CB  LEU    57      28.945  41.418  48.217  1.00 57.54           C  
ATOM    386  CG  LEU    57      30.007  40.319  48.211  1.00 55.85           C  
ATOM    387  CD1 LEU    57      29.865  39.434  49.442  1.00 48.35           C  
ATOM    388  CD2 LEU    57      29.846  39.493  46.940  1.00 48.05           C  
ATOM    389  N   ASP    58      26.994  43.728  47.139  1.00 58.06           N  
ATOM    390  CA  ASP    58      25.681  44.110  46.639  1.00 59.20           C  
ATOM    391  C   ASP    58      25.877  44.738  45.273  1.00 57.88           C  
ATOM    392  O   ASP    58      25.250  44.358  44.288  1.00 58.06           O  
ATOM    393  CB  ASP    58      25.027  45.123  47.585  1.00 60.09           C  
ATOM    394  CG  ASP    58      23.591  45.424  47.210  1.00 60.92           C  
ATOM    395  OD1 ASP    58      23.009  44.637  46.434  1.00 64.05           O  
ATOM    396  OD2 ASP    58      23.040  46.430  47.701  1.00 63.82           O  
ATOM    397  N   PHE    59      26.770  45.715  45.241  1.00 59.00           N  
ATOM    398  CA  PHE    59      27.117  46.424  44.024  1.00 59.42           C  
ATOM    399  C   PHE    59      27.459  45.465  42.876  1.00 58.46           C  
ATOM    400  O   PHE    59      26.895  45.545  41.786  1.00 59.38           O  
ATOM    401  CB  PHE    59      28.309  47.339  44.319  1.00 60.78           C  
ATOM    402  CG  PHE    59      28.934  47.934  43.095  1.00 69.86           C  
ATOM    403  CD1 PHE    59      28.140  48.503  42.108  1.00 72.66           C  
ATOM    404  CD2 PHE    59      30.314  47.908  42.921  1.00 75.70           C  
ATOM    405  CE1 PHE    59      28.704  49.034  40.960  1.00 84.13           C  
ATOM    406  CE2 PHE    59      30.892  48.439  41.777  1.00 85.16           C  
ATOM    407  CZ  PHE    59      30.082  49.004  40.791  1.00 89.23           C  
ATOM    408  N   THR    60      28.375  44.543  43.147  1.00 57.19           N  
ATOM    409  CA  THR    60      28.852  43.592  42.152  1.00 55.36           C  
ATOM    410  C   THR    60      27.902  42.472  41.730  1.00 55.78           C  
ATOM    411  O   THR    60      28.014  41.949  40.625  1.00 56.93           O  
ATOM    412  CB  THR    60      30.174  42.972  42.627  1.00 54.97           C  
ATOM    413  OG1 THR    60      31.009  44.011  43.157  1.00 51.98           O  
ATOM    414  CG2 THR    60      30.902  42.282  41.454  1.00 50.54           C  
ATOM    415  N   LEU    61      26.978  42.091  42.601  1.00 54.16           N  
ATOM    416  CA  LEU    61      26.039  41.039  42.254  1.00 53.20           C  
ATOM    417  C   LEU    61      25.080  41.575  41.195  1.00 53.73           C  
ATOM    418  O   LEU    61      24.756  40.893  40.222  1.00 52.67           O  
ATOM    419  CB  LEU    61      25.279  40.571  43.504  1.00 52.15           C  
ATOM    420  CG  LEU    61      26.060  39.700  44.497  1.00 50.32           C  
ATOM    421  CD1 LEU    61      25.558  39.942  45.918  1.00 49.21           C  
ATOM    422  CD2 LEU    61      25.916  38.227  44.122  1.00 47.40           C  
ATOM    423  N   GLY    62      24.633  42.808  41.379  1.00 55.99           N  
ATOM    424  CA  GLY    62      23.719  43.392  40.417  1.00 59.26           C  
ATOM    425  C   GLY    62      24.385  43.577  39.065  1.00 60.09           C  
ATOM    426  O   GLY    62      23.770  43.381  38.018  1.00 61.11           O  
ATOM    427  N   ALA    63      25.659  43.950  39.095  1.00 60.63           N  
ATOM    428  CA  ALA    63      26.419  44.172  37.873  1.00 61.18           C  
ATOM    429  C   ALA    63      26.460  42.954  36.957  1.00 60.04           C  
ATOM    430  O   ALA    63      26.575  43.105  35.750  1.00 61.51           O  
ATOM    431  CB  ALA    63      27.832  44.617  38.219  1.00 61.48           C  
ATOM    432  N   ALA    64      26.374  41.752  37.518  1.00 59.72           N  
ATOM    433  CA  ALA    64      26.404  40.539  36.700  1.00 59.00           C  
ATOM    434  C   ALA    64      25.120  40.380  35.901  1.00 61.13           C  
ATOM    435  O   ALA    64      25.025  39.523  35.024  1.00 60.65           O  
ATOM    436  CB  ALA    64      26.618  39.321  37.568  1.00 57.86           C  
ATOM    437  N   ILE    65      24.122  41.196  36.221  1.00 63.34           N  
ATOM    438  CA  ILE    65      22.853  41.143  35.506  1.00 64.35           C  
ATOM    439  C   ILE    65      22.854  42.255  34.466  1.00 65.13           C  
ATOM    440  O   ILE    65      22.716  41.997  33.278  1.00 63.47           O  
ATOM    441  CB  ILE    65      21.633  41.375  36.431  1.00 64.03           C  
ATOM    442  CG1 ILE    65      21.603  40.354  37.561  1.00 61.72           C  
ATOM    443  CG2 ILE    65      20.343  41.247  35.626  1.00 64.35           C  
ATOM    444  CD1 ILE    65      20.632  40.736  38.678  1.00 58.41           C  
ATOM    445  N   ARG    66      23.034  43.498  34.908  1.00 65.61           N  
ATOM    446  CA  ARG    66      22.991  44.625  33.971  1.00 66.75           C  
ATOM    447  C   ARG    66      24.286  45.044  33.265  1.00 65.81           C  
ATOM    448  O   ARG    66      24.657  46.225  33.243  1.00 67.92           O  
ATOM    449  CB  ARG    66      22.348  45.832  34.650  1.00 67.01           C  
ATOM    450  CG  ARG    66      22.930  46.224  35.983  1.00 70.89           C  
ATOM    451  CD  ARG    66      22.388  47.577  36.376  1.00 79.03           C  
ATOM    452  NE  ARG    66      22.696  48.583  35.361  1.00 84.60           N  
ATOM    453  CZ  ARG    66      23.885  49.155  35.206  1.00 86.35           C  
ATOM    454  NH1 ARG    66      24.893  48.825  36.008  1.00 83.77           N  
ATOM    455  NH2 ARG    66      24.062  50.059  34.249  1.00 83.22           N  
ATOM    456  N   GLY    67      24.948  44.056  32.671  1.00 61.55           N  
ATOM    457  CA  GLY    67      26.180  44.278  31.929  1.00 63.66           C  
ATOM    458  C   GLY    67      25.815  43.701  30.583  1.00 65.46           C  
ATOM    459  O   GLY    67      26.284  44.135  29.526  1.00 66.44           O  
ATOM    460  N   ASP    68      24.954  42.686  30.653  1.00 33.74           N  
ATOM    461  CA  ASP    68      24.422  42.009  29.472  1.00 33.21           C  
ATOM    462  C   ASP    68      23.369  42.986  28.987  1.00 36.28           C  
ATOM    463  O   ASP    68      22.870  42.874  27.855  1.00 71.16           O  
ATOM    464  CB  ASP    68      23.781  40.681  29.867  1.00 30.38           C  
ATOM    465  CG  ASP    68      24.819  39.640  30.230  1.00 34.25           C  
ATOM    466  OD1 ASP    68      26.007  39.875  29.876  1.00 35.02           O  
ATOM    467  OD2 ASP    68      24.481  38.589  30.842  1.00 33.10           O  
ATOM    468  N   THR    69      23.038  43.948  29.865  1.00 35.66           N  
ATOM    469  CA  THR    69      22.075  44.989  29.518  1.00 34.35           C  
ATOM    470  C   THR    69      21.996  46.196  30.461  1.00 37.99           C  
ATOM    471  O   THR    69      21.239  46.188  31.440  1.00 71.48           O  
ATOM    472  CB  THR    69      20.667  44.439  29.417  1.00 32.31           C  
ATOM    473  OG1 THR    69      20.701  43.139  28.797  1.00 33.54           O  
ATOM    474  CG2 THR    69      19.833  45.393  28.545  1.00 35.19           C  
ATOM    475  N   PRO    70      22.791  47.243  30.187  1.00 71.09           N  
ATOM    476  CA  PRO    70      22.777  48.455  31.019  1.00 70.65           C  
ATOM    477  C   PRO    70      21.468  49.209  30.766  1.00 70.27           C  
ATOM    478  O   PRO    70      21.241  50.307  31.275  1.00 69.44           O  
ATOM    479  CB  PRO    70      24.015  49.227  30.537  1.00 71.09           C  
ATOM    480  CG  PRO    70      24.252  48.684  29.133  1.00 72.04           C  
ATOM    481  CD  PRO    70      23.974  47.218  29.308  1.00 71.20           C  
ATOM    482  N   GLU    71      20.607  48.581  29.972  1.00 71.09           N  
ATOM    483  CA  GLU    71      19.312  49.150  29.616  1.00 75.30           C  
ATOM    484  C   GLU    71      18.296  48.896  30.714  1.00 78.01           C  
ATOM    485  O   GLU    71      17.318  49.623  30.850  1.00 79.60           O  
ATOM    486  CB  GLU    71      18.815  48.533  28.315  1.00 75.45           C  
ATOM    487  N   VAL    72      18.552  47.858  31.502  1.00 80.19           N  
ATOM    488  CA  VAL    72      17.645  47.444  32.562  1.00 79.15           C  
ATOM    489  C   VAL    72      17.993  47.917  33.969  1.00 79.08           C  
ATOM    490  O   VAL    72      19.128  48.300  34.268  1.00 80.56           O  
ATOM    491  CB  VAL    72      17.540  45.919  32.569  1.00 78.95           C  
ATOM    492  CG1 VAL    72      18.800  45.316  33.164  1.00 78.97           C  
ATOM    493  CG2 VAL    72      16.306  45.478  33.315  1.00 79.92           C  
ATOM    494  N   GLY    73      16.994  47.891  34.840  1.00 77.79           N  
ATOM    495  CA  GLY    73      17.215  48.295  36.213  1.00 74.50           C  
ATOM    496  C   GLY    73      17.176  47.054  37.076  1.00 72.12           C  
ATOM    497  O   GLY    73      16.435  46.124  36.778  1.00 71.30           O  
ATOM    498  N   VAL    74      18.000  47.009  38.115  1.00 69.87           N  
ATOM    499  CA  VAL    74      17.980  45.867  39.021  1.00 67.33           C  
ATOM    500  C   VAL    74      17.924  46.378  40.446  1.00 65.07           C  
ATOM    501  O   VAL    74      18.701  47.252  40.840  1.00 64.68           O  
ATOM    502  CB  VAL    74      19.230  44.925  38.893  1.00 66.36           C  
ATOM    503  CG1 VAL    74      19.382  44.433  37.469  1.00 67.21           C  
ATOM    504  CG2 VAL    74      20.488  45.624  39.395  1.00 66.08           C  
ATOM    505  N   ALA    75      16.990  45.844  41.216  1.00 62.21           N  
ATOM    506  CA  ALA    75      16.860  46.233  42.612  1.00 59.82           C  
ATOM    507  C   ALA    75      17.039  44.956  43.415  1.00 57.48           C  
ATOM    508  O   ALA    75      16.521  43.898  43.035  1.00 55.79           O  
ATOM    509  CB  ALA    75      15.487  46.840  42.869  1.00 59.11           C  
ATOM    510  N   THR    76      17.802  45.046  44.501  1.00 57.35           N  
ATOM    511  CA  THR    76      18.046  43.886  45.356  1.00 54.95           C  
ATOM    512  C   THR    76      16.774  43.588  46.149  1.00 54.39           C  
ATOM    513  O   THR    76      16.188  44.504  46.720  1.00 55.28           O  
ATOM    514  CB  THR    76      19.146  44.179  46.376  1.00 54.73           C  
ATOM    515  OG1 THR    76      20.137  45.028  45.789  1.00 53.12           O  
ATOM    516  CG2 THR    76      19.791  42.875  46.837  1.00 48.76           C  
ATOM    517  N   ILE    77      16.351  42.339  46.161  1.00 54.78           N  
ATOM    518  CA  ILE    77      15.153  41.933  46.919  1.00 53.95           C  
ATOM    519  C   ILE    77      15.629  41.454  48.293  1.00 53.85           C  
ATOM    520  O   ILE    77      15.225  41.980  49.326  1.00 53.87           O  
ATOM    521  CB  ILE    77      14.389  40.777  46.214  1.00 53.06           C  
ATOM    522  CG1 ILE    77      13.793  41.277  44.891  1.00 49.37           C  
ATOM    523  CG2 ILE    77      13.299  40.243  47.112  1.00 51.41           C  
ATOM    524  CD1 ILE    77      13.302  40.153  43.972  1.00 50.91           C  
ATOM    525  N   ASP    78      16.508  40.458  48.278  1.00 55.39           N  
ATOM    526  CA  ASP    78      17.093  39.904  49.496  1.00 55.89           C  
ATOM    527  C   ASP    78      18.510  39.412  49.202  1.00 54.38           C  
ATOM    528  O   ASP    78      18.835  39.076  48.067  1.00 53.61           O  
ATOM    529  CB  ASP    78      16.253  38.747  50.015  1.00 54.72           C  
ATOM    530  CG  ASP    78      16.001  37.701  48.953  1.00 59.69           C  
ATOM    531  OD1 ASP    78      14.817  37.481  48.619  1.00 61.41           O  
ATOM    532  OD2 ASP    78      16.980  37.107  48.448  1.00 60.49           O  
ATOM    533  N   MET    79      19.342  39.374  50.239  1.00 55.52           N  
ATOM    534  CA  MET    79      20.716  38.921  50.105  1.00 55.94           C  
ATOM    535  C   MET    79      21.201  38.170  51.340  1.00 55.05           C  
ATOM    536  O   MET    79      20.918  38.560  52.478  1.00 54.67           O  
ATOM    537  CB  MET    79      21.634  40.112  49.844  1.00 57.77           C  
ATOM    538  CG  MET    79      23.104  39.746  49.644  1.00 61.43           C  
ATOM    539  SD  MET    79      24.188  41.319  49.288  1.00 69.63          SE  
ATOM    540  CE  MET    79      23.137  41.999  47.825  1.00 68.28           C  
ATOM    541  N   ASN    80      21.939  37.097  51.098  1.00 55.10           N  
ATOM    542  CA  ASN    80      22.491  36.243  52.142  1.00 53.44           C  
ATOM    543  C   ASN    80      24.026  36.260  52.038  1.00 52.11           C  
ATOM    544  O   ASN    80      24.590  36.005  50.981  1.00 50.58           O  
ATOM    545  CB  ASN    80      21.935  34.822  51.964  1.00 53.41           C  
ATOM    546  CG  ASN    80      22.277  33.905  53.126  1.00 54.82           C  
ATOM    547  OD1 ASN    80      23.412  33.444  53.253  1.00 56.64           O  
ATOM    548  ND2 ASN    80      21.297  33.642  53.982  1.00 54.68           N  
ATOM    549  N   THR    81      24.690  36.577  53.140  1.00 52.31           N  
ATOM    550  CA  THR    81      26.142  36.657  53.148  1.00 51.58           C  
ATOM    551  C   THR    81      26.772  35.788  54.236  1.00 50.18           C  
ATOM    552  O   THR    81      26.372  35.825  55.406  1.00 47.55           O  
ATOM    553  CB  THR    81      26.595  38.130  53.333  1.00 50.52           C  
ATOM    554  OG1 THR    81      25.786  38.979  52.513  1.00 53.11           O  
ATOM    555  CG2 THR    81      28.056  38.313  52.912  1.00 51.60           C  
ATOM    556  N   SER    82      27.756  34.999  53.822  1.00 49.70           N  
ATOM    557  CA  SER    82      28.486  34.119  54.715  1.00 48.38           C  
ATOM    558  C   SER    82      29.867  34.719  54.962  1.00 49.69           C  
ATOM    559  O   SER    82      30.508  35.220  54.032  1.00 49.83           O  
ATOM    560  CB  SER    82      28.605  32.733  54.090  1.00 47.04           C  
ATOM    561  OG  SER    82      27.380  32.035  54.219  1.00 47.27           O  
ATOM    562  N   PHE    83      30.305  34.683  56.217  1.00 48.39           N  
ATOM    563  CA  PHE    83      31.596  35.233  56.601  1.00 52.04           C  
ATOM    564  C   PHE    83      32.540  34.094  56.982  1.00 53.41           C  
ATOM    565  O   PHE    83      32.405  33.475  58.034  1.00 51.27           O  
ATOM    566  CB  PHE    83      31.401  36.230  57.751  1.00 52.31           C  
ATOM    567  CG  PHE    83      30.568  37.417  57.369  1.00 48.98           C  
ATOM    568  CD1 PHE    83      31.084  38.398  56.533  1.00 47.82           C  
ATOM    569  CD2 PHE    83      29.237  37.511  57.769  1.00 47.87           C  
ATOM    570  CE1 PHE    83      30.289  39.456  56.094  1.00 48.23           C  
ATOM    571  CE2 PHE    83      28.431  38.571  57.331  1.00 50.92           C  
ATOM    572  CZ  PHE    83      28.956  39.538  56.494  1.00 47.91           C  
ATOM    573  N   MET    84      33.502  33.828  56.103  1.00 56.89           N  
ATOM    574  CA  MET    84      34.440  32.731  56.301  1.00 59.89           C  
ATOM    575  C   MET    84      35.791  33.067  56.893  1.00 60.24           C  
ATOM    576  O   MET    84      36.319  32.314  57.712  1.00 60.94           O  
ATOM    577  CB  MET    84      34.684  32.014  54.981  1.00 60.79           C  
ATOM    578  CG  MET    84      33.579  31.076  54.553  1.00 67.59           C  
ATOM    579  SD  MET    84      32.327  31.852  53.306  1.00 82.87          SE  
ATOM    580  CE  MET    84      31.428  30.224  52.768  1.00 74.13           C  
ATOM    581  N   SER    85      36.350  34.189  56.463  1.00 62.74           N  
ATOM    582  CA  SER    85      37.663  34.601  56.904  1.00 65.29           C  
ATOM    583  C   SER    85      37.779  36.104  56.991  1.00 67.79           C  
ATOM    584  O   SER    85      37.254  36.828  56.149  1.00 68.96           O  
ATOM    585  CB  SER    85      38.706  34.086  55.915  1.00 65.16           C  
ATOM    586  OG  SER    85      38.545  32.696  55.708  1.00 67.38           O  
ATOM    587  N   PRO    86      38.474  36.593  58.021  1.00 68.91           N  
ATOM    588  CA  PRO    86      38.650  38.034  58.184  1.00 69.20           C  
ATOM    589  C   PRO    86      39.234  38.589  56.898  1.00 69.57           C  
ATOM    590  O   PRO    86      40.109  37.973  56.303  1.00 69.70           O  
ATOM    591  CB  PRO    86      39.628  38.129  59.352  1.00 70.10           C  
ATOM    592  CG  PRO    86      39.254  36.938  60.189  1.00 69.38           C  
ATOM    593  CD  PRO    86      39.057  35.851  59.154  1.00 68.26           C  
ATOM    594  N   GLY    87      38.742  39.745  56.469  1.00 71.21           N  
ATOM    595  CA  GLY    87      39.238  40.352  55.246  1.00 70.14           C  
ATOM    596  C   GLY    87      40.309  41.386  55.524  1.00 71.08           C  
ATOM    597  O   GLY    87      40.143  42.241  56.393  1.00 70.15           O  
ATOM    598  N   ARG    88      41.409  41.313  54.778  1.00 72.20           N  
ATOM    599  CA  ARG    88      42.517  42.243  54.947  1.00 71.33           C  
ATOM    600  C   ARG    88      43.218  42.528  53.626  1.00 71.05           C  
ATOM    601  O   ARG    88      43.272  41.670  52.749  1.00 71.84           O  
ATOM    602  CB  ARG    88      43.516  41.671  55.954  1.00 72.66           C  
ATOM    603  CG  ARG    88      42.998  41.644  57.382  1.00 72.27           C  
ATOM    604  CD  ARG    88      43.927  40.870  58.295  1.00 76.68           C  
ATOM    605  NE  ARG    88      43.204  39.848  59.050  1.00 79.59           N  
ATOM    606  CZ  ARG    88      43.741  39.114  60.017  1.00 79.58           C  
ATOM    607  NH1 ARG    88      45.013  39.287  60.351  1.00 82.63           N  
ATOM    608  NH2 ARG    88      43.008  38.207  60.651  1.00 78.13           N  
ATOM    609  N   GLY    89      43.758  43.735  53.488  1.00 70.69           N  
ATOM    610  CA  GLY    89      44.446  44.101  52.264  1.00 71.85           C  
ATOM    611  C   GLY    89      43.462  44.226  51.121  1.00 73.12           C  
ATOM    612  O   GLY    89      42.256  44.199  51.342  1.00 73.84           O  
ATOM    613  N   ASP    90      43.970  44.370  49.901  1.00 72.73           N  
ATOM    614  CA  ASP    90      43.117  44.490  48.723  1.00 72.06           C  
ATOM    615  C   ASP    90      42.302  43.219  48.534  1.00 70.71           C  
ATOM    616  O   ASP    90      42.810  42.110  48.713  1.00 71.10           O  
ATOM    617  CB  ASP    90      43.955  44.724  47.462  1.00 73.55           C  
ATOM    618  CG  ASP    90      44.353  46.179  47.277  1.00 74.11           C  
ATOM    619  OD1 ASP    90      44.944  46.770  48.208  1.00 73.77           O  
ATOM    620  OD2 ASP    90      44.085  46.727  46.188  1.00 75.54           O  
ATOM    621  N   LEU    91      41.039  43.384  48.161  1.00 68.33           N  
ATOM    622  CA  LEU    91      40.155  42.244  47.931  1.00 64.69           C  
ATOM    623  C   LEU    91      39.545  42.356  46.539  1.00 63.47           C  
ATOM    624  O   LEU    91      39.327  43.463  46.031  1.00 61.92           O  
ATOM    625  CB  LEU    91      39.041  42.216  48.972  1.00 63.68           C  
ATOM    626  CG  LEU    91      39.459  42.248  50.440  1.00 59.55           C  
ATOM    627  CD1 LEU    91      38.233  42.541  51.291  1.00 60.67           C  
ATOM    628  CD2 LEU    91      40.101  40.933  50.843  1.00 56.88           C  
ATOM    629  N   VAL    92      39.282  41.211  45.920  1.00 61.53           N  
ATOM    630  CA  VAL    92      38.691  41.204  44.593  1.00 60.01           C  
ATOM    631  C   VAL    92      37.337  40.527  44.720  1.00 57.88           C  
ATOM    632  O   VAL    92      37.203  39.510  45.393  1.00 55.94           O  
ATOM    633  CB  VAL    92      39.602  40.457  43.559  1.00 59.18           C  
ATOM    634  CG1 VAL    92      39.536  38.961  43.765  1.00 62.89           C  
ATOM    635  CG2 VAL    92      39.200  40.833  42.151  1.00 60.68           C  
ATOM    636  N   ILE    93      36.331  41.116  44.085  1.00 58.48           N  
ATOM    637  CA  ILE    93      34.974  40.592  44.144  1.00 57.13           C  
ATOM    638  C   ILE    93      34.493  40.141  42.774  1.00 55.90           C  
ATOM    639  O   ILE    93      34.531  40.904  41.809  1.00 56.68           O  
ATOM    640  CB  ILE    93      34.014  41.662  44.710  1.00 57.13           C  
ATOM    641  CG1 ILE    93      34.526  42.132  46.072  1.00 54.80           C  
ATOM    642  CG2 ILE    93      32.602  41.107  44.837  1.00 53.88           C  
ATOM    643  CD1 ILE    93      35.587  43.210  45.997  1.00 48.07           C  
ATOM    644  N   GLU    94      34.035  38.898  42.698  1.00 56.37           N  
ATOM    645  CA  GLU    94      33.559  38.346  41.436  1.00 56.42           C  
ATOM    646  C   GLU    94      32.210  37.645  41.589  1.00 55.31           C  
ATOM    647  O   GLU    94      32.034  36.791  42.451  1.00 54.64           O  
ATOM    648  CB  GLU    94      34.588  37.364  40.873  1.00 58.89           C  
ATOM    649  CG  GLU    94      35.954  37.969  40.620  1.00 62.05           C  
ATOM    650  CD  GLU    94      36.781  37.142  39.657  1.00 69.04           C  
ATOM    651  OE1 GLU    94      37.265  37.703  38.646  1.00 67.11           O  
ATOM    652  OE2 GLU    94      36.945  35.932  39.908  1.00 70.83           O  
ATOM    653  N   THR    95      31.272  38.000  40.720  1.00 55.95           N  
ATOM    654  CA  THR    95      29.928  37.445  40.761  1.00 55.64           C  
ATOM    655  C   THR    95      29.519  36.789  39.450  1.00 57.43           C  
ATOM    656  O   THR    95      30.160  36.987  38.421  1.00 59.47           O  
ATOM    657  CB  THR    95      28.905  38.544  41.078  1.00 55.35           C  
ATOM    658  OG1 THR    95      29.008  39.593  40.104  1.00 53.07           O  
ATOM    659  CG2 THR    95      29.155  39.118  42.467  1.00 51.92           C  
ATOM    660  N   ARG    96      28.447  36.006  39.500  1.00 58.84           N  
ATOM    661  CA  ARG    96      27.907  35.334  38.318  1.00 58.70           C  
ATOM    662  C   ARG    96      26.393  35.235  38.479  1.00 57.98           C  
ATOM    663  O   ARG    96      25.894  35.043  39.589  1.00 57.43           O  
ATOM    664  CB  ARG    96      28.516  33.928  38.154  1.00 60.02           C  
ATOM    665  CG  ARG    96      28.151  32.917  39.244  1.00 64.39           C  
ATOM    666  CD  ARG    96      29.294  31.922  39.471  1.00 73.23           C  
ATOM    667  NE  ARG    96      30.532  32.618  39.831  1.00 79.38           N  
ATOM    668  CZ  ARG    96      31.044  32.700  41.058  1.00 77.77           C  
ATOM    669  NH1 ARG    96      30.442  32.122  42.088  1.00 75.44           N  
ATOM    670  NH2 ARG    96      32.164  33.384  41.255  1.00 77.42           N  
ATOM    671  N   CYS    97      25.664  35.390  37.378  1.00 57.49           N  
ATOM    672  CA  CYS    97      24.211  35.306  37.416  1.00 55.67           C  
ATOM    673  C   CYS    97      23.878  33.840  37.260  1.00 55.73           C  
ATOM    674  O   CYS    97      24.382  33.193  36.350  1.00 58.61           O  
ATOM    675  CB  CYS    97      23.593  36.101  36.269  1.00 56.18           C  
ATOM    676  SG  CYS    97      21.779  36.147  36.286  1.00 57.01           S  
ATOM    677  N   LEU    98      23.040  33.313  38.146  1.00 54.26           N  
ATOM    678  CA  LEU    98      22.664  31.897  38.098  1.00 52.21           C  
ATOM    679  C   LEU    98      21.433  31.641  37.250  1.00 49.03           C  
ATOM    680  O   LEU    98      21.256  30.560  36.704  1.00 46.12           O  
ATOM    681  CB  LEU    98      22.395  31.381  39.504  1.00 54.15           C  
ATOM    682  CG  LEU    98      23.539  31.416  40.510  1.00 54.58           C  
ATOM    683  CD1 LEU    98      22.973  31.175  41.898  1.00 46.73           C  
ATOM    684  CD2 LEU    98      24.594  30.369  40.145  1.00 56.93           C  
ATOM    685  N   ARG    99      20.568  32.644  37.178  1.00 50.48           N  
ATOM    686  CA  ARG    99      19.344  32.557  36.404  1.00 52.49           C  
ATOM    687  C   ARG    99      18.757  33.938  36.190  1.00 52.82           C  
ATOM    688  O   ARG    99      18.828  34.807  37.056  1.00 53.75           O  
ATOM    689  CB  ARG    99      18.304  31.676  37.102  1.00 54.06           C  
ATOM    690  CG  ARG    99      16.945  31.789  36.431  1.00 57.29           C  
ATOM    691  CD  ARG    99      16.145  30.500  36.429  1.00 65.87           C  
ATOM    692  NE  ARG    99      15.023  30.617  35.497  1.00 70.54           N  
ATOM    693  CZ  ARG    99      14.103  31.574  35.559  1.00 67.79           C  
ATOM    694  NH1 ARG    99      14.164  32.496  36.511  1.00 71.10           N  
ATOM    695  NH2 ARG    99      13.132  31.624  34.661  1.00 70.62           N  
ATOM    696  N   ARG   100      18.160  34.132  35.030  1.00 56.24           N  
ATOM    697  CA  ARG   100      17.563  35.413  34.713  1.00 58.79           C  
ATOM    698  C   ARG   100      16.166  35.176  34.156  1.00 59.48           C  
ATOM    699  O   ARG   100      15.992  34.445  33.179  1.00 62.14           O  
ATOM    700  CB  ARG   100      18.432  36.142  33.687  1.00 59.79           C  
ATOM    701  CG  ARG   100      18.455  37.650  33.842  1.00 59.96           C  
ATOM    702  CD  ARG   100      19.412  38.262  32.846  1.00 63.35           C  
ATOM    703  NE  ARG   100      19.086  39.652  32.554  1.00 71.63           N  
ATOM    704  CZ  ARG   100      19.996  40.602  32.363  1.00 73.15           C  
ATOM    705  NH1 ARG   100      21.288  40.302  32.445  1.00 66.78           N  
ATOM    706  NH2 ARG   100      19.618  41.842  32.072  1.00 77.98           N  
ATOM    707  N   GLY   101      15.171  35.778  34.797  1.00 59.68           N  
ATOM    708  CA  GLY   101      13.807  35.625  34.342  1.00 60.36           C  
ATOM    709  C   GLY   101      13.387  36.942  33.748  1.00 59.99           C  
ATOM    710  O   GLY   101      14.216  37.825  33.555  1.00 59.70           O  
ATOM    711  N   ALA   102      12.107  37.086  33.444  1.00 61.31           N  
ATOM    712  CA  ALA   102      11.638  38.337  32.876  1.00 62.56           C  
ATOM    713  C   ALA   102      11.613  39.373  33.981  1.00 63.18           C  
ATOM    714  O   ALA   102      11.869  40.556  33.752  1.00 65.06           O  
ATOM    715  CB  ALA   102      10.259  38.155  32.296  1.00 62.57           C  
ATOM    716  N   SER   103      11.327  38.907  35.191  1.00 63.17           N  
ATOM    717  CA  SER   103      11.222  39.792  36.345  1.00 63.30           C  
ATOM    718  C   SER   103      12.206  39.558  37.492  1.00 60.88           C  
ATOM    719  O   SER   103      12.620  40.507  38.152  1.00 59.41           O  
ATOM    720  CB  SER   103       9.791  39.713  36.886  1.00 65.59           C  
ATOM    721  OG  SER   103       9.628  40.516  38.041  1.00 72.67           O  
ATOM    722  N   ILE   104      12.576  38.294  37.712  1.00 60.81           N  
ATOM    723  CA  ILE   104      13.469  37.891  38.813  1.00 58.72           C  
ATOM    724  C   ILE   104      14.853  37.356  38.406  1.00 59.10           C  
ATOM    725  O   ILE   104      14.965  36.490  37.540  1.00 56.77           O  
ATOM    726  CB  ILE   104      12.793  36.791  39.674  1.00 58.71           C  
ATOM    727  CG1 ILE   104      11.414  37.255  40.143  1.00 54.91           C  
ATOM    728  CG2 ILE   104      13.657  36.457  40.872  1.00 56.87           C  
ATOM    729  CD1 ILE   104      11.455  38.329  41.208  1.00 53.11           C  
ATOM    730  N   ALA   105      15.897  37.851  39.069  1.00 57.55           N  
ATOM    731  CA  ALA   105      17.265  37.408  38.791  1.00 55.87           C  
ATOM    732  C   ALA   105      17.959  36.863  40.039  1.00 53.73           C  
ATOM    733  O   ALA   105      17.839  37.433  41.119  1.00 52.30           O  
ATOM    734  CB  ALA   105      18.079  38.563  38.209  1.00 55.98           C  
ATOM    735  N   PHE   106      18.697  35.765  39.878  1.00 54.37           N  
ATOM    736  CA  PHE   106      19.435  35.138  40.984  1.00 54.66           C  
ATOM    737  C   PHE   106      20.934  35.283  40.757  1.00 56.10           C  
ATOM    738  O   PHE   106      21.431  35.012  39.668  1.00 58.87           O  
ATOM    739  CB  PHE   106      19.118  33.647  41.074  1.00 51.44           C  
ATOM    740  CG  PHE   106      17.710  33.342  41.483  1.00 50.85           C  
ATOM    741  CD1 PHE   106      17.320  33.428  42.822  1.00 44.53           C  
ATOM    742  CD2 PHE   106      16.763  32.968  40.527  1.00 46.72           C  
ATOM    743  CE1 PHE   106      16.002  33.144  43.214  1.00 39.63           C  
ATOM    744  CE2 PHE   106      15.439  32.684  40.904  1.00 47.44           C  
ATOM    745  CZ  PHE   106      15.059  32.773  42.253  1.00 49.21           C  
ATOM    746  N   CYS   107      21.658  35.694  41.788  1.00 59.42           N  
ATOM    747  CA  CYS   107      23.103  35.859  41.666  1.00 60.48           C  
ATOM    748  C   CYS   107      23.868  35.361  42.879  1.00 58.89           C  
ATOM    749  O   CYS   107      23.320  35.228  43.968  1.00 58.15           O  
ATOM    750  CB  CYS   107      23.451  37.333  41.430  1.00 59.77           C  
ATOM    751  SG  CYS   107      22.814  38.008  39.875  1.00 68.43           S  
ATOM    752  N   GLU   108      25.142  35.060  42.670  1.00 58.74           N  
ATOM    753  CA  GLU   108      26.014  34.615  43.746  1.00 57.79           C  
ATOM    754  C   GLU   108      27.394  35.209  43.505  1.00 56.15           C  
ATOM    755  O   GLU   108      27.675  35.741  42.435  1.00 56.27           O  
ATOM    756  CB  GLU   108      26.088  33.090  43.809  1.00 56.81           C  
ATOM    757  CG  GLU   108      26.431  32.413  42.505  1.00 59.58           C  
ATOM    758  CD  GLU   108      27.160  31.110  42.723  1.00 56.82           C  
ATOM    759  OE1 GLU   108      26.776  30.354  43.640  1.00 62.65           O  
ATOM    760  OE2 GLU   108      28.122  30.847  41.975  1.00 63.95           O  
ATOM    761  N   GLY   109      28.252  35.143  44.510  1.00 55.69           N  
ATOM    762  CA  GLY   109      29.573  35.711  44.349  1.00 56.85           C  
ATOM    763  C   GLY   109      30.464  35.456  45.541  1.00 56.87           C  
ATOM    764  O   GLY   109      30.046  34.847  46.526  1.00 54.75           O  
ATOM    765  N   GLU   110      31.693  35.955  45.459  1.00 57.17           N  
ATOM    766  CA  GLU   110      32.664  35.744  46.520  1.00 58.54           C  
ATOM    767  C   GLU   110      33.738  36.825  46.563  1.00 56.41           C  
ATOM    768  O   GLU   110      34.023  37.483  45.560  1.00 57.20           O  
ATOM    769  CB  GLU   110      33.321  34.376  46.325  1.00 58.69           C  
ATOM    770  CG  GLU   110      33.367  33.958  44.854  1.00 67.99           C  
ATOM    771  CD  GLU   110      34.447  32.940  44.547  1.00 76.41           C  
ATOM    772  OE1 GLU   110      34.343  31.793  45.033  1.00 83.23           O  
ATOM    773  OE2 GLU   110      35.399  33.295  43.814  1.00 76.64           O  
ATOM    774  N   ILE   111      34.327  36.997  47.741  1.00 55.20           N  
ATOM    775  CA  ILE   111      35.387  37.964  47.944  1.00 53.99           C  
ATOM    776  C   ILE   111      36.631  37.171  48.334  1.00 53.91           C  
ATOM    777  O   ILE   111      36.563  36.255  49.158  1.00 52.14           O  
ATOM    778  CB  ILE   111      35.039  38.952  49.079  1.00 55.99           C  
ATOM    779  CG1 ILE   111      33.687  39.618  48.794  1.00 50.38           C  
ATOM    780  CG2 ILE   111      36.146  40.007  49.213  1.00 52.86           C  
ATOM    781  CD1 ILE   111      33.182  40.488  49.915  1.00 44.32           C  
ATOM    782  N   ARG   112      37.767  37.512  47.740  1.00 54.95           N  
ATOM    783  CA  ARG   112      39.004  36.802  48.049  1.00 57.36           C  
ATOM    784  C   ARG   112      40.111  37.804  48.309  1.00 58.33           C  
ATOM    785  O   ARG   112      40.093  38.914  47.770  1.00 58.61           O  
ATOM    786  CB  ARG   112      39.401  35.876  46.890  1.00 55.02           C  
ATOM    787  CG  ARG   112      38.240  35.058  46.326  1.00 58.53           C  
ATOM    788  CD  ARG   112      38.714  33.889  45.468  1.00 59.84           C  
ATOM    789  NE  ARG   112      38.967  32.697  46.276  1.00 55.17           N  
ATOM    790  CZ  ARG   112      38.262  31.576  46.185  1.00 56.50           C  
ATOM    791  NH1 ARG   112      37.268  31.499  45.312  1.00 57.16           N  
ATOM    792  NH2 ARG   112      38.530  30.546  46.983  1.00 53.22           N  
ATOM    793  N   ASP   113      41.065  37.418  49.149  1.00 59.75           N  
ATOM    794  CA  ASP   113      42.187  38.293  49.460  1.00 61.42           C  
ATOM    795  C   ASP   113      43.326  38.045  48.482  1.00 61.61           C  
ATOM    796  O   ASP   113      43.249  37.151  47.643  1.00 61.62           O  
ATOM    797  CB  ASP   113      42.678  38.072  50.899  1.00 63.46           C  
ATOM    798  CG  ASP   113      42.922  36.614  51.225  1.00 62.82           C  
ATOM    799  OD1 ASP   113      43.513  35.895  50.390  1.00 71.52           O  
ATOM    800  OD2 ASP   113      42.531  36.189  52.327  1.00 61.21           O  
ATOM    801  N   SER   114      44.375  38.852  48.590  1.00 63.28           N  
ATOM    802  CA  SER   114      45.539  38.730  47.722  1.00 64.00           C  
ATOM    803  C   SER   114      46.053  37.295  47.693  1.00 65.13           C  
ATOM    804  O   SER   114      46.604  36.850  46.693  1.00 66.04           O  
ATOM    805  CB  SER   114      46.643  39.679  48.204  1.00 65.13           C  
ATOM    806  OG  SER   114      46.817  39.600  49.612  1.00 60.56           O  
ATOM    807  N   ALA   115      45.849  36.572  48.792  1.00 66.03           N  
ATOM    808  CA  ALA   115      46.287  35.183  48.918  1.00 65.08           C  
ATOM    809  C   ALA   115      45.301  34.190  48.297  1.00 65.99           C  
ATOM    810  O   ALA   115      45.504  32.977  48.367  1.00 66.38           O  
ATOM    811  CB  ALA   115      46.511  34.846  50.396  1.00 65.09           C  
ATOM    812  N   GLY   116      44.227  34.714  47.707  1.00 66.72           N  
ATOM    813  CA  GLY   116      43.228  33.874  47.061  1.00 64.83           C  
ATOM    814  C   GLY   116      42.303  33.078  47.968  1.00 64.48           C  
ATOM    815  O   GLY   116      41.588  32.188  47.501  1.00 63.85           O  
ATOM    816  N   GLU   117      42.304  33.389  49.259  1.00 63.88           N  
ATOM    817  CA  GLU   117      41.458  32.672  50.204  1.00 64.34           C  
ATOM    818  C   GLU   117      40.067  33.306  50.290  1.00 62.51           C  
ATOM    819  O   GLU   117      39.922  34.529  50.216  1.00 62.86           O  
ATOM    820  CB  GLU   117      42.115  32.656  51.587  1.00 65.37           C  
ATOM    821  CG  GLU   117      42.256  31.277  52.213  1.00 66.65           C  
ATOM    822  CD  GLU   117      43.127  30.333  51.389  1.00 73.09           C  
ATOM    823  OE1 GLU   117      44.185  30.772  50.883  1.00 72.72           O  
ATOM    824  OE2 GLU   117      42.761  29.144  51.258  1.00 73.02           O  
ATOM    825  N   LEU   118      39.053  32.461  50.444  1.00 59.68           N  
ATOM    826  CA  LEU   118      37.671  32.909  50.529  1.00 59.25           C  
ATOM    827  C   LEU   118      37.402  33.732  51.794  1.00 58.30           C  
ATOM    828  O   LEU   118      37.537  33.241  52.920  1.00 54.60           O  
ATOM    829  CB  LEU   118      36.729  31.695  50.472  1.00 60.95           C  
ATOM    830  CG  LEU   118      35.239  31.901  50.169  1.00 59.70           C  
ATOM    831  CD1 LEU   118      35.060  32.717  48.881  1.00 53.79           C  
ATOM    832  CD2 LEU   118      34.574  30.539  50.026  1.00 56.32           C  
ATOM    833  N   VAL   119      37.034  34.994  51.588  1.00 57.09           N  
ATOM    834  CA  VAL   119      36.725  35.905  52.679  1.00 56.54           C  
ATOM    835  C   VAL   119      35.238  35.783  53.006  1.00 54.43           C  
ATOM    836  O   VAL   119      34.868  35.530  54.149  1.00 55.22           O  
ATOM    837  CB  VAL   119      37.065  37.375  52.296  1.00 56.87           C  
ATOM    838  CG1 VAL   119      36.539  38.330  53.353  1.00 56.66           C  
ATOM    839  CG2 VAL   119      38.580  37.534  52.157  1.00 57.01           C  
ATOM    840  N   ALA   120      34.393  35.949  51.996  1.00 53.42           N  
ATOM    841  CA  ALA   120      32.947  35.838  52.174  1.00 54.17           C  
ATOM    842  C   ALA   120      32.283  35.429  50.873  1.00 52.69           C  
ATOM    843  O   ALA   120      32.813  35.685  49.804  1.00 54.05           O  
ATOM    844  CB  ALA   120      32.370  37.164  52.656  1.00 51.04           C  
ATOM    845  N   LYS   121      31.128  34.785  50.974  1.00 53.82           N  
ATOM    846  CA  LYS   121      30.365  34.361  49.807  1.00 53.64           C  
ATOM    847  C   LYS   121      28.933  34.842  50.040  1.00 53.35           C  
ATOM    848  O   LYS   121      28.452  34.835  51.174  1.00 51.67           O  
ATOM    849  CB  LYS   121      30.399  32.838  49.663  1.00 53.76           C  
ATOM    850  CG  LYS   121      30.210  32.357  48.236  1.00 60.50           C  
ATOM    851  CD  LYS   121      30.881  31.005  48.023  1.00 69.99           C  
ATOM    852  CE  LYS   121      30.995  30.643  46.543  1.00 72.37           C  
ATOM    853  NZ  LYS   121      29.668  30.515  45.889  1.00 75.53           N  
ATOM    854  N   ALA   122      28.257  35.258  48.969  1.00 52.17           N  
ATOM    855  CA  ALA   122      26.894  35.764  49.095  1.00 50.01           C  
ATOM    856  C   ALA   122      25.981  35.395  47.937  1.00 47.99           C  
ATOM    857  O   ALA   122      26.429  35.170  46.821  1.00 47.40           O  
ATOM    858  CB  ALA   122      26.921  37.286  49.260  1.00 47.87           C  
ATOM    859  N   THR   123      24.690  35.305  48.219  1.00 48.48           N  
ATOM    860  CA  THR   123      23.720  35.027  47.175  1.00 50.18           C  
ATOM    861  C   THR   123      22.708  36.170  47.283  1.00 50.64           C  
ATOM    862  O   THR   123      22.557  36.775  48.351  1.00 49.94           O  
ATOM    863  CB  THR   123      23.031  33.656  47.369  1.00 48.58           C  
ATOM    864  OG1 THR   123      22.423  33.601  48.666  1.00 52.63           O  
ATOM    865  CG2 THR   123      24.043  32.516  47.217  1.00 48.88           C  
ATOM    866  N   ALA   124      22.047  36.491  46.176  1.00 50.30           N  
ATOM    867  CA  ALA   124      21.073  37.577  46.166  1.00 49.15           C  
ATOM    868  C   ALA   124      19.970  37.360  45.144  1.00 50.23           C  
ATOM    869  O   ALA   124      20.143  36.646  44.150  1.00 48.07           O  
ATOM    870  CB  ALA   124      21.767  38.900  45.896  1.00 49.07           C  
ATOM    871  N   THR   125      18.823  37.969  45.410  1.00 49.61           N  
ATOM    872  CA  THR   125      17.695  37.868  44.509  1.00 49.31           C  
ATOM    873  C   THR   125      17.456  39.292  44.042  1.00 47.89           C  
ATOM    874  O   THR   125      17.596  40.240  44.816  1.00 47.69           O  
ATOM    875  CB  THR   125      16.435  37.301  45.215  1.00 48.47           C  
ATOM    876  OG1 THR   125      16.746  36.048  45.841  1.00 46.66           O  
ATOM    877  CG2 THR   125      15.350  37.055  44.207  1.00 49.82           C  
ATOM    878  N   PHE   126      17.099  39.452  42.777  1.00 47.83           N  
ATOM    879  CA  PHE   126      16.909  40.798  42.258  1.00 49.42           C  
ATOM    880  C   PHE   126      15.630  41.041  41.484  1.00 49.91           C  
ATOM    881  O   PHE   126      15.075  40.134  40.859  1.00 48.27           O  
ATOM    882  CB  PHE   126      18.075  41.197  41.342  1.00 47.90           C  
ATOM    883  CG  PHE   126      19.377  41.440  42.062  1.00 46.56           C  
ATOM    884  CD1 PHE   126      20.242  40.387  42.367  1.00 46.64           C  
ATOM    885  CD2 PHE   126      19.758  42.734  42.399  1.00 40.34           C  
ATOM    886  CE1 PHE   126      21.478  40.634  42.997  1.00 45.60           C  
ATOM    887  CE2 PHE   126      20.988  42.991  43.028  1.00 42.33           C  
ATOM    888  CZ  PHE   126      21.849  41.935  43.324  1.00 39.69           C  
ATOM    889  N   LYS   127      15.173  42.290  41.522  1.00 53.22           N  
ATOM    890  CA  LYS   127      14.003  42.701  40.755  1.00 57.90           C  
ATOM    891  C   LYS   127      14.625  43.362  39.520  1.00 59.78           C  
ATOM    892  O   LYS   127      15.464  44.259  39.659  1.00 58.23           O  
ATOM    893  CB  LYS   127      13.184  43.727  41.536  1.00 56.86           C  
ATOM    894  N   ILE   128      14.283  42.901  38.321  1.00 63.95           N  
ATOM    895  CA  ILE   128      14.820  43.588  37.157  1.00 68.16           C  
ATOM    896  C   ILE   128      13.707  44.524  36.743  1.00 71.94           C  
ATOM    897  O   ILE   128      12.611  44.095  36.375  1.00 71.60           O  
ATOM    898  CB  ILE   128      15.243  42.644  35.982  1.00 67.37           C  
ATOM    899  CG1 ILE   128      14.467  41.327  36.011  1.00 63.20           C  
ATOM    900  CG2 ILE   128      16.746  42.394  36.053  1.00 68.21           C  
ATOM    901  CD1 ILE   128      15.170  40.208  35.236  1.00 60.33           C  
ATOM    902  N   ILE   129      14.000  45.816  36.858  1.00 75.65           N  
ATOM    903  CA  ILE   129      13.054  46.886  36.560  1.00 79.11           C  
ATOM    904  C   ILE   129      12.728  47.158  35.092  1.00 82.21           C  
ATOM    905  O   ILE   129      13.085  48.203  34.556  1.00 82.94           O  
ATOM    906  CB  ILE   129      13.512  48.223  37.209  1.00 79.07           C  
ATOM    907  CG1 ILE   129      13.778  48.023  38.711  1.00 78.47           C  
ATOM    908  CG2 ILE   129      12.450  49.294  37.007  1.00 79.06           C  
ATOM    909  CD1 ILE   129      12.657  47.332  39.458  1.00 77.73           C  
ATOM    910  N   GLN   130      12.055  46.203  34.453  1.00 85.92           N  
ATOM    911  CA  GLN   130      11.596  46.349  33.074  1.00 88.00           C  
ATOM    912  C   GLN   130      10.817  45.148  32.564  1.00 88.85           C  
ATOM    913  O   GLN   130       9.657  45.373  32.160  1.00 89.20           O  
ATOM    914  CB  GLN   130      12.742  46.702  32.114  1.00 87.61           C  
ATOM    915  CG  GLN   130      12.373  47.924  31.257  1.00 87.70           C  
ATOM    916  CD  GLN   130      11.656  49.016  32.066  1.00 85.68           C  
ATOM    917  OE1 GLN   130      10.611  48.772  32.678  1.00 80.72           O  
ATOM    918  NE2 GLN   130      12.217  50.224  32.065  1.00 84.66           N  
END
