
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   60 (  437),  selected   60 , name 2pk7_B
# Molecule2: number of CA atoms   29 (  432),  selected   29 , name T0480.pdb
# PARAMETERS: 2pk7_B.T0480.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T     3_B      -       -           -
LGA    K     4_B      -       -           -
LGA    L     5_B      -       -           -
LGA    L     6_B      -       -           -
LGA    D     7_B      -       -           -
LGA    I     8_B      -       -           -
LGA    L     9_B      -       -           -
LGA    A    10_B      F      20          1.939
LGA    C    11_B      C      21          0.762
LGA    P    12_B      P      22          1.176
LGA    I    13_B      R      23          3.180
LGA    C    14_B      C      24          2.016
LGA    K    15_B      G      25          1.775
LGA    -       -      P      26           -
LGA    -       -      G      27           -
LGA    G    16_B      V      28          1.758
LGA    P    17_B      F      29          1.067
LGA    L    18_B      L      30          1.724
LGA    K    19_B      A      31          1.683
LGA    L    20_B      E      32          2.295
LGA    S    21_B      H      33          2.919
LGA    A    22_B      -       -           -
LGA    D    23_B      -       -           -
LGA    K    24_B      A      34          2.046
LGA    T    25_B      D      35          1.700
LGA    E    26_B      R      36          0.977
LGA    L    27_B      Y      37          1.364
LGA    I    28_B      S      38          1.405
LGA    S    29_B      C      39          1.202
LGA    K    30_B      G      40          1.023
LGA    G    31_B      R      41          2.161
LGA    A    32_B      C      42          1.728
LGA    G    33_B      G      43          0.988
LGA    L    34_B      Y      44          1.665
LGA    A    35_B      T      45          1.139
LGA    Y    36_B      E      46          1.461
LGA    P    37_B      F      47          1.516
LGA    I    38_B      K      48          1.341
LGA    R    39_B      -       -           -
LGA    D    40_B      -       -           -
LGA    G    41_B      -       -           -
LGA    I    42_B      -       -           -
LGA    P    43_B      -       -           -
LGA    V    44_B      -       -           -
LGA    X    45_B      -       -           -
LGA    L    46_B      -       -           -
LGA    E    47_B      -       -           -
LGA    S    48_B      -       -           -
LGA    E    49_B      -       -           -
LGA    A    50_B      -       -           -
LGA    R    51_B      -       -           -
LGA    T    52_B      -       -           -
LGA    L    53_B      -       -           -
LGA    T    54_B      -       -           -
LGA    T    55_B      -       -           -
LGA    E    56_B      -       -           -
LGA    E    57_B      -       -           -
LGA    R    58_B      -       -           -
LGA    L    59_B      -       -           -
LGA    D    60_B      -       -           -
LGA    K    61_B      -       -           -
LGA    L    62_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   60   29    5.0     27    1.72    18.52     84.997     1.481

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.205750 * X  +  -0.520521 * Y  +  -0.828689 * Z  +  -6.035172
  Y_new =   0.837034 * X  +  -0.345103 * Y  +   0.424591 * Z  +  38.168770
  Z_new =  -0.506991 * X  +  -0.781001 * Y  +   0.364688 * Z  +  -6.671074 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.133936    2.007656  [ DEG:   -64.9698    115.0302 ]
  Theta =   0.531691    2.609902  [ DEG:    30.4636    149.5364 ]
  Phi   =   1.329766   -1.811826  [ DEG:    76.1900   -103.8100 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2pk7_B                                        
REMARK     2: T0480.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2pk7_B.T0480.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   60   29   5.0   27   1.72   18.52  84.997
REMARK  ---------------------------------------------------------- 
MOLECULE 2pk7_B
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   17-APR-07   2PK7              
TITLE     CRYSTAL STRUCTURE OF THE Q4KFT4_PSEF5 PROTEIN FROM                    
TITLE    2 PSEUDOMONAS FLUORESCENS. NESG TARGET PLR1                            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UNCHARACTERIZED PROTEIN;                                   
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PSEUDOMONAS FLUORESCENS;                        
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: PF-5;                                                        
SOURCE   5 ATCC: BAA-477;                                                       
SOURCE   6 GENE: PFL_1779;                                                      
SOURCE   7 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   8 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   9 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)+MAGIC;                           
SOURCE  10 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  11 EXPRESSION_SYSTEM_PLASMID: PET21                                     
KEYWDS    NESG, PLR1, PUTATIVE TETRAACYLDISACCHARIDE-1-P 4-KINASE,              
KEYWDS   2 Q4KFT4, STRUCTURAL GENOMICS, PSI-2, PROTEIN STRUCTURE                
KEYWDS   3 INITIATIVE, NORTHEAST STRUCTURAL GENOMICS CONSORTIUM                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.M.VOROBIEV,H.NEELY,S.JAYARAMAN,C.X.CHEN,H.JANJUA,R.XIAO,            
AUTHOR   2 T.ACTON,G.T.MONTELIONE,J.F.HUNT,L.TONG,NORTHEAST STRUCTURAL          
AUTHOR   3 GENOMICS CONSORTIUM (NESG)                                           
REVDAT   1   01-MAY-07 2PK7    0                                                
JRNL        AUTH   S.M.VOROBIEV,H.NEELY,S.JAYARAMAN,C.X.CHEN,H.JANJUA,          
JRNL        AUTH 2 R.XIAO,T.ACTON,G.T.MONTELIONE,J.F.HUNT,L.TONG                
JRNL        TITL   CRYSTAL STRUCTURE OF THE Q4KFT4_PSEF5 PROTEIN FROM           
JRNL        TITL 2 PSEUDOMONAS FLUORESCENS.                                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.20 ANGSTROMS.                                          
DBREF  2PK7 A    1    61  UNP    Q4KFT4   Q4KFT4_PSEF5     1     61             
DBREF  2PK7 B    1    61  UNP    Q4KFT4   Q4KFT4_PSEF5     1     61             
SEQRES   1 A   69  MSE ASP THR LYS LEU LEU ASP ILE LEU ALA CYS PRO ILE          
SEQRES   2 A   69  CYS LYS GLY PRO LEU LYS LEU SER ALA ASP LYS THR GLU          
SEQRES   3 A   69  LEU ILE SER LYS GLY ALA GLY LEU ALA TYR PRO ILE ARG          
SEQRES   4 A   69  ASP GLY ILE PRO VAL MSE LEU GLU SER GLU ALA ARG THR          
SEQRES   5 A   69  LEU THR THR GLU GLU ARG LEU ASP LYS LEU GLU HIS HIS          
SEQRES   6 A   69  HIS HIS HIS HIS                                              
SEQRES   1 B   69  MSE ASP THR LYS LEU LEU ASP ILE LEU ALA CYS PRO ILE          
SEQRES   2 B   69  CYS LYS GLY PRO LEU LYS LEU SER ALA ASP LYS THR GLU          
SEQRES   3 B   69  LEU ILE SER LYS GLY ALA GLY LEU ALA TYR PRO ILE ARG          
SEQRES   4 B   69  ASP GLY ILE PRO VAL MSE LEU GLU SER GLU ALA ARG THR          
SEQRES   5 B   69  LEU THR THR GLU GLU ARG LEU ASP LYS LEU GLU HIS HIS          
SEQRES   6 B   69  HIS HIS HIS HIS                                              
HET    MSE  A  45       8                                                       
HET    MSE  B  45       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    2(C5 H11 N O2 SE)                                            
FORMUL   3  HOH   *68(H2 O)                                                     
CRYST1   29.415   34.363   35.832  76.39  76.12  73.58 P 1           2          
ATOM    468  N   THR B   3       2.331  53.717 -10.431  1.00 30.48           N  
ATOM    469  CA  THR B   3       1.051  53.225  -9.838  1.00 28.37           C  
ATOM    470  C   THR B   3       1.281  51.887  -9.147  1.00 34.18           C  
ATOM    471  O   THR B   3       1.821  50.960  -9.749  1.00 32.52           O  
ATOM    472  CB  THR B   3      -0.003  53.078 -10.932  1.00 32.84           C  
ATOM    473  N   LYS B   4       0.884  51.787  -7.881  1.00 31.84           N  
ATOM    474  CA  LYS B   4       1.056  50.540  -7.143  1.00 32.70           C  
ATOM    475  C   LYS B   4      -0.299  49.919  -6.820  1.00 29.79           C  
ATOM    476  O   LYS B   4      -1.312  50.617  -6.726  1.00 26.39           O  
ATOM    477  CB  LYS B   4       1.869  50.781  -5.868  1.00 36.71           C  
ATOM    478  CG  LYS B   4       1.732  52.178  -5.278  1.00 44.26           C  
ATOM    479  CD  LYS B   4       2.600  52.344  -4.041  1.00 48.79           C  
ATOM    480  CE  LYS B   4       2.218  53.599  -3.265  1.00 60.56           C  
ATOM    481  NZ  LYS B   4       3.223  54.692  -3.371  1.00 55.23           N  
ATOM    482  N   LEU B   5      -0.326  48.603  -6.655  1.00 25.97           N  
ATOM    483  CA  LEU B   5      -1.586  47.937  -6.382  1.00 24.80           C  
ATOM    484  C   LEU B   5      -2.385  48.570  -5.246  1.00 29.18           C  
ATOM    485  O   LEU B   5      -3.561  48.895  -5.421  1.00 27.89           O  
ATOM    486  CB  LEU B   5      -1.356  46.454  -6.088  1.00 23.30           C  
ATOM    487  CG  LEU B   5      -2.669  45.669  -5.962  1.00 17.62           C  
ATOM    488  CD1 LEU B   5      -3.520  45.885  -7.194  1.00 15.60           C  
ATOM    489  CD2 LEU B   5      -2.366  44.193  -5.785  1.00 20.48           C  
ATOM    490  N   LEU B   6      -1.748  48.762  -4.093  1.00 28.45           N  
ATOM    491  CA  LEU B   6      -2.431  49.343  -2.941  1.00 33.56           C  
ATOM    492  C   LEU B   6      -3.197  50.638  -3.230  1.00 35.13           C  
ATOM    493  O   LEU B   6      -4.119  50.980  -2.492  1.00 42.85           O  
ATOM    494  CB  LEU B   6      -1.441  49.582  -1.788  1.00 34.67           C  
ATOM    495  CG  LEU B   6      -1.570  48.667  -0.562  1.00 35.72           C  
ATOM    496  CD1 LEU B   6      -0.845  49.286   0.633  1.00 40.20           C  
ATOM    497  CD2 LEU B   6      -3.044  48.484  -0.220  1.00 40.98           C  
ATOM    498  N   ASP B   7      -2.828  51.346  -4.299  1.00 38.62           N  
ATOM    499  CA  ASP B   7      -3.494  52.605  -4.663  1.00 36.24           C  
ATOM    500  C   ASP B   7      -4.808  52.455  -5.423  1.00 35.14           C  
ATOM    501  O   ASP B   7      -5.597  53.394  -5.490  1.00 40.51           O  
ATOM    502  CB  ASP B   7      -2.584  53.503  -5.516  1.00 40.85           C  
ATOM    503  CG  ASP B   7      -1.323  53.921  -4.798  1.00 46.29           C  
ATOM    504  OD1 ASP B   7      -1.326  53.988  -3.549  1.00 44.02           O  
ATOM    505  OD2 ASP B   7      -0.327  54.202  -5.495  1.00 50.55           O  
ATOM    506  N   ILE B   8      -5.049  51.298  -6.019  1.00 31.53           N  
ATOM    507  CA  ILE B   8      -6.293  51.142  -6.761  1.00 27.85           C  
ATOM    508  C   ILE B   8      -7.294  50.223  -6.087  1.00 23.77           C  
ATOM    509  O   ILE B   8      -8.475  50.226  -6.430  1.00 31.73           O  
ATOM    510  CB  ILE B   8      -6.033  50.674  -8.185  1.00 24.81           C  
ATOM    511  CG1 ILE B   8      -5.257  49.360  -8.176  1.00 25.93           C  
ATOM    512  CG2 ILE B   8      -5.269  51.752  -8.942  1.00 35.73           C  
ATOM    513  CD1 ILE B   8      -4.935  48.869  -9.559  1.00 25.67           C  
ATOM    514  N   LEU B   9      -6.829  49.428  -5.132  1.00 18.59           N  
ATOM    515  CA  LEU B   9      -7.752  48.568  -4.412  1.00 24.45           C  
ATOM    516  C   LEU B   9      -8.495  49.527  -3.479  1.00 26.42           C  
ATOM    517  O   LEU B   9      -8.007  50.620  -3.184  1.00 21.77           O  
ATOM    518  CB  LEU B   9      -7.002  47.498  -3.607  1.00 20.61           C  
ATOM    519  CG  LEU B   9      -6.138  46.535  -4.440  1.00 24.69           C  
ATOM    520  CD1 LEU B   9      -5.671  45.371  -3.581  1.00 26.91           C  
ATOM    521  CD2 LEU B   9      -6.947  46.011  -5.611  1.00 15.53           C  
ATOM    522  N   ALA B  10      -9.686  49.141  -3.049  1.00 22.84           N  
ATOM    523  CA  ALA B  10     -10.468  49.981  -2.157  1.00 24.78           C  
ATOM    524  C   ALA B  10     -11.288  49.062  -1.282  1.00 30.87           C  
ATOM    525  O   ALA B  10     -11.474  47.887  -1.609  1.00 28.59           O  
ATOM    526  CB  ALA B  10     -11.385  50.909  -2.963  1.00 22.89           C  
ATOM    527  N   CYS B  11     -11.781  49.597  -0.172  1.00 27.76           N  
ATOM    528  CA  CYS B  11     -12.578  48.811   0.750  1.00 26.52           C  
ATOM    529  C   CYS B  11     -13.894  48.378   0.118  1.00 27.11           C  
ATOM    530  O   CYS B  11     -14.602  49.189  -0.474  1.00 34.57           O  
ATOM    531  CB  CYS B  11     -12.870  49.617   2.015  1.00 25.82           C  
ATOM    532  SG  CYS B  11     -13.904  48.742   3.195  1.00 30.54           S  
ATOM    533  N   PRO B  12     -14.234  47.086   0.232  1.00 32.02           N  
ATOM    534  CA  PRO B  12     -15.478  46.537  -0.318  1.00 34.38           C  
ATOM    535  C   PRO B  12     -16.713  47.145   0.342  1.00 39.24           C  
ATOM    536  O   PRO B  12     -17.749  47.328  -0.305  1.00 39.09           O  
ATOM    537  CB  PRO B  12     -15.345  45.034  -0.057  1.00 30.93           C  
ATOM    538  CG  PRO B  12     -14.292  44.931   1.028  1.00 27.82           C  
ATOM    539  CD  PRO B  12     -13.329  46.008   0.654  1.00 29.83           C  
ATOM    540  N   ILE B  13     -16.583  47.474   1.624  1.00 41.96           N  
ATOM    541  CA  ILE B  13     -17.671  48.060   2.394  1.00 36.68           C  
ATOM    542  C   ILE B  13     -17.823  49.579   2.241  1.00 38.54           C  
ATOM    543  O   ILE B  13     -18.911  50.070   1.918  1.00 38.59           O  
ATOM    544  CB  ILE B  13     -17.506  47.736   3.911  1.00 37.16           C  
ATOM    545  CG1 ILE B  13     -17.724  46.234   4.153  1.00 31.76           C  
ATOM    546  CG2 ILE B  13     -18.443  48.600   4.742  1.00 45.98           C  
ATOM    547  CD1 ILE B  13     -18.956  45.645   3.468  1.00 38.27           C  
ATOM    548  N   CYS B  14     -16.740  50.320   2.467  1.00 37.62           N  
ATOM    549  CA  CYS B  14     -16.795  51.783   2.387  1.00 34.63           C  
ATOM    550  C   CYS B  14     -16.103  52.435   1.192  1.00 36.86           C  
ATOM    551  O   CYS B  14     -16.159  53.658   1.040  1.00 36.37           O  
ATOM    552  CB  CYS B  14     -16.217  52.394   3.666  1.00 36.56           C  
ATOM    553  SG  CYS B  14     -14.419  52.260   3.818  1.00 33.64           S  
ATOM    554  N   LYS B  15     -15.446  51.638   0.356  1.00 38.88           N  
ATOM    555  CA  LYS B  15     -14.750  52.170  -0.811  1.00 39.98           C  
ATOM    556  C   LYS B  15     -13.566  53.038  -0.384  1.00 41.28           C  
ATOM    557  O   LYS B  15     -13.023  53.792  -1.191  1.00 40.53           O  
ATOM    558  CB  LYS B  15     -15.697  53.010  -1.675  1.00 42.24           C  
ATOM    559  CG  LYS B  15     -17.036  52.346  -1.973  1.00 50.09           C  
ATOM    560  CD  LYS B  15     -16.880  50.957  -2.577  1.00 60.73           C  
ATOM    561  CE  LYS B  15     -16.418  51.021  -4.014  1.00 68.67           C  
ATOM    562  NZ  LYS B  15     -17.220  52.004  -4.781  1.00 68.26           N  
ATOM    563  N   GLY B  16     -13.168  52.933   0.883  1.00 38.42           N  
ATOM    564  CA  GLY B  16     -12.047  53.720   1.363  1.00 38.10           C  
ATOM    565  C   GLY B  16     -10.694  53.078   1.100  1.00 35.07           C  
ATOM    566  O   GLY B  16     -10.621  51.904   0.752  1.00 38.33           O  
ATOM    567  N   PRO B  17      -9.595  53.835   1.260  1.00 35.33           N  
ATOM    568  CA  PRO B  17      -8.227  53.349   1.045  1.00 31.40           C  
ATOM    569  C   PRO B  17      -7.879  52.191   1.992  1.00 30.43           C  
ATOM    570  O   PRO B  17      -8.482  52.047   3.053  1.00 22.93           O  
ATOM    571  CB  PRO B  17      -7.379  54.595   1.289  1.00 33.21           C  
ATOM    572  CG  PRO B  17      -8.199  55.385   2.273  1.00 32.92           C  
ATOM    573  CD  PRO B  17      -9.592  55.236   1.716  1.00 35.98           C  
ATOM    574  N   LEU B  18      -6.927  51.357   1.582  1.00 23.07           N  
ATOM    575  CA  LEU B  18      -6.491  50.212   2.381  1.00 26.15           C  
ATOM    576  C   LEU B  18      -5.006  50.358   2.641  1.00 27.98           C  
ATOM    577  O   LEU B  18      -4.287  50.915   1.820  1.00 27.49           O  
ATOM    578  CB  LEU B  18      -6.724  48.910   1.618  1.00 27.96           C  
ATOM    579  CG  LEU B  18      -8.189  48.589   1.327  1.00 27.43           C  
ATOM    580  CD1 LEU B  18      -8.310  47.421   0.352  1.00 21.24           C  
ATOM    581  CD2 LEU B  18      -8.868  48.272   2.644  1.00 18.80           C  
ATOM    582  N   LYS B  19      -4.549  49.864   3.784  1.00 23.32           N  
ATOM    583  CA  LYS B  19      -3.139  49.928   4.111  1.00 25.19           C  
ATOM    584  C   LYS B  19      -2.689  48.520   4.433  1.00 19.16           C  
ATOM    585  O   LYS B  19      -3.470  47.720   4.937  1.00 25.38           O  
ATOM    586  CB  LYS B  19      -2.897  50.827   5.334  1.00 24.05           C  
ATOM    587  CG  LYS B  19      -2.827  52.323   5.038  1.00 27.66           C  
ATOM    588  CD  LYS B  19      -2.385  53.093   6.280  1.00 43.51           C  
ATOM    589  CE  LYS B  19      -3.252  52.781   7.490  1.00 60.28           C  
ATOM    590  NZ  LYS B  19      -4.491  53.593   7.538  1.00 69.18           N  
ATOM    591  N   LEU B  20      -1.431  48.208   4.145  1.00 25.34           N  
ATOM    592  CA  LEU B  20      -0.918  46.883   4.453  1.00 26.19           C  
ATOM    593  C   LEU B  20      -0.593  46.884   5.940  1.00 26.01           C  
ATOM    594  O   LEU B  20       0.194  47.702   6.383  1.00 27.38           O  
ATOM    595  CB  LEU B  20       0.339  46.599   3.620  1.00 30.08           C  
ATOM    596  CG  LEU B  20       1.065  45.255   3.761  1.00 28.72           C  
ATOM    597  CD1 LEU B  20       0.099  44.083   3.661  1.00 21.58           C  
ATOM    598  CD2 LEU B  20       2.118  45.180   2.664  1.00 25.47           C  
ATOM    599  N   SER B  21      -1.217  45.986   6.706  1.00 22.38           N  
ATOM    600  CA  SER B  21      -0.979  45.903   8.148  1.00 18.77           C  
ATOM    601  C   SER B  21       0.508  45.760   8.427  1.00 20.19           C  
ATOM    602  O   SER B  21       1.265  45.303   7.577  1.00 21.24           O  
ATOM    603  CB  SER B  21      -1.703  44.699   8.761  1.00 15.25           C  
ATOM    604  OG  SER B  21      -1.024  43.495   8.442  1.00 16.35           O  
ATOM    605  N   ALA B  22       0.918  46.131   9.635  1.00 22.86           N  
ATOM    606  CA  ALA B  22       2.320  46.053  10.028  1.00 25.96           C  
ATOM    607  C   ALA B  22       2.875  44.628   9.993  1.00 25.42           C  
ATOM    608  O   ALA B  22       4.056  44.434   9.696  1.00 35.03           O  
ATOM    609  CB  ALA B  22       2.510  46.668  11.419  1.00 31.46           C  
ATOM    610  N   ASP B  23       2.055  43.623  10.300  1.00 28.23           N  
ATOM    611  CA  ASP B  23       2.565  42.255  10.244  1.00 22.52           C  
ATOM    612  C   ASP B  23       2.389  41.726   8.821  1.00 25.84           C  
ATOM    613  O   ASP B  23       2.731  40.581   8.518  1.00 26.46           O  
ATOM    614  CB  ASP B  23       1.847  41.333  11.250  1.00 19.66           C  
ATOM    615  CG  ASP B  23       0.367  41.152  10.947  1.00 33.54           C  
ATOM    616  OD1 ASP B  23      -0.078  41.454   9.819  1.00 29.93           O  
ATOM    617  OD2 ASP B  23      -0.360  40.700  11.858  1.00 30.10           O  
ATOM    618  N   LYS B  24       1.857  42.595   7.963  1.00 27.21           N  
ATOM    619  CA  LYS B  24       1.594  42.319   6.548  1.00 29.23           C  
ATOM    620  C   LYS B  24       0.743  41.089   6.223  1.00 30.58           C  
ATOM    621  O   LYS B  24       0.947  40.440   5.192  1.00 26.78           O  
ATOM    622  CB  LYS B  24       2.912  42.289   5.734  1.00 36.20           C  
ATOM    623  CG  LYS B  24       4.017  41.364   6.246  1.00 44.36           C  
ATOM    624  CD  LYS B  24       3.911  39.964   5.646  1.00 67.37           C  
ATOM    625  CE  LYS B  24       4.818  38.988   6.382  1.00 69.30           C  
ATOM    626  NZ  LYS B  24       5.147  37.783   5.574  1.00 68.74           N  
ATOM    627  N   THR B  25      -0.218  40.775   7.094  1.00 21.31           N  
ATOM    628  CA  THR B  25      -1.114  39.647   6.853  1.00 26.25           C  
ATOM    629  C   THR B  25      -2.510  40.157   6.502  1.00 21.66           C  
ATOM    630  O   THR B  25      -3.367  39.390   6.073  1.00 20.80           O  
ATOM    631  CB  THR B  25      -1.268  38.722   8.084  1.00 20.19           C  
ATOM    632  OG1 THR B  25      -1.771  39.474   9.195  1.00 21.30           O  
ATOM    633  CG2 THR B  25       0.058  38.088   8.452  1.00 35.52           C  
ATOM    634  N   GLU B  26      -2.747  41.452   6.682  1.00 21.73           N  
ATOM    635  CA  GLU B  26      -4.070  42.004   6.386  1.00 13.82           C  
ATOM    636  C   GLU B  26      -4.019  43.313   5.632  1.00 15.10           C  
ATOM    637  O   GLU B  26      -2.982  43.946   5.547  1.00 17.68           O  
ATOM    638  CB  GLU B  26      -4.841  42.254   7.692  1.00 15.32           C  
ATOM    639  CG  GLU B  26      -4.867  41.070   8.655  1.00 14.52           C  
ATOM    640  CD  GLU B  26      -5.226  41.496  10.072  1.00 30.48           C  
ATOM    641  OE1 GLU B  26      -4.594  42.453  10.565  1.00 27.18           O  
ATOM    642  OE2 GLU B  26      -6.128  40.883  10.691  1.00 22.96           O  
ATOM    643  N   LEU B  27      -5.167  43.703   5.082  1.00 16.98           N  
ATOM    644  CA  LEU B  27      -5.313  44.975   4.388  1.00 21.42           C  
ATOM    645  C   LEU B  27      -6.254  45.721   5.323  1.00 24.53           C  
ATOM    646  O   LEU B  27      -7.395  45.308   5.521  1.00 24.50           O  
ATOM    647  CB  LEU B  27      -5.947  44.794   3.007  1.00 17.57           C  
ATOM    648  CG  LEU B  27      -5.157  43.971   1.983  1.00 15.74           C  
ATOM    649  CD1 LEU B  27      -5.909  43.951   0.659  1.00 22.50           C  
ATOM    650  CD2 LEU B  27      -3.762  44.554   1.807  1.00 25.62           C  
ATOM    651  N   ILE B  28      -5.759  46.800   5.923  1.00 22.16           N  
ATOM    652  CA  ILE B  28      -6.548  47.568   6.875  1.00 19.42           C  
ATOM    653  C   ILE B  28      -7.446  48.629   6.254  1.00 22.05           C  
ATOM    654  O   ILE B  28      -7.000  49.427   5.435  1.00 22.64           O  
ATOM    655  CB  ILE B  28      -5.637  48.298   7.880  1.00 17.77           C  
ATOM    656  CG1 ILE B  28      -4.620  47.320   8.468  1.00 19.13           C  
ATOM    657  CG2 ILE B  28      -6.480  48.946   8.986  1.00 19.53           C  
ATOM    658  CD1 ILE B  28      -5.233  46.162   9.230  1.00 15.08           C  
ATOM    659  N   SER B  29      -8.715  48.629   6.650  1.00 23.17           N  
ATOM    660  CA  SER B  29      -9.660  49.642   6.187  1.00 24.01           C  
ATOM    661  C   SER B  29     -10.107  50.398   7.431  1.00 24.82           C  
ATOM    662  O   SER B  29     -10.968  49.925   8.174  1.00 23.10           O  
ATOM    663  CB  SER B  29     -10.890  49.026   5.528  1.00 25.73           C  
ATOM    664  OG  SER B  29     -11.828  50.043   5.185  1.00 26.65           O  
ATOM    665  N   LYS B  30      -9.490  51.546   7.692  1.00 24.67           N  
ATOM    666  CA  LYS B  30      -9.887  52.325   8.856  1.00 30.94           C  
ATOM    667  C   LYS B  30     -11.277  52.839   8.542  1.00 31.60           C  
ATOM    668  O   LYS B  30     -12.164  52.851   9.405  1.00 29.06           O  
ATOM    669  CB  LYS B  30      -8.929  53.491   9.099  1.00 33.31           C  
ATOM    670  CG  LYS B  30      -7.591  53.076   9.696  1.00 30.60           C  
ATOM    671  CD  LYS B  30      -7.237  53.874  10.944  1.00 42.87           C  
ATOM    672  CE  LYS B  30      -5.893  53.409  11.490  1.00 44.88           C  
ATOM    673  NZ  LYS B  30      -5.586  53.943  12.846  1.00 52.51           N  
ATOM    674  N   GLY B  31     -11.460  53.235   7.286  1.00 28.12           N  
ATOM    675  CA  GLY B  31     -12.742  53.742   6.837  1.00 26.15           C  
ATOM    676  C   GLY B  31     -13.908  52.884   7.284  1.00 26.70           C  
ATOM    677  O   GLY B  31     -15.020  53.394   7.458  1.00 29.71           O  
ATOM    678  N   ALA B  32     -13.655  51.592   7.493  1.00 24.87           N  
ATOM    679  CA  ALA B  32     -14.699  50.668   7.924  1.00 25.03           C  
ATOM    680  C   ALA B  32     -14.429  49.967   9.255  1.00 27.26           C  
ATOM    681  O   ALA B  32     -15.256  49.188   9.711  1.00 29.25           O  
ATOM    682  CB  ALA B  32     -14.927  49.609   6.840  1.00 25.79           C  
ATOM    683  N   GLY B  33     -13.286  50.232   9.877  1.00 27.69           N  
ATOM    684  CA  GLY B  33     -12.983  49.576  11.136  1.00 27.73           C  
ATOM    685  C   GLY B  33     -12.794  48.095  10.880  1.00 33.45           C  
ATOM    686  O   GLY B  33     -13.091  47.251  11.729  1.00 33.13           O  
ATOM    687  N   LEU B  34     -12.276  47.774   9.697  1.00 32.32           N  
ATOM    688  CA  LEU B  34     -12.059  46.379   9.327  1.00 32.91           C  
ATOM    689  C   LEU B  34     -10.668  46.023   8.763  1.00 27.32           C  
ATOM    690  O   LEU B  34      -9.958  46.881   8.235  1.00 30.52           O  
ATOM    691  CB  LEU B  34     -13.121  45.956   8.302  1.00 36.29           C  
ATOM    692  CG  LEU B  34     -14.589  45.898   8.733  1.00 32.62           C  
ATOM    693  CD1 LEU B  34     -15.456  45.408   7.573  1.00 40.63           C  
ATOM    694  CD2 LEU B  34     -14.721  44.955   9.915  1.00 30.42           C  
ATOM    695  N   ALA B  35     -10.297  44.746   8.875  1.00 27.37           N  
ATOM    696  CA  ALA B  35      -9.024  44.244   8.371  1.00 23.37           C  
ATOM    697  C   ALA B  35      -9.270  42.986   7.542  1.00 24.06           C  
ATOM    698  O   ALA B  35      -9.625  41.934   8.070  1.00 23.89           O  
ATOM    699  CB  ALA B  35      -8.079  43.926   9.527  1.00 20.10           C  
ATOM    700  N   TYR B  36      -9.082  43.092   6.236  1.00 24.42           N  
ATOM    701  CA  TYR B  36      -9.280  41.936   5.385  1.00 21.30           C  
ATOM    702  C   TYR B  36      -8.035  41.065   5.422  1.00 20.90           C  
ATOM    703  O   TYR B  36      -6.912  41.541   5.264  1.00 22.91           O  
ATOM    704  CB  TYR B  36      -9.591  42.390   3.971  1.00 21.99           C  
ATOM    705  CG  TYR B  36     -10.768  43.328   3.941  1.00 24.01           C  
ATOM    706  CD1 TYR B  36     -12.075  42.855   4.097  1.00 26.69           C  
ATOM    707  CD2 TYR B  36     -10.574  44.696   3.790  1.00 31.67           C  
ATOM    708  CE1 TYR B  36     -13.160  43.735   4.108  1.00 22.60           C  
ATOM    709  CE2 TYR B  36     -11.641  45.581   3.802  1.00 33.28           C  
ATOM    710  CZ  TYR B  36     -12.930  45.102   3.954  1.00 31.80           C  
ATOM    711  OH  TYR B  36     -13.975  45.995   3.925  1.00 34.49           O  
ATOM    712  N   PRO B  37      -8.226  39.761   5.637  1.00 21.67           N  
ATOM    713  CA  PRO B  37      -7.128  38.803   5.709  1.00 23.07           C  
ATOM    714  C   PRO B  37      -6.504  38.457   4.357  1.00 30.66           C  
ATOM    715  O   PRO B  37      -7.182  38.454   3.330  1.00 35.57           O  
ATOM    716  CB  PRO B  37      -7.782  37.601   6.392  1.00 21.89           C  
ATOM    717  CG  PRO B  37      -9.172  37.626   5.852  1.00 14.75           C  
ATOM    718  CD  PRO B  37      -9.539  39.096   5.761  1.00 19.82           C  
ATOM    719  N   ILE B  38      -5.196  38.219   4.352  1.00 28.90           N  
ATOM    720  CA  ILE B  38      -4.519  37.823   3.123  1.00 28.51           C  
ATOM    721  C   ILE B  38      -4.235  36.356   3.381  1.00 26.15           C  
ATOM    722  O   ILE B  38      -3.501  36.015   4.303  1.00 26.18           O  
ATOM    723  CB  ILE B  38      -3.198  38.620   2.891  1.00 20.33           C  
ATOM    724  CG1 ILE B  38      -3.536  40.083   2.567  1.00 27.91           C  
ATOM    725  CG2 ILE B  38      -2.410  38.026   1.722  1.00 24.90           C  
ATOM    726  CD1 ILE B  38      -2.345  41.003   2.504  1.00 22.49           C  
ATOM    727  N   ARG B  39      -4.876  35.490   2.602  1.00 25.80           N  
ATOM    728  CA  ARG B  39      -4.704  34.053   2.767  1.00 27.38           C  
ATOM    729  C   ARG B  39      -4.449  33.376   1.435  1.00 27.83           C  
ATOM    730  O   ARG B  39      -5.041  33.734   0.422  1.00 29.10           O  
ATOM    731  CB  ARG B  39      -5.946  33.440   3.426  1.00 26.48           C  
ATOM    732  CG  ARG B  39      -5.731  32.944   4.847  1.00 41.38           C  
ATOM    733  CD  ARG B  39      -6.955  32.190   5.330  1.00 54.35           C  
ATOM    734  NE  ARG B  39      -8.146  33.032   5.294  1.00 66.58           N  
ATOM    735  CZ  ARG B  39      -8.546  33.808   6.296  1.00 67.98           C  
ATOM    736  NH1 ARG B  39      -7.857  33.844   7.430  1.00 61.07           N  
ATOM    737  NH2 ARG B  39      -9.632  34.556   6.159  1.00 58.94           N  
ATOM    738  N   ASP B  40      -3.559  32.395   1.452  1.00 27.35           N  
ATOM    739  CA  ASP B  40      -3.210  31.662   0.247  1.00 31.56           C  
ATOM    740  C   ASP B  40      -2.851  32.636  -0.871  1.00 30.93           C  
ATOM    741  O   ASP B  40      -3.111  32.383  -2.047  1.00 29.65           O  
ATOM    742  CB  ASP B  40      -4.372  30.761  -0.166  1.00 31.35           C  
ATOM    743  CG  ASP B  40      -4.878  29.919   0.990  1.00 32.96           C  
ATOM    744  OD1 ASP B  40      -6.064  30.063   1.350  1.00 37.76           O  
ATOM    745  OD2 ASP B  40      -4.084  29.125   1.546  1.00 34.69           O  
ATOM    746  N   GLY B  41      -2.254  33.758  -0.471  1.00 31.19           N  
ATOM    747  CA  GLY B  41      -1.820  34.783  -1.407  1.00 28.62           C  
ATOM    748  C   GLY B  41      -2.888  35.624  -2.086  1.00 32.62           C  
ATOM    749  O   GLY B  41      -2.630  36.228  -3.133  1.00 35.38           O  
ATOM    750  N   ILE B  42      -4.074  35.686  -1.487  1.00 29.84           N  
ATOM    751  CA  ILE B  42      -5.190  36.442  -2.045  1.00 31.29           C  
ATOM    752  C   ILE B  42      -5.760  37.371  -0.998  1.00 30.46           C  
ATOM    753  O   ILE B  42      -5.956  36.964   0.139  1.00 30.77           O  
ATOM    754  CB  ILE B  42      -6.347  35.514  -2.450  1.00 35.34           C  
ATOM    755  CG1 ILE B  42      -5.832  34.368  -3.315  1.00 43.49           C  
ATOM    756  CG2 ILE B  42      -7.424  36.315  -3.159  1.00 40.90           C  
ATOM    757  CD1 ILE B  42      -5.091  34.825  -4.535  1.00 45.46           C  
ATOM    758  N   PRO B  43      -6.027  38.635  -1.350  1.00 27.11           N  
ATOM    759  CA  PRO B  43      -6.592  39.460  -0.284  1.00 27.09           C  
ATOM    760  C   PRO B  43      -8.068  39.083  -0.198  1.00 29.37           C  
ATOM    761  O   PRO B  43      -8.815  39.267  -1.154  1.00 33.82           O  
ATOM    762  CB  PRO B  43      -6.357  40.883  -0.794  1.00 25.94           C  
ATOM    763  CG  PRO B  43      -6.491  40.728  -2.282  1.00 27.77           C  
ATOM    764  CD  PRO B  43      -5.718  39.439  -2.546  1.00 26.88           C  
ATOM    765  N   VAL B  44      -8.477  38.558   0.952  1.00 28.81           N  
ATOM    766  CA  VAL B  44      -9.845  38.085   1.135  1.00 29.43           C  
ATOM    767  C   VAL B  44     -10.786  39.237   1.470  1.00 31.65           C  
ATOM    768  O   VAL B  44     -10.991  39.564   2.639  1.00 28.92           O  
ATOM    769  CB  VAL B  44      -9.930  37.024   2.249  1.00 27.16           C  
ATOM    770  CG1 VAL B  44     -11.376  36.610   2.480  1.00 31.95           C  
ATOM    771  CG2 VAL B  44      -9.072  35.817   1.902  1.00 27.86           C  
HETATM  772  N   MSE B  45     -11.356  39.848   0.437  1.00 33.03           N  
HETATM  773  CA  MSE B  45     -12.188  41.032   0.610  1.00 33.30           C  
HETATM  774  C   MSE B  45     -13.641  40.650   0.870  1.00 32.57           C  
HETATM  775  O   MSE B  45     -14.491  40.768  -0.013  1.00 29.49           O  
HETATM  776  CB  MSE B  45     -12.094  41.939  -0.618  1.00 38.50           C  
HETATM  777  CG  MSE B  45     -11.628  43.353  -0.311  1.00 54.07           C  
HETATM  778 SE   MSE B  45      -9.419  43.046   0.327  1.00 46.81          SE  
HETATM  779  CE  MSE B  45      -8.767  43.826  -1.765  1.00 44.91           C  
ATOM    780  N   LEU B  46     -13.920  40.194   2.086  1.00 36.13           N  
ATOM    781  CA  LEU B  46     -15.288  39.910   2.504  1.00 35.99           C  
ATOM    782  C   LEU B  46     -15.525  40.338   3.947  1.00 39.19           C  
ATOM    783  O   LEU B  46     -14.745  40.005   4.840  1.00 39.34           O  
ATOM    784  CB  LEU B  46     -15.600  38.421   2.339  1.00 35.26           C  
ATOM    785  CG  LEU B  46     -15.473  37.855   0.923  1.00 38.61           C  
ATOM    786  CD1 LEU B  46     -15.818  36.373   0.904  1.00 27.88           C  
ATOM    787  CD2 LEU B  46     -16.354  38.627  -0.046  1.00 36.08           C  
ATOM    788  N   GLU B  47     -16.606  41.078   4.170  1.00 42.24           N  
ATOM    789  CA  GLU B  47     -16.957  41.534   5.504  1.00 44.42           C  
ATOM    790  C   GLU B  47     -17.046  40.279   6.366  1.00 43.88           C  
ATOM    791  O   GLU B  47     -16.640  40.280   7.528  1.00 44.65           O  
ATOM    792  CB  GLU B  47     -18.305  42.273   5.469  1.00 44.36           C  
ATOM    793  CG  GLU B  47     -18.625  43.097   6.714  1.00 45.53           C  
ATOM    794  CD  GLU B  47     -19.885  43.933   6.552  1.00 46.66           C  
ATOM    795  OE1 GLU B  47     -20.822  43.467   5.865  1.00 58.10           O  
ATOM    796  OE2 GLU B  47     -19.949  45.044   7.121  1.00 63.52           O  
ATOM    797  N   SER B  48     -17.551  39.200   5.772  1.00 44.32           N  
ATOM    798  CA  SER B  48     -17.695  37.925   6.475  1.00 44.24           C  
ATOM    799  C   SER B  48     -16.382  37.340   6.992  1.00 45.02           C  
ATOM    800  O   SER B  48     -16.369  36.586   7.973  1.00 44.00           O  
ATOM    801  CB  SER B  48     -18.386  36.891   5.568  1.00 46.71           C  
ATOM    802  OG  SER B  48     -17.842  36.907   4.260  1.00 45.07           O  
ATOM    803  N   GLU B  49     -15.280  37.683   6.336  1.00 42.73           N  
ATOM    804  CA  GLU B  49     -13.978  37.167   6.738  1.00 37.94           C  
ATOM    805  C   GLU B  49     -13.121  38.193   7.474  1.00 37.86           C  
ATOM    806  O   GLU B  49     -12.147  37.835   8.135  1.00 37.96           O  
ATOM    807  CB  GLU B  49     -13.204  36.682   5.502  1.00 40.68           C  
ATOM    808  CG  GLU B  49     -13.924  35.652   4.665  1.00 37.91           C  
ATOM    809  CD  GLU B  49     -14.233  34.384   5.430  1.00 48.32           C  
ATOM    810  OE1 GLU B  49     -13.283  33.696   5.865  1.00 45.35           O  
ATOM    811  OE2 GLU B  49     -15.431  34.080   5.599  1.00 47.10           O  
ATOM    812  N   ALA B  50     -13.484  39.464   7.351  1.00 36.91           N  
ATOM    813  CA  ALA B  50     -12.730  40.547   7.974  1.00 31.33           C  
ATOM    814  C   ALA B  50     -12.684  40.501   9.504  1.00 36.30           C  
ATOM    815  O   ALA B  50     -13.568  39.945  10.164  1.00 33.43           O  
ATOM    816  CB  ALA B  50     -13.292  41.887   7.512  1.00 30.29           C  
ATOM    817  N   ARG B  51     -11.628  41.086  10.062  1.00 37.53           N  
ATOM    818  CA  ARG B  51     -11.442  41.153  11.507  1.00 30.72           C  
ATOM    819  C   ARG B  51     -11.808  42.569  11.934  1.00 30.46           C  
ATOM    820  O   ARG B  51     -11.442  43.539  11.265  1.00 31.91           O  
ATOM    821  CB  ARG B  51      -9.974  40.839  11.868  1.00 26.81           C  
ATOM    822  CG  ARG B  51      -9.565  41.050  13.336  1.00 30.87           C  
ATOM    823  CD  ARG B  51      -8.083  40.686  13.570  1.00 34.44           C  
ATOM    824  NE  ARG B  51      -7.155  41.647  12.961  1.00 22.09           N  
ATOM    825  CZ  ARG B  51      -6.914  42.856  13.451  1.00 34.07           C  
ATOM    826  NH1 ARG B  51      -7.520  43.244  14.564  1.00 22.51           N  
ATOM    827  NH2 ARG B  51      -6.081  43.684  12.826  1.00 20.97           N  
ATOM    828  N   THR B  52     -12.554  42.693  13.025  1.00 31.47           N  
ATOM    829  CA  THR B  52     -12.940  44.011  13.513  1.00 28.24           C  
ATOM    830  C   THR B  52     -11.705  44.631  14.156  1.00 24.50           C  
ATOM    831  O   THR B  52     -11.093  44.013  15.026  1.00 25.27           O  
ATOM    832  CB  THR B  52     -14.061  43.910  14.575  1.00 34.97           C  
ATOM    833  OG1 THR B  52     -15.144  43.130  14.054  1.00 32.53           O  
ATOM    834  CG2 THR B  52     -14.573  45.300  14.944  1.00 27.19           C  
ATOM    835  N   LEU B  53     -11.328  45.834  13.727  1.00 18.28           N  
ATOM    836  CA  LEU B  53     -10.156  46.488  14.302  1.00 20.27           C  
ATOM    837  C   LEU B  53     -10.390  46.754  15.776  1.00 24.44           C  
ATOM    838  O   LEU B  53     -11.485  47.143  16.178  1.00 27.23           O  
ATOM    839  CB  LEU B  53      -9.872  47.823  13.602  1.00 15.82           C  
ATOM    840  CG  LEU B  53      -9.468  47.738  12.134  1.00 21.76           C  
ATOM    841  CD1 LEU B  53      -9.236  49.152  11.597  1.00 26.31           C  
ATOM    842  CD2 LEU B  53      -8.219  46.900  12.012  1.00 22.31           C  
ATOM    843  N   THR B  54      -9.352  46.548  16.575  1.00 31.31           N  
ATOM    844  CA  THR B  54      -9.439  46.783  18.005  1.00 27.44           C  
ATOM    845  C   THR B  54      -9.533  48.276  18.255  1.00 28.55           C  
ATOM    846  O   THR B  54      -9.340  49.086  17.345  1.00 28.66           O  
ATOM    847  CB  THR B  54      -8.207  46.247  18.750  1.00 27.31           C  
ATOM    848  OG1 THR B  54      -7.034  46.912  18.268  1.00 25.11           O  
ATOM    849  CG2 THR B  54      -8.070  44.750  18.541  1.00 25.92           C  
ATOM    850  N   THR B  55      -9.835  48.640  19.493  1.00 22.83           N  
ATOM    851  CA  THR B  55      -9.952  50.040  19.840  1.00 24.42           C  
ATOM    852  C   THR B  55      -8.683  50.817  19.503  1.00 16.69           C  
ATOM    853  O   THR B  55      -8.742  51.892  18.896  1.00 15.24           O  
ATOM    854  CB  THR B  55     -10.256  50.204  21.324  1.00 21.63           C  
ATOM    855  OG1 THR B  55     -11.523  49.602  21.603  1.00 25.35           O  
ATOM    856  CG2 THR B  55     -10.290  51.678  21.699  1.00 25.93           C  
ATOM    857  N   GLU B  56      -7.545  50.271  19.916  1.00 14.10           N  
ATOM    858  CA  GLU B  56      -6.243  50.890  19.699  1.00 20.65           C  
ATOM    859  C   GLU B  56      -5.928  51.100  18.225  1.00 23.47           C  
ATOM    860  O   GLU B  56      -5.252  52.073  17.859  1.00 24.15           O  
ATOM    861  CB  GLU B  56      -5.163  50.037  20.341  1.00 29.49           C  
ATOM    862  N   GLU B  57      -6.415  50.187  17.387  1.00 23.81           N  
ATOM    863  CA  GLU B  57      -6.201  50.258  15.947  1.00 26.54           C  
ATOM    864  C   GLU B  57      -7.022  51.362  15.293  1.00 25.73           C  
ATOM    865  O   GLU B  57      -6.601  51.957  14.303  1.00 24.81           O  
ATOM    866  CB  GLU B  57      -6.548  48.915  15.299  1.00 21.81           C  
ATOM    867  CG  GLU B  57      -5.494  47.840  15.499  1.00 25.62           C  
ATOM    868  CD  GLU B  57      -5.905  46.516  14.905  1.00 28.14           C  
ATOM    869  OE1 GLU B  57      -6.817  45.874  15.465  1.00 28.86           O  
ATOM    870  OE2 GLU B  57      -5.324  46.120  13.874  1.00 26.39           O  
ATOM    871  N   ARG B  58      -8.195  51.634  15.852  1.00 26.20           N  
ATOM    872  CA  ARG B  58      -9.078  52.660  15.312  1.00 24.76           C  
ATOM    873  C   ARG B  58      -8.648  54.063  15.716  1.00 30.44           C  
ATOM    874  O   ARG B  58      -8.896  55.024  14.992  1.00 33.69           O  
ATOM    875  CB  ARG B  58     -10.509  52.415  15.784  1.00 24.45           C  
ATOM    876  CG  ARG B  58     -11.096  51.086  15.351  1.00 15.70           C  
ATOM    877  CD  ARG B  58     -12.356  50.773  16.140  1.00 28.12           C  
ATOM    878  NE  ARG B  58     -13.055  49.610  15.605  1.00 29.08           N  
ATOM    879  CZ  ARG B  58     -14.200  49.675  14.934  1.00 35.00           C  
ATOM    880  NH1 ARG B  58     -14.787  50.848  14.726  1.00 36.91           N  
ATOM    881  NH2 ARG B  58     -14.759  48.567  14.469  1.00 46.99           N  
ATOM    882  N   LEU B  59      -8.020  54.184  16.880  1.00 34.35           N  
ATOM    883  CA  LEU B  59      -7.564  55.487  17.341  1.00 36.59           C  
ATOM    884  C   LEU B  59      -6.484  55.962  16.388  1.00 40.22           C  
ATOM    885  O   LEU B  59      -5.949  55.189  15.597  1.00 39.89           O  
ATOM    886  CB  LEU B  59      -6.979  55.388  18.753  1.00 36.71           C  
ATOM    887  CG  LEU B  59      -7.898  54.896  19.872  1.00 39.66           C  
ATOM    888  CD1 LEU B  59      -7.060  54.501  21.074  1.00 40.36           C  
ATOM    889  CD2 LEU B  59      -8.908  55.976  20.238  1.00 32.91           C  
ATOM    890  N   ASP B  60      -6.169  57.247  16.450  1.00 44.11           N  
ATOM    891  CA  ASP B  60      -5.118  57.786  15.599  1.00 53.66           C  
ATOM    892  C   ASP B  60      -3.878  57.895  16.477  1.00 60.90           C  
ATOM    893  O   ASP B  60      -3.939  58.476  17.564  1.00 64.24           O  
ATOM    894  CB  ASP B  60      -5.519  59.153  15.066  1.00 52.48           C  
ATOM    895  N   LYS B  61      -2.765  57.334  16.013  1.00 66.06           N  
ATOM    896  CA  LYS B  61      -1.518  57.373  16.767  1.00 70.09           C  
ATOM    897  C   LYS B  61      -1.122  58.822  17.013  1.00 73.29           C  
ATOM    898  O   LYS B  61      -0.404  59.133  17.965  1.00 73.76           O  
ATOM    899  CB  LYS B  61      -0.418  56.662  15.986  1.00 69.58           C  
ATOM    900  N   LEU B  62      -1.622  59.699  16.144  1.00 75.21           N  
ATOM    901  CA  LEU B  62      -1.347  61.134  16.195  1.00 73.90           C  
ATOM    902  C   LEU B  62      -2.143  61.934  17.235  1.00 73.82           C  
ATOM    903  O   LEU B  62      -1.994  63.183  17.243  1.00 75.01           O  
ATOM    904  CB  LEU B  62      -1.566  61.732  14.812  1.00 71.87           C  
TER     905      LEU B  62                                                      
END
MOLECULE T0480.pdb
ATOM     43  N   PHE    20      -9.421  47.124  -2.332  1.00  0.00
ATOM     44  HN  PHE    20      -9.663  47.024  -3.278  1.00  0.00
ATOM     45  CA  PHE    20     -10.050  48.188  -1.549  1.00  0.00
ATOM     46  HA  PHE    20      -9.287  48.642  -0.932  1.00  0.00
ATOM     47  CB  PHE    20     -10.641  49.260  -2.478  1.00  0.00
ATOM     48  HB1 PHE    20     -11.197  49.974  -1.885  1.00  0.00
ATOM     49  HB2 PHE    20     -11.316  48.788  -3.178  1.00  0.00
ATOM     50  CG  PHE    20      -9.613  50.019  -3.274  1.00  0.00
ATOM     51  CD1 PHE    20      -9.119  49.504  -4.460  1.00  0.00
ATOM     52  HD1 PHE    20      -9.476  48.547  -4.813  1.00  0.00
ATOM     53  CD2 PHE    20      -9.145  51.251  -2.836  1.00  0.00
ATOM     54  HD2 PHE    20      -9.523  51.664  -1.912  1.00  0.00
ATOM     55  CE1 PHE    20      -8.180  50.199  -5.195  1.00  0.00
ATOM     56  HE1 PHE    20      -7.803  49.783  -6.119  1.00  0.00
ATOM     57  CE2 PHE    20      -8.206  51.949  -3.568  1.00  0.00
ATOM     58  HE2 PHE    20      -7.850  52.908  -3.217  1.00  0.00
ATOM     59  CZ  PHE    20      -7.722  51.422  -4.750  1.00  0.00
ATOM     60  HZ  PHE    20      -6.988  51.966  -5.326  1.00  0.00
ATOM     61  C   PHE    20     -11.149  47.641  -0.643  1.00  0.00
ATOM     62  O   PHE    20     -11.503  46.465  -0.706  1.00  0.00
ATOM     63  N   CYS    21     -11.685  48.510   0.204  1.00  0.00
ATOM     64  HN  CYS    21     -11.329  49.425   0.240  1.00  0.00
ATOM     65  CA  CYS    21     -12.801  48.155   1.067  1.00  0.00
ATOM     66  HA  CYS    21     -12.726  47.105   1.318  1.00  0.00
ATOM     67  HB1 CYS    21     -12.914  50.028   2.087  1.00  0.00
ATOM     68  HB2 CYS    21     -11.760  48.898   2.773  1.00  0.00
ATOM     69  C   CYS    21     -14.100  48.414   0.312  1.00  0.00
ATOM     70  O   CYS    21     -14.384  49.557  -0.023  1.00  0.00
ATOM     71  CB  CYS    21     -12.742  48.991   2.341  1.00  0.00
ATOM     72  SG  CYS    21     -13.954  48.528   3.619  1.00  0.00
ATOM     73  N   PRO    22     -14.916  47.367   0.073  1.00  0.00
ATOM     74  CA  PRO    22     -16.026  47.404  -0.893  1.00  0.00
ATOM     75  HA  PRO    22     -15.680  47.160  -1.889  1.00  0.00
ATOM     76  CB  PRO    22     -16.958  46.298  -0.401  1.00  0.00
ATOM     77  HB1 PRO    22     -17.462  45.846  -1.245  1.00  0.00
ATOM     78  HB2 PRO    22     -17.694  46.716   0.276  1.00  0.00
ATOM     79  CG  PRO    22     -16.074  45.316   0.294  1.00  0.00
ATOM     80  HG1 PRO    22     -15.795  44.526  -0.389  1.00  0.00
ATOM     81  HG2 PRO    22     -16.602  44.907   1.141  1.00  0.00
ATOM     82  CD  PRO    22     -14.843  46.065   0.763  1.00  0.00
ATOM     83  HD1 PRO    22     -13.945  45.532   0.486  1.00  0.00
ATOM     84  HD2 PRO    22     -14.875  46.204   1.835  1.00  0.00
ATOM     85  C   PRO    22     -16.770  48.741  -0.939  1.00  0.00
ATOM     86  O   PRO    22     -16.834  49.390  -1.988  1.00  0.00
ATOM     87  N   ARG    23     -17.316  49.158   0.201  1.00  0.00
ATOM     88  HN  ARG    23     -17.154  48.653   1.025  1.00  0.00
ATOM     89  CA  ARG    23     -18.164  50.344   0.238  1.00  0.00
ATOM     90  HA  ARG    23     -18.672  50.391  -0.712  1.00  0.00
ATOM     91  CB  ARG    23     -19.223  50.223   1.341  1.00  0.00
ATOM     92  HB1 ARG    23     -19.804  51.135   1.369  1.00  0.00
ATOM     93  HB2 ARG    23     -18.724  50.096   2.291  1.00  0.00
ATOM     94  CG  ARG    23     -20.180  49.050   1.141  1.00  0.00
ATOM     95  HG1 ARG    23     -19.642  48.129   1.321  1.00  0.00
ATOM     96  HG2 ARG    23     -20.538  49.061   0.121  1.00  0.00
ATOM     97  CD  ARG    23     -21.381  49.113   2.081  1.00  0.00
ATOM     98  HD1 ARG    23     -21.999  48.242   1.910  1.00  0.00
ATOM     99  HD2 ARG    23     -21.951  50.003   1.854  1.00  0.00
ATOM    100  NE  ARG    23     -20.991  49.150   3.495  1.00  0.00
ATOM    101  HE  ARG    23     -20.100  49.512   3.706  1.00  0.00
ATOM    102  CZ  ARG    23     -21.777  48.752   4.498  1.00  0.00
ATOM    103  NH1 ARG    23     -22.967  48.220   4.250  1.00  0.00
ATOM    104 HH11 ARG    23     -23.285  48.110   3.303  1.00  0.00
ATOM    105 HH12 ARG    23     -23.556  47.929   5.009  1.00  0.00
ATOM    106  NH2 ARG    23     -21.364  48.866   5.751  1.00  0.00
ATOM    107 HH21 ARG    23     -20.460  49.252   5.953  1.00  0.00
ATOM    108 HH22 ARG    23     -21.954  48.569   6.504  1.00  0.00
ATOM    109  C   ARG    23     -17.352  51.633   0.415  1.00  0.00
ATOM    110  O   ARG    23     -17.758  52.692  -0.062  1.00  0.00
ATOM    111  N   CYS    24     -16.206  51.549   1.092  1.00  0.00
ATOM    112  HN  CYS    24     -15.914  50.681   1.429  1.00  0.00
ATOM    113  CA  CYS    24     -15.370  52.739   1.328  1.00  0.00
ATOM    114  HA  CYS    24     -16.018  53.602   1.381  1.00  0.00
ATOM    115  HB1 CYS    24     -14.192  53.616   2.885  1.00  0.00
ATOM    116  HB2 CYS    24     -13.735  51.970   2.480  1.00  0.00
ATOM    117  C   CYS    24     -14.366  52.941   0.194  1.00  0.00
ATOM    118  O   CYS    24     -13.660  53.947   0.171  1.00  0.00
ATOM    119  CB  CYS    24     -14.572  52.634   2.635  1.00  0.00
ATOM    120  SG  CYS    24     -15.473  52.014   4.084  1.00  0.00
ATOM    121  N   GLY    25     -14.311  51.975  -0.727  1.00  0.00
ATOM    122  HN  GLY    25     -15.009  51.286  -0.729  1.00  0.00
ATOM    123  CA  GLY    25     -13.256  51.919  -1.735  1.00  0.00
ATOM    124  HA1 GLY    25     -13.576  51.268  -2.533  1.00  0.00
ATOM    125  HA2 GLY    25     -12.373  51.493  -1.282  1.00  0.00
ATOM    126  C   GLY    25     -12.895  53.274  -2.316  1.00  0.00
ATOM    127  O   GLY    25     -11.779  53.757  -2.106  1.00  0.00
ATOM    128  N   PRO    26     -13.818  53.919  -3.049  1.00  0.00
ATOM    129  CA  PRO    26     -13.599  55.269  -3.570  1.00  0.00
ATOM    130  HA  PRO    26     -12.703  55.315  -4.175  1.00  0.00
ATOM    131  CB  PRO    26     -14.836  55.536  -4.453  1.00  0.00
ATOM    132  HB1 PRO    26     -14.526  55.974  -5.391  1.00  0.00
ATOM    133  HB2 PRO    26     -15.511  56.212  -3.944  1.00  0.00
ATOM    134  CG  PRO    26     -15.466  54.197  -4.662  1.00  0.00
ATOM    135  HG1 PRO    26     -15.052  53.729  -5.546  1.00  0.00
ATOM    136  HG2 PRO    26     -16.537  54.305  -4.764  1.00  0.00
ATOM    137  CD  PRO    26     -15.135  53.389  -3.440  1.00  0.00
ATOM    138  HD1 PRO    26     -15.075  52.339  -3.684  1.00  0.00
ATOM    139  HD2 PRO    26     -15.868  53.560  -2.664  1.00  0.00
ATOM    140  C   PRO    26     -13.496  56.293  -2.437  1.00  0.00
ATOM    141  O   PRO    26     -14.508  56.823  -1.967  1.00  0.00
ATOM    142  N   GLY    27     -12.275  56.524  -1.966  1.00  0.00
ATOM    143  HN  GLY    27     -11.520  56.002  -2.319  1.00  0.00
ATOM    144  CA  GLY    27     -12.036  57.519  -0.932  1.00  0.00
ATOM    145  HA1 GLY    27     -12.982  57.935  -0.612  1.00  0.00
ATOM    146  HA2 GLY    27     -11.430  58.310  -1.348  1.00  0.00
ATOM    147  C   GLY    27     -11.325  56.943   0.273  1.00  0.00
ATOM    148  O   GLY    27     -10.653  57.668   1.009  1.00  0.00
ATOM    149  N   VAL    28     -11.468  55.634   0.479  1.00  0.00
ATOM    150  HN  VAL    28     -12.031  55.114  -0.136  1.00  0.00
ATOM    151  CA  VAL    28     -10.810  54.948   1.591  1.00  0.00
ATOM    152  HA  VAL    28     -10.018  55.586   1.960  1.00  0.00
ATOM    153  CB  VAL    28     -11.782  54.646   2.763  1.00  0.00
ATOM    154  HB  VAL    28     -12.477  53.886   2.424  1.00  0.00
ATOM    155  CG1 VAL    28     -11.028  54.082   3.968  1.00  0.00
ATOM    156 HG11 VAL    28     -10.300  54.803   4.309  1.00  0.00
ATOM    157 HG12 VAL    28     -10.525  53.168   3.687  1.00  0.00
ATOM    158 HG13 VAL    28     -11.728  53.875   4.766  1.00  0.00
ATOM    159  CG2 VAL    28     -12.588  55.883   3.159  1.00  0.00
ATOM    160 HG21 VAL    28     -11.917  56.666   3.482  1.00  0.00
ATOM    161 HG22 VAL    28     -13.260  55.632   3.967  1.00  0.00
ATOM    162 HG23 VAL    28     -13.162  56.229   2.311  1.00  0.00
ATOM    163  C   VAL    28     -10.205  53.631   1.123  1.00  0.00
ATOM    164  O   VAL    28     -10.910  52.621   0.993  1.00  0.00
ATOM    165  N   PHE    29      -8.907  53.645   0.861  1.00  0.00
ATOM    166  HN  PHE    29      -8.420  54.495   0.903  1.00  0.00
ATOM    167  CA  PHE    29      -8.190  52.430   0.504  1.00  0.00
ATOM    168  HA  PHE    29      -8.697  51.979  -0.339  1.00  0.00
ATOM    169  CB  PHE    29      -6.738  52.749   0.109  1.00  0.00
ATOM    170  HB1 PHE    29      -6.738  53.555  -0.613  1.00  0.00
ATOM    171  HB2 PHE    29      -6.296  51.872  -0.342  1.00  0.00
ATOM    172  CG  PHE    29      -5.864  53.166   1.270  1.00  0.00
ATOM    173  CD1 PHE    29      -4.909  52.298   1.788  1.00  0.00
ATOM    174  HD1 PHE    29      -4.786  51.319   1.348  1.00  0.00
ATOM    175  CD2 PHE    29      -6.003  54.418   1.850  1.00  0.00
ATOM    176  HD2 PHE    29      -6.739  55.104   1.458  1.00  0.00
ATOM    177  CE1 PHE    29      -4.116  52.673   2.857  1.00  0.00
ATOM    178  HE1 PHE    29      -3.377  51.988   3.249  1.00  0.00
ATOM    179  CE2 PHE    29      -5.211  54.796   2.917  1.00  0.00
ATOM    180  HE2 PHE    29      -5.331  55.775   3.358  1.00  0.00
ATOM    181  CZ  PHE    29      -4.268  53.924   3.421  1.00  0.00
ATOM    182  HZ  PHE    29      -3.650  54.219   4.258  1.00  0.00
ATOM    183  C   PHE    29      -8.210  51.449   1.679  1.00  0.00
ATOM    184  O   PHE    29      -8.458  51.838   2.825  1.00  0.00
ATOM    185  N   LEU    30      -7.958  50.182   1.396  1.00  0.00
ATOM    186  HN  LEU    30      -7.805  49.919   0.464  1.00  0.00
ATOM    187  CA  LEU    30      -7.868  49.176   2.441  1.00  0.00
ATOM    188  HA  LEU    30      -8.446  49.515   3.292  1.00  0.00
ATOM    189  CB  LEU    30      -8.437  47.841   1.939  1.00  0.00
ATOM    190  HB1 LEU    30      -7.762  47.449   1.190  1.00  0.00
ATOM    191  HB2 LEU    30      -9.389  48.040   1.467  1.00  0.00
ATOM    192  CG  LEU    30      -8.649  46.756   3.010  1.00  0.00
ATOM    193  HG  LEU    30      -7.705  46.559   3.499  1.00  0.00
ATOM    194  CD1 LEU    30      -9.637  47.226   4.075  1.00  0.00
ATOM    195 HD11 LEU    30     -10.591  47.443   3.615  1.00  0.00
ATOM    196 HD12 LEU    30      -9.257  48.119   4.550  1.00  0.00
ATOM    197 HD13 LEU    30      -9.765  46.452   4.819  1.00  0.00
ATOM    198  CD2 LEU    30      -9.129  45.452   2.368  1.00  0.00
ATOM    199 HD21 LEU    30     -10.068  45.622   1.859  1.00  0.00
ATOM    200 HD22 LEU    30      -9.268  44.701   3.133  1.00  0.00
ATOM    201 HD23 LEU    30      -8.392  45.106   1.657  1.00  0.00
ATOM    202  C   LEU    30      -6.405  49.037   2.850  1.00  0.00
ATOM    203  O   LEU    30      -5.581  48.585   2.055  1.00  0.00
ATOM    204  N   ALA    31      -6.089  49.469   4.074  1.00  0.00
ATOM    205  HN  ALA    31      -6.808  49.759   4.671  1.00  0.00
ATOM    206  CA  ALA    31      -4.708  49.517   4.560  1.00  0.00
ATOM    207  HA  ALA    31      -4.182  50.263   3.979  1.00  0.00
ATOM    208  CB  ALA    31      -4.674  49.953   6.023  1.00  0.00
ATOM    209  HB1 ALA    31      -3.648  50.043   6.352  1.00  0.00
ATOM    210  HB2 ALA    31      -5.182  49.219   6.631  1.00  0.00
ATOM    211  HB3 ALA    31      -5.167  50.908   6.126  1.00  0.00
ATOM    212  C   ALA    31      -4.007  48.174   4.380  1.00  0.00
ATOM    213  O   ALA    31      -4.101  47.290   5.237  1.00  0.00
ATOM    214  N   GLU    32      -3.331  48.023   3.246  1.00  0.00
ATOM    215  HN  GLU    32      -3.321  48.760   2.599  1.00  0.00
ATOM    216  CA  GLU    32      -2.625  46.794   2.922  1.00  0.00
ATOM    217  HA  GLU    32      -3.248  45.965   3.234  1.00  0.00
ATOM    218  CB  GLU    32      -2.386  46.686   1.408  1.00  0.00
ATOM    219  HB1 GLU    32      -1.814  47.543   1.083  1.00  0.00
ATOM    220  HB2 GLU    32      -3.342  46.691   0.903  1.00  0.00
ATOM    221  CG  GLU    32      -1.632  45.422   0.999  1.00  0.00
ATOM    222  HG1 GLU    32      -2.172  44.560   1.369  1.00  0.00
ATOM    223  HG2 GLU    32      -0.650  45.445   1.449  1.00  0.00
ATOM    224  CD  GLU    32      -1.467  45.287  -0.506  1.00  0.00
ATOM    225  OE1 GLU    32      -0.618  46.002  -1.079  1.00  0.00
ATOM    226  OE2 GLU    32      -2.171  44.448  -1.114  1.00  0.00
ATOM    227  C   GLU    32      -1.300  46.719   3.673  1.00  0.00
ATOM    228  O   GLU    32      -0.357  47.459   3.381  1.00  0.00
ATOM    229  N   HIS    33      -1.263  45.852   4.668  1.00  0.00
ATOM    230  HN  HIS    33      -2.089  45.388   4.911  1.00  0.00
ATOM    231  CA  HIS    33      -0.045  45.545   5.406  1.00  0.00
ATOM    232  HA  HIS    33       0.685  46.317   5.196  1.00  0.00
ATOM    233  CB  HIS    33      -0.317  45.503   6.914  1.00  0.00
ATOM    234  HB1 HIS    33       0.590  45.218   7.429  1.00  0.00
ATOM    235  HB2 HIS    33      -1.084  44.767   7.119  1.00  0.00
ATOM    236  CG  HIS    33      -0.772  46.815   7.476  1.00  0.00
ATOM    237  ND1 HIS    33       0.097  47.768   7.958  1.00  0.00
ATOM    238  HD1 HIS    33       1.077  47.689   7.991  1.00  0.00
ATOM    239  CD2 HIS    33      -2.014  47.330   7.633  1.00  0.00
ATOM    240  HD2 HIS    33      -2.944  46.851   7.362  1.00  0.00
ATOM    241  CE1 HIS    33      -0.589  48.809   8.385  1.00  0.00
ATOM    242  HE1 HIS    33      -0.169  49.705   8.818  1.00  0.00
ATOM    243  NE2 HIS    33      -1.873  48.572   8.199  1.00  0.00
ATOM    244  HE2 HIS    33      -2.599  49.075   8.631  1.00  0.00
ATOM    245  C   HIS    33       0.506  44.203   4.940  1.00  0.00
ATOM    246  O   HIS    33      -0.225  43.393   4.365  1.00  0.00
ATOM    247  N   ALA    34       1.782  43.964   5.214  1.00  0.00
ATOM    248  HN  ALA    34       2.282  44.621   5.746  1.00  0.00
ATOM    249  CA  ALA    34       2.468  42.759   4.751  1.00  0.00
ATOM    250  HA  ALA    34       2.479  42.779   3.670  1.00  0.00
ATOM    251  CB  ALA    34       3.914  42.763   5.235  1.00  0.00
ATOM    252  HB1 ALA    34       4.434  41.909   4.826  1.00  0.00
ATOM    253  HB2 ALA    34       3.936  42.714   6.315  1.00  0.00
ATOM    254  HB3 ALA    34       4.401  43.670   4.907  1.00  0.00
ATOM    255  C   ALA    34       1.761  41.481   5.206  1.00  0.00
ATOM    256  O   ALA    34       1.850  40.444   4.543  1.00  0.00
ATOM    257  N   ASP    35       1.049  41.561   6.329  1.00  0.00
ATOM    258  HN  ASP    35       0.954  42.428   6.773  1.00  0.00
ATOM    259  CA  ASP    35       0.416  40.383   6.923  1.00  0.00
ATOM    260  HA  ASP    35       0.770  39.510   6.392  1.00  0.00
ATOM    261  CB  ASP    35       0.816  40.251   8.399  1.00  0.00
ATOM    262  HB1 ASP    35       1.883  40.394   8.487  1.00  0.00
ATOM    263  HB2 ASP    35       0.565  39.258   8.747  1.00  0.00
ATOM    264  CG  ASP    35       0.122  41.266   9.293  1.00  0.00
ATOM    265  OD1 ASP    35       0.449  42.468   9.202  1.00  0.00
ATOM    266  OD2 ASP    35      -0.746  40.867  10.097  1.00  0.00
ATOM    267  C   ASP    35      -1.111  40.429   6.812  1.00  0.00
ATOM    268  O   ASP    35      -1.773  39.400   6.966  1.00  0.00
ATOM    269  N   ARG    36      -1.682  41.598   6.521  1.00  0.00
ATOM    270  HN  ARG    36      -1.122  42.366   6.270  1.00  0.00
ATOM    271  CA  ARG    36      -3.142  41.736   6.533  1.00  0.00
ATOM    272  HA  ARG    36      -3.550  40.949   5.917  1.00  0.00
ATOM    273  CB  ARG    36      -3.678  41.570   7.966  1.00  0.00
ATOM    274  HB1 ARG    36      -3.315  40.633   8.368  1.00  0.00
ATOM    275  HB2 ARG    36      -4.759  41.538   7.933  1.00  0.00
ATOM    276  CG  ARG    36      -3.264  42.690   8.914  1.00  0.00
ATOM    277  HG1 ARG    36      -3.731  43.611   8.594  1.00  0.00
ATOM    278  HG2 ARG    36      -2.190  42.797   8.873  1.00  0.00
ATOM    279  CD  ARG    36      -3.677  42.398  10.353  1.00  0.00
ATOM    280  HD1 ARG    36      -3.114  41.546  10.712  1.00  0.00
ATOM    281  HD2 ARG    36      -4.732  42.162  10.370  1.00  0.00
ATOM    282  NE  ARG    36      -3.436  43.539  11.239  1.00  0.00
ATOM    283  HE  ARG    36      -4.165  44.194  11.330  1.00  0.00
ATOM    284  CZ  ARG    36      -2.321  43.724  11.948  1.00  0.00
ATOM    285  NH1 ARG    36      -1.289  42.903  11.808  1.00  0.00
ATOM    286 HH11 ARG    36      -1.337  42.131  11.163  1.00  0.00
ATOM    287 HH12 ARG    36      -0.455  43.046  12.347  1.00  0.00
ATOM    288  NH2 ARG    36      -2.225  44.752  12.777  1.00  0.00
ATOM    289 HH21 ARG    36      -2.992  45.396  12.878  1.00  0.00
ATOM    290 HH22 ARG    36      -1.390  44.887  13.317  1.00  0.00
ATOM    291  C   ARG    36      -3.592  43.080   5.962  1.00  0.00
ATOM    292  O   ARG    36      -2.805  43.816   5.384  1.00  0.00
ATOM    293  N   TYR    37      -4.876  43.366   6.135  1.00  0.00
ATOM    294  HN  TYR    37      -5.429  42.719   6.609  1.00  0.00
ATOM    295  CA  TYR    37      -5.508  44.603   5.686  1.00  0.00
ATOM    296  HA  TYR    37      -4.743  45.306   5.387  1.00  0.00
ATOM    297  CB  TYR    37      -6.477  44.347   4.519  1.00  0.00
ATOM    298  HB1 TYR    37      -6.833  45.302   4.155  1.00  0.00
ATOM    299  HB2 TYR    37      -7.322  43.784   4.887  1.00  0.00
ATOM    300  CG  TYR    37      -5.912  43.586   3.333  1.00  0.00
ATOM    301  CD1 TYR    37      -5.992  42.198   3.273  1.00  0.00
ATOM    302  HD1 TYR    37      -6.438  41.661   4.097  1.00  0.00
ATOM    303  CD2 TYR    37      -5.335  44.256   2.258  1.00  0.00
ATOM    304  HD2 TYR    37      -5.265  45.334   2.286  1.00  0.00
ATOM    305  CE1 TYR    37      -5.512  41.502   2.183  1.00  0.00
ATOM    306  HE1 TYR    37      -5.586  40.425   2.155  1.00  0.00
ATOM    307  CE2 TYR    37      -4.849  43.564   1.166  1.00  0.00
ATOM    308  HE2 TYR    37      -4.402  44.101   0.342  1.00  0.00
ATOM    309  CZ  TYR    37      -4.942  42.190   1.133  1.00  0.00
ATOM    310  OH  TYR    37      -4.459  41.497   0.046  1.00  0.00
ATOM    311  HH  TYR    37      -5.120  40.864  -0.251  1.00  0.00
ATOM    312  C   TYR    37      -6.322  45.182   6.841  1.00  0.00
ATOM    313  O   TYR    37      -6.679  44.453   7.767  1.00  0.00
ATOM    314  N   SER    38      -6.636  46.471   6.777  1.00  0.00
ATOM    315  HN  SER    38      -6.247  47.026   6.068  1.00  0.00
ATOM    316  CA  SER    38      -7.535  47.084   7.751  1.00  0.00
ATOM    317  HA  SER    38      -8.327  46.375   7.956  1.00  0.00
ATOM    318  CB  SER    38      -6.797  47.393   9.060  1.00  0.00
ATOM    319  HB1 SER    38      -6.130  48.229   8.911  1.00  0.00
ATOM    320  HB2 SER    38      -6.225  46.527   9.362  1.00  0.00
ATOM    321  OG  SER    38      -7.714  47.715  10.094  1.00  0.00
ATOM    322  HG  SER    38      -8.082  46.897  10.459  1.00  0.00
ATOM    323  C   SER    38      -8.166  48.351   7.170  1.00  0.00
ATOM    324  O   SER    38      -7.687  48.894   6.172  1.00  0.00
ATOM    325  N   CYS    39      -9.256  48.806   7.780  1.00  0.00
ATOM    326  HN  CYS    39      -9.589  48.331   8.573  1.00  0.00
ATOM    327  CA  CYS    39      -9.980  49.978   7.296  1.00  0.00
ATOM    328  HA  CYS    39      -9.347  50.504   6.596  1.00  0.00
ATOM    329  HB1 CYS    39     -11.825  48.903   7.229  1.00  0.00
ATOM    330  HB2 CYS    39     -10.986  48.989   5.693  1.00  0.00
ATOM    331  C   CYS    39     -10.341  50.922   8.431  1.00  0.00
ATOM    332  O   CYS    39     -11.402  50.776   9.049  1.00  0.00
ATOM    333  CB  CYS    39     -11.253  49.545   6.574  1.00  0.00
ATOM    334  SG  CYS    39     -12.344  50.914   6.050  1.00  0.00
ATOM    335  N   GLY    40      -9.454  51.877   8.706  1.00  0.00
ATOM    336  HN  GLY    40      -8.584  51.868   8.253  1.00  0.00
ATOM    337  CA  GLY    40      -9.742  52.916   9.678  1.00  0.00
ATOM    338  HA1 GLY    40      -8.854  53.512   9.830  1.00  0.00
ATOM    339  HA2 GLY    40     -10.020  52.456  10.616  1.00  0.00
ATOM    340  C   GLY    40     -10.870  53.818   9.213  1.00  0.00
ATOM    341  O   GLY    40     -10.634  54.923   8.718  1.00  0.00
ATOM    342  N   ARG    41     -12.095  53.327   9.360  1.00  0.00
ATOM    343  HN  ARG    41     -12.200  52.466   9.822  1.00  0.00
ATOM    344  CA  ARG    41     -13.289  54.031   8.907  1.00  0.00
ATOM    345  HA  ARG    41     -13.318  54.990   9.406  1.00  0.00
ATOM    346  CB  ARG    41     -13.252  54.250   7.384  1.00  0.00
ATOM    347  HB1 ARG    41     -13.317  53.288   6.892  1.00  0.00
ATOM    348  HB2 ARG    41     -12.308  54.710   7.123  1.00  0.00
ATOM    349  CG  ARG    41     -14.378  55.137   6.858  1.00  0.00
ATOM    350  HG1 ARG    41     -15.326  54.721   7.169  1.00  0.00
ATOM    351  HG2 ARG    41     -14.332  55.156   5.778  1.00  0.00
ATOM    352  CD  ARG    41     -14.270  56.568   7.379  1.00  0.00
ATOM    353  HD1 ARG    41     -13.379  57.024   6.966  1.00  0.00
ATOM    354  HD2 ARG    41     -14.193  56.542   8.456  1.00  0.00
ATOM    355  NE  ARG    41     -15.434  57.375   7.008  1.00  0.00
ATOM    356  HE  ARG    41     -16.316  57.040   7.290  1.00  0.00
ATOM    357  CZ  ARG    41     -15.372  58.529   6.339  1.00  0.00
ATOM    358  NH1 ARG    41     -14.206  59.004   5.921  1.00  0.00
ATOM    359 HH11 ARG    41     -13.359  58.498   6.105  1.00  0.00
ATOM    360 HH12 ARG    41     -14.164  59.872   5.417  1.00  0.00
ATOM    361  NH2 ARG    41     -16.485  59.200   6.077  1.00  0.00
ATOM    362 HH21 ARG    41     -17.372  58.843   6.382  1.00  0.00
ATOM    363 HH22 ARG    41     -16.447  60.068   5.571  1.00  0.00
ATOM    364  C   ARG    41     -14.536  53.232   9.294  1.00  0.00
ATOM    365  O   ARG    41     -15.460  53.767   9.905  1.00  0.00
ATOM    366  N   CYS    42     -14.550  51.941   8.946  1.00  0.00
ATOM    367  HN  CYS    42     -13.788  51.572   8.462  1.00  0.00
ATOM    368  CA  CYS    42     -15.680  51.066   9.290  1.00  0.00
ATOM    369  HA  CYS    42     -16.324  51.612   9.967  1.00  0.00
ATOM    370  HB1 CYS    42     -16.667  51.558   7.443  1.00  0.00
ATOM    371  HB2 CYS    42     -17.452  50.281   8.357  1.00  0.00
ATOM    372  C   CYS    42     -15.190  49.810  10.010  1.00  0.00
ATOM    373  O   CYS    42     -15.972  48.902  10.291  1.00  0.00
ATOM    374  CB  CYS    42     -16.497  50.676   8.042  1.00  0.00
ATOM    375  SG  CYS    42     -15.721  49.422   6.967  1.00  0.00
ATOM    376  N   GLY    43     -13.886  49.755  10.293  1.00  0.00
ATOM    377  HN  GLY    43     -13.292  50.472   9.984  1.00  0.00
ATOM    378  CA  GLY    43     -13.333  48.655  11.068  1.00  0.00
ATOM    379  HA1 GLY    43     -13.985  48.453  11.906  1.00  0.00
ATOM    380  HA2 GLY    43     -12.365  48.951  11.446  1.00  0.00
ATOM    381  C   GLY    43     -13.167  47.383  10.264  1.00  0.00
ATOM    382  O   GLY    43     -12.919  46.319  10.828  1.00  0.00
ATOM    383  N   TYR    44     -13.292  47.490   8.943  1.00  0.00
ATOM    384  HN  TYR    44     -13.474  48.365   8.552  1.00  0.00
ATOM    385  CA  TYR    44     -13.151  46.329   8.071  1.00  0.00
ATOM    386  HA  TYR    44     -13.761  45.533   8.480  1.00  0.00
ATOM    387  CB  TYR    44     -13.634  46.650   6.644  1.00  0.00
ATOM    388  HB1 TYR    44     -12.949  47.348   6.181  1.00  0.00
ATOM    389  HB2 TYR    44     -14.613  47.103   6.698  1.00  0.00
ATOM    390  CG  TYR    44     -13.736  45.430   5.742  1.00  0.00
ATOM    391  CD1 TYR    44     -14.898  44.664   5.711  1.00  0.00
ATOM    392  HD1 TYR    44     -15.731  44.949   6.336  1.00  0.00
ATOM    393  CD2 TYR    44     -12.675  45.043   4.926  1.00  0.00
ATOM    394  HD2 TYR    44     -11.765  45.625   4.936  1.00  0.00
ATOM    395  CE1 TYR    44     -14.999  43.553   4.896  1.00  0.00
ATOM    396  HE1 TYR    44     -15.910  42.972   4.888  1.00  0.00
ATOM    397  CE2 TYR    44     -12.772  43.932   4.110  1.00  0.00
ATOM    398  HE2 TYR    44     -11.937  43.647   3.485  1.00  0.00
ATOM    399  CZ  TYR    44     -13.935  43.191   4.098  1.00  0.00
ATOM    400  OH  TYR    44     -14.035  42.084   3.285  1.00  0.00
ATOM    401  HH  TYR    44     -13.267  41.512   3.421  1.00  0.00
ATOM    402  C   TYR    44     -11.692  45.874   8.052  1.00  0.00
ATOM    403  O   TYR    44     -10.820  46.586   7.541  1.00  0.00
ATOM    404  N   THR    45     -11.440  44.710   8.635  1.00  0.00
ATOM    405  HN  THR    45     -12.181  44.224   9.056  1.00  0.00
ATOM    406  CA  THR    45     -10.111  44.123   8.690  1.00  0.00
ATOM    407  HA  THR    45      -9.436  44.742   8.108  1.00  0.00
ATOM    408  CB  THR    45      -9.598  44.072  10.151  1.00  0.00
ATOM    409  HB  THR    45     -10.307  43.509  10.743  1.00  0.00
ATOM    410  OG1 THR    45      -9.513  45.405  10.682  1.00  0.00
ATOM    411  HG1 THR    45     -10.178  45.513  11.373  1.00  0.00
ATOM    412  CG2 THR    45      -8.233  43.392  10.251  1.00  0.00
ATOM    413 HG21 THR    45      -7.903  43.395  11.280  1.00  0.00
ATOM    414 HG22 THR    45      -7.517  43.926   9.643  1.00  0.00
ATOM    415 HG23 THR    45      -8.311  42.372   9.903  1.00  0.00
ATOM    416  C   THR    45     -10.144  42.717   8.091  1.00  0.00
ATOM    417  O   THR    45     -11.064  41.940   8.359  1.00  0.00
ATOM    418  N   GLU    46      -9.150  42.411   7.270  1.00  0.00
ATOM    419  HN  GLU    46      -8.432  43.068   7.132  1.00  0.00
ATOM    420  CA  GLU    46      -9.061  41.127   6.581  1.00  0.00
ATOM    421  HA  GLU    46      -9.638  40.397   7.131  1.00  0.00
ATOM    422  CB  GLU    46      -9.617  41.256   5.152  1.00  0.00
ATOM    423  HB1 GLU    46      -9.027  41.987   4.614  1.00  0.00
ATOM    424  HB2 GLU    46     -10.638  41.607   5.206  1.00  0.00
ATOM    425  CG  GLU    46      -9.603  39.953   4.359  1.00  0.00
ATOM    426  HG1 GLU    46      -8.586  39.589   4.310  1.00  0.00
ATOM    427  HG2 GLU    46      -9.958  40.150   3.356  1.00  0.00
ATOM    428  CD  GLU    46     -10.477  38.876   4.981  1.00  0.00
ATOM    429  OE1 GLU    46      -9.978  38.115   5.835  1.00  0.00
ATOM    430  OE2 GLU    46     -11.665  38.779   4.610  1.00  0.00
ATOM    431  C   GLU    46      -7.603  40.695   6.546  1.00  0.00
ATOM    432  O   GLU    46      -6.725  41.538   6.470  1.00  0.00
ATOM    433  N   PHE    47      -7.333  39.399   6.601  1.00  0.00
ATOM    434  HN  PHE    47      -8.072  38.749   6.586  1.00  0.00
ATOM    435  CA  PHE    47      -5.950  38.917   6.656  1.00  0.00
ATOM    436  HA  PHE    47      -5.338  39.722   7.041  1.00  0.00
ATOM    437  CB  PHE    47      -5.833  37.719   7.606  1.00  0.00
ATOM    438  HB1 PHE    47      -4.848  37.284   7.507  1.00  0.00
ATOM    439  HB2 PHE    47      -6.574  36.980   7.337  1.00  0.00
ATOM    440  CG  PHE    47      -6.037  38.084   9.055  1.00  0.00
ATOM    441  CD1 PHE    47      -7.275  37.931   9.663  1.00  0.00
ATOM    442  HD1 PHE    47      -8.103  37.536   9.090  1.00  0.00
ATOM    443  CD2 PHE    47      -4.984  38.591   9.806  1.00  0.00
ATOM    444  HD2 PHE    47      -4.014  38.715   9.342  1.00  0.00
ATOM    445  CE1 PHE    47      -7.457  38.275  10.989  1.00  0.00
ATOM    446  HE1 PHE    47      -8.426  38.151  11.451  1.00  0.00
ATOM    447  CE2 PHE    47      -5.163  38.934  11.133  1.00  0.00
ATOM    448  HE2 PHE    47      -4.336  39.325  11.707  1.00  0.00
ATOM    449  CZ  PHE    47      -6.400  38.776  11.724  1.00  0.00
ATOM    450  HZ  PHE    47      -6.542  39.045  12.761  1.00  0.00
ATOM    451  C   PHE    47      -5.431  38.540   5.273  1.00  0.00
ATOM    452  O   PHE    47      -6.207  38.197   4.380  1.00  0.00
ATOM    453  N   LYS    48      -4.109  38.631   5.098  1.00  0.00
ATOM    454  HN  LYS    48      -3.558  39.035   5.806  1.00  0.00
ATOM    455  CA  LYS    48      -3.461  38.123   3.891  1.00  0.00
ATOM    456  HA  LYS    48      -3.984  38.527   3.032  1.00  0.00
ATOM    457  CB  LYS    48      -1.979  38.548   3.833  1.00  0.00
ATOM    458  HB1 LYS    48      -1.467  37.928   3.110  1.00  0.00
ATOM    459  HB2 LYS    48      -1.536  38.381   4.805  1.00  0.00
ATOM    460  CG  LYS    48      -1.748  40.015   3.454  1.00  0.00
ATOM    461  HG1 LYS    48      -0.734  40.287   3.714  1.00  0.00
ATOM    462  HG2 LYS    48      -2.437  40.634   4.012  1.00  0.00
ATOM    463  CD  LYS    48      -1.962  40.267   1.960  1.00  0.00
ATOM    464  HD1 LYS    48      -3.004  40.099   1.722  1.00  0.00
ATOM    465  HD2 LYS    48      -1.349  39.578   1.398  1.00  0.00
ATOM    466  CE  LYS    48      -1.588  41.694   1.562  1.00  0.00
ATOM    467  HE1 LYS    48      -0.547  41.862   1.800  1.00  0.00
ATOM    468  HE2 LYS    48      -2.200  42.386   2.122  1.00  0.00
ATOM    469  NZ  LYS    48      -1.795  41.935   0.107  1.00  0.00
ATOM    470  HZ1 LYS    48      -1.136  41.354  -0.450  1.00  0.00
ATOM    471  HZ2 LYS    48      -1.634  42.936  -0.124  1.00  0.00
ATOM    472  HZ3 LYS    48      -2.767  41.683  -0.163  1.00  0.00
ATOM    473  C   LYS    48      -3.585  36.600   3.875  1.00  0.00
ATOM    474  O   LYS    48      -2.753  35.890   4.447  1.00  0.00
END
