
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  150 ( 1211),  selected  150 , name 2p1a_B
# Molecule2: number of CA atoms  144 ( 1145),  selected  144 , name T0481.pdb
# PARAMETERS: 2p1a_B.T0481.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     0_B      -       -           -
LGA    X     1_B      -       -           -
LGA    F     2_B      -       -           -
LGA    V     3_B      -       -           -
LGA    Q     4_B      N       5          2.936
LGA    S     5_B      Q       6          2.727
LGA    A     6_B      I       7          3.420
LGA    L     7_B      V       8          2.691
LGA    H     8_B      S       9          1.641
LGA    Q     9_B      H      10          1.870
LGA    L    10_B      F      11          1.006
LGA    K    11_B      L      12          0.620
LGA    V    12_B      S      13          1.075
LGA    A    13_B      H      14          1.159
LGA    V    14_B      R      15          1.317
LGA    D    15_B      N      16          1.036
LGA    T    16_B      V      17          1.152
LGA    S    17_B      T      18          1.282
LGA    I    18_B      N      19          1.470
LGA    Q    19_B      E      20          1.456
LGA    X    20_B      L      21          1.551
LGA    L    21_B      A      22          1.740
LGA    D    22_B      E      23          1.882
LGA    Q    23_B      K      24          2.036
LGA    Y    24_B      I      25          2.347
LGA    T    25_B      S      26          1.520
LGA    E    26_B      K      27          1.872
LGA    I    27_B      D      28          1.536
LGA    D    28_B      H      29          1.961
LGA    L    29_B      Y      30          2.679
LGA    K    30_B      S      31          2.046
LGA    I    31_B      Y      32          3.926
LGA    A    32_B      K      33          4.759
LGA    P    33_B      P      34          4.709
LGA    I    34_B      A      35          3.542
LGA    Q    35_B      E      36          2.392
LGA    S    36_B      T      37          2.613
LGA    K    37_B      S      38          4.406
LGA    R    38_B      M      39          2.671
LGA    S    39_B      S      40          0.720
LGA    L    40_B      A      41          0.619
LGA    F    41_B      E      42          1.144
LGA    E    42_B      E      43          1.306
LGA    X    43_B      L      44          0.904
LGA    Y    44_B      V      45          0.685
LGA    A    45_B      K      46          1.406
LGA    H    46_B      H      47          1.372
LGA    L    47_B      I      48          1.320
LGA    S    48_B      L      49          1.760
LGA    L    49_B      T      50          1.572
LGA    I    50_B      S      51          2.769
LGA    C    51_B      F      52          2.985
LGA    H    52_B      H      53          1.693
LGA    A    53_B      L      54          1.107
LGA    D    54_B      F      55          1.029
LGA    L    55_B      A      56          1.868
LGA    L    56_B      N      57          2.655
LGA    I    57_B      V      58          2.825
LGA    L    58_B      I      59          2.800
LGA    -       -      K      60           -
LGA    -       -      E      61           -
LGA    N    59_B      G      62          3.770
LGA    G    60_B      N      63          1.786
LGA    S    61_B      A      64          3.543
LGA    -       -      S      65           -
LGA    T    62_B      P      66           #
LGA    E    63_B      F      67          4.008
LGA    K    64_B      Q      68          4.182
LGA    E    65_B      N      69          3.218
LGA    L    66_B      -       -           -
LGA    H    67_B      -       -           -
LGA    T    68_B      K      70          2.602
LGA    F    69_B      Q      71          3.074
LGA    Y    70_B      -       -           -
LGA    K    71_B      -       -           -
LGA    E    72_B      E      72          1.858
LGA    Q    73_B      E      73          2.309
LGA    T    74_B      T      74           #
LGA    P    75_B      E      75          4.513
LGA    E    76_B      T      76          1.358
LGA    T    77_B      D      77          0.985
LGA    I    78_B      L      78          1.947
LGA    A    79_B      N      79          3.140
LGA    Q    80_B      V      80          2.362
LGA    X    81_B      L      81          1.612
LGA    Q    82_B      A      82          2.203
LGA    K    83_B      K      83          2.422
LGA    T    84_B      T      84          2.392
LGA    X    85_B      Y      85          2.671
LGA    I    86_B      T      86          1.989
LGA    Q    87_B      E      87          1.919
LGA    G    88_B      K      88          2.739
LGA    Y    89_B      T      89          2.651
LGA    D    90_B      V      90          1.972
LGA    L    91_B      A      91          2.438
LGA    L    92_B      I      92          2.705
LGA    S    93_B      L      93          1.826
LGA    K    94_B      E      94          2.067
LGA    T    95_B      Q      95          2.621
LGA    F    96_B      L      96          1.817
LGA    L    97_B      -       -           -
LGA    S    98_B      -       -           -
LGA    Y    99_B      T      97          0.775
LGA    S   100_B      E      98          3.557
LGA    N   101_B      -       -           -
LGA    E   102_B      E      99          3.640
LGA    Q   103_B      Q     100          3.564
LGA    L   104_B      L     101          2.546
LGA    A   105_B      D     102          1.358
LGA    E   106_B      R     103          0.847
LGA    X   107_B      E     104          0.742
LGA    K   108_B      I     105          0.764
LGA    T   109_B      D     106          2.271
LGA    A   110_B      L     107          3.191
LGA    Y   111_B      -       -           -
LGA    W   112_B      -       -           -
LGA    G   113_B      -       -           -
LGA    I   114_B      T     108           #
LGA    S   115_B      K     114          1.894
LGA    Y   116_B      V     115          1.877
LGA    S   117_B      T     116          1.639
LGA    R   118_B      G     117          1.622
LGA    F   119_B      R     118          1.762
LGA    E   120_B      A     119          1.804
LGA    W   121_B      L     120          1.777
LGA    L   122_B      L     121          1.618
LGA    L   123_B      Q     122          1.399
LGA    E   124_B      L     123          1.447
LGA    I   125_B      A     124          1.516
LGA    V   126_B      M     125          1.060
LGA    A   127_B      E     126          0.936
LGA    H   128_B      H     127          1.318
LGA    F   129_B      E     128          0.911
LGA    Y   130_B      I     129          0.742
LGA    H   131_B      H     130          1.124
LGA    H   132_B      H     131          1.407
LGA    R   133_B      K     132          1.111
LGA    G   134_B      G     133          1.015
LGA    Q   135_B      N     134          1.519
LGA    I   136_B      L     135          1.568
LGA    H   137_B      F     136          1.499
LGA    I   138_B      V     137          1.986
LGA    L   139_B      Y     138          2.599
LGA    L   140_B      V     139          2.445
LGA    C   141_B      R     140          2.393
LGA    E   142_B      E     141          3.808
LGA    H   143_B      M     142          5.063
LGA    X   144_B      G     143          4.179
LGA    K   145_B      H     144          2.588
LGA    D   146_B      T     145          3.504
LGA    P   147_B      E     146          4.755
LGA    N   148_B      L     147          1.293
LGA    I   149_B      P     148          1.667
LGA    -       -      F     149           -
LGA    -       -      Y     150           -
LGA    -       -      Q     151           -
LGA    -       -      Q     152           -
LGA    -       -      R     153           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  150  144    5.0    133    2.35    12.78     63.870     5.419

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.262086 * X  +  -0.878688 * Y  +   0.399021 * Z  +  33.546368
  Y_new =  -0.557430 * X  +   0.199682 * Y  +   0.805853 * Z  +   4.429852
  Z_new =  -0.787771 * X  +  -0.433629 * Y  +  -0.437474 * Z  +  93.671753 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.360608    0.780984  [ DEG:  -135.2529     44.7471 ]
  Theta =   0.907181    2.234411  [ DEG:    51.9777    128.0223 ]
  Phi   =  -1.131298    2.010294  [ DEG:   -64.8186    115.1814 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2p1a_B                                        
REMARK     2: T0481.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2p1a_B.T0481.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  150  144   5.0  133   2.35   12.78  63.870
REMARK  ---------------------------------------------------------- 
MOLECULE 2p1a_B
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   02-MAR-07   2P1A              
TITLE     CRYSTAL STRUCTURE OF PUTATIVE DNA-BINDING PROTEIN FROM                
TITLE    2 BACILLUS CEREUS ATCC 10987 AT 2.10 A RESOLUTION                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN;                                      
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS CEREUS ATCC 10987;                     
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: NP_978475.1, BCE_2162;                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    NP_978475.1, HYPOTHETICAL PROTEIN, STRUCTURAL GENOMICS,               
KEYWDS   2 JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG, PROTEIN                  
KEYWDS   3 STRUCTURE INITIATIVE, PSI-2                                          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   20-MAR-07 2P1A    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF HYPOTHETICAL PROTEIN                    
JRNL        TITL 2 (NP_978475.1) FROM BACILLUS CEREUS ATCC 10987 AT             
JRNL        TITL 3 2.10 A RESOLUTION                                            
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.10 ANGSTROMS.                                          
DBREF  2P1A A    1   153  UNP    Q739H9   Q739H9_BACC1     1    153             
DBREF  2P1A B    1   153  UNP    Q739H9   Q739H9_BACC1     1    153             
SEQRES   1 A  154  GLY MSE PHE VAL GLN SER ALA LEU HIS GLN LEU LYS VAL          
SEQRES   2 A  154  ALA VAL ASP THR SER ILE GLN MSE LEU ASP GLN TYR THR          
SEQRES   3 A  154  GLU ILE ASP LEU LYS ILE ALA PRO ILE GLN SER LYS ARG          
SEQRES   4 A  154  SER LEU PHE GLU MSE TYR ALA HIS LEU SER LEU ILE CYS          
SEQRES   5 A  154  HIS ALA ASP LEU LEU ILE LEU ASN GLY SER THR GLU LYS          
SEQRES   6 A  154  GLU LEU HIS THR PHE TYR LYS GLU GLN THR PRO GLU THR          
SEQRES   7 A  154  ILE ALA GLN MSE GLN LYS THR MSE ILE GLN GLY TYR ASP          
SEQRES   8 A  154  LEU LEU SER LYS THR PHE LEU SER TYR SER ASN GLU GLN          
SEQRES   9 A  154  LEU ALA GLU MSE LYS THR ALA TYR TRP GLY ILE SER TYR          
SEQRES  10 A  154  SER ARG PHE GLU TRP LEU LEU GLU ILE VAL ALA HIS PHE          
SEQRES  11 A  154  TYR HIS HIS ARG GLY GLN ILE HIS ILE LEU LEU CYS GLU          
SEQRES  12 A  154  HIS MSE LYS ASP PRO ASN ILE PRO LEU PHE GLN                  
SEQRES   1 B  154  GLY MSE PHE VAL GLN SER ALA LEU HIS GLN LEU LYS VAL          
SEQRES   2 B  154  ALA VAL ASP THR SER ILE GLN MSE LEU ASP GLN TYR THR          
SEQRES   3 B  154  GLU ILE ASP LEU LYS ILE ALA PRO ILE GLN SER LYS ARG          
SEQRES   4 B  154  SER LEU PHE GLU MSE TYR ALA HIS LEU SER LEU ILE CYS          
SEQRES   5 B  154  HIS ALA ASP LEU LEU ILE LEU ASN GLY SER THR GLU LYS          
SEQRES   6 B  154  GLU LEU HIS THR PHE TYR LYS GLU GLN THR PRO GLU THR          
SEQRES   7 B  154  ILE ALA GLN MSE GLN LYS THR MSE ILE GLN GLY TYR ASP          
SEQRES   8 B  154  LEU LEU SER LYS THR PHE LEU SER TYR SER ASN GLU GLN          
SEQRES   9 B  154  LEU ALA GLU MSE LYS THR ALA TYR TRP GLY ILE SER TYR          
SEQRES  10 B  154  SER ARG PHE GLU TRP LEU LEU GLU ILE VAL ALA HIS PHE          
SEQRES  11 B  154  TYR HIS HIS ARG GLY GLN ILE HIS ILE LEU LEU CYS GLU          
SEQRES  12 B  154  HIS MSE LYS ASP PRO ASN ILE PRO LEU PHE GLN                  
HET    MSE  A   1       8                                                       
HET    MSE  A  20       8                                                       
HET    MSE  A  43       8                                                       
HET    MSE  A  81       8                                                       
HET    MSE  A  85       8                                                       
HET    MSE  A 107       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  20       8                                                       
HET    MSE  B  43       8                                                       
HET    MSE  B  81       8                                                       
HET    MSE  B  85       8                                                       
HET    MSE  B 107       8                                                       
HET    MSE  B 144       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    13(C5 H11 N O2 SE)                                           
FORMUL   3  HOH   *98(H2 O)                                                     
CRYST1   45.470   77.820   87.070  90.00  90.00  90.00 P 21 21 21    8          
ATOM   1183  N   GLY B   0      43.596  42.939   7.442  1.00 69.09           N  
ATOM   1184  CA  GLY B   0      44.051  44.360   7.621  1.00 68.84           C  
ATOM   1185  C   GLY B   0      42.911  45.198   8.164  1.00 67.81           C  
ATOM   1186  O   GLY B   0      42.882  45.538   9.349  1.00 66.86           O  
HETATM 1187  N   MSE B   1      41.986  45.547   7.276  1.00 66.94           N  
HETATM 1188  CA  MSE B   1      40.747  46.240   7.644  1.00 68.35           C  
HETATM 1189  C   MSE B   1      39.818  45.262   8.385  1.00 58.70           C  
HETATM 1190  O   MSE B   1      39.107  45.647   9.303  1.00 57.11           O  
HETATM 1191  CB  MSE B   1      40.017  46.704   6.386  1.00 68.56           C  
HETATM 1192  CG  MSE B   1      38.769  47.567   6.627  1.00 76.84           C  
HETATM 1193 SE   MSE B   1      37.225  46.888   5.609  1.00 88.78          SE  
HETATM 1194  CE  MSE B   1      36.809  45.338   6.727  1.00 88.13           C  
ATOM   1195  N   PHE B   2      39.833  44.002   7.961  1.00 52.49           N  
ATOM   1196  CA  PHE B   2      38.996  42.950   8.531  1.00 48.04           C  
ATOM   1197  C   PHE B   2      39.520  42.526   9.912  1.00 45.80           C  
ATOM   1198  O   PHE B   2      38.735  42.285  10.829  1.00 45.38           O  
ATOM   1199  CB  PHE B   2      38.922  41.746   7.580  1.00 48.36           C  
ATOM   1200  CG  PHE B   2      38.433  42.095   6.195  1.00 48.73           C  
ATOM   1201  CD1 PHE B   2      37.072  42.123   5.903  1.00 50.16           C  
ATOM   1202  CD2 PHE B   2      39.341  42.405   5.176  1.00 51.84           C  
ATOM   1203  CE1 PHE B   2      36.612  42.465   4.619  1.00 51.36           C  
ATOM   1204  CE2 PHE B   2      38.903  42.738   3.885  1.00 50.59           C  
ATOM   1205  CZ  PHE B   2      37.531  42.769   3.608  1.00 54.16           C  
ATOM   1206  N   VAL B   3      40.845  42.416  10.038  1.00 43.07           N  
ATOM   1207  CA  VAL B   3      41.513  42.095  11.304  1.00 38.80           C  
ATOM   1208  C   VAL B   3      41.331  43.223  12.315  1.00 36.30           C  
ATOM   1209  O   VAL B   3      40.981  42.956  13.466  1.00 35.31           O  
ATOM   1210  CB  VAL B   3      43.029  41.726  11.095  1.00 39.18           C  
ATOM   1211  CG1 VAL B   3      43.823  41.749  12.406  1.00 34.31           C  
ATOM   1212  CG2 VAL B   3      43.147  40.363  10.416  1.00 33.61           C  
ATOM   1213  N   GLN B   4      41.553  44.472  11.899  1.00 35.58           N  
ATOM   1214  CA  GLN B   4      41.346  45.619  12.794  1.00 35.31           C  
ATOM   1215  C   GLN B   4      39.897  45.710  13.290  1.00 34.86           C  
ATOM   1216  O   GLN B   4      39.671  46.068  14.439  1.00 33.70           O  
ATOM   1217  CB  GLN B   4      41.797  46.953  12.159  1.00 36.45           C  
ATOM   1218  CG  GLN B   4      43.325  47.117  12.107  1.00 42.78           C  
ATOM   1219  N   SER B   5      38.931  45.374  12.426  1.00 35.86           N  
ATOM   1220  CA  SER B   5      37.506  45.362  12.780  1.00 35.61           C  
ATOM   1221  C   SER B   5      37.238  44.319  13.887  1.00 34.72           C  
ATOM   1222  O   SER B   5      36.583  44.637  14.885  1.00 33.76           O  
ATOM   1223  CB  SER B   5      36.625  45.085  11.543  1.00 36.50           C  
ATOM   1224  OG  SER B   5      36.711  46.128  10.571  1.00 40.04           O  
ATOM   1225  N   ALA B   6      37.776  43.109  13.704  1.00 35.51           N  
ATOM   1226  CA  ALA B   6      37.653  42.008  14.689  1.00 35.81           C  
ATOM   1227  C   ALA B   6      38.319  42.322  16.043  1.00 38.60           C  
ATOM   1228  O   ALA B   6      37.757  42.006  17.114  1.00 38.74           O  
ATOM   1229  CB  ALA B   6      38.211  40.718  14.124  1.00 34.61           C  
ATOM   1230  N   LEU B   7      39.515  42.917  15.998  1.00 39.94           N  
ATOM   1231  CA  LEU B   7      40.236  43.322  17.215  1.00 39.65           C  
ATOM   1232  C   LEU B   7      39.543  44.467  17.935  1.00 39.86           C  
ATOM   1233  O   LEU B   7      39.597  44.522  19.157  1.00 41.60           O  
ATOM   1234  CB  LEU B   7      41.711  43.680  16.922  1.00 39.50           C  
ATOM   1235  CG  LEU B   7      42.588  42.495  16.502  1.00 38.53           C  
ATOM   1236  CD1 LEU B   7      43.914  42.943  15.918  1.00 33.11           C  
ATOM   1237  CD2 LEU B   7      42.805  41.513  17.661  1.00 33.58           C  
ATOM   1238  N   HIS B   8      38.905  45.373  17.191  1.00 39.93           N  
ATOM   1239  CA  HIS B   8      38.186  46.502  17.782  1.00 40.39           C  
ATOM   1240  C   HIS B   8      36.948  46.031  18.543  1.00 39.44           C  
ATOM   1241  O   HIS B   8      36.651  46.550  19.604  1.00 39.55           O  
ATOM   1242  CB  HIS B   8      37.798  47.540  16.724  1.00 41.58           C  
ATOM   1243  CG  HIS B   8      37.202  48.779  17.312  1.00 47.22           C  
ATOM   1244  ND1 HIS B   8      35.850  49.044  17.299  1.00 45.35           N  
ATOM   1245  CD2 HIS B   8      37.780  49.798  17.990  1.00 54.77           C  
ATOM   1246  CE1 HIS B   8      35.626  50.189  17.919  1.00 52.49           C  
ATOM   1247  NE2 HIS B   8      36.781  50.668  18.347  1.00 55.18           N  
ATOM   1248  N   GLN B   9      36.222  45.067  17.985  1.00 40.71           N  
ATOM   1249  CA  GLN B   9      35.067  44.465  18.673  1.00 40.73           C  
ATOM   1250  C   GLN B   9      35.516  43.770  19.958  1.00 41.56           C  
ATOM   1251  O   GLN B   9      34.826  43.865  20.976  1.00 41.46           O  
ATOM   1252  CB  GLN B   9      34.270  43.503  17.754  1.00 40.54           C  
ATOM   1253  CG  GLN B   9      33.447  44.218  16.653  1.00 44.37           C  
ATOM   1254  CD  GLN B   9      32.338  45.125  17.197  1.00 43.69           C  
ATOM   1255  OE1 GLN B   9      32.233  46.318  16.847  1.00 42.49           O  
ATOM   1256  NE2 GLN B   9      31.538  44.576  18.085  1.00 42.63           N  
ATOM   1257  N   LEU B  10      36.674  43.100  19.908  1.00 42.76           N  
ATOM   1258  CA  LEU B  10      37.249  42.449  21.076  1.00 44.34           C  
ATOM   1259  C   LEU B  10      37.606  43.496  22.143  1.00 43.15           C  
ATOM   1260  O   LEU B  10      37.229  43.334  23.307  1.00 41.73           O  
ATOM   1261  CB  LEU B  10      38.481  41.614  20.702  1.00 44.96           C  
ATOM   1262  CG  LEU B  10      39.067  40.749  21.830  1.00 46.72           C  
ATOM   1263  CD1 LEU B  10      38.060  39.713  22.339  1.00 49.27           C  
ATOM   1264  CD2 LEU B  10      40.334  40.080  21.343  1.00 46.22           C  
ATOM   1265  N   LYS B  11      38.306  44.550  21.718  1.00 41.08           N  
ATOM   1266  CA  LYS B  11      38.700  45.679  22.566  1.00 41.51           C  
ATOM   1267  C   LYS B  11      37.492  46.396  23.187  1.00 41.42           C  
ATOM   1268  O   LYS B  11      37.570  46.811  24.332  1.00 42.83           O  
ATOM   1269  CB  LYS B  11      39.549  46.677  21.764  1.00 42.62           C  
ATOM   1270  CG  LYS B  11      40.153  47.879  22.533  1.00 44.98           C  
ATOM   1271  CD  LYS B  11      41.039  47.461  23.691  1.00 53.78           C  
ATOM   1272  CE  LYS B  11      41.796  48.642  24.292  1.00 56.75           C  
ATOM   1273  NZ  LYS B  11      42.529  48.223  25.533  1.00 62.49           N  
ATOM   1274  N   VAL B  12      36.392  46.538  22.443  1.00 40.32           N  
ATOM   1275  CA  VAL B  12      35.169  47.120  22.993  1.00 39.65           C  
ATOM   1276  C   VAL B  12      34.694  46.266  24.162  1.00 40.23           C  
ATOM   1277  O   VAL B  12      34.304  46.816  25.186  1.00 40.55           O  
ATOM   1278  CB  VAL B  12      34.035  47.268  21.948  1.00 40.28           C  
ATOM   1279  CG1 VAL B  12      32.697  47.591  22.626  1.00 37.07           C  
ATOM   1280  CG2 VAL B  12      34.389  48.360  20.949  1.00 39.62           C  
ATOM   1281  N   ALA B  13      34.741  44.937  23.992  1.00 39.34           N  
ATOM   1282  CA  ALA B  13      34.367  43.984  25.035  1.00 39.68           C  
ATOM   1283  C   ALA B  13      35.297  44.089  26.244  1.00 40.63           C  
ATOM   1284  O   ALA B  13      34.808  44.077  27.373  1.00 41.10           O  
ATOM   1285  CB  ALA B  13      34.348  42.548  24.488  1.00 39.35           C  
ATOM   1286  N   VAL B  14      36.608  44.225  25.994  1.00 41.63           N  
ATOM   1287  CA  VAL B  14      37.638  44.370  27.047  1.00 42.24           C  
ATOM   1288  C   VAL B  14      37.426  45.642  27.851  1.00 43.62           C  
ATOM   1289  O   VAL B  14      37.278  45.586  29.073  1.00 43.16           O  
ATOM   1290  CB  VAL B  14      39.088  44.359  26.460  1.00 41.96           C  
ATOM   1291  CG1 VAL B  14      40.136  44.847  27.479  1.00 40.47           C  
ATOM   1292  CG2 VAL B  14      39.445  42.970  25.956  1.00 43.40           C  
ATOM   1293  N   ASP B  15      37.390  46.779  27.155  1.00 45.48           N  
ATOM   1294  CA  ASP B  15      37.201  48.084  27.788  1.00 45.84           C  
ATOM   1295  C   ASP B  15      35.915  48.156  28.603  1.00 46.46           C  
ATOM   1296  O   ASP B  15      35.950  48.626  29.732  1.00 47.07           O  
ATOM   1297  CB  ASP B  15      37.227  49.223  26.751  1.00 46.46           C  
ATOM   1298  CG  ASP B  15      38.594  49.407  26.100  1.00 46.77           C  
ATOM   1299  OD1 ASP B  15      39.587  48.777  26.526  1.00 49.25           O  
ATOM   1300  OD2 ASP B  15      38.672  50.196  25.142  1.00 56.27           O  
ATOM   1301  N   THR B  16      34.804  47.676  28.037  1.00 46.72           N  
ATOM   1302  CA  THR B  16      33.513  47.677  28.736  1.00 46.80           C  
ATOM   1303  C   THR B  16      33.514  46.728  29.944  1.00 48.30           C  
ATOM   1304  O   THR B  16      32.899  47.041  30.964  1.00 50.25           O  
ATOM   1305  CB  THR B  16      32.330  47.331  27.816  1.00 46.64           C  
ATOM   1306  OG1 THR B  16      32.574  46.076  27.167  1.00 49.88           O  
ATOM   1307  CG2 THR B  16      32.102  48.428  26.787  1.00 40.71           C  
ATOM   1308  N   SER B  17      34.185  45.579  29.830  1.00 48.48           N  
ATOM   1309  CA  SER B  17      34.325  44.648  30.968  1.00 48.13           C  
ATOM   1310  C   SER B  17      35.140  45.263  32.104  1.00 49.32           C  
ATOM   1311  O   SER B  17      34.876  44.971  33.252  1.00 50.12           O  
ATOM   1312  CB  SER B  17      34.979  43.343  30.543  1.00 47.44           C  
ATOM   1313  OG  SER B  17      34.124  42.628  29.688  1.00 46.27           O  
ATOM   1314  N   ILE B  18      36.135  46.081  31.764  1.00 51.00           N  
ATOM   1315  CA  ILE B  18      36.982  46.799  32.734  1.00 52.18           C  
ATOM   1316  C   ILE B  18      36.197  47.898  33.452  1.00 53.52           C  
ATOM   1317  O   ILE B  18      36.377  48.093  34.652  1.00 54.93           O  
ATOM   1318  CB  ILE B  18      38.283  47.344  32.051  1.00 52.30           C  
ATOM   1319  CG1 ILE B  18      39.222  46.166  31.745  1.00 52.28           C  
ATOM   1320  CG2 ILE B  18      39.022  48.349  32.934  1.00 52.56           C  
ATOM   1321  CD1 ILE B  18      40.448  46.522  30.935  1.00 51.94           C  
ATOM   1322  N   GLN B  19      35.352  48.611  32.710  1.00 54.56           N  
ATOM   1323  CA  GLN B  19      34.477  49.640  33.270  1.00 57.06           C  
ATOM   1324  C   GLN B  19      33.378  49.022  34.133  1.00 57.91           C  
ATOM   1325  O   GLN B  19      33.039  49.568  35.186  1.00 58.79           O  
ATOM   1326  CB  GLN B  19      33.833  50.467  32.158  1.00 57.31           C  
ATOM   1327  CG  GLN B  19      34.825  51.341  31.398  1.00 61.03           C  
ATOM   1328  CD  GLN B  19      34.271  51.917  30.096  1.00 61.15           C  
ATOM   1329  OE1 GLN B  19      33.137  51.626  29.679  1.00 65.76           O  
ATOM   1330  NE2 GLN B  19      35.089  52.729  29.436  1.00 70.73           N  
HETATM 1331  N   MSE B  20      32.804  47.915  33.658  1.00 58.93           N  
HETATM 1332  CA  MSE B  20      31.778  47.156  34.394  1.00 59.71           C  
HETATM 1333  C   MSE B  20      32.357  46.613  35.721  1.00 59.03           C  
HETATM 1334  O   MSE B  20      31.681  46.639  36.752  1.00 59.48           O  
HETATM 1335  CB  MSE B  20      31.210  46.028  33.503  1.00 58.88           C  
HETATM 1336  CG  MSE B  20      30.139  45.135  34.143  1.00 60.64           C  
HETATM 1337 SE   MSE B  20      29.288  43.803  32.936  0.75 64.34          SE  
HETATM 1338  CE  MSE B  20      30.859  42.957  32.125  1.00 55.87           C  
ATOM   1339  N   LEU B  21      33.611  46.162  35.678  1.00 59.21           N  
ATOM   1340  CA  LEU B  21      34.334  45.625  36.845  1.00 59.48           C  
ATOM   1341  C   LEU B  21      34.590  46.682  37.941  1.00 61.08           C  
ATOM   1342  O   LEU B  21      34.636  46.329  39.123  1.00 62.40           O  
ATOM   1343  CB  LEU B  21      35.645  44.966  36.385  1.00 59.14           C  
ATOM   1344  CG  LEU B  21      36.498  44.084  37.285  1.00 59.55           C  
ATOM   1345  CD1 LEU B  21      35.695  42.934  37.888  1.00 53.64           C  
ATOM   1346  CD2 LEU B  21      37.680  43.551  36.468  1.00 57.38           C  
ATOM   1347  N   ASP B  22      34.750  47.955  37.554  1.00 60.66           N  
ATOM   1348  CA  ASP B  22      34.905  49.064  38.520  1.00 60.79           C  
ATOM   1349  C   ASP B  22      33.631  49.394  39.322  1.00 60.39           C  
ATOM   1350  O   ASP B  22      33.728  49.992  40.393  1.00 60.81           O  
ATOM   1351  CB  ASP B  22      35.418  50.342  37.833  1.00 60.92           C  
ATOM   1352  CG  ASP B  22      36.859  50.232  37.362  1.00 61.69           C  
ATOM   1353  OD1 ASP B  22      37.587  49.296  37.760  1.00 60.15           O  
ATOM   1354  OD2 ASP B  22      37.273  51.123  36.589  1.00 64.74           O  
ATOM   1355  N   GLN B  23      32.456  48.997  38.828  1.00 59.45           N  
ATOM   1356  CA  GLN B  23      31.189  49.212  39.551  1.00 59.81           C  
ATOM   1357  C   GLN B  23      30.966  48.228  40.718  1.00 58.28           C  
ATOM   1358  O   GLN B  23      29.962  48.351  41.431  1.00 57.45           O  
ATOM   1359  CB  GLN B  23      29.981  49.144  38.597  1.00 61.42           C  
ATOM   1360  CG  GLN B  23      30.098  49.987  37.312  1.00 67.41           C  
ATOM   1361  CD  GLN B  23      30.602  51.409  37.560  1.00 76.11           C  
ATOM   1362  OE1 GLN B  23      30.048  52.149  38.380  1.00 81.33           O  
ATOM   1363  NE2 GLN B  23      31.662  51.794  36.845  1.00 82.24           N  
ATOM   1364  N   TYR B  24      31.878  47.263  40.909  1.00 56.97           N  
ATOM   1365  CA  TYR B  24      31.804  46.269  41.986  1.00 56.69           C  
ATOM   1366  C   TYR B  24      33.147  46.170  42.685  1.00 55.60           C  
ATOM   1367  O   TYR B  24      34.163  46.620  42.157  1.00 55.46           O  
ATOM   1368  CB  TYR B  24      31.397  44.903  41.419  1.00 57.18           C  
ATOM   1369  CG  TYR B  24      30.153  45.006  40.574  1.00 60.35           C  
ATOM   1370  CD1 TYR B  24      28.878  44.977  41.154  1.00 61.97           C  
ATOM   1371  CD2 TYR B  24      30.247  45.213  39.194  1.00 61.23           C  
ATOM   1372  CE1 TYR B  24      27.723  45.119  40.368  1.00 60.55           C  
ATOM   1373  CE2 TYR B  24      29.104  45.362  38.400  1.00 60.39           C  
ATOM   1374  CZ  TYR B  24      27.850  45.311  38.998  1.00 59.09           C  
ATOM   1375  OH  TYR B  24      26.733  45.451  38.231  1.00 62.67           O  
ATOM   1376  N   THR B  25      33.125  45.616  43.891  1.00 55.00           N  
ATOM   1377  CA  THR B  25      34.318  45.389  44.699  1.00 55.41           C  
ATOM   1378  C   THR B  25      34.548  43.891  44.758  1.00 56.09           C  
ATOM   1379  O   THR B  25      33.667  43.105  44.408  1.00 54.42           O  
ATOM   1380  CB  THR B  25      34.148  45.913  46.136  1.00 55.78           C  
ATOM   1381  OG1 THR B  25      33.079  45.211  46.781  1.00 55.46           O  
ATOM   1382  CG2 THR B  25      33.847  47.407  46.145  1.00 55.78           C  
ATOM   1383  N   GLU B  26      35.737  43.508  45.217  1.00 58.25           N  
ATOM   1384  CA  GLU B  26      36.111  42.100  45.382  1.00 60.71           C  
ATOM   1385  C   GLU B  26      35.066  41.347  46.234  1.00 59.44           C  
ATOM   1386  O   GLU B  26      34.674  40.235  45.887  1.00 58.57           O  
ATOM   1387  CB  GLU B  26      37.533  42.007  45.978  1.00 60.71           C  
ATOM   1388  CG  GLU B  26      38.002  40.598  46.357  1.00 67.11           C  
ATOM   1389  CD  GLU B  26      39.482  40.508  46.736  1.00 67.59           C  
ATOM   1390  OE1 GLU B  26      40.325  41.252  46.170  1.00 79.29           O  
ATOM   1391  OE2 GLU B  26      39.802  39.648  47.587  1.00 76.43           O  
ATOM   1392  N   ILE B  27      34.587  41.991  47.303  1.00 59.10           N  
ATOM   1393  CA  ILE B  27      33.575  41.412  48.199  1.00 58.13           C  
ATOM   1394  C   ILE B  27      32.225  41.204  47.476  1.00 56.70           C  
ATOM   1395  O   ILE B  27      31.634  40.136  47.604  1.00 55.71           O  
ATOM   1396  CB  ILE B  27      33.409  42.235  49.539  1.00 59.20           C  
ATOM   1397  CG1 ILE B  27      34.585  42.001  50.507  1.00 60.36           C  
ATOM   1398  CG2 ILE B  27      32.135  41.827  50.298  1.00 56.23           C  
ATOM   1399  CD1 ILE B  27      35.939  42.509  50.064  1.00 64.18           C  
ATOM   1400  N   ASP B  28      31.761  42.205  46.717  1.00 55.29           N  
ATOM   1401  CA  ASP B  28      30.508  42.095  45.935  1.00 55.00           C  
ATOM   1402  C   ASP B  28      30.485  40.862  45.012  1.00 55.28           C  
ATOM   1403  O   ASP B  28      29.487  40.145  44.950  1.00 56.28           O  
ATOM   1404  CB  ASP B  28      30.272  43.324  45.028  1.00 55.68           C  
ATOM   1405  CG  ASP B  28      29.981  44.613  45.785  1.00 55.45           C  
ATOM   1406  OD1 ASP B  28      29.520  44.566  46.948  1.00 56.58           O  
ATOM   1407  OD2 ASP B  28      30.180  45.692  45.171  1.00 56.97           O  
ATOM   1408  N   LEU B  29      31.593  40.627  44.313  1.00 55.05           N  
ATOM   1409  CA  LEU B  29      31.708  39.519  43.348  1.00 54.91           C  
ATOM   1410  C   LEU B  29      31.816  38.135  44.019  1.00 55.25           C  
ATOM   1411  O   LEU B  29      31.205  37.172  43.550  1.00 54.14           O  
ATOM   1412  CB  LEU B  29      32.905  39.755  42.418  1.00 54.03           C  
ATOM   1413  CG  LEU B  29      32.913  41.055  41.613  1.00 51.12           C  
ATOM   1414  CD1 LEU B  29      34.254  41.195  40.907  1.00 50.39           C  
ATOM   1415  CD2 LEU B  29      31.735  41.118  40.636  1.00 46.03           C  
ATOM   1416  N   LYS B  30      32.604  38.058  45.093  1.00 56.60           N  
ATOM   1417  CA  LYS B  30      32.794  36.823  45.865  1.00 58.74           C  
ATOM   1418  C   LYS B  30      31.540  36.413  46.651  1.00 61.95           C  
ATOM   1419  O   LYS B  30      31.181  35.231  46.669  1.00 61.75           O  
ATOM   1420  CB  LYS B  30      33.990  36.949  46.823  1.00 58.05           C  
ATOM   1421  CG  LYS B  30      35.341  36.934  46.128  1.00 58.28           C  
ATOM   1422  CD  LYS B  30      36.488  37.062  47.121  1.00 57.38           C  
ATOM   1423  CE  LYS B  30      37.846  36.912  46.454  1.00 56.46           C  
ATOM   1424  NZ  LYS B  30      38.963  37.052  47.429  1.00 54.07           N  
ATOM   1425  N   ILE B  31      30.890  37.395  47.281  1.00 65.85           N  
ATOM   1426  CA  ILE B  31      29.677  37.185  48.101  1.00 69.57           C  
ATOM   1427  C   ILE B  31      28.346  36.986  47.337  1.00 70.61           C  
ATOM   1428  O   ILE B  31      27.454  36.328  47.881  1.00 70.96           O  
ATOM   1429  CB  ILE B  31      29.596  38.259  49.291  1.00 69.70           C  
ATOM   1430  CG1 ILE B  31      30.050  37.622  50.627  1.00 72.09           C  
ATOM   1431  CG2 ILE B  31      28.191  38.850  49.480  1.00 69.76           C  
ATOM   1432  CD1 ILE B  31      31.487  37.019  50.655  1.00 74.68           C  
ATOM   1433  N   ALA B  32      28.221  37.495  46.101  1.00 72.44           N  
ATOM   1434  CA  ALA B  32      26.974  37.367  45.287  1.00 73.78           C  
ATOM   1435  C   ALA B  32      26.443  35.910  45.248  1.00 75.64           C  
ATOM   1436  O   ALA B  32      27.249  35.001  45.029  1.00 76.66           O  
ATOM   1437  CB  ALA B  32      27.186  37.892  43.872  1.00 72.63           C  
ATOM   1438  N   PRO B  33      25.116  35.684  45.494  1.00 77.12           N  
ATOM   1439  CA  PRO B  33      24.531  34.314  45.605  1.00 78.34           C  
ATOM   1440  C   PRO B  33      24.679  33.366  44.390  1.00 81.10           C  
ATOM   1441  O   PRO B  33      25.126  32.220  44.552  1.00 82.40           O  
ATOM   1442  CB  PRO B  33      23.052  34.587  45.931  1.00 79.18           C  
ATOM   1443  CG  PRO B  33      22.802  35.979  45.491  1.00 77.56           C  
ATOM   1444  CD  PRO B  33      24.077  36.715  45.699  1.00 76.65           C  
ATOM   1445  N   ILE B  34      24.257  33.835  43.215  1.00 82.73           N  
ATOM   1446  CA  ILE B  34      24.389  33.117  41.922  1.00 83.57           C  
ATOM   1447  C   ILE B  34      23.534  31.837  41.724  1.00 84.01           C  
ATOM   1448  O   ILE B  34      22.514  31.893  41.024  1.00 83.86           O  
ATOM   1449  CB  ILE B  34      25.917  32.856  41.548  1.00 83.06           C  
ATOM   1450  CG1 ILE B  34      26.752  34.136  41.686  1.00 82.41           C  
ATOM   1451  CG2 ILE B  34      26.073  32.306  40.136  1.00 83.53           C  
ATOM   1452  CD1 ILE B  34      26.162  35.362  40.999  1.00 80.63           C  
ATOM   1453  N   GLN B  35      23.961  30.727  42.338  1.00 84.45           N  
ATOM   1454  CA  GLN B  35      23.374  29.364  42.206  1.00 85.00           C  
ATOM   1455  C   GLN B  35      24.388  28.442  41.505  1.00 85.68           C  
ATOM   1456  O   GLN B  35      24.547  27.285  41.907  1.00 86.86           O  
ATOM   1457  CB  GLN B  35      22.012  29.297  41.485  1.00 85.24           C  
ATOM   1458  N   SER B  36      25.063  28.952  40.469  1.00 85.29           N  
ATOM   1459  CA  SER B  36      26.103  28.196  39.728  1.00 85.21           C  
ATOM   1460  C   SER B  36      27.336  27.799  40.580  1.00 84.87           C  
ATOM   1461  O   SER B  36      27.589  28.390  41.642  1.00 84.78           O  
ATOM   1462  CB  SER B  36      26.543  28.982  38.484  1.00 86.34           C  
ATOM   1463  OG  SER B  36      25.419  29.264  37.655  1.00 89.01           O  
ATOM   1464  N   LYS B  37      28.087  26.800  40.087  1.00 83.63           N  
ATOM   1465  CA  LYS B  37      29.273  26.208  40.783  1.00 82.15           C  
ATOM   1466  C   LYS B  37      30.417  27.157  41.200  1.00 78.60           C  
ATOM   1467  O   LYS B  37      31.152  26.829  42.147  1.00 80.16           O  
ATOM   1468  CB  LYS B  37      29.878  25.060  39.952  1.00 81.43           C  
ATOM   1469  N   ARG B  38      30.561  28.288  40.487  1.00 73.73           N  
ATOM   1470  CA  ARG B  38      31.605  29.292  40.743  0.50 70.99           C  
ATOM   1472  C   ARG B  38      31.005  30.690  40.941  1.00 68.27           C  
ATOM   1473  O   ARG B  38      29.919  30.988  40.428  1.00 68.16           O  
ATOM   1474  CB  ARG B  38      32.619  29.311  39.587  0.50 71.53           C  
ATOM   1476  CG  ARG B  38      33.518  28.068  39.497  0.50 71.84           C  
ATOM   1478  CD  ARG B  38      34.549  28.194  38.374  0.50 70.03           C  
ATOM   1480  NE  ARG B  38      35.512  27.086  38.377  0.50 68.21           N  
ATOM   1482  CZ  ARG B  38      36.602  26.982  39.152  0.50 66.54           C  
ATOM   1484  NH1 ARG B  38      36.919  27.917  40.054  0.50 65.56           N  
ATOM   1486  NH2 ARG B  38      37.388  25.911  39.035  0.50 65.34           N  
ATOM   1488  N   SER B  39      31.730  31.537  41.677  1.00 62.79           N  
ATOM   1489  CA  SER B  39      31.304  32.907  41.976  1.00 57.95           C  
ATOM   1490  C   SER B  39      31.518  33.867  40.810  1.00 55.24           C  
ATOM   1491  O   SER B  39      32.248  33.553  39.875  1.00 54.00           O  
ATOM   1492  CB  SER B  39      32.063  33.433  43.208  1.00 57.54           C  
ATOM   1493  OG  SER B  39      33.469  33.392  43.025  1.00 50.64           O  
ATOM   1494  N   LEU B  40      30.881  35.042  40.885  1.00 52.24           N  
ATOM   1495  CA  LEU B  40      31.076  36.118  39.886  1.00 51.35           C  
ATOM   1496  C   LEU B  40      32.531  36.562  39.810  1.00 50.73           C  
ATOM   1497  O   LEU B  40      32.969  37.017  38.767  1.00 52.83           O  
ATOM   1498  CB  LEU B  40      30.177  37.347  40.127  1.00 50.30           C  
ATOM   1499  CG  LEU B  40      28.737  37.266  39.619  1.00 51.90           C  
ATOM   1500  CD1 LEU B  40      27.887  38.412  40.175  1.00 50.59           C  
ATOM   1501  CD2 LEU B  40      28.671  37.241  38.083  1.00 52.34           C  
ATOM   1502  N   PHE B  41      33.253  36.449  40.923  1.00 49.42           N  
ATOM   1503  CA  PHE B  41      34.678  36.740  40.989  1.00 48.20           C  
ATOM   1504  C   PHE B  41      35.439  35.743  40.112  1.00 47.89           C  
ATOM   1505  O   PHE B  41      36.206  36.153  39.254  1.00 45.50           O  
ATOM   1506  CB  PHE B  41      35.173  36.657  42.447  1.00 48.24           C  
ATOM   1507  CG  PHE B  41      36.573  37.125  42.624  1.00 46.43           C  
ATOM   1508  CD1 PHE B  41      36.835  38.479  42.811  1.00 46.27           C  
ATOM   1509  CD2 PHE B  41      37.642  36.225  42.577  1.00 47.36           C  
ATOM   1510  CE1 PHE B  41      38.137  38.936  42.961  1.00 46.73           C  
ATOM   1511  CE2 PHE B  41      38.956  36.674  42.720  1.00 46.83           C  
ATOM   1512  CZ  PHE B  41      39.199  38.037  42.916  1.00 46.04           C  
ATOM   1513  N   GLU B  42      35.202  34.445  40.335  1.00 47.39           N  
ATOM   1514  CA  GLU B  42      35.841  33.353  39.568  1.00 48.75           C  
ATOM   1515  C   GLU B  42      35.567  33.409  38.060  1.00 47.62           C  
ATOM   1516  O   GLU B  42      36.460  33.125  37.249  1.00 48.15           O  
ATOM   1517  CB  GLU B  42      35.442  31.983  40.140  1.00 48.49           C  
ATOM   1518  CG  GLU B  42      36.081  31.722  41.509  1.00 52.14           C  
ATOM   1519  CD  GLU B  42      35.594  30.445  42.175  1.00 54.32           C  
ATOM   1520  OE1 GLU B  42      34.358  30.254  42.294  1.00 61.40           O  
ATOM   1521  OE2 GLU B  42      36.457  29.654  42.620  1.00 62.33           O  
HETATM 1522  N   MSE B  43      34.340  33.786  37.705  1.00 46.56           N  
HETATM 1523  CA  MSE B  43      33.930  33.957  36.309  1.00 46.66           C  
HETATM 1524  C   MSE B  43      34.583  35.175  35.642  1.00 43.92           C  
HETATM 1525  O   MSE B  43      34.829  35.159  34.431  1.00 43.20           O  
HETATM 1526  CB  MSE B  43      32.416  34.088  36.209  1.00 45.20           C  
HETATM 1527  CG  MSE B  43      31.703  32.830  36.605  1.00 50.36           C  
HETATM 1528 SE   MSE B  43      29.830  33.120  36.525  0.75 55.07          SE  
HETATM 1529  CE  MSE B  43      29.598  33.204  34.577  1.00 52.00           C  
ATOM   1530  N   TYR B  44      34.837  36.217  36.433  1.00 42.72           N  
ATOM   1531  CA  TYR B  44      35.463  37.445  35.939  1.00 42.43           C  
ATOM   1532  C   TYR B  44      36.965  37.173  35.780  1.00 40.88           C  
ATOM   1533  O   TYR B  44      37.582  37.663  34.827  1.00 41.49           O  
ATOM   1534  CB  TYR B  44      35.212  38.634  36.880  1.00 43.10           C  
ATOM   1535  CG  TYR B  44      34.626  39.831  36.187  1.00 44.57           C  
ATOM   1536  CD1 TYR B  44      35.397  40.615  35.324  1.00 51.43           C  
ATOM   1537  CD2 TYR B  44      33.287  40.196  36.393  1.00 49.45           C  
ATOM   1538  CE1 TYR B  44      34.843  41.734  34.673  1.00 50.00           C  
ATOM   1539  CE2 TYR B  44      32.726  41.319  35.750  1.00 50.64           C  
ATOM   1540  CZ  TYR B  44      33.510  42.073  34.895  1.00 44.05           C  
ATOM   1541  OH  TYR B  44      32.970  43.164  34.273  1.00 47.91           O  
ATOM   1542  N   ALA B  45      37.541  36.418  36.721  1.00 38.65           N  
ATOM   1543  CA  ALA B  45      38.938  35.993  36.642  1.00 39.15           C  
ATOM   1544  C   ALA B  45      39.160  35.158  35.363  1.00 39.77           C  
ATOM   1545  O   ALA B  45      40.160  35.400  34.656  1.00 37.52           O  
ATOM   1546  CB  ALA B  45      39.371  35.238  37.898  1.00 38.75           C  
ATOM   1547  N   HIS B  46      38.232  34.221  35.070  1.00 38.71           N  
ATOM   1548  CA  HIS B  46      38.229  33.396  33.821  0.50 39.15           C  
ATOM   1550  C   HIS B  46      38.145  34.299  32.581  1.00 39.72           C  
ATOM   1551  O   HIS B  46      38.879  34.111  31.600  1.00 39.35           O  
ATOM   1552  CB  HIS B  46      37.040  32.395  33.827  0.50 38.77           C  
ATOM   1554  CG  HIS B  46      36.888  31.563  32.574  0.50 39.39           C  
ATOM   1556  ND1 HIS B  46      37.482  30.326  32.419  0.50 42.92           N  
ATOM   1558  CD2 HIS B  46      36.158  31.766  31.449  0.50 38.44           C  
ATOM   1560  CE1 HIS B  46      37.151  29.820  31.243  0.50 37.17           C  
ATOM   1562  NE2 HIS B  46      36.348  30.673  30.633  0.50 33.59           N  
ATOM   1564  N   LEU B  47      37.235  35.277  32.633  1.00 38.91           N  
ATOM   1565  CA  LEU B  47      37.030  36.224  31.523  1.00 38.61           C  
ATOM   1566  C   LEU B  47      38.336  36.956  31.205  1.00 38.46           C  
ATOM   1567  O   LEU B  47      38.681  37.128  30.040  1.00 40.07           O  
ATOM   1568  CB  LEU B  47      35.933  37.255  31.846  1.00 39.24           C  
ATOM   1569  CG  LEU B  47      35.451  38.202  30.725  1.00 37.33           C  
ATOM   1570  CD1 LEU B  47      34.556  37.457  29.750  1.00 33.62           C  
ATOM   1571  CD2 LEU B  47      34.724  39.401  31.287  1.00 36.71           C  
ATOM   1572  N   SER B  48      39.075  37.339  32.243  1.00 39.21           N  
ATOM   1573  CA  SER B  48      40.335  38.067  32.068  1.00 40.10           C  
ATOM   1574  C   SER B  48      41.454  37.249  31.400  1.00 39.15           C  
ATOM   1575  O   SER B  48      42.403  37.838  30.818  1.00 37.86           O  
ATOM   1576  CB  SER B  48      40.826  38.642  33.408  1.00 41.94           C  
ATOM   1577  OG  SER B  48      41.450  37.644  34.196  1.00 40.39           O  
ATOM   1578  N   LEU B  49      41.338  35.920  31.480  1.00 36.28           N  
ATOM   1579  CA  LEU B  49      42.294  34.992  30.874  1.00 36.77           C  
ATOM   1580  C   LEU B  49      41.985  34.550  29.436  1.00 36.67           C  
ATOM   1581  O   LEU B  49      42.840  33.889  28.826  1.00 38.41           O  
ATOM   1582  CB  LEU B  49      42.456  33.737  31.752  1.00 36.77           C  
ATOM   1583  CG  LEU B  49      43.139  33.844  33.110  1.00 35.88           C  
ATOM   1584  CD1 LEU B  49      43.234  32.422  33.710  1.00 31.97           C  
ATOM   1585  CD2 LEU B  49      44.519  34.463  32.982  1.00 35.05           C  
ATOM   1586  N   ILE B  50      40.815  34.926  28.893  1.00 34.33           N  
ATOM   1587  CA  ILE B  50      40.389  34.506  27.540  1.00 31.85           C  
ATOM   1588  C   ILE B  50      41.389  34.894  26.443  1.00 32.07           C  
ATOM   1589  O   ILE B  50      41.809  34.050  25.665  1.00 28.81           O  
ATOM   1590  CB  ILE B  50      38.966  35.035  27.196  1.00 32.44           C  
ATOM   1591  CG1 ILE B  50      37.917  34.295  28.054  1.00 29.44           C  
ATOM   1592  CG2 ILE B  50      38.642  34.855  25.714  1.00 29.25           C  
ATOM   1593  CD1 ILE B  50      36.506  34.808  27.875  1.00 28.21           C  
ATOM   1594  N   CYS B  51      41.796  36.158  26.395  1.00 32.69           N  
ATOM   1595  CA  CYS B  51      42.738  36.560  25.353  1.00 31.06           C  
ATOM   1596  C   CYS B  51      44.043  35.768  25.379  1.00 30.17           C  
ATOM   1597  O   CYS B  51      44.464  35.289  24.335  1.00 32.06           O  
ATOM   1598  CB  CYS B  51      42.976  38.051  25.385  1.00 32.46           C  
ATOM   1599  SG  CYS B  51      41.518  38.894  24.847  1.00 37.42           S  
ATOM   1600  N   HIS B  52      44.634  35.587  26.566  1.00 30.15           N  
ATOM   1601  CA  HIS B  52      45.881  34.815  26.721  1.00 30.17           C  
ATOM   1602  C   HIS B  52      45.695  33.328  26.376  1.00 30.87           C  
ATOM   1603  O   HIS B  52      46.458  32.776  25.599  1.00 32.01           O  
ATOM   1604  CB  HIS B  52      46.407  34.863  28.165  1.00 32.31           C  
ATOM   1605  CG  HIS B  52      47.255  36.050  28.503  1.00 34.85           C  
ATOM   1606  ND1 HIS B  52      46.807  37.091  29.287  1.00 39.00           N  
ATOM   1607  CD2 HIS B  52      48.564  36.303  28.256  1.00 37.87           C  
ATOM   1608  CE1 HIS B  52      47.793  37.951  29.476  1.00 41.60           C  
ATOM   1609  NE2 HIS B  52      48.869  37.499  28.858  1.00 39.66           N  
ATOM   1610  N   ALA B  53      44.691  32.701  26.990  1.00 29.41           N  
ATOM   1611  CA  ALA B  53      44.397  31.253  26.829  1.00 27.89           C  
ATOM   1612  C   ALA B  53      44.125  30.868  25.378  1.00 26.16           C  
ATOM   1613  O   ALA B  53      44.781  30.008  24.790  1.00 27.76           O  
ATOM   1614  CB  ALA B  53      43.182  30.884  27.692  1.00 24.20           C  
ATOM   1615  N   ASP B  54      43.163  31.542  24.785  1.00 28.12           N  
ATOM   1616  CA  ASP B  54      42.818  31.290  23.402  1.00 30.23           C  
ATOM   1617  C   ASP B  54      43.989  31.564  22.433  1.00 29.97           C  
ATOM   1618  O   ASP B  54      44.097  30.888  21.410  1.00 30.34           O  
ATOM   1619  CB  ASP B  54      41.556  32.062  23.005  1.00 32.60           C  
ATOM   1620  CG  ASP B  54      40.273  31.582  23.728  1.00 34.39           C  
ATOM   1621  OD1 ASP B  54      40.307  30.636  24.555  1.00 43.97           O  
ATOM   1622  OD2 ASP B  54      39.199  32.170  23.448  1.00 38.88           O  
ATOM   1623  N   LEU B  55      44.885  32.501  22.763  1.00 31.87           N  
ATOM   1624  CA  LEU B  55      46.126  32.703  21.949  1.00 32.15           C  
ATOM   1625  C   LEU B  55      47.084  31.508  22.108  1.00 33.26           C  
ATOM   1626  O   LEU B  55      47.738  31.110  21.140  1.00 32.82           O  
ATOM   1627  CB  LEU B  55      46.884  33.979  22.316  1.00 31.70           C  
ATOM   1628  CG  LEU B  55      48.139  34.267  21.457  1.00 32.55           C  
ATOM   1629  CD1 LEU B  55      47.821  34.314  19.985  1.00 30.24           C  
ATOM   1630  CD2 LEU B  55      48.763  35.538  21.900  1.00 27.88           C  
ATOM   1631  N   LEU B  56      47.214  30.993  23.335  1.00 33.50           N  
ATOM   1632  CA  LEU B  56      48.031  29.799  23.591  0.50 32.21           C  
ATOM   1634  C   LEU B  56      47.452  28.620  22.788  1.00 33.62           C  
ATOM   1635  O   LEU B  56      48.183  27.893  22.125  1.00 34.25           O  
ATOM   1636  CB  LEU B  56      48.106  29.480  25.092  0.50 31.58           C  
ATOM   1638  CG  LEU B  56      48.900  30.404  26.024  0.50 21.43           C  
ATOM   1640  CD1 LEU B  56      48.399  30.320  27.454  0.50  9.43           C  
ATOM   1642  CD2 LEU B  56      50.384  30.109  25.986  0.50  9.29           C  
ATOM   1644  N   ILE B  57      46.126  28.458  22.820  1.00 35.78           N  
ATOM   1645  CA  ILE B  57      45.434  27.383  22.055  1.00 34.02           C  
ATOM   1646  C   ILE B  57      45.762  27.455  20.554  1.00 35.57           C  
ATOM   1647  O   ILE B  57      46.132  26.449  19.945  1.00 35.85           O  
ATOM   1648  CB  ILE B  57      43.902  27.419  22.277  1.00 34.51           C  
ATOM   1649  CG1 ILE B  57      43.566  26.890  23.685  1.00 35.07           C  
ATOM   1650  CG2 ILE B  57      43.186  26.546  21.264  1.00 36.13           C  
ATOM   1651  CD1 ILE B  57      42.117  27.034  24.110  1.00 28.19           C  
ATOM   1652  N   LEU B  58      45.634  28.654  19.993  1.00 36.20           N  
ATOM   1653  CA  LEU B  58      45.975  28.946  18.590  1.00 36.57           C  
ATOM   1654  C   LEU B  58      47.432  28.587  18.248  1.00 37.86           C  
ATOM   1655  O   LEU B  58      47.717  28.095  17.148  1.00 39.01           O  
ATOM   1656  CB  LEU B  58      45.761  30.449  18.314  1.00 36.43           C  
ATOM   1657  CG  LEU B  58      46.053  31.035  16.927  1.00 36.44           C  
ATOM   1658  CD1 LEU B  58      45.260  30.310  15.837  1.00 37.84           C  
ATOM   1659  CD2 LEU B  58      45.755  32.520  16.956  1.00 35.01           C  
ATOM   1660  N   ASN B  59      48.332  28.845  19.201  1.00 38.89           N  
ATOM   1661  CA  ASN B  59      49.767  28.556  19.080  1.00 38.51           C  
ATOM   1662  C   ASN B  59      50.207  27.163  19.539  1.00 40.39           C  
ATOM   1663  O   ASN B  59      51.351  26.991  19.959  1.00 43.54           O  
ATOM   1664  CB  ASN B  59      50.573  29.677  19.768  1.00 38.85           C  
ATOM   1665  CG  ASN B  59      50.470  30.989  19.026  1.00 33.05           C  
ATOM   1666  OD1 ASN B  59      50.292  31.005  17.814  1.00 33.63           O  
ATOM   1667  ND2 ASN B  59      50.617  32.092  19.739  1.00 34.30           N  
ATOM   1668  N   GLY B  60      49.302  26.185  19.445  1.00 38.08           N  
ATOM   1669  CA  GLY B  60      49.603  24.795  19.698  1.00 39.62           C  
ATOM   1670  C   GLY B  60      49.744  24.310  21.114  1.00 41.40           C  
ATOM   1671  O   GLY B  60      50.270  23.212  21.316  1.00 43.77           O  
ATOM   1672  N   SER B  61      49.265  25.072  22.096  1.00 41.88           N  
ATOM   1673  CA  SER B  61      49.385  24.645  23.487  1.00 41.63           C  
ATOM   1674  C   SER B  61      48.553  23.399  23.757  1.00 43.40           C  
ATOM   1675  O   SER B  61      47.461  23.242  23.197  1.00 42.20           O  
ATOM   1676  CB  SER B  61      49.039  25.761  24.464  1.00 43.50           C  
ATOM   1677  OG  SER B  61      50.078  26.721  24.458  1.00 36.46           O  
ATOM   1678  N   THR B  62      49.108  22.506  24.578  1.00 44.41           N  
ATOM   1679  CA  THR B  62      48.441  21.262  24.954  1.00 45.39           C  
ATOM   1680  C   THR B  62      47.386  21.550  26.003  1.00 46.04           C  
ATOM   1681  O   THR B  62      47.395  22.627  26.618  1.00 46.85           O  
ATOM   1682  CB  THR B  62      49.430  20.220  25.558  1.00 44.90           C  
ATOM   1683  OG1 THR B  62      50.003  20.737  26.765  1.00 44.60           O  
ATOM   1684  CG2 THR B  62      50.542  19.857  24.570  1.00 39.91           C  
ATOM   1685  N   GLU B  63      46.491  20.577  26.188  1.00 46.77           N  
ATOM   1686  CA  GLU B  63      45.449  20.618  27.218  1.00 47.96           C  
ATOM   1687  C   GLU B  63      46.104  20.822  28.580  1.00 46.99           C  
ATOM   1688  O   GLU B  63      45.753  21.764  29.298  1.00 46.96           O  
ATOM   1689  CB  GLU B  63      44.635  19.318  27.221  1.00 47.82           C  
ATOM   1690  CG  GLU B  63      43.452  19.317  28.204  1.00 52.31           C  
ATOM   1691  CD  GLU B  63      42.471  18.168  27.983  1.00 52.76           C  
ATOM   1692  OE1 GLU B  63      42.857  17.135  27.393  1.00 56.57           O  
ATOM   1693  OE2 GLU B  63      41.302  18.307  28.407  1.00 60.91           O  
ATOM   1694  N   LYS B  64      47.075  19.950  28.890  1.00 46.61           N  
ATOM   1695  CA  LYS B  64      47.870  19.979  30.138  1.00 46.01           C  
ATOM   1696  C   LYS B  64      48.391  21.375  30.455  1.00 44.41           C  
ATOM   1697  O   LYS B  64      48.280  21.844  31.593  1.00 44.85           O  
ATOM   1698  CB  LYS B  64      49.056  19.003  30.005  1.00 47.08           C  
ATOM   1699  CG  LYS B  64      50.060  18.930  31.186  1.00 47.97           C  
ATOM   1700  CD  LYS B  64      51.236  18.018  30.816  1.00 48.89           C  
ATOM   1701  CE  LYS B  64      52.433  18.210  31.748  1.00 54.81           C  
ATOM   1702  NZ  LYS B  64      53.620  17.445  31.257  1.00 60.79           N  
ATOM   1703  N   GLU B  65      48.965  22.022  29.443  1.00 43.96           N  
ATOM   1704  CA  GLU B  65      49.481  23.393  29.592  1.00 43.41           C  
ATOM   1705  C   GLU B  65      48.370  24.398  29.930  1.00 42.74           C  
ATOM   1706  O   GLU B  65      48.596  25.273  30.762  1.00 45.21           O  
ATOM   1707  CB  GLU B  65      50.273  23.843  28.360  1.00 42.44           C  
ATOM   1708  CG  GLU B  65      50.739  25.308  28.479  1.00 45.09           C  
ATOM   1709  CD  GLU B  65      51.697  25.746  27.417  1.00 44.71           C  
ATOM   1710  OE1 GLU B  65      51.611  25.289  26.262  1.00 47.35           O  
ATOM   1711  OE2 GLU B  65      52.507  26.617  27.744  1.00 52.80           O  
ATOM   1712  N   LEU B  66      47.215  24.294  29.261  1.00 43.14           N  
ATOM   1713  CA  LEU B  66      46.057  25.157  29.558  1.00 43.19           C  
ATOM   1714  C   LEU B  66      45.546  24.912  30.978  1.00 43.90           C  
ATOM   1715  O   LEU B  66      45.270  25.863  31.702  1.00 42.64           O  
ATOM   1716  CB  LEU B  66      44.924  25.041  28.518  1.00 43.40           C  
ATOM   1717  CG  LEU B  66      44.972  25.944  27.260  1.00 43.10           C  
ATOM   1718  CD1 LEU B  66      44.781  27.412  27.652  1.00 35.98           C  
ATOM   1719  CD2 LEU B  66      46.242  25.759  26.387  1.00 37.96           C  
ATOM   1720  N   HIS B  67      45.461  23.642  31.380  1.00 46.92           N  
ATOM   1721  CA  HIS B  67      45.052  23.279  32.757  1.00 47.25           C  
ATOM   1722  C   HIS B  67      46.010  23.850  33.808  1.00 46.70           C  
ATOM   1723  O   HIS B  67      45.558  24.426  34.806  1.00 47.58           O  
ATOM   1724  CB  HIS B  67      44.872  21.763  32.892  1.00 49.00           C  
ATOM   1725  CG  HIS B  67      43.597  21.269  32.289  1.00 53.16           C  
ATOM   1726  ND1 HIS B  67      42.697  20.495  32.985  1.00 63.43           N  
ATOM   1727  CD2 HIS B  67      43.029  21.509  31.081  1.00 61.68           C  
ATOM   1728  CE1 HIS B  67      41.656  20.233  32.214  1.00 67.92           C  
ATOM   1729  NE2 HIS B  67      41.829  20.844  31.055  1.00 62.69           N  
ATOM   1730  N   THR B  68      47.315  23.729  33.555  1.00 45.86           N  
ATOM   1731  CA  THR B  68      48.336  24.351  34.416  1.00 45.32           C  
ATOM   1732  C   THR B  68      48.218  25.878  34.372  1.00 45.11           C  
ATOM   1733  O   THR B  68      48.333  26.524  35.416  1.00 45.92           O  
ATOM   1734  CB  THR B  68      49.764  23.964  33.995  1.00 44.14           C  
ATOM   1735  OG1 THR B  68      49.878  22.537  33.955  1.00 51.03           O  
ATOM   1736  CG2 THR B  68      50.805  24.539  34.961  1.00 44.55           C  
ATOM   1737  N   PHE B  69      47.982  26.436  33.170  1.00 44.93           N  
ATOM   1738  CA  PHE B  69      47.854  27.902  32.964  1.00 43.56           C  
ATOM   1739  C   PHE B  69      46.720  28.465  33.809  1.00 44.27           C  
ATOM   1740  O   PHE B  69      46.938  29.397  34.579  1.00 43.33           O  
ATOM   1741  CB  PHE B  69      47.683  28.247  31.479  1.00 41.14           C  
ATOM   1742  CG  PHE B  69      47.465  29.724  31.207  1.00 39.10           C  
ATOM   1743  CD1 PHE B  69      48.529  30.613  31.234  1.00 43.97           C  
ATOM   1744  CD2 PHE B  69      46.187  30.219  30.905  1.00 34.25           C  
ATOM   1745  CE1 PHE B  69      48.325  31.997  30.966  1.00 41.38           C  
ATOM   1746  CE2 PHE B  69      45.969  31.575  30.646  1.00 37.43           C  
ATOM   1747  CZ  PHE B  69      47.037  32.462  30.669  1.00 36.47           C  
ATOM   1748  N   TYR B  70      45.533  27.870  33.687  1.00 47.50           N  
ATOM   1749  CA  TYR B  70      44.369  28.265  34.514  1.00 49.47           C  
ATOM   1750  C   TYR B  70      44.612  28.017  36.015  1.00 51.72           C  
ATOM   1751  O   TYR B  70      44.265  28.870  36.837  1.00 51.63           O  
ATOM   1752  CB  TYR B  70      43.061  27.597  34.039  1.00 50.58           C  
ATOM   1753  CG  TYR B  70      42.439  28.291  32.835  1.00 51.02           C  
ATOM   1754  CD1 TYR B  70      41.716  29.472  33.006  1.00 49.12           C  
ATOM   1755  CD2 TYR B  70      42.562  27.776  31.536  1.00 49.96           C  
ATOM   1756  CE1 TYR B  70      41.135  30.147  31.922  1.00 46.38           C  
ATOM   1757  CE2 TYR B  70      41.973  28.442  30.436  1.00 50.57           C  
ATOM   1758  CZ  TYR B  70      41.269  29.631  30.646  1.00 48.21           C  
ATOM   1759  OH  TYR B  70      40.693  30.302  29.595  1.00 55.44           O  
ATOM   1760  N   LYS B  71      45.231  26.878  36.357  1.00 54.29           N  
ATOM   1761  CA  LYS B  71      45.581  26.547  37.759  1.00 54.95           C  
ATOM   1762  C   LYS B  71      46.485  27.608  38.400  1.00 54.87           C  
ATOM   1763  O   LYS B  71      46.140  28.145  39.447  1.00 56.26           O  
ATOM   1764  CB  LYS B  71      46.266  25.172  37.873  1.00 54.36           C  
ATOM   1765  N   GLU B  72      47.584  27.958  37.734  1.00 54.65           N  
ATOM   1766  CA  GLU B  72      48.563  28.896  38.299  1.00 55.73           C  
ATOM   1767  C   GLU B  72      48.452  30.388  37.938  1.00 54.00           C  
ATOM   1768  O   GLU B  72      49.126  31.191  38.578  1.00 54.83           O  
ATOM   1769  CB  GLU B  72      49.990  28.394  37.990  1.00 56.81           C  
ATOM   1770  CG  GLU B  72      50.567  28.762  36.615  1.00 61.34           C  
ATOM   1771  CD  GLU B  72      51.854  28.012  36.250  1.00 62.85           C  
ATOM   1772  OE1 GLU B  72      52.483  27.352  37.126  1.00 65.54           O  
ATOM   1773  OE2 GLU B  72      52.226  28.101  35.050  1.00 75.87           O  
ATOM   1774  N   GLN B  73      47.639  30.773  36.947  1.00 52.91           N  
ATOM   1775  CA  GLN B  73      47.584  32.199  36.501  1.00 51.47           C  
ATOM   1776  C   GLN B  73      46.274  32.968  36.628  1.00 48.42           C  
ATOM   1777  O   GLN B  73      46.248  34.170  36.335  1.00 45.45           O  
ATOM   1778  CB  GLN B  73      48.159  32.325  35.090  1.00 51.66           C  
ATOM   1779  CG  GLN B  73      49.561  31.710  35.000  1.00 56.25           C  
ATOM   1780  CD  GLN B  73      50.369  32.150  33.803  1.00 63.59           C  
ATOM   1781  OE1 GLN B  73      50.282  33.295  33.343  1.00 67.14           O  
ATOM   1782  NE2 GLN B  73      51.198  31.242  33.307  1.00 67.81           N  
ATOM   1783  N   THR B  74      45.213  32.307  37.099  1.00 47.35           N  
ATOM   1784  CA  THR B  74      43.910  32.947  37.310  1.00 47.70           C  
ATOM   1785  C   THR B  74      44.056  34.043  38.350  1.00 50.31           C  
ATOM   1786  O   THR B  74      44.528  33.752  39.452  1.00 51.08           O  
ATOM   1787  CB  THR B  74      42.852  31.950  37.816  1.00 48.21           C  
ATOM   1788  OG1 THR B  74      42.652  30.933  36.826  1.00 47.33           O  
ATOM   1789  CG2 THR B  74      41.522  32.642  38.088  1.00 45.73           C  
ATOM   1790  N   PRO B  75      43.736  35.310  37.990  1.00 53.17           N  
ATOM   1791  CA  PRO B  75      43.792  36.437  38.926  1.00 54.62           C  
ATOM   1792  C   PRO B  75      43.101  36.223  40.271  1.00 56.89           C  
ATOM   1793  O   PRO B  75      42.063  35.546  40.337  1.00 58.60           O  
ATOM   1794  CB  PRO B  75      43.065  37.534  38.155  1.00 54.27           C  
ATOM   1795  CG  PRO B  75      43.512  37.309  36.807  1.00 53.56           C  
ATOM   1796  CD  PRO B  75      43.372  35.813  36.651  1.00 53.18           C  
ATOM   1797  N   GLU B  76      43.722  36.759  41.320  1.00 57.75           N  
ATOM   1798  CA  GLU B  76      43.214  36.720  42.690  1.00 58.96           C  
ATOM   1799  C   GLU B  76      42.781  38.118  43.192  1.00 57.24           C  
ATOM   1800  O   GLU B  76      42.361  38.239  44.343  1.00 58.77           O  
ATOM   1801  CB  GLU B  76      44.245  36.037  43.601  1.00 59.67           C  
ATOM   1802  CG  GLU B  76      44.400  34.518  43.281  1.00 62.18           C  
ATOM   1803  CD  GLU B  76      45.480  33.794  44.093  1.00 61.95           C  
ATOM   1804  OE1 GLU B  76      46.279  34.450  44.796  1.00 72.64           O  
ATOM   1805  OE2 GLU B  76      45.537  32.549  44.010  1.00 69.49           O  
ATOM   1806  N   THR B  77      42.868  39.140  42.322  1.00 55.01           N  
ATOM   1807  CA  THR B  77      42.458  40.518  42.618  0.50 54.36           C  
ATOM   1809  C   THR B  77      41.865  41.172  41.357  1.00 54.13           C  
ATOM   1810  O   THR B  77      42.202  40.779  40.246  1.00 54.31           O  
ATOM   1811  CB  THR B  77      43.652  41.381  43.108  0.50 54.02           C  
ATOM   1813  OG1 THR B  77      44.632  41.509  42.073  0.50 52.18           O  
ATOM   1815  CG2 THR B  77      44.308  40.773  44.339  0.50 52.31           C  
ATOM   1817  N   ILE B  78      41.006  42.174  41.547  1.00 53.18           N  
ATOM   1818  CA  ILE B  78      40.398  42.937  40.439  1.00 51.64           C  
ATOM   1819  C   ILE B  78      41.452  43.738  39.660  1.00 52.54           C  
ATOM   1820  O   ILE B  78      41.283  43.975  38.464  1.00 51.73           O  
ATOM   1821  CB  ILE B  78      39.244  43.864  40.952  1.00 51.45           C  
ATOM   1822  CG1 ILE B  78      38.042  43.008  41.354  1.00 48.87           C  
ATOM   1823  CG2 ILE B  78      38.815  44.902  39.911  1.00 48.34           C  
ATOM   1824  CD1 ILE B  78      36.866  43.802  41.865  1.00 48.95           C  
ATOM   1825  N   ALA B  79      42.531  44.142  40.338  1.00 53.95           N  
ATOM   1826  CA  ALA B  79      43.631  44.881  39.697  1.00 53.65           C  
ATOM   1827  C   ALA B  79      44.351  43.983  38.701  1.00 52.62           C  
ATOM   1828  O   ALA B  79      44.505  44.373  37.547  1.00 51.75           O  
ATOM   1829  CB  ALA B  79      44.609  45.420  40.730  1.00 53.43           C  
ATOM   1830  N   GLN B  80      44.730  42.771  39.137  1.00 52.56           N  
ATOM   1831  CA  GLN B  80      45.441  41.819  38.268  1.00 53.53           C  
ATOM   1832  C   GLN B  80      44.527  41.207  37.196  1.00 51.91           C  
ATOM   1833  O   GLN B  80      45.033  40.730  36.183  1.00 53.77           O  
ATOM   1834  CB  GLN B  80      46.288  40.793  39.048  1.00 53.49           C  
ATOM   1835  CG  GLN B  80      45.613  39.564  39.602  1.00 57.70           C  
ATOM   1836  CD  GLN B  80      46.474  38.849  40.672  1.00 58.02           C  
ATOM   1837  OE1 GLN B  80      46.722  39.391  41.748  1.00 70.16           O  
ATOM   1838  NE2 GLN B  80      46.895  37.619  40.382  1.00 65.22           N  
HETATM 1839  N   MSE B  81      43.205  41.234  37.410  1.00 49.00           N  
HETATM 1840  CA  MSE B  81      42.238  40.876  36.365  1.00 46.90           C  
HETATM 1841  C   MSE B  81      42.310  41.896  35.243  1.00 45.37           C  
HETATM 1842  O   MSE B  81      42.374  41.523  34.086  1.00 43.91           O  
HETATM 1843  CB  MSE B  81      40.798  40.871  36.873  1.00 46.61           C  
HETATM 1844  CG  MSE B  81      40.401  39.686  37.687  1.00 45.48           C  
HETATM 1845 SE   MSE B  81      38.584  39.984  38.283  0.75 46.78          SE  
HETATM 1846  CE  MSE B  81      38.433  38.296  39.284  1.00 39.17           C  
ATOM   1847  N   GLN B  82      42.281  43.176  35.608  1.00 46.20           N  
ATOM   1848  CA  GLN B  82      42.353  44.272  34.631  1.00 47.56           C  
ATOM   1849  C   GLN B  82      43.693  44.315  33.905  1.00 46.39           C  
ATOM   1850  O   GLN B  82      43.726  44.495  32.691  1.00 46.15           O  
ATOM   1851  CB  GLN B  82      42.018  45.619  35.282  1.00 47.43           C  
ATOM   1852  CG  GLN B  82      40.556  45.692  35.729  1.00 50.28           C  
ATOM   1853  CD  GLN B  82      40.168  47.039  36.278  1.00 49.97           C  
ATOM   1854  OE1 GLN B  82      40.443  48.062  35.662  1.00 58.16           O  
ATOM   1855  NE2 GLN B  82      39.481  47.048  37.410  1.00 56.13           N  
ATOM   1856  N   LYS B  83      44.778  44.128  34.655  1.00 46.58           N  
ATOM   1857  CA  LYS B  83      46.129  44.093  34.095  1.00 46.60           C  
ATOM   1858  C   LYS B  83      46.291  42.924  33.122  1.00 43.95           C  
ATOM   1859  O   LYS B  83      46.805  43.120  32.023  1.00 42.68           O  
ATOM   1860  CB  LYS B  83      47.211  44.043  35.204  1.00 46.76           C  
ATOM   1861  CG  LYS B  83      47.314  45.343  36.028  1.00 52.15           C  
ATOM   1862  CD  LYS B  83      48.634  45.496  36.833  1.00 51.21           C  
ATOM   1863  CE  LYS B  83      48.834  44.458  37.923  1.00 54.55           C  
ATOM   1864  NZ  LYS B  83      50.016  44.808  38.788  1.00 49.67           N  
ATOM   1865  N   THR B  84      45.827  41.733  33.523  1.00 40.25           N  
ATOM   1866  CA  THR B  84      45.916  40.529  32.697  1.00 39.01           C  
ATOM   1867  C   THR B  84      45.114  40.628  31.388  1.00 39.45           C  
ATOM   1868  O   THR B  84      45.616  40.277  30.321  1.00 40.70           O  
ATOM   1869  CB  THR B  84      45.427  39.292  33.485  1.00 39.98           C  
ATOM   1870  OG1 THR B  84      46.302  39.073  34.599  1.00 42.32           O  
ATOM   1871  CG2 THR B  84      45.387  38.037  32.613  1.00 37.70           C  
HETATM 1872  N   MSE B  85      43.877  41.101  31.491  1.00 38.68           N  
HETATM 1873  CA  MSE B  85      42.976  41.251  30.349  1.00 39.62           C  
HETATM 1874  C   MSE B  85      43.545  42.237  29.311  1.00 38.40           C  
HETATM 1875  O   MSE B  85      43.450  41.968  28.104  1.00 35.80           O  
HETATM 1876  CB  MSE B  85      41.608  41.706  30.832  1.00 39.07           C  
HETATM 1877  CG  MSE B  85      40.467  41.417  29.911  1.00 43.17           C  
HETATM 1878 SE   MSE B  85      38.814  42.070  30.695  0.75 49.26          SE  
HETATM 1879  CE  MSE B  85      38.727  41.061  32.345  1.00 59.03           C  
ATOM   1880  N   ILE B  86      44.152  43.345  29.771  1.00 39.41           N  
ATOM   1881  CA  ILE B  86      44.795  44.333  28.851  1.00 38.99           C  
ATOM   1882  C   ILE B  86      46.036  43.745  28.184  1.00 38.85           C  
ATOM   1883  O   ILE B  86      46.235  43.919  26.988  1.00 40.77           O  
ATOM   1884  CB  ILE B  86      45.175  45.671  29.555  1.00 40.47           C  
ATOM   1885  CG1 ILE B  86      43.923  46.464  29.953  1.00 43.58           C  
ATOM   1886  CG2 ILE B  86      46.010  46.591  28.631  1.00 39.75           C  
ATOM   1887  CD1 ILE B  86      43.071  46.978  28.770  1.00 46.69           C  
ATOM   1888  N   GLN B  87      46.871  43.070  28.967  1.00 39.33           N  
ATOM   1889  CA  GLN B  87      48.076  42.418  28.450  1.00 39.40           C  
ATOM   1890  C   GLN B  87      47.766  41.320  27.446  1.00 37.49           C  
ATOM   1891  O   GLN B  87      48.511  41.140  26.491  1.00 36.19           O  
ATOM   1892  CB  GLN B  87      48.907  41.831  29.586  1.00 41.05           C  
ATOM   1893  CG  GLN B  87      49.627  42.881  30.425  1.00 46.45           C  
ATOM   1894  CD  GLN B  87      50.104  42.340  31.757  1.00 56.45           C  
ATOM   1895  OE1 GLN B  87      50.158  41.117  31.984  1.00 60.20           O  
ATOM   1896  NE2 GLN B  87      50.441  43.254  32.662  1.00 62.44           N  
ATOM   1897  N   GLY B  88      46.703  40.563  27.700  1.00 37.80           N  
ATOM   1898  CA  GLY B  88      46.252  39.508  26.796  1.00 36.90           C  
ATOM   1899  C   GLY B  88      45.757  40.081  25.478  1.00 35.30           C  
ATOM   1900  O   GLY B  88      46.049  39.525  24.409  1.00 34.09           O  
ATOM   1901  N   TYR B  89      44.998  41.175  25.560  1.00 35.66           N  
ATOM   1902  CA  TYR B  89      44.532  41.869  24.374  1.00 35.87           C  
ATOM   1903  C   TYR B  89      45.727  42.373  23.557  1.00 36.29           C  
ATOM   1904  O   TYR B  89      45.748  42.186  22.336  1.00 38.63           O  
ATOM   1905  CB  TYR B  89      43.550  43.026  24.679  1.00 35.18           C  
ATOM   1906  CG  TYR B  89      43.242  43.785  23.413  1.00 35.23           C  
ATOM   1907  CD1 TYR B  89      42.338  43.281  22.486  1.00 32.47           C  
ATOM   1908  CD2 TYR B  89      43.950  44.954  23.083  1.00 37.44           C  
ATOM   1909  CE1 TYR B  89      42.093  43.939  21.283  1.00 36.26           C  
ATOM   1910  CE2 TYR B  89      43.722  45.623  21.871  1.00 34.32           C  
ATOM   1911  CZ  TYR B  89      42.793  45.109  20.976  1.00 38.46           C  
ATOM   1912  OH  TYR B  89      42.537  45.765  19.794  1.00 41.58           O  
ATOM   1913  N   ASP B  90      46.686  43.027  24.215  1.00 36.16           N  
ATOM   1914  CA  ASP B  90      47.892  43.529  23.525  1.00 36.66           C  
ATOM   1915  C   ASP B  90      48.633  42.406  22.820  1.00 35.40           C  
ATOM   1916  O   ASP B  90      48.990  42.564  21.674  1.00 32.32           O  
ATOM   1917  CB  ASP B  90      48.869  44.222  24.480  1.00 38.39           C  
ATOM   1918  CG  ASP B  90      48.370  45.554  24.984  1.00 45.92           C  
ATOM   1919  OD1 ASP B  90      47.184  45.935  24.764  1.00 49.68           O  
ATOM   1920  OD2 ASP B  90      49.198  46.228  25.635  1.00 58.31           O  
ATOM   1921  N   LEU B  91      48.810  41.256  23.480  1.00 34.20           N  
ATOM   1922  CA  LEU B  91      49.529  40.139  22.864  1.00 35.45           C  
ATOM   1923  C   LEU B  91      48.739  39.563  21.672  1.00 36.67           C  
ATOM   1924  O   LEU B  91      49.312  39.266  20.620  1.00 38.82           O  
ATOM   1925  CB  LEU B  91      49.857  39.050  23.908  1.00 36.68           C  
ATOM   1926  CG  LEU B  91      50.809  37.903  23.537  1.00 36.17           C  
ATOM   1927  CD1 LEU B  91      52.161  38.411  23.051  1.00 39.36           C  
ATOM   1928  CD2 LEU B  91      50.977  36.908  24.724  1.00 35.92           C  
ATOM   1929  N   LEU B  92      47.424  39.439  21.835  1.00 36.40           N  
ATOM   1930  CA  LEU B  92      46.559  38.929  20.782  1.00 35.29           C  
ATOM   1931  C   LEU B  92      46.514  39.860  19.579  1.00 34.39           C  
ATOM   1932  O   LEU B  92      46.614  39.396  18.448  1.00 35.01           O  
ATOM   1933  CB  LEU B  92      45.136  38.704  21.314  1.00 35.38           C  
ATOM   1934  CG  LEU B  92      44.109  38.030  20.406  1.00 31.29           C  
ATOM   1935  CD1 LEU B  92      44.609  36.679  19.967  1.00 31.96           C  
ATOM   1936  CD2 LEU B  92      42.808  37.889  21.147  1.00 34.01           C  
ATOM   1937  N   SER B  93      46.366  41.161  19.819  1.00 35.54           N  
ATOM   1938  CA  SER B  93      46.303  42.136  18.705  1.00 37.64           C  
ATOM   1939  C   SER B  93      47.636  42.241  17.982  1.00 36.35           C  
ATOM   1940  O   SER B  93      47.678  42.127  16.760  1.00 38.84           O  
ATOM   1941  CB  SER B  93      45.806  43.510  19.161  1.00 35.37           C  
ATOM   1942  OG  SER B  93      46.566  43.986  20.238  1.00 47.07           O  
ATOM   1943  N   LYS B  94      48.724  42.405  18.734  1.00 36.54           N  
ATOM   1944  CA  LYS B  94      50.075  42.492  18.137  1.00 35.09           C  
ATOM   1945  C   LYS B  94      50.364  41.283  17.262  1.00 33.57           C  
ATOM   1946  O   LYS B  94      50.913  41.416  16.171  1.00 29.04           O  
ATOM   1947  CB  LYS B  94      51.169  42.688  19.199  1.00 35.43           C  
ATOM   1948  CG  LYS B  94      51.117  44.038  19.935  1.00 37.25           C  
ATOM   1949  CD  LYS B  94      51.330  45.285  19.024  1.00 44.33           C  
ATOM   1950  CE  LYS B  94      51.338  46.601  19.843  1.00 48.01           C  
ATOM   1951  NZ  LYS B  94      52.430  46.721  20.914  1.00 47.02           N  
ATOM   1952  N   THR B  95      49.928  40.111  17.727  1.00 30.79           N  
ATOM   1953  CA  THR B  95      50.065  38.891  16.976  1.00 28.24           C  
ATOM   1954  C   THR B  95      49.241  38.929  15.703  1.00 28.96           C  
ATOM   1955  O   THR B  95      49.786  38.712  14.625  1.00 31.70           O  
ATOM   1956  CB  THR B  95      49.598  37.651  17.815  1.00 28.74           C  
ATOM   1957  OG1 THR B  95      50.477  37.476  18.941  1.00 28.93           O  
ATOM   1958  CG2 THR B  95      49.592  36.409  16.952  1.00 18.71           C  
ATOM   1959  N   PHE B  96      47.936  39.190  15.822  1.00 30.17           N  
ATOM   1960  CA  PHE B  96      47.058  39.210  14.631  1.00 31.28           C  
ATOM   1961  C   PHE B  96      47.404  40.278  13.598  1.00 32.72           C  
ATOM   1962  O   PHE B  96      47.227  40.049  12.406  1.00 34.07           O  
ATOM   1963  CB  PHE B  96      45.562  39.180  14.984  1.00 32.08           C  
ATOM   1964  CG  PHE B  96      45.022  37.777  15.089  1.00 32.82           C  
ATOM   1965  CD1 PHE B  96      45.083  37.075  16.288  1.00 31.40           C  
ATOM   1966  CD2 PHE B  96      44.560  37.131  13.944  1.00 28.95           C  
ATOM   1967  CE1 PHE B  96      44.609  35.737  16.362  1.00 34.48           C  
ATOM   1968  CE2 PHE B  96      44.114  35.828  13.987  1.00 31.02           C  
ATOM   1969  CZ  PHE B  96      44.123  35.115  15.206  1.00 32.51           C  
ATOM   1970  N   LEU B  97      47.916  41.408  14.068  1.00 34.26           N  
ATOM   1971  CA  LEU B  97      48.389  42.495  13.190  1.00 36.70           C  
ATOM   1972  C   LEU B  97      49.713  42.163  12.492  1.00 39.27           C  
ATOM   1973  O   LEU B  97      50.088  42.863  11.536  1.00 43.05           O  
ATOM   1974  CB  LEU B  97      48.548  43.804  13.985  1.00 36.13           C  
ATOM   1975  CG  LEU B  97      47.307  44.528  14.486  1.00 34.18           C  
ATOM   1976  CD1 LEU B  97      47.732  45.720  15.329  1.00 39.08           C  
ATOM   1977  CD2 LEU B  97      46.430  44.966  13.309  1.00 37.25           C  
ATOM   1978  N   SER B  98      50.437  41.155  12.999  1.00 40.71           N  
ATOM   1979  CA  SER B  98      51.682  40.683  12.392  1.00 39.84           C  
ATOM   1980  C   SER B  98      51.413  39.714  11.233  1.00 40.91           C  
ATOM   1981  O   SER B  98      52.314  39.485  10.420  1.00 40.90           O  
ATOM   1982  CB  SER B  98      52.602  40.008  13.435  1.00 41.46           C  
ATOM   1983  OG  SER B  98      52.179  38.691  13.809  1.00 35.07           O  
ATOM   1984  N   TYR B  99      50.202  39.149  11.155  1.00 41.05           N  
ATOM   1985  CA  TYR B  99      49.888  38.149  10.142  1.00 40.95           C  
ATOM   1986  C   TYR B  99      49.560  38.705   8.754  1.00 44.24           C  
ATOM   1987  O   TYR B  99      48.804  39.669   8.612  1.00 45.11           O  
ATOM   1988  CB  TYR B  99      48.716  37.250  10.556  1.00 39.20           C  
ATOM   1989  CG  TYR B  99      48.905  36.362  11.781  1.00 37.13           C  
ATOM   1990  CD1 TYR B  99      50.092  35.634  11.997  1.00 32.73           C  
ATOM   1991  CD2 TYR B  99      47.848  36.165  12.675  1.00 33.55           C  
ATOM   1992  CE1 TYR B  99      50.236  34.791  13.109  1.00 39.34           C  
ATOM   1993  CE2 TYR B  99      47.976  35.324  13.786  1.00 35.50           C  
ATOM   1994  CZ  TYR B  99      49.167  34.634  13.997  1.00 36.95           C  
ATOM   1995  OH  TYR B  99      49.285  33.805  15.084  1.00 41.35           O  
ATOM   1996  N   SER B 100      50.124  38.048   7.737  1.00 46.02           N  
ATOM   1997  CA  SER B 100      49.810  38.292   6.330  1.00 45.87           C  
ATOM   1998  C   SER B 100      48.455  37.630   6.052  1.00 45.92           C  
ATOM   1999  O   SER B 100      47.972  36.843   6.874  1.00 45.38           O  
ATOM   2000  CB  SER B 100      50.866  37.622   5.434  1.00 46.09           C  
ATOM   2001  OG  SER B 100      50.814  36.190   5.534  1.00 43.03           O  
ATOM   2002  N   ASN B 101      47.862  37.912   4.888  1.00 47.08           N  
ATOM   2003  CA  ASN B 101      46.603  37.231   4.477  1.00 47.90           C  
ATOM   2004  C   ASN B 101      46.746  35.711   4.424  1.00 46.46           C  
ATOM   2005  O   ASN B 101      45.803  34.983   4.766  1.00 47.40           O  
ATOM   2006  CB  ASN B 101      46.062  37.735   3.116  1.00 49.37           C  
ATOM   2007  CG  ASN B 101      45.104  38.927   3.247  1.00 55.29           C  
ATOM   2008  OD1 ASN B 101      44.080  38.980   2.553  1.00 66.32           O  
ATOM   2009  ND2 ASN B 101      45.411  39.861   4.143  1.00 57.93           N  
ATOM   2010  N   GLU B 102      47.936  35.262   4.023  1.00 45.19           N  
ATOM   2011  CA  GLU B 102      48.285  33.843   3.902  1.00 45.19           C  
ATOM   2012  C   GLU B 102      48.304  33.237   5.291  1.00 42.73           C  
ATOM   2013  O   GLU B 102      47.782  32.138   5.502  1.00 43.78           O  
ATOM   2014  CB  GLU B 102      49.636  33.647   3.179  1.00 46.82           C  
ATOM   2015  CG  GLU B 102      49.646  34.012   1.673  1.00 49.36           C  
ATOM   2016  CD  GLU B 102      49.411  35.513   1.370  1.00 55.92           C  
ATOM   2017  OE1 GLU B 102      49.868  36.388   2.154  1.00 46.58           O  
ATOM   2018  OE2 GLU B 102      48.745  35.811   0.349  1.00 62.65           O  
ATOM   2019  N   GLN B 103      48.882  33.979   6.233  1.00 41.31           N  
ATOM   2020  CA  GLN B 103      48.898  33.592   7.648  1.00 40.63           C  
ATOM   2021  C   GLN B 103      47.498  33.595   8.263  1.00 40.69           C  
ATOM   2022  O   GLN B 103      47.164  32.699   9.044  1.00 42.13           O  
ATOM   2023  CB  GLN B 103      49.866  34.470   8.430  1.00 40.53           C  
ATOM   2024  CG  GLN B 103      51.293  34.147   8.073  1.00 39.76           C  
ATOM   2025  CD  GLN B 103      52.295  34.998   8.766  1.00 34.30           C  
ATOM   2026  OE1 GLN B 103      52.223  36.216   8.735  1.00 36.95           O  
ATOM   2027  NE2 GLN B 103      53.267  34.363   9.376  1.00 42.93           N  
ATOM   2028  N   LEU B 104      46.676  34.581   7.894  1.00 39.68           N  
ATOM   2029  CA  LEU B 104      45.271  34.617   8.325  1.00 38.78           C  
ATOM   2030  C   LEU B 104      44.454  33.433   7.815  1.00 38.30           C  
ATOM   2031  O   LEU B 104      43.496  33.047   8.469  1.00 38.60           O  
ATOM   2032  CB  LEU B 104      44.585  35.921   7.906  1.00 37.99           C  
ATOM   2033  CG  LEU B 104      45.102  37.151   8.635  1.00 36.62           C  
ATOM   2034  CD1 LEU B 104      44.576  38.401   7.966  1.00 32.72           C  
ATOM   2035  CD2 LEU B 104      44.736  37.094  10.118  1.00 24.32           C  
ATOM   2036  N   ALA B 105      44.826  32.890   6.652  1.00 38.63           N  
ATOM   2037  CA  ALA B 105      44.157  31.731   6.055  1.00 39.04           C  
ATOM   2038  C   ALA B 105      44.698  30.398   6.562  1.00 40.80           C  
ATOM   2039  O   ALA B 105      44.056  29.379   6.348  1.00 42.62           O  
ATOM   2040  CB  ALA B 105      44.270  31.786   4.523  1.00 37.14           C  
ATOM   2041  N   GLU B 106      45.874  30.403   7.204  1.00 42.17           N  
ATOM   2042  CA  GLU B 106      46.535  29.185   7.677  1.00 42.33           C  
ATOM   2043  C   GLU B 106      45.674  28.446   8.678  1.00 41.60           C  
ATOM   2044  O   GLU B 106      45.096  29.055   9.555  1.00 42.82           O  
ATOM   2045  CB  GLU B 106      47.889  29.495   8.323  1.00 41.83           C  
ATOM   2046  CG  GLU B 106      48.731  28.248   8.701  1.00 48.64           C  
ATOM   2047  CD  GLU B 106      49.391  27.558   7.521  1.00 49.83           C  
ATOM   2048  OE1 GLU B 106      49.176  27.957   6.352  1.00 57.24           O  
ATOM   2049  OE2 GLU B 106      50.162  26.611   7.776  1.00 51.78           O  
HETATM 2050  N   MSE B 107      45.656  27.127   8.554  1.00 42.86           N  
HETATM 2051  CA  MSE B 107      44.835  26.252   9.383  1.00 43.19           C  
HETATM 2052  C   MSE B 107      45.629  25.778  10.578  1.00 44.15           C  
HETATM 2053  O   MSE B 107      46.757  25.297  10.409  1.00 45.57           O  
HETATM 2054  CB  MSE B 107      44.392  25.041   8.571  1.00 43.67           C  
HETATM 2055  CG  MSE B 107      43.618  25.420   7.356  1.00 44.59           C  
HETATM 2056 SE   MSE B 107      41.884  26.108   7.812  0.75 56.42          SE  
HETATM 2057  CE  MSE B 107      41.678  27.406   6.357  1.00 48.89           C  
ATOM   2058  N   LYS B 108      45.044  25.924  11.771  1.00 43.33           N  
ATOM   2059  CA  LYS B 108      45.652  25.478  13.022  1.00 42.84           C  
ATOM   2060  C   LYS B 108      44.640  24.589  13.727  1.00 44.25           C  
ATOM   2061  O   LYS B 108      43.433  24.884  13.711  1.00 43.03           O  
ATOM   2062  CB  LYS B 108      46.034  26.651  13.933  1.00 41.65           C  
ATOM   2063  CG  LYS B 108      46.821  27.808  13.286  1.00 41.15           C  
ATOM   2064  CD  LYS B 108      48.128  27.435  12.573  1.00 43.06           C  
ATOM   2065  CE  LYS B 108      49.217  26.909  13.456  1.00 46.00           C  
ATOM   2066  NZ  LYS B 108      50.396  26.602  12.601  1.00 42.93           N  
ATOM   2067  N   THR B 109      45.140  23.517  14.344  1.00 45.09           N  
ATOM   2068  CA  THR B 109      44.307  22.564  15.080  1.00 47.64           C  
ATOM   2069  C   THR B 109      44.430  22.835  16.583  1.00 47.38           C  
ATOM   2070  O   THR B 109      45.554  22.863  17.136  1.00 47.59           O  
ATOM   2071  CB  THR B 109      44.743  21.114  14.795  1.00 48.53           C  
ATOM   2072  OG1 THR B 109      44.736  20.903  13.385  1.00 52.01           O  
ATOM   2073  CG2 THR B 109      43.803  20.107  15.460  1.00 46.89           C  
ATOM   2074  N   ALA B 110      43.278  23.059  17.228  1.00 45.80           N  
ATOM   2075  CA  ALA B 110      43.216  23.217  18.690  1.00 45.28           C  
ATOM   2076  C   ALA B 110      43.517  21.846  19.283  1.00 43.42           C  
ATOM   2077  O   ALA B 110      43.318  20.830  18.611  1.00 43.08           O  
ATOM   2078  CB  ALA B 110      41.842  23.712  19.140  1.00 44.27           C  
ATOM   2079  N   TYR B 111      43.994  21.815  20.526  1.00 44.27           N  
ATOM   2080  CA  TYR B 111      44.388  20.545  21.183  1.00 45.23           C  
ATOM   2081  C   TYR B 111      43.318  19.450  21.123  1.00 46.41           C  
ATOM   2082  O   TYR B 111      43.651  18.273  21.005  1.00 48.52           O  
ATOM   2083  CB  TYR B 111      44.890  20.764  22.623  1.00 44.96           C  
ATOM   2084  CG  TYR B 111      43.877  21.243  23.650  1.00 44.18           C  
ATOM   2085  CD1 TYR B 111      42.948  20.353  24.226  1.00 39.87           C  
ATOM   2086  CD2 TYR B 111      43.883  22.568  24.100  1.00 40.74           C  
ATOM   2087  CE1 TYR B 111      42.035  20.777  25.195  1.00 43.27           C  
ATOM   2088  CE2 TYR B 111      42.969  23.013  25.074  1.00 45.17           C  
ATOM   2089  CZ  TYR B 111      42.046  22.109  25.624  1.00 44.92           C  
ATOM   2090  OH  TYR B 111      41.132  22.540  26.564  1.00 40.40           O  
ATOM   2091  N   TRP B 112      42.048  19.870  21.169  1.00 47.83           N  
ATOM   2092  CA  TRP B 112      40.869  18.992  21.051  1.00 47.83           C  
ATOM   2093  C   TRP B 112      40.520  18.549  19.607  1.00 49.28           C  
ATOM   2094  O   TRP B 112      39.425  18.031  19.369  1.00 49.78           O  
ATOM   2095  CB  TRP B 112      39.645  19.614  21.761  1.00 47.07           C  
ATOM   2096  CG  TRP B 112      39.116  20.886  21.182  1.00 46.43           C  
ATOM   2097  CD1 TRP B 112      38.187  21.007  20.199  1.00 46.55           C  
ATOM   2098  CD2 TRP B 112      39.467  22.222  21.573  1.00 46.56           C  
ATOM   2099  NE1 TRP B 112      37.932  22.335  19.943  1.00 45.18           N  
ATOM   2100  CE2 TRP B 112      38.704  23.104  20.778  1.00 48.47           C  
ATOM   2101  CE3 TRP B 112      40.353  22.757  22.518  1.00 43.39           C  
ATOM   2102  CZ2 TRP B 112      38.814  24.511  20.894  1.00 47.66           C  
ATOM   2103  CZ3 TRP B 112      40.463  24.132  22.638  1.00 45.60           C  
ATOM   2104  CH2 TRP B 112      39.695  24.999  21.830  1.00 45.32           C  
ATOM   2105  N   GLY B 113      41.416  18.784  18.644  1.00 49.57           N  
ATOM   2106  CA  GLY B 113      41.269  18.259  17.291  1.00 50.60           C  
ATOM   2107  C   GLY B 113      40.394  18.948  16.270  1.00 50.35           C  
ATOM   2108  O   GLY B 113      40.301  18.464  15.146  1.00 50.95           O  
ATOM   2109  N   ILE B 114      39.722  20.035  16.642  1.00 50.73           N  
ATOM   2110  CA  ILE B 114      38.910  20.805  15.686  1.00 50.04           C  
ATOM   2111  C   ILE B 114      39.881  21.831  15.101  1.00 49.43           C  
ATOM   2112  O   ILE B 114      40.743  22.346  15.828  1.00 51.41           O  
ATOM   2113  CB  ILE B 114      37.658  21.447  16.353  1.00 49.83           C  
ATOM   2114  CG1 ILE B 114      36.751  20.360  16.983  1.00 49.24           C  
ATOM   2115  CG2 ILE B 114      36.870  22.286  15.353  1.00 48.67           C  
ATOM   2116  CD1 ILE B 114      36.251  19.271  16.045  1.00 45.44           C  
ATOM   2117  N   SER B 115      39.771  22.084  13.793  1.00 48.85           N  
ATOM   2118  CA  SER B 115      40.644  23.029  13.077  1.00 46.83           C  
ATOM   2119  C   SER B 115      39.881  24.243  12.559  1.00 46.83           C  
ATOM   2120  O   SER B 115      38.689  24.153  12.227  1.00 47.02           O  
ATOM   2121  CB  SER B 115      41.383  22.338  11.939  1.00 45.70           C  
ATOM   2122  OG  SER B 115      42.325  21.427  12.467  1.00 47.94           O  
ATOM   2123  N   TYR B 116      40.592  25.378  12.534  1.00 47.06           N  
ATOM   2124  CA  TYR B 116      40.078  26.694  12.105  1.00 47.05           C  
ATOM   2125  C   TYR B 116      41.200  27.419  11.376  1.00 44.39           C  
ATOM   2126  O   TYR B 116      42.380  27.111  11.590  1.00 43.11           O  
ATOM   2127  CB  TYR B 116      39.715  27.588  13.323  1.00 49.60           C  
ATOM   2128  CG  TYR B 116      38.999  26.895  14.466  1.00 52.36           C  
ATOM   2129  CD1 TYR B 116      39.716  26.100  15.384  1.00 55.12           C  
ATOM   2130  CD2 TYR B 116      37.617  27.042  14.653  1.00 52.61           C  
ATOM   2131  CE1 TYR B 116      39.068  25.433  16.441  1.00 57.73           C  
ATOM   2132  CE2 TYR B 116      36.952  26.393  15.717  1.00 56.41           C  
ATOM   2133  CZ  TYR B 116      37.683  25.584  16.608  1.00 58.59           C  
ATOM   2134  OH  TYR B 116      37.049  24.940  17.667  1.00 61.58           O  
ATOM   2135  N   SER B 117      40.834  28.389  10.537  1.00 41.75           N  
ATOM   2136  CA  SER B 117      41.821  29.297   9.963  1.00 40.46           C  
ATOM   2137  C   SER B 117      42.181  30.256  11.101  1.00 40.23           C  
ATOM   2138  O   SER B 117      41.441  30.367  12.083  1.00 41.86           O  
ATOM   2139  CB  SER B 117      41.284  30.073   8.753  1.00 40.29           C  
ATOM   2140  OG  SER B 117      40.297  31.025   9.091  1.00 39.55           O  
ATOM   2141  N   ARG B 118      43.294  30.964  10.996  1.00 39.86           N  
ATOM   2142  CA  ARG B 118      43.634  31.920  12.050  1.00 38.22           C  
ATOM   2143  C   ARG B 118      42.572  33.006  12.181  1.00 36.70           C  
ATOM   2144  O   ARG B 118      42.229  33.367  13.307  1.00 38.05           O  
ATOM   2145  CB  ARG B 118      45.012  32.521  11.870  1.00 38.68           C  
ATOM   2146  CG  ARG B 118      46.119  31.502  12.015  1.00 41.09           C  
ATOM   2147  CD  ARG B 118      47.256  32.131  12.744  1.00 45.19           C  
ATOM   2148  NE  ARG B 118      48.406  31.251  12.861  1.00 45.22           N  
ATOM   2149  CZ  ARG B 118      49.470  31.256  12.062  1.00 43.23           C  
ATOM   2150  NH1 ARG B 118      49.566  32.068  11.013  1.00 43.74           N  
ATOM   2151  NH2 ARG B 118      50.450  30.401  12.317  1.00 46.19           N  
ATOM   2152  N   PHE B 119      42.030  33.488  11.056  1.00 36.42           N  
ATOM   2153  CA  PHE B 119      40.960  34.490  11.092  1.00 36.79           C  
ATOM   2154  C   PHE B 119      39.685  33.938  11.738  1.00 36.34           C  
ATOM   2155  O   PHE B 119      39.082  34.608  12.567  1.00 35.44           O  
ATOM   2156  CB  PHE B 119      40.624  35.066   9.726  1.00 36.51           C  
ATOM   2157  CG  PHE B 119      39.672  36.222   9.805  1.00 36.48           C  
ATOM   2158  CD1 PHE B 119      40.145  37.504  10.108  1.00 37.81           C  
ATOM   2159  CD2 PHE B 119      38.296  36.036   9.617  1.00 36.17           C  
ATOM   2160  CE1 PHE B 119      39.266  38.590  10.207  1.00 32.89           C  
ATOM   2161  CE2 PHE B 119      37.404  37.113   9.712  1.00 33.50           C  
ATOM   2162  CZ  PHE B 119      37.890  38.402  10.003  1.00 36.75           C  
ATOM   2163  N   GLU B 120      39.284  32.734  11.339  1.00 38.37           N  
ATOM   2164  CA  GLU B 120      38.137  32.049  11.959  1.00 40.90           C  
ATOM   2165  C   GLU B 120      38.303  31.931  13.468  1.00 39.42           C  
ATOM   2166  O   GLU B 120      37.352  32.169  14.204  1.00 41.70           O  
ATOM   2167  CB  GLU B 120      37.931  30.650  11.358  1.00 41.29           C  
ATOM   2168  CG  GLU B 120      37.306  30.673   9.968  1.00 46.21           C  
ATOM   2169  CD  GLU B 120      37.427  29.365   9.211  1.00 45.26           C  
ATOM   2170  OE1 GLU B 120      37.778  28.322   9.808  1.00 56.08           O  
ATOM   2171  OE2 GLU B 120      37.171  29.394   7.987  1.00 60.27           O  
ATOM   2172  N   TRP B 121      39.506  31.572  13.917  1.00 39.06           N  
ATOM   2173  CA  TRP B 121      39.779  31.449  15.350  1.00 38.85           C  
ATOM   2174  C   TRP B 121      39.680  32.824  16.064  1.00 35.28           C  
ATOM   2175  O   TRP B 121      39.188  32.892  17.186  1.00 32.76           O  
ATOM   2176  CB  TRP B 121      41.107  30.703  15.626  1.00 42.77           C  
ATOM   2177  CG  TRP B 121      41.311  30.504  17.075  1.00 46.10           C  
ATOM   2178  CD1 TRP B 121      42.168  31.196  17.871  1.00 49.07           C  
ATOM   2179  CD2 TRP B 121      40.561  29.638  17.942  1.00 50.05           C  
ATOM   2180  NE1 TRP B 121      42.046  30.786  19.174  1.00 49.53           N  
ATOM   2181  CE2 TRP B 121      41.062  29.836  19.258  1.00 49.42           C  
ATOM   2182  CE3 TRP B 121      39.540  28.693  17.737  1.00 49.07           C  
ATOM   2183  CZ2 TRP B 121      40.573  29.131  20.374  1.00 46.50           C  
ATOM   2184  CZ3 TRP B 121      39.041  27.982  18.861  1.00 49.51           C  
ATOM   2185  CH2 TRP B 121      39.567  28.211  20.158  1.00 49.17           C  
ATOM   2186  N   LEU B 122      40.091  33.909  15.406  1.00 30.67           N  
ATOM   2187  CA  LEU B 122      39.942  35.239  15.988  1.00 29.72           C  
ATOM   2188  C   LEU B 122      38.460  35.538  16.239  1.00 29.99           C  
ATOM   2189  O   LEU B 122      38.121  36.107  17.277  1.00 33.37           O  
ATOM   2190  CB  LEU B 122      40.550  36.343  15.104  1.00 30.01           C  
ATOM   2191  CG  LEU B 122      40.469  37.806  15.567  1.00 30.16           C  
ATOM   2192  CD1 LEU B 122      41.136  38.052  16.922  1.00 29.81           C  
ATOM   2193  CD2 LEU B 122      41.065  38.729  14.453  1.00 23.90           C  
ATOM   2194  N   LEU B 123      37.599  35.156  15.295  1.00 30.11           N  
ATOM   2195  CA  LEU B 123      36.148  35.345  15.437  1.00 31.40           C  
ATOM   2196  C   LEU B 123      35.579  34.467  16.569  1.00 32.06           C  
ATOM   2197  O   LEU B 123      34.617  34.855  17.223  1.00 32.45           O  
ATOM   2198  CB  LEU B 123      35.428  35.084  14.109  1.00 31.94           C  
ATOM   2199  CG  LEU B 123      35.841  35.976  12.923  1.00 31.88           C  
ATOM   2200  CD1 LEU B 123      34.959  35.642  11.719  1.00 31.65           C  
ATOM   2201  CD2 LEU B 123      35.798  37.479  13.268  1.00 31.91           C  
ATOM   2202  N   GLU B 124      36.175  33.296  16.777  1.00 32.67           N  
ATOM   2203  CA  GLU B 124      35.818  32.419  17.932  1.00 35.09           C  
ATOM   2204  C   GLU B 124      36.225  33.060  19.252  1.00 34.63           C  
ATOM   2205  O   GLU B 124      35.524  32.854  20.218  1.00 34.02           O  
ATOM   2206  CB  GLU B 124      36.440  31.029  17.825  1.00 32.28           C  
ATOM   2207  CG  GLU B 124      35.808  30.148  16.766  1.00 39.93           C  
ATOM   2208  CD  GLU B 124      34.492  29.512  17.188  1.00 47.28           C  
ATOM   2209  OE1 GLU B 124      34.421  28.961  18.304  1.00 46.55           O  
ATOM   2210  OE2 GLU B 124      33.546  29.519  16.374  1.00 57.83           O  
ATOM   2211  N   ILE B 125      37.330  33.833  19.285  1.00 36.15           N  
ATOM   2212  CA  ILE B 125      37.763  34.548  20.518  1.00 36.43           C  
ATOM   2213  C   ILE B 125      36.727  35.609  20.836  1.00 35.41           C  
ATOM   2214  O   ILE B 125      36.323  35.756  21.981  1.00 35.61           O  
ATOM   2215  CB  ILE B 125      39.165  35.309  20.445  1.00 36.31           C  
ATOM   2216  CG1 ILE B 125      40.316  34.481  19.869  1.00 39.08           C  
ATOM   2217  CG2 ILE B 125      39.552  35.832  21.809  1.00 35.75           C  
ATOM   2218  CD1 ILE B 125      40.290  33.104  20.266  1.00 47.26           C  
ATOM   2219  N   VAL B 126      36.346  36.370  19.810  1.00 35.32           N  
ATOM   2220  CA  VAL B 126      35.321  37.396  19.933  1.00 34.84           C  
ATOM   2221  C   VAL B 126      34.003  36.785  20.469  1.00 34.31           C  
ATOM   2222  O   VAL B 126      33.442  37.287  21.419  1.00 33.59           O  
ATOM   2223  CB  VAL B 126      35.080  38.127  18.579  1.00 35.48           C  
ATOM   2224  CG1 VAL B 126      33.878  39.074  18.674  1.00 36.91           C  
ATOM   2225  CG2 VAL B 126      36.357  38.887  18.141  1.00 31.37           C  
ATOM   2226  N   ALA B 127      33.544  35.698  19.864  1.00 34.43           N  
ATOM   2227  CA  ALA B 127      32.319  35.020  20.307  1.00 35.75           C  
ATOM   2228  C   ALA B 127      32.425  34.515  21.774  1.00 37.65           C  
ATOM   2229  O   ALA B 127      31.501  34.710  22.569  1.00 39.50           O  
ATOM   2230  CB  ALA B 127      31.980  33.871  19.352  1.00 34.13           C  
ATOM   2231  N   HIS B 128      33.562  33.882  22.097  1.00 38.44           N  
ATOM   2232  CA  HIS B 128      33.917  33.351  23.440  1.00 37.39           C  
ATOM   2233  C   HIS B 128      33.834  34.464  24.485  1.00 34.55           C  
ATOM   2234  O   HIS B 128      33.187  34.305  25.526  1.00 32.46           O  
ATOM   2235  CB  HIS B 128      35.373  32.806  23.391  1.00 40.88           C  
ATOM   2236  CG  HIS B 128      35.837  32.015  24.585  1.00 46.78           C  
ATOM   2237  ND1 HIS B 128      36.785  31.021  24.459  1.00 57.51           N  
ATOM   2238  CD2 HIS B 128      35.505  32.043  25.902  1.00 53.60           C  
ATOM   2239  CE1 HIS B 128      37.031  30.490  25.644  1.00 60.51           C  
ATOM   2240  NE2 HIS B 128      36.265  31.088  26.537  1.00 53.57           N  
ATOM   2241  N   PHE B 129      34.472  35.593  24.192  1.00 28.03           N  
ATOM   2242  CA  PHE B 129      34.525  36.716  25.111  1.00 26.28           C  
ATOM   2243  C   PHE B 129      33.152  37.334  25.333  1.00 26.15           C  
ATOM   2244  O   PHE B 129      32.793  37.598  26.471  1.00 30.86           O  
ATOM   2245  CB  PHE B 129      35.521  37.795  24.614  1.00 27.03           C  
ATOM   2246  CG  PHE B 129      35.971  38.750  25.691  1.00 24.88           C  
ATOM   2247  CD1 PHE B 129      35.133  39.766  26.155  1.00 28.24           C  
ATOM   2248  CD2 PHE B 129      37.253  38.650  26.230  1.00 33.55           C  
ATOM   2249  CE1 PHE B 129      35.556  40.639  27.145  1.00 28.95           C  
ATOM   2250  CE2 PHE B 129      37.687  39.527  27.235  1.00 30.05           C  
ATOM   2251  CZ  PHE B 129      36.845  40.513  27.691  1.00 26.30           C  
ATOM   2252  N   TYR B 130      32.400  37.599  24.262  1.00 25.47           N  
ATOM   2253  CA  TYR B 130      31.053  38.148  24.390  1.00 25.40           C  
ATOM   2254  C   TYR B 130      30.094  37.128  25.069  1.00 29.30           C  
ATOM   2255  O   TYR B 130      29.233  37.528  25.853  1.00 29.47           O  
ATOM   2256  CB  TYR B 130      30.503  38.631  23.041  1.00 28.65           C  
ATOM   2257  CG  TYR B 130      31.018  40.024  22.640  1.00 24.12           C  
ATOM   2258  CD1 TYR B 130      30.335  41.161  23.044  1.00 27.47           C  
ATOM   2259  CD2 TYR B 130      32.173  40.193  21.873  1.00 33.02           C  
ATOM   2260  CE1 TYR B 130      30.793  42.472  22.704  1.00 36.53           C  
ATOM   2261  CE2 TYR B 130      32.641  41.498  21.506  1.00 28.21           C  
ATOM   2262  CZ  TYR B 130      31.941  42.623  21.940  1.00 28.39           C  
ATOM   2263  OH  TYR B 130      32.358  43.904  21.607  1.00 37.89           O  
ATOM   2264  N   HIS B 131      30.254  35.836  24.784  1.00 27.40           N  
ATOM   2265  CA  HIS B 131      29.396  34.811  25.407  1.00 31.43           C  
ATOM   2266  C   HIS B 131      29.610  34.909  26.900  1.00 30.74           C  
ATOM   2267  O   HIS B 131      28.686  35.240  27.609  1.00 34.19           O  
ATOM   2268  CB  HIS B 131      29.723  33.412  24.887  1.00 30.39           C  
ATOM   2269  CG  HIS B 131      28.848  32.332  25.439  1.00 37.79           C  
ATOM   2270  ND1 HIS B 131      27.682  31.935  24.819  1.00 43.29           N  
ATOM   2271  CD2 HIS B 131      28.987  31.543  26.532  1.00 36.56           C  
ATOM   2272  CE1 HIS B 131      27.136  30.951  25.515  1.00 47.42           C  
ATOM   2273  NE2 HIS B 131      27.906  30.697  26.560  1.00 43.02           N  
ATOM   2274  N   HIS B 132      30.853  34.751  27.336  1.00 33.15           N  
ATOM   2275  CA  HIS B 132      31.209  34.803  28.754  1.00 36.23           C  
ATOM   2276  C   HIS B 132      30.923  36.138  29.440  1.00 35.17           C  
ATOM   2277  O   HIS B 132      30.521  36.145  30.592  1.00 31.84           O  
ATOM   2278  CB  HIS B 132      32.657  34.314  28.963  1.00 40.05           C  
ATOM   2279  CG  HIS B 132      32.808  32.826  28.794  1.00 47.70           C  
ATOM   2280  ND1 HIS B 132      32.534  32.184  27.605  1.00 53.61           N  
ATOM   2281  CD2 HIS B 132      33.181  31.857  29.663  1.00 57.00           C  
ATOM   2282  CE1 HIS B 132      32.737  30.886  27.748  1.00 54.26           C  
ATOM   2283  NE2 HIS B 132      33.133  30.662  28.985  1.00 53.99           N  
ATOM   2284  N   ARG B 133      31.125  37.255  28.737  1.00 37.24           N  
ATOM   2285  CA  ARG B 133      30.787  38.587  29.263  1.00 37.31           C  
ATOM   2286  C   ARG B 133      29.270  38.706  29.457  1.00 35.84           C  
ATOM   2287  O   ARG B 133      28.834  39.374  30.389  1.00 37.88           O  
ATOM   2288  CB  ARG B 133      31.354  39.698  28.348  1.00 38.19           C  
ATOM   2289  CG  ARG B 133      30.919  41.150  28.607  1.00 39.96           C  
ATOM   2290  CD  ARG B 133      31.572  42.070  27.541  1.00 45.80           C  
ATOM   2291  NE  ARG B 133      31.007  43.427  27.446  1.00 54.53           N  
ATOM   2292  CZ  ARG B 133      30.084  43.846  26.564  1.00 63.36           C  
ATOM   2293  NH1 ARG B 133      29.537  43.034  25.655  1.00 69.41           N  
ATOM   2294  NH2 ARG B 133      29.675  45.121  26.594  1.00 71.37           N  
ATOM   2295  N   GLY B 134      28.486  38.063  28.583  1.00 33.81           N  
ATOM   2296  CA  GLY B 134      27.040  38.027  28.684  1.00 33.06           C  
ATOM   2297  C   GLY B 134      26.544  37.200  29.870  1.00 33.53           C  
ATOM   2298  O   GLY B 134      25.567  37.571  30.503  1.00 34.94           O  
ATOM   2299  N   GLN B 135      27.197  36.079  30.155  1.00 34.20           N  
ATOM   2300  CA  GLN B 135      26.869  35.237  31.339  1.00 35.01           C  
ATOM   2301  C   GLN B 135      27.030  36.052  32.630  1.00 37.89           C  
ATOM   2302  O   GLN B 135      26.140  36.069  33.484  1.00 37.03           O  
ATOM   2303  CB  GLN B 135      27.799  34.016  31.413  1.00 34.00           C  
ATOM   2304  CG  GLN B 135      27.552  32.949  30.348  1.00 33.23           C  
ATOM   2305  CD  GLN B 135      28.508  31.759  30.433  1.00 32.17           C  
ATOM   2306  OE1 GLN B 135      29.444  31.733  31.220  1.00 39.69           O  
ATOM   2307  NE2 GLN B 135      28.280  30.781  29.590  1.00 44.62           N  
ATOM   2308  N   ILE B 136      28.173  36.733  32.732  1.00 41.22           N  
ATOM   2309  CA  ILE B 136      28.499  37.602  33.858  1.00 43.49           C  
ATOM   2310  C   ILE B 136      27.494  38.757  33.958  1.00 45.67           C  
ATOM   2311  O   ILE B 136      26.934  38.985  35.024  1.00 47.17           O  
ATOM   2312  CB  ILE B 136      29.959  38.178  33.754  1.00 43.48           C  
ATOM   2313  CG1 ILE B 136      30.999  37.062  33.921  1.00 40.37           C  
ATOM   2314  CG2 ILE B 136      30.210  39.269  34.813  1.00 40.35           C  
ATOM   2315  CD1 ILE B 136      32.433  37.494  33.629  1.00 42.54           C  
ATOM   2316  N   HIS B 137      27.260  39.448  32.842  1.00 47.74           N  
ATOM   2317  CA  HIS B 137      26.349  40.603  32.788  1.00 48.91           C  
ATOM   2318  C   HIS B 137      24.943  40.347  33.352  1.00 49.55           C  
ATOM   2319  O   HIS B 137      24.431  41.172  34.106  1.00 51.02           O  
ATOM   2320  CB  HIS B 137      26.245  41.142  31.358  1.00 49.82           C  
ATOM   2321  CG  HIS B 137      25.295  42.294  31.214  1.00 53.38           C  
ATOM   2322  ND1 HIS B 137      23.966  42.124  30.895  1.00 54.62           N  
ATOM   2323  CD2 HIS B 137      25.476  43.625  31.378  1.00 54.76           C  
ATOM   2324  CE1 HIS B 137      23.374  43.303  30.845  1.00 55.69           C  
ATOM   2325  NE2 HIS B 137      24.269  44.230  31.136  1.00 54.25           N  
ATOM   2326  N   ILE B 138      24.335  39.221  32.986  1.00 49.62           N  
ATOM   2327  CA  ILE B 138      22.987  38.882  33.460  1.00 49.06           C  
ATOM   2328  C   ILE B 138      22.996  38.457  34.937  1.00 49.90           C  
ATOM   2329  O   ILE B 138      22.033  38.732  35.646  1.00 51.60           O  
ATOM   2330  CB  ILE B 138      22.307  37.814  32.555  1.00 48.83           C  
ATOM   2331  CG1 ILE B 138      20.779  37.818  32.713  1.00 47.83           C  
ATOM   2332  CG2 ILE B 138      22.903  36.427  32.757  1.00 45.23           C  
ATOM   2333  CD1 ILE B 138      20.117  39.043  32.124  1.00 46.10           C  
ATOM   2334  N   LEU B 139      24.056  37.778  35.388  1.00 50.29           N  
ATOM   2335  CA  LEU B 139      24.195  37.400  36.807  1.00 50.44           C  
ATOM   2336  C   LEU B 139      24.326  38.664  37.657  1.00 50.59           C  
ATOM   2337  O   LEU B 139      23.824  38.689  38.777  1.00 49.64           O  
ATOM   2338  CB  LEU B 139      25.389  36.455  37.066  1.00 51.00           C  
ATOM   2339  CG  LEU B 139      25.357  35.006  36.560  1.00 49.49           C  
ATOM   2340  CD2 LEU B 139      24.139  34.255  37.090  1.00 48.27           C  
ATOM   2341  N   LEU B 140      24.983  39.701  37.116  1.00 51.39           N  
ATOM   2342  CA  LEU B 140      25.113  41.007  37.791  1.00 52.42           C  
ATOM   2343  C   LEU B 140      23.753  41.706  37.915  1.00 54.01           C  
ATOM   2344  O   LEU B 140      23.405  42.144  38.999  1.00 56.83           O  
ATOM   2345  CB  LEU B 140      26.138  41.924  37.092  1.00 51.47           C  
ATOM   2346  CG  LEU B 140      27.618  41.522  37.182  1.00 50.65           C  
ATOM   2347  CD1 LEU B 140      28.479  42.437  36.317  1.00 48.77           C  
ATOM   2348  CD2 LEU B 140      28.112  41.522  38.628  1.00 52.02           C  
ATOM   2349  N   CYS B 141      22.990  41.795  36.828  1.00 54.95           N  
ATOM   2350  CA  CYS B 141      21.631  42.376  36.865  1.00 55.97           C  
ATOM   2351  C   CYS B 141      20.650  41.610  37.778  1.00 58.28           C  
ATOM   2352  O   CYS B 141      19.742  42.214  38.351  1.00 59.16           O  
ATOM   2353  CB  CYS B 141      21.021  42.404  35.469  1.00 55.37           C  
ATOM   2354  SG  CYS B 141      21.950  43.313  34.277  1.00 57.89           S  
ATOM   2355  N   GLU B 142      20.846  40.295  37.896  1.00 60.61           N  
ATOM   2356  CA  GLU B 142      19.980  39.405  38.694  1.00 62.78           C  
ATOM   2357  C   GLU B 142      20.234  39.392  40.211  1.00 64.75           C  
ATOM   2358  O   GLU B 142      19.271  39.359  40.984  1.00 64.87           O  
ATOM   2359  CB  GLU B 142      20.048  37.961  38.139  1.00 63.17           C  
ATOM   2360  CG  GLU B 142      19.222  37.730  36.852  1.00 64.66           C  
ATOM   2361  CD  GLU B 142      17.725  37.553  37.122  1.00 64.38           C  
ATOM   2362  OE1 GLU B 142      17.366  36.724  37.981  1.00 66.21           O  
ATOM   2363  OE2 GLU B 142      16.901  38.218  36.463  1.00 65.58           O  
ATOM   2364  N   HIS B 143      21.508  39.407  40.620  1.00 66.66           N  
ATOM   2365  CA  HIS B 143      21.923  39.301  42.046  1.00 67.38           C  
ATOM   2366  C   HIS B 143      22.691  40.498  42.652  1.00 68.89           C  
ATOM   2367  O   HIS B 143      23.041  40.471  43.834  1.00 68.42           O  
ATOM   2368  CB  HIS B 143      22.778  38.043  42.204  1.00 66.83           C  
ATOM   2369  CG  HIS B 143      22.172  36.825  41.582  1.00 66.59           C  
ATOM   2370  ND1 HIS B 143      22.484  36.414  40.307  1.00 70.80           N  
ATOM   2371  CD2 HIS B 143      21.250  35.948  42.044  1.00 71.15           C  
ATOM   2372  CE1 HIS B 143      21.793  35.325  40.015  1.00 71.90           C  
ATOM   2373  NE2 HIS B 143      21.036  35.021  41.052  1.00 67.20           N  
HETATM 2374  N   MSE B 144      22.949  41.522  41.845  1.00 71.38           N  
HETATM 2375  CA  MSE B 144      23.688  42.723  42.242  1.00 73.57           C  
HETATM 2376  C   MSE B 144      23.028  43.954  41.600  1.00 74.38           C  
HETATM 2377  O   MSE B 144      21.906  43.854  41.094  1.00 74.68           O  
HETATM 2378  CB  MSE B 144      25.156  42.557  41.787  1.00 75.16           C  
HETATM 2379  CG  MSE B 144      26.013  41.643  42.635  1.00 79.43           C  
HETATM 2380 SE   MSE B 144      26.201  42.297  44.473  0.75103.50          SE  
HETATM 2381  CE  MSE B 144      26.678  44.187  44.193  1.00 88.54           C  
ATOM   2382  N   LYS B 145      23.681  45.115  41.667  1.00 76.02           N  
ATOM   2383  CA  LYS B 145      23.205  46.308  40.961  1.00 77.96           C  
ATOM   2384  C   LYS B 145      23.414  46.127  39.437  1.00 78.98           C  
ATOM   2385  O   LYS B 145      24.333  45.426  39.001  1.00 78.17           O  
ATOM   2386  CB  LYS B 145      23.928  47.571  41.453  1.00 78.17           C  
ATOM   2387  N   ASP B 146      22.539  46.748  38.650  1.00 79.57           N  
ATOM   2388  CA  ASP B 146      22.605  46.721  37.186  1.00 80.60           C  
ATOM   2389  C   ASP B 146      23.761  47.675  36.774  1.00 81.49           C  
ATOM   2390  O   ASP B 146      23.757  48.835  37.191  1.00 81.99           O  
ATOM   2391  CB  ASP B 146      21.245  47.200  36.632  1.00 79.91           C  
ATOM   2392  CG  ASP B 146      21.070  46.985  35.130  1.00 78.49           C  
ATOM   2393  OD1 ASP B 146      22.026  47.132  34.340  1.00 77.20           O  
ATOM   2394  OD2 ASP B 146      19.920  46.704  34.731  1.00 72.20           O  
ATOM   2395  N   PRO B 147      24.755  47.202  35.977  1.00 82.57           N  
ATOM   2396  CA  PRO B 147      25.859  48.080  35.517  1.00 83.67           C  
ATOM   2397  C   PRO B 147      25.452  48.903  34.271  1.00 85.28           C  
ATOM   2398  O   PRO B 147      24.254  49.013  33.988  1.00 85.73           O  
ATOM   2399  CB  PRO B 147      26.960  47.070  35.195  1.00 83.68           C  
ATOM   2400  CG  PRO B 147      26.210  45.894  34.672  1.00 82.80           C  
ATOM   2401  CD  PRO B 147      24.921  45.832  35.454  1.00 82.32           C  
ATOM   2402  N   ASN B 148      26.415  49.529  33.576  1.00 86.83           N  
ATOM   2403  CA  ASN B 148      26.156  50.274  32.314  1.00 86.97           C  
ATOM   2404  C   ASN B 148      27.231  50.049  31.226  1.00 87.01           C  
ATOM   2405  O   ASN B 148      28.421  50.295  31.474  1.00 86.83           O  
ATOM   2406  CB  ASN B 148      25.996  51.785  32.565  1.00 87.87           C  
ATOM   2407  CG  ASN B 148      24.665  52.142  33.228  1.00 90.67           C  
ATOM   2408  OD1 ASN B 148      23.786  52.729  32.591  1.00 94.03           O  
ATOM   2409  ND2 ASN B 148      24.507  51.776  34.496  1.00 91.89           N  
ATOM   2410  N   ILE B 149      26.792  49.584  30.044  1.00 86.24           N  
ATOM   2411  CA  ILE B 149      27.654  49.381  28.855  1.00 86.05           C  
ATOM   2412  C   ILE B 149      27.615  50.652  27.993  1.00 84.88           C  
ATOM   2413  O   ILE B 149      27.433  51.765  28.496  1.00 82.42           O  
ATOM   2414  CB  ILE B 149      27.206  48.134  27.996  1.00 86.61           C  
ATOM   2415  CG1 ILE B 149      27.347  46.832  28.805  1.00 87.11           C  
ATOM   2416  CG2 ILE B 149      28.007  48.029  26.667  1.00 85.06           C  
ATOM   2417  CD1 ILE B 149      26.854  45.567  28.080  1.00 85.32           C  
TER    2418      ILE B 149                                                      
END
MOLECULE T0481.pdb
ATOM   1157  N   ASN     5      43.757  48.627  12.993  1.00 48.55           N  
ATOM   1158  CA  ASN     5      43.707  47.221  13.486  1.00 48.66           C  
ATOM   1159  C   ASN     5      42.297  46.854  13.970  1.00 46.10           C  
ATOM   1160  O   ASN     5      41.931  47.131  15.124  1.00 45.32           O  
ATOM   1161  CB  ASN     5      44.739  47.032  14.610  1.00 49.92           C  
ATOM   1162  CG  ASN     5      45.105  45.561  14.854  1.00 51.98           C  
ATOM   1163  OD1 ASN     5      44.378  44.628  14.479  1.00 41.03           O  
ATOM   1164  ND2 ASN     5      46.252  45.360  15.496  1.00 51.86           N  
ATOM   1165  N   GLN     6      41.522  46.221  13.081  1.00 42.89           N  
ATOM   1166  CA  GLN     6      40.122  45.866  13.363  1.00 39.86           C  
ATOM   1167  C   GLN     6      39.972  44.674  14.322  1.00 37.64           C  
ATOM   1168  O   GLN     6      38.948  44.545  14.985  1.00 37.24           O  
ATOM   1169  CB  GLN     6      39.363  45.603  12.059  1.00 39.17           C  
ATOM   1170  N   ILE     7      40.983  43.809  14.403  1.00 34.88           N  
ATOM   1171  CA  ILE     7      40.937  42.694  15.353  1.00 34.40           C  
ATOM   1172  C   ILE     7      41.043  43.194  16.799  1.00 31.45           C  
ATOM   1173  O   ILE     7      40.216  42.843  17.643  1.00 29.10           O  
ATOM   1174  CB  ILE     7      42.038  41.634  15.082  1.00 34.24           C  
ATOM   1175  CG1 ILE     7      41.687  40.792  13.849  1.00 35.88           C  
ATOM   1176  CG2 ILE     7      42.186  40.712  16.271  1.00 34.37           C  
ATOM   1177  CD1 ILE     7      42.783  39.803  13.446  1.00 36.32           C  
ATOM   1178  N   VAL     8      42.071  44.003  17.067  1.00 31.23           N  
ATOM   1179  CA  VAL     8      42.289  44.610  18.384  1.00 29.82           C  
ATOM   1180  C   VAL     8      41.107  45.490  18.755  1.00 29.64           C  
ATOM   1181  O   VAL     8      40.544  45.353  19.832  1.00 30.66           O  
ATOM   1182  CB  VAL     8      43.589  45.453  18.418  1.00 29.55           C  
ATOM   1183  CG1 VAL     8      43.562  46.438  19.575  1.00 30.78           C  
ATOM   1184  CG2 VAL     8      44.817  44.553  18.513  1.00 26.78           C  
ATOM   1185  N   SER     9      40.726  46.377  17.846  1.00 30.09           N  
ATOM   1186  CA  SER     9      39.600  47.287  18.059  1.00 30.85           C  
ATOM   1187  C   SER     9      38.300  46.564  18.423  1.00 29.88           C  
ATOM   1188  O   SER     9      37.633  46.922  19.394  1.00 30.15           O  
ATOM   1189  CB  SER     9      39.382  48.137  16.796  1.00 31.43           C  
ATOM   1190  OG  SER     9      38.309  49.037  16.971  1.00 34.73           O  
ATOM   1191  N   HIS    10      37.946  45.552  17.640  1.00 29.62           N  
ATOM   1192  CA  HIS    10      36.728  44.774  17.872  1.00 29.21           C  
ATOM   1193  C   HIS    10      36.770  43.988  19.188  1.00 27.89           C  
ATOM   1194  O   HIS    10      35.747  43.834  19.863  1.00 27.83           O  
ATOM   1195  CB  HIS    10      36.453  43.833  16.696  1.00 29.11           C  
ATOM   1196  CG  HIS    10      35.127  43.131  16.782  1.00 30.96           C  
ATOM   1197  ND1 HIS    10      34.991  41.773  16.582  1.00 29.81           N  
ATOM   1198  CD2 HIS    10      33.882  43.596  17.055  1.00 32.11           C  
ATOM   1199  CE1 HIS    10      33.723  41.432  16.721  1.00 34.31           C  
ATOM   1200  NE2 HIS    10      33.025  42.520  17.004  1.00 31.48           N  
ATOM   1201  N   PHE    11      37.946  43.490  19.545  1.00 26.50           N  
ATOM   1202  CA  PHE    11      38.144  42.846  20.847  1.00 25.86           C  
ATOM   1203  C   PHE    11      37.899  43.833  22.005  1.00 25.41           C  
ATOM   1204  O   PHE    11      37.131  43.543  22.922  1.00 26.59           O  
ATOM   1205  CB  PHE    11      39.561  42.251  20.931  1.00 25.87           C  
ATOM   1206  CG  PHE    11      39.978  41.854  22.325  1.00 23.85           C  
ATOM   1207  CD1 PHE    11      39.402  40.765  22.948  1.00 23.40           C  
ATOM   1208  CD2 PHE    11      40.940  42.587  23.009  1.00 24.43           C  
ATOM   1209  CE1 PHE    11      39.769  40.403  24.233  1.00 24.62           C  
ATOM   1210  CE2 PHE    11      41.331  42.230  24.298  1.00 26.60           C  
ATOM   1211  CZ  PHE    11      40.751  41.136  24.910  1.00 25.39           C  
ATOM   1212  N   LEU    12      38.558  44.993  21.960  1.00 25.19           N  
ATOM   1213  CA  LEU    12      38.433  46.000  23.024  1.00 24.40           C  
ATOM   1214  C   LEU    12      37.013  46.571  23.154  1.00 24.37           C  
ATOM   1215  O   LEU    12      36.551  46.899  24.244  1.00 23.55           O  
ATOM   1216  CB  LEU    12      39.429  47.127  22.787  1.00 25.08           C  
ATOM   1217  CG  LEU    12      40.903  46.732  22.935  1.00 23.88           C  
ATOM   1218  CD1 LEU    12      41.772  47.927  22.675  1.00 19.99           C  
ATOM   1219  CD2 LEU    12      41.172  46.151  24.314  1.00 17.50           C  
ATOM   1220  N   SER    13      36.345  46.698  22.018  1.00 24.35           N  
ATOM   1221  CA  SER    13      34.937  47.074  21.945  1.00 24.92           C  
ATOM   1222  C   SER    13      34.094  46.327  22.991  1.00 25.13           C  
ATOM   1223  O   SER    13      33.214  46.894  23.629  1.00 27.77           O  
ATOM   1224  CB  SER    13      34.440  46.723  20.541  1.00 25.22           C  
ATOM   1225  OG  SER    13      33.092  47.020  20.376  1.00 26.42           O  
ATOM   1226  N   HIS    14      34.392  45.046  23.150  1.00 24.32           N  
ATOM   1227  CA  HIS    14      33.720  44.177  24.093  1.00 23.44           C  
ATOM   1228  C   HIS    14      34.479  44.063  25.424  1.00 22.45           C  
ATOM   1229  O   HIS    14      33.887  44.226  26.488  1.00 22.95           O  
ATOM   1230  CB  HIS    14      33.528  42.795  23.455  1.00 23.60           C  
ATOM   1231  CG  HIS    14      32.468  42.759  22.397  1.00 22.55           C  
ATOM   1232  ND1 HIS    14      31.123  42.736  22.695  1.00 22.51           N  
ATOM   1233  CD2 HIS    14      32.554  42.716  21.047  1.00 24.07           C  
ATOM   1234  CE1 HIS    14      30.425  42.689  21.575  1.00 22.12           C  
ATOM   1235  NE2 HIS    14      31.270  42.672  20.559  1.00 23.74           N  
ATOM   1236  N   ARG    15      35.782  43.819  25.364  1.00 23.33           N  
ATOM   1237  CA  ARG    15      36.609  43.694  26.581  1.00 23.65           C  
ATOM   1238  C   ARG    15      36.617  44.947  27.474  1.00 24.04           C  
ATOM   1239  O   ARG    15      36.658  44.830  28.696  1.00 25.31           O  
ATOM   1240  CB  ARG    15      38.040  43.267  26.216  1.00 22.98           C  
ATOM   1241  CG  ARG    15      39.061  43.250  27.369  1.00 25.04           C  
ATOM   1242  CD  ARG    15      38.654  42.372  28.575  1.00 23.51           C  
ATOM   1243  NE  ARG    15      38.553  40.961  28.233  1.00 25.26           N  
ATOM   1244  CZ  ARG    15      39.583  40.124  28.141  1.00 29.21           C  
ATOM   1245  NH1 ARG    15      40.828  40.529  28.388  1.00 30.40           N  
ATOM   1246  NH2 ARG    15      39.358  38.857  27.809  1.00 26.91           N  
ATOM   1247  N   ASN    16      36.571  46.142  26.889  1.00 24.45           N  
ATOM   1248  CA  ASN    16      36.470  47.356  27.702  1.00 24.31           C  
ATOM   1249  C   ASN    16      35.182  47.388  28.527  1.00 24.67           C  
ATOM   1250  O   ASN    16      35.152  47.967  29.618  1.00 24.35           O  
ATOM   1251  CB  ASN    16      36.580  48.634  26.848  1.00 23.87           C  
ATOM   1252  CG  ASN    16      37.991  48.873  26.313  1.00 25.17           C  
ATOM   1253  OD1 ASN    16      38.980  48.416  26.887  1.00 27.85           O  
ATOM   1254  ND2 ASN    16      38.085  49.616  25.218  1.00 24.54           N  
ATOM   1255  N   VAL    17      34.112  46.792  28.005  1.00 25.32           N  
ATOM   1256  CA  VAL    17      32.845  46.739  28.750  1.00 25.14           C  
ATOM   1257  C   VAL    17      32.951  45.686  29.871  1.00 25.47           C  
ATOM   1258  O   VAL    17      32.466  45.898  30.980  1.00 24.38           O  
ATOM   1259  CB  VAL    17      31.636  46.485  27.807  1.00 25.11           C  
ATOM   1260  CG1 VAL    17      30.329  46.424  28.590  1.00 23.93           C  
ATOM   1261  CG2 VAL    17      31.567  47.563  26.732  1.00 21.19           C  
ATOM   1262  N   THR    18      33.621  44.570  29.581  1.00 26.85           N  
ATOM   1263  CA  THR    18      33.871  43.517  30.570  1.00 27.43           C  
ATOM   1264  C   THR    18      34.686  44.040  31.750  1.00 28.37           C  
ATOM   1265  O   THR    18      34.401  43.716  32.908  1.00 27.86           O  
ATOM   1266  CB  THR    18      34.631  42.343  29.937  1.00 26.46           C  
ATOM   1267  OG1 THR    18      33.758  41.641  29.047  1.00 28.22           O  
ATOM   1268  CG2 THR    18      35.153  41.393  31.005  1.00 26.76           C  
ATOM   1269  N   ASN    19      35.712  44.830  31.436  1.00 29.46           N  
ATOM   1270  CA  ASN    19      36.583  45.415  32.444  1.00 29.44           C  
ATOM   1271  C   ASN    19      35.877  46.449  33.302  1.00 31.03           C  
ATOM   1272  O   ASN    19      36.120  46.544  34.505  1.00 32.27           O  
ATOM   1273  CB  ASN    19      37.800  46.053  31.781  1.00 28.63           C  
ATOM   1274  CG  ASN    19      38.752  45.038  31.224  1.00 27.67           C  
ATOM   1275  OD1 ASN    19      38.698  43.849  31.561  1.00 29.89           O  
ATOM   1276  ND2 ASN    19      39.631  45.490  30.362  1.00 16.24           N  
ATOM   1277  N   GLU    20      35.009  47.226  32.673  1.00 32.85           N  
ATOM   1278  CA  GLU    20      34.197  48.215  33.378  1.00 34.98           C  
ATOM   1279  C   GLU    20      33.218  47.533  34.338  1.00 32.92           C  
ATOM   1280  O   GLU    20      33.018  47.999  35.451  1.00 35.00           O  
ATOM   1281  CB  GLU    20      33.450  49.089  32.369  1.00 34.33           C  
ATOM   1282  CG  GLU    20      32.885  50.367  32.951  1.00 41.33           C  
ATOM   1283  CD  GLU    20      32.241  51.269  31.906  1.00 41.71           C  
ATOM   1284  OE1 GLU    20      32.529  51.102  30.688  1.00 48.89           O  
ATOM   1285  OE2 GLU    20      31.448  52.149  32.316  1.00 50.11           O  
ATOM   1286  N   LEU    21      32.624  46.426  33.905  1.00 31.28           N  
ATOM   1287  CA  LEU    21      31.700  45.645  34.734  1.00 30.29           C  
ATOM   1288  C   LEU    21      32.414  44.977  35.915  1.00 30.39           C  
ATOM   1289  O   LEU    21      31.860  44.873  37.015  1.00 30.47           O  
ATOM   1290  CB  LEU    21      30.993  44.561  33.892  1.00 29.76           C  
ATOM   1291  CG  LEU    21      29.893  44.963  32.899  1.00 27.66           C  
ATOM   1292  CD1 LEU    21      29.501  43.764  32.026  1.00 22.19           C  
ATOM   1293  CD2 LEU    21      28.660  45.529  33.614  1.00 25.56           C  
ATOM   1294  N   ALA    22      33.635  44.512  35.672  1.00 30.64           N  
ATOM   1295  CA  ALA    22      34.460  43.895  36.710  1.00 31.48           C  
ATOM   1296  C   ALA    22      34.780  44.861  37.856  1.00 32.45           C  
ATOM   1297  O   ALA    22      34.888  44.450  39.016  1.00 31.11           O  
ATOM   1298  CB  ALA    22      35.755  43.354  36.098  1.00 31.19           C  
ATOM   1299  N   GLU    23      34.934  46.138  37.510  1.00 34.47           N  
ATOM   1300  CA  GLU    23      35.214  47.208  38.475  1.00 36.19           C  
ATOM   1301  C   GLU    23      34.053  47.424  39.453  1.00 35.68           C  
ATOM   1302  O   GLU    23      34.267  47.870  40.573  1.00 36.37           O  
ATOM   1303  CB  GLU    23      35.582  48.500  37.711  1.00 36.80           C  
ATOM   1304  CG  GLU    23      34.996  49.826  38.232  1.00 44.97           C  
ATOM   1305  CD  GLU    23      35.795  50.464  39.365  1.00 54.10           C  
ATOM   1306  OE1 GLU    23      37.029  50.243  39.444  1.00 58.36           O  
ATOM   1307  OE2 GLU    23      35.181  51.215  40.160  1.00 55.37           O  
ATOM   1308  N   LYS    24      32.837  47.095  39.020  1.00 35.78           N  
ATOM   1309  CA  LYS    24      31.630  47.243  39.828  1.00 36.00           C  
ATOM   1310  C   LYS    24      31.403  46.089  40.811  1.00 36.32           C  
ATOM   1311  O   LYS    24      30.399  46.071  41.524  1.00 37.08           O  
ATOM   1312  CB  LYS    24      30.411  47.385  38.910  1.00 36.20           C  
ATOM   1313  CG  LYS    24      30.488  48.628  38.038  1.00 37.65           C  
ATOM   1314  CD  LYS    24      29.127  49.070  37.532  1.00 40.50           C  
ATOM   1315  CE  LYS    24      29.157  50.541  37.089  1.00 46.04           C  
ATOM   1316  NZ  LYS    24      30.023  50.741  35.879  1.00 47.21           N  
ATOM   1317  N   ILE    25      32.337  45.138  40.840  1.00 35.88           N  
ATOM   1318  CA  ILE    25      32.294  43.987  41.733  1.00 35.06           C  
ATOM   1319  C   ILE    25      33.129  44.260  42.988  1.00 36.05           C  
ATOM   1320  O   ILE    25      34.364  44.186  42.953  1.00 35.12           O  
ATOM   1321  CB  ILE    25      32.851  42.718  41.022  1.00 34.99           C  
ATOM   1322  CG1 ILE    25      32.047  42.405  39.750  1.00 36.68           C  
ATOM   1323  CG2 ILE    25      32.848  41.515  41.959  1.00 34.29           C  
ATOM   1324  CD1 ILE    25      32.637  41.292  38.907  1.00 33.67           C  
ATOM   1325  N   SER    26      32.457  44.580  44.092  1.00 37.22           N  
ATOM   1326  CA  SER    26      33.128  44.736  45.383  1.00 38.56           C  
ATOM   1327  C   SER    26      33.758  43.410  45.786  1.00 40.35           C  
ATOM   1328  O   SER    26      33.334  42.354  45.310  1.00 41.06           O  
ATOM   1329  CB  SER    26      32.125  45.138  46.459  1.00 38.56           C  
ATOM   1330  OG  SER    26      31.263  44.055  46.775  1.00 37.07           O  
ATOM   1331  N   LYS    27      34.756  43.461  46.666  1.00 41.84           N  
ATOM   1332  CA  LYS    27      35.441  42.247  47.124  1.00 43.21           C  
ATOM   1333  C   LYS    27      34.509  41.312  47.910  1.00 42.45           C  
ATOM   1334  O   LYS    27      34.734  40.103  47.968  1.00 41.33           O  
ATOM   1335  CB  LYS    27      36.707  42.600  47.918  1.00 43.47           C  
ATOM   1336  CG  LYS    27      37.740  43.358  47.071  1.00 45.04           C  
ATOM   1337  CD  LYS    27      39.142  43.329  47.664  1.00 45.26           C  
ATOM   1338  CE  LYS    27      39.954  42.132  47.180  1.00 47.98           C  
ATOM   1339  NZ  LYS    27      40.646  42.396  45.885  1.00 44.46           N  
ATOM   1340  N   ASP    28      33.448  41.865  48.491  1.00 43.17           N  
ATOM   1341  CA  ASP    28      32.423  41.038  49.143  1.00 43.66           C  
ATOM   1342  C   ASP    28      31.589  40.274  48.109  1.00 42.08           C  
ATOM   1343  O   ASP    28      30.981  39.250  48.419  1.00 41.99           O  
ATOM   1344  CB  ASP    28      31.504  41.876  50.056  1.00 44.61           C  
ATOM   1345  CG  ASP    28      32.015  41.950  51.499  1.00 50.08           C  
ATOM   1346  OD1 ASP    28      32.189  40.877  52.115  1.00 52.94           O  
ATOM   1347  OD2 ASP    28      32.229  43.067  52.026  1.00 53.70           O  
ATOM   1348  N   HIS    29      31.575  40.767  46.875  1.00 40.09           N  
ATOM   1349  CA  HIS    29      30.784  40.157  45.813  1.00 38.00           C  
ATOM   1350  C   HIS    29      31.591  39.254  44.869  1.00 35.48           C  
ATOM   1351  O   HIS    29      31.047  38.750  43.891  1.00 34.55           O  
ATOM   1352  CB  HIS    29      30.051  41.241  45.014  1.00 37.73           C  
ATOM   1353  CG  HIS    29      28.769  41.692  45.637  1.00 38.39           C  
ATOM   1354  ND1 HIS    29      28.368  43.010  45.641  1.00 39.31           N  
ATOM   1355  CD2 HIS    29      27.793  40.999  46.267  1.00 39.76           C  
ATOM   1356  CE1 HIS    29      27.201  43.109  46.251  1.00 41.37           C  
ATOM   1357  NE2 HIS    29      26.830  41.903  46.639  1.00 41.73           N  
ATOM   1358  N   TYR    30      32.873  39.052  45.163  1.00 33.70           N  
ATOM   1359  CA  TYR    30      33.706  38.095  44.423  1.00 32.36           C  
ATOM   1360  C   TYR    30      33.079  36.686  44.430  1.00 32.70           C  
ATOM   1361  O   TYR    30      33.074  35.983  43.416  1.00 32.96           O  
ATOM   1362  CB  TYR    30      35.106  38.029  45.044  1.00 31.66           C  
ATOM   1363  CG  TYR    30      36.109  39.075  44.583  1.00 30.06           C  
ATOM   1364  CD1 TYR    30      35.708  40.312  44.111  1.00 29.10           C  
ATOM   1365  CD2 TYR    30      37.483  38.822  44.672  1.00 30.44           C  
ATOM   1366  CE1 TYR    30      36.643  41.265  43.700  1.00 29.51           C  
ATOM   1367  CE2 TYR    30      38.421  39.763  44.272  1.00 29.19           C  
ATOM   1368  CZ  TYR    30      37.999  40.983  43.786  1.00 31.71           C  
ATOM   1369  OH  TYR    30      38.933  41.930  43.389  1.00 31.55           O  
ATOM   1370  N   SER    31      32.546  36.289  45.586  1.00 32.70           N  
ATOM   1371  CA  SER    31      31.925  34.974  45.767  1.00 31.27           C  
ATOM   1372  C   SER    31      30.485  34.902  45.255  1.00 29.76           C  
ATOM   1373  O   SER    31      29.886  33.828  45.261  1.00 29.74           O  
ATOM   1374  CB  SER    31      31.904  34.639  47.255  1.00 31.47           C  
ATOM   1375  OG  SER    31      31.001  35.510  47.929  1.00 31.56           O  
ATOM   1376  N   TYR    32      29.923  36.031  44.826  1.00 29.31           N  
ATOM   1377  CA  TYR    32      28.493  36.105  44.518  1.00 28.85           C  
ATOM   1378  C   TYR    32      28.089  35.149  43.394  1.00 30.14           C  
ATOM   1379  O   TYR    32      28.698  35.128  42.324  1.00 31.63           O  
ATOM   1380  CB  TYR    32      28.054  37.533  44.156  1.00 28.51           C  
ATOM   1381  CG  TYR    32      26.573  37.583  43.859  1.00 28.85           C  
ATOM   1382  CD1 TYR    32      25.640  37.573  44.892  1.00 30.87           C  
ATOM   1383  CD2 TYR    32      26.104  37.564  42.555  1.00 30.04           C  
ATOM   1384  CE1 TYR    32      24.285  37.577  44.632  1.00 31.57           C  
ATOM   1385  CE2 TYR    32      24.743  37.561  42.284  1.00 28.50           C  
ATOM   1386  CZ  TYR    32      23.840  37.567  43.328  1.00 30.20           C  
ATOM   1387  OH  TYR    32      22.491  37.566  43.071  1.00 27.86           O  
ATOM   1388  N   LYS    33      27.062  34.354  43.664  1.00 30.60           N  
ATOM   1389  CA  LYS    33      26.541  33.386  42.716  1.00 30.67           C  
ATOM   1390  C   LYS    33      25.036  33.621  42.611  1.00 29.00           C  
ATOM   1391  O   LYS    33      24.353  33.610  43.634  1.00 27.20           O  
ATOM   1392  CB  LYS    33      26.804  31.963  43.218  1.00 30.54           C  
ATOM   1393  CG  LYS    33      28.261  31.518  43.131  1.00 31.84           C  
ATOM   1394  CD  LYS    33      28.444  30.104  43.651  1.00 32.67           C  
ATOM   1395  CE  LYS    33      29.915  29.685  43.643  1.00 38.32           C  
ATOM   1396  NZ  LYS    33      30.093  28.233  43.927  1.00 35.17           N  
ATOM   1397  N   PRO    34      24.527  33.902  41.397  1.00 27.53           N  
ATOM   1398  CA  PRO    34      23.093  34.023  41.131  1.00 27.92           C  
ATOM   1399  C   PRO    34      22.258  32.808  41.526  1.00 27.42           C  
ATOM   1400  O   PRO    34      21.134  32.971  42.007  1.00 26.94           O  
ATOM   1401  CB  PRO    34      23.043  34.209  39.609  1.00 28.69           C  
ATOM   1402  CG  PRO    34      24.349  34.838  39.276  1.00 28.43           C  
ATOM   1403  CD  PRO    34      25.323  34.197  40.193  1.00 27.34           C  
ATOM   1404  N   ALA    35      22.800  31.615  41.282  1.00 28.20           N  
ATOM   1405  CA  ALA    35      22.192  30.348  41.691  1.00 29.19           C  
ATOM   1406  C   ALA    35      23.291  29.440  42.234  1.00 30.41           C  
ATOM   1407  O   ALA    35      24.477  29.688  41.984  1.00 29.92           O  
ATOM   1408  CB  ALA    35      21.486  29.688  40.515  1.00 27.66           C  
ATOM   1409  N   GLU    36      22.900  28.382  42.949  1.00 31.54           N  
ATOM   1410  CA  GLU    36      23.861  27.475  43.590  1.00 33.38           C  
ATOM   1411  C   GLU    36      24.823  26.807  42.625  1.00 32.55           C  
ATOM   1412  O   GLU    36      25.968  26.559  42.979  1.00 33.40           O  
ATOM   1413  CB  GLU    36      23.150  26.386  44.381  1.00 34.20           C  
ATOM   1414  CG  GLU    36      22.389  26.881  45.598  1.00 37.06           C  
ATOM   1415  CD  GLU    36      22.094  25.766  46.602  1.00 39.82           C  
ATOM   1416  OE1 GLU    36      22.175  24.569  46.227  1.00 44.32           O  
ATOM   1417  OE2 GLU    36      21.794  26.094  47.775  1.00 47.78           O  
ATOM   1418  N   THR    37      24.351  26.510  41.419  1.00 31.80           N  
ATOM   1419  CA  THR    37      25.157  25.853  40.393  1.00 31.56           C  
ATOM   1420  C   THR    37      25.885  26.843  39.474  1.00 32.32           C  
ATOM   1421  O   THR    37      26.457  26.434  38.474  1.00 33.55           O  
ATOM   1422  CB  THR    37      24.262  24.924  39.568  1.00 31.01           C  
ATOM   1423  OG1 THR    37      23.098  25.641  39.152  1.00 31.99           O  
ATOM   1424  CG2 THR    37      23.806  23.726  40.418  1.00 31.00           C  
ATOM   1425  N   SER    38      25.883  28.134  39.826  1.00 32.65           N  
ATOM   1426  CA  SER    38      26.541  29.182  39.021  1.00 31.97           C  
ATOM   1427  C   SER    38      28.004  29.341  39.378  1.00 30.83           C  
ATOM   1428  O   SER    38      28.405  28.993  40.476  1.00 31.30           O  
ATOM   1429  CB  SER    38      25.870  30.550  39.232  1.00 31.46           C  
ATOM   1430  OG  SER    38      24.536  30.548  38.778  1.00 32.46           O  
ATOM   1431  N   MET    39      28.791  29.880  38.446  1.00 30.71           N  
ATOM   1432  CA  MET    39      30.141  30.329  38.764  1.00 28.97           C  
ATOM   1433  C   MET    39      29.976  31.552  39.652  1.00 28.65           C  
ATOM   1434  O   MET    39      28.998  32.284  39.522  1.00 27.14           O  
ATOM   1435  CB  MET    39      30.933  30.734  37.516  1.00 28.74           C  
ATOM   1436  CG  MET    39      31.363  29.598  36.573  1.00 31.41           C  
ATOM   1437  SD  MET    39      32.514  30.228  35.067  0.75 25.74          SE  
ATOM   1438  CE  MET    39      34.264  29.826  35.772  1.00 37.14           C  
ATOM   1439  N   SER    40      30.928  31.768  40.550  1.00 28.71           N  
ATOM   1440  CA  SER    40      30.961  32.977  41.347  1.00 28.93           C  
ATOM   1441  C   SER    40      31.356  34.119  40.422  1.00 29.26           C  
ATOM   1442  O   SER    40      31.856  33.886  39.321  1.00 28.27           O  
ATOM   1443  CB  SER    40      31.977  32.857  42.485  1.00 28.55           C  
ATOM   1444  OG  SER    40      33.300  32.845  41.971  1.00 31.56           O  
ATOM   1445  N   ALA    41      31.141  35.346  40.883  1.00 29.32           N  
ATOM   1446  CA  ALA    41      31.479  36.531  40.109  1.00 28.43           C  
ATOM   1447  C   ALA    41      32.928  36.492  39.643  1.00 28.87           C  
ATOM   1448  O   ALA    41      33.208  36.745  38.475  1.00 29.06           O  
ATOM   1449  CB  ALA    41      31.216  37.789  40.924  1.00 28.00           C  
ATOM   1450  N   GLU    42      33.844  36.156  40.549  1.00 30.19           N  
ATOM   1451  CA  GLU    42      35.266  36.137  40.215  1.00 32.30           C  
ATOM   1452  C   GLU    42      35.669  34.956  39.338  1.00 31.49           C  
ATOM   1453  O   GLU    42      36.549  35.098  38.495  1.00 31.64           O  
ATOM   1454  CB  GLU    42      36.150  36.217  41.468  1.00 32.29           C  
ATOM   1455  CG  GLU    42      36.145  35.016  42.371  1.00 35.81           C  
ATOM   1456  CD  GLU    42      37.144  35.156  43.514  1.00 36.28           C  
ATOM   1457  OE1 GLU    42      38.328  35.484  43.242  1.00 35.57           O  
ATOM   1458  OE2 GLU    42      36.744  34.923  44.680  1.00 43.97           O  
ATOM   1459  N   GLU    43      35.044  33.797  39.532  1.00 30.87           N  
ATOM   1460  CA  GLU    43      35.260  32.661  38.625  1.00 30.39           C  
ATOM   1461  C   GLU    43      34.845  33.040  37.214  1.00 29.35           C  
ATOM   1462  O   GLU    43      35.531  32.703  36.238  1.00 29.22           O  
ATOM   1463  CB  GLU    43      34.467  31.425  39.060  1.00 30.93           C  
ATOM   1464  CG  GLU    43      35.062  30.666  40.239  1.00 32.30           C  
ATOM   1465  CD  GLU    43      34.153  29.551  40.752  1.00 32.16           C  
ATOM   1466  OE1 GLU    43      32.930  29.604  40.535  1.00 35.30           O  
ATOM   1467  OE2 GLU    43      34.667  28.617  41.401  1.00 38.93           O  
ATOM   1468  N   LEU    44      33.722  33.747  37.111  1.00 27.81           N  
ATOM   1469  CA  LEU    44      33.205  34.170  35.813  1.00 27.14           C  
ATOM   1470  C   LEU    44      34.204  35.093  35.145  1.00 26.11           C  
ATOM   1471  O   LEU    44      34.615  34.849  34.019  1.00 26.10           O  
ATOM   1472  CB  LEU    44      31.835  34.853  35.958  1.00 27.33           C  
ATOM   1473  CG  LEU    44      31.197  35.427  34.687  1.00 26.54           C  
ATOM   1474  CD1 LEU    44      31.341  34.484  33.494  1.00 26.87           C  
ATOM   1475  CD2 LEU    44      29.729  35.714  34.941  1.00 25.50           C  
ATOM   1476  N   VAL    45      34.619  36.132  35.865  1.00 26.48           N  
ATOM   1477  CA  VAL    45      35.510  37.144  35.325  1.00 26.04           C  
ATOM   1478  C   VAL    45      36.867  36.552  34.944  1.00 27.08           C  
ATOM   1479  O   VAL    45      37.346  36.802  33.850  1.00 27.54           O  
ATOM   1480  CB  VAL    45      35.683  38.334  36.309  1.00 27.04           C  
ATOM   1481  CG1 VAL    45      36.744  39.312  35.797  1.00 25.46           C  
ATOM   1482  CG2 VAL    45      34.352  39.042  36.521  1.00 23.13           C  
ATOM   1483  N   LYS    46      37.482  35.767  35.827  1.00 28.21           N  
ATOM   1484  CA  LYS    46      38.793  35.155  35.522  1.00 29.00           C  
ATOM   1485  C   LYS    46      38.708  34.265  34.287  1.00 28.55           C  
ATOM   1486  O   LYS    46      39.629  34.250  33.464  1.00 29.07           O  
ATOM   1487  CB  LYS    46      39.324  34.321  36.690  1.00 29.20           C  
ATOM   1488  CG  LYS    46      39.776  35.118  37.886  1.00 31.60           C  
ATOM   1489  CD  LYS    46      40.299  34.197  38.968  1.00 29.66           C  
ATOM   1490  CE  LYS    46      40.389  34.916  40.294  1.00 37.54           C  
ATOM   1491  NZ  LYS    46      40.795  33.997  41.394  1.00 35.65           N  
ATOM   1492  N   HIS    47      37.616  33.505  34.172  1.00 27.91           N  
ATOM   1493  CA  HIS    47      37.432  32.622  33.016  1.00 27.17           C  
ATOM   1494  C   HIS    47      37.379  33.401  31.699  1.00 25.59           C  
ATOM   1495  O   HIS    47      37.956  32.964  30.704  1.00 26.75           O  
ATOM   1496  CB  HIS    47      36.190  31.743  33.159  1.00 27.46           C  
ATOM   1497  CG  HIS    47      35.905  30.922  31.937  1.00 28.87           C  
ATOM   1498  ND1 HIS    47      36.734  29.908  31.515  1.00 32.09           N  
ATOM   1499  CD2 HIS    47      34.908  30.996  31.025  1.00 28.90           C  
ATOM   1500  CE1 HIS    47      36.257  29.387  30.399  1.00 27.52           C  
ATOM   1501  NE2 HIS    47      35.146  30.027  30.083  1.00 28.54           N  
ATOM   1502  N   ILE    48      36.699  34.545  31.701  1.00 25.40           N  
ATOM   1503  CA  ILE    48      36.648  35.436  30.536  1.00 24.70           C  
ATOM   1504  C   ILE    48      38.065  35.852  30.154  1.00 25.30           C  
ATOM   1505  O   ILE    48      38.456  35.765  28.997  1.00 26.11           O  
ATOM   1506  CB  ILE    48      35.781  36.700  30.805  1.00 25.39           C  
ATOM   1507  CG1 ILE    48      34.294  36.324  30.910  1.00 26.97           C  
ATOM   1508  CG2 ILE    48      35.972  37.754  29.707  1.00 21.47           C  
ATOM   1509  CD1 ILE    48      33.372  37.436  31.476  1.00 21.56           C  
ATOM   1510  N   LEU    49      38.837  36.259  31.148  1.00 25.60           N  
ATOM   1511  CA  LEU    49      40.199  36.717  30.947  1.00 24.97           C  
ATOM   1512  C   LEU    49      41.170  35.634  30.482  1.00 25.95           C  
ATOM   1513  O   LEU    49      41.891  35.831  29.502  1.00 27.25           O  
ATOM   1514  CB  LEU    49      40.725  37.337  32.231  1.00 24.59           C  
ATOM   1515  CG  LEU    49      40.077  38.643  32.687  1.00 26.07           C  
ATOM   1516  CD1 LEU    49      40.707  39.082  34.017  1.00 25.43           C  
ATOM   1517  CD2 LEU    49      40.202  39.746  31.632  1.00 21.72           C  
ATOM   1518  N   THR    50      41.206  34.501  31.184  1.00 26.62           N  
ATOM   1519  CA  THR    50      42.139  33.428  30.831  1.00 26.53           C  
ATOM   1520  C   THR    50      41.768  32.721  29.518  1.00 28.19           C  
ATOM   1521  O   THR    50      42.664  32.330  28.753  1.00 29.08           O  
ATOM   1522  CB  THR    50      42.279  32.370  31.958  1.00 26.75           C  
ATOM   1523  OG1 THR    50      41.018  31.734  32.195  1.00 29.27           O  
ATOM   1524  CG2 THR    50      42.785  33.010  33.255  1.00 20.35           C  
ATOM   1525  N   SER    51      40.469  32.568  29.242  1.00 28.56           N  
ATOM   1526  CA  SER    51      40.053  31.808  28.064  1.00 29.13           C  
ATOM   1527  C   SER    51      40.431  32.521  26.777  1.00 28.90           C  
ATOM   1528  O   SER    51      40.940  31.880  25.847  1.00 30.53           O  
ATOM   1529  CB  SER    51      38.557  31.446  28.084  1.00 28.88           C  
ATOM   1530  OG  SER    51      37.727  32.590  28.069  1.00 33.02           O  
ATOM   1531  N   PHE    52      40.194  33.830  26.703  1.00 27.66           N  
ATOM   1532  CA  PHE    52      40.530  34.557  25.483  1.00 27.14           C  
ATOM   1533  C   PHE    52      42.039  34.554  25.296  1.00 27.70           C  
ATOM   1534  O   PHE    52      42.530  34.421  24.178  1.00 28.71           O  
ATOM   1535  CB  PHE    52      40.001  35.993  25.481  1.00 27.08           C  
ATOM   1536  CG  PHE    52      39.811  36.560  24.089  1.00 25.86           C  
ATOM   1537  CD1 PHE    52      40.907  36.795  23.256  1.00 25.78           C  
ATOM   1538  CD2 PHE    52      38.542  36.839  23.608  1.00 23.07           C  
ATOM   1539  CE1 PHE    52      40.725  37.299  21.977  1.00 26.17           C  
ATOM   1540  CE2 PHE    52      38.359  37.351  22.333  1.00 23.04           C  
ATOM   1541  CZ  PHE    52      39.446  37.570  21.514  1.00 23.22           C  
ATOM   1542  N   HIS    53      42.772  34.683  26.394  1.00 28.75           N  
ATOM   1543  CA  HIS    53      44.234  34.689  26.347  1.00 29.87           C  
ATOM   1544  C   HIS    53      44.799  33.336  25.861  1.00 29.22           C  
ATOM   1545  O   HIS    53      45.774  33.303  25.101  1.00 28.96           O  
ATOM   1546  CB  HIS    53      44.812  35.081  27.710  1.00 29.38           C  
ATOM   1547  CG  HIS    53      46.297  35.259  27.699  1.00 32.09           C  
ATOM   1548  ND1 HIS    53      47.161  34.324  28.221  1.00 36.75           N  
ATOM   1549  CD2 HIS    53      47.071  36.250  27.200  1.00 34.27           C  
ATOM   1550  CE1 HIS    53      48.405  34.738  28.056  1.00 36.33           C  
ATOM   1551  NE2 HIS    53      48.377  35.904  27.439  1.00 35.25           N  
ATOM   1552  N   LEU    54      44.175  32.237  26.280  1.00 28.84           N  
ATOM   1553  CA  LEU    54      44.545  30.908  25.787  1.00 29.41           C  
ATOM   1554  C   LEU    54      44.344  30.820  24.271  1.00 29.89           C  
ATOM   1555  O   LEU    54      45.283  30.469  23.530  1.00 28.10           O  
ATOM   1556  CB  LEU    54      43.746  29.812  26.501  1.00 28.57           C  
ATOM   1557  CG  LEU    54      44.049  28.359  26.102  1.00 30.83           C  
ATOM   1558  CD1 LEU    54      45.538  28.026  26.269  1.00 28.39           C  
ATOM   1559  CD2 LEU    54      43.180  27.371  26.890  1.00 30.29           C  
ATOM   1560  N   PHE    55      43.134  31.159  23.817  1.00 30.20           N  
ATOM   1561  CA  PHE    55      42.819  31.153  22.382  1.00 32.29           C  
ATOM   1562  C   PHE    55      43.787  32.023  21.577  1.00 31.95           C  
ATOM   1563  O   PHE    55      44.243  31.620  20.510  1.00 32.57           O  
ATOM   1564  CB  PHE    55      41.398  31.652  22.119  1.00 34.13           C  
ATOM   1565  CG  PHE    55      40.317  30.681  22.505  1.00 36.99           C  
ATOM   1566  CD1 PHE    55      40.343  29.372  22.063  1.00 39.85           C  
ATOM   1567  CD2 PHE    55      39.236  31.104  23.275  1.00 45.14           C  
ATOM   1568  CE1 PHE    55      39.330  28.494  22.403  1.00 44.15           C  
ATOM   1569  CE2 PHE    55      38.220  30.231  23.620  1.00 45.62           C  
ATOM   1570  CZ  PHE    55      38.263  28.923  23.179  1.00 43.03           C  
ATOM   1571  N   ALA    56      44.077  33.221  22.089  1.00 31.31           N  
ATOM   1572  CA  ALA    56      45.030  34.131  21.448  1.00 30.70           C  
ATOM   1573  C   ALA    56      46.421  33.491  21.272  1.00 29.92           C  
ATOM   1574  O   ALA    56      47.059  33.654  20.231  1.00 30.50           O  
ATOM   1575  CB  ALA    56      45.132  35.443  22.241  1.00 30.35           C  
ATOM   1576  N   ASN    57      46.879  32.749  22.274  1.00 30.14           N  
ATOM   1577  CA  ASN    57      48.161  32.034  22.164  1.00 31.35           C  
ATOM   1578  C   ASN    57      48.100  30.807  21.225  1.00 32.06           C  
ATOM   1579  O   ASN    57      49.095  30.465  20.591  1.00 32.88           O  
ATOM   1580  CB  ASN    57      48.708  31.665  23.553  1.00 31.09           C  
ATOM   1581  CG  ASN    57      49.664  32.728  24.110  1.00 33.29           C  
ATOM   1582  OD1 ASN    57      50.701  33.008  23.514  1.00 36.72           O  
ATOM   1583  ND2 ASN    57      49.326  33.305  25.261  1.00 32.00           N  
ATOM   1584  N   VAL    58      46.936  30.166  21.120  1.00 32.60           N  
ATOM   1585  CA  VAL    58      46.760  29.045  20.194  1.00 32.08           C  
ATOM   1586  C   VAL    58      46.876  29.526  18.742  1.00 32.30           C  
ATOM   1587  O   VAL    58      47.545  28.890  17.934  1.00 32.10           O  
ATOM   1588  CB  VAL    58      45.419  28.287  20.433  1.00 31.98           C  
ATOM   1589  CG1 VAL    58      45.237  27.157  19.410  1.00 29.82           C  
ATOM   1590  CG2 VAL    58      45.366  27.727  21.861  1.00 28.52           C  
ATOM   1591  N   ILE    59      46.235  30.650  18.422  1.00 32.76           N  
ATOM   1592  CA  ILE    59      46.363  31.279  17.092  1.00 33.21           C  
ATOM   1593  C   ILE    59      47.797  31.770  16.842  1.00 33.87           C  
ATOM   1594  O   ILE    59      48.332  31.642  15.741  1.00 33.61           O  
ATOM   1595  CB  ILE    59      45.427  32.500  16.938  1.00 33.99           C  
ATOM   1596  CG1 ILE    59      43.950  32.095  17.083  1.00 33.69           C  
ATOM   1597  CG2 ILE    59      45.664  33.206  15.586  1.00 31.95           C  
ATOM   1598  CD1 ILE    59      43.006  33.284  17.176  1.00 32.20           C  
ATOM   1599  N   LYS    60      48.411  32.330  17.872  1.00 35.71           N  
ATOM   1600  CA  LYS    60      49.772  32.840  17.767  1.00 37.57           C  
ATOM   1601  C   LYS    60      50.764  31.721  17.441  1.00 38.24           C  
ATOM   1602  O   LYS    60      51.604  31.872  16.562  1.00 37.60           O  
ATOM   1603  CB  LYS    60      50.174  33.557  19.062  1.00 37.54           C  
ATOM   1604  CG  LYS    60      51.655  33.883  19.189  1.00 36.89           C  
ATOM   1605  CD  LYS    60      51.907  34.811  20.361  1.00 39.39           C  
ATOM   1606  CE  LYS    60      53.381  34.926  20.678  1.00 43.88           C  
ATOM   1607  NZ  LYS    60      53.698  36.138  21.480  1.00 45.53           N  
ATOM   1608  N   GLU    61      50.662  30.603  18.150  1.00 39.86           N  
ATOM   1609  CA  GLU    61      51.580  29.486  17.934  1.00 40.82           C  
ATOM   1610  C   GLU    61      51.197  28.632  16.722  1.00 41.21           C  
ATOM   1611  O   GLU    61      52.065  28.113  16.025  1.00 41.01           O  
ATOM   1612  CB  GLU    61      51.673  28.611  19.193  1.00 40.22           C  
ATOM   1613  CG  GLU    61      52.201  29.330  20.445  1.00 41.09           C  
ATOM   1614  CD  GLU    61      53.587  29.968  20.275  1.00 41.98           C  
ATOM   1615  OE1 GLU    61      54.314  29.626  19.319  1.00 43.56           O  
ATOM   1616  OE2 GLU    61      53.956  30.816  21.114  1.00 41.89           O  
ATOM   1617  N   GLY    62      49.896  28.506  16.472  1.00 42.51           N  
ATOM   1618  CA  GLY    62      49.378  27.596  15.455  1.00 43.05           C  
ATOM   1619  C   GLY    62      49.304  26.169  15.972  1.00 43.55           C  
ATOM   1620  O   GLY    62      48.994  25.252  15.216  1.00 44.20           O  
ATOM   1621  N   ASN    63      49.576  25.996  17.266  1.00 44.07           N  
ATOM   1622  CA  ASN    63      49.674  24.692  17.917  1.00 44.21           C  
ATOM   1623  C   ASN    63      48.667  24.579  19.044  1.00 44.05           C  
ATOM   1624  O   ASN    63      48.103  25.579  19.482  1.00 43.63           O  
ATOM   1625  CB  ASN    63      51.057  24.530  18.552  1.00 43.35           C  
ATOM   1626  CG  ASN    63      52.175  24.755  17.581  1.00 46.03           C  
ATOM   1627  OD1 ASN    63      52.015  24.563  16.380  1.00 56.39           O  
ATOM   1628  ND2 ASN    63      53.329  25.158  18.093  1.00 46.14           N  
ATOM   1629  N   ALA    64      48.497  23.354  19.541  1.00 44.06           N  
ATOM   1630  CA  ALA    64      47.735  23.100  20.759  1.00 43.65           C  
ATOM   1631  C   ALA    64      48.652  23.159  21.986  1.00 42.60           C  
ATOM   1632  O   ALA    64      48.215  22.878  23.100  1.00 42.66           O  
ATOM   1633  CB  ALA    64      47.047  21.750  20.674  1.00 44.16           C  
ATOM   1634  N   SER    65      49.913  23.548  21.778  1.00 41.62           N  
ATOM   1635  CA  SER    65      50.914  23.588  22.848  1.00 40.66           C  
ATOM   1636  C   SER    65      50.624  24.576  23.992  1.00 39.74           C  
ATOM   1637  O   SER    65      50.986  24.293  25.121  1.00 39.46           O  
ATOM   1638  CB  SER    65      52.332  23.802  22.273  1.00 39.86           C  
ATOM   1639  OG  SER    65      52.479  25.053  21.630  1.00 38.52           O  
ATOM   1640  N   PRO    66      49.983  25.731  23.718  1.00 39.50           N  
ATOM   1641  CA  PRO    66      49.632  26.610  24.848  1.00 39.62           C  
ATOM   1642  C   PRO    66      48.674  26.005  25.903  1.00 40.52           C  
ATOM   1643  O   PRO    66      48.529  26.577  26.989  1.00 40.07           O  
ATOM   1644  CB  PRO    66      48.999  27.830  24.163  1.00 39.89           C  
ATOM   1645  CG  PRO    66      49.525  27.792  22.756  1.00 39.12           C  
ATOM   1646  CD  PRO    66      49.599  26.337  22.428  1.00 39.03           C  
ATOM   1647  N   PHE    67      48.033  24.874  25.599  1.00 41.75           N  
ATOM   1648  CA  PHE    67      47.273  24.136  26.617  1.00 43.43           C  
ATOM   1649  C   PHE    67      48.212  23.489  27.643  1.00 44.65           C  
ATOM   1650  O   PHE    67      47.832  23.293  28.801  1.00 44.48           O  
ATOM   1651  CB  PHE    67      46.384  23.053  25.996  1.00 44.15           C  
ATOM   1652  CG  PHE    67      45.455  23.559  24.931  1.00 45.35           C  
ATOM   1653  CD1 PHE    67      44.694  24.703  25.134  1.00 48.97           C  
ATOM   1654  CD2 PHE    67      45.327  22.883  23.728  1.00 47.36           C  
ATOM   1655  CE1 PHE    67      43.834  25.171  24.148  1.00 47.77           C  
ATOM   1656  CE2 PHE    67      44.476  23.353  22.740  1.00 47.83           C  
ATOM   1657  CZ  PHE    67      43.728  24.495  22.955  1.00 44.88           C  
ATOM   1658  N   GLN    68      49.425  23.149  27.209  1.00 46.69           N  
ATOM   1659  CA  GLN    68      50.444  22.560  28.089  1.00 48.37           C  
ATOM   1660  C   GLN    68      50.999  23.583  29.073  1.00 50.08           C  
ATOM   1661  O   GLN    68      51.458  23.216  30.156  1.00 50.91           O  
ATOM   1662  CB  GLN    68      51.607  21.962  27.275  1.00 48.44           C  
ATOM   1663  CG  GLN    68      51.370  20.560  26.709  1.00 49.99           C  
ATOM   1664  CD  GLN    68      50.026  20.407  26.019  1.00 50.43           C  
ATOM   1665  OE1 GLN    68      48.982  20.371  26.673  1.00 50.63           O  
ATOM   1666  NE2 GLN    68      50.047  20.305  24.691  1.00 50.53           N  
ATOM   1667  N   ASN    69      50.974  24.859  28.688  1.00 51.88           N  
ATOM   1668  CA  ASN    69      51.449  25.938  29.552  1.00 53.28           C  
ATOM   1669  C   ASN    69      50.511  26.154  30.740  1.00 54.71           C  
ATOM   1670  O   ASN    69      49.505  26.850  30.618  1.00 54.91           O  
ATOM   1671  CB  ASN    69      51.588  27.240  28.752  1.00 53.14           C  
ATOM   1672  N   LYS    70      50.835  25.536  31.874  1.00 57.03           N  
ATOM   1673  CA  LYS    70      50.099  25.758  33.119  1.00 58.38           C  
ATOM   1674  C   LYS    70      50.589  27.059  33.750  1.00 59.82           C  
ATOM   1675  O   LYS    70      51.596  27.058  34.465  1.00 59.85           O  
ATOM   1676  CB  LYS    70      50.324  24.599  34.092  1.00 58.61           C  
ATOM   1677  N   GLN    71      49.889  28.161  33.473  1.00 61.09           N  
ATOM   1678  CA  GLN    71      50.291  29.486  33.963  1.00 62.37           C  
ATOM   1679  C   GLN    71      49.654  29.793  35.321  1.00 63.43           C  
ATOM   1680  O   GLN    71      48.464  30.126  35.397  1.00 64.18           O  
ATOM   1681  CB  GLN    71      49.910  30.572  32.952  1.00 62.69           C  
ATOM   1682  N   GLU    72      50.451  29.679  36.386  1.00 63.24           N  
ATOM   1683  CA  GLU    72      49.984  29.958  37.746  1.00 62.89           C  
ATOM   1684  C   GLU    72      49.973  31.469  38.008  1.00 62.36           C  
ATOM   1685  O   GLU    72      50.992  32.045  38.403  1.00 62.30           O  
ATOM   1686  CB  GLU    72      50.871  29.246  38.777  1.00 62.86           C  
ATOM   1687  N   GLU    73      48.824  32.106  37.772  1.00 60.95           N  
ATOM   1688  CA  GLU    73      48.670  33.540  38.035  1.00 59.65           C  
ATOM   1689  C   GLU    73      48.477  33.737  39.540  1.00 57.43           C  
ATOM   1690  O   GLU    73      47.552  33.173  40.130  1.00 57.80           O  
ATOM   1691  CB  GLU    73      47.484  34.123  37.250  1.00 60.09           C  
ATOM   1692  CG  GLU    73      47.401  35.662  37.243  1.00 60.77           C  
ATOM   1693  CD  GLU    73      48.532  36.354  36.463  1.00 62.91           C  
ATOM   1694  OE1 GLU    73      49.224  35.689  35.663  1.00 64.78           O  
ATOM   1695  OE2 GLU    73      48.720  37.577  36.645  1.00 61.24           O  
ATOM   1696  N   THR    74      49.361  34.526  40.149  1.00 54.02           N  
ATOM   1697  CA  THR    74      49.358  34.754  41.597  1.00 52.74           C  
ATOM   1698  C   THR    74      48.387  35.863  42.044  1.00 51.44           C  
ATOM   1699  O   THR    74      47.943  35.871  43.196  1.00 51.74           O  
ATOM   1700  CB  THR    74      50.775  35.105  42.101  1.00 52.41           C  
ATOM   1701  N   GLU    75      48.058  36.784  41.135  1.00 49.36           N  
ATOM   1702  CA  GLU    75      47.214  37.939  41.455  1.00 47.02           C  
ATOM   1703  C   GLU    75      45.759  37.533  41.711  1.00 45.84           C  
ATOM   1704  O   GLU    75      45.231  36.654  41.029  1.00 46.17           O  
ATOM   1705  CB  GLU    75      47.283  38.962  40.312  1.00 46.52           C  
ATOM   1706  CG  GLU    75      46.513  40.248  40.573  1.00 44.62           C  
ATOM   1707  CD  GLU    75      47.058  41.016  41.759  1.00 42.04           C  
ATOM   1708  OE1 GLU    75      48.292  41.233  41.800  1.00 33.54           O  
ATOM   1709  OE2 GLU    75      46.253  41.402  42.637  1.00 35.78           O  
ATOM   1710  N   THR    76      45.133  38.178  42.697  1.00 44.18           N  
ATOM   1711  CA  THR    76      43.737  37.915  43.069  1.00 42.84           C  
ATOM   1712  C   THR    76      42.803  39.105  42.845  1.00 41.12           C  
ATOM   1713  O   THR    76      41.591  38.923  42.736  1.00 41.75           O  
ATOM   1714  CB  THR    76      43.627  37.523  44.548  1.00 43.10           C  
ATOM   1715  OG1 THR    76      44.363  38.464  45.345  1.00 44.47           O  
ATOM   1716  CG2 THR    76      44.167  36.111  44.770  1.00 43.34           C  
ATOM   1717  N   ASP    77      43.351  40.318  42.805  1.00 38.64           N  
ATOM   1718  CA  ASP    77      42.547  41.494  42.522  1.00 36.40           C  
ATOM   1719  C   ASP    77      42.053  41.379  41.091  1.00 34.51           C  
ATOM   1720  O   ASP    77      42.855  41.330  40.155  1.00 32.72           O  
ATOM   1721  CB  ASP    77      43.351  42.785  42.726  1.00 36.29           C  
ATOM   1722  CG  ASP    77      42.471  44.032  42.705  1.00 36.98           C  
ATOM   1723  OD1 ASP    77      41.907  44.355  41.639  1.00 32.41           O  
ATOM   1724  OD2 ASP    77      42.349  44.695  43.757  1.00 42.30           O  
ATOM   1725  N   LEU    78      40.728  41.321  40.945  1.00 33.17           N  
ATOM   1726  CA  LEU    78      40.084  41.188  39.644  1.00 31.83           C  
ATOM   1727  C   LEU    78      40.447  42.312  38.690  1.00 30.92           C  
ATOM   1728  O   LEU    78      40.630  42.063  37.501  1.00 30.51           O  
ATOM   1729  CB  LEU    78      38.554  41.136  39.777  1.00 31.06           C  
ATOM   1730  CG  LEU    78      37.884  39.831  40.213  1.00 30.15           C  
ATOM   1731  CD1 LEU    78      36.382  39.991  40.079  1.00 28.75           C  
ATOM   1732  CD2 LEU    78      38.360  38.634  39.408  1.00 26.53           C  
ATOM   1733  N   ASN    79      40.528  43.540  39.205  1.00 31.00           N  
ATOM   1734  CA  ASN    79      40.795  44.709  38.361  1.00 31.40           C  
ATOM   1735  C   ASN    79      42.207  44.677  37.806  1.00 30.64           C  
ATOM   1736  O   ASN    79      42.430  45.047  36.659  1.00 32.32           O  
ATOM   1737  CB  ASN    79      40.519  46.014  39.113  1.00 30.97           C  
ATOM   1738  CG  ASN    79      39.047  46.191  39.445  1.00 32.77           C  
ATOM   1739  OD1 ASN    79      38.169  45.793  38.669  1.00 34.47           O  
ATOM   1740  ND2 ASN    79      38.767  46.792  40.597  1.00 31.40           N  
ATOM   1741  N   VAL    80      43.145  44.198  38.613  1.00 30.86           N  
ATOM   1742  CA  VAL    80      44.527  43.995  38.176  1.00 30.48           C  
ATOM   1743  C   VAL    80      44.626  42.802  37.208  1.00 30.68           C  
ATOM   1744  O   VAL    80      45.369  42.850  36.230  1.00 32.36           O  
ATOM   1745  CB  VAL    80      45.453  43.767  39.378  1.00 30.21           C  
ATOM   1746  CG1 VAL    80      46.886  43.546  38.914  1.00 28.13           C  
ATOM   1747  CG2 VAL    80      45.352  44.942  40.345  1.00 27.39           C  
ATOM   1748  N   LEU    81      43.884  41.731  37.480  1.00 30.58           N  
ATOM   1749  CA  LEU    81      43.817  40.603  36.546  1.00 30.81           C  
ATOM   1750  C   LEU    81      43.247  41.057  35.200  1.00 30.95           C  
ATOM   1751  O   LEU    81      43.794  40.737  34.148  1.00 31.51           O  
ATOM   1752  CB  LEU    81      42.979  39.451  37.110  1.00 30.49           C  
ATOM   1753  CG  LEU    81      43.664  38.568  38.154  1.00 32.45           C  
ATOM   1754  CD1 LEU    81      42.657  37.683  38.888  1.00 28.60           C  
ATOM   1755  CD2 LEU    81      44.748  37.729  37.503  1.00 32.31           C  
ATOM   1756  N   ALA    82      42.162  41.827  35.243  1.00 31.30           N  
ATOM   1757  CA  ALA    82      41.511  42.328  34.029  1.00 29.87           C  
ATOM   1758  C   ALA    82      42.455  43.178  33.184  1.00 29.55           C  
ATOM   1759  O   ALA    82      42.555  42.976  31.975  1.00 29.00           O  
ATOM   1760  CB  ALA    82      40.252  43.108  34.382  1.00 27.98           C  
ATOM   1761  N   LYS    83      43.145  44.114  33.827  1.00 30.62           N  
ATOM   1762  CA  LYS    83      44.095  45.003  33.147  1.00 32.82           C  
ATOM   1763  C   LYS    83      45.278  44.247  32.545  1.00 31.38           C  
ATOM   1764  O   LYS    83      45.603  44.429  31.383  1.00 31.61           O  
ATOM   1765  CB  LYS    83      44.612  46.060  34.122  1.00 33.23           C  
ATOM   1766  CG  LYS    83      45.524  47.089  33.488  1.00 35.47           C  
ATOM   1767  CD  LYS    83      45.840  48.216  34.451  1.00 36.43           C  
ATOM   1768  CE  LYS    83      46.837  49.196  33.841  1.00 42.15           C  
ATOM   1769  NZ  LYS    83      47.235  50.260  34.808  1.00 48.16           N  
ATOM   1770  N   THR    84      45.915  43.410  33.352  1.00 31.31           N  
ATOM   1771  CA  THR    84      47.066  42.615  32.918  1.00 31.31           C  
ATOM   1772  C   THR    84      46.767  41.681  31.742  1.00 30.31           C  
ATOM   1773  O   THR    84      47.511  41.650  30.762  1.00 29.48           O  
ATOM   1774  CB  THR    84      47.595  41.795  34.095  1.00 30.96           C  
ATOM   1775  OG1 THR    84      48.174  42.693  35.047  1.00 32.33           O  
ATOM   1776  CG2 THR    84      48.648  40.779  33.637  1.00 34.24           C  
ATOM   1777  N   TYR    85      45.676  40.927  31.847  1.00 30.38           N  
ATOM   1778  CA  TYR    85      45.284  39.982  30.797  1.00 30.35           C  
ATOM   1779  C   TYR    85      44.820  40.665  29.510  1.00 29.76           C  
ATOM   1780  O   TYR    85      44.976  40.115  28.423  1.00 29.50           O  
ATOM   1781  CB  TYR    85      44.195  39.038  31.306  1.00 31.62           C  
ATOM   1782  CG  TYR    85      44.726  37.797  31.993  1.00 31.20           C  
ATOM   1783  CD1 TYR    85      45.237  36.746  31.245  1.00 32.21           C  
ATOM   1784  CD2 TYR    85      44.680  37.656  33.381  1.00 32.86           C  
ATOM   1785  CE1 TYR    85      45.701  35.590  31.850  1.00 32.84           C  
ATOM   1786  CE2 TYR    85      45.147  36.493  34.003  1.00 32.36           C  
ATOM   1787  CZ  TYR    85      45.657  35.467  33.229  1.00 33.24           C  
ATOM   1788  OH  TYR    85      46.137  34.309  33.811  1.00 34.89           O  
ATOM   1789  N   THR    86      44.235  41.848  29.638  1.00 31.05           N  
ATOM   1790  CA  THR    86      43.815  42.641  28.486  1.00 31.05           C  
ATOM   1791  C   THR    86      45.045  43.122  27.733  1.00 32.15           C  
ATOM   1792  O   THR    86      45.109  42.994  26.512  1.00 32.75           O  
ATOM   1793  CB  THR    86      42.918  43.820  28.928  1.00 30.81           C  
ATOM   1794  OG1 THR    86      41.726  43.284  29.508  1.00 29.76           O  
ATOM   1795  CG2 THR    86      42.532  44.732  27.760  1.00 26.40           C  
ATOM   1796  N   GLU    87      46.025  43.652  28.471  1.00 32.42           N  
ATOM   1797  CA  GLU    87      47.300  44.084  27.899  1.00 33.13           C  
ATOM   1798  C   GLU    87      48.047  42.928  27.211  1.00 31.43           C  
ATOM   1799  O   GLU    87      48.576  43.091  26.114  1.00 30.84           O  
ATOM   1800  CB  GLU    87      48.193  44.737  28.977  1.00 33.57           C  
ATOM   1801  CG  GLU    87      47.674  46.098  29.487  1.00 36.24           C  
ATOM   1802  CD  GLU    87      48.430  46.649  30.705  1.00 36.39           C  
ATOM   1803  OE1 GLU    87      49.213  45.898  31.339  1.00 42.87           O  
ATOM   1804  OE2 GLU    87      48.224  47.844  31.039  1.00 41.68           O  
ATOM   1805  N   LYS    88      48.086  41.769  27.857  1.00 30.05           N  
ATOM   1806  CA  LYS    88      48.724  40.586  27.275  1.00 31.07           C  
ATOM   1807  C   LYS    88      48.015  40.085  26.007  1.00 29.92           C  
ATOM   1808  O   LYS    88      48.669  39.628  25.061  1.00 30.19           O  
ATOM   1809  CB  LYS    88      48.768  39.444  28.295  1.00 31.28           C  
ATOM   1810  CG  LYS    88      49.807  39.588  29.405  1.00 32.74           C  
ATOM   1811  CD  LYS    88      49.487  38.619  30.542  1.00 34.44           C  
ATOM   1812  CE  LYS    88      50.726  38.125  31.283  1.00 39.86           C  
ATOM   1813  NZ  LYS    88      51.268  39.116  32.264  1.00 38.26           N  
ATOM   1814  N   THR    89      46.686  40.150  26.003  1.00 28.30           N  
ATOM   1815  CA  THR    89      45.907  39.659  24.876  1.00 26.91           C  
ATOM   1816  C   THR    89      45.994  40.627  23.697  1.00 26.04           C  
ATOM   1817  O   THR    89      46.155  40.197  22.563  1.00 25.57           O  
ATOM   1818  CB  THR    89      44.432  39.370  25.276  1.00 26.83           C  
ATOM   1819  OG1 THR    89      44.402  38.387  26.321  1.00 26.62           O  
ATOM   1820  CG2 THR    89      43.649  38.837  24.091  1.00 21.94           C  
ATOM   1821  N   VAL    90      45.916  41.928  23.970  1.00 25.73           N  
ATOM   1822  CA  VAL    90      46.100  42.954  22.935  1.00 24.97           C  
ATOM   1823  C   VAL    90      47.491  42.846  22.274  1.00 25.21           C  
ATOM   1824  O   VAL    90      47.625  42.875  21.044  1.00 24.21           O  
ATOM   1825  CB  VAL    90      45.922  44.368  23.530  1.00 26.15           C  
ATOM   1826  CG1 VAL    90      46.342  45.465  22.513  1.00 25.78           C  
ATOM   1827  CG2 VAL    90      44.477  44.564  24.014  1.00 24.53           C  
ATOM   1828  N   ALA    91      48.522  42.690  23.092  1.00 24.60           N  
ATOM   1829  CA  ALA    91      49.883  42.534  22.583  1.00 25.64           C  
ATOM   1830  C   ALA    91      49.993  41.348  21.616  1.00 27.64           C  
ATOM   1831  O   ALA    91      50.684  41.436  20.600  1.00 29.22           O  
ATOM   1832  CB  ALA    91      50.884  42.412  23.746  1.00 24.73           C  
ATOM   1833  N   ILE    92      49.284  40.255  21.896  1.00 29.04           N  
ATOM   1834  CA  ILE    92      49.251  39.131  20.956  1.00 29.11           C  
ATOM   1835  C   ILE    92      48.443  39.481  19.694  1.00 30.76           C  
ATOM   1836  O   ILE    92      48.935  39.307  18.568  1.00 31.05           O  
ATOM   1837  CB  ILE    92      48.682  37.846  21.579  1.00 29.24           C  
ATOM   1838  CG1 ILE    92      49.595  37.340  22.711  1.00 30.86           C  
ATOM   1839  CG2 ILE    92      48.552  36.775  20.506  1.00 23.58           C  
ATOM   1840  CD1 ILE    92      49.028  36.148  23.491  1.00 28.37           C  
ATOM   1841  N   LEU    93      47.221  39.983  19.890  1.00 30.68           N  
ATOM   1842  CA  LEU    93      46.329  40.312  18.782  1.00 31.19           C  
ATOM   1843  C   LEU    93      46.942  41.317  17.798  1.00 33.19           C  
ATOM   1844  O   LEU    93      46.804  41.152  16.584  1.00 32.19           O  
ATOM   1845  CB  LEU    93      44.981  40.836  19.305  1.00 30.38           C  
ATOM   1846  CG  LEU    93      44.072  39.867  20.066  1.00 28.57           C  
ATOM   1847  CD1 LEU    93      42.719  40.515  20.315  1.00 27.89           C  
ATOM   1848  CD2 LEU    93      43.904  38.560  19.325  1.00 24.19           C  
ATOM   1849  N   GLU    94      47.626  42.337  18.330  1.00 35.21           N  
ATOM   1850  CA  GLU    94      48.307  43.369  17.523  1.00 37.43           C  
ATOM   1851  C   GLU    94      49.279  42.824  16.477  1.00 38.02           C  
ATOM   1852  O   GLU    94      49.540  43.469  15.471  1.00 39.24           O  
ATOM   1853  CB  GLU    94      49.157  44.276  18.417  1.00 37.45           C  
ATOM   1854  CG  GLU    94      48.437  45.346  19.215  1.00 39.62           C  
ATOM   1855  CD  GLU    94      49.393  46.060  20.179  1.00 40.91           C  
ATOM   1856  OE1 GLU    94      50.569  45.626  20.285  1.00 44.33           O  
ATOM   1857  OE2 GLU    94      48.981  47.052  20.823  1.00 44.87           O  
ATOM   1858  N   GLN    95      49.868  41.672  16.757  1.00 38.62           N  
ATOM   1859  CA  GLN    95      50.925  41.131  15.921  1.00 39.16           C  
ATOM   1860  C   GLN    95      50.427  40.055  14.970  1.00 39.45           C  
ATOM   1861  O   GLN    95      51.135  39.700  14.038  1.00 40.62           O  
ATOM   1862  CB  GLN    95      52.020  40.554  16.816  1.00 40.08           C  
ATOM   1863  CG  GLN    95      52.579  41.550  17.832  1.00 42.36           C  
ATOM   1864  CD  GLN    95      53.520  42.551  17.202  1.00 46.73           C  
ATOM   1865  OE1 GLN    95      53.167  43.716  16.994  1.00 45.61           O  
ATOM   1866  NE2 GLN    95      54.729  42.096  16.877  1.00 50.68           N  
ATOM   1867  N   LEU    96      49.215  39.540  15.194  1.00 39.81           N  
ATOM   1868  CA  LEU    96      48.690  38.454  14.376  1.00 39.64           C  
ATOM   1869  C   LEU    96      48.600  38.845  12.906  1.00 40.14           C  
ATOM   1870  O   LEU    96      47.997  39.860  12.560  1.00 41.09           O  
ATOM   1871  CB  LEU    96      47.323  37.991  14.884  1.00 40.07           C  
ATOM   1872  CG  LEU    96      47.325  37.192  16.188  1.00 36.48           C  
ATOM   1873  CD1 LEU    96      45.897  36.863  16.590  1.00 34.41           C  
ATOM   1874  CD2 LEU    96      48.160  35.932  16.053  1.00 34.32           C  
ATOM   1875  N   THR    97      49.214  38.020  12.060  1.00 40.77           N  
ATOM   1876  CA  THR    97      49.279  38.234  10.615  1.00 40.51           C  
ATOM   1877  C   THR    97      48.149  37.480   9.901  1.00 40.99           C  
ATOM   1878  O   THR    97      47.577  36.530  10.442  1.00 40.42           O  
ATOM   1879  CB  THR    97      50.644  37.755  10.051  1.00 40.10           C  
ATOM   1880  OG1 THR    97      50.761  36.336  10.198  1.00 40.62           O  
ATOM   1881  CG2 THR    97      51.796  38.419  10.788  1.00 38.60           C  
ATOM   1882  N   GLU    98      47.826  37.916   8.688  1.00 41.70           N  
ATOM   1883  CA  GLU    98      46.781  37.269   7.889  1.00 42.96           C  
ATOM   1884  C   GLU    98      47.103  35.792   7.645  1.00 42.45           C  
ATOM   1885  O   GLU    98      46.204  34.969   7.536  1.00 42.13           O  
ATOM   1886  CB  GLU    98      46.577  38.023   6.565  1.00 43.80           C  
ATOM   1887  CG  GLU    98      45.735  39.297   6.722  1.00 46.73           C  
ATOM   1888  CD  GLU    98      44.267  38.992   6.996  1.00 51.55           C  
ATOM   1889  OE1 GLU    98      43.648  38.291   6.166  1.00 53.83           O  
ATOM   1890  OE2 GLU    98      43.731  39.443   8.037  1.00 53.34           O  
ATOM   1891  N   GLU    99      48.396  35.478   7.588  1.00 42.79           N  
ATOM   1892  CA  GLU    99      48.895  34.105   7.480  1.00 43.72           C  
ATOM   1893  C   GLU    99      48.494  33.277   8.694  1.00 41.44           C  
ATOM   1894  O   GLU    99      48.041  32.136   8.555  1.00 40.91           O  
ATOM   1895  CB  GLU    99      50.427  34.128   7.368  1.00 44.27           C  
ATOM   1896  CG  GLU    99      51.118  32.763   7.344  1.00 47.94           C  
ATOM   1897  CD  GLU    99      52.606  32.854   7.693  1.00 48.92           C  
ATOM   1898  OE1 GLU    99      52.937  33.477   8.732  1.00 61.99           O  
ATOM   1899  OE2 GLU    99      53.440  32.296   6.939  1.00 52.94           O  
ATOM   1900  N   GLN   100      48.693  33.847   9.883  1.00 39.56           N  
ATOM   1901  CA  GLN   100      48.308  33.198  11.140  1.00 37.57           C  
ATOM   1902  C   GLN   100      46.789  33.034  11.271  1.00 35.88           C  
ATOM   1903  O   GLN   100      46.315  32.075  11.865  1.00 34.56           O  
ATOM   1904  CB  GLN   100      48.865  33.972  12.335  1.00 37.95           C  
ATOM   1905  CG  GLN   100      50.361  33.753  12.560  1.00 35.36           C  
ATOM   1906  CD  GLN   100      50.928  34.653  13.650  1.00 37.02           C  
ATOM   1907  OE1 GLN   100      50.688  35.861  13.655  1.00 35.51           O  
ATOM   1908  NE2 GLN   100      51.688  34.064  14.577  1.00 28.77           N  
ATOM   1909  N   LEU   101      46.041  33.973  10.700  1.00 36.17           N  
ATOM   1910  CA  LEU   101      44.583  33.911  10.672  1.00 36.04           C  
ATOM   1911  C   LEU   101      44.073  32.913   9.633  1.00 37.42           C  
ATOM   1912  O   LEU   101      43.082  32.221   9.870  1.00 38.35           O  
ATOM   1913  CB  LEU   101      44.009  35.305  10.394  1.00 35.43           C  
ATOM   1914  CG  LEU   101      44.231  36.320  11.524  1.00 34.17           C  
ATOM   1915  CD1 LEU   101      44.014  37.731  11.053  1.00 35.54           C  
ATOM   1916  CD2 LEU   101      43.314  36.006  12.707  1.00 29.97           C  
ATOM   1917  N   ASP   102      44.753  32.842   8.488  1.00 38.87           N  
ATOM   1918  CA  ASP   102      44.334  31.980   7.378  1.00 39.41           C  
ATOM   1919  C   ASP   102      44.687  30.510   7.582  1.00 39.52           C  
ATOM   1920  O   ASP   102      43.960  29.630   7.119  1.00 40.06           O  
ATOM   1921  CB  ASP   102      44.945  32.476   6.060  1.00 40.18           C  
ATOM   1922  CG  ASP   102      44.274  33.742   5.538  1.00 41.84           C  
ATOM   1923  OD1 ASP   102      43.098  33.969   5.877  1.00 44.15           O  
ATOM   1924  OD2 ASP   102      44.916  34.501   4.776  1.00 44.89           O  
ATOM   1925  N   ARG   103      45.780  30.242   8.288  1.00 39.77           N  
ATOM   1926  CA  ARG   103      46.285  28.875   8.425  1.00 40.80           C  
ATOM   1927  C   ARG   103      45.443  27.996   9.334  1.00 41.55           C  
ATOM   1928  O   ARG   103      44.794  28.468  10.260  1.00 41.57           O  
ATOM   1929  CB  ARG   103      47.731  28.872   8.931  1.00 40.90           C  
ATOM   1930  CG  ARG   103      47.888  29.243  10.392  1.00 42.29           C  
ATOM   1931  CD  ARG   103      49.339  29.471  10.724  1.00 44.86           C  
ATOM   1932  NE  ARG   103      49.550  29.752  12.139  1.00 45.75           N  
ATOM   1933  CZ  ARG   103      50.715  30.125  12.661  1.00 47.88           C  
ATOM   1934  NH1 ARG   103      51.797  30.276  11.895  1.00 46.92           N  
ATOM   1935  NH2 ARG   103      50.802  30.357  13.962  1.00 48.77           N  
ATOM   1936  N   GLU   104      45.500  26.700   9.059  1.00 42.30           N  
ATOM   1937  CA  GLU   104      44.841  25.683   9.859  1.00 42.85           C  
ATOM   1938  C   GLU   104      45.654  25.353  11.112  1.00 41.15           C  
ATOM   1939  O   GLU   104      46.859  25.119  11.035  1.00 40.82           O  
ATOM   1940  CB  GLU   104      44.662  24.412   9.025  1.00 43.55           C  
ATOM   1941  CG  GLU   104      43.506  23.559   9.459  1.00 48.29           C  
ATOM   1942  CD  GLU   104      42.933  22.766   8.320  1.00 54.58           C  
ATOM   1943  OE1 GLU   104      43.648  21.883   7.807  1.00 57.58           O  
ATOM   1944  OE2 GLU   104      41.772  23.036   7.941  1.00 58.33           O  
ATOM   1945  N   ILE   105      44.980  25.348  12.258  1.00 40.26           N  
ATOM   1946  CA  ILE   105      45.561  24.903  13.517  1.00 39.85           C  
ATOM   1947  C   ILE   105      45.102  23.459  13.741  1.00 40.87           C  
ATOM   1948  O   ILE   105      43.896  23.195  13.806  1.00 38.41           O  
ATOM   1949  CB  ILE   105      45.100  25.787  14.698  1.00 39.56           C  
ATOM   1950  CG1 ILE   105      45.389  27.263  14.410  1.00 41.36           C  
ATOM   1951  CG2 ILE   105      45.783  25.371  15.987  1.00 36.65           C  
ATOM   1952  CD1 ILE   105      44.838  28.207  15.451  1.00 38.91           C  
ATOM   1953  N   ASP   106      46.055  22.530  13.838  1.00 43.16           N  
ATOM   1954  CA  ASP   106      45.735  21.110  14.079  1.00 45.33           C  
ATOM   1955  C   ASP   106      45.508  20.819  15.575  1.00 46.30           C  
ATOM   1956  O   ASP   106      46.472  20.721  16.343  1.00 47.07           O  
ATOM   1957  CB  ASP   106      46.851  20.206  13.529  1.00 45.75           C  
ATOM   1958  CG  ASP   106      46.547  18.715  13.689  1.00 48.90           C  
ATOM   1959  OD1 ASP   106      45.436  18.361  14.159  1.00 54.25           O  
ATOM   1960  OD2 ASP   106      47.426  17.896  13.340  1.00 48.22           O  
ATOM   1961  N   LEU   107      44.242  20.665  15.974  1.00 47.64           N  
ATOM   1962  CA  LEU   107      43.881  20.387  17.375  1.00 48.79           C  
ATOM   1963  C   LEU   107      43.225  19.004  17.581  1.00 49.78           C  
ATOM   1964  O   LEU   107      42.345  18.605  16.814  1.00 51.17           O  
ATOM   1965  CB  LEU   107      42.946  21.482  17.904  1.00 48.93           C  
ATOM   1966  CG  LEU   107      43.479  22.915  17.843  1.00 48.72           C  
ATOM   1967  CD1 LEU   107      42.485  23.893  18.457  1.00 47.04           C  
ATOM   1968  CD2 LEU   107      44.823  23.024  18.539  1.00 50.50           C  
ATOM   1969  N   THR   108      43.654  18.293  18.630  1.00 49.87           N  
ATOM   1970  CA  THR   108      43.136  16.954  18.974  1.00 48.10           C  
ATOM   1971  C   THR   108      41.608  16.879  18.933  1.00 48.72           C  
ATOM   1972  O   THR   108      41.034  16.018  18.261  1.00 48.58           O  
ATOM   1973  CB  THR   108      43.602  16.500  20.395  1.00 48.19           C  
ATOM   1974  OG1 THR   108      43.218  17.476  21.378  1.00 40.35           O  
ATOM   1975  CG2 THR   108      45.114  16.291  20.439  1.00 45.16           C  
ATOM   1976  N   LYS   114      40.560  20.285  13.549  1.00 48.83           N  
ATOM   1977  CA  LYS   114      41.339  21.284  12.829  1.00 47.35           C  
ATOM   1978  C   LYS   114      40.493  22.541  12.660  1.00 45.69           C  
ATOM   1979  O   LYS   114      39.291  22.459  12.389  1.00 45.34           O  
ATOM   1980  CB  LYS   114      41.802  20.739  11.475  1.00 46.66           C  
ATOM   1981  N   VAL   115      41.122  23.699  12.841  1.00 42.98           N  
ATOM   1982  CA  VAL   115      40.424  24.983  12.796  1.00 40.69           C  
ATOM   1983  C   VAL   115      41.403  26.064  12.356  1.00 37.96           C  
ATOM   1984  O   VAL   115      42.580  26.010  12.700  1.00 37.13           O  
ATOM   1985  CB  VAL   115      39.827  25.330  14.188  1.00 41.29           C  
ATOM   1986  CG1 VAL   115      40.938  25.423  15.230  1.00 41.11           C  
ATOM   1987  CG2 VAL   115      39.014  26.625  14.141  1.00 41.31           C  
ATOM   1988  N   THR   116      40.924  27.018  11.565  1.00 35.83           N  
ATOM   1989  CA  THR   116      41.747  28.147  11.129  1.00 34.25           C  
ATOM   1990  C   THR   116      41.888  29.156  12.249  1.00 34.16           C  
ATOM   1991  O   THR   116      40.982  29.294  13.064  1.00 34.64           O  
ATOM   1992  CB  THR   116      41.095  28.887   9.978  1.00 34.35           C  
ATOM   1993  OG1 THR   116      39.768  29.268  10.376  1.00 33.55           O  
ATOM   1994  CG2 THR   116      41.045  28.007   8.736  1.00 26.14           C  
ATOM   1995  N   GLY   117      43.000  29.883  12.275  1.00 33.53           N  
ATOM   1996  CA  GLY   117      43.191  30.940  13.265  1.00 32.87           C  
ATOM   1997  C   GLY   117      41.993  31.880  13.316  1.00 32.75           C  
ATOM   1998  O   GLY   117      41.549  32.261  14.400  1.00 32.20           O  
ATOM   1999  N   ARG   118      41.468  32.232  12.139  1.00 33.22           N  
ATOM   2000  CA  ARG   118      40.315  33.129  12.006  1.00 34.94           C  
ATOM   2001  C   ARG   118      39.071  32.565  12.685  1.00 33.27           C  
ATOM   2002  O   ARG   118      38.391  33.268  13.432  1.00 34.97           O  
ATOM   2003  CB  ARG   118      40.008  33.398  10.528  1.00 34.63           C  
ATOM   2004  CG  ARG   118      39.075  34.578  10.287  1.00 38.04           C  
ATOM   2005  CD  ARG   118      38.912  34.917   8.796  1.00 41.22           C  
ATOM   2006  NE  ARG   118      40.200  35.077   8.112  1.00 48.85           N  
ATOM   2007  CZ  ARG   118      41.000  36.138   8.220  1.00 48.59           C  
ATOM   2008  NH1 ARG   118      40.677  37.176   8.988  1.00 49.41           N  
ATOM   2009  NH2 ARG   118      42.145  36.158   7.557  1.00 48.99           N  
ATOM   2010  N   ALA   119      38.770  31.298  12.427  1.00 30.92           N  
ATOM   2011  CA  ALA   119      37.577  30.682  12.994  1.00 29.20           C  
ATOM   2012  C   ALA   119      37.694  30.522  14.527  1.00 28.24           C  
ATOM   2013  O   ALA   119      36.694  30.620  15.245  1.00 27.02           O  
ATOM   2014  CB  ALA   119      37.300  29.361  12.328  1.00 29.59           C  
ATOM   2015  N   LEU   120      38.907  30.297  15.027  1.00 26.93           N  
ATOM   2016  CA  LEU   120      39.125  30.231  16.467  1.00 28.00           C  
ATOM   2017  C   LEU   120      39.018  31.640  17.102  1.00 27.86           C  
ATOM   2018  O   LEU   120      38.633  31.771  18.257  1.00 27.73           O  
ATOM   2019  CB  LEU   120      40.488  29.602  16.779  1.00 29.16           C  
ATOM   2020  CG  LEU   120      40.699  29.065  18.198  1.00 29.75           C  
ATOM   2021  CD1 LEU   120      39.857  27.808  18.433  1.00 35.18           C  
ATOM   2022  CD2 LEU   120      42.165  28.759  18.433  1.00 29.74           C  
ATOM   2023  N   LEU   121      39.359  32.683  16.346  1.00 28.09           N  
ATOM   2024  CA  LEU   121      39.228  34.057  16.832  1.00 27.44           C  
ATOM   2025  C   LEU   121      37.750  34.434  17.007  1.00 28.11           C  
ATOM   2026  O   LEU   121      37.378  35.044  18.004  1.00 28.73           O  
ATOM   2027  CB  LEU   121      39.920  35.041  15.889  1.00 26.16           C  
ATOM   2028  CG  LEU   121      39.829  36.523  16.266  1.00 27.90           C  
ATOM   2029  CD1 LEU   121      40.567  36.780  17.561  1.00 23.80           C  
ATOM   2030  CD2 LEU   121      40.358  37.411  15.134  1.00 27.70           C  
ATOM   2031  N   GLN   122      36.917  34.057  16.039  1.00 28.54           N  
ATOM   2032  CA  GLN   122      35.481  34.314  16.107  1.00 30.48           C  
ATOM   2033  C   GLN   122      34.866  33.560  17.293  1.00 30.29           C  
ATOM   2034  O   GLN   122      33.977  34.061  17.983  1.00 30.33           O  
ATOM   2035  CB  GLN   122      34.788  33.907  14.790  1.00 30.73           C  
ATOM   2036  CG  GLN   122      33.269  33.730  14.930  1.00 34.32           C  
ATOM   2037  CD  GLN   122      32.527  33.691  13.616  1.00 33.25           C  
ATOM   2038  OE1 GLN   122      32.635  34.605  12.807  1.00 42.39           O  
ATOM   2039  NE2 GLN   122      31.721  32.648  13.419  1.00 35.24           N  
ATOM   2040  N   LEU   123      35.343  32.341  17.495  1.00 29.79           N  
ATOM   2041  CA  LEU   123      34.918  31.500  18.594  1.00 30.76           C  
ATOM   2042  C   LEU   123      35.297  32.158  19.938  1.00 30.05           C  
ATOM   2043  O   LEU   123      34.511  32.159  20.881  1.00 28.56           O  
ATOM   2044  CB  LEU   123      35.581  30.124  18.426  1.00 32.64           C  
ATOM   2045  CG  LEU   123      35.088  28.918  19.208  1.00 36.41           C  
ATOM   2046  CD1 LEU   123      35.493  27.647  18.473  1.00 37.74           C  
ATOM   2047  CD2 LEU   123      35.638  28.950  20.633  1.00 37.75           C  
ATOM   2048  N   ALA   124      36.509  32.710  20.008  1.00 29.00           N  
ATOM   2049  CA  ALA   124      36.979  33.433  21.183  1.00 27.92           C  
ATOM   2050  C   ALA   124      36.140  34.689  21.458  1.00 27.85           C  
ATOM   2051  O   ALA   124      35.857  35.030  22.619  1.00 27.75           O  
ATOM   2052  CB  ALA   124      38.437  33.815  20.996  1.00 27.52           C  
ATOM   2053  N   MET   125      35.737  35.368  20.384  1.00 26.51           N  
ATOM   2054  CA  MET   125      34.935  36.579  20.487  1.00 24.50           C  
ATOM   2055  C   MET   125      33.523  36.293  20.949  1.00 23.15           C  
ATOM   2056  O   MET   125      32.950  37.063  21.705  1.00 23.24           O  
ATOM   2057  CB  MET   125      34.872  37.308  19.138  1.00 23.98           C  
ATOM   2058  CG  MET   125      36.151  38.017  18.740  1.00 24.55           C  
ATOM   2059  SD  MET   125      36.568  39.523  19.855  0.75 19.69          SE  
ATOM   2060  CE  MET   125      34.822  40.421  19.829  1.00 27.99           C  
ATOM   2061  N   GLU   126      32.949  35.198  20.472  1.00 22.92           N  
ATOM   2062  CA  GLU   126      31.589  34.833  20.863  1.00 22.67           C  
ATOM   2063  C   GLU   126      31.542  34.327  22.296  1.00 23.28           C  
ATOM   2064  O   GLU   126      30.535  34.500  22.995  1.00 24.32           O  
ATOM   2065  CB  GLU   126      31.017  33.797  19.905  1.00 22.12           C  
ATOM   2066  CG  GLU   126      30.912  34.295  18.466  1.00 19.97           C  
ATOM   2067  CD  GLU   126      30.242  33.303  17.552  1.00 21.02           C  
ATOM   2068  OE1 GLU   126      29.901  32.187  18.004  1.00 25.67           O  
ATOM   2069  OE2 GLU   126      30.029  33.658  16.382  1.00 23.17           O  
ATOM   2070  N   HIS   127      32.637  33.714  22.727  1.00 24.65           N  
ATOM   2071  CA  HIS   127      32.783  33.226  24.099  1.00 25.24           C  
ATOM   2072  C   HIS   127      32.844  34.408  25.069  1.00 24.32           C  
ATOM   2073  O   HIS   127      32.184  34.415  26.118  1.00 24.41           O  
ATOM   2074  CB  HIS   127      34.050  32.389  24.183  1.00 26.17           C  
ATOM   2075  CG  HIS   127      34.235  31.687  25.484  1.00 31.32           C  
ATOM   2076  ND1 HIS   127      33.450  30.626  25.876  1.00 38.61           N  
ATOM   2077  CD2 HIS   127      35.141  31.872  26.470  1.00 36.97           C  
ATOM   2078  CE1 HIS   127      33.861  30.195  27.054  1.00 39.40           C  
ATOM   2079  NE2 HIS   127      34.881  30.938  27.438  1.00 37.60           N  
ATOM   2080  N   GLU   128      33.625  35.417  24.699  1.00 23.98           N  
ATOM   2081  CA  GLU   128      33.678  36.673  25.445  1.00 22.90           C  
ATOM   2082  C   GLU   128      32.285  37.287  25.550  1.00 21.15           C  
ATOM   2083  O   GLU   128      31.845  37.655  26.629  1.00 19.73           O  
ATOM   2084  CB  GLU   128      34.610  37.659  24.747  1.00 22.49           C  
ATOM   2085  CG  GLU   128      34.708  39.049  25.408  1.00 27.83           C  
ATOM   2086  CD  GLU   128      35.846  39.181  26.415  1.00 28.43           C  
ATOM   2087  OE1 GLU   128      36.726  38.301  26.447  1.00 27.93           O  
ATOM   2088  OE2 GLU   128      35.860  40.190  27.156  1.00 30.92           O  
ATOM   2089  N   ILE   129      31.613  37.390  24.410  1.00 20.76           N  
ATOM   2090  CA  ILE   129      30.320  38.058  24.320  1.00 20.58           C  
ATOM   2091  C   ILE   129      29.281  37.312  25.140  1.00 21.24           C  
ATOM   2092  O   ILE   129      28.513  37.931  25.863  1.00 23.67           O  
ATOM   2093  CB  ILE   129      29.858  38.233  22.840  1.00 19.95           C  
ATOM   2094  CG1 ILE   129      30.767  39.241  22.133  1.00 20.52           C  
ATOM   2095  CG2 ILE   129      28.411  38.718  22.786  1.00 19.35           C  
ATOM   2096  CD1 ILE   129      30.746  39.177  20.613  1.00 19.09           C  
ATOM   2097  N   HIS   130      29.288  35.985  25.048  1.00 21.33           N  
ATOM   2098  CA  HIS   130      28.430  35.139  25.878  1.00 19.82           C  
ATOM   2099  C   HIS   130      28.572  35.420  27.373  1.00 20.82           C  
ATOM   2100  O   HIS   130      27.583  35.721  28.048  1.00 20.66           O  
ATOM   2101  CB  HIS   130      28.727  33.658  25.615  1.00 18.93           C  
ATOM   2102  CG  HIS   130      28.027  32.732  26.553  1.00 15.45           C  
ATOM   2103  ND1 HIS   130      26.658  32.550  26.535  1.00 14.36           N  
ATOM   2104  CD2 HIS   130      28.503  31.936  27.536  1.00 13.49           C  
ATOM   2105  CE1 HIS   130      26.323  31.696  27.484  1.00 15.06           C  
ATOM   2106  NE2 HIS   130      27.423  31.317  28.111  1.00 16.03           N  
ATOM   2107  N   HIS   131      29.799  35.303  27.882  1.00 21.96           N  
ATOM   2108  CA  HIS   131      30.080  35.424  29.318  1.00 21.31           C  
ATOM   2109  C   HIS   131      29.957  36.868  29.852  1.00 22.10           C  
ATOM   2110  O   HIS   131      29.656  37.088  31.034  1.00 20.92           O  
ATOM   2111  CB  HIS   131      31.461  34.839  29.643  1.00 21.24           C  
ATOM   2112  CG  HIS   131      31.522  33.343  29.551  1.00 22.99           C  
ATOM   2113  ND1 HIS   131      30.750  32.516  30.340  1.00 25.40           N  
ATOM   2114  CD2 HIS   131      32.274  32.525  28.776  1.00 23.84           C  
ATOM   2115  CE1 HIS   131      31.012  31.255  30.044  1.00 25.83           C  
ATOM   2116  NE2 HIS   131      31.936  31.233  29.101  1.00 26.08           N  
ATOM   2117  N   LYS   132      30.195  37.854  28.993  1.00 23.34           N  
ATOM   2118  CA  LYS   132      29.890  39.237  29.349  1.00 23.59           C  
ATOM   2119  C   LYS   132      28.368  39.353  29.502  1.00 24.59           C  
ATOM   2120  O   LYS   132      27.883  40.077  30.374  1.00 25.72           O  
ATOM   2121  CB  LYS   132      30.450  40.221  28.303  1.00 24.16           C  
ATOM   2122  CG  LYS   132      29.937  41.660  28.425  1.00 22.60           C  
ATOM   2123  CD  LYS   132      30.819  42.673  27.685  1.00 23.82           C  
ATOM   2124  CE  LYS   132      31.003  42.367  26.192  1.00 26.25           C  
ATOM   2125  NZ  LYS   132      29.783  42.581  25.373  1.00 19.16           N  
ATOM   2126  N   GLY   133      27.625  38.625  28.666  1.00 24.94           N  
ATOM   2127  CA  GLY   133      26.167  38.535  28.785  1.00 23.57           C  
ATOM   2128  C   GLY   133      25.738  37.992  30.140  1.00 24.46           C  
ATOM   2129  O   GLY   133      24.797  38.507  30.745  1.00 25.42           O  
ATOM   2130  N   ASN   134      26.421  36.946  30.616  1.00 24.53           N  
ATOM   2131  CA  ASN   134      26.212  36.447  31.981  1.00 23.49           C  
ATOM   2132  C   ASN   134      26.525  37.544  32.981  1.00 23.55           C  
ATOM   2133  O   ASN   134      25.752  37.789  33.899  1.00 23.87           O  
ATOM   2134  CB  ASN   134      27.137  35.279  32.349  1.00 24.25           C  
ATOM   2135  CG  ASN   134      27.000  34.066  31.443  1.00 22.64           C  
ATOM   2136  OD1 ASN   134      27.917  33.259  31.385  1.00 27.65           O  
ATOM   2137  ND2 ASN   134      25.884  33.927  30.755  1.00 22.69           N  
ATOM   2138  N   LEU   135      27.674  38.188  32.797  1.00 23.93           N  
ATOM   2139  CA  LEU   135      28.207  39.140  33.769  1.00 24.06           C  
ATOM   2140  C   LEU   135      27.286  40.331  34.014  1.00 24.23           C  
ATOM   2141  O   LEU   135      27.195  40.795  35.130  1.00 25.52           O  
ATOM   2142  CB  LEU   135      29.599  39.605  33.340  1.00 23.83           C  
ATOM   2143  CG  LEU   135      30.452  40.451  34.291  1.00 24.29           C  
ATOM   2144  CD1 LEU   135      30.640  39.807  35.676  1.00 20.22           C  
ATOM   2145  CD2 LEU   135      31.803  40.685  33.627  1.00 24.00           C  
ATOM   2146  N   PHE   136      26.617  40.814  32.967  1.00 24.58           N  
ATOM   2147  CA  PHE   136      25.647  41.896  33.073  1.00 24.76           C  
ATOM   2148  C   PHE   136      24.547  41.609  34.115  1.00 26.40           C  
ATOM   2149  O   PHE   136      24.153  42.502  34.871  1.00 24.96           O  
ATOM   2150  CB  PHE   136      24.994  42.160  31.714  1.00 25.02           C  
ATOM   2151  CG  PHE   136      25.603  43.297  30.961  1.00 25.69           C  
ATOM   2152  CD1 PHE   136      25.197  44.595  31.219  1.00 27.75           C  
ATOM   2153  CD2 PHE   136      26.590  43.077  29.998  1.00 23.95           C  
ATOM   2154  CE1 PHE   136      25.751  45.656  30.529  1.00 27.50           C  
ATOM   2155  CE2 PHE   136      27.150  44.126  29.303  1.00 22.33           C  
ATOM   2156  CZ  PHE   136      26.732  45.426  29.568  1.00 28.13           C  
ATOM   2157  N   VAL   137      24.049  40.374  34.143  1.00 26.43           N  
ATOM   2158  CA  VAL   137      23.008  40.004  35.098  1.00 25.49           C  
ATOM   2159  C   VAL   137      23.599  39.897  36.506  1.00 26.38           C  
ATOM   2160  O   VAL   137      22.977  40.346  37.462  1.00 27.33           O  
ATOM   2161  CB  VAL   137      22.254  38.714  34.667  1.00 26.90           C  
ATOM   2162  CG1 VAL   137      21.086  38.397  35.632  1.00 22.98           C  
ATOM   2163  CG2 VAL   137      21.726  38.861  33.238  1.00 21.37           C  
ATOM   2164  N   TYR   138      24.814  39.352  36.631  1.00 27.22           N  
ATOM   2165  CA  TYR   138      25.534  39.329  37.921  1.00 27.61           C  
ATOM   2166  C   TYR   138      25.601  40.731  38.527  1.00 28.62           C  
ATOM   2167  O   TYR   138      25.164  40.955  39.664  1.00 30.89           O  
ATOM   2168  CB  TYR   138      26.980  38.813  37.775  1.00 27.23           C  
ATOM   2169  CG  TYR   138      27.175  37.304  37.716  1.00 27.29           C  
ATOM   2170  CD1 TYR   138      26.675  36.558  36.664  1.00 26.10           C  
ATOM   2171  CD2 TYR   138      27.903  36.634  38.695  1.00 29.05           C  
ATOM   2172  CE1 TYR   138      26.872  35.177  36.590  1.00 24.62           C  
ATOM   2173  CE2 TYR   138      28.092  35.252  38.642  1.00 26.24           C  
ATOM   2174  CZ  TYR   138      27.577  34.534  37.582  1.00 26.62           C  
ATOM   2175  OH  TYR   138      27.771  33.174  37.491  1.00 27.21           O  
ATOM   2176  N   VAL   139      26.146  41.666  37.754  1.00 27.99           N  
ATOM   2177  CA  VAL   139      26.404  43.039  38.215  1.00 27.23           C  
ATOM   2178  C   VAL   139      25.129  43.810  38.552  1.00 27.92           C  
ATOM   2179  O   VAL   139      25.086  44.595  39.514  1.00 26.74           O  
ATOM   2180  CB  VAL   139      27.222  43.803  37.156  1.00 28.07           C  
ATOM   2181  CG1 VAL   139      27.307  45.289  37.484  1.00 28.06           C  
ATOM   2182  CG2 VAL   139      28.624  43.174  37.012  1.00 26.48           C  
ATOM   2183  N   ARG   140      24.099  43.592  37.744  1.00 29.05           N  
ATOM   2184  CA  ARG   140      22.773  44.168  37.964  1.00 31.02           C  
ATOM   2185  C   ARG   140      22.193  43.697  39.308  1.00 30.81           C  
ATOM   2186  O   ARG   140      21.591  44.480  40.046  1.00 30.77           O  
ATOM   2187  CB  ARG   140      21.863  43.745  36.804  1.00 32.60           C  
ATOM   2188  CG  ARG   140      20.404  44.195  36.878  1.00 40.15           C  
ATOM   2189  CD  ARG   140      20.154  45.498  36.168  1.00 42.74           C  
ATOM   2190  NE  ARG   140      20.623  45.454  34.785  1.00 44.57           N  
ATOM   2191  CZ  ARG   140      20.631  46.499  33.961  1.00 43.68           C  
ATOM   2192  NH1 ARG   140      20.180  47.690  34.364  1.00 42.68           N  
ATOM   2193  NH2 ARG   140      21.097  46.350  32.724  1.00 47.01           N  
ATOM   2194  N   GLU   141      22.378  42.412  39.606  1.00 31.43           N  
ATOM   2195  CA  GLU   141      21.960  41.809  40.885  1.00 30.94           C  
ATOM   2196  C   GLU   141      22.784  42.249  42.108  1.00 31.18           C  
ATOM   2197  O   GLU   141      22.380  42.019  43.250  1.00 30.01           O  
ATOM   2198  CB  GLU   141      21.989  40.281  40.789  1.00 31.38           C  
ATOM   2199  CG  GLU   141      20.789  39.711  40.078  1.00 29.43           C  
ATOM   2200  CD  GLU   141      20.871  38.218  39.838  1.00 29.00           C  
ATOM   2201  OE1 GLU   141      21.346  37.465  40.720  1.00 24.08           O  
ATOM   2202  OE2 GLU   141      20.434  37.798  38.751  1.00 24.21           O  
ATOM   2203  N   MET   142      23.935  42.872  41.866  1.00 31.32           N  
ATOM   2204  CA  MET   142      24.788  43.379  42.938  1.00 30.72           C  
ATOM   2205  C   MET   142      24.459  44.808  43.371  1.00 32.76           C  
ATOM   2206  O   MET   142      25.194  45.384  44.180  1.00 33.35           O  
ATOM   2207  CB  MET   142      26.247  43.366  42.498  1.00 30.80           C  
ATOM   2208  CG  MET   142      26.791  42.021  42.195  1.00 29.92           C  
ATOM   2209  SD  MET   142      28.615  42.104  41.579  0.75 23.20          SE  
ATOM   2210  CE  MET   142      28.655  43.665  40.756  1.00 18.45           C  
ATOM   2211  N   GLY   143      23.394  45.393  42.822  1.00 33.02           N  
ATOM   2212  CA  GLY   143      22.959  46.714  43.243  1.00 33.47           C  
ATOM   2213  C   GLY   143      23.214  47.819  42.232  1.00 34.81           C  
ATOM   2214  O   GLY   143      22.746  48.940  42.423  1.00 35.09           O  
ATOM   2215  N   HIS   144      23.943  47.516  41.159  1.00 35.68           N  
ATOM   2216  CA  HIS   144      24.277  48.516  40.138  1.00 36.43           C  
ATOM   2217  C   HIS   144      23.212  48.593  39.051  1.00 37.25           C  
ATOM   2218  O   HIS   144      22.838  47.584  38.459  1.00 36.10           O  
ATOM   2219  CB  HIS   144      25.643  48.218  39.538  1.00 36.53           C  
ATOM   2220  CG  HIS   144      26.725  48.147  40.564  1.00 36.63           C  
ATOM   2221  ND1 HIS   144      27.392  49.264  41.015  1.00 34.51           N  
ATOM   2222  CD2 HIS   144      27.217  47.101  41.267  1.00 41.34           C  
ATOM   2223  CE1 HIS   144      28.270  48.906  41.934  1.00 40.77           C  
ATOM   2224  NE2 HIS   144      28.181  47.599  42.111  1.00 42.86           N  
ATOM   2225  N   THR   145      22.720  49.802  38.808  1.00 39.71           N  
ATOM   2226  CA  THR   145      21.653  50.030  37.835  1.00 41.21           C  
ATOM   2227  C   THR   145      22.096  50.853  36.624  1.00 43.96           C  
ATOM   2228  O   THR   145      21.370  50.917  35.626  1.00 45.11           O  
ATOM   2229  CB  THR   145      20.451  50.766  38.477  1.00 40.95           C  
ATOM   2230  OG1 THR   145      20.784  52.148  38.677  1.00 36.83           O  
ATOM   2231  CG2 THR   145      20.050  50.122  39.813  1.00 38.96           C  
ATOM   2232  N   GLU   146      23.260  51.496  36.705  1.00 45.65           N  
ATOM   2233  CA  GLU   146      23.726  52.328  35.604  1.00 47.58           C  
ATOM   2234  C   GLU   146      24.886  51.616  34.924  1.00 46.33           C  
ATOM   2235  O   GLU   146      26.059  51.845  35.238  1.00 48.08           O  
ATOM   2236  CB  GLU   146      24.105  53.725  36.101  1.00 48.88           C  
ATOM   2237  CG  GLU   146      23.685  54.842  35.148  1.00 53.87           C  
ATOM   2238  CD  GLU   146      22.186  54.817  34.818  1.00 59.74           C  
ATOM   2239  OE1 GLU   146      21.360  54.933  35.753  1.00 62.56           O  
ATOM   2240  OE2 GLU   146      21.837  54.686  33.624  1.00 60.00           O  
ATOM   2241  N   LEU   147      24.535  50.731  33.998  1.00 43.13           N  
ATOM   2242  CA  LEU   147      25.511  49.860  33.355  1.00 40.71           C  
ATOM   2243  C   LEU   147      25.797  50.305  31.923  1.00 38.85           C  
ATOM   2244  O   LEU   147      24.917  50.848  31.242  1.00 37.87           O  
ATOM   2245  CB  LEU   147      25.016  48.411  33.365  1.00 40.10           C  
ATOM   2246  CG  LEU   147      24.740  47.799  34.743  1.00 39.60           C  
ATOM   2247  CD1 LEU   147      24.125  46.436  34.588  1.00 38.09           C  
ATOM   2248  CD2 LEU   147      26.011  47.720  35.575  1.00 37.18           C  
ATOM   2249  N   PRO   148      27.036  50.070  31.457  1.00 36.83           N  
ATOM   2250  CA  PRO   148      27.359  50.459  30.092  1.00 35.09           C  
ATOM   2251  C   PRO   148      26.522  49.694  29.079  1.00 32.85           C  
ATOM   2252  O   PRO   148      25.936  48.655  29.407  1.00 32.33           O  
ATOM   2253  CB  PRO   148      28.841  50.080  29.953  1.00 34.78           C  
ATOM   2254  CG  PRO   148      29.096  49.071  31.022  1.00 36.57           C  
ATOM   2255  CD  PRO   148      28.178  49.432  32.143  1.00 37.27           C  
ATOM   2256  N   PHE   149      26.440  50.234  27.871  1.00 30.90           N  
ATOM   2257  CA  PHE   149      25.923  49.487  26.742  1.00 29.22           C  
ATOM   2258  C   PHE   149      26.911  48.343  26.533  1.00 26.36           C  
ATOM   2259  O   PHE   149      28.108  48.498  26.802  1.00 26.92           O  
ATOM   2260  CB  PHE   149      25.825  50.378  25.500  1.00 29.54           C  
ATOM   2261  CG  PHE   149      25.075  49.745  24.365  1.00 31.48           C  
ATOM   2262  CD1 PHE   149      23.731  49.412  24.508  1.00 32.96           C  
ATOM   2263  CD2 PHE   149      25.708  49.468  23.162  1.00 31.91           C  
ATOM   2264  CE1 PHE   149      23.040  48.813  23.475  1.00 33.85           C  
ATOM   2265  CE2 PHE   149      25.017  48.876  22.123  1.00 34.43           C  
ATOM   2266  CZ  PHE   149      23.683  48.546  22.282  1.00 33.21           C  
ATOM   2267  N   TYR   150      26.428  47.209  26.045  1.00 25.14           N  
ATOM   2268  CA  TYR   150      27.236  45.986  26.041  1.00 26.48           C  
ATOM   2269  C   TYR   150      28.453  45.994  25.127  1.00 25.90           C  
ATOM   2270  O   TYR   150      29.319  45.125  25.246  1.00 26.81           O  
ATOM   2271  CB  TYR   150      26.372  44.766  25.751  1.00 27.38           C  
ATOM   2272  CG  TYR   150      25.858  44.654  24.346  1.00 27.41           C  
ATOM   2273  CD1 TYR   150      26.599  44.014  23.357  1.00 26.55           C  
ATOM   2274  CD2 TYR   150      24.599  45.154  24.011  1.00 33.30           C  
ATOM   2275  CE1 TYR   150      26.103  43.901  22.050  1.00 32.66           C  
ATOM   2276  CE2 TYR   150      24.090  45.035  22.725  1.00 34.22           C  
ATOM   2277  CZ  TYR   150      24.845  44.420  21.751  1.00 33.26           C  
ATOM   2278  OH  TYR   150      24.321  44.325  20.489  1.00 36.66           O  
ATOM   2279  N   GLN   151      28.514  46.963  24.224  1.00 25.97           N  
ATOM   2280  CA  GLN   151      29.643  47.114  23.323  1.00 28.02           C  
ATOM   2281  C   GLN   151      29.928  48.601  23.100  1.00 28.27           C  
ATOM   2282  O   GLN   151      29.011  49.379  22.893  1.00 26.65           O  
ATOM   2283  CB  GLN   151      29.326  46.447  21.977  1.00 28.59           C  
ATOM   2284  CG  GLN   151      30.572  46.158  21.157  1.00 31.58           C  
ATOM   2285  CD  GLN   151      30.308  45.843  19.693  1.00 29.46           C  
ATOM   2286  OE1 GLN   151      29.163  45.768  19.260  1.00 34.99           O  
ATOM   2287  NE2 GLN   151      31.381  45.675  18.920  1.00 28.17           N  
ATOM   2288  N   GLN   152      31.196  48.988  23.151  1.00 30.83           N  
ATOM   2289  CA  GLN   152      31.596  50.336  22.767  1.00 33.70           C  
ATOM   2290  C   GLN   152      31.634  50.422  21.243  1.00 36.95           C  
ATOM   2291  O   GLN   152      31.835  49.412  20.563  1.00 37.86           O  
ATOM   2292  CB  GLN   152      32.961  50.684  23.349  1.00 32.47           C  
ATOM   2293  CG  GLN   152      32.965  50.794  24.856  1.00 33.78           C  
ATOM   2294  CD  GLN   152      34.315  51.214  25.424  1.00 35.09           C  
ATOM   2295  OE1 GLN   152      35.319  51.317  24.704  1.00 32.29           O  
ATOM   2296  NE2 GLN   152      34.342  51.450  26.731  1.00 28.38           N  
ATOM   2297  N   ARG   153      31.444  51.622  20.707  1.00 38.84           N  
ATOM   2298  CA  ARG   153      31.447  51.820  19.252  1.00 40.64           C  
ATOM   2299  C   ARG   153      32.858  51.664  18.680  1.00 42.01           C  
ATOM   2300  O   ARG   153      33.351  50.543  18.488  1.00 44.29           O  
ATOM   2301  CB  ARG   153      30.889  53.206  18.903  1.00 39.42           C  
END
