
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  170 ( 1361),  selected  170 , name 3cex_A
# Molecule2: number of CA atoms  144 ( 1145),  selected  144 , name T0481.pdb
# PARAMETERS: 3cex_A.T0481.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     0_A      -       -           -
LGA    X     1_A      -       -           -
LGA    K     2_A      -       -           -
LGA    V     3_A      -       -           -
LGA    T     4_A      -       -           -
LGA    Q     5_A      N       5          2.572
LGA    L     6_A      Q       6          2.508
LGA    S     7_A      I       7          3.093
LGA    S     8_A      V       8          1.800
LGA    E     9_A      S       9          1.817
LGA    T    10_A      H      10          2.469
LGA    L    11_A      F      11          1.953
LGA    D    12_A      L      12          1.353
LGA    R    13_A      S      13          2.772
LGA    A    14_A      H      14          2.571
LGA    H    15_A      R      15          2.433
LGA    E    16_A      N      16          2.201
LGA    R    17_A      V      17          1.756
LGA    F    18_A      T      18          2.350
LGA    E    19_A      N      19          2.880
LGA    E    20_A      E      20          2.561
LGA    T    21_A      L      21          2.101
LGA    L    22_A      A      22          2.938
LGA    A    23_A      E      23          3.043
LGA    Q    24_A      K      24          2.843
LGA    X    25_A      I      25          3.200
LGA    T    26_A      S      26          1.589
LGA    V    27_A      K      27          1.003
LGA    A    28_A      D      28          1.127
LGA    E    29_A      H      29          1.484
LGA    A    30_A      Y      30          3.081
LGA    N    31_A      S      31          2.202
LGA    T    32_A      Y      32          0.675
LGA    X    33_A      K      33          0.882
LGA    P    34_A      P      34          1.726
LGA    A    35_A      A      35          0.527
LGA    P    36_A      E      36          3.080
LGA    L    37_A      T      37          4.101
LGA    I    38_A      S      38          3.397
LGA    K    39_A      M      39          2.780
LGA    S    40_A      S      40          2.806
LGA    V    41_A      A      41          2.463
LGA    T    42_A      E      42          1.187
LGA    W    43_A      E      43          1.485
LGA    L    44_A      L      44          1.671
LGA    X    45_A      V      45          1.247
LGA    W    46_A      K      46          0.400
LGA    H    47_A      H      47          0.401
LGA    T    48_A      I      48          0.995
LGA    A    49_A      L      49          1.110
LGA    R    50_A      T      50          1.019
LGA    E    51_A      S      51          0.684
LGA    L    52_A      F      52          1.966
LGA    D    53_A      H      53          2.333
LGA    L    54_A      L      54          2.067
LGA    Q    55_A      F      55          2.208
LGA    I    56_A      A      56          2.144
LGA    S    57_A      N      57          2.724
LGA    A    58_A      V      58          3.399
LGA    L    59_A      I      59          3.460
LGA    N    60_A      K      60          3.432
LGA    H    61_A      E      61          4.172
LGA    -       -      G      62           -
LGA    -       -      N      63           -
LGA    -       -      A      64           -
LGA    -       -      S      65           -
LGA    S    62_A      P      66           #
LGA    -       -      F      67           -
LGA    -       -      Q      68           -
LGA    D    63_A      N      69          4.315
LGA    P    64_A      K      70           #
LGA    L    65_A      -       -           -
LGA    W    66_A      Q      71          3.424
LGA    L    67_A      E      72          3.439
LGA    S    68_A      -       -           -
LGA    Q    69_A      -       -           -
LGA    H    70_A      -       -           -
LGA    W    71_A      E      73          1.690
LGA    T    72_A      -       -           -
LGA    E    73_A      T      74          2.791
LGA    K    74_A      E      75          3.049
LGA    F    75_A      T      76          3.819
LGA    A    76_A      -       -           -
LGA    L    77_A      -       -           -
LGA    D    78_A      -       -           -
LGA    L    79_A      -       -           -
LGA    P    80_A      -       -           -
LGA    D    81_A      -       -           -
LGA    E    82_A      -       -           -
LGA    T    83_A      -       -           -
LGA    E    84_A      -       -           -
LGA    D    85_A      -       -           -
LGA    W    86_A      -       -           -
LGA    H    87_A      -       -           -
LGA    H    88_A      -       -           -
LGA    T    89_A      -       -           -
LGA    P    90_A      -       -           -
LGA    E    91_A      -       -           -
LGA    E    92_A      -       -           -
LGA    A    93_A      -       -           -
LGA    A    94_A      -       -           -
LGA    K    95_A      -       -           -
LGA    V    96_A      -       -           -
LGA    V    97_A      -       -           -
LGA    V    98_A      -       -           -
LGA    A    99_A      -       -           -
LGA    E   100_A      -       -           -
LGA    K   101_A      -       -           -
LGA    Q   102_A      -       -           -
LGA    L   103_A      D      77          1.890
LGA    L   104_A      L      78          1.435
LGA    S   105_A      N      79          1.864
LGA    D   106_A      V      80          1.844
LGA    Y   107_A      L      81          1.933
LGA    L   108_A      A      82          2.187
LGA    A   109_A      K      83          2.024
LGA    A   110_A      T      84          2.154
LGA    S   111_A      Y      85          1.993
LGA    V   112_A      T      86          1.908
LGA    A   113_A      E      87          1.953
LGA    L   114_A      K      88          2.278
LGA    T   115_A      T      89          2.113
LGA    K   116_A      V      90          1.803
LGA    S   117_A      A      91          1.966
LGA    Y   118_A      I      92          2.032
LGA    L   119_A      L      93          1.991
LGA    D   120_A      E      94          1.759
LGA    Q   121_A      Q      95          1.267
LGA    I   122_A      L      96          1.553
LGA    K   123_A      T      97          1.495
LGA    E   124_A      E      98          0.774
LGA    E   125_A      E      99          2.214
LGA    Q   126_A      Q     100          2.383
LGA    L   127_A      L     101          1.498
LGA    S   128_A      D     102          2.014
LGA    D   129_A      R     103          1.325
LGA    V   130_A      E     104          1.315
LGA    I   131_A      I     105          0.909
LGA    D   132_A      D     106          2.495
LGA    K   133_A      L     107          5.570
LGA    N   134_A      T     108          5.297
LGA    W   135_A      -       -           -
LGA    T   136_A      -       -           -
LGA    P   137_A      -       -           -
LGA    P   138_A      K     114          2.883
LGA    V   139_A      V     115          1.000
LGA    T   140_A      T     116          1.245
LGA    R   141_A      G     117          1.042
LGA    Q   142_A      R     118          1.060
LGA    V   143_A      A     119          1.299
LGA    R   144_A      L     120          1.278
LGA    L   145_A      L     121          1.378
LGA    V   146_A      Q     122          1.437
LGA    S   147_A      L     123          1.407
LGA    A   148_A      A     124          1.468
LGA    I   149_A      M     125          1.952
LGA    D   150_A      E     126          1.824
LGA    D   151_A      H     127          1.478
LGA    A   152_A      E     128          1.706
LGA    V   153_A      I     129          2.503
LGA    X   154_A      H     130          2.309
LGA    H   155_A      H     131          1.479
LGA    S   156_A      K     132          1.611
LGA    G   157_A      G     133          2.137
LGA    Q   158_A      N     134          1.374
LGA    A   159_A      L     135          0.709
LGA    V   160_A      F     136          0.971
LGA    Y   161_A      V     137          0.539
LGA    T   162_A      Y     138          1.136
LGA    R   163_A      V     139          1.540
LGA    R   164_A      R     140          1.853
LGA    L   165_A      E     141          2.576
LGA    V   166_A      M     142          3.534
LGA    I   167_A      G     143          2.933
LGA    G   168_A      -       -           -
LGA    K   169_A      H     144          3.672
LGA    -       -      T     145           -
LGA    -       -      E     146           -
LGA    -       -      L     147           -
LGA    -       -      P     148           -
LGA    -       -      F     149           -
LGA    -       -      Y     150           -
LGA    -       -      Q     151           -
LGA    -       -      Q     152           -
LGA    -       -      R     153           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  170  144    5.0    127    2.28    18.90     62.717     5.340

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.141090 * X  +  -0.571741 * Y  +   0.808212 * Z  +  35.788490
  Y_new =   0.976200 * X  +  -0.216164 * Y  +   0.017499 * Z  +  13.312330
  Z_new =   0.164701 * X  +   0.791445 * Y  +   0.588632 * Z  +  15.269668 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.931312   -2.210281  [ DEG:    53.3602   -126.6398 ]
  Theta =  -0.165455   -2.976137  [ DEG:    -9.4799   -170.5201 ]
  Phi   =   1.714332   -1.427260  [ DEG:    98.2240    -81.7760 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3cex_A                                        
REMARK     2: T0481.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3cex_A.T0481.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  170  144   5.0  127   2.28   18.90  62.717
REMARK  ---------------------------------------------------------- 
MOLECULE 3cex_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   29-FEB-08   3CEX              
TITLE     CRYSTAL STRUCTURE OF THE CONSERVED PROTEIN OF LOCUS EF_3021           
TITLE    2 FROM ENTEROCOCCUS FAECALIS                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: UNCHARACTERIZED PROTEIN;                                   
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: ENTEROCOCCUS FAECALIS V583;                     
SOURCE   3 STRAIN: V583;                                                        
SOURCE   4 ATCC: 700802;                                                        
SOURCE   5 GENE: EF_3021;                                                       
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PMCSG7                                    
KEYWDS    ENTEROCOCCUS FAECALIS, STRUCTURAL GENOMICS, EF_3021, PSI-2,           
KEYWDS   2 PROTEIN STRUCTURE INITIATIVE, MIDWEST CENTER FOR STRUCTURAL          
KEYWDS   3 GENOMICS, MCSG, STRUCTURAL GENOMICS, UNKNOWN FUNCTION                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    M.E.CUFF,R.WU,S.MOY,A.JOACHIMIAK,MIDWEST CENTER FOR                   
AUTHOR   2 STRUCTURAL GENOMICS (MCSG)                                           
REVDAT   1   13-MAY-08 3CEX    0                                                
JRNL        AUTH   M.E.CUFF,R.WU,S.MOY,A.JOACHIMIAK                             
JRNL        TITL   STRUCTURE OF THE CONSERVED PROTEIN OF LOCUS                  
JRNL        TITL 2 EF_3021 FROM ENTEROCOCCUS FAECALIS.                          
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  3CEX A    1   169  UNP    Q82ZN0   Q82ZN0_ENTFA     1    169             
DBREF  3CEX B    1   169  UNP    Q82ZN0   Q82ZN0_ENTFA     1    169             
SEQRES   1 A  172  SER ASN ALA MSE LYS VAL THR GLN LEU SER SER GLU THR          
SEQRES   2 A  172  LEU ASP ARG ALA HIS GLU ARG PHE GLU GLU THR LEU ALA          
SEQRES   3 A  172  GLN MSE THR VAL ALA GLU ALA ASN THR MSE PRO ALA PRO          
SEQRES   4 A  172  LEU ILE LYS SER VAL THR TRP LEU MSE TRP HIS THR ALA          
SEQRES   5 A  172  ARG GLU LEU ASP LEU GLN ILE SER ALA LEU ASN HIS SER          
SEQRES   6 A  172  ASP PRO LEU TRP LEU SER GLN HIS TRP THR GLU LYS PHE          
SEQRES   7 A  172  ALA LEU ASP LEU PRO ASP GLU THR GLU ASP TRP HIS HIS          
SEQRES   8 A  172  THR PRO GLU GLU ALA ALA LYS VAL VAL VAL ALA GLU LYS          
SEQRES   9 A  172  GLN LEU LEU SER ASP TYR LEU ALA ALA SER VAL ALA LEU          
SEQRES  10 A  172  THR LYS SER TYR LEU ASP GLN ILE LYS GLU GLU GLN LEU          
SEQRES  11 A  172  SER ASP VAL ILE ASP LYS ASN TRP THR PRO PRO VAL THR          
SEQRES  12 A  172  ARG GLN VAL ARG LEU VAL SER ALA ILE ASP ASP ALA VAL          
SEQRES  13 A  172  MSE HIS SER GLY GLN ALA VAL TYR THR ARG ARG LEU VAL          
SEQRES  14 A  172  ILE GLY LYS                                                  
SEQRES   1 B  172  SER ASN ALA MSE LYS VAL THR GLN LEU SER SER GLU THR          
SEQRES   2 B  172  LEU ASP ARG ALA HIS GLU ARG PHE GLU GLU THR LEU ALA          
SEQRES   3 B  172  GLN MSE THR VAL ALA GLU ALA ASN THR MSE PRO ALA PRO          
SEQRES   4 B  172  LEU ILE LYS SER VAL THR TRP LEU MSE TRP HIS THR ALA          
SEQRES   5 B  172  ARG GLU LEU ASP LEU GLN ILE SER ALA LEU ASN HIS SER          
SEQRES   6 B  172  ASP PRO LEU TRP LEU SER GLN HIS TRP THR GLU LYS PHE          
SEQRES   7 B  172  ALA LEU ASP LEU PRO ASP GLU THR GLU ASP TRP HIS HIS          
SEQRES   8 B  172  THR PRO GLU GLU ALA ALA LYS VAL VAL VAL ALA GLU LYS          
SEQRES   9 B  172  GLN LEU LEU SER ASP TYR LEU ALA ALA SER VAL ALA LEU          
SEQRES  10 B  172  THR LYS SER TYR LEU ASP GLN ILE LYS GLU GLU GLN LEU          
SEQRES  11 B  172  SER ASP VAL ILE ASP LYS ASN TRP THR PRO PRO VAL THR          
SEQRES  12 B  172  ARG GLN VAL ARG LEU VAL SER ALA ILE ASP ASP ALA VAL          
SEQRES  13 B  172  MSE HIS SER GLY GLN ALA VAL TYR THR ARG ARG LEU VAL          
SEQRES  14 B  172  ILE GLY LYS                                                  
HET    MSE  A   1       8                                                       
HET    MSE  A  25       8                                                       
HET    MSE  A  33       8                                                       
HET    MSE  A  45       8                                                       
HET    MSE  A 154       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B  25       8                                                       
HET    MSE  B  33       8                                                       
HET    MSE  B  45       8                                                       
HET    MSE  B 154       8                                                       
HET    ACY  A 301       4                                                       
HET    GOL  A 302       6                                                       
HET    ACY  B 301       4                                                       
HET    GOL  B 302       6                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     ACY ACETIC ACID                                                      
HETNAM     GOL GLYCEROL                                                         
FORMUL   1  MSE    10(C5 H11 N O2 SE)                                           
FORMUL   3  ACY    2(C2 H4 O2)                                                  
FORMUL   4  GOL    2(C3 H8 O3)                                                  
FORMUL   7  HOH   *188(H2 O)                                                    
CRYST1   55.191   55.137   62.429  90.00 108.20  90.00 P 1 2 1       4          
ATOM      1  N   ALA A   0      45.502  49.129   4.292  1.00 39.42           N  
ATOM      2  CA  ALA A   0      46.108  50.029   5.335  1.00 39.22           C  
ATOM      3  C   ALA A   0      45.678  49.538   6.725  1.00 39.12           C  
ATOM      4  O   ALA A   0      46.495  49.417   7.651  1.00 38.05           O  
ATOM      5  CB  ALA A   0      45.679  51.480   5.124  1.00 39.36           C  
HETATM    6  N   MSE A   1      44.398  49.223   6.857  1.00 38.70           N  
HETATM    7  CA  MSE A   1      43.913  48.701   8.112  1.00 39.78           C  
HETATM    8  C   MSE A   1      44.181  47.197   8.219  1.00 36.67           C  
HETATM    9  O   MSE A   1      44.003  46.457   7.271  1.00 35.86           O  
HETATM   10  CB  MSE A   1      42.432  48.974   8.243  1.00 39.57           C  
HETATM   11  CG  MSE A   1      41.928  48.689   9.636  1.00 42.54           C  
HETATM   12 SE   MSE A   1      40.028  49.111   9.831  0.80 49.07          SE  
HETATM   13  CE  MSE A   1      39.850  50.255   8.300  1.00 39.28           C  
ATOM     14  N   LYS A   2      44.576  46.765   9.404  1.00 34.81           N  
ATOM     15  CA  LYS A   2      44.705  45.362   9.696  1.00 33.23           C  
ATOM     16  C   LYS A   2      43.327  44.670   9.702  1.00 31.98           C  
ATOM     17  O   LYS A   2      42.327  45.270  10.142  1.00 29.51           O  
ATOM     18  CB  LYS A   2      45.388  45.172  11.059  1.00 34.88           C  
ATOM     19  CG  LYS A   2      46.868  44.847  10.987  1.00 37.55           C  
ATOM     20  CD  LYS A   2      47.759  45.886  11.614  1.00 40.64           C  
ATOM     21  CE  LYS A   2      49.182  45.320  11.691  1.00 41.60           C  
ATOM     22  NZ  LYS A   2      50.077  46.241  12.422  1.00 42.38           N  
ATOM     23  N   VAL A   3      43.293  43.417   9.227  1.00 29.75           N  
ATOM     24  CA  VAL A   3      42.060  42.624   9.190  1.00 29.50           C  
ATOM     25  C   VAL A   3      41.549  42.246  10.615  1.00 28.01           C  
ATOM     26  O   VAL A   3      40.386  41.870  10.804  1.00 28.71           O  
ATOM     27  CB  VAL A   3      42.195  41.379   8.243  1.00 29.29           C  
ATOM     28  CG1 VAL A   3      42.644  41.812   6.819  1.00 29.26           C  
ATOM     29  CG2 VAL A   3      43.150  40.350   8.820  1.00 29.49           C  
ATOM     30  N   THR A   4      42.421  42.373  11.602  1.00 27.36           N  
ATOM     31  CA  THR A   4      42.103  42.109  12.991  1.00 28.24           C  
ATOM     32  C   THR A   4      41.746  43.382  13.805  1.00 28.05           C  
ATOM     33  O   THR A   4      41.437  43.280  14.993  1.00 26.96           O  
ATOM     34  CB  THR A   4      43.315  41.423  13.676  1.00 28.93           C  
ATOM     35  OG1 THR A   4      44.460  42.281  13.582  1.00 29.25           O  
ATOM     36  CG2 THR A   4      43.638  40.009  13.020  1.00 27.71           C  
ATOM     37  N   GLN A   5      41.816  44.571  13.205  1.00 27.84           N  
ATOM     38  CA  GLN A   5      41.613  45.814  13.990  0.50 27.89           C  
ATOM     40  C   GLN A   5      40.197  45.905  14.584  1.00 28.08           C  
ATOM     41  O   GLN A   5      40.028  46.230  15.781  1.00 26.98           O  
ATOM     42  CB  GLN A   5      41.925  47.088  13.179  0.50 27.80           C  
ATOM     44  CG  GLN A   5      41.373  48.381  13.845  0.50 27.98           C  
ATOM     46  CD  GLN A   5      41.941  49.673  13.274  0.50 28.03           C  
ATOM     48  OE1 GLN A   5      42.888  49.663  12.491  0.50 29.93           O  
ATOM     50  NE2 GLN A   5      41.342  50.799  13.658  0.50 27.73           N  
ATOM     52  N   LEU A   6      39.180  45.645  13.782  1.00 27.85           N  
ATOM     53  CA  LEU A   6      37.814  45.684  14.328  1.00 28.12           C  
ATOM     54  C   LEU A   6      37.568  44.658  15.467  1.00 28.10           C  
ATOM     55  O   LEU A   6      36.878  44.992  16.445  1.00 26.80           O  
ATOM     56  CB  LEU A   6      36.738  45.605  13.231  1.00 28.18           C  
ATOM     57  CG  LEU A   6      36.644  46.733  12.187  1.00 30.18           C  
ATOM     58  CD1 LEU A   6      35.499  46.500  11.197  1.00 29.27           C  
ATOM     59  CD2 LEU A   6      36.487  48.058  12.869  1.00 31.01           C  
ATOM     60  N   SER A   7      38.132  43.452  15.362  1.00 27.73           N  
ATOM     61  CA  SER A   7      38.061  42.455  16.466  1.00 28.14           C  
ATOM     62  C   SER A   7      38.711  42.966  17.730  1.00 28.90           C  
ATOM     63  O   SER A   7      38.205  42.754  18.843  1.00 28.48           O  
ATOM     64  CB  SER A   7      38.736  41.126  16.072  1.00 28.65           C  
ATOM     65  OG  SER A   7      38.108  40.559  14.938  1.00 29.97           O  
ATOM     66  N   SER A   8      39.824  43.676  17.557  1.00 29.20           N  
ATOM     67  CA  SER A   8      40.536  44.304  18.652  1.00 29.86           C  
ATOM     68  C   SER A   8      39.703  45.394  19.369  1.00 29.51           C  
ATOM     69  O   SER A   8      39.679  45.490  20.613  1.00 29.02           O  
ATOM     70  CB  SER A   8      41.846  44.883  18.106  1.00 31.30           C  
ATOM     71  OG  SER A   8      42.717  45.137  19.150  1.00 35.97           O  
ATOM     72  N   GLU A   9      39.025  46.222  18.590  1.00 28.68           N  
ATOM     73  CA  GLU A   9      38.151  47.235  19.155  1.00 29.21           C  
ATOM     74  C   GLU A   9      36.928  46.590  19.826  1.00 28.18           C  
ATOM     75  O   GLU A   9      36.420  47.093  20.832  1.00 27.77           O  
ATOM     76  CB  GLU A   9      37.778  48.249  18.067  1.00 30.11           C  
ATOM     77  CG  GLU A   9      39.032  48.988  17.585  1.00 30.62           C  
ATOM     78  CD  GLU A   9      38.815  49.936  16.439  1.00 33.23           C  
ATOM     79  OE1 GLU A   9      37.669  50.061  15.948  1.00 39.88           O  
ATOM     80  OE2 GLU A   9      39.832  50.563  16.006  1.00 37.44           O  
ATOM     81  N   THR A  10      36.474  45.459  19.308  1.00 28.36           N  
ATOM     82  CA  THR A  10      35.359  44.720  19.927  1.00 28.34           C  
ATOM     83  C   THR A  10      35.737  44.128  21.304  1.00 28.78           C  
ATOM     84  O   THR A  10      34.903  44.143  22.283  1.00 28.72           O  
ATOM     85  CB  THR A  10      34.842  43.594  18.970  1.00 28.99           C  
ATOM     86  OG1 THR A  10      34.477  44.183  17.712  1.00 30.15           O  
ATOM     87  CG2 THR A  10      33.620  42.859  19.542  1.00 29.24           C  
ATOM     88  N   LEU A  11      36.942  43.550  21.383  1.00 28.42           N  
ATOM     89  CA  LEU A  11      37.490  43.111  22.668  1.00 29.05           C  
ATOM     90  C   LEU A  11      37.585  44.250  23.704  1.00 29.45           C  
ATOM     91  O   LEU A  11      37.263  44.049  24.905  1.00 29.75           O  
ATOM     92  CB  LEU A  11      38.849  42.410  22.443  1.00 28.94           C  
ATOM     93  CG  LEU A  11      39.541  41.820  23.679  1.00 29.69           C  
ATOM     94  CD1 LEU A  11      38.677  40.728  24.325  1.00 29.95           C  
ATOM     95  CD2 LEU A  11      40.933  41.234  23.320  1.00 28.90           C  
ATOM     96  N   ASP A  12      37.965  45.450  23.259  1.00 29.28           N  
ATOM     97  CA  ASP A  12      38.004  46.612  24.152  1.00 29.97           C  
ATOM     98  C   ASP A  12      36.633  46.901  24.783  1.00 29.44           C  
ATOM     99  O   ASP A  12      36.558  47.246  25.952  1.00 28.57           O  
ATOM    100  CB  ASP A  12      38.471  47.877  23.411  1.00 31.46           C  
ATOM    101  CG  ASP A  12      39.971  47.873  23.101  1.00 36.70           C  
ATOM    102  OD1 ASP A  12      40.729  47.181  23.835  1.00 42.92           O  
ATOM    103  OD2 ASP A  12      40.385  48.619  22.167  1.00 39.89           O  
ATOM    104  N   ARG A  13      35.550  46.719  24.035  1.00 28.94           N  
ATOM    105  CA  ARG A  13      34.214  46.906  24.616  1.00 28.96           C  
ATOM    106  C   ARG A  13      33.926  45.875  25.700  1.00 28.95           C  
ATOM    107  O   ARG A  13      33.337  46.235  26.717  1.00 30.13           O  
ATOM    108  CB  ARG A  13      33.079  46.873  23.575  1.00 28.94           C  
ATOM    109  CG  ARG A  13      33.257  47.743  22.345  1.00 30.76           C  
ATOM    110  CD  ARG A  13      33.295  49.212  22.715  1.00 31.80           C  
ATOM    111  NE  ARG A  13      33.184  49.958  21.483  1.00 33.90           N  
ATOM    112  CZ  ARG A  13      32.037  50.332  20.921  1.00 34.09           C  
ATOM    113  NH1 ARG A  13      30.874  50.106  21.517  1.00 32.72           N  
ATOM    114  NH2 ARG A  13      32.075  50.961  19.766  1.00 29.86           N  
ATOM    115  N   ALA A  14      34.317  44.618  25.503  1.00 28.10           N  
ATOM    116  CA  ALA A  14      34.181  43.578  26.551  1.00 28.67           C  
ATOM    117  C   ALA A  14      34.963  43.998  27.816  1.00 28.80           C  
ATOM    118  O   ALA A  14      34.449  43.961  28.955  1.00 27.98           O  
ATOM    119  CB  ALA A  14      34.684  42.236  26.061  1.00 28.18           C  
ATOM    120  N   HIS A  15      36.197  44.436  27.595  1.00 27.98           N  
ATOM    121  CA  HIS A  15      37.086  44.838  28.675  1.00 28.95           C  
ATOM    122  C   HIS A  15      36.468  45.963  29.497  1.00 28.79           C  
ATOM    123  O   HIS A  15      36.385  45.885  30.738  1.00 29.14           O  
ATOM    124  CB  HIS A  15      38.422  45.270  28.057  1.00 29.50           C  
ATOM    125  CG  HIS A  15      39.529  45.476  29.044  1.00 29.73           C  
ATOM    126  ND1 HIS A  15      40.745  46.007  28.676  1.00 30.06           N  
ATOM    127  CD2 HIS A  15      39.621  45.203  30.368  1.00 30.18           C  
ATOM    128  CE1 HIS A  15      41.535  46.069  29.737  1.00 31.05           C  
ATOM    129  NE2 HIS A  15      40.881  45.580  30.775  1.00 29.33           N  
ATOM    130  N   GLU A  16      36.034  47.008  28.802  1.00 29.78           N  
ATOM    131  CA  GLU A  16      35.339  48.156  29.412  1.00 31.08           C  
ATOM    132  C   GLU A  16      34.067  47.750  30.173  1.00 29.84           C  
ATOM    133  O   GLU A  16      33.797  48.242  31.283  1.00 28.44           O  
ATOM    134  CB  GLU A  16      35.027  49.227  28.317  1.00 31.06           C  
ATOM    135  CG  GLU A  16      36.321  49.816  27.758  1.00 36.38           C  
ATOM    136  CD  GLU A  16      36.238  50.577  26.399  1.00 39.74           C  
ATOM    137  OE1 GLU A  16      35.199  50.526  25.677  1.00 48.52           O  
ATOM    138  OE2 GLU A  16      37.264  51.263  26.056  1.00 49.95           O  
ATOM    139  N   ARG A  17      33.280  46.850  29.602  1.00 28.95           N  
ATOM    140  CA  ARG A  17      32.061  46.409  30.287  1.00 29.17           C  
ATOM    141  C   ARG A  17      32.351  45.675  31.615  1.00 28.57           C  
ATOM    142  O   ARG A  17      31.701  45.924  32.596  1.00 28.48           O  
ATOM    143  CB  ARG A  17      31.244  45.509  29.373  1.00 29.45           C  
ATOM    144  CG  ARG A  17      29.944  44.957  29.976  1.00 28.89           C  
ATOM    145  CD  ARG A  17      29.082  44.293  28.927  1.00 29.02           C  
ATOM    146  NE  ARG A  17      28.647  45.262  27.927  1.00 27.61           N  
ATOM    147  CZ  ARG A  17      29.020  45.276  26.642  1.00 29.12           C  
ATOM    148  NH1 ARG A  17      29.814  44.351  26.134  1.00 28.98           N  
ATOM    149  NH2 ARG A  17      28.550  46.203  25.857  1.00 31.39           N  
ATOM    150  N   PHE A  18      33.322  44.769  31.619  1.00 27.57           N  
ATOM    151  CA  PHE A  18      33.721  44.084  32.846  1.00 28.69           C  
ATOM    152  C   PHE A  18      34.174  45.112  33.925  1.00 28.42           C  
ATOM    153  O   PHE A  18      33.775  45.015  35.088  1.00 29.68           O  
ATOM    154  CB  PHE A  18      34.860  43.107  32.552  1.00 28.52           C  
ATOM    155  CG  PHE A  18      34.426  41.727  32.132  1.00 29.81           C  
ATOM    156  CD1 PHE A  18      33.743  40.908  33.005  1.00 29.83           C  
ATOM    157  CD2 PHE A  18      34.801  41.207  30.916  1.00 28.71           C  
ATOM    158  CE1 PHE A  18      33.352  39.618  32.627  1.00 31.00           C  
ATOM    159  CE2 PHE A  18      34.424  39.944  30.568  1.00 30.64           C  
ATOM    160  CZ  PHE A  18      33.694  39.155  31.446  1.00 29.27           C  
ATOM    161  N   GLU A  19      35.012  46.075  33.543  1.00 28.07           N  
ATOM    162  CA  GLU A  19      35.448  47.096  34.489  1.00 30.12           C  
ATOM    163  C   GLU A  19      34.290  47.974  35.036  1.00 29.74           C  
ATOM    164  O   GLU A  19      34.272  48.268  36.220  1.00 30.13           O  
ATOM    165  CB  GLU A  19      36.556  47.971  33.884  1.00 29.99           C  
ATOM    166  CG  GLU A  19      37.908  47.285  33.687  1.00 34.14           C  
ATOM    167  CD  GLU A  19      38.499  46.563  34.940  1.00 40.66           C  
ATOM    168  OE1 GLU A  19      38.400  47.070  36.075  1.00 43.32           O  
ATOM    169  OE2 GLU A  19      39.068  45.467  34.759  1.00 46.01           O  
ATOM    170  N   GLU A  20      33.339  48.385  34.201  1.00 29.91           N  
ATOM    171  CA  GLU A  20      32.203  49.193  34.655  1.00 31.91           C  
ATOM    172  C   GLU A  20      31.320  48.408  35.618  1.00 30.02           C  
ATOM    173  O   GLU A  20      30.765  48.971  36.550  1.00 30.60           O  
ATOM    174  CB  GLU A  20      31.312  49.651  33.490  1.00 32.40           C  
ATOM    175  CG  GLU A  20      31.979  50.563  32.510  1.00 38.00           C  
ATOM    176  CD  GLU A  20      31.185  50.803  31.203  1.00 39.49           C  
ATOM    177  OE1 GLU A  20      30.287  49.985  30.831  1.00 50.86           O  
ATOM    178  OE2 GLU A  20      31.483  51.825  30.544  1.00 48.66           O  
ATOM    179  N   THR A  21      31.152  47.117  35.364  1.00 29.45           N  
ATOM    180  CA  THR A  21      30.384  46.258  36.253  1.00 30.22           C  
ATOM    181  C   THR A  21      31.079  46.065  37.615  1.00 30.11           C  
ATOM    182  O   THR A  21      30.470  46.285  38.659  1.00 30.57           O  
ATOM    183  CB  THR A  21      30.043  44.906  35.535  1.00 30.47           C  
ATOM    184  OG1 THR A  21      28.868  45.096  34.756  1.00 33.16           O  
ATOM    185  CG2 THR A  21      29.802  43.781  36.497  1.00 30.50           C  
ATOM    186  N   LEU A  22      32.355  45.686  37.587  1.00 29.73           N  
ATOM    187  CA  LEU A  22      33.146  45.496  38.794  1.00 30.36           C  
ATOM    188  C   LEU A  22      33.202  46.738  39.687  1.00 30.14           C  
ATOM    189  O   LEU A  22      33.149  46.612  40.883  1.00 28.95           O  
ATOM    190  CB  LEU A  22      34.573  45.068  38.442  1.00 29.89           C  
ATOM    191  CG  LEU A  22      35.409  44.513  39.582  1.00 30.63           C  
ATOM    192  CD1 LEU A  22      34.801  43.215  40.163  1.00 29.80           C  
ATOM    193  CD2 LEU A  22      36.841  44.276  39.043  1.00 30.63           C  
ATOM    194  N   ALA A  23      33.304  47.915  39.080  1.00 30.29           N  
ATOM    195  CA  ALA A  23      33.312  49.182  39.797  1.00 31.26           C  
ATOM    196  C   ALA A  23      32.056  49.383  40.654  1.00 31.81           C  
ATOM    197  O   ALA A  23      32.095  50.168  41.587  1.00 32.86           O  
ATOM    198  CB  ALA A  23      33.503  50.409  38.823  1.00 30.69           C  
ATOM    199  N   GLN A  24      30.944  48.707  40.348  1.00 31.76           N  
ATOM    200  CA  GLN A  24      29.723  48.883  41.152  1.00 32.19           C  
ATOM    201  C   GLN A  24      29.649  47.936  42.326  1.00 30.92           C  
ATOM    202  O   GLN A  24      28.699  48.019  43.100  1.00 31.75           O  
ATOM    203  CB  GLN A  24      28.467  48.736  40.291  1.00 32.31           C  
ATOM    204  CG  GLN A  24      28.408  49.769  39.164  1.00 35.02           C  
ATOM    205  CD  GLN A  24      27.247  49.531  38.236  1.00 35.85           C  
ATOM    206  OE1 GLN A  24      26.068  49.598  38.653  1.00 41.02           O  
ATOM    207  NE2 GLN A  24      27.557  49.240  36.964  1.00 39.69           N  
HETATM  208  N   MSE A  25      30.629  47.051  42.492  1.00 29.30           N  
HETATM  209  CA  MSE A  25      30.500  45.983  43.476  1.00 30.41           C  
HETATM  210  C   MSE A  25      31.600  46.020  44.519  1.00 29.36           C  
HETATM  211  O   MSE A  25      32.699  46.439  44.230  1.00 30.72           O  
HETATM  212  CB  MSE A  25      30.554  44.616  42.765  1.00 29.85           C  
HETATM  213  CG  MSE A  25      29.559  44.558  41.638  1.00 31.38           C  
HETATM  214 SE   MSE A  25      29.640  42.942  40.566  0.80 35.37          SE  
HETATM  215  CE  MSE A  25      28.398  41.761  41.585  1.00 27.15           C  
ATOM    216  N   THR A  26      31.298  45.542  45.714  1.00 27.73           N  
ATOM    217  CA  THR A  26      32.334  45.175  46.687  1.00 27.85           C  
ATOM    218  C   THR A  26      32.928  43.834  46.248  1.00 27.51           C  
ATOM    219  O   THR A  26      32.348  43.153  45.403  1.00 26.64           O  
ATOM    220  CB  THR A  26      31.743  45.017  48.107  1.00 27.92           C  
ATOM    221  OG1 THR A  26      30.838  43.896  48.109  1.00 27.20           O  
ATOM    222  CG2 THR A  26      31.009  46.309  48.544  1.00 26.36           C  
ATOM    223  N   VAL A  27      34.091  43.472  46.785  1.00 27.47           N  
ATOM    224  CA  VAL A  27      34.702  42.192  46.449  1.00 27.99           C  
ATOM    225  C   VAL A  27      33.803  41.034  46.914  1.00 27.44           C  
ATOM    226  O   VAL A  27      33.692  40.048  46.212  1.00 27.23           O  
ATOM    227  CB  VAL A  27      36.174  42.041  46.991  1.00 29.13           C  
ATOM    228  CG1 VAL A  27      36.222  42.112  48.449  1.00 29.21           C  
ATOM    229  CG2 VAL A  27      36.792  40.719  46.541  1.00 29.17           C  
ATOM    230  N   ALA A  28      33.145  41.157  48.070  1.00 27.11           N  
ATOM    231  CA  ALA A  28      32.208  40.113  48.536  1.00 27.08           C  
ATOM    232  C   ALA A  28      31.074  39.881  47.540  1.00 26.78           C  
ATOM    233  O   ALA A  28      30.715  38.732  47.226  1.00 25.76           O  
ATOM    234  CB  ALA A  28      31.647  40.450  49.944  1.00 27.27           C  
ATOM    235  N   GLU A  29      30.551  40.968  46.991  1.00 26.69           N  
ATOM    236  CA  GLU A  29      29.506  40.896  45.965  1.00 26.78           C  
ATOM    237  C   GLU A  29      30.025  40.262  44.688  1.00 26.36           C  
ATOM    238  O   GLU A  29      29.344  39.417  44.092  1.00 26.50           O  
ATOM    239  CB  GLU A  29      28.943  42.284  45.657  1.00 26.55           C  
ATOM    240  CG  GLU A  29      27.921  42.743  46.722  1.00 27.58           C  
ATOM    241  CD  GLU A  29      27.697  44.239  46.765  1.00 28.77           C  
ATOM    242  OE1 GLU A  29      28.329  44.990  45.969  1.00 28.49           O  
ATOM    243  OE2 GLU A  29      26.863  44.670  47.612  1.00 29.51           O  
ATOM    244  N   ALA A  30      31.208  40.680  44.265  1.00 26.21           N  
ATOM    245  CA  ALA A  30      31.844  40.136  43.058  1.00 26.46           C  
ATOM    246  C   ALA A  30      32.065  38.636  43.174  1.00 26.59           C  
ATOM    247  O   ALA A  30      31.984  37.920  42.178  1.00 26.68           O  
ATOM    248  CB  ALA A  30      33.189  40.826  42.809  1.00 25.77           C  
ATOM    249  N   ASN A  31      32.398  38.176  44.380  1.00 26.30           N  
ATOM    250  CA  ASN A  31      32.609  36.746  44.653  1.00 27.05           C  
ATOM    251  C   ASN A  31      31.320  35.918  44.766  1.00 27.43           C  
ATOM    252  O   ASN A  31      31.380  34.710  44.946  1.00 27.12           O  
ATOM    253  CB  ASN A  31      33.376  36.592  45.980  1.00 27.04           C  
ATOM    254  CG  ASN A  31      34.831  36.973  45.867  1.00 26.59           C  
ATOM    255  OD1 ASN A  31      35.407  36.931  44.789  1.00 26.38           O  
ATOM    256  ND2 ASN A  31      35.441  37.302  46.990  1.00 25.19           N  
ATOM    257  N   THR A  32      30.160  36.566  44.719  1.00 27.83           N  
ATOM    258  CA  THR A  32      28.910  35.902  45.008  1.00 28.30           C  
ATOM    259  C   THR A  32      28.331  35.244  43.776  1.00 30.46           C  
ATOM    260  O   THR A  32      28.078  35.916  42.751  1.00 28.41           O  
ATOM    261  CB  THR A  32      27.890  36.875  45.584  1.00 28.35           C  
ATOM    262  OG1 THR A  32      28.394  37.357  46.835  1.00 29.20           O  
ATOM    263  CG2 THR A  32      26.511  36.185  45.814  1.00 27.32           C  
HETATM  264  N   MSE A  33      28.084  33.935  43.870  1.00 32.02           N  
HETATM  265  CA  MSE A  33      27.415  33.266  42.748  1.00 35.70           C  
HETATM  266  C   MSE A  33      25.950  33.074  43.093  1.00 35.14           C  
HETATM  267  O   MSE A  33      25.629  32.421  44.090  1.00 35.08           O  
HETATM  268  CB  MSE A  33      28.188  32.027  42.246  1.00 35.13           C  
HETATM  269  CG  MSE A  33      28.049  30.751  42.925  1.00 39.65           C  
HETATM  270 SE   MSE A  33      29.041  29.403  41.843  0.80 44.88          SE  
HETATM  271  CE  MSE A  33      27.717  28.899  40.514  1.00 40.88           C  
ATOM    272  N   PRO A  34      25.051  33.759  42.354  1.00 35.38           N  
ATOM    273  CA  PRO A  34      23.642  33.760  42.746  1.00 35.75           C  
ATOM    274  C   PRO A  34      22.846  32.448  42.549  1.00 36.21           C  
ATOM    275  O   PRO A  34      21.742  32.335  43.080  1.00 36.80           O  
ATOM    276  CB  PRO A  34      23.030  34.928  41.934  1.00 35.97           C  
ATOM    277  CG  PRO A  34      23.950  35.219  40.851  1.00 34.56           C  
ATOM    278  CD  PRO A  34      25.299  34.620  41.184  1.00 35.28           C  
ATOM    279  N   ALA A  35      23.400  31.464  41.848  1.00 36.38           N  
ATOM    280  CA  ALA A  35      22.686  30.206  41.574  1.00 36.16           C  
ATOM    281  C   ALA A  35      23.678  29.199  41.021  1.00 36.41           C  
ATOM    282  O   ALA A  35      24.731  29.583  40.518  1.00 36.06           O  
ATOM    283  CB  ALA A  35      21.532  30.429  40.567  1.00 35.83           C  
ATOM    284  N   PRO A  36      23.354  27.894  41.114  1.00 36.24           N  
ATOM    285  CA  PRO A  36      24.274  26.868  40.599  1.00 35.86           C  
ATOM    286  C   PRO A  36      24.829  27.095  39.195  1.00 35.45           C  
ATOM    287  O   PRO A  36      26.000  26.775  38.951  1.00 36.72           O  
ATOM    288  CB  PRO A  36      23.433  25.581  40.679  1.00 36.67           C  
ATOM    289  CG  PRO A  36      22.521  25.830  41.825  1.00 36.39           C  
ATOM    290  CD  PRO A  36      22.183  27.296  41.789  1.00 36.39           C  
ATOM    291  N   LEU A  37      24.016  27.670  38.295  1.00 34.48           N  
ATOM    292  CA  LEU A  37      24.366  27.823  36.884  1.00 33.38           C  
ATOM    293  C   LEU A  37      24.629  29.275  36.492  1.00 31.35           C  
ATOM    294  O   LEU A  37      24.837  29.555  35.325  1.00 31.74           O  
ATOM    295  CB  LEU A  37      23.248  27.253  35.977  1.00 34.00           C  
ATOM    296  CG  LEU A  37      22.782  25.816  36.270  1.00 34.10           C  
ATOM    297  CD1 LEU A  37      21.608  25.366  35.408  1.00 35.17           C  
ATOM    298  CD2 LEU A  37      23.966  24.873  36.107  1.00 33.34           C  
ATOM    299  N   ILE A  38      24.589  30.179  37.466  1.00 29.43           N  
ATOM    300  CA  ILE A  38      24.876  31.568  37.267  1.00 28.23           C  
ATOM    301  C   ILE A  38      26.202  31.870  37.981  1.00 27.71           C  
ATOM    302  O   ILE A  38      26.273  31.858  39.223  1.00 29.22           O  
ATOM    303  CB  ILE A  38      23.750  32.454  37.824  1.00 27.95           C  
ATOM    304  CG1 ILE A  38      22.402  32.070  37.215  1.00 28.82           C  
ATOM    305  CG2 ILE A  38      24.101  33.936  37.617  1.00 25.93           C  
ATOM    306  CD1 ILE A  38      22.334  32.209  35.682  1.00 28.47           C  
ATOM    307  N   LYS A  39      27.245  32.061  37.202  1.00 26.46           N  
ATOM    308  CA  LYS A  39      28.586  32.369  37.694  1.00 26.01           C  
ATOM    309  C   LYS A  39      28.688  33.766  38.338  1.00 25.90           C  
ATOM    310  O   LYS A  39      27.976  34.713  37.968  1.00 25.64           O  
ATOM    311  CB  LYS A  39      29.624  32.223  36.558  1.00 26.45           C  
ATOM    312  CG  LYS A  39      29.674  30.843  35.824  1.00 27.18           C  
ATOM    313  CD  LYS A  39      30.209  29.720  36.750  1.00 30.28           C  
ATOM    314  CE  LYS A  39      30.712  28.528  35.922  1.00 32.90           C  
ATOM    315  NZ  LYS A  39      29.613  27.647  35.388  1.00 31.71           N  
ATOM    316  N   SER A  40      29.555  33.877  39.336  1.00 25.63           N  
ATOM    317  CA  SER A  40      29.914  35.162  39.933  1.00 25.41           C  
ATOM    318  C   SER A  40      30.629  36.032  38.937  1.00 25.32           C  
ATOM    319  O   SER A  40      31.196  35.526  37.959  1.00 25.37           O  
ATOM    320  CB  SER A  40      30.820  34.954  41.153  1.00 25.88           C  
ATOM    321  OG  SER A  40      32.103  34.459  40.821  1.00 24.91           O  
ATOM    322  N   VAL A  41      30.608  37.335  39.178  1.00 25.00           N  
ATOM    323  CA  VAL A  41      31.408  38.269  38.365  1.00 25.32           C  
ATOM    324  C   VAL A  41      32.891  37.937  38.497  1.00 24.91           C  
ATOM    325  O   VAL A  41      33.610  37.954  37.512  1.00 25.55           O  
ATOM    326  CB  VAL A  41      31.105  39.752  38.690  1.00 24.83           C  
ATOM    327  CG1 VAL A  41      32.071  40.713  37.980  1.00 25.77           C  
ATOM    328  CG2 VAL A  41      29.671  40.074  38.295  1.00 25.76           C  
ATOM    329  N   THR A  42      33.339  37.564  39.687  1.00 24.76           N  
ATOM    330  CA  THR A  42      34.737  37.140  39.864  1.00 24.95           C  
ATOM    331  C   THR A  42      35.062  35.947  38.953  1.00 24.97           C  
ATOM    332  O   THR A  42      36.074  35.978  38.222  1.00 23.89           O  
ATOM    333  CB  THR A  42      35.057  36.758  41.301  1.00 24.00           C  
ATOM    334  OG1 THR A  42      35.005  37.915  42.130  1.00 24.98           O  
ATOM    335  CG2 THR A  42      36.474  36.133  41.405  1.00 24.64           C  
ATOM    336  N   TRP A  43      34.204  34.922  38.949  1.00 25.51           N  
ATOM    337  CA  TRP A  43      34.442  33.758  38.047  1.00 25.85           C  
ATOM    338  C   TRP A  43      34.476  34.169  36.566  1.00 26.33           C  
ATOM    339  O   TRP A  43      35.343  33.740  35.812  1.00 24.04           O  
ATOM    340  CB  TRP A  43      33.393  32.677  38.259  1.00 26.97           C  
ATOM    341  CG  TRP A  43      33.706  31.355  37.550  1.00 27.08           C  
ATOM    342  CD1 TRP A  43      34.243  30.243  38.127  1.00 29.10           C  
ATOM    343  CD2 TRP A  43      33.510  31.027  36.159  1.00 27.25           C  
ATOM    344  NE1 TRP A  43      34.389  29.252  37.209  1.00 28.64           N  
ATOM    345  CE2 TRP A  43      33.960  29.695  35.985  1.00 29.20           C  
ATOM    346  CE3 TRP A  43      32.993  31.716  35.050  1.00 29.16           C  
ATOM    347  CZ2 TRP A  43      33.905  29.028  34.738  1.00 29.22           C  
ATOM    348  CZ3 TRP A  43      32.957  31.060  33.799  1.00 29.38           C  
ATOM    349  CH2 TRP A  43      33.423  29.736  33.657  1.00 28.13           C  
ATOM    350  N   LEU A  44      33.512  35.006  36.161  1.00 26.95           N  
ATOM    351  CA  LEU A  44      33.403  35.452  34.759  1.00 27.62           C  
ATOM    352  C   LEU A  44      34.622  36.230  34.288  1.00 28.23           C  
ATOM    353  O   LEU A  44      35.117  36.016  33.182  1.00 28.91           O  
ATOM    354  CB  LEU A  44      32.130  36.295  34.565  1.00 27.03           C  
ATOM    355  CG  LEU A  44      30.857  35.455  34.653  1.00 25.79           C  
ATOM    356  CD1 LEU A  44      29.613  36.310  34.874  1.00 27.37           C  
ATOM    357  CD2 LEU A  44      30.713  34.580  33.347  1.00 26.28           C  
HETATM  358  N   MSE A  45      35.104  37.141  35.119  1.00 28.91           N  
HETATM  359  CA  MSE A  45      36.301  37.934  34.772  1.00 30.32           C  
HETATM  360  C   MSE A  45      37.568  37.107  34.801  1.00 28.84           C  
HETATM  361  O   MSE A  45      38.375  37.221  33.927  1.00 28.89           O  
HETATM  362  CB  MSE A  45      36.476  39.103  35.735  1.00 29.61           C  
HETATM  363  CG  MSE A  45      35.731  40.254  35.345  1.00 35.01           C  
HETATM  364 SE   MSE A  45      36.103  41.871  36.359  0.80 39.17          SE  
HETATM  365  CE  MSE A  45      37.610  42.693  35.506  1.00 32.43           C  
ATOM    366  N   TRP A  46      37.737  36.270  35.814  1.00 29.10           N  
ATOM    367  CA  TRP A  46      38.881  35.357  35.856  1.00 28.91           C  
ATOM    368  C   TRP A  46      38.856  34.421  34.646  1.00 28.75           C  
ATOM    369  O   TRP A  46      39.870  34.228  33.957  1.00 26.91           O  
ATOM    370  CB  TRP A  46      38.825  34.528  37.138  1.00 28.69           C  
ATOM    371  CG  TRP A  46      39.731  33.358  37.098  1.00 29.12           C  
ATOM    372  CD1 TRP A  46      41.076  33.364  37.346  1.00 29.15           C  
ATOM    373  CD2 TRP A  46      39.390  31.996  36.777  1.00 28.42           C  
ATOM    374  NE1 TRP A  46      41.566  32.115  37.209  1.00 28.83           N  
ATOM    375  CE2 TRP A  46      40.560  31.255  36.863  1.00 28.50           C  
ATOM    376  CE3 TRP A  46      38.194  31.343  36.426  1.00 28.93           C  
ATOM    377  CZ2 TRP A  46      40.593  29.871  36.635  1.00 29.34           C  
ATOM    378  CZ3 TRP A  46      38.216  30.014  36.195  1.00 28.54           C  
ATOM    379  CH2 TRP A  46      39.412  29.274  36.288  1.00 30.33           C  
ATOM    380  N   HIS A  47      37.675  33.861  34.356  1.00 28.13           N  
ATOM    381  CA  HIS A  47      37.559  32.928  33.243  1.00 29.04           C  
ATOM    382  C   HIS A  47      37.863  33.574  31.901  1.00 28.72           C  
ATOM    383  O   HIS A  47      38.523  32.974  31.087  1.00 28.43           O  
ATOM    384  CB  HIS A  47      36.185  32.277  33.153  1.00 30.84           C  
ATOM    385  CG  HIS A  47      35.920  31.644  31.819  1.00 32.93           C  
ATOM    386  ND1 HIS A  47      36.359  30.383  31.500  1.00 34.37           N  
ATOM    387  CD2 HIS A  47      35.298  32.120  30.710  1.00 37.34           C  
ATOM    388  CE1 HIS A  47      36.002  30.094  30.258  1.00 35.48           C  
ATOM    389  NE2 HIS A  47      35.367  31.134  29.750  1.00 37.74           N  
ATOM    390  N   THR A  48      37.364  34.790  31.683  1.00 28.43           N  
ATOM    391  CA  THR A  48      37.635  35.526  30.452  1.00 28.21           C  
ATOM    392  C   THR A  48      39.133  35.801  30.317  1.00 28.88           C  
ATOM    393  O   THR A  48      39.692  35.567  29.259  1.00 28.47           O  
ATOM    394  CB  THR A  48      36.799  36.806  30.387  1.00 28.89           C  
ATOM    395  OG1 THR A  48      35.409  36.412  30.392  1.00 29.57           O  
ATOM    396  CG2 THR A  48      37.114  37.667  29.101  1.00 28.24           C  
ATOM    397  N   ALA A  49      39.775  36.300  31.373  1.00 28.15           N  
ATOM    398  CA  ALA A  49      41.220  36.540  31.346  1.00 28.74           C  
ATOM    399  C   ALA A  49      41.951  35.217  31.110  1.00 29.45           C  
ATOM    400  O   ALA A  49      42.890  35.161  30.312  1.00 29.52           O  
ATOM    401  CB  ALA A  49      41.684  37.193  32.627  1.00 27.71           C  
ATOM    402  N   ARG A  50      41.514  34.164  31.777  1.00 30.50           N  
ATOM    403  CA  ARG A  50      42.160  32.860  31.677  1.00 31.61           C  
ATOM    404  C   ARG A  50      42.042  32.255  30.271  1.00 32.45           C  
ATOM    405  O   ARG A  50      43.009  31.679  29.747  1.00 33.03           O  
ATOM    406  CB  ARG A  50      41.590  31.933  32.768  1.00 32.61           C  
ATOM    407  CG  ARG A  50      42.272  30.628  32.997  1.00 35.12           C  
ATOM    408  CD  ARG A  50      43.516  30.731  33.836  1.00 41.19           C  
ATOM    409  NE  ARG A  50      43.791  29.398  34.378  1.00 46.31           N  
ATOM    410  CZ  ARG A  50      44.626  28.495  33.862  1.00 48.28           C  
ATOM    411  NH1 ARG A  50      45.351  28.759  32.781  1.00 51.62           N  
ATOM    412  NH2 ARG A  50      44.755  27.314  34.451  1.00 50.79           N  
ATOM    413  N   GLU A  51      40.879  32.403  29.641  1.00 32.40           N  
ATOM    414  CA  GLU A  51      40.677  31.812  28.344  1.00 33.76           C  
ATOM    415  C   GLU A  51      41.422  32.564  27.216  1.00 33.32           C  
ATOM    416  O   GLU A  51      41.925  31.925  26.294  1.00 32.91           O  
ATOM    417  CB  GLU A  51      39.172  31.714  28.049  1.00 34.59           C  
ATOM    418  CG  GLU A  51      38.846  31.019  26.775  1.00 40.83           C  
ATOM    419  CD  GLU A  51      38.953  29.500  26.838  1.00 45.94           C  
ATOM    420  OE1 GLU A  51      39.662  28.938  27.703  1.00 52.58           O  
ATOM    421  OE2 GLU A  51      38.313  28.855  25.989  1.00 52.67           O  
ATOM    422  N   LEU A  52      41.421  33.898  27.252  1.00 32.47           N  
ATOM    423  CA  LEU A  52      42.287  34.697  26.354  1.00 32.50           C  
ATOM    424  C   LEU A  52      43.761  34.312  26.512  1.00 32.49           C  
ATOM    425  O   LEU A  52      44.486  34.071  25.530  1.00 32.06           O  
ATOM    426  CB  LEU A  52      42.109  36.196  26.627  1.00 31.82           C  
ATOM    427  CG  LEU A  52      40.722  36.819  26.304  1.00 32.17           C  
ATOM    428  CD1 LEU A  52      40.614  38.272  26.796  1.00 30.56           C  
ATOM    429  CD2 LEU A  52      40.428  36.723  24.797  1.00 31.84           C  
ATOM    430  N   ASP A  53      44.228  34.331  27.755  1.00 31.68           N  
ATOM    431  CA  ASP A  53      45.580  33.913  28.088  1.00 32.33           C  
ATOM    432  C   ASP A  53      45.905  32.523  27.490  1.00 31.49           C  
ATOM    433  O   ASP A  53      46.766  32.394  26.620  1.00 31.73           O  
ATOM    434  CB  ASP A  53      45.736  33.908  29.628  1.00 31.53           C  
ATOM    435  CG  ASP A  53      47.157  33.615  30.096  1.00 32.70           C  
ATOM    436  OD1 ASP A  53      48.116  33.698  29.292  1.00 30.34           O  
ATOM    437  OD2 ASP A  53      47.306  33.336  31.315  1.00 30.69           O  
ATOM    438  N   LEU A  54      45.198  31.499  27.936  1.00 31.59           N  
ATOM    439  CA  LEU A  54      45.469  30.130  27.464  1.00 32.73           C  
ATOM    440  C   LEU A  54      45.396  29.966  25.941  1.00 31.95           C  
ATOM    441  O   LEU A  54      46.253  29.328  25.336  1.00 29.84           O  
ATOM    442  CB  LEU A  54      44.521  29.134  28.118  1.00 34.12           C  
ATOM    443  CG  LEU A  54      44.868  28.783  29.567  1.00 38.00           C  
ATOM    444  CD1 LEU A  54      43.791  27.837  30.109  1.00 42.17           C  
ATOM    445  CD2 LEU A  54      46.259  28.175  29.689  1.00 41.93           C  
ATOM    446  N   GLN A  55      44.378  30.530  25.318  1.00 32.14           N  
ATOM    447  CA  GLN A  55      44.217  30.321  23.875  1.00 33.13           C  
ATOM    448  C   GLN A  55      45.251  31.065  23.032  1.00 33.38           C  
ATOM    449  O   GLN A  55      45.778  30.506  22.055  1.00 32.87           O  
ATOM    450  CB  GLN A  55      42.833  30.728  23.409  1.00 33.48           C  
ATOM    451  CG  GLN A  55      41.687  29.880  23.975  1.00 36.24           C  
ATOM    452  CD  GLN A  55      41.645  28.453  23.482  1.00 41.99           C  
ATOM    453  OE1 GLN A  55      42.598  27.932  22.874  1.00 44.50           O  
ATOM    454  NE2 GLN A  55      40.537  27.794  23.772  1.00 45.63           N  
ATOM    455  N   ILE A  56      45.500  32.327  23.385  1.00 32.81           N  
ATOM    456  CA  ILE A  56      46.477  33.130  22.673  1.00 33.86           C  
ATOM    457  C   ILE A  56      47.862  32.615  22.975  1.00 34.04           C  
ATOM    458  O   ILE A  56      48.683  32.550  22.081  1.00 34.99           O  
ATOM    459  CB  ILE A  56      46.401  34.657  23.013  1.00 33.29           C  
ATOM    460  CG1 ILE A  56      45.065  35.249  22.577  1.00 33.23           C  
ATOM    461  CG2 ILE A  56      47.585  35.412  22.354  1.00 33.11           C  
ATOM    462  CD1 ILE A  56      44.876  35.331  21.078  1.00 31.03           C  
ATOM    463  N   SER A  57      48.131  32.216  24.210  1.00 34.57           N  
ATOM    464  CA  SER A  57      49.471  31.677  24.526  1.00 35.24           C  
ATOM    465  C   SER A  57      49.743  30.372  23.761  1.00 35.94           C  
ATOM    466  O   SER A  57      50.853  30.164  23.303  1.00 36.64           O  
ATOM    467  CB  SER A  57      49.664  31.483  26.028  1.00 34.22           C  
ATOM    468  OG  SER A  57      49.656  32.743  26.680  1.00 34.34           O  
ATOM    469  N   ALA A  58      48.728  29.518  23.627  1.00 36.93           N  
ATOM    470  CA  ALA A  58      48.803  28.298  22.806  1.00 37.78           C  
ATOM    471  C   ALA A  58      49.050  28.579  21.298  1.00 38.90           C  
ATOM    472  O   ALA A  58      49.873  27.930  20.683  1.00 39.32           O  
ATOM    473  CB  ALA A  58      47.540  27.446  23.001  1.00 37.07           C  
ATOM    474  N   LEU A  59      48.359  29.550  20.709  1.00 39.96           N  
ATOM    475  CA  LEU A  59      48.664  29.993  19.333  1.00 41.21           C  
ATOM    476  C   LEU A  59      50.073  30.581  19.189  1.00 42.62           C  
ATOM    477  O   LEU A  59      50.665  30.538  18.115  1.00 43.22           O  
ATOM    478  CB  LEU A  59      47.667  31.053  18.868  1.00 40.71           C  
ATOM    479  CG  LEU A  59      46.228  30.592  18.672  1.00 39.91           C  
ATOM    480  CD1 LEU A  59      45.373  31.791  18.363  1.00 38.12           C  
ATOM    481  CD2 LEU A  59      46.109  29.515  17.565  1.00 38.75           C  
ATOM    482  N   ASN A  60      50.579  31.160  20.276  1.00 44.07           N  
ATOM    483  CA  ASN A  60      51.866  31.834  20.292  1.00 44.88           C  
ATOM    484  C   ASN A  60      52.980  30.903  20.757  1.00 45.46           C  
ATOM    485  O   ASN A  60      54.109  31.340  20.931  1.00 46.43           O  
ATOM    486  CB  ASN A  60      51.769  33.038  21.224  1.00 45.31           C  
ATOM    487  CG  ASN A  60      52.694  34.141  20.846  1.00 47.42           C  
ATOM    488  OD1 ASN A  60      52.657  34.624  19.720  1.00 51.17           O  
ATOM    489  ND2 ASN A  60      53.537  34.569  21.791  1.00 48.90           N  
ATOM    490  N   HIS A  61      52.647  29.631  20.982  1.00 45.76           N  
ATOM    491  CA  HIS A  61      53.576  28.629  21.496  1.00 46.16           C  
ATOM    492  C   HIS A  61      54.325  29.071  22.759  1.00 45.91           C  
ATOM    493  O   HIS A  61      55.449  28.620  23.000  1.00 46.28           O  
ATOM    494  CB  HIS A  61      54.563  28.187  20.381  1.00 47.52           C  
ATOM    495  CG  HIS A  61      53.874  27.612  19.180  1.00 50.53           C  
ATOM    496  ND1 HIS A  61      53.582  26.268  19.059  1.00 53.21           N  
ATOM    497  CD2 HIS A  61      53.358  28.208  18.076  1.00 54.06           C  
ATOM    498  CE1 HIS A  61      52.935  26.059  17.925  1.00 53.43           C  
ATOM    499  NE2 HIS A  61      52.782  27.220  17.310  1.00 54.27           N  
ATOM    500  N   SER A  62      53.704  29.936  23.566  1.00 44.84           N  
ATOM    501  CA  SER A  62      54.332  30.451  24.789  1.00 43.54           C  
ATOM    502  C   SER A  62      53.578  29.901  25.997  1.00 42.38           C  
ATOM    503  O   SER A  62      52.424  29.465  25.880  1.00 42.02           O  
ATOM    504  CB  SER A  62      54.386  32.000  24.794  1.00 43.87           C  
ATOM    505  OG  SER A  62      53.111  32.643  24.546  1.00 46.39           O  
ATOM    506  N   ASP A  63      54.248  29.888  27.147  1.00 40.66           N  
ATOM    507  CA  ASP A  63      53.614  29.491  28.409  1.00 39.48           C  
ATOM    508  C   ASP A  63      52.568  30.563  28.739  1.00 37.18           C  
ATOM    509  O   ASP A  63      52.822  31.740  28.522  1.00 37.71           O  
ATOM    510  CB  ASP A  63      54.643  29.420  29.562  1.00 39.86           C  
ATOM    511  CG  ASP A  63      55.229  28.004  29.783  1.00 43.18           C  
ATOM    512  OD1 ASP A  63      54.858  27.032  29.065  1.00 46.90           O  
ATOM    513  OD2 ASP A  63      56.077  27.862  30.698  1.00 44.74           O  
ATOM    514  N   PRO A  64      51.413  30.174  29.279  1.00 34.74           N  
ATOM    515  CA  PRO A  64      50.434  31.198  29.636  1.00 33.81           C  
ATOM    516  C   PRO A  64      50.903  32.114  30.767  1.00 31.93           C  
ATOM    517  O   PRO A  64      51.700  31.700  31.598  1.00 30.66           O  
ATOM    518  CB  PRO A  64      49.216  30.376  30.072  1.00 34.12           C  
ATOM    519  CG  PRO A  64      49.754  29.093  30.488  1.00 34.85           C  
ATOM    520  CD  PRO A  64      50.923  28.820  29.594  1.00 35.67           C  
ATOM    521  N   LEU A  65      50.423  33.352  30.778  1.00 30.80           N  
ATOM    522  CA  LEU A  65      50.796  34.333  31.801  1.00 30.62           C  
ATOM    523  C   LEU A  65      50.396  33.882  33.196  1.00 30.02           C  
ATOM    524  O   LEU A  65      51.073  34.225  34.176  1.00 29.27           O  
ATOM    525  CB  LEU A  65      50.148  35.694  31.522  1.00 29.80           C  
ATOM    526  CG  LEU A  65      50.347  36.301  30.142  1.00 30.34           C  
ATOM    527  CD1 LEU A  65      49.466  37.530  30.038  1.00 30.04           C  
ATOM    528  CD2 LEU A  65      51.805  36.623  29.838  1.00 30.30           C  
ATOM    529  N   TRP A  66      49.298  33.121  33.278  1.00 29.14           N  
ATOM    530  CA  TRP A  66      48.819  32.525  34.529  1.00 29.64           C  
ATOM    531  C   TRP A  66      49.985  31.946  35.333  1.00 29.99           C  
ATOM    532  O   TRP A  66      50.068  32.141  36.555  1.00 29.65           O  
ATOM    533  CB  TRP A  66      47.805  31.415  34.217  1.00 28.59           C  
ATOM    534  CG  TRP A  66      47.167  30.750  35.404  1.00 28.24           C  
ATOM    535  CD1 TRP A  66      47.307  29.448  35.781  1.00 26.72           C  
ATOM    536  CD2 TRP A  66      46.279  31.345  36.360  1.00 27.28           C  
ATOM    537  NE1 TRP A  66      46.548  29.188  36.893  1.00 26.78           N  
ATOM    538  CE2 TRP A  66      45.927  30.333  37.292  1.00 26.41           C  
ATOM    539  CE3 TRP A  66      45.766  32.628  36.537  1.00 26.23           C  
ATOM    540  CZ2 TRP A  66      45.060  30.563  38.363  1.00 27.45           C  
ATOM    541  CZ3 TRP A  66      44.892  32.859  37.591  1.00 26.17           C  
ATOM    542  CH2 TRP A  66      44.560  31.841  38.501  1.00 28.18           C  
ATOM    543  N   LEU A  67      50.851  31.228  34.613  1.00 30.22           N  
ATOM    544  CA  LEU A  67      52.089  30.659  35.118  1.00 31.32           C  
ATOM    545  C   LEU A  67      53.298  31.593  34.952  1.00 31.58           C  
ATOM    546  O   LEU A  67      53.990  31.906  35.915  1.00 31.68           O  
ATOM    547  CB  LEU A  67      52.384  29.347  34.386  1.00 31.75           C  
ATOM    548  CG  LEU A  67      51.394  28.199  34.599  1.00 33.18           C  
ATOM    549  CD1 LEU A  67      51.905  26.962  33.829  1.00 36.67           C  
ATOM    550  CD2 LEU A  67      51.191  27.871  36.090  1.00 32.52           C  
ATOM    551  N   SER A  68      53.550  32.032  33.726  1.00 31.95           N  
ATOM    552  CA  SER A  68      54.758  32.806  33.421  1.00 32.33           C  
ATOM    553  C   SER A  68      54.881  34.146  34.174  1.00 32.22           C  
ATOM    554  O   SER A  68      55.981  34.585  34.473  1.00 32.24           O  
ATOM    555  CB  SER A  68      54.876  33.046  31.912  1.00 32.86           C  
ATOM    556  OG  SER A  68      54.134  34.191  31.510  1.00 32.55           O  
ATOM    557  N   GLN A  69      53.762  34.791  34.473  1.00 32.03           N  
ATOM    558  CA  GLN A  69      53.754  36.018  35.302  1.00 31.93           C  
ATOM    559  C   GLN A  69      53.280  35.731  36.738  1.00 31.30           C  
ATOM    560  O   GLN A  69      53.109  36.641  37.535  1.00 31.36           O  
ATOM    561  CB  GLN A  69      52.876  37.091  34.672  1.00 31.96           C  
ATOM    562  CG  GLN A  69      53.476  37.763  33.455  1.00 33.10           C  
ATOM    563  CD  GLN A  69      52.550  38.769  32.810  1.00 34.30           C  
ATOM    564  OE1 GLN A  69      51.430  38.983  33.248  1.00 35.93           O  
ATOM    565  NE2 GLN A  69      53.014  39.376  31.731  1.00 39.95           N  
ATOM    566  N   HIS A  70      53.066  34.460  37.058  1.00 30.47           N  
ATOM    567  CA  HIS A  70      52.724  34.044  38.412  1.00 30.67           C  
ATOM    568  C   HIS A  70      51.390  34.562  38.947  1.00 29.87           C  
ATOM    569  O   HIS A  70      51.213  34.700  40.142  1.00 29.14           O  
ATOM    570  CB  HIS A  70      53.906  34.364  39.347  1.00 31.25           C  
ATOM    571  CG  HIS A  70      55.177  33.765  38.855  1.00 32.33           C  
ATOM    572  ND1 HIS A  70      55.374  32.400  38.821  1.00 34.22           N  
ATOM    573  CD2 HIS A  70      56.264  34.324  38.273  1.00 33.16           C  
ATOM    574  CE1 HIS A  70      56.554  32.148  38.287  1.00 33.68           C  
ATOM    575  NE2 HIS A  70      57.114  33.298  37.944  1.00 34.01           N  
ATOM    576  N   TRP A  71      50.425  34.764  38.063  1.00 29.44           N  
ATOM    577  CA  TRP A  71      49.079  35.103  38.529  1.00 30.24           C  
ATOM    578  C   TRP A  71      48.477  34.003  39.397  1.00 30.22           C  
ATOM    579  O   TRP A  71      47.752  34.286  40.339  1.00 30.34           O  
ATOM    580  CB  TRP A  71      48.149  35.439  37.366  1.00 30.05           C  
ATOM    581  CG  TRP A  71      48.570  36.636  36.586  1.00 29.55           C  
ATOM    582  CD1 TRP A  71      49.191  36.640  35.375  1.00 30.09           C  
ATOM    583  CD2 TRP A  71      48.422  38.003  36.961  1.00 29.82           C  
ATOM    584  NE1 TRP A  71      49.415  37.918  34.960  1.00 30.12           N  
ATOM    585  CE2 TRP A  71      48.958  38.781  35.918  1.00 30.52           C  
ATOM    586  CE3 TRP A  71      47.867  38.650  38.062  1.00 29.65           C  
ATOM    587  CZ2 TRP A  71      48.973  40.171  35.953  1.00 30.27           C  
ATOM    588  CZ3 TRP A  71      47.894  40.029  38.102  1.00 30.67           C  
ATOM    589  CH2 TRP A  71      48.438  40.776  37.055  1.00 30.55           C  
ATOM    590  N   THR A  72      48.792  32.750  39.102  1.00 30.75           N  
ATOM    591  CA  THR A  72      48.290  31.650  39.924  1.00 31.06           C  
ATOM    592  C   THR A  72      48.595  31.812  41.423  1.00 30.72           C  
ATOM    593  O   THR A  72      47.771  31.482  42.247  1.00 30.15           O  
ATOM    594  CB  THR A  72      48.763  30.272  39.423  1.00 30.95           C  
ATOM    595  OG1 THR A  72      48.075  29.261  40.168  1.00 32.54           O  
ATOM    596  CG2 THR A  72      50.267  30.087  39.596  1.00 32.73           C  
ATOM    597  N   GLU A  73      49.775  32.323  41.763  1.00 31.84           N  
ATOM    598  CA  GLU A  73      50.148  32.592  43.175  1.00 31.97           C  
ATOM    599  C   GLU A  73      49.408  33.778  43.801  1.00 31.41           C  
ATOM    600  O   GLU A  73      49.145  33.780  44.986  1.00 31.11           O  
ATOM    601  CB  GLU A  73      51.649  32.839  43.300  1.00 32.98           C  
ATOM    602  CG  GLU A  73      52.513  31.608  43.009  1.00 38.08           C  
ATOM    603  CD  GLU A  73      52.987  31.530  41.568  1.00 43.91           C  
ATOM    604  OE1 GLU A  73      52.328  32.106  40.679  1.00 50.69           O  
ATOM    605  OE2 GLU A  73      54.020  30.880  41.316  1.00 50.40           O  
ATOM    606  N   LYS A  74      49.054  34.777  43.002  1.00 31.59           N  
ATOM    607  CA  LYS A  74      48.285  35.935  43.489  1.00 32.00           C  
ATOM    608  C   LYS A  74      46.847  35.577  43.783  1.00 30.87           C  
ATOM    609  O   LYS A  74      46.258  36.076  44.740  1.00 30.60           O  
ATOM    610  CB  LYS A  74      48.277  37.052  42.452  1.00 33.63           C  
ATOM    611  CG  LYS A  74      49.650  37.540  42.005  1.00 36.72           C  
ATOM    612  CD  LYS A  74      50.495  37.962  43.146  1.00 43.08           C  
ATOM    613  CE  LYS A  74      49.951  39.159  43.870  1.00 45.13           C  
ATOM    614  NZ  LYS A  74      51.028  39.618  44.810  1.00 47.84           N  
ATOM    615  N   PHE A  75      46.280  34.725  42.923  1.00 29.57           N  
ATOM    616  CA  PHE A  75      44.913  34.282  43.054  1.00 28.91           C  
ATOM    617  C   PHE A  75      44.801  33.258  44.189  1.00 28.80           C  
ATOM    618  O   PHE A  75      43.820  33.269  44.934  1.00 30.00           O  
ATOM    619  CB  PHE A  75      44.405  33.709  41.721  1.00 27.80           C  
ATOM    620  CG  PHE A  75      43.856  34.747  40.787  1.00 28.12           C  
ATOM    621  CD1 PHE A  75      44.681  35.444  39.929  1.00 26.32           C  
ATOM    622  CD2 PHE A  75      42.499  35.016  40.765  1.00 27.67           C  
ATOM    623  CE1 PHE A  75      44.151  36.389  39.057  1.00 29.54           C  
ATOM    624  CE2 PHE A  75      41.983  35.967  39.919  1.00 28.62           C  
ATOM    625  CZ  PHE A  75      42.802  36.645  39.060  1.00 26.98           C  
ATOM    626  N   ALA A  76      45.794  32.379  44.296  1.00 28.40           N  
ATOM    627  CA  ALA A  76      45.821  31.278  45.287  1.00 29.21           C  
ATOM    628  C   ALA A  76      44.503  30.504  45.370  1.00 29.20           C  
ATOM    629  O   ALA A  76      43.958  30.274  46.456  1.00 28.59           O  
ATOM    630  CB  ALA A  76      46.270  31.778  46.676  1.00 28.07           C  
ATOM    631  N   LEU A  77      44.011  30.088  44.212  1.00 29.60           N  
ATOM    632  CA  LEU A  77      42.741  29.362  44.128  1.00 31.21           C  
ATOM    633  C   LEU A  77      42.851  27.976  44.768  1.00 32.09           C  
ATOM    634  O   LEU A  77      43.880  27.327  44.658  1.00 31.56           O  
ATOM    635  CB  LEU A  77      42.294  29.236  42.668  1.00 30.31           C  
ATOM    636  CG  LEU A  77      41.968  30.508  41.870  1.00 30.78           C  
ATOM    637  CD1 LEU A  77      41.407  30.134  40.503  1.00 31.84           C  
ATOM    638  CD2 LEU A  77      41.009  31.376  42.638  1.00 30.34           C  
ATOM    639  N   ASP A  78      41.790  27.534  45.441  1.00 34.24           N  
ATOM    640  CA  ASP A  78      41.733  26.148  45.928  1.00 35.09           C  
ATOM    641  C   ASP A  78      41.306  25.213  44.792  1.00 35.87           C  
ATOM    642  O   ASP A  78      40.395  24.411  44.929  1.00 36.80           O  
ATOM    643  CB  ASP A  78      40.808  26.033  47.145  1.00 35.70           C  
ATOM    644  CG  ASP A  78      41.046  24.747  47.975  1.00 37.96           C  
ATOM    645  OD1 ASP A  78      42.106  24.018  47.833  1.00 41.25           O  
ATOM    646  OD2 ASP A  78      40.138  24.488  48.813  1.00 44.80           O  
ATOM    647  N   LEU A  79      42.012  25.314  43.671  1.00 36.32           N  
ATOM    648  CA  LEU A  79      41.808  24.484  42.503  1.00 36.55           C  
ATOM    649  C   LEU A  79      43.184  24.119  41.953  1.00 37.09           C  
ATOM    650  O   LEU A  79      44.098  24.959  41.930  1.00 37.00           O  
ATOM    651  CB  LEU A  79      41.049  25.238  41.423  1.00 36.47           C  
ATOM    652  CG  LEU A  79      39.584  25.594  41.653  1.00 37.43           C  
ATOM    653  CD1 LEU A  79      39.119  26.378  40.439  1.00 35.26           C  
ATOM    654  CD2 LEU A  79      38.688  24.355  41.917  1.00 37.88           C  
ATOM    655  N   PRO A  80      43.352  22.870  41.505  1.00 36.79           N  
ATOM    656  CA  PRO A  80      44.663  22.465  41.016  1.00 37.30           C  
ATOM    657  C   PRO A  80      44.955  23.058  39.633  1.00 37.86           C  
ATOM    658  O   PRO A  80      44.028  23.269  38.847  1.00 36.83           O  
ATOM    659  CB  PRO A  80      44.545  20.932  40.947  1.00 37.22           C  
ATOM    660  CG  PRO A  80      43.087  20.682  40.693  1.00 36.40           C  
ATOM    661  CD  PRO A  80      42.352  21.790  41.411  1.00 37.20           C  
ATOM    662  N   ASP A  81      46.221  23.367  39.356  1.00 38.85           N  
ATOM    663  CA  ASP A  81      46.639  23.685  37.992  1.00 40.22           C  
ATOM    664  C   ASP A  81      46.972  22.349  37.344  1.00 40.83           C  
ATOM    665  O   ASP A  81      47.801  21.606  37.848  1.00 41.75           O  
ATOM    666  CB  ASP A  81      47.857  24.627  37.966  1.00 40.63           C  
ATOM    667  CG  ASP A  81      47.511  26.056  38.372  1.00 41.38           C  
ATOM    668  OD1 ASP A  81      46.454  26.566  37.937  1.00 42.22           O  
ATOM    669  OD2 ASP A  81      48.289  26.678  39.120  1.00 42.23           O  
ATOM    670  N   GLU A  82      46.305  22.045  36.241  1.00 41.96           N  
ATOM    671  CA  GLU A  82      46.422  20.749  35.583  1.00 43.03           C  
ATOM    672  C   GLU A  82      46.812  20.925  34.125  1.00 44.62           C  
ATOM    673  O   GLU A  82      46.626  22.012  33.558  1.00 45.74           O  
ATOM    674  CB  GLU A  82      45.083  20.008  35.703  1.00 42.84           C  
ATOM    675  CG  GLU A  82      44.743  19.694  37.154  1.00 41.34           C  
ATOM    676  CD  GLU A  82      43.526  18.818  37.350  1.00 40.58           C  
ATOM    677  OE1 GLU A  82      42.805  18.543  36.390  1.00 37.57           O  
ATOM    678  OE2 GLU A  82      43.282  18.404  38.498  1.00 38.12           O  
ATOM    679  N   THR A  83      47.327  19.860  33.512  1.00 46.54           N  
ATOM    680  CA  THR A  83      47.718  19.907  32.096  1.00 47.27           C  
ATOM    681  C   THR A  83      46.585  20.443  31.247  1.00 48.29           C  
ATOM    682  O   THR A  83      46.784  21.420  30.536  1.00 49.59           O  
ATOM    683  CB  THR A  83      48.155  18.533  31.524  1.00 47.69           C  
ATOM    684  OG1 THR A  83      49.108  17.922  32.389  1.00 48.55           O  
ATOM    685  CG2 THR A  83      48.786  18.713  30.136  1.00 47.85           C  
ATOM    686  N   GLU A  84      45.396  19.842  31.361  1.00 48.68           N  
ATOM    687  CA  GLU A  84      44.232  20.233  30.554  1.00 49.20           C  
ATOM    688  C   GLU A  84      43.189  21.030  31.344  1.00 48.92           C  
ATOM    689  O   GLU A  84      42.975  20.801  32.530  1.00 49.12           O  
ATOM    690  CB  GLU A  84      43.580  18.991  29.939  1.00 49.73           C  
ATOM    691  CG  GLU A  84      44.424  18.372  28.826  1.00 51.44           C  
ATOM    692  CD  GLU A  84      44.006  16.959  28.474  1.00 52.17           C  
ATOM    693  OE1 GLU A  84      44.761  16.016  28.825  1.00 56.65           O  
ATOM    694  OE2 GLU A  84      42.930  16.786  27.834  1.00 57.14           O  
ATOM    695  N   ASP A  85      42.546  21.988  30.682  1.00 48.85           N  
ATOM    696  CA  ASP A  85      41.491  22.765  31.322  1.00 47.48           C  
ATOM    697  C   ASP A  85      40.237  21.886  31.321  1.00 46.63           C  
ATOM    698  O   ASP A  85      40.118  20.980  30.504  1.00 46.66           O  
ATOM    699  CB  ASP A  85      41.246  24.086  30.589  1.00 48.88           C  
ATOM    700  CG  ASP A  85      40.304  25.017  31.357  1.00 50.46           C  
ATOM    701  OD1 ASP A  85      40.231  24.903  32.612  1.00 54.27           O  
ATOM    702  OD2 ASP A  85      39.629  25.852  30.701  1.00 55.48           O  
ATOM    703  N   TRP A  86      39.324  22.125  32.258  1.00 44.18           N  
ATOM    704  CA  TRP A  86      38.129  21.304  32.343  1.00 41.66           C  
ATOM    705  C   TRP A  86      36.918  22.203  32.620  1.00 40.37           C  
ATOM    706  O   TRP A  86      37.066  23.372  32.916  1.00 38.74           O  
ATOM    707  CB  TRP A  86      38.321  20.237  33.419  1.00 39.53           C  
ATOM    708  CG  TRP A  86      38.195  20.750  34.806  1.00 36.95           C  
ATOM    709  CD1 TRP A  86      37.065  20.780  35.544  1.00 35.36           C  
ATOM    710  CD2 TRP A  86      39.227  21.325  35.625  1.00 36.09           C  
ATOM    711  NE1 TRP A  86      37.309  21.322  36.778  1.00 34.79           N  
ATOM    712  CE2 TRP A  86      38.627  21.684  36.855  1.00 36.16           C  
ATOM    713  CE3 TRP A  86      40.602  21.565  35.449  1.00 37.00           C  
ATOM    714  CZ2 TRP A  86      39.359  22.261  37.923  1.00 37.52           C  
ATOM    715  CZ3 TRP A  86      41.326  22.160  36.505  1.00 36.75           C  
ATOM    716  CH2 TRP A  86      40.700  22.483  37.729  1.00 36.42           C  
ATOM    717  N   HIS A  87      35.721  21.636  32.503  1.00 39.81           N  
ATOM    718  CA  HIS A  87      34.493  22.353  32.774  1.00 39.41           C  
ATOM    719  C   HIS A  87      34.216  22.305  34.285  1.00 38.08           C  
ATOM    720  O   HIS A  87      34.048  21.233  34.873  1.00 34.88           O  
ATOM    721  CB  HIS A  87      33.330  21.753  31.970  1.00 41.34           C  
ATOM    722  CG  HIS A  87      32.038  22.482  32.159  1.00 46.09           C  
ATOM    723  ND1 HIS A  87      31.006  21.976  32.927  1.00 49.66           N  
ATOM    724  CD2 HIS A  87      31.629  23.704  31.733  1.00 50.49           C  
ATOM    725  CE1 HIS A  87      30.012  22.850  32.951  1.00 50.19           C  
ATOM    726  NE2 HIS A  87      30.366  23.909  32.243  1.00 53.06           N  
ATOM    727  N   HIS A  88      34.199  23.474  34.921  1.00 35.54           N  
ATOM    728  CA  HIS A  88      33.989  23.532  36.359  1.00 35.98           C  
ATOM    729  C   HIS A  88      32.631  23.025  36.743  1.00 35.63           C  
ATOM    730  O   HIS A  88      31.647  23.390  36.143  1.00 35.33           O  
ATOM    731  CB  HIS A  88      34.113  24.967  36.886  1.00 35.64           C  
ATOM    732  CG  HIS A  88      35.519  25.447  36.975  1.00 36.34           C  
ATOM    733  ND1 HIS A  88      35.862  26.645  37.568  1.00 34.57           N  
ATOM    734  CD2 HIS A  88      36.676  24.885  36.548  1.00 34.95           C  
ATOM    735  CE1 HIS A  88      37.171  26.799  37.489  1.00 34.66           C  
ATOM    736  NE2 HIS A  88      37.687  25.742  36.883  1.00 34.50           N  
ATOM    737  N   THR A  89      32.596  22.195  37.772  1.00 36.12           N  
ATOM    738  CA  THR A  89      31.371  21.939  38.517  1.00 36.30           C  
ATOM    739  C   THR A  89      30.961  23.215  39.286  1.00 36.45           C  
ATOM    740  O   THR A  89      31.793  24.120  39.492  1.00 34.46           O  
ATOM    741  CB  THR A  89      31.569  20.743  39.470  1.00 37.18           C  
ATOM    742  OG1 THR A  89      32.580  21.055  40.433  1.00 37.47           O  
ATOM    743  CG2 THR A  89      32.004  19.512  38.672  1.00 37.75           C  
ATOM    744  N   PRO A  90      29.669  23.326  39.660  1.00 36.54           N  
ATOM    745  CA  PRO A  90      29.227  24.468  40.449  1.00 36.60           C  
ATOM    746  C   PRO A  90      30.044  24.665  41.722  1.00 36.67           C  
ATOM    747  O   PRO A  90      30.325  25.780  42.114  1.00 37.38           O  
ATOM    748  CB  PRO A  90      27.775  24.117  40.811  1.00 36.94           C  
ATOM    749  CG  PRO A  90      27.336  23.206  39.744  1.00 37.58           C  
ATOM    750  CD  PRO A  90      28.552  22.414  39.342  1.00 37.26           C  
ATOM    751  N   GLU A  91      30.415  23.570  42.363  1.00 36.51           N  
ATOM    752  CA  GLU A  91      31.159  23.633  43.600  1.00 35.98           C  
ATOM    753  C   GLU A  91      32.602  24.068  43.376  1.00 34.45           C  
ATOM    754  O   GLU A  91      33.154  24.791  44.199  1.00 34.46           O  
ATOM    755  CB  GLU A  91      31.057  22.280  44.307  1.00 36.79           C  
ATOM    756  CG  GLU A  91      29.587  21.935  44.715  1.00 40.66           C  
ATOM    757  CD  GLU A  91      28.761  21.100  43.683  1.00 44.96           C  
ATOM    758  OE1 GLU A  91      29.092  21.050  42.461  1.00 46.29           O  
ATOM    759  OE2 GLU A  91      27.758  20.476  44.137  1.00 48.03           O  
ATOM    760  N   GLU A  92      33.188  23.682  42.245  1.00 33.45           N  
ATOM    761  CA  GLU A  92      34.506  24.186  41.837  1.00 32.95           C  
ATOM    762  C   GLU A  92      34.469  25.666  41.462  1.00 32.38           C  
ATOM    763  O   GLU A  92      35.388  26.419  41.824  1.00 31.58           O  
ATOM    764  CB  GLU A  92      35.073  23.371  40.676  1.00 33.22           C  
ATOM    765  CG  GLU A  92      35.578  21.986  41.089  1.00 34.01           C  
ATOM    766  CD  GLU A  92      36.021  21.116  39.911  1.00 33.48           C  
ATOM    767  OE1 GLU A  92      35.507  21.292  38.791  1.00 34.86           O  
ATOM    768  OE2 GLU A  92      36.846  20.209  40.121  1.00 34.61           O  
ATOM    769  N   ALA A  93      33.410  26.086  40.756  1.00 31.34           N  
ATOM    770  CA  ALA A  93      33.238  27.488  40.353  1.00 31.26           C  
ATOM    771  C   ALA A  93      33.127  28.428  41.563  1.00 30.28           C  
ATOM    772  O   ALA A  93      33.619  29.535  41.514  1.00 30.33           O  
ATOM    773  CB  ALA A  93      32.008  27.652  39.401  1.00 29.94           C  
ATOM    774  N   ALA A  94      32.460  27.992  42.633  1.00 30.76           N  
ATOM    775  CA  ALA A  94      32.354  28.785  43.863  1.00 31.11           C  
ATOM    776  C   ALA A  94      33.703  29.030  44.535  1.00 31.26           C  
ATOM    777  O   ALA A  94      33.803  29.888  45.389  1.00 32.18           O  
ATOM    778  CB  ALA A  94      31.413  28.098  44.856  1.00 30.94           C  
ATOM    779  N   LYS A  95      34.723  28.259  44.168  1.00 30.74           N  
ATOM    780  CA  LYS A  95      36.047  28.420  44.722  1.00 30.94           C  
ATOM    781  C   LYS A  95      36.862  29.474  43.982  1.00 30.37           C  
ATOM    782  O   LYS A  95      37.974  29.802  44.407  1.00 29.76           O  
ATOM    783  CB  LYS A  95      36.806  27.086  44.702  1.00 30.70           C  
ATOM    784  CG  LYS A  95      36.238  26.071  45.681  1.00 31.91           C  
ATOM    785  CD  LYS A  95      37.172  24.883  45.822  1.00 33.25           C  
ATOM    786  CE  LYS A  95      36.444  23.553  46.047  1.00 36.14           C  
ATOM    787  NZ  LYS A  95      36.711  22.992  47.369  1.00 38.44           N  
ATOM    788  N   VAL A  96      36.338  29.993  42.871  1.00 29.39           N  
ATOM    789  CA  VAL A  96      37.034  31.075  42.198  1.00 28.63           C  
ATOM    790  C   VAL A  96      36.567  32.371  42.861  1.00 28.73           C  
ATOM    791  O   VAL A  96      35.520  32.922  42.532  1.00 27.87           O  
ATOM    792  CB  VAL A  96      36.818  31.076  40.691  1.00 28.29           C  
ATOM    793  CG1 VAL A  96      37.571  32.271  40.072  1.00 28.11           C  
ATOM    794  CG2 VAL A  96      37.287  29.720  40.064  1.00 26.42           C  
ATOM    795  N   VAL A  97      37.337  32.799  43.861  1.00 29.43           N  
ATOM    796  CA  VAL A  97      37.069  33.999  44.631  1.00 29.02           C  
ATOM    797  C   VAL A  97      38.398  34.728  44.817  1.00 29.65           C  
ATOM    798  O   VAL A  97      39.455  34.100  44.775  1.00 29.49           O  
ATOM    799  CB  VAL A  97      36.413  33.681  46.016  1.00 29.49           C  
ATOM    800  CG1 VAL A  97      35.041  33.062  45.811  1.00 28.39           C  
ATOM    801  CG2 VAL A  97      37.313  32.761  46.891  1.00 29.57           C  
ATOM    802  N   VAL A  98      38.337  36.048  44.997  1.00 29.37           N  
ATOM    803  CA  VAL A  98      39.543  36.859  45.181  1.00 29.32           C  
ATOM    804  C   VAL A  98      39.458  37.688  46.462  1.00 29.26           C  
ATOM    805  O   VAL A  98      38.360  38.019  46.951  1.00 28.45           O  
ATOM    806  CB  VAL A  98      39.794  37.822  43.987  1.00 29.71           C  
ATOM    807  CG1 VAL A  98      40.197  37.056  42.721  1.00 29.81           C  
ATOM    808  CG2 VAL A  98      38.565  38.704  43.735  1.00 28.82           C  
ATOM    809  N   ALA A  99      40.632  38.044  46.989  1.00 29.30           N  
ATOM    810  CA  ALA A  99      40.725  38.888  48.183  1.00 29.09           C  
ATOM    811  C   ALA A  99      40.448  40.369  47.877  1.00 28.94           C  
ATOM    812  O   ALA A  99      39.900  41.083  48.719  1.00 28.63           O  
ATOM    813  CB  ALA A  99      42.100  38.707  48.850  1.00 28.10           C  
ATOM    814  N   GLU A 100      40.835  40.825  46.684  1.00 28.89           N  
ATOM    815  CA  GLU A 100      40.615  42.205  46.259  1.00 29.08           C  
ATOM    816  C   GLU A 100      40.280  42.289  44.771  1.00 29.23           C  
ATOM    817  O   GLU A 100      40.834  41.539  43.958  1.00 28.75           O  
ATOM    818  CB  GLU A 100      41.846  43.077  46.532  1.00 28.74           C  
ATOM    819  CG  GLU A 100      42.308  43.140  47.974  1.00 31.15           C  
ATOM    820  CD  GLU A 100      41.452  44.034  48.874  1.00 32.70           C  
ATOM    821  OE1 GLU A 100      40.511  44.707  48.380  1.00 34.55           O  
ATOM    822  OE2 GLU A 100      41.758  44.078  50.089  1.00 35.85           O  
ATOM    823  N   LYS A 101      39.400  43.230  44.416  1.00 29.39           N  
ATOM    824  CA  LYS A 101      38.948  43.413  43.024  1.00 29.95           C  
ATOM    825  C   LYS A 101      40.090  43.739  42.042  1.00 29.77           C  
ATOM    826  O   LYS A 101      40.081  43.274  40.914  1.00 29.40           O  
ATOM    827  CB  LYS A 101      37.931  44.548  42.928  1.00 30.95           C  
ATOM    828  CG  LYS A 101      36.589  44.250  43.517  1.00 31.58           C  
ATOM    829  CD  LYS A 101      35.579  45.328  43.179  1.00 30.39           C  
ATOM    830  CE  LYS A 101      35.932  46.684  43.712  1.00 31.92           C  
ATOM    831  NZ  LYS A 101      34.959  47.666  43.194  1.00 30.62           N  
ATOM    832  N   GLN A 102      41.063  44.521  42.488  1.00 29.40           N  
ATOM    833  CA  GLN A 102      42.193  44.925  41.637  1.00 29.71           C  
ATOM    834  C   GLN A 102      42.862  43.747  40.920  1.00 29.21           C  
ATOM    835  O   GLN A 102      43.280  43.884  39.773  1.00 28.28           O  
ATOM    836  CB  GLN A 102      43.241  45.733  42.437  1.00 30.66           C  
ATOM    837  CG  GLN A 102      44.272  46.542  41.612  1.00 31.73           C  
ATOM    838  CD  GLN A 102      43.588  47.537  40.674  1.00 36.80           C  
ATOM    839  OE1 GLN A 102      42.726  48.297  41.104  1.00 41.83           O  
ATOM    840  NE2 GLN A 102      43.941  47.515  39.397  1.00 35.91           N  
ATOM    841  N   LEU A 103      42.944  42.590  41.569  1.00 29.13           N  
ATOM    842  CA  LEU A 103      43.584  41.433  40.942  1.00 29.53           C  
ATOM    843  C   LEU A 103      42.904  41.016  39.641  1.00 29.26           C  
ATOM    844  O   LEU A 103      43.564  40.672  38.651  1.00 29.87           O  
ATOM    845  CB  LEU A 103      43.621  40.248  41.909  1.00 30.04           C  
ATOM    846  CG  LEU A 103      44.361  39.017  41.408  1.00 29.45           C  
ATOM    847  CD1 LEU A 103      45.782  39.344  41.034  1.00 30.08           C  
ATOM    848  CD2 LEU A 103      44.310  37.919  42.476  1.00 30.27           C  
ATOM    849  N   LEU A 104      41.573  41.042  39.657  1.00 28.86           N  
ATOM    850  CA  LEU A 104      40.776  40.704  38.484  1.00 28.26           C  
ATOM    851  C   LEU A 104      41.050  41.690  37.363  1.00 28.30           C  
ATOM    852  O   LEU A 104      41.226  41.287  36.242  1.00 27.44           O  
ATOM    853  CB  LEU A 104      39.279  40.739  38.817  1.00 28.49           C  
ATOM    854  CG  LEU A 104      38.725  39.672  39.782  1.00 26.86           C  
ATOM    855  CD1 LEU A 104      37.349  40.056  40.291  1.00 27.10           C  
ATOM    856  CD2 LEU A 104      38.736  38.279  39.144  1.00 26.38           C  
ATOM    857  N   SER A 105      41.093  42.985  37.693  1.00 27.92           N  
ATOM    858  CA  SER A 105      41.353  44.020  36.721  1.00 28.17           C  
ATOM    859  C   SER A 105      42.728  43.865  36.099  1.00 28.13           C  
ATOM    860  O   SER A 105      42.903  44.071  34.877  1.00 27.50           O  
ATOM    861  CB  SER A 105      41.294  45.398  37.359  1.00 28.64           C  
ATOM    862  OG  SER A 105      39.988  45.708  37.713  1.00 31.71           O  
ATOM    863  N   ASP A 106      43.712  43.576  36.954  1.00 28.22           N  
ATOM    864  CA  ASP A 106      45.114  43.449  36.516  1.00 28.06           C  
ATOM    865  C   ASP A 106      45.340  42.237  35.610  1.00 27.41           C  
ATOM    866  O   ASP A 106      46.022  42.332  34.553  1.00 27.26           O  
ATOM    867  CB  ASP A 106      46.049  43.403  37.731  1.00 28.51           C  
ATOM    868  CG  ASP A 106      46.124  44.713  38.479  1.00 32.02           C  
ATOM    869  OD1 ASP A 106      45.649  45.759  37.969  1.00 33.99           O  
ATOM    870  OD2 ASP A 106      46.677  44.694  39.605  1.00 33.60           O  
ATOM    871  N   TYR A 107      44.766  41.096  35.974  1.00 26.60           N  
ATOM    872  CA  TYR A 107      44.961  39.909  35.150  1.00 26.46           C  
ATOM    873  C   TYR A 107      44.189  40.040  33.817  1.00 26.75           C  
ATOM    874  O   TYR A 107      44.697  39.687  32.750  1.00 25.52           O  
ATOM    875  CB  TYR A 107      44.575  38.629  35.915  1.00 26.71           C  
ATOM    876  CG  TYR A 107      44.766  37.337  35.134  1.00 26.37           C  
ATOM    877  CD1 TYR A 107      45.889  37.129  34.324  1.00 27.48           C  
ATOM    878  CD2 TYR A 107      43.852  36.324  35.221  1.00 25.48           C  
ATOM    879  CE1 TYR A 107      46.055  35.906  33.599  1.00 27.52           C  
ATOM    880  CE2 TYR A 107      44.013  35.135  34.516  1.00 26.36           C  
ATOM    881  CZ  TYR A 107      45.104  34.928  33.702  1.00 26.84           C  
ATOM    882  OH  TYR A 107      45.222  33.722  33.016  1.00 27.45           O  
ATOM    883  N   LEU A 108      42.979  40.584  33.862  1.00 27.13           N  
ATOM    884  CA  LEU A 108      42.253  40.834  32.616  1.00 27.72           C  
ATOM    885  C   LEU A 108      42.993  41.822  31.695  1.00 28.05           C  
ATOM    886  O   LEU A 108      43.089  41.597  30.490  1.00 27.88           O  
ATOM    887  CB  LEU A 108      40.817  41.326  32.878  1.00 27.56           C  
ATOM    888  CG  LEU A 108      39.888  41.473  31.660  1.00 26.84           C  
ATOM    889  CD1 LEU A 108      39.737  40.128  30.906  1.00 27.54           C  
ATOM    890  CD2 LEU A 108      38.472  41.977  32.135  1.00 28.18           C  
ATOM    891  N   ALA A 109      43.524  42.897  32.265  1.00 27.91           N  
ATOM    892  CA  ALA A 109      44.288  43.879  31.474  1.00 27.95           C  
ATOM    893  C   ALA A 109      45.512  43.240  30.817  1.00 28.23           C  
ATOM    894  O   ALA A 109      45.824  43.533  29.649  1.00 27.77           O  
ATOM    895  CB  ALA A 109      44.729  45.087  32.356  1.00 28.35           C  
ATOM    896  N   ALA A 110      46.212  42.374  31.566  1.00 28.42           N  
ATOM    897  CA  ALA A 110      47.339  41.634  31.020  1.00 28.00           C  
ATOM    898  C   ALA A 110      46.890  40.703  29.899  1.00 28.19           C  
ATOM    899  O   ALA A 110      47.574  40.600  28.881  1.00 27.65           O  
ATOM    900  CB  ALA A 110      48.081  40.852  32.102  1.00 27.78           C  
ATOM    901  N   SER A 111      45.786  39.979  30.087  1.00 28.10           N  
ATOM    902  CA  SER A 111      45.337  39.055  29.033  1.00 29.14           C  
ATOM    903  C   SER A 111      44.805  39.761  27.783  1.00 29.15           C  
ATOM    904  O   SER A 111      44.992  39.277  26.680  1.00 29.57           O  
ATOM    905  CB  SER A 111      44.300  38.075  29.569  1.00 28.47           C  
ATOM    906  OG  SER A 111      44.867  37.384  30.660  1.00 32.92           O  
ATOM    907  N   VAL A 112      44.123  40.889  27.962  1.00 30.52           N  
ATOM    908  CA  VAL A 112      43.694  41.707  26.827  1.00 30.22           C  
ATOM    909  C   VAL A 112      44.893  42.253  26.068  1.00 30.43           C  
ATOM    910  O   VAL A 112      44.905  42.203  24.837  1.00 30.78           O  
ATOM    911  CB  VAL A 112      42.722  42.842  27.280  1.00 30.90           C  
ATOM    912  CG1 VAL A 112      42.463  43.840  26.139  1.00 30.69           C  
ATOM    913  CG2 VAL A 112      41.408  42.214  27.772  1.00 29.35           C  
ATOM    914  N   ALA A 113      45.908  42.738  26.781  1.00 30.72           N  
ATOM    915  CA  ALA A 113      47.128  43.250  26.142  1.00 31.15           C  
ATOM    916  C   ALA A 113      47.802  42.198  25.270  1.00 30.77           C  
ATOM    917  O   ALA A 113      48.197  42.478  24.145  1.00 31.29           O  
ATOM    918  CB  ALA A 113      48.139  43.759  27.181  1.00 30.98           C  
ATOM    919  N   LEU A 114      47.971  41.012  25.829  1.00 30.48           N  
ATOM    920  CA  LEU A 114      48.535  39.872  25.120  1.00 30.38           C  
ATOM    921  C   LEU A 114      47.753  39.583  23.829  1.00 29.54           C  
ATOM    922  O   LEU A 114      48.341  39.378  22.751  1.00 28.83           O  
ATOM    923  CB  LEU A 114      48.501  38.632  26.028  1.00 30.16           C  
ATOM    924  CG  LEU A 114      49.063  37.328  25.433  1.00 31.54           C  
ATOM    925  CD1 LEU A 114      50.618  37.349  25.357  1.00 33.25           C  
ATOM    926  CD2 LEU A 114      48.542  36.097  26.233  1.00 31.18           C  
ATOM    927  N   THR A 115      46.430  39.565  23.956  1.00 29.66           N  
ATOM    928  CA  THR A 115      45.534  39.263  22.834  1.00 29.93           C  
ATOM    929  C   THR A 115      45.737  40.318  21.750  1.00 29.86           C  
ATOM    930  O   THR A 115      45.946  39.993  20.589  1.00 27.67           O  
ATOM    931  CB  THR A 115      44.070  39.178  23.296  1.00 29.57           C  
ATOM    932  OG1 THR A 115      43.963  38.185  24.328  1.00 30.84           O  
ATOM    933  CG2 THR A 115      43.127  38.814  22.131  1.00 29.24           C  
ATOM    934  N   LYS A 116      45.729  41.583  22.146  1.00 30.86           N  
ATOM    935  CA  LYS A 116      45.849  42.675  21.172  1.00 32.09           C  
ATOM    936  C   LYS A 116      47.204  42.686  20.480  1.00 32.31           C  
ATOM    937  O   LYS A 116      47.295  43.039  19.302  1.00 33.28           O  
ATOM    938  CB  LYS A 116      45.599  44.019  21.842  1.00 32.95           C  
ATOM    939  CG  LYS A 116      44.152  44.216  22.272  1.00 34.96           C  
ATOM    940  CD  LYS A 116      43.995  45.466  23.174  1.00 35.62           C  
ATOM    941  CE  LYS A 116      43.523  46.629  22.416  1.00 38.42           C  
ATOM    942  NZ  LYS A 116      43.453  47.878  23.267  1.00 40.62           N  
ATOM    943  N   SER A 117      48.252  42.333  21.222  1.00 31.61           N  
ATOM    944  CA  SER A 117      49.578  42.167  20.676  1.00 32.14           C  
ATOM    945  C   SER A 117      49.599  41.063  19.631  1.00 31.04           C  
ATOM    946  O   SER A 117      50.148  41.254  18.570  1.00 30.13           O  
ATOM    947  CB  SER A 117      50.586  41.831  21.772  1.00 32.32           C  
ATOM    948  OG  SER A 117      51.872  41.592  21.209  1.00 36.45           O  
ATOM    949  N   TYR A 118      48.970  39.935  19.926  1.00 30.44           N  
ATOM    950  CA  TYR A 118      48.933  38.837  18.970  1.00 30.25           C  
ATOM    951  C   TYR A 118      48.185  39.279  17.710  1.00 29.95           C  
ATOM    952  O   TYR A 118      48.672  39.072  16.587  1.00 28.59           O  
ATOM    953  CB  TYR A 118      48.303  37.567  19.575  1.00 30.25           C  
ATOM    954  CG  TYR A 118      48.395  36.365  18.650  1.00 30.58           C  
ATOM    955  CD1 TYR A 118      49.537  35.577  18.612  1.00 32.04           C  
ATOM    956  CD2 TYR A 118      47.357  36.029  17.807  1.00 32.43           C  
ATOM    957  CE1 TYR A 118      49.634  34.487  17.745  1.00 31.96           C  
ATOM    958  CE2 TYR A 118      47.450  34.939  16.935  1.00 30.56           C  
ATOM    959  CZ  TYR A 118      48.585  34.186  16.917  1.00 31.53           C  
ATOM    960  OH  TYR A 118      48.668  33.143  16.044  1.00 32.58           O  
ATOM    961  N   LEU A 119      47.030  39.916  17.904  1.00 29.44           N  
ATOM    962  CA  LEU A 119      46.189  40.352  16.797  1.00 30.62           C  
ATOM    963  C   LEU A 119      46.930  41.338  15.898  1.00 31.51           C  
ATOM    964  O   LEU A 119      46.754  41.341  14.682  1.00 30.67           O  
ATOM    965  CB  LEU A 119      44.875  40.999  17.290  1.00 29.72           C  
ATOM    966  CG  LEU A 119      43.818  39.990  17.771  1.00 31.41           C  
ATOM    967  CD1 LEU A 119      42.593  40.709  18.302  1.00 32.28           C  
ATOM    968  CD2 LEU A 119      43.433  39.072  16.664  1.00 31.55           C  
ATOM    969  N   ASP A 120      47.720  42.197  16.517  1.00 33.48           N  
ATOM    970  CA  ASP A 120      48.475  43.201  15.780  1.00 36.25           C  
ATOM    971  C   ASP A 120      49.643  42.619  14.994  1.00 36.33           C  
ATOM    972  O   ASP A 120      50.149  43.267  14.070  1.00 37.15           O  
ATOM    973  CB  ASP A 120      48.980  44.260  16.747  1.00 37.04           C  
ATOM    974  CG  ASP A 120      47.876  45.174  17.236  1.00 43.47           C  
ATOM    975  OD1 ASP A 120      46.871  45.338  16.479  1.00 50.27           O  
ATOM    976  OD2 ASP A 120      47.998  45.721  18.382  1.00 49.42           O  
ATOM    977  N   GLN A 121      50.094  41.424  15.369  1.00 36.76           N  
ATOM    978  CA  GLN A 121      51.276  40.828  14.742  1.00 37.92           C  
ATOM    979  C   GLN A 121      50.963  39.636  13.837  1.00 37.36           C  
ATOM    980  O   GLN A 121      51.781  39.273  12.999  1.00 36.92           O  
ATOM    981  CB  GLN A 121      52.316  40.461  15.803  1.00 38.25           C  
ATOM    982  CG  GLN A 121      52.844  41.685  16.554  1.00 40.33           C  
ATOM    983  CD  GLN A 121      53.808  41.327  17.675  1.00 41.27           C  
ATOM    984  OE1 GLN A 121      53.540  41.604  18.850  1.00 46.78           O  
ATOM    985  NE2 GLN A 121      54.935  40.718  17.322  1.00 44.13           N  
ATOM    986  N   ILE A 122      49.783  39.044  13.972  1.00 37.46           N  
ATOM    987  CA  ILE A 122      49.410  37.946  13.098  1.00 37.67           C  
ATOM    988  C   ILE A 122      49.370  38.455  11.645  1.00 37.77           C  
ATOM    989  O   ILE A 122      48.838  39.530  11.386  1.00 37.28           O  
ATOM    990  CB  ILE A 122      48.061  37.308  13.526  1.00 38.28           C  
ATOM    991  CG1 ILE A 122      47.889  35.915  12.905  1.00 39.92           C  
ATOM    992  CG2 ILE A 122      46.910  38.195  13.179  1.00 35.47           C  
ATOM    993  CD1 ILE A 122      49.013  34.933  13.279  1.00 42.72           C  
ATOM    994  N   LYS A 123      49.978  37.697  10.724  1.00 37.83           N  
ATOM    995  CA  LYS A 123      49.887  37.954   9.278  1.00 38.46           C  
ATOM    996  C   LYS A 123      48.645  37.297   8.702  1.00 38.51           C  
ATOM    997  O   LYS A 123      48.215  36.231   9.153  1.00 37.64           O  
ATOM    998  CB  LYS A 123      51.158  37.476   8.540  1.00 38.90           C  
ATOM    999  CG  LYS A 123      52.290  38.501   8.605  1.00 39.59           C  
ATOM   1000  CD  LYS A 123      53.682  37.889   8.429  1.00 41.48           C  
ATOM   1001  CE  LYS A 123      54.312  37.432   9.767  1.00 45.15           C  
ATOM   1002  NZ  LYS A 123      53.989  38.339  10.955  1.00 47.07           N  
ATOM   1003  N   GLU A 124      48.060  37.961   7.721  1.00 38.34           N  
ATOM   1004  CA  GLU A 124      46.779  37.570   7.176  1.00 39.59           C  
ATOM   1005  C   GLU A 124      46.829  36.169   6.540  1.00 39.31           C  
ATOM   1006  O   GLU A 124      45.841  35.447   6.526  1.00 39.33           O  
ATOM   1007  CB  GLU A 124      46.365  38.632   6.164  1.00 39.54           C  
ATOM   1008  CG  GLU A 124      44.967  38.509   5.589  1.00 42.19           C  
ATOM   1009  CD  GLU A 124      44.830  39.297   4.290  1.00 42.69           C  
ATOM   1010  OE1 GLU A 124      44.375  38.702   3.269  1.00 44.99           O  
ATOM   1011  OE2 GLU A 124      45.211  40.501   4.301  1.00 46.49           O  
ATOM   1012  N   GLU A 125      47.989  35.801   6.008  1.00 39.74           N  
ATOM   1013  CA  GLU A 125      48.198  34.484   5.414  1.00 39.89           C  
ATOM   1014  C   GLU A 125      48.136  33.355   6.466  1.00 39.39           C  
ATOM   1015  O   GLU A 125      47.764  32.221   6.154  1.00 39.29           O  
ATOM   1016  CB  GLU A 125      49.535  34.454   4.674  1.00 40.35           C  
ATOM   1017  CG  GLU A 125      49.542  35.284   3.381  1.00 44.14           C  
ATOM   1018  CD  GLU A 125      49.567  36.830   3.580  1.00 48.27           C  
ATOM   1019  OE1 GLU A 125      49.687  37.323   4.742  1.00 50.48           O  
ATOM   1020  OE2 GLU A 125      49.459  37.550   2.553  1.00 50.10           O  
ATOM   1021  N   GLN A 126      48.489  33.685   7.708  1.00 38.72           N  
ATOM   1022  CA  GLN A 126      48.475  32.723   8.811  1.00 37.77           C  
ATOM   1023  C   GLN A 126      47.065  32.378   9.298  1.00 36.56           C  
ATOM   1024  O   GLN A 126      46.888  31.368   9.969  1.00 35.08           O  
ATOM   1025  CB  GLN A 126      49.280  33.248   9.990  1.00 37.31           C  
ATOM   1026  CG  GLN A 126      50.744  33.426   9.733  1.00 38.55           C  
ATOM   1027  CD  GLN A 126      51.425  34.187  10.857  1.00 39.62           C  
ATOM   1028  OE1 GLN A 126      51.126  35.364  11.106  1.00 41.65           O  
ATOM   1029  NE2 GLN A 126      52.356  33.522  11.540  1.00 43.17           N  
ATOM   1030  N   LEU A 127      46.080  33.217   8.984  1.00 35.54           N  
ATOM   1031  CA  LEU A 127      44.728  32.994   9.496  1.00 35.58           C  
ATOM   1032  C   LEU A 127      44.075  31.703   8.976  1.00 34.79           C  
ATOM   1033  O   LEU A 127      43.230  31.130   9.647  1.00 33.57           O  
ATOM   1034  CB  LEU A 127      43.815  34.194   9.207  1.00 35.62           C  
ATOM   1035  CG  LEU A 127      44.098  35.482   9.988  1.00 35.48           C  
ATOM   1036  CD1 LEU A 127      43.199  36.585   9.426  1.00 36.16           C  
ATOM   1037  CD2 LEU A 127      43.894  35.289  11.511  1.00 35.72           C  
ATOM   1038  N   SER A 128      44.488  31.240   7.797  1.00 34.63           N  
ATOM   1039  CA  SER A 128      43.931  30.012   7.232  1.00 34.56           C  
ATOM   1040  C   SER A 128      44.616  28.746   7.758  1.00 33.92           C  
ATOM   1041  O   SER A 128      44.213  27.641   7.405  1.00 34.09           O  
ATOM   1042  CB  SER A 128      44.012  30.037   5.695  1.00 34.28           C  
ATOM   1043  OG  SER A 128      45.354  30.047   5.267  1.00 35.50           O  
ATOM   1044  N   ASP A 129      45.663  28.892   8.562  1.00 33.34           N  
ATOM   1045  CA  ASP A 129      46.389  27.724   9.072  1.00 33.11           C  
ATOM   1046  C   ASP A 129      45.487  26.802   9.902  1.00 32.30           C  
ATOM   1047  O   ASP A 129      44.840  27.268  10.818  1.00 29.61           O  
ATOM   1048  CB  ASP A 129      47.518  28.180   9.987  1.00 33.30           C  
ATOM   1049  CG  ASP A 129      48.684  28.818   9.231  1.00 37.36           C  
ATOM   1050  OD1 ASP A 129      48.739  28.702   7.975  1.00 41.88           O  
ATOM   1051  OD2 ASP A 129      49.566  29.403   9.912  1.00 40.18           O  
ATOM   1052  N   VAL A 130      45.508  25.500   9.619  1.00 31.70           N  
ATOM   1053  CA  VAL A 130      44.819  24.512  10.456  1.00 32.31           C  
ATOM   1054  C   VAL A 130      45.600  24.246  11.756  1.00 32.24           C  
ATOM   1055  O   VAL A 130      46.749  23.799  11.740  1.00 31.62           O  
ATOM   1056  CB  VAL A 130      44.540  23.193   9.657  1.00 32.14           C  
ATOM   1057  CG1 VAL A 130      44.003  22.071  10.562  1.00 29.99           C  
ATOM   1058  CG2 VAL A 130      43.566  23.469   8.524  1.00 30.83           C  
ATOM   1059  N   ILE A 131      44.966  24.514  12.887  1.00 32.72           N  
ATOM   1060  CA  ILE A 131      45.587  24.293  14.190  1.00 34.11           C  
ATOM   1061  C   ILE A 131      45.080  23.022  14.883  1.00 34.75           C  
ATOM   1062  O   ILE A 131      45.773  22.482  15.757  1.00 34.77           O  
ATOM   1063  CB  ILE A 131      45.482  25.527  15.149  1.00 34.74           C  
ATOM   1064  CG1 ILE A 131      44.048  25.896  15.470  1.00 35.04           C  
ATOM   1065  CG2 ILE A 131      46.209  26.772  14.569  1.00 34.11           C  
ATOM   1066  CD1 ILE A 131      43.953  26.912  16.543  1.00 35.77           C  
ATOM   1067  N   ASP A 132      43.899  22.531  14.487  1.00 35.38           N  
ATOM   1068  CA  ASP A 132      43.408  21.230  14.971  1.00 35.57           C  
ATOM   1069  C   ASP A 132      42.634  20.516  13.887  1.00 36.04           C  
ATOM   1070  O   ASP A 132      41.507  20.874  13.602  1.00 35.22           O  
ATOM   1071  CB  ASP A 132      42.523  21.378  16.223  1.00 35.81           C  
ATOM   1072  CG  ASP A 132      42.251  20.025  16.918  1.00 37.00           C  
ATOM   1073  OD1 ASP A 132      42.399  18.949  16.289  1.00 36.29           O  
ATOM   1074  OD2 ASP A 132      41.880  20.045  18.108  1.00 40.33           O  
ATOM   1075  N   LYS A 133      43.233  19.473  13.324  1.00 37.20           N  
ATOM   1076  CA  LYS A 133      42.649  18.777  12.187  1.00 38.72           C  
ATOM   1077  C   LYS A 133      41.550  17.813  12.615  1.00 40.12           C  
ATOM   1078  O   LYS A 133      40.784  17.358  11.778  1.00 41.21           O  
ATOM   1079  CB  LYS A 133      43.721  18.025  11.368  1.00 38.42           C  
ATOM   1080  CG  LYS A 133      44.506  16.915  12.130  1.00 37.18           C  
ATOM   1081  CD  LYS A 133      45.786  16.433  11.379  1.00 37.09           C  
ATOM   1082  CE  LYS A 133      45.464  15.750  10.060  1.00 35.29           C  
ATOM   1083  NZ  LYS A 133      46.673  15.385   9.238  1.00 32.87           N  
ATOM   1084  N   ASN A 134      41.441  17.516  13.908  1.00 41.55           N  
ATOM   1085  CA  ASN A 134      40.572  16.416  14.371  1.00 42.58           C  
ATOM   1086  C   ASN A 134      39.123  16.845  14.664  1.00 43.69           C  
ATOM   1087  O   ASN A 134      38.462  16.287  15.549  1.00 43.77           O  
ATOM   1088  CB  ASN A 134      41.226  15.729  15.574  1.00 42.82           C  
ATOM   1089  CG  ASN A 134      42.547  15.065  15.205  1.00 42.15           C  
ATOM   1090  OD1 ASN A 134      42.650  14.372  14.197  1.00 42.30           O  
ATOM   1091  ND2 ASN A 134      43.561  15.286  16.017  1.00 44.73           N  
ATOM   1092  N   TRP A 135      38.659  17.836  13.904  1.00 44.68           N  
ATOM   1093  CA  TRP A 135      37.289  18.339  13.933  1.00 45.48           C  
ATOM   1094  C   TRP A 135      36.826  18.429  12.503  1.00 45.30           C  
ATOM   1095  O   TRP A 135      37.652  18.474  11.599  1.00 44.99           O  
ATOM   1096  CB  TRP A 135      37.248  19.731  14.542  1.00 47.70           C  
ATOM   1097  CG  TRP A 135      37.684  19.716  15.944  1.00 50.55           C  
ATOM   1098  CD1 TRP A 135      38.969  19.758  16.397  1.00 52.22           C  
ATOM   1099  CD2 TRP A 135      36.849  19.603  17.104  1.00 53.20           C  
ATOM   1100  NE1 TRP A 135      38.987  19.697  17.770  1.00 53.34           N  
ATOM   1101  CE2 TRP A 135      37.702  19.591  18.230  1.00 53.73           C  
ATOM   1102  CE3 TRP A 135      35.461  19.512  17.303  1.00 53.97           C  
ATOM   1103  CZ2 TRP A 135      37.217  19.499  19.544  1.00 52.70           C  
ATOM   1104  CZ3 TRP A 135      34.979  19.419  18.616  1.00 52.43           C  
ATOM   1105  CH2 TRP A 135      35.859  19.411  19.712  1.00 51.84           C  
ATOM   1106  N   THR A 136      35.509  18.452  12.304  1.00 45.03           N  
ATOM   1107  CA  THR A 136      34.911  18.716  10.995  1.00 44.57           C  
ATOM   1108  C   THR A 136      34.081  19.969  11.126  1.00 43.80           C  
ATOM   1109  O   THR A 136      33.112  19.973  11.890  1.00 44.91           O  
ATOM   1110  CB  THR A 136      33.962  17.602  10.524  1.00 44.59           C  
ATOM   1111  OG1 THR A 136      34.542  16.331  10.801  1.00 45.35           O  
ATOM   1112  CG2 THR A 136      33.671  17.736   9.013  1.00 44.95           C  
ATOM   1113  N   PRO A 137      34.467  21.051  10.426  1.00 42.31           N  
ATOM   1114  CA  PRO A 137      35.663  21.143   9.598  1.00 40.96           C  
ATOM   1115  C   PRO A 137      36.819  21.433  10.551  1.00 40.12           C  
ATOM   1116  O   PRO A 137      36.569  21.741  11.729  1.00 39.52           O  
ATOM   1117  CB  PRO A 137      35.369  22.340   8.690  1.00 41.30           C  
ATOM   1118  CG  PRO A 137      34.550  23.239   9.521  1.00 41.80           C  
ATOM   1119  CD  PRO A 137      33.758  22.338  10.493  1.00 42.57           C  
ATOM   1120  N   PRO A 138      38.064  21.342  10.060  1.00 39.13           N  
ATOM   1121  CA  PRO A 138      39.213  21.632  10.913  1.00 38.06           C  
ATOM   1122  C   PRO A 138      39.136  23.011  11.569  1.00 36.41           C  
ATOM   1123  O   PRO A 138      38.509  23.948  11.040  1.00 36.06           O  
ATOM   1124  CB  PRO A 138      40.389  21.583   9.946  1.00 37.86           C  
ATOM   1125  CG  PRO A 138      39.942  20.710   8.843  1.00 39.16           C  
ATOM   1126  CD  PRO A 138      38.477  20.935   8.695  1.00 38.87           C  
ATOM   1127  N   VAL A 139      39.755  23.123  12.737  1.00 33.26           N  
ATOM   1128  CA  VAL A 139      39.868  24.400  13.389  1.00 31.64           C  
ATOM   1129  C   VAL A 139      41.112  25.113  12.852  1.00 30.28           C  
ATOM   1130  O   VAL A 139      42.218  24.566  12.891  1.00 28.41           O  
ATOM   1131  CB  VAL A 139      39.998  24.222  14.901  1.00 31.80           C  
ATOM   1132  CG1 VAL A 139      40.147  25.580  15.585  1.00 30.04           C  
ATOM   1133  CG2 VAL A 139      38.805  23.417  15.441  1.00 32.67           C  
ATOM   1134  N   THR A 140      40.910  26.334  12.380  1.00 28.79           N  
ATOM   1135  CA  THR A 140      41.967  27.188  11.891  1.00 28.62           C  
ATOM   1136  C   THR A 140      42.274  28.261  12.910  1.00 29.02           C  
ATOM   1137  O   THR A 140      41.527  28.457  13.870  1.00 27.44           O  
ATOM   1138  CB  THR A 140      41.495  27.914  10.633  1.00 29.22           C  
ATOM   1139  OG1 THR A 140      40.321  28.699  10.952  1.00 28.48           O  
ATOM   1140  CG2 THR A 140      41.182  26.917   9.492  1.00 28.18           C  
ATOM   1141  N   ARG A 141      43.360  28.992  12.678  1.00 29.42           N  
ATOM   1142  CA  ARG A 141      43.730  30.093  13.546  1.00 30.10           C  
ATOM   1143  C   ARG A 141      42.549  31.083  13.667  1.00 30.25           C  
ATOM   1144  O   ARG A 141      42.243  31.582  14.752  1.00 28.83           O  
ATOM   1145  CB  ARG A 141      44.958  30.784  12.983  1.00 30.20           C  
ATOM   1146  CG  ARG A 141      45.703  31.680  13.923  1.00 30.98           C  
ATOM   1147  CD  ARG A 141      47.038  32.091  13.296  1.00 32.59           C  
ATOM   1148  NE  ARG A 141      47.813  30.941  12.846  1.00 32.19           N  
ATOM   1149  CZ  ARG A 141      48.619  30.220  13.612  1.00 34.05           C  
ATOM   1150  NH1 ARG A 141      48.810  30.514  14.886  1.00 37.83           N  
ATOM   1151  NH2 ARG A 141      49.257  29.203  13.094  1.00 36.07           N  
ATOM   1152  N   GLN A 142      41.911  31.337  12.530  1.00 30.67           N  
ATOM   1153  CA  GLN A 142      40.852  32.313  12.419  1.00 31.89           C  
ATOM   1154  C   GLN A 142      39.663  31.947  13.293  1.00 30.73           C  
ATOM   1155  O   GLN A 142      39.157  32.794  14.034  1.00 31.11           O  
ATOM   1156  CB  GLN A 142      40.412  32.415  10.965  1.00 31.57           C  
ATOM   1157  CG  GLN A 142      39.330  33.444  10.743  1.00 35.57           C  
ATOM   1158  CD  GLN A 142      39.281  33.895   9.301  1.00 36.08           C  
ATOM   1159  OE1 GLN A 142      40.326  34.188   8.713  1.00 42.52           O  
ATOM   1160  NE2 GLN A 142      38.075  33.982   8.731  1.00 40.71           N  
ATOM   1161  N   VAL A 143      39.264  30.674  13.235  1.00 30.69           N  
ATOM   1162  CA  VAL A 143      38.148  30.155  14.035  1.00 30.75           C  
ATOM   1163  C   VAL A 143      38.444  30.323  15.534  1.00 30.99           C  
ATOM   1164  O   VAL A 143      37.597  30.757  16.322  1.00 29.72           O  
ATOM   1165  CB  VAL A 143      37.845  28.687  13.647  1.00 31.28           C  
ATOM   1166  CG1 VAL A 143      36.960  28.005  14.691  1.00 30.48           C  
ATOM   1167  CG2 VAL A 143      37.160  28.635  12.264  1.00 31.20           C  
ATOM   1168  N   ARG A 144      39.689  30.058  15.921  1.00 30.87           N  
ATOM   1169  CA  ARG A 144      40.070  30.127  17.321  1.00 30.55           C  
ATOM   1170  C   ARG A 144      40.057  31.579  17.812  1.00 29.82           C  
ATOM   1171  O   ARG A 144      39.583  31.851  18.919  1.00 30.09           O  
ATOM   1172  CB  ARG A 144      41.424  29.471  17.471  1.00 31.94           C  
ATOM   1173  CG  ARG A 144      42.082  29.539  18.765  1.00 35.84           C  
ATOM   1174  CD  ARG A 144      41.387  28.721  19.833  1.00 41.32           C  
ATOM   1175  NE  ARG A 144      40.743  27.470  19.429  1.00 43.54           N  
ATOM   1176  CZ  ARG A 144      41.289  26.256  19.474  1.00 43.16           C  
ATOM   1177  NH1 ARG A 144      42.548  26.069  19.811  1.00 46.57           N  
ATOM   1178  NH2 ARG A 144      40.555  25.209  19.149  1.00 44.11           N  
ATOM   1179  N   LEU A 145      40.561  32.493  16.988  1.00 29.97           N  
ATOM   1180  CA  LEU A 145      40.525  33.921  17.276  1.00 29.93           C  
ATOM   1181  C   LEU A 145      39.108  34.470  17.403  1.00 29.36           C  
ATOM   1182  O   LEU A 145      38.842  35.254  18.292  1.00 29.40           O  
ATOM   1183  CB  LEU A 145      41.285  34.716  16.206  1.00 29.92           C  
ATOM   1184  CG  LEU A 145      42.821  34.525  16.244  1.00 31.15           C  
ATOM   1185  CD1 LEU A 145      43.531  35.167  15.037  1.00 31.86           C  
ATOM   1186  CD2 LEU A 145      43.388  35.057  17.589  1.00 29.65           C  
ATOM   1187  N   VAL A 146      38.219  34.085  16.505  1.00 29.60           N  
ATOM   1188  CA  VAL A 146      36.822  34.511  16.582  1.00 29.78           C  
ATOM   1189  C   VAL A 146      36.141  33.958  17.858  1.00 30.05           C  
ATOM   1190  O   VAL A 146      35.355  34.659  18.530  1.00 30.14           O  
ATOM   1191  CB  VAL A 146      36.050  34.097  15.319  1.00 30.23           C  
ATOM   1192  CG1 VAL A 146      34.542  34.312  15.507  1.00 29.31           C  
ATOM   1193  CG2 VAL A 146      36.534  34.846  14.091  1.00 29.88           C  
ATOM   1194  N   SER A 147      36.443  32.694  18.183  1.00 29.64           N  
ATOM   1195  CA  SER A 147      35.938  32.065  19.381  1.00 30.50           C  
ATOM   1196  C   SER A 147      36.397  32.810  20.619  1.00 30.76           C  
ATOM   1197  O   SER A 147      35.602  33.008  21.558  1.00 31.04           O  
ATOM   1198  CB  SER A 147      36.390  30.592  19.486  1.00 31.03           C  
ATOM   1199  OG  SER A 147      35.714  29.832  18.516  1.00 30.55           O  
ATOM   1200  N   ALA A 148      37.668  33.226  20.631  1.00 31.99           N  
ATOM   1201  CA  ALA A 148      38.208  33.951  21.797  1.00 31.79           C  
ATOM   1202  C   ALA A 148      37.558  35.310  21.994  1.00 32.31           C  
ATOM   1203  O   ALA A 148      37.196  35.662  23.121  1.00 32.39           O  
ATOM   1204  CB  ALA A 148      39.682  34.056  21.739  1.00 32.91           C  
ATOM   1205  N   ILE A 149      37.327  36.050  20.916  1.00 32.42           N  
ATOM   1206  CA  ILE A 149      36.653  37.346  21.010  1.00 32.26           C  
ATOM   1207  C   ILE A 149      35.183  37.146  21.406  1.00 32.02           C  
ATOM   1208  O   ILE A 149      34.682  37.839  22.298  1.00 30.55           O  
ATOM   1209  CB  ILE A 149      36.687  38.133  19.668  1.00 32.56           C  
ATOM   1210  CG1 ILE A 149      38.125  38.475  19.232  1.00 34.29           C  
ATOM   1211  CG2 ILE A 149      35.864  39.414  19.751  1.00 32.35           C  
ATOM   1212  CD1 ILE A 149      38.930  39.263  20.241  1.00 34.61           C  
ATOM   1213  N   ASP A 150      34.503  36.182  20.773  1.00 32.29           N  
ATOM   1214  CA  ASP A 150      33.087  35.845  21.100  1.00 31.62           C  
ATOM   1215  C   ASP A 150      32.880  35.517  22.599  1.00 32.00           C  
ATOM   1216  O   ASP A 150      31.937  35.988  23.238  1.00 29.24           O  
ATOM   1217  CB  ASP A 150      32.615  34.693  20.186  1.00 32.31           C  
ATOM   1218  CG  ASP A 150      31.285  34.082  20.601  1.00 33.13           C  
ATOM   1219  OD1 ASP A 150      30.287  34.822  20.556  1.00 32.70           O  
ATOM   1220  OD2 ASP A 150      31.238  32.855  20.956  1.00 33.19           O  
ATOM   1221  N   ASP A 151      33.768  34.690  23.127  1.00 32.34           N  
ATOM   1222  CA  ASP A 151      33.753  34.263  24.510  1.00 32.69           C  
ATOM   1223  C   ASP A 151      33.866  35.443  25.454  1.00 31.76           C  
ATOM   1224  O   ASP A 151      33.080  35.533  26.394  1.00 30.62           O  
ATOM   1225  CB  ASP A 151      34.931  33.302  24.781  1.00 33.66           C  
ATOM   1226  CG  ASP A 151      35.077  32.937  26.270  1.00 38.06           C  
ATOM   1227  OD1 ASP A 151      34.587  31.850  26.615  1.00 46.07           O  
ATOM   1228  OD2 ASP A 151      35.672  33.736  27.085  1.00 48.08           O  
ATOM   1229  N   ALA A 152      34.849  36.318  25.215  1.00 29.78           N  
ATOM   1230  CA  ALA A 152      35.046  37.475  26.073  1.00 29.57           C  
ATOM   1231  C   ALA A 152      33.821  38.378  26.039  1.00 29.48           C  
ATOM   1232  O   ALA A 152      33.325  38.780  27.117  1.00 28.68           O  
ATOM   1233  CB  ALA A 152      36.324  38.267  25.721  1.00 28.72           C  
ATOM   1234  N   VAL A 153      33.321  38.697  24.839  1.00 28.76           N  
ATOM   1235  CA  VAL A 153      32.208  39.646  24.744  1.00 28.87           C  
ATOM   1236  C   VAL A 153      30.963  39.047  25.382  1.00 28.20           C  
ATOM   1237  O   VAL A 153      30.267  39.691  26.164  1.00 28.83           O  
ATOM   1238  CB  VAL A 153      31.966  40.129  23.309  1.00 28.77           C  
ATOM   1239  CG1 VAL A 153      30.751  41.067  23.210  1.00 26.68           C  
ATOM   1240  CG2 VAL A 153      33.216  40.854  22.773  1.00 32.04           C  
HETATM 1241  N   MSE A 154      30.667  37.804  25.044  1.00 27.87           N  
HETATM 1242  CA  MSE A 154      29.474  37.175  25.573  1.00 29.22           C  
HETATM 1243  C   MSE A 154      29.503  37.055  27.126  1.00 27.95           C  
HETATM 1244  O   MSE A 154      28.487  37.256  27.797  1.00 25.76           O  
HETATM 1245  CB  MSE A 154      29.342  35.812  24.885  1.00 30.90           C  
HETATM 1246  CG  MSE A 154      28.400  34.961  25.492  1.00 37.82           C  
HETATM 1247 SE   MSE A 154      29.099  33.720  26.873  0.80 42.77          SE  
HETATM 1248  CE  MSE A 154      27.922  32.390  26.145  1.00 34.48           C  
ATOM   1249  N   HIS A 155      30.652  36.703  27.688  1.00 27.31           N  
ATOM   1250  CA  HIS A 155      30.804  36.703  29.153  1.00 28.18           C  
ATOM   1251  C   HIS A 155      30.643  38.061  29.818  1.00 26.91           C  
ATOM   1252  O   HIS A 155      30.142  38.130  30.934  1.00 26.30           O  
ATOM   1253  CB  HIS A 155      32.116  36.004  29.607  1.00 27.90           C  
ATOM   1254  CG  HIS A 155      32.035  34.517  29.486  1.00 28.33           C  
ATOM   1255  ND1 HIS A 155      32.769  33.811  28.560  1.00 32.73           N  
ATOM   1256  CD2 HIS A 155      31.197  33.620  30.065  1.00 31.38           C  
ATOM   1257  CE1 HIS A 155      32.449  32.523  28.639  1.00 33.63           C  
ATOM   1258  NE2 HIS A 155      31.490  32.381  29.536  1.00 30.08           N  
ATOM   1259  N   SER A 156      31.019  39.122  29.121  1.00 27.32           N  
ATOM   1260  CA  SER A 156      30.849  40.496  29.650  1.00 26.93           C  
ATOM   1261  C   SER A 156      29.353  40.828  29.781  1.00 27.42           C  
ATOM   1262  O   SER A 156      28.926  41.424  30.771  1.00 27.85           O  
ATOM   1263  CB  SER A 156      31.643  41.513  28.801  1.00 27.22           C  
ATOM   1264  OG  SER A 156      31.030  41.793  27.552  1.00 26.67           O  
ATOM   1265  N   GLY A 157      28.530  40.345  28.836  1.00 27.51           N  
ATOM   1266  CA  GLY A 157      27.090  40.456  28.940  1.00 27.04           C  
ATOM   1267  C   GLY A 157      26.543  39.689  30.112  1.00 27.06           C  
ATOM   1268  O   GLY A 157      25.681  40.191  30.841  1.00 26.34           O  
ATOM   1269  N   GLN A 158      27.034  38.464  30.302  1.00 26.20           N  
ATOM   1270  CA  GLN A 158      26.572  37.667  31.462  1.00 26.35           C  
ATOM   1271  C   GLN A 158      26.923  38.351  32.774  1.00 25.50           C  
ATOM   1272  O   GLN A 158      26.168  38.297  33.735  1.00 25.11           O  
ATOM   1273  CB  GLN A 158      27.158  36.232  31.379  1.00 27.24           C  
ATOM   1274  CG  GLN A 158      26.545  35.409  30.266  1.00 26.06           C  
ATOM   1275  CD  GLN A 158      27.196  34.039  30.053  1.00 26.94           C  
ATOM   1276  OE1 GLN A 158      28.252  33.758  30.623  1.00 28.14           O  
ATOM   1277  NE2 GLN A 158      26.538  33.174  29.257  1.00 22.15           N  
ATOM   1278  N   ALA A 159      28.078  38.997  32.838  1.00 25.77           N  
ATOM   1279  CA  ALA A 159      28.495  39.706  34.084  1.00 25.49           C  
ATOM   1280  C   ALA A 159      27.521  40.792  34.501  1.00 24.56           C  
ATOM   1281  O   ALA A 159      27.283  40.989  35.688  1.00 24.93           O  
ATOM   1282  CB  ALA A 159      29.898  40.295  33.933  1.00 24.87           C  
ATOM   1283  N   VAL A 160      26.951  41.490  33.525  1.00 24.45           N  
ATOM   1284  CA  VAL A 160      25.903  42.487  33.799  1.00 23.46           C  
ATOM   1285  C   VAL A 160      24.694  41.876  34.490  1.00 23.34           C  
ATOM   1286  O   VAL A 160      24.168  42.432  35.455  1.00 22.05           O  
ATOM   1287  CB  VAL A 160      25.455  43.147  32.507  1.00 24.35           C  
ATOM   1288  CG1 VAL A 160      24.236  44.020  32.745  1.00 22.36           C  
ATOM   1289  CG2 VAL A 160      26.623  43.949  31.888  1.00 22.97           C  
ATOM   1290  N   TYR A 161      24.270  40.713  33.999  1.00 23.66           N  
ATOM   1291  CA  TYR A 161      23.142  39.978  34.577  1.00 23.17           C  
ATOM   1292  C   TYR A 161      23.424  39.475  35.991  1.00 23.90           C  
ATOM   1293  O   TYR A 161      22.591  39.620  36.870  1.00 22.86           O  
ATOM   1294  CB  TYR A 161      22.672  38.875  33.585  1.00 23.56           C  
ATOM   1295  CG  TYR A 161      21.586  39.345  32.620  1.00 23.55           C  
ATOM   1296  CD1 TYR A 161      21.425  40.686  32.304  1.00 26.73           C  
ATOM   1297  CD2 TYR A 161      20.712  38.455  32.034  1.00 24.21           C  
ATOM   1298  CE1 TYR A 161      20.403  41.128  31.456  1.00 23.96           C  
ATOM   1299  CE2 TYR A 161      19.700  38.890  31.206  1.00 21.79           C  
ATOM   1300  CZ  TYR A 161      19.560  40.237  30.915  1.00 22.35           C  
ATOM   1301  OH  TYR A 161      18.552  40.685  30.077  1.00 24.49           O  
ATOM   1302  N   THR A 162      24.578  38.860  36.209  1.00 24.32           N  
ATOM   1303  CA  THR A 162      24.935  38.437  37.552  1.00 24.31           C  
ATOM   1304  C   THR A 162      24.938  39.631  38.514  1.00 24.73           C  
ATOM   1305  O   THR A 162      24.479  39.534  39.649  1.00 25.39           O  
ATOM   1306  CB  THR A 162      26.326  37.829  37.582  1.00 23.70           C  
ATOM   1307  OG1 THR A 162      26.315  36.595  36.864  1.00 23.33           O  
ATOM   1308  CG2 THR A 162      26.759  37.569  39.049  1.00 23.57           C  
ATOM   1309  N   ARG A 163      25.494  40.753  38.075  1.00 26.05           N  
ATOM   1310  CA  ARG A 163      25.501  41.983  38.879  1.00 25.73           C  
ATOM   1311  C   ARG A 163      24.089  42.374  39.268  1.00 25.75           C  
ATOM   1312  O   ARG A 163      23.815  42.649  40.448  1.00 24.98           O  
ATOM   1313  CB  ARG A 163      26.165  43.139  38.114  1.00 26.55           C  
ATOM   1314  CG  ARG A 163      26.340  44.454  38.910  1.00 26.72           C  
ATOM   1315  CD  ARG A 163      26.440  45.665  37.979  1.00 29.24           C  
ATOM   1316  NE  ARG A 163      25.172  46.027  37.349  1.00 34.16           N  
ATOM   1317  CZ  ARG A 163      25.016  46.425  36.078  1.00 34.76           C  
ATOM   1318  NH1 ARG A 163      23.805  46.739  35.641  1.00 34.84           N  
ATOM   1319  NH2 ARG A 163      26.044  46.511  35.238  1.00 37.09           N  
ATOM   1320  N   ARG A 164      23.186  42.397  38.297  1.00 25.27           N  
ATOM   1321  CA  ARG A 164      21.786  42.715  38.553  1.00 26.18           C  
ATOM   1322  C   ARG A 164      21.140  41.780  39.564  1.00 27.03           C  
ATOM   1323  O   ARG A 164      20.413  42.230  40.446  1.00 24.71           O  
ATOM   1324  CB  ARG A 164      20.970  42.782  37.251  1.00 26.58           C  
ATOM   1325  CG  ARG A 164      21.389  43.954  36.351  1.00 27.01           C  
ATOM   1326  CD  ARG A 164      20.756  43.893  34.984  1.00 27.60           C  
ATOM   1327  NE  ARG A 164      21.138  45.023  34.137  1.00 29.28           N  
ATOM   1328  CZ  ARG A 164      20.609  45.283  32.935  1.00 30.97           C  
ATOM   1329  NH1 ARG A 164      19.630  44.531  32.439  1.00 31.87           N  
ATOM   1330  NH2 ARG A 164      21.036  46.321  32.227  1.00 31.65           N  
ATOM   1331  N   LEU A 165      21.441  40.490  39.460  1.00 27.39           N  
ATOM   1332  CA  LEU A 165      20.902  39.511  40.399  1.00 27.52           C  
ATOM   1333  C   LEU A 165      21.489  39.661  41.783  1.00 28.80           C  
ATOM   1334  O   LEU A 165      20.803  39.429  42.780  1.00 28.29           O  
ATOM   1335  CB  LEU A 165      21.186  38.088  39.889  1.00 28.12           C  
ATOM   1336  CG  LEU A 165      20.520  37.701  38.581  1.00 28.96           C  
ATOM   1337  CD1 LEU A 165      21.073  36.412  38.043  1.00 27.77           C  
ATOM   1338  CD2 LEU A 165      19.006  37.610  38.813  1.00 31.72           C  
ATOM   1339  N   VAL A 166      22.745  40.085  41.864  1.00 28.75           N  
ATOM   1340  CA  VAL A 166      23.437  40.120  43.145  1.00 30.22           C  
ATOM   1341  C   VAL A 166      23.175  41.419  43.902  1.00 30.77           C  
ATOM   1342  O   VAL A 166      22.939  41.400  45.119  1.00 30.32           O  
ATOM   1343  CB  VAL A 166      24.972  39.885  42.977  1.00 29.49           C  
ATOM   1344  CG1 VAL A 166      25.700  40.106  44.304  1.00 31.53           C  
ATOM   1345  CG2 VAL A 166      25.241  38.471  42.419  1.00 28.77           C  
ATOM   1346  N   ILE A 167      23.210  42.540  43.198  1.00 31.51           N  
ATOM   1347  CA  ILE A 167      23.032  43.844  43.847  1.00 32.98           C  
ATOM   1348  C   ILE A 167      21.752  44.594  43.467  1.00 33.09           C  
ATOM   1349  O   ILE A 167      21.567  45.715  43.901  1.00 33.57           O  
ATOM   1350  CB  ILE A 167      24.288  44.767  43.632  1.00 33.79           C  
ATOM   1351  CG1 ILE A 167      24.333  45.388  42.242  1.00 33.38           C  
ATOM   1352  CG2 ILE A 167      25.583  43.987  43.858  1.00 34.69           C  
ATOM   1353  CD1 ILE A 167      25.466  46.423  42.080  1.00 33.68           C  
ATOM   1354  N   GLY A 168      20.896  43.998  42.642  1.00 33.74           N  
ATOM   1355  CA  GLY A 168      19.604  44.588  42.288  1.00 34.08           C  
ATOM   1356  C   GLY A 168      19.647  45.816  41.393  1.00 35.11           C  
ATOM   1357  O   GLY A 168      18.675  46.563  41.293  1.00 34.71           O  
ATOM   1358  N   LYS A 169      20.766  46.052  40.741  1.00 36.00           N  
ATOM   1359  CA  LYS A 169      20.861  47.199  39.855  1.00 37.67           C  
ATOM   1360  C   LYS A 169      21.954  46.983  38.836  1.00 37.36           C  
ATOM   1361  O   LYS A 169      22.821  46.106  38.953  1.00 37.07           O  
ATOM   1362  CB  LYS A 169      21.108  48.505  40.650  1.00 38.23           C  
ATOM   1363  CG  LYS A 169      22.457  48.564  41.367  1.00 39.26           C  
ATOM   1364  CD  LYS A 169      22.585  49.772  42.294  1.00 40.06           C  
ATOM   1365  CE  LYS A 169      24.064  50.091  42.583  1.00 42.19           C  
ATOM   1366  NZ  LYS A 169      24.848  50.521  41.360  1.00 42.80           N  
ATOM   1367  OXT LYS A 169      21.940  47.695  37.847  1.00 38.58           O  
TER    1368      LYS A 169                                                      
END
MOLECULE T0481.pdb
ATOM   1157  N   ASN     5      43.757  48.627  12.993  1.00 48.55           N  
ATOM   1158  CA  ASN     5      43.707  47.221  13.486  1.00 48.66           C  
ATOM   1159  C   ASN     5      42.297  46.854  13.970  1.00 46.10           C  
ATOM   1160  O   ASN     5      41.931  47.131  15.124  1.00 45.32           O  
ATOM   1161  CB  ASN     5      44.739  47.032  14.610  1.00 49.92           C  
ATOM   1162  CG  ASN     5      45.105  45.561  14.854  1.00 51.98           C  
ATOM   1163  OD1 ASN     5      44.378  44.628  14.479  1.00 41.03           O  
ATOM   1164  ND2 ASN     5      46.252  45.360  15.496  1.00 51.86           N  
ATOM   1165  N   GLN     6      41.522  46.221  13.081  1.00 42.89           N  
ATOM   1166  CA  GLN     6      40.122  45.866  13.363  1.00 39.86           C  
ATOM   1167  C   GLN     6      39.972  44.674  14.322  1.00 37.64           C  
ATOM   1168  O   GLN     6      38.948  44.545  14.985  1.00 37.24           O  
ATOM   1169  CB  GLN     6      39.363  45.603  12.059  1.00 39.17           C  
ATOM   1170  N   ILE     7      40.983  43.809  14.403  1.00 34.88           N  
ATOM   1171  CA  ILE     7      40.937  42.694  15.353  1.00 34.40           C  
ATOM   1172  C   ILE     7      41.043  43.194  16.799  1.00 31.45           C  
ATOM   1173  O   ILE     7      40.216  42.843  17.643  1.00 29.10           O  
ATOM   1174  CB  ILE     7      42.038  41.634  15.082  1.00 34.24           C  
ATOM   1175  CG1 ILE     7      41.687  40.792  13.849  1.00 35.88           C  
ATOM   1176  CG2 ILE     7      42.186  40.712  16.271  1.00 34.37           C  
ATOM   1177  CD1 ILE     7      42.783  39.803  13.446  1.00 36.32           C  
ATOM   1178  N   VAL     8      42.071  44.003  17.067  1.00 31.23           N  
ATOM   1179  CA  VAL     8      42.289  44.610  18.384  1.00 29.82           C  
ATOM   1180  C   VAL     8      41.107  45.490  18.755  1.00 29.64           C  
ATOM   1181  O   VAL     8      40.544  45.353  19.832  1.00 30.66           O  
ATOM   1182  CB  VAL     8      43.589  45.453  18.418  1.00 29.55           C  
ATOM   1183  CG1 VAL     8      43.562  46.438  19.575  1.00 30.78           C  
ATOM   1184  CG2 VAL     8      44.817  44.553  18.513  1.00 26.78           C  
ATOM   1185  N   SER     9      40.726  46.377  17.846  1.00 30.09           N  
ATOM   1186  CA  SER     9      39.600  47.287  18.059  1.00 30.85           C  
ATOM   1187  C   SER     9      38.300  46.564  18.423  1.00 29.88           C  
ATOM   1188  O   SER     9      37.633  46.922  19.394  1.00 30.15           O  
ATOM   1189  CB  SER     9      39.382  48.137  16.796  1.00 31.43           C  
ATOM   1190  OG  SER     9      38.309  49.037  16.971  1.00 34.73           O  
ATOM   1191  N   HIS    10      37.946  45.552  17.640  1.00 29.62           N  
ATOM   1192  CA  HIS    10      36.728  44.774  17.872  1.00 29.21           C  
ATOM   1193  C   HIS    10      36.770  43.988  19.188  1.00 27.89           C  
ATOM   1194  O   HIS    10      35.747  43.834  19.863  1.00 27.83           O  
ATOM   1195  CB  HIS    10      36.453  43.833  16.696  1.00 29.11           C  
ATOM   1196  CG  HIS    10      35.127  43.131  16.782  1.00 30.96           C  
ATOM   1197  ND1 HIS    10      34.991  41.773  16.582  1.00 29.81           N  
ATOM   1198  CD2 HIS    10      33.882  43.596  17.055  1.00 32.11           C  
ATOM   1199  CE1 HIS    10      33.723  41.432  16.721  1.00 34.31           C  
ATOM   1200  NE2 HIS    10      33.025  42.520  17.004  1.00 31.48           N  
ATOM   1201  N   PHE    11      37.946  43.490  19.545  1.00 26.50           N  
ATOM   1202  CA  PHE    11      38.144  42.846  20.847  1.00 25.86           C  
ATOM   1203  C   PHE    11      37.899  43.833  22.005  1.00 25.41           C  
ATOM   1204  O   PHE    11      37.131  43.543  22.922  1.00 26.59           O  
ATOM   1205  CB  PHE    11      39.561  42.251  20.931  1.00 25.87           C  
ATOM   1206  CG  PHE    11      39.978  41.854  22.325  1.00 23.85           C  
ATOM   1207  CD1 PHE    11      39.402  40.765  22.948  1.00 23.40           C  
ATOM   1208  CD2 PHE    11      40.940  42.587  23.009  1.00 24.43           C  
ATOM   1209  CE1 PHE    11      39.769  40.403  24.233  1.00 24.62           C  
ATOM   1210  CE2 PHE    11      41.331  42.230  24.298  1.00 26.60           C  
ATOM   1211  CZ  PHE    11      40.751  41.136  24.910  1.00 25.39           C  
ATOM   1212  N   LEU    12      38.558  44.993  21.960  1.00 25.19           N  
ATOM   1213  CA  LEU    12      38.433  46.000  23.024  1.00 24.40           C  
ATOM   1214  C   LEU    12      37.013  46.571  23.154  1.00 24.37           C  
ATOM   1215  O   LEU    12      36.551  46.899  24.244  1.00 23.55           O  
ATOM   1216  CB  LEU    12      39.429  47.127  22.787  1.00 25.08           C  
ATOM   1217  CG  LEU    12      40.903  46.732  22.935  1.00 23.88           C  
ATOM   1218  CD1 LEU    12      41.772  47.927  22.675  1.00 19.99           C  
ATOM   1219  CD2 LEU    12      41.172  46.151  24.314  1.00 17.50           C  
ATOM   1220  N   SER    13      36.345  46.698  22.018  1.00 24.35           N  
ATOM   1221  CA  SER    13      34.937  47.074  21.945  1.00 24.92           C  
ATOM   1222  C   SER    13      34.094  46.327  22.991  1.00 25.13           C  
ATOM   1223  O   SER    13      33.214  46.894  23.629  1.00 27.77           O  
ATOM   1224  CB  SER    13      34.440  46.723  20.541  1.00 25.22           C  
ATOM   1225  OG  SER    13      33.092  47.020  20.376  1.00 26.42           O  
ATOM   1226  N   HIS    14      34.392  45.046  23.150  1.00 24.32           N  
ATOM   1227  CA  HIS    14      33.720  44.177  24.093  1.00 23.44           C  
ATOM   1228  C   HIS    14      34.479  44.063  25.424  1.00 22.45           C  
ATOM   1229  O   HIS    14      33.887  44.226  26.488  1.00 22.95           O  
ATOM   1230  CB  HIS    14      33.528  42.795  23.455  1.00 23.60           C  
ATOM   1231  CG  HIS    14      32.468  42.759  22.397  1.00 22.55           C  
ATOM   1232  ND1 HIS    14      31.123  42.736  22.695  1.00 22.51           N  
ATOM   1233  CD2 HIS    14      32.554  42.716  21.047  1.00 24.07           C  
ATOM   1234  CE1 HIS    14      30.425  42.689  21.575  1.00 22.12           C  
ATOM   1235  NE2 HIS    14      31.270  42.672  20.559  1.00 23.74           N  
ATOM   1236  N   ARG    15      35.782  43.819  25.364  1.00 23.33           N  
ATOM   1237  CA  ARG    15      36.609  43.694  26.581  1.00 23.65           C  
ATOM   1238  C   ARG    15      36.617  44.947  27.474  1.00 24.04           C  
ATOM   1239  O   ARG    15      36.658  44.830  28.696  1.00 25.31           O  
ATOM   1240  CB  ARG    15      38.040  43.267  26.216  1.00 22.98           C  
ATOM   1241  CG  ARG    15      39.061  43.250  27.369  1.00 25.04           C  
ATOM   1242  CD  ARG    15      38.654  42.372  28.575  1.00 23.51           C  
ATOM   1243  NE  ARG    15      38.553  40.961  28.233  1.00 25.26           N  
ATOM   1244  CZ  ARG    15      39.583  40.124  28.141  1.00 29.21           C  
ATOM   1245  NH1 ARG    15      40.828  40.529  28.388  1.00 30.40           N  
ATOM   1246  NH2 ARG    15      39.358  38.857  27.809  1.00 26.91           N  
ATOM   1247  N   ASN    16      36.571  46.142  26.889  1.00 24.45           N  
ATOM   1248  CA  ASN    16      36.470  47.356  27.702  1.00 24.31           C  
ATOM   1249  C   ASN    16      35.182  47.388  28.527  1.00 24.67           C  
ATOM   1250  O   ASN    16      35.152  47.967  29.618  1.00 24.35           O  
ATOM   1251  CB  ASN    16      36.580  48.634  26.848  1.00 23.87           C  
ATOM   1252  CG  ASN    16      37.991  48.873  26.313  1.00 25.17           C  
ATOM   1253  OD1 ASN    16      38.980  48.416  26.887  1.00 27.85           O  
ATOM   1254  ND2 ASN    16      38.085  49.616  25.218  1.00 24.54           N  
ATOM   1255  N   VAL    17      34.112  46.792  28.005  1.00 25.32           N  
ATOM   1256  CA  VAL    17      32.845  46.739  28.750  1.00 25.14           C  
ATOM   1257  C   VAL    17      32.951  45.686  29.871  1.00 25.47           C  
ATOM   1258  O   VAL    17      32.466  45.898  30.980  1.00 24.38           O  
ATOM   1259  CB  VAL    17      31.636  46.485  27.807  1.00 25.11           C  
ATOM   1260  CG1 VAL    17      30.329  46.424  28.590  1.00 23.93           C  
ATOM   1261  CG2 VAL    17      31.567  47.563  26.732  1.00 21.19           C  
ATOM   1262  N   THR    18      33.621  44.570  29.581  1.00 26.85           N  
ATOM   1263  CA  THR    18      33.871  43.517  30.570  1.00 27.43           C  
ATOM   1264  C   THR    18      34.686  44.040  31.750  1.00 28.37           C  
ATOM   1265  O   THR    18      34.401  43.716  32.908  1.00 27.86           O  
ATOM   1266  CB  THR    18      34.631  42.343  29.937  1.00 26.46           C  
ATOM   1267  OG1 THR    18      33.758  41.641  29.047  1.00 28.22           O  
ATOM   1268  CG2 THR    18      35.153  41.393  31.005  1.00 26.76           C  
ATOM   1269  N   ASN    19      35.712  44.830  31.436  1.00 29.46           N  
ATOM   1270  CA  ASN    19      36.583  45.415  32.444  1.00 29.44           C  
ATOM   1271  C   ASN    19      35.877  46.449  33.302  1.00 31.03           C  
ATOM   1272  O   ASN    19      36.120  46.544  34.505  1.00 32.27           O  
ATOM   1273  CB  ASN    19      37.800  46.053  31.781  1.00 28.63           C  
ATOM   1274  CG  ASN    19      38.752  45.038  31.224  1.00 27.67           C  
ATOM   1275  OD1 ASN    19      38.698  43.849  31.561  1.00 29.89           O  
ATOM   1276  ND2 ASN    19      39.631  45.490  30.362  1.00 16.24           N  
ATOM   1277  N   GLU    20      35.009  47.226  32.673  1.00 32.85           N  
ATOM   1278  CA  GLU    20      34.197  48.215  33.378  1.00 34.98           C  
ATOM   1279  C   GLU    20      33.218  47.533  34.338  1.00 32.92           C  
ATOM   1280  O   GLU    20      33.018  47.999  35.451  1.00 35.00           O  
ATOM   1281  CB  GLU    20      33.450  49.089  32.369  1.00 34.33           C  
ATOM   1282  CG  GLU    20      32.885  50.367  32.951  1.00 41.33           C  
ATOM   1283  CD  GLU    20      32.241  51.269  31.906  1.00 41.71           C  
ATOM   1284  OE1 GLU    20      32.529  51.102  30.688  1.00 48.89           O  
ATOM   1285  OE2 GLU    20      31.448  52.149  32.316  1.00 50.11           O  
ATOM   1286  N   LEU    21      32.624  46.426  33.905  1.00 31.28           N  
ATOM   1287  CA  LEU    21      31.700  45.645  34.734  1.00 30.29           C  
ATOM   1288  C   LEU    21      32.414  44.977  35.915  1.00 30.39           C  
ATOM   1289  O   LEU    21      31.860  44.873  37.015  1.00 30.47           O  
ATOM   1290  CB  LEU    21      30.993  44.561  33.892  1.00 29.76           C  
ATOM   1291  CG  LEU    21      29.893  44.963  32.899  1.00 27.66           C  
ATOM   1292  CD1 LEU    21      29.501  43.764  32.026  1.00 22.19           C  
ATOM   1293  CD2 LEU    21      28.660  45.529  33.614  1.00 25.56           C  
ATOM   1294  N   ALA    22      33.635  44.512  35.672  1.00 30.64           N  
ATOM   1295  CA  ALA    22      34.460  43.895  36.710  1.00 31.48           C  
ATOM   1296  C   ALA    22      34.780  44.861  37.856  1.00 32.45           C  
ATOM   1297  O   ALA    22      34.888  44.450  39.016  1.00 31.11           O  
ATOM   1298  CB  ALA    22      35.755  43.354  36.098  1.00 31.19           C  
ATOM   1299  N   GLU    23      34.934  46.138  37.510  1.00 34.47           N  
ATOM   1300  CA  GLU    23      35.214  47.208  38.475  1.00 36.19           C  
ATOM   1301  C   GLU    23      34.053  47.424  39.453  1.00 35.68           C  
ATOM   1302  O   GLU    23      34.267  47.870  40.573  1.00 36.37           O  
ATOM   1303  CB  GLU    23      35.582  48.500  37.711  1.00 36.80           C  
ATOM   1304  CG  GLU    23      34.996  49.826  38.232  1.00 44.97           C  
ATOM   1305  CD  GLU    23      35.795  50.464  39.365  1.00 54.10           C  
ATOM   1306  OE1 GLU    23      37.029  50.243  39.444  1.00 58.36           O  
ATOM   1307  OE2 GLU    23      35.181  51.215  40.160  1.00 55.37           O  
ATOM   1308  N   LYS    24      32.837  47.095  39.020  1.00 35.78           N  
ATOM   1309  CA  LYS    24      31.630  47.243  39.828  1.00 36.00           C  
ATOM   1310  C   LYS    24      31.403  46.089  40.811  1.00 36.32           C  
ATOM   1311  O   LYS    24      30.399  46.071  41.524  1.00 37.08           O  
ATOM   1312  CB  LYS    24      30.411  47.385  38.910  1.00 36.20           C  
ATOM   1313  CG  LYS    24      30.488  48.628  38.038  1.00 37.65           C  
ATOM   1314  CD  LYS    24      29.127  49.070  37.532  1.00 40.50           C  
ATOM   1315  CE  LYS    24      29.157  50.541  37.089  1.00 46.04           C  
ATOM   1316  NZ  LYS    24      30.023  50.741  35.879  1.00 47.21           N  
ATOM   1317  N   ILE    25      32.337  45.138  40.840  1.00 35.88           N  
ATOM   1318  CA  ILE    25      32.294  43.987  41.733  1.00 35.06           C  
ATOM   1319  C   ILE    25      33.129  44.260  42.988  1.00 36.05           C  
ATOM   1320  O   ILE    25      34.364  44.186  42.953  1.00 35.12           O  
ATOM   1321  CB  ILE    25      32.851  42.718  41.022  1.00 34.99           C  
ATOM   1322  CG1 ILE    25      32.047  42.405  39.750  1.00 36.68           C  
ATOM   1323  CG2 ILE    25      32.848  41.515  41.959  1.00 34.29           C  
ATOM   1324  CD1 ILE    25      32.637  41.292  38.907  1.00 33.67           C  
ATOM   1325  N   SER    26      32.457  44.580  44.092  1.00 37.22           N  
ATOM   1326  CA  SER    26      33.128  44.736  45.383  1.00 38.56           C  
ATOM   1327  C   SER    26      33.758  43.410  45.786  1.00 40.35           C  
ATOM   1328  O   SER    26      33.334  42.354  45.310  1.00 41.06           O  
ATOM   1329  CB  SER    26      32.125  45.138  46.459  1.00 38.56           C  
ATOM   1330  OG  SER    26      31.263  44.055  46.775  1.00 37.07           O  
ATOM   1331  N   LYS    27      34.756  43.461  46.666  1.00 41.84           N  
ATOM   1332  CA  LYS    27      35.441  42.247  47.124  1.00 43.21           C  
ATOM   1333  C   LYS    27      34.509  41.312  47.910  1.00 42.45           C  
ATOM   1334  O   LYS    27      34.734  40.103  47.968  1.00 41.33           O  
ATOM   1335  CB  LYS    27      36.707  42.600  47.918  1.00 43.47           C  
ATOM   1336  CG  LYS    27      37.740  43.358  47.071  1.00 45.04           C  
ATOM   1337  CD  LYS    27      39.142  43.329  47.664  1.00 45.26           C  
ATOM   1338  CE  LYS    27      39.954  42.132  47.180  1.00 47.98           C  
ATOM   1339  NZ  LYS    27      40.646  42.396  45.885  1.00 44.46           N  
ATOM   1340  N   ASP    28      33.448  41.865  48.491  1.00 43.17           N  
ATOM   1341  CA  ASP    28      32.423  41.038  49.143  1.00 43.66           C  
ATOM   1342  C   ASP    28      31.589  40.274  48.109  1.00 42.08           C  
ATOM   1343  O   ASP    28      30.981  39.250  48.419  1.00 41.99           O  
ATOM   1344  CB  ASP    28      31.504  41.876  50.056  1.00 44.61           C  
ATOM   1345  CG  ASP    28      32.015  41.950  51.499  1.00 50.08           C  
ATOM   1346  OD1 ASP    28      32.189  40.877  52.115  1.00 52.94           O  
ATOM   1347  OD2 ASP    28      32.229  43.067  52.026  1.00 53.70           O  
ATOM   1348  N   HIS    29      31.575  40.767  46.875  1.00 40.09           N  
ATOM   1349  CA  HIS    29      30.784  40.157  45.813  1.00 38.00           C  
ATOM   1350  C   HIS    29      31.591  39.254  44.869  1.00 35.48           C  
ATOM   1351  O   HIS    29      31.047  38.750  43.891  1.00 34.55           O  
ATOM   1352  CB  HIS    29      30.051  41.241  45.014  1.00 37.73           C  
ATOM   1353  CG  HIS    29      28.769  41.692  45.637  1.00 38.39           C  
ATOM   1354  ND1 HIS    29      28.368  43.010  45.641  1.00 39.31           N  
ATOM   1355  CD2 HIS    29      27.793  40.999  46.267  1.00 39.76           C  
ATOM   1356  CE1 HIS    29      27.201  43.109  46.251  1.00 41.37           C  
ATOM   1357  NE2 HIS    29      26.830  41.903  46.639  1.00 41.73           N  
ATOM   1358  N   TYR    30      32.873  39.052  45.163  1.00 33.70           N  
ATOM   1359  CA  TYR    30      33.706  38.095  44.423  1.00 32.36           C  
ATOM   1360  C   TYR    30      33.079  36.686  44.430  1.00 32.70           C  
ATOM   1361  O   TYR    30      33.074  35.983  43.416  1.00 32.96           O  
ATOM   1362  CB  TYR    30      35.106  38.029  45.044  1.00 31.66           C  
ATOM   1363  CG  TYR    30      36.109  39.075  44.583  1.00 30.06           C  
ATOM   1364  CD1 TYR    30      35.708  40.312  44.111  1.00 29.10           C  
ATOM   1365  CD2 TYR    30      37.483  38.822  44.672  1.00 30.44           C  
ATOM   1366  CE1 TYR    30      36.643  41.265  43.700  1.00 29.51           C  
ATOM   1367  CE2 TYR    30      38.421  39.763  44.272  1.00 29.19           C  
ATOM   1368  CZ  TYR    30      37.999  40.983  43.786  1.00 31.71           C  
ATOM   1369  OH  TYR    30      38.933  41.930  43.389  1.00 31.55           O  
ATOM   1370  N   SER    31      32.546  36.289  45.586  1.00 32.70           N  
ATOM   1371  CA  SER    31      31.925  34.974  45.767  1.00 31.27           C  
ATOM   1372  C   SER    31      30.485  34.902  45.255  1.00 29.76           C  
ATOM   1373  O   SER    31      29.886  33.828  45.261  1.00 29.74           O  
ATOM   1374  CB  SER    31      31.904  34.639  47.255  1.00 31.47           C  
ATOM   1375  OG  SER    31      31.001  35.510  47.929  1.00 31.56           O  
ATOM   1376  N   TYR    32      29.923  36.031  44.826  1.00 29.31           N  
ATOM   1377  CA  TYR    32      28.493  36.105  44.518  1.00 28.85           C  
ATOM   1378  C   TYR    32      28.089  35.149  43.394  1.00 30.14           C  
ATOM   1379  O   TYR    32      28.698  35.128  42.324  1.00 31.63           O  
ATOM   1380  CB  TYR    32      28.054  37.533  44.156  1.00 28.51           C  
ATOM   1381  CG  TYR    32      26.573  37.583  43.859  1.00 28.85           C  
ATOM   1382  CD1 TYR    32      25.640  37.573  44.892  1.00 30.87           C  
ATOM   1383  CD2 TYR    32      26.104  37.564  42.555  1.00 30.04           C  
ATOM   1384  CE1 TYR    32      24.285  37.577  44.632  1.00 31.57           C  
ATOM   1385  CE2 TYR    32      24.743  37.561  42.284  1.00 28.50           C  
ATOM   1386  CZ  TYR    32      23.840  37.567  43.328  1.00 30.20           C  
ATOM   1387  OH  TYR    32      22.491  37.566  43.071  1.00 27.86           O  
ATOM   1388  N   LYS    33      27.062  34.354  43.664  1.00 30.60           N  
ATOM   1389  CA  LYS    33      26.541  33.386  42.716  1.00 30.67           C  
ATOM   1390  C   LYS    33      25.036  33.621  42.611  1.00 29.00           C  
ATOM   1391  O   LYS    33      24.353  33.610  43.634  1.00 27.20           O  
ATOM   1392  CB  LYS    33      26.804  31.963  43.218  1.00 30.54           C  
ATOM   1393  CG  LYS    33      28.261  31.518  43.131  1.00 31.84           C  
ATOM   1394  CD  LYS    33      28.444  30.104  43.651  1.00 32.67           C  
ATOM   1395  CE  LYS    33      29.915  29.685  43.643  1.00 38.32           C  
ATOM   1396  NZ  LYS    33      30.093  28.233  43.927  1.00 35.17           N  
ATOM   1397  N   PRO    34      24.527  33.902  41.397  1.00 27.53           N  
ATOM   1398  CA  PRO    34      23.093  34.023  41.131  1.00 27.92           C  
ATOM   1399  C   PRO    34      22.258  32.808  41.526  1.00 27.42           C  
ATOM   1400  O   PRO    34      21.134  32.971  42.007  1.00 26.94           O  
ATOM   1401  CB  PRO    34      23.043  34.209  39.609  1.00 28.69           C  
ATOM   1402  CG  PRO    34      24.349  34.838  39.276  1.00 28.43           C  
ATOM   1403  CD  PRO    34      25.323  34.197  40.193  1.00 27.34           C  
ATOM   1404  N   ALA    35      22.800  31.615  41.282  1.00 28.20           N  
ATOM   1405  CA  ALA    35      22.192  30.348  41.691  1.00 29.19           C  
ATOM   1406  C   ALA    35      23.291  29.440  42.234  1.00 30.41           C  
ATOM   1407  O   ALA    35      24.477  29.688  41.984  1.00 29.92           O  
ATOM   1408  CB  ALA    35      21.486  29.688  40.515  1.00 27.66           C  
ATOM   1409  N   GLU    36      22.900  28.382  42.949  1.00 31.54           N  
ATOM   1410  CA  GLU    36      23.861  27.475  43.590  1.00 33.38           C  
ATOM   1411  C   GLU    36      24.823  26.807  42.625  1.00 32.55           C  
ATOM   1412  O   GLU    36      25.968  26.559  42.979  1.00 33.40           O  
ATOM   1413  CB  GLU    36      23.150  26.386  44.381  1.00 34.20           C  
ATOM   1414  CG  GLU    36      22.389  26.881  45.598  1.00 37.06           C  
ATOM   1415  CD  GLU    36      22.094  25.766  46.602  1.00 39.82           C  
ATOM   1416  OE1 GLU    36      22.175  24.569  46.227  1.00 44.32           O  
ATOM   1417  OE2 GLU    36      21.794  26.094  47.775  1.00 47.78           O  
ATOM   1418  N   THR    37      24.351  26.510  41.419  1.00 31.80           N  
ATOM   1419  CA  THR    37      25.157  25.853  40.393  1.00 31.56           C  
ATOM   1420  C   THR    37      25.885  26.843  39.474  1.00 32.32           C  
ATOM   1421  O   THR    37      26.457  26.434  38.474  1.00 33.55           O  
ATOM   1422  CB  THR    37      24.262  24.924  39.568  1.00 31.01           C  
ATOM   1423  OG1 THR    37      23.098  25.641  39.152  1.00 31.99           O  
ATOM   1424  CG2 THR    37      23.806  23.726  40.418  1.00 31.00           C  
ATOM   1425  N   SER    38      25.883  28.134  39.826  1.00 32.65           N  
ATOM   1426  CA  SER    38      26.541  29.182  39.021  1.00 31.97           C  
ATOM   1427  C   SER    38      28.004  29.341  39.378  1.00 30.83           C  
ATOM   1428  O   SER    38      28.405  28.993  40.476  1.00 31.30           O  
ATOM   1429  CB  SER    38      25.870  30.550  39.232  1.00 31.46           C  
ATOM   1430  OG  SER    38      24.536  30.548  38.778  1.00 32.46           O  
ATOM   1431  N   MET    39      28.791  29.880  38.446  1.00 30.71           N  
ATOM   1432  CA  MET    39      30.141  30.329  38.764  1.00 28.97           C  
ATOM   1433  C   MET    39      29.976  31.552  39.652  1.00 28.65           C  
ATOM   1434  O   MET    39      28.998  32.284  39.522  1.00 27.14           O  
ATOM   1435  CB  MET    39      30.933  30.734  37.516  1.00 28.74           C  
ATOM   1436  CG  MET    39      31.363  29.598  36.573  1.00 31.41           C  
ATOM   1437  SD  MET    39      32.514  30.228  35.067  0.75 25.74          SE  
ATOM   1438  CE  MET    39      34.264  29.826  35.772  1.00 37.14           C  
ATOM   1439  N   SER    40      30.928  31.768  40.550  1.00 28.71           N  
ATOM   1440  CA  SER    40      30.961  32.977  41.347  1.00 28.93           C  
ATOM   1441  C   SER    40      31.356  34.119  40.422  1.00 29.26           C  
ATOM   1442  O   SER    40      31.856  33.886  39.321  1.00 28.27           O  
ATOM   1443  CB  SER    40      31.977  32.857  42.485  1.00 28.55           C  
ATOM   1444  OG  SER    40      33.300  32.845  41.971  1.00 31.56           O  
ATOM   1445  N   ALA    41      31.141  35.346  40.883  1.00 29.32           N  
ATOM   1446  CA  ALA    41      31.479  36.531  40.109  1.00 28.43           C  
ATOM   1447  C   ALA    41      32.928  36.492  39.643  1.00 28.87           C  
ATOM   1448  O   ALA    41      33.208  36.745  38.475  1.00 29.06           O  
ATOM   1449  CB  ALA    41      31.216  37.789  40.924  1.00 28.00           C  
ATOM   1450  N   GLU    42      33.844  36.156  40.549  1.00 30.19           N  
ATOM   1451  CA  GLU    42      35.266  36.137  40.215  1.00 32.30           C  
ATOM   1452  C   GLU    42      35.669  34.956  39.338  1.00 31.49           C  
ATOM   1453  O   GLU    42      36.549  35.098  38.495  1.00 31.64           O  
ATOM   1454  CB  GLU    42      36.150  36.217  41.468  1.00 32.29           C  
ATOM   1455  CG  GLU    42      36.145  35.016  42.371  1.00 35.81           C  
ATOM   1456  CD  GLU    42      37.144  35.156  43.514  1.00 36.28           C  
ATOM   1457  OE1 GLU    42      38.328  35.484  43.242  1.00 35.57           O  
ATOM   1458  OE2 GLU    42      36.744  34.923  44.680  1.00 43.97           O  
ATOM   1459  N   GLU    43      35.044  33.797  39.532  1.00 30.87           N  
ATOM   1460  CA  GLU    43      35.260  32.661  38.625  1.00 30.39           C  
ATOM   1461  C   GLU    43      34.845  33.040  37.214  1.00 29.35           C  
ATOM   1462  O   GLU    43      35.531  32.703  36.238  1.00 29.22           O  
ATOM   1463  CB  GLU    43      34.467  31.425  39.060  1.00 30.93           C  
ATOM   1464  CG  GLU    43      35.062  30.666  40.239  1.00 32.30           C  
ATOM   1465  CD  GLU    43      34.153  29.551  40.752  1.00 32.16           C  
ATOM   1466  OE1 GLU    43      32.930  29.604  40.535  1.00 35.30           O  
ATOM   1467  OE2 GLU    43      34.667  28.617  41.401  1.00 38.93           O  
ATOM   1468  N   LEU    44      33.722  33.747  37.111  1.00 27.81           N  
ATOM   1469  CA  LEU    44      33.205  34.170  35.813  1.00 27.14           C  
ATOM   1470  C   LEU    44      34.204  35.093  35.145  1.00 26.11           C  
ATOM   1471  O   LEU    44      34.615  34.849  34.019  1.00 26.10           O  
ATOM   1472  CB  LEU    44      31.835  34.853  35.958  1.00 27.33           C  
ATOM   1473  CG  LEU    44      31.197  35.427  34.687  1.00 26.54           C  
ATOM   1474  CD1 LEU    44      31.341  34.484  33.494  1.00 26.87           C  
ATOM   1475  CD2 LEU    44      29.729  35.714  34.941  1.00 25.50           C  
ATOM   1476  N   VAL    45      34.619  36.132  35.865  1.00 26.48           N  
ATOM   1477  CA  VAL    45      35.510  37.144  35.325  1.00 26.04           C  
ATOM   1478  C   VAL    45      36.867  36.552  34.944  1.00 27.08           C  
ATOM   1479  O   VAL    45      37.346  36.802  33.850  1.00 27.54           O  
ATOM   1480  CB  VAL    45      35.683  38.334  36.309  1.00 27.04           C  
ATOM   1481  CG1 VAL    45      36.744  39.312  35.797  1.00 25.46           C  
ATOM   1482  CG2 VAL    45      34.352  39.042  36.521  1.00 23.13           C  
ATOM   1483  N   LYS    46      37.482  35.767  35.827  1.00 28.21           N  
ATOM   1484  CA  LYS    46      38.793  35.155  35.522  1.00 29.00           C  
ATOM   1485  C   LYS    46      38.708  34.265  34.287  1.00 28.55           C  
ATOM   1486  O   LYS    46      39.629  34.250  33.464  1.00 29.07           O  
ATOM   1487  CB  LYS    46      39.324  34.321  36.690  1.00 29.20           C  
ATOM   1488  CG  LYS    46      39.776  35.118  37.886  1.00 31.60           C  
ATOM   1489  CD  LYS    46      40.299  34.197  38.968  1.00 29.66           C  
ATOM   1490  CE  LYS    46      40.389  34.916  40.294  1.00 37.54           C  
ATOM   1491  NZ  LYS    46      40.795  33.997  41.394  1.00 35.65           N  
ATOM   1492  N   HIS    47      37.616  33.505  34.172  1.00 27.91           N  
ATOM   1493  CA  HIS    47      37.432  32.622  33.016  1.00 27.17           C  
ATOM   1494  C   HIS    47      37.379  33.401  31.699  1.00 25.59           C  
ATOM   1495  O   HIS    47      37.956  32.964  30.704  1.00 26.75           O  
ATOM   1496  CB  HIS    47      36.190  31.743  33.159  1.00 27.46           C  
ATOM   1497  CG  HIS    47      35.905  30.922  31.937  1.00 28.87           C  
ATOM   1498  ND1 HIS    47      36.734  29.908  31.515  1.00 32.09           N  
ATOM   1499  CD2 HIS    47      34.908  30.996  31.025  1.00 28.90           C  
ATOM   1500  CE1 HIS    47      36.257  29.387  30.399  1.00 27.52           C  
ATOM   1501  NE2 HIS    47      35.146  30.027  30.083  1.00 28.54           N  
ATOM   1502  N   ILE    48      36.699  34.545  31.701  1.00 25.40           N  
ATOM   1503  CA  ILE    48      36.648  35.436  30.536  1.00 24.70           C  
ATOM   1504  C   ILE    48      38.065  35.852  30.154  1.00 25.30           C  
ATOM   1505  O   ILE    48      38.456  35.765  28.997  1.00 26.11           O  
ATOM   1506  CB  ILE    48      35.781  36.700  30.805  1.00 25.39           C  
ATOM   1507  CG1 ILE    48      34.294  36.324  30.910  1.00 26.97           C  
ATOM   1508  CG2 ILE    48      35.972  37.754  29.707  1.00 21.47           C  
ATOM   1509  CD1 ILE    48      33.372  37.436  31.476  1.00 21.56           C  
ATOM   1510  N   LEU    49      38.837  36.259  31.148  1.00 25.60           N  
ATOM   1511  CA  LEU    49      40.199  36.717  30.947  1.00 24.97           C  
ATOM   1512  C   LEU    49      41.170  35.634  30.482  1.00 25.95           C  
ATOM   1513  O   LEU    49      41.891  35.831  29.502  1.00 27.25           O  
ATOM   1514  CB  LEU    49      40.725  37.337  32.231  1.00 24.59           C  
ATOM   1515  CG  LEU    49      40.077  38.643  32.687  1.00 26.07           C  
ATOM   1516  CD1 LEU    49      40.707  39.082  34.017  1.00 25.43           C  
ATOM   1517  CD2 LEU    49      40.202  39.746  31.632  1.00 21.72           C  
ATOM   1518  N   THR    50      41.206  34.501  31.184  1.00 26.62           N  
ATOM   1519  CA  THR    50      42.139  33.428  30.831  1.00 26.53           C  
ATOM   1520  C   THR    50      41.768  32.721  29.518  1.00 28.19           C  
ATOM   1521  O   THR    50      42.664  32.330  28.753  1.00 29.08           O  
ATOM   1522  CB  THR    50      42.279  32.370  31.958  1.00 26.75           C  
ATOM   1523  OG1 THR    50      41.018  31.734  32.195  1.00 29.27           O  
ATOM   1524  CG2 THR    50      42.785  33.010  33.255  1.00 20.35           C  
ATOM   1525  N   SER    51      40.469  32.568  29.242  1.00 28.56           N  
ATOM   1526  CA  SER    51      40.053  31.808  28.064  1.00 29.13           C  
ATOM   1527  C   SER    51      40.431  32.521  26.777  1.00 28.90           C  
ATOM   1528  O   SER    51      40.940  31.880  25.847  1.00 30.53           O  
ATOM   1529  CB  SER    51      38.557  31.446  28.084  1.00 28.88           C  
ATOM   1530  OG  SER    51      37.727  32.590  28.069  1.00 33.02           O  
ATOM   1531  N   PHE    52      40.194  33.830  26.703  1.00 27.66           N  
ATOM   1532  CA  PHE    52      40.530  34.557  25.483  1.00 27.14           C  
ATOM   1533  C   PHE    52      42.039  34.554  25.296  1.00 27.70           C  
ATOM   1534  O   PHE    52      42.530  34.421  24.178  1.00 28.71           O  
ATOM   1535  CB  PHE    52      40.001  35.993  25.481  1.00 27.08           C  
ATOM   1536  CG  PHE    52      39.811  36.560  24.089  1.00 25.86           C  
ATOM   1537  CD1 PHE    52      40.907  36.795  23.256  1.00 25.78           C  
ATOM   1538  CD2 PHE    52      38.542  36.839  23.608  1.00 23.07           C  
ATOM   1539  CE1 PHE    52      40.725  37.299  21.977  1.00 26.17           C  
ATOM   1540  CE2 PHE    52      38.359  37.351  22.333  1.00 23.04           C  
ATOM   1541  CZ  PHE    52      39.446  37.570  21.514  1.00 23.22           C  
ATOM   1542  N   HIS    53      42.772  34.683  26.394  1.00 28.75           N  
ATOM   1543  CA  HIS    53      44.234  34.689  26.347  1.00 29.87           C  
ATOM   1544  C   HIS    53      44.799  33.336  25.861  1.00 29.22           C  
ATOM   1545  O   HIS    53      45.774  33.303  25.101  1.00 28.96           O  
ATOM   1546  CB  HIS    53      44.812  35.081  27.710  1.00 29.38           C  
ATOM   1547  CG  HIS    53      46.297  35.259  27.699  1.00 32.09           C  
ATOM   1548  ND1 HIS    53      47.161  34.324  28.221  1.00 36.75           N  
ATOM   1549  CD2 HIS    53      47.071  36.250  27.200  1.00 34.27           C  
ATOM   1550  CE1 HIS    53      48.405  34.738  28.056  1.00 36.33           C  
ATOM   1551  NE2 HIS    53      48.377  35.904  27.439  1.00 35.25           N  
ATOM   1552  N   LEU    54      44.175  32.237  26.280  1.00 28.84           N  
ATOM   1553  CA  LEU    54      44.545  30.908  25.787  1.00 29.41           C  
ATOM   1554  C   LEU    54      44.344  30.820  24.271  1.00 29.89           C  
ATOM   1555  O   LEU    54      45.283  30.469  23.530  1.00 28.10           O  
ATOM   1556  CB  LEU    54      43.746  29.812  26.501  1.00 28.57           C  
ATOM   1557  CG  LEU    54      44.049  28.359  26.102  1.00 30.83           C  
ATOM   1558  CD1 LEU    54      45.538  28.026  26.269  1.00 28.39           C  
ATOM   1559  CD2 LEU    54      43.180  27.371  26.890  1.00 30.29           C  
ATOM   1560  N   PHE    55      43.134  31.159  23.817  1.00 30.20           N  
ATOM   1561  CA  PHE    55      42.819  31.153  22.382  1.00 32.29           C  
ATOM   1562  C   PHE    55      43.787  32.023  21.577  1.00 31.95           C  
ATOM   1563  O   PHE    55      44.243  31.620  20.510  1.00 32.57           O  
ATOM   1564  CB  PHE    55      41.398  31.652  22.119  1.00 34.13           C  
ATOM   1565  CG  PHE    55      40.317  30.681  22.505  1.00 36.99           C  
ATOM   1566  CD1 PHE    55      40.343  29.372  22.063  1.00 39.85           C  
ATOM   1567  CD2 PHE    55      39.236  31.104  23.275  1.00 45.14           C  
ATOM   1568  CE1 PHE    55      39.330  28.494  22.403  1.00 44.15           C  
ATOM   1569  CE2 PHE    55      38.220  30.231  23.620  1.00 45.62           C  
ATOM   1570  CZ  PHE    55      38.263  28.923  23.179  1.00 43.03           C  
ATOM   1571  N   ALA    56      44.077  33.221  22.089  1.00 31.31           N  
ATOM   1572  CA  ALA    56      45.030  34.131  21.448  1.00 30.70           C  
ATOM   1573  C   ALA    56      46.421  33.491  21.272  1.00 29.92           C  
ATOM   1574  O   ALA    56      47.059  33.654  20.231  1.00 30.50           O  
ATOM   1575  CB  ALA    56      45.132  35.443  22.241  1.00 30.35           C  
ATOM   1576  N   ASN    57      46.879  32.749  22.274  1.00 30.14           N  
ATOM   1577  CA  ASN    57      48.161  32.034  22.164  1.00 31.35           C  
ATOM   1578  C   ASN    57      48.100  30.807  21.225  1.00 32.06           C  
ATOM   1579  O   ASN    57      49.095  30.465  20.591  1.00 32.88           O  
ATOM   1580  CB  ASN    57      48.708  31.665  23.553  1.00 31.09           C  
ATOM   1581  CG  ASN    57      49.664  32.728  24.110  1.00 33.29           C  
ATOM   1582  OD1 ASN    57      50.701  33.008  23.514  1.00 36.72           O  
ATOM   1583  ND2 ASN    57      49.326  33.305  25.261  1.00 32.00           N  
ATOM   1584  N   VAL    58      46.936  30.166  21.120  1.00 32.60           N  
ATOM   1585  CA  VAL    58      46.760  29.045  20.194  1.00 32.08           C  
ATOM   1586  C   VAL    58      46.876  29.526  18.742  1.00 32.30           C  
ATOM   1587  O   VAL    58      47.545  28.890  17.934  1.00 32.10           O  
ATOM   1588  CB  VAL    58      45.419  28.287  20.433  1.00 31.98           C  
ATOM   1589  CG1 VAL    58      45.237  27.157  19.410  1.00 29.82           C  
ATOM   1590  CG2 VAL    58      45.366  27.727  21.861  1.00 28.52           C  
ATOM   1591  N   ILE    59      46.235  30.650  18.422  1.00 32.76           N  
ATOM   1592  CA  ILE    59      46.363  31.279  17.092  1.00 33.21           C  
ATOM   1593  C   ILE    59      47.797  31.770  16.842  1.00 33.87           C  
ATOM   1594  O   ILE    59      48.332  31.642  15.741  1.00 33.61           O  
ATOM   1595  CB  ILE    59      45.427  32.500  16.938  1.00 33.99           C  
ATOM   1596  CG1 ILE    59      43.950  32.095  17.083  1.00 33.69           C  
ATOM   1597  CG2 ILE    59      45.664  33.206  15.586  1.00 31.95           C  
ATOM   1598  CD1 ILE    59      43.006  33.284  17.176  1.00 32.20           C  
ATOM   1599  N   LYS    60      48.411  32.330  17.872  1.00 35.71           N  
ATOM   1600  CA  LYS    60      49.772  32.840  17.767  1.00 37.57           C  
ATOM   1601  C   LYS    60      50.764  31.721  17.441  1.00 38.24           C  
ATOM   1602  O   LYS    60      51.604  31.872  16.562  1.00 37.60           O  
ATOM   1603  CB  LYS    60      50.174  33.557  19.062  1.00 37.54           C  
ATOM   1604  CG  LYS    60      51.655  33.883  19.189  1.00 36.89           C  
ATOM   1605  CD  LYS    60      51.907  34.811  20.361  1.00 39.39           C  
ATOM   1606  CE  LYS    60      53.381  34.926  20.678  1.00 43.88           C  
ATOM   1607  NZ  LYS    60      53.698  36.138  21.480  1.00 45.53           N  
ATOM   1608  N   GLU    61      50.662  30.603  18.150  1.00 39.86           N  
ATOM   1609  CA  GLU    61      51.580  29.486  17.934  1.00 40.82           C  
ATOM   1610  C   GLU    61      51.197  28.632  16.722  1.00 41.21           C  
ATOM   1611  O   GLU    61      52.065  28.113  16.025  1.00 41.01           O  
ATOM   1612  CB  GLU    61      51.673  28.611  19.193  1.00 40.22           C  
ATOM   1613  CG  GLU    61      52.201  29.330  20.445  1.00 41.09           C  
ATOM   1614  CD  GLU    61      53.587  29.968  20.275  1.00 41.98           C  
ATOM   1615  OE1 GLU    61      54.314  29.626  19.319  1.00 43.56           O  
ATOM   1616  OE2 GLU    61      53.956  30.816  21.114  1.00 41.89           O  
ATOM   1617  N   GLY    62      49.896  28.506  16.472  1.00 42.51           N  
ATOM   1618  CA  GLY    62      49.378  27.596  15.455  1.00 43.05           C  
ATOM   1619  C   GLY    62      49.304  26.169  15.972  1.00 43.55           C  
ATOM   1620  O   GLY    62      48.994  25.252  15.216  1.00 44.20           O  
ATOM   1621  N   ASN    63      49.576  25.996  17.266  1.00 44.07           N  
ATOM   1622  CA  ASN    63      49.674  24.692  17.917  1.00 44.21           C  
ATOM   1623  C   ASN    63      48.667  24.579  19.044  1.00 44.05           C  
ATOM   1624  O   ASN    63      48.103  25.579  19.482  1.00 43.63           O  
ATOM   1625  CB  ASN    63      51.057  24.530  18.552  1.00 43.35           C  
ATOM   1626  CG  ASN    63      52.175  24.755  17.581  1.00 46.03           C  
ATOM   1627  OD1 ASN    63      52.015  24.563  16.380  1.00 56.39           O  
ATOM   1628  ND2 ASN    63      53.329  25.158  18.093  1.00 46.14           N  
ATOM   1629  N   ALA    64      48.497  23.354  19.541  1.00 44.06           N  
ATOM   1630  CA  ALA    64      47.735  23.100  20.759  1.00 43.65           C  
ATOM   1631  C   ALA    64      48.652  23.159  21.986  1.00 42.60           C  
ATOM   1632  O   ALA    64      48.215  22.878  23.100  1.00 42.66           O  
ATOM   1633  CB  ALA    64      47.047  21.750  20.674  1.00 44.16           C  
ATOM   1634  N   SER    65      49.913  23.548  21.778  1.00 41.62           N  
ATOM   1635  CA  SER    65      50.914  23.588  22.848  1.00 40.66           C  
ATOM   1636  C   SER    65      50.624  24.576  23.992  1.00 39.74           C  
ATOM   1637  O   SER    65      50.986  24.293  25.121  1.00 39.46           O  
ATOM   1638  CB  SER    65      52.332  23.802  22.273  1.00 39.86           C  
ATOM   1639  OG  SER    65      52.479  25.053  21.630  1.00 38.52           O  
ATOM   1640  N   PRO    66      49.983  25.731  23.718  1.00 39.50           N  
ATOM   1641  CA  PRO    66      49.632  26.610  24.848  1.00 39.62           C  
ATOM   1642  C   PRO    66      48.674  26.005  25.903  1.00 40.52           C  
ATOM   1643  O   PRO    66      48.529  26.577  26.989  1.00 40.07           O  
ATOM   1644  CB  PRO    66      48.999  27.830  24.163  1.00 39.89           C  
ATOM   1645  CG  PRO    66      49.525  27.792  22.756  1.00 39.12           C  
ATOM   1646  CD  PRO    66      49.599  26.337  22.428  1.00 39.03           C  
ATOM   1647  N   PHE    67      48.033  24.874  25.599  1.00 41.75           N  
ATOM   1648  CA  PHE    67      47.273  24.136  26.617  1.00 43.43           C  
ATOM   1649  C   PHE    67      48.212  23.489  27.643  1.00 44.65           C  
ATOM   1650  O   PHE    67      47.832  23.293  28.801  1.00 44.48           O  
ATOM   1651  CB  PHE    67      46.384  23.053  25.996  1.00 44.15           C  
ATOM   1652  CG  PHE    67      45.455  23.559  24.931  1.00 45.35           C  
ATOM   1653  CD1 PHE    67      44.694  24.703  25.134  1.00 48.97           C  
ATOM   1654  CD2 PHE    67      45.327  22.883  23.728  1.00 47.36           C  
ATOM   1655  CE1 PHE    67      43.834  25.171  24.148  1.00 47.77           C  
ATOM   1656  CE2 PHE    67      44.476  23.353  22.740  1.00 47.83           C  
ATOM   1657  CZ  PHE    67      43.728  24.495  22.955  1.00 44.88           C  
ATOM   1658  N   GLN    68      49.425  23.149  27.209  1.00 46.69           N  
ATOM   1659  CA  GLN    68      50.444  22.560  28.089  1.00 48.37           C  
ATOM   1660  C   GLN    68      50.999  23.583  29.073  1.00 50.08           C  
ATOM   1661  O   GLN    68      51.458  23.216  30.156  1.00 50.91           O  
ATOM   1662  CB  GLN    68      51.607  21.962  27.275  1.00 48.44           C  
ATOM   1663  CG  GLN    68      51.370  20.560  26.709  1.00 49.99           C  
ATOM   1664  CD  GLN    68      50.026  20.407  26.019  1.00 50.43           C  
ATOM   1665  OE1 GLN    68      48.982  20.371  26.673  1.00 50.63           O  
ATOM   1666  NE2 GLN    68      50.047  20.305  24.691  1.00 50.53           N  
ATOM   1667  N   ASN    69      50.974  24.859  28.688  1.00 51.88           N  
ATOM   1668  CA  ASN    69      51.449  25.938  29.552  1.00 53.28           C  
ATOM   1669  C   ASN    69      50.511  26.154  30.740  1.00 54.71           C  
ATOM   1670  O   ASN    69      49.505  26.850  30.618  1.00 54.91           O  
ATOM   1671  CB  ASN    69      51.588  27.240  28.752  1.00 53.14           C  
ATOM   1672  N   LYS    70      50.835  25.536  31.874  1.00 57.03           N  
ATOM   1673  CA  LYS    70      50.099  25.758  33.119  1.00 58.38           C  
ATOM   1674  C   LYS    70      50.589  27.059  33.750  1.00 59.82           C  
ATOM   1675  O   LYS    70      51.596  27.058  34.465  1.00 59.85           O  
ATOM   1676  CB  LYS    70      50.324  24.599  34.092  1.00 58.61           C  
ATOM   1677  N   GLN    71      49.889  28.161  33.473  1.00 61.09           N  
ATOM   1678  CA  GLN    71      50.291  29.486  33.963  1.00 62.37           C  
ATOM   1679  C   GLN    71      49.654  29.793  35.321  1.00 63.43           C  
ATOM   1680  O   GLN    71      48.464  30.126  35.397  1.00 64.18           O  
ATOM   1681  CB  GLN    71      49.910  30.572  32.952  1.00 62.69           C  
ATOM   1682  N   GLU    72      50.451  29.679  36.386  1.00 63.24           N  
ATOM   1683  CA  GLU    72      49.984  29.958  37.746  1.00 62.89           C  
ATOM   1684  C   GLU    72      49.973  31.469  38.008  1.00 62.36           C  
ATOM   1685  O   GLU    72      50.992  32.045  38.403  1.00 62.30           O  
ATOM   1686  CB  GLU    72      50.871  29.246  38.777  1.00 62.86           C  
ATOM   1687  N   GLU    73      48.824  32.106  37.772  1.00 60.95           N  
ATOM   1688  CA  GLU    73      48.670  33.540  38.035  1.00 59.65           C  
ATOM   1689  C   GLU    73      48.477  33.737  39.540  1.00 57.43           C  
ATOM   1690  O   GLU    73      47.552  33.173  40.130  1.00 57.80           O  
ATOM   1691  CB  GLU    73      47.484  34.123  37.250  1.00 60.09           C  
ATOM   1692  CG  GLU    73      47.401  35.662  37.243  1.00 60.77           C  
ATOM   1693  CD  GLU    73      48.532  36.354  36.463  1.00 62.91           C  
ATOM   1694  OE1 GLU    73      49.224  35.689  35.663  1.00 64.78           O  
ATOM   1695  OE2 GLU    73      48.720  37.577  36.645  1.00 61.24           O  
ATOM   1696  N   THR    74      49.361  34.526  40.149  1.00 54.02           N  
ATOM   1697  CA  THR    74      49.358  34.754  41.597  1.00 52.74           C  
ATOM   1698  C   THR    74      48.387  35.863  42.044  1.00 51.44           C  
ATOM   1699  O   THR    74      47.943  35.871  43.196  1.00 51.74           O  
ATOM   1700  CB  THR    74      50.775  35.105  42.101  1.00 52.41           C  
ATOM   1701  N   GLU    75      48.058  36.784  41.135  1.00 49.36           N  
ATOM   1702  CA  GLU    75      47.214  37.939  41.455  1.00 47.02           C  
ATOM   1703  C   GLU    75      45.759  37.533  41.711  1.00 45.84           C  
ATOM   1704  O   GLU    75      45.231  36.654  41.029  1.00 46.17           O  
ATOM   1705  CB  GLU    75      47.283  38.962  40.312  1.00 46.52           C  
ATOM   1706  CG  GLU    75      46.513  40.248  40.573  1.00 44.62           C  
ATOM   1707  CD  GLU    75      47.058  41.016  41.759  1.00 42.04           C  
ATOM   1708  OE1 GLU    75      48.292  41.233  41.800  1.00 33.54           O  
ATOM   1709  OE2 GLU    75      46.253  41.402  42.637  1.00 35.78           O  
ATOM   1710  N   THR    76      45.133  38.178  42.697  1.00 44.18           N  
ATOM   1711  CA  THR    76      43.737  37.915  43.069  1.00 42.84           C  
ATOM   1712  C   THR    76      42.803  39.105  42.845  1.00 41.12           C  
ATOM   1713  O   THR    76      41.591  38.923  42.736  1.00 41.75           O  
ATOM   1714  CB  THR    76      43.627  37.523  44.548  1.00 43.10           C  
ATOM   1715  OG1 THR    76      44.363  38.464  45.345  1.00 44.47           O  
ATOM   1716  CG2 THR    76      44.167  36.111  44.770  1.00 43.34           C  
ATOM   1717  N   ASP    77      43.351  40.318  42.805  1.00 38.64           N  
ATOM   1718  CA  ASP    77      42.547  41.494  42.522  1.00 36.40           C  
ATOM   1719  C   ASP    77      42.053  41.379  41.091  1.00 34.51           C  
ATOM   1720  O   ASP    77      42.855  41.330  40.155  1.00 32.72           O  
ATOM   1721  CB  ASP    77      43.351  42.785  42.726  1.00 36.29           C  
ATOM   1722  CG  ASP    77      42.471  44.032  42.705  1.00 36.98           C  
ATOM   1723  OD1 ASP    77      41.907  44.355  41.639  1.00 32.41           O  
ATOM   1724  OD2 ASP    77      42.349  44.695  43.757  1.00 42.30           O  
ATOM   1725  N   LEU    78      40.728  41.321  40.945  1.00 33.17           N  
ATOM   1726  CA  LEU    78      40.084  41.188  39.644  1.00 31.83           C  
ATOM   1727  C   LEU    78      40.447  42.312  38.690  1.00 30.92           C  
ATOM   1728  O   LEU    78      40.630  42.063  37.501  1.00 30.51           O  
ATOM   1729  CB  LEU    78      38.554  41.136  39.777  1.00 31.06           C  
ATOM   1730  CG  LEU    78      37.884  39.831  40.213  1.00 30.15           C  
ATOM   1731  CD1 LEU    78      36.382  39.991  40.079  1.00 28.75           C  
ATOM   1732  CD2 LEU    78      38.360  38.634  39.408  1.00 26.53           C  
ATOM   1733  N   ASN    79      40.528  43.540  39.205  1.00 31.00           N  
ATOM   1734  CA  ASN    79      40.795  44.709  38.361  1.00 31.40           C  
ATOM   1735  C   ASN    79      42.207  44.677  37.806  1.00 30.64           C  
ATOM   1736  O   ASN    79      42.430  45.047  36.659  1.00 32.32           O  
ATOM   1737  CB  ASN    79      40.519  46.014  39.113  1.00 30.97           C  
ATOM   1738  CG  ASN    79      39.047  46.191  39.445  1.00 32.77           C  
ATOM   1739  OD1 ASN    79      38.169  45.793  38.669  1.00 34.47           O  
ATOM   1740  ND2 ASN    79      38.767  46.792  40.597  1.00 31.40           N  
ATOM   1741  N   VAL    80      43.145  44.198  38.613  1.00 30.86           N  
ATOM   1742  CA  VAL    80      44.527  43.995  38.176  1.00 30.48           C  
ATOM   1743  C   VAL    80      44.626  42.802  37.208  1.00 30.68           C  
ATOM   1744  O   VAL    80      45.369  42.850  36.230  1.00 32.36           O  
ATOM   1745  CB  VAL    80      45.453  43.767  39.378  1.00 30.21           C  
ATOM   1746  CG1 VAL    80      46.886  43.546  38.914  1.00 28.13           C  
ATOM   1747  CG2 VAL    80      45.352  44.942  40.345  1.00 27.39           C  
ATOM   1748  N   LEU    81      43.884  41.731  37.480  1.00 30.58           N  
ATOM   1749  CA  LEU    81      43.817  40.603  36.546  1.00 30.81           C  
ATOM   1750  C   LEU    81      43.247  41.057  35.200  1.00 30.95           C  
ATOM   1751  O   LEU    81      43.794  40.737  34.148  1.00 31.51           O  
ATOM   1752  CB  LEU    81      42.979  39.451  37.110  1.00 30.49           C  
ATOM   1753  CG  LEU    81      43.664  38.568  38.154  1.00 32.45           C  
ATOM   1754  CD1 LEU    81      42.657  37.683  38.888  1.00 28.60           C  
ATOM   1755  CD2 LEU    81      44.748  37.729  37.503  1.00 32.31           C  
ATOM   1756  N   ALA    82      42.162  41.827  35.243  1.00 31.30           N  
ATOM   1757  CA  ALA    82      41.511  42.328  34.029  1.00 29.87           C  
ATOM   1758  C   ALA    82      42.455  43.178  33.184  1.00 29.55           C  
ATOM   1759  O   ALA    82      42.555  42.976  31.975  1.00 29.00           O  
ATOM   1760  CB  ALA    82      40.252  43.108  34.382  1.00 27.98           C  
ATOM   1761  N   LYS    83      43.145  44.114  33.827  1.00 30.62           N  
ATOM   1762  CA  LYS    83      44.095  45.003  33.147  1.00 32.82           C  
ATOM   1763  C   LYS    83      45.278  44.247  32.545  1.00 31.38           C  
ATOM   1764  O   LYS    83      45.603  44.429  31.383  1.00 31.61           O  
ATOM   1765  CB  LYS    83      44.612  46.060  34.122  1.00 33.23           C  
ATOM   1766  CG  LYS    83      45.524  47.089  33.488  1.00 35.47           C  
ATOM   1767  CD  LYS    83      45.840  48.216  34.451  1.00 36.43           C  
ATOM   1768  CE  LYS    83      46.837  49.196  33.841  1.00 42.15           C  
ATOM   1769  NZ  LYS    83      47.235  50.260  34.808  1.00 48.16           N  
ATOM   1770  N   THR    84      45.915  43.410  33.352  1.00 31.31           N  
ATOM   1771  CA  THR    84      47.066  42.615  32.918  1.00 31.31           C  
ATOM   1772  C   THR    84      46.767  41.681  31.742  1.00 30.31           C  
ATOM   1773  O   THR    84      47.511  41.650  30.762  1.00 29.48           O  
ATOM   1774  CB  THR    84      47.595  41.795  34.095  1.00 30.96           C  
ATOM   1775  OG1 THR    84      48.174  42.693  35.047  1.00 32.33           O  
ATOM   1776  CG2 THR    84      48.648  40.779  33.637  1.00 34.24           C  
ATOM   1777  N   TYR    85      45.676  40.927  31.847  1.00 30.38           N  
ATOM   1778  CA  TYR    85      45.284  39.982  30.797  1.00 30.35           C  
ATOM   1779  C   TYR    85      44.820  40.665  29.510  1.00 29.76           C  
ATOM   1780  O   TYR    85      44.976  40.115  28.423  1.00 29.50           O  
ATOM   1781  CB  TYR    85      44.195  39.038  31.306  1.00 31.62           C  
ATOM   1782  CG  TYR    85      44.726  37.797  31.993  1.00 31.20           C  
ATOM   1783  CD1 TYR    85      45.237  36.746  31.245  1.00 32.21           C  
ATOM   1784  CD2 TYR    85      44.680  37.656  33.381  1.00 32.86           C  
ATOM   1785  CE1 TYR    85      45.701  35.590  31.850  1.00 32.84           C  
ATOM   1786  CE2 TYR    85      45.147  36.493  34.003  1.00 32.36           C  
ATOM   1787  CZ  TYR    85      45.657  35.467  33.229  1.00 33.24           C  
ATOM   1788  OH  TYR    85      46.137  34.309  33.811  1.00 34.89           O  
ATOM   1789  N   THR    86      44.235  41.848  29.638  1.00 31.05           N  
ATOM   1790  CA  THR    86      43.815  42.641  28.486  1.00 31.05           C  
ATOM   1791  C   THR    86      45.045  43.122  27.733  1.00 32.15           C  
ATOM   1792  O   THR    86      45.109  42.994  26.512  1.00 32.75           O  
ATOM   1793  CB  THR    86      42.918  43.820  28.928  1.00 30.81           C  
ATOM   1794  OG1 THR    86      41.726  43.284  29.508  1.00 29.76           O  
ATOM   1795  CG2 THR    86      42.532  44.732  27.760  1.00 26.40           C  
ATOM   1796  N   GLU    87      46.025  43.652  28.471  1.00 32.42           N  
ATOM   1797  CA  GLU    87      47.300  44.084  27.899  1.00 33.13           C  
ATOM   1798  C   GLU    87      48.047  42.928  27.211  1.00 31.43           C  
ATOM   1799  O   GLU    87      48.576  43.091  26.114  1.00 30.84           O  
ATOM   1800  CB  GLU    87      48.193  44.737  28.977  1.00 33.57           C  
ATOM   1801  CG  GLU    87      47.674  46.098  29.487  1.00 36.24           C  
ATOM   1802  CD  GLU    87      48.430  46.649  30.705  1.00 36.39           C  
ATOM   1803  OE1 GLU    87      49.213  45.898  31.339  1.00 42.87           O  
ATOM   1804  OE2 GLU    87      48.224  47.844  31.039  1.00 41.68           O  
ATOM   1805  N   LYS    88      48.086  41.769  27.857  1.00 30.05           N  
ATOM   1806  CA  LYS    88      48.724  40.586  27.275  1.00 31.07           C  
ATOM   1807  C   LYS    88      48.015  40.085  26.007  1.00 29.92           C  
ATOM   1808  O   LYS    88      48.669  39.628  25.061  1.00 30.19           O  
ATOM   1809  CB  LYS    88      48.768  39.444  28.295  1.00 31.28           C  
ATOM   1810  CG  LYS    88      49.807  39.588  29.405  1.00 32.74           C  
ATOM   1811  CD  LYS    88      49.487  38.619  30.542  1.00 34.44           C  
ATOM   1812  CE  LYS    88      50.726  38.125  31.283  1.00 39.86           C  
ATOM   1813  NZ  LYS    88      51.268  39.116  32.264  1.00 38.26           N  
ATOM   1814  N   THR    89      46.686  40.150  26.003  1.00 28.30           N  
ATOM   1815  CA  THR    89      45.907  39.659  24.876  1.00 26.91           C  
ATOM   1816  C   THR    89      45.994  40.627  23.697  1.00 26.04           C  
ATOM   1817  O   THR    89      46.155  40.197  22.563  1.00 25.57           O  
ATOM   1818  CB  THR    89      44.432  39.370  25.276  1.00 26.83           C  
ATOM   1819  OG1 THR    89      44.402  38.387  26.321  1.00 26.62           O  
ATOM   1820  CG2 THR    89      43.649  38.837  24.091  1.00 21.94           C  
ATOM   1821  N   VAL    90      45.916  41.928  23.970  1.00 25.73           N  
ATOM   1822  CA  VAL    90      46.100  42.954  22.935  1.00 24.97           C  
ATOM   1823  C   VAL    90      47.491  42.846  22.274  1.00 25.21           C  
ATOM   1824  O   VAL    90      47.625  42.875  21.044  1.00 24.21           O  
ATOM   1825  CB  VAL    90      45.922  44.368  23.530  1.00 26.15           C  
ATOM   1826  CG1 VAL    90      46.342  45.465  22.513  1.00 25.78           C  
ATOM   1827  CG2 VAL    90      44.477  44.564  24.014  1.00 24.53           C  
ATOM   1828  N   ALA    91      48.522  42.690  23.092  1.00 24.60           N  
ATOM   1829  CA  ALA    91      49.883  42.534  22.583  1.00 25.64           C  
ATOM   1830  C   ALA    91      49.993  41.348  21.616  1.00 27.64           C  
ATOM   1831  O   ALA    91      50.684  41.436  20.600  1.00 29.22           O  
ATOM   1832  CB  ALA    91      50.884  42.412  23.746  1.00 24.73           C  
ATOM   1833  N   ILE    92      49.284  40.255  21.896  1.00 29.04           N  
ATOM   1834  CA  ILE    92      49.251  39.131  20.956  1.00 29.11           C  
ATOM   1835  C   ILE    92      48.443  39.481  19.694  1.00 30.76           C  
ATOM   1836  O   ILE    92      48.935  39.307  18.568  1.00 31.05           O  
ATOM   1837  CB  ILE    92      48.682  37.846  21.579  1.00 29.24           C  
ATOM   1838  CG1 ILE    92      49.595  37.340  22.711  1.00 30.86           C  
ATOM   1839  CG2 ILE    92      48.552  36.775  20.506  1.00 23.58           C  
ATOM   1840  CD1 ILE    92      49.028  36.148  23.491  1.00 28.37           C  
ATOM   1841  N   LEU    93      47.221  39.983  19.890  1.00 30.68           N  
ATOM   1842  CA  LEU    93      46.329  40.312  18.782  1.00 31.19           C  
ATOM   1843  C   LEU    93      46.942  41.317  17.798  1.00 33.19           C  
ATOM   1844  O   LEU    93      46.804  41.152  16.584  1.00 32.19           O  
ATOM   1845  CB  LEU    93      44.981  40.836  19.305  1.00 30.38           C  
ATOM   1846  CG  LEU    93      44.072  39.867  20.066  1.00 28.57           C  
ATOM   1847  CD1 LEU    93      42.719  40.515  20.315  1.00 27.89           C  
ATOM   1848  CD2 LEU    93      43.904  38.560  19.325  1.00 24.19           C  
ATOM   1849  N   GLU    94      47.626  42.337  18.330  1.00 35.21           N  
ATOM   1850  CA  GLU    94      48.307  43.369  17.523  1.00 37.43           C  
ATOM   1851  C   GLU    94      49.279  42.824  16.477  1.00 38.02           C  
ATOM   1852  O   GLU    94      49.540  43.469  15.471  1.00 39.24           O  
ATOM   1853  CB  GLU    94      49.157  44.276  18.417  1.00 37.45           C  
ATOM   1854  CG  GLU    94      48.437  45.346  19.215  1.00 39.62           C  
ATOM   1855  CD  GLU    94      49.393  46.060  20.179  1.00 40.91           C  
ATOM   1856  OE1 GLU    94      50.569  45.626  20.285  1.00 44.33           O  
ATOM   1857  OE2 GLU    94      48.981  47.052  20.823  1.00 44.87           O  
ATOM   1858  N   GLN    95      49.868  41.672  16.757  1.00 38.62           N  
ATOM   1859  CA  GLN    95      50.925  41.131  15.921  1.00 39.16           C  
ATOM   1860  C   GLN    95      50.427  40.055  14.970  1.00 39.45           C  
ATOM   1861  O   GLN    95      51.135  39.700  14.038  1.00 40.62           O  
ATOM   1862  CB  GLN    95      52.020  40.554  16.816  1.00 40.08           C  
ATOM   1863  CG  GLN    95      52.579  41.550  17.832  1.00 42.36           C  
ATOM   1864  CD  GLN    95      53.520  42.551  17.202  1.00 46.73           C  
ATOM   1865  OE1 GLN    95      53.167  43.716  16.994  1.00 45.61           O  
ATOM   1866  NE2 GLN    95      54.729  42.096  16.877  1.00 50.68           N  
ATOM   1867  N   LEU    96      49.215  39.540  15.194  1.00 39.81           N  
ATOM   1868  CA  LEU    96      48.690  38.454  14.376  1.00 39.64           C  
ATOM   1869  C   LEU    96      48.600  38.845  12.906  1.00 40.14           C  
ATOM   1870  O   LEU    96      47.997  39.860  12.560  1.00 41.09           O  
ATOM   1871  CB  LEU    96      47.323  37.991  14.884  1.00 40.07           C  
ATOM   1872  CG  LEU    96      47.325  37.192  16.188  1.00 36.48           C  
ATOM   1873  CD1 LEU    96      45.897  36.863  16.590  1.00 34.41           C  
ATOM   1874  CD2 LEU    96      48.160  35.932  16.053  1.00 34.32           C  
ATOM   1875  N   THR    97      49.214  38.020  12.060  1.00 40.77           N  
ATOM   1876  CA  THR    97      49.279  38.234  10.615  1.00 40.51           C  
ATOM   1877  C   THR    97      48.149  37.480   9.901  1.00 40.99           C  
ATOM   1878  O   THR    97      47.577  36.530  10.442  1.00 40.42           O  
ATOM   1879  CB  THR    97      50.644  37.755  10.051  1.00 40.10           C  
ATOM   1880  OG1 THR    97      50.761  36.336  10.198  1.00 40.62           O  
ATOM   1881  CG2 THR    97      51.796  38.419  10.788  1.00 38.60           C  
ATOM   1882  N   GLU    98      47.826  37.916   8.688  1.00 41.70           N  
ATOM   1883  CA  GLU    98      46.781  37.269   7.889  1.00 42.96           C  
ATOM   1884  C   GLU    98      47.103  35.792   7.645  1.00 42.45           C  
ATOM   1885  O   GLU    98      46.204  34.969   7.536  1.00 42.13           O  
ATOM   1886  CB  GLU    98      46.577  38.023   6.565  1.00 43.80           C  
ATOM   1887  CG  GLU    98      45.735  39.297   6.722  1.00 46.73           C  
ATOM   1888  CD  GLU    98      44.267  38.992   6.996  1.00 51.55           C  
ATOM   1889  OE1 GLU    98      43.648  38.291   6.166  1.00 53.83           O  
ATOM   1890  OE2 GLU    98      43.731  39.443   8.037  1.00 53.34           O  
ATOM   1891  N   GLU    99      48.396  35.478   7.588  1.00 42.79           N  
ATOM   1892  CA  GLU    99      48.895  34.105   7.480  1.00 43.72           C  
ATOM   1893  C   GLU    99      48.494  33.277   8.694  1.00 41.44           C  
ATOM   1894  O   GLU    99      48.041  32.136   8.555  1.00 40.91           O  
ATOM   1895  CB  GLU    99      50.427  34.128   7.368  1.00 44.27           C  
ATOM   1896  CG  GLU    99      51.118  32.763   7.344  1.00 47.94           C  
ATOM   1897  CD  GLU    99      52.606  32.854   7.693  1.00 48.92           C  
ATOM   1898  OE1 GLU    99      52.937  33.477   8.732  1.00 61.99           O  
ATOM   1899  OE2 GLU    99      53.440  32.296   6.939  1.00 52.94           O  
ATOM   1900  N   GLN   100      48.693  33.847   9.883  1.00 39.56           N  
ATOM   1901  CA  GLN   100      48.308  33.198  11.140  1.00 37.57           C  
ATOM   1902  C   GLN   100      46.789  33.034  11.271  1.00 35.88           C  
ATOM   1903  O   GLN   100      46.315  32.075  11.865  1.00 34.56           O  
ATOM   1904  CB  GLN   100      48.865  33.972  12.335  1.00 37.95           C  
ATOM   1905  CG  GLN   100      50.361  33.753  12.560  1.00 35.36           C  
ATOM   1906  CD  GLN   100      50.928  34.653  13.650  1.00 37.02           C  
ATOM   1907  OE1 GLN   100      50.688  35.861  13.655  1.00 35.51           O  
ATOM   1908  NE2 GLN   100      51.688  34.064  14.577  1.00 28.77           N  
ATOM   1909  N   LEU   101      46.041  33.973  10.700  1.00 36.17           N  
ATOM   1910  CA  LEU   101      44.583  33.911  10.672  1.00 36.04           C  
ATOM   1911  C   LEU   101      44.073  32.913   9.633  1.00 37.42           C  
ATOM   1912  O   LEU   101      43.082  32.221   9.870  1.00 38.35           O  
ATOM   1913  CB  LEU   101      44.009  35.305  10.394  1.00 35.43           C  
ATOM   1914  CG  LEU   101      44.231  36.320  11.524  1.00 34.17           C  
ATOM   1915  CD1 LEU   101      44.014  37.731  11.053  1.00 35.54           C  
ATOM   1916  CD2 LEU   101      43.314  36.006  12.707  1.00 29.97           C  
ATOM   1917  N   ASP   102      44.753  32.842   8.488  1.00 38.87           N  
ATOM   1918  CA  ASP   102      44.334  31.980   7.378  1.00 39.41           C  
ATOM   1919  C   ASP   102      44.687  30.510   7.582  1.00 39.52           C  
ATOM   1920  O   ASP   102      43.960  29.630   7.119  1.00 40.06           O  
ATOM   1921  CB  ASP   102      44.945  32.476   6.060  1.00 40.18           C  
ATOM   1922  CG  ASP   102      44.274  33.742   5.538  1.00 41.84           C  
ATOM   1923  OD1 ASP   102      43.098  33.969   5.877  1.00 44.15           O  
ATOM   1924  OD2 ASP   102      44.916  34.501   4.776  1.00 44.89           O  
ATOM   1925  N   ARG   103      45.780  30.242   8.288  1.00 39.77           N  
ATOM   1926  CA  ARG   103      46.285  28.875   8.425  1.00 40.80           C  
ATOM   1927  C   ARG   103      45.443  27.996   9.334  1.00 41.55           C  
ATOM   1928  O   ARG   103      44.794  28.468  10.260  1.00 41.57           O  
ATOM   1929  CB  ARG   103      47.731  28.872   8.931  1.00 40.90           C  
ATOM   1930  CG  ARG   103      47.888  29.243  10.392  1.00 42.29           C  
ATOM   1931  CD  ARG   103      49.339  29.471  10.724  1.00 44.86           C  
ATOM   1932  NE  ARG   103      49.550  29.752  12.139  1.00 45.75           N  
ATOM   1933  CZ  ARG   103      50.715  30.125  12.661  1.00 47.88           C  
ATOM   1934  NH1 ARG   103      51.797  30.276  11.895  1.00 46.92           N  
ATOM   1935  NH2 ARG   103      50.802  30.357  13.962  1.00 48.77           N  
ATOM   1936  N   GLU   104      45.500  26.700   9.059  1.00 42.30           N  
ATOM   1937  CA  GLU   104      44.841  25.683   9.859  1.00 42.85           C  
ATOM   1938  C   GLU   104      45.654  25.353  11.112  1.00 41.15           C  
ATOM   1939  O   GLU   104      46.859  25.119  11.035  1.00 40.82           O  
ATOM   1940  CB  GLU   104      44.662  24.412   9.025  1.00 43.55           C  
ATOM   1941  CG  GLU   104      43.506  23.559   9.459  1.00 48.29           C  
ATOM   1942  CD  GLU   104      42.933  22.766   8.320  1.00 54.58           C  
ATOM   1943  OE1 GLU   104      43.648  21.883   7.807  1.00 57.58           O  
ATOM   1944  OE2 GLU   104      41.772  23.036   7.941  1.00 58.33           O  
ATOM   1945  N   ILE   105      44.980  25.348  12.258  1.00 40.26           N  
ATOM   1946  CA  ILE   105      45.561  24.903  13.517  1.00 39.85           C  
ATOM   1947  C   ILE   105      45.102  23.459  13.741  1.00 40.87           C  
ATOM   1948  O   ILE   105      43.896  23.195  13.806  1.00 38.41           O  
ATOM   1949  CB  ILE   105      45.100  25.787  14.698  1.00 39.56           C  
ATOM   1950  CG1 ILE   105      45.389  27.263  14.410  1.00 41.36           C  
ATOM   1951  CG2 ILE   105      45.783  25.371  15.987  1.00 36.65           C  
ATOM   1952  CD1 ILE   105      44.838  28.207  15.451  1.00 38.91           C  
ATOM   1953  N   ASP   106      46.055  22.530  13.838  1.00 43.16           N  
ATOM   1954  CA  ASP   106      45.735  21.110  14.079  1.00 45.33           C  
ATOM   1955  C   ASP   106      45.508  20.819  15.575  1.00 46.30           C  
ATOM   1956  O   ASP   106      46.472  20.721  16.343  1.00 47.07           O  
ATOM   1957  CB  ASP   106      46.851  20.206  13.529  1.00 45.75           C  
ATOM   1958  CG  ASP   106      46.547  18.715  13.689  1.00 48.90           C  
ATOM   1959  OD1 ASP   106      45.436  18.361  14.159  1.00 54.25           O  
ATOM   1960  OD2 ASP   106      47.426  17.896  13.340  1.00 48.22           O  
ATOM   1961  N   LEU   107      44.242  20.665  15.974  1.00 47.64           N  
ATOM   1962  CA  LEU   107      43.881  20.387  17.375  1.00 48.79           C  
ATOM   1963  C   LEU   107      43.225  19.004  17.581  1.00 49.78           C  
ATOM   1964  O   LEU   107      42.345  18.605  16.814  1.00 51.17           O  
ATOM   1965  CB  LEU   107      42.946  21.482  17.904  1.00 48.93           C  
ATOM   1966  CG  LEU   107      43.479  22.915  17.843  1.00 48.72           C  
ATOM   1967  CD1 LEU   107      42.485  23.893  18.457  1.00 47.04           C  
ATOM   1968  CD2 LEU   107      44.823  23.024  18.539  1.00 50.50           C  
ATOM   1969  N   THR   108      43.654  18.293  18.630  1.00 49.87           N  
ATOM   1970  CA  THR   108      43.136  16.954  18.974  1.00 48.10           C  
ATOM   1971  C   THR   108      41.608  16.879  18.933  1.00 48.72           C  
ATOM   1972  O   THR   108      41.034  16.018  18.261  1.00 48.58           O  
ATOM   1973  CB  THR   108      43.602  16.500  20.395  1.00 48.19           C  
ATOM   1974  OG1 THR   108      43.218  17.476  21.378  1.00 40.35           O  
ATOM   1975  CG2 THR   108      45.114  16.291  20.439  1.00 45.16           C  
ATOM   1976  N   LYS   114      40.560  20.285  13.549  1.00 48.83           N  
ATOM   1977  CA  LYS   114      41.339  21.284  12.829  1.00 47.35           C  
ATOM   1978  C   LYS   114      40.493  22.541  12.660  1.00 45.69           C  
ATOM   1979  O   LYS   114      39.291  22.459  12.389  1.00 45.34           O  
ATOM   1980  CB  LYS   114      41.802  20.739  11.475  1.00 46.66           C  
ATOM   1981  N   VAL   115      41.122  23.699  12.841  1.00 42.98           N  
ATOM   1982  CA  VAL   115      40.424  24.983  12.796  1.00 40.69           C  
ATOM   1983  C   VAL   115      41.403  26.064  12.356  1.00 37.96           C  
ATOM   1984  O   VAL   115      42.580  26.010  12.700  1.00 37.13           O  
ATOM   1985  CB  VAL   115      39.827  25.330  14.188  1.00 41.29           C  
ATOM   1986  CG1 VAL   115      40.938  25.423  15.230  1.00 41.11           C  
ATOM   1987  CG2 VAL   115      39.014  26.625  14.141  1.00 41.31           C  
ATOM   1988  N   THR   116      40.924  27.018  11.565  1.00 35.83           N  
ATOM   1989  CA  THR   116      41.747  28.147  11.129  1.00 34.25           C  
ATOM   1990  C   THR   116      41.888  29.156  12.249  1.00 34.16           C  
ATOM   1991  O   THR   116      40.982  29.294  13.064  1.00 34.64           O  
ATOM   1992  CB  THR   116      41.095  28.887   9.978  1.00 34.35           C  
ATOM   1993  OG1 THR   116      39.768  29.268  10.376  1.00 33.55           O  
ATOM   1994  CG2 THR   116      41.045  28.007   8.736  1.00 26.14           C  
ATOM   1995  N   GLY   117      43.000  29.883  12.275  1.00 33.53           N  
ATOM   1996  CA  GLY   117      43.191  30.940  13.265  1.00 32.87           C  
ATOM   1997  C   GLY   117      41.993  31.880  13.316  1.00 32.75           C  
ATOM   1998  O   GLY   117      41.549  32.261  14.400  1.00 32.20           O  
ATOM   1999  N   ARG   118      41.468  32.232  12.139  1.00 33.22           N  
ATOM   2000  CA  ARG   118      40.315  33.129  12.006  1.00 34.94           C  
ATOM   2001  C   ARG   118      39.071  32.565  12.685  1.00 33.27           C  
ATOM   2002  O   ARG   118      38.391  33.268  13.432  1.00 34.97           O  
ATOM   2003  CB  ARG   118      40.008  33.398  10.528  1.00 34.63           C  
ATOM   2004  CG  ARG   118      39.075  34.578  10.287  1.00 38.04           C  
ATOM   2005  CD  ARG   118      38.912  34.917   8.796  1.00 41.22           C  
ATOM   2006  NE  ARG   118      40.200  35.077   8.112  1.00 48.85           N  
ATOM   2007  CZ  ARG   118      41.000  36.138   8.220  1.00 48.59           C  
ATOM   2008  NH1 ARG   118      40.677  37.176   8.988  1.00 49.41           N  
ATOM   2009  NH2 ARG   118      42.145  36.158   7.557  1.00 48.99           N  
ATOM   2010  N   ALA   119      38.770  31.298  12.427  1.00 30.92           N  
ATOM   2011  CA  ALA   119      37.577  30.682  12.994  1.00 29.20           C  
ATOM   2012  C   ALA   119      37.694  30.522  14.527  1.00 28.24           C  
ATOM   2013  O   ALA   119      36.694  30.620  15.245  1.00 27.02           O  
ATOM   2014  CB  ALA   119      37.300  29.361  12.328  1.00 29.59           C  
ATOM   2015  N   LEU   120      38.907  30.297  15.027  1.00 26.93           N  
ATOM   2016  CA  LEU   120      39.125  30.231  16.467  1.00 28.00           C  
ATOM   2017  C   LEU   120      39.018  31.640  17.102  1.00 27.86           C  
ATOM   2018  O   LEU   120      38.633  31.771  18.257  1.00 27.73           O  
ATOM   2019  CB  LEU   120      40.488  29.602  16.779  1.00 29.16           C  
ATOM   2020  CG  LEU   120      40.699  29.065  18.198  1.00 29.75           C  
ATOM   2021  CD1 LEU   120      39.857  27.808  18.433  1.00 35.18           C  
ATOM   2022  CD2 LEU   120      42.165  28.759  18.433  1.00 29.74           C  
ATOM   2023  N   LEU   121      39.359  32.683  16.346  1.00 28.09           N  
ATOM   2024  CA  LEU   121      39.228  34.057  16.832  1.00 27.44           C  
ATOM   2025  C   LEU   121      37.750  34.434  17.007  1.00 28.11           C  
ATOM   2026  O   LEU   121      37.378  35.044  18.004  1.00 28.73           O  
ATOM   2027  CB  LEU   121      39.920  35.041  15.889  1.00 26.16           C  
ATOM   2028  CG  LEU   121      39.829  36.523  16.266  1.00 27.90           C  
ATOM   2029  CD1 LEU   121      40.567  36.780  17.561  1.00 23.80           C  
ATOM   2030  CD2 LEU   121      40.358  37.411  15.134  1.00 27.70           C  
ATOM   2031  N   GLN   122      36.917  34.057  16.039  1.00 28.54           N  
ATOM   2032  CA  GLN   122      35.481  34.314  16.107  1.00 30.48           C  
ATOM   2033  C   GLN   122      34.866  33.560  17.293  1.00 30.29           C  
ATOM   2034  O   GLN   122      33.977  34.061  17.983  1.00 30.33           O  
ATOM   2035  CB  GLN   122      34.788  33.907  14.790  1.00 30.73           C  
ATOM   2036  CG  GLN   122      33.269  33.730  14.930  1.00 34.32           C  
ATOM   2037  CD  GLN   122      32.527  33.691  13.616  1.00 33.25           C  
ATOM   2038  OE1 GLN   122      32.635  34.605  12.807  1.00 42.39           O  
ATOM   2039  NE2 GLN   122      31.721  32.648  13.419  1.00 35.24           N  
ATOM   2040  N   LEU   123      35.343  32.341  17.495  1.00 29.79           N  
ATOM   2041  CA  LEU   123      34.918  31.500  18.594  1.00 30.76           C  
ATOM   2042  C   LEU   123      35.297  32.158  19.938  1.00 30.05           C  
ATOM   2043  O   LEU   123      34.511  32.159  20.881  1.00 28.56           O  
ATOM   2044  CB  LEU   123      35.581  30.124  18.426  1.00 32.64           C  
ATOM   2045  CG  LEU   123      35.088  28.918  19.208  1.00 36.41           C  
ATOM   2046  CD1 LEU   123      35.493  27.647  18.473  1.00 37.74           C  
ATOM   2047  CD2 LEU   123      35.638  28.950  20.633  1.00 37.75           C  
ATOM   2048  N   ALA   124      36.509  32.710  20.008  1.00 29.00           N  
ATOM   2049  CA  ALA   124      36.979  33.433  21.183  1.00 27.92           C  
ATOM   2050  C   ALA   124      36.140  34.689  21.458  1.00 27.85           C  
ATOM   2051  O   ALA   124      35.857  35.030  22.619  1.00 27.75           O  
ATOM   2052  CB  ALA   124      38.437  33.815  20.996  1.00 27.52           C  
ATOM   2053  N   MET   125      35.737  35.368  20.384  1.00 26.51           N  
ATOM   2054  CA  MET   125      34.935  36.579  20.487  1.00 24.50           C  
ATOM   2055  C   MET   125      33.523  36.293  20.949  1.00 23.15           C  
ATOM   2056  O   MET   125      32.950  37.063  21.705  1.00 23.24           O  
ATOM   2057  CB  MET   125      34.872  37.308  19.138  1.00 23.98           C  
ATOM   2058  CG  MET   125      36.151  38.017  18.740  1.00 24.55           C  
ATOM   2059  SD  MET   125      36.568  39.523  19.855  0.75 19.69          SE  
ATOM   2060  CE  MET   125      34.822  40.421  19.829  1.00 27.99           C  
ATOM   2061  N   GLU   126      32.949  35.198  20.472  1.00 22.92           N  
ATOM   2062  CA  GLU   126      31.589  34.833  20.863  1.00 22.67           C  
ATOM   2063  C   GLU   126      31.542  34.327  22.296  1.00 23.28           C  
ATOM   2064  O   GLU   126      30.535  34.500  22.995  1.00 24.32           O  
ATOM   2065  CB  GLU   126      31.017  33.797  19.905  1.00 22.12           C  
ATOM   2066  CG  GLU   126      30.912  34.295  18.466  1.00 19.97           C  
ATOM   2067  CD  GLU   126      30.242  33.303  17.552  1.00 21.02           C  
ATOM   2068  OE1 GLU   126      29.901  32.187  18.004  1.00 25.67           O  
ATOM   2069  OE2 GLU   126      30.029  33.658  16.382  1.00 23.17           O  
ATOM   2070  N   HIS   127      32.637  33.714  22.727  1.00 24.65           N  
ATOM   2071  CA  HIS   127      32.783  33.226  24.099  1.00 25.24           C  
ATOM   2072  C   HIS   127      32.844  34.408  25.069  1.00 24.32           C  
ATOM   2073  O   HIS   127      32.184  34.415  26.118  1.00 24.41           O  
ATOM   2074  CB  HIS   127      34.050  32.389  24.183  1.00 26.17           C  
ATOM   2075  CG  HIS   127      34.235  31.687  25.484  1.00 31.32           C  
ATOM   2076  ND1 HIS   127      33.450  30.626  25.876  1.00 38.61           N  
ATOM   2077  CD2 HIS   127      35.141  31.872  26.470  1.00 36.97           C  
ATOM   2078  CE1 HIS   127      33.861  30.195  27.054  1.00 39.40           C  
ATOM   2079  NE2 HIS   127      34.881  30.938  27.438  1.00 37.60           N  
ATOM   2080  N   GLU   128      33.625  35.417  24.699  1.00 23.98           N  
ATOM   2081  CA  GLU   128      33.678  36.673  25.445  1.00 22.90           C  
ATOM   2082  C   GLU   128      32.285  37.287  25.550  1.00 21.15           C  
ATOM   2083  O   GLU   128      31.845  37.655  26.629  1.00 19.73           O  
ATOM   2084  CB  GLU   128      34.610  37.659  24.747  1.00 22.49           C  
ATOM   2085  CG  GLU   128      34.708  39.049  25.408  1.00 27.83           C  
ATOM   2086  CD  GLU   128      35.846  39.181  26.415  1.00 28.43           C  
ATOM   2087  OE1 GLU   128      36.726  38.301  26.447  1.00 27.93           O  
ATOM   2088  OE2 GLU   128      35.860  40.190  27.156  1.00 30.92           O  
ATOM   2089  N   ILE   129      31.613  37.390  24.410  1.00 20.76           N  
ATOM   2090  CA  ILE   129      30.320  38.058  24.320  1.00 20.58           C  
ATOM   2091  C   ILE   129      29.281  37.312  25.140  1.00 21.24           C  
ATOM   2092  O   ILE   129      28.513  37.931  25.863  1.00 23.67           O  
ATOM   2093  CB  ILE   129      29.858  38.233  22.840  1.00 19.95           C  
ATOM   2094  CG1 ILE   129      30.767  39.241  22.133  1.00 20.52           C  
ATOM   2095  CG2 ILE   129      28.411  38.718  22.786  1.00 19.35           C  
ATOM   2096  CD1 ILE   129      30.746  39.177  20.613  1.00 19.09           C  
ATOM   2097  N   HIS   130      29.288  35.985  25.048  1.00 21.33           N  
ATOM   2098  CA  HIS   130      28.430  35.139  25.878  1.00 19.82           C  
ATOM   2099  C   HIS   130      28.572  35.420  27.373  1.00 20.82           C  
ATOM   2100  O   HIS   130      27.583  35.721  28.048  1.00 20.66           O  
ATOM   2101  CB  HIS   130      28.727  33.658  25.615  1.00 18.93           C  
ATOM   2102  CG  HIS   130      28.027  32.732  26.553  1.00 15.45           C  
ATOM   2103  ND1 HIS   130      26.658  32.550  26.535  1.00 14.36           N  
ATOM   2104  CD2 HIS   130      28.503  31.936  27.536  1.00 13.49           C  
ATOM   2105  CE1 HIS   130      26.323  31.696  27.484  1.00 15.06           C  
ATOM   2106  NE2 HIS   130      27.423  31.317  28.111  1.00 16.03           N  
ATOM   2107  N   HIS   131      29.799  35.303  27.882  1.00 21.96           N  
ATOM   2108  CA  HIS   131      30.080  35.424  29.318  1.00 21.31           C  
ATOM   2109  C   HIS   131      29.957  36.868  29.852  1.00 22.10           C  
ATOM   2110  O   HIS   131      29.656  37.088  31.034  1.00 20.92           O  
ATOM   2111  CB  HIS   131      31.461  34.839  29.643  1.00 21.24           C  
ATOM   2112  CG  HIS   131      31.522  33.343  29.551  1.00 22.99           C  
ATOM   2113  ND1 HIS   131      30.750  32.516  30.340  1.00 25.40           N  
ATOM   2114  CD2 HIS   131      32.274  32.525  28.776  1.00 23.84           C  
ATOM   2115  CE1 HIS   131      31.012  31.255  30.044  1.00 25.83           C  
ATOM   2116  NE2 HIS   131      31.936  31.233  29.101  1.00 26.08           N  
ATOM   2117  N   LYS   132      30.195  37.854  28.993  1.00 23.34           N  
ATOM   2118  CA  LYS   132      29.890  39.237  29.349  1.00 23.59           C  
ATOM   2119  C   LYS   132      28.368  39.353  29.502  1.00 24.59           C  
ATOM   2120  O   LYS   132      27.883  40.077  30.374  1.00 25.72           O  
ATOM   2121  CB  LYS   132      30.450  40.221  28.303  1.00 24.16           C  
ATOM   2122  CG  LYS   132      29.937  41.660  28.425  1.00 22.60           C  
ATOM   2123  CD  LYS   132      30.819  42.673  27.685  1.00 23.82           C  
ATOM   2124  CE  LYS   132      31.003  42.367  26.192  1.00 26.25           C  
ATOM   2125  NZ  LYS   132      29.783  42.581  25.373  1.00 19.16           N  
ATOM   2126  N   GLY   133      27.625  38.625  28.666  1.00 24.94           N  
ATOM   2127  CA  GLY   133      26.167  38.535  28.785  1.00 23.57           C  
ATOM   2128  C   GLY   133      25.738  37.992  30.140  1.00 24.46           C  
ATOM   2129  O   GLY   133      24.797  38.507  30.745  1.00 25.42           O  
ATOM   2130  N   ASN   134      26.421  36.946  30.616  1.00 24.53           N  
ATOM   2131  CA  ASN   134      26.212  36.447  31.981  1.00 23.49           C  
ATOM   2132  C   ASN   134      26.525  37.544  32.981  1.00 23.55           C  
ATOM   2133  O   ASN   134      25.752  37.789  33.899  1.00 23.87           O  
ATOM   2134  CB  ASN   134      27.137  35.279  32.349  1.00 24.25           C  
ATOM   2135  CG  ASN   134      27.000  34.066  31.443  1.00 22.64           C  
ATOM   2136  OD1 ASN   134      27.917  33.259  31.385  1.00 27.65           O  
ATOM   2137  ND2 ASN   134      25.884  33.927  30.755  1.00 22.69           N  
ATOM   2138  N   LEU   135      27.674  38.188  32.797  1.00 23.93           N  
ATOM   2139  CA  LEU   135      28.207  39.140  33.769  1.00 24.06           C  
ATOM   2140  C   LEU   135      27.286  40.331  34.014  1.00 24.23           C  
ATOM   2141  O   LEU   135      27.195  40.795  35.130  1.00 25.52           O  
ATOM   2142  CB  LEU   135      29.599  39.605  33.340  1.00 23.83           C  
ATOM   2143  CG  LEU   135      30.452  40.451  34.291  1.00 24.29           C  
ATOM   2144  CD1 LEU   135      30.640  39.807  35.676  1.00 20.22           C  
ATOM   2145  CD2 LEU   135      31.803  40.685  33.627  1.00 24.00           C  
ATOM   2146  N   PHE   136      26.617  40.814  32.967  1.00 24.58           N  
ATOM   2147  CA  PHE   136      25.647  41.896  33.073  1.00 24.76           C  
ATOM   2148  C   PHE   136      24.547  41.609  34.115  1.00 26.40           C  
ATOM   2149  O   PHE   136      24.153  42.502  34.871  1.00 24.96           O  
ATOM   2150  CB  PHE   136      24.994  42.160  31.714  1.00 25.02           C  
ATOM   2151  CG  PHE   136      25.603  43.297  30.961  1.00 25.69           C  
ATOM   2152  CD1 PHE   136      25.197  44.595  31.219  1.00 27.75           C  
ATOM   2153  CD2 PHE   136      26.590  43.077  29.998  1.00 23.95           C  
ATOM   2154  CE1 PHE   136      25.751  45.656  30.529  1.00 27.50           C  
ATOM   2155  CE2 PHE   136      27.150  44.126  29.303  1.00 22.33           C  
ATOM   2156  CZ  PHE   136      26.732  45.426  29.568  1.00 28.13           C  
ATOM   2157  N   VAL   137      24.049  40.374  34.143  1.00 26.43           N  
ATOM   2158  CA  VAL   137      23.008  40.004  35.098  1.00 25.49           C  
ATOM   2159  C   VAL   137      23.599  39.897  36.506  1.00 26.38           C  
ATOM   2160  O   VAL   137      22.977  40.346  37.462  1.00 27.33           O  
ATOM   2161  CB  VAL   137      22.254  38.714  34.667  1.00 26.90           C  
ATOM   2162  CG1 VAL   137      21.086  38.397  35.632  1.00 22.98           C  
ATOM   2163  CG2 VAL   137      21.726  38.861  33.238  1.00 21.37           C  
ATOM   2164  N   TYR   138      24.814  39.352  36.631  1.00 27.22           N  
ATOM   2165  CA  TYR   138      25.534  39.329  37.921  1.00 27.61           C  
ATOM   2166  C   TYR   138      25.601  40.731  38.527  1.00 28.62           C  
ATOM   2167  O   TYR   138      25.164  40.955  39.664  1.00 30.89           O  
ATOM   2168  CB  TYR   138      26.980  38.813  37.775  1.00 27.23           C  
ATOM   2169  CG  TYR   138      27.175  37.304  37.716  1.00 27.29           C  
ATOM   2170  CD1 TYR   138      26.675  36.558  36.664  1.00 26.10           C  
ATOM   2171  CD2 TYR   138      27.903  36.634  38.695  1.00 29.05           C  
ATOM   2172  CE1 TYR   138      26.872  35.177  36.590  1.00 24.62           C  
ATOM   2173  CE2 TYR   138      28.092  35.252  38.642  1.00 26.24           C  
ATOM   2174  CZ  TYR   138      27.577  34.534  37.582  1.00 26.62           C  
ATOM   2175  OH  TYR   138      27.771  33.174  37.491  1.00 27.21           O  
ATOM   2176  N   VAL   139      26.146  41.666  37.754  1.00 27.99           N  
ATOM   2177  CA  VAL   139      26.404  43.039  38.215  1.00 27.23           C  
ATOM   2178  C   VAL   139      25.129  43.810  38.552  1.00 27.92           C  
ATOM   2179  O   VAL   139      25.086  44.595  39.514  1.00 26.74           O  
ATOM   2180  CB  VAL   139      27.222  43.803  37.156  1.00 28.07           C  
ATOM   2181  CG1 VAL   139      27.307  45.289  37.484  1.00 28.06           C  
ATOM   2182  CG2 VAL   139      28.624  43.174  37.012  1.00 26.48           C  
ATOM   2183  N   ARG   140      24.099  43.592  37.744  1.00 29.05           N  
ATOM   2184  CA  ARG   140      22.773  44.168  37.964  1.00 31.02           C  
ATOM   2185  C   ARG   140      22.193  43.697  39.308  1.00 30.81           C  
ATOM   2186  O   ARG   140      21.591  44.480  40.046  1.00 30.77           O  
ATOM   2187  CB  ARG   140      21.863  43.745  36.804  1.00 32.60           C  
ATOM   2188  CG  ARG   140      20.404  44.195  36.878  1.00 40.15           C  
ATOM   2189  CD  ARG   140      20.154  45.498  36.168  1.00 42.74           C  
ATOM   2190  NE  ARG   140      20.623  45.454  34.785  1.00 44.57           N  
ATOM   2191  CZ  ARG   140      20.631  46.499  33.961  1.00 43.68           C  
ATOM   2192  NH1 ARG   140      20.180  47.690  34.364  1.00 42.68           N  
ATOM   2193  NH2 ARG   140      21.097  46.350  32.724  1.00 47.01           N  
ATOM   2194  N   GLU   141      22.378  42.412  39.606  1.00 31.43           N  
ATOM   2195  CA  GLU   141      21.960  41.809  40.885  1.00 30.94           C  
ATOM   2196  C   GLU   141      22.784  42.249  42.108  1.00 31.18           C  
ATOM   2197  O   GLU   141      22.380  42.019  43.250  1.00 30.01           O  
ATOM   2198  CB  GLU   141      21.989  40.281  40.789  1.00 31.38           C  
ATOM   2199  CG  GLU   141      20.789  39.711  40.078  1.00 29.43           C  
ATOM   2200  CD  GLU   141      20.871  38.218  39.838  1.00 29.00           C  
ATOM   2201  OE1 GLU   141      21.346  37.465  40.720  1.00 24.08           O  
ATOM   2202  OE2 GLU   141      20.434  37.798  38.751  1.00 24.21           O  
ATOM   2203  N   MET   142      23.935  42.872  41.866  1.00 31.32           N  
ATOM   2204  CA  MET   142      24.788  43.379  42.938  1.00 30.72           C  
ATOM   2205  C   MET   142      24.459  44.808  43.371  1.00 32.76           C  
ATOM   2206  O   MET   142      25.194  45.384  44.180  1.00 33.35           O  
ATOM   2207  CB  MET   142      26.247  43.366  42.498  1.00 30.80           C  
ATOM   2208  CG  MET   142      26.791  42.021  42.195  1.00 29.92           C  
ATOM   2209  SD  MET   142      28.615  42.104  41.579  0.75 23.20          SE  
ATOM   2210  CE  MET   142      28.655  43.665  40.756  1.00 18.45           C  
ATOM   2211  N   GLY   143      23.394  45.393  42.822  1.00 33.02           N  
ATOM   2212  CA  GLY   143      22.959  46.714  43.243  1.00 33.47           C  
ATOM   2213  C   GLY   143      23.214  47.819  42.232  1.00 34.81           C  
ATOM   2214  O   GLY   143      22.746  48.940  42.423  1.00 35.09           O  
ATOM   2215  N   HIS   144      23.943  47.516  41.159  1.00 35.68           N  
ATOM   2216  CA  HIS   144      24.277  48.516  40.138  1.00 36.43           C  
ATOM   2217  C   HIS   144      23.212  48.593  39.051  1.00 37.25           C  
ATOM   2218  O   HIS   144      22.838  47.584  38.459  1.00 36.10           O  
ATOM   2219  CB  HIS   144      25.643  48.218  39.538  1.00 36.53           C  
ATOM   2220  CG  HIS   144      26.725  48.147  40.564  1.00 36.63           C  
ATOM   2221  ND1 HIS   144      27.392  49.264  41.015  1.00 34.51           N  
ATOM   2222  CD2 HIS   144      27.217  47.101  41.267  1.00 41.34           C  
ATOM   2223  CE1 HIS   144      28.270  48.906  41.934  1.00 40.77           C  
ATOM   2224  NE2 HIS   144      28.181  47.599  42.111  1.00 42.86           N  
ATOM   2225  N   THR   145      22.720  49.802  38.808  1.00 39.71           N  
ATOM   2226  CA  THR   145      21.653  50.030  37.835  1.00 41.21           C  
ATOM   2227  C   THR   145      22.096  50.853  36.624  1.00 43.96           C  
ATOM   2228  O   THR   145      21.370  50.917  35.626  1.00 45.11           O  
ATOM   2229  CB  THR   145      20.451  50.766  38.477  1.00 40.95           C  
ATOM   2230  OG1 THR   145      20.784  52.148  38.677  1.00 36.83           O  
ATOM   2231  CG2 THR   145      20.050  50.122  39.813  1.00 38.96           C  
ATOM   2232  N   GLU   146      23.260  51.496  36.705  1.00 45.65           N  
ATOM   2233  CA  GLU   146      23.726  52.328  35.604  1.00 47.58           C  
ATOM   2234  C   GLU   146      24.886  51.616  34.924  1.00 46.33           C  
ATOM   2235  O   GLU   146      26.059  51.845  35.238  1.00 48.08           O  
ATOM   2236  CB  GLU   146      24.105  53.725  36.101  1.00 48.88           C  
ATOM   2237  CG  GLU   146      23.685  54.842  35.148  1.00 53.87           C  
ATOM   2238  CD  GLU   146      22.186  54.817  34.818  1.00 59.74           C  
ATOM   2239  OE1 GLU   146      21.360  54.933  35.753  1.00 62.56           O  
ATOM   2240  OE2 GLU   146      21.837  54.686  33.624  1.00 60.00           O  
ATOM   2241  N   LEU   147      24.535  50.731  33.998  1.00 43.13           N  
ATOM   2242  CA  LEU   147      25.511  49.860  33.355  1.00 40.71           C  
ATOM   2243  C   LEU   147      25.797  50.305  31.923  1.00 38.85           C  
ATOM   2244  O   LEU   147      24.917  50.848  31.242  1.00 37.87           O  
ATOM   2245  CB  LEU   147      25.016  48.411  33.365  1.00 40.10           C  
ATOM   2246  CG  LEU   147      24.740  47.799  34.743  1.00 39.60           C  
ATOM   2247  CD1 LEU   147      24.125  46.436  34.588  1.00 38.09           C  
ATOM   2248  CD2 LEU   147      26.011  47.720  35.575  1.00 37.18           C  
ATOM   2249  N   PRO   148      27.036  50.070  31.457  1.00 36.83           N  
ATOM   2250  CA  PRO   148      27.359  50.459  30.092  1.00 35.09           C  
ATOM   2251  C   PRO   148      26.522  49.694  29.079  1.00 32.85           C  
ATOM   2252  O   PRO   148      25.936  48.655  29.407  1.00 32.33           O  
ATOM   2253  CB  PRO   148      28.841  50.080  29.953  1.00 34.78           C  
ATOM   2254  CG  PRO   148      29.096  49.071  31.022  1.00 36.57           C  
ATOM   2255  CD  PRO   148      28.178  49.432  32.143  1.00 37.27           C  
ATOM   2256  N   PHE   149      26.440  50.234  27.871  1.00 30.90           N  
ATOM   2257  CA  PHE   149      25.923  49.487  26.742  1.00 29.22           C  
ATOM   2258  C   PHE   149      26.911  48.343  26.533  1.00 26.36           C  
ATOM   2259  O   PHE   149      28.108  48.498  26.802  1.00 26.92           O  
ATOM   2260  CB  PHE   149      25.825  50.378  25.500  1.00 29.54           C  
ATOM   2261  CG  PHE   149      25.075  49.745  24.365  1.00 31.48           C  
ATOM   2262  CD1 PHE   149      23.731  49.412  24.508  1.00 32.96           C  
ATOM   2263  CD2 PHE   149      25.708  49.468  23.162  1.00 31.91           C  
ATOM   2264  CE1 PHE   149      23.040  48.813  23.475  1.00 33.85           C  
ATOM   2265  CE2 PHE   149      25.017  48.876  22.123  1.00 34.43           C  
ATOM   2266  CZ  PHE   149      23.683  48.546  22.282  1.00 33.21           C  
ATOM   2267  N   TYR   150      26.428  47.209  26.045  1.00 25.14           N  
ATOM   2268  CA  TYR   150      27.236  45.986  26.041  1.00 26.48           C  
ATOM   2269  C   TYR   150      28.453  45.994  25.127  1.00 25.90           C  
ATOM   2270  O   TYR   150      29.319  45.125  25.246  1.00 26.81           O  
ATOM   2271  CB  TYR   150      26.372  44.766  25.751  1.00 27.38           C  
ATOM   2272  CG  TYR   150      25.858  44.654  24.346  1.00 27.41           C  
ATOM   2273  CD1 TYR   150      26.599  44.014  23.357  1.00 26.55           C  
ATOM   2274  CD2 TYR   150      24.599  45.154  24.011  1.00 33.30           C  
ATOM   2275  CE1 TYR   150      26.103  43.901  22.050  1.00 32.66           C  
ATOM   2276  CE2 TYR   150      24.090  45.035  22.725  1.00 34.22           C  
ATOM   2277  CZ  TYR   150      24.845  44.420  21.751  1.00 33.26           C  
ATOM   2278  OH  TYR   150      24.321  44.325  20.489  1.00 36.66           O  
ATOM   2279  N   GLN   151      28.514  46.963  24.224  1.00 25.97           N  
ATOM   2280  CA  GLN   151      29.643  47.114  23.323  1.00 28.02           C  
ATOM   2281  C   GLN   151      29.928  48.601  23.100  1.00 28.27           C  
ATOM   2282  O   GLN   151      29.011  49.379  22.893  1.00 26.65           O  
ATOM   2283  CB  GLN   151      29.326  46.447  21.977  1.00 28.59           C  
ATOM   2284  CG  GLN   151      30.572  46.158  21.157  1.00 31.58           C  
ATOM   2285  CD  GLN   151      30.308  45.843  19.693  1.00 29.46           C  
ATOM   2286  OE1 GLN   151      29.163  45.768  19.260  1.00 34.99           O  
ATOM   2287  NE2 GLN   151      31.381  45.675  18.920  1.00 28.17           N  
ATOM   2288  N   GLN   152      31.196  48.988  23.151  1.00 30.83           N  
ATOM   2289  CA  GLN   152      31.596  50.336  22.767  1.00 33.70           C  
ATOM   2290  C   GLN   152      31.634  50.422  21.243  1.00 36.95           C  
ATOM   2291  O   GLN   152      31.835  49.412  20.563  1.00 37.86           O  
ATOM   2292  CB  GLN   152      32.961  50.684  23.349  1.00 32.47           C  
ATOM   2293  CG  GLN   152      32.965  50.794  24.856  1.00 33.78           C  
ATOM   2294  CD  GLN   152      34.315  51.214  25.424  1.00 35.09           C  
ATOM   2295  OE1 GLN   152      35.319  51.317  24.704  1.00 32.29           O  
ATOM   2296  NE2 GLN   152      34.342  51.450  26.731  1.00 28.38           N  
ATOM   2297  N   ARG   153      31.444  51.622  20.707  1.00 38.84           N  
ATOM   2298  CA  ARG   153      31.447  51.820  19.252  1.00 40.64           C  
ATOM   2299  C   ARG   153      32.858  51.664  18.680  1.00 42.01           C  
ATOM   2300  O   ARG   153      33.351  50.543  18.488  1.00 44.29           O  
ATOM   2301  CB  ARG   153      30.889  53.206  18.903  1.00 39.42           C  
END
