
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  147 ( 1147),  selected  147 , name 1ozb_G
# Molecule2: number of CA atoms  101 ( 1588),  selected  101 , name T0482_7_107.pdb
# PARAMETERS: 1ozb_G.T0482_7_107.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    K     5_G      P     7_A           -
LGA    Q     6_G      G     8_A           -
LGA    D     7_G      H     9_A           -
LGA    V     8_G      L    10_A           -
LGA    A     9_G      H    11_A           -
LGA    A    10_G      L    12_A           -
LGA    T    11_G      V    13_A           -
LGA    E    12_G      S    14_A           -
LGA    E    13_G      L    15_A           -
LGA    Q    14_G      P    16_A           -
LGA    Q    15_G      G    17_A           -
LGA    P    16_G      L    18_A           -
LGA    V    17_G      -       -           -
LGA    L    18_G      -       -           -
LGA    Q    19_G      -       -           -
LGA    I    20_G      -       -           -
LGA    Q    21_G      -       -           -
LGA    R    22_G      -       -           -
LGA    I    23_G      -       -           -
LGA    Y    24_G      -       -           -
LGA    V    25_G      -       -           -
LGA    K    26_G      -       -           -
LGA    D    27_G      -       -           -
LGA    V    28_G      -       -           -
LGA    S    29_G      -       -           -
LGA    F    30_G      -       -           -
LGA    E    31_G      -       -           -
LGA    A    32_G      -       -           -
LGA    P    33_G      -       -           -
LGA    N    34_G      -       -           -
LGA    L    35_G      -       -           -
LGA    P    36_G      -       -           -
LGA    H    37_G      -       -           -
LGA    I    38_G      -       -           -
LGA    F    39_G      -       -           -
LGA    Q    40_G      -       -           -
LGA    Q    41_G      -       -           -
LGA    E    42_G      -       -           -
LGA    W    43_G      -       -           -
LGA    K    44_G      D    19_A           #
LGA    P    45_G      Q    20_A          4.250
LGA    -       -      Q    21_A           -
LGA    K    46_G      D    22_A          2.940
LGA    L    47_G      I    23_A          2.388
LGA    G    48_G      N    24_A          2.039
LGA    F    49_G      I    25_A          2.736
LGA    D    50_G      H    26_A          1.750
LGA    L    51_G      I    27_A          1.838
LGA    S    52_G      R    28_A          1.902
LGA    T    53_G      Y    29_A          0.578
LGA    E    54_G      E    30_A          0.583
LGA    T    55_G      V    31_A          1.148
LGA    T    56_G      R    32_A          1.209
LGA    Q    57_G      Q    33_A          1.129
LGA    V    58_G      N    34_A          0.828
LGA    G    59_G      A    35_A          2.111
LGA    D    60_G      E    36_A           #
LGA    D    61_G      S    37_A          5.401
LGA    L    62_G      G    38_A          2.187
LGA    Y    63_G      A    39_A          1.921
LGA    E    64_G      Y    40_A          2.214
LGA    V    65_G      V    41_A          1.009
LGA    V    66_G      H    42_A          1.880
LGA    L    67_G      F    43_A          2.333
LGA    N    68_G      D    44_A          2.271
LGA    I    69_G      M    45_A          2.251
LGA    S    70_G      D    46_A          2.473
LGA    V    71_G      G    47_A          3.468
LGA    E    72_G      E    48_A          2.461
LGA    T    73_G      I    49_A          3.190
LGA    T    74_G      -       -           -
LGA    L    75_G      -       -           -
LGA    E    76_G      -       -           -
LGA    D    77_G      -       -           -
LGA    S    78_G      -       -           -
LGA    G    79_G      -       -           -
LGA    D    80_G      -       -           -
LGA    V    81_G      D    50_A           #
LGA    A    82_G      G    51_A          2.141
LGA    F    83_G      K    52_A          1.515
LGA    I    84_G      P    53_A          2.262
LGA    C    85_G      F    54_A          2.703
LGA    E    86_G      S    55_A          3.005
LGA    V    87_G      D    56_A          2.367
LGA    K    88_G      S    57_A          1.615
LGA    Q    89_G      F    58_A          2.044
LGA    A    90_G      E    59_A          1.373
LGA    G    91_G      L    60_A          0.968
LGA    V    92_G      P    61_A          1.707
LGA    F    93_G      R    62_A          2.594
LGA    T    94_G      D    63_A          4.722
LGA    I    95_G      T    64_A           -
LGA    S    96_G      -       -           -
LGA    G    97_G      -       -           -
LGA    L    98_G      -       -           -
LGA    E    99_G      -       -           -
LGA    D   100_G      -       -           -
LGA    V   101_G      -       -           -
LGA    Q   102_G      -       -           -
LGA    M   103_G      -       -           -
LGA    A   104_G      -       -           -
LGA    H   105_G      -       -           -
LGA    C   106_G      -       -           -
LGA    L   107_G      -       -           -
LGA    T   108_G      -       -           -
LGA    S   109_G      -       -           -
LGA    Q   110_G      A    65_A           #
LGA    C   111_G      F    66_A          2.434
LGA    P   112_G      -       -           -
LGA    N   113_G      -       -           -
LGA    M   114_G      N    67_A          1.122
LGA    L   115_G      F    68_A          1.480
LGA    F   116_G      A    69_A          2.474
LGA    P   117_G      S    70_A          1.645
LGA    Y   118_G      D    71_A          1.469
LGA    A   119_G      A    72_A          2.693
LGA    R   120_G      T    73_A          2.182
LGA    E   121_G      R    74_A          1.858
LGA    L   122_G      V    75_A          2.348
LGA    V   123_G      A    76_A          3.105
LGA    S   124_G      Q    77_A          2.616
LGA    N   125_G      K    78_A          2.798
LGA    L   126_G      H    79_A          4.204
LGA    V   127_G      G    80_A          3.540
LGA    N   128_G      -       -           -
LGA    R   129_G      -       -           -
LGA    G   130_G      -       -           -
LGA    T   131_G      -       -           -
LGA    F   132_G      -       -           -
LGA    P   133_G      -       -           -
LGA    A   134_G      L    81_A          4.314
LGA    L   135_G      H    82_A          3.640
LGA    N   136_G      P    83_A          4.860
LGA    -       -      K    84_A           -
LGA    -       -      F    85_A           -
LGA    L   137_G      G    86_A           #
LGA    S   138_G      A    87_A          2.558
LGA    P   139_G      I    88_A          5.413
LGA    -       -      T    89_A           -
LGA    -       -      R    90_A           -
LGA    -       -      V    91_A           -
LGA    V   140_G      H    92_A           #
LGA    -       -      K    93_A           -
LGA    N   141_G      E    94_A          3.654
LGA    F   142_G      Y    95_A          4.642
LGA    -       -      D    96_A           -
LGA    D   143_G      A    97_A          1.761
LGA    A   144_G      M    98_A          4.834
LGA    L   145_G      F    99_A           #
LGA    -       -      E   100_A           -
LGA    F   146_G      D   101_A          2.697
LGA    V   147_G      I   102_A           -
LGA    E   148_G      R   103_A           -
LGA    -       -      A   104_A           -
LGA    Y   149_G      K   105_A           #
LGA    M   150_G      L   106_A           -
LGA    N   151_G      H   107_A           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  147  101    5.0     66    2.73     7.58     42.980     2.331

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.752798 * X  +   0.436923 * Y  +  -0.492335 * Z  + -118.753014
  Y_new =  -0.594915 * X  +  -0.771717 * Y  +   0.224787 * Z  + 173.707932
  Z_new =  -0.281728 * X  +   0.462117 * Y  +   0.840879 * Z  + 243.919708 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.502508   -2.639084  [ DEG:    28.7916   -151.2084 ]
  Theta =   0.285595    2.855998  [ DEG:    16.3634    163.6366 ]
  Phi   =  -2.472812    0.668781  [ DEG:  -141.6817     38.3183 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1ozb_G                                        
REMARK     2: T0482_7_107.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1ozb_G.T0482_7_107.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  147  101   5.0   66   2.73    7.58  42.980
REMARK  ---------------------------------------------------------- 
MOLECULE 1ozb_G
HEADER    PROTEIN TRANSPORT                       08-APR-03   1OZB              
TITLE     CRYSTAL STRUCTURE OF SECB COMPLEXED WITH SECA C-TERMINUS              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROTEIN-EXPORT PROTEIN SECB;                               
COMPND   3 CHAIN: A, B, C, D, E, F, G, H;                                       
COMPND   4 ENGINEERED: YES;                                                     
COMPND   5 MOL_ID: 2;                                                           
COMPND   6 MOLECULE: PREPROTEIN TRANSLOCASE SECA SUBUNIT;                       
COMPND   7 CHAIN: I, J;                                                         
COMPND   8 FRAGMENT: C-TERMINAL DOMAIN;                                         
COMPND   9 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HAEMOPHILUS INFLUENZAE;                         
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: SECB OR HI0743;                                                
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PSJ4-SECBHI;                              
SOURCE  10 MOL_ID: 2;                                                           
SOURCE  11 ORGANISM_SCIENTIFIC: HAEMOPHILUS INFLUENZAE;                         
SOURCE  12 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  13 GENE: SECA OR HI0909;                                                
SOURCE  14 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  15 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE  16 EXPRESSION_SYSTEM_STRAIN: DH5ALPHA;                                  
SOURCE  17 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  18 EXPRESSION_SYSTEM_PLASMID: PGEX-2T-SECACHI                           
KEYWDS    ZINC BINDING MOTIF, PROTEIN-PROTEIN COMPLEX                           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    J.ZHOU,Z.XU                                                           
REVDAT   2   04-NOV-03 1OZB    1       JRNL                                     
REVDAT   1   14-OCT-03 1OZB    0                                                
JRNL        AUTH   J.ZHOU,Z.XU                                                  
JRNL        TITL   STRUCTURAL DETERMINANTS OF SECB RECOGNITION BY               
JRNL        TITL 2 SECA IN BACTERIAL PROTEIN TRANSLOCATION                      
JRNL        REF    NAT.STRUCT.BIOL.              V.  10   942 2003              
JRNL        REFN   ASTM NSBIEW  US ISSN 1072-8368                               
REMARK   2 RESOLUTION. 2.80 ANGSTROMS.                                          
DBREF  1OZB A    1   169  UNP    P44853   SECB_HAEIN       1    169             
DBREF  1OZB B    1   169  UNP    P44853   SECB_HAEIN       1    169             
DBREF  1OZB C    1   169  UNP    P44853   SECB_HAEIN       1    169             
DBREF  1OZB D    1   169  UNP    P44853   SECB_HAEIN       1    169             
DBREF  1OZB E    1   169  UNP    P44853   SECB_HAEIN       1    169             
DBREF  1OZB F    1   169  UNP    P44853   SECB_HAEIN       1    169             
DBREF  1OZB G    1   169  UNP    P44853   SECB_HAEIN       1    169             
DBREF  1OZB H    1   169  UNP    P44853   SECB_HAEIN       1    169             
DBREF  1OZB I    1    27  UNP    P43803   SECA_HAEIN     875    901             
DBREF  1OZB J    1    27  UNP    P43803   SECA_HAEIN     875    901             
SEQRES   1 A  169  MET SER GLU GLN LYS GLN ASP VAL ALA ALA THR GLU GLU          
SEQRES   2 A  169  GLN GLN PRO VAL LEU GLN ILE GLN ARG ILE TYR VAL LYS          
SEQRES   3 A  169  ASP VAL SER PHE GLU ALA PRO ASN LEU PRO HIS ILE PHE          
SEQRES   4 A  169  GLN GLN GLU TRP LYS PRO LYS LEU GLY PHE ASP LEU SER          
SEQRES   5 A  169  THR GLU THR THR GLN VAL GLY ASP ASP LEU TYR GLU VAL          
SEQRES   6 A  169  VAL LEU ASN ILE SER VAL GLU THR THR LEU GLU ASP SER          
SEQRES   7 A  169  GLY ASP VAL ALA PHE ILE CYS GLU VAL LYS GLN ALA GLY          
SEQRES   8 A  169  VAL PHE THR ILE SER GLY LEU GLU ASP VAL GLN MET ALA          
SEQRES   9 A  169  HIS CYS LEU THR SER GLN CYS PRO ASN MET LEU PHE PRO          
SEQRES  10 A  169  TYR ALA ARG GLU LEU VAL SER ASN LEU VAL ASN ARG GLY          
SEQRES  11 A  169  THR PHE PRO ALA LEU ASN LEU SER PRO VAL ASN PHE ASP          
SEQRES  12 A  169  ALA LEU PHE VAL GLU TYR MET ASN ARG GLN GLN ALA GLU          
SEQRES  13 A  169  ASN ALA GLU GLU LYS SER GLU GLU GLU GLN THR LYS HIS          
SEQRES   1 B  169  MET SER GLU GLN LYS GLN ASP VAL ALA ALA THR GLU GLU          
SEQRES   2 B  169  GLN GLN PRO VAL LEU GLN ILE GLN ARG ILE TYR VAL LYS          
SEQRES   3 B  169  ASP VAL SER PHE GLU ALA PRO ASN LEU PRO HIS ILE PHE          
SEQRES   4 B  169  GLN GLN GLU TRP LYS PRO LYS LEU GLY PHE ASP LEU SER          
SEQRES   5 B  169  THR GLU THR THR GLN VAL GLY ASP ASP LEU TYR GLU VAL          
SEQRES   6 B  169  VAL LEU ASN ILE SER VAL GLU THR THR LEU GLU ASP SER          
SEQRES   7 B  169  GLY ASP VAL ALA PHE ILE CYS GLU VAL LYS GLN ALA GLY          
SEQRES   8 B  169  VAL PHE THR ILE SER GLY LEU GLU ASP VAL GLN MET ALA          
SEQRES   9 B  169  HIS CYS LEU THR SER GLN CYS PRO ASN MET LEU PHE PRO          
SEQRES  10 B  169  TYR ALA ARG GLU LEU VAL SER ASN LEU VAL ASN ARG GLY          
SEQRES  11 B  169  THR PHE PRO ALA LEU ASN LEU SER PRO VAL ASN PHE ASP          
SEQRES  12 B  169  ALA LEU PHE VAL GLU TYR MET ASN ARG GLN GLN ALA GLU          
SEQRES  13 B  169  ASN ALA GLU GLU LYS SER GLU GLU GLU GLN THR LYS HIS          
SEQRES   1 C  169  MET SER GLU GLN LYS GLN ASP VAL ALA ALA THR GLU GLU          
SEQRES   2 C  169  GLN GLN PRO VAL LEU GLN ILE GLN ARG ILE TYR VAL LYS          
SEQRES   3 C  169  ASP VAL SER PHE GLU ALA PRO ASN LEU PRO HIS ILE PHE          
SEQRES   4 C  169  GLN GLN GLU TRP LYS PRO LYS LEU GLY PHE ASP LEU SER          
SEQRES   5 C  169  THR GLU THR THR GLN VAL GLY ASP ASP LEU TYR GLU VAL          
SEQRES   6 C  169  VAL LEU ASN ILE SER VAL GLU THR THR LEU GLU ASP SER          
SEQRES   7 C  169  GLY ASP VAL ALA PHE ILE CYS GLU VAL LYS GLN ALA GLY          
SEQRES   8 C  169  VAL PHE THR ILE SER GLY LEU GLU ASP VAL GLN MET ALA          
SEQRES   9 C  169  HIS CYS LEU THR SER GLN CYS PRO ASN MET LEU PHE PRO          
SEQRES  10 C  169  TYR ALA ARG GLU LEU VAL SER ASN LEU VAL ASN ARG GLY          
SEQRES  11 C  169  THR PHE PRO ALA LEU ASN LEU SER PRO VAL ASN PHE ASP          
SEQRES  12 C  169  ALA LEU PHE VAL GLU TYR MET ASN ARG GLN GLN ALA GLU          
SEQRES  13 C  169  ASN ALA GLU GLU LYS SER GLU GLU GLU GLN THR LYS HIS          
SEQRES   1 D  169  MET SER GLU GLN LYS GLN ASP VAL ALA ALA THR GLU GLU          
SEQRES   2 D  169  GLN GLN PRO VAL LEU GLN ILE GLN ARG ILE TYR VAL LYS          
SEQRES   3 D  169  ASP VAL SER PHE GLU ALA PRO ASN LEU PRO HIS ILE PHE          
SEQRES   4 D  169  GLN GLN GLU TRP LYS PRO LYS LEU GLY PHE ASP LEU SER          
SEQRES   5 D  169  THR GLU THR THR GLN VAL GLY ASP ASP LEU TYR GLU VAL          
SEQRES   6 D  169  VAL LEU ASN ILE SER VAL GLU THR THR LEU GLU ASP SER          
SEQRES   7 D  169  GLY ASP VAL ALA PHE ILE CYS GLU VAL LYS GLN ALA GLY          
SEQRES   8 D  169  VAL PHE THR ILE SER GLY LEU GLU ASP VAL GLN MET ALA          
SEQRES   9 D  169  HIS CYS LEU THR SER GLN CYS PRO ASN MET LEU PHE PRO          
SEQRES  10 D  169  TYR ALA ARG GLU LEU VAL SER ASN LEU VAL ASN ARG GLY          
SEQRES  11 D  169  THR PHE PRO ALA LEU ASN LEU SER PRO VAL ASN PHE ASP          
SEQRES  12 D  169  ALA LEU PHE VAL GLU TYR MET ASN ARG GLN GLN ALA GLU          
SEQRES  13 D  169  ASN ALA GLU GLU LYS SER GLU GLU GLU GLN THR LYS HIS          
SEQRES   1 E  169  MET SER GLU GLN LYS GLN ASP VAL ALA ALA THR GLU GLU          
SEQRES   2 E  169  GLN GLN PRO VAL LEU GLN ILE GLN ARG ILE TYR VAL LYS          
SEQRES   3 E  169  ASP VAL SER PHE GLU ALA PRO ASN LEU PRO HIS ILE PHE          
SEQRES   4 E  169  GLN GLN GLU TRP LYS PRO LYS LEU GLY PHE ASP LEU SER          
SEQRES   5 E  169  THR GLU THR THR GLN VAL GLY ASP ASP LEU TYR GLU VAL          
SEQRES   6 E  169  VAL LEU ASN ILE SER VAL GLU THR THR LEU GLU ASP SER          
SEQRES   7 E  169  GLY ASP VAL ALA PHE ILE CYS GLU VAL LYS GLN ALA GLY          
SEQRES   8 E  169  VAL PHE THR ILE SER GLY LEU GLU ASP VAL GLN MET ALA          
SEQRES   9 E  169  HIS CYS LEU THR SER GLN CYS PRO ASN MET LEU PHE PRO          
SEQRES  10 E  169  TYR ALA ARG GLU LEU VAL SER ASN LEU VAL ASN ARG GLY          
SEQRES  11 E  169  THR PHE PRO ALA LEU ASN LEU SER PRO VAL ASN PHE ASP          
SEQRES  12 E  169  ALA LEU PHE VAL GLU TYR MET ASN ARG GLN GLN ALA GLU          
SEQRES  13 E  169  ASN ALA GLU GLU LYS SER GLU GLU GLU GLN THR LYS HIS          
SEQRES   1 F  169  MET SER GLU GLN LYS GLN ASP VAL ALA ALA THR GLU GLU          
SEQRES   2 F  169  GLN GLN PRO VAL LEU GLN ILE GLN ARG ILE TYR VAL LYS          
SEQRES   3 F  169  ASP VAL SER PHE GLU ALA PRO ASN LEU PRO HIS ILE PHE          
SEQRES   4 F  169  GLN GLN GLU TRP LYS PRO LYS LEU GLY PHE ASP LEU SER          
SEQRES   5 F  169  THR GLU THR THR GLN VAL GLY ASP ASP LEU TYR GLU VAL          
SEQRES   6 F  169  VAL LEU ASN ILE SER VAL GLU THR THR LEU GLU ASP SER          
SEQRES   7 F  169  GLY ASP VAL ALA PHE ILE CYS GLU VAL LYS GLN ALA GLY          
SEQRES   8 F  169  VAL PHE THR ILE SER GLY LEU GLU ASP VAL GLN MET ALA          
SEQRES   9 F  169  HIS CYS LEU THR SER GLN CYS PRO ASN MET LEU PHE PRO          
SEQRES  10 F  169  TYR ALA ARG GLU LEU VAL SER ASN LEU VAL ASN ARG GLY          
SEQRES  11 F  169  THR PHE PRO ALA LEU ASN LEU SER PRO VAL ASN PHE ASP          
SEQRES  12 F  169  ALA LEU PHE VAL GLU TYR MET ASN ARG GLN GLN ALA GLU          
SEQRES  13 F  169  ASN ALA GLU GLU LYS SER GLU GLU GLU GLN THR LYS HIS          
SEQRES   1 G  169  MET SER GLU GLN LYS GLN ASP VAL ALA ALA THR GLU GLU          
SEQRES   2 G  169  GLN GLN PRO VAL LEU GLN ILE GLN ARG ILE TYR VAL LYS          
SEQRES   3 G  169  ASP VAL SER PHE GLU ALA PRO ASN LEU PRO HIS ILE PHE          
SEQRES   4 G  169  GLN GLN GLU TRP LYS PRO LYS LEU GLY PHE ASP LEU SER          
SEQRES   5 G  169  THR GLU THR THR GLN VAL GLY ASP ASP LEU TYR GLU VAL          
SEQRES   6 G  169  VAL LEU ASN ILE SER VAL GLU THR THR LEU GLU ASP SER          
SEQRES   7 G  169  GLY ASP VAL ALA PHE ILE CYS GLU VAL LYS GLN ALA GLY          
SEQRES   8 G  169  VAL PHE THR ILE SER GLY LEU GLU ASP VAL GLN MET ALA          
SEQRES   9 G  169  HIS CYS LEU THR SER GLN CYS PRO ASN MET LEU PHE PRO          
SEQRES  10 G  169  TYR ALA ARG GLU LEU VAL SER ASN LEU VAL ASN ARG GLY          
SEQRES  11 G  169  THR PHE PRO ALA LEU ASN LEU SER PRO VAL ASN PHE ASP          
SEQRES  12 G  169  ALA LEU PHE VAL GLU TYR MET ASN ARG GLN GLN ALA GLU          
SEQRES  13 G  169  ASN ALA GLU GLU LYS SER GLU GLU GLU GLN THR LYS HIS          
SEQRES   1 H  169  MET SER GLU GLN LYS GLN ASP VAL ALA ALA THR GLU GLU          
SEQRES   2 H  169  GLN GLN PRO VAL LEU GLN ILE GLN ARG ILE TYR VAL LYS          
SEQRES   3 H  169  ASP VAL SER PHE GLU ALA PRO ASN LEU PRO HIS ILE PHE          
SEQRES   4 H  169  GLN GLN GLU TRP LYS PRO LYS LEU GLY PHE ASP LEU SER          
SEQRES   5 H  169  THR GLU THR THR GLN VAL GLY ASP ASP LEU TYR GLU VAL          
SEQRES   6 H  169  VAL LEU ASN ILE SER VAL GLU THR THR LEU GLU ASP SER          
SEQRES   7 H  169  GLY ASP VAL ALA PHE ILE CYS GLU VAL LYS GLN ALA GLY          
SEQRES   8 H  169  VAL PHE THR ILE SER GLY LEU GLU ASP VAL GLN MET ALA          
SEQRES   9 H  169  HIS CYS LEU THR SER GLN CYS PRO ASN MET LEU PHE PRO          
SEQRES  10 H  169  TYR ALA ARG GLU LEU VAL SER ASN LEU VAL ASN ARG GLY          
SEQRES  11 H  169  THR PHE PRO ALA LEU ASN LEU SER PRO VAL ASN PHE ASP          
SEQRES  12 H  169  ALA LEU PHE VAL GLU TYR MET ASN ARG GLN GLN ALA GLU          
SEQRES  13 H  169  ASN ALA GLU GLU LYS SER GLU GLU GLU GLN THR LYS HIS          
SEQRES   1 I   27  ARG ILE GLY ARG ASN GLU PRO CYS PRO CYS GLY SER GLY          
SEQRES   2 I   27  LYS LYS TYR LYS HIS CYS HIS GLY SER ARG VAL ALA ARG          
SEQRES   3 I   27  GLN                                                          
SEQRES   1 J   27  ARG ILE GLY ARG ASN GLU PRO CYS PRO CYS GLY SER GLY          
SEQRES   2 J   27  LYS LYS TYR LYS HIS CYS HIS GLY SER ARG VAL ALA ARG          
SEQRES   3 J   27  GLN                                                          
HET     ZN     50       1                                                       
HET     ZN     51       1                                                       
HETNAM      ZN ZINC ION                                                         
FORMUL  11   ZN    2(ZN 2+)                                                     
CRYST1  114.500  114.500  286.100  90.00  90.00  90.00 P 41 21 2    64          
ATOM   6582  N   LYS G   5      24.683  27.086  -9.657  1.00106.45           N  
ATOM   6583  CA  LYS G   5      25.873  26.289  -9.233  1.00106.45           C  
ATOM   6584  C   LYS G   5      25.512  24.834  -8.896  1.00106.45           C  
ATOM   6585  O   LYS G   5      24.453  24.555  -8.330  1.00106.45           O  
ATOM   6586  CB  LYS G   5      26.566  26.971  -8.018  1.00 45.12           C  
ATOM   6587  N   GLN G   6      26.398  23.910  -9.261  1.00133.79           N  
ATOM   6588  CA  GLN G   6      26.197  22.490  -8.987  1.00133.79           C  
ATOM   6589  C   GLN G   6      27.217  22.071  -7.925  1.00133.79           C  
ATOM   6590  O   GLN G   6      28.384  21.838  -8.236  1.00133.79           O  
ATOM   6591  CB  GLN G   6      26.386  21.661 -10.281  1.00 42.27           C  
ATOM   6592  N   ASP G   7      26.772  21.992  -6.673  1.00119.29           N  
ATOM   6593  CA  ASP G   7      27.647  21.614  -5.564  1.00119.29           C  
ATOM   6594  C   ASP G   7      27.216  20.303  -4.906  1.00119.29           C  
ATOM   6595  O   ASP G   7      26.468  20.317  -3.931  1.00119.29           O  
ATOM   6596  CB  ASP G   7      27.664  22.722  -4.528  1.00 37.74           C  
ATOM   6597  N   VAL G   8      27.703  19.178  -5.430  1.00 62.69           N  
ATOM   6598  CA  VAL G   8      27.365  17.858  -4.903  1.00 62.69           C  
ATOM   6599  C   VAL G   8      27.709  17.690  -3.420  1.00 62.69           C  
ATOM   6600  O   VAL G   8      28.856  17.415  -3.077  1.00 62.69           O  
ATOM   6601  CB  VAL G   8      28.068  16.783  -5.725  1.00 33.51           C  
ATOM   6602  N   ALA G   9      26.711  17.844  -2.551  1.00 63.25           N  
ATOM   6603  CA  ALA G   9      26.901  17.703  -1.103  1.00 63.25           C  
ATOM   6604  C   ALA G   9      27.410  16.309  -0.730  1.00 63.25           C  
ATOM   6605  O   ALA G   9      26.907  15.307  -1.229  1.00 63.25           O  
ATOM   6606  CB  ALA G   9      25.587  17.986  -0.379  1.00 47.98           C  
ATOM   6607  N   ALA G  10      28.394  16.253   0.162  1.00 61.01           N  
ATOM   6608  CA  ALA G  10      29.006  14.997   0.613  1.00 61.01           C  
ATOM   6609  C   ALA G  10      28.075  13.786   0.784  1.00 61.01           C  
ATOM   6610  O   ALA G  10      27.000  13.894   1.375  1.00 61.01           O  
ATOM   6611  CB  ALA G  10      29.761  15.244   1.929  1.00 51.65           C  
ATOM   6612  N   THR G  11      28.515  12.629   0.284  1.00 54.85           N  
ATOM   6613  CA  THR G  11      27.741  11.390   0.392  1.00 54.85           C  
ATOM   6614  C   THR G  11      28.042  10.689   1.722  1.00 54.85           C  
ATOM   6615  O   THR G  11      28.946  11.099   2.455  1.00 54.85           O  
ATOM   6616  CB  THR G  11      28.067  10.394  -0.756  1.00 59.27           C  
ATOM   6617  OG1 THR G  11      29.134   9.524  -0.361  1.00 48.65           O  
ATOM   6618  CG2 THR G  11      28.492  11.131  -1.999  1.00 48.65           C  
ATOM   6619  N   GLU G  12      27.298   9.622   2.021  1.00 41.72           N  
ATOM   6620  CA  GLU G  12      27.479   8.867   3.267  1.00 41.72           C  
ATOM   6621  C   GLU G  12      28.785   8.071   3.378  1.00 41.72           C  
ATOM   6622  O   GLU G  12      29.407   7.689   2.370  1.00 41.72           O  
ATOM   6623  CB  GLU G  12      26.297   7.921   3.486  1.00 89.81           C  
ATOM   6624  CG  GLU G  12      24.996   8.630   3.769  1.00 68.07           C  
ATOM   6625  CD  GLU G  12      25.137   9.644   4.870  1.00 68.07           C  
ATOM   6626  OE1 GLU G  12      25.665   9.280   5.939  1.00 68.07           O  
ATOM   6627  OE2 GLU G  12      24.721  10.804   4.669  1.00 68.07           O  
ATOM   6628  N   GLU G  13      29.184   7.817   4.623  1.00 48.17           N  
ATOM   6629  CA  GLU G  13      30.415   7.087   4.906  1.00 48.17           C  
ATOM   6630  C   GLU G  13      30.399   5.693   4.273  1.00 48.17           C  
ATOM   6631  O   GLU G  13      31.417   5.206   3.775  1.00 48.17           O  
ATOM   6632  CB  GLU G  13      30.610   6.983   6.418  1.00114.24           C  
ATOM   6633  CG  GLU G  13      32.015   7.331   6.890  1.00 80.45           C  
ATOM   6634  CD  GLU G  13      32.459   8.727   6.472  1.00 80.45           C  
ATOM   6635  OE1 GLU G  13      32.906   8.903   5.314  1.00 80.45           O  
ATOM   6636  OE2 GLU G  13      32.351   9.648   7.312  1.00 80.45           O  
ATOM   6637  N   GLN G  14      29.226   5.067   4.304  1.00 61.80           N  
ATOM   6638  CA  GLN G  14      28.999   3.739   3.740  1.00 61.80           C  
ATOM   6639  C   GLN G  14      27.734   3.797   2.887  1.00 61.80           C  
ATOM   6640  O   GLN G  14      26.764   4.461   3.261  1.00 61.80           O  
ATOM   6641  CB  GLN G  14      28.797   2.721   4.862  1.00 72.74           C  
ATOM   6642  CG  GLN G  14      30.044   2.359   5.644  1.00 65.36           C  
ATOM   6643  CD  GLN G  14      30.987   1.463   4.860  1.00 65.36           C  
ATOM   6644  OE1 GLN G  14      30.581   0.786   3.909  1.00 65.36           O  
ATOM   6645  NE2 GLN G  14      32.251   1.436   5.270  1.00 65.36           N  
ATOM   6646  N   GLN G  15      27.740   3.108   1.747  1.00 72.27           N  
ATOM   6647  CA  GLN G  15      26.568   3.090   0.872  1.00 72.27           C  
ATOM   6648  C   GLN G  15      25.297   2.930   1.710  1.00 72.27           C  
ATOM   6649  O   GLN G  15      25.179   1.993   2.502  1.00 72.27           O  
ATOM   6650  CB  GLN G  15      26.677   1.941  -0.148  1.00 60.00           C  
ATOM   6651  CG  GLN G  15      25.389   1.640  -0.935  1.00 50.98           C  
ATOM   6652  CD  GLN G  15      25.658   1.037  -2.322  1.00 50.98           C  
ATOM   6653  OE1 GLN G  15      26.240  -0.042  -2.449  1.00 50.98           O  
ATOM   6654  NE2 GLN G  15      25.237   1.751  -3.371  1.00 50.98           N  
ATOM   6655  N   PRO G  16      24.340   3.863   1.567  1.00 54.08           N  
ATOM   6656  CA  PRO G  16      23.095   3.772   2.333  1.00 54.08           C  
ATOM   6657  C   PRO G  16      22.462   2.434   1.979  1.00 54.08           C  
ATOM   6658  O   PRO G  16      22.745   1.883   0.919  1.00 54.08           O  
ATOM   6659  CB  PRO G  16      22.278   4.953   1.810  1.00 42.80           C  
ATOM   6660  CG  PRO G  16      23.311   5.926   1.349  1.00 47.92           C  
ATOM   6661  CD  PRO G  16      24.324   5.039   0.680  1.00 47.92           C  
ATOM   6662  N   VAL G  17      21.602   1.906   2.836  1.00 51.49           N  
ATOM   6663  CA  VAL G  17      21.010   0.617   2.513  1.00 51.49           C  
ATOM   6664  C   VAL G  17      19.493   0.551   2.438  1.00 51.49           C  
ATOM   6665  O   VAL G  17      18.783   0.985   3.342  1.00 51.49           O  
ATOM   6666  CB  VAL G  17      21.484  -0.479   3.501  1.00 68.07           C  
ATOM   6667  CG1 VAL G  17      20.819  -1.803   3.169  1.00 68.07           C  
ATOM   6668  CG2 VAL G  17      22.988  -0.628   3.427  1.00 68.07           C  
ATOM   6669  N   LEU G  18      19.012   0.013   1.328  1.00 59.79           N  
ATOM   6670  CA  LEU G  18      17.590  -0.193   1.120  1.00 59.79           C  
ATOM   6671  C   LEU G  18      17.481  -1.617   0.601  1.00 59.79           C  
ATOM   6672  O   LEU G  18      17.663  -1.860  -0.589  1.00 59.79           O  
ATOM   6673  CB  LEU G  18      17.032   0.772   0.078  1.00 43.64           C  
ATOM   6674  CG  LEU G  18      15.542   0.596  -0.214  1.00 43.64           C  
ATOM   6675  CD1 LEU G  18      14.770   0.543   1.091  1.00 43.64           C  
ATOM   6676  CD2 LEU G  18      15.064   1.747  -1.082  1.00 43.64           C  
ATOM   6677  N   GLN G  19      17.221  -2.557   1.501  1.00 44.20           N  
ATOM   6678  CA  GLN G  19      17.095  -3.961   1.117  1.00 44.20           C  
ATOM   6679  C   GLN G  19      15.800  -4.624   1.591  1.00 44.20           C  
ATOM   6680  O   GLN G  19      15.277  -4.312   2.668  1.00 44.20           O  
ATOM   6681  CB  GLN G  19      18.292  -4.772   1.620  1.00 76.02           C  
ATOM   6682  CG  GLN G  19      19.502  -4.669   0.718  1.00 76.02           C  
ATOM   6683  CD  GLN G  19      19.206  -5.119  -0.701  1.00 76.02           C  
ATOM   6684  OE1 GLN G  19      20.003  -4.894  -1.612  1.00 76.02           O  
ATOM   6685  NE2 GLN G  19      18.059  -5.768  -0.895  1.00 76.02           N  
ATOM   6686  N   ILE G  20      15.283  -5.537   0.768  1.00 47.22           N  
ATOM   6687  CA  ILE G  20      14.044  -6.247   1.092  1.00 47.22           C  
ATOM   6688  C   ILE G  20      14.398  -7.505   1.858  1.00 47.22           C  
ATOM   6689  O   ILE G  20      15.093  -8.370   1.323  1.00 47.22           O  
ATOM   6690  CB  ILE G  20      13.265  -6.696  -0.174  1.00 40.30           C  
ATOM   6691  CG1 ILE G  20      12.799  -5.485  -0.972  1.00 40.30           C  
ATOM   6692  CG2 ILE G  20      12.045  -7.518   0.230  1.00 40.30           C  
ATOM   6693  CD1 ILE G  20      12.284  -5.846  -2.344  1.00 40.30           C  
ATOM   6694  N   GLN G  21      13.917  -7.609   3.098  1.00 44.65           N  
ATOM   6695  CA  GLN G  21      14.193  -8.783   3.932  1.00 44.65           C  
ATOM   6696  C   GLN G  21      13.170  -9.876   3.694  1.00 44.65           C  
ATOM   6697  O   GLN G  21      13.512 -11.047   3.519  1.00 44.65           O  
ATOM   6698  CB  GLN G  21      14.196  -8.405   5.415  1.00 71.45           C  
ATOM   6699  CG  GLN G  21      15.374  -7.533   5.812  1.00 71.45           C  
ATOM   6700  CD  GLN G  21      16.713  -8.173   5.477  1.00 71.45           C  
ATOM   6701  OE1 GLN G  21      17.075  -9.203   6.040  1.00 71.45           O  
ATOM   6702  NE2 GLN G  21      17.451  -7.564   4.551  1.00 71.45           N  
ATOM   6703  N   ARG G  22      11.902  -9.494   3.706  1.00 62.49           N  
ATOM   6704  CA  ARG G  22      10.850 -10.458   3.449  1.00 62.49           C  
ATOM   6705  C   ARG G  22       9.510  -9.799   3.165  1.00 62.49           C  
ATOM   6706  O   ARG G  22       9.187  -8.741   3.708  1.00 62.49           O  
ATOM   6707  CB  ARG G  22      10.725 -11.459   4.605  1.00 80.86           C  
ATOM   6708  CG  ARG G  22      10.081 -10.943   5.877  1.00 80.86           C  
ATOM   6709  CD  ARG G  22       9.499 -12.124   6.647  1.00 80.86           C  
ATOM   6710  NE  ARG G  22      10.498 -13.166   6.872  1.00 80.86           N  
ATOM   6711  CZ  ARG G  22      10.216 -14.435   7.146  1.00 80.86           C  
ATOM   6712  NH1 ARG G  22       8.958 -14.838   7.232  1.00 80.86           N  
ATOM   6713  NH2 ARG G  22      11.197 -15.307   7.328  1.00 80.86           N  
ATOM   6714  N   ILE G  23       8.747 -10.411   2.270  1.00 55.40           N  
ATOM   6715  CA  ILE G  23       7.435  -9.881   1.958  1.00 55.40           C  
ATOM   6716  C   ILE G  23       6.439 -10.947   2.316  1.00 55.40           C  
ATOM   6717  O   ILE G  23       6.595 -12.120   1.967  1.00 55.40           O  
ATOM   6718  CB  ILE G  23       7.297  -9.461   0.489  1.00 45.56           C  
ATOM   6719  CG1 ILE G  23       8.211  -8.253   0.221  1.00 45.56           C  
ATOM   6720  CG2 ILE G  23       5.849  -9.066   0.212  1.00 45.56           C  
ATOM   6721  CD1 ILE G  23       8.371  -7.898  -1.213  1.00 45.56           C  
ATOM   6722  N   TYR G  24       5.424 -10.526   3.050  1.00 58.63           N  
ATOM   6723  CA  TYR G  24       4.409 -11.442   3.529  1.00 58.63           C  
ATOM   6724  C   TYR G  24       3.064 -10.752   3.702  1.00 58.63           C  
ATOM   6725  O   TYR G  24       2.976  -9.523   3.701  1.00 58.63           O  
ATOM   6726  CB  TYR G  24       4.874 -12.045   4.872  1.00 53.03           C  
ATOM   6727  CG  TYR G  24       5.247 -11.019   5.942  1.00 53.03           C  
ATOM   6728  CD1 TYR G  24       4.265 -10.392   6.715  1.00 53.03           C  
ATOM   6729  CD2 TYR G  24       6.577 -10.641   6.149  1.00 53.03           C  
ATOM   6730  CE1 TYR G  24       4.596  -9.411   7.668  1.00 53.03           C  
ATOM   6731  CE2 TYR G  24       6.921  -9.659   7.095  1.00 53.03           C  
ATOM   6732  CZ  TYR G  24       5.924  -9.050   7.848  1.00 53.03           C  
ATOM   6733  OH  TYR G  24       6.245  -8.084   8.776  1.00 53.03           O  
ATOM   6734  N   VAL G  25       2.017 -11.549   3.848  1.00 48.81           N  
ATOM   6735  CA  VAL G  25       0.688 -11.000   4.050  1.00 48.81           C  
ATOM   6736  C   VAL G  25       0.335 -11.154   5.519  1.00 48.81           C  
ATOM   6737  O   VAL G  25       0.521 -12.220   6.101  1.00 48.81           O  
ATOM   6738  CB  VAL G  25      -0.379 -11.738   3.205  1.00 40.43           C  
ATOM   6739  CG1 VAL G  25      -1.765 -11.259   3.589  1.00 40.43           C  
ATOM   6740  CG2 VAL G  25      -0.137 -11.488   1.730  1.00 40.43           C  
ATOM   6741  N   LYS G  26      -0.176 -10.087   6.118  1.00 46.30           N  
ATOM   6742  CA  LYS G  26      -0.559 -10.128   7.524  1.00 46.30           C  
ATOM   6743  C   LYS G  26      -2.029 -10.500   7.676  1.00 46.30           C  
ATOM   6744  O   LYS G  26      -2.412 -11.178   8.629  1.00 46.30           O  
ATOM   6745  CB  LYS G  26      -0.302  -8.776   8.192  1.00 54.58           C  
ATOM   6746  CG  LYS G  26       1.153  -8.324   8.117  1.00 54.58           C  
ATOM   6747  CD  LYS G  26       1.420  -7.091   8.964  1.00 54.58           C  
ATOM   6748  CE  LYS G  26       1.361  -7.420  10.441  1.00 54.58           C  
ATOM   6749  NZ  LYS G  26       1.826  -6.264  11.234  1.00 54.58           N  
ATOM   6750  N   ASP G  27      -2.854 -10.050   6.737  1.00 68.80           N  
ATOM   6751  CA  ASP G  27      -4.280 -10.353   6.778  1.00 68.80           C  
ATOM   6752  C   ASP G  27      -4.907 -10.260   5.401  1.00 68.80           C  
ATOM   6753  O   ASP G  27      -4.553  -9.398   4.604  1.00 68.80           O  
ATOM   6754  CB  ASP G  27      -5.008  -9.405   7.735  1.00 50.24           C  
ATOM   6755  CG  ASP G  27      -6.449  -9.832   7.996  1.00 50.24           C  
ATOM   6756  OD1 ASP G  27      -6.772 -11.019   7.774  1.00 50.24           O  
ATOM   6757  OD2 ASP G  27      -7.259  -8.993   8.439  1.00 50.24           O  
ATOM   6758  N   VAL G  28      -5.828 -11.172   5.119  1.00 60.33           N  
ATOM   6759  CA  VAL G  28      -6.519 -11.172   3.840  1.00 60.33           C  
ATOM   6760  C   VAL G  28      -7.970 -11.558   4.050  1.00 60.33           C  
ATOM   6761  O   VAL G  28      -8.303 -12.370   4.913  1.00 60.33           O  
ATOM   6762  CB  VAL G  28      -5.877 -12.133   2.820  1.00 51.63           C  
ATOM   6763  CG1 VAL G  28      -6.201 -13.563   3.163  1.00 51.63           C  
ATOM   6764  CG2 VAL G  28      -6.374 -11.794   1.427  1.00 51.63           C  
ATOM   6765  N   SER G  29      -8.833 -10.965   3.246  1.00 58.38           N  
ATOM   6766  CA  SER G  29     -10.254 -11.203   3.363  1.00 58.38           C  
ATOM   6767  C   SER G  29     -10.932 -11.009   2.016  1.00 58.38           C  
ATOM   6768  O   SER G  29     -10.702 -10.008   1.335  1.00 58.38           O  
ATOM   6769  CB  SER G  29     -10.823 -10.219   4.391  1.00 40.02           C  
ATOM   6770  OG  SER G  29     -12.237 -10.206   4.412  1.00 40.02           O  
ATOM   6771  N   PHE G  30     -11.743 -11.986   1.619  1.00 51.97           N  
ATOM   6772  CA  PHE G  30     -12.496 -11.902   0.367  1.00 51.97           C  
ATOM   6773  C   PHE G  30     -13.900 -12.406   0.646  1.00 51.97           C  
ATOM   6774  O   PHE G  30     -14.083 -13.493   1.175  1.00 51.97           O  
ATOM   6775  CB  PHE G  30     -11.877 -12.758  -0.733  1.00 65.51           C  
ATOM   6776  CG  PHE G  30     -12.603 -12.654  -2.041  1.00 65.51           C  
ATOM   6777  CD1 PHE G  30     -12.508 -11.500  -2.812  1.00 65.51           C  
ATOM   6778  CD2 PHE G  30     -13.421 -13.685  -2.484  1.00 65.51           C  
ATOM   6779  CE1 PHE G  30     -13.218 -11.377  -4.009  1.00 65.51           C  
ATOM   6780  CE2 PHE G  30     -14.134 -13.571  -3.677  1.00 65.51           C  
ATOM   6781  CZ  PHE G  30     -14.031 -12.414  -4.439  1.00 65.51           C  
ATOM   6782  N   GLU G  31     -14.898 -11.628   0.271  1.00 59.77           N  
ATOM   6783  CA  GLU G  31     -16.264 -12.026   0.538  1.00 59.77           C  
ATOM   6784  C   GLU G  31     -17.173 -11.751  -0.655  1.00 59.77           C  
ATOM   6785  O   GLU G  31     -17.113 -10.683  -1.259  1.00 59.77           O  
ATOM   6786  CB  GLU G  31     -16.740 -11.257   1.761  1.00 74.90           C  
ATOM   6787  CG  GLU G  31     -18.003 -11.744   2.391  1.00 74.90           C  
ATOM   6788  CD  GLU G  31     -18.504 -10.748   3.412  1.00 74.90           C  
ATOM   6789  OE1 GLU G  31     -17.716 -10.378   4.314  1.00 74.90           O  
ATOM   6790  OE2 GLU G  31     -19.677 -10.328   3.304  1.00 74.90           O  
ATOM   6791  N   ALA G  32     -17.998 -12.736  -1.000  1.00 45.44           N  
ATOM   6792  CA  ALA G  32     -18.964 -12.631  -2.098  1.00 45.44           C  
ATOM   6793  C   ALA G  32     -20.271 -13.186  -1.538  1.00 45.44           C  
ATOM   6794  O   ALA G  32     -20.618 -14.343  -1.755  1.00 45.44           O  
ATOM   6795  CB  ALA G  32     -18.502 -13.447  -3.283  1.00 20.87           C  
ATOM   6796  N   PRO G  33     -21.005 -12.351  -0.798  1.00 67.83           N  
ATOM   6797  CA  PRO G  33     -22.281 -12.619  -0.130  1.00 67.83           C  
ATOM   6798  C   PRO G  33     -23.406 -13.159  -0.987  1.00 67.83           C  
ATOM   6799  O   PRO G  33     -24.026 -14.159  -0.648  1.00 67.83           O  
ATOM   6800  CB  PRO G  33     -22.663 -11.258   0.449  1.00 53.87           C  
ATOM   6801  CG  PRO G  33     -21.372 -10.547   0.565  1.00 53.87           C  
ATOM   6802  CD  PRO G  33     -20.697 -10.918  -0.716  1.00 53.87           C  
ATOM   6803  N   ASN G  34     -23.668 -12.480  -2.097  1.00 51.05           N  
ATOM   6804  CA  ASN G  34     -24.768 -12.840  -2.975  1.00 51.05           C  
ATOM   6805  C   ASN G  34     -24.504 -13.830  -4.091  1.00 51.05           C  
ATOM   6806  O   ASN G  34     -24.954 -13.627  -5.213  1.00 51.05           O  
ATOM   6807  CB  ASN G  34     -25.372 -11.573  -3.571  1.00 74.94           C  
ATOM   6808  CG  ASN G  34     -25.951 -10.670  -2.520  1.00 74.94           C  
ATOM   6809  OD1 ASN G  34     -26.911 -11.035  -1.840  1.00 74.94           O  
ATOM   6810  ND2 ASN G  34     -25.368  -9.486  -2.362  1.00 74.94           N  
ATOM   6811  N   LEU G  35     -23.785 -14.905  -3.798  1.00 64.51           N  
ATOM   6812  CA  LEU G  35     -23.536 -15.922  -4.814  1.00 64.51           C  
ATOM   6813  C   LEU G  35     -24.488 -17.083  -4.568  1.00 64.51           C  
ATOM   6814  O   LEU G  35     -24.861 -17.352  -3.429  1.00 64.51           O  
ATOM   6815  CB  LEU G  35     -22.105 -16.446  -4.736  1.00 72.14           C  
ATOM   6816  CG  LEU G  35     -20.972 -15.475  -5.051  1.00 72.14           C  
ATOM   6817  CD1 LEU G  35     -19.667 -16.242  -5.040  1.00 72.14           C  
ATOM   6818  CD2 LEU G  35     -21.192 -14.834  -6.406  1.00 72.14           C  
ATOM   6819  N   PRO G  36     -24.910 -17.778  -5.630  1.00 55.75           N  
ATOM   6820  CA  PRO G  36     -24.533 -17.509  -7.021  1.00 55.75           C  
ATOM   6821  C   PRO G  36     -25.510 -16.639  -7.826  1.00 55.75           C  
ATOM   6822  O   PRO G  36     -25.248 -16.330  -8.986  1.00 55.75           O  
ATOM   6823  CB  PRO G  36     -24.393 -18.908  -7.613  1.00 46.14           C  
ATOM   6824  CG  PRO G  36     -25.453 -19.659  -6.905  1.00 46.14           C  
ATOM   6825  CD  PRO G  36     -25.308 -19.190  -5.469  1.00 46.14           C  
ATOM   6826  N   HIS G  37     -26.620 -16.230  -7.222  1.00 56.20           N  
ATOM   6827  CA  HIS G  37     -27.587 -15.420  -7.950  1.00 56.20           C  
ATOM   6828  C   HIS G  37     -27.073 -14.096  -8.514  1.00 56.20           C  
ATOM   6829  O   HIS G  37     -27.559 -13.647  -9.544  1.00 56.20           O  
ATOM   6830  CB  HIS G  37     -28.827 -15.165  -7.094  1.00 58.06           C  
ATOM   6831  CG  HIS G  37     -28.523 -14.851  -5.667  1.00 58.06           C  
ATOM   6832  ND1 HIS G  37     -28.089 -15.808  -4.774  1.00 58.06           N  
ATOM   6833  CD2 HIS G  37     -28.581 -13.687  -4.977  1.00 58.06           C  
ATOM   6834  CE1 HIS G  37     -27.893 -15.246  -3.595  1.00 58.06           C  
ATOM   6835  NE2 HIS G  37     -28.184 -13.960  -3.691  1.00 58.06           N  
ATOM   6836  N   ILE G  38     -26.102 -13.470  -7.862  1.00 48.54           N  
ATOM   6837  CA  ILE G  38     -25.564 -12.190  -8.348  1.00 48.54           C  
ATOM   6838  C   ILE G  38     -25.101 -12.331  -9.802  1.00 48.54           C  
ATOM   6839  O   ILE G  38     -25.091 -11.361 -10.567  1.00 48.54           O  
ATOM   6840  CB  ILE G  38     -24.348 -11.731  -7.491  1.00 47.79           C  
ATOM   6841  CG1 ILE G  38     -23.961 -10.296  -7.828  1.00 47.79           C  
ATOM   6842  CG2 ILE G  38     -23.163 -12.628  -7.755  1.00 47.79           C  
ATOM   6843  CD1 ILE G  38     -24.900  -9.279  -7.258  1.00 47.79           C  
ATOM   6844  N   PHE G  39     -24.724 -13.553 -10.172  1.00 48.57           N  
ATOM   6845  CA  PHE G  39     -24.233 -13.838 -11.516  1.00 48.57           C  
ATOM   6846  C   PHE G  39     -25.305 -13.666 -12.575  1.00 48.57           C  
ATOM   6847  O   PHE G  39     -25.018 -13.722 -13.768  1.00 48.57           O  
ATOM   6848  CB  PHE G  39     -23.684 -15.268 -11.590  1.00 67.41           C  
ATOM   6849  CG  PHE G  39     -22.360 -15.464 -10.885  1.00 67.41           C  
ATOM   6850  CD1 PHE G  39     -22.040 -16.694 -10.318  1.00 67.41           C  
ATOM   6851  CD2 PHE G  39     -21.427 -14.442 -10.812  1.00 67.41           C  
ATOM   6852  CE1 PHE G  39     -20.818 -16.904  -9.690  1.00 67.41           C  
ATOM   6853  CE2 PHE G  39     -20.196 -14.647 -10.181  1.00 67.41           C  
ATOM   6854  CZ  PHE G  39     -19.898 -15.884  -9.622  1.00 67.41           C  
ATOM   6855  N   GLN G  40     -26.540 -13.451 -12.143  1.00 66.35           N  
ATOM   6856  CA  GLN G  40     -27.659 -13.302 -13.065  1.00 66.35           C  
ATOM   6857  C   GLN G  40     -27.928 -11.840 -13.390  1.00 66.35           C  
ATOM   6858  O   GLN G  40     -28.666 -11.529 -14.319  1.00 66.35           O  
ATOM   6859  CB  GLN G  40     -28.904 -13.935 -12.455  1.00 95.69           C  
ATOM   6860  CG  GLN G  40     -30.018 -14.190 -13.433  1.00 95.69           C  
ATOM   6861  CD  GLN G  40     -31.243 -14.741 -12.750  1.00 95.69           C  
ATOM   6862  OE1 GLN G  40     -31.937 -14.023 -12.029  1.00 95.69           O  
ATOM   6863  NE2 GLN G  40     -31.509 -16.028 -12.955  1.00 95.69           N  
ATOM   6864  N   GLN G  41     -27.328 -10.947 -12.615  1.00 49.17           N  
ATOM   6865  CA  GLN G  41     -27.491  -9.510 -12.827  1.00 49.17           C  
ATOM   6866  C   GLN G  41     -26.583  -9.054 -13.951  1.00 49.17           C  
ATOM   6867  O   GLN G  41     -25.609  -9.725 -14.277  1.00 49.17           O  
ATOM   6868  CB  GLN G  41     -27.136  -8.734 -11.553  1.00 41.49           C  
ATOM   6869  CG  GLN G  41     -28.160  -8.892 -10.470  1.00 41.49           C  
ATOM   6870  CD  GLN G  41     -27.813  -8.144  -9.207  1.00 41.49           C  
ATOM   6871  OE1 GLN G  41     -27.480  -6.960  -9.237  1.00 41.49           O  
ATOM   6872  NE2 GLN G  41     -27.909  -8.833  -8.078  1.00 41.49           N  
ATOM   6873  N   GLU G  42     -26.897  -7.920 -14.556  1.00 77.24           N  
ATOM   6874  CA  GLU G  42     -26.049  -7.430 -15.622  1.00 77.24           C  
ATOM   6875  C   GLU G  42     -24.795  -6.881 -14.949  1.00 77.24           C  
ATOM   6876  O   GLU G  42     -24.878  -6.072 -14.018  1.00 77.24           O  
ATOM   6877  CB  GLU G  42     -26.763  -6.346 -16.427  1.00 85.79           C  
ATOM   6878  CG  GLU G  42     -28.114  -6.780 -16.980  1.00 85.79           C  
ATOM   6879  CD  GLU G  42     -28.549  -5.947 -18.170  1.00 85.79           C  
ATOM   6880  OE1 GLU G  42     -28.016  -6.177 -19.279  1.00 85.79           O  
ATOM   6881  OE2 GLU G  42     -29.411  -5.058 -17.995  1.00 85.79           O  
ATOM   6882  N   TRP G  43     -23.633  -7.334 -15.410  1.00 45.57           N  
ATOM   6883  CA  TRP G  43     -22.371  -6.903 -14.820  1.00 45.57           C  
ATOM   6884  C   TRP G  43     -21.999  -5.460 -15.137  1.00 45.57           C  
ATOM   6885  O   TRP G  43     -21.227  -5.190 -16.046  1.00 45.57           O  
ATOM   6886  CB  TRP G  43     -21.235  -7.849 -15.241  1.00 50.13           C  
ATOM   6887  CG  TRP G  43     -19.949  -7.593 -14.517  1.00 50.13           C  
ATOM   6888  CD1 TRP G  43     -18.831  -6.990 -15.017  1.00 50.13           C  
ATOM   6889  CD2 TRP G  43     -19.669  -7.879 -13.142  1.00 50.13           C  
ATOM   6890  NE1 TRP G  43     -17.876  -6.880 -14.039  1.00 50.13           N  
ATOM   6891  CE2 TRP G  43     -18.367  -7.418 -12.878  1.00 50.13           C  
ATOM   6892  CE3 TRP G  43     -20.398  -8.479 -12.104  1.00 50.13           C  
ATOM   6893  CZ2 TRP G  43     -17.772  -7.538 -11.620  1.00 50.13           C  
ATOM   6894  CZ3 TRP G  43     -19.806  -8.597 -10.848  1.00 50.13           C  
ATOM   6895  CH2 TRP G  43     -18.506  -8.129 -10.619  1.00 50.13           C  
ATOM   6896  N   LYS G  44     -22.567  -4.534 -14.381  1.00 44.75           N  
ATOM   6897  CA  LYS G  44     -22.274  -3.120 -14.549  1.00 44.75           C  
ATOM   6898  C   LYS G  44     -21.688  -2.736 -13.196  1.00 44.75           C  
ATOM   6899  O   LYS G  44     -22.375  -2.189 -12.326  1.00 44.75           O  
ATOM   6900  CB  LYS G  44     -23.562  -2.350 -14.841  1.00 77.86           C  
ATOM   6901  CG  LYS G  44     -24.350  -2.911 -16.014  1.00 77.86           C  
ATOM   6902  CD  LYS G  44     -25.621  -2.119 -16.280  1.00 77.86           C  
ATOM   6903  CE  LYS G  44     -26.440  -2.759 -17.393  1.00 77.86           C  
ATOM   6904  NZ  LYS G  44     -27.734  -2.059 -17.604  1.00 77.86           N  
ATOM   6905  N   PRO G  45     -20.397  -3.049 -12.994  1.00 52.14           N  
ATOM   6906  CA  PRO G  45     -19.634  -2.793 -11.769  1.00 52.14           C  
ATOM   6907  C   PRO G  45     -19.276  -1.377 -11.364  1.00 52.14           C  
ATOM   6908  O   PRO G  45     -18.945  -0.544 -12.201  1.00 52.14           O  
ATOM   6909  CB  PRO G  45     -18.388  -3.646 -11.967  1.00 45.72           C  
ATOM   6910  CG  PRO G  45     -18.169  -3.574 -13.444  1.00 45.72           C  
ATOM   6911  CD  PRO G  45     -19.573  -3.785 -13.972  1.00 45.72           C  
ATOM   6912  N   LYS G  46     -19.353  -1.128 -10.057  1.00 53.33           N  
ATOM   6913  CA  LYS G  46     -18.984   0.152  -9.448  1.00 53.33           C  
ATOM   6914  C   LYS G  46     -17.927  -0.208  -8.414  1.00 53.33           C  
ATOM   6915  O   LYS G  46     -18.219  -0.858  -7.408  1.00 53.33           O  
ATOM   6916  CB  LYS G  46     -20.174   0.824  -8.759  1.00 86.85           C  
ATOM   6917  CG  LYS G  46     -21.107   1.543  -9.718  1.00 86.85           C  
ATOM   6918  CD  LYS G  46     -20.370   2.599 -10.541  1.00 86.85           C  
ATOM   6919  CE  LYS G  46     -21.200   3.051 -11.741  1.00 86.85           C  
ATOM   6920  NZ  LYS G  46     -22.532   3.598 -11.353  1.00 86.85           N  
ATOM   6921  N   LEU G  47     -16.695   0.211  -8.676  1.00 50.96           N  
ATOM   6922  CA  LEU G  47     -15.579  -0.103  -7.797  1.00 50.96           C  
ATOM   6923  C   LEU G  47     -15.212   0.937  -6.749  1.00 50.96           C  
ATOM   6924  O   LEU G  47     -14.986   2.099  -7.068  1.00 50.96           O  
ATOM   6925  CB  LEU G  47     -14.331  -0.419  -8.636  1.00 36.08           C  
ATOM   6926  CG  LEU G  47     -12.985  -0.411  -7.899  1.00 36.08           C  
ATOM   6927  CD1 LEU G  47     -12.975  -1.520  -6.855  1.00 36.08           C  
ATOM   6928  CD2 LEU G  47     -11.840  -0.598  -8.892  1.00 36.08           C  
ATOM   6929  N   GLY G  48     -15.148   0.487  -5.498  1.00 52.71           N  
ATOM   6930  CA  GLY G  48     -14.761   1.336  -4.384  1.00 52.71           C  
ATOM   6931  C   GLY G  48     -13.368   0.881  -3.971  1.00 52.71           C  
ATOM   6932  O   GLY G  48     -13.172  -0.293  -3.640  1.00 52.71           O  
ATOM   6933  N   PHE G  49     -12.401   1.798  -3.990  1.00 73.46           N  
ATOM   6934  CA  PHE G  49     -11.013   1.467  -3.667  1.00 73.46           C  
ATOM   6935  C   PHE G  49     -10.419   2.339  -2.578  1.00 73.46           C  
ATOM   6936  O   PHE G  49     -10.288   3.550  -2.744  1.00 73.46           O  
ATOM   6937  CB  PHE G  49     -10.161   1.586  -4.938  1.00 68.21           C  
ATOM   6938  CG  PHE G  49      -8.681   1.428  -4.713  1.00 68.21           C  
ATOM   6939  CD1 PHE G  49      -8.169   0.289  -4.110  1.00 68.21           C  
ATOM   6940  CD2 PHE G  49      -7.798   2.409  -5.140  1.00 68.21           C  
ATOM   6941  CE1 PHE G  49      -6.801   0.131  -3.937  1.00 68.21           C  
ATOM   6942  CE2 PHE G  49      -6.431   2.259  -4.970  1.00 68.21           C  
ATOM   6943  CZ  PHE G  49      -5.933   1.119  -4.369  1.00 68.21           C  
ATOM   6944  N   ASP G  50     -10.046   1.719  -1.465  1.00 71.33           N  
ATOM   6945  CA  ASP G  50      -9.444   2.453  -0.361  1.00 71.33           C  
ATOM   6946  C   ASP G  50      -8.005   1.972  -0.182  1.00 71.33           C  
ATOM   6947  O   ASP G  50      -7.721   0.786  -0.363  1.00 71.33           O  
ATOM   6948  CB  ASP G  50     -10.254   2.233   0.916  1.00 90.70           C  
ATOM   6949  CG  ASP G  50     -10.486   3.522   1.687  1.00 90.70           C  
ATOM   6950  OD1 ASP G  50      -9.495   4.123   2.161  1.00 90.70           O  
ATOM   6951  OD2 ASP G  50     -11.660   3.936   1.811  1.00 90.70           O  
ATOM   6952  N   LEU G  51      -7.104   2.889   0.168  1.00 57.50           N  
ATOM   6953  CA  LEU G  51      -5.692   2.550   0.331  1.00 57.50           C  
ATOM   6954  C   LEU G  51      -4.987   3.388   1.398  1.00 57.50           C  
ATOM   6955  O   LEU G  51      -5.313   4.553   1.602  1.00 57.50           O  
ATOM   6956  CB  LEU G  51      -4.982   2.708  -1.023  1.00 45.96           C  
ATOM   6957  CG  LEU G  51      -3.486   2.396  -1.127  1.00 45.96           C  
ATOM   6958  CD1 LEU G  51      -3.111   2.108  -2.579  1.00 45.96           C  
ATOM   6959  CD2 LEU G  51      -2.676   3.568  -0.576  1.00 45.96           C  
ATOM   6960  N   SER G  52      -4.016   2.783   2.076  1.00 62.25           N  
ATOM   6961  CA  SER G  52      -3.255   3.465   3.118  1.00 62.25           C  
ATOM   6962  C   SER G  52      -2.049   2.623   3.519  1.00 62.25           C  
ATOM   6963  O   SER G  52      -2.032   1.413   3.299  1.00 62.25           O  
ATOM   6964  CB  SER G  52      -4.135   3.714   4.348  1.00 61.97           C  
ATOM   6965  OG  SER G  52      -4.408   2.503   5.033  1.00 61.97           O  
ATOM   6966  N   THR G  53      -1.041   3.268   4.101  1.00 56.45           N  
ATOM   6967  CA  THR G  53       0.164   2.566   4.533  1.00 56.45           C  
ATOM   6968  C   THR G  53       0.503   2.942   5.964  1.00 56.45           C  
ATOM   6969  O   THR G  53       0.029   3.951   6.475  1.00 56.45           O  
ATOM   6970  CB  THR G  53       1.412   2.899   3.637  1.00 57.23           C  
ATOM   6971  OG1 THR G  53       1.725   4.295   3.724  1.00 57.23           O  
ATOM   6972  CG2 THR G  53       1.157   2.544   2.183  1.00 57.23           C  
ATOM   6973  N   GLU G  54       1.312   2.114   6.611  1.00 61.83           N  
ATOM   6974  CA  GLU G  54       1.746   2.369   7.973  1.00 61.83           C  
ATOM   6975  C   GLU G  54       3.073   1.663   8.198  1.00 61.83           C  
ATOM   6976  O   GLU G  54       3.309   0.587   7.649  1.00 61.83           O  
ATOM   6977  CB  GLU G  54       0.691   1.904   8.979  1.00 82.83           C  
ATOM   6978  CG  GLU G  54       0.154   0.515   8.754  1.00 82.83           C  
ATOM   6979  CD  GLU G  54      -0.784   0.095   9.866  1.00 82.83           C  
ATOM   6980  OE1 GLU G  54      -0.318  -0.008  11.023  1.00 82.83           O  
ATOM   6981  OE2 GLU G  54      -1.984  -0.123   9.587  1.00 82.83           O  
ATOM   6982  N   THR G  55       3.944   2.280   8.993  1.00 62.54           N  
ATOM   6983  CA  THR G  55       5.272   1.732   9.264  1.00 62.54           C  
ATOM   6984  C   THR G  55       5.512   1.429  10.733  1.00 62.54           C  
ATOM   6985  O   THR G  55       4.905   2.034  11.610  1.00 62.54           O  
ATOM   6986  CB  THR G  55       6.378   2.716   8.792  1.00 64.54           C  
ATOM   6987  OG1 THR G  55       6.396   2.773   7.361  1.00 64.54           O  
ATOM   6988  CG2 THR G  55       7.745   2.282   9.292  1.00 64.54           C  
ATOM   6989  N   THR G  56       6.407   0.485  10.991  1.00 70.55           N  
ATOM   6990  CA  THR G  56       6.760   0.113  12.349  1.00 70.55           C  
ATOM   6991  C   THR G  56       8.195  -0.370  12.360  1.00 70.55           C  
ATOM   6992  O   THR G  56       8.556  -1.265  11.593  1.00 70.55           O  
ATOM   6993  CB  THR G  56       5.883  -1.027  12.884  1.00 60.02           C  
ATOM   6994  OG1 THR G  56       4.538  -0.565  13.011  1.00 60.02           O  
ATOM   6995  CG2 THR G  56       6.378  -1.489  14.245  1.00 60.02           C  
ATOM   6996  N   GLN G  57       9.020   0.226  13.214  1.00 75.12           N  
ATOM   6997  CA  GLN G  57      10.403  -0.208  13.299  1.00 75.12           C  
ATOM   6998  C   GLN G  57      10.347  -1.517  14.067  1.00 75.12           C  
ATOM   6999  O   GLN G  57       9.776  -1.581  15.153  1.00 75.12           O  
ATOM   7000  CB  GLN G  57      11.260   0.822  14.035  1.00 98.07           C  
ATOM   7001  CG  GLN G  57      12.742   0.484  14.022  1.00 98.07           C  
ATOM   7002  CD  GLN G  57      13.626   1.678  14.326  1.00 98.07           C  
ATOM   7003  OE1 GLN G  57      14.852   1.570  14.323  1.00 98.07           O  
ATOM   7004  NE2 GLN G  57      13.008   2.823  14.588  1.00 98.07           N  
ATOM   7005  N   VAL G  58      10.921  -2.565  13.489  1.00 71.30           N  
ATOM   7006  CA  VAL G  58      10.896  -3.875  14.118  1.00 71.30           C  
ATOM   7007  C   VAL G  58      12.292  -4.346  14.521  1.00 71.30           C  
ATOM   7008  O   VAL G  58      12.474  -5.486  14.953  1.00 71.30           O  
ATOM   7009  CB  VAL G  58      10.244  -4.924  13.170  1.00 72.84           C  
ATOM   7010  CG1 VAL G  58      11.139  -5.166  11.961  1.00 72.84           C  
ATOM   7011  CG2 VAL G  58       9.976  -6.226  13.923  1.00 72.84           C  
ATOM   7012  N   GLY G  59      13.271  -3.460  14.383  1.00 67.00           N  
ATOM   7013  CA  GLY G  59      14.636  -3.802  14.737  1.00 67.00           C  
ATOM   7014  C   GLY G  59      15.566  -2.660  14.391  1.00 67.00           C  
ATOM   7015  O   GLY G  59      15.106  -1.574  14.036  1.00 67.00           O  
ATOM   7016  N   ASP G  60      16.872  -2.878  14.508  1.00 81.16           N  
ATOM   7017  CA  ASP G  60      17.822  -1.826  14.170  1.00 81.16           C  
ATOM   7018  C   ASP G  60      17.912  -1.774  12.652  1.00 81.16           C  
ATOM   7019  O   ASP G  60      18.328  -2.738  12.011  1.00 81.16           O  
ATOM   7020  CB  ASP G  60      19.196  -2.098  14.800  1.00165.16           C  
ATOM   7021  CG  ASP G  60      19.693  -3.506  14.548  1.00165.16           C  
ATOM   7022  OD1 ASP G  60      19.018  -4.463  14.983  1.00165.16           O  
ATOM   7023  OD2 ASP G  60      20.763  -3.654  13.921  1.00165.16           O  
ATOM   7024  N   ASP G  61      17.490  -0.651  12.080  1.00110.16           N  
ATOM   7025  CA  ASP G  61      17.501  -0.487  10.631  1.00110.16           C  
ATOM   7026  C   ASP G  61      16.478  -1.383   9.946  1.00110.16           C  
ATOM   7027  O   ASP G  61      16.482  -1.509   8.723  1.00110.16           O  
ATOM   7028  CB  ASP G  61      18.879  -0.812  10.065  1.00 72.86           C  
ATOM   7029  CG  ASP G  61      19.851   0.314  10.240  1.00 72.86           C  
ATOM   7030  OD1 ASP G  61      21.024   0.135   9.855  1.00 72.86           O  
ATOM   7031  OD2 ASP G  61      19.443   1.376  10.755  1.00 72.86           O  
ATOM   7032  N   LEU G  62      15.622  -2.027  10.731  1.00 69.08           N  
ATOM   7033  CA  LEU G  62      14.600  -2.891  10.166  1.00 69.08           C  
ATOM   7034  C   LEU G  62      13.218  -2.308  10.394  1.00 69.08           C  
ATOM   7035  O   LEU G  62      12.799  -2.065  11.531  1.00 69.08           O  
ATOM   7036  CB  LEU G  62      14.682  -4.308  10.747  1.00 43.65           C  
ATOM   7037  CG  LEU G  62      15.831  -5.185  10.227  1.00 43.65           C  
ATOM   7038  CD1 LEU G  62      15.379  -6.637  10.249  1.00 43.65           C  
ATOM   7039  CD2 LEU G  62      16.231  -4.792   8.799  1.00 43.65           C  
ATOM   7040  N   TYR G  63      12.513  -2.078   9.292  1.00 54.16           N  
ATOM   7041  CA  TYR G  63      11.178  -1.515   9.356  1.00 54.16           C  
ATOM   7042  C   TYR G  63      10.180  -2.404   8.632  1.00 54.16           C  
ATOM   7043  O   TYR G  63      10.495  -2.991   7.593  1.00 54.16           O  
ATOM   7044  CB  TYR G  63      11.177  -0.116   8.734  1.00 83.73           C  
ATOM   7045  CG  TYR G  63      12.299   0.775   9.229  1.00 83.73           C  
ATOM   7046  CD1 TYR G  63      13.618   0.564   8.815  1.00 83.73           C  
ATOM   7047  CD2 TYR G  63      12.045   1.822  10.117  1.00 83.73           C  
ATOM   7048  CE1 TYR G  63      14.657   1.371   9.271  1.00 83.73           C  
ATOM   7049  CE2 TYR G  63      13.077   2.637  10.582  1.00 83.73           C  
ATOM   7050  CZ  TYR G  63      14.382   2.407  10.154  1.00 83.73           C  
ATOM   7051  OH  TYR G  63      15.406   3.212  10.607  1.00 83.73           O  
ATOM   7052  N   GLU G  64       8.989  -2.528   9.210  1.00 56.22           N  
ATOM   7053  CA  GLU G  64       7.920  -3.308   8.597  1.00 56.22           C  
ATOM   7054  C   GLU G  64       6.985  -2.295   7.963  1.00 56.22           C  
ATOM   7055  O   GLU G  64       6.370  -1.491   8.668  1.00 56.22           O  
ATOM   7056  CB  GLU G  64       7.126  -4.103   9.640  1.00 46.84           C  
ATOM   7057  CG  GLU G  64       5.940  -4.873   9.034  1.00 46.84           C  
ATOM   7058  CD  GLU G  64       4.924  -5.358  10.071  1.00 46.84           C  
ATOM   7059  OE1 GLU G  64       4.339  -4.503  10.781  1.00 46.84           O  
ATOM   7060  OE2 GLU G  64       4.711  -6.591  10.165  1.00 46.84           O  
ATOM   7061  N   VAL G  65       6.894  -2.307   6.638  1.00 54.70           N  
ATOM   7062  CA  VAL G  65       5.990  -1.392   5.955  1.00 54.70           C  
ATOM   7063  C   VAL G  65       4.744  -2.183   5.550  1.00 54.70           C  
ATOM   7064  O   VAL G  65       4.842  -3.241   4.921  1.00 54.70           O  
ATOM   7065  CB  VAL G  65       6.654  -0.765   4.717  1.00 68.42           C  
ATOM   7066  CG1 VAL G  65       5.758   0.326   4.137  1.00 68.42           C  
ATOM   7067  CG2 VAL G  65       8.010  -0.193   5.101  1.00 68.42           C  
ATOM   7068  N   VAL G  66       3.575  -1.677   5.931  1.00 57.39           N  
ATOM   7069  CA  VAL G  66       2.316  -2.349   5.629  1.00 57.39           C  
ATOM   7070  C   VAL G  66       1.439  -1.563   4.666  1.00 57.39           C  
ATOM   7071  O   VAL G  66       1.173  -0.384   4.882  1.00 57.39           O  
ATOM   7072  CB  VAL G  66       1.505  -2.601   6.919  1.00 71.53           C  
ATOM   7073  CG1 VAL G  66       0.176  -3.259   6.586  1.00 71.53           C  
ATOM   7074  CG2 VAL G  66       2.304  -3.477   7.864  1.00 71.53           C  
ATOM   7075  N   LEU G  67       1.003  -2.223   3.595  1.00 65.30           N  
ATOM   7076  CA  LEU G  67       0.126  -1.594   2.609  1.00 65.30           C  
ATOM   7077  C   LEU G  67      -1.272  -2.156   2.800  1.00 65.30           C  
ATOM   7078  O   LEU G  67      -1.490  -3.364   2.699  1.00 65.30           O  
ATOM   7079  CB  LEU G  67       0.603  -1.870   1.179  1.00 54.08           C  
ATOM   7080  CG  LEU G  67      -0.259  -1.305   0.040  1.00 54.08           C  
ATOM   7081  CD1 LEU G  67      -0.489   0.191   0.227  1.00 54.08           C  
ATOM   7082  CD2 LEU G  67       0.430  -1.585  -1.300  1.00 54.08           C  
ATOM   7083  N   ASN G  68      -2.216  -1.275   3.098  1.00 65.66           N  
ATOM   7084  CA  ASN G  68      -3.596  -1.680   3.311  1.00 65.66           C  
ATOM   7085  C   ASN G  68      -4.423  -1.334   2.093  1.00 65.66           C  
ATOM   7086  O   ASN G  68      -4.491  -0.181   1.686  1.00 65.66           O  
ATOM   7087  CB  ASN G  68      -4.180  -0.967   4.526  1.00 83.12           C  
ATOM   7088  CG  ASN G  68      -3.421  -1.270   5.788  1.00 83.12           C  
ATOM   7089  OD1 ASN G  68      -3.293  -2.427   6.178  1.00 83.12           O  
ATOM   7090  ND2 ASN G  68      -2.904  -0.231   6.437  1.00 83.12           N  
ATOM   7091  N   ILE G  69      -5.048  -2.343   1.507  1.00 55.65           N  
ATOM   7092  CA  ILE G  69      -5.879  -2.119   0.343  1.00 55.65           C  
ATOM   7093  C   ILE G  69      -7.256  -2.717   0.558  1.00 55.65           C  
ATOM   7094  O   ILE G  69      -7.399  -3.868   0.953  1.00 55.65           O  
ATOM   7095  CB  ILE G  69      -5.220  -2.698  -0.929  1.00 45.26           C  
ATOM   7096  CG1 ILE G  69      -4.110  -1.741  -1.388  1.00 45.26           C  
ATOM   7097  CG2 ILE G  69      -6.268  -2.926  -2.013  1.00 45.26           C  
ATOM   7098  CD1 ILE G  69      -3.479  -2.078  -2.730  1.00 45.26           C  
ATOM   7099  N   SER G  70      -8.272  -1.904   0.323  1.00 70.61           N  
ATOM   7100  CA  SER G  70      -9.642  -2.346   0.486  1.00 70.61           C  
ATOM   7101  C   SER G  70     -10.354  -2.097  -0.838  1.00 70.61           C  
ATOM   7102  O   SER G  70     -10.252  -1.018  -1.428  1.00 70.61           O  
ATOM   7103  CB  SER G  70     -10.304  -1.568   1.623  1.00 89.20           C  
ATOM   7104  OG  SER G  70     -11.559  -2.122   1.961  1.00 89.20           O  
ATOM   7105  N   VAL G  71     -11.062  -3.108  -1.313  1.00 50.37           N  
ATOM   7106  CA  VAL G  71     -11.767  -2.998  -2.579  1.00 50.37           C  
ATOM   7107  C   VAL G  71     -13.185  -3.560  -2.471  1.00 50.37           C  
ATOM   7108  O   VAL G  71     -13.396  -4.654  -1.953  1.00 50.37           O  
ATOM   7109  CB  VAL G  71     -10.950  -3.725  -3.712  1.00 47.87           C  
ATOM   7110  CG1 VAL G  71     -11.869  -4.335  -4.747  1.00 47.87           C  
ATOM   7111  CG2 VAL G  71     -10.017  -2.735  -4.390  1.00 47.87           C  
ATOM   7112  N   GLU G  72     -14.161  -2.789  -2.934  1.00 65.12           N  
ATOM   7113  CA  GLU G  72     -15.543  -3.251  -2.909  1.00 65.12           C  
ATOM   7114  C   GLU G  72     -16.181  -2.974  -4.259  1.00 65.12           C  
ATOM   7115  O   GLU G  72     -16.087  -1.866  -4.786  1.00 65.12           O  
ATOM   7116  CB  GLU G  72     -16.348  -2.550  -1.816  1.00 75.80           C  
ATOM   7117  CG  GLU G  72     -17.720  -3.174  -1.593  1.00 75.80           C  
ATOM   7118  CD  GLU G  72     -18.643  -2.321  -0.730  1.00 75.80           C  
ATOM   7119  OE1 GLU G  72     -19.075  -1.244  -1.196  1.00 75.80           O  
ATOM   7120  OE2 GLU G  72     -18.939  -2.728   0.413  1.00 75.80           O  
ATOM   7121  N   THR G  73     -16.818  -3.988  -4.828  1.00 59.15           N  
ATOM   7122  CA  THR G  73     -17.466  -3.838  -6.122  1.00 59.15           C  
ATOM   7123  C   THR G  73     -18.948  -4.126  -6.005  1.00 59.15           C  
ATOM   7124  O   THR G  73     -19.358  -5.166  -5.489  1.00 59.15           O  
ATOM   7125  CB  THR G  73     -16.859  -4.798  -7.185  1.00 53.90           C  
ATOM   7126  OG1 THR G  73     -15.557  -4.334  -7.570  1.00 53.90           O  
ATOM   7127  CG2 THR G  73     -17.741  -4.862  -8.418  1.00 53.90           C  
ATOM   7128  N   THR G  74     -19.755  -3.188  -6.480  1.00 45.83           N  
ATOM   7129  CA  THR G  74     -21.201  -3.343  -6.458  1.00 45.83           C  
ATOM   7130  C   THR G  74     -21.705  -3.165  -7.873  1.00 45.83           C  
ATOM   7131  O   THR G  74     -21.034  -2.547  -8.701  1.00 45.83           O  
ATOM   7132  CB  THR G  74     -21.858  -2.295  -5.572  1.00 46.26           C  
ATOM   7133  OG1 THR G  74     -21.274  -1.016  -5.850  1.00 46.26           O  
ATOM   7134  CG2 THR G  74     -21.653  -2.639  -4.107  1.00 46.26           C  
ATOM   7135  N   LEU G  75     -22.875  -3.731  -8.149  1.00 67.52           N  
ATOM   7136  CA  LEU G  75     -23.497  -3.630  -9.458  1.00 67.52           C  
ATOM   7137  C   LEU G  75     -24.484  -2.473  -9.377  1.00 67.52           C  
ATOM   7138  O   LEU G  75     -25.356  -2.451  -8.513  1.00 67.52           O  
ATOM   7139  CB  LEU G  75     -24.190  -4.942  -9.790  1.00 38.99           C  
ATOM   7140  CG  LEU G  75     -23.293  -6.048 -10.352  1.00 38.99           C  
ATOM   7141  CD1 LEU G  75     -21.901  -5.934  -9.779  1.00 38.99           C  
ATOM   7142  CD2 LEU G  75     -23.903  -7.416 -10.057  1.00 38.99           C  
ATOM   7143  N   GLU G  76     -24.332  -1.510 -10.280  1.00 81.04           N  
ATOM   7144  CA  GLU G  76     -25.154  -0.299 -10.294  1.00 81.04           C  
ATOM   7145  C   GLU G  76     -26.677  -0.395 -10.325  1.00 81.04           C  
ATOM   7146  O   GLU G  76     -27.350   0.231  -9.506  1.00 81.04           O  
ATOM   7147  CB  GLU G  76     -24.691   0.613 -11.433  1.00137.40           C  
ATOM   7148  CG  GLU G  76     -24.522  -0.100 -12.754  1.00137.40           C  
ATOM   7149  CD  GLU G  76     -23.860   0.767 -13.806  1.00137.40           C  
ATOM   7150  OE1 GLU G  76     -24.495   1.742 -14.260  1.00137.40           O  
ATOM   7151  OE2 GLU G  76     -22.700   0.475 -14.174  1.00137.40           O  
ATOM   7152  N   ASP G  77     -27.236  -1.158 -11.254  1.00 72.23           N  
ATOM   7153  CA  ASP G  77     -28.690  -1.237 -11.323  1.00 72.23           C  
ATOM   7154  C   ASP G  77     -29.345  -2.137 -10.276  1.00 72.23           C  
ATOM   7155  O   ASP G  77     -30.367  -2.767 -10.540  1.00 72.23           O  
ATOM   7156  CB  ASP G  77     -29.142  -1.636 -12.738  1.00 96.98           C  
ATOM   7157  CG  ASP G  77     -28.530  -2.941 -13.211  1.00 96.98           C  
ATOM   7158  OD1 ASP G  77     -28.886  -3.384 -14.326  1.00 96.98           O  
ATOM   7159  OD2 ASP G  77     -27.695  -3.519 -12.475  1.00 96.98           O  
ATOM   7160  N   SER G  78     -28.766  -2.183  -9.080  1.00 69.03           N  
ATOM   7161  CA  SER G  78     -29.316  -2.994  -7.994  1.00 69.03           C  
ATOM   7162  C   SER G  78     -28.648  -2.662  -6.673  1.00 69.03           C  
ATOM   7163  O   SER G  78     -29.239  -2.841  -5.613  1.00 69.03           O  
ATOM   7164  CB  SER G  78     -29.142  -4.490  -8.277  1.00 66.33           C  
ATOM   7165  OG  SER G  78     -27.814  -4.908  -8.032  1.00 66.33           O  
ATOM   7166  N   GLY G  79     -27.410  -2.187  -6.745  1.00 53.60           N  
ATOM   7167  CA  GLY G  79     -26.680  -1.831  -5.541  1.00 53.60           C  
ATOM   7168  C   GLY G  79     -26.084  -3.009  -4.783  1.00 53.60           C  
ATOM   7169  O   GLY G  79     -25.312  -2.827  -3.843  1.00 53.60           O  
ATOM   7170  N   ASP G  80     -26.440  -4.221  -5.189  1.00 64.93           N  
ATOM   7171  CA  ASP G  80     -25.943  -5.421  -4.537  1.00 64.93           C  
ATOM   7172  C   ASP G  80     -24.431  -5.478  -4.531  1.00 64.93           C  
ATOM   7173  O   ASP G  80     -23.784  -5.007  -5.460  1.00 64.93           O  
ATOM   7174  CB  ASP G  80     -26.474  -6.653  -5.257  1.00 66.18           C  
ATOM   7175  CG  ASP G  80     -27.973  -6.743  -5.214  1.00 66.18           C  
ATOM   7176  OD1 ASP G  80     -28.554  -7.404  -6.104  1.00 66.18           O  
ATOM   7177  OD2 ASP G  80     -28.565  -6.157  -4.280  1.00 66.18           O  
ATOM   7178  N   VAL G  81     -23.870  -6.076  -3.489  1.00 56.35           N  
ATOM   7179  CA  VAL G  81     -22.425  -6.209  -3.379  1.00 56.35           C  
ATOM   7180  C   VAL G  81     -21.962  -7.432  -4.164  1.00 56.35           C  
ATOM   7181  O   VAL G  81     -22.440  -8.543  -3.934  1.00 56.35           O  
ATOM   7182  CB  VAL G  81     -22.000  -6.379  -1.906  1.00 47.68           C  
ATOM   7183  CG1 VAL G  81     -20.497  -6.631  -1.810  1.00 47.68           C  
ATOM   7184  CG2 VAL G  81     -22.382  -5.144  -1.120  1.00 47.68           C  
ATOM   7185  N   ALA G  82     -21.040  -7.233  -5.098  1.00 57.50           N  
ATOM   7186  CA  ALA G  82     -20.536  -8.354  -5.871  1.00 57.50           C  
ATOM   7187  C   ALA G  82     -19.517  -9.060  -4.998  1.00 57.50           C  
ATOM   7188  O   ALA G  82     -19.590 -10.270  -4.793  1.00 57.50           O  
ATOM   7189  CB  ALA G  82     -19.889  -7.866  -7.141  1.00 12.47           C  
ATOM   7190  N   PHE G  83     -18.570  -8.286  -4.481  1.00 55.48           N  
ATOM   7191  CA  PHE G  83     -17.537  -8.820  -3.606  1.00 55.48           C  
ATOM   7192  C   PHE G  83     -16.759  -7.717  -2.886  1.00 55.48           C  
ATOM   7193  O   PHE G  83     -16.677  -6.576  -3.352  1.00 55.48           O  
ATOM   7194  CB  PHE G  83     -16.567  -9.702  -4.396  1.00 45.20           C  
ATOM   7195  CG  PHE G  83     -15.722  -8.946  -5.377  1.00 45.20           C  
ATOM   7196  CD1 PHE G  83     -14.775  -8.025  -4.937  1.00 45.20           C  
ATOM   7197  CD2 PHE G  83     -15.885  -9.140  -6.744  1.00 45.20           C  
ATOM   7198  CE1 PHE G  83     -14.006  -7.310  -5.843  1.00 45.20           C  
ATOM   7199  CE2 PHE G  83     -15.118  -8.428  -7.661  1.00 45.20           C  
ATOM   7200  CZ  PHE G  83     -14.179  -7.512  -7.211  1.00 45.20           C  
ATOM   7201  N   ILE G  84     -16.190  -8.078  -1.742  1.00 55.67           N  
ATOM   7202  CA  ILE G  84     -15.403  -7.162  -0.926  1.00 55.67           C  
ATOM   7203  C   ILE G  84     -14.080  -7.855  -0.704  1.00 55.67           C  
ATOM   7204  O   ILE G  84     -14.057  -9.037  -0.383  1.00 55.67           O  
ATOM   7205  CB  ILE G  84     -16.030  -6.932   0.461  1.00 38.96           C  
ATOM   7206  CG1 ILE G  84     -17.472  -6.447   0.319  1.00 38.96           C  
ATOM   7207  CG2 ILE G  84     -15.224  -5.894   1.219  1.00 38.96           C  
ATOM   7208  CD1 ILE G  84     -18.143  -6.148   1.641  1.00 38.96           C  
ATOM   7209  N   CYS G  85     -12.979  -7.134  -0.881  1.00 75.18           N  
ATOM   7210  CA  CYS G  85     -11.659  -7.720  -0.678  1.00 75.18           C  
ATOM   7211  C   CYS G  85     -10.736  -6.748   0.045  1.00 75.18           C  
ATOM   7212  O   CYS G  85     -10.547  -5.609  -0.388  1.00 75.18           O  
ATOM   7213  CB  CYS G  85     -11.033  -8.130  -2.017  1.00 70.78           C  
ATOM   7214  SG  CYS G  85      -9.563  -9.205  -1.870  1.00 70.78           S  
ATOM   7215  N   GLU G  86     -10.173  -7.203   1.159  1.00 50.46           N  
ATOM   7216  CA  GLU G  86      -9.262  -6.382   1.940  1.00 50.46           C  
ATOM   7217  C   GLU G  86      -7.957  -7.127   2.116  1.00 50.46           C  
ATOM   7218  O   GLU G  86      -7.928  -8.300   2.477  1.00 50.46           O  
ATOM   7219  CB  GLU G  86      -9.891  -6.039   3.282  1.00 70.57           C  
ATOM   7220  CG  GLU G  86     -11.330  -5.611   3.112  1.00 70.57           C  
ATOM   7221  CD  GLU G  86     -11.829  -4.717   4.214  1.00 70.57           C  
ATOM   7222  OE1 GLU G  86     -11.417  -3.533   4.263  1.00 70.57           O  
ATOM   7223  OE2 GLU G  86     -12.637  -5.202   5.032  1.00 70.57           O  
ATOM   7224  N   VAL G  87      -6.867  -6.435   1.832  1.00 55.96           N  
ATOM   7225  CA  VAL G  87      -5.550  -7.028   1.926  1.00 55.96           C  
ATOM   7226  C   VAL G  87      -4.599  -6.158   2.730  1.00 55.96           C  
ATOM   7227  O   VAL G  87      -4.612  -4.928   2.628  1.00 55.96           O  
ATOM   7228  CB  VAL G  87      -4.963  -7.263   0.516  1.00 47.70           C  
ATOM   7229  CG1 VAL G  87      -3.474  -7.528   0.593  1.00 47.70           C  
ATOM   7230  CG2 VAL G  87      -5.666  -8.439  -0.134  1.00 47.70           C  
ATOM   7231  N   LYS G  88      -3.781  -6.825   3.537  1.00 51.98           N  
ATOM   7232  CA  LYS G  88      -2.787  -6.180   4.375  1.00 51.98           C  
ATOM   7233  C   LYS G  88      -1.438  -6.771   3.947  1.00 51.98           C  
ATOM   7234  O   LYS G  88      -0.933  -7.707   4.568  1.00 51.98           O  
ATOM   7235  CB  LYS G  88      -3.093  -6.505   5.831  1.00 68.78           C  
ATOM   7236  CG  LYS G  88      -2.764  -5.409   6.807  1.00 68.78           C  
ATOM   7237  CD  LYS G  88      -3.522  -5.624   8.109  1.00 68.78           C  
ATOM   7238  CE  LYS G  88      -2.985  -4.747   9.238  1.00 68.78           C  
ATOM   7239  NZ  LYS G  88      -3.085  -3.286   8.941  1.00 68.78           N  
ATOM   7240  N   GLN G  89      -0.878  -6.237   2.862  1.00 53.23           N  
ATOM   7241  CA  GLN G  89       0.393  -6.716   2.326  1.00 53.23           C  
ATOM   7242  C   GLN G  89       1.539  -6.007   3.014  1.00 53.23           C  
ATOM   7243  O   GLN G  89       1.563  -4.776   3.083  1.00 53.23           O  
ATOM   7244  CB  GLN G  89       0.479  -6.445   0.828  1.00 57.43           C  
ATOM   7245  CG  GLN G  89       1.663  -7.088   0.154  1.00 57.43           C  
ATOM   7246  CD  GLN G  89       1.518  -8.588   0.077  1.00 57.43           C  
ATOM   7247  OE1 GLN G  89       0.532  -9.098  -0.457  1.00 57.43           O  
ATOM   7248  NE2 GLN G  89       2.500  -9.308   0.606  1.00 57.43           N  
ATOM   7249  N   ALA G  90       2.504  -6.773   3.514  1.00 43.63           N  
ATOM   7250  CA  ALA G  90       3.617  -6.158   4.208  1.00 43.63           C  
ATOM   7251  C   ALA G  90       4.976  -6.643   3.758  1.00 43.63           C  
ATOM   7252  O   ALA G  90       5.105  -7.623   3.010  1.00 43.63           O  
ATOM   7253  CB  ALA G  90       3.462  -6.361   5.707  1.00 63.08           C  
ATOM   7254  N   GLY G  91       5.991  -5.928   4.225  1.00 68.00           N  
ATOM   7255  CA  GLY G  91       7.362  -6.263   3.911  1.00 68.00           C  
ATOM   7256  C   GLY G  91       8.281  -5.700   4.979  1.00 68.00           C  
ATOM   7257  O   GLY G  91       8.008  -4.650   5.556  1.00 68.00           O  
ATOM   7258  N   VAL G  92       9.361  -6.417   5.257  1.00 39.70           N  
ATOM   7259  CA  VAL G  92      10.348  -5.987   6.238  1.00 39.70           C  
ATOM   7260  C   VAL G  92      11.557  -5.523   5.431  1.00 39.70           C  
ATOM   7261  O   VAL G  92      12.147  -6.295   4.658  1.00 39.70           O  
ATOM   7262  CB  VAL G  92      10.734  -7.155   7.181  1.00 55.59           C  
ATOM   7263  CG1 VAL G  92      12.128  -6.954   7.731  1.00 55.59           C  
ATOM   7264  CG2 VAL G  92       9.736  -7.238   8.327  1.00 55.59           C  
ATOM   7265  N   PHE G  93      11.911  -4.254   5.598  1.00 60.18           N  
ATOM   7266  CA  PHE G  93      13.034  -3.697   4.866  1.00 60.18           C  
ATOM   7267  C   PHE G  93      14.147  -3.195   5.773  1.00 60.18           C  
ATOM   7268  O   PHE G  93      13.901  -2.751   6.894  1.00 60.18           O  
ATOM   7269  CB  PHE G  93      12.576  -2.534   3.981  1.00 49.85           C  
ATOM   7270  CG  PHE G  93      11.336  -2.819   3.177  1.00 49.85           C  
ATOM   7271  CD1 PHE G  93      10.086  -2.886   3.793  1.00 49.85           C  
ATOM   7272  CD2 PHE G  93      11.409  -2.974   1.789  1.00 49.85           C  
ATOM   7273  CE1 PHE G  93       8.937  -3.097   3.045  1.00 49.85           C  
ATOM   7274  CE2 PHE G  93      10.262  -3.185   1.036  1.00 49.85           C  
ATOM   7275  CZ  PHE G  93       9.023  -3.245   1.667  1.00 49.85           C  
ATOM   7276  N   THR G  94      15.372  -3.278   5.271  1.00 58.14           N  
ATOM   7277  CA  THR G  94      16.538  -2.789   5.986  1.00 58.14           C  
ATOM   7278  C   THR G  94      16.786  -1.414   5.370  1.00 58.14           C  
ATOM   7279  O   THR G  94      17.121  -1.304   4.190  1.00 58.14           O  
ATOM   7280  CB  THR G  94      17.781  -3.684   5.748  1.00 56.82           C  
ATOM   7281  OG1 THR G  94      17.547  -4.991   6.283  1.00 56.82           O  
ATOM   7282  CG2 THR G  94      19.003  -3.084   6.428  1.00 56.82           C  
ATOM   7283  N   ILE G  95      16.600  -0.366   6.158  1.00 67.56           N  
ATOM   7284  CA  ILE G  95      16.802   0.985   5.653  1.00 67.56           C  
ATOM   7285  C   ILE G  95      17.744   1.789   6.550  1.00 67.56           C  
ATOM   7286  O   ILE G  95      17.589   1.831   7.775  1.00 67.56           O  
ATOM   7287  CB  ILE G  95      15.457   1.707   5.518  1.00 78.27           C  
ATOM   7288  CG1 ILE G  95      14.493   0.838   4.706  1.00 78.27           C  
ATOM   7289  CG2 ILE G  95      15.656   3.046   4.835  1.00 78.27           C  
ATOM   7290  CD1 ILE G  95      13.060   1.346   4.696  1.00 78.27           C  
ATOM   7291  N   SER G  96      18.719   2.440   5.931  1.00 69.80           N  
ATOM   7292  CA  SER G  96      19.702   3.202   6.683  1.00 69.80           C  
ATOM   7293  C   SER G  96      20.422   4.247   5.840  1.00 69.80           C  
ATOM   7294  O   SER G  96      20.604   4.067   4.636  1.00 69.80           O  
ATOM   7295  CB  SER G  96      20.746   2.240   7.252  1.00 57.69           C  
ATOM   7296  OG  SER G  96      21.399   1.523   6.209  1.00 57.69           O  
ATOM   7297  N   GLY G  97      20.848   5.327   6.492  1.00 50.63           N  
ATOM   7298  CA  GLY G  97      21.569   6.379   5.799  1.00 50.63           C  
ATOM   7299  C   GLY G  97      20.727   7.382   5.037  1.00 50.63           C  
ATOM   7300  O   GLY G  97      21.100   7.767   3.930  1.00 50.63           O  
ATOM   7301  N   LEU G  98      19.612   7.821   5.617  1.00 60.77           N  
ATOM   7302  CA  LEU G  98      18.761   8.787   4.943  1.00 60.77           C  
ATOM   7303  C   LEU G  98      18.264   9.887   5.878  1.00 60.77           C  
ATOM   7304  O   LEU G  98      17.909   9.620   7.033  1.00 60.77           O  
ATOM   7305  CB  LEU G  98      17.574   8.065   4.308  1.00 67.87           C  
ATOM   7306  CG  LEU G  98      17.881   7.033   3.219  1.00 67.87           C  
ATOM   7307  CD1 LEU G  98      16.599   6.348   2.782  1.00 67.87           C  
ATOM   7308  CD2 LEU G  98      18.537   7.713   2.033  1.00 67.87           C  
ATOM   7309  N   GLU G  99      18.244  11.123   5.375  1.00 49.11           N  
ATOM   7310  CA  GLU G  99      17.774  12.269   6.155  1.00 49.11           C  
ATOM   7311  C   GLU G  99      16.280  12.136   6.452  1.00 49.11           C  
ATOM   7312  O   GLU G  99      15.554  11.501   5.695  1.00 49.11           O  
ATOM   7313  CB  GLU G  99      18.024  13.574   5.386  1.00102.90           C  
ATOM   7314  CG  GLU G  99      19.181  14.423   5.919  1.00102.90           C  
ATOM   7315  CD  GLU G  99      20.549  13.807   5.677  1.00102.90           C  
ATOM   7316  OE1 GLU G  99      20.932  13.660   4.497  1.00102.90           O  
ATOM   7317  OE2 GLU G  99      21.240  13.474   6.665  1.00102.90           O  
ATOM   7318  N   ASP G 100      15.820  12.745   7.543  1.00 69.19           N  
ATOM   7319  CA  ASP G 100      14.408  12.678   7.918  1.00 69.19           C  
ATOM   7320  C   ASP G 100      13.422  12.671   6.747  1.00 69.19           C  
ATOM   7321  O   ASP G 100      12.497  11.861   6.715  1.00 69.19           O  
ATOM   7322  CB  ASP G 100      14.060  13.831   8.862  1.00 94.90           C  
ATOM   7323  CG  ASP G 100      14.550  13.593  10.273  1.00 94.90           C  
ATOM   7324  OD1 ASP G 100      14.278  14.446  11.144  1.00 94.90           O  
ATOM   7325  OD2 ASP G 100      15.202  12.553  10.511  1.00 94.90           O  
ATOM   7326  N   VAL G 101      13.621  13.570   5.791  1.00 64.71           N  
ATOM   7327  CA  VAL G 101      12.728  13.653   4.642  1.00 64.71           C  
ATOM   7328  C   VAL G 101      12.899  12.478   3.684  1.00 64.71           C  
ATOM   7329  O   VAL G 101      11.917  11.884   3.252  1.00 64.71           O  
ATOM   7330  CB  VAL G 101      12.941  14.974   3.867  1.00 68.49           C  
ATOM   7331  CG1 VAL G 101      12.023  15.023   2.652  1.00 68.49           C  
ATOM   7332  CG2 VAL G 101      12.667  16.157   4.784  1.00 68.49           C  
ATOM   7333  N   GLN G 102      14.142  12.143   3.351  1.00 76.46           N  
ATOM   7334  CA  GLN G 102      14.414  11.026   2.442  1.00 76.46           C  
ATOM   7335  C   GLN G 102      13.800   9.744   3.006  1.00 76.46           C  
ATOM   7336  O   GLN G 102      13.236   8.932   2.270  1.00 76.46           O  
ATOM   7337  CB  GLN G 102      15.919  10.797   2.286  1.00 77.37           C  
ATOM   7338  CG  GLN G 102      16.771  12.030   2.444  1.00 77.37           C  
ATOM   7339  CD  GLN G 102      16.507  13.046   1.372  1.00 77.37           C  
ATOM   7340  OE1 GLN G 102      16.665  12.762   0.184  1.00 77.37           O  
ATOM   7341  NE2 GLN G 102      16.102  14.245   1.780  1.00 77.37           N  
ATOM   7342  N   MET G 103      13.934   9.567   4.320  1.00 56.95           N  
ATOM   7343  CA  MET G 103      13.413   8.400   5.009  1.00 56.95           C  
ATOM   7344  C   MET G 103      11.892   8.344   4.942  1.00 56.95           C  
ATOM   7345  O   MET G 103      11.315   7.284   4.720  1.00 56.95           O  
ATOM   7346  CB  MET G 103      13.861   8.421   6.469  1.00 58.71           C  
ATOM   7347  CG  MET G 103      13.441   7.201   7.295  1.00 58.71           C  
ATOM   7348  SD  MET G 103      14.146   5.623   6.744  1.00 58.71           S  
ATOM   7349  CE  MET G 103      15.590   6.193   5.884  1.00 58.71           C  
ATOM   7350  N   ALA G 104      11.242   9.485   5.139  1.00 70.82           N  
ATOM   7351  CA  ALA G 104       9.784   9.536   5.095  1.00 70.82           C  
ATOM   7352  C   ALA G 104       9.278   9.171   3.705  1.00 70.82           C  
ATOM   7353  O   ALA G 104       8.245   8.517   3.561  1.00 70.82           O  
ATOM   7354  CB  ALA G 104       9.286  10.920   5.481  1.00 48.36           C  
ATOM   7355  N   HIS G 105      10.001   9.598   2.680  1.00 72.65           N  
ATOM   7356  CA  HIS G 105       9.605   9.291   1.316  1.00 72.65           C  
ATOM   7357  C   HIS G 105       9.770   7.801   1.067  1.00 72.65           C  
ATOM   7358  O   HIS G 105       8.949   7.176   0.405  1.00 72.65           O  
ATOM   7359  CB  HIS G 105      10.458  10.080   0.320  1.00 47.00           C  
ATOM   7360  CG  HIS G 105      10.307   9.625  -1.098  1.00 47.00           C  
ATOM   7361  ND1 HIS G 105      11.111   8.652  -1.658  1.00 47.00           N  
ATOM   7362  CD2 HIS G 105       9.445  10.005  -2.072  1.00 47.00           C  
ATOM   7363  CE1 HIS G 105      10.752   8.455  -2.914  1.00 47.00           C  
ATOM   7364  NE2 HIS G 105       9.743   9.263  -3.191  1.00 47.00           N  
ATOM   7365  N   CYS G 106      10.838   7.240   1.614  1.00 71.34           N  
ATOM   7366  CA  CYS G 106      11.130   5.827   1.449  1.00 71.34           C  
ATOM   7367  C   CYS G 106      10.069   4.952   2.132  1.00 71.34           C  
ATOM   7368  O   CYS G 106       9.661   3.924   1.595  1.00 71.34           O  
ATOM   7369  CB  CYS G 106      12.527   5.533   2.018  1.00 70.34           C  
ATOM   7370  SG  CYS G 106      13.335   4.013   1.422  1.00 70.34           S  
ATOM   7371  N   LEU G 107       9.603   5.368   3.301  1.00 54.20           N  
ATOM   7372  CA  LEU G 107       8.620   4.574   4.026  1.00 54.20           C  
ATOM   7373  C   LEU G 107       7.174   4.791   3.602  1.00 54.20           C  
ATOM   7374  O   LEU G 107       6.319   3.935   3.840  1.00 54.20           O  
ATOM   7375  CB  LEU G 107       8.754   4.820   5.534  1.00 40.51           C  
ATOM   7376  CG  LEU G 107      10.066   4.427   6.231  1.00 40.51           C  
ATOM   7377  CD1 LEU G 107       9.987   4.854   7.686  1.00 40.51           C  
ATOM   7378  CD2 LEU G 107      10.317   2.920   6.129  1.00 40.51           C  
ATOM   7379  N   THR G 108       6.895   5.923   2.970  1.00 62.61           N  
ATOM   7380  CA  THR G 108       5.534   6.227   2.551  1.00 62.61           C  
ATOM   7381  C   THR G 108       5.307   6.091   1.058  1.00 62.61           C  
ATOM   7382  O   THR G 108       4.166   6.051   0.605  1.00 62.61           O  
ATOM   7383  CB  THR G 108       5.145   7.658   2.933  1.00 65.05           C  
ATOM   7384  OG1 THR G 108       5.466   7.892   4.308  1.00 65.05           O  
ATOM   7385  CG2 THR G 108       3.649   7.868   2.730  1.00 65.05           C  
ATOM   7386  N   SER G 109       6.384   6.024   0.290  1.00 68.31           N  
ATOM   7387  CA  SER G 109       6.252   5.918  -1.156  1.00 68.31           C  
ATOM   7388  C   SER G 109       7.067   4.785  -1.772  1.00 68.31           C  
ATOM   7389  O   SER G 109       6.505   3.875  -2.384  1.00 68.31           O  
ATOM   7390  CB  SER G 109       6.640   7.248  -1.807  1.00 48.46           C  
ATOM   7391  OG  SER G 109       6.515   7.200  -3.218  1.00 48.46           O  
ATOM   7392  N   GLN G 110       8.386   4.835  -1.613  1.00 65.38           N  
ATOM   7393  CA  GLN G 110       9.255   3.810  -2.188  1.00 65.38           C  
ATOM   7394  C   GLN G 110       8.894   2.381  -1.816  1.00 65.38           C  
ATOM   7395  O   GLN G 110       8.695   1.541  -2.689  1.00 65.38           O  
ATOM   7396  CB  GLN G 110      10.711   4.074  -1.816  1.00 92.66           C  
ATOM   7397  CG  GLN G 110      11.398   5.046  -2.739  1.00 92.66           C  
ATOM   7398  CD  GLN G 110      12.805   5.337  -2.301  1.00 92.66           C  
ATOM   7399  OE1 GLN G 110      13.584   4.420  -2.040  1.00 92.66           O  
ATOM   7400  NE2 GLN G 110      13.148   6.616  -2.217  1.00 92.66           N  
ATOM   7401  N   CYS G 111       8.815   2.104  -0.522  1.00 66.85           N  
ATOM   7402  CA  CYS G 111       8.492   0.763  -0.070  1.00 66.85           C  
ATOM   7403  C   CYS G 111       7.064   0.349  -0.409  1.00 66.85           C  
ATOM   7404  O   CYS G 111       6.840  -0.737  -0.956  1.00 66.85           O  
ATOM   7405  CB  CYS G 111       8.778   0.652   1.425  1.00 58.15           C  
ATOM   7406  SG  CYS G 111      10.545   0.857   1.744  1.00 58.15           S  
ATOM   7407  N   PRO G 112       6.077   1.202  -0.097  1.00 72.50           N  
ATOM   7408  CA  PRO G 112       4.703   0.825  -0.424  1.00 72.50           C  
ATOM   7409  C   PRO G 112       4.606   0.491  -1.913  1.00 72.50           C  
ATOM   7410  O   PRO G 112       3.873  -0.409  -2.320  1.00 72.50           O  
ATOM   7411  CB  PRO G 112       3.912   2.079  -0.051  1.00 45.49           C  
ATOM   7412  CG  PRO G 112       4.662   2.602   1.100  1.00 45.49           C  
ATOM   7413  CD  PRO G 112       6.100   2.482   0.630  1.00 45.49           C  
ATOM   7414  N   ASN G 113       5.375   1.215  -2.718  1.00 54.45           N  
ATOM   7415  CA  ASN G 113       5.370   1.007  -4.157  1.00 54.45           C  
ATOM   7416  C   ASN G 113       5.938  -0.355  -4.555  1.00 54.45           C  
ATOM   7417  O   ASN G 113       5.511  -0.932  -5.550  1.00 54.45           O  
ATOM   7418  CB  ASN G 113       6.140   2.129  -4.862  1.00 45.49           C  
ATOM   7419  CG  ASN G 113       5.750   2.272  -6.325  1.00 45.49           C  
ATOM   7420  OD1 ASN G 113       6.444   1.792  -7.228  1.00 45.49           O  
ATOM   7421  ND2 ASN G 113       4.620   2.931  -6.563  1.00 45.49           N  
ATOM   7422  N   MET G 114       6.896  -0.870  -3.792  1.00 60.32           N  
ATOM   7423  CA  MET G 114       7.457  -2.179  -4.108  1.00 60.32           C  
ATOM   7424  C   MET G 114       6.442  -3.250  -3.706  1.00 60.32           C  
ATOM   7425  O   MET G 114       6.374  -4.316  -4.323  1.00 60.32           O  
ATOM   7426  CB  MET G 114       8.781  -2.403  -3.366  1.00 54.44           C  
ATOM   7427  CG  MET G 114       9.963  -1.594  -3.898  1.00 54.44           C  
ATOM   7428  SD  MET G 114      11.537  -1.831  -2.983  1.00 54.44           S  
ATOM   7429  CE  MET G 114      11.161  -0.875  -1.490  1.00 54.44           C  
ATOM   7430  N   LEU G 115       5.647  -2.947  -2.680  1.00 52.27           N  
ATOM   7431  CA  LEU G 115       4.636  -3.870  -2.180  1.00 52.27           C  
ATOM   7432  C   LEU G 115       3.346  -3.914  -2.983  1.00 52.27           C  
ATOM   7433  O   LEU G 115       2.624  -4.911  -2.947  1.00 52.27           O  
ATOM   7434  CB  LEU G 115       4.267  -3.518  -0.749  1.00 29.78           C  
ATOM   7435  CG  LEU G 115       5.378  -3.670   0.274  1.00 29.78           C  
ATOM   7436  CD1 LEU G 115       4.790  -3.439   1.662  1.00 29.78           C  
ATOM   7437  CD2 LEU G 115       6.000  -5.066   0.151  1.00 29.78           C  
ATOM   7438  N   PHE G 116       3.052  -2.834  -3.692  1.00 52.43           N  
ATOM   7439  CA  PHE G 116       1.825  -2.735  -4.474  1.00 52.43           C  
ATOM   7440  C   PHE G 116       1.541  -3.878  -5.461  1.00 52.43           C  
ATOM   7441  O   PHE G 116       0.487  -4.505  -5.395  1.00 52.43           O  
ATOM   7442  CB  PHE G 116       1.800  -1.385  -5.206  1.00 34.31           C  
ATOM   7443  CG  PHE G 116       0.605  -1.192  -6.097  1.00 34.31           C  
ATOM   7444  CD1 PHE G 116      -0.666  -0.995  -5.549  1.00 34.31           C  
ATOM   7445  CD2 PHE G 116       0.750  -1.212  -7.489  1.00 34.31           C  
ATOM   7446  CE1 PHE G 116      -1.777  -0.818  -6.375  1.00 34.31           C  
ATOM   7447  CE2 PHE G 116      -0.352  -1.037  -8.321  1.00 34.31           C  
ATOM   7448  CZ  PHE G 116      -1.621  -0.839  -7.762  1.00 34.31           C  
ATOM   7449  N   PRO G 117       2.471  -4.172  -6.384  1.00 38.46           N  
ATOM   7450  CA  PRO G 117       2.127  -5.265  -7.296  1.00 38.46           C  
ATOM   7451  C   PRO G 117       1.923  -6.628  -6.632  1.00 38.46           C  
ATOM   7452  O   PRO G 117       1.285  -7.509  -7.206  1.00 38.46           O  
ATOM   7453  CB  PRO G 117       3.248  -5.231  -8.347  1.00 24.01           C  
ATOM   7454  CG  PRO G 117       4.379  -4.629  -7.644  1.00 24.01           C  
ATOM   7455  CD  PRO G 117       3.768  -3.575  -6.734  1.00 24.01           C  
ATOM   7456  N   TYR G 118       2.446  -6.808  -5.426  1.00 64.54           N  
ATOM   7457  CA  TYR G 118       2.231  -8.070  -4.725  1.00 64.54           C  
ATOM   7458  C   TYR G 118       0.775  -8.083  -4.266  1.00 64.54           C  
ATOM   7459  O   TYR G 118       0.080  -9.096  -4.354  1.00 64.54           O  
ATOM   7460  CB  TYR G 118       3.140  -8.187  -3.496  1.00 52.13           C  
ATOM   7461  CG  TYR G 118       4.572  -8.534  -3.812  1.00 52.13           C  
ATOM   7462  CD1 TYR G 118       5.472  -7.560  -4.236  1.00 52.13           C  
ATOM   7463  CD2 TYR G 118       5.025  -9.845  -3.709  1.00 52.13           C  
ATOM   7464  CE1 TYR G 118       6.786  -7.890  -4.548  1.00 52.13           C  
ATOM   7465  CE2 TYR G 118       6.328 -10.183  -4.021  1.00 52.13           C  
ATOM   7466  CZ  TYR G 118       7.206  -9.205  -4.441  1.00 52.13           C  
ATOM   7467  OH  TYR G 118       8.500  -9.548  -4.769  1.00 52.13           O  
ATOM   7468  N   ALA G 119       0.324  -6.940  -3.768  1.00 42.84           N  
ATOM   7469  CA  ALA G 119      -1.034  -6.796  -3.287  1.00 42.84           C  
ATOM   7470  C   ALA G 119      -2.024  -6.827  -4.458  1.00 42.84           C  
ATOM   7471  O   ALA G 119      -3.151  -7.313  -4.327  1.00 42.84           O  
ATOM   7472  CB  ALA G 119      -1.155  -5.494  -2.517  1.00 19.43           C  
ATOM   7473  N   ARG G 120      -1.596  -6.312  -5.605  1.00 57.09           N  
ATOM   7474  CA  ARG G 120      -2.447  -6.299  -6.780  1.00 57.09           C  
ATOM   7475  C   ARG G 120      -2.720  -7.724  -7.195  1.00 57.09           C  
ATOM   7476  O   ARG G 120      -3.860  -8.090  -7.468  1.00 57.09           O  
ATOM   7477  CB  ARG G 120      -1.770  -5.570  -7.932  1.00 28.52           C  
ATOM   7478  CG  ARG G 120      -2.767  -5.086  -8.961  1.00 28.52           C  
ATOM   7479  CD  ARG G 120      -2.093  -4.331 -10.083  1.00 28.52           C  
ATOM   7480  NE  ARG G 120      -1.322  -5.238 -10.915  1.00 28.52           N  
ATOM   7481  CZ  ARG G 120      -1.421  -5.257 -12.233  1.00 28.52           C  
ATOM   7482  NH1 ARG G 120      -2.256  -4.423 -12.825  1.00 28.52           N  
ATOM   7483  NH2 ARG G 120      -0.684  -6.095 -12.947  1.00 28.52           N  
ATOM   7484  N   GLU G 121      -1.659  -8.524  -7.233  1.00 43.03           N  
ATOM   7485  CA  GLU G 121      -1.750  -9.922  -7.629  1.00 43.03           C  
ATOM   7486  C   GLU G 121      -2.669 -10.708  -6.691  1.00 43.03           C  
ATOM   7487  O   GLU G 121      -3.420 -11.587  -7.124  1.00 43.03           O  
ATOM   7488  CB  GLU G 121      -0.350 -10.540  -7.648  1.00 55.00           C  
ATOM   7489  CG  GLU G 121      -0.246 -11.806  -8.472  1.00 55.00           C  
ATOM   7490  CD  GLU G 121      -0.885 -12.999  -7.801  1.00 55.00           C  
ATOM   7491  OE1 GLU G 121      -1.646 -13.732  -8.483  1.00 55.00           O  
ATOM   7492  OE2 GLU G 121      -0.620 -13.206  -6.596  1.00 55.00           O  
ATOM   7493  N   LEU G 122      -2.615 -10.381  -5.403  1.00 38.67           N  
ATOM   7494  CA  LEU G 122      -3.439 -11.068  -4.419  1.00 38.67           C  
ATOM   7495  C   LEU G 122      -4.902 -10.752  -4.657  1.00 38.67           C  
ATOM   7496  O   LEU G 122      -5.751 -11.634  -4.627  1.00 38.67           O  
ATOM   7497  CB  LEU G 122      -3.050 -10.650  -2.997  1.00 46.63           C  
ATOM   7498  CG  LEU G 122      -3.864 -11.240  -1.835  1.00 46.63           C  
ATOM   7499  CD1 LEU G 122      -3.907 -12.759  -1.936  1.00 46.63           C  
ATOM   7500  CD2 LEU G 122      -3.236 -10.813  -0.516  1.00 46.63           C  
ATOM   7501  N   VAL G 123      -5.194  -9.481  -4.877  1.00 50.87           N  
ATOM   7502  CA  VAL G 123      -6.562  -9.069  -5.125  1.00 50.87           C  
ATOM   7503  C   VAL G 123      -7.066  -9.728  -6.399  1.00 50.87           C  
ATOM   7504  O   VAL G 123      -8.170 -10.261  -6.420  1.00 50.87           O  
ATOM   7505  CB  VAL G 123      -6.673  -7.535  -5.274  1.00 36.40           C  
ATOM   7506  CG1 VAL G 123      -8.076  -7.152  -5.802  1.00 36.40           C  
ATOM   7507  CG2 VAL G 123      -6.398  -6.872  -3.938  1.00 36.40           C  
ATOM   7508  N   SER G 124      -6.259  -9.711  -7.455  1.00 42.25           N  
ATOM   7509  CA  SER G 124      -6.700 -10.305  -8.706  1.00 42.25           C  
ATOM   7510  C   SER G 124      -6.901 -11.814  -8.579  1.00 42.25           C  
ATOM   7511  O   SER G 124      -7.852 -12.359  -9.148  1.00 42.25           O  
ATOM   7512  CB  SER G 124      -5.739  -9.953  -9.860  1.00 35.24           C  
ATOM   7513  OG  SER G 124      -4.534 -10.691  -9.810  1.00 35.24           O  
ATOM   7514  N   ASN G 125      -6.042 -12.481  -7.807  1.00 41.04           N  
ATOM   7515  CA  ASN G 125      -6.138 -13.930  -7.616  1.00 41.04           C  
ATOM   7516  C   ASN G 125      -7.445 -14.286  -6.914  1.00 41.04           C  
ATOM   7517  O   ASN G 125      -8.151 -15.202  -7.329  1.00 41.04           O  
ATOM   7518  CB  ASN G 125      -4.944 -14.434  -6.793  1.00 45.56           C  
ATOM   7519  CG  ASN G 125      -4.655 -15.919  -7.017  1.00 45.56           C  
ATOM   7520  OD1 ASN G 125      -5.385 -16.795  -6.534  1.00 45.56           O  
ATOM   7521  ND2 ASN G 125      -3.583 -16.205  -7.767  1.00 45.56           N  
ATOM   7522  N   LEU G 126      -7.764 -13.547  -5.854  1.00 52.29           N  
ATOM   7523  CA  LEU G 126      -8.979 -13.771  -5.082  1.00 52.29           C  
ATOM   7524  C   LEU G 126     -10.235 -13.508  -5.897  1.00 52.29           C  
ATOM   7525  O   LEU G 126     -11.194 -14.282  -5.843  1.00 52.29           O  
ATOM   7526  CB  LEU G 126      -8.985 -12.872  -3.849  1.00 46.03           C  
ATOM   7527  CG  LEU G 126      -7.944 -13.228  -2.789  1.00 46.03           C  
ATOM   7528  CD1 LEU G 126      -7.938 -12.172  -1.686  1.00 46.03           C  
ATOM   7529  CD2 LEU G 126      -8.258 -14.616  -2.239  1.00 46.03           C  
ATOM   7530  N   VAL G 127     -10.235 -12.405  -6.641  1.00 43.29           N  
ATOM   7531  CA  VAL G 127     -11.380 -12.046  -7.468  1.00 43.29           C  
ATOM   7532  C   VAL G 127     -11.651 -13.159  -8.470  1.00 43.29           C  
ATOM   7533  O   VAL G 127     -12.786 -13.568  -8.664  1.00 43.29           O  
ATOM   7534  CB  VAL G 127     -11.137 -10.722  -8.217  1.00 46.70           C  
ATOM   7535  CG1 VAL G 127     -12.277 -10.444  -9.183  1.00 46.70           C  
ATOM   7536  CG2 VAL G 127     -11.036  -9.581  -7.219  1.00 46.70           C  
ATOM   7537  N   ASN G 128     -10.600 -13.656  -9.101  1.00 33.94           N  
ATOM   7538  CA  ASN G 128     -10.735 -14.738 -10.070  1.00 33.94           C  
ATOM   7539  C   ASN G 128     -11.330 -15.991  -9.438  1.00 33.94           C  
ATOM   7540  O   ASN G 128     -12.070 -16.716 -10.093  1.00 33.94           O  
ATOM   7541  CB  ASN G 128      -9.368 -15.065 -10.677  1.00 42.97           C  
ATOM   7542  CG  ASN G 128      -9.433 -16.136 -11.749  1.00 42.97           C  
ATOM   7543  OD1 ASN G 128     -10.301 -16.113 -12.620  1.00 42.97           O  
ATOM   7544  ND2 ASN G 128      -8.492 -17.071 -11.706  1.00 42.97           N  
ATOM   7545  N   ARG G 129     -11.015 -16.254  -8.171  1.00 49.86           N  
ATOM   7546  CA  ARG G 129     -11.543 -17.447  -7.521  1.00 49.86           C  
ATOM   7547  C   ARG G 129     -13.036 -17.324  -7.274  1.00 49.86           C  
ATOM   7548  O   ARG G 129     -13.715 -18.314  -7.008  1.00 49.86           O  
ATOM   7549  CB  ARG G 129     -10.789 -17.729  -6.221  1.00 52.43           C  
ATOM   7550  CG  ARG G 129      -9.384 -18.270  -6.432  1.00 52.43           C  
ATOM   7551  CD  ARG G 129      -8.524 -18.039  -5.205  1.00 52.43           C  
ATOM   7552  NE  ARG G 129      -7.129 -18.407  -5.428  1.00 52.43           N  
ATOM   7553  CZ  ARG G 129      -6.685 -19.658  -5.474  1.00 52.43           C  
ATOM   7554  NH1 ARG G 129      -7.531 -20.666  -5.305  1.00 52.43           N  
ATOM   7555  NH2 ARG G 129      -5.401 -19.904  -5.700  1.00 52.43           N  
ATOM   7556  N   GLY G 130     -13.552 -16.107  -7.367  1.00 50.95           N  
ATOM   7557  CA  GLY G 130     -14.976 -15.919  -7.181  1.00 50.95           C  
ATOM   7558  C   GLY G 130     -15.631 -15.920  -8.549  1.00 50.95           C  
ATOM   7559  O   GLY G 130     -16.826 -15.700  -8.687  1.00 50.95           O  
ATOM   7560  N   THR G 131     -14.815 -16.191  -9.560  1.00 45.62           N  
ATOM   7561  CA  THR G 131     -15.222 -16.209 -10.965  1.00 45.62           C  
ATOM   7562  C   THR G 131     -15.844 -14.898 -11.439  1.00 45.62           C  
ATOM   7563  O   THR G 131     -16.783 -14.897 -12.229  1.00 45.62           O  
ATOM   7564  CB  THR G 131     -16.201 -17.377 -11.315  1.00 38.50           C  
ATOM   7565  OG1 THR G 131     -17.313 -17.365 -10.414  1.00 38.50           O  
ATOM   7566  CG2 THR G 131     -15.491 -18.720 -11.261  1.00 38.50           C  
ATOM   7567  N   PHE G 132     -15.323 -13.783 -10.942  1.00 35.29           N  
ATOM   7568  CA  PHE G 132     -15.779 -12.467 -11.363  1.00 35.29           C  
ATOM   7569  C   PHE G 132     -14.834 -12.026 -12.474  1.00 35.29           C  
ATOM   7570  O   PHE G 132     -13.726 -12.548 -12.613  1.00 35.29           O  
ATOM   7571  CB  PHE G 132     -15.714 -11.468 -10.211  1.00 51.36           C  
ATOM   7572  CG  PHE G 132     -16.715 -11.733  -9.125  1.00 51.36           C  
ATOM   7573  CD1 PHE G 132     -16.317 -12.269  -7.902  1.00 51.36           C  
ATOM   7574  CD2 PHE G 132     -18.065 -11.459  -9.326  1.00 51.36           C  
ATOM   7575  CE1 PHE G 132     -17.254 -12.532  -6.886  1.00 51.36           C  
ATOM   7576  CE2 PHE G 132     -19.009 -11.717  -8.321  1.00 51.36           C  
ATOM   7577  CZ  PHE G 132     -18.603 -12.254  -7.099  1.00 51.36           C  
ATOM   7578  N   PRO G 133     -15.264 -11.082 -13.313  1.00 35.28           N  
ATOM   7579  CA  PRO G 133     -14.315 -10.685 -14.360  1.00 35.28           C  
ATOM   7580  C   PRO G 133     -13.059 -10.049 -13.749  1.00 35.28           C  
ATOM   7581  O   PRO G 133     -13.129  -9.364 -12.733  1.00 35.28           O  
ATOM   7582  CB  PRO G 133     -15.127  -9.712 -15.211  1.00 31.76           C  
ATOM   7583  CG  PRO G 133     -16.110  -9.147 -14.227  1.00 31.76           C  
ATOM   7584  CD  PRO G 133     -16.535 -10.350 -13.427  1.00 31.76           C  
ATOM   7585  N   ALA G 134     -11.914 -10.292 -14.379  1.00 46.44           N  
ATOM   7586  CA  ALA G 134     -10.621  -9.781 -13.915  1.00 46.44           C  
ATOM   7587  C   ALA G 134     -10.640  -8.371 -13.363  1.00 46.44           C  
ATOM   7588  O   ALA G 134     -11.277  -7.487 -13.925  1.00 46.44           O  
ATOM   7589  CB  ALA G 134      -9.582  -9.857 -15.046  1.00 33.60           C  
ATOM   7590  N   LEU G 135      -9.927  -8.181 -12.256  1.00 50.68           N  
ATOM   7591  CA  LEU G 135      -9.784  -6.880 -11.607  1.00 50.68           C  
ATOM   7592  C   LEU G 135      -8.307  -6.690 -11.298  1.00 50.68           C  
ATOM   7593  O   LEU G 135      -7.796  -7.245 -10.330  1.00 50.68           O  
ATOM   7594  CB  LEU G 135     -10.578  -6.824 -10.303  1.00 17.83           C  
ATOM   7595  CG  LEU G 135     -10.313  -5.653  -9.323  1.00 17.83           C  
ATOM   7596  CD1 LEU G 135     -10.412  -4.339 -10.095  1.00 17.83           C  
ATOM   7597  CD2 LEU G 135     -11.297  -5.662  -8.121  1.00 17.83           C  
ATOM   7598  N   ASN G 136      -7.614  -5.929 -12.136  1.00 44.43           N  
ATOM   7599  CA  ASN G 136      -6.195  -5.680 -11.926  1.00 44.43           C  
ATOM   7600  C   ASN G 136      -6.024  -4.207 -11.597  1.00 44.43           C  
ATOM   7601  O   ASN G 136      -5.991  -3.356 -12.487  1.00 44.43           O  
ATOM   7602  CB  ASN G 136      -5.392  -6.074 -13.175  1.00 55.26           C  
ATOM   7603  CG  ASN G 136      -5.262  -7.590 -13.334  1.00 55.26           C  
ATOM   7604  OD1 ASN G 136      -4.790  -8.288 -12.431  1.00 55.26           O  
ATOM   7605  ND2 ASN G 136      -5.675  -8.100 -14.481  1.00 55.26           N  
ATOM   7606  N   LEU G 137      -5.926  -3.915 -10.305  1.00 39.30           N  
ATOM   7607  CA  LEU G 137      -5.798  -2.540  -9.832  1.00 39.30           C  
ATOM   7608  C   LEU G 137      -4.837  -1.697 -10.647  1.00 39.30           C  
ATOM   7609  O   LEU G 137      -3.728  -2.129 -10.954  1.00 39.30           O  
ATOM   7610  CB  LEU G 137      -5.381  -2.535  -8.365  1.00 40.41           C  
ATOM   7611  CG  LEU G 137      -6.362  -3.308  -7.478  1.00 40.41           C  
ATOM   7612  CD1 LEU G 137      -5.866  -3.267  -6.037  1.00 40.41           C  
ATOM   7613  CD2 LEU G 137      -7.778  -2.709  -7.587  1.00 40.41           C  
ATOM   7614  N   SER G 138      -5.275  -0.493 -11.005  1.00 51.21           N  
ATOM   7615  CA  SER G 138      -4.448   0.428 -11.781  1.00 51.21           C  
ATOM   7616  C   SER G 138      -3.298   0.965 -10.937  1.00 51.21           C  
ATOM   7617  O   SER G 138      -3.393   1.048  -9.715  1.00 51.21           O  
ATOM   7618  CB  SER G 138      -5.278   1.608 -12.287  1.00 68.63           C  
ATOM   7619  OG  SER G 138      -6.250   1.186 -13.221  1.00 68.63           O  
ATOM   7620  N   PRO G 139      -2.194   1.346 -11.591  1.00 40.90           N  
ATOM   7621  CA  PRO G 139      -1.005   1.883 -10.942  1.00 40.90           C  
ATOM   7622  C   PRO G 139      -1.354   2.961  -9.941  1.00 40.90           C  
ATOM   7623  O   PRO G 139      -2.220   3.792 -10.198  1.00 40.90           O  
ATOM   7624  CB  PRO G 139      -0.218   2.448 -12.113  1.00 36.06           C  
ATOM   7625  CG  PRO G 139      -0.530   1.474 -13.202  1.00 36.06           C  
ATOM   7626  CD  PRO G 139      -2.021   1.360 -13.053  1.00 36.06           C  
ATOM   7627  N   VAL G 140      -0.679   2.952  -8.802  1.00 60.83           N  
ATOM   7628  CA  VAL G 140      -0.920   3.956  -7.784  1.00 60.83           C  
ATOM   7629  C   VAL G 140       0.314   4.831  -7.671  1.00 60.83           C  
ATOM   7630  O   VAL G 140       1.441   4.325  -7.652  1.00 60.83           O  
ATOM   7631  CB  VAL G 140      -1.195   3.307  -6.416  1.00 51.83           C  
ATOM   7632  CG1 VAL G 140      -1.148   4.360  -5.318  1.00 51.83           C  
ATOM   7633  CG2 VAL G 140      -2.547   2.607  -6.432  1.00 51.83           C  
ATOM   7634  N   ASN G 141       0.089   6.142  -7.616  1.00 60.77           N  
ATOM   7635  CA  ASN G 141       1.164   7.117  -7.479  1.00 60.77           C  
ATOM   7636  C   ASN G 141       1.351   7.368  -5.992  1.00 60.77           C  
ATOM   7637  O   ASN G 141       0.674   8.213  -5.413  1.00 60.77           O  
ATOM   7638  CB  ASN G 141       0.802   8.427  -8.193  1.00 72.78           C  
ATOM   7639  CG  ASN G 141       1.768   9.560  -7.872  1.00 72.78           C  
ATOM   7640  OD1 ASN G 141       1.639  10.229  -6.845  1.00 72.78           O  
ATOM   7641  ND2 ASN G 141       2.750   9.773  -8.747  1.00 72.78           N  
ATOM   7642  N   PHE G 142       2.269   6.633  -5.374  1.00 88.72           N  
ATOM   7643  CA  PHE G 142       2.496   6.793  -3.947  1.00 88.72           C  
ATOM   7644  C   PHE G 142       3.184   8.100  -3.577  1.00 88.72           C  
ATOM   7645  O   PHE G 142       3.175   8.498  -2.412  1.00 88.72           O  
ATOM   7646  CB  PHE G 142       3.282   5.601  -3.395  1.00 49.10           C  
ATOM   7647  CG  PHE G 142       2.508   4.303  -3.411  1.00 49.10           C  
ATOM   7648  CD1 PHE G 142       2.485   3.502  -4.553  1.00 49.10           C  
ATOM   7649  CD2 PHE G 142       1.774   3.903  -2.292  1.00 49.10           C  
ATOM   7650  CE1 PHE G 142       1.741   2.325  -4.581  1.00 49.10           C  
ATOM   7651  CE2 PHE G 142       1.028   2.727  -2.312  1.00 49.10           C  
ATOM   7652  CZ  PHE G 142       1.009   1.936  -3.458  1.00 49.10           C  
ATOM   7653  N   ASP G 143       3.776   8.771  -4.559  1.00 79.02           N  
ATOM   7654  CA  ASP G 143       4.435  10.040  -4.286  1.00 79.02           C  
ATOM   7655  C   ASP G 143       3.411  11.025  -3.737  1.00 79.02           C  
ATOM   7656  O   ASP G 143       3.728  11.868  -2.899  1.00 79.02           O  
ATOM   7657  CB  ASP G 143       5.085  10.612  -5.554  1.00 57.26           C  
ATOM   7658  CG  ASP G 143       6.479  10.049  -5.803  1.00 57.26           C  
ATOM   7659  OD1 ASP G 143       7.076   9.512  -4.847  1.00 57.26           O  
ATOM   7660  OD2 ASP G 143       6.984  10.153  -6.944  1.00 57.26           O  
ATOM   7661  N   ALA G 144       2.174  10.905  -4.205  1.00 67.17           N  
ATOM   7662  CA  ALA G 144       1.103  11.785  -3.757  1.00 67.17           C  
ATOM   7663  C   ALA G 144       0.827  11.578  -2.273  1.00 67.17           C  
ATOM   7664  O   ALA G 144       0.629  12.543  -1.532  1.00 67.17           O  
ATOM   7665  CB  ALA G 144      -0.163  11.522  -4.566  1.00 81.47           C  
ATOM   7666  N   LEU G 145       0.819  10.318  -1.846  1.00 66.29           N  
ATOM   7667  CA  LEU G 145       0.566   9.981  -0.449  1.00 66.29           C  
ATOM   7668  C   LEU G 145       1.678  10.508   0.442  1.00 66.29           C  
ATOM   7669  O   LEU G 145       1.431  10.912   1.578  1.00 66.29           O  
ATOM   7670  CB  LEU G 145       0.455   8.466  -0.273  1.00 83.46           C  
ATOM   7671  CG  LEU G 145      -0.600   7.737  -1.106  1.00 83.46           C  
ATOM   7672  CD1 LEU G 145      -0.671   6.297  -0.639  1.00 83.46           C  
ATOM   7673  CD2 LEU G 145      -1.957   8.403  -0.961  1.00 83.46           C  
ATOM   7674  N   PHE G 146       2.903  10.486  -0.082  1.00 71.96           N  
ATOM   7675  CA  PHE G 146       4.075  10.971   0.643  1.00 71.96           C  
ATOM   7676  C   PHE G 146       3.932  12.462   0.871  1.00 71.96           C  
ATOM   7677  O   PHE G 146       4.181  12.956   1.972  1.00 71.96           O  
ATOM   7678  CB  PHE G 146       5.350  10.686  -0.153  1.00 88.97           C  
ATOM   7679  CG  PHE G 146       6.479  11.617   0.167  1.00 88.97           C  
ATOM   7680  CD1 PHE G 146       6.934  11.757   1.474  1.00 88.97           C  
ATOM   7681  CD2 PHE G 146       7.070  12.381  -0.837  1.00 88.97           C  
ATOM   7682  CE1 PHE G 146       7.958  12.648   1.776  1.00 88.97           C  
ATOM   7683  CE2 PHE G 146       8.098  13.275  -0.544  1.00 88.97           C  
ATOM   7684  CZ  PHE G 146       8.541  13.410   0.763  1.00 88.97           C  
ATOM   7685  N   VAL G 147       3.538  13.172  -0.181  1.00 68.92           N  
ATOM   7686  CA  VAL G 147       3.325  14.613  -0.116  1.00 68.92           C  
ATOM   7687  C   VAL G 147       2.234  14.922   0.915  1.00 68.92           C  
ATOM   7688  O   VAL G 147       2.401  15.803   1.757  1.00 68.92           O  
ATOM   7689  CB  VAL G 147       2.913  15.167  -1.503  1.00 67.75           C  
ATOM   7690  CG1 VAL G 147       1.980  16.353  -1.348  1.00 67.75           C  
ATOM   7691  CG2 VAL G 147       4.157  15.580  -2.281  1.00 67.75           C  
ATOM   7692  N   GLU G 148       1.121  14.197   0.846  1.00 93.39           N  
ATOM   7693  CA  GLU G 148       0.030  14.399   1.795  1.00 93.39           C  
ATOM   7694  C   GLU G 148       0.563  14.249   3.218  1.00 93.39           C  
ATOM   7695  O   GLU G 148       0.116  14.945   4.132  1.00 93.39           O  
ATOM   7696  CB  GLU G 148      -1.082  13.369   1.573  1.00131.17           C  
ATOM   7697  CG  GLU G 148      -1.869  13.537   0.284  1.00131.17           C  
ATOM   7698  CD  GLU G 148      -2.959  12.490   0.134  1.00131.17           C  
ATOM   7699  OE1 GLU G 148      -3.800  12.369   1.052  1.00131.17           O  
ATOM   7700  OE2 GLU G 148      -2.978  11.788  -0.900  1.00131.17           O  
ATOM   7701  N   TYR G 149       1.518  13.335   3.388  1.00 84.32           N  
ATOM   7702  CA  TYR G 149       2.134  13.052   4.684  1.00 84.32           C  
ATOM   7703  C   TYR G 149       3.005  14.197   5.180  1.00 84.32           C  
ATOM   7704  O   TYR G 149       3.178  14.376   6.384  1.00 84.32           O  
ATOM   7705  CB  TYR G 149       2.984  11.788   4.589  1.00 87.57           C  
ATOM   7706  CG  TYR G 149       3.663  11.395   5.882  1.00 87.57           C  
ATOM   7707  CD1 TYR G 149       2.917  11.044   7.008  1.00 87.57           C  
ATOM   7708  CD2 TYR G 149       5.052  11.334   5.970  1.00 87.57           C  
ATOM   7709  CE1 TYR G 149       3.542  10.636   8.187  1.00 87.57           C  
ATOM   7710  CE2 TYR G 149       5.685  10.927   7.141  1.00 87.57           C  
ATOM   7711  CZ  TYR G 149       4.926  10.578   8.243  1.00 87.57           C  
ATOM   7712  OH  TYR G 149       5.554  10.150   9.388  1.00 87.57           O  
ATOM   7713  N   MET G 150       3.557  14.963   4.245  1.00 89.96           N  
ATOM   7714  CA  MET G 150       4.413  16.095   4.580  1.00 89.96           C  
ATOM   7715  C   MET G 150       3.625  17.347   4.984  1.00 89.96           C  
ATOM   7716  O   MET G 150       4.203  18.338   5.434  1.00 89.96           O  
ATOM   7717  CB  MET G 150       5.333  16.417   3.397  1.00 69.80           C  
ATOM   7718  CG  MET G 150       6.428  15.392   3.170  1.00 69.80           C  
ATOM   7719  SD  MET G 150       7.600  15.340   4.544  1.00 69.80           S  
ATOM   7720  CE  MET G 150       8.981  16.290   3.838  1.00 69.80           C  
ATOM   7721  N   ASN G 151       2.307  17.304   4.824  1.00107.61           N  
ATOM   7722  CA  ASN G 151       1.479  18.444   5.190  1.00107.61           C  
ATOM   7723  C   ASN G 151       0.684  18.141   6.458  1.00107.61           C  
ATOM   7724  O   ASN G 151       0.987  18.764   7.499  1.00107.61           O  
ATOM   7725  CB  ASN G 151       0.530  18.797   4.041  1.00 93.15           C  
ATOM   7726  CG  ASN G 151       1.252  18.933   2.708  1.00 93.15           C  
ATOM   7727  OD1 ASN G 151       2.355  19.474   2.633  1.00 93.15           O  
ATOM   7728  ND2 ASN G 151       0.621  18.450   1.643  1.00 93.15           N  
TER    7729      ASN G 151                                                      
END
MOLECULE T0482_7_107.pdb
EXPDTA     NMR, 20 STRUCTURES
ATOM     97  N   PRO A   7      -1.524  11.209   1.755  1.00  0.00           N 
ATOM     98  CA  PRO A   7      -0.374  10.698   2.544  1.00  0.00           C 
ATOM     99  C   PRO A   7      -0.850   9.805   3.722  1.00  0.00           C 
ATOM    100  O   PRO A   7      -1.278  10.304   4.769  1.00  0.00           O 
ATOM    101  CB  PRO A   7       0.357  11.990   3.010  1.00  0.00           C 
ATOM    102  CG  PRO A   7      -0.693  13.067   2.965  1.00  0.00           C 
ATOM    103  CD  PRO A   7      -1.639  12.691   1.839  1.00  0.00           C 
ATOM    104  HA  PRO A   7       0.295  10.112   1.912  1.00  0.00           H 
ATOM    105 2HB  PRO A   7       1.175  12.209   2.329  1.00  0.00           H 
ATOM    106 1HB  PRO A   7       0.755  11.857   4.011  1.00  0.00           H 
ATOM    107 2HG  PRO A   7      -0.229  14.028   2.770  1.00  0.00           H 
ATOM    108 1HG  PRO A   7      -1.226  13.101   3.913  1.00  0.00           H 
ATOM    109 2HD  PRO A   7      -1.329  13.151   0.907  1.00  0.00           H 
ATOM    110 1HD  PRO A   7      -2.654  12.988   2.079  1.00  0.00           H 
ATOM    111  N   GLY A   8      -0.828   8.476   3.495  1.00  0.00           N 
ATOM    112  CA  GLY A   8      -1.248   7.480   4.493  1.00  0.00           C 
ATOM    113  C   GLY A   8      -2.274   6.471   3.961  1.00  0.00           C 
ATOM    114  O   GLY A   8      -2.481   5.419   4.582  1.00  0.00           O 
ATOM    115  H   GLY A   8      -0.501   8.160   2.624  1.00  0.00           H 
ATOM    116 2HA  GLY A   8      -1.674   7.981   5.357  1.00  0.00           H 
ATOM    117 1HA  GLY A   8      -0.369   6.938   4.816  1.00  0.00           H 
ATOM    118  N   HIS A   9      -2.906   6.777   2.799  1.00  0.00           N 
ATOM    119  CA  HIS A   9      -4.036   5.976   2.252  1.00  0.00           C 
ATOM    120  C   HIS A   9      -4.258   6.233   0.734  1.00  0.00           C 
ATOM    121  O   HIS A   9      -3.912   7.285   0.219  1.00  0.00           O 
ATOM    122  CB  HIS A   9      -5.320   6.285   3.075  1.00  0.00           C 
ATOM    123  CG  HIS A   9      -6.600   5.708   2.529  1.00  0.00           C 
ATOM    124  ND1 HIS A   9      -7.504   6.454   1.813  1.00  0.00           N 
ATOM    125  CD2 HIS A   9      -7.111   4.456   2.576  1.00  0.00           C 
ATOM    126  CE1 HIS A   9      -8.507   5.700   1.449  1.00  0.00           C 
ATOM    127  NE2 HIS A   9      -8.304   4.476   1.894  1.00  0.00           N 
ATOM    128  H   HIS A   9      -2.612   7.568   2.302  1.00  0.00           H 
ATOM    129  HA  HIS A   9      -3.784   4.925   2.378  1.00  0.00           H 
ATOM    130 2HB  HIS A   9      -5.440   7.359   3.139  1.00  0.00           H 
ATOM    131 1HB  HIS A   9      -5.194   5.897   4.079  1.00  0.00           H 
ATOM    132  HD1 HIS A   9      -7.432   7.415   1.622  1.00  0.00           H 
ATOM    133  HD2 HIS A   9      -6.669   3.600   3.069  1.00  0.00           H 
ATOM    134  HE1 HIS A   9      -9.362   6.027   0.875  1.00  0.00           H 
ATOM    135  HE2 HIS A   9      -9.027   3.830   2.038  1.00  0.00           H 
ATOM    136  N   LEU A  10      -4.830   5.233   0.035  1.00  0.00           N 
ATOM    137  CA  LEU A  10      -5.185   5.300  -1.392  1.00  0.00           C 
ATOM    138  C   LEU A  10      -6.605   4.693  -1.551  1.00  0.00           C 
ATOM    139  O   LEU A  10      -6.861   3.572  -1.112  1.00  0.00           O 
ATOM    140  CB  LEU A  10      -4.118   4.513  -2.232  1.00  0.00           C 
ATOM    141  CG  LEU A  10      -3.964   4.864  -3.759  1.00  0.00           C 
ATOM    142  CD1 LEU A  10      -2.752   4.129  -4.371  1.00  0.00           C 
ATOM    143  CD2 LEU A  10      -5.232   4.548  -4.578  1.00  0.00           C 
ATOM    144  H   LEU A  10      -5.018   4.397   0.485  1.00  0.00           H 
ATOM    145  HA  LEU A  10      -5.199   6.343  -1.700  1.00  0.00           H 
ATOM    146 2HB  LEU A  10      -4.344   3.454  -2.152  1.00  0.00           H 
ATOM    147 1HB  LEU A  10      -3.151   4.673  -1.763  1.00  0.00           H 
ATOM    148  HG  LEU A  10      -3.771   5.929  -3.848  1.00  0.00           H 
ATOM    149 1HD1 LEU A  10      -1.853   4.401  -3.832  1.00  0.00           H 
ATOM    150 2HD1 LEU A  10      -2.633   4.414  -5.410  1.00  0.00           H 
ATOM    151 3HD1 LEU A  10      -2.899   3.060  -4.308  1.00  0.00           H 
ATOM    152 1HD2 LEU A  10      -5.076   4.802  -5.618  1.00  0.00           H 
ATOM    153 2HD2 LEU A  10      -6.065   5.124  -4.196  1.00  0.00           H 
ATOM    154 3HD2 LEU A  10      -5.468   3.492  -4.500  1.00  0.00           H 
ATOM    155  N   HIS A  11      -7.521   5.455  -2.162  1.00  0.00           N 
ATOM    156  CA  HIS A  11      -8.909   5.023  -2.451  1.00  0.00           C 
ATOM    157  C   HIS A  11      -9.022   4.538  -3.915  1.00  0.00           C 
ATOM    158  O   HIS A  11      -8.440   5.144  -4.808  1.00  0.00           O 
ATOM    159  CB  HIS A  11      -9.859   6.222  -2.187  1.00  0.00           C 
ATOM    160  CG  HIS A  11     -11.311   6.011  -2.554  1.00  0.00           C 
ATOM    161  ND1 HIS A  11     -12.115   7.025  -3.033  1.00  0.00           N 
ATOM    162  CD2 HIS A  11     -12.106   4.912  -2.473  1.00  0.00           C 
ATOM    163  CE1 HIS A  11     -13.331   6.558  -3.230  1.00  0.00           C 
ATOM    164  NE2 HIS A  11     -13.352   5.285  -2.896  1.00  0.00           N 
ATOM    165  H   HIS A  11      -7.258   6.357  -2.423  1.00  0.00           H 
ATOM    166  HA  HIS A  11      -9.168   4.208  -1.778  1.00  0.00           H 
ATOM    167 2HB  HIS A  11      -9.500   7.080  -2.747  1.00  0.00           H 
ATOM    168 1HB  HIS A  11      -9.827   6.467  -1.132  1.00  0.00           H 
ATOM    169  HD1 HIS A  11     -11.837   7.951  -3.202  1.00  0.00           H 
ATOM    170  HD2 HIS A  11     -11.792   3.914  -2.187  1.00  0.00           H 
ATOM    171  HE1 HIS A  11     -14.169   7.125  -3.598  1.00  0.00           H 
ATOM    172  HE2 HIS A  11     -14.164   4.745  -2.804  1.00  0.00           H 
ATOM    173  N   LEU A  12      -9.781   3.446  -4.141  1.00  0.00           N 
ATOM    174  CA  LEU A  12      -9.995   2.857  -5.482  1.00  0.00           C 
ATOM    175  C   LEU A  12     -11.490   2.576  -5.724  1.00  0.00           C 
ATOM    176  O   LEU A  12     -12.110   1.830  -4.975  1.00  0.00           O 
ATOM    177  CB  LEU A  12      -9.193   1.535  -5.642  1.00  0.00           C 
ATOM    178  CG  LEU A  12      -7.639   1.670  -5.707  1.00  0.00           C 
ATOM    179  CD1 LEU A  12      -6.956   0.282  -5.754  1.00  0.00           C 
ATOM    180  CD2 LEU A  12      -7.218   2.547  -6.912  1.00  0.00           C 
ATOM    181  H   LEU A  12     -10.225   3.025  -3.380  1.00  0.00           H 
ATOM    182  HA  LEU A  12      -9.648   3.566  -6.232  1.00  0.00           H 
ATOM    183 2HB  LEU A  12      -9.523   1.038  -6.552  1.00  0.00           H 
ATOM    184 1HB  LEU A  12      -9.444   0.894  -4.804  1.00  0.00           H 
ATOM    185  HG  LEU A  12      -7.294   2.168  -4.805  1.00  0.00           H 
ATOM    186 1HD1 LEU A  12      -7.273  -0.256  -6.639  1.00  0.00           H 
ATOM    187 2HD1 LEU A  12      -7.230  -0.289  -4.875  1.00  0.00           H 
ATOM    188 3HD1 LEU A  12      -5.881   0.403  -5.771  1.00  0.00           H 
ATOM    189 1HD2 LEU A  12      -7.556   2.093  -7.836  1.00  0.00           H 
ATOM    190 2HD2 LEU A  12      -6.140   2.646  -6.937  1.00  0.00           H 
ATOM    191 3HD2 LEU A  12      -7.659   3.531  -6.817  1.00  0.00           H 
ATOM    192  N   VAL A  13     -12.051   3.244  -6.737  1.00  0.00           N 
ATOM    193  CA  VAL A  13     -13.336   2.894  -7.399  1.00  0.00           C 
ATOM    194  C   VAL A  13     -13.076   3.039  -8.916  1.00  0.00           C 
ATOM    195  O   VAL A  13     -12.109   3.725  -9.296  1.00  0.00           O 
ATOM    196  CB  VAL A  13     -14.527   3.828  -6.930  1.00  0.00           C 
ATOM    197  CG1 VAL A  13     -15.858   3.513  -7.660  1.00  0.00           C 
ATOM    198  CG2 VAL A  13     -14.735   3.741  -5.402  1.00  0.00           C 
ATOM    199  H   VAL A  13     -11.580   4.036  -7.069  1.00  0.00           H 
ATOM    200  HA  VAL A  13     -13.578   1.856  -7.176  1.00  0.00           H 
ATOM    201  HB  VAL A  13     -14.255   4.855  -7.166  1.00  0.00           H 
ATOM    202 1HG1 VAL A  13     -15.729   3.647  -8.725  1.00  0.00           H 
ATOM    203 2HG1 VAL A  13     -16.639   4.177  -7.311  1.00  0.00           H 
ATOM    204 3HG1 VAL A  13     -16.149   2.486  -7.461  1.00  0.00           H 
ATOM    205 1HG2 VAL A  13     -15.544   4.398  -5.098  1.00  0.00           H 
ATOM    206 2HG2 VAL A  13     -13.829   4.040  -4.895  1.00  0.00           H 
ATOM    207 3HG2 VAL A  13     -14.981   2.723  -5.124  1.00  0.00           H 
ATOM    208  N   SER A  14     -13.897   2.435  -9.805  1.00  0.00           N 
ATOM    209  CA  SER A  14     -13.634   2.491 -11.249  1.00  0.00           C 
ATOM    210  C   SER A  14     -14.392   3.701 -11.809  1.00  0.00           C 
ATOM    211  O   SER A  14     -15.602   3.825 -11.575  1.00  0.00           O 
ATOM    212  CB  SER A  14     -14.108   1.193 -11.941  1.00  0.00           C 
ATOM    213  OG  SER A  14     -13.741   1.176 -13.314  1.00  0.00           O 
ATOM    214  H   SER A  14     -14.777   2.087  -9.568  1.00  0.00           H 
ATOM    215  HA  SER A  14     -12.561   2.613 -11.412  1.00  0.00           H 
ATOM    216 2HB  SER A  14     -15.188   1.105 -11.864  1.00  0.00           H 
ATOM    217 1HB  SER A  14     -13.651   0.341 -11.457  1.00  0.00           H 
ATOM    218  HG  SER A  14     -14.208   0.462 -13.761  1.00  0.00           H 
ATOM    219  N   LEU A  15     -13.686   4.605 -12.504  1.00  0.00           N 
ATOM    220  CA  LEU A  15     -14.301   5.816 -13.070  1.00  0.00           C 
ATOM    221  C   LEU A  15     -15.236   5.433 -14.251  1.00  0.00           C 
ATOM    222  O   LEU A  15     -14.894   4.533 -15.035  1.00  0.00           O 
ATOM    223  CB  LEU A  15     -13.192   6.848 -13.458  1.00  0.00           C 
ATOM    224  CG  LEU A  15     -12.126   6.418 -14.537  1.00  0.00           C 
ATOM    225  CD1 LEU A  15     -12.578   6.764 -15.978  1.00  0.00           C 
ATOM    226  CD2 LEU A  15     -10.733   7.029 -14.237  1.00  0.00           C 
ATOM    227  H   LEU A  15     -12.733   4.445 -12.654  1.00  0.00           H 
ATOM    228  HA  LEU A  15     -14.911   6.258 -12.283  1.00  0.00           H 
ATOM    229 2HB  LEU A  15     -12.665   7.103 -12.541  1.00  0.00           H 
ATOM    230 1HB  LEU A  15     -13.685   7.754 -13.803  1.00  0.00           H 
ATOM    231  HG  LEU A  15     -12.016   5.339 -14.497  1.00  0.00           H 
ATOM    232 1HD1 LEU A  15     -11.837   6.415 -16.690  1.00  0.00           H 
ATOM    233 2HD1 LEU A  15     -12.689   7.836 -16.077  1.00  0.00           H 
ATOM    234 3HD1 LEU A  15     -13.525   6.286 -16.189  1.00  0.00           H 
ATOM    235 1HD2 LEU A  15     -10.023   6.705 -14.987  1.00  0.00           H 
ATOM    236 2HD2 LEU A  15     -10.392   6.700 -13.265  1.00  0.00           H 
ATOM    237 3HD2 LEU A  15     -10.795   8.111 -14.245  1.00  0.00           H 
ATOM    238  N   PRO A  16     -16.448   6.073 -14.363  1.00  0.00           N 
ATOM    239  CA  PRO A  16     -17.434   5.743 -15.418  1.00  0.00           C 
ATOM    240  C   PRO A  16     -16.866   5.982 -16.835  1.00  0.00           C 
ATOM    241  O   PRO A  16     -16.247   7.022 -17.106  1.00  0.00           O 
ATOM    242  CB  PRO A  16     -18.642   6.673 -15.098  1.00  0.00           C 
ATOM    243  CG  PRO A  16     -18.065   7.780 -14.273  1.00  0.00           C 
ATOM    244  CD  PRO A  16     -16.955   7.147 -13.467  1.00  0.00           C 
ATOM    245  HA  PRO A  16     -17.746   4.703 -15.334  1.00  0.00           H 
ATOM    246 2HB  PRO A  16     -19.388   6.117 -14.538  1.00  0.00           H 
ATOM    247 1HB  PRO A  16     -19.093   7.050 -16.012  1.00  0.00           H 
ATOM    248 2HG  PRO A  16     -18.825   8.194 -13.618  1.00  0.00           H 
ATOM    249 1HG  PRO A  16     -17.668   8.564 -14.918  1.00  0.00           H 
ATOM    250 2HD  PRO A  16     -17.337   6.725 -12.541  1.00  0.00           H 
ATOM    251 1HD  PRO A  16     -16.180   7.876 -13.251  1.00  0.00           H 
ATOM    252  N   GLY A  17     -17.074   4.995 -17.717  1.00  0.00           N 
ATOM    253  CA  GLY A  17     -16.491   4.985 -19.061  1.00  0.00           C 
ATOM    254  C   GLY A  17     -15.361   3.967 -19.184  1.00  0.00           C 
ATOM    255  O   GLY A  17     -15.148   3.398 -20.260  1.00  0.00           O 
ATOM    256  H   GLY A  17     -17.649   4.248 -17.447  1.00  0.00           H 
ATOM    257 2HA  GLY A  17     -16.104   5.969 -19.310  1.00  0.00           H 
ATOM    258 1HA  GLY A  17     -17.269   4.735 -19.770  1.00  0.00           H 
ATOM    259  N   LEU A  18     -14.629   3.741 -18.070  1.00  0.00           N 
ATOM    260  CA  LEU A  18     -13.489   2.804 -18.026  1.00  0.00           C 
ATOM    261  C   LEU A  18     -13.995   1.352 -17.944  1.00  0.00           C 
ATOM    262  O   LEU A  18     -13.786   0.564 -18.878  1.00  0.00           O 
ATOM    263  CB  LEU A  18     -12.565   3.146 -16.822  1.00  0.00           C 
ATOM    264  CG  LEU A  18     -11.286   2.264 -16.636  1.00  0.00           C 
ATOM    265  CD1 LEU A  18     -10.365   2.318 -17.878  1.00  0.00           C 
ATOM    266  CD2 LEU A  18     -10.522   2.674 -15.355  1.00  0.00           C 
ATOM    267  H   LEU A  18     -14.867   4.225 -17.248  1.00  0.00           H 
ATOM    268  HA  LEU A  18     -12.918   2.926 -18.946  1.00  0.00           H 
ATOM    269 2HB  LEU A  18     -13.161   3.074 -15.917  1.00  0.00           H 
ATOM    270 1HB  LEU A  18     -12.248   4.180 -16.929  1.00  0.00           H 
ATOM    271  HG  LEU A  18     -11.593   1.231 -16.512  1.00  0.00           H 
ATOM    272 1HD1 LEU A  18     -10.893   1.940 -18.743  1.00  0.00           H 
ATOM    273 2HD1 LEU A  18      -9.487   1.707 -17.708  1.00  0.00           H 
ATOM    274 3HD1 LEU A  18     -10.055   3.340 -18.066  1.00  0.00           H 
ATOM    275 1HD2 LEU A  18      -9.649   2.044 -15.234  1.00  0.00           H 
ATOM    276 2HD2 LEU A  18     -11.164   2.554 -14.491  1.00  0.00           H 
ATOM    277 3HD2 LEU A  18     -10.209   3.709 -15.426  1.00  0.00           H 
ATOM    278  N   ASP A  19     -14.673   1.023 -16.827  1.00  0.00           N 
ATOM    279  CA  ASP A  19     -15.207  -0.327 -16.570  1.00  0.00           C 
ATOM    280  C   ASP A  19     -16.367  -0.235 -15.566  1.00  0.00           C 
ATOM    281  O   ASP A  19     -16.154   0.074 -14.392  1.00  0.00           O 
ATOM    282  CB  ASP A  19     -14.083  -1.273 -16.043  1.00  0.00           C 
ATOM    283  CG  ASP A  19     -14.572  -2.707 -15.753  1.00  0.00           C 
ATOM    284  OD1 ASP A  19     -15.077  -3.371 -16.683  1.00  0.00           O 
ATOM    285  OD2 ASP A  19     -14.447  -3.184 -14.604  1.00  0.00           O 
ATOM    286  H   ASP A  19     -14.821   1.715 -16.146  1.00  0.00           H 
ATOM    287  HA  ASP A  19     -15.589  -0.725 -17.509  1.00  0.00           H 
ATOM    288 2HB  ASP A  19     -13.666  -0.849 -15.135  1.00  0.00           H 
ATOM    289 1HB  ASP A  19     -13.293  -1.330 -16.787  1.00  0.00           H 
ATOM    290  N   GLN A  20     -17.601  -0.473 -16.047  1.00  0.00           N 
ATOM    291  CA  GLN A  20     -18.811  -0.441 -15.212  1.00  0.00           C 
ATOM    292  C   GLN A  20     -18.952  -1.771 -14.446  1.00  0.00           C 
ATOM    293  O   GLN A  20     -19.638  -2.702 -14.884  1.00  0.00           O 
ATOM    294  CB  GLN A  20     -20.082  -0.121 -16.069  1.00  0.00           C 
ATOM    295  CG  GLN A  20     -20.203   1.352 -16.540  1.00  0.00           C 
ATOM    296  CD  GLN A  20     -19.119   1.782 -17.538  1.00  0.00           C 
ATOM    297  OE1 GLN A  20     -18.051   2.270 -17.156  1.00  0.00           O 
ATOM    298  NE2 GLN A  20     -19.390   1.619 -18.824  1.00  0.00           N 
ATOM    299  H   GLN A  20     -17.698  -0.678 -16.999  1.00  0.00           H 
ATOM    300  HA  GLN A  20     -18.685   0.360 -14.482  1.00  0.00           H 
ATOM    301 2HB  GLN A  20     -20.964  -0.349 -15.480  1.00  0.00           H 
ATOM    302 1HB  GLN A  20     -20.085  -0.758 -16.947  1.00  0.00           H 
ATOM    303 2HG  GLN A  20     -20.148   1.997 -15.673  1.00  0.00           H 
ATOM    304 1HG  GLN A  20     -21.173   1.487 -17.008  1.00  0.00           H 
ATOM    305 2HE2 GLN A  20     -20.256   1.233 -19.070  1.00  0.00           H 
ATOM    306 1HE2 GLN A  20     -18.712   1.891 -19.479  1.00  0.00           H 
ATOM    307  N   GLN A  21     -18.229  -1.843 -13.323  1.00  0.00           N 
ATOM    308  CA  GLN A  21     -18.253  -2.971 -12.386  1.00  0.00           C 
ATOM    309  C   GLN A  21     -18.057  -2.406 -10.977  1.00  0.00           C 
ATOM    310  O   GLN A  21     -17.362  -1.389 -10.806  1.00  0.00           O 
ATOM    311  CB  GLN A  21     -17.137  -3.996 -12.730  1.00  0.00           C 
ATOM    312  CG  GLN A  21     -17.169  -5.302 -11.906  1.00  0.00           C 
ATOM    313  CD  GLN A  21     -16.076  -6.297 -12.307  1.00  0.00           C 
ATOM    314  OE1 GLN A  21     -16.263  -7.107 -13.214  1.00  0.00           O 
ATOM    315  NE2 GLN A  21     -14.933  -6.255 -11.635  1.00  0.00           N 
ATOM    316  H   GLN A  21     -17.645  -1.082 -13.106  1.00  0.00           H 
ATOM    317  HA  GLN A  21     -19.226  -3.453 -12.446  1.00  0.00           H 
ATOM    318 2HB  GLN A  21     -16.173  -3.523 -12.578  1.00  0.00           H 
ATOM    319 1HB  GLN A  21     -17.223  -4.257 -13.781  1.00  0.00           H 
ATOM    320 2HG  GLN A  21     -18.136  -5.775 -12.042  1.00  0.00           H 
ATOM    321 1HG  GLN A  21     -17.046  -5.055 -10.856  1.00  0.00           H 
ATOM    322 2HE2 GLN A  21     -14.843  -5.598 -10.921  1.00  0.00           H 
ATOM    323 1HE2 GLN A  21     -14.221  -6.886 -11.881  1.00  0.00           H 
ATOM    324  N   ASP A  22     -18.655  -3.067  -9.977  1.00  0.00           N 
ATOM    325  CA  ASP A  22     -18.577  -2.626  -8.576  1.00  0.00           C 
ATOM    326  C   ASP A  22     -17.223  -3.037  -7.987  1.00  0.00           C 
ATOM    327  O   ASP A  22     -17.087  -4.115  -7.404  1.00  0.00           O 
ATOM    328  CB  ASP A  22     -19.759  -3.213  -7.751  1.00  0.00           C 
ATOM    329  CG  ASP A  22     -19.741  -2.828  -6.254  1.00  0.00           C 
ATOM    330  OD1 ASP A  22     -19.571  -3.714  -5.384  1.00  0.00           O 
ATOM    331  OD2 ASP A  22     -19.891  -1.624  -5.945  1.00  0.00           O 
ATOM    332  H   ASP A  22     -19.128  -3.901 -10.182  1.00  0.00           H 
ATOM    333  HA  ASP A  22     -18.645  -1.536  -8.565  1.00  0.00           H 
ATOM    334 2HB  ASP A  22     -19.737  -4.294  -7.837  1.00  0.00           H 
ATOM    335 1HB  ASP A  22     -20.690  -2.857  -8.177  1.00  0.00           H 
ATOM    336  N   ILE A  23     -16.190  -2.218  -8.247  1.00  0.00           N 
ATOM    337  CA  ILE A  23     -14.882  -2.380  -7.609  1.00  0.00           C 
ATOM    338  C   ILE A  23     -14.695  -1.215  -6.635  1.00  0.00           C 
ATOM    339  O   ILE A  23     -14.928  -0.050  -6.983  1.00  0.00           O 
ATOM    340  CB  ILE A  23     -13.684  -2.511  -8.656  1.00  0.00           C 
ATOM    341  CG1 ILE A  23     -13.206  -1.140  -9.277  1.00  0.00           C 
ATOM    342  CG2 ILE A  23     -14.069  -3.505  -9.777  1.00  0.00           C 
ATOM    343  CD1 ILE A  23     -11.995  -0.499  -8.596  1.00  0.00           C 
ATOM    344  H   ILE A  23     -16.317  -1.488  -8.895  1.00  0.00           H 
ATOM    345  HA  ILE A  23     -14.909  -3.306  -7.026  1.00  0.00           H 
ATOM    346  HB  ILE A  23     -12.846  -2.960  -8.120  1.00  0.00           H 
ATOM    347 2HG1 ILE A  23     -14.018  -0.422  -9.237  1.00  0.00           H 
ATOM    348 1HG1 ILE A  23     -12.928  -1.283 -10.315  1.00  0.00           H 
ATOM    349 1HG2 ILE A  23     -13.249  -3.606 -10.478  1.00  0.00           H 
ATOM    350 2HG2 ILE A  23     -14.943  -3.142 -10.305  1.00  0.00           H 
ATOM    351 3HG2 ILE A  23     -14.292  -4.474  -9.348  1.00  0.00           H 
ATOM    352 1HD1 ILE A  23     -12.217  -0.305  -7.554  1.00  0.00           H 
ATOM    353 2HD1 ILE A  23     -11.763   0.433  -9.090  1.00  0.00           H 
ATOM    354 3HD1 ILE A  23     -11.147  -1.164  -8.669  1.00  0.00           H 
ATOM    355  N   ASN A  24     -14.353  -1.554  -5.398  1.00  0.00           N 
ATOM    356  CA  ASN A  24     -14.068  -0.582  -4.346  1.00  0.00           C 
ATOM    357  C   ASN A  24     -13.066  -1.203  -3.375  1.00  0.00           C 
ATOM    358  O   ASN A  24     -13.285  -2.299  -2.847  1.00  0.00           O 
ATOM    359  CB  ASN A  24     -15.359  -0.070  -3.644  1.00  0.00           C 
ATOM    360  CG  ASN A  24     -16.286  -1.164  -3.116  1.00  0.00           C 
ATOM    361  OD1 ASN A  24     -16.199  -1.563  -1.958  1.00  0.00           O 
ATOM    362  ND2 ASN A  24     -17.171  -1.666  -3.973  1.00  0.00           N 
ATOM    363  H   ASN A  24     -14.280  -2.510  -5.190  1.00  0.00           H 
ATOM    364  HA  ASN A  24     -13.581   0.271  -4.826  1.00  0.00           H 
ATOM    365 2HB  ASN A  24     -15.923   0.534  -4.348  1.00  0.00           H 
ATOM    366 1HB  ASN A  24     -15.078   0.563  -2.808  1.00  0.00           H 
ATOM    367 2HD2 ASN A  24     -17.185  -1.311  -4.887  1.00  0.00           H 
ATOM    368 1HD2 ASN A  24     -17.765  -2.384  -3.662  1.00  0.00           H 
ATOM    369  N   ILE A  25     -11.938  -0.500  -3.196  1.00  0.00           N 
ATOM    370  CA  ILE A  25     -10.764  -0.971  -2.451  1.00  0.00           C 
ATOM    371  C   ILE A  25     -10.221   0.217  -1.653  1.00  0.00           C 
ATOM    372  O   ILE A  25     -10.222   1.356  -2.139  1.00  0.00           O 
ATOM    373  CB  ILE A  25      -9.608  -1.495  -3.399  1.00  0.00           C 
ATOM    374  CG1 ILE A  25     -10.131  -2.536  -4.436  1.00  0.00           C 
ATOM    375  CG2 ILE A  25      -8.430  -2.089  -2.576  1.00  0.00           C 
ATOM    376  CD1 ILE A  25      -9.111  -2.967  -5.474  1.00  0.00           C 
ATOM    377  H   ILE A  25     -11.906   0.417  -3.535  1.00  0.00           H 
ATOM    378  HA  ILE A  25     -11.067  -1.768  -1.773  1.00  0.00           H 
ATOM    379  HB  ILE A  25      -9.219  -0.635  -3.944  1.00  0.00           H 
ATOM    380 2HG1 ILE A  25     -10.978  -2.118  -4.970  1.00  0.00           H 
ATOM    381 1HG1 ILE A  25     -10.456  -3.431  -3.919  1.00  0.00           H 
ATOM    382 1HG2 ILE A  25      -7.635  -2.401  -3.245  1.00  0.00           H 
ATOM    383 2HG2 ILE A  25      -8.773  -2.946  -2.010  1.00  0.00           H 
ATOM    384 3HG2 ILE A  25      -8.045  -1.342  -1.893  1.00  0.00           H 
ATOM    385 1HD1 ILE A  25      -9.569  -3.666  -6.155  1.00  0.00           H 
ATOM    386 2HD1 ILE A  25      -8.273  -3.445  -4.984  1.00  0.00           H 
ATOM    387 3HD1 ILE A  25      -8.759  -2.105  -6.028  1.00  0.00           H 
ATOM    388  N   HIS A  26      -9.790  -0.046  -0.427  1.00  0.00           N 
ATOM    389  CA  HIS A  26      -9.086   0.923   0.411  1.00  0.00           C 
ATOM    390  C   HIS A  26      -7.667   0.375   0.593  1.00  0.00           C 
ATOM    391  O   HIS A  26      -7.521  -0.815   0.856  1.00  0.00           O 
ATOM    392  CB  HIS A  26      -9.795   1.066   1.797  1.00  0.00           C 
ATOM    393  CG  HIS A  26     -11.306   1.197   1.770  1.00  0.00           C 
ATOM    394  ND1 HIS A  26     -12.106   0.832   2.833  1.00  0.00           N 
ATOM    395  CD2 HIS A  26     -12.158   1.660   0.818  1.00  0.00           C 
ATOM    396  CE1 HIS A  26     -13.369   1.063   2.538  1.00  0.00           C 
ATOM    397  NE2 HIS A  26     -13.425   1.566   1.323  1.00  0.00           N 
ATOM    398  H   HIS A  26      -9.945  -0.938  -0.061  1.00  0.00           H 
ATOM    399  HA  HIS A  26      -9.046   1.888  -0.093  1.00  0.00           H 
ATOM    400 2HB  HIS A  26      -9.402   1.943   2.299  1.00  0.00           H 
ATOM    401 1HB  HIS A  26      -9.568   0.195   2.400  1.00  0.00           H 
ATOM    402  HD1 HIS A  26     -11.791   0.444   3.677  1.00  0.00           H 
ATOM    403  HD2 HIS A  26     -11.887   2.016  -0.165  1.00  0.00           H 
ATOM    404  HE1 HIS A  26     -14.214   0.866   3.177  1.00  0.00           H 
ATOM    405  HE2 HIS A  26     -14.248   1.778   0.837  1.00  0.00           H 
ATOM    406  N   ILE A  27      -6.632   1.213   0.442  1.00  0.00           N 
ATOM    407  CA  ILE A  27      -5.231   0.800   0.655  1.00  0.00           C 
ATOM    408  C   ILE A  27      -4.631   1.734   1.713  1.00  0.00           C 
ATOM    409  O   ILE A  27      -4.342   2.889   1.438  1.00  0.00           O 
ATOM    410  CB  ILE A  27      -4.367   0.863  -0.670  1.00  0.00           C 
ATOM    411  CG1 ILE A  27      -5.003  -0.016  -1.805  1.00  0.00           C 
ATOM    412  CG2 ILE A  27      -2.892   0.432  -0.400  1.00  0.00           C 
ATOM    413  CD1 ILE A  27      -4.245  -0.003  -3.128  1.00  0.00           C 
ATOM    414  H   ILE A  27      -6.809   2.142   0.228  1.00  0.00           H 
ATOM    415  HA  ILE A  27      -5.211  -0.228   1.030  1.00  0.00           H 
ATOM    416  HB  ILE A  27      -4.350   1.899  -1.002  1.00  0.00           H 
ATOM    417 2HG1 ILE A  27      -6.014   0.331  -2.005  1.00  0.00           H 
ATOM    418 1HG1 ILE A  27      -5.052  -1.046  -1.477  1.00  0.00           H 
ATOM    419 1HG2 ILE A  27      -2.866  -0.597  -0.063  1.00  0.00           H 
ATOM    420 2HG2 ILE A  27      -2.460   1.063   0.368  1.00  0.00           H 
ATOM    421 3HG2 ILE A  27      -2.303   0.526  -1.304  1.00  0.00           H 
ATOM    422 1HD1 ILE A  27      -4.774  -0.612  -3.849  1.00  0.00           H 
ATOM    423 2HD1 ILE A  27      -3.252  -0.404  -2.985  1.00  0.00           H 
ATOM    424 3HD1 ILE A  27      -4.178   1.010  -3.502  1.00  0.00           H 
ATOM    425  N   ARG A  28      -4.461   1.212   2.912  1.00  0.00           N 
ATOM    426  CA  ARG A  28      -3.893   1.936   4.051  1.00  0.00           C 
ATOM    427  C   ARG A  28      -2.453   1.471   4.225  1.00  0.00           C 
ATOM    428  O   ARG A  28      -2.190   0.273   4.173  1.00  0.00           O 
ATOM    429  CB  ARG A  28      -4.735   1.635   5.320  1.00  0.00           C 
ATOM    430  CG  ARG A  28      -4.268   2.331   6.615  1.00  0.00           C 
ATOM    431  CD  ARG A  28      -5.196   2.012   7.802  1.00  0.00           C 
ATOM    432  NE  ARG A  28      -4.780   2.692   9.038  1.00  0.00           N 
ATOM    433  CZ  ARG A  28      -5.565   2.918  10.102  1.00  0.00           C 
ATOM    434  NH1 ARG A  28      -6.853   2.609  10.074  1.00  0.00           N 
ATOM    435  NH2 ARG A  28      -5.055   3.463  11.194  1.00  0.00           N 
ATOM    436  H   ARG A  28      -4.724   0.286   3.047  1.00  0.00           H 
ATOM    437  HA  ARG A  28      -3.915   3.005   3.845  1.00  0.00           H 
ATOM    438 2HB  ARG A  28      -4.735   0.561   5.487  1.00  0.00           H 
ATOM    439 1HB  ARG A  28      -5.757   1.946   5.124  1.00  0.00           H 
ATOM    440 2HG  ARG A  28      -4.259   3.403   6.455  1.00  0.00           H 
ATOM    441 1HG  ARG A  28      -3.266   1.998   6.855  1.00  0.00           H 
ATOM    442 2HD  ARG A  28      -5.188   0.942   7.974  1.00  0.00           H 
ATOM    443 1HD  ARG A  28      -6.206   2.323   7.549  1.00  0.00           H 
ATOM    444  HE  ARG A  28      -3.851   2.976   9.087  1.00  0.00           H 
ATOM    445 1HH1 ARG A  28      -7.258   2.207   9.252  1.00  0.00           H 
ATOM    446 2HH1 ARG A  28      -7.429   2.778  10.877  1.00  0.00           H 
ATOM    447 1HH2 ARG A  28      -4.081   3.705  11.226  1.00  0.00           H 
ATOM    448 2HH2 ARG A  28      -5.638   3.639  11.992  1.00  0.00           H 
ATOM    449  N   TYR A  29      -1.520   2.408   4.386  1.00  0.00           N 
ATOM    450  CA  TYR A  29      -0.120   2.079   4.660  1.00  0.00           C 
ATOM    451  C   TYR A  29       0.343   2.884   5.878  1.00  0.00           C 
ATOM    452  O   TYR A  29       0.193   4.113   5.923  1.00  0.00           O 
ATOM    453  CB  TYR A  29       0.775   2.295   3.402  1.00  0.00           C 
ATOM    454  CG  TYR A  29       0.919   3.736   2.880  1.00  0.00           C 
ATOM    455  CD1 TYR A  29       1.995   4.543   3.276  1.00  0.00           C 
ATOM    456  CD2 TYR A  29      -0.010   4.289   1.996  1.00  0.00           C 
ATOM    457  CE1 TYR A  29       2.132   5.833   2.814  1.00  0.00           C 
ATOM    458  CE2 TYR A  29       0.131   5.583   1.527  1.00  0.00           C 
ATOM    459  CZ  TYR A  29       1.200   6.351   1.944  1.00  0.00           C 
ATOM    460  OH  TYR A  29       1.331   7.643   1.500  1.00  0.00           O 
ATOM    461  H   TYR A  29      -1.780   3.354   4.348  1.00  0.00           H 
ATOM    462  HA  TYR A  29      -0.072   1.019   4.928  1.00  0.00           H 
ATOM    463 2HB  TYR A  29       0.368   1.693   2.593  1.00  0.00           H 
ATOM    464 1HB  TYR A  29       1.769   1.924   3.616  1.00  0.00           H 
ATOM    465  HD1 TYR A  29       2.730   4.140   3.961  1.00  0.00           H 
ATOM    466  HD2 TYR A  29      -0.853   3.689   1.669  1.00  0.00           H 
ATOM    467  HE1 TYR A  29       2.971   6.435   3.136  1.00  0.00           H 
ATOM    468  HE2 TYR A  29      -0.603   5.993   0.844  1.00  0.00           H 
ATOM    469  HH  TYR A  29       2.260   7.825   1.314  1.00  0.00           H 
ATOM    470  N   GLU A  30       0.830   2.161   6.889  1.00  0.00           N 
ATOM    471  CA  GLU A  30       1.320   2.727   8.146  1.00  0.00           C 
ATOM    472  C   GLU A  30       2.724   2.190   8.394  1.00  0.00           C 
ATOM    473  O   GLU A  30       2.901   0.979   8.560  1.00  0.00           O 
ATOM    474  CB  GLU A  30       0.393   2.334   9.327  1.00  0.00           C 
ATOM    475  CG  GLU A  30      -1.074   2.767   9.177  1.00  0.00           C 
ATOM    476  CD  GLU A  30      -1.896   2.506  10.444  1.00  0.00           C 
ATOM    477  OE1 GLU A  30      -2.382   1.374  10.628  1.00  0.00           O 
ATOM    478  OE2 GLU A  30      -2.071   3.435  11.258  1.00  0.00           O 
ATOM    479  H   GLU A  30       0.869   1.193   6.780  1.00  0.00           H 
ATOM    480  HA  GLU A  30       1.355   3.814   8.063  1.00  0.00           H 
ATOM    481 2HB  GLU A  30       0.789   2.783  10.237  1.00  0.00           H 
ATOM    482 1HB  GLU A  30       0.414   1.252   9.446  1.00  0.00           H 
ATOM    483 2HG  GLU A  30      -1.523   2.220   8.352  1.00  0.00           H 
ATOM    484 1HG  GLU A  30      -1.105   3.827   8.942  1.00  0.00           H 
ATOM    485  N   VAL A  31       3.716   3.081   8.411  1.00  0.00           N 
ATOM    486  CA  VAL A  31       5.100   2.694   8.661  1.00  0.00           C 
ATOM    487  C   VAL A  31       5.310   2.491  10.166  1.00  0.00           C 
ATOM    488  O   VAL A  31       5.168   3.426  10.963  1.00  0.00           O 
ATOM    489  CB  VAL A  31       6.101   3.756   8.089  1.00  0.00           C 
ATOM    490  CG1 VAL A  31       7.579   3.365   8.368  1.00  0.00           C 
ATOM    491  CG2 VAL A  31       5.846   3.944   6.576  1.00  0.00           C 
ATOM    492  H   VAL A  31       3.510   4.029   8.264  1.00  0.00           H 
ATOM    493  HA  VAL A  31       5.281   1.746   8.141  1.00  0.00           H 
ATOM    494  HB  VAL A  31       5.908   4.705   8.584  1.00  0.00           H 
ATOM    495 1HG1 VAL A  31       7.795   2.405   7.915  1.00  0.00           H 
ATOM    496 2HG1 VAL A  31       7.749   3.300   9.433  1.00  0.00           H 
ATOM    497 3HG1 VAL A  31       8.244   4.114   7.949  1.00  0.00           H 
ATOM    498 1HG2 VAL A  31       5.992   3.006   6.057  1.00  0.00           H 
ATOM    499 2HG2 VAL A  31       6.534   4.679   6.178  1.00  0.00           H 
ATOM    500 3HG2 VAL A  31       4.830   4.286   6.410  1.00  0.00           H 
ATOM    501  N   ARG A  32       5.643   1.256  10.526  1.00  0.00           N 
ATOM    502  CA  ARG A  32       5.896   0.833  11.906  1.00  0.00           C 
ATOM    503  C   ARG A  32       7.346   0.340  11.980  1.00  0.00           C 
ATOM    504  O   ARG A  32       7.948   0.008  10.952  1.00  0.00           O 
ATOM    505  CB  ARG A  32       4.916  -0.307  12.304  1.00  0.00           C 
ATOM    506  CG  ARG A  32       4.998  -0.761  13.789  1.00  0.00           C 
ATOM    507  CD  ARG A  32       4.409  -2.152  14.004  1.00  0.00           C 
ATOM    508  NE  ARG A  32       4.377  -2.570  15.419  1.00  0.00           N 
ATOM    509  CZ  ARG A  32       4.117  -3.823  15.844  1.00  0.00           C 
ATOM    510  NH1 ARG A  32       3.940  -4.810  14.972  1.00  0.00           N 
ATOM    511  NH2 ARG A  32       4.059  -4.089  17.142  1.00  0.00           N 
ATOM    512  H   ARG A  32       5.766   0.589   9.818  1.00  0.00           H 
ATOM    513  HA  ARG A  32       5.766   1.683  12.575  1.00  0.00           H 
ATOM    514 2HB  ARG A  32       5.114  -1.168  11.671  1.00  0.00           H 
ATOM    515 1HB  ARG A  32       3.899   0.025  12.114  1.00  0.00           H 
ATOM    516 2HG  ARG A  32       4.458  -0.049  14.404  1.00  0.00           H 
ATOM    517 1HG  ARG A  32       6.038  -0.774  14.102  1.00  0.00           H 
ATOM    518 2HD  ARG A  32       5.020  -2.858  13.448  1.00  0.00           H 
ATOM    519 1HD  ARG A  32       3.399  -2.172  13.615  1.00  0.00           H 
ATOM    520  HE  ARG A  32       4.541  -1.871  16.090  1.00  0.00           H 
ATOM    521 1HH1 ARG A  32       4.001  -4.633  13.983  1.00  0.00           H 
ATOM    522 2HH1 ARG A  32       3.748  -5.738  15.294  1.00  0.00           H 
ATOM    523 1HH2 ARG A  32       4.211  -3.359  17.813  1.00  0.00           H 
ATOM    524 2HH2 ARG A  32       3.862  -5.023  17.459  1.00  0.00           H 
ATOM    525  N   GLN A  33       7.916   0.305  13.183  1.00  0.00           N 
ATOM    526  CA  GLN A  33       9.278  -0.182  13.398  1.00  0.00           C 
ATOM    527  C   GLN A  33       9.241  -1.548  14.104  1.00  0.00           C 
ATOM    528  O   GLN A  33       8.695  -1.668  15.199  1.00  0.00           O 
ATOM    529  CB  GLN A  33      10.112   0.837  14.227  1.00  0.00           C 
ATOM    530  CG  GLN A  33      10.094   2.295  13.722  1.00  0.00           C 
ATOM    531  CD  GLN A  33      10.625   2.478  12.299  1.00  0.00           C 
ATOM    532  OE1 GLN A  33      11.831   2.616  12.086  1.00  0.00           O 
ATOM    533  NE2 GLN A  33       9.728   2.539  11.320  1.00  0.00           N 
ATOM    534  H   GLN A  33       7.399   0.599  13.953  1.00  0.00           H 
ATOM    535  HA  GLN A  33       9.747  -0.310  12.427  1.00  0.00           H 
ATOM    536 2HB  GLN A  33      11.149   0.504  14.248  1.00  0.00           H 
ATOM    537 1HB  GLN A  33       9.740   0.840  15.240  1.00  0.00           H 
ATOM    538 2HG  GLN A  33      10.694   2.900  14.390  1.00  0.00           H 
ATOM    539 1HG  GLN A  33       9.071   2.657  13.757  1.00  0.00           H 
ATOM    540 2HE2 GLN A  33       8.780   2.463  11.560  1.00  0.00           H 
ATOM    541 1HE2 GLN A  33      10.047   2.667  10.406  1.00  0.00           H 
ATOM    542  N   ASN A  34       9.791  -2.570  13.437  1.00  0.00           N 
ATOM    543  CA  ASN A  34      10.073  -3.899  14.031  1.00  0.00           C 
ATOM    544  C   ASN A  34      11.561  -3.977  14.409  1.00  0.00           C 
ATOM    545  O   ASN A  34      12.392  -3.360  13.754  1.00  0.00           O 
ATOM    546  CB  ASN A  34       9.684  -5.067  13.057  1.00  0.00           C 
ATOM    547  CG  ASN A  34      10.487  -5.200  11.737  1.00  0.00           C 
ATOM    548  OD1 ASN A  34      10.576  -6.289  11.190  1.00  0.00           O 
ATOM    549  ND2 ASN A  34      11.099  -4.142  11.222  1.00  0.00           N 
ATOM    550  H   ASN A  34      10.044  -2.421  12.513  1.00  0.00           H 
ATOM    551  HA  ASN A  34       9.480  -3.993  14.941  1.00  0.00           H 
ATOM    552 2HB  ASN A  34       8.638  -4.956  12.795  1.00  0.00           H 
ATOM    553 1HB  ASN A  34       9.801  -6.008  13.585  1.00  0.00           H 
ATOM    554 2HD2 ASN A  34      11.047  -3.299  11.691  1.00  0.00           H 
ATOM    555 1HD2 ASN A  34      11.561  -4.250  10.367  1.00  0.00           H 
ATOM    556  N   ALA A  35      11.890  -4.732  15.463  1.00  0.00           N 
ATOM    557  CA  ALA A  35      13.290  -4.924  15.913  1.00  0.00           C 
ATOM    558  C   ALA A  35      14.095  -5.817  14.937  1.00  0.00           C 
ATOM    559  O   ALA A  35      15.325  -5.902  15.038  1.00  0.00           O 
ATOM    560  CB  ALA A  35      13.302  -5.505  17.335  1.00  0.00           C 
ATOM    561  H   ALA A  35      11.175  -5.183  15.958  1.00  0.00           H 
ATOM    562  HA  ALA A  35      13.764  -3.947  15.952  1.00  0.00           H 
ATOM    563 1HB  ALA A  35      14.323  -5.601  17.686  1.00  0.00           H 
ATOM    564 2HB  ALA A  35      12.831  -6.480  17.334  1.00  0.00           H 
ATOM    565 3HB  ALA A  35      12.754  -4.849  18.000  1.00  0.00           H 
ATOM    566  N   GLU A  36      13.386  -6.469  13.998  1.00  0.00           N 
ATOM    567  CA  GLU A  36      13.981  -7.370  13.003  1.00  0.00           C 
ATOM    568  C   GLU A  36      14.697  -6.589  11.875  1.00  0.00           C 
ATOM    569  O   GLU A  36      15.887  -6.809  11.622  1.00  0.00           O 
ATOM    570  CB  GLU A  36      12.869  -8.279  12.419  1.00  0.00           C 
ATOM    571  CG  GLU A  36      13.323  -9.215  11.280  1.00  0.00           C 
ATOM    572  CD  GLU A  36      12.177 -10.041  10.683  1.00  0.00           C 
ATOM    573  OE1 GLU A  36      11.908 -11.160  11.173  1.00  0.00           O 
ATOM    574  OE2 GLU A  36      11.521  -9.564   9.732  1.00  0.00           O 
ATOM    575  H   GLU A  36      12.415  -6.351  13.989  1.00  0.00           H 
ATOM    576  HA  GLU A  36      14.709  -7.995  13.516  1.00  0.00           H 
ATOM    577 2HB  GLU A  36      12.075  -7.645  12.041  1.00  0.00           H 
ATOM    578 1HB  GLU A  36      12.468  -8.889  13.221  1.00  0.00           H 
ATOM    579 2HG  GLU A  36      14.083  -9.886  11.663  1.00  0.00           H 
ATOM    580 1HG  GLU A  36      13.759  -8.606  10.495  1.00  0.00           H 
ATOM    581  N   SER A  37      13.970  -5.671  11.209  1.00  0.00           N 
ATOM    582  CA  SER A  37      14.483  -4.925  10.024  1.00  0.00           C 
ATOM    583  C   SER A  37      14.617  -3.417  10.315  1.00  0.00           C 
ATOM    584  O   SER A  37      15.155  -2.659   9.498  1.00  0.00           O 
ATOM    585  CB  SER A  37      13.536  -5.167   8.813  1.00  0.00           C 
ATOM    586  OG  SER A  37      14.001  -4.528   7.627  1.00  0.00           O 
ATOM    587  H   SER A  37      13.059  -5.491  11.514  1.00  0.00           H 
ATOM    588  HA  SER A  37      15.469  -5.310   9.771  1.00  0.00           H 
ATOM    589 2HB  SER A  37      12.549  -4.786   9.043  1.00  0.00           H 
ATOM    590 1HB  SER A  37      13.467  -6.229   8.619  1.00  0.00           H 
ATOM    591  HG  SER A  37      14.531  -5.151   7.111  1.00  0.00           H 
ATOM    592  N   GLY A  38      14.134  -2.991  11.486  1.00  0.00           N 
ATOM    593  CA  GLY A  38      14.043  -1.571  11.818  1.00  0.00           C 
ATOM    594  C   GLY A  38      12.745  -1.004  11.274  1.00  0.00           C 
ATOM    595  O   GLY A  38      11.676  -1.339  11.769  1.00  0.00           O 
ATOM    596  H   GLY A  38      13.804  -3.653  12.124  1.00  0.00           H 
ATOM    597 2HA  GLY A  38      14.886  -1.030  11.397  1.00  0.00           H 
ATOM    598 1HA  GLY A  38      14.057  -1.462  12.896  1.00  0.00           H 
ATOM    599  N   ALA A  39      12.832  -0.183  10.225  1.00  0.00           N 
ATOM    600  CA  ALA A  39      11.649   0.341   9.520  1.00  0.00           C 
ATOM    601  C   ALA A  39      10.990  -0.747   8.646  1.00  0.00           C 
ATOM    602  O   ALA A  39      11.680  -1.587   8.058  1.00  0.00           O 
ATOM    603  CB  ALA A  39      12.030   1.568   8.663  1.00  0.00           C 
ATOM    604  H   ALA A  39      13.721   0.099   9.939  1.00  0.00           H 
ATOM    605  HA  ALA A  39      10.930   0.669  10.281  1.00  0.00           H 
ATOM    606 1HB  ALA A  39      12.477   2.328   9.294  1.00  0.00           H 
ATOM    607 2HB  ALA A  39      11.145   1.978   8.195  1.00  0.00           H 
ATOM    608 3HB  ALA A  39      12.738   1.278   7.894  1.00  0.00           H 
ATOM    609  N   TYR A  40       9.651  -0.736   8.615  1.00  0.00           N 
ATOM    610  CA  TYR A  40       8.839  -1.526   7.659  1.00  0.00           C 
ATOM    611  C   TYR A  40       7.460  -0.857   7.508  1.00  0.00           C 
ATOM    612  O   TYR A  40       7.109   0.021   8.301  1.00  0.00           O 
ATOM    613  CB  TYR A  40       8.708  -3.024   8.103  1.00  0.00           C 
ATOM    614  CG  TYR A  40       7.592  -3.358   9.113  1.00  0.00           C 
ATOM    615  CD1 TYR A  40       7.764  -3.160  10.484  1.00  0.00           C 
ATOM    616  CD2 TYR A  40       6.365  -3.897   8.687  1.00  0.00           C 
ATOM    617  CE1 TYR A  40       6.763  -3.475  11.382  1.00  0.00           C 
ATOM    618  CE2 TYR A  40       5.372  -4.200   9.583  1.00  0.00           C 
ATOM    619  CZ  TYR A  40       5.570  -3.999  10.923  1.00  0.00           C 
ATOM    620  OH  TYR A  40       4.568  -4.332  11.809  1.00  0.00           O 
ATOM    621  H   TYR A  40       9.182  -0.173   9.270  1.00  0.00           H 
ATOM    622  HA  TYR A  40       9.343  -1.485   6.691  1.00  0.00           H 
ATOM    623 2HB  TYR A  40       9.652  -3.336   8.538  1.00  0.00           H 
ATOM    624 1HB  TYR A  40       8.537  -3.629   7.219  1.00  0.00           H 
ATOM    625  HD1 TYR A  40       8.697  -2.748  10.847  1.00  0.00           H 
ATOM    626  HD2 TYR A  40       6.191  -4.064   7.629  1.00  0.00           H 
ATOM    627  HE1 TYR A  40       6.917  -3.311  12.441  1.00  0.00           H 
ATOM    628  HE2 TYR A  40       4.436  -4.607   9.225  1.00  0.00           H 
ATOM    629  HH  TYR A  40       4.164  -5.170  11.535  1.00  0.00           H 
ATOM    630  N   VAL A  41       6.675  -1.257   6.493  1.00  0.00           N 
ATOM    631  CA  VAL A  41       5.313  -0.724   6.293  1.00  0.00           C 
ATOM    632  C   VAL A  41       4.272  -1.847   6.460  1.00  0.00           C 
ATOM    633  O   VAL A  41       4.377  -2.903   5.826  1.00  0.00           O 
ATOM    634  CB  VAL A  41       5.120  -0.056   4.879  1.00  0.00           C 
ATOM    635  CG1 VAL A  41       3.846   0.823   4.856  1.00  0.00           C 
ATOM    636  CG2 VAL A  41       6.357   0.755   4.444  1.00  0.00           C 
ATOM    637  H   VAL A  41       7.014  -1.927   5.867  1.00  0.00           H 
ATOM    638  HA  VAL A  41       5.131   0.038   7.054  1.00  0.00           H 
ATOM    639  HB  VAL A  41       4.980  -0.853   4.149  1.00  0.00           H 
ATOM    640 1HG1 VAL A  41       3.933   1.615   5.590  1.00  0.00           H 
ATOM    641 2HG1 VAL A  41       2.977   0.220   5.090  1.00  0.00           H 
ATOM    642 3HG1 VAL A  41       3.716   1.257   3.870  1.00  0.00           H 
ATOM    643 1HG2 VAL A  41       6.543   1.550   5.155  1.00  0.00           H 
ATOM    644 2HG2 VAL A  41       6.190   1.186   3.464  1.00  0.00           H 
ATOM    645 3HG2 VAL A  41       7.223   0.109   4.403  1.00  0.00           H 
ATOM    646  N   HIS A  42       3.292  -1.607   7.335  1.00  0.00           N 
ATOM    647  CA  HIS A  42       2.101  -2.452   7.494  1.00  0.00           C 
ATOM    648  C   HIS A  42       0.995  -1.928   6.558  1.00  0.00           C 
ATOM    649  O   HIS A  42       0.576  -0.775   6.679  1.00  0.00           O 
ATOM    650  CB  HIS A  42       1.637  -2.417   8.980  1.00  0.00           C 
ATOM    651  CG  HIS A  42       0.253  -2.984   9.237  1.00  0.00           C 
ATOM    652  ND1 HIS A  42      -0.006  -4.326   9.399  1.00  0.00           N 
ATOM    653  CD2 HIS A  42      -0.949  -2.365   9.343  1.00  0.00           C 
ATOM    654  CE1 HIS A  42      -1.297  -4.504   9.582  1.00  0.00           C 
ATOM    655  NE2 HIS A  42      -1.888  -3.333   9.557  1.00  0.00           N 
ATOM    656  H   HIS A  42       3.357  -0.813   7.894  1.00  0.00           H 
ATOM    657  HA  HIS A  42       2.359  -3.477   7.222  1.00  0.00           H 
ATOM    658 2HB  HIS A  42       1.642  -1.390   9.326  1.00  0.00           H 
ATOM    659 1HB  HIS A  42       2.337  -2.985   9.577  1.00  0.00           H 
ATOM    660  HD1 HIS A  42       0.663  -5.041   9.409  1.00  0.00           H 
ATOM    661  HD2 HIS A  42      -1.134  -1.301   9.266  1.00  0.00           H 
ATOM    662  HE1 HIS A  42      -1.786  -5.456   9.732  1.00  0.00           H 
ATOM    663  HE2 HIS A  42      -2.854  -3.204   9.431  1.00  0.00           H 
ATOM    664  N   PHE A  43       0.527  -2.777   5.637  1.00  0.00           N 
ATOM    665  CA  PHE A  43      -0.545  -2.423   4.684  1.00  0.00           C 
ATOM    666  C   PHE A  43      -1.856  -3.149   5.057  1.00  0.00           C 
ATOM    667  O   PHE A  43      -1.820  -4.285   5.548  1.00  0.00           O 
ATOM    668  CB  PHE A  43      -0.139  -2.807   3.240  1.00  0.00           C 
ATOM    669  CG  PHE A  43       1.185  -2.214   2.740  1.00  0.00           C 
ATOM    670  CD1 PHE A  43       1.224  -0.962   2.134  1.00  0.00           C 
ATOM    671  CD2 PHE A  43       2.385  -2.924   2.856  1.00  0.00           C 
ATOM    672  CE1 PHE A  43       2.412  -0.442   1.654  1.00  0.00           C 
ATOM    673  CE2 PHE A  43       3.568  -2.404   2.380  1.00  0.00           C 
ATOM    674  CZ  PHE A  43       3.584  -1.162   1.785  1.00  0.00           C 
ATOM    675  H   PHE A  43       0.906  -3.676   5.583  1.00  0.00           H 
ATOM    676  HA  PHE A  43      -0.707  -1.348   4.725  1.00  0.00           H 
ATOM    677 2HB  PHE A  43      -0.925  -2.484   2.559  1.00  0.00           H 
ATOM    678 1HB  PHE A  43      -0.056  -3.887   3.170  1.00  0.00           H 
ATOM    679  HD1 PHE A  43       0.310  -0.387   2.039  1.00  0.00           H 
ATOM    680  HD2 PHE A  43       2.380  -3.902   3.315  1.00  0.00           H 
ATOM    681  HE1 PHE A  43       2.428   0.532   1.185  1.00  0.00           H 
ATOM    682  HE2 PHE A  43       4.484  -2.969   2.482  1.00  0.00           H 
ATOM    683  HZ  PHE A  43       4.514  -0.756   1.408  1.00  0.00           H 
ATOM    684  N   ASP A  44      -2.997  -2.470   4.833  1.00  0.00           N 
ATOM    685  CA  ASP A  44      -4.359  -3.047   4.955  1.00  0.00           C 
ATOM    686  C   ASP A  44      -5.135  -2.746   3.672  1.00  0.00           C 
ATOM    687  O   ASP A  44      -5.175  -1.593   3.244  1.00  0.00           O 
ATOM    688  CB  ASP A  44      -5.142  -2.432   6.150  1.00  0.00           C 
ATOM    689  CG  ASP A  44      -4.435  -2.600   7.496  1.00  0.00           C 
ATOM    690  OD1 ASP A  44      -4.476  -3.711   8.067  1.00  0.00           O 
ATOM    691  OD2 ASP A  44      -3.835  -1.624   7.994  1.00  0.00           O 
ATOM    692  H   ASP A  44      -2.927  -1.527   4.586  1.00  0.00           H 
ATOM    693  HA  ASP A  44      -4.283  -4.124   5.087  1.00  0.00           H 
ATOM    694 2HB  ASP A  44      -6.122  -2.905   6.218  1.00  0.00           H 
ATOM    695 1HB  ASP A  44      -5.294  -1.372   5.965  1.00  0.00           H 
ATOM    696  N   MET A  45      -5.741  -3.765   3.047  1.00  0.00           N 
ATOM    697  CA  MET A  45      -6.638  -3.568   1.890  1.00  0.00           C 
ATOM    698  C   MET A  45      -8.014  -4.187   2.170  1.00  0.00           C 
ATOM    699  O   MET A  45      -8.100  -5.355   2.536  1.00  0.00           O 
ATOM    700  CB  MET A  45      -6.005  -4.167   0.603  1.00  0.00           C 
ATOM    701  CG  MET A  45      -4.753  -3.414   0.113  1.00  0.00           C 
ATOM    702  SD  MET A  45      -4.014  -4.131  -1.369  1.00  0.00           S 
ATOM    703  CE  MET A  45      -5.384  -4.102  -2.520  1.00  0.00           C 
ATOM    704  H   MET A  45      -5.569  -4.680   3.348  1.00  0.00           H 
ATOM    705  HA  MET A  45      -6.772  -2.500   1.743  1.00  0.00           H 
ATOM    706 2HB  MET A  45      -6.742  -4.148  -0.195  1.00  0.00           H 
ATOM    707 1HB  MET A  45      -5.730  -5.198   0.790  1.00  0.00           H 
ATOM    708 2HG  MET A  45      -4.008  -3.421   0.899  1.00  0.00           H 
ATOM    709 1HG  MET A  45      -5.023  -2.389  -0.106  1.00  0.00           H 
ATOM    710 1HE  MET A  45      -5.707  -3.084  -2.675  1.00  0.00           H 
ATOM    711 2HE  MET A  45      -6.202  -4.688  -2.125  1.00  0.00           H 
ATOM    712 3HE  MET A  45      -5.065  -4.525  -3.464  1.00  0.00           H 
ATOM    713  N   ASP A  46      -9.090  -3.404   1.953  1.00  0.00           N 
ATOM    714  CA  ASP A  46     -10.474  -3.828   2.282  1.00  0.00           C 
ATOM    715  C   ASP A  46     -11.513  -3.099   1.399  1.00  0.00           C 
ATOM    716  O   ASP A  46     -11.311  -1.950   1.014  1.00  0.00           O 
ATOM    717  CB  ASP A  46     -10.780  -3.593   3.790  1.00  0.00           C 
ATOM    718  CG  ASP A  46     -10.745  -2.111   4.211  1.00  0.00           C 
ATOM    719  OD1 ASP A  46     -11.805  -1.546   4.557  1.00  0.00           O 
ATOM    720  OD2 ASP A  46      -9.656  -1.509   4.211  1.00  0.00           O 
ATOM    721  H   ASP A  46      -8.952  -2.513   1.571  1.00  0.00           H 
ATOM    722  HA  ASP A  46     -10.546  -4.898   2.083  1.00  0.00           H 
ATOM    723 2HB  ASP A  46     -10.047  -4.131   4.380  1.00  0.00           H 
ATOM    724 1HB  ASP A  46     -11.762  -4.005   4.020  1.00  0.00           H 
ATOM    725  N   GLY A  47     -12.619  -3.795   1.091  1.00  0.00           N 
ATOM    726  CA  GLY A  47     -13.722  -3.249   0.274  1.00  0.00           C 
ATOM    727  C   GLY A  47     -14.694  -4.355  -0.109  1.00  0.00           C 
ATOM    728  O   GLY A  47     -14.804  -5.329   0.638  1.00  0.00           O 
ATOM    729  H   GLY A  47     -12.691  -4.719   1.419  1.00  0.00           H 
ATOM    730 2HA  GLY A  47     -13.317  -2.800  -0.624  1.00  0.00           H 
ATOM    731 1HA  GLY A  47     -14.251  -2.496   0.842  1.00  0.00           H 
ATOM    732  N   GLU A  48     -15.392  -4.242  -1.265  1.00  0.00           N 
ATOM    733  CA  GLU A  48     -16.205  -5.349  -1.807  1.00  0.00           C 
ATOM    734  C   GLU A  48     -16.282  -5.277  -3.350  1.00  0.00           C 
ATOM    735  O   GLU A  48     -16.906  -4.393  -3.934  1.00  0.00           O 
ATOM    736  CB  GLU A  48     -17.629  -5.382  -1.180  1.00  0.00           C 
ATOM    737  CG  GLU A  48     -18.451  -4.078  -1.306  1.00  0.00           C 
ATOM    738  CD  GLU A  48     -19.870  -4.198  -0.729  1.00  0.00           C 
ATOM    739  OE1 GLU A  48     -20.103  -3.774   0.426  1.00  0.00           O 
ATOM    740  OE2 GLU A  48     -20.767  -4.707  -1.437  1.00  0.00           O 
ATOM    741  H   GLU A  48     -15.343  -3.411  -1.783  1.00  0.00           H 
ATOM    742  HA  GLU A  48     -15.700  -6.277  -1.540  1.00  0.00           H 
ATOM    743 2HB  GLU A  48     -17.534  -5.625  -0.123  1.00  0.00           H 
ATOM    744 1HB  GLU A  48     -18.179  -6.183  -1.660  1.00  0.00           H 
ATOM    745 2HG  GLU A  48     -18.525  -3.815  -2.357  1.00  0.00           H 
ATOM    746 1HG  GLU A  48     -17.923  -3.282  -0.789  1.00  0.00           H 
ATOM    747  N   ILE A  49     -15.591  -6.224  -3.993  1.00  0.00           N 
ATOM    748  CA  ILE A  49     -15.570  -6.320  -5.474  1.00  0.00           C 
ATOM    749  C   ILE A  49     -16.518  -7.408  -5.978  1.00  0.00           C 
ATOM    750  O   ILE A  49     -16.443  -8.551  -5.529  1.00  0.00           O 
ATOM    751  CB  ILE A  49     -14.120  -6.577  -6.000  1.00  0.00           C 
ATOM    752  CG1 ILE A  49     -13.161  -5.456  -5.479  1.00  0.00           C 
ATOM    753  CG2 ILE A  49     -14.096  -6.661  -7.553  1.00  0.00           C 
ATOM    754  CD1 ILE A  49     -11.703  -5.680  -5.795  1.00  0.00           C 
ATOM    755  H   ILE A  49     -14.919  -6.673  -3.456  1.00  0.00           H 
ATOM    756  HA  ILE A  49     -15.899  -5.358  -5.875  1.00  0.00           H 
ATOM    757  HB  ILE A  49     -13.791  -7.539  -5.605  1.00  0.00           H 
ATOM    758 2HG1 ILE A  49     -13.252  -5.384  -4.399  1.00  0.00           H 
ATOM    759 1HG1 ILE A  49     -13.444  -4.507  -5.914  1.00  0.00           H 
ATOM    760 1HG2 ILE A  49     -14.443  -5.727  -7.981  1.00  0.00           H 
ATOM    761 2HG2 ILE A  49     -14.741  -7.463  -7.890  1.00  0.00           H 
ATOM    762 3HG2 ILE A  49     -13.087  -6.857  -7.893  1.00  0.00           H 
ATOM    763 1HD1 ILE A  49     -11.357  -6.578  -5.305  1.00  0.00           H 
ATOM    764 2HD1 ILE A  49     -11.132  -4.838  -5.439  1.00  0.00           H 
ATOM    765 3HD1 ILE A  49     -11.570  -5.777  -6.862  1.00  0.00           H 
ATOM    766  N   ASP A  50     -17.397  -7.008  -6.934  1.00  0.00           N 
ATOM    767  CA  ASP A  50     -18.531  -7.814  -7.434  1.00  0.00           C 
ATOM    768  C   ASP A  50     -19.528  -8.069  -6.270  1.00  0.00           C 
ATOM    769  O   ASP A  50     -20.337  -8.997  -6.290  1.00  0.00           O 
ATOM    770  CB  ASP A  50     -18.011  -9.132  -8.115  1.00  0.00           C 
ATOM    771  CG  ASP A  50     -19.090  -9.936  -8.867  1.00  0.00           C 
ATOM    772  OD1 ASP A  50     -19.443 -11.057  -8.433  1.00  0.00           O 
ATOM    773  OD2 ASP A  50     -19.597  -9.443  -9.897  1.00  0.00           O 
ATOM    774  H   ASP A  50     -17.271  -6.119  -7.317  1.00  0.00           H 
ATOM    775  HA  ASP A  50     -19.041  -7.211  -8.175  1.00  0.00           H 
ATOM    776 2HB  ASP A  50     -17.568  -9.762  -7.349  1.00  0.00           H 
ATOM    777 1HB  ASP A  50     -17.234  -8.873  -8.826  1.00  0.00           H 
ATOM    778  N   GLY A  51     -19.455  -7.185  -5.247  1.00  0.00           N 
ATOM    779  CA  GLY A  51     -20.244  -7.313  -4.024  1.00  0.00           C 
ATOM    780  C   GLY A  51     -19.589  -8.192  -2.966  1.00  0.00           C 
ATOM    781  O   GLY A  51     -20.138  -8.337  -1.869  1.00  0.00           O 
ATOM    782  H   GLY A  51     -18.830  -6.434  -5.322  1.00  0.00           H 
ATOM    783 2HA  GLY A  51     -21.219  -7.726  -4.262  1.00  0.00           H 
ATOM    784 1HA  GLY A  51     -20.384  -6.328  -3.605  1.00  0.00           H 
ATOM    785  N   LYS A  52     -18.422  -8.797  -3.291  1.00  0.00           N 
ATOM    786  CA  LYS A  52     -17.698  -9.716  -2.394  1.00  0.00           C 
ATOM    787  C   LYS A  52     -16.756  -8.966  -1.440  1.00  0.00           C 
ATOM    788  O   LYS A  52     -15.719  -8.451  -1.887  1.00  0.00           O 
ATOM    789  CB  LYS A  52     -16.897 -10.749  -3.231  1.00  0.00           C 
ATOM    790  CG  LYS A  52     -17.778 -11.707  -4.067  1.00  0.00           C 
ATOM    791  CD  LYS A  52     -18.702 -12.570  -3.172  1.00  0.00           C 
ATOM    792  CE  LYS A  52     -19.616 -13.512  -3.970  1.00  0.00           C 
ATOM    793  NZ  LYS A  52     -20.494 -14.303  -3.071  1.00  0.00           N 
ATOM    794  H   LYS A  52     -18.037  -8.656  -4.176  1.00  0.00           H 
ATOM    795  HA  LYS A  52     -18.424 -10.243  -1.814  1.00  0.00           H 
ATOM    796 2HB  LYS A  52     -16.280 -11.346  -2.561  1.00  0.00           H 
ATOM    797 1HB  LYS A  52     -16.239 -10.205  -3.907  1.00  0.00           H 
ATOM    798 2HG  LYS A  52     -17.133 -12.362  -4.643  1.00  0.00           H 
ATOM    799 1HG  LYS A  52     -18.391 -11.121  -4.745  1.00  0.00           H 
ATOM    800 2HD  LYS A  52     -19.322 -11.914  -2.569  1.00  0.00           H 
ATOM    801 1HD  LYS A  52     -18.085 -13.170  -2.511  1.00  0.00           H 
ATOM    802 2HE  LYS A  52     -19.008 -14.192  -4.553  1.00  0.00           H 
ATOM    803 1HE  LYS A  52     -20.240 -12.926  -4.635  1.00  0.00           H 
ATOM    804 1HZ  LYS A  52     -19.920 -14.924  -2.473  1.00  0.00           H 
ATOM    805 2HZ  LYS A  52     -21.150 -14.884  -3.627  1.00  0.00           H 
ATOM    806 3HZ  LYS A  52     -21.046 -13.663  -2.461  1.00  0.00           H 
ATOM    807  N   PRO A  53     -17.078  -8.923  -0.103  1.00  0.00           N 
ATOM    808  CA  PRO A  53     -16.271  -8.193   0.891  1.00  0.00           C 
ATOM    809  C   PRO A  53     -14.951  -8.920   1.207  1.00  0.00           C 
ATOM    810  O   PRO A  53     -14.908 -10.159   1.282  1.00  0.00           O 
ATOM    811  CB  PRO A  53     -17.206  -8.117   2.123  1.00  0.00           C 
ATOM    812  CG  PRO A  53     -18.041  -9.359   2.027  1.00  0.00           C 
ATOM    813  CD  PRO A  53     -18.242  -9.606   0.542  1.00  0.00           C 
ATOM    814  HA  PRO A  53     -16.048  -7.186   0.541  1.00  0.00           H 
ATOM    815 2HB  PRO A  53     -17.820  -7.221   2.063  1.00  0.00           H 
ATOM    816 1HB  PRO A  53     -16.625  -8.090   3.041  1.00  0.00           H 
ATOM    817 2HG  PRO A  53     -18.993  -9.209   2.524  1.00  0.00           H 
ATOM    818 1HG  PRO A  53     -17.514 -10.194   2.483  1.00  0.00           H 
ATOM    819 2HD  PRO A  53     -19.175  -9.168   0.201  1.00  0.00           H 
ATOM    820 1HD  PRO A  53     -18.233 -10.669   0.326  1.00  0.00           H 
ATOM    821  N   PHE A  54     -13.879  -8.138   1.392  1.00  0.00           N 
ATOM    822  CA  PHE A  54     -12.543  -8.666   1.695  1.00  0.00           C 
ATOM    823  C   PHE A  54     -11.845  -7.771   2.719  1.00  0.00           C 
ATOM    824  O   PHE A  54     -12.084  -6.561   2.760  1.00  0.00           O 
ATOM    825  CB  PHE A  54     -11.685  -8.813   0.400  1.00  0.00           C 
ATOM    826  CG  PHE A  54     -11.315  -7.508  -0.332  1.00  0.00           C 
ATOM    827  CD1 PHE A  54     -12.199  -6.909  -1.232  1.00  0.00           C 
ATOM    828  CD2 PHE A  54     -10.070  -6.901  -0.136  1.00  0.00           C 
ATOM    829  CE1 PHE A  54     -11.851  -5.754  -1.906  1.00  0.00           C 
ATOM    830  CE2 PHE A  54      -9.727  -5.746  -0.808  1.00  0.00           C 
ATOM    831  CZ  PHE A  54     -10.617  -5.173  -1.692  1.00  0.00           C 
ATOM    832  H   PHE A  54     -13.993  -7.167   1.344  1.00  0.00           H 
ATOM    833  HA  PHE A  54     -12.667  -9.654   2.141  1.00  0.00           H 
ATOM    834 2HB  PHE A  54     -12.227  -9.442  -0.299  1.00  0.00           H 
ATOM    835 1HB  PHE A  54     -10.761  -9.322   0.653  1.00  0.00           H 
ATOM    836  HD1 PHE A  54     -13.169  -7.361  -1.401  1.00  0.00           H 
ATOM    837  HD2 PHE A  54      -9.365  -7.347   0.558  1.00  0.00           H 
ATOM    838  HE1 PHE A  54     -12.548  -5.305  -2.600  1.00  0.00           H 
ATOM    839  HE2 PHE A  54      -8.760  -5.289  -0.641  1.00  0.00           H 
ATOM    840  HZ  PHE A  54     -10.346  -4.270  -2.221  1.00  0.00           H 
ATOM    841  N   SER A  55     -11.010  -8.393   3.554  1.00  0.00           N 
ATOM    842  CA  SER A  55     -10.126  -7.707   4.494  1.00  0.00           C 
ATOM    843  C   SER A  55      -8.772  -8.430   4.472  1.00  0.00           C 
ATOM    844  O   SER A  55      -8.675  -9.614   4.824  1.00  0.00           O 
ATOM    845  CB  SER A  55     -10.748  -7.685   5.911  1.00  0.00           C 
ATOM    846  OG  SER A  55     -11.035  -8.997   6.384  1.00  0.00           O 
ATOM    847  H   SER A  55     -11.003  -9.371   3.558  1.00  0.00           H 
ATOM    848  HA  SER A  55      -9.985  -6.680   4.149  1.00  0.00           H 
ATOM    849 2HB  SER A  55     -11.671  -7.120   5.888  1.00  0.00           H 
ATOM    850 1HB  SER A  55     -10.062  -7.212   6.596  1.00  0.00           H 
ATOM    851  HG  SER A  55     -10.208  -9.424   6.634  1.00  0.00           H 
ATOM    852  N   ASP A  56      -7.743  -7.706   4.040  1.00  0.00           N 
ATOM    853  CA  ASP A  56      -6.400  -8.241   3.772  1.00  0.00           C 
ATOM    854  C   ASP A  56      -5.363  -7.364   4.484  1.00  0.00           C 
ATOM    855  O   ASP A  56      -5.573  -6.160   4.649  1.00  0.00           O 
ATOM    856  CB  ASP A  56      -6.149  -8.260   2.235  1.00  0.00           C 
ATOM    857  CG  ASP A  56      -4.816  -8.921   1.840  1.00  0.00           C 
ATOM    858  OD1 ASP A  56      -3.799  -8.216   1.677  1.00  0.00           O 
ATOM    859  OD2 ASP A  56      -4.781 -10.163   1.716  1.00  0.00           O 
ATOM    860  H   ASP A  56      -7.886  -6.752   3.904  1.00  0.00           H 
ATOM    861  HA  ASP A  56      -6.340  -9.256   4.163  1.00  0.00           H 
ATOM    862 2HB  ASP A  56      -6.161  -7.241   1.862  1.00  0.00           H 
ATOM    863 1HB  ASP A  56      -6.960  -8.804   1.756  1.00  0.00           H 
ATOM    864  N   SER A  57      -4.265  -7.976   4.937  1.00  0.00           N 
ATOM    865  CA  SER A  57      -3.132  -7.254   5.530  1.00  0.00           C 
ATOM    866  C   SER A  57      -1.823  -7.933   5.100  1.00  0.00           C 
ATOM    867  O   SER A  57      -1.684  -9.155   5.218  1.00  0.00           O 
ATOM    868  CB  SER A  57      -3.252  -7.219   7.075  1.00  0.00           C 
ATOM    869  OG  SER A  57      -4.499  -6.677   7.494  1.00  0.00           O 
ATOM    870  H   SER A  57      -4.217  -8.952   4.883  1.00  0.00           H 
ATOM    871  HA  SER A  57      -3.137  -6.234   5.151  1.00  0.00           H 
ATOM    872 2HB  SER A  57      -2.456  -6.607   7.486  1.00  0.00           H 
ATOM    873 1HB  SER A  57      -3.175  -8.223   7.469  1.00  0.00           H 
ATOM    874  HG  SER A  57      -4.576  -5.766   7.178  1.00  0.00           H 
ATOM    875  N   PHE A  58      -0.878  -7.134   4.591  1.00  0.00           N 
ATOM    876  CA  PHE A  58       0.451  -7.607   4.164  1.00  0.00           C 
ATOM    877  C   PHE A  58       1.506  -6.595   4.608  1.00  0.00           C 
ATOM    878  O   PHE A  58       1.246  -5.398   4.618  1.00  0.00           O 
ATOM    879  CB  PHE A  58       0.497  -7.850   2.628  1.00  0.00           C 
ATOM    880  CG  PHE A  58       0.152  -6.642   1.736  1.00  0.00           C 
ATOM    881  CD1 PHE A  58       1.153  -5.895   1.109  1.00  0.00           C 
ATOM    882  CD2 PHE A  58      -1.174  -6.277   1.507  1.00  0.00           C 
ATOM    883  CE1 PHE A  58       0.837  -4.837   0.281  1.00  0.00           C 
ATOM    884  CE2 PHE A  58      -1.488  -5.215   0.686  1.00  0.00           C 
ATOM    885  CZ  PHE A  58      -0.484  -4.495   0.071  1.00  0.00           C 
ATOM    886  H   PHE A  58      -1.077  -6.175   4.508  1.00  0.00           H 
ATOM    887  HA  PHE A  58       0.656  -8.551   4.673  1.00  0.00           H 
ATOM    888 2HB  PHE A  58      -0.201  -8.649   2.387  1.00  0.00           H 
ATOM    889 1HB  PHE A  58       1.492  -8.192   2.359  1.00  0.00           H 
ATOM    890  HD1 PHE A  58       2.193  -6.157   1.270  1.00  0.00           H 
ATOM    891  HD2 PHE A  58      -1.968  -6.837   1.988  1.00  0.00           H 
ATOM    892  HE1 PHE A  58       1.627  -4.266  -0.188  1.00  0.00           H 
ATOM    893  HE2 PHE A  58      -2.522  -4.948   0.521  1.00  0.00           H 
ATOM    894  HZ  PHE A  58      -0.732  -3.665  -0.577  1.00  0.00           H 
ATOM    895  N   GLU A  59       2.684  -7.086   5.010  1.00  0.00           N 
ATOM    896  CA  GLU A  59       3.763  -6.250   5.570  1.00  0.00           C 
ATOM    897  C   GLU A  59       5.064  -6.484   4.803  1.00  0.00           C 
ATOM    898  O   GLU A  59       5.443  -7.630   4.539  1.00  0.00           O 
ATOM    899  CB  GLU A  59       3.950  -6.556   7.078  1.00  0.00           C 
ATOM    900  CG  GLU A  59       2.683  -6.318   7.924  1.00  0.00           C 
ATOM    901  CD  GLU A  59       2.854  -6.655   9.415  1.00  0.00           C 
ATOM    902  OE1 GLU A  59       3.364  -7.745   9.738  1.00  0.00           O 
ATOM    903  OE2 GLU A  59       2.457  -5.842  10.271  1.00  0.00           O 
ATOM    904  H   GLU A  59       2.842  -8.049   4.916  1.00  0.00           H 
ATOM    905  HA  GLU A  59       3.479  -5.203   5.461  1.00  0.00           H 
ATOM    906 2HB  GLU A  59       4.743  -5.927   7.472  1.00  0.00           H 
ATOM    907 1HB  GLU A  59       4.245  -7.597   7.196  1.00  0.00           H 
ATOM    908 2HG  GLU A  59       1.889  -6.925   7.523  1.00  0.00           H 
ATOM    909 1HG  GLU A  59       2.397  -5.274   7.823  1.00  0.00           H 
ATOM    910  N   LEU A  60       5.734  -5.386   4.449  1.00  0.00           N 
ATOM    911  CA  LEU A  60       6.993  -5.396   3.690  1.00  0.00           C 
ATOM    912  C   LEU A  60       8.065  -4.632   4.479  1.00  0.00           C 
ATOM    913  O   LEU A  60       7.801  -3.504   4.905  1.00  0.00           O 
ATOM    914  CB  LEU A  60       6.767  -4.752   2.297  1.00  0.00           C 
ATOM    915  CG  LEU A  60       5.928  -5.606   1.289  1.00  0.00           C 
ATOM    916  CD1 LEU A  60       5.480  -4.774   0.071  1.00  0.00           C 
ATOM    917  CD2 LEU A  60       6.721  -6.865   0.849  1.00  0.00           C 
ATOM    918  H   LEU A  60       5.371  -4.515   4.727  1.00  0.00           H 
ATOM    919  HA  LEU A  60       7.314  -6.425   3.555  1.00  0.00           H 
ATOM    920 2HB  LEU A  60       7.736  -4.555   1.843  1.00  0.00           H 
ATOM    921 1HB  LEU A  60       6.266  -3.799   2.442  1.00  0.00           H 
ATOM    922  HG  LEU A  60       5.028  -5.947   1.790  1.00  0.00           H 
ATOM    923 1HD1 LEU A  60       6.345  -4.370  -0.440  1.00  0.00           H 
ATOM    924 2HD1 LEU A  60       4.846  -3.958   0.400  1.00  0.00           H 
ATOM    925 3HD1 LEU A  60       4.919  -5.400  -0.612  1.00  0.00           H 
ATOM    926 1HD2 LEU A  60       6.968  -7.466   1.715  1.00  0.00           H 
ATOM    927 2HD2 LEU A  60       7.633  -6.572   0.344  1.00  0.00           H 
ATOM    928 3HD2 LEU A  60       6.114  -7.456   0.174  1.00  0.00           H 
ATOM    929  N   PRO A  61       9.283  -5.234   4.700  1.00  0.00           N 
ATOM    930  CA  PRO A  61      10.419  -4.533   5.347  1.00  0.00           C 
ATOM    931  C   PRO A  61      10.906  -3.349   4.498  1.00  0.00           C 
ATOM    932  O   PRO A  61      10.579  -3.277   3.318  1.00  0.00           O 
ATOM    933  CB  PRO A  61      11.498  -5.639   5.481  1.00  0.00           C 
ATOM    934  CG  PRO A  61      11.162  -6.628   4.410  1.00  0.00           C 
ATOM    935  CD  PRO A  61       9.650  -6.630   4.333  1.00  0.00           C 
ATOM    936  HA  PRO A  61      10.145  -4.169   6.326  1.00  0.00           H 
ATOM    937 2HB  PRO A  61      11.429  -6.090   6.466  1.00  0.00           H 
ATOM    938 1HB  PRO A  61      12.493  -5.228   5.348  1.00  0.00           H 
ATOM    939 2HG  PRO A  61      11.533  -7.611   4.678  1.00  0.00           H 
ATOM    940 1HG  PRO A  61      11.594  -6.314   3.460  1.00  0.00           H 
ATOM    941 2HD  PRO A  61       9.229  -7.336   5.042  1.00  0.00           H 
ATOM    942 1HD  PRO A  61       9.321  -6.870   3.327  1.00  0.00           H 
ATOM    943  N   ARG A  62      11.653  -2.422   5.123  1.00  0.00           N 
ATOM    944  CA  ARG A  62      12.271  -1.254   4.439  1.00  0.00           C 
ATOM    945  C   ARG A  62      12.963  -1.628   3.088  1.00  0.00           C 
ATOM    946  O   ARG A  62      12.952  -0.840   2.133  1.00  0.00           O 
ATOM    947  CB  ARG A  62      13.292  -0.566   5.391  1.00  0.00           C 
ATOM    948  CG  ARG A  62      14.632  -1.326   5.562  1.00  0.00           C 
ATOM    949  CD  ARG A  62      15.616  -0.656   6.537  1.00  0.00           C 
ATOM    950  NE  ARG A  62      16.993  -1.161   6.352  1.00  0.00           N 
ATOM    951  CZ  ARG A  62      17.438  -2.395   6.676  1.00  0.00           C 
ATOM    952  NH1 ARG A  62      16.658  -3.281   7.289  1.00  0.00           N 
ATOM    953  NH2 ARG A  62      18.687  -2.727   6.402  1.00  0.00           N 
ATOM    954  H   ARG A  62      11.711  -2.470   6.099  1.00  0.00           H 
ATOM    955  HA  ARG A  62      11.467  -0.556   4.227  1.00  0.00           H 
ATOM    956 2HB  ARG A  62      12.835  -0.466   6.370  1.00  0.00           H 
ATOM    957 1HB  ARG A  62      13.507   0.428   5.015  1.00  0.00           H 
ATOM    958 2HG  ARG A  62      15.107  -1.402   4.588  1.00  0.00           H 
ATOM    959 1HG  ARG A  62      14.420  -2.327   5.924  1.00  0.00           H 
ATOM    960 2HD  ARG A  62      15.301  -0.847   7.558  1.00  0.00           H 
ATOM    961 1HD  ARG A  62      15.617   0.414   6.361  1.00  0.00           H 
ATOM    962  HE  ARG A  62      17.628  -0.538   5.934  1.00  0.00           H 
ATOM    963 1HH1 ARG A  62      15.710  -3.048   7.528  1.00  0.00           H 
ATOM    964 2HH1 ARG A  62      17.013  -4.192   7.519  1.00  0.00           H 
ATOM    965 1HH2 ARG A  62      19.298  -2.070   5.954  1.00  0.00           H 
ATOM    966 2HH2 ARG A  62      19.029  -3.640   6.645  1.00  0.00           H 
ATOM    967  N   ASP A  63      13.509  -2.863   3.034  1.00  0.00           N 
ATOM    968  CA  ASP A  63      14.270  -3.396   1.889  1.00  0.00           C 
ATOM    969  C   ASP A  63      13.370  -3.680   0.662  1.00  0.00           C 
ATOM    970  O   ASP A  63      13.822  -3.557  -0.479  1.00  0.00           O 
ATOM    971  CB  ASP A  63      15.014  -4.687   2.337  1.00  0.00           C 
ATOM    972  CG  ASP A  63      15.954  -5.276   1.264  1.00  0.00           C 
ATOM    973  OD1 ASP A  63      17.051  -4.718   1.056  1.00  0.00           O 
ATOM    974  OD2 ASP A  63      15.602  -6.289   0.624  1.00  0.00           O 
ATOM    975  H   ASP A  63      13.394  -3.443   3.813  1.00  0.00           H 
ATOM    976  HA  ASP A  63      15.009  -2.648   1.614  1.00  0.00           H 
ATOM    977 2HB  ASP A  63      14.279  -5.438   2.613  1.00  0.00           H 
ATOM    978 1HB  ASP A  63      15.608  -4.456   3.214  1.00  0.00           H 
ATOM    979  N   THR A  64      12.090  -4.015   0.902  1.00  0.00           N 
ATOM    980  CA  THR A  64      11.126  -4.404  -0.155  1.00  0.00           C 
ATOM    981  C   THR A  64       9.813  -3.608  -0.002  1.00  0.00           C 
ATOM    982  O   THR A  64       8.790  -3.966  -0.596  1.00  0.00           O 
ATOM    983  CB  THR A  64      10.831  -5.948  -0.127  1.00  0.00           C 
ATOM    984  OG1 THR A  64      10.411  -6.339   1.185  1.00  0.00           O 
ATOM    985  CG2 THR A  64      12.059  -6.778  -0.549  1.00  0.00           C 
ATOM    986  H   THR A  64      11.743  -3.920   1.810  1.00  0.00           H 
ATOM    987  HA  THR A  64      11.550  -4.152  -1.125  1.00  0.00           H 
ATOM    988  HB  THR A  64      10.022  -6.158  -0.820  1.00  0.00           H 
ATOM    989  HG1 THR A  64      10.391  -7.298   1.240  1.00  0.00           H 
ATOM    990 1HG2 THR A  64      11.811  -7.830  -0.527  1.00  0.00           H 
ATOM    991 2HG2 THR A  64      12.881  -6.591   0.134  1.00  0.00           H 
ATOM    992 3HG2 THR A  64      12.360  -6.504  -1.552  1.00  0.00           H 
ATOM    993  N   ALA A  65       9.865  -2.507   0.782  1.00  0.00           N 
ATOM    994  CA  ALA A  65       8.704  -1.623   1.020  1.00  0.00           C 
ATOM    995  C   ALA A  65       8.240  -0.960  -0.283  1.00  0.00           C 
ATOM    996  O   ALA A  65       7.048  -0.895  -0.557  1.00  0.00           O 
ATOM    997  CB  ALA A  65       9.049  -0.561   2.074  1.00  0.00           C 
ATOM    998  H   ALA A  65      10.710  -2.304   1.237  1.00  0.00           H 
ATOM    999  HA  ALA A  65       7.897  -2.234   1.412  1.00  0.00           H 
ATOM   1000 1HB  ALA A  65       8.179   0.051   2.277  1.00  0.00           H 
ATOM   1001 2HB  ALA A  65       9.852   0.069   1.716  1.00  0.00           H 
ATOM   1002 3HB  ALA A  65       9.363  -1.049   2.989  1.00  0.00           H 
ATOM   1003  N   PHE A  66       9.221  -0.494  -1.073  1.00  0.00           N 
ATOM   1004  CA  PHE A  66       9.001   0.180  -2.378  1.00  0.00           C 
ATOM   1005  C   PHE A  66       8.574  -0.807  -3.492  1.00  0.00           C 
ATOM   1006  O   PHE A  66       8.283  -0.394  -4.616  1.00  0.00           O 
ATOM   1007  CB  PHE A  66      10.281   0.951  -2.784  1.00  0.00           C 
ATOM   1008  CG  PHE A  66      10.816   1.835  -1.659  1.00  0.00           C 
ATOM   1009  CD1 PHE A  66      11.880   1.414  -0.857  1.00  0.00           C 
ATOM   1010  CD2 PHE A  66      10.223   3.062  -1.377  1.00  0.00           C 
ATOM   1011  CE1 PHE A  66      12.335   2.195   0.184  1.00  0.00           C 
ATOM   1012  CE2 PHE A  66      10.681   3.840  -0.343  1.00  0.00           C 
ATOM   1013  CZ  PHE A  66      11.738   3.406   0.441  1.00  0.00           C 
ATOM   1014  H   PHE A  66      10.131  -0.547  -0.723  1.00  0.00           H 
ATOM   1015  HA  PHE A  66       8.196   0.899  -2.243  1.00  0.00           H 
ATOM   1016 2HB  PHE A  66      10.066   1.586  -3.641  1.00  0.00           H 
ATOM   1017 1HB  PHE A  66      11.057   0.243  -3.069  1.00  0.00           H 
ATOM   1018  HD1 PHE A  66      12.355   0.460  -1.062  1.00  0.00           H 
ATOM   1019  HD2 PHE A  66       9.398   3.409  -1.985  1.00  0.00           H 
ATOM   1020  HE1 PHE A  66      13.161   1.857   0.797  1.00  0.00           H 
ATOM   1021  HE2 PHE A  66      10.216   4.797  -0.137  1.00  0.00           H 
ATOM   1022  HZ  PHE A  66      12.092   4.022   1.258  1.00  0.00           H 
ATOM   1023  N   ASN A  67       8.513  -2.106  -3.156  1.00  0.00           N 
ATOM   1024  CA  ASN A  67       7.995  -3.162  -4.053  1.00  0.00           C 
ATOM   1025  C   ASN A  67       6.468  -3.320  -3.874  1.00  0.00           C 
ATOM   1026  O   ASN A  67       5.854  -4.195  -4.503  1.00  0.00           O 
ATOM   1027  CB  ASN A  67       8.720  -4.508  -3.756  1.00  0.00           C 
ATOM   1028  CG  ASN A  67      10.211  -4.571  -4.147  1.00  0.00           C 
ATOM   1029  OD1 ASN A  67      10.731  -5.648  -4.436  1.00  0.00           O 
ATOM   1030  ND2 ASN A  67      10.922  -3.449  -4.168  1.00  0.00           N 
ATOM   1031  H   ASN A  67       8.812  -2.367  -2.264  1.00  0.00           H 
ATOM   1032  HA  ASN A  67       8.190  -2.868  -5.078  1.00  0.00           H 
ATOM   1033 2HB  ASN A  67       8.202  -5.306  -4.281  1.00  0.00           H 
ATOM   1034 1HB  ASN A  67       8.657  -4.708  -2.694  1.00  0.00           H 
ATOM   1035 2HD2 ASN A  67      10.482  -2.607  -3.940  1.00  0.00           H 
ATOM   1036 1HD2 ASN A  67      11.872  -3.511  -4.405  1.00  0.00           H 
ATOM   1037  N   PHE A  68       5.888  -2.465  -2.994  1.00  0.00           N 
ATOM   1038  CA  PHE A  68       4.460  -2.478  -2.648  1.00  0.00           C 
ATOM   1039  C   PHE A  68       3.555  -2.379  -3.883  1.00  0.00           C 
ATOM   1040  O   PHE A  68       2.650  -3.178  -4.018  1.00  0.00           O 
ATOM   1041  CB  PHE A  68       4.117  -1.352  -1.629  1.00  0.00           C 
ATOM   1042  CG  PHE A  68       4.151   0.080  -2.197  1.00  0.00           C 
ATOM   1043  CD1 PHE A  68       5.359   0.693  -2.541  1.00  0.00           C 
ATOM   1044  CD2 PHE A  68       2.977   0.791  -2.415  1.00  0.00           C 
ATOM   1045  CE1 PHE A  68       5.393   1.956  -3.083  1.00  0.00           C 
ATOM   1046  CE2 PHE A  68       3.011   2.057  -2.954  1.00  0.00           C 
ATOM   1047  CZ  PHE A  68       4.217   2.642  -3.290  1.00  0.00           C 
ATOM   1048  H   PHE A  68       6.476  -1.848  -2.515  1.00  0.00           H 
ATOM   1049  HA  PHE A  68       4.273  -3.435  -2.162  1.00  0.00           H 
ATOM   1050 2HB  PHE A  68       4.820  -1.402  -0.807  1.00  0.00           H 
ATOM   1051 1HB  PHE A  68       3.124  -1.537  -1.229  1.00  0.00           H 
ATOM   1052  HD1 PHE A  68       6.281   0.154  -2.377  1.00  0.00           H 
ATOM   1053  HD2 PHE A  68       2.023   0.342  -2.156  1.00  0.00           H 
ATOM   1054  HE1 PHE A  68       6.341   2.412  -3.342  1.00  0.00           H 
ATOM   1055  HE2 PHE A  68       2.090   2.593  -3.116  1.00  0.00           H 
ATOM   1056  HZ  PHE A  68       4.238   3.638  -3.714  1.00  0.00           H 
ATOM   1057  N   ALA A  69       3.812  -1.395  -4.779  1.00  0.00           N 
ATOM   1058  CA  ALA A  69       2.968  -1.129  -5.968  1.00  0.00           C 
ATOM   1059  C   ALA A  69       2.750  -2.362  -6.864  1.00  0.00           C 
ATOM   1060  O   ALA A  69       1.723  -2.452  -7.540  1.00  0.00           O 
ATOM   1061  CB  ALA A  69       3.541   0.035  -6.782  1.00  0.00           C 
ATOM   1062  H   ALA A  69       4.534  -0.753  -4.600  1.00  0.00           H 
ATOM   1063  HA  ALA A  69       1.995  -0.814  -5.591  1.00  0.00           H 
ATOM   1064 1HB  ALA A  69       2.866   0.291  -7.588  1.00  0.00           H 
ATOM   1065 2HB  ALA A  69       4.501  -0.244  -7.192  1.00  0.00           H 
ATOM   1066 3HB  ALA A  69       3.669   0.898  -6.138  1.00  0.00           H 
ATOM   1067  N   SER A  70       3.719  -3.295  -6.867  1.00  0.00           N 
ATOM   1068  CA  SER A  70       3.591  -4.571  -7.581  1.00  0.00           C 
ATOM   1069  C   SER A  70       2.582  -5.487  -6.856  1.00  0.00           C 
ATOM   1070  O   SER A  70       1.629  -5.966  -7.467  1.00  0.00           O 
ATOM   1071  CB  SER A  70       4.982  -5.244  -7.682  1.00  0.00           C 
ATOM   1072  OG  SER A  70       5.938  -4.362  -8.264  1.00  0.00           O 
ATOM   1073  H   SER A  70       4.539  -3.131  -6.357  1.00  0.00           H 
ATOM   1074  HA  SER A  70       3.231  -4.362  -8.588  1.00  0.00           H 
ATOM   1075 2HB  SER A  70       4.914  -6.133  -8.297  1.00  0.00           H 
ATOM   1076 1HB  SER A  70       5.327  -5.519  -6.692  1.00  0.00           H 
ATOM   1077  HG  SER A  70       5.510  -3.523  -8.482  1.00  0.00           H 
ATOM   1078  N   ASP A  71       2.790  -5.676  -5.533  1.00  0.00           N 
ATOM   1079  CA  ASP A  71       1.988  -6.621  -4.716  1.00  0.00           C 
ATOM   1080  C   ASP A  71       0.567  -6.097  -4.432  1.00  0.00           C 
ATOM   1081  O   ASP A  71      -0.396  -6.816  -4.628  1.00  0.00           O 
ATOM   1082  CB  ASP A  71       2.705  -6.946  -3.384  1.00  0.00           C 
ATOM   1083  CG  ASP A  71       1.993  -8.057  -2.582  1.00  0.00           C 
ATOM   1084  OD1 ASP A  71       1.260  -7.755  -1.614  1.00  0.00           O 
ATOM   1085  OD2 ASP A  71       2.157  -9.243  -2.934  1.00  0.00           O 
ATOM   1086  H   ASP A  71       3.516  -5.175  -5.094  1.00  0.00           H 
ATOM   1087  HA  ASP A  71       1.904  -7.537  -5.293  1.00  0.00           H 
ATOM   1088 2HB  ASP A  71       2.758  -6.045  -2.779  1.00  0.00           H 
ATOM   1089 1HB  ASP A  71       3.718  -7.271  -3.602  1.00  0.00           H 
ATOM   1090  N   ALA A  72       0.477  -4.860  -3.910  1.00  0.00           N 
ATOM   1091  CA  ALA A  72      -0.798  -4.140  -3.659  1.00  0.00           C 
ATOM   1092  C   ALA A  72      -1.756  -4.176  -4.870  1.00  0.00           C 
ATOM   1093  O   ALA A  72      -2.974  -4.266  -4.708  1.00  0.00           O 
ATOM   1094  CB  ALA A  72      -0.501  -2.686  -3.254  1.00  0.00           C 
ATOM   1095  H   ALA A  72       1.301  -4.443  -3.622  1.00  0.00           H 
ATOM   1096  HA  ALA A  72      -1.282  -4.625  -2.815  1.00  0.00           H 
ATOM   1097 1HB  ALA A  72      -0.029  -2.167  -4.079  1.00  0.00           H 
ATOM   1098 2HB  ALA A  72       0.170  -2.678  -2.402  1.00  0.00           H 
ATOM   1099 3HB  ALA A  72      -1.419  -2.180  -2.988  1.00  0.00           H 
ATOM   1100  N   THR A  73      -1.182  -4.106  -6.079  1.00  0.00           N 
ATOM   1101  CA  THR A  73      -1.939  -4.250  -7.332  1.00  0.00           C 
ATOM   1102  C   THR A  73      -2.302  -5.733  -7.594  1.00  0.00           C 
ATOM   1103  O   THR A  73      -3.441  -6.040  -7.949  1.00  0.00           O 
ATOM   1104  CB  THR A  73      -1.141  -3.667  -8.538  1.00  0.00           C 
ATOM   1105  OG1 THR A  73      -0.950  -2.253  -8.349  1.00  0.00           O 
ATOM   1106  CG2 THR A  73      -1.846  -3.916  -9.880  1.00  0.00           C 
ATOM   1107  H   THR A  73      -0.217  -3.955  -6.116  1.00  0.00           H 
ATOM   1108  HA  THR A  73      -2.862  -3.679  -7.229  1.00  0.00           H 
ATOM   1109  HB  THR A  73      -0.162  -4.143  -8.567  1.00  0.00           H 
ATOM   1110  HG1 THR A  73      -0.325  -2.116  -7.632  1.00  0.00           H 
ATOM   1111 1HG2 THR A  73      -2.838  -3.479  -9.862  1.00  0.00           H 
ATOM   1112 2HG2 THR A  73      -1.929  -4.981 -10.062  1.00  0.00           H 
ATOM   1113 3HG2 THR A  73      -1.277  -3.464 -10.679  1.00  0.00           H 
ATOM   1114  N   ARG A  74      -1.316  -6.626  -7.391  1.00  0.00           N 
ATOM   1115  CA  ARG A  74      -1.441  -8.090  -7.607  1.00  0.00           C 
ATOM   1116  C   ARG A  74      -2.608  -8.699  -6.792  1.00  0.00           C 
ATOM   1117  O   ARG A  74      -3.410  -9.475  -7.319  1.00  0.00           O 
ATOM   1118  CB  ARG A  74      -0.091  -8.770  -7.248  1.00  0.00           C 
ATOM   1119  CG  ARG A  74      -0.047 -10.304  -7.400  1.00  0.00           C 
ATOM   1120  CD  ARG A  74       1.334 -10.879  -7.031  1.00  0.00           C 
ATOM   1121  NE  ARG A  74       1.378 -12.353  -7.150  1.00  0.00           N 
ATOM   1122  CZ  ARG A  74       2.390 -13.063  -7.676  1.00  0.00           C 
ATOM   1123  NH1 ARG A  74       3.445 -12.456  -8.206  1.00  0.00           N 
ATOM   1124  NH2 ARG A  74       2.331 -14.384  -7.672  1.00  0.00           N 
ATOM   1125  H   ARG A  74      -0.452  -6.280  -7.089  1.00  0.00           H 
ATOM   1126  HA  ARG A  74      -1.637  -8.245  -8.663  1.00  0.00           H 
ATOM   1127 2HB  ARG A  74       0.154  -8.524  -6.217  1.00  0.00           H 
ATOM   1128 1HB  ARG A  74       0.680  -8.350  -7.884  1.00  0.00           H 
ATOM   1129 2HG  ARG A  74      -0.277 -10.564  -8.428  1.00  0.00           H 
ATOM   1130 1HG  ARG A  74      -0.793 -10.745  -6.746  1.00  0.00           H 
ATOM   1131 2HD  ARG A  74       1.564 -10.611  -6.006  1.00  0.00           H 
ATOM   1132 1HD  ARG A  74       2.079 -10.441  -7.686  1.00  0.00           H 
ATOM   1133  HE  ARG A  74       0.607 -12.843  -6.783  1.00  0.00           H 
ATOM   1134 1HH1 ARG A  74       3.497 -11.456  -8.217  1.00  0.00           H 
ATOM   1135 2HH1 ARG A  74       4.199 -12.995  -8.593  1.00  0.00           H 
ATOM   1136 1HH2 ARG A  74       1.536 -14.855  -7.274  1.00  0.00           H 
ATOM   1137 2HH2 ARG A  74       3.080 -14.921  -8.064  1.00  0.00           H 
ATOM   1138  N   VAL A  75      -2.703  -8.307  -5.518  1.00  0.00           N 
ATOM   1139  CA  VAL A  75      -3.766  -8.751  -4.603  1.00  0.00           C 
ATOM   1140  C   VAL A  75      -5.114  -8.080  -4.955  1.00  0.00           C 
ATOM   1141  O   VAL A  75      -6.171  -8.698  -4.806  1.00  0.00           O 
ATOM   1142  CB  VAL A  75      -3.361  -8.516  -3.094  1.00  0.00           C 
ATOM   1143  CG1 VAL A  75      -3.126  -7.030  -2.774  1.00  0.00           C 
ATOM   1144  CG2 VAL A  75      -4.377  -9.140  -2.108  1.00  0.00           C 
ATOM   1145  H   VAL A  75      -2.036  -7.687  -5.180  1.00  0.00           H 
ATOM   1146  HA  VAL A  75      -3.882  -9.821  -4.750  1.00  0.00           H 
ATOM   1147  HB  VAL A  75      -2.410  -9.027  -2.942  1.00  0.00           H 
ATOM   1148 1HG1 VAL A  75      -4.042  -6.472  -2.932  1.00  0.00           H 
ATOM   1149 2HG1 VAL A  75      -2.354  -6.633  -3.419  1.00  0.00           H 
ATOM   1150 3HG1 VAL A  75      -2.816  -6.920  -1.741  1.00  0.00           H 
ATOM   1151 1HG2 VAL A  75      -4.472 -10.201  -2.297  1.00  0.00           H 
ATOM   1152 2HG2 VAL A  75      -5.345  -8.669  -2.230  1.00  0.00           H 
ATOM   1153 3HG2 VAL A  75      -4.037  -8.991  -1.089  1.00  0.00           H 
ATOM   1154  N   ALA A  76      -5.063  -6.833  -5.477  1.00  0.00           N 
ATOM   1155  CA  ALA A  76      -6.268  -6.064  -5.850  1.00  0.00           C 
ATOM   1156  C   ALA A  76      -6.974  -6.713  -7.054  1.00  0.00           C 
ATOM   1157  O   ALA A  76      -8.201  -6.859  -7.069  1.00  0.00           O 
ATOM   1158  CB  ALA A  76      -5.889  -4.613  -6.184  1.00  0.00           C 
ATOM   1159  H   ALA A  76      -4.191  -6.435  -5.679  1.00  0.00           H 
ATOM   1160  HA  ALA A  76      -6.941  -6.053  -4.995  1.00  0.00           H 
ATOM   1161 1HB  ALA A  76      -5.212  -4.599  -7.029  1.00  0.00           H 
ATOM   1162 2HB  ALA A  76      -5.399  -4.157  -5.331  1.00  0.00           H 
ATOM   1163 3HB  ALA A  76      -6.776  -4.046  -6.429  1.00  0.00           H 
ATOM   1164  N   GLN A  77      -6.162  -7.125  -8.042  1.00  0.00           N 
ATOM   1165  CA  GLN A  77      -6.653  -7.753  -9.279  1.00  0.00           C 
ATOM   1166  C   GLN A  77      -7.008  -9.228  -9.051  1.00  0.00           C 
ATOM   1167  O   GLN A  77      -7.849  -9.785  -9.772  1.00  0.00           O 
ATOM   1168  CB  GLN A  77      -5.651  -7.583 -10.449  1.00  0.00           C 
ATOM   1169  CG  GLN A  77      -4.273  -8.216 -10.229  1.00  0.00           C 
ATOM   1170  CD  GLN A  77      -3.381  -8.128 -11.464  1.00  0.00           C 
ATOM   1171  OE1 GLN A  77      -2.637  -7.160 -11.649  1.00  0.00           O 
ATOM   1172  NE2 GLN A  77      -3.459  -9.133 -12.325  1.00  0.00           N 
ATOM   1173  H   GLN A  77      -5.199  -7.018  -7.910  1.00  0.00           H 
ATOM   1174  HA  GLN A  77      -7.571  -7.239  -9.551  1.00  0.00           H 
ATOM   1175 2HB  GLN A  77      -5.512  -6.520 -10.629  1.00  0.00           H 
ATOM   1176 1HB  GLN A  77      -6.092  -8.021 -11.342  1.00  0.00           H 
ATOM   1177 2HG  GLN A  77      -4.402  -9.260  -9.959  1.00  0.00           H 
ATOM   1178 1HG  GLN A  77      -3.785  -7.701  -9.411  1.00  0.00           H 
ATOM   1179 2HE2 GLN A  77      -4.075  -9.868 -12.125  1.00  0.00           H 
ATOM   1180 1HE2 GLN A  77      -2.893  -9.102 -13.125  1.00  0.00           H 
ATOM   1181  N   LYS A  78      -6.365  -9.857  -8.043  1.00  0.00           N 
ATOM   1182  CA  LYS A  78      -6.742 -11.199  -7.557  1.00  0.00           C 
ATOM   1183  C   LYS A  78      -8.146 -11.164  -6.911  1.00  0.00           C 
ATOM   1184  O   LYS A  78      -8.851 -12.172  -6.875  1.00  0.00           O 
ATOM   1185  CB  LYS A  78      -5.672 -11.721  -6.555  1.00  0.00           C 
ATOM   1186  CG  LYS A  78      -5.885 -13.175  -6.073  1.00  0.00           C 
ATOM   1187  CD  LYS A  78      -4.740 -13.696  -5.165  1.00  0.00           C 
ATOM   1188  CE  LYS A  78      -3.396 -13.835  -5.900  1.00  0.00           C 
ATOM   1189  NZ  LYS A  78      -3.464 -14.823  -7.012  1.00  0.00           N 
ATOM   1190  H   LYS A  78      -5.596  -9.418  -7.625  1.00  0.00           H 
ATOM   1191  HA  LYS A  78      -6.772 -11.864  -8.415  1.00  0.00           H 
ATOM   1192 2HB  LYS A  78      -5.661 -11.072  -5.684  1.00  0.00           H 
ATOM   1193 1HB  LYS A  78      -4.697 -11.663  -7.032  1.00  0.00           H 
ATOM   1194 2HG  LYS A  78      -5.969 -13.824  -6.942  1.00  0.00           H 
ATOM   1195 1HG  LYS A  78      -6.818 -13.221  -5.517  1.00  0.00           H 
ATOM   1196 2HD  LYS A  78      -5.024 -14.669  -4.772  1.00  0.00           H 
ATOM   1197 1HD  LYS A  78      -4.613 -13.012  -4.333  1.00  0.00           H 
ATOM   1198 2HE  LYS A  78      -2.642 -14.163  -5.192  1.00  0.00           H 
ATOM   1199 1HE  LYS A  78      -3.108 -12.875  -6.304  1.00  0.00           H 
ATOM   1200 1HZ  LYS A  78      -3.722 -15.764  -6.642  1.00  0.00           H 
ATOM   1201 2HZ  LYS A  78      -2.544 -14.895  -7.484  1.00  0.00           H 
ATOM   1202 3HZ  LYS A  78      -4.176 -14.531  -7.713  1.00  0.00           H 
ATOM   1203  N   HIS A  79      -8.544  -9.970  -6.421  1.00  0.00           N 
ATOM   1204  CA  HIS A  79      -9.883  -9.736  -5.844  1.00  0.00           C 
ATOM   1205  C   HIS A  79     -10.934  -9.356  -6.915  1.00  0.00           C 
ATOM   1206  O   HIS A  79     -12.097  -9.150  -6.561  1.00  0.00           O 
ATOM   1207  CB  HIS A  79      -9.823  -8.651  -4.730  1.00  0.00           C 
ATOM   1208  CG  HIS A  79      -9.238  -9.128  -3.423  1.00  0.00           C 
ATOM   1209  ND1 HIS A  79      -8.108  -8.588  -2.846  1.00  0.00           N 
ATOM   1210  CD2 HIS A  79      -9.665 -10.085  -2.565  1.00  0.00           C 
ATOM   1211  CE1 HIS A  79      -7.871  -9.190  -1.700  1.00  0.00           C 
ATOM   1212  NE2 HIS A  79      -8.796 -10.102  -1.503  1.00  0.00           N 
ATOM   1213  H   HIS A  79      -7.908  -9.223  -6.448  1.00  0.00           H 
ATOM   1214  HA  HIS A  79     -10.212 -10.670  -5.391  1.00  0.00           H 
ATOM   1215 2HB  HIS A  79     -10.824  -8.290  -4.525  1.00  0.00           H 
ATOM   1216 1HB  HIS A  79      -9.223  -7.820  -5.079  1.00  0.00           H 
ATOM   1217  HD1 HIS A  79      -7.548  -7.885  -3.235  1.00  0.00           H 
ATOM   1218  HD2 HIS A  79     -10.536 -10.716  -2.687  1.00  0.00           H 
ATOM   1219  HE1 HIS A  79      -7.054  -8.970  -1.031  1.00  0.00           H 
ATOM   1220  HE2 HIS A  79      -8.704 -10.853  -0.873  1.00  0.00           H 
ATOM   1221  N   GLY A  80     -10.557  -9.291  -8.214  1.00  0.00           N 
ATOM   1222  CA  GLY A  80     -11.533  -9.018  -9.294  1.00  0.00           C 
ATOM   1223  C   GLY A  80     -11.312  -7.720 -10.069  1.00  0.00           C 
ATOM   1224  O   GLY A  80     -12.272  -6.996 -10.349  1.00  0.00           O 
ATOM   1225  H   GLY A  80      -9.639  -9.502  -8.466  1.00  0.00           H 
ATOM   1226 2HA  GLY A  80     -12.542  -9.007  -8.882  1.00  0.00           H 
ATOM   1227 1HA  GLY A  80     -11.476  -9.830 -10.000  1.00  0.00           H 
ATOM   1228  N   LEU A  81     -10.051  -7.419 -10.427  1.00  0.00           N 
ATOM   1229  CA  LEU A  81      -9.723  -6.369 -11.432  1.00  0.00           C 
ATOM   1230  C   LEU A  81      -9.052  -7.044 -12.637  1.00  0.00           C 
ATOM   1231  O   LEU A  81      -8.228  -7.946 -12.465  1.00  0.00           O 
ATOM   1232  CB  LEU A  81      -8.778  -5.239 -10.870  1.00  0.00           C 
ATOM   1233  CG  LEU A  81      -9.440  -4.074 -10.065  1.00  0.00           C 
ATOM   1234  CD1 LEU A  81     -10.495  -3.342 -10.914  1.00  0.00           C 
ATOM   1235  CD2 LEU A  81     -10.031  -4.561  -8.735  1.00  0.00           C 
ATOM   1236  H   LEU A  81      -9.318  -7.923 -10.025  1.00  0.00           H 
ATOM   1237  HA  LEU A  81     -10.656  -5.914 -11.768  1.00  0.00           H 
ATOM   1238 2HB  LEU A  81      -8.246  -4.790 -11.706  1.00  0.00           H 
ATOM   1239 1HB  LEU A  81      -8.039  -5.704 -10.234  1.00  0.00           H 
ATOM   1240  HG  LEU A  81      -8.670  -3.345  -9.823  1.00  0.00           H 
ATOM   1241 1HD1 LEU A  81     -11.306  -4.018 -11.167  1.00  0.00           H 
ATOM   1242 2HD1 LEU A  81     -10.040  -2.979 -11.825  1.00  0.00           H 
ATOM   1243 3HD1 LEU A  81     -10.890  -2.503 -10.360  1.00  0.00           H 
ATOM   1244 1HD2 LEU A  81     -10.446  -3.725  -8.184  1.00  0.00           H 
ATOM   1245 2HD2 LEU A  81      -9.252  -5.021  -8.142  1.00  0.00           H 
ATOM   1246 3HD2 LEU A  81     -10.812  -5.288  -8.922  1.00  0.00           H 
ATOM   1247  N   HIS A  82      -9.420  -6.614 -13.848  1.00  0.00           N 
ATOM   1248  CA  HIS A  82      -8.747  -7.029 -15.093  1.00  0.00           C 
ATOM   1249  C   HIS A  82      -7.687  -5.973 -15.485  1.00  0.00           C 
ATOM   1250  O   HIS A  82      -7.828  -4.808 -15.103  1.00  0.00           O 
ATOM   1251  CB  HIS A  82      -9.788  -7.234 -16.232  1.00  0.00           C 
ATOM   1252  CG  HIS A  82     -10.710  -8.413 -16.018  1.00  0.00           C 
ATOM   1253  ND1 HIS A  82     -11.999  -8.471 -16.508  1.00  0.00           N 
ATOM   1254  CD2 HIS A  82     -10.502  -9.599 -15.392  1.00  0.00           C 
ATOM   1255  CE1 HIS A  82     -12.536  -9.632 -16.191  1.00  0.00           C 
ATOM   1256  NE2 HIS A  82     -11.652 -10.333 -15.515  1.00  0.00           N 
ATOM   1257  H   HIS A  82     -10.169  -5.985 -13.911  1.00  0.00           H 
ATOM   1258  HA  HIS A  82      -8.238  -7.971 -14.910  1.00  0.00           H 
ATOM   1259 2HB  HIS A  82      -9.266  -7.395 -17.170  1.00  0.00           H 
ATOM   1260 1HB  HIS A  82     -10.399  -6.348 -16.319  1.00  0.00           H 
ATOM   1261  HD1 HIS A  82     -12.450  -7.769 -17.025  1.00  0.00           H 
ATOM   1262  HD2 HIS A  82      -9.596  -9.910 -14.892  1.00  0.00           H 
ATOM   1263  HE1 HIS A  82     -13.533  -9.958 -16.452  1.00  0.00           H 
ATOM   1264  HE2 HIS A  82     -11.857 -11.145 -15.006  1.00  0.00           H 
ATOM   1265  N   PRO A  83      -6.595  -6.361 -16.235  1.00  0.00           N 
ATOM   1266  CA  PRO A  83      -5.561  -5.401 -16.737  1.00  0.00           C 
ATOM   1267  C   PRO A  83      -6.128  -4.285 -17.654  1.00  0.00           C 
ATOM   1268  O   PRO A  83      -5.462  -3.276 -17.889  1.00  0.00           O 
ATOM   1269  CB  PRO A  83      -4.564  -6.314 -17.502  1.00  0.00           C 
ATOM   1270  CG  PRO A  83      -4.762  -7.675 -16.899  1.00  0.00           C 
ATOM   1271  CD  PRO A  83      -6.237  -7.763 -16.594  1.00  0.00           C 
ATOM   1272  HA  PRO A  83      -5.050  -4.931 -15.903  1.00  0.00           H 
ATOM   1273 2HB  PRO A  83      -3.547  -5.962 -17.357  1.00  0.00           H 
ATOM   1274 1HB  PRO A  83      -4.790  -6.317 -18.566  1.00  0.00           H 
ATOM   1275 2HG  PRO A  83      -4.178  -7.773 -15.987  1.00  0.00           H 
ATOM   1276 1HG  PRO A  83      -4.471  -8.445 -17.609  1.00  0.00           H 
ATOM   1277 2HD  PRO A  83      -6.416  -8.432 -15.762  1.00  0.00           H 
ATOM   1278 1HD  PRO A  83      -6.795  -8.092 -17.467  1.00  0.00           H 
ATOM   1279  N   LYS A  84      -7.366  -4.481 -18.138  1.00  0.00           N 
ATOM   1280  CA  LYS A  84      -8.084  -3.502 -18.983  1.00  0.00           C 
ATOM   1281  C   LYS A  84      -8.407  -2.216 -18.189  1.00  0.00           C 
ATOM   1282  O   LYS A  84      -8.498  -1.127 -18.763  1.00  0.00           O 
ATOM   1283  CB  LYS A  84      -9.385  -4.143 -19.541  1.00  0.00           C 
ATOM   1284  CG  LYS A  84      -9.183  -5.533 -20.199  1.00  0.00           C 
ATOM   1285  CD  LYS A  84      -8.175  -5.517 -21.380  1.00  0.00           C 
ATOM   1286  CE  LYS A  84      -8.673  -4.711 -22.596  1.00  0.00           C 
ATOM   1287  NZ  LYS A  84      -9.898  -5.301 -23.192  1.00  0.00           N 
ATOM   1288  H   LYS A  84      -7.818  -5.316 -17.913  1.00  0.00           H 
ATOM   1289  HA  LYS A  84      -7.434  -3.246 -19.814  1.00  0.00           H 
ATOM   1290 2HB  LYS A  84      -9.814  -3.474 -20.280  1.00  0.00           H 
ATOM   1291 1HB  LYS A  84     -10.097  -4.259 -18.727  1.00  0.00           H 
ATOM   1292 2HG  LYS A  84     -10.143  -5.890 -20.561  1.00  0.00           H 
ATOM   1293 1HG  LYS A  84      -8.818  -6.223 -19.443  1.00  0.00           H 
ATOM   1294 2HD  LYS A  84      -7.991  -6.540 -21.691  1.00  0.00           H 
ATOM   1295 1HD  LYS A  84      -7.238  -5.085 -21.038  1.00  0.00           H 
ATOM   1296 2HE  LYS A  84      -7.897  -4.692 -23.351  1.00  0.00           H 
ATOM   1297 1HE  LYS A  84      -8.893  -3.697 -22.288  1.00  0.00           H 
ATOM   1298 1HZ  LYS A  84      -9.713  -6.277 -23.501  1.00  0.00           H 
ATOM   1299 2HZ  LYS A  84     -10.203  -4.747 -24.013  1.00  0.00           H 
ATOM   1300 3HZ  LYS A  84     -10.667  -5.311 -22.493  1.00  0.00           H 
ATOM   1301  N   PHE A  85      -8.575  -2.382 -16.861  1.00  0.00           N 
ATOM   1302  CA  PHE A  85      -8.742  -1.277 -15.890  1.00  0.00           C 
ATOM   1303  C   PHE A  85      -7.506  -0.352 -15.878  1.00  0.00           C 
ATOM   1304  O   PHE A  85      -7.622   0.863 -15.679  1.00  0.00           O 
ATOM   1305  CB  PHE A  85      -8.978  -1.887 -14.478  1.00  0.00           C 
ATOM   1306  CG  PHE A  85      -9.107  -0.877 -13.331  1.00  0.00           C 
ATOM   1307  CD1 PHE A  85      -8.052  -0.657 -12.436  1.00  0.00           C 
ATOM   1308  CD2 PHE A  85     -10.289  -0.165 -13.138  1.00  0.00           C 
ATOM   1309  CE1 PHE A  85      -8.176   0.253 -11.400  1.00  0.00           C 
ATOM   1310  CE2 PHE A  85     -10.407   0.744 -12.103  1.00  0.00           C 
ATOM   1311  CZ  PHE A  85      -9.357   0.949 -11.231  1.00  0.00           C 
ATOM   1312  H   PHE A  85      -8.606  -3.301 -16.518  1.00  0.00           H 
ATOM   1313  HA  PHE A  85      -9.614  -0.702 -16.182  1.00  0.00           H 
ATOM   1314 2HB  PHE A  85      -8.154  -2.559 -14.248  1.00  0.00           H 
ATOM   1315 1HB  PHE A  85      -9.888  -2.475 -14.505  1.00  0.00           H 
ATOM   1316  HD1 PHE A  85      -7.122  -1.200 -12.563  1.00  0.00           H 
ATOM   1317  HD2 PHE A  85     -11.121  -0.319 -13.819  1.00  0.00           H 
ATOM   1318  HE1 PHE A  85      -7.351   0.413 -10.718  1.00  0.00           H 
ATOM   1319  HE2 PHE A  85     -11.330   1.289 -11.973  1.00  0.00           H 
ATOM   1320  HZ  PHE A  85      -9.458   1.659 -10.423  1.00  0.00           H 
ATOM   1321  N   GLY A  86      -6.328  -0.944 -16.131  1.00  0.00           N 
ATOM   1322  CA  GLY A  86      -5.050  -0.245 -16.002  1.00  0.00           C 
ATOM   1323  C   GLY A  86      -4.503  -0.368 -14.593  1.00  0.00           C 
ATOM   1324  O   GLY A  86      -4.081   0.620 -13.984  1.00  0.00           O 
ATOM   1325  H   GLY A  86      -6.329  -1.878 -16.417  1.00  0.00           H 
ATOM   1326 2HA  GLY A  86      -5.170   0.803 -16.256  1.00  0.00           H 
ATOM   1327 1HA  GLY A  86      -4.345  -0.693 -16.690  1.00  0.00           H 
ATOM   1328  N   ALA A  87      -4.539  -1.604 -14.072  1.00  0.00           N 
ATOM   1329  CA  ALA A  87      -4.053  -1.917 -12.723  1.00  0.00           C 
ATOM   1330  C   ALA A  87      -2.509  -1.847 -12.673  1.00  0.00           C 
ATOM   1331  O   ALA A  87      -1.939  -0.888 -12.143  1.00  0.00           O 
ATOM   1332  CB  ALA A  87      -4.589  -3.294 -12.286  1.00  0.00           C 
ATOM   1333  H   ALA A  87      -4.914  -2.326 -14.612  1.00  0.00           H 
ATOM   1334  HA  ALA A  87      -4.457  -1.173 -12.041  1.00  0.00           H 
ATOM   1335 1HB  ALA A  87      -5.670  -3.300 -12.342  1.00  0.00           H 
ATOM   1336 2HB  ALA A  87      -4.286  -3.499 -11.268  1.00  0.00           H 
ATOM   1337 3HB  ALA A  87      -4.193  -4.065 -12.937  1.00  0.00           H 
ATOM   1338  N   ILE A  88      -1.840  -2.864 -13.253  1.00  0.00           N 
ATOM   1339  CA  ILE A  88      -0.359  -2.942 -13.308  1.00  0.00           C 
ATOM   1340  C   ILE A  88       0.151  -2.513 -14.703  1.00  0.00           C 
ATOM   1341  O   ILE A  88       1.319  -2.169 -14.873  1.00  0.00           O 
ATOM   1342  CB  ILE A  88       0.129  -4.404 -12.954  1.00  0.00           C 
ATOM   1343  CG1 ILE A  88       1.685  -4.461 -12.764  1.00  0.00           C 
ATOM   1344  CG2 ILE A  88      -0.354  -5.429 -14.016  1.00  0.00           C 
ATOM   1345  CD1 ILE A  88       2.242  -5.819 -12.370  1.00  0.00           C 
ATOM   1346  H   ILE A  88      -2.352  -3.595 -13.648  1.00  0.00           H 
ATOM   1347  HA  ILE A  88       0.050  -2.255 -12.563  1.00  0.00           H 
ATOM   1348  HB  ILE A  88      -0.342  -4.674 -12.012  1.00  0.00           H 
ATOM   1349 2HG1 ILE A  88       1.976  -3.754 -11.993  1.00  0.00           H 
ATOM   1350 1HG1 ILE A  88       2.167  -4.182 -13.689  1.00  0.00           H 
ATOM   1351 1HG2 ILE A  88      -0.052  -6.432 -13.733  1.00  0.00           H 
ATOM   1352 2HG2 ILE A  88       0.078  -5.192 -14.981  1.00  0.00           H 
ATOM   1353 3HG2 ILE A  88      -1.434  -5.393 -14.097  1.00  0.00           H 
ATOM   1354 1HD1 ILE A  88       1.785  -6.150 -11.448  1.00  0.00           H 
ATOM   1355 2HD1 ILE A  88       3.312  -5.743 -12.228  1.00  0.00           H 
ATOM   1356 3HD1 ILE A  88       2.037  -6.535 -13.152  1.00  0.00           H 
ATOM   1357  N   THR A  89      -0.758  -2.527 -15.689  1.00  0.00           N 
ATOM   1358  CA  THR A  89      -0.455  -2.236 -17.105  1.00  0.00           C 
ATOM   1359  C   THR A  89      -0.475  -0.723 -17.419  1.00  0.00           C 
ATOM   1360  O   THR A  89      -0.211  -0.314 -18.558  1.00  0.00           O 
ATOM   1361  CB  THR A  89      -1.482  -3.000 -17.999  1.00  0.00           C 
ATOM   1362  OG1 THR A  89      -2.806  -2.780 -17.479  1.00  0.00           O 
ATOM   1363  CG2 THR A  89      -1.195  -4.515 -18.037  1.00  0.00           C 
ATOM   1364  H   THR A  89      -1.684  -2.747 -15.462  1.00  0.00           H 
ATOM   1365  HA  THR A  89       0.540  -2.616 -17.327  1.00  0.00           H 
ATOM   1366  HB  THR A  89      -1.434  -2.613 -19.014  1.00  0.00           H 
ATOM   1367  HG1 THR A  89      -3.365  -2.408 -18.175  1.00  0.00           H 
ATOM   1368 1HG2 THR A  89      -1.239  -4.921 -17.034  1.00  0.00           H 
ATOM   1369 2HG2 THR A  89      -0.208  -4.695 -18.450  1.00  0.00           H 
ATOM   1370 3HG2 THR A  89      -1.933  -5.010 -18.654  1.00  0.00           H 
ATOM   1371  N   ARG A  90      -0.800   0.098 -16.406  1.00  0.00           N 
ATOM   1372  CA  ARG A  90      -0.725   1.567 -16.492  1.00  0.00           C 
ATOM   1373  C   ARG A  90       0.533   2.016 -15.742  1.00  0.00           C 
ATOM   1374  O   ARG A  90       0.660   1.732 -14.540  1.00  0.00           O 
ATOM   1375  CB  ARG A  90      -1.994   2.212 -15.854  1.00  0.00           C 
ATOM   1376  CG  ARG A  90      -2.208   3.716 -16.171  1.00  0.00           C 
ATOM   1377  CD  ARG A  90      -2.627   3.955 -17.637  1.00  0.00           C 
ATOM   1378  NE  ARG A  90      -2.886   5.381 -17.933  1.00  0.00           N 
ATOM   1379  CZ  ARG A  90      -3.411   5.851 -19.080  1.00  0.00           C 
ATOM   1380  NH1 ARG A  90      -3.732   5.030 -20.072  1.00  0.00           N 
ATOM   1381  NH2 ARG A  90      -3.611   7.150 -19.221  1.00  0.00           N 
ATOM   1382  H   ARG A  90      -1.100  -0.300 -15.564  1.00  0.00           H 
ATOM   1383  HA  ARG A  90      -0.652   1.865 -17.535  1.00  0.00           H 
ATOM   1384 2HB  ARG A  90      -1.945   2.098 -14.774  1.00  0.00           H 
ATOM   1385 1HB  ARG A  90      -2.865   1.671 -16.207  1.00  0.00           H 
ATOM   1386 2HG  ARG A  90      -1.281   4.250 -15.978  1.00  0.00           H 
ATOM   1387 1HG  ARG A  90      -2.981   4.112 -15.519  1.00  0.00           H 
ATOM   1388 2HD  ARG A  90      -3.526   3.383 -17.842  1.00  0.00           H 
ATOM   1389 1HD  ARG A  90      -1.831   3.607 -18.289  1.00  0.00           H 
ATOM   1390  HE  ARG A  90      -2.664   6.028 -17.227  1.00  0.00           H 
ATOM   1391 1HH1 ARG A  90      -3.587   4.043 -19.973  1.00  0.00           H 
ATOM   1392 2HH1 ARG A  90      -4.131   5.389 -20.918  1.00  0.00           H 
ATOM   1393 1HH2 ARG A  90      -3.378   7.777 -18.472  1.00  0.00           H 
ATOM   1394 2HH2 ARG A  90      -4.001   7.513 -20.069  1.00  0.00           H 
ATOM   1395  N   VAL A  91       1.483   2.667 -16.442  1.00  0.00           N 
ATOM   1396  CA  VAL A  91       2.668   3.246 -15.787  1.00  0.00           C 
ATOM   1397  C   VAL A  91       2.232   4.461 -14.935  1.00  0.00           C 
ATOM   1398  O   VAL A  91       1.983   5.559 -15.451  1.00  0.00           O 
ATOM   1399  CB  VAL A  91       3.833   3.618 -16.804  1.00  0.00           C 
ATOM   1400  CG1 VAL A  91       4.455   2.343 -17.425  1.00  0.00           C 
ATOM   1401  CG2 VAL A  91       3.373   4.587 -17.924  1.00  0.00           C 
ATOM   1402  H   VAL A  91       1.383   2.756 -17.409  1.00  0.00           H 
ATOM   1403  HA  VAL A  91       3.061   2.484 -15.106  1.00  0.00           H 
ATOM   1404  HB  VAL A  91       4.616   4.116 -16.232  1.00  0.00           H 
ATOM   1405 1HG1 VAL A  91       4.830   1.698 -16.639  1.00  0.00           H 
ATOM   1406 2HG1 VAL A  91       5.277   2.614 -18.077  1.00  0.00           H 
ATOM   1407 3HG1 VAL A  91       3.707   1.809 -17.998  1.00  0.00           H 
ATOM   1408 1HG2 VAL A  91       2.584   4.126 -18.506  1.00  0.00           H 
ATOM   1409 2HG2 VAL A  91       4.205   4.823 -18.575  1.00  0.00           H 
ATOM   1410 3HG2 VAL A  91       3.002   5.502 -17.483  1.00  0.00           H 
ATOM   1411  N   HIS A  92       2.041   4.214 -13.622  1.00  0.00           N 
ATOM   1412  CA  HIS A  92       1.611   5.252 -12.673  1.00  0.00           C 
ATOM   1413  C   HIS A  92       2.725   6.301 -12.547  1.00  0.00           C 
ATOM   1414  O   HIS A  92       3.779   6.029 -11.982  1.00  0.00           O 
ATOM   1415  CB  HIS A  92       1.242   4.649 -11.290  1.00  0.00           C 
ATOM   1416  CG  HIS A  92       0.083   3.671 -11.333  1.00  0.00           C 
ATOM   1417  ND1 HIS A  92      -1.236   4.053 -11.206  1.00  0.00           N 
ATOM   1418  CD2 HIS A  92       0.057   2.322 -11.494  1.00  0.00           C 
ATOM   1419  CE1 HIS A  92      -2.014   2.989 -11.292  1.00  0.00           C 
ATOM   1420  NE2 HIS A  92      -1.253   1.929 -11.465  1.00  0.00           N 
ATOM   1421  H   HIS A  92       2.198   3.305 -13.292  1.00  0.00           H 
ATOM   1422  HA  HIS A  92       0.724   5.731 -13.090  1.00  0.00           H 
ATOM   1423 2HB  HIS A  92       0.968   5.458 -10.614  1.00  0.00           H 
ATOM   1424 1HB  HIS A  92       2.102   4.133 -10.883  1.00  0.00           H 
ATOM   1425  HD1 HIS A  92      -1.555   4.969 -11.050  1.00  0.00           H 
ATOM   1426  HD2 HIS A  92       0.915   1.678 -11.627  1.00  0.00           H 
ATOM   1427  HE1 HIS A  92      -3.092   2.988 -11.233  1.00  0.00           H 
ATOM   1428  HE2 HIS A  92      -1.559   1.004 -11.383  1.00  0.00           H 
ATOM   1429  N   LYS A  93       2.492   7.482 -13.133  1.00  0.00           N 
ATOM   1430  CA  LYS A  93       3.489   8.568 -13.188  1.00  0.00           C 
ATOM   1431  C   LYS A  93       3.647   9.235 -11.810  1.00  0.00           C 
ATOM   1432  O   LYS A  93       4.724   9.737 -11.469  1.00  0.00           O 
ATOM   1433  CB  LYS A  93       3.075   9.600 -14.267  1.00  0.00           C 
ATOM   1434  CG  LYS A  93       2.959   9.017 -15.694  1.00  0.00           C 
ATOM   1435  CD  LYS A  93       2.605  10.069 -16.786  1.00  0.00           C 
ATOM   1436  CE  LYS A  93       1.178  10.666 -16.665  1.00  0.00           C 
ATOM   1437  NZ  LYS A  93       1.033  11.660 -15.562  1.00  0.00           N 
ATOM   1438  H   LYS A  93       1.610   7.638 -13.536  1.00  0.00           H 
ATOM   1439  HA  LYS A  93       4.443   8.132 -13.472  1.00  0.00           H 
ATOM   1440 2HB  LYS A  93       3.807  10.403 -14.287  1.00  0.00           H 
ATOM   1441 1HB  LYS A  93       2.111  10.022 -13.996  1.00  0.00           H 
ATOM   1442 2HG  LYS A  93       2.193   8.246 -15.689  1.00  0.00           H 
ATOM   1443 1HG  LYS A  93       3.908   8.558 -15.956  1.00  0.00           H 
ATOM   1444 2HD  LYS A  93       2.700   9.596 -17.760  1.00  0.00           H 
ATOM   1445 1HD  LYS A  93       3.319  10.882 -16.729  1.00  0.00           H 
ATOM   1446 2HE  LYS A  93       0.476   9.859 -16.496  1.00  0.00           H 
ATOM   1447 1HE  LYS A  93       0.925  11.158 -17.595  1.00  0.00           H 
ATOM   1448 1HZ  LYS A  93       1.721  12.431 -15.678  1.00  0.00           H 
ATOM   1449 2HZ  LYS A  93       1.192  11.205 -14.642  1.00  0.00           H 
ATOM   1450 3HZ  LYS A  93       0.076  12.062 -15.570  1.00  0.00           H 
ATOM   1451  N   GLU A  94       2.556   9.207 -11.022  1.00  0.00           N 
ATOM   1452  CA  GLU A  94       2.523   9.729  -9.643  1.00  0.00           C 
ATOM   1453  C   GLU A  94       2.995   8.671  -8.620  1.00  0.00           C 
ATOM   1454  O   GLU A  94       2.924   8.912  -7.406  1.00  0.00           O 
ATOM   1455  CB  GLU A  94       1.092  10.213  -9.311  1.00  0.00           C 
ATOM   1456  CG  GLU A  94       0.583  11.336 -10.238  1.00  0.00           C 
ATOM   1457  CD  GLU A  94      -0.884  11.706  -9.996  1.00  0.00           C 
ATOM   1458  OE1 GLU A  94      -1.771  11.134 -10.672  1.00  0.00           O 
ATOM   1459  OE2 GLU A  94      -1.167  12.561  -9.125  1.00  0.00           O 
ATOM   1460  H   GLU A  94       1.732   8.819 -11.388  1.00  0.00           H 
ATOM   1461  HA  GLU A  94       3.200  10.577  -9.584  1.00  0.00           H 
ATOM   1462 2HB  GLU A  94       1.072  10.578  -8.288  1.00  0.00           H 
ATOM   1463 1HB  GLU A  94       0.413   9.368  -9.391  1.00  0.00           H 
ATOM   1464 2HG  GLU A  94       0.696  11.002 -11.267  1.00  0.00           H 
ATOM   1465 1HG  GLU A  94       1.199  12.220 -10.093  1.00  0.00           H 
ATOM   1466  N   TYR A  95       3.476   7.503  -9.118  1.00  0.00           N 
ATOM   1467  CA  TYR A  95       4.135   6.486  -8.279  1.00  0.00           C 
ATOM   1468  C   TYR A  95       5.365   7.088  -7.593  1.00  0.00           C 
ATOM   1469  O   TYR A  95       5.620   6.779  -6.446  1.00  0.00           O 
ATOM   1470  CB  TYR A  95       4.545   5.236  -9.115  1.00  0.00           C 
ATOM   1471  CG  TYR A  95       5.515   4.274  -8.392  1.00  0.00           C 
ATOM   1472  CD1 TYR A  95       6.863   4.178  -8.774  1.00  0.00           C 
ATOM   1473  CD2 TYR A  95       5.098   3.507  -7.302  1.00  0.00           C 
ATOM   1474  CE1 TYR A  95       7.742   3.349  -8.104  1.00  0.00           C 
ATOM   1475  CE2 TYR A  95       5.978   2.674  -6.635  1.00  0.00           C 
ATOM   1476  CZ  TYR A  95       7.293   2.602  -7.033  1.00  0.00           C 
ATOM   1477  OH  TYR A  95       8.162   1.777  -6.358  1.00  0.00           O 
ATOM   1478  H   TYR A  95       3.386   7.329 -10.076  1.00  0.00           H 
ATOM   1479  HA  TYR A  95       3.423   6.180  -7.516  1.00  0.00           H 
ATOM   1480 2HB  TYR A  95       5.016   5.567 -10.034  1.00  0.00           H 
ATOM   1481 1HB  TYR A  95       3.652   4.675  -9.373  1.00  0.00           H 
ATOM   1482  HD1 TYR A  95       7.216   4.759  -9.619  1.00  0.00           H 
ATOM   1483  HD2 TYR A  95       4.065   3.558  -6.987  1.00  0.00           H 
ATOM   1484  HE1 TYR A  95       8.780   3.294  -8.417  1.00  0.00           H 
ATOM   1485  HE2 TYR A  95       5.631   2.089  -5.797  1.00  0.00           H 
ATOM   1486  HH  TYR A  95       7.726   0.944  -6.165  1.00  0.00           H 
ATOM   1487  N   ASP A  96       6.110   7.947  -8.322  1.00  0.00           N 
ATOM   1488  CA  ASP A  96       7.323   8.614  -7.801  1.00  0.00           C 
ATOM   1489  C   ASP A  96       7.007   9.511  -6.587  1.00  0.00           C 
ATOM   1490  O   ASP A  96       7.827   9.639  -5.678  1.00  0.00           O 
ATOM   1491  CB  ASP A  96       8.008   9.445  -8.910  1.00  0.00           C 
ATOM   1492  CG  ASP A  96       8.579   8.562 -10.026  1.00  0.00           C 
ATOM   1493  OD1 ASP A  96       7.841   8.243 -10.981  1.00  0.00           O 
ATOM   1494  OD2 ASP A  96       9.759   8.151  -9.938  1.00  0.00           O 
ATOM   1495  H   ASP A  96       5.848   8.128  -9.252  1.00  0.00           H 
ATOM   1496  HA  ASP A  96       8.009   7.832  -7.481  1.00  0.00           H 
ATOM   1497 2HB  ASP A  96       8.818  10.029  -8.479  1.00  0.00           H 
ATOM   1498 1HB  ASP A  96       7.280  10.130  -9.336  1.00  0.00           H 
ATOM   1499  N   ALA A  97       5.803  10.107  -6.585  1.00  0.00           N 
ATOM   1500  CA  ALA A  97       5.326  10.970  -5.487  1.00  0.00           C 
ATOM   1501  C   ALA A  97       5.018  10.140  -4.217  1.00  0.00           C 
ATOM   1502  O   ALA A  97       5.357  10.536  -3.100  1.00  0.00           O 
ATOM   1503  CB  ALA A  97       4.099  11.770  -5.945  1.00  0.00           C 
ATOM   1504  H   ALA A  97       5.212   9.961  -7.353  1.00  0.00           H 
ATOM   1505  HA  ALA A  97       6.119  11.679  -5.254  1.00  0.00           H 
ATOM   1506 1HB  ALA A  97       3.784  12.445  -5.157  1.00  0.00           H 
ATOM   1507 2HB  ALA A  97       3.286  11.095  -6.178  1.00  0.00           H 
ATOM   1508 3HB  ALA A  97       4.344  12.345  -6.829  1.00  0.00           H 
ATOM   1509  N   MET A  98       4.338   9.006  -4.405  1.00  0.00           N 
ATOM   1510  CA  MET A  98       4.095   8.012  -3.331  1.00  0.00           C 
ATOM   1511  C   MET A  98       5.418   7.385  -2.814  1.00  0.00           C 
ATOM   1512  O   MET A  98       5.594   7.159  -1.619  1.00  0.00           O 
ATOM   1513  CB  MET A  98       3.161   6.917  -3.897  1.00  0.00           C 
ATOM   1514  CG  MET A  98       2.554   5.951  -2.868  1.00  0.00           C 
ATOM   1515  SD  MET A  98       1.484   4.703  -3.631  1.00  0.00           S 
ATOM   1516  CE  MET A  98       0.508   5.665  -4.781  1.00  0.00           C 
ATOM   1517  H   MET A  98       3.896   8.869  -5.270  1.00  0.00           H 
ATOM   1518  HA  MET A  98       3.598   8.517  -2.511  1.00  0.00           H 
ATOM   1519 2HB  MET A  98       3.715   6.332  -4.624  1.00  0.00           H 
ATOM   1520 1HB  MET A  98       2.341   7.403  -4.410  1.00  0.00           H 
ATOM   1521 2HG  MET A  98       1.971   6.512  -2.151  1.00  0.00           H 
ATOM   1522 1HG  MET A  98       3.355   5.437  -2.351  1.00  0.00           H 
ATOM   1523 1HE  MET A  98       1.155   6.105  -5.526  1.00  0.00           H 
ATOM   1524 2HE  MET A  98      -0.012   6.446  -4.247  1.00  0.00           H 
ATOM   1525 3HE  MET A  98      -0.213   5.023  -5.265  1.00  0.00           H 
ATOM   1526  N   PHE A  99       6.315   7.121  -3.766  1.00  0.00           N 
ATOM   1527  CA  PHE A  99       7.653   6.536  -3.543  1.00  0.00           C 
ATOM   1528  C   PHE A  99       8.479   7.417  -2.592  1.00  0.00           C 
ATOM   1529  O   PHE A  99       9.036   6.926  -1.598  1.00  0.00           O 
ATOM   1530  CB  PHE A  99       8.364   6.379  -4.916  1.00  0.00           C 
ATOM   1531  CG  PHE A  99       9.773   5.779  -4.878  1.00  0.00           C 
ATOM   1532  CD1 PHE A  99      10.906   6.597  -4.812  1.00  0.00           C 
ATOM   1533  CD2 PHE A  99       9.962   4.397  -4.912  1.00  0.00           C 
ATOM   1534  CE1 PHE A  99      12.172   6.051  -4.782  1.00  0.00           C 
ATOM   1535  CE2 PHE A  99      11.231   3.855  -4.884  1.00  0.00           C 
ATOM   1536  CZ  PHE A  99      12.335   4.680  -4.817  1.00  0.00           C 
ATOM   1537  H   PHE A  99       6.034   7.320  -4.670  1.00  0.00           H 
ATOM   1538  HA  PHE A  99       7.520   5.556  -3.096  1.00  0.00           H 
ATOM   1539 2HB  PHE A  99       8.428   7.356  -5.384  1.00  0.00           H 
ATOM   1540 1HB  PHE A  99       7.752   5.746  -5.550  1.00  0.00           H 
ATOM   1541  HD1 PHE A  99      10.785   7.675  -4.786  1.00  0.00           H 
ATOM   1542  HD2 PHE A  99       9.097   3.743  -4.964  1.00  0.00           H 
ATOM   1543  HE1 PHE A  99      13.041   6.698  -4.731  1.00  0.00           H 
ATOM   1544  HE2 PHE A  99      11.361   2.784  -4.912  1.00  0.00           H 
ATOM   1545  HZ  PHE A  99      13.331   4.252  -4.794  1.00  0.00           H 
ATOM   1546  N   GLU A 100       8.531   8.729  -2.905  1.00  0.00           N 
ATOM   1547  CA  GLU A 100       9.299   9.709  -2.124  1.00  0.00           C 
ATOM   1548  C   GLU A 100       8.654   9.971  -0.745  1.00  0.00           C 
ATOM   1549  O   GLU A 100       9.364  10.256   0.232  1.00  0.00           O 
ATOM   1550  CB  GLU A 100       9.487  11.024  -2.904  1.00  0.00           C 
ATOM   1551  CG  GLU A 100       8.188  11.775  -3.220  1.00  0.00           C 
ATOM   1552  CD  GLU A 100       8.413  13.113  -3.918  1.00  0.00           C 
ATOM   1553  OE1 GLU A 100       8.721  13.118  -5.126  1.00  0.00           O 
ATOM   1554  OE2 GLU A 100       8.297  14.167  -3.256  1.00  0.00           O 
ATOM   1555  H   GLU A 100       8.051   9.040  -3.699  1.00  0.00           H 
ATOM   1556  HA  GLU A 100      10.279   9.274  -1.958  1.00  0.00           H 
ATOM   1557 2HB  GLU A 100       9.985  10.797  -3.843  1.00  0.00           H 
ATOM   1558 1HB  GLU A 100      10.134  11.680  -2.329  1.00  0.00           H 
ATOM   1559 2HG  GLU A 100       7.653  11.944  -2.290  1.00  0.00           H 
ATOM   1560 1HG  GLU A 100       7.572  11.151  -3.861  1.00  0.00           H 
ATOM   1561  N   ASP A 101       7.313   9.859  -0.678  1.00  0.00           N 
ATOM   1562  CA  ASP A 101       6.566   9.938   0.591  1.00  0.00           C 
ATOM   1563  C   ASP A 101       7.044   8.829   1.546  1.00  0.00           C 
ATOM   1564  O   ASP A 101       7.445   9.103   2.675  1.00  0.00           O 
ATOM   1565  CB  ASP A 101       5.037   9.810   0.338  1.00  0.00           C 
ATOM   1566  CG  ASP A 101       4.196   9.798   1.637  1.00  0.00           C 
ATOM   1567  OD1 ASP A 101       3.781  10.883   2.104  1.00  0.00           O 
ATOM   1568  OD2 ASP A 101       3.970   8.708   2.209  1.00  0.00           O 
ATOM   1569  H   ASP A 101       6.814   9.717  -1.511  1.00  0.00           H 
ATOM   1570  HA  ASP A 101       6.773  10.908   1.038  1.00  0.00           H 
ATOM   1571 2HB  ASP A 101       4.845   8.893  -0.211  1.00  0.00           H 
ATOM   1572 1HB  ASP A 101       4.716  10.646  -0.274  1.00  0.00           H 
ATOM   1573  N   ILE A 102       6.995   7.586   1.045  1.00  0.00           N 
ATOM   1574  CA  ILE A 102       7.371   6.379   1.795  1.00  0.00           C 
ATOM   1575  C   ILE A 102       8.872   6.366   2.192  1.00  0.00           C 
ATOM   1576  O   ILE A 102       9.186   5.946   3.296  1.00  0.00           O 
ATOM   1577  CB  ILE A 102       6.952   5.080   0.992  1.00  0.00           C 
ATOM   1578  CG1 ILE A 102       5.390   5.028   0.855  1.00  0.00           C 
ATOM   1579  CG2 ILE A 102       7.492   3.774   1.638  1.00  0.00           C 
ATOM   1580  CD1 ILE A 102       4.835   3.822   0.114  1.00  0.00           C 
ATOM   1581  H   ILE A 102       6.629   7.478   0.146  1.00  0.00           H 
ATOM   1582  HA  ILE A 102       6.786   6.395   2.715  1.00  0.00           H 
ATOM   1583  HB  ILE A 102       7.387   5.157  -0.004  1.00  0.00           H 
ATOM   1584 2HG1 ILE A 102       5.054   5.916   0.329  1.00  0.00           H 
ATOM   1585 1HG1 ILE A 102       4.947   5.024   1.841  1.00  0.00           H 
ATOM   1586 1HG2 ILE A 102       7.104   3.678   2.645  1.00  0.00           H 
ATOM   1587 2HG2 ILE A 102       8.571   3.803   1.677  1.00  0.00           H 
ATOM   1588 3HG2 ILE A 102       7.184   2.916   1.052  1.00  0.00           H 
ATOM   1589 1HD1 ILE A 102       5.238   3.791  -0.888  1.00  0.00           H 
ATOM   1590 2HD1 ILE A 102       3.759   3.900   0.063  1.00  0.00           H 
ATOM   1591 3HD1 ILE A 102       5.102   2.915   0.639  1.00  0.00           H 
ATOM   1592  N   ARG A 103       9.792   6.849   1.319  1.00  0.00           N 
ATOM   1593  CA  ARG A 103      11.250   6.864   1.657  1.00  0.00           C 
ATOM   1594  C   ARG A 103      11.562   7.892   2.760  1.00  0.00           C 
ATOM   1595  O   ARG A 103      12.472   7.680   3.572  1.00  0.00           O 
ATOM   1596  CB  ARG A 103      12.169   7.019   0.397  1.00  0.00           C 
ATOM   1597  CG  ARG A 103      12.073   8.333  -0.411  1.00  0.00           C 
ATOM   1598  CD  ARG A 103      12.959   9.483   0.108  1.00  0.00           C 
ATOM   1599  NE  ARG A 103      12.919  10.630  -0.821  1.00  0.00           N 
ATOM   1600  CZ  ARG A 103      12.215  11.763  -0.650  1.00  0.00           C 
ATOM   1601  NH1 ARG A 103      11.569  12.003   0.477  1.00  0.00           N 
ATOM   1602  NH2 ARG A 103      12.164  12.658  -1.621  1.00  0.00           N 
ATOM   1603  H   ARG A 103       9.473   7.177   0.456  1.00  0.00           H 
ATOM   1604  HA  ARG A 103      11.459   5.881   2.085  1.00  0.00           H 
ATOM   1605 2HB  ARG A 103      11.930   6.200  -0.279  1.00  0.00           H 
ATOM   1606 1HB  ARG A 103      13.200   6.891   0.706  1.00  0.00           H 
ATOM   1607 2HG  ARG A 103      11.041   8.664  -0.402  1.00  0.00           H 
ATOM   1608 1HG  ARG A 103      12.356   8.130  -1.438  1.00  0.00           H 
ATOM   1609 2HD  ARG A 103      13.982   9.132   0.186  1.00  0.00           H 
ATOM   1610 1HD  ARG A 103      12.612   9.791   1.089  1.00  0.00           H 
ATOM   1611  HE  ARG A 103      13.433  10.530  -1.655  1.00  0.00           H 
ATOM   1612 1HH1 ARG A 103      11.604  11.347   1.228  1.00  0.00           H 
ATOM   1613 2HH1 ARG A 103      11.022  12.838   0.570  1.00  0.00           H 
ATOM   1614 1HH2 ARG A 103      12.657  12.497  -2.480  1.00  0.00           H 
ATOM   1615 2HH2 ARG A 103      11.623  13.497  -1.507  1.00  0.00           H 
ATOM   1616  N   ALA A 104      10.784   8.990   2.798  1.00  0.00           N 
ATOM   1617  CA  ALA A 104      10.911  10.016   3.848  1.00  0.00           C 
ATOM   1618  C   ALA A 104      10.304   9.512   5.169  1.00  0.00           C 
ATOM   1619  O   ALA A 104      10.874   9.709   6.237  1.00  0.00           O 
ATOM   1620  CB  ALA A 104      10.240  11.320   3.405  1.00  0.00           C 
ATOM   1621  H   ALA A 104      10.064   9.084   2.136  1.00  0.00           H 
ATOM   1622  HA  ALA A 104      11.972  10.211   3.998  1.00  0.00           H 
ATOM   1623 1HB  ALA A 104      10.365  12.076   4.170  1.00  0.00           H 
ATOM   1624 2HB  ALA A 104       9.183  11.149   3.236  1.00  0.00           H 
ATOM   1625 3HB  ALA A 104      10.695  11.666   2.489  1.00  0.00           H 
ATOM   1626  N   LYS A 105       9.113   8.899   5.068  1.00  0.00           N 
ATOM   1627  CA  LYS A 105       8.384   8.275   6.193  1.00  0.00           C 
ATOM   1628  C   LYS A 105       9.185   7.149   6.885  1.00  0.00           C 
ATOM   1629  O   LYS A 105       9.189   7.047   8.112  1.00  0.00           O 
ATOM   1630  CB  LYS A 105       7.035   7.725   5.649  1.00  0.00           C 
ATOM   1631  CG  LYS A 105       5.956   7.453   6.708  1.00  0.00           C 
ATOM   1632  CD  LYS A 105       5.529   8.726   7.462  1.00  0.00           C 
ATOM   1633  CE  LYS A 105       4.398   8.459   8.459  1.00  0.00           C 
ATOM   1634  NZ  LYS A 105       3.126   8.088   7.782  1.00  0.00           N 
ATOM   1635  H   LYS A 105       8.628   8.947   4.226  1.00  0.00           H 
ATOM   1636  HA  LYS A 105       8.182   9.055   6.914  1.00  0.00           H 
ATOM   1637 2HB  LYS A 105       7.227   6.797   5.113  1.00  0.00           H 
ATOM   1638 1HB  LYS A 105       6.632   8.439   4.943  1.00  0.00           H 
ATOM   1639 2HG  LYS A 105       6.345   6.733   7.424  1.00  0.00           H 
ATOM   1640 1HG  LYS A 105       5.086   7.024   6.218  1.00  0.00           H 
ATOM   1641 2HD  LYS A 105       5.193   9.465   6.740  1.00  0.00           H 
ATOM   1642 1HD  LYS A 105       6.384   9.123   8.000  1.00  0.00           H 
ATOM   1643 2HE  LYS A 105       4.233   9.348   9.054  1.00  0.00           H 
ATOM   1644 1HE  LYS A 105       4.697   7.644   9.111  1.00  0.00           H 
ATOM   1645 1HZ  LYS A 105       2.791   8.877   7.190  1.00  0.00           H 
ATOM   1646 2HZ  LYS A 105       2.393   7.863   8.485  1.00  0.00           H 
ATOM   1647 3HZ  LYS A 105       3.273   7.258   7.178  1.00  0.00           H 
ATOM   1648  N   LEU A 106       9.835   6.303   6.073  1.00  0.00           N 
ATOM   1649  CA  LEU A 106      10.764   5.252   6.553  1.00  0.00           C 
ATOM   1650  C   LEU A 106      11.969   5.862   7.293  1.00  0.00           C 
ATOM   1651  O   LEU A 106      12.514   5.244   8.209  1.00  0.00           O 
ATOM   1652  CB  LEU A 106      11.261   4.346   5.371  1.00  0.00           C 
ATOM   1653  CG  LEU A 106      10.479   3.013   5.133  1.00  0.00           C 
ATOM   1654  CD1 LEU A 106       8.976   3.257   4.962  1.00  0.00           C 
ATOM   1655  CD2 LEU A 106      11.045   2.245   3.916  1.00  0.00           C 
ATOM   1656  H   LEU A 106       9.644   6.363   5.127  1.00  0.00           H 
ATOM   1657  HA  LEU A 106      10.197   4.645   7.258  1.00  0.00           H 
ATOM   1658 2HB  LEU A 106      12.303   4.089   5.538  1.00  0.00           H 
ATOM   1659 1HB  LEU A 106      11.213   4.932   4.459  1.00  0.00           H 
ATOM   1660  HG  LEU A 106      10.600   2.376   6.004  1.00  0.00           H 
ATOM   1661 1HD1 LEU A 106       8.585   3.768   5.831  1.00  0.00           H 
ATOM   1662 2HD1 LEU A 106       8.464   2.313   4.852  1.00  0.00           H 
ATOM   1663 3HD1 LEU A 106       8.800   3.863   4.081  1.00  0.00           H 
ATOM   1664 1HD2 LEU A 106      10.508   1.313   3.793  1.00  0.00           H 
ATOM   1665 2HD2 LEU A 106      12.094   2.027   4.073  1.00  0.00           H 
ATOM   1666 3HD2 LEU A 106      10.934   2.841   3.017  1.00  0.00           H 
ATOM   1667  N   HIS A 107      12.381   7.063   6.863  1.00  0.00           N 
ATOM   1668  CA  HIS A 107      13.452   7.827   7.525  1.00  0.00           C 
ATOM   1669  C   HIS A 107      12.904   8.573   8.768  1.00  0.00           C 
ATOM   1670  O   HIS A 107      13.686   8.991   9.639  1.00  0.00           O 
ATOM   1671  CB  HIS A 107      14.090   8.813   6.507  1.00  0.00           C 
ATOM   1672  CG  HIS A 107      15.289   9.570   7.026  1.00  0.00           C 
ATOM   1673  ND1 HIS A 107      16.525   8.984   7.199  1.00  0.00           N 
ATOM   1674  CD2 HIS A 107      15.429  10.855   7.429  1.00  0.00           C 
ATOM   1675  CE1 HIS A 107      17.367   9.873   7.681  1.00  0.00           C 
ATOM   1676  NE2 HIS A 107      16.728  11.018   7.828  1.00  0.00           N 
ATOM   1677  H   HIS A 107      11.949   7.450   6.073  1.00  0.00           H 
ATOM   1678  HA  HIS A 107      14.213   7.121   7.855  1.00  0.00           H 
ATOM   1679 2HB  HIS A 107      13.342   9.536   6.195  1.00  0.00           H 
ATOM   1680 1HB  HIS A 107      14.414   8.256   5.636  1.00  0.00           H 
ATOM   1681  HD1 HIS A 107      16.750   8.051   6.995  1.00  0.00           H 
ATOM   1682  HD2 HIS A 107      14.659  11.614   7.432  1.00  0.00           H 
ATOM   1683  HE1 HIS A 107      18.406   9.694   7.922  1.00  0.00           H 
ATOM   1684  HE2 HIS A 107      17.070  11.790   8.325  1.00  0.00           H 
END
