
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  242 ( 1916),  selected  242 , name 3d2l_C
# Molecule2: number of CA atoms  218 ( 1715),  selected  218 , name T0485.pdb
# PARAMETERS: 3d2l_C.T0485.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    X     1_C      M       1           -
LGA    -       -      S       2           -
LGA    -       -      E       3           -
LGA    -       -      N       4           -
LGA    -       -      K       5           -
LGA    -       -      K       6           -
LGA    -       -      K       7           -
LGA    -       -      F       8           -
LGA    -       -      D       9           -
LGA    A     2_C      K      10           #
LGA    Y     3_C      K      11          3.080
LGA    E     4_C      G      12           -
LGA    Q     5_C      -       -           -
LGA    F     6_C      -       -           -
LGA    A     7_C      A      13          2.511
LGA    Y     8_C      K      14          2.935
LGA    V     9_C      N      15          3.953
LGA    Y    10_C      M      16          2.860
LGA    D    11_C      D      17          2.345
LGA    E    12_C      E      18          2.268
LGA    L    13_C      I      19          2.789
LGA    X    14_C      S      20          3.676
LGA    Q    15_C      K      21          3.659
LGA    -       -      T      22           -
LGA    D    16_C      L      23          1.995
LGA    V    17_C      F      24          1.535
LGA    -       -      A      25           -
LGA    -       -      P      26           -
LGA    P    18_C      I      27          1.552
LGA    Y    19_C      Y      28          1.144
LGA    P    20_C      P      29          1.261
LGA    E    21_C      I      30          1.534
LGA    W    22_C      I      31          0.955
LGA    V    23_C      A      32          0.473
LGA    A    24_C      E      33          1.139
LGA    W    25_C      N      34          1.617
LGA    V    26_C      I      35          1.282
LGA    L    27_C      I      36          0.385
LGA    E    28_C      N      37          1.988
LGA    Q    29_C      R      38          3.412
LGA    V    30_C      F      39          3.814
LGA    -       -      G      40           -
LGA    E    31_C      I      41          1.222
LGA    P    32_C      T      42          0.492
LGA    G    33_C      A      43          1.139
LGA    K    34_C      G      44          2.122
LGA    R    35_C      N      45          0.759
LGA    I    36_C      C      46          0.596
LGA    A    37_C      I      47          0.505
LGA    D    38_C      D      48          0.382
LGA    I    39_C      I      49          0.432
LGA    G    40_C      G      50          0.631
LGA    C    41_C      S      51          0.667
LGA    G    42_C      G      52          0.657
LGA    T    43_C      P      53          0.595
LGA    G    44_C      G      54          0.471
LGA    T    45_C      A      55          0.724
LGA    A    46_C      L      56          0.961
LGA    T    47_C      S      57          0.993
LGA    L    48_C      I      58          1.053
LGA    L    49_C      A      59          1.214
LGA    L    50_C      L      60          1.274
LGA    A    51_C      A      61          1.945
LGA    D    52_C      K      62          2.633
LGA    -       -      Q      63           -
LGA    H    53_C      S      64          1.225
LGA    Y    54_C      D      65          3.885
LGA    E    55_C      F      66          2.811
LGA    -       -      S      67           -
LGA    V    56_C      I      68          0.466
LGA    T    57_C      R      69          0.284
LGA    G    58_C      A      70          0.206
LGA    V    59_C      L      71          0.202
LGA    D    60_C      D      72          0.443
LGA    L    61_C      F      73          0.569
LGA    S    62_C      S      74          0.795
LGA    E    63_C      K      75          0.910
LGA    E    64_C      H      76          1.139
LGA    X    65_C      M      77          0.935
LGA    L    66_C      N      78          1.159
LGA    E    67_C      E      79          1.054
LGA    I    68_C      I      80          0.949
LGA    A    69_C      A      81          0.888
LGA    Q    70_C      L      82          0.868
LGA    E    71_C      K      83          0.776
LGA    K    72_C      N      84          1.128
LGA    A    73_C      I      85          0.989
LGA    X    74_C      A      86          0.791
LGA    E    75_C      D      87          1.074
LGA    T    76_C      A      88          1.420
LGA    N    77_C      D      89          1.215
LGA    R    78_C      L      90          0.602
LGA    H    79_C      N      91          2.601
LGA    -       -      D      92           -
LGA    -       -      R      93           -
LGA    V    80_C      I      94          1.147
LGA    D    81_C      Q      95          1.049
LGA    F    82_C      I      96          0.713
LGA    W    83_C      V      97          0.841
LGA    V    84_C      Q      98          1.090
LGA    Q    85_C      G      99          0.912
LGA    D    86_C      D     100          1.128
LGA    X    87_C      V     101          0.995
LGA    R    88_C      H     102          2.020
LGA    E    89_C      N     103          2.027
LGA    L    90_C      I     104          1.662
LGA    E    91_C      P     105          2.515
LGA    L    92_C      I     106          0.822
LGA    P    93_C      E     107          4.274
LGA    E    94_C      D     108           -
LGA    P    95_C      N     109          4.969
LGA    V    96_C      Y     110          3.177
LGA    D    97_C      A     111          3.067
LGA    -       -      D     112           -
LGA    A    98_C      L     113          1.551
LGA    I    99_C      I     114          1.048
LGA    T   100_C      V     115          0.850
LGA    I   101_C      S     116          1.254
LGA    L   102_C      R     117          1.543
LGA    C   103_C      G     118          3.463
LGA    D   104_C      -       -           -
LGA    S   105_C      S     119          1.590
LGA    L   106_C      V     120          0.634
LGA    N   107_C      F     121          0.541
LGA    Y   108_C      F     122          1.247
LGA    L   109_C      W     123          1.853
LGA    Q   110_C      E     124          4.272
LGA    T   111_C      -       -           -
LGA    E   112_C      -       -           -
LGA    A   113_C      -       -           -
LGA    D   114_C      D     125          1.432
LGA    V   115_C      V     126          1.380
LGA    K   116_C      T     127          1.187
LGA    Q   117_C      T     128          1.124
LGA    T   118_C      A     129          1.043
LGA    F   119_C      F     130          0.688
LGA    D   120_C      R     131          0.507
LGA    S   121_C      E     132          0.423
LGA    A   122_C      I     133          0.572
LGA    A   123_C      Y     134          0.781
LGA    R   124_C      R     135          0.930
LGA    L   125_C      I     136          0.870
LGA    L   126_C      L     137          1.435
LGA    T   127_C      K     138          2.780
LGA    D   128_C      S     139          1.907
LGA    G   129_C      G     140          1.516
LGA    G   130_C      G     141          1.577
LGA    K   131_C      K     142          1.218
LGA    L   132_C      T     143          1.649
LGA    L   133_C      Y     144          1.213
LGA    F   134_C      I     145          1.235
LGA    D   135_C      G     146          2.037
LGA    V   136_C      G     147          3.886
LGA    H   137_C      G     148           #
LGA    S   138_C      F     149           -
LGA    P   139_C      G     150           -
LGA    Y   140_C      N     151           -
LGA    K   141_C      K     152           -
LGA    X   142_C      E     153           -
LGA    E   143_C      L     154           -
LGA    T   144_C      R     155           -
LGA    -       -      D     156           -
LGA    -       -      S     157           -
LGA    -       -      I     158           -
LGA    L   145_C      S     159           #
LGA    F   146_C      A     160           -
LGA    N   147_C      E     161           -
LGA    G   148_C      M     162           -
LGA    K   149_C      I     163           #
LGA    T   150_C      -       -           -
LGA    Y   151_C      R     164          3.066
LGA    A   152_C      K     165          1.681
LGA    T   153_C      -       -           -
LGA    H   154_C      -       -           -
LGA    A   155_C      -       -           -
LGA    E   156_C      -       -           -
LGA    Q   157_C      -       -           -
LGA    S   158_C      -       -           -
LGA    S   159_C      -       -           -
LGA    Y   160_C      -       -           -
LGA    I   161_C      N     166          4.902
LGA    W   162_C      P     167          5.275
LGA    F   163_C      D     168          3.351
LGA    A   164_C      W     169          3.585
LGA    -       -      K     170           -
LGA    D   165_C      E     171          5.649
LGA    P   166_C      F     172           #
LGA    G   167_C      N     173           -
LGA    E   168_C      R     174           -
LGA    E   169_C      -       -           -
LGA    P   170_C      -       -           -
LGA    L   171_C      K     175          4.534
LGA    S   172_C      -       -           -
LGA    V   173_C      -       -           -
LGA    V   174_C      -       -           -
LGA    H   175_C      -       -           -
LGA    E   176_C      -       -           -
LGA    L   177_C      -       -           -
LGA    T   178_C      -       -           -
LGA    F   179_C      -       -           -
LGA    F   180_C      -       -           -
LGA    I   181_C      -       -           -
LGA    E   182_C      -       -           -
LGA    G   183_C      -       -           -
LGA    E   184_C      -       -           -
LGA    D   185_C      -       -           -
LGA    G   186_C      -       -           -
LGA    R   187_C      -       -           -
LGA    Y   188_C      -       -           -
LGA    D   189_C      -       -           -
LGA    R   190_C      -       -           -
LGA    V   191_C      -       -           -
LGA    D   192_C      -       -           -
LGA    E   193_C      -       -           -
LGA    T   194_C      -       -           -
LGA    H   195_C      -       -           -
LGA    H   196_C      -       -           -
LGA    Q   197_C      -       -           -
LGA    R   198_C      N     176          5.950
LGA    T   199_C      I     177           #
LGA    -       -      S     178           -
LGA    Y   200_C      Q     179          6.204
LGA    P   201_C      E     180          2.147
LGA    -       -      N     181           -
LGA    P   202_C      V     182          0.819
LGA    E   203_C      E     183          2.733
LGA    Q   204_C      R     184          2.716
LGA    Y   205_C      F     185          1.189
LGA    I   206_C      Q     186          1.948
LGA    T   207_C      N     187          2.884
LGA    W   208_C      V     188          1.755
LGA    L   209_C      L     189          1.970
LGA    R   210_C      D     190          3.406
LGA    E   211_C      E     191          3.112
LGA    A   212_C      I     192          2.793
LGA    G   213_C      G     193          4.214
LGA    F   214_C      V     194          3.110
LGA    -       -      S     195           -
LGA    R   215_C      S     196          1.020
LGA    V   216_C      Y     197          0.958
LGA    C   217_C      E     198          3.444
LGA    A   218_C      I     199           #
LGA    V   219_C      I     200          1.973
LGA    T   220_C      L     201          3.852
LGA    G   221_C      E     202          1.080
LGA    D   222_C      D     203          1.624
LGA    F   223_C      E     204          2.151
LGA    K   224_C      -       -           -
LGA    S   225_C      -       -           -
LGA    D   226_C      -       -           -
LGA    A   227_C      -       -           -
LGA    P   228_C      -       -           -
LGA    T   229_C      -       -           -
LGA    E   230_C      -       -           -
LGA    T   231_C      -       -           -
LGA    A   232_C      -       -           -
LGA    E   233_C      -       -           -
LGA    R   234_C      G     205          2.703
LGA    I   235_C      F     206          1.672
LGA    F   236_C      W     207          2.193
LGA    F   237_C      I     208          2.556
LGA    V   238_C      I     209          1.588
LGA    A   239_C      I     210          1.365
LGA    E   240_C      S     211          0.475
LGA    K   241_C      K     212          1.435
LGA    I   242_C      T     213          2.547
LGA    -       -      D     214           -
LGA    -       -      Q     215           -
LGA    -       -      E     216           -
LGA    -       -      V     217           -
LGA    -       -      I     218           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  242  218    5.0    167    2.19    20.36     59.992     7.297

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.461738 * X  +   0.811084 * Y  +   0.359084 * Z  + -48.838013
  Y_new =   0.878355 * X  +   0.361653 * Y  +   0.312570 * Z  + -47.443176
  Z_new =   0.123657 * X  +   0.459728 * Y  +  -0.879408 * Z  +  60.373978 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.659895   -0.481697  [ DEG:   152.4008    -27.5992 ]
  Theta =  -0.123974   -3.017618  [ DEG:    -7.1032   -172.8968 ]
  Phi   =   2.054781   -1.086812  [ DEG:   117.7303    -62.2697 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3d2l_C                                        
REMARK     2: T0485.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3d2l_C.T0485.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  242  218   5.0  167   2.19   20.36  59.992
REMARK  ---------------------------------------------------------- 
MOLECULE 3d2l_C
HEADER    TRANSFERASE                             08-MAY-08   3D2L              
TITLE     CRYSTAL STRUCTURE OF SAM-DEPENDENT METHYLTRANSFERASE                  
TITLE    2 (ZP_00538691.1) FROM EXIGUOBACTERIUM SP. 255-15 AT 1.90 A            
TITLE    3 RESOLUTION                                                           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SAM-DEPENDENT METHYLTRANSFERASE;                           
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: EXIGUOBACTERIUM SIBIRICUM 255-15;               
SOURCE   3 GENE: ZP_00538691.1, EXIGDRAFT_1659;                                 
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    ZP_00538691.1, SAM-DEPENDENT METHYLTRANSFERASE, STRUCTURAL            
KEYWDS   2 GENOMICS, JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG,                
KEYWDS   3 PROTEIN STRUCTURE INITIATIVE, PSI-2, METHYLTRANSFERASE               
KEYWDS   4 DOMAIN                                                               
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   20-MAY-08 3D2L    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF SAM-DEPENDENT                           
JRNL        TITL 2 METHYLTRANSFERASE (ZP_00538691.1) FROM                       
JRNL        TITL 3 EXIGUOBACTERIUM SP. 255-15 AT 1.90 A RESOLUTION              
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.90 ANGSTROMS.                                          
DBREF  3D2L A    1   242  UNP    Q41FK2   Q41FK2_9BACI     1    242             
DBREF  3D2L B    1   242  UNP    Q41FK2   Q41FK2_9BACI     1    242             
DBREF  3D2L C    1   242  UNP    Q41FK2   Q41FK2_9BACI     1    242             
DBREF  3D2L D    1   242  UNP    Q41FK2   Q41FK2_9BACI     1    242             
SEQRES   1 A  243  GLY MSE ALA TYR GLU GLN PHE ALA TYR VAL TYR ASP GLU          
SEQRES   2 A  243  LEU MSE GLN ASP VAL PRO TYR PRO GLU TRP VAL ALA TRP          
SEQRES   3 A  243  VAL LEU GLU GLN VAL GLU PRO GLY LYS ARG ILE ALA ASP          
SEQRES   4 A  243  ILE GLY CYS GLY THR GLY THR ALA THR LEU LEU LEU ALA          
SEQRES   5 A  243  ASP HIS TYR GLU VAL THR GLY VAL ASP LEU SER GLU GLU          
SEQRES   6 A  243  MSE LEU GLU ILE ALA GLN GLU LYS ALA MSE GLU THR ASN          
SEQRES   7 A  243  ARG HIS VAL ASP PHE TRP VAL GLN ASP MSE ARG GLU LEU          
SEQRES   8 A  243  GLU LEU PRO GLU PRO VAL ASP ALA ILE THR ILE LEU CYS          
SEQRES   9 A  243  ASP SER LEU ASN TYR LEU GLN THR GLU ALA ASP VAL LYS          
SEQRES  10 A  243  GLN THR PHE ASP SER ALA ALA ARG LEU LEU THR ASP GLY          
SEQRES  11 A  243  GLY LYS LEU LEU PHE ASP VAL HIS SER PRO TYR LYS MSE          
SEQRES  12 A  243  GLU THR LEU PHE ASN GLY LYS THR TYR ALA THR HIS ALA          
SEQRES  13 A  243  GLU GLN SER SER TYR ILE TRP PHE ALA ASP PRO GLY GLU          
SEQRES  14 A  243  GLU PRO LEU SER VAL VAL HIS GLU LEU THR PHE PHE ILE          
SEQRES  15 A  243  GLU GLY GLU ASP GLY ARG TYR ASP ARG VAL ASP GLU THR          
SEQRES  16 A  243  HIS HIS GLN ARG THR TYR PRO PRO GLU GLN TYR ILE THR          
SEQRES  17 A  243  TRP LEU ARG GLU ALA GLY PHE ARG VAL CYS ALA VAL THR          
SEQRES  18 A  243  GLY ASP PHE LYS SER ASP ALA PRO THR GLU THR ALA GLU          
SEQRES  19 A  243  ARG ILE PHE PHE VAL ALA GLU LYS ILE                          
SEQRES   1 B  243  GLY MSE ALA TYR GLU GLN PHE ALA TYR VAL TYR ASP GLU          
SEQRES   2 B  243  LEU MSE GLN ASP VAL PRO TYR PRO GLU TRP VAL ALA TRP          
SEQRES   3 B  243  VAL LEU GLU GLN VAL GLU PRO GLY LYS ARG ILE ALA ASP          
SEQRES   4 B  243  ILE GLY CYS GLY THR GLY THR ALA THR LEU LEU LEU ALA          
SEQRES   5 B  243  ASP HIS TYR GLU VAL THR GLY VAL ASP LEU SER GLU GLU          
SEQRES   6 B  243  MSE LEU GLU ILE ALA GLN GLU LYS ALA MSE GLU THR ASN          
SEQRES   7 B  243  ARG HIS VAL ASP PHE TRP VAL GLN ASP MSE ARG GLU LEU          
SEQRES   8 B  243  GLU LEU PRO GLU PRO VAL ASP ALA ILE THR ILE LEU CYS          
SEQRES   9 B  243  ASP SER LEU ASN TYR LEU GLN THR GLU ALA ASP VAL LYS          
SEQRES  10 B  243  GLN THR PHE ASP SER ALA ALA ARG LEU LEU THR ASP GLY          
SEQRES  11 B  243  GLY LYS LEU LEU PHE ASP VAL HIS SER PRO TYR LYS MSE          
SEQRES  12 B  243  GLU THR LEU PHE ASN GLY LYS THR TYR ALA THR HIS ALA          
SEQRES  13 B  243  GLU GLN SER SER TYR ILE TRP PHE ALA ASP PRO GLY GLU          
SEQRES  14 B  243  GLU PRO LEU SER VAL VAL HIS GLU LEU THR PHE PHE ILE          
SEQRES  15 B  243  GLU GLY GLU ASP GLY ARG TYR ASP ARG VAL ASP GLU THR          
SEQRES  16 B  243  HIS HIS GLN ARG THR TYR PRO PRO GLU GLN TYR ILE THR          
SEQRES  17 B  243  TRP LEU ARG GLU ALA GLY PHE ARG VAL CYS ALA VAL THR          
SEQRES  18 B  243  GLY ASP PHE LYS SER ASP ALA PRO THR GLU THR ALA GLU          
SEQRES  19 B  243  ARG ILE PHE PHE VAL ALA GLU LYS ILE                          
SEQRES   1 C  243  GLY MSE ALA TYR GLU GLN PHE ALA TYR VAL TYR ASP GLU          
SEQRES   2 C  243  LEU MSE GLN ASP VAL PRO TYR PRO GLU TRP VAL ALA TRP          
SEQRES   3 C  243  VAL LEU GLU GLN VAL GLU PRO GLY LYS ARG ILE ALA ASP          
SEQRES   4 C  243  ILE GLY CYS GLY THR GLY THR ALA THR LEU LEU LEU ALA          
SEQRES   5 C  243  ASP HIS TYR GLU VAL THR GLY VAL ASP LEU SER GLU GLU          
SEQRES   6 C  243  MSE LEU GLU ILE ALA GLN GLU LYS ALA MSE GLU THR ASN          
SEQRES   7 C  243  ARG HIS VAL ASP PHE TRP VAL GLN ASP MSE ARG GLU LEU          
SEQRES   8 C  243  GLU LEU PRO GLU PRO VAL ASP ALA ILE THR ILE LEU CYS          
SEQRES   9 C  243  ASP SER LEU ASN TYR LEU GLN THR GLU ALA ASP VAL LYS          
SEQRES  10 C  243  GLN THR PHE ASP SER ALA ALA ARG LEU LEU THR ASP GLY          
SEQRES  11 C  243  GLY LYS LEU LEU PHE ASP VAL HIS SER PRO TYR LYS MSE          
SEQRES  12 C  243  GLU THR LEU PHE ASN GLY LYS THR TYR ALA THR HIS ALA          
SEQRES  13 C  243  GLU GLN SER SER TYR ILE TRP PHE ALA ASP PRO GLY GLU          
SEQRES  14 C  243  GLU PRO LEU SER VAL VAL HIS GLU LEU THR PHE PHE ILE          
SEQRES  15 C  243  GLU GLY GLU ASP GLY ARG TYR ASP ARG VAL ASP GLU THR          
SEQRES  16 C  243  HIS HIS GLN ARG THR TYR PRO PRO GLU GLN TYR ILE THR          
SEQRES  17 C  243  TRP LEU ARG GLU ALA GLY PHE ARG VAL CYS ALA VAL THR          
SEQRES  18 C  243  GLY ASP PHE LYS SER ASP ALA PRO THR GLU THR ALA GLU          
SEQRES  19 C  243  ARG ILE PHE PHE VAL ALA GLU LYS ILE                          
SEQRES   1 D  243  GLY MSE ALA TYR GLU GLN PHE ALA TYR VAL TYR ASP GLU          
SEQRES   2 D  243  LEU MSE GLN ASP VAL PRO TYR PRO GLU TRP VAL ALA TRP          
SEQRES   3 D  243  VAL LEU GLU GLN VAL GLU PRO GLY LYS ARG ILE ALA ASP          
SEQRES   4 D  243  ILE GLY CYS GLY THR GLY THR ALA THR LEU LEU LEU ALA          
SEQRES   5 D  243  ASP HIS TYR GLU VAL THR GLY VAL ASP LEU SER GLU GLU          
SEQRES   6 D  243  MSE LEU GLU ILE ALA GLN GLU LYS ALA MSE GLU THR ASN          
SEQRES   7 D  243  ARG HIS VAL ASP PHE TRP VAL GLN ASP MSE ARG GLU LEU          
SEQRES   8 D  243  GLU LEU PRO GLU PRO VAL ASP ALA ILE THR ILE LEU CYS          
SEQRES   9 D  243  ASP SER LEU ASN TYR LEU GLN THR GLU ALA ASP VAL LYS          
SEQRES  10 D  243  GLN THR PHE ASP SER ALA ALA ARG LEU LEU THR ASP GLY          
SEQRES  11 D  243  GLY LYS LEU LEU PHE ASP VAL HIS SER PRO TYR LYS MSE          
SEQRES  12 D  243  GLU THR LEU PHE ASN GLY LYS THR TYR ALA THR HIS ALA          
SEQRES  13 D  243  GLU GLN SER SER TYR ILE TRP PHE ALA ASP PRO GLY GLU          
SEQRES  14 D  243  GLU PRO LEU SER VAL VAL HIS GLU LEU THR PHE PHE ILE          
SEQRES  15 D  243  GLU GLY GLU ASP GLY ARG TYR ASP ARG VAL ASP GLU THR          
SEQRES  16 D  243  HIS HIS GLN ARG THR TYR PRO PRO GLU GLN TYR ILE THR          
SEQRES  17 D  243  TRP LEU ARG GLU ALA GLY PHE ARG VAL CYS ALA VAL THR          
SEQRES  18 D  243  GLY ASP PHE LYS SER ASP ALA PRO THR GLU THR ALA GLU          
SEQRES  19 D  243  ARG ILE PHE PHE VAL ALA GLU LYS ILE                          
HET    MSE  A  14      13                                                       
HET    MSE  A  65       8                                                       
HET    MSE  A  74       8                                                       
HET    MSE  A  87       8                                                       
HET    MSE  A 142      13                                                       
HET    MSE  B  14      13                                                       
HET    MSE  B  65       8                                                       
HET    MSE  B  74       8                                                       
HET    MSE  B  87       8                                                       
HET    MSE  B 142      13                                                       
HET    MSE  C   1       8                                                       
HET    MSE  C  14      13                                                       
HET    MSE  C  65       8                                                       
HET    MSE  C  74       8                                                       
HET    MSE  C  87       8                                                       
HET    MSE  C 142      13                                                       
HET    MSE  D  14       8                                                       
HET    MSE  D  65      13                                                       
HET    MSE  D  74       8                                                       
HET    MSE  D  87       8                                                       
HET    MSE  D 142      13                                                       
HET     MG  A 243       1                                                       
HET     MG  B 243       1                                                       
HET     MG  B 244       1                                                       
HET     MG  C 243       1                                                       
HET     MG  D 243       1                                                       
HET     MG  D 244       1                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      MG MAGNESIUM ION                                                    
FORMUL   1  MSE    21(C5 H11 N O2 SE)                                           
FORMUL   5   MG    6(MG 2+)                                                     
FORMUL  11  HOH   *516(H2 O)                                                    
CRYST1   67.830   70.920   77.190 116.57 104.63 102.32 P 1           4          
HETATM 3869  N   MSE C   1      -9.150   1.347  35.486  1.00 42.44           N  
HETATM 3870  CA  MSE C   1      -8.008   0.378  35.474  1.00 42.77           C  
HETATM 3871  C   MSE C   1      -6.654   1.078  35.259  1.00 41.85           C  
HETATM 3872  O   MSE C   1      -6.587   2.137  34.622  1.00 39.82           O  
HETATM 3873  CB  MSE C   1      -8.208  -0.715  34.401  1.00 42.79           C  
HETATM 3874  CG  MSE C   1      -9.388  -1.694  34.644  1.00 46.05           C  
HETATM 3875 SE   MSE C   1      -9.438  -2.629  36.432  0.75 51.30          SE  
HETATM 3876  CE  MSE C   1      -7.400  -2.526  36.787  1.00 60.08           C  
ATOM   3877  N   ALA C   2      -5.585   0.459  35.770  1.00 41.42           N  
ATOM   3878  CA  ALA C   2      -4.217   1.003  35.659  1.00 41.84           C  
ATOM   3879  C   ALA C   2      -3.774   1.266  34.223  1.00 41.19           C  
ATOM   3880  O   ALA C   2      -3.124   2.274  33.979  1.00 37.59           O  
ATOM   3881  CB  ALA C   2      -3.204   0.093  36.362  1.00 42.89           C  
ATOM   3882  N   TYR C   3      -4.116   0.391  33.270  1.00 41.36           N  
ATOM   3883  CA  TYR C   3      -3.714   0.620  31.852  1.00 42.64           C  
ATOM   3884  C   TYR C   3      -4.607   1.688  31.208  1.00 44.99           C  
ATOM   3885  O   TYR C   3      -4.156   2.440  30.340  1.00 42.34           O  
ATOM   3886  CB  TYR C   3      -3.763  -0.670  31.007  1.00 41.51           C  
ATOM   3887  CG  TYR C   3      -5.155  -1.072  30.517  1.00 40.34           C  
ATOM   3888  CD1 TYR C   3      -6.017  -1.846  31.307  1.00 28.83           C  
ATOM   3889  CD2 TYR C   3      -5.603  -0.676  29.245  1.00 44.00           C  
ATOM   3890  CE1 TYR C   3      -7.297  -2.190  30.847  1.00 36.08           C  
ATOM   3891  CE2 TYR C   3      -6.885  -1.031  28.784  1.00 39.25           C  
ATOM   3892  CZ  TYR C   3      -7.708  -1.791  29.571  1.00 34.33           C  
ATOM   3893  OH  TYR C   3      -8.943  -2.116  29.063  1.00 33.43           O  
ATOM   3894  N   GLU C   4      -5.874   1.724  31.638  1.00 47.81           N  
ATOM   3895  CA  GLU C   4      -6.857   2.681  31.142  1.00 52.28           C  
ATOM   3896  C   GLU C   4      -6.601   3.999  31.844  1.00 57.37           C  
ATOM   3897  O   GLU C   4      -6.021   4.013  32.938  1.00 58.77           O  
ATOM   3898  CB  GLU C   4      -8.286   2.201  31.441  1.00 51.57           C  
ATOM   3899  N   GLN C   5      -6.986   5.115  31.223  1.00 59.88           N  
ATOM   3900  CA  GLN C   5      -6.835   6.419  31.863  1.00 61.12           C  
ATOM   3901  C   GLN C   5      -5.341   6.670  32.081  1.00 60.89           C  
ATOM   3902  O   GLN C   5      -4.884   7.817  32.046  1.00 61.64           O  
ATOM   3903  CB  GLN C   5      -7.650   6.487  33.178  1.00 61.60           C  
ATOM   3904  N   PHE C   6      -4.600   5.588  32.341  1.00 59.34           N  
ATOM   3905  CA  PHE C   6      -3.147   5.614  32.381  1.00 56.69           C  
ATOM   3906  C   PHE C   6      -2.676   5.989  30.990  1.00 54.28           C  
ATOM   3907  O   PHE C   6      -1.682   6.699  30.832  1.00 53.47           O  
ATOM   3908  CB  PHE C   6      -2.588   4.234  32.707  1.00 56.54           C  
ATOM   3909  CG  PHE C   6      -1.142   4.082  32.373  1.00 55.06           C  
ATOM   3910  CD1 PHE C   6      -0.184   4.167  33.357  1.00 58.54           C  
ATOM   3911  CD2 PHE C   6      -0.731   3.905  31.057  1.00 56.15           C  
ATOM   3912  CE1 PHE C   6       1.152   4.064  33.039  1.00 59.50           C  
ATOM   3913  CE2 PHE C   6       0.602   3.814  30.731  1.00 55.27           C  
ATOM   3914  CZ  PHE C   6       1.546   3.889  31.723  1.00 59.27           C  
ATOM   3915  N   ALA C   7      -3.361   5.455  29.978  1.00 50.84           N  
ATOM   3916  CA  ALA C   7      -3.031   5.784  28.603  1.00 50.53           C  
ATOM   3917  C   ALA C   7      -3.252   7.285  28.419  1.00 48.96           C  
ATOM   3918  O   ALA C   7      -2.515   7.933  27.704  1.00 46.17           O  
ATOM   3919  CB  ALA C   7      -3.884   4.978  27.625  1.00 49.34           C  
ATOM   3920  N   TYR C   8      -4.255   7.846  29.090  1.00 50.49           N  
ATOM   3921  CA  TYR C   8      -4.516   9.268  28.910  1.00 52.83           C  
ATOM   3922  C   TYR C   8      -3.379  10.078  29.478  1.00 52.59           C  
ATOM   3923  O   TYR C   8      -2.953  11.039  28.852  1.00 54.92           O  
ATOM   3924  CB  TYR C   8      -5.863   9.737  29.490  1.00 53.76           C  
ATOM   3925  CG  TYR C   8      -6.652  10.494  28.427  1.00 57.56           C  
ATOM   3926  CD1 TYR C   8      -6.067  11.551  27.683  1.00 52.95           C  
ATOM   3927  CD2 TYR C   8      -7.964  10.127  28.124  1.00 56.95           C  
ATOM   3928  CE1 TYR C   8      -6.789  12.213  26.674  1.00 53.96           C  
ATOM   3929  CE2 TYR C   8      -8.692  10.786  27.125  1.00 57.95           C  
ATOM   3930  CZ  TYR C   8      -8.113  11.825  26.409  1.00 57.39           C  
ATOM   3931  OH  TYR C   8      -8.875  12.457  25.444  1.00 59.25           O  
ATOM   3932  N   VAL C   9      -2.836   9.674  30.624  1.00 52.66           N  
ATOM   3933  CA  VAL C   9      -1.731  10.436  31.207  1.00 52.75           C  
ATOM   3934  C   VAL C   9      -0.583  10.482  30.224  1.00 51.34           C  
ATOM   3935  O   VAL C   9       0.018  11.522  30.060  1.00 50.57           O  
ATOM   3936  CB  VAL C   9      -1.243   9.937  32.613  1.00 52.96           C  
ATOM   3937  CG1 VAL C   9      -2.442   9.788  33.582  1.00 51.65           C  
ATOM   3938  CG2 VAL C   9      -0.385   8.656  32.504  1.00 52.79           C  
ATOM   3939  N   TYR C  10      -0.309   9.380  29.538  1.00 51.15           N  
ATOM   3940  CA  TYR C  10       0.785   9.322  28.566  1.00 49.90           C  
ATOM   3941  C   TYR C  10       0.816  10.469  27.518  1.00 49.91           C  
ATOM   3942  O   TYR C  10       1.896  10.834  27.011  1.00 48.59           O  
ATOM   3943  CB  TYR C  10       0.797   7.969  27.879  1.00 53.51           C  
ATOM   3944  CG  TYR C  10       1.982   7.806  26.992  1.00 51.81           C  
ATOM   3945  CD1 TYR C  10       3.237   7.533  27.538  1.00 61.71           C  
ATOM   3946  CD2 TYR C  10       1.874   7.957  25.613  1.00 59.58           C  
ATOM   3947  CE1 TYR C  10       4.374   7.403  26.728  1.00 59.28           C  
ATOM   3948  CE2 TYR C  10       3.010   7.824  24.776  1.00 61.62           C  
ATOM   3949  CZ  TYR C  10       4.256   7.540  25.346  1.00 61.61           C  
ATOM   3950  OH  TYR C  10       5.384   7.421  24.558  1.00 55.37           O  
ATOM   3951  N   ASP C  11      -0.343  11.024  27.172  1.00 48.71           N  
ATOM   3952  CA  ASP C  11      -0.375  12.242  26.328  1.00 48.46           C  
ATOM   3953  C   ASP C  11       0.321  13.431  27.062  1.00 48.50           C  
ATOM   3954  O   ASP C  11       0.908  14.328  26.442  1.00 49.52           O  
ATOM   3955  CB  ASP C  11      -1.816  12.590  25.938  1.00 47.08           C  
ATOM   3956  CG  ASP C  11      -2.414  11.583  24.932  1.00 48.11           C  
ATOM   3957  OD1 ASP C  11      -1.672  10.683  24.493  1.00 50.38           O  
ATOM   3958  OD2 ASP C  11      -3.610  11.688  24.565  1.00 38.00           O  
ATOM   3959  N   GLU C  12       0.274  13.388  28.387  1.00 47.59           N  
ATOM   3960  CA  GLU C  12       0.897  14.367  29.268  1.00 48.17           C  
ATOM   3961  C   GLU C  12       2.433  14.309  29.094  1.00 47.92           C  
ATOM   3962  O   GLU C  12       3.063  15.338  28.901  1.00 48.00           O  
ATOM   3963  CB  GLU C  12       0.444  14.092  30.736  1.00 48.84           C  
ATOM   3964  CG  GLU C  12       0.030  15.315  31.534  1.00 52.69           C  
ATOM   3965  CD  GLU C  12      -0.874  14.972  32.737  1.00 50.26           C  
ATOM   3966  OE1 GLU C  12      -0.837  13.824  33.217  1.00 51.57           O  
ATOM   3967  OE2 GLU C  12      -1.625  15.856  33.210  1.00 47.71           O  
ATOM   3968  N   LEU C  13       3.040  13.120  29.116  1.00 46.37           N  
ATOM   3969  CA  LEU C  13       4.498  13.013  28.921  1.00 47.81           C  
ATOM   3970  C   LEU C  13       4.925  13.557  27.539  1.00 50.57           C  
ATOM   3971  O   LEU C  13       6.075  14.028  27.345  1.00 50.22           O  
ATOM   3972  CB  LEU C  13       4.955  11.549  29.078  1.00 45.84           C  
ATOM   3973  CG  LEU C  13       6.451  11.204  28.841  1.00 48.39           C  
ATOM   3974  CD1 LEU C  13       6.889   9.891  29.495  1.00 46.41           C  
ATOM   3975  CD2 LEU C  13       6.818  11.163  27.353  1.00 41.35           C  
HETATM 3976  N   MSE C  14       3.971  13.512  26.602  1.00 51.48           N  
HETATM 3977  CA  MSE C  14       4.257  13.945  25.231  0.50 49.89           C  
HETATM 3979  C   MSE C  14       3.624  15.296  24.900  1.00 50.30           C  
HETATM 3980  O   MSE C  14       3.773  15.787  23.784  1.00 48.16           O  
HETATM 3981  CB  MSE C  14       3.823  12.869  24.223  0.50 49.91           C  
HETATM 3983  CG  MSE C  14       4.598  11.554  24.330  0.50 42.29           C  
HETATM 3985 SE   MSE C  14       6.434  11.575  23.593  0.38 40.02          SE  
HETATM 3987  CE  MSE C  14       6.010  11.667  21.616  0.50 35.62           C  
ATOM   3989  N   GLN C  15       2.984  15.922  25.884  1.00 50.32           N  
ATOM   3990  CA  GLN C  15       2.312  17.226  25.689  1.00 51.24           C  
ATOM   3991  C   GLN C  15       3.079  18.308  24.916  1.00 50.62           C  
ATOM   3992  O   GLN C  15       2.465  19.088  24.181  1.00 49.70           O  
ATOM   3993  CB  GLN C  15       1.767  17.775  27.015  1.00 51.99           C  
ATOM   3994  CG  GLN C  15       2.771  18.396  27.970  1.00 54.69           C  
ATOM   3995  CD  GLN C  15       2.090  18.830  29.255  1.00 53.52           C  
ATOM   3996  OE1 GLN C  15       1.356  18.055  29.876  1.00 60.10           O  
ATOM   3997  NE2 GLN C  15       2.327  20.073  29.661  1.00 62.81           N  
ATOM   3998  N   ASP C  16       4.399  18.343  25.050  1.00 49.46           N  
ATOM   3999  CA  ASP C  16       5.192  19.351  24.326  1.00 50.36           C  
ATOM   4000  C   ASP C  16       5.781  18.872  23.004  1.00 47.26           C  
ATOM   4001  O   ASP C  16       6.576  19.599  22.394  1.00 48.33           O  
ATOM   4002  CB  ASP C  16       6.304  19.916  25.226  1.00 52.45           C  
ATOM   4003  CG  ASP C  16       5.761  20.499  26.520  1.00 57.11           C  
ATOM   4004  OD1 ASP C  16       4.650  21.080  26.502  1.00 65.56           O  
ATOM   4005  OD2 ASP C  16       6.441  20.357  27.556  1.00 64.94           O  
ATOM   4006  N   VAL C  17       5.376  17.687  22.538  1.00 43.80           N  
ATOM   4007  CA  VAL C  17       5.877  17.156  21.258  1.00 42.45           C  
ATOM   4008  C   VAL C  17       5.227  17.909  20.076  1.00 41.08           C  
ATOM   4009  O   VAL C  17       3.999  17.982  19.999  1.00 39.87           O  
ATOM   4010  CB  VAL C  17       5.659  15.626  21.148  1.00 42.15           C  
ATOM   4011  CG1 VAL C  17       6.242  15.085  19.859  1.00 38.13           C  
ATOM   4012  CG2 VAL C  17       6.316  14.931  22.329  1.00 45.14           C  
ATOM   4013  N   PRO C  18       6.055  18.496  19.179  1.00 40.45           N  
ATOM   4014  CA  PRO C  18       5.575  19.285  18.043  1.00 38.62           C  
ATOM   4015  C   PRO C  18       5.138  18.449  16.835  1.00 35.46           C  
ATOM   4016  O   PRO C  18       5.779  18.448  15.777  1.00 34.30           O  
ATOM   4017  CB  PRO C  18       6.782  20.144  17.711  1.00 38.22           C  
ATOM   4018  CG  PRO C  18       7.929  19.280  18.018  1.00 37.29           C  
ATOM   4019  CD  PRO C  18       7.532  18.471  19.211  1.00 39.89           C  
ATOM   4020  N   TYR C  19       4.017  17.769  17.009  1.00 32.93           N  
ATOM   4021  CA  TYR C  19       3.431  16.940  15.966  1.00 33.25           C  
ATOM   4022  C   TYR C  19       3.215  17.642  14.615  1.00 32.75           C  
ATOM   4023  O   TYR C  19       3.340  16.997  13.576  1.00 33.64           O  
ATOM   4024  CB  TYR C  19       2.136  16.330  16.463  1.00 32.81           C  
ATOM   4025  CG  TYR C  19       2.354  15.345  17.594  1.00 34.64           C  
ATOM   4026  CD1 TYR C  19       2.909  14.093  17.352  1.00 36.28           C  
ATOM   4027  CD2 TYR C  19       1.997  15.657  18.898  1.00 33.85           C  
ATOM   4028  CE1 TYR C  19       3.097  13.173  18.392  1.00 38.79           C  
ATOM   4029  CE2 TYR C  19       2.177  14.749  19.929  1.00 40.63           C  
ATOM   4030  CZ  TYR C  19       2.731  13.515  19.670  1.00 34.71           C  
ATOM   4031  OH  TYR C  19       2.906  12.627  20.684  1.00 37.87           O  
ATOM   4032  N   PRO C  20       2.853  18.945  14.619  1.00 30.58           N  
ATOM   4033  CA  PRO C  20       2.730  19.639  13.355  1.00 31.59           C  
ATOM   4034  C   PRO C  20       3.955  19.526  12.469  1.00 30.63           C  
ATOM   4035  O   PRO C  20       3.828  19.507  11.248  1.00 31.92           O  
ATOM   4036  CB  PRO C  20       2.486  21.100  13.794  1.00 31.34           C  
ATOM   4037  CG  PRO C  20       1.711  20.952  15.056  1.00 31.67           C  
ATOM   4038  CD  PRO C  20       2.458  19.821  15.742  1.00 32.24           C  
ATOM   4039  N   GLU C  21       5.142  19.458  13.060  1.00 33.90           N  
ATOM   4040  CA  GLU C  21       6.374  19.322  12.272  1.00 33.90           C  
ATOM   4041  C   GLU C  21       6.370  18.010  11.481  1.00 31.91           C  
ATOM   4042  O   GLU C  21       6.873  17.939  10.361  1.00 28.21           O  
ATOM   4043  CB  GLU C  21       7.618  19.437  13.173  1.00 36.28           C  
ATOM   4044  CG  GLU C  21       7.723  20.802  13.844  1.00 38.49           C  
ATOM   4045  CD  GLU C  21       8.891  20.955  14.845  1.00 43.02           C  
ATOM   4046  OE1 GLU C  21       9.818  20.112  14.878  1.00 54.27           O  
ATOM   4047  OE2 GLU C  21       8.871  21.956  15.608  1.00 55.45           O  
ATOM   4048  N   TRP C  22       5.808  16.951  12.058  1.00 30.77           N  
ATOM   4049  CA  TRP C  22       5.710  15.696  11.324  1.00 31.41           C  
ATOM   4050  C   TRP C  22       4.653  15.791  10.245  1.00 31.70           C  
ATOM   4051  O   TRP C  22       4.805  15.222   9.165  1.00 31.85           O  
ATOM   4052  CB  TRP C  22       5.313  14.558  12.235  1.00 31.56           C  
ATOM   4053  CG  TRP C  22       6.408  13.945  12.990  1.00 33.81           C  
ATOM   4054  CD1 TRP C  22       7.058  12.804  12.672  1.00 35.12           C  
ATOM   4055  CD2 TRP C  22       6.939  14.380  14.248  1.00 34.21           C  
ATOM   4056  NE1 TRP C  22       7.979  12.512  13.631  1.00 28.08           N  
ATOM   4057  CE2 TRP C  22       7.923  13.458  14.617  1.00 28.13           C  
ATOM   4058  CE3 TRP C  22       6.671  15.455  15.095  1.00 34.28           C  
ATOM   4059  CZ2 TRP C  22       8.667  13.584  15.790  1.00 34.00           C  
ATOM   4060  CZ3 TRP C  22       7.396  15.570  16.271  1.00 36.34           C  
ATOM   4061  CH2 TRP C  22       8.382  14.647  16.605  1.00 34.92           C  
ATOM   4062  N   VAL C  23       3.570  16.495  10.556  1.00 31.73           N  
ATOM   4063  CA  VAL C  23       2.482  16.661   9.616  1.00 30.11           C  
ATOM   4064  C   VAL C  23       2.935  17.516   8.439  1.00 30.01           C  
ATOM   4065  O   VAL C  23       2.507  17.262   7.306  1.00 29.52           O  
ATOM   4066  CB  VAL C  23       1.218  17.231  10.309  1.00 30.27           C  
ATOM   4067  CG1 VAL C  23       0.118  17.496   9.292  1.00 26.34           C  
ATOM   4068  CG2 VAL C  23       0.729  16.218  11.386  1.00 25.04           C  
ATOM   4069  N   ALA C  24       3.798  18.507   8.682  1.00 31.47           N  
ATOM   4070  CA  ALA C  24       4.301  19.360   7.594  1.00 30.82           C  
ATOM   4071  C   ALA C  24       5.142  18.538   6.630  1.00 31.68           C  
ATOM   4072  O   ALA C  24       5.054  18.722   5.426  1.00 33.19           O  
ATOM   4073  CB  ALA C  24       5.078  20.591   8.115  1.00 29.44           C  
ATOM   4074  N   TRP C  25       5.946  17.625   7.153  1.00 32.43           N  
ATOM   4075  CA  TRP C  25       6.752  16.720   6.318  1.00 31.21           C  
ATOM   4076  C   TRP C  25       5.870  15.816   5.439  1.00 31.48           C  
ATOM   4077  O   TRP C  25       6.134  15.660   4.248  1.00 28.41           O  
ATOM   4078  CB  TRP C  25       7.656  15.877   7.224  1.00 33.12           C  
ATOM   4079  CG  TRP C  25       8.394  14.757   6.547  1.00 32.66           C  
ATOM   4080  CD1 TRP C  25       9.267  14.847   5.510  1.00 33.59           C  
ATOM   4081  CD2 TRP C  25       8.359  13.382   6.924  1.00 27.38           C  
ATOM   4082  NE1 TRP C  25       9.757  13.602   5.198  1.00 30.93           N  
ATOM   4083  CE2 TRP C  25       9.221  12.687   6.055  1.00 27.27           C  
ATOM   4084  CE3 TRP C  25       7.655  12.665   7.903  1.00 31.99           C  
ATOM   4085  CZ2 TRP C  25       9.416  11.308   6.132  1.00 28.93           C  
ATOM   4086  CZ3 TRP C  25       7.860  11.294   7.985  1.00 32.77           C  
ATOM   4087  CH2 TRP C  25       8.739  10.637   7.096  1.00 29.37           C  
ATOM   4088  N   VAL C  26       4.812  15.222   6.008  1.00 30.58           N  
ATOM   4089  CA  VAL C  26       3.912  14.393   5.192  1.00 29.95           C  
ATOM   4090  C   VAL C  26       3.316  15.245   4.063  1.00 31.14           C  
ATOM   4091  O   VAL C  26       3.274  14.815   2.898  1.00 31.95           O  
ATOM   4092  CB  VAL C  26       2.797  13.732   6.012  1.00 30.89           C  
ATOM   4093  CG1 VAL C  26       1.863  12.971   5.090  1.00 27.25           C  
ATOM   4094  CG2 VAL C  26       3.404  12.787   7.034  1.00 28.58           C  
ATOM   4095  N   LEU C  27       2.914  16.468   4.416  1.00 30.70           N  
ATOM   4096  CA  LEU C  27       2.324  17.429   3.464  1.00 30.51           C  
ATOM   4097  C   LEU C  27       3.234  17.758   2.260  1.00 32.93           C  
ATOM   4098  O   LEU C  27       2.748  18.150   1.177  1.00 31.08           O  
ATOM   4099  CB  LEU C  27       1.899  18.703   4.207  1.00 30.75           C  
ATOM   4100  CG  LEU C  27       0.596  18.630   5.019  1.00 30.70           C  
ATOM   4101  CD1 LEU C  27       0.440  19.844   5.924  1.00 35.87           C  
ATOM   4102  CD2 LEU C  27      -0.605  18.509   4.087  1.00 30.41           C  
ATOM   4103  N   GLU C  28       4.539  17.582   2.438  1.00 34.08           N  
ATOM   4104  CA  GLU C  28       5.503  17.839   1.372  1.00 37.04           C  
ATOM   4105  C   GLU C  28       5.653  16.637   0.462  1.00 35.46           C  
ATOM   4106  O   GLU C  28       6.119  16.780  -0.650  1.00 35.44           O  
ATOM   4107  CB  GLU C  28       6.872  18.152   1.961  1.00 36.75           C  
ATOM   4108  CG  GLU C  28       6.899  19.326   2.921  1.00 43.96           C  
ATOM   4109  CD  GLU C  28       8.277  19.564   3.570  1.00 46.39           C  
ATOM   4110  OE1 GLU C  28       9.124  18.626   3.616  1.00 58.44           O  
ATOM   4111  OE2 GLU C  28       8.493  20.697   4.062  1.00 58.39           O  
ATOM   4112  N   GLN C  29       5.280  15.452   0.949  1.00 34.69           N  
ATOM   4113  CA  GLN C  29       5.424  14.196   0.212  1.00 34.24           C  
ATOM   4114  C   GLN C  29       4.124  13.600  -0.301  1.00 35.08           C  
ATOM   4115  O   GLN C  29       4.150  12.836  -1.261  1.00 36.26           O  
ATOM   4116  CB  GLN C  29       6.063  13.132   1.120  1.00 35.17           C  
ATOM   4117  CG  GLN C  29       7.334  13.571   1.861  1.00 38.51           C  
ATOM   4118  CD  GLN C  29       8.441  14.064   0.945  1.00 41.88           C  
ATOM   4119  OE1 GLN C  29       8.619  13.561  -0.170  1.00 34.57           O  
ATOM   4120  NE2 GLN C  29       9.202  15.057   1.418  1.00 43.76           N  
ATOM   4121  N   VAL C  30       2.995  13.903   0.342  1.00 34.73           N  
ATOM   4122  CA  VAL C  30       1.712  13.325  -0.064  1.00 35.34           C  
ATOM   4123  C   VAL C  30       0.672  14.415  -0.305  1.00 35.17           C  
ATOM   4124  O   VAL C  30       0.392  15.212   0.579  1.00 35.00           O  
ATOM   4125  CB  VAL C  30       1.199  12.295   0.983  1.00 36.07           C  
ATOM   4126  CG1 VAL C  30      -0.085  11.601   0.499  1.00 36.44           C  
ATOM   4127  CG2 VAL C  30       2.253  11.257   1.265  1.00 32.75           C  
ATOM   4128  N   GLU C  31       0.105  14.426  -1.514  1.00 34.77           N  
ATOM   4129  CA  GLU C  31      -0.871  15.423  -1.923  1.00 36.59           C  
ATOM   4130  C   GLU C  31      -2.037  15.440  -0.967  1.00 35.04           C  
ATOM   4131  O   GLU C  31      -2.602  14.392  -0.711  1.00 34.49           O  
ATOM   4132  CB  GLU C  31      -1.434  15.104  -3.315  1.00 37.50           C  
ATOM   4133  CG  GLU C  31      -0.443  15.183  -4.482  1.00 44.52           C  
ATOM   4134  CD  GLU C  31       0.493  13.972  -4.639  1.00 53.14           C  
ATOM   4135  OE1 GLU C  31       0.546  13.086  -3.741  1.00 52.58           O  
ATOM   4136  OE2 GLU C  31       1.190  13.926  -5.686  1.00 58.59           O  
ATOM   4137  N   PRO C  32      -2.401  16.622  -0.429  1.00 34.53           N  
ATOM   4138  CA  PRO C  32      -3.584  16.719   0.441  1.00 33.99           C  
ATOM   4139  C   PRO C  32      -4.841  16.111  -0.192  1.00 34.00           C  
ATOM   4140  O   PRO C  32      -5.020  16.179  -1.406  1.00 35.61           O  
ATOM   4141  CB  PRO C  32      -3.734  18.228   0.656  1.00 34.21           C  
ATOM   4142  CG  PRO C  32      -2.326  18.732   0.577  1.00 33.22           C  
ATOM   4143  CD  PRO C  32      -1.696  17.913  -0.524  1.00 34.52           C  
ATOM   4144  N   GLY C  33      -5.682  15.485   0.620  1.00 33.40           N  
ATOM   4145  CA  GLY C  33      -6.892  14.837   0.120  1.00 34.19           C  
ATOM   4146  C   GLY C  33      -6.736  13.345  -0.133  1.00 34.11           C  
ATOM   4147  O   GLY C  33      -7.723  12.617  -0.150  1.00 36.72           O  
ATOM   4148  N   LYS C  34      -5.512  12.872  -0.322  1.00 32.84           N  
ATOM   4149  CA  LYS C  34      -5.296  11.456  -0.574  1.00 33.70           C  
ATOM   4150  C   LYS C  34      -5.592  10.649   0.694  1.00 34.82           C  
ATOM   4151  O   LYS C  34      -5.833  11.219   1.774  1.00 33.27           O  
ATOM   4152  CB  LYS C  34      -3.881  11.196  -1.121  1.00 35.50           C  
ATOM   4153  CG  LYS C  34      -3.646  11.816  -2.502  1.00 32.61           C  
ATOM   4154  CD  LYS C  34      -2.304  11.418  -3.084  1.00 36.38           C  
ATOM   4155  N   ARG C  35      -5.617   9.327   0.537  1.00 35.34           N  
ATOM   4156  CA  ARG C  35      -5.916   8.391   1.625  1.00 36.20           C  
ATOM   4157  C   ARG C  35      -4.621   7.911   2.248  1.00 33.79           C  
ATOM   4158  O   ARG C  35      -3.696   7.526   1.536  1.00 33.24           O  
ATOM   4159  CB  ARG C  35      -6.665   7.181   1.083  1.00 36.35           C  
ATOM   4160  CG  ARG C  35      -7.944   7.505   0.326  1.00 39.58           C  
ATOM   4161  CD  ARG C  35      -8.433   6.255  -0.386  1.00 42.23           C  
ATOM   4162  NE  ARG C  35      -7.461   5.793  -1.386  1.00 46.73           N  
ATOM   4163  CZ  ARG C  35      -7.592   5.893  -2.709  1.00 49.49           C  
ATOM   4164  NH1 ARG C  35      -8.688   6.409  -3.257  1.00 52.36           N  
ATOM   4165  NH2 ARG C  35      -6.618   5.442  -3.500  1.00 43.38           N  
ATOM   4166  N   ILE C  36      -4.574   7.924   3.575  1.00 33.22           N  
ATOM   4167  CA  ILE C  36      -3.394   7.543   4.335  1.00 32.33           C  
ATOM   4168  C   ILE C  36      -3.765   6.628   5.489  1.00 32.35           C  
ATOM   4169  O   ILE C  36      -4.769   6.887   6.186  1.00 33.21           O  
ATOM   4170  CB  ILE C  36      -2.720   8.799   4.948  1.00 32.62           C  
ATOM   4171  CG1 ILE C  36      -2.119   9.698   3.857  1.00 34.34           C  
ATOM   4172  CG2 ILE C  36      -1.653   8.412   5.946  1.00 34.80           C  
ATOM   4173  CD1 ILE C  36      -1.403  10.931   4.399  1.00 31.99           C  
ATOM   4174  N   ALA C  37      -2.992   5.550   5.665  1.00 29.68           N  
ATOM   4175  CA  ALA C  37      -3.117   4.675   6.828  1.00 29.33           C  
ATOM   4176  C   ALA C  37      -1.952   5.054   7.767  1.00 31.60           C  
ATOM   4177  O   ALA C  37      -0.773   4.911   7.409  1.00 30.95           O  
ATOM   4178  CB  ALA C  37      -3.073   3.178   6.447  1.00 27.77           C  
ATOM   4179  N   ASP C  38      -2.286   5.597   8.935  1.00 29.94           N  
ATOM   4180  CA  ASP C  38      -1.283   5.987   9.930  1.00 31.48           C  
ATOM   4181  C   ASP C  38      -1.259   4.829  10.894  1.00 30.39           C  
ATOM   4182  O   ASP C  38      -2.222   4.601  11.650  1.00 31.00           O  
ATOM   4183  CB  ASP C  38      -1.663   7.284  10.619  1.00 32.95           C  
ATOM   4184  CG  ASP C  38      -0.612   7.754  11.612  1.00 37.30           C  
ATOM   4185  OD1 ASP C  38       0.622   7.531  11.418  1.00 32.76           O  
ATOM   4186  OD2 ASP C  38      -1.044   8.380  12.593  1.00 34.07           O  
ATOM   4187  N   ILE C  39      -0.175   4.074  10.829  1.00 31.21           N  
ATOM   4188  CA  ILE C  39      -0.064   2.849  11.568  1.00 33.19           C  
ATOM   4189  C   ILE C  39       0.911   3.020  12.726  1.00 33.79           C  
ATOM   4190  O   ILE C  39       1.860   3.779  12.653  1.00 34.89           O  
ATOM   4191  CB  ILE C  39       0.163   1.624  10.620  1.00 34.11           C  
ATOM   4192  CG1 ILE C  39       1.528   1.600  10.007  1.00 38.96           C  
ATOM   4193  CG2 ILE C  39      -0.908   1.569   9.458  1.00 31.75           C  
ATOM   4194  CD1 ILE C  39       1.669   0.481   9.018  1.00 38.06           C  
ATOM   4195  N   GLY C  40       0.641   2.311  13.817  1.00 35.46           N  
ATOM   4196  CA  GLY C  40       1.352   2.538  15.080  1.00 36.61           C  
ATOM   4197  C   GLY C  40       0.979   3.944  15.574  1.00 35.89           C  
ATOM   4198  O   GLY C  40       1.818   4.666  16.092  1.00 35.54           O  
ATOM   4199  N   CYS C  41      -0.292   4.324  15.411  1.00 32.99           N  
ATOM   4200  CA  CYS C  41      -0.741   5.679  15.728  1.00 33.93           C  
ATOM   4201  C   CYS C  41      -0.878   6.005  17.210  1.00 32.14           C  
ATOM   4202  O   CYS C  41      -1.026   7.166  17.566  1.00 31.27           O  
ATOM   4203  CB  CYS C  41      -2.071   5.975  15.035  1.00 33.65           C  
ATOM   4204  SG  CYS C  41      -3.446   5.002  15.576  1.00 32.20           S  
ATOM   4205  N   GLY C  42      -0.839   4.993  18.069  1.00 34.60           N  
ATOM   4206  CA  GLY C  42      -0.938   5.214  19.500  1.00 34.19           C  
ATOM   4207  C   GLY C  42      -2.241   5.908  19.809  1.00 33.02           C  
ATOM   4208  O   GLY C  42      -3.296   5.445  19.371  1.00 32.06           O  
ATOM   4209  N   THR C  43      -2.156   7.031  20.532  1.00 33.09           N  
ATOM   4210  CA  THR C  43      -3.341   7.826  20.940  1.00 34.13           C  
ATOM   4211  C   THR C  43      -3.779   8.824  19.872  1.00 34.17           C  
ATOM   4212  O   THR C  43      -4.607   9.697  20.140  1.00 33.35           O  
ATOM   4213  CB  THR C  43      -3.145   8.522  22.297  1.00 33.55           C  
ATOM   4214  OG1 THR C  43      -1.990   9.354  22.251  1.00 30.53           O  
ATOM   4215  CG2 THR C  43      -2.971   7.484  23.411  1.00 33.10           C  
ATOM   4216  N   GLY C  44      -3.204   8.694  18.667  1.00 32.31           N  
ATOM   4217  CA  GLY C  44      -3.651   9.456  17.498  1.00 29.97           C  
ATOM   4218  C   GLY C  44      -3.452  10.959  17.449  1.00 31.25           C  
ATOM   4219  O   GLY C  44      -4.080  11.629  16.619  1.00 29.85           O  
ATOM   4220  N   THR C  45      -2.569  11.513  18.280  1.00 32.67           N  
ATOM   4221  CA  THR C  45      -2.348  12.980  18.252  1.00 32.42           C  
ATOM   4222  C   THR C  45      -1.980  13.477  16.839  1.00 31.87           C  
ATOM   4223  O   THR C  45      -2.588  14.425  16.333  1.00 32.32           O  
ATOM   4224  CB  THR C  45      -1.313  13.443  19.321  1.00 33.02           C  
ATOM   4225  OG1 THR C  45      -1.665  12.897  20.601  1.00 31.72           O  
ATOM   4226  CG2 THR C  45      -1.278  14.954  19.425  1.00 33.45           C  
ATOM   4227  N   ALA C  46      -0.974  12.859  16.207  1.00 31.07           N  
ATOM   4228  CA  ALA C  46      -0.590  13.217  14.849  1.00 29.61           C  
ATOM   4229  C   ALA C  46      -1.660  12.787  13.860  1.00 29.77           C  
ATOM   4230  O   ALA C  46      -1.914  13.497  12.890  1.00 32.53           O  
ATOM   4231  CB  ALA C  46       0.743  12.572  14.467  1.00 27.34           C  
ATOM   4232  N   THR C  47      -2.296  11.635  14.122  1.00 29.99           N  
ATOM   4233  CA  THR C  47      -3.327  11.079  13.241  1.00 29.38           C  
ATOM   4234  C   THR C  47      -4.487  12.039  12.995  1.00 29.30           C  
ATOM   4235  O   THR C  47      -5.012  12.111  11.879  1.00 29.74           O  
ATOM   4236  CB  THR C  47      -3.903   9.772  13.828  1.00 29.58           C  
ATOM   4237  OG1 THR C  47      -2.832   8.937  14.279  1.00 32.91           O  
ATOM   4238  CG2 THR C  47      -4.762   9.042  12.803  1.00 27.18           C  
ATOM   4239  N   LEU C  48      -4.894  12.745  14.049  1.00 30.19           N  
ATOM   4240  CA  LEU C  48      -5.999  13.687  13.974  1.00 30.96           C  
ATOM   4241  C   LEU C  48      -5.579  14.948  13.243  1.00 29.97           C  
ATOM   4242  O   LEU C  48      -6.393  15.540  12.554  1.00 29.05           O  
ATOM   4243  CB  LEU C  48      -6.551  14.028  15.363  1.00 29.93           C  
ATOM   4244  CG  LEU C  48      -7.216  12.889  16.149  1.00 34.25           C  
ATOM   4245  CD1 LEU C  48      -7.690  13.401  17.498  1.00 37.83           C  
ATOM   4246  CD2 LEU C  48      -8.363  12.278  15.373  1.00 35.14           C  
ATOM   4247  N   LEU C  49      -4.309  15.350  13.370  1.00 31.58           N  
ATOM   4248  CA  LEU C  49      -3.800  16.513  12.612  1.00 29.88           C  
ATOM   4249  C   LEU C  49      -3.760  16.160  11.121  1.00 30.53           C  
ATOM   4250  O   LEU C  49      -4.024  17.002  10.272  1.00 32.08           O  
ATOM   4251  CB  LEU C  49      -2.416  16.950  13.093  1.00 28.96           C  
ATOM   4252  CG  LEU C  49      -2.315  17.512  14.505  1.00 28.70           C  
ATOM   4253  CD1 LEU C  49      -0.860  17.761  14.884  1.00 26.93           C  
ATOM   4254  CD2 LEU C  49      -3.153  18.791  14.639  1.00 26.17           C  
ATOM   4255  N   LEU C  50      -3.376  14.925  10.803  1.00 31.60           N  
ATOM   4256  CA  LEU C  50      -3.396  14.439   9.423  1.00 30.55           C  
ATOM   4257  C   LEU C  50      -4.821  14.427   8.870  1.00 29.32           C  
ATOM   4258  O   LEU C  50      -5.026  14.716   7.705  1.00 31.17           O  
ATOM   4259  CB  LEU C  50      -2.807  13.026   9.328  1.00 31.15           C  
ATOM   4260  CG  LEU C  50      -1.291  12.866   9.518  1.00 32.41           C  
ATOM   4261  CD1 LEU C  50      -0.920  11.391   9.597  1.00 30.65           C  
ATOM   4262  CD2 LEU C  50      -0.541  13.531   8.393  1.00 31.19           C  
ATOM   4263  N   ALA C  51      -5.795  14.073   9.714  1.00 31.10           N  
ATOM   4264  CA  ALA C  51      -7.211  14.020   9.319  1.00 30.56           C  
ATOM   4265  C   ALA C  51      -7.731  15.361   8.775  1.00 31.91           C  
ATOM   4266  O   ALA C  51      -8.708  15.383   8.017  1.00 30.82           O  
ATOM   4267  CB  ALA C  51      -8.058  13.548  10.476  1.00 29.59           C  
ATOM   4268  N   ASP C  52      -7.071  16.467   9.139  1.00 30.58           N  
ATOM   4269  CA  ASP C  52      -7.441  17.801   8.615  1.00 31.62           C  
ATOM   4270  C   ASP C  52      -6.980  18.036   7.164  1.00 30.81           C  
ATOM   4271  O   ASP C  52      -7.311  19.057   6.588  1.00 30.03           O  
ATOM   4272  CB  ASP C  52      -6.877  18.906   9.511  1.00 30.56           C  
ATOM   4273  CG  ASP C  52      -7.487  18.890  10.901  1.00 35.88           C  
ATOM   4274  OD1 ASP C  52      -8.603  18.353  11.055  1.00 36.90           O  
ATOM   4275  OD2 ASP C  52      -6.859  19.419  11.845  1.00 33.66           O  
ATOM   4276  N   HIS C  53      -6.204  17.102   6.597  1.00 30.41           N  
ATOM   4277  CA  HIS C  53      -5.707  17.210   5.221  1.00 31.23           C  
ATOM   4278  C   HIS C  53      -5.936  15.982   4.343  1.00 30.91           C  
ATOM   4279  O   HIS C  53      -5.910  16.088   3.124  1.00 31.34           O  
ATOM   4280  CB  HIS C  53      -4.214  17.466   5.257  1.00 33.45           C  
ATOM   4281  CG  HIS C  53      -3.827  18.634   6.095  1.00 34.07           C  
ATOM   4282  ND1 HIS C  53      -3.863  19.927   5.626  1.00 34.92           N  
ATOM   4283  CD2 HIS C  53      -3.385  18.703   7.372  1.00 34.57           C  
ATOM   4284  CE1 HIS C  53      -3.456  20.744   6.579  1.00 38.64           C  
ATOM   4285  NE2 HIS C  53      -3.159  20.028   7.649  1.00 31.65           N  
ATOM   4286  N   TYR C  54      -6.148  14.826   4.958  1.00 31.57           N  
ATOM   4287  CA  TYR C  54      -6.281  13.577   4.225  1.00 31.72           C  
ATOM   4288  C   TYR C  54      -7.432  12.728   4.746  1.00 31.74           C  
ATOM   4289  O   TYR C  54      -7.990  13.014   5.794  1.00 31.82           O  
ATOM   4290  CB  TYR C  54      -5.015  12.754   4.427  1.00 31.60           C  
ATOM   4291  CG  TYR C  54      -3.709  13.431   4.064  1.00 33.20           C  
ATOM   4292  CD1 TYR C  54      -3.239  13.418   2.762  1.00 30.13           C  
ATOM   4293  CD2 TYR C  54      -2.913  14.035   5.041  1.00 35.30           C  
ATOM   4294  CE1 TYR C  54      -2.029  14.021   2.434  1.00 37.45           C  
ATOM   4295  CE2 TYR C  54      -1.692  14.647   4.714  1.00 30.74           C  
ATOM   4296  CZ  TYR C  54      -1.260  14.635   3.413  1.00 34.29           C  
ATOM   4297  OH  TYR C  54      -0.039  15.193   3.059  1.00 28.22           O  
ATOM   4298  N   GLU C  55      -7.762  11.679   3.997  1.00 32.82           N  
ATOM   4299  CA  GLU C  55      -8.729  10.686   4.427  1.00 34.25           C  
ATOM   4300  C   GLU C  55      -7.832   9.718   5.185  1.00 33.55           C  
ATOM   4301  O   GLU C  55      -7.054   9.010   4.579  1.00 35.10           O  
ATOM   4302  CB  GLU C  55      -9.422   9.996   3.241  1.00 34.64           C  
ATOM   4303  CG  GLU C  55     -10.034  10.909   2.186  1.00 40.11           C  
ATOM   4304  CD  GLU C  55     -11.211  11.718   2.707  1.00 51.49           C  
ATOM   4305  OE1 GLU C  55     -11.349  11.863   3.938  1.00 56.68           O  
ATOM   4306  OE2 GLU C  55     -12.006  12.219   1.882  1.00 59.88           O  
ATOM   4307  N   VAL C  56      -7.936   9.699   6.511  1.00 33.53           N  
ATOM   4308  CA  VAL C  56      -7.040   8.920   7.352  1.00 31.74           C  
ATOM   4309  C   VAL C  56      -7.673   7.740   8.087  1.00 31.78           C  
ATOM   4310  O   VAL C  56      -8.801   7.816   8.581  1.00 32.15           O  
ATOM   4311  CB  VAL C  56      -6.402   9.842   8.420  1.00 33.15           C  
ATOM   4312  CG1 VAL C  56      -5.539   9.048   9.404  1.00 35.80           C  
ATOM   4313  CG2 VAL C  56      -5.611  10.915   7.764  1.00 29.58           C  
ATOM   4314  N   THR C  57      -6.910   6.653   8.135  1.00 31.30           N  
ATOM   4315  CA  THR C  57      -7.220   5.445   8.891  1.00 31.58           C  
ATOM   4316  C   THR C  57      -6.079   5.254   9.908  1.00 32.64           C  
ATOM   4317  O   THR C  57      -4.896   5.224   9.523  1.00 33.50           O  
ATOM   4318  CB  THR C  57      -7.271   4.228   7.983  1.00 31.31           C  
ATOM   4319  OG1 THR C  57      -8.324   4.404   7.037  1.00 32.97           O  
ATOM   4320  CG2 THR C  57      -7.506   2.941   8.782  1.00 34.67           C  
ATOM   4321  N   GLY C  58      -6.429   5.179  11.193  1.00 30.97           N  
ATOM   4322  CA  GLY C  58      -5.467   4.964  12.265  1.00 29.57           C  
ATOM   4323  C   GLY C  58      -5.482   3.490  12.636  1.00 31.41           C  
ATOM   4324  O   GLY C  58      -6.548   2.908  12.832  1.00 30.79           O  
ATOM   4325  N   VAL C  59      -4.299   2.901  12.752  1.00 29.85           N  
ATOM   4326  CA  VAL C  59      -4.130   1.507  13.083  1.00 31.10           C  
ATOM   4327  C   VAL C  59      -3.112   1.389  14.219  1.00 32.44           C  
ATOM   4328  O   VAL C  59      -1.985   1.929  14.140  1.00 31.17           O  
ATOM   4329  CB  VAL C  59      -3.633   0.682  11.865  1.00 32.76           C  
ATOM   4330  CG1 VAL C  59      -3.327  -0.761  12.285  1.00 31.92           C  
ATOM   4331  CG2 VAL C  59      -4.662   0.693  10.720  1.00 33.50           C  
ATOM   4332  N   ASP C  60      -3.529   0.744  15.305  1.00 31.72           N  
ATOM   4333  CA  ASP C  60      -2.628   0.451  16.402  1.00 33.60           C  
ATOM   4334  C   ASP C  60      -3.048  -0.875  17.026  1.00 33.01           C  
ATOM   4335  O   ASP C  60      -4.210  -1.258  16.944  1.00 33.72           O  
ATOM   4336  CB  ASP C  60      -2.621   1.571  17.436  1.00 33.31           C  
ATOM   4337  CG  ASP C  60      -1.417   1.506  18.351  1.00 34.41           C  
ATOM   4338  OD1 ASP C  60      -0.333   1.961  17.937  1.00 37.21           O  
ATOM   4339  OD2 ASP C  60      -1.549   1.023  19.493  1.00 37.51           O  
ATOM   4340  N   LEU C  61      -2.109  -1.571  17.654  1.00 34.54           N  
ATOM   4341  CA  LEU C  61      -2.415  -2.835  18.299  1.00 35.49           C  
ATOM   4342  C   LEU C  61      -3.098  -2.568  19.669  1.00 36.49           C  
ATOM   4343  O   LEU C  61      -3.818  -3.420  20.183  1.00 36.11           O  
ATOM   4344  CB  LEU C  61      -1.135  -3.673  18.469  1.00 36.84           C  
ATOM   4345  CG  LEU C  61      -1.238  -5.186  18.288  1.00 39.32           C  
ATOM   4346  CD1 LEU C  61       0.014  -5.865  18.817  1.00 41.49           C  
ATOM   4347  CD2 LEU C  61      -2.445  -5.757  18.965  1.00 41.94           C  
ATOM   4348  N   SER C  62      -2.915  -1.375  20.231  1.00 36.00           N  
ATOM   4349  CA  SER C  62      -3.484  -1.026  21.524  1.00 35.91           C  
ATOM   4350  C   SER C  62      -4.932  -0.516  21.417  1.00 35.45           C  
ATOM   4351  O   SER C  62      -5.196   0.565  20.885  1.00 34.51           O  
ATOM   4352  CB  SER C  62      -2.619   0.027  22.216  1.00 37.75           C  
ATOM   4353  OG  SER C  62      -3.081   0.282  23.530  1.00 39.74           O  
ATOM   4354  N   GLU C  63      -5.861  -1.293  21.962  1.00 35.79           N  
ATOM   4355  CA  GLU C  63      -7.278  -0.942  21.956  1.00 36.26           C  
ATOM   4356  C   GLU C  63      -7.505   0.295  22.804  1.00 35.50           C  
ATOM   4357  O   GLU C  63      -8.267   1.193  22.410  1.00 35.52           O  
ATOM   4358  CB  GLU C  63      -8.138  -2.090  22.482  1.00 34.78           C  
ATOM   4359  CG  GLU C  63      -7.874  -3.387  21.746  1.00 40.19           C  
ATOM   4360  CD  GLU C  63      -9.005  -4.373  21.829  1.00 37.68           C  
ATOM   4361  OE1 GLU C  63      -9.873  -4.225  22.714  1.00 41.51           O  
ATOM   4362  OE2 GLU C  63      -9.020  -5.313  21.003  1.00 50.20           O  
ATOM   4363  N   GLU C  64      -6.829   0.357  23.949  1.00 35.12           N  
ATOM   4364  CA  GLU C  64      -6.947   1.502  24.826  1.00 36.02           C  
ATOM   4365  C   GLU C  64      -6.504   2.797  24.211  1.00 36.80           C  
ATOM   4366  O   GLU C  64      -7.226   3.794  24.298  1.00 36.33           O  
ATOM   4367  CB  GLU C  64      -6.148   1.311  26.107  1.00 38.97           C  
ATOM   4368  CG  GLU C  64      -6.478   2.378  27.174  1.00 44.51           C  
ATOM   4369  CD  GLU C  64      -7.992   2.502  27.477  1.00 49.88           C  
ATOM   4370  OE1 GLU C  64      -8.754   1.512  27.302  1.00 44.59           O  
ATOM   4371  OE2 GLU C  64      -8.422   3.599  27.909  1.00 51.10           O  
HETATM 4372  N   MSE C  65      -5.300   2.811  23.622  1.00 35.82           N  
HETATM 4373  CA  MSE C  65      -4.790   4.017  23.019  1.00 36.34           C  
HETATM 4374  C   MSE C  65      -5.732   4.452  21.919  1.00 32.75           C  
HETATM 4375  O   MSE C  65      -6.030   5.631  21.810  1.00 33.13           O  
HETATM 4376  CB  MSE C  65      -3.363   3.814  22.506  1.00 32.97           C  
HETATM 4377  CG  MSE C  65      -2.337   3.669  23.628  1.00 40.22           C  
HETATM 4378 SE   MSE C  65      -0.446   3.802  23.020  0.75 50.96          SE  
HETATM 4379  CE  MSE C  65      -0.311   2.276  21.740  1.00 57.19           C  
ATOM   4380  N   LEU C  66      -6.216   3.500  21.114  1.00 33.46           N  
ATOM   4381  CA  LEU C  66      -7.185   3.813  20.061  1.00 31.71           C  
ATOM   4382  C   LEU C  66      -8.524   4.320  20.615  1.00 31.67           C  
ATOM   4383  O   LEU C  66      -9.224   5.065  19.935  1.00 31.65           O  
ATOM   4384  CB  LEU C  66      -7.472   2.606  19.194  1.00 32.25           C  
ATOM   4385  CG  LEU C  66      -6.391   2.153  18.221  1.00 30.11           C  
ATOM   4386  CD1 LEU C  66      -6.992   0.976  17.455  1.00 26.59           C  
ATOM   4387  CD2 LEU C  66      -5.969   3.306  17.318  1.00 26.46           C  
ATOM   4388  N   GLU C  67      -8.888   3.861  21.812  1.00 33.14           N  
ATOM   4389  CA  GLU C  67     -10.097   4.329  22.506  1.00 33.79           C  
ATOM   4390  C   GLU C  67      -9.930   5.824  22.789  1.00 33.09           C  
ATOM   4391  O   GLU C  67     -10.842   6.619  22.535  1.00 31.93           O  
ATOM   4392  CB  GLU C  67     -10.319   3.496  23.780  1.00 35.94           C  
ATOM   4393  CG  GLU C  67     -11.498   3.874  24.674  1.00 35.00           C  
ATOM   4394  CD  GLU C  67     -11.753   2.826  25.781  1.00 39.95           C  
ATOM   4395  OE1 GLU C  67     -11.711   1.608  25.487  1.00 50.60           O  
ATOM   4396  OE2 GLU C  67     -12.022   3.217  26.946  1.00 53.58           O  
ATOM   4397  N   ILE C  68      -8.738   6.204  23.258  1.00 33.19           N  
ATOM   4398  CA  ILE C  68      -8.406   7.609  23.507  1.00 31.32           C  
ATOM   4399  C   ILE C  68      -8.368   8.387  22.199  1.00 29.28           C  
ATOM   4400  O   ILE C  68      -8.886   9.483  22.130  1.00 29.03           O  
ATOM   4401  CB  ILE C  68      -7.063   7.758  24.234  1.00 31.09           C  
ATOM   4402  CG1 ILE C  68      -7.165   7.232  25.639  1.00 31.17           C  
ATOM   4403  CG2 ILE C  68      -6.590   9.215  24.247  1.00 30.80           C  
ATOM   4404  CD1 ILE C  68      -5.864   7.243  26.335  1.00 41.69           C  
ATOM   4405  N   ALA C  69      -7.704   7.835  21.179  1.00 30.23           N  
ATOM   4406  CA  ALA C  69      -7.655   8.446  19.856  1.00 29.21           C  
ATOM   4407  C   ALA C  69      -9.073   8.718  19.377  1.00 28.18           C  
ATOM   4408  O   ALA C  69      -9.366   9.773  18.836  1.00 27.66           O  
ATOM   4409  CB  ALA C  69      -6.919   7.509  18.836  1.00 28.90           C  
ATOM   4410  N   GLN C  70      -9.935   7.730  19.571  1.00 30.22           N  
ATOM   4411  CA  GLN C  70     -11.336   7.807  19.146  1.00 30.87           C  
ATOM   4412  C   GLN C  70     -12.094   8.903  19.876  1.00 30.60           C  
ATOM   4413  O   GLN C  70     -12.910   9.590  19.263  1.00 28.56           O  
ATOM   4414  CB  GLN C  70     -12.028   6.473  19.366  1.00 30.61           C  
ATOM   4415  CG  GLN C  70     -13.461   6.466  18.878  1.00 34.66           C  
ATOM   4416  CD  GLN C  70     -14.103   5.113  19.016  1.00 35.64           C  
ATOM   4417  OE1 GLN C  70     -13.917   4.419  20.027  1.00 44.87           O  
ATOM   4418  NE2 GLN C  70     -14.888   4.731  18.009  1.00 37.42           N  
ATOM   4419  N   GLU C  71     -11.824   9.059  21.175  1.00 32.89           N  
ATOM   4420  CA  GLU C  71     -12.460  10.112  21.981  1.00 32.75           C  
ATOM   4421  C   GLU C  71     -12.033  11.469  21.461  1.00 30.24           C  
ATOM   4422  O   GLU C  71     -12.839  12.371  21.311  1.00 31.09           O  
ATOM   4423  CB  GLU C  71     -12.023  10.087  23.450  1.00 33.64           C  
ATOM   4424  CG  GLU C  71     -12.346   8.871  24.274  1.00 38.38           C  
ATOM   4425  CD  GLU C  71     -12.375   9.204  25.782  1.00 41.21           C  
ATOM   4426  OE1 GLU C  71     -11.778  10.237  26.200  1.00 48.96           O  
ATOM   4427  OE2 GLU C  71     -13.025   8.442  26.542  1.00 43.48           O  
ATOM   4428  N   LYS C  72     -10.738  11.627  21.227  1.00 29.19           N  
ATOM   4429  CA  LYS C  72     -10.231  12.903  20.739  1.00 29.12           C  
ATOM   4430  C   LYS C  72     -10.772  13.278  19.373  1.00 27.54           C  
ATOM   4431  O   LYS C  72     -10.952  14.458  19.083  1.00 29.92           O  
ATOM   4432  CB  LYS C  72      -8.705  12.915  20.758  1.00 30.90           C  
ATOM   4433  CG  LYS C  72      -8.127  12.705  22.167  1.00 31.39           C  
ATOM   4434  CD  LYS C  72      -6.638  12.969  22.244  1.00 34.79           C  
ATOM   4435  CE  LYS C  72      -5.864  12.123  21.329  1.00 32.70           C  
ATOM   4436  NZ  LYS C  72      -4.407  12.307  21.527  1.00 30.14           N  
ATOM   4437  N   ALA C  73     -11.041  12.286  18.530  1.00 27.59           N  
ATOM   4438  CA  ALA C  73     -11.613  12.533  17.205  1.00 28.03           C  
ATOM   4439  C   ALA C  73     -13.034  12.979  17.407  1.00 28.90           C  
ATOM   4440  O   ALA C  73     -13.520  13.928  16.798  1.00 31.19           O  
ATOM   4441  CB  ALA C  73     -11.578  11.255  16.350  1.00 27.32           C  
HETATM 4442  N   MSE C  74     -13.699  12.260  18.289  1.00 30.67           N  
HETATM 4443  CA  MSE C  74     -15.067  12.540  18.626  1.00 30.85           C  
HETATM 4444  C   MSE C  74     -15.088  13.989  19.101  1.00 28.26           C  
HETATM 4445  O   MSE C  74     -15.702  14.847  18.446  1.00 30.44           O  
HETATM 4446  CB  MSE C  74     -15.499  11.474  19.619  1.00 32.63           C  
HETATM 4447  CG  MSE C  74     -16.906  11.558  20.134  1.00 31.45           C  
HETATM 4448 SE   MSE C  74     -16.787  12.960  21.514  0.75 41.95          SE  
HETATM 4449  CE  MSE C  74     -17.559  14.410  20.479  1.00 50.10           C  
ATOM   4450  N   GLU C  75     -14.375  14.261  20.213  1.00 28.68           N  
ATOM   4451  CA  GLU C  75     -14.265  15.619  20.803  1.00 32.29           C  
ATOM   4452  C   GLU C  75     -14.032  16.755  19.815  1.00 30.71           C  
ATOM   4453  O   GLU C  75     -14.552  17.833  19.975  1.00 31.61           O  
ATOM   4454  CB  GLU C  75     -13.141  15.653  21.860  1.00 31.22           C  
ATOM   4455  CG  GLU C  75     -13.494  14.946  23.162  1.00 35.70           C  
ATOM   4456  CD  GLU C  75     -12.325  14.772  24.119  1.00 36.56           C  
ATOM   4457  OE1 GLU C  75     -11.179  15.162  23.798  1.00 48.20           O  
ATOM   4458  OE2 GLU C  75     -12.558  14.210  25.203  1.00 41.06           O  
ATOM   4459  N   THR C  76     -13.241  16.520  18.784  1.00 32.10           N  
ATOM   4460  CA  THR C  76     -12.929  17.580  17.837  1.00 31.09           C  
ATOM   4461  C   THR C  76     -13.686  17.461  16.511  1.00 31.80           C  
ATOM   4462  O   THR C  76     -13.351  18.135  15.530  1.00 31.38           O  
ATOM   4463  CB  THR C  76     -11.409  17.624  17.634  1.00 29.14           C  
ATOM   4464  OG1 THR C  76     -10.964  16.356  17.148  1.00 26.72           O  
ATOM   4465  CG2 THR C  76     -10.743  17.896  18.970  1.00 27.38           C  
ATOM   4466  N   ASN C  77     -14.709  16.602  16.488  1.00 32.62           N  
ATOM   4467  CA  ASN C  77     -15.566  16.400  15.310  1.00 31.96           C  
ATOM   4468  C   ASN C  77     -14.839  15.889  14.059  1.00 32.64           C  
ATOM   4469  O   ASN C  77     -15.148  16.283  12.935  1.00 32.09           O  
ATOM   4470  CB  ASN C  77     -16.285  17.705  14.996  1.00 33.54           C  
ATOM   4471  CG  ASN C  77     -17.595  17.494  14.282  1.00 37.36           C  
ATOM   4472  OD1 ASN C  77     -18.124  16.385  14.230  1.00 47.01           O  
ATOM   4473  ND2 ASN C  77     -18.140  18.569  13.743  1.00 40.94           N  
ATOM   4474  N   ARG C  78     -13.858  15.019  14.263  1.00 31.24           N  
ATOM   4475  CA  ARG C  78     -13.109  14.440  13.161  1.00 32.27           C  
ATOM   4476  C   ARG C  78     -13.549  13.014  12.959  1.00 32.72           C  
ATOM   4477  O   ARG C  78     -13.975  12.339  13.907  1.00 32.19           O  
ATOM   4478  CB  ARG C  78     -11.620  14.477  13.441  1.00 32.09           C  
ATOM   4479  CG  ARG C  78     -10.993  15.844  13.258  1.00 35.02           C  
ATOM   4480  CD  ARG C  78      -9.751  15.893  14.097  1.00 37.84           C  
ATOM   4481  NE  ARG C  78      -8.930  17.076  13.913  1.00 35.50           N  
ATOM   4482  CZ  ARG C  78      -8.183  17.608  14.879  1.00 38.68           C  
ATOM   4483  NH1 ARG C  78      -8.237  17.134  16.119  1.00 34.90           N  
ATOM   4484  NH2 ARG C  78      -7.425  18.664  14.621  1.00 40.94           N  
ATOM   4485  N   HIS C  79     -13.444  12.566  11.711  1.00 33.14           N  
ATOM   4486  CA  HIS C  79     -13.839  11.222  11.345  1.00 32.76           C  
ATOM   4487  C   HIS C  79     -12.699  10.386  10.788  1.00 32.39           C  
ATOM   4488  O   HIS C  79     -12.313  10.505   9.629  1.00 31.63           O  
ATOM   4489  CB  HIS C  79     -15.025  11.294  10.409  1.00 32.76           C  
ATOM   4490  CG  HIS C  79     -16.269  11.776  11.086  1.00 32.77           C  
ATOM   4491  ND1 HIS C  79     -16.742  13.062  10.952  1.00 35.09           N  
ATOM   4492  CD2 HIS C  79     -17.114  11.152  11.943  1.00 34.43           C  
ATOM   4493  CE1 HIS C  79     -17.847  13.199  11.663  1.00 31.68           C  
ATOM   4494  NE2 HIS C  79     -18.093  12.053  12.274  1.00 36.62           N  
ATOM   4495  N   VAL C  80     -12.166   9.543  11.656  1.00 31.44           N  
ATOM   4496  CA  VAL C  80     -11.078   8.644  11.326  1.00 32.51           C  
ATOM   4497  C   VAL C  80     -11.471   7.233  11.761  1.00 32.72           C  
ATOM   4498  O   VAL C  80     -11.944   7.037  12.878  1.00 30.23           O  
ATOM   4499  CB  VAL C  80      -9.789   9.061  12.068  1.00 32.73           C  
ATOM   4500  CG1 VAL C  80      -8.672   8.051  11.834  1.00 31.98           C  
ATOM   4501  CG2 VAL C  80      -9.380  10.472  11.653  1.00 32.67           C  
ATOM   4502  N   ASP C  81     -11.319   6.261  10.869  1.00 32.59           N  
ATOM   4503  CA  ASP C  81     -11.578   4.870  11.226  1.00 33.32           C  
ATOM   4504  C   ASP C  81     -10.361   4.407  11.978  1.00 31.86           C  
ATOM   4505  O   ASP C  81      -9.261   4.534  11.457  1.00 32.31           O  
ATOM   4506  CB  ASP C  81     -11.704   3.984   9.983  1.00 36.98           C  
ATOM   4507  CG  ASP C  81     -13.007   4.171   9.247  1.00 41.24           C  
ATOM   4508  OD1 ASP C  81     -13.979   4.699   9.839  1.00 41.20           O  
ATOM   4509  OD2 ASP C  81     -13.044   3.765   8.064  1.00 49.61           O  
ATOM   4510  N   PHE C  82     -10.535   3.900  13.196  1.00 30.44           N  
ATOM   4511  CA  PHE C  82      -9.410   3.363  13.952  1.00 30.53           C  
ATOM   4512  C   PHE C  82      -9.534   1.843  14.007  1.00 29.86           C  
ATOM   4513  O   PHE C  82     -10.540   1.325  14.446  1.00 31.97           O  
ATOM   4514  CB  PHE C  82      -9.329   3.960  15.353  1.00 31.83           C  
ATOM   4515  CG  PHE C  82      -8.943   5.402  15.369  1.00 34.56           C  
ATOM   4516  CD1 PHE C  82      -7.615   5.772  15.294  1.00 37.01           C  
ATOM   4517  CD2 PHE C  82      -9.912   6.393  15.478  1.00 35.70           C  
ATOM   4518  CE1 PHE C  82      -7.243   7.112  15.288  1.00 37.70           C  
ATOM   4519  CE2 PHE C  82      -9.555   7.740  15.507  1.00 35.36           C  
ATOM   4520  CZ  PHE C  82      -8.212   8.099  15.404  1.00 38.33           C  
ATOM   4521  N   TRP C  83      -8.513   1.128  13.559  1.00 30.62           N  
ATOM   4522  CA  TRP C  83      -8.563  -0.325  13.558  1.00 31.11           C  
ATOM   4523  C   TRP C  83      -7.479  -0.918  14.444  1.00 31.02           C  
ATOM   4524  O   TRP C  83      -6.327  -0.488  14.413  1.00 29.51           O  
ATOM   4525  CB  TRP C  83      -8.442  -0.874  12.133  1.00 35.13           C  
ATOM   4526  CG  TRP C  83      -9.529  -0.401  11.173  1.00 39.33           C  
ATOM   4527  CD1 TRP C  83      -9.344   0.214   9.967  1.00 41.92           C  
ATOM   4528  CD2 TRP C  83     -10.957  -0.475  11.363  1.00 49.11           C  
ATOM   4529  NE1 TRP C  83     -10.556   0.495   9.375  1.00 42.47           N  
ATOM   4530  CE2 TRP C  83     -11.563   0.088  10.212  1.00 50.91           C  
ATOM   4531  CE3 TRP C  83     -11.785  -0.978  12.384  1.00 46.64           C  
ATOM   4532  CZ2 TRP C  83     -12.962   0.169  10.060  1.00 47.75           C  
ATOM   4533  CZ3 TRP C  83     -13.175  -0.894  12.234  1.00 44.23           C  
ATOM   4534  CH2 TRP C  83     -13.744  -0.328  11.077  1.00 45.72           C  
ATOM   4535  N   VAL C  84      -7.868  -1.892  15.265  1.00 31.63           N  
ATOM   4536  CA  VAL C  84      -6.913  -2.593  16.108  1.00 33.59           C  
ATOM   4537  C   VAL C  84      -6.227  -3.624  15.229  1.00 33.95           C  
ATOM   4538  O   VAL C  84      -6.867  -4.575  14.792  1.00 36.07           O  
ATOM   4539  CB  VAL C  84      -7.563  -3.300  17.312  1.00 33.81           C  
ATOM   4540  CG1 VAL C  84      -6.489  -4.034  18.109  1.00 35.47           C  
ATOM   4541  CG2 VAL C  84      -8.242  -2.282  18.195  1.00 31.84           C  
ATOM   4542  N   GLN C  85      -4.944  -3.422  14.964  1.00 33.33           N  
ATOM   4543  CA  GLN C  85      -4.150  -4.336  14.129  1.00 35.71           C  
ATOM   4544  C   GLN C  85      -2.683  -4.241  14.462  1.00 35.45           C  
ATOM   4545  O   GLN C  85      -2.197  -3.210  14.949  1.00 35.48           O  
ATOM   4546  CB  GLN C  85      -4.269  -4.019  12.642  1.00 34.89           C  
ATOM   4547  CG  GLN C  85      -5.659  -4.088  12.070  1.00 38.89           C  
ATOM   4548  CD  GLN C  85      -5.681  -4.205  10.557  1.00 40.62           C  
ATOM   4549  OE1 GLN C  85      -4.642  -4.244   9.899  1.00 41.62           O  
ATOM   4550  NE2 GLN C  85      -6.880  -4.295  10.004  1.00 50.02           N  
ATOM   4551  N   ASP C  86      -1.983  -5.314  14.145  1.00 35.11           N  
ATOM   4552  CA  ASP C  86      -0.551  -5.416  14.328  1.00 35.70           C  
ATOM   4553  C   ASP C  86       0.051  -4.972  12.996  1.00 37.49           C  
ATOM   4554  O   ASP C  86      -0.272  -5.554  11.958  1.00 37.77           O  
ATOM   4555  CB  ASP C  86      -0.233  -6.873  14.638  1.00 36.30           C  
ATOM   4556  CG  ASP C  86       1.217  -7.116  14.941  1.00 38.69           C  
ATOM   4557  OD1 ASP C  86       2.112  -6.518  14.308  1.00 34.15           O  
ATOM   4558  OD2 ASP C  86       1.465  -7.969  15.805  1.00 45.48           O  
HETATM 4559  N   MSE C  87       0.919  -3.950  13.011  1.00 37.11           N  
HETATM 4560  CA  MSE C  87       1.528  -3.423  11.756  1.00 36.16           C  
HETATM 4561  C   MSE C  87       2.299  -4.477  10.958  1.00 34.92           C  
HETATM 4562  O   MSE C  87       2.396  -4.386   9.745  1.00 37.73           O  
HETATM 4563  CB  MSE C  87       2.439  -2.214  12.036  1.00 37.50           C  
HETATM 4564  CG  MSE C  87       3.733  -2.533  12.784  1.00 33.53           C  
HETATM 4565 SE   MSE C  87       4.829  -0.985  13.084  0.75 36.46          SE  
HETATM 4566  CE  MSE C  87       3.633   0.018  14.293  1.00 35.27           C  
ATOM   4567  N   ARG C  88       2.836  -5.486  11.640  1.00 33.84           N  
ATOM   4568  CA  ARG C  88       3.548  -6.572  10.984  1.00 33.23           C  
ATOM   4569  C   ARG C  88       2.669  -7.366  10.034  1.00 35.17           C  
ATOM   4570  O   ARG C  88       3.163  -7.959   9.084  1.00 35.29           O  
ATOM   4571  CB  ARG C  88       4.152  -7.518  12.023  1.00 32.33           C  
ATOM   4572  CG  ARG C  88       5.210  -6.847  12.874  1.00 33.88           C  
ATOM   4573  CD  ARG C  88       5.725  -7.756  13.946  1.00 35.10           C  
ATOM   4574  NE  ARG C  88       4.691  -8.043  14.928  1.00 38.65           N  
ATOM   4575  CZ  ARG C  88       4.811  -8.942  15.901  1.00 39.77           C  
ATOM   4576  NH1 ARG C  88       5.917  -9.655  16.053  1.00 38.80           N  
ATOM   4577  NH2 ARG C  88       3.809  -9.136  16.735  1.00 48.14           N  
ATOM   4578  N   GLU C  89       1.366  -7.371  10.283  1.00 37.85           N  
ATOM   4579  CA  GLU C  89       0.425  -8.136   9.472  1.00 41.00           C  
ATOM   4580  C   GLU C  89      -0.804  -7.280   9.216  1.00 40.52           C  
ATOM   4581  O   GLU C  89      -1.933  -7.709   9.409  1.00 41.26           O  
ATOM   4582  CB  GLU C  89       0.079  -9.463  10.175  1.00 40.39           C  
ATOM   4583  CG  GLU C  89      -0.407  -9.315  11.615  1.00 46.30           C  
ATOM   4584  CD  GLU C  89      -0.642 -10.657  12.329  1.00 46.90           C  
ATOM   4585  OE1 GLU C  89      -0.696 -11.728  11.666  1.00 52.17           O  
ATOM   4586  OE2 GLU C  89      -0.786 -10.626  13.573  1.00 55.82           O  
ATOM   4587  N   LEU C  90      -0.543  -6.056   8.772  1.00 40.87           N  
ATOM   4588  CA  LEU C  90      -1.556  -5.052   8.484  1.00 42.23           C  
ATOM   4589  C   LEU C  90      -2.493  -5.604   7.404  1.00 44.72           C  
ATOM   4590  O   LEU C  90      -2.042  -6.258   6.474  1.00 45.08           O  
ATOM   4591  CB  LEU C  90      -0.842  -3.797   7.971  1.00 42.11           C  
ATOM   4592  CG  LEU C  90      -1.404  -2.391   8.016  1.00 43.84           C  
ATOM   4593  CD1 LEU C  90      -0.598  -1.580   6.997  1.00 43.47           C  
ATOM   4594  CD2 LEU C  90      -2.884  -2.310   7.721  1.00 52.12           C  
ATOM   4595  N   GLU C  91      -3.795  -5.366   7.541  1.00 45.77           N  
ATOM   4596  CA  GLU C  91      -4.775  -5.837   6.557  1.00 46.06           C  
ATOM   4597  C   GLU C  91      -5.967  -4.880   6.530  1.00 47.19           C  
ATOM   4598  O   GLU C  91      -6.779  -4.880   7.454  1.00 48.29           O  
ATOM   4599  CB  GLU C  91      -5.234  -7.263   6.890  1.00 46.66           C  
ATOM   4600  N   LEU C  92      -6.068  -4.066   5.479  1.00 46.84           N  
ATOM   4601  CA  LEU C  92      -7.142  -3.070   5.352  1.00 48.19           C  
ATOM   4602  C   LEU C  92      -8.120  -3.339   4.204  1.00 49.15           C  
ATOM   4603  O   LEU C  92      -7.734  -3.891   3.166  1.00 48.86           O  
ATOM   4604  CB  LEU C  92      -6.548  -1.667   5.221  1.00 48.77           C  
ATOM   4605  CG  LEU C  92      -6.027  -1.141   6.551  1.00 49.51           C  
ATOM   4606  CD1 LEU C  92      -5.123   0.066   6.365  1.00 40.53           C  
ATOM   4607  CD2 LEU C  92      -7.214  -0.832   7.457  1.00 49.92           C  
ATOM   4608  N   PRO C  93      -9.390  -2.914   4.383  1.00 51.54           N  
ATOM   4609  CA  PRO C  93     -10.447  -3.166   3.416  1.00 52.17           C  
ATOM   4610  C   PRO C  93     -10.391  -2.290   2.171  1.00 52.97           C  
ATOM   4611  O   PRO C  93     -10.649  -2.796   1.084  1.00 55.33           O  
ATOM   4612  CB  PRO C  93     -11.716  -2.877   4.214  1.00 52.28           C  
ATOM   4613  CG  PRO C  93     -11.308  -1.840   5.193  1.00 51.48           C  
ATOM   4614  CD  PRO C  93      -9.887  -2.136   5.540  1.00 52.65           C  
ATOM   4615  N   GLU C  94     -10.071  -1.002   2.321  1.00 52.20           N  
ATOM   4616  CA  GLU C  94     -10.006  -0.085   1.176  1.00 50.85           C  
ATOM   4617  C   GLU C  94      -8.559   0.282   0.814  1.00 48.96           C  
ATOM   4618  O   GLU C  94      -7.657   0.151   1.646  1.00 48.78           O  
ATOM   4619  CB  GLU C  94     -10.827   1.188   1.448  1.00 51.21           C  
ATOM   4620  CG  GLU C  94     -12.362   0.996   1.453  1.00 51.24           C  
ATOM   4621  CD  GLU C  94     -12.967   0.667   0.074  1.00 57.64           C  
ATOM   4622  OE1 GLU C  94     -12.360   0.968  -0.977  1.00 59.21           O  
ATOM   4623  OE2 GLU C  94     -14.087   0.118   0.035  1.00 64.26           O  
ATOM   4624  N   PRO C  95      -8.332   0.726  -0.441  1.00 46.72           N  
ATOM   4625  CA  PRO C  95      -6.993   1.144  -0.863  1.00 44.44           C  
ATOM   4626  C   PRO C  95      -6.502   2.373  -0.121  1.00 41.24           C  
ATOM   4627  O   PRO C  95      -7.321   3.146   0.376  1.00 40.49           O  
ATOM   4628  CB  PRO C  95      -7.185   1.508  -2.343  1.00 44.43           C  
ATOM   4629  CG  PRO C  95      -8.453   0.864  -2.755  1.00 44.91           C  
ATOM   4630  CD  PRO C  95      -9.308   0.849  -1.542  1.00 46.36           C  
ATOM   4631  N   VAL C  96      -5.179   2.524  -0.020  1.00 38.98           N  
ATOM   4632  CA  VAL C  96      -4.558   3.725   0.568  1.00 35.88           C  
ATOM   4633  C   VAL C  96      -3.430   4.175  -0.333  1.00 34.47           C  
ATOM   4634  O   VAL C  96      -2.702   3.352  -0.890  1.00 34.30           O  
ATOM   4635  CB  VAL C  96      -3.989   3.537   2.022  1.00 36.03           C  
ATOM   4636  CG1 VAL C  96      -5.090   3.157   3.005  1.00 32.47           C  
ATOM   4637  CG2 VAL C  96      -2.860   2.524   2.049  1.00 36.41           C  
ATOM   4638  N   ASP C  97      -3.282   5.492  -0.453  1.00 33.51           N  
ATOM   4639  CA  ASP C  97      -2.239   6.097  -1.266  1.00 32.41           C  
ATOM   4640  C   ASP C  97      -0.881   6.179  -0.548  1.00 31.30           C  
ATOM   4641  O   ASP C  97       0.155   6.288  -1.198  1.00 30.34           O  
ATOM   4642  CB  ASP C  97      -2.686   7.496  -1.707  1.00 33.08           C  
ATOM   4643  CG  ASP C  97      -3.998   7.476  -2.494  1.00 35.56           C  
ATOM   4644  OD1 ASP C  97      -4.044   6.848  -3.575  1.00 38.09           O  
ATOM   4645  OD2 ASP C  97      -4.977   8.115  -2.037  1.00 33.62           O  
ATOM   4646  N   ALA C  98      -0.907   6.164   0.785  1.00 30.96           N  
ATOM   4647  CA  ALA C  98       0.298   6.226   1.604  1.00 29.99           C  
ATOM   4648  C   ALA C  98       0.115   5.573   2.971  1.00 30.54           C  
ATOM   4649  O   ALA C  98      -0.997   5.508   3.532  1.00 30.79           O  
ATOM   4650  CB  ALA C  98       0.734   7.660   1.815  1.00 29.21           C  
ATOM   4651  N   ILE C  99       1.236   5.125   3.504  1.00 29.71           N  
ATOM   4652  CA  ILE C  99       1.301   4.596   4.839  1.00 30.48           C  
ATOM   4653  C   ILE C  99       2.320   5.459   5.594  1.00 30.77           C  
ATOM   4654  O   ILE C  99       3.387   5.808   5.065  1.00 28.82           O  
ATOM   4655  CB  ILE C  99       1.683   3.098   4.862  1.00 32.18           C  
ATOM   4656  CG1 ILE C  99       0.624   2.273   4.111  1.00 32.07           C  
ATOM   4657  CG2 ILE C  99       1.867   2.622   6.324  1.00 30.81           C  
ATOM   4658  CD1 ILE C  99       0.843   0.756   4.133  1.00 31.25           C  
ATOM   4659  N   THR C 100       1.950   5.870   6.804  1.00 29.67           N  
ATOM   4660  CA  THR C 100       2.849   6.615   7.667  1.00 28.22           C  
ATOM   4661  C   THR C 100       3.026   5.829   8.958  1.00 29.40           C  
ATOM   4662  O   THR C 100       2.053   5.268   9.475  1.00 29.04           O  
ATOM   4663  CB  THR C 100       2.306   8.055   7.966  1.00 30.09           C  
ATOM   4664  OG1 THR C 100       1.018   7.989   8.613  1.00 32.73           O  
ATOM   4665  CG2 THR C 100       2.152   8.840   6.682  1.00 26.72           C  
ATOM   4666  N   ILE C 101       4.266   5.771   9.451  1.00 29.00           N  
ATOM   4667  CA  ILE C 101       4.611   5.179  10.737  1.00 28.57           C  
ATOM   4668  C   ILE C 101       5.450   6.266  11.393  1.00 31.40           C  
ATOM   4669  O   ILE C 101       6.662   6.376  11.188  1.00 30.78           O  
ATOM   4670  CB  ILE C 101       5.353   3.834  10.640  1.00 29.33           C  
ATOM   4671  CG1 ILE C 101       4.763   2.982   9.511  1.00 31.02           C  
ATOM   4672  CG2 ILE C 101       5.298   3.108  12.006  1.00 25.03           C  
ATOM   4673  CD1 ILE C 101       5.450   1.617   9.302  1.00 28.39           C  
ATOM   4674  N   LEU C 102       4.786   7.100  12.182  1.00 30.79           N  
ATOM   4675  CA  LEU C 102       5.434   8.267  12.744  1.00 30.47           C  
ATOM   4676  C   LEU C 102       5.916   8.175  14.200  1.00 31.02           C  
ATOM   4677  O   LEU C 102       5.517   7.271  14.971  1.00 30.91           O  
ATOM   4678  CB  LEU C 102       4.500   9.478  12.535  1.00 32.12           C  
ATOM   4679  CG  LEU C 102       3.906   9.692  11.124  1.00 27.92           C  
ATOM   4680  CD1 LEU C 102       2.916  10.879  11.133  1.00 35.48           C  
ATOM   4681  CD2 LEU C 102       5.001   9.933  10.079  1.00 28.75           C  
ATOM   4682  N   CYS C 103       6.822   9.093  14.532  1.00 32.39           N  
ATOM   4683  CA  CYS C 103       7.340   9.300  15.904  1.00 31.94           C  
ATOM   4684  C   CYS C 103       7.950   8.087  16.541  1.00 31.61           C  
ATOM   4685  O   CYS C 103       7.567   7.679  17.647  1.00 28.86           O  
ATOM   4686  CB  CYS C 103       6.213   9.843  16.791  1.00 34.89           C  
ATOM   4687  SG  CYS C 103       5.372  11.289  16.055  1.00 39.32           S  
ATOM   4688  N   ASP C 104       8.920   7.530  15.835  1.00 31.12           N  
ATOM   4689  CA  ASP C 104       9.676   6.343  16.236  1.00 29.75           C  
ATOM   4690  C   ASP C 104       8.790   5.143  16.626  1.00 28.71           C  
ATOM   4691  O   ASP C 104       9.226   4.237  17.325  1.00 29.85           O  
ATOM   4692  CB  ASP C 104      10.770   6.671  17.278  1.00 30.21           C  
ATOM   4693  CG  ASP C 104      10.238   7.386  18.530  1.00 33.20           C  
ATOM   4694  OD1 ASP C 104      10.168   8.628  18.517  1.00 29.99           O  
ATOM   4695  OD2 ASP C 104       9.941   6.711  19.556  1.00 26.94           O  
ATOM   4696  N   SER C 105       7.558   5.124  16.112  1.00 29.60           N  
ATOM   4697  CA  SER C 105       6.656   4.017  16.335  1.00 32.46           C  
ATOM   4698  C   SER C 105       7.213   2.700  15.777  1.00 29.96           C  
ATOM   4699  O   SER C 105       7.084   1.637  16.409  1.00 29.18           O  
ATOM   4700  CB  SER C 105       5.300   4.301  15.720  1.00 34.66           C  
ATOM   4701  OG  SER C 105       4.481   3.215  16.008  1.00 36.08           O  
ATOM   4702  N   LEU C 106       7.852   2.770  14.603  1.00 31.81           N  
ATOM   4703  CA  LEU C 106       8.469   1.586  14.006  1.00 28.70           C  
ATOM   4704  C   LEU C 106       9.536   0.982  14.909  1.00 29.21           C  
ATOM   4705  O   LEU C 106       9.828  -0.192  14.782  1.00 30.30           O  
ATOM   4706  CB  LEU C 106       9.135   1.942  12.661  1.00 29.73           C  
ATOM   4707  CG  LEU C 106       9.580   0.768  11.777  1.00 29.06           C  
ATOM   4708  CD1 LEU C 106       8.329   0.096  11.210  1.00 34.51           C  
ATOM   4709  CD2 LEU C 106      10.552   1.196  10.677  1.00 27.31           C  
ATOM   4710  N   ASN C 107      10.159   1.795  15.775  1.00 30.51           N  
ATOM   4711  CA  ASN C 107      11.248   1.330  16.673  1.00 27.75           C  
ATOM   4712  C   ASN C 107      10.770   0.442  17.815  1.00 28.31           C  
ATOM   4713  O   ASN C 107      11.586  -0.116  18.503  1.00 28.84           O  
ATOM   4714  CB  ASN C 107      12.097   2.505  17.228  1.00 27.76           C  
ATOM   4715  CG  ASN C 107      12.936   3.210  16.171  1.00 25.09           C  
ATOM   4716  OD1 ASN C 107      12.840   4.408  15.997  1.00 28.29           O  
ATOM   4717  ND2 ASN C 107      13.757   2.453  15.458  1.00 26.75           N  
ATOM   4718  N   TYR C 108       9.461   0.336  18.039  1.00 29.64           N  
ATOM   4719  CA  TYR C 108       8.916  -0.605  19.020  1.00 29.77           C  
ATOM   4720  C   TYR C 108       8.996  -2.057  18.548  1.00 29.30           C  
ATOM   4721  O   TYR C 108       8.875  -2.963  19.361  1.00 28.36           O  
ATOM   4722  CB  TYR C 108       7.479  -0.226  19.457  1.00 32.50           C  
ATOM   4723  CG  TYR C 108       7.481   1.043  20.276  1.00 31.65           C  
ATOM   4724  CD1 TYR C 108       7.883   1.022  21.611  1.00 36.16           C  
ATOM   4725  CD2 TYR C 108       7.130   2.265  19.715  1.00 34.86           C  
ATOM   4726  CE1 TYR C 108       7.912   2.169  22.372  1.00 34.45           C  
ATOM   4727  CE2 TYR C 108       7.152   3.428  20.471  1.00 34.92           C  
ATOM   4728  CZ  TYR C 108       7.561   3.367  21.788  1.00 37.04           C  
ATOM   4729  OH  TYR C 108       7.601   4.507  22.532  1.00 40.65           O  
ATOM   4730  N   LEU C 109       9.213  -2.278  17.247  1.00 30.07           N  
ATOM   4731  CA  LEU C 109       9.409  -3.636  16.733  1.00 30.01           C  
ATOM   4732  C   LEU C 109      10.668  -4.176  17.414  1.00 28.61           C  
ATOM   4733  O   LEU C 109      11.611  -3.431  17.691  1.00 29.90           O  
ATOM   4734  CB  LEU C 109       9.487  -3.662  15.198  1.00 29.10           C  
ATOM   4735  CG  LEU C 109       8.243  -3.137  14.473  1.00 29.12           C  
ATOM   4736  CD1 LEU C 109       8.461  -3.131  12.935  1.00 23.49           C  
ATOM   4737  CD2 LEU C 109       7.006  -3.907  14.851  1.00 26.22           C  
ATOM   4738  N   GLN C 110      10.672  -5.466  17.709  1.00 31.75           N  
ATOM   4739  CA  GLN C 110      11.757  -6.064  18.476  1.00 32.30           C  
ATOM   4740  C   GLN C 110      12.781  -6.854  17.687  1.00 33.50           C  
ATOM   4741  O   GLN C 110      13.949  -6.912  18.089  1.00 35.18           O  
ATOM   4742  CB  GLN C 110      11.155  -6.901  19.599  1.00 33.80           C  
ATOM   4743  CG  GLN C 110      10.467  -6.007  20.624  1.00 36.62           C  
ATOM   4744  CD  GLN C 110       9.707  -6.754  21.705  1.00 34.97           C  
ATOM   4745  OE1 GLN C 110       9.580  -7.976  21.665  1.00 45.89           O  
ATOM   4746  NE2 GLN C 110       9.194  -6.009  22.679  1.00 35.90           N  
ATOM   4747  N   THR C 111      12.380  -7.453  16.565  1.00 31.36           N  
ATOM   4748  CA  THR C 111      13.315  -8.227  15.772  1.00 30.96           C  
ATOM   4749  C   THR C 111      13.419  -7.687  14.361  1.00 30.39           C  
ATOM   4750  O   THR C 111      12.571  -6.914  13.918  1.00 27.27           O  
ATOM   4751  CB  THR C 111      12.855  -9.688  15.643  1.00 32.40           C  
ATOM   4752  OG1 THR C 111      11.675  -9.721  14.831  1.00 32.42           O  
ATOM   4753  CG2 THR C 111      12.570 -10.304  17.008  1.00 30.36           C  
ATOM   4754  N   GLU C 112      14.445  -8.150  13.652  1.00 29.38           N  
ATOM   4755  CA  GLU C 112      14.650  -7.781  12.269  1.00 30.86           C  
ATOM   4756  C   GLU C 112      13.514  -8.337  11.398  1.00 29.60           C  
ATOM   4757  O   GLU C 112      13.015  -7.650  10.509  1.00 26.45           O  
ATOM   4758  CB  GLU C 112      16.013  -8.290  11.785  1.00 32.19           C  
ATOM   4759  CG  GLU C 112      17.185  -7.749  12.602  1.00 35.02           C  
ATOM   4760  CD  GLU C 112      18.547  -8.181  12.096  1.00 34.05           C  
ATOM   4761  OE1 GLU C 112      18.675  -8.572  10.912  1.00 38.93           O  
ATOM   4762  OE2 GLU C 112      19.494  -8.123  12.905  1.00 44.36           O  
ATOM   4763  N   ALA C 113      13.099  -9.575  11.662  1.00 28.77           N  
ATOM   4764  CA  ALA C 113      11.992 -10.190  10.916  1.00 29.17           C  
ATOM   4765  C   ALA C 113      10.724  -9.321  11.006  1.00 27.17           C  
ATOM   4766  O   ALA C 113      10.009  -9.175  10.018  1.00 27.80           O  
ATOM   4767  CB  ALA C 113      11.713 -11.597  11.428  1.00 27.78           C  
ATOM   4768  N   ASP C 114      10.477  -8.744  12.183  1.00 26.80           N  
ATOM   4769  CA  ASP C 114       9.322  -7.869  12.446  1.00 27.42           C  
ATOM   4770  C   ASP C 114       9.288  -6.653  11.532  1.00 27.60           C  
ATOM   4771  O   ASP C 114       8.221  -6.191  11.118  1.00 27.70           O  
ATOM   4772  CB  ASP C 114       9.369  -7.304  13.884  1.00 28.44           C  
ATOM   4773  CG  ASP C 114       9.106  -8.344  14.979  1.00 27.51           C  
ATOM   4774  OD1 ASP C 114       8.615  -9.442  14.688  1.00 37.18           O  
ATOM   4775  OD2 ASP C 114       9.385  -8.023  16.158  1.00 32.12           O  
ATOM   4776  N   VAL C 115      10.461  -6.083  11.277  1.00 28.06           N  
ATOM   4777  CA  VAL C 115      10.561  -4.896  10.429  1.00 27.16           C  
ATOM   4778  C   VAL C 115      10.284  -5.341   8.996  1.00 27.47           C  
ATOM   4779  O   VAL C 115       9.488  -4.739   8.314  1.00 27.33           O  
ATOM   4780  CB  VAL C 115      11.945  -4.220  10.529  1.00 28.69           C  
ATOM   4781  CG1 VAL C 115      11.992  -3.020   9.612  1.00 25.47           C  
ATOM   4782  CG2 VAL C 115      12.257  -3.789  11.981  1.00 27.58           C  
ATOM   4783  N   LYS C 116      10.937  -6.415   8.561  1.00 29.17           N  
ATOM   4784  CA  LYS C 116      10.720  -6.954   7.220  1.00 28.88           C  
ATOM   4785  C   LYS C 116       9.238  -7.280   7.009  1.00 28.98           C  
ATOM   4786  O   LYS C 116       8.663  -6.891   6.001  1.00 31.75           O  
ATOM   4787  CB  LYS C 116      11.628  -8.167   6.978  1.00 30.74           C  
ATOM   4788  CG  LYS C 116      13.073  -7.749   6.643  1.00 28.64           C  
ATOM   4789  CD  LYS C 116      14.030  -8.902   6.447  1.00 32.32           C  
ATOM   4790  CE  LYS C 116      14.563  -9.410   7.762  1.00 38.43           C  
ATOM   4791  NZ  LYS C 116      15.646 -10.389   7.536  1.00 34.80           N  
ATOM   4792  N   GLN C 117       8.616  -7.961   7.959  1.00 29.77           N  
ATOM   4793  CA  GLN C 117       7.184  -8.258   7.869  1.00 30.51           C  
ATOM   4794  C   GLN C 117       6.370  -6.996   7.710  1.00 28.56           C  
ATOM   4795  O   GLN C 117       5.448  -6.957   6.905  1.00 29.31           O  
ATOM   4796  CB  GLN C 117       6.666  -8.893   9.124  1.00 32.88           C  
ATOM   4797  CG  GLN C 117       7.066 -10.283   9.411  1.00 35.66           C  
ATOM   4798  CD  GLN C 117       6.312 -10.745  10.627  1.00 43.27           C  
ATOM   4799  OE1 GLN C 117       5.083 -10.857  10.577  1.00 48.22           O  
ATOM   4800  NE2 GLN C 117       7.022 -10.970  11.741  1.00 38.31           N  
ATOM   4801  N   THR C 118       6.693  -5.986   8.515  1.00 28.95           N  
ATOM   4802  CA  THR C 118       6.007  -4.707   8.463  1.00 28.53           C  
ATOM   4803  C   THR C 118       6.132  -4.102   7.086  1.00 28.58           C  
ATOM   4804  O   THR C 118       5.122  -3.717   6.503  1.00 30.50           O  
ATOM   4805  CB  THR C 118       6.507  -3.732   9.540  1.00 27.79           C  
ATOM   4806  OG1 THR C 118       6.423  -4.367  10.821  1.00 29.97           O  
ATOM   4807  CG2 THR C 118       5.675  -2.436   9.554  1.00 28.21           C  
ATOM   4808  N   PHE C 119       7.351  -4.044   6.541  1.00 28.07           N  
ATOM   4809  CA  PHE C 119       7.545  -3.486   5.205  1.00 28.94           C  
ATOM   4810  C   PHE C 119       6.823  -4.311   4.136  1.00 27.91           C  
ATOM   4811  O   PHE C 119       6.240  -3.754   3.211  1.00 29.18           O  
ATOM   4812  CB  PHE C 119       9.029  -3.350   4.829  1.00 28.01           C  
ATOM   4813  CG  PHE C 119       9.799  -2.356   5.660  1.00 31.34           C  
ATOM   4814  CD1 PHE C 119       9.152  -1.376   6.407  1.00 29.54           C  
ATOM   4815  CD2 PHE C 119      11.186  -2.344   5.616  1.00 31.68           C  
ATOM   4816  CE1 PHE C 119       9.884  -0.447   7.143  1.00 28.84           C  
ATOM   4817  CE2 PHE C 119      11.909  -1.424   6.352  1.00 32.18           C  
ATOM   4818  CZ  PHE C 119      11.258  -0.465   7.100  1.00 32.95           C  
ATOM   4819  N   ASP C 120       6.846  -5.632   4.277  1.00 28.85           N  
ATOM   4820  CA  ASP C 120       6.173  -6.503   3.324  1.00 28.67           C  
ATOM   4821  C   ASP C 120       4.658  -6.283   3.338  1.00 29.64           C  
ATOM   4822  O   ASP C 120       4.002  -6.377   2.304  1.00 28.34           O  
ATOM   4823  CB  ASP C 120       6.485  -7.980   3.620  1.00 31.51           C  
ATOM   4824  CG  ASP C 120       7.926  -8.367   3.264  1.00 31.84           C  
ATOM   4825  OD1 ASP C 120       8.647  -7.550   2.672  1.00 35.81           O  
ATOM   4826  OD2 ASP C 120       8.331  -9.493   3.601  1.00 39.32           O  
ATOM   4827  N   SER C 121       4.107  -6.022   4.520  1.00 29.79           N  
ATOM   4828  CA  SER C 121       2.675  -5.811   4.671  1.00 31.79           C  
ATOM   4829  C   SER C 121       2.281  -4.492   4.075  1.00 30.98           C  
ATOM   4830  O   SER C 121       1.191  -4.386   3.500  1.00 31.97           O  
ATOM   4831  CB  SER C 121       2.291  -5.831   6.137  1.00 31.66           C  
ATOM   4832  OG  SER C 121       2.690  -7.058   6.705  1.00 41.44           O  
ATOM   4833  N   ALA C 122       3.164  -3.497   4.236  1.00 30.18           N  
ATOM   4834  CA  ALA C 122       2.956  -2.153   3.697  1.00 29.54           C  
ATOM   4835  C   ALA C 122       2.930  -2.191   2.183  1.00 29.54           C  
ATOM   4836  O   ALA C 122       2.057  -1.589   1.577  1.00 32.02           O  
ATOM   4837  CB  ALA C 122       4.034  -1.209   4.169  1.00 28.09           C  
ATOM   4838  N   ALA C 123       3.910  -2.881   1.585  1.00 30.96           N  
ATOM   4839  CA  ALA C 123       4.015  -3.040   0.128  1.00 29.98           C  
ATOM   4840  C   ALA C 123       2.784  -3.751  -0.443  1.00 32.51           C  
ATOM   4841  O   ALA C 123       2.309  -3.439  -1.538  1.00 34.79           O  
ATOM   4842  CB  ALA C 123       5.303  -3.833  -0.241  1.00 31.41           C  
ATOM   4843  N   ARG C 124       2.277  -4.712   0.312  1.00 32.22           N  
ATOM   4844  CA  ARG C 124       1.106  -5.459  -0.067  1.00 33.39           C  
ATOM   4845  C   ARG C 124      -0.141  -4.554  -0.080  1.00 33.54           C  
ATOM   4846  O   ARG C 124      -0.980  -4.687  -0.949  1.00 35.78           O  
ATOM   4847  CB  ARG C 124       0.973  -6.634   0.906  1.00 33.92           C  
ATOM   4848  CG  ARG C 124       0.120  -7.728   0.457  1.00 37.78           C  
ATOM   4849  CD  ARG C 124       0.460  -9.042   1.176  1.00 37.12           C  
ATOM   4850  NE  ARG C 124       0.358  -8.979   2.636  1.00 44.25           N  
ATOM   4851  CZ  ARG C 124       1.372  -9.042   3.500  1.00 39.33           C  
ATOM   4852  NH1 ARG C 124       2.623  -9.185   3.095  1.00 43.02           N  
ATOM   4853  NH2 ARG C 124       1.116  -8.985   4.797  1.00 48.11           N  
ATOM   4854  N   LEU C 125      -0.240  -3.602   0.840  1.00 35.55           N  
ATOM   4855  CA  LEU C 125      -1.399  -2.711   0.889  1.00 35.75           C  
ATOM   4856  C   LEU C 125      -1.326  -1.659  -0.221  1.00 35.78           C  
ATOM   4857  O   LEU C 125      -2.324  -1.329  -0.856  1.00 39.63           O  
ATOM   4858  CB  LEU C 125      -1.497  -2.022   2.271  1.00 37.44           C  
ATOM   4859  CG  LEU C 125      -2.879  -1.633   2.856  1.00 40.84           C  
ATOM   4860  CD1 LEU C 125      -2.727  -0.903   4.212  1.00 43.59           C  
ATOM   4861  CD2 LEU C 125      -3.758  -0.812   1.890  1.00 50.32           C  
ATOM   4862  N   LEU C 126      -0.139  -1.147  -0.477  1.00 36.38           N  
ATOM   4863  CA  LEU C 126       0.034  -0.083  -1.459  1.00 35.27           C  
ATOM   4864  C   LEU C 126       0.055  -0.571  -2.907  1.00 36.05           C  
ATOM   4865  O   LEU C 126       0.418  -1.714  -3.202  1.00 36.62           O  
ATOM   4866  CB  LEU C 126       1.339   0.662  -1.170  1.00 35.17           C  
ATOM   4867  CG  LEU C 126       1.453   1.383   0.174  1.00 30.83           C  
ATOM   4868  CD1 LEU C 126       2.902   1.713   0.432  1.00 24.44           C  
ATOM   4869  CD2 LEU C 126       0.576   2.631   0.231  1.00 29.68           C  
ATOM   4870  N   THR C 127      -0.335   0.308  -3.819  1.00 36.34           N  
ATOM   4871  CA  THR C 127      -0.231  -0.007  -5.237  1.00 36.31           C  
ATOM   4872  C   THR C 127       0.946   0.794  -5.790  1.00 36.70           C  
ATOM   4873  O   THR C 127       1.543   1.621  -5.096  1.00 34.86           O  
ATOM   4874  CB  THR C 127      -1.525   0.290  -6.000  1.00 37.04           C  
ATOM   4875  OG1 THR C 127      -1.924   1.648  -5.783  1.00 36.74           O  
ATOM   4876  CG2 THR C 127      -2.637  -0.637  -5.535  1.00 34.40           C  
ATOM   4877  N   ASP C 128       1.300   0.503  -7.029  1.00 36.52           N  
ATOM   4878  CA  ASP C 128       2.377   1.173  -7.719  1.00 37.30           C  
ATOM   4879  C   ASP C 128       2.305   2.682  -7.456  1.00 35.15           C  
ATOM   4880  O   ASP C 128       1.272   3.306  -7.682  1.00 36.02           O  
ATOM   4881  CB  ASP C 128       2.236   0.858  -9.214  1.00 37.42           C  
ATOM   4882  CG  ASP C 128       3.368   1.390 -10.048  1.00 43.84           C  
ATOM   4883  OD1 ASP C 128       4.230   2.148  -9.538  1.00 37.91           O  
ATOM   4884  OD2 ASP C 128       3.381   1.042 -11.253  1.00 46.65           O  
ATOM   4885  N   GLY C 129       3.393   3.251  -6.943  1.00 34.15           N  
ATOM   4886  CA  GLY C 129       3.470   4.684  -6.671  1.00 33.24           C  
ATOM   4887  C   GLY C 129       3.014   5.113  -5.282  1.00 32.22           C  
ATOM   4888  O   GLY C 129       3.120   6.289  -4.938  1.00 33.08           O  
ATOM   4889  N   GLY C 130       2.492   4.173  -4.491  1.00 31.68           N  
ATOM   4890  CA  GLY C 130       2.059   4.454  -3.130  1.00 29.66           C  
ATOM   4891  C   GLY C 130       3.292   4.766  -2.299  1.00 29.77           C  
ATOM   4892  O   GLY C 130       4.378   4.278  -2.600  1.00 28.93           O  
ATOM   4893  N   LYS C 131       3.129   5.587  -1.266  1.00 31.51           N  
ATOM   4894  CA  LYS C 131       4.251   6.020  -0.431  1.00 31.08           C  
ATOM   4895  C   LYS C 131       4.244   5.437   0.958  1.00 30.25           C  
ATOM   4896  O   LYS C 131       3.203   5.290   1.568  1.00 30.29           O  
ATOM   4897  CB  LYS C 131       4.286   7.561  -0.332  1.00 32.72           C  
ATOM   4898  CG  LYS C 131       4.831   8.261  -1.578  1.00 38.41           C  
ATOM   4899  N   LEU C 132       5.432   5.106   1.442  1.00 29.26           N  
ATOM   4900  CA  LEU C 132       5.636   4.681   2.803  1.00 30.28           C  
ATOM   4901  C   LEU C 132       6.543   5.710   3.460  1.00 30.63           C  
ATOM   4902  O   LEU C 132       7.658   5.935   3.017  1.00 29.71           O  
ATOM   4903  CB  LEU C 132       6.256   3.293   2.881  1.00 31.81           C  
ATOM   4904  CG  LEU C 132       6.684   2.817   4.274  1.00 28.93           C  
ATOM   4905  CD1 LEU C 132       5.539   2.873   5.328  1.00 24.27           C  
ATOM   4906  CD2 LEU C 132       7.227   1.442   4.112  1.00 31.83           C  
ATOM   4907  N   LEU C 133       6.033   6.367   4.494  1.00 30.89           N  
ATOM   4908  CA  LEU C 133       6.809   7.329   5.235  1.00 30.28           C  
ATOM   4909  C   LEU C 133       6.977   6.881   6.666  1.00 29.50           C  
ATOM   4910  O   LEU C 133       6.005   6.495   7.331  1.00 29.78           O  
ATOM   4911  CB  LEU C 133       6.153   8.708   5.235  1.00 31.02           C  
ATOM   4912  CG  LEU C 133       6.303   9.697   4.089  1.00 31.33           C  
ATOM   4913  CD1 LEU C 133       5.701   9.148   2.826  1.00 36.99           C  
ATOM   4914  CD2 LEU C 133       5.631  10.991   4.485  1.00 32.18           C  
ATOM   4915  N   PHE C 134       8.202   6.987   7.162  1.00 29.93           N  
ATOM   4916  CA  PHE C 134       8.448   6.717   8.591  1.00 29.15           C  
ATOM   4917  C   PHE C 134       9.706   7.405   9.066  1.00 28.18           C  
ATOM   4918  O   PHE C 134      10.570   7.758   8.269  1.00 27.50           O  
ATOM   4919  CB  PHE C 134       8.539   5.230   8.902  1.00 31.39           C  
ATOM   4920  CG  PHE C 134       9.699   4.534   8.264  1.00 26.98           C  
ATOM   4921  CD1 PHE C 134      10.924   4.406   8.938  1.00 23.89           C  
ATOM   4922  CD2 PHE C 134       9.557   3.945   7.020  1.00 29.56           C  
ATOM   4923  CE1 PHE C 134      12.000   3.709   8.360  1.00 25.22           C  
ATOM   4924  CE2 PHE C 134      10.620   3.256   6.442  1.00 30.25           C  
ATOM   4925  CZ  PHE C 134      11.844   3.140   7.114  1.00 27.44           C  
ATOM   4926  N   ASP C 135       9.765   7.630  10.375  1.00 25.76           N  
ATOM   4927  CA  ASP C 135      10.902   8.244  11.030  1.00 27.70           C  
ATOM   4928  C   ASP C 135      11.306   7.397  12.217  1.00 27.43           C  
ATOM   4929  O   ASP C 135      10.450   6.882  12.933  1.00 30.33           O  
ATOM   4930  CB  ASP C 135      10.608   9.708  11.439  1.00 28.93           C  
ATOM   4931  CG  ASP C 135       9.502   9.838  12.450  1.00 31.57           C  
ATOM   4932  OD1 ASP C 135       8.303   9.758  12.061  1.00 27.53           O  
ATOM   4933  OD2 ASP C 135       9.839  10.082  13.632  1.00 34.00           O  
ATOM   4934  N   VAL C 136      12.609   7.294  12.433  1.00 26.13           N  
ATOM   4935  CA  VAL C 136      13.177   6.437  13.447  1.00 29.12           C  
ATOM   4936  C   VAL C 136      14.327   7.101  14.200  1.00 29.15           C  
ATOM   4937  O   VAL C 136      14.915   8.084  13.751  1.00 30.49           O  
ATOM   4938  CB  VAL C 136      13.706   5.130  12.788  1.00 29.18           C  
ATOM   4939  CG1 VAL C 136      12.552   4.223  12.386  1.00 29.00           C  
ATOM   4940  CG2 VAL C 136      14.629   5.455  11.575  1.00 26.52           C  
ATOM   4941  N   HIS C 137      14.645   6.573  15.365  1.00 29.76           N  
ATOM   4942  CA  HIS C 137      15.809   7.045  16.096  1.00 28.62           C  
ATOM   4943  C   HIS C 137      17.064   6.723  15.295  1.00 30.83           C  
ATOM   4944  O   HIS C 137      17.128   5.676  14.639  1.00 31.10           O  
ATOM   4945  CB  HIS C 137      15.979   6.309  17.428  1.00 29.99           C  
ATOM   4946  CG  HIS C 137      14.825   6.449  18.357  1.00 25.74           C  
ATOM   4947  ND1 HIS C 137      14.251   7.666  18.638  1.00 25.62           N  
ATOM   4948  CD2 HIS C 137      14.160   5.532  19.093  1.00 26.92           C  
ATOM   4949  CE1 HIS C 137      13.259   7.491  19.491  1.00 22.89           C  
ATOM   4950  NE2 HIS C 137      13.188   6.203  19.791  1.00 26.23           N  
ATOM   4951  N   SER C 138      18.054   7.609  15.376  1.00 31.87           N  
ATOM   4952  CA  SER C 138      19.364   7.381  14.765  1.00 31.37           C  
ATOM   4953  C   SER C 138      20.196   6.561  15.751  1.00 31.25           C  
ATOM   4954  O   SER C 138      19.894   6.554  16.950  1.00 29.73           O  
ATOM   4955  CB  SER C 138      20.080   8.696  14.516  1.00 30.37           C  
ATOM   4956  OG  SER C 138      20.423   9.288  15.754  1.00 31.66           O  
ATOM   4957  N   PRO C 139      21.218   5.834  15.254  1.00 29.90           N  
ATOM   4958  CA  PRO C 139      22.101   5.123  16.190  1.00 27.94           C  
ATOM   4959  C   PRO C 139      22.753   6.105  17.186  1.00 27.90           C  
ATOM   4960  O   PRO C 139      22.939   5.772  18.352  1.00 28.84           O  
ATOM   4961  CB  PRO C 139      23.128   4.449  15.268  1.00 28.09           C  
ATOM   4962  CG  PRO C 139      22.427   4.344  13.911  1.00 25.92           C  
ATOM   4963  CD  PRO C 139      21.561   5.571  13.841  1.00 31.03           C  
ATOM   4964  N   TYR C 140      23.041   7.327  16.738  1.00 29.13           N  
ATOM   4965  CA  TYR C 140      23.619   8.355  17.604  1.00 29.63           C  
ATOM   4966  C   TYR C 140      22.758   8.663  18.825  1.00 28.99           C  
ATOM   4967  O   TYR C 140      23.267   8.844  19.937  1.00 28.37           O  
ATOM   4968  CB  TYR C 140      23.823   9.651  16.823  1.00 30.79           C  
ATOM   4969  CG  TYR C 140      24.529  10.713  17.637  1.00 38.47           C  
ATOM   4970  CD1 TYR C 140      25.850  10.527  18.044  1.00 39.93           C  
ATOM   4971  CD2 TYR C 140      23.889  11.904  17.992  1.00 39.41           C  
ATOM   4972  CE1 TYR C 140      26.502  11.480  18.794  1.00 38.61           C  
ATOM   4973  CE2 TYR C 140      24.541  12.866  18.742  1.00 31.90           C  
ATOM   4974  CZ  TYR C 140      25.843  12.644  19.135  1.00 34.18           C  
ATOM   4975  OH  TYR C 140      26.505  13.574  19.874  1.00 38.66           O  
ATOM   4976  N   LYS C 141      21.454   8.761  18.608  1.00 29.34           N  
ATOM   4977  CA  LYS C 141      20.524   9.033  19.696  1.00 31.60           C  
ATOM   4978  C   LYS C 141      20.555   7.919  20.763  1.00 30.17           C  
ATOM   4979  O   LYS C 141      20.493   8.165  21.973  1.00 30.88           O  
ATOM   4980  CB  LYS C 141      19.111   9.223  19.147  1.00 29.13           C  
ATOM   4981  CG  LYS C 141      18.085   9.482  20.253  1.00 37.39           C  
ATOM   4982  CD  LYS C 141      16.800   9.950  19.676  1.00 38.05           C  
ATOM   4983  CE  LYS C 141      15.861  10.477  20.736  1.00 35.43           C  
ATOM   4984  NZ  LYS C 141      14.730  11.119  20.034  1.00 34.90           N  
HETATM 4985  N   MSE C 142      20.680   6.694  20.285  1.00 32.74           N  
HETATM 4986  CA  MSE C 142      20.707   5.521  21.137  0.50 33.33           C  
HETATM 4988  C   MSE C 142      21.937   5.535  22.052  1.00 34.51           C  
HETATM 4989  O   MSE C 142      21.848   5.213  23.240  1.00 36.92           O  
HETATM 4990  CB  MSE C 142      20.725   4.282  20.242  0.50 32.79           C  
HETATM 4992  CG  MSE C 142      20.217   3.060  20.897  0.50 32.51           C  
HETATM 4994 SE   MSE C 142      18.341   3.236  21.299  0.38 29.58          SE  
HETATM 4996  CE  MSE C 142      17.573   3.208  19.544  0.50 41.56           C  
ATOM   4998  N   GLU C 143      23.078   5.908  21.469  1.00 36.94           N  
ATOM   4999  CA  GLU C 143      24.368   5.980  22.156  1.00 36.77           C  
ATOM   5000  C   GLU C 143      24.517   7.226  23.046  1.00 38.18           C  
ATOM   5001  O   GLU C 143      25.421   7.275  23.882  1.00 40.48           O  
ATOM   5002  CB  GLU C 143      25.512   5.987  21.125  1.00 36.05           C  
ATOM   5003  CG  GLU C 143      25.530   4.800  20.181  1.00 39.77           C  
ATOM   5004  N   THR C 144      23.645   8.217  22.883  1.00 36.05           N  
ATOM   5005  CA  THR C 144      23.713   9.447  23.664  1.00 35.82           C  
ATOM   5006  C   THR C 144      22.494   9.661  24.592  1.00 36.53           C  
ATOM   5007  O   THR C 144      22.564   9.311  25.770  1.00 40.88           O  
ATOM   5008  CB  THR C 144      23.950  10.655  22.725  1.00 34.89           C  
ATOM   5009  OG1 THR C 144      22.891  10.739  21.758  1.00 33.24           O  
ATOM   5010  CG2 THR C 144      25.275  10.479  21.984  1.00 34.21           C  
ATOM   5011  N   LEU C 145      21.377  10.167  24.069  1.00 34.98           N  
ATOM   5012  CA  LEU C 145      20.191  10.473  24.884  1.00 36.16           C  
ATOM   5013  C   LEU C 145      19.525   9.300  25.600  1.00 35.34           C  
ATOM   5014  O   LEU C 145      18.811   9.510  26.585  1.00 36.00           O  
ATOM   5015  CB  LEU C 145      19.121  11.159  24.046  1.00 37.90           C  
ATOM   5016  CG  LEU C 145      19.447  12.555  23.526  1.00 40.00           C  
ATOM   5017  CD1 LEU C 145      18.304  13.045  22.665  1.00 40.13           C  
ATOM   5018  CD2 LEU C 145      19.698  13.506  24.690  1.00 40.36           C  
ATOM   5019  N   PHE C 146      19.706   8.085  25.090  1.00 34.29           N  
ATOM   5020  CA  PHE C 146      19.117   6.897  25.711  1.00 34.58           C  
ATOM   5021  C   PHE C 146      20.183   6.025  26.343  1.00 35.74           C  
ATOM   5022  O   PHE C 146      19.927   4.862  26.653  1.00 35.48           O  
ATOM   5023  CB  PHE C 146      18.315   6.077  24.681  1.00 32.39           C  
ATOM   5024  CG  PHE C 146      17.088   6.778  24.131  1.00 33.74           C  
ATOM   5025  CD1 PHE C 146      16.361   7.683  24.898  1.00 36.95           C  
ATOM   5026  CD2 PHE C 146      16.593   6.432  22.876  1.00 34.36           C  
ATOM   5027  CE1 PHE C 146      15.199   8.264  24.404  1.00 34.83           C  
ATOM   5028  CE2 PHE C 146      15.433   7.005  22.378  1.00 34.01           C  
ATOM   5029  CZ  PHE C 146      14.731   7.923  23.145  1.00 36.51           C  
ATOM   5030  N   ASN C 147      21.367   6.595  26.566  1.00 36.71           N  
ATOM   5031  CA  ASN C 147      22.485   5.840  27.098  1.00 37.73           C  
ATOM   5032  C   ASN C 147      22.702   6.111  28.577  1.00 36.89           C  
ATOM   5033  O   ASN C 147      23.640   6.798  28.968  1.00 37.49           O  
ATOM   5034  CB  ASN C 147      23.748   6.154  26.298  1.00 36.87           C  
ATOM   5035  CG  ASN C 147      24.869   5.183  26.578  1.00 39.07           C  
ATOM   5036  OD1 ASN C 147      24.700   4.219  27.332  1.00 42.59           O  
ATOM   5037  ND2 ASN C 147      26.024   5.424  25.964  1.00 40.06           N  
ATOM   5038  N   GLY C 148      21.813   5.566  29.389  1.00 36.22           N  
ATOM   5039  CA  GLY C 148      21.893   5.727  30.832  1.00 36.50           C  
ATOM   5040  C   GLY C 148      21.424   7.079  31.324  1.00 36.52           C  
ATOM   5041  O   GLY C 148      22.030   7.651  32.232  1.00 37.02           O  
ATOM   5042  N   LYS C 149      20.318   7.564  30.757  1.00 36.09           N  
ATOM   5043  CA  LYS C 149      19.768   8.886  31.087  1.00 34.93           C  
ATOM   5044  C   LYS C 149      18.462   8.821  31.886  1.00 35.29           C  
ATOM   5045  O   LYS C 149      17.690   7.867  31.763  1.00 36.27           O  
ATOM   5046  CB  LYS C 149      19.535   9.679  29.795  1.00 34.16           C  
ATOM   5047  CG  LYS C 149      20.789   9.915  28.984  1.00 32.22           C  
ATOM   5048  CD  LYS C 149      21.861  10.684  29.765  1.00 38.33           C  
ATOM   5049  CE  LYS C 149      22.995  11.149  28.868  1.00 40.37           C  
ATOM   5050  NZ  LYS C 149      23.766  10.017  28.317  1.00 48.51           N  
ATOM   5051  N   THR C 150      18.227   9.841  32.713  1.00 34.85           N  
ATOM   5052  CA  THR C 150      17.010   9.950  33.543  1.00 34.10           C  
ATOM   5053  C   THR C 150      16.231  11.176  33.119  1.00 33.14           C  
ATOM   5054  O   THR C 150      16.799  12.239  32.901  1.00 33.67           O  
ATOM   5055  CB  THR C 150      17.338  10.044  35.061  1.00 33.72           C  
ATOM   5056  OG1 THR C 150      18.116   8.905  35.431  1.00 36.81           O  
ATOM   5057  CG2 THR C 150      16.039  10.042  35.928  1.00 33.41           C  
ATOM   5058  N   TYR C 151      14.937  11.009  32.950  1.00 32.00           N  
ATOM   5059  CA  TYR C 151      14.057  12.095  32.542  1.00 31.67           C  
ATOM   5060  C   TYR C 151      12.917  12.085  33.532  1.00 32.55           C  
ATOM   5061  O   TYR C 151      12.484  11.023  33.943  1.00 32.12           O  
ATOM   5062  CB  TYR C 151      13.537  11.851  31.119  1.00 30.77           C  
ATOM   5063  CG  TYR C 151      14.654  11.785  30.147  1.00 29.44           C  
ATOM   5064  CD1 TYR C 151      15.325  12.951  29.772  1.00 30.36           C  
ATOM   5065  CD2 TYR C 151      15.085  10.577  29.615  1.00 30.19           C  
ATOM   5066  CE1 TYR C 151      16.393  12.909  28.910  1.00 31.46           C  
ATOM   5067  CE2 TYR C 151      16.158  10.529  28.727  1.00 32.48           C  
ATOM   5068  CZ  TYR C 151      16.797  11.705  28.371  1.00 32.83           C  
ATOM   5069  OH  TYR C 151      17.857  11.698  27.486  1.00 34.09           O  
ATOM   5070  N   ALA C 152      12.446  13.256  33.935  1.00 32.81           N  
ATOM   5071  CA  ALA C 152      11.395  13.320  34.933  1.00 32.29           C  
ATOM   5072  C   ALA C 152      10.764  14.690  34.920  1.00 32.81           C  
ATOM   5073  O   ALA C 152      11.443  15.688  34.690  1.00 35.43           O  
ATOM   5074  CB  ALA C 152      11.973  13.037  36.319  1.00 29.75           C  
ATOM   5075  N   THR C 153       9.458  14.747  35.128  1.00 33.58           N  
ATOM   5076  CA  THR C 153       8.800  16.028  35.245  1.00 34.95           C  
ATOM   5077  C   THR C 153       7.433  15.862  35.853  1.00 34.30           C  
ATOM   5078  O   THR C 153       7.008  14.740  36.161  1.00 35.42           O  
ATOM   5079  CB  THR C 153       8.784  16.845  33.935  1.00 37.00           C  
ATOM   5080  OG1 THR C 153       8.536  18.215  34.261  1.00 47.09           O  
ATOM   5081  CG2 THR C 153       7.756  16.337  32.939  1.00 34.45           C  
ATOM   5082  N   HIS C 154       6.797  16.990  36.138  1.00 33.27           N  
ATOM   5083  CA  HIS C 154       5.480  16.999  36.738  1.00 33.59           C  
ATOM   5084  C   HIS C 154       4.517  17.610  35.748  1.00 35.91           C  
ATOM   5085  O   HIS C 154       4.826  18.625  35.135  1.00 34.59           O  
ATOM   5086  CB  HIS C 154       5.405  17.866  37.999  1.00 32.86           C  
ATOM   5087  CG  HIS C 154       6.404  17.521  39.060  1.00 33.10           C  
ATOM   5088  ND1 HIS C 154       6.442  16.291  39.676  1.00 30.33           N  
ATOM   5089  CD2 HIS C 154       7.368  18.264  39.648  1.00 28.84           C  
ATOM   5090  CE1 HIS C 154       7.409  16.282  40.576  1.00 29.16           C  
ATOM   5091  NE2 HIS C 154       7.988  17.467  40.576  1.00 29.23           N  
ATOM   5092  N   ALA C 155       3.363  16.975  35.584  1.00 38.23           N  
ATOM   5093  CA  ALA C 155       2.280  17.514  34.764  1.00 38.87           C  
ATOM   5094  C   ALA C 155       1.158  17.775  35.754  1.00 37.56           C  
ATOM   5095  O   ALA C 155       1.373  17.679  36.954  1.00 37.31           O  
ATOM   5096  CB  ALA C 155       1.877  16.532  33.678  1.00 39.72           C  
ATOM   5097  N   GLU C 156      -0.035  18.111  35.286  1.00 38.38           N  
ATOM   5098  CA  GLU C 156      -1.140  18.392  36.214  1.00 38.62           C  
ATOM   5099  C   GLU C 156      -1.732  17.121  36.860  1.00 38.62           C  
ATOM   5100  O   GLU C 156      -2.050  17.097  38.050  1.00 37.11           O  
ATOM   5101  CB  GLU C 156      -2.261  19.149  35.473  1.00 39.64           C  
ATOM   5102  N   GLN C 157      -1.911  16.079  36.052  1.00 39.91           N  
ATOM   5103  CA  GLN C 157      -2.552  14.829  36.509  1.00 39.63           C  
ATOM   5104  C   GLN C 157      -1.544  13.770  36.974  1.00 39.06           C  
ATOM   5105  O   GLN C 157      -1.888  12.869  37.749  1.00 38.94           O  
ATOM   5106  CB  GLN C 157      -3.451  14.258  35.391  1.00 37.73           C  
ATOM   5107  N   SER C 158      -0.307  13.875  36.492  1.00 37.79           N  
ATOM   5108  CA  SER C 158       0.716  12.909  36.840  1.00 37.67           C  
ATOM   5109  C   SER C 158       2.168  13.428  36.734  1.00 37.14           C  
ATOM   5110  O   SER C 158       2.457  14.454  36.094  1.00 36.14           O  
ATOM   5111  CB  SER C 158       0.554  11.659  35.964  1.00 35.78           C  
ATOM   5112  OG  SER C 158       0.911  11.892  34.605  1.00 37.46           O  
ATOM   5113  N   SER C 159       3.067  12.689  37.374  1.00 33.91           N  
ATOM   5114  CA  SER C 159       4.498  12.969  37.318  1.00 33.09           C  
ATOM   5115  C   SER C 159       5.094  11.677  36.839  1.00 32.24           C  
ATOM   5116  O   SER C 159       4.495  10.619  37.030  1.00 32.26           O  
ATOM   5117  CB  SER C 159       5.059  13.321  38.710  1.00 32.98           C  
ATOM   5118  OG  SER C 159       4.442  14.471  39.258  1.00 33.17           O  
ATOM   5119  N   TYR C 160       6.261  11.740  36.226  1.00 32.30           N  
ATOM   5120  CA  TYR C 160       6.926  10.530  35.804  1.00 31.10           C  
ATOM   5121  C   TYR C 160       8.405  10.592  36.002  1.00 29.43           C  
ATOM   5122  O   TYR C 160       9.002  11.671  36.078  1.00 32.76           O  
ATOM   5123  CB  TYR C 160       6.651  10.209  34.317  1.00 32.32           C  
ATOM   5124  CG  TYR C 160       7.322  11.162  33.372  1.00 32.27           C  
ATOM   5125  CD1 TYR C 160       8.622  10.938  32.933  1.00 34.75           C  
ATOM   5126  CD2 TYR C 160       6.673  12.307  32.941  1.00 31.49           C  
ATOM   5127  CE1 TYR C 160       9.240  11.836  32.090  1.00 30.02           C  
ATOM   5128  CE2 TYR C 160       7.276  13.183  32.111  1.00 34.32           C  
ATOM   5129  CZ  TYR C 160       8.556  12.946  31.684  1.00 35.36           C  
ATOM   5130  OH  TYR C 160       9.151  13.847  30.841  1.00 28.85           O  
ATOM   5131  N   ILE C 161       8.983   9.400  36.072  1.00 31.50           N  
ATOM   5132  CA  ILE C 161      10.403   9.173  36.142  1.00 31.30           C  
ATOM   5133  C   ILE C 161      10.745   8.150  35.074  1.00 33.91           C  
ATOM   5134  O   ILE C 161      10.320   6.970  35.136  1.00 35.24           O  
ATOM   5135  CB  ILE C 161      10.868   8.656  37.492  1.00 31.87           C  
ATOM   5136  CG1 ILE C 161      10.564   9.689  38.595  1.00 35.68           C  
ATOM   5137  CG2 ILE C 161      12.361   8.381  37.434  1.00 30.31           C  
ATOM   5138  CD1 ILE C 161      10.948   9.263  40.017  1.00 29.55           C  
ATOM   5139  N   TRP C 162      11.554   8.597  34.118  1.00 33.61           N  
ATOM   5140  CA  TRP C 162      11.946   7.794  32.976  1.00 34.05           C  
ATOM   5141  C   TRP C 162      13.459   7.508  32.894  1.00 33.30           C  
ATOM   5142  O   TRP C 162      14.267   8.428  32.779  1.00 34.37           O  
ATOM   5143  CB  TRP C 162      11.407   8.519  31.728  1.00 37.41           C  
ATOM   5144  CG  TRP C 162      11.793   7.958  30.416  1.00 40.12           C  
ATOM   5145  CD1 TRP C 162      12.286   6.714  30.153  1.00 43.85           C  
ATOM   5146  CD2 TRP C 162      11.590   8.581  29.154  1.00 43.05           C  
ATOM   5147  NE1 TRP C 162      12.479   6.559  28.816  1.00 42.96           N  
ATOM   5148  CE2 TRP C 162      12.058   7.687  28.169  1.00 45.45           C  
ATOM   5149  CE3 TRP C 162      11.106   9.832  28.761  1.00 46.41           C  
ATOM   5150  CZ2 TRP C 162      12.048   7.999  26.795  1.00 45.33           C  
ATOM   5151  CZ3 TRP C 162      11.096  10.155  27.388  1.00 47.14           C  
ATOM   5152  CH2 TRP C 162      11.567   9.233  26.427  1.00 45.31           C  
ATOM   5153  N   PHE C 163      13.815   6.220  32.960  1.00 30.77           N  
ATOM   5154  CA  PHE C 163      15.184   5.751  32.807  1.00 33.52           C  
ATOM   5155  C   PHE C 163      15.312   5.143  31.408  1.00 35.29           C  
ATOM   5156  O   PHE C 163      14.513   4.283  31.011  1.00 34.28           O  
ATOM   5157  CB  PHE C 163      15.592   4.684  33.831  1.00 36.45           C  
ATOM   5158  CG  PHE C 163      15.510   5.132  35.266  1.00 41.47           C  
ATOM   5159  CD1 PHE C 163      15.774   6.454  35.636  1.00 44.10           C  
ATOM   5160  CD2 PHE C 163      15.257   4.200  36.262  1.00 45.18           C  
ATOM   5161  CE1 PHE C 163      15.705   6.842  36.957  1.00 44.17           C  
ATOM   5162  CE2 PHE C 163      15.199   4.579  37.582  1.00 48.06           C  
ATOM   5163  CZ  PHE C 163      15.424   5.900  37.931  1.00 45.36           C  
ATOM   5164  N   ALA C 164      16.294   5.643  30.663  1.00 34.15           N  
ATOM   5165  CA  ALA C 164      16.606   5.177  29.337  1.00 33.70           C  
ATOM   5166  C   ALA C 164      17.997   4.552  29.396  1.00 35.29           C  
ATOM   5167  O   ALA C 164      19.005   5.252  29.559  1.00 37.72           O  
ATOM   5168  CB  ALA C 164      16.555   6.341  28.352  1.00 30.79           C  
ATOM   5169  N   ASP C 165      18.052   3.232  29.277  1.00 35.86           N  
ATOM   5170  CA  ASP C 165      19.322   2.505  29.278  1.00 37.38           C  
ATOM   5171  C   ASP C 165      19.385   1.574  28.061  1.00 37.72           C  
ATOM   5172  O   ASP C 165      18.351   1.120  27.564  1.00 36.98           O  
ATOM   5173  CB  ASP C 165      19.490   1.689  30.573  1.00 38.98           C  
ATOM   5174  CG  ASP C 165      19.434   2.549  31.830  1.00 42.85           C  
ATOM   5175  OD1 ASP C 165      20.517   2.817  32.409  1.00 45.44           O  
ATOM   5176  OD2 ASP C 165      18.319   2.978  32.225  1.00 49.61           O  
ATOM   5177  N   PRO C 166      20.597   1.279  27.571  1.00 37.31           N  
ATOM   5178  CA  PRO C 166      20.653   0.346  26.454  1.00 37.53           C  
ATOM   5179  C   PRO C 166      20.164  -1.057  26.861  1.00 36.17           C  
ATOM   5180  O   PRO C 166      20.283  -1.428  28.015  1.00 32.86           O  
ATOM   5181  CB  PRO C 166      22.138   0.335  26.063  1.00 38.41           C  
ATOM   5182  CG  PRO C 166      22.862   0.820  27.273  1.00 39.90           C  
ATOM   5183  CD  PRO C 166      21.931   1.750  27.983  1.00 38.77           C  
ATOM   5184  N   GLY C 167      19.598  -1.789  25.906  1.00 35.34           N  
ATOM   5185  CA  GLY C 167      19.076  -3.136  26.125  1.00 34.89           C  
ATOM   5186  C   GLY C 167      20.020  -4.218  25.636  1.00 34.66           C  
ATOM   5187  O   GLY C 167      21.193  -3.963  25.391  1.00 35.08           O  
ATOM   5188  N   GLU C 168      19.491  -5.421  25.451  1.00 35.38           N  
ATOM   5189  CA  GLU C 168      20.310  -6.573  25.075  1.00 36.86           C  
ATOM   5190  C   GLU C 168      20.911  -6.521  23.668  1.00 37.15           C  
ATOM   5191  O   GLU C 168      22.057  -6.928  23.493  1.00 38.12           O  
ATOM   5192  CB  GLU C 168      19.529  -7.892  25.282  1.00 36.51           C  
ATOM   5193  N   GLU C 169      20.157  -6.039  22.679  1.00 36.93           N  
ATOM   5194  CA  GLU C 169      20.646  -5.974  21.299  1.00 36.64           C  
ATOM   5195  C   GLU C 169      21.321  -4.635  21.009  1.00 35.81           C  
ATOM   5196  O   GLU C 169      21.034  -3.644  21.670  1.00 34.94           O  
ATOM   5197  CB  GLU C 169      19.513  -6.214  20.285  1.00 36.63           C  
ATOM   5198  CG  GLU C 169      18.869  -7.609  20.371  1.00 38.83           C  
ATOM   5199  CD  GLU C 169      19.810  -8.753  19.996  1.00 44.45           C  
ATOM   5200  OE1 GLU C 169      20.712  -8.565  19.146  1.00 39.31           O  
ATOM   5201  OE2 GLU C 169      19.631  -9.865  20.550  1.00 52.15           O  
ATOM   5202  N   PRO C 170      22.270  -4.619  20.064  1.00 33.74           N  
ATOM   5203  CA  PRO C 170      22.880  -3.345  19.716  1.00 34.02           C  
ATOM   5204  C   PRO C 170      21.831  -2.318  19.291  1.00 32.52           C  
ATOM   5205  O   PRO C 170      20.804  -2.673  18.727  1.00 33.34           O  
ATOM   5206  CB  PRO C 170      23.796  -3.691  18.534  1.00 34.72           C  
ATOM   5207  CG  PRO C 170      23.493  -5.104  18.160  1.00 35.54           C  
ATOM   5208  CD  PRO C 170      22.852  -5.747  19.321  1.00 32.61           C  
ATOM   5209  N   LEU C 171      22.091  -1.053  19.575  1.00 32.40           N  
ATOM   5210  CA  LEU C 171      21.177   0.037  19.246  1.00 30.01           C  
ATOM   5211  C   LEU C 171      19.750  -0.150  19.805  1.00 29.80           C  
ATOM   5212  O   LEU C 171      18.782   0.303  19.219  1.00 27.08           O  
ATOM   5213  CB  LEU C 171      21.165   0.290  17.743  1.00 29.77           C  
ATOM   5214  CG  LEU C 171      22.554   0.561  17.149  1.00 26.88           C  
ATOM   5215  CD1 LEU C 171      22.471   0.670  15.678  1.00 20.66           C  
ATOM   5216  CD2 LEU C 171      23.194   1.805  17.760  1.00 31.07           C  
ATOM   5217  N   SER C 172      19.640  -0.808  20.952  1.00 31.32           N  
ATOM   5218  CA  SER C 172      18.346  -0.996  21.651  1.00 32.30           C  
ATOM   5219  C   SER C 172      18.293  -0.236  22.995  1.00 32.79           C  
ATOM   5220  O   SER C 172      19.331   0.095  23.589  1.00 30.98           O  
ATOM   5221  CB  SER C 172      18.077  -2.481  21.917  1.00 30.08           C  
ATOM   5222  OG  SER C 172      19.096  -3.044  22.702  1.00 32.44           O  
ATOM   5223  N   VAL C 173      17.074   0.029  23.468  1.00 30.60           N  
ATOM   5224  CA  VAL C 173      16.878   0.752  24.710  1.00 31.16           C  
ATOM   5225  C   VAL C 173      15.706   0.138  25.461  1.00 28.90           C  
ATOM   5226  O   VAL C 173      14.736  -0.319  24.846  1.00 23.94           O  
ATOM   5227  CB  VAL C 173      16.615   2.287  24.463  1.00 30.34           C  
ATOM   5228  CG1 VAL C 173      15.412   2.502  23.588  1.00 34.15           C  
ATOM   5229  CG2 VAL C 173      16.444   3.049  25.763  1.00 27.60           C  
ATOM   5230  N   VAL C 174      15.855   0.080  26.781  1.00 32.01           N  
ATOM   5231  CA  VAL C 174      14.807  -0.351  27.687  1.00 30.29           C  
ATOM   5232  C   VAL C 174      14.370   0.948  28.369  1.00 34.21           C  
ATOM   5233  O   VAL C 174      15.175   1.625  29.029  1.00 34.47           O  
ATOM   5234  CB  VAL C 174      15.281  -1.317  28.774  1.00 32.34           C  
ATOM   5235  CG1 VAL C 174      14.097  -1.662  29.674  1.00 23.68           C  
ATOM   5236  CG2 VAL C 174      15.882  -2.577  28.175  1.00 24.83           C  
ATOM   5237  N   HIS C 175      13.125   1.340  28.127  1.00 33.75           N  
ATOM   5238  CA  HIS C 175      12.577   2.536  28.730  1.00 31.93           C  
ATOM   5239  C   HIS C 175      11.849   2.090  29.995  1.00 33.25           C  
ATOM   5240  O   HIS C 175      10.717   1.605  29.885  1.00 32.29           O  
ATOM   5241  CB  HIS C 175      11.572   3.193  27.795  1.00 30.15           C  
ATOM   5242  CG  HIS C 175      12.178   3.763  26.547  1.00 29.66           C  
ATOM   5243  ND1 HIS C 175      13.243   4.635  26.579  1.00 31.30           N  
ATOM   5244  CD2 HIS C 175      11.824   3.642  25.244  1.00 27.37           C  
ATOM   5245  CE1 HIS C 175      13.542   5.004  25.342  1.00 35.71           C  
ATOM   5246  NE2 HIS C 175      12.686   4.426  24.516  1.00 31.63           N  
ATOM   5247  N   GLU C 176      12.500   2.210  31.165  1.00 34.19           N  
ATOM   5248  CA  GLU C 176      11.863   1.864  32.464  1.00 33.51           C  
ATOM   5249  C   GLU C 176      11.127   3.126  32.913  1.00 35.02           C  
ATOM   5250  O   GLU C 176      11.732   4.145  33.272  1.00 35.73           O  
ATOM   5251  CB  GLU C 176      12.867   1.414  33.537  1.00 34.30           C  
ATOM   5252  CG  GLU C 176      13.548   0.047  33.318  1.00 32.11           C  
ATOM   5253  CD  GLU C 176      12.638  -1.150  33.483  1.00 43.26           C  
ATOM   5254  OE1 GLU C 176      11.422  -0.980  33.731  1.00 49.34           O  
ATOM   5255  OE2 GLU C 176      13.156  -2.285  33.373  1.00 48.36           O  
ATOM   5256  N   LEU C 177       9.806   3.044  32.879  1.00 36.16           N  
ATOM   5257  CA  LEU C 177       8.951   4.180  33.143  1.00 35.53           C  
ATOM   5258  C   LEU C 177       8.168   3.987  34.450  1.00 35.30           C  
ATOM   5259  O   LEU C 177       7.768   2.862  34.806  1.00 36.71           O  
ATOM   5260  CB  LEU C 177       7.988   4.317  31.951  1.00 34.56           C  
ATOM   5261  CG  LEU C 177       7.784   5.690  31.295  1.00 41.56           C  
ATOM   5262  CD1 LEU C 177       9.114   6.231  30.798  1.00 37.05           C  
ATOM   5263  CD2 LEU C 177       6.823   5.613  30.124  1.00 37.50           C  
ATOM   5264  N   THR C 178       7.985   5.081  35.191  1.00 36.71           N  
ATOM   5265  CA  THR C 178       7.135   5.078  36.386  1.00 35.38           C  
ATOM   5266  C   THR C 178       6.321   6.370  36.414  1.00 35.31           C  
ATOM   5267  O   THR C 178       6.885   7.469  36.301  1.00 36.28           O  
ATOM   5268  CB  THR C 178       7.927   4.942  37.685  1.00 36.36           C  
ATOM   5269  OG1 THR C 178       8.658   3.706  37.665  1.00 40.82           O  
ATOM   5270  CG2 THR C 178       6.961   4.960  38.894  1.00 35.83           C  
ATOM   5271  N   PHE C 179       5.002   6.214  36.535  1.00 35.07           N  
ATOM   5272  CA  PHE C 179       4.053   7.317  36.621  1.00 34.18           C  
ATOM   5273  C   PHE C 179       3.375   7.316  37.981  1.00 34.46           C  
ATOM   5274  O   PHE C 179       2.944   6.253  38.466  1.00 32.48           O  
ATOM   5275  CB  PHE C 179       2.942   7.161  35.583  1.00 35.91           C  
ATOM   5276  CG  PHE C 179       3.440   7.076  34.169  1.00 39.88           C  
ATOM   5277  CD1 PHE C 179       3.827   5.844  33.618  1.00 44.00           C  
ATOM   5278  CD2 PHE C 179       3.522   8.212  33.392  1.00 41.61           C  
ATOM   5279  CE1 PHE C 179       4.303   5.762  32.306  1.00 45.83           C  
ATOM   5280  CE2 PHE C 179       3.993   8.143  32.082  1.00 42.47           C  
ATOM   5281  CZ  PHE C 179       4.381   6.915  31.541  1.00 40.96           C  
ATOM   5282  N   PHE C 180       3.275   8.508  38.574  1.00 33.01           N  
ATOM   5283  CA  PHE C 180       2.532   8.736  39.803  1.00 32.54           C  
ATOM   5284  C   PHE C 180       1.343   9.593  39.394  1.00 33.68           C  
ATOM   5285  O   PHE C 180       1.508  10.765  39.048  1.00 33.23           O  
ATOM   5286  CB  PHE C 180       3.388   9.446  40.858  1.00 33.10           C  
ATOM   5287  CG  PHE C 180       4.535   8.611  41.367  1.00 27.00           C  
ATOM   5288  CD1 PHE C 180       4.351   7.750  42.423  1.00 25.76           C  
ATOM   5289  CD2 PHE C 180       5.777   8.678  40.780  1.00 28.10           C  
ATOM   5290  CE1 PHE C 180       5.383   6.991  42.900  1.00 28.07           C  
ATOM   5291  CE2 PHE C 180       6.825   7.917  41.270  1.00 31.18           C  
ATOM   5292  CZ  PHE C 180       6.603   7.061  42.334  1.00 30.76           C  
ATOM   5293  N   ILE C 181       0.154   8.996  39.441  1.00 34.94           N  
ATOM   5294  CA  ILE C 181      -1.092   9.629  38.972  1.00 35.50           C  
ATOM   5295  C   ILE C 181      -1.954  10.100  40.117  1.00 33.09           C  
ATOM   5296  O   ILE C 181      -2.342   9.290  40.947  1.00 32.58           O  
ATOM   5297  CB  ILE C 181      -1.924   8.622  38.107  1.00 34.79           C  
ATOM   5298  CG1 ILE C 181      -1.095   8.127  36.903  1.00 35.28           C  
ATOM   5299  CG2 ILE C 181      -3.218   9.272  37.631  1.00 37.23           C  
ATOM   5300  CD1 ILE C 181      -1.735   6.998  36.103  1.00 36.51           C  
ATOM   5301  N   GLU C 182      -2.283  11.389  40.160  1.00 31.72           N  
ATOM   5302  CA  GLU C 182      -3.104  11.901  41.258  1.00 34.40           C  
ATOM   5303  C   GLU C 182      -4.512  11.311  41.297  1.00 36.82           C  
ATOM   5304  O   GLU C 182      -5.174  11.201  40.276  1.00 37.52           O  
ATOM   5305  CB  GLU C 182      -3.206  13.426  41.232  1.00 33.60           C  
ATOM   5306  CG  GLU C 182      -3.725  13.992  42.560  1.00 38.35           C  
ATOM   5307  CD  GLU C 182      -3.691  15.503  42.627  1.00 37.24           C  
ATOM   5308  OE1 GLU C 182      -3.735  16.136  41.561  1.00 47.15           O  
ATOM   5309  OE2 GLU C 182      -3.644  16.050  43.748  1.00 44.60           O  
ATOM   5310  N   GLY C 183      -4.975  10.959  42.487  1.00 37.44           N  
ATOM   5311  CA  GLY C 183      -6.303  10.398  42.669  1.00 39.17           C  
ATOM   5312  C   GLY C 183      -7.277  11.465  43.128  1.00 40.57           C  
ATOM   5313  O   GLY C 183      -6.878  12.591  43.445  1.00 40.43           O  
ATOM   5314  N   GLU C 184      -8.559  11.102  43.175  1.00 42.08           N  
ATOM   5315  CA  GLU C 184      -9.608  12.031  43.583  1.00 42.86           C  
ATOM   5316  C   GLU C 184      -9.361  12.593  44.974  1.00 44.06           C  
ATOM   5317  O   GLU C 184      -9.724  13.736  45.246  1.00 45.51           O  
ATOM   5318  CB  GLU C 184     -10.986  11.358  43.514  1.00 43.59           C  
ATOM   5319  N   ASP C 185      -8.718  11.805  45.844  1.00 44.94           N  
ATOM   5320  CA  ASP C 185      -8.417  12.213  47.226  1.00 44.14           C  
ATOM   5321  C   ASP C 185      -7.024  12.840  47.436  1.00 43.42           C  
ATOM   5322  O   ASP C 185      -6.554  12.940  48.568  1.00 44.33           O  
ATOM   5323  CB  ASP C 185      -8.601  11.021  48.181  1.00 45.34           C  
ATOM   5324  CG  ASP C 185      -7.597   9.891  47.942  1.00 46.17           C  
ATOM   5325  OD1 ASP C 185      -6.802   9.952  46.977  1.00 43.62           O  
ATOM   5326  OD2 ASP C 185      -7.613   8.934  48.741  1.00 50.69           O  
ATOM   5327  N   GLY C 186      -6.353  13.241  46.362  1.00 42.71           N  
ATOM   5328  CA  GLY C 186      -5.047  13.904  46.497  1.00 41.87           C  
ATOM   5329  C   GLY C 186      -3.835  13.005  46.746  1.00 41.07           C  
ATOM   5330  O   GLY C 186      -2.700  13.491  46.786  1.00 39.27           O  
ATOM   5331  N   ARG C 187      -4.079  11.704  46.917  1.00 39.38           N  
ATOM   5332  CA  ARG C 187      -3.029  10.718  47.066  1.00 36.52           C  
ATOM   5333  C   ARG C 187      -2.759  10.164  45.666  1.00 35.03           C  
ATOM   5334  O   ARG C 187      -3.573  10.322  44.767  1.00 35.21           O  
ATOM   5335  CB  ARG C 187      -3.443   9.628  48.048  1.00 35.77           C  
ATOM   5336  CG  ARG C 187      -3.656  10.140  49.469  1.00 34.66           C  
ATOM   5337  CD  ARG C 187      -3.880   8.974  50.408  1.00 36.13           C  
ATOM   5338  NE  ARG C 187      -2.673   8.152  50.471  1.00 39.42           N  
ATOM   5339  CZ  ARG C 187      -2.638   6.846  50.722  1.00 38.35           C  
ATOM   5340  NH1 ARG C 187      -3.747   6.151  50.905  1.00 36.01           N  
ATOM   5341  NH2 ARG C 187      -1.470   6.217  50.742  1.00 40.63           N  
ATOM   5342  N   TYR C 188      -1.620   9.512  45.484  1.00 33.98           N  
ATOM   5343  CA  TYR C 188      -1.194   9.048  44.174  1.00 31.92           C  
ATOM   5344  C   TYR C 188      -1.144   7.529  44.026  1.00 32.60           C  
ATOM   5345  O   TYR C 188      -0.944   6.787  45.002  1.00 32.84           O  
ATOM   5346  CB  TYR C 188       0.189   9.640  43.837  1.00 30.58           C  
ATOM   5347  CG  TYR C 188       0.176  11.135  43.584  1.00 29.86           C  
ATOM   5348  CD1 TYR C 188      -0.050  12.025  44.612  1.00 27.15           C  
ATOM   5349  CD2 TYR C 188       0.402  11.654  42.314  1.00 31.17           C  
ATOM   5350  CE1 TYR C 188      -0.070  13.383  44.388  1.00 27.98           C  
ATOM   5351  CE2 TYR C 188       0.372  13.023  42.077  1.00 31.44           C  
ATOM   5352  CZ  TYR C 188       0.127  13.874  43.123  1.00 30.42           C  
ATOM   5353  OH  TYR C 188       0.097  15.241  42.941  1.00 35.52           O  
ATOM   5354  N   ASP C 189      -1.370   7.081  42.787  1.00 34.26           N  
ATOM   5355  CA  ASP C 189      -1.250   5.672  42.412  1.00 34.06           C  
ATOM   5356  C   ASP C 189      -0.049   5.528  41.490  1.00 31.66           C  
ATOM   5357  O   ASP C 189       0.176   6.349  40.609  1.00 32.56           O  
ATOM   5358  CB  ASP C 189      -2.529   5.151  41.788  1.00 34.70           C  
ATOM   5359  CG  ASP C 189      -3.664   5.129  42.774  1.00 43.64           C  
ATOM   5360  OD1 ASP C 189      -3.940   4.027  43.358  1.00 32.91           O  
ATOM   5361  OD2 ASP C 189      -4.229   6.226  43.039  1.00 47.67           O  
ATOM   5362  N   ARG C 190       0.768   4.517  41.748  1.00 31.15           N  
ATOM   5363  CA  ARG C 190       1.967   4.264  40.954  1.00 32.13           C  
ATOM   5364  C   ARG C 190       1.752   3.185  39.863  1.00 32.57           C  
ATOM   5365  O   ARG C 190       1.177   2.138  40.129  1.00 32.83           O  
ATOM   5366  CB  ARG C 190       3.101   3.821  41.873  1.00 29.91           C  
ATOM   5367  CG  ARG C 190       4.410   3.569  41.142  1.00 30.58           C  
ATOM   5368  CD  ARG C 190       5.486   3.198  42.110  1.00 32.38           C  
ATOM   5369  NE  ARG C 190       6.708   2.868  41.408  1.00 29.62           N  
ATOM   5370  CZ  ARG C 190       7.904   2.757  41.977  1.00 39.30           C  
ATOM   5371  NH1 ARG C 190       8.080   2.991  43.274  1.00 37.94           N  
ATOM   5372  NH2 ARG C 190       8.956   2.454  41.223  1.00 41.04           N  
ATOM   5373  N   VAL C 191       2.236   3.464  38.652  1.00 34.03           N  
ATOM   5374  CA  VAL C 191       2.188   2.519  37.518  1.00 34.36           C  
ATOM   5375  C   VAL C 191       3.598   2.420  36.911  1.00 33.96           C  
ATOM   5376  O   VAL C 191       4.195   3.436  36.572  1.00 33.79           O  
ATOM   5377  CB  VAL C 191       1.200   2.945  36.425  1.00 35.50           C  
ATOM   5378  CG1 VAL C 191       1.129   1.862  35.358  1.00 39.15           C  
ATOM   5379  CG2 VAL C 191      -0.189   3.193  36.995  1.00 31.91           C  
ATOM   5380  N   ASP C 192       4.145   1.206  36.843  1.00 32.95           N  
ATOM   5381  CA  ASP C 192       5.494   0.975  36.311  1.00 34.94           C  
ATOM   5382  C   ASP C 192       5.378   0.199  35.019  1.00 35.62           C  
ATOM   5383  O   ASP C 192       4.709  -0.831  34.976  1.00 32.51           O  
ATOM   5384  CB  ASP C 192       6.341   0.131  37.261  1.00 36.93           C  
ATOM   5385  CG  ASP C 192       6.485   0.747  38.626  1.00 39.97           C  
ATOM   5386  OD1 ASP C 192       6.745   1.967  38.690  1.00 44.80           O  
ATOM   5387  OD2 ASP C 192       6.363  -0.009  39.613  1.00 41.91           O  
ATOM   5388  N   GLU C 193       6.064   0.688  33.998  1.00 34.87           N  
ATOM   5389  CA  GLU C 193       6.058   0.103  32.676  1.00 37.26           C  
ATOM   5390  C   GLU C 193       7.456   0.027  32.056  1.00 36.01           C  
ATOM   5391  O   GLU C 193       8.350   0.800  32.409  1.00 36.43           O  
ATOM   5392  CB  GLU C 193       5.210   0.955  31.749  1.00 38.79           C  
ATOM   5393  CG  GLU C 193       3.750   0.792  31.943  1.00 40.33           C  
ATOM   5394  CD  GLU C 193       2.976   1.297  30.756  1.00 45.03           C  
ATOM   5395  OE1 GLU C 193       3.550   2.083  29.959  1.00 47.48           O  
ATOM   5396  OE2 GLU C 193       1.795   0.919  30.621  1.00 50.80           O  
ATOM   5397  N   THR C 194       7.613  -0.902  31.118  1.00 32.35           N  
ATOM   5398  CA  THR C 194       8.865  -1.074  30.430  1.00 32.19           C  
ATOM   5399  C   THR C 194       8.543  -1.197  28.960  1.00 31.27           C  
ATOM   5400  O   THR C 194       7.790  -2.072  28.555  1.00 30.17           O  
ATOM   5401  CB  THR C 194       9.626  -2.306  30.927  1.00 33.37           C  
ATOM   5402  OG1 THR C 194       9.665  -2.285  32.361  1.00 38.96           O  
ATOM   5403  CG2 THR C 194      11.062  -2.332  30.368  1.00 29.90           C  
ATOM   5404  N   HIS C 195       9.107  -0.283  28.182  1.00 31.93           N  
ATOM   5405  CA  HIS C 195       8.944  -0.234  26.744  1.00 33.04           C  
ATOM   5406  C   HIS C 195      10.303  -0.533  26.161  1.00 31.01           C  
ATOM   5407  O   HIS C 195      11.326  -0.221  26.760  1.00 30.46           O  
ATOM   5408  CB  HIS C 195       8.465   1.159  26.288  1.00 33.87           C  
ATOM   5409  CG  HIS C 195       7.161   1.564  26.894  1.00 38.47           C  
ATOM   5410  ND1 HIS C 195       5.949   1.126  26.410  1.00 46.78           N  
ATOM   5411  CD2 HIS C 195       6.878   2.320  27.980  1.00 47.41           C  
ATOM   5412  CE1 HIS C 195       4.976   1.604  27.162  1.00 41.66           C  
ATOM   5413  NE2 HIS C 195       5.512   2.329  28.122  1.00 41.22           N  
ATOM   5414  N   HIS C 196      10.294  -1.157  24.994  1.00 30.90           N  
ATOM   5415  CA  HIS C 196      11.504  -1.545  24.306  1.00 28.46           C  
ATOM   5416  C   HIS C 196      11.484  -0.981  22.923  1.00 26.99           C  
ATOM   5417  O   HIS C 196      10.498  -1.147  22.211  1.00 25.44           O  
ATOM   5418  CB  HIS C 196      11.597  -3.074  24.231  1.00 29.46           C  
ATOM   5419  CG  HIS C 196      11.741  -3.717  25.569  1.00 27.98           C  
ATOM   5420  ND1 HIS C 196      12.947  -3.777  26.228  1.00 29.57           N  
ATOM   5421  CD2 HIS C 196      10.829  -4.280  26.394  1.00 31.41           C  
ATOM   5422  CE1 HIS C 196      12.775  -4.363  27.402  1.00 31.68           C  
ATOM   5423  NE2 HIS C 196      11.500  -4.676  27.527  1.00 31.17           N  
ATOM   5424  N   GLN C 197      12.565  -0.284  22.572  1.00 24.55           N  
ATOM   5425  CA  GLN C 197      12.768   0.233  21.249  1.00 25.42           C  
ATOM   5426  C   GLN C 197      14.148  -0.208  20.770  1.00 27.11           C  
ATOM   5427  O   GLN C 197      15.063  -0.423  21.570  1.00 25.04           O  
ATOM   5428  CB  GLN C 197      12.673   1.780  21.184  1.00 24.49           C  
ATOM   5429  CG  GLN C 197      11.242   2.325  21.297  1.00 22.44           C  
ATOM   5430  CD  GLN C 197      11.182   3.791  20.964  1.00 21.19           C  
ATOM   5431  OE1 GLN C 197      11.958   4.565  21.498  1.00 25.85           O  
ATOM   5432  NE2 GLN C 197      10.254   4.183  20.082  1.00 17.62           N  
ATOM   5433  N   ARG C 198      14.278  -0.317  19.452  1.00 27.33           N  
ATOM   5434  CA  ARG C 198      15.498  -0.765  18.801  1.00 26.49           C  
ATOM   5435  C   ARG C 198      15.572  -0.137  17.417  1.00 24.97           C  
ATOM   5436  O   ARG C 198      14.592  -0.116  16.690  1.00 24.38           O  
ATOM   5437  CB  ARG C 198      15.506  -2.299  18.715  1.00 26.97           C  
ATOM   5438  CG  ARG C 198      16.634  -2.870  17.888  1.00 25.11           C  
ATOM   5439  CD  ARG C 198      16.625  -4.389  17.925  1.00 26.13           C  
ATOM   5440  NE  ARG C 198      17.772  -4.895  17.194  1.00 28.32           N  
ATOM   5441  CZ  ARG C 198      18.029  -6.176  16.967  1.00 28.73           C  
ATOM   5442  NH1 ARG C 198      17.211  -7.128  17.402  1.00 29.54           N  
ATOM   5443  NH2 ARG C 198      19.113  -6.490  16.279  1.00 27.75           N  
ATOM   5444  N   THR C 199      16.744   0.363  17.064  1.00 22.38           N  
ATOM   5445  CA  THR C 199      16.932   0.980  15.763  1.00 24.83           C  
ATOM   5446  C   THR C 199      18.092   0.276  15.071  1.00 24.73           C  
ATOM   5447  O   THR C 199      18.645  -0.710  15.601  1.00 26.40           O  
ATOM   5448  CB  THR C 199      17.076   2.504  15.886  1.00 21.82           C  
ATOM   5449  OG1 THR C 199      16.836   3.101  14.614  1.00 17.07           O  
ATOM   5450  CG2 THR C 199      18.453   2.949  16.411  1.00 25.50           C  
ATOM   5451  N   TYR C 200      18.361   0.704  13.852  1.00 27.23           N  
ATOM   5452  CA  TYR C 200      19.422   0.156  13.003  1.00 25.73           C  
ATOM   5453  C   TYR C 200      20.052   1.298  12.237  1.00 25.64           C  
ATOM   5454  O   TYR C 200      19.468   2.384  12.145  1.00 26.63           O  
ATOM   5455  CB  TYR C 200      18.844  -0.868  12.028  1.00 22.71           C  
ATOM   5456  CG  TYR C 200      18.168  -2.045  12.688  1.00 24.00           C  
ATOM   5457  CD1 TYR C 200      16.846  -1.946  13.133  1.00 20.42           C  
ATOM   5458  CD2 TYR C 200      18.833  -3.271  12.854  1.00 19.29           C  
ATOM   5459  CE1 TYR C 200      16.207  -3.016  13.734  1.00 21.16           C  
ATOM   5460  CE2 TYR C 200      18.200  -4.349  13.449  1.00 18.86           C  
ATOM   5461  CZ  TYR C 200      16.881  -4.217  13.898  1.00 17.85           C  
ATOM   5462  OH  TYR C 200      16.222  -5.268  14.509  1.00 23.67           O  
ATOM   5463  N   PRO C 201      21.269   1.090  11.691  1.00 28.90           N  
ATOM   5464  CA  PRO C 201      21.823   2.149  10.867  1.00 29.09           C  
ATOM   5465  C   PRO C 201      20.887   2.354   9.668  1.00 29.39           C  
ATOM   5466  O   PRO C 201      20.267   1.391   9.212  1.00 27.68           O  
ATOM   5467  CB  PRO C 201      23.177   1.588  10.415  1.00 29.59           C  
ATOM   5468  CG  PRO C 201      23.492   0.503  11.373  1.00 31.67           C  
ATOM   5469  CD  PRO C 201      22.180  -0.063  11.795  1.00 30.96           C  
ATOM   5470  N   PRO C 202      20.786   3.585   9.146  1.00 29.34           N  
ATOM   5471  CA  PRO C 202      19.870   3.802   8.018  1.00 28.88           C  
ATOM   5472  C   PRO C 202      20.048   2.846   6.831  1.00 28.54           C  
ATOM   5473  O   PRO C 202      19.057   2.471   6.209  1.00 28.11           O  
ATOM   5474  CB  PRO C 202      20.135   5.253   7.609  1.00 28.81           C  
ATOM   5475  CG  PRO C 202      20.828   5.852   8.709  1.00 30.56           C  
ATOM   5476  CD  PRO C 202      21.472   4.821   9.543  1.00 28.20           C  
ATOM   5477  N   GLU C 203      21.290   2.449   6.546  1.00 28.42           N  
ATOM   5478  CA  GLU C 203      21.608   1.522   5.464  1.00 29.18           C  
ATOM   5479  C   GLU C 203      20.832   0.208   5.602  1.00 28.16           C  
ATOM   5480  O   GLU C 203      20.398  -0.359   4.611  1.00 26.14           O  
ATOM   5481  CB  GLU C 203      23.124   1.223   5.405  1.00 31.39           C  
ATOM   5482  CG  GLU C 203      24.032   2.460   5.222  1.00 40.38           C  
ATOM   5483  CD  GLU C 203      23.962   3.472   6.395  1.00 49.46           C  
ATOM   5484  OE1 GLU C 203      24.013   3.059   7.577  1.00 35.30           O  
ATOM   5485  OE2 GLU C 203      23.873   4.695   6.121  1.00 59.58           O  
ATOM   5486  N   GLN C 204      20.650  -0.271   6.828  1.00 28.50           N  
ATOM   5487  CA  GLN C 204      19.911  -1.514   7.055  1.00 29.40           C  
ATOM   5488  C   GLN C 204      18.434  -1.380   6.672  1.00 29.01           C  
ATOM   5489  O   GLN C 204      17.860  -2.256   6.010  1.00 27.78           O  
ATOM   5490  CB  GLN C 204      20.017  -1.929   8.507  1.00 31.39           C  
ATOM   5491  CG  GLN C 204      19.372  -3.274   8.824  1.00 36.77           C  
ATOM   5492  CD  GLN C 204      19.914  -4.416   7.965  1.00 36.78           C  
ATOM   5493  OE1 GLN C 204      20.803  -5.134   8.394  1.00 39.37           O  
ATOM   5494  NE2 GLN C 204      19.396  -4.562   6.739  1.00 36.95           N  
ATOM   5495  N   TYR C 205      17.823  -0.280   7.089  1.00 28.31           N  
ATOM   5496  CA  TYR C 205      16.431   0.001   6.744  1.00 28.49           C  
ATOM   5497  C   TYR C 205      16.286   0.140   5.240  1.00 26.88           C  
ATOM   5498  O   TYR C 205      15.298  -0.328   4.664  1.00 28.28           O  
ATOM   5499  CB  TYR C 205      15.936   1.279   7.424  1.00 30.54           C  
ATOM   5500  CG  TYR C 205      15.594   1.145   8.898  1.00 29.63           C  
ATOM   5501  CD1 TYR C 205      14.503   0.362   9.300  1.00 31.13           C  
ATOM   5502  CD2 TYR C 205      16.318   1.846   9.889  1.00 31.00           C  
ATOM   5503  CE1 TYR C 205      14.148   0.247  10.639  1.00 29.32           C  
ATOM   5504  CE2 TYR C 205      15.959   1.751  11.243  1.00 33.94           C  
ATOM   5505  CZ  TYR C 205      14.876   0.944  11.609  1.00 31.70           C  
ATOM   5506  OH  TYR C 205      14.490   0.811  12.923  1.00 29.12           O  
ATOM   5507  N   ILE C 206      17.271   0.783   4.609  1.00 27.61           N  
ATOM   5508  CA  ILE C 206      17.275   0.962   3.143  1.00 26.71           C  
ATOM   5509  C   ILE C 206      17.248  -0.410   2.431  1.00 26.44           C  
ATOM   5510  O   ILE C 206      16.446  -0.634   1.529  1.00 24.54           O  
ATOM   5511  CB  ILE C 206      18.473   1.835   2.648  1.00 27.66           C  
ATOM   5512  CG1 ILE C 206      18.322   3.284   3.148  1.00 28.85           C  
ATOM   5513  CG2 ILE C 206      18.550   1.777   1.129  1.00 27.89           C  
ATOM   5514  CD1 ILE C 206      19.504   4.223   2.827  1.00 26.10           C  
ATOM   5515  N   THR C 207      18.073  -1.339   2.896  1.00 27.94           N  
ATOM   5516  CA  THR C 207      18.122  -2.682   2.324  1.00 28.94           C  
ATOM   5517  C   THR C 207      16.796  -3.389   2.440  1.00 27.13           C  
ATOM   5518  O   THR C 207      16.282  -3.876   1.447  1.00 26.99           O  
ATOM   5519  CB  THR C 207      19.224  -3.514   2.976  1.00 32.10           C  
ATOM   5520  OG1 THR C 207      20.480  -2.911   2.649  1.00 30.08           O  
ATOM   5521  CG2 THR C 207      19.201  -4.979   2.468  1.00 29.84           C  
ATOM   5522  N   TRP C 208      16.230  -3.408   3.643  1.00 29.31           N  
ATOM   5523  CA  TRP C 208      14.940  -4.063   3.888  1.00 26.91           C  
ATOM   5524  C   TRP C 208      13.819  -3.473   3.051  1.00 26.71           C  
ATOM   5525  O   TRP C 208      12.946  -4.206   2.606  1.00 28.88           O  
ATOM   5526  CB  TRP C 208      14.563  -4.036   5.366  1.00 27.38           C  
ATOM   5527  CG  TRP C 208      15.451  -4.835   6.280  1.00 26.75           C  
ATOM   5528  CD1 TRP C 208      16.099  -6.008   5.986  1.00 31.21           C  
ATOM   5529  CD2 TRP C 208      15.691  -4.586   7.674  1.00 32.17           C  
ATOM   5530  NE1 TRP C 208      16.770  -6.473   7.105  1.00 26.23           N  
ATOM   5531  CE2 TRP C 208      16.524  -5.623   8.151  1.00 31.30           C  
ATOM   5532  CE3 TRP C 208      15.286  -3.581   8.566  1.00 33.26           C  
ATOM   5533  CZ2 TRP C 208      16.969  -5.672   9.472  1.00 28.41           C  
ATOM   5534  CZ3 TRP C 208      15.737  -3.631   9.881  1.00 31.65           C  
ATOM   5535  CH2 TRP C 208      16.567  -4.674  10.318  1.00 28.02           C  
ATOM   5536  N   LEU C 209      13.854  -2.164   2.823  1.00 23.78           N  
ATOM   5537  CA  LEU C 209      12.855  -1.500   2.011  1.00 24.91           C  
ATOM   5538  C   LEU C 209      12.935  -1.945   0.558  1.00 26.91           C  
ATOM   5539  O   LEU C 209      11.895  -2.156  -0.094  1.00 29.44           O  
ATOM   5540  CB  LEU C 209      13.015   0.022   2.088  1.00 23.73           C  
ATOM   5541  CG  LEU C 209      12.439   0.654   3.348  1.00 24.85           C  
ATOM   5542  CD1 LEU C 209      12.899   2.112   3.493  1.00 22.18           C  
ATOM   5543  CD2 LEU C 209      10.917   0.537   3.342  1.00 27.20           C  
ATOM   5544  N   ARG C 210      14.165  -2.081   0.070  1.00 24.93           N  
ATOM   5545  CA  ARG C 210      14.419  -2.515  -1.272  1.00 26.37           C  
ATOM   5546  C   ARG C 210      14.002  -3.945  -1.411  1.00 27.59           C  
ATOM   5547  O   ARG C 210      13.346  -4.303  -2.404  1.00 28.02           O  
ATOM   5548  CB  ARG C 210      15.883  -2.330  -1.638  1.00 27.20           C  
ATOM   5549  CG  ARG C 210      16.277  -0.864  -1.778  1.00 24.96           C  
ATOM   5550  CD  ARG C 210      17.762  -0.675  -2.052  1.00 28.23           C  
ATOM   5551  NE  ARG C 210      18.082   0.751  -2.195  1.00 28.79           N  
ATOM   5552  CZ  ARG C 210      19.281   1.288  -1.994  1.00 27.20           C  
ATOM   5553  NH1 ARG C 210      20.313   0.521  -1.632  1.00 26.22           N  
ATOM   5554  NH2 ARG C 210      19.449   2.607  -2.151  1.00 22.03           N  
ATOM   5555  N   GLU C 211      14.348  -4.754  -0.409  1.00 28.44           N  
ATOM   5556  CA  GLU C 211      13.966  -6.168  -0.404  1.00 29.22           C  
ATOM   5557  C   GLU C 211      12.437  -6.324  -0.402  1.00 29.24           C  
ATOM   5558  O   GLU C 211      11.925  -7.274  -0.987  1.00 31.15           O  
ATOM   5559  CB  GLU C 211      14.624  -6.908   0.761  1.00 28.82           C  
ATOM   5560  CG  GLU C 211      16.155  -7.138   0.618  1.00 29.74           C  
ATOM   5561  CD  GLU C 211      16.794  -7.655   1.934  1.00 33.17           C  
ATOM   5562  OE1 GLU C 211      16.036  -7.864   2.925  1.00 34.16           O  
ATOM   5563  OE2 GLU C 211      18.037  -7.850   1.979  1.00 36.28           O  
ATOM   5564  N   ALA C 212      11.715  -5.386   0.217  1.00 30.24           N  
ATOM   5565  CA  ALA C 212      10.236  -5.374   0.220  1.00 28.62           C  
ATOM   5566  C   ALA C 212       9.607  -4.852  -1.082  1.00 28.93           C  
ATOM   5567  O   ALA C 212       8.395  -4.859  -1.211  1.00 29.05           O  
ATOM   5568  CB  ALA C 212       9.711  -4.531   1.387  1.00 27.49           C  
ATOM   5569  N   GLY C 213      10.414  -4.377  -2.031  1.00 27.58           N  
ATOM   5570  CA  GLY C 213       9.887  -3.825  -3.285  1.00 28.42           C  
ATOM   5571  C   GLY C 213       9.626  -2.318  -3.306  1.00 27.81           C  
ATOM   5572  O   GLY C 213       8.799  -1.841  -4.078  1.00 27.95           O  
ATOM   5573  N   PHE C 214      10.302  -1.571  -2.437  1.00 27.67           N  
ATOM   5574  CA  PHE C 214      10.220  -0.099  -2.441  1.00 27.90           C  
ATOM   5575  C   PHE C 214      11.461   0.538  -3.037  1.00 28.74           C  
ATOM   5576  O   PHE C 214      12.569   0.011  -2.896  1.00 26.98           O  
ATOM   5577  CB  PHE C 214      10.157   0.461  -1.029  1.00 24.40           C  
ATOM   5578  CG  PHE C 214       8.881   0.178  -0.335  1.00 23.85           C  
ATOM   5579  CD1 PHE C 214       7.813   1.030  -0.480  1.00 26.04           C  
ATOM   5580  CD2 PHE C 214       8.747  -0.958   0.464  1.00 26.71           C  
ATOM   5581  CE1 PHE C 214       6.642   0.785   0.150  1.00 26.65           C  
ATOM   5582  CE2 PHE C 214       7.564  -1.203   1.091  1.00 26.47           C  
ATOM   5583  CZ  PHE C 214       6.525  -0.328   0.943  1.00 22.96           C  
ATOM   5584  N   ARG C 215      11.262   1.679  -3.693  1.00 30.51           N  
ATOM   5585  CA  ARG C 215      12.369   2.508  -4.121  1.00 27.95           C  
ATOM   5586  C   ARG C 215      12.485   3.537  -3.005  1.00 28.56           C  
ATOM   5587  O   ARG C 215      11.490   4.169  -2.649  1.00 28.62           O  
ATOM   5588  CB  ARG C 215      12.119   3.191  -5.450  1.00 30.04           C  
ATOM   5589  CG  ARG C 215      13.249   4.115  -5.856  1.00 27.45           C  
ATOM   5590  CD  ARG C 215      13.051   4.693  -7.221  1.00 31.07           C  
ATOM   5591  NE  ARG C 215      11.802   5.410  -7.313  1.00 33.65           N  
ATOM   5592  CZ  ARG C 215      11.626   6.695  -7.022  1.00 39.75           C  
ATOM   5593  NH1 ARG C 215      12.639   7.455  -6.618  1.00 40.35           N  
ATOM   5594  NH2 ARG C 215      10.416   7.219  -7.141  1.00 41.48           N  
ATOM   5595  N   VAL C 216      13.675   3.661  -2.427  1.00 27.98           N  
ATOM   5596  CA  VAL C 216      13.936   4.614  -1.346  1.00 28.23           C  
ATOM   5597  C   VAL C 216      14.156   5.985  -1.991  1.00 28.18           C  
ATOM   5598  O   VAL C 216      15.117   6.205  -2.747  1.00 26.46           O  
ATOM   5599  CB  VAL C 216      15.131   4.149  -0.469  1.00 30.19           C  
ATOM   5600  CG1 VAL C 216      15.378   5.110   0.706  1.00 27.70           C  
ATOM   5601  CG2 VAL C 216      14.866   2.741   0.050  1.00 26.96           C  
ATOM   5602  N   CYS C 217      13.244   6.906  -1.710  1.00 29.18           N  
ATOM   5603  CA  CYS C 217      13.273   8.231  -2.327  1.00 31.33           C  
ATOM   5604  C   CYS C 217      14.177   9.231  -1.639  1.00 31.31           C  
ATOM   5605  O   CYS C 217      14.942   9.946  -2.306  1.00 32.77           O  
ATOM   5606  CB  CYS C 217      11.865   8.813  -2.388  1.00 32.30           C  
ATOM   5607  SG  CYS C 217      10.710   7.757  -3.224  1.00 40.20           S  
ATOM   5608  N   ALA C 218      14.101   9.270  -0.319  1.00 28.30           N  
ATOM   5609  CA  ALA C 218      14.842  10.233   0.457  1.00 29.42           C  
ATOM   5610  C   ALA C 218      15.086   9.689   1.848  1.00 29.31           C  
ATOM   5611  O   ALA C 218      14.250   8.996   2.388  1.00 27.45           O  
ATOM   5612  CB  ALA C 218      14.041  11.568   0.524  1.00 31.12           C  
ATOM   5613  N   VAL C 219      16.267   9.955   2.392  1.00 30.03           N  
ATOM   5614  CA  VAL C 219      16.625   9.591   3.778  1.00 29.89           C  
ATOM   5615  C   VAL C 219      17.247  10.868   4.292  1.00 28.77           C  
ATOM   5616  O   VAL C 219      18.269  11.289   3.805  1.00 29.51           O  
ATOM   5617  CB  VAL C 219      17.615   8.434   3.849  1.00 29.77           C  
ATOM   5618  CG1 VAL C 219      17.995   8.132   5.305  1.00 31.91           C  
ATOM   5619  CG2 VAL C 219      17.001   7.203   3.152  1.00 30.32           C  
ATOM   5620  N   THR C 220      16.573  11.508   5.227  1.00 30.52           N  
ATOM   5621  CA  THR C 220      16.974  12.800   5.735  1.00 29.62           C  
ATOM   5622  C   THR C 220      17.001  12.788   7.266  1.00 29.01           C  
ATOM   5623  O   THR C 220      16.542  11.834   7.912  1.00 28.55           O  
ATOM   5624  CB  THR C 220      16.016  13.886   5.220  1.00 28.36           C  
ATOM   5625  OG1 THR C 220      14.690  13.609   5.674  1.00 30.21           O  
ATOM   5626  CG2 THR C 220      16.010  13.922   3.713  1.00 29.04           C  
ATOM   5627  N   GLY C 221      17.602  13.825   7.839  1.00 29.55           N  
ATOM   5628  CA  GLY C 221      17.768  13.917   9.286  1.00 29.14           C  
ATOM   5629  C   GLY C 221      17.127  15.147   9.906  1.00 30.94           C  
ATOM   5630  O   GLY C 221      17.175  16.238   9.340  1.00 31.76           O  
ATOM   5631  N   ASP C 222      16.516  14.945  11.058  1.00 31.53           N  
ATOM   5632  CA  ASP C 222      15.986  15.993  11.946  1.00 33.28           C  
ATOM   5633  C   ASP C 222      15.131  17.063  11.320  1.00 33.85           C  
ATOM   5634  O   ASP C 222      15.307  18.241  11.595  1.00 33.87           O  
ATOM   5635  CB  ASP C 222      17.150  16.619  12.735  1.00 33.37           C  
ATOM   5636  CG  ASP C 222      17.867  15.597  13.604  1.00 36.23           C  
ATOM   5637  OD1 ASP C 222      17.204  14.656  14.040  1.00 34.82           O  
ATOM   5638  OD2 ASP C 222      19.079  15.722  13.855  1.00 38.67           O  
ATOM   5639  N   PHE C 223      14.204  16.633  10.484  1.00 35.24           N  
ATOM   5640  CA  PHE C 223      13.264  17.532   9.800  1.00 36.84           C  
ATOM   5641  C   PHE C 223      13.902  18.423   8.729  1.00 37.49           C  
ATOM   5642  O   PHE C 223      13.237  19.311   8.236  1.00 40.63           O  
ATOM   5643  CB  PHE C 223      12.454  18.379  10.792  1.00 36.01           C  
ATOM   5644  CG  PHE C 223      11.636  17.581  11.761  1.00 34.53           C  
ATOM   5645  CD1 PHE C 223      10.349  17.184  11.437  1.00 34.23           C  
ATOM   5646  CD2 PHE C 223      12.133  17.270  13.017  1.00 34.66           C  
ATOM   5647  CE1 PHE C 223       9.581  16.447  12.338  1.00 31.45           C  
ATOM   5648  CE2 PHE C 223      11.373  16.534  13.932  1.00 33.02           C  
ATOM   5649  CZ  PHE C 223      10.093  16.136  13.604  1.00 30.04           C  
ATOM   5650  N   LYS C 224      15.163  18.158   8.357  1.00 38.01           N  
ATOM   5651  CA  LYS C 224      15.870  18.899   7.314  1.00 39.16           C  
ATOM   5652  C   LYS C 224      15.757  18.134   5.983  1.00 39.18           C  
ATOM   5653  O   LYS C 224      15.339  16.982   5.955  1.00 36.12           O  
ATOM   5654  CB  LYS C 224      17.343  19.085   7.691  1.00 40.50           C  
ATOM   5655  CG  LYS C 224      17.574  19.700   9.070  1.00 43.36           C  
ATOM   5656  N   SER C 225      16.200  18.775   4.906  1.00 39.29           N  
ATOM   5657  CA  SER C 225      16.116  18.249   3.536  1.00 39.43           C  
ATOM   5658  C   SER C 225      17.266  17.401   3.096  1.00 37.38           C  
ATOM   5659  O   SER C 225      17.209  16.816   2.022  1.00 37.29           O  
ATOM   5660  CB  SER C 225      16.075  19.417   2.527  1.00 39.16           C  
ATOM   5661  OG  SER C 225      14.819  20.071   2.559  1.00 53.02           O  
ATOM   5662  N   ASP C 226      18.299  17.331   3.922  1.00 36.59           N  
ATOM   5663  CA  ASP C 226      19.536  16.690   3.549  1.00 38.35           C  
ATOM   5664  C   ASP C 226      19.741  15.365   4.240  1.00 37.37           C  
ATOM   5665  O   ASP C 226      19.044  15.047   5.218  1.00 34.86           O  
ATOM   5666  CB  ASP C 226      20.651  17.680   3.891  1.00 42.46           C  
ATOM   5667  CG  ASP C 226      20.306  19.119   3.420  1.00 52.66           C  
ATOM   5668  OD1 ASP C 226      20.565  19.445   2.229  1.00 46.89           O  
ATOM   5669  OD2 ASP C 226      19.755  19.910   4.253  1.00 51.36           O  
ATOM   5670  N   ALA C 227      20.670  14.579   3.703  1.00 36.72           N  
ATOM   5671  CA  ALA C 227      21.027  13.301   4.290  1.00 37.39           C  
ATOM   5672  C   ALA C 227      21.379  13.601   5.741  1.00 37.47           C  
ATOM   5673  O   ALA C 227      21.788  14.721   6.057  1.00 35.57           O  
ATOM   5674  CB  ALA C 227      22.201  12.674   3.562  1.00 36.19           C  
ATOM   5675  N   PRO C 228      21.170  12.627   6.636  1.00 36.94           N  
ATOM   5676  CA  PRO C 228      21.446  12.917   8.037  1.00 37.50           C  
ATOM   5677  C   PRO C 228      22.941  13.078   8.321  1.00 37.54           C  
ATOM   5678  O   PRO C 228      23.763  12.470   7.634  1.00 38.35           O  
ATOM   5679  CB  PRO C 228      20.853  11.715   8.777  1.00 36.84           C  
ATOM   5680  CG  PRO C 228      20.799  10.624   7.783  1.00 40.13           C  
ATOM   5681  CD  PRO C 228      20.656  11.265   6.433  1.00 35.95           C  
ATOM   5682  N   THR C 229      23.250  13.924   9.301  1.00 37.28           N  
ATOM   5683  CA  THR C 229      24.611  14.157   9.754  1.00 38.88           C  
ATOM   5684  C   THR C 229      24.980  13.108  10.795  1.00 38.18           C  
ATOM   5685  O   THR C 229      24.119  12.350  11.266  1.00 39.29           O  
ATOM   5686  CB  THR C 229      24.771  15.569  10.366  1.00 38.37           C  
ATOM   5687  OG1 THR C 229      24.018  15.665  11.577  1.00 42.31           O  
ATOM   5688  CG2 THR C 229      24.285  16.638   9.387  1.00 39.33           C  
ATOM   5689  N   GLU C 230      26.255  13.066  11.166  1.00 38.18           N  
ATOM   5690  CA  GLU C 230      26.744  12.107  12.177  1.00 38.82           C  
ATOM   5691  C   GLU C 230      26.074  12.312  13.556  1.00 37.68           C  
ATOM   5692  O   GLU C 230      26.043  11.396  14.373  1.00 39.97           O  
ATOM   5693  CB  GLU C 230      28.280  12.193  12.307  1.00 38.55           C  
ATOM   5694  N   THR C 231      25.517  13.492  13.801  1.00 35.61           N  
ATOM   5695  CA  THR C 231      24.850  13.777  15.072  1.00 37.02           C  
ATOM   5696  C   THR C 231      23.320  13.918  14.939  1.00 34.97           C  
ATOM   5697  O   THR C 231      22.650  14.452  15.838  1.00 35.66           O  
ATOM   5698  CB  THR C 231      25.437  15.053  15.676  1.00 37.75           C  
ATOM   5699  OG1 THR C 231      25.327  16.112  14.719  1.00 46.35           O  
ATOM   5700  CG2 THR C 231      26.908  14.854  15.991  1.00 36.65           C  
ATOM   5701  N   ALA C 232      22.745  13.436  13.838  1.00 34.71           N  
ATOM   5702  CA  ALA C 232      21.281  13.512  13.691  1.00 34.89           C  
ATOM   5703  C   ALA C 232      20.663  12.570  14.733  1.00 32.60           C  
ATOM   5704  O   ALA C 232      21.211  11.496  15.010  1.00 34.29           O  
ATOM   5705  CB  ALA C 232      20.833  13.122  12.276  1.00 33.19           C  
ATOM   5706  N   GLU C 233      19.551  12.996  15.319  1.00 32.36           N  
ATOM   5707  CA  GLU C 233      18.825  12.221  16.304  1.00 34.07           C  
ATOM   5708  C   GLU C 233      17.630  11.450  15.744  1.00 30.75           C  
ATOM   5709  O   GLU C 233      17.190  10.476  16.347  1.00 30.58           O  
ATOM   5710  CB  GLU C 233      18.309  13.159  17.405  1.00 34.88           C  
ATOM   5711  CG  GLU C 233      19.404  13.723  18.268  1.00 41.45           C  
ATOM   5712  CD  GLU C 233      18.911  14.704  19.313  1.00 39.55           C  
ATOM   5713  OE1 GLU C 233      17.681  14.914  19.447  1.00 41.19           O  
ATOM   5714  OE2 GLU C 233      19.783  15.269  20.015  1.00 53.76           O  
ATOM   5715  N   ARG C 234      17.085  11.921  14.623  1.00 30.25           N  
ATOM   5716  CA  ARG C 234      15.885  11.328  14.033  1.00 30.17           C  
ATOM   5717  C   ARG C 234      16.083  11.227  12.565  1.00 28.97           C  
ATOM   5718  O   ARG C 234      16.477  12.198  11.920  1.00 29.03           O  
ATOM   5719  CB  ARG C 234      14.638  12.169  14.351  1.00 29.84           C  
ATOM   5720  CG  ARG C 234      13.291  11.519  14.008  1.00 29.86           C  
ATOM   5721  CD  ARG C 234      12.132  12.346  14.552  1.00 30.95           C  
ATOM   5722  NE  ARG C 234      12.120  12.324  16.016  1.00 32.95           N  
ATOM   5723  CZ  ARG C 234      11.650  11.318  16.755  1.00 30.21           C  
ATOM   5724  NH1 ARG C 234      11.111  10.252  16.182  1.00 36.04           N  
ATOM   5725  NH2 ARG C 234      11.714  11.383  18.074  1.00 34.21           N  
ATOM   5726  N   ILE C 235      15.863  10.035  12.027  1.00 29.47           N  
ATOM   5727  CA  ILE C 235      16.053   9.841  10.589  1.00 28.36           C  
ATOM   5728  C   ILE C 235      14.702   9.558   9.944  1.00 27.41           C  
ATOM   5729  O   ILE C 235      13.949   8.689  10.415  1.00 27.21           O  
ATOM   5730  CB  ILE C 235      17.064   8.733  10.302  1.00 29.88           C  
ATOM   5731  CG1 ILE C 235      18.379   9.054  11.037  1.00 36.84           C  
ATOM   5732  CG2 ILE C 235      17.347   8.677   8.790  1.00 21.71           C  
ATOM   5733  CD1 ILE C 235      19.409   8.014  10.927  1.00 38.27           C  
ATOM   5734  N   PHE C 236      14.435  10.287   8.869  1.00 27.72           N  
ATOM   5735  CA  PHE C 236      13.189  10.238   8.121  1.00 28.83           C  
ATOM   5736  C   PHE C 236      13.364   9.555   6.786  1.00 27.95           C  
ATOM   5737  O   PHE C 236      14.272   9.900   6.034  1.00 27.21           O  
ATOM   5738  CB  PHE C 236      12.719  11.665   7.857  1.00 28.92           C  
ATOM   5739  CG  PHE C 236      12.310  12.401   9.105  1.00 32.70           C  
ATOM   5740  CD1 PHE C 236      13.274  12.951   9.955  1.00 33.75           C  
ATOM   5741  CD2 PHE C 236      10.973  12.566   9.409  1.00 30.73           C  
ATOM   5742  CE1 PHE C 236      12.905  13.593  11.099  1.00 30.55           C  
ATOM   5743  CE2 PHE C 236      10.584  13.213  10.547  1.00 26.33           C  
ATOM   5744  CZ  PHE C 236      11.556  13.743  11.395  1.00 29.69           C  
ATOM   5745  N   PHE C 237      12.510   8.577   6.501  1.00 29.32           N  
ATOM   5746  CA  PHE C 237      12.535   7.846   5.224  1.00 29.53           C  
ATOM   5747  C   PHE C 237      11.271   8.048   4.411  1.00 28.60           C  
ATOM   5748  O   PHE C 237      10.179   8.036   4.965  1.00 28.31           O  
ATOM   5749  CB  PHE C 237      12.646   6.353   5.485  1.00 27.51           C  
ATOM   5750  CG  PHE C 237      13.905   5.931   6.177  1.00 29.63           C  
ATOM   5751  CD1 PHE C 237      14.060   6.105   7.550  1.00 30.17           C  
ATOM   5752  CD2 PHE C 237      14.900   5.282   5.478  1.00 34.12           C  
ATOM   5753  CE1 PHE C 237      15.228   5.690   8.192  1.00 33.32           C  
ATOM   5754  CE2 PHE C 237      16.054   4.869   6.103  1.00 29.70           C  
ATOM   5755  CZ  PHE C 237      16.225   5.074   7.458  1.00 31.31           C  
ATOM   5756  N   VAL C 238      11.429   8.275   3.104  1.00 27.47           N  
ATOM   5757  CA  VAL C 238      10.328   8.329   2.156  1.00 27.57           C  
ATOM   5758  C   VAL C 238      10.650   7.233   1.120  1.00 29.66           C  
ATOM   5759  O   VAL C 238      11.756   7.224   0.542  1.00 29.46           O  
ATOM   5760  CB  VAL C 238      10.197   9.666   1.387  1.00 30.75           C  
ATOM   5761  CG1 VAL C 238       9.050   9.559   0.401  1.00 26.81           C  
ATOM   5762  CG2 VAL C 238       9.997  10.878   2.341  1.00 25.82           C  
ATOM   5763  N   ALA C 239       9.714   6.294   0.947  1.00 30.69           N  
ATOM   5764  CA  ALA C 239       9.846   5.177   0.023  1.00 29.75           C  
ATOM   5765  C   ALA C 239       8.618   5.125  -0.876  1.00 29.54           C  
ATOM   5766  O   ALA C 239       7.548   5.550  -0.488  1.00 31.45           O  
ATOM   5767  CB  ALA C 239      10.005   3.858   0.795  1.00 30.01           C  
ATOM   5768  N   GLU C 240       8.776   4.576  -2.071  1.00 30.16           N  
ATOM   5769  CA  GLU C 240       7.673   4.438  -3.026  1.00 31.55           C  
ATOM   5770  C   GLU C 240       7.606   2.994  -3.549  1.00 30.15           C  
ATOM   5771  O   GLU C 240       8.628   2.387  -3.918  1.00 29.32           O  
ATOM   5772  CB  GLU C 240       7.847   5.416  -4.184  1.00 32.16           C  
ATOM   5773  CG  GLU C 240       6.680   5.462  -5.158  1.00 35.71           C  
ATOM   5774  CD  GLU C 240       6.833   6.563  -6.213  1.00 37.17           C  
ATOM   5775  OE1 GLU C 240       7.085   7.724  -5.825  1.00 45.30           O  
ATOM   5776  OE2 GLU C 240       6.670   6.279  -7.426  1.00 42.30           O  
ATOM   5777  N   LYS C 241       6.402   2.448  -3.590  1.00 30.17           N  
ATOM   5778  CA  LYS C 241       6.245   1.084  -4.080  1.00 31.59           C  
ATOM   5779  C   LYS C 241       6.484   1.067  -5.588  1.00 32.69           C  
ATOM   5780  O   LYS C 241       5.934   1.876  -6.339  1.00 33.06           O  
ATOM   5781  CB  LYS C 241       4.877   0.490  -3.749  1.00 32.60           C  
ATOM   5782  CG  LYS C 241       4.877  -1.026  -3.928  1.00 31.63           C  
ATOM   5783  CD  LYS C 241       3.531  -1.580  -4.051  1.00 39.15           C  
ATOM   5784  CE  LYS C 241       3.597  -3.057  -4.365  1.00 33.08           C  
ATOM   5785  NZ  LYS C 241       2.279  -3.638  -4.085  1.00 33.18           N  
ATOM   5786  N   ILE C 242       7.333   0.148  -6.009  1.00 32.88           N  
ATOM   5787  CA  ILE C 242       7.642  -0.048  -7.409  1.00 34.60           C  
ATOM   5788  C   ILE C 242       6.463  -0.776  -8.050  1.00 37.36           C  
ATOM   5789  O   ILE C 242       5.859  -1.652  -7.419  1.00 39.21           O  
ATOM   5790  CB  ILE C 242       8.953  -0.829  -7.555  1.00 33.77           C  
ATOM   5791  CG1 ILE C 242      10.112   0.070  -7.123  1.00 32.56           C  
ATOM   5792  CG2 ILE C 242       9.165  -1.284  -8.985  1.00 31.55           C  
ATOM   5793  CD1 ILE C 242      11.384  -0.662  -6.814  1.00 29.69           C  
ATOM   5794  OXT ILE C 242       6.066  -0.470  -9.176  1.00 38.86           O  
TER    5795      ILE C 242                                                      
END
MOLECULE T0485.pdb
ATOM      5  N   MET     1      -1.481 -13.150  43.871  1.00  8.67           N  
ATOM      6  CA  MET     1      -1.996 -12.142  42.964  0.70  8.34           C  
ATOM      8  C   MET     1      -0.843 -11.344  42.396  1.00  7.61           C  
ATOM      9  O   MET     1       0.307 -11.417  42.868  1.00  8.27           O  
ATOM     10  CB  MET     1      -3.060 -11.257  43.656  0.70  7.93           C  
ATOM     12  CG  MET     1      -2.578 -10.402  44.794  0.70  6.92           C  
ATOM     14  SD  MET     1      -1.632  -8.771  44.313  0.53  6.93          SE  
ATOM     16  CE  MET     1      -3.050  -7.819  43.355  0.70 10.03           C  
ATOM     18  N   SER     2      -1.143 -10.624  41.351  1.00  7.85           N  
ATOM     19  CA  SER     2      -0.222  -9.690  40.807  1.00  9.16           C  
ATOM     20  C   SER     2      -0.898  -8.470  40.231  1.00  9.17           C  
ATOM     21  O   SER     2      -2.095  -8.531  39.828  1.00 10.71           O  
ATOM     22  CB  SER     2       0.615 -10.344  39.753  1.00  9.64           C  
ATOM     23  OG  SER     2      -0.120 -10.696  38.610  1.00 11.89           O  
ATOM     24  N   GLU     3      -0.151  -7.389  40.224  1.00  8.77           N  
ATOM     25  CA  GLU     3      -0.509  -6.172  39.524  0.53  8.19           C  
ATOM     27  C   GLU     3       0.562  -6.069  38.444  1.00  8.87           C  
ATOM     28  O   GLU     3       1.745  -6.166  38.752  1.00 12.42           O  
ATOM     29  CB  GLU     3      -0.448  -4.997  40.483  0.53 10.65           C  
ATOM     31  CG  GLU     3      -0.721  -3.646  39.850  0.53 12.43           C  
ATOM     33  CD  GLU     3      -2.150  -3.481  39.333  0.53 14.52           C  
ATOM     35  OE1 GLU     3      -3.058  -4.169  39.799  0.53 14.77           O  
ATOM     37  OE2 GLU     3      -2.356  -2.624  38.458  0.53 21.83           O  
ATOM     39  N   ASN     4       0.176  -5.885  37.205  1.00  8.06           N  
ATOM     40  CA  ASN     4       1.062  -5.959  36.055  0.74  9.14           C  
ATOM     42  C   ASN     4       1.002  -4.687  35.236  1.00  9.09           C  
ATOM     43  O   ASN     4      -0.074  -4.130  35.035  1.00 13.07           O  
ATOM     44  CB  ASN     4       0.606  -7.129  35.142  0.74 10.42           C  
ATOM     46  CG  ASN     4       0.724  -8.489  35.798  0.74 10.49           C  
ATOM     48  OD1 ASN     4       1.608  -9.290  35.448  0.74 13.87           O  
ATOM     50  ND2 ASN     4      -0.134  -8.756  36.763  0.74  9.20           N  
ATOM     52  N   LYS     5       2.150  -4.296  34.746  1.00  6.87           N  
ATOM     53  CA  LYS     5       2.324  -3.143  33.860  1.00  7.01           C  
ATOM     54  C   LYS     5       3.179  -3.619  32.700  1.00  7.25           C  
ATOM     55  O   LYS     5       4.205  -4.240  32.901  1.00  7.40           O  
ATOM     56  CB  LYS     5       2.998  -2.001  34.624  1.00  7.11           C  
ATOM     57  CG  LYS     5       3.426  -0.860  33.745  1.00  7.50           C  
ATOM     58  CD  LYS     5       2.280   0.049  33.310  1.00  7.49           C  
ATOM     59  CE  LYS     5       2.719   1.051  32.232  1.00  8.04           C  
ATOM     60  NZ  LYS     5       2.947   0.397  30.922  1.00  8.27           N  
ATOM     61  N   LYS     6       2.719  -3.369  31.473  1.00  7.17           N  
ATOM     62  CA  LYS     6       3.456  -3.757  30.274  1.00  8.10           C  
ATOM     63  C   LYS     6       3.233  -2.708  29.204  1.00  7.31           C  
ATOM     64  O   LYS     6       2.310  -1.895  29.289  1.00  7.86           O  
ATOM     65  CB  LYS     6       3.043  -5.126  29.805  1.00  9.03           C  
ATOM     66  CG  LYS     6       1.599  -5.244  29.462  1.00  9.62           C  
ATOM     67  CD  LYS     6       1.186  -6.709  29.147  1.00 12.22           C  
ATOM     68  CE  LYS     6      -0.336  -6.926  28.980  1.00 14.34           C  
ATOM     69  NZ  LYS     6      -1.001  -6.893  30.345  1.00 15.98           N  
ATOM     70  N   LYS     7       4.087  -2.694  28.194  1.00  7.80           N  
ATOM     71  CA  LYS     7       3.964  -1.662  27.190  1.00  7.69           C  
ATOM     72  C   LYS     7       2.617  -1.682  26.492  1.00  7.66           C  
ATOM     73  O   LYS     7       2.071  -2.728  26.148  1.00  8.71           O  
ATOM     74  CB  LYS     7       5.046  -1.755  26.125  1.00  8.86           C  
ATOM     75  CG  LYS     7       6.450  -1.501  26.628  1.00 11.03           C  
ATOM     76  CD  LYS     7       7.438  -1.209  25.488  1.00 13.56           C  
ATOM     77  CE  LYS     7       7.589  -2.328  24.501  1.00 13.98           C  
ATOM     78  NZ  LYS     7       8.191  -3.588  25.051  1.00 17.04           N  
ATOM     79  N   PHE     8       2.096  -0.482  26.317  1.00  7.70           N  
ATOM     80  CA  PHE     8       0.891  -0.214  25.527  1.00  7.42           C  
ATOM     81  C   PHE     8      -0.409  -0.656  26.170  1.00  7.87           C  
ATOM     82  O   PHE     8      -1.454  -0.771  25.521  1.00  9.21           O  
ATOM     83  CB  PHE     8       1.015  -0.731  24.073  1.00  9.35           C  
ATOM     84  CG  PHE     8       2.397  -0.542  23.487  1.00  8.92           C  
ATOM     85  CD1 PHE     8       2.987   0.706  23.481  1.00  9.86           C  
ATOM     86  CD2 PHE     8       3.069  -1.598  22.920  1.00 10.18           C  
ATOM     87  CE1 PHE     8       4.256   0.904  22.946  1.00  9.67           C  
ATOM     88  CE2 PHE     8       4.353  -1.418  22.365  1.00 11.24           C  
ATOM     89  CZ  PHE     8       4.922  -0.179  22.389  1.00 10.77           C  
ATOM     90  N   ASP     9      -0.325  -0.887  27.471  1.00  7.13           N  
ATOM     91  CA  ASP     9      -1.507  -1.238  28.276  1.00  7.67           C  
ATOM     92  C   ASP     9      -2.276   0.016  28.676  1.00  7.69           C  
ATOM     93  O   ASP     9      -2.012   1.098  28.184  1.00  7.72           O  
ATOM     94  CB  ASP     9      -1.129  -2.123  29.468  1.00  8.06           C  
ATOM     95  CG  ASP     9      -0.247  -1.442  30.510  1.00  6.85           C  
ATOM     96  OD1 ASP     9       0.092  -0.248  30.352  1.00  7.29           O  
ATOM     97  OD2 ASP     9       0.069  -2.129  31.524  1.00  7.83           O  
ATOM     98  N   LYS    10      -3.267  -0.124  29.545  1.00  8.67           N  
ATOM     99  CA  LYS    10      -4.080   1.031  29.882  1.00  9.26           C  
ATOM    100  C   LYS    10      -3.265   2.158  30.504  1.00  8.69           C  
ATOM    101  O   LYS    10      -3.387   3.323  30.124  1.00  8.94           O  
ATOM    102  CB  LYS    10      -5.210   0.623  30.806  1.00 11.99           C  
ATOM    103  CG  LYS    10      -6.173   1.746  31.093  1.00 16.97           C  
ATOM    104  CD  LYS    10      -7.405   1.342  31.886  1.00 22.29           C  
ATOM    105  CE  LYS    10      -8.364   2.546  31.946  1.00 27.25           C  
ATOM    106  NZ  LYS    10      -9.627   2.275  32.678  1.00 32.98           N  
ATOM    107  N   LYS    11      -2.416   1.817  31.462  1.00  8.37           N  
ATOM    108  CA  LYS    11      -1.579   2.828  32.078  1.00  8.68           C  
ATOM    109  C   LYS    11      -0.591   3.451  31.102  1.00  7.99           C  
ATOM    110  O   LYS    11      -0.346   4.666  31.124  1.00  8.73           O  
ATOM    111  CB  LYS    11      -0.858   2.193  33.240  1.00  9.97           C  
ATOM    112  CG  LYS    11      -1.736   1.893  34.432  1.00 14.76           C  
ATOM    113  CD  LYS    11      -1.059   1.146  35.513  1.00 18.41           C  
ATOM    114  CE  LYS    11      -1.984   1.067  36.712  1.00 20.58           C  
ATOM    115  NZ  LYS    11      -1.315   0.442  37.822  1.00 22.46           N  
ATOM    116  N   GLY    12      -0.010   2.630  30.240  1.00  7.91           N  
ATOM    117  CA  GLY    12       0.930   3.141  29.266  1.00  7.46           C  
ATOM    118  C   GLY    12       0.271   4.038  28.242  1.00  7.46           C  
ATOM    119  O   GLY    12       0.847   5.037  27.807  1.00  8.40           O  
ATOM    120  N   ALA    13      -0.950   3.685  27.854  1.00  7.42           N  
ATOM    121  CA  ALA    13      -1.714   4.493  26.900  1.00  7.56           C  
ATOM    122  C   ALA    13      -1.979   5.875  27.498  1.00  7.04           C  
ATOM    123  O   ALA    13      -1.894   6.900  26.820  1.00  7.99           O  
ATOM    124  CB  ALA    13      -3.037   3.792  26.547  1.00  9.11           C  
ATOM    125  N   LYS    14      -2.325   5.905  28.784  1.00  7.10           N  
ATOM    126  CA  LYS    14      -2.545   7.170  29.482  0.53  7.27           C  
ATOM    128  C   LYS    14      -1.266   8.025  29.468  1.00  7.21           C  
ATOM    129  O   LYS    14      -1.321   9.233  29.257  1.00  8.68           O  
ATOM    130  CB  LYS    14      -3.017   6.888  30.918  0.53  8.25           C  
ATOM    132  CG  LYS    14      -3.209   8.137  31.782  0.53 10.78           C  
ATOM    134  CD  LYS    14      -3.717   7.767  33.194  0.53 16.27           C  
ATOM    136  CE  LYS    14      -3.901   8.984  34.108  0.53 20.54           C  
ATOM    138  NZ  LYS    14      -2.629   9.615  34.533  0.53 23.85           N  
ATOM    140  N   ASN    15      -0.131   7.406  29.726  1.00  7.92           N  
ATOM    141  CA  ASN    15       1.136   8.159  29.717  1.00  8.53           C  
ATOM    142  C   ASN    15       1.440   8.737  28.345  1.00  8.17           C  
ATOM    143  O   ASN    15       1.852   9.887  28.230  1.00  8.82           O  
ATOM    144  CB  ASN    15       2.283   7.276  30.135  1.00  8.79           C  
ATOM    145  CG  ASN    15       2.242   6.898  31.574  1.00 11.44           C  
ATOM    146  OD1 ASN    15       1.482   7.460  32.353  1.00 15.16           O  
ATOM    147  ND2 ASN    15       3.084   5.969  31.954  1.00 11.41           N  
ATOM    148  N   MET    16       1.247   7.925  27.308  1.00  7.21           N  
ATOM    149  CA  MET    16       1.480   8.381  25.957  1.00  8.03           C  
ATOM    150  C   MET    16       0.532   9.535  25.607  1.00  7.68           C  
ATOM    151  O   MET    16       0.938  10.534  24.994  1.00  8.53           O  
ATOM    152  CB  MET    16       1.325   7.241  24.978  1.00  7.51           C  
ATOM    153  CG  MET    16       1.698   7.583  23.517  1.00  8.88           C  
ATOM    154  SD  MET    16       3.579   7.936  23.215  0.75  8.58          SE  
ATOM    155  CE  MET    16       3.470   9.822  22.762  1.00 11.14           C  
ATOM    156  N   ASP    17      -0.734   9.395  25.990  1.00  6.41           N  
ATOM    157  CA  ASP    17      -1.721  10.420  25.724  1.00  7.06           C  
ATOM    158  C   ASP    17      -1.319  11.732  26.416  1.00  7.51           C  
ATOM    159  O   ASP    17      -1.372  12.815  25.830  1.00  8.29           O  
ATOM    160  CB  ASP    17      -3.080   9.966  26.240  1.00  7.74           C  
ATOM    161  CG  ASP    17      -4.196  10.927  25.886  1.00  7.94           C  
ATOM    162  OD1 ASP    17      -4.289  11.351  24.720  1.00  8.94           O  
ATOM    163  OD2 ASP    17      -5.028  11.219  26.778  1.00 11.58           O  
ATOM    164  N   GLU    18      -0.932  11.629  27.682  1.00  7.26           N  
ATOM    165  CA  GLU    18      -0.554  12.836  28.434  1.00  8.48           C  
ATOM    166  C   GLU    18       0.619  13.553  27.809  1.00  7.65           C  
ATOM    167  O   GLU    18       0.628  14.774  27.698  1.00  9.54           O  
ATOM    168  CB  GLU    18      -0.270  12.467  29.894  1.00  9.41           C  
ATOM    169  CG  GLU    18      -1.569  12.133  30.631  1.00 13.91           C  
ATOM    170  CD  GLU    18      -1.395  11.689  32.079  1.00 22.47           C  
ATOM    171  OE1 GLU    18      -0.237  11.582  32.552  1.00 28.94           O  
ATOM    172  OE2 GLU    18      -2.447  11.400  32.719  1.00 26.09           O  
ATOM    173  N   ILE    19       1.617  12.801  27.380  1.00  7.61           N  
ATOM    174  CA  ILE    19       2.804  13.388  26.737  1.00  7.85           C  
ATOM    175  C   ILE    19       2.432  13.988  25.377  1.00  6.82           C  
ATOM    176  O   ILE    19       2.850  15.102  25.029  1.00  8.10           O  
ATOM    177  CB  ILE    19       3.937  12.371  26.646  1.00  8.65           C  
ATOM    178  CG1 ILE    19       4.522  12.143  28.043  1.00 10.43           C  
ATOM    179  CG2 ILE    19       5.033  12.856  25.661  1.00 10.37           C  
ATOM    180  CD1 ILE    19       5.343  13.325  28.598  1.00 14.31           C  
ATOM    181  N   SER    20       1.610  13.265  24.615  1.00  7.24           N  
ATOM    182  CA  SER    20       1.135  13.685  23.306  0.50  7.20           C  
ATOM    184  C   SER    20       0.420  15.055  23.364  1.00  8.01           C  
ATOM    185  O   SER    20       0.459  15.856  22.444  1.00  9.90           O  
ATOM    186  CB  SER    20       0.168  12.600  22.787  0.50  6.57           C  
ATOM    188  OG  SER    20      -0.448  12.996  21.591  0.50 10.00           O  
ATOM    190  N   LYS    21      -0.305  15.269  24.453  1.00  8.12           N  
ATOM    191  CA  LYS    21      -1.128  16.476  24.694  0.52  8.74           C  
ATOM    193  C   LYS    21      -0.354  17.626  25.305  1.00  8.20           C  
ATOM    194  O   LYS    21      -0.855  18.749  25.389  1.00  9.65           O  
ATOM    195  CB  LYS    21      -2.311  16.147  25.637  0.52  8.96           C  
ATOM    197  CG  LYS    21      -3.427  15.322  24.947  0.52 10.89           C  
ATOM    199  CD  LYS    21      -4.560  14.849  25.851  0.52 14.15           C  
ATOM    201  CE  LYS    21      -5.655  14.138  25.022  0.52 14.68           C  
ATOM    203  NZ  LYS    21      -6.579  13.275  25.848  0.52 13.50           N  
ATOM    205  N   THR    22       0.857  17.327  25.765  1.00  8.24           N  
ATOM    206  CA  THR    22       1.672  18.314  26.464  1.00  8.54           C  
ATOM    207  C   THR    22       3.023  18.504  25.783  1.00  8.63           C  
ATOM    208  O   THR    22       3.145  19.231  24.793  1.00  9.20           O  
ATOM    209  CB  THR    22       1.763  18.000  27.992  1.00 10.21           C  
ATOM    210  OG1 THR    22       2.381  16.735  28.229  1.00  9.41           O  
ATOM    211  CG2 THR    22       0.403  18.068  28.666  1.00 11.24           C  
ATOM    212  N   LEU    23       4.030  17.846  26.288  1.00  8.41           N  
ATOM    213  CA  LEU    23       5.393  18.041  25.817  1.00  9.05           C  
ATOM    214  C   LEU    23       5.555  17.805  24.314  1.00  8.93           C  
ATOM    215  O   LEU    23       6.243  18.561  23.636  1.00  9.40           O  
ATOM    216  CB  LEU    23       6.288  17.088  26.585  1.00 10.54           C  
ATOM    217  CG  LEU    23       7.755  17.241  26.300  1.00 13.35           C  
ATOM    218  CD1 LEU    23       8.234  18.660  26.616  1.00 13.77           C  
ATOM    219  CD2 LEU    23       8.515  16.191  27.077  1.00 15.65           C  
ATOM    220  N   PHE    24       4.921  16.768  23.780  1.00  7.77           N  
ATOM    221  CA  PHE    24       5.067  16.460  22.361  1.00  7.58           C  
ATOM    222  C   PHE    24       4.078  17.202  21.464  1.00  7.62           C  
ATOM    223  O   PHE    24       4.204  17.173  20.245  1.00  8.46           O  
ATOM    224  CB  PHE    24       4.886  14.960  22.066  1.00  7.43           C  
ATOM    225  CG  PHE    24       6.000  14.056  22.471  1.00  7.96           C  
ATOM    226  CD1 PHE    24       7.061  14.462  23.247  1.00  8.92           C  
ATOM    227  CD2 PHE    24       5.931  12.739  22.097  1.00  8.54           C  
ATOM    228  CE1 PHE    24       8.022  13.538  23.649  1.00  9.73           C  
ATOM    229  CE2 PHE    24       6.904  11.835  22.495  1.00 10.13           C  
ATOM    230  CZ  PHE    24       7.948  12.221  23.230  1.00  9.82           C  
ATOM    231  N   ALA    25       3.091  17.867  22.052  1.00  8.31           N  
ATOM    232  CA  ALA    25       2.015  18.435  21.232  1.00  8.01           C  
ATOM    233  C   ALA    25       2.484  19.228  20.000  1.00  8.06           C  
ATOM    234  O   ALA    25       1.914  19.078  18.920  1.00  8.05           O  
ATOM    235  CB  ALA    25       1.051  19.291  22.060  1.00  9.40           C  
ATOM    236  N   PRO    26       3.494  20.097  20.126  1.00  8.11           N  
ATOM    237  CA  PRO    26       3.866  20.886  18.956  1.00  8.19           C  
ATOM    238  C   PRO    26       4.464  20.111  17.785  1.00  7.84           C  
ATOM    239  O   PRO    26       4.461  20.600  16.647  1.00  8.42           O  
ATOM    240  CB  PRO    26       4.912  21.858  19.489  1.00 10.25           C  
ATOM    241  CG  PRO    26       5.213  21.496  20.784  1.00 15.30           C  
ATOM    242  CD  PRO    26       4.235  20.516  21.324  1.00  9.57           C  
ATOM    243  N   ILE    27       4.940  18.897  18.046  1.00  7.18           N  
ATOM    244  CA  ILE    27       5.610  18.172  16.962  1.00  7.05           C  
ATOM    245  C   ILE    27       4.629  17.692  15.910  1.00  6.91           C  
ATOM    246  O   ILE    27       5.002  17.552  14.740  1.00  7.44           O  
ATOM    247  CB  ILE    27       6.453  16.990  17.458  1.00  7.30           C  
ATOM    248  CG1 ILE    27       5.629  15.768  17.830  1.00  7.74           C  
ATOM    249  CG2 ILE    27       7.385  17.453  18.598  1.00  8.53           C  
ATOM    250  CD1 ILE    27       6.414  14.665  18.487  1.00  9.05           C  
ATOM    251  N   TYR    28       3.379  17.437  16.300  1.00  6.72           N  
ATOM    252  CA  TYR    28       2.470  16.771  15.368  1.00  7.01           C  
ATOM    253  C   TYR    28       2.098  17.686  14.170  1.00  6.99           C  
ATOM    254  O   TYR    28       2.157  17.224  13.039  1.00  7.14           O  
ATOM    255  CB  TYR    28       1.268  16.172  16.092  1.00  7.55           C  
ATOM    256  CG  TYR    28       1.700  15.172  17.130  1.00  6.77           C  
ATOM    257  CD1 TYR    28       2.076  13.900  16.777  1.00  7.31           C  
ATOM    258  CD2 TYR    28       1.712  15.496  18.476  1.00  7.57           C  
ATOM    259  CE1 TYR    28       2.502  12.982  17.725  1.00  6.97           C  
ATOM    260  CE2 TYR    28       2.133  14.588  19.435  1.00  7.99           C  
ATOM    261  CZ  TYR    28       2.498  13.336  19.065  1.00  7.33           C  
ATOM    262  OH  TYR    28       2.883  12.442  20.051  1.00  9.14           O  
ATOM    263  N   PRO    29       1.728  18.953  14.417  1.00  6.96           N  
ATOM    264  CA  PRO    29       1.485  19.814  13.265  1.00  7.46           C  
ATOM    265  C   PRO    29       2.723  20.018  12.400  1.00  7.10           C  
ATOM    266  O   PRO    29       2.605  20.183  11.192  1.00  7.69           O  
ATOM    267  CB  PRO    29       0.974  21.118  13.866  1.00  8.48           C  
ATOM    268  CG  PRO    29       1.138  20.983  15.303  1.00 13.62           C  
ATOM    269  CD  PRO    29       1.334  19.581  15.680  1.00  8.11           C  
ATOM    270  N   ILE    30       3.905  20.050  13.004  1.00  7.19           N  
ATOM    271  CA  ILE    30       5.143  20.237  12.242  1.00  6.88           C  
ATOM    272  C   ILE    30       5.403  19.006  11.355  1.00  7.03           C  
ATOM    273  O   ILE    30       5.741  19.136  10.183  1.00  7.09           O  
ATOM    274  CB  ILE    30       6.351  20.520  13.169  1.00  7.04           C  
ATOM    275  CG1 ILE    30       6.168  21.881  13.877  1.00  8.69           C  
ATOM    276  CG2 ILE    30       7.679  20.458  12.422  1.00  9.30           C  
ATOM    277  CD1 ILE    30       6.185  23.079  12.950  1.00 10.79           C  
ATOM    278  N   ILE    31       5.272  17.819  11.925  1.00  6.61           N  
ATOM    279  CA  ILE    31       5.492  16.611  11.159  1.00  6.92           C  
ATOM    280  C   ILE    31       4.456  16.528  10.042  1.00  6.73           C  
ATOM    281  O   ILE    31       4.786  16.171   8.892  1.00  6.99           O  
ATOM    282  CB  ILE    31       5.472  15.375  12.054  1.00  7.14           C  
ATOM    283  CG1 ILE    31       6.700  15.397  12.998  1.00  6.96           C  
ATOM    284  CG2 ILE    31       5.478  14.099  11.208  1.00  8.22           C  
ATOM    285  CD1 ILE    31       6.661  14.361  14.125  1.00  8.75           C  
ATOM    286  N   ALA    32       3.195  16.817  10.341  1.00  6.98           N  
ATOM    287  CA  ALA    32       2.162  16.816   9.305  1.00  7.60           C  
ATOM    288  C   ALA    32       2.490  17.772   8.173  1.00  6.55           C  
ATOM    289  O   ALA    32       2.366  17.453   6.998  1.00  6.98           O  
ATOM    290  CB  ALA    32       0.793  17.136   9.928  1.00  7.82           C  
ATOM    291  N   GLU    33       2.943  18.965   8.533  1.00  6.56           N  
ATOM    292  CA  GLU    33       3.330  19.953   7.552  1.00  7.54           C  
ATOM    293  C   GLU    33       4.509  19.462   6.732  1.00  7.00           C  
ATOM    294  O   GLU    33       4.548  19.633   5.506  1.00  7.66           O  
ATOM    295  CB  GLU    33       3.661  21.262   8.272  1.00  7.76           C  
ATOM    296  CG  GLU    33       4.174  22.352   7.390  1.00 10.06           C  
ATOM    297  CD  GLU    33       4.400  23.640   8.136  1.00 12.92           C  
ATOM    298  OE1 GLU    33       5.047  23.663   9.184  1.00 17.46           O  
ATOM    299  OE2 GLU    33       3.891  24.633   7.658  1.00 18.89           O  
ATOM    300  N   ASN    34       5.482  18.836   7.386  1.00  7.18           N  
ATOM    301  CA  ASN    34       6.636  18.291   6.686  1.00  7.24           C  
ATOM    302  C   ASN    34       6.184  17.268   5.636  1.00  7.17           C  
ATOM    303  O   ASN    34       6.698  17.263   4.500  1.00  7.61           O  
ATOM    304  CB  ASN    34       7.619  17.610   7.640  1.00  7.23           C  
ATOM    305  CG  ASN    34       8.377  18.580   8.503  1.00  8.40           C  
ATOM    306  OD1 ASN    34       8.422  19.779   8.205  1.00  9.80           O  
ATOM    307  ND2 ASN    34       9.018  18.060   9.551  1.00  9.22           N  
ATOM    308  N   ILE    35       5.227  16.404   6.002  1.00  7.02           N  
ATOM    309  CA  ILE    35       4.750  15.360   5.117  1.00  7.18           C  
ATOM    310  C   ILE    35       4.006  15.973   3.924  1.00  6.48           C  
ATOM    311  O   ILE    35       4.217  15.581   2.755  1.00  7.12           O  
ATOM    312  CB  ILE    35       3.846  14.379   5.893  1.00  7.39           C  
ATOM    313  CG1 ILE    35       4.678  13.599   6.915  1.00  8.00           C  
ATOM    314  CG2 ILE    35       3.077  13.456   4.933  1.00  9.13           C  
ATOM    315  CD1 ILE    35       3.808  12.938   7.996  1.00  9.04           C  
ATOM    316  N   ILE    36       3.135  16.920   4.199  1.00  6.43           N  
ATOM    317  CA  ILE    36       2.396  17.615   3.134  1.00  6.88           C  
ATOM    318  C   ILE    36       3.357  18.290   2.181  1.00  7.45           C  
ATOM    319  O   ILE    36       3.210  18.201   0.954  1.00  7.42           O  
ATOM    320  CB  ILE    36       1.361  18.589   3.754  1.00  7.55           C  
ATOM    321  CG1 ILE    36       0.248  17.777   4.421  1.00  8.70           C  
ATOM    322  CG2 ILE    36       0.837  19.572   2.683  1.00  9.97           C  
ATOM    323  CD1 ILE    36      -0.653  18.558   5.339  1.00 12.24           C  
ATOM    324  N   ASN    37       4.329  18.991   2.745  1.00  7.38           N  
ATOM    325  CA  ASN    37       5.276  19.736   1.919  1.00  8.10           C  
ATOM    326  C   ASN    37       6.164  18.813   1.110  1.00  7.67           C  
ATOM    327  O   ASN    37       6.515  19.126  -0.030  1.00  9.85           O  
ATOM    328  CB  ASN    37       6.151  20.633   2.769  1.00  8.87           C  
ATOM    329  CG  ASN    37       5.412  21.835   3.316  1.00 10.85           C  
ATOM    330  OD1 ASN    37       4.281  22.121   2.904  1.00 12.97           O  
ATOM    331  ND2 ASN    37       6.019  22.525   4.284  1.00 13.28           N  
ATOM    332  N   ARG    38       6.538  17.670   1.678  1.00  7.47           N  
ATOM    333  CA  ARG    38       7.474  16.807   1.003  0.52  8.07           C  
ATOM    335  C   ARG    38       6.876  16.121  -0.239  1.00 10.01           C  
ATOM    336  O   ARG    38       7.538  16.008  -1.253  1.00 10.10           O  
ATOM    337  CB  ARG    38       8.042  15.816   2.010  0.52  7.49           C  
ATOM    339  CG  ARG    38       9.277  15.167   1.514  0.52  7.20           C  
ATOM    341  CD  ARG    38       9.981  14.327   2.572  0.52  7.52           C  
ATOM    343  NE  ARG    38      11.111  13.683   1.952  0.52  6.54           N  
ATOM    345  CZ  ARG    38      12.386  13.780   2.326  0.52  8.59           C  
ATOM    347  NH1 ARG    38      12.775  14.317   3.477  0.52  7.08           N  
ATOM    349  NH2 ARG    38      13.282  13.207   1.572  0.52  7.93           N  
ATOM    351  N   PHE    39       5.654  15.552  -0.094  1.00  9.61           N  
ATOM    352  CA  PHE    39       5.065  14.786  -1.146  1.00  8.65           C  
ATOM    353  C   PHE    39       3.976  15.460  -1.928  1.00  8.39           C  
ATOM    354  O   PHE    39       3.674  15.014  -3.023  1.00  9.72           O  
ATOM    355  CB  PHE    39       4.540  13.467  -0.594  1.00  8.88           C  
ATOM    356  CG  PHE    39       5.532  12.708   0.247  1.00  8.23           C  
ATOM    357  CD1 PHE    39       6.722  12.259  -0.278  1.00  8.94           C  
ATOM    358  CD2 PHE    39       5.284  12.480   1.575  1.00 10.04           C  
ATOM    359  CE1 PHE    39       7.620  11.571   0.495  1.00  9.70           C  
ATOM    360  CE2 PHE    39       6.179  11.796   2.364  1.00 12.97           C  
ATOM    361  CZ  PHE    39       7.356  11.341   1.817  1.00 12.09           C  
ATOM    362  N   GLY    40       3.388  16.521  -1.409  1.00  7.85           N  
ATOM    363  CA  GLY    40       2.312  17.174  -2.138  1.00  8.79           C  
ATOM    364  C   GLY    40       1.030  16.367  -2.229  1.00  8.85           C  
ATOM    365  O   GLY    40       0.188  16.673  -3.083  1.00 10.77           O  
ATOM    366  N   ILE    41       0.882  15.345  -1.375  1.00  8.99           N  
ATOM    367  CA  ILE    41      -0.336  14.518  -1.300  1.00  9.47           C  
ATOM    368  C   ILE    41      -1.213  15.140  -0.236  1.00  8.66           C  
ATOM    369  O   ILE    41      -0.787  15.277   0.913  1.00  9.73           O  
ATOM    370  CB  ILE    41      -0.058  13.034  -0.988  1.00  9.34           C  
ATOM    371  CG1 ILE    41       1.083  12.448  -1.847  1.00  9.24           C  
ATOM    372  CG2 ILE    41      -1.336  12.233  -1.198  1.00 10.11           C  
ATOM    373  CD1 ILE    41       1.665  11.148  -1.289  1.00 12.39           C  
ATOM    374  N   THR    42      -2.415  15.581  -0.628  1.00  9.48           N  
ATOM    375  CA  THR    42      -3.275  16.361   0.307  1.00 10.42           C  
ATOM    376  C   THR    42      -4.692  15.755   0.480  1.00  9.48           C  
ATOM    377  O   THR    42      -5.541  16.311   1.133  1.00 10.21           O  
ATOM    378  CB  THR    42      -3.376  17.807  -0.171  1.00 11.69           C  
ATOM    379  OG1 THR    42      -3.894  17.844  -1.506  1.00 14.96           O  
ATOM    380  CG2 THR    42      -2.011  18.491  -0.160  1.00 14.68           C  
ATOM    381  N   ALA    43      -4.956  14.730  -0.309  1.00  9.15           N  
ATOM    382  CA  ALA    43      -6.217  14.028  -0.314  1.00  9.37           C  
ATOM    383  C   ALA    43      -6.043  12.572  -0.708  1.00  9.19           C  
ATOM    384  O   ALA    43      -4.960  12.147  -1.105  1.00 11.46           O  
ATOM    385  CB  ALA    43      -7.258  14.742  -1.240  1.00 10.44           C  
ATOM    386  N   GLY    44      -7.126  11.829  -0.664  1.00 10.43           N  
ATOM    387  CA  GLY    44      -7.098  10.385  -0.901  1.00 10.01           C  
ATOM    388  C   GLY    44      -7.096   9.682   0.450  1.00 10.00           C  
ATOM    389  O   GLY    44      -7.731  10.144   1.407  1.00 11.67           O  
ATOM    390  N   ASN    45      -6.362   8.594   0.535  1.00  8.32           N  
ATOM    391  CA  ASN    45      -6.335   7.768   1.732  1.00  8.24           C  
ATOM    392  C   ASN    45      -4.975   7.794   2.398  1.00  8.40           C  
ATOM    393  O   ASN    45      -3.927   7.720   1.753  1.00  9.29           O  
ATOM    394  CB  ASN    45      -6.695   6.336   1.331  1.00  9.68           C  
ATOM    397  N   CYS    46      -5.000   7.940   3.707  1.00  7.79           N  
ATOM    398  CA  CYS    46      -3.796   7.934   4.538  1.00  7.37           C  
ATOM    399  C   CYS    46      -3.960   6.957   5.687  1.00  6.93           C  
ATOM    400  O   CYS    46      -4.992   6.985   6.372  1.00  8.49           O  
ATOM    401  CB  CYS    46      -3.532   9.335   5.099  1.00  8.02           C  
ATOM    402  SG  CYS    46      -2.142   9.452   6.229  1.00 10.58           S  
ATOM    403  N   ILE    47      -2.977   6.083   5.859  1.00  6.83           N  
ATOM    404  CA  ILE    47      -2.969   5.136   6.973  1.00  6.92           C  
ATOM    405  C   ILE    47      -1.869   5.568   7.934  1.00  6.74           C  
ATOM    406  O   ILE    47      -0.734   5.773   7.511  1.00  7.56           O  
ATOM    407  CB  ILE    47      -2.696   3.684   6.527  1.00  8.48           C  
ATOM    408  CG1 ILE    47      -3.578   3.260   5.350  1.00 10.58           C  
ATOM    409  CG2 ILE    47      -2.814   2.742   7.694  1.00 10.64           C  
ATOM    410  CD1 ILE    47      -5.056   3.398   5.512  1.00 12.24           C  
ATOM    411  N   ASP    48      -2.222   5.749   9.213  1.00  7.07           N  
ATOM    412  CA  ASP    48      -1.302   6.081  10.300  1.00  6.60           C  
ATOM    413  C   ASP    48      -1.114   4.801  11.114  1.00  6.67           C  
ATOM    414  O   ASP    48      -2.003   4.357  11.833  1.00  8.14           O  
ATOM    415  CB  ASP    48      -1.906   7.217  11.122  1.00  7.17           C  
ATOM    416  CG  ASP    48      -1.052   7.660  12.289  1.00  7.98           C  
ATOM    417  OD1 ASP    48       0.114   7.232  12.370  1.00  9.38           O  
ATOM    418  OD2 ASP    48      -1.585   8.439  13.116  1.00  8.93           O  
ATOM    419  N   ILE    49       0.060   4.189  10.967  1.00  6.49           N  
ATOM    420  CA  ILE    49       0.363   2.908  11.602  1.00  6.46           C  
ATOM    421  C   ILE    49       0.972   3.136  12.977  1.00  6.15           C  
ATOM    422  O   ILE    49       1.947   3.859  13.134  1.00  7.92           O  
ATOM    423  CB  ILE    49       1.274   2.053  10.725  1.00  7.77           C  
ATOM    424  CG1 ILE    49       0.588   1.788   9.356  1.00  9.01           C  
ATOM    425  CG2 ILE    49       1.630   0.728  11.446  1.00  8.68           C  
ATOM    426  CD1 ILE    49       1.448   0.984   8.392  1.00 10.96           C  
ATOM    427  N   GLY    50       0.397   2.484  13.975  1.00  6.58           N  
ATOM    428  CA  GLY    50       0.799   2.677  15.352  1.00  6.69           C  
ATOM    429  C   GLY    50       0.390   4.064  15.811  1.00  6.03           C  
ATOM    430  O   GLY    50       1.177   4.805  16.412  1.00  7.71           O  
ATOM    431  N   SER    51      -0.872   4.400  15.538  1.00  6.38           N  
ATOM    432  CA  SER    51      -1.406   5.722  15.732  1.00  6.50           C  
ATOM    433  C   SER    51      -1.492   6.169  17.198  1.00  6.71           C  
ATOM    434  O   SER    51      -1.535   7.367  17.477  1.00  7.54           O  
ATOM    435  CB  SER    51      -2.787   5.792  15.058  1.00  7.66           C  
ATOM    436  OG  SER    51      -3.566   4.627  15.335  1.00  7.63           O  
ATOM    437  N   GLY    52      -1.540   5.209  18.122  1.00  6.79           N  
ATOM    438  CA  GLY    52      -1.511   5.535  19.525  1.00  7.71           C  
ATOM    439  C   GLY    52      -2.698   6.405  19.913  1.00  7.28           C  
ATOM    440  O   GLY    52      -3.822   6.137  19.521  1.00  7.82           O  
ATOM    441  N   PRO    53      -2.472   7.474  20.700  1.00  7.60           N  
ATOM    442  CA  PRO    53      -3.569   8.361  21.066  1.00  8.11           C  
ATOM    443  C   PRO    53      -4.139   9.195  19.911  1.00  7.80           C  
ATOM    444  O   PRO    53      -5.121   9.900  20.106  1.00  8.40           O  
ATOM    445  CB  PRO    53      -2.948   9.283  22.121  1.00 10.37           C  
ATOM    446  CG  PRO    53      -1.764   8.546  22.652  1.00 11.26           C  
ATOM    447  CD  PRO    53      -1.246   7.779  21.461  1.00  9.95           C  
ATOM    448  N   GLY    54      -3.515   9.113  18.725  1.00  7.73           N  
ATOM    449  CA  GLY    54      -4.052   9.702  17.521  1.00  7.97           C  
ATOM    450  C   GLY    54      -3.551  11.055  17.113  1.00  7.36           C  
ATOM    451  O   GLY    54      -4.084  11.644  16.173  1.00  8.91           O  
ATOM    452  N   ALA    55      -2.528  11.586  17.785  1.00  8.21           N  
ATOM    453  CA  ALA    55      -2.156  12.975  17.554  1.00  8.70           C  
ATOM    454  C   ALA    55      -1.640  13.243  16.152  1.00  7.97           C  
ATOM    455  O   ALA    55      -1.848  14.334  15.648  1.00  9.08           O  
ATOM    456  CB  ALA    55      -1.178  13.479  18.609  1.00 11.23           C  
ATOM    457  N   LEU    56      -0.946  12.297  15.527  1.00  7.81           N  
ATOM    458  CA  LEU    56      -0.446  12.560  14.163  1.00  8.20           C  
ATOM    459  C   LEU    56      -1.617  12.570  13.176  1.00  7.59           C  
ATOM    460  O   LEU    56      -1.687  13.404  12.287  1.00  8.15           O  
ATOM    461  CB  LEU    56       0.637  11.561  13.728  1.00  8.89           C  
ATOM    462  CG  LEU    56       1.266  11.813  12.358  1.00  9.14           C  
ATOM    463  CD1 LEU    56       1.879  13.237  12.252  1.00 11.63           C  
ATOM    464  CD2 LEU    56       2.290  10.716  12.080  1.00 11.52           C  
ATOM    465  N   SER    57      -2.551  11.652  13.357  1.00  7.75           N  
ATOM    466  CA  SER    57      -3.743  11.610  12.512  1.00  7.27           C  
ATOM    467  C   SER    57      -4.557  12.903  12.649  1.00  7.41           C  
ATOM    468  O   SER    57      -5.066  13.452  11.671  1.00  7.91           O  
ATOM    469  CB  SER    57      -4.618  10.406  12.841  1.00  8.21           C  
ATOM    470  OG  SER    57      -4.062   9.190  12.378  1.00  8.44           O  
ATOM    471  N   ILE    58      -4.745  13.345  13.890  1.00  7.25           N  
ATOM    472  CA  ILE    58      -5.480  14.585  14.156  1.00  7.79           C  
ATOM    473  C   ILE    58      -4.773  15.785  13.471  1.00  7.84           C  
ATOM    474  O   ILE    58      -5.433  16.583  12.792  1.00  8.09           O  
ATOM    475  CB  ILE    58      -5.685  14.796  15.672  1.00  8.23           C  
ATOM    476  CG1 ILE    58      -6.683  13.739  16.214  1.00  9.21           C  
ATOM    477  CG2 ILE    58      -6.082  16.223  15.953  1.00 10.08           C  
ATOM    478  CD1 ILE    58      -6.760  13.695  17.734  1.00 11.50           C  
ATOM    479  N   ALA    59      -3.452  15.866  13.587  1.00  8.01           N  
ATOM    480  CA  ALA    59      -2.736  16.967  12.980  1.00  8.60           C  
ATOM    481  C   ALA    59      -2.859  16.937  11.458  1.00  8.17           C  
ATOM    482  O   ALA    59      -3.075  17.959  10.817  1.00  9.25           O  
ATOM    483  CB  ALA    59      -1.268  16.929  13.417  1.00  9.10           C  
ATOM    484  N   LEU    60      -2.754  15.752  10.874  1.00  8.03           N  
ATOM    485  CA  LEU    60      -2.905  15.615   9.418  0.76  8.55           C  
ATOM    487  C   LEU    60      -4.306  15.997   8.963  1.00  8.29           C  
ATOM    488  O   LEU    60      -4.483  16.669   7.945  1.00  9.33           O  
ATOM    489  CB  LEU    60      -2.542  14.195   8.942  0.76  8.80           C  
ATOM    491  CG  LEU    60      -1.070  13.885   8.762  0.76  8.87           C  
ATOM    493  CD1 LEU    60      -0.846  12.360   8.732  0.76 11.37           C  
ATOM    495  CD2 LEU    60      -0.509  14.531   7.485  0.76  9.21           C  
ATOM    497  N   ALA    61      -5.316  15.564   9.715  1.00  8.32           N  
ATOM    498  CA  ALA    61      -6.703  15.897   9.354  1.00  7.81           C  
ATOM    499  C   ALA    61      -6.910  17.405   9.315  1.00  8.61           C  
ATOM    500  O   ALA    61      -7.605  17.940   8.454  1.00  9.99           O  
ATOM    501  CB  ALA    61      -7.672  15.232  10.329  1.00  9.68           C  
ATOM    502  N   LYS    62      -6.312  18.105  10.265  1.00  8.27           N  
ATOM    503  CA  LYS    62      -6.511  19.548  10.351  1.00 10.14           C  
ATOM    504  C   LYS    62      -5.826  20.333   9.239  1.00 10.18           C  
ATOM    505  O   LYS    62      -6.210  21.467   8.971  1.00 13.87           O  
ATOM    506  CB  LYS    62      -6.037  20.060  11.707  1.00 10.06           C  
ATOM    507  CG  LYS    62      -6.911  19.610  12.875  1.00 12.40           C  
ATOM    508  CD  LYS    62      -6.321  20.107  14.178  1.00 15.89           C  
ATOM    509  CE  LYS    62      -7.123  19.696  15.395  1.00 21.55           C  
ATOM    510  NZ  LYS    62      -6.366  20.077  16.635  1.00 25.13           N  
ATOM    511  N   GLN    63      -4.879  19.706   8.559  1.00  8.63           N  
ATOM    512  CA  GLN    63      -4.116  20.380   7.512  1.00  8.33           C  
ATOM    513  C   GLN    63      -4.371  19.866   6.115  1.00  8.54           C  
ATOM    514  O   GLN    63      -3.744  20.365   5.180  1.00 10.07           O  
ATOM    515  CB  GLN    63      -2.608  20.289   7.767  1.00  9.53           C  
ATOM    516  CG  GLN    63      -2.132  21.066   8.946  1.00  9.43           C  
ATOM    517  CD  GLN    63      -0.626  21.029   9.102  1.00  9.46           C  
ATOM    518  OE1 GLN    63       0.141  21.216   8.140  1.00 10.56           O  
ATOM    519  NE2 GLN    63      -0.199  20.877  10.335  1.00 10.08           N  
ATOM    520  N   SER    64      -5.287  18.914   5.933  1.00  8.57           N  
ATOM    521  CA  SER    64      -5.479  18.261   4.636  1.00  9.29           C  
ATOM    522  C   SER    64      -6.902  17.778   4.470  1.00  9.12           C  
ATOM    523  O   SER    64      -7.704  17.887   5.394  1.00  9.90           O  
ATOM    524  CB  SER    64      -4.581  17.021   4.542  1.00 10.86           C  
ATOM    525  OG  SER    64      -5.081  15.978   5.391  1.00 12.56           O  
ATOM    526  N   ASP    65      -7.146  17.145   3.326  1.00  8.63           N  
ATOM    527  CA  ASP    65      -8.441  16.564   2.997  1.00  8.06           C  
ATOM    528  C   ASP    65      -8.403  15.029   2.964  1.00  8.02           C  
ATOM    529  O   ASP    65      -9.255  14.405   2.356  1.00 10.25           O  
ATOM    530  CB  ASP    65      -8.965  17.103   1.651  1.00  8.89           C  
ATOM    531  CG  ASP    65      -9.006  18.598   1.610  1.00 10.85           C  
ATOM    532  OD1 ASP    65      -9.445  19.186   2.588  1.00 13.30           O  
ATOM    533  OD2 ASP    65      -8.576  19.191   0.595  1.00  9.68           O  
ATOM    534  N   PHE    66      -7.401  14.428   3.580  1.00  7.91           N  
ATOM    535  CA  PHE    66      -7.343  12.989   3.603  1.00  8.61           C  
ATOM    536  C   PHE    66      -8.453  12.304   4.378  1.00  7.63           C  
ATOM    537  O   PHE    66      -8.965  12.850   5.360  1.00  8.56           O  
ATOM    538  CB  PHE    66      -6.057  12.491   4.328  1.00  9.45           C  
ATOM    539  CG  PHE    66      -4.795  12.575   3.523  1.00  8.86           C  
ATOM    540  CD1 PHE    66      -4.565  11.692   2.481  1.00  9.16           C  
ATOM    541  CD2 PHE    66      -3.790  13.435   3.872  1.00 10.05           C  
ATOM    542  CE1 PHE    66      -3.384  11.729   1.776  1.00  9.50           C  
ATOM    543  CE2 PHE    66      -2.602  13.475   3.144  1.00 10.62           C  
ATOM    544  CZ  PHE    66      -2.412  12.618   2.118  1.00 10.79           C  
ATOM    545  N   SER    67      -8.799  11.109   3.900  1.00  7.80           N  
ATOM    546  CA  SER    67      -9.575  10.149   4.672  0.48  7.51           C  
ATOM    549  C   SER    67      -8.512   9.324   5.388  1.00  7.49           C  
ATOM    550  O   SER    67      -7.698   8.663   4.745  1.00  9.48           O  
ATOM    551  CB  SER    67     -10.411   9.241   3.776  0.48  8.28           C  
ATOM    554  OG  SER    67     -11.327   9.975   2.955  0.48 10.11           O  
ATOM    557  N   ILE    68      -8.496   9.367   6.710  1.00  7.00           N  
ATOM    558  CA  ILE    68      -7.434   8.716   7.495  1.00  7.24           C  
ATOM    559  C   ILE    68      -7.918   7.521   8.263  1.00  6.90           C  
ATOM    560  O   ILE    68      -9.043   7.525   8.805  1.00  7.69           O  
ATOM    561  CB  ILE    68      -6.872   9.760   8.505  1.00  7.71           C  
ATOM    562  CG1 ILE    68      -6.289  10.976   7.751  1.00  8.62           C  
ATOM    563  CG2 ILE    68      -5.800   9.127   9.439  1.00  9.32           C  
ATOM    564  CD1 ILE    68      -6.111  12.217   8.602  1.00 12.10           C  
ATOM    565  N   ARG    69      -7.104   6.471   8.250  1.00  7.48           N  
ATOM    566  CA  ARG    69      -7.347   5.293   9.095  0.61  8.21           C  
ATOM    568  C   ARG    69      -6.157   5.189  10.026  1.00  8.11           C  
ATOM    569  O   ARG    69      -4.998   5.202   9.601  1.00  9.74           O  
ATOM    570  CB  ARG    69      -7.496   4.020   8.300  0.61  9.63           C  
ATOM    572  CG  ARG    69      -8.781   4.018   7.536  0.61 11.35           C  
ATOM    574  CD  ARG    69      -8.976   2.762   6.779  0.61 16.48           C  
ATOM    576  NE  ARG    69     -10.115   2.894   5.885  0.61 17.32           N  
ATOM    578  CZ  ARG    69     -10.615   1.895   5.178  0.61 21.59           C  
ATOM    580  NH1 ARG    69     -10.051   0.697   5.246  0.61 26.13           N  
ATOM    582  NH2 ARG    69     -11.671   2.106   4.393  0.61 28.13           N  
ATOM    584  N   ALA    70      -6.461   5.169  11.310  1.00  7.66           N  
ATOM    585  CA  ALA    70      -5.496   5.103  12.415  1.00  7.76           C  
ATOM    586  C   ALA    70      -5.467   3.679  12.936  1.00  7.29           C  
ATOM    587  O   ALA    70      -6.409   3.202  13.557  1.00  8.29           O  
ATOM    588  CB  ALA    70      -5.913   6.079  13.493  1.00  8.97           C  
ATOM    589  N   LEU    71      -4.387   2.974  12.603  1.00  6.50           N  
ATOM    590  CA  LEU    71      -4.237   1.560  12.921  1.00  7.24           C  
ATOM    591  C   LEU    71      -3.357   1.378  14.154  1.00  6.48           C  
ATOM    592  O   LEU    71      -2.228   1.856  14.201  1.00  7.37           O  
ATOM    593  CB  LEU    71      -3.557   0.870  11.729  1.00  7.97           C  
ATOM    594  CG  LEU    71      -3.259  -0.619  11.891  1.00  8.45           C  
ATOM    595  CD1 LEU    71      -4.535  -1.453  11.817  1.00 10.23           C  
ATOM    596  CD2 LEU    71      -2.287  -1.128  10.823  1.00 11.95           C  
ATOM    597  N   ASP    72      -3.857   0.666  15.143  1.00  7.11           N  
ATOM    598  CA  ASP    72      -3.058   0.368  16.333  1.00  6.22           C  
ATOM    599  C   ASP    72      -3.479  -0.977  16.901  1.00  6.55           C  
ATOM    600  O   ASP    72      -4.660  -1.320  16.882  1.00  7.28           O  
ATOM    601  CB  ASP    72      -3.210   1.474  17.369  1.00  7.24           C  
ATOM    602  CG  ASP    72      -2.052   1.496  18.358  1.00  7.04           C  
ATOM    603  OD1 ASP    72      -1.958   0.596  19.211  1.00  7.74           O  
ATOM    604  OD2 ASP    72      -1.204   2.424  18.262  1.00  7.78           O  
ATOM    605  N   PHE    73      -2.521  -1.745  17.392  1.00  6.76           N  
ATOM    606  CA  PHE    73      -2.785  -3.063  17.933  1.00  6.81           C  
ATOM    607  C   PHE    73      -3.192  -3.074  19.382  1.00  6.80           C  
ATOM    608  O   PHE    73      -3.543  -4.141  19.891  1.00  8.21           O  
ATOM    609  CB  PHE    73      -1.632  -4.070  17.627  1.00  7.26           C  
ATOM    610  CG  PHE    73      -0.408  -3.996  18.517  1.00  7.03           C  
ATOM    611  CD1 PHE    73      -0.103  -2.904  19.316  1.00  7.74           C  
ATOM    612  CD2 PHE    73       0.468  -5.064  18.492  1.00  8.56           C  
ATOM    613  CE1 PHE    73       1.057  -2.920  20.091  1.00  8.30           C  
ATOM    614  CE2 PHE    73       1.611  -5.070  19.245  1.00 10.15           C  
ATOM    615  CZ  PHE    73       1.916  -3.997  20.054  1.00  9.14           C  
ATOM    616  N   SER    74      -3.220  -1.909  20.032  1.00  7.40           N  
ATOM    617  CA  SER    74      -3.577  -1.811  21.438  1.00  7.37           C  
ATOM    618  C   SER    74      -4.983  -1.276  21.611  1.00  7.52           C  
ATOM    619  O   SER    74      -5.278  -0.117  21.260  1.00  7.51           O  
ATOM    620  CB  SER    74      -2.592  -0.915  22.189  1.00  8.08           C  
ATOM    621  OG  SER    74      -3.141  -0.600  23.453  1.00  7.86           O  
ATOM    622  N   LYS    75      -5.874  -2.111  22.137  1.00  7.72           N  
ATOM    623  CA  LYS    75      -7.243  -1.709  22.446  0.50  7.68           C  
ATOM    625  C   LYS    75      -7.239  -0.477  23.337  1.00  7.92           C  
ATOM    626  O   LYS    75      -8.090   0.378  23.236  1.00  8.31           O  
ATOM    627  CB  LYS    75      -7.968  -2.849  23.193  0.50  8.60           C  
ATOM    629  CG  LYS    75      -9.367  -2.509  23.636  0.50 12.08           C  
ATOM    631  CD  LYS    75     -10.242  -2.238  22.487  0.50 16.33           C  
ATOM    633  CE  LYS    75     -11.699  -2.068  22.902  0.50 20.58           C  
ATOM    635  NZ  LYS    75     -12.563  -1.881  21.707  0.50 23.27           N  
ATOM    637  N   HIS    76      -6.295  -0.409  24.277  1.00  8.95           N  
ATOM    638  CA  HIS    76      -6.227   0.715  25.224  1.00  9.08           C  
ATOM    639  C   HIS    76      -5.877   2.024  24.535  1.00  9.07           C  
ATOM    640  O   HIS    76      -6.462   3.065  24.834  1.00  9.81           O  
ATOM    641  CB  HIS    76      -5.234   0.422  26.320  1.00 10.32           C  
ATOM    642  CG  HIS    76      -5.512  -0.864  26.956  1.00 12.91           C  
ATOM    643  ND1 HIS    76      -6.633  -1.045  27.719  1.00 14.05           N  
ATOM    644  CD2 HIS    76      -4.936  -2.075  26.818  1.00 14.52           C  
ATOM    645  CE1 HIS    76      -6.696  -2.310  28.103  1.00 17.11           C  
ATOM    646  NE2 HIS    76      -5.683  -2.958  27.554  1.00 16.00           N  
ATOM    647  N   MET    77      -4.961   1.953  23.581  1.00  8.90           N  
ATOM    648  CA  MET    77      -4.631   3.129  22.776  1.00  9.49           C  
ATOM    649  C   MET    77      -5.863   3.537  21.978  1.00  8.75           C  
ATOM    650  O   MET    77      -6.177   4.714  21.870  1.00  9.24           O  
ATOM    651  CB  MET    77      -3.506   2.837  21.793  1.00 10.74           C  
ATOM    652  CG  MET    77      -2.139   2.700  22.390  1.00 10.69           C  
ATOM    653  SD  MET    77      -1.598   4.441  23.137  0.75  9.35          SE  
ATOM    654  CE  MET    77       0.124   3.861  23.515  1.00 15.04           C  
ATOM    655  N   ASN    78      -6.548   2.563  21.394  1.00  8.02           N  
ATOM    656  CA  ASN    78      -7.679   2.871  20.522  1.00  8.28           C  
ATOM    657  C   ASN    78      -8.843   3.499  21.267  1.00  8.77           C  
ATOM    658  O   ASN    78      -9.546   4.359  20.736  1.00  9.68           O  
ATOM    659  CB  ASN    78      -8.073   1.659  19.685  1.00  8.29           C  
ATOM    660  CG  ASN    78      -7.029   1.345  18.643  1.00  8.37           C  
ATOM    661  OD1 ASN    78      -6.336   2.253  18.171  1.00  9.60           O  
ATOM    662  ND2 ASN    78      -6.911   0.096  18.276  1.00  9.01           N  
ATOM    663  N   GLU    79      -9.033   3.088  22.518  1.00  9.15           N  
ATOM    664  CA  GLU    79     -10.096   3.685  23.340  0.53  9.33           C  
ATOM    666  C   GLU    79      -9.804   5.165  23.561  1.00  9.02           C  
ATOM    667  O   GLU    79     -10.703   6.022  23.470  1.00 10.17           O  
ATOM    668  CB  GLU    79     -10.245   2.954  24.677  0.53 10.77           C  
ATOM    670  CG  GLU    79     -10.824   1.545  24.551  0.53 12.41           C  
ATOM    672  CD  GLU    79     -10.675   0.682  25.807  0.53 20.98           C  
ATOM    674  OE1 GLU    79     -10.045   1.116  26.788  0.53 24.38           O  
ATOM    676  OE2 GLU    79     -11.183  -0.455  25.806  0.53 27.07           O  
ATOM    678  N   ILE    80      -8.553   5.487  23.865  1.00  8.61           N  
ATOM    679  CA  ILE    80      -8.171   6.885  24.073  1.00  9.00           C  
ATOM    680  C   ILE    80      -8.276   7.657  22.745  1.00  8.58           C  
ATOM    681  O   ILE    80      -8.730   8.779  22.727  1.00  8.80           O  
ATOM    682  CB  ILE    80      -6.768   7.009  24.660  1.00  9.84           C  
ATOM    683  CG1 ILE    80      -6.757   6.509  26.078  1.00 12.57           C  
ATOM    684  CG2 ILE    80      -6.278   8.439  24.535  1.00 14.37           C  
ATOM    685  CD1 ILE    80      -5.376   6.543  26.731  1.00 15.85           C  
ATOM    686  N   ALA    81      -7.800   7.050  21.663  1.00  8.09           N  
ATOM    687  CA  ALA    81      -7.807   7.734  20.364  1.00  8.26           C  
ATOM    688  C   ALA    81      -9.247   8.071  19.970  1.00  8.09           C  
ATOM    689  O   ALA    81      -9.524   9.139  19.443  1.00  9.02           O  
ATOM    690  CB  ALA    81      -7.123   6.881  19.289  1.00  9.00           C  
ATOM    691  N   LEU    82     -10.168   7.136  20.206  1.00  8.33           N  
ATOM    692  CA  LEU    82     -11.561   7.378  19.867  0.52  9.58           C  
ATOM    694  C   LEU    82     -12.093   8.620  20.584  1.00  9.47           C  
ATOM    695  O   LEU    82     -12.780   9.465  19.999  1.00 10.24           O  
ATOM    696  CB  LEU    82     -12.439   6.151  20.195  0.52 11.15           C  
ATOM    698  CG  LEU    82     -12.276   4.934  19.274  0.52 10.73           C  
ATOM    700  CD1 LEU    82     -12.788   3.634  19.891  0.52 15.40           C  
ATOM    702  CD2 LEU    82     -12.948   5.175  17.927  0.52 10.68           C  
ATOM    704  N   LYS    83     -11.774   8.727  21.865  1.00  9.39           N  
ATOM    705  CA  LYS    83     -12.185   9.866  22.663  1.00 10.85           C  
ATOM    706  C   LYS    83     -11.520  11.129  22.114  1.00  9.83           C  
ATOM    707  O   LYS    83     -12.163  12.168  21.975  1.00 10.35           O  
ATOM    708  CB  LYS    83     -11.818   9.705  24.137  1.00 11.92           C  
ATOM    709  CG  LYS    83     -12.210  10.893  24.977  1.00 17.87           C  
ATOM    710  CD  LYS    83     -11.780  10.785  26.442  1.00 22.59           C  
ATOM    711  CE  LYS    83     -12.327  11.963  27.272  1.00 24.59           C  
ATOM    712  NZ  LYS    83     -11.687  13.294  26.957  1.00 24.18           N  
ATOM    713  N   ASN    84     -10.218  11.069  21.816  1.00  9.60           N  
ATOM    714  CA  ASN    84      -9.518  12.244  21.313  1.00  9.05           C  
ATOM    715  C   ASN    84     -10.066  12.752  19.982  1.00  8.21           C  
ATOM    716  O   ASN    84     -10.231  13.968  19.778  1.00  9.30           O  
ATOM    717  CB  ASN    84      -8.011  11.971  21.175  1.00  8.02           C  
ATOM    718  CG  ASN    84      -7.310  11.857  22.512  1.00  9.68           C  
ATOM    719  OD1 ASN    84      -7.819  12.367  23.524  1.00 11.50           O  
ATOM    720  ND2 ASN    84      -6.142  11.228  22.538  1.00  8.90           N  
ATOM    721  N   ILE    85     -10.366  11.829  19.076  1.00  8.79           N  
ATOM    722  CA  ILE    85     -10.894  12.158  17.771  0.54  7.79           C  
ATOM    724  C   ILE    85     -12.278  12.804  17.903  1.00  8.39           C  
ATOM    725  O   ILE    85     -12.602  13.793  17.243  1.00  9.86           O  
ATOM    726  CB  ILE    85     -10.876  10.913  16.879  0.54  6.47           C  
ATOM    728  CG1 ILE    85      -9.432  10.550  16.556  0.54  9.65           C  
ATOM    730  CG2 ILE    85     -11.584  11.180  15.583  0.54  8.26           C  
ATOM    732  CD1 ILE    85      -9.270   9.157  16.129  0.54 12.10           C  
ATOM    734  N   ALA    86     -13.074  12.230  18.788  1.00  9.18           N  
ATOM    735  CA  ALA    86     -14.424  12.759  19.032  1.00  9.31           C  
ATOM    736  C   ALA    86     -14.342  14.170  19.652  1.00 10.03           C  
ATOM    737  O   ALA    86     -15.078  15.098  19.269  1.00 11.39           O  
ATOM    738  CB  ALA    86     -15.221  11.821  19.931  1.00 11.37           C  
ATOM    739  N   ASP    87     -13.472  14.336  20.634  1.00 10.44           N  
ATOM    740  CA  ASP    87     -13.315  15.623  21.304  1.00 11.59           C  
ATOM    741  C   ASP    87     -12.910  16.684  20.303  1.00 11.12           C  
ATOM    742  O   ASP    87     -13.283  17.840  20.431  1.00 12.81           O  
ATOM    743  CB  ASP    87     -12.240  15.552  22.380  1.00 12.32           C  
ATOM    744  CG  ASP    87     -12.645  14.822  23.637  1.00 15.89           C  
ATOM    745  OD1 ASP    87     -13.825  14.539  23.843  1.00 17.53           O  
ATOM    746  OD2 ASP    87     -11.754  14.535  24.467  1.00 17.49           O  
ATOM    747  N   ALA    88     -12.123  16.299  19.315  1.00 10.27           N  
ATOM    748  CA  ALA    88     -11.632  17.200  18.272  1.00 11.37           C  
ATOM    749  C   ALA    88     -12.626  17.420  17.135  1.00 11.38           C  
ATOM    750  O   ALA    88     -12.344  18.164  16.201  1.00 12.62           O  
ATOM    751  CB  ALA    88     -10.307  16.697  17.698  1.00 11.36           C  
ATOM    752  N   ASP    89     -13.777  16.756  17.208  1.00 10.69           N  
ATOM    753  CA  ASP    89     -14.796  16.825  16.148  0.49 12.07           C  
ATOM    755  C   ASP    89     -14.249  16.319  14.821  1.00 11.64           C  
ATOM    756  O   ASP    89     -14.501  16.912  13.772  1.00 13.00           O  
ATOM    757  CB  ASP    89     -15.345  18.249  15.991  0.49 13.69           C  
ATOM    759  CG  ASP    89     -16.216  18.668  17.160  0.49 15.45           C  
ATOM    761  OD1 ASP    89     -16.952  17.859  17.725  0.49 16.47           O  
ATOM    763  OD2 ASP    89     -16.148  19.942  17.518  0.49 19.08           N  
ATOM    765  N   LEU    90     -13.515  15.208  14.875  1.00 10.06           N  
ATOM    766  CA  LEU    90     -12.896  14.624  13.694  1.00  9.34           C  
ATOM    767  C   LEU    90     -13.303  13.178  13.407  1.00  8.79           C  
ATOM    768  O   LEU    90     -12.630  12.467  12.684  1.00  8.62           O  
ATOM    769  CB  LEU    90     -11.382  14.738  13.810  1.00  9.05           C  
ATOM    770  CG  LEU    90     -10.842  16.157  13.746  1.00 10.32           C  
ATOM    771  CD1 LEU    90      -9.371  16.121  14.137  1.00 12.89           C  
ATOM    772  CD2 LEU    90     -11.040  16.784  12.365  1.00 13.60           C  
ATOM    773  N   ASN    91     -14.418  12.742  13.962  1.00 10.00           N  
ATOM    774  CA  ASN    91     -14.896  11.371  13.717  0.41 10.39           C  
ATOM    777  C   ASN    91     -15.133  11.097  12.255  1.00  9.16           C  
ATOM    778  O   ASN    91     -15.039   9.957  11.810  1.00 10.41           O  
ATOM    779  CB  ASN    91     -16.205  11.067  14.453  0.41 12.20           C  
ATOM    782  CG  ASN    91     -16.051  11.137  15.929  0.41 13.74           C  
ATOM    785  OD1 ASN    91     -14.981  10.839  16.447  0.41 14.20           O  
ATOM    788  ND2 ASN    91     -17.101  11.528  16.625  0.41 15.67           N  
ATOM    791  N   ASP    92     -15.486  12.139  11.525  1.00  8.87           N  
ATOM    792  CA  ASP    92     -15.703  12.038  10.080  1.00  9.57           C  
ATOM    793  C   ASP    92     -14.416  11.908   9.278  1.00  9.19           C  
ATOM    794  O   ASP    92     -14.467  11.547   8.117  1.00 11.83           O  
ATOM    795  CB  ASP    92     -16.464  13.270   9.561  1.00 11.13           C  
ATOM    796  CG  ASP    92     -15.755  14.592   9.875  1.00 12.48           C  
ATOM    797  OD1 ASP    92     -15.213  14.735  10.979  1.00 15.33           O  
ATOM    798  OD2 ASP    92     -15.714  15.498   9.019  1.00 16.48           O  
ATOM    799  N   ARG    93     -13.296  12.252   9.895  1.00  8.70           N  
ATOM    800  CA  ARG    93     -12.004  12.308   9.205  1.00  8.60           C  
ATOM    801  C   ARG    93     -11.094  11.128   9.474  1.00  8.42           C  
ATOM    802  O   ARG    93     -10.192  10.838   8.652  1.00  8.42           O  
ATOM    803  CB  ARG    93     -11.278  13.589   9.583  1.00  8.88           C  
ATOM    804  CG  ARG    93     -12.061  14.879   9.264  1.00 10.10           C  
ATOM    805  CD  ARG    93     -12.375  15.021   7.752  1.00 10.78           C  
ATOM    806  NE  ARG    93     -11.154  14.900   6.981  1.00  9.70           N  
ATOM    807  CZ  ARG    93     -10.140  15.754   7.001  1.00  9.21           C  
ATOM    808  NH1 ARG    93     -10.204  16.913   7.631  1.00 10.09           N  
ATOM    809  NH2 ARG    93      -9.042  15.429   6.379  1.00  9.76           N  
ATOM    810  N   ILE    94     -11.255  10.500  10.639  1.00  7.68           N  
ATOM    811  CA  ILE    94     -10.338   9.492  11.106  1.00  7.34           C  
ATOM    812  C   ILE    94     -11.125   8.296  11.635  1.00  8.11           C  
ATOM    813  O   ILE    94     -11.981   8.427  12.502  1.00 10.46           O  
ATOM    814  CB  ILE    94      -9.452  10.016  12.246  1.00  8.13           C  
ATOM    815  CG1 ILE    94      -8.662  11.242  11.805  1.00  8.13           C  
ATOM    816  CG2 ILE    94      -8.480   8.920  12.750  1.00  8.96           C  
ATOM    817  CD1 ILE    94      -8.146  12.102  12.990  1.00  9.32           C  
ATOM    818  N   GLN    95     -10.845   7.146  11.052  1.00  7.68           N  
ATOM    819  CA  GLN    95     -11.400   5.872  11.482  1.00  7.54           C  
ATOM    820  C   GLN    95     -10.349   5.113  12.264  1.00  8.31           C  
ATOM    821  O   GLN    95      -9.242   4.918  11.759  1.00  9.00           O  
ATOM    822  CB  GLN    95     -11.798   5.024  10.271  1.00  9.36           C  
ATOM    823  CG  GLN    95     -12.374   3.687  10.694  1.00 11.15           C  
ATOM    824  CD  GLN    95     -12.741   2.784   9.532  1.00 15.09           C  
ATOM    825  OE1 GLN    95     -12.534   3.118   8.363  1.00 23.64           O  
ATOM    826  NE2 GLN    95     -13.323   1.631   9.849  1.00 21.71           N  
ATOM    827  N   ILE    96     -10.674   4.684  13.476  1.00  8.48           N  
ATOM    828  CA  ILE    96      -9.758   3.892  14.281  1.00  9.41           C  
ATOM    829  C   ILE    96      -9.917   2.438  13.865  1.00 10.76           C  
ATOM    830  O   ILE    96     -11.026   1.924  13.776  1.00 14.33           O  
ATOM    831  CB  ILE    96     -10.047   4.124  15.794  1.00 11.62           C  
ATOM    832  CG1 ILE    96      -9.938   5.621  16.183  1.00 14.56           C  
ATOM    833  CG2 ILE    96      -9.151   3.290  16.653  1.00 15.64           C  
ATOM    834  CD1 ILE    96      -8.660   6.355  15.883  1.00 20.14           C  
ATOM    835  N   VAL    97      -8.783   1.797  13.584  1.00  9.63           N  
ATOM    836  CA  VAL    97      -8.751   0.395  13.166  1.00 10.25           C  
ATOM    837  C   VAL    97      -7.899  -0.417  14.134  1.00  9.21           C  
ATOM    838  O   VAL    97      -6.724  -0.152  14.346  1.00  9.63           O  
ATOM    839  CB  VAL    97      -8.192   0.290  11.745  1.00 10.48           C  
ATOM    840  CG1 VAL    97      -8.176  -1.145  11.280  1.00 13.10           C  
ATOM    841  CG2 VAL    97      -8.964   1.213  10.794  1.00 12.97           C  
ATOM    842  N   GLN    98      -8.528  -1.405  14.729  1.00  8.92           N  
ATOM    843  CA  GLN    98      -7.858  -2.314  15.644  1.00  8.81           C  
ATOM    844  C   GLN    98      -7.120  -3.331  14.800  1.00  8.74           C  
ATOM    845  O   GLN    98      -7.738  -4.084  14.040  1.00 11.10           O  
ATOM    846  CB  GLN    98      -8.911  -2.983  16.547  1.00  9.76           C  
ATOM    847  CG  GLN    98      -8.408  -3.986  17.507  1.00 12.22           C  
ATOM    848  CD  GLN    98      -7.655  -3.356  18.635  1.00 12.03           C  
ATOM    849  OE1 GLN    98      -8.102  -2.368  19.246  1.00 14.32           O  
ATOM    850  NE2 GLN    98      -6.489  -3.935  18.947  1.00 13.93           N  
ATOM    851  N   GLY    99      -5.803  -3.371  14.870  1.00  8.36           N  
ATOM    852  CA  GLY    99      -5.061  -4.339  14.094  1.00  8.48           C  
ATOM    853  C   GLY    99      -3.575  -4.113  14.186  1.00  7.51           C  
ATOM    854  O   GLY    99      -3.088  -3.169  14.776  1.00  8.37           O  
ATOM    855  N   ASP   100      -2.856  -5.022  13.555  1.00  9.15           N  
ATOM    856  CA  ASP   100      -1.406  -5.155  13.640  1.00  8.65           C  
ATOM    857  C   ASP   100      -0.763  -4.958  12.280  1.00  8.18           C  
ATOM    858  O   ASP   100      -1.281  -5.423  11.245  1.00  8.84           O  
ATOM    859  CB  ASP   100      -1.120  -6.598  14.152  1.00 10.11           C  
ATOM    860  CG  ASP   100       0.258  -6.814  14.679  1.00 10.02           C  
ATOM    861  OD1 ASP   100       1.245  -6.493  13.994  1.00  9.84           O  
ATOM    862  OD2 ASP   100       0.370  -7.312  15.827  1.00 11.81           O  
ATOM    863  N   VAL   101       0.370  -4.265  12.274  1.00  7.91           N  
ATOM    864  CA  VAL   101       1.136  -4.015  11.059  1.00  8.03           C  
ATOM    865  C   VAL   101       1.521  -5.325  10.343  1.00  8.12           C  
ATOM    866  O   VAL   101       1.772  -5.334   9.147  1.00  8.41           O  
ATOM    867  CB  VAL   101       2.393  -3.156  11.367  1.00  7.51           C  
ATOM    868  CG1 VAL   101       3.426  -3.915  12.194  1.00  8.68           C  
ATOM    869  CG2 VAL   101       2.983  -2.609  10.063  1.00  7.72           C  
ATOM    870  N   HIS   102       1.564  -6.427  11.087  1.00  8.09           N  
ATOM    871  CA  HIS   102       1.951  -7.701  10.481  1.00  9.26           C  
ATOM    872  C   HIS   102       0.804  -8.396   9.777  1.00  9.67           C  
ATOM    873  O   HIS   102       1.015  -9.439   9.151  1.00 11.32           O  
ATOM    874  CB  HIS   102       2.540  -8.660  11.508  1.00  9.93           C  
ATOM    875  CG  HIS   102       3.762  -8.134  12.176  1.00 10.27           C  
ATOM    876  ND1 HIS   102       3.700  -7.419  13.347  1.00 10.22           N  
ATOM    877  CD2 HIS   102       5.064  -8.137  11.803  1.00 11.57           C  
ATOM    878  CE1 HIS   102       4.929  -7.066  13.697  1.00 10.76           C  
ATOM    879  NE2 HIS   102       5.772  -7.483  12.776  1.00 12.79           N  
ATOM    880  N   ASN   103      -0.401  -7.845   9.864  1.00  8.87           N  
ATOM    881  CA  ASN   103      -1.562  -8.444   9.214  1.00  9.43           C  
ATOM    882  C   ASN   103      -2.628  -7.361   9.105  1.00  9.27           C  
ATOM    883  O   ASN   103      -3.615  -7.331   9.823  1.00 10.60           O  
ATOM    884  CB  ASN   103      -2.025  -9.649  10.024  1.00 10.11           C  
ATOM    885  CG  ASN   103      -3.163 -10.342   9.372  1.00 12.51           C  
ATOM    886  OD1 ASN   103      -3.107 -10.581   8.180  1.00 16.56           O  
ATOM    887  ND2 ASN   103      -4.194 -10.712  10.143  1.00 15.23           N  
ATOM    888  N   ILE   104      -2.375  -6.437   8.199  1.00  9.26           N  
ATOM    889  CA  ILE   104      -3.174  -5.215   8.139  1.00  9.26           C  
ATOM    890  C   ILE   104      -4.531  -5.478   7.509  1.00  9.79           C  
ATOM    891  O   ILE   104      -4.590  -5.997   6.394  1.00 10.42           O  
ATOM    892  CB  ILE   104      -2.441  -4.112   7.342  1.00  8.65           C  
ATOM    893  CG1 ILE   104      -1.059  -3.842   7.938  1.00  9.12           C  
ATOM    894  CG2 ILE   104      -3.309  -2.825   7.312  1.00 10.10           C  
ATOM    895  CD1 ILE   104      -0.191  -2.832   7.128  1.00  9.92           C  
ATOM    896  N   PRO   105      -5.622  -5.109   8.191  1.00 10.93           N  
ATOM    897  CA  PRO   105      -6.983  -5.393   7.678  1.00 12.42           C  
ATOM    898  C   PRO   105      -7.459  -4.339   6.695  1.00 12.67           C  
ATOM    899  O   PRO   105      -8.493  -3.688   6.872  1.00 15.50           O  
ATOM    900  CB  PRO   105      -7.825  -5.406   8.949  1.00 14.01           C  
ATOM    901  CG  PRO   105      -7.205  -4.354   9.782  1.00 14.91           C  
ATOM    902  CD  PRO   105      -5.690  -4.524   9.549  1.00 12.35           C  
ATOM    903  N   ILE   106      -6.643  -4.177   5.668  1.00 11.77           N  
ATOM    904  CA  ILE   106      -6.881  -3.223   4.588  0.67 11.84           C  
ATOM    906  C   ILE   106      -6.548  -3.916   3.271  1.00 11.58           C  
ATOM    907  O   ILE   106      -5.611  -4.719   3.199  1.00 11.45           O  
ATOM    908  CB  ILE   106      -6.038  -1.927   4.810  0.67 11.08           C  
ATOM    910  CG1 ILE   106      -6.460  -1.241   6.115  0.67 11.15           C  
ATOM    912  CG2 ILE   106      -6.165  -0.965   3.623  0.67 13.85           C  
ATOM    914  CD1 ILE   106      -5.566  -0.069   6.504  0.67 12.34           C  
ATOM    916  N   GLU   107      -7.332  -3.611   2.246  1.00 12.90           N  
ATOM    917  CA  GLU   107      -7.126  -4.227   0.943  1.00 13.99           C  
ATOM    918  C   GLU   107      -5.833  -3.800   0.268  1.00 12.73           C  
ATOM    919  O   GLU   107      -5.212  -2.789   0.589  1.00 12.05           O  
ATOM    920  CB  GLU   107      -8.312  -3.989  -0.008  1.00 17.33           C  
ATOM    921  CG  GLU   107      -8.524  -2.583  -0.495  1.00 22.38           C  
ATOM    922  CD  GLU   107      -9.760  -2.476  -1.402  1.00 28.40           C  
ATOM    923  OE1 GLU   107     -10.717  -3.260  -1.216  1.00 33.83           O  
ATOM    924  OE2 GLU   107      -9.785  -1.617  -2.297  1.00 30.51           O  
ATOM    925  N   ASP   108      -5.464  -4.590  -0.712  1.00 12.22           N  
ATOM    926  CA  ASP   108      -4.290  -4.320  -1.513  1.00 12.45           C  
ATOM    927  C   ASP   108      -4.400  -2.958  -2.213  1.00 10.68           C  
ATOM    928  O   ASP   108      -5.476  -2.568  -2.677  1.00 12.03           O  
ATOM    929  CB  ASP   108      -4.134  -5.335  -2.645  1.00 13.84           C  
ATOM    930  CG  ASP   108      -3.947  -6.776  -2.178  1.00 16.95           C  
ATOM    931  OD1 ASP   108      -3.780  -7.071  -0.986  1.00 13.62           O  
ATOM    932  OD2 ASP   108      -3.970  -7.651  -3.071  1.00 20.93           O  
ATOM    933  N   ASN   109      -3.273  -2.250  -2.290  1.00 10.55           N  
ATOM    934  CA  ASN   109      -3.160  -1.049  -3.140  1.00 11.25           C  
ATOM    935  C   ASN   109      -4.129   0.053  -2.789  1.00 11.87           C  
ATOM    936  O   ASN   109      -4.549   0.799  -3.650  1.00 16.02           O  
ATOM    937  CB  ASN   109      -3.354  -1.459  -4.608  1.00 11.88           C  
ATOM    938  CG  ASN   109      -2.355  -2.481  -5.039  1.00 13.39           C  
ATOM    939  OD1 ASN   109      -1.186  -2.404  -4.683  1.00 15.54           O  
ATOM    940  ND2 ASN   109      -2.795  -3.450  -5.846  1.00 15.63           N  
ATOM    941  N   TYR   110      -4.427   0.176  -1.516  1.00 10.52           N  
ATOM    942  CA  TYR   110      -5.407   1.106  -1.017  1.00 10.42           C  
ATOM    943  C   TYR   110      -4.907   2.506  -0.669  1.00  8.87           C  
ATOM    944  O   TYR   110      -5.642   3.483  -0.873  1.00  9.76           O  
ATOM    945  CB  TYR   110      -6.053   0.510   0.246  1.00 12.46           C  
ATOM    946  CG  TYR   110      -7.104   1.377   0.887  1.00 14.30           C  
ATOM    947  CD1 TYR   110      -8.381   1.387   0.390  1.00 18.22           C  
ATOM    948  CD2 TYR   110      -6.805   2.179   1.988  1.00 15.21           C  
ATOM    949  CE1 TYR   110      -9.366   2.194   0.960  1.00 20.62           C  
ATOM    950  CE2 TYR   110      -7.772   2.978   2.562  1.00 17.07           C  
ATOM    951  CZ  TYR   110      -9.041   2.971   2.048  1.00 17.95           C  
ATOM    952  OH  TYR   110      -9.980   3.781   2.629  1.00 22.89           O  
ATOM    953  N   ALA   111      -3.706   2.608  -0.106  1.00  7.93           N  
ATOM    954  CA  ALA   111      -3.256   3.832   0.534  1.00  7.78           C  
ATOM    955  C   ALA   111      -2.441   4.734  -0.382  1.00  7.24           C  
ATOM    956  O   ALA   111      -1.429   4.325  -0.913  1.00  8.08           O  
ATOM    957  CB  ALA   111      -2.384   3.448   1.772  1.00  8.73           C  
ATOM    958  N   ASP   112      -2.847   5.979  -0.465  1.00  7.19           N  
ATOM    959  CA  ASP   112      -2.016   6.980  -1.132  1.00  7.38           C  
ATOM    960  C   ASP   112      -0.779   7.364  -0.324  1.00  6.64           C  
ATOM    961  O   ASP   112       0.254   7.715  -0.874  1.00  8.16           O  
ATOM    962  CB  ASP   112      -2.863   8.227  -1.419  1.00  8.05           C  
ATOM    963  CG  ASP   112      -3.992   7.941  -2.393  1.00  9.94           C  
ATOM    964  OD1 ASP   112      -3.699   7.605  -3.563  1.00 14.44           O  
ATOM    965  OD2 ASP   112      -5.149   8.049  -1.998  1.00 11.64           O  
ATOM    966  N   LEU   113      -0.933   7.323   0.986  1.00  6.67           N  
ATOM    967  CA  LEU   113       0.098   7.729   1.930  1.00  6.74           C  
ATOM    968  C   LEU   113       0.039   6.863   3.163  1.00  5.77           C  
ATOM    969  O   LEU   113      -1.041   6.579   3.653  1.00  6.67           O  
ATOM    970  CB  LEU   113      -0.100   9.189   2.342  1.00  7.25           C  
ATOM    971  CG  LEU   113       0.868   9.769   3.363  1.00  8.21           C  
ATOM    972  CD1 LEU   113       2.308   9.837   2.842  1.00  9.19           C  
ATOM    973  CD2 LEU   113       0.358  11.175   3.810  1.00 10.58           C  
ATOM    974  N   ILE   114       1.187   6.389   3.617  1.00  5.65           N  
ATOM    975  CA  ILE   114       1.290   5.643   4.870  1.00  5.52           C  
ATOM    976  C   ILE   114       2.287   6.367   5.751  1.00  6.04           C  
ATOM    977  O   ILE   114       3.442   6.581   5.348  1.00  7.49           O  
ATOM    978  CB  ILE   114       1.729   4.181   4.657  1.00  6.16           C  
ATOM    979  CG1 ILE   114       0.757   3.469   3.721  1.00  7.43           C  
ATOM    980  CG2 ILE   114       1.897   3.471   5.972  1.00  7.77           C  
ATOM    981  CD1 ILE   114       1.197   2.051   3.299  1.00  8.26           C  
ATOM    982  N   VAL   115       1.852   6.746   6.949  1.00  5.68           N  
ATOM    983  CA  VAL   115       2.699   7.415   7.911  1.00  6.11           C  
ATOM    984  C   VAL   115       2.771   6.585   9.188  1.00  5.70           C  
ATOM    985  O   VAL   115       1.896   5.796   9.471  1.00  6.47           O  
ATOM    986  CB  VAL   115       2.175   8.852   8.227  1.00  7.08           C  
ATOM    987  CG1 VAL   115       2.042   9.681   6.939  1.00  8.57           C  
ATOM    988  CG2 VAL   115       0.842   8.828   8.995  1.00  8.27           C  
ATOM    989  N   SER   116       3.828   6.784   9.961  1.00  6.22           N  
ATOM    990  CA  SER   116       3.959   6.117  11.254  1.00  6.34           C  
ATOM    991  C   SER   116       5.050   6.795  12.050  1.00  6.36           C  
ATOM    992  O   SER   116       6.172   6.958  11.554  1.00  6.83           O  
ATOM    993  CB  SER   116       4.370   4.687  11.048  1.00  7.27           C  
ATOM    994  OG  SER   116       4.530   4.002  12.275  1.00  7.35           O  
ATOM    995  N   ARG   117       4.725   7.183  13.288  1.00  5.94           N  
ATOM    996  CA  ARG   117       5.689   7.793  14.190  1.00  6.28           C  
ATOM    997  C   ARG   117       5.848   6.963  15.427  1.00  6.61           C  
ATOM    998  O   ARG   117       4.872   6.634  16.100  1.00  8.17           O  
ATOM    999  CB  ARG   117       5.271   9.209  14.597  1.00  6.35           C  
ATOM   1000  CG  ARG   117       6.278   9.874  15.491  1.00  7.49           C  
ATOM   1001  CD  ARG   117       5.787  11.216  16.100  1.00  7.54           C  
ATOM   1002  NE  ARG   117       6.813  11.705  16.992  1.00  8.26           N  
ATOM   1003  CZ  ARG   117       7.035  11.197  18.209  1.00  8.17           C  
ATOM   1004  NH1 ARG   117       6.177  10.346  18.728  1.00  9.56           N  
ATOM   1005  NH2 ARG   117       8.084  11.585  18.897  1.00  9.70           N  
ATOM   1006  N   GLY   118       7.080   6.679  15.792  0.50  6.73           N  
ATOM   1008  CA  GLY   118       7.345   6.035  17.059  0.50  7.78           C  
ATOM   1010  C   GLY   118       6.883   4.622  17.261  0.50  7.67           C  
ATOM   1012  O   GLY   118       6.770   4.211  18.414  0.50  8.95           O  
ATOM   1014  N   SER   119       6.488   3.932  16.189  1.00  9.05           N  
ATOM   1015  CA  SER   119       6.063   2.545  16.230  1.00  7.91           C  
ATOM   1016  C   SER   119       7.072   1.539  15.673  1.00  8.02           C  
ATOM   1017  O   SER   119       7.247   0.464  16.249  1.00  8.54           O  
ATOM   1018  CB  SER   119       4.719   2.482  15.496  1.00  9.18           C  
ATOM   1019  OG  SER   119       4.007   1.292  15.769  1.00  8.94           O  
ATOM   1020  N   VAL   120       7.744   1.903  14.581  1.00  7.52           N  
ATOM   1021  CA  VAL   120       8.625   0.982  13.893  1.00  7.57           C  
ATOM   1022  C   VAL   120       9.710   0.407  14.782  1.00  8.43           C  
ATOM   1023  O   VAL   120      10.150  -0.710  14.566  1.00  9.93           O  
ATOM   1024  CB  VAL   120       9.231   1.645  12.614  1.00  7.75           C  
ATOM   1025  CG1 VAL   120      10.155   2.803  12.967  1.00  8.23           C  
ATOM   1026  CG2 VAL   120       9.943   0.616  11.742  1.00  9.64           C  
ATOM   1027  N   PHE   121      10.139   1.180  15.778  1.00  7.65           N  
ATOM   1028  CA  PHE   121      11.227   0.789  16.672  1.00  8.29           C  
ATOM   1029  C   PHE   121      10.838  -0.354  17.590  1.00  9.16           C  
ATOM   1030  O   PHE   121      11.701  -0.978  18.191  1.00 11.83           O  
ATOM   1031  CB  PHE   121      11.701   2.005  17.476  1.00  9.11           C  
ATOM   1032  CG  PHE   121      12.051   3.175  16.614  1.00  8.92           C  
ATOM   1033  CD1 PHE   121      13.062   3.123  15.690  1.00 10.11           C  
ATOM   1034  CD2 PHE   121      11.303   4.311  16.678  1.00 10.96           C  
ATOM   1035  CE1 PHE   121      13.337   4.198  14.883  1.00 11.17           C  
ATOM   1036  CE2 PHE   121      11.568   5.396  15.858  1.00 12.91           C  
ATOM   1037  CZ  PHE   121      12.584   5.339  14.977  1.00 12.80           C  
ATOM   1038  N   PHE   122       9.549  -0.654  17.658  1.00  8.40           N  
ATOM   1039  CA  PHE   122       9.036  -1.735  18.507  1.00 10.10           C  
ATOM   1040  C   PHE   122       8.657  -2.996  17.732  1.00 10.76           C  
ATOM   1041  O   PHE   122       8.508  -4.058  18.336  1.00 15.74           O  
ATOM   1042  CB  PHE   122       7.786  -1.274  19.286  1.00  9.79           C  
ATOM   1043  CG  PHE   122       8.044  -0.136  20.228  1.00  8.46           C  
ATOM   1044  CD1 PHE   122       8.756  -0.318  21.398  1.00  9.80           C  
ATOM   1045  CD2 PHE   122       7.549   1.121  19.968  1.00  8.61           C  
ATOM   1046  CE1 PHE   122       8.932   0.778  22.286  1.00 10.79           C  
ATOM   1047  CE2 PHE   122       7.722   2.159  20.830  1.00 10.41           C  
ATOM   1048  CZ  PHE   122       8.448   1.998  21.964  1.00 10.35           C  
ATOM   1049  N   TRP   123       8.480  -2.918  16.427  1.00 10.63           N  
ATOM   1050  CA  TRP   123       7.933  -4.056  15.695  1.00 10.83           C  
ATOM   1051  C   TRP   123       8.798  -5.278  15.710  1.00 11.50           C  
ATOM   1052  O   TRP   123       9.982  -5.188  15.477  1.00 11.52           O  
ATOM   1053  CB  TRP   123       7.615  -3.724  14.220  1.00 10.25           C  
ATOM   1054  CG  TRP   123       6.671  -2.596  14.046  1.00  9.23           C  
ATOM   1055  CD1 TRP   123       5.778  -2.098  14.966  1.00  9.94           C  
ATOM   1056  CD2 TRP   123       6.501  -1.807  12.865  1.00  9.22           C  
ATOM   1057  NE1 TRP   123       5.085  -1.041  14.431  1.00 10.84           N  
ATOM   1058  CE2 TRP   123       5.541  -0.818  13.156  1.00  8.27           C  
ATOM   1059  CE3 TRP   123       7.075  -1.821  11.599  1.00  9.17           C  
ATOM   1060  CZ2 TRP   123       5.148   0.123  12.214  1.00  9.88           C  
ATOM   1061  CZ3 TRP   123       6.705  -0.862  10.681  1.00 10.31           C  
ATOM   1062  CH2 TRP   123       5.753   0.096  10.996  1.00  9.71           C  
ATOM   1063  N   GLU   124       8.162  -6.414  15.977  1.00 11.93           N  
ATOM   1064  CA  GLU   124       8.804  -7.719  15.871  0.50 13.50           C  
ATOM   1066  C   GLU   124       8.807  -8.022  14.343  1.00 13.77           C  
ATOM   1067  O   GLU   124       8.147  -7.340  13.608  1.00 15.88           O  
ATOM   1068  CB  GLU   124       7.964  -8.760  16.664  0.50 14.72           C  
ATOM   1070  CG  GLU   124       7.881  -8.458  18.169  0.50 19.73           C  
ATOM   1072  CD  GLU   124       6.848  -9.303  18.942  0.50 22.67           C  
ATOM   1074  OE1 GLU   124       6.138 -10.144  18.336  0.50 21.97           O  
ATOM   1076  OE2 GLU   124       6.743  -9.103  20.176  0.50 24.70           O  
ATOM   1078  N   ASP   125       9.537  -8.988  13.834  1.00 16.25           N  
ATOM   1079  CA  ASP   125       9.376  -9.299  12.398  1.00 11.58           C  
ATOM   1080  C   ASP   125       9.118  -8.159  11.382  1.00 10.07           C  
ATOM   1081  O   ASP   125       8.089  -8.079  10.691  1.00  9.50           O  
ATOM   1082  CB  ASP   125       8.298 -10.362  12.241  1.00 11.92           C  
ATOM   1083  CG  ASP   125       8.424 -11.094  10.925  1.00 10.36           C  
ATOM   1084  OD1 ASP   125       9.361 -10.777  10.144  1.00 12.78           O  
ATOM   1085  OD2 ASP   125       7.558 -11.943  10.656  1.00 12.56           O  
ATOM   1086  N   VAL   126      10.140  -7.333  11.250  1.00  9.61           N  
ATOM   1087  CA  VAL   126      10.030  -6.169  10.391  0.82  8.89           C  
ATOM   1089  C   VAL   126       9.921  -6.518   8.908  1.00  8.30           C  
ATOM   1090  O   VAL   126       9.327  -5.754   8.155  1.00  8.51           O  
ATOM   1091  CB  VAL   126      11.111  -5.126  10.654  0.82  9.68           C  
ATOM   1093  CG1 VAL   126      10.883  -4.500  12.054  0.82 11.15           C  
ATOM   1095  CG2 VAL   126      12.502  -5.701  10.517  0.82 10.67           C  
ATOM   1097  N   THR   127      10.460  -7.660   8.491  1.00  8.00           N  
ATOM   1098  CA  THR   127      10.320  -8.063   7.084  1.00  7.90           C  
ATOM   1099  C   THR   127       8.839  -8.233   6.748  1.00  8.19           C  
ATOM   1100  O   THR   127       8.355  -7.760   5.719  1.00  8.41           O  
ATOM   1101  CB  THR   127      11.069  -9.352   6.808  1.00 10.87           C  
ATOM   1102  N   THR   128       8.110  -8.942   7.601  1.00  7.52           N  
ATOM   1103  CA  THR   128       6.695  -9.148   7.386  1.00  7.95           C  
ATOM   1104  C   THR   128       5.935  -7.825   7.439  1.00  7.92           C  
ATOM   1105  O   THR   128       5.034  -7.573   6.625  1.00  8.44           O  
ATOM   1106  CB  THR   128       6.130 -10.147   8.402  1.00  9.79           C  
ATOM   1107  OG1 THR   128       6.767 -11.405   8.181  1.00 10.06           O  
ATOM   1108  CG2 THR   128       4.608 -10.286   8.313  1.00 11.49           C  
ATOM   1109  N   ALA   129       6.289  -6.980   8.393  1.00  7.72           N  
ATOM   1110  CA  ALA   129       5.626  -5.676   8.532  1.00  7.74           C  
ATOM   1111  C   ALA   129       5.776  -4.862   7.243  1.00  7.05           C  
ATOM   1112  O   ALA   129       4.816  -4.300   6.751  1.00  7.71           O  
ATOM   1113  CB  ALA   129       6.207  -4.909   9.705  1.00  8.15           C  
ATOM   1114  N   PHE   130       6.995  -4.789   6.706  1.00  7.37           N  
ATOM   1115  CA  PHE   130       7.212  -4.018   5.487  1.00  7.45           C  
ATOM   1116  C   PHE   130       6.612  -4.628   4.238  1.00  7.36           C  
ATOM   1117  O   PHE   130       6.203  -3.912   3.349  1.00  7.74           O  
ATOM   1118  CB  PHE   130       8.674  -3.598   5.341  1.00  7.32           C  
ATOM   1119  CG  PHE   130       8.978  -2.364   6.166  1.00  7.34           C  
ATOM   1120  CD1 PHE   130       8.687  -1.097   5.678  1.00  8.48           C  
ATOM   1121  CD2 PHE   130       9.426  -2.475   7.473  1.00  8.55           C  
ATOM   1122  CE1 PHE   130       8.887   0.015   6.465  1.00  9.14           C  
ATOM   1123  CE2 PHE   130       9.623  -1.357   8.257  1.00  9.73           C  
ATOM   1124  CZ  PHE   130       9.347  -0.118   7.751  1.00  9.56           C  
ATOM   1125  N   ARG   131       6.492  -5.946   4.179  1.00  7.37           N  
ATOM   1126  CA  ARG   131       5.727  -6.571   3.093  1.00  7.62           C  
ATOM   1127  C   ARG   131       4.263  -6.164   3.158  1.00  7.56           C  
ATOM   1128  O   ARG   131       3.634  -5.914   2.126  1.00  8.19           O  
ATOM   1129  CB  ARG   131       5.892  -8.091   3.103  1.00  7.21           C  
ATOM   1130  CG  ARG   131       7.254  -8.524   2.540  1.00  8.66           C  
ATOM   1131  CD  ARG   131       7.352 -10.056   2.457  1.00  8.42           C  
ATOM   1132  NE  ARG   131       8.440 -10.466   1.588  1.00  9.16           N  
ATOM   1133  CZ  ARG   131       9.687 -10.589   1.960  1.00  9.13           C  
ATOM   1134  NH1 ARG   131      10.036 -10.523   3.221  1.00 11.02           N  
ATOM   1135  NH2 ARG   131      10.621 -10.811   1.041  1.00  9.82           N  
ATOM   1136  N   GLU   132       3.713  -6.106   4.372  1.00  7.44           N  
ATOM   1137  CA  GLU   132       2.309  -5.665   4.518  1.00  7.89           C  
ATOM   1138  C   GLU   132       2.126  -4.197   4.125  1.00  7.73           C  
ATOM   1139  O   GLU   132       1.162  -3.815   3.468  1.00  8.05           O  
ATOM   1140  CB  GLU   132       1.816  -5.911   5.957  1.00  8.39           C  
ATOM   1141  CG  GLU   132       1.390  -7.325   6.199  1.00  9.26           C  
ATOM   1142  CD  GLU   132       0.113  -7.614   5.431  1.00  9.17           C  
ATOM   1143  OE1 GLU   132      -0.984  -7.205   5.892  1.00 10.47           O  
ATOM   1144  OE2 GLU   132       0.199  -8.204   4.337  1.00  9.94           O  
ATOM   1145  N   ILE   133       3.051  -3.352   4.574  1.00  7.41           N  
ATOM   1146  CA  ILE   133       3.039  -1.941   4.222  1.00  7.93           C  
ATOM   1147  C   ILE   133       3.071  -1.791   2.710  1.00  7.75           C  
ATOM   1148  O   ILE   133       2.316  -1.018   2.119  1.00  8.20           O  
ATOM   1149  CB  ILE   133       4.202  -1.217   4.909  1.00  7.60           C  
ATOM   1150  CG1 ILE   133       3.890  -1.130   6.410  1.00  7.93           C  
ATOM   1151  CG2 ILE   133       4.464   0.166   4.313  1.00  8.43           C  
ATOM   1152  CD1 ILE   133       5.100  -0.804   7.300  1.00  9.23           C  
ATOM   1153  N   TYR   134       3.951  -2.537   2.057  1.00  7.52           N  
ATOM   1154  CA  TYR   134       4.042  -2.425   0.607  1.00  7.77           C  
ATOM   1155  C   TYR   134       2.772  -2.933  -0.056  1.00  8.48           C  
ATOM   1156  O   TYR   134       2.344  -2.357  -1.071  1.00  8.98           O  
ATOM   1157  CB  TYR   134       5.282  -3.144   0.070  1.00  8.17           C  
ATOM   1158  CG  TYR   134       5.763  -2.642  -1.268  1.00  8.07           C  
ATOM   1159  CD1 TYR   134       6.219  -1.348  -1.396  1.00  9.13           C  
ATOM   1160  CD2 TYR   134       5.800  -3.438  -2.384  1.00 10.07           C  
ATOM   1161  CE1 TYR   134       6.716  -0.861  -2.558  1.00 10.00           C  
ATOM   1162  CE2 TYR   134       6.331  -2.955  -3.606  1.00 10.31           C  
ATOM   1163  CZ  TYR   134       6.784  -1.660  -3.665  1.00  9.15           C  
ATOM   1164  OH  TYR   134       7.277  -1.111  -4.831  1.00 10.03           O  
ATOM   1165  N   ARG   135       2.174  -3.994   0.507  1.00  8.18           N  
ATOM   1166  CA  ARG   135       0.976  -4.538  -0.063  1.00  9.41           C  
ATOM   1167  C   ARG   135      -0.168  -3.521  -0.105  1.00  8.81           C  
ATOM   1168  O   ARG   135      -0.911  -3.436  -1.102  1.00  9.48           O  
ATOM   1169  CB  ARG   135       0.537  -5.789   0.708  1.00  9.49           C  
ATOM   1170  CG  ARG   135      -0.741  -6.408   0.167  1.00  9.61           C  
ATOM   1171  CD  ARG   135      -1.222  -7.593   1.016  1.00 10.56           C  
ATOM   1172  NE  ARG   135      -1.602  -7.228   2.373  1.00 10.04           N  
ATOM   1173  CZ  ARG   135      -2.723  -6.591   2.702  1.00 11.05           C  
ATOM   1174  NH1 ARG   135      -3.607  -6.225   1.787  1.00 10.99           N  
ATOM   1175  NH2 ARG   135      -2.950  -6.308   3.985  1.00 11.47           N  
ATOM   1176  N   ILE   136      -0.348  -2.788   0.993  1.00  8.02           N  
ATOM   1177  CA  ILE   136      -1.481  -1.869   1.094  1.00  8.77           C  
ATOM   1178  C   ILE   136      -1.229  -0.509   0.424  1.00  8.64           C  
ATOM   1179  O   ILE   136      -2.140   0.279   0.270  1.00 10.16           O  
ATOM   1180  CB  ILE   136      -1.964  -1.672   2.562  1.00  8.62           C  
ATOM   1181  CG1 ILE   136      -0.901  -0.989   3.433  1.00  9.51           C  
ATOM   1182  CG2 ILE   136      -2.444  -3.012   3.170  1.00 10.74           C  
ATOM   1183  CD1 ILE   136      -1.474  -0.170   4.556  1.00 10.37           C  
ATOM   1184  N   LEU   137       0.004  -0.220   0.057  1.00  8.25           N  
ATOM   1185  CA  LEU   137       0.379   1.019  -0.607  1.00  8.41           C  
ATOM   1186  C   LEU   137      -0.077   0.986  -2.072  1.00  8.83           C  
ATOM   1187  O   LEU   137       0.149   0.008  -2.782  1.00 10.37           O  
ATOM   1188  CB  LEU   137       1.916   1.175  -0.521  1.00  8.67           C  
ATOM   1189  CG  LEU   137       2.524   2.497  -0.967  1.00  9.05           C  
ATOM   1190  CD1 LEU   137       1.952   3.672  -0.154  1.00  9.55           C  
ATOM   1191  CD2 LEU   137       4.052   2.432  -0.820  1.00  9.56           C  
ATOM   1192  N   LYS   138      -0.700   2.077  -2.498  0.57  8.62           N  
ATOM   1194  CA  LYS   138      -1.125   2.244  -3.871  0.57  9.34           C  
ATOM   1196  C   LYS   138       0.093   2.534  -4.750  0.57 10.25           C  
ATOM   1198  O   LYS   138       1.030   3.220  -4.345  0.57  9.47           O  
ATOM   1200  CB  LYS   138      -2.136   3.405  -3.979  0.57  9.61           C  
ATOM   1202  CG  LYS   138      -2.873   3.440  -5.298  0.57 10.76           C  
ATOM   1204  CD  LYS   138      -3.817   4.658  -5.366  0.57 12.36           C  
ATOM   1206  CE  LYS   138      -4.828   4.646  -4.271  0.57 14.49           C  
ATOM   1208  NZ  LYS   138      -5.760   5.780  -4.509  0.57 18.01           N  
ATOM   1210  N   SER   139       0.064   2.008  -5.966  0.57 10.87           N  
ATOM   1212  CA  SER   139       1.083   2.343  -6.950  0.57 12.67           C  
ATOM   1214  C   SER   139       1.123   3.868  -7.065  0.57 11.08           C  
ATOM   1216  O   SER   139       0.103   4.527  -7.272  0.57 12.04           O  
ATOM   1218  CB  SER   139       0.766   1.684  -8.296  0.57 14.08           C  
ATOM   1220  OG  SER   139       1.772   1.944  -9.248  0.57 19.45           O  
ATOM   1222  N   GLY   140       2.320   4.420  -6.967  1.00 11.25           N  
ATOM   1223  CA  GLY   140       2.540   5.857  -6.908  1.00 11.39           C  
ATOM   1224  C   GLY   140       2.460   6.449  -5.516  1.00 12.04           C  
ATOM   1225  O   GLY   140       2.731   7.613  -5.331  1.00 14.89           O  
ATOM   1226  N   GLY   141       2.097   5.630  -4.543  1.00 10.70           N  
ATOM   1227  CA  GLY   141       1.996   6.029  -3.148  1.00  9.69           C  
ATOM   1228  C   GLY   141       3.340   6.229  -2.482  1.00 10.19           C  
ATOM   1229  O   GLY   141       4.361   5.740  -2.961  1.00 11.81           O  
ATOM   1230  N   LYS   142       3.300   6.878  -1.314  1.00  7.88           N  
ATOM   1231  CA  LYS   142       4.488   7.211  -0.523  1.00  7.53           C  
ATOM   1232  C   LYS   142       4.319   6.792   0.930  1.00  7.09           C  
ATOM   1233  O   LYS   142       3.193   6.747   1.437  1.00  7.75           O  
ATOM   1234  CB  LYS   142       4.753   8.735  -0.530  1.00  8.17           C  
ATOM   1235  CG  LYS   142       4.943   9.374  -1.903  1.00 10.76           C  
ATOM   1236  CD  LYS   142       6.261   9.017  -2.514  1.00 11.66           C  
ATOM   1237  CE  LYS   142       6.456   9.706  -3.853  1.00 13.32           C  
ATOM   1238  NZ  LYS   142       7.759   9.410  -4.431  1.00 13.44           N  
ATOM   1239  N   THR   143       5.442   6.528   1.594  1.00  6.74           N  
ATOM   1240  CA  THR   143       5.447   6.303   3.036  1.00  6.51           C  
ATOM   1241  C   THR   143       6.321   7.336   3.745  1.00  6.36           C  
ATOM   1242  O   THR   143       7.189   7.964   3.156  1.00  6.85           O  
ATOM   1243  CB  THR   143       5.923   4.885   3.452  1.00  6.63           C  
ATOM   1244  OG1 THR   143       7.351   4.758   3.358  1.00  6.25           O  
ATOM   1245  CG2 THR   143       5.300   3.805   2.613  1.00  8.11           C  
ATOM   1246  N   TYR   144       6.095   7.457   5.054  1.00  6.31           N  
ATOM   1247  CA  TYR   144       6.905   8.318   5.931  1.00  5.84           C  
ATOM   1248  C   TYR   144       6.808   7.655   7.301  1.00  5.77           C  
ATOM   1249  O   TYR   144       5.934   7.952   8.106  1.00  6.22           O  
ATOM   1250  CB  TYR   144       6.354   9.727   5.910  1.00  6.64           C  
ATOM   1251  CG  TYR   144       7.273  10.798   6.464  1.00  6.36           C  
ATOM   1252  CD1 TYR   144       8.263  11.377   5.686  1.00  7.88           C  
ATOM   1253  CD2 TYR   144       7.099  11.301   7.741  1.00  7.13           C  
ATOM   1254  CE1 TYR   144       9.037  12.401   6.151  1.00  8.39           C  
ATOM   1255  CE2 TYR   144       7.875  12.335   8.208  1.00  7.78           C  
ATOM   1256  CZ  TYR   144       8.846  12.885   7.413  1.00  7.67           C  
ATOM   1257  OH  TYR   144       9.585  13.925   7.919  1.00 10.26           O  
ATOM   1258  N   ILE   145       7.723   6.706   7.515  1.00  5.59           N  
ATOM   1259  CA  ILE   145       7.663   5.766   8.662  1.00  5.49           C  
ATOM   1260  C   ILE   145       8.935   5.867   9.464  1.00  5.52           C  
ATOM   1261  O   ILE   145      10.037   5.618   8.960  1.00  6.01           O  
ATOM   1262  CB  ILE   145       7.469   4.320   8.138  1.00  6.70           C  
ATOM   1263  CG1 ILE   145       6.103   4.200   7.445  1.00  6.92           C  
ATOM   1264  CG2 ILE   145       7.672   3.304   9.251  1.00  6.86           C  
ATOM   1265  CD1 ILE   145       5.958   2.972   6.594  1.00  8.71           C  
ATOM   1266  N   GLY   146       8.815   6.253  10.731  1.00  5.56           N  
ATOM   1267  CA  GLY   146      10.031   6.466  11.509  1.00  5.84           C  
ATOM   1268  C   GLY   146       9.725   7.121  12.819  1.00  5.82           C  
ATOM   1269  O   GLY   146       8.775   6.723  13.506  1.00  6.49           O  
ATOM   1270  N   GLY   147      10.505   8.124  13.158  1.00  6.23           N  
ATOM   1271  CA  GLY   147      10.296   8.863  14.402  1.00  6.62           C  
ATOM   1272  C   GLY   147      11.058  10.149  14.432  1.00  6.55           C  
ATOM   1273  O   GLY   147      11.913  10.375  13.610  1.00  7.94           O  
ATOM   1274  N   GLY   148      10.727  11.001  15.383  1.00  8.32           N  
ATOM   1275  CA  GLY   148      11.368  12.281  15.490  1.00  8.78           C  
ATOM   1276  C   GLY   148      10.430  13.334  16.028  1.00  7.34           C  
ATOM   1277  O   GLY   148       9.316  13.061  16.480  1.00  7.05           O  
ATOM   1278  N   PHE   149      10.921  14.563  15.920  1.00  7.26           N  
ATOM   1279  CA  PHE   149      10.301  15.728  16.544  0.83  7.47           C  
ATOM   1281  C   PHE   149       9.975  16.866  15.602  1.00  8.23           C  
ATOM   1282  O   PHE   149       9.602  17.919  16.041  1.00 10.56           O  
ATOM   1283  CB  PHE   149      11.128  16.161  17.767  0.83  8.05           C  
ATOM   1285  CG  PHE   149      11.263  15.051  18.742  0.83  8.81           C  
ATOM   1287  CD1 PHE   149      10.250  14.783  19.652  0.83  9.60           C  
ATOM   1289  CD2 PHE   149      12.306  14.126  18.623  0.83 12.55           C  
ATOM   1291  CE1 PHE   149      10.307  13.703  20.507  0.83 10.47           C  
ATOM   1293  CE2 PHE   149      12.352  13.008  19.456  0.83 13.97           C  
ATOM   1295  CZ  PHE   149      11.356  12.809  20.413  0.83 14.66           C  
ATOM   1297  N   GLY   150      10.130  16.622  14.310  1.00  9.02           N  
ATOM   1298  CA  GLY   150       9.732  17.586  13.297  1.00  9.85           C  
ATOM   1299  C   GLY   150      10.760  18.630  12.908  1.00  8.62           C  
ATOM   1300  O   GLY   150      10.877  18.942  11.727  1.00  9.04           O  
ATOM   1301  N   ASN   151      11.444  19.220  13.889  1.00  8.76           N  
ATOM   1302  CA  ASN   151      12.527  20.139  13.570  1.00  9.02           C  
ATOM   1303  C   ASN   151      13.524  20.165  14.724  1.00  8.46           C  
ATOM   1304  O   ASN   151      13.291  19.593  15.794  1.00  8.74           O  
ATOM   1305  CB  ASN   151      11.979  21.509  13.184  1.00  9.98           C  
ATOM   1306  CG  ASN   151      11.258  22.214  14.317  1.00 10.21           C  
ATOM   1307  OD1 ASN   151      11.717  22.197  15.450  1.00 11.18           O  
ATOM   1308  ND2 ASN   151      10.143  22.882  14.001  1.00 11.44           N  
ATOM   1309  N   LYS   152      14.653  20.826  14.496  1.00  8.67           N  
ATOM   1310  CA  LYS   152      15.721  20.826  15.479  1.00  9.44           C  
ATOM   1311  C   LYS   152      15.338  21.524  16.770  1.00  9.39           C  
ATOM   1312  O   LYS   152      15.720  21.082  17.853  1.00  9.72           O  
ATOM   1313  CB  LYS   152      16.957  21.503  14.892  1.00 10.99           C  
ATOM   1314  CG  LYS   152      18.158  21.503  15.799  1.00 13.50           C  
ATOM   1315  CD  LYS   152      19.343  22.199  15.162  1.00 15.84           C  
ATOM   1316  CE  LYS   152      20.586  22.091  15.987  1.00 21.48           C  
ATOM   1317  NZ  LYS   152      21.726  22.714  15.268  1.00 26.36           N  
ATOM   1318  N   GLU   153      14.614  22.628  16.669  1.00  9.85           N  
ATOM   1319  CA  GLU   153      14.264  23.428  17.852  0.51 10.41           C  
ATOM   1321  C   GLU   153      13.413  22.595  18.813  1.00  9.57           C  
ATOM   1322  O   GLU   153      13.663  22.553  20.017  1.00 10.01           O  
ATOM   1323  CB  GLU   153      13.537  24.752  17.484  0.51 11.47           C  
ATOM   1325  CG  GLU   153      13.073  25.576  18.734  0.51 17.67           C  
ATOM   1327  CD  GLU   153      12.583  27.014  18.444  0.51 21.20           C  
ATOM   1329  OE1 GLU   153      12.468  27.407  17.265  0.51 25.98           O  
ATOM   1331  OE2 GLU   153      12.266  27.747  19.414  0.51 23.32           O  
ATOM   1333  N   LEU   154      12.401  21.940  18.268  1.00  8.79           N  
ATOM   1334  CA  LEU   154      11.535  21.090  19.079  1.00  8.92           C  
ATOM   1335  C   LEU   154      12.280  19.876  19.570  1.00  7.91           C  
ATOM   1336  O   LEU   154      12.140  19.469  20.720  1.00  8.79           O  
ATOM   1337  CB  LEU   154      10.276  20.699  18.315  1.00  9.43           C  
ATOM   1338  CG  LEU   154       9.331  21.841  17.953  1.00  9.85           C  
ATOM   1339  CD1 LEU   154       8.190  21.292  17.134  1.00 10.67           C  
ATOM   1340  CD2 LEU   154       8.822  22.565  19.214  1.00 13.40           C  
ATOM   1341  N   ARG   155      13.090  19.277  18.711  1.00  7.63           N  
ATOM   1342  CA  ARG   155      13.862  18.133  19.131  1.00  8.32           C  
ATOM   1343  C   ARG   155      14.668  18.467  20.394  1.00  9.00           C  
ATOM   1344  O   ARG   155      14.694  17.731  21.391  1.00  9.61           O  
ATOM   1345  CB  ARG   155      14.808  17.663  18.024  1.00  8.41           C  
ATOM   1346  CG  ARG   155      15.656  16.493  18.400  1.00  9.22           C  
ATOM   1347  CD  ARG   155      16.797  16.292  17.398  1.00 10.33           C  
ATOM   1348  NE  ARG   155      17.769  17.358  17.568  1.00 11.99           N  
ATOM   1349  CZ  ARG   155      18.828  17.530  16.808  1.00 14.45           C  
ATOM   1350  NH1 ARG   155      19.024  16.722  15.791  1.00 15.52           N  
ATOM   1351  NH2 ARG   155      19.670  18.528  17.054  1.00 16.84           N  
ATOM   1352  N   ASP   156      15.362  19.584  20.332  1.00  9.30           N  
ATOM   1353  CA  ASP   156      16.298  19.952  21.405  1.00  9.93           C  
ATOM   1354  C   ASP   156      15.545  20.301  22.697  1.00  9.88           C  
ATOM   1355  O   ASP   156      15.968  19.913  23.810  1.00 11.08           O  
ATOM   1356  CB  ASP   156      17.200  21.090  20.947  1.00 12.09           C  
ATOM   1357  CG  ASP   156      18.225  20.653  19.904  1.00 13.32           C  
ATOM   1358  OD1 ASP   156      18.384  19.421  19.664  1.00 14.73           O  
ATOM   1359  OD2 ASP   156      18.899  21.574  19.376  1.00 17.02           O  
ATOM   1360  N   SER   157      14.455  21.054  22.589  1.00 10.33           N  
ATOM   1361  CA  SER   157      13.734  21.453  23.796  1.00 10.24           C  
ATOM   1362  C   SER   157      13.044  20.269  24.425  1.00 10.07           C  
ATOM   1363  O   SER   157      13.045  20.094  25.659  1.00 10.76           O  
ATOM   1364  CB  SER   157      12.756  22.581  23.556  1.00 12.70           C  
ATOM   1365  OG  SER   157      11.741  22.238  22.668  1.00 13.44           O  
ATOM   1366  N   ILE   158      12.435  19.435  23.599  1.00  8.70           N  
ATOM   1367  CA  ILE   158      11.747  18.261  24.120  1.00  8.89           C  
ATOM   1368  C   ILE   158      12.722  17.276  24.713  1.00  9.69           C  
ATOM   1369  O   ILE   158      12.473  16.699  25.778  1.00 10.84           O  
ATOM   1370  CB  ILE   158      10.876  17.594  23.019  1.00  8.88           C  
ATOM   1371  CG1 ILE   158       9.724  18.515  22.676  1.00 10.25           C  
ATOM   1372  CG2 ILE   158      10.386  16.204  23.471  1.00 11.17           C  
ATOM   1373  CD1 ILE   158       8.942  18.115  21.441  1.00 11.33           C  
ATOM   1374  N   SER   159      13.871  17.108  24.068  1.00 10.59           N  
ATOM   1375  CA  SER   159      14.876  16.162  24.577  0.49 11.67           C  
ATOM   1377  C   SER   159      15.283  16.503  25.973  1.00 10.55           C  
ATOM   1378  O   SER   159      15.410  15.630  26.837  1.00 12.90           O  
ATOM   1379  CB  SER   159      16.165  16.114  23.731  0.49 12.50           C  
ATOM   1381  OG  SER   159      17.221  15.442  24.443  0.49 14.69           O  
ATOM   1383  N   ALA   160      15.535  17.779  26.218  1.00 11.61           N  
ATOM   1384  CA  ALA   160      15.970  18.189  27.524  1.00 11.74           C  
ATOM   1385  C   ALA   160      14.956  17.798  28.587  1.00 12.77           C  
ATOM   1386  O   ALA   160      15.308  17.287  29.665  1.00 13.22           O  
ATOM   1387  CB  ALA   160      16.236  19.673  27.560  1.00 13.46           C  
ATOM   1388  N   GLU   161      13.680  18.009  28.292  1.00 12.13           N  
ATOM   1389  CA  GLU   161      12.634  17.667  29.251  0.55 12.38           C  
ATOM   1391  C   GLU   161      12.479  16.147  29.390  1.00 11.75           C  
ATOM   1392  O   GLU   161      12.273  15.633  30.509  1.00 13.35           O  
ATOM   1393  CB  GLU   161      11.303  18.312  28.880  0.55 13.15           C  
ATOM   1395  CG  GLU   161      10.244  18.097  29.926  0.55 16.08           C  
ATOM   1397  CD  GLU   161      10.558  18.730  31.262  0.55 21.94           C  
ATOM   1399  OE1 GLU   161      11.519  19.524  31.366  0.55 22.75           O  
ATOM   1401  OE2 GLU   161       9.803  18.436  32.217  0.55 26.74           O  
ATOM   1403  N   MET   162      12.535  15.402  28.295  1.00 11.57           N  
ATOM   1404  CA  MET   162      12.399  13.929  28.363  0.50 11.42           C  
ATOM   1406  C   MET   162      13.510  13.312  29.181  1.00 11.89           C  
ATOM   1407  O   MET   162      13.281  12.381  29.952  1.00 13.08           O  
ATOM   1408  CB  MET   162      12.330  13.252  26.986  0.50 10.93           C  
ATOM   1410  CG  MET   162      11.018  13.450  26.238  0.50  8.70           C  
ATOM   1412  SD  MET   162       9.464  12.746  27.149  0.38  6.08          SE  
ATOM   1414  CE  MET   162       9.887  10.868  26.999  0.50  7.35           C  
ATOM   1416  N   ILE   163      14.704  13.857  29.032  1.00 11.81           N  
ATOM   1417  CA  ILE   163      15.870  13.343  29.768  1.00 12.25           C  
ATOM   1418  C   ILE   163      15.686  13.582  31.270  1.00 12.44           C  
ATOM   1419  O   ILE   163      16.041  12.741  32.087  1.00 14.51           O  
ATOM   1420  CB  ILE   163      17.184  13.964  29.232  1.00 14.26           C  
ATOM   1421  CG1 ILE   163      17.425  13.418  27.830  1.00 14.80           C  
ATOM   1422  CG2 ILE   163      18.326  13.625  30.164  1.00 17.53           C  
ATOM   1423  CD1 ILE   163      18.497  14.126  27.067  1.00 18.03           C  
ATOM   1424  N   ARG   164      15.092  14.718  31.626  1.00 12.19           N  
ATOM   1425  CA  ARG   164      14.834  15.022  33.023  0.48 12.98           C  
ATOM   1427  C   ARG   164      13.788  14.056  33.608  1.00 12.06           C  
ATOM   1428  O   ARG   164      13.915  13.561  34.729  1.00 13.99           O  
ATOM   1429  CB  ARG   164      14.347  16.464  33.145  0.48 14.17           C  
ATOM   1431  CG  ARG   164      14.229  16.975  34.550  0.48 15.40           C  
ATOM   1433  CD  ARG   164      13.494  18.309  34.559  0.48 19.98           C  
ATOM   1435  NE  ARG   164      12.106  18.124  34.158  0.48 22.85           N  
ATOM   1437  CZ  ARG   164      11.158  17.694  34.981  0.48 20.45           C  
ATOM   1439  NH1 ARG   164      11.457  17.429  36.253  0.48 31.20           N  
ATOM   1441  NH2 ARG   164       9.922  17.531  34.543  0.48 27.60           N  
ATOM   1443  N   LYS   165      12.741  13.799  32.844  1.00 11.55           N  
ATOM   1444  CA  LYS   165      11.677  12.906  33.329  0.48 11.53           C  
ATOM   1446  C   LYS   165      12.099  11.445  33.360  1.00 10.63           C  
ATOM   1447  O   LYS   165      11.835  10.745  34.325  1.00 11.54           O  
ATOM   1448  CB  LYS   165      10.411  13.043  32.468  0.48 13.02           C  
ATOM   1450  CG  LYS   165       9.806  14.437  32.478  0.48 16.74           C  
ATOM   1452  CD  LYS   165       8.644  14.537  31.511  0.48 20.80           C  
ATOM   1454  CE  LYS   165       7.442  13.749  31.989  0.48 23.80           C  
ATOM   1456  NZ  LYS   165       6.840  14.325  33.224  0.48 26.95           N  
ATOM   1458  N   ASN   166      12.724  11.014  32.281  1.00 10.82           N  
ATOM   1459  CA  ASN   166      13.063   9.611  32.048  1.00 10.88           C  
ATOM   1460  C   ASN   166      14.519   9.498  31.579  1.00 11.38           C  
ATOM   1461  O   ASN   166      14.790   9.500  30.365  1.00 11.73           O  
ATOM   1462  CB  ASN   166      12.188   9.035  30.918  1.00 11.30           C  
ATOM   1463  CG  ASN   166      10.682   9.108  31.149  1.00 11.26           C  
ATOM   1464  OD1 ASN   166       9.917   9.301  30.187  1.00 11.85           O  
ATOM   1465  ND2 ASN   166      10.236   8.879  32.391  1.00 13.52           N  
ATOM   1466  N   PRO   167      15.457   9.423  32.517  1.00 10.53           N  
ATOM   1467  CA  PRO   167      16.849   9.532  32.099  1.00 11.73           C  
ATOM   1468  C   PRO   167      17.292   8.496  31.045  1.00 11.00           C  
ATOM   1469  O   PRO   167      18.087   8.832  30.160  1.00 13.71           O  
ATOM   1470  CB  PRO   167      17.612   9.368  33.404  1.00 13.75           C  
ATOM   1471  CG  PRO   167      16.643   9.861  34.436  1.00 13.20           C  
ATOM   1472  CD  PRO   167      15.288   9.488  33.977  1.00 11.16           C  
ATOM   1473  N   ASP   168      16.740   7.289  31.089  1.00 10.51           N  
ATOM   1474  CA  ASP   168      17.151   6.227  30.136  1.00 10.92           C  
ATOM   1475  C   ASP   168      16.623   6.452  28.726  1.00 10.34           C  
ATOM   1476  O   ASP   168      17.076   5.820  27.778  1.00 11.40           O  
ATOM   1477  CB  ASP   168      16.721   4.848  30.635  1.00 11.57           C  
ATOM   1478  CG  ASP   168      17.242   4.556  32.003  1.00 12.24           C  
ATOM   1479  OD1 ASP   168      18.445   4.301  32.146  1.00 15.10           O  
ATOM   1480  OD2 ASP   168      16.460   4.670  32.983  1.00 13.85           O  
ATOM   1481  N   TRP   169      15.652   7.357  28.572  1.00  9.95           N  
ATOM   1482  CA  TRP   169      15.118   7.675  27.240  1.00 10.25           C  
ATOM   1483  C   TRP   169      16.244   8.220  26.370  1.00 10.22           C  
ATOM   1484  O   TRP   169      16.245   8.017  25.159  1.00 11.17           O  
ATOM   1485  CB  TRP   169      13.975   8.700  27.355  1.00  9.83           C  
ATOM   1486  CG  TRP   169      13.529   9.285  26.049  1.00  9.55           C  
ATOM   1487  CD1 TRP   169      12.517   8.847  25.253  1.00 11.31           C  
ATOM   1488  CD2 TRP   169      14.071  10.429  25.412  1.00  9.57           C  
ATOM   1489  NE1 TRP   169      12.414   9.630  24.143  1.00 11.66           N  
ATOM   1490  CE2 TRP   169      13.379  10.600  24.204  1.00 10.57           C  
ATOM   1491  CE3 TRP   169      15.128  11.290  25.714  1.00 10.85           C  
ATOM   1492  CZ2 TRP   169      13.663  11.638  23.329  1.00 13.28           C  
ATOM   1493  CZ3 TRP   169      15.410  12.309  24.846  1.00 14.36           C  
ATOM   1494  CH2 TRP   169      14.704  12.468  23.666  1.00 14.08           C  
ATOM   1495  N   LYS   170      17.231   8.889  26.968  1.00 10.69           N  
ATOM   1496  CA  LYS   170      18.315   9.501  26.190  1.00 11.77           C  
ATOM   1497  C   LYS   170      18.976   8.440  25.285  1.00 11.41           C  
ATOM   1498  O   LYS   170      19.142   8.615  24.069  1.00 13.09           O  
ATOM   1499  CB  LYS   170      19.370  10.100  27.125  1.00 13.56           C  
ATOM   1500  CG  LYS   170      20.482  10.898  26.427  1.00 15.07           C  
ATOM   1501  CD  LYS   170      21.455  11.468  27.480  1.00 20.05           C  
ATOM   1502  CE  LYS   170      22.623  12.226  26.872  1.00 22.38           C  
ATOM   1503  NZ  LYS   170      23.477  12.888  27.928  1.00 26.03           N  
ATOM   1504  N   GLU   171      19.317   7.299  25.884  1.00 12.60           N  
ATOM   1505  CA  GLU   171      19.985   6.258  25.107  1.00 14.39           C  
ATOM   1506  C   GLU   171      19.083   5.553  24.118  1.00 13.40           C  
ATOM   1507  O   GLU   171      19.553   5.179  23.038  1.00 15.61           O  
ATOM   1508  CB  GLU   171      20.696   5.269  26.029  1.00 17.57           C  
ATOM   1509  CG  GLU   171      21.903   5.891  26.707  1.00 20.31           C  
ATOM   1510  CD  GLU   171      21.571   6.779  27.905  1.00 23.03           C  
ATOM   1511  OE1 GLU   171      20.478   6.635  28.536  1.00 21.01           O  
ATOM   1512  OE2 GLU   171      22.421   7.644  28.227  1.00 25.17           O  
ATOM   1513  N   PHE   172      17.814   5.350  24.454  1.00 12.47           N  
ATOM   1514  CA  PHE   172      16.885   4.673  23.532  1.00 12.40           C  
ATOM   1515  C   PHE   172      16.661   5.563  22.323  1.00 10.95           C  
ATOM   1516  O   PHE   172      16.792   5.140  21.194  1.00 12.60           O  
ATOM   1517  CB  PHE   172      15.588   4.311  24.259  1.00 12.73           C  
ATOM   1518  CG  PHE   172      14.576   3.593  23.425  1.00 11.50           C  
ATOM   1519  CD1 PHE   172      14.937   2.661  22.466  1.00 12.62           C  
ATOM   1520  CD2 PHE   172      13.219   3.757  23.674  1.00 11.41           C  
ATOM   1521  CE1 PHE   172      13.977   1.982  21.757  1.00 14.13           C  
ATOM   1522  CE2 PHE   172      12.275   3.071  22.952  1.00 12.14           C  
ATOM   1523  CZ  PHE   172      12.655   2.198  21.989  1.00 12.34           C  
ATOM   1524  N   ASN   173      16.402   6.833  22.570  1.00 10.78           N  
ATOM   1525  CA  ASN   173      16.220   7.780  21.470  1.00 11.90           C  
ATOM   1526  C   ASN   173      17.456   7.850  20.578  1.00 13.16           C  
ATOM   1527  O   ASN   173      17.347   7.880  19.350  1.00 13.46           O  
ATOM   1528  CB  ASN   173      15.864   9.156  22.037  1.00 12.64           C  
ATOM   1529  CG  ASN   173      15.897  10.241  20.994  1.00 13.41           C  
ATOM   1530  OD1 ASN   173      16.769  11.119  21.034  1.00 16.00           O  
ATOM   1531  ND2 ASN   173      14.958  10.210  20.068  1.00 14.40           N  
ATOM   1532  N   ARG   174      18.649   7.858  21.186  1.00 13.04           N  
ATOM   1533  CA  ARG   174      19.901   7.930  20.425  0.48 14.77           C  
ATOM   1535  C   ARG   174      20.096   6.693  19.544  1.00 16.70           C  
ATOM   1536  O   ARG   174      20.609   6.780  18.432  1.00 20.85           O  
ATOM   1537  CB  ARG   174      21.099   8.222  21.333  0.48 16.10           C  
ATOM   1539  CG  ARG   174      21.052   9.689  21.766  0.48 17.56           C  
ATOM   1541  CD  ARG   174      22.141  10.214  22.690  0.48 15.61           C  
ATOM   1543  NE  ARG   174      22.118  11.677  22.677  0.48 15.38           N  
ATOM   1545  CZ  ARG   174      23.148  12.434  23.062  0.48 13.73           C  
ATOM   1547  NH1 ARG   174      24.245  11.846  23.518  0.48 12.38           N  
ATOM   1549  NH2 ARG   174      23.073  13.755  22.962  0.48 16.09           N  
ATOM   1551  N   LYS   175      19.647   5.550  20.010  1.00 16.04           N  
ATOM   1552  CA  LYS   175      19.687   4.319  19.196  1.00 15.62           C  
ATOM   1553  C   LYS   175      18.639   4.400  18.071  1.00 15.85           C  
ATOM   1554  O   LYS   175      18.934   4.046  16.920  1.00 18.40           O  
ATOM   1555  CB  LYS   175      19.432   3.092  20.053  1.00 19.52           C  
ATOM   1556  N   ASN   176      17.441   4.873  18.364  1.00 12.96           N  
ATOM   1557  CA  ASN   176      16.359   4.951  17.389  1.00 13.62           C  
ATOM   1558  C   ASN   176      16.675   5.877  16.204  1.00 12.82           C  
ATOM   1559  O   ASN   176      16.535   5.495  15.045  1.00 12.24           O  
ATOM   1560  CB  ASN   176      15.063   5.432  18.048  1.00 13.13           C  
ATOM   1561  CG  ASN   176      14.461   4.409  18.990  1.00 12.85           C  
ATOM   1562  OD1 ASN   176      14.782   3.232  18.934  1.00 14.11           O  
ATOM   1563  ND2 ASN   176      13.585   4.866  19.853  1.00 12.52           N  
ATOM   1564  N   ILE   177      17.118   7.084  16.523  1.00 12.61           N  
ATOM   1565  CA  ILE   177      17.308   8.114  15.502  1.00 13.60           C  
ATOM   1566  C   ILE   177      18.782   8.149  15.140  1.00 15.44           C  
ATOM   1567  O   ILE   177      19.509   9.067  15.487  1.00 16.67           O  
ATOM   1568  CB  ILE   177      16.792   9.483  15.994  1.00 15.08           C  
ATOM   1569  CG1 ILE   177      15.396   9.382  16.617  1.00 18.27           C  
ATOM   1570  CG2 ILE   177      16.807  10.509  14.844  1.00 17.17           C  
ATOM   1571  CD1 ILE   177      14.325   8.832  15.691  1.00 18.17           C  
ATOM   1572  N   SER   178      19.239   7.101  14.460  1.00 15.05           N  
ATOM   1573  CA  SER   178      20.612   7.012  14.057  1.00 15.96           C  
ATOM   1574  C   SER   178      20.837   6.112  12.866  1.00 13.51           C  
ATOM   1575  O   SER   178      19.916   5.470  12.347  1.00 13.40           O  
ATOM   1576  CB  SER   178      21.474   6.475  15.191  1.00 18.42           C  
ATOM   1577  OG  SER   178      21.264   5.106  15.353  1.00 21.32           O  
ATOM   1578  N   GLN   179      22.111   6.052  12.446  1.00 12.66           N  
ATOM   1579  CA  GLN   179      22.465   5.275  11.267  1.00 11.66           C  
ATOM   1580  C   GLN   179      22.336   3.788  11.483  1.00 12.77           C  
ATOM   1581  O   GLN   179      22.332   3.027  10.526  1.00 12.79           O  
ATOM   1582  CB  GLN   179      23.813   5.688  10.698  1.00 11.62           C  
ATOM   1583  CG  GLN   179      23.701   7.044  10.037  1.00 10.61           C  
ATOM   1584  CD  GLN   179      24.906   7.306   9.178  1.00 11.06           C  
ATOM   1585  OE1 GLN   179      25.158   6.546   8.222  1.00 14.43           O  
ATOM   1586  NE2 GLN   179      25.689   8.341   9.513  1.00 11.50           N  
ATOM   1587  N   GLU   180      22.236   3.362  12.739  1.00 13.28           N  
ATOM   1588  CA  GLU   180      22.004   1.933  12.996  1.00 15.08           C  
ATOM   1589  C   GLU   180      20.712   1.501  12.323  1.00 13.96           C  
ATOM   1590  O   GLU   180      20.633   0.430  11.717  1.00 14.16           O  
ATOM   1591  CB  GLU   180      21.925   1.653  14.478  1.00 16.38           C  
ATOM   1592  N   ASN   181      19.689   2.321  12.437  1.00 11.35           N  
ATOM   1593  CA  ASN   181      18.395   2.062  11.840  1.00 11.90           C  
ATOM   1594  C   ASN   181      18.380   2.340  10.369  1.00 10.50           C  
ATOM   1595  O   ASN   181      17.599   1.680   9.651  1.00 11.78           O  
ATOM   1596  CB  ASN   181      17.262   2.736  12.601  1.00 11.76           C  
ATOM   1597  CG  ASN   181      16.897   1.951  13.810  1.00 12.13           C  
ATOM   1598  OD1 ASN   181      16.926   0.701  13.778  1.00 14.58           O  
ATOM   1599  ND2 ASN   181      16.579   2.629  14.879  1.00 13.07           N  
ATOM   1600  N   VAL   182      19.204   3.283   9.912  1.00  9.58           N  
ATOM   1601  CA  VAL   182      19.272   3.485   8.479  1.00  8.94           C  
ATOM   1602  C   VAL   182      19.767   2.174   7.856  1.00  9.93           C  
ATOM   1603  O   VAL   182      19.159   1.675   6.880  1.00 10.78           O  
ATOM   1604  CB  VAL   182      20.145   4.664   8.107  1.00  9.53           C  
ATOM   1605  CG1 VAL   182      20.256   4.772   6.608  1.00 11.17           C  
ATOM   1606  CG2 VAL   182      19.567   5.967   8.706  1.00 10.62           C  
ATOM   1607  N   GLU   183      20.825   1.598   8.421  1.00  9.99           N  
ATOM   1608  CA  GLU   183      21.371   0.354   7.924  0.50 10.11           C  
ATOM   1610  C   GLU   183      20.409  -0.811   8.080  1.00  9.86           C  
ATOM   1611  O   GLU   183      20.173  -1.614   7.176  1.00 10.02           O  
ATOM   1612  CB  GLU   183      22.661   0.012   8.643  0.50 11.35           C  
ATOM   1614  CG  GLU   183      23.194  -1.326   8.178  0.50 15.01           C  
ATOM   1616  CD  GLU   183      24.666  -1.300   7.952  0.50 15.08           C  
ATOM   1618  OE1 GLU   183      25.108  -0.396   7.213  0.50 30.11           O  
ATOM   1620  OE2 GLU   183      25.371  -2.198   8.448  0.50 31.87           O  
ATOM   1622  N   ARG   184      19.834  -0.915   9.260  1.00 10.06           N  
ATOM   1623  CA  ARG   184      18.922  -2.019   9.533  1.00 10.17           C  
ATOM   1624  C   ARG   184      17.794  -2.061   8.513  1.00 10.00           C  
ATOM   1625  O   ARG   184      17.482  -3.102   7.929  1.00  9.98           O  
ATOM   1626  CB  ARG   184      18.309  -1.917  10.925  1.00 11.15           C  
ATOM   1627  CG  ARG   184      17.365  -3.060  11.290  1.00 12.30           C  
ATOM   1628  CD  ARG   184      16.673  -2.910  12.630  1.00 14.09           C  
ATOM   1629  NE  ARG   184      15.909  -4.137  12.851  1.00 15.57           N  
ATOM   1630  CZ  ARG   184      14.839  -4.272  13.608  1.00 16.60           C  
ATOM   1631  NH1 ARG   184      14.346  -3.265  14.264  1.00 17.24           N  
ATOM   1632  NH2 ARG   184      14.261  -5.452  13.681  1.00 18.03           N  
ATOM   1633  N   PHE   185      17.158  -0.913   8.327  1.00  9.53           N  
ATOM   1634  CA  PHE   185      15.985  -0.841   7.456  1.00  8.59           C  
ATOM   1635  C   PHE   185      16.310  -0.868   5.975  1.00  9.00           C  
ATOM   1636  O   PHE   185      15.525  -1.396   5.205  1.00  9.94           O  
ATOM   1637  CB  PHE   185      15.022   0.247   7.929  1.00  9.55           C  
ATOM   1638  CG  PHE   185      14.341  -0.144   9.178  1.00  9.01           C  
ATOM   1639  CD1 PHE   185      13.326  -1.089   9.134  1.00 10.44           C  
ATOM   1640  CD2 PHE   185      14.745   0.311  10.394  1.00 10.18           C  
ATOM   1641  CE1 PHE   185      12.731  -1.530  10.291  1.00 10.34           C  
ATOM   1642  CE2 PHE   185      14.155  -0.112  11.546  1.00 11.02           C  
ATOM   1643  CZ  PHE   185      13.150  -1.037  11.509  1.00 10.75           C  
ATOM   1644  N   GLN   186      17.472  -0.352   5.587  1.00  8.84           N  
ATOM   1645  CA  GLN   186      17.917  -0.531   4.218  1.00  9.83           C  
ATOM   1646  C   GLN   186      17.985  -2.034   3.954  1.00  9.36           C  
ATOM   1647  O   GLN   186      17.537  -2.522   2.916  1.00  9.42           O  
ATOM   1648  CB  GLN   186      19.305   0.129   4.042  1.00 12.65           C  
ATOM   1649  CG  GLN   186      20.120  -0.095   2.882  1.00 18.81           C  
ATOM   1650  CD  GLN   186      21.548   0.468   3.124  1.00 22.78           C  
ATOM   1651  OE1 GLN   186      22.411   0.262   2.315  1.00 33.67           O  
ATOM   1652  NE2 GLN   186      21.755   1.195   4.243  1.00 25.78           N  
ATOM   1653  N   ASN   187      18.574  -2.780   4.901  1.00  8.98           N  
ATOM   1654  CA  ASN   187      18.703  -4.226   4.689  1.00  9.69           C  
ATOM   1655  C   ASN   187      17.351  -4.932   4.599  1.00  8.77           C  
ATOM   1656  O   ASN   187      17.148  -5.820   3.770  1.00  9.73           O  
ATOM   1657  CB  ASN   187      19.556  -4.867   5.772  1.00  9.65           C  
ATOM   1658  CG  ASN   187      21.018  -4.446   5.706  1.00 12.77           C  
ATOM   1659  OD1 ASN   187      21.483  -3.948   4.685  1.00 16.60           O  
ATOM   1660  ND2 ASN   187      21.743  -4.623   6.805  1.00 15.21           N  
ATOM   1661  N   VAL   188      16.389  -4.487   5.393  1.00  8.25           N  
ATOM   1662  CA  VAL   188      15.047  -5.049   5.336  1.00  8.78           C  
ATOM   1663  C   VAL   188      14.388  -4.804   3.984  1.00  8.05           C  
ATOM   1664  O   VAL   188      13.844  -5.713   3.339  1.00  7.98           O  
ATOM   1665  CB  VAL   188      14.137  -4.456   6.454  1.00  9.61           C  
ATOM   1666  CG1 VAL   188      12.671  -4.878   6.284  1.00 11.93           C  
ATOM   1667  CG2 VAL   188      14.637  -4.839   7.854  1.00 11.67           C  
ATOM   1668  N   LEU   189      14.438  -3.562   3.511  1.00  7.78           N  
ATOM   1669  CA  LEU   189      13.810  -3.207   2.247  1.00  8.02           C  
ATOM   1670  C   LEU   189      14.519  -3.911   1.101  1.00  7.78           C  
ATOM   1671  O   LEU   189      13.890  -4.315   0.122  1.00  8.52           O  
ATOM   1672  CB  LEU   189      13.816  -1.686   2.040  1.00  8.06           C  
ATOM   1673  CG  LEU   189      13.040  -0.877   3.107  1.00  8.50           C  
ATOM   1674  CD1 LEU   189      12.931   0.554   2.625  1.00 10.54           C  
ATOM   1675  CD2 LEU   189      11.636  -1.447   3.420  1.00 10.09           C  
ATOM   1676  N   ASP   190      15.834  -4.068   1.212  1.00  7.87           N  
ATOM   1677  CA  ASP   190      16.601  -4.713   0.145  1.00  8.50           C  
ATOM   1678  C   ASP   190      16.271  -6.199   0.063  1.00  8.73           C  
ATOM   1679  O   ASP   190      16.233  -6.759  -1.037  1.00  9.75           O  
ATOM   1680  CB  ASP   190      18.082  -4.445   0.330  1.00  9.21           C  
ATOM   1681  CG  ASP   190      18.453  -2.983   0.110  1.00 10.79           C  
ATOM   1682  OD1 ASP   190      17.642  -2.201  -0.440  1.00 10.77           O  
ATOM   1683  OD2 ASP   190      19.584  -2.637   0.479  1.00 13.31           O  
ATOM   1684  N   GLU   191      16.024  -6.844   1.197  1.00  8.92           N  
ATOM   1685  CA  GLU   191      15.633  -8.271   1.170  1.00  9.18           C  
ATOM   1686  C   GLU   191      14.268  -8.414   0.494  1.00  9.15           C  
ATOM   1687  O   GLU   191      14.035  -9.403  -0.227  1.00 10.43           O  
ATOM   1688  CB  GLU   191      15.612  -8.868   2.567  1.00 10.40           C  
ATOM   1689  CG  GLU   191      15.204 -10.367   2.612  1.00 11.99           C  
ATOM   1690  CD  GLU   191      13.683 -10.691   2.617  1.00 12.18           C  
ATOM   1691  OE1 GLU   191      12.889  -9.991   3.258  1.00 13.76           O  
ATOM   1692  OE2 GLU   191      13.263 -11.738   2.018  1.00 15.64           O  
ATOM   1693  N   ILE   192      13.353  -7.475   0.691  1.00  8.64           N  
ATOM   1694  CA  ILE   192      12.043  -7.496   0.030  1.00  9.11           C  
ATOM   1695  C   ILE   192      12.183  -7.248  -1.450  1.00  9.06           C  
ATOM   1696  O   ILE   192      11.431  -7.781  -2.257  1.00  9.77           O  
ATOM   1697  CB  ILE   192      11.068  -6.503   0.695  1.00  9.34           C  
ATOM   1698  CG1 ILE   192      10.788  -6.949   2.134  1.00  8.99           C  
ATOM   1699  CG2 ILE   192       9.760  -6.398  -0.105  1.00 11.12           C  
ATOM   1700  CD1 ILE   192      10.126  -5.867   2.992  1.00 10.95           C  
ATOM   1701  N   GLY   193      13.144  -6.415  -1.808  1.00  8.48           N  
ATOM   1702  CA  GLY   193      13.440  -6.090  -3.201  1.00  8.98           C  
ATOM   1703  C   GLY   193      12.861  -4.806  -3.741  1.00  8.30           C  
ATOM   1704  O   GLY   193      12.757  -4.611  -4.937  1.00  8.89           O  
ATOM   1705  N   VAL   194      12.532  -3.893  -2.833  1.00  7.89           N  
ATOM   1706  CA  VAL   194      11.916  -2.609  -3.147  0.51  7.79           C  
ATOM   1708  C   VAL   194      12.786  -1.844  -4.138  1.00  7.24           C  
ATOM   1709  O   VAL   194      13.965  -1.612  -3.880  1.00  8.42           O  
ATOM   1710  CB  VAL   194      11.754  -1.756  -1.841  0.51  7.93           C  
ATOM   1712  CG1 VAL   194      10.847  -2.466  -0.813  0.51  8.64           C  
ATOM   1714  CG2 VAL   194      11.224  -0.366  -2.159  0.51  8.88           C  
ATOM   1718  N   SER   195      12.197  -1.421  -5.252  1.00  7.24           N  
ATOM   1719  CA  SER   195      12.967  -0.743  -6.320  1.00  7.37           C  
ATOM   1720  C   SER   195      13.335   0.701  -6.038  1.00  7.01           C  
ATOM   1721  O   SER   195      14.316   1.197  -6.559  1.00  7.47           O  
ATOM   1722  CB  SER   195      12.163  -0.766  -7.641  1.00  8.14           C  
ATOM   1723  OG  SER   195      11.981  -2.081  -8.152  1.00  8.78           O  
ATOM   1724  N   SER   196      12.468   1.389  -5.289  1.00  6.94           N  
ATOM   1725  CA  SER   196      12.607   2.835  -5.057  1.00  6.98           C  
ATOM   1726  C   SER   196      12.274   3.215  -3.630  1.00  6.76           C  
ATOM   1727  O   SER   196      11.174   3.030  -3.178  1.00  7.30           O  
ATOM   1728  CB  SER   196      11.649   3.562  -6.000  1.00  8.24           C  
ATOM   1729  OG  SER   196      11.766   4.957  -5.877  1.00 13.11           O  
ATOM   1730  N   TYR   197      13.265   3.786  -2.951  1.00  6.84           N  
ATOM   1731  CA  TYR   197      13.055   4.342  -1.605  1.00  7.15           C  
ATOM   1732  C   TYR   197      14.146   5.331  -1.250  1.00  6.91           C  
ATOM   1733  O   TYR   197      15.220   5.364  -1.855  1.00  7.22           O  
ATOM   1734  CB  TYR   197      12.968   3.226  -0.522  1.00  7.54           C  
ATOM   1735  CG  TYR   197      14.250   2.433  -0.278  1.00  7.94           C  
ATOM   1736  CD1 TYR   197      15.315   2.975   0.407  1.00  7.60           C  
ATOM   1737  CD2 TYR   197      14.379   1.132  -0.695  1.00  8.03           C  
ATOM   1738  CE1 TYR   197      16.481   2.241   0.648  1.00  8.83           C  
ATOM   1739  CE2 TYR   197      15.537   0.397  -0.475  1.00  7.92           C  
ATOM   1740  CZ  TYR   197      16.576   0.945   0.222  1.00  8.01           C  
ATOM   1741  OH  TYR   197      17.767   0.278   0.428  1.00  9.56           O  
ATOM   1742  N   GLU   198      13.835   6.124  -0.230  1.00  6.59           N  
ATOM   1743  CA  GLU   198      14.793   6.930   0.476  1.00  6.92           C  
ATOM   1744  C   GLU   198      14.661   6.600   1.966  1.00  6.27           C  
ATOM   1745  O   GLU   198      13.552   6.411   2.453  1.00  7.47           O  
ATOM   1746  CB  GLU   198      14.472   8.434   0.367  1.00  8.45           C  
ATOM   1747  CG  GLU   198      14.424   9.011  -1.009  1.00  9.66           C  
ATOM   1748  CD  GLU   198      13.665  10.326  -1.024  1.00 10.13           C  
ATOM   1749  OE1 GLU   198      12.453  10.271  -0.705  1.00 12.22           O  
ATOM   1750  OE2 GLU   198      14.270  11.365  -1.314  1.00 11.95           O  
ATOM   1751  N   ILE   199      15.766   6.531   2.680  1.00  7.15           N  
ATOM   1752  CA  ILE   199      15.745   6.453   4.152  1.00  6.80           C  
ATOM   1753  C   ILE   199      16.548   7.648   4.584  1.00  7.33           C  
ATOM   1754  O   ILE   199      17.709   7.774   4.207  1.00  8.81           O  
ATOM   1755  CB  ILE   199      16.281   5.152   4.712  1.00  8.16           C  
ATOM   1756  CG1 ILE   199      15.483   3.958   4.181  1.00  8.20           C  
ATOM   1757  CG2 ILE   199      16.222   5.172   6.218  1.00  9.74           C  
ATOM   1758  CD1 ILE   199      16.030   2.597   4.607  1.00 11.40           C  
ATOM   1759  N   ILE   200      15.932   8.530   5.353  1.00  6.71           N  
ATOM   1760  CA  ILE   200      16.532   9.816   5.736  0.51  7.29           C  
ATOM   1762  C   ILE   200      16.774   9.915   7.225  1.00  7.22           C  
ATOM   1763  O   ILE   200      16.058   9.315   8.048  1.00  7.79           O  
ATOM   1764  CB  ILE   200      15.663  11.043   5.332  0.51  6.86           C  
ATOM   1766  CG1 ILE   200      14.341  11.073   6.081  0.51  7.78           C  
ATOM   1768  CG2 ILE   200      15.423  11.099   3.796  0.51  9.15           C  
ATOM   1770  CD1 ILE   200      13.596  12.351   5.802  0.51  9.79           C  
ATOM   1772  N   LEU   201      17.775  10.704   7.570  1.00  7.47           N  
ATOM   1773  CA  LEU   201      18.106  10.998   8.946  1.00  7.40           C  
ATOM   1774  C   LEU   201      18.587  12.431   9.000  1.00  7.56           C  
ATOM   1775  O   LEU   201      19.544  12.790   8.349  1.00  9.03           O  
ATOM   1776  CB  LEU   201      19.164  10.022   9.454  1.00  8.16           C  
ATOM   1777  CG  LEU   201      19.712  10.249  10.831  1.00 10.34           C  
ATOM   1778  CD1 LEU   201      18.664  10.070  11.893  1.00 13.16           C  
ATOM   1779  CD2 LEU   201      20.915   9.304  11.050  1.00 13.25           C  
ATOM   1780  N   GLU   202      17.900  13.238   9.787  1.00  8.39           N  
ATOM   1781  CA  GLU   202      18.265  14.623   9.936  1.00  9.66           C  
ATOM   1782  C   GLU   202      17.541  15.269  11.080  1.00  9.31           C  
ATOM   1783  O   GLU   202      17.020  14.596  11.960  1.00  9.63           O  
ATOM   1784  N   ASP   203      17.484  16.584  11.052  1.00 10.94           N  
ATOM   1785  CA  ASP   203      16.906  17.309  12.187  1.00 12.13           C  
ATOM   1786  C   ASP   203      15.431  17.019  12.393  1.00 11.44           C  
ATOM   1787  O   ASP   203      14.918  17.250  13.478  1.00 12.93           O  
ATOM   1788  CB  ASP   203      17.175  18.812  12.072  1.00 14.32           C  
ATOM   1789  CG  ASP   203      18.660  19.168  12.294  1.00 15.59           C  
ATOM   1790  OD1 ASP   203      19.428  18.384  12.885  1.00 17.55           O  
ATOM   1791  OD2 ASP   203      19.060  20.272  11.925  1.00 21.01           O  
ATOM   1792  N   GLU   204      14.757  16.514  11.387  0.51 10.46           N  
ATOM   1794  CA  GLU   204      13.337  16.242  11.520  0.51 10.84           C  
ATOM   1796  C   GLU   204      13.061  14.843  12.010  0.51 10.34           C  
ATOM   1798  O   GLU   204      11.934  14.482  12.340  0.51 10.98           O  
ATOM   1800  CB  GLU   204      12.628  16.441  10.193  0.51 11.71           C  
ATOM   1802  CG  GLU   204      13.002  15.418   9.132  0.51 12.75           C  
ATOM   1804  CD  GLU   204      14.113  15.834   8.179  0.51 13.60           C  
ATOM   1806  OE1 GLU   204      15.214  16.370   8.566  0.51 14.70           O  
ATOM   1808  OE2 GLU   204      13.877  15.583   6.979  0.51 15.00           O  
ATOM   1810  N   GLY   205      14.119  14.063  12.056  1.00  9.31           N  
ATOM   1811  CA  GLY   205      14.065  12.680  12.560  1.00  9.02           C  
ATOM   1812  C   GLY   205      14.623  11.644  11.596  1.00  8.05           C  
ATOM   1813  O   GLY   205      15.423  11.968  10.705  1.00  8.62           O  
ATOM   1814  N   PHE   206      14.190  10.405  11.815  1.00  7.06           N  
ATOM   1815  CA  PHE   206      14.561   9.218  11.017  1.00  6.37           C  
ATOM   1816  C   PHE   206      13.286   8.781  10.308  1.00  6.15           C  
ATOM   1817  O   PHE   206      12.287   8.508  10.975  1.00  6.14           O  
ATOM   1818  CB  PHE   206      15.040   8.099  11.939  1.00  7.23           C  
ATOM   1819  CG  PHE   206      15.071   6.743  11.261  1.00  8.04           C  
ATOM   1820  CD1 PHE   206      16.090   6.393  10.396  1.00  9.90           C  
ATOM   1821  CD2 PHE   206      14.064   5.842  11.437  1.00  9.37           C  
ATOM   1822  CE1 PHE   206      16.076   5.167   9.762  1.00 10.64           C  
ATOM   1823  CE2 PHE   206      14.067   4.597  10.797  1.00 10.05           C  
ATOM   1824  CZ  PHE   206      15.066   4.283   9.978  1.00  9.14           C  
ATOM   1825  N   TRP   207      13.302   8.677   8.971  1.00  5.96           N  
ATOM   1826  CA  TRP   207      12.075   8.353   8.231  1.00  5.95           C  
ATOM   1827  C   TRP   207      12.387   7.496   7.015  1.00  6.25           C  
ATOM   1828  O   TRP   207      13.307   7.774   6.248  1.00  7.20           O  
ATOM   1829  CB  TRP   207      11.338   9.619   7.803  1.00  6.22           C  
ATOM   1830  CG  TRP   207      11.025  10.523   8.968  1.00  6.85           C  
ATOM   1831  CD1 TRP   207      11.767  11.579   9.408  1.00  7.54           C  
ATOM   1832  CD2 TRP   207       9.936  10.403   9.871  1.00  6.13           C  
ATOM   1833  NE1 TRP   207      11.189  12.128  10.521  1.00  7.82           N  
ATOM   1834  CE2 TRP   207      10.062  11.424  10.828  1.00  6.99           C  
ATOM   1835  CE3 TRP   207       8.857   9.532   9.965  1.00  7.19           C  
ATOM   1836  CZ2 TRP   207       9.123  11.610  11.854  1.00  7.88           C  
ATOM   1837  CZ3 TRP   207       7.911   9.720  10.987  1.00  7.28           C  
ATOM   1838  CH2 TRP   207       8.067  10.745  11.909  1.00  8.41           C  
ATOM   1839  N   ILE   208      11.558   6.463   6.848  1.00  5.94           N  
ATOM   1840  CA  ILE   208      11.600   5.524   5.739  1.00  6.12           C  
ATOM   1841  C   ILE   208      10.537   5.928   4.739  1.00  5.45           C  
ATOM   1842  O   ILE   208       9.349   5.952   5.059  1.00  6.40           O  
ATOM   1843  CB  ILE   208      11.359   4.101   6.262  1.00  5.82           C  
ATOM   1844  CG1 ILE   208      12.436   3.678   7.274  1.00  7.29           C  
ATOM   1845  CG2 ILE   208      11.250   3.117   5.101  1.00  8.18           C  
ATOM   1846  CD1 ILE   208      12.021   2.499   8.167  1.00  7.79           C  
ATOM   1847  N   ILE   209      10.987   6.219   3.519  1.00  5.86           N  
ATOM   1848  CA  ILE   209      10.141   6.784   2.468  1.00  6.44           C  
ATOM   1849  C   ILE   209      10.178   5.901   1.224  1.00  5.76           C  
ATOM   1850  O   ILE   209      11.044   6.015   0.339  1.00  6.98           O  
ATOM   1851  CB  ILE   209      10.618   8.215   2.113  1.00  6.53           C  
ATOM   1852  CG1 ILE   209      10.623   9.090   3.364  1.00  7.73           C  
ATOM   1853  CG2 ILE   209       9.744   8.827   1.014  1.00  7.77           C  
ATOM   1854  CD1 ILE   209      11.241  10.463   3.206  1.00  9.24           C  
ATOM   1855  N   ILE   210       9.238   4.975   1.184  1.00  6.60           N  
ATOM   1856  CA  ILE   210       9.101   4.036   0.090  1.00  6.60           C  
ATOM   1857  C   ILE   210       8.194   4.654  -0.956  1.00  7.33           C  
ATOM   1858  O   ILE   210       7.182   5.254  -0.639  1.00  8.13           O  
ATOM   1859  CB  ILE   210       8.496   2.718   0.596  1.00  7.30           C  
ATOM   1860  CG1 ILE   210       9.459   2.044   1.593  1.00  8.56           C  
ATOM   1861  CG2 ILE   210       8.152   1.778  -0.566  1.00  9.41           C  
ATOM   1862  CD1 ILE   210       8.779   1.030   2.522  1.00 10.57           C  
ATOM   1863  N   SER   211       8.542   4.428  -2.218  1.00  7.80           N  
ATOM   1864  CA  SER   211       7.704   4.787  -3.346  1.00  9.51           C  
ATOM   1865  C   SER   211       7.310   3.536  -4.068  1.00  9.69           C  
ATOM   1866  O   SER   211       8.175   2.864  -4.583  1.00 14.81           O  
ATOM   1867  CB  SER   211       8.463   5.621  -4.353  1.00 10.93           C  
ATOM   1868  OG  SER   211       8.739   6.890  -3.859  1.00 12.33           O  
ATOM   1869  N   LYS   212       6.037   3.229  -4.210  1.00 10.63           N  
ATOM   1870  CA  LYS   212       5.665   2.060  -4.958  1.00 10.65           C  
ATOM   1871  C   LYS   212       5.632   2.404  -6.409  1.00  9.76           C  
ATOM   1872  O   LYS   212       4.902   3.275  -6.862  1.00 12.14           O  
ATOM   1873  CB  LYS   212       4.309   1.506  -4.519  1.00 11.11           C  
ATOM   1874  CG  LYS   212       3.923   0.279  -5.352  1.00 13.46           C  
ATOM   1875  CD  LYS   212       2.588  -0.397  -5.039  1.00 18.87           C  
ATOM   1876  CE  LYS   212       2.723  -1.451  -4.033  1.00 15.44           C  
ATOM   1877  NZ  LYS   212       1.493  -2.207  -3.667  1.00  9.74           N  
ATOM   1878  N   THR   213       6.431   1.694  -7.159  1.00 12.74           N  
ATOM   1879  CA  THR   213       6.569   1.950  -8.568  1.00 12.48           C  
ATOM   1880  C   THR   213       6.693   0.638  -9.305  1.00 10.87           C  
ATOM   1881  O   THR   213       7.025  -0.379  -8.733  1.00 13.74           O  
ATOM   1882  CB  THR   213       7.791   2.873  -8.803  1.00 13.61           C  
ATOM   1883  OG1 THR   213       7.713   3.501 -10.087  1.00 17.55           O  
ATOM   1884  CG2 THR   213       9.149   2.143  -8.597  1.00 15.43           C  
ATOM   1885  N   ASP   214       6.456   0.674 -10.605  1.00 10.89           N  
ATOM   1886  CA  ASP   214       6.591  -0.516 -11.448  1.00 10.60           C  
ATOM   1887  C   ASP   214       8.030  -1.029 -11.294  1.00 11.07           C  
ATOM   1888  O   ASP   214       8.984  -0.292 -11.512  1.00 11.94           O  
ATOM   1889  CB  ASP   214       6.265  -0.193 -12.889  1.00 12.55           C  
ATOM   1890  CG  ASP   214       4.780   0.093 -13.126  1.00 13.76           C  
ATOM   1891  OD1 ASP   214       3.917  -0.336 -12.313  1.00 15.87           O  
ATOM   1892  OD2 ASP   214       4.482   0.751 -14.144  1.00 17.35           O  
ATOM   1893  N   GLN   215       8.167  -2.276 -10.897  1.00  9.57           N  
ATOM   1894  CA  GLN   215       9.446  -2.776 -10.472  1.00  8.21           C  
ATOM   1895  C   GLN   215      10.493  -2.921 -11.555  1.00  8.15           C  
ATOM   1896  O   GLN   215      10.210  -3.132 -12.735  1.00  9.83           O  
ATOM   1897  CB  GLN   215       9.325  -4.059  -9.688  1.00  9.05           C  
ATOM   1898  CG  GLN   215       8.982  -5.284 -10.470  1.00 10.29           C  
ATOM   1899  CD  GLN   215       9.012  -6.495  -9.570  1.00  9.65           C  
ATOM   1900  OE1 GLN   215       8.463  -6.458  -8.451  1.00 10.50           O  
ATOM   1901  NE2 GLN   215       9.664  -7.570 -10.003  1.00  9.58           N  
ATOM   1902  N   GLU   216      11.743  -2.895 -11.125  1.00  8.07           N  
ATOM   1903  CA  GLU   216      12.863  -2.943 -12.054  1.00  8.31           C  
ATOM   1904  C   GLU   216      13.142  -4.322 -12.618  1.00  8.10           C  
ATOM   1905  O   GLU   216      13.691  -4.421 -13.713  1.00  9.58           O  
ATOM   1906  CB  GLU   216      14.129  -2.364 -11.402  1.00  9.90           C  
ATOM   1907  CG  GLU   216      14.607  -3.115 -10.206  1.00  8.84           C  
ATOM   1908  CD  GLU   216      15.623  -2.326  -9.428  1.00  9.44           C  
ATOM   1909  OE1 GLU   216      16.487  -1.646 -10.041  1.00 11.52           O  
ATOM   1910  OE2 GLU   216      15.587  -2.398  -8.197  1.00 10.51           O  
ATOM   1911  N   VAL   217      12.804  -5.374 -11.889  1.00  7.86           N  
ATOM   1912  CA  VAL   217      13.046  -6.739 -12.369  1.00  8.11           C  
ATOM   1913  C   VAL   217      11.827  -7.236 -13.112  1.00  7.99           C  
ATOM   1914  O   VAL   217      10.778  -7.528 -12.532  1.00  9.26           O  
ATOM   1915  CB  VAL   217      13.419  -7.703 -11.210  1.00  8.89           C  
ATOM   1916  CG1 VAL   217      13.576  -9.130 -11.753  1.00 11.10           C  
ATOM   1917  CG2 VAL   217      14.685  -7.236 -10.507  1.00 10.59           C  
ATOM   1918  N   ILE   218      11.981  -7.338 -14.425  1.00  8.45           N  
ATOM   1919  CA  ILE   218      10.971  -7.885 -15.321  1.00  9.15           C  
ATOM   1920  C   ILE   218      11.632  -8.729 -16.414  1.00 10.29           C  
ATOM   1921  O   ILE   218      12.876  -8.674 -16.590  1.00 10.34           O  
ATOM   1922  CB  ILE   218      10.052  -6.829 -15.982  1.00 10.14           C  
ATOM   1923  CG1 ILE   218      10.841  -5.840 -16.818  1.00  9.54           C  
ATOM   1924  CG2 ILE   218       9.197  -6.156 -14.932  1.00 11.46           C  
ATOM   1925  CD1 ILE   218       9.974  -4.931 -17.648  1.00 11.50           C  
ATOM   1926  OXT ILE   218      10.883  -9.441 -17.135  1.00 11.01           O  
END
