
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  190 ( 1533),  selected  190 , name 3dh0_B
# Molecule2: number of CA atoms  218 ( 1715),  selected  218 , name T0485.pdb
# PARAMETERS: 3dh0_B.T0485.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     4_B      M       1           -
LGA    H     5_B      S       2           -
LGA    K     6_B      E       3           -
LGA    -       -      N       4           -
LGA    -       -      K       5           -
LGA    F     7_B      K       6           #
LGA    D     8_B      K       7          1.931
LGA    P     9_B      F       8          2.795
LGA    -       -      D       9           -
LGA    -       -      K      10           -
LGA    S    10_B      K      11          1.577
LGA    K    11_B      G      12          1.967
LGA    I    12_B      A      13          1.505
LGA    K    13_B      K      14          2.496
LGA    K    14_B      N      15          2.643
LGA    L    15_B      M      16          2.148
LGA    D    16_B      D      17          2.534
LGA    D    17_B      E      18          3.515
LGA    -       -      I      19           -
LGA    -       -      S      20           -
LGA    -       -      K      21           -
LGA    P    18_B      T      22          1.913
LGA    S    19_B      L      23          0.652
LGA    R    20_B      F      24          0.855
LGA    L    21_B      A      25          3.509
LGA    E    22_B      P      26          5.384
LGA    L    23_B      -       -           -
LGA    F    24_B      -       -           -
LGA    D    25_B      I      27          3.733
LGA    P    26_B      Y      28          3.206
LGA    E    27_B      P      29          3.242
LGA    K    28_B      I      30          3.478
LGA    V    29_B      I      31          3.095
LGA    L    30_B      A      32          2.952
LGA    K    31_B      E      33          3.254
LGA    E    32_B      N      34          3.091
LGA    -       -      I      35           -
LGA    -       -      I      36           -
LGA    -       -      N      37           -
LGA    F    33_B      R      38          3.382
LGA    G    34_B      F      39          2.209
LGA    L    35_B      G      40          5.769
LGA    K    36_B      I      41          2.985
LGA    E    37_B      T      42          2.219
LGA    G    38_B      A      43          1.333
LGA    M    39_B      G      44          2.680
LGA    T    40_B      N      45          0.988
LGA    V    41_B      C      46          0.637
LGA    L    42_B      I      47          0.354
LGA    D    43_B      D      48          0.296
LGA    V    44_B      I      49          0.248
LGA    G    45_B      G      50          0.573
LGA    T    46_B      S      51          0.497
LGA    G    47_B      G      52          0.747
LGA    A    48_B      P      53          1.066
LGA    G    49_B      G      54          0.949
LGA    F    50_B      A      55          1.662
LGA    Y    51_B      L      56          1.359
LGA    L    52_B      S      57          1.825
LGA    P    53_B      I      58          1.320
LGA    Y    54_B      A      59          1.005
LGA    L    55_B      L      60          1.475
LGA    S    56_B      A      61          1.220
LGA    K    57_B      K      62          1.873
LGA    M    58_B      Q      63          2.838
LGA    V    59_B      S      64          3.023
LGA    G    60_B      D      65          1.731
LGA    E    61_B      -       -           -
LGA    K    62_B      -       -           -
LGA    G    63_B      F      66          2.658
LGA    K    64_B      S      67          0.316
LGA    V    65_B      I      68          0.323
LGA    Y    66_B      R      69          0.522
LGA    A    67_B      A      70          0.204
LGA    I    68_B      L      71          0.456
LGA    D    69_B      D      72          0.646
LGA    V    70_B      F      73          0.771
LGA    Q    71_B      S      74          1.043
LGA    E    72_B      K      75          0.842
LGA    E    73_B      H      76          0.882
LGA    M    74_B      M      77          1.072
LGA    V    75_B      N      78          1.409
LGA    N    76_B      E      79          1.567
LGA    Y    77_B      I      80          1.344
LGA    A    78_B      A      81          0.743
LGA    W    79_B      L      82          1.263
LGA    E    80_B      K      83          1.726
LGA    K    81_B      N      84          1.479
LGA    V    82_B      I      85          0.806
LGA    N    83_B      A      86          1.368
LGA    K    84_B      D      87          1.772
LGA    L    85_B      A      88          1.335
LGA    G    86_B      D      89          0.850
LGA    L    87_B      L      90          0.290
LGA    K    88_B      N      91          3.587
LGA    -       -      D      92           -
LGA    N    89_B      R      93          1.294
LGA    V    90_B      I      94          0.693
LGA    E    91_B      Q      95          0.635
LGA    V    92_B      I      96          0.459
LGA    L    93_B      V      97          0.521
LGA    K    94_B      Q      98          0.372
LGA    S    95_B      G      99          0.625
LGA    E    96_B      D     100          2.731
LGA    E    97_B      V     101          4.493
LGA    N    98_B      H     102          0.814
LGA    K    99_B      N     103          0.807
LGA    I   100_B      I     104          0.870
LGA    P   101_B      P     105          0.948
LGA    L   102_B      I     106          1.005
LGA    P   103_B      E     107          1.129
LGA    D   104_B      D     108          1.249
LGA    N   105_B      N     109          1.318
LGA    T   106_B      Y     110          1.029
LGA    V   107_B      A     111          0.488
LGA    D   108_B      D     112          0.718
LGA    F   109_B      L     113          0.593
LGA    I   110_B      I     114          0.656
LGA    F   111_B      V     115          0.541
LGA    M   112_B      S     116          1.426
LGA    A   113_B      R     117          0.542
LGA    F   114_B      G     118          0.971
LGA    T   115_B      S     119          0.781
LGA    F   116_B      V     120          0.701
LGA    H   117_B      F     121          1.083
LGA    E   118_B      F     122          1.218
LGA    L   119_B      W     123          1.156
LGA    S   120_B      E     124          0.687
LGA    E   121_B      D     125          0.920
LGA    P   122_B      V     126          0.762
LGA    L   123_B      T     127          1.294
LGA    K   124_B      T     128          0.360
LGA    F   125_B      A     129          1.005
LGA    L   126_B      F     130          1.019
LGA    E   127_B      R     131          1.032
LGA    E   128_B      E     132          1.165
LGA    L   129_B      I     133          1.245
LGA    K   130_B      Y     134          1.591
LGA    R   131_B      R     135          1.646
LGA    V   132_B      I     136          1.332
LGA    A   133_B      L     137          1.250
LGA    K   134_B      K     138          0.748
LGA    P   135_B      S     139          1.293
LGA    F   136_B      G     140          1.909
LGA    A   137_B      G     141          0.925
LGA    Y   138_B      K     142          0.583
LGA    L   139_B      T     143          0.914
LGA    A   140_B      Y     144          0.417
LGA    I   141_B      I     145          1.709
LGA    I   142_B      G     146          2.551
LGA    D   143_B      G     147          2.126
LGA    W   144_B      G     148          5.615
LGA    K   145_B      F     149           -
LGA    K   146_B      G     150           -
LGA    E   147_B      N     151           -
LGA    E   148_B      K     152           -
LGA    R   149_B      E     153           -
LGA    D   150_B      L     154           -
LGA    -       -      R     155           -
LGA    K   151_B      D     156           #
LGA    G   152_B      S     157           -
LGA    -       -      I     158           -
LGA    -       -      S     159           -
LGA    -       -      A     160           -
LGA    -       -      E     161           -
LGA    -       -      M     162           -
LGA    -       -      I     163           -
LGA    -       -      R     164           -
LGA    -       -      K     165           -
LGA    -       -      N     166           -
LGA    -       -      P     167           -
LGA    -       -      D     168           -
LGA    P   153_B      W     169          2.971
LGA    -       -      K     170           -
LGA    -       -      E     171           -
LGA    P   154_B      F     172          2.077
LGA    P   155_B      N     173          5.319
LGA    -       -      R     174           -
LGA    E   156_B      K     175          5.451
LGA    E   157_B      -       -           -
LGA    V   158_B      N     176          3.450
LGA    Y   159_B      I     177           #
LGA    -       -      S     178           -
LGA    -       -      Q     179           -
LGA    S   160_B      E     180          2.852
LGA    E   161_B      N     181          3.594
LGA    W   162_B      V     182          1.720
LGA    E   163_B      E     183          2.543
LGA    -       -      R     184           -
LGA    V   164_B      F     185          2.054
LGA    G   165_B      Q     186          2.433
LGA    L   166_B      N     187          2.418
LGA    I   167_B      V     188          1.757
LGA    L   168_B      L     189          2.293
LGA    E   169_B      D     190          2.859
LGA    D   170_B      E     191          2.596
LGA    A   171_B      I     192          2.575
LGA    G   172_B      G     193          2.996
LGA    I   173_B      V     194          3.341
LGA    -       -      S     195           -
LGA    R   174_B      S     196          2.800
LGA    V   175_B      Y     197          2.175
LGA    G   176_B      E     198          2.687
LGA    R   177_B      I     199           #
LGA    V   178_B      I     200          0.876
LGA    V   179_B      L     201          3.577
LGA    E   180_B      E     202          1.177
LGA    V   181_B      D     203          3.247
LGA    G   182_B      E     204          4.329
LGA    K   183_B      -       -           -
LGA    Y   184_B      -       -           -
LGA    C   185_B      G     205          3.056
LGA    F   186_B      F     206          2.311
LGA    G   187_B      W     207          2.788
LGA    V   188_B      I     208          3.421
LGA    Y   189_B      I     209          2.621
LGA    A   190_B      I     210          2.611
LGA    M   191_B      S     211          1.340
LGA    I   192_B      K     212          2.268
LGA    V   193_B      T     213          2.679
LGA    -       -      D     214           -
LGA    -       -      Q     215           -
LGA    -       -      E     216           -
LGA    -       -      V     217           -
LGA    -       -      I     218           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  190  218    5.0    169    2.15    16.57     62.604     7.521

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.885203 * X  +  -0.374900 * Y  +  -0.275438 * Z  +  10.154799
  Y_new =  -0.422670 * X  +   0.895477 * Y  +   0.139540 * Z  +  -9.110581
  Z_new =   0.194335 * X  +   0.239940 * Y  +  -0.951137 * Z  +  24.455454 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.894482   -0.247111  [ DEG:   165.8416    -14.1584 ]
  Theta =  -0.195579   -2.946013  [ DEG:   -11.2059   -168.7941 ]
  Phi   =  -2.696120    0.445473  [ DEG:  -154.4763     25.5237 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3dh0_B                                        
REMARK     2: T0485.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3dh0_B.T0485.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  190  218   5.0  169   2.15   16.57  62.604
REMARK  ---------------------------------------------------------- 
MOLECULE 3dh0_B
HEADER    TRANSFERASE                             16-JUN-08   3DH0              
TITLE     CRYSTAL STRUCTURE OF A SAM DEPENDENT METHYLTRANSFERASE FROM           
TITLE    2 AQUIFEX AEOLICUS                                                     
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SAM DEPENDENT METHYLTRANSFERASE;                           
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: AQUIFEX AEOLICUS;                               
SOURCE   3 STRAIN: VF5;                                                         
SOURCE   4 GENE: AQ_1457;                                                       
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)RIPL;                             
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PSGX3(BC)                                 
KEYWDS    CYSTAL STRUCTURE, PSI-2, NYSGXRC, 11116C, SAM DEPENDENT,              
KEYWDS   2 METHYLTRANSFERASE, STRUCTURAL GENOMICS, PROTEIN STRUCTURE            
KEYWDS   3 INITIATIVE, NEW YORK SGX RESEARCH CENTER FOR STRUCTURAL              
KEYWDS   4 GENOMICS                                                             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    R.AGARWAL,S.K.BURLEY,S.SWAMINATHAN,NEW YORK SGX RESEARCH              
AUTHOR   2 CENTER FOR STRUCTURAL GENOMICS (NYSGXRC)                             
REVDAT   1   15-JUL-08 3DH0    0                                                
JRNL        AUTH   R.AGARWAL,S.K.BURLEY,S.SWAMINATHAN                           
JRNL        TITL   CRYSTAL STRUCTURE OF A SAM DEPENDENT                         
JRNL        TITL 2 METHYLTRANSFERASE FROM AQUIFEX AEOLICUS                      
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.72 ANGSTROMS.                                          
DBREF  3DH0 A    4   211  UNP    O67440   O67440_AQUAE     2    209             
DBREF  3DH0 B    4   211  UNP    O67440   O67440_AQUAE     2    209             
SEQRES   1 A  219  MET SER LEU ALA HIS LYS PHE ASP PRO SER LYS ILE LYS          
SEQRES   2 A  219  LYS LEU ASP ASP PRO SER ARG LEU GLU LEU PHE ASP PRO          
SEQRES   3 A  219  GLU LYS VAL LEU LYS GLU PHE GLY LEU LYS GLU GLY MET          
SEQRES   4 A  219  THR VAL LEU ASP VAL GLY THR GLY ALA GLY PHE TYR LEU          
SEQRES   5 A  219  PRO TYR LEU SER LYS MET VAL GLY GLU LYS GLY LYS VAL          
SEQRES   6 A  219  TYR ALA ILE ASP VAL GLN GLU GLU MET VAL ASN TYR ALA          
SEQRES   7 A  219  TRP GLU LYS VAL ASN LYS LEU GLY LEU LYS ASN VAL GLU          
SEQRES   8 A  219  VAL LEU LYS SER GLU GLU ASN LYS ILE PRO LEU PRO ASP          
SEQRES   9 A  219  ASN THR VAL ASP PHE ILE PHE MET ALA PHE THR PHE HIS          
SEQRES  10 A  219  GLU LEU SER GLU PRO LEU LYS PHE LEU GLU GLU LEU LYS          
SEQRES  11 A  219  ARG VAL ALA LYS PRO PHE ALA TYR LEU ALA ILE ILE ASP          
SEQRES  12 A  219  TRP LYS LYS GLU GLU ARG ASP LYS GLY PRO PRO PRO GLU          
SEQRES  13 A  219  GLU VAL TYR SER GLU TRP GLU VAL GLY LEU ILE LEU GLU          
SEQRES  14 A  219  ASP ALA GLY ILE ARG VAL GLY ARG VAL VAL GLU VAL GLY          
SEQRES  15 A  219  LYS TYR CYS PHE GLY VAL TYR ALA MET ILE VAL LYS GLN          
SEQRES  16 A  219  GLU GLU GLU ASN PRO LEU MET ASN VAL PRO PHE LYS ILE          
SEQRES  17 A  219  PRO PRO GLY GLU GLY HIS HIS HIS HIS HIS HIS                  
SEQRES   1 B  219  MET SER LEU ALA HIS LYS PHE ASP PRO SER LYS ILE LYS          
SEQRES   2 B  219  LYS LEU ASP ASP PRO SER ARG LEU GLU LEU PHE ASP PRO          
SEQRES   3 B  219  GLU LYS VAL LEU LYS GLU PHE GLY LEU LYS GLU GLY MET          
SEQRES   4 B  219  THR VAL LEU ASP VAL GLY THR GLY ALA GLY PHE TYR LEU          
SEQRES   5 B  219  PRO TYR LEU SER LYS MET VAL GLY GLU LYS GLY LYS VAL          
SEQRES   6 B  219  TYR ALA ILE ASP VAL GLN GLU GLU MET VAL ASN TYR ALA          
SEQRES   7 B  219  TRP GLU LYS VAL ASN LYS LEU GLY LEU LYS ASN VAL GLU          
SEQRES   8 B  219  VAL LEU LYS SER GLU GLU ASN LYS ILE PRO LEU PRO ASP          
SEQRES   9 B  219  ASN THR VAL ASP PHE ILE PHE MET ALA PHE THR PHE HIS          
SEQRES  10 B  219  GLU LEU SER GLU PRO LEU LYS PHE LEU GLU GLU LEU LYS          
SEQRES  11 B  219  ARG VAL ALA LYS PRO PHE ALA TYR LEU ALA ILE ILE ASP          
SEQRES  12 B  219  TRP LYS LYS GLU GLU ARG ASP LYS GLY PRO PRO PRO GLU          
SEQRES  13 B  219  GLU VAL TYR SER GLU TRP GLU VAL GLY LEU ILE LEU GLU          
SEQRES  14 B  219  ASP ALA GLY ILE ARG VAL GLY ARG VAL VAL GLU VAL GLY          
SEQRES  15 B  219  LYS TYR CYS PHE GLY VAL TYR ALA MET ILE VAL LYS GLN          
SEQRES  16 B  219  GLU GLU GLU ASN PRO LEU MET ASN VAL PRO PHE LYS ILE          
SEQRES  17 B  219  PRO PRO GLY GLU GLY HIS HIS HIS HIS HIS HIS                  
HET    SAM  A 220      27                                                       
HET    SAM  B 300      27                                                       
HETNAM     SAM S-ADENOSYLMETHIONINE                                             
FORMUL   3  SAM    2(C15 H22 N6 O5 S)                                           
FORMUL   5  HOH   *47(H2 O)                                                     
CRYST1   66.436   42.902   84.253  90.00 106.74  90.00 P 1 21 1      4          
ATOM   1520  N   ALA B   4      13.605  -3.468  22.903  1.00 47.24           N  
ATOM   1521  CA  ALA B   4      12.768  -3.128  21.714  1.00 47.11           C  
ATOM   1522  C   ALA B   4      11.314  -3.615  21.793  1.00 47.51           C  
ATOM   1523  O   ALA B   4      10.738  -3.879  20.743  1.00 50.27           O  
ATOM   1524  CB  ALA B   4      13.428  -3.702  20.446  1.00 44.44           C  
ATOM   1525  N   HIS B   5      10.693  -3.720  22.979  1.00 46.55           N  
ATOM   1526  CA  HIS B   5       9.320  -4.252  22.995  1.00 45.89           C  
ATOM   1527  C   HIS B   5       8.104  -3.319  22.935  1.00 45.50           C  
ATOM   1528  O   HIS B   5       8.229  -2.092  22.921  1.00 45.50           O  
ATOM   1529  CB  HIS B   5       9.134  -5.299  24.126  1.00 46.51           C  
ATOM   1530  CG  HIS B   5       9.129  -4.749  25.524  1.00 46.79           C  
ATOM   1531  ND1 HIS B   5       8.349  -3.677  25.907  1.00 46.11           N  
ATOM   1532  CD2 HIS B   5       9.711  -5.213  26.659  1.00 45.43           C  
ATOM   1533  CE1 HIS B   5       8.446  -3.509  27.216  1.00 45.31           C  
ATOM   1534  NE2 HIS B   5       9.265  -4.428  27.696  1.00 44.95           N  
ATOM   1535  N   LYS B   6       6.924  -3.933  22.869  1.00 44.05           N  
ATOM   1536  CA  LYS B   6       5.659  -3.218  22.756  1.00 43.13           C  
ATOM   1537  C   LYS B   6       5.556  -2.058  23.719  1.00 42.80           C  
ATOM   1538  O   LYS B   6       6.333  -1.984  24.656  1.00 45.53           O  
ATOM   1539  CB  LYS B   6       4.499  -4.189  22.979  1.00 42.41           C  
ATOM   1540  CG  LYS B   6       3.289  -3.880  22.143  1.00 39.98           C  
ATOM   1541  CD  LYS B   6       3.656  -3.768  20.656  1.00 40.34           C  
ATOM   1542  CE  LYS B   6       4.094  -5.103  20.028  1.00 40.40           C  
ATOM   1543  NZ  LYS B   6       4.344  -5.007  18.545  1.00 37.66           N  
ATOM   1544  N   PHE B   7       4.605  -1.155  23.492  1.00 41.23           N  
ATOM   1545  CA  PHE B   7       4.438  -0.002  24.368  1.00 41.05           C  
ATOM   1546  C   PHE B   7       3.461  -0.290  25.505  1.00 41.79           C  
ATOM   1547  O   PHE B   7       2.384  -0.821  25.280  1.00 42.50           O  
ATOM   1548  CB  PHE B   7       3.937   1.196  23.573  1.00 39.75           C  
ATOM   1549  CG  PHE B   7       4.025   2.494  24.320  1.00 39.63           C  
ATOM   1550  CD1 PHE B   7       5.095   3.357  24.111  1.00 39.83           C  
ATOM   1551  CD2 PHE B   7       3.041   2.854  25.236  1.00 38.16           C  
ATOM   1552  CE1 PHE B   7       5.187   4.572  24.802  1.00 38.02           C  
ATOM   1553  CE2 PHE B   7       3.121   4.058  25.929  1.00 38.42           C  
ATOM   1554  CZ  PHE B   7       4.199   4.921  25.711  1.00 37.32           C  
ATOM   1555  N   ASP B   8       3.830   0.086  26.725  1.00 43.39           N  
ATOM   1556  CA  ASP B   8       2.987  -0.153  27.895  1.00 44.43           C  
ATOM   1557  C   ASP B   8       1.730   0.707  27.899  1.00 44.33           C  
ATOM   1558  O   ASP B   8       1.788   1.913  28.169  1.00 43.70           O  
ATOM   1559  CB  ASP B   8       3.763   0.121  29.184  1.00 46.32           C  
ATOM   1560  CG  ASP B   8       3.157  -0.578  30.391  1.00 48.56           C  
ATOM   1561  OD1 ASP B   8       1.923  -0.482  30.599  1.00 49.35           O  
ATOM   1562  OD2 ASP B   8       3.923  -1.227  31.138  1.00 51.59           O  
ATOM   1563  N   PRO B   9       0.571   0.082  27.633  1.00 44.48           N  
ATOM   1564  CA  PRO B   9      -0.746   0.729  27.587  1.00 44.76           C  
ATOM   1565  C   PRO B   9      -1.054   1.545  28.848  1.00 45.99           C  
ATOM   1566  O   PRO B   9      -1.795   2.544  28.799  1.00 45.16           O  
ATOM   1567  CB  PRO B   9      -1.704  -0.450  27.430  1.00 44.30           C  
ATOM   1568  CG  PRO B   9      -0.865  -1.507  26.773  1.00 43.62           C  
ATOM   1569  CD  PRO B   9       0.442  -1.380  27.491  1.00 43.45           C  
ATOM   1570  N   SER B  10      -0.498   1.108  29.979  1.00 46.72           N  
ATOM   1571  CA  SER B  10      -0.724   1.791  31.253  1.00 48.20           C  
ATOM   1572  C   SER B  10      -0.230   3.239  31.195  1.00 47.73           C  
ATOM   1573  O   SER B  10      -0.748   4.115  31.887  1.00 48.53           O  
ATOM   1574  CB  SER B  10      -0.005   1.060  32.391  1.00 49.42           C  
ATOM   1575  OG  SER B  10       1.405   1.157  32.247  1.00 51.74           O  
ATOM   1576  N   LYS B  11       0.771   3.483  30.361  1.00 47.31           N  
ATOM   1577  CA  LYS B  11       1.330   4.816  30.216  1.00 46.13           C  
ATOM   1578  C   LYS B  11       0.906   5.444  28.897  1.00 44.29           C  
ATOM   1579  O   LYS B  11       1.605   6.312  28.373  1.00 45.31           O  
ATOM   1580  CB  LYS B  11       2.857   4.733  30.280  1.00 46.99           C  
ATOM   1581  CG  LYS B  11       3.368   4.029  31.533  1.00 48.29           C  
ATOM   1582  CD  LYS B  11       4.760   3.460  31.313  1.00 49.49           C  
ATOM   1583  CE  LYS B  11       4.905   2.127  32.023  1.00 50.22           C  
ATOM   1584  NZ  LYS B  11       5.976   1.269  31.424  1.00 49.92           N  
ATOM   1585  N   ILE B  12      -0.227   5.016  28.352  1.00 41.92           N  
ATOM   1586  CA  ILE B  12      -0.670   5.564  27.074  1.00 40.45           C  
ATOM   1587  C   ILE B  12      -0.767   7.088  27.103  1.00 39.06           C  
ATOM   1588  O   ILE B  12      -0.493   7.760  26.107  1.00 38.38           O  
ATOM   1589  CB  ILE B  12      -2.034   4.981  26.654  1.00 40.97           C  
ATOM   1590  CG1 ILE B  12      -2.478   5.612  25.328  1.00 40.68           C  
ATOM   1591  CG2 ILE B  12      -3.054   5.199  27.760  1.00 39.26           C  
ATOM   1592  CD1 ILE B  12      -3.719   4.978  24.717  1.00 41.44           C  
ATOM   1593  N   LYS B  13      -1.151   7.624  28.255  1.00 37.61           N  
ATOM   1594  CA  LYS B  13      -1.294   9.060  28.435  1.00 36.96           C  
ATOM   1595  C   LYS B  13       0.012   9.762  28.058  1.00 37.19           C  
ATOM   1596  O   LYS B  13       0.019  10.916  27.616  1.00 36.61           O  
ATOM   1597  CB  LYS B  13      -1.660   9.355  29.892  1.00 35.59           C  
ATOM   1598  CG  LYS B  13      -2.226  10.739  30.100  1.00 36.28           C  
ATOM   1599  CD  LYS B  13      -3.627  10.864  29.518  1.00 36.64           C  
ATOM   1600  CE  LYS B  13      -4.167  12.279  29.674  1.00 36.64           C  
ATOM   1601  NZ  LYS B  13      -5.575  12.393  29.213  1.00 36.75           N  
ATOM   1602  N   LYS B  14       1.121   9.052  28.242  1.00 37.20           N  
ATOM   1603  CA  LYS B  14       2.425   9.590  27.908  1.00 37.88           C  
ATOM   1604  C   LYS B  14       2.468  10.022  26.450  1.00 37.93           C  
ATOM   1605  O   LYS B  14       3.039  11.062  26.125  1.00 38.93           O  
ATOM   1606  CB  LYS B  14       3.521   8.548  28.160  1.00 38.81           C  
ATOM   1607  CG  LYS B  14       4.432   8.882  29.344  1.00 40.21           C  
ATOM   1608  CD  LYS B  14       5.602   7.904  29.481  1.00 41.19           C  
ATOM   1609  CE  LYS B  14       6.557   7.969  28.279  1.00 40.26           C  
ATOM   1610  NZ  LYS B  14       7.591   6.883  28.314  1.00 40.97           N  
ATOM   1611  N   LEU B  15       1.851   9.221  25.581  1.00 37.14           N  
ATOM   1612  CA  LEU B  15       1.813   9.479  24.142  1.00 35.48           C  
ATOM   1613  C   LEU B  15       0.938  10.648  23.711  1.00 35.40           C  
ATOM   1614  O   LEU B  15       1.015  11.071  22.570  1.00 36.51           O  
ATOM   1615  CB  LEU B  15       1.355   8.215  23.409  1.00 33.70           C  
ATOM   1616  CG  LEU B  15       2.202   6.955  23.635  1.00 31.24           C  
ATOM   1617  CD1 LEU B  15       1.411   5.738  23.277  1.00 27.50           C  
ATOM   1618  CD2 LEU B  15       3.480   7.034  22.828  1.00 30.51           C  
ATOM   1619  N   ASP B  16       0.110  11.164  24.613  1.00 37.08           N  
ATOM   1620  CA  ASP B  16      -0.774  12.287  24.297  1.00 38.45           C  
ATOM   1621  C   ASP B  16      -0.232  13.573  24.929  1.00 38.92           C  
ATOM   1622  O   ASP B  16      -0.842  14.632  24.808  1.00 39.07           O  
ATOM   1623  CB  ASP B  16      -2.198  12.001  24.818  1.00 40.22           C  
ATOM   1624  CG  ASP B  16      -3.311  12.644  23.944  1.00 43.31           C  
ATOM   1625  OD1 ASP B  16      -4.504  12.371  24.222  1.00 43.19           O  
ATOM   1626  OD2 ASP B  16      -3.015  13.411  22.988  1.00 43.98           O  
ATOM   1627  N   ASP B  17       0.923  13.473  25.585  1.00 39.74           N  
ATOM   1628  CA  ASP B  17       1.558  14.613  26.257  1.00 41.04           C  
ATOM   1629  C   ASP B  17       1.948  15.751  25.316  1.00 40.79           C  
ATOM   1630  O   ASP B  17       2.874  15.610  24.515  1.00 40.96           O  
ATOM   1631  CB  ASP B  17       2.801  14.146  27.023  1.00 42.44           C  
ATOM   1632  CG  ASP B  17       3.413  15.252  27.876  1.00 43.81           C  
ATOM   1633  OD1 ASP B  17       4.295  14.928  28.701  1.00 44.43           O  
ATOM   1634  OD2 ASP B  17       3.025  16.436  27.717  1.00 44.40           O  
ATOM   1635  N   PRO B  18       1.271  16.911  25.431  1.00 40.81           N  
ATOM   1636  CA  PRO B  18       1.553  18.072  24.570  1.00 40.31           C  
ATOM   1637  C   PRO B  18       3.015  18.528  24.508  1.00 39.78           C  
ATOM   1638  O   PRO B  18       3.347  19.497  23.832  1.00 39.76           O  
ATOM   1639  CB  PRO B  18       0.598  19.145  25.106  1.00 39.82           C  
ATOM   1640  CG  PRO B  18       0.402  18.749  26.542  1.00 40.52           C  
ATOM   1641  CD  PRO B  18       0.296  17.251  26.484  1.00 39.52           C  
ATOM   1642  N   SER B  19       3.884  17.811  25.203  1.00 39.33           N  
ATOM   1643  CA  SER B  19       5.292  18.134  25.180  1.00 39.33           C  
ATOM   1644  C   SER B  19       5.911  17.526  23.915  1.00 39.96           C  
ATOM   1645  O   SER B  19       7.030  17.892  23.520  1.00 40.07           O  
ATOM   1646  CB  SER B  19       5.974  17.542  26.403  1.00 40.90           C  
ATOM   1647  OG  SER B  19       5.816  16.131  26.421  1.00 42.12           O  
ATOM   1648  N   ARG B  20       5.189  16.592  23.288  1.00 38.21           N  
ATOM   1649  CA  ARG B  20       5.680  15.937  22.076  1.00 36.77           C  
ATOM   1650  C   ARG B  20       5.916  16.968  20.975  1.00 36.37           C  
ATOM   1651  O   ARG B  20       6.781  16.781  20.117  1.00 35.37           O  
ATOM   1652  CB  ARG B  20       4.679  14.890  21.539  1.00 36.27           C  
ATOM   1653  CG  ARG B  20       4.002  13.958  22.550  1.00 36.25           C  
ATOM   1654  CD  ARG B  20       4.869  12.809  23.072  1.00 35.38           C  
ATOM   1655  NE  ARG B  20       5.348  11.893  22.036  1.00 36.24           N  
ATOM   1656  CZ  ARG B  20       4.577  11.153  21.237  1.00 35.80           C  
ATOM   1657  NH1 ARG B  20       3.255  11.199  21.333  1.00 35.46           N  
ATOM   1658  NH2 ARG B  20       5.140  10.363  20.326  1.00 34.57           N  
ATOM   1659  N   LEU B  21       5.131  18.046  20.998  1.00 36.52           N  
ATOM   1660  CA  LEU B  21       5.227  19.112  19.993  1.00 37.46           C  
ATOM   1661  C   LEU B  21       6.651  19.586  19.819  1.00 37.51           C  
ATOM   1662  O   LEU B  21       7.056  20.043  18.754  1.00 37.48           O  
ATOM   1663  CB  LEU B  21       4.356  20.304  20.400  1.00 38.17           C  
ATOM   1664  CG  LEU B  21       2.832  20.114  20.366  1.00 39.47           C  
ATOM   1665  CD1 LEU B  21       2.162  21.100  21.322  1.00 38.67           C  
ATOM   1666  CD2 LEU B  21       2.325  20.300  18.940  1.00 38.21           C  
ATOM   1667  N   GLU B  22       7.415  19.458  20.887  1.00 39.06           N  
ATOM   1668  CA  GLU B  22       8.789  19.898  20.900  1.00 40.15           C  
ATOM   1669  C   GLU B  22       9.736  19.018  20.099  1.00 39.81           C  
ATOM   1670  O   GLU B  22      10.847  19.436  19.783  1.00 39.33           O  
ATOM   1671  CB  GLU B  22       9.235  20.024  22.355  1.00 41.68           C  
ATOM   1672  CG  GLU B  22       8.203  20.766  23.201  1.00 44.78           C  
ATOM   1673  CD  GLU B  22       8.697  21.088  24.597  1.00 48.34           C  
ATOM   1674  OE1 GLU B  22       9.742  21.773  24.700  1.00 50.65           O  
ATOM   1675  OE2 GLU B  22       8.041  20.666  25.585  1.00 48.50           O  
ATOM   1676  N   LEU B  23       9.309  17.804  19.763  1.00 39.79           N  
ATOM   1677  CA  LEU B  23      10.164  16.924  18.977  1.00 39.09           C  
ATOM   1678  C   LEU B  23      10.295  17.511  17.581  1.00 39.15           C  
ATOM   1679  O   LEU B  23      11.380  17.542  17.010  1.00 40.24           O  
ATOM   1680  CB  LEU B  23       9.578  15.517  18.868  1.00 39.28           C  
ATOM   1681  CG  LEU B  23       9.628  14.485  20.002  1.00 38.41           C  
ATOM   1682  CD1 LEU B  23      11.049  14.397  20.557  1.00 38.53           C  
ATOM   1683  CD2 LEU B  23       8.643  14.841  21.079  1.00 38.86           C  
ATOM   1684  N   PHE B  24       9.176  17.986  17.043  1.00 38.97           N  
ATOM   1685  CA  PHE B  24       9.132  18.572  15.707  1.00 38.75           C  
ATOM   1686  C   PHE B  24       7.729  19.084  15.443  1.00 39.49           C  
ATOM   1687  O   PHE B  24       6.783  18.733  16.157  1.00 39.88           O  
ATOM   1688  CB  PHE B  24       9.488  17.517  14.651  1.00 38.25           C  
ATOM   1689  CG  PHE B  24       8.623  16.288  14.706  1.00 37.72           C  
ATOM   1690  CD1 PHE B  24       7.342  16.295  14.166  1.00 37.19           C  
ATOM   1691  CD2 PHE B  24       9.086  15.125  15.329  1.00 37.44           C  
ATOM   1692  CE1 PHE B  24       6.531  15.164  14.238  1.00 38.32           C  
ATOM   1693  CE2 PHE B  24       8.281  13.984  15.408  1.00 37.72           C  
ATOM   1694  CZ  PHE B  24       6.999  13.998  14.864  1.00 37.09           C  
ATOM   1695  N   ASP B  25       7.589  19.920  14.421  1.00 40.20           N  
ATOM   1696  CA  ASP B  25       6.276  20.447  14.078  1.00 40.87           C  
ATOM   1697  C   ASP B  25       5.640  19.501  13.047  1.00 39.86           C  
ATOM   1698  O   ASP B  25       6.077  19.434  11.897  1.00 39.57           O  
ATOM   1699  CB  ASP B  25       6.422  21.878  13.538  1.00 42.57           C  
ATOM   1700  CG  ASP B  25       5.128  22.428  12.971  1.00 43.07           C  
ATOM   1701  OD1 ASP B  25       4.056  22.224  13.590  1.00 43.32           O  
ATOM   1702  OD2 ASP B  25       5.193  23.072  11.898  1.00 43.53           O  
ATOM   1703  N   PRO B  26       4.601  18.750  13.464  1.00 39.61           N  
ATOM   1704  CA  PRO B  26       3.849  17.774  12.653  1.00 39.11           C  
ATOM   1705  C   PRO B  26       3.390  18.349  11.317  1.00 38.57           C  
ATOM   1706  O   PRO B  26       3.482  17.702  10.273  1.00 37.71           O  
ATOM   1707  CB  PRO B  26       2.660  17.417  13.542  1.00 39.49           C  
ATOM   1708  CG  PRO B  26       3.169  17.656  14.915  1.00 40.95           C  
ATOM   1709  CD  PRO B  26       3.964  18.927  14.779  1.00 40.51           C  
ATOM   1710  N   GLU B  27       2.871  19.568  11.375  1.00 38.02           N  
ATOM   1711  CA  GLU B  27       2.413  20.267  10.192  1.00 38.12           C  
ATOM   1712  C   GLU B  27       3.568  20.327   9.208  1.00 37.76           C  
ATOM   1713  O   GLU B  27       3.453  19.906   8.057  1.00 37.10           O  
ATOM   1714  CB  GLU B  27       2.019  21.683  10.571  1.00 41.15           C  
ATOM   1715  CG  GLU B  27       0.895  21.776  11.575  1.00 44.80           C  
ATOM   1716  CD  GLU B  27      -0.429  21.982  10.885  1.00 46.55           C  
ATOM   1717  OE1 GLU B  27      -0.518  22.922  10.056  1.00 46.31           O  
ATOM   1718  OE2 GLU B  27      -1.379  21.215  11.175  1.00 48.66           O  
ATOM   1719  N   LYS B  28       4.680  20.864   9.701  1.00 36.74           N  
ATOM   1720  CA  LYS B  28       5.908  21.044   8.946  1.00 36.62           C  
ATOM   1721  C   LYS B  28       6.351  19.759   8.273  1.00 36.37           C  
ATOM   1722  O   LYS B  28       6.417  19.657   7.043  1.00 35.99           O  
ATOM   1723  CB  LYS B  28       7.006  21.509   9.899  1.00 38.30           C  
ATOM   1724  CG  LYS B  28       8.163  22.250   9.247  1.00 40.74           C  
ATOM   1725  CD  LYS B  28       7.872  23.757   9.137  1.00 43.27           C  
ATOM   1726  CE  LYS B  28       9.158  24.556   8.872  1.00 43.27           C  
ATOM   1727  NZ  LYS B  28       8.930  26.028   8.730  1.00 43.04           N  
ATOM   1728  N   VAL B  29       6.654  18.778   9.109  1.00 36.05           N  
ATOM   1729  CA  VAL B  29       7.119  17.470   8.670  1.00 36.31           C  
ATOM   1730  C   VAL B  29       6.209  16.761   7.661  1.00 36.40           C  
ATOM   1731  O   VAL B  29       6.646  16.432   6.554  1.00 35.41           O  
ATOM   1732  CB  VAL B  29       7.315  16.577   9.888  1.00 37.39           C  
ATOM   1733  CG1 VAL B  29       7.980  15.275   9.489  1.00 36.79           C  
ATOM   1734  CG2 VAL B  29       8.150  17.321  10.916  1.00 38.44           C  
ATOM   1735  N   LEU B  30       4.953  16.524   8.051  1.00 36.46           N  
ATOM   1736  CA  LEU B  30       3.977  15.857   7.183  1.00 36.81           C  
ATOM   1737  C   LEU B  30       3.908  16.553   5.830  1.00 37.00           C  
ATOM   1738  O   LEU B  30       3.737  15.917   4.789  1.00 37.23           O  
ATOM   1739  CB  LEU B  30       2.593  15.864   7.842  1.00 36.82           C  
ATOM   1740  CG  LEU B  30       2.474  14.994   9.102  1.00 37.26           C  
ATOM   1741  CD1 LEU B  30       1.361  15.484  10.003  1.00 35.69           C  
ATOM   1742  CD2 LEU B  30       2.248  13.556   8.698  1.00 36.99           C  
ATOM   1743  N   LYS B  31       4.052  17.869   5.855  1.00 37.88           N  
ATOM   1744  CA  LYS B  31       4.017  18.669   4.642  1.00 38.81           C  
ATOM   1745  C   LYS B  31       5.278  18.375   3.838  1.00 38.40           C  
ATOM   1746  O   LYS B  31       5.190  18.102   2.647  1.00 37.33           O  
ATOM   1747  CB  LYS B  31       3.952  20.151   5.018  1.00 41.01           C  
ATOM   1748  CG  LYS B  31       2.979  20.996   4.204  1.00 43.59           C  
ATOM   1749  CD  LYS B  31       3.617  21.491   2.909  1.00 46.46           C  
ATOM   1750  CE  LYS B  31       2.816  22.652   2.292  1.00 47.43           C  
ATOM   1751  NZ  LYS B  31       3.421  23.185   1.024  1.00 47.42           N  
ATOM   1752  N   GLU B  32       6.444  18.404   4.489  1.00 38.27           N  
ATOM   1753  CA  GLU B  32       7.698  18.139   3.788  1.00 39.84           C  
ATOM   1754  C   GLU B  32       7.774  16.742   3.186  1.00 39.68           C  
ATOM   1755  O   GLU B  32       8.409  16.545   2.146  1.00 40.56           O  
ATOM   1756  CB  GLU B  32       8.922  18.316   4.702  1.00 42.63           C  
ATOM   1757  CG  GLU B  32      10.254  18.166   3.920  1.00 46.51           C  
ATOM   1758  CD  GLU B  32      11.441  17.610   4.737  1.00 49.32           C  
ATOM   1759  OE1 GLU B  32      11.853  18.242   5.739  1.00 49.56           O  
ATOM   1760  OE2 GLU B  32      11.975  16.531   4.356  1.00 50.69           O  
ATOM   1761  N   PHE B  33       7.144  15.769   3.838  1.00 38.96           N  
ATOM   1762  CA  PHE B  33       7.186  14.393   3.355  1.00 37.85           C  
ATOM   1763  C   PHE B  33       6.194  14.013   2.256  1.00 37.39           C  
ATOM   1764  O   PHE B  33       6.307  12.941   1.668  1.00 37.41           O  
ATOM   1765  CB  PHE B  33       7.068  13.434   4.538  1.00 38.18           C  
ATOM   1766  CG  PHE B  33       8.356  13.257   5.293  1.00 38.41           C  
ATOM   1767  CD1 PHE B  33       9.175  12.156   5.042  1.00 39.89           C  
ATOM   1768  CD2 PHE B  33       8.792  14.224   6.201  1.00 39.20           C  
ATOM   1769  CE1 PHE B  33      10.410  12.009   5.686  1.00 39.89           C  
ATOM   1770  CE2 PHE B  33      10.025  14.098   6.856  1.00 38.28           C  
ATOM   1771  CZ  PHE B  33      10.840  12.989   6.596  1.00 39.15           C  
ATOM   1772  N   GLY B  34       5.222  14.875   1.977  1.00 37.27           N  
ATOM   1773  CA  GLY B  34       4.282  14.571   0.909  1.00 35.82           C  
ATOM   1774  C   GLY B  34       2.792  14.453   1.192  1.00 34.64           C  
ATOM   1775  O   GLY B  34       2.004  14.351   0.256  1.00 34.91           O  
ATOM   1776  N   LEU B  35       2.379  14.463   2.450  1.00 32.60           N  
ATOM   1777  CA  LEU B  35       0.961  14.352   2.709  1.00 31.83           C  
ATOM   1778  C   LEU B  35       0.263  15.518   2.021  1.00 33.03           C  
ATOM   1779  O   LEU B  35       0.765  16.644   2.026  1.00 32.98           O  
ATOM   1780  CB  LEU B  35       0.686  14.371   4.208  1.00 30.71           C  
ATOM   1781  CG  LEU B  35      -0.779  14.102   4.578  1.00 30.53           C  
ATOM   1782  CD1 LEU B  35      -1.221  12.770   3.993  1.00 29.83           C  
ATOM   1783  CD2 LEU B  35      -0.946  14.114   6.086  1.00 30.14           C  
ATOM   1784  N   LYS B  36      -0.894  15.248   1.420  1.00 34.13           N  
ATOM   1785  CA  LYS B  36      -1.642  16.287   0.719  1.00 34.99           C  
ATOM   1786  C   LYS B  36      -3.133  16.019   0.755  1.00 35.81           C  
ATOM   1787  O   LYS B  36      -3.552  14.874   0.923  1.00 37.15           O  
ATOM   1788  CB  LYS B  36      -1.162  16.380  -0.730  1.00 35.08           C  
ATOM   1789  CG  LYS B  36       0.260  16.881  -0.839  1.00 35.07           C  
ATOM   1790  CD  LYS B  36       0.779  16.882  -2.258  1.00 35.27           C  
ATOM   1791  CE  LYS B  36       2.170  17.480  -2.321  1.00 35.76           C  
ATOM   1792  NZ  LYS B  36       2.761  17.307  -3.674  1.00 39.43           N  
ATOM   1793  N   GLU B  37      -3.933  17.073   0.599  1.00 36.38           N  
ATOM   1794  CA  GLU B  37      -5.394  16.941   0.623  1.00 36.95           C  
ATOM   1795  C   GLU B  37      -5.934  15.953  -0.394  1.00 34.95           C  
ATOM   1796  O   GLU B  37      -5.531  15.956  -1.555  1.00 35.43           O  
ATOM   1797  CB  GLU B  37      -6.085  18.285   0.386  1.00 39.73           C  
ATOM   1798  CG  GLU B  37      -7.591  18.113   0.184  1.00 44.31           C  
ATOM   1799  CD  GLU B  37      -8.341  19.421   0.063  1.00 47.27           C  
ATOM   1800  OE1 GLU B  37      -7.938  20.266  -0.780  1.00 49.89           O  
ATOM   1801  OE2 GLU B  37      -9.342  19.591   0.807  1.00 48.29           O  
ATOM   1802  N   GLY B  38      -6.869  15.127   0.050  1.00 33.49           N  
ATOM   1803  CA  GLY B  38      -7.443  14.128  -0.828  1.00 33.10           C  
ATOM   1804  C   GLY B  38      -6.831  12.772  -0.532  1.00 32.67           C  
ATOM   1805  O   GLY B  38      -7.531  11.765  -0.452  1.00 32.57           O  
ATOM   1806  N   MET B  39      -5.516  12.750  -0.352  1.00 31.28           N  
ATOM   1807  CA  MET B  39      -4.814  11.512  -0.068  1.00 30.24           C  
ATOM   1808  C   MET B  39      -5.453  10.703   1.041  1.00 30.21           C  
ATOM   1809  O   MET B  39      -6.127  11.229   1.929  1.00 30.79           O  
ATOM   1810  CB  MET B  39      -3.370  11.774   0.347  1.00 28.38           C  
ATOM   1811  CG  MET B  39      -2.472  12.329  -0.709  1.00 25.07           C  
ATOM   1812  SD  MET B  39      -0.796  12.222  -0.120  1.00 17.95           S  
ATOM   1813  CE  MET B  39       0.014  11.726  -1.559  1.00 18.29           C  
ATOM   1814  N   THR B  40      -5.214   9.405   0.974  1.00 29.24           N  
ATOM   1815  CA  THR B  40      -5.702   8.489   1.969  1.00 29.23           C  
ATOM   1816  C   THR B  40      -4.441   8.044   2.695  1.00 28.84           C  
ATOM   1817  O   THR B  40      -3.542   7.436   2.118  1.00 28.79           O  
ATOM   1818  CB  THR B  40      -6.435   7.313   1.312  1.00 29.54           C  
ATOM   1819  OG1 THR B  40      -7.686   7.787   0.796  1.00 30.33           O  
ATOM   1820  CG2 THR B  40      -6.700   6.193   2.322  1.00 30.12           C  
ATOM   1821  N   VAL B  41      -4.376   8.388   3.968  1.00 26.90           N  
ATOM   1822  CA  VAL B  41      -3.221   8.073   4.775  1.00 26.03           C  
ATOM   1823  C   VAL B  41      -3.505   7.037   5.848  1.00 26.35           C  
ATOM   1824  O   VAL B  41      -4.570   7.018   6.451  1.00 27.47           O  
ATOM   1825  CB  VAL B  41      -2.689   9.366   5.428  1.00 26.37           C  
ATOM   1826  CG1 VAL B  41      -3.857  10.169   6.005  1.00 25.26           C  
ATOM   1827  CG2 VAL B  41      -1.660   9.041   6.497  1.00 24.35           C  
ATOM   1828  N   LEU B  42      -2.539   6.159   6.063  1.00 25.72           N  
ATOM   1829  CA  LEU B  42      -2.632   5.132   7.082  1.00 25.55           C  
ATOM   1830  C   LEU B  42      -1.615   5.486   8.160  1.00 26.19           C  
ATOM   1831  O   LEU B  42      -0.435   5.672   7.876  1.00 25.49           O  
ATOM   1832  CB  LEU B  42      -2.292   3.759   6.502  1.00 24.11           C  
ATOM   1833  CG  LEU B  42      -2.013   2.648   7.514  1.00 22.67           C  
ATOM   1834  CD1 LEU B  42      -3.238   2.375   8.335  1.00 21.57           C  
ATOM   1835  CD2 LEU B  42      -1.588   1.396   6.790  1.00 22.55           C  
ATOM   1836  N   ASP B  43      -2.088   5.597   9.391  1.00 26.98           N  
ATOM   1837  CA  ASP B  43      -1.237   5.901  10.525  1.00 27.51           C  
ATOM   1838  C   ASP B  43      -1.028   4.592  11.277  1.00 27.11           C  
ATOM   1839  O   ASP B  43      -1.915   4.115  11.983  1.00 26.69           O  
ATOM   1840  CB  ASP B  43      -1.925   6.936  11.415  1.00 30.53           C  
ATOM   1841  CG  ASP B  43      -1.109   7.286  12.634  1.00 32.52           C  
ATOM   1842  OD1 ASP B  43       0.112   7.491  12.487  1.00 33.51           O  
ATOM   1843  OD2 ASP B  43      -1.694   7.365  13.737  1.00 36.58           O  
ATOM   1844  N   VAL B  44       0.152   4.015  11.119  1.00 27.79           N  
ATOM   1845  CA  VAL B  44       0.481   2.735  11.733  1.00 29.17           C  
ATOM   1846  C   VAL B  44       0.383   2.626  13.255  1.00 31.50           C  
ATOM   1847  O   VAL B  44      -0.522   1.976  13.779  1.00 34.64           O  
ATOM   1848  CB  VAL B  44       1.867   2.284  11.287  1.00 28.07           C  
ATOM   1849  CG1 VAL B  44       2.180   0.917  11.850  1.00 29.03           C  
ATOM   1850  CG2 VAL B  44       1.913   2.255   9.772  1.00 26.23           C  
ATOM   1851  N   GLY B  45       1.312   3.208  13.991  1.00 31.39           N  
ATOM   1852  CA  GLY B  45       1.182   3.096  15.432  1.00 31.55           C  
ATOM   1853  C   GLY B  45       0.438   4.324  15.907  1.00 30.44           C  
ATOM   1854  O   GLY B  45       1.046   5.252  16.446  1.00 31.94           O  
ATOM   1855  N   THR B  46      -0.870   4.343  15.692  1.00 28.32           N  
ATOM   1856  CA  THR B  46      -1.681   5.484  16.071  1.00 28.89           C  
ATOM   1857  C   THR B  46      -1.452   5.865  17.553  1.00 29.71           C  
ATOM   1858  O   THR B  46      -1.480   7.046  17.915  1.00 29.73           O  
ATOM   1859  CB  THR B  46      -3.184   5.186  15.758  1.00 28.93           C  
ATOM   1860  OG1 THR B  46      -3.901   6.413  15.612  1.00 28.82           O  
ATOM   1861  CG2 THR B  46      -3.824   4.345  16.860  1.00 28.15           C  
ATOM   1862  N   GLY B  47      -1.206   4.862  18.393  1.00 29.53           N  
ATOM   1863  CA  GLY B  47      -0.958   5.113  19.798  1.00 29.48           C  
ATOM   1864  C   GLY B  47      -2.124   5.786  20.482  1.00 30.57           C  
ATOM   1865  O   GLY B  47      -3.216   5.228  20.561  1.00 31.87           O  
ATOM   1866  N   ALA B  48      -1.902   6.992  20.988  1.00 30.86           N  
ATOM   1867  CA  ALA B  48      -2.957   7.725  21.663  1.00 30.55           C  
ATOM   1868  C   ALA B  48      -3.723   8.529  20.622  1.00 30.39           C  
ATOM   1869  O   ALA B  48      -4.705   9.200  20.936  1.00 28.58           O  
ATOM   1870  CB  ALA B  48      -2.352   8.645  22.705  1.00 29.05           C  
ATOM   1871  N   GLY B  49      -3.243   8.440  19.382  1.00 31.00           N  
ATOM   1872  CA  GLY B  49      -3.831   9.157  18.265  1.00 32.05           C  
ATOM   1873  C   GLY B  49      -3.363  10.602  18.205  1.00 33.06           C  
ATOM   1874  O   GLY B  49      -3.981  11.443  17.547  1.00 32.83           O  
ATOM   1875  N   PHE B  50      -2.258  10.884  18.890  1.00 34.51           N  
ATOM   1876  CA  PHE B  50      -1.691  12.232  18.966  1.00 35.28           C  
ATOM   1877  C   PHE B  50      -1.620  13.013  17.650  1.00 35.09           C  
ATOM   1878  O   PHE B  50      -2.018  14.176  17.601  1.00 35.81           O  
ATOM   1879  CB  PHE B  50      -0.290  12.177  19.574  1.00 36.72           C  
ATOM   1880  CG  PHE B  50       0.244  13.513  19.981  1.00 37.83           C  
ATOM   1881  CD1 PHE B  50      -0.253  14.163  21.114  1.00 39.32           C  
ATOM   1882  CD2 PHE B  50       1.249  14.119  19.247  1.00 38.23           C  
ATOM   1883  CE1 PHE B  50       0.245  15.404  21.512  1.00 39.37           C  
ATOM   1884  CE2 PHE B  50       1.757  15.361  19.634  1.00 39.64           C  
ATOM   1885  CZ  PHE B  50       1.254  16.004  20.770  1.00 39.41           C  
ATOM   1886  N   TYR B  51      -1.117  12.377  16.593  1.00 33.26           N  
ATOM   1887  CA  TYR B  51      -0.992  13.040  15.311  1.00 31.41           C  
ATOM   1888  C   TYR B  51      -2.214  12.973  14.408  1.00 30.74           C  
ATOM   1889  O   TYR B  51      -2.183  13.488  13.295  1.00 31.18           O  
ATOM   1890  CB  TYR B  51       0.221  12.490  14.570  1.00 32.05           C  
ATOM   1891  CG  TYR B  51       1.531  12.845  15.234  1.00 33.03           C  
ATOM   1892  CD1 TYR B  51       1.879  14.178  15.464  1.00 32.91           C  
ATOM   1893  CD2 TYR B  51       2.412  11.849  15.652  1.00 32.96           C  
ATOM   1894  CE1 TYR B  51       3.065  14.512  16.094  1.00 32.87           C  
ATOM   1895  CE2 TYR B  51       3.608  12.169  16.283  1.00 33.81           C  
ATOM   1896  CZ  TYR B  51       3.928  13.504  16.504  1.00 34.09           C  
ATOM   1897  OH  TYR B  51       5.107  13.812  17.142  1.00 33.81           O  
ATOM   1898  N   LEU B  52      -3.293  12.359  14.873  1.00 30.22           N  
ATOM   1899  CA  LEU B  52      -4.490  12.256  14.047  1.00 30.68           C  
ATOM   1900  C   LEU B  52      -5.058  13.621  13.627  1.00 32.32           C  
ATOM   1901  O   LEU B  52      -5.492  13.807  12.481  1.00 31.98           O  
ATOM   1902  CB  LEU B  52      -5.550  11.434  14.774  1.00 29.05           C  
ATOM   1903  CG  LEU B  52      -5.172   9.962  14.950  1.00 28.75           C  
ATOM   1904  CD1 LEU B  52      -6.132   9.248  15.881  1.00 26.80           C  
ATOM   1905  CD2 LEU B  52      -5.169   9.307  13.586  1.00 30.38           C  
ATOM   1906  N   PRO B  53      -5.067  14.600  14.542  1.00 32.62           N  
ATOM   1907  CA  PRO B  53      -5.601  15.899  14.146  1.00 32.71           C  
ATOM   1908  C   PRO B  53      -4.852  16.452  12.934  1.00 34.21           C  
ATOM   1909  O   PRO B  53      -5.454  16.811  11.914  1.00 35.86           O  
ATOM   1910  CB  PRO B  53      -5.373  16.759  15.387  1.00 31.31           C  
ATOM   1911  CG  PRO B  53      -5.416  15.788  16.498  1.00 31.09           C  
ATOM   1912  CD  PRO B  53      -4.642  14.618  15.954  1.00 32.50           C  
ATOM   1913  N   TYR B  54      -3.532  16.515  13.049  1.00 33.79           N  
ATOM   1914  CA  TYR B  54      -2.710  17.047  11.978  1.00 34.53           C  
ATOM   1915  C   TYR B  54      -2.961  16.329  10.659  1.00 34.29           C  
ATOM   1916  O   TYR B  54      -3.229  16.965   9.635  1.00 34.68           O  
ATOM   1917  CB  TYR B  54      -1.246  16.976  12.404  1.00 35.26           C  
ATOM   1918  CG  TYR B  54      -1.011  17.735  13.696  1.00 36.84           C  
ATOM   1919  CD1 TYR B  54      -1.096  19.135  13.731  1.00 36.04           C  
ATOM   1920  CD2 TYR B  54      -0.760  17.054  14.903  1.00 37.33           C  
ATOM   1921  CE1 TYR B  54      -0.941  19.840  14.934  1.00 37.01           C  
ATOM   1922  CE2 TYR B  54      -0.607  17.754  16.114  1.00 37.21           C  
ATOM   1923  CZ  TYR B  54      -0.700  19.148  16.117  1.00 37.18           C  
ATOM   1924  OH  TYR B  54      -0.560  19.852  17.298  1.00 36.13           O  
ATOM   1925  N   LEU B  55      -2.902  15.002  10.695  1.00 34.11           N  
ATOM   1926  CA  LEU B  55      -3.146  14.164   9.522  1.00 33.00           C  
ATOM   1927  C   LEU B  55      -4.545  14.425   8.950  1.00 32.17           C  
ATOM   1928  O   LEU B  55      -4.723  14.566   7.744  1.00 30.49           O  
ATOM   1929  CB  LEU B  55      -3.046  12.692   9.925  1.00 33.30           C  
ATOM   1930  CG  LEU B  55      -1.701  12.190  10.427  1.00 31.89           C  
ATOM   1931  CD1 LEU B  55      -1.880  10.868  11.148  1.00 32.07           C  
ATOM   1932  CD2 LEU B  55      -0.766  12.051   9.245  1.00 32.23           C  
ATOM   1933  N   SER B  56      -5.529  14.460   9.844  1.00 32.17           N  
ATOM   1934  CA  SER B  56      -6.922  14.705   9.493  1.00 32.48           C  
ATOM   1935  C   SER B  56      -7.117  16.061   8.815  1.00 32.89           C  
ATOM   1936  O   SER B  56      -7.809  16.172   7.806  1.00 32.81           O  
ATOM   1937  CB  SER B  56      -7.783  14.640  10.756  1.00 31.89           C  
ATOM   1938  OG  SER B  56      -9.057  15.207  10.536  1.00 31.62           O  
ATOM   1939  N   LYS B  57      -6.501  17.093   9.382  1.00 33.10           N  
ATOM   1940  CA  LYS B  57      -6.612  18.437   8.846  1.00 33.55           C  
ATOM   1941  C   LYS B  57      -5.989  18.564   7.459  1.00 33.21           C  
ATOM   1942  O   LYS B  57      -6.563  19.213   6.587  1.00 33.27           O  
ATOM   1943  CB  LYS B  57      -5.962  19.429   9.817  1.00 35.43           C  
ATOM   1944  CG  LYS B  57      -5.769  20.834   9.269  1.00 38.00           C  
ATOM   1945  CD  LYS B  57      -4.901  21.668  10.216  1.00 41.39           C  
ATOM   1946  CE  LYS B  57      -4.358  22.957   9.543  1.00 42.49           C  
ATOM   1947  NZ  LYS B  57      -3.308  23.676  10.366  1.00 39.64           N  
ATOM   1948  N   MET B  58      -4.827  17.944   7.249  1.00 32.90           N  
ATOM   1949  CA  MET B  58      -4.149  18.011   5.949  1.00 33.31           C  
ATOM   1950  C   MET B  58      -4.855  17.298   4.794  1.00 34.30           C  
ATOM   1951  O   MET B  58      -4.952  17.848   3.695  1.00 35.12           O  
ATOM   1952  CB  MET B  58      -2.707  17.491   6.047  1.00 31.78           C  
ATOM   1953  CG  MET B  58      -1.670  18.596   6.259  1.00 32.93           C  
ATOM   1954  SD  MET B  58       0.077  18.088   6.220  1.00 31.85           S  
ATOM   1955  CE  MET B  58       0.435  18.229   4.493  1.00 28.70           C  
ATOM   1956  N   VAL B  59      -5.349  16.085   5.018  1.00 34.59           N  
ATOM   1957  CA  VAL B  59      -6.027  15.370   3.941  1.00 35.53           C  
ATOM   1958  C   VAL B  59      -7.409  15.951   3.641  1.00 36.42           C  
ATOM   1959  O   VAL B  59      -8.101  15.487   2.734  1.00 35.79           O  
ATOM   1960  CB  VAL B  59      -6.175  13.891   4.275  1.00 34.22           C  
ATOM   1961  CG1 VAL B  59      -4.815  13.296   4.493  1.00 34.31           C  
ATOM   1962  CG2 VAL B  59      -7.027  13.725   5.501  1.00 33.44           C  
ATOM   1963  N   GLY B  60      -7.798  16.963   4.412  1.00 36.81           N  
ATOM   1964  CA  GLY B  60      -9.082  17.607   4.221  1.00 38.61           C  
ATOM   1965  C   GLY B  60     -10.263  16.696   4.492  1.00 40.42           C  
ATOM   1966  O   GLY B  60     -10.086  15.501   4.737  1.00 41.06           O  
ATOM   1967  N   GLU B  61     -11.473  17.251   4.456  1.00 41.05           N  
ATOM   1968  CA  GLU B  61     -12.655  16.437   4.694  1.00 41.72           C  
ATOM   1969  C   GLU B  61     -12.866  15.588   3.449  1.00 40.86           C  
ATOM   1970  O   GLU B  61     -13.682  14.671   3.437  1.00 38.76           O  
ATOM   1971  CB  GLU B  61     -13.875  17.320   4.935  1.00 44.07           C  
ATOM   1972  CG  GLU B  61     -14.235  18.221   3.770  1.00 48.18           C  
ATOM   1973  CD  GLU B  61     -15.596  18.892   3.963  1.00 51.42           C  
ATOM   1974  OE1 GLU B  61     -16.623  18.173   3.908  1.00 51.18           O  
ATOM   1975  OE2 GLU B  61     -15.634  20.134   4.172  1.00 52.28           O  
ATOM   1976  N   LYS B  62     -12.098  15.920   2.414  1.00 40.29           N  
ATOM   1977  CA  LYS B  62     -12.130  15.255   1.119  1.00 40.48           C  
ATOM   1978  C   LYS B  62     -11.128  14.115   1.044  1.00 39.90           C  
ATOM   1979  O   LYS B  62     -10.832  13.602  -0.046  1.00 38.96           O  
ATOM   1980  CB  LYS B  62     -11.803  16.266   0.023  1.00 42.41           C  
ATOM   1981  CG  LYS B  62     -12.969  16.596  -0.897  1.00 45.81           C  
ATOM   1982  CD  LYS B  62     -14.195  17.103  -0.124  1.00 46.64           C  
ATOM   1983  CE  LYS B  62     -15.288  17.453  -1.104  1.00 46.41           C  
ATOM   1984  NZ  LYS B  62     -14.735  18.329  -2.167  1.00 46.34           N  
ATOM   1985  N   GLY B  63     -10.593  13.739   2.203  1.00 37.96           N  
ATOM   1986  CA  GLY B  63      -9.618  12.668   2.266  1.00 35.17           C  
ATOM   1987  C   GLY B  63      -9.907  11.859   3.500  1.00 33.02           C  
ATOM   1988  O   GLY B  63     -10.761  12.235   4.284  1.00 32.59           O  
ATOM   1989  N   LYS B  64      -9.206  10.752   3.691  1.00 33.27           N  
ATOM   1990  CA  LYS B  64      -9.455   9.935   4.872  1.00 32.92           C  
ATOM   1991  C   LYS B  64      -8.169   9.527   5.559  1.00 31.92           C  
ATOM   1992  O   LYS B  64      -7.110   9.468   4.934  1.00 31.97           O  
ATOM   1993  CB  LYS B  64     -10.249   8.666   4.511  1.00 32.68           C  
ATOM   1994  CG  LYS B  64     -10.714   7.898   5.749  1.00 35.57           C  
ATOM   1995  CD  LYS B  64     -11.312   6.523   5.470  1.00 36.77           C  
ATOM   1996  CE  LYS B  64     -12.617   6.578   4.682  1.00 37.79           C  
ATOM   1997  NZ  LYS B  64     -12.379   6.824   3.225  1.00 39.31           N  
ATOM   1998  N   VAL B  65      -8.286   9.259   6.856  1.00 30.80           N  
ATOM   1999  CA  VAL B  65      -7.172   8.796   7.665  1.00 28.88           C  
ATOM   2000  C   VAL B  65      -7.567   7.475   8.329  1.00 27.64           C  
ATOM   2001  O   VAL B  65      -8.666   7.332   8.857  1.00 25.43           O  
ATOM   2002  CB  VAL B  65      -6.805   9.801   8.777  1.00 28.88           C  
ATOM   2003  CG1 VAL B  65      -5.549   9.338   9.487  1.00 28.31           C  
ATOM   2004  CG2 VAL B  65      -6.613  11.185   8.199  1.00 28.53           C  
ATOM   2005  N   TYR B  66      -6.667   6.503   8.263  1.00 28.06           N  
ATOM   2006  CA  TYR B  66      -6.875   5.203   8.891  1.00 26.90           C  
ATOM   2007  C   TYR B  66      -5.838   5.087   9.986  1.00 26.11           C  
ATOM   2008  O   TYR B  66      -4.645   5.052   9.708  1.00 25.49           O  
ATOM   2009  CB  TYR B  66      -6.646   4.059   7.910  1.00 27.18           C  
ATOM   2010  CG  TYR B  66      -7.769   3.846   6.952  1.00 29.07           C  
ATOM   2011  CD1 TYR B  66      -8.965   3.279   7.372  1.00 28.52           C  
ATOM   2012  CD2 TYR B  66      -7.643   4.217   5.619  1.00 30.46           C  
ATOM   2013  CE1 TYR B  66     -10.006   3.083   6.488  1.00 29.64           C  
ATOM   2014  CE2 TYR B  66      -8.681   4.025   4.725  1.00 30.09           C  
ATOM   2015  CZ  TYR B  66      -9.858   3.458   5.165  1.00 30.35           C  
ATOM   2016  OH  TYR B  66     -10.888   3.264   4.274  1.00 32.90           O  
ATOM   2017  N   ALA B  67      -6.303   5.046  11.223  1.00 25.27           N  
ATOM   2018  CA  ALA B  67      -5.429   4.917  12.366  1.00 25.43           C  
ATOM   2019  C   ALA B  67      -5.552   3.491  12.839  1.00 26.04           C  
ATOM   2020  O   ALA B  67      -6.600   3.107  13.350  1.00 27.78           O  
ATOM   2021  CB  ALA B  67      -5.876   5.860  13.464  1.00 26.08           C  
ATOM   2022  N   ILE B  68      -4.504   2.697  12.669  1.00 25.10           N  
ATOM   2023  CA  ILE B  68      -4.568   1.318  13.119  1.00 24.55           C  
ATOM   2024  C   ILE B  68      -3.677   1.164  14.329  1.00 25.83           C  
ATOM   2025  O   ILE B  68      -2.908   2.056  14.645  1.00 25.89           O  
ATOM   2026  CB  ILE B  68      -4.094   0.326  12.043  1.00 22.95           C  
ATOM   2027  CG1 ILE B  68      -2.635   0.604  11.703  1.00 24.12           C  
ATOM   2028  CG2 ILE B  68      -4.979   0.416  10.820  1.00 19.95           C  
ATOM   2029  CD1 ILE B  68      -1.953  -0.529  10.981  1.00 24.15           C  
ATOM   2030  N   ASP B  69      -3.800   0.032  15.011  1.00 27.57           N  
ATOM   2031  CA  ASP B  69      -2.993  -0.257  16.183  1.00 27.66           C  
ATOM   2032  C   ASP B  69      -3.355  -1.643  16.699  1.00 27.85           C  
ATOM   2033  O   ASP B  69      -4.529  -2.017  16.676  1.00 28.08           O  
ATOM   2034  CB  ASP B  69      -3.229   0.788  17.275  1.00 27.56           C  
ATOM   2035  CG  ASP B  69      -2.034   0.926  18.204  1.00 29.21           C  
ATOM   2036  OD1 ASP B  69      -1.615  -0.104  18.772  1.00 26.82           O  
ATOM   2037  OD2 ASP B  69      -1.514   2.056  18.352  1.00 29.52           O  
ATOM   2038  N   VAL B  70      -2.346  -2.394  17.153  1.00 26.66           N  
ATOM   2039  CA  VAL B  70      -2.539  -3.746  17.673  1.00 26.76           C  
ATOM   2040  C   VAL B  70      -2.967  -3.862  19.136  1.00 26.46           C  
ATOM   2041  O   VAL B  70      -3.235  -4.953  19.605  1.00 25.09           O  
ATOM   2042  CB  VAL B  70      -1.269  -4.626  17.484  1.00 26.90           C  
ATOM   2043  CG1 VAL B  70      -0.995  -4.819  16.027  1.00 28.27           C  
ATOM   2044  CG2 VAL B  70      -0.062  -3.986  18.163  1.00 28.90           C  
ATOM   2045  N   GLN B  71      -3.022  -2.756  19.866  1.00 26.93           N  
ATOM   2046  CA  GLN B  71      -3.443  -2.829  21.257  1.00 27.80           C  
ATOM   2047  C   GLN B  71      -4.790  -2.145  21.387  1.00 28.77           C  
ATOM   2048  O   GLN B  71      -4.932  -0.969  21.047  1.00 28.73           O  
ATOM   2049  CB  GLN B  71      -2.407  -2.179  22.190  1.00 28.10           C  
ATOM   2050  CG  GLN B  71      -1.016  -2.838  22.172  1.00 29.82           C  
ATOM   2051  CD  GLN B  71      -0.089  -2.309  23.264  1.00 32.26           C  
ATOM   2052  OE1 GLN B  71       0.137  -1.102  23.384  1.00 35.29           O  
ATOM   2053  NE2 GLN B  71       0.455  -3.214  24.062  1.00 31.02           N  
ATOM   2054  N   GLU B  72      -5.774  -2.904  21.874  1.00 29.75           N  
ATOM   2055  CA  GLU B  72      -7.151  -2.444  22.046  1.00 30.37           C  
ATOM   2056  C   GLU B  72      -7.322  -1.087  22.736  1.00 30.47           C  
ATOM   2057  O   GLU B  72      -8.033  -0.211  22.229  1.00 30.13           O  
ATOM   2058  CB  GLU B  72      -7.948  -3.519  22.788  1.00 32.60           C  
ATOM   2059  CG  GLU B  72      -9.428  -3.198  23.016  1.00 35.59           C  
ATOM   2060  CD  GLU B  72     -10.256  -4.440  23.371  1.00 38.31           C  
ATOM   2061  OE1 GLU B  72     -10.220  -5.417  22.583  1.00 39.51           O  
ATOM   2062  OE2 GLU B  72     -10.952  -4.447  24.419  1.00 38.63           O  
ATOM   2063  N   GLU B  73      -6.668  -0.912  23.882  1.00 29.02           N  
ATOM   2064  CA  GLU B  73      -6.761   0.335  24.633  1.00 28.15           C  
ATOM   2065  C   GLU B  73      -6.318   1.544  23.827  1.00 27.47           C  
ATOM   2066  O   GLU B  73      -6.807   2.663  24.037  1.00 25.41           O  
ATOM   2067  CB  GLU B  73      -5.936   0.242  25.917  1.00 29.14           C  
ATOM   2068  CG  GLU B  73      -4.634  -0.512  25.784  1.00 28.72           C  
ATOM   2069  CD  GLU B  73      -4.803  -2.014  25.929  1.00 29.66           C  
ATOM   2070  OE1 GLU B  73      -5.544  -2.432  26.843  1.00 28.76           O  
ATOM   2071  OE2 GLU B  73      -4.190  -2.777  25.149  1.00 29.49           O  
ATOM   2072  N   MET B  74      -5.382   1.318  22.911  1.00 26.63           N  
ATOM   2073  CA  MET B  74      -4.893   2.386  22.049  1.00 26.23           C  
ATOM   2074  C   MET B  74      -6.019   2.715  21.069  1.00 26.53           C  
ATOM   2075  O   MET B  74      -6.369   3.880  20.834  1.00 26.21           O  
ATOM   2076  CB  MET B  74      -3.650   1.924  21.292  1.00 24.92           C  
ATOM   2077  CG  MET B  74      -2.330   2.121  22.045  1.00 25.06           C  
ATOM   2078  SD  MET B  74      -2.173   1.228  23.596  1.00 23.16           S  
ATOM   2079  CE  MET B  74      -0.556   1.723  24.084  1.00 23.29           C  
ATOM   2080  N   VAL B  75      -6.610   1.664  20.523  1.00 25.04           N  
ATOM   2081  CA  VAL B  75      -7.700   1.817  19.586  1.00 24.06           C  
ATOM   2082  C   VAL B  75      -8.864   2.578  20.224  1.00 23.32           C  
ATOM   2083  O   VAL B  75      -9.354   3.561  19.663  1.00 20.41           O  
ATOM   2084  CB  VAL B  75      -8.185   0.442  19.099  1.00 23.92           C  
ATOM   2085  CG1 VAL B  75      -9.335   0.613  18.127  1.00 20.33           C  
ATOM   2086  CG2 VAL B  75      -7.026  -0.318  18.454  1.00 22.56           C  
ATOM   2087  N   ASN B  76      -9.296   2.124  21.399  1.00 23.29           N  
ATOM   2088  CA  ASN B  76     -10.404   2.761  22.112  1.00 24.10           C  
ATOM   2089  C   ASN B  76     -10.073   4.190  22.538  1.00 24.53           C  
ATOM   2090  O   ASN B  76     -10.911   5.083  22.441  1.00 24.21           O  
ATOM   2091  CB  ASN B  76     -10.797   1.945  23.350  1.00 23.21           C  
ATOM   2092  CG  ASN B  76     -11.403   0.595  23.005  1.00 24.11           C  
ATOM   2093  OD1 ASN B  76     -12.203   0.474  22.077  1.00 25.64           O  
ATOM   2094  ND2 ASN B  76     -11.043  -0.423  23.770  1.00 24.64           N  
ATOM   2095  N   TYR B  77      -8.850   4.408  23.011  1.00 26.01           N  
ATOM   2096  CA  TYR B  77      -8.438   5.732  23.437  1.00 27.05           C  
ATOM   2097  C   TYR B  77      -8.504   6.663  22.242  1.00 28.75           C  
ATOM   2098  O   TYR B  77      -9.226   7.667  22.254  1.00 29.10           O  
ATOM   2099  CB  TYR B  77      -7.010   5.696  23.978  1.00 27.64           C  
ATOM   2100  CG  TYR B  77      -6.535   7.011  24.548  1.00 28.51           C  
ATOM   2101  CD1 TYR B  77      -6.625   7.272  25.913  1.00 29.78           C  
ATOM   2102  CD2 TYR B  77      -6.001   7.998  23.720  1.00 28.38           C  
ATOM   2103  CE1 TYR B  77      -6.186   8.486  26.442  1.00 30.90           C  
ATOM   2104  CE2 TYR B  77      -5.564   9.210  24.233  1.00 29.51           C  
ATOM   2105  CZ  TYR B  77      -5.652   9.447  25.598  1.00 31.15           C  
ATOM   2106  OH  TYR B  77      -5.148  10.620  26.122  1.00 32.42           O  
ATOM   2107  N   ALA B  78      -7.738   6.318  21.210  1.00 29.51           N  
ATOM   2108  CA  ALA B  78      -7.686   7.107  19.984  1.00 30.59           C  
ATOM   2109  C   ALA B  78      -9.063   7.343  19.377  1.00 31.01           C  
ATOM   2110  O   ALA B  78      -9.303   8.378  18.762  1.00 30.64           O  
ATOM   2111  CB  ALA B  78      -6.784   6.417  18.958  1.00 32.23           C  
ATOM   2112  N   TRP B  79      -9.963   6.381  19.538  1.00 32.38           N  
ATOM   2113  CA  TRP B  79     -11.305   6.506  18.990  1.00 34.97           C  
ATOM   2114  C   TRP B  79     -12.067   7.593  19.736  1.00 36.21           C  
ATOM   2115  O   TRP B  79     -12.608   8.517  19.125  1.00 35.77           O  
ATOM   2116  CB  TRP B  79     -12.040   5.162  19.098  1.00 36.12           C  
ATOM   2117  CG  TRP B  79     -13.490   5.204  18.704  1.00 37.47           C  
ATOM   2118  CD1 TRP B  79     -14.549   4.769  19.447  1.00 38.35           C  
ATOM   2119  CD2 TRP B  79     -14.043   5.705  17.475  1.00 37.58           C  
ATOM   2120  NE1 TRP B  79     -15.724   4.971  18.759  1.00 38.67           N  
ATOM   2121  CE2 TRP B  79     -15.437   5.541  17.551  1.00 37.43           C  
ATOM   2122  CE3 TRP B  79     -13.492   6.272  16.328  1.00 37.54           C  
ATOM   2123  CZ2 TRP B  79     -16.285   5.929  16.513  1.00 38.14           C  
ATOM   2124  CZ3 TRP B  79     -14.339   6.655  15.300  1.00 36.62           C  
ATOM   2125  CH2 TRP B  79     -15.715   6.484  15.400  1.00 37.78           C  
ATOM   2126  N   GLU B  80     -12.105   7.480  21.059  1.00 37.33           N  
ATOM   2127  CA  GLU B  80     -12.801   8.461  21.872  1.00 38.79           C  
ATOM   2128  C   GLU B  80     -12.119   9.780  21.616  1.00 38.33           C  
ATOM   2129  O   GLU B  80     -12.733  10.841  21.660  1.00 38.03           O  
ATOM   2130  CB  GLU B  80     -12.685   8.102  23.355  1.00 42.39           C  
ATOM   2131  CG  GLU B  80     -13.636   8.884  24.262  1.00 47.14           C  
ATOM   2132  CD  GLU B  80     -12.934   9.977  25.053  1.00 49.67           C  
ATOM   2133  OE1 GLU B  80     -12.261  10.832  24.430  1.00 50.50           O  
ATOM   2134  OE2 GLU B  80     -13.056   9.976  26.304  1.00 52.24           O  
ATOM   2135  N   LYS B  81     -10.829   9.698  21.329  1.00 38.84           N  
ATOM   2136  CA  LYS B  81     -10.065  10.891  21.073  1.00 39.24           C  
ATOM   2137  C   LYS B  81     -10.568  11.555  19.803  1.00 38.97           C  
ATOM   2138  O   LYS B  81     -11.009  12.702  19.839  1.00 39.47           O  
ATOM   2139  CB  LYS B  81      -8.574  10.561  20.966  1.00 39.99           C  
ATOM   2140  CG  LYS B  81      -7.706  11.799  21.113  1.00 40.94           C  
ATOM   2141  CD  LYS B  81      -6.544  11.786  20.155  1.00 42.52           C  
ATOM   2142  CE  LYS B  81      -5.823  13.120  20.177  1.00 43.28           C  
ATOM   2143  NZ  LYS B  81      -4.757  13.186  19.137  1.00 45.52           N  
ATOM   2144  N   VAL B  82     -10.516  10.844  18.680  1.00 38.96           N  
ATOM   2145  CA  VAL B  82     -10.994  11.434  17.431  1.00 40.40           C  
ATOM   2146  C   VAL B  82     -12.429  11.921  17.620  1.00 40.13           C  
ATOM   2147  O   VAL B  82     -12.791  13.000  17.163  1.00 40.66           O  
ATOM   2148  CB  VAL B  82     -10.942  10.425  16.239  1.00 41.12           C  
ATOM   2149  CG1 VAL B  82      -9.492  10.145  15.836  1.00 39.74           C  
ATOM   2150  CG2 VAL B  82     -11.641   9.140  16.610  1.00 41.89           C  
ATOM   2151  N   ASN B  83     -13.238  11.121  18.300  1.00 40.34           N  
ATOM   2152  CA  ASN B  83     -14.617  11.485  18.572  1.00 40.82           C  
ATOM   2153  C   ASN B  83     -14.636  12.812  19.308  1.00 41.39           C  
ATOM   2154  O   ASN B  83     -15.152  13.817  18.816  1.00 42.24           O  
ATOM   2155  CB  ASN B  83     -15.270  10.421  19.447  1.00 41.59           C  
ATOM   2156  CG  ASN B  83     -16.303   9.593  18.696  1.00 42.98           C  
ATOM   2157  OD1 ASN B  83     -16.781   8.578  19.203  1.00 44.14           O  
ATOM   2158  ND2 ASN B  83     -16.664  10.032  17.493  1.00 42.93           N  
ATOM   2159  N   LYS B  84     -14.039  12.807  20.489  1.00 41.61           N  
ATOM   2160  CA  LYS B  84     -13.978  13.980  21.348  1.00 42.06           C  
ATOM   2161  C   LYS B  84     -13.490  15.255  20.652  1.00 42.19           C  
ATOM   2162  O   LYS B  84     -13.549  16.343  21.237  1.00 41.82           O  
ATOM   2163  CB  LYS B  84     -13.092  13.647  22.550  1.00 42.22           C  
ATOM   2164  CG  LYS B  84     -13.082  14.674  23.640  1.00 44.13           C  
ATOM   2165  CD  LYS B  84     -12.603  14.061  24.961  1.00 46.13           C  
ATOM   2166  CE  LYS B  84     -13.666  13.111  25.556  1.00 47.36           C  
ATOM   2167  NZ  LYS B  84     -13.334  12.572  26.926  1.00 46.57           N  
ATOM   2168  N   LEU B  85     -13.028  15.130  19.408  1.00 41.90           N  
ATOM   2169  CA  LEU B  85     -12.524  16.287  18.662  1.00 41.52           C  
ATOM   2170  C   LEU B  85     -13.354  16.633  17.435  1.00 41.04           C  
ATOM   2171  O   LEU B  85     -13.075  17.624  16.754  1.00 41.43           O  
ATOM   2172  CB  LEU B  85     -11.093  16.038  18.195  1.00 41.61           C  
ATOM   2173  CG  LEU B  85     -10.069  15.589  19.229  1.00 42.11           C  
ATOM   2174  CD1 LEU B  85      -8.759  15.270  18.516  1.00 42.27           C  
ATOM   2175  CD2 LEU B  85      -9.877  16.682  20.279  1.00 41.03           C  
ATOM   2176  N   GLY B  86     -14.344  15.806  17.126  1.00 39.56           N  
ATOM   2177  CA  GLY B  86     -15.166  16.082  15.965  1.00 37.72           C  
ATOM   2178  C   GLY B  86     -14.487  15.768  14.648  1.00 36.90           C  
ATOM   2179  O   GLY B  86     -14.920  16.242  13.601  1.00 36.73           O  
ATOM   2180  N   LEU B  87     -13.419  14.976  14.693  1.00 36.40           N  
ATOM   2181  CA  LEU B  87     -12.714  14.589  13.471  1.00 36.39           C  
ATOM   2182  C   LEU B  87     -13.612  13.643  12.659  1.00 36.20           C  
ATOM   2183  O   LEU B  87     -13.924  12.544  13.097  1.00 37.55           O  
ATOM   2184  CB  LEU B  87     -11.394  13.886  13.815  1.00 37.34           C  
ATOM   2185  CG  LEU B  87     -10.234  14.700  14.409  1.00 36.44           C  
ATOM   2186  CD1 LEU B  87      -9.136  13.758  14.831  1.00 35.81           C  
ATOM   2187  CD2 LEU B  87      -9.707  15.710  13.402  1.00 35.73           C  
ATOM   2188  N   LYS B  88     -14.020  14.064  11.472  1.00 35.09           N  
ATOM   2189  CA  LYS B  88     -14.904  13.243  10.658  1.00 34.09           C  
ATOM   2190  C   LYS B  88     -14.205  12.254   9.732  1.00 32.07           C  
ATOM   2191  O   LYS B  88     -14.581  11.086   9.665  1.00 32.48           O  
ATOM   2192  CB  LYS B  88     -15.827  14.143   9.830  1.00 35.89           C  
ATOM   2193  CG  LYS B  88     -16.711  15.050  10.662  1.00 38.06           C  
ATOM   2194  CD  LYS B  88     -17.851  14.280  11.291  1.00 42.20           C  
ATOM   2195  CE  LYS B  88     -18.896  13.863  10.241  1.00 44.46           C  
ATOM   2196  NZ  LYS B  88     -20.075  13.108  10.819  1.00 45.38           N  
ATOM   2197  N   ASN B  89     -13.194  12.725   9.017  1.00 29.23           N  
ATOM   2198  CA  ASN B  89     -12.462  11.889   8.070  1.00 27.44           C  
ATOM   2199  C   ASN B  89     -11.540  10.827   8.667  1.00 26.42           C  
ATOM   2200  O   ASN B  89     -10.745  10.225   7.944  1.00 25.97           O  
ATOM   2201  CB  ASN B  89     -11.639  12.768   7.125  1.00 26.83           C  
ATOM   2202  CG  ASN B  89     -10.517  13.510   7.839  1.00 26.49           C  
ATOM   2203  OD1 ASN B  89      -9.616  14.040   7.196  1.00 26.19           O  
ATOM   2204  ND2 ASN B  89     -10.573  13.555   9.167  1.00 24.13           N  
ATOM   2205  N   VAL B  90     -11.649  10.579   9.966  1.00 25.68           N  
ATOM   2206  CA  VAL B  90     -10.781   9.589  10.581  1.00 24.88           C  
ATOM   2207  C   VAL B  90     -11.495   8.301  10.958  1.00 24.63           C  
ATOM   2208  O   VAL B  90     -12.563   8.312  11.570  1.00 24.13           O  
ATOM   2209  CB  VAL B  90     -10.077  10.150  11.834  1.00 24.45           C  
ATOM   2210  CG1 VAL B  90      -9.051   9.146  12.329  1.00 22.47           C  
ATOM   2211  CG2 VAL B  90      -9.424  11.492  11.521  1.00 25.69           C  
ATOM   2212  N   GLU B  91     -10.869   7.191  10.584  1.00 24.48           N  
ATOM   2213  CA  GLU B  91     -11.393   5.859  10.847  1.00 23.86           C  
ATOM   2214  C   GLU B  91     -10.382   5.079  11.706  1.00 23.37           C  
ATOM   2215  O   GLU B  91      -9.289   4.763  11.241  1.00 21.55           O  
ATOM   2216  CB  GLU B  91     -11.609   5.152   9.515  1.00 25.50           C  
ATOM   2217  CG  GLU B  91     -12.512   3.957   9.571  1.00 27.02           C  
ATOM   2218  CD  GLU B  91     -13.961   4.329   9.764  1.00 28.30           C  
ATOM   2219  OE1 GLU B  91     -14.498   5.059   8.909  1.00 30.24           O  
ATOM   2220  OE2 GLU B  91     -14.564   3.891  10.764  1.00 27.19           O  
ATOM   2221  N   VAL B  92     -10.748   4.778  12.955  1.00 22.89           N  
ATOM   2222  CA  VAL B  92      -9.855   4.053  13.862  1.00 22.31           C  
ATOM   2223  C   VAL B  92     -10.109   2.548  13.873  1.00 22.24           C  
ATOM   2224  O   VAL B  92     -11.208   2.099  14.196  1.00 21.58           O  
ATOM   2225  CB  VAL B  92      -9.975   4.570  15.329  1.00 22.93           C  
ATOM   2226  CG1 VAL B  92      -8.822   4.025  16.160  1.00 20.78           C  
ATOM   2227  CG2 VAL B  92      -9.992   6.090  15.368  1.00 21.78           C  
ATOM   2228  N   LEU B  93      -9.070   1.781  13.540  1.00 22.52           N  
ATOM   2229  CA  LEU B  93      -9.156   0.320  13.485  1.00 21.40           C  
ATOM   2230  C   LEU B  93      -8.164  -0.481  14.357  1.00 22.70           C  
ATOM   2231  O   LEU B  93      -7.075  -0.019  14.721  1.00 21.53           O  
ATOM   2232  CB  LEU B  93      -9.007  -0.154  12.037  1.00 18.58           C  
ATOM   2233  CG  LEU B  93      -9.919   0.427  10.966  1.00 16.38           C  
ATOM   2234  CD1 LEU B  93      -9.552  -0.212   9.644  1.00 15.43           C  
ATOM   2235  CD2 LEU B  93     -11.365   0.180  11.309  1.00 11.38           C  
ATOM   2236  N   LYS B  94      -8.562  -1.711  14.651  1.00 22.19           N  
ATOM   2237  CA  LYS B  94      -7.775  -2.624  15.456  1.00 23.99           C  
ATOM   2238  C   LYS B  94      -7.127  -3.668  14.553  1.00 25.10           C  
ATOM   2239  O   LYS B  94      -7.801  -4.558  14.053  1.00 27.83           O  
ATOM   2240  CB  LYS B  94      -8.688  -3.295  16.488  1.00 23.25           C  
ATOM   2241  CG  LYS B  94      -8.136  -4.558  17.121  1.00 24.97           C  
ATOM   2242  CD  LYS B  94      -6.807  -4.315  17.824  1.00 28.20           C  
ATOM   2243  CE  LYS B  94      -6.379  -5.529  18.643  1.00 28.58           C  
ATOM   2244  NZ  LYS B  94      -5.993  -6.689  17.812  1.00 28.46           N  
ATOM   2245  N   SER B  95      -5.817  -3.566  14.352  1.00 24.74           N  
ATOM   2246  CA  SER B  95      -5.117  -4.516  13.497  1.00 23.69           C  
ATOM   2247  C   SER B  95      -4.318  -5.577  14.239  1.00 24.46           C  
ATOM   2248  O   SER B  95      -4.328  -5.643  15.461  1.00 23.50           O  
ATOM   2249  CB  SER B  95      -4.196  -3.764  12.546  1.00 23.30           C  
ATOM   2250  OG  SER B  95      -3.526  -2.719  13.209  1.00 21.93           O  
ATOM   2251  N   GLU B  96      -3.647  -6.423  13.471  1.00 25.73           N  
ATOM   2252  CA  GLU B  96      -2.808  -7.467  14.022  1.00 28.10           C  
ATOM   2253  C   GLU B  96      -1.396  -7.196  13.536  1.00 28.46           C  
ATOM   2254  O   GLU B  96      -1.209  -6.559  12.506  1.00 28.53           O  
ATOM   2255  CB  GLU B  96      -3.260  -8.841  13.555  1.00 31.33           C  
ATOM   2256  CG  GLU B  96      -3.780  -9.716  14.683  1.00 34.83           C  
ATOM   2257  CD  GLU B  96      -5.273  -9.579  14.886  1.00 36.83           C  
ATOM   2258  OE1 GLU B  96      -6.045 -10.168  14.093  1.00 37.82           O  
ATOM   2259  OE2 GLU B  96      -5.676  -8.870  15.832  1.00 39.55           O  
ATOM   2260  N   GLU B  97      -0.406  -7.688  14.271  1.00 29.04           N  
ATOM   2261  CA  GLU B  97       0.997  -7.455  13.945  1.00 28.85           C  
ATOM   2262  C   GLU B  97       1.325  -7.320  12.460  1.00 28.29           C  
ATOM   2263  O   GLU B  97       1.728  -6.251  12.014  1.00 28.03           O  
ATOM   2264  CB  GLU B  97       1.866  -8.544  14.593  1.00 30.09           C  
ATOM   2265  CG  GLU B  97       3.387  -8.315  14.493  1.00 32.79           C  
ATOM   2266  CD  GLU B  97       3.844  -6.967  15.053  1.00 34.21           C  
ATOM   2267  OE1 GLU B  97       3.525  -6.661  16.223  1.00 34.06           O  
ATOM   2268  OE2 GLU B  97       4.536  -6.216  14.328  1.00 35.22           O  
ATOM   2269  N   ASN B  98       1.158  -8.391  11.696  1.00 27.36           N  
ATOM   2270  CA  ASN B  98       1.474  -8.330  10.282  1.00 27.23           C  
ATOM   2271  C   ASN B  98       0.230  -8.391   9.400  1.00 28.28           C  
ATOM   2272  O   ASN B  98       0.263  -8.906   8.281  1.00 28.18           O  
ATOM   2273  CB  ASN B  98       2.405  -9.470   9.918  1.00 28.92           C  
ATOM   2274  CG  ASN B  98       3.637  -9.520  10.785  1.00 29.21           C  
ATOM   2275  OD1 ASN B  98       4.104 -10.601  11.137  1.00 29.28           O  
ATOM   2276  ND2 ASN B  98       4.181  -8.357  11.120  1.00 29.31           N  
ATOM   2277  N   LYS B  99      -0.868  -7.857   9.909  1.00 27.85           N  
ATOM   2278  CA  LYS B  99      -2.110  -7.854   9.159  1.00 28.06           C  
ATOM   2279  C   LYS B  99      -2.882  -6.546   9.299  1.00 26.23           C  
ATOM   2280  O   LYS B  99      -3.329  -6.192  10.386  1.00 24.72           O  
ATOM   2281  CB  LYS B  99      -2.980  -9.037   9.600  1.00 30.62           C  
ATOM   2282  CG  LYS B  99      -2.461 -10.368   9.110  1.00 32.17           C  
ATOM   2283  CD  LYS B  99      -3.186 -11.530   9.748  1.00 34.40           C  
ATOM   2284  CE  LYS B  99      -2.583 -12.835   9.249  1.00 35.64           C  
ATOM   2285  NZ  LYS B  99      -2.920 -13.997  10.112  1.00 37.49           N  
ATOM   2286  N   ILE B 100      -3.025  -5.833   8.188  1.00 24.03           N  
ATOM   2287  CA  ILE B 100      -3.761  -4.574   8.170  1.00 23.45           C  
ATOM   2288  C   ILE B 100      -5.161  -4.903   7.657  1.00 22.04           C  
ATOM   2289  O   ILE B 100      -5.312  -5.482   6.588  1.00 22.93           O  
ATOM   2290  CB  ILE B 100      -3.055  -3.536   7.266  1.00 22.90           C  
ATOM   2291  CG1 ILE B 100      -1.679  -3.234   7.856  1.00 20.03           C  
ATOM   2292  CG2 ILE B 100      -3.888  -2.254   7.168  1.00 21.57           C  
ATOM   2293  CD1 ILE B 100      -0.640  -2.878   6.841  1.00 22.29           C  
ATOM   2294  N   PRO B 101      -6.204  -4.542   8.427  1.00 20.66           N  
ATOM   2295  CA  PRO B 101      -7.604  -4.803   8.084  1.00 20.36           C  
ATOM   2296  C   PRO B 101      -8.197  -4.086   6.877  1.00 20.89           C  
ATOM   2297  O   PRO B 101      -9.410  -3.965   6.755  1.00 22.55           O  
ATOM   2298  CB  PRO B 101      -8.331  -4.469   9.381  1.00 19.95           C  
ATOM   2299  CG  PRO B 101      -7.532  -3.359   9.916  1.00 18.52           C  
ATOM   2300  CD  PRO B 101      -6.112  -3.791   9.690  1.00 17.71           C  
ATOM   2301  N   LEU B 102      -7.344  -3.620   5.979  1.00 20.83           N  
ATOM   2302  CA  LEU B 102      -7.815  -2.920   4.804  1.00 21.33           C  
ATOM   2303  C   LEU B 102      -7.651  -3.753   3.530  1.00 22.93           C  
ATOM   2304  O   LEU B 102      -6.946  -4.756   3.523  1.00 22.79           O  
ATOM   2305  CB  LEU B 102      -7.071  -1.588   4.667  1.00 20.17           C  
ATOM   2306  CG  LEU B 102      -7.761  -0.343   5.241  1.00 20.61           C  
ATOM   2307  CD1 LEU B 102      -8.011  -0.500   6.720  1.00 21.96           C  
ATOM   2308  CD2 LEU B 102      -6.901   0.859   4.990  1.00 20.37           C  
ATOM   2309  N   PRO B 103      -8.360  -3.376   2.450  1.00 23.43           N  
ATOM   2310  CA  PRO B 103      -8.220  -4.135   1.206  1.00 23.81           C  
ATOM   2311  C   PRO B 103      -6.986  -3.639   0.440  1.00 23.13           C  
ATOM   2312  O   PRO B 103      -6.361  -2.662   0.830  1.00 23.08           O  
ATOM   2313  CB  PRO B 103      -9.530  -3.847   0.476  1.00 23.68           C  
ATOM   2314  CG  PRO B 103      -9.866  -2.470   0.926  1.00 23.71           C  
ATOM   2315  CD  PRO B 103      -9.545  -2.498   2.400  1.00 22.63           C  
ATOM   2316  N   ASP B 104      -6.638  -4.319  -0.643  1.00 22.80           N  
ATOM   2317  CA  ASP B 104      -5.479  -3.944  -1.442  1.00 22.87           C  
ATOM   2318  C   ASP B 104      -5.604  -2.586  -2.119  1.00 22.12           C  
ATOM   2319  O   ASP B 104      -6.695  -2.110  -2.400  1.00 21.50           O  
ATOM   2320  CB  ASP B 104      -5.215  -4.996  -2.532  1.00 25.72           C  
ATOM   2321  CG  ASP B 104      -5.131  -6.407  -1.982  1.00 27.84           C  
ATOM   2322  OD1 ASP B 104      -4.689  -7.316  -2.712  1.00 28.25           O  
ATOM   2323  OD2 ASP B 104      -5.512  -6.613  -0.817  1.00 29.99           O  
ATOM   2324  N   ASN B 105      -4.465  -1.966  -2.377  1.00 22.05           N  
ATOM   2325  CA  ASN B 105      -4.429  -0.697  -3.087  1.00 22.89           C  
ATOM   2326  C   ASN B 105      -5.331   0.387  -2.537  1.00 22.88           C  
ATOM   2327  O   ASN B 105      -5.932   1.136  -3.291  1.00 23.22           O  
ATOM   2328  CB  ASN B 105      -4.790  -0.955  -4.546  1.00 21.86           C  
ATOM   2329  CG  ASN B 105      -3.933  -2.023  -5.165  1.00 21.13           C  
ATOM   2330  OD1 ASN B 105      -2.897  -1.735  -5.757  1.00 22.17           O  
ATOM   2331  ND2 ASN B 105      -4.350  -3.272  -5.016  1.00 19.76           N  
ATOM   2332  N   THR B 106      -5.415   0.499  -1.224  1.00 23.41           N  
ATOM   2333  CA  THR B 106      -6.279   1.514  -0.653  1.00 23.83           C  
ATOM   2334  C   THR B 106      -5.605   2.742  -0.052  1.00 23.81           C  
ATOM   2335  O   THR B 106      -6.264   3.749   0.140  1.00 24.97           O  
ATOM   2336  CB  THR B 106      -7.210   0.892   0.407  1.00 25.24           C  
ATOM   2337  OG1 THR B 106      -6.447   0.041   1.274  1.00 25.65           O  
ATOM   2338  CG2 THR B 106      -8.317   0.088  -0.263  1.00 23.15           C  
ATOM   2339  N   VAL B 107      -4.308   2.679   0.234  1.00 23.82           N  
ATOM   2340  CA  VAL B 107      -3.635   3.833   0.841  1.00 24.87           C  
ATOM   2341  C   VAL B 107      -2.642   4.573  -0.035  1.00 24.53           C  
ATOM   2342  O   VAL B 107      -1.969   3.994  -0.885  1.00 23.13           O  
ATOM   2343  CB  VAL B 107      -2.919   3.452   2.172  1.00 26.22           C  
ATOM   2344  CG1 VAL B 107      -3.901   2.797   3.131  1.00 26.48           C  
ATOM   2345  CG2 VAL B 107      -1.752   2.525   1.894  1.00 28.95           C  
ATOM   2346  N   ASP B 108      -2.551   5.872   0.203  1.00 25.09           N  
ATOM   2347  CA  ASP B 108      -1.661   6.740  -0.556  1.00 25.38           C  
ATOM   2348  C   ASP B 108      -0.418   7.112   0.233  1.00 25.04           C  
ATOM   2349  O   ASP B 108       0.680   7.157  -0.307  1.00 23.70           O  
ATOM   2350  CB  ASP B 108      -2.391   8.032  -0.942  1.00 26.96           C  
ATOM   2351  CG  ASP B 108      -3.613   7.782  -1.784  1.00 28.51           C  
ATOM   2352  OD1 ASP B 108      -3.453   7.480  -2.984  1.00 30.45           O  
ATOM   2353  OD2 ASP B 108      -4.738   7.886  -1.248  1.00 30.09           O  
ATOM   2354  N   PHE B 109      -0.615   7.377   1.518  1.00 25.41           N  
ATOM   2355  CA  PHE B 109       0.463   7.800   2.391  1.00 26.17           C  
ATOM   2356  C   PHE B 109       0.529   6.979   3.688  1.00 26.02           C  
ATOM   2357  O   PHE B 109      -0.456   6.897   4.417  1.00 25.82           O  
ATOM   2358  CB  PHE B 109       0.248   9.276   2.734  1.00 27.55           C  
ATOM   2359  CG  PHE B 109       1.449   9.955   3.307  1.00 29.23           C  
ATOM   2360  CD1 PHE B 109       2.440  10.465   2.473  1.00 29.41           C  
ATOM   2361  CD2 PHE B 109       1.582  10.117   4.688  1.00 30.54           C  
ATOM   2362  CE1 PHE B 109       3.544  11.136   3.001  1.00 30.16           C  
ATOM   2363  CE2 PHE B 109       2.683  10.786   5.227  1.00 30.22           C  
ATOM   2364  CZ  PHE B 109       3.665  11.296   4.380  1.00 29.45           C  
ATOM   2365  N   ILE B 110       1.681   6.370   3.961  1.00 24.04           N  
ATOM   2366  CA  ILE B 110       1.861   5.607   5.190  1.00 22.36           C  
ATOM   2367  C   ILE B 110       2.724   6.446   6.133  1.00 21.31           C  
ATOM   2368  O   ILE B 110       3.767   6.952   5.744  1.00 18.15           O  
ATOM   2369  CB  ILE B 110       2.588   4.276   4.955  1.00 23.52           C  
ATOM   2370  CG1 ILE B 110       1.919   3.484   3.835  1.00 23.91           C  
ATOM   2371  CG2 ILE B 110       2.571   3.462   6.234  1.00 21.93           C  
ATOM   2372  CD1 ILE B 110       2.714   2.246   3.408  1.00 22.63           C  
ATOM   2373  N   PHE B 111       2.276   6.582   7.373  1.00 21.35           N  
ATOM   2374  CA  PHE B 111       2.983   7.371   8.370  1.00 22.25           C  
ATOM   2375  C   PHE B 111       3.364   6.507   9.574  1.00 22.70           C  
ATOM   2376  O   PHE B 111       2.515   6.115  10.354  1.00 22.22           O  
ATOM   2377  CB  PHE B 111       2.083   8.528   8.811  1.00 21.98           C  
ATOM   2378  CG  PHE B 111       2.687   9.421   9.855  1.00 24.29           C  
ATOM   2379  CD1 PHE B 111       3.645  10.370   9.515  1.00 24.72           C  
ATOM   2380  CD2 PHE B 111       2.253   9.351  11.183  1.00 25.30           C  
ATOM   2381  CE1 PHE B 111       4.161  11.249  10.477  1.00 23.86           C  
ATOM   2382  CE2 PHE B 111       2.759  10.223  12.158  1.00 24.37           C  
ATOM   2383  CZ  PHE B 111       3.713  11.173  11.803  1.00 24.85           C  
ATOM   2384  N   MET B 112       4.648   6.206   9.713  1.00 22.80           N  
ATOM   2385  CA  MET B 112       5.119   5.402  10.832  1.00 24.59           C  
ATOM   2386  C   MET B 112       5.928   6.230  11.814  1.00 24.43           C  
ATOM   2387  O   MET B 112       7.133   6.391  11.661  1.00 23.18           O  
ATOM   2388  CB  MET B 112       5.985   4.253  10.338  1.00 25.89           C  
ATOM   2389  CG  MET B 112       5.207   3.117   9.768  1.00 26.15           C  
ATOM   2390  SD  MET B 112       5.954   1.608  10.284  1.00 24.10           S  
ATOM   2391  CE  MET B 112       6.538   1.084   8.735  1.00 27.70           C  
ATOM   2392  N   ALA B 113       5.269   6.754  12.831  1.00 23.83           N  
ATOM   2393  CA  ALA B 113       5.973   7.570  13.786  1.00 24.78           C  
ATOM   2394  C   ALA B 113       6.310   6.804  15.044  1.00 27.32           C  
ATOM   2395  O   ALA B 113       5.419   6.336  15.752  1.00 28.66           O  
ATOM   2396  CB  ALA B 113       5.163   8.788  14.114  1.00 22.53           C  
ATOM   2397  N   PHE B 114       7.613   6.675  15.303  1.00 28.95           N  
ATOM   2398  CA  PHE B 114       8.123   5.986  16.480  1.00 30.84           C  
ATOM   2399  C   PHE B 114       7.523   4.608  16.652  1.00 31.37           C  
ATOM   2400  O   PHE B 114       7.390   4.121  17.777  1.00 32.33           O  
ATOM   2401  CB  PHE B 114       7.819   6.810  17.728  1.00 30.49           C  
ATOM   2402  CG  PHE B 114       8.264   8.223  17.620  1.00 32.62           C  
ATOM   2403  CD1 PHE B 114       7.349   9.230  17.295  1.00 31.91           C  
ATOM   2404  CD2 PHE B 114       9.615   8.551  17.792  1.00 32.71           C  
ATOM   2405  CE1 PHE B 114       7.760  10.543  17.141  1.00 31.98           C  
ATOM   2406  CE2 PHE B 114      10.048   9.863  17.644  1.00 33.34           C  
ATOM   2407  CZ  PHE B 114       9.121  10.868  17.314  1.00 33.26           C  
ATOM   2408  N   THR B 115       7.178   3.969  15.547  1.00 31.35           N  
ATOM   2409  CA  THR B 115       6.548   2.664  15.630  1.00 32.65           C  
ATOM   2410  C   THR B 115       7.346   1.534  14.961  1.00 33.25           C  
ATOM   2411  O   THR B 115       7.165   0.362  15.290  1.00 33.62           O  
ATOM   2412  CB  THR B 115       5.081   2.767  15.061  1.00 31.36           C  
ATOM   2413  OG1 THR B 115       4.407   1.519  15.211  1.00 32.89           O  
ATOM   2414  CG2 THR B 115       5.094   3.157  13.599  1.00 33.90           C  
ATOM   2415  N   PHE B 116       8.251   1.887  14.056  1.00 33.99           N  
ATOM   2416  CA  PHE B 116       9.055   0.896  13.347  1.00 35.83           C  
ATOM   2417  C   PHE B 116       9.916   0.015  14.271  1.00 37.15           C  
ATOM   2418  O   PHE B 116      10.063  -1.186  14.029  1.00 37.47           O  
ATOM   2419  CB  PHE B 116       9.955   1.602  12.317  1.00 36.47           C  
ATOM   2420  CG  PHE B 116      10.481   0.692  11.228  1.00 35.22           C  
ATOM   2421  CD1 PHE B 116       9.655   0.261  10.193  1.00 35.99           C  
ATOM   2422  CD2 PHE B 116      11.817   0.301  11.218  1.00 35.08           C  
ATOM   2423  CE1 PHE B 116      10.149  -0.549   9.159  1.00 35.98           C  
ATOM   2424  CE2 PHE B 116      12.325  -0.509  10.189  1.00 35.37           C  
ATOM   2425  CZ  PHE B 116      11.488  -0.931   9.156  1.00 34.66           C  
ATOM   2426  N   HIS B 117      10.487   0.598  15.321  1.00 37.67           N  
ATOM   2427  CA  HIS B 117      11.316  -0.193  16.223  1.00 38.51           C  
ATOM   2428  C   HIS B 117      10.471  -1.094  17.129  1.00 39.48           C  
ATOM   2429  O   HIS B 117      10.989  -1.726  18.064  1.00 40.72           O  
ATOM   2430  CB  HIS B 117      12.238   0.712  17.070  1.00 37.74           C  
ATOM   2431  CG  HIS B 117      11.517   1.570  18.067  1.00 36.82           C  
ATOM   2432  ND1 HIS B 117      11.007   2.814  17.753  1.00 36.23           N  
ATOM   2433  CD2 HIS B 117      11.210   1.353  19.368  1.00 35.45           C  
ATOM   2434  CE1 HIS B 117      10.417   3.326  18.819  1.00 35.26           C  
ATOM   2435  NE2 HIS B 117      10.525   2.459  19.812  1.00 35.97           N  
ATOM   2436  N   GLU B 118       9.169  -1.161  16.847  1.00 39.59           N  
ATOM   2437  CA  GLU B 118       8.239  -1.995  17.623  1.00 38.42           C  
ATOM   2438  C   GLU B 118       7.714  -3.192  16.829  1.00 37.48           C  
ATOM   2439  O   GLU B 118       7.138  -4.124  17.395  1.00 37.18           O  
ATOM   2440  CB  GLU B 118       7.057  -1.153  18.117  1.00 37.80           C  
ATOM   2441  CG  GLU B 118       7.342  -0.399  19.388  1.00 36.09           C  
ATOM   2442  CD  GLU B 118       6.077   0.001  20.119  1.00 34.29           C  
ATOM   2443  OE1 GLU B 118       5.149  -0.830  20.190  1.00 31.81           O  
ATOM   2444  OE2 GLU B 118       6.021   1.134  20.638  1.00 35.44           O  
ATOM   2445  N   LEU B 119       7.912  -3.154  15.517  1.00 36.85           N  
ATOM   2446  CA  LEU B 119       7.467  -4.236  14.653  1.00 36.65           C  
ATOM   2447  C   LEU B 119       8.245  -5.496  14.992  1.00 37.23           C  
ATOM   2448  O   LEU B 119       9.474  -5.490  14.993  1.00 36.61           O  
ATOM   2449  CB  LEU B 119       7.727  -3.890  13.185  1.00 35.97           C  
ATOM   2450  CG  LEU B 119       7.207  -2.577  12.596  1.00 35.68           C  
ATOM   2451  CD1 LEU B 119       7.805  -2.389  11.215  1.00 36.04           C  
ATOM   2452  CD2 LEU B 119       5.687  -2.587  12.529  1.00 34.63           C  
ATOM   2453  N   SER B 120       7.534  -6.574  15.295  1.00 37.98           N  
ATOM   2454  CA  SER B 120       8.186  -7.831  15.593  1.00 38.29           C  
ATOM   2455  C   SER B 120       8.918  -8.286  14.342  1.00 39.88           C  
ATOM   2456  O   SER B 120      10.111  -8.586  14.375  1.00 40.53           O  
ATOM   2457  CB  SER B 120       7.150  -8.863  15.986  1.00 37.99           C  
ATOM   2458  OG  SER B 120       6.431  -8.396  17.100  1.00 40.65           O  
ATOM   2459  N   GLU B 121       8.204  -8.299  13.222  1.00 41.10           N  
ATOM   2460  CA  GLU B 121       8.788  -8.738  11.966  1.00 41.59           C  
ATOM   2461  C   GLU B 121       8.688  -7.701  10.853  1.00 41.17           C  
ATOM   2462  O   GLU B 121       7.821  -7.762   9.977  1.00 40.16           O  
ATOM   2463  CB  GLU B 121       8.150 -10.067  11.564  1.00 42.29           C  
ATOM   2464  CG  GLU B 121       8.507 -11.164  12.562  1.00 43.89           C  
ATOM   2465  CD  GLU B 121       7.881 -12.493  12.227  1.00 45.48           C  
ATOM   2466  OE1 GLU B 121       6.673 -12.656  12.494  1.00 46.61           O  
ATOM   2467  OE2 GLU B 121       8.596 -13.375  11.698  1.00 46.30           O  
ATOM   2468  N   PRO B 122       9.617  -6.741  10.870  1.00 40.80           N  
ATOM   2469  CA  PRO B 122       9.756  -5.623   9.935  1.00 40.91           C  
ATOM   2470  C   PRO B 122       9.366  -5.899   8.490  1.00 41.35           C  
ATOM   2471  O   PRO B 122       8.551  -5.165   7.917  1.00 42.64           O  
ATOM   2472  CB  PRO B 122      11.231  -5.251  10.066  1.00 40.84           C  
ATOM   2473  CG  PRO B 122      11.487  -5.501  11.510  1.00 40.99           C  
ATOM   2474  CD  PRO B 122      10.792  -6.820  11.757  1.00 40.77           C  
ATOM   2475  N   LEU B 123       9.934  -6.933   7.878  1.00 40.56           N  
ATOM   2476  CA  LEU B 123       9.608  -7.169   6.476  1.00 39.53           C  
ATOM   2477  C   LEU B 123       8.339  -7.975   6.284  1.00 38.40           C  
ATOM   2478  O   LEU B 123       7.698  -7.912   5.230  1.00 36.70           O  
ATOM   2479  CB  LEU B 123      10.803  -7.787   5.730  1.00 39.30           C  
ATOM   2480  CG  LEU B 123      11.442  -9.108   6.134  1.00 39.54           C  
ATOM   2481  CD1 LEU B 123      12.642  -9.320   5.239  1.00 39.23           C  
ATOM   2482  CD2 LEU B 123      11.865  -9.094   7.585  1.00 40.18           C  
ATOM   2483  N   LYS B 124       7.955  -8.716   7.312  1.00 37.63           N  
ATOM   2484  CA  LYS B 124       6.720  -9.463   7.215  1.00 37.11           C  
ATOM   2485  C   LYS B 124       5.688  -8.338   7.171  1.00 36.83           C  
ATOM   2486  O   LYS B 124       4.816  -8.311   6.298  1.00 37.67           O  
ATOM   2487  CB  LYS B 124       6.522 -10.339   8.448  1.00 38.11           C  
ATOM   2488  CG  LYS B 124       5.519 -11.469   8.280  1.00 39.64           C  
ATOM   2489  CD  LYS B 124       6.123 -12.810   8.768  1.00 43.36           C  
ATOM   2490  CE  LYS B 124       7.357 -13.216   7.920  1.00 44.49           C  
ATOM   2491  NZ  LYS B 124       8.155 -14.343   8.508  1.00 45.04           N  
ATOM   2492  N   PHE B 125       5.825  -7.387   8.091  1.00 34.35           N  
ATOM   2493  CA  PHE B 125       4.905  -6.265   8.155  1.00 33.07           C  
ATOM   2494  C   PHE B 125       4.960  -5.402   6.921  1.00 33.04           C  
ATOM   2495  O   PHE B 125       3.932  -4.903   6.474  1.00 33.63           O  
ATOM   2496  CB  PHE B 125       5.194  -5.400   9.378  1.00 32.84           C  
ATOM   2497  CG  PHE B 125       4.278  -4.221   9.507  1.00 32.13           C  
ATOM   2498  CD1 PHE B 125       4.588  -3.005   8.901  1.00 31.26           C  
ATOM   2499  CD2 PHE B 125       3.104  -4.322  10.256  1.00 31.32           C  
ATOM   2500  CE1 PHE B 125       3.745  -1.902   9.039  1.00 30.80           C  
ATOM   2501  CE2 PHE B 125       2.254  -3.232  10.403  1.00 30.78           C  
ATOM   2502  CZ  PHE B 125       2.573  -2.016   9.796  1.00 30.40           C  
ATOM   2503  N   LEU B 126       6.157  -5.210   6.381  1.00 32.09           N  
ATOM   2504  CA  LEU B 126       6.314  -4.393   5.185  1.00 30.87           C  
ATOM   2505  C   LEU B 126       5.661  -4.985   3.934  1.00 30.68           C  
ATOM   2506  O   LEU B 126       5.331  -4.241   3.022  1.00 31.75           O  
ATOM   2507  CB  LEU B 126       7.794  -4.121   4.916  1.00 32.38           C  
ATOM   2508  CG  LEU B 126       8.386  -2.771   5.348  1.00 32.27           C  
ATOM   2509  CD1 LEU B 126       7.902  -2.382   6.718  1.00 33.20           C  
ATOM   2510  CD2 LEU B 126       9.902  -2.875   5.334  1.00 32.39           C  
ATOM   2511  N   GLU B 127       5.488  -6.306   3.872  1.00 30.37           N  
ATOM   2512  CA  GLU B 127       4.840  -6.933   2.708  1.00 30.63           C  
ATOM   2513  C   GLU B 127       3.380  -6.551   2.750  1.00 29.97           C  
ATOM   2514  O   GLU B 127       2.781  -6.172   1.741  1.00 30.59           O  
ATOM   2515  CB  GLU B 127       4.917  -8.462   2.761  1.00 32.29           C  
ATOM   2516  CG  GLU B 127       6.217  -9.046   2.283  1.00 36.15           C  
ATOM   2517  CD  GLU B 127       6.559  -8.597   0.887  1.00 38.25           C  
ATOM   2518  OE1 GLU B 127       5.849  -9.016  -0.057  1.00 38.16           O  
ATOM   2519  OE2 GLU B 127       7.534  -7.819   0.738  1.00 38.98           O  
ATOM   2520  N   GLU B 128       2.817  -6.674   3.940  1.00 28.53           N  
ATOM   2521  CA  GLU B 128       1.433  -6.351   4.172  1.00 28.49           C  
ATOM   2522  C   GLU B 128       1.184  -4.885   3.805  1.00 28.80           C  
ATOM   2523  O   GLU B 128       0.135  -4.547   3.248  1.00 28.92           O  
ATOM   2524  CB  GLU B 128       1.096  -6.618   5.640  1.00 28.70           C  
ATOM   2525  CG  GLU B 128      -0.334  -6.328   6.006  1.00 30.59           C  
ATOM   2526  CD  GLU B 128      -1.316  -7.245   5.311  1.00 30.98           C  
ATOM   2527  OE1 GLU B 128      -0.944  -7.880   4.296  1.00 29.95           O  
ATOM   2528  OE2 GLU B 128      -2.470  -7.322   5.782  1.00 31.82           O  
ATOM   2529  N   LEU B 129       2.149  -4.021   4.120  1.00 27.89           N  
ATOM   2530  CA  LEU B 129       2.056  -2.588   3.818  1.00 28.11           C  
ATOM   2531  C   LEU B 129       1.983  -2.322   2.318  1.00 28.04           C  
ATOM   2532  O   LEU B 129       1.360  -1.357   1.870  1.00 27.96           O  
ATOM   2533  CB  LEU B 129       3.269  -1.836   4.375  1.00 29.70           C  
ATOM   2534  CG  LEU B 129       3.173  -1.150   5.737  1.00 29.81           C  
ATOM   2535  CD1 LEU B 129       4.464  -0.395   6.011  1.00 28.29           C  
ATOM   2536  CD2 LEU B 129       1.995  -0.195   5.744  1.00 30.06           C  
ATOM   2537  N   LYS B 130       2.650  -3.166   1.544  1.00 27.23           N  
ATOM   2538  CA  LYS B 130       2.651  -3.015   0.108  1.00 26.77           C  
ATOM   2539  C   LYS B 130       1.324  -3.443  -0.476  1.00 25.49           C  
ATOM   2540  O   LYS B 130       0.889  -2.911  -1.486  1.00 27.22           O  
ATOM   2541  CB  LYS B 130       3.785  -3.823  -0.509  1.00 27.89           C  
ATOM   2542  CG  LYS B 130       5.148  -3.231  -0.234  1.00 26.82           C  
ATOM   2543  CD  LYS B 130       6.107  -3.588  -1.344  1.00 27.99           C  
ATOM   2544  CE  LYS B 130       6.480  -5.055  -1.328  1.00 28.37           C  
ATOM   2545  NZ  LYS B 130       7.349  -5.406  -0.173  1.00 29.09           N  
ATOM   2546  N   ARG B 131       0.675  -4.404   0.163  1.00 24.03           N  
ATOM   2547  CA  ARG B 131      -0.616  -4.876  -0.309  1.00 23.23           C  
ATOM   2548  C   ARG B 131      -1.674  -3.771  -0.214  1.00 23.52           C  
ATOM   2549  O   ARG B 131      -2.364  -3.472  -1.194  1.00 22.30           O  
ATOM   2550  CB  ARG B 131      -1.066  -6.086   0.508  1.00 21.47           C  
ATOM   2551  CG  ARG B 131      -2.434  -6.603   0.111  1.00 19.77           C  
ATOM   2552  CD  ARG B 131      -2.824  -7.843   0.887  1.00 18.03           C  
ATOM   2553  NE  ARG B 131      -3.123  -7.545   2.274  1.00 16.29           N  
ATOM   2554  CZ  ARG B 131      -4.075  -6.710   2.656  1.00 16.42           C  
ATOM   2555  NH1 ARG B 131      -4.811  -6.097   1.746  1.00 17.59           N  
ATOM   2556  NH2 ARG B 131      -4.292  -6.480   3.941  1.00 15.42           N  
ATOM   2557  N   VAL B 132      -1.800  -3.166   0.965  1.00 23.32           N  
ATOM   2558  CA  VAL B 132      -2.789  -2.112   1.156  1.00 24.36           C  
ATOM   2559  C   VAL B 132      -2.392  -0.800   0.488  1.00 25.72           C  
ATOM   2560  O   VAL B 132      -3.161   0.157   0.460  1.00 25.40           O  
ATOM   2561  CB  VAL B 132      -3.053  -1.863   2.641  1.00 23.24           C  
ATOM   2562  CG1 VAL B 132      -3.533  -3.132   3.288  1.00 26.32           C  
ATOM   2563  CG2 VAL B 132      -1.806  -1.376   3.323  1.00 24.97           C  
ATOM   2564  N   ALA B 133      -1.194  -0.769  -0.076  1.00 25.91           N  
ATOM   2565  CA  ALA B 133      -0.716   0.428  -0.729  1.00 26.50           C  
ATOM   2566  C   ALA B 133      -1.071   0.443  -2.206  1.00 27.25           C  
ATOM   2567  O   ALA B 133      -1.114  -0.599  -2.856  1.00 27.05           O  
ATOM   2568  CB  ALA B 133       0.775   0.536  -0.547  1.00 26.85           C  
ATOM   2569  N   LYS B 134      -1.330   1.637  -2.730  1.00 28.53           N  
ATOM   2570  CA  LYS B 134      -1.666   1.804  -4.140  1.00 29.53           C  
ATOM   2571  C   LYS B 134      -0.399   1.591  -4.962  1.00 31.61           C  
ATOM   2572  O   LYS B 134       0.711   1.649  -4.426  1.00 30.68           O  
ATOM   2573  CB  LYS B 134      -2.226   3.208  -4.399  1.00 27.65           C  
ATOM   2574  CG  LYS B 134      -3.508   3.499  -3.663  1.00 27.83           C  
ATOM   2575  CD  LYS B 134      -4.162   4.796  -4.105  1.00 26.13           C  
ATOM   2576  CE  LYS B 134      -5.471   5.003  -3.353  1.00 27.48           C  
ATOM   2577  NZ  LYS B 134      -6.362   6.077  -3.899  1.00 26.90           N  
ATOM   2578  N   PRO B 135      -0.544   1.359  -6.278  1.00 34.30           N  
ATOM   2579  CA  PRO B 135       0.636   1.142  -7.119  1.00 36.17           C  
ATOM   2580  C   PRO B 135       1.820   2.060  -6.809  1.00 37.83           C  
ATOM   2581  O   PRO B 135       2.969   1.660  -7.010  1.00 39.56           O  
ATOM   2582  CB  PRO B 135       0.088   1.297  -8.546  1.00 36.39           C  
ATOM   2583  CG  PRO B 135      -1.220   2.037  -8.373  1.00 35.13           C  
ATOM   2584  CD  PRO B 135      -1.758   1.468  -7.103  1.00 34.45           C  
ATOM   2585  N   PHE B 136       1.549   3.271  -6.321  1.00 38.82           N  
ATOM   2586  CA  PHE B 136       2.622   4.197  -5.969  1.00 40.48           C  
ATOM   2587  C   PHE B 136       2.711   4.275  -4.441  1.00 40.63           C  
ATOM   2588  O   PHE B 136       3.222   3.348  -3.802  1.00 43.11           O  
ATOM   2589  CB  PHE B 136       2.366   5.593  -6.532  1.00 43.63           C  
ATOM   2590  CG  PHE B 136       1.550   5.612  -7.807  1.00 49.64           C  
ATOM   2591  CD1 PHE B 136       0.160   5.356  -7.777  1.00 51.47           C  
ATOM   2592  CD2 PHE B 136       2.154   5.954  -9.033  1.00 50.25           C  
ATOM   2593  CE1 PHE B 136      -0.624   5.451  -8.959  1.00 52.52           C  
ATOM   2594  CE2 PHE B 136       1.385   6.051 -10.223  1.00 51.60           C  
ATOM   2595  CZ  PHE B 136      -0.006   5.803 -10.190  1.00 51.96           C  
ATOM   2596  N   ALA B 137       2.222   5.371  -3.855  1.00 37.72           N  
ATOM   2597  CA  ALA B 137       2.229   5.544  -2.395  1.00 34.87           C  
ATOM   2598  C   ALA B 137       3.564   5.903  -1.729  1.00 34.64           C  
ATOM   2599  O   ALA B 137       4.629   5.372  -2.074  1.00 33.17           O  
ATOM   2600  CB  ALA B 137       1.667   4.304  -1.732  1.00 34.19           C  
ATOM   2601  N   TYR B 138       3.470   6.802  -0.746  1.00 33.89           N  
ATOM   2602  CA  TYR B 138       4.608   7.276   0.044  1.00 32.80           C  
ATOM   2603  C   TYR B 138       4.722   6.580   1.408  1.00 30.65           C  
ATOM   2604  O   TYR B 138       3.722   6.202   2.025  1.00 29.08           O  
ATOM   2605  CB  TYR B 138       4.494   8.783   0.306  1.00 35.18           C  
ATOM   2606  CG  TYR B 138       4.378   9.645  -0.929  1.00 38.87           C  
ATOM   2607  CD1 TYR B 138       3.220   9.623  -1.707  1.00 39.13           C  
ATOM   2608  CD2 TYR B 138       5.426  10.501  -1.314  1.00 39.37           C  
ATOM   2609  CE1 TYR B 138       3.102  10.427  -2.836  1.00 41.30           C  
ATOM   2610  CE2 TYR B 138       5.316  11.312  -2.448  1.00 40.55           C  
ATOM   2611  CZ  TYR B 138       4.148  11.270  -3.206  1.00 41.47           C  
ATOM   2612  OH  TYR B 138       4.008  12.054  -4.335  1.00 42.60           O  
ATOM   2613  N   LEU B 139       5.954   6.432   1.880  1.00 28.94           N  
ATOM   2614  CA  LEU B 139       6.210   5.820   3.180  1.00 27.27           C  
ATOM   2615  C   LEU B 139       7.121   6.761   3.967  1.00 26.16           C  
ATOM   2616  O   LEU B 139       8.288   6.931   3.622  1.00 26.58           O  
ATOM   2617  CB  LEU B 139       6.868   4.444   3.014  1.00 25.78           C  
ATOM   2618  CG  LEU B 139       7.254   3.764   4.334  1.00 26.90           C  
ATOM   2619  CD1 LEU B 139       6.064   3.733   5.264  1.00 25.03           C  
ATOM   2620  CD2 LEU B 139       7.766   2.361   4.075  1.00 25.40           C  
ATOM   2621  N   ALA B 140       6.571   7.390   5.004  1.00 25.40           N  
ATOM   2622  CA  ALA B 140       7.312   8.336   5.843  1.00 23.11           C  
ATOM   2623  C   ALA B 140       7.491   7.782   7.232  1.00 21.33           C  
ATOM   2624  O   ALA B 140       6.554   7.730   8.002  1.00 22.64           O  
ATOM   2625  CB  ALA B 140       6.576   9.655   5.920  1.00 22.00           C  
ATOM   2626  N   ILE B 141       8.707   7.372   7.551  1.00 22.62           N  
ATOM   2627  CA  ILE B 141       9.001   6.811   8.861  1.00 21.66           C  
ATOM   2628  C   ILE B 141       9.728   7.843   9.711  1.00 22.35           C  
ATOM   2629  O   ILE B 141      10.670   8.477   9.258  1.00 24.09           O  
ATOM   2630  CB  ILE B 141       9.863   5.550   8.710  1.00 20.21           C  
ATOM   2631  CG1 ILE B 141       9.102   4.516   7.878  1.00 22.12           C  
ATOM   2632  CG2 ILE B 141      10.210   4.982  10.054  1.00 21.62           C  
ATOM   2633  CD1 ILE B 141       9.893   3.262   7.535  1.00 22.76           C  
ATOM   2634  N   ILE B 142       9.279   8.031  10.941  1.00 23.34           N  
ATOM   2635  CA  ILE B 142       9.921   8.995  11.824  1.00 24.56           C  
ATOM   2636  C   ILE B 142      10.243   8.332  13.162  1.00 26.17           C  
ATOM   2637  O   ILE B 142       9.338   7.958  13.910  1.00 27.41           O  
ATOM   2638  CB  ILE B 142       9.008  10.194  12.026  1.00 22.88           C  
ATOM   2639  CG1 ILE B 142       8.771  10.860  10.676  1.00 21.96           C  
ATOM   2640  CG2 ILE B 142       9.623  11.157  12.994  1.00 24.70           C  
ATOM   2641  CD1 ILE B 142       7.718  11.906  10.708  1.00 25.27           C  
ATOM   2642  N   ASP B 143      11.530   8.183  13.468  1.00 27.25           N  
ATOM   2643  CA  ASP B 143      11.917   7.525  14.716  1.00 27.36           C  
ATOM   2644  C   ASP B 143      13.085   8.169  15.464  1.00 27.76           C  
ATOM   2645  O   ASP B 143      13.656   9.164  15.027  1.00 27.16           O  
ATOM   2646  CB  ASP B 143      12.234   6.046  14.449  1.00 25.32           C  
ATOM   2647  CG  ASP B 143      11.510   5.105  15.398  1.00 25.51           C  
ATOM   2648  OD1 ASP B 143      11.370   5.447  16.585  1.00 25.08           O  
ATOM   2649  OD2 ASP B 143      11.095   4.013  14.960  1.00 26.52           O  
ATOM   2650  N   TRP B 144      13.428   7.578  16.605  1.00 29.82           N  
ATOM   2651  CA  TRP B 144      14.517   8.065  17.452  1.00 30.39           C  
ATOM   2652  C   TRP B 144      15.878   7.712  16.872  1.00 32.00           C  
ATOM   2653  O   TRP B 144      16.041   6.638  16.287  1.00 31.85           O  
ATOM   2654  CB  TRP B 144      14.436   7.437  18.842  1.00 28.87           C  
ATOM   2655  CG  TRP B 144      13.182   7.714  19.608  1.00 28.48           C  
ATOM   2656  CD1 TRP B 144      12.215   6.815  19.939  1.00 28.03           C  
ATOM   2657  CD2 TRP B 144      12.805   8.952  20.217  1.00 28.64           C  
ATOM   2658  NE1 TRP B 144      11.264   7.411  20.725  1.00 27.35           N  
ATOM   2659  CE2 TRP B 144      11.599   8.724  20.909  1.00 28.85           C  
ATOM   2660  CE3 TRP B 144      13.373  10.230  20.245  1.00 28.15           C  
ATOM   2661  CZ2 TRP B 144      10.946   9.736  21.629  1.00 29.25           C  
ATOM   2662  CZ3 TRP B 144      12.723  11.236  20.963  1.00 30.49           C  
ATOM   2663  CH2 TRP B 144      11.521  10.982  21.644  1.00 28.83           C  
ATOM   2664  N   LYS B 145      16.848   8.610  17.052  1.00 33.16           N  
ATOM   2665  CA  LYS B 145      18.215   8.382  16.587  1.00 34.65           C  
ATOM   2666  C   LYS B 145      18.871   7.425  17.572  1.00 33.57           C  
ATOM   2667  O   LYS B 145      18.634   7.519  18.776  1.00 32.70           O  
ATOM   2668  CB  LYS B 145      19.011   9.689  16.557  1.00 37.19           C  
ATOM   2669  CG  LYS B 145      18.319  10.815  15.805  1.00 40.42           C  
ATOM   2670  CD  LYS B 145      19.251  12.002  15.593  1.00 41.80           C  
ATOM   2671  CE  LYS B 145      20.282  11.714  14.514  1.00 42.80           C  
ATOM   2672  NZ  LYS B 145      21.132  12.914  14.244  1.00 43.87           N  
ATOM   2673  N   LYS B 146      19.675   6.498  17.060  1.00 33.74           N  
ATOM   2674  CA  LYS B 146      20.362   5.518  17.901  1.00 34.13           C  
ATOM   2675  C   LYS B 146      21.563   6.214  18.547  1.00 35.75           C  
ATOM   2676  O   LYS B 146      22.703   6.083  18.089  1.00 34.47           O  
ATOM   2677  CB  LYS B 146      20.829   4.331  17.053  1.00 32.10           C  
ATOM   2678  CG  LYS B 146      20.925   3.015  17.810  1.00 30.05           C  
ATOM   2679  CD  LYS B 146      21.698   1.982  17.005  1.00 30.75           C  
ATOM   2680  CE  LYS B 146      21.671   0.619  17.658  1.00 29.31           C  
ATOM   2681  NZ  LYS B 146      20.349  -0.042  17.505  1.00 30.87           N  
ATOM   2682  N   GLU B 147      21.291   6.958  19.615  1.00 37.24           N  
ATOM   2683  CA  GLU B 147      22.328   7.700  20.296  1.00 40.01           C  
ATOM   2684  C   GLU B 147      21.784   8.341  21.568  1.00 42.19           C  
ATOM   2685  O   GLU B 147      20.569   8.495  21.723  1.00 42.91           O  
ATOM   2686  CB  GLU B 147      22.849   8.784  19.372  1.00 39.99           C  
ATOM   2687  CG  GLU B 147      21.876   9.911  19.198  1.00 41.57           C  
ATOM   2688  CD  GLU B 147      22.352  10.923  18.200  1.00 42.83           C  
ATOM   2689  OE1 GLU B 147      21.856  12.066  18.254  1.00 44.40           O  
ATOM   2690  OE2 GLU B 147      23.214  10.574  17.355  1.00 43.86           O  
ATOM   2691  N   GLU B 148      22.683   8.733  22.472  1.00 44.30           N  
ATOM   2692  CA  GLU B 148      22.262   9.334  23.733  1.00 46.51           C  
ATOM   2693  C   GLU B 148      21.546  10.666  23.547  1.00 46.86           C  
ATOM   2694  O   GLU B 148      22.077  11.610  22.936  1.00 46.02           O  
ATOM   2695  CB  GLU B 148      23.455   9.514  24.671  1.00 49.27           C  
ATOM   2696  CG  GLU B 148      23.529   8.494  25.817  1.00 53.39           C  
ATOM   2697  CD  GLU B 148      23.691   7.038  25.351  1.00 55.12           C  
ATOM   2698  OE1 GLU B 148      24.234   6.818  24.232  1.00 54.95           O  
ATOM   2699  OE2 GLU B 148      23.298   6.118  26.126  1.00 55.58           O  
ATOM   2700  N   ARG B 149      20.329  10.716  24.087  1.00 46.85           N  
ATOM   2701  CA  ARG B 149      19.469  11.892  24.010  1.00 46.99           C  
ATOM   2702  C   ARG B 149      18.865  12.101  25.381  1.00 46.98           C  
ATOM   2703  O   ARG B 149      18.723  11.162  26.165  1.00 46.04           O  
ATOM   2704  CB  ARG B 149      18.318  11.663  23.007  1.00 47.27           C  
ATOM   2705  CG  ARG B 149      18.744  11.222  21.605  1.00 45.68           C  
ATOM   2706  CD  ARG B 149      17.547  10.830  20.741  1.00 43.84           C  
ATOM   2707  NE  ARG B 149      17.468   9.384  20.553  1.00 42.80           N  
ATOM   2708  CZ  ARG B 149      16.997   8.537  21.465  1.00 43.22           C  
ATOM   2709  NH1 ARG B 149      16.552   9.004  22.630  1.00 42.60           N  
ATOM   2710  NH2 ARG B 149      16.994   7.222  21.226  1.00 40.62           N  
ATOM   2711  N   ASP B 150      18.486  13.334  25.662  1.00 48.42           N  
ATOM   2712  CA  ASP B 150      17.878  13.643  26.941  1.00 49.80           C  
ATOM   2713  C   ASP B 150      16.379  13.753  26.737  1.00 50.74           C  
ATOM   2714  O   ASP B 150      15.774  14.770  27.101  1.00 51.27           O  
ATOM   2715  CB  ASP B 150      18.438  14.959  27.494  1.00 50.56           C  
ATOM   2716  CG  ASP B 150      18.372  16.099  26.488  1.00 51.01           C  
ATOM   2717  OD1 ASP B 150      19.046  16.013  25.435  1.00 50.09           O  
ATOM   2718  OD2 ASP B 150      17.652  17.088  26.755  1.00 51.51           O  
ATOM   2719  N   LYS B 151      15.786  12.711  26.146  1.00 50.72           N  
ATOM   2720  CA  LYS B 151      14.349  12.692  25.889  1.00 50.44           C  
ATOM   2721  C   LYS B 151      13.771  11.338  25.442  1.00 50.84           C  
ATOM   2722  O   LYS B 151      12.796  10.863  26.037  1.00 52.52           O  
ATOM   2723  CB  LYS B 151      14.000  13.789  24.880  1.00 49.61           C  
ATOM   2724  CG  LYS B 151      12.609  13.704  24.272  1.00 51.94           C  
ATOM   2725  CD  LYS B 151      11.472  13.703  25.304  1.00 53.72           C  
ATOM   2726  CE  LYS B 151      10.085  13.572  24.614  1.00 54.00           C  
ATOM   2727  NZ  LYS B 151       8.905  13.513  25.535  1.00 53.03           N  
ATOM   2728  N   GLY B 152      14.349  10.706  24.421  1.00 49.57           N  
ATOM   2729  CA  GLY B 152      13.805   9.430  23.966  1.00 48.64           C  
ATOM   2730  C   GLY B 152      14.230   8.224  24.791  1.00 48.23           C  
ATOM   2731  O   GLY B 152      14.881   8.391  25.825  1.00 49.44           O  
ATOM   2732  N   PRO B 153      13.878   6.991  24.373  1.00 47.20           N  
ATOM   2733  CA  PRO B 153      14.259   5.779  25.120  1.00 45.90           C  
ATOM   2734  C   PRO B 153      15.733   5.391  24.872  1.00 44.86           C  
ATOM   2735  O   PRO B 153      16.436   6.036  24.087  1.00 44.42           O  
ATOM   2736  CB  PRO B 153      13.278   4.733  24.581  1.00 45.91           C  
ATOM   2737  CG  PRO B 153      13.153   5.127  23.128  1.00 44.95           C  
ATOM   2738  CD  PRO B 153      13.020   6.651  23.218  1.00 46.04           C  
ATOM   2739  N   PRO B 154      16.220   4.333  25.540  1.00 44.30           N  
ATOM   2740  CA  PRO B 154      17.621   3.933  25.328  1.00 43.85           C  
ATOM   2741  C   PRO B 154      17.882   3.621  23.855  1.00 42.89           C  
ATOM   2742  O   PRO B 154      16.985   3.163  23.150  1.00 42.23           O  
ATOM   2743  CB  PRO B 154      17.762   2.684  26.198  1.00 43.51           C  
ATOM   2744  CG  PRO B 154      16.776   2.926  27.300  1.00 43.62           C  
ATOM   2745  CD  PRO B 154      15.581   3.495  26.571  1.00 43.65           C  
ATOM   2746  N   PRO B 155      19.113   3.869  23.374  1.00 42.66           N  
ATOM   2747  CA  PRO B 155      19.475   3.604  21.978  1.00 42.00           C  
ATOM   2748  C   PRO B 155      19.422   2.129  21.580  1.00 41.62           C  
ATOM   2749  O   PRO B 155      19.207   1.804  20.413  1.00 41.35           O  
ATOM   2750  CB  PRO B 155      20.881   4.182  21.878  1.00 41.79           C  
ATOM   2751  CG  PRO B 155      20.833   5.339  22.844  1.00 42.22           C  
ATOM   2752  CD  PRO B 155      20.142   4.701  24.025  1.00 42.72           C  
ATOM   2753  N   GLU B 156      19.613   1.235  22.542  1.00 42.01           N  
ATOM   2754  CA  GLU B 156      19.586  -0.196  22.249  1.00 42.02           C  
ATOM   2755  C   GLU B 156      18.216  -0.619  21.705  1.00 42.17           C  
ATOM   2756  O   GLU B 156      18.126  -1.591  20.953  1.00 41.13           O  
ATOM   2757  CB  GLU B 156      19.886  -1.029  23.504  1.00 42.82           C  
ATOM   2758  CG  GLU B 156      21.044  -0.558  24.366  1.00 43.31           C  
ATOM   2759  CD  GLU B 156      20.647   0.580  25.292  1.00 44.64           C  
ATOM   2760  OE1 GLU B 156      20.624   1.753  24.838  1.00 44.46           O  
ATOM   2761  OE2 GLU B 156      20.344   0.294  26.474  1.00 44.81           O  
ATOM   2762  N   GLU B 157      17.165   0.114  22.086  1.00 42.43           N  
ATOM   2763  CA  GLU B 157      15.785  -0.184  21.669  1.00 42.82           C  
ATOM   2764  C   GLU B 157      15.323   0.500  20.389  1.00 42.12           C  
ATOM   2765  O   GLU B 157      14.118   0.578  20.149  1.00 42.92           O  
ATOM   2766  CB  GLU B 157      14.784   0.214  22.765  1.00 44.53           C  
ATOM   2767  CG  GLU B 157      14.944  -0.473  24.121  1.00 48.32           C  
ATOM   2768  CD  GLU B 157      13.923   0.024  25.154  1.00 50.54           C  
ATOM   2769  OE1 GLU B 157      12.703   0.006  24.861  1.00 52.09           O  
ATOM   2770  OE2 GLU B 157      14.336   0.425  26.267  1.00 51.73           O  
ATOM   2771  N   VAL B 158      16.242   0.990  19.564  1.00 40.61           N  
ATOM   2772  CA  VAL B 158      15.824   1.682  18.353  1.00 39.52           C  
ATOM   2773  C   VAL B 158      16.742   1.486  17.151  1.00 39.46           C  
ATOM   2774  O   VAL B 158      17.944   1.683  17.257  1.00 40.92           O  
ATOM   2775  CB  VAL B 158      15.714   3.194  18.612  1.00 38.56           C  
ATOM   2776  CG1 VAL B 158      17.057   3.750  19.021  1.00 37.52           C  
ATOM   2777  CG2 VAL B 158      15.239   3.901  17.352  1.00 41.17           C  
ATOM   2778  N   TYR B 159      16.188   1.118  16.000  1.00 38.87           N  
ATOM   2779  CA  TYR B 159      17.027   0.940  14.813  1.00 38.57           C  
ATOM   2780  C   TYR B 159      17.715   2.251  14.447  1.00 38.20           C  
ATOM   2781  O   TYR B 159      17.154   3.330  14.631  1.00 38.47           O  
ATOM   2782  CB  TYR B 159      16.204   0.485  13.601  1.00 37.16           C  
ATOM   2783  CG  TYR B 159      15.496  -0.822  13.781  1.00 37.76           C  
ATOM   2784  CD1 TYR B 159      14.148  -0.859  14.105  1.00 37.11           C  
ATOM   2785  CD2 TYR B 159      16.176  -2.034  13.644  1.00 38.47           C  
ATOM   2786  CE1 TYR B 159      13.496  -2.059  14.290  1.00 37.04           C  
ATOM   2787  CE2 TYR B 159      15.517  -3.251  13.832  1.00 36.90           C  
ATOM   2788  CZ  TYR B 159      14.183  -3.248  14.155  1.00 36.51           C  
ATOM   2789  OH  TYR B 159      13.516  -4.434  14.370  1.00 38.87           O  
ATOM   2790  N   SER B 160      18.931   2.165  13.930  1.00 37.39           N  
ATOM   2791  CA  SER B 160      19.603   3.380  13.521  1.00 38.05           C  
ATOM   2792  C   SER B 160      19.020   3.722  12.150  1.00 39.75           C  
ATOM   2793  O   SER B 160      18.330   2.900  11.529  1.00 39.94           O  
ATOM   2794  CB  SER B 160      21.116   3.166  13.403  1.00 36.40           C  
ATOM   2795  OG  SER B 160      21.506   2.845  12.077  1.00 31.48           O  
ATOM   2796  N   GLU B 161      19.285   4.929  11.671  1.00 41.06           N  
ATOM   2797  CA  GLU B 161      18.785   5.318  10.371  1.00 42.55           C  
ATOM   2798  C   GLU B 161      19.781   4.803   9.351  1.00 44.17           C  
ATOM   2799  O   GLU B 161      20.418   5.576   8.646  1.00 45.76           O  
ATOM   2800  CB  GLU B 161      18.660   6.839  10.283  1.00 44.16           C  
ATOM   2801  CG  GLU B 161      19.974   7.615  10.361  1.00 43.93           C  
ATOM   2802  CD  GLU B 161      20.744   7.314  11.624  1.00 44.79           C  
ATOM   2803  OE1 GLU B 161      20.199   7.532  12.739  1.00 44.68           O  
ATOM   2804  OE2 GLU B 161      21.900   6.852  11.491  1.00 45.35           O  
ATOM   2805  N   TRP B 162      19.935   3.482   9.319  1.00 45.72           N  
ATOM   2806  CA  TRP B 162      20.847   2.797   8.399  1.00 46.48           C  
ATOM   2807  C   TRP B 162      20.292   1.383   8.238  1.00 46.17           C  
ATOM   2808  O   TRP B 162      20.132   0.886   7.121  1.00 45.87           O  
ATOM   2809  CB  TRP B 162      22.269   2.720   8.967  1.00 49.53           C  
ATOM   2810  CG  TRP B 162      22.960   4.059   9.160  1.00 53.78           C  
ATOM   2811  CD1 TRP B 162      23.328   4.639  10.356  1.00 54.88           C  
ATOM   2812  CD2 TRP B 162      23.381   4.966   8.130  1.00 54.77           C  
ATOM   2813  NE1 TRP B 162      23.951   5.852  10.123  1.00 55.13           N  
ATOM   2814  CE2 TRP B 162      23.998   6.073   8.768  1.00 55.34           C  
ATOM   2815  CE3 TRP B 162      23.298   4.953   6.726  1.00 56.16           C  
ATOM   2816  CZ2 TRP B 162      24.526   7.151   8.052  1.00 56.39           C  
ATOM   2817  CZ3 TRP B 162      23.824   6.027   6.009  1.00 57.22           C  
ATOM   2818  CH2 TRP B 162      24.432   7.112   6.675  1.00 57.71           C  
ATOM   2819  N   GLU B 163      20.015   0.727   9.360  1.00 44.34           N  
ATOM   2820  CA  GLU B 163      19.452  -0.601   9.292  1.00 44.47           C  
ATOM   2821  C   GLU B 163      18.071  -0.439   8.673  1.00 42.98           C  
ATOM   2822  O   GLU B 163      17.679  -1.201   7.788  1.00 43.19           O  
ATOM   2823  CB  GLU B 163      19.349  -1.232  10.689  1.00 46.91           C  
ATOM   2824  CG  GLU B 163      19.150  -0.241  11.828  1.00 49.98           C  
ATOM   2825  CD  GLU B 163      20.425  -0.023  12.633  1.00 51.09           C  
ATOM   2826  OE1 GLU B 163      21.477   0.258  12.012  1.00 52.37           O  
ATOM   2827  OE2 GLU B 163      20.380  -0.116  13.882  1.00 51.08           O  
ATOM   2828  N   VAL B 164      17.346   0.573   9.135  1.00 41.14           N  
ATOM   2829  CA  VAL B 164      16.014   0.856   8.613  1.00 38.72           C  
ATOM   2830  C   VAL B 164      16.058   0.881   7.092  1.00 37.14           C  
ATOM   2831  O   VAL B 164      15.186   0.329   6.427  1.00 37.25           O  
ATOM   2832  CB  VAL B 164      15.488   2.232   9.100  1.00 38.21           C  
ATOM   2833  CG1 VAL B 164      14.217   2.596   8.353  1.00 36.67           C  
ATOM   2834  CG2 VAL B 164      15.231   2.196  10.590  1.00 35.99           C  
ATOM   2835  N   GLY B 165      17.088   1.525   6.556  1.00 36.01           N  
ATOM   2836  CA  GLY B 165      17.241   1.626   5.116  1.00 35.79           C  
ATOM   2837  C   GLY B 165      17.457   0.298   4.416  1.00 35.77           C  
ATOM   2838  O   GLY B 165      16.829   0.019   3.393  1.00 35.18           O  
ATOM   2839  N   LEU B 166      18.342  -0.525   4.970  1.00 35.44           N  
ATOM   2840  CA  LEU B 166      18.638  -1.827   4.393  1.00 35.63           C  
ATOM   2841  C   LEU B 166      17.432  -2.762   4.460  1.00 35.03           C  
ATOM   2842  O   LEU B 166      17.299  -3.682   3.646  1.00 35.75           O  
ATOM   2843  CB  LEU B 166      19.823  -2.462   5.116  1.00 36.90           C  
ATOM   2844  CG  LEU B 166      21.041  -1.545   5.200  1.00 38.12           C  
ATOM   2845  CD1 LEU B 166      22.134  -2.259   5.971  1.00 39.00           C  
ATOM   2846  CD2 LEU B 166      21.514  -1.153   3.799  1.00 38.48           C  
ATOM   2847  N   ILE B 167      16.565  -2.537   5.441  1.00 32.67           N  
ATOM   2848  CA  ILE B 167      15.360  -3.337   5.576  1.00 31.68           C  
ATOM   2849  C   ILE B 167      14.436  -2.945   4.407  1.00 32.11           C  
ATOM   2850  O   ILE B 167      14.016  -3.790   3.625  1.00 32.28           O  
ATOM   2851  CB  ILE B 167      14.679  -3.066   6.935  1.00 30.43           C  
ATOM   2852  CG1 ILE B 167      15.595  -3.547   8.064  1.00 28.33           C  
ATOM   2853  CG2 ILE B 167      13.323  -3.753   6.997  1.00 30.34           C  
ATOM   2854  CD1 ILE B 167      15.047  -3.342   9.456  1.00 24.85           C  
ATOM   2855  N   LEU B 168      14.144  -1.659   4.277  1.00 31.78           N  
ATOM   2856  CA  LEU B 168      13.303  -1.179   3.189  1.00 33.90           C  
ATOM   2857  C   LEU B 168      13.805  -1.737   1.857  1.00 35.83           C  
ATOM   2858  O   LEU B 168      13.053  -2.316   1.065  1.00 35.71           O  
ATOM   2859  CB  LEU B 168      13.352   0.344   3.128  1.00 32.36           C  
ATOM   2860  CG  LEU B 168      12.344   1.243   3.843  1.00 31.64           C  
ATOM   2861  CD1 LEU B 168      11.751   0.585   5.066  1.00 29.08           C  
ATOM   2862  CD2 LEU B 168      13.065   2.536   4.205  1.00 29.03           C  
ATOM   2863  N   GLU B 169      15.093  -1.534   1.617  1.00 38.49           N  
ATOM   2864  CA  GLU B 169      15.754  -1.995   0.404  1.00 40.44           C  
ATOM   2865  C   GLU B 169      15.497  -3.495   0.241  1.00 40.87           C  
ATOM   2866  O   GLU B 169      15.059  -3.960  -0.807  1.00 40.99           O  
ATOM   2867  CB  GLU B 169      17.258  -1.684   0.515  1.00 40.74           C  
ATOM   2868  CG  GLU B 169      18.184  -2.813   0.116  1.00 43.90           C  
ATOM   2869  CD  GLU B 169      19.397  -2.936   1.036  1.00 45.51           C  
ATOM   2870  OE1 GLU B 169      20.350  -2.135   0.867  1.00 47.15           O  
ATOM   2871  OE2 GLU B 169      19.396  -3.828   1.931  1.00 43.94           O  
ATOM   2872  N   ASP B 170      15.744  -4.241   1.306  1.00 40.92           N  
ATOM   2873  CA  ASP B 170      15.554  -5.679   1.299  1.00 41.72           C  
ATOM   2874  C   ASP B 170      14.071  -6.060   1.228  1.00 41.60           C  
ATOM   2875  O   ASP B 170      13.720  -7.226   1.035  1.00 41.31           O  
ATOM   2876  CB  ASP B 170      16.197  -6.259   2.559  1.00 42.74           C  
ATOM   2877  CG  ASP B 170      16.018  -7.747   2.672  1.00 44.23           C  
ATOM   2878  OD1 ASP B 170      16.259  -8.462   1.665  1.00 43.91           O  
ATOM   2879  OD2 ASP B 170      15.645  -8.199   3.779  1.00 46.19           O  
ATOM   2880  N   ALA B 171      13.203  -5.068   1.390  1.00 40.93           N  
ATOM   2881  CA  ALA B 171      11.766  -5.303   1.352  1.00 39.32           C  
ATOM   2882  C   ALA B 171      11.215  -4.807   0.030  1.00 38.24           C  
ATOM   2883  O   ALA B 171      10.005  -4.799  -0.189  1.00 38.37           O  
ATOM   2884  CB  ALA B 171      11.087  -4.585   2.509  1.00 38.31           C  
ATOM   2885  N   GLY B 172      12.114  -4.394  -0.852  1.00 36.64           N  
ATOM   2886  CA  GLY B 172      11.689  -3.902  -2.142  1.00 36.21           C  
ATOM   2887  C   GLY B 172      11.399  -2.419  -2.150  1.00 36.73           C  
ATOM   2888  O   GLY B 172      11.440  -1.804  -3.210  1.00 37.90           O  
ATOM   2889  N   ILE B 173      11.104  -1.838  -0.986  1.00 36.03           N  
ATOM   2890  CA  ILE B 173      10.812  -0.406  -0.891  1.00 34.15           C  
ATOM   2891  C   ILE B 173      12.041   0.425  -1.227  1.00 34.67           C  
ATOM   2892  O   ILE B 173      13.141   0.091  -0.789  1.00 35.45           O  
ATOM   2893  CB  ILE B 173      10.380  -0.004   0.531  1.00 33.06           C  
ATOM   2894  CG1 ILE B 173       9.062  -0.681   0.904  1.00 31.93           C  
ATOM   2895  CG2 ILE B 173      10.255   1.506   0.624  1.00 30.71           C  
ATOM   2896  CD1 ILE B 173       9.190  -2.153   1.144  1.00 32.59           C  
ATOM   2897  N   ARG B 174      11.867   1.506  -1.990  1.00 34.94           N  
ATOM   2898  CA  ARG B 174      13.006   2.366  -2.326  1.00 35.52           C  
ATOM   2899  C   ARG B 174      13.048   3.671  -1.531  1.00 34.52           C  
ATOM   2900  O   ARG B 174      12.078   4.431  -1.473  1.00 33.18           O  
ATOM   2901  CB  ARG B 174      13.053   2.667  -3.830  1.00 37.62           C  
ATOM   2902  CG  ARG B 174      12.166   3.795  -4.344  1.00 41.28           C  
ATOM   2903  CD  ARG B 174      11.782   3.503  -5.813  1.00 45.89           C  
ATOM   2904  NE  ARG B 174      10.980   4.547  -6.465  1.00 47.58           N  
ATOM   2905  CZ  ARG B 174      10.432   4.428  -7.676  1.00 47.90           C  
ATOM   2906  NH1 ARG B 174      10.583   3.306  -8.375  1.00 46.21           N  
ATOM   2907  NH2 ARG B 174       9.756   5.444  -8.205  1.00 48.51           N  
ATOM   2908  N   VAL B 175      14.202   3.917  -0.918  1.00 33.52           N  
ATOM   2909  CA  VAL B 175      14.428   5.095  -0.096  1.00 32.67           C  
ATOM   2910  C   VAL B 175      14.873   6.328  -0.888  1.00 32.31           C  
ATOM   2911  O   VAL B 175      15.951   6.356  -1.468  1.00 31.78           O  
ATOM   2912  CB  VAL B 175      15.473   4.776   0.974  1.00 32.16           C  
ATOM   2913  CG1 VAL B 175      15.444   5.825   2.067  1.00 31.90           C  
ATOM   2914  CG2 VAL B 175      15.210   3.391   1.532  1.00 32.57           C  
ATOM   2915  N   GLY B 176      14.036   7.355  -0.902  1.00 32.27           N  
ATOM   2916  CA  GLY B 176      14.391   8.555  -1.626  1.00 32.81           C  
ATOM   2917  C   GLY B 176      15.366   9.392  -0.824  1.00 34.37           C  
ATOM   2918  O   GLY B 176      16.376   9.865  -1.350  1.00 35.87           O  
ATOM   2919  N   ARG B 177      15.079   9.572   0.460  1.00 34.16           N  
ATOM   2920  CA  ARG B 177      15.957  10.362   1.298  1.00 33.33           C  
ATOM   2921  C   ARG B 177      15.797  10.082   2.784  1.00 33.50           C  
ATOM   2922  O   ARG B 177      14.743   9.642   3.233  1.00 33.86           O  
ATOM   2923  CB  ARG B 177      15.705  11.837   1.041  1.00 34.32           C  
ATOM   2924  CG  ARG B 177      14.412  12.350   1.620  1.00 36.56           C  
ATOM   2925  CD  ARG B 177      14.282  13.839   1.349  1.00 40.87           C  
ATOM   2926  NE  ARG B 177      13.413  14.139   0.212  1.00 44.40           N  
ATOM   2927  CZ  ARG B 177      12.163  14.584   0.334  1.00 46.72           C  
ATOM   2928  NH1 ARG B 177      11.640  14.780   1.543  1.00 47.15           N  
ATOM   2929  NH2 ARG B 177      11.433  14.837  -0.747  1.00 47.78           N  
ATOM   2930  N   VAL B 178      16.860  10.333   3.541  1.00 32.95           N  
ATOM   2931  CA  VAL B 178      16.832  10.164   4.990  1.00 32.68           C  
ATOM   2932  C   VAL B 178      17.308  11.492   5.581  1.00 32.66           C  
ATOM   2933  O   VAL B 178      18.464  11.859   5.437  1.00 33.73           O  
ATOM   2934  CB  VAL B 178      17.758   9.023   5.459  1.00 31.64           C  
ATOM   2935  CG1 VAL B 178      17.576   8.807   6.943  1.00 31.92           C  
ATOM   2936  CG2 VAL B 178      17.446   7.750   4.715  1.00 29.73           C  
ATOM   2937  N   VAL B 179      16.408  12.215   6.232  1.00 33.63           N  
ATOM   2938  CA  VAL B 179      16.732  13.517   6.810  1.00 34.26           C  
ATOM   2939  C   VAL B 179      16.772  13.468   8.336  1.00 34.89           C  
ATOM   2940  O   VAL B 179      16.450  12.445   8.936  1.00 35.21           O  
ATOM   2941  CB  VAL B 179      15.674  14.557   6.400  1.00 33.72           C  
ATOM   2942  CG1 VAL B 179      16.174  15.961   6.710  1.00 35.50           C  
ATOM   2943  CG2 VAL B 179      15.362  14.417   4.924  1.00 34.17           C  
ATOM   2944  N   GLU B 180      17.172  14.566   8.967  1.00 35.82           N  
ATOM   2945  CA  GLU B 180      17.195  14.599  10.427  1.00 37.54           C  
ATOM   2946  C   GLU B 180      15.991  15.404  10.863  1.00 37.12           C  
ATOM   2947  O   GLU B 180      15.681  16.407  10.235  1.00 36.63           O  
ATOM   2948  CB  GLU B 180      18.483  15.249  10.947  1.00 39.47           C  
ATOM   2949  CG  GLU B 180      18.693  16.707  10.560  1.00 42.41           C  
ATOM   2950  CD  GLU B 180      20.063  17.224  11.005  1.00 43.29           C  
ATOM   2951  OE1 GLU B 180      20.385  18.397  10.705  1.00 44.09           O  
ATOM   2952  OE2 GLU B 180      20.818  16.454  11.650  1.00 42.78           O  
ATOM   2953  N   VAL B 181      15.306  14.962  11.918  1.00 37.76           N  
ATOM   2954  CA  VAL B 181      14.118  15.659  12.402  1.00 37.95           C  
ATOM   2955  C   VAL B 181      14.226  16.189  13.838  1.00 40.35           C  
ATOM   2956  O   VAL B 181      14.223  15.419  14.808  1.00 41.15           O  
ATOM   2957  CB  VAL B 181      12.872  14.757  12.301  1.00 37.15           C  
ATOM   2958  CG1 VAL B 181      11.636  15.534  12.714  1.00 36.98           C  
ATOM   2959  CG2 VAL B 181      12.721  14.231  10.878  1.00 35.70           C  
ATOM   2960  N   GLY B 182      14.329  17.513  13.950  1.00 41.78           N  
ATOM   2961  CA  GLY B 182      14.413  18.174  15.242  1.00 43.21           C  
ATOM   2962  C   GLY B 182      15.575  17.857  16.167  1.00 43.99           C  
ATOM   2963  O   GLY B 182      15.494  18.130  17.372  1.00 44.22           O  
ATOM   2964  N   LYS B 183      16.652  17.289  15.639  1.00 44.20           N  
ATOM   2965  CA  LYS B 183      17.795  16.970  16.498  1.00 45.62           C  
ATOM   2966  C   LYS B 183      17.394  16.104  17.707  1.00 43.04           C  
ATOM   2967  O   LYS B 183      17.584  16.488  18.862  1.00 41.26           O  
ATOM   2968  CB  LYS B 183      18.466  18.267  16.986  1.00 49.16           C  
ATOM   2969  CG  LYS B 183      18.953  19.224  15.850  1.00 52.86           C  
ATOM   2970  CD  LYS B 183      19.642  20.472  16.437  1.00 54.33           C  
ATOM   2971  CE  LYS B 183      19.955  21.530  15.374  1.00 55.40           C  
ATOM   2972  NZ  LYS B 183      20.640  22.744  15.957  1.00 55.55           N  
ATOM   2973  N   TYR B 184      16.830  14.940  17.393  1.00 41.48           N  
ATOM   2974  CA  TYR B 184      16.372  13.925  18.350  1.00 39.56           C  
ATOM   2975  C   TYR B 184      15.934  12.731  17.515  1.00 37.26           C  
ATOM   2976  O   TYR B 184      16.079  11.583  17.920  1.00 37.17           O  
ATOM   2977  CB  TYR B 184      15.172  14.419  19.163  1.00 39.51           C  
ATOM   2978  CG  TYR B 184      15.509  14.976  20.525  1.00 39.02           C  
ATOM   2979  CD1 TYR B 184      14.947  16.175  20.955  1.00 39.04           C  
ATOM   2980  CD2 TYR B 184      16.366  14.296  21.391  1.00 38.21           C  
ATOM   2981  CE1 TYR B 184      15.227  16.686  22.209  1.00 40.26           C  
ATOM   2982  CE2 TYR B 184      16.650  14.795  22.643  1.00 39.81           C  
ATOM   2983  CZ  TYR B 184      16.079  15.993  23.054  1.00 40.60           C  
ATOM   2984  OH  TYR B 184      16.340  16.498  24.314  1.00 41.17           O  
ATOM   2985  N   CYS B 185      15.412  13.031  16.331  1.00 35.11           N  
ATOM   2986  CA  CYS B 185      14.934  12.012  15.413  1.00 33.38           C  
ATOM   2987  C   CYS B 185      15.522  12.131  14.015  1.00 33.00           C  
ATOM   2988  O   CYS B 185      16.401  12.940  13.741  1.00 31.25           O  
ATOM   2989  CB  CYS B 185      13.419  12.100  15.261  1.00 31.61           C  
ATOM   2990  SG  CYS B 185      12.506  11.980  16.752  1.00 30.35           S  
ATOM   2991  N   PHE B 186      14.993  11.287  13.140  1.00 33.00           N  
ATOM   2992  CA  PHE B 186      15.345  11.269  11.736  1.00 33.41           C  
ATOM   2993  C   PHE B 186      14.061  10.860  11.031  1.00 32.54           C  
ATOM   2994  O   PHE B 186      13.200  10.207  11.616  1.00 32.79           O  
ATOM   2995  CB  PHE B 186      16.485  10.279  11.448  1.00 33.91           C  
ATOM   2996  CG  PHE B 186      16.119   8.844  11.620  1.00 34.12           C  
ATOM   2997  CD1 PHE B 186      15.406   8.174  10.636  1.00 35.34           C  
ATOM   2998  CD2 PHE B 186      16.529   8.148  12.748  1.00 36.18           C  
ATOM   2999  CE1 PHE B 186      15.108   6.813  10.775  1.00 36.04           C  
ATOM   3000  CE2 PHE B 186      16.237   6.789  12.898  1.00 36.18           C  
ATOM   3001  CZ  PHE B 186      15.525   6.120  11.907  1.00 34.74           C  
ATOM   3002  N   GLY B 187      13.910  11.285   9.794  1.00 31.16           N  
ATOM   3003  CA  GLY B 187      12.720  10.933   9.069  1.00 31.12           C  
ATOM   3004  C   GLY B 187      13.172  10.361   7.758  1.00 31.25           C  
ATOM   3005  O   GLY B 187      13.884  11.019   7.014  1.00 30.88           O  
ATOM   3006  N   VAL B 188      12.802   9.124   7.481  1.00 32.26           N  
ATOM   3007  CA  VAL B 188      13.178   8.521   6.218  1.00 33.07           C  
ATOM   3008  C   VAL B 188      11.994   8.624   5.269  1.00 32.48           C  
ATOM   3009  O   VAL B 188      10.842   8.452   5.667  1.00 29.83           O  
ATOM   3010  CB  VAL B 188      13.581   7.053   6.395  1.00 34.02           C  
ATOM   3011  CG1 VAL B 188      14.748   6.956   7.367  1.00 35.74           C  
ATOM   3012  CG2 VAL B 188      12.429   6.264   6.911  1.00 35.73           C  
ATOM   3013  N   TYR B 189      12.292   8.942   4.017  1.00 33.31           N  
ATOM   3014  CA  TYR B 189      11.270   9.092   2.982  1.00 34.21           C  
ATOM   3015  C   TYR B 189      11.423   8.073   1.836  1.00 32.16           C  
ATOM   3016  O   TYR B 189      12.437   8.038   1.140  1.00 30.31           O  
ATOM   3017  CB  TYR B 189      11.305  10.531   2.458  1.00 36.88           C  
ATOM   3018  CG  TYR B 189      10.527  10.776   1.188  1.00 42.02           C  
ATOM   3019  CD1 TYR B 189      11.126  10.593  -0.064  1.00 44.18           C  
ATOM   3020  CD2 TYR B 189       9.200  11.223   1.232  1.00 43.35           C  
ATOM   3021  CE1 TYR B 189      10.433  10.848  -1.240  1.00 45.22           C  
ATOM   3022  CE2 TYR B 189       8.492  11.483   0.062  1.00 45.27           C  
ATOM   3023  CZ  TYR B 189       9.116  11.293  -1.179  1.00 46.78           C  
ATOM   3024  OH  TYR B 189       8.427  11.527  -2.362  1.00 47.87           O  
ATOM   3025  N   ALA B 190      10.410   7.228   1.665  1.00 31.63           N  
ATOM   3026  CA  ALA B 190      10.437   6.216   0.616  1.00 30.93           C  
ATOM   3027  C   ALA B 190       9.131   6.157  -0.172  1.00 30.21           C  
ATOM   3028  O   ALA B 190       8.104   6.715   0.223  1.00 27.08           O  
ATOM   3029  CB  ALA B 190      10.752   4.852   1.214  1.00 29.67           C  
ATOM   3030  N   MET B 191       9.195   5.472  -1.303  1.00 31.39           N  
ATOM   3031  CA  MET B 191       8.046   5.327  -2.169  1.00 31.38           C  
ATOM   3032  C   MET B 191       7.859   3.860  -2.513  1.00 30.65           C  
ATOM   3033  O   MET B 191       8.808   3.145  -2.813  1.00 28.25           O  
ATOM   3034  CB  MET B 191       8.239   6.141  -3.450  1.00 33.38           C  
ATOM   3035  CG  MET B 191       6.958   6.804  -3.951  1.00 38.18           C  
ATOM   3036  SD  MET B 191       6.769   6.808  -5.778  1.00 41.92           S  
ATOM   3037  CE  MET B 191       7.841   8.215  -6.226  1.00 43.00           C  
ATOM   3038  N   ILE B 192       6.614   3.420  -2.446  1.00 32.75           N  
ATOM   3039  CA  ILE B 192       6.261   2.049  -2.770  1.00 33.67           C  
ATOM   3040  C   ILE B 192       5.886   2.011  -4.244  1.00 35.39           C  
ATOM   3041  O   ILE B 192       5.377   2.990  -4.790  1.00 34.69           O  
ATOM   3042  CB  ILE B 192       5.054   1.584  -1.933  1.00 33.26           C  
ATOM   3043  CG1 ILE B 192       5.508   1.282  -0.504  1.00 31.43           C  
ATOM   3044  CG2 ILE B 192       4.386   0.375  -2.586  1.00 31.93           C  
ATOM   3045  CD1 ILE B 192       4.390   0.904   0.407  1.00 30.00           C  
ATOM   3046  N   VAL B 193       6.142   0.881  -4.886  1.00 37.96           N  
ATOM   3047  CA  VAL B 193       5.814   0.738  -6.301  1.00 40.50           C  
ATOM   3048  C   VAL B 193       5.927  -0.725  -6.744  1.00 42.82           C  
ATOM   3049  O   VAL B 193       4.885  -1.313  -7.151  1.00 43.36           O  
ATOM   3050  CB  VAL B 193       6.754   1.608  -7.157  1.00 40.14           C  
ATOM   3051  CG1 VAL B 193       8.212   1.253  -6.848  1.00 38.94           C  
ATOM   3052  CG2 VAL B 193       6.428   1.437  -8.632  1.00 39.26           C  
TER    3053      VAL B 193                                                      
END
MOLECULE T0485.pdb
ATOM      5  N   MET     1      -1.481 -13.150  43.871  1.00  8.67           N  
ATOM      6  CA  MET     1      -1.996 -12.142  42.964  0.70  8.34           C  
ATOM      8  C   MET     1      -0.843 -11.344  42.396  1.00  7.61           C  
ATOM      9  O   MET     1       0.307 -11.417  42.868  1.00  8.27           O  
ATOM     10  CB  MET     1      -3.060 -11.257  43.656  0.70  7.93           C  
ATOM     12  CG  MET     1      -2.578 -10.402  44.794  0.70  6.92           C  
ATOM     14  SD  MET     1      -1.632  -8.771  44.313  0.53  6.93          SE  
ATOM     16  CE  MET     1      -3.050  -7.819  43.355  0.70 10.03           C  
ATOM     18  N   SER     2      -1.143 -10.624  41.351  1.00  7.85           N  
ATOM     19  CA  SER     2      -0.222  -9.690  40.807  1.00  9.16           C  
ATOM     20  C   SER     2      -0.898  -8.470  40.231  1.00  9.17           C  
ATOM     21  O   SER     2      -2.095  -8.531  39.828  1.00 10.71           O  
ATOM     22  CB  SER     2       0.615 -10.344  39.753  1.00  9.64           C  
ATOM     23  OG  SER     2      -0.120 -10.696  38.610  1.00 11.89           O  
ATOM     24  N   GLU     3      -0.151  -7.389  40.224  1.00  8.77           N  
ATOM     25  CA  GLU     3      -0.509  -6.172  39.524  0.53  8.19           C  
ATOM     27  C   GLU     3       0.562  -6.069  38.444  1.00  8.87           C  
ATOM     28  O   GLU     3       1.745  -6.166  38.752  1.00 12.42           O  
ATOM     29  CB  GLU     3      -0.448  -4.997  40.483  0.53 10.65           C  
ATOM     31  CG  GLU     3      -0.721  -3.646  39.850  0.53 12.43           C  
ATOM     33  CD  GLU     3      -2.150  -3.481  39.333  0.53 14.52           C  
ATOM     35  OE1 GLU     3      -3.058  -4.169  39.799  0.53 14.77           O  
ATOM     37  OE2 GLU     3      -2.356  -2.624  38.458  0.53 21.83           O  
ATOM     39  N   ASN     4       0.176  -5.885  37.205  1.00  8.06           N  
ATOM     40  CA  ASN     4       1.062  -5.959  36.055  0.74  9.14           C  
ATOM     42  C   ASN     4       1.002  -4.687  35.236  1.00  9.09           C  
ATOM     43  O   ASN     4      -0.074  -4.130  35.035  1.00 13.07           O  
ATOM     44  CB  ASN     4       0.606  -7.129  35.142  0.74 10.42           C  
ATOM     46  CG  ASN     4       0.724  -8.489  35.798  0.74 10.49           C  
ATOM     48  OD1 ASN     4       1.608  -9.290  35.448  0.74 13.87           O  
ATOM     50  ND2 ASN     4      -0.134  -8.756  36.763  0.74  9.20           N  
ATOM     52  N   LYS     5       2.150  -4.296  34.746  1.00  6.87           N  
ATOM     53  CA  LYS     5       2.324  -3.143  33.860  1.00  7.01           C  
ATOM     54  C   LYS     5       3.179  -3.619  32.700  1.00  7.25           C  
ATOM     55  O   LYS     5       4.205  -4.240  32.901  1.00  7.40           O  
ATOM     56  CB  LYS     5       2.998  -2.001  34.624  1.00  7.11           C  
ATOM     57  CG  LYS     5       3.426  -0.860  33.745  1.00  7.50           C  
ATOM     58  CD  LYS     5       2.280   0.049  33.310  1.00  7.49           C  
ATOM     59  CE  LYS     5       2.719   1.051  32.232  1.00  8.04           C  
ATOM     60  NZ  LYS     5       2.947   0.397  30.922  1.00  8.27           N  
ATOM     61  N   LYS     6       2.719  -3.369  31.473  1.00  7.17           N  
ATOM     62  CA  LYS     6       3.456  -3.757  30.274  1.00  8.10           C  
ATOM     63  C   LYS     6       3.233  -2.708  29.204  1.00  7.31           C  
ATOM     64  O   LYS     6       2.310  -1.895  29.289  1.00  7.86           O  
ATOM     65  CB  LYS     6       3.043  -5.126  29.805  1.00  9.03           C  
ATOM     66  CG  LYS     6       1.599  -5.244  29.462  1.00  9.62           C  
ATOM     67  CD  LYS     6       1.186  -6.709  29.147  1.00 12.22           C  
ATOM     68  CE  LYS     6      -0.336  -6.926  28.980  1.00 14.34           C  
ATOM     69  NZ  LYS     6      -1.001  -6.893  30.345  1.00 15.98           N  
ATOM     70  N   LYS     7       4.087  -2.694  28.194  1.00  7.80           N  
ATOM     71  CA  LYS     7       3.964  -1.662  27.190  1.00  7.69           C  
ATOM     72  C   LYS     7       2.617  -1.682  26.492  1.00  7.66           C  
ATOM     73  O   LYS     7       2.071  -2.728  26.148  1.00  8.71           O  
ATOM     74  CB  LYS     7       5.046  -1.755  26.125  1.00  8.86           C  
ATOM     75  CG  LYS     7       6.450  -1.501  26.628  1.00 11.03           C  
ATOM     76  CD  LYS     7       7.438  -1.209  25.488  1.00 13.56           C  
ATOM     77  CE  LYS     7       7.589  -2.328  24.501  1.00 13.98           C  
ATOM     78  NZ  LYS     7       8.191  -3.588  25.051  1.00 17.04           N  
ATOM     79  N   PHE     8       2.096  -0.482  26.317  1.00  7.70           N  
ATOM     80  CA  PHE     8       0.891  -0.214  25.527  1.00  7.42           C  
ATOM     81  C   PHE     8      -0.409  -0.656  26.170  1.00  7.87           C  
ATOM     82  O   PHE     8      -1.454  -0.771  25.521  1.00  9.21           O  
ATOM     83  CB  PHE     8       1.015  -0.731  24.073  1.00  9.35           C  
ATOM     84  CG  PHE     8       2.397  -0.542  23.487  1.00  8.92           C  
ATOM     85  CD1 PHE     8       2.987   0.706  23.481  1.00  9.86           C  
ATOM     86  CD2 PHE     8       3.069  -1.598  22.920  1.00 10.18           C  
ATOM     87  CE1 PHE     8       4.256   0.904  22.946  1.00  9.67           C  
ATOM     88  CE2 PHE     8       4.353  -1.418  22.365  1.00 11.24           C  
ATOM     89  CZ  PHE     8       4.922  -0.179  22.389  1.00 10.77           C  
ATOM     90  N   ASP     9      -0.325  -0.887  27.471  1.00  7.13           N  
ATOM     91  CA  ASP     9      -1.507  -1.238  28.276  1.00  7.67           C  
ATOM     92  C   ASP     9      -2.276   0.016  28.676  1.00  7.69           C  
ATOM     93  O   ASP     9      -2.012   1.098  28.184  1.00  7.72           O  
ATOM     94  CB  ASP     9      -1.129  -2.123  29.468  1.00  8.06           C  
ATOM     95  CG  ASP     9      -0.247  -1.442  30.510  1.00  6.85           C  
ATOM     96  OD1 ASP     9       0.092  -0.248  30.352  1.00  7.29           O  
ATOM     97  OD2 ASP     9       0.069  -2.129  31.524  1.00  7.83           O  
ATOM     98  N   LYS    10      -3.267  -0.124  29.545  1.00  8.67           N  
ATOM     99  CA  LYS    10      -4.080   1.031  29.882  1.00  9.26           C  
ATOM    100  C   LYS    10      -3.265   2.158  30.504  1.00  8.69           C  
ATOM    101  O   LYS    10      -3.387   3.323  30.124  1.00  8.94           O  
ATOM    102  CB  LYS    10      -5.210   0.623  30.806  1.00 11.99           C  
ATOM    103  CG  LYS    10      -6.173   1.746  31.093  1.00 16.97           C  
ATOM    104  CD  LYS    10      -7.405   1.342  31.886  1.00 22.29           C  
ATOM    105  CE  LYS    10      -8.364   2.546  31.946  1.00 27.25           C  
ATOM    106  NZ  LYS    10      -9.627   2.275  32.678  1.00 32.98           N  
ATOM    107  N   LYS    11      -2.416   1.817  31.462  1.00  8.37           N  
ATOM    108  CA  LYS    11      -1.579   2.828  32.078  1.00  8.68           C  
ATOM    109  C   LYS    11      -0.591   3.451  31.102  1.00  7.99           C  
ATOM    110  O   LYS    11      -0.346   4.666  31.124  1.00  8.73           O  
ATOM    111  CB  LYS    11      -0.858   2.193  33.240  1.00  9.97           C  
ATOM    112  CG  LYS    11      -1.736   1.893  34.432  1.00 14.76           C  
ATOM    113  CD  LYS    11      -1.059   1.146  35.513  1.00 18.41           C  
ATOM    114  CE  LYS    11      -1.984   1.067  36.712  1.00 20.58           C  
ATOM    115  NZ  LYS    11      -1.315   0.442  37.822  1.00 22.46           N  
ATOM    116  N   GLY    12      -0.010   2.630  30.240  1.00  7.91           N  
ATOM    117  CA  GLY    12       0.930   3.141  29.266  1.00  7.46           C  
ATOM    118  C   GLY    12       0.271   4.038  28.242  1.00  7.46           C  
ATOM    119  O   GLY    12       0.847   5.037  27.807  1.00  8.40           O  
ATOM    120  N   ALA    13      -0.950   3.685  27.854  1.00  7.42           N  
ATOM    121  CA  ALA    13      -1.714   4.493  26.900  1.00  7.56           C  
ATOM    122  C   ALA    13      -1.979   5.875  27.498  1.00  7.04           C  
ATOM    123  O   ALA    13      -1.894   6.900  26.820  1.00  7.99           O  
ATOM    124  CB  ALA    13      -3.037   3.792  26.547  1.00  9.11           C  
ATOM    125  N   LYS    14      -2.325   5.905  28.784  1.00  7.10           N  
ATOM    126  CA  LYS    14      -2.545   7.170  29.482  0.53  7.27           C  
ATOM    128  C   LYS    14      -1.266   8.025  29.468  1.00  7.21           C  
ATOM    129  O   LYS    14      -1.321   9.233  29.257  1.00  8.68           O  
ATOM    130  CB  LYS    14      -3.017   6.888  30.918  0.53  8.25           C  
ATOM    132  CG  LYS    14      -3.209   8.137  31.782  0.53 10.78           C  
ATOM    134  CD  LYS    14      -3.717   7.767  33.194  0.53 16.27           C  
ATOM    136  CE  LYS    14      -3.901   8.984  34.108  0.53 20.54           C  
ATOM    138  NZ  LYS    14      -2.629   9.615  34.533  0.53 23.85           N  
ATOM    140  N   ASN    15      -0.131   7.406  29.726  1.00  7.92           N  
ATOM    141  CA  ASN    15       1.136   8.159  29.717  1.00  8.53           C  
ATOM    142  C   ASN    15       1.440   8.737  28.345  1.00  8.17           C  
ATOM    143  O   ASN    15       1.852   9.887  28.230  1.00  8.82           O  
ATOM    144  CB  ASN    15       2.283   7.276  30.135  1.00  8.79           C  
ATOM    145  CG  ASN    15       2.242   6.898  31.574  1.00 11.44           C  
ATOM    146  OD1 ASN    15       1.482   7.460  32.353  1.00 15.16           O  
ATOM    147  ND2 ASN    15       3.084   5.969  31.954  1.00 11.41           N  
ATOM    148  N   MET    16       1.247   7.925  27.308  1.00  7.21           N  
ATOM    149  CA  MET    16       1.480   8.381  25.957  1.00  8.03           C  
ATOM    150  C   MET    16       0.532   9.535  25.607  1.00  7.68           C  
ATOM    151  O   MET    16       0.938  10.534  24.994  1.00  8.53           O  
ATOM    152  CB  MET    16       1.325   7.241  24.978  1.00  7.51           C  
ATOM    153  CG  MET    16       1.698   7.583  23.517  1.00  8.88           C  
ATOM    154  SD  MET    16       3.579   7.936  23.215  0.75  8.58          SE  
ATOM    155  CE  MET    16       3.470   9.822  22.762  1.00 11.14           C  
ATOM    156  N   ASP    17      -0.734   9.395  25.990  1.00  6.41           N  
ATOM    157  CA  ASP    17      -1.721  10.420  25.724  1.00  7.06           C  
ATOM    158  C   ASP    17      -1.319  11.732  26.416  1.00  7.51           C  
ATOM    159  O   ASP    17      -1.372  12.815  25.830  1.00  8.29           O  
ATOM    160  CB  ASP    17      -3.080   9.966  26.240  1.00  7.74           C  
ATOM    161  CG  ASP    17      -4.196  10.927  25.886  1.00  7.94           C  
ATOM    162  OD1 ASP    17      -4.289  11.351  24.720  1.00  8.94           O  
ATOM    163  OD2 ASP    17      -5.028  11.219  26.778  1.00 11.58           O  
ATOM    164  N   GLU    18      -0.932  11.629  27.682  1.00  7.26           N  
ATOM    165  CA  GLU    18      -0.554  12.836  28.434  1.00  8.48           C  
ATOM    166  C   GLU    18       0.619  13.553  27.809  1.00  7.65           C  
ATOM    167  O   GLU    18       0.628  14.774  27.698  1.00  9.54           O  
ATOM    168  CB  GLU    18      -0.270  12.467  29.894  1.00  9.41           C  
ATOM    169  CG  GLU    18      -1.569  12.133  30.631  1.00 13.91           C  
ATOM    170  CD  GLU    18      -1.395  11.689  32.079  1.00 22.47           C  
ATOM    171  OE1 GLU    18      -0.237  11.582  32.552  1.00 28.94           O  
ATOM    172  OE2 GLU    18      -2.447  11.400  32.719  1.00 26.09           O  
ATOM    173  N   ILE    19       1.617  12.801  27.380  1.00  7.61           N  
ATOM    174  CA  ILE    19       2.804  13.388  26.737  1.00  7.85           C  
ATOM    175  C   ILE    19       2.432  13.988  25.377  1.00  6.82           C  
ATOM    176  O   ILE    19       2.850  15.102  25.029  1.00  8.10           O  
ATOM    177  CB  ILE    19       3.937  12.371  26.646  1.00  8.65           C  
ATOM    178  CG1 ILE    19       4.522  12.143  28.043  1.00 10.43           C  
ATOM    179  CG2 ILE    19       5.033  12.856  25.661  1.00 10.37           C  
ATOM    180  CD1 ILE    19       5.343  13.325  28.598  1.00 14.31           C  
ATOM    181  N   SER    20       1.610  13.265  24.615  1.00  7.24           N  
ATOM    182  CA  SER    20       1.135  13.685  23.306  0.50  7.20           C  
ATOM    184  C   SER    20       0.420  15.055  23.364  1.00  8.01           C  
ATOM    185  O   SER    20       0.459  15.856  22.444  1.00  9.90           O  
ATOM    186  CB  SER    20       0.168  12.600  22.787  0.50  6.57           C  
ATOM    188  OG  SER    20      -0.448  12.996  21.591  0.50 10.00           O  
ATOM    190  N   LYS    21      -0.305  15.269  24.453  1.00  8.12           N  
ATOM    191  CA  LYS    21      -1.128  16.476  24.694  0.52  8.74           C  
ATOM    193  C   LYS    21      -0.354  17.626  25.305  1.00  8.20           C  
ATOM    194  O   LYS    21      -0.855  18.749  25.389  1.00  9.65           O  
ATOM    195  CB  LYS    21      -2.311  16.147  25.637  0.52  8.96           C  
ATOM    197  CG  LYS    21      -3.427  15.322  24.947  0.52 10.89           C  
ATOM    199  CD  LYS    21      -4.560  14.849  25.851  0.52 14.15           C  
ATOM    201  CE  LYS    21      -5.655  14.138  25.022  0.52 14.68           C  
ATOM    203  NZ  LYS    21      -6.579  13.275  25.848  0.52 13.50           N  
ATOM    205  N   THR    22       0.857  17.327  25.765  1.00  8.24           N  
ATOM    206  CA  THR    22       1.672  18.314  26.464  1.00  8.54           C  
ATOM    207  C   THR    22       3.023  18.504  25.783  1.00  8.63           C  
ATOM    208  O   THR    22       3.145  19.231  24.793  1.00  9.20           O  
ATOM    209  CB  THR    22       1.763  18.000  27.992  1.00 10.21           C  
ATOM    210  OG1 THR    22       2.381  16.735  28.229  1.00  9.41           O  
ATOM    211  CG2 THR    22       0.403  18.068  28.666  1.00 11.24           C  
ATOM    212  N   LEU    23       4.030  17.846  26.288  1.00  8.41           N  
ATOM    213  CA  LEU    23       5.393  18.041  25.817  1.00  9.05           C  
ATOM    214  C   LEU    23       5.555  17.805  24.314  1.00  8.93           C  
ATOM    215  O   LEU    23       6.243  18.561  23.636  1.00  9.40           O  
ATOM    216  CB  LEU    23       6.288  17.088  26.585  1.00 10.54           C  
ATOM    217  CG  LEU    23       7.755  17.241  26.300  1.00 13.35           C  
ATOM    218  CD1 LEU    23       8.234  18.660  26.616  1.00 13.77           C  
ATOM    219  CD2 LEU    23       8.515  16.191  27.077  1.00 15.65           C  
ATOM    220  N   PHE    24       4.921  16.768  23.780  1.00  7.77           N  
ATOM    221  CA  PHE    24       5.067  16.460  22.361  1.00  7.58           C  
ATOM    222  C   PHE    24       4.078  17.202  21.464  1.00  7.62           C  
ATOM    223  O   PHE    24       4.204  17.173  20.245  1.00  8.46           O  
ATOM    224  CB  PHE    24       4.886  14.960  22.066  1.00  7.43           C  
ATOM    225  CG  PHE    24       6.000  14.056  22.471  1.00  7.96           C  
ATOM    226  CD1 PHE    24       7.061  14.462  23.247  1.00  8.92           C  
ATOM    227  CD2 PHE    24       5.931  12.739  22.097  1.00  8.54           C  
ATOM    228  CE1 PHE    24       8.022  13.538  23.649  1.00  9.73           C  
ATOM    229  CE2 PHE    24       6.904  11.835  22.495  1.00 10.13           C  
ATOM    230  CZ  PHE    24       7.948  12.221  23.230  1.00  9.82           C  
ATOM    231  N   ALA    25       3.091  17.867  22.052  1.00  8.31           N  
ATOM    232  CA  ALA    25       2.015  18.435  21.232  1.00  8.01           C  
ATOM    233  C   ALA    25       2.484  19.228  20.000  1.00  8.06           C  
ATOM    234  O   ALA    25       1.914  19.078  18.920  1.00  8.05           O  
ATOM    235  CB  ALA    25       1.051  19.291  22.060  1.00  9.40           C  
ATOM    236  N   PRO    26       3.494  20.097  20.126  1.00  8.11           N  
ATOM    237  CA  PRO    26       3.866  20.886  18.956  1.00  8.19           C  
ATOM    238  C   PRO    26       4.464  20.111  17.785  1.00  7.84           C  
ATOM    239  O   PRO    26       4.461  20.600  16.647  1.00  8.42           O  
ATOM    240  CB  PRO    26       4.912  21.858  19.489  1.00 10.25           C  
ATOM    241  CG  PRO    26       5.213  21.496  20.784  1.00 15.30           C  
ATOM    242  CD  PRO    26       4.235  20.516  21.324  1.00  9.57           C  
ATOM    243  N   ILE    27       4.940  18.897  18.046  1.00  7.18           N  
ATOM    244  CA  ILE    27       5.610  18.172  16.962  1.00  7.05           C  
ATOM    245  C   ILE    27       4.629  17.692  15.910  1.00  6.91           C  
ATOM    246  O   ILE    27       5.002  17.552  14.740  1.00  7.44           O  
ATOM    247  CB  ILE    27       6.453  16.990  17.458  1.00  7.30           C  
ATOM    248  CG1 ILE    27       5.629  15.768  17.830  1.00  7.74           C  
ATOM    249  CG2 ILE    27       7.385  17.453  18.598  1.00  8.53           C  
ATOM    250  CD1 ILE    27       6.414  14.665  18.487  1.00  9.05           C  
ATOM    251  N   TYR    28       3.379  17.437  16.300  1.00  6.72           N  
ATOM    252  CA  TYR    28       2.470  16.771  15.368  1.00  7.01           C  
ATOM    253  C   TYR    28       2.098  17.686  14.170  1.00  6.99           C  
ATOM    254  O   TYR    28       2.157  17.224  13.039  1.00  7.14           O  
ATOM    255  CB  TYR    28       1.268  16.172  16.092  1.00  7.55           C  
ATOM    256  CG  TYR    28       1.700  15.172  17.130  1.00  6.77           C  
ATOM    257  CD1 TYR    28       2.076  13.900  16.777  1.00  7.31           C  
ATOM    258  CD2 TYR    28       1.712  15.496  18.476  1.00  7.57           C  
ATOM    259  CE1 TYR    28       2.502  12.982  17.725  1.00  6.97           C  
ATOM    260  CE2 TYR    28       2.133  14.588  19.435  1.00  7.99           C  
ATOM    261  CZ  TYR    28       2.498  13.336  19.065  1.00  7.33           C  
ATOM    262  OH  TYR    28       2.883  12.442  20.051  1.00  9.14           O  
ATOM    263  N   PRO    29       1.728  18.953  14.417  1.00  6.96           N  
ATOM    264  CA  PRO    29       1.485  19.814  13.265  1.00  7.46           C  
ATOM    265  C   PRO    29       2.723  20.018  12.400  1.00  7.10           C  
ATOM    266  O   PRO    29       2.605  20.183  11.192  1.00  7.69           O  
ATOM    267  CB  PRO    29       0.974  21.118  13.866  1.00  8.48           C  
ATOM    268  CG  PRO    29       1.138  20.983  15.303  1.00 13.62           C  
ATOM    269  CD  PRO    29       1.334  19.581  15.680  1.00  8.11           C  
ATOM    270  N   ILE    30       3.905  20.050  13.004  1.00  7.19           N  
ATOM    271  CA  ILE    30       5.143  20.237  12.242  1.00  6.88           C  
ATOM    272  C   ILE    30       5.403  19.006  11.355  1.00  7.03           C  
ATOM    273  O   ILE    30       5.741  19.136  10.183  1.00  7.09           O  
ATOM    274  CB  ILE    30       6.351  20.520  13.169  1.00  7.04           C  
ATOM    275  CG1 ILE    30       6.168  21.881  13.877  1.00  8.69           C  
ATOM    276  CG2 ILE    30       7.679  20.458  12.422  1.00  9.30           C  
ATOM    277  CD1 ILE    30       6.185  23.079  12.950  1.00 10.79           C  
ATOM    278  N   ILE    31       5.272  17.819  11.925  1.00  6.61           N  
ATOM    279  CA  ILE    31       5.492  16.611  11.159  1.00  6.92           C  
ATOM    280  C   ILE    31       4.456  16.528  10.042  1.00  6.73           C  
ATOM    281  O   ILE    31       4.786  16.171   8.892  1.00  6.99           O  
ATOM    282  CB  ILE    31       5.472  15.375  12.054  1.00  7.14           C  
ATOM    283  CG1 ILE    31       6.700  15.397  12.998  1.00  6.96           C  
ATOM    284  CG2 ILE    31       5.478  14.099  11.208  1.00  8.22           C  
ATOM    285  CD1 ILE    31       6.661  14.361  14.125  1.00  8.75           C  
ATOM    286  N   ALA    32       3.195  16.817  10.341  1.00  6.98           N  
ATOM    287  CA  ALA    32       2.162  16.816   9.305  1.00  7.60           C  
ATOM    288  C   ALA    32       2.490  17.772   8.173  1.00  6.55           C  
ATOM    289  O   ALA    32       2.366  17.453   6.998  1.00  6.98           O  
ATOM    290  CB  ALA    32       0.793  17.136   9.928  1.00  7.82           C  
ATOM    291  N   GLU    33       2.943  18.965   8.533  1.00  6.56           N  
ATOM    292  CA  GLU    33       3.330  19.953   7.552  1.00  7.54           C  
ATOM    293  C   GLU    33       4.509  19.462   6.732  1.00  7.00           C  
ATOM    294  O   GLU    33       4.548  19.633   5.506  1.00  7.66           O  
ATOM    295  CB  GLU    33       3.661  21.262   8.272  1.00  7.76           C  
ATOM    296  CG  GLU    33       4.174  22.352   7.390  1.00 10.06           C  
ATOM    297  CD  GLU    33       4.400  23.640   8.136  1.00 12.92           C  
ATOM    298  OE1 GLU    33       5.047  23.663   9.184  1.00 17.46           O  
ATOM    299  OE2 GLU    33       3.891  24.633   7.658  1.00 18.89           O  
ATOM    300  N   ASN    34       5.482  18.836   7.386  1.00  7.18           N  
ATOM    301  CA  ASN    34       6.636  18.291   6.686  1.00  7.24           C  
ATOM    302  C   ASN    34       6.184  17.268   5.636  1.00  7.17           C  
ATOM    303  O   ASN    34       6.698  17.263   4.500  1.00  7.61           O  
ATOM    304  CB  ASN    34       7.619  17.610   7.640  1.00  7.23           C  
ATOM    305  CG  ASN    34       8.377  18.580   8.503  1.00  8.40           C  
ATOM    306  OD1 ASN    34       8.422  19.779   8.205  1.00  9.80           O  
ATOM    307  ND2 ASN    34       9.018  18.060   9.551  1.00  9.22           N  
ATOM    308  N   ILE    35       5.227  16.404   6.002  1.00  7.02           N  
ATOM    309  CA  ILE    35       4.750  15.360   5.117  1.00  7.18           C  
ATOM    310  C   ILE    35       4.006  15.973   3.924  1.00  6.48           C  
ATOM    311  O   ILE    35       4.217  15.581   2.755  1.00  7.12           O  
ATOM    312  CB  ILE    35       3.846  14.379   5.893  1.00  7.39           C  
ATOM    313  CG1 ILE    35       4.678  13.599   6.915  1.00  8.00           C  
ATOM    314  CG2 ILE    35       3.077  13.456   4.933  1.00  9.13           C  
ATOM    315  CD1 ILE    35       3.808  12.938   7.996  1.00  9.04           C  
ATOM    316  N   ILE    36       3.135  16.920   4.199  1.00  6.43           N  
ATOM    317  CA  ILE    36       2.396  17.615   3.134  1.00  6.88           C  
ATOM    318  C   ILE    36       3.357  18.290   2.181  1.00  7.45           C  
ATOM    319  O   ILE    36       3.210  18.201   0.954  1.00  7.42           O  
ATOM    320  CB  ILE    36       1.361  18.589   3.754  1.00  7.55           C  
ATOM    321  CG1 ILE    36       0.248  17.777   4.421  1.00  8.70           C  
ATOM    322  CG2 ILE    36       0.837  19.572   2.683  1.00  9.97           C  
ATOM    323  CD1 ILE    36      -0.653  18.558   5.339  1.00 12.24           C  
ATOM    324  N   ASN    37       4.329  18.991   2.745  1.00  7.38           N  
ATOM    325  CA  ASN    37       5.276  19.736   1.919  1.00  8.10           C  
ATOM    326  C   ASN    37       6.164  18.813   1.110  1.00  7.67           C  
ATOM    327  O   ASN    37       6.515  19.126  -0.030  1.00  9.85           O  
ATOM    328  CB  ASN    37       6.151  20.633   2.769  1.00  8.87           C  
ATOM    329  CG  ASN    37       5.412  21.835   3.316  1.00 10.85           C  
ATOM    330  OD1 ASN    37       4.281  22.121   2.904  1.00 12.97           O  
ATOM    331  ND2 ASN    37       6.019  22.525   4.284  1.00 13.28           N  
ATOM    332  N   ARG    38       6.538  17.670   1.678  1.00  7.47           N  
ATOM    333  CA  ARG    38       7.474  16.807   1.003  0.52  8.07           C  
ATOM    335  C   ARG    38       6.876  16.121  -0.239  1.00 10.01           C  
ATOM    336  O   ARG    38       7.538  16.008  -1.253  1.00 10.10           O  
ATOM    337  CB  ARG    38       8.042  15.816   2.010  0.52  7.49           C  
ATOM    339  CG  ARG    38       9.277  15.167   1.514  0.52  7.20           C  
ATOM    341  CD  ARG    38       9.981  14.327   2.572  0.52  7.52           C  
ATOM    343  NE  ARG    38      11.111  13.683   1.952  0.52  6.54           N  
ATOM    345  CZ  ARG    38      12.386  13.780   2.326  0.52  8.59           C  
ATOM    347  NH1 ARG    38      12.775  14.317   3.477  0.52  7.08           N  
ATOM    349  NH2 ARG    38      13.282  13.207   1.572  0.52  7.93           N  
ATOM    351  N   PHE    39       5.654  15.552  -0.094  1.00  9.61           N  
ATOM    352  CA  PHE    39       5.065  14.786  -1.146  1.00  8.65           C  
ATOM    353  C   PHE    39       3.976  15.460  -1.928  1.00  8.39           C  
ATOM    354  O   PHE    39       3.674  15.014  -3.023  1.00  9.72           O  
ATOM    355  CB  PHE    39       4.540  13.467  -0.594  1.00  8.88           C  
ATOM    356  CG  PHE    39       5.532  12.708   0.247  1.00  8.23           C  
ATOM    357  CD1 PHE    39       6.722  12.259  -0.278  1.00  8.94           C  
ATOM    358  CD2 PHE    39       5.284  12.480   1.575  1.00 10.04           C  
ATOM    359  CE1 PHE    39       7.620  11.571   0.495  1.00  9.70           C  
ATOM    360  CE2 PHE    39       6.179  11.796   2.364  1.00 12.97           C  
ATOM    361  CZ  PHE    39       7.356  11.341   1.817  1.00 12.09           C  
ATOM    362  N   GLY    40       3.388  16.521  -1.409  1.00  7.85           N  
ATOM    363  CA  GLY    40       2.312  17.174  -2.138  1.00  8.79           C  
ATOM    364  C   GLY    40       1.030  16.367  -2.229  1.00  8.85           C  
ATOM    365  O   GLY    40       0.188  16.673  -3.083  1.00 10.77           O  
ATOM    366  N   ILE    41       0.882  15.345  -1.375  1.00  8.99           N  
ATOM    367  CA  ILE    41      -0.336  14.518  -1.300  1.00  9.47           C  
ATOM    368  C   ILE    41      -1.213  15.140  -0.236  1.00  8.66           C  
ATOM    369  O   ILE    41      -0.787  15.277   0.913  1.00  9.73           O  
ATOM    370  CB  ILE    41      -0.058  13.034  -0.988  1.00  9.34           C  
ATOM    371  CG1 ILE    41       1.083  12.448  -1.847  1.00  9.24           C  
ATOM    372  CG2 ILE    41      -1.336  12.233  -1.198  1.00 10.11           C  
ATOM    373  CD1 ILE    41       1.665  11.148  -1.289  1.00 12.39           C  
ATOM    374  N   THR    42      -2.415  15.581  -0.628  1.00  9.48           N  
ATOM    375  CA  THR    42      -3.275  16.361   0.307  1.00 10.42           C  
ATOM    376  C   THR    42      -4.692  15.755   0.480  1.00  9.48           C  
ATOM    377  O   THR    42      -5.541  16.311   1.133  1.00 10.21           O  
ATOM    378  CB  THR    42      -3.376  17.807  -0.171  1.00 11.69           C  
ATOM    379  OG1 THR    42      -3.894  17.844  -1.506  1.00 14.96           O  
ATOM    380  CG2 THR    42      -2.011  18.491  -0.160  1.00 14.68           C  
ATOM    381  N   ALA    43      -4.956  14.730  -0.309  1.00  9.15           N  
ATOM    382  CA  ALA    43      -6.217  14.028  -0.314  1.00  9.37           C  
ATOM    383  C   ALA    43      -6.043  12.572  -0.708  1.00  9.19           C  
ATOM    384  O   ALA    43      -4.960  12.147  -1.105  1.00 11.46           O  
ATOM    385  CB  ALA    43      -7.258  14.742  -1.240  1.00 10.44           C  
ATOM    386  N   GLY    44      -7.126  11.829  -0.664  1.00 10.43           N  
ATOM    387  CA  GLY    44      -7.098  10.385  -0.901  1.00 10.01           C  
ATOM    388  C   GLY    44      -7.096   9.682   0.450  1.00 10.00           C  
ATOM    389  O   GLY    44      -7.731  10.144   1.407  1.00 11.67           O  
ATOM    390  N   ASN    45      -6.362   8.594   0.535  1.00  8.32           N  
ATOM    391  CA  ASN    45      -6.335   7.768   1.732  1.00  8.24           C  
ATOM    392  C   ASN    45      -4.975   7.794   2.398  1.00  8.40           C  
ATOM    393  O   ASN    45      -3.927   7.720   1.753  1.00  9.29           O  
ATOM    394  CB  ASN    45      -6.695   6.336   1.331  1.00  9.68           C  
ATOM    397  N   CYS    46      -5.000   7.940   3.707  1.00  7.79           N  
ATOM    398  CA  CYS    46      -3.796   7.934   4.538  1.00  7.37           C  
ATOM    399  C   CYS    46      -3.960   6.957   5.687  1.00  6.93           C  
ATOM    400  O   CYS    46      -4.992   6.985   6.372  1.00  8.49           O  
ATOM    401  CB  CYS    46      -3.532   9.335   5.099  1.00  8.02           C  
ATOM    402  SG  CYS    46      -2.142   9.452   6.229  1.00 10.58           S  
ATOM    403  N   ILE    47      -2.977   6.083   5.859  1.00  6.83           N  
ATOM    404  CA  ILE    47      -2.969   5.136   6.973  1.00  6.92           C  
ATOM    405  C   ILE    47      -1.869   5.568   7.934  1.00  6.74           C  
ATOM    406  O   ILE    47      -0.734   5.773   7.511  1.00  7.56           O  
ATOM    407  CB  ILE    47      -2.696   3.684   6.527  1.00  8.48           C  
ATOM    408  CG1 ILE    47      -3.578   3.260   5.350  1.00 10.58           C  
ATOM    409  CG2 ILE    47      -2.814   2.742   7.694  1.00 10.64           C  
ATOM    410  CD1 ILE    47      -5.056   3.398   5.512  1.00 12.24           C  
ATOM    411  N   ASP    48      -2.222   5.749   9.213  1.00  7.07           N  
ATOM    412  CA  ASP    48      -1.302   6.081  10.300  1.00  6.60           C  
ATOM    413  C   ASP    48      -1.114   4.801  11.114  1.00  6.67           C  
ATOM    414  O   ASP    48      -2.003   4.357  11.833  1.00  8.14           O  
ATOM    415  CB  ASP    48      -1.906   7.217  11.122  1.00  7.17           C  
ATOM    416  CG  ASP    48      -1.052   7.660  12.289  1.00  7.98           C  
ATOM    417  OD1 ASP    48       0.114   7.232  12.370  1.00  9.38           O  
ATOM    418  OD2 ASP    48      -1.585   8.439  13.116  1.00  8.93           O  
ATOM    419  N   ILE    49       0.060   4.189  10.967  1.00  6.49           N  
ATOM    420  CA  ILE    49       0.363   2.908  11.602  1.00  6.46           C  
ATOM    421  C   ILE    49       0.972   3.136  12.977  1.00  6.15           C  
ATOM    422  O   ILE    49       1.947   3.859  13.134  1.00  7.92           O  
ATOM    423  CB  ILE    49       1.274   2.053  10.725  1.00  7.77           C  
ATOM    424  CG1 ILE    49       0.588   1.788   9.356  1.00  9.01           C  
ATOM    425  CG2 ILE    49       1.630   0.728  11.446  1.00  8.68           C  
ATOM    426  CD1 ILE    49       1.448   0.984   8.392  1.00 10.96           C  
ATOM    427  N   GLY    50       0.397   2.484  13.975  1.00  6.58           N  
ATOM    428  CA  GLY    50       0.799   2.677  15.352  1.00  6.69           C  
ATOM    429  C   GLY    50       0.390   4.064  15.811  1.00  6.03           C  
ATOM    430  O   GLY    50       1.177   4.805  16.412  1.00  7.71           O  
ATOM    431  N   SER    51      -0.872   4.400  15.538  1.00  6.38           N  
ATOM    432  CA  SER    51      -1.406   5.722  15.732  1.00  6.50           C  
ATOM    433  C   SER    51      -1.492   6.169  17.198  1.00  6.71           C  
ATOM    434  O   SER    51      -1.535   7.367  17.477  1.00  7.54           O  
ATOM    435  CB  SER    51      -2.787   5.792  15.058  1.00  7.66           C  
ATOM    436  OG  SER    51      -3.566   4.627  15.335  1.00  7.63           O  
ATOM    437  N   GLY    52      -1.540   5.209  18.122  1.00  6.79           N  
ATOM    438  CA  GLY    52      -1.511   5.535  19.525  1.00  7.71           C  
ATOM    439  C   GLY    52      -2.698   6.405  19.913  1.00  7.28           C  
ATOM    440  O   GLY    52      -3.822   6.137  19.521  1.00  7.82           O  
ATOM    441  N   PRO    53      -2.472   7.474  20.700  1.00  7.60           N  
ATOM    442  CA  PRO    53      -3.569   8.361  21.066  1.00  8.11           C  
ATOM    443  C   PRO    53      -4.139   9.195  19.911  1.00  7.80           C  
ATOM    444  O   PRO    53      -5.121   9.900  20.106  1.00  8.40           O  
ATOM    445  CB  PRO    53      -2.948   9.283  22.121  1.00 10.37           C  
ATOM    446  CG  PRO    53      -1.764   8.546  22.652  1.00 11.26           C  
ATOM    447  CD  PRO    53      -1.246   7.779  21.461  1.00  9.95           C  
ATOM    448  N   GLY    54      -3.515   9.113  18.725  1.00  7.73           N  
ATOM    449  CA  GLY    54      -4.052   9.702  17.521  1.00  7.97           C  
ATOM    450  C   GLY    54      -3.551  11.055  17.113  1.00  7.36           C  
ATOM    451  O   GLY    54      -4.084  11.644  16.173  1.00  8.91           O  
ATOM    452  N   ALA    55      -2.528  11.586  17.785  1.00  8.21           N  
ATOM    453  CA  ALA    55      -2.156  12.975  17.554  1.00  8.70           C  
ATOM    454  C   ALA    55      -1.640  13.243  16.152  1.00  7.97           C  
ATOM    455  O   ALA    55      -1.848  14.334  15.648  1.00  9.08           O  
ATOM    456  CB  ALA    55      -1.178  13.479  18.609  1.00 11.23           C  
ATOM    457  N   LEU    56      -0.946  12.297  15.527  1.00  7.81           N  
ATOM    458  CA  LEU    56      -0.446  12.560  14.163  1.00  8.20           C  
ATOM    459  C   LEU    56      -1.617  12.570  13.176  1.00  7.59           C  
ATOM    460  O   LEU    56      -1.687  13.404  12.287  1.00  8.15           O  
ATOM    461  CB  LEU    56       0.637  11.561  13.728  1.00  8.89           C  
ATOM    462  CG  LEU    56       1.266  11.813  12.358  1.00  9.14           C  
ATOM    463  CD1 LEU    56       1.879  13.237  12.252  1.00 11.63           C  
ATOM    464  CD2 LEU    56       2.290  10.716  12.080  1.00 11.52           C  
ATOM    465  N   SER    57      -2.551  11.652  13.357  1.00  7.75           N  
ATOM    466  CA  SER    57      -3.743  11.610  12.512  1.00  7.27           C  
ATOM    467  C   SER    57      -4.557  12.903  12.649  1.00  7.41           C  
ATOM    468  O   SER    57      -5.066  13.452  11.671  1.00  7.91           O  
ATOM    469  CB  SER    57      -4.618  10.406  12.841  1.00  8.21           C  
ATOM    470  OG  SER    57      -4.062   9.190  12.378  1.00  8.44           O  
ATOM    471  N   ILE    58      -4.745  13.345  13.890  1.00  7.25           N  
ATOM    472  CA  ILE    58      -5.480  14.585  14.156  1.00  7.79           C  
ATOM    473  C   ILE    58      -4.773  15.785  13.471  1.00  7.84           C  
ATOM    474  O   ILE    58      -5.433  16.583  12.792  1.00  8.09           O  
ATOM    475  CB  ILE    58      -5.685  14.796  15.672  1.00  8.23           C  
ATOM    476  CG1 ILE    58      -6.683  13.739  16.214  1.00  9.21           C  
ATOM    477  CG2 ILE    58      -6.082  16.223  15.953  1.00 10.08           C  
ATOM    478  CD1 ILE    58      -6.760  13.695  17.734  1.00 11.50           C  
ATOM    479  N   ALA    59      -3.452  15.866  13.587  1.00  8.01           N  
ATOM    480  CA  ALA    59      -2.736  16.967  12.980  1.00  8.60           C  
ATOM    481  C   ALA    59      -2.859  16.937  11.458  1.00  8.17           C  
ATOM    482  O   ALA    59      -3.075  17.959  10.817  1.00  9.25           O  
ATOM    483  CB  ALA    59      -1.268  16.929  13.417  1.00  9.10           C  
ATOM    484  N   LEU    60      -2.754  15.752  10.874  1.00  8.03           N  
ATOM    485  CA  LEU    60      -2.905  15.615   9.418  0.76  8.55           C  
ATOM    487  C   LEU    60      -4.306  15.997   8.963  1.00  8.29           C  
ATOM    488  O   LEU    60      -4.483  16.669   7.945  1.00  9.33           O  
ATOM    489  CB  LEU    60      -2.542  14.195   8.942  0.76  8.80           C  
ATOM    491  CG  LEU    60      -1.070  13.885   8.762  0.76  8.87           C  
ATOM    493  CD1 LEU    60      -0.846  12.360   8.732  0.76 11.37           C  
ATOM    495  CD2 LEU    60      -0.509  14.531   7.485  0.76  9.21           C  
ATOM    497  N   ALA    61      -5.316  15.564   9.715  1.00  8.32           N  
ATOM    498  CA  ALA    61      -6.703  15.897   9.354  1.00  7.81           C  
ATOM    499  C   ALA    61      -6.910  17.405   9.315  1.00  8.61           C  
ATOM    500  O   ALA    61      -7.605  17.940   8.454  1.00  9.99           O  
ATOM    501  CB  ALA    61      -7.672  15.232  10.329  1.00  9.68           C  
ATOM    502  N   LYS    62      -6.312  18.105  10.265  1.00  8.27           N  
ATOM    503  CA  LYS    62      -6.511  19.548  10.351  1.00 10.14           C  
ATOM    504  C   LYS    62      -5.826  20.333   9.239  1.00 10.18           C  
ATOM    505  O   LYS    62      -6.210  21.467   8.971  1.00 13.87           O  
ATOM    506  CB  LYS    62      -6.037  20.060  11.707  1.00 10.06           C  
ATOM    507  CG  LYS    62      -6.911  19.610  12.875  1.00 12.40           C  
ATOM    508  CD  LYS    62      -6.321  20.107  14.178  1.00 15.89           C  
ATOM    509  CE  LYS    62      -7.123  19.696  15.395  1.00 21.55           C  
ATOM    510  NZ  LYS    62      -6.366  20.077  16.635  1.00 25.13           N  
ATOM    511  N   GLN    63      -4.879  19.706   8.559  1.00  8.63           N  
ATOM    512  CA  GLN    63      -4.116  20.380   7.512  1.00  8.33           C  
ATOM    513  C   GLN    63      -4.371  19.866   6.115  1.00  8.54           C  
ATOM    514  O   GLN    63      -3.744  20.365   5.180  1.00 10.07           O  
ATOM    515  CB  GLN    63      -2.608  20.289   7.767  1.00  9.53           C  
ATOM    516  CG  GLN    63      -2.132  21.066   8.946  1.00  9.43           C  
ATOM    517  CD  GLN    63      -0.626  21.029   9.102  1.00  9.46           C  
ATOM    518  OE1 GLN    63       0.141  21.216   8.140  1.00 10.56           O  
ATOM    519  NE2 GLN    63      -0.199  20.877  10.335  1.00 10.08           N  
ATOM    520  N   SER    64      -5.287  18.914   5.933  1.00  8.57           N  
ATOM    521  CA  SER    64      -5.479  18.261   4.636  1.00  9.29           C  
ATOM    522  C   SER    64      -6.902  17.778   4.470  1.00  9.12           C  
ATOM    523  O   SER    64      -7.704  17.887   5.394  1.00  9.90           O  
ATOM    524  CB  SER    64      -4.581  17.021   4.542  1.00 10.86           C  
ATOM    525  OG  SER    64      -5.081  15.978   5.391  1.00 12.56           O  
ATOM    526  N   ASP    65      -7.146  17.145   3.326  1.00  8.63           N  
ATOM    527  CA  ASP    65      -8.441  16.564   2.997  1.00  8.06           C  
ATOM    528  C   ASP    65      -8.403  15.029   2.964  1.00  8.02           C  
ATOM    529  O   ASP    65      -9.255  14.405   2.356  1.00 10.25           O  
ATOM    530  CB  ASP    65      -8.965  17.103   1.651  1.00  8.89           C  
ATOM    531  CG  ASP    65      -9.006  18.598   1.610  1.00 10.85           C  
ATOM    532  OD1 ASP    65      -9.445  19.186   2.588  1.00 13.30           O  
ATOM    533  OD2 ASP    65      -8.576  19.191   0.595  1.00  9.68           O  
ATOM    534  N   PHE    66      -7.401  14.428   3.580  1.00  7.91           N  
ATOM    535  CA  PHE    66      -7.343  12.989   3.603  1.00  8.61           C  
ATOM    536  C   PHE    66      -8.453  12.304   4.378  1.00  7.63           C  
ATOM    537  O   PHE    66      -8.965  12.850   5.360  1.00  8.56           O  
ATOM    538  CB  PHE    66      -6.057  12.491   4.328  1.00  9.45           C  
ATOM    539  CG  PHE    66      -4.795  12.575   3.523  1.00  8.86           C  
ATOM    540  CD1 PHE    66      -4.565  11.692   2.481  1.00  9.16           C  
ATOM    541  CD2 PHE    66      -3.790  13.435   3.872  1.00 10.05           C  
ATOM    542  CE1 PHE    66      -3.384  11.729   1.776  1.00  9.50           C  
ATOM    543  CE2 PHE    66      -2.602  13.475   3.144  1.00 10.62           C  
ATOM    544  CZ  PHE    66      -2.412  12.618   2.118  1.00 10.79           C  
ATOM    545  N   SER    67      -8.799  11.109   3.900  1.00  7.80           N  
ATOM    546  CA  SER    67      -9.575  10.149   4.672  0.48  7.51           C  
ATOM    549  C   SER    67      -8.512   9.324   5.388  1.00  7.49           C  
ATOM    550  O   SER    67      -7.698   8.663   4.745  1.00  9.48           O  
ATOM    551  CB  SER    67     -10.411   9.241   3.776  0.48  8.28           C  
ATOM    554  OG  SER    67     -11.327   9.975   2.955  0.48 10.11           O  
ATOM    557  N   ILE    68      -8.496   9.367   6.710  1.00  7.00           N  
ATOM    558  CA  ILE    68      -7.434   8.716   7.495  1.00  7.24           C  
ATOM    559  C   ILE    68      -7.918   7.521   8.263  1.00  6.90           C  
ATOM    560  O   ILE    68      -9.043   7.525   8.805  1.00  7.69           O  
ATOM    561  CB  ILE    68      -6.872   9.760   8.505  1.00  7.71           C  
ATOM    562  CG1 ILE    68      -6.289  10.976   7.751  1.00  8.62           C  
ATOM    563  CG2 ILE    68      -5.800   9.127   9.439  1.00  9.32           C  
ATOM    564  CD1 ILE    68      -6.111  12.217   8.602  1.00 12.10           C  
ATOM    565  N   ARG    69      -7.104   6.471   8.250  1.00  7.48           N  
ATOM    566  CA  ARG    69      -7.347   5.293   9.095  0.61  8.21           C  
ATOM    568  C   ARG    69      -6.157   5.189  10.026  1.00  8.11           C  
ATOM    569  O   ARG    69      -4.998   5.202   9.601  1.00  9.74           O  
ATOM    570  CB  ARG    69      -7.496   4.020   8.300  0.61  9.63           C  
ATOM    572  CG  ARG    69      -8.781   4.018   7.536  0.61 11.35           C  
ATOM    574  CD  ARG    69      -8.976   2.762   6.779  0.61 16.48           C  
ATOM    576  NE  ARG    69     -10.115   2.894   5.885  0.61 17.32           N  
ATOM    578  CZ  ARG    69     -10.615   1.895   5.178  0.61 21.59           C  
ATOM    580  NH1 ARG    69     -10.051   0.697   5.246  0.61 26.13           N  
ATOM    582  NH2 ARG    69     -11.671   2.106   4.393  0.61 28.13           N  
ATOM    584  N   ALA    70      -6.461   5.169  11.310  1.00  7.66           N  
ATOM    585  CA  ALA    70      -5.496   5.103  12.415  1.00  7.76           C  
ATOM    586  C   ALA    70      -5.467   3.679  12.936  1.00  7.29           C  
ATOM    587  O   ALA    70      -6.409   3.202  13.557  1.00  8.29           O  
ATOM    588  CB  ALA    70      -5.913   6.079  13.493  1.00  8.97           C  
ATOM    589  N   LEU    71      -4.387   2.974  12.603  1.00  6.50           N  
ATOM    590  CA  LEU    71      -4.237   1.560  12.921  1.00  7.24           C  
ATOM    591  C   LEU    71      -3.357   1.378  14.154  1.00  6.48           C  
ATOM    592  O   LEU    71      -2.228   1.856  14.201  1.00  7.37           O  
ATOM    593  CB  LEU    71      -3.557   0.870  11.729  1.00  7.97           C  
ATOM    594  CG  LEU    71      -3.259  -0.619  11.891  1.00  8.45           C  
ATOM    595  CD1 LEU    71      -4.535  -1.453  11.817  1.00 10.23           C  
ATOM    596  CD2 LEU    71      -2.287  -1.128  10.823  1.00 11.95           C  
ATOM    597  N   ASP    72      -3.857   0.666  15.143  1.00  7.11           N  
ATOM    598  CA  ASP    72      -3.058   0.368  16.333  1.00  6.22           C  
ATOM    599  C   ASP    72      -3.479  -0.977  16.901  1.00  6.55           C  
ATOM    600  O   ASP    72      -4.660  -1.320  16.882  1.00  7.28           O  
ATOM    601  CB  ASP    72      -3.210   1.474  17.369  1.00  7.24           C  
ATOM    602  CG  ASP    72      -2.052   1.496  18.358  1.00  7.04           C  
ATOM    603  OD1 ASP    72      -1.958   0.596  19.211  1.00  7.74           O  
ATOM    604  OD2 ASP    72      -1.204   2.424  18.262  1.00  7.78           O  
ATOM    605  N   PHE    73      -2.521  -1.745  17.392  1.00  6.76           N  
ATOM    606  CA  PHE    73      -2.785  -3.063  17.933  1.00  6.81           C  
ATOM    607  C   PHE    73      -3.192  -3.074  19.382  1.00  6.80           C  
ATOM    608  O   PHE    73      -3.543  -4.141  19.891  1.00  8.21           O  
ATOM    609  CB  PHE    73      -1.632  -4.070  17.627  1.00  7.26           C  
ATOM    610  CG  PHE    73      -0.408  -3.996  18.517  1.00  7.03           C  
ATOM    611  CD1 PHE    73      -0.103  -2.904  19.316  1.00  7.74           C  
ATOM    612  CD2 PHE    73       0.468  -5.064  18.492  1.00  8.56           C  
ATOM    613  CE1 PHE    73       1.057  -2.920  20.091  1.00  8.30           C  
ATOM    614  CE2 PHE    73       1.611  -5.070  19.245  1.00 10.15           C  
ATOM    615  CZ  PHE    73       1.916  -3.997  20.054  1.00  9.14           C  
ATOM    616  N   SER    74      -3.220  -1.909  20.032  1.00  7.40           N  
ATOM    617  CA  SER    74      -3.577  -1.811  21.438  1.00  7.37           C  
ATOM    618  C   SER    74      -4.983  -1.276  21.611  1.00  7.52           C  
ATOM    619  O   SER    74      -5.278  -0.117  21.260  1.00  7.51           O  
ATOM    620  CB  SER    74      -2.592  -0.915  22.189  1.00  8.08           C  
ATOM    621  OG  SER    74      -3.141  -0.600  23.453  1.00  7.86           O  
ATOM    622  N   LYS    75      -5.874  -2.111  22.137  1.00  7.72           N  
ATOM    623  CA  LYS    75      -7.243  -1.709  22.446  0.50  7.68           C  
ATOM    625  C   LYS    75      -7.239  -0.477  23.337  1.00  7.92           C  
ATOM    626  O   LYS    75      -8.090   0.378  23.236  1.00  8.31           O  
ATOM    627  CB  LYS    75      -7.968  -2.849  23.193  0.50  8.60           C  
ATOM    629  CG  LYS    75      -9.367  -2.509  23.636  0.50 12.08           C  
ATOM    631  CD  LYS    75     -10.242  -2.238  22.487  0.50 16.33           C  
ATOM    633  CE  LYS    75     -11.699  -2.068  22.902  0.50 20.58           C  
ATOM    635  NZ  LYS    75     -12.563  -1.881  21.707  0.50 23.27           N  
ATOM    637  N   HIS    76      -6.295  -0.409  24.277  1.00  8.95           N  
ATOM    638  CA  HIS    76      -6.227   0.715  25.224  1.00  9.08           C  
ATOM    639  C   HIS    76      -5.877   2.024  24.535  1.00  9.07           C  
ATOM    640  O   HIS    76      -6.462   3.065  24.834  1.00  9.81           O  
ATOM    641  CB  HIS    76      -5.234   0.422  26.320  1.00 10.32           C  
ATOM    642  CG  HIS    76      -5.512  -0.864  26.956  1.00 12.91           C  
ATOM    643  ND1 HIS    76      -6.633  -1.045  27.719  1.00 14.05           N  
ATOM    644  CD2 HIS    76      -4.936  -2.075  26.818  1.00 14.52           C  
ATOM    645  CE1 HIS    76      -6.696  -2.310  28.103  1.00 17.11           C  
ATOM    646  NE2 HIS    76      -5.683  -2.958  27.554  1.00 16.00           N  
ATOM    647  N   MET    77      -4.961   1.953  23.581  1.00  8.90           N  
ATOM    648  CA  MET    77      -4.631   3.129  22.776  1.00  9.49           C  
ATOM    649  C   MET    77      -5.863   3.537  21.978  1.00  8.75           C  
ATOM    650  O   MET    77      -6.177   4.714  21.870  1.00  9.24           O  
ATOM    651  CB  MET    77      -3.506   2.837  21.793  1.00 10.74           C  
ATOM    652  CG  MET    77      -2.139   2.700  22.390  1.00 10.69           C  
ATOM    653  SD  MET    77      -1.598   4.441  23.137  0.75  9.35          SE  
ATOM    654  CE  MET    77       0.124   3.861  23.515  1.00 15.04           C  
ATOM    655  N   ASN    78      -6.548   2.563  21.394  1.00  8.02           N  
ATOM    656  CA  ASN    78      -7.679   2.871  20.522  1.00  8.28           C  
ATOM    657  C   ASN    78      -8.843   3.499  21.267  1.00  8.77           C  
ATOM    658  O   ASN    78      -9.546   4.359  20.736  1.00  9.68           O  
ATOM    659  CB  ASN    78      -8.073   1.659  19.685  1.00  8.29           C  
ATOM    660  CG  ASN    78      -7.029   1.345  18.643  1.00  8.37           C  
ATOM    661  OD1 ASN    78      -6.336   2.253  18.171  1.00  9.60           O  
ATOM    662  ND2 ASN    78      -6.911   0.096  18.276  1.00  9.01           N  
ATOM    663  N   GLU    79      -9.033   3.088  22.518  1.00  9.15           N  
ATOM    664  CA  GLU    79     -10.096   3.685  23.340  0.53  9.33           C  
ATOM    666  C   GLU    79      -9.804   5.165  23.561  1.00  9.02           C  
ATOM    667  O   GLU    79     -10.703   6.022  23.470  1.00 10.17           O  
ATOM    668  CB  GLU    79     -10.245   2.954  24.677  0.53 10.77           C  
ATOM    670  CG  GLU    79     -10.824   1.545  24.551  0.53 12.41           C  
ATOM    672  CD  GLU    79     -10.675   0.682  25.807  0.53 20.98           C  
ATOM    674  OE1 GLU    79     -10.045   1.116  26.788  0.53 24.38           O  
ATOM    676  OE2 GLU    79     -11.183  -0.455  25.806  0.53 27.07           O  
ATOM    678  N   ILE    80      -8.553   5.487  23.865  1.00  8.61           N  
ATOM    679  CA  ILE    80      -8.171   6.885  24.073  1.00  9.00           C  
ATOM    680  C   ILE    80      -8.276   7.657  22.745  1.00  8.58           C  
ATOM    681  O   ILE    80      -8.730   8.779  22.727  1.00  8.80           O  
ATOM    682  CB  ILE    80      -6.768   7.009  24.660  1.00  9.84           C  
ATOM    683  CG1 ILE    80      -6.757   6.509  26.078  1.00 12.57           C  
ATOM    684  CG2 ILE    80      -6.278   8.439  24.535  1.00 14.37           C  
ATOM    685  CD1 ILE    80      -5.376   6.543  26.731  1.00 15.85           C  
ATOM    686  N   ALA    81      -7.800   7.050  21.663  1.00  8.09           N  
ATOM    687  CA  ALA    81      -7.807   7.734  20.364  1.00  8.26           C  
ATOM    688  C   ALA    81      -9.247   8.071  19.970  1.00  8.09           C  
ATOM    689  O   ALA    81      -9.524   9.139  19.443  1.00  9.02           O  
ATOM    690  CB  ALA    81      -7.123   6.881  19.289  1.00  9.00           C  
ATOM    691  N   LEU    82     -10.168   7.136  20.206  1.00  8.33           N  
ATOM    692  CA  LEU    82     -11.561   7.378  19.867  0.52  9.58           C  
ATOM    694  C   LEU    82     -12.093   8.620  20.584  1.00  9.47           C  
ATOM    695  O   LEU    82     -12.780   9.465  19.999  1.00 10.24           O  
ATOM    696  CB  LEU    82     -12.439   6.151  20.195  0.52 11.15           C  
ATOM    698  CG  LEU    82     -12.276   4.934  19.274  0.52 10.73           C  
ATOM    700  CD1 LEU    82     -12.788   3.634  19.891  0.52 15.40           C  
ATOM    702  CD2 LEU    82     -12.948   5.175  17.927  0.52 10.68           C  
ATOM    704  N   LYS    83     -11.774   8.727  21.865  1.00  9.39           N  
ATOM    705  CA  LYS    83     -12.185   9.866  22.663  1.00 10.85           C  
ATOM    706  C   LYS    83     -11.520  11.129  22.114  1.00  9.83           C  
ATOM    707  O   LYS    83     -12.163  12.168  21.975  1.00 10.35           O  
ATOM    708  CB  LYS    83     -11.818   9.705  24.137  1.00 11.92           C  
ATOM    709  CG  LYS    83     -12.210  10.893  24.977  1.00 17.87           C  
ATOM    710  CD  LYS    83     -11.780  10.785  26.442  1.00 22.59           C  
ATOM    711  CE  LYS    83     -12.327  11.963  27.272  1.00 24.59           C  
ATOM    712  NZ  LYS    83     -11.687  13.294  26.957  1.00 24.18           N  
ATOM    713  N   ASN    84     -10.218  11.069  21.816  1.00  9.60           N  
ATOM    714  CA  ASN    84      -9.518  12.244  21.313  1.00  9.05           C  
ATOM    715  C   ASN    84     -10.066  12.752  19.982  1.00  8.21           C  
ATOM    716  O   ASN    84     -10.231  13.968  19.778  1.00  9.30           O  
ATOM    717  CB  ASN    84      -8.011  11.971  21.175  1.00  8.02           C  
ATOM    718  CG  ASN    84      -7.310  11.857  22.512  1.00  9.68           C  
ATOM    719  OD1 ASN    84      -7.819  12.367  23.524  1.00 11.50           O  
ATOM    720  ND2 ASN    84      -6.142  11.228  22.538  1.00  8.90           N  
ATOM    721  N   ILE    85     -10.366  11.829  19.076  1.00  8.79           N  
ATOM    722  CA  ILE    85     -10.894  12.158  17.771  0.54  7.79           C  
ATOM    724  C   ILE    85     -12.278  12.804  17.903  1.00  8.39           C  
ATOM    725  O   ILE    85     -12.602  13.793  17.243  1.00  9.86           O  
ATOM    726  CB  ILE    85     -10.876  10.913  16.879  0.54  6.47           C  
ATOM    728  CG1 ILE    85      -9.432  10.550  16.556  0.54  9.65           C  
ATOM    730  CG2 ILE    85     -11.584  11.180  15.583  0.54  8.26           C  
ATOM    732  CD1 ILE    85      -9.270   9.157  16.129  0.54 12.10           C  
ATOM    734  N   ALA    86     -13.074  12.230  18.788  1.00  9.18           N  
ATOM    735  CA  ALA    86     -14.424  12.759  19.032  1.00  9.31           C  
ATOM    736  C   ALA    86     -14.342  14.170  19.652  1.00 10.03           C  
ATOM    737  O   ALA    86     -15.078  15.098  19.269  1.00 11.39           O  
ATOM    738  CB  ALA    86     -15.221  11.821  19.931  1.00 11.37           C  
ATOM    739  N   ASP    87     -13.472  14.336  20.634  1.00 10.44           N  
ATOM    740  CA  ASP    87     -13.315  15.623  21.304  1.00 11.59           C  
ATOM    741  C   ASP    87     -12.910  16.684  20.303  1.00 11.12           C  
ATOM    742  O   ASP    87     -13.283  17.840  20.431  1.00 12.81           O  
ATOM    743  CB  ASP    87     -12.240  15.552  22.380  1.00 12.32           C  
ATOM    744  CG  ASP    87     -12.645  14.822  23.637  1.00 15.89           C  
ATOM    745  OD1 ASP    87     -13.825  14.539  23.843  1.00 17.53           O  
ATOM    746  OD2 ASP    87     -11.754  14.535  24.467  1.00 17.49           O  
ATOM    747  N   ALA    88     -12.123  16.299  19.315  1.00 10.27           N  
ATOM    748  CA  ALA    88     -11.632  17.200  18.272  1.00 11.37           C  
ATOM    749  C   ALA    88     -12.626  17.420  17.135  1.00 11.38           C  
ATOM    750  O   ALA    88     -12.344  18.164  16.201  1.00 12.62           O  
ATOM    751  CB  ALA    88     -10.307  16.697  17.698  1.00 11.36           C  
ATOM    752  N   ASP    89     -13.777  16.756  17.208  1.00 10.69           N  
ATOM    753  CA  ASP    89     -14.796  16.825  16.148  0.49 12.07           C  
ATOM    755  C   ASP    89     -14.249  16.319  14.821  1.00 11.64           C  
ATOM    756  O   ASP    89     -14.501  16.912  13.772  1.00 13.00           O  
ATOM    757  CB  ASP    89     -15.345  18.249  15.991  0.49 13.69           C  
ATOM    759  CG  ASP    89     -16.216  18.668  17.160  0.49 15.45           C  
ATOM    761  OD1 ASP    89     -16.952  17.859  17.725  0.49 16.47           O  
ATOM    763  OD2 ASP    89     -16.148  19.942  17.518  0.49 19.08           N  
ATOM    765  N   LEU    90     -13.515  15.208  14.875  1.00 10.06           N  
ATOM    766  CA  LEU    90     -12.896  14.624  13.694  1.00  9.34           C  
ATOM    767  C   LEU    90     -13.303  13.178  13.407  1.00  8.79           C  
ATOM    768  O   LEU    90     -12.630  12.467  12.684  1.00  8.62           O  
ATOM    769  CB  LEU    90     -11.382  14.738  13.810  1.00  9.05           C  
ATOM    770  CG  LEU    90     -10.842  16.157  13.746  1.00 10.32           C  
ATOM    771  CD1 LEU    90      -9.371  16.121  14.137  1.00 12.89           C  
ATOM    772  CD2 LEU    90     -11.040  16.784  12.365  1.00 13.60           C  
ATOM    773  N   ASN    91     -14.418  12.742  13.962  1.00 10.00           N  
ATOM    774  CA  ASN    91     -14.896  11.371  13.717  0.41 10.39           C  
ATOM    777  C   ASN    91     -15.133  11.097  12.255  1.00  9.16           C  
ATOM    778  O   ASN    91     -15.039   9.957  11.810  1.00 10.41           O  
ATOM    779  CB  ASN    91     -16.205  11.067  14.453  0.41 12.20           C  
ATOM    782  CG  ASN    91     -16.051  11.137  15.929  0.41 13.74           C  
ATOM    785  OD1 ASN    91     -14.981  10.839  16.447  0.41 14.20           O  
ATOM    788  ND2 ASN    91     -17.101  11.528  16.625  0.41 15.67           N  
ATOM    791  N   ASP    92     -15.486  12.139  11.525  1.00  8.87           N  
ATOM    792  CA  ASP    92     -15.703  12.038  10.080  1.00  9.57           C  
ATOM    793  C   ASP    92     -14.416  11.908   9.278  1.00  9.19           C  
ATOM    794  O   ASP    92     -14.467  11.547   8.117  1.00 11.83           O  
ATOM    795  CB  ASP    92     -16.464  13.270   9.561  1.00 11.13           C  
ATOM    796  CG  ASP    92     -15.755  14.592   9.875  1.00 12.48           C  
ATOM    797  OD1 ASP    92     -15.213  14.735  10.979  1.00 15.33           O  
ATOM    798  OD2 ASP    92     -15.714  15.498   9.019  1.00 16.48           O  
ATOM    799  N   ARG    93     -13.296  12.252   9.895  1.00  8.70           N  
ATOM    800  CA  ARG    93     -12.004  12.308   9.205  1.00  8.60           C  
ATOM    801  C   ARG    93     -11.094  11.128   9.474  1.00  8.42           C  
ATOM    802  O   ARG    93     -10.192  10.838   8.652  1.00  8.42           O  
ATOM    803  CB  ARG    93     -11.278  13.589   9.583  1.00  8.88           C  
ATOM    804  CG  ARG    93     -12.061  14.879   9.264  1.00 10.10           C  
ATOM    805  CD  ARG    93     -12.375  15.021   7.752  1.00 10.78           C  
ATOM    806  NE  ARG    93     -11.154  14.900   6.981  1.00  9.70           N  
ATOM    807  CZ  ARG    93     -10.140  15.754   7.001  1.00  9.21           C  
ATOM    808  NH1 ARG    93     -10.204  16.913   7.631  1.00 10.09           N  
ATOM    809  NH2 ARG    93      -9.042  15.429   6.379  1.00  9.76           N  
ATOM    810  N   ILE    94     -11.255  10.500  10.639  1.00  7.68           N  
ATOM    811  CA  ILE    94     -10.338   9.492  11.106  1.00  7.34           C  
ATOM    812  C   ILE    94     -11.125   8.296  11.635  1.00  8.11           C  
ATOM    813  O   ILE    94     -11.981   8.427  12.502  1.00 10.46           O  
ATOM    814  CB  ILE    94      -9.452  10.016  12.246  1.00  8.13           C  
ATOM    815  CG1 ILE    94      -8.662  11.242  11.805  1.00  8.13           C  
ATOM    816  CG2 ILE    94      -8.480   8.920  12.750  1.00  8.96           C  
ATOM    817  CD1 ILE    94      -8.146  12.102  12.990  1.00  9.32           C  
ATOM    818  N   GLN    95     -10.845   7.146  11.052  1.00  7.68           N  
ATOM    819  CA  GLN    95     -11.400   5.872  11.482  1.00  7.54           C  
ATOM    820  C   GLN    95     -10.349   5.113  12.264  1.00  8.31           C  
ATOM    821  O   GLN    95      -9.242   4.918  11.759  1.00  9.00           O  
ATOM    822  CB  GLN    95     -11.798   5.024  10.271  1.00  9.36           C  
ATOM    823  CG  GLN    95     -12.374   3.687  10.694  1.00 11.15           C  
ATOM    824  CD  GLN    95     -12.741   2.784   9.532  1.00 15.09           C  
ATOM    825  OE1 GLN    95     -12.534   3.118   8.363  1.00 23.64           O  
ATOM    826  NE2 GLN    95     -13.323   1.631   9.849  1.00 21.71           N  
ATOM    827  N   ILE    96     -10.674   4.684  13.476  1.00  8.48           N  
ATOM    828  CA  ILE    96      -9.758   3.892  14.281  1.00  9.41           C  
ATOM    829  C   ILE    96      -9.917   2.438  13.865  1.00 10.76           C  
ATOM    830  O   ILE    96     -11.026   1.924  13.776  1.00 14.33           O  
ATOM    831  CB  ILE    96     -10.047   4.124  15.794  1.00 11.62           C  
ATOM    832  CG1 ILE    96      -9.938   5.621  16.183  1.00 14.56           C  
ATOM    833  CG2 ILE    96      -9.151   3.290  16.653  1.00 15.64           C  
ATOM    834  CD1 ILE    96      -8.660   6.355  15.883  1.00 20.14           C  
ATOM    835  N   VAL    97      -8.783   1.797  13.584  1.00  9.63           N  
ATOM    836  CA  VAL    97      -8.751   0.395  13.166  1.00 10.25           C  
ATOM    837  C   VAL    97      -7.899  -0.417  14.134  1.00  9.21           C  
ATOM    838  O   VAL    97      -6.724  -0.152  14.346  1.00  9.63           O  
ATOM    839  CB  VAL    97      -8.192   0.290  11.745  1.00 10.48           C  
ATOM    840  CG1 VAL    97      -8.176  -1.145  11.280  1.00 13.10           C  
ATOM    841  CG2 VAL    97      -8.964   1.213  10.794  1.00 12.97           C  
ATOM    842  N   GLN    98      -8.528  -1.405  14.729  1.00  8.92           N  
ATOM    843  CA  GLN    98      -7.858  -2.314  15.644  1.00  8.81           C  
ATOM    844  C   GLN    98      -7.120  -3.331  14.800  1.00  8.74           C  
ATOM    845  O   GLN    98      -7.738  -4.084  14.040  1.00 11.10           O  
ATOM    846  CB  GLN    98      -8.911  -2.983  16.547  1.00  9.76           C  
ATOM    847  CG  GLN    98      -8.408  -3.986  17.507  1.00 12.22           C  
ATOM    848  CD  GLN    98      -7.655  -3.356  18.635  1.00 12.03           C  
ATOM    849  OE1 GLN    98      -8.102  -2.368  19.246  1.00 14.32           O  
ATOM    850  NE2 GLN    98      -6.489  -3.935  18.947  1.00 13.93           N  
ATOM    851  N   GLY    99      -5.803  -3.371  14.870  1.00  8.36           N  
ATOM    852  CA  GLY    99      -5.061  -4.339  14.094  1.00  8.48           C  
ATOM    853  C   GLY    99      -3.575  -4.113  14.186  1.00  7.51           C  
ATOM    854  O   GLY    99      -3.088  -3.169  14.776  1.00  8.37           O  
ATOM    855  N   ASP   100      -2.856  -5.022  13.555  1.00  9.15           N  
ATOM    856  CA  ASP   100      -1.406  -5.155  13.640  1.00  8.65           C  
ATOM    857  C   ASP   100      -0.763  -4.958  12.280  1.00  8.18           C  
ATOM    858  O   ASP   100      -1.281  -5.423  11.245  1.00  8.84           O  
ATOM    859  CB  ASP   100      -1.120  -6.598  14.152  1.00 10.11           C  
ATOM    860  CG  ASP   100       0.258  -6.814  14.679  1.00 10.02           C  
ATOM    861  OD1 ASP   100       1.245  -6.493  13.994  1.00  9.84           O  
ATOM    862  OD2 ASP   100       0.370  -7.312  15.827  1.00 11.81           O  
ATOM    863  N   VAL   101       0.370  -4.265  12.274  1.00  7.91           N  
ATOM    864  CA  VAL   101       1.136  -4.015  11.059  1.00  8.03           C  
ATOM    865  C   VAL   101       1.521  -5.325  10.343  1.00  8.12           C  
ATOM    866  O   VAL   101       1.772  -5.334   9.147  1.00  8.41           O  
ATOM    867  CB  VAL   101       2.393  -3.156  11.367  1.00  7.51           C  
ATOM    868  CG1 VAL   101       3.426  -3.915  12.194  1.00  8.68           C  
ATOM    869  CG2 VAL   101       2.983  -2.609  10.063  1.00  7.72           C  
ATOM    870  N   HIS   102       1.564  -6.427  11.087  1.00  8.09           N  
ATOM    871  CA  HIS   102       1.951  -7.701  10.481  1.00  9.26           C  
ATOM    872  C   HIS   102       0.804  -8.396   9.777  1.00  9.67           C  
ATOM    873  O   HIS   102       1.015  -9.439   9.151  1.00 11.32           O  
ATOM    874  CB  HIS   102       2.540  -8.660  11.508  1.00  9.93           C  
ATOM    875  CG  HIS   102       3.762  -8.134  12.176  1.00 10.27           C  
ATOM    876  ND1 HIS   102       3.700  -7.419  13.347  1.00 10.22           N  
ATOM    877  CD2 HIS   102       5.064  -8.137  11.803  1.00 11.57           C  
ATOM    878  CE1 HIS   102       4.929  -7.066  13.697  1.00 10.76           C  
ATOM    879  NE2 HIS   102       5.772  -7.483  12.776  1.00 12.79           N  
ATOM    880  N   ASN   103      -0.401  -7.845   9.864  1.00  8.87           N  
ATOM    881  CA  ASN   103      -1.562  -8.444   9.214  1.00  9.43           C  
ATOM    882  C   ASN   103      -2.628  -7.361   9.105  1.00  9.27           C  
ATOM    883  O   ASN   103      -3.615  -7.331   9.823  1.00 10.60           O  
ATOM    884  CB  ASN   103      -2.025  -9.649  10.024  1.00 10.11           C  
ATOM    885  CG  ASN   103      -3.163 -10.342   9.372  1.00 12.51           C  
ATOM    886  OD1 ASN   103      -3.107 -10.581   8.180  1.00 16.56           O  
ATOM    887  ND2 ASN   103      -4.194 -10.712  10.143  1.00 15.23           N  
ATOM    888  N   ILE   104      -2.375  -6.437   8.199  1.00  9.26           N  
ATOM    889  CA  ILE   104      -3.174  -5.215   8.139  1.00  9.26           C  
ATOM    890  C   ILE   104      -4.531  -5.478   7.509  1.00  9.79           C  
ATOM    891  O   ILE   104      -4.590  -5.997   6.394  1.00 10.42           O  
ATOM    892  CB  ILE   104      -2.441  -4.112   7.342  1.00  8.65           C  
ATOM    893  CG1 ILE   104      -1.059  -3.842   7.938  1.00  9.12           C  
ATOM    894  CG2 ILE   104      -3.309  -2.825   7.312  1.00 10.10           C  
ATOM    895  CD1 ILE   104      -0.191  -2.832   7.128  1.00  9.92           C  
ATOM    896  N   PRO   105      -5.622  -5.109   8.191  1.00 10.93           N  
ATOM    897  CA  PRO   105      -6.983  -5.393   7.678  1.00 12.42           C  
ATOM    898  C   PRO   105      -7.459  -4.339   6.695  1.00 12.67           C  
ATOM    899  O   PRO   105      -8.493  -3.688   6.872  1.00 15.50           O  
ATOM    900  CB  PRO   105      -7.825  -5.406   8.949  1.00 14.01           C  
ATOM    901  CG  PRO   105      -7.205  -4.354   9.782  1.00 14.91           C  
ATOM    902  CD  PRO   105      -5.690  -4.524   9.549  1.00 12.35           C  
ATOM    903  N   ILE   106      -6.643  -4.177   5.668  1.00 11.77           N  
ATOM    904  CA  ILE   106      -6.881  -3.223   4.588  0.67 11.84           C  
ATOM    906  C   ILE   106      -6.548  -3.916   3.271  1.00 11.58           C  
ATOM    907  O   ILE   106      -5.611  -4.719   3.199  1.00 11.45           O  
ATOM    908  CB  ILE   106      -6.038  -1.927   4.810  0.67 11.08           C  
ATOM    910  CG1 ILE   106      -6.460  -1.241   6.115  0.67 11.15           C  
ATOM    912  CG2 ILE   106      -6.165  -0.965   3.623  0.67 13.85           C  
ATOM    914  CD1 ILE   106      -5.566  -0.069   6.504  0.67 12.34           C  
ATOM    916  N   GLU   107      -7.332  -3.611   2.246  1.00 12.90           N  
ATOM    917  CA  GLU   107      -7.126  -4.227   0.943  1.00 13.99           C  
ATOM    918  C   GLU   107      -5.833  -3.800   0.268  1.00 12.73           C  
ATOM    919  O   GLU   107      -5.212  -2.789   0.589  1.00 12.05           O  
ATOM    920  CB  GLU   107      -8.312  -3.989  -0.008  1.00 17.33           C  
ATOM    921  CG  GLU   107      -8.524  -2.583  -0.495  1.00 22.38           C  
ATOM    922  CD  GLU   107      -9.760  -2.476  -1.402  1.00 28.40           C  
ATOM    923  OE1 GLU   107     -10.717  -3.260  -1.216  1.00 33.83           O  
ATOM    924  OE2 GLU   107      -9.785  -1.617  -2.297  1.00 30.51           O  
ATOM    925  N   ASP   108      -5.464  -4.590  -0.712  1.00 12.22           N  
ATOM    926  CA  ASP   108      -4.290  -4.320  -1.513  1.00 12.45           C  
ATOM    927  C   ASP   108      -4.400  -2.958  -2.213  1.00 10.68           C  
ATOM    928  O   ASP   108      -5.476  -2.568  -2.677  1.00 12.03           O  
ATOM    929  CB  ASP   108      -4.134  -5.335  -2.645  1.00 13.84           C  
ATOM    930  CG  ASP   108      -3.947  -6.776  -2.178  1.00 16.95           C  
ATOM    931  OD1 ASP   108      -3.780  -7.071  -0.986  1.00 13.62           O  
ATOM    932  OD2 ASP   108      -3.970  -7.651  -3.071  1.00 20.93           O  
ATOM    933  N   ASN   109      -3.273  -2.250  -2.290  1.00 10.55           N  
ATOM    934  CA  ASN   109      -3.160  -1.049  -3.140  1.00 11.25           C  
ATOM    935  C   ASN   109      -4.129   0.053  -2.789  1.00 11.87           C  
ATOM    936  O   ASN   109      -4.549   0.799  -3.650  1.00 16.02           O  
ATOM    937  CB  ASN   109      -3.354  -1.459  -4.608  1.00 11.88           C  
ATOM    938  CG  ASN   109      -2.355  -2.481  -5.039  1.00 13.39           C  
ATOM    939  OD1 ASN   109      -1.186  -2.404  -4.683  1.00 15.54           O  
ATOM    940  ND2 ASN   109      -2.795  -3.450  -5.846  1.00 15.63           N  
ATOM    941  N   TYR   110      -4.427   0.176  -1.516  1.00 10.52           N  
ATOM    942  CA  TYR   110      -5.407   1.106  -1.017  1.00 10.42           C  
ATOM    943  C   TYR   110      -4.907   2.506  -0.669  1.00  8.87           C  
ATOM    944  O   TYR   110      -5.642   3.483  -0.873  1.00  9.76           O  
ATOM    945  CB  TYR   110      -6.053   0.510   0.246  1.00 12.46           C  
ATOM    946  CG  TYR   110      -7.104   1.377   0.887  1.00 14.30           C  
ATOM    947  CD1 TYR   110      -8.381   1.387   0.390  1.00 18.22           C  
ATOM    948  CD2 TYR   110      -6.805   2.179   1.988  1.00 15.21           C  
ATOM    949  CE1 TYR   110      -9.366   2.194   0.960  1.00 20.62           C  
ATOM    950  CE2 TYR   110      -7.772   2.978   2.562  1.00 17.07           C  
ATOM    951  CZ  TYR   110      -9.041   2.971   2.048  1.00 17.95           C  
ATOM    952  OH  TYR   110      -9.980   3.781   2.629  1.00 22.89           O  
ATOM    953  N   ALA   111      -3.706   2.608  -0.106  1.00  7.93           N  
ATOM    954  CA  ALA   111      -3.256   3.832   0.534  1.00  7.78           C  
ATOM    955  C   ALA   111      -2.441   4.734  -0.382  1.00  7.24           C  
ATOM    956  O   ALA   111      -1.429   4.325  -0.913  1.00  8.08           O  
ATOM    957  CB  ALA   111      -2.384   3.448   1.772  1.00  8.73           C  
ATOM    958  N   ASP   112      -2.847   5.979  -0.465  1.00  7.19           N  
ATOM    959  CA  ASP   112      -2.016   6.980  -1.132  1.00  7.38           C  
ATOM    960  C   ASP   112      -0.779   7.364  -0.324  1.00  6.64           C  
ATOM    961  O   ASP   112       0.254   7.715  -0.874  1.00  8.16           O  
ATOM    962  CB  ASP   112      -2.863   8.227  -1.419  1.00  8.05           C  
ATOM    963  CG  ASP   112      -3.992   7.941  -2.393  1.00  9.94           C  
ATOM    964  OD1 ASP   112      -3.699   7.605  -3.563  1.00 14.44           O  
ATOM    965  OD2 ASP   112      -5.149   8.049  -1.998  1.00 11.64           O  
ATOM    966  N   LEU   113      -0.933   7.323   0.986  1.00  6.67           N  
ATOM    967  CA  LEU   113       0.098   7.729   1.930  1.00  6.74           C  
ATOM    968  C   LEU   113       0.039   6.863   3.163  1.00  5.77           C  
ATOM    969  O   LEU   113      -1.041   6.579   3.653  1.00  6.67           O  
ATOM    970  CB  LEU   113      -0.100   9.189   2.342  1.00  7.25           C  
ATOM    971  CG  LEU   113       0.868   9.769   3.363  1.00  8.21           C  
ATOM    972  CD1 LEU   113       2.308   9.837   2.842  1.00  9.19           C  
ATOM    973  CD2 LEU   113       0.358  11.175   3.810  1.00 10.58           C  
ATOM    974  N   ILE   114       1.187   6.389   3.617  1.00  5.65           N  
ATOM    975  CA  ILE   114       1.290   5.643   4.870  1.00  5.52           C  
ATOM    976  C   ILE   114       2.287   6.367   5.751  1.00  6.04           C  
ATOM    977  O   ILE   114       3.442   6.581   5.348  1.00  7.49           O  
ATOM    978  CB  ILE   114       1.729   4.181   4.657  1.00  6.16           C  
ATOM    979  CG1 ILE   114       0.757   3.469   3.721  1.00  7.43           C  
ATOM    980  CG2 ILE   114       1.897   3.471   5.972  1.00  7.77           C  
ATOM    981  CD1 ILE   114       1.197   2.051   3.299  1.00  8.26           C  
ATOM    982  N   VAL   115       1.852   6.746   6.949  1.00  5.68           N  
ATOM    983  CA  VAL   115       2.699   7.415   7.911  1.00  6.11           C  
ATOM    984  C   VAL   115       2.771   6.585   9.188  1.00  5.70           C  
ATOM    985  O   VAL   115       1.896   5.796   9.471  1.00  6.47           O  
ATOM    986  CB  VAL   115       2.175   8.852   8.227  1.00  7.08           C  
ATOM    987  CG1 VAL   115       2.042   9.681   6.939  1.00  8.57           C  
ATOM    988  CG2 VAL   115       0.842   8.828   8.995  1.00  8.27           C  
ATOM    989  N   SER   116       3.828   6.784   9.961  1.00  6.22           N  
ATOM    990  CA  SER   116       3.959   6.117  11.254  1.00  6.34           C  
ATOM    991  C   SER   116       5.050   6.795  12.050  1.00  6.36           C  
ATOM    992  O   SER   116       6.172   6.958  11.554  1.00  6.83           O  
ATOM    993  CB  SER   116       4.370   4.687  11.048  1.00  7.27           C  
ATOM    994  OG  SER   116       4.530   4.002  12.275  1.00  7.35           O  
ATOM    995  N   ARG   117       4.725   7.183  13.288  1.00  5.94           N  
ATOM    996  CA  ARG   117       5.689   7.793  14.190  1.00  6.28           C  
ATOM    997  C   ARG   117       5.848   6.963  15.427  1.00  6.61           C  
ATOM    998  O   ARG   117       4.872   6.634  16.100  1.00  8.17           O  
ATOM    999  CB  ARG   117       5.271   9.209  14.597  1.00  6.35           C  
ATOM   1000  CG  ARG   117       6.278   9.874  15.491  1.00  7.49           C  
ATOM   1001  CD  ARG   117       5.787  11.216  16.100  1.00  7.54           C  
ATOM   1002  NE  ARG   117       6.813  11.705  16.992  1.00  8.26           N  
ATOM   1003  CZ  ARG   117       7.035  11.197  18.209  1.00  8.17           C  
ATOM   1004  NH1 ARG   117       6.177  10.346  18.728  1.00  9.56           N  
ATOM   1005  NH2 ARG   117       8.084  11.585  18.897  1.00  9.70           N  
ATOM   1006  N   GLY   118       7.080   6.679  15.792  0.50  6.73           N  
ATOM   1008  CA  GLY   118       7.345   6.035  17.059  0.50  7.78           C  
ATOM   1010  C   GLY   118       6.883   4.622  17.261  0.50  7.67           C  
ATOM   1012  O   GLY   118       6.770   4.211  18.414  0.50  8.95           O  
ATOM   1014  N   SER   119       6.488   3.932  16.189  1.00  9.05           N  
ATOM   1015  CA  SER   119       6.063   2.545  16.230  1.00  7.91           C  
ATOM   1016  C   SER   119       7.072   1.539  15.673  1.00  8.02           C  
ATOM   1017  O   SER   119       7.247   0.464  16.249  1.00  8.54           O  
ATOM   1018  CB  SER   119       4.719   2.482  15.496  1.00  9.18           C  
ATOM   1019  OG  SER   119       4.007   1.292  15.769  1.00  8.94           O  
ATOM   1020  N   VAL   120       7.744   1.903  14.581  1.00  7.52           N  
ATOM   1021  CA  VAL   120       8.625   0.982  13.893  1.00  7.57           C  
ATOM   1022  C   VAL   120       9.710   0.407  14.782  1.00  8.43           C  
ATOM   1023  O   VAL   120      10.150  -0.710  14.566  1.00  9.93           O  
ATOM   1024  CB  VAL   120       9.231   1.645  12.614  1.00  7.75           C  
ATOM   1025  CG1 VAL   120      10.155   2.803  12.967  1.00  8.23           C  
ATOM   1026  CG2 VAL   120       9.943   0.616  11.742  1.00  9.64           C  
ATOM   1027  N   PHE   121      10.139   1.180  15.778  1.00  7.65           N  
ATOM   1028  CA  PHE   121      11.227   0.789  16.672  1.00  8.29           C  
ATOM   1029  C   PHE   121      10.838  -0.354  17.590  1.00  9.16           C  
ATOM   1030  O   PHE   121      11.701  -0.978  18.191  1.00 11.83           O  
ATOM   1031  CB  PHE   121      11.701   2.005  17.476  1.00  9.11           C  
ATOM   1032  CG  PHE   121      12.051   3.175  16.614  1.00  8.92           C  
ATOM   1033  CD1 PHE   121      13.062   3.123  15.690  1.00 10.11           C  
ATOM   1034  CD2 PHE   121      11.303   4.311  16.678  1.00 10.96           C  
ATOM   1035  CE1 PHE   121      13.337   4.198  14.883  1.00 11.17           C  
ATOM   1036  CE2 PHE   121      11.568   5.396  15.858  1.00 12.91           C  
ATOM   1037  CZ  PHE   121      12.584   5.339  14.977  1.00 12.80           C  
ATOM   1038  N   PHE   122       9.549  -0.654  17.658  1.00  8.40           N  
ATOM   1039  CA  PHE   122       9.036  -1.735  18.507  1.00 10.10           C  
ATOM   1040  C   PHE   122       8.657  -2.996  17.732  1.00 10.76           C  
ATOM   1041  O   PHE   122       8.508  -4.058  18.336  1.00 15.74           O  
ATOM   1042  CB  PHE   122       7.786  -1.274  19.286  1.00  9.79           C  
ATOM   1043  CG  PHE   122       8.044  -0.136  20.228  1.00  8.46           C  
ATOM   1044  CD1 PHE   122       8.756  -0.318  21.398  1.00  9.80           C  
ATOM   1045  CD2 PHE   122       7.549   1.121  19.968  1.00  8.61           C  
ATOM   1046  CE1 PHE   122       8.932   0.778  22.286  1.00 10.79           C  
ATOM   1047  CE2 PHE   122       7.722   2.159  20.830  1.00 10.41           C  
ATOM   1048  CZ  PHE   122       8.448   1.998  21.964  1.00 10.35           C  
ATOM   1049  N   TRP   123       8.480  -2.918  16.427  1.00 10.63           N  
ATOM   1050  CA  TRP   123       7.933  -4.056  15.695  1.00 10.83           C  
ATOM   1051  C   TRP   123       8.798  -5.278  15.710  1.00 11.50           C  
ATOM   1052  O   TRP   123       9.982  -5.188  15.477  1.00 11.52           O  
ATOM   1053  CB  TRP   123       7.615  -3.724  14.220  1.00 10.25           C  
ATOM   1054  CG  TRP   123       6.671  -2.596  14.046  1.00  9.23           C  
ATOM   1055  CD1 TRP   123       5.778  -2.098  14.966  1.00  9.94           C  
ATOM   1056  CD2 TRP   123       6.501  -1.807  12.865  1.00  9.22           C  
ATOM   1057  NE1 TRP   123       5.085  -1.041  14.431  1.00 10.84           N  
ATOM   1058  CE2 TRP   123       5.541  -0.818  13.156  1.00  8.27           C  
ATOM   1059  CE3 TRP   123       7.075  -1.821  11.599  1.00  9.17           C  
ATOM   1060  CZ2 TRP   123       5.148   0.123  12.214  1.00  9.88           C  
ATOM   1061  CZ3 TRP   123       6.705  -0.862  10.681  1.00 10.31           C  
ATOM   1062  CH2 TRP   123       5.753   0.096  10.996  1.00  9.71           C  
ATOM   1063  N   GLU   124       8.162  -6.414  15.977  1.00 11.93           N  
ATOM   1064  CA  GLU   124       8.804  -7.719  15.871  0.50 13.50           C  
ATOM   1066  C   GLU   124       8.807  -8.022  14.343  1.00 13.77           C  
ATOM   1067  O   GLU   124       8.147  -7.340  13.608  1.00 15.88           O  
ATOM   1068  CB  GLU   124       7.964  -8.760  16.664  0.50 14.72           C  
ATOM   1070  CG  GLU   124       7.881  -8.458  18.169  0.50 19.73           C  
ATOM   1072  CD  GLU   124       6.848  -9.303  18.942  0.50 22.67           C  
ATOM   1074  OE1 GLU   124       6.138 -10.144  18.336  0.50 21.97           O  
ATOM   1076  OE2 GLU   124       6.743  -9.103  20.176  0.50 24.70           O  
ATOM   1078  N   ASP   125       9.537  -8.988  13.834  1.00 16.25           N  
ATOM   1079  CA  ASP   125       9.376  -9.299  12.398  1.00 11.58           C  
ATOM   1080  C   ASP   125       9.118  -8.159  11.382  1.00 10.07           C  
ATOM   1081  O   ASP   125       8.089  -8.079  10.691  1.00  9.50           O  
ATOM   1082  CB  ASP   125       8.298 -10.362  12.241  1.00 11.92           C  
ATOM   1083  CG  ASP   125       8.424 -11.094  10.925  1.00 10.36           C  
ATOM   1084  OD1 ASP   125       9.361 -10.777  10.144  1.00 12.78           O  
ATOM   1085  OD2 ASP   125       7.558 -11.943  10.656  1.00 12.56           O  
ATOM   1086  N   VAL   126      10.140  -7.333  11.250  1.00  9.61           N  
ATOM   1087  CA  VAL   126      10.030  -6.169  10.391  0.82  8.89           C  
ATOM   1089  C   VAL   126       9.921  -6.518   8.908  1.00  8.30           C  
ATOM   1090  O   VAL   126       9.327  -5.754   8.155  1.00  8.51           O  
ATOM   1091  CB  VAL   126      11.111  -5.126  10.654  0.82  9.68           C  
ATOM   1093  CG1 VAL   126      10.883  -4.500  12.054  0.82 11.15           C  
ATOM   1095  CG2 VAL   126      12.502  -5.701  10.517  0.82 10.67           C  
ATOM   1097  N   THR   127      10.460  -7.660   8.491  1.00  8.00           N  
ATOM   1098  CA  THR   127      10.320  -8.063   7.084  1.00  7.90           C  
ATOM   1099  C   THR   127       8.839  -8.233   6.748  1.00  8.19           C  
ATOM   1100  O   THR   127       8.355  -7.760   5.719  1.00  8.41           O  
ATOM   1101  CB  THR   127      11.069  -9.352   6.808  1.00 10.87           C  
ATOM   1102  N   THR   128       8.110  -8.942   7.601  1.00  7.52           N  
ATOM   1103  CA  THR   128       6.695  -9.148   7.386  1.00  7.95           C  
ATOM   1104  C   THR   128       5.935  -7.825   7.439  1.00  7.92           C  
ATOM   1105  O   THR   128       5.034  -7.573   6.625  1.00  8.44           O  
ATOM   1106  CB  THR   128       6.130 -10.147   8.402  1.00  9.79           C  
ATOM   1107  OG1 THR   128       6.767 -11.405   8.181  1.00 10.06           O  
ATOM   1108  CG2 THR   128       4.608 -10.286   8.313  1.00 11.49           C  
ATOM   1109  N   ALA   129       6.289  -6.980   8.393  1.00  7.72           N  
ATOM   1110  CA  ALA   129       5.626  -5.676   8.532  1.00  7.74           C  
ATOM   1111  C   ALA   129       5.776  -4.862   7.243  1.00  7.05           C  
ATOM   1112  O   ALA   129       4.816  -4.300   6.751  1.00  7.71           O  
ATOM   1113  CB  ALA   129       6.207  -4.909   9.705  1.00  8.15           C  
ATOM   1114  N   PHE   130       6.995  -4.789   6.706  1.00  7.37           N  
ATOM   1115  CA  PHE   130       7.212  -4.018   5.487  1.00  7.45           C  
ATOM   1116  C   PHE   130       6.612  -4.628   4.238  1.00  7.36           C  
ATOM   1117  O   PHE   130       6.203  -3.912   3.349  1.00  7.74           O  
ATOM   1118  CB  PHE   130       8.674  -3.598   5.341  1.00  7.32           C  
ATOM   1119  CG  PHE   130       8.978  -2.364   6.166  1.00  7.34           C  
ATOM   1120  CD1 PHE   130       8.687  -1.097   5.678  1.00  8.48           C  
ATOM   1121  CD2 PHE   130       9.426  -2.475   7.473  1.00  8.55           C  
ATOM   1122  CE1 PHE   130       8.887   0.015   6.465  1.00  9.14           C  
ATOM   1123  CE2 PHE   130       9.623  -1.357   8.257  1.00  9.73           C  
ATOM   1124  CZ  PHE   130       9.347  -0.118   7.751  1.00  9.56           C  
ATOM   1125  N   ARG   131       6.492  -5.946   4.179  1.00  7.37           N  
ATOM   1126  CA  ARG   131       5.727  -6.571   3.093  1.00  7.62           C  
ATOM   1127  C   ARG   131       4.263  -6.164   3.158  1.00  7.56           C  
ATOM   1128  O   ARG   131       3.634  -5.914   2.126  1.00  8.19           O  
ATOM   1129  CB  ARG   131       5.892  -8.091   3.103  1.00  7.21           C  
ATOM   1130  CG  ARG   131       7.254  -8.524   2.540  1.00  8.66           C  
ATOM   1131  CD  ARG   131       7.352 -10.056   2.457  1.00  8.42           C  
ATOM   1132  NE  ARG   131       8.440 -10.466   1.588  1.00  9.16           N  
ATOM   1133  CZ  ARG   131       9.687 -10.589   1.960  1.00  9.13           C  
ATOM   1134  NH1 ARG   131      10.036 -10.523   3.221  1.00 11.02           N  
ATOM   1135  NH2 ARG   131      10.621 -10.811   1.041  1.00  9.82           N  
ATOM   1136  N   GLU   132       3.713  -6.106   4.372  1.00  7.44           N  
ATOM   1137  CA  GLU   132       2.309  -5.665   4.518  1.00  7.89           C  
ATOM   1138  C   GLU   132       2.126  -4.197   4.125  1.00  7.73           C  
ATOM   1139  O   GLU   132       1.162  -3.815   3.468  1.00  8.05           O  
ATOM   1140  CB  GLU   132       1.816  -5.911   5.957  1.00  8.39           C  
ATOM   1141  CG  GLU   132       1.390  -7.325   6.199  1.00  9.26           C  
ATOM   1142  CD  GLU   132       0.113  -7.614   5.431  1.00  9.17           C  
ATOM   1143  OE1 GLU   132      -0.984  -7.205   5.892  1.00 10.47           O  
ATOM   1144  OE2 GLU   132       0.199  -8.204   4.337  1.00  9.94           O  
ATOM   1145  N   ILE   133       3.051  -3.352   4.574  1.00  7.41           N  
ATOM   1146  CA  ILE   133       3.039  -1.941   4.222  1.00  7.93           C  
ATOM   1147  C   ILE   133       3.071  -1.791   2.710  1.00  7.75           C  
ATOM   1148  O   ILE   133       2.316  -1.018   2.119  1.00  8.20           O  
ATOM   1149  CB  ILE   133       4.202  -1.217   4.909  1.00  7.60           C  
ATOM   1150  CG1 ILE   133       3.890  -1.130   6.410  1.00  7.93           C  
ATOM   1151  CG2 ILE   133       4.464   0.166   4.313  1.00  8.43           C  
ATOM   1152  CD1 ILE   133       5.100  -0.804   7.300  1.00  9.23           C  
ATOM   1153  N   TYR   134       3.951  -2.537   2.057  1.00  7.52           N  
ATOM   1154  CA  TYR   134       4.042  -2.425   0.607  1.00  7.77           C  
ATOM   1155  C   TYR   134       2.772  -2.933  -0.056  1.00  8.48           C  
ATOM   1156  O   TYR   134       2.344  -2.357  -1.071  1.00  8.98           O  
ATOM   1157  CB  TYR   134       5.282  -3.144   0.070  1.00  8.17           C  
ATOM   1158  CG  TYR   134       5.763  -2.642  -1.268  1.00  8.07           C  
ATOM   1159  CD1 TYR   134       6.219  -1.348  -1.396  1.00  9.13           C  
ATOM   1160  CD2 TYR   134       5.800  -3.438  -2.384  1.00 10.07           C  
ATOM   1161  CE1 TYR   134       6.716  -0.861  -2.558  1.00 10.00           C  
ATOM   1162  CE2 TYR   134       6.331  -2.955  -3.606  1.00 10.31           C  
ATOM   1163  CZ  TYR   134       6.784  -1.660  -3.665  1.00  9.15           C  
ATOM   1164  OH  TYR   134       7.277  -1.111  -4.831  1.00 10.03           O  
ATOM   1165  N   ARG   135       2.174  -3.994   0.507  1.00  8.18           N  
ATOM   1166  CA  ARG   135       0.976  -4.538  -0.063  1.00  9.41           C  
ATOM   1167  C   ARG   135      -0.168  -3.521  -0.105  1.00  8.81           C  
ATOM   1168  O   ARG   135      -0.911  -3.436  -1.102  1.00  9.48           O  
ATOM   1169  CB  ARG   135       0.537  -5.789   0.708  1.00  9.49           C  
ATOM   1170  CG  ARG   135      -0.741  -6.408   0.167  1.00  9.61           C  
ATOM   1171  CD  ARG   135      -1.222  -7.593   1.016  1.00 10.56           C  
ATOM   1172  NE  ARG   135      -1.602  -7.228   2.373  1.00 10.04           N  
ATOM   1173  CZ  ARG   135      -2.723  -6.591   2.702  1.00 11.05           C  
ATOM   1174  NH1 ARG   135      -3.607  -6.225   1.787  1.00 10.99           N  
ATOM   1175  NH2 ARG   135      -2.950  -6.308   3.985  1.00 11.47           N  
ATOM   1176  N   ILE   136      -0.348  -2.788   0.993  1.00  8.02           N  
ATOM   1177  CA  ILE   136      -1.481  -1.869   1.094  1.00  8.77           C  
ATOM   1178  C   ILE   136      -1.229  -0.509   0.424  1.00  8.64           C  
ATOM   1179  O   ILE   136      -2.140   0.279   0.270  1.00 10.16           O  
ATOM   1180  CB  ILE   136      -1.964  -1.672   2.562  1.00  8.62           C  
ATOM   1181  CG1 ILE   136      -0.901  -0.989   3.433  1.00  9.51           C  
ATOM   1182  CG2 ILE   136      -2.444  -3.012   3.170  1.00 10.74           C  
ATOM   1183  CD1 ILE   136      -1.474  -0.170   4.556  1.00 10.37           C  
ATOM   1184  N   LEU   137       0.004  -0.220   0.057  1.00  8.25           N  
ATOM   1185  CA  LEU   137       0.379   1.019  -0.607  1.00  8.41           C  
ATOM   1186  C   LEU   137      -0.077   0.986  -2.072  1.00  8.83           C  
ATOM   1187  O   LEU   137       0.149   0.008  -2.782  1.00 10.37           O  
ATOM   1188  CB  LEU   137       1.916   1.175  -0.521  1.00  8.67           C  
ATOM   1189  CG  LEU   137       2.524   2.497  -0.967  1.00  9.05           C  
ATOM   1190  CD1 LEU   137       1.952   3.672  -0.154  1.00  9.55           C  
ATOM   1191  CD2 LEU   137       4.052   2.432  -0.820  1.00  9.56           C  
ATOM   1192  N   LYS   138      -0.700   2.077  -2.498  0.57  8.62           N  
ATOM   1194  CA  LYS   138      -1.125   2.244  -3.871  0.57  9.34           C  
ATOM   1196  C   LYS   138       0.093   2.534  -4.750  0.57 10.25           C  
ATOM   1198  O   LYS   138       1.030   3.220  -4.345  0.57  9.47           O  
ATOM   1200  CB  LYS   138      -2.136   3.405  -3.979  0.57  9.61           C  
ATOM   1202  CG  LYS   138      -2.873   3.440  -5.298  0.57 10.76           C  
ATOM   1204  CD  LYS   138      -3.817   4.658  -5.366  0.57 12.36           C  
ATOM   1206  CE  LYS   138      -4.828   4.646  -4.271  0.57 14.49           C  
ATOM   1208  NZ  LYS   138      -5.760   5.780  -4.509  0.57 18.01           N  
ATOM   1210  N   SER   139       0.064   2.008  -5.966  0.57 10.87           N  
ATOM   1212  CA  SER   139       1.083   2.343  -6.950  0.57 12.67           C  
ATOM   1214  C   SER   139       1.123   3.868  -7.065  0.57 11.08           C  
ATOM   1216  O   SER   139       0.103   4.527  -7.272  0.57 12.04           O  
ATOM   1218  CB  SER   139       0.766   1.684  -8.296  0.57 14.08           C  
ATOM   1220  OG  SER   139       1.772   1.944  -9.248  0.57 19.45           O  
ATOM   1222  N   GLY   140       2.320   4.420  -6.967  1.00 11.25           N  
ATOM   1223  CA  GLY   140       2.540   5.857  -6.908  1.00 11.39           C  
ATOM   1224  C   GLY   140       2.460   6.449  -5.516  1.00 12.04           C  
ATOM   1225  O   GLY   140       2.731   7.613  -5.331  1.00 14.89           O  
ATOM   1226  N   GLY   141       2.097   5.630  -4.543  1.00 10.70           N  
ATOM   1227  CA  GLY   141       1.996   6.029  -3.148  1.00  9.69           C  
ATOM   1228  C   GLY   141       3.340   6.229  -2.482  1.00 10.19           C  
ATOM   1229  O   GLY   141       4.361   5.740  -2.961  1.00 11.81           O  
ATOM   1230  N   LYS   142       3.300   6.878  -1.314  1.00  7.88           N  
ATOM   1231  CA  LYS   142       4.488   7.211  -0.523  1.00  7.53           C  
ATOM   1232  C   LYS   142       4.319   6.792   0.930  1.00  7.09           C  
ATOM   1233  O   LYS   142       3.193   6.747   1.437  1.00  7.75           O  
ATOM   1234  CB  LYS   142       4.753   8.735  -0.530  1.00  8.17           C  
ATOM   1235  CG  LYS   142       4.943   9.374  -1.903  1.00 10.76           C  
ATOM   1236  CD  LYS   142       6.261   9.017  -2.514  1.00 11.66           C  
ATOM   1237  CE  LYS   142       6.456   9.706  -3.853  1.00 13.32           C  
ATOM   1238  NZ  LYS   142       7.759   9.410  -4.431  1.00 13.44           N  
ATOM   1239  N   THR   143       5.442   6.528   1.594  1.00  6.74           N  
ATOM   1240  CA  THR   143       5.447   6.303   3.036  1.00  6.51           C  
ATOM   1241  C   THR   143       6.321   7.336   3.745  1.00  6.36           C  
ATOM   1242  O   THR   143       7.189   7.964   3.156  1.00  6.85           O  
ATOM   1243  CB  THR   143       5.923   4.885   3.452  1.00  6.63           C  
ATOM   1244  OG1 THR   143       7.351   4.758   3.358  1.00  6.25           O  
ATOM   1245  CG2 THR   143       5.300   3.805   2.613  1.00  8.11           C  
ATOM   1246  N   TYR   144       6.095   7.457   5.054  1.00  6.31           N  
ATOM   1247  CA  TYR   144       6.905   8.318   5.931  1.00  5.84           C  
ATOM   1248  C   TYR   144       6.808   7.655   7.301  1.00  5.77           C  
ATOM   1249  O   TYR   144       5.934   7.952   8.106  1.00  6.22           O  
ATOM   1250  CB  TYR   144       6.354   9.727   5.910  1.00  6.64           C  
ATOM   1251  CG  TYR   144       7.273  10.798   6.464  1.00  6.36           C  
ATOM   1252  CD1 TYR   144       8.263  11.377   5.686  1.00  7.88           C  
ATOM   1253  CD2 TYR   144       7.099  11.301   7.741  1.00  7.13           C  
ATOM   1254  CE1 TYR   144       9.037  12.401   6.151  1.00  8.39           C  
ATOM   1255  CE2 TYR   144       7.875  12.335   8.208  1.00  7.78           C  
ATOM   1256  CZ  TYR   144       8.846  12.885   7.413  1.00  7.67           C  
ATOM   1257  OH  TYR   144       9.585  13.925   7.919  1.00 10.26           O  
ATOM   1258  N   ILE   145       7.723   6.706   7.515  1.00  5.59           N  
ATOM   1259  CA  ILE   145       7.663   5.766   8.662  1.00  5.49           C  
ATOM   1260  C   ILE   145       8.935   5.867   9.464  1.00  5.52           C  
ATOM   1261  O   ILE   145      10.037   5.618   8.960  1.00  6.01           O  
ATOM   1262  CB  ILE   145       7.469   4.320   8.138  1.00  6.70           C  
ATOM   1263  CG1 ILE   145       6.103   4.200   7.445  1.00  6.92           C  
ATOM   1264  CG2 ILE   145       7.672   3.304   9.251  1.00  6.86           C  
ATOM   1265  CD1 ILE   145       5.958   2.972   6.594  1.00  8.71           C  
ATOM   1266  N   GLY   146       8.815   6.253  10.731  1.00  5.56           N  
ATOM   1267  CA  GLY   146      10.031   6.466  11.509  1.00  5.84           C  
ATOM   1268  C   GLY   146       9.725   7.121  12.819  1.00  5.82           C  
ATOM   1269  O   GLY   146       8.775   6.723  13.506  1.00  6.49           O  
ATOM   1270  N   GLY   147      10.505   8.124  13.158  1.00  6.23           N  
ATOM   1271  CA  GLY   147      10.296   8.863  14.402  1.00  6.62           C  
ATOM   1272  C   GLY   147      11.058  10.149  14.432  1.00  6.55           C  
ATOM   1273  O   GLY   147      11.913  10.375  13.610  1.00  7.94           O  
ATOM   1274  N   GLY   148      10.727  11.001  15.383  1.00  8.32           N  
ATOM   1275  CA  GLY   148      11.368  12.281  15.490  1.00  8.78           C  
ATOM   1276  C   GLY   148      10.430  13.334  16.028  1.00  7.34           C  
ATOM   1277  O   GLY   148       9.316  13.061  16.480  1.00  7.05           O  
ATOM   1278  N   PHE   149      10.921  14.563  15.920  1.00  7.26           N  
ATOM   1279  CA  PHE   149      10.301  15.728  16.544  0.83  7.47           C  
ATOM   1281  C   PHE   149       9.975  16.866  15.602  1.00  8.23           C  
ATOM   1282  O   PHE   149       9.602  17.919  16.041  1.00 10.56           O  
ATOM   1283  CB  PHE   149      11.128  16.161  17.767  0.83  8.05           C  
ATOM   1285  CG  PHE   149      11.263  15.051  18.742  0.83  8.81           C  
ATOM   1287  CD1 PHE   149      10.250  14.783  19.652  0.83  9.60           C  
ATOM   1289  CD2 PHE   149      12.306  14.126  18.623  0.83 12.55           C  
ATOM   1291  CE1 PHE   149      10.307  13.703  20.507  0.83 10.47           C  
ATOM   1293  CE2 PHE   149      12.352  13.008  19.456  0.83 13.97           C  
ATOM   1295  CZ  PHE   149      11.356  12.809  20.413  0.83 14.66           C  
ATOM   1297  N   GLY   150      10.130  16.622  14.310  1.00  9.02           N  
ATOM   1298  CA  GLY   150       9.732  17.586  13.297  1.00  9.85           C  
ATOM   1299  C   GLY   150      10.760  18.630  12.908  1.00  8.62           C  
ATOM   1300  O   GLY   150      10.877  18.942  11.727  1.00  9.04           O  
ATOM   1301  N   ASN   151      11.444  19.220  13.889  1.00  8.76           N  
ATOM   1302  CA  ASN   151      12.527  20.139  13.570  1.00  9.02           C  
ATOM   1303  C   ASN   151      13.524  20.165  14.724  1.00  8.46           C  
ATOM   1304  O   ASN   151      13.291  19.593  15.794  1.00  8.74           O  
ATOM   1305  CB  ASN   151      11.979  21.509  13.184  1.00  9.98           C  
ATOM   1306  CG  ASN   151      11.258  22.214  14.317  1.00 10.21           C  
ATOM   1307  OD1 ASN   151      11.717  22.197  15.450  1.00 11.18           O  
ATOM   1308  ND2 ASN   151      10.143  22.882  14.001  1.00 11.44           N  
ATOM   1309  N   LYS   152      14.653  20.826  14.496  1.00  8.67           N  
ATOM   1310  CA  LYS   152      15.721  20.826  15.479  1.00  9.44           C  
ATOM   1311  C   LYS   152      15.338  21.524  16.770  1.00  9.39           C  
ATOM   1312  O   LYS   152      15.720  21.082  17.853  1.00  9.72           O  
ATOM   1313  CB  LYS   152      16.957  21.503  14.892  1.00 10.99           C  
ATOM   1314  CG  LYS   152      18.158  21.503  15.799  1.00 13.50           C  
ATOM   1315  CD  LYS   152      19.343  22.199  15.162  1.00 15.84           C  
ATOM   1316  CE  LYS   152      20.586  22.091  15.987  1.00 21.48           C  
ATOM   1317  NZ  LYS   152      21.726  22.714  15.268  1.00 26.36           N  
ATOM   1318  N   GLU   153      14.614  22.628  16.669  1.00  9.85           N  
ATOM   1319  CA  GLU   153      14.264  23.428  17.852  0.51 10.41           C  
ATOM   1321  C   GLU   153      13.413  22.595  18.813  1.00  9.57           C  
ATOM   1322  O   GLU   153      13.663  22.553  20.017  1.00 10.01           O  
ATOM   1323  CB  GLU   153      13.537  24.752  17.484  0.51 11.47           C  
ATOM   1325  CG  GLU   153      13.073  25.576  18.734  0.51 17.67           C  
ATOM   1327  CD  GLU   153      12.583  27.014  18.444  0.51 21.20           C  
ATOM   1329  OE1 GLU   153      12.468  27.407  17.265  0.51 25.98           O  
ATOM   1331  OE2 GLU   153      12.266  27.747  19.414  0.51 23.32           O  
ATOM   1333  N   LEU   154      12.401  21.940  18.268  1.00  8.79           N  
ATOM   1334  CA  LEU   154      11.535  21.090  19.079  1.00  8.92           C  
ATOM   1335  C   LEU   154      12.280  19.876  19.570  1.00  7.91           C  
ATOM   1336  O   LEU   154      12.140  19.469  20.720  1.00  8.79           O  
ATOM   1337  CB  LEU   154      10.276  20.699  18.315  1.00  9.43           C  
ATOM   1338  CG  LEU   154       9.331  21.841  17.953  1.00  9.85           C  
ATOM   1339  CD1 LEU   154       8.190  21.292  17.134  1.00 10.67           C  
ATOM   1340  CD2 LEU   154       8.822  22.565  19.214  1.00 13.40           C  
ATOM   1341  N   ARG   155      13.090  19.277  18.711  1.00  7.63           N  
ATOM   1342  CA  ARG   155      13.862  18.133  19.131  1.00  8.32           C  
ATOM   1343  C   ARG   155      14.668  18.467  20.394  1.00  9.00           C  
ATOM   1344  O   ARG   155      14.694  17.731  21.391  1.00  9.61           O  
ATOM   1345  CB  ARG   155      14.808  17.663  18.024  1.00  8.41           C  
ATOM   1346  CG  ARG   155      15.656  16.493  18.400  1.00  9.22           C  
ATOM   1347  CD  ARG   155      16.797  16.292  17.398  1.00 10.33           C  
ATOM   1348  NE  ARG   155      17.769  17.358  17.568  1.00 11.99           N  
ATOM   1349  CZ  ARG   155      18.828  17.530  16.808  1.00 14.45           C  
ATOM   1350  NH1 ARG   155      19.024  16.722  15.791  1.00 15.52           N  
ATOM   1351  NH2 ARG   155      19.670  18.528  17.054  1.00 16.84           N  
ATOM   1352  N   ASP   156      15.362  19.584  20.332  1.00  9.30           N  
ATOM   1353  CA  ASP   156      16.298  19.952  21.405  1.00  9.93           C  
ATOM   1354  C   ASP   156      15.545  20.301  22.697  1.00  9.88           C  
ATOM   1355  O   ASP   156      15.968  19.913  23.810  1.00 11.08           O  
ATOM   1356  CB  ASP   156      17.200  21.090  20.947  1.00 12.09           C  
ATOM   1357  CG  ASP   156      18.225  20.653  19.904  1.00 13.32           C  
ATOM   1358  OD1 ASP   156      18.384  19.421  19.664  1.00 14.73           O  
ATOM   1359  OD2 ASP   156      18.899  21.574  19.376  1.00 17.02           O  
ATOM   1360  N   SER   157      14.455  21.054  22.589  1.00 10.33           N  
ATOM   1361  CA  SER   157      13.734  21.453  23.796  1.00 10.24           C  
ATOM   1362  C   SER   157      13.044  20.269  24.425  1.00 10.07           C  
ATOM   1363  O   SER   157      13.045  20.094  25.659  1.00 10.76           O  
ATOM   1364  CB  SER   157      12.756  22.581  23.556  1.00 12.70           C  
ATOM   1365  OG  SER   157      11.741  22.238  22.668  1.00 13.44           O  
ATOM   1366  N   ILE   158      12.435  19.435  23.599  1.00  8.70           N  
ATOM   1367  CA  ILE   158      11.747  18.261  24.120  1.00  8.89           C  
ATOM   1368  C   ILE   158      12.722  17.276  24.713  1.00  9.69           C  
ATOM   1369  O   ILE   158      12.473  16.699  25.778  1.00 10.84           O  
ATOM   1370  CB  ILE   158      10.876  17.594  23.019  1.00  8.88           C  
ATOM   1371  CG1 ILE   158       9.724  18.515  22.676  1.00 10.25           C  
ATOM   1372  CG2 ILE   158      10.386  16.204  23.471  1.00 11.17           C  
ATOM   1373  CD1 ILE   158       8.942  18.115  21.441  1.00 11.33           C  
ATOM   1374  N   SER   159      13.871  17.108  24.068  1.00 10.59           N  
ATOM   1375  CA  SER   159      14.876  16.162  24.577  0.49 11.67           C  
ATOM   1377  C   SER   159      15.283  16.503  25.973  1.00 10.55           C  
ATOM   1378  O   SER   159      15.410  15.630  26.837  1.00 12.90           O  
ATOM   1379  CB  SER   159      16.165  16.114  23.731  0.49 12.50           C  
ATOM   1381  OG  SER   159      17.221  15.442  24.443  0.49 14.69           O  
ATOM   1383  N   ALA   160      15.535  17.779  26.218  1.00 11.61           N  
ATOM   1384  CA  ALA   160      15.970  18.189  27.524  1.00 11.74           C  
ATOM   1385  C   ALA   160      14.956  17.798  28.587  1.00 12.77           C  
ATOM   1386  O   ALA   160      15.308  17.287  29.665  1.00 13.22           O  
ATOM   1387  CB  ALA   160      16.236  19.673  27.560  1.00 13.46           C  
ATOM   1388  N   GLU   161      13.680  18.009  28.292  1.00 12.13           N  
ATOM   1389  CA  GLU   161      12.634  17.667  29.251  0.55 12.38           C  
ATOM   1391  C   GLU   161      12.479  16.147  29.390  1.00 11.75           C  
ATOM   1392  O   GLU   161      12.273  15.633  30.509  1.00 13.35           O  
ATOM   1393  CB  GLU   161      11.303  18.312  28.880  0.55 13.15           C  
ATOM   1395  CG  GLU   161      10.244  18.097  29.926  0.55 16.08           C  
ATOM   1397  CD  GLU   161      10.558  18.730  31.262  0.55 21.94           C  
ATOM   1399  OE1 GLU   161      11.519  19.524  31.366  0.55 22.75           O  
ATOM   1401  OE2 GLU   161       9.803  18.436  32.217  0.55 26.74           O  
ATOM   1403  N   MET   162      12.535  15.402  28.295  1.00 11.57           N  
ATOM   1404  CA  MET   162      12.399  13.929  28.363  0.50 11.42           C  
ATOM   1406  C   MET   162      13.510  13.312  29.181  1.00 11.89           C  
ATOM   1407  O   MET   162      13.281  12.381  29.952  1.00 13.08           O  
ATOM   1408  CB  MET   162      12.330  13.252  26.986  0.50 10.93           C  
ATOM   1410  CG  MET   162      11.018  13.450  26.238  0.50  8.70           C  
ATOM   1412  SD  MET   162       9.464  12.746  27.149  0.38  6.08          SE  
ATOM   1414  CE  MET   162       9.887  10.868  26.999  0.50  7.35           C  
ATOM   1416  N   ILE   163      14.704  13.857  29.032  1.00 11.81           N  
ATOM   1417  CA  ILE   163      15.870  13.343  29.768  1.00 12.25           C  
ATOM   1418  C   ILE   163      15.686  13.582  31.270  1.00 12.44           C  
ATOM   1419  O   ILE   163      16.041  12.741  32.087  1.00 14.51           O  
ATOM   1420  CB  ILE   163      17.184  13.964  29.232  1.00 14.26           C  
ATOM   1421  CG1 ILE   163      17.425  13.418  27.830  1.00 14.80           C  
ATOM   1422  CG2 ILE   163      18.326  13.625  30.164  1.00 17.53           C  
ATOM   1423  CD1 ILE   163      18.497  14.126  27.067  1.00 18.03           C  
ATOM   1424  N   ARG   164      15.092  14.718  31.626  1.00 12.19           N  
ATOM   1425  CA  ARG   164      14.834  15.022  33.023  0.48 12.98           C  
ATOM   1427  C   ARG   164      13.788  14.056  33.608  1.00 12.06           C  
ATOM   1428  O   ARG   164      13.915  13.561  34.729  1.00 13.99           O  
ATOM   1429  CB  ARG   164      14.347  16.464  33.145  0.48 14.17           C  
ATOM   1431  CG  ARG   164      14.229  16.975  34.550  0.48 15.40           C  
ATOM   1433  CD  ARG   164      13.494  18.309  34.559  0.48 19.98           C  
ATOM   1435  NE  ARG   164      12.106  18.124  34.158  0.48 22.85           N  
ATOM   1437  CZ  ARG   164      11.158  17.694  34.981  0.48 20.45           C  
ATOM   1439  NH1 ARG   164      11.457  17.429  36.253  0.48 31.20           N  
ATOM   1441  NH2 ARG   164       9.922  17.531  34.543  0.48 27.60           N  
ATOM   1443  N   LYS   165      12.741  13.799  32.844  1.00 11.55           N  
ATOM   1444  CA  LYS   165      11.677  12.906  33.329  0.48 11.53           C  
ATOM   1446  C   LYS   165      12.099  11.445  33.360  1.00 10.63           C  
ATOM   1447  O   LYS   165      11.835  10.745  34.325  1.00 11.54           O  
ATOM   1448  CB  LYS   165      10.411  13.043  32.468  0.48 13.02           C  
ATOM   1450  CG  LYS   165       9.806  14.437  32.478  0.48 16.74           C  
ATOM   1452  CD  LYS   165       8.644  14.537  31.511  0.48 20.80           C  
ATOM   1454  CE  LYS   165       7.442  13.749  31.989  0.48 23.80           C  
ATOM   1456  NZ  LYS   165       6.840  14.325  33.224  0.48 26.95           N  
ATOM   1458  N   ASN   166      12.724  11.014  32.281  1.00 10.82           N  
ATOM   1459  CA  ASN   166      13.063   9.611  32.048  1.00 10.88           C  
ATOM   1460  C   ASN   166      14.519   9.498  31.579  1.00 11.38           C  
ATOM   1461  O   ASN   166      14.790   9.500  30.365  1.00 11.73           O  
ATOM   1462  CB  ASN   166      12.188   9.035  30.918  1.00 11.30           C  
ATOM   1463  CG  ASN   166      10.682   9.108  31.149  1.00 11.26           C  
ATOM   1464  OD1 ASN   166       9.917   9.301  30.187  1.00 11.85           O  
ATOM   1465  ND2 ASN   166      10.236   8.879  32.391  1.00 13.52           N  
ATOM   1466  N   PRO   167      15.457   9.423  32.517  1.00 10.53           N  
ATOM   1467  CA  PRO   167      16.849   9.532  32.099  1.00 11.73           C  
ATOM   1468  C   PRO   167      17.292   8.496  31.045  1.00 11.00           C  
ATOM   1469  O   PRO   167      18.087   8.832  30.160  1.00 13.71           O  
ATOM   1470  CB  PRO   167      17.612   9.368  33.404  1.00 13.75           C  
ATOM   1471  CG  PRO   167      16.643   9.861  34.436  1.00 13.20           C  
ATOM   1472  CD  PRO   167      15.288   9.488  33.977  1.00 11.16           C  
ATOM   1473  N   ASP   168      16.740   7.289  31.089  1.00 10.51           N  
ATOM   1474  CA  ASP   168      17.151   6.227  30.136  1.00 10.92           C  
ATOM   1475  C   ASP   168      16.623   6.452  28.726  1.00 10.34           C  
ATOM   1476  O   ASP   168      17.076   5.820  27.778  1.00 11.40           O  
ATOM   1477  CB  ASP   168      16.721   4.848  30.635  1.00 11.57           C  
ATOM   1478  CG  ASP   168      17.242   4.556  32.003  1.00 12.24           C  
ATOM   1479  OD1 ASP   168      18.445   4.301  32.146  1.00 15.10           O  
ATOM   1480  OD2 ASP   168      16.460   4.670  32.983  1.00 13.85           O  
ATOM   1481  N   TRP   169      15.652   7.357  28.572  1.00  9.95           N  
ATOM   1482  CA  TRP   169      15.118   7.675  27.240  1.00 10.25           C  
ATOM   1483  C   TRP   169      16.244   8.220  26.370  1.00 10.22           C  
ATOM   1484  O   TRP   169      16.245   8.017  25.159  1.00 11.17           O  
ATOM   1485  CB  TRP   169      13.975   8.700  27.355  1.00  9.83           C  
ATOM   1486  CG  TRP   169      13.529   9.285  26.049  1.00  9.55           C  
ATOM   1487  CD1 TRP   169      12.517   8.847  25.253  1.00 11.31           C  
ATOM   1488  CD2 TRP   169      14.071  10.429  25.412  1.00  9.57           C  
ATOM   1489  NE1 TRP   169      12.414   9.630  24.143  1.00 11.66           N  
ATOM   1490  CE2 TRP   169      13.379  10.600  24.204  1.00 10.57           C  
ATOM   1491  CE3 TRP   169      15.128  11.290  25.714  1.00 10.85           C  
ATOM   1492  CZ2 TRP   169      13.663  11.638  23.329  1.00 13.28           C  
ATOM   1493  CZ3 TRP   169      15.410  12.309  24.846  1.00 14.36           C  
ATOM   1494  CH2 TRP   169      14.704  12.468  23.666  1.00 14.08           C  
ATOM   1495  N   LYS   170      17.231   8.889  26.968  1.00 10.69           N  
ATOM   1496  CA  LYS   170      18.315   9.501  26.190  1.00 11.77           C  
ATOM   1497  C   LYS   170      18.976   8.440  25.285  1.00 11.41           C  
ATOM   1498  O   LYS   170      19.142   8.615  24.069  1.00 13.09           O  
ATOM   1499  CB  LYS   170      19.370  10.100  27.125  1.00 13.56           C  
ATOM   1500  CG  LYS   170      20.482  10.898  26.427  1.00 15.07           C  
ATOM   1501  CD  LYS   170      21.455  11.468  27.480  1.00 20.05           C  
ATOM   1502  CE  LYS   170      22.623  12.226  26.872  1.00 22.38           C  
ATOM   1503  NZ  LYS   170      23.477  12.888  27.928  1.00 26.03           N  
ATOM   1504  N   GLU   171      19.317   7.299  25.884  1.00 12.60           N  
ATOM   1505  CA  GLU   171      19.985   6.258  25.107  1.00 14.39           C  
ATOM   1506  C   GLU   171      19.083   5.553  24.118  1.00 13.40           C  
ATOM   1507  O   GLU   171      19.553   5.179  23.038  1.00 15.61           O  
ATOM   1508  CB  GLU   171      20.696   5.269  26.029  1.00 17.57           C  
ATOM   1509  CG  GLU   171      21.903   5.891  26.707  1.00 20.31           C  
ATOM   1510  CD  GLU   171      21.571   6.779  27.905  1.00 23.03           C  
ATOM   1511  OE1 GLU   171      20.478   6.635  28.536  1.00 21.01           O  
ATOM   1512  OE2 GLU   171      22.421   7.644  28.227  1.00 25.17           O  
ATOM   1513  N   PHE   172      17.814   5.350  24.454  1.00 12.47           N  
ATOM   1514  CA  PHE   172      16.885   4.673  23.532  1.00 12.40           C  
ATOM   1515  C   PHE   172      16.661   5.563  22.323  1.00 10.95           C  
ATOM   1516  O   PHE   172      16.792   5.140  21.194  1.00 12.60           O  
ATOM   1517  CB  PHE   172      15.588   4.311  24.259  1.00 12.73           C  
ATOM   1518  CG  PHE   172      14.576   3.593  23.425  1.00 11.50           C  
ATOM   1519  CD1 PHE   172      14.937   2.661  22.466  1.00 12.62           C  
ATOM   1520  CD2 PHE   172      13.219   3.757  23.674  1.00 11.41           C  
ATOM   1521  CE1 PHE   172      13.977   1.982  21.757  1.00 14.13           C  
ATOM   1522  CE2 PHE   172      12.275   3.071  22.952  1.00 12.14           C  
ATOM   1523  CZ  PHE   172      12.655   2.198  21.989  1.00 12.34           C  
ATOM   1524  N   ASN   173      16.402   6.833  22.570  1.00 10.78           N  
ATOM   1525  CA  ASN   173      16.220   7.780  21.470  1.00 11.90           C  
ATOM   1526  C   ASN   173      17.456   7.850  20.578  1.00 13.16           C  
ATOM   1527  O   ASN   173      17.347   7.880  19.350  1.00 13.46           O  
ATOM   1528  CB  ASN   173      15.864   9.156  22.037  1.00 12.64           C  
ATOM   1529  CG  ASN   173      15.897  10.241  20.994  1.00 13.41           C  
ATOM   1530  OD1 ASN   173      16.769  11.119  21.034  1.00 16.00           O  
ATOM   1531  ND2 ASN   173      14.958  10.210  20.068  1.00 14.40           N  
ATOM   1532  N   ARG   174      18.649   7.858  21.186  1.00 13.04           N  
ATOM   1533  CA  ARG   174      19.901   7.930  20.425  0.48 14.77           C  
ATOM   1535  C   ARG   174      20.096   6.693  19.544  1.00 16.70           C  
ATOM   1536  O   ARG   174      20.609   6.780  18.432  1.00 20.85           O  
ATOM   1537  CB  ARG   174      21.099   8.222  21.333  0.48 16.10           C  
ATOM   1539  CG  ARG   174      21.052   9.689  21.766  0.48 17.56           C  
ATOM   1541  CD  ARG   174      22.141  10.214  22.690  0.48 15.61           C  
ATOM   1543  NE  ARG   174      22.118  11.677  22.677  0.48 15.38           N  
ATOM   1545  CZ  ARG   174      23.148  12.434  23.062  0.48 13.73           C  
ATOM   1547  NH1 ARG   174      24.245  11.846  23.518  0.48 12.38           N  
ATOM   1549  NH2 ARG   174      23.073  13.755  22.962  0.48 16.09           N  
ATOM   1551  N   LYS   175      19.647   5.550  20.010  1.00 16.04           N  
ATOM   1552  CA  LYS   175      19.687   4.319  19.196  1.00 15.62           C  
ATOM   1553  C   LYS   175      18.639   4.400  18.071  1.00 15.85           C  
ATOM   1554  O   LYS   175      18.934   4.046  16.920  1.00 18.40           O  
ATOM   1555  CB  LYS   175      19.432   3.092  20.053  1.00 19.52           C  
ATOM   1556  N   ASN   176      17.441   4.873  18.364  1.00 12.96           N  
ATOM   1557  CA  ASN   176      16.359   4.951  17.389  1.00 13.62           C  
ATOM   1558  C   ASN   176      16.675   5.877  16.204  1.00 12.82           C  
ATOM   1559  O   ASN   176      16.535   5.495  15.045  1.00 12.24           O  
ATOM   1560  CB  ASN   176      15.063   5.432  18.048  1.00 13.13           C  
ATOM   1561  CG  ASN   176      14.461   4.409  18.990  1.00 12.85           C  
ATOM   1562  OD1 ASN   176      14.782   3.232  18.934  1.00 14.11           O  
ATOM   1563  ND2 ASN   176      13.585   4.866  19.853  1.00 12.52           N  
ATOM   1564  N   ILE   177      17.118   7.084  16.523  1.00 12.61           N  
ATOM   1565  CA  ILE   177      17.308   8.114  15.502  1.00 13.60           C  
ATOM   1566  C   ILE   177      18.782   8.149  15.140  1.00 15.44           C  
ATOM   1567  O   ILE   177      19.509   9.067  15.487  1.00 16.67           O  
ATOM   1568  CB  ILE   177      16.792   9.483  15.994  1.00 15.08           C  
ATOM   1569  CG1 ILE   177      15.396   9.382  16.617  1.00 18.27           C  
ATOM   1570  CG2 ILE   177      16.807  10.509  14.844  1.00 17.17           C  
ATOM   1571  CD1 ILE   177      14.325   8.832  15.691  1.00 18.17           C  
ATOM   1572  N   SER   178      19.239   7.101  14.460  1.00 15.05           N  
ATOM   1573  CA  SER   178      20.612   7.012  14.057  1.00 15.96           C  
ATOM   1574  C   SER   178      20.837   6.112  12.866  1.00 13.51           C  
ATOM   1575  O   SER   178      19.916   5.470  12.347  1.00 13.40           O  
ATOM   1576  CB  SER   178      21.474   6.475  15.191  1.00 18.42           C  
ATOM   1577  OG  SER   178      21.264   5.106  15.353  1.00 21.32           O  
ATOM   1578  N   GLN   179      22.111   6.052  12.446  1.00 12.66           N  
ATOM   1579  CA  GLN   179      22.465   5.275  11.267  1.00 11.66           C  
ATOM   1580  C   GLN   179      22.336   3.788  11.483  1.00 12.77           C  
ATOM   1581  O   GLN   179      22.332   3.027  10.526  1.00 12.79           O  
ATOM   1582  CB  GLN   179      23.813   5.688  10.698  1.00 11.62           C  
ATOM   1583  CG  GLN   179      23.701   7.044  10.037  1.00 10.61           C  
ATOM   1584  CD  GLN   179      24.906   7.306   9.178  1.00 11.06           C  
ATOM   1585  OE1 GLN   179      25.158   6.546   8.222  1.00 14.43           O  
ATOM   1586  NE2 GLN   179      25.689   8.341   9.513  1.00 11.50           N  
ATOM   1587  N   GLU   180      22.236   3.362  12.739  1.00 13.28           N  
ATOM   1588  CA  GLU   180      22.004   1.933  12.996  1.00 15.08           C  
ATOM   1589  C   GLU   180      20.712   1.501  12.323  1.00 13.96           C  
ATOM   1590  O   GLU   180      20.633   0.430  11.717  1.00 14.16           O  
ATOM   1591  CB  GLU   180      21.925   1.653  14.478  1.00 16.38           C  
ATOM   1592  N   ASN   181      19.689   2.321  12.437  1.00 11.35           N  
ATOM   1593  CA  ASN   181      18.395   2.062  11.840  1.00 11.90           C  
ATOM   1594  C   ASN   181      18.380   2.340  10.369  1.00 10.50           C  
ATOM   1595  O   ASN   181      17.599   1.680   9.651  1.00 11.78           O  
ATOM   1596  CB  ASN   181      17.262   2.736  12.601  1.00 11.76           C  
ATOM   1597  CG  ASN   181      16.897   1.951  13.810  1.00 12.13           C  
ATOM   1598  OD1 ASN   181      16.926   0.701  13.778  1.00 14.58           O  
ATOM   1599  ND2 ASN   181      16.579   2.629  14.879  1.00 13.07           N  
ATOM   1600  N   VAL   182      19.204   3.283   9.912  1.00  9.58           N  
ATOM   1601  CA  VAL   182      19.272   3.485   8.479  1.00  8.94           C  
ATOM   1602  C   VAL   182      19.767   2.174   7.856  1.00  9.93           C  
ATOM   1603  O   VAL   182      19.159   1.675   6.880  1.00 10.78           O  
ATOM   1604  CB  VAL   182      20.145   4.664   8.107  1.00  9.53           C  
ATOM   1605  CG1 VAL   182      20.256   4.772   6.608  1.00 11.17           C  
ATOM   1606  CG2 VAL   182      19.567   5.967   8.706  1.00 10.62           C  
ATOM   1607  N   GLU   183      20.825   1.598   8.421  1.00  9.99           N  
ATOM   1608  CA  GLU   183      21.371   0.354   7.924  0.50 10.11           C  
ATOM   1610  C   GLU   183      20.409  -0.811   8.080  1.00  9.86           C  
ATOM   1611  O   GLU   183      20.173  -1.614   7.176  1.00 10.02           O  
ATOM   1612  CB  GLU   183      22.661   0.012   8.643  0.50 11.35           C  
ATOM   1614  CG  GLU   183      23.194  -1.326   8.178  0.50 15.01           C  
ATOM   1616  CD  GLU   183      24.666  -1.300   7.952  0.50 15.08           C  
ATOM   1618  OE1 GLU   183      25.108  -0.396   7.213  0.50 30.11           O  
ATOM   1620  OE2 GLU   183      25.371  -2.198   8.448  0.50 31.87           O  
ATOM   1622  N   ARG   184      19.834  -0.915   9.260  1.00 10.06           N  
ATOM   1623  CA  ARG   184      18.922  -2.019   9.533  1.00 10.17           C  
ATOM   1624  C   ARG   184      17.794  -2.061   8.513  1.00 10.00           C  
ATOM   1625  O   ARG   184      17.482  -3.102   7.929  1.00  9.98           O  
ATOM   1626  CB  ARG   184      18.309  -1.917  10.925  1.00 11.15           C  
ATOM   1627  CG  ARG   184      17.365  -3.060  11.290  1.00 12.30           C  
ATOM   1628  CD  ARG   184      16.673  -2.910  12.630  1.00 14.09           C  
ATOM   1629  NE  ARG   184      15.909  -4.137  12.851  1.00 15.57           N  
ATOM   1630  CZ  ARG   184      14.839  -4.272  13.608  1.00 16.60           C  
ATOM   1631  NH1 ARG   184      14.346  -3.265  14.264  1.00 17.24           N  
ATOM   1632  NH2 ARG   184      14.261  -5.452  13.681  1.00 18.03           N  
ATOM   1633  N   PHE   185      17.158  -0.913   8.327  1.00  9.53           N  
ATOM   1634  CA  PHE   185      15.985  -0.841   7.456  1.00  8.59           C  
ATOM   1635  C   PHE   185      16.310  -0.868   5.975  1.00  9.00           C  
ATOM   1636  O   PHE   185      15.525  -1.396   5.205  1.00  9.94           O  
ATOM   1637  CB  PHE   185      15.022   0.247   7.929  1.00  9.55           C  
ATOM   1638  CG  PHE   185      14.341  -0.144   9.178  1.00  9.01           C  
ATOM   1639  CD1 PHE   185      13.326  -1.089   9.134  1.00 10.44           C  
ATOM   1640  CD2 PHE   185      14.745   0.311  10.394  1.00 10.18           C  
ATOM   1641  CE1 PHE   185      12.731  -1.530  10.291  1.00 10.34           C  
ATOM   1642  CE2 PHE   185      14.155  -0.112  11.546  1.00 11.02           C  
ATOM   1643  CZ  PHE   185      13.150  -1.037  11.509  1.00 10.75           C  
ATOM   1644  N   GLN   186      17.472  -0.352   5.587  1.00  8.84           N  
ATOM   1645  CA  GLN   186      17.917  -0.531   4.218  1.00  9.83           C  
ATOM   1646  C   GLN   186      17.985  -2.034   3.954  1.00  9.36           C  
ATOM   1647  O   GLN   186      17.537  -2.522   2.916  1.00  9.42           O  
ATOM   1648  CB  GLN   186      19.305   0.129   4.042  1.00 12.65           C  
ATOM   1649  CG  GLN   186      20.120  -0.095   2.882  1.00 18.81           C  
ATOM   1650  CD  GLN   186      21.548   0.468   3.124  1.00 22.78           C  
ATOM   1651  OE1 GLN   186      22.411   0.262   2.315  1.00 33.67           O  
ATOM   1652  NE2 GLN   186      21.755   1.195   4.243  1.00 25.78           N  
ATOM   1653  N   ASN   187      18.574  -2.780   4.901  1.00  8.98           N  
ATOM   1654  CA  ASN   187      18.703  -4.226   4.689  1.00  9.69           C  
ATOM   1655  C   ASN   187      17.351  -4.932   4.599  1.00  8.77           C  
ATOM   1656  O   ASN   187      17.148  -5.820   3.770  1.00  9.73           O  
ATOM   1657  CB  ASN   187      19.556  -4.867   5.772  1.00  9.65           C  
ATOM   1658  CG  ASN   187      21.018  -4.446   5.706  1.00 12.77           C  
ATOM   1659  OD1 ASN   187      21.483  -3.948   4.685  1.00 16.60           O  
ATOM   1660  ND2 ASN   187      21.743  -4.623   6.805  1.00 15.21           N  
ATOM   1661  N   VAL   188      16.389  -4.487   5.393  1.00  8.25           N  
ATOM   1662  CA  VAL   188      15.047  -5.049   5.336  1.00  8.78           C  
ATOM   1663  C   VAL   188      14.388  -4.804   3.984  1.00  8.05           C  
ATOM   1664  O   VAL   188      13.844  -5.713   3.339  1.00  7.98           O  
ATOM   1665  CB  VAL   188      14.137  -4.456   6.454  1.00  9.61           C  
ATOM   1666  CG1 VAL   188      12.671  -4.878   6.284  1.00 11.93           C  
ATOM   1667  CG2 VAL   188      14.637  -4.839   7.854  1.00 11.67           C  
ATOM   1668  N   LEU   189      14.438  -3.562   3.511  1.00  7.78           N  
ATOM   1669  CA  LEU   189      13.810  -3.207   2.247  1.00  8.02           C  
ATOM   1670  C   LEU   189      14.519  -3.911   1.101  1.00  7.78           C  
ATOM   1671  O   LEU   189      13.890  -4.315   0.122  1.00  8.52           O  
ATOM   1672  CB  LEU   189      13.816  -1.686   2.040  1.00  8.06           C  
ATOM   1673  CG  LEU   189      13.040  -0.877   3.107  1.00  8.50           C  
ATOM   1674  CD1 LEU   189      12.931   0.554   2.625  1.00 10.54           C  
ATOM   1675  CD2 LEU   189      11.636  -1.447   3.420  1.00 10.09           C  
ATOM   1676  N   ASP   190      15.834  -4.068   1.212  1.00  7.87           N  
ATOM   1677  CA  ASP   190      16.601  -4.713   0.145  1.00  8.50           C  
ATOM   1678  C   ASP   190      16.271  -6.199   0.063  1.00  8.73           C  
ATOM   1679  O   ASP   190      16.233  -6.759  -1.037  1.00  9.75           O  
ATOM   1680  CB  ASP   190      18.082  -4.445   0.330  1.00  9.21           C  
ATOM   1681  CG  ASP   190      18.453  -2.983   0.110  1.00 10.79           C  
ATOM   1682  OD1 ASP   190      17.642  -2.201  -0.440  1.00 10.77           O  
ATOM   1683  OD2 ASP   190      19.584  -2.637   0.479  1.00 13.31           O  
ATOM   1684  N   GLU   191      16.024  -6.844   1.197  1.00  8.92           N  
ATOM   1685  CA  GLU   191      15.633  -8.271   1.170  1.00  9.18           C  
ATOM   1686  C   GLU   191      14.268  -8.414   0.494  1.00  9.15           C  
ATOM   1687  O   GLU   191      14.035  -9.403  -0.227  1.00 10.43           O  
ATOM   1688  CB  GLU   191      15.612  -8.868   2.567  1.00 10.40           C  
ATOM   1689  CG  GLU   191      15.204 -10.367   2.612  1.00 11.99           C  
ATOM   1690  CD  GLU   191      13.683 -10.691   2.617  1.00 12.18           C  
ATOM   1691  OE1 GLU   191      12.889  -9.991   3.258  1.00 13.76           O  
ATOM   1692  OE2 GLU   191      13.263 -11.738   2.018  1.00 15.64           O  
ATOM   1693  N   ILE   192      13.353  -7.475   0.691  1.00  8.64           N  
ATOM   1694  CA  ILE   192      12.043  -7.496   0.030  1.00  9.11           C  
ATOM   1695  C   ILE   192      12.183  -7.248  -1.450  1.00  9.06           C  
ATOM   1696  O   ILE   192      11.431  -7.781  -2.257  1.00  9.77           O  
ATOM   1697  CB  ILE   192      11.068  -6.503   0.695  1.00  9.34           C  
ATOM   1698  CG1 ILE   192      10.788  -6.949   2.134  1.00  8.99           C  
ATOM   1699  CG2 ILE   192       9.760  -6.398  -0.105  1.00 11.12           C  
ATOM   1700  CD1 ILE   192      10.126  -5.867   2.992  1.00 10.95           C  
ATOM   1701  N   GLY   193      13.144  -6.415  -1.808  1.00  8.48           N  
ATOM   1702  CA  GLY   193      13.440  -6.090  -3.201  1.00  8.98           C  
ATOM   1703  C   GLY   193      12.861  -4.806  -3.741  1.00  8.30           C  
ATOM   1704  O   GLY   193      12.757  -4.611  -4.937  1.00  8.89           O  
ATOM   1705  N   VAL   194      12.532  -3.893  -2.833  1.00  7.89           N  
ATOM   1706  CA  VAL   194      11.916  -2.609  -3.147  0.51  7.79           C  
ATOM   1708  C   VAL   194      12.786  -1.844  -4.138  1.00  7.24           C  
ATOM   1709  O   VAL   194      13.965  -1.612  -3.880  1.00  8.42           O  
ATOM   1710  CB  VAL   194      11.754  -1.756  -1.841  0.51  7.93           C  
ATOM   1712  CG1 VAL   194      10.847  -2.466  -0.813  0.51  8.64           C  
ATOM   1714  CG2 VAL   194      11.224  -0.366  -2.159  0.51  8.88           C  
ATOM   1718  N   SER   195      12.197  -1.421  -5.252  1.00  7.24           N  
ATOM   1719  CA  SER   195      12.967  -0.743  -6.320  1.00  7.37           C  
ATOM   1720  C   SER   195      13.335   0.701  -6.038  1.00  7.01           C  
ATOM   1721  O   SER   195      14.316   1.197  -6.559  1.00  7.47           O  
ATOM   1722  CB  SER   195      12.163  -0.766  -7.641  1.00  8.14           C  
ATOM   1723  OG  SER   195      11.981  -2.081  -8.152  1.00  8.78           O  
ATOM   1724  N   SER   196      12.468   1.389  -5.289  1.00  6.94           N  
ATOM   1725  CA  SER   196      12.607   2.835  -5.057  1.00  6.98           C  
ATOM   1726  C   SER   196      12.274   3.215  -3.630  1.00  6.76           C  
ATOM   1727  O   SER   196      11.174   3.030  -3.178  1.00  7.30           O  
ATOM   1728  CB  SER   196      11.649   3.562  -6.000  1.00  8.24           C  
ATOM   1729  OG  SER   196      11.766   4.957  -5.877  1.00 13.11           O  
ATOM   1730  N   TYR   197      13.265   3.786  -2.951  1.00  6.84           N  
ATOM   1731  CA  TYR   197      13.055   4.342  -1.605  1.00  7.15           C  
ATOM   1732  C   TYR   197      14.146   5.331  -1.250  1.00  6.91           C  
ATOM   1733  O   TYR   197      15.220   5.364  -1.855  1.00  7.22           O  
ATOM   1734  CB  TYR   197      12.968   3.226  -0.522  1.00  7.54           C  
ATOM   1735  CG  TYR   197      14.250   2.433  -0.278  1.00  7.94           C  
ATOM   1736  CD1 TYR   197      15.315   2.975   0.407  1.00  7.60           C  
ATOM   1737  CD2 TYR   197      14.379   1.132  -0.695  1.00  8.03           C  
ATOM   1738  CE1 TYR   197      16.481   2.241   0.648  1.00  8.83           C  
ATOM   1739  CE2 TYR   197      15.537   0.397  -0.475  1.00  7.92           C  
ATOM   1740  CZ  TYR   197      16.576   0.945   0.222  1.00  8.01           C  
ATOM   1741  OH  TYR   197      17.767   0.278   0.428  1.00  9.56           O  
ATOM   1742  N   GLU   198      13.835   6.124  -0.230  1.00  6.59           N  
ATOM   1743  CA  GLU   198      14.793   6.930   0.476  1.00  6.92           C  
ATOM   1744  C   GLU   198      14.661   6.600   1.966  1.00  6.27           C  
ATOM   1745  O   GLU   198      13.552   6.411   2.453  1.00  7.47           O  
ATOM   1746  CB  GLU   198      14.472   8.434   0.367  1.00  8.45           C  
ATOM   1747  CG  GLU   198      14.424   9.011  -1.009  1.00  9.66           C  
ATOM   1748  CD  GLU   198      13.665  10.326  -1.024  1.00 10.13           C  
ATOM   1749  OE1 GLU   198      12.453  10.271  -0.705  1.00 12.22           O  
ATOM   1750  OE2 GLU   198      14.270  11.365  -1.314  1.00 11.95           O  
ATOM   1751  N   ILE   199      15.766   6.531   2.680  1.00  7.15           N  
ATOM   1752  CA  ILE   199      15.745   6.453   4.152  1.00  6.80           C  
ATOM   1753  C   ILE   199      16.548   7.648   4.584  1.00  7.33           C  
ATOM   1754  O   ILE   199      17.709   7.774   4.207  1.00  8.81           O  
ATOM   1755  CB  ILE   199      16.281   5.152   4.712  1.00  8.16           C  
ATOM   1756  CG1 ILE   199      15.483   3.958   4.181  1.00  8.20           C  
ATOM   1757  CG2 ILE   199      16.222   5.172   6.218  1.00  9.74           C  
ATOM   1758  CD1 ILE   199      16.030   2.597   4.607  1.00 11.40           C  
ATOM   1759  N   ILE   200      15.932   8.530   5.353  1.00  6.71           N  
ATOM   1760  CA  ILE   200      16.532   9.816   5.736  0.51  7.29           C  
ATOM   1762  C   ILE   200      16.774   9.915   7.225  1.00  7.22           C  
ATOM   1763  O   ILE   200      16.058   9.315   8.048  1.00  7.79           O  
ATOM   1764  CB  ILE   200      15.663  11.043   5.332  0.51  6.86           C  
ATOM   1766  CG1 ILE   200      14.341  11.073   6.081  0.51  7.78           C  
ATOM   1768  CG2 ILE   200      15.423  11.099   3.796  0.51  9.15           C  
ATOM   1770  CD1 ILE   200      13.596  12.351   5.802  0.51  9.79           C  
ATOM   1772  N   LEU   201      17.775  10.704   7.570  1.00  7.47           N  
ATOM   1773  CA  LEU   201      18.106  10.998   8.946  1.00  7.40           C  
ATOM   1774  C   LEU   201      18.587  12.431   9.000  1.00  7.56           C  
ATOM   1775  O   LEU   201      19.544  12.790   8.349  1.00  9.03           O  
ATOM   1776  CB  LEU   201      19.164  10.022   9.454  1.00  8.16           C  
ATOM   1777  CG  LEU   201      19.712  10.249  10.831  1.00 10.34           C  
ATOM   1778  CD1 LEU   201      18.664  10.070  11.893  1.00 13.16           C  
ATOM   1779  CD2 LEU   201      20.915   9.304  11.050  1.00 13.25           C  
ATOM   1780  N   GLU   202      17.900  13.238   9.787  1.00  8.39           N  
ATOM   1781  CA  GLU   202      18.265  14.623   9.936  1.00  9.66           C  
ATOM   1782  C   GLU   202      17.541  15.269  11.080  1.00  9.31           C  
ATOM   1783  O   GLU   202      17.020  14.596  11.960  1.00  9.63           O  
ATOM   1784  N   ASP   203      17.484  16.584  11.052  1.00 10.94           N  
ATOM   1785  CA  ASP   203      16.906  17.309  12.187  1.00 12.13           C  
ATOM   1786  C   ASP   203      15.431  17.019  12.393  1.00 11.44           C  
ATOM   1787  O   ASP   203      14.918  17.250  13.478  1.00 12.93           O  
ATOM   1788  CB  ASP   203      17.175  18.812  12.072  1.00 14.32           C  
ATOM   1789  CG  ASP   203      18.660  19.168  12.294  1.00 15.59           C  
ATOM   1790  OD1 ASP   203      19.428  18.384  12.885  1.00 17.55           O  
ATOM   1791  OD2 ASP   203      19.060  20.272  11.925  1.00 21.01           O  
ATOM   1792  N   GLU   204      14.757  16.514  11.387  0.51 10.46           N  
ATOM   1794  CA  GLU   204      13.337  16.242  11.520  0.51 10.84           C  
ATOM   1796  C   GLU   204      13.061  14.843  12.010  0.51 10.34           C  
ATOM   1798  O   GLU   204      11.934  14.482  12.340  0.51 10.98           O  
ATOM   1800  CB  GLU   204      12.628  16.441  10.193  0.51 11.71           C  
ATOM   1802  CG  GLU   204      13.002  15.418   9.132  0.51 12.75           C  
ATOM   1804  CD  GLU   204      14.113  15.834   8.179  0.51 13.60           C  
ATOM   1806  OE1 GLU   204      15.214  16.370   8.566  0.51 14.70           O  
ATOM   1808  OE2 GLU   204      13.877  15.583   6.979  0.51 15.00           O  
ATOM   1810  N   GLY   205      14.119  14.063  12.056  1.00  9.31           N  
ATOM   1811  CA  GLY   205      14.065  12.680  12.560  1.00  9.02           C  
ATOM   1812  C   GLY   205      14.623  11.644  11.596  1.00  8.05           C  
ATOM   1813  O   GLY   205      15.423  11.968  10.705  1.00  8.62           O  
ATOM   1814  N   PHE   206      14.190  10.405  11.815  1.00  7.06           N  
ATOM   1815  CA  PHE   206      14.561   9.218  11.017  1.00  6.37           C  
ATOM   1816  C   PHE   206      13.286   8.781  10.308  1.00  6.15           C  
ATOM   1817  O   PHE   206      12.287   8.508  10.975  1.00  6.14           O  
ATOM   1818  CB  PHE   206      15.040   8.099  11.939  1.00  7.23           C  
ATOM   1819  CG  PHE   206      15.071   6.743  11.261  1.00  8.04           C  
ATOM   1820  CD1 PHE   206      16.090   6.393  10.396  1.00  9.90           C  
ATOM   1821  CD2 PHE   206      14.064   5.842  11.437  1.00  9.37           C  
ATOM   1822  CE1 PHE   206      16.076   5.167   9.762  1.00 10.64           C  
ATOM   1823  CE2 PHE   206      14.067   4.597  10.797  1.00 10.05           C  
ATOM   1824  CZ  PHE   206      15.066   4.283   9.978  1.00  9.14           C  
ATOM   1825  N   TRP   207      13.302   8.677   8.971  1.00  5.96           N  
ATOM   1826  CA  TRP   207      12.075   8.353   8.231  1.00  5.95           C  
ATOM   1827  C   TRP   207      12.387   7.496   7.015  1.00  6.25           C  
ATOM   1828  O   TRP   207      13.307   7.774   6.248  1.00  7.20           O  
ATOM   1829  CB  TRP   207      11.338   9.619   7.803  1.00  6.22           C  
ATOM   1830  CG  TRP   207      11.025  10.523   8.968  1.00  6.85           C  
ATOM   1831  CD1 TRP   207      11.767  11.579   9.408  1.00  7.54           C  
ATOM   1832  CD2 TRP   207       9.936  10.403   9.871  1.00  6.13           C  
ATOM   1833  NE1 TRP   207      11.189  12.128  10.521  1.00  7.82           N  
ATOM   1834  CE2 TRP   207      10.062  11.424  10.828  1.00  6.99           C  
ATOM   1835  CE3 TRP   207       8.857   9.532   9.965  1.00  7.19           C  
ATOM   1836  CZ2 TRP   207       9.123  11.610  11.854  1.00  7.88           C  
ATOM   1837  CZ3 TRP   207       7.911   9.720  10.987  1.00  7.28           C  
ATOM   1838  CH2 TRP   207       8.067  10.745  11.909  1.00  8.41           C  
ATOM   1839  N   ILE   208      11.558   6.463   6.848  1.00  5.94           N  
ATOM   1840  CA  ILE   208      11.600   5.524   5.739  1.00  6.12           C  
ATOM   1841  C   ILE   208      10.537   5.928   4.739  1.00  5.45           C  
ATOM   1842  O   ILE   208       9.349   5.952   5.059  1.00  6.40           O  
ATOM   1843  CB  ILE   208      11.359   4.101   6.262  1.00  5.82           C  
ATOM   1844  CG1 ILE   208      12.436   3.678   7.274  1.00  7.29           C  
ATOM   1845  CG2 ILE   208      11.250   3.117   5.101  1.00  8.18           C  
ATOM   1846  CD1 ILE   208      12.021   2.499   8.167  1.00  7.79           C  
ATOM   1847  N   ILE   209      10.987   6.219   3.519  1.00  5.86           N  
ATOM   1848  CA  ILE   209      10.141   6.784   2.468  1.00  6.44           C  
ATOM   1849  C   ILE   209      10.178   5.901   1.224  1.00  5.76           C  
ATOM   1850  O   ILE   209      11.044   6.015   0.339  1.00  6.98           O  
ATOM   1851  CB  ILE   209      10.618   8.215   2.113  1.00  6.53           C  
ATOM   1852  CG1 ILE   209      10.623   9.090   3.364  1.00  7.73           C  
ATOM   1853  CG2 ILE   209       9.744   8.827   1.014  1.00  7.77           C  
ATOM   1854  CD1 ILE   209      11.241  10.463   3.206  1.00  9.24           C  
ATOM   1855  N   ILE   210       9.238   4.975   1.184  1.00  6.60           N  
ATOM   1856  CA  ILE   210       9.101   4.036   0.090  1.00  6.60           C  
ATOM   1857  C   ILE   210       8.194   4.654  -0.956  1.00  7.33           C  
ATOM   1858  O   ILE   210       7.182   5.254  -0.639  1.00  8.13           O  
ATOM   1859  CB  ILE   210       8.496   2.718   0.596  1.00  7.30           C  
ATOM   1860  CG1 ILE   210       9.459   2.044   1.593  1.00  8.56           C  
ATOM   1861  CG2 ILE   210       8.152   1.778  -0.566  1.00  9.41           C  
ATOM   1862  CD1 ILE   210       8.779   1.030   2.522  1.00 10.57           C  
ATOM   1863  N   SER   211       8.542   4.428  -2.218  1.00  7.80           N  
ATOM   1864  CA  SER   211       7.704   4.787  -3.346  1.00  9.51           C  
ATOM   1865  C   SER   211       7.310   3.536  -4.068  1.00  9.69           C  
ATOM   1866  O   SER   211       8.175   2.864  -4.583  1.00 14.81           O  
ATOM   1867  CB  SER   211       8.463   5.621  -4.353  1.00 10.93           C  
ATOM   1868  OG  SER   211       8.739   6.890  -3.859  1.00 12.33           O  
ATOM   1869  N   LYS   212       6.037   3.229  -4.210  1.00 10.63           N  
ATOM   1870  CA  LYS   212       5.665   2.060  -4.958  1.00 10.65           C  
ATOM   1871  C   LYS   212       5.632   2.404  -6.409  1.00  9.76           C  
ATOM   1872  O   LYS   212       4.902   3.275  -6.862  1.00 12.14           O  
ATOM   1873  CB  LYS   212       4.309   1.506  -4.519  1.00 11.11           C  
ATOM   1874  CG  LYS   212       3.923   0.279  -5.352  1.00 13.46           C  
ATOM   1875  CD  LYS   212       2.588  -0.397  -5.039  1.00 18.87           C  
ATOM   1876  CE  LYS   212       2.723  -1.451  -4.033  1.00 15.44           C  
ATOM   1877  NZ  LYS   212       1.493  -2.207  -3.667  1.00  9.74           N  
ATOM   1878  N   THR   213       6.431   1.694  -7.159  1.00 12.74           N  
ATOM   1879  CA  THR   213       6.569   1.950  -8.568  1.00 12.48           C  
ATOM   1880  C   THR   213       6.693   0.638  -9.305  1.00 10.87           C  
ATOM   1881  O   THR   213       7.025  -0.379  -8.733  1.00 13.74           O  
ATOM   1882  CB  THR   213       7.791   2.873  -8.803  1.00 13.61           C  
ATOM   1883  OG1 THR   213       7.713   3.501 -10.087  1.00 17.55           O  
ATOM   1884  CG2 THR   213       9.149   2.143  -8.597  1.00 15.43           C  
ATOM   1885  N   ASP   214       6.456   0.674 -10.605  1.00 10.89           N  
ATOM   1886  CA  ASP   214       6.591  -0.516 -11.448  1.00 10.60           C  
ATOM   1887  C   ASP   214       8.030  -1.029 -11.294  1.00 11.07           C  
ATOM   1888  O   ASP   214       8.984  -0.292 -11.512  1.00 11.94           O  
ATOM   1889  CB  ASP   214       6.265  -0.193 -12.889  1.00 12.55           C  
ATOM   1890  CG  ASP   214       4.780   0.093 -13.126  1.00 13.76           C  
ATOM   1891  OD1 ASP   214       3.917  -0.336 -12.313  1.00 15.87           O  
ATOM   1892  OD2 ASP   214       4.482   0.751 -14.144  1.00 17.35           O  
ATOM   1893  N   GLN   215       8.167  -2.276 -10.897  1.00  9.57           N  
ATOM   1894  CA  GLN   215       9.446  -2.776 -10.472  1.00  8.21           C  
ATOM   1895  C   GLN   215      10.493  -2.921 -11.555  1.00  8.15           C  
ATOM   1896  O   GLN   215      10.210  -3.132 -12.735  1.00  9.83           O  
ATOM   1897  CB  GLN   215       9.325  -4.059  -9.688  1.00  9.05           C  
ATOM   1898  CG  GLN   215       8.982  -5.284 -10.470  1.00 10.29           C  
ATOM   1899  CD  GLN   215       9.012  -6.495  -9.570  1.00  9.65           C  
ATOM   1900  OE1 GLN   215       8.463  -6.458  -8.451  1.00 10.50           O  
ATOM   1901  NE2 GLN   215       9.664  -7.570 -10.003  1.00  9.58           N  
ATOM   1902  N   GLU   216      11.743  -2.895 -11.125  1.00  8.07           N  
ATOM   1903  CA  GLU   216      12.863  -2.943 -12.054  1.00  8.31           C  
ATOM   1904  C   GLU   216      13.142  -4.322 -12.618  1.00  8.10           C  
ATOM   1905  O   GLU   216      13.691  -4.421 -13.713  1.00  9.58           O  
ATOM   1906  CB  GLU   216      14.129  -2.364 -11.402  1.00  9.90           C  
ATOM   1907  CG  GLU   216      14.607  -3.115 -10.206  1.00  8.84           C  
ATOM   1908  CD  GLU   216      15.623  -2.326  -9.428  1.00  9.44           C  
ATOM   1909  OE1 GLU   216      16.487  -1.646 -10.041  1.00 11.52           O  
ATOM   1910  OE2 GLU   216      15.587  -2.398  -8.197  1.00 10.51           O  
ATOM   1911  N   VAL   217      12.804  -5.374 -11.889  1.00  7.86           N  
ATOM   1912  CA  VAL   217      13.046  -6.739 -12.369  1.00  8.11           C  
ATOM   1913  C   VAL   217      11.827  -7.236 -13.112  1.00  7.99           C  
ATOM   1914  O   VAL   217      10.778  -7.528 -12.532  1.00  9.26           O  
ATOM   1915  CB  VAL   217      13.419  -7.703 -11.210  1.00  8.89           C  
ATOM   1916  CG1 VAL   217      13.576  -9.130 -11.753  1.00 11.10           C  
ATOM   1917  CG2 VAL   217      14.685  -7.236 -10.507  1.00 10.59           C  
ATOM   1918  N   ILE   218      11.981  -7.338 -14.425  1.00  8.45           N  
ATOM   1919  CA  ILE   218      10.971  -7.885 -15.321  1.00  9.15           C  
ATOM   1920  C   ILE   218      11.632  -8.729 -16.414  1.00 10.29           C  
ATOM   1921  O   ILE   218      12.876  -8.674 -16.590  1.00 10.34           O  
ATOM   1922  CB  ILE   218      10.052  -6.829 -15.982  1.00 10.14           C  
ATOM   1923  CG1 ILE   218      10.841  -5.840 -16.818  1.00  9.54           C  
ATOM   1924  CG2 ILE   218       9.197  -6.156 -14.932  1.00 11.46           C  
ATOM   1925  CD1 ILE   218       9.974  -4.931 -17.648  1.00 11.50           C  
ATOM   1926  OXT ILE   218      10.883  -9.441 -17.135  1.00 11.01           O  
END
