
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  260 ( 1905),  selected  260 , name 2hw5_F
# Molecule2: number of CA atoms  201 ( 1504),  selected  201 , name T0486_32_232.pdb
# PARAMETERS: 2hw5_F.T0486_32_232.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A    31_F      P      32           -
LGA    N    32_F      -       -           -
LGA    F    33_F      -       -           -
LGA    E    34_F      R      33          1.708
LGA    Y    35_F      P      34          0.759
LGA    I    36_F      T      35          1.335
LGA    I    37_F      S      36          1.247
LGA    A    38_F      A      37          0.378
LGA    E    39_F      R      38          0.371
LGA    K    40_F      Q      39          1.324
LGA    R    41_F      L      40          3.474
LGA    G    42_F      -       -           -
LGA    K    43_F      -       -           -
LGA    N    44_F      -       -           -
LGA    N    45_F      D      41          1.512
LGA    T    46_F      G      42          1.153
LGA    V    47_F      I      43          0.559
LGA    G    48_F      R      44          0.633
LGA    L    49_F      N      45          0.410
LGA    I    50_F      I      46          0.379
LGA    Q    51_F      V      47          0.543
LGA    L    52_F      L      48          0.502
LGA    N    53_F      S      49          0.500
LGA    R    54_F      N      50          0.343
LGA    P    55_F      P      51          0.953
LGA    K    56_F      K      52          0.410
LGA    A    57_F      K      53          0.901
LGA    L    58_F      R      54          1.098
LGA    N    59_F      N      55          0.798
LGA    A    60_F      T      56          1.027
LGA    L    61_F      L      57          1.026
LGA    C    62_F      S      58          0.797
LGA    D    63_F      L      59          1.141
LGA    G    64_F      A      60          1.101
LGA    L    65_F      M      61          0.929
LGA    I    66_F      L      62          0.970
LGA    D    67_F      K      63          0.821
LGA    E    68_F      S      64          0.733
LGA    L    69_F      L      65          0.724
LGA    N    70_F      Q      66          0.932
LGA    Q    71_F      S      67          0.976
LGA    A    72_F      D      68          0.493
LGA    L    73_F      I      69          0.588
LGA    K    74_F      L      70          1.101
LGA    I    75_F      X      71          1.482
LGA    F    76_F      D      72          4.846
LGA    E    77_F      A      73          1.504
LGA    E    78_F      D      74          3.302
LGA    D    79_F      S      75          3.102
LGA    P    80_F      N      76          1.739
LGA    A    81_F      D      77          0.996
LGA    V    82_F      L      78          1.224
LGA    G    83_F      K      79          0.568
LGA    A    84_F      V      80          0.580
LGA    I    85_F      I      81          0.182
LGA    V    86_F      I      82          0.210
LGA    L    87_F      I      83          0.214
LGA    T    88_F      S      84          0.437
LGA    G    89_F      A      85          0.768
LGA    G    90_F      E      86          2.357
LGA    D    91_F      G      87          4.028
LGA    K    92_F      P      88          0.652
LGA    A    93_F      V      89          1.505
LGA    F    94_F      F      90          1.116
LGA    A    95_F      S      91          0.710
LGA    A    96_F      S      92          1.438
LGA    G    97_F      G      93          1.706
LGA    A    98_F      X      94          1.219
LGA    D    99_F      D      95          0.765
LGA    I   100_F      L      96          0.601
LGA    K   101_F      K      97          0.904
LGA    E   102_F      E      98          1.105
LGA    M   103_F      L      99          0.732
LGA    Q   104_F      T     100          1.166
LGA    N   105_F      E     101          2.106
LGA    -       -      E     102           -
LGA    L   106_F      Q     103          4.146
LGA    S   107_F      G     104          4.429
LGA    F   108_F      R     105          4.732
LGA    Q   109_F      -       -           -
LGA    D   110_F      -       -           -
LGA    C   111_F      D     106          4.271
LGA    Y   112_F      Y     107           -
LGA    S   113_F      X     108           -
LGA    S   114_F      -       -           -
LGA    K   115_F      A     109          3.778
LGA    F   116_F      E     110          2.876
LGA    -       -      V     111           -
LGA    L   117_F      F     112          1.508
LGA    K   118_F      Q     113          1.397
LGA    H   119_F      T     114          1.727
LGA    W   120_F      C     115          1.368
LGA    D   121_F      S     116          2.868
LGA    H   122_F      K     117          3.739
LGA    -       -      V     118           -
LGA    L   123_F      M     119          3.558
LGA    T   124_F      M     120          2.096
LGA    Q   125_F      X     121          2.308
LGA    -       -      I     122           -
LGA    -       -      R     123           -
LGA    -       -      N     124           -
LGA    V   126_F      X     125          1.813
LGA    K   127_F      P     126          2.464
LGA    K   128_F      V     127          1.311
LGA    P   129_F      P     128          0.748
LGA    V   130_F      V     129          0.340
LGA    I   131_F      I     130          0.411
LGA    A   132_F      A     131          0.404
LGA    A   133_F      M     132          0.611
LGA    V   134_F      V     133          0.795
LGA    N   135_F      N     134          0.670
LGA    G   136_F      G     135          0.244
LGA    Y   137_F      L     136          0.723
LGA    A   138_F      A     137          0.494
LGA    F   139_F      T     138          0.261
LGA    G   140_F      A     139          0.830
LGA    G   141_F      A     140          0.644
LGA    G   142_F      G     141          0.472
LGA    C   143_F      C     142          0.418
LGA    E   144_F      Q     143          0.476
LGA    L   145_F      L     144          0.919
LGA    A   146_F      V     145          0.902
LGA    M   147_F      A     146          1.189
LGA    M   148_F      S     147          1.253
LGA    C   149_F      C     148          0.917
LGA    D   150_F      D     149          0.722
LGA    I   151_F      I     150          0.812
LGA    I   152_F      A     151          0.969
LGA    Y   153_F      V     152          0.720
LGA    A   154_F      A     153          0.901
LGA    G   155_F      S     154          0.883
LGA    E   156_F      D     155          1.193
LGA    K   157_F      K     156          0.802
LGA    A   158_F      S     157          0.575
LGA    Q   159_F      S     158          0.820
LGA    F   160_F      F     159          0.259
LGA    A   161_F      A     160          0.340
LGA    Q   162_F      T     161          0.466
LGA    P   163_F      P     162          0.640
LGA    E   164_F      G     163          0.659
LGA    I   165_F      V     164          0.999
LGA    L   166_F      N     165          0.930
LGA    I   167_F      V     166          0.762
LGA    G   168_F      G     167          0.769
LGA    T   169_F      L     168          1.474
LGA    I   170_F      F     169          1.793
LGA    P   171_F      C     170          2.024
LGA    G   172_F      S     171          4.153
LGA    A   173_F      T     172          3.010
LGA    G   174_F      -       -           -
LGA    G   175_F      P     173          1.624
LGA    T   176_F      G     174          1.464
LGA    Q   177_F      V     175          2.273
LGA    R   178_F      A     176          2.158
LGA    L   179_F      L     177          1.104
LGA    T   180_F      A     178          2.098
LGA    R   181_F      R     179          2.792
LGA    A   182_F      A     180          1.880
LGA    V   183_F      V     181          1.311
LGA    G   184_F      P     182          0.870
LGA    K   185_F      R     183          1.375
LGA    S   186_F      K     184          1.236
LGA    L   187_F      V     185          1.200
LGA    A   188_F      A     186          0.705
LGA    M   189_F      L     187          0.740
LGA    E   190_F      E     188          0.593
LGA    M   191_F      M     189          0.372
LGA    V   192_F      L     190          0.154
LGA    L   193_F      F     191          0.389
LGA    T   194_F      T     192          0.715
LGA    G   195_F      G     193          0.615
LGA    D   196_F      E     194          0.523
LGA    R   197_F      P     195          0.279
LGA    I   198_F      I     196          0.482
LGA    S   199_F      S     197          0.454
LGA    A   200_F      A     198          0.357
LGA    Q   201_F      Q     199          0.436
LGA    D   202_F      E     200          0.540
LGA    A   203_F      A     201          0.369
LGA    K   204_F      L     202          0.414
LGA    Q   205_F      L     203          0.753
LGA    A   206_F      X     204          0.527
LGA    G   207_F      G     205          1.127
LGA    L   208_F      L     206          0.766
LGA    V   209_F      L     207          0.338
LGA    S   210_F      S     208          1.166
LGA    K   211_F      K     209          0.306
LGA    I   212_F      V     210          0.473
LGA    C   213_F      V     211          1.512
LGA    P   214_F      P     212          1.640
LGA    V   215_F      E     213          1.348
LGA    E   216_F      A     214          2.758
LGA    T   217_F      E     215          3.034
LGA    L   218_F      L     216          1.463
LGA    V   219_F      Q     217          2.880
LGA    E   220_F      E     218          2.845
LGA    E   221_F      E     219          1.667
LGA    A   222_F      T     220          1.297
LGA    I   223_F      M     221          2.214
LGA    Q   224_F      R     222          1.982
LGA    C   225_F      I     223          0.426
LGA    A   226_F      A     224          1.294
LGA    E   227_F      R     225          1.420
LGA    K   228_F      K     226          0.920
LGA    I   229_F      I     227          1.223
LGA    A   230_F      A     228          1.723
LGA    S   231_F      S     229          1.760
LGA    N   232_F      L     230          1.695
LGA    S   233_F      S     231          1.724
LGA    K   234_F      R     232          1.396
LGA    I   235_F      -       -           -
LGA    V   236_F      -       -           -
LGA    V   237_F      -       -           -
LGA    A   238_F      -       -           -
LGA    M   239_F      -       -           -
LGA    A   240_F      -       -           -
LGA    K   241_F      -       -           -
LGA    E   242_F      -       -           -
LGA    S   243_F      -       -           -
LGA    V   244_F      -       -           -
LGA    N   245_F      -       -           -
LGA    A   246_F      -       -           -
LGA    A   247_F      -       -           -
LGA    F   248_F      -       -           -
LGA    E   249_F      -       -           -
LGA    M   250_F      -       -           -
LGA    T   251_F      -       -           -
LGA    L   252_F      -       -           -
LGA    T   253_F      -       -           -
LGA    E   254_F      -       -           -
LGA    G   255_F      -       -           -
LGA    S   256_F      -       -           -
LGA    K   257_F      -       -           -
LGA    L   258_F      -       -           -
LGA    E   259_F      -       -           -
LGA    K   260_F      -       -           -
LGA    K   261_F      -       -           -
LGA    L   262_F      -       -           -
LGA    F   263_F      -       -           -
LGA    Y   264_F      -       -           -
LGA    S   265_F      -       -           -
LGA    T   266_F      -       -           -
LGA    F   267_F      -       -           -
LGA    A   268_F      -       -           -
LGA    T   269_F      -       -           -
LGA    D   270_F      -       -           -
LGA    D   271_F      -       -           -
LGA    R   272_F      -       -           -
LGA    K   273_F      -       -           -
LGA    E   274_F      -       -           -
LGA    G   275_F      -       -           -
LGA    M   276_F      -       -           -
LGA    T   277_F      -       -           -
LGA    A   278_F      -       -           -
LGA    F   279_F      -       -           -
LGA    V   280_F      -       -           -
LGA    E   281_F      -       -           -
LGA    K   282_F      -       -           -
LGA    R   283_F      -       -           -
LGA    K   284_F      -       -           -
LGA    A   285_F      -       -           -
LGA    N   286_F      -       -           -
LGA    F   287_F      -       -           -
LGA    K   288_F      -       -           -
LGA    D   289_F      -       -           -
LGA    Q   290_F      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  260  201    5.0    192    1.59    32.29     88.638    11.354

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.877426 * X  +  -0.109169 * Y  +  -0.467125 * Z  +  63.530239
  Y_new =   0.425349 * X  +  -0.273210 * Y  +   0.862806 * Z  +  47.121704
  Z_new =  -0.221815 * X  +  -0.955740 * Y  +  -0.193287 * Z  + 102.687698 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.770343    1.371250  [ DEG:  -101.4332     78.5668 ]
  Theta =   0.223676    2.917917  [ DEG:    12.8157    167.1843 ]
  Phi   =   0.451389   -2.690204  [ DEG:    25.8627   -154.1373 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2hw5_F                                        
REMARK     2: T0486_32_232.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2hw5_F.T0486_32_232.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  260  201   5.0  192   1.59   32.29  88.638
REMARK  ---------------------------------------------------------- 
MOLECULE 2hw5_F
HEADER    LYASE                                   31-JUL-06   2HW5              
TITLE     THE CRYSTAL STRUCTURE OF HUMAN ENOYL-COENZYME A (COA)                 
TITLE    2 HYDRATASE SHORT CHAIN 1, ECHS1                                       
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ENOYL-COA HYDRATASE;                                       
COMPND   3 CHAIN: A, B, C, D, E, F;                                             
COMPND   4 SYNONYM: SHORT CHAIN ENOYL-COA HYDRATASE, SCEH, ENOYL-COA            
COMPND   5 HYDRATASE 1;                                                         
COMPND   6 EC: 4.2.1.17;                                                        
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: ECHS1;                                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL-21(DE3)R3;                              
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PNIC28-BSA4                               
KEYWDS    FATTY ACID METABOLISM, HYDRATASE/ISOMERASE SUPERFAMILY,               
KEYWDS   2 BETA-OXIDATION, COA, ENOYL-COA HYDRATASE, LYASE, STRUCTURAL          
KEYWDS   3 GENOMICS, STRUCTURAL GENOMICS CONSORTIUM, SGC                        
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.P.TURNBULL,E.SALAH,F.NIESEN,J.DEBRECZENI,E.UGOCHUKWU,               
AUTHOR   2 A.C.W.PIKE,K.KAVANAGH,O.GILEADI,F.GORREC,C.UMEANO,F.VON              
AUTHOR   3 DELFT,J.WEIGELT,A.EDWARDS,C.ARROWSMITH,M.SUNDSTROM,                  
AUTHOR   4 U.OPPERMANN,STRUCTURAL GENOMICS CONSORTIUM (SGC)                     
REVDAT   1   22-AUG-06 2HW5    0                                                
JRNL        AUTH   A.P.TURNBULL,E.SALAH,F.NIESEN,J.DEBRECZENI,                  
JRNL        AUTH 2 E.UGOCHUKWU,A.C.W.PIKE,K.KAVANAGH,O.GILEADI,                 
JRNL        AUTH 3 F.GORREC,C.UMEANO,F.VON DELFT,J.WEIGELT,A.EDWARDS,           
JRNL        AUTH 4 C.ARROWSMITH,M.SUNDSTROM,U.OPPERMANN                         
JRNL        TITL   THE CRYSTAL STRUCTURE OF HUMAN ENOYL-COENZYME A              
JRNL        TITL 2 (COA) HYDRATASE SHORT CHAIN 1, ECHS1                         
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.55 ANGSTROMS.                                          
DBREF  2HW5 A   28   290  UNP    P30084   ECHM_HUMAN      28    290             
DBREF  2HW5 B   28   290  UNP    P30084   ECHM_HUMAN      28    290             
DBREF  2HW5 C   28   290  UNP    P30084   ECHM_HUMAN      28    290             
DBREF  2HW5 D   28   290  UNP    P30084   ECHM_HUMAN      28    290             
DBREF  2HW5 E   28   290  UNP    P30084   ECHM_HUMAN      28    290             
DBREF  2HW5 F   28   290  UNP    P30084   ECHM_HUMAN      28    290             
SEQRES   1 A  286  MET HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 A  286  GLY THR GLU ASN LEU TYR PHE GLN SER MET ALA SER GLY          
SEQRES   3 A  286  ALA ASN PHE GLU TYR ILE ILE ALA GLU LYS ARG GLY LYS          
SEQRES   4 A  286  ASN ASN THR VAL GLY LEU ILE GLN LEU ASN ARG PRO LYS          
SEQRES   5 A  286  ALA LEU ASN ALA LEU CYS ASP GLY LEU ILE ASP GLU LEU          
SEQRES   6 A  286  ASN GLN ALA LEU LYS ILE PHE GLU GLU ASP PRO ALA VAL          
SEQRES   7 A  286  GLY ALA ILE VAL LEU THR GLY GLY ASP LYS ALA PHE ALA          
SEQRES   8 A  286  ALA GLY ALA ASP ILE LYS GLU MET GLN ASN LEU SER PHE          
SEQRES   9 A  286  GLN ASP CYS TYR SER SER LYS PHE LEU LYS HIS TRP ASP          
SEQRES  10 A  286  HIS LEU THR GLN VAL LYS LYS PRO VAL ILE ALA ALA VAL          
SEQRES  11 A  286  ASN GLY TYR ALA PHE GLY GLY GLY CYS GLU LEU ALA MET          
SEQRES  12 A  286  MET CYS ASP ILE ILE TYR ALA GLY GLU LYS ALA GLN PHE          
SEQRES  13 A  286  ALA GLN PRO GLU ILE LEU ILE GLY THR ILE PRO GLY ALA          
SEQRES  14 A  286  GLY GLY THR GLN ARG LEU THR ARG ALA VAL GLY LYS SER          
SEQRES  15 A  286  LEU ALA MET GLU MET VAL LEU THR GLY ASP ARG ILE SER          
SEQRES  16 A  286  ALA GLN ASP ALA LYS GLN ALA GLY LEU VAL SER LYS ILE          
SEQRES  17 A  286  CYS PRO VAL GLU THR LEU VAL GLU GLU ALA ILE GLN CYS          
SEQRES  18 A  286  ALA GLU LYS ILE ALA SER ASN SER LYS ILE VAL VAL ALA          
SEQRES  19 A  286  MET ALA LYS GLU SER VAL ASN ALA ALA PHE GLU MET THR          
SEQRES  20 A  286  LEU THR GLU GLY SER LYS LEU GLU LYS LYS LEU PHE TYR          
SEQRES  21 A  286  SER THR PHE ALA THR ASP ASP ARG LYS GLU GLY MET THR          
SEQRES  22 A  286  ALA PHE VAL GLU LYS ARG LYS ALA ASN PHE LYS ASP GLN          
SEQRES   1 B  286  MET HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 B  286  GLY THR GLU ASN LEU TYR PHE GLN SER MET ALA SER GLY          
SEQRES   3 B  286  ALA ASN PHE GLU TYR ILE ILE ALA GLU LYS ARG GLY LYS          
SEQRES   4 B  286  ASN ASN THR VAL GLY LEU ILE GLN LEU ASN ARG PRO LYS          
SEQRES   5 B  286  ALA LEU ASN ALA LEU CYS ASP GLY LEU ILE ASP GLU LEU          
SEQRES   6 B  286  ASN GLN ALA LEU LYS ILE PHE GLU GLU ASP PRO ALA VAL          
SEQRES   7 B  286  GLY ALA ILE VAL LEU THR GLY GLY ASP LYS ALA PHE ALA          
SEQRES   8 B  286  ALA GLY ALA ASP ILE LYS GLU MET GLN ASN LEU SER PHE          
SEQRES   9 B  286  GLN ASP CYS TYR SER SER LYS PHE LEU LYS HIS TRP ASP          
SEQRES  10 B  286  HIS LEU THR GLN VAL LYS LYS PRO VAL ILE ALA ALA VAL          
SEQRES  11 B  286  ASN GLY TYR ALA PHE GLY GLY GLY CYS GLU LEU ALA MET          
SEQRES  12 B  286  MET CYS ASP ILE ILE TYR ALA GLY GLU LYS ALA GLN PHE          
SEQRES  13 B  286  ALA GLN PRO GLU ILE LEU ILE GLY THR ILE PRO GLY ALA          
SEQRES  14 B  286  GLY GLY THR GLN ARG LEU THR ARG ALA VAL GLY LYS SER          
SEQRES  15 B  286  LEU ALA MET GLU MET VAL LEU THR GLY ASP ARG ILE SER          
SEQRES  16 B  286  ALA GLN ASP ALA LYS GLN ALA GLY LEU VAL SER LYS ILE          
SEQRES  17 B  286  CYS PRO VAL GLU THR LEU VAL GLU GLU ALA ILE GLN CYS          
SEQRES  18 B  286  ALA GLU LYS ILE ALA SER ASN SER LYS ILE VAL VAL ALA          
SEQRES  19 B  286  MET ALA LYS GLU SER VAL ASN ALA ALA PHE GLU MET THR          
SEQRES  20 B  286  LEU THR GLU GLY SER LYS LEU GLU LYS LYS LEU PHE TYR          
SEQRES  21 B  286  SER THR PHE ALA THR ASP ASP ARG LYS GLU GLY MET THR          
SEQRES  22 B  286  ALA PHE VAL GLU LYS ARG LYS ALA ASN PHE LYS ASP GLN          
SEQRES   1 C  286  MET HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 C  286  GLY THR GLU ASN LEU TYR PHE GLN SER MET ALA SER GLY          
SEQRES   3 C  286  ALA ASN PHE GLU TYR ILE ILE ALA GLU LYS ARG GLY LYS          
SEQRES   4 C  286  ASN ASN THR VAL GLY LEU ILE GLN LEU ASN ARG PRO LYS          
SEQRES   5 C  286  ALA LEU ASN ALA LEU CYS ASP GLY LEU ILE ASP GLU LEU          
SEQRES   6 C  286  ASN GLN ALA LEU LYS ILE PHE GLU GLU ASP PRO ALA VAL          
SEQRES   7 C  286  GLY ALA ILE VAL LEU THR GLY GLY ASP LYS ALA PHE ALA          
SEQRES   8 C  286  ALA GLY ALA ASP ILE LYS GLU MET GLN ASN LEU SER PHE          
SEQRES   9 C  286  GLN ASP CYS TYR SER SER LYS PHE LEU LYS HIS TRP ASP          
SEQRES  10 C  286  HIS LEU THR GLN VAL LYS LYS PRO VAL ILE ALA ALA VAL          
SEQRES  11 C  286  ASN GLY TYR ALA PHE GLY GLY GLY CYS GLU LEU ALA MET          
SEQRES  12 C  286  MET CYS ASP ILE ILE TYR ALA GLY GLU LYS ALA GLN PHE          
SEQRES  13 C  286  ALA GLN PRO GLU ILE LEU ILE GLY THR ILE PRO GLY ALA          
SEQRES  14 C  286  GLY GLY THR GLN ARG LEU THR ARG ALA VAL GLY LYS SER          
SEQRES  15 C  286  LEU ALA MET GLU MET VAL LEU THR GLY ASP ARG ILE SER          
SEQRES  16 C  286  ALA GLN ASP ALA LYS GLN ALA GLY LEU VAL SER LYS ILE          
SEQRES  17 C  286  CYS PRO VAL GLU THR LEU VAL GLU GLU ALA ILE GLN CYS          
SEQRES  18 C  286  ALA GLU LYS ILE ALA SER ASN SER LYS ILE VAL VAL ALA          
SEQRES  19 C  286  MET ALA LYS GLU SER VAL ASN ALA ALA PHE GLU MET THR          
SEQRES  20 C  286  LEU THR GLU GLY SER LYS LEU GLU LYS LYS LEU PHE TYR          
SEQRES  21 C  286  SER THR PHE ALA THR ASP ASP ARG LYS GLU GLY MET THR          
SEQRES  22 C  286  ALA PHE VAL GLU LYS ARG LYS ALA ASN PHE LYS ASP GLN          
SEQRES   1 D  286  MET HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 D  286  GLY THR GLU ASN LEU TYR PHE GLN SER MET ALA SER GLY          
SEQRES   3 D  286  ALA ASN PHE GLU TYR ILE ILE ALA GLU LYS ARG GLY LYS          
SEQRES   4 D  286  ASN ASN THR VAL GLY LEU ILE GLN LEU ASN ARG PRO LYS          
SEQRES   5 D  286  ALA LEU ASN ALA LEU CYS ASP GLY LEU ILE ASP GLU LEU          
SEQRES   6 D  286  ASN GLN ALA LEU LYS ILE PHE GLU GLU ASP PRO ALA VAL          
SEQRES   7 D  286  GLY ALA ILE VAL LEU THR GLY GLY ASP LYS ALA PHE ALA          
SEQRES   8 D  286  ALA GLY ALA ASP ILE LYS GLU MET GLN ASN LEU SER PHE          
SEQRES   9 D  286  GLN ASP CYS TYR SER SER LYS PHE LEU LYS HIS TRP ASP          
SEQRES  10 D  286  HIS LEU THR GLN VAL LYS LYS PRO VAL ILE ALA ALA VAL          
SEQRES  11 D  286  ASN GLY TYR ALA PHE GLY GLY GLY CYS GLU LEU ALA MET          
SEQRES  12 D  286  MET CYS ASP ILE ILE TYR ALA GLY GLU LYS ALA GLN PHE          
SEQRES  13 D  286  ALA GLN PRO GLU ILE LEU ILE GLY THR ILE PRO GLY ALA          
SEQRES  14 D  286  GLY GLY THR GLN ARG LEU THR ARG ALA VAL GLY LYS SER          
SEQRES  15 D  286  LEU ALA MET GLU MET VAL LEU THR GLY ASP ARG ILE SER          
SEQRES  16 D  286  ALA GLN ASP ALA LYS GLN ALA GLY LEU VAL SER LYS ILE          
SEQRES  17 D  286  CYS PRO VAL GLU THR LEU VAL GLU GLU ALA ILE GLN CYS          
SEQRES  18 D  286  ALA GLU LYS ILE ALA SER ASN SER LYS ILE VAL VAL ALA          
SEQRES  19 D  286  MET ALA LYS GLU SER VAL ASN ALA ALA PHE GLU MET THR          
SEQRES  20 D  286  LEU THR GLU GLY SER LYS LEU GLU LYS LYS LEU PHE TYR          
SEQRES  21 D  286  SER THR PHE ALA THR ASP ASP ARG LYS GLU GLY MET THR          
SEQRES  22 D  286  ALA PHE VAL GLU LYS ARG LYS ALA ASN PHE LYS ASP GLN          
SEQRES   1 E  286  MET HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 E  286  GLY THR GLU ASN LEU TYR PHE GLN SER MET ALA SER GLY          
SEQRES   3 E  286  ALA ASN PHE GLU TYR ILE ILE ALA GLU LYS ARG GLY LYS          
SEQRES   4 E  286  ASN ASN THR VAL GLY LEU ILE GLN LEU ASN ARG PRO LYS          
SEQRES   5 E  286  ALA LEU ASN ALA LEU CYS ASP GLY LEU ILE ASP GLU LEU          
SEQRES   6 E  286  ASN GLN ALA LEU LYS ILE PHE GLU GLU ASP PRO ALA VAL          
SEQRES   7 E  286  GLY ALA ILE VAL LEU THR GLY GLY ASP LYS ALA PHE ALA          
SEQRES   8 E  286  ALA GLY ALA ASP ILE LYS GLU MET GLN ASN LEU SER PHE          
SEQRES   9 E  286  GLN ASP CYS TYR SER SER LYS PHE LEU LYS HIS TRP ASP          
SEQRES  10 E  286  HIS LEU THR GLN VAL LYS LYS PRO VAL ILE ALA ALA VAL          
SEQRES  11 E  286  ASN GLY TYR ALA PHE GLY GLY GLY CYS GLU LEU ALA MET          
SEQRES  12 E  286  MET CYS ASP ILE ILE TYR ALA GLY GLU LYS ALA GLN PHE          
SEQRES  13 E  286  ALA GLN PRO GLU ILE LEU ILE GLY THR ILE PRO GLY ALA          
SEQRES  14 E  286  GLY GLY THR GLN ARG LEU THR ARG ALA VAL GLY LYS SER          
SEQRES  15 E  286  LEU ALA MET GLU MET VAL LEU THR GLY ASP ARG ILE SER          
SEQRES  16 E  286  ALA GLN ASP ALA LYS GLN ALA GLY LEU VAL SER LYS ILE          
SEQRES  17 E  286  CYS PRO VAL GLU THR LEU VAL GLU GLU ALA ILE GLN CYS          
SEQRES  18 E  286  ALA GLU LYS ILE ALA SER ASN SER LYS ILE VAL VAL ALA          
SEQRES  19 E  286  MET ALA LYS GLU SER VAL ASN ALA ALA PHE GLU MET THR          
SEQRES  20 E  286  LEU THR GLU GLY SER LYS LEU GLU LYS LYS LEU PHE TYR          
SEQRES  21 E  286  SER THR PHE ALA THR ASP ASP ARG LYS GLU GLY MET THR          
SEQRES  22 E  286  ALA PHE VAL GLU LYS ARG LYS ALA ASN PHE LYS ASP GLN          
SEQRES   1 F  286  MET HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 F  286  GLY THR GLU ASN LEU TYR PHE GLN SER MET ALA SER GLY          
SEQRES   3 F  286  ALA ASN PHE GLU TYR ILE ILE ALA GLU LYS ARG GLY LYS          
SEQRES   4 F  286  ASN ASN THR VAL GLY LEU ILE GLN LEU ASN ARG PRO LYS          
SEQRES   5 F  286  ALA LEU ASN ALA LEU CYS ASP GLY LEU ILE ASP GLU LEU          
SEQRES   6 F  286  ASN GLN ALA LEU LYS ILE PHE GLU GLU ASP PRO ALA VAL          
SEQRES   7 F  286  GLY ALA ILE VAL LEU THR GLY GLY ASP LYS ALA PHE ALA          
SEQRES   8 F  286  ALA GLY ALA ASP ILE LYS GLU MET GLN ASN LEU SER PHE          
SEQRES   9 F  286  GLN ASP CYS TYR SER SER LYS PHE LEU LYS HIS TRP ASP          
SEQRES  10 F  286  HIS LEU THR GLN VAL LYS LYS PRO VAL ILE ALA ALA VAL          
SEQRES  11 F  286  ASN GLY TYR ALA PHE GLY GLY GLY CYS GLU LEU ALA MET          
SEQRES  12 F  286  MET CYS ASP ILE ILE TYR ALA GLY GLU LYS ALA GLN PHE          
SEQRES  13 F  286  ALA GLN PRO GLU ILE LEU ILE GLY THR ILE PRO GLY ALA          
SEQRES  14 F  286  GLY GLY THR GLN ARG LEU THR ARG ALA VAL GLY LYS SER          
SEQRES  15 F  286  LEU ALA MET GLU MET VAL LEU THR GLY ASP ARG ILE SER          
SEQRES  16 F  286  ALA GLN ASP ALA LYS GLN ALA GLY LEU VAL SER LYS ILE          
SEQRES  17 F  286  CYS PRO VAL GLU THR LEU VAL GLU GLU ALA ILE GLN CYS          
SEQRES  18 F  286  ALA GLU LYS ILE ALA SER ASN SER LYS ILE VAL VAL ALA          
SEQRES  19 F  286  MET ALA LYS GLU SER VAL ASN ALA ALA PHE GLU MET THR          
SEQRES  20 F  286  LEU THR GLU GLY SER LYS LEU GLU LYS LYS LEU PHE TYR          
SEQRES  21 F  286  SER THR PHE ALA THR ASP ASP ARG LYS GLU GLY MET THR          
SEQRES  22 F  286  ALA PHE VAL GLU LYS ARG LYS ALA ASN PHE LYS ASP GLN          
HET     MG     11       1                                                       
HET     MG     12       1                                                       
HET     MG     13       1                                                       
HET     MG     14       1                                                       
HET    COO      1      35                                                       
HET    COO      2      35                                                       
HETNAM      MG MAGNESIUM ION                                                    
HETNAM     COO CROTONYL COENZYME A                                              
FORMUL   7   MG    4(MG 2+)                                                     
FORMUL  11  COO    2(C25 H40 N7 O17 P3 S)                                       
CRYST1   91.554   97.344  231.796  90.00  90.00  90.00 P 21 21 21   24          
ATOM   9576  N   ALA F  31     -35.378 108.892  25.825  1.00 80.89           N  
ATOM   9577  CA  ALA F  31     -35.964 110.260  25.653  1.00 81.11           C  
ATOM   9578  C   ALA F  31     -35.703 110.802  24.243  1.00 80.97           C  
ATOM   9579  O   ALA F  31     -34.845 110.288  23.519  1.00 81.34           O  
ATOM   9580  CB  ALA F  31     -35.398 111.217  26.708  1.00 81.01           C  
ATOM   9581  N   ASN F  32     -36.442 111.841  23.865  1.00 80.61           N  
ATOM   9582  CA  ASN F  32     -36.233 112.522  22.585  1.00 80.40           C  
ATOM   9583  C   ASN F  32     -34.927 113.336  22.594  1.00 80.14           C  
ATOM   9584  O   ASN F  32     -34.900 114.477  23.061  1.00 80.28           O  
ATOM   9585  CB  ASN F  32     -37.433 113.429  22.275  1.00 80.38           C  
ATOM   9586  CG  ASN F  32     -37.431 113.943  20.846  1.00 80.53           C  
ATOM   9587  OD1 ASN F  32     -36.475 113.737  20.093  1.00 80.60           O  
ATOM   9588  ND2 ASN F  32     -38.514 114.614  20.463  1.00 80.30           N  
ATOM   9589  N   PHE F  33     -33.858 112.741  22.067  1.00 79.69           N  
ATOM   9590  CA  PHE F  33     -32.519 113.342  22.101  1.00 79.33           C  
ATOM   9591  C   PHE F  33     -32.355 114.468  21.087  1.00 79.06           C  
ATOM   9592  O   PHE F  33     -33.017 114.473  20.057  1.00 78.95           O  
ATOM   9593  CB  PHE F  33     -31.459 112.288  21.803  1.00 79.24           C  
ATOM   9594  CG  PHE F  33     -31.449 111.141  22.767  1.00 79.23           C  
ATOM   9595  CD1 PHE F  33     -30.936 111.297  24.044  1.00 78.89           C  
ATOM   9596  CD2 PHE F  33     -31.928 109.896  22.388  1.00 79.28           C  
ATOM   9597  CE1 PHE F  33     -30.912 110.241  24.933  1.00 79.05           C  
ATOM   9598  CE2 PHE F  33     -31.901 108.830  23.269  1.00 79.31           C  
ATOM   9599  CZ  PHE F  33     -31.391 109.002  24.544  1.00 79.22           C  
ATOM   9600  N   GLU F  34     -31.446 115.399  21.378  1.00 78.83           N  
ATOM   9601  CA  GLU F  34     -31.172 116.540  20.495  1.00 78.77           C  
ATOM   9602  C   GLU F  34     -29.766 116.550  19.885  1.00 78.32           C  
ATOM   9603  O   GLU F  34     -29.566 117.170  18.843  1.00 77.93           O  
ATOM   9604  CB  GLU F  34     -31.438 117.863  21.229  1.00 78.90           C  
ATOM   9605  CG  GLU F  34     -30.451 118.215  22.356  1.00 79.43           C  
ATOM   9606  CD  GLU F  34     -30.801 119.528  23.078  1.00 79.65           C  
ATOM   9607  OE1 GLU F  34     -30.033 119.913  23.989  1.00 81.13           O  
ATOM   9608  OE2 GLU F  34     -31.828 120.172  22.742  1.00 79.30           O  
ATOM   9609  N   TYR F  35     -28.800 115.882  20.529  1.00 78.04           N  
ATOM   9610  CA  TYR F  35     -27.420 115.789  20.007  1.00 77.76           C  
ATOM   9611  C   TYR F  35     -27.113 114.464  19.313  1.00 77.30           C  
ATOM   9612  O   TYR F  35     -26.132 114.377  18.578  1.00 77.11           O  
ATOM   9613  CB  TYR F  35     -26.386 116.026  21.117  1.00 78.04           C  
ATOM   9614  CG  TYR F  35     -26.549 117.360  21.793  1.00 78.40           C  
ATOM   9615  CD1 TYR F  35     -26.179 118.533  21.148  1.00 79.14           C  
ATOM   9616  CD2 TYR F  35     -27.100 117.455  23.062  1.00 78.87           C  
ATOM   9617  CE1 TYR F  35     -26.353 119.771  21.749  1.00 79.41           C  
ATOM   9618  CE2 TYR F  35     -27.276 118.686  23.677  1.00 79.38           C  
ATOM   9619  CZ  TYR F  35     -26.899 119.842  23.015  1.00 79.33           C  
ATOM   9620  OH  TYR F  35     -27.072 121.067  23.619  1.00 79.20           O  
ATOM   9621  N   ILE F  36     -27.932 113.439  19.549  1.00 76.85           N  
ATOM   9622  CA  ILE F  36     -27.666 112.101  19.010  1.00 76.56           C  
ATOM   9623  C   ILE F  36     -28.928 111.406  18.487  1.00 76.36           C  
ATOM   9624  O   ILE F  36     -30.049 111.848  18.742  1.00 76.02           O  
ATOM   9625  CB  ILE F  36     -26.970 111.175  20.072  1.00 76.40           C  
ATOM   9626  CG1 ILE F  36     -27.949 110.733  21.164  1.00 76.43           C  
ATOM   9627  CG2 ILE F  36     -25.800 111.877  20.721  1.00 75.78           C  
ATOM   9628  CD1 ILE F  36     -27.332 109.828  22.185  1.00 76.61           C  
ATOM   9629  N   ILE F  37     -28.715 110.312  17.756  1.00 76.28           N  
ATOM   9630  CA  ILE F  37     -29.790 109.408  17.343  1.00 76.14           C  
ATOM   9631  C   ILE F  37     -29.510 108.036  17.930  1.00 75.99           C  
ATOM   9632  O   ILE F  37     -28.385 107.541  17.853  1.00 75.62           O  
ATOM   9633  CB  ILE F  37     -29.882 109.285  15.813  1.00 76.25           C  
ATOM   9634  CG1 ILE F  37     -30.316 110.618  15.201  1.00 76.30           C  
ATOM   9635  CG2 ILE F  37     -30.862 108.173  15.414  1.00 75.87           C  
ATOM   9636  CD1 ILE F  37     -30.002 110.728  13.727  1.00 76.71           C  
ATOM   9637  N   ALA F  38     -30.544 107.433  18.510  1.00 75.96           N  
ATOM   9638  CA  ALA F  38     -30.430 106.154  19.196  1.00 75.96           C  
ATOM   9639  C   ALA F  38     -31.565 105.233  18.764  1.00 76.08           C  
ATOM   9640  O   ALA F  38     -32.736 105.520  19.005  1.00 75.79           O  
ATOM   9641  CB  ALA F  38     -30.468 106.366  20.690  1.00 75.99           C  
ATOM   9642  N   GLU F  39     -31.205 104.120  18.136  1.00 76.23           N  
ATOM   9643  CA  GLU F  39     -32.184 103.223  17.544  1.00 76.42           C  
ATOM   9644  C   GLU F  39     -31.647 101.797  17.482  1.00 76.60           C  
ATOM   9645  O   GLU F  39     -30.437 101.581  17.500  1.00 76.69           O  
ATOM   9646  CB  GLU F  39     -32.537 103.707  16.135  1.00 76.36           C  
ATOM   9647  N   LYS F  40     -32.566 100.838  17.397  1.00 76.93           N  
ATOM   9648  CA  LYS F  40     -32.237  99.413  17.327  1.00 77.31           C  
ATOM   9649  C   LYS F  40     -32.087  98.949  15.870  1.00 77.42           C  
ATOM   9650  O   LYS F  40     -32.804  99.423  14.985  1.00 77.12           O  
ATOM   9651  CB  LYS F  40     -33.311  98.596  18.056  1.00 77.38           C  
ATOM   9652  CG  LYS F  40     -33.414  98.925  19.551  1.00 77.69           C  
ATOM   9653  CD  LYS F  40     -34.591  98.229  20.225  1.00 77.74           C  
ATOM   9654  CE  LYS F  40     -34.387  96.725  20.307  1.00 78.28           C  
ATOM   9655  NZ  LYS F  40     -35.376  96.052  21.197  1.00 78.49           N  
ATOM   9656  N   ARG F  41     -31.149  98.028  15.623  1.00 77.68           N  
ATOM   9657  CA  ARG F  41     -30.741  97.685  14.251  1.00 77.81           C  
ATOM   9658  C   ARG F  41     -30.366  96.217  14.053  1.00 77.86           C  
ATOM   9659  O   ARG F  41     -30.281  95.457  15.006  1.00 77.92           O  
ATOM   9660  CB  ARG F  41     -29.572  98.579  13.837  1.00 77.85           C  
ATOM   9661  CG  ARG F  41     -29.951 100.049  13.710  1.00 78.29           C  
ATOM   9662  CD  ARG F  41     -30.691 100.319  12.417  1.00 78.35           C  
ATOM   9663  NE  ARG F  41     -29.731 100.780  11.426  1.00 78.77           N  
ATOM   9664  CZ  ARG F  41     -29.565 102.045  11.048  1.00 79.12           C  
ATOM   9665  NH1 ARG F  41     -30.334 103.020  11.542  1.00 78.51           N  
ATOM   9666  NH2 ARG F  41     -28.627 102.332  10.146  1.00 79.20           N  
ATOM   9667  N   GLY F  42     -30.143  95.834  12.799  1.00 78.12           N  
ATOM   9668  CA  GLY F  42     -29.914  94.439  12.431  1.00 78.28           C  
ATOM   9669  C   GLY F  42     -31.237  93.726  12.197  1.00 78.51           C  
ATOM   9670  O   GLY F  42     -32.309  94.312  12.387  1.00 78.54           O  
ATOM   9671  N   LYS F  43     -31.170  92.468  11.761  1.00 78.64           N  
ATOM   9672  CA  LYS F  43     -32.359  91.614  11.703  1.00 78.62           C  
ATOM   9673  C   LYS F  43     -32.715  91.221  13.143  1.00 78.41           C  
ATOM   9674  O   LYS F  43     -31.827  90.893  13.949  1.00 78.21           O  
ATOM   9675  CB  LYS F  43     -32.110  90.376  10.834  1.00 78.69           C  
ATOM   9676  N   ASN F  44     -34.010  91.293  13.462  1.00 78.00           N  
ATOM   9677  CA  ASN F  44     -34.511  91.157  14.843  1.00 77.72           C  
ATOM   9678  C   ASN F  44     -34.041  92.270  15.810  1.00 77.33           C  
ATOM   9679  O   ASN F  44     -34.149  92.117  17.032  1.00 77.43           O  
ATOM   9680  CB  ASN F  44     -34.188  89.765  15.421  1.00 77.80           C  
ATOM   9681  CG  ASN F  44     -34.849  88.641  14.643  1.00 77.62           C  
ATOM   9682  OD1 ASN F  44     -36.056  88.676  14.382  1.00 77.42           O  
ATOM   9683  ND2 ASN F  44     -34.063  87.632  14.275  1.00 77.09           N  
ATOM   9684  N   ASN F  45     -33.532  93.376  15.262  1.00 76.70           N  
ATOM   9685  CA  ASN F  45     -33.202  94.575  16.037  1.00 76.27           C  
ATOM   9686  C   ASN F  45     -32.440  94.287  17.338  1.00 75.85           C  
ATOM   9687  O   ASN F  45     -32.804  94.773  18.407  1.00 75.72           O  
ATOM   9688  CB  ASN F  45     -34.484  95.375  16.321  1.00 76.27           C  
ATOM   9689  CG  ASN F  45     -35.180  95.837  15.051  1.00 76.42           C  
ATOM   9690  OD1 ASN F  45     -36.392  95.649  14.883  1.00 76.68           O  
ATOM   9691  ND2 ASN F  45     -34.415  96.437  14.140  1.00 75.93           N  
ATOM   9692  N   THR F  46     -31.377  93.494  17.233  1.00 75.38           N  
ATOM   9693  CA  THR F  46     -30.615  93.064  18.403  1.00 75.12           C  
ATOM   9694  C   THR F  46     -29.366  93.911  18.661  1.00 74.80           C  
ATOM   9695  O   THR F  46     -28.605  93.622  19.580  1.00 74.66           O  
ATOM   9696  CB  THR F  46     -30.198  91.580  18.279  1.00 75.13           C  
ATOM   9697  OG1 THR F  46     -29.511  91.379  17.041  1.00 75.17           O  
ATOM   9698  CG2 THR F  46     -31.423  90.672  18.339  1.00 75.21           C  
ATOM   9699  N   VAL F  47     -29.156  94.950  17.857  1.00 74.59           N  
ATOM   9700  CA  VAL F  47     -28.026  95.854  18.051  1.00 74.42           C  
ATOM   9701  C   VAL F  47     -28.499  97.257  18.390  1.00 74.44           C  
ATOM   9702  O   VAL F  47     -29.415  97.786  17.755  1.00 74.46           O  
ATOM   9703  CB  VAL F  47     -27.164  95.964  16.798  1.00 74.33           C  
ATOM   9704  CG1 VAL F  47     -25.945  96.840  17.087  1.00 73.99           C  
ATOM   9705  CG2 VAL F  47     -26.746  94.583  16.321  1.00 74.63           C  
ATOM   9706  N   GLY F  48     -27.866  97.857  19.391  1.00 74.40           N  
ATOM   9707  CA  GLY F  48     -28.069  99.264  19.681  1.00 74.39           C  
ATOM   9708  C   GLY F  48     -27.163 100.070  18.778  1.00 74.35           C  
ATOM   9709  O   GLY F  48     -25.985  99.730  18.605  1.00 74.57           O  
ATOM   9710  N   LEU F  49     -27.707 101.123  18.180  1.00 74.31           N  
ATOM   9711  CA  LEU F  49     -26.901 102.046  17.389  1.00 74.34           C  
ATOM   9712  C   LEU F  49     -27.080 103.434  17.953  1.00 74.33           C  
ATOM   9713  O   LEU F  49     -28.199 103.907  18.096  1.00 74.39           O  
ATOM   9714  CB  LEU F  49     -27.281 102.006  15.906  1.00 74.30           C  
ATOM   9715  CG  LEU F  49     -26.605 103.013  14.964  1.00 74.23           C  
ATOM   9716  CD1 LEU F  49     -25.103 103.037  15.116  1.00 74.37           C  
ATOM   9717  CD2 LEU F  49     -26.975 102.723  13.517  1.00 74.56           C  
ATOM   9718  N   ILE F  50     -25.963 104.055  18.306  1.00 74.63           N  
ATOM   9719  CA  ILE F  50     -25.931 105.436  18.732  1.00 74.97           C  
ATOM   9720  C   ILE F  50     -25.133 106.181  17.677  1.00 75.43           C  
ATOM   9721  O   ILE F  50     -24.003 105.812  17.380  1.00 75.45           O  
ATOM   9722  CB  ILE F  50     -25.252 105.602  20.100  1.00 75.04           C  
ATOM   9723  CG1 ILE F  50     -25.819 104.593  21.107  1.00 75.19           C  
ATOM   9724  CG2 ILE F  50     -25.427 107.033  20.602  1.00 74.70           C  
ATOM   9725  CD1 ILE F  50     -25.199 104.661  22.482  1.00 74.21           C  
ATOM   9726  N   GLN F  51     -25.744 107.203  17.087  1.00 76.05           N  
ATOM   9727  CA  GLN F  51     -25.081 108.063  16.119  1.00 76.59           C  
ATOM   9728  C   GLN F  51     -24.995 109.465  16.706  1.00 76.67           C  
ATOM   9729  O   GLN F  51     -26.020 110.053  17.081  1.00 76.65           O  
ATOM   9730  CB  GLN F  51     -25.854 108.094  14.792  1.00 76.65           C  
ATOM   9731  CG  GLN F  51     -25.170 108.922  13.707  1.00 77.31           C  
ATOM   9732  CD  GLN F  51     -25.746 108.701  12.315  1.00 77.34           C  
ATOM   9733  OE1 GLN F  51     -26.958 108.784  12.106  1.00 78.15           O  
ATOM   9734  NE2 GLN F  51     -24.867 108.434  11.350  1.00 78.33           N  
ATOM   9735  N   LEU F  52     -23.777 109.992  16.790  1.00 76.82           N  
ATOM   9736  CA  LEU F  52     -23.559 111.359  17.245  1.00 76.92           C  
ATOM   9737  C   LEU F  52     -24.015 112.291  16.131  1.00 77.14           C  
ATOM   9738  O   LEU F  52     -23.520 112.199  15.013  1.00 77.10           O  
ATOM   9739  CB  LEU F  52     -22.086 111.599  17.577  1.00 76.81           C  
ATOM   9740  CG  LEU F  52     -21.411 110.581  18.498  1.00 76.41           C  
ATOM   9741  CD1 LEU F  52     -20.014 111.052  18.847  1.00 76.31           C  
ATOM   9742  CD2 LEU F  52     -22.224 110.351  19.747  1.00 76.06           C  
ATOM   9743  N   ASN F  53     -24.960 113.177  16.445  1.00 77.56           N  
ATOM   9744  CA  ASN F  53     -25.643 113.987  15.442  1.00 77.84           C  
ATOM   9745  C   ASN F  53     -25.516 115.484  15.726  1.00 78.14           C  
ATOM   9746  O   ASN F  53     -26.502 116.186  15.944  1.00 78.29           O  
ATOM   9747  CB  ASN F  53     -27.113 113.568  15.354  1.00 77.84           C  
ATOM   9748  CG  ASN F  53     -27.753 113.957  14.036  1.00 78.18           C  
ATOM   9749  OD1 ASN F  53     -27.173 113.748  12.966  1.00 78.27           O  
ATOM   9750  ND2 ASN F  53     -28.957 114.521  14.103  1.00 77.95           N  
ATOM   9751  N   ARG F  54     -24.274 115.954  15.717  1.00 78.58           N  
ATOM   9752  CA  ARG F  54     -23.945 117.369  15.872  1.00 78.76           C  
ATOM   9753  C   ARG F  54     -22.983 117.730  14.727  1.00 78.58           C  
ATOM   9754  O   ARG F  54     -21.859 118.178  14.961  1.00 78.24           O  
ATOM   9755  CB  ARG F  54     -23.311 117.599  17.257  1.00 78.92           C  
ATOM   9756  CG  ARG F  54     -23.082 119.062  17.643  1.00 79.13           C  
ATOM   9757  CD  ARG F  54     -22.847 119.216  19.149  1.00 79.28           C  
ATOM   9758  NE  ARG F  54     -22.712 120.627  19.529  1.00 80.13           N  
ATOM   9759  CZ  ARG F  54     -21.597 121.229  19.952  1.00 80.90           C  
ATOM   9760  NH1 ARG F  54     -20.449 120.566  20.100  1.00 81.31           N  
ATOM   9761  NH2 ARG F  54     -21.633 122.525  20.253  1.00 80.62           N  
ATOM   9762  N   PRO F  55     -23.430 117.524  13.474  1.00 78.67           N  
ATOM   9763  CA  PRO F  55     -22.539 117.648  12.307  1.00 78.75           C  
ATOM   9764  C   PRO F  55     -21.904 119.036  12.123  1.00 78.78           C  
ATOM   9765  O   PRO F  55     -20.784 119.129  11.614  1.00 78.72           O  
ATOM   9766  CB  PRO F  55     -23.464 117.320  11.123  1.00 78.76           C  
ATOM   9767  CG  PRO F  55     -24.839 117.574  11.630  1.00 78.60           C  
ATOM   9768  CD  PRO F  55     -24.807 117.187  13.068  1.00 78.52           C  
ATOM   9769  N   LYS F  56     -22.610 120.090  12.539  1.00 78.82           N  
ATOM   9770  CA  LYS F  56     -22.116 121.467  12.413  1.00 78.75           C  
ATOM   9771  C   LYS F  56     -20.816 121.688  13.191  1.00 78.58           C  
ATOM   9772  O   LYS F  56     -19.913 122.381  12.720  1.00 78.50           O  
ATOM   9773  CB  LYS F  56     -23.184 122.465  12.877  1.00 78.81           C  
ATOM   9774  N   ALA F  57     -20.723 121.088  14.373  1.00 78.45           N  
ATOM   9775  CA  ALA F  57     -19.515 121.173  15.193  1.00 78.38           C  
ATOM   9776  C   ALA F  57     -18.598 119.955  15.010  1.00 78.33           C  
ATOM   9777  O   ALA F  57     -17.699 119.727  15.822  1.00 78.41           O  
ATOM   9778  CB  ALA F  57     -19.895 121.340  16.663  1.00 78.34           C  
ATOM   9779  N   LEU F  58     -18.811 119.188  13.939  1.00 78.23           N  
ATOM   9780  CA  LEU F  58     -18.055 117.953  13.694  1.00 78.19           C  
ATOM   9781  C   LEU F  58     -18.119 117.043  14.923  1.00 77.95           C  
ATOM   9782  O   LEU F  58     -17.093 116.652  15.484  1.00 78.00           O  
ATOM   9783  CB  LEU F  58     -16.603 118.262  13.310  1.00 78.22           C  
ATOM   9784  CG  LEU F  58     -16.424 119.172  12.086  1.00 79.27           C  
ATOM   9785  CD1 LEU F  58     -14.990 119.716  12.004  1.00 79.85           C  
ATOM   9786  CD2 LEU F  58     -16.825 118.446  10.788  1.00 79.66           C  
ATOM   9787  N   ASN F  59     -19.346 116.736  15.342  1.00 77.59           N  
ATOM   9788  CA  ASN F  59     -19.604 115.924  16.524  1.00 77.26           C  
ATOM   9789  C   ASN F  59     -18.637 116.194  17.673  1.00 77.25           C  
ATOM   9790  O   ASN F  59     -18.240 115.267  18.385  1.00 77.21           O  
ATOM   9791  CB  ASN F  59     -19.574 114.439  16.169  1.00 77.21           C  
ATOM   9792  CG  ASN F  59     -20.683 114.032  15.236  1.00 77.10           C  
ATOM   9793  OD1 ASN F  59     -21.692 114.727  15.091  1.00 77.55           O  
ATOM   9794  ND2 ASN F  59     -20.506 112.885  14.594  1.00 76.94           N  
ATOM   9795  N   ALA F  60     -18.260 117.456  17.859  1.00 77.12           N  
ATOM   9796  CA  ALA F  60     -17.429 117.830  18.992  1.00 76.97           C  
ATOM   9797  C   ALA F  60     -18.185 117.508  20.279  1.00 77.05           C  
ATOM   9798  O   ALA F  60     -19.405 117.715  20.371  1.00 76.91           O  
ATOM   9799  CB  ALA F  60     -17.061 119.301  18.935  1.00 76.99           C  
ATOM   9800  N   LEU F  61     -17.459 116.993  21.264  1.00 77.23           N  
ATOM   9801  CA  LEU F  61     -18.064 116.482  22.483  1.00 77.39           C  
ATOM   9802  C   LEU F  61     -18.274 117.597  23.523  1.00 77.72           C  
ATOM   9803  O   LEU F  61     -17.318 118.215  24.001  1.00 78.31           O  
ATOM   9804  CB  LEU F  61     -17.194 115.368  23.062  1.00 77.38           C  
ATOM   9805  CG  LEU F  61     -16.800 114.240  22.103  1.00 77.19           C  
ATOM   9806  CD1 LEU F  61     -15.854 113.267  22.788  1.00 76.68           C  
ATOM   9807  CD2 LEU F  61     -18.035 113.526  21.592  1.00 77.00           C  
ATOM   9808  N   CYS F  62     -19.530 117.862  23.857  1.00 77.53           N  
ATOM   9809  CA  CYS F  62     -19.858 118.812  24.903  1.00 77.44           C  
ATOM   9810  C   CYS F  62     -20.605 118.064  25.987  1.00 77.31           C  
ATOM   9811  O   CYS F  62     -20.949 116.896  25.802  1.00 77.33           O  
ATOM   9812  CB  CYS F  62     -20.728 119.931  24.342  1.00 77.56           C  
ATOM   9813  SG  CYS F  62     -22.285 119.353  23.644  1.00 77.72           S  
ATOM   9814  N   ASP F  63     -20.853 118.736  27.109  1.00 77.22           N  
ATOM   9815  CA  ASP F  63     -21.596 118.147  28.226  1.00 77.26           C  
ATOM   9816  C   ASP F  63     -22.928 117.578  27.758  1.00 77.09           C  
ATOM   9817  O   ASP F  63     -23.270 116.434  28.070  1.00 77.06           O  
ATOM   9818  CB  ASP F  63     -21.867 119.191  29.317  1.00 77.37           C  
ATOM   9819  CG  ASP F  63     -20.645 119.498  30.176  1.00 78.00           C  
ATOM   9820  OD1 ASP F  63     -19.581 118.857  30.008  1.00 77.84           O  
ATOM   9821  OD2 ASP F  63     -20.767 120.400  31.038  1.00 79.30           O  
ATOM   9822  N   GLY F  64     -23.671 118.393  27.008  1.00 76.91           N  
ATOM   9823  CA  GLY F  64     -24.986 118.020  26.498  1.00 76.76           C  
ATOM   9824  C   GLY F  64     -24.983 116.764  25.648  1.00 76.71           C  
ATOM   9825  O   GLY F  64     -25.933 115.987  25.690  1.00 77.00           O  
ATOM   9826  N   LEU F  65     -23.920 116.564  24.875  1.00 76.36           N  
ATOM   9827  CA  LEU F  65     -23.793 115.381  24.031  1.00 76.25           C  
ATOM   9828  C   LEU F  65     -23.482 114.150  24.883  1.00 75.87           C  
ATOM   9829  O   LEU F  65     -24.118 113.109  24.735  1.00 75.97           O  
ATOM   9830  CB  LEU F  65     -22.693 115.600  22.981  1.00 76.40           C  
ATOM   9831  CG  LEU F  65     -22.382 114.448  22.020  1.00 76.58           C  
ATOM   9832  CD1 LEU F  65     -23.605 114.091  21.211  1.00 76.76           C  
ATOM   9833  CD2 LEU F  65     -21.247 114.816  21.097  1.00 76.66           C  
ATOM   9834  N   ILE F  66     -22.504 114.289  25.775  1.00 75.25           N  
ATOM   9835  CA  ILE F  66     -22.084 113.209  26.661  1.00 74.65           C  
ATOM   9836  C   ILE F  66     -23.227 112.738  27.552  1.00 74.48           C  
ATOM   9837  O   ILE F  66     -23.466 111.536  27.677  1.00 74.44           O  
ATOM   9838  CB  ILE F  66     -20.895 113.646  27.550  1.00 74.59           C  
ATOM   9839  CG1 ILE F  66     -19.658 113.911  26.688  1.00 74.47           C  
ATOM   9840  CG2 ILE F  66     -20.576 112.583  28.610  1.00 74.02           C  
ATOM   9841  CD1 ILE F  66     -19.120 112.672  25.971  1.00 73.82           C  
ATOM   9842  N   ASP F  67     -23.926 113.691  28.162  1.00 74.19           N  
ATOM   9843  CA  ASP F  67     -25.097 113.395  28.989  1.00 74.11           C  
ATOM   9844  C   ASP F  67     -26.068 112.460  28.257  1.00 73.51           C  
ATOM   9845  O   ASP F  67     -26.559 111.489  28.835  1.00 73.37           O  
ATOM   9846  CB  ASP F  67     -25.813 114.700  29.381  1.00 74.30           C  
ATOM   9847  CG  ASP F  67     -26.702 114.549  30.620  1.00 75.70           C  
ATOM   9848  OD1 ASP F  67     -27.866 115.020  30.595  1.00 77.17           O  
ATOM   9849  OD2 ASP F  67     -26.234 113.973  31.627  1.00 78.11           O  
ATOM   9850  N   GLU F  68     -26.318 112.744  26.979  1.00 72.98           N  
ATOM   9851  CA  GLU F  68     -27.282 111.970  26.192  1.00 72.74           C  
ATOM   9852  C   GLU F  68     -26.735 110.614  25.761  1.00 72.59           C  
ATOM   9853  O   GLU F  68     -27.461 109.616  25.766  1.00 72.35           O  
ATOM   9854  CB  GLU F  68     -27.747 112.763  24.972  1.00 72.65           C  
ATOM   9855  CG  GLU F  68     -28.638 113.952  25.334  1.00 73.02           C  
ATOM   9856  CD  GLU F  68     -29.328 114.573  24.133  1.00 73.31           C  
ATOM   9857  OE1 GLU F  68     -28.821 114.414  22.998  1.00 73.48           O  
ATOM   9858  OE2 GLU F  68     -30.388 115.216  24.325  1.00 73.66           O  
ATOM   9859  N   LEU F  69     -25.459 110.585  25.381  1.00 72.35           N  
ATOM   9860  CA  LEU F  69     -24.784 109.336  25.068  1.00 72.38           C  
ATOM   9861  C   LEU F  69     -24.924 108.394  26.248  1.00 72.28           C  
ATOM   9862  O   LEU F  69     -25.235 107.222  26.078  1.00 72.17           O  
ATOM   9863  CB  LEU F  69     -23.302 109.588  24.769  1.00 72.39           C  
ATOM   9864  CG  LEU F  69     -22.413 108.356  24.578  1.00 72.52           C  
ATOM   9865  CD1 LEU F  69     -22.896 107.542  23.397  1.00 72.77           C  
ATOM   9866  CD2 LEU F  69     -20.948 108.753  24.404  1.00 72.73           C  
ATOM   9867  N   ASN F  70     -24.707 108.923  27.445  1.00 72.40           N  
ATOM   9868  CA  ASN F  70     -24.792 108.126  28.662  1.00 72.57           C  
ATOM   9869  C   ASN F  70     -26.214 107.620  28.943  1.00 72.99           C  
ATOM   9870  O   ASN F  70     -26.392 106.523  29.471  1.00 73.49           O  
ATOM   9871  CB  ASN F  70     -24.250 108.918  29.858  1.00 72.38           C  
ATOM   9872  CG  ASN F  70     -22.759 109.196  29.752  1.00 71.50           C  
ATOM   9873  OD1 ASN F  70     -22.047 108.560  28.983  1.00 71.11           O  
ATOM   9874  ND2 ASN F  70     -22.281 110.146  30.540  1.00 70.16           N  
ATOM   9875  N   GLN F  71     -27.222 108.406  28.598  1.00 73.15           N  
ATOM   9876  CA  GLN F  71     -28.601 107.936  28.718  1.00 73.48           C  
ATOM   9877  C   GLN F  71     -28.866 106.816  27.718  1.00 73.70           C  
ATOM   9878  O   GLN F  71     -29.572 105.858  28.030  1.00 73.78           O  
ATOM   9879  CB  GLN F  71     -29.600 109.082  28.525  1.00 73.30           C  
ATOM   9880  CG  GLN F  71     -29.752 109.947  29.759  1.00 73.75           C  
ATOM   9881  CD  GLN F  71     -30.345 111.310  29.463  1.00 74.99           C  
ATOM   9882  OE1 GLN F  71     -31.549 111.447  29.202  1.00 75.22           O  
ATOM   9883  NE2 GLN F  71     -29.502 112.338  29.520  1.00 75.36           N  
ATOM   9884  N   ALA F  72     -28.286 106.940  26.525  1.00 73.97           N  
ATOM   9885  CA  ALA F  72     -28.515 105.978  25.446  1.00 74.17           C  
ATOM   9886  C   ALA F  72     -27.835 104.640  25.741  1.00 74.41           C  
ATOM   9887  O   ALA F  72     -28.350 103.580  25.384  1.00 74.48           O  
ATOM   9888  CB  ALA F  72     -28.033 106.549  24.110  1.00 73.98           C  
ATOM   9889  N   LEU F  73     -26.674 104.697  26.385  1.00 74.75           N  
ATOM   9890  CA  LEU F  73     -25.983 103.492  26.823  1.00 74.85           C  
ATOM   9891  C   LEU F  73     -26.800 102.797  27.916  1.00 75.05           C  
ATOM   9892  O   LEU F  73     -27.071 101.604  27.832  1.00 74.93           O  
ATOM   9893  CB  LEU F  73     -24.578 103.842  27.318  1.00 74.77           C  
ATOM   9894  CG  LEU F  73     -23.621 104.431  26.267  1.00 74.53           C  
ATOM   9895  CD1 LEU F  73     -22.370 104.995  26.927  1.00 73.48           C  
ATOM   9896  CD2 LEU F  73     -23.247 103.403  25.208  1.00 74.13           C  
ATOM   9897  N   LYS F  74     -27.219 103.565  28.917  1.00 75.56           N  
ATOM   9898  CA  LYS F  74     -28.054 103.052  29.998  1.00 76.04           C  
ATOM   9899  C   LYS F  74     -29.266 102.277  29.461  1.00 76.59           C  
ATOM   9900  O   LYS F  74     -29.552 101.172  29.927  1.00 76.88           O  
ATOM   9901  CB  LYS F  74     -28.509 104.195  30.914  1.00 75.98           C  
ATOM   9902  CG  LYS F  74     -29.176 103.744  32.213  1.00 76.06           C  
ATOM   9903  N   ILE F  75     -29.957 102.835  28.468  1.00 77.00           N  
ATOM   9904  CA  ILE F  75     -31.128 102.163  27.891  1.00 77.48           C  
ATOM   9905  C   ILE F  75     -30.744 100.848  27.204  1.00 77.90           C  
ATOM   9906  O   ILE F  75     -31.231  99.784  27.591  1.00 78.43           O  
ATOM   9907  CB  ILE F  75     -31.910 103.077  26.912  1.00 77.43           C  
ATOM   9908  CG1 ILE F  75     -32.527 104.261  27.664  1.00 77.11           C  
ATOM   9909  CG2 ILE F  75     -33.025 102.301  26.237  1.00 77.21           C  
ATOM   9910  CD1 ILE F  75     -32.760 105.467  26.796  1.00 76.93           C  
ATOM   9911  N   PHE F  76     -29.863 100.912  26.210  1.00 78.23           N  
ATOM   9912  CA  PHE F  76     -29.408  99.703  25.501  1.00 78.62           C  
ATOM   9913  C   PHE F  76     -28.807  98.607  26.397  1.00 79.20           C  
ATOM   9914  O   PHE F  76     -28.918  97.424  26.072  1.00 79.23           O  
ATOM   9915  CB  PHE F  76     -28.391 100.056  24.404  1.00 78.41           C  
ATOM   9916  CG  PHE F  76     -28.977 100.781  23.223  1.00 77.93           C  
ATOM   9917  CD1 PHE F  76     -30.258 100.490  22.755  1.00 77.54           C  
ATOM   9918  CD2 PHE F  76     -28.231 101.740  22.554  1.00 77.56           C  
ATOM   9919  CE1 PHE F  76     -30.785 101.156  21.663  1.00 77.24           C  
ATOM   9920  CE2 PHE F  76     -28.756 102.408  21.452  1.00 77.65           C  
ATOM   9921  CZ  PHE F  76     -30.033 102.113  21.010  1.00 77.60           C  
ATOM   9922  N   GLU F  77     -28.157  99.001  27.494  1.00 79.87           N  
ATOM   9923  CA  GLU F  77     -27.661  98.049  28.504  1.00 80.45           C  
ATOM   9924  C   GLU F  77     -28.826  97.345  29.220  1.00 80.44           C  
ATOM   9925  O   GLU F  77     -28.727  96.168  29.578  1.00 80.25           O  
ATOM   9926  CB  GLU F  77     -26.791  98.785  29.535  1.00 80.77           C  
ATOM   9927  CG  GLU F  77     -26.144  97.895  30.632  1.00 82.23           C  
ATOM   9928  CD  GLU F  77     -24.702  97.479  30.324  1.00 84.20           C  
ATOM   9929  OE1 GLU F  77     -24.222  97.760  29.203  1.00 85.51           O  
ATOM   9930  OE2 GLU F  77     -24.047  96.871  31.210  1.00 84.77           O  
ATOM   9931  N   GLU F  78     -29.926  98.070  29.420  1.00 80.48           N  
ATOM   9932  CA  GLU F  78     -31.121  97.514  30.070  1.00 80.64           C  
ATOM   9933  C   GLU F  78     -32.016  96.717  29.129  1.00 80.23           C  
ATOM   9934  O   GLU F  78     -32.774  95.861  29.589  1.00 80.13           O  
ATOM   9935  CB  GLU F  78     -31.938  98.623  30.751  1.00 80.59           C  
ATOM   9936  CG  GLU F  78     -31.345  99.027  32.097  1.00 81.29           C  
ATOM   9937  CD  GLU F  78     -32.015 100.234  32.724  1.00 81.47           C  
ATOM   9938  OE1 GLU F  78     -33.181 100.538  32.378  1.00 83.75           O  
ATOM   9939  OE2 GLU F  78     -31.367 100.873  33.580  1.00 82.51           O  
ATOM   9940  N   ASP F  79     -31.933  96.987  27.827  1.00 79.93           N  
ATOM   9941  CA  ASP F  79     -32.802  96.319  26.861  1.00 79.80           C  
ATOM   9942  C   ASP F  79     -32.312  94.885  26.651  1.00 79.39           C  
ATOM   9943  O   ASP F  79     -31.203  94.678  26.160  1.00 79.16           O  
ATOM   9944  CB  ASP F  79     -32.846  97.086  25.533  1.00 79.86           C  
ATOM   9945  CG  ASP F  79     -33.936  96.575  24.592  1.00 80.42           C  
ATOM   9946  OD1 ASP F  79     -33.962  95.354  24.323  1.00 81.69           O  
ATOM   9947  OD2 ASP F  79     -34.758  97.389  24.108  1.00 79.43           O  
ATOM   9948  N   PRO F  80     -33.143  93.889  27.022  1.00 79.02           N  
ATOM   9949  CA  PRO F  80     -32.713  92.487  26.943  1.00 78.72           C  
ATOM   9950  C   PRO F  80     -32.605  91.924  25.517  1.00 78.29           C  
ATOM   9951  O   PRO F  80     -32.004  90.867  25.332  1.00 78.12           O  
ATOM   9952  CB  PRO F  80     -33.783  91.746  27.750  1.00 78.75           C  
ATOM   9953  CG  PRO F  80     -35.002  92.593  27.635  1.00 78.95           C  
ATOM   9954  CD  PRO F  80     -34.524  94.016  27.527  1.00 79.00           C  
ATOM   9955  N   ALA F  81     -33.180  92.612  24.528  1.00 77.84           N  
ATOM   9956  CA  ALA F  81     -32.961  92.258  23.117  1.00 77.53           C  
ATOM   9957  C   ALA F  81     -31.595  92.755  22.603  1.00 77.28           C  
ATOM   9958  O   ALA F  81     -30.999  92.138  21.715  1.00 77.51           O  
ATOM   9959  CB  ALA F  81     -34.062  92.804  22.258  1.00 77.30           C  
ATOM   9960  N   VAL F  82     -31.102  93.863  23.154  1.00 76.55           N  
ATOM   9961  CA  VAL F  82     -29.827  94.417  22.724  1.00 76.08           C  
ATOM   9962  C   VAL F  82     -28.681  93.550  23.231  1.00 75.61           C  
ATOM   9963  O   VAL F  82     -28.534  93.368  24.433  1.00 75.72           O  
ATOM   9964  CB  VAL F  82     -29.646  95.863  23.215  1.00 76.08           C  
ATOM   9965  CG1 VAL F  82     -28.204  96.325  23.014  1.00 75.90           C  
ATOM   9966  CG2 VAL F  82     -30.622  96.781  22.485  1.00 76.14           C  
ATOM   9967  N   GLY F  83     -27.892  93.007  22.304  1.00 75.03           N  
ATOM   9968  CA  GLY F  83     -26.722  92.186  22.632  1.00 74.60           C  
ATOM   9969  C   GLY F  83     -25.393  92.905  22.453  1.00 74.25           C  
ATOM   9970  O   GLY F  83     -24.356  92.458  22.955  1.00 74.23           O  
ATOM   9971  N   ALA F  84     -25.420  94.021  21.738  1.00 73.97           N  
ATOM   9972  CA  ALA F  84     -24.214  94.775  21.433  1.00 73.79           C  
ATOM   9973  C   ALA F  84     -24.579  96.183  20.989  1.00 73.67           C  
ATOM   9974  O   ALA F  84     -25.675  96.419  20.469  1.00 73.79           O  
ATOM   9975  CB  ALA F  84     -23.430  94.075  20.347  1.00 73.65           C  
ATOM   9976  N   ILE F  85     -23.657  97.114  21.193  1.00 73.45           N  
ATOM   9977  CA  ILE F  85     -23.866  98.495  20.807  1.00 73.40           C  
ATOM   9978  C   ILE F  85     -22.869  98.909  19.729  1.00 73.73           C  
ATOM   9979  O   ILE F  85     -21.710  98.481  19.747  1.00 73.41           O  
ATOM   9980  CB  ILE F  85     -23.708  99.400  22.012  1.00 73.30           C  
ATOM   9981  CG1 ILE F  85     -24.861  99.158  22.984  1.00 73.29           C  
ATOM   9982  CG2 ILE F  85     -23.648 100.856  21.589  1.00 73.27           C  
ATOM   9983  CD1 ILE F  85     -24.649  99.786  24.341  1.00 73.75           C  
ATOM   9984  N   VAL F  86     -23.338  99.720  18.777  1.00 73.96           N  
ATOM   9985  CA  VAL F  86     -22.450 100.381  17.827  1.00 73.96           C  
ATOM   9986  C   VAL F  86     -22.508 101.877  18.088  1.00 74.03           C  
ATOM   9987  O   VAL F  86     -23.578 102.455  18.153  1.00 73.65           O  
ATOM   9988  CB  VAL F  86     -22.821 100.087  16.352  1.00 73.99           C  
ATOM   9989  CG1 VAL F  86     -21.852 100.783  15.413  1.00 74.06           C  
ATOM   9990  CG2 VAL F  86     -22.799  98.593  16.075  1.00 73.83           C  
ATOM   9991  N   LEU F  87     -21.343 102.480  18.269  1.00 74.50           N  
ATOM   9992  CA  LEU F  87     -21.207 103.919  18.384  1.00 75.04           C  
ATOM   9993  C   LEU F  87     -20.642 104.429  17.061  1.00 75.63           C  
ATOM   9994  O   LEU F  87     -19.697 103.838  16.538  1.00 75.73           O  
ATOM   9995  CB  LEU F  87     -20.248 104.249  19.526  1.00 75.07           C  
ATOM   9996  CG  LEU F  87     -20.035 105.725  19.862  1.00 75.28           C  
ATOM   9997  CD1 LEU F  87     -21.318 106.341  20.409  1.00 75.01           C  
ATOM   9998  CD2 LEU F  87     -18.891 105.881  20.855  1.00 75.01           C  
ATOM   9999  N   THR F  88     -21.212 105.510  16.521  1.00 76.21           N  
ATOM  10000  CA  THR F  88     -20.713 106.115  15.273  1.00 77.09           C  
ATOM  10001  C   THR F  88     -20.948 107.612  15.239  1.00 77.33           C  
ATOM  10002  O   THR F  88     -21.726 108.134  16.030  1.00 77.35           O  
ATOM  10003  CB  THR F  88     -21.403 105.515  14.031  1.00 77.25           C  
ATOM  10004  OG1 THR F  88     -21.289 104.094  14.073  1.00 79.28           O  
ATOM  10005  CG2 THR F  88     -20.766 106.013  12.736  1.00 77.45           C  
ATOM  10006  N   GLY F  89     -20.259 108.293  14.323  1.00 77.87           N  
ATOM  10007  CA  GLY F  89     -20.563 109.685  13.979  1.00 78.27           C  
ATOM  10008  C   GLY F  89     -21.207 109.814  12.607  1.00 78.67           C  
ATOM  10009  O   GLY F  89     -22.101 109.036  12.248  1.00 78.75           O  
ATOM  10010  N   GLY F  90     -20.764 110.817  11.848  1.00 79.20           N  
ATOM  10011  CA  GLY F  90     -21.238 111.049  10.480  1.00 79.37           C  
ATOM  10012  C   GLY F  90     -20.304 110.377   9.496  1.00 79.61           C  
ATOM  10013  O   GLY F  90     -19.754 109.323   9.787  1.00 80.10           O  
ATOM  10014  N   ASP F  91     -20.118 110.986   8.332  1.00 79.94           N  
ATOM  10015  CA  ASP F  91     -19.192 110.467   7.322  1.00 80.20           C  
ATOM  10016  C   ASP F  91     -17.887 111.263   7.280  1.00 80.21           C  
ATOM  10017  O   ASP F  91     -16.832 110.719   6.957  1.00 80.11           O  
ATOM  10018  CB  ASP F  91     -19.856 110.479   5.943  1.00 80.39           C  
ATOM  10019  CG  ASP F  91     -21.032 109.514   5.850  1.00 81.08           C  
ATOM  10020  OD1 ASP F  91     -21.167 108.639   6.742  1.00 81.38           O  
ATOM  10021  OD2 ASP F  91     -21.818 109.633   4.881  1.00 81.68           O  
ATOM  10022  N   LYS F  92     -17.966 112.552   7.593  1.00 80.37           N  
ATOM  10023  CA  LYS F  92     -16.791 113.402   7.649  1.00 80.50           C  
ATOM  10024  C   LYS F  92     -16.142 113.355   9.037  1.00 80.73           C  
ATOM  10025  O   LYS F  92     -14.947 113.649   9.168  1.00 80.94           O  
ATOM  10026  CB  LYS F  92     -17.162 114.845   7.283  1.00 80.62           C  
ATOM  10027  N   ALA F  93     -16.909 112.968  10.062  1.00 80.69           N  
ATOM  10028  CA  ALA F  93     -16.427 113.055  11.445  1.00 80.59           C  
ATOM  10029  C   ALA F  93     -17.118 112.103  12.424  1.00 80.56           C  
ATOM  10030  O   ALA F  93     -18.346 112.100  12.532  1.00 80.22           O  
ATOM  10031  CB  ALA F  93     -16.572 114.482  11.941  1.00 80.55           C  
ATOM  10032  N   PHE F  94     -16.300 111.318  13.138  1.00 80.46           N  
ATOM  10033  CA  PHE F  94     -16.730 110.535  14.307  1.00 80.50           C  
ATOM  10034  C   PHE F  94     -16.990 111.472  15.499  1.00 80.41           C  
ATOM  10035  O   PHE F  94     -18.104 111.540  16.027  1.00 80.13           O  
ATOM  10036  CB  PHE F  94     -15.638 109.496  14.667  1.00 80.76           C  
ATOM  10037  CG  PHE F  94     -15.982 108.610  15.839  1.00 80.60           C  
ATOM  10038  CD1 PHE F  94     -16.952 107.617  15.721  1.00 81.29           C  
ATOM  10039  CD2 PHE F  94     -15.323 108.750  17.050  1.00 80.93           C  
ATOM  10040  CE1 PHE F  94     -17.271 106.788  16.805  1.00 81.54           C  
ATOM  10041  CE2 PHE F  94     -15.630 107.919  18.138  1.00 80.94           C  
ATOM  10042  CZ  PHE F  94     -16.604 106.943  18.015  1.00 81.01           C  
ATOM  10043  N   ALA F  95     -15.931 112.170  15.909  1.00 80.37           N  
ATOM  10044  CA  ALA F  95     -15.975 113.219  16.924  1.00 80.44           C  
ATOM  10045  C   ALA F  95     -14.634 113.946  16.842  1.00 80.65           C  
ATOM  10046  O   ALA F  95     -13.587 113.327  16.944  1.00 80.46           O  
ATOM  10047  CB  ALA F  95     -16.194 112.635  18.303  1.00 80.36           C  
ATOM  10048  N   ALA F  96     -14.667 115.255  16.634  1.00 81.21           N  
ATOM  10049  CA  ALA F  96     -13.469 116.009  16.271  1.00 81.63           C  
ATOM  10050  C   ALA F  96     -12.838 116.729  17.461  1.00 82.06           C  
ATOM  10051  O   ALA F  96     -12.289 117.820  17.303  1.00 82.68           O  
ATOM  10052  CB  ALA F  96     -13.808 117.023  15.167  1.00 81.47           C  
ATOM  10053  N   GLY F  97     -12.908 116.126  18.644  1.00 82.23           N  
ATOM  10054  CA  GLY F  97     -12.421 116.768  19.867  1.00 82.43           C  
ATOM  10055  C   GLY F  97     -13.558 117.252  20.752  1.00 82.59           C  
ATOM  10056  O   GLY F  97     -14.727 116.980  20.477  1.00 82.59           O  
ATOM  10057  N   ALA F  98     -13.210 117.974  21.814  1.00 82.76           N  
ATOM  10058  CA  ALA F  98     -14.180 118.393  22.829  1.00 82.82           C  
ATOM  10059  C   ALA F  98     -14.522 119.868  22.703  1.00 82.88           C  
ATOM  10060  O   ALA F  98     -13.906 120.599  21.921  1.00 83.06           O  
ATOM  10061  CB  ALA F  98     -13.642 118.105  24.217  1.00 82.83           C  
ATOM  10062  N   ASP F  99     -15.505 120.299  23.491  1.00 82.79           N  
ATOM  10063  CA  ASP F  99     -15.958 121.688  23.475  1.00 82.67           C  
ATOM  10064  C   ASP F  99     -15.007 122.557  24.297  1.00 82.31           C  
ATOM  10065  O   ASP F  99     -15.223 122.798  25.489  1.00 82.39           O  
ATOM  10066  CB  ASP F  99     -17.392 121.790  24.004  1.00 82.78           C  
ATOM  10067  CG  ASP F  99     -17.989 123.166  23.805  1.00 83.05           C  
ATOM  10068  OD1 ASP F  99     -18.365 123.491  22.657  1.00 83.69           O  
ATOM  10069  OD2 ASP F  99     -18.089 123.917  24.798  1.00 83.79           O  
ATOM  10070  N   ILE F 100     -13.960 123.034  23.631  1.00 81.84           N  
ATOM  10071  CA  ILE F 100     -12.902 123.820  24.262  1.00 81.47           C  
ATOM  10072  C   ILE F 100     -13.379 125.178  24.777  1.00 81.15           C  
ATOM  10073  O   ILE F 100     -12.753 125.757  25.666  1.00 81.01           O  
ATOM  10074  CB  ILE F 100     -11.718 123.990  23.283  1.00 81.54           C  
ATOM  10075  CG1 ILE F 100     -11.006 122.637  23.112  1.00 81.73           C  
ATOM  10076  CG2 ILE F 100     -10.749 125.074  23.763  1.00 81.34           C  
ATOM  10077  CD1 ILE F 100     -10.449 122.385  21.715  1.00 82.25           C  
ATOM  10078  N   LYS F 101     -14.487 125.676  24.230  1.00 80.97           N  
ATOM  10079  CA  LYS F 101     -15.107 126.913  24.720  1.00 80.82           C  
ATOM  10080  C   LYS F 101     -15.633 126.761  26.160  1.00 80.77           C  
ATOM  10081  O   LYS F 101     -15.743 127.751  26.891  1.00 80.64           O  
ATOM  10082  CB  LYS F 101     -16.233 127.360  23.778  1.00 80.73           C  
ATOM  10083  N   GLU F 102     -15.940 125.524  26.562  1.00 80.69           N  
ATOM  10084  CA  GLU F 102     -16.361 125.223  27.939  1.00 80.60           C  
ATOM  10085  C   GLU F 102     -15.178 125.158  28.928  1.00 80.42           C  
ATOM  10086  O   GLU F 102     -15.283 125.637  30.060  1.00 80.56           O  
ATOM  10087  CB  GLU F 102     -17.147 123.907  27.976  1.00 80.58           C  
ATOM  10088  N   MET F 103     -14.055 124.588  28.489  1.00 80.06           N  
ATOM  10089  CA  MET F 103     -12.861 124.417  29.341  1.00 79.80           C  
ATOM  10090  C   MET F 103     -12.058 125.703  29.570  1.00 79.36           C  
ATOM  10091  O   MET F 103     -11.135 125.714  30.380  1.00 79.48           O  
ATOM  10092  CB  MET F 103     -11.907 123.386  28.723  1.00 79.64           C  
ATOM  10093  CG  MET F 103     -12.525 122.036  28.423  1.00 79.71           C  
ATOM  10094  SD  MET F 103     -11.277 120.786  28.043  1.00 80.24           S  
ATOM  10095  CE  MET F 103     -10.667 121.385  26.473  1.00 81.63           C  
ATOM  10096  N   GLN F 104     -12.428 126.776  28.876  1.00 78.78           N  
ATOM  10097  CA  GLN F 104     -11.545 127.921  28.652  1.00 78.28           C  
ATOM  10098  C   GLN F 104     -11.234 128.745  29.899  1.00 78.02           C  
ATOM  10099  O   GLN F 104     -10.119 129.243  30.039  1.00 77.81           O  
ATOM  10100  CB  GLN F 104     -12.169 128.817  27.573  1.00 78.44           C  
ATOM  10101  CG  GLN F 104     -11.264 129.902  26.996  1.00 78.15           C  
ATOM  10102  CD  GLN F 104     -12.013 130.875  26.085  1.00 77.91           C  
ATOM  10103  OE1 GLN F 104     -11.460 131.884  25.660  1.00 77.03           O  
ATOM  10104  NE2 GLN F 104     -13.276 130.572  25.789  1.00 76.83           N  
ATOM  10105  N   ASN F 105     -12.210 128.900  30.788  1.00 77.82           N  
ATOM  10106  CA  ASN F 105     -12.042 129.742  31.980  1.00 77.74           C  
ATOM  10107  C   ASN F 105     -11.715 128.954  33.248  1.00 77.49           C  
ATOM  10108  O   ASN F 105     -11.399 129.544  34.285  1.00 77.40           O  
ATOM  10109  CB  ASN F 105     -13.302 130.581  32.220  1.00 77.85           C  
ATOM  10110  CG  ASN F 105     -13.600 131.538  31.075  1.00 78.00           C  
ATOM  10111  OD1 ASN F 105     -12.904 131.553  30.057  1.00 78.10           O  
ATOM  10112  ND2 ASN F 105     -14.644 132.338  31.238  1.00 77.58           N  
ATOM  10113  N   LEU F 106     -11.777 127.628  33.149  1.00 77.20           N  
ATOM  10114  CA  LEU F 106     -11.651 126.736  34.302  1.00 76.89           C  
ATOM  10115  C   LEU F 106     -10.342 126.925  35.069  1.00 76.55           C  
ATOM  10116  O   LEU F 106      -9.283 127.130  34.474  1.00 76.32           O  
ATOM  10117  CB  LEU F 106     -11.782 125.271  33.858  1.00 76.87           C  
ATOM  10118  CG  LEU F 106     -13.206 124.718  33.696  1.00 77.07           C  
ATOM  10119  CD1 LEU F 106     -14.084 125.633  32.861  1.00 77.23           C  
ATOM  10120  CD2 LEU F 106     -13.177 123.317  33.094  1.00 77.01           C  
ATOM  10121  N   SER F 107     -10.439 126.869  36.397  1.00 76.30           N  
ATOM  10122  CA  SER F 107      -9.275 126.880  37.287  1.00 76.06           C  
ATOM  10123  C   SER F 107      -8.799 125.454  37.566  1.00 75.85           C  
ATOM  10124  O   SER F 107      -9.463 124.483  37.192  1.00 75.63           O  
ATOM  10125  CB  SER F 107      -9.630 127.557  38.614  1.00 75.99           C  
ATOM  10126  OG  SER F 107      -8.545 127.504  39.522  1.00 75.78           O  
ATOM  10127  N   PHE F 108      -7.646 125.334  38.218  1.00 75.73           N  
ATOM  10128  CA  PHE F 108      -7.188 124.037  38.710  1.00 75.71           C  
ATOM  10129  C   PHE F 108      -8.158 123.496  39.765  1.00 76.01           C  
ATOM  10130  O   PHE F 108      -8.563 122.342  39.705  1.00 75.62           O  
ATOM  10131  CB  PHE F 108      -5.783 124.133  39.310  1.00 75.52           C  
ATOM  10132  CG  PHE F 108      -5.400 122.931  40.121  1.00 75.04           C  
ATOM  10133  CD1 PHE F 108      -5.040 121.754  39.493  1.00 74.61           C  
ATOM  10134  CD2 PHE F 108      -5.437 122.967  41.507  1.00 74.68           C  
ATOM  10135  CE1 PHE F 108      -4.709 120.636  40.225  1.00 74.87           C  
ATOM  10136  CE2 PHE F 108      -5.108 121.856  42.249  1.00 74.64           C  
ATOM  10137  CZ  PHE F 108      -4.741 120.683  41.604  1.00 75.20           C  
ATOM  10138  N   GLN F 109      -8.519 124.348  40.723  1.00 76.68           N  
ATOM  10139  CA  GLN F 109      -9.447 123.979  41.792  1.00 77.27           C  
ATOM  10140  C   GLN F 109     -10.784 123.503  41.231  1.00 78.16           C  
ATOM  10141  O   GLN F 109     -11.294 122.453  41.633  1.00 78.41           O  
ATOM  10142  CB  GLN F 109      -9.682 125.159  42.732  1.00 77.14           C  
ATOM  10143  CG  GLN F 109      -8.482 125.538  43.592  1.00 76.82           C  
ATOM  10144  CD  GLN F 109      -7.547 126.526  42.917  1.00 76.45           C  
ATOM  10145  OE1 GLN F 109      -7.352 126.484  41.700  1.00 76.07           O  
ATOM  10146  NE2 GLN F 109      -6.957 127.417  43.707  1.00 75.41           N  
ATOM  10147  N   ASP F 110     -11.338 124.277  40.300  1.00 79.14           N  
ATOM  10148  CA  ASP F 110     -12.577 123.914  39.604  1.00 79.92           C  
ATOM  10149  C   ASP F 110     -12.513 122.511  38.996  1.00 80.54           C  
ATOM  10150  O   ASP F 110     -13.477 121.751  39.080  1.00 80.55           O  
ATOM  10151  CB  ASP F 110     -12.893 124.934  38.496  1.00 80.04           C  
ATOM  10152  CG  ASP F 110     -13.337 126.291  39.041  1.00 80.23           C  
ATOM  10153  OD1 ASP F 110     -14.075 126.332  40.050  1.00 80.28           O  
ATOM  10154  OD2 ASP F 110     -12.960 127.322  38.445  1.00 81.01           O  
ATOM  10155  N   CYS F 111     -11.379 122.180  38.386  1.00 81.46           N  
ATOM  10156  CA  CYS F 111     -11.182 120.863  37.774  1.00 82.21           C  
ATOM  10157  C   CYS F 111     -11.205 119.746  38.810  1.00 82.89           C  
ATOM  10158  O   CYS F 111     -11.910 118.746  38.638  1.00 83.13           O  
ATOM  10159  CB  CYS F 111      -9.856 120.806  37.007  1.00 82.20           C  
ATOM  10160  SG  CYS F 111      -9.922 121.454  35.322  1.00 83.06           S  
ATOM  10161  N   TYR F 112     -10.432 119.925  39.878  1.00 83.60           N  
ATOM  10162  CA  TYR F 112     -10.190 118.862  40.852  1.00 83.97           C  
ATOM  10163  C   TYR F 112     -11.388 118.622  41.768  1.00 84.41           C  
ATOM  10164  O   TYR F 112     -11.811 117.483  41.953  1.00 84.43           O  
ATOM  10165  CB  TYR F 112      -8.940 119.166  41.688  1.00 83.95           C  
ATOM  10166  CG  TYR F 112      -8.609 118.060  42.655  1.00 83.96           C  
ATOM  10167  CD1 TYR F 112      -7.779 117.004  42.279  1.00 83.73           C  
ATOM  10168  CD2 TYR F 112      -9.153 118.048  43.941  1.00 84.18           C  
ATOM  10169  CE1 TYR F 112      -7.483 115.972  43.163  1.00 84.00           C  
ATOM  10170  CE2 TYR F 112      -8.868 117.020  44.833  1.00 84.10           C  
ATOM  10171  CZ  TYR F 112      -8.035 115.988  44.438  1.00 84.23           C  
ATOM  10172  OH  TYR F 112      -7.753 114.980  45.322  1.00 84.44           O  
ATOM  10173  N   SER F 113     -11.930 119.691  42.340  1.00 85.02           N  
ATOM  10174  CA  SER F 113     -13.054 119.571  43.273  1.00 85.51           C  
ATOM  10175  C   SER F 113     -14.295 118.943  42.633  1.00 86.16           C  
ATOM  10176  O   SER F 113     -15.101 118.319  43.326  1.00 86.47           O  
ATOM  10177  CB  SER F 113     -13.425 120.940  43.855  1.00 85.42           C  
ATOM  10178  OG  SER F 113     -12.382 121.463  44.656  1.00 85.03           O  
ATOM  10179  N   SER F 114     -14.438 119.112  41.323  1.00 86.87           N  
ATOM  10180  CA  SER F 114     -15.723 118.915  40.661  1.00 87.45           C  
ATOM  10181  C   SER F 114     -15.602 117.923  39.510  1.00 87.88           C  
ATOM  10182  O   SER F 114     -15.802 118.279  38.348  1.00 87.70           O  
ATOM  10183  CB  SER F 114     -16.274 120.248  40.151  1.00 87.47           C  
ATOM  10184  OG  SER F 114     -17.346 120.045  39.248  1.00 87.69           O  
ATOM  10185  N   LYS F 115     -15.275 116.678  39.839  1.00 88.55           N  
ATOM  10186  CA  LYS F 115     -14.397 115.869  39.002  1.00 89.17           C  
ATOM  10187  C   LYS F 115     -14.681 116.100  37.521  1.00 89.77           C  
ATOM  10188  O   LYS F 115     -15.748 115.744  37.021  1.00 90.22           O  
ATOM  10189  CB  LYS F 115     -14.549 114.385  39.342  1.00 89.06           C  
ATOM  10190  N   PHE F 116     -13.720 116.697  36.824  1.00 90.23           N  
ATOM  10191  CA  PHE F 116     -13.926 117.129  35.447  1.00 90.44           C  
ATOM  10192  C   PHE F 116     -13.693 115.981  34.470  1.00 90.65           C  
ATOM  10193  O   PHE F 116     -12.695 115.266  34.563  1.00 90.71           O  
ATOM  10194  CB  PHE F 116     -13.004 118.302  35.110  1.00 90.46           C  
ATOM  10195  CG  PHE F 116     -13.209 118.855  33.729  1.00 90.67           C  
ATOM  10196  CD1 PHE F 116     -14.484 119.107  33.250  1.00 90.78           C  
ATOM  10197  CD2 PHE F 116     -12.126 119.125  32.908  1.00 90.77           C  
ATOM  10198  CE1 PHE F 116     -14.676 119.616  31.980  1.00 90.90           C  
ATOM  10199  CE2 PHE F 116     -12.311 119.634  31.636  1.00 90.60           C  
ATOM  10200  CZ  PHE F 116     -13.589 119.880  31.172  1.00 90.61           C  
ATOM  10201  N   LEU F 117     -14.620 115.811  33.533  1.00 90.79           N  
ATOM  10202  CA  LEU F 117     -14.568 114.679  32.586  1.00 91.01           C  
ATOM  10203  C   LEU F 117     -14.800 113.320  33.273  1.00 91.09           C  
ATOM  10204  O   LEU F 117     -14.332 112.281  32.789  1.00 91.01           O  
ATOM  10205  CB  LEU F 117     -13.250 114.654  31.778  1.00 90.97           C  
ATOM  10206  CG  LEU F 117     -12.860 115.895  30.960  1.00 91.31           C  
ATOM  10207  CD1 LEU F 117     -11.558 115.651  30.198  1.00 91.43           C  
ATOM  10208  CD2 LEU F 117     -13.966 116.307  29.990  1.00 90.97           C  
ATOM  10209  N   LYS F 118     -15.535 113.330  34.385  1.00 91.24           N  
ATOM  10210  CA  LYS F 118     -15.840 112.098  35.123  1.00 91.49           C  
ATOM  10211  C   LYS F 118     -16.880 111.274  34.368  1.00 91.60           C  
ATOM  10212  O   LYS F 118     -16.707 110.063  34.177  1.00 91.66           O  
ATOM  10213  CB  LYS F 118     -16.351 112.402  36.540  1.00 91.41           C  
ATOM  10214  N   HIS F 119     -17.947 111.939  33.921  1.00 91.52           N  
ATOM  10215  CA  HIS F 119     -19.045 111.260  33.231  1.00 91.50           C  
ATOM  10216  C   HIS F 119     -18.709 110.845  31.791  1.00 91.14           C  
ATOM  10217  O   HIS F 119     -19.512 110.190  31.122  1.00 90.99           O  
ATOM  10218  CB  HIS F 119     -20.316 112.116  33.283  1.00 91.73           C  
ATOM  10219  CG  HIS F 119     -20.994 112.096  34.621  1.00 92.57           C  
ATOM  10220  ND1 HIS F 119     -20.857 111.048  35.510  1.00 93.66           N  
ATOM  10221  CD2 HIS F 119     -21.837 112.980  35.209  1.00 93.13           C  
ATOM  10222  CE1 HIS F 119     -21.571 111.296  36.595  1.00 93.67           C  
ATOM  10223  NE2 HIS F 119     -22.178 112.461  36.437  1.00 93.46           N  
ATOM  10224  N   TRP F 120     -17.502 111.182  31.343  1.00 90.84           N  
ATOM  10225  CA  TRP F 120     -17.010 110.793  30.025  1.00 90.67           C  
ATOM  10226  C   TRP F 120     -16.506 109.350  30.015  1.00 90.23           C  
ATOM  10227  O   TRP F 120     -15.852 108.928  29.064  1.00 90.17           O  
ATOM  10228  CB  TRP F 120     -15.879 111.735  29.593  1.00 91.00           C  
ATOM  10229  CG  TRP F 120     -16.344 113.119  29.298  1.00 91.22           C  
ATOM  10230  CD1 TRP F 120     -17.221 113.867  30.031  1.00 91.96           C  
ATOM  10231  CD2 TRP F 120     -15.953 113.934  28.191  1.00 91.52           C  
ATOM  10232  NE1 TRP F 120     -17.409 115.095  29.444  1.00 92.33           N  
ATOM  10233  CE2 TRP F 120     -16.637 115.164  28.314  1.00 92.12           C  
ATOM  10234  CE3 TRP F 120     -15.093 113.745  27.103  1.00 92.17           C  
ATOM  10235  CZ2 TRP F 120     -16.489 116.202  27.389  1.00 91.92           C  
ATOM  10236  CZ3 TRP F 120     -14.945 114.779  26.181  1.00 91.89           C  
ATOM  10237  CH2 TRP F 120     -15.640 115.992  26.334  1.00 91.84           C  
ATOM  10238  N   ASP F 121     -16.849 108.590  31.050  1.00 89.59           N  
ATOM  10239  CA  ASP F 121     -16.199 107.326  31.339  1.00 89.39           C  
ATOM  10240  C   ASP F 121     -17.153 106.131  31.390  1.00 88.32           C  
ATOM  10241  O   ASP F 121     -16.710 105.003  31.638  1.00 88.22           O  
ATOM  10242  CB  ASP F 121     -15.511 107.464  32.705  1.00 89.85           C  
ATOM  10243  CG  ASP F 121     -14.175 106.770  32.770  1.00 91.75           C  
ATOM  10244  OD1 ASP F 121     -13.858 105.948  31.877  1.00 94.81           O  
ATOM  10245  OD2 ASP F 121     -13.427 107.056  33.735  1.00 95.28           O  
ATOM  10246  N   HIS F 122     -18.446 106.368  31.157  1.00 87.34           N  
ATOM  10247  CA  HIS F 122     -19.467 105.326  31.296  0.50 86.96           C  
ATOM  10249  C   HIS F 122     -19.332 104.253  30.212  1.00 86.54           C  
ATOM  10250  O   HIS F 122     -19.817 103.136  30.376  1.00 86.53           O  
ATOM  10251  CB  HIS F 122     -20.874 105.947  31.283  0.50 86.98           C  
ATOM  10253  CG  HIS F 122     -21.956 105.019  31.748  0.50 87.14           C  
ATOM  10255  ND1 HIS F 122     -23.222 105.017  31.200  0.50 87.30           N  
ATOM  10257  CD2 HIS F 122     -21.961 104.062  32.708  0.50 87.16           C  
ATOM  10259  CE1 HIS F 122     -23.959 104.101  31.802  0.50 87.24           C  
ATOM  10261  NE2 HIS F 122     -23.217 103.506  32.719  0.50 87.37           N  
ATOM  10263  N   LEU F 123     -18.678 104.589  29.104  1.00 85.89           N  
ATOM  10264  CA  LEU F 123     -18.358 103.585  28.089  1.00 85.46           C  
ATOM  10265  C   LEU F 123     -17.551 102.429  28.704  1.00 85.13           C  
ATOM  10266  O   LEU F 123     -17.771 101.264  28.370  1.00 85.37           O  
ATOM  10267  CB  LEU F 123     -17.569 104.197  26.917  1.00 85.48           C  
ATOM  10268  CG  LEU F 123     -18.351 104.667  25.686  1.00 85.31           C  
ATOM  10269  CD1 LEU F 123     -17.463 105.468  24.746  1.00 84.65           C  
ATOM  10270  CD2 LEU F 123     -18.946 103.480  24.957  1.00 85.20           C  
ATOM  10271  N   THR F 124     -16.626 102.753  29.610  1.00 84.45           N  
ATOM  10272  CA  THR F 124     -15.797 101.734  30.261  1.00 83.90           C  
ATOM  10273  C   THR F 124     -16.576 100.902  31.292  1.00 83.90           C  
ATOM  10274  O   THR F 124     -16.014  99.999  31.912  1.00 84.16           O  
ATOM  10275  CB  THR F 124     -14.563 102.355  30.968  1.00 83.64           C  
ATOM  10276  OG1 THR F 124     -14.996 103.210  32.034  1.00 82.80           O  
ATOM  10277  CG2 THR F 124     -13.708 103.144  29.983  1.00 82.99           C  
ATOM  10278  N   GLN F 125     -17.856 101.202  31.478  1.00 83.53           N  
ATOM  10279  CA  GLN F 125     -18.667 100.512  32.465  1.00 83.51           C  
ATOM  10280  C   GLN F 125     -19.853  99.747  31.875  1.00 82.67           C  
ATOM  10281  O   GLN F 125     -20.599  99.093  32.611  1.00 82.39           O  
ATOM  10282  CB  GLN F 125     -19.150 101.522  33.502  1.00 83.89           C  
ATOM  10283  CG  GLN F 125     -18.023 102.061  34.371  1.00 85.77           C  
ATOM  10284  CD  GLN F 125     -18.536 102.935  35.501  1.00 87.91           C  
ATOM  10285  OE1 GLN F 125     -19.119 104.002  35.265  1.00 89.14           O  
ATOM  10286  NE2 GLN F 125     -18.324 102.490  36.740  1.00 88.96           N  
ATOM  10287  N   VAL F 126     -20.033  99.818  30.560  1.00 81.82           N  
ATOM  10288  CA  VAL F 126     -21.053  99.007  29.918  1.00 81.39           C  
ATOM  10289  C   VAL F 126     -20.517  97.583  29.836  1.00 80.95           C  
ATOM  10290  O   VAL F 126     -19.379  97.351  29.413  1.00 80.77           O  
ATOM  10291  CB  VAL F 126     -21.481  99.543  28.529  1.00 81.23           C  
ATOM  10292  CG1 VAL F 126     -22.086 100.925  28.673  1.00 81.08           C  
ATOM  10293  CG2 VAL F 126     -20.318  99.571  27.574  1.00 81.98           C  
ATOM  10294  N   LYS F 127     -21.337  96.637  30.279  1.00 80.37           N  
ATOM  10295  CA  LYS F 127     -20.929  95.244  30.375  1.00 79.85           C  
ATOM  10296  C   LYS F 127     -21.133  94.503  29.040  1.00 79.21           C  
ATOM  10297  O   LYS F 127     -20.405  93.545  28.749  1.00 79.63           O  
ATOM  10298  CB  LYS F 127     -21.670  94.567  31.536  1.00 80.02           C  
ATOM  10299  CG  LYS F 127     -21.458  95.258  32.891  1.00 79.88           C  
ATOM  10300  N   LYS F 128     -22.097  94.947  28.230  1.00 78.05           N  
ATOM  10301  CA  LYS F 128     -22.220  94.464  26.852  1.00 77.31           C  
ATOM  10302  C   LYS F 128     -21.126  95.078  25.977  1.00 76.80           C  
ATOM  10303  O   LYS F 128     -20.616  96.151  26.289  1.00 76.67           O  
ATOM  10304  CB  LYS F 128     -23.574  94.826  26.254  1.00 77.30           C  
ATOM  10305  CG  LYS F 128     -24.742  94.046  26.809  1.00 77.03           C  
ATOM  10306  CD  LYS F 128     -26.067  94.675  26.424  1.00 76.04           C  
ATOM  10307  CE  LYS F 128     -27.203  94.040  27.194  1.00 75.72           C  
ATOM  10308  NZ  LYS F 128     -28.517  94.669  26.876  1.00 75.00           N  
ATOM  10309  N   PRO F 129     -20.761  94.401  24.873  1.00 76.15           N  
ATOM  10310  CA  PRO F 129     -19.747  94.945  23.955  1.00 75.75           C  
ATOM  10311  C   PRO F 129     -20.197  96.162  23.146  1.00 75.36           C  
ATOM  10312  O   PRO F 129     -21.290  96.157  22.569  1.00 75.66           O  
ATOM  10313  CB  PRO F 129     -19.459  93.771  23.006  1.00 75.67           C  
ATOM  10314  CG  PRO F 129     -20.046  92.560  23.685  1.00 76.01           C  
ATOM  10315  CD  PRO F 129     -21.223  93.073  24.439  1.00 75.99           C  
ATOM  10316  N   VAL F 130     -19.343  97.182  23.098  1.00 74.68           N  
ATOM  10317  CA  VAL F 130     -19.556  98.362  22.267  1.00 74.11           C  
ATOM  10318  C   VAL F 130     -18.532  98.354  21.143  1.00 73.86           C  
ATOM  10319  O   VAL F 130     -17.370  98.042  21.387  1.00 74.39           O  
ATOM  10320  CB  VAL F 130     -19.374  99.652  23.086  1.00 74.01           C  
ATOM  10321  CG1 VAL F 130     -19.624 100.881  22.236  1.00 72.97           C  
ATOM  10322  CG2 VAL F 130     -20.294  99.641  24.279  1.00 74.45           C  
ATOM  10323  N   ILE F 131     -18.953  98.715  19.932  1.00 73.47           N  
ATOM  10324  CA  ILE F 131     -18.062  98.797  18.764  1.00 73.19           C  
ATOM  10325  C   ILE F 131     -18.036 100.204  18.155  1.00 72.73           C  
ATOM  10326  O   ILE F 131     -19.062 100.699  17.664  1.00 72.49           O  
ATOM  10327  CB  ILE F 131     -18.524  97.861  17.626  1.00 73.40           C  
ATOM  10328  CG1 ILE F 131     -18.550  96.405  18.081  1.00 73.80           C  
ATOM  10329  CG2 ILE F 131     -17.630  98.017  16.399  1.00 73.22           C  
ATOM  10330  CD1 ILE F 131     -19.168  95.481  17.039  1.00 74.64           C  
ATOM  10331  N   ALA F 132     -16.864 100.830  18.148  1.00 71.95           N  
ATOM  10332  CA  ALA F 132     -16.718 102.131  17.504  1.00 71.43           C  
ATOM  10333  C   ALA F 132     -16.660 101.945  15.996  1.00 71.06           C  
ATOM  10334  O   ALA F 132     -15.919 101.105  15.499  1.00 71.27           O  
ATOM  10335  CB  ALA F 132     -15.473 102.841  18.003  1.00 71.21           C  
ATOM  10336  N   ALA F 133     -17.461 102.715  15.270  1.00 70.73           N  
ATOM  10337  CA  ALA F 133     -17.404 102.736  13.812  1.00 70.54           C  
ATOM  10338  C   ALA F 133     -17.013 104.142  13.376  1.00 70.38           C  
ATOM  10339  O   ALA F 133     -17.866 105.030  13.253  1.00 70.46           O  
ATOM  10340  CB  ALA F 133     -18.740 102.331  13.211  1.00 70.43           C  
ATOM  10341  N   VAL F 134     -15.716 104.324  13.141  1.00 70.16           N  
ATOM  10342  CA  VAL F 134     -15.131 105.637  12.898  1.00 70.19           C  
ATOM  10343  C   VAL F 134     -14.980 105.960  11.410  1.00 70.55           C  
ATOM  10344  O   VAL F 134     -14.133 105.382  10.729  1.00 70.83           O  
ATOM  10345  CB  VAL F 134     -13.739 105.718  13.547  1.00 70.27           C  
ATOM  10346  CG1 VAL F 134     -13.130 107.105  13.327  1.00 69.54           C  
ATOM  10347  CG2 VAL F 134     -13.829 105.350  15.035  1.00 69.12           C  
ATOM  10348  N   ASN F 135     -15.817 106.870  10.915  1.00 70.77           N  
ATOM  10349  CA  ASN F 135     -15.620 107.496   9.612  1.00 70.98           C  
ATOM  10350  C   ASN F 135     -15.048 108.887   9.833  1.00 71.27           C  
ATOM  10351  O   ASN F 135     -15.458 109.586  10.754  1.00 71.19           O  
ATOM  10352  CB  ASN F 135     -16.946 107.599   8.844  1.00 71.13           C  
ATOM  10353  CG  ASN F 135     -17.036 106.630   7.662  1.00 71.01           C  
ATOM  10354  OD1 ASN F 135     -16.023 106.133   7.160  1.00 71.29           O  
ATOM  10355  ND2 ASN F 135     -18.259 106.377   7.203  1.00 68.88           N  
ATOM  10356  N   GLY F 136     -14.095 109.282   8.996  1.00 71.80           N  
ATOM  10357  CA  GLY F 136     -13.495 110.613   9.085  1.00 72.26           C  
ATOM  10358  C   GLY F 136     -12.696 110.846  10.358  1.00 72.62           C  
ATOM  10359  O   GLY F 136     -12.063 109.931  10.871  1.00 72.51           O  
ATOM  10360  N   TYR F 137     -12.760 112.068  10.884  1.00 73.30           N  
ATOM  10361  CA  TYR F 137     -11.941 112.468  12.038  1.00 73.83           C  
ATOM  10362  C   TYR F 137     -12.379 111.832  13.368  1.00 73.88           C  
ATOM  10363  O   TYR F 137     -13.549 111.886  13.737  1.00 74.27           O  
ATOM  10364  CB  TYR F 137     -11.942 113.993  12.205  1.00 74.07           C  
ATOM  10365  CG  TYR F 137     -11.670 114.770  10.933  1.00 74.66           C  
ATOM  10366  CD1 TYR F 137     -10.587 114.457  10.114  1.00 74.86           C  
ATOM  10367  CD2 TYR F 137     -12.499 115.818  10.549  1.00 74.98           C  
ATOM  10368  CE1 TYR F 137     -10.344 115.173   8.940  1.00 75.13           C  
ATOM  10369  CE2 TYR F 137     -12.264 116.536   9.384  1.00 75.12           C  
ATOM  10370  CZ  TYR F 137     -11.184 116.214   8.581  1.00 75.15           C  
ATOM  10371  OH  TYR F 137     -10.953 116.931   7.419  1.00 74.79           O  
ATOM  10372  N   ALA F 138     -11.429 111.211  14.059  1.00 73.97           N  
ATOM  10373  CA  ALA F 138     -11.557 110.885  15.482  1.00 74.10           C  
ATOM  10374  C   ALA F 138     -10.365 111.523  16.205  1.00 74.30           C  
ATOM  10375  O   ALA F 138      -9.305 110.900  16.349  1.00 73.77           O  
ATOM  10376  CB  ALA F 138     -11.589 109.367  15.708  1.00 73.74           C  
ATOM  10377  N   PHE F 139     -10.543 112.780  16.620  1.00 74.77           N  
ATOM  10378  CA  PHE F 139      -9.495 113.553  17.285  1.00 75.46           C  
ATOM  10379  C   PHE F 139      -9.820 113.842  18.753  1.00 76.04           C  
ATOM  10380  O   PHE F 139     -10.983 113.885  19.150  1.00 76.42           O  
ATOM  10381  CB  PHE F 139      -9.253 114.883  16.560  1.00 75.74           C  
ATOM  10382  CG  PHE F 139      -8.910 114.746  15.091  1.00 75.65           C  
ATOM  10383  CD1 PHE F 139      -8.267 113.617  14.596  1.00 75.15           C  
ATOM  10384  CD2 PHE F 139      -9.210 115.780  14.212  1.00 76.32           C  
ATOM  10385  CE1 PHE F 139      -7.952 113.508  13.264  1.00 75.46           C  
ATOM  10386  CE2 PHE F 139      -8.896 115.686  12.860  1.00 76.52           C  
ATOM  10387  CZ  PHE F 139      -8.263 114.549  12.386  1.00 76.64           C  
ATOM  10388  N   GLY F 140      -8.775 114.033  19.553  1.00 76.63           N  
ATOM  10389  CA  GLY F 140      -8.910 114.387  20.964  1.00 76.83           C  
ATOM  10390  C   GLY F 140      -9.761 113.382  21.710  1.00 77.05           C  
ATOM  10391  O   GLY F 140      -9.469 112.196  21.719  1.00 77.05           O  
ATOM  10392  N   GLY F 141     -10.827 113.869  22.327  1.00 77.52           N  
ATOM  10393  CA  GLY F 141     -11.808 113.009  22.973  1.00 77.78           C  
ATOM  10394  C   GLY F 141     -12.450 112.032  22.001  1.00 78.09           C  
ATOM  10395  O   GLY F 141     -12.777 110.905  22.378  1.00 78.49           O  
ATOM  10396  N   GLY F 142     -12.630 112.449  20.749  1.00 77.90           N  
ATOM  10397  CA  GLY F 142     -13.191 111.562  19.742  1.00 77.93           C  
ATOM  10398  C   GLY F 142     -12.447 110.240  19.743  1.00 78.08           C  
ATOM  10399  O   GLY F 142     -13.046 109.165  19.844  1.00 78.16           O  
ATOM  10400  N   CYS F 143     -11.127 110.332  19.654  1.00 77.98           N  
ATOM  10401  CA  CYS F 143     -10.275 109.159  19.623  1.00 77.95           C  
ATOM  10402  C   CYS F 143     -10.353 108.389  20.935  1.00 78.18           C  
ATOM  10403  O   CYS F 143     -10.447 107.158  20.947  1.00 78.23           O  
ATOM  10404  CB  CYS F 143      -8.840 109.598  19.375  1.00 77.94           C  
ATOM  10405  SG  CYS F 143      -7.694 108.251  19.361  1.00 77.86           S  
ATOM  10406  N   GLU F 144     -10.300 109.127  22.040  1.00 78.34           N  
ATOM  10407  CA  GLU F 144     -10.411 108.542  23.376  1.00 78.54           C  
ATOM  10408  C   GLU F 144     -11.714 107.753  23.513  1.00 78.15           C  
ATOM  10409  O   GLU F 144     -11.728 106.631  24.007  1.00 78.01           O  
ATOM  10410  CB  GLU F 144     -10.312 109.643  24.437  1.00 78.36           C  
ATOM  10411  CG  GLU F 144      -8.945 110.337  24.418  1.00 79.01           C  
ATOM  10412  CD  GLU F 144      -8.731 111.292  25.574  1.00 79.64           C  
ATOM  10413  OE1 GLU F 144      -9.512 112.269  25.710  1.00 81.61           O  
ATOM  10414  OE2 GLU F 144      -7.769 111.070  26.349  1.00 80.88           O  
ATOM  10415  N   LEU F 145     -12.795 108.341  23.021  1.00 78.02           N  
ATOM  10416  CA  LEU F 145     -14.108 107.716  23.050  1.00 78.04           C  
ATOM  10417  C   LEU F 145     -14.100 106.398  22.274  1.00 77.95           C  
ATOM  10418  O   LEU F 145     -14.698 105.405  22.709  1.00 78.01           O  
ATOM  10419  CB  LEU F 145     -15.152 108.675  22.460  1.00 78.16           C  
ATOM  10420  CG  LEU F 145     -16.526 108.688  23.111  1.00 78.50           C  
ATOM  10421  CD1 LEU F 145     -16.414 109.230  24.540  1.00 78.20           C  
ATOM  10422  CD2 LEU F 145     -17.513 109.517  22.267  1.00 77.97           C  
ATOM  10423  N   ALA F 146     -13.422 106.392  21.128  1.00 77.77           N  
ATOM  10424  CA  ALA F 146     -13.327 105.192  20.301  1.00 77.58           C  
ATOM  10425  C   ALA F 146     -12.516 104.140  21.028  1.00 77.70           C  
ATOM  10426  O   ALA F 146     -12.930 102.986  21.100  1.00 77.79           O  
ATOM  10427  CB  ALA F 146     -12.695 105.506  18.973  1.00 77.45           C  
ATOM  10428  N   MET F 147     -11.370 104.552  21.576  1.00 77.75           N  
ATOM  10429  CA  MET F 147     -10.480 103.646  22.315  1.00 77.63           C  
ATOM  10430  C   MET F 147     -11.151 103.035  23.540  1.00 77.51           C  
ATOM  10431  O   MET F 147     -10.879 101.894  23.884  1.00 77.34           O  
ATOM  10432  CB  MET F 147      -9.195 104.365  22.721  1.00 77.51           C  
ATOM  10433  CG  MET F 147      -8.252 104.596  21.549  1.00 78.20           C  
ATOM  10434  SD  MET F 147      -6.617 105.216  21.995  1.00 77.96           S  
ATOM  10435  CE  MET F 147      -7.051 106.868  22.541  1.00 78.23           C  
ATOM  10436  N   MET F 148     -12.034 103.789  24.192  1.00 77.65           N  
ATOM  10437  CA  MET F 148     -12.829 103.254  25.293  1.00 77.77           C  
ATOM  10438  C   MET F 148     -13.718 102.098  24.840  1.00 77.59           C  
ATOM  10439  O   MET F 148     -14.123 101.294  25.656  1.00 77.79           O  
ATOM  10440  CB  MET F 148     -13.702 104.337  25.925  1.00 77.73           C  
ATOM  10441  CG  MET F 148     -12.982 105.286  26.864  1.00 78.27           C  
ATOM  10442  SD  MET F 148     -14.070 106.610  27.508  1.00 79.04           S  
ATOM  10443  CE  MET F 148     -13.009 107.337  28.760  1.00 78.83           C  
ATOM  10444  N   CYS F 149     -14.036 102.009  23.551  1.00 77.60           N  
ATOM  10445  CA  CYS F 149     -14.828 100.879  23.054  1.00 77.55           C  
ATOM  10446  C   CYS F 149     -13.974  99.615  22.891  1.00 77.68           C  
ATOM  10447  O   CYS F 149     -12.747  99.672  22.739  1.00 77.66           O  
ATOM  10448  CB  CYS F 149     -15.535 101.209  21.726  1.00 77.54           C  
ATOM  10449  SG  CYS F 149     -16.614 102.673  21.752  1.00 76.52           S  
ATOM  10450  N   ASP F 150     -14.656  98.475  22.897  1.00 77.70           N  
ATOM  10451  CA  ASP F 150     -14.012  97.176  22.785  1.00 77.78           C  
ATOM  10452  C   ASP F 150     -13.379  96.975  21.408  1.00 77.57           C  
ATOM  10453  O   ASP F 150     -12.199  96.624  21.304  1.00 77.36           O  
ATOM  10454  CB  ASP F 150     -15.040  96.081  23.048  1.00 77.98           C  
ATOM  10455  CG  ASP F 150     -15.702  96.229  24.409  1.00 78.73           C  
ATOM  10456  OD1 ASP F 150     -15.025  95.958  25.433  1.00 79.37           O  
ATOM  10457  OD2 ASP F 150     -16.887  96.632  24.452  1.00 78.30           O  
ATOM  10458  N   ILE F 151     -14.167  97.214  20.358  1.00 76.93           N  
ATOM  10459  CA  ILE F 151     -13.722  97.001  18.981  1.00 76.41           C  
ATOM  10460  C   ILE F 151     -13.861  98.281  18.134  1.00 76.17           C  
ATOM  10461  O   ILE F 151     -14.909  98.934  18.128  1.00 76.08           O  
ATOM  10462  CB  ILE F 151     -14.533  95.863  18.330  1.00 76.28           C  
ATOM  10463  CG1 ILE F 151     -14.767  94.733  19.344  1.00 75.76           C  
ATOM  10464  CG2 ILE F 151     -13.843  95.369  17.063  1.00 76.36           C  
ATOM  10465  CD1 ILE F 151     -15.362  93.483  18.760  1.00 75.09           C  
ATOM  10466  N   ILE F 152     -12.792  98.645  17.433  1.00 75.74           N  
ATOM  10467  CA  ILE F 152     -12.837  99.773  16.525  1.00 75.44           C  
ATOM  10468  C   ILE F 152     -12.779  99.266  15.095  1.00 75.46           C  
ATOM  10469  O   ILE F 152     -11.849  98.543  14.723  1.00 75.35           O  
ATOM  10470  CB  ILE F 152     -11.663 100.743  16.736  1.00 75.32           C  
ATOM  10471  CG1 ILE F 152     -11.626 101.249  18.170  1.00 74.71           C  
ATOM  10472  CG2 ILE F 152     -11.785 101.928  15.790  1.00 74.58           C  
ATOM  10473  CD1 ILE F 152     -10.550 102.286  18.404  1.00 74.26           C  
ATOM  10474  N   TYR F 153     -13.790  99.644  14.315  1.00 75.43           N  
ATOM  10475  CA  TYR F 153     -13.801  99.485  12.865  1.00 75.33           C  
ATOM  10476  C   TYR F 153     -13.593 100.887  12.306  1.00 75.37           C  
ATOM  10477  O   TYR F 153     -14.228 101.829  12.768  1.00 75.17           O  
ATOM  10478  CB  TYR F 153     -15.166  98.965  12.406  1.00 75.73           C  
ATOM  10479  CG  TYR F 153     -15.344  97.460  12.321  1.00 75.63           C  
ATOM  10480  CD1 TYR F 153     -14.668  96.599  13.162  1.00 76.20           C  
ATOM  10481  CD2 TYR F 153     -16.236  96.909  11.405  1.00 76.46           C  
ATOM  10482  CE1 TYR F 153     -14.845  95.219  13.082  1.00 76.59           C  
ATOM  10483  CE2 TYR F 153     -16.427  95.533  11.319  1.00 76.93           C  
ATOM  10484  CZ  TYR F 153     -15.731  94.690  12.166  1.00 76.69           C  
ATOM  10485  OH  TYR F 153     -15.914  93.322  12.085  1.00 76.14           O  
ATOM  10486  N   ALA F 154     -12.722 101.035  11.312  1.00 75.52           N  
ATOM  10487  CA  ALA F 154     -12.452 102.352  10.707  1.00 75.60           C  
ATOM  10488  C   ALA F 154     -12.801 102.401   9.215  1.00 75.55           C  
ATOM  10489  O   ALA F 154     -12.552 101.449   8.477  1.00 75.51           O  
ATOM  10490  CB  ALA F 154     -10.994 102.732  10.913  1.00 75.52           C  
ATOM  10491  N   GLY F 155     -13.383 103.518   8.776  1.00 75.60           N  
ATOM  10492  CA  GLY F 155     -13.574 103.784   7.348  1.00 75.41           C  
ATOM  10493  C   GLY F 155     -12.246 104.062   6.662  1.00 75.46           C  
ATOM  10494  O   GLY F 155     -11.225 104.263   7.326  1.00 75.46           O  
ATOM  10495  N   GLU F 156     -12.259 104.074   5.332  1.00 75.60           N  
ATOM  10496  CA  GLU F 156     -11.039 104.279   4.528  1.00 75.66           C  
ATOM  10497  C   GLU F 156     -10.375 105.641   4.762  1.00 75.44           C  
ATOM  10498  O   GLU F 156      -9.141 105.740   4.782  1.00 75.34           O  
ATOM  10499  CB  GLU F 156     -11.322 104.079   3.023  1.00 75.74           C  
ATOM  10500  CG  GLU F 156     -11.072 102.648   2.533  1.00 76.17           C  
ATOM  10501  N   LYS F 157     -11.193 106.674   4.952  1.00 75.25           N  
ATOM  10502  CA  LYS F 157     -10.696 108.048   5.095  1.00 75.37           C  
ATOM  10503  C   LYS F 157     -10.748 108.507   6.556  1.00 75.23           C  
ATOM  10504  O   LYS F 157     -10.840 109.707   6.839  1.00 75.19           O  
ATOM  10505  CB  LYS F 157     -11.485 109.004   4.177  1.00 75.12           C  
ATOM  10506  N   ALA F 158     -10.660 107.547   7.476  1.00 75.24           N  
ATOM  10507  CA  ALA F 158     -10.723 107.841   8.908  1.00 75.41           C  
ATOM  10508  C   ALA F 158      -9.356 108.298   9.391  1.00 75.47           C  
ATOM  10509  O   ALA F 158      -8.340 107.836   8.890  1.00 75.40           O  
ATOM  10510  CB  ALA F 158     -11.208 106.626   9.699  1.00 74.91           C  
ATOM  10511  N   GLN F 159      -9.341 109.216  10.350  1.00 75.80           N  
ATOM  10512  CA  GLN F 159      -8.096 109.780  10.851  1.00 76.33           C  
ATOM  10513  C   GLN F 159      -8.114 109.876  12.367  1.00 76.65           C  
ATOM  10514  O   GLN F 159      -9.127 110.276  12.952  1.00 76.66           O  
ATOM  10515  CB  GLN F 159      -7.849 111.156  10.235  1.00 76.47           C  
ATOM  10516  CG  GLN F 159      -7.152 111.083   8.894  1.00 77.13           C  
ATOM  10517  CD  GLN F 159      -7.115 112.414   8.183  1.00 77.85           C  
ATOM  10518  OE1 GLN F 159      -8.153 112.963   7.829  1.00 78.02           O  
ATOM  10519  NE2 GLN F 159      -5.911 112.931   7.952  1.00 78.99           N  
ATOM  10520  N   PHE F 160      -6.991 109.499  12.984  1.00 76.74           N  
ATOM  10521  CA  PHE F 160      -6.847 109.487  14.435  1.00 76.89           C  
ATOM  10522  C   PHE F 160      -5.728 110.421  14.876  1.00 77.03           C  
ATOM  10523  O   PHE F 160      -4.649 110.430  14.286  1.00 76.78           O  
ATOM  10524  CB  PHE F 160      -6.561 108.070  14.938  1.00 76.81           C  
ATOM  10525  CG  PHE F 160      -7.674 107.101  14.667  1.00 77.02           C  
ATOM  10526  CD1 PHE F 160      -7.824 106.531  13.410  1.00 77.15           C  
ATOM  10527  CD2 PHE F 160      -8.579 106.764  15.664  1.00 76.80           C  
ATOM  10528  CE1 PHE F 160      -8.855 105.636  13.149  1.00 76.82           C  
ATOM  10529  CE2 PHE F 160      -9.608 105.867  15.411  1.00 76.59           C  
ATOM  10530  CZ  PHE F 160      -9.745 105.304  14.154  1.00 76.51           C  
ATOM  10531  N   ALA F 161      -6.006 111.203  15.918  1.00 77.35           N  
ATOM  10532  CA  ALA F 161      -5.010 112.073  16.534  1.00 77.62           C  
ATOM  10533  C   ALA F 161      -5.374 112.359  17.991  1.00 77.86           C  
ATOM  10534  O   ALA F 161      -6.545 112.250  18.384  1.00 78.01           O  
ATOM  10535  CB  ALA F 161      -4.896 113.382  15.757  1.00 77.75           C  
ATOM  10536  N   GLN F 162      -4.357 112.709  18.780  1.00 77.82           N  
ATOM  10537  CA  GLN F 162      -4.539 113.299  20.106  1.00 77.86           C  
ATOM  10538  C   GLN F 162      -3.818 114.644  20.089  1.00 77.70           C  
ATOM  10539  O   GLN F 162      -2.660 114.736  20.505  1.00 77.96           O  
ATOM  10540  CB  GLN F 162      -3.959 112.398  21.191  1.00 78.04           C  
ATOM  10541  CG  GLN F 162      -4.664 111.049  21.350  1.00 79.01           C  
ATOM  10542  CD  GLN F 162      -6.016 111.136  22.045  1.00 80.49           C  
ATOM  10543  OE1 GLN F 162      -6.798 110.185  22.009  1.00 81.51           O  
ATOM  10544  NE2 GLN F 162      -6.297 112.273  22.682  1.00 81.49           N  
ATOM  10545  N   PRO F 163      -4.492 115.693  19.582  1.00 77.46           N  
ATOM  10546  CA  PRO F 163      -3.886 116.999  19.398  1.00 77.42           C  
ATOM  10547  C   PRO F 163      -4.016 117.950  20.586  1.00 77.33           C  
ATOM  10548  O   PRO F 163      -3.816 119.154  20.412  1.00 77.40           O  
ATOM  10549  CB  PRO F 163      -4.672 117.552  18.209  1.00 77.58           C  
ATOM  10550  CG  PRO F 163      -6.050 117.028  18.431  1.00 77.64           C  
ATOM  10551  CD  PRO F 163      -5.891 115.690  19.117  1.00 77.42           C  
ATOM  10552  N   GLU F 164      -4.321 117.433  21.774  1.00 77.27           N  
ATOM  10553  CA  GLU F 164      -4.477 118.283  22.969  1.00 77.34           C  
ATOM  10554  C   GLU F 164      -3.218 119.082  23.328  1.00 76.56           C  
ATOM  10555  O   GLU F 164      -3.318 120.138  23.934  1.00 76.66           O  
ATOM  10556  CB  GLU F 164      -4.922 117.459  24.185  1.00 77.69           C  
ATOM  10557  CG  GLU F 164      -6.352 116.898  24.089  1.00 79.40           C  
ATOM  10558  CD  GLU F 164      -6.414 115.482  23.506  1.00 81.91           C  
ATOM  10559  OE1 GLU F 164      -5.555 115.135  22.659  1.00 83.46           O  
ATOM  10560  OE2 GLU F 164      -7.326 114.714  23.897  1.00 83.71           O  
ATOM  10561  N   ILE F 165      -2.045 118.584  22.953  1.00 75.89           N  
ATOM  10562  CA  ILE F 165      -0.785 119.272  23.230  1.00 75.44           C  
ATOM  10563  C   ILE F 165      -0.741 120.660  22.592  1.00 75.13           C  
ATOM  10564  O   ILE F 165      -0.208 121.598  23.187  1.00 74.86           O  
ATOM  10565  CB  ILE F 165       0.430 118.426  22.747  1.00 75.42           C  
ATOM  10566  CG1 ILE F 165       1.749 118.967  23.315  1.00 75.28           C  
ATOM  10567  CG2 ILE F 165       0.491 118.382  21.222  1.00 75.68           C  
ATOM  10568  CD1 ILE F 165       1.958 118.668  24.771  1.00 74.45           C  
ATOM  10569  N   LEU F 166      -1.313 120.769  21.389  1.00 74.91           N  
ATOM  10570  CA  LEU F 166      -1.337 122.008  20.606  1.00 74.44           C  
ATOM  10571  C   LEU F 166      -2.108 123.138  21.281  1.00 74.45           C  
ATOM  10572  O   LEU F 166      -1.797 124.305  21.061  1.00 74.76           O  
ATOM  10573  CB  LEU F 166      -1.967 121.761  19.233  1.00 74.23           C  
ATOM  10574  CG  LEU F 166      -1.243 120.860  18.233  1.00 74.26           C  
ATOM  10575  CD1 LEU F 166      -2.109 120.683  16.979  1.00 73.85           C  
ATOM  10576  CD2 LEU F 166       0.127 121.420  17.862  1.00 73.18           C  
ATOM  10577  N   ILE F 167      -3.124 122.790  22.071  1.00 74.16           N  
ATOM  10578  CA  ILE F 167      -3.920 123.776  22.809  1.00 73.90           C  
ATOM  10579  C   ILE F 167      -3.520 123.839  24.293  1.00 73.87           C  
ATOM  10580  O   ILE F 167      -4.291 124.301  25.134  1.00 73.75           O  
ATOM  10581  CB  ILE F 167      -5.450 123.512  22.644  1.00 73.94           C  
ATOM  10582  CG1 ILE F 167      -5.896 122.233  23.369  1.00 73.80           C  
ATOM  10583  CG2 ILE F 167      -5.804 123.412  21.161  1.00 73.77           C  
ATOM  10584  CD1 ILE F 167      -7.398 121.976  23.297  1.00 73.72           C  
ATOM  10585  N   GLY F 168      -2.317 123.362  24.605  1.00 73.94           N  
ATOM  10586  CA  GLY F 168      -1.739 123.493  25.939  1.00 73.88           C  
ATOM  10587  C   GLY F 168      -2.166 122.492  26.999  1.00 73.91           C  
ATOM  10588  O   GLY F 168      -1.986 122.755  28.177  1.00 73.83           O  
ATOM  10589  N   THR F 169      -2.726 121.351  26.608  1.00 74.11           N  
ATOM  10590  CA  THR F 169      -3.061 120.295  27.585  1.00 74.55           C  
ATOM  10591  C   THR F 169      -2.445 118.963  27.194  1.00 74.61           C  
ATOM  10592  O   THR F 169      -1.654 118.873  26.262  1.00 74.55           O  
ATOM  10593  CB  THR F 169      -4.599 120.034  27.718  1.00 74.53           C  
ATOM  10594  OG1 THR F 169      -5.336 121.146  27.217  1.00 75.47           O  
ATOM  10595  CG2 THR F 169      -4.984 119.775  29.172  1.00 74.17           C  
ATOM  10596  N   ILE F 170      -2.824 117.936  27.942  1.00 74.73           N  
ATOM  10597  CA  ILE F 170      -2.580 116.563  27.577  1.00 74.86           C  
ATOM  10598  C   ILE F 170      -3.946 115.868  27.493  1.00 75.33           C  
ATOM  10599  O   ILE F 170      -4.942 116.386  28.005  1.00 75.05           O  
ATOM  10600  CB  ILE F 170      -1.666 115.885  28.621  1.00 74.81           C  
ATOM  10601  CG1 ILE F 170      -2.429 115.568  29.911  1.00 74.14           C  
ATOM  10602  CG2 ILE F 170      -0.469 116.784  28.929  1.00 73.99           C  
ATOM  10603  CD1 ILE F 170      -1.568 115.004  30.968  1.00 74.52           C  
ATOM  10604  N   PRO F 171      -4.005 114.706  26.824  1.00 75.94           N  
ATOM  10605  CA  PRO F 171      -5.236 113.896  26.832  1.00 76.30           C  
ATOM  10606  C   PRO F 171      -5.652 113.491  28.251  1.00 76.76           C  
ATOM  10607  O   PRO F 171      -4.796 113.101  29.040  1.00 77.35           O  
ATOM  10608  CB  PRO F 171      -4.848 112.661  26.014  1.00 76.20           C  
ATOM  10609  CG  PRO F 171      -3.672 113.103  25.164  1.00 75.86           C  
ATOM  10610  CD  PRO F 171      -2.939 114.108  25.992  1.00 75.70           C  
ATOM  10611  N   GLY F 172      -6.943 113.579  28.570  1.00 76.99           N  
ATOM  10612  CA  GLY F 172      -7.432 113.276  29.920  1.00 77.25           C  
ATOM  10613  C   GLY F 172      -8.571 112.263  30.008  1.00 77.54           C  
ATOM  10614  O   GLY F 172      -9.331 112.273  30.976  1.00 77.96           O  
ATOM  10615  N   ALA F 173      -8.697 111.394  29.007  1.00 77.67           N  
ATOM  10616  CA  ALA F 173      -9.699 110.313  29.011  1.00 77.73           C  
ATOM  10617  C   ALA F 173      -9.049 108.990  28.557  1.00 77.84           C  
ATOM  10618  O   ALA F 173      -9.555 108.279  27.694  1.00 77.45           O  
ATOM  10619  CB  ALA F 173     -10.890 110.686  28.119  1.00 77.64           C  
ATOM  10620  N   GLY F 174      -7.907 108.678  29.159  1.00 78.45           N  
ATOM  10621  CA  GLY F 174      -7.141 107.492  28.812  1.00 78.81           C  
ATOM  10622  C   GLY F 174      -6.406 107.618  27.494  1.00 79.31           C  
ATOM  10623  O   GLY F 174      -5.945 106.617  26.940  1.00 79.77           O  
ATOM  10624  N   GLY F 175      -6.266 108.842  26.993  1.00 79.56           N  
ATOM  10625  CA  GLY F 175      -5.620 109.061  25.704  1.00 79.61           C  
ATOM  10626  C   GLY F 175      -4.161 108.653  25.655  1.00 79.56           C  
ATOM  10627  O   GLY F 175      -3.696 108.156  24.640  1.00 80.38           O  
ATOM  10628  N   THR F 176      -3.420 108.872  26.733  1.00 79.29           N  
ATOM  10629  CA  THR F 176      -2.020 108.456  26.761  1.00 78.97           C  
ATOM  10630  C   THR F 176      -1.926 106.982  27.141  1.00 78.91           C  
ATOM  10631  O   THR F 176      -0.924 106.329  26.867  1.00 79.81           O  
ATOM  10632  CB  THR F 176      -1.179 109.298  27.752  1.00 78.96           C  
ATOM  10633  OG1 THR F 176      -1.674 109.125  29.081  1.00 78.09           O  
ATOM  10634  CG2 THR F 176      -1.216 110.788  27.382  1.00 78.68           C  
ATOM  10635  N   GLN F 177      -2.980 106.452  27.754  1.00 78.15           N  
ATOM  10636  CA  GLN F 177      -2.938 105.130  28.337  1.00 77.23           C  
ATOM  10637  C   GLN F 177      -3.410 104.055  27.378  1.00 76.69           C  
ATOM  10638  O   GLN F 177      -2.702 103.075  27.168  1.00 76.70           O  
ATOM  10639  CB  GLN F 177      -3.758 105.114  29.614  1.00 77.11           C  
ATOM  10640  CG  GLN F 177      -3.318 106.164  30.614  1.00 77.11           C  
ATOM  10641  CD  GLN F 177      -1.885 105.992  31.068  1.00 76.49           C  
ATOM  10642  OE1 GLN F 177      -1.482 104.901  31.452  1.00 78.13           O  
ATOM  10643  NE2 GLN F 177      -1.112 107.071  31.041  1.00 75.93           N  
ATOM  10644  N   ARG F 178      -4.586 104.227  26.788  1.00 76.10           N  
ATOM  10645  CA  ARG F 178      -5.102 103.227  25.854  1.00 75.94           C  
ATOM  10646  C   ARG F 178      -4.367 103.266  24.524  1.00 75.82           C  
ATOM  10647  O   ARG F 178      -4.206 102.232  23.882  1.00 76.05           O  
ATOM  10648  CB  ARG F 178      -6.604 103.387  25.628  1.00 76.05           C  
ATOM  10649  CG  ARG F 178      -7.412 103.229  26.906  1.00 76.41           C  
ATOM  10650  CD  ARG F 178      -8.871 102.910  26.663  1.00 76.37           C  
ATOM  10651  NE  ARG F 178      -9.511 102.569  27.931  1.00 77.03           N  
ATOM  10652  CZ  ARG F 178      -9.892 103.446  28.860  1.00 76.36           C  
ATOM  10653  NH1 ARG F 178      -9.737 104.755  28.684  1.00 76.33           N  
ATOM  10654  NH2 ARG F 178     -10.436 103.005  29.983  1.00 76.25           N  
ATOM  10655  N   LEU F 179      -3.911 104.448  24.116  1.00 75.57           N  
ATOM  10656  CA  LEU F 179      -3.190 104.577  22.858  1.00 75.26           C  
ATOM  10657  C   LEU F 179      -1.858 103.858  22.937  1.00 75.12           C  
ATOM  10658  O   LEU F 179      -1.537 103.054  22.078  1.00 75.16           O  
ATOM  10659  CB  LEU F 179      -2.967 106.047  22.499  1.00 75.37           C  
ATOM  10660  CG  LEU F 179      -2.257 106.340  21.168  1.00 74.95           C  
ATOM  10661  CD1 LEU F 179      -3.049 105.791  19.974  1.00 75.13           C  
ATOM  10662  CD2 LEU F 179      -2.057 107.824  21.032  1.00 73.95           C  
ATOM  10663  N   THR F 180      -1.086 104.143  23.974  1.00 74.92           N  
ATOM  10664  CA  THR F 180       0.227 103.530  24.121  1.00 74.97           C  
ATOM  10665  C   THR F 180       0.164 101.998  24.116  1.00 75.19           C  
ATOM  10666  O   THR F 180       0.943 101.340  23.439  1.00 75.18           O  
ATOM  10667  CB  THR F 180       0.899 104.033  25.405  1.00 75.04           C  
ATOM  10668  OG1 THR F 180       0.881 105.465  25.391  1.00 74.01           O  
ATOM  10669  CG2 THR F 180       2.331 103.523  25.512  1.00 73.52           C  
ATOM  10670  N   ARG F 181      -0.778 101.445  24.869  1.00 75.61           N  
ATOM  10671  CA  ARG F 181      -0.970  99.994  24.954  1.00 75.67           C  
ATOM  10672  C   ARG F 181      -1.462  99.355  23.644  1.00 75.68           C  
ATOM  10673  O   ARG F 181      -1.230  98.165  23.401  1.00 76.20           O  
ATOM  10674  CB  ARG F 181      -1.965  99.663  26.067  1.00 75.62           C  
ATOM  10675  CG  ARG F 181      -1.484 100.006  27.459  1.00 75.98           C  
ATOM  10676  CD  ARG F 181      -2.600  99.801  28.452  1.00 76.92           C  
ATOM  10677  NE  ARG F 181      -2.142  99.726  29.839  1.00 78.20           N  
ATOM  10678  CZ  ARG F 181      -1.855 100.772  30.616  1.00 78.62           C  
ATOM  10679  NH1 ARG F 181      -1.948 102.014  30.156  1.00 79.82           N  
ATOM  10680  NH2 ARG F 181      -1.469 100.572  31.868  1.00 78.32           N  
ATOM  10681  N   ALA F 182      -2.159 100.118  22.811  1.00 75.29           N  
ATOM  10682  CA  ALA F 182      -2.565  99.611  21.503  1.00 75.26           C  
ATOM  10683  C   ALA F 182      -1.360  99.625  20.575  1.00 75.53           C  
ATOM  10684  O   ALA F 182      -0.999  98.613  19.973  1.00 75.86           O  
ATOM  10685  CB  ALA F 182      -3.682 100.456  20.921  1.00 74.68           C  
ATOM  10686  N   VAL F 183      -0.716 100.785  20.518  1.00 75.54           N  
ATOM  10687  CA  VAL F 183       0.120 101.191  19.395  1.00 75.07           C  
ATOM  10688  C   VAL F 183       1.613 101.083  19.670  1.00 74.75           C  
ATOM  10689  O   VAL F 183       2.387 100.867  18.739  1.00 75.20           O  
ATOM  10690  CB  VAL F 183      -0.232 102.646  19.027  1.00 74.93           C  
ATOM  10691  CG1 VAL F 183       0.995 103.461  18.833  1.00 75.48           C  
ATOM  10692  CG2 VAL F 183      -1.148 102.685  17.827  1.00 75.23           C  
ATOM  10693  N   GLY F 184       2.009 101.250  20.935  1.00 74.31           N  
ATOM  10694  CA  GLY F 184       3.411 101.213  21.348  1.00 73.84           C  
ATOM  10695  C   GLY F 184       4.018 102.587  21.567  1.00 73.93           C  
ATOM  10696  O   GLY F 184       3.527 103.602  21.032  1.00 74.14           O  
ATOM  10697  N   LYS F 185       5.126 102.604  22.302  1.00 73.85           N  
ATOM  10698  CA  LYS F 185       5.721 103.833  22.814  1.00 74.05           C  
ATOM  10699  C   LYS F 185       6.116 104.826  21.738  1.00 74.07           C  
ATOM  10700  O   LYS F 185       5.799 106.002  21.845  1.00 75.08           O  
ATOM  10701  CB  LYS F 185       6.947 103.550  23.691  1.00 74.12           C  
ATOM  10702  CG  LYS F 185       7.245 104.699  24.649  1.00 74.45           C  
ATOM  10703  CD  LYS F 185       8.429 104.418  25.559  1.00 74.13           C  
ATOM  10704  CE  LYS F 185       9.754 104.641  24.852  1.00 74.34           C  
ATOM  10705  NZ  LYS F 185      10.870 104.834  25.826  1.00 74.85           N  
ATOM  10706  N   SER F 186       6.802 104.380  20.701  1.00 73.63           N  
ATOM  10707  CA  SER F 186       7.293 105.317  19.701  1.00 73.30           C  
ATOM  10708  C   SER F 186       6.161 106.111  19.030  1.00 73.11           C  
ATOM  10709  O   SER F 186       6.192 107.340  19.003  1.00 72.53           O  
ATOM  10710  CB  SER F 186       8.156 104.599  18.659  1.00 73.19           C  
ATOM  10711  OG  SER F 186       8.574 105.499  17.633  1.00 74.28           O  
ATOM  10712  N   LEU F 187       5.162 105.409  18.503  1.00 73.29           N  
ATOM  10713  CA  LEU F 187       4.082 106.067  17.779  1.00 73.51           C  
ATOM  10714  C   LEU F 187       3.171 106.860  18.717  1.00 73.79           C  
ATOM  10715  O   LEU F 187       2.824 108.007  18.421  1.00 74.09           O  
ATOM  10716  CB  LEU F 187       3.272 105.068  16.955  1.00 73.26           C  
ATOM  10717  CG  LEU F 187       2.111 105.680  16.141  1.00 73.82           C  
ATOM  10718  CD1 LEU F 187       2.602 106.759  15.159  1.00 71.45           C  
ATOM  10719  CD2 LEU F 187       1.332 104.595  15.402  1.00 73.63           C  
ATOM  10720  N   ALA F 188       2.808 106.259  19.848  1.00 74.10           N  
ATOM  10721  CA  ALA F 188       2.068 106.972  20.892  1.00 74.25           C  
ATOM  10722  C   ALA F 188       2.792 108.256  21.308  1.00 74.06           C  
ATOM  10723  O   ALA F 188       2.184 109.320  21.345  1.00 74.17           O  
ATOM  10724  CB  ALA F 188       1.833 106.070  22.109  1.00 74.25           C  
ATOM  10725  N   MET F 189       4.086 108.165  21.600  1.00 74.06           N  
ATOM  10726  CA  MET F 189       4.855 109.363  21.962  1.00 74.17           C  
ATOM  10727  C   MET F 189       4.839 110.381  20.844  1.00 73.87           C  
ATOM  10728  O   MET F 189       4.681 111.570  21.100  1.00 73.80           O  
ATOM  10729  CB  MET F 189       6.303 109.039  22.326  1.00 74.29           C  
ATOM  10730  CG  MET F 189       6.474 108.406  23.710  1.00 75.43           C  
ATOM  10731  SD  MET F 189       6.350 109.579  25.074  1.00 77.39           S  
ATOM  10732  CE  MET F 189       7.328 108.784  26.347  1.00 75.29           C  
ATOM  10733  N   GLU F 190       4.990 109.922  19.604  1.00 73.87           N  
ATOM  10734  CA  GLU F 190       5.015 110.841  18.461  1.00 73.91           C  
ATOM  10735  C   GLU F 190       3.661 111.534  18.300  1.00 73.77           C  
ATOM  10736  O   GLU F 190       3.594 112.755  18.173  1.00 73.49           O  
ATOM  10737  CB  GLU F 190       5.422 110.103  17.182  1.00 73.91           C  
ATOM  10738  CG  GLU F 190       5.506 110.982  15.922  1.00 73.72           C  
ATOM  10739  CD  GLU F 190       6.138 110.245  14.735  1.00 74.16           C  
ATOM  10740  OE1 GLU F 190       6.247 108.992  14.807  1.00 74.35           O  
ATOM  10741  OE2 GLU F 190       6.526 110.908  13.740  1.00 71.26           O  
ATOM  10742  N   MET F 191       2.588 110.748  18.336  1.00 73.79           N  
ATOM  10743  CA  MET F 191       1.233 111.289  18.249  1.00 74.20           C  
ATOM  10744  C   MET F 191       0.908 112.280  19.354  1.00 73.74           C  
ATOM  10745  O   MET F 191       0.337 113.332  19.085  1.00 74.01           O  
ATOM  10746  CB  MET F 191       0.195 110.170  18.275  1.00 74.19           C  
ATOM  10747  CG  MET F 191       0.055 109.434  16.961  1.00 74.66           C  
ATOM  10748  SD  MET F 191      -1.227 108.166  17.052  1.00 76.14           S  
ATOM  10749  CE  MET F 191      -2.730 109.166  17.048  1.00 73.40           C  
ATOM  10750  N   VAL F 192       1.267 111.943  20.589  1.00 73.65           N  
ATOM  10751  CA  VAL F 192       0.914 112.774  21.749  1.00 73.49           C  
ATOM  10752  C   VAL F 192       1.745 114.060  21.862  1.00 73.37           C  
ATOM  10753  O   VAL F 192       1.220 115.112  22.206  1.00 72.97           O  
ATOM  10754  CB  VAL F 192       1.013 111.967  23.083  1.00 73.52           C  
ATOM  10755  CG1 VAL F 192       0.770 112.881  24.273  1.00 72.90           C  
ATOM  10756  CG2 VAL F 192       0.019 110.788  23.089  1.00 72.21           C  
ATOM  10757  N   LEU F 193       3.037 113.967  21.576  1.00 73.71           N  
ATOM  10758  CA  LEU F 193       3.940 115.101  21.736  1.00 74.14           C  
ATOM  10759  C   LEU F 193       3.894 116.087  20.562  1.00 74.89           C  
ATOM  10760  O   LEU F 193       4.244 117.261  20.738  1.00 74.90           O  
ATOM  10761  CB  LEU F 193       5.366 114.608  21.960  1.00 74.10           C  
ATOM  10762  CG  LEU F 193       5.582 113.715  23.189  1.00 73.86           C  
ATOM  10763  CD1 LEU F 193       7.019 113.254  23.263  1.00 72.93           C  
ATOM  10764  CD2 LEU F 193       5.203 114.443  24.455  1.00 74.00           C  
ATOM  10765  N   THR F 194       3.469 115.620  19.382  1.00 75.70           N  
ATOM  10766  CA  THR F 194       3.298 116.488  18.201  1.00 76.46           C  
ATOM  10767  C   THR F 194       1.841 116.804  17.861  1.00 77.08           C  
ATOM  10768  O   THR F 194       1.562 117.828  17.244  1.00 77.26           O  
ATOM  10769  CB  THR F 194       3.886 115.861  16.924  1.00 76.52           C  
ATOM  10770  OG1 THR F 194       3.052 114.776  16.501  1.00 76.59           O  
ATOM  10771  CG2 THR F 194       5.317 115.373  17.146  1.00 76.44           C  
ATOM  10772  N   GLY F 195       0.921 115.914  18.226  1.00 77.87           N  
ATOM  10773  CA  GLY F 195      -0.483 116.038  17.816  1.00 78.29           C  
ATOM  10774  C   GLY F 195      -0.742 115.623  16.375  1.00 78.62           C  
ATOM  10775  O   GLY F 195      -1.796 115.927  15.817  1.00 78.16           O  
ATOM  10776  N   ASP F 196       0.204 114.906  15.773  1.00 79.29           N  
ATOM  10777  CA  ASP F 196       0.069 114.496  14.380  1.00 79.98           C  
ATOM  10778  C   ASP F 196      -0.919 113.344  14.212  1.00 80.20           C  
ATOM  10779  O   ASP F 196      -1.287 112.672  15.174  1.00 80.53           O  
ATOM  10780  CB  ASP F 196       1.438 114.161  13.765  1.00 80.06           C  
ATOM  10781  CG  ASP F 196       2.227 115.420  13.363  1.00 81.25           C  
ATOM  10782  OD1 ASP F 196       1.628 116.525  13.295  1.00 81.28           O  
ATOM  10783  OD2 ASP F 196       3.447 115.303  13.105  1.00 82.31           O  
ATOM  10784  N   ARG F 197      -1.330 113.131  12.969  1.00 80.55           N  
ATOM  10785  CA  ARG F 197      -2.491 112.325  12.641  1.00 80.76           C  
ATOM  10786  C   ARG F 197      -2.068 111.066  11.901  1.00 80.61           C  
ATOM  10787  O   ARG F 197      -1.115 111.090  11.118  1.00 80.86           O  
ATOM  10788  CB  ARG F 197      -3.432 113.150  11.774  1.00 80.90           C  
ATOM  10789  CG  ARG F 197      -3.361 114.637  12.107  1.00 82.49           C  
ATOM  10790  CD  ARG F 197      -4.564 115.417  11.626  1.00 83.78           C  
ATOM  10791  NE  ARG F 197      -4.656 115.440  10.169  1.00 84.49           N  
ATOM  10792  CZ  ARG F 197      -5.531 116.175   9.487  1.00 85.29           C  
ATOM  10793  NH1 ARG F 197      -6.392 116.964  10.128  1.00 85.44           N  
ATOM  10794  NH2 ARG F 197      -5.544 116.126   8.158  1.00 85.01           N  
ATOM  10795  N   ILE F 198      -2.767 109.966  12.161  1.00 80.04           N  
ATOM  10796  CA  ILE F 198      -2.485 108.709  11.479  1.00 79.66           C  
ATOM  10797  C   ILE F 198      -3.721 108.287  10.697  1.00 79.29           C  
ATOM  10798  O   ILE F 198      -4.847 108.576  11.096  1.00 79.25           O  
ATOM  10799  CB  ILE F 198      -2.039 107.598  12.477  1.00 79.66           C  
ATOM  10800  CG1 ILE F 198      -3.250 106.921  13.142  1.00 79.55           C  
ATOM  10801  CG2 ILE F 198      -1.083 108.188  13.524  1.00 79.47           C  
ATOM  10802  CD1 ILE F 198      -2.907 105.830  14.134  1.00 79.16           C  
ATOM  10803  N   SER F 199      -3.501 107.609   9.580  1.00 78.87           N  
ATOM  10804  CA  SER F 199      -4.596 107.100   8.776  1.00 78.70           C  
ATOM  10805  C   SER F 199      -5.139 105.796   9.336  1.00 78.41           C  
ATOM  10806  O   SER F 199      -4.531 105.171  10.201  1.00 78.47           O  
ATOM  10807  CB  SER F 199      -4.137 106.873   7.339  1.00 78.71           C  
ATOM  10808  OG  SER F 199      -3.190 105.824   7.272  1.00 79.38           O  
ATOM  10809  N   ALA F 200      -6.291 105.396   8.809  1.00 78.27           N  
ATOM  10810  CA  ALA F 200      -6.919 104.114   9.112  1.00 78.17           C  
ATOM  10811  C   ALA F 200      -5.972 102.956   8.825  1.00 78.12           C  
ATOM  10812  O   ALA F 200      -5.977 101.944   9.523  1.00 77.83           O  
ATOM  10813  CB  ALA F 200      -8.192 103.959   8.283  1.00 78.08           C  
ATOM  10814  N   GLN F 201      -5.159 103.126   7.789  1.00 78.24           N  
ATOM  10815  CA  GLN F 201      -4.220 102.104   7.358  1.00 78.23           C  
ATOM  10816  C   GLN F 201      -3.106 101.960   8.384  1.00 78.20           C  
ATOM  10817  O   GLN F 201      -2.691 100.843   8.679  1.00 78.29           O  
ATOM  10818  CB  GLN F 201      -3.664 102.437   5.968  1.00 78.29           C  
ATOM  10819  CG  GLN F 201      -4.714 102.379   4.830  1.00 78.68           C  
ATOM  10820  CD  GLN F 201      -5.670 103.588   4.781  1.00 78.54           C  
ATOM  10821  OE1 GLN F 201      -5.269 104.725   5.028  1.00 78.72           O  
ATOM  10822  NE2 GLN F 201      -6.933 103.335   4.446  1.00 78.13           N  
ATOM  10823  N   ASP F 202      -2.646 103.077   8.948  1.00 78.20           N  
ATOM  10824  CA  ASP F 202      -1.633 103.038  10.021  1.00 78.30           C  
ATOM  10825  C   ASP F 202      -2.200 102.439  11.321  1.00 77.82           C  
ATOM  10826  O   ASP F 202      -1.568 101.600  11.955  1.00 77.64           O  
ATOM  10827  CB  ASP F 202      -1.087 104.444  10.310  1.00 78.57           C  
ATOM  10828  CG  ASP F 202      -0.388 105.063   9.117  1.00 79.64           C  
ATOM  10829  OD1 ASP F 202       0.330 104.324   8.408  1.00 81.58           O  
ATOM  10830  OD2 ASP F 202      -0.550 106.288   8.893  1.00 80.41           O  
ATOM  10831  N   ALA F 203      -3.391 102.887  11.707  1.00 77.36           N  
ATOM  10832  CA  ALA F 203      -4.081 102.369  12.882  1.00 77.12           C  
ATOM  10833  C   ALA F 203      -4.272 100.847  12.835  1.00 76.90           C  
ATOM  10834  O   ALA F 203      -4.173 100.163  13.864  1.00 76.81           O  
ATOM  10835  CB  ALA F 203      -5.436 103.057  13.032  1.00 77.03           C  
ATOM  10836  N   LYS F 204      -4.575 100.329  11.650  1.00 76.62           N  
ATOM  10837  CA  LYS F 204      -4.828  98.906  11.471  1.00 76.65           C  
ATOM  10838  C   LYS F 204      -3.528  98.137  11.636  1.00 76.46           C  
ATOM  10839  O   LYS F 204      -3.464  97.166  12.398  1.00 76.51           O  
ATOM  10840  CB  LYS F 204      -5.475  98.641  10.100  1.00 76.98           C  
ATOM  10841  CG  LYS F 204      -5.602  97.164   9.677  1.00 77.44           C  
ATOM  10842  CD  LYS F 204      -6.311  96.282  10.714  1.00 78.46           C  
ATOM  10843  CE  LYS F 204      -6.153  94.796  10.372  1.00 78.62           C  
ATOM  10844  NZ  LYS F 204      -6.490  94.495   8.938  1.00 78.60           N  
ATOM  10845  N   GLN F 205      -2.485  98.590  10.942  1.00 76.25           N  
ATOM  10846  CA  GLN F 205      -1.145  98.013  11.104  1.00 75.96           C  
ATOM  10847  C   GLN F 205      -0.760  97.967  12.575  1.00 75.23           C  
ATOM  10848  O   GLN F 205      -0.304  96.936  13.047  1.00 75.66           O  
ATOM  10849  CB  GLN F 205      -0.082  98.785  10.298  1.00 76.02           C  
ATOM  10850  N   ALA F 206      -0.976  99.068  13.296  1.00 74.56           N  
ATOM  10851  CA  ALA F 206      -0.612  99.165  14.721  1.00 74.19           C  
ATOM  10852  C   ALA F 206      -1.632  98.539  15.685  1.00 74.23           C  
ATOM  10853  O   ALA F 206      -1.421  98.544  16.884  1.00 74.66           O  
ATOM  10854  CB  ALA F 206      -0.383 100.613  15.095  1.00 73.90           C  
ATOM  10855  N   GLY F 207      -2.744  98.020  15.188  1.00 74.32           N  
ATOM  10856  CA  GLY F 207      -3.697  97.337  16.059  1.00 74.40           C  
ATOM  10857  C   GLY F 207      -4.527  98.211  16.985  1.00 74.43           C  
ATOM  10858  O   GLY F 207      -5.035  97.717  17.987  1.00 74.24           O  
ATOM  10859  N   LEU F 208      -4.675  99.496  16.647  1.00 74.73           N  
ATOM  10860  CA  LEU F 208      -5.614 100.399  17.329  1.00 74.78           C  
ATOM  10861  C   LEU F 208      -7.042 100.080  16.869  1.00 75.36           C  
ATOM  10862  O   LEU F 208      -7.990 100.079  17.670  1.00 75.39           O  
ATOM  10863  CB  LEU F 208      -5.275 101.855  17.016  1.00 74.81           C  
ATOM  10864  CG  LEU F 208      -6.149 102.983  17.578  1.00 74.93           C  
ATOM  10865  CD1 LEU F 208      -6.158 102.994  19.103  1.00 75.26           C  
ATOM  10866  CD2 LEU F 208      -5.671 104.318  17.051  1.00 74.44           C  
ATOM  10867  N   VAL F 209      -7.177  99.819  15.571  1.00 75.67           N  
ATOM  10868  CA  VAL F 209      -8.417  99.330  14.988  1.00 75.85           C  
ATOM  10869  C   VAL F 209      -8.137  97.972  14.374  1.00 75.88           C  
ATOM  10870  O   VAL F 209      -6.987  97.661  14.059  1.00 76.30           O  
ATOM  10871  CB  VAL F 209      -8.908 100.264  13.904  1.00 75.83           C  
ATOM  10872  CG1 VAL F 209      -8.821 101.705  14.388  1.00 76.36           C  
ATOM  10873  CG2 VAL F 209      -8.079 100.076  12.651  1.00 75.99           C  
ATOM  10874  N   SER F 210      -9.182  97.169  14.197  1.00 75.75           N  
ATOM  10875  CA  SER F 210      -9.014  95.781  13.788  1.00 75.80           C  
ATOM  10876  C   SER F 210      -9.660  95.432  12.450  1.00 75.88           C  
ATOM  10877  O   SER F 210      -9.682  94.266  12.063  1.00 75.88           O  
ATOM  10878  CB  SER F 210      -9.552  94.861  14.878  1.00 75.68           C  
ATOM  10879  OG  SER F 210     -10.928  95.072  15.087  1.00 76.52           O  
ATOM  10880  N   LYS F 211     -10.179  96.438  11.748  1.00 76.17           N  
ATOM  10881  CA  LYS F 211     -10.785  96.249  10.425  1.00 76.19           C  
ATOM  10882  C   LYS F 211     -10.900  97.599   9.716  1.00 75.99           C  
ATOM  10883  O   LYS F 211     -11.148  98.618  10.351  1.00 75.69           O  
ATOM  10884  CB  LYS F 211     -12.170  95.587  10.536  1.00 76.25           C  
ATOM  10885  CG  LYS F 211     -12.532  94.710   9.334  1.00 76.70           C  
ATOM  10886  CD  LYS F 211     -14.016  94.329   9.296  1.00 76.69           C  
ATOM  10887  CE  LYS F 211     -14.360  93.469   8.064  1.00 77.73           C  
ATOM  10888  NZ  LYS F 211     -15.764  93.682   7.527  1.00 77.96           N  
ATOM  10889  N   ILE F 212     -10.694  97.595   8.405  1.00 76.16           N  
ATOM  10890  CA  ILE F 212     -10.904  98.773   7.567  1.00 76.17           C  
ATOM  10891  C   ILE F 212     -11.992  98.470   6.548  1.00 76.26           C  
ATOM  10892  O   ILE F 212     -11.998  97.396   5.954  1.00 76.09           O  
ATOM  10893  CB  ILE F 212      -9.624  99.172   6.819  1.00 76.25           C  
ATOM  10894  CG1 ILE F 212      -8.508  99.525   7.816  1.00 76.12           C  
ATOM  10895  CG2 ILE F 212      -9.899 100.343   5.896  1.00 75.36           C  
ATOM  10896  CD1 ILE F 212      -7.193  99.905   7.133  1.00 76.19           C  
ATOM  10897  N   CYS F 213     -12.907  99.420   6.356  1.00 76.54           N  
ATOM  10898  CA  CYS F 213     -14.058  99.239   5.469  1.00 76.82           C  
ATOM  10899  C   CYS F 213     -14.250 100.446   4.546  1.00 76.74           C  
ATOM  10900  O   CYS F 213     -13.765 101.538   4.834  1.00 76.69           O  
ATOM  10901  CB  CYS F 213     -15.340  99.051   6.292  1.00 76.99           C  
ATOM  10902  SG  CYS F 213     -15.248  97.830   7.638  1.00 78.51           S  
ATOM  10903  N   PRO F 214     -14.958 100.254   3.425  1.00 76.74           N  
ATOM  10904  CA  PRO F 214     -15.378 101.410   2.634  1.00 76.90           C  
ATOM  10905  C   PRO F 214     -16.317 102.327   3.417  1.00 76.87           C  
ATOM  10906  O   PRO F 214     -17.132 101.854   4.210  1.00 76.97           O  
ATOM  10907  CB  PRO F 214     -16.112 100.779   1.442  1.00 76.87           C  
ATOM  10908  CG  PRO F 214     -15.592  99.375   1.375  1.00 77.00           C  
ATOM  10909  CD  PRO F 214     -15.367  98.985   2.801  1.00 76.80           C  
ATOM  10910  N   VAL F 215     -16.200 103.627   3.189  1.00 76.72           N  
ATOM  10911  CA  VAL F 215     -16.990 104.609   3.918  1.00 76.59           C  
ATOM  10912  C   VAL F 215     -18.478 104.250   3.849  1.00 76.72           C  
ATOM  10913  O   VAL F 215     -19.185 104.278   4.856  1.00 76.46           O  
ATOM  10914  CB  VAL F 215     -16.759 106.030   3.351  1.00 76.61           C  
ATOM  10915  CG1 VAL F 215     -17.573 107.055   4.120  1.00 76.71           C  
ATOM  10916  CG2 VAL F 215     -15.273 106.388   3.383  1.00 75.99           C  
ATOM  10917  N   GLU F 216     -18.925 103.877   2.654  1.00 77.04           N  
ATOM  10918  CA  GLU F 216     -20.339 103.589   2.369  1.00 77.24           C  
ATOM  10919  C   GLU F 216     -20.914 102.461   3.226  1.00 76.96           C  
ATOM  10920  O   GLU F 216     -22.068 102.519   3.636  1.00 76.91           O  
ATOM  10921  CB  GLU F 216     -20.520 103.218   0.890  1.00 77.41           C  
ATOM  10922  CG  GLU F 216     -20.151 104.331  -0.112  1.00 78.82           C  
ATOM  10923  CD  GLU F 216     -18.650 104.406  -0.460  1.00 80.04           C  
ATOM  10924  OE1 GLU F 216     -17.881 103.479  -0.114  1.00 78.83           O  
ATOM  10925  OE2 GLU F 216     -18.246 105.412  -1.093  1.00 81.40           O  
ATOM  10926  N   THR F 217     -20.108 101.435   3.485  1.00 76.75           N  
ATOM  10927  CA  THR F 217     -20.583 100.232   4.164  1.00 76.44           C  
ATOM  10928  C   THR F 217     -20.026 100.073   5.587  1.00 76.24           C  
ATOM  10929  O   THR F 217     -20.210  99.027   6.205  1.00 76.36           O  
ATOM  10930  CB  THR F 217     -20.264  98.970   3.316  1.00 76.48           C  
ATOM  10931  OG1 THR F 217     -18.850  98.853   3.119  1.00 75.72           O  
ATOM  10932  CG2 THR F 217     -20.960  99.053   1.946  1.00 76.57           C  
ATOM  10933  N   LEU F 218     -19.386 101.112   6.123  1.00 75.89           N  
ATOM  10934  CA  LEU F 218     -18.717 101.009   7.427  1.00 75.90           C  
ATOM  10935  C   LEU F 218     -19.677 100.641   8.553  1.00 75.95           C  
ATOM  10936  O   LEU F 218     -19.500  99.614   9.207  1.00 75.99           O  
ATOM  10937  CB  LEU F 218     -17.989 102.310   7.772  1.00 75.78           C  
ATOM  10938  CG  LEU F 218     -17.304 102.397   9.133  1.00 75.34           C  
ATOM  10939  CD1 LEU F 218     -16.344 101.238   9.356  1.00 75.12           C  
ATOM  10940  CD2 LEU F 218     -16.580 103.714   9.222  1.00 75.62           C  
ATOM  10941  N   VAL F 219     -20.680 101.481   8.778  1.00 76.00           N  
ATOM  10942  CA  VAL F 219     -21.683 101.221   9.804  1.00 76.18           C  
ATOM  10943  C   VAL F 219     -22.375  99.871   9.551  1.00 76.62           C  
ATOM  10944  O   VAL F 219     -22.673  99.136  10.503  1.00 76.89           O  
ATOM  10945  CB  VAL F 219     -22.727 102.364   9.885  1.00 76.11           C  
ATOM  10946  CG1 VAL F 219     -23.842 102.014  10.863  1.00 76.01           C  
ATOM  10947  CG2 VAL F 219     -22.055 103.674  10.295  1.00 75.72           C  
ATOM  10948  N   GLU F 220     -22.591  99.544   8.275  1.00 76.82           N  
ATOM  10949  CA  GLU F 220     -23.171  98.258   7.864  1.00 77.30           C  
ATOM  10950  C   GLU F 220     -22.298  97.061   8.297  1.00 77.22           C  
ATOM  10951  O   GLU F 220     -22.819  96.071   8.822  1.00 77.23           O  
ATOM  10952  CB  GLU F 220     -23.400  98.241   6.340  1.00 77.34           C  
ATOM  10953  CG  GLU F 220     -24.366  97.164   5.833  1.00 78.07           C  
ATOM  10954  CD  GLU F 220     -24.498  97.139   4.293  1.00 78.53           C  
ATOM  10955  OE1 GLU F 220     -25.227  97.987   3.708  1.00 78.96           O  
ATOM  10956  OE2 GLU F 220     -23.879  96.248   3.667  1.00 80.54           O  
ATOM  10957  N   GLU F 221     -20.982  97.150   8.088  1.00 76.99           N  
ATOM  10958  CA  GLU F 221     -20.072  96.095   8.542  1.00 76.85           C  
ATOM  10959  C   GLU F 221     -20.078  96.037  10.067  1.00 76.41           C  
ATOM  10960  O   GLU F 221     -20.034  94.950  10.650  1.00 76.44           O  
ATOM  10961  CB  GLU F 221     -18.622  96.324   8.075  1.00 77.17           C  
ATOM  10962  CG  GLU F 221     -18.390  96.533   6.570  1.00 78.45           C  
ATOM  10963  CD  GLU F 221     -18.886  95.400   5.693  1.00 80.11           C  
ATOM  10964  OE1 GLU F 221     -18.949  94.243   6.164  1.00 81.50           O  
ATOM  10965  OE2 GLU F 221     -19.201  95.671   4.514  1.00 81.57           O  
ATOM  10966  N   ALA F 222     -20.108  97.207  10.707  1.00 75.87           N  
ATOM  10967  CA  ALA F 222     -20.090  97.285  12.173  1.00 75.51           C  
ATOM  10968  C   ALA F 222     -21.303  96.581  12.764  1.00 75.19           C  
ATOM  10969  O   ALA F 222     -21.182  95.863  13.752  1.00 75.02           O  
ATOM  10970  CB  ALA F 222     -20.027  98.736  12.653  1.00 75.15           C  
ATOM  10971  N   ILE F 223     -22.465  96.777  12.144  1.00 75.08           N  
ATOM  10972  CA  ILE F 223     -23.695  96.135  12.609  1.00 75.00           C  
ATOM  10973  C   ILE F 223     -23.620  94.619  12.427  1.00 75.15           C  
ATOM  10974  O   ILE F 223     -23.986  93.878  13.331  1.00 75.29           O  
ATOM  10975  CB  ILE F 223     -24.951  96.709  11.904  1.00 74.96           C  
ATOM  10976  CG1 ILE F 223     -25.169  98.164  12.320  1.00 74.60           C  
ATOM  10977  CG2 ILE F 223     -26.189  95.897  12.257  1.00 74.48           C  
ATOM  10978  CD1 ILE F 223     -25.887  98.983  11.288  1.00 74.17           C  
ATOM  10979  N   GLN F 224     -23.133  94.162  11.276  1.00 75.33           N  
ATOM  10980  CA  GLN F 224     -22.977  92.726  11.033  1.00 75.64           C  
ATOM  10981  C   GLN F 224     -22.078  92.085  12.085  1.00 75.68           C  
ATOM  10982  O   GLN F 224     -22.421  91.038  12.635  1.00 75.73           O  
ATOM  10983  CB  GLN F 224     -22.438  92.453   9.627  1.00 75.66           C  
ATOM  10984  CG  GLN F 224     -23.465  92.738   8.538  1.00 76.84           C  
ATOM  10985  CD  GLN F 224     -22.995  92.336   7.153  1.00 77.52           C  
ATOM  10986  OE1 GLN F 224     -21.791  92.203   6.901  1.00 78.00           O  
ATOM  10987  NE2 GLN F 224     -23.945  92.139   6.244  1.00 77.03           N  
ATOM  10988  N   CYS F 225     -20.941  92.715  12.374  1.00 75.70           N  
ATOM  10989  CA  CYS F 225     -20.081  92.249  13.464  1.00 75.61           C  
ATOM  10990  C   CYS F 225     -20.826  92.250  14.800  1.00 75.48           C  
ATOM  10991  O   CYS F 225     -20.774  91.268  15.545  1.00 75.45           O  
ATOM  10992  CB  CYS F 225     -18.828  93.105  13.577  1.00 75.59           C  
ATOM  10993  SG  CYS F 225     -17.856  92.737  15.046  1.00 76.25           S  
ATOM  10994  N   ALA F 226     -21.516  93.345  15.099  1.00 75.33           N  
ATOM  10995  CA  ALA F 226     -22.335  93.429  16.309  1.00 75.55           C  
ATOM  10996  C   ALA F 226     -23.424  92.354  16.341  1.00 75.78           C  
ATOM  10997  O   ALA F 226     -23.739  91.813  17.397  1.00 76.09           O  
ATOM  10998  CB  ALA F 226     -22.961  94.808  16.433  1.00 75.35           C  
ATOM  10999  N   GLU F 227     -23.980  92.042  15.178  1.00 75.89           N  
ATOM  11000  CA  GLU F 227     -25.094  91.101  15.073  1.00 76.22           C  
ATOM  11001  C   GLU F 227     -24.668  89.665  15.403  1.00 76.10           C  
ATOM  11002  O   GLU F 227     -25.446  88.913  15.988  1.00 75.98           O  
ATOM  11003  CB  GLU F 227     -25.717  91.189  13.670  1.00 76.35           C  
ATOM  11004  CG  GLU F 227     -27.097  90.570  13.540  1.00 77.26           C  
ATOM  11005  CD  GLU F 227     -27.884  91.132  12.356  1.00 78.49           C  
ATOM  11006  OE1 GLU F 227     -27.272  91.418  11.300  1.00 78.45           O  
ATOM  11007  OE2 GLU F 227     -29.121  91.287  12.492  1.00 78.99           O  
ATOM  11008  N   LYS F 228     -23.441  89.292  15.034  1.00 76.10           N  
ATOM  11009  CA  LYS F 228     -22.865  87.998  15.427  1.00 76.29           C  
ATOM  11010  C   LYS F 228     -22.688  87.921  16.937  1.00 75.83           C  
ATOM  11011  O   LYS F 228     -23.017  86.910  17.561  1.00 75.93           O  
ATOM  11012  CB  LYS F 228     -21.487  87.782  14.795  1.00 76.29           C  
ATOM  11013  CG  LYS F 228     -21.480  87.531  13.297  1.00 77.13           C  
ATOM  11014  CD  LYS F 228     -20.045  87.296  12.810  1.00 77.43           C  
ATOM  11015  CE  LYS F 228     -19.798  87.918  11.440  1.00 78.46           C  
ATOM  11016  NZ  LYS F 228     -18.341  88.095  11.210  1.00 79.38           N  
ATOM  11017  N   ILE F 229     -22.145  88.987  17.517  1.00 75.24           N  
ATOM  11018  CA  ILE F 229     -21.941  89.049  18.961  1.00 74.79           C  
ATOM  11019  C   ILE F 229     -23.277  88.949  19.689  1.00 74.39           C  
ATOM  11020  O   ILE F 229     -23.397  88.268  20.701  1.00 74.57           O  
ATOM  11021  CB  ILE F 229     -21.198  90.337  19.374  1.00 74.71           C  
ATOM  11022  CG1 ILE F 229     -19.738  90.275  18.908  1.00 73.96           C  
ATOM  11023  CG2 ILE F 229     -21.271  90.529  20.875  1.00 74.51           C  
ATOM  11024  CD1 ILE F 229     -18.969  91.565  19.083  1.00 72.61           C  
ATOM  11025  N   ALA F 230     -24.290  89.610  19.155  1.00 74.09           N  
ATOM  11026  CA  ALA F 230     -25.625  89.535  19.728  1.00 73.69           C  
ATOM  11027  C   ALA F 230     -26.191  88.112  19.705  1.00 73.42           C  
ATOM  11028  O   ALA F 230     -27.010  87.774  20.553  1.00 73.45           O  
ATOM  11029  CB  ALA F 230     -26.552  90.487  19.008  1.00 73.74           C  
ATOM  11030  N   SER F 231     -25.768  87.291  18.739  1.00 73.22           N  
ATOM  11031  CA  SER F 231     -26.229  85.892  18.628  1.00 73.13           C  
ATOM  11032  C   SER F 231     -25.821  85.034  19.812  1.00 72.85           C  
ATOM  11033  O   SER F 231     -26.568  84.149  20.227  1.00 73.00           O  
ATOM  11034  CB  SER F 231     -25.676  85.210  17.373  1.00 73.14           C  
ATOM  11035  OG  SER F 231     -25.988  85.933  16.213  1.00 73.55           O  
ATOM  11036  N   ASN F 232     -24.631  85.289  20.342  1.00 72.51           N  
ATOM  11037  CA  ASN F 232     -24.097  84.496  21.448  1.00 72.27           C  
ATOM  11038  C   ASN F 232     -24.835  84.751  22.777  1.00 72.11           C  
ATOM  11039  O   ASN F 232     -25.659  85.647  22.875  1.00 72.02           O  
ATOM  11040  CB  ASN F 232     -22.595  84.771  21.607  1.00 72.07           C  
ATOM  11041  CG  ASN F 232     -21.808  84.531  20.320  1.00 71.63           C  
ATOM  11042  OD1 ASN F 232     -22.170  83.675  19.517  1.00 70.83           O  
ATOM  11043  ND2 ASN F 232     -20.725  85.293  20.124  1.00 70.36           N  
ATOM  11044  N   SER F 233     -24.527  83.952  23.794  1.00 72.11           N  
ATOM  11045  CA  SER F 233     -25.089  84.141  25.134  1.00 72.01           C  
ATOM  11046  C   SER F 233     -24.647  85.474  25.756  1.00 72.04           C  
ATOM  11047  O   SER F 233     -23.459  85.749  25.848  1.00 72.03           O  
ATOM  11048  CB  SER F 233     -24.680  82.978  26.041  1.00 71.83           C  
ATOM  11049  OG  SER F 233     -25.081  83.206  27.376  1.00 70.94           O  
ATOM  11050  N   LYS F 234     -25.612  86.289  26.180  1.00 72.27           N  
ATOM  11051  CA  LYS F 234     -25.331  87.617  26.736  1.00 72.37           C  
ATOM  11052  C   LYS F 234     -24.469  87.517  27.991  1.00 72.42           C  
ATOM  11053  O   LYS F 234     -23.507  88.275  28.156  1.00 72.33           O  
ATOM  11054  CB  LYS F 234     -26.632  88.371  27.051  1.00 72.17           C  
ATOM  11055  N   ILE F 235     -24.813  86.567  28.857  1.00 72.47           N  
ATOM  11056  CA  ILE F 235     -24.072  86.340  30.100  1.00 72.55           C  
ATOM  11057  C   ILE F 235     -22.640  85.870  29.833  1.00 72.52           C  
ATOM  11058  O   ILE F 235     -21.700  86.366  30.463  1.00 73.02           O  
ATOM  11059  CB  ILE F 235     -24.806  85.338  31.030  1.00 72.55           C  
ATOM  11060  CG1 ILE F 235     -24.120  85.275  32.395  1.00 72.80           C  
ATOM  11061  CG2 ILE F 235     -24.861  83.952  30.411  1.00 72.42           C  
ATOM  11062  CD1 ILE F 235     -24.957  84.597  33.468  1.00 73.21           C  
ATOM  11063  N   VAL F 236     -22.471  84.952  28.882  1.00 72.39           N  
ATOM  11064  CA  VAL F 236     -21.152  84.381  28.585  1.00 72.70           C  
ATOM  11065  C   VAL F 236     -20.268  85.359  27.790  1.00 72.49           C  
ATOM  11066  O   VAL F 236     -19.054  85.405  27.990  1.00 72.20           O  
ATOM  11067  CB  VAL F 236     -21.264  82.997  27.881  1.00 72.69           C  
ATOM  11068  CG1 VAL F 236     -19.888  82.432  27.555  1.00 73.33           C  
ATOM  11069  CG2 VAL F 236     -22.015  82.020  28.773  1.00 72.74           C  
ATOM  11070  N   VAL F 237     -20.887  86.142  26.911  1.00 72.48           N  
ATOM  11071  CA  VAL F 237     -20.211  87.256  26.238  1.00 72.33           C  
ATOM  11072  C   VAL F 237     -19.685  88.252  27.262  1.00 72.62           C  
ATOM  11073  O   VAL F 237     -18.548  88.694  27.167  1.00 72.58           O  
ATOM  11074  CB  VAL F 237     -21.168  87.996  25.259  1.00 72.22           C  
ATOM  11075  CG1 VAL F 237     -20.667  89.406  24.942  1.00 71.39           C  
ATOM  11076  CG2 VAL F 237     -21.342  87.192  23.986  1.00 71.71           C  
ATOM  11077  N   ALA F 238     -20.519  88.593  28.241  1.00 73.08           N  
ATOM  11078  CA  ALA F 238     -20.136  89.527  29.298  1.00 73.40           C  
ATOM  11079  C   ALA F 238     -18.863  89.092  30.033  1.00 73.89           C  
ATOM  11080  O   ALA F 238     -18.012  89.922  30.338  1.00 73.71           O  
ATOM  11081  CB  ALA F 238     -21.280  89.706  30.283  1.00 73.02           C  
ATOM  11082  N   MET F 239     -18.738  87.796  30.318  1.00 74.61           N  
ATOM  11083  CA  MET F 239     -17.588  87.273  31.058  1.00 75.09           C  
ATOM  11084  C   MET F 239     -16.360  87.251  30.170  1.00 75.20           C  
ATOM  11085  O   MET F 239     -15.254  87.589  30.617  1.00 75.38           O  
ATOM  11086  CB  MET F 239     -17.863  85.863  31.581  1.00 75.20           C  
ATOM  11087  CG  MET F 239     -19.052  85.753  32.534  1.00 75.47           C  
ATOM  11088  SD  MET F 239     -19.444  84.034  32.936  1.00 76.91           S  
ATOM  11089  CE  MET F 239     -20.853  84.217  34.024  1.00 75.81           C  
ATOM  11090  N   ALA F 240     -16.545  86.862  28.909  1.00 75.21           N  
ATOM  11091  CA  ALA F 240     -15.460  86.934  27.928  1.00 75.30           C  
ATOM  11092  C   ALA F 240     -14.906  88.351  27.815  1.00 75.64           C  
ATOM  11093  O   ALA F 240     -13.692  88.536  27.731  1.00 75.73           O  
ATOM  11094  CB  ALA F 240     -15.917  86.434  26.570  1.00 75.01           C  
ATOM  11095  N   LYS F 241     -15.788  89.350  27.822  1.00 76.26           N  
ATOM  11096  CA  LYS F 241     -15.353  90.745  27.768  1.00 76.88           C  
ATOM  11097  C   LYS F 241     -14.517  91.102  28.995  1.00 77.59           C  
ATOM  11098  O   LYS F 241     -13.400  91.619  28.868  1.00 77.47           O  
ATOM  11099  CB  LYS F 241     -16.545  91.693  27.640  1.00 76.84           C  
ATOM  11100  CG  LYS F 241     -16.194  93.167  27.821  1.00 76.86           C  
ATOM  11101  CD  LYS F 241     -17.235  94.070  27.175  1.00 77.94           C  
ATOM  11102  CE  LYS F 241     -17.114  95.509  27.669  1.00 78.83           C  
ATOM  11103  NZ  LYS F 241     -17.773  96.506  26.761  1.00 79.10           N  
ATOM  11104  N   GLU F 242     -15.052  90.807  30.175  1.00 78.27           N  
ATOM  11105  CA  GLU F 242     -14.364  91.116  31.432  1.00 79.49           C  
ATOM  11106  C   GLU F 242     -12.955  90.483  31.483  1.00 79.03           C  
ATOM  11107  O   GLU F 242     -12.013  91.080  32.012  1.00 79.23           O  
ATOM  11108  CB  GLU F 242     -15.220  90.659  32.622  1.00 79.62           C  
ATOM  11109  CG  GLU F 242     -15.153  91.556  33.873  1.00 81.05           C  
ATOM  11110  CD  GLU F 242     -16.448  91.500  34.724  1.00 82.02           C  
ATOM  11111  OE1 GLU F 242     -17.231  90.517  34.604  1.00 83.89           O  
ATOM  11112  OE2 GLU F 242     -16.681  92.449  35.522  1.00 85.66           O  
ATOM  11113  N   SER F 243     -12.826  89.291  30.901  1.00 78.79           N  
ATOM  11114  CA  SER F 243     -11.571  88.534  30.866  1.00 78.39           C  
ATOM  11115  C   SER F 243     -10.519  89.198  29.966  1.00 77.91           C  
ATOM  11116  O   SER F 243      -9.365  89.330  30.362  1.00 77.84           O  
ATOM  11117  CB  SER F 243     -11.856  87.092  30.412  1.00 78.61           C  
ATOM  11118  OG  SER F 243     -10.686  86.296  30.299  1.00 79.47           O  
ATOM  11119  N   VAL F 244     -10.911  89.620  28.768  1.00 77.52           N  
ATOM  11120  CA  VAL F 244     -10.025  90.424  27.915  1.00 77.22           C  
ATOM  11121  C   VAL F 244      -9.580  91.729  28.596  1.00 76.93           C  
ATOM  11122  O   VAL F 244      -8.385  92.032  28.610  1.00 77.40           O  
ATOM  11123  CB  VAL F 244     -10.666  90.789  26.560  1.00 77.17           C  
ATOM  11124  CG1 VAL F 244      -9.788  91.778  25.820  1.00 77.25           C  
ATOM  11125  CG2 VAL F 244     -10.884  89.554  25.703  1.00 77.39           C  
ATOM  11126  N   ASN F 245     -10.523  92.486  29.158  1.00 76.50           N  
ATOM  11127  CA  ASN F 245     -10.211  93.728  29.900  1.00 76.34           C  
ATOM  11128  C   ASN F 245      -9.238  93.525  31.063  1.00 76.48           C  
ATOM  11129  O   ASN F 245      -8.419  94.403  31.348  1.00 76.19           O  
ATOM  11130  CB  ASN F 245     -11.486  94.392  30.436  1.00 76.19           C  
ATOM  11131  CG  ASN F 245     -12.151  95.327  29.418  1.00 75.56           C  
ATOM  11132  OD1 ASN F 245     -11.478  95.988  28.625  1.00 74.43           O  
ATOM  11133  ND2 ASN F 245     -13.479  95.400  29.464  1.00 74.06           N  
ATOM  11134  N   ALA F 246      -9.332  92.363  31.714  1.00 76.53           N  
ATOM  11135  CA  ALA F 246      -8.378  91.959  32.754  1.00 76.90           C  
ATOM  11136  C   ALA F 246      -6.890  92.042  32.334  1.00 77.29           C  
ATOM  11137  O   ALA F 246      -6.021  92.252  33.185  1.00 77.46           O  
ATOM  11138  CB  ALA F 246      -8.690  90.553  33.218  1.00 76.61           C  
ATOM  11139  N   ALA F 247      -6.594  91.876  31.041  1.00 77.24           N  
ATOM  11140  CA  ALA F 247      -5.199  91.768  30.588  1.00 77.28           C  
ATOM  11141  C   ALA F 247      -4.390  93.049  30.795  1.00 77.51           C  
ATOM  11142  O   ALA F 247      -3.154  93.011  30.815  1.00 77.77           O  
ATOM  11143  CB  ALA F 247      -5.142  91.343  29.140  1.00 77.29           C  
ATOM  11144  N   PHE F 248      -5.085  94.176  30.952  1.00 77.63           N  
ATOM  11145  CA  PHE F 248      -4.441  95.457  31.221  1.00 77.44           C  
ATOM  11146  C   PHE F 248      -4.467  95.854  32.693  1.00 77.30           C  
ATOM  11147  O   PHE F 248      -4.136  96.991  33.021  1.00 77.21           O  
ATOM  11148  CB  PHE F 248      -5.130  96.562  30.424  1.00 77.71           C  
ATOM  11149  CG  PHE F 248      -5.198  96.302  28.952  1.00 77.83           C  
ATOM  11150  CD1 PHE F 248      -4.064  96.419  28.165  1.00 77.78           C  
ATOM  11151  CD2 PHE F 248      -6.409  95.963  28.348  1.00 78.15           C  
ATOM  11152  CE1 PHE F 248      -4.124  96.190  26.789  1.00 78.39           C  
ATOM  11153  CE2 PHE F 248      -6.480  95.731  26.985  1.00 78.41           C  
ATOM  11154  CZ  PHE F 248      -5.332  95.842  26.198  1.00 78.09           C  
ATOM  11155  N   GLU F 249      -4.859  94.941  33.580  1.00 77.29           N  
ATOM  11156  CA  GLU F 249      -5.037  95.295  34.987  1.00 77.34           C  
ATOM  11157  C   GLU F 249      -4.353  94.360  35.988  1.00 77.07           C  
ATOM  11158  O   GLU F 249      -4.382  94.622  37.192  1.00 77.78           O  
ATOM  11159  CB  GLU F 249      -6.524  95.359  35.322  1.00 77.53           C  
ATOM  11160  CG  GLU F 249      -7.414  96.027  34.259  1.00 78.41           C  
ATOM  11161  CD  GLU F 249      -7.333  97.553  34.221  1.00 80.02           C  
ATOM  11162  OE1 GLU F 249      -6.674  98.166  35.100  1.00 80.82           O  
ATOM  11163  OE2 GLU F 249      -7.959  98.144  33.300  1.00 81.33           O  
ATOM  11164  N   MET F 250      -3.754  93.278  35.504  1.00 76.34           N  
ATOM  11165  CA  MET F 250      -3.114  92.270  36.354  1.00 75.62           C  
ATOM  11166  C   MET F 250      -1.921  91.707  35.617  1.00 73.80           C  
ATOM  11167  O   MET F 250      -1.804  91.854  34.414  1.00 73.28           O  
ATOM  11168  CB  MET F 250      -4.057  91.097  36.604  1.00 75.23           C  
ATOM  11169  CG  MET F 250      -5.409  91.447  37.136  1.00 77.02           C  
ATOM  11170  SD  MET F 250      -6.491  89.999  37.222  1.00 78.70           S  
ATOM  11171  CE  MET F 250      -6.192  89.391  35.580  1.00 81.49           C  
ATOM  11172  N   THR F 251      -1.065  91.002  36.339  1.00 72.87           N  
ATOM  11173  CA  THR F 251      -0.007  90.229  35.706  1.00 71.82           C  
ATOM  11174  C   THR F 251      -0.611  89.046  34.937  1.00 71.96           C  
ATOM  11175  O   THR F 251      -1.735  88.582  35.245  1.00 72.21           O  
ATOM  11176  CB  THR F 251       1.008  89.697  36.723  1.00 71.37           C  
ATOM  11177  OG1 THR F 251       0.401  88.683  37.529  1.00 70.37           O  
ATOM  11178  CG2 THR F 251       1.559  90.818  37.592  1.00 69.79           C  
ATOM  11179  N   LEU F 252       0.136  88.556  33.951  1.00 71.59           N  
ATOM  11180  CA  LEU F 252      -0.267  87.373  33.205  1.00 71.84           C  
ATOM  11181  C   LEU F 252      -0.628  86.214  34.137  1.00 72.57           C  
ATOM  11182  O   LEU F 252      -1.661  85.555  33.951  1.00 72.46           O  
ATOM  11183  CB  LEU F 252       0.835  86.935  32.232  1.00 71.98           C  
ATOM  11184  CG  LEU F 252       0.460  85.759  31.327  1.00 71.81           C  
ATOM  11185  CD1 LEU F 252      -0.829  86.117  30.566  1.00 70.56           C  
ATOM  11186  CD2 LEU F 252       1.596  85.390  30.376  1.00 70.75           C  
ATOM  11187  N   THR F 253       0.201  85.984  35.154  1.00 73.15           N  
ATOM  11188  CA  THR F 253      -0.080  84.932  36.120  1.00 73.78           C  
ATOM  11189  C   THR F 253      -1.503  85.007  36.668  1.00 74.30           C  
ATOM  11190  O   THR F 253      -2.202  83.989  36.729  1.00 74.78           O  
ATOM  11191  CB  THR F 253       0.895  84.982  37.295  1.00 74.02           C  
ATOM  11192  OG1 THR F 253       2.236  84.828  36.812  1.00 74.90           O  
ATOM  11193  CG2 THR F 253       0.588  83.882  38.296  1.00 73.63           C  
ATOM  11194  N   GLU F 254      -1.936  86.201  37.067  1.00 74.75           N  
ATOM  11195  CA  GLU F 254      -3.218  86.334  37.756  1.00 74.97           C  
ATOM  11196  C   GLU F 254      -4.364  86.453  36.772  1.00 74.87           C  
ATOM  11197  O   GLU F 254      -5.487  86.082  37.093  1.00 74.96           O  
ATOM  11198  CB  GLU F 254      -3.212  87.521  38.720  1.00 75.15           C  
ATOM  11199  CG  GLU F 254      -2.179  87.427  39.842  1.00 75.72           C  
ATOM  11200  CD  GLU F 254      -2.294  86.165  40.717  1.00 77.67           C  
ATOM  11201  OE1 GLU F 254      -3.422  85.785  41.125  1.00 79.08           O  
ATOM  11202  OE2 GLU F 254      -1.234  85.567  41.029  1.00 78.17           O  
ATOM  11203  N   GLY F 255      -4.081  86.971  35.579  1.00 74.87           N  
ATOM  11204  CA  GLY F 255      -5.053  86.948  34.484  1.00 74.73           C  
ATOM  11205  C   GLY F 255      -5.505  85.536  34.215  1.00 74.77           C  
ATOM  11206  O   GLY F 255      -6.698  85.243  34.212  1.00 74.52           O  
ATOM  11207  N   SER F 256      -4.532  84.650  34.027  1.00 75.03           N  
ATOM  11208  CA  SER F 256      -4.797  83.239  33.799  1.00 75.00           C  
ATOM  11209  C   SER F 256      -5.660  82.635  34.899  1.00 75.15           C  
ATOM  11210  O   SER F 256      -6.606  81.916  34.604  1.00 75.20           O  
ATOM  11211  CB  SER F 256      -3.482  82.475  33.649  1.00 74.87           C  
ATOM  11212  OG  SER F 256      -2.868  82.822  32.417  1.00 75.09           O  
ATOM  11213  N   LYS F 257      -5.347  82.942  36.157  1.00 75.43           N  
ATOM  11214  CA  LYS F 257      -6.176  82.496  37.274  1.00 75.77           C  
ATOM  11215  C   LYS F 257      -7.589  83.070  37.191  1.00 75.80           C  
ATOM  11216  O   LYS F 257      -8.553  82.366  37.480  1.00 75.20           O  
ATOM  11217  CB  LYS F 257      -5.574  82.892  38.623  1.00 76.04           C  
ATOM  11218  CG  LYS F 257      -4.415  82.017  39.122  1.00 77.71           C  
ATOM  11219  CD  LYS F 257      -4.262  82.152  40.652  1.00 79.82           C  
ATOM  11220  CE  LYS F 257      -2.846  81.847  41.123  1.00 81.58           C  
ATOM  11221  NZ  LYS F 257      -1.852  82.892  40.698  1.00 83.19           N  
ATOM  11222  N   LEU F 258      -7.706  84.349  36.833  1.00 76.00           N  
ATOM  11223  CA  LEU F 258      -9.011  84.992  36.783  1.00 76.40           C  
ATOM  11224  C   LEU F 258      -9.847  84.388  35.660  1.00 76.52           C  
ATOM  11225  O   LEU F 258     -11.018  84.068  35.853  1.00 76.15           O  
ATOM  11226  CB  LEU F 258      -8.895  86.509  36.599  1.00 76.43           C  
ATOM  11227  CG  LEU F 258     -10.254  87.210  36.369  1.00 76.52           C  
ATOM  11228  CD1 LEU F 258     -11.206  86.869  37.492  1.00 76.74           C  
ATOM  11229  CD2 LEU F 258     -10.124  88.718  36.237  1.00 76.73           C  
ATOM  11230  N   GLU F 259      -9.220  84.244  34.496  1.00 76.91           N  
ATOM  11231  CA  GLU F 259      -9.832  83.618  33.328  1.00 77.57           C  
ATOM  11232  C   GLU F 259     -10.362  82.235  33.706  1.00 77.24           C  
ATOM  11233  O   GLU F 259     -11.546  81.936  33.491  1.00 76.89           O  
ATOM  11234  CB  GLU F 259      -8.802  83.511  32.184  1.00 77.60           C  
ATOM  11235  CG  GLU F 259      -9.344  83.047  30.826  1.00 78.40           C  
ATOM  11236  CD  GLU F 259      -8.242  82.505  29.893  1.00 79.48           C  
ATOM  11237  OE1 GLU F 259      -7.687  81.409  30.170  1.00 81.50           O  
ATOM  11238  OE2 GLU F 259      -7.935  83.162  28.866  1.00 82.43           O  
ATOM  11239  N   LYS F 260      -9.489  81.406  34.284  1.00 76.69           N  
ATOM  11240  CA  LYS F 260      -9.877  80.067  34.703  1.00 76.64           C  
ATOM  11241  C   LYS F 260     -11.151  80.102  35.539  1.00 76.23           C  
ATOM  11242  O   LYS F 260     -12.056  79.293  35.336  1.00 76.40           O  
ATOM  11243  CB  LYS F 260      -8.775  79.428  35.536  1.00 76.85           C  
ATOM  11244  CG  LYS F 260      -7.581  78.965  34.748  1.00 78.81           C  
ATOM  11245  CD  LYS F 260      -7.730  77.539  34.224  1.00 80.53           C  
ATOM  11246  CE  LYS F 260      -6.384  76.998  33.726  1.00 81.00           C  
ATOM  11247  NZ  LYS F 260      -5.711  77.896  32.733  1.00 80.54           N  
ATOM  11248  N   LYS F 261     -11.201  81.030  36.492  1.00 75.64           N  
ATOM  11249  CA  LYS F 261     -12.321  81.122  37.413  1.00 75.44           C  
ATOM  11250  C   LYS F 261     -13.608  81.499  36.672  1.00 75.05           C  
ATOM  11251  O   LYS F 261     -14.657  80.938  36.945  1.00 74.54           O  
ATOM  11252  CB  LYS F 261     -12.010  82.095  38.555  1.00 75.60           C  
ATOM  11253  CG  LYS F 261     -11.062  81.506  39.612  1.00 75.95           C  
ATOM  11254  CD  LYS F 261     -10.317  82.592  40.380  1.00 77.65           C  
ATOM  11255  CE  LYS F 261      -9.135  82.050  41.207  1.00 79.02           C  
ATOM  11256  NZ  LYS F 261      -7.973  83.042  41.308  1.00 80.13           N  
ATOM  11257  N   LEU F 262     -13.508  82.419  35.716  1.00 74.84           N  
ATOM  11258  CA  LEU F 262     -14.638  82.752  34.840  1.00 74.67           C  
ATOM  11259  C   LEU F 262     -14.999  81.570  33.937  1.00 74.59           C  
ATOM  11260  O   LEU F 262     -16.170  81.259  33.759  1.00 74.26           O  
ATOM  11261  CB  LEU F 262     -14.320  83.984  33.995  1.00 74.27           C  
ATOM  11262  CG  LEU F 262     -14.114  85.270  34.799  1.00 74.26           C  
ATOM  11263  CD1 LEU F 262     -13.526  86.343  33.922  1.00 73.88           C  
ATOM  11264  CD2 LEU F 262     -15.427  85.748  35.422  1.00 74.08           C  
ATOM  11265  N   PHE F 263     -13.979  80.913  33.387  1.00 74.83           N  
ATOM  11266  CA  PHE F 263     -14.153  79.706  32.583  1.00 74.86           C  
ATOM  11267  C   PHE F 263     -14.864  78.611  33.364  1.00 75.33           C  
ATOM  11268  O   PHE F 263     -15.640  77.861  32.785  1.00 75.58           O  
ATOM  11269  CB  PHE F 263     -12.798  79.195  32.076  1.00 74.82           C  
ATOM  11270  CG  PHE F 263     -12.847  77.818  31.461  1.00 74.48           C  
ATOM  11271  CD1 PHE F 263     -13.292  77.641  30.166  1.00 74.62           C  
ATOM  11272  CD2 PHE F 263     -12.433  76.711  32.170  1.00 74.31           C  
ATOM  11273  CE1 PHE F 263     -13.341  76.380  29.592  1.00 74.37           C  
ATOM  11274  CE2 PHE F 263     -12.478  75.452  31.604  1.00 74.62           C  
ATOM  11275  CZ  PHE F 263     -12.934  75.288  30.310  1.00 74.40           C  
ATOM  11276  N   TYR F 264     -14.598  78.511  34.664  1.00 75.66           N  
ATOM  11277  CA  TYR F 264     -15.358  77.599  35.521  1.00 76.10           C  
ATOM  11278  C   TYR F 264     -16.792  78.107  35.739  1.00 75.78           C  
ATOM  11279  O   TYR F 264     -17.731  77.322  35.747  1.00 75.85           O  
ATOM  11280  CB  TYR F 264     -14.658  77.390  36.874  1.00 76.77           C  
ATOM  11281  CG  TYR F 264     -13.276  76.745  36.811  1.00 77.50           C  
ATOM  11282  CD1 TYR F 264     -12.862  76.022  35.693  1.00 78.22           C  
ATOM  11283  CD2 TYR F 264     -12.402  76.826  37.895  1.00 78.23           C  
ATOM  11284  CE1 TYR F 264     -11.613  75.425  35.642  1.00 78.54           C  
ATOM  11285  CE2 TYR F 264     -11.147  76.229  37.854  1.00 78.63           C  
ATOM  11286  CZ  TYR F 264     -10.761  75.527  36.721  1.00 78.75           C  
ATOM  11287  OH  TYR F 264      -9.529  74.925  36.646  1.00 78.54           O  
ATOM  11288  N   SER F 265     -16.951  79.415  35.906  1.00 75.45           N  
ATOM  11289  CA  SER F 265     -18.265  80.025  36.088  1.00 75.61           C  
ATOM  11290  C   SER F 265     -19.248  79.673  34.967  1.00 75.51           C  
ATOM  11291  O   SER F 265     -20.444  79.456  35.221  1.00 74.97           O  
ATOM  11292  CB  SER F 265     -18.146  81.553  36.178  1.00 75.65           C  
ATOM  11293  OG  SER F 265     -17.509  81.947  37.376  1.00 76.42           O  
ATOM  11294  N   THR F 266     -18.746  79.621  33.732  1.00 75.12           N  
ATOM  11295  CA  THR F 266     -19.604  79.339  32.587  1.00 75.03           C  
ATOM  11296  C   THR F 266     -20.386  78.038  32.770  1.00 74.87           C  
ATOM  11297  O   THR F 266     -21.492  77.909  32.263  1.00 74.97           O  
ATOM  11298  CB  THR F 266     -18.809  79.244  31.282  1.00 74.79           C  
ATOM  11299  OG1 THR F 266     -17.851  78.183  31.393  1.00 75.65           O  
ATOM  11300  CG2 THR F 266     -18.107  80.554  30.993  1.00 74.26           C  
ATOM  11301  N   PHE F 267     -19.808  77.088  33.500  1.00 74.72           N  
ATOM  11302  CA  PHE F 267     -20.449  75.798  33.755  1.00 74.83           C  
ATOM  11303  C   PHE F 267     -21.598  75.874  34.765  1.00 74.86           C  
ATOM  11304  O   PHE F 267     -22.310  74.895  34.969  1.00 74.70           O  
ATOM  11305  CB  PHE F 267     -19.411  74.761  34.190  1.00 74.87           C  
ATOM  11306  CG  PHE F 267     -18.475  74.367  33.090  1.00 74.65           C  
ATOM  11307  CD1 PHE F 267     -17.471  75.221  32.686  1.00 74.31           C  
ATOM  11308  CD2 PHE F 267     -18.624  73.161  32.438  1.00 74.85           C  
ATOM  11309  CE1 PHE F 267     -16.621  74.873  31.671  1.00 75.10           C  
ATOM  11310  CE2 PHE F 267     -17.775  72.804  31.414  1.00 74.98           C  
ATOM  11311  CZ  PHE F 267     -16.773  73.662  31.028  1.00 75.23           C  
ATOM  11312  N   ALA F 268     -21.759  77.035  35.397  1.00 74.93           N  
ATOM  11313  CA  ALA F 268     -22.904  77.317  36.241  1.00 74.86           C  
ATOM  11314  C   ALA F 268     -24.093  77.753  35.387  1.00 74.91           C  
ATOM  11315  O   ALA F 268     -25.236  77.699  35.841  1.00 74.50           O  
ATOM  11316  CB  ALA F 268     -22.553  78.401  37.263  1.00 74.67           C  
ATOM  11317  N   THR F 269     -23.826  78.167  34.151  1.00 75.07           N  
ATOM  11318  CA  THR F 269     -24.865  78.735  33.296  1.00 75.57           C  
ATOM  11319  C   THR F 269     -25.486  77.685  32.372  1.00 75.98           C  
ATOM  11320  O   THR F 269     -24.833  76.704  32.008  1.00 76.31           O  
ATOM  11321  CB  THR F 269     -24.317  79.896  32.453  1.00 75.47           C  
ATOM  11322  OG1 THR F 269     -23.526  79.386  31.377  1.00 75.82           O  
ATOM  11323  CG2 THR F 269     -23.474  80.833  33.305  1.00 75.39           C  
ATOM  11324  N   ASP F 270     -26.748  77.907  32.003  1.00 76.33           N  
ATOM  11325  CA  ASP F 270     -27.471  77.031  31.074  1.00 76.73           C  
ATOM  11326  C   ASP F 270     -26.963  77.166  29.642  1.00 76.90           C  
ATOM  11327  O   ASP F 270     -26.878  76.183  28.909  1.00 77.15           O  
ATOM  11328  CB  ASP F 270     -28.978  77.344  31.087  1.00 76.70           C  
ATOM  11329  CG  ASP F 270     -29.615  77.133  32.451  1.00 77.06           C  
ATOM  11330  OD1 ASP F 270     -29.060  76.359  33.265  1.00 77.57           O  
ATOM  11331  OD2 ASP F 270     -30.681  77.740  32.705  1.00 77.83           O  
ATOM  11332  N   ASP F 271     -26.629  78.387  29.244  1.00 77.20           N  
ATOM  11333  CA  ASP F 271     -26.214  78.655  27.871  1.00 77.44           C  
ATOM  11334  C   ASP F 271     -24.924  77.945  27.453  1.00 77.67           C  
ATOM  11335  O   ASP F 271     -24.657  77.811  26.258  1.00 78.14           O  
ATOM  11336  CB  ASP F 271     -26.080  80.162  27.644  1.00 77.51           C  
ATOM  11337  CG  ASP F 271     -27.423  80.844  27.410  1.00 77.62           C  
ATOM  11338  OD1 ASP F 271     -28.475  80.159  27.445  1.00 77.98           O  
ATOM  11339  OD2 ASP F 271     -27.424  82.077  27.185  1.00 77.57           O  
ATOM  11340  N   ARG F 272     -24.126  77.498  28.416  1.00 77.65           N  
ATOM  11341  CA  ARG F 272     -22.951  76.691  28.101  1.00 77.76           C  
ATOM  11342  C   ARG F 272     -23.333  75.211  27.979  1.00 77.95           C  
ATOM  11343  O   ARG F 272     -22.896  74.532  27.054  1.00 77.80           O  
ATOM  11344  CB  ARG F 272     -21.848  76.925  29.142  1.00 77.81           C  
ATOM  11345  CG  ARG F 272     -20.709  75.920  29.115  1.00 77.26           C  
ATOM  11346  CD  ARG F 272     -20.844  75.001  30.292  1.00 77.92           C  
ATOM  11347  NE  ARG F 272     -20.942  73.592  29.930  1.00 78.22           N  
ATOM  11348  CZ  ARG F 272     -21.692  72.699  30.577  1.00 78.97           C  
ATOM  11349  NH1 ARG F 272     -21.697  71.437  30.170  1.00 79.54           N  
ATOM  11350  NH2 ARG F 272     -22.456  73.050  31.614  1.00 79.26           N  
ATOM  11351  N   LYS F 273     -24.150  74.716  28.903  1.00 78.35           N  
ATOM  11352  CA  LYS F 273     -24.723  73.373  28.777  1.00 78.79           C  
ATOM  11353  C   LYS F 273     -25.397  73.241  27.411  1.00 79.08           C  
ATOM  11354  O   LYS F 273     -25.253  72.225  26.724  1.00 79.06           O  
ATOM  11355  CB  LYS F 273     -25.739  73.097  29.900  1.00 78.78           C  
ATOM  11356  CG  LYS F 273     -26.087  71.618  30.106  1.00 79.07           C  
ATOM  11357  CD  LYS F 273     -27.351  71.435  30.962  1.00 78.67           C  
ATOM  11358  N   GLU F 274     -26.114  74.292  27.021  1.00 79.51           N  
ATOM  11359  CA  GLU F 274     -26.854  74.313  25.762  1.00 79.89           C  
ATOM  11360  C   GLU F 274     -25.939  74.448  24.548  1.00 80.04           C  
ATOM  11361  O   GLU F 274     -26.214  73.877  23.489  1.00 79.80           O  
ATOM  11362  CB  GLU F 274     -27.880  75.453  25.788  1.00 79.96           C  
ATOM  11363  CG  GLU F 274     -28.604  75.725  24.469  1.00 80.54           C  
ATOM  11364  CD  GLU F 274     -29.398  74.537  23.949  1.00 81.06           C  
ATOM  11365  OE1 GLU F 274     -29.452  73.486  24.629  1.00 81.49           O  
ATOM  11366  OE2 GLU F 274     -29.976  74.663  22.848  1.00 81.01           O  
ATOM  11367  N   GLY F 275     -24.862  75.214  24.703  1.00 80.46           N  
ATOM  11368  CA  GLY F 275     -23.938  75.479  23.605  1.00 80.71           C  
ATOM  11369  C   GLY F 275     -23.135  74.252  23.220  1.00 80.97           C  
ATOM  11370  O   GLY F 275     -22.952  73.960  22.038  1.00 80.92           O  
ATOM  11371  N   MET F 276     -22.669  73.524  24.228  1.00 81.34           N  
ATOM  11372  CA  MET F 276     -21.850  72.342  23.999  1.00 81.79           C  
ATOM  11373  C   MET F 276     -22.669  71.129  23.561  1.00 81.74           C  
ATOM  11374  O   MET F 276     -22.204  70.351  22.731  1.00 81.80           O  
ATOM  11375  CB  MET F 276     -21.019  72.010  25.243  1.00 81.77           C  
ATOM  11376  CG  MET F 276     -19.834  72.945  25.442  1.00 81.90           C  
ATOM  11377  SD  MET F 276     -18.769  72.409  26.793  1.00 83.09           S  
ATOM  11378  CE  MET F 276     -17.659  73.807  26.951  1.00 81.04           C  
ATOM  11379  N   THR F 277     -23.874  70.960  24.105  1.00 81.86           N  
ATOM  11380  CA  THR F 277     -24.702  69.808  23.732  1.00 81.96           C  
ATOM  11381  C   THR F 277     -25.287  69.976  22.322  1.00 82.09           C  
ATOM  11382  O   THR F 277     -25.549  68.987  21.632  1.00 82.10           O  
ATOM  11383  CB  THR F 277     -25.823  69.525  24.758  1.00 81.98           C  
ATOM  11384  OG1 THR F 277     -26.705  70.649  24.842  1.00 82.21           O  
ATOM  11385  CG2 THR F 277     -25.238  69.228  26.135  1.00 81.69           C  
ATOM  11386  N   ALA F 278     -25.479  71.226  21.899  1.00 82.18           N  
ATOM  11387  CA  ALA F 278     -25.869  71.531  20.519  1.00 82.22           C  
ATOM  11388  C   ALA F 278     -24.751  71.165  19.538  1.00 82.26           C  
ATOM  11389  O   ALA F 278     -25.019  70.734  18.415  1.00 82.37           O  
ATOM  11390  CB  ALA F 278     -26.223  73.007  20.379  1.00 82.11           C  
ATOM  11391  N   PHE F 279     -23.505  71.344  19.963  1.00 82.21           N  
ATOM  11392  CA  PHE F 279     -22.357  71.020  19.123  1.00 82.38           C  
ATOM  11393  C   PHE F 279     -22.226  69.510  18.929  1.00 82.39           C  
ATOM  11394  O   PHE F 279     -22.080  69.039  17.804  1.00 82.38           O  
ATOM  11395  CB  PHE F 279     -21.074  71.589  19.730  1.00 82.48           C  
ATOM  11396  CG  PHE F 279     -19.844  71.333  18.908  1.00 82.48           C  
ATOM  11397  CD1 PHE F 279     -19.426  72.253  17.954  1.00 82.84           C  
ATOM  11398  CD2 PHE F 279     -19.095  70.176  19.096  1.00 82.56           C  
ATOM  11399  CE1 PHE F 279     -18.279  72.025  17.194  1.00 83.10           C  
ATOM  11400  CE2 PHE F 279     -17.950  69.934  18.343  1.00 82.98           C  
ATOM  11401  CZ  PHE F 279     -17.541  70.862  17.389  1.00 83.27           C  
ATOM  11402  N   VAL F 280     -22.285  68.757  20.021  1.00 82.41           N  
ATOM  11403  CA  VAL F 280     -22.142  67.302  19.951  1.00 82.56           C  
ATOM  11404  C   VAL F 280     -23.340  66.642  19.252  1.00 82.59           C  
ATOM  11405  O   VAL F 280     -23.202  65.558  18.686  1.00 82.63           O  
ATOM  11406  CB  VAL F 280     -21.931  66.668  21.350  1.00 82.64           C  
ATOM  11407  CG1 VAL F 280     -21.725  65.156  21.234  1.00 82.57           C  
ATOM  11408  CG2 VAL F 280     -20.735  67.310  22.054  1.00 82.57           C  
ATOM  11409  N   GLU F 281     -24.500  67.295  19.286  1.00 82.63           N  
ATOM  11410  CA  GLU F 281     -25.674  66.837  18.527  1.00 82.63           C  
ATOM  11411  C   GLU F 281     -25.742  67.435  17.109  1.00 82.78           C  
ATOM  11412  O   GLU F 281     -26.729  67.238  16.402  1.00 82.76           O  
ATOM  11413  CB  GLU F 281     -26.965  67.144  19.301  1.00 82.65           C  
ATOM  11414  CG  GLU F 281     -27.110  66.326  20.589  1.00 82.55           C  
ATOM  11415  CD  GLU F 281     -28.393  66.623  21.360  1.00 82.29           C  
ATOM  11416  OE1 GLU F 281     -29.173  67.501  20.934  1.00 81.23           O  
ATOM  11417  OE2 GLU F 281     -28.616  65.972  22.404  1.00 81.63           O  
ATOM  11418  N   LYS F 282     -24.695  68.158  16.704  1.00 83.04           N  
ATOM  11419  CA  LYS F 282     -24.570  68.714  15.346  1.00 83.09           C  
ATOM  11420  C   LYS F 282     -25.783  69.565  14.930  1.00 83.22           C  
ATOM  11421  O   LYS F 282     -26.533  69.186  14.032  1.00 83.08           O  
ATOM  11422  CB  LYS F 282     -24.325  67.585  14.328  1.00 83.06           C  
ATOM  11423  CG  LYS F 282     -23.096  66.730  14.612  1.00 82.65           C  
ATOM  11424  N   ARG F 283     -25.969  70.710  15.586  1.00 83.37           N  
ATOM  11425  CA  ARG F 283     -27.104  71.598  15.284  1.00 83.42           C  
ATOM  11426  C   ARG F 283     -26.894  73.039  15.775  1.00 83.55           C  
ATOM  11427  O   ARG F 283     -25.889  73.340  16.438  1.00 83.77           O  
ATOM  11428  CB  ARG F 283     -28.396  71.025  15.873  1.00 83.35           C  
ATOM  11429  CG  ARG F 283     -28.391  70.809  17.388  1.00 83.37           C  
ATOM  11430  CD  ARG F 283     -29.828  70.726  17.921  1.00 83.40           C  
ATOM  11431  NE  ARG F 283     -29.912  70.375  19.341  1.00 83.35           N  
ATOM  11432  CZ  ARG F 283     -29.659  71.205  20.356  1.00 83.27           C  
ATOM  11433  NH1 ARG F 283     -29.278  72.464  20.140  1.00 82.99           N  
ATOM  11434  NH2 ARG F 283     -29.779  70.766  21.604  1.00 83.03           N  
ATOM  11435  N   LYS F 284     -27.840  73.917  15.429  1.00 83.56           N  
ATOM  11436  CA  LYS F 284     -27.834  75.321  15.868  1.00 83.57           C  
ATOM  11437  C   LYS F 284     -28.376  75.449  17.294  1.00 83.74           C  
ATOM  11438  O   LYS F 284     -29.374  74.814  17.644  1.00 83.79           O  
ATOM  11439  CB  LYS F 284     -28.661  76.194  14.920  1.00 83.38           C  
ATOM  11440  N   ALA F 285     -27.717  76.282  18.102  1.00 83.94           N  
ATOM  11441  CA  ALA F 285     -28.023  76.411  19.533  1.00 84.03           C  
ATOM  11442  C   ALA F 285     -28.973  77.571  19.813  1.00 84.12           C  
ATOM  11443  O   ALA F 285     -28.971  78.572  19.098  1.00 84.07           O  
ATOM  11444  CB  ALA F 285     -26.736  76.587  20.337  1.00 83.83           C  
ATOM  11445  N   ASN F 286     -29.763  77.428  20.875  1.00 84.37           N  
ATOM  11446  CA  ASN F 286     -30.728  78.445  21.288  1.00 84.63           C  
ATOM  11447  C   ASN F 286     -30.365  79.019  22.659  1.00 84.67           C  
ATOM  11448  O   ASN F 286     -30.665  78.418  23.696  1.00 84.72           O  
ATOM  11449  CB  ASN F 286     -32.147  77.853  21.308  1.00 84.66           C  
ATOM  11450  CG  ASN F 286     -33.230  78.915  21.194  1.00 85.06           C  
ATOM  11451  OD1 ASN F 286     -32.943  80.115  21.120  1.00 85.22           O  
ATOM  11452  ND2 ASN F 286     -34.487  78.476  21.169  1.00 85.02           N  
ATOM  11453  N   PHE F 287     -29.717  80.181  22.655  1.00 84.69           N  
ATOM  11454  CA  PHE F 287     -29.251  80.815  23.886  1.00 84.81           C  
ATOM  11455  C   PHE F 287     -30.349  81.674  24.491  1.00 85.00           C  
ATOM  11456  O   PHE F 287     -31.010  82.420  23.774  1.00 85.12           O  
ATOM  11457  CB  PHE F 287     -28.024  81.688  23.616  1.00 84.67           C  
ATOM  11458  CG  PHE F 287     -26.844  80.928  23.075  1.00 84.66           C  
ATOM  11459  CD1 PHE F 287     -26.143  80.035  23.881  1.00 84.89           C  
ATOM  11460  CD2 PHE F 287     -26.426  81.107  21.764  1.00 84.34           C  
ATOM  11461  CE1 PHE F 287     -25.046  79.336  23.383  1.00 84.58           C  
ATOM  11462  CE2 PHE F 287     -25.338  80.409  21.262  1.00 84.54           C  
ATOM  11463  CZ  PHE F 287     -24.645  79.525  22.074  1.00 84.53           C  
ATOM  11464  N   LYS F 288     -30.526  81.566  25.810  1.00 85.30           N  
ATOM  11465  CA  LYS F 288     -31.520  82.350  26.550  1.00 85.55           C  
ATOM  11466  C   LYS F 288     -30.877  83.362  27.519  1.00 85.84           C  
ATOM  11467  O   LYS F 288     -31.533  83.849  28.439  1.00 85.69           O  
ATOM  11468  CB  LYS F 288     -32.468  81.410  27.303  1.00 85.55           C  
ATOM  11469  CG  LYS F 288     -33.288  80.494  26.395  1.00 85.44           C  
ATOM  11470  N   ASP F 289     -29.599  83.676  27.294  1.00 86.37           N  
ATOM  11471  CA  ASP F 289     -28.863  84.694  28.073  1.00 86.72           C  
ATOM  11472  C   ASP F 289     -28.906  84.417  29.572  1.00 86.68           C  
ATOM  11473  O   ASP F 289     -29.182  85.305  30.382  1.00 86.78           O  
ATOM  11474  CB  ASP F 289     -29.399  86.099  27.764  1.00 86.84           C  
ATOM  11475  CG  ASP F 289     -29.328  86.433  26.285  1.00 87.41           C  
ATOM  11476  OD1 ASP F 289     -28.368  85.978  25.621  1.00 88.23           O  
ATOM  11477  OD2 ASP F 289     -30.226  87.150  25.786  1.00 87.43           O  
ATOM  11478  N   GLN F 290     -28.601  83.173  29.921  1.00 86.69           N  
ATOM  11479  CA  GLN F 290     -28.774  82.658  31.275  1.00 86.59           C  
ATOM  11480  C   GLN F 290     -27.832  81.463  31.472  1.00 86.45           C  
ATOM  11481  O   GLN F 290     -26.897  81.302  30.693  1.00 86.11           O  
ATOM  11482  CB  GLN F 290     -30.227  82.226  31.449  1.00 86.53           C  
ATOM  11483  CG  GLN F 290     -30.729  82.216  32.873  1.00 86.72           C  
ATOM  11484  CD  GLN F 290     -32.120  81.628  32.981  1.00 86.97           C  
ATOM  11485  OE1 GLN F 290     -32.742  81.275  31.978  1.00 86.69           O  
ATOM  11486  NE2 GLN F 290     -32.615  81.514  34.204  1.00 87.62           N  
ATOM  11487  OXT GLN F 290     -27.972  80.626  32.371  1.00 86.45           O  
TER   11488      GLN F 290                                                      
END
MOLECULE T0486_32_232.pdb
ATOM      1  N   PRO    32     -34.619 118.105  22.201  1.00 36.37          
ATOM      2  CA  PRO    32     -33.499 118.122  21.209  1.00 35.38          
ATOM      4  CB  PRO    32     -33.430 119.614  20.792  1.00 35.70          
ATOM      7  CG  PRO    32     -33.972 120.393  22.069  1.00 36.10          
ATOM     10  CD  PRO    32     -34.671 119.355  22.997  1.00 36.93          
ATOM     13  C   PRO    32     -32.165 117.592  21.848  1.00 33.74          
ATOM     14  O   PRO    32     -31.732 118.103  22.927  1.00 33.85          
ATOM     17  N   ARG    33     -31.582 116.543  21.238  1.00 30.52          
ATOM     18  CA  ARG    33     -30.447 115.793  21.849  1.00 27.98          
ATOM     20  CB  ARG    33     -30.865 114.408  22.341  1.00 28.20          
ATOM     23  CG  ARG    33     -31.393 114.428  23.789  1.00 29.12          
ATOM     26  CD  ARG    33     -32.244 113.222  24.112  1.00 29.44          
ATOM     29  NE  ARG    33     -31.441 112.010  24.221  1.00 34.76          
ATOM     31  CZ  ARG    33     -30.684 111.700  25.275  1.00 35.22          
ATOM     32  NH1 ARG    33     -30.631 112.499  26.343  1.00 36.88          
ATOM     35  NH2 ARG    33     -29.978 110.588  25.259  1.00 32.19          
ATOM     38  C   ARG    33     -29.262 115.677  20.906  1.00 25.16          
ATOM     39  O   ARG    33     -29.423 115.490  19.701  1.00 24.96          
ATOM     41  N   PRO    34     -28.053 115.856  21.441  1.00 22.90          
ATOM     42  CA  PRO    34     -26.892 115.796  20.552  1.00 21.60          
ATOM     44  CB  PRO    34     -25.813 116.476  21.373  1.00 21.42          
ATOM     47  CG  PRO    34     -26.259 116.398  22.777  1.00 21.04          
ATOM     50  CD  PRO    34     -27.713 116.344  22.796  1.00 21.80          
ATOM     53  C   PRO    34     -26.530 114.359  20.058  1.00 21.60          
ATOM     54  O   PRO    34     -25.855 114.222  19.035  1.00 19.72          
ATOM     55  N   THR    35     -27.041 113.315  20.739  1.00 21.90          
ATOM     56  CA  THR    35     -27.051 111.948  20.185  1.00 23.12          
ATOM     58  CB  THR    35     -26.409 110.928  21.125  1.00 22.50          
ATOM     60  OG1 THR    35     -27.132 110.918  22.364  1.00 25.34          
ATOM     62  CG2 THR    35     -24.919 111.265  21.369  1.00 21.08          
ATOM     66  C   THR    35     -28.454 111.425  19.823  1.00 23.98          
ATOM     67  O   THR    35     -29.444 111.807  20.428  1.00 23.83          
ATOM     69  N   SER    36     -28.514 110.537  18.832  1.00 25.38          
ATOM     70  CA  SER    36     -29.722 109.737  18.544  1.00 26.75          
ATOM     72  CB  SER    36     -30.314 110.035  17.140  1.00 27.55          
ATOM     75  OG  SER    36     -29.338 110.522  16.226  1.00 30.93          
ATOM     77  C   SER    36     -29.398 108.260  18.650  1.00 26.57          
ATOM     78  O   SER    36     -28.336 107.810  18.248  1.00 27.02          
ATOM     80  N   ALA    37     -30.314 107.511  19.238  1.00 26.96          
ATOM     81  CA  ALA    37     -30.143 106.081  19.431  1.00 27.11          
ATOM     83  CB  ALA    37     -29.956 105.773  20.900  1.00 26.60          
ATOM     87  C   ALA    37     -31.372 105.383  18.908  1.00 27.34          
ATOM     88  O   ALA    37     -32.470 105.853  19.106  1.00 28.07          
ATOM     90  N   ARG    38     -31.190 104.251  18.246  1.00 27.41          
ATOM     91  CA  ARG    38     -32.296 103.405  17.847  1.00 27.20          
ATOM     93  CB  ARG    38     -32.659 103.679  16.387  1.00 27.68          
ATOM     96  CG  ARG    38     -31.555 103.196  15.435  1.00 32.69          
ATOM     99  CD  ARG    38     -31.659 103.719  14.024  1.00 41.47          
ATOM    102  NE  ARG    38     -30.354 103.705  13.320  1.00 45.71          
ATOM    104  CZ  ARG    38     -29.427 104.668  13.420  1.00 50.50          
ATOM    105  NH1 ARG    38     -29.618 105.741  14.231  1.00 50.89          
ATOM    108  NH2 ARG    38     -28.289 104.552  12.723  1.00 52.00          
ATOM    111  C   ARG    38     -31.815 101.967  18.007  1.00 25.56          
ATOM    112  O   ARG    38     -30.678 101.662  17.715  1.00 25.50          
ATOM    114  N   GLN    39     -32.704 101.090  18.416  1.00 24.27          
ATOM    115  CA  GLN    39     -32.419  99.696  18.607  1.00 23.41          
ATOM    117  CB  GLN    39     -32.504  99.381  20.098  1.00 22.43          
ATOM    120  CG  GLN    39     -32.031  98.004  20.463  1.00 20.76          
ATOM    123  CD  GLN    39     -32.101  97.804  21.945  1.00 19.82          
ATOM    124  OE1 GLN    39     -31.617  98.641  22.700  1.00 21.67          
ATOM    125  NE2 GLN    39     -32.718  96.729  22.382  1.00 18.57          
ATOM    128  C   GLN    39     -33.376  98.795  17.807  1.00 23.80          
ATOM    129  O   GLN    39     -34.607  98.928  17.836  1.00 22.33          
ATOM    131  N   LEU    40     -32.781  97.833  17.122  1.00 24.93          
ATOM    132  CA  LEU    40     -33.517  96.918  16.193  1.00 24.93          
ATOM    134  CB  LEU    40     -33.638  97.621  14.868  1.00 23.82          
ATOM    137  CG  LEU    40     -34.317  97.048  13.632  1.00 25.78          
ATOM    139  CD1 LEU    40     -35.754  96.407  13.794  1.00 22.15          
ATOM    143  CD2 LEU    40     -34.332  98.285  12.734  1.00 27.38          
ATOM    147  C   LEU    40     -32.727  95.579  16.056  1.00 24.92          
ATOM    148  O   LEU    40     -31.532  95.556  15.665  1.00 24.12          
ATOM    150  N   ASP    41     -33.397  94.485  16.407  1.00 24.46          
ATOM    151  CA  ASP    41     -32.832  93.138  16.324  1.00 23.32          
ATOM    153  CB  ASP    41     -32.497  92.813  14.881  1.00 23.91          
ATOM    156  CG  ASP    41     -33.714  92.826  14.019  1.00 24.72          
ATOM    157  OD1 ASP    41     -34.776  92.365  14.493  1.00 26.36          
ATOM    158  OD2 ASP    41     -33.611  93.311  12.880  1.00 28.80          
ATOM    159  C   ASP    41     -31.614  92.967  17.229  1.00 21.87          
ATOM    160  O   ASP    41     -30.626  92.310  16.860  1.00 20.53          
ATOM    162  N   GLY    42     -31.746  93.566  18.411  1.00 20.42          
ATOM    163  CA  GLY    42     -30.736  93.512  19.459  1.00 20.29          
ATOM    166  C   GLY    42     -29.595  94.500  19.363  1.00 19.56          
ATOM    167  O   GLY    42     -28.794  94.588  20.317  1.00 18.21          
ATOM    169  N   ILE    43     -29.524  95.210  18.216  1.00 18.49          
ATOM    170  CA  ILE    43     -28.446  96.171  17.861  1.00 18.12          
ATOM    172  CB  ILE    43     -27.947  96.049  16.350  1.00 17.15          
ATOM    174  CG1 ILE    43     -27.750  94.566  15.978  1.00 17.41          
ATOM    177  CD  ILE    43     -27.448  94.223  14.517  1.00 10.50          
ATOM    181  CG2 ILE    43     -26.679  96.919  16.144  1.00 16.46          
ATOM    185  C   ILE    43     -28.914  97.604  18.115  1.00 18.28          
ATOM    186  O   ILE    43     -29.876  98.098  17.509  1.00 18.83          
ATOM    188  N   ARG    44     -28.217  98.262  19.026  1.00 19.01          
ATOM    189  CA  ARG    44     -28.426  99.669  19.350  1.00 18.37          
ATOM    191  CB  ARG    44     -28.251  99.867  20.862  1.00 17.76          
ATOM    194  CG  ARG    44     -28.759 101.185  21.386  1.00 16.54          
ATOM    197  CD  ARG    44     -28.557 101.298  22.871  1.00 13.79          
ATOM    200  NE  ARG    44     -29.614 100.601  23.569  1.00 16.47          
ATOM    202  CZ  ARG    44     -29.743 100.548  24.895  1.00 14.91          
ATOM    203  NH1 ARG    44     -28.873 101.103  25.694  1.00 16.61          
ATOM    206  NH2 ARG    44     -30.739  99.908  25.406  1.00 13.62          
ATOM    209  C   ARG    44     -27.374 100.471  18.614  1.00 18.83          
ATOM    210  O   ARG    44     -26.207 100.233  18.807  1.00 19.07          
ATOM    212  N   ASN    45     -27.790 101.381  17.737  1.00 20.00          
ATOM    213  CA  ASN    45     -26.902 102.386  17.160  1.00 21.31          
ATOM    215  CB  ASN    45     -27.254 102.653  15.690  1.00 22.09          
ATOM    218  CG  ASN    45     -26.607 101.671  14.767  1.00 25.78          
ATOM    219  OD1 ASN    45     -25.428 101.800  14.420  1.00 29.25          
ATOM    220  ND2 ASN    45     -27.368 100.646  14.370  1.00 29.97          
ATOM    223  C   ASN    45     -27.097 103.694  17.913  1.00 20.17          
ATOM    224  O   ASN    45     -28.210 104.202  17.948  1.00 18.97          
ATOM    226  N   ILE    46     -26.014 104.210  18.466  1.00 18.93          
ATOM    227  CA  ILE    46     -25.987 105.493  19.103  1.00 19.48          
ATOM    229  CB  ILE    46     -25.365 105.470  20.503  1.00 20.23          
ATOM    231  CG1 ILE    46     -25.959 104.315  21.334  1.00 18.43          
ATOM    234  CD  ILE    46     -25.395 104.142  22.715  1.00 16.72          
ATOM    238  CG2 ILE    46     -25.657 106.813  21.251  1.00 21.84          
ATOM    242  C   ILE    46     -25.153 106.373  18.195  1.00 19.86          
ATOM    243  O   ILE    46     -24.007 106.093  17.927  1.00 19.65          
ATOM    245  N   VAL    47     -25.783 107.396  17.626  1.00 19.12          
ATOM    246  CA  VAL    47     -25.130 108.216  16.637  1.00 17.92          
ATOM    248  CB  VAL    47     -26.000 108.295  15.342  1.00 18.43          
ATOM    250  CG1 VAL    47     -25.252 109.065  14.230  1.00 14.15          
ATOM    254  CG2 VAL    47     -26.458 106.884  14.946  1.00 15.51          
ATOM    258  C   VAL    47     -24.874 109.613  17.222  1.00 18.23          
ATOM    259  O   VAL    47     -25.789 110.245  17.749  1.00 16.54          
ATOM    261  N   LEU    48     -23.597 110.026  17.180  1.00 19.26          
ATOM    262  CA  LEU    48     -23.140 111.408  17.516  1.00 19.61          
ATOM    264  CB  LEU    48     -21.612 111.473  17.583  1.00 19.28          
ATOM    267  CG  LEU    48     -20.809 111.031  18.827  1.00 21.00          
ATOM    269  CD1 LEU    48     -21.282 109.801  19.431  1.00 21.01          
ATOM    273  CD2 LEU    48     -19.254 110.978  18.591  1.00 20.34          
ATOM    277  C   LEU    48     -23.683 112.346  16.433  1.00 19.02          
ATOM    278  O   LEU    48     -23.265 112.242  15.284  1.00 19.61          
ATOM    280  N   SER    49     -24.629 113.228  16.817  1.00 19.00          
ATOM    281  CA  SER    49     -25.459 113.967  15.907  1.00 19.54          
ATOM    283  CB  SER    49     -26.956 113.575  16.017  1.00 19.42          
ATOM    286  OG  SER    49     -27.184 112.207  15.968  1.00 22.18          
ATOM    288  C   SER    49     -25.374 115.453  16.188  1.00 19.35          
ATOM    289  O   SER    49     -26.415 116.121  16.348  1.00 20.03          
ATOM    291  N   ASN    50     -24.167 115.992  16.192  1.00 18.55          
ATOM    292  CA  ASN    50     -23.986 117.427  16.208  1.00 18.37          
ATOM    294  CB  ASN    50     -23.746 117.909  17.661  1.00 18.55          
ATOM    297  CG  ASN    50     -23.854 119.443  17.836  1.00 20.36          
ATOM    298  OD1 ASN    50     -24.433 120.176  17.010  1.00 23.36          
ATOM    299  ND2 ASN    50     -23.307 119.920  18.928  1.00 20.58          
ATOM    302  C   ASN    50     -22.845 117.817  15.253  1.00 17.76          
ATOM    303  O   ASN    50     -21.879 118.424  15.685  1.00 16.99          
ATOM    305  N   PRO    51     -22.976 117.488  13.948  1.00 17.55          
ATOM    306  CA  PRO    51     -21.879 117.662  12.995  1.00 17.89          
ATOM    308  CB  PRO    51     -22.410 117.004  11.717  1.00 17.83          
ATOM    311  CG  PRO    51     -23.910 117.044  11.828  1.00 17.67          
ATOM    314  CD  PRO    51     -24.125 116.811  13.314  1.00 18.65          
ATOM    317  C   PRO    51     -21.472 119.109  12.713  1.00 18.99          
ATOM    318  O   PRO    51     -20.383 119.318  12.162  1.00 19.27          
ATOM    319  N   LYS    52     -22.337 120.078  13.063  1.00 19.59          
ATOM    320  CA  LYS    52     -22.065 121.478  12.820  1.00 20.04          
ATOM    322  CB  LYS    52     -23.329 122.341  12.836  1.00 20.46          
ATOM    325  CG  LYS    52     -24.164 122.187  11.572  1.00 20.43          
ATOM    328  CD  LYS    52     -25.365 123.122  11.559  1.00 22.83          
ATOM    331  CE  LYS    52     -26.699 122.394  11.494  1.00 24.90          
ATOM    334  NZ  LYS    52     -27.829 123.330  11.277  1.00 24.95          
ATOM    338  C   LYS    52     -21.061 121.966  13.827  1.00 20.04          
ATOM    339  O   LYS    52     -20.398 122.970  13.602  1.00 20.00          
ATOM    341  N   LYS    53     -20.927 121.200  14.900  1.00 20.27          
ATOM    342  CA  LYS    53     -19.956 121.445  15.930  1.00 20.34          
ATOM    344  CB  LYS    53     -20.682 121.670  17.246  1.00 20.68          
ATOM    347  CG  LYS    53     -21.847 122.692  17.095  1.00 23.09          
ATOM    350  CD  LYS    53     -21.521 124.116  17.491  1.00 27.62          
ATOM    353  CE  LYS    53     -21.409 124.209  19.100  1.00 32.41          
ATOM    356  NZ  LYS    53     -22.460 123.426  19.934  1.00 31.15          
ATOM    360  C   LYS    53     -18.986 120.294  15.993  1.00 19.39          
ATOM    361  O   LYS    53     -18.420 120.077  17.023  1.00 18.49          
ATOM    363  N   ARG    54     -18.802 119.602  14.853  1.00 19.24          
ATOM    364  CA  ARG    54     -17.947 118.407  14.688  1.00 19.47          
ATOM    366  CB  ARG    54     -16.491 118.814  14.543  1.00 20.32          
ATOM    369  CG  ARG    54     -16.186 119.822  13.489  1.00 20.47          
ATOM    372  CD  ARG    54     -14.698 120.096  13.553  1.00 24.75          
ATOM    375  NE  ARG    54     -14.290 121.251  12.769  1.00 28.96          
ATOM    380  C   ARG    54     -18.064 117.358  15.813  1.00 19.60          
ATOM    381  O   ARG    54     -17.084 116.759  16.256  1.00 16.42          
ATOM    383  N   ASN    55     -19.290 117.172  16.282  1.00 19.25          
ATOM    384  CA  ASN    55     -19.541 116.166  17.282  1.00 18.54          
ATOM    386  CB  ASN    55     -19.436 114.785  16.625  1.00 18.50          
ATOM    389  CG  ASN    55     -20.554 114.554  15.636  1.00 17.41          
ATOM    390  OD1 ASN    55     -21.626 115.015  15.879  1.00 16.53          
ATOM    391  ND2 ASN    55     -20.289 113.919  14.511  1.00 15.60          
ATOM    394  C   ASN    55     -18.686 116.324  18.525  1.00 17.75          
ATOM    395  O   ASN    55     -18.268 115.349  19.146  1.00 16.70          
ATOM    397  N   THR    56     -18.423 117.568  18.899  0.50 17.45          
ATOM    399  CA  THR    56     -17.523 117.808  20.015  0.50 17.17          
ATOM    403  CB  THR    56     -17.134 119.322  20.215  0.50 16.76          
ATOM    407  OG1 THR    56     -18.308 120.136  20.261  0.50 15.81          
ATOM    411  CG2 THR    56     -16.202 119.812  19.093  0.50 16.14          
ATOM    419  C   THR    56     -18.163 117.235  21.281  0.50 17.32          
ATOM    421  O   THR    56     -19.389 117.253  21.438  0.50 16.51          
ATOM    425  N   LEU    57     -17.299 116.734  22.157  1.00 16.32          
ATOM    426  CA  LEU    57     -17.669 116.055  23.328  1.00 17.23          
ATOM    428  CB  LEU    57     -16.656 114.936  23.660  1.00 17.89          
ATOM    431  CG  LEU    57     -16.646 113.795  22.618  1.00 21.28          
ATOM    433  CD1 LEU    57     -15.502 112.788  22.902  1.00 18.00          
ATOM    437  CD2 LEU    57     -18.119 113.109  22.438  1.00 18.16          
ATOM    441  C   LEU    57     -17.801 117.054  24.455  1.00 16.91          
ATOM    442  O   LEU    57     -17.015 117.112  25.387  1.00 15.44          
ATOM    444  N   SER    58     -18.876 117.811  24.369  1.00 17.04          
ATOM    445  CA  SER    58     -19.218 118.780  25.376  1.00 17.02          
ATOM    447  CB  SER    58     -20.214 119.781  24.830  1.00 17.07          
ATOM    450  OG  SER    58     -21.405 119.120  24.399  1.00 18.63          
ATOM    452  C   SER    58     -19.837 118.015  26.481  1.00 17.85          
ATOM    453  O   SER    58     -20.266 116.837  26.284  1.00 19.18          
ATOM    455  N   LEU    59     -19.940 118.672  27.640  1.00 18.08          
ATOM    456  CA  LEU    59     -20.596 118.079  28.772  1.00 18.91          
ATOM    458  CB  LEU    59     -20.722 119.060  29.922  1.00 18.31          
ATOM    461  CG  LEU    59     -21.104 118.375  31.206  1.00 19.05          
ATOM    463  CD1 LEU    59     -20.058 117.332  31.631  1.00 13.20          
ATOM    467  CD2 LEU    59     -21.366 119.435  32.315  1.00 18.29          
ATOM    471  C   LEU    59     -21.975 117.511  28.356  1.00 19.34          
ATOM    472  O   LEU    59     -22.280 116.379  28.709  1.00 21.50          
ATOM    474  N   ALA    60     -22.751 118.247  27.558  1.00 19.33          
ATOM    475  CA  ALA    60     -24.113 117.845  27.145  1.00 19.25          
ATOM    477  CB  ALA    60     -24.852 119.063  26.474  1.00 17.30          
ATOM    481  C   ALA    60     -24.128 116.608  26.197  1.00 19.56          
ATOM    482  O   ALA    60     -24.965 115.726  26.338  1.00 20.09          
ATOM    484  N   MET    61     -23.207 116.582  25.220  1.00 20.39          
ATOM    485  CA  MET    61     -22.937 115.400  24.392  1.00 20.42          
ATOM    487  CB  MET    61     -21.851 115.762  23.403  1.00 20.30          
ATOM    490  CG  MET    61     -21.441 114.639  22.523  1.00 21.87          
ATOM    493  SD  MET    61     -22.682 114.165  21.333  1.00 17.95          
ATOM    494  CE  MET    61     -22.252 115.145  19.892  1.00 25.26          
ATOM    498  C   MET    61     -22.492 114.161  25.207  1.00 20.67          
ATOM    499  O   MET    61     -23.010 113.080  25.036  1.00 21.86          
ATOM    501  N   LEU    62     -21.560 114.336  26.128  1.00 19.50          
ATOM    502  CA  LEU    62     -21.183 113.264  27.017  1.00 19.05          
ATOM    504  CB  LEU    62     -20.032 113.730  27.953  1.00 18.43          
ATOM    507  CG  LEU    62     -18.673 113.886  27.303  1.00 16.64          
ATOM    509  CD1 LEU    62     -17.752 114.841  28.082  1.00 13.44          
ATOM    513  CD2 LEU    62     -18.074 112.458  27.050  1.00 10.71          
ATOM    517  C   LEU    62     -22.349 112.696  27.880  1.00 19.89          
ATOM    518  O   LEU    62     -22.421 111.472  28.107  1.00 20.69          
ATOM    520  N   LYS    63     -23.256 113.540  28.344  1.00 18.86          
ATOM    521  CA  LYS    63     -24.368 113.067  29.174  1.00 18.70          
ATOM    523  CB  LYS    63     -24.967 114.220  29.983  1.00 19.18          
ATOM    526  CG  LYS    63     -23.947 114.768  31.011  1.00 21.85          
ATOM    529  CD  LYS    63     -24.591 115.794  31.978  1.00 26.45          
ATOM    532  CE  LYS    63     -24.705 117.236  31.381  1.00 28.19          
ATOM    535  NZ  LYS    63     -24.745 118.338  32.430  1.00 27.09          
ATOM    539  C   LYS    63     -25.449 112.378  28.380  1.00 18.16          
ATOM    540  O   LYS    63     -26.060 111.407  28.863  1.00 14.99          
ATOM    542  N   SER    64     -25.679 112.890  27.169  1.00 18.16          
ATOM    543  CA  SER    64     -26.622 112.285  26.231  1.00 18.71          
ATOM    545  CB  SER    64     -26.765 113.206  24.997  1.00 18.48          
ATOM    548  OG  SER    64     -27.687 112.789  24.019  1.00 18.11          
ATOM    550  C   SER    64     -26.080 110.903  25.867  1.00 19.90          
ATOM    551  O   SER    64     -26.825 109.916  25.838  1.00 19.94          
ATOM    553  N   LEU    65     -24.766 110.841  25.586  1.00 20.77          
ATOM    554  CA  LEU    65     -24.115 109.603  25.140  1.00 20.75          
ATOM    556  CB  LEU    65     -22.684 109.865  24.635  1.00 20.13          
ATOM    559  CG  LEU    65     -21.825 108.617  24.301  1.00 20.27          
ATOM    561  CD1 LEU    65     -22.510 107.847  23.202  1.00 21.28          
ATOM    565  CD2 LEU    65     -20.409 109.031  23.868  1.00 19.72          
ATOM    569  C   LEU    65     -24.167 108.553  26.251  1.00 20.12          
ATOM    570  O   LEU    65     -24.622 107.439  26.031  1.00 20.44          
ATOM    572  N   GLN    66     -23.744 108.962  27.445  1.00 20.60          
ATOM    573  CA  GLN    66     -23.862 108.189  28.670  1.00 19.61          
ATOM    575  CB  GLN    66     -23.515 109.049  29.870  1.00 20.10          
ATOM    578  CG  GLN    66     -23.577 108.308  31.264  1.00 20.81          
ATOM    581  CD  GLN    66     -22.884 109.093  32.336  1.00 23.04          
ATOM    582  OE1 GLN    66     -21.735 108.798  32.653  1.00 29.45          
ATOM    583  NE2 GLN    66     -23.513 110.164  32.820  1.00 22.57          
ATOM    586  C   GLN    66     -25.235 107.644  28.881  1.00 20.02          
ATOM    587  O   GLN    66     -25.390 106.570  29.439  1.00 20.66          
ATOM    589  N   SER    67     -26.251 108.388  28.477  1.00 20.55          
ATOM    590  CA  SER    67     -27.633 108.053  28.778  1.00 19.80          
ATOM    592  CB  SER    67     -28.495 109.304  28.623  1.00 20.36          
ATOM    595  OG  SER    67     -29.550 109.291  29.502  1.00 22.20          
ATOM    597  C   SER    67     -28.104 106.978  27.819  1.00 19.85          
ATOM    598  O   SER    67     -28.780 106.002  28.204  1.00 19.35          
ATOM    600  N   ASP    68     -27.755 107.173  26.552  1.00 19.94          
ATOM    601  CA  ASP    68     -28.086 106.210  25.516  1.00 19.79          
ATOM    603  CB  ASP    68     -27.629 106.746  24.158  1.00 20.43          
ATOM    606  CG  ASP    68     -28.456 107.942  23.658  1.00 23.76          
ATOM    607  OD1 ASP    68     -29.557 108.215  24.195  1.00 23.98          
ATOM    608  OD2 ASP    68     -27.973 108.619  22.722  1.00 28.92          
ATOM    609  C   ASP    68     -27.404 104.851  25.801  1.00 19.43          
ATOM    610  O   ASP    68     -27.954 103.843  25.545  1.00 18.46          
ATOM    612  N   ILE    69     -26.173 104.862  26.312  1.00 19.12          
ATOM    613  CA  ILE    69     -25.446 103.638  26.632  1.00 18.47          
ATOM    615  CB  ILE    69     -23.958 103.948  26.929  1.00 18.25          
ATOM    617  CG1 ILE    69     -23.242 104.395  25.637  1.00 19.17          
ATOM    620  CD  ILE    69     -21.812 104.999  25.889  1.00 15.75          
ATOM    624  CG2 ILE    69     -23.235 102.721  27.440  1.00 15.24          
ATOM    628  C   ILE    69     -26.089 102.850  27.785  1.00 18.01          
ATOM    629  O   ILE    69     -26.329 101.659  27.651  1.00 16.70          
ATOM    631  N   LEU    70     -26.426 103.562  28.858  1.00 18.44          
ATOM    632  CA  LEU    70     -26.958 102.993  30.087  1.00 18.51          
ATOM    634  CB  LEU    70     -26.781 104.008  31.221  1.00 18.02          
ATOM    637  CG  LEU    70     -25.282 104.191  31.605  1.00 17.56          
ATOM    639  CD1 LEU    70     -25.172 105.045  32.861  1.00 17.10          
ATOM    643  CD2 LEU    70     -24.507 102.850  31.759  1.00 16.31          
ATOM    647  C   LEU    70     -28.402 102.570  30.034  1.00 18.99          
ATOM    648  O   LEU    70     -28.889 101.779  30.891  1.00 19.34          
ATOM    650  N   HSD    71     -29.119 103.103  29.061  1.00 19.25          
ATOM    651  CA  HSD    71     -30.548 102.931  29.018  1.00 19.59          
ATOM    653  CB  HSD    71     -31.131 103.739  27.866  1.00 19.71          
ATOM    656  CG  HSD    71     -32.594 103.546  27.715  1.00 19.32          
ATOM    657  ND1 HSD    71     -33.145 102.695  26.782  1.00 19.54          
ATOM    659  CE1 HSD    71     -34.464 102.709  26.910  1.00 20.43          
ATOM    661  NE2 HSD    71     -34.779 103.515  27.909  1.00 19.47          
ATOM    663  CD2 HSD    71     -33.628 104.049  28.430  1.00 20.71          
ATOM    665  C   HSD    71     -30.896 101.469  28.799  1.00 20.07          
ATOM    666  O   HSD    71     -30.428 100.917  27.828  1.00 18.82          
ATOM    668  N   ASP    72     -31.700 100.854  29.682  1.00 21.27          
ATOM    669  CA  ASP    72     -32.105  99.434  29.518  1.00 22.29          
ATOM    671  CB  ASP    72     -32.970  99.278  28.269  1.00 23.59          
ATOM    674  CG  ASP    72     -34.388  99.232  28.573  1.00 25.09          
ATOM    675  OD1 ASP    72     -34.945 100.303  28.881  1.00 30.24          
ATOM    676  OD2 ASP    72     -34.935  98.108  28.543  1.00 29.83          
ATOM    677  C   ASP    72     -30.928  98.486  29.323  1.00 22.15          
ATOM    678  O   ASP    72     -31.034  97.497  28.625  1.00 23.16          
ATOM    680  N   ALA    73     -29.809  98.782  29.945  1.00 21.79          
ATOM    681  CA  ALA    73     -28.591  98.081  29.685  1.00 21.44          
ATOM    683  CB  ALA    73     -27.431  98.783  30.436  1.00 20.97          
ATOM    687  C   ALA    73     -28.700  96.590  30.095  1.00 21.85          
ATOM    688  O   ALA    73     -27.919  95.788  29.623  1.00 20.76          
ATOM    690  N   ASP    74     -29.630  96.237  30.997  1.00 22.22          
ATOM    691  CA  ASP    74     -29.750  94.857  31.470  1.00 23.54          
ATOM    693  CB  ASP    74     -29.886  94.810  32.985  1.00 23.82          
ATOM    696  CG  ASP    74     -28.784  95.618  33.696  1.00 28.77          
ATOM    697  OD1 ASP    74     -29.186  96.333  34.670  1.00 34.27          
ATOM    698  OD2 ASP    74     -27.556  95.561  33.294  1.00 29.12          
ATOM    699  C   ASP    74     -30.896  94.104  30.793  1.00 23.04          
ATOM    700  O   ASP    74     -31.244  92.988  31.192  1.00 22.85          
ATOM    702  N   SER    75     -31.474  94.734  29.777  1.00 22.85          
ATOM    703  CA  SER    75     -32.544  94.139  29.053  1.00 22.91          
ATOM    705  CB  SER    75     -33.246  95.169  28.172  1.00 23.24          
ATOM    708  OG  SER    75     -34.064  94.523  27.198  1.00 22.89          
ATOM    710  C   SER    75     -31.965  93.071  28.176  1.00 22.93          
ATOM    711  O   SER    75     -30.951  93.307  27.505  1.00 22.07          
ATOM    713  N   ASN    76     -32.664  91.933  28.118  1.00 22.63          
ATOM    714  CA  ASN    76     -32.244  90.843  27.259  1.00 22.95          
ATOM    716  CB  ASN    76     -32.966  89.545  27.612  1.00 24.11          
ATOM    719  CG  ASN    76     -32.336  88.850  28.783  1.00 26.98          
ATOM    720  OD1 ASN    76     -31.113  88.563  28.782  1.00 33.45          
ATOM    721  ND2 ASN    76     -33.158  88.541  29.789  1.00 30.14          
ATOM    724  C   ASN    76     -32.413  91.104  25.793  1.00 21.54          
ATOM    725  O   ASN    76     -31.859  90.375  25.007  1.00 21.30          
ATOM    727  N   ASP    77     -33.184  92.111  25.418  1.00 20.44          
ATOM    728  CA  ASP    77     -33.321  92.434  24.029  1.00 20.82          
ATOM    730  CB  ASP    77     -34.588  93.263  23.761  1.00 21.94          
ATOM    733  CG  ASP    77     -35.898  92.516  24.107  1.00 26.35          
ATOM    734  OD1 ASP    77     -35.962  91.239  24.040  1.00 30.79          
ATOM    735  OD2 ASP    77     -36.896  93.238  24.439  1.00 32.58          
ATOM    736  C   ASP    77     -32.091  93.168  23.480  1.00 19.61          
ATOM    737  O   ASP    77     -31.919  93.204  22.283  1.00 19.66          
ATOM    739  N   LEU    78     -31.251  93.749  24.344  1.00 18.80          
ATOM    740  CA  LEU    78     -30.023  94.404  23.932  1.00 17.27          
ATOM    742  CB  LEU    78     -29.623  95.472  24.947  1.00 16.54          
ATOM    745  CG  LEU    78     -28.321  96.230  24.692  1.00 13.70          
ATOM    747  CD1 LEU    78     -28.422  97.110  23.477  1.00  8.97          
ATOM    751  CD2 LEU    78     -27.875  97.031  25.932  1.00 13.55          
ATOM    755  C   LEU    78     -28.910  93.397  23.812  1.00 17.24          
ATOM    756  O   LEU    78     -28.530  92.762  24.795  1.00 17.67          
ATOM    758  N   LYS    79     -28.312  93.302  22.622  1.00 16.68          
ATOM    759  CA  LYS    79     -27.199  92.370  22.384  1.00 15.82          
ATOM    761  CB  LYS    79     -27.528  91.369  21.270  1.00 15.73          
ATOM    764  CG  LYS    79     -28.877  90.676  21.388  1.00 16.59          
ATOM    767  CD  LYS    79     -28.974  89.712  22.499  1.00 18.06          
ATOM    770  CE  LYS    79     -30.109  88.683  22.212  1.00 18.62          
ATOM    773  NZ  LYS    79     -31.314  89.066  22.909  1.00 17.95          
ATOM    777  C   LYS    79     -25.857  93.002  22.030  1.00 15.41          
ATOM    778  O   LYS    79     -24.845  92.355  22.179  1.00 15.62          
ATOM    780  N   VAL    80     -25.854  94.222  21.505  1.00 15.50          
ATOM    781  CA  VAL    80     -24.634  94.872  21.046  1.00 15.60          
ATOM    783  CB  VAL    80     -24.067  94.182  19.722  1.00 16.76          
ATOM    785  CG1 VAL    80     -25.070  94.308  18.564  1.00 13.79          
ATOM    789  CG2 VAL    80     -22.644  94.724  19.295  1.00 12.47          
ATOM    793  C   VAL    80     -24.910  96.353  20.822  1.00 16.02          
ATOM    794  O   VAL    80     -26.008  96.732  20.471  1.00 16.93          
ATOM    796  N   ILE    81     -23.877  97.178  20.990  1.00 16.52          
ATOM    797  CA  ILE    81     -23.916  98.629  20.694  1.00 15.56          
ATOM    799  CB  ILE    81     -23.690  99.507  21.943  1.00 15.15          
ATOM    801  CG1 ILE    81     -24.768  99.260  23.001  1.00 14.39          
ATOM    804  CD  ILE    81     -24.524  99.793  24.350  1.00 11.87          
ATOM    808  CG2 ILE    81     -23.720 100.927  21.527  1.00 15.92          
ATOM    812  C   ILE    81     -22.909  99.028  19.600  1.00 15.42          
ATOM    813  O   ILE    81     -21.760  98.607  19.626  1.00 15.24          
ATOM    815  N   ILE    82     -23.363  99.853  18.649  1.00 14.63          
ATOM    816  CA  ILE    82     -22.498 100.522  17.680  1.00 14.36          
ATOM    818  CB  ILE    82     -22.980 100.304  16.200  1.00 15.79          
ATOM    820  CG1 ILE    82     -23.053  98.806  15.843  1.00 15.81          
ATOM    823  CD  ILE    82     -23.912  98.475  14.628  1.00 16.96          
ATOM    827  CG2 ILE    82     -22.056 101.060  15.234  1.00 14.37          
ATOM    831  C   ILE    82     -22.516 102.016  17.977  1.00 14.01          
ATOM    832  O   ILE    82     -23.555 102.590  18.029  1.00 12.00          
ATOM    834  N   ILE    83     -21.361 102.641  18.257  1.00 15.53          
ATOM    835  CA  ILE    83     -21.295 104.105  18.325  1.00 15.80          
ATOM    837  CB  ILE    83     -20.506 104.634  19.502  1.00 17.01          
ATOM    839  CG1 ILE    83     -21.069 104.097  20.819  1.00 17.25          
ATOM    842  CD  ILE    83     -20.076 104.162  22.048  1.00 18.56          
ATOM    846  CG2 ILE    83     -20.575 106.163  19.466  1.00 18.42          
ATOM    850  C   ILE    83     -20.693 104.607  17.020  1.00 16.12          
ATOM    851  O   ILE    83     -19.551 104.235  16.717  1.00 16.77          
ATOM    853  N   SER    84     -21.494 105.381  16.241  1.00 15.80          
ATOM    854  CA  SER    84     -21.076 106.080  15.032  1.00 16.15          
ATOM    856  CB  SER    84     -21.795 105.512  13.784  1.00 16.26          
ATOM    859  OG  SER    84     -23.117 105.324  14.014  1.00 13.91          
ATOM    861  C   SER    84     -21.340 107.580  15.115  1.00 16.70          
ATOM    862  O   SER    84     -21.732 108.078  16.160  1.00 13.67          
ATOM    864  N   ALA    85     -21.143 108.292  13.990  1.00 17.33          
ATOM    865  CA  ALA    85     -21.328 109.742  13.980  1.00 18.13          
ATOM    867  CB  ALA    85     -20.003 110.477  14.422  1.00 16.26          
ATOM    871  C   ALA    85     -21.818 110.265  12.627  1.00 18.58          
ATOM    872  O   ALA    85     -21.481 109.703  11.609  1.00 18.18          
ATOM    874  N   GLU    86     -22.588 111.367  12.663  1.00 19.55          
ATOM    875  CA  GLU    86     -23.096 112.098  11.481  1.00 20.31          
ATOM    877  CB  GLU    86     -24.170 113.112  11.933  1.00 21.00          
ATOM    880  CG  GLU    86     -25.599 113.067  11.409  1.00 23.95          
ATOM    883  CD  GLU    86     -26.391 114.364  11.807  1.00 28.72          
ATOM    884  OE1 GLU    86     -26.253 114.814  12.977  1.00 31.93          
ATOM    885  OE2 GLU    86     -27.118 114.972  10.952  1.00 31.70          
ATOM    886  C   GLU    86     -21.929 112.919  10.916  1.00 19.87          
ATOM    887  O   GLU    86     -21.230 113.606  11.651  1.00 18.05          
ATOM    889  N   GLY    87     -21.712 112.845   9.619  1.00 19.92          
ATOM    890  CA  GLY    87     -20.790 113.770   8.983  1.00 20.95          
ATOM    893  C   GLY    87     -19.335 113.339   9.028  1.00 21.41          
ATOM    894  O   GLY    87     -19.021 112.263   9.522  1.00 22.86          
ATOM    896  N   PRO    88     -18.435 114.181   8.506  1.00 21.29          
ATOM    897  CA  PRO    88     -17.064 113.774   8.110  1.00 20.91          
ATOM    899  CB  PRO    88     -16.718 114.801   7.035  1.00 20.21          
ATOM    902  CG  PRO    88     -17.484 116.017   7.442  1.00 20.92          
ATOM    905  CD  PRO    88     -18.780 115.518   7.976  1.00 20.77          
ATOM    908  C   PRO    88     -15.973 113.805   9.177  1.00 20.24          
ATOM    909  O   PRO    88     -14.824 113.450   8.903  1.00 19.80          
ATOM    910  N   VAL    89     -16.345 114.315  10.343  1.00 20.65          
ATOM    911  CA  VAL    89     -15.578 114.291  11.576  1.00 18.88          
ATOM    913  CB  VAL    89     -15.432 115.702  12.208  1.00 18.80          
ATOM    915  CG1 VAL    89     -14.743 115.625  13.537  1.00 16.50          
ATOM    919  CG2 VAL    89     -14.658 116.670  11.253  1.00 13.64          
ATOM    923  C   VAL    89     -16.376 113.390  12.498  1.00 20.43          
ATOM    924  O   VAL    89     -17.589 113.534  12.580  1.00 21.91          
ATOM    926  N   PHE    90     -15.695 112.468  13.184  1.00 19.72          
ATOM    927  CA  PHE    90     -16.301 111.531  14.041  1.00 19.43          
ATOM    929  CB  PHE    90     -15.414 110.245  14.121  1.00 19.48          
ATOM    932  CG  PHE    90     -15.877 109.287  15.158  1.00 20.01          
ATOM    933  CD1 PHE    90     -16.872 108.362  14.868  1.00 17.39          
ATOM    935  CE1 PHE    90     -17.370 107.504  15.841  1.00 18.93          
ATOM    937  CZ  PHE    90     -16.911 107.558  17.103  1.00 16.39          
ATOM    939  CE2 PHE    90     -15.896 108.507  17.428  1.00 18.94          
ATOM    941  CD2 PHE    90     -15.408 109.370  16.462  1.00 16.60          
ATOM    943  C   PHE    90     -16.550 112.239  15.403  1.00 21.11          
ATOM    944  O   PHE    90     -17.689 112.292  15.908  1.00 22.10          
ATOM    946  N   SER    91     -15.482 112.766  15.998  1.00 20.30          
ATOM    947  CA  SER    91     -15.576 113.800  17.007  1.00 20.57          
ATOM    949  CB  SER    91     -15.752 113.196  18.379  1.00 20.84          
ATOM    952  OG  SER    91     -15.846 114.234  19.320  1.00 22.57          
ATOM    954  C   SER    91     -14.248 114.511  17.033  1.00 21.11          
ATOM    955  O   SER    91     -13.221 113.881  16.841  1.00 21.08          
ATOM    957  N   SER    92     -14.277 115.783  17.401  1.00 21.15          
ATOM    958  CA  SER    92     -13.105 116.632  17.515  1.00 21.23          
ATOM    960  CB  SER    92     -13.489 118.059  17.139  1.00 20.94          
ATOM    963  OG  SER    92     -14.589 118.564  17.943  1.00 21.78          
ATOM    965  C   SER    92     -12.575 116.624  18.946  1.00 21.25          
ATOM    966  O   SER    92     -11.535 117.223  19.235  1.00 22.40          
ATOM    968  N   GLY    93     -13.301 115.985  19.841  1.00 20.58          
ATOM    969  CA  GLY    93     -12.948 115.936  21.260  1.00 19.95          
ATOM    972  C   GLY    93     -13.750 116.972  22.009  1.00 19.47          
ATOM    973  O   GLY    93     -14.794 117.442  21.566  1.00 20.34          
ATOM    975  N   HSD    94     -13.252 117.343  23.149  1.00 19.02          
ATOM    976  CA  HSD    94     -13.913 118.258  24.010  1.00 18.65          
ATOM    978  CB  HSD    94     -13.212 118.340  25.388  1.00 18.04          
ATOM    981  CG  HSD    94     -13.222 117.059  26.144  1.00 17.83          
ATOM    982  ND1 HSD    94     -14.362 116.316  26.320  1.00 19.55          
ATOM    984  CE1 HSD    94     -14.074 115.230  27.024  1.00 19.25          
ATOM    986  NE2 HSD    94     -12.801 115.280  27.377  1.00 19.12          
ATOM    988  CD2 HSD    94     -12.241 116.403  26.821  1.00 20.68          
ATOM    990  C   HSD    94     -13.972 119.647  23.426  1.00 18.42          
ATOM    991  O   HSD    94     -13.158 120.042  22.633  1.00 17.03          
ATOM    993  N   ASP    95     -15.017 120.360  23.847  1.00 19.61          
ATOM    994  CA  ASP    95     -15.202 121.784  23.545  1.00 19.31          
ATOM    996  CB  ASP    95     -16.648 122.164  23.827  1.00 19.16          
ATOM    999  CG  ASP    95     -17.011 123.572  23.311  1.00 21.32          
ATOM   1000  OD1 ASP    95     -16.166 124.344  22.761  1.00 22.64          
ATOM   1001  OD2 ASP    95     -18.190 123.904  23.461  1.00 24.08          
ATOM   1002  C   ASP    95     -14.290 122.653  24.378  1.00 18.37          
ATOM   1003  O   ASP    95     -14.398 122.688  25.598  1.00 18.35          
ATOM   1005  N   LEU    96     -13.401 123.378  23.732  1.00 18.38          
ATOM   1006  CA  LEU    96     -12.454 124.159  24.476  1.00 18.46          
ATOM   1008  CB  LEU    96     -11.342 124.659  23.572  1.00 18.82          
ATOM   1011  CG  LEU    96     -10.536 123.507  22.924  1.00 20.57          
ATOM   1013  CD1 LEU    96      -9.523 124.069  21.931  1.00 18.98          
ATOM   1017  CD2 LEU    96      -9.895 122.528  23.976  1.00 16.21          
ATOM   1021  C   LEU    96     -13.061 125.301  25.247  1.00 18.43          
ATOM   1022  O   LEU    96     -12.463 125.725  26.223  1.00 19.95          
ATOM   1024  N   LYS    97     -14.238 125.786  24.858  1.00 17.91          
ATOM   1025  CA  LYS    97     -14.921 126.857  25.603  1.00 18.00          
ATOM   1027  CB  LYS    97     -16.187 127.275  24.892  1.00 18.56          
ATOM   1030  CG  LYS    97     -15.959 127.874  23.482  1.00 19.92          
ATOM   1033  CD  LYS    97     -17.219 128.444  22.945  1.00 25.08          
ATOM   1036  CE  LYS    97     -17.489 127.989  21.508  1.00 27.41          
ATOM   1039  NZ  LYS    97     -17.434 126.508  21.314  1.00 24.52          
ATOM   1043  C   LYS    97     -15.276 126.479  27.029  1.00 18.48          
ATOM   1044  O   LYS    97     -15.389 127.335  27.890  1.00 17.64          
ATOM   1046  N   GLU    98     -15.406 125.165  27.260  1.00 19.13          
ATOM   1047  CA  GLU    98     -15.696 124.570  28.531  1.00 18.89          
ATOM   1049  CB  GLU    98     -16.448 123.268  28.308  1.00 20.08          
ATOM   1052  CG  GLU    98     -17.862 123.418  27.722  1.00 20.54          
ATOM   1055  CD  GLU    98     -18.743 122.139  27.922  1.00 21.91          
ATOM   1056  OE1 GLU    98     -18.271 121.035  27.670  1.00 21.23          
ATOM   1057  OE2 GLU    98     -19.924 122.226  28.330  1.00 28.69          
ATOM   1059  O   GLU    98     -14.760 124.443  30.541  1.00 10.39          
ATOM   1061  N   LEU    99     -13.540 124.717  29.023  1.00 13.44          
ATOM   1062  CA  LEU    99     -12.160 124.599  29.448  1.00 14.57          
ATOM   1064  CB  LEU    99     -11.425 123.586  28.556  1.00 13.88          
ATOM   1067  CG  LEU    99     -12.151 122.212  28.425  1.00 14.81          
ATOM   1069  CD1 LEU    99     -11.306 121.277  27.604  1.00 11.91          
ATOM   1073  CD2 LEU    99     -12.636 121.513  29.804  1.00 11.10          
ATOM   1077  C   LEU    99     -11.334 125.898  29.709  1.00 14.60          
ATOM   1078  O   LEU    99     -10.171 125.850  30.155  1.00 15.08          
ATOM   1080  N   THR   100     -11.960 127.042  29.512  1.00 14.98          
ATOM   1081  CA  THR   100     -11.367 128.347  29.722  1.00 14.61          
ATOM   1083  CB  THR   100     -12.111 129.442  28.938  1.00 14.62          
ATOM   1085  OG1 THR   100     -13.460 129.486  29.403  1.00 16.09          
ATOM   1087  CG2 THR   100     -12.108 129.222  27.413  1.00 12.66          
ATOM   1091  C   THR   100     -11.446 128.616  31.225  1.00 15.75          
ATOM   1092  O   THR   100     -12.296 128.057  31.918  1.00 15.40          
ATOM   1094  N   GLU   101     -10.519 129.422  31.723  1.00 16.75          
ATOM   1095  CA  GLU   101     -10.300 129.624  33.158  1.00 18.54          
ATOM   1097  CB  GLU   101      -9.309 130.784  33.353  1.00 18.95          
ATOM   1100  CG  GLU   101      -9.001 131.077  34.834  1.00 22.65          
ATOM   1103  CD  GLU   101      -8.032 132.231  35.060  1.00 29.16          
ATOM   1104  OE1 GLU   101      -7.267 132.606  34.119  1.00 32.26          
ATOM   1105  OE2 GLU   101      -8.025 132.771  36.207  1.00 34.97          
ATOM   1106  C   GLU   101     -11.574 129.957  33.914  1.00 18.85          
ATOM   1107  O   GLU   101     -11.785 129.513  35.024  1.00 19.24          
ATOM   1109  N   GLU   102     -12.376 130.809  33.295  1.00 19.48          
ATOM   1110  CA  GLU   102     -13.613 131.343  33.814  1.00 20.28          
ATOM   1112  CB  GLU   102     -14.160 132.354  32.785  1.00 21.28          
ATOM   1115  CG  GLU   102     -14.209 131.851  31.283  1.00 24.17          
ATOM   1118  CD  GLU   102     -13.063 132.402  30.307  1.00 29.37          
ATOM   1119  OE1 GLU   102     -11.828 132.567  30.753  1.00 25.64          
ATOM   1120  OE2 GLU   102     -13.436 132.634  29.075  1.00 28.75          
ATOM   1121  C   GLU   102     -14.688 130.295  34.206  1.00 20.36          
ATOM   1122  O   GLU   102     -15.533 130.559  35.055  1.00 20.79          
ATOM   1124  N   GLN   103     -14.620 129.103  33.632  1.00 19.97          
ATOM   1125  CA  GLN   103     -15.564 128.054  33.929  1.00 19.27          
ATOM   1127  CB  GLN   103     -15.493 126.951  32.879  1.00 18.37          
ATOM   1130  CG  GLN   103     -15.787 127.389  31.400  1.00 17.59          
ATOM   1133  CD  GLN   103     -17.184 127.918  31.150  1.00 15.51          
ATOM   1134  OE1 GLN   103     -17.995 128.061  32.091  1.00 11.69          
ATOM   1135  NE2 GLN   103     -17.483 128.225  29.851  1.00 10.46          
ATOM   1138  C   GLN   103     -15.307 127.493  35.302  1.00 18.92          
ATOM   1139  O   GLN   103     -16.216 126.940  35.921  1.00 19.77          
ATOM   1141  N   GLY   104     -14.085 127.649  35.783  1.00 18.10          
ATOM   1142  CA  GLY   104     -13.692 127.120  37.064  1.00 17.66          
ATOM   1145  C   GLY   104     -13.260 125.673  36.935  1.00 17.90          
ATOM   1146  O   GLY   104     -13.673 124.953  36.033  1.00 18.12          
ATOM   1148  N   ARG   105     -12.419 125.268  37.862  1.00 17.60          
ATOM   1149  CA  ARG   105     -11.850 123.943  37.905  1.00 18.31          
ATOM   1151  CB  ARG   105     -10.785 123.846  39.046  1.00 18.56          
ATOM   1154  CG  ARG   105      -9.597 124.622  38.911  1.00 18.52          
ATOM   1157  CD  ARG   105      -8.680 124.452  40.161  1.00 20.52          
ATOM   1160  NE  ARG   105      -8.054 123.166  40.123  1.00 18.48          
ATOM   1162  CZ  ARG   105      -6.790 122.867  39.821  1.00 13.75          
ATOM   1163  NH1 ARG   105      -5.866 123.743  39.483  1.00 11.33          
ATOM   1166  NH2 ARG   105      -6.464 121.606  39.843  1.00 12.71          
ATOM   1169  C   ARG   105     -12.866 122.841  38.195  1.00 17.38          
ATOM   1170  O   ARG   105     -12.644 121.738  37.811  1.00 17.17          
ATOM   1172  N   ASP   106     -13.894 123.121  38.980  1.00 16.80          
ATOM   1173  CA  ASP   106     -14.987 122.176  39.203  1.00 18.17          
ATOM   1175  CB  ASP   106     -16.037 122.801  40.117  1.00 19.03          
ATOM   1178  CG  ASP   106     -15.648 122.794  41.617  1.00 20.77          
ATOM   1179  OD1 ASP   106     -14.523 122.405  41.987  1.00 21.59          
ATOM   1180  OD2 ASP   106     -16.528 123.183  42.427  1.00 26.31          
ATOM   1181  C   ASP   106     -15.662 121.754  37.891  1.00 17.79          
ATOM   1182  O   ASP   106     -15.933 120.560  37.654  1.00 18.16          
ATOM   1184  N   TYR   107     -15.946 122.741  37.052  1.00 17.38          
ATOM   1185  CA  TYR   107     -16.546 122.486  35.733  1.00 17.07          
ATOM   1187  CB  TYR   107     -16.974 123.803  35.059  1.00 16.22          
ATOM   1190  CG  TYR   107     -17.938 123.593  33.901  1.00 17.26          
ATOM   1191  CD1 TYR   107     -19.301 123.391  34.120  1.00 18.97          
ATOM   1193  CE1 TYR   107     -20.171 123.222  33.089  1.00 16.44          
ATOM   1195  CZ  TYR   107     -19.689 123.179  31.795  1.00 16.92          
ATOM   1196  OH  TYR   107     -20.553 123.019  30.702  1.00 19.19          
ATOM   1198  CE2 TYR   107     -18.369 123.359  31.567  1.00 16.10          
ATOM   1200  CD2 TYR   107     -17.500 123.582  32.593  1.00 14.19          
ATOM   1202  C   TYR   107     -15.582 121.705  34.854  1.00 16.43          
ATOM   1203  O   TYR   107     -15.959 120.768  34.215  1.00 15.44          
ATOM   1205  N   HSD   108     -14.322 122.108  34.838  1.00 16.53          
ATOM   1206  CA  HSD   108     -13.307 121.377  34.111  1.00 15.88          
ATOM   1208  CB  HSD   108     -11.916 121.949  34.329  1.00 16.59          
ATOM   1211  CG  HSD   108     -11.718 123.383  33.917  1.00 16.50          
ATOM   1212  ND1 HSD   108     -10.588 124.083  34.293  1.00 15.51          
ATOM   1214  CE1 HSD   108     -10.637 125.301  33.769  1.00 16.01          
ATOM   1216  NE2 HSD   108     -11.757 125.417  33.086  1.00 15.37          
ATOM   1218  CD2 HSD   108     -12.459 124.234  33.166  1.00 16.00          
ATOM   1220  C   HSD   108     -13.235 119.921  34.646  1.00 15.19          
ATOM   1221  O   HSD   108     -13.155 118.995  33.914  1.00 14.28          
ATOM   1223  N   ALA   109     -13.224 119.734  35.940  1.00 15.65          
ATOM   1224  CA  ALA   109     -13.156 118.385  36.471  1.00 16.05          
ATOM   1226  CB  ALA   109     -12.982 118.414  37.948  1.00 15.64          
ATOM   1230  C   ALA   109     -14.389 117.577  36.057  1.00 16.76          
ATOM   1231  O   ALA   109     -14.296 116.376  35.833  1.00 16.84          
ATOM   1233  N   GLU   110     -15.530 118.244  35.907  1.00 18.11          
ATOM   1234  CA  GLU   110     -16.763 117.601  35.509  1.00 19.64          
ATOM   1236  CB  GLU   110     -17.944 118.562  35.725  1.00 20.98          
ATOM   1239  CG  GLU   110     -19.263 117.914  35.603  1.00 24.86          
ATOM   1242  CD  GLU   110     -20.462 118.763  36.071  1.00 31.30          
ATOM   1243  OE1 GLU   110     -20.310 119.940  36.553  1.00 33.93          
ATOM   1244  OE2 GLU   110     -21.590 118.225  35.910  1.00 33.70          
ATOM   1245  C   GLU   110     -16.703 117.087  34.095  1.00 19.32          
ATOM   1246  O   GLU   110     -17.168 116.035  33.832  1.00 19.73          
ATOM   1248  N   VAL   111     -16.090 117.823  33.180  1.00 19.93          
ATOM   1249  CA  VAL   111     -16.036 117.395  31.781  1.00 19.74          
ATOM   1251  CB  VAL   111     -15.417 118.506  30.864  1.00 18.83          
ATOM   1253  CG1 VAL   111     -15.077 117.966  29.594  1.00 17.21          
ATOM   1257  CG2 VAL   111     -16.404 119.747  30.729  1.00 18.98          
ATOM   1261  C   VAL   111     -15.230 116.100  31.695  1.00 19.31          
ATOM   1262  O   VAL   111     -15.681 115.136  31.122  1.00 19.55          
ATOM   1264  N   PHE   112     -14.048 116.102  32.277  1.00 19.15          
ATOM   1265  CA  PHE   112     -13.133 114.989  32.241  1.00 18.93          
ATOM   1267  CB  PHE   112     -11.763 115.437  32.754  1.00 19.07          
ATOM   1270  CG  PHE   112     -11.146 116.497  31.920  1.00 19.16          
ATOM   1271  CD1 PHE   112     -10.959 116.293  30.542  1.00 17.43          
ATOM   1273  CE1 PHE   112     -10.449 117.314  29.729  1.00 11.85          
ATOM   1275  CZ  PHE   112     -10.076 118.473  30.281  1.00 14.99          
ATOM   1277  CE2 PHE   112     -10.200 118.670  31.681  1.00 17.71          
ATOM   1279  CD2 PHE   112     -10.742 117.696  32.482  1.00 15.39          
ATOM   1281  C   PHE   112     -13.571 113.807  33.093  1.00 19.61          
ATOM   1282  O   PHE   112     -13.400 112.701  32.662  1.00 19.84          
ATOM   1284  N   GLN   113     -14.038 114.020  34.333  1.00 19.47          
ATOM   1285  CA  GLN   113     -14.712 112.919  35.058  1.00 20.19          
ATOM   1287  CB  GLN   113     -15.147 113.356  36.462  1.00 21.12          
ATOM   1290  CG  GLN   113     -13.895 113.637  37.417  1.00 24.34          
ATOM   1293  CD  GLN   113     -14.303 114.291  38.712  1.00 28.02          
ATOM   1294  OE1 GLN   113     -15.481 114.613  38.900  1.00 34.19          
ATOM   1295  NE2 GLN   113     -13.346 114.493  39.629  1.00 29.41          
ATOM   1298  C   GLN   113     -15.908 112.231  34.303  1.00 20.00          
ATOM   1299  O   GLN   113     -16.072 111.020  34.374  1.00 19.33          
ATOM   1301  N   THR   114     -16.704 112.989  33.569  1.00 19.93          
ATOM   1302  CA  THR   114     -17.845 112.436  32.832  1.00 18.45          
ATOM   1304  CB  THR   114     -18.870 113.557  32.392  1.00 18.41          
ATOM   1306  OG1 THR   114     -19.130 114.379  33.508  1.00 19.14          
ATOM   1308  CG2 THR   114     -20.240 112.995  31.904  1.00 15.13          
ATOM   1312  C   THR   114     -17.408 111.680  31.629  1.00 18.45          
ATOM   1313  O   THR   114     -18.021 110.672  31.235  1.00 18.46          
ATOM   1315  N   CYS   115     -16.405 112.205  30.969  1.00 17.05          
ATOM   1316  CA  CYS   115     -15.829 111.473  29.904  1.00 17.54          
ATOM   1318  CB  CYS   115     -14.759 112.350  29.292  1.00 18.42          
ATOM   1321  SG  CYS   115     -14.293 111.722  27.701  1.00 19.64          
ATOM   1323  C   CYS   115     -15.216 110.103  30.355  1.00 17.36          
ATOM   1324  O   CYS   115     -15.361 109.073  29.671  1.00 17.12          
ATOM   1326  N   SER   116     -14.533 110.100  31.516  1.00 16.47          
ATOM   1327  CA  SER   116     -13.910 108.902  32.049  1.00 16.74          
ATOM   1329  CB  SER   116     -12.991 109.261  33.235  1.00 18.02          
ATOM   1332  OG  SER   116     -11.972 110.188  32.826  1.00 19.25          
ATOM   1334  C   SER   116     -14.951 107.854  32.442  1.00 17.27          
ATOM   1335  O   SER   116     -14.746 106.695  32.185  1.00 18.02          
ATOM   1337  N   LYS   117     -16.017 108.248  33.143  1.00 17.76          
ATOM   1338  CA  LYS   117     -17.198 107.433  33.391  1.00 17.73          
ATOM   1340  CB  LYS   117     -18.288 108.271  34.036  1.00 18.80          
ATOM   1343  CG  LYS   117     -18.214 108.465  35.557  1.00 22.09          
ATOM   1346  CD  LYS   117     -19.399 109.382  35.976  1.00 29.44          
ATOM   1349  CE  LYS   117     -20.799 108.670  35.829  1.00 35.03          
ATOM   1352  NZ  LYS   117     -21.979 109.160  36.673  1.00 35.49          
ATOM   1356  C   LYS   117     -17.806 106.832  32.099  1.00 16.56          
ATOM   1357  O   LYS   117     -18.183 105.702  32.117  1.00 16.05          
ATOM   1359  N   VAL   118     -17.909 107.594  31.018  1.00 15.45          
ATOM   1360  CA  VAL   118     -18.408 107.055  29.765  1.00 16.58          
ATOM   1362  CB  VAL   118     -18.569 108.102  28.639  1.00 17.05          
ATOM   1364  CG1 VAL   118     -18.796 107.399  27.267  1.00 16.04          
ATOM   1368  CG2 VAL   118     -19.803 109.032  28.946  1.00 16.61          
ATOM   1372  C   VAL   118     -17.544 105.907  29.283  1.00 17.33          
ATOM   1373  O   VAL   118     -18.050 104.859  28.958  1.00 17.93          
ATOM   1375  N   MET   119     -16.232 106.124  29.277  1.00 17.29          
ATOM   1376  CA  MET   119     -15.268 105.152  28.901  1.00 16.83          
ATOM   1378  CB  MET   119     -13.847 105.771  29.086  1.00 18.48          
ATOM   1381  CG  MET   119     -13.346 106.789  27.945  1.00 17.68          
ATOM   1384  SD  MET   119     -14.396 106.780  26.536  1.00 25.44          
ATOM   1385  CE  MET   119     -14.656 108.485  26.051  1.00 25.86          
ATOM   1389  C   MET   119     -15.384 103.882  29.725  1.00 17.68          
ATOM   1390  O   MET   119     -15.300 102.785  29.203  1.00 16.23          
ATOM   1392  N   MET   120     -15.530 104.054  31.038  1.00 17.82          
ATOM   1393  CA  MET   120     -15.646 102.962  31.953  1.00 17.90          
ATOM   1395  CB  MET   120     -15.541 103.449  33.405  1.00 18.49          
ATOM   1398  CG  MET   120     -14.183 103.992  33.856  1.00 20.43          
ATOM   1401  SD  MET   120     -12.763 102.963  33.490  1.00 27.50          
ATOM   1402  CE  MET   120     -13.154 101.506  34.487  1.00 23.80          
ATOM   1406  C   MET   120     -16.976 102.242  31.806  1.00 18.07          
ATOM   1407  O   MET   120     -17.056 101.074  32.114  1.00 18.76          
ATOM   1409  N   HSD   121     -18.020 102.936  31.379  1.00 18.02          
ATOM   1410  CA  HSD   121     -19.310 102.326  31.191  1.00 16.84          
ATOM   1412  CB  HSD   121     -20.401 103.380  30.986  1.00 16.90          
ATOM   1415  CG  HSD   121     -20.886 104.029  32.249  1.00 15.18          
ATOM   1416  ND1 HSD   121     -21.278 103.309  33.350  1.00 17.39          
ATOM   1418  CE1 HSD   121     -21.695 104.137  34.298  1.00 19.88          
ATOM   1420  NE2 HSD   121     -21.639 105.370  33.820  1.00 19.45          
ATOM   1422  CD2 HSD   121     -21.103 105.327  32.553  1.00 15.34          
ATOM   1424  C   HSD   121     -19.233 101.442  29.958  1.00 17.12          
ATOM   1425  O   HSD   121     -19.898 100.408  29.892  1.00 17.67          
ATOM   1427  N   ILE   122     -18.502 101.874  28.948  1.00 16.86          
ATOM   1428  CA  ILE   122     -18.306 101.064  27.715  1.00 15.65          
ATOM   1430  CB  ILE   122     -17.560 101.861  26.674  1.00 15.30          
ATOM   1432  CG1 ILE   122     -18.452 103.000  26.114  1.00 16.20          
ATOM   1435  CD  ILE   122     -17.690 103.930  25.081  1.00 12.70          
ATOM   1439  CG2 ILE   122     -16.998 100.971  25.496  1.00 14.97          
ATOM   1443  C   ILE   122     -17.555  99.752  28.097  1.00 15.69          
ATOM   1444  O   ILE   122     -17.972  98.646  27.746  1.00 17.26          
ATOM   1446  N   ARG   123     -16.481  99.880  28.863  1.00 15.27          
ATOM   1447  CA  ARG   123     -15.686  98.739  29.305  0.50 14.81          
ATOM   1451  CB  ARG   123     -14.432  99.242  30.018  0.50 14.77          
ATOM   1457  CG  ARG   123     -13.518  98.121  30.561  0.50 13.13          
ATOM   1463  CD  ARG   123     -13.132  98.482  31.954  0.50 10.58          
ATOM   1469  NE  ARG   123     -11.975  97.751  32.467  0.50 13.44          
ATOM   1473  CZ  ARG   123     -12.032  96.946  33.510  0.50  9.28          
ATOM   1475  NH1 ARG   123     -13.172  96.775  34.116  0.50  6.74          
ATOM   1481  NH2 ARG   123     -10.967  96.293  33.887  0.50 11.97          
ATOM   1487  C   ARG   123     -16.410  97.757  30.213  1.00 15.26          
ATOM   1488  O   ARG   123     -16.192  96.552  30.115  1.00 14.36          
ATOM   1490  N   ASN   124     -17.205  98.288  31.139  1.00 15.97          
ATOM   1491  CA  ASN   124     -17.955  97.518  32.062  1.00 16.12          
ATOM   1493  CB  ASN   124     -18.005  98.262  33.361  1.00 16.76          
ATOM   1496  CG  ASN   124     -16.642  98.358  34.019  1.00 17.50          
ATOM   1497  OD1 ASN   124     -15.867  97.451  33.968  1.00 22.01          
ATOM   1498  ND2 ASN   124     -16.384  99.436  34.661  1.00 20.81          
ATOM   1501  C   ASN   124     -19.372  97.139  31.575  1.00 16.10          
ATOM   1502  O   ASN   124     -20.131  96.542  32.309  1.00 15.88          
ATOM   1504  N   HSD   125     -19.703  97.442  30.336  1.00 16.02          
ATOM   1505  CA  HSD   125     -21.006  97.198  29.804  1.00 15.87          
ATOM   1507  CB  HSD   125     -21.182  97.819  28.406  1.00 16.42          
ATOM   1510  CG  HSD   125     -22.595  98.294  28.145  1.00 17.72          
ATOM   1511  ND1 HSD   125     -23.591  97.471  27.649  1.00 20.32          
ATOM   1513  CE1 HSD   125     -24.728  98.144  27.578  1.00 20.03          
ATOM   1515  NE2 HSD   125     -24.512  99.385  27.985  1.00 17.52          
ATOM   1517  CD2 HSD   125     -23.184  99.504  28.354  1.00 18.22          
ATOM   1519  C   HSD   125     -21.288  95.703  29.677  1.00 17.08          
ATOM   1520  O   HSD   125     -20.352  94.926  29.505  1.00 17.32          
ATOM   1522  N   PRO   126     -22.592  95.291  29.761  1.00 15.94          
ATOM   1523  CA  PRO   126     -22.859  93.897  29.646  1.00 15.53          
ATOM   1525  CB  PRO   126     -24.244  93.788  30.191  1.00 15.78          
ATOM   1528  CG  PRO   126     -24.607  95.092  30.745  1.00 15.31          
ATOM   1531  CD  PRO   126     -23.543  95.966  30.660  1.00 15.45          
ATOM   1534  C   PRO   126     -22.760  93.357  28.190  1.00 15.77          
ATOM   1535  O   PRO   126     -22.646  92.151  28.000  1.00 15.83          
ATOM   1536  N   VAL   127     -22.829  94.237  27.204  1.00 15.26          
ATOM   1537  CA  VAL   127     -22.769  93.868  25.821  1.00 14.48          
ATOM   1539  CB  VAL   127     -24.078  94.266  25.106  1.00 16.44          
ATOM   1541  CG1 VAL   127     -25.360  93.691  25.896  1.00 14.02          
ATOM   1545  CG2 VAL   127     -24.187  95.807  24.885  1.00 14.24          
ATOM   1549  C   VAL   127     -21.504  94.494  25.189  1.00 14.76          
ATOM   1550  O   VAL   127     -20.999  95.482  25.628  1.00 15.29          
ATOM   1552  N   PRO   128     -20.952  93.874  24.170  1.00 15.02          
ATOM   1553  CA  PRO   128     -19.949  94.518  23.375  1.00 13.57          
ATOM   1555  CB  PRO   128     -19.716  93.492  22.225  1.00 14.89          
ATOM   1558  CG  PRO   128     -20.237  92.224  22.689  1.00 13.79          
ATOM   1561  CD  PRO   128     -21.405  92.607  23.551  1.00 15.73          
ATOM   1564  C   PRO   128     -20.360  95.862  22.784  1.00 14.69          
ATOM   1565  O   PRO   128     -21.505  96.052  22.307  1.00 15.31          
ATOM   1566  N   VAL   129     -19.382  96.784  22.689  1.00 15.44          
ATOM   1567  CA  VAL   129     -19.582  98.111  22.039  1.00 12.97          
ATOM   1569  CB  VAL   129     -19.405  99.269  23.055  1.00 13.20          
ATOM   1571  CG1 VAL   129     -19.638 100.622  22.347  1.00  7.24          
ATOM   1575  CG2 VAL   129     -20.292  99.059  24.413  1.00  7.88          
ATOM   1579  C   VAL   129     -18.603  98.214  20.857  1.00 13.07          
ATOM   1580  O   VAL   129     -17.456  97.971  21.014  1.00 12.83          
ATOM   1582  N   ILE   130     -19.096  98.480  19.652  1.00 14.20          
ATOM   1583  CA  ILE   130     -18.300  98.659  18.459  1.00 11.93          
ATOM   1585  CB  ILE   130     -18.984  97.874  17.286  1.00 13.69          
ATOM   1587  CG1 ILE   130     -19.161  96.399  17.666  1.00 13.43          
ATOM   1590  CD  ILE   130     -19.975  95.634  16.659  1.00 15.03          
ATOM   1594  CG2 ILE   130     -18.218  98.015  15.906  1.00  4.90          
ATOM   1598  C   ILE   130     -18.318 100.185  18.077  1.00 13.42          
ATOM   1599  O   ILE   130     -19.419 100.851  18.076  1.00 10.47          
ATOM   1601  N   ALA   131     -17.122 100.722  17.781  1.00 13.18          
ATOM   1602  CA  ALA   131     -16.957 102.062  17.185  1.00 13.55          
ATOM   1604  CB  ALA   131     -15.624 102.761  17.547  1.00 11.89          
ATOM   1608  C   ALA   131     -17.006 101.860  15.728  1.00 13.09          
ATOM   1609  O   ALA   131     -16.321 101.028  15.192  1.00 12.65          
ATOM   1611  N   MET   132     -17.852 102.615  15.068  1.00 15.32          
ATOM   1612  CA  MET   132     -17.940 102.582  13.563  1.00 13.93          
ATOM   1614  CB  MET   132     -19.335 102.230  13.107  1.00 13.98          
ATOM   1617  CG  MET   132     -19.509 102.357  11.534  1.00 16.51          
ATOM   1620  SD  MET   132     -21.151 101.970  10.883  1.00 18.40          
ATOM   1621  CE  MET   132     -21.122 102.807   9.309  1.00 24.32          
ATOM   1625  C   MET   132     -17.554 103.991  13.067  1.00 14.19          
ATOM   1626  O   MET   132     -18.360 104.888  13.056  1.00 16.29          
ATOM   1628  N   VAL   133     -16.333 104.173  12.608  1.00 13.14          
ATOM   1629  CA  VAL   133     -15.746 105.489  12.417  1.00 12.83          
ATOM   1631  CB  VAL   133     -14.311 105.497  13.055  1.00 10.70          
ATOM   1633  CG1 VAL   133     -13.673 106.899  12.793  1.00  9.23          
ATOM   1637  CG2 VAL   133     -14.369 105.055  14.518  1.00 11.76          
ATOM   1641  C   VAL   133     -15.547 105.798  10.938  1.00 14.21          
ATOM   1642  O   VAL   133     -14.987 104.969  10.290  1.00 12.77          
ATOM   1644  N   ASN   134     -15.930 106.997  10.458  1.00 15.70          
ATOM   1645  CA  ASN   134     -15.892 107.341   9.020  1.00 17.80          
ATOM   1647  CB  ASN   134     -17.294 107.206   8.446  1.00 18.10          
ATOM   1650  CG  ASN   134     -17.349 107.295   6.929  1.00 16.58          
ATOM   1651  OD1 ASN   134     -16.352 107.061   6.189  1.00 15.83          
ATOM   1652  ND2 ASN   134     -18.540 107.645   6.448  1.00 14.19          
ATOM   1655  C   ASN   134     -15.391 108.796   8.834  1.00 19.29          
ATOM   1656  O   ASN   134     -16.183 109.695   8.577  1.00 20.58          
ATOM   1658  N   GLY   135     -14.089 109.035   9.035  1.00 19.25          
ATOM   1659  CA  GLY   135     -13.543 110.390   8.996  1.00 17.79          
ATOM   1662  C   GLY   135     -12.605 110.549  10.177  1.00 17.04          
ATOM   1663  O   GLY   135     -12.035 109.561  10.632  1.00 16.93          
ATOM   1665  N   LEU   136     -12.466 111.788  10.667  1.00 15.81          
ATOM   1666  CA  LEU   136     -11.440 112.138  11.635  1.00 15.63          
ATOM   1668  CB  LEU   136     -11.044 113.617  11.520  1.00 16.59          
ATOM   1671  CG  LEU   136      -9.891 114.219  12.309  1.00 18.05          
ATOM   1673  CD1 LEU   136      -8.429 113.551  12.089  1.00 18.99          
ATOM   1677  CD2 LEU   136      -9.833 115.783  12.152  1.00 20.77          
ATOM   1681  C   LEU   136     -11.954 111.965  12.963  1.00 14.44          
ATOM   1682  O   LEU   136     -13.066 112.422  13.261  1.00 12.39          
ATOM   1684  N   ALA   137     -11.077 111.436  13.817  1.00 14.97          
ATOM   1685  CA  ALA   137     -11.376 111.250  15.202  1.00 14.20          
ATOM   1687  CB  ALA   137     -11.609 109.759  15.466  1.00 12.24          
ATOM   1691  C   ALA   137     -10.160 111.801  15.973  1.00 15.75          
ATOM   1692  O   ALA   137      -9.029 111.333  15.763  1.00 16.76          
ATOM   1694  N   THR   138     -10.362 112.837  16.809  1.00 16.53          
ATOM   1695  CA  THR   138      -9.252 113.551  17.381  1.00 16.52          
ATOM   1697  CB  THR   138      -8.919 114.929  16.739  1.00 16.69          
ATOM   1699  OG1 THR   138      -9.769 115.911  17.307  1.00 21.82          
ATOM   1701  CG2 THR   138      -9.014 115.076  15.082  1.00 17.09          
ATOM   1705  C   THR   138      -9.402 113.732  18.943  1.00 16.59          
ATOM   1706  O   THR   138     -10.504 114.058  19.468  1.00 17.31          
ATOM   1708  N   ALA   139      -8.278 113.646  19.641  1.00 14.84          
ATOM   1709  CA  ALA   139      -8.277 113.889  21.168  1.00 14.64          
ATOM   1711  CB  ALA   139      -8.517 115.349  21.540  1.00 12.76          
ATOM   1715  C   ALA   139      -9.300 112.981  21.721  1.00 14.52          
ATOM   1716  O   ALA   139      -9.168 111.760  21.532  1.00 14.92          
ATOM   1718  N   ALA   140     -10.322 113.519  22.401  1.00 16.51          
ATOM   1719  CA  ALA   140     -11.291 112.702  23.204  1.00 16.46          
ATOM   1721  CB  ALA   140     -12.166 113.531  24.163  1.00 15.96          
ATOM   1725  C   ALA   140     -12.142 111.890  22.295  1.00 16.99          
ATOM   1726  O   ALA   140     -12.700 110.882  22.738  1.00 17.32          
ATOM   1728  N   GLY   141     -12.260 112.322  21.015  1.00 17.55          
ATOM   1729  CA  GLY   141     -12.798 111.517  20.000  1.00 17.29          
ATOM   1732  C   GLY   141     -12.052 110.245  19.685  1.00 19.38          
ATOM   1733  O   GLY   141     -12.668 109.205  19.427  1.00 21.86          
ATOM   1735  N   CYS   142     -10.720 110.328  19.629  1.00 19.34          
ATOM   1736  CA  CYS   142      -9.878 109.194  19.497  1.00 18.07          
ATOM   1738  CB  CYS   142      -8.437 109.670  19.305  1.00 20.75          
ATOM   1741  SG  CYS   142      -7.434 108.399  18.490  1.00 21.27          
ATOM   1743  C   CYS   142      -9.947 108.334  20.733  1.00 17.69          
ATOM   1744  O   CYS   142     -10.031 107.119  20.635  1.00 19.11          
ATOM   1746  N   GLN   143      -9.923 108.948  21.907  1.00 15.10          
ATOM   1747  CA  GLN   143     -10.181 108.220  23.112  1.00 14.70          
ATOM   1749  CB  GLN   143     -10.384 109.228  24.244  1.00 15.37          
ATOM   1752  CG  GLN   143     -10.213 108.699  25.562  1.00 16.50          
ATOM   1755  CD  GLN   143     -10.624 109.665  26.587  1.00 15.66          
ATOM   1756  OE1 GLN   143     -11.172 109.277  27.546  1.00 21.03          
ATOM   1757  NE2 GLN   143     -10.363 110.904  26.395  1.00 14.30          
ATOM   1760  C   GLN   143     -11.391 107.289  22.958  1.00 14.94          
ATOM   1761  O   GLN   143     -11.356 106.109  23.216  1.00 15.30          
ATOM   1763  N   LEU   144     -12.489 107.835  22.491  1.00 16.72          
ATOM   1764  CA  LEU   144     -13.743 107.112  22.461  1.00 15.83          
ATOM   1766  CB  LEU   144     -14.866 108.027  21.963  1.00 15.53          
ATOM   1769  CG  LEU   144     -16.280 107.504  21.752  1.00 17.08          
ATOM   1771  CD1 LEU   144     -16.809 106.644  22.878  1.00 11.29          
ATOM   1775  CD2 LEU   144     -17.178 108.702  21.383  1.00 15.43          
ATOM   1779  C   LEU   144     -13.627 105.947  21.596  1.00 17.09          
ATOM   1780  O   LEU   144     -14.065 104.857  21.983  1.00 18.00          
ATOM   1782  N   VAL   145     -13.041 106.150  20.403  1.00 14.98          
ATOM   1783  CA  VAL   145     -12.867 105.031  19.542  1.00 14.78          
ATOM   1785  CB  VAL   145     -12.064 105.410  18.272  1.00 13.20          
ATOM   1787  CG1 VAL   145     -11.776 104.237  17.615  1.00 11.90          
ATOM   1791  CG2 VAL   145     -12.739 106.455  17.502  1.00  8.21          
ATOM   1795  C   VAL   145     -12.079 103.855  20.226  1.00 14.76          
ATOM   1796  O   VAL   145     -12.454 102.672  20.187  1.00 15.27          
ATOM   1798  N   ALA   146     -10.928 104.207  20.718  1.00 14.28          
ATOM   1799  CA  ALA   146      -9.999 103.265  21.296  1.00 14.65          
ATOM   1801  CB  ALA   146      -8.694 104.003  21.540  1.00 13.90          
ATOM   1805  C   ALA   146     -10.573 102.690  22.578  1.00 16.55          
ATOM   1806  O   ALA   146     -10.131 101.649  23.054  1.00 18.77          
ATOM   1808  N   SER   147     -11.567 103.346  23.155  1.00 15.98          
ATOM   1809  CA  SER   147     -12.355 102.748  24.250  1.00 17.16          
ATOM   1811  CB  SER   147     -13.099 103.897  25.013  1.00 16.86          
ATOM   1814  OG  SER   147     -12.018 104.685  25.615  1.00 20.51          
ATOM   1816  C   SER   147     -13.330 101.630  23.869  1.00 16.07          
ATOM   1817  O   SER   147     -13.759 100.933  24.701  1.00 12.98          
ATOM   1819  N   CYS   148     -13.790 101.551  22.619  1.00 17.13          
ATOM   1820  CA  CYS   148     -14.721 100.505  22.224  1.00 16.71          
ATOM   1822  CB  CYS   148     -15.343 100.877  20.885  1.00 18.29          
ATOM   1825  SG  CYS   148     -16.416 102.299  21.190  1.00 20.48          
ATOM   1827  C   CYS   148     -14.015  99.133  22.224  1.00 17.21          
ATOM   1828  O   CYS   148     -12.817  99.052  22.100  1.00 16.90          
ATOM   1830  N   ASP   149     -14.781  98.049  22.386  1.00 16.56          
ATOM   1831  CA  ASP   149     -14.248  96.671  22.327  1.00 15.21          
ATOM   1833  CB  ASP   149     -15.349  95.619  22.823  1.00 13.52          
ATOM   1836  CG  ASP   149     -15.848  95.882  24.217  1.00 16.68          
ATOM   1837  OD1 ASP   149     -17.059  96.102  24.440  1.00 17.98          
ATOM   1838  OD2 ASP   149     -15.021  95.858  25.170  1.00 20.31          
ATOM   1839  C   ASP   149     -13.735  96.331  20.910  1.00 14.93          
ATOM   1840  O   ASP   149     -12.711  95.631  20.781  1.00 15.16          
ATOM   1842  N   ILE   150     -14.444  96.820  19.883  1.00 13.57          
ATOM   1843  CA  ILE   150     -14.111  96.565  18.416  1.00 14.31          
ATOM   1845  CB  ILE   150     -15.095  95.522  17.733  1.00 12.77          
ATOM   1847  CG1 ILE   150     -14.892  94.146  18.399  1.00 15.91          
ATOM   1850  CD  ILE   150     -16.059  93.224  18.301  1.00 13.77          
ATOM   1854  CG2 ILE   150     -14.941  95.404  16.247  1.00 13.56          
ATOM   1858  C   ILE   150     -14.247  97.871  17.746  1.00 13.95          
ATOM   1859  O   ILE   150     -15.051  98.691  18.219  1.00 16.22          
ATOM   1861  N   ALA   151     -13.385  98.172  16.777  1.00 12.47          
ATOM   1862  CA  ALA   151     -13.555  99.420  15.978  1.00 12.55          
ATOM   1864  CB  ALA   151     -12.576 100.535  16.376  1.00 13.16          
ATOM   1868  C   ALA   151     -13.361  99.119  14.555  1.00 11.59          
ATOM   1869  O   ALA   151     -12.459  98.428  14.221  1.00  9.67          
ATOM   1871  N   VAL   152     -14.239  99.649  13.723  1.00 13.17          
ATOM   1872  CA  VAL   152     -14.215  99.467  12.276  1.00 13.54          
ATOM   1874  CB  VAL   152     -15.538  98.720  11.775  1.00 14.14          
ATOM   1876  CG1 VAL   152     -15.402  98.283  10.412  1.00 11.83          
ATOM   1880  CG2 VAL   152     -15.927  97.558  12.693  1.00 11.37          
ATOM   1884  C   VAL   152     -14.215 100.896  11.702  1.00 15.05          
ATOM   1885  O   VAL   152     -15.007 101.694  12.153  1.00 15.86          
ATOM   1887  N   ALA   153     -13.434 101.177  10.651  1.00 16.38          
ATOM   1888  CA  ALA   153     -13.167 102.532  10.189  1.00 16.80          
ATOM   1890  CB  ALA   153     -11.780 103.072  10.794  1.00 15.60          
ATOM   1894  C   ALA   153     -13.144 102.479   8.685  1.00 16.53          
ATOM   1895  O   ALA   153     -12.680 101.499   8.135  1.00 18.86          
ATOM   1897  N   SER   154     -13.720 103.460   7.976  1.00 17.43          
ATOM   1898  CA  SER   154     -13.425 103.599   6.498  1.00 17.76          
ATOM   1900  CB  SER   154     -14.205 104.772   5.892  1.00 17.71          
ATOM   1903  OG  SER   154     -13.894 105.937   6.657  1.00 20.86          
ATOM   1905  C   SER   154     -11.941 103.874   6.287  1.00 17.98          
ATOM   1906  O   SER   154     -11.274 104.399   7.145  1.00 18.86          
ATOM   1908  N   ASP   155     -11.434 103.531   5.123  1.00 20.20          
ATOM   1909  CA  ASP   155     -10.016 103.718   4.775  1.00 20.53          
ATOM   1911  CB  ASP   155      -9.720 102.958   3.422  1.00 21.70          
ATOM   1914  CG  ASP   155     -10.661 103.332   2.321  1.00 25.16          
ATOM   1915  OD1 ASP   155     -11.393 104.326   2.548  1.00 32.18          
ATOM   1916  OD2 ASP   155     -10.704 102.656   1.233  1.00 31.33          
ATOM   1917  C   ASP   155      -9.580 105.200   4.717  1.00 19.69          
ATOM   1918  O   ASP   155      -8.400 105.484   4.732  1.00 20.26          
ATOM   1920  N   LYS   156     -10.531 106.140   4.626  1.00 19.70          
ATOM   1921  CA  LYS   156     -10.233 107.613   4.606  1.00 19.36          
ATOM   1923  CB  LYS   156     -11.287 108.402   3.848  1.00 18.32          
ATOM   1926  CG  LYS   156     -12.523 108.719   4.721  1.00 21.72          
ATOM   1929  CD  LYS   156     -13.605 109.442   3.926  1.00 28.34          
ATOM   1932  CE  LYS   156     -14.764 109.953   4.810  1.00 30.53          
ATOM   1935  NZ  LYS   156     -15.859 110.341   3.812  1.00 23.70          
ATOM   1939  C   LYS   156     -10.196 108.205   6.008  1.00 18.12          
ATOM   1940  O   LYS   156      -9.851 109.365   6.182  1.00 19.94          
ATOM   1942  N   SER   157     -10.707 107.475   6.967  1.00 15.93          
ATOM   1943  CA  SER   157     -10.481 107.827   8.387  1.00 14.77          
ATOM   1945  CB  SER   157     -10.962 106.683   9.196  1.00 13.82          
ATOM   1948  OG  SER   157     -12.318 106.488   9.139  1.00 14.81          
ATOM   1950  C   SER   157      -9.042 108.058   8.857  1.00 14.72          
ATOM   1951  O   SER   157      -8.125 107.444   8.356  1.00 14.23          
ATOM   1953  N   SER   158      -8.889 108.847   9.942  1.00 14.89          
ATOM   1954  CA  SER   158      -7.659 109.206  10.462  1.00 15.21          
ATOM   1956  CB  SER   158      -7.008 110.355   9.719  1.00 16.57          
ATOM   1959  OG  SER   158      -7.455 111.626  10.185  1.00 19.65          
ATOM   1961  C   SER   158      -7.864 109.556  11.938  1.00 15.60          
ATOM   1962  O   SER   158      -8.988 109.831  12.370  1.00 17.35          
ATOM   1964  N   PHE   159      -6.773 109.495  12.685  1.00 13.31          
ATOM   1965  CA  PHE   159      -6.797 109.518  14.183  1.00 13.16          
ATOM   1967  CB  PHE   159      -6.626 108.061  14.637  1.00 14.50          
ATOM   1970  CG  PHE   159      -7.597 107.116  13.922  1.00 14.84          
ATOM   1971  CD1 PHE   159      -7.268 106.551  12.741  1.00 18.81          
ATOM   1973  CE1 PHE   159      -8.215 105.735  12.070  1.00 19.96          
ATOM   1975  CZ  PHE   159      -9.499 105.507  12.689  1.00 19.89          
ATOM   1977  CE2 PHE   159      -9.808 106.080  13.773  1.00 10.53          
ATOM   1979  CD2 PHE   159      -8.873 106.890  14.430  1.00 18.37          
ATOM   1981  C   PHE   159      -5.650 110.331  14.658  1.00 11.23          
ATOM   1982  O   PHE   159      -4.558 110.173  14.074  1.00  7.55          
ATOM   1984  N   ALA   160      -5.854 111.185  15.710  1.00 11.91          
ATOM   1985  CA  ALA   160      -4.826 112.135  16.255  1.00 11.63          
ATOM   1987  CB  ALA   160      -4.717 113.434  15.370  1.00 10.32          
ATOM   1991  C   ALA   160      -5.100 112.562  17.718  1.00 12.81          
ATOM   1992  O   ALA   160      -6.225 112.448  18.208  1.00 14.16          
ATOM   1994  N   THR   161      -4.028 112.898  18.449  1.00 14.40          
ATOM   1995  CA  THR   161      -4.124 113.375  19.908  1.00 14.46          
ATOM   1997  CB  THR   161      -3.674 112.359  20.920  1.00 14.70          
ATOM   1999  OG1 THR   161      -2.354 111.948  20.692  1.00 18.82          
ATOM   2001  CG2 THR   161      -4.605 111.072  21.070  1.00 11.62          
ATOM   2005  C   THR   161      -3.342 114.724  19.891  1.00 13.93          
ATOM   2006  O   THR   161      -2.186 114.821  20.299  1.00 13.89          
ATOM   2008  N   PRO   162      -3.936 115.746  19.260  1.00 13.68          
ATOM   2009  CA  PRO   162      -3.314 117.035  19.113  1.00 14.50          
ATOM   2011  CB  PRO   162      -4.021 117.570  17.909  1.00 14.91          
ATOM   2014  CG  PRO   162      -5.495 117.147  18.299  1.00 13.72          
ATOM   2017  CD  PRO   162      -5.264 115.729  18.624  1.00 14.02          
ATOM   2020  C   PRO   162      -3.546 118.026  20.273  1.00 13.71          
ATOM   2021  O   PRO   162      -3.349 119.171  20.077  1.00 13.59          
ATOM   2022  N   GLY   163      -3.966 117.617  21.432  1.00 13.57          
ATOM   2023  CA  GLY   163      -4.009 118.567  22.602  1.00 15.24          
ATOM   2026  C   GLY   163      -2.896 119.618  22.674  1.00 16.04          
ATOM   2027  O   GLY   163      -3.162 120.804  22.979  1.00 16.72          
ATOM   2029  N   VAL   164      -1.668 119.202  22.341  1.00 15.79          
ATOM   2030  CA  VAL   164      -0.458 119.981  22.607  1.00 15.89          
ATOM   2032  CB  VAL   164       0.907 119.180  22.283  1.00 16.65          
ATOM   2034  CG1 VAL   164       1.292 118.356  23.398  1.00 19.97          
ATOM   2038  CG2 VAL   164       0.828 118.443  20.938  1.00 15.86          
ATOM   2042  C   VAL   164      -0.448 121.262  21.852  1.00 14.61          
ATOM   2043  O   VAL   164       0.088 122.249  22.319  1.00 13.93          
ATOM   2045  N   ASN   165      -0.969 121.224  20.629  1.00 16.04          
ATOM   2046  CA  ASN   165      -1.148 122.387  19.778  1.00 14.55          
ATOM   2048  CB  ASN   165      -1.761 121.915  18.480  1.00 14.16          
ATOM   2051  CG  ASN   165      -0.774 121.026  17.664  1.00 14.81          
ATOM   2052  OD1 ASN   165       0.415 121.018  17.949  1.00 17.41          
ATOM   2053  ND2 ASN   165      -1.256 120.334  16.641  1.00 12.60          
ATOM   2056  C   ASN   165      -1.980 123.516  20.470  1.00 15.76          
ATOM   2057  O   ASN   165      -1.754 124.706  20.185  1.00 18.72          
ATOM   2059  N   VAL   166      -2.891 123.162  21.400  1.00 14.92          
ATOM   2060  CA  VAL   166      -3.702 124.124  22.167  1.00 12.58          
ATOM   2062  CB  VAL   166      -5.210 123.861  22.031  1.00 12.92          
ATOM   2064  CG1 VAL   166      -5.615 123.744  20.418  1.00  7.18          
ATOM   2068  CG2 VAL   166      -5.718 122.593  22.756  1.00  8.71          
ATOM   2072  C   VAL   166      -3.289 124.120  23.607  1.00 13.26          
ATOM   2073  O   VAL   166      -4.050 124.481  24.482  1.00 13.86          
ATOM   2075  N   GLY   167      -2.067 123.782  23.873  1.00 12.52          
ATOM   2076  CA  GLY   167      -1.554 123.834  25.275  1.00 12.88          
ATOM   2079  C   GLY   167      -2.257 122.906  26.196  1.00 12.87          
ATOM   2080  O   GLY   167      -2.050 122.990  27.366  1.00 11.70          
ATOM   2082  N   LEU   168      -3.018 121.945  25.629  1.00 15.15          
ATOM   2083  CA  LEU   168      -3.711 120.940  26.430  1.00 15.27          
ATOM   2085  CB  LEU   168      -5.220 121.049  26.337  1.00 14.54          
ATOM   2088  CG  LEU   168      -6.044 120.150  27.318  1.00 15.01          
ATOM   2090  CD1 LEU   168      -5.635 120.183  28.793  1.00  8.44          
ATOM   2094  CD2 LEU   168      -7.475 120.492  27.192  1.00 12.90          
ATOM   2098  C   LEU   168      -3.300 119.519  26.054  1.00 15.66          
ATOM   2099  O   LEU   168      -3.986 118.919  25.340  1.00 14.16          
ATOM   2101  N   PHE   169      -2.277 118.941  26.750  1.00 15.84          
ATOM   2102  CA  PHE   169      -1.776 117.603  26.358  1.00 15.52          
ATOM   2104  CB  PHE   169      -0.632 117.222  27.284  1.00 15.49          
ATOM   2107  CG  PHE   169       0.273 116.083  26.783  1.00 19.77          
ATOM   2108  CD1 PHE   169       0.016 114.757  27.103  1.00 19.12          
ATOM   2110  CE1 PHE   169       0.845 113.751  26.725  1.00 12.77          
ATOM   2112  CZ  PHE   169       2.009 114.007  26.151  1.00 18.20          
ATOM   2114  CE2 PHE   169       2.320 115.311  25.776  1.00 23.08          
ATOM   2116  CD2 PHE   169       1.463 116.346  26.115  1.00 23.90          
ATOM   2118  C   PHE   169      -2.915 116.557  26.384  1.00 14.86          
ATOM   2119  O   PHE   169      -3.643 116.462  27.398  1.00 12.35          
ATOM   2121  N   CYS   170      -3.016 115.698  25.348  1.00 13.41          
ATOM   2122  CA  CYS   170      -4.035 114.596  25.361  1.00 11.88          
ATOM   2124  CB  CYS   170      -4.212 113.985  23.971  1.00 16.34          
ATOM   2127  SG  CYS   170      -5.066 115.119  22.882  1.00 14.15          
ATOM   2129  C   CYS   170      -3.822 113.535  26.415  1.00 12.88          
ATOM   2130  O   CYS   170      -3.758 112.371  26.134  1.00 11.10          
ATOM   2132  N   SER   171      -3.733 113.932  27.715  1.00 11.47          
ATOM   2133  CA  SER   171      -3.464 112.969  28.731  1.00 10.97          
ATOM   2135  CB  SER   171      -3.229 113.633  30.073  1.00 10.81          
ATOM   2138  OG  SER   171      -2.022 114.323  30.093  1.00 11.21          
ATOM   2140  C   SER   171      -4.525 111.918  28.919  1.00 12.85          
ATOM   2141  O   SER   171      -4.212 110.719  29.144  1.00 12.57          
ATOM   2143  N   THR   172      -5.771 112.381  28.822  1.00 13.91          
ATOM   2144  CA  THR   172      -6.954 111.541  28.875  1.00 14.21          
ATOM   2146  CB  THR   172      -8.245 112.376  28.810  1.00 11.99          
ATOM   2148  OG1 THR   172      -7.944 113.688  28.320  1.00 18.90          
ATOM   2150  CG2 THR   172      -8.876 112.488  30.190  1.00 12.58          
ATOM   2154  C   THR   172      -6.931 110.566  27.713  1.00 14.24          
ATOM   2155  O   THR   172      -6.909 109.354  27.927  1.00 14.96          
ATOM   2157  N   PRO   173      -6.924 111.071  26.480  1.00 13.79          
ATOM   2158  CA  PRO   173      -6.781 110.153  25.396  1.00 14.93          
ATOM   2160  CB  PRO   173      -6.706 111.045  24.184  1.00 15.71          
ATOM   2163  CG  PRO   173      -7.460 112.323  24.540  1.00 12.71          
ATOM   2166  CD  PRO   173      -7.051 112.455  26.023  1.00 13.35          
ATOM   2169  C   PRO   173      -5.521 109.199  25.422  1.00 17.61          
ATOM   2170  O   PRO   173      -5.580 108.103  24.913  1.00 19.27          
ATOM   2171  N   GLY   174      -4.387 109.629  25.969  1.00 17.70          
ATOM   2172  CA  GLY   174      -3.272 108.737  26.057  1.00 17.44          
ATOM   2175  C   GLY   174      -3.499 107.491  26.902  1.00 15.28          
ATOM   2176  O   GLY   174      -2.813 106.537  26.725  1.00 14.27          
ATOM   2178  N   VAL   175      -4.467 107.505  27.800  1.00 15.76          
ATOM   2179  CA  VAL   175      -4.896 106.271  28.511  1.00 15.71          
ATOM   2181  CB  VAL   175      -5.937 106.619  29.521  1.00 15.70          
ATOM   2183  CG1 VAL   175      -6.565 105.337  30.087  1.00 14.32          
ATOM   2187  CG2 VAL   175      -5.252 107.444  30.643  1.00 15.63          
ATOM   2191  C   VAL   175      -5.366 105.150  27.553  1.00 15.93          
ATOM   2192  O   VAL   175      -4.804 104.066  27.471  1.00 16.71          
ATOM   2194  N   ALA   176      -6.311 105.462  26.691  1.00 17.13          
ATOM   2195  CA  ALA   176      -6.865 104.471  25.816  1.00 15.80          
ATOM   2197  CB  ALA   176      -8.171 104.961  25.233  1.00 14.01          
ATOM   2201  C   ALA   176      -5.808 104.198  24.771  1.00 17.04          
ATOM   2202  O   ALA   176      -5.591 103.035  24.407  1.00 18.17          
ATOM   2204  N   LEU   177      -5.122 105.241  24.314  1.00 15.93          
ATOM   2205  CA  LEU   177      -4.075 105.075  23.291  1.00 15.60          
ATOM   2207  CB  LEU   177      -3.623 106.433  22.684  1.00 14.99          
ATOM   2210  CG  LEU   177      -2.831 106.520  21.396  1.00 15.86          
ATOM   2212  CD1 LEU   177      -3.655 106.014  20.179  1.00  9.70          
ATOM   2216  CD2 LEU   177      -2.241 107.883  21.203  1.00 12.41          
ATOM   2220  C   LEU   177      -2.907 104.225  23.790  1.00 13.61          
ATOM   2221  O   LEU   177      -2.461 103.392  23.100  1.00 12.97          
ATOM   2223  N   ALA   178      -2.379 104.413  25.010  1.00 15.02          
ATOM   2224  CA  ALA   178      -1.346 103.557  25.509  1.00 12.58          
ATOM   2226  CB  ALA   178      -0.913 104.031  27.090  1.00 12.50          
ATOM   2230  C   ALA   178      -1.803 102.057  25.497  1.00 13.24          
ATOM   2231  O   ALA   178      -0.988 101.166  25.426  1.00 14.17          
ATOM   2233  N   ARG   179      -3.103 101.769  25.688  1.00 13.68          
ATOM   2234  CA  ARG   179      -3.628 100.423  25.693  1.00 12.53          
ATOM   2236  CB  ARG   179      -4.741 100.327  26.661  1.00 13.34          
ATOM   2239  CG  ARG   179      -4.187 100.433  28.135  1.00 13.74          
ATOM   2242  CD  ARG   179      -5.181 101.036  29.004  1.00 12.81          
ATOM   2245  NE  ARG   179      -4.651 101.243  30.377  1.00 15.74          
ATOM   2247  CZ  ARG   179      -3.865 102.245  30.734  1.00 16.14          
ATOM   2248  NH1 ARG   179      -3.541 103.192  29.833  1.00 17.19          
ATOM   2251  NH2 ARG   179      -3.467 102.334  31.971  1.00 14.79          
ATOM   2254  C   ARG   179      -4.038  99.924  24.308  1.00 13.40          
ATOM   2255  O   ARG   179      -4.381  98.769  24.163  1.00 13.16          
ATOM   2257  N   ALA   180      -3.790 100.731  23.293  1.00 12.66          
ATOM   2258  CA  ALA   180      -4.220 100.412  21.896  1.00 13.32          
ATOM   2260  CB  ALA   180      -5.088 101.538  21.418  1.00  9.90          
ATOM   2264  C   ALA   180      -3.011 100.164  21.056  1.00 14.18          
ATOM   2265  O   ALA   180      -2.927  99.131  20.414  1.00 19.33          
ATOM   2267  N   VAL   181      -2.039 101.075  21.068  1.00 15.22          
ATOM   2268  CA  VAL   181      -0.849 100.991  20.255  1.00 13.85          
ATOM   2270  CB  VAL   181      -0.860 102.135  19.120  1.00 15.98          
ATOM   2272  CG1 VAL   181      -2.155 102.081  18.357  1.00  7.73          
ATOM   2276  CG2 VAL   181      -0.656 103.523  19.716  1.00 13.22          
ATOM   2280  C   VAL   181       0.461 100.901  21.028  1.00 15.16          
ATOM   2281  O   VAL   181       0.502 100.992  22.279  1.00 15.82          
ATOM   2283  N   PRO   182       1.573 100.616  20.315  1.00 14.19          
ATOM   2284  CA  PRO   182       2.868 100.628  21.001  1.00 13.75          
ATOM   2286  CB  PRO   182       3.843 100.160  19.916  1.00 13.53          
ATOM   2289  CG  PRO   182       3.032  99.343  19.051  1.00 13.09          
ATOM   2292  CD  PRO   182       1.682 100.081  18.971  1.00 12.60          
ATOM   2295  C   PRO   182       3.299 101.974  21.526  1.00 13.83          
ATOM   2296  O   PRO   182       2.954 102.954  20.942  1.00 12.62          
ATOM   2297  N   ARG   183       4.038 101.995  22.650  1.00 13.44          
ATOM   2298  CA  ARG   183       4.558 103.211  23.203  1.00 13.38          
ATOM   2300  CB  ARG   183       5.547 102.934  24.284  1.00 15.77          
ATOM   2303  CG  ARG   183       5.003 102.142  25.512  1.00 18.09          
ATOM   2306  CD  ARG   183       6.155 101.847  26.588  1.00 26.29          
ATOM   2309  NE  ARG   183       5.731 100.924  27.657  1.00 24.27          
ATOM   2311  CZ  ARG   183       6.371 100.749  28.824  1.00 29.69          
ATOM   2312  NH1 ARG   183       7.466 101.430  29.149  1.00 28.43          
ATOM   2315  NH2 ARG   183       5.873  99.907  29.739  1.00 32.30          
ATOM   2318  C   ARG   183       5.194 104.148  22.188  1.00 15.18          
ATOM   2319  O   ARG   183       4.927 105.346  22.173  1.00 14.34          
ATOM   2321  N   LYS   184       5.970 103.614  21.250  1.00 16.19          
ATOM   2322  CA  LYS   184       6.672 104.457  20.335  1.00 15.56          
ATOM   2324  CB  LYS   184       7.652 103.603  19.501  1.00 15.75          
ATOM   2327  CG  LYS   184       8.897 103.148  20.171  1.00 14.21          
ATOM   2330  CD  LYS   184       9.909 104.258  20.363  1.00 14.47          
ATOM   2333  CE  LYS   184      11.130 103.809  21.190  1.00 15.16          
ATOM   2336  NZ  LYS   184      10.767 103.122  22.463  1.00 11.42          
ATOM   2340  C   LYS   184       5.674 105.175  19.376  1.00 16.21          
ATOM   2341  O   LYS   184       6.000 106.188  18.817  1.00 18.28          
ATOM   2343  N   VAL   185       4.530 104.560  19.092  1.00 16.20          
ATOM   2344  CA  VAL   185       3.482 105.117  18.199  1.00 13.76          
ATOM   2346  CB  VAL   185       2.638 104.025  17.610  1.00 13.98          
ATOM   2348  CG1 VAL   185       1.288 104.568  16.898  1.00  9.73          
ATOM   2352  CG2 VAL   185       3.464 103.207  16.582  1.00 12.89          
ATOM   2356  C   VAL   185       2.705 106.100  19.084  1.00 13.72          
ATOM   2357  O   VAL   185       2.551 107.269  18.736  1.00 12.67          
ATOM   2359  N   ALA   186       2.331 105.677  20.296  1.00 12.27          
ATOM   2360  CA  ALA   186       1.546 106.569  21.141  1.00 11.47          
ATOM   2362  CB  ALA   186       1.073 105.873  22.447  1.00 10.23          
ATOM   2366  C   ALA   186       2.287 107.858  21.382  1.00 11.39          
ATOM   2367  O   ALA   186       1.712 108.967  21.396  1.00 11.13          
ATOM   2369  N   LEU   187       3.568 107.762  21.624  1.00 13.68          
ATOM   2370  CA  LEU   187       4.279 108.922  22.109  1.00 14.98          
ATOM   2372  CB  LEU   187       5.438 108.567  23.079  1.00 16.33          
ATOM   2375  CG  LEU   187       5.187 108.269  24.512  1.00 15.86          
ATOM   2377  CD1 LEU   187       6.406 107.556  25.136  1.00 15.26          
ATOM   2381  CD2 LEU   187       4.757 109.428  25.486  1.00 18.79          
ATOM   2385  C   LEU   187       4.650 109.852  20.973  1.00 14.07          
ATOM   2386  O   LEU   187       4.708 111.061  21.208  1.00 13.86          
ATOM   2388  N   GLU   188       4.748 109.370  19.711  1.00 16.26          
ATOM   2389  CA  GLU   188       4.968 110.277  18.638  1.00 13.66          
ATOM   2391  CB  GLU   188       5.315 109.608  17.304  1.00 15.77          
ATOM   2394  CG  GLU   188       5.935 110.580  16.321  1.00 11.44          
ATOM   2397  CD  GLU   188       6.002 110.080  14.897  1.00 21.65          
ATOM   2398  OE1 GLU   188       6.090 108.837  14.675  1.00 17.68          
ATOM   2399  OE2 GLU   188       5.983 110.977  13.985  1.00 20.00          
ATOM   2400  C   GLU   188       3.697 111.074  18.509  1.00 16.10          
ATOM   2401  O   GLU   188       3.728 112.300  18.403  1.00 19.11          
ATOM   2403  N   MET   189       2.568 110.373  18.503  1.00 15.67          
ATOM   2404  CA  MET   189       1.245 110.944  18.386  1.00 14.76          
ATOM   2406  CB  MET   189       0.223 109.820  18.476  1.00 16.05          
ATOM   2409  CG  MET   189      -0.192 109.235  17.113  1.00 11.41          
ATOM   2412  SD  MET   189      -1.299 107.831  17.427  1.00 15.18          
ATOM   2413  CE  MET   189      -2.885 108.711  17.284  1.00 10.20          
ATOM   2417  C   MET   189       0.881 111.983  19.415  1.00 13.16          
ATOM   2418  O   MET   189       0.362 113.020  19.111  1.00 12.74          
ATOM   2420  N   LEU   190       1.163 111.686  20.648  1.00 13.46          
ATOM   2421  CA  LEU   190       1.007 112.651  21.758  1.00 13.26          
ATOM   2423  CB  LEU   190       1.172 111.896  23.085  1.00 12.76          
ATOM   2426  CG  LEU   190      -0.041 110.953  23.427  1.00 15.20          
ATOM   2428  CD1 LEU   190       0.342 109.960  24.610  1.00 10.62          
ATOM   2432  CD2 LEU   190      -1.373 111.659  23.801  1.00  9.41          
ATOM   2436  C   LEU   190       1.916 113.923  21.809  1.00 13.41          
ATOM   2437  O   LEU   190       1.441 115.039  22.144  1.00 12.31          
ATOM   2439  N   PHE   191       3.219 113.734  21.593  1.00 13.82          
ATOM   2440  CA  PHE   191       4.180 114.821  21.611  1.00 13.38          
ATOM   2442  CB  PHE   191       5.621 114.271  21.785  1.00 13.20          
ATOM   2445  CG  PHE   191       5.928 113.726  23.145  1.00 15.67          
ATOM   2446  CD1 PHE   191       5.438 114.319  24.316  1.00 11.51          
ATOM   2448  CE1 PHE   191       5.760 113.755  25.521  1.00 14.34          
ATOM   2450  CZ  PHE   191       6.558 112.674  25.594  1.00 12.42          
ATOM   2452  CE2 PHE   191       7.108 112.149  24.432  1.00 13.47          
ATOM   2454  CD2 PHE   191       6.740 112.606  23.264  1.00 13.04          
ATOM   2456  C   PHE   191       4.137 115.686  20.356  1.00 14.04          
ATOM   2457  O   PHE   191       4.506 116.891  20.425  1.00 14.78          
ATOM   2459  N   THR   192       3.689 115.134  19.229  1.00 13.16          
ATOM   2460  CA  THR   192       3.681 115.936  17.956  1.00 13.89          
ATOM   2462  CB  THR   192       4.352 115.169  16.800  1.00 12.82          
ATOM   2464  OG1 THR   192       3.631 113.956  16.553  1.00 12.98          
ATOM   2466  CG2 THR   192       5.800 114.804  17.141  1.00 12.48          
ATOM   2470  C   THR   192       2.300 116.317  17.407  1.00 14.50          
ATOM   2471  O   THR   192       2.187 117.235  16.600  1.00 15.91          
ATOM   2473  N   GLY   193       1.261 115.554  17.731  1.00 15.16          
ATOM   2474  CA  GLY   193      -0.111 115.890  17.349  1.00 13.21          
ATOM   2477  C   GLY   193      -0.453 115.579  15.886  1.00 14.47          
ATOM   2478  O   GLY   193      -1.570 115.866  15.458  1.00 11.68          
ATOM   2480  N   GLU   194       0.378 114.845  15.193  1.00 14.01          
ATOM   2481  CA  GLU   194       0.022 114.437  13.862  1.00 16.76          
ATOM   2483  CB  GLU   194       1.277 114.336  13.000  1.00 17.80          
ATOM   2486  CG  GLU   194       2.118 115.670  12.989  1.00 22.11          
ATOM   2489  CD  GLU   194       1.936 116.482  11.769  1.00 24.74          
ATOM   2490  OE1 GLU   194       0.906 116.402  11.071  1.00 23.22          
ATOM   2491  OE2 GLU   194       2.886 117.207  11.450  1.00 34.60          
ATOM   2492  C   GLU   194      -0.850 113.190  13.715  1.00 15.67          
ATOM   2493  O   GLU   194      -0.580 112.138  14.278  1.00 14.15          
ATOM   2495  N   PRO   195      -1.886 113.300  12.895  1.00 14.69          
ATOM   2496  CA  PRO   195      -2.718 112.173  12.696  1.00 14.86          
ATOM   2498  CB  PRO   195      -3.653 112.671  11.550  1.00 15.80          
ATOM   2501  CG  PRO   195      -2.811 113.512  10.737  1.00 12.58          
ATOM   2504  CD  PRO   195      -2.018 114.261  11.786  1.00 15.77          
ATOM   2507  C   PRO   195      -1.901 110.912  12.128  1.00 14.58          
ATOM   2508  O   PRO   195      -0.835 111.053  11.564  1.00  8.63          
ATOM   2509  N   ILE   196      -2.412 109.726  12.465  1.00 14.84          
ATOM   2510  CA  ILE   196      -2.167 108.529  11.793  1.00 14.45          
ATOM   2512  CB  ILE   196      -1.750 107.326  12.600  1.00 14.39          
ATOM   2514  CG1 ILE   196      -2.928 106.781  13.464  1.00 15.65          
ATOM   2517  CD  ILE   196      -2.544 105.621  14.499  1.00 11.63          
ATOM   2521  CG2 ILE   196      -0.395 107.632  13.279  1.00 13.20          
ATOM   2525  C   ILE   196      -3.455 108.204  11.051  1.00 15.62          
ATOM   2526  O   ILE   196      -4.602 108.541  11.511  1.00 14.49          
ATOM   2528  N   SER   197      -3.224 107.593   9.897  1.00 11.08          
ATOM   2529  CA  SER   197      -4.312 107.127   9.129  1.00 14.10          
ATOM   2531  CB  SER   197      -3.849 106.874   7.672  1.00 11.64          
ATOM   2534  OG  SER   197      -2.965 105.783   7.822  1.00 14.41          
ATOM   2536  C   SER   197      -4.818 105.784   9.650  1.00 12.85          
ATOM   2537  O   SER   197      -4.136 105.126  10.410  1.00 12.13          
ATOM   2539  N   ALA   198      -5.960 105.388   9.078  1.00 12.74          
ATOM   2540  CA  ALA   198      -6.697 104.195   9.380  1.00 12.91          
ATOM   2542  CB  ALA   198      -8.125 104.216   8.733  1.00 11.76          
ATOM   2546  C   ALA   198      -5.890 102.968   9.009  1.00 15.33          
ATOM   2547  O   ALA   198      -5.988 101.999   9.676  1.00 15.30          
ATOM   2549  N   GLN   199      -5.066 102.998   7.965  1.00 17.46          
ATOM   2550  CA  GLN   199      -4.204 101.844   7.708  1.00 18.62          
ATOM   2552  CB  GLN   199      -3.447 102.006   6.403  1.00 18.95          
ATOM   2555  CG  GLN   199      -4.292 102.060   5.089  1.00 19.74          
ATOM   2558  CD  GLN   199      -5.328 103.261   4.900  1.00 17.57          
ATOM   2559  OE1 GLN   199      -5.067 104.433   5.285  1.00 22.03          
ATOM   2560  NE2 GLN   199      -6.539 102.929   4.327  1.00  5.76          
ATOM   2563  C   GLN   199      -3.217 101.559   8.815  1.00 19.07          
ATOM   2564  O   GLN   199      -3.066 100.416   9.239  1.00 19.01          
ATOM   2566  N   GLU   200      -2.568 102.629   9.289  1.00 19.39          
ATOM   2567  CA  GLU   200      -1.639 102.627  10.372  1.00 17.75          
ATOM   2569  CB  GLU   200      -0.938 104.016  10.467  1.00 18.59          
ATOM   2572  CG  GLU   200      -0.123 104.440   9.146  1.00 19.47          
ATOM   2575  CD  GLU   200       0.227 105.995   9.049  1.00 23.04          
ATOM   2576  OE1 GLU   200      -0.213 106.792   9.926  1.00 23.16          
ATOM   2577  OE2 GLU   200       0.895 106.450   8.065  1.00 26.47          
ATOM   2578  C   GLU   200      -2.267 102.296  11.720  1.00 17.53          
ATOM   2579  O   GLU   200      -1.687 101.538  12.552  1.00 14.24          
ATOM   2581  N   ALA   201      -3.414 102.888  11.983  1.00 17.46          
ATOM   2582  CA  ALA   201      -4.134 102.512  13.218  1.00 15.81          
ATOM   2584  CB  ALA   201      -5.399 103.324  13.368  1.00 17.82          
ATOM   2588  C   ALA   201      -4.499 101.033  13.078  1.00 16.05          
ATOM   2589  O   ALA   201      -4.535 100.368  14.018  1.00 12.65          
ATOM   2591  N   LEU   202      -4.799 100.518  11.866  1.00 15.15          
ATOM   2592  CA  LEU   202      -5.079  99.062  11.761  1.00 16.60          
ATOM   2594  CB  LEU   202      -5.662  98.635  10.393  1.00 14.11          
ATOM   2597  CG  LEU   202      -5.909  97.131  10.254  1.00 14.17          
ATOM   2599  CD1 LEU   202      -6.933  96.662  11.181  1.00 10.30          
ATOM   2603  CD2 LEU   202      -6.276  96.674   8.762  1.00  6.93          
ATOM   2607  C   LEU   202      -3.807  98.222  12.129  1.00 17.80          
ATOM   2608  O   LEU   202      -3.878  97.379  13.019  1.00 20.48          
ATOM   2610  N   LEU   203      -2.656  98.555  11.544  1.00 17.59          
ATOM   2611  CA  LEU   203      -1.429  97.825  11.775  1.00 18.35          
ATOM   2613  CB  LEU   203      -0.297  98.488  11.010  1.00 18.94          
ATOM   2616  CG  LEU   203       1.043  97.768  10.922  1.00 21.00          
ATOM   2618  CD1 LEU   203       1.190  97.414   9.449  1.00 24.89          
ATOM   2622  CD2 LEU   203       2.209  98.632  11.305  1.00 26.89          
ATOM   2626  C   LEU   203      -0.998  97.807  13.218  1.00 18.20          
ATOM   2627  O   LEU   203      -0.338  96.856  13.663  1.00 20.33          
ATOM   2629  N   HSD   204      -1.273  98.900  13.907  1.00 17.02          
ATOM   2630  CA  HSD   204      -0.728  99.131  15.234  1.00 17.25          
ATOM   2632  CB  HSD   204      -0.203 100.553  15.369  1.00 16.74          
ATOM   2635  CG  HSD   204       1.093 100.729  14.676  1.00 18.87          
ATOM   2636  ND1 HSD   204       2.157  99.882  14.902  1.00 22.98          
ATOM   2638  CE1 HSD   204       3.153 100.212  14.106  1.00 21.31          
ATOM   2640  NE2 HSD   204       2.756 101.220  13.350  1.00 20.85          
ATOM   2642  CD2 HSD   204       1.477 101.566  13.687  1.00 18.98          
ATOM   2644  C   HSD   204      -1.654  98.782  16.358  1.00 16.73          
ATOM   2645  O   HSD   204      -1.243  98.784  17.497  1.00 18.93          
ATOM   2647  N   GLY   205      -2.879  98.408  16.047  1.00 16.80          
ATOM   2648  CA  GLY   205      -3.774  97.896  17.035  1.00 17.30          
ATOM   2651  C   GLY   205      -4.869  98.863  17.470  1.00 17.34          
ATOM   2652  O   GLY   205      -5.606  98.494  18.429  1.00 14.11          
ATOM   2654  N   LEU   206      -5.028 100.015  16.740  1.00 14.87          
ATOM   2655  CA  LEU   206      -6.093 100.963  17.128  1.00 15.55          
ATOM   2657  CB  LEU   206      -5.815 102.441  16.664  1.00 14.16          
ATOM   2660  CG  LEU   206      -6.820 103.556  17.045  1.00 12.78          
ATOM   2662  CD1 LEU   206      -7.503 103.424  18.333  1.00 20.82          
ATOM   2666  CD2 LEU   206      -6.183 104.910  16.994  1.00 15.60          
ATOM   2670  C   LEU   206      -7.477 100.488  16.711  1.00 14.99          
ATOM   2671  O   LEU   206      -8.414 100.664  17.458  1.00 14.65          
ATOM   2673  N   LEU   207      -7.548  99.925  15.485  1.00 14.78          
ATOM   2674  CA  LEU   207      -8.704  99.420  14.835  1.00 14.16          
ATOM   2676  CB  LEU   207      -8.769 100.007  13.376  1.00 14.90          
ATOM   2679  CG  LEU   207      -8.827 101.563  13.292  1.00 13.55          
ATOM   2681  CD1 LEU   207      -8.549 102.044  11.845  1.00 14.59          
ATOM   2685  CD2 LEU   207     -10.197 102.130  13.827  1.00  7.65          
ATOM   2689  C   LEU   207      -8.664  97.877  14.752  1.00 15.12          
ATOM   2690  O   LEU   207      -7.603  97.251  14.797  1.00 15.49          
ATOM   2692  N   SER   208      -9.848  97.286  14.559  1.00 15.66          
ATOM   2693  CA  SER   208     -10.067  95.832  14.288  1.00 14.66          
ATOM   2695  CB  SER   208     -11.378  95.301  14.949  1.00 13.97          
ATOM   2698  OG  SER   208     -11.455  95.674  16.324  1.00 12.76          
ATOM   2700  C   SER   208     -10.116  95.578  12.808  1.00 14.17          
ATOM   2701  O   SER   208      -9.495  94.620  12.297  1.00 11.84          
ATOM   2703  N   LYS   209     -10.831  96.455  12.113  1.00 15.33          
ATOM   2704  CA  LYS   209     -10.987  96.353  10.630  1.00 15.92          
ATOM   2706  CB  LYS   209     -12.322  95.634  10.279  1.00 15.35          
ATOM   2709  CG  LYS   209     -12.355  94.142  10.708  1.00 17.64          
ATOM   2712  CD  LYS   209     -11.567  93.203   9.711  1.00 20.11          
ATOM   2715  CE  LYS   209     -11.666  91.731  10.123  1.00 19.47          
ATOM   2718  NZ  LYS   209     -10.901  91.692  11.344  1.00 20.65          
ATOM   2722  C   LYS   209     -10.950  97.711   9.937  1.00 15.36          
ATOM   2723  O   LYS   209     -11.355  98.672  10.538  1.00 15.46          
ATOM   2725  N   VAL   210     -10.479  97.750   8.689  1.00 15.08          
ATOM   2726  CA  VAL   210     -10.553  98.951   7.829  1.00 15.57          
ATOM   2728  CB  VAL   210      -9.168  99.696   7.643  1.00 14.71          
ATOM   2730  CG1 VAL   210      -9.272 100.831   6.619  1.00 18.35          
ATOM   2734  CG2 VAL   210      -8.604 100.180   8.959  1.00 18.35          
ATOM   2738  C   VAL   210     -11.155  98.506   6.474  1.00 14.68          
ATOM   2739  O   VAL   210     -10.706  97.549   5.873  1.00 14.03          
ATOM   2741  N   VAL   211     -12.181  99.185   6.001  1.00 15.64          
ATOM   2742  CA  VAL   211     -12.831  98.810   4.697  1.00 15.09          
ATOM   2744  CB  VAL   211     -14.145  97.980   4.989  1.00 16.09          
ATOM   2746  CG1 VAL   211     -13.862  96.746   5.837  1.00 14.13          
ATOM   2750  CG2 VAL   211     -15.209  98.830   5.691  1.00 15.98          
ATOM   2754  C   VAL   211     -13.174 100.025   3.866  1.00 14.77          
ATOM   2755  O   VAL   211     -13.233 101.080   4.396  1.00 11.73          
ATOM   2757  N   PRO   212     -13.445  99.900   2.512  1.00 17.06          
ATOM   2758  CA  PRO   212     -13.921 101.159   1.922  1.00 17.19          
ATOM   2760  CB  PRO   212     -14.305 100.750   0.497  1.00 18.82          
ATOM   2763  CG  PRO   212     -13.353  99.628   0.192  1.00 19.04          
ATOM   2766  CD  PRO   212     -13.052  98.925   1.485  1.00 16.13          
ATOM   2769  C   PRO   212     -15.135 101.791   2.658  1.00 18.76          
ATOM   2770  O   PRO   212     -15.906 101.120   3.384  1.00 17.33          
ATOM   2771  N   GLU   213     -15.307 103.086   2.482  1.00 19.25          
ATOM   2772  CA  GLU   213     -16.484 103.738   3.022  1.00 20.79          
ATOM   2774  CB  GLU   213     -16.477 105.206   2.596  1.00 21.02          
ATOM   2777  CG  GLU   213     -17.736 105.977   2.967  1.00 24.18          
ATOM   2780  CD  GLU   213     -17.585 107.491   2.811  1.00 27.14          
ATOM   2781  OE1 GLU   213     -17.184 107.981   1.714  1.00 28.50          
ATOM   2782  OE2 GLU   213     -17.856 108.177   3.819  1.00 30.21          
ATOM   2783  C   GLU   213     -17.824 103.033   2.612  1.00 21.38          
ATOM   2784  O   GLU   213     -18.810 103.032   3.390  1.00 23.43          
ATOM   2786  N   ALA   214     -17.833 102.432   1.420  1.00 20.19          
ATOM   2787  CA  ALA   214     -18.988 101.723   0.852  1.00 20.15          
ATOM   2789  CB  ALA   214     -18.812 101.613  -0.714  1.00 18.33          
ATOM   2793  C   ALA   214     -19.225 100.332   1.504  1.00 19.74          
ATOM   2794  O   ALA   214     -20.290  99.769   1.359  1.00 17.74          
ATOM   2796  N   GLU   215     -18.262  99.812   2.283  1.00 21.29          
ATOM   2797  CA  GLU   215     -18.416  98.500   2.937  1.00 21.39          
ATOM   2799  CB  GLU   215     -17.210  97.622   2.623  1.00 21.99          
ATOM   2802  CG  GLU   215     -16.950  97.415   1.099  1.00 23.86          
ATOM   2805  CD  GLU   215     -15.724  96.513   0.816  1.00 26.03          
ATOM   2806  OE1 GLU   215     -14.945  96.119   1.730  1.00 27.52          
ATOM   2807  OE2 GLU   215     -15.547  96.163  -0.348  1.00 29.48          
ATOM   2808  C   GLU   215     -18.573  98.632   4.417  1.00 21.50          
ATOM   2809  O   GLU   215     -18.644  97.657   5.181  1.00 21.73          
ATOM   2811  N   LEU   216     -18.554  99.869   4.861  1.00 21.86          
ATOM   2812  CA  LEU   216     -18.421 100.145   6.284  1.00 19.44          
ATOM   2814  CB  LEU   216     -18.142 101.625   6.476  1.00 18.79          
ATOM   2817  CG  LEU   216     -18.039 102.169   7.936  1.00 16.12          
ATOM   2819  CD1 LEU   216     -16.962 101.490   8.719  1.00 13.83          
ATOM   2823  CD2 LEU   216     -17.864 103.637   7.891  1.00  9.01          
ATOM   2827  C   LEU   216     -19.643  99.749   7.082  1.00 20.22          
ATOM   2828  O   LEU   216     -19.529  99.118   8.115  1.00 22.13          
ATOM   2830  N   GLN   217     -20.798 100.216   6.668  1.00 22.03          
ATOM   2831  CA  GLN   217     -22.078  99.873   7.290  1.00 23.43          
ATOM   2833  CB  GLN   217     -23.216 100.646   6.575  1.00 24.69          
ATOM   2836  CG  GLN   217     -24.677 100.560   7.186  1.00 28.96          
ATOM   2839  CD  GLN   217     -24.820 101.076   8.653  1.00 33.30          
ATOM   2840  OE1 GLN   217     -24.511 102.243   8.968  1.00 36.19          
ATOM   2841  NE2 GLN   217     -25.338 100.214   9.528  1.00 34.41          
ATOM   2844  C   GLN   217     -22.291  98.352   7.283  1.00 23.28          
ATOM   2845  O   GLN   217     -22.572  97.784   8.308  1.00 23.33          
ATOM   2847  N   GLU   218     -22.105  97.687   6.152  1.00 23.93          
ATOM   2848  CA  GLU   218     -22.224  96.230   6.108  1.00 24.99          
ATOM   2850  CB  GLU   218     -22.186  95.694   4.692  1.00 25.20          
ATOM   2853  CG  GLU   218     -22.222  94.125   4.663  1.00 31.40          
ATOM   2856  CD  GLU   218     -23.501  93.449   5.354  1.00 37.43          
ATOM   2857  OE1 GLU   218     -24.658  93.787   4.944  1.00 42.00          
ATOM   2858  OE2 GLU   218     -23.341  92.552   6.252  1.00 37.45          
ATOM   2859  C   GLU   218     -21.175  95.488   6.917  1.00 24.20          
ATOM   2860  O   GLU   218     -21.494  94.466   7.552  1.00 23.78          
ATOM   2862  N   GLU   219     -19.934  95.982   6.912  1.00 24.03          
ATOM   2863  CA  GLU   219     -18.886  95.317   7.666  1.00 23.56          
ATOM   2865  CB  GLU   219     -17.507  95.828   7.309  1.00 24.48          
ATOM   2868  CG  GLU   219     -16.389  95.123   8.117  1.00 27.49          
ATOM   2871  CD  GLU   219     -16.099  93.700   7.628  1.00 31.58          
ATOM   2872  OE1 GLU   219     -16.823  93.172   6.722  1.00 34.57          
ATOM   2873  OE2 GLU   219     -15.128  93.120   8.153  1.00 34.06          
ATOM   2874  C   GLU   219     -19.093  95.427   9.124  1.00 21.74          
ATOM   2875  O   GLU   219     -18.815  94.496   9.865  1.00 24.10          
ATOM   2877  N   THR   220     -19.566  96.567   9.583  1.00 20.51          
ATOM   2878  CA  THR   220     -19.850  96.741  11.020  1.00 17.78          
ATOM   2880  CB  THR   220     -20.187  98.189  11.276  1.00 17.27          
ATOM   2882  OG1 THR   220     -19.047  98.984  10.954  1.00 17.78          
ATOM   2884  CG2 THR   220     -20.679  98.448  12.706  1.00 16.86          
ATOM   2888  C   THR   220     -21.082  95.937  11.434  1.00 17.39          
ATOM   2889  O   THR   220     -21.186  95.490  12.589  1.00 15.62          
ATOM   2891  N   MET   221     -22.050  95.831  10.501  1.00 16.50          
ATOM   2892  CA  MET   221     -23.284  95.049  10.724  1.00 17.34          
ATOM   2894  CB  MET   221     -24.372  95.341   9.642  1.00 17.93          
ATOM   2897  CG  MET   221     -25.119  96.659   9.843  1.00 19.23          
ATOM   2900  SD  MET   221     -25.605  96.801  11.607  1.00 24.57          
ATOM   2901  CE  MET   221     -27.246  96.093  11.392  1.00 21.33          
ATOM   2905  C   MET   221     -23.020  93.541  10.759  1.00 17.15          
ATOM   2906  O   MET   221     -23.736  92.839  11.393  1.00 16.60          
ATOM   2908  N   ARG   222     -22.043  93.059  10.007  1.00 17.61          
ATOM   2909  CA  ARG   222     -21.626  91.678  10.031  1.00 18.05          
ATOM   2911  CB  ARG   222     -20.470  91.443   9.043  1.00 18.43          
ATOM   2914  CG  ARG   222     -19.984  89.983   8.921  1.00 19.56          
ATOM   2917  CD  ARG   222     -18.661  89.841   8.102  1.00 22.18          
ATOM   2920  NE  ARG   222     -17.555  90.652   8.667  1.00 25.51          
ATOM   2922  CZ  ARG   222     -16.845  90.324   9.742  1.00 25.92          
ATOM   2923  NH1 ARG   222     -17.092  89.216  10.385  1.00 29.49          
ATOM   2926  NH2 ARG   222     -15.868  91.084  10.176  1.00 28.66          
ATOM   2929  C   ARG   222     -21.148  91.306  11.414  1.00 17.99          
ATOM   2930  O   ARG   222     -21.501  90.252  11.914  1.00 18.12          
ATOM   2932  N   ILE   223     -20.292  92.152  12.000  1.00 18.21          
ATOM   2933  CA  ILE   223     -19.815  91.929  13.376  1.00 17.43          
ATOM   2935  CB  ILE   223     -18.650  92.921  13.811  1.00 16.78          
ATOM   2937  CG1 ILE   223     -17.392  92.698  12.966  1.00 17.99          
ATOM   2940  CD  ILE   223     -16.388  93.920  13.040  1.00 15.84          
ATOM   2944  CG2 ILE   223     -18.318  92.804  15.249  1.00 13.85          
ATOM   2948  C   ILE   223     -21.015  92.019  14.308  1.00 16.64          
ATOM   2949  O   ILE   223     -21.161  91.175  15.166  1.00 16.90          
ATOM   2951  N   ALA   224     -21.864  93.024  14.136  1.00 15.31          
ATOM   2952  CA  ALA   224     -22.905  93.273  15.158  1.00 15.78          
ATOM   2954  CB  ALA   224     -23.548  94.745  15.021  1.00 14.62          
ATOM   2958  C   ALA   224     -24.007  92.170  15.139  1.00 14.91          
ATOM   2959  O   ALA   224     -24.485  91.769  16.181  1.00 13.13          
ATOM   2961  N   ARG   225     -24.428  91.755  13.940  1.00 15.23          
ATOM   2962  CA  ARG   225     -25.376  90.669  13.750  1.00 16.23          
ATOM   2964  CB  ARG   225     -25.720  90.483  12.257  1.00 16.86          
ATOM   2967  CG  ARG   225     -26.643  91.504  11.776  1.00 20.23          
ATOM   2970  CD  ARG   225     -27.407  91.074  10.575  1.00 25.65          
ATOM   2973  NE  ARG   225     -27.654  92.232   9.717  1.00 29.44          
ATOM   2975  CZ  ARG   225     -26.869  92.596   8.698  1.00 32.85          
ATOM   2976  NH1 ARG   225     -25.752  91.896   8.383  1.00 32.04          
ATOM   2979  NH2 ARG   225     -27.211  93.666   7.980  1.00 32.54          
ATOM   2982  C   ARG   225     -24.836  89.365  14.231  1.00 16.34          
ATOM   2983  O   ARG   225     -25.607  88.558  14.761  1.00 18.15          
ATOM   2985  N   LYS   226     -23.546  89.096  13.984  1.00 15.65          
ATOM   2986  CA  LYS   226     -22.926  87.890  14.516  1.00 15.61          
ATOM   2988  CB  LYS   226     -21.485  87.748  14.104  1.00 15.11          
ATOM   2991  CG  LYS   226     -20.764  86.542  14.698  1.00 15.61          
ATOM   2994  CD  LYS   226     -21.543  85.216  14.583  1.00 14.54          
ATOM   2997  CE  LYS   226     -20.686  84.046  15.051  1.00 14.02          
ATOM   3000  NZ  LYS   226     -21.290  82.725  14.679  1.00 17.57          
ATOM   3004  C   LYS   226     -23.036  87.877  16.007  1.00 15.66          
ATOM   3005  O   LYS   226     -23.430  86.909  16.601  1.00 18.10          
ATOM   3007  N   ILE   227     -22.714  88.971  16.624  1.00 15.72          
ATOM   3008  CA  ILE   227     -22.786  89.054  18.077  1.00 15.33          
ATOM   3010  CB  ILE   227     -22.212  90.403  18.599  1.00 13.82          
ATOM   3012  CG1 ILE   227     -20.687  90.453  18.344  1.00 15.84          
ATOM   3015  CD  ILE   227     -19.874  91.755  18.995  1.00  9.69          
ATOM   3019  CG2 ILE   227     -22.458  90.561  20.114  1.00 14.42          
ATOM   3023  C   ILE   227     -24.204  88.872  18.569  1.00 14.80          
ATOM   3024  O   ILE   227     -24.417  88.167  19.515  1.00 16.94          
ATOM   3026  N   ALA   228     -25.132  89.586  17.962  1.00 14.71          
ATOM   3027  CA  ALA   228     -26.551  89.567  18.275  1.00 15.02          
ATOM   3029  CB  ALA   228     -27.317  90.628  17.420  1.00 13.51          
ATOM   3033  C   ALA   228     -27.190  88.150  18.114  1.00 15.09          
ATOM   3034  O   ALA   228     -28.139  87.824  18.801  1.00 14.60          
ATOM   3036  N   SER   229     -26.619  87.346  17.220  1.00 15.04          
ATOM   3037  CA  SER   229     -26.992  85.970  17.044  1.00 14.66          
ATOM   3039  CB  SER   229     -26.544  85.498  15.676  1.00 14.33          
ATOM   3042  OG  SER   229     -25.239  85.032  15.696  1.00 13.00          
ATOM   3044  C   SER   229     -26.466  84.994  18.066  1.00 14.70          
ATOM   3045  O   SER   229     -26.821  83.830  17.973  1.00 14.93          
ATOM   3047  N   LEU   230     -25.578  85.424  18.958  1.00 13.97          
ATOM   3048  CA  LEU   230     -25.002  84.560  20.017  1.00 13.95          
ATOM   3050  CB  LEU   230     -23.507  84.855  20.251  1.00 13.31          
ATOM   3053  CG  LEU   230     -22.597  84.633  19.045  1.00 14.28          
ATOM   3055  CD1 LEU   230     -21.222  85.339  19.256  1.00 13.01          
ATOM   3059  CD2 LEU   230     -22.501  83.118  18.707  1.00 13.08          
ATOM   3063  C   LEU   230     -25.742  84.674  21.359  1.00 13.72          
ATOM   3064  O   LEU   230     -26.685  85.428  21.481  1.00 14.55          
ATOM   3066  N   SER   231     -25.347  83.875  22.355  1.00 13.96          
ATOM   3067  CA  SER   231     -25.977  83.950  23.669  1.00 13.31          
ATOM   3069  CB  SER   231     -25.675  82.726  24.476  1.00 12.96          
ATOM   3072  OG  SER   231     -25.981  82.958  25.830  1.00 11.33          
ATOM   3074  C   SER   231     -25.474  85.149  24.455  1.00 14.36          
ATOM   3075  O   SER   231     -24.297  85.218  24.802  1.00 15.12          
ATOM   3077  N   ARG   232     -26.377  86.069  24.786  1.00 14.66          
ATOM   3078  CA  ARG   232     -26.082  87.204  25.635  1.00 14.70          
ATOM   3080  CB  ARG   232     -27.326  88.030  25.937  1.00 13.46          
ATOM   3083  CG  ARG   232     -27.017  89.470  26.314  1.00 17.14          
ATOM   3086  CD  ARG   232     -28.102  90.058  27.218  1.00 21.44          
ATOM   3089  NE  ARG   232     -28.145  91.520  27.275  1.00 21.71          
ATOM   3091  CZ  ARG   232     -27.828  92.273  28.328  1.00 22.46          
ATOM   3092  NH1 ARG   232     -27.369  91.776  29.447  1.00 21.91          
ATOM   3095  NH2 ARG   232     -27.968  93.569  28.244  1.00 23.29          
ATOM   3098  C   ARG   232     -25.338  86.860  26.938  1.00 14.71          
ATOM   3099  O   ARG   232     -24.340  87.502  27.257  1.00 13.88          
END
