
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  264 ( 2068),  selected  264 , name 2ppy_A
# Molecule2: number of CA atoms  201 ( 1504),  selected  201 , name T0486_32_232.pdb
# PARAMETERS: 2ppy_A.T0486_32_232.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T     2_A      -       -           -
LGA    A     3_A      -       -           -
LGA    V     4_A      -       -           -
LGA    E     5_A      -       -           -
LGA    T     6_A      -       -           -
LGA    K     7_A      -       -           -
LGA    K     8_A      P      32          4.596
LGA    Q     9_A      R      33          1.630
LGA    Y    10_A      P      34          0.341
LGA    L    11_A      T      35          0.683
LGA    T    12_A      S      36          0.706
LGA    V    13_A      A      37          0.709
LGA    F    14_A      R      38          0.614
LGA    K    15_A      Q      39          0.443
LGA    E    16_A      L      40          0.615
LGA    D    17_A      D      41          0.619
LGA    G    18_A      G      42          0.853
LGA    I    19_A      I      43          0.613
LGA    A    20_A      R      44          0.296
LGA    E    21_A      N      45          0.269
LGA    I    22_A      I      46          0.121
LGA    H    23_A      V      47          0.828
LGA    L    24_A      L      48          0.957
LGA    H    25_A      S      49          0.632
LGA    I    26_A      N      50          1.508
LGA    N    27_A      P      51          3.122
LGA    K    28_A      K      52          2.263
LGA    -       -      K      53           -
LGA    S    29_A      R      54          1.006
LGA    N    30_A      N      55          0.826
LGA    S    31_A      T      56          1.255
LGA    Y    32_A      L      57          2.378
LGA    D    33_A      S      58          1.033
LGA    L    34_A      L      59          0.646
LGA    E    35_A      A      60          1.113
LGA    F    36_A      M      61          1.125
LGA    Y    37_A      L      62          0.986
LGA    K    38_A      K      63          1.070
LGA    E    39_A      S      64          1.081
LGA    F    40_A      L      65          1.069
LGA    N    41_A      Q      66          1.155
LGA    A    42_A      S      67          1.157
LGA    A    43_A      D      68          1.242
LGA    I    44_A      I      69          1.605
LGA    D    45_A      L      70          1.361
LGA    D    46_A      X      71          0.465
LGA    I    47_A      D      72          4.062
LGA    R    48_A      A      73          1.205
LGA    F    49_A      D      74          3.045
LGA    D    50_A      S      75          2.421
LGA    P    51_A      N      76          2.076
LGA    D    52_A      D      77          1.060
LGA    I    53_A      L      78          0.822
LGA    K    54_A      K      79          1.132
LGA    V    55_A      V      80          0.535
LGA    V    56_A      I      81          0.253
LGA    I    57_A      I      82          0.260
LGA    V    58_A      I      83          0.457
LGA    X    59_A      S      84          0.584
LGA    S    60_A      A      85          0.706
LGA    D    61_A      E      86          1.516
LGA    V    62_A      G      87          1.889
LGA    P    63_A      -       -           -
LGA    K    64_A      P      88          0.975
LGA    F    65_A      V      89          0.953
LGA    F    66_A      F      90          0.838
LGA    S    67_A      S      91          0.736
LGA    A    68_A      S      92          0.881
LGA    G    69_A      G      93          0.729
LGA    A    70_A      X      94          0.953
LGA    D    71_A      D      95          1.549
LGA    I    72_A      L      96          1.872
LGA    N    73_A      K      97          2.565
LGA    F    74_A      E      98          3.147
LGA    L    75_A      L      99          2.983
LGA    R    76_A      T     100          2.513
LGA    -       -      E     101           -
LGA    S    77_A      E     102          4.619
LGA    A    78_A      Q     103          2.043
LGA    D    79_A      G     104          1.562
LGA    P    80_A      R     105          2.514
LGA    R    81_A      D     106          2.855
LGA    F    82_A      Y     107          1.548
LGA    K    83_A      X     108          0.500
LGA    T    84_A      A     109          1.587
LGA    Q    85_A      E     110          2.269
LGA    F    86_A      V     111          1.742
LGA    C    87_A      F     112          0.689
LGA    L    88_A      Q     113          1.031
LGA    F    89_A      T     114          1.708
LGA    C    90_A      C     115          1.294
LGA    N    91_A      S     116          0.594
LGA    E    92_A      K     117          1.323
LGA    T    93_A      V     118          1.808
LGA    L    94_A      M     119          1.337
LGA    D    95_A      M     120          0.827
LGA    K    96_A      X     121          0.989
LGA    I    97_A      I     122          0.950
LGA    A    98_A      R     123          0.815
LGA    R    99_A      N     124          0.665
LGA    S   100_A      X     125          0.666
LGA    P   101_A      P     126          0.979
LGA    Q   102_A      V     127          0.898
LGA    V   103_A      P     128          0.509
LGA    Y   104_A      V     129          0.380
LGA    I   105_A      I     130          0.383
LGA    A   106_A      A     131          0.295
LGA    C   107_A      M     132          0.246
LGA    L   108_A      V     133          0.397
LGA    E   109_A      N     134          0.606
LGA    G   110_A      G     135          1.297
LGA    H   111_A      L     136          0.688
LGA    T   112_A      A     137          0.730
LGA    V   113_A      T     138          0.823
LGA    G   114_A      A     139          0.890
LGA    G   115_A      A     140          1.042
LGA    G   116_A      G     141          0.695
LGA    L   117_A      C     142          0.663
LGA    E   118_A      Q     143          0.799
LGA    X   119_A      L     144          1.098
LGA    A   120_A      V     145          1.015
LGA    L   121_A      A     146          1.444
LGA    A   122_A      S     147          1.308
LGA    C   123_A      C     148          0.958
LGA    D   124_A      D     149          0.645
LGA    L   125_A      I     150          1.121
LGA    R   126_A      A     151          0.981
LGA    F   127_A      V     152          0.593
LGA    X   128_A      A     153          0.443
LGA    G   129_A      S     154          0.075
LGA    D   130_A      D     155          0.858
LGA    E   131_A      K     156          1.574
LGA    A   132_A      S     157          2.392
LGA    G   133_A      -       -           -
LGA    K   134_A      S     158          2.326
LGA    I   135_A      F     159          0.707
LGA    G   136_A      A     160          1.429
LGA    L   137_A      T     161          0.730
LGA    P   138_A      P     162          0.659
LGA    E   139_A      G     163          0.774
LGA    V   140_A      V     164          1.104
LGA    S   141_A      N     165          0.858
LGA    L   142_A      V     166          0.903
LGA    G   143_A      G     167          0.914
LGA    V   144_A      L     168          1.234
LGA    L   145_A      F     169          1.863
LGA    A   146_A      C     170          1.906
LGA    G   147_A      S     171          3.901
LGA    T   148_A      -       -           -
LGA    G   149_A      T     172          3.410
LGA    G   150_A      P     173          1.323
LGA    T   151_A      G     174          1.163
LGA    Q   152_A      V     175          1.612
LGA    R   153_A      A     176          1.660
LGA    L   154_A      L     177          0.837
LGA    A   155_A      A     178          0.964
LGA    R   156_A      R     179          1.712
LGA    L   157_A      A     180          1.554
LGA    I   158_A      V     181          0.886
LGA    G   159_A      P     182          2.130
LGA    Y   160_A      R     183          2.415
LGA    S   161_A      K     184          2.987
LGA    R   162_A      V     185          2.277
LGA    A   163_A      A     186          1.034
LGA    L   164_A      L     187          1.578
LGA    D   165_A      E     188          1.780
LGA    X   166_A      M     189          1.136
LGA    N   167_A      L     190          0.596
LGA    I   168_A      F     191          0.854
LGA    T   169_A      T     192          0.887
LGA    G   170_A      G     193          1.069
LGA    E   171_A      E     194          0.988
LGA    T   172_A      P     195          0.556
LGA    I   173_A      I     196          1.060
LGA    T   174_A      S     197          0.925
LGA    P   175_A      A     198          0.817
LGA    Q   176_A      Q     199          0.782
LGA    E   177_A      E     200          1.179
LGA    A   178_A      A     201          1.056
LGA    L   179_A      L     202          0.764
LGA    E   180_A      L     203          0.998
LGA    I   181_A      X     204          0.919
LGA    G   182_A      G     205          1.106
LGA    L   183_A      L     206          1.058
LGA    V   184_A      L     207          0.719
LGA    N   185_A      S     208          0.870
LGA    R   186_A      K     209          0.444
LGA    V   187_A      V     210          0.189
LGA    F   188_A      V     211          0.850
LGA    P   189_A      P     212          0.814
LGA    Q   190_A      E     213          0.961
LGA    A   191_A      A     214          1.594
LGA    E   192_A      E     215          1.583
LGA    T   193_A      L     216          0.686
LGA    R   194_A      Q     217          1.368
LGA    E   195_A      E     218          1.743
LGA    R   196_A      E     219          1.162
LGA    T   197_A      T     220          0.412
LGA    R   198_A      M     221          1.109
LGA    E   199_A      R     222          1.765
LGA    Y   200_A      I     223          1.413
LGA    A   201_A      A     224          0.484
LGA    R   202_A      R     225          0.583
LGA    K   203_A      K     226          1.117
LGA    L   204_A      I     227          1.107
LGA    A   205_A      A     228          0.587
LGA    N   206_A      S     229          0.838
LGA    S   207_A      L     230          2.034
LGA    A   208_A      S     231          2.747
LGA    T   209_A      R     232          3.127
LGA    Y   210_A      -       -           -
LGA    A   211_A      -       -           -
LGA    V   212_A      -       -           -
LGA    S   213_A      -       -           -
LGA    N   214_A      -       -           -
LGA    I   215_A      -       -           -
LGA    K   216_A      -       -           -
LGA    L   217_A      -       -           -
LGA    A   218_A      -       -           -
LGA    I   219_A      -       -           -
LGA    X   220_A      -       -           -
LGA    N   221_A      -       -           -
LGA    G   222_A      -       -           -
LGA    K   223_A      -       -           -
LGA    E   224_A      -       -           -
LGA    X   225_A      -       -           -
LGA    P   226_A      -       -           -
LGA    L   227_A      -       -           -
LGA    N   228_A      -       -           -
LGA    V   229_A      -       -           -
LGA    A   230_A      -       -           -
LGA    I   231_A      -       -           -
LGA    R   232_A      -       -           -
LGA    Y   233_A      -       -           -
LGA    E   234_A      -       -           -
LGA    G   235_A      -       -           -
LGA    E   236_A      -       -           -
LGA    L   237_A      -       -           -
LGA    Q   238_A      -       -           -
LGA    N   239_A      -       -           -
LGA    L   240_A      -       -           -
LGA    L   241_A      -       -           -
LGA    F   242_A      -       -           -
LGA    R   243_A      -       -           -
LGA    S   244_A      -       -           -
LGA    E   245_A      -       -           -
LGA    D   246_A      -       -           -
LGA    A   247_A      -       -           -
LGA    K   248_A      -       -           -
LGA    E   249_A      -       -           -
LGA    G   250_A      -       -           -
LGA    L   251_A      -       -           -
LGA    S   252_A      -       -           -
LGA    A   253_A      -       -           -
LGA    F   254_A      -       -           -
LGA    L   255_A      -       -           -
LGA    E   256_A      -       -           -
LGA    K   257_A      -       -           -
LGA    R   258_A      -       -           -
LGA    Q   259_A      -       -           -
LGA    P   260_A      -       -           -
LGA    N   261_A      -       -           -
LGA    W   262_A      -       -           -
LGA    K   263_A      -       -           -
LGA    G   264_A      -       -           -
LGA    I   265_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  264  201    5.0    199    1.46    28.64     92.568    12.733

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.397603 * X  +  -0.047112 * Y  +   0.916347 * Z  + -69.498039
  Y_new =  -0.080546 * X  +   0.993034 * Y  +   0.086003 * Z  +  59.835136
  Z_new =  -0.914015 * X  +  -0.108003 * Y  +   0.391039 * Z  +  54.808617 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.269477    2.872115  [ DEG:   -15.4399    164.5601 ]
  Theta =   1.153074    1.988519  [ DEG:    66.0663    113.9337 ]
  Phi   =  -0.199873    2.941719  [ DEG:   -11.4519    168.5481 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ppy_A                                        
REMARK     2: T0486_32_232.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ppy_A.T0486_32_232.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  264  201   5.0  199   1.46   28.64  92.568
REMARK  ---------------------------------------------------------- 
MOLECULE 2ppy_A
HEADER    LYASE                                   01-MAY-07   2PPY              
TITLE     CRYSTAL STRUCTURE OF ENOYL-COA HYDRATES (GK_1992) FROM                
TITLE    2 GEOBACILLUS KAUSTOPHILUS HTA426                                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ENOYL-COA HYDRATASE;                                       
COMPND   3 CHAIN: A, B, C, D, E, F;                                             
COMPND   4 EC: 4.2.1.17;                                                        
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: GEOBACILLUS KAUSTOPHILUS;                       
SOURCE   3 STRAIN: HTA426;                                                      
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: ROSETTA834(DE3);                           
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET15B                                    
KEYWDS    BETA-OXIDATION, COA, ENOYL-COA HYDRATASE, FATTY ACID                  
KEYWDS   2 METABOLISM, LYASE, STRUCTURAL GENOMICS, NPPSFA, NATIONAL             
KEYWDS   3 PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL ANALYSES,               
KEYWDS   4 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE, RSGI                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.P.KANAUJIA,J.JEYAKANTHAN,M.KAVYASHREE,K.SEKAR,A.EBIHARA,            
AUTHOR   2 S.KURAMITSU,A.SHINKAI,Y.SHIRO,S.YOKOYAMA,RIKEN STRUCTURAL            
AUTHOR   3 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   1   06-MAY-08 2PPY    0                                                
JRNL        AUTH   S.P.KANAUJIA,J.JEYAKANTHAN,M.KAVYASHREE,K.SEKAR,             
JRNL        AUTH 2 A.EBIHARA,S.KURAMITSU,A.SHINKAI,Y.SHIRO,S.YOKOYAMA           
JRNL        TITL   CRYSTAL STRUCTURE OF ENOYL-COA HYDRATES (GK_1992)            
JRNL        TITL 2 FROM GEOBACILLUS KAUSTOPHILUS HTA426                         
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.16 ANGSTROMS.                                          
DBREF  2PPY A    1   265  UNP    Q5KYF9   Q5KYF9_GEOKA     1    265             
DBREF  2PPY B    1   265  UNP    Q5KYF9   Q5KYF9_GEOKA     1    265             
DBREF  2PPY C    1   265  UNP    Q5KYF9   Q5KYF9_GEOKA     1    265             
DBREF  2PPY D    1   265  UNP    Q5KYF9   Q5KYF9_GEOKA     1    265             
DBREF  2PPY E    1   265  UNP    Q5KYF9   Q5KYF9_GEOKA     1    265             
DBREF  2PPY F    1   265  UNP    Q5KYF9   Q5KYF9_GEOKA     1    265             
SEQRES   1 A  265  MSE THR ALA VAL GLU THR LYS LYS GLN TYR LEU THR VAL          
SEQRES   2 A  265  PHE LYS GLU ASP GLY ILE ALA GLU ILE HIS LEU HIS ILE          
SEQRES   3 A  265  ASN LYS SER ASN SER TYR ASP LEU GLU PHE TYR LYS GLU          
SEQRES   4 A  265  PHE ASN ALA ALA ILE ASP ASP ILE ARG PHE ASP PRO ASP          
SEQRES   5 A  265  ILE LYS VAL VAL ILE VAL MSE SER ASP VAL PRO LYS PHE          
SEQRES   6 A  265  PHE SER ALA GLY ALA ASP ILE ASN PHE LEU ARG SER ALA          
SEQRES   7 A  265  ASP PRO ARG PHE LYS THR GLN PHE CYS LEU PHE CYS ASN          
SEQRES   8 A  265  GLU THR LEU ASP LYS ILE ALA ARG SER PRO GLN VAL TYR          
SEQRES   9 A  265  ILE ALA CYS LEU GLU GLY HIS THR VAL GLY GLY GLY LEU          
SEQRES  10 A  265  GLU MSE ALA LEU ALA CYS ASP LEU ARG PHE MSE GLY ASP          
SEQRES  11 A  265  GLU ALA GLY LYS ILE GLY LEU PRO GLU VAL SER LEU GLY          
SEQRES  12 A  265  VAL LEU ALA GLY THR GLY GLY THR GLN ARG LEU ALA ARG          
SEQRES  13 A  265  LEU ILE GLY TYR SER ARG ALA LEU ASP MSE ASN ILE THR          
SEQRES  14 A  265  GLY GLU THR ILE THR PRO GLN GLU ALA LEU GLU ILE GLY          
SEQRES  15 A  265  LEU VAL ASN ARG VAL PHE PRO GLN ALA GLU THR ARG GLU          
SEQRES  16 A  265  ARG THR ARG GLU TYR ALA ARG LYS LEU ALA ASN SER ALA          
SEQRES  17 A  265  THR TYR ALA VAL SER ASN ILE LYS LEU ALA ILE MSE ASN          
SEQRES  18 A  265  GLY LYS GLU MSE PRO LEU ASN VAL ALA ILE ARG TYR GLU          
SEQRES  19 A  265  GLY GLU LEU GLN ASN LEU LEU PHE ARG SER GLU ASP ALA          
SEQRES  20 A  265  LYS GLU GLY LEU SER ALA PHE LEU GLU LYS ARG GLN PRO          
SEQRES  21 A  265  ASN TRP LYS GLY ILE                                          
SEQRES   1 B  265  MSE THR ALA VAL GLU THR LYS LYS GLN TYR LEU THR VAL          
SEQRES   2 B  265  PHE LYS GLU ASP GLY ILE ALA GLU ILE HIS LEU HIS ILE          
SEQRES   3 B  265  ASN LYS SER ASN SER TYR ASP LEU GLU PHE TYR LYS GLU          
SEQRES   4 B  265  PHE ASN ALA ALA ILE ASP ASP ILE ARG PHE ASP PRO ASP          
SEQRES   5 B  265  ILE LYS VAL VAL ILE VAL MSE SER ASP VAL PRO LYS PHE          
SEQRES   6 B  265  PHE SER ALA GLY ALA ASP ILE ASN PHE LEU ARG SER ALA          
SEQRES   7 B  265  ASP PRO ARG PHE LYS THR GLN PHE CYS LEU PHE CYS ASN          
SEQRES   8 B  265  GLU THR LEU ASP LYS ILE ALA ARG SER PRO GLN VAL TYR          
SEQRES   9 B  265  ILE ALA CYS LEU GLU GLY HIS THR VAL GLY GLY GLY LEU          
SEQRES  10 B  265  GLU MSE ALA LEU ALA CYS ASP LEU ARG PHE MSE GLY ASP          
SEQRES  11 B  265  GLU ALA GLY LYS ILE GLY LEU PRO GLU VAL SER LEU GLY          
SEQRES  12 B  265  VAL LEU ALA GLY THR GLY GLY THR GLN ARG LEU ALA ARG          
SEQRES  13 B  265  LEU ILE GLY TYR SER ARG ALA LEU ASP MSE ASN ILE THR          
SEQRES  14 B  265  GLY GLU THR ILE THR PRO GLN GLU ALA LEU GLU ILE GLY          
SEQRES  15 B  265  LEU VAL ASN ARG VAL PHE PRO GLN ALA GLU THR ARG GLU          
SEQRES  16 B  265  ARG THR ARG GLU TYR ALA ARG LYS LEU ALA ASN SER ALA          
SEQRES  17 B  265  THR TYR ALA VAL SER ASN ILE LYS LEU ALA ILE MSE ASN          
SEQRES  18 B  265  GLY LYS GLU MSE PRO LEU ASN VAL ALA ILE ARG TYR GLU          
SEQRES  19 B  265  GLY GLU LEU GLN ASN LEU LEU PHE ARG SER GLU ASP ALA          
SEQRES  20 B  265  LYS GLU GLY LEU SER ALA PHE LEU GLU LYS ARG GLN PRO          
SEQRES  21 B  265  ASN TRP LYS GLY ILE                                          
SEQRES   1 C  265  MSE THR ALA VAL GLU THR LYS LYS GLN TYR LEU THR VAL          
SEQRES   2 C  265  PHE LYS GLU ASP GLY ILE ALA GLU ILE HIS LEU HIS ILE          
SEQRES   3 C  265  ASN LYS SER ASN SER TYR ASP LEU GLU PHE TYR LYS GLU          
SEQRES   4 C  265  PHE ASN ALA ALA ILE ASP ASP ILE ARG PHE ASP PRO ASP          
SEQRES   5 C  265  ILE LYS VAL VAL ILE VAL MSE SER ASP VAL PRO LYS PHE          
SEQRES   6 C  265  PHE SER ALA GLY ALA ASP ILE ASN PHE LEU ARG SER ALA          
SEQRES   7 C  265  ASP PRO ARG PHE LYS THR GLN PHE CYS LEU PHE CYS ASN          
SEQRES   8 C  265  GLU THR LEU ASP LYS ILE ALA ARG SER PRO GLN VAL TYR          
SEQRES   9 C  265  ILE ALA CYS LEU GLU GLY HIS THR VAL GLY GLY GLY LEU          
SEQRES  10 C  265  GLU MSE ALA LEU ALA CYS ASP LEU ARG PHE MSE GLY ASP          
SEQRES  11 C  265  GLU ALA GLY LYS ILE GLY LEU PRO GLU VAL SER LEU GLY          
SEQRES  12 C  265  VAL LEU ALA GLY THR GLY GLY THR GLN ARG LEU ALA ARG          
SEQRES  13 C  265  LEU ILE GLY TYR SER ARG ALA LEU ASP MSE ASN ILE THR          
SEQRES  14 C  265  GLY GLU THR ILE THR PRO GLN GLU ALA LEU GLU ILE GLY          
SEQRES  15 C  265  LEU VAL ASN ARG VAL PHE PRO GLN ALA GLU THR ARG GLU          
SEQRES  16 C  265  ARG THR ARG GLU TYR ALA ARG LYS LEU ALA ASN SER ALA          
SEQRES  17 C  265  THR TYR ALA VAL SER ASN ILE LYS LEU ALA ILE MSE ASN          
SEQRES  18 C  265  GLY LYS GLU MSE PRO LEU ASN VAL ALA ILE ARG TYR GLU          
SEQRES  19 C  265  GLY GLU LEU GLN ASN LEU LEU PHE ARG SER GLU ASP ALA          
SEQRES  20 C  265  LYS GLU GLY LEU SER ALA PHE LEU GLU LYS ARG GLN PRO          
SEQRES  21 C  265  ASN TRP LYS GLY ILE                                          
SEQRES   1 D  265  MSE THR ALA VAL GLU THR LYS LYS GLN TYR LEU THR VAL          
SEQRES   2 D  265  PHE LYS GLU ASP GLY ILE ALA GLU ILE HIS LEU HIS ILE          
SEQRES   3 D  265  ASN LYS SER ASN SER TYR ASP LEU GLU PHE TYR LYS GLU          
SEQRES   4 D  265  PHE ASN ALA ALA ILE ASP ASP ILE ARG PHE ASP PRO ASP          
SEQRES   5 D  265  ILE LYS VAL VAL ILE VAL MSE SER ASP VAL PRO LYS PHE          
SEQRES   6 D  265  PHE SER ALA GLY ALA ASP ILE ASN PHE LEU ARG SER ALA          
SEQRES   7 D  265  ASP PRO ARG PHE LYS THR GLN PHE CYS LEU PHE CYS ASN          
SEQRES   8 D  265  GLU THR LEU ASP LYS ILE ALA ARG SER PRO GLN VAL TYR          
SEQRES   9 D  265  ILE ALA CYS LEU GLU GLY HIS THR VAL GLY GLY GLY LEU          
SEQRES  10 D  265  GLU MSE ALA LEU ALA CYS ASP LEU ARG PHE MSE GLY ASP          
SEQRES  11 D  265  GLU ALA GLY LYS ILE GLY LEU PRO GLU VAL SER LEU GLY          
SEQRES  12 D  265  VAL LEU ALA GLY THR GLY GLY THR GLN ARG LEU ALA ARG          
SEQRES  13 D  265  LEU ILE GLY TYR SER ARG ALA LEU ASP MSE ASN ILE THR          
SEQRES  14 D  265  GLY GLU THR ILE THR PRO GLN GLU ALA LEU GLU ILE GLY          
SEQRES  15 D  265  LEU VAL ASN ARG VAL PHE PRO GLN ALA GLU THR ARG GLU          
SEQRES  16 D  265  ARG THR ARG GLU TYR ALA ARG LYS LEU ALA ASN SER ALA          
SEQRES  17 D  265  THR TYR ALA VAL SER ASN ILE LYS LEU ALA ILE MSE ASN          
SEQRES  18 D  265  GLY LYS GLU MSE PRO LEU ASN VAL ALA ILE ARG TYR GLU          
SEQRES  19 D  265  GLY GLU LEU GLN ASN LEU LEU PHE ARG SER GLU ASP ALA          
SEQRES  20 D  265  LYS GLU GLY LEU SER ALA PHE LEU GLU LYS ARG GLN PRO          
SEQRES  21 D  265  ASN TRP LYS GLY ILE                                          
SEQRES   1 E  265  MSE THR ALA VAL GLU THR LYS LYS GLN TYR LEU THR VAL          
SEQRES   2 E  265  PHE LYS GLU ASP GLY ILE ALA GLU ILE HIS LEU HIS ILE          
SEQRES   3 E  265  ASN LYS SER ASN SER TYR ASP LEU GLU PHE TYR LYS GLU          
SEQRES   4 E  265  PHE ASN ALA ALA ILE ASP ASP ILE ARG PHE ASP PRO ASP          
SEQRES   5 E  265  ILE LYS VAL VAL ILE VAL MSE SER ASP VAL PRO LYS PHE          
SEQRES   6 E  265  PHE SER ALA GLY ALA ASP ILE ASN PHE LEU ARG SER ALA          
SEQRES   7 E  265  ASP PRO ARG PHE LYS THR GLN PHE CYS LEU PHE CYS ASN          
SEQRES   8 E  265  GLU THR LEU ASP LYS ILE ALA ARG SER PRO GLN VAL TYR          
SEQRES   9 E  265  ILE ALA CYS LEU GLU GLY HIS THR VAL GLY GLY GLY LEU          
SEQRES  10 E  265  GLU MSE ALA LEU ALA CYS ASP LEU ARG PHE MSE GLY ASP          
SEQRES  11 E  265  GLU ALA GLY LYS ILE GLY LEU PRO GLU VAL SER LEU GLY          
SEQRES  12 E  265  VAL LEU ALA GLY THR GLY GLY THR GLN ARG LEU ALA ARG          
SEQRES  13 E  265  LEU ILE GLY TYR SER ARG ALA LEU ASP MSE ASN ILE THR          
SEQRES  14 E  265  GLY GLU THR ILE THR PRO GLN GLU ALA LEU GLU ILE GLY          
SEQRES  15 E  265  LEU VAL ASN ARG VAL PHE PRO GLN ALA GLU THR ARG GLU          
SEQRES  16 E  265  ARG THR ARG GLU TYR ALA ARG LYS LEU ALA ASN SER ALA          
SEQRES  17 E  265  THR TYR ALA VAL SER ASN ILE LYS LEU ALA ILE MSE ASN          
SEQRES  18 E  265  GLY LYS GLU MSE PRO LEU ASN VAL ALA ILE ARG TYR GLU          
SEQRES  19 E  265  GLY GLU LEU GLN ASN LEU LEU PHE ARG SER GLU ASP ALA          
SEQRES  20 E  265  LYS GLU GLY LEU SER ALA PHE LEU GLU LYS ARG GLN PRO          
SEQRES  21 E  265  ASN TRP LYS GLY ILE                                          
SEQRES   1 F  265  MSE THR ALA VAL GLU THR LYS LYS GLN TYR LEU THR VAL          
SEQRES   2 F  265  PHE LYS GLU ASP GLY ILE ALA GLU ILE HIS LEU HIS ILE          
SEQRES   3 F  265  ASN LYS SER ASN SER TYR ASP LEU GLU PHE TYR LYS GLU          
SEQRES   4 F  265  PHE ASN ALA ALA ILE ASP ASP ILE ARG PHE ASP PRO ASP          
SEQRES   5 F  265  ILE LYS VAL VAL ILE VAL MSE SER ASP VAL PRO LYS PHE          
SEQRES   6 F  265  PHE SER ALA GLY ALA ASP ILE ASN PHE LEU ARG SER ALA          
SEQRES   7 F  265  ASP PRO ARG PHE LYS THR GLN PHE CYS LEU PHE CYS ASN          
SEQRES   8 F  265  GLU THR LEU ASP LYS ILE ALA ARG SER PRO GLN VAL TYR          
SEQRES   9 F  265  ILE ALA CYS LEU GLU GLY HIS THR VAL GLY GLY GLY LEU          
SEQRES  10 F  265  GLU MSE ALA LEU ALA CYS ASP LEU ARG PHE MSE GLY ASP          
SEQRES  11 F  265  GLU ALA GLY LYS ILE GLY LEU PRO GLU VAL SER LEU GLY          
SEQRES  12 F  265  VAL LEU ALA GLY THR GLY GLY THR GLN ARG LEU ALA ARG          
SEQRES  13 F  265  LEU ILE GLY TYR SER ARG ALA LEU ASP MSE ASN ILE THR          
SEQRES  14 F  265  GLY GLU THR ILE THR PRO GLN GLU ALA LEU GLU ILE GLY          
SEQRES  15 F  265  LEU VAL ASN ARG VAL PHE PRO GLN ALA GLU THR ARG GLU          
SEQRES  16 F  265  ARG THR ARG GLU TYR ALA ARG LYS LEU ALA ASN SER ALA          
SEQRES  17 F  265  THR TYR ALA VAL SER ASN ILE LYS LEU ALA ILE MSE ASN          
SEQRES  18 F  265  GLY LYS GLU MSE PRO LEU ASN VAL ALA ILE ARG TYR GLU          
SEQRES  19 F  265  GLY GLU LEU GLN ASN LEU LEU PHE ARG SER GLU ASP ALA          
SEQRES  20 F  265  LYS GLU GLY LEU SER ALA PHE LEU GLU LYS ARG GLN PRO          
SEQRES  21 F  265  ASN TRP LYS GLY ILE                                          
HET    MSE  A  59       8                                                       
HET    MSE  A 119       8                                                       
HET    MSE  A 128       8                                                       
HET    MSE  A 166       8                                                       
HET    MSE  A 220       8                                                       
HET    MSE  A 225       8                                                       
HET    MSE  B  59       8                                                       
HET    MSE  B 119       8                                                       
HET    MSE  B 128       8                                                       
HET    MSE  B 166       8                                                       
HET    MSE  B 220       8                                                       
HET    MSE  B 225       8                                                       
HET    MSE  C  59       8                                                       
HET    MSE  C 119       8                                                       
HET    MSE  C 128       8                                                       
HET    MSE  C 166       8                                                       
HET    MSE  C 220       8                                                       
HET    MSE  C 225       8                                                       
HET    MSE  D  59       8                                                       
HET    MSE  D 119       8                                                       
HET    MSE  D 128       8                                                       
HET    MSE  D 166       8                                                       
HET    MSE  D 220       8                                                       
HET    MSE  D 225       8                                                       
HET    MSE  E  59       8                                                       
HET    MSE  E 119       8                                                       
HET    MSE  E 128       8                                                       
HET    MSE  E 166       8                                                       
HET    MSE  E 220       8                                                       
HET    MSE  E 225       8                                                       
HET    MSE  F  59       8                                                       
HET    MSE  F 119       8                                                       
HET    MSE  F 128       8                                                       
HET    MSE  F 166       8                                                       
HET    MSE  F 220       8                                                       
HET    MSE  F 225       8                                                       
HET    EDO  C 266       4                                                       
HET    EDO  D 266       4                                                       
HET    PEG  B 266       7                                                       
HET    PEG  B 267       7                                                       
HET    PEG  C 267       7                                                       
HET    PEG  C 268       7                                                       
HET    PEG  F 266       7                                                       
HET    PEG  F 267       7                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETNAM     PEG DI(HYDROXYETHYL)ETHER                                            
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    36(C5 H11 N O2 SE)                                           
FORMUL   7  EDO    2(C2 H6 O2)                                                  
FORMUL   9  PEG    6(C4 H10 O3)                                                 
FORMUL  15  HOH   *1098(H2 O)                                                   
CRYST1  136.201  137.345   79.131  90.00  90.00  90.00 P 21 21 2    24          
ATOM      1  N   THR A   2     -42.387  97.964  14.910  1.00 89.14           N  
ATOM      2  CA  THR A   2     -41.398  96.892  15.225  1.00 90.92           C  
ATOM      3  C   THR A   2     -40.073  97.462  15.724  1.00 93.40           C  
ATOM      4  O   THR A   2     -39.639  97.164  16.838  1.00 92.91           O  
ATOM      5  CB  THR A   2     -41.117  96.016  13.989  1.00 89.80           C  
ATOM      6  OG1 THR A   2     -40.035  95.122  14.272  1.00 89.91           O  
ATOM      7  CG2 THR A   2     -40.760  96.878  12.793  1.00 89.43           C  
ATOM      8  N   ALA A   3     -39.433  98.279  14.891  1.00 95.74           N  
ATOM      9  CA  ALA A   3     -38.158  98.896  15.239  1.00 96.53           C  
ATOM     10  C   ALA A   3     -38.392 100.201  15.995  1.00 97.93           C  
ATOM     11  O   ALA A   3     -39.004 101.130  15.467  1.00 98.57           O  
ATOM     12  CB  ALA A   3     -37.347  99.162  13.975  1.00 93.58           C  
ATOM     13  N   VAL A   4     -37.904 100.263  17.231  1.00 98.89           N  
ATOM     14  CA  VAL A   4     -38.066 101.454  18.059  1.00 98.22           C  
ATOM     15  C   VAL A   4     -36.907 102.430  17.912  1.00 97.25           C  
ATOM     16  O   VAL A   4     -35.758 102.030  17.726  1.00 95.61           O  
ATOM     17  CB  VAL A   4     -38.213 101.084  19.548  1.00 99.08           C  
ATOM     18  CG1 VAL A   4     -39.541 100.382  19.775  1.00100.42           C  
ATOM     19  CG2 VAL A   4     -37.059 100.194  19.981  1.00 99.08           C  
ATOM     20  N   GLU A   5     -37.226 103.718  18.001  1.00 97.20           N  
ATOM     21  CA  GLU A   5     -36.236 104.778  17.864  1.00 96.69           C  
ATOM     22  C   GLU A   5     -36.515 105.886  18.881  1.00 95.22           C  
ATOM     23  O   GLU A   5     -37.632 106.395  18.964  1.00 96.03           O  
ATOM     24  CB  GLU A   5     -36.299 105.356  16.447  1.00 98.64           C  
ATOM     25  CG  GLU A   5     -36.357 104.298  15.351  1.00100.33           C  
ATOM     26  CD  GLU A   5     -36.775 104.864  14.005  1.00100.30           C  
ATOM     27  OE1 GLU A   5     -37.854 105.488  13.932  1.00100.42           O  
ATOM     28  OE2 GLU A   5     -36.030 104.678  13.020  1.00100.42           O  
ATOM     29  N   THR A   6     -35.498 106.246  19.656  1.00 92.83           N  
ATOM     30  CA  THR A   6     -35.626 107.300  20.658  1.00 89.92           C  
ATOM     31  C   THR A   6     -34.566 108.358  20.357  1.00 89.86           C  
ATOM     32  O   THR A   6     -33.409 108.027  20.093  1.00 88.16           O  
ATOM     33  CB  THR A   6     -35.434 106.736  22.084  1.00 88.08           C  
ATOM     34  OG1 THR A   6     -35.553 107.795  23.042  1.00 87.62           O  
ATOM     35  CG2 THR A   6     -34.073 106.078  22.220  1.00 87.02           C  
ATOM     36  N   LYS A   7     -34.954 109.630  20.399  1.00 89.42           N  
ATOM     37  CA  LYS A   7     -34.023 110.704  20.069  1.00 90.00           C  
ATOM     38  C   LYS A   7     -33.906 111.841  21.080  1.00 88.34           C  
ATOM     39  O   LYS A   7     -34.806 112.085  21.885  1.00 87.89           O  
ATOM     40  CB  LYS A   7     -34.410 111.301  18.715  1.00 92.98           C  
ATOM     41  CG  LYS A   7     -34.839 110.267  17.690  1.00 97.46           C  
ATOM     42  CD  LYS A   7     -35.645 110.896  16.567  1.00 99.01           C  
ATOM     43  CE  LYS A   7     -36.233 109.828  15.659  1.00 99.16           C  
ATOM     44  NZ  LYS A   7     -37.161 110.408  14.651  1.00100.42           N  
ATOM     45  N   LYS A   8     -32.771 112.532  21.010  1.00 85.78           N  
ATOM     46  CA  LYS A   8     -32.471 113.688  21.846  1.00 83.29           C  
ATOM     47  C   LYS A   8     -31.875 114.716  20.891  1.00 77.50           C  
ATOM     48  O   LYS A   8     -32.043 114.590  19.679  1.00 79.30           O  
ATOM     49  CB  LYS A   8     -31.475 113.329  22.953  1.00 87.67           C  
ATOM     50  CG  LYS A   8     -32.100 112.557  24.110  1.00 92.30           C  
ATOM     51  CD  LYS A   8     -31.147 112.431  25.289  1.00 97.09           C  
ATOM     52  CE  LYS A   8     -31.844 111.825  26.499  1.00100.12           C  
ATOM     53  NZ  LYS A   8     -30.953 111.750  27.691  1.00 99.49           N  
ATOM     54  N   GLN A   9     -31.181 115.723  21.409  1.00 70.41           N  
ATOM     55  CA  GLN A   9     -30.604 116.734  20.527  1.00 62.62           C  
ATOM     56  C   GLN A   9     -29.159 116.477  20.121  1.00 56.91           C  
ATOM     57  O   GLN A   9     -28.735 116.892  19.043  1.00 60.87           O  
ATOM     58  CB  GLN A   9     -30.716 118.127  21.156  1.00 60.70           C  
ATOM     59  CG  GLN A   9     -30.302 118.211  22.612  1.00 58.89           C  
ATOM     60  CD  GLN A   9     -30.216 119.647  23.096  1.00 63.62           C  
ATOM     61  OE1 GLN A   9     -30.880 120.535  22.558  1.00 63.16           O  
ATOM     62  NE2 GLN A   9     -29.405 119.881  24.122  1.00 59.60           N  
ATOM     63  N   TYR A  10     -28.406 115.790  20.973  1.00 48.42           N  
ATOM     64  CA  TYR A  10     -27.004 115.502  20.684  1.00 40.37           C  
ATOM     65  C   TYR A  10     -26.806 114.134  20.046  1.00 34.42           C  
ATOM     66  O   TYR A  10     -25.837 113.912  19.318  1.00 31.34           O  
ATOM     67  CB  TYR A  10     -26.176 115.566  21.966  1.00 36.84           C  
ATOM     68  CG  TYR A  10     -26.070 116.938  22.584  1.00 36.08           C  
ATOM     69  CD1 TYR A  10     -25.133 117.859  22.124  1.00 41.41           C  
ATOM     70  CD2 TYR A  10     -26.886 117.305  23.649  1.00 37.66           C  
ATOM     71  CE1 TYR A  10     -25.009 119.115  22.715  1.00 43.24           C  
ATOM     72  CE2 TYR A  10     -26.770 118.555  24.245  1.00 39.32           C  
ATOM     73  CZ  TYR A  10     -25.831 119.454  23.776  1.00 39.20           C  
ATOM     74  OH  TYR A  10     -25.709 120.686  24.375  1.00 46.52           O  
ATOM     75  N   LEU A  11     -27.722 113.214  20.321  1.00 32.50           N  
ATOM     76  CA  LEU A  11     -27.598 111.871  19.784  1.00 30.34           C  
ATOM     77  C   LEU A  11     -28.938 111.157  19.724  1.00 29.63           C  
ATOM     78  O   LEU A  11     -29.900 111.566  20.373  1.00 24.43           O  
ATOM     79  CB  LEU A  11     -26.607 111.076  20.650  1.00 31.93           C  
ATOM     80  CG  LEU A  11     -26.996 109.895  21.559  1.00 36.37           C  
ATOM     81  CD1 LEU A  11     -25.823 109.625  22.495  1.00 37.59           C  
ATOM     82  CD2 LEU A  11     -28.227 110.184  22.393  1.00 34.28           C  
ATOM     83  N   THR A  12     -28.985 110.079  18.945  1.00 29.86           N  
ATOM     84  CA  THR A  12     -30.188 109.272  18.799  1.00 28.02           C  
ATOM     85  C   THR A  12     -29.836 107.796  18.956  1.00 29.15           C  
ATOM     86  O   THR A  12     -28.818 107.331  18.441  1.00 30.83           O  
ATOM     87  CB  THR A  12     -30.842 109.488  17.416  1.00 31.86           C  
ATOM     88  OG1 THR A  12     -31.288 110.842  17.306  1.00 34.48           O  
ATOM     89  CG2 THR A  12     -32.027 108.556  17.228  1.00 29.26           C  
ATOM     90  N   VAL A  13     -30.678 107.061  19.675  1.00 28.65           N  
ATOM     91  CA  VAL A  13     -30.456 105.638  19.887  1.00 25.92           C  
ATOM     92  C   VAL A  13     -31.507 104.829  19.137  1.00 27.40           C  
ATOM     93  O   VAL A  13     -32.704 105.070  19.279  1.00 30.35           O  
ATOM     94  CB  VAL A  13     -30.530 105.266  21.392  1.00 25.41           C  
ATOM     95  CG1 VAL A  13     -30.311 103.769  21.570  1.00 26.09           C  
ATOM     96  CG2 VAL A  13     -29.491 106.044  22.178  1.00 26.60           C  
ATOM     97  N   PHE A  14     -31.048 103.876  18.333  1.00 23.89           N  
ATOM     98  CA  PHE A  14     -31.929 103.002  17.564  1.00 25.94           C  
ATOM     99  C   PHE A  14     -31.732 101.580  18.078  1.00 29.73           C  
ATOM    100  O   PHE A  14     -30.597 101.125  18.225  1.00 31.85           O  
ATOM    101  CB  PHE A  14     -31.569 103.046  16.074  1.00 32.33           C  
ATOM    102  CG  PHE A  14     -31.790 104.383  15.428  1.00 36.92           C  
ATOM    103  CD1 PHE A  14     -33.076 104.864  15.212  1.00 38.10           C  
ATOM    104  CD2 PHE A  14     -30.709 105.161  15.026  1.00 39.79           C  
ATOM    105  CE1 PHE A  14     -33.286 106.104  14.602  1.00 39.95           C  
ATOM    106  CE2 PHE A  14     -30.904 106.401  14.415  1.00 39.70           C  
ATOM    107  CZ  PHE A  14     -32.197 106.873  14.204  1.00 41.46           C  
ATOM    108  N   LYS A  15     -32.828 100.880  18.355  1.00 30.16           N  
ATOM    109  CA  LYS A  15     -32.742  99.508  18.845  1.00 27.03           C  
ATOM    110  C   LYS A  15     -33.469  98.566  17.905  1.00 32.64           C  
ATOM    111  O   LYS A  15     -34.614  98.816  17.525  1.00 30.63           O  
ATOM    112  CB  LYS A  15     -33.352  99.385  20.242  1.00 23.27           C  
ATOM    113  CG  LYS A  15     -32.595 100.125  21.337  1.00 24.25           C  
ATOM    114  CD  LYS A  15     -33.235  99.837  22.680  1.00 29.91           C  
ATOM    115  CE  LYS A  15     -32.609 100.644  23.802  1.00 34.91           C  
ATOM    116  NZ  LYS A  15     -33.275 100.337  25.101  1.00 31.21           N  
ATOM    117  N   GLU A  16     -32.808  97.474  17.541  1.00 32.29           N  
ATOM    118  CA  GLU A  16     -33.406  96.508  16.638  1.00 37.23           C  
ATOM    119  C   GLU A  16     -32.639  95.193  16.640  1.00 34.63           C  
ATOM    120  O   GLU A  16     -31.419  95.175  16.516  1.00 36.99           O  
ATOM    121  CB  GLU A  16     -33.449  97.097  15.224  1.00 43.33           C  
ATOM    122  CG  GLU A  16     -34.162  96.245  14.191  1.00 55.22           C  
ATOM    123  CD  GLU A  16     -34.341  96.977  12.871  1.00 65.67           C  
ATOM    124  OE1 GLU A  16     -33.325  97.391  12.270  1.00 67.58           O  
ATOM    125  OE2 GLU A  16     -35.501  97.140  12.434  1.00 67.65           O  
ATOM    126  N   ASP A  17     -33.374  94.099  16.800  1.00 34.56           N  
ATOM    127  CA  ASP A  17     -32.812  92.749  16.805  1.00 36.38           C  
ATOM    128  C   ASP A  17     -31.509  92.552  17.580  1.00 35.67           C  
ATOM    129  O   ASP A  17     -30.532  92.021  17.045  1.00 31.38           O  
ATOM    130  CB  ASP A  17     -32.630  92.265  15.365  1.00 42.72           C  
ATOM    131  CG  ASP A  17     -33.952  92.084  14.641  1.00 49.21           C  
ATOM    132  OD1 ASP A  17     -34.774  91.264  15.108  1.00 50.20           O  
ATOM    133  OD2 ASP A  17     -34.170  92.762  13.612  1.00 49.72           O  
ATOM    134  N   GLY A  18     -31.500  92.970  18.841  1.00 34.80           N  
ATOM    135  CA  GLY A  18     -30.316  92.799  19.666  1.00 34.29           C  
ATOM    136  C   GLY A  18     -29.166  93.758  19.417  1.00 29.55           C  
ATOM    137  O   GLY A  18     -28.082  93.582  19.973  1.00 32.59           O  
ATOM    138  N   ILE A  19     -29.389  94.769  18.585  1.00 26.47           N  
ATOM    139  CA  ILE A  19     -28.350  95.751  18.297  1.00 24.09           C  
ATOM    140  C   ILE A  19     -28.868  97.161  18.546  1.00 26.39           C  
ATOM    141  O   ILE A  19     -30.013  97.481  18.223  1.00 26.34           O  
ATOM    142  CB  ILE A  19     -27.877  95.670  16.830  1.00 24.78           C  
ATOM    143  CG1 ILE A  19     -27.264  94.296  16.551  1.00 28.21           C  
ATOM    144  CG2 ILE A  19     -26.863  96.769  16.549  1.00 18.67           C  
ATOM    145  CD1 ILE A  19     -26.892  94.080  15.097  1.00 18.38           C  
ATOM    146  N   ALA A  20     -28.023  97.997  19.135  1.00 21.28           N  
ATOM    147  CA  ALA A  20     -28.385  99.380  19.398  1.00 19.07           C  
ATOM    148  C   ALA A  20     -27.358 100.247  18.700  1.00 21.11           C  
ATOM    149  O   ALA A  20     -26.162  99.965  18.748  1.00 25.92           O  
ATOM    150  CB  ALA A  20     -28.378  99.664  20.896  1.00 16.17           C  
ATOM    151  N   GLU A  21     -27.822 101.290  18.025  1.00 21.62           N  
ATOM    152  CA  GLU A  21     -26.910 102.185  17.339  1.00 21.12           C  
ATOM    153  C   GLU A  21     -27.053 103.557  17.957  1.00 24.84           C  
ATOM    154  O   GLU A  21     -28.151 104.103  18.031  1.00 22.34           O  
ATOM    155  CB  GLU A  21     -27.227 102.273  15.844  1.00 21.29           C  
ATOM    156  CG  GLU A  21     -27.298 100.946  15.122  1.00 25.27           C  
ATOM    157  CD  GLU A  21     -27.266 101.113  13.611  1.00 25.61           C  
ATOM    158  OE1 GLU A  21     -27.719 102.167  13.119  1.00 31.23           O  
ATOM    159  OE2 GLU A  21     -26.798 100.188  12.914  1.00 26.86           O  
ATOM    160  N   ILE A  22     -25.937 104.104  18.418  1.00 25.58           N  
ATOM    161  CA  ILE A  22     -25.943 105.427  19.011  1.00 22.44           C  
ATOM    162  C   ILE A  22     -25.394 106.366  17.946  1.00 26.23           C  
ATOM    163  O   ILE A  22     -24.190 106.370  17.670  1.00 21.53           O  
ATOM    164  CB  ILE A  22     -25.047 105.487  20.265  1.00 18.93           C  
ATOM    165  CG1 ILE A  22     -25.478 104.412  21.271  1.00 14.55           C  
ATOM    166  CG2 ILE A  22     -25.143 106.868  20.896  1.00 18.32           C  
ATOM    167  CD1 ILE A  22     -24.619 104.351  22.534  1.00 18.31           C  
ATOM    168  N   HIS A  23     -26.283 107.136  17.326  1.00 25.12           N  
ATOM    169  CA  HIS A  23     -25.868 108.072  16.292  1.00 24.00           C  
ATOM    170  C   HIS A  23     -25.561 109.424  16.901  1.00 24.80           C  
ATOM    171  O   HIS A  23     -26.360 109.967  17.659  1.00 23.77           O  
ATOM    172  CB  HIS A  23     -26.957 108.218  15.229  1.00 26.07           C  
ATOM    173  CG  HIS A  23     -27.109 107.015  14.352  1.00 27.12           C  
ATOM    174  ND1 HIS A  23     -26.811 107.032  13.005  1.00 28.88           N  
ATOM    175  CD2 HIS A  23     -27.520 105.755  14.630  1.00 24.14           C  
ATOM    176  CE1 HIS A  23     -27.035 105.836  12.492  1.00 32.53           C  
ATOM    177  NE2 HIS A  23     -27.467 105.043  13.456  1.00 32.43           N  
ATOM    178  N   LEU A  24     -24.395 109.962  16.566  1.00 26.88           N  
ATOM    179  CA  LEU A  24     -23.978 111.253  17.079  1.00 25.15           C  
ATOM    180  C   LEU A  24     -24.276 112.359  16.063  1.00 26.15           C  
ATOM    181  O   LEU A  24     -23.884 112.266  14.901  1.00 23.60           O  
ATOM    182  CB  LEU A  24     -22.477 111.228  17.385  1.00 25.36           C  
ATOM    183  CG  LEU A  24     -21.965 110.061  18.242  1.00 27.34           C  
ATOM    184  CD1 LEU A  24     -20.457 110.188  18.430  1.00 28.34           C  
ATOM    185  CD2 LEU A  24     -22.664 110.055  19.589  1.00 20.62           C  
ATOM    186  N   HIS A  25     -24.982 113.392  16.506  1.00 26.17           N  
ATOM    187  CA  HIS A  25     -25.318 114.530  15.657  1.00 29.83           C  
ATOM    188  C   HIS A  25     -25.299 115.790  16.515  1.00 31.33           C  
ATOM    189  O   HIS A  25     -26.339 116.347  16.845  1.00 33.27           O  
ATOM    190  CB  HIS A  25     -26.702 114.350  15.002  1.00 25.00           C  
ATOM    191  CG  HIS A  25     -27.787 113.962  15.961  1.00 19.13           C  
ATOM    192  ND1 HIS A  25     -28.340 112.700  15.982  1.00 28.00           N  
ATOM    193  CD2 HIS A  25     -28.431 114.671  16.920  1.00 18.92           C  
ATOM    194  CE1 HIS A  25     -29.278 112.648  16.912  1.00 20.70           C  
ATOM    195  NE2 HIS A  25     -29.352 113.831  17.495  1.00 23.39           N  
ATOM    196  N   ILE A  26     -24.101 116.242  16.866  1.00 29.86           N  
ATOM    197  CA  ILE A  26     -23.936 117.409  17.715  1.00 30.64           C  
ATOM    198  C   ILE A  26     -23.727 118.706  16.942  1.00 34.67           C  
ATOM    199  O   ILE A  26     -24.333 119.733  17.245  1.00 34.05           O  
ATOM    200  CB  ILE A  26     -22.741 117.221  18.658  1.00 28.19           C  
ATOM    201  CG1 ILE A  26     -22.828 115.855  19.339  1.00 30.40           C  
ATOM    202  CG2 ILE A  26     -22.713 118.328  19.696  1.00 21.57           C  
ATOM    203  CD1 ILE A  26     -21.516 115.398  19.954  1.00 32.77           C  
ATOM    204  N   ASN A  27     -22.844 118.657  15.953  1.00 30.83           N  
ATOM    205  CA  ASN A  27     -22.538 119.828  15.144  1.00 30.67           C  
ATOM    206  C   ASN A  27     -21.592 119.455  14.012  1.00 30.75           C  
ATOM    207  O   ASN A  27     -21.293 118.282  13.799  1.00 29.50           O  
ATOM    208  CB  ASN A  27     -21.923 120.947  16.011  1.00 27.13           C  
ATOM    209  CG  ASN A  27     -20.729 120.482  16.825  1.00 31.60           C  
ATOM    210  OD1 ASN A  27     -19.912 119.698  16.351  1.00 28.41           O  
ATOM    211  ND2 ASN A  27     -20.610 120.989  18.055  1.00 23.00           N  
ATOM    212  N   LYS A  28     -21.136 120.477  13.297  1.00 32.63           N  
ATOM    213  CA  LYS A  28     -20.256 120.292  12.153  1.00 32.77           C  
ATOM    214  C   LYS A  28     -19.127 119.286  12.353  1.00 31.59           C  
ATOM    215  O   LYS A  28     -18.785 118.539  11.430  1.00 31.51           O  
ATOM    216  CB  LYS A  28     -19.648 121.645  11.762  1.00 41.07           C  
ATOM    217  CG  LYS A  28     -18.945 122.324  12.947  1.00 52.55           C  
ATOM    218  CD  LYS A  28     -18.434 123.740  12.642  1.00 56.59           C  
ATOM    219  CE  LYS A  28     -18.994 124.324  11.358  1.00 56.06           C  
ATOM    220  NZ  LYS A  28     -18.515 125.736  11.177  1.00 60.13           N  
ATOM    221  N   SER A  29     -18.542 119.260  13.550  1.00 28.74           N  
ATOM    222  CA  SER A  29     -17.431 118.342  13.827  1.00 24.94           C  
ATOM    223  C   SER A  29     -17.684 117.481  15.065  1.00 26.58           C  
ATOM    224  O   SER A  29     -16.776 116.838  15.585  1.00 26.91           O  
ATOM    225  CB  SER A  29     -16.125 119.130  14.012  1.00 24.82           C  
ATOM    226  OG  SER A  29     -16.227 120.055  15.067  1.00 27.53           O  
ATOM    227  N   ASN A  30     -18.940 117.447  15.504  1.00 24.75           N  
ATOM    228  CA  ASN A  30     -19.329 116.700  16.688  1.00 23.25           C  
ATOM    229  C   ASN A  30     -18.470 117.040  17.900  1.00 25.60           C  
ATOM    230  O   ASN A  30     -18.096 116.150  18.670  1.00 23.46           O  
ATOM    231  CB  ASN A  30     -19.292 115.186  16.439  1.00 22.28           C  
ATOM    232  CG  ASN A  30     -20.557 114.673  15.777  1.00 25.40           C  
ATOM    233  OD1 ASN A  30     -21.660 115.118  16.094  1.00 25.18           O  
ATOM    234  ND2 ASN A  30     -20.406 113.720  14.867  1.00 26.11           N  
ATOM    235  N   SER A  31     -18.139 118.322  18.061  1.00 18.17           N  
ATOM    236  CA  SER A  31     -17.370 118.770  19.223  1.00 23.39           C  
ATOM    237  C   SER A  31     -18.364 118.777  20.375  1.00 25.99           C  
ATOM    238  O   SER A  31     -19.370 119.483  20.329  1.00 32.02           O  
ATOM    239  CB  SER A  31     -16.819 120.175  18.994  1.00 20.90           C  
ATOM    240  OG  SER A  31     -15.801 120.148  18.014  1.00 33.58           O  
ATOM    241  N   TYR A  32     -18.077 117.998  21.411  1.00 25.76           N  
ATOM    242  CA  TYR A  32     -18.997 117.862  22.538  1.00 20.13           C  
ATOM    243  C   TYR A  32     -18.783 118.751  23.752  1.00 20.41           C  
ATOM    244  O   TYR A  32     -17.751 119.405  23.896  1.00 21.14           O  
ATOM    245  CB  TYR A  32     -19.004 116.406  23.004  1.00 19.99           C  
ATOM    246  CG  TYR A  32     -17.653 115.926  23.492  1.00 16.38           C  
ATOM    247  CD1 TYR A  32     -16.794 115.209  22.655  1.00 15.54           C  
ATOM    248  CD2 TYR A  32     -17.222 116.210  24.788  1.00 16.61           C  
ATOM    249  CE1 TYR A  32     -15.536 114.786  23.105  1.00 16.57           C  
ATOM    250  CE2 TYR A  32     -15.969 115.796  25.243  1.00 19.35           C  
ATOM    251  CZ  TYR A  32     -15.134 115.086  24.399  1.00 18.35           C  
ATOM    252  OH  TYR A  32     -13.898 114.695  24.852  1.00 19.61           O  
ATOM    253  N   ASP A  33     -19.787 118.746  24.627  1.00 20.14           N  
ATOM    254  CA  ASP A  33     -19.765 119.497  25.879  1.00 22.33           C  
ATOM    255  C   ASP A  33     -20.230 118.547  26.984  1.00 21.06           C  
ATOM    256  O   ASP A  33     -20.327 117.341  26.765  1.00 22.65           O  
ATOM    257  CB  ASP A  33     -20.703 120.708  25.816  1.00 23.28           C  
ATOM    258  CG  ASP A  33     -22.117 120.332  25.414  1.00 26.37           C  
ATOM    259  OD1 ASP A  33     -22.522 119.169  25.624  1.00 28.24           O  
ATOM    260  OD2 ASP A  33     -22.834 121.210  24.896  1.00 33.65           O  
ATOM    261  N   LEU A  34     -20.531 119.083  28.163  1.00 19.95           N  
ATOM    262  CA  LEU A  34     -20.968 118.244  29.273  1.00 20.64           C  
ATOM    263  C   LEU A  34     -22.317 117.598  29.003  1.00 22.08           C  
ATOM    264  O   LEU A  34     -22.515 116.421  29.293  1.00 28.63           O  
ATOM    265  CB  LEU A  34     -21.037 119.056  30.577  1.00 18.77           C  
ATOM    266  CG  LEU A  34     -21.539 118.294  31.814  1.00 19.90           C  
ATOM    267  CD1 LEU A  34     -20.723 117.019  32.008  1.00 15.71           C  
ATOM    268  CD2 LEU A  34     -21.442 119.183  33.048  1.00 19.60           C  
ATOM    269  N   GLU A  35     -23.247 118.368  28.447  1.00 21.48           N  
ATOM    270  CA  GLU A  35     -24.575 117.853  28.157  1.00 23.77           C  
ATOM    271  C   GLU A  35     -24.527 116.639  27.224  1.00 23.18           C  
ATOM    272  O   GLU A  35     -25.322 115.709  27.368  1.00 22.35           O  
ATOM    273  CB  GLU A  35     -25.441 118.962  27.549  1.00 28.22           C  
ATOM    274  CG  GLU A  35     -26.921 118.639  27.493  1.00 40.66           C  
ATOM    275  CD  GLU A  35     -27.504 118.306  28.856  1.00 53.07           C  
ATOM    276  OE1 GLU A  35     -27.325 119.109  29.800  1.00 53.29           O  
ATOM    277  OE2 GLU A  35     -28.148 117.240  28.979  1.00 56.96           O  
ATOM    278  N   PHE A  36     -23.603 116.641  26.267  1.00 20.83           N  
ATOM    279  CA  PHE A  36     -23.498 115.504  25.362  1.00 23.28           C  
ATOM    280  C   PHE A  36     -23.194 114.239  26.147  1.00 21.47           C  
ATOM    281  O   PHE A  36     -23.858 113.217  25.978  1.00 20.19           O  
ATOM    282  CB  PHE A  36     -22.384 115.689  24.331  1.00 26.25           C  
ATOM    283  CG  PHE A  36     -21.966 114.395  23.678  1.00 26.76           C  
ATOM    284  CD1 PHE A  36     -22.839 113.715  22.833  1.00 25.79           C  
ATOM    285  CD2 PHE A  36     -20.727 113.824  23.959  1.00 28.58           C  
ATOM    286  CE1 PHE A  36     -22.490 112.473  22.287  1.00 24.37           C  
ATOM    287  CE2 PHE A  36     -20.369 112.582  23.418  1.00 22.66           C  
ATOM    288  CZ  PHE A  36     -21.252 111.909  22.579  1.00 18.43           C  
ATOM    289  N   TYR A  37     -22.172 114.310  26.997  1.00 24.64           N  
ATOM    290  CA  TYR A  37     -21.780 113.157  27.795  1.00 17.61           C  
ATOM    291  C   TYR A  37     -22.854 112.723  28.773  1.00 19.40           C  
ATOM    292  O   TYR A  37     -22.950 111.542  29.107  1.00 21.68           O  
ATOM    293  CB  TYR A  37     -20.459 113.432  28.514  1.00 19.70           C  
ATOM    294  CG  TYR A  37     -19.291 112.763  27.817  1.00 20.34           C  
ATOM    295  CD1 TYR A  37     -19.124 111.378  27.882  1.00 21.22           C  
ATOM    296  CD2 TYR A  37     -18.393 113.500  27.043  1.00 21.13           C  
ATOM    297  CE1 TYR A  37     -18.090 110.741  27.194  1.00 26.74           C  
ATOM    298  CE2 TYR A  37     -17.355 112.871  26.349  1.00 28.12           C  
ATOM    299  CZ  TYR A  37     -17.211 111.491  26.430  1.00 25.66           C  
ATOM    300  OH  TYR A  37     -16.186 110.862  25.760  1.00 25.39           O  
ATOM    301  N   LYS A  38     -23.672 113.669  29.224  1.00 16.86           N  
ATOM    302  CA  LYS A  38     -24.752 113.326  30.138  1.00 21.83           C  
ATOM    303  C   LYS A  38     -25.753 112.466  29.368  1.00 19.09           C  
ATOM    304  O   LYS A  38     -26.326 111.529  29.918  1.00 19.71           O  
ATOM    305  CB  LYS A  38     -25.411 114.598  30.684  1.00 20.91           C  
ATOM    306  CG  LYS A  38     -24.488 115.381  31.611  1.00 24.08           C  
ATOM    307  CD  LYS A  38     -24.995 116.779  31.923  1.00 35.02           C  
ATOM    308  CE  LYS A  38     -26.293 116.758  32.700  1.00 42.88           C  
ATOM    309  NZ  LYS A  38     -26.724 118.146  33.032  1.00 54.37           N  
ATOM    310  N   GLU A  39     -25.934 112.769  28.083  1.00 20.92           N  
ATOM    311  CA  GLU A  39     -26.847 111.996  27.249  1.00 19.49           C  
ATOM    312  C   GLU A  39     -26.225 110.653  26.872  1.00 20.25           C  
ATOM    313  O   GLU A  39     -26.906 109.628  26.866  1.00 17.18           O  
ATOM    314  CB  GLU A  39     -27.207 112.763  25.971  1.00 29.49           C  
ATOM    315  CG  GLU A  39     -27.882 114.112  26.201  1.00 40.32           C  
ATOM    316  CD  GLU A  39     -28.620 114.609  24.967  1.00 47.89           C  
ATOM    317  OE1 GLU A  39     -28.048 114.540  23.861  1.00 50.11           O  
ATOM    318  OE2 GLU A  39     -29.773 115.071  25.101  1.00 47.89           O  
ATOM    319  N   PHE A  40     -24.932 110.659  26.556  1.00 18.97           N  
ATOM    320  CA  PHE A  40     -24.234 109.429  26.188  1.00 19.38           C  
ATOM    321  C   PHE A  40     -24.252 108.467  27.379  1.00 18.71           C  
ATOM    322  O   PHE A  40     -24.438 107.257  27.214  1.00 17.93           O  
ATOM    323  CB  PHE A  40     -22.786 109.731  25.782  1.00 20.85           C  
ATOM    324  CG  PHE A  40     -22.085 108.570  25.125  1.00 24.86           C  
ATOM    325  CD1 PHE A  40     -22.562 108.040  23.932  1.00 27.88           C  
ATOM    326  CD2 PHE A  40     -20.952 108.006  25.700  1.00 28.19           C  
ATOM    327  CE1 PHE A  40     -21.916 106.969  23.315  1.00 31.02           C  
ATOM    328  CE2 PHE A  40     -20.299 106.932  25.091  1.00 31.31           C  
ATOM    329  CZ  PHE A  40     -20.785 106.412  23.897  1.00 25.33           C  
ATOM    330  N   ASN A  41     -24.061 109.017  28.576  1.00 15.83           N  
ATOM    331  CA  ASN A  41     -24.083 108.224  29.803  1.00 16.73           C  
ATOM    332  C   ASN A  41     -25.461 107.597  30.002  1.00 18.73           C  
ATOM    333  O   ASN A  41     -25.576 106.433  30.380  1.00 21.20           O  
ATOM    334  CB  ASN A  41     -23.763 109.108  31.010  1.00 17.40           C  
ATOM    335  CG  ASN A  41     -23.788 108.336  32.312  1.00 21.00           C  
ATOM    336  OD1 ASN A  41     -22.947 107.471  32.552  1.00 18.87           O  
ATOM    337  ND2 ASN A  41     -24.765 108.635  33.155  1.00 20.96           N  
ATOM    338  N   ALA A  42     -26.508 108.380  29.752  1.00 20.85           N  
ATOM    339  CA  ALA A  42     -27.880 107.894  29.897  1.00 20.91           C  
ATOM    340  C   ALA A  42     -28.162 106.759  28.917  1.00 17.46           C  
ATOM    341  O   ALA A  42     -28.846 105.793  29.256  1.00 21.35           O  
ATOM    342  CB  ALA A  42     -28.868 109.032  29.673  1.00 13.70           C  
ATOM    343  N   ALA A  43     -27.634 106.882  27.702  1.00 15.73           N  
ATOM    344  CA  ALA A  43     -27.829 105.859  26.679  1.00 16.65           C  
ATOM    345  C   ALA A  43     -27.188 104.555  27.139  1.00 20.43           C  
ATOM    346  O   ALA A  43     -27.754 103.471  26.975  1.00 22.39           O  
ATOM    347  CB  ALA A  43     -27.208 106.311  25.366  1.00 21.12           C  
ATOM    348  N   ILE A  44     -25.999 104.668  27.721  1.00 20.76           N  
ATOM    349  CA  ILE A  44     -25.289 103.500  28.223  1.00 18.98           C  
ATOM    350  C   ILE A  44     -26.114 102.822  29.317  1.00 19.82           C  
ATOM    351  O   ILE A  44     -26.340 101.609  29.267  1.00 22.01           O  
ATOM    352  CB  ILE A  44     -23.902 103.890  28.781  1.00 17.33           C  
ATOM    353  CG1 ILE A  44     -23.031 104.435  27.642  1.00 18.88           C  
ATOM    354  CG2 ILE A  44     -23.240 102.686  29.421  1.00 15.76           C  
ATOM    355  CD1 ILE A  44     -21.658 104.893  28.065  1.00 18.06           C  
ATOM    356  N   ASP A  45     -26.572 103.602  30.296  1.00 14.96           N  
ATOM    357  CA  ASP A  45     -27.379 103.042  31.381  1.00 21.87           C  
ATOM    358  C   ASP A  45     -28.646 102.395  30.829  1.00 23.14           C  
ATOM    359  O   ASP A  45     -29.006 101.282  31.214  1.00 29.03           O  
ATOM    360  CB  ASP A  45     -27.764 104.120  32.402  1.00 20.79           C  
ATOM    361  CG  ASP A  45     -26.600 104.543  33.272  1.00 23.22           C  
ATOM    362  OD1 ASP A  45     -25.674 103.729  33.465  1.00 24.73           O  
ATOM    363  OD2 ASP A  45     -26.617 105.683  33.780  1.00 21.57           O  
ATOM    364  N   ASP A  46     -29.318 103.098  29.922  1.00 20.36           N  
ATOM    365  CA  ASP A  46     -30.535 102.573  29.314  1.00 23.89           C  
ATOM    366  C   ASP A  46     -30.275 101.231  28.646  1.00 23.19           C  
ATOM    367  O   ASP A  46     -30.986 100.258  28.888  1.00 24.74           O  
ATOM    368  CB  ASP A  46     -31.074 103.536  28.261  1.00 25.86           C  
ATOM    369  CG  ASP A  46     -32.264 102.961  27.516  1.00 32.26           C  
ATOM    370  OD1 ASP A  46     -33.345 102.848  28.129  1.00 38.96           O  
ATOM    371  OD2 ASP A  46     -32.116 102.608  26.326  1.00 30.12           O  
ATOM    372  N   ILE A  47     -29.254 101.192  27.796  1.00 25.15           N  
ATOM    373  CA  ILE A  47     -28.904  99.977  27.077  1.00 17.82           C  
ATOM    374  C   ILE A  47     -28.533  98.831  28.011  1.00 21.69           C  
ATOM    375  O   ILE A  47     -28.867  97.675  27.737  1.00 16.18           O  
ATOM    376  CB  ILE A  47     -27.757 100.247  26.079  1.00 22.73           C  
ATOM    377  CG1 ILE A  47     -28.242 101.236  25.009  1.00 23.52           C  
ATOM    378  CG2 ILE A  47     -27.305  98.945  25.430  1.00 22.47           C  
ATOM    379  CD1 ILE A  47     -27.172 101.723  24.062  1.00 21.29           C  
ATOM    380  N   ARG A  48     -27.854  99.150  29.114  1.00 22.36           N  
ATOM    381  CA  ARG A  48     -27.458  98.136  30.092  1.00 18.75           C  
ATOM    382  C   ARG A  48     -28.682  97.434  30.666  1.00 19.57           C  
ATOM    383  O   ARG A  48     -28.707  96.214  30.795  1.00 23.58           O  
ATOM    384  CB  ARG A  48     -26.693  98.769  31.259  1.00 16.47           C  
ATOM    385  CG  ARG A  48     -25.210  99.001  31.061  1.00 19.92           C  
ATOM    386  CD  ARG A  48     -24.671  99.711  32.298  1.00 24.20           C  
ATOM    387  NE  ARG A  48     -23.214  99.787  32.352  1.00 18.69           N  
ATOM    388  CZ  ARG A  48     -22.545 100.223  33.414  1.00 21.24           C  
ATOM    389  NH1 ARG A  48     -23.205 100.618  34.494  1.00 19.52           N  
ATOM    390  NH2 ARG A  48     -21.220 100.257  33.404  1.00 23.03           N  
ATOM    391  N   PHE A  49     -29.692  98.218  31.027  1.00 18.47           N  
ATOM    392  CA  PHE A  49     -30.905  97.671  31.615  1.00 24.90           C  
ATOM    393  C   PHE A  49     -31.854  97.073  30.585  1.00 29.04           C  
ATOM    394  O   PHE A  49     -32.979  96.702  30.916  1.00 34.39           O  
ATOM    395  CB  PHE A  49     -31.616  98.753  32.435  1.00 24.69           C  
ATOM    396  CG  PHE A  49     -31.037  98.947  33.809  1.00 22.99           C  
ATOM    397  CD1 PHE A  49     -31.552  98.250  34.901  1.00 28.70           C  
ATOM    398  CD2 PHE A  49     -29.968  99.813  34.014  1.00 28.43           C  
ATOM    399  CE1 PHE A  49     -31.015  98.416  36.176  1.00 24.69           C  
ATOM    400  CE2 PHE A  49     -29.422  99.985  35.285  1.00 26.39           C  
ATOM    401  CZ  PHE A  49     -29.948  99.285  36.368  1.00 28.71           C  
ATOM    402  N   ASP A  50     -31.400  96.978  29.339  1.00 28.38           N  
ATOM    403  CA  ASP A  50     -32.209  96.404  28.268  1.00 27.61           C  
ATOM    404  C   ASP A  50     -31.592  95.067  27.864  1.00 27.59           C  
ATOM    405  O   ASP A  50     -30.695  95.022  27.027  1.00 31.49           O  
ATOM    406  CB  ASP A  50     -32.239  97.341  27.061  1.00 26.55           C  
ATOM    407  CG  ASP A  50     -33.230  96.895  26.000  1.00 24.01           C  
ATOM    408  OD1 ASP A  50     -33.595  95.702  25.988  1.00 25.15           O  
ATOM    409  OD2 ASP A  50     -33.632  97.736  25.170  1.00 28.26           O  
ATOM    410  N   PRO A  51     -32.083  93.960  28.445  1.00 29.65           N  
ATOM    411  CA  PRO A  51     -31.631  92.584  28.211  1.00 31.75           C  
ATOM    412  C   PRO A  51     -31.540  92.145  26.752  1.00 33.65           C  
ATOM    413  O   PRO A  51     -30.747  91.269  26.410  1.00 34.23           O  
ATOM    414  CB  PRO A  51     -32.656  91.748  28.976  1.00 31.76           C  
ATOM    415  CG  PRO A  51     -33.102  92.660  30.058  1.00 40.16           C  
ATOM    416  CD  PRO A  51     -33.260  93.963  29.329  1.00 35.53           C  
ATOM    417  N   ASP A  52     -32.352  92.751  25.896  1.00 33.68           N  
ATOM    418  CA  ASP A  52     -32.368  92.374  24.489  1.00 32.71           C  
ATOM    419  C   ASP A  52     -31.196  92.889  23.669  1.00 27.11           C  
ATOM    420  O   ASP A  52     -30.903  92.342  22.606  1.00 27.57           O  
ATOM    421  CB  ASP A  52     -33.681  92.827  23.842  1.00 37.64           C  
ATOM    422  CG  ASP A  52     -34.898  92.183  24.484  1.00 45.51           C  
ATOM    423  OD1 ASP A  52     -34.945  90.935  24.565  1.00 43.84           O  
ATOM    424  OD2 ASP A  52     -35.810  92.928  24.903  1.00 50.71           O  
ATOM    425  N   ILE A  53     -30.526  93.932  24.147  1.00 23.86           N  
ATOM    426  CA  ILE A  53     -29.396  94.488  23.407  1.00 20.78           C  
ATOM    427  C   ILE A  53     -28.104  93.762  23.757  1.00 22.57           C  
ATOM    428  O   ILE A  53     -27.697  93.717  24.916  1.00 21.33           O  
ATOM    429  CB  ILE A  53     -29.210  95.992  23.694  1.00 19.33           C  
ATOM    430  CG1 ILE A  53     -30.537  96.733  23.505  1.00 19.95           C  
ATOM    431  CG2 ILE A  53     -28.159  96.569  22.740  1.00 16.05           C  
ATOM    432  CD1 ILE A  53     -31.097  96.652  22.093  1.00 24.94           C  
ATOM    433  N   LYS A  54     -27.460  93.193  22.745  1.00 21.45           N  
ATOM    434  CA  LYS A  54     -26.224  92.461  22.953  1.00 21.42           C  
ATOM    435  C   LYS A  54     -25.022  93.161  22.314  1.00 24.92           C  
ATOM    436  O   LYS A  54     -23.875  92.888  22.662  1.00 24.87           O  
ATOM    437  CB  LYS A  54     -26.368  91.043  22.391  1.00 30.85           C  
ATOM    438  CG  LYS A  54     -27.277  90.116  23.215  1.00 36.76           C  
ATOM    439  CD  LYS A  54     -28.739  90.516  23.147  1.00 34.32           C  
ATOM    440  CE  LYS A  54     -29.660  89.406  23.669  1.00 35.15           C  
ATOM    441  NZ  LYS A  54     -29.534  89.135  25.131  1.00 23.18           N  
ATOM    442  N   VAL A  55     -25.291  94.065  21.379  1.00 21.02           N  
ATOM    443  CA  VAL A  55     -24.230  94.792  20.704  1.00 19.97           C  
ATOM    444  C   VAL A  55     -24.585  96.262  20.537  1.00 19.62           C  
ATOM    445  O   VAL A  55     -25.743  96.615  20.316  1.00 23.98           O  
ATOM    446  CB  VAL A  55     -23.945  94.203  19.300  1.00 21.75           C  
ATOM    447  CG1 VAL A  55     -22.784  94.943  18.650  1.00 17.63           C  
ATOM    448  CG2 VAL A  55     -23.635  92.718  19.409  1.00 17.13           C  
ATOM    449  N   VAL A  56     -23.584  97.123  20.644  1.00 23.88           N  
ATOM    450  CA  VAL A  56     -23.809  98.550  20.478  1.00 18.56           C  
ATOM    451  C   VAL A  56     -22.832  99.117  19.461  1.00 18.71           C  
ATOM    452  O   VAL A  56     -21.621  98.921  19.571  1.00 20.27           O  
ATOM    453  CB  VAL A  56     -23.633  99.320  21.798  1.00 22.69           C  
ATOM    454  CG1 VAL A  56     -23.839 100.815  21.551  1.00 21.56           C  
ATOM    455  CG2 VAL A  56     -24.618  98.809  22.843  1.00 12.84           C  
ATOM    456  N   ILE A  57     -23.365  99.798  18.454  1.00 17.76           N  
ATOM    457  CA  ILE A  57     -22.521 100.416  17.444  1.00 17.06           C  
ATOM    458  C   ILE A  57     -22.603 101.925  17.625  1.00 17.77           C  
ATOM    459  O   ILE A  57     -23.688 102.501  17.642  1.00 18.76           O  
ATOM    460  CB  ILE A  57     -22.988 100.106  16.007  1.00 15.19           C  
ATOM    461  CG1 ILE A  57     -23.012  98.602  15.757  1.00  9.83           C  
ATOM    462  CG2 ILE A  57     -22.037 100.770  15.017  1.00 14.87           C  
ATOM    463  CD1 ILE A  57     -23.600  98.227  14.395  1.00 13.19           C  
ATOM    464  N   VAL A  58     -21.457 102.569  17.768  1.00 18.74           N  
ATOM    465  CA  VAL A  58     -21.459 104.009  17.909  1.00 21.18           C  
ATOM    466  C   VAL A  58     -21.009 104.577  16.570  1.00 22.51           C  
ATOM    467  O   VAL A  58     -19.928 104.253  16.086  1.00 20.99           O  
ATOM    468  CB  VAL A  58     -20.505 104.461  19.030  1.00 15.38           C  
ATOM    469  CG1 VAL A  58     -20.551 105.978  19.177  1.00 16.89           C  
ATOM    470  CG2 VAL A  58     -20.892 103.779  20.339  1.00  9.62           C  
HETATM  471  N   MSE A  59     -21.863 105.389  15.954  1.00 20.73           N  
HETATM  472  CA  MSE A  59     -21.531 106.002  14.675  1.00 23.82           C  
HETATM  473  C   MSE A  59     -21.917 107.472  14.632  1.00 21.13           C  
HETATM  474  O   MSE A  59     -22.586 107.975  15.532  1.00 20.03           O  
HETATM  475  CB  MSE A  59     -22.176 105.236  13.509  1.00 28.39           C  
HETATM  476  CG  MSE A  59     -23.557 104.661  13.768  1.00 36.74           C  
HETATM  477 SE   MSE A  59     -24.300 103.812  12.171  1.00 48.92          SE  
HETATM  478  CE  MSE A  59     -23.639 102.015  12.377  1.00 38.77           C  
ATOM    479  N   SER A  60     -21.474 108.160  13.587  1.00 25.57           N  
ATOM    480  CA  SER A  60     -21.738 109.583  13.427  1.00 26.32           C  
ATOM    481  C   SER A  60     -22.556 109.882  12.180  1.00 27.61           C  
ATOM    482  O   SER A  60     -22.362 109.252  11.138  1.00 28.29           O  
ATOM    483  CB  SER A  60     -20.408 110.345  13.354  1.00 26.67           C  
ATOM    484  OG  SER A  60     -20.602 111.715  13.047  1.00 18.57           O  
ATOM    485  N   ASP A  61     -23.468 110.844  12.291  1.00 26.78           N  
ATOM    486  CA  ASP A  61     -24.299 111.234  11.157  1.00 27.52           C  
ATOM    487  C   ASP A  61     -23.722 112.484  10.509  1.00 30.27           C  
ATOM    488  O   ASP A  61     -24.314 113.042   9.588  1.00 35.43           O  
ATOM    489  CB  ASP A  61     -25.739 111.519  11.592  1.00 27.17           C  
ATOM    490  CG  ASP A  61     -26.443 110.293  12.137  1.00 28.64           C  
ATOM    491  OD1 ASP A  61     -26.213 109.182  11.611  1.00 31.61           O  
ATOM    492  OD2 ASP A  61     -27.242 110.447  13.084  1.00 36.93           O  
ATOM    493  N   VAL A  62     -22.571 112.929  11.002  1.00 29.44           N  
ATOM    494  CA  VAL A  62     -21.915 114.112  10.461  1.00 29.87           C  
ATOM    495  C   VAL A  62     -20.948 113.695   9.350  1.00 32.62           C  
ATOM    496  O   VAL A  62     -20.085 112.836   9.542  1.00 27.61           O  
ATOM    497  CB  VAL A  62     -21.159 114.884  11.562  1.00 30.61           C  
ATOM    498  CG1 VAL A  62     -20.483 116.115  10.975  1.00 27.97           C  
ATOM    499  CG2 VAL A  62     -22.136 115.297  12.659  1.00 32.95           C  
ATOM    500  N   PRO A  63     -21.088 114.311   8.170  1.00 34.89           N  
ATOM    501  CA  PRO A  63     -20.283 114.061   6.974  1.00 39.59           C  
ATOM    502  C   PRO A  63     -18.815 113.635   7.113  1.00 38.68           C  
ATOM    503  O   PRO A  63     -18.491 112.458   6.943  1.00 43.29           O  
ATOM    504  CB  PRO A  63     -20.446 115.358   6.188  1.00 40.34           C  
ATOM    505  CG  PRO A  63     -21.878 115.682   6.447  1.00 36.89           C  
ATOM    506  CD  PRO A  63     -22.005 115.445   7.943  1.00 33.67           C  
ATOM    507  N   LYS A  64     -17.935 114.582   7.418  1.00 33.55           N  
ATOM    508  CA  LYS A  64     -16.503 114.291   7.503  1.00 33.98           C  
ATOM    509  C   LYS A  64     -15.916 114.002   8.883  1.00 31.81           C  
ATOM    510  O   LYS A  64     -14.700 113.841   9.012  1.00 26.04           O  
ATOM    511  CB  LYS A  64     -15.717 115.449   6.880  1.00 34.86           C  
ATOM    512  CG  LYS A  64     -16.150 115.813   5.466  1.00 39.39           C  
ATOM    513  CD  LYS A  64     -15.834 114.695   4.486  1.00 46.35           C  
ATOM    514  CE  LYS A  64     -16.238 115.065   3.068  1.00 45.53           C  
ATOM    515  NZ  LYS A  64     -15.900 113.987   2.094  1.00 46.30           N  
ATOM    516  N   PHE A  65     -16.754 113.932   9.912  1.00 28.01           N  
ATOM    517  CA  PHE A  65     -16.243 113.687  11.257  1.00 28.31           C  
ATOM    518  C   PHE A  65     -16.992 112.640  12.051  1.00 28.09           C  
ATOM    519  O   PHE A  65     -18.209 112.497  11.930  1.00 29.92           O  
ATOM    520  CB  PHE A  65     -16.287 114.958  12.114  1.00 24.87           C  
ATOM    521  CG  PHE A  65     -15.465 116.099  11.595  1.00 29.95           C  
ATOM    522  CD1 PHE A  65     -15.788 116.730  10.399  1.00 29.89           C  
ATOM    523  CD2 PHE A  65     -14.409 116.597  12.347  1.00 27.30           C  
ATOM    524  CE1 PHE A  65     -15.073 117.840   9.964  1.00 28.25           C  
ATOM    525  CE2 PHE A  65     -13.687 117.707  11.919  1.00 30.49           C  
ATOM    526  CZ  PHE A  65     -14.021 118.331  10.730  1.00 27.99           C  
ATOM    527  N   PHE A  66     -16.245 111.906  12.869  1.00 26.56           N  
ATOM    528  CA  PHE A  66     -16.849 110.952  13.783  1.00 23.50           C  
ATOM    529  C   PHE A  66     -17.019 111.926  14.945  1.00 21.13           C  
ATOM    530  O   PHE A  66     -18.115 112.120  15.464  1.00 23.60           O  
ATOM    531  CB  PHE A  66     -15.870 109.843  14.174  1.00 22.79           C  
ATOM    532  CG  PHE A  66     -16.338 109.013  15.337  1.00 18.02           C  
ATOM    533  CD1 PHE A  66     -17.410 108.144  15.201  1.00 16.42           C  
ATOM    534  CD2 PHE A  66     -15.731 109.135  16.584  1.00 16.62           C  
ATOM    535  CE1 PHE A  66     -17.876 107.409  16.284  1.00 15.81           C  
ATOM    536  CE2 PHE A  66     -16.188 108.405  17.675  1.00 18.84           C  
ATOM    537  CZ  PHE A  66     -17.266 107.539  17.524  1.00 16.23           C  
ATOM    538  N   SER A  67     -15.904 112.566  15.304  1.00 20.68           N  
ATOM    539  CA  SER A  67     -15.856 113.565  16.368  1.00 20.65           C  
ATOM    540  C   SER A  67     -14.454 114.152  16.494  1.00 22.88           C  
ATOM    541  O   SER A  67     -13.456 113.423  16.457  1.00 21.19           O  
ATOM    542  CB  SER A  67     -16.270 112.958  17.710  1.00 19.62           C  
ATOM    543  OG  SER A  67     -16.107 113.904  18.753  1.00 14.84           O  
ATOM    544  N   ALA A  68     -14.379 115.471  16.641  1.00 23.32           N  
ATOM    545  CA  ALA A  68     -13.091 116.144  16.782  1.00 20.78           C  
ATOM    546  C   ALA A  68     -12.754 116.407  18.248  1.00 20.59           C  
ATOM    547  O   ALA A  68     -11.867 117.198  18.550  1.00 22.87           O  
ATOM    548  CB  ALA A  68     -13.092 117.455  16.002  1.00 25.11           C  
ATOM    549  N   GLY A  69     -13.466 115.751  19.159  1.00 20.79           N  
ATOM    550  CA  GLY A  69     -13.187 115.940  20.571  1.00 21.22           C  
ATOM    551  C   GLY A  69     -14.034 116.982  21.280  1.00 22.84           C  
ATOM    552  O   GLY A  69     -15.146 117.296  20.858  1.00 29.26           O  
ATOM    553  N   ALA A  70     -13.503 117.526  22.367  1.00 19.71           N  
ATOM    554  CA  ALA A  70     -14.222 118.525  23.149  1.00 22.72           C  
ATOM    555  C   ALA A  70     -14.308 119.884  22.461  1.00 23.62           C  
ATOM    556  O   ALA A  70     -13.371 120.316  21.789  1.00 19.60           O  
ATOM    557  CB  ALA A  70     -13.569 118.678  24.522  1.00 13.42           C  
ATOM    558  N   ASP A  71     -15.445 120.551  22.639  1.00 26.85           N  
ATOM    559  CA  ASP A  71     -15.667 121.877  22.070  1.00 27.48           C  
ATOM    560  C   ASP A  71     -14.747 122.866  22.789  1.00 27.61           C  
ATOM    561  O   ASP A  71     -14.914 123.122  23.977  1.00 24.21           O  
ATOM    562  CB  ASP A  71     -17.130 122.285  22.268  1.00 35.64           C  
ATOM    563  CG  ASP A  71     -17.465 123.605  21.600  1.00 37.85           C  
ATOM    564  OD1 ASP A  71     -16.816 124.622  21.920  1.00 38.55           O  
ATOM    565  OD2 ASP A  71     -18.385 123.623  20.758  1.00 45.63           O  
ATOM    566  N   ILE A  72     -13.776 123.419  22.068  1.00 27.67           N  
ATOM    567  CA  ILE A  72     -12.827 124.362  22.653  1.00 30.49           C  
ATOM    568  C   ILE A  72     -13.498 125.603  23.227  1.00 34.78           C  
ATOM    569  O   ILE A  72     -13.016 126.174  24.205  1.00 34.44           O  
ATOM    570  CB  ILE A  72     -11.776 124.804  21.621  1.00 30.07           C  
ATOM    571  CG1 ILE A  72     -11.091 123.574  21.015  1.00 31.35           C  
ATOM    572  CG2 ILE A  72     -10.753 125.717  22.283  1.00 29.99           C  
ATOM    573  CD1 ILE A  72     -10.432 122.667  22.029  1.00 35.75           C  
ATOM    574  N   ASN A  73     -14.601 126.025  22.613  1.00 40.37           N  
ATOM    575  CA  ASN A  73     -15.335 127.192  23.094  1.00 46.97           C  
ATOM    576  C   ASN A  73     -15.926 126.867  24.455  1.00 46.58           C  
ATOM    577  O   ASN A  73     -15.831 127.657  25.394  1.00 48.02           O  
ATOM    578  CB  ASN A  73     -16.460 127.568  22.126  1.00 53.52           C  
ATOM    579  CG  ASN A  73     -15.950 128.262  20.881  1.00 64.30           C  
ATOM    580  OD1 ASN A  73     -15.273 129.290  20.962  1.00 70.08           O  
ATOM    581  ND2 ASN A  73     -16.276 127.708  19.717  1.00 66.69           N  
ATOM    582  N   PHE A  74     -16.538 125.694  24.557  1.00 45.40           N  
ATOM    583  CA  PHE A  74     -17.125 125.268  25.815  1.00 47.16           C  
ATOM    584  C   PHE A  74     -16.008 124.952  26.800  1.00 52.18           C  
ATOM    585  O   PHE A  74     -16.019 125.427  27.934  1.00 52.66           O  
ATOM    586  CB  PHE A  74     -18.008 124.034  25.606  1.00 40.15           C  
ATOM    587  CG  PHE A  74     -18.563 123.468  26.881  1.00 40.06           C  
ATOM    588  CD1 PHE A  74     -17.820 122.568  27.641  1.00 37.03           C  
ATOM    589  CD2 PHE A  74     -19.814 123.861  27.346  1.00 39.02           C  
ATOM    590  CE1 PHE A  74     -18.313 122.069  28.846  1.00 34.36           C  
ATOM    591  CE2 PHE A  74     -20.316 123.368  28.551  1.00 37.49           C  
ATOM    592  CZ  PHE A  74     -19.562 122.470  29.301  1.00 33.39           C  
ATOM    593  N   LEU A  75     -15.045 124.150  26.354  1.00 60.61           N  
ATOM    594  CA  LEU A  75     -13.912 123.756  27.185  1.00 67.39           C  
ATOM    595  C   LEU A  75     -13.352 124.979  27.895  1.00 72.59           C  
ATOM    596  O   LEU A  75     -13.333 125.032  29.124  1.00 76.22           O  
ATOM    597  CB  LEU A  75     -12.832 123.096  26.319  1.00 71.31           C  
ATOM    598  CG  LEU A  75     -11.635 122.412  26.991  1.00 74.79           C  
ATOM    599  CD1 LEU A  75     -10.923 121.539  25.970  1.00 75.99           C  
ATOM    600  CD2 LEU A  75     -10.680 123.448  27.569  1.00 78.02           C  
ATOM    601  N   ARG A  76     -12.894 125.964  27.129  1.00 77.21           N  
ATOM    602  CA  ARG A  76     -12.366 127.175  27.737  1.00 80.59           C  
ATOM    603  C   ARG A  76     -13.557 127.955  28.267  1.00 78.95           C  
ATOM    604  O   ARG A  76     -14.699 127.540  28.081  1.00 81.79           O  
ATOM    605  CB  ARG A  76     -11.599 128.017  26.715  1.00 86.35           C  
ATOM    606  CG  ARG A  76     -10.842 129.188  27.339  1.00 94.55           C  
ATOM    607  CD  ARG A  76      -9.917 128.709  28.459  1.00 99.36           C  
ATOM    608  NE  ARG A  76      -9.189 129.801  29.103  1.00 99.88           N  
ATOM    609  CZ  ARG A  76      -8.305 130.580  28.486  1.00100.42           C  
ATOM    610  NH1 ARG A  76      -8.031 130.394  27.202  1.00100.42           N  
ATOM    611  NH2 ARG A  76      -7.694 131.547  29.157  1.00100.42           N  
ATOM    612  N   SER A  77     -13.295 129.081  28.921  1.00 75.72           N  
ATOM    613  CA  SER A  77     -14.360 129.898  29.491  1.00 73.23           C  
ATOM    614  C   SER A  77     -14.914 129.189  30.725  1.00 67.91           C  
ATOM    615  O   SER A  77     -15.887 129.635  31.333  1.00 68.65           O  
ATOM    616  CB  SER A  77     -15.479 130.119  28.468  1.00 76.27           C  
ATOM    617  OG  SER A  77     -16.541 130.872  29.027  1.00 85.69           O  
ATOM    618  N   ALA A  78     -14.282 128.076  31.083  1.00 59.05           N  
ATOM    619  CA  ALA A  78     -14.691 127.299  32.243  1.00 49.90           C  
ATOM    620  C   ALA A  78     -13.584 127.315  33.290  1.00 44.30           C  
ATOM    621  O   ALA A  78     -12.403 127.274  32.957  1.00 42.11           O  
ATOM    622  CB  ALA A  78     -15.007 125.866  31.830  1.00 44.65           C  
ATOM    623  N   ASP A  79     -13.980 127.389  34.555  1.00 40.35           N  
ATOM    624  CA  ASP A  79     -13.043 127.401  35.672  1.00 42.01           C  
ATOM    625  C   ASP A  79     -12.274 126.081  35.740  1.00 37.05           C  
ATOM    626  O   ASP A  79     -12.802 125.028  35.384  1.00 34.11           O  
ATOM    627  CB  ASP A  79     -13.818 127.641  36.974  1.00 49.97           C  
ATOM    628  CG  ASP A  79     -13.244 126.881  38.154  1.00 66.30           C  
ATOM    629  OD1 ASP A  79     -12.075 127.120  38.522  1.00 75.27           O  
ATOM    630  OD2 ASP A  79     -13.971 126.039  38.719  1.00 76.97           O  
ATOM    631  N   PRO A  80     -11.006 126.123  36.186  1.00 35.47           N  
ATOM    632  CA  PRO A  80     -10.186 124.913  36.289  1.00 32.39           C  
ATOM    633  C   PRO A  80     -10.846 123.800  37.102  1.00 29.02           C  
ATOM    634  O   PRO A  80     -10.619 122.616  36.845  1.00 27.47           O  
ATOM    635  CB  PRO A  80      -8.905 125.424  36.939  1.00 33.24           C  
ATOM    636  CG  PRO A  80      -8.784 126.791  36.359  1.00 35.77           C  
ATOM    637  CD  PRO A  80     -10.197 127.321  36.480  1.00 29.00           C  
ATOM    638  N   ARG A  81     -11.662 124.173  38.082  1.00 22.39           N  
ATOM    639  CA  ARG A  81     -12.327 123.165  38.896  1.00 25.77           C  
ATOM    640  C   ARG A  81     -13.519 122.568  38.167  1.00 23.95           C  
ATOM    641  O   ARG A  81     -13.885 121.422  38.408  1.00 22.65           O  
ATOM    642  CB  ARG A  81     -12.744 123.749  40.246  1.00 27.47           C  
ATOM    643  CG  ARG A  81     -11.573 123.897  41.204  1.00 32.61           C  
ATOM    644  CD  ARG A  81     -12.004 124.389  42.572  1.00 43.96           C  
ATOM    645  NE  ARG A  81     -12.502 125.760  42.535  1.00 51.13           N  
ATOM    646  CZ  ARG A  81     -12.762 126.489  43.616  1.00 54.27           C  
ATOM    647  NH1 ARG A  81     -12.570 125.977  44.827  1.00 56.75           N  
ATOM    648  NH2 ARG A  81     -13.203 127.732  43.489  1.00 49.70           N  
ATOM    649  N   PHE A  82     -14.120 123.344  37.271  1.00 25.71           N  
ATOM    650  CA  PHE A  82     -15.246 122.843  36.495  1.00 20.22           C  
ATOM    651  C   PHE A  82     -14.680 121.887  35.445  1.00 17.97           C  
ATOM    652  O   PHE A  82     -15.282 120.860  35.144  1.00 20.09           O  
ATOM    653  CB  PHE A  82     -15.988 123.977  35.785  1.00 18.71           C  
ATOM    654  CG  PHE A  82     -17.100 123.496  34.889  1.00 22.36           C  
ATOM    655  CD1 PHE A  82     -18.366 123.238  35.403  1.00 22.81           C  
ATOM    656  CD2 PHE A  82     -16.862 123.236  33.541  1.00 23.57           C  
ATOM    657  CE1 PHE A  82     -19.378 122.725  34.592  1.00 19.70           C  
ATOM    658  CE2 PHE A  82     -17.863 122.723  32.725  1.00 23.81           C  
ATOM    659  CZ  PHE A  82     -19.123 122.466  33.250  1.00 25.30           C  
ATOM    660  N   LYS A  83     -13.521 122.237  34.890  1.00 17.82           N  
ATOM    661  CA  LYS A  83     -12.866 121.406  33.878  1.00 23.73           C  
ATOM    662  C   LYS A  83     -12.493 120.056  34.477  1.00 22.76           C  
ATOM    663  O   LYS A  83     -12.610 119.016  33.829  1.00 20.76           O  
ATOM    664  CB  LYS A  83     -11.599 122.089  33.358  1.00 25.23           C  
ATOM    665  CG  LYS A  83     -11.838 123.361  32.557  1.00 29.71           C  
ATOM    666  CD  LYS A  83     -10.523 123.944  32.064  1.00 29.92           C  
ATOM    667  CE  LYS A  83     -10.740 125.193  31.239  1.00 37.27           C  
ATOM    668  NZ  LYS A  83      -9.453 125.751  30.737  1.00 37.68           N  
ATOM    669  N   THR A  84     -12.036 120.091  35.725  1.00 23.30           N  
ATOM    670  CA  THR A  84     -11.651 118.886  36.438  1.00 17.75           C  
ATOM    671  C   THR A  84     -12.855 117.965  36.573  1.00 16.84           C  
ATOM    672  O   THR A  84     -12.761 116.770  36.306  1.00 17.81           O  
ATOM    673  CB  THR A  84     -11.115 119.226  37.849  1.00 18.29           C  
ATOM    674  OG1 THR A  84      -9.906 119.984  37.729  1.00 13.84           O  
ATOM    675  CG2 THR A  84     -10.848 117.954  38.647  1.00 14.02           C  
ATOM    676  N   GLN A  85     -13.992 118.523  36.979  1.00 13.55           N  
ATOM    677  CA  GLN A  85     -15.194 117.719  37.143  1.00 15.02           C  
ATOM    678  C   GLN A  85     -15.800 117.308  35.806  1.00 17.62           C  
ATOM    679  O   GLN A  85     -16.417 116.250  35.694  1.00 16.66           O  
ATOM    680  CB  GLN A  85     -16.223 118.468  37.991  1.00 20.13           C  
ATOM    681  CG  GLN A  85     -15.761 118.713  39.419  1.00 18.42           C  
ATOM    682  CD  GLN A  85     -15.186 117.461  40.063  1.00 16.97           C  
ATOM    683  OE1 GLN A  85     -15.812 116.398  40.053  1.00 22.23           O  
ATOM    684  NE2 GLN A  85     -13.990 117.582  40.631  1.00 16.68           N  
ATOM    685  N   PHE A  86     -15.626 118.149  34.793  1.00 18.58           N  
ATOM    686  CA  PHE A  86     -16.128 117.840  33.462  1.00 15.85           C  
ATOM    687  C   PHE A  86     -15.372 116.612  32.956  1.00 16.02           C  
ATOM    688  O   PHE A  86     -15.972 115.647  32.477  1.00 18.71           O  
ATOM    689  CB  PHE A  86     -15.886 119.025  32.521  1.00 19.24           C  
ATOM    690  CG  PHE A  86     -16.078 118.697  31.062  1.00 21.00           C  
ATOM    691  CD1 PHE A  86     -17.305 118.252  30.584  1.00 26.66           C  
ATOM    692  CD2 PHE A  86     -15.028 118.844  30.162  1.00 25.75           C  
ATOM    693  CE1 PHE A  86     -17.485 117.958  29.231  1.00 26.01           C  
ATOM    694  CE2 PHE A  86     -15.197 118.552  28.808  1.00 24.92           C  
ATOM    695  CZ  PHE A  86     -16.427 118.110  28.342  1.00 22.12           C  
ATOM    696  N   CYS A  87     -14.049 116.653  33.075  1.00 19.29           N  
ATOM    697  CA  CYS A  87     -13.200 115.552  32.633  1.00 19.75           C  
ATOM    698  C   CYS A  87     -13.462 114.267  33.409  1.00 16.05           C  
ATOM    699  O   CYS A  87     -13.541 113.194  32.820  1.00 20.99           O  
ATOM    700  CB  CYS A  87     -11.725 115.946  32.747  1.00 16.17           C  
ATOM    701  SG  CYS A  87     -11.228 117.232  31.552  1.00 24.91           S  
ATOM    702  N   LEU A  88     -13.604 114.378  34.728  1.00 14.94           N  
ATOM    703  CA  LEU A  88     -13.862 113.211  35.565  1.00 15.24           C  
ATOM    704  C   LEU A  88     -15.143 112.507  35.131  1.00 14.18           C  
ATOM    705  O   LEU A  88     -15.163 111.287  34.991  1.00 17.66           O  
ATOM    706  CB  LEU A  88     -13.968 113.613  37.040  1.00 11.32           C  
ATOM    707  CG  LEU A  88     -14.240 112.490  38.050  1.00 21.28           C  
ATOM    708  CD1 LEU A  88     -13.259 111.328  37.848  1.00 13.57           C  
ATOM    709  CD2 LEU A  88     -14.107 113.055  39.467  1.00 15.11           C  
ATOM    710  N   PHE A  89     -16.205 113.272  34.903  1.00 17.62           N  
ATOM    711  CA  PHE A  89     -17.477 112.685  34.481  1.00 17.66           C  
ATOM    712  C   PHE A  89     -17.369 111.989  33.124  1.00 11.38           C  
ATOM    713  O   PHE A  89     -17.925 110.906  32.925  1.00 14.76           O  
ATOM    714  CB  PHE A  89     -18.575 113.747  34.400  1.00 20.01           C  
ATOM    715  CG  PHE A  89     -19.914 113.187  34.016  1.00 16.69           C  
ATOM    716  CD1 PHE A  89     -20.672 112.475  34.937  1.00 20.17           C  
ATOM    717  CD2 PHE A  89     -20.389 113.317  32.717  1.00 17.19           C  
ATOM    718  CE1 PHE A  89     -21.885 111.895  34.567  1.00 22.65           C  
ATOM    719  CE2 PHE A  89     -21.599 112.741  32.336  1.00 20.67           C  
ATOM    720  CZ  PHE A  89     -22.348 112.028  33.262  1.00 17.98           C  
ATOM    721  N   CYS A  90     -16.673 112.619  32.184  1.00 15.51           N  
ATOM    722  CA  CYS A  90     -16.503 112.028  30.860  1.00 15.27           C  
ATOM    723  C   CYS A  90     -15.748 110.703  30.966  1.00 14.94           C  
ATOM    724  O   CYS A  90     -16.126 109.715  30.338  1.00 13.83           O  
ATOM    725  CB  CYS A  90     -15.734 112.982  29.944  1.00 18.67           C  
ATOM    726  SG  CYS A  90     -16.614 114.512  29.565  1.00 19.91           S  
ATOM    727  N   ASN A  91     -14.683 110.692  31.763  1.00 13.47           N  
ATOM    728  CA  ASN A  91     -13.885 109.487  31.951  1.00 17.73           C  
ATOM    729  C   ASN A  91     -14.702 108.358  32.571  1.00 13.33           C  
ATOM    730  O   ASN A  91     -14.673 107.225  32.089  1.00 17.17           O  
ATOM    731  CB  ASN A  91     -12.657 109.785  32.819  1.00 10.82           C  
ATOM    732  CG  ASN A  91     -11.508 110.366  32.020  1.00 17.06           C  
ATOM    733  OD1 ASN A  91     -11.108 109.805  31.003  1.00 19.42           O  
ATOM    734  ND2 ASN A  91     -10.959 111.487  32.484  1.00 14.14           N  
ATOM    735  N   GLU A  92     -15.435 108.666  33.636  1.00 14.36           N  
ATOM    736  CA  GLU A  92     -16.257 107.659  34.293  1.00 16.02           C  
ATOM    737  C   GLU A  92     -17.305 107.126  33.322  1.00 17.07           C  
ATOM    738  O   GLU A  92     -17.667 105.948  33.365  1.00 12.22           O  
ATOM    739  CB  GLU A  92     -16.931 108.252  35.537  1.00 16.04           C  
ATOM    740  CG  GLU A  92     -15.928 108.734  36.584  1.00 22.58           C  
ATOM    741  CD  GLU A  92     -16.583 109.242  37.855  1.00 21.26           C  
ATOM    742  OE1 GLU A  92     -17.655 109.873  37.757  1.00 21.56           O  
ATOM    743  OE2 GLU A  92     -16.016 109.026  38.951  1.00 17.03           O  
ATOM    744  N   THR A  93     -17.790 107.993  32.437  1.00 14.15           N  
ATOM    745  CA  THR A  93     -18.783 107.565  31.459  1.00 16.40           C  
ATOM    746  C   THR A  93     -18.125 106.561  30.515  1.00 17.27           C  
ATOM    747  O   THR A  93     -18.649 105.471  30.291  1.00 16.32           O  
ATOM    748  CB  THR A  93     -19.322 108.754  30.645  1.00 16.34           C  
ATOM    749  OG1 THR A  93     -20.009 109.658  31.524  1.00 19.23           O  
ATOM    750  CG2 THR A  93     -20.289 108.267  29.559  1.00 13.75           C  
ATOM    751  N   LEU A  94     -16.968 106.926  29.973  1.00 15.38           N  
ATOM    752  CA  LEU A  94     -16.263 106.028  29.071  1.00 16.92           C  
ATOM    753  C   LEU A  94     -15.894 104.728  29.792  1.00 14.98           C  
ATOM    754  O   LEU A  94     -15.945 103.654  29.197  1.00  9.86           O  
ATOM    755  CB  LEU A  94     -15.004 106.704  28.512  1.00 12.38           C  
ATOM    756  CG  LEU A  94     -15.227 107.910  27.584  1.00 18.77           C  
ATOM    757  CD1 LEU A  94     -13.900 108.271  26.916  1.00 10.59           C  
ATOM    758  CD2 LEU A  94     -16.281 107.583  26.510  1.00  9.55           C  
ATOM    759  N   ASP A  95     -15.546 104.822  31.072  1.00 14.68           N  
ATOM    760  CA  ASP A  95     -15.176 103.633  31.841  1.00 16.40           C  
ATOM    761  C   ASP A  95     -16.300 102.594  31.906  1.00 16.28           C  
ATOM    762  O   ASP A  95     -16.035 101.392  31.999  1.00 17.33           O  
ATOM    763  CB  ASP A  95     -14.781 104.002  33.282  1.00 16.55           C  
ATOM    764  CG  ASP A  95     -13.564 104.911  33.355  1.00 19.78           C  
ATOM    765  OD1 ASP A  95     -12.712 104.864  32.444  1.00 20.81           O  
ATOM    766  OD2 ASP A  95     -13.455 105.666  34.347  1.00 22.90           O  
ATOM    767  N   LYS A  96     -17.546 103.058  31.872  1.00 13.78           N  
ATOM    768  CA  LYS A  96     -18.703 102.167  31.956  1.00 11.36           C  
ATOM    769  C   LYS A  96     -18.829 101.139  30.826  1.00 12.10           C  
ATOM    770  O   LYS A  96     -19.413 100.073  31.013  1.00 14.28           O  
ATOM    771  CB  LYS A  96     -19.982 103.006  32.058  1.00 12.14           C  
ATOM    772  CG  LYS A  96     -20.005 103.862  33.325  1.00 13.20           C  
ATOM    773  CD  LYS A  96     -21.173 104.841  33.397  1.00 14.25           C  
ATOM    774  CE  LYS A  96     -22.499 104.143  33.667  1.00 18.33           C  
ATOM    775  NZ  LYS A  96     -23.512 105.112  34.186  1.00 20.32           N  
ATOM    776  N   ILE A  97     -18.272 101.451  29.661  1.00 12.79           N  
ATOM    777  CA  ILE A  97     -18.343 100.551  28.514  1.00 15.97           C  
ATOM    778  C   ILE A  97     -17.670  99.195  28.759  1.00 17.30           C  
ATOM    779  O   ILE A  97     -18.242  98.147  28.456  1.00 23.78           O  
ATOM    780  CB  ILE A  97     -17.718 101.219  27.256  1.00 15.63           C  
ATOM    781  CG1 ILE A  97     -18.528 102.463  26.884  1.00 11.78           C  
ATOM    782  CG2 ILE A  97     -17.705 100.241  26.087  1.00 16.83           C  
ATOM    783  CD1 ILE A  97     -17.948 103.264  25.744  1.00 14.39           C  
ATOM    784  N   ALA A  98     -16.460  99.211  29.306  1.00 13.08           N  
ATOM    785  CA  ALA A  98     -15.739  97.973  29.578  1.00 14.95           C  
ATOM    786  C   ALA A  98     -16.479  97.094  30.586  1.00 14.71           C  
ATOM    787  O   ALA A  98     -16.276  95.886  30.625  1.00 14.15           O  
ATOM    788  CB  ALA A  98     -14.339  98.287  30.093  1.00 15.00           C  
ATOM    789  N   ARG A  99     -17.337  97.705  31.399  1.00 13.72           N  
ATOM    790  CA  ARG A  99     -18.092  96.963  32.401  1.00 15.51           C  
ATOM    791  C   ARG A  99     -19.461  96.510  31.902  1.00 14.53           C  
ATOM    792  O   ARG A  99     -20.132  95.728  32.576  1.00 17.97           O  
ATOM    793  CB  ARG A  99     -18.280  97.817  33.662  1.00  9.91           C  
ATOM    794  CG  ARG A  99     -16.992  98.386  34.221  1.00 15.92           C  
ATOM    795  CD  ARG A  99     -17.211  99.080  35.558  1.00  9.79           C  
ATOM    796  NE  ARG A  99     -16.034  99.852  35.950  1.00  6.39           N  
ATOM    797  CZ  ARG A  99     -15.999 101.179  36.025  1.00 14.55           C  
ATOM    798  NH1 ARG A  99     -17.082 101.897  35.743  1.00  9.75           N  
ATOM    799  NH2 ARG A  99     -14.874 101.791  36.364  1.00 10.66           N  
ATOM    800  N   SER A 100     -19.876  97.005  30.735  1.00 13.35           N  
ATOM    801  CA  SER A 100     -21.183  96.665  30.162  1.00 14.50           C  
ATOM    802  C   SER A 100     -21.246  95.297  29.474  1.00 18.10           C  
ATOM    803  O   SER A 100     -20.269  94.838  28.886  1.00 16.29           O  
ATOM    804  CB  SER A 100     -21.611  97.749  29.168  1.00 17.67           C  
ATOM    805  OG  SER A 100     -21.713  99.012  29.804  1.00 16.06           O  
ATOM    806  N   PRO A 101     -22.415  94.638  29.524  1.00 20.45           N  
ATOM    807  CA  PRO A 101     -22.586  93.323  28.902  1.00 21.62           C  
ATOM    808  C   PRO A 101     -22.464  93.356  27.384  1.00 20.56           C  
ATOM    809  O   PRO A 101     -22.010  92.386  26.778  1.00 24.06           O  
ATOM    810  CB  PRO A 101     -23.997  92.904  29.335  1.00 22.53           C  
ATOM    811  CG  PRO A 101     -24.262  93.716  30.560  1.00 23.53           C  
ATOM    812  CD  PRO A 101     -23.649  95.047  30.212  1.00 24.63           C  
ATOM    813  N   GLN A 102     -22.883  94.465  26.776  1.00 18.37           N  
ATOM    814  CA  GLN A 102     -22.844  94.611  25.321  1.00 20.88           C  
ATOM    815  C   GLN A 102     -21.454  94.877  24.783  1.00 24.06           C  
ATOM    816  O   GLN A 102     -20.625  95.494  25.452  1.00 17.80           O  
ATOM    817  CB  GLN A 102     -23.723  95.777  24.842  1.00 24.05           C  
ATOM    818  CG  GLN A 102     -25.209  95.670  25.099  1.00 24.19           C  
ATOM    819  CD  GLN A 102     -25.579  96.016  26.521  1.00 27.48           C  
ATOM    820  OE1 GLN A 102     -24.865  96.759  27.200  1.00 19.80           O  
ATOM    821  NE2 GLN A 102     -26.713  95.495  26.978  1.00 18.85           N  
ATOM    822  N   VAL A 103     -21.217  94.425  23.556  1.00 22.52           N  
ATOM    823  CA  VAL A 103     -19.952  94.661  22.886  1.00 18.27           C  
ATOM    824  C   VAL A 103     -20.106  96.021  22.209  1.00 21.97           C  
ATOM    825  O   VAL A 103     -21.032  96.231  21.421  1.00 19.92           O  
ATOM    826  CB  VAL A 103     -19.668  93.584  21.816  1.00 18.94           C  
ATOM    827  CG1 VAL A 103     -18.477  93.989  20.957  1.00 14.50           C  
ATOM    828  CG2 VAL A 103     -19.394  92.252  22.490  1.00 25.13           C  
ATOM    829  N   TYR A 104     -19.215  96.949  22.537  1.00 19.30           N  
ATOM    830  CA  TYR A 104     -19.254  98.282  21.951  1.00 18.55           C  
ATOM    831  C   TYR A 104     -18.294  98.412  20.765  1.00 19.67           C  
ATOM    832  O   TYR A 104     -17.093  98.182  20.893  1.00 20.22           O  
ATOM    833  CB  TYR A 104     -18.921  99.334  23.015  1.00 18.03           C  
ATOM    834  CG  TYR A 104     -20.121  99.799  23.818  1.00 17.76           C  
ATOM    835  CD1 TYR A 104     -20.840  98.912  24.621  1.00 18.81           C  
ATOM    836  CD2 TYR A 104     -20.556 101.120  23.745  1.00 12.60           C  
ATOM    837  CE1 TYR A 104     -21.971  99.335  25.330  1.00 17.58           C  
ATOM    838  CE2 TYR A 104     -21.680 101.551  24.445  1.00 17.56           C  
ATOM    839  CZ  TYR A 104     -22.382 100.656  25.232  1.00 15.94           C  
ATOM    840  OH  TYR A 104     -23.496 101.086  25.903  1.00 15.04           O  
ATOM    841  N   ILE A 105     -18.839  98.781  19.610  1.00 19.33           N  
ATOM    842  CA  ILE A 105     -18.046  98.939  18.398  1.00 18.87           C  
ATOM    843  C   ILE A 105     -18.118 100.384  17.919  1.00 21.97           C  
ATOM    844  O   ILE A 105     -19.205 100.942  17.774  1.00 23.33           O  
ATOM    845  CB  ILE A 105     -18.572  98.039  17.254  1.00 13.20           C  
ATOM    846  CG1 ILE A 105     -18.673  96.591  17.728  1.00 11.55           C  
ATOM    847  CG2 ILE A 105     -17.639  98.128  16.038  1.00  6.07           C  
ATOM    848  CD1 ILE A 105     -19.301  95.672  16.699  1.00 14.15           C  
ATOM    849  N   ALA A 106     -16.960 100.984  17.677  1.00 17.30           N  
ATOM    850  CA  ALA A 106     -16.903 102.352  17.185  1.00 17.64           C  
ATOM    851  C   ALA A 106     -16.844 102.292  15.664  1.00 23.73           C  
ATOM    852  O   ALA A 106     -15.890 101.758  15.099  1.00 20.73           O  
ATOM    853  CB  ALA A 106     -15.670 103.047  17.720  1.00 14.12           C  
ATOM    854  N   CYS A 107     -17.868 102.821  15.003  1.00 25.22           N  
ATOM    855  CA  CYS A 107     -17.905 102.825  13.545  1.00 23.87           C  
ATOM    856  C   CYS A 107     -17.330 104.157  13.082  1.00 23.86           C  
ATOM    857  O   CYS A 107     -18.030 105.168  13.058  1.00 23.96           O  
ATOM    858  CB  CYS A 107     -19.342 102.672  13.042  1.00 20.29           C  
ATOM    859  SG  CYS A 107     -19.470 102.469  11.242  1.00 23.39           S  
ATOM    860  N   LEU A 108     -16.055 104.154  12.708  1.00 20.18           N  
ATOM    861  CA  LEU A 108     -15.387 105.378  12.290  1.00 19.20           C  
ATOM    862  C   LEU A 108     -15.455 105.637  10.784  1.00 22.03           C  
ATOM    863  O   LEU A 108     -14.817 104.945   9.987  1.00 20.55           O  
ATOM    864  CB  LEU A 108     -13.932 105.334  12.765  1.00 16.15           C  
ATOM    865  CG  LEU A 108     -13.770 104.989  14.254  1.00 15.85           C  
ATOM    866  CD1 LEU A 108     -12.285 104.868  14.593  1.00 16.93           C  
ATOM    867  CD2 LEU A 108     -14.436 106.061  15.124  1.00 15.36           C  
ATOM    868  N   GLU A 109     -16.233 106.648  10.403  1.00 20.65           N  
ATOM    869  CA  GLU A 109     -16.396 107.005   8.998  1.00 23.62           C  
ATOM    870  C   GLU A 109     -15.802 108.367   8.668  1.00 21.97           C  
ATOM    871  O   GLU A 109     -15.765 108.767   7.507  1.00 26.28           O  
ATOM    872  CB  GLU A 109     -17.876 106.988   8.617  1.00 22.70           C  
ATOM    873  CG  GLU A 109     -18.479 105.599   8.542  1.00 26.57           C  
ATOM    874  CD  GLU A 109     -19.974 105.631   8.307  1.00 32.20           C  
ATOM    875  OE1 GLU A 109     -20.715 106.001   9.243  1.00 33.64           O  
ATOM    876  OE2 GLU A 109     -20.410 105.295   7.186  1.00 34.77           O  
ATOM    877  N   GLY A 110     -15.340 109.078   9.690  1.00 25.21           N  
ATOM    878  CA  GLY A 110     -14.749 110.387   9.472  1.00 24.97           C  
ATOM    879  C   GLY A 110     -13.611 110.654  10.437  1.00 24.61           C  
ATOM    880  O   GLY A 110     -13.157 109.749  11.132  1.00 25.59           O  
ATOM    881  N   HIS A 111     -13.149 111.898  10.480  1.00 24.80           N  
ATOM    882  CA  HIS A 111     -12.061 112.274  11.372  1.00 21.19           C  
ATOM    883  C   HIS A 111     -12.370 111.848  12.799  1.00 20.92           C  
ATOM    884  O   HIS A 111     -13.451 112.132  13.324  1.00 18.47           O  
ATOM    885  CB  HIS A 111     -11.830 113.787  11.324  1.00 20.77           C  
ATOM    886  CG  HIS A 111     -11.314 114.281  10.007  1.00 25.04           C  
ATOM    887  ND1 HIS A 111     -11.927 115.294   9.300  1.00 30.38           N  
ATOM    888  CD2 HIS A 111     -10.245 113.901   9.270  1.00 24.97           C  
ATOM    889  CE1 HIS A 111     -11.255 115.514   8.181  1.00 26.72           C  
ATOM    890  NE2 HIS A 111     -10.234 114.684   8.141  1.00 29.88           N  
ATOM    891  N   THR A 112     -11.407 111.164  13.414  1.00 20.76           N  
ATOM    892  CA  THR A 112     -11.528 110.671  14.785  1.00 21.18           C  
ATOM    893  C   THR A 112     -10.306 111.159  15.552  1.00 16.24           C  
ATOM    894  O   THR A 112      -9.295 110.462  15.628  1.00 17.83           O  
ATOM    895  CB  THR A 112     -11.561 109.123  14.808  1.00 18.75           C  
ATOM    896  OG1 THR A 112     -12.630 108.658  13.978  1.00 21.15           O  
ATOM    897  CG2 THR A 112     -11.775 108.607  16.218  1.00 11.48           C  
ATOM    898  N   VAL A 113     -10.399 112.356  16.121  1.00 14.29           N  
ATOM    899  CA  VAL A 113      -9.273 112.934  16.836  1.00 16.92           C  
ATOM    900  C   VAL A 113      -9.597 113.447  18.233  1.00 16.68           C  
ATOM    901  O   VAL A 113     -10.755 113.712  18.563  1.00 20.16           O  
ATOM    902  CB  VAL A 113      -8.641 114.085  16.011  1.00 18.13           C  
ATOM    903  CG1 VAL A 113      -8.108 113.541  14.689  1.00 14.43           C  
ATOM    904  CG2 VAL A 113      -9.674 115.170  15.748  1.00 16.13           C  
ATOM    905  N   GLY A 114      -8.552 113.591  19.046  1.00 13.57           N  
ATOM    906  CA  GLY A 114      -8.715 114.062  20.412  1.00 10.65           C  
ATOM    907  C   GLY A 114      -9.794 113.283  21.135  1.00 10.74           C  
ATOM    908  O   GLY A 114      -9.839 112.056  21.062  1.00 17.09           O  
ATOM    909  N   GLY A 115     -10.667 114.004  21.829  1.00 13.20           N  
ATOM    910  CA  GLY A 115     -11.752 113.368  22.549  1.00 12.03           C  
ATOM    911  C   GLY A 115     -12.524 112.388  21.692  1.00 14.64           C  
ATOM    912  O   GLY A 115     -13.121 111.449  22.212  1.00 11.79           O  
ATOM    913  N   GLY A 116     -12.521 112.603  20.378  1.00 17.31           N  
ATOM    914  CA  GLY A 116     -13.232 111.702  19.490  1.00 14.60           C  
ATOM    915  C   GLY A 116     -12.588 110.324  19.506  1.00 15.17           C  
ATOM    916  O   GLY A 116     -13.272 109.296  19.548  1.00 13.88           O  
ATOM    917  N   LEU A 117     -11.261 110.303  19.467  1.00 14.26           N  
ATOM    918  CA  LEU A 117     -10.525 109.047  19.496  1.00 16.21           C  
ATOM    919  C   LEU A 117     -10.628 108.442  20.892  1.00 11.84           C  
ATOM    920  O   LEU A 117     -10.745 107.227  21.049  1.00 12.10           O  
ATOM    921  CB  LEU A 117      -9.053 109.272  19.139  1.00 11.43           C  
ATOM    922  CG  LEU A 117      -8.182 108.013  19.246  1.00 16.48           C  
ATOM    923  CD1 LEU A 117      -8.797 106.893  18.420  1.00 15.72           C  
ATOM    924  CD2 LEU A 117      -6.772 108.313  18.769  1.00 17.42           C  
ATOM    925  N   GLU A 118     -10.599 109.294  21.908  1.00 15.82           N  
ATOM    926  CA  GLU A 118     -10.693 108.810  23.279  1.00 10.92           C  
ATOM    927  C   GLU A 118     -11.981 108.023  23.485  1.00 14.73           C  
ATOM    928  O   GLU A 118     -11.980 106.979  24.132  1.00 14.84           O  
ATOM    929  CB  GLU A 118     -10.599 109.986  24.252  1.00  8.17           C  
ATOM    930  CG  GLU A 118      -9.260 110.685  24.163  1.00 10.94           C  
ATOM    931  CD  GLU A 118      -9.134 111.851  25.107  1.00 21.07           C  
ATOM    932  OE1 GLU A 118      -9.821 112.874  24.892  1.00 24.43           O  
ATOM    933  OE2 GLU A 118      -8.342 111.742  26.065  1.00 16.76           O  
HETATM  934  N   MSE A 119     -13.080 108.515  22.923  1.00 14.33           N  
HETATM  935  CA  MSE A 119     -14.355 107.815  23.040  1.00 16.97           C  
HETATM  936  C   MSE A 119     -14.248 106.473  22.329  1.00 16.34           C  
HETATM  937  O   MSE A 119     -14.742 105.457  22.816  1.00 15.82           O  
HETATM  938  CB  MSE A 119     -15.477 108.630  22.393  1.00 17.62           C  
HETATM  939  CG  MSE A 119     -16.845 107.973  22.478  1.00 31.85           C  
HETATM  940 SE   MSE A 119     -18.221 109.011  21.586  1.00 50.78          SE  
HETATM  941  CE  MSE A 119     -17.747 110.766  22.242  1.00 39.27           C  
ATOM    942  N   ALA A 120     -13.600 106.488  21.165  1.00 14.41           N  
ATOM    943  CA  ALA A 120     -13.416 105.290  20.355  1.00 15.55           C  
ATOM    944  C   ALA A 120     -12.491 104.279  21.036  1.00 16.12           C  
ATOM    945  O   ALA A 120     -12.686 103.070  20.904  1.00 12.21           O  
ATOM    946  CB  ALA A 120     -12.858 105.672  18.990  1.00 11.62           C  
ATOM    947  N   LEU A 121     -11.490 104.778  21.760  1.00  8.11           N  
ATOM    948  CA  LEU A 121     -10.547 103.910  22.466  1.00 12.02           C  
ATOM    949  C   LEU A 121     -11.238 103.174  23.608  1.00 17.32           C  
ATOM    950  O   LEU A 121     -10.838 102.067  23.973  1.00 12.96           O  
ATOM    951  CB  LEU A 121      -9.373 104.727  23.026  1.00  9.31           C  
ATOM    952  CG  LEU A 121      -8.313 105.245  22.043  1.00 12.90           C  
ATOM    953  CD1 LEU A 121      -7.372 106.226  22.743  1.00  5.31           C  
ATOM    954  CD2 LEU A 121      -7.527 104.073  21.478  1.00 13.33           C  
ATOM    955  N   ALA A 122     -12.279 103.793  24.165  1.00 15.20           N  
ATOM    956  CA  ALA A 122     -13.028 103.201  25.276  1.00 12.66           C  
ATOM    957  C   ALA A 122     -13.986 102.098  24.816  1.00 15.60           C  
ATOM    958  O   ALA A 122     -14.501 101.340  25.632  1.00 16.14           O  
ATOM    959  CB  ALA A 122     -13.795 104.284  26.028  1.00  5.72           C  
ATOM    960  N   CYS A 123     -14.227 102.011  23.509  1.00 15.54           N  
ATOM    961  CA  CYS A 123     -15.096 100.967  22.975  1.00 13.59           C  
ATOM    962  C   CYS A 123     -14.283  99.678  22.838  1.00 11.78           C  
ATOM    963  O   CYS A 123     -13.053  99.719  22.824  1.00  9.00           O  
ATOM    964  CB  CYS A 123     -15.654 101.380  21.610  1.00 13.09           C  
ATOM    965  SG  CYS A 123     -16.747 102.820  21.656  1.00 22.32           S  
ATOM    966  N   ASP A 124     -14.968  98.543  22.734  1.00 12.23           N  
ATOM    967  CA  ASP A 124     -14.305  97.242  22.620  1.00 13.53           C  
ATOM    968  C   ASP A 124     -13.604  97.025  21.280  1.00 16.76           C  
ATOM    969  O   ASP A 124     -12.574  96.351  21.217  1.00 15.88           O  
ATOM    970  CB  ASP A 124     -15.319  96.111  22.849  1.00 10.05           C  
ATOM    971  CG  ASP A 124     -16.044  96.238  24.179  1.00 19.39           C  
ATOM    972  OD1 ASP A 124     -15.365  96.505  25.190  1.00 19.42           O  
ATOM    973  OD2 ASP A 124     -17.284  96.068  24.224  1.00 12.13           O  
ATOM    974  N   LEU A 125     -14.164  97.590  20.213  1.00 14.31           N  
ATOM    975  CA  LEU A 125     -13.591  97.444  18.879  1.00 15.07           C  
ATOM    976  C   LEU A 125     -13.723  98.739  18.087  1.00 13.06           C  
ATOM    977  O   LEU A 125     -14.591  99.557  18.368  1.00 12.59           O  
ATOM    978  CB  LEU A 125     -14.304  96.321  18.117  1.00 12.49           C  
ATOM    979  CG  LEU A 125     -14.295  94.902  18.692  1.00 20.63           C  
ATOM    980  CD1 LEU A 125     -15.375  94.061  18.008  1.00 13.71           C  
ATOM    981  CD2 LEU A 125     -12.919  94.282  18.513  1.00 12.76           C  
ATOM    982  N   ARG A 126     -12.865  98.905  17.084  1.00 13.41           N  
ATOM    983  CA  ARG A 126     -12.883 100.088  16.233  1.00 18.11           C  
ATOM    984  C   ARG A 126     -12.755  99.698  14.762  1.00 19.37           C  
ATOM    985  O   ARG A 126     -11.768  99.077  14.374  1.00 19.99           O  
ATOM    986  CB  ARG A 126     -11.732 101.026  16.615  1.00 15.35           C  
ATOM    987  CG  ARG A 126     -11.911 101.726  17.964  1.00 17.66           C  
ATOM    988  CD  ARG A 126     -10.563 102.099  18.566  1.00 11.28           C  
ATOM    989  NE  ARG A 126      -9.828 100.901  18.968  1.00 15.26           N  
ATOM    990  CZ  ARG A 126     -10.153 100.143  20.012  1.00 15.92           C  
ATOM    991  NH1 ARG A 126     -11.198 100.459  20.769  1.00  8.76           N  
ATOM    992  NH2 ARG A 126      -9.449  99.053  20.288  1.00 14.78           N  
ATOM    993  N   PHE A 127     -13.762 100.046  13.958  1.00 19.48           N  
ATOM    994  CA  PHE A 127     -13.759  99.762  12.516  1.00 16.69           C  
ATOM    995  C   PHE A 127     -13.738 101.110  11.800  1.00 14.96           C  
ATOM    996  O   PHE A 127     -14.536 101.992  12.113  1.00 15.99           O  
ATOM    997  CB  PHE A 127     -15.016  98.981  12.091  1.00 12.51           C  
ATOM    998  CG  PHE A 127     -15.169  97.628  12.755  1.00 13.52           C  
ATOM    999  CD1 PHE A 127     -14.083  96.988  13.355  1.00 15.05           C  
ATOM   1000  CD2 PHE A 127     -16.407  96.986  12.765  1.00 14.39           C  
ATOM   1001  CE1 PHE A 127     -14.234  95.727  13.963  1.00 13.53           C  
ATOM   1002  CE2 PHE A 127     -16.569  95.729  13.367  1.00 14.55           C  
ATOM   1003  CZ  PHE A 127     -15.477  95.099  13.965  1.00 15.87           C  
HETATM 1004  N   MSE A 128     -12.840 101.275  10.835  1.00 18.32           N  
HETATM 1005  CA  MSE A 128     -12.728 102.551  10.135  1.00 19.90           C  
HETATM 1006  C   MSE A 128     -12.778 102.463   8.609  1.00 20.27           C  
HETATM 1007  O   MSE A 128     -12.317 101.485   8.023  1.00 20.89           O  
HETATM 1008  CB  MSE A 128     -11.430 103.232  10.577  1.00 20.63           C  
HETATM 1009  CG  MSE A 128     -11.208 104.633  10.044  1.00 20.84           C  
HETATM 1010 SE   MSE A 128      -9.793 105.494  11.045  1.00 35.26          SE  
HETATM 1011  CE  MSE A 128     -10.600 107.233  11.308  1.00 25.02           C  
ATOM   1012  N   GLY A 129     -13.337 103.495   7.976  1.00 19.59           N  
ATOM   1013  CA  GLY A 129     -13.429 103.528   6.523  1.00 22.42           C  
ATOM   1014  C   GLY A 129     -12.090 103.867   5.891  1.00 23.53           C  
ATOM   1015  O   GLY A 129     -11.321 104.637   6.469  1.00 19.84           O  
ATOM   1016  N   ASP A 130     -11.804 103.326   4.707  1.00 19.07           N  
ATOM   1017  CA  ASP A 130     -10.510 103.598   4.084  1.00 25.00           C  
ATOM   1018  C   ASP A 130     -10.288 105.031   3.608  1.00 22.67           C  
ATOM   1019  O   ASP A 130      -9.213 105.362   3.117  1.00 23.78           O  
ATOM   1020  CB  ASP A 130     -10.214 102.596   2.950  1.00 26.83           C  
ATOM   1021  CG  ASP A 130     -11.242 102.625   1.830  1.00 26.90           C  
ATOM   1022  OD1 ASP A 130     -11.105 101.791   0.912  1.00 27.56           O  
ATOM   1023  OD2 ASP A 130     -12.171 103.457   1.852  1.00 32.50           O  
ATOM   1024  N   GLU A 131     -11.295 105.880   3.775  1.00 24.05           N  
ATOM   1025  CA  GLU A 131     -11.186 107.285   3.396  1.00 24.13           C  
ATOM   1026  C   GLU A 131     -11.745 108.138   4.536  1.00 26.46           C  
ATOM   1027  O   GLU A 131     -12.104 109.300   4.342  1.00 25.05           O  
ATOM   1028  CB  GLU A 131     -11.974 107.564   2.109  1.00 32.55           C  
ATOM   1029  CG  GLU A 131     -11.512 106.767   0.897  1.00 37.43           C  
ATOM   1030  CD  GLU A 131     -12.214 107.195  -0.386  1.00 44.58           C  
ATOM   1031  OE1 GLU A 131     -12.021 108.354  -0.813  1.00 41.90           O  
ATOM   1032  OE2 GLU A 131     -12.959 106.376  -0.968  1.00 36.48           O  
ATOM   1033  N   ALA A 132     -11.803 107.545   5.729  1.00 26.51           N  
ATOM   1034  CA  ALA A 132     -12.332 108.206   6.920  1.00 24.22           C  
ATOM   1035  C   ALA A 132     -11.591 109.470   7.341  1.00 19.91           C  
ATOM   1036  O   ALA A 132     -12.132 110.286   8.083  1.00 27.56           O  
ATOM   1037  CB  ALA A 132     -12.369 107.218   8.089  1.00 22.20           C  
ATOM   1038  N   GLY A 133     -10.355 109.633   6.889  1.00 19.89           N  
ATOM   1039  CA  GLY A 133      -9.615 110.830   7.249  1.00 20.97           C  
ATOM   1040  C   GLY A 133      -8.463 110.652   8.216  1.00 20.96           C  
ATOM   1041  O   GLY A 133      -7.627 109.763   8.044  1.00 23.32           O  
ATOM   1042  N   LYS A 134      -8.431 111.504   9.239  1.00 24.78           N  
ATOM   1043  CA  LYS A 134      -7.368 111.504  10.250  1.00 24.97           C  
ATOM   1044  C   LYS A 134      -7.775 110.887  11.580  1.00 24.38           C  
ATOM   1045  O   LYS A 134      -8.922 111.001  12.015  1.00 24.09           O  
ATOM   1046  CB  LYS A 134      -6.909 112.935  10.541  1.00 29.36           C  
ATOM   1047  CG  LYS A 134      -6.572 113.798   9.338  1.00 38.86           C  
ATOM   1048  CD  LYS A 134      -6.281 115.222   9.806  1.00 45.57           C  
ATOM   1049  CE  LYS A 134      -5.960 116.161   8.657  1.00 47.91           C  
ATOM   1050  NZ  LYS A 134      -5.681 117.544   9.147  1.00 46.29           N  
ATOM   1051  N   ILE A 135      -6.815 110.247  12.235  1.00 21.76           N  
ATOM   1052  CA  ILE A 135      -7.058 109.648  13.539  1.00 20.26           C  
ATOM   1053  C   ILE A 135      -5.815 109.889  14.396  1.00 20.31           C  
ATOM   1054  O   ILE A 135      -4.692 109.615  13.969  1.00 22.57           O  
ATOM   1055  CB  ILE A 135      -7.375 108.129  13.412  1.00 18.53           C  
ATOM   1056  CG1 ILE A 135      -7.591 107.519  14.798  1.00 12.39           C  
ATOM   1057  CG2 ILE A 135      -6.262 107.420  12.654  1.00 12.09           C  
ATOM   1058  CD1 ILE A 135      -8.228 106.147  14.758  1.00 11.20           C  
ATOM   1059  N   GLY A 136      -6.022 110.438  15.591  1.00 20.85           N  
ATOM   1060  CA  GLY A 136      -4.918 110.729  16.490  1.00 11.64           C  
ATOM   1061  C   GLY A 136      -5.321 111.598  17.671  1.00 16.30           C  
ATOM   1062  O   GLY A 136      -6.505 111.866  17.882  1.00 15.74           O  
ATOM   1063  N   LEU A 137      -4.331 112.043  18.440  1.00 14.40           N  
ATOM   1064  CA  LEU A 137      -4.566 112.871  19.619  1.00 12.95           C  
ATOM   1065  C   LEU A 137      -3.721 114.150  19.546  1.00 17.59           C  
ATOM   1066  O   LEU A 137      -2.582 114.182  20.014  1.00 20.22           O  
ATOM   1067  CB  LEU A 137      -4.204 112.077  20.875  1.00  8.45           C  
ATOM   1068  CG  LEU A 137      -4.945 110.757  21.134  1.00 12.27           C  
ATOM   1069  CD1 LEU A 137      -4.298 110.030  22.301  1.00  8.89           C  
ATOM   1070  CD2 LEU A 137      -6.412 111.021  21.421  1.00  8.77           C  
ATOM   1071  N   PRO A 138      -4.274 115.224  18.957  1.00 17.22           N  
ATOM   1072  CA  PRO A 138      -3.549 116.490  18.827  1.00 17.05           C  
ATOM   1073  C   PRO A 138      -3.658 117.489  19.984  1.00 18.84           C  
ATOM   1074  O   PRO A 138      -3.252 118.638  19.834  1.00 18.25           O  
ATOM   1075  CB  PRO A 138      -4.110 117.058  17.532  1.00 21.29           C  
ATOM   1076  CG  PRO A 138      -5.549 116.674  17.627  1.00 16.56           C  
ATOM   1077  CD  PRO A 138      -5.499 115.237  18.133  1.00 15.20           C  
ATOM   1078  N   GLU A 139      -4.180 117.057  21.128  1.00 15.10           N  
ATOM   1079  CA  GLU A 139      -4.340 117.944  22.283  1.00 15.66           C  
ATOM   1080  C   GLU A 139      -3.111 118.765  22.668  1.00 19.40           C  
ATOM   1081  O   GLU A 139      -3.236 119.884  23.172  1.00 14.21           O  
ATOM   1082  CB  GLU A 139      -4.799 117.147  23.510  1.00 15.01           C  
ATOM   1083  CG  GLU A 139      -6.237 116.669  23.437  1.00 18.52           C  
ATOM   1084  CD  GLU A 139      -6.388 115.297  22.808  1.00 17.82           C  
ATOM   1085  OE1 GLU A 139      -5.610 114.956  21.889  1.00 18.14           O  
ATOM   1086  OE2 GLU A 139      -7.306 114.564  23.229  1.00 16.67           O  
ATOM   1087  N   VAL A 140      -1.923 118.213  22.449  1.00 14.88           N  
ATOM   1088  CA  VAL A 140      -0.698 118.921  22.798  1.00 19.01           C  
ATOM   1089  C   VAL A 140      -0.578 120.260  22.061  1.00 21.45           C  
ATOM   1090  O   VAL A 140       0.061 121.189  22.556  1.00 21.16           O  
ATOM   1091  CB  VAL A 140       0.557 118.067  22.480  1.00 18.70           C  
ATOM   1092  CG1 VAL A 140       0.737 117.931  20.971  1.00 17.19           C  
ATOM   1093  CG2 VAL A 140       1.784 118.698  23.101  1.00 16.57           C  
ATOM   1094  N   SER A 141      -1.190 120.359  20.883  1.00 17.69           N  
ATOM   1095  CA  SER A 141      -1.118 121.594  20.104  1.00 21.90           C  
ATOM   1096  C   SER A 141      -1.892 122.718  20.779  1.00 23.59           C  
ATOM   1097  O   SER A 141      -1.777 123.877  20.388  1.00 23.12           O  
ATOM   1098  CB  SER A 141      -1.645 121.373  18.678  1.00 15.83           C  
ATOM   1099  OG  SER A 141      -3.027 121.074  18.669  1.00 21.94           O  
ATOM   1100  N   LEU A 142      -2.671 122.368  21.800  1.00 23.20           N  
ATOM   1101  CA  LEU A 142      -3.460 123.343  22.549  1.00 19.80           C  
ATOM   1102  C   LEU A 142      -2.850 123.592  23.929  1.00 19.55           C  
ATOM   1103  O   LEU A 142      -3.359 124.400  24.703  1.00 20.60           O  
ATOM   1104  CB  LEU A 142      -4.894 122.840  22.731  1.00 20.08           C  
ATOM   1105  CG  LEU A 142      -5.718 122.497  21.488  1.00 25.77           C  
ATOM   1106  CD1 LEU A 142      -6.933 121.672  21.909  1.00 26.06           C  
ATOM   1107  CD2 LEU A 142      -6.147 123.767  20.766  1.00 15.79           C  
ATOM   1108  N   GLY A 143      -1.765 122.890  24.238  1.00 18.70           N  
ATOM   1109  CA  GLY A 143      -1.130 123.065  25.531  1.00 18.96           C  
ATOM   1110  C   GLY A 143      -1.675 122.154  26.619  1.00 21.92           C  
ATOM   1111  O   GLY A 143      -1.369 122.345  27.797  1.00 20.92           O  
ATOM   1112  N   VAL A 144      -2.495 121.177  26.234  1.00 16.50           N  
ATOM   1113  CA  VAL A 144      -3.056 120.217  27.185  1.00 17.46           C  
ATOM   1114  C   VAL A 144      -2.796 118.800  26.661  1.00 18.52           C  
ATOM   1115  O   VAL A 144      -2.128 118.627  25.646  1.00 18.96           O  
ATOM   1116  CB  VAL A 144      -4.581 120.413  27.379  1.00 20.08           C  
ATOM   1117  CG1 VAL A 144      -4.862 121.799  27.944  1.00 21.20           C  
ATOM   1118  CG2 VAL A 144      -5.312 120.217  26.057  1.00 18.48           C  
ATOM   1119  N   LEU A 145      -3.313 117.787  27.349  1.00 18.69           N  
ATOM   1120  CA  LEU A 145      -3.102 116.416  26.909  1.00 12.06           C  
ATOM   1121  C   LEU A 145      -4.414 115.667  26.759  1.00 10.45           C  
ATOM   1122  O   LEU A 145      -5.466 116.184  27.112  1.00 10.33           O  
ATOM   1123  CB  LEU A 145      -2.182 115.682  27.888  1.00 10.93           C  
ATOM   1124  CG  LEU A 145      -2.548 115.647  29.375  1.00 11.10           C  
ATOM   1125  CD1 LEU A 145      -3.851 114.892  29.603  1.00 10.89           C  
ATOM   1126  CD2 LEU A 145      -1.404 114.984  30.138  1.00 14.90           C  
ATOM   1127  N   ALA A 146      -4.343 114.454  26.211  1.00 15.24           N  
ATOM   1128  CA  ALA A 146      -5.530 113.619  26.027  1.00 15.67           C  
ATOM   1129  C   ALA A 146      -5.994 113.196  27.420  1.00 17.08           C  
ATOM   1130  O   ALA A 146      -5.685 112.092  27.884  1.00 16.80           O  
ATOM   1131  CB  ALA A 146      -5.177 112.396  25.183  1.00 10.92           C  
ATOM   1132  N   GLY A 147      -6.734 114.088  28.076  1.00 22.35           N  
ATOM   1133  CA  GLY A 147      -7.200 113.849  29.432  1.00 16.79           C  
ATOM   1134  C   GLY A 147      -8.460 113.040  29.660  1.00 17.33           C  
ATOM   1135  O   GLY A 147      -8.949 112.966  30.789  1.00 17.81           O  
ATOM   1136  N   THR A 148      -9.008 112.447  28.612  1.00 14.85           N  
ATOM   1137  CA  THR A 148     -10.192 111.622  28.786  1.00 17.80           C  
ATOM   1138  C   THR A 148      -9.804 110.165  28.522  1.00 18.49           C  
ATOM   1139  O   THR A 148     -10.489 109.445  27.796  1.00 11.30           O  
ATOM   1140  CB  THR A 148     -11.339 112.045  27.834  1.00 20.13           C  
ATOM   1141  OG1 THR A 148     -11.482 113.469  27.856  1.00 22.14           O  
ATOM   1142  CG2 THR A 148     -12.659 111.434  28.299  1.00 14.25           C  
ATOM   1143  N   GLY A 149      -8.683 109.746  29.108  1.00 15.67           N  
ATOM   1144  CA  GLY A 149      -8.219 108.375  28.945  1.00 16.81           C  
ATOM   1145  C   GLY A 149      -7.306 108.120  27.755  1.00 16.51           C  
ATOM   1146  O   GLY A 149      -6.756 107.028  27.611  1.00 15.41           O  
ATOM   1147  N   GLY A 150      -7.126 109.128  26.912  1.00 13.05           N  
ATOM   1148  CA  GLY A 150      -6.288 108.974  25.737  1.00 13.76           C  
ATOM   1149  C   GLY A 150      -4.859 108.502  25.950  1.00 18.05           C  
ATOM   1150  O   GLY A 150      -4.431 107.540  25.305  1.00 17.77           O  
ATOM   1151  N   THR A 151      -4.110 109.163  26.836  1.00 13.62           N  
ATOM   1152  CA  THR A 151      -2.715 108.782  27.077  1.00 14.94           C  
ATOM   1153  C   THR A 151      -2.596 107.353  27.586  1.00 15.85           C  
ATOM   1154  O   THR A 151      -1.694 106.619  27.195  1.00 19.24           O  
ATOM   1155  CB  THR A 151      -2.010 109.710  28.116  1.00 14.41           C  
ATOM   1156  OG1 THR A 151      -2.563 109.495  29.421  1.00 11.29           O  
ATOM   1157  CG2 THR A 151      -2.170 111.179  27.733  1.00  9.88           C  
ATOM   1158  N   GLN A 152      -3.522 106.964  28.453  1.00 14.90           N  
ATOM   1159  CA  GLN A 152      -3.512 105.639  29.043  1.00 12.50           C  
ATOM   1160  C   GLN A 152      -4.006 104.505  28.143  1.00 13.99           C  
ATOM   1161  O   GLN A 152      -3.349 103.469  28.031  1.00 11.98           O  
ATOM   1162  CB  GLN A 152      -4.311 105.668  30.351  1.00 13.02           C  
ATOM   1163  CG  GLN A 152      -3.734 106.638  31.378  1.00 15.04           C  
ATOM   1164  CD  GLN A 152      -2.216 106.492  31.529  1.00 13.58           C  
ATOM   1165  OE1 GLN A 152      -1.459 107.414  31.232  1.00 22.80           O  
ATOM   1166  NE2 GLN A 152      -1.775 105.328  31.987  1.00  9.22           N  
ATOM   1167  N   ARG A 153      -5.157 104.689  27.501  1.00 14.56           N  
ATOM   1168  CA  ARG A 153      -5.685 103.642  26.638  1.00  9.62           C  
ATOM   1169  C   ARG A 153      -4.869 103.480  25.359  1.00 10.73           C  
ATOM   1170  O   ARG A 153      -4.678 102.360  24.881  1.00 13.39           O  
ATOM   1171  CB  ARG A 153      -7.162 103.897  26.307  1.00  6.22           C  
ATOM   1172  CG  ARG A 153      -8.107 103.768  27.515  1.00  9.46           C  
ATOM   1173  CD  ARG A 153      -9.554 103.524  27.072  1.00  9.82           C  
ATOM   1174  NE  ARG A 153     -10.441 103.238  28.199  1.00 13.32           N  
ATOM   1175  CZ  ARG A 153     -10.955 104.161  29.007  1.00 16.86           C  
ATOM   1176  NH1 ARG A 153     -10.683 105.444  28.813  1.00 13.08           N  
ATOM   1177  NH2 ARG A 153     -11.729 103.800  30.024  1.00 11.56           N  
ATOM   1178  N   LEU A 154      -4.374 104.581  24.801  1.00  9.58           N  
ATOM   1179  CA  LEU A 154      -3.565 104.479  23.584  1.00 13.21           C  
ATOM   1180  C   LEU A 154      -2.301 103.668  23.867  1.00 12.32           C  
ATOM   1181  O   LEU A 154      -1.916 102.808  23.078  1.00 11.61           O  
ATOM   1182  CB  LEU A 154      -3.158 105.862  23.057  1.00 14.74           C  
ATOM   1183  CG  LEU A 154      -2.533 105.838  21.651  1.00 18.09           C  
ATOM   1184  CD1 LEU A 154      -3.526 105.232  20.666  1.00 17.85           C  
ATOM   1185  CD2 LEU A 154      -2.160 107.245  21.213  1.00 17.34           C  
ATOM   1186  N   ALA A 155      -1.663 103.949  25.000  1.00 10.18           N  
ATOM   1187  CA  ALA A 155      -0.440 103.252  25.377  1.00 12.22           C  
ATOM   1188  C   ALA A 155      -0.679 101.758  25.541  1.00 11.21           C  
ATOM   1189  O   ALA A 155       0.131 100.946  25.102  1.00 11.97           O  
ATOM   1190  CB  ALA A 155       0.125 103.840  26.674  1.00  7.88           C  
ATOM   1191  N   ARG A 156      -1.790 101.401  26.172  1.00  9.41           N  
ATOM   1192  CA  ARG A 156      -2.124 100.001  26.394  1.00 14.79           C  
ATOM   1193  C   ARG A 156      -2.527  99.304  25.101  1.00 13.76           C  
ATOM   1194  O   ARG A 156      -2.277  98.113  24.927  1.00 18.25           O  
ATOM   1195  CB  ARG A 156      -3.253  99.881  27.430  1.00 10.98           C  
ATOM   1196  CG  ARG A 156      -2.807 100.224  28.862  1.00 15.54           C  
ATOM   1197  CD  ARG A 156      -3.985 100.401  29.822  1.00  7.26           C  
ATOM   1198  NE  ARG A 156      -3.544 100.600  31.204  1.00 16.95           N  
ATOM   1199  CZ  ARG A 156      -2.867 101.660  31.642  1.00 12.84           C  
ATOM   1200  NH1 ARG A 156      -2.545 102.640  30.809  1.00  9.89           N  
ATOM   1201  NH2 ARG A 156      -2.498 101.737  32.914  1.00  4.33           N  
ATOM   1202  N   LEU A 157      -3.139 100.044  24.184  1.00 16.11           N  
ATOM   1203  CA  LEU A 157      -3.569  99.448  22.926  1.00 14.53           C  
ATOM   1204  C   LEU A 157      -2.444  99.268  21.909  1.00 15.17           C  
ATOM   1205  O   LEU A 157      -2.258  98.167  21.388  1.00 16.48           O  
ATOM   1206  CB  LEU A 157      -4.694 100.277  22.292  1.00 12.83           C  
ATOM   1207  CG  LEU A 157      -5.293  99.716  20.994  1.00 13.80           C  
ATOM   1208  CD1 LEU A 157      -5.960  98.372  21.269  1.00 10.49           C  
ATOM   1209  CD2 LEU A 157      -6.308 100.698  20.423  1.00 10.69           C  
ATOM   1210  N   ILE A 158      -1.681 100.325  21.637  1.00 10.19           N  
ATOM   1211  CA  ILE A 158      -0.612 100.229  20.639  1.00 10.33           C  
ATOM   1212  C   ILE A 158       0.825 100.175  21.159  1.00 12.67           C  
ATOM   1213  O   ILE A 158       1.761 100.044  20.364  1.00 10.88           O  
ATOM   1214  CB  ILE A 158      -0.690 101.399  19.617  1.00 11.49           C  
ATOM   1215  CG1 ILE A 158      -0.412 102.733  20.314  1.00 14.65           C  
ATOM   1216  CG2 ILE A 158      -2.052 101.428  18.957  1.00  8.41           C  
ATOM   1217  CD1 ILE A 158      -0.277 103.903  19.348  1.00 11.52           C  
ATOM   1218  N   GLY A 159       1.006 100.276  22.473  1.00 11.75           N  
ATOM   1219  CA  GLY A 159       2.349 100.262  23.034  1.00  9.04           C  
ATOM   1220  C   GLY A 159       2.690 101.630  23.599  1.00 14.15           C  
ATOM   1221  O   GLY A 159       2.405 102.654  22.970  1.00 12.27           O  
ATOM   1222  N   TYR A 160       3.320 101.659  24.772  1.00  8.12           N  
ATOM   1223  CA  TYR A 160       3.647 102.924  25.421  1.00 11.04           C  
ATOM   1224  C   TYR A 160       4.565 103.888  24.664  1.00 13.31           C  
ATOM   1225  O   TYR A 160       4.307 105.090  24.635  1.00 13.21           O  
ATOM   1226  CB  TYR A 160       4.191 102.664  26.837  1.00  8.46           C  
ATOM   1227  CG  TYR A 160       5.444 101.803  26.929  1.00 14.32           C  
ATOM   1228  CD1 TYR A 160       6.713 102.358  26.765  1.00 10.75           C  
ATOM   1229  CD2 TYR A 160       5.357 100.440  27.235  1.00 12.84           C  
ATOM   1230  CE1 TYR A 160       7.867 101.580  26.913  1.00 12.45           C  
ATOM   1231  CE2 TYR A 160       6.506  99.654  27.380  1.00 12.64           C  
ATOM   1232  CZ  TYR A 160       7.758 100.231  27.222  1.00 16.61           C  
ATOM   1233  OH  TYR A 160       8.900  99.466  27.394  1.00 12.98           O  
ATOM   1234  N   SER A 161       5.621 103.379  24.040  1.00 11.77           N  
ATOM   1235  CA  SER A 161       6.533 104.254  23.312  1.00  8.38           C  
ATOM   1236  C   SER A 161       5.857 104.828  22.067  1.00 15.08           C  
ATOM   1237  O   SER A 161       5.987 106.020  21.772  1.00 13.07           O  
ATOM   1238  CB  SER A 161       7.797 103.494  22.918  1.00 12.43           C  
ATOM   1239  OG  SER A 161       8.751 104.366  22.334  1.00 16.69           O  
ATOM   1240  N   ARG A 162       5.139 103.973  21.341  1.00 12.46           N  
ATOM   1241  CA  ARG A 162       4.426 104.399  20.143  1.00 14.59           C  
ATOM   1242  C   ARG A 162       3.354 105.421  20.487  1.00 13.52           C  
ATOM   1243  O   ARG A 162       3.118 106.359  19.735  1.00 14.78           O  
ATOM   1244  CB  ARG A 162       3.787 103.197  19.441  1.00 12.64           C  
ATOM   1245  CG  ARG A 162       4.790 102.379  18.658  1.00 20.38           C  
ATOM   1246  CD  ARG A 162       4.152 101.242  17.894  1.00 23.58           C  
ATOM   1247  NE  ARG A 162       5.108 100.670  16.952  1.00 27.13           N  
ATOM   1248  CZ  ARG A 162       4.873  99.605  16.195  1.00 29.71           C  
ATOM   1249  NH1 ARG A 162       3.705  98.980  16.268  1.00 26.12           N  
ATOM   1250  NH2 ARG A 162       5.808  99.166  15.363  1.00 23.84           N  
ATOM   1251  N   ALA A 163       2.708 105.232  21.631  1.00 12.72           N  
ATOM   1252  CA  ALA A 163       1.673 106.151  22.078  1.00 13.94           C  
ATOM   1253  C   ALA A 163       2.332 107.456  22.526  1.00 13.32           C  
ATOM   1254  O   ALA A 163       1.799 108.543  22.307  1.00 18.23           O  
ATOM   1255  CB  ALA A 163       0.890 105.534  23.232  1.00  6.99           C  
ATOM   1256  N   LEU A 164       3.497 107.343  23.156  1.00  8.36           N  
ATOM   1257  CA  LEU A 164       4.208 108.521  23.633  1.00 11.23           C  
ATOM   1258  C   LEU A 164       4.529 109.400  22.437  1.00 11.97           C  
ATOM   1259  O   LEU A 164       4.284 110.605  22.455  1.00 17.06           O  
ATOM   1260  CB  LEU A 164       5.492 108.102  24.356  1.00 13.88           C  
ATOM   1261  CG  LEU A 164       6.343 109.187  25.020  1.00 17.96           C  
ATOM   1262  CD1 LEU A 164       6.956 108.632  26.305  1.00 20.26           C  
ATOM   1263  CD2 LEU A 164       7.428 109.656  24.062  1.00 18.59           C  
ATOM   1264  N   ASP A 165       5.060 108.778  21.392  1.00 13.27           N  
ATOM   1265  CA  ASP A 165       5.415 109.479  20.165  1.00 12.04           C  
ATOM   1266  C   ASP A 165       4.209 110.224  19.602  1.00 16.18           C  
ATOM   1267  O   ASP A 165       4.281 111.428  19.348  1.00 17.01           O  
ATOM   1268  CB  ASP A 165       5.968 108.464  19.154  1.00 15.49           C  
ATOM   1269  CG  ASP A 165       6.188 109.055  17.774  1.00 21.69           C  
ATOM   1270  OD1 ASP A 165       6.457 110.272  17.657  1.00 20.82           O  
ATOM   1271  OD2 ASP A 165       6.110 108.280  16.797  1.00 23.29           O  
HETATM 1272  N   MSE A 166       3.092 109.523  19.427  1.00 10.78           N  
HETATM 1273  CA  MSE A 166       1.895 110.156  18.882  1.00 15.31           C  
HETATM 1274  C   MSE A 166       1.338 111.287  19.735  1.00 16.76           C  
HETATM 1275  O   MSE A 166       0.894 112.302  19.198  1.00 15.79           O  
HETATM 1276  CB  MSE A 166       0.791 109.119  18.644  1.00 15.65           C  
HETATM 1277  CG  MSE A 166       1.010 108.258  17.411  1.00 18.09           C  
HETATM 1278 SE   MSE A 166      -0.456 107.047  17.088  1.00 32.58          SE  
HETATM 1279  CE  MSE A 166      -1.789 108.302  16.464  1.00 16.68           C  
ATOM   1280  N   ASN A 167       1.357 111.113  21.057  1.00 14.38           N  
ATOM   1281  CA  ASN A 167       0.837 112.124  21.977  1.00 14.06           C  
ATOM   1282  C   ASN A 167       1.687 113.395  22.093  1.00 13.34           C  
ATOM   1283  O   ASN A 167       1.137 114.502  22.124  1.00 16.27           O  
ATOM   1284  CB  ASN A 167       0.649 111.518  23.379  1.00 15.57           C  
ATOM   1285  CG  ASN A 167      -0.683 110.791  23.542  1.00 15.39           C  
ATOM   1286  OD1 ASN A 167      -1.702 111.398  23.881  1.00 18.27           O  
ATOM   1287  ND2 ASN A 167      -0.681 109.488  23.292  1.00 13.82           N  
ATOM   1288  N   ILE A 168       3.010 113.257  22.165  1.00 11.39           N  
ATOM   1289  CA  ILE A 168       3.862 114.437  22.305  1.00 11.08           C  
ATOM   1290  C   ILE A 168       3.994 115.264  21.021  1.00 14.93           C  
ATOM   1291  O   ILE A 168       4.247 116.467  21.088  1.00 13.73           O  
ATOM   1292  CB  ILE A 168       5.283 114.087  22.830  1.00 10.12           C  
ATOM   1293  CG1 ILE A 168       6.024 113.213  21.823  1.00 12.76           C  
ATOM   1294  CG2 ILE A 168       5.185 113.398  24.198  1.00 11.94           C  
ATOM   1295  CD1 ILE A 168       7.455 112.938  22.219  1.00  6.73           C  
ATOM   1296  N   THR A 169       3.828 114.632  19.861  1.00 12.67           N  
ATOM   1297  CA  THR A 169       3.907 115.361  18.592  1.00 19.78           C  
ATOM   1298  C   THR A 169       2.505 115.851  18.220  1.00 17.16           C  
ATOM   1299  O   THR A 169       2.347 116.910  17.627  1.00 16.56           O  
ATOM   1300  CB  THR A 169       4.428 114.475  17.431  1.00 17.58           C  
ATOM   1301  OG1 THR A 169       3.464 113.458  17.134  1.00 20.04           O  
ATOM   1302  CG2 THR A 169       5.756 113.827  17.791  1.00 19.69           C  
ATOM   1303  N   GLY A 170       1.492 115.065  18.578  1.00 21.34           N  
ATOM   1304  CA  GLY A 170       0.116 115.429  18.286  1.00 17.02           C  
ATOM   1305  C   GLY A 170      -0.272 115.130  16.854  1.00 20.59           C  
ATOM   1306  O   GLY A 170      -1.357 115.493  16.398  1.00 21.70           O  
ATOM   1307  N   GLU A 171       0.616 114.459  16.135  1.00 24.72           N  
ATOM   1308  CA  GLU A 171       0.357 114.137  14.742  1.00 26.85           C  
ATOM   1309  C   GLU A 171      -0.645 113.014  14.535  1.00 23.54           C  
ATOM   1310  O   GLU A 171      -0.645 112.014  15.248  1.00 27.70           O  
ATOM   1311  CB  GLU A 171       1.680 113.831  14.032  1.00 34.49           C  
ATOM   1312  CG  GLU A 171       2.398 115.095  13.558  1.00 41.19           C  
ATOM   1313  CD  GLU A 171       3.877 114.889  13.295  1.00 46.19           C  
ATOM   1314  OE1 GLU A 171       4.243 113.872  12.671  1.00 52.49           O  
ATOM   1315  OE2 GLU A 171       4.675 115.758  13.706  1.00 49.43           O  
ATOM   1316  N   THR A 172      -1.510 113.202  13.546  1.00 17.23           N  
ATOM   1317  CA  THR A 172      -2.534 112.227  13.218  1.00 21.11           C  
ATOM   1318  C   THR A 172      -2.056 111.310  12.092  1.00 20.14           C  
ATOM   1319  O   THR A 172      -1.152 111.657  11.332  1.00 20.68           O  
ATOM   1320  CB  THR A 172      -3.836 112.932  12.788  1.00 27.95           C  
ATOM   1321  OG1 THR A 172      -3.593 113.714  11.613  1.00 32.26           O  
ATOM   1322  CG2 THR A 172      -4.326 113.859  13.897  1.00 25.88           C  
ATOM   1323  N   ILE A 173      -2.664 110.134  11.991  1.00 18.08           N  
ATOM   1324  CA  ILE A 173      -2.291 109.177  10.963  1.00 17.74           C  
ATOM   1325  C   ILE A 173      -3.496 108.777  10.115  1.00 16.04           C  
ATOM   1326  O   ILE A 173      -4.606 109.249  10.342  1.00 20.17           O  
ATOM   1327  CB  ILE A 173      -1.660 107.916  11.594  1.00 16.45           C  
ATOM   1328  CG1 ILE A 173      -2.642 107.269  12.573  1.00 14.33           C  
ATOM   1329  CG2 ILE A 173      -0.373 108.292  12.314  1.00 16.59           C  
ATOM   1330  CD1 ILE A 173      -2.122 105.987  13.205  1.00 17.46           C  
ATOM   1331  N   THR A 174      -3.271 107.900   9.144  1.00 17.33           N  
ATOM   1332  CA  THR A 174      -4.333 107.437   8.258  1.00 15.16           C  
ATOM   1333  C   THR A 174      -4.976 106.168   8.799  1.00 22.54           C  
ATOM   1334  O   THR A 174      -4.446 105.532   9.711  1.00 22.26           O  
ATOM   1335  CB  THR A 174      -3.784 107.113   6.849  1.00 17.94           C  
ATOM   1336  OG1 THR A 174      -2.841 106.035   6.941  1.00 15.36           O  
ATOM   1337  CG2 THR A 174      -3.095 108.333   6.241  1.00 14.69           C  
ATOM   1338  N   PRO A 175      -6.138 105.787   8.240  1.00 23.17           N  
ATOM   1339  CA  PRO A 175      -6.844 104.577   8.672  1.00 20.78           C  
ATOM   1340  C   PRO A 175      -5.939 103.363   8.491  1.00 18.77           C  
ATOM   1341  O   PRO A 175      -5.872 102.491   9.360  1.00 13.47           O  
ATOM   1342  CB  PRO A 175      -8.053 104.532   7.739  1.00 24.13           C  
ATOM   1343  CG  PRO A 175      -8.327 105.979   7.480  1.00 25.53           C  
ATOM   1344  CD  PRO A 175      -6.939 106.540   7.259  1.00 22.98           C  
ATOM   1345  N   GLN A 176      -5.245 103.321   7.353  1.00 16.60           N  
ATOM   1346  CA  GLN A 176      -4.331 102.228   7.039  1.00 17.22           C  
ATOM   1347  C   GLN A 176      -3.227 102.120   8.086  1.00 19.91           C  
ATOM   1348  O   GLN A 176      -2.960 101.036   8.604  1.00 25.02           O  
ATOM   1349  CB  GLN A 176      -3.693 102.431   5.658  1.00 23.90           C  
ATOM   1350  CG  GLN A 176      -4.640 102.297   4.461  1.00 26.67           C  
ATOM   1351  CD  GLN A 176      -5.654 103.426   4.363  1.00 27.49           C  
ATOM   1352  OE1 GLN A 176      -5.352 104.578   4.679  1.00 26.32           O  
ATOM   1353  NE2 GLN A 176      -6.857 103.104   3.900  1.00 25.54           N  
ATOM   1354  N   GLU A 177      -2.580 103.242   8.391  1.00 16.42           N  
ATOM   1355  CA  GLU A 177      -1.508 103.252   9.382  1.00 17.13           C  
ATOM   1356  C   GLU A 177      -2.073 102.834  10.732  1.00 20.61           C  
ATOM   1357  O   GLU A 177      -1.418 102.129  11.505  1.00 22.16           O  
ATOM   1358  CB  GLU A 177      -0.883 104.647   9.474  1.00 16.50           C  
ATOM   1359  CG  GLU A 177      -0.319 105.145   8.138  1.00 30.80           C  
ATOM   1360  CD  GLU A 177       0.189 106.578   8.194  1.00 33.58           C  
ATOM   1361  OE1 GLU A 177      -0.511 107.439   8.765  1.00 31.91           O  
ATOM   1362  OE2 GLU A 177       1.284 106.845   7.654  1.00 40.19           O  
ATOM   1363  N   ALA A 178      -3.301 103.262  11.009  1.00 15.58           N  
ATOM   1364  CA  ALA A 178      -3.955 102.917  12.259  1.00 16.69           C  
ATOM   1365  C   ALA A 178      -4.117 101.402  12.341  1.00 17.19           C  
ATOM   1366  O   ALA A 178      -3.911 100.796  13.392  1.00 19.25           O  
ATOM   1367  CB  ALA A 178      -5.318 103.599  12.342  1.00 20.06           C  
ATOM   1368  N   LEU A 179      -4.488 100.791  11.221  1.00 16.15           N  
ATOM   1369  CA  LEU A 179      -4.667  99.346  11.183  1.00 18.02           C  
ATOM   1370  C   LEU A 179      -3.358  98.597  11.455  1.00 19.44           C  
ATOM   1371  O   LEU A 179      -3.338  97.614  12.196  1.00 22.16           O  
ATOM   1372  CB  LEU A 179      -5.230  98.916   9.821  1.00 16.59           C  
ATOM   1373  CG  LEU A 179      -5.494  97.413   9.659  1.00 18.65           C  
ATOM   1374  CD1 LEU A 179      -6.534  96.966  10.684  1.00 10.83           C  
ATOM   1375  CD2 LEU A 179      -5.980  97.120   8.236  1.00 14.54           C  
ATOM   1376  N   GLU A 180      -2.263  99.057  10.864  1.00 19.64           N  
ATOM   1377  CA  GLU A 180      -0.995  98.376  11.065  1.00 23.75           C  
ATOM   1378  C   GLU A 180      -0.451  98.454  12.491  1.00 23.39           C  
ATOM   1379  O   GLU A 180       0.227  97.529  12.934  1.00 21.53           O  
ATOM   1380  CB  GLU A 180       0.043  98.863  10.050  1.00 30.26           C  
ATOM   1381  CG  GLU A 180       0.146 100.360   9.896  1.00 51.01           C  
ATOM   1382  CD  GLU A 180       0.741 100.760   8.555  1.00 59.90           C  
ATOM   1383  OE1 GLU A 180       0.045 100.613   7.525  1.00 63.56           O  
ATOM   1384  OE2 GLU A 180       1.906 101.213   8.527  1.00 63.28           O  
ATOM   1385  N   ILE A 181      -0.754  99.520  13.226  1.00 19.80           N  
ATOM   1386  CA  ILE A 181      -0.254  99.595  14.598  1.00 18.29           C  
ATOM   1387  C   ILE A 181      -1.271  99.065  15.612  1.00 17.81           C  
ATOM   1388  O   ILE A 181      -1.023  99.082  16.820  1.00 18.19           O  
ATOM   1389  CB  ILE A 181       0.150 101.030  14.997  1.00 14.71           C  
ATOM   1390  CG1 ILE A 181      -1.076 101.944  15.013  1.00  5.29           C  
ATOM   1391  CG2 ILE A 181       1.211 101.549  14.042  1.00 17.50           C  
ATOM   1392  CD1 ILE A 181      -0.779 103.344  15.548  1.00 11.91           C  
ATOM   1393  N   GLY A 182      -2.410  98.592  15.116  1.00 15.04           N  
ATOM   1394  CA  GLY A 182      -3.433  98.052  15.995  1.00 14.43           C  
ATOM   1395  C   GLY A 182      -4.371  99.075  16.610  1.00 14.36           C  
ATOM   1396  O   GLY A 182      -5.079  98.764  17.566  1.00 16.11           O  
ATOM   1397  N   LEU A 183      -4.388 100.289  16.069  1.00 12.88           N  
ATOM   1398  CA  LEU A 183      -5.264 101.340  16.589  1.00 13.57           C  
ATOM   1399  C   LEU A 183      -6.729 101.038  16.258  1.00 13.58           C  
ATOM   1400  O   LEU A 183      -7.631 101.401  17.012  1.00 17.38           O  
ATOM   1401  CB  LEU A 183      -4.876 102.697  16.001  1.00 10.69           C  
ATOM   1402  CG  LEU A 183      -4.942 103.914  16.933  1.00 16.55           C  
ATOM   1403  CD1 LEU A 183      -5.085 105.165  16.085  1.00 10.84           C  
ATOM   1404  CD2 LEU A 183      -6.100 103.811  17.901  1.00  9.51           C  
ATOM   1405  N   VAL A 184      -6.963 100.403  15.112  1.00 17.57           N  
ATOM   1406  CA  VAL A 184      -8.315 100.010  14.705  1.00 12.55           C  
ATOM   1407  C   VAL A 184      -8.232  98.523  14.419  1.00 13.44           C  
ATOM   1408  O   VAL A 184      -7.138  98.011  14.170  1.00 14.01           O  
ATOM   1409  CB  VAL A 184      -8.799 100.755  13.423  1.00 13.14           C  
ATOM   1410  CG1 VAL A 184      -8.817 102.255  13.677  1.00  6.51           C  
ATOM   1411  CG2 VAL A 184      -7.904 100.414  12.224  1.00 10.59           C  
ATOM   1412  N   ASN A 185      -9.369  97.830  14.461  1.00 12.86           N  
ATOM   1413  CA  ASN A 185      -9.402  96.387  14.205  1.00 15.14           C  
ATOM   1414  C   ASN A 185      -9.724  96.028  12.758  1.00 18.45           C  
ATOM   1415  O   ASN A 185      -9.416  94.926  12.303  1.00 17.31           O  
ATOM   1416  CB  ASN A 185     -10.433  95.704  15.103  1.00 14.39           C  
ATOM   1417  CG  ASN A 185     -10.245  96.045  16.561  1.00 20.64           C  
ATOM   1418  OD1 ASN A 185     -10.641  97.119  17.016  1.00 17.82           O  
ATOM   1419  ND2 ASN A 185      -9.627  95.133  17.305  1.00 18.03           N  
ATOM   1420  N   ARG A 186     -10.359  96.949  12.046  1.00 14.54           N  
ATOM   1421  CA  ARG A 186     -10.734  96.717  10.655  1.00 16.29           C  
ATOM   1422  C   ARG A 186     -10.757  98.013   9.871  1.00 17.43           C  
ATOM   1423  O   ARG A 186     -11.067  99.073  10.411  1.00 17.63           O  
ATOM   1424  CB  ARG A 186     -12.138  96.115  10.566  1.00 13.72           C  
ATOM   1425  CG  ARG A 186     -12.336  94.780  11.236  1.00 20.63           C  
ATOM   1426  CD  ARG A 186     -12.061  93.634  10.291  1.00 11.82           C  
ATOM   1427  NE  ARG A 186     -12.543  92.379  10.856  1.00 24.10           N  
ATOM   1428  CZ  ARG A 186     -12.057  91.822  11.959  1.00 24.65           C  
ATOM   1429  NH1 ARG A 186     -11.062  92.407  12.620  1.00 23.53           N  
ATOM   1430  NH2 ARG A 186     -12.575  90.691  12.412  1.00 18.09           N  
ATOM   1431  N   VAL A 187     -10.427  97.917   8.591  1.00 19.87           N  
ATOM   1432  CA  VAL A 187     -10.482  99.058   7.690  1.00 20.34           C  
ATOM   1433  C   VAL A 187     -11.333  98.553   6.534  1.00 23.20           C  
ATOM   1434  O   VAL A 187     -10.944  97.617   5.836  1.00 20.74           O  
ATOM   1435  CB  VAL A 187      -9.093  99.478   7.168  1.00 22.13           C  
ATOM   1436  CG1 VAL A 187      -9.253 100.355   5.922  1.00 25.29           C  
ATOM   1437  CG2 VAL A 187      -8.352 100.265   8.246  1.00 16.68           C  
ATOM   1438  N   PHE A 188     -12.507  99.152   6.360  1.00 19.91           N  
ATOM   1439  CA  PHE A 188     -13.427  98.751   5.300  1.00 21.00           C  
ATOM   1440  C   PHE A 188     -13.497  99.797   4.191  1.00 23.31           C  
ATOM   1441  O   PHE A 188     -13.120 100.959   4.391  1.00 23.17           O  
ATOM   1442  CB  PHE A 188     -14.847  98.577   5.852  1.00 21.92           C  
ATOM   1443  CG  PHE A 188     -14.982  97.558   6.954  1.00 23.45           C  
ATOM   1444  CD1 PHE A 188     -14.481  96.266   6.806  1.00 22.31           C  
ATOM   1445  CD2 PHE A 188     -15.691  97.872   8.115  1.00 17.43           C  
ATOM   1446  CE1 PHE A 188     -14.703  95.300   7.790  1.00 24.19           C  
ATOM   1447  CE2 PHE A 188     -15.918  96.914   9.100  1.00 17.97           C  
ATOM   1448  CZ  PHE A 188     -15.421  95.627   8.941  1.00 20.60           C  
ATOM   1449  N   PRO A 189     -13.965  99.394   2.995  1.00 27.13           N  
ATOM   1450  CA  PRO A 189     -14.076 100.360   1.898  1.00 25.25           C  
ATOM   1451  C   PRO A 189     -15.065 101.406   2.414  1.00 21.65           C  
ATOM   1452  O   PRO A 189     -16.131 101.052   2.916  1.00 21.20           O  
ATOM   1453  CB  PRO A 189     -14.663  99.526   0.761  1.00 24.97           C  
ATOM   1454  CG  PRO A 189     -14.100  98.169   1.019  1.00 30.64           C  
ATOM   1455  CD  PRO A 189     -14.242  98.025   2.522  1.00 24.88           C  
ATOM   1456  N   GLN A 190     -14.711 102.681   2.299  1.00 20.20           N  
ATOM   1457  CA  GLN A 190     -15.550 103.769   2.797  1.00 23.92           C  
ATOM   1458  C   GLN A 190     -17.068 103.585   2.699  1.00 28.53           C  
ATOM   1459  O   GLN A 190     -17.766 103.610   3.711  1.00 30.02           O  
ATOM   1460  CB  GLN A 190     -15.159 105.079   2.109  1.00 22.49           C  
ATOM   1461  CG  GLN A 190     -15.687 106.336   2.792  1.00 22.96           C  
ATOM   1462  CD  GLN A 190     -15.128 106.530   4.198  1.00 19.59           C  
ATOM   1463  OE1 GLN A 190     -13.946 106.292   4.447  1.00 21.63           O  
ATOM   1464  NE2 GLN A 190     -15.976 106.982   5.118  1.00 20.75           N  
ATOM   1465  N   ALA A 191     -17.581 103.397   1.488  1.00 30.27           N  
ATOM   1466  CA  ALA A 191     -19.020 103.255   1.291  1.00 29.73           C  
ATOM   1467  C   ALA A 191     -19.638 101.983   1.868  1.00 31.37           C  
ATOM   1468  O   ALA A 191     -20.859 101.838   1.885  1.00 33.23           O  
ATOM   1469  CB  ALA A 191     -19.342 103.357  -0.198  1.00 36.04           C  
ATOM   1470  N   GLU A 192     -18.804 101.067   2.345  1.00 30.23           N  
ATOM   1471  CA  GLU A 192     -19.298  99.814   2.905  1.00 30.88           C  
ATOM   1472  C   GLU A 192     -19.053  99.712   4.410  1.00 28.33           C  
ATOM   1473  O   GLU A 192     -19.376  98.699   5.033  1.00 25.31           O  
ATOM   1474  CB  GLU A 192     -18.612  98.640   2.209  1.00 33.73           C  
ATOM   1475  CG  GLU A 192     -18.815  98.604   0.705  1.00 41.14           C  
ATOM   1476  CD  GLU A 192     -17.830  97.685   0.012  1.00 41.84           C  
ATOM   1477  OE1 GLU A 192     -17.712  96.511   0.431  1.00 35.70           O  
ATOM   1478  OE2 GLU A 192     -17.178  98.139  -0.952  1.00 44.04           O  
ATOM   1479  N   THR A 193     -18.496 100.768   4.994  1.00 28.21           N  
ATOM   1480  CA  THR A 193     -18.174 100.771   6.417  1.00 25.79           C  
ATOM   1481  C   THR A 193     -19.344 100.447   7.337  1.00 26.87           C  
ATOM   1482  O   THR A 193     -19.247  99.544   8.173  1.00 24.84           O  
ATOM   1483  CB  THR A 193     -17.549 102.114   6.825  1.00 26.34           C  
ATOM   1484  OG1 THR A 193     -16.367 102.330   6.047  1.00 19.47           O  
ATOM   1485  CG2 THR A 193     -17.172 102.110   8.300  1.00 24.11           C  
ATOM   1486  N   ARG A 194     -20.447 101.175   7.190  1.00 25.97           N  
ATOM   1487  CA  ARG A 194     -21.621 100.936   8.020  1.00 26.89           C  
ATOM   1488  C   ARG A 194     -22.188  99.552   7.761  1.00 30.83           C  
ATOM   1489  O   ARG A 194     -22.590  98.842   8.684  1.00 26.94           O  
ATOM   1490  CB  ARG A 194     -22.705 101.974   7.735  1.00 28.55           C  
ATOM   1491  CG  ARG A 194     -22.395 103.353   8.249  1.00 26.82           C  
ATOM   1492  CD  ARG A 194     -23.662 104.168   8.362  1.00 25.03           C  
ATOM   1493  NE  ARG A 194     -23.405 105.480   8.943  1.00 25.15           N  
ATOM   1494  CZ  ARG A 194     -24.356 106.319   9.332  1.00 29.41           C  
ATOM   1495  NH1 ARG A 194     -25.635 105.981   9.201  1.00 28.91           N  
ATOM   1496  NH2 ARG A 194     -24.028 107.490   9.860  1.00 30.76           N  
ATOM   1497  N   GLU A 195     -22.218  99.185   6.486  1.00 34.42           N  
ATOM   1498  CA  GLU A 195     -22.732  97.897   6.055  1.00 37.51           C  
ATOM   1499  C   GLU A 195     -21.965  96.747   6.702  1.00 33.64           C  
ATOM   1500  O   GLU A 195     -22.554  95.884   7.349  1.00 35.89           O  
ATOM   1501  CB  GLU A 195     -22.630  97.789   4.533  1.00 49.72           C  
ATOM   1502  CG  GLU A 195     -23.310  96.570   3.934  1.00 70.32           C  
ATOM   1503  CD  GLU A 195     -23.006  96.409   2.455  1.00 83.52           C  
ATOM   1504  OE1 GLU A 195     -22.566  97.393   1.824  1.00 89.84           O  
ATOM   1505  OE2 GLU A 195     -23.217  95.299   1.920  1.00 93.48           O  
ATOM   1506  N   ARG A 196     -20.649  96.739   6.531  1.00 27.49           N  
ATOM   1507  CA  ARG A 196     -19.828  95.673   7.087  1.00 24.42           C  
ATOM   1508  C   ARG A 196     -19.767  95.689   8.616  1.00 22.44           C  
ATOM   1509  O   ARG A 196     -19.641  94.639   9.242  1.00 23.87           O  
ATOM   1510  CB  ARG A 196     -18.430  95.728   6.468  1.00 26.32           C  
ATOM   1511  CG  ARG A 196     -18.472  95.608   4.941  1.00 31.33           C  
ATOM   1512  CD  ARG A 196     -17.101  95.403   4.334  1.00 38.25           C  
ATOM   1513  NE  ARG A 196     -16.466  94.199   4.855  1.00 47.84           N  
ATOM   1514  CZ  ARG A 196     -15.264  93.773   4.486  1.00 50.18           C  
ATOM   1515  NH1 ARG A 196     -14.568  94.453   3.583  1.00 51.22           N  
ATOM   1516  NH2 ARG A 196     -14.752  92.675   5.027  1.00 51.15           N  
ATOM   1517  N   THR A 197     -19.866  96.872   9.218  1.00 16.57           N  
ATOM   1518  CA  THR A 197     -19.861  96.967  10.676  1.00 18.84           C  
ATOM   1519  C   THR A 197     -21.140  96.310  11.190  1.00 20.02           C  
ATOM   1520  O   THR A 197     -21.104  95.501  12.123  1.00 18.67           O  
ATOM   1521  CB  THR A 197     -19.830  98.437  11.161  1.00 17.73           C  
ATOM   1522  OG1 THR A 197     -18.597  99.047  10.763  1.00 20.02           O  
ATOM   1523  CG2 THR A 197     -19.952  98.504  12.683  1.00 15.78           C  
ATOM   1524  N   ARG A 198     -22.271  96.658  10.575  1.00 23.84           N  
ATOM   1525  CA  ARG A 198     -23.566  96.095  10.961  1.00 22.70           C  
ATOM   1526  C   ARG A 198     -23.599  94.590  10.734  1.00 22.31           C  
ATOM   1527  O   ARG A 198     -24.216  93.851  11.501  1.00 25.96           O  
ATOM   1528  CB  ARG A 198     -24.698  96.759  10.169  1.00 22.76           C  
ATOM   1529  CG  ARG A 198     -25.122  98.106  10.726  1.00 25.80           C  
ATOM   1530  CD  ARG A 198     -25.904  98.926   9.718  1.00 24.41           C  
ATOM   1531  NE  ARG A 198     -26.334 100.195  10.295  1.00 23.53           N  
ATOM   1532  CZ  ARG A 198     -26.608 101.287   9.587  1.00 26.41           C  
ATOM   1533  NH1 ARG A 198     -26.495 101.270   8.264  1.00 24.69           N  
ATOM   1534  NH2 ARG A 198     -26.988 102.400  10.203  1.00 23.24           N  
ATOM   1535  N   GLU A 199     -22.933  94.144   9.674  1.00 23.33           N  
ATOM   1536  CA  GLU A 199     -22.875  92.723   9.352  1.00 29.44           C  
ATOM   1537  C   GLU A 199     -22.131  91.977  10.457  1.00 26.54           C  
ATOM   1538  O   GLU A 199     -22.516  90.874  10.839  1.00 26.51           O  
ATOM   1539  CB  GLU A 199     -22.168  92.522   8.010  1.00 35.70           C  
ATOM   1540  CG  GLU A 199     -22.035  91.077   7.577  1.00 55.20           C  
ATOM   1541  CD  GLU A 199     -21.425  90.947   6.193  1.00 67.86           C  
ATOM   1542  OE1 GLU A 199     -22.020  91.482   5.232  1.00 74.12           O  
ATOM   1543  OE2 GLU A 199     -20.352  90.315   6.065  1.00 71.59           O  
ATOM   1544  N   TYR A 200     -21.069  92.593  10.970  1.00 28.07           N  
ATOM   1545  CA  TYR A 200     -20.273  92.000  12.041  1.00 24.15           C  
ATOM   1546  C   TYR A 200     -21.119  91.921  13.301  1.00 20.40           C  
ATOM   1547  O   TYR A 200     -21.159  90.887  13.967  1.00 25.99           O  
ATOM   1548  CB  TYR A 200     -19.023  92.852  12.288  1.00 21.18           C  
ATOM   1549  CG  TYR A 200     -18.065  92.319  13.335  1.00 19.19           C  
ATOM   1550  CD1 TYR A 200     -18.324  92.478  14.698  1.00 16.65           C  
ATOM   1551  CD2 TYR A 200     -16.870  91.700  12.961  1.00 18.64           C  
ATOM   1552  CE1 TYR A 200     -17.409  92.040  15.667  1.00 13.61           C  
ATOM   1553  CE2 TYR A 200     -15.951  91.256  13.920  1.00 17.62           C  
ATOM   1554  CZ  TYR A 200     -16.228  91.434  15.271  1.00 19.85           C  
ATOM   1555  OH  TYR A 200     -15.315  91.029  16.224  1.00 15.25           O  
ATOM   1556  N   ALA A 201     -21.805  93.015  13.617  1.00 24.64           N  
ATOM   1557  CA  ALA A 201     -22.660  93.064  14.797  1.00 22.04           C  
ATOM   1558  C   ALA A 201     -23.790  92.044  14.671  1.00 27.59           C  
ATOM   1559  O   ALA A 201     -24.147  91.381  15.645  1.00 27.27           O  
ATOM   1560  CB  ALA A 201     -23.230  94.466  14.979  1.00 19.21           C  
ATOM   1561  N   ARG A 202     -24.355  91.921  13.472  1.00 29.80           N  
ATOM   1562  CA  ARG A 202     -25.429  90.963  13.249  1.00 29.87           C  
ATOM   1563  C   ARG A 202     -24.983  89.555  13.630  1.00 27.07           C  
ATOM   1564  O   ARG A 202     -25.695  88.851  14.351  1.00 25.96           O  
ATOM   1565  CB  ARG A 202     -25.886  90.981  11.784  1.00 39.19           C  
ATOM   1566  CG  ARG A 202     -26.800  92.149  11.421  1.00 53.97           C  
ATOM   1567  CD  ARG A 202     -27.434  91.955  10.043  1.00 61.84           C  
ATOM   1568  NE  ARG A 202     -26.495  92.167   8.940  1.00 69.86           N  
ATOM   1569  CZ  ARG A 202     -26.193  93.359   8.431  1.00 69.46           C  
ATOM   1570  NH1 ARG A 202     -26.755  94.454   8.924  1.00 71.24           N  
ATOM   1571  NH2 ARG A 202     -25.330  93.457   7.428  1.00 70.92           N  
ATOM   1572  N   LYS A 203     -23.809  89.149  13.152  1.00 23.79           N  
ATOM   1573  CA  LYS A 203     -23.283  87.821  13.459  1.00 29.13           C  
ATOM   1574  C   LYS A 203     -23.145  87.603  14.967  1.00 29.86           C  
ATOM   1575  O   LYS A 203     -23.424  86.515  15.472  1.00 30.55           O  
ATOM   1576  CB  LYS A 203     -21.924  87.599  12.785  1.00 30.44           C  
ATOM   1577  CG  LYS A 203     -21.980  87.388  11.273  1.00 37.03           C  
ATOM   1578  CD  LYS A 203     -20.611  86.970  10.734  1.00 39.69           C  
ATOM   1579  CE  LYS A 203     -20.650  86.640   9.244  1.00 49.35           C  
ATOM   1580  NZ  LYS A 203     -20.934  87.829   8.393  1.00 50.49           N  
ATOM   1581  N   LEU A 204     -22.709  88.633  15.686  1.00 26.44           N  
ATOM   1582  CA  LEU A 204     -22.569  88.517  17.134  1.00 25.88           C  
ATOM   1583  C   LEU A 204     -23.939  88.354  17.776  1.00 24.91           C  
ATOM   1584  O   LEU A 204     -24.154  87.444  18.579  1.00 23.99           O  
ATOM   1585  CB  LEU A 204     -21.880  89.756  17.724  1.00 21.06           C  
ATOM   1586  CG  LEU A 204     -20.387  89.953  17.450  1.00 25.18           C  
ATOM   1587  CD1 LEU A 204     -19.897  91.196  18.181  1.00 23.56           C  
ATOM   1588  CD2 LEU A 204     -19.615  88.725  17.918  1.00 19.85           C  
ATOM   1589  N   ALA A 205     -24.867  89.235  17.410  1.00 24.44           N  
ATOM   1590  CA  ALA A 205     -26.218  89.201  17.959  1.00 27.21           C  
ATOM   1591  C   ALA A 205     -26.936  87.884  17.680  1.00 29.50           C  
ATOM   1592  O   ALA A 205     -27.828  87.483  18.425  1.00 29.20           O  
ATOM   1593  CB  ALA A 205     -27.031  90.361  17.404  1.00 28.65           C  
ATOM   1594  N   ASN A 206     -26.542  87.213  16.603  1.00 35.40           N  
ATOM   1595  CA  ASN A 206     -27.156  85.947  16.223  1.00 35.83           C  
ATOM   1596  C   ASN A 206     -26.464  84.714  16.777  1.00 35.20           C  
ATOM   1597  O   ASN A 206     -26.859  83.593  16.466  1.00 39.48           O  
ATOM   1598  CB  ASN A 206     -27.227  85.835  14.702  1.00 38.46           C  
ATOM   1599  CG  ASN A 206     -28.340  86.664  14.118  1.00 43.17           C  
ATOM   1600  OD1 ASN A 206     -29.514  86.415  14.387  1.00 52.63           O  
ATOM   1601  ND2 ASN A 206     -27.981  87.662  13.319  1.00 46.78           N  
ATOM   1602  N   SER A 207     -25.433  84.909  17.589  1.00 31.37           N  
ATOM   1603  CA  SER A 207     -24.720  83.774  18.162  1.00 29.60           C  
ATOM   1604  C   SER A 207     -25.038  83.633  19.648  1.00 28.63           C  
ATOM   1605  O   SER A 207     -26.052  84.148  20.124  1.00 25.61           O  
ATOM   1606  CB  SER A 207     -23.208  83.937  17.952  1.00 31.62           C  
ATOM   1607  OG  SER A 207     -22.735  85.155  18.504  1.00 26.60           O  
ATOM   1608  N   ALA A 208     -24.183  82.918  20.373  1.00 30.36           N  
ATOM   1609  CA  ALA A 208     -24.374  82.726  21.804  1.00 24.18           C  
ATOM   1610  C   ALA A 208     -23.952  84.023  22.482  1.00 28.66           C  
ATOM   1611  O   ALA A 208     -22.843  84.136  23.007  1.00 30.06           O  
ATOM   1612  CB  ALA A 208     -23.522  81.563  22.295  1.00 26.88           C  
ATOM   1613  N   THR A 209     -24.856  84.996  22.468  1.00 27.23           N  
ATOM   1614  CA  THR A 209     -24.598  86.312  23.031  1.00 24.76           C  
ATOM   1615  C   THR A 209     -24.195  86.354  24.505  1.00 23.75           C  
ATOM   1616  O   THR A 209     -23.537  87.303  24.939  1.00 25.38           O  
ATOM   1617  CB  THR A 209     -25.807  87.246  22.788  1.00 21.01           C  
ATOM   1618  OG1 THR A 209     -26.974  86.713  23.425  1.00 19.02           O  
ATOM   1619  CG2 THR A 209     -26.075  87.370  21.293  1.00 19.42           C  
ATOM   1620  N   TYR A 210     -24.579  85.342  25.276  1.00 23.42           N  
ATOM   1621  CA  TYR A 210     -24.212  85.303  26.691  1.00 20.01           C  
ATOM   1622  C   TYR A 210     -22.718  84.999  26.759  1.00 21.69           C  
ATOM   1623  O   TYR A 210     -21.995  85.535  27.596  1.00 23.56           O  
ATOM   1624  CB  TYR A 210     -25.006  84.217  27.415  1.00 22.31           C  
ATOM   1625  CG  TYR A 210     -24.933  84.252  28.932  1.00 19.37           C  
ATOM   1626  CD1 TYR A 210     -24.356  85.328  29.607  1.00 24.29           C  
ATOM   1627  CD2 TYR A 210     -25.488  83.224  29.693  1.00 23.74           C  
ATOM   1628  CE1 TYR A 210     -24.338  85.378  30.997  1.00 21.90           C  
ATOM   1629  CE2 TYR A 210     -25.478  83.265  31.082  1.00 25.28           C  
ATOM   1630  CZ  TYR A 210     -24.903  84.343  31.728  1.00 28.11           C  
ATOM   1631  OH  TYR A 210     -24.906  84.389  33.101  1.00 30.19           O  
ATOM   1632  N   ALA A 211     -22.265  84.134  25.858  1.00 22.25           N  
ATOM   1633  CA  ALA A 211     -20.859  83.766  25.792  1.00 21.57           C  
ATOM   1634  C   ALA A 211     -20.081  84.974  25.289  1.00 20.49           C  
ATOM   1635  O   ALA A 211     -19.031  85.320  25.830  1.00 25.15           O  
ATOM   1636  CB  ALA A 211     -20.665  82.583  24.845  1.00 13.65           C  
ATOM   1637  N   VAL A 212     -20.607  85.616  24.252  1.00 17.42           N  
ATOM   1638  CA  VAL A 212     -19.963  86.792  23.684  1.00 15.37           C  
ATOM   1639  C   VAL A 212     -19.783  87.845  24.767  1.00 19.62           C  
ATOM   1640  O   VAL A 212     -18.705  88.416  24.928  1.00 19.15           O  
ATOM   1641  CB  VAL A 212     -20.812  87.401  22.547  1.00 15.23           C  
ATOM   1642  CG1 VAL A 212     -20.316  88.802  22.217  1.00 17.52           C  
ATOM   1643  CG2 VAL A 212     -20.729  86.512  21.306  1.00 18.69           C  
ATOM   1644  N   SER A 213     -20.854  88.087  25.512  1.00 16.31           N  
ATOM   1645  CA  SER A 213     -20.848  89.080  26.572  1.00 21.57           C  
ATOM   1646  C   SER A 213     -19.842  88.765  27.682  1.00 22.63           C  
ATOM   1647  O   SER A 213     -19.037  89.621  28.060  1.00 24.71           O  
ATOM   1648  CB  SER A 213     -22.256  89.217  27.152  1.00 15.75           C  
ATOM   1649  OG  SER A 213     -22.287  90.221  28.147  1.00 35.13           O  
ATOM   1650  N   ASN A 214     -19.882  87.542  28.202  1.00 15.41           N  
ATOM   1651  CA  ASN A 214     -18.960  87.153  29.259  1.00 16.31           C  
ATOM   1652  C   ASN A 214     -17.508  87.170  28.771  1.00 17.11           C  
ATOM   1653  O   ASN A 214     -16.596  87.426  29.551  1.00 16.55           O  
ATOM   1654  CB  ASN A 214     -19.344  85.773  29.815  1.00 17.27           C  
ATOM   1655  CG  ASN A 214     -20.430  85.856  30.876  1.00 18.32           C  
ATOM   1656  OD1 ASN A 214     -21.143  86.857  30.972  1.00 18.09           O  
ATOM   1657  ND2 ASN A 214     -20.565  84.801  31.677  1.00 18.78           N  
ATOM   1658  N   ILE A 215     -17.293  86.908  27.484  1.00 22.44           N  
ATOM   1659  CA  ILE A 215     -15.940  86.934  26.923  1.00 20.05           C  
ATOM   1660  C   ILE A 215     -15.404  88.369  26.961  1.00 20.57           C  
ATOM   1661  O   ILE A 215     -14.256  88.610  27.350  1.00 17.03           O  
ATOM   1662  CB  ILE A 215     -15.919  86.453  25.450  1.00 17.37           C  
ATOM   1663  CG1 ILE A 215     -16.111  84.938  25.389  1.00 18.45           C  
ATOM   1664  CG2 ILE A 215     -14.603  86.849  24.788  1.00 15.72           C  
ATOM   1665  CD1 ILE A 215     -16.268  84.402  23.974  1.00 20.10           C  
ATOM   1666  N   LYS A 216     -16.248  89.312  26.544  1.00 15.14           N  
ATOM   1667  CA  LYS A 216     -15.894  90.724  26.525  1.00 15.50           C  
ATOM   1668  C   LYS A 216     -15.564  91.206  27.932  1.00 10.59           C  
ATOM   1669  O   LYS A 216     -14.628  91.972  28.122  1.00  9.40           O  
ATOM   1670  CB  LYS A 216     -17.040  91.548  25.910  1.00 16.50           C  
ATOM   1671  CG  LYS A 216     -16.945  93.066  26.104  1.00 16.19           C  
ATOM   1672  CD  LYS A 216     -17.559  93.489  27.440  1.00 17.21           C  
ATOM   1673  CE  LYS A 216     -17.308  94.956  27.755  1.00 14.29           C  
ATOM   1674  NZ  LYS A 216     -17.981  95.885  26.807  1.00 15.12           N  
ATOM   1675  N   LEU A 217     -16.331  90.756  28.920  1.00 12.64           N  
ATOM   1676  CA  LEU A 217     -16.078  91.139  30.303  1.00 13.08           C  
ATOM   1677  C   LEU A 217     -14.767  90.522  30.792  1.00 17.14           C  
ATOM   1678  O   LEU A 217     -13.967  91.171  31.466  1.00 15.63           O  
ATOM   1679  CB  LEU A 217     -17.220  90.667  31.210  1.00 12.07           C  
ATOM   1680  CG  LEU A 217     -18.582  91.350  31.055  1.00 14.78           C  
ATOM   1681  CD1 LEU A 217     -19.594  90.661  31.955  1.00 11.23           C  
ATOM   1682  CD2 LEU A 217     -18.460  92.830  31.407  1.00 11.33           C  
ATOM   1683  N   ALA A 218     -14.563  89.257  30.452  1.00 13.20           N  
ATOM   1684  CA  ALA A 218     -13.363  88.543  30.859  1.00 18.23           C  
ATOM   1685  C   ALA A 218     -12.085  89.246  30.419  1.00 15.10           C  
ATOM   1686  O   ALA A 218     -11.147  89.401  31.204  1.00 14.27           O  
ATOM   1687  CB  ALA A 218     -13.393  87.120  30.300  1.00 13.87           C  
ATOM   1688  N   ILE A 219     -12.052  89.683  29.168  1.00 15.10           N  
ATOM   1689  CA  ILE A 219     -10.864  90.333  28.625  1.00 15.23           C  
ATOM   1690  C   ILE A 219     -10.661  91.792  29.033  1.00 16.41           C  
ATOM   1691  O   ILE A 219      -9.566  92.174  29.441  1.00 18.38           O  
ATOM   1692  CB  ILE A 219     -10.859  90.240  27.087  1.00 21.81           C  
ATOM   1693  CG1 ILE A 219     -10.858  88.767  26.661  1.00 18.17           C  
ATOM   1694  CG2 ILE A 219      -9.643  90.969  26.517  1.00 16.16           C  
ATOM   1695  CD1 ILE A 219     -11.001  88.566  25.163  1.00 21.92           C  
HETATM 1696  N   MSE A 220     -11.705  92.604  28.933  1.00 14.47           N  
HETATM 1697  CA  MSE A 220     -11.577  94.017  29.273  1.00 20.28           C  
HETATM 1698  C   MSE A 220     -11.262  94.282  30.745  1.00 17.51           C  
HETATM 1699  O   MSE A 220     -10.513  95.200  31.065  1.00 19.69           O  
HETATM 1700  CB  MSE A 220     -12.840  94.778  28.858  1.00 16.34           C  
HETATM 1701  CG  MSE A 220     -13.112  94.735  27.355  1.00 19.36           C  
HETATM 1702 SE   MSE A 220     -11.539  95.161  26.290  1.00 30.34          SE  
HETATM 1703  CE  MSE A 220     -11.106  96.873  27.093  1.00 19.42           C  
ATOM   1704  N   ASN A 221     -11.831  93.478  31.636  1.00 14.66           N  
ATOM   1705  CA  ASN A 221     -11.588  93.652  33.064  1.00 14.30           C  
ATOM   1706  C   ASN A 221     -10.483  92.723  33.557  1.00 12.79           C  
ATOM   1707  O   ASN A 221      -9.816  93.013  34.548  1.00 15.30           O  
ATOM   1708  CB  ASN A 221     -12.882  93.403  33.846  1.00 15.06           C  
ATOM   1709  CG  ASN A 221     -13.976  94.404  33.492  1.00 21.16           C  
ATOM   1710  OD1 ASN A 221     -13.873  95.598  33.800  1.00 18.16           O  
ATOM   1711  ND2 ASN A 221     -15.026  93.925  32.835  1.00 19.67           N  
ATOM   1712  N   GLY A 222     -10.285  91.609  32.858  1.00  9.68           N  
ATOM   1713  CA  GLY A 222      -9.247  90.674  33.254  1.00  9.60           C  
ATOM   1714  C   GLY A 222      -7.851  91.169  32.919  1.00 12.82           C  
ATOM   1715  O   GLY A 222      -6.871  90.753  33.536  1.00 11.35           O  
ATOM   1716  N   LYS A 223      -7.746  92.072  31.949  1.00 12.30           N  
ATOM   1717  CA  LYS A 223      -6.435  92.576  31.569  1.00 14.82           C  
ATOM   1718  C   LYS A 223      -5.822  93.460  32.649  1.00  9.26           C  
ATOM   1719  O   LYS A 223      -4.636  93.748  32.609  1.00 19.02           O  
ATOM   1720  CB  LYS A 223      -6.508  93.328  30.231  1.00 18.26           C  
ATOM   1721  CG  LYS A 223      -7.267  94.638  30.235  1.00 17.67           C  
ATOM   1722  CD  LYS A 223      -7.258  95.244  28.833  1.00 16.58           C  
ATOM   1723  CE  LYS A 223      -7.754  96.672  28.839  1.00 14.70           C  
ATOM   1724  NZ  LYS A 223      -6.799  97.560  29.559  1.00 17.16           N  
ATOM   1725  N   GLU A 224      -6.632  93.871  33.619  1.00 15.74           N  
ATOM   1726  CA  GLU A 224      -6.169  94.716  34.720  1.00 12.68           C  
ATOM   1727  C   GLU A 224      -5.682  93.893  35.905  1.00 16.51           C  
ATOM   1728  O   GLU A 224      -5.159  94.449  36.874  1.00 18.57           O  
ATOM   1729  CB  GLU A 224      -7.297  95.622  35.218  1.00 15.84           C  
ATOM   1730  CG  GLU A 224      -7.916  96.521  34.169  1.00 15.52           C  
ATOM   1731  CD  GLU A 224      -6.904  97.428  33.516  1.00 20.62           C  
ATOM   1732  OE1 GLU A 224      -6.015  97.945  34.228  1.00 26.09           O  
ATOM   1733  OE2 GLU A 224      -7.004  97.639  32.290  1.00 19.85           O  
HETATM 1734  N   MSE A 225      -5.855  92.576  35.833  1.00 12.53           N  
HETATM 1735  CA  MSE A 225      -5.466  91.689  36.931  1.00 13.86           C  
HETATM 1736  C   MSE A 225      -4.218  90.852  36.655  1.00 12.55           C  
HETATM 1737  O   MSE A 225      -3.824  90.659  35.505  1.00 16.03           O  
HETATM 1738  CB  MSE A 225      -6.613  90.715  37.245  1.00 13.09           C  
HETATM 1739  CG  MSE A 225      -8.022  91.300  37.185  1.00 15.17           C  
HETATM 1740 SE   MSE A 225      -9.367  89.886  37.223  1.00 29.55          SE  
HETATM 1741  CE  MSE A 225     -10.981  90.945  37.335  1.00 16.28           C  
ATOM   1742  N   PRO A 226      -3.564  90.364  37.721  1.00 17.70           N  
ATOM   1743  CA  PRO A 226      -2.371  89.529  37.539  1.00 15.17           C  
ATOM   1744  C   PRO A 226      -2.889  88.244  36.892  1.00 15.02           C  
ATOM   1745  O   PRO A 226      -4.020  87.833  37.161  1.00 12.55           O  
ATOM   1746  CB  PRO A 226      -1.894  89.303  38.969  1.00 14.02           C  
ATOM   1747  CG  PRO A 226      -2.283  90.585  39.644  1.00 14.57           C  
ATOM   1748  CD  PRO A 226      -3.674  90.822  39.120  1.00 13.31           C  
ATOM   1749  N   LEU A 227      -2.078  87.608  36.054  1.00  9.28           N  
ATOM   1750  CA  LEU A 227      -2.512  86.404  35.357  1.00 13.28           C  
ATOM   1751  C   LEU A 227      -3.117  85.297  36.225  1.00 14.26           C  
ATOM   1752  O   LEU A 227      -4.187  84.783  35.910  1.00 16.18           O  
ATOM   1753  CB  LEU A 227      -1.353  85.822  34.543  1.00 12.39           C  
ATOM   1754  CG  LEU A 227      -1.736  84.672  33.599  1.00 12.57           C  
ATOM   1755  CD1 LEU A 227      -2.755  85.167  32.576  1.00 13.16           C  
ATOM   1756  CD2 LEU A 227      -0.491  84.139  32.894  1.00 13.69           C  
ATOM   1757  N   ASN A 228      -2.441  84.930  37.309  1.00 18.26           N  
ATOM   1758  CA  ASN A 228      -2.920  83.858  38.172  1.00 15.55           C  
ATOM   1759  C   ASN A 228      -4.330  84.057  38.730  1.00 21.12           C  
ATOM   1760  O   ASN A 228      -5.039  83.078  38.973  1.00 27.45           O  
ATOM   1761  CB  ASN A 228      -1.932  83.605  39.320  1.00 14.43           C  
ATOM   1762  CG  ASN A 228      -2.139  82.239  39.974  1.00 21.87           C  
ATOM   1763  OD1 ASN A 228      -2.351  82.143  41.180  1.00 19.95           O  
ATOM   1764  ND2 ASN A 228      -2.082  81.180  39.170  1.00 14.70           N  
ATOM   1765  N   VAL A 229      -4.748  85.302  38.946  1.00 17.00           N  
ATOM   1766  CA  VAL A 229      -6.104  85.535  39.442  1.00 15.55           C  
ATOM   1767  C   VAL A 229      -7.042  85.935  38.308  1.00 16.52           C  
ATOM   1768  O   VAL A 229      -8.266  85.819  38.432  1.00 14.30           O  
ATOM   1769  CB  VAL A 229      -6.153  86.616  40.555  1.00 15.95           C  
ATOM   1770  CG1 VAL A 229      -5.554  86.051  41.840  1.00 21.86           C  
ATOM   1771  CG2 VAL A 229      -5.410  87.866  40.117  1.00 13.57           C  
ATOM   1772  N   ALA A 230      -6.466  86.406  37.202  1.00 13.17           N  
ATOM   1773  CA  ALA A 230      -7.261  86.802  36.040  1.00 11.67           C  
ATOM   1774  C   ALA A 230      -8.005  85.577  35.524  1.00 13.13           C  
ATOM   1775  O   ALA A 230      -9.163  85.652  35.107  1.00 11.00           O  
ATOM   1776  CB  ALA A 230      -6.356  87.353  34.945  1.00  6.77           C  
ATOM   1777  N   ILE A 231      -7.322  84.441  35.547  1.00 14.55           N  
ATOM   1778  CA  ILE A 231      -7.923  83.210  35.083  1.00 14.63           C  
ATOM   1779  C   ILE A 231      -9.024  82.770  36.057  1.00 17.14           C  
ATOM   1780  O   ILE A 231      -9.932  82.038  35.679  1.00 15.50           O  
ATOM   1781  CB  ILE A 231      -6.841  82.131  34.895  1.00 19.47           C  
ATOM   1782  CG1 ILE A 231      -5.839  82.618  33.832  1.00 15.09           C  
ATOM   1783  CG2 ILE A 231      -7.479  80.808  34.467  1.00 16.86           C  
ATOM   1784  CD1 ILE A 231      -4.644  81.717  33.609  1.00 14.07           C  
ATOM   1785  N   ARG A 232      -8.956  83.230  37.304  1.00 12.96           N  
ATOM   1786  CA  ARG A 232      -9.999  82.890  38.271  1.00 16.49           C  
ATOM   1787  C   ARG A 232     -11.267  83.659  37.871  1.00 19.08           C  
ATOM   1788  O   ARG A 232     -12.376  83.131  37.937  1.00 21.07           O  
ATOM   1789  CB  ARG A 232      -9.591  83.298  39.693  1.00 15.58           C  
ATOM   1790  CG  ARG A 232      -8.329  82.635  40.242  1.00 21.14           C  
ATOM   1791  CD  ARG A 232      -8.540  81.163  40.572  1.00 25.19           C  
ATOM   1792  NE  ARG A 232      -8.539  80.318  39.381  1.00 22.08           N  
ATOM   1793  CZ  ARG A 232      -7.461  80.058  38.653  1.00 22.56           C  
ATOM   1794  NH1 ARG A 232      -7.553  79.277  37.581  1.00 19.24           N  
ATOM   1795  NH2 ARG A 232      -6.291  80.574  39.000  1.00 17.58           N  
ATOM   1796  N   TYR A 233     -11.092  84.914  37.463  1.00 16.09           N  
ATOM   1797  CA  TYR A 233     -12.211  85.763  37.049  1.00 16.07           C  
ATOM   1798  C   TYR A 233     -12.835  85.145  35.799  1.00 16.03           C  
ATOM   1799  O   TYR A 233     -14.058  85.097  35.643  1.00 14.93           O  
ATOM   1800  CB  TYR A 233     -11.691  87.178  36.765  1.00 12.50           C  
ATOM   1801  CG  TYR A 233     -12.689  88.145  36.158  1.00 14.06           C  
ATOM   1802  CD1 TYR A 233     -13.868  88.488  36.825  1.00 20.42           C  
ATOM   1803  CD2 TYR A 233     -12.428  88.753  34.931  1.00 14.02           C  
ATOM   1804  CE1 TYR A 233     -14.760  89.418  36.282  1.00  9.21           C  
ATOM   1805  CE2 TYR A 233     -13.306  89.676  34.384  1.00 12.76           C  
ATOM   1806  CZ  TYR A 233     -14.466  90.006  35.061  1.00 16.95           C  
ATOM   1807  OH  TYR A 233     -15.325  90.927  34.507  1.00 18.01           O  
ATOM   1808  N   GLU A 234     -11.971  84.660  34.917  1.00 21.13           N  
ATOM   1809  CA  GLU A 234     -12.391  84.015  33.682  1.00 18.14           C  
ATOM   1810  C   GLU A 234     -13.130  82.725  34.013  1.00 20.77           C  
ATOM   1811  O   GLU A 234     -14.077  82.346  33.323  1.00 21.66           O  
ATOM   1812  CB  GLU A 234     -11.163  83.707  32.829  1.00 20.02           C  
ATOM   1813  CG  GLU A 234     -11.341  82.583  31.817  1.00 27.17           C  
ATOM   1814  CD  GLU A 234     -10.017  82.155  31.203  1.00 28.96           C  
ATOM   1815  OE1 GLU A 234      -9.461  82.922  30.385  1.00 22.85           O  
ATOM   1816  OE2 GLU A 234      -9.528  81.057  31.556  1.00 26.66           O  
ATOM   1817  N   GLY A 235     -12.693  82.059  35.077  1.00 24.00           N  
ATOM   1818  CA  GLY A 235     -13.310  80.808  35.483  1.00 19.86           C  
ATOM   1819  C   GLY A 235     -14.712  80.977  36.031  1.00 21.48           C  
ATOM   1820  O   GLY A 235     -15.546  80.088  35.876  1.00 22.46           O  
ATOM   1821  N   GLU A 236     -14.970  82.105  36.687  1.00 20.70           N  
ATOM   1822  CA  GLU A 236     -16.292  82.363  37.243  1.00 19.43           C  
ATOM   1823  C   GLU A 236     -17.246  82.725  36.113  1.00 23.14           C  
ATOM   1824  O   GLU A 236     -18.423  82.355  36.138  1.00 17.85           O  
ATOM   1825  CB  GLU A 236     -16.241  83.497  38.271  1.00 25.84           C  
ATOM   1826  CG  GLU A 236     -15.408  83.183  39.505  1.00 28.71           C  
ATOM   1827  CD  GLU A 236     -15.678  81.788  40.064  1.00 37.50           C  
ATOM   1828  OE1 GLU A 236     -16.862  81.429  40.260  1.00 30.22           O  
ATOM   1829  OE2 GLU A 236     -14.698  81.052  40.310  1.00 35.79           O  
ATOM   1830  N   LEU A 237     -16.735  83.452  35.122  1.00 18.96           N  
ATOM   1831  CA  LEU A 237     -17.541  83.833  33.973  1.00 22.70           C  
ATOM   1832  C   LEU A 237     -17.895  82.561  33.206  1.00 26.17           C  
ATOM   1833  O   LEU A 237     -19.003  82.431  32.677  1.00 24.89           O  
ATOM   1834  CB  LEU A 237     -16.769  84.802  33.077  1.00 17.98           C  
ATOM   1835  CG  LEU A 237     -16.672  86.240  33.600  1.00 23.11           C  
ATOM   1836  CD1 LEU A 237     -15.476  86.940  32.983  1.00 23.86           C  
ATOM   1837  CD2 LEU A 237     -17.967  86.989  33.292  1.00 19.55           C  
ATOM   1838  N   GLN A 238     -16.951  81.623  33.159  1.00 24.76           N  
ATOM   1839  CA  GLN A 238     -17.168  80.350  32.479  1.00 25.02           C  
ATOM   1840  C   GLN A 238     -18.180  79.524  33.274  1.00 24.62           C  
ATOM   1841  O   GLN A 238     -18.993  78.802  32.700  1.00 24.15           O  
ATOM   1842  CB  GLN A 238     -15.858  79.572  32.361  1.00 23.46           C  
ATOM   1843  CG  GLN A 238     -15.990  78.208  31.675  1.00 22.96           C  
ATOM   1844  CD  GLN A 238     -16.048  78.308  30.162  1.00 23.92           C  
ATOM   1845  OE1 GLN A 238     -16.929  78.960  29.603  1.00 22.97           O  
ATOM   1846  NE2 GLN A 238     -15.103  77.655  29.490  1.00 20.02           N  
ATOM   1847  N   ASN A 239     -18.122  79.628  34.599  1.00 21.61           N  
ATOM   1848  CA  ASN A 239     -19.057  78.898  35.445  1.00 25.13           C  
ATOM   1849  C   ASN A 239     -20.473  79.327  35.074  1.00 29.02           C  
ATOM   1850  O   ASN A 239     -21.360  78.495  34.908  1.00 27.33           O  
ATOM   1851  CB  ASN A 239     -18.789  79.190  36.924  1.00 19.92           C  
ATOM   1852  CG  ASN A 239     -17.674  78.332  37.500  1.00 21.77           C  
ATOM   1853  OD1 ASN A 239     -17.106  78.655  38.544  1.00 20.83           O  
ATOM   1854  ND2 ASN A 239     -17.366  77.230  36.830  1.00 16.59           N  
ATOM   1855  N   LEU A 240     -20.679  80.633  34.935  1.00 25.67           N  
ATOM   1856  CA  LEU A 240     -21.988  81.157  34.569  1.00 26.60           C  
ATOM   1857  C   LEU A 240     -22.427  80.598  33.218  1.00 27.75           C  
ATOM   1858  O   LEU A 240     -23.605  80.302  33.014  1.00 25.94           O  
ATOM   1859  CB  LEU A 240     -21.947  82.687  34.519  1.00 21.23           C  
ATOM   1860  CG  LEU A 240     -21.953  83.349  35.897  1.00 15.64           C  
ATOM   1861  CD1 LEU A 240     -21.396  84.755  35.820  1.00 18.04           C  
ATOM   1862  CD2 LEU A 240     -23.378  83.355  36.423  1.00 14.96           C  
ATOM   1863  N   LEU A 241     -21.475  80.446  32.303  1.00 25.29           N  
ATOM   1864  CA  LEU A 241     -21.770  79.919  30.974  1.00 25.28           C  
ATOM   1865  C   LEU A 241     -22.095  78.427  31.005  1.00 28.97           C  
ATOM   1866  O   LEU A 241     -22.932  77.962  30.234  1.00 33.14           O  
ATOM   1867  CB  LEU A 241     -20.593  80.185  30.029  1.00 22.59           C  
ATOM   1868  CG  LEU A 241     -20.674  81.401  29.093  1.00 23.33           C  
ATOM   1869  CD1 LEU A 241     -21.506  82.522  29.701  1.00 22.33           C  
ATOM   1870  CD2 LEU A 241     -19.268  81.870  28.780  1.00 14.22           C  
ATOM   1871  N   PHE A 242     -21.439  77.678  31.889  1.00 27.23           N  
ATOM   1872  CA  PHE A 242     -21.702  76.246  31.993  1.00 27.97           C  
ATOM   1873  C   PHE A 242     -23.098  76.026  32.540  1.00 28.34           C  
ATOM   1874  O   PHE A 242     -23.699  74.979  32.311  1.00 29.98           O  
ATOM   1875  CB  PHE A 242     -20.702  75.542  32.921  1.00 27.08           C  
ATOM   1876  CG  PHE A 242     -19.377  75.236  32.279  1.00 30.06           C  
ATOM   1877  CD1 PHE A 242     -19.304  74.849  30.945  1.00 32.65           C  
ATOM   1878  CD2 PHE A 242     -18.205  75.297  33.021  1.00 25.92           C  
ATOM   1879  CE1 PHE A 242     -18.082  74.531  30.360  1.00 27.72           C  
ATOM   1880  CE2 PHE A 242     -16.978  74.980  32.446  1.00 25.96           C  
ATOM   1881  CZ  PHE A 242     -16.919  74.595  31.113  1.00 26.84           C  
ATOM   1882  N   ARG A 243     -23.609  77.013  33.270  1.00 27.43           N  
ATOM   1883  CA  ARG A 243     -24.942  76.913  33.850  1.00 29.52           C  
ATOM   1884  C   ARG A 243     -26.040  77.530  32.986  1.00 31.06           C  
ATOM   1885  O   ARG A 243     -27.206  77.520  33.376  1.00 34.74           O  
ATOM   1886  CB  ARG A 243     -24.982  77.565  35.237  1.00 30.09           C  
ATOM   1887  CG  ARG A 243     -24.357  76.749  36.365  1.00 30.60           C  
ATOM   1888  CD  ARG A 243     -22.843  76.858  36.377  1.00 41.18           C  
ATOM   1889  NE  ARG A 243     -22.232  76.115  37.476  1.00 38.11           N  
ATOM   1890  CZ  ARG A 243     -22.563  76.263  38.753  1.00 33.66           C  
ATOM   1891  NH1 ARG A 243     -23.506  77.127  39.102  1.00 35.51           N  
ATOM   1892  NH2 ARG A 243     -21.956  75.539  39.682  1.00 38.30           N  
ATOM   1893  N   SER A 244     -25.682  78.063  31.821  1.00 29.46           N  
ATOM   1894  CA  SER A 244     -26.682  78.683  30.955  1.00 30.95           C  
ATOM   1895  C   SER A 244     -27.346  77.670  30.032  1.00 35.37           C  
ATOM   1896  O   SER A 244     -26.887  76.534  29.900  1.00 35.08           O  
ATOM   1897  CB  SER A 244     -26.055  79.799  30.110  1.00 28.76           C  
ATOM   1898  OG  SER A 244     -25.252  79.276  29.060  1.00 25.55           O  
ATOM   1899  N   GLU A 245     -28.427  78.097  29.386  1.00 39.00           N  
ATOM   1900  CA  GLU A 245     -29.161  77.233  28.474  1.00 40.79           C  
ATOM   1901  C   GLU A 245     -28.460  77.140  27.127  1.00 39.38           C  
ATOM   1902  O   GLU A 245     -28.466  76.089  26.485  1.00 42.10           O  
ATOM   1903  CB  GLU A 245     -30.587  77.759  28.295  1.00 47.21           C  
ATOM   1904  CG  GLU A 245     -31.417  77.675  29.565  1.00 61.11           C  
ATOM   1905  CD  GLU A 245     -32.774  78.331  29.426  1.00 69.49           C  
ATOM   1906  OE1 GLU A 245     -33.513  77.981  28.481  1.00 75.19           O  
ATOM   1907  OE2 GLU A 245     -33.104  79.193  30.268  1.00 72.18           O  
ATOM   1908  N   ASP A 246     -27.848  78.236  26.698  1.00 34.07           N  
ATOM   1909  CA  ASP A 246     -27.147  78.246  25.423  1.00 33.66           C  
ATOM   1910  C   ASP A 246     -26.007  77.239  25.413  1.00 31.43           C  
ATOM   1911  O   ASP A 246     -25.715  76.639  24.382  1.00 30.02           O  
ATOM   1912  CB  ASP A 246     -26.615  79.649  25.125  1.00 39.50           C  
ATOM   1913  CG  ASP A 246     -27.696  80.579  24.613  1.00 40.68           C  
ATOM   1914  OD1 ASP A 246     -28.861  80.423  25.035  1.00 43.12           O  
ATOM   1915  OD2 ASP A 246     -27.379  81.470  23.799  1.00 43.75           O  
ATOM   1916  N   ALA A 247     -25.363  77.057  26.564  1.00 31.88           N  
ATOM   1917  CA  ALA A 247     -24.258  76.108  26.682  1.00 32.05           C  
ATOM   1918  C   ALA A 247     -24.800  74.707  26.442  1.00 30.40           C  
ATOM   1919  O   ALA A 247     -24.245  73.933  25.660  1.00 31.64           O  
ATOM   1920  CB  ALA A 247     -23.631  76.197  28.072  1.00 25.33           C  
ATOM   1921  N   LYS A 248     -25.891  74.388  27.131  1.00 35.67           N  
ATOM   1922  CA  LYS A 248     -26.544  73.094  26.987  1.00 36.29           C  
ATOM   1923  C   LYS A 248     -26.852  72.921  25.504  1.00 36.72           C  
ATOM   1924  O   LYS A 248     -26.432  71.952  24.873  1.00 33.71           O  
ATOM   1925  CB  LYS A 248     -27.845  73.076  27.793  1.00 42.79           C  
ATOM   1926  CG  LYS A 248     -27.666  73.160  29.305  1.00 55.84           C  
ATOM   1927  CD  LYS A 248     -28.961  73.604  29.986  1.00 69.34           C  
ATOM   1928  CE  LYS A 248     -28.996  73.238  31.471  1.00 74.62           C  
ATOM   1929  NZ  LYS A 248     -27.844  73.771  32.253  1.00 74.33           N  
ATOM   1930  N   GLU A 249     -27.577  73.892  24.959  1.00 34.79           N  
ATOM   1931  CA  GLU A 249     -27.964  73.898  23.554  1.00 38.27           C  
ATOM   1932  C   GLU A 249     -26.764  73.800  22.618  1.00 39.90           C  
ATOM   1933  O   GLU A 249     -26.773  73.025  21.664  1.00 43.77           O  
ATOM   1934  CB  GLU A 249     -28.748  75.180  23.252  1.00 38.09           C  
ATOM   1935  CG  GLU A 249     -29.155  75.360  21.797  1.00 41.94           C  
ATOM   1936  CD  GLU A 249     -30.036  74.235  21.288  1.00 48.79           C  
ATOM   1937  OE1 GLU A 249     -30.986  73.850  22.005  1.00 53.53           O  
ATOM   1938  OE2 GLU A 249     -29.787  73.745  20.167  1.00 44.13           O  
ATOM   1939  N   GLY A 250     -25.732  74.592  22.899  1.00 44.01           N  
ATOM   1940  CA  GLY A 250     -24.542  74.597  22.067  1.00 37.93           C  
ATOM   1941  C   GLY A 250     -23.823  73.265  22.000  1.00 42.15           C  
ATOM   1942  O   GLY A 250     -23.373  72.853  20.934  1.00 42.30           O  
ATOM   1943  N   LEU A 251     -23.704  72.590  23.138  1.00 46.89           N  
ATOM   1944  CA  LEU A 251     -23.028  71.300  23.174  1.00 51.60           C  
ATOM   1945  C   LEU A 251     -23.858  70.214  22.491  1.00 53.32           C  
ATOM   1946  O   LEU A 251     -23.314  69.358  21.794  1.00 53.30           O  
ATOM   1947  CB  LEU A 251     -22.708  70.907  24.622  1.00 55.51           C  
ATOM   1948  CG  LEU A 251     -21.454  71.549  25.242  1.00 60.56           C  
ATOM   1949  CD1 LEU A 251     -21.537  73.066  25.165  1.00 56.98           C  
ATOM   1950  CD2 LEU A 251     -21.306  71.098  26.688  1.00 61.74           C  
ATOM   1951  N   SER A 252     -25.174  70.257  22.680  1.00 54.22           N  
ATOM   1952  CA  SER A 252     -26.061  69.275  22.060  1.00 54.50           C  
ATOM   1953  C   SER A 252     -26.017  69.402  20.545  1.00 54.67           C  
ATOM   1954  O   SER A 252     -25.769  68.427  19.836  1.00 54.48           O  
ATOM   1955  CB  SER A 252     -27.503  69.470  22.535  1.00 53.78           C  
ATOM   1956  OG  SER A 252     -27.647  69.130  23.902  1.00 59.33           O  
ATOM   1957  N   ALA A 253     -26.262  70.613  20.057  1.00 53.75           N  
ATOM   1958  CA  ALA A 253     -26.258  70.880  18.626  1.00 52.72           C  
ATOM   1959  C   ALA A 253     -24.974  70.389  17.966  1.00 53.29           C  
ATOM   1960  O   ALA A 253     -24.998  69.893  16.844  1.00 55.01           O  
ATOM   1961  CB  ALA A 253     -26.437  72.371  18.378  1.00 49.07           C  
ATOM   1962  N   PHE A 254     -23.856  70.522  18.669  1.00 57.28           N  
ATOM   1963  CA  PHE A 254     -22.575  70.087  18.130  1.00 59.98           C  
ATOM   1964  C   PHE A 254     -22.497  68.568  18.005  1.00 62.30           C  
ATOM   1965  O   PHE A 254     -22.085  68.050  16.969  1.00 66.45           O  
ATOM   1966  CB  PHE A 254     -21.429  70.606  19.007  1.00 59.90           C  
ATOM   1967  CG  PHE A 254     -20.063  70.197  18.529  1.00 58.33           C  
ATOM   1968  CD1 PHE A 254     -19.502  68.987  18.929  1.00 55.98           C  
ATOM   1969  CD2 PHE A 254     -19.341  71.016  17.667  1.00 57.44           C  
ATOM   1970  CE1 PHE A 254     -18.242  68.601  18.476  1.00 57.83           C  
ATOM   1971  CE2 PHE A 254     -18.081  70.639  17.209  1.00 54.37           C  
ATOM   1972  CZ  PHE A 254     -17.530  69.429  17.614  1.00 56.74           C  
ATOM   1973  N   LEU A 255     -22.890  67.858  19.059  1.00 62.56           N  
ATOM   1974  CA  LEU A 255     -22.860  66.398  19.045  1.00 62.83           C  
ATOM   1975  C   LEU A 255     -23.948  65.827  18.139  1.00 64.43           C  
ATOM   1976  O   LEU A 255     -23.754  64.796  17.491  1.00 65.91           O  
ATOM   1977  CB  LEU A 255     -23.033  65.844  20.462  1.00 60.67           C  
ATOM   1978  CG  LEU A 255     -21.883  66.079  21.443  1.00 60.08           C  
ATOM   1979  CD1 LEU A 255     -22.219  65.440  22.782  1.00 59.97           C  
ATOM   1980  CD2 LEU A 255     -20.595  65.491  20.881  1.00 59.46           C  
ATOM   1981  N   GLU A 256     -25.092  66.503  18.102  1.00 63.10           N  
ATOM   1982  CA  GLU A 256     -26.215  66.083  17.273  1.00 58.92           C  
ATOM   1983  C   GLU A 256     -26.103  66.693  15.878  1.00 60.60           C  
ATOM   1984  O   GLU A 256     -27.022  66.592  15.065  1.00 60.60           O  
ATOM   1985  CB  GLU A 256     -27.532  66.471  17.946  1.00 57.05           C  
ATOM   1986  CG  GLU A 256     -27.838  65.657  19.194  1.00 57.21           C  
ATOM   1987  CD  GLU A 256     -28.990  66.224  19.999  1.00 58.11           C  
ATOM   1988  OE1 GLU A 256     -30.050  66.513  19.405  1.00 55.62           O  
ATOM   1989  OE2 GLU A 256     -28.835  66.373  21.230  1.00 61.81           O  
ATOM   1990  N   LYS A 257     -24.961  67.325  15.620  1.00 59.95           N  
ATOM   1991  CA  LYS A 257     -24.665  67.961  14.339  1.00 59.84           C  
ATOM   1992  C   LYS A 257     -25.806  68.750  13.692  1.00 58.74           C  
ATOM   1993  O   LYS A 257     -26.210  68.470  12.565  1.00 62.04           O  
ATOM   1994  CB  LYS A 257     -24.134  66.934  13.337  1.00 60.39           C  
ATOM   1995  CG  LYS A 257     -23.021  66.049  13.880  1.00 61.23           C  
ATOM   1996  CD  LYS A 257     -22.491  65.117  12.801  1.00 62.46           C  
ATOM   1997  CE  LYS A 257     -21.661  63.987  13.389  1.00 64.04           C  
ATOM   1998  NZ  LYS A 257     -20.484  64.477  14.156  1.00 64.84           N  
ATOM   1999  N   ARG A 258     -26.315  69.742  14.413  1.00 59.29           N  
ATOM   2000  CA  ARG A 258     -27.399  70.588  13.922  1.00 57.55           C  
ATOM   2001  C   ARG A 258     -27.184  72.029  14.364  1.00 57.71           C  
ATOM   2002  O   ARG A 258     -26.504  72.284  15.358  1.00 61.20           O  
ATOM   2003  CB  ARG A 258     -28.715  70.051  14.490  1.00 55.61           C  
ATOM   2004  CG  ARG A 258     -28.694  69.804  15.989  1.00 55.51           C  
ATOM   2005  CD  ARG A 258     -29.635  70.737  16.727  1.00 56.02           C  
ATOM   2006  NE  ARG A 258     -29.650  70.461  18.160  1.00 55.31           N  
ATOM   2007  CZ  ARG A 258     -30.410  71.108  19.037  1.00 55.46           C  
ATOM   2008  NH1 ARG A 258     -31.225  72.074  18.630  1.00 51.86           N  
ATOM   2009  NH2 ARG A 258     -30.357  70.788  20.324  1.00 58.49           N  
ATOM   2010  N   GLN A 259     -27.754  72.974  13.626  1.00 55.56           N  
ATOM   2011  CA  GLN A 259     -27.590  74.380  13.965  1.00 52.43           C  
ATOM   2012  C   GLN A 259     -28.222  74.689  15.317  1.00 51.21           C  
ATOM   2013  O   GLN A 259     -29.412  74.456  15.526  1.00 47.93           O  
ATOM   2014  CB  GLN A 259     -28.220  75.272  12.897  1.00 53.48           C  
ATOM   2015  CG  GLN A 259     -27.785  76.727  13.001  1.00 62.63           C  
ATOM   2016  CD  GLN A 259     -28.668  77.665  12.205  1.00 65.03           C  
ATOM   2017  OE1 GLN A 259     -28.885  77.470  11.010  1.00 67.88           O  
ATOM   2018  NE2 GLN A 259     -29.183  78.696  12.869  1.00 66.03           N  
ATOM   2019  N   PRO A 260     -27.425  75.221  16.258  1.00 48.52           N  
ATOM   2020  CA  PRO A 260     -27.916  75.562  17.594  1.00 45.67           C  
ATOM   2021  C   PRO A 260     -28.816  76.785  17.557  1.00 45.03           C  
ATOM   2022  O   PRO A 260     -28.629  77.674  16.728  1.00 44.79           O  
ATOM   2023  CB  PRO A 260     -26.632  75.813  18.374  1.00 45.78           C  
ATOM   2024  CG  PRO A 260     -25.737  76.400  17.332  1.00 45.71           C  
ATOM   2025  CD  PRO A 260     -25.982  75.497  16.147  1.00 45.85           C  
ATOM   2026  N   ASN A 261     -29.796  76.820  18.454  1.00 46.64           N  
ATOM   2027  CA  ASN A 261     -30.726  77.939  18.532  1.00 49.12           C  
ATOM   2028  C   ASN A 261     -30.495  78.709  19.826  1.00 44.69           C  
ATOM   2029  O   ASN A 261     -31.048  78.383  20.880  1.00 40.49           O  
ATOM   2030  CB  ASN A 261     -32.166  77.431  18.459  1.00 58.78           C  
ATOM   2031  CG  ASN A 261     -32.443  76.653  17.183  1.00 69.19           C  
ATOM   2032  OD1 ASN A 261     -32.246  77.162  16.077  1.00 73.56           O  
ATOM   2033  ND2 ASN A 261     -32.898  75.414  17.332  1.00 75.13           N  
ATOM   2034  N   TRP A 262     -29.668  79.740  19.723  1.00 42.87           N  
ATOM   2035  CA  TRP A 262     -29.305  80.579  20.855  1.00 37.41           C  
ATOM   2036  C   TRP A 262     -30.467  81.377  21.421  1.00 36.68           C  
ATOM   2037  O   TRP A 262     -31.252  81.963  20.678  1.00 39.26           O  
ATOM   2038  CB  TRP A 262     -28.196  81.532  20.432  1.00 31.46           C  
ATOM   2039  CG  TRP A 262     -27.074  80.843  19.736  1.00 23.21           C  
ATOM   2040  CD1 TRP A 262     -26.632  81.077  18.467  1.00 22.42           C  
ATOM   2041  CD2 TRP A 262     -26.227  79.822  20.277  1.00 21.71           C  
ATOM   2042  NE1 TRP A 262     -25.559  80.266  18.183  1.00 27.19           N  
ATOM   2043  CE2 TRP A 262     -25.291  79.485  19.276  1.00 22.34           C  
ATOM   2044  CE3 TRP A 262     -26.171  79.157  21.509  1.00 23.26           C  
ATOM   2045  CZ2 TRP A 262     -24.304  78.514  19.472  1.00 23.67           C  
ATOM   2046  CZ3 TRP A 262     -25.191  78.191  21.703  1.00 21.08           C  
ATOM   2047  CH2 TRP A 262     -24.271  77.878  20.686  1.00 20.87           C  
ATOM   2048  N   LYS A 263     -30.562  81.403  22.744  1.00 40.09           N  
ATOM   2049  CA  LYS A 263     -31.619  82.139  23.421  1.00 44.87           C  
ATOM   2050  C   LYS A 263     -31.041  83.332  24.173  1.00 42.55           C  
ATOM   2051  O   LYS A 263     -31.779  84.198  24.640  1.00 46.60           O  
ATOM   2052  CB  LYS A 263     -32.374  81.214  24.380  1.00 53.76           C  
ATOM   2053  CG  LYS A 263     -33.292  80.224  23.669  1.00 67.27           C  
ATOM   2054  CD  LYS A 263     -33.789  79.128  24.600  1.00 80.42           C  
ATOM   2055  CE  LYS A 263     -32.660  78.185  24.996  1.00 87.65           C  
ATOM   2056  NZ  LYS A 263     -33.142  77.042  25.822  1.00 90.10           N  
ATOM   2057  N   GLY A 264     -29.718  83.372  24.283  1.00 40.09           N  
ATOM   2058  CA  GLY A 264     -29.065  84.476  24.965  1.00 39.32           C  
ATOM   2059  C   GLY A 264     -28.954  84.315  26.467  1.00 37.40           C  
ATOM   2060  O   GLY A 264     -28.425  85.190  27.150  1.00 33.13           O  
ATOM   2061  N   ILE A 265     -29.458  83.200  26.987  1.00 36.00           N  
ATOM   2062  CA  ILE A 265     -29.400  82.933  28.418  1.00 34.17           C  
ATOM   2063  C   ILE A 265     -28.911  81.510  28.664  1.00 32.47           C  
ATOM   2064  O   ILE A 265     -28.602  80.818  27.674  1.00 22.36           O  
ATOM   2065  CB  ILE A 265     -30.786  83.101  29.077  1.00 42.51           C  
ATOM   2066  CG1 ILE A 265     -31.754  82.041  28.544  1.00 47.32           C  
ATOM   2067  CG2 ILE A 265     -31.329  84.493  28.791  1.00 42.40           C  
ATOM   2068  CD1 ILE A 265     -33.117  82.066  29.210  1.00 52.79           C  
TER    2069      ILE A 265                                                      
END
MOLECULE T0486_32_232.pdb
ATOM      1  N   PRO    32     -34.619 118.105  22.201  1.00 36.37          
ATOM      2  CA  PRO    32     -33.499 118.122  21.209  1.00 35.38          
ATOM      4  CB  PRO    32     -33.430 119.614  20.792  1.00 35.70          
ATOM      7  CG  PRO    32     -33.972 120.393  22.069  1.00 36.10          
ATOM     10  CD  PRO    32     -34.671 119.355  22.997  1.00 36.93          
ATOM     13  C   PRO    32     -32.165 117.592  21.848  1.00 33.74          
ATOM     14  O   PRO    32     -31.732 118.103  22.927  1.00 33.85          
ATOM     17  N   ARG    33     -31.582 116.543  21.238  1.00 30.52          
ATOM     18  CA  ARG    33     -30.447 115.793  21.849  1.00 27.98          
ATOM     20  CB  ARG    33     -30.865 114.408  22.341  1.00 28.20          
ATOM     23  CG  ARG    33     -31.393 114.428  23.789  1.00 29.12          
ATOM     26  CD  ARG    33     -32.244 113.222  24.112  1.00 29.44          
ATOM     29  NE  ARG    33     -31.441 112.010  24.221  1.00 34.76          
ATOM     31  CZ  ARG    33     -30.684 111.700  25.275  1.00 35.22          
ATOM     32  NH1 ARG    33     -30.631 112.499  26.343  1.00 36.88          
ATOM     35  NH2 ARG    33     -29.978 110.588  25.259  1.00 32.19          
ATOM     38  C   ARG    33     -29.262 115.677  20.906  1.00 25.16          
ATOM     39  O   ARG    33     -29.423 115.490  19.701  1.00 24.96          
ATOM     41  N   PRO    34     -28.053 115.856  21.441  1.00 22.90          
ATOM     42  CA  PRO    34     -26.892 115.796  20.552  1.00 21.60          
ATOM     44  CB  PRO    34     -25.813 116.476  21.373  1.00 21.42          
ATOM     47  CG  PRO    34     -26.259 116.398  22.777  1.00 21.04          
ATOM     50  CD  PRO    34     -27.713 116.344  22.796  1.00 21.80          
ATOM     53  C   PRO    34     -26.530 114.359  20.058  1.00 21.60          
ATOM     54  O   PRO    34     -25.855 114.222  19.035  1.00 19.72          
ATOM     55  N   THR    35     -27.041 113.315  20.739  1.00 21.90          
ATOM     56  CA  THR    35     -27.051 111.948  20.185  1.00 23.12          
ATOM     58  CB  THR    35     -26.409 110.928  21.125  1.00 22.50          
ATOM     60  OG1 THR    35     -27.132 110.918  22.364  1.00 25.34          
ATOM     62  CG2 THR    35     -24.919 111.265  21.369  1.00 21.08          
ATOM     66  C   THR    35     -28.454 111.425  19.823  1.00 23.98          
ATOM     67  O   THR    35     -29.444 111.807  20.428  1.00 23.83          
ATOM     69  N   SER    36     -28.514 110.537  18.832  1.00 25.38          
ATOM     70  CA  SER    36     -29.722 109.737  18.544  1.00 26.75          
ATOM     72  CB  SER    36     -30.314 110.035  17.140  1.00 27.55          
ATOM     75  OG  SER    36     -29.338 110.522  16.226  1.00 30.93          
ATOM     77  C   SER    36     -29.398 108.260  18.650  1.00 26.57          
ATOM     78  O   SER    36     -28.336 107.810  18.248  1.00 27.02          
ATOM     80  N   ALA    37     -30.314 107.511  19.238  1.00 26.96          
ATOM     81  CA  ALA    37     -30.143 106.081  19.431  1.00 27.11          
ATOM     83  CB  ALA    37     -29.956 105.773  20.900  1.00 26.60          
ATOM     87  C   ALA    37     -31.372 105.383  18.908  1.00 27.34          
ATOM     88  O   ALA    37     -32.470 105.853  19.106  1.00 28.07          
ATOM     90  N   ARG    38     -31.190 104.251  18.246  1.00 27.41          
ATOM     91  CA  ARG    38     -32.296 103.405  17.847  1.00 27.20          
ATOM     93  CB  ARG    38     -32.659 103.679  16.387  1.00 27.68          
ATOM     96  CG  ARG    38     -31.555 103.196  15.435  1.00 32.69          
ATOM     99  CD  ARG    38     -31.659 103.719  14.024  1.00 41.47          
ATOM    102  NE  ARG    38     -30.354 103.705  13.320  1.00 45.71          
ATOM    104  CZ  ARG    38     -29.427 104.668  13.420  1.00 50.50          
ATOM    105  NH1 ARG    38     -29.618 105.741  14.231  1.00 50.89          
ATOM    108  NH2 ARG    38     -28.289 104.552  12.723  1.00 52.00          
ATOM    111  C   ARG    38     -31.815 101.967  18.007  1.00 25.56          
ATOM    112  O   ARG    38     -30.678 101.662  17.715  1.00 25.50          
ATOM    114  N   GLN    39     -32.704 101.090  18.416  1.00 24.27          
ATOM    115  CA  GLN    39     -32.419  99.696  18.607  1.00 23.41          
ATOM    117  CB  GLN    39     -32.504  99.381  20.098  1.00 22.43          
ATOM    120  CG  GLN    39     -32.031  98.004  20.463  1.00 20.76          
ATOM    123  CD  GLN    39     -32.101  97.804  21.945  1.00 19.82          
ATOM    124  OE1 GLN    39     -31.617  98.641  22.700  1.00 21.67          
ATOM    125  NE2 GLN    39     -32.718  96.729  22.382  1.00 18.57          
ATOM    128  C   GLN    39     -33.376  98.795  17.807  1.00 23.80          
ATOM    129  O   GLN    39     -34.607  98.928  17.836  1.00 22.33          
ATOM    131  N   LEU    40     -32.781  97.833  17.122  1.00 24.93          
ATOM    132  CA  LEU    40     -33.517  96.918  16.193  1.00 24.93          
ATOM    134  CB  LEU    40     -33.638  97.621  14.868  1.00 23.82          
ATOM    137  CG  LEU    40     -34.317  97.048  13.632  1.00 25.78          
ATOM    139  CD1 LEU    40     -35.754  96.407  13.794  1.00 22.15          
ATOM    143  CD2 LEU    40     -34.332  98.285  12.734  1.00 27.38          
ATOM    147  C   LEU    40     -32.727  95.579  16.056  1.00 24.92          
ATOM    148  O   LEU    40     -31.532  95.556  15.665  1.00 24.12          
ATOM    150  N   ASP    41     -33.397  94.485  16.407  1.00 24.46          
ATOM    151  CA  ASP    41     -32.832  93.138  16.324  1.00 23.32          
ATOM    153  CB  ASP    41     -32.497  92.813  14.881  1.00 23.91          
ATOM    156  CG  ASP    41     -33.714  92.826  14.019  1.00 24.72          
ATOM    157  OD1 ASP    41     -34.776  92.365  14.493  1.00 26.36          
ATOM    158  OD2 ASP    41     -33.611  93.311  12.880  1.00 28.80          
ATOM    159  C   ASP    41     -31.614  92.967  17.229  1.00 21.87          
ATOM    160  O   ASP    41     -30.626  92.310  16.860  1.00 20.53          
ATOM    162  N   GLY    42     -31.746  93.566  18.411  1.00 20.42          
ATOM    163  CA  GLY    42     -30.736  93.512  19.459  1.00 20.29          
ATOM    166  C   GLY    42     -29.595  94.500  19.363  1.00 19.56          
ATOM    167  O   GLY    42     -28.794  94.588  20.317  1.00 18.21          
ATOM    169  N   ILE    43     -29.524  95.210  18.216  1.00 18.49          
ATOM    170  CA  ILE    43     -28.446  96.171  17.861  1.00 18.12          
ATOM    172  CB  ILE    43     -27.947  96.049  16.350  1.00 17.15          
ATOM    174  CG1 ILE    43     -27.750  94.566  15.978  1.00 17.41          
ATOM    177  CD  ILE    43     -27.448  94.223  14.517  1.00 10.50          
ATOM    181  CG2 ILE    43     -26.679  96.919  16.144  1.00 16.46          
ATOM    185  C   ILE    43     -28.914  97.604  18.115  1.00 18.28          
ATOM    186  O   ILE    43     -29.876  98.098  17.509  1.00 18.83          
ATOM    188  N   ARG    44     -28.217  98.262  19.026  1.00 19.01          
ATOM    189  CA  ARG    44     -28.426  99.669  19.350  1.00 18.37          
ATOM    191  CB  ARG    44     -28.251  99.867  20.862  1.00 17.76          
ATOM    194  CG  ARG    44     -28.759 101.185  21.386  1.00 16.54          
ATOM    197  CD  ARG    44     -28.557 101.298  22.871  1.00 13.79          
ATOM    200  NE  ARG    44     -29.614 100.601  23.569  1.00 16.47          
ATOM    202  CZ  ARG    44     -29.743 100.548  24.895  1.00 14.91          
ATOM    203  NH1 ARG    44     -28.873 101.103  25.694  1.00 16.61          
ATOM    206  NH2 ARG    44     -30.739  99.908  25.406  1.00 13.62          
ATOM    209  C   ARG    44     -27.374 100.471  18.614  1.00 18.83          
ATOM    210  O   ARG    44     -26.207 100.233  18.807  1.00 19.07          
ATOM    212  N   ASN    45     -27.790 101.381  17.737  1.00 20.00          
ATOM    213  CA  ASN    45     -26.902 102.386  17.160  1.00 21.31          
ATOM    215  CB  ASN    45     -27.254 102.653  15.690  1.00 22.09          
ATOM    218  CG  ASN    45     -26.607 101.671  14.767  1.00 25.78          
ATOM    219  OD1 ASN    45     -25.428 101.800  14.420  1.00 29.25          
ATOM    220  ND2 ASN    45     -27.368 100.646  14.370  1.00 29.97          
ATOM    223  C   ASN    45     -27.097 103.694  17.913  1.00 20.17          
ATOM    224  O   ASN    45     -28.210 104.202  17.948  1.00 18.97          
ATOM    226  N   ILE    46     -26.014 104.210  18.466  1.00 18.93          
ATOM    227  CA  ILE    46     -25.987 105.493  19.103  1.00 19.48          
ATOM    229  CB  ILE    46     -25.365 105.470  20.503  1.00 20.23          
ATOM    231  CG1 ILE    46     -25.959 104.315  21.334  1.00 18.43          
ATOM    234  CD  ILE    46     -25.395 104.142  22.715  1.00 16.72          
ATOM    238  CG2 ILE    46     -25.657 106.813  21.251  1.00 21.84          
ATOM    242  C   ILE    46     -25.153 106.373  18.195  1.00 19.86          
ATOM    243  O   ILE    46     -24.007 106.093  17.927  1.00 19.65          
ATOM    245  N   VAL    47     -25.783 107.396  17.626  1.00 19.12          
ATOM    246  CA  VAL    47     -25.130 108.216  16.637  1.00 17.92          
ATOM    248  CB  VAL    47     -26.000 108.295  15.342  1.00 18.43          
ATOM    250  CG1 VAL    47     -25.252 109.065  14.230  1.00 14.15          
ATOM    254  CG2 VAL    47     -26.458 106.884  14.946  1.00 15.51          
ATOM    258  C   VAL    47     -24.874 109.613  17.222  1.00 18.23          
ATOM    259  O   VAL    47     -25.789 110.245  17.749  1.00 16.54          
ATOM    261  N   LEU    48     -23.597 110.026  17.180  1.00 19.26          
ATOM    262  CA  LEU    48     -23.140 111.408  17.516  1.00 19.61          
ATOM    264  CB  LEU    48     -21.612 111.473  17.583  1.00 19.28          
ATOM    267  CG  LEU    48     -20.809 111.031  18.827  1.00 21.00          
ATOM    269  CD1 LEU    48     -21.282 109.801  19.431  1.00 21.01          
ATOM    273  CD2 LEU    48     -19.254 110.978  18.591  1.00 20.34          
ATOM    277  C   LEU    48     -23.683 112.346  16.433  1.00 19.02          
ATOM    278  O   LEU    48     -23.265 112.242  15.284  1.00 19.61          
ATOM    280  N   SER    49     -24.629 113.228  16.817  1.00 19.00          
ATOM    281  CA  SER    49     -25.459 113.967  15.907  1.00 19.54          
ATOM    283  CB  SER    49     -26.956 113.575  16.017  1.00 19.42          
ATOM    286  OG  SER    49     -27.184 112.207  15.968  1.00 22.18          
ATOM    288  C   SER    49     -25.374 115.453  16.188  1.00 19.35          
ATOM    289  O   SER    49     -26.415 116.121  16.348  1.00 20.03          
ATOM    291  N   ASN    50     -24.167 115.992  16.192  1.00 18.55          
ATOM    292  CA  ASN    50     -23.986 117.427  16.208  1.00 18.37          
ATOM    294  CB  ASN    50     -23.746 117.909  17.661  1.00 18.55          
ATOM    297  CG  ASN    50     -23.854 119.443  17.836  1.00 20.36          
ATOM    298  OD1 ASN    50     -24.433 120.176  17.010  1.00 23.36          
ATOM    299  ND2 ASN    50     -23.307 119.920  18.928  1.00 20.58          
ATOM    302  C   ASN    50     -22.845 117.817  15.253  1.00 17.76          
ATOM    303  O   ASN    50     -21.879 118.424  15.685  1.00 16.99          
ATOM    305  N   PRO    51     -22.976 117.488  13.948  1.00 17.55          
ATOM    306  CA  PRO    51     -21.879 117.662  12.995  1.00 17.89          
ATOM    308  CB  PRO    51     -22.410 117.004  11.717  1.00 17.83          
ATOM    311  CG  PRO    51     -23.910 117.044  11.828  1.00 17.67          
ATOM    314  CD  PRO    51     -24.125 116.811  13.314  1.00 18.65          
ATOM    317  C   PRO    51     -21.472 119.109  12.713  1.00 18.99          
ATOM    318  O   PRO    51     -20.383 119.318  12.162  1.00 19.27          
ATOM    319  N   LYS    52     -22.337 120.078  13.063  1.00 19.59          
ATOM    320  CA  LYS    52     -22.065 121.478  12.820  1.00 20.04          
ATOM    322  CB  LYS    52     -23.329 122.341  12.836  1.00 20.46          
ATOM    325  CG  LYS    52     -24.164 122.187  11.572  1.00 20.43          
ATOM    328  CD  LYS    52     -25.365 123.122  11.559  1.00 22.83          
ATOM    331  CE  LYS    52     -26.699 122.394  11.494  1.00 24.90          
ATOM    334  NZ  LYS    52     -27.829 123.330  11.277  1.00 24.95          
ATOM    338  C   LYS    52     -21.061 121.966  13.827  1.00 20.04          
ATOM    339  O   LYS    52     -20.398 122.970  13.602  1.00 20.00          
ATOM    341  N   LYS    53     -20.927 121.200  14.900  1.00 20.27          
ATOM    342  CA  LYS    53     -19.956 121.445  15.930  1.00 20.34          
ATOM    344  CB  LYS    53     -20.682 121.670  17.246  1.00 20.68          
ATOM    347  CG  LYS    53     -21.847 122.692  17.095  1.00 23.09          
ATOM    350  CD  LYS    53     -21.521 124.116  17.491  1.00 27.62          
ATOM    353  CE  LYS    53     -21.409 124.209  19.100  1.00 32.41          
ATOM    356  NZ  LYS    53     -22.460 123.426  19.934  1.00 31.15          
ATOM    360  C   LYS    53     -18.986 120.294  15.993  1.00 19.39          
ATOM    361  O   LYS    53     -18.420 120.077  17.023  1.00 18.49          
ATOM    363  N   ARG    54     -18.802 119.602  14.853  1.00 19.24          
ATOM    364  CA  ARG    54     -17.947 118.407  14.688  1.00 19.47          
ATOM    366  CB  ARG    54     -16.491 118.814  14.543  1.00 20.32          
ATOM    369  CG  ARG    54     -16.186 119.822  13.489  1.00 20.47          
ATOM    372  CD  ARG    54     -14.698 120.096  13.553  1.00 24.75          
ATOM    375  NE  ARG    54     -14.290 121.251  12.769  1.00 28.96          
ATOM    380  C   ARG    54     -18.064 117.358  15.813  1.00 19.60          
ATOM    381  O   ARG    54     -17.084 116.759  16.256  1.00 16.42          
ATOM    383  N   ASN    55     -19.290 117.172  16.282  1.00 19.25          
ATOM    384  CA  ASN    55     -19.541 116.166  17.282  1.00 18.54          
ATOM    386  CB  ASN    55     -19.436 114.785  16.625  1.00 18.50          
ATOM    389  CG  ASN    55     -20.554 114.554  15.636  1.00 17.41          
ATOM    390  OD1 ASN    55     -21.626 115.015  15.879  1.00 16.53          
ATOM    391  ND2 ASN    55     -20.289 113.919  14.511  1.00 15.60          
ATOM    394  C   ASN    55     -18.686 116.324  18.525  1.00 17.75          
ATOM    395  O   ASN    55     -18.268 115.349  19.146  1.00 16.70          
ATOM    397  N   THR    56     -18.423 117.568  18.899  0.50 17.45          
ATOM    399  CA  THR    56     -17.523 117.808  20.015  0.50 17.17          
ATOM    403  CB  THR    56     -17.134 119.322  20.215  0.50 16.76          
ATOM    407  OG1 THR    56     -18.308 120.136  20.261  0.50 15.81          
ATOM    411  CG2 THR    56     -16.202 119.812  19.093  0.50 16.14          
ATOM    419  C   THR    56     -18.163 117.235  21.281  0.50 17.32          
ATOM    421  O   THR    56     -19.389 117.253  21.438  0.50 16.51          
ATOM    425  N   LEU    57     -17.299 116.734  22.157  1.00 16.32          
ATOM    426  CA  LEU    57     -17.669 116.055  23.328  1.00 17.23          
ATOM    428  CB  LEU    57     -16.656 114.936  23.660  1.00 17.89          
ATOM    431  CG  LEU    57     -16.646 113.795  22.618  1.00 21.28          
ATOM    433  CD1 LEU    57     -15.502 112.788  22.902  1.00 18.00          
ATOM    437  CD2 LEU    57     -18.119 113.109  22.438  1.00 18.16          
ATOM    441  C   LEU    57     -17.801 117.054  24.455  1.00 16.91          
ATOM    442  O   LEU    57     -17.015 117.112  25.387  1.00 15.44          
ATOM    444  N   SER    58     -18.876 117.811  24.369  1.00 17.04          
ATOM    445  CA  SER    58     -19.218 118.780  25.376  1.00 17.02          
ATOM    447  CB  SER    58     -20.214 119.781  24.830  1.00 17.07          
ATOM    450  OG  SER    58     -21.405 119.120  24.399  1.00 18.63          
ATOM    452  C   SER    58     -19.837 118.015  26.481  1.00 17.85          
ATOM    453  O   SER    58     -20.266 116.837  26.284  1.00 19.18          
ATOM    455  N   LEU    59     -19.940 118.672  27.640  1.00 18.08          
ATOM    456  CA  LEU    59     -20.596 118.079  28.772  1.00 18.91          
ATOM    458  CB  LEU    59     -20.722 119.060  29.922  1.00 18.31          
ATOM    461  CG  LEU    59     -21.104 118.375  31.206  1.00 19.05          
ATOM    463  CD1 LEU    59     -20.058 117.332  31.631  1.00 13.20          
ATOM    467  CD2 LEU    59     -21.366 119.435  32.315  1.00 18.29          
ATOM    471  C   LEU    59     -21.975 117.511  28.356  1.00 19.34          
ATOM    472  O   LEU    59     -22.280 116.379  28.709  1.00 21.50          
ATOM    474  N   ALA    60     -22.751 118.247  27.558  1.00 19.33          
ATOM    475  CA  ALA    60     -24.113 117.845  27.145  1.00 19.25          
ATOM    477  CB  ALA    60     -24.852 119.063  26.474  1.00 17.30          
ATOM    481  C   ALA    60     -24.128 116.608  26.197  1.00 19.56          
ATOM    482  O   ALA    60     -24.965 115.726  26.338  1.00 20.09          
ATOM    484  N   MET    61     -23.207 116.582  25.220  1.00 20.39          
ATOM    485  CA  MET    61     -22.937 115.400  24.392  1.00 20.42          
ATOM    487  CB  MET    61     -21.851 115.762  23.403  1.00 20.30          
ATOM    490  CG  MET    61     -21.441 114.639  22.523  1.00 21.87          
ATOM    493  SD  MET    61     -22.682 114.165  21.333  1.00 17.95          
ATOM    494  CE  MET    61     -22.252 115.145  19.892  1.00 25.26          
ATOM    498  C   MET    61     -22.492 114.161  25.207  1.00 20.67          
ATOM    499  O   MET    61     -23.010 113.080  25.036  1.00 21.86          
ATOM    501  N   LEU    62     -21.560 114.336  26.128  1.00 19.50          
ATOM    502  CA  LEU    62     -21.183 113.264  27.017  1.00 19.05          
ATOM    504  CB  LEU    62     -20.032 113.730  27.953  1.00 18.43          
ATOM    507  CG  LEU    62     -18.673 113.886  27.303  1.00 16.64          
ATOM    509  CD1 LEU    62     -17.752 114.841  28.082  1.00 13.44          
ATOM    513  CD2 LEU    62     -18.074 112.458  27.050  1.00 10.71          
ATOM    517  C   LEU    62     -22.349 112.696  27.880  1.00 19.89          
ATOM    518  O   LEU    62     -22.421 111.472  28.107  1.00 20.69          
ATOM    520  N   LYS    63     -23.256 113.540  28.344  1.00 18.86          
ATOM    521  CA  LYS    63     -24.368 113.067  29.174  1.00 18.70          
ATOM    523  CB  LYS    63     -24.967 114.220  29.983  1.00 19.18          
ATOM    526  CG  LYS    63     -23.947 114.768  31.011  1.00 21.85          
ATOM    529  CD  LYS    63     -24.591 115.794  31.978  1.00 26.45          
ATOM    532  CE  LYS    63     -24.705 117.236  31.381  1.00 28.19          
ATOM    535  NZ  LYS    63     -24.745 118.338  32.430  1.00 27.09          
ATOM    539  C   LYS    63     -25.449 112.378  28.380  1.00 18.16          
ATOM    540  O   LYS    63     -26.060 111.407  28.863  1.00 14.99          
ATOM    542  N   SER    64     -25.679 112.890  27.169  1.00 18.16          
ATOM    543  CA  SER    64     -26.622 112.285  26.231  1.00 18.71          
ATOM    545  CB  SER    64     -26.765 113.206  24.997  1.00 18.48          
ATOM    548  OG  SER    64     -27.687 112.789  24.019  1.00 18.11          
ATOM    550  C   SER    64     -26.080 110.903  25.867  1.00 19.90          
ATOM    551  O   SER    64     -26.825 109.916  25.838  1.00 19.94          
ATOM    553  N   LEU    65     -24.766 110.841  25.586  1.00 20.77          
ATOM    554  CA  LEU    65     -24.115 109.603  25.140  1.00 20.75          
ATOM    556  CB  LEU    65     -22.684 109.865  24.635  1.00 20.13          
ATOM    559  CG  LEU    65     -21.825 108.617  24.301  1.00 20.27          
ATOM    561  CD1 LEU    65     -22.510 107.847  23.202  1.00 21.28          
ATOM    565  CD2 LEU    65     -20.409 109.031  23.868  1.00 19.72          
ATOM    569  C   LEU    65     -24.167 108.553  26.251  1.00 20.12          
ATOM    570  O   LEU    65     -24.622 107.439  26.031  1.00 20.44          
ATOM    572  N   GLN    66     -23.744 108.962  27.445  1.00 20.60          
ATOM    573  CA  GLN    66     -23.862 108.189  28.670  1.00 19.61          
ATOM    575  CB  GLN    66     -23.515 109.049  29.870  1.00 20.10          
ATOM    578  CG  GLN    66     -23.577 108.308  31.264  1.00 20.81          
ATOM    581  CD  GLN    66     -22.884 109.093  32.336  1.00 23.04          
ATOM    582  OE1 GLN    66     -21.735 108.798  32.653  1.00 29.45          
ATOM    583  NE2 GLN    66     -23.513 110.164  32.820  1.00 22.57          
ATOM    586  C   GLN    66     -25.235 107.644  28.881  1.00 20.02          
ATOM    587  O   GLN    66     -25.390 106.570  29.439  1.00 20.66          
ATOM    589  N   SER    67     -26.251 108.388  28.477  1.00 20.55          
ATOM    590  CA  SER    67     -27.633 108.053  28.778  1.00 19.80          
ATOM    592  CB  SER    67     -28.495 109.304  28.623  1.00 20.36          
ATOM    595  OG  SER    67     -29.550 109.291  29.502  1.00 22.20          
ATOM    597  C   SER    67     -28.104 106.978  27.819  1.00 19.85          
ATOM    598  O   SER    67     -28.780 106.002  28.204  1.00 19.35          
ATOM    600  N   ASP    68     -27.755 107.173  26.552  1.00 19.94          
ATOM    601  CA  ASP    68     -28.086 106.210  25.516  1.00 19.79          
ATOM    603  CB  ASP    68     -27.629 106.746  24.158  1.00 20.43          
ATOM    606  CG  ASP    68     -28.456 107.942  23.658  1.00 23.76          
ATOM    607  OD1 ASP    68     -29.557 108.215  24.195  1.00 23.98          
ATOM    608  OD2 ASP    68     -27.973 108.619  22.722  1.00 28.92          
ATOM    609  C   ASP    68     -27.404 104.851  25.801  1.00 19.43          
ATOM    610  O   ASP    68     -27.954 103.843  25.545  1.00 18.46          
ATOM    612  N   ILE    69     -26.173 104.862  26.312  1.00 19.12          
ATOM    613  CA  ILE    69     -25.446 103.638  26.632  1.00 18.47          
ATOM    615  CB  ILE    69     -23.958 103.948  26.929  1.00 18.25          
ATOM    617  CG1 ILE    69     -23.242 104.395  25.637  1.00 19.17          
ATOM    620  CD  ILE    69     -21.812 104.999  25.889  1.00 15.75          
ATOM    624  CG2 ILE    69     -23.235 102.721  27.440  1.00 15.24          
ATOM    628  C   ILE    69     -26.089 102.850  27.785  1.00 18.01          
ATOM    629  O   ILE    69     -26.329 101.659  27.651  1.00 16.70          
ATOM    631  N   LEU    70     -26.426 103.562  28.858  1.00 18.44          
ATOM    632  CA  LEU    70     -26.958 102.993  30.087  1.00 18.51          
ATOM    634  CB  LEU    70     -26.781 104.008  31.221  1.00 18.02          
ATOM    637  CG  LEU    70     -25.282 104.191  31.605  1.00 17.56          
ATOM    639  CD1 LEU    70     -25.172 105.045  32.861  1.00 17.10          
ATOM    643  CD2 LEU    70     -24.507 102.850  31.759  1.00 16.31          
ATOM    647  C   LEU    70     -28.402 102.570  30.034  1.00 18.99          
ATOM    648  O   LEU    70     -28.889 101.779  30.891  1.00 19.34          
ATOM    650  N   HSD    71     -29.119 103.103  29.061  1.00 19.25          
ATOM    651  CA  HSD    71     -30.548 102.931  29.018  1.00 19.59          
ATOM    653  CB  HSD    71     -31.131 103.739  27.866  1.00 19.71          
ATOM    656  CG  HSD    71     -32.594 103.546  27.715  1.00 19.32          
ATOM    657  ND1 HSD    71     -33.145 102.695  26.782  1.00 19.54          
ATOM    659  CE1 HSD    71     -34.464 102.709  26.910  1.00 20.43          
ATOM    661  NE2 HSD    71     -34.779 103.515  27.909  1.00 19.47          
ATOM    663  CD2 HSD    71     -33.628 104.049  28.430  1.00 20.71          
ATOM    665  C   HSD    71     -30.896 101.469  28.799  1.00 20.07          
ATOM    666  O   HSD    71     -30.428 100.917  27.828  1.00 18.82          
ATOM    668  N   ASP    72     -31.700 100.854  29.682  1.00 21.27          
ATOM    669  CA  ASP    72     -32.105  99.434  29.518  1.00 22.29          
ATOM    671  CB  ASP    72     -32.970  99.278  28.269  1.00 23.59          
ATOM    674  CG  ASP    72     -34.388  99.232  28.573  1.00 25.09          
ATOM    675  OD1 ASP    72     -34.945 100.303  28.881  1.00 30.24          
ATOM    676  OD2 ASP    72     -34.935  98.108  28.543  1.00 29.83          
ATOM    677  C   ASP    72     -30.928  98.486  29.323  1.00 22.15          
ATOM    678  O   ASP    72     -31.034  97.497  28.625  1.00 23.16          
ATOM    680  N   ALA    73     -29.809  98.782  29.945  1.00 21.79          
ATOM    681  CA  ALA    73     -28.591  98.081  29.685  1.00 21.44          
ATOM    683  CB  ALA    73     -27.431  98.783  30.436  1.00 20.97          
ATOM    687  C   ALA    73     -28.700  96.590  30.095  1.00 21.85          
ATOM    688  O   ALA    73     -27.919  95.788  29.623  1.00 20.76          
ATOM    690  N   ASP    74     -29.630  96.237  30.997  1.00 22.22          
ATOM    691  CA  ASP    74     -29.750  94.857  31.470  1.00 23.54          
ATOM    693  CB  ASP    74     -29.886  94.810  32.985  1.00 23.82          
ATOM    696  CG  ASP    74     -28.784  95.618  33.696  1.00 28.77          
ATOM    697  OD1 ASP    74     -29.186  96.333  34.670  1.00 34.27          
ATOM    698  OD2 ASP    74     -27.556  95.561  33.294  1.00 29.12          
ATOM    699  C   ASP    74     -30.896  94.104  30.793  1.00 23.04          
ATOM    700  O   ASP    74     -31.244  92.988  31.192  1.00 22.85          
ATOM    702  N   SER    75     -31.474  94.734  29.777  1.00 22.85          
ATOM    703  CA  SER    75     -32.544  94.139  29.053  1.00 22.91          
ATOM    705  CB  SER    75     -33.246  95.169  28.172  1.00 23.24          
ATOM    708  OG  SER    75     -34.064  94.523  27.198  1.00 22.89          
ATOM    710  C   SER    75     -31.965  93.071  28.176  1.00 22.93          
ATOM    711  O   SER    75     -30.951  93.307  27.505  1.00 22.07          
ATOM    713  N   ASN    76     -32.664  91.933  28.118  1.00 22.63          
ATOM    714  CA  ASN    76     -32.244  90.843  27.259  1.00 22.95          
ATOM    716  CB  ASN    76     -32.966  89.545  27.612  1.00 24.11          
ATOM    719  CG  ASN    76     -32.336  88.850  28.783  1.00 26.98          
ATOM    720  OD1 ASN    76     -31.113  88.563  28.782  1.00 33.45          
ATOM    721  ND2 ASN    76     -33.158  88.541  29.789  1.00 30.14          
ATOM    724  C   ASN    76     -32.413  91.104  25.793  1.00 21.54          
ATOM    725  O   ASN    76     -31.859  90.375  25.007  1.00 21.30          
ATOM    727  N   ASP    77     -33.184  92.111  25.418  1.00 20.44          
ATOM    728  CA  ASP    77     -33.321  92.434  24.029  1.00 20.82          
ATOM    730  CB  ASP    77     -34.588  93.263  23.761  1.00 21.94          
ATOM    733  CG  ASP    77     -35.898  92.516  24.107  1.00 26.35          
ATOM    734  OD1 ASP    77     -35.962  91.239  24.040  1.00 30.79          
ATOM    735  OD2 ASP    77     -36.896  93.238  24.439  1.00 32.58          
ATOM    736  C   ASP    77     -32.091  93.168  23.480  1.00 19.61          
ATOM    737  O   ASP    77     -31.919  93.204  22.283  1.00 19.66          
ATOM    739  N   LEU    78     -31.251  93.749  24.344  1.00 18.80          
ATOM    740  CA  LEU    78     -30.023  94.404  23.932  1.00 17.27          
ATOM    742  CB  LEU    78     -29.623  95.472  24.947  1.00 16.54          
ATOM    745  CG  LEU    78     -28.321  96.230  24.692  1.00 13.70          
ATOM    747  CD1 LEU    78     -28.422  97.110  23.477  1.00  8.97          
ATOM    751  CD2 LEU    78     -27.875  97.031  25.932  1.00 13.55          
ATOM    755  C   LEU    78     -28.910  93.397  23.812  1.00 17.24          
ATOM    756  O   LEU    78     -28.530  92.762  24.795  1.00 17.67          
ATOM    758  N   LYS    79     -28.312  93.302  22.622  1.00 16.68          
ATOM    759  CA  LYS    79     -27.199  92.370  22.384  1.00 15.82          
ATOM    761  CB  LYS    79     -27.528  91.369  21.270  1.00 15.73          
ATOM    764  CG  LYS    79     -28.877  90.676  21.388  1.00 16.59          
ATOM    767  CD  LYS    79     -28.974  89.712  22.499  1.00 18.06          
ATOM    770  CE  LYS    79     -30.109  88.683  22.212  1.00 18.62          
ATOM    773  NZ  LYS    79     -31.314  89.066  22.909  1.00 17.95          
ATOM    777  C   LYS    79     -25.857  93.002  22.030  1.00 15.41          
ATOM    778  O   LYS    79     -24.845  92.355  22.179  1.00 15.62          
ATOM    780  N   VAL    80     -25.854  94.222  21.505  1.00 15.50          
ATOM    781  CA  VAL    80     -24.634  94.872  21.046  1.00 15.60          
ATOM    783  CB  VAL    80     -24.067  94.182  19.722  1.00 16.76          
ATOM    785  CG1 VAL    80     -25.070  94.308  18.564  1.00 13.79          
ATOM    789  CG2 VAL    80     -22.644  94.724  19.295  1.00 12.47          
ATOM    793  C   VAL    80     -24.910  96.353  20.822  1.00 16.02          
ATOM    794  O   VAL    80     -26.008  96.732  20.471  1.00 16.93          
ATOM    796  N   ILE    81     -23.877  97.178  20.990  1.00 16.52          
ATOM    797  CA  ILE    81     -23.916  98.629  20.694  1.00 15.56          
ATOM    799  CB  ILE    81     -23.690  99.507  21.943  1.00 15.15          
ATOM    801  CG1 ILE    81     -24.768  99.260  23.001  1.00 14.39          
ATOM    804  CD  ILE    81     -24.524  99.793  24.350  1.00 11.87          
ATOM    808  CG2 ILE    81     -23.720 100.927  21.527  1.00 15.92          
ATOM    812  C   ILE    81     -22.909  99.028  19.600  1.00 15.42          
ATOM    813  O   ILE    81     -21.760  98.607  19.626  1.00 15.24          
ATOM    815  N   ILE    82     -23.363  99.853  18.649  1.00 14.63          
ATOM    816  CA  ILE    82     -22.498 100.522  17.680  1.00 14.36          
ATOM    818  CB  ILE    82     -22.980 100.304  16.200  1.00 15.79          
ATOM    820  CG1 ILE    82     -23.053  98.806  15.843  1.00 15.81          
ATOM    823  CD  ILE    82     -23.912  98.475  14.628  1.00 16.96          
ATOM    827  CG2 ILE    82     -22.056 101.060  15.234  1.00 14.37          
ATOM    831  C   ILE    82     -22.516 102.016  17.977  1.00 14.01          
ATOM    832  O   ILE    82     -23.555 102.590  18.029  1.00 12.00          
ATOM    834  N   ILE    83     -21.361 102.641  18.257  1.00 15.53          
ATOM    835  CA  ILE    83     -21.295 104.105  18.325  1.00 15.80          
ATOM    837  CB  ILE    83     -20.506 104.634  19.502  1.00 17.01          
ATOM    839  CG1 ILE    83     -21.069 104.097  20.819  1.00 17.25          
ATOM    842  CD  ILE    83     -20.076 104.162  22.048  1.00 18.56          
ATOM    846  CG2 ILE    83     -20.575 106.163  19.466  1.00 18.42          
ATOM    850  C   ILE    83     -20.693 104.607  17.020  1.00 16.12          
ATOM    851  O   ILE    83     -19.551 104.235  16.717  1.00 16.77          
ATOM    853  N   SER    84     -21.494 105.381  16.241  1.00 15.80          
ATOM    854  CA  SER    84     -21.076 106.080  15.032  1.00 16.15          
ATOM    856  CB  SER    84     -21.795 105.512  13.784  1.00 16.26          
ATOM    859  OG  SER    84     -23.117 105.324  14.014  1.00 13.91          
ATOM    861  C   SER    84     -21.340 107.580  15.115  1.00 16.70          
ATOM    862  O   SER    84     -21.732 108.078  16.160  1.00 13.67          
ATOM    864  N   ALA    85     -21.143 108.292  13.990  1.00 17.33          
ATOM    865  CA  ALA    85     -21.328 109.742  13.980  1.00 18.13          
ATOM    867  CB  ALA    85     -20.003 110.477  14.422  1.00 16.26          
ATOM    871  C   ALA    85     -21.818 110.265  12.627  1.00 18.58          
ATOM    872  O   ALA    85     -21.481 109.703  11.609  1.00 18.18          
ATOM    874  N   GLU    86     -22.588 111.367  12.663  1.00 19.55          
ATOM    875  CA  GLU    86     -23.096 112.098  11.481  1.00 20.31          
ATOM    877  CB  GLU    86     -24.170 113.112  11.933  1.00 21.00          
ATOM    880  CG  GLU    86     -25.599 113.067  11.409  1.00 23.95          
ATOM    883  CD  GLU    86     -26.391 114.364  11.807  1.00 28.72          
ATOM    884  OE1 GLU    86     -26.253 114.814  12.977  1.00 31.93          
ATOM    885  OE2 GLU    86     -27.118 114.972  10.952  1.00 31.70          
ATOM    886  C   GLU    86     -21.929 112.919  10.916  1.00 19.87          
ATOM    887  O   GLU    86     -21.230 113.606  11.651  1.00 18.05          
ATOM    889  N   GLY    87     -21.712 112.845   9.619  1.00 19.92          
ATOM    890  CA  GLY    87     -20.790 113.770   8.983  1.00 20.95          
ATOM    893  C   GLY    87     -19.335 113.339   9.028  1.00 21.41          
ATOM    894  O   GLY    87     -19.021 112.263   9.522  1.00 22.86          
ATOM    896  N   PRO    88     -18.435 114.181   8.506  1.00 21.29          
ATOM    897  CA  PRO    88     -17.064 113.774   8.110  1.00 20.91          
ATOM    899  CB  PRO    88     -16.718 114.801   7.035  1.00 20.21          
ATOM    902  CG  PRO    88     -17.484 116.017   7.442  1.00 20.92          
ATOM    905  CD  PRO    88     -18.780 115.518   7.976  1.00 20.77          
ATOM    908  C   PRO    88     -15.973 113.805   9.177  1.00 20.24          
ATOM    909  O   PRO    88     -14.824 113.450   8.903  1.00 19.80          
ATOM    910  N   VAL    89     -16.345 114.315  10.343  1.00 20.65          
ATOM    911  CA  VAL    89     -15.578 114.291  11.576  1.00 18.88          
ATOM    913  CB  VAL    89     -15.432 115.702  12.208  1.00 18.80          
ATOM    915  CG1 VAL    89     -14.743 115.625  13.537  1.00 16.50          
ATOM    919  CG2 VAL    89     -14.658 116.670  11.253  1.00 13.64          
ATOM    923  C   VAL    89     -16.376 113.390  12.498  1.00 20.43          
ATOM    924  O   VAL    89     -17.589 113.534  12.580  1.00 21.91          
ATOM    926  N   PHE    90     -15.695 112.468  13.184  1.00 19.72          
ATOM    927  CA  PHE    90     -16.301 111.531  14.041  1.00 19.43          
ATOM    929  CB  PHE    90     -15.414 110.245  14.121  1.00 19.48          
ATOM    932  CG  PHE    90     -15.877 109.287  15.158  1.00 20.01          
ATOM    933  CD1 PHE    90     -16.872 108.362  14.868  1.00 17.39          
ATOM    935  CE1 PHE    90     -17.370 107.504  15.841  1.00 18.93          
ATOM    937  CZ  PHE    90     -16.911 107.558  17.103  1.00 16.39          
ATOM    939  CE2 PHE    90     -15.896 108.507  17.428  1.00 18.94          
ATOM    941  CD2 PHE    90     -15.408 109.370  16.462  1.00 16.60          
ATOM    943  C   PHE    90     -16.550 112.239  15.403  1.00 21.11          
ATOM    944  O   PHE    90     -17.689 112.292  15.908  1.00 22.10          
ATOM    946  N   SER    91     -15.482 112.766  15.998  1.00 20.30          
ATOM    947  CA  SER    91     -15.576 113.800  17.007  1.00 20.57          
ATOM    949  CB  SER    91     -15.752 113.196  18.379  1.00 20.84          
ATOM    952  OG  SER    91     -15.846 114.234  19.320  1.00 22.57          
ATOM    954  C   SER    91     -14.248 114.511  17.033  1.00 21.11          
ATOM    955  O   SER    91     -13.221 113.881  16.841  1.00 21.08          
ATOM    957  N   SER    92     -14.277 115.783  17.401  1.00 21.15          
ATOM    958  CA  SER    92     -13.105 116.632  17.515  1.00 21.23          
ATOM    960  CB  SER    92     -13.489 118.059  17.139  1.00 20.94          
ATOM    963  OG  SER    92     -14.589 118.564  17.943  1.00 21.78          
ATOM    965  C   SER    92     -12.575 116.624  18.946  1.00 21.25          
ATOM    966  O   SER    92     -11.535 117.223  19.235  1.00 22.40          
ATOM    968  N   GLY    93     -13.301 115.985  19.841  1.00 20.58          
ATOM    969  CA  GLY    93     -12.948 115.936  21.260  1.00 19.95          
ATOM    972  C   GLY    93     -13.750 116.972  22.009  1.00 19.47          
ATOM    973  O   GLY    93     -14.794 117.442  21.566  1.00 20.34          
ATOM    975  N   HSD    94     -13.252 117.343  23.149  1.00 19.02          
ATOM    976  CA  HSD    94     -13.913 118.258  24.010  1.00 18.65          
ATOM    978  CB  HSD    94     -13.212 118.340  25.388  1.00 18.04          
ATOM    981  CG  HSD    94     -13.222 117.059  26.144  1.00 17.83          
ATOM    982  ND1 HSD    94     -14.362 116.316  26.320  1.00 19.55          
ATOM    984  CE1 HSD    94     -14.074 115.230  27.024  1.00 19.25          
ATOM    986  NE2 HSD    94     -12.801 115.280  27.377  1.00 19.12          
ATOM    988  CD2 HSD    94     -12.241 116.403  26.821  1.00 20.68          
ATOM    990  C   HSD    94     -13.972 119.647  23.426  1.00 18.42          
ATOM    991  O   HSD    94     -13.158 120.042  22.633  1.00 17.03          
ATOM    993  N   ASP    95     -15.017 120.360  23.847  1.00 19.61          
ATOM    994  CA  ASP    95     -15.202 121.784  23.545  1.00 19.31          
ATOM    996  CB  ASP    95     -16.648 122.164  23.827  1.00 19.16          
ATOM    999  CG  ASP    95     -17.011 123.572  23.311  1.00 21.32          
ATOM   1000  OD1 ASP    95     -16.166 124.344  22.761  1.00 22.64          
ATOM   1001  OD2 ASP    95     -18.190 123.904  23.461  1.00 24.08          
ATOM   1002  C   ASP    95     -14.290 122.653  24.378  1.00 18.37          
ATOM   1003  O   ASP    95     -14.398 122.688  25.598  1.00 18.35          
ATOM   1005  N   LEU    96     -13.401 123.378  23.732  1.00 18.38          
ATOM   1006  CA  LEU    96     -12.454 124.159  24.476  1.00 18.46          
ATOM   1008  CB  LEU    96     -11.342 124.659  23.572  1.00 18.82          
ATOM   1011  CG  LEU    96     -10.536 123.507  22.924  1.00 20.57          
ATOM   1013  CD1 LEU    96      -9.523 124.069  21.931  1.00 18.98          
ATOM   1017  CD2 LEU    96      -9.895 122.528  23.976  1.00 16.21          
ATOM   1021  C   LEU    96     -13.061 125.301  25.247  1.00 18.43          
ATOM   1022  O   LEU    96     -12.463 125.725  26.223  1.00 19.95          
ATOM   1024  N   LYS    97     -14.238 125.786  24.858  1.00 17.91          
ATOM   1025  CA  LYS    97     -14.921 126.857  25.603  1.00 18.00          
ATOM   1027  CB  LYS    97     -16.187 127.275  24.892  1.00 18.56          
ATOM   1030  CG  LYS    97     -15.959 127.874  23.482  1.00 19.92          
ATOM   1033  CD  LYS    97     -17.219 128.444  22.945  1.00 25.08          
ATOM   1036  CE  LYS    97     -17.489 127.989  21.508  1.00 27.41          
ATOM   1039  NZ  LYS    97     -17.434 126.508  21.314  1.00 24.52          
ATOM   1043  C   LYS    97     -15.276 126.479  27.029  1.00 18.48          
ATOM   1044  O   LYS    97     -15.389 127.335  27.890  1.00 17.64          
ATOM   1046  N   GLU    98     -15.406 125.165  27.260  1.00 19.13          
ATOM   1047  CA  GLU    98     -15.696 124.570  28.531  1.00 18.89          
ATOM   1049  CB  GLU    98     -16.448 123.268  28.308  1.00 20.08          
ATOM   1052  CG  GLU    98     -17.862 123.418  27.722  1.00 20.54          
ATOM   1055  CD  GLU    98     -18.743 122.139  27.922  1.00 21.91          
ATOM   1056  OE1 GLU    98     -18.271 121.035  27.670  1.00 21.23          
ATOM   1057  OE2 GLU    98     -19.924 122.226  28.330  1.00 28.69          
ATOM   1059  O   GLU    98     -14.760 124.443  30.541  1.00 10.39          
ATOM   1061  N   LEU    99     -13.540 124.717  29.023  1.00 13.44          
ATOM   1062  CA  LEU    99     -12.160 124.599  29.448  1.00 14.57          
ATOM   1064  CB  LEU    99     -11.425 123.586  28.556  1.00 13.88          
ATOM   1067  CG  LEU    99     -12.151 122.212  28.425  1.00 14.81          
ATOM   1069  CD1 LEU    99     -11.306 121.277  27.604  1.00 11.91          
ATOM   1073  CD2 LEU    99     -12.636 121.513  29.804  1.00 11.10          
ATOM   1077  C   LEU    99     -11.334 125.898  29.709  1.00 14.60          
ATOM   1078  O   LEU    99     -10.171 125.850  30.155  1.00 15.08          
ATOM   1080  N   THR   100     -11.960 127.042  29.512  1.00 14.98          
ATOM   1081  CA  THR   100     -11.367 128.347  29.722  1.00 14.61          
ATOM   1083  CB  THR   100     -12.111 129.442  28.938  1.00 14.62          
ATOM   1085  OG1 THR   100     -13.460 129.486  29.403  1.00 16.09          
ATOM   1087  CG2 THR   100     -12.108 129.222  27.413  1.00 12.66          
ATOM   1091  C   THR   100     -11.446 128.616  31.225  1.00 15.75          
ATOM   1092  O   THR   100     -12.296 128.057  31.918  1.00 15.40          
ATOM   1094  N   GLU   101     -10.519 129.422  31.723  1.00 16.75          
ATOM   1095  CA  GLU   101     -10.300 129.624  33.158  1.00 18.54          
ATOM   1097  CB  GLU   101      -9.309 130.784  33.353  1.00 18.95          
ATOM   1100  CG  GLU   101      -9.001 131.077  34.834  1.00 22.65          
ATOM   1103  CD  GLU   101      -8.032 132.231  35.060  1.00 29.16          
ATOM   1104  OE1 GLU   101      -7.267 132.606  34.119  1.00 32.26          
ATOM   1105  OE2 GLU   101      -8.025 132.771  36.207  1.00 34.97          
ATOM   1106  C   GLU   101     -11.574 129.957  33.914  1.00 18.85          
ATOM   1107  O   GLU   101     -11.785 129.513  35.024  1.00 19.24          
ATOM   1109  N   GLU   102     -12.376 130.809  33.295  1.00 19.48          
ATOM   1110  CA  GLU   102     -13.613 131.343  33.814  1.00 20.28          
ATOM   1112  CB  GLU   102     -14.160 132.354  32.785  1.00 21.28          
ATOM   1115  CG  GLU   102     -14.209 131.851  31.283  1.00 24.17          
ATOM   1118  CD  GLU   102     -13.063 132.402  30.307  1.00 29.37          
ATOM   1119  OE1 GLU   102     -11.828 132.567  30.753  1.00 25.64          
ATOM   1120  OE2 GLU   102     -13.436 132.634  29.075  1.00 28.75          
ATOM   1121  C   GLU   102     -14.688 130.295  34.206  1.00 20.36          
ATOM   1122  O   GLU   102     -15.533 130.559  35.055  1.00 20.79          
ATOM   1124  N   GLN   103     -14.620 129.103  33.632  1.00 19.97          
ATOM   1125  CA  GLN   103     -15.564 128.054  33.929  1.00 19.27          
ATOM   1127  CB  GLN   103     -15.493 126.951  32.879  1.00 18.37          
ATOM   1130  CG  GLN   103     -15.787 127.389  31.400  1.00 17.59          
ATOM   1133  CD  GLN   103     -17.184 127.918  31.150  1.00 15.51          
ATOM   1134  OE1 GLN   103     -17.995 128.061  32.091  1.00 11.69          
ATOM   1135  NE2 GLN   103     -17.483 128.225  29.851  1.00 10.46          
ATOM   1138  C   GLN   103     -15.307 127.493  35.302  1.00 18.92          
ATOM   1139  O   GLN   103     -16.216 126.940  35.921  1.00 19.77          
ATOM   1141  N   GLY   104     -14.085 127.649  35.783  1.00 18.10          
ATOM   1142  CA  GLY   104     -13.692 127.120  37.064  1.00 17.66          
ATOM   1145  C   GLY   104     -13.260 125.673  36.935  1.00 17.90          
ATOM   1146  O   GLY   104     -13.673 124.953  36.033  1.00 18.12          
ATOM   1148  N   ARG   105     -12.419 125.268  37.862  1.00 17.60          
ATOM   1149  CA  ARG   105     -11.850 123.943  37.905  1.00 18.31          
ATOM   1151  CB  ARG   105     -10.785 123.846  39.046  1.00 18.56          
ATOM   1154  CG  ARG   105      -9.597 124.622  38.911  1.00 18.52          
ATOM   1157  CD  ARG   105      -8.680 124.452  40.161  1.00 20.52          
ATOM   1160  NE  ARG   105      -8.054 123.166  40.123  1.00 18.48          
ATOM   1162  CZ  ARG   105      -6.790 122.867  39.821  1.00 13.75          
ATOM   1163  NH1 ARG   105      -5.866 123.743  39.483  1.00 11.33          
ATOM   1166  NH2 ARG   105      -6.464 121.606  39.843  1.00 12.71          
ATOM   1169  C   ARG   105     -12.866 122.841  38.195  1.00 17.38          
ATOM   1170  O   ARG   105     -12.644 121.738  37.811  1.00 17.17          
ATOM   1172  N   ASP   106     -13.894 123.121  38.980  1.00 16.80          
ATOM   1173  CA  ASP   106     -14.987 122.176  39.203  1.00 18.17          
ATOM   1175  CB  ASP   106     -16.037 122.801  40.117  1.00 19.03          
ATOM   1178  CG  ASP   106     -15.648 122.794  41.617  1.00 20.77          
ATOM   1179  OD1 ASP   106     -14.523 122.405  41.987  1.00 21.59          
ATOM   1180  OD2 ASP   106     -16.528 123.183  42.427  1.00 26.31          
ATOM   1181  C   ASP   106     -15.662 121.754  37.891  1.00 17.79          
ATOM   1182  O   ASP   106     -15.933 120.560  37.654  1.00 18.16          
ATOM   1184  N   TYR   107     -15.946 122.741  37.052  1.00 17.38          
ATOM   1185  CA  TYR   107     -16.546 122.486  35.733  1.00 17.07          
ATOM   1187  CB  TYR   107     -16.974 123.803  35.059  1.00 16.22          
ATOM   1190  CG  TYR   107     -17.938 123.593  33.901  1.00 17.26          
ATOM   1191  CD1 TYR   107     -19.301 123.391  34.120  1.00 18.97          
ATOM   1193  CE1 TYR   107     -20.171 123.222  33.089  1.00 16.44          
ATOM   1195  CZ  TYR   107     -19.689 123.179  31.795  1.00 16.92          
ATOM   1196  OH  TYR   107     -20.553 123.019  30.702  1.00 19.19          
ATOM   1198  CE2 TYR   107     -18.369 123.359  31.567  1.00 16.10          
ATOM   1200  CD2 TYR   107     -17.500 123.582  32.593  1.00 14.19          
ATOM   1202  C   TYR   107     -15.582 121.705  34.854  1.00 16.43          
ATOM   1203  O   TYR   107     -15.959 120.768  34.215  1.00 15.44          
ATOM   1205  N   HSD   108     -14.322 122.108  34.838  1.00 16.53          
ATOM   1206  CA  HSD   108     -13.307 121.377  34.111  1.00 15.88          
ATOM   1208  CB  HSD   108     -11.916 121.949  34.329  1.00 16.59          
ATOM   1211  CG  HSD   108     -11.718 123.383  33.917  1.00 16.50          
ATOM   1212  ND1 HSD   108     -10.588 124.083  34.293  1.00 15.51          
ATOM   1214  CE1 HSD   108     -10.637 125.301  33.769  1.00 16.01          
ATOM   1216  NE2 HSD   108     -11.757 125.417  33.086  1.00 15.37          
ATOM   1218  CD2 HSD   108     -12.459 124.234  33.166  1.00 16.00          
ATOM   1220  C   HSD   108     -13.235 119.921  34.646  1.00 15.19          
ATOM   1221  O   HSD   108     -13.155 118.995  33.914  1.00 14.28          
ATOM   1223  N   ALA   109     -13.224 119.734  35.940  1.00 15.65          
ATOM   1224  CA  ALA   109     -13.156 118.385  36.471  1.00 16.05          
ATOM   1226  CB  ALA   109     -12.982 118.414  37.948  1.00 15.64          
ATOM   1230  C   ALA   109     -14.389 117.577  36.057  1.00 16.76          
ATOM   1231  O   ALA   109     -14.296 116.376  35.833  1.00 16.84          
ATOM   1233  N   GLU   110     -15.530 118.244  35.907  1.00 18.11          
ATOM   1234  CA  GLU   110     -16.763 117.601  35.509  1.00 19.64          
ATOM   1236  CB  GLU   110     -17.944 118.562  35.725  1.00 20.98          
ATOM   1239  CG  GLU   110     -19.263 117.914  35.603  1.00 24.86          
ATOM   1242  CD  GLU   110     -20.462 118.763  36.071  1.00 31.30          
ATOM   1243  OE1 GLU   110     -20.310 119.940  36.553  1.00 33.93          
ATOM   1244  OE2 GLU   110     -21.590 118.225  35.910  1.00 33.70          
ATOM   1245  C   GLU   110     -16.703 117.087  34.095  1.00 19.32          
ATOM   1246  O   GLU   110     -17.168 116.035  33.832  1.00 19.73          
ATOM   1248  N   VAL   111     -16.090 117.823  33.180  1.00 19.93          
ATOM   1249  CA  VAL   111     -16.036 117.395  31.781  1.00 19.74          
ATOM   1251  CB  VAL   111     -15.417 118.506  30.864  1.00 18.83          
ATOM   1253  CG1 VAL   111     -15.077 117.966  29.594  1.00 17.21          
ATOM   1257  CG2 VAL   111     -16.404 119.747  30.729  1.00 18.98          
ATOM   1261  C   VAL   111     -15.230 116.100  31.695  1.00 19.31          
ATOM   1262  O   VAL   111     -15.681 115.136  31.122  1.00 19.55          
ATOM   1264  N   PHE   112     -14.048 116.102  32.277  1.00 19.15          
ATOM   1265  CA  PHE   112     -13.133 114.989  32.241  1.00 18.93          
ATOM   1267  CB  PHE   112     -11.763 115.437  32.754  1.00 19.07          
ATOM   1270  CG  PHE   112     -11.146 116.497  31.920  1.00 19.16          
ATOM   1271  CD1 PHE   112     -10.959 116.293  30.542  1.00 17.43          
ATOM   1273  CE1 PHE   112     -10.449 117.314  29.729  1.00 11.85          
ATOM   1275  CZ  PHE   112     -10.076 118.473  30.281  1.00 14.99          
ATOM   1277  CE2 PHE   112     -10.200 118.670  31.681  1.00 17.71          
ATOM   1279  CD2 PHE   112     -10.742 117.696  32.482  1.00 15.39          
ATOM   1281  C   PHE   112     -13.571 113.807  33.093  1.00 19.61          
ATOM   1282  O   PHE   112     -13.400 112.701  32.662  1.00 19.84          
ATOM   1284  N   GLN   113     -14.038 114.020  34.333  1.00 19.47          
ATOM   1285  CA  GLN   113     -14.712 112.919  35.058  1.00 20.19          
ATOM   1287  CB  GLN   113     -15.147 113.356  36.462  1.00 21.12          
ATOM   1290  CG  GLN   113     -13.895 113.637  37.417  1.00 24.34          
ATOM   1293  CD  GLN   113     -14.303 114.291  38.712  1.00 28.02          
ATOM   1294  OE1 GLN   113     -15.481 114.613  38.900  1.00 34.19          
ATOM   1295  NE2 GLN   113     -13.346 114.493  39.629  1.00 29.41          
ATOM   1298  C   GLN   113     -15.908 112.231  34.303  1.00 20.00          
ATOM   1299  O   GLN   113     -16.072 111.020  34.374  1.00 19.33          
ATOM   1301  N   THR   114     -16.704 112.989  33.569  1.00 19.93          
ATOM   1302  CA  THR   114     -17.845 112.436  32.832  1.00 18.45          
ATOM   1304  CB  THR   114     -18.870 113.557  32.392  1.00 18.41          
ATOM   1306  OG1 THR   114     -19.130 114.379  33.508  1.00 19.14          
ATOM   1308  CG2 THR   114     -20.240 112.995  31.904  1.00 15.13          
ATOM   1312  C   THR   114     -17.408 111.680  31.629  1.00 18.45          
ATOM   1313  O   THR   114     -18.021 110.672  31.235  1.00 18.46          
ATOM   1315  N   CYS   115     -16.405 112.205  30.969  1.00 17.05          
ATOM   1316  CA  CYS   115     -15.829 111.473  29.904  1.00 17.54          
ATOM   1318  CB  CYS   115     -14.759 112.350  29.292  1.00 18.42          
ATOM   1321  SG  CYS   115     -14.293 111.722  27.701  1.00 19.64          
ATOM   1323  C   CYS   115     -15.216 110.103  30.355  1.00 17.36          
ATOM   1324  O   CYS   115     -15.361 109.073  29.671  1.00 17.12          
ATOM   1326  N   SER   116     -14.533 110.100  31.516  1.00 16.47          
ATOM   1327  CA  SER   116     -13.910 108.902  32.049  1.00 16.74          
ATOM   1329  CB  SER   116     -12.991 109.261  33.235  1.00 18.02          
ATOM   1332  OG  SER   116     -11.972 110.188  32.826  1.00 19.25          
ATOM   1334  C   SER   116     -14.951 107.854  32.442  1.00 17.27          
ATOM   1335  O   SER   116     -14.746 106.695  32.185  1.00 18.02          
ATOM   1337  N   LYS   117     -16.017 108.248  33.143  1.00 17.76          
ATOM   1338  CA  LYS   117     -17.198 107.433  33.391  1.00 17.73          
ATOM   1340  CB  LYS   117     -18.288 108.271  34.036  1.00 18.80          
ATOM   1343  CG  LYS   117     -18.214 108.465  35.557  1.00 22.09          
ATOM   1346  CD  LYS   117     -19.399 109.382  35.976  1.00 29.44          
ATOM   1349  CE  LYS   117     -20.799 108.670  35.829  1.00 35.03          
ATOM   1352  NZ  LYS   117     -21.979 109.160  36.673  1.00 35.49          
ATOM   1356  C   LYS   117     -17.806 106.832  32.099  1.00 16.56          
ATOM   1357  O   LYS   117     -18.183 105.702  32.117  1.00 16.05          
ATOM   1359  N   VAL   118     -17.909 107.594  31.018  1.00 15.45          
ATOM   1360  CA  VAL   118     -18.408 107.055  29.765  1.00 16.58          
ATOM   1362  CB  VAL   118     -18.569 108.102  28.639  1.00 17.05          
ATOM   1364  CG1 VAL   118     -18.796 107.399  27.267  1.00 16.04          
ATOM   1368  CG2 VAL   118     -19.803 109.032  28.946  1.00 16.61          
ATOM   1372  C   VAL   118     -17.544 105.907  29.283  1.00 17.33          
ATOM   1373  O   VAL   118     -18.050 104.859  28.958  1.00 17.93          
ATOM   1375  N   MET   119     -16.232 106.124  29.277  1.00 17.29          
ATOM   1376  CA  MET   119     -15.268 105.152  28.901  1.00 16.83          
ATOM   1378  CB  MET   119     -13.847 105.771  29.086  1.00 18.48          
ATOM   1381  CG  MET   119     -13.346 106.789  27.945  1.00 17.68          
ATOM   1384  SD  MET   119     -14.396 106.780  26.536  1.00 25.44          
ATOM   1385  CE  MET   119     -14.656 108.485  26.051  1.00 25.86          
ATOM   1389  C   MET   119     -15.384 103.882  29.725  1.00 17.68          
ATOM   1390  O   MET   119     -15.300 102.785  29.203  1.00 16.23          
ATOM   1392  N   MET   120     -15.530 104.054  31.038  1.00 17.82          
ATOM   1393  CA  MET   120     -15.646 102.962  31.953  1.00 17.90          
ATOM   1395  CB  MET   120     -15.541 103.449  33.405  1.00 18.49          
ATOM   1398  CG  MET   120     -14.183 103.992  33.856  1.00 20.43          
ATOM   1401  SD  MET   120     -12.763 102.963  33.490  1.00 27.50          
ATOM   1402  CE  MET   120     -13.154 101.506  34.487  1.00 23.80          
ATOM   1406  C   MET   120     -16.976 102.242  31.806  1.00 18.07          
ATOM   1407  O   MET   120     -17.056 101.074  32.114  1.00 18.76          
ATOM   1409  N   HSD   121     -18.020 102.936  31.379  1.00 18.02          
ATOM   1410  CA  HSD   121     -19.310 102.326  31.191  1.00 16.84          
ATOM   1412  CB  HSD   121     -20.401 103.380  30.986  1.00 16.90          
ATOM   1415  CG  HSD   121     -20.886 104.029  32.249  1.00 15.18          
ATOM   1416  ND1 HSD   121     -21.278 103.309  33.350  1.00 17.39          
ATOM   1418  CE1 HSD   121     -21.695 104.137  34.298  1.00 19.88          
ATOM   1420  NE2 HSD   121     -21.639 105.370  33.820  1.00 19.45          
ATOM   1422  CD2 HSD   121     -21.103 105.327  32.553  1.00 15.34          
ATOM   1424  C   HSD   121     -19.233 101.442  29.958  1.00 17.12          
ATOM   1425  O   HSD   121     -19.898 100.408  29.892  1.00 17.67          
ATOM   1427  N   ILE   122     -18.502 101.874  28.948  1.00 16.86          
ATOM   1428  CA  ILE   122     -18.306 101.064  27.715  1.00 15.65          
ATOM   1430  CB  ILE   122     -17.560 101.861  26.674  1.00 15.30          
ATOM   1432  CG1 ILE   122     -18.452 103.000  26.114  1.00 16.20          
ATOM   1435  CD  ILE   122     -17.690 103.930  25.081  1.00 12.70          
ATOM   1439  CG2 ILE   122     -16.998 100.971  25.496  1.00 14.97          
ATOM   1443  C   ILE   122     -17.555  99.752  28.097  1.00 15.69          
ATOM   1444  O   ILE   122     -17.972  98.646  27.746  1.00 17.26          
ATOM   1446  N   ARG   123     -16.481  99.880  28.863  1.00 15.27          
ATOM   1447  CA  ARG   123     -15.686  98.739  29.305  0.50 14.81          
ATOM   1451  CB  ARG   123     -14.432  99.242  30.018  0.50 14.77          
ATOM   1457  CG  ARG   123     -13.518  98.121  30.561  0.50 13.13          
ATOM   1463  CD  ARG   123     -13.132  98.482  31.954  0.50 10.58          
ATOM   1469  NE  ARG   123     -11.975  97.751  32.467  0.50 13.44          
ATOM   1473  CZ  ARG   123     -12.032  96.946  33.510  0.50  9.28          
ATOM   1475  NH1 ARG   123     -13.172  96.775  34.116  0.50  6.74          
ATOM   1481  NH2 ARG   123     -10.967  96.293  33.887  0.50 11.97          
ATOM   1487  C   ARG   123     -16.410  97.757  30.213  1.00 15.26          
ATOM   1488  O   ARG   123     -16.192  96.552  30.115  1.00 14.36          
ATOM   1490  N   ASN   124     -17.205  98.288  31.139  1.00 15.97          
ATOM   1491  CA  ASN   124     -17.955  97.518  32.062  1.00 16.12          
ATOM   1493  CB  ASN   124     -18.005  98.262  33.361  1.00 16.76          
ATOM   1496  CG  ASN   124     -16.642  98.358  34.019  1.00 17.50          
ATOM   1497  OD1 ASN   124     -15.867  97.451  33.968  1.00 22.01          
ATOM   1498  ND2 ASN   124     -16.384  99.436  34.661  1.00 20.81          
ATOM   1501  C   ASN   124     -19.372  97.139  31.575  1.00 16.10          
ATOM   1502  O   ASN   124     -20.131  96.542  32.309  1.00 15.88          
ATOM   1504  N   HSD   125     -19.703  97.442  30.336  1.00 16.02          
ATOM   1505  CA  HSD   125     -21.006  97.198  29.804  1.00 15.87          
ATOM   1507  CB  HSD   125     -21.182  97.819  28.406  1.00 16.42          
ATOM   1510  CG  HSD   125     -22.595  98.294  28.145  1.00 17.72          
ATOM   1511  ND1 HSD   125     -23.591  97.471  27.649  1.00 20.32          
ATOM   1513  CE1 HSD   125     -24.728  98.144  27.578  1.00 20.03          
ATOM   1515  NE2 HSD   125     -24.512  99.385  27.985  1.00 17.52          
ATOM   1517  CD2 HSD   125     -23.184  99.504  28.354  1.00 18.22          
ATOM   1519  C   HSD   125     -21.288  95.703  29.677  1.00 17.08          
ATOM   1520  O   HSD   125     -20.352  94.926  29.505  1.00 17.32          
ATOM   1522  N   PRO   126     -22.592  95.291  29.761  1.00 15.94          
ATOM   1523  CA  PRO   126     -22.859  93.897  29.646  1.00 15.53          
ATOM   1525  CB  PRO   126     -24.244  93.788  30.191  1.00 15.78          
ATOM   1528  CG  PRO   126     -24.607  95.092  30.745  1.00 15.31          
ATOM   1531  CD  PRO   126     -23.543  95.966  30.660  1.00 15.45          
ATOM   1534  C   PRO   126     -22.760  93.357  28.190  1.00 15.77          
ATOM   1535  O   PRO   126     -22.646  92.151  28.000  1.00 15.83          
ATOM   1536  N   VAL   127     -22.829  94.237  27.204  1.00 15.26          
ATOM   1537  CA  VAL   127     -22.769  93.868  25.821  1.00 14.48          
ATOM   1539  CB  VAL   127     -24.078  94.266  25.106  1.00 16.44          
ATOM   1541  CG1 VAL   127     -25.360  93.691  25.896  1.00 14.02          
ATOM   1545  CG2 VAL   127     -24.187  95.807  24.885  1.00 14.24          
ATOM   1549  C   VAL   127     -21.504  94.494  25.189  1.00 14.76          
ATOM   1550  O   VAL   127     -20.999  95.482  25.628  1.00 15.29          
ATOM   1552  N   PRO   128     -20.952  93.874  24.170  1.00 15.02          
ATOM   1553  CA  PRO   128     -19.949  94.518  23.375  1.00 13.57          
ATOM   1555  CB  PRO   128     -19.716  93.492  22.225  1.00 14.89          
ATOM   1558  CG  PRO   128     -20.237  92.224  22.689  1.00 13.79          
ATOM   1561  CD  PRO   128     -21.405  92.607  23.551  1.00 15.73          
ATOM   1564  C   PRO   128     -20.360  95.862  22.784  1.00 14.69          
ATOM   1565  O   PRO   128     -21.505  96.052  22.307  1.00 15.31          
ATOM   1566  N   VAL   129     -19.382  96.784  22.689  1.00 15.44          
ATOM   1567  CA  VAL   129     -19.582  98.111  22.039  1.00 12.97          
ATOM   1569  CB  VAL   129     -19.405  99.269  23.055  1.00 13.20          
ATOM   1571  CG1 VAL   129     -19.638 100.622  22.347  1.00  7.24          
ATOM   1575  CG2 VAL   129     -20.292  99.059  24.413  1.00  7.88          
ATOM   1579  C   VAL   129     -18.603  98.214  20.857  1.00 13.07          
ATOM   1580  O   VAL   129     -17.456  97.971  21.014  1.00 12.83          
ATOM   1582  N   ILE   130     -19.096  98.480  19.652  1.00 14.20          
ATOM   1583  CA  ILE   130     -18.300  98.659  18.459  1.00 11.93          
ATOM   1585  CB  ILE   130     -18.984  97.874  17.286  1.00 13.69          
ATOM   1587  CG1 ILE   130     -19.161  96.399  17.666  1.00 13.43          
ATOM   1590  CD  ILE   130     -19.975  95.634  16.659  1.00 15.03          
ATOM   1594  CG2 ILE   130     -18.218  98.015  15.906  1.00  4.90          
ATOM   1598  C   ILE   130     -18.318 100.185  18.077  1.00 13.42          
ATOM   1599  O   ILE   130     -19.419 100.851  18.076  1.00 10.47          
ATOM   1601  N   ALA   131     -17.122 100.722  17.781  1.00 13.18          
ATOM   1602  CA  ALA   131     -16.957 102.062  17.185  1.00 13.55          
ATOM   1604  CB  ALA   131     -15.624 102.761  17.547  1.00 11.89          
ATOM   1608  C   ALA   131     -17.006 101.860  15.728  1.00 13.09          
ATOM   1609  O   ALA   131     -16.321 101.028  15.192  1.00 12.65          
ATOM   1611  N   MET   132     -17.852 102.615  15.068  1.00 15.32          
ATOM   1612  CA  MET   132     -17.940 102.582  13.563  1.00 13.93          
ATOM   1614  CB  MET   132     -19.335 102.230  13.107  1.00 13.98          
ATOM   1617  CG  MET   132     -19.509 102.357  11.534  1.00 16.51          
ATOM   1620  SD  MET   132     -21.151 101.970  10.883  1.00 18.40          
ATOM   1621  CE  MET   132     -21.122 102.807   9.309  1.00 24.32          
ATOM   1625  C   MET   132     -17.554 103.991  13.067  1.00 14.19          
ATOM   1626  O   MET   132     -18.360 104.888  13.056  1.00 16.29          
ATOM   1628  N   VAL   133     -16.333 104.173  12.608  1.00 13.14          
ATOM   1629  CA  VAL   133     -15.746 105.489  12.417  1.00 12.83          
ATOM   1631  CB  VAL   133     -14.311 105.497  13.055  1.00 10.70          
ATOM   1633  CG1 VAL   133     -13.673 106.899  12.793  1.00  9.23          
ATOM   1637  CG2 VAL   133     -14.369 105.055  14.518  1.00 11.76          
ATOM   1641  C   VAL   133     -15.547 105.798  10.938  1.00 14.21          
ATOM   1642  O   VAL   133     -14.987 104.969  10.290  1.00 12.77          
ATOM   1644  N   ASN   134     -15.930 106.997  10.458  1.00 15.70          
ATOM   1645  CA  ASN   134     -15.892 107.341   9.020  1.00 17.80          
ATOM   1647  CB  ASN   134     -17.294 107.206   8.446  1.00 18.10          
ATOM   1650  CG  ASN   134     -17.349 107.295   6.929  1.00 16.58          
ATOM   1651  OD1 ASN   134     -16.352 107.061   6.189  1.00 15.83          
ATOM   1652  ND2 ASN   134     -18.540 107.645   6.448  1.00 14.19          
ATOM   1655  C   ASN   134     -15.391 108.796   8.834  1.00 19.29          
ATOM   1656  O   ASN   134     -16.183 109.695   8.577  1.00 20.58          
ATOM   1658  N   GLY   135     -14.089 109.035   9.035  1.00 19.25          
ATOM   1659  CA  GLY   135     -13.543 110.390   8.996  1.00 17.79          
ATOM   1662  C   GLY   135     -12.605 110.549  10.177  1.00 17.04          
ATOM   1663  O   GLY   135     -12.035 109.561  10.632  1.00 16.93          
ATOM   1665  N   LEU   136     -12.466 111.788  10.667  1.00 15.81          
ATOM   1666  CA  LEU   136     -11.440 112.138  11.635  1.00 15.63          
ATOM   1668  CB  LEU   136     -11.044 113.617  11.520  1.00 16.59          
ATOM   1671  CG  LEU   136      -9.891 114.219  12.309  1.00 18.05          
ATOM   1673  CD1 LEU   136      -8.429 113.551  12.089  1.00 18.99          
ATOM   1677  CD2 LEU   136      -9.833 115.783  12.152  1.00 20.77          
ATOM   1681  C   LEU   136     -11.954 111.965  12.963  1.00 14.44          
ATOM   1682  O   LEU   136     -13.066 112.422  13.261  1.00 12.39          
ATOM   1684  N   ALA   137     -11.077 111.436  13.817  1.00 14.97          
ATOM   1685  CA  ALA   137     -11.376 111.250  15.202  1.00 14.20          
ATOM   1687  CB  ALA   137     -11.609 109.759  15.466  1.00 12.24          
ATOM   1691  C   ALA   137     -10.160 111.801  15.973  1.00 15.75          
ATOM   1692  O   ALA   137      -9.029 111.333  15.763  1.00 16.76          
ATOM   1694  N   THR   138     -10.362 112.837  16.809  1.00 16.53          
ATOM   1695  CA  THR   138      -9.252 113.551  17.381  1.00 16.52          
ATOM   1697  CB  THR   138      -8.919 114.929  16.739  1.00 16.69          
ATOM   1699  OG1 THR   138      -9.769 115.911  17.307  1.00 21.82          
ATOM   1701  CG2 THR   138      -9.014 115.076  15.082  1.00 17.09          
ATOM   1705  C   THR   138      -9.402 113.732  18.943  1.00 16.59          
ATOM   1706  O   THR   138     -10.504 114.058  19.468  1.00 17.31          
ATOM   1708  N   ALA   139      -8.278 113.646  19.641  1.00 14.84          
ATOM   1709  CA  ALA   139      -8.277 113.889  21.168  1.00 14.64          
ATOM   1711  CB  ALA   139      -8.517 115.349  21.540  1.00 12.76          
ATOM   1715  C   ALA   139      -9.300 112.981  21.721  1.00 14.52          
ATOM   1716  O   ALA   139      -9.168 111.760  21.532  1.00 14.92          
ATOM   1718  N   ALA   140     -10.322 113.519  22.401  1.00 16.51          
ATOM   1719  CA  ALA   140     -11.291 112.702  23.204  1.00 16.46          
ATOM   1721  CB  ALA   140     -12.166 113.531  24.163  1.00 15.96          
ATOM   1725  C   ALA   140     -12.142 111.890  22.295  1.00 16.99          
ATOM   1726  O   ALA   140     -12.700 110.882  22.738  1.00 17.32          
ATOM   1728  N   GLY   141     -12.260 112.322  21.015  1.00 17.55          
ATOM   1729  CA  GLY   141     -12.798 111.517  20.000  1.00 17.29          
ATOM   1732  C   GLY   141     -12.052 110.245  19.685  1.00 19.38          
ATOM   1733  O   GLY   141     -12.668 109.205  19.427  1.00 21.86          
ATOM   1735  N   CYS   142     -10.720 110.328  19.629  1.00 19.34          
ATOM   1736  CA  CYS   142      -9.878 109.194  19.497  1.00 18.07          
ATOM   1738  CB  CYS   142      -8.437 109.670  19.305  1.00 20.75          
ATOM   1741  SG  CYS   142      -7.434 108.399  18.490  1.00 21.27          
ATOM   1743  C   CYS   142      -9.947 108.334  20.733  1.00 17.69          
ATOM   1744  O   CYS   142     -10.031 107.119  20.635  1.00 19.11          
ATOM   1746  N   GLN   143      -9.923 108.948  21.907  1.00 15.10          
ATOM   1747  CA  GLN   143     -10.181 108.220  23.112  1.00 14.70          
ATOM   1749  CB  GLN   143     -10.384 109.228  24.244  1.00 15.37          
ATOM   1752  CG  GLN   143     -10.213 108.699  25.562  1.00 16.50          
ATOM   1755  CD  GLN   143     -10.624 109.665  26.587  1.00 15.66          
ATOM   1756  OE1 GLN   143     -11.172 109.277  27.546  1.00 21.03          
ATOM   1757  NE2 GLN   143     -10.363 110.904  26.395  1.00 14.30          
ATOM   1760  C   GLN   143     -11.391 107.289  22.958  1.00 14.94          
ATOM   1761  O   GLN   143     -11.356 106.109  23.216  1.00 15.30          
ATOM   1763  N   LEU   144     -12.489 107.835  22.491  1.00 16.72          
ATOM   1764  CA  LEU   144     -13.743 107.112  22.461  1.00 15.83          
ATOM   1766  CB  LEU   144     -14.866 108.027  21.963  1.00 15.53          
ATOM   1769  CG  LEU   144     -16.280 107.504  21.752  1.00 17.08          
ATOM   1771  CD1 LEU   144     -16.809 106.644  22.878  1.00 11.29          
ATOM   1775  CD2 LEU   144     -17.178 108.702  21.383  1.00 15.43          
ATOM   1779  C   LEU   144     -13.627 105.947  21.596  1.00 17.09          
ATOM   1780  O   LEU   144     -14.065 104.857  21.983  1.00 18.00          
ATOM   1782  N   VAL   145     -13.041 106.150  20.403  1.00 14.98          
ATOM   1783  CA  VAL   145     -12.867 105.031  19.542  1.00 14.78          
ATOM   1785  CB  VAL   145     -12.064 105.410  18.272  1.00 13.20          
ATOM   1787  CG1 VAL   145     -11.776 104.237  17.615  1.00 11.90          
ATOM   1791  CG2 VAL   145     -12.739 106.455  17.502  1.00  8.21          
ATOM   1795  C   VAL   145     -12.079 103.855  20.226  1.00 14.76          
ATOM   1796  O   VAL   145     -12.454 102.672  20.187  1.00 15.27          
ATOM   1798  N   ALA   146     -10.928 104.207  20.718  1.00 14.28          
ATOM   1799  CA  ALA   146      -9.999 103.265  21.296  1.00 14.65          
ATOM   1801  CB  ALA   146      -8.694 104.003  21.540  1.00 13.90          
ATOM   1805  C   ALA   146     -10.573 102.690  22.578  1.00 16.55          
ATOM   1806  O   ALA   146     -10.131 101.649  23.054  1.00 18.77          
ATOM   1808  N   SER   147     -11.567 103.346  23.155  1.00 15.98          
ATOM   1809  CA  SER   147     -12.355 102.748  24.250  1.00 17.16          
ATOM   1811  CB  SER   147     -13.099 103.897  25.013  1.00 16.86          
ATOM   1814  OG  SER   147     -12.018 104.685  25.615  1.00 20.51          
ATOM   1816  C   SER   147     -13.330 101.630  23.869  1.00 16.07          
ATOM   1817  O   SER   147     -13.759 100.933  24.701  1.00 12.98          
ATOM   1819  N   CYS   148     -13.790 101.551  22.619  1.00 17.13          
ATOM   1820  CA  CYS   148     -14.721 100.505  22.224  1.00 16.71          
ATOM   1822  CB  CYS   148     -15.343 100.877  20.885  1.00 18.29          
ATOM   1825  SG  CYS   148     -16.416 102.299  21.190  1.00 20.48          
ATOM   1827  C   CYS   148     -14.015  99.133  22.224  1.00 17.21          
ATOM   1828  O   CYS   148     -12.817  99.052  22.100  1.00 16.90          
ATOM   1830  N   ASP   149     -14.781  98.049  22.386  1.00 16.56          
ATOM   1831  CA  ASP   149     -14.248  96.671  22.327  1.00 15.21          
ATOM   1833  CB  ASP   149     -15.349  95.619  22.823  1.00 13.52          
ATOM   1836  CG  ASP   149     -15.848  95.882  24.217  1.00 16.68          
ATOM   1837  OD1 ASP   149     -17.059  96.102  24.440  1.00 17.98          
ATOM   1838  OD2 ASP   149     -15.021  95.858  25.170  1.00 20.31          
ATOM   1839  C   ASP   149     -13.735  96.331  20.910  1.00 14.93          
ATOM   1840  O   ASP   149     -12.711  95.631  20.781  1.00 15.16          
ATOM   1842  N   ILE   150     -14.444  96.820  19.883  1.00 13.57          
ATOM   1843  CA  ILE   150     -14.111  96.565  18.416  1.00 14.31          
ATOM   1845  CB  ILE   150     -15.095  95.522  17.733  1.00 12.77          
ATOM   1847  CG1 ILE   150     -14.892  94.146  18.399  1.00 15.91          
ATOM   1850  CD  ILE   150     -16.059  93.224  18.301  1.00 13.77          
ATOM   1854  CG2 ILE   150     -14.941  95.404  16.247  1.00 13.56          
ATOM   1858  C   ILE   150     -14.247  97.871  17.746  1.00 13.95          
ATOM   1859  O   ILE   150     -15.051  98.691  18.219  1.00 16.22          
ATOM   1861  N   ALA   151     -13.385  98.172  16.777  1.00 12.47          
ATOM   1862  CA  ALA   151     -13.555  99.420  15.978  1.00 12.55          
ATOM   1864  CB  ALA   151     -12.576 100.535  16.376  1.00 13.16          
ATOM   1868  C   ALA   151     -13.361  99.119  14.555  1.00 11.59          
ATOM   1869  O   ALA   151     -12.459  98.428  14.221  1.00  9.67          
ATOM   1871  N   VAL   152     -14.239  99.649  13.723  1.00 13.17          
ATOM   1872  CA  VAL   152     -14.215  99.467  12.276  1.00 13.54          
ATOM   1874  CB  VAL   152     -15.538  98.720  11.775  1.00 14.14          
ATOM   1876  CG1 VAL   152     -15.402  98.283  10.412  1.00 11.83          
ATOM   1880  CG2 VAL   152     -15.927  97.558  12.693  1.00 11.37          
ATOM   1884  C   VAL   152     -14.215 100.896  11.702  1.00 15.05          
ATOM   1885  O   VAL   152     -15.007 101.694  12.153  1.00 15.86          
ATOM   1887  N   ALA   153     -13.434 101.177  10.651  1.00 16.38          
ATOM   1888  CA  ALA   153     -13.167 102.532  10.189  1.00 16.80          
ATOM   1890  CB  ALA   153     -11.780 103.072  10.794  1.00 15.60          
ATOM   1894  C   ALA   153     -13.144 102.479   8.685  1.00 16.53          
ATOM   1895  O   ALA   153     -12.680 101.499   8.135  1.00 18.86          
ATOM   1897  N   SER   154     -13.720 103.460   7.976  1.00 17.43          
ATOM   1898  CA  SER   154     -13.425 103.599   6.498  1.00 17.76          
ATOM   1900  CB  SER   154     -14.205 104.772   5.892  1.00 17.71          
ATOM   1903  OG  SER   154     -13.894 105.937   6.657  1.00 20.86          
ATOM   1905  C   SER   154     -11.941 103.874   6.287  1.00 17.98          
ATOM   1906  O   SER   154     -11.274 104.399   7.145  1.00 18.86          
ATOM   1908  N   ASP   155     -11.434 103.531   5.123  1.00 20.20          
ATOM   1909  CA  ASP   155     -10.016 103.718   4.775  1.00 20.53          
ATOM   1911  CB  ASP   155      -9.720 102.958   3.422  1.00 21.70          
ATOM   1914  CG  ASP   155     -10.661 103.332   2.321  1.00 25.16          
ATOM   1915  OD1 ASP   155     -11.393 104.326   2.548  1.00 32.18          
ATOM   1916  OD2 ASP   155     -10.704 102.656   1.233  1.00 31.33          
ATOM   1917  C   ASP   155      -9.580 105.200   4.717  1.00 19.69          
ATOM   1918  O   ASP   155      -8.400 105.484   4.732  1.00 20.26          
ATOM   1920  N   LYS   156     -10.531 106.140   4.626  1.00 19.70          
ATOM   1921  CA  LYS   156     -10.233 107.613   4.606  1.00 19.36          
ATOM   1923  CB  LYS   156     -11.287 108.402   3.848  1.00 18.32          
ATOM   1926  CG  LYS   156     -12.523 108.719   4.721  1.00 21.72          
ATOM   1929  CD  LYS   156     -13.605 109.442   3.926  1.00 28.34          
ATOM   1932  CE  LYS   156     -14.764 109.953   4.810  1.00 30.53          
ATOM   1935  NZ  LYS   156     -15.859 110.341   3.812  1.00 23.70          
ATOM   1939  C   LYS   156     -10.196 108.205   6.008  1.00 18.12          
ATOM   1940  O   LYS   156      -9.851 109.365   6.182  1.00 19.94          
ATOM   1942  N   SER   157     -10.707 107.475   6.967  1.00 15.93          
ATOM   1943  CA  SER   157     -10.481 107.827   8.387  1.00 14.77          
ATOM   1945  CB  SER   157     -10.962 106.683   9.196  1.00 13.82          
ATOM   1948  OG  SER   157     -12.318 106.488   9.139  1.00 14.81          
ATOM   1950  C   SER   157      -9.042 108.058   8.857  1.00 14.72          
ATOM   1951  O   SER   157      -8.125 107.444   8.356  1.00 14.23          
ATOM   1953  N   SER   158      -8.889 108.847   9.942  1.00 14.89          
ATOM   1954  CA  SER   158      -7.659 109.206  10.462  1.00 15.21          
ATOM   1956  CB  SER   158      -7.008 110.355   9.719  1.00 16.57          
ATOM   1959  OG  SER   158      -7.455 111.626  10.185  1.00 19.65          
ATOM   1961  C   SER   158      -7.864 109.556  11.938  1.00 15.60          
ATOM   1962  O   SER   158      -8.988 109.831  12.370  1.00 17.35          
ATOM   1964  N   PHE   159      -6.773 109.495  12.685  1.00 13.31          
ATOM   1965  CA  PHE   159      -6.797 109.518  14.183  1.00 13.16          
ATOM   1967  CB  PHE   159      -6.626 108.061  14.637  1.00 14.50          
ATOM   1970  CG  PHE   159      -7.597 107.116  13.922  1.00 14.84          
ATOM   1971  CD1 PHE   159      -7.268 106.551  12.741  1.00 18.81          
ATOM   1973  CE1 PHE   159      -8.215 105.735  12.070  1.00 19.96          
ATOM   1975  CZ  PHE   159      -9.499 105.507  12.689  1.00 19.89          
ATOM   1977  CE2 PHE   159      -9.808 106.080  13.773  1.00 10.53          
ATOM   1979  CD2 PHE   159      -8.873 106.890  14.430  1.00 18.37          
ATOM   1981  C   PHE   159      -5.650 110.331  14.658  1.00 11.23          
ATOM   1982  O   PHE   159      -4.558 110.173  14.074  1.00  7.55          
ATOM   1984  N   ALA   160      -5.854 111.185  15.710  1.00 11.91          
ATOM   1985  CA  ALA   160      -4.826 112.135  16.255  1.00 11.63          
ATOM   1987  CB  ALA   160      -4.717 113.434  15.370  1.00 10.32          
ATOM   1991  C   ALA   160      -5.100 112.562  17.718  1.00 12.81          
ATOM   1992  O   ALA   160      -6.225 112.448  18.208  1.00 14.16          
ATOM   1994  N   THR   161      -4.028 112.898  18.449  1.00 14.40          
ATOM   1995  CA  THR   161      -4.124 113.375  19.908  1.00 14.46          
ATOM   1997  CB  THR   161      -3.674 112.359  20.920  1.00 14.70          
ATOM   1999  OG1 THR   161      -2.354 111.948  20.692  1.00 18.82          
ATOM   2001  CG2 THR   161      -4.605 111.072  21.070  1.00 11.62          
ATOM   2005  C   THR   161      -3.342 114.724  19.891  1.00 13.93          
ATOM   2006  O   THR   161      -2.186 114.821  20.299  1.00 13.89          
ATOM   2008  N   PRO   162      -3.936 115.746  19.260  1.00 13.68          
ATOM   2009  CA  PRO   162      -3.314 117.035  19.113  1.00 14.50          
ATOM   2011  CB  PRO   162      -4.021 117.570  17.909  1.00 14.91          
ATOM   2014  CG  PRO   162      -5.495 117.147  18.299  1.00 13.72          
ATOM   2017  CD  PRO   162      -5.264 115.729  18.624  1.00 14.02          
ATOM   2020  C   PRO   162      -3.546 118.026  20.273  1.00 13.71          
ATOM   2021  O   PRO   162      -3.349 119.171  20.077  1.00 13.59          
ATOM   2022  N   GLY   163      -3.966 117.617  21.432  1.00 13.57          
ATOM   2023  CA  GLY   163      -4.009 118.567  22.602  1.00 15.24          
ATOM   2026  C   GLY   163      -2.896 119.618  22.674  1.00 16.04          
ATOM   2027  O   GLY   163      -3.162 120.804  22.979  1.00 16.72          
ATOM   2029  N   VAL   164      -1.668 119.202  22.341  1.00 15.79          
ATOM   2030  CA  VAL   164      -0.458 119.981  22.607  1.00 15.89          
ATOM   2032  CB  VAL   164       0.907 119.180  22.283  1.00 16.65          
ATOM   2034  CG1 VAL   164       1.292 118.356  23.398  1.00 19.97          
ATOM   2038  CG2 VAL   164       0.828 118.443  20.938  1.00 15.86          
ATOM   2042  C   VAL   164      -0.448 121.262  21.852  1.00 14.61          
ATOM   2043  O   VAL   164       0.088 122.249  22.319  1.00 13.93          
ATOM   2045  N   ASN   165      -0.969 121.224  20.629  1.00 16.04          
ATOM   2046  CA  ASN   165      -1.148 122.387  19.778  1.00 14.55          
ATOM   2048  CB  ASN   165      -1.761 121.915  18.480  1.00 14.16          
ATOM   2051  CG  ASN   165      -0.774 121.026  17.664  1.00 14.81          
ATOM   2052  OD1 ASN   165       0.415 121.018  17.949  1.00 17.41          
ATOM   2053  ND2 ASN   165      -1.256 120.334  16.641  1.00 12.60          
ATOM   2056  C   ASN   165      -1.980 123.516  20.470  1.00 15.76          
ATOM   2057  O   ASN   165      -1.754 124.706  20.185  1.00 18.72          
ATOM   2059  N   VAL   166      -2.891 123.162  21.400  1.00 14.92          
ATOM   2060  CA  VAL   166      -3.702 124.124  22.167  1.00 12.58          
ATOM   2062  CB  VAL   166      -5.210 123.861  22.031  1.00 12.92          
ATOM   2064  CG1 VAL   166      -5.615 123.744  20.418  1.00  7.18          
ATOM   2068  CG2 VAL   166      -5.718 122.593  22.756  1.00  8.71          
ATOM   2072  C   VAL   166      -3.289 124.120  23.607  1.00 13.26          
ATOM   2073  O   VAL   166      -4.050 124.481  24.482  1.00 13.86          
ATOM   2075  N   GLY   167      -2.067 123.782  23.873  1.00 12.52          
ATOM   2076  CA  GLY   167      -1.554 123.834  25.275  1.00 12.88          
ATOM   2079  C   GLY   167      -2.257 122.906  26.196  1.00 12.87          
ATOM   2080  O   GLY   167      -2.050 122.990  27.366  1.00 11.70          
ATOM   2082  N   LEU   168      -3.018 121.945  25.629  1.00 15.15          
ATOM   2083  CA  LEU   168      -3.711 120.940  26.430  1.00 15.27          
ATOM   2085  CB  LEU   168      -5.220 121.049  26.337  1.00 14.54          
ATOM   2088  CG  LEU   168      -6.044 120.150  27.318  1.00 15.01          
ATOM   2090  CD1 LEU   168      -5.635 120.183  28.793  1.00  8.44          
ATOM   2094  CD2 LEU   168      -7.475 120.492  27.192  1.00 12.90          
ATOM   2098  C   LEU   168      -3.300 119.519  26.054  1.00 15.66          
ATOM   2099  O   LEU   168      -3.986 118.919  25.340  1.00 14.16          
ATOM   2101  N   PHE   169      -2.277 118.941  26.750  1.00 15.84          
ATOM   2102  CA  PHE   169      -1.776 117.603  26.358  1.00 15.52          
ATOM   2104  CB  PHE   169      -0.632 117.222  27.284  1.00 15.49          
ATOM   2107  CG  PHE   169       0.273 116.083  26.783  1.00 19.77          
ATOM   2108  CD1 PHE   169       0.016 114.757  27.103  1.00 19.12          
ATOM   2110  CE1 PHE   169       0.845 113.751  26.725  1.00 12.77          
ATOM   2112  CZ  PHE   169       2.009 114.007  26.151  1.00 18.20          
ATOM   2114  CE2 PHE   169       2.320 115.311  25.776  1.00 23.08          
ATOM   2116  CD2 PHE   169       1.463 116.346  26.115  1.00 23.90          
ATOM   2118  C   PHE   169      -2.915 116.557  26.384  1.00 14.86          
ATOM   2119  O   PHE   169      -3.643 116.462  27.398  1.00 12.35          
ATOM   2121  N   CYS   170      -3.016 115.698  25.348  1.00 13.41          
ATOM   2122  CA  CYS   170      -4.035 114.596  25.361  1.00 11.88          
ATOM   2124  CB  CYS   170      -4.212 113.985  23.971  1.00 16.34          
ATOM   2127  SG  CYS   170      -5.066 115.119  22.882  1.00 14.15          
ATOM   2129  C   CYS   170      -3.822 113.535  26.415  1.00 12.88          
ATOM   2130  O   CYS   170      -3.758 112.371  26.134  1.00 11.10          
ATOM   2132  N   SER   171      -3.733 113.932  27.715  1.00 11.47          
ATOM   2133  CA  SER   171      -3.464 112.969  28.731  1.00 10.97          
ATOM   2135  CB  SER   171      -3.229 113.633  30.073  1.00 10.81          
ATOM   2138  OG  SER   171      -2.022 114.323  30.093  1.00 11.21          
ATOM   2140  C   SER   171      -4.525 111.918  28.919  1.00 12.85          
ATOM   2141  O   SER   171      -4.212 110.719  29.144  1.00 12.57          
ATOM   2143  N   THR   172      -5.771 112.381  28.822  1.00 13.91          
ATOM   2144  CA  THR   172      -6.954 111.541  28.875  1.00 14.21          
ATOM   2146  CB  THR   172      -8.245 112.376  28.810  1.00 11.99          
ATOM   2148  OG1 THR   172      -7.944 113.688  28.320  1.00 18.90          
ATOM   2150  CG2 THR   172      -8.876 112.488  30.190  1.00 12.58          
ATOM   2154  C   THR   172      -6.931 110.566  27.713  1.00 14.24          
ATOM   2155  O   THR   172      -6.909 109.354  27.927  1.00 14.96          
ATOM   2157  N   PRO   173      -6.924 111.071  26.480  1.00 13.79          
ATOM   2158  CA  PRO   173      -6.781 110.153  25.396  1.00 14.93          
ATOM   2160  CB  PRO   173      -6.706 111.045  24.184  1.00 15.71          
ATOM   2163  CG  PRO   173      -7.460 112.323  24.540  1.00 12.71          
ATOM   2166  CD  PRO   173      -7.051 112.455  26.023  1.00 13.35          
ATOM   2169  C   PRO   173      -5.521 109.199  25.422  1.00 17.61          
ATOM   2170  O   PRO   173      -5.580 108.103  24.913  1.00 19.27          
ATOM   2171  N   GLY   174      -4.387 109.629  25.969  1.00 17.70          
ATOM   2172  CA  GLY   174      -3.272 108.737  26.057  1.00 17.44          
ATOM   2175  C   GLY   174      -3.499 107.491  26.902  1.00 15.28          
ATOM   2176  O   GLY   174      -2.813 106.537  26.725  1.00 14.27          
ATOM   2178  N   VAL   175      -4.467 107.505  27.800  1.00 15.76          
ATOM   2179  CA  VAL   175      -4.896 106.271  28.511  1.00 15.71          
ATOM   2181  CB  VAL   175      -5.937 106.619  29.521  1.00 15.70          
ATOM   2183  CG1 VAL   175      -6.565 105.337  30.087  1.00 14.32          
ATOM   2187  CG2 VAL   175      -5.252 107.444  30.643  1.00 15.63          
ATOM   2191  C   VAL   175      -5.366 105.150  27.553  1.00 15.93          
ATOM   2192  O   VAL   175      -4.804 104.066  27.471  1.00 16.71          
ATOM   2194  N   ALA   176      -6.311 105.462  26.691  1.00 17.13          
ATOM   2195  CA  ALA   176      -6.865 104.471  25.816  1.00 15.80          
ATOM   2197  CB  ALA   176      -8.171 104.961  25.233  1.00 14.01          
ATOM   2201  C   ALA   176      -5.808 104.198  24.771  1.00 17.04          
ATOM   2202  O   ALA   176      -5.591 103.035  24.407  1.00 18.17          
ATOM   2204  N   LEU   177      -5.122 105.241  24.314  1.00 15.93          
ATOM   2205  CA  LEU   177      -4.075 105.075  23.291  1.00 15.60          
ATOM   2207  CB  LEU   177      -3.623 106.433  22.684  1.00 14.99          
ATOM   2210  CG  LEU   177      -2.831 106.520  21.396  1.00 15.86          
ATOM   2212  CD1 LEU   177      -3.655 106.014  20.179  1.00  9.70          
ATOM   2216  CD2 LEU   177      -2.241 107.883  21.203  1.00 12.41          
ATOM   2220  C   LEU   177      -2.907 104.225  23.790  1.00 13.61          
ATOM   2221  O   LEU   177      -2.461 103.392  23.100  1.00 12.97          
ATOM   2223  N   ALA   178      -2.379 104.413  25.010  1.00 15.02          
ATOM   2224  CA  ALA   178      -1.346 103.557  25.509  1.00 12.58          
ATOM   2226  CB  ALA   178      -0.913 104.031  27.090  1.00 12.50          
ATOM   2230  C   ALA   178      -1.803 102.057  25.497  1.00 13.24          
ATOM   2231  O   ALA   178      -0.988 101.166  25.426  1.00 14.17          
ATOM   2233  N   ARG   179      -3.103 101.769  25.688  1.00 13.68          
ATOM   2234  CA  ARG   179      -3.628 100.423  25.693  1.00 12.53          
ATOM   2236  CB  ARG   179      -4.741 100.327  26.661  1.00 13.34          
ATOM   2239  CG  ARG   179      -4.187 100.433  28.135  1.00 13.74          
ATOM   2242  CD  ARG   179      -5.181 101.036  29.004  1.00 12.81          
ATOM   2245  NE  ARG   179      -4.651 101.243  30.377  1.00 15.74          
ATOM   2247  CZ  ARG   179      -3.865 102.245  30.734  1.00 16.14          
ATOM   2248  NH1 ARG   179      -3.541 103.192  29.833  1.00 17.19          
ATOM   2251  NH2 ARG   179      -3.467 102.334  31.971  1.00 14.79          
ATOM   2254  C   ARG   179      -4.038  99.924  24.308  1.00 13.40          
ATOM   2255  O   ARG   179      -4.381  98.769  24.163  1.00 13.16          
ATOM   2257  N   ALA   180      -3.790 100.731  23.293  1.00 12.66          
ATOM   2258  CA  ALA   180      -4.220 100.412  21.896  1.00 13.32          
ATOM   2260  CB  ALA   180      -5.088 101.538  21.418  1.00  9.90          
ATOM   2264  C   ALA   180      -3.011 100.164  21.056  1.00 14.18          
ATOM   2265  O   ALA   180      -2.927  99.131  20.414  1.00 19.33          
ATOM   2267  N   VAL   181      -2.039 101.075  21.068  1.00 15.22          
ATOM   2268  CA  VAL   181      -0.849 100.991  20.255  1.00 13.85          
ATOM   2270  CB  VAL   181      -0.860 102.135  19.120  1.00 15.98          
ATOM   2272  CG1 VAL   181      -2.155 102.081  18.357  1.00  7.73          
ATOM   2276  CG2 VAL   181      -0.656 103.523  19.716  1.00 13.22          
ATOM   2280  C   VAL   181       0.461 100.901  21.028  1.00 15.16          
ATOM   2281  O   VAL   181       0.502 100.992  22.279  1.00 15.82          
ATOM   2283  N   PRO   182       1.573 100.616  20.315  1.00 14.19          
ATOM   2284  CA  PRO   182       2.868 100.628  21.001  1.00 13.75          
ATOM   2286  CB  PRO   182       3.843 100.160  19.916  1.00 13.53          
ATOM   2289  CG  PRO   182       3.032  99.343  19.051  1.00 13.09          
ATOM   2292  CD  PRO   182       1.682 100.081  18.971  1.00 12.60          
ATOM   2295  C   PRO   182       3.299 101.974  21.526  1.00 13.83          
ATOM   2296  O   PRO   182       2.954 102.954  20.942  1.00 12.62          
ATOM   2297  N   ARG   183       4.038 101.995  22.650  1.00 13.44          
ATOM   2298  CA  ARG   183       4.558 103.211  23.203  1.00 13.38          
ATOM   2300  CB  ARG   183       5.547 102.934  24.284  1.00 15.77          
ATOM   2303  CG  ARG   183       5.003 102.142  25.512  1.00 18.09          
ATOM   2306  CD  ARG   183       6.155 101.847  26.588  1.00 26.29          
ATOM   2309  NE  ARG   183       5.731 100.924  27.657  1.00 24.27          
ATOM   2311  CZ  ARG   183       6.371 100.749  28.824  1.00 29.69          
ATOM   2312  NH1 ARG   183       7.466 101.430  29.149  1.00 28.43          
ATOM   2315  NH2 ARG   183       5.873  99.907  29.739  1.00 32.30          
ATOM   2318  C   ARG   183       5.194 104.148  22.188  1.00 15.18          
ATOM   2319  O   ARG   183       4.927 105.346  22.173  1.00 14.34          
ATOM   2321  N   LYS   184       5.970 103.614  21.250  1.00 16.19          
ATOM   2322  CA  LYS   184       6.672 104.457  20.335  1.00 15.56          
ATOM   2324  CB  LYS   184       7.652 103.603  19.501  1.00 15.75          
ATOM   2327  CG  LYS   184       8.897 103.148  20.171  1.00 14.21          
ATOM   2330  CD  LYS   184       9.909 104.258  20.363  1.00 14.47          
ATOM   2333  CE  LYS   184      11.130 103.809  21.190  1.00 15.16          
ATOM   2336  NZ  LYS   184      10.767 103.122  22.463  1.00 11.42          
ATOM   2340  C   LYS   184       5.674 105.175  19.376  1.00 16.21          
ATOM   2341  O   LYS   184       6.000 106.188  18.817  1.00 18.28          
ATOM   2343  N   VAL   185       4.530 104.560  19.092  1.00 16.20          
ATOM   2344  CA  VAL   185       3.482 105.117  18.199  1.00 13.76          
ATOM   2346  CB  VAL   185       2.638 104.025  17.610  1.00 13.98          
ATOM   2348  CG1 VAL   185       1.288 104.568  16.898  1.00  9.73          
ATOM   2352  CG2 VAL   185       3.464 103.207  16.582  1.00 12.89          
ATOM   2356  C   VAL   185       2.705 106.100  19.084  1.00 13.72          
ATOM   2357  O   VAL   185       2.551 107.269  18.736  1.00 12.67          
ATOM   2359  N   ALA   186       2.331 105.677  20.296  1.00 12.27          
ATOM   2360  CA  ALA   186       1.546 106.569  21.141  1.00 11.47          
ATOM   2362  CB  ALA   186       1.073 105.873  22.447  1.00 10.23          
ATOM   2366  C   ALA   186       2.287 107.858  21.382  1.00 11.39          
ATOM   2367  O   ALA   186       1.712 108.967  21.396  1.00 11.13          
ATOM   2369  N   LEU   187       3.568 107.762  21.624  1.00 13.68          
ATOM   2370  CA  LEU   187       4.279 108.922  22.109  1.00 14.98          
ATOM   2372  CB  LEU   187       5.438 108.567  23.079  1.00 16.33          
ATOM   2375  CG  LEU   187       5.187 108.269  24.512  1.00 15.86          
ATOM   2377  CD1 LEU   187       6.406 107.556  25.136  1.00 15.26          
ATOM   2381  CD2 LEU   187       4.757 109.428  25.486  1.00 18.79          
ATOM   2385  C   LEU   187       4.650 109.852  20.973  1.00 14.07          
ATOM   2386  O   LEU   187       4.708 111.061  21.208  1.00 13.86          
ATOM   2388  N   GLU   188       4.748 109.370  19.711  1.00 16.26          
ATOM   2389  CA  GLU   188       4.968 110.277  18.638  1.00 13.66          
ATOM   2391  CB  GLU   188       5.315 109.608  17.304  1.00 15.77          
ATOM   2394  CG  GLU   188       5.935 110.580  16.321  1.00 11.44          
ATOM   2397  CD  GLU   188       6.002 110.080  14.897  1.00 21.65          
ATOM   2398  OE1 GLU   188       6.090 108.837  14.675  1.00 17.68          
ATOM   2399  OE2 GLU   188       5.983 110.977  13.985  1.00 20.00          
ATOM   2400  C   GLU   188       3.697 111.074  18.509  1.00 16.10          
ATOM   2401  O   GLU   188       3.728 112.300  18.403  1.00 19.11          
ATOM   2403  N   MET   189       2.568 110.373  18.503  1.00 15.67          
ATOM   2404  CA  MET   189       1.245 110.944  18.386  1.00 14.76          
ATOM   2406  CB  MET   189       0.223 109.820  18.476  1.00 16.05          
ATOM   2409  CG  MET   189      -0.192 109.235  17.113  1.00 11.41          
ATOM   2412  SD  MET   189      -1.299 107.831  17.427  1.00 15.18          
ATOM   2413  CE  MET   189      -2.885 108.711  17.284  1.00 10.20          
ATOM   2417  C   MET   189       0.881 111.983  19.415  1.00 13.16          
ATOM   2418  O   MET   189       0.362 113.020  19.111  1.00 12.74          
ATOM   2420  N   LEU   190       1.163 111.686  20.648  1.00 13.46          
ATOM   2421  CA  LEU   190       1.007 112.651  21.758  1.00 13.26          
ATOM   2423  CB  LEU   190       1.172 111.896  23.085  1.00 12.76          
ATOM   2426  CG  LEU   190      -0.041 110.953  23.427  1.00 15.20          
ATOM   2428  CD1 LEU   190       0.342 109.960  24.610  1.00 10.62          
ATOM   2432  CD2 LEU   190      -1.373 111.659  23.801  1.00  9.41          
ATOM   2436  C   LEU   190       1.916 113.923  21.809  1.00 13.41          
ATOM   2437  O   LEU   190       1.441 115.039  22.144  1.00 12.31          
ATOM   2439  N   PHE   191       3.219 113.734  21.593  1.00 13.82          
ATOM   2440  CA  PHE   191       4.180 114.821  21.611  1.00 13.38          
ATOM   2442  CB  PHE   191       5.621 114.271  21.785  1.00 13.20          
ATOM   2445  CG  PHE   191       5.928 113.726  23.145  1.00 15.67          
ATOM   2446  CD1 PHE   191       5.438 114.319  24.316  1.00 11.51          
ATOM   2448  CE1 PHE   191       5.760 113.755  25.521  1.00 14.34          
ATOM   2450  CZ  PHE   191       6.558 112.674  25.594  1.00 12.42          
ATOM   2452  CE2 PHE   191       7.108 112.149  24.432  1.00 13.47          
ATOM   2454  CD2 PHE   191       6.740 112.606  23.264  1.00 13.04          
ATOM   2456  C   PHE   191       4.137 115.686  20.356  1.00 14.04          
ATOM   2457  O   PHE   191       4.506 116.891  20.425  1.00 14.78          
ATOM   2459  N   THR   192       3.689 115.134  19.229  1.00 13.16          
ATOM   2460  CA  THR   192       3.681 115.936  17.956  1.00 13.89          
ATOM   2462  CB  THR   192       4.352 115.169  16.800  1.00 12.82          
ATOM   2464  OG1 THR   192       3.631 113.956  16.553  1.00 12.98          
ATOM   2466  CG2 THR   192       5.800 114.804  17.141  1.00 12.48          
ATOM   2470  C   THR   192       2.300 116.317  17.407  1.00 14.50          
ATOM   2471  O   THR   192       2.187 117.235  16.600  1.00 15.91          
ATOM   2473  N   GLY   193       1.261 115.554  17.731  1.00 15.16          
ATOM   2474  CA  GLY   193      -0.111 115.890  17.349  1.00 13.21          
ATOM   2477  C   GLY   193      -0.453 115.579  15.886  1.00 14.47          
ATOM   2478  O   GLY   193      -1.570 115.866  15.458  1.00 11.68          
ATOM   2480  N   GLU   194       0.378 114.845  15.193  1.00 14.01          
ATOM   2481  CA  GLU   194       0.022 114.437  13.862  1.00 16.76          
ATOM   2483  CB  GLU   194       1.277 114.336  13.000  1.00 17.80          
ATOM   2486  CG  GLU   194       2.118 115.670  12.989  1.00 22.11          
ATOM   2489  CD  GLU   194       1.936 116.482  11.769  1.00 24.74          
ATOM   2490  OE1 GLU   194       0.906 116.402  11.071  1.00 23.22          
ATOM   2491  OE2 GLU   194       2.886 117.207  11.450  1.00 34.60          
ATOM   2492  C   GLU   194      -0.850 113.190  13.715  1.00 15.67          
ATOM   2493  O   GLU   194      -0.580 112.138  14.278  1.00 14.15          
ATOM   2495  N   PRO   195      -1.886 113.300  12.895  1.00 14.69          
ATOM   2496  CA  PRO   195      -2.718 112.173  12.696  1.00 14.86          
ATOM   2498  CB  PRO   195      -3.653 112.671  11.550  1.00 15.80          
ATOM   2501  CG  PRO   195      -2.811 113.512  10.737  1.00 12.58          
ATOM   2504  CD  PRO   195      -2.018 114.261  11.786  1.00 15.77          
ATOM   2507  C   PRO   195      -1.901 110.912  12.128  1.00 14.58          
ATOM   2508  O   PRO   195      -0.835 111.053  11.564  1.00  8.63          
ATOM   2509  N   ILE   196      -2.412 109.726  12.465  1.00 14.84          
ATOM   2510  CA  ILE   196      -2.167 108.529  11.793  1.00 14.45          
ATOM   2512  CB  ILE   196      -1.750 107.326  12.600  1.00 14.39          
ATOM   2514  CG1 ILE   196      -2.928 106.781  13.464  1.00 15.65          
ATOM   2517  CD  ILE   196      -2.544 105.621  14.499  1.00 11.63          
ATOM   2521  CG2 ILE   196      -0.395 107.632  13.279  1.00 13.20          
ATOM   2525  C   ILE   196      -3.455 108.204  11.051  1.00 15.62          
ATOM   2526  O   ILE   196      -4.602 108.541  11.511  1.00 14.49          
ATOM   2528  N   SER   197      -3.224 107.593   9.897  1.00 11.08          
ATOM   2529  CA  SER   197      -4.312 107.127   9.129  1.00 14.10          
ATOM   2531  CB  SER   197      -3.849 106.874   7.672  1.00 11.64          
ATOM   2534  OG  SER   197      -2.965 105.783   7.822  1.00 14.41          
ATOM   2536  C   SER   197      -4.818 105.784   9.650  1.00 12.85          
ATOM   2537  O   SER   197      -4.136 105.126  10.410  1.00 12.13          
ATOM   2539  N   ALA   198      -5.960 105.388   9.078  1.00 12.74          
ATOM   2540  CA  ALA   198      -6.697 104.195   9.380  1.00 12.91          
ATOM   2542  CB  ALA   198      -8.125 104.216   8.733  1.00 11.76          
ATOM   2546  C   ALA   198      -5.890 102.968   9.009  1.00 15.33          
ATOM   2547  O   ALA   198      -5.988 101.999   9.676  1.00 15.30          
ATOM   2549  N   GLN   199      -5.066 102.998   7.965  1.00 17.46          
ATOM   2550  CA  GLN   199      -4.204 101.844   7.708  1.00 18.62          
ATOM   2552  CB  GLN   199      -3.447 102.006   6.403  1.00 18.95          
ATOM   2555  CG  GLN   199      -4.292 102.060   5.089  1.00 19.74          
ATOM   2558  CD  GLN   199      -5.328 103.261   4.900  1.00 17.57          
ATOM   2559  OE1 GLN   199      -5.067 104.433   5.285  1.00 22.03          
ATOM   2560  NE2 GLN   199      -6.539 102.929   4.327  1.00  5.76          
ATOM   2563  C   GLN   199      -3.217 101.559   8.815  1.00 19.07          
ATOM   2564  O   GLN   199      -3.066 100.416   9.239  1.00 19.01          
ATOM   2566  N   GLU   200      -2.568 102.629   9.289  1.00 19.39          
ATOM   2567  CA  GLU   200      -1.639 102.627  10.372  1.00 17.75          
ATOM   2569  CB  GLU   200      -0.938 104.016  10.467  1.00 18.59          
ATOM   2572  CG  GLU   200      -0.123 104.440   9.146  1.00 19.47          
ATOM   2575  CD  GLU   200       0.227 105.995   9.049  1.00 23.04          
ATOM   2576  OE1 GLU   200      -0.213 106.792   9.926  1.00 23.16          
ATOM   2577  OE2 GLU   200       0.895 106.450   8.065  1.00 26.47          
ATOM   2578  C   GLU   200      -2.267 102.296  11.720  1.00 17.53          
ATOM   2579  O   GLU   200      -1.687 101.538  12.552  1.00 14.24          
ATOM   2581  N   ALA   201      -3.414 102.888  11.983  1.00 17.46          
ATOM   2582  CA  ALA   201      -4.134 102.512  13.218  1.00 15.81          
ATOM   2584  CB  ALA   201      -5.399 103.324  13.368  1.00 17.82          
ATOM   2588  C   ALA   201      -4.499 101.033  13.078  1.00 16.05          
ATOM   2589  O   ALA   201      -4.535 100.368  14.018  1.00 12.65          
ATOM   2591  N   LEU   202      -4.799 100.518  11.866  1.00 15.15          
ATOM   2592  CA  LEU   202      -5.079  99.062  11.761  1.00 16.60          
ATOM   2594  CB  LEU   202      -5.662  98.635  10.393  1.00 14.11          
ATOM   2597  CG  LEU   202      -5.909  97.131  10.254  1.00 14.17          
ATOM   2599  CD1 LEU   202      -6.933  96.662  11.181  1.00 10.30          
ATOM   2603  CD2 LEU   202      -6.276  96.674   8.762  1.00  6.93          
ATOM   2607  C   LEU   202      -3.807  98.222  12.129  1.00 17.80          
ATOM   2608  O   LEU   202      -3.878  97.379  13.019  1.00 20.48          
ATOM   2610  N   LEU   203      -2.656  98.555  11.544  1.00 17.59          
ATOM   2611  CA  LEU   203      -1.429  97.825  11.775  1.00 18.35          
ATOM   2613  CB  LEU   203      -0.297  98.488  11.010  1.00 18.94          
ATOM   2616  CG  LEU   203       1.043  97.768  10.922  1.00 21.00          
ATOM   2618  CD1 LEU   203       1.190  97.414   9.449  1.00 24.89          
ATOM   2622  CD2 LEU   203       2.209  98.632  11.305  1.00 26.89          
ATOM   2626  C   LEU   203      -0.998  97.807  13.218  1.00 18.20          
ATOM   2627  O   LEU   203      -0.338  96.856  13.663  1.00 20.33          
ATOM   2629  N   HSD   204      -1.273  98.900  13.907  1.00 17.02          
ATOM   2630  CA  HSD   204      -0.728  99.131  15.234  1.00 17.25          
ATOM   2632  CB  HSD   204      -0.203 100.553  15.369  1.00 16.74          
ATOM   2635  CG  HSD   204       1.093 100.729  14.676  1.00 18.87          
ATOM   2636  ND1 HSD   204       2.157  99.882  14.902  1.00 22.98          
ATOM   2638  CE1 HSD   204       3.153 100.212  14.106  1.00 21.31          
ATOM   2640  NE2 HSD   204       2.756 101.220  13.350  1.00 20.85          
ATOM   2642  CD2 HSD   204       1.477 101.566  13.687  1.00 18.98          
ATOM   2644  C   HSD   204      -1.654  98.782  16.358  1.00 16.73          
ATOM   2645  O   HSD   204      -1.243  98.784  17.497  1.00 18.93          
ATOM   2647  N   GLY   205      -2.879  98.408  16.047  1.00 16.80          
ATOM   2648  CA  GLY   205      -3.774  97.896  17.035  1.00 17.30          
ATOM   2651  C   GLY   205      -4.869  98.863  17.470  1.00 17.34          
ATOM   2652  O   GLY   205      -5.606  98.494  18.429  1.00 14.11          
ATOM   2654  N   LEU   206      -5.028 100.015  16.740  1.00 14.87          
ATOM   2655  CA  LEU   206      -6.093 100.963  17.128  1.00 15.55          
ATOM   2657  CB  LEU   206      -5.815 102.441  16.664  1.00 14.16          
ATOM   2660  CG  LEU   206      -6.820 103.556  17.045  1.00 12.78          
ATOM   2662  CD1 LEU   206      -7.503 103.424  18.333  1.00 20.82          
ATOM   2666  CD2 LEU   206      -6.183 104.910  16.994  1.00 15.60          
ATOM   2670  C   LEU   206      -7.477 100.488  16.711  1.00 14.99          
ATOM   2671  O   LEU   206      -8.414 100.664  17.458  1.00 14.65          
ATOM   2673  N   LEU   207      -7.548  99.925  15.485  1.00 14.78          
ATOM   2674  CA  LEU   207      -8.704  99.420  14.835  1.00 14.16          
ATOM   2676  CB  LEU   207      -8.769 100.007  13.376  1.00 14.90          
ATOM   2679  CG  LEU   207      -8.827 101.563  13.292  1.00 13.55          
ATOM   2681  CD1 LEU   207      -8.549 102.044  11.845  1.00 14.59          
ATOM   2685  CD2 LEU   207     -10.197 102.130  13.827  1.00  7.65          
ATOM   2689  C   LEU   207      -8.664  97.877  14.752  1.00 15.12          
ATOM   2690  O   LEU   207      -7.603  97.251  14.797  1.00 15.49          
ATOM   2692  N   SER   208      -9.848  97.286  14.559  1.00 15.66          
ATOM   2693  CA  SER   208     -10.067  95.832  14.288  1.00 14.66          
ATOM   2695  CB  SER   208     -11.378  95.301  14.949  1.00 13.97          
ATOM   2698  OG  SER   208     -11.455  95.674  16.324  1.00 12.76          
ATOM   2700  C   SER   208     -10.116  95.578  12.808  1.00 14.17          
ATOM   2701  O   SER   208      -9.495  94.620  12.297  1.00 11.84          
ATOM   2703  N   LYS   209     -10.831  96.455  12.113  1.00 15.33          
ATOM   2704  CA  LYS   209     -10.987  96.353  10.630  1.00 15.92          
ATOM   2706  CB  LYS   209     -12.322  95.634  10.279  1.00 15.35          
ATOM   2709  CG  LYS   209     -12.355  94.142  10.708  1.00 17.64          
ATOM   2712  CD  LYS   209     -11.567  93.203   9.711  1.00 20.11          
ATOM   2715  CE  LYS   209     -11.666  91.731  10.123  1.00 19.47          
ATOM   2718  NZ  LYS   209     -10.901  91.692  11.344  1.00 20.65          
ATOM   2722  C   LYS   209     -10.950  97.711   9.937  1.00 15.36          
ATOM   2723  O   LYS   209     -11.355  98.672  10.538  1.00 15.46          
ATOM   2725  N   VAL   210     -10.479  97.750   8.689  1.00 15.08          
ATOM   2726  CA  VAL   210     -10.553  98.951   7.829  1.00 15.57          
ATOM   2728  CB  VAL   210      -9.168  99.696   7.643  1.00 14.71          
ATOM   2730  CG1 VAL   210      -9.272 100.831   6.619  1.00 18.35          
ATOM   2734  CG2 VAL   210      -8.604 100.180   8.959  1.00 18.35          
ATOM   2738  C   VAL   210     -11.155  98.506   6.474  1.00 14.68          
ATOM   2739  O   VAL   210     -10.706  97.549   5.873  1.00 14.03          
ATOM   2741  N   VAL   211     -12.181  99.185   6.001  1.00 15.64          
ATOM   2742  CA  VAL   211     -12.831  98.810   4.697  1.00 15.09          
ATOM   2744  CB  VAL   211     -14.145  97.980   4.989  1.00 16.09          
ATOM   2746  CG1 VAL   211     -13.862  96.746   5.837  1.00 14.13          
ATOM   2750  CG2 VAL   211     -15.209  98.830   5.691  1.00 15.98          
ATOM   2754  C   VAL   211     -13.174 100.025   3.866  1.00 14.77          
ATOM   2755  O   VAL   211     -13.233 101.080   4.396  1.00 11.73          
ATOM   2757  N   PRO   212     -13.445  99.900   2.512  1.00 17.06          
ATOM   2758  CA  PRO   212     -13.921 101.159   1.922  1.00 17.19          
ATOM   2760  CB  PRO   212     -14.305 100.750   0.497  1.00 18.82          
ATOM   2763  CG  PRO   212     -13.353  99.628   0.192  1.00 19.04          
ATOM   2766  CD  PRO   212     -13.052  98.925   1.485  1.00 16.13          
ATOM   2769  C   PRO   212     -15.135 101.791   2.658  1.00 18.76          
ATOM   2770  O   PRO   212     -15.906 101.120   3.384  1.00 17.33          
ATOM   2771  N   GLU   213     -15.307 103.086   2.482  1.00 19.25          
ATOM   2772  CA  GLU   213     -16.484 103.738   3.022  1.00 20.79          
ATOM   2774  CB  GLU   213     -16.477 105.206   2.596  1.00 21.02          
ATOM   2777  CG  GLU   213     -17.736 105.977   2.967  1.00 24.18          
ATOM   2780  CD  GLU   213     -17.585 107.491   2.811  1.00 27.14          
ATOM   2781  OE1 GLU   213     -17.184 107.981   1.714  1.00 28.50          
ATOM   2782  OE2 GLU   213     -17.856 108.177   3.819  1.00 30.21          
ATOM   2783  C   GLU   213     -17.824 103.033   2.612  1.00 21.38          
ATOM   2784  O   GLU   213     -18.810 103.032   3.390  1.00 23.43          
ATOM   2786  N   ALA   214     -17.833 102.432   1.420  1.00 20.19          
ATOM   2787  CA  ALA   214     -18.988 101.723   0.852  1.00 20.15          
ATOM   2789  CB  ALA   214     -18.812 101.613  -0.714  1.00 18.33          
ATOM   2793  C   ALA   214     -19.225 100.332   1.504  1.00 19.74          
ATOM   2794  O   ALA   214     -20.290  99.769   1.359  1.00 17.74          
ATOM   2796  N   GLU   215     -18.262  99.812   2.283  1.00 21.29          
ATOM   2797  CA  GLU   215     -18.416  98.500   2.937  1.00 21.39          
ATOM   2799  CB  GLU   215     -17.210  97.622   2.623  1.00 21.99          
ATOM   2802  CG  GLU   215     -16.950  97.415   1.099  1.00 23.86          
ATOM   2805  CD  GLU   215     -15.724  96.513   0.816  1.00 26.03          
ATOM   2806  OE1 GLU   215     -14.945  96.119   1.730  1.00 27.52          
ATOM   2807  OE2 GLU   215     -15.547  96.163  -0.348  1.00 29.48          
ATOM   2808  C   GLU   215     -18.573  98.632   4.417  1.00 21.50          
ATOM   2809  O   GLU   215     -18.644  97.657   5.181  1.00 21.73          
ATOM   2811  N   LEU   216     -18.554  99.869   4.861  1.00 21.86          
ATOM   2812  CA  LEU   216     -18.421 100.145   6.284  1.00 19.44          
ATOM   2814  CB  LEU   216     -18.142 101.625   6.476  1.00 18.79          
ATOM   2817  CG  LEU   216     -18.039 102.169   7.936  1.00 16.12          
ATOM   2819  CD1 LEU   216     -16.962 101.490   8.719  1.00 13.83          
ATOM   2823  CD2 LEU   216     -17.864 103.637   7.891  1.00  9.01          
ATOM   2827  C   LEU   216     -19.643  99.749   7.082  1.00 20.22          
ATOM   2828  O   LEU   216     -19.529  99.118   8.115  1.00 22.13          
ATOM   2830  N   GLN   217     -20.798 100.216   6.668  1.00 22.03          
ATOM   2831  CA  GLN   217     -22.078  99.873   7.290  1.00 23.43          
ATOM   2833  CB  GLN   217     -23.216 100.646   6.575  1.00 24.69          
ATOM   2836  CG  GLN   217     -24.677 100.560   7.186  1.00 28.96          
ATOM   2839  CD  GLN   217     -24.820 101.076   8.653  1.00 33.30          
ATOM   2840  OE1 GLN   217     -24.511 102.243   8.968  1.00 36.19          
ATOM   2841  NE2 GLN   217     -25.338 100.214   9.528  1.00 34.41          
ATOM   2844  C   GLN   217     -22.291  98.352   7.283  1.00 23.28          
ATOM   2845  O   GLN   217     -22.572  97.784   8.308  1.00 23.33          
ATOM   2847  N   GLU   218     -22.105  97.687   6.152  1.00 23.93          
ATOM   2848  CA  GLU   218     -22.224  96.230   6.108  1.00 24.99          
ATOM   2850  CB  GLU   218     -22.186  95.694   4.692  1.00 25.20          
ATOM   2853  CG  GLU   218     -22.222  94.125   4.663  1.00 31.40          
ATOM   2856  CD  GLU   218     -23.501  93.449   5.354  1.00 37.43          
ATOM   2857  OE1 GLU   218     -24.658  93.787   4.944  1.00 42.00          
ATOM   2858  OE2 GLU   218     -23.341  92.552   6.252  1.00 37.45          
ATOM   2859  C   GLU   218     -21.175  95.488   6.917  1.00 24.20          
ATOM   2860  O   GLU   218     -21.494  94.466   7.552  1.00 23.78          
ATOM   2862  N   GLU   219     -19.934  95.982   6.912  1.00 24.03          
ATOM   2863  CA  GLU   219     -18.886  95.317   7.666  1.00 23.56          
ATOM   2865  CB  GLU   219     -17.507  95.828   7.309  1.00 24.48          
ATOM   2868  CG  GLU   219     -16.389  95.123   8.117  1.00 27.49          
ATOM   2871  CD  GLU   219     -16.099  93.700   7.628  1.00 31.58          
ATOM   2872  OE1 GLU   219     -16.823  93.172   6.722  1.00 34.57          
ATOM   2873  OE2 GLU   219     -15.128  93.120   8.153  1.00 34.06          
ATOM   2874  C   GLU   219     -19.093  95.427   9.124  1.00 21.74          
ATOM   2875  O   GLU   219     -18.815  94.496   9.865  1.00 24.10          
ATOM   2877  N   THR   220     -19.566  96.567   9.583  1.00 20.51          
ATOM   2878  CA  THR   220     -19.850  96.741  11.020  1.00 17.78          
ATOM   2880  CB  THR   220     -20.187  98.189  11.276  1.00 17.27          
ATOM   2882  OG1 THR   220     -19.047  98.984  10.954  1.00 17.78          
ATOM   2884  CG2 THR   220     -20.679  98.448  12.706  1.00 16.86          
ATOM   2888  C   THR   220     -21.082  95.937  11.434  1.00 17.39          
ATOM   2889  O   THR   220     -21.186  95.490  12.589  1.00 15.62          
ATOM   2891  N   MET   221     -22.050  95.831  10.501  1.00 16.50          
ATOM   2892  CA  MET   221     -23.284  95.049  10.724  1.00 17.34          
ATOM   2894  CB  MET   221     -24.372  95.341   9.642  1.00 17.93          
ATOM   2897  CG  MET   221     -25.119  96.659   9.843  1.00 19.23          
ATOM   2900  SD  MET   221     -25.605  96.801  11.607  1.00 24.57          
ATOM   2901  CE  MET   221     -27.246  96.093  11.392  1.00 21.33          
ATOM   2905  C   MET   221     -23.020  93.541  10.759  1.00 17.15          
ATOM   2906  O   MET   221     -23.736  92.839  11.393  1.00 16.60          
ATOM   2908  N   ARG   222     -22.043  93.059  10.007  1.00 17.61          
ATOM   2909  CA  ARG   222     -21.626  91.678  10.031  1.00 18.05          
ATOM   2911  CB  ARG   222     -20.470  91.443   9.043  1.00 18.43          
ATOM   2914  CG  ARG   222     -19.984  89.983   8.921  1.00 19.56          
ATOM   2917  CD  ARG   222     -18.661  89.841   8.102  1.00 22.18          
ATOM   2920  NE  ARG   222     -17.555  90.652   8.667  1.00 25.51          
ATOM   2922  CZ  ARG   222     -16.845  90.324   9.742  1.00 25.92          
ATOM   2923  NH1 ARG   222     -17.092  89.216  10.385  1.00 29.49          
ATOM   2926  NH2 ARG   222     -15.868  91.084  10.176  1.00 28.66          
ATOM   2929  C   ARG   222     -21.148  91.306  11.414  1.00 17.99          
ATOM   2930  O   ARG   222     -21.501  90.252  11.914  1.00 18.12          
ATOM   2932  N   ILE   223     -20.292  92.152  12.000  1.00 18.21          
ATOM   2933  CA  ILE   223     -19.815  91.929  13.376  1.00 17.43          
ATOM   2935  CB  ILE   223     -18.650  92.921  13.811  1.00 16.78          
ATOM   2937  CG1 ILE   223     -17.392  92.698  12.966  1.00 17.99          
ATOM   2940  CD  ILE   223     -16.388  93.920  13.040  1.00 15.84          
ATOM   2944  CG2 ILE   223     -18.318  92.804  15.249  1.00 13.85          
ATOM   2948  C   ILE   223     -21.015  92.019  14.308  1.00 16.64          
ATOM   2949  O   ILE   223     -21.161  91.175  15.166  1.00 16.90          
ATOM   2951  N   ALA   224     -21.864  93.024  14.136  1.00 15.31          
ATOM   2952  CA  ALA   224     -22.905  93.273  15.158  1.00 15.78          
ATOM   2954  CB  ALA   224     -23.548  94.745  15.021  1.00 14.62          
ATOM   2958  C   ALA   224     -24.007  92.170  15.139  1.00 14.91          
ATOM   2959  O   ALA   224     -24.485  91.769  16.181  1.00 13.13          
ATOM   2961  N   ARG   225     -24.428  91.755  13.940  1.00 15.23          
ATOM   2962  CA  ARG   225     -25.376  90.669  13.750  1.00 16.23          
ATOM   2964  CB  ARG   225     -25.720  90.483  12.257  1.00 16.86          
ATOM   2967  CG  ARG   225     -26.643  91.504  11.776  1.00 20.23          
ATOM   2970  CD  ARG   225     -27.407  91.074  10.575  1.00 25.65          
ATOM   2973  NE  ARG   225     -27.654  92.232   9.717  1.00 29.44          
ATOM   2975  CZ  ARG   225     -26.869  92.596   8.698  1.00 32.85          
ATOM   2976  NH1 ARG   225     -25.752  91.896   8.383  1.00 32.04          
ATOM   2979  NH2 ARG   225     -27.211  93.666   7.980  1.00 32.54          
ATOM   2982  C   ARG   225     -24.836  89.365  14.231  1.00 16.34          
ATOM   2983  O   ARG   225     -25.607  88.558  14.761  1.00 18.15          
ATOM   2985  N   LYS   226     -23.546  89.096  13.984  1.00 15.65          
ATOM   2986  CA  LYS   226     -22.926  87.890  14.516  1.00 15.61          
ATOM   2988  CB  LYS   226     -21.485  87.748  14.104  1.00 15.11          
ATOM   2991  CG  LYS   226     -20.764  86.542  14.698  1.00 15.61          
ATOM   2994  CD  LYS   226     -21.543  85.216  14.583  1.00 14.54          
ATOM   2997  CE  LYS   226     -20.686  84.046  15.051  1.00 14.02          
ATOM   3000  NZ  LYS   226     -21.290  82.725  14.679  1.00 17.57          
ATOM   3004  C   LYS   226     -23.036  87.877  16.007  1.00 15.66          
ATOM   3005  O   LYS   226     -23.430  86.909  16.601  1.00 18.10          
ATOM   3007  N   ILE   227     -22.714  88.971  16.624  1.00 15.72          
ATOM   3008  CA  ILE   227     -22.786  89.054  18.077  1.00 15.33          
ATOM   3010  CB  ILE   227     -22.212  90.403  18.599  1.00 13.82          
ATOM   3012  CG1 ILE   227     -20.687  90.453  18.344  1.00 15.84          
ATOM   3015  CD  ILE   227     -19.874  91.755  18.995  1.00  9.69          
ATOM   3019  CG2 ILE   227     -22.458  90.561  20.114  1.00 14.42          
ATOM   3023  C   ILE   227     -24.204  88.872  18.569  1.00 14.80          
ATOM   3024  O   ILE   227     -24.417  88.167  19.515  1.00 16.94          
ATOM   3026  N   ALA   228     -25.132  89.586  17.962  1.00 14.71          
ATOM   3027  CA  ALA   228     -26.551  89.567  18.275  1.00 15.02          
ATOM   3029  CB  ALA   228     -27.317  90.628  17.420  1.00 13.51          
ATOM   3033  C   ALA   228     -27.190  88.150  18.114  1.00 15.09          
ATOM   3034  O   ALA   228     -28.139  87.824  18.801  1.00 14.60          
ATOM   3036  N   SER   229     -26.619  87.346  17.220  1.00 15.04          
ATOM   3037  CA  SER   229     -26.992  85.970  17.044  1.00 14.66          
ATOM   3039  CB  SER   229     -26.544  85.498  15.676  1.00 14.33          
ATOM   3042  OG  SER   229     -25.239  85.032  15.696  1.00 13.00          
ATOM   3044  C   SER   229     -26.466  84.994  18.066  1.00 14.70          
ATOM   3045  O   SER   229     -26.821  83.830  17.973  1.00 14.93          
ATOM   3047  N   LEU   230     -25.578  85.424  18.958  1.00 13.97          
ATOM   3048  CA  LEU   230     -25.002  84.560  20.017  1.00 13.95          
ATOM   3050  CB  LEU   230     -23.507  84.855  20.251  1.00 13.31          
ATOM   3053  CG  LEU   230     -22.597  84.633  19.045  1.00 14.28          
ATOM   3055  CD1 LEU   230     -21.222  85.339  19.256  1.00 13.01          
ATOM   3059  CD2 LEU   230     -22.501  83.118  18.707  1.00 13.08          
ATOM   3063  C   LEU   230     -25.742  84.674  21.359  1.00 13.72          
ATOM   3064  O   LEU   230     -26.685  85.428  21.481  1.00 14.55          
ATOM   3066  N   SER   231     -25.347  83.875  22.355  1.00 13.96          
ATOM   3067  CA  SER   231     -25.977  83.950  23.669  1.00 13.31          
ATOM   3069  CB  SER   231     -25.675  82.726  24.476  1.00 12.96          
ATOM   3072  OG  SER   231     -25.981  82.958  25.830  1.00 11.33          
ATOM   3074  C   SER   231     -25.474  85.149  24.455  1.00 14.36          
ATOM   3075  O   SER   231     -24.297  85.218  24.802  1.00 15.12          
ATOM   3077  N   ARG   232     -26.377  86.069  24.786  1.00 14.66          
ATOM   3078  CA  ARG   232     -26.082  87.204  25.635  1.00 14.70          
ATOM   3080  CB  ARG   232     -27.326  88.030  25.937  1.00 13.46          
ATOM   3083  CG  ARG   232     -27.017  89.470  26.314  1.00 17.14          
ATOM   3086  CD  ARG   232     -28.102  90.058  27.218  1.00 21.44          
ATOM   3089  NE  ARG   232     -28.145  91.520  27.275  1.00 21.71          
ATOM   3091  CZ  ARG   232     -27.828  92.273  28.328  1.00 22.46          
ATOM   3092  NH1 ARG   232     -27.369  91.776  29.447  1.00 21.91          
ATOM   3095  NH2 ARG   232     -27.968  93.569  28.244  1.00 23.29          
ATOM   3098  C   ARG   232     -25.338  86.860  26.938  1.00 14.71          
ATOM   3099  O   ARG   232     -24.340  87.502  27.257  1.00 13.88          
END
