
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  260 ( 1905),  selected  260 , name 2hw5_F
# Molecule2: number of CA atoms  256 ( 1936),  selected  256 , name T0486.pdb
# PARAMETERS: 2hw5_F.T0486.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A    31_F      P      32           -
LGA    N    32_F      -       -           -
LGA    F    33_F      -       -           -
LGA    E    34_F      R      33          1.752
LGA    Y    35_F      P      34          0.734
LGA    I    36_F      T      35          1.402
LGA    I    37_F      S      36          1.377
LGA    A    38_F      A      37          0.604
LGA    E    39_F      R      38          0.591
LGA    K    40_F      Q      39          1.634
LGA    R    41_F      L      40          3.594
LGA    G    42_F      -       -           -
LGA    K    43_F      -       -           -
LGA    N    44_F      -       -           -
LGA    N    45_F      D      41          1.861
LGA    T    46_F      G      42          1.537
LGA    V    47_F      I      43          0.356
LGA    G    48_F      R      44          0.414
LGA    L    49_F      N      45          0.337
LGA    I    50_F      I      46          0.536
LGA    Q    51_F      V      47          0.637
LGA    L    52_F      L      48          0.506
LGA    N    53_F      S      49          0.495
LGA    R    54_F      N      50          0.333
LGA    P    55_F      P      51          0.759
LGA    K    56_F      K      52          0.327
LGA    A    57_F      K      53          0.918
LGA    L    58_F      R      54          0.987
LGA    N    59_F      N      55          0.734
LGA    A    60_F      T      56          0.893
LGA    L    61_F      L      57          0.835
LGA    C    62_F      S      58          0.716
LGA    D    63_F      L      59          1.131
LGA    G    64_F      A      60          1.059
LGA    L    65_F      M      61          0.941
LGA    I    66_F      L      62          1.075
LGA    D    67_F      K      63          0.884
LGA    E    68_F      S      64          0.876
LGA    L    69_F      L      65          0.903
LGA    N    70_F      Q      66          1.164
LGA    Q    71_F      S      67          1.216
LGA    A    72_F      D      68          0.735
LGA    L    73_F      I      69          0.837
LGA    K    74_F      L      70          1.441
LGA    I    75_F      H      71          1.857
LGA    F    76_F      D      72          4.947
LGA    E    77_F      A      73          1.597
LGA    E    78_F      D      74          3.579
LGA    D    79_F      S      75          3.440
LGA    P    80_F      N      76          2.021
LGA    A    81_F      D      77          1.391
LGA    V    82_F      L      78          1.608
LGA    G    83_F      K      79          0.288
LGA    A    84_F      V      80          0.215
LGA    I    85_F      I      81          0.315
LGA    V    86_F      I      82          0.233
LGA    L    87_F      I      83          0.275
LGA    T    88_F      S      84          0.363
LGA    G    89_F      A      85          0.807
LGA    G    90_F      E      86          2.428
LGA    D    91_F      G      87          4.033
LGA    K    92_F      P      88          0.688
LGA    A    93_F      V      89          1.478
LGA    F    94_F      F      90          1.199
LGA    A    95_F      S      91          0.809
LGA    A    96_F      S      92          1.351
LGA    G    97_F      G      93          1.439
LGA    A    98_F      H      94          0.998
LGA    D    99_F      D      95          0.765
LGA    I   100_F      L      96          0.743
LGA    K   101_F      K      97          0.593
LGA    E   102_F      E      98          0.726
LGA    M   103_F      L      99          0.897
LGA    Q   104_F      T     100          1.072
LGA    N   105_F      E     101          1.828
LGA    -       -      E     102           -
LGA    L   106_F      Q     103          4.404
LGA    S   107_F      G     104          4.524
LGA    F   108_F      R     105          4.765
LGA    Q   109_F      -       -           -
LGA    D   110_F      -       -           -
LGA    C   111_F      D     106          4.283
LGA    Y   112_F      Y     107           -
LGA    S   113_F      H     108           -
LGA    S   114_F      -       -           -
LGA    K   115_F      A     109          4.324
LGA    F   116_F      E     110          2.851
LGA    -       -      V     111           -
LGA    L   117_F      F     112          1.815
LGA    K   118_F      Q     113          1.860
LGA    H   119_F      T     114          2.130
LGA    W   120_F      C     115          1.708
LGA    D   121_F      S     116          3.281
LGA    -       -      K     117           -
LGA    H   122_F      V     118          2.851
LGA    L   123_F      M     119          3.940
LGA    T   124_F      M     120          2.426
LGA    Q   125_F      H     121          2.454
LGA    -       -      I     122           -
LGA    -       -      R     123           -
LGA    -       -      N     124           -
LGA    V   126_F      H     125          1.603
LGA    K   127_F      P     126          1.894
LGA    K   128_F      V     127          0.859
LGA    P   129_F      P     128          0.441
LGA    V   130_F      V     129          0.265
LGA    I   131_F      I     130          0.153
LGA    A   132_F      A     131          0.268
LGA    A   133_F      M     132          0.496
LGA    V   134_F      V     133          0.770
LGA    N   135_F      N     134          0.710
LGA    G   136_F      G     135          0.301
LGA    Y   137_F      L     136          0.708
LGA    A   138_F      A     137          0.717
LGA    F   139_F      T     138          0.344
LGA    G   140_F      A     139          0.643
LGA    G   141_F      A     140          0.562
LGA    G   142_F      G     141          0.474
LGA    C   143_F      C     142          0.610
LGA    E   144_F      Q     143          0.515
LGA    L   145_F      L     144          0.868
LGA    A   146_F      V     145          0.980
LGA    M   147_F      A     146          1.247
LGA    M   148_F      S     147          1.268
LGA    C   149_F      C     148          0.841
LGA    D   150_F      D     149          0.414
LGA    I   151_F      I     150          0.515
LGA    I   152_F      A     151          0.750
LGA    Y   153_F      V     152          0.597
LGA    A   154_F      A     153          0.890
LGA    G   155_F      S     154          0.865
LGA    E   156_F      D     155          1.098
LGA    K   157_F      K     156          0.778
LGA    A   158_F      S     157          0.649
LGA    Q   159_F      S     158          0.766
LGA    F   160_F      F     159          0.524
LGA    A   161_F      A     160          0.672
LGA    Q   162_F      T     161          0.782
LGA    P   163_F      P     162          0.908
LGA    E   164_F      G     163          1.106
LGA    I   165_F      V     164          1.628
LGA    L   166_F      N     165          1.536
LGA    I   167_F      V     166          1.355
LGA    G   168_F      G     167          1.442
LGA    T   169_F      L     168          2.068
LGA    I   170_F      F     169          2.391
LGA    P   171_F      C     170          2.469
LGA    G   172_F      S     171          4.348
LGA    A   173_F      T     172          3.377
LGA    G   174_F      -       -           -
LGA    G   175_F      P     173          1.922
LGA    T   176_F      G     174          1.646
LGA    Q   177_F      V     175          2.401
LGA    R   178_F      A     176          2.294
LGA    L   179_F      L     177          1.219
LGA    T   180_F      A     178          1.898
LGA    R   181_F      R     179          2.630
LGA    A   182_F      A     180          1.907
LGA    V   183_F      V     181          1.089
LGA    G   184_F      P     182          0.630
LGA    K   185_F      R     183          0.974
LGA    S   186_F      K     184          0.649
LGA    L   187_F      V     185          0.697
LGA    A   188_F      A     186          0.423
LGA    M   189_F      L     187          0.542
LGA    E   190_F      E     188          0.199
LGA    M   191_F      M     189          0.221
LGA    V   192_F      L     190          0.528
LGA    L   193_F      F     191          0.659
LGA    T   194_F      T     192          0.747
LGA    G   195_F      G     193          0.934
LGA    D   196_F      E     194          0.948
LGA    R   197_F      P     195          0.430
LGA    I   198_F      I     196          0.299
LGA    S   199_F      S     197          0.370
LGA    A   200_F      A     198          0.376
LGA    Q   201_F      Q     199          0.258
LGA    D   202_F      E     200          0.238
LGA    A   203_F      A     201          0.486
LGA    K   204_F      L     202          0.496
LGA    Q   205_F      L     203          0.626
LGA    A   206_F      H     204          0.533
LGA    G   207_F      G     205          1.311
LGA    L   208_F      L     206          0.977
LGA    V   209_F      L     207          0.388
LGA    S   210_F      S     208          1.063
LGA    K   211_F      K     209          0.380
LGA    I   212_F      V     210          0.574
LGA    C   213_F      V     211          1.484
LGA    P   214_F      P     212          1.568
LGA    V   215_F      E     213          1.340
LGA    E   216_F      A     214          2.765
LGA    T   217_F      E     215          3.037
LGA    L   218_F      L     216          1.404
LGA    V   219_F      Q     217          2.764
LGA    E   220_F      E     218          2.821
LGA    E   221_F      E     219          1.676
LGA    A   222_F      T     220          1.159
LGA    I   223_F      M     221          2.057
LGA    Q   224_F      R     222          2.032
LGA    C   225_F      I     223          0.628
LGA    A   226_F      A     224          0.911
LGA    E   227_F      R     225          1.058
LGA    K   228_F      K     226          0.600
LGA    I   229_F      I     227          0.700
LGA    A   230_F      A     228          1.176
LGA    S   231_F      S     229          1.157
LGA    N   232_F      L     230          1.054
LGA    S   233_F      S     231          1.033
LGA    K   234_F      R     232          0.754
LGA    I   235_F      P     233          1.021
LGA    V   236_F      V     234          0.874
LGA    V   237_F      V     235          0.287
LGA    A   238_F      S     236          0.810
LGA    M   239_F      L     237          1.460
LGA    A   240_F      G     238          1.165
LGA    K   241_F      K     239          0.884
LGA    E   242_F      A     240          1.655
LGA    S   243_F      T     241          2.564
LGA    V   244_F      F     242          2.461
LGA    N   245_F      Y     243          1.663
LGA    A   246_F      K     244          2.823
LGA    A   247_F      Q     245          4.743
LGA    F   248_F      L     246          4.080
LGA    E   249_F      P     247          2.489
LGA    M   250_F      Q     248          1.944
LGA    T   251_F      D     249          2.131
LGA    L   252_F      L     250          2.525
LGA    T   253_F      G     251          2.486
LGA    E   254_F      T     252          1.577
LGA    G   255_F      A     253          1.595
LGA    S   256_F      Y     254          1.804
LGA    K   257_F      Y     255          1.541
LGA    L   258_F      L     256          1.392
LGA    E   259_F      T     257          1.113
LGA    K   260_F      S     258          1.095
LGA    K   261_F      Q     259          1.469
LGA    L   262_F      A     260          1.007
LGA    F   263_F      M     261          1.048
LGA    Y   264_F      V     262          1.336
LGA    S   265_F      D     263          1.068
LGA    T   266_F      N     264          0.416
LGA    F   267_F      L     265          1.800
LGA    A   268_F      A     266          2.053
LGA    T   269_F      L     267          0.704
LGA    D   270_F      R     268          0.375
LGA    D   271_F      D     269          0.441
LGA    R   272_F      G     270          0.306
LGA    K   273_F      Q     271          0.662
LGA    E   274_F      E     272          0.488
LGA    G   275_F      G     273          0.551
LGA    M   276_F      I     274          0.115
LGA    T   277_F      T     275          0.301
LGA    A   278_F      A     276          0.371
LGA    F   279_F      F     277          0.356
LGA    V   280_F      L     278          0.223
LGA    E   281_F      Q     279          0.228
LGA    K   282_F      K     280          0.256
LGA    R   283_F      R     281          0.376
LGA    K   284_F      K     282          0.352
LGA    A   285_F      P     283          0.267
LGA    N   286_F      V     284          0.771
LGA    F   287_F      W     285          0.864
LGA    K   288_F      S     286          1.159
LGA    D   289_F      H     287          1.261
LGA    Q   290_F      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  260  256    5.0    247    1.62    31.17     88.934    14.368

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.887589 * X  +  -0.099787 * Y  +  -0.449698 * Z  +  61.201725
  Y_new =   0.413807 * X  +  -0.256143 * Y  +   0.873587 * Z  +  44.278641
  Z_new =  -0.202360 * X  +  -0.961474 * Y  +  -0.186057 * Z  + 102.852310 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.761946    1.379646  [ DEG:  -100.9521     79.0479 ]
  Theta =   0.203767    2.937825  [ DEG:    11.6750    168.3250 ]
  Phi   =   0.436256   -2.705337  [ DEG:    24.9956   -155.0044 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2hw5_F                                        
REMARK     2: T0486.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2hw5_F.T0486.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  260  256   5.0  247   1.62   31.17  88.934
REMARK  ---------------------------------------------------------- 
MOLECULE 2hw5_F
HEADER    LYASE                                   31-JUL-06   2HW5              
TITLE     THE CRYSTAL STRUCTURE OF HUMAN ENOYL-COENZYME A (COA)                 
TITLE    2 HYDRATASE SHORT CHAIN 1, ECHS1                                       
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ENOYL-COA HYDRATASE;                                       
COMPND   3 CHAIN: A, B, C, D, E, F;                                             
COMPND   4 SYNONYM: SHORT CHAIN ENOYL-COA HYDRATASE, SCEH, ENOYL-COA            
COMPND   5 HYDRATASE 1;                                                         
COMPND   6 EC: 4.2.1.17;                                                        
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: ECHS1;                                                         
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL-21(DE3)R3;                              
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PNIC28-BSA4                               
KEYWDS    FATTY ACID METABOLISM, HYDRATASE/ISOMERASE SUPERFAMILY,               
KEYWDS   2 BETA-OXIDATION, COA, ENOYL-COA HYDRATASE, LYASE, STRUCTURAL          
KEYWDS   3 GENOMICS, STRUCTURAL GENOMICS CONSORTIUM, SGC                        
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    A.P.TURNBULL,E.SALAH,F.NIESEN,J.DEBRECZENI,E.UGOCHUKWU,               
AUTHOR   2 A.C.W.PIKE,K.KAVANAGH,O.GILEADI,F.GORREC,C.UMEANO,F.VON              
AUTHOR   3 DELFT,J.WEIGELT,A.EDWARDS,C.ARROWSMITH,M.SUNDSTROM,                  
AUTHOR   4 U.OPPERMANN,STRUCTURAL GENOMICS CONSORTIUM (SGC)                     
REVDAT   1   22-AUG-06 2HW5    0                                                
JRNL        AUTH   A.P.TURNBULL,E.SALAH,F.NIESEN,J.DEBRECZENI,                  
JRNL        AUTH 2 E.UGOCHUKWU,A.C.W.PIKE,K.KAVANAGH,O.GILEADI,                 
JRNL        AUTH 3 F.GORREC,C.UMEANO,F.VON DELFT,J.WEIGELT,A.EDWARDS,           
JRNL        AUTH 4 C.ARROWSMITH,M.SUNDSTROM,U.OPPERMANN                         
JRNL        TITL   THE CRYSTAL STRUCTURE OF HUMAN ENOYL-COENZYME A              
JRNL        TITL 2 (COA) HYDRATASE SHORT CHAIN 1, ECHS1                         
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.55 ANGSTROMS.                                          
DBREF  2HW5 A   28   290  UNP    P30084   ECHM_HUMAN      28    290             
DBREF  2HW5 B   28   290  UNP    P30084   ECHM_HUMAN      28    290             
DBREF  2HW5 C   28   290  UNP    P30084   ECHM_HUMAN      28    290             
DBREF  2HW5 D   28   290  UNP    P30084   ECHM_HUMAN      28    290             
DBREF  2HW5 E   28   290  UNP    P30084   ECHM_HUMAN      28    290             
DBREF  2HW5 F   28   290  UNP    P30084   ECHM_HUMAN      28    290             
SEQRES   1 A  286  MET HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 A  286  GLY THR GLU ASN LEU TYR PHE GLN SER MET ALA SER GLY          
SEQRES   3 A  286  ALA ASN PHE GLU TYR ILE ILE ALA GLU LYS ARG GLY LYS          
SEQRES   4 A  286  ASN ASN THR VAL GLY LEU ILE GLN LEU ASN ARG PRO LYS          
SEQRES   5 A  286  ALA LEU ASN ALA LEU CYS ASP GLY LEU ILE ASP GLU LEU          
SEQRES   6 A  286  ASN GLN ALA LEU LYS ILE PHE GLU GLU ASP PRO ALA VAL          
SEQRES   7 A  286  GLY ALA ILE VAL LEU THR GLY GLY ASP LYS ALA PHE ALA          
SEQRES   8 A  286  ALA GLY ALA ASP ILE LYS GLU MET GLN ASN LEU SER PHE          
SEQRES   9 A  286  GLN ASP CYS TYR SER SER LYS PHE LEU LYS HIS TRP ASP          
SEQRES  10 A  286  HIS LEU THR GLN VAL LYS LYS PRO VAL ILE ALA ALA VAL          
SEQRES  11 A  286  ASN GLY TYR ALA PHE GLY GLY GLY CYS GLU LEU ALA MET          
SEQRES  12 A  286  MET CYS ASP ILE ILE TYR ALA GLY GLU LYS ALA GLN PHE          
SEQRES  13 A  286  ALA GLN PRO GLU ILE LEU ILE GLY THR ILE PRO GLY ALA          
SEQRES  14 A  286  GLY GLY THR GLN ARG LEU THR ARG ALA VAL GLY LYS SER          
SEQRES  15 A  286  LEU ALA MET GLU MET VAL LEU THR GLY ASP ARG ILE SER          
SEQRES  16 A  286  ALA GLN ASP ALA LYS GLN ALA GLY LEU VAL SER LYS ILE          
SEQRES  17 A  286  CYS PRO VAL GLU THR LEU VAL GLU GLU ALA ILE GLN CYS          
SEQRES  18 A  286  ALA GLU LYS ILE ALA SER ASN SER LYS ILE VAL VAL ALA          
SEQRES  19 A  286  MET ALA LYS GLU SER VAL ASN ALA ALA PHE GLU MET THR          
SEQRES  20 A  286  LEU THR GLU GLY SER LYS LEU GLU LYS LYS LEU PHE TYR          
SEQRES  21 A  286  SER THR PHE ALA THR ASP ASP ARG LYS GLU GLY MET THR          
SEQRES  22 A  286  ALA PHE VAL GLU LYS ARG LYS ALA ASN PHE LYS ASP GLN          
SEQRES   1 B  286  MET HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 B  286  GLY THR GLU ASN LEU TYR PHE GLN SER MET ALA SER GLY          
SEQRES   3 B  286  ALA ASN PHE GLU TYR ILE ILE ALA GLU LYS ARG GLY LYS          
SEQRES   4 B  286  ASN ASN THR VAL GLY LEU ILE GLN LEU ASN ARG PRO LYS          
SEQRES   5 B  286  ALA LEU ASN ALA LEU CYS ASP GLY LEU ILE ASP GLU LEU          
SEQRES   6 B  286  ASN GLN ALA LEU LYS ILE PHE GLU GLU ASP PRO ALA VAL          
SEQRES   7 B  286  GLY ALA ILE VAL LEU THR GLY GLY ASP LYS ALA PHE ALA          
SEQRES   8 B  286  ALA GLY ALA ASP ILE LYS GLU MET GLN ASN LEU SER PHE          
SEQRES   9 B  286  GLN ASP CYS TYR SER SER LYS PHE LEU LYS HIS TRP ASP          
SEQRES  10 B  286  HIS LEU THR GLN VAL LYS LYS PRO VAL ILE ALA ALA VAL          
SEQRES  11 B  286  ASN GLY TYR ALA PHE GLY GLY GLY CYS GLU LEU ALA MET          
SEQRES  12 B  286  MET CYS ASP ILE ILE TYR ALA GLY GLU LYS ALA GLN PHE          
SEQRES  13 B  286  ALA GLN PRO GLU ILE LEU ILE GLY THR ILE PRO GLY ALA          
SEQRES  14 B  286  GLY GLY THR GLN ARG LEU THR ARG ALA VAL GLY LYS SER          
SEQRES  15 B  286  LEU ALA MET GLU MET VAL LEU THR GLY ASP ARG ILE SER          
SEQRES  16 B  286  ALA GLN ASP ALA LYS GLN ALA GLY LEU VAL SER LYS ILE          
SEQRES  17 B  286  CYS PRO VAL GLU THR LEU VAL GLU GLU ALA ILE GLN CYS          
SEQRES  18 B  286  ALA GLU LYS ILE ALA SER ASN SER LYS ILE VAL VAL ALA          
SEQRES  19 B  286  MET ALA LYS GLU SER VAL ASN ALA ALA PHE GLU MET THR          
SEQRES  20 B  286  LEU THR GLU GLY SER LYS LEU GLU LYS LYS LEU PHE TYR          
SEQRES  21 B  286  SER THR PHE ALA THR ASP ASP ARG LYS GLU GLY MET THR          
SEQRES  22 B  286  ALA PHE VAL GLU LYS ARG LYS ALA ASN PHE LYS ASP GLN          
SEQRES   1 C  286  MET HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 C  286  GLY THR GLU ASN LEU TYR PHE GLN SER MET ALA SER GLY          
SEQRES   3 C  286  ALA ASN PHE GLU TYR ILE ILE ALA GLU LYS ARG GLY LYS          
SEQRES   4 C  286  ASN ASN THR VAL GLY LEU ILE GLN LEU ASN ARG PRO LYS          
SEQRES   5 C  286  ALA LEU ASN ALA LEU CYS ASP GLY LEU ILE ASP GLU LEU          
SEQRES   6 C  286  ASN GLN ALA LEU LYS ILE PHE GLU GLU ASP PRO ALA VAL          
SEQRES   7 C  286  GLY ALA ILE VAL LEU THR GLY GLY ASP LYS ALA PHE ALA          
SEQRES   8 C  286  ALA GLY ALA ASP ILE LYS GLU MET GLN ASN LEU SER PHE          
SEQRES   9 C  286  GLN ASP CYS TYR SER SER LYS PHE LEU LYS HIS TRP ASP          
SEQRES  10 C  286  HIS LEU THR GLN VAL LYS LYS PRO VAL ILE ALA ALA VAL          
SEQRES  11 C  286  ASN GLY TYR ALA PHE GLY GLY GLY CYS GLU LEU ALA MET          
SEQRES  12 C  286  MET CYS ASP ILE ILE TYR ALA GLY GLU LYS ALA GLN PHE          
SEQRES  13 C  286  ALA GLN PRO GLU ILE LEU ILE GLY THR ILE PRO GLY ALA          
SEQRES  14 C  286  GLY GLY THR GLN ARG LEU THR ARG ALA VAL GLY LYS SER          
SEQRES  15 C  286  LEU ALA MET GLU MET VAL LEU THR GLY ASP ARG ILE SER          
SEQRES  16 C  286  ALA GLN ASP ALA LYS GLN ALA GLY LEU VAL SER LYS ILE          
SEQRES  17 C  286  CYS PRO VAL GLU THR LEU VAL GLU GLU ALA ILE GLN CYS          
SEQRES  18 C  286  ALA GLU LYS ILE ALA SER ASN SER LYS ILE VAL VAL ALA          
SEQRES  19 C  286  MET ALA LYS GLU SER VAL ASN ALA ALA PHE GLU MET THR          
SEQRES  20 C  286  LEU THR GLU GLY SER LYS LEU GLU LYS LYS LEU PHE TYR          
SEQRES  21 C  286  SER THR PHE ALA THR ASP ASP ARG LYS GLU GLY MET THR          
SEQRES  22 C  286  ALA PHE VAL GLU LYS ARG LYS ALA ASN PHE LYS ASP GLN          
SEQRES   1 D  286  MET HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 D  286  GLY THR GLU ASN LEU TYR PHE GLN SER MET ALA SER GLY          
SEQRES   3 D  286  ALA ASN PHE GLU TYR ILE ILE ALA GLU LYS ARG GLY LYS          
SEQRES   4 D  286  ASN ASN THR VAL GLY LEU ILE GLN LEU ASN ARG PRO LYS          
SEQRES   5 D  286  ALA LEU ASN ALA LEU CYS ASP GLY LEU ILE ASP GLU LEU          
SEQRES   6 D  286  ASN GLN ALA LEU LYS ILE PHE GLU GLU ASP PRO ALA VAL          
SEQRES   7 D  286  GLY ALA ILE VAL LEU THR GLY GLY ASP LYS ALA PHE ALA          
SEQRES   8 D  286  ALA GLY ALA ASP ILE LYS GLU MET GLN ASN LEU SER PHE          
SEQRES   9 D  286  GLN ASP CYS TYR SER SER LYS PHE LEU LYS HIS TRP ASP          
SEQRES  10 D  286  HIS LEU THR GLN VAL LYS LYS PRO VAL ILE ALA ALA VAL          
SEQRES  11 D  286  ASN GLY TYR ALA PHE GLY GLY GLY CYS GLU LEU ALA MET          
SEQRES  12 D  286  MET CYS ASP ILE ILE TYR ALA GLY GLU LYS ALA GLN PHE          
SEQRES  13 D  286  ALA GLN PRO GLU ILE LEU ILE GLY THR ILE PRO GLY ALA          
SEQRES  14 D  286  GLY GLY THR GLN ARG LEU THR ARG ALA VAL GLY LYS SER          
SEQRES  15 D  286  LEU ALA MET GLU MET VAL LEU THR GLY ASP ARG ILE SER          
SEQRES  16 D  286  ALA GLN ASP ALA LYS GLN ALA GLY LEU VAL SER LYS ILE          
SEQRES  17 D  286  CYS PRO VAL GLU THR LEU VAL GLU GLU ALA ILE GLN CYS          
SEQRES  18 D  286  ALA GLU LYS ILE ALA SER ASN SER LYS ILE VAL VAL ALA          
SEQRES  19 D  286  MET ALA LYS GLU SER VAL ASN ALA ALA PHE GLU MET THR          
SEQRES  20 D  286  LEU THR GLU GLY SER LYS LEU GLU LYS LYS LEU PHE TYR          
SEQRES  21 D  286  SER THR PHE ALA THR ASP ASP ARG LYS GLU GLY MET THR          
SEQRES  22 D  286  ALA PHE VAL GLU LYS ARG LYS ALA ASN PHE LYS ASP GLN          
SEQRES   1 E  286  MET HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 E  286  GLY THR GLU ASN LEU TYR PHE GLN SER MET ALA SER GLY          
SEQRES   3 E  286  ALA ASN PHE GLU TYR ILE ILE ALA GLU LYS ARG GLY LYS          
SEQRES   4 E  286  ASN ASN THR VAL GLY LEU ILE GLN LEU ASN ARG PRO LYS          
SEQRES   5 E  286  ALA LEU ASN ALA LEU CYS ASP GLY LEU ILE ASP GLU LEU          
SEQRES   6 E  286  ASN GLN ALA LEU LYS ILE PHE GLU GLU ASP PRO ALA VAL          
SEQRES   7 E  286  GLY ALA ILE VAL LEU THR GLY GLY ASP LYS ALA PHE ALA          
SEQRES   8 E  286  ALA GLY ALA ASP ILE LYS GLU MET GLN ASN LEU SER PHE          
SEQRES   9 E  286  GLN ASP CYS TYR SER SER LYS PHE LEU LYS HIS TRP ASP          
SEQRES  10 E  286  HIS LEU THR GLN VAL LYS LYS PRO VAL ILE ALA ALA VAL          
SEQRES  11 E  286  ASN GLY TYR ALA PHE GLY GLY GLY CYS GLU LEU ALA MET          
SEQRES  12 E  286  MET CYS ASP ILE ILE TYR ALA GLY GLU LYS ALA GLN PHE          
SEQRES  13 E  286  ALA GLN PRO GLU ILE LEU ILE GLY THR ILE PRO GLY ALA          
SEQRES  14 E  286  GLY GLY THR GLN ARG LEU THR ARG ALA VAL GLY LYS SER          
SEQRES  15 E  286  LEU ALA MET GLU MET VAL LEU THR GLY ASP ARG ILE SER          
SEQRES  16 E  286  ALA GLN ASP ALA LYS GLN ALA GLY LEU VAL SER LYS ILE          
SEQRES  17 E  286  CYS PRO VAL GLU THR LEU VAL GLU GLU ALA ILE GLN CYS          
SEQRES  18 E  286  ALA GLU LYS ILE ALA SER ASN SER LYS ILE VAL VAL ALA          
SEQRES  19 E  286  MET ALA LYS GLU SER VAL ASN ALA ALA PHE GLU MET THR          
SEQRES  20 E  286  LEU THR GLU GLY SER LYS LEU GLU LYS LYS LEU PHE TYR          
SEQRES  21 E  286  SER THR PHE ALA THR ASP ASP ARG LYS GLU GLY MET THR          
SEQRES  22 E  286  ALA PHE VAL GLU LYS ARG LYS ALA ASN PHE LYS ASP GLN          
SEQRES   1 F  286  MET HIS HIS HIS HIS HIS HIS SER SER GLY VAL ASP LEU          
SEQRES   2 F  286  GLY THR GLU ASN LEU TYR PHE GLN SER MET ALA SER GLY          
SEQRES   3 F  286  ALA ASN PHE GLU TYR ILE ILE ALA GLU LYS ARG GLY LYS          
SEQRES   4 F  286  ASN ASN THR VAL GLY LEU ILE GLN LEU ASN ARG PRO LYS          
SEQRES   5 F  286  ALA LEU ASN ALA LEU CYS ASP GLY LEU ILE ASP GLU LEU          
SEQRES   6 F  286  ASN GLN ALA LEU LYS ILE PHE GLU GLU ASP PRO ALA VAL          
SEQRES   7 F  286  GLY ALA ILE VAL LEU THR GLY GLY ASP LYS ALA PHE ALA          
SEQRES   8 F  286  ALA GLY ALA ASP ILE LYS GLU MET GLN ASN LEU SER PHE          
SEQRES   9 F  286  GLN ASP CYS TYR SER SER LYS PHE LEU LYS HIS TRP ASP          
SEQRES  10 F  286  HIS LEU THR GLN VAL LYS LYS PRO VAL ILE ALA ALA VAL          
SEQRES  11 F  286  ASN GLY TYR ALA PHE GLY GLY GLY CYS GLU LEU ALA MET          
SEQRES  12 F  286  MET CYS ASP ILE ILE TYR ALA GLY GLU LYS ALA GLN PHE          
SEQRES  13 F  286  ALA GLN PRO GLU ILE LEU ILE GLY THR ILE PRO GLY ALA          
SEQRES  14 F  286  GLY GLY THR GLN ARG LEU THR ARG ALA VAL GLY LYS SER          
SEQRES  15 F  286  LEU ALA MET GLU MET VAL LEU THR GLY ASP ARG ILE SER          
SEQRES  16 F  286  ALA GLN ASP ALA LYS GLN ALA GLY LEU VAL SER LYS ILE          
SEQRES  17 F  286  CYS PRO VAL GLU THR LEU VAL GLU GLU ALA ILE GLN CYS          
SEQRES  18 F  286  ALA GLU LYS ILE ALA SER ASN SER LYS ILE VAL VAL ALA          
SEQRES  19 F  286  MET ALA LYS GLU SER VAL ASN ALA ALA PHE GLU MET THR          
SEQRES  20 F  286  LEU THR GLU GLY SER LYS LEU GLU LYS LYS LEU PHE TYR          
SEQRES  21 F  286  SER THR PHE ALA THR ASP ASP ARG LYS GLU GLY MET THR          
SEQRES  22 F  286  ALA PHE VAL GLU LYS ARG LYS ALA ASN PHE LYS ASP GLN          
HET     MG     11       1                                                       
HET     MG     12       1                                                       
HET     MG     13       1                                                       
HET     MG     14       1                                                       
HET    COO      1      35                                                       
HET    COO      2      35                                                       
HETNAM      MG MAGNESIUM ION                                                    
HETNAM     COO CROTONYL COENZYME A                                              
FORMUL   7   MG    4(MG 2+)                                                     
FORMUL  11  COO    2(C25 H40 N7 O17 P3 S)                                       
CRYST1   91.554   97.344  231.796  90.00  90.00  90.00 P 21 21 21   24          
ATOM   9576  N   ALA F  31     -35.523 108.934  25.584  1.00 80.89           N  
ATOM   9577  CA  ALA F  31     -36.084 110.313  25.426  1.00 81.11           C  
ATOM   9578  C   ALA F  31     -35.793 110.873  24.029  1.00 80.97           C  
ATOM   9579  O   ALA F  31     -34.933 110.357  23.309  1.00 81.34           O  
ATOM   9580  CB  ALA F  31     -35.517 111.245  26.504  1.00 81.01           C  
ATOM   9581  N   ASN F  32     -36.509 111.931  23.657  1.00 80.61           N  
ATOM   9582  CA  ASN F  32     -36.270 112.629  22.391  1.00 80.40           C  
ATOM   9583  C   ASN F  32     -34.951 113.420  22.432  1.00 80.14           C  
ATOM   9584  O   ASN F  32     -34.911 114.553  22.917  1.00 80.28           O  
ATOM   9585  CB  ASN F  32     -37.449 113.560  22.079  1.00 80.38           C  
ATOM   9586  CG  ASN F  32     -37.418 114.097  20.658  1.00 80.53           C  
ATOM   9587  OD1 ASN F  32     -36.455 113.887  19.916  1.00 80.60           O  
ATOM   9588  ND2 ASN F  32     -38.484 114.792  20.271  1.00 80.30           N  
ATOM   9589  N   PHE F  33     -33.884 112.815  21.911  1.00 79.69           N  
ATOM   9590  CA  PHE F  33     -32.536 113.393  21.974  1.00 79.33           C  
ATOM   9591  C   PHE F  33     -32.338 114.531  20.980  1.00 79.06           C  
ATOM   9592  O   PHE F  33     -32.985 114.564  19.942  1.00 78.95           O  
ATOM   9593  CB  PHE F  33     -31.489 112.326  21.674  1.00 79.24           C  
ATOM   9594  CG  PHE F  33     -31.513 111.163  22.620  1.00 79.23           C  
ATOM   9595  CD1 PHE F  33     -31.016 111.290  23.906  1.00 78.89           C  
ATOM   9596  CD2 PHE F  33     -32.007 109.933  22.214  1.00 79.28           C  
ATOM   9597  CE1 PHE F  33     -31.023 110.220  24.778  1.00 79.05           C  
ATOM   9598  CE2 PHE F  33     -32.011 108.853  23.078  1.00 79.31           C  
ATOM   9599  CZ  PHE F  33     -31.516 108.996  24.363  1.00 79.22           C  
ATOM   9600  N   GLU F  34     -31.418 115.442  21.300  1.00 78.83           N  
ATOM   9601  CA  GLU F  34     -31.112 116.592  20.438  1.00 78.77           C  
ATOM   9602  C   GLU F  34     -29.697 116.588  19.849  1.00 78.32           C  
ATOM   9603  O   GLU F  34     -29.472 117.221  18.820  1.00 77.93           O  
ATOM   9604  CB  GLU F  34     -31.366 117.908  21.190  1.00 78.90           C  
ATOM   9605  CG  GLU F  34     -30.390 118.225  22.336  1.00 79.43           C  
ATOM   9606  CD  GLU F  34     -30.728 119.532  23.075  1.00 79.65           C  
ATOM   9607  OE1 GLU F  34     -29.967 119.890  24.003  1.00 81.13           O  
ATOM   9608  OE2 GLU F  34     -31.740 120.199  22.735  1.00 79.30           O  
ATOM   9609  N   TYR F  35     -28.752 115.893  20.496  1.00 78.04           N  
ATOM   9610  CA  TYR F  35     -27.367 115.785  19.992  1.00 77.76           C  
ATOM   9611  C   TYR F  35     -27.071 114.466  19.282  1.00 77.30           C  
ATOM   9612  O   TYR F  35     -26.081 114.374  18.560  1.00 77.11           O  
ATOM   9613  CB  TYR F  35     -26.345 115.987  21.121  1.00 78.04           C  
ATOM   9614  CG  TYR F  35     -26.495 117.313  21.816  1.00 78.40           C  
ATOM   9615  CD1 TYR F  35     -26.096 118.489  21.195  1.00 79.14           C  
ATOM   9616  CD2 TYR F  35     -27.063 117.397  23.078  1.00 78.87           C  
ATOM   9617  CE1 TYR F  35     -26.258 119.720  21.814  1.00 79.41           C  
ATOM   9618  CE2 TYR F  35     -27.227 118.621  23.710  1.00 79.38           C  
ATOM   9619  CZ  TYR F  35     -26.821 119.781  23.073  1.00 79.33           C  
ATOM   9620  OH  TYR F  35     -26.983 120.999  23.694  1.00 79.20           O  
ATOM   9621  N   ILE F  36     -27.911 113.452  19.490  1.00 76.85           N  
ATOM   9622  CA  ILE F  36     -27.660 112.118  18.933  1.00 76.56           C  
ATOM   9623  C   ILE F  36     -28.925 111.453  18.381  1.00 76.36           C  
ATOM   9624  O   ILE F  36     -30.042 111.910  18.627  1.00 76.02           O  
ATOM   9625  CB  ILE F  36     -26.995 111.164  19.990  1.00 76.40           C  
ATOM   9626  CG1 ILE F  36     -27.997 110.721  21.060  1.00 76.43           C  
ATOM   9627  CG2 ILE F  36     -25.823 111.836  20.667  1.00 75.78           C  
ATOM   9628  CD1 ILE F  36     -27.410 109.789  22.075  1.00 76.61           C  
ATOM   9629  N   ILE F  37     -28.720 110.367  17.635  1.00 76.28           N  
ATOM   9630  CA  ILE F  37     -29.804 109.488  17.192  1.00 76.14           C  
ATOM   9631  C   ILE F  37     -29.556 108.102  17.762  1.00 75.99           C  
ATOM   9632  O   ILE F  37     -28.438 107.589  17.693  1.00 75.62           O  
ATOM   9633  CB  ILE F  37     -29.876 109.391  15.659  1.00 76.25           C  
ATOM   9634  CG1 ILE F  37     -30.278 110.741  15.063  1.00 76.30           C  
ATOM   9635  CG2 ILE F  37     -30.868 108.302  15.229  1.00 75.87           C  
ATOM   9636  CD1 ILE F  37     -29.941 110.869  13.596  1.00 76.71           C  
ATOM   9637  N   ALA F  38     -30.608 107.509  18.317  1.00 75.96           N  
ATOM   9638  CA  ALA F  38     -30.525 106.216  18.983  1.00 75.96           C  
ATOM   9639  C   ALA F  38     -31.669 105.322  18.521  1.00 76.08           C  
ATOM   9640  O   ALA F  38     -32.839 105.626  18.750  1.00 75.79           O  
ATOM   9641  CB  ALA F  38     -30.582 106.405  20.480  1.00 75.99           C  
ATOM   9642  N   GLU F  39     -31.319 104.213  17.880  1.00 76.23           N  
ATOM   9643  CA  GLU F  39     -32.304 103.343  17.260  1.00 76.42           C  
ATOM   9644  C   GLU F  39     -31.791 101.909  17.183  1.00 76.60           C  
ATOM   9645  O   GLU F  39     -30.585 101.672  17.214  1.00 76.69           O  
ATOM   9646  CB  GLU F  39     -32.629 103.855  15.854  1.00 76.36           C  
ATOM   9647  N   LYS F  40     -32.724 100.967  17.069  1.00 76.93           N  
ATOM   9648  CA  LYS F  40     -32.418  99.538  16.981  1.00 77.31           C  
ATOM   9649  C   LYS F  40     -32.255  99.095  15.519  1.00 77.42           C  
ATOM   9650  O   LYS F  40     -32.951  99.595  14.632  1.00 77.12           O  
ATOM   9651  CB  LYS F  40     -33.517  98.728  17.681  1.00 77.38           C  
ATOM   9652  CG  LYS F  40     -33.635  99.035  19.180  1.00 77.69           C  
ATOM   9653  CD  LYS F  40     -34.834  98.349  19.825  1.00 77.74           C  
ATOM   9654  CE  LYS F  40     -34.656  96.840  19.886  1.00 78.28           C  
ATOM   9655  NZ  LYS F  40     -35.670  96.170  20.751  1.00 78.49           N  
ATOM   9656  N   ARG F  41     -31.329  98.162  15.271  1.00 77.68           N  
ATOM   9657  CA  ARG F  41     -30.906  97.833  13.899  1.00 77.81           C  
ATOM   9658  C   ARG F  41     -30.554  96.363  13.683  1.00 77.86           C  
ATOM   9659  O   ARG F  41     -30.495  95.586  14.624  1.00 77.92           O  
ATOM   9660  CB  ARG F  41     -29.717  98.714  13.517  1.00 77.85           C  
ATOM   9661  CG  ARG F  41     -30.070 100.193  13.408  1.00 78.29           C  
ATOM   9662  CD  ARG F  41     -30.786 100.495  12.109  1.00 78.35           C  
ATOM   9663  NE  ARG F  41     -29.804 100.955  11.139  1.00 78.77           N  
ATOM   9664  CZ  ARG F  41     -29.611 102.224  10.784  1.00 79.12           C  
ATOM   9665  NH1 ARG F  41     -30.371 103.203  11.282  1.00 78.51           N  
ATOM   9666  NH2 ARG F  41     -28.655 102.509   9.901  1.00 79.20           N  
ATOM   9667  N   GLY F  42     -30.319  95.996  12.426  1.00 78.12           N  
ATOM   9668  CA  GLY F  42     -30.108  94.603  12.039  1.00 78.28           C  
ATOM   9669  C   GLY F  42     -31.439  93.917  11.775  1.00 78.51           C  
ATOM   9670  O   GLY F  42     -32.503  94.518  11.959  1.00 78.54           O  
ATOM   9671  N   LYS F  43     -31.386  92.665  11.320  1.00 78.64           N  
ATOM   9672  CA  LYS F  43     -32.589  91.832  11.231  1.00 78.62           C  
ATOM   9673  C   LYS F  43     -32.973  91.423  12.659  1.00 78.41           C  
ATOM   9674  O   LYS F  43     -32.102  91.067  13.473  1.00 78.21           O  
ATOM   9675  CB  LYS F  43     -32.349  90.604  10.346  1.00 78.69           C  
ATOM   9676  N   ASN F  44     -34.270  91.512  12.961  1.00 78.00           N  
ATOM   9677  CA  ASN F  44     -34.794  91.363  14.332  1.00 77.72           C  
ATOM   9678  C   ASN F  44     -34.319  92.451  15.324  1.00 77.33           C  
ATOM   9679  O   ASN F  44     -34.448  92.281  16.541  1.00 77.43           O  
ATOM   9680  CB  ASN F  44     -34.503  89.956  14.893  1.00 77.80           C  
ATOM   9681  CG  ASN F  44     -35.171  88.856  14.087  1.00 77.62           C  
ATOM   9682  OD1 ASN F  44     -36.374  88.916  13.809  1.00 77.42           O  
ATOM   9683  ND2 ASN F  44     -34.397  87.840  13.714  1.00 77.09           N  
ATOM   9684  N   ASN F  45     -33.784  93.558  14.801  1.00 76.70           N  
ATOM   9685  CA  ASN F  45     -33.446  94.739  15.599  1.00 76.27           C  
ATOM   9686  C   ASN F  45     -32.707  94.416  16.907  1.00 75.85           C  
ATOM   9687  O   ASN F  45     -33.079  94.892  17.978  1.00 75.72           O  
ATOM   9688  CB  ASN F  45     -34.718  95.556  15.878  1.00 76.27           C  
ATOM   9689  CG  ASN F  45     -35.388  96.049  14.605  1.00 76.42           C  
ATOM   9690  OD1 ASN F  45     -36.600  95.884  14.417  1.00 76.68           O  
ATOM   9691  ND2 ASN F  45     -34.599  96.650  13.715  1.00 75.93           N  
ATOM   9692  N   THR F  46     -31.656  93.608  16.804  1.00 75.38           N  
ATOM   9693  CA  THR F  46     -30.919  93.146  17.978  1.00 75.12           C  
ATOM   9694  C   THR F  46     -29.660  93.968  18.267  1.00 74.80           C  
ATOM   9695  O   THR F  46     -28.918  93.651  19.193  1.00 74.66           O  
ATOM   9696  CB  THR F  46     -30.525  91.658  17.836  1.00 75.13           C  
ATOM   9697  OG1 THR F  46     -29.824  91.465  16.604  1.00 75.17           O  
ATOM   9698  CG2 THR F  46     -31.766  90.769  17.864  1.00 75.21           C  
ATOM   9699  N   VAL F  47     -29.421  95.015  17.484  1.00 74.59           N  
ATOM   9700  CA  VAL F  47     -28.279  95.897  17.707  1.00 74.42           C  
ATOM   9701  C   VAL F  47     -28.733  97.302  18.062  1.00 74.44           C  
ATOM   9702  O   VAL F  47     -29.630  97.857  17.423  1.00 74.46           O  
ATOM   9703  CB  VAL F  47     -27.397  96.012  16.469  1.00 74.33           C  
ATOM   9704  CG1 VAL F  47     -26.168  96.863  16.790  1.00 73.99           C  
ATOM   9705  CG2 VAL F  47     -26.995  94.632  15.976  1.00 74.63           C  
ATOM   9706  N   GLY F  48     -28.105  97.875  19.082  1.00 74.40           N  
ATOM   9707  CA  GLY F  48     -28.288  99.281  19.391  1.00 74.39           C  
ATOM   9708  C   GLY F  48     -27.356 100.085  18.515  1.00 74.35           C  
ATOM   9709  O   GLY F  48     -26.181  99.729  18.353  1.00 74.57           O  
ATOM   9710  N   LEU F  49     -27.874 101.157  17.926  1.00 74.31           N  
ATOM   9711  CA  LEU F  49     -27.040 102.079  17.161  1.00 74.34           C  
ATOM   9712  C   LEU F  49     -27.204 103.460  17.745  1.00 74.33           C  
ATOM   9713  O   LEU F  49     -28.317 103.950  17.880  1.00 74.39           O  
ATOM   9714  CB  LEU F  49     -27.400 102.069  15.673  1.00 74.30           C  
ATOM   9715  CG  LEU F  49     -26.693 103.079  14.757  1.00 74.23           C  
ATOM   9716  CD1 LEU F  49     -25.193 103.074  14.931  1.00 74.37           C  
ATOM   9717  CD2 LEU F  49     -27.046 102.818  13.301  1.00 74.56           C  
ATOM   9718  N   ILE F  50     -26.082 104.057  18.124  1.00 74.63           N  
ATOM   9719  CA  ILE F  50     -26.033 105.430  18.573  1.00 74.97           C  
ATOM   9720  C   ILE F  50     -25.207 106.178  17.541  1.00 75.43           C  
ATOM   9721  O   ILE F  50     -24.080 105.794  17.255  1.00 75.45           O  
ATOM   9722  CB  ILE F  50     -25.371 105.563  19.953  1.00 75.04           C  
ATOM   9723  CG1 ILE F  50     -25.970 104.547  20.936  1.00 75.19           C  
ATOM   9724  CG2 ILE F  50     -25.529 106.988  20.475  1.00 74.70           C  
ATOM   9725  CD1 ILE F  50     -25.369 104.584  22.320  1.00 74.21           C  
ATOM   9726  N   GLN F  51     -25.793 107.219  16.959  1.00 76.05           N  
ATOM   9727  CA  GLN F  51     -25.101 108.083  16.015  1.00 76.59           C  
ATOM   9728  C   GLN F  51     -25.001 109.474  16.626  1.00 76.67           C  
ATOM   9729  O   GLN F  51     -26.020 110.073  16.995  1.00 76.65           O  
ATOM   9730  CB  GLN F  51     -25.854 108.148  14.678  1.00 76.65           C  
ATOM   9731  CG  GLN F  51     -25.141 108.982  13.616  1.00 77.31           C  
ATOM   9732  CD  GLN F  51     -25.700 108.792  12.212  1.00 77.34           C  
ATOM   9733  OE1 GLN F  51     -26.907 108.899  11.988  1.00 78.15           O  
ATOM   9734  NE2 GLN F  51     -24.812 108.526  11.256  1.00 78.33           N  
ATOM   9735  N   LEU F  52     -23.774 109.979  16.735  1.00 76.82           N  
ATOM   9736  CA  LEU F  52     -23.541 111.334  17.215  1.00 76.92           C  
ATOM   9737  C   LEU F  52     -23.964 112.291  16.110  1.00 77.14           C  
ATOM   9738  O   LEU F  52     -23.455 112.209  14.997  1.00 77.10           O  
ATOM   9739  CB  LEU F  52     -22.069 111.544  17.573  1.00 76.81           C  
ATOM   9740  CG  LEU F  52     -21.425 110.500  18.486  1.00 76.41           C  
ATOM   9741  CD1 LEU F  52     -20.025 110.941  18.863  1.00 76.31           C  
ATOM   9742  CD2 LEU F  52     -22.259 110.264  19.719  1.00 76.06           C  
ATOM   9743  N   ASN F  53     -24.899 113.188  16.425  1.00 77.56           N  
ATOM   9744  CA  ASN F  53     -25.553 114.026  15.425  1.00 77.84           C  
ATOM   9745  C   ASN F  53     -25.405 115.516  15.735  1.00 78.14           C  
ATOM   9746  O   ASN F  53     -26.383 116.231  15.950  1.00 78.29           O  
ATOM   9747  CB  ASN F  53     -27.029 113.634  15.309  1.00 77.84           C  
ATOM   9748  CG  ASN F  53     -27.642 114.054  13.989  1.00 78.18           C  
ATOM   9749  OD1 ASN F  53     -27.051 113.852  12.924  1.00 78.27           O  
ATOM   9750  ND2 ASN F  53     -28.838 114.637  14.048  1.00 77.95           N  
ATOM   9751  N   ARG F  54     -24.156 115.965  15.751  1.00 78.58           N  
ATOM   9752  CA  ARG F  54     -23.805 117.371  15.934  1.00 78.76           C  
ATOM   9753  C   ARG F  54     -22.821 117.733  14.809  1.00 78.58           C  
ATOM   9754  O   ARG F  54     -21.693 118.159  15.066  1.00 78.24           O  
ATOM   9755  CB  ARG F  54     -23.188 117.569  17.331  1.00 78.92           C  
ATOM   9756  CG  ARG F  54     -22.940 119.021  17.744  1.00 79.13           C  
ATOM   9757  CD  ARG F  54     -22.724 119.147  19.255  1.00 79.28           C  
ATOM   9758  NE  ARG F  54     -22.571 120.549  19.660  1.00 80.13           N  
ATOM   9759  CZ  ARG F  54     -21.452 121.126  20.109  1.00 80.90           C  
ATOM   9760  NH1 ARG F  54     -20.318 120.440  20.262  1.00 81.31           N  
ATOM   9761  NH2 ARG F  54     -21.471 122.417  20.430  1.00 80.62           N  
ATOM   9762  N   PRO F  55     -23.253 117.556  13.546  1.00 78.67           N  
ATOM   9763  CA  PRO F  55     -22.343 117.683  12.394  1.00 78.75           C  
ATOM   9764  C   PRO F  55     -21.682 119.062  12.242  1.00 78.78           C  
ATOM   9765  O   PRO F  55     -20.554 119.144  11.750  1.00 78.72           O  
ATOM   9766  CB  PRO F  55     -23.256 117.389  11.192  1.00 78.76           C  
ATOM   9767  CG  PRO F  55     -24.634 117.658  11.684  1.00 78.60           C  
ATOM   9768  CD  PRO F  55     -24.629 117.248  13.115  1.00 78.52           C  
ATOM   9769  N   LYS F  56     -22.376 120.121  12.664  1.00 78.82           N  
ATOM   9770  CA  LYS F  56     -21.857 121.492  12.568  1.00 78.75           C  
ATOM   9771  C   LYS F  56     -20.565 121.678  13.368  1.00 78.58           C  
ATOM   9772  O   LYS F  56     -19.645 122.363  12.920  1.00 78.50           O  
ATOM   9773  CB  LYS F  56     -22.915 122.500  13.032  1.00 78.81           C  
ATOM   9774  N   ALA F  57     -20.500 121.058  14.541  1.00 78.45           N  
ATOM   9775  CA  ALA F  57     -19.303 121.109  15.379  1.00 78.38           C  
ATOM   9776  C   ALA F  57     -18.404 119.879  15.190  1.00 78.33           C  
ATOM   9777  O   ALA F  57     -17.521 119.623  16.011  1.00 78.41           O  
ATOM   9778  CB  ALA F  57     -19.701 121.259  16.847  1.00 78.34           C  
ATOM   9779  N   LEU F  58     -18.614 119.133  14.104  1.00 78.23           N  
ATOM   9780  CA  LEU F  58     -17.876 117.890  13.850  1.00 78.19           C  
ATOM   9781  C   LEU F  58     -17.973 116.961  15.063  1.00 77.95           C  
ATOM   9782  O   LEU F  58     -16.961 116.544  15.632  1.00 78.00           O  
ATOM   9783  CB  LEU F  58     -16.413 118.179  13.491  1.00 78.22           C  
ATOM   9784  CG  LEU F  58     -16.201 119.105  12.286  1.00 79.27           C  
ATOM   9785  CD1 LEU F  58     -14.757 119.627  12.233  1.00 79.85           C  
ATOM   9786  CD2 LEU F  58     -16.595 118.407  10.970  1.00 79.66           C  
ATOM   9787  N   ASN F  59     -19.211 116.668  15.459  1.00 77.59           N  
ATOM   9788  CA  ASN F  59     -19.500 115.843  16.625  1.00 77.26           C  
ATOM   9789  C   ASN F  59     -18.544 116.077  17.791  1.00 77.25           C  
ATOM   9790  O   ASN F  59     -18.173 115.132  18.494  1.00 77.21           O  
ATOM   9791  CB  ASN F  59     -19.489 114.363  16.246  1.00 77.21           C  
ATOM   9792  CG  ASN F  59     -20.591 113.989  15.291  1.00 77.10           C  
ATOM   9793  OD1 ASN F  59     -21.586 114.704  15.142  1.00 77.55           O  
ATOM   9794  ND2 ASN F  59     -20.424 112.850  14.633  1.00 76.94           N  
ATOM   9795  N   ALA F  60     -18.150 117.330  18.003  1.00 77.12           N  
ATOM   9796  CA  ALA F  60     -17.329 117.672  19.154  1.00 76.97           C  
ATOM   9797  C   ALA F  60     -18.109 117.342  20.424  1.00 77.05           C  
ATOM   9798  O   ALA F  60     -19.327 117.568  20.502  1.00 76.91           O  
ATOM   9799  CB  ALA F  60     -16.935 119.136  19.125  1.00 76.99           C  
ATOM   9800  N   LEU F  61     -17.406 116.800  21.411  1.00 77.23           N  
ATOM   9801  CA  LEU F  61     -18.037 116.280  22.613  1.00 77.39           C  
ATOM   9802  C   LEU F  61     -18.243 117.382  23.667  1.00 77.72           C  
ATOM   9803  O   LEU F  61     -17.284 117.975  24.169  1.00 78.31           O  
ATOM   9804  CB  LEU F  61     -17.195 115.142  23.187  1.00 77.38           C  
ATOM   9805  CG  LEU F  61     -16.805 114.022  22.215  1.00 77.19           C  
ATOM   9806  CD1 LEU F  61     -15.886 113.022  22.898  1.00 76.68           C  
ATOM   9807  CD2 LEU F  61     -18.045 113.338  21.676  1.00 77.00           C  
ATOM   9808  N   CYS F  62     -19.500 117.663  23.988  1.00 77.53           N  
ATOM   9809  CA  CYS F  62     -19.827 118.601  25.044  1.00 77.44           C  
ATOM   9810  C   CYS F  62     -20.602 117.848  26.105  1.00 77.31           C  
ATOM   9811  O   CYS F  62     -20.963 116.690  25.897  1.00 77.33           O  
ATOM   9812  CB  CYS F  62     -20.670 119.744  24.489  1.00 77.56           C  
ATOM   9813  SG  CYS F  62     -22.226 119.203  23.760  1.00 77.72           S  
ATOM   9814  N   ASP F  63     -20.855 118.507  27.234  1.00 77.22           N  
ATOM   9815  CA  ASP F  63     -21.624 117.913  28.331  1.00 77.26           C  
ATOM   9816  C   ASP F  63     -22.959 117.374  27.834  1.00 77.09           C  
ATOM   9817  O   ASP F  63     -23.325 116.231  28.124  1.00 77.06           O  
ATOM   9818  CB  ASP F  63     -21.893 118.945  29.434  1.00 77.37           C  
ATOM   9819  CG  ASP F  63     -20.679 119.217  30.315  1.00 78.00           C  
ATOM   9820  OD1 ASP F  63     -19.624 118.561  30.153  1.00 77.84           O  
ATOM   9821  OD2 ASP F  63     -20.799 120.107  31.190  1.00 79.30           O  
ATOM   9822  N   GLY F  64     -23.676 118.214  27.087  1.00 76.91           N  
ATOM   9823  CA  GLY F  64     -24.990 117.871  26.552  1.00 76.76           C  
ATOM   9824  C   GLY F  64     -24.996 116.629  25.683  1.00 76.71           C  
ATOM   9825  O   GLY F  64     -25.959 115.868  25.698  1.00 77.00           O  
ATOM   9826  N   LEU F  65     -23.926 116.424  24.922  1.00 76.36           N  
ATOM   9827  CA  LEU F  65     -23.806 115.252  24.061  1.00 76.25           C  
ATOM   9828  C   LEU F  65     -23.528 114.003  24.898  1.00 75.87           C  
ATOM   9829  O   LEU F  65     -24.179 112.975  24.723  1.00 75.97           O  
ATOM   9830  CB  LEU F  65     -22.687 115.469  23.030  1.00 76.40           C  
ATOM   9831  CG  LEU F  65     -22.381 114.327  22.056  1.00 76.58           C  
ATOM   9832  CD1 LEU F  65     -23.599 114.004  21.224  1.00 76.76           C  
ATOM   9833  CD2 LEU F  65     -21.227 114.690  21.155  1.00 76.66           C  
ATOM   9834  N   ILE F  66     -22.561 114.110  25.806  1.00 75.25           N  
ATOM   9835  CA  ILE F  66     -22.172 113.010  26.680  1.00 74.65           C  
ATOM   9836  C   ILE F  66     -23.336 112.544  27.547  1.00 74.48           C  
ATOM   9837  O   ILE F  66     -23.597 111.345  27.649  1.00 74.44           O  
ATOM   9838  CB  ILE F  66     -20.989 113.413  27.593  1.00 74.59           C  
ATOM   9839  CG1 ILE F  66     -19.735 113.669  26.753  1.00 74.47           C  
ATOM   9840  CG2 ILE F  66     -20.703 112.328  28.640  1.00 74.02           C  
ATOM   9841  CD1 ILE F  66     -19.208 112.434  26.024  1.00 73.82           C  
ATOM   9842  N   ASP F  67     -24.027 113.499  28.162  1.00 74.19           N  
ATOM   9843  CA  ASP F  67     -25.215 113.210  28.967  1.00 74.11           C  
ATOM   9844  C   ASP F  67     -26.191 112.303  28.206  1.00 73.51           C  
ATOM   9845  O   ASP F  67     -26.706 111.332  28.762  1.00 73.37           O  
ATOM   9846  CB  ASP F  67     -25.915 114.521  29.370  1.00 74.30           C  
ATOM   9847  CG  ASP F  67     -26.824 114.365  30.593  1.00 75.70           C  
ATOM   9848  OD1 ASP F  67     -27.980 114.856  30.559  1.00 77.17           O  
ATOM   9849  OD2 ASP F  67     -26.381 113.766  31.598  1.00 78.11           O  
ATOM   9850  N   GLU F  68     -26.417 112.612  26.929  1.00 72.98           N  
ATOM   9851  CA  GLU F  68     -27.383 111.867  26.116  1.00 72.74           C  
ATOM   9852  C   GLU F  68     -26.852 110.509  25.672  1.00 72.59           C  
ATOM   9853  O   GLU F  68     -27.595 109.524  25.651  1.00 72.35           O  
ATOM   9854  CB  GLU F  68     -27.817 112.687  24.903  1.00 72.65           C  
ATOM   9855  CG  GLU F  68     -28.692 113.885  25.271  1.00 73.02           C  
ATOM   9856  CD  GLU F  68     -29.354 114.536  24.070  1.00 73.31           C  
ATOM   9857  OE1 GLU F  68     -28.834 114.388  22.941  1.00 73.48           O  
ATOM   9858  OE2 GLU F  68     -30.406 115.195  24.258  1.00 73.66           O  
ATOM   9859  N   LEU F  69     -25.572 110.464  25.310  1.00 72.35           N  
ATOM   9860  CA  LEU F  69     -24.913 109.209  24.986  1.00 72.38           C  
ATOM   9861  C   LEU F  69     -25.087 108.250  26.149  1.00 72.28           C  
ATOM   9862  O   LEU F  69     -25.414 107.087  25.956  1.00 72.17           O  
ATOM   9863  CB  LEU F  69     -23.423 109.440  24.713  1.00 72.39           C  
ATOM   9864  CG  LEU F  69     -22.552 108.196  24.515  1.00 72.52           C  
ATOM   9865  CD1 LEU F  69     -23.032 107.410  23.314  1.00 72.77           C  
ATOM   9866  CD2 LEU F  69     -21.078 108.571  24.368  1.00 72.73           C  
ATOM   9867  N   ASN F  70     -24.878 108.757  27.358  1.00 72.40           N  
ATOM   9868  CA  ASN F  70     -24.994 107.943  28.560  1.00 72.57           C  
ATOM   9869  C   ASN F  70     -26.428 107.457  28.813  1.00 72.99           C  
ATOM   9870  O   ASN F  70     -26.632 106.354  29.320  1.00 73.49           O  
ATOM   9871  CB  ASN F  70     -24.457 108.706  29.776  1.00 72.38           C  
ATOM   9872  CG  ASN F  70     -22.960 108.961  29.696  1.00 71.50           C  
ATOM   9873  OD1 ASN F  70     -22.247 108.325  28.927  1.00 71.11           O  
ATOM   9874  ND2 ASN F  70     -22.477 109.889  30.506  1.00 70.16           N  
ATOM   9875  N   GLN F  71     -27.418 108.265  28.466  1.00 73.15           N  
ATOM   9876  CA  GLN F  71     -28.806 107.817  28.559  1.00 73.48           C  
ATOM   9877  C   GLN F  71     -29.075 106.718  27.537  1.00 73.70           C  
ATOM   9878  O   GLN F  71     -29.801 105.767  27.823  1.00 73.78           O  
ATOM   9879  CB  GLN F  71     -29.783 108.982  28.370  1.00 73.30           C  
ATOM   9880  CG  GLN F  71     -29.939 109.830  29.615  1.00 73.75           C  
ATOM   9881  CD  GLN F  71     -30.504 111.207  29.333  1.00 74.99           C  
ATOM   9882  OE1 GLN F  71     -31.701 111.369  29.056  1.00 75.22           O  
ATOM   9883  NE2 GLN F  71     -29.644 112.220  29.418  1.00 75.36           N  
ATOM   9884  N   ALA F  72     -28.475 106.850  26.355  1.00 73.97           N  
ATOM   9885  CA  ALA F  72     -28.705 105.909  25.257  1.00 74.17           C  
ATOM   9886  C   ALA F  72     -28.052 104.555  25.540  1.00 74.41           C  
ATOM   9887  O   ALA F  72     -28.579 103.510  25.158  1.00 74.48           O  
ATOM   9888  CB  ALA F  72     -28.195 106.493  23.937  1.00 73.98           C  
ATOM   9889  N   LEU F  73     -26.900 104.583  26.201  1.00 74.75           N  
ATOM   9890  CA  LEU F  73     -26.235 103.359  26.630  1.00 74.85           C  
ATOM   9891  C   LEU F  73     -27.080 102.661  27.700  1.00 75.05           C  
ATOM   9892  O   LEU F  73     -27.370 101.474  27.593  1.00 74.93           O  
ATOM   9893  CB  LEU F  73     -24.833 103.677  27.151  1.00 74.77           C  
ATOM   9894  CG  LEU F  73     -23.850 104.266  26.123  1.00 74.53           C  
ATOM   9895  CD1 LEU F  73     -22.600 104.798  26.809  1.00 73.48           C  
ATOM   9896  CD2 LEU F  73     -23.478 103.249  25.053  1.00 74.13           C  
ATOM   9897  N   LYS F  74     -27.501 103.420  28.706  1.00 75.56           N  
ATOM   9898  CA  LYS F  74     -28.360 102.904  29.767  1.00 76.04           C  
ATOM   9899  C   LYS F  74     -29.577 102.159  29.201  1.00 76.59           C  
ATOM   9900  O   LYS F  74     -29.888 101.052  29.645  1.00 76.88           O  
ATOM   9901  CB  LYS F  74     -28.809 104.040  30.695  1.00 75.98           C  
ATOM   9902  CG  LYS F  74     -29.502 103.580  31.977  1.00 76.06           C  
ATOM   9903  N   ILE F  75     -30.244 102.744  28.207  1.00 77.00           N  
ATOM   9904  CA  ILE F  75     -31.418 102.102  27.603  1.00 77.48           C  
ATOM   9905  C   ILE F  75     -31.046 100.791  26.900  1.00 77.90           C  
ATOM   9906  O   ILE F  75     -31.556  99.730  27.263  1.00 78.43           O  
ATOM   9907  CB  ILE F  75     -32.169 103.043  26.628  1.00 77.43           C  
ATOM   9908  CG1 ILE F  75     -32.778 104.226  27.389  1.00 77.11           C  
ATOM   9909  CG2 ILE F  75     -33.288 102.297  25.924  1.00 77.21           C  
ATOM   9910  CD1 ILE F  75     -32.978 105.449  26.538  1.00 76.93           C  
ATOM   9911  N   PHE F  76     -30.149 100.856  25.920  1.00 78.23           N  
ATOM   9912  CA  PHE F  76     -29.705  99.651  25.198  1.00 78.62           C  
ATOM   9913  C   PHE F  76     -29.135  98.531  26.085  1.00 79.20           C  
ATOM   9914  O   PHE F  76     -29.261  97.355  25.739  1.00 79.23           O  
ATOM   9915  CB  PHE F  76     -28.666 100.003  24.121  1.00 78.41           C  
ATOM   9916  CG  PHE F  76     -29.222 100.757  22.944  1.00 77.93           C  
ATOM   9917  CD1 PHE F  76     -30.501 100.495  22.453  1.00 77.54           C  
ATOM   9918  CD2 PHE F  76     -28.450 101.714  22.302  1.00 77.56           C  
ATOM   9919  CE1 PHE F  76     -31.001 101.187  21.365  1.00 77.24           C  
ATOM   9920  CE2 PHE F  76     -28.948 102.407  21.203  1.00 77.65           C  
ATOM   9921  CZ  PHE F  76     -30.223 102.142  20.738  1.00 77.60           C  
ATOM   9922  N   GLU F  77     -28.495  98.896  27.197  1.00 79.87           N  
ATOM   9923  CA  GLU F  77     -28.029  97.920  28.198  1.00 80.45           C  
ATOM   9924  C   GLU F  77     -29.216  97.224  28.887  1.00 80.44           C  
ATOM   9925  O   GLU F  77     -29.142  96.040  29.227  1.00 80.25           O  
ATOM   9926  CB  GLU F  77     -27.162  98.624  29.254  1.00 80.77           C  
ATOM   9927  CG  GLU F  77     -26.546  97.706  30.346  1.00 82.23           C  
ATOM   9928  CD  GLU F  77     -25.108  97.270  30.052  1.00 84.20           C  
ATOM   9929  OE1 GLU F  77     -24.606  97.561  28.942  1.00 85.51           O  
ATOM   9930  OE2 GLU F  77     -24.475  96.637  30.937  1.00 84.77           O  
ATOM   9931  N   GLU F  78     -30.307  97.965  29.082  1.00 80.48           N  
ATOM   9932  CA  GLU F  78     -31.520  97.419  29.706  1.00 80.64           C  
ATOM   9933  C   GLU F  78     -32.415  96.652  28.740  1.00 80.23           C  
ATOM   9934  O   GLU F  78     -33.194  95.802  29.175  1.00 80.13           O  
ATOM   9935  CB  GLU F  78     -32.329  98.531  30.394  1.00 80.59           C  
ATOM   9936  CG  GLU F  78     -31.748  98.903  31.754  1.00 81.29           C  
ATOM   9937  CD  GLU F  78     -32.407 100.111  32.391  1.00 81.47           C  
ATOM   9938  OE1 GLU F  78     -33.563 100.440  32.033  1.00 83.75           O  
ATOM   9939  OE2 GLU F  78     -31.761 100.725  33.266  1.00 82.51           O  
ATOM   9940  N   ASP F  79     -32.308  96.942  27.444  1.00 79.93           N  
ATOM   9941  CA  ASP F  79     -33.174  96.303  26.455  1.00 79.80           C  
ATOM   9942  C   ASP F  79     -32.705  94.865  26.229  1.00 79.39           C  
ATOM   9943  O   ASP F  79     -31.592  94.647  25.751  1.00 79.16           O  
ATOM   9944  CB  ASP F  79     -33.186  97.092  25.139  1.00 79.86           C  
ATOM   9945  CG  ASP F  79     -34.270  96.614  24.175  1.00 80.42           C  
ATOM   9946  OD1 ASP F  79     -34.313  95.399  23.885  1.00 81.69           O  
ATOM   9947  OD2 ASP F  79     -35.072  97.450  23.692  1.00 79.43           O  
ATOM   9948  N   PRO F  80     -33.558  93.878  26.572  1.00 79.02           N  
ATOM   9949  CA  PRO F  80     -33.151  92.470  26.476  1.00 78.72           C  
ATOM   9950  C   PRO F  80     -33.031  91.928  25.043  1.00 78.29           C  
ATOM   9951  O   PRO F  80     -32.446  90.863  24.850  1.00 78.12           O  
ATOM   9952  CB  PRO F  80     -34.245  91.734  27.256  1.00 78.75           C  
ATOM   9953  CG  PRO F  80     -35.448  92.604  27.137  1.00 78.95           C  
ATOM   9954  CD  PRO F  80     -34.944  94.020  27.059  1.00 79.00           C  
ATOM   9955  N   ALA F  81     -33.580  92.640  24.057  1.00 77.84           N  
ATOM   9956  CA  ALA F  81     -33.346  92.305  22.644  1.00 77.53           C  
ATOM   9957  C   ALA F  81     -31.965  92.787  22.158  1.00 77.28           C  
ATOM   9958  O   ALA F  81     -31.367  92.174  21.268  1.00 77.51           O  
ATOM   9959  CB  ALA F  81     -34.425  92.884  21.778  1.00 77.30           C  
ATOM   9960  N   VAL F  82     -31.462  93.878  22.734  1.00 76.55           N  
ATOM   9961  CA  VAL F  82     -30.172  94.417  22.330  1.00 76.08           C  
ATOM   9962  C   VAL F  82     -29.047  93.523  22.840  1.00 75.61           C  
ATOM   9963  O   VAL F  82     -28.921  93.320  24.041  1.00 75.72           O  
ATOM   9964  CB  VAL F  82     -29.973  95.851  22.847  1.00 76.08           C  
ATOM   9965  CG1 VAL F  82     -28.521  96.292  22.675  1.00 75.90           C  
ATOM   9966  CG2 VAL F  82     -30.923  96.798  22.118  1.00 76.14           C  
ATOM   9967  N   GLY F  83     -28.255  92.981  21.916  1.00 75.03           N  
ATOM   9968  CA  GLY F  83     -27.103  92.136  22.247  1.00 74.60           C  
ATOM   9969  C   GLY F  83     -25.760  92.834  22.099  1.00 74.25           C  
ATOM   9970  O   GLY F  83     -24.738  92.362  22.608  1.00 74.23           O  
ATOM   9971  N   ALA F  84     -25.758  93.962  21.402  1.00 73.97           N  
ATOM   9972  CA  ALA F  84     -24.534  94.699  21.126  1.00 73.79           C  
ATOM   9973  C   ALA F  84     -24.870  96.121  20.700  1.00 73.67           C  
ATOM   9974  O   ALA F  84     -25.954  96.383  20.168  1.00 73.79           O  
ATOM   9975  CB  ALA F  84     -23.747  94.003  20.040  1.00 73.65           C  
ATOM   9976  N   ILE F  85     -23.935  97.033  20.932  1.00 73.45           N  
ATOM   9977  CA  ILE F  85     -24.116  98.423  20.565  1.00 73.40           C  
ATOM   9978  C   ILE F  85     -23.096  98.837  19.509  1.00 73.73           C  
ATOM   9979  O   ILE F  85     -21.945  98.389  19.537  1.00 73.41           O  
ATOM   9980  CB  ILE F  85     -23.960  99.306  21.786  1.00 73.30           C  
ATOM   9981  CG1 ILE F  85     -25.131  99.068  22.738  1.00 73.29           C  
ATOM   9982  CG2 ILE F  85     -23.870 100.767  21.388  1.00 73.27           C  
ATOM   9983  CD1 ILE F  85     -24.928  99.670  24.108  1.00 73.75           C  
ATOM   9984  N   VAL F  86     -23.537  99.670  18.563  1.00 73.96           N  
ATOM   9985  CA  VAL F  86     -22.624 100.331  17.637  1.00 73.96           C  
ATOM   9986  C   VAL F  86     -22.662 101.824  17.921  1.00 74.03           C  
ATOM   9987  O   VAL F  86     -23.722 102.419  17.980  1.00 73.65           O  
ATOM   9988  CB  VAL F  86     -22.979 100.067  16.152  1.00 73.99           C  
ATOM   9989  CG1 VAL F  86     -21.985 100.762  15.238  1.00 74.06           C  
ATOM   9990  CG2 VAL F  86     -22.978  98.577  15.851  1.00 73.83           C  
ATOM   9991  N   LEU F  87     -21.489 102.404  18.128  1.00 74.50           N  
ATOM   9992  CA  LEU F  87     -21.331 103.839  18.268  1.00 75.04           C  
ATOM   9993  C   LEU F  87     -20.738 104.360  16.961  1.00 75.63           C  
ATOM   9994  O   LEU F  87     -19.795 103.761  16.443  1.00 75.73           O  
ATOM   9995  CB  LEU F  87     -20.383 104.134  19.429  1.00 75.07           C  
ATOM   9996  CG  LEU F  87     -20.150 105.601  19.792  1.00 75.28           C  
ATOM   9997  CD1 LEU F  87     -21.430 106.230  20.330  1.00 75.01           C  
ATOM   9998  CD2 LEU F  87     -19.019 105.721  20.803  1.00 75.01           C  
ATOM   9999  N   THR F  88     -21.282 105.458  16.431  1.00 76.21           N  
ATOM  10000  CA  THR F  88     -20.754 106.075  15.200  1.00 77.09           C  
ATOM  10001  C   THR F  88     -20.963 107.576  15.187  1.00 77.33           C  
ATOM  10002  O   THR F  88     -21.744 108.099  15.975  1.00 77.35           O  
ATOM  10003  CB  THR F  88     -21.437 105.506  13.939  1.00 77.25           C  
ATOM  10004  OG1 THR F  88     -21.346 104.083  13.959  1.00 79.28           O  
ATOM  10005  CG2 THR F  88     -20.772 106.013  12.662  1.00 77.45           C  
ATOM  10006  N   GLY F  89     -20.250 108.260  14.292  1.00 77.87           N  
ATOM  10007  CA  GLY F  89     -20.525 109.661  13.966  1.00 78.27           C  
ATOM  10008  C   GLY F  89     -21.147 109.824  12.587  1.00 78.67           C  
ATOM  10009  O   GLY F  89     -22.049 109.066  12.203  1.00 78.75           O  
ATOM  10010  N   GLY F  90     -20.677 110.830  11.851  1.00 79.20           N  
ATOM  10011  CA  GLY F  90     -21.126 111.092  10.480  1.00 79.37           C  
ATOM  10012  C   GLY F  90     -20.189 110.420   9.499  1.00 79.61           C  
ATOM  10013  O   GLY F  90     -19.662 109.352   9.781  1.00 80.10           O  
ATOM  10014  N   ASP F  91     -19.976 111.044   8.348  1.00 79.94           N  
ATOM  10015  CA  ASP F  91     -19.044 110.525   7.343  1.00 80.20           C  
ATOM  10016  C   ASP F  91     -17.726 111.300   7.332  1.00 80.21           C  
ATOM  10017  O   ASP F  91     -16.676 110.743   7.016  1.00 80.11           O  
ATOM  10018  CB  ASP F  91     -19.689 110.571   5.955  1.00 80.39           C  
ATOM  10019  CG  ASP F  91     -20.879 109.627   5.830  1.00 81.08           C  
ATOM  10020  OD1 ASP F  91     -21.042 108.741   6.705  1.00 81.38           O  
ATOM  10021  OD2 ASP F  91     -21.649 109.775   4.852  1.00 81.68           O  
ATOM  10022  N   LYS F  92     -17.788 112.585   7.665  1.00 80.37           N  
ATOM  10023  CA  LYS F  92     -16.600 113.414   7.752  1.00 80.50           C  
ATOM  10024  C   LYS F  92     -15.972 113.334   9.147  1.00 80.73           C  
ATOM  10025  O   LYS F  92     -14.775 113.605   9.300  1.00 80.94           O  
ATOM  10026  CB  LYS F  92     -16.941 114.869   7.404  1.00 80.62           C  
ATOM  10027  N   ALA F  93     -16.760 112.943  10.155  1.00 80.69           N  
ATOM  10028  CA  ALA F  93     -16.297 113.001  11.546  1.00 80.59           C  
ATOM  10029  C   ALA F  93     -17.018 112.045  12.500  1.00 80.56           C  
ATOM  10030  O   ALA F  93     -18.248 112.061  12.590  1.00 80.22           O  
ATOM  10031  CB  ALA F  93     -16.425 114.422  12.063  1.00 80.55           C  
ATOM  10032  N   PHE F  94     -16.224 111.235  13.213  1.00 80.46           N  
ATOM  10033  CA  PHE F  94     -16.684 110.441  14.362  1.00 80.50           C  
ATOM  10034  C   PHE F  94     -16.945 111.363  15.565  1.00 80.41           C  
ATOM  10035  O   PHE F  94     -18.066 111.442  16.079  1.00 80.13           O  
ATOM  10036  CB  PHE F  94     -15.615 109.378  14.722  1.00 80.76           C  
ATOM  10037  CG  PHE F  94     -15.991 108.479  15.874  1.00 80.60           C  
ATOM  10038  CD1 PHE F  94     -16.976 107.505  15.726  1.00 81.29           C  
ATOM  10039  CD2 PHE F  94     -15.348 108.589  17.097  1.00 80.93           C  
ATOM  10040  CE1 PHE F  94     -17.325 106.665  16.792  1.00 81.54           C  
ATOM  10041  CE2 PHE F  94     -15.684 107.746  18.166  1.00 80.94           C  
ATOM  10042  CZ  PHE F  94     -16.672 106.789  18.014  1.00 81.01           C  
ATOM  10043  N   ALA F  95     -15.881 112.036  16.002  1.00 80.37           N  
ATOM  10044  CA  ALA F  95     -15.923 113.070  17.033  1.00 80.44           C  
ATOM  10045  C   ALA F  95     -14.569 113.775  16.982  1.00 80.65           C  
ATOM  10046  O   ALA F  95     -13.533 113.137  17.089  1.00 80.46           O  
ATOM  10047  CB  ALA F  95     -16.171 112.468  18.399  1.00 80.36           C  
ATOM  10048  N   ALA F  96     -14.577 115.088  16.794  1.00 81.21           N  
ATOM  10049  CA  ALA F  96     -13.360 115.827  16.461  1.00 81.63           C  
ATOM  10050  C   ALA F  96     -12.735 116.517  17.671  1.00 82.06           C  
ATOM  10051  O   ALA F  96     -12.166 117.601  17.539  1.00 82.68           O  
ATOM  10052  CB  ALA F  96     -13.667 116.864  15.369  1.00 81.47           C  
ATOM  10053  N   GLY F  97     -12.833 115.896  18.843  1.00 82.23           N  
ATOM  10054  CA  GLY F  97     -12.353 116.510  20.083  1.00 82.43           C  
ATOM  10055  C   GLY F  97     -13.494 117.000  20.959  1.00 82.59           C  
ATOM  10056  O   GLY F  97     -14.663 116.752  20.664  1.00 82.59           O  
ATOM  10057  N   ALA F  98     -13.150 117.699  22.038  1.00 82.76           N  
ATOM  10058  CA  ALA F  98     -14.128 118.119  23.045  1.00 82.82           C  
ATOM  10059  C   ALA F  98     -14.443 119.600  22.938  1.00 82.88           C  
ATOM  10060  O   ALA F  98     -13.803 120.333  22.177  1.00 83.06           O  
ATOM  10061  CB  ALA F  98     -13.614 117.799  24.436  1.00 82.83           C  
ATOM  10062  N   ASP F  99     -15.429 120.036  23.719  1.00 82.79           N  
ATOM  10063  CA  ASP F  99     -15.859 121.432  23.719  1.00 82.67           C  
ATOM  10064  C   ASP F  99     -14.906 122.272  24.568  1.00 82.31           C  
ATOM  10065  O   ASP F  99     -15.135 122.497  25.761  1.00 82.39           O  
ATOM  10066  CB  ASP F  99     -17.299 121.551  24.229  1.00 82.78           C  
ATOM  10067  CG  ASP F  99     -17.869 122.939  24.043  1.00 83.05           C  
ATOM  10068  OD1 ASP F  99     -18.223 123.289  22.895  1.00 83.69           O  
ATOM  10069  OD2 ASP F  99     -17.971 123.676  25.047  1.00 83.79           O  
ATOM  10070  N   ILE F 100     -13.841 122.742  23.925  1.00 81.84           N  
ATOM  10071  CA  ILE F 100     -12.779 123.500  24.583  1.00 81.47           C  
ATOM  10072  C   ILE F 100     -13.241 124.857  25.113  1.00 81.15           C  
ATOM  10073  O   ILE F 100     -12.618 125.411  26.020  1.00 81.01           O  
ATOM  10074  CB  ILE F 100     -11.579 123.665  23.624  1.00 81.54           C  
ATOM  10075  CG1 ILE F 100     -10.887 122.303  23.442  1.00 81.73           C  
ATOM  10076  CG2 ILE F 100     -10.598 124.724  24.136  1.00 81.34           C  
ATOM  10077  CD1 ILE F 100     -10.314 122.063  22.050  1.00 82.25           C  
ATOM  10078  N   LYS F 101     -14.332 125.383  24.559  1.00 80.97           N  
ATOM  10079  CA  LYS F 101     -14.939 126.622  25.059  1.00 80.82           C  
ATOM  10080  C   LYS F 101     -15.487 126.456  26.490  1.00 80.77           C  
ATOM  10081  O   LYS F 101     -15.592 127.436  27.235  1.00 80.64           O  
ATOM  10082  CB  LYS F 101     -16.043 127.103  24.109  1.00 80.73           C  
ATOM  10083  N   GLU F 102     -15.822 125.219  26.867  1.00 80.69           N  
ATOM  10084  CA  GLU F 102     -16.268 124.903  28.233  1.00 80.60           C  
ATOM  10085  C   GLU F 102     -15.100 124.802  29.238  1.00 80.42           C  
ATOM  10086  O   GLU F 102     -15.214 125.264  30.375  1.00 80.56           O  
ATOM  10087  CB  GLU F 102     -17.075 123.600  28.237  1.00 80.58           C  
ATOM  10088  N   MET F 103     -13.981 124.220  28.805  1.00 80.06           N  
ATOM  10089  CA  MET F 103     -12.802 124.015  29.672  1.00 79.80           C  
ATOM  10090  C   MET F 103     -11.981 125.283  29.933  1.00 79.36           C  
ATOM  10091  O   MET F 103     -11.070 125.266  30.756  1.00 79.48           O  
ATOM  10092  CB  MET F 103     -11.857 122.978  29.051  1.00 79.64           C  
ATOM  10093  CG  MET F 103     -12.493 121.644  28.721  1.00 79.71           C  
ATOM  10094  SD  MET F 103     -11.260 120.379  28.338  1.00 80.24           S  
ATOM  10095  CE  MET F 103     -10.618 120.993  26.787  1.00 81.63           C  
ATOM  10096  N   GLN F 104     -12.323 126.374  29.250  1.00 78.78           N  
ATOM  10097  CA  GLN F 104     -11.418 127.507  29.058  1.00 78.28           C  
ATOM  10098  C   GLN F 104     -11.111 128.306  30.322  1.00 78.02           C  
ATOM  10099  O   GLN F 104      -9.990 128.782  30.486  1.00 77.81           O  
ATOM  10100  CB  GLN F 104     -12.011 128.430  27.985  1.00 78.44           C  
ATOM  10101  CG  GLN F 104     -11.079 129.509  27.438  1.00 78.15           C  
ATOM  10102  CD  GLN F 104     -11.799 130.508  26.532  1.00 77.91           C  
ATOM  10103  OE1 GLN F 104     -11.223 131.515  26.132  1.00 77.03           O  
ATOM  10104  NE2 GLN F 104     -13.062 130.232  26.213  1.00 76.83           N  
ATOM  10105  N   ASN F 105     -12.097 128.463  31.200  1.00 77.82           N  
ATOM  10106  CA  ASN F 105     -11.932 129.283  32.408  1.00 77.74           C  
ATOM  10107  C   ASN F 105     -11.637 128.470  33.667  1.00 77.49           C  
ATOM  10108  O   ASN F 105     -11.327 129.037  34.717  1.00 77.40           O  
ATOM  10109  CB  ASN F 105     -13.181 130.140  32.643  1.00 77.85           C  
ATOM  10110  CG  ASN F 105     -13.447 131.119  31.509  1.00 78.00           C  
ATOM  10111  OD1 ASN F 105     -12.736 131.139  30.501  1.00 78.10           O  
ATOM  10112  ND2 ASN F 105     -14.480 131.935  31.670  1.00 77.58           N  
ATOM  10113  N   LEU F 106     -11.720 127.147  33.546  1.00 77.20           N  
ATOM  10114  CA  LEU F 106     -11.626 126.235  34.686  1.00 76.89           C  
ATOM  10115  C   LEU F 106     -10.325 126.389  35.475  1.00 76.55           C  
ATOM  10116  O   LEU F 106      -9.254 126.585  34.899  1.00 76.32           O  
ATOM  10117  CB  LEU F 106     -11.775 124.779  34.217  1.00 76.87           C  
ATOM  10118  CG  LEU F 106     -13.205 124.253  34.026  1.00 77.07           C  
ATOM  10119  CD1 LEU F 106     -14.056 125.196  33.193  1.00 77.23           C  
ATOM  10120  CD2 LEU F 106     -13.192 122.861  33.402  1.00 77.01           C  
ATOM  10121  N   SER F 107     -10.443 126.314  36.800  1.00 76.30           N  
ATOM  10122  CA  SER F 107      -9.291 126.291  37.707  1.00 76.06           C  
ATOM  10123  C   SER F 107      -8.844 124.853  37.970  1.00 75.85           C  
ATOM  10124  O   SER F 107      -9.519 123.899  37.570  1.00 75.63           O  
ATOM  10125  CB  SER F 107      -9.655 126.953  39.039  1.00 75.99           C  
ATOM  10126  OG  SER F 107      -8.584 126.867  39.962  1.00 75.78           O  
ATOM  10127  N   PHE F 108      -7.703 124.702  38.636  1.00 75.73           N  
ATOM  10128  CA  PHE F 108      -7.274 123.390  39.114  1.00 75.71           C  
ATOM  10129  C   PHE F 108      -8.268 122.849  40.145  1.00 76.01           C  
ATOM  10130  O   PHE F 108      -8.691 121.704  40.062  1.00 75.62           O  
ATOM  10131  CB  PHE F 108      -5.876 123.453  39.735  1.00 75.52           C  
ATOM  10132  CG  PHE F 108      -5.525 122.232  40.532  1.00 75.04           C  
ATOM  10133  CD1 PHE F 108      -5.176 121.059  39.890  1.00 74.61           C  
ATOM  10134  CD2 PHE F 108      -5.582 122.246  41.918  1.00 74.68           C  
ATOM  10135  CE1 PHE F 108      -4.874 119.924  40.609  1.00 74.87           C  
ATOM  10136  CE2 PHE F 108      -5.283 121.118  42.646  1.00 74.64           C  
ATOM  10137  CZ  PHE F 108      -4.925 119.950  41.988  1.00 75.20           C  
ATOM  10138  N   GLN F 109      -8.628 123.692  41.112  1.00 76.68           N  
ATOM  10139  CA  GLN F 109      -9.578 123.322  42.162  1.00 77.27           C  
ATOM  10140  C   GLN F 109     -10.915 122.878  41.574  1.00 78.16           C  
ATOM  10141  O   GLN F 109     -11.448 121.830  41.951  1.00 78.41           O  
ATOM  10142  CB  GLN F 109      -9.807 124.491  43.117  1.00 77.14           C  
ATOM  10143  CG  GLN F 109      -8.614 124.835  44.000  1.00 76.82           C  
ATOM  10144  CD  GLN F 109      -7.652 125.818  43.354  1.00 76.45           C  
ATOM  10145  OE1 GLN F 109      -7.440 125.792  42.140  1.00 76.07           O  
ATOM  10146  NE2 GLN F 109      -7.059 126.686  44.167  1.00 75.41           N  
ATOM  10147  N   ASP F 110     -11.442 123.676  40.648  1.00 79.14           N  
ATOM  10148  CA  ASP F 110     -12.677 123.345  39.928  1.00 79.92           C  
ATOM  10149  C   ASP F 110     -12.628 121.951  39.299  1.00 80.54           C  
ATOM  10150  O   ASP F 110     -13.605 121.206  39.357  1.00 80.55           O  
ATOM  10151  CB  ASP F 110     -12.960 124.388  38.833  1.00 80.04           C  
ATOM  10152  CG  ASP F 110     -13.388 125.743  39.393  1.00 80.23           C  
ATOM  10153  OD1 ASP F 110     -14.140 125.780  40.392  1.00 80.28           O  
ATOM  10154  OD2 ASP F 110     -12.985 126.777  38.819  1.00 81.01           O  
ATOM  10155  N   CYS F 111     -11.490 121.610  38.700  1.00 81.46           N  
ATOM  10156  CA  CYS F 111     -11.307 120.300  38.069  1.00 82.21           C  
ATOM  10157  C   CYS F 111     -11.363 119.167  39.087  1.00 82.89           C  
ATOM  10158  O   CYS F 111     -12.083 118.182  38.889  1.00 83.13           O  
ATOM  10159  CB  CYS F 111      -9.970 120.233  37.321  1.00 82.20           C  
ATOM  10160  SG  CYS F 111     -10.001 120.909  35.646  1.00 83.06           S  
ATOM  10161  N   TYR F 112     -10.603 119.316  40.169  1.00 83.60           N  
ATOM  10162  CA  TYR F 112     -10.393 118.233  41.129  1.00 83.97           C  
ATOM  10163  C   TYR F 112     -11.609 118.000  42.023  1.00 84.41           C  
ATOM  10164  O   TYR F 112     -12.053 116.865  42.184  1.00 84.43           O  
ATOM  10165  CB  TYR F 112      -9.151 118.503  41.988  1.00 83.95           C  
ATOM  10166  CG  TYR F 112      -8.852 117.376  42.941  1.00 83.96           C  
ATOM  10167  CD1 TYR F 112      -8.035 116.312  42.561  1.00 83.73           C  
ATOM  10168  CD2 TYR F 112      -9.416 117.354  44.218  1.00 84.18           C  
ATOM  10169  CE1 TYR F 112      -7.769 115.262  43.432  1.00 84.00           C  
ATOM  10170  CE2 TYR F 112      -9.161 116.307  45.098  1.00 84.10           C  
ATOM  10171  CZ  TYR F 112      -8.339 115.267  44.699  1.00 84.23           C  
ATOM  10172  OH  TYR F 112      -8.088 114.241  45.570  1.00 84.44           O  
ATOM  10173  N   SER F 113     -12.141 119.068  42.605  1.00 85.02           N  
ATOM  10174  CA  SER F 113     -13.280 118.953  43.520  1.00 85.51           C  
ATOM  10175  C   SER F 113     -14.522 118.357  42.852  1.00 86.16           C  
ATOM  10176  O   SER F 113     -15.348 117.735  43.523  1.00 86.47           O  
ATOM  10177  CB  SER F 113     -13.636 120.319  44.118  1.00 85.42           C  
ATOM  10178  OG  SER F 113     -12.596 120.811  44.942  1.00 85.03           O  
ATOM  10179  N   SER F 114     -14.643 118.549  41.543  1.00 86.87           N  
ATOM  10180  CA  SER F 114     -15.921 118.384  40.859  1.00 87.45           C  
ATOM  10181  C   SER F 114     -15.800 117.408  39.694  1.00 87.88           C  
ATOM  10182  O   SER F 114     -15.977 117.786  38.535  1.00 87.70           O  
ATOM  10183  CB  SER F 114     -16.442 119.735  40.363  1.00 87.47           C  
ATOM  10184  OG  SER F 114     -17.504 119.564  39.441  1.00 87.69           O  
ATOM  10185  N   LYS F 115     -15.498 116.153  40.008  1.00 88.55           N  
ATOM  10186  CA  LYS F 115     -14.622 115.343  39.171  1.00 89.17           C  
ATOM  10187  C   LYS F 115     -14.881 115.602  37.690  1.00 89.77           C  
ATOM  10188  O   LYS F 115     -15.947 115.272  37.169  1.00 90.22           O  
ATOM  10189  CB  LYS F 115     -14.804 113.856  39.485  1.00 89.06           C  
ATOM  10190  N   PHE F 116     -13.900 116.193  37.017  1.00 90.23           N  
ATOM  10191  CA  PHE F 116     -14.079 116.650  35.644  1.00 90.44           C  
ATOM  10192  C   PHE F 116     -13.851 115.514  34.652  1.00 90.65           C  
ATOM  10193  O   PHE F 116     -12.867 114.781  34.748  1.00 90.71           O  
ATOM  10194  CB  PHE F 116     -13.132 117.813  35.339  1.00 90.46           C  
ATOM  10195  CG  PHE F 116     -13.308 118.392  33.964  1.00 90.67           C  
ATOM  10196  CD1 PHE F 116     -14.571 118.672  33.471  1.00 90.78           C  
ATOM  10197  CD2 PHE F 116     -12.208 118.655  33.163  1.00 90.77           C  
ATOM  10198  CE1 PHE F 116     -14.736 119.205  32.206  1.00 90.90           C  
ATOM  10199  CE2 PHE F 116     -12.367 119.188  31.897  1.00 90.60           C  
ATOM  10200  CZ  PHE F 116     -13.633 119.463  31.419  1.00 90.61           C  
ATOM  10201  N   LEU F 117     -14.767 115.375  33.699  1.00 90.79           N  
ATOM  10202  CA  LEU F 117     -14.719 114.258  32.735  1.00 91.01           C  
ATOM  10203  C   LEU F 117     -14.984 112.892  33.397  1.00 91.09           C  
ATOM  10204  O   LEU F 117     -14.527 111.853  32.902  1.00 91.01           O  
ATOM  10205  CB  LEU F 117     -13.390 114.223  31.945  1.00 90.97           C  
ATOM  10206  CG  LEU F 117     -12.968 115.470  31.153  1.00 91.31           C  
ATOM  10207  CD1 LEU F 117     -11.659 115.215  30.406  1.00 91.43           C  
ATOM  10208  CD2 LEU F 117     -14.053 115.915  30.174  1.00 90.97           C  
ATOM  10209  N   LYS F 118     -15.736 112.896  34.498  1.00 91.24           N  
ATOM  10210  CA  LYS F 118     -16.072 111.658  35.211  1.00 91.49           C  
ATOM  10211  C   LYS F 118     -17.115 110.864  34.429  1.00 91.60           C  
ATOM  10212  O   LYS F 118     -16.958 109.654  34.220  1.00 91.66           O  
ATOM  10213  CB  LYS F 118     -16.599 111.948  36.626  1.00 91.41           C  
ATOM  10214  N   HIS F 119     -18.164 111.555  33.977  1.00 91.52           N  
ATOM  10215  CA  HIS F 119     -19.263 110.905  33.261  1.00 91.50           C  
ATOM  10216  C   HIS F 119     -18.912 110.507  31.819  1.00 91.14           C  
ATOM  10217  O   HIS F 119     -19.717 109.877  31.128  1.00 90.99           O  
ATOM  10218  CB  HIS F 119     -20.520 111.782  33.308  1.00 91.73           C  
ATOM  10219  CG  HIS F 119     -21.217 111.752  34.636  1.00 92.57           C  
ATOM  10220  ND1 HIS F 119     -21.110 110.689  35.510  1.00 93.66           N  
ATOM  10221  CD2 HIS F 119     -22.054 112.641  35.226  1.00 93.13           C  
ATOM  10222  CE1 HIS F 119     -21.836 110.931  36.588  1.00 93.67           C  
ATOM  10223  NE2 HIS F 119     -22.421 112.109  36.440  1.00 93.46           N  
ATOM  10224  N   TRP F 120     -17.693 110.831  31.394  1.00 90.84           N  
ATOM  10225  CA  TRP F 120     -17.189 110.455  30.077  1.00 90.67           C  
ATOM  10226  C   TRP F 120     -16.709 109.003  30.051  1.00 90.23           C  
ATOM  10227  O   TRP F 120     -16.049 108.586  29.103  1.00 90.17           O  
ATOM  10228  CB  TRP F 120     -16.036 111.384  29.677  1.00 91.00           C  
ATOM  10229  CG  TRP F 120     -16.474 112.781  29.397  1.00 91.22           C  
ATOM  10230  CD1 TRP F 120     -17.349 113.531  30.129  1.00 91.96           C  
ATOM  10231  CD2 TRP F 120     -16.052 113.606  28.309  1.00 91.52           C  
ATOM  10232  NE1 TRP F 120     -17.507 114.771  29.560  1.00 92.33           N  
ATOM  10233  CE2 TRP F 120     -16.718 114.845  28.442  1.00 92.12           C  
ATOM  10234  CE3 TRP F 120     -15.180 113.419  27.231  1.00 92.17           C  
ATOM  10235  CZ2 TRP F 120     -16.539 115.895  27.536  1.00 91.92           C  
ATOM  10236  CZ3 TRP F 120     -15.002 114.466  26.327  1.00 91.89           C  
ATOM  10237  CH2 TRP F 120     -15.678 115.687  26.490  1.00 91.84           C  
ATOM  10238  N   ASP F 121     -17.080 108.233  31.069  1.00 89.59           N  
ATOM  10239  CA  ASP F 121     -16.455 106.954  31.347  1.00 89.39           C  
ATOM  10240  C   ASP F 121     -17.430 105.775  31.365  1.00 88.32           C  
ATOM  10241  O   ASP F 121     -17.010 104.636  31.601  1.00 88.22           O  
ATOM  10242  CB  ASP F 121     -15.786 107.059  32.724  1.00 89.85           C  
ATOM  10243  CG  ASP F 121     -14.462 106.341  32.797  1.00 91.75           C  
ATOM  10244  OD1 ASP F 121     -14.147 105.528  31.896  1.00 94.81           O  
ATOM  10245  OD2 ASP F 121     -13.724 106.599  33.777  1.00 95.28           O  
ATOM  10246  N   HIS F 122     -18.715 106.037  31.117  1.00 87.34           N  
ATOM  10247  CA  HIS F 122     -19.756 105.011  31.224  0.50 86.96           C  
ATOM  10249  C   HIS F 122     -19.624 103.953  30.126  1.00 86.54           C  
ATOM  10250  O   HIS F 122     -20.129 102.842  30.265  1.00 86.53           O  
ATOM  10251  CB  HIS F 122     -21.151 105.656  31.201  0.50 86.98           C  
ATOM  10253  CG  HIS F 122     -22.256 104.739  31.636  0.50 87.14           C  
ATOM  10255  ND1 HIS F 122     -23.514 104.767  31.070  0.50 87.30           N  
ATOM  10257  CD2 HIS F 122     -22.291 103.768  32.580  0.50 87.16           C  
ATOM  10259  CE1 HIS F 122     -24.275 103.855  31.647  0.50 87.24           C  
ATOM  10261  NE2 HIS F 122     -23.556 103.232  32.565  0.50 87.37           N  
ATOM  10263  N   LEU F 123     -18.948 104.296  29.032  1.00 85.89           N  
ATOM  10264  CA  LEU F 123     -18.629 103.302  28.006  1.00 85.46           C  
ATOM  10265  C   LEU F 123     -17.851 102.123  28.614  1.00 85.13           C  
ATOM  10266  O   LEU F 123     -18.086 100.967  28.258  1.00 85.37           O  
ATOM  10267  CB  LEU F 123     -17.814 103.919  26.856  1.00 85.48           C  
ATOM  10268  CG  LEU F 123     -18.570 104.422  25.622  1.00 85.31           C  
ATOM  10269  CD1 LEU F 123     -17.654 105.223  24.707  1.00 84.65           C  
ATOM  10270  CD2 LEU F 123     -19.173 103.256  24.864  1.00 85.20           C  
ATOM  10271  N   THR F 124     -16.934 102.417  29.538  1.00 84.45           N  
ATOM  10272  CA  THR F 124     -16.132 101.374  30.185  1.00 83.90           C  
ATOM  10273  C   THR F 124     -16.939 100.539  31.191  1.00 83.90           C  
ATOM  10274  O   THR F 124     -16.402  99.617  31.805  1.00 84.16           O  
ATOM  10275  CB  THR F 124     -14.898 101.962  30.920  1.00 83.64           C  
ATOM  10276  OG1 THR F 124     -15.332 102.807  31.993  1.00 82.80           O  
ATOM  10277  CG2 THR F 124     -14.016 102.752  29.959  1.00 82.99           C  
ATOM  10278  N   GLN F 125     -18.217 100.857  31.363  1.00 83.53           N  
ATOM  10279  CA  GLN F 125     -19.054 100.166  32.328  1.00 83.51           C  
ATOM  10280  C   GLN F 125     -20.244  99.431  31.708  1.00 82.67           C  
ATOM  10281  O   GLN F 125     -21.011  98.778  32.423  1.00 82.39           O  
ATOM  10282  CB  GLN F 125     -19.535 101.168  33.373  1.00 83.89           C  
ATOM  10283  CG  GLN F 125     -18.412 101.673  34.267  1.00 85.77           C  
ATOM  10284  CD  GLN F 125     -18.927 102.538  35.404  1.00 87.91           C  
ATOM  10285  OE1 GLN F 125     -19.488 103.618  35.176  1.00 89.14           O  
ATOM  10286  NE2 GLN F 125     -18.740 102.070  36.638  1.00 88.96           N  
ATOM  10287  N   VAL F 126     -20.404  99.526  30.392  1.00 81.82           N  
ATOM  10288  CA  VAL F 126     -21.428  98.742  29.723  1.00 81.39           C  
ATOM  10289  C   VAL F 126     -20.914  97.311  29.625  1.00 80.95           C  
ATOM  10290  O   VAL F 126     -19.774  97.066  29.215  1.00 80.77           O  
ATOM  10291  CB  VAL F 126     -21.826  99.307  28.336  1.00 81.23           C  
ATOM  10292  CG1 VAL F 126     -22.410 100.697  28.494  1.00 81.08           C  
ATOM  10293  CG2 VAL F 126     -20.649  99.331  27.399  1.00 81.98           C  
ATOM  10294  N   LYS F 127     -21.757  96.373  30.041  1.00 80.37           N  
ATOM  10295  CA  LYS F 127     -21.374  94.972  30.121  1.00 79.85           C  
ATOM  10296  C   LYS F 127     -21.570  94.254  28.771  1.00 79.21           C  
ATOM  10297  O   LYS F 127     -20.854  93.289  28.475  1.00 79.63           O  
ATOM  10298  CB  LYS F 127     -22.142  94.289  31.260  1.00 80.02           C  
ATOM  10299  CG  LYS F 127     -21.938  94.954  32.629  1.00 79.88           C  
ATOM  10300  N   LYS F 128     -22.514  94.728  27.954  1.00 78.05           N  
ATOM  10301  CA  LYS F 128     -22.626  94.269  26.568  1.00 77.31           C  
ATOM  10302  C   LYS F 128     -21.509  94.878  25.718  1.00 76.80           C  
ATOM  10303  O   LYS F 128     -20.985  95.937  26.055  1.00 76.67           O  
ATOM  10304  CB  LYS F 128     -23.964  94.664  25.956  1.00 77.30           C  
ATOM  10305  CG  LYS F 128     -25.153  93.895  26.481  1.00 77.03           C  
ATOM  10306  CD  LYS F 128     -26.462  94.552  26.087  1.00 76.04           C  
ATOM  10307  CE  LYS F 128     -27.620  93.924  26.831  1.00 75.72           C  
ATOM  10308  NZ  LYS F 128     -28.918  94.581  26.505  1.00 75.00           N  
ATOM  10309  N   PRO F 129     -21.140  94.212  24.609  1.00 76.15           N  
ATOM  10310  CA  PRO F 129     -20.103  94.754  23.715  1.00 75.75           C  
ATOM  10311  C   PRO F 129     -20.521  95.991  22.919  1.00 75.36           C  
ATOM  10312  O   PRO F 129     -21.605  96.014  22.326  1.00 75.66           O  
ATOM  10313  CB  PRO F 129     -19.821  93.590  22.751  1.00 75.67           C  
ATOM  10314  CG  PRO F 129     -20.438  92.378  23.402  1.00 76.01           C  
ATOM  10315  CD  PRO F 129     -21.618  92.899  24.147  1.00 75.99           C  
ATOM  10316  N   VAL F 130     -19.649  96.997  22.900  1.00 74.68           N  
ATOM  10317  CA  VAL F 130     -19.830  98.193  22.085  1.00 74.11           C  
ATOM  10318  C   VAL F 130     -18.790  98.185  20.975  1.00 73.86           C  
ATOM  10319  O   VAL F 130     -17.638  97.850  21.231  1.00 74.39           O  
ATOM  10320  CB  VAL F 130     -19.639  99.467  22.927  1.00 74.01           C  
ATOM  10321  CG1 VAL F 130     -19.856 100.714  22.093  1.00 72.97           C  
ATOM  10322  CG2 VAL F 130     -20.576  99.453  24.106  1.00 74.45           C  
ATOM  10323  N   ILE F 131     -19.187  98.573  19.764  1.00 73.47           N  
ATOM  10324  CA  ILE F 131     -18.278  98.659  18.611  1.00 73.19           C  
ATOM  10325  C   ILE F 131     -18.219 100.074  18.025  1.00 72.73           C  
ATOM  10326  O   ILE F 131     -19.230 100.594  17.527  1.00 72.49           O  
ATOM  10327  CB  ILE F 131     -18.739  97.748  17.451  1.00 73.40           C  
ATOM  10328  CG1 ILE F 131     -18.796  96.286  17.882  1.00 73.80           C  
ATOM  10329  CG2 ILE F 131     -17.825  97.908  16.240  1.00 73.22           C  
ATOM  10330  CD1 ILE F 131     -19.414  95.389  16.817  1.00 74.64           C  
ATOM  10331  N   ALA F 132     -17.037 100.680  18.044  1.00 71.95           N  
ATOM  10332  CA  ALA F 132     -16.860 101.988  17.424  1.00 71.43           C  
ATOM  10333  C   ALA F 132     -16.783 101.825  15.914  1.00 71.06           C  
ATOM  10334  O   ALA F 132     -16.050 100.980  15.415  1.00 71.27           O  
ATOM  10335  CB  ALA F 132     -15.611 102.669  17.952  1.00 71.21           C  
ATOM  10336  N   ALA F 133     -17.561 102.620  15.189  1.00 70.73           N  
ATOM  10337  CA  ALA F 133     -17.481 102.663  13.733  1.00 70.54           C  
ATOM  10338  C   ALA F 133     -17.061 104.069  13.325  1.00 70.38           C  
ATOM  10339  O   ALA F 133     -17.897 104.974  13.204  1.00 70.46           O  
ATOM  10340  CB  ALA F 133     -18.816 102.290  13.106  1.00 70.43           C  
ATOM  10341  N   VAL F 134     -15.758 104.233  13.112  1.00 70.16           N  
ATOM  10342  CA  VAL F 134     -15.147 105.539  12.898  1.00 70.19           C  
ATOM  10343  C   VAL F 134     -14.969 105.883  11.418  1.00 70.55           C  
ATOM  10344  O   VAL F 134     -14.122 105.301  10.739  1.00 70.83           O  
ATOM  10345  CB  VAL F 134     -13.763 105.586  13.568  1.00 70.27           C  
ATOM  10346  CG1 VAL F 134     -13.128 106.966  13.379  1.00 69.54           C  
ATOM  10347  CG2 VAL F 134     -13.882 105.196  15.048  1.00 69.12           C  
ATOM  10348  N   ASN F 135     -15.784 106.815  10.926  1.00 70.77           N  
ATOM  10349  CA  ASN F 135     -15.557 107.458   9.636  1.00 70.98           C  
ATOM  10350  C   ASN F 135     -14.965 108.836   9.887  1.00 71.27           C  
ATOM  10351  O   ASN F 135     -15.377 109.527  10.813  1.00 71.19           O  
ATOM  10352  CB  ASN F 135     -16.870 107.596   8.850  1.00 71.13           C  
ATOM  10353  CG  ASN F 135     -16.959 106.647   7.652  1.00 71.01           C  
ATOM  10354  OD1 ASN F 135     -15.947 106.141   7.156  1.00 71.29           O  
ATOM  10355  ND2 ASN F 135     -18.179 106.423   7.172  1.00 68.88           N  
ATOM  10356  N   GLY F 136     -13.993 109.227   9.071  1.00 71.80           N  
ATOM  10357  CA  GLY F 136     -13.373 110.546   9.190  1.00 72.26           C  
ATOM  10358  C   GLY F 136     -12.589 110.745  10.477  1.00 72.62           C  
ATOM  10359  O   GLY F 136     -11.978 109.812  10.984  1.00 72.51           O  
ATOM  10360  N   TYR F 137     -12.640 111.960  11.022  1.00 73.30           N  
ATOM  10361  CA  TYR F 137     -11.831 112.328  12.194  1.00 73.83           C  
ATOM  10362  C   TYR F 137     -12.299 111.678  13.507  1.00 73.88           C  
ATOM  10363  O   TYR F 137     -13.473 111.747  13.860  1.00 74.27           O  
ATOM  10364  CB  TYR F 137     -11.808 113.850  12.385  1.00 74.07           C  
ATOM  10365  CG  TYR F 137     -11.505 114.642  11.130  1.00 74.66           C  
ATOM  10366  CD1 TYR F 137     -10.416 114.324  10.321  1.00 74.86           C  
ATOM  10367  CD2 TYR F 137     -12.310 115.710  10.751  1.00 74.98           C  
ATOM  10368  CE1 TYR F 137     -10.144 115.054   9.163  1.00 75.13           C  
ATOM  10369  CE2 TYR F 137     -12.046 116.442   9.601  1.00 75.12           C  
ATOM  10370  CZ  TYR F 137     -10.961 116.115   8.809  1.00 75.15           C  
ATOM  10371  OH  TYR F 137     -10.701 116.846   7.661  1.00 74.79           O  
ATOM  10372  N   ALA F 138     -11.370 111.031  14.202  1.00 73.97           N  
ATOM  10373  CA  ALA F 138     -11.523 110.684  15.617  1.00 74.10           C  
ATOM  10374  C   ALA F 138     -10.331 111.290  16.367  1.00 74.30           C  
ATOM  10375  O   ALA F 138      -9.284 110.647  16.516  1.00 73.77           O  
ATOM  10376  CB  ALA F 138     -11.584 109.164  15.818  1.00 73.74           C  
ATOM  10377  N   PHE F 139     -10.495 112.544  16.800  1.00 74.77           N  
ATOM  10378  CA  PHE F 139      -9.443 113.287  17.492  1.00 75.46           C  
ATOM  10379  C   PHE F 139      -9.785 113.559  18.959  1.00 76.04           C  
ATOM  10380  O   PHE F 139     -10.953 113.615  19.341  1.00 76.42           O  
ATOM  10381  CB  PHE F 139      -9.169 114.625  16.792  1.00 75.74           C  
ATOM  10382  CG  PHE F 139      -8.807 114.505  15.326  1.00 75.65           C  
ATOM  10383  CD1 PHE F 139      -8.176 113.373  14.822  1.00 75.15           C  
ATOM  10384  CD2 PHE F 139      -9.076 115.558  14.460  1.00 76.32           C  
ATOM  10385  CE1 PHE F 139      -7.843 113.280  13.493  1.00 75.46           C  
ATOM  10386  CE2 PHE F 139      -8.745 115.480  13.111  1.00 76.52           C  
ATOM  10387  CZ  PHE F 139      -8.124 114.340  12.627  1.00 76.64           C  
ATOM  10388  N   GLY F 140      -8.749 113.720  19.777  1.00 76.63           N  
ATOM  10389  CA  GLY F 140      -8.898 114.053  21.192  1.00 76.83           C  
ATOM  10390  C   GLY F 140      -9.777 113.051  21.909  1.00 77.05           C  
ATOM  10391  O   GLY F 140      -9.505 111.860  21.904  1.00 77.05           O  
ATOM  10392  N   GLY F 141     -10.844 113.547  22.519  1.00 77.52           N  
ATOM  10393  CA  GLY F 141     -11.848 112.693  23.137  1.00 77.78           C  
ATOM  10394  C   GLY F 141     -12.492 111.743  22.140  1.00 78.09           C  
ATOM  10395  O   GLY F 141     -12.844 110.615  22.495  1.00 78.49           O  
ATOM  10396  N   GLY F 142     -12.647 112.183  20.893  1.00 77.90           N  
ATOM  10397  CA  GLY F 142     -13.208 111.321  19.864  1.00 77.93           C  
ATOM  10398  C   GLY F 142     -12.487 109.987  19.854  1.00 78.08           C  
ATOM  10399  O   GLY F 142     -13.105 108.921  19.929  1.00 78.16           O  
ATOM  10400  N   CYS F 143     -11.164 110.058  19.785  1.00 77.98           N  
ATOM  10401  CA  CYS F 143     -10.331 108.871  19.748  1.00 77.95           C  
ATOM  10402  C   CYS F 143     -10.441 108.082  21.046  1.00 78.18           C  
ATOM  10403  O   CYS F 143     -10.557 106.853  21.037  1.00 78.23           O  
ATOM  10404  CB  CYS F 143      -8.886 109.289  19.527  1.00 77.94           C  
ATOM  10405  SG  CYS F 143      -7.763 107.923  19.508  1.00 77.86           S  
ATOM  10406  N   GLU F 144     -10.393 108.801  22.163  1.00 78.34           N  
ATOM  10407  CA  GLU F 144     -10.532 108.198  23.487  1.00 78.54           C  
ATOM  10408  C   GLU F 144     -11.851 107.428  23.593  1.00 78.15           C  
ATOM  10409  O   GLU F 144     -11.891 106.299  24.069  1.00 78.01           O  
ATOM  10410  CB  GLU F 144     -10.431 109.279  24.568  1.00 78.36           C  
ATOM  10411  CG  GLU F 144      -9.052 109.950  24.580  1.00 79.01           C  
ATOM  10412  CD  GLU F 144      -8.839 110.883  25.754  1.00 79.64           C  
ATOM  10413  OE1 GLU F 144      -9.605 111.871  25.894  1.00 81.61           O  
ATOM  10414  OE2 GLU F 144      -7.892 110.633  26.539  1.00 80.88           O  
ATOM  10415  N   LEU F 145     -12.914 108.042  23.096  1.00 78.02           N  
ATOM  10416  CA  LEU F 145     -14.238 107.440  23.095  1.00 78.04           C  
ATOM  10417  C   LEU F 145     -14.241 106.134  22.298  1.00 77.95           C  
ATOM  10418  O   LEU F 145     -14.861 105.144  22.709  1.00 78.01           O  
ATOM  10419  CB  LEU F 145     -15.256 108.426  22.507  1.00 78.16           C  
ATOM  10420  CG  LEU F 145     -16.640 108.451  23.137  1.00 78.50           C  
ATOM  10421  CD1 LEU F 145     -16.539 108.968  24.576  1.00 78.20           C  
ATOM  10422  CD2 LEU F 145     -17.600 109.311  22.293  1.00 77.97           C  
ATOM  10423  N   ALA F 146     -13.546 106.134  21.163  1.00 77.77           N  
ATOM  10424  CA  ALA F 146     -13.460 104.947  20.318  1.00 77.58           C  
ATOM  10425  C   ALA F 146     -12.677 103.870  21.040  1.00 77.70           C  
ATOM  10426  O   ALA F 146     -13.111 102.721  21.087  1.00 77.79           O  
ATOM  10427  CB  ALA F 146     -12.803 105.271  19.004  1.00 77.45           C  
ATOM  10428  N   MET F 147     -11.532 104.253  21.610  1.00 77.75           N  
ATOM  10429  CA  MET F 147     -10.668 103.320  22.347  1.00 77.63           C  
ATOM  10430  C   MET F 147     -11.368 102.702  23.553  1.00 77.51           C  
ATOM  10431  O   MET F 147     -11.119 101.551  23.882  1.00 77.34           O  
ATOM  10432  CB  MET F 147      -9.377 104.011  22.784  1.00 77.51           C  
ATOM  10433  CG  MET F 147      -8.413 104.244  21.629  1.00 78.20           C  
ATOM  10434  SD  MET F 147      -6.775 104.829  22.108  1.00 77.96           S  
ATOM  10435  CE  MET F 147      -7.189 106.480  22.675  1.00 78.23           C  
ATOM  10436  N   MET F 148     -12.247 103.460  24.204  1.00 77.65           N  
ATOM  10437  CA  MET F 148     -13.066 102.922  25.285  1.00 77.77           C  
ATOM  10438  C   MET F 148     -13.968 101.788  24.801  1.00 77.59           C  
ATOM  10439  O   MET F 148     -14.398 100.978  25.598  1.00 77.79           O  
ATOM  10440  CB  MET F 148     -13.931 104.009  25.921  1.00 77.73           C  
ATOM  10441  CG  MET F 148     -13.209 104.931  26.886  1.00 78.27           C  
ATOM  10442  SD  MET F 148     -14.283 106.263  27.535  1.00 79.04           S  
ATOM  10443  CE  MET F 148     -13.229 106.952  28.814  1.00 78.83           C  
ATOM  10444  N   CYS F 149     -14.269 101.725  23.506  1.00 77.60           N  
ATOM  10445  CA  CYS F 149     -15.072 100.616  22.980  1.00 77.55           C  
ATOM  10446  C   CYS F 149     -14.237  99.341  22.809  1.00 77.68           C  
ATOM  10447  O   CYS F 149     -13.007  99.380  22.675  1.00 77.66           O  
ATOM  10448  CB  CYS F 149     -15.754 100.980  21.646  1.00 77.54           C  
ATOM  10449  SG  CYS F 149     -16.809 102.461  21.681  1.00 76.52           S  
ATOM  10450  N   ASP F 150     -14.939  98.213  22.787  1.00 77.70           N  
ATOM  10451  CA  ASP F 150     -14.314  96.905  22.663  1.00 77.78           C  
ATOM  10452  C   ASP F 150     -13.665  96.715  21.292  1.00 77.57           C  
ATOM  10453  O   ASP F 150     -12.490  96.345  21.199  1.00 77.36           O  
ATOM  10454  CB  ASP F 150     -15.365  95.824  22.893  1.00 77.98           C  
ATOM  10455  CG  ASP F 150     -16.044  95.962  24.247  1.00 78.73           C  
ATOM  10456  OD1 ASP F 150     -15.387  95.663  25.276  1.00 79.37           O  
ATOM  10457  OD2 ASP F 150     -17.223  96.384  24.280  1.00 78.30           O  
ATOM  10458  N   ILE F 151     -14.434  96.984  20.235  1.00 76.93           N  
ATOM  10459  CA  ILE F 151     -13.973  96.785  18.861  1.00 76.41           C  
ATOM  10460  C   ILE F 151     -14.077  98.081  18.032  1.00 76.17           C  
ATOM  10461  O   ILE F 151     -15.114  98.751  18.022  1.00 76.08           O  
ATOM  10462  CB  ILE F 151     -14.793  95.672  18.181  1.00 76.28           C  
ATOM  10463  CG1 ILE F 151     -15.061  94.530  19.172  1.00 75.76           C  
ATOM  10464  CG2 ILE F 151     -14.093  95.186  16.915  1.00 76.36           C  
ATOM  10465  CD1 ILE F 151     -15.668  93.300  18.560  1.00 75.09           C  
ATOM  10466  N   ILE F 152     -12.992  98.437  17.353  1.00 75.74           N  
ATOM  10467  CA  ILE F 152     -13.005  99.580  16.463  1.00 75.44           C  
ATOM  10468  C   ILE F 152     -12.935  99.095  15.026  1.00 75.46           C  
ATOM  10469  O   ILE F 152     -12.012  98.363  14.655  1.00 75.35           O  
ATOM  10470  CB  ILE F 152     -11.818 100.527  16.706  1.00 75.32           C  
ATOM  10471  CG1 ILE F 152     -11.794 101.009  18.148  1.00 74.71           C  
ATOM  10472  CG2 ILE F 152     -11.906 101.729  15.777  1.00 74.58           C  
ATOM  10473  CD1 ILE F 152     -10.704 102.024  18.414  1.00 74.26           C  
ATOM  10474  N   TYR F 153     -13.928  99.502  14.237  1.00 75.43           N  
ATOM  10475  CA  TYR F 153     -13.921  99.366  12.785  1.00 75.33           C  
ATOM  10476  C   TYR F 153     -13.681 100.774  12.251  1.00 75.37           C  
ATOM  10477  O   TYR F 153     -14.307 101.719  12.720  1.00 75.17           O  
ATOM  10478  CB  TYR F 153     -15.287  98.877  12.298  1.00 75.73           C  
ATOM  10479  CG  TYR F 153     -15.489  97.377  12.186  1.00 75.63           C  
ATOM  10480  CD1 TYR F 153     -14.840  96.492  13.024  1.00 76.20           C  
ATOM  10481  CD2 TYR F 153     -16.377  96.856  11.249  1.00 76.46           C  
ATOM  10482  CE1 TYR F 153     -15.039  95.116  12.919  1.00 76.59           C  
ATOM  10483  CE2 TYR F 153     -16.590  95.485  11.138  1.00 76.93           C  
ATOM  10484  CZ  TYR F 153     -15.921  94.617  11.981  1.00 76.69           C  
ATOM  10485  OH  TYR F 153     -16.125  93.254  11.876  1.00 76.14           O  
ATOM  10486  N   ALA F 154     -12.793 100.923  11.273  1.00 75.52           N  
ATOM  10487  CA  ALA F 154     -12.492 102.244  10.693  1.00 75.60           C  
ATOM  10488  C   ALA F 154     -12.818 102.323   9.197  1.00 75.55           C  
ATOM  10489  O   ALA F 154     -12.574 101.378   8.448  1.00 75.51           O  
ATOM  10490  CB  ALA F 154     -11.031 102.596  10.926  1.00 75.52           C  
ATOM  10491  N   GLY F 155     -13.375 103.456   8.767  1.00 75.60           N  
ATOM  10492  CA  GLY F 155     -13.541 103.749   7.342  1.00 75.41           C  
ATOM  10493  C   GLY F 155     -12.199 104.014   6.680  1.00 75.46           C  
ATOM  10494  O   GLY F 155     -11.184 104.187   7.361  1.00 75.46           O  
ATOM  10495  N   GLU F 156     -12.192 104.048   5.349  1.00 75.60           N  
ATOM  10496  CA  GLU F 156     -10.957 104.245   4.566  1.00 75.66           C  
ATOM  10497  C   GLU F 156     -10.274 105.591   4.832  1.00 75.44           C  
ATOM  10498  O   GLU F 156      -9.038 105.669   4.871  1.00 75.34           O  
ATOM  10499  CB  GLU F 156     -11.221 104.073   3.054  1.00 75.74           C  
ATOM  10500  CG  GLU F 156     -10.988 102.646   2.545  1.00 76.17           C  
ATOM  10501  N   LYS F 157     -11.076 106.635   5.027  1.00 75.25           N  
ATOM  10502  CA  LYS F 157     -10.559 107.997   5.199  1.00 75.37           C  
ATOM  10503  C   LYS F 157     -10.625 108.434   6.666  1.00 75.23           C  
ATOM  10504  O   LYS F 157     -10.700 109.631   6.968  1.00 75.19           O  
ATOM  10505  CB  LYS F 157     -11.319 108.981   4.285  1.00 75.12           C  
ATOM  10506  N   ALA F 158     -10.566 107.459   7.572  1.00 75.24           N  
ATOM  10507  CA  ALA F 158     -10.645 107.731   9.007  1.00 75.41           C  
ATOM  10508  C   ALA F 158      -9.278 108.156   9.518  1.00 75.47           C  
ATOM  10509  O   ALA F 158      -8.262 107.686   9.024  1.00 75.40           O  
ATOM  10510  CB  ALA F 158     -11.162 106.512   9.772  1.00 74.91           C  
ATOM  10511  N   GLN F 159      -9.261 109.059  10.491  1.00 75.80           N  
ATOM  10512  CA  GLN F 159      -8.014 109.594  11.019  1.00 76.33           C  
ATOM  10513  C   GLN F 159      -8.053 109.666  12.536  1.00 76.65           C  
ATOM  10514  O   GLN F 159      -9.068 110.074  13.113  1.00 76.66           O  
ATOM  10515  CB  GLN F 159      -7.736 110.975  10.429  1.00 76.47           C  
ATOM  10516  CG  GLN F 159      -7.021 110.911   9.096  1.00 77.13           C  
ATOM  10517  CD  GLN F 159      -6.950 112.252   8.407  1.00 77.85           C  
ATOM  10518  OE1 GLN F 159      -7.974 112.825   8.048  1.00 78.02           O  
ATOM  10519  NE2 GLN F 159      -5.735 112.753   8.202  1.00 78.99           N  
ATOM  10520  N   PHE F 160      -6.945 109.260  13.163  1.00 76.74           N  
ATOM  10521  CA  PHE F 160      -6.823 109.223  14.615  1.00 76.89           C  
ATOM  10522  C   PHE F 160      -5.695 110.130  15.087  1.00 77.03           C  
ATOM  10523  O   PHE F 160      -4.607 110.131  14.513  1.00 76.78           O  
ATOM  10524  CB  PHE F 160      -6.568 107.794  15.099  1.00 76.81           C  
ATOM  10525  CG  PHE F 160      -7.693 106.848  14.797  1.00 77.02           C  
ATOM  10526  CD1 PHE F 160      -7.834 106.300  13.529  1.00 77.15           C  
ATOM  10527  CD2 PHE F 160      -8.619 106.510  15.776  1.00 76.80           C  
ATOM  10528  CE1 PHE F 160      -8.877 105.427  13.239  1.00 76.82           C  
ATOM  10529  CE2 PHE F 160      -9.659 105.635  15.494  1.00 76.59           C  
ATOM  10530  CZ  PHE F 160      -9.787 105.094  14.225  1.00 76.51           C  
ATOM  10531  N   ALA F 161      -5.975 110.900  16.137  1.00 77.35           N  
ATOM  10532  CA  ALA F 161      -4.974 111.744  16.781  1.00 77.62           C  
ATOM  10533  C   ALA F 161      -5.354 112.013  18.237  1.00 77.86           C  
ATOM  10534  O   ALA F 161      -6.533 111.917  18.612  1.00 78.01           O  
ATOM  10535  CB  ALA F 161      -4.827 113.063  16.028  1.00 77.75           C  
ATOM  10536  N   GLN F 162      -4.343 112.332  19.047  1.00 77.82           N  
ATOM  10537  CA  GLN F 162      -4.534 112.905  20.379  1.00 77.86           C  
ATOM  10538  C   GLN F 162      -3.791 114.237  20.394  1.00 77.70           C  
ATOM  10539  O   GLN F 162      -2.637 114.303  20.828  1.00 77.96           O  
ATOM  10540  CB  GLN F 162      -3.985 111.977  21.458  1.00 78.04           C  
ATOM  10541  CG  GLN F 162      -4.715 110.638  21.585  1.00 79.01           C  
ATOM  10542  CD  GLN F 162      -6.075 110.737  22.262  1.00 80.49           C  
ATOM  10543  OE1 GLN F 162      -6.873 109.800  22.199  1.00 81.51           O  
ATOM  10544  NE2 GLN F 162      -6.347 111.868  22.913  1.00 81.49           N  
ATOM  10545  N   PRO F 163      -4.440 115.306  19.894  1.00 77.46           N  
ATOM  10546  CA  PRO F 163      -3.809 116.603  19.740  1.00 77.42           C  
ATOM  10547  C   PRO F 163      -3.940 117.538  20.941  1.00 77.33           C  
ATOM  10548  O   PRO F 163      -3.717 118.741  20.790  1.00 77.40           O  
ATOM  10549  CB  PRO F 163      -4.568 117.189  18.549  1.00 77.58           C  
ATOM  10550  CG  PRO F 163      -5.957 116.685  18.743  1.00 77.64           C  
ATOM  10551  CD  PRO F 163      -5.831 115.334  19.409  1.00 77.42           C  
ATOM  10552  N   GLU F 164      -4.272 117.008  22.116  1.00 77.27           N  
ATOM  10553  CA  GLU F 164      -4.430 117.841  23.322  1.00 77.34           C  
ATOM  10554  C   GLU F 164      -3.164 118.613  23.712  1.00 76.56           C  
ATOM  10555  O   GLU F 164      -3.254 119.660  24.334  1.00 76.66           O  
ATOM  10556  CB  GLU F 164      -4.907 117.006  24.519  1.00 77.69           C  
ATOM  10557  CG  GLU F 164      -6.345 116.470  24.393  1.00 79.40           C  
ATOM  10558  CD  GLU F 164      -6.422 115.065  23.787  1.00 81.91           C  
ATOM  10559  OE1 GLU F 164      -5.556 114.717  22.946  1.00 83.46           O  
ATOM  10560  OE2 GLU F 164      -7.352 114.307  24.152  1.00 83.71           O  
ATOM  10561  N   ILE F 165      -1.994 118.101  23.346  1.00 75.89           N  
ATOM  10562  CA  ILE F 165      -0.727 118.763  23.652  1.00 75.44           C  
ATOM  10563  C   ILE F 165      -0.649 120.159  23.037  1.00 75.13           C  
ATOM  10564  O   ILE F 165      -0.110 121.079  23.654  1.00 74.86           O  
ATOM  10565  CB  ILE F 165       0.481 117.904  23.173  1.00 75.42           C  
ATOM  10566  CG1 ILE F 165       1.800 118.414  23.769  1.00 75.28           C  
ATOM  10567  CG2 ILE F 165       0.564 117.883  21.648  1.00 75.68           C  
ATOM  10568  CD1 ILE F 165       1.983 118.088  25.222  1.00 74.45           C  
ATOM  10569  N   LEU F 166      -1.202 120.297  21.828  1.00 74.91           N  
ATOM  10570  CA  LEU F 166      -1.194 121.549  21.065  1.00 74.44           C  
ATOM  10571  C   LEU F 166      -1.956 122.681  21.747  1.00 74.45           C  
ATOM  10572  O   LEU F 166      -1.622 123.846  21.550  1.00 74.76           O  
ATOM  10573  CB  LEU F 166      -1.808 121.334  19.679  1.00 74.23           C  
ATOM  10574  CG  LEU F 166      -1.085 120.437  18.675  1.00 74.26           C  
ATOM  10575  CD1 LEU F 166      -1.935 120.295  17.407  1.00 73.85           C  
ATOM  10576  CD2 LEU F 166       0.300 120.980  18.333  1.00 73.18           C  
ATOM  10577  N   ILE F 167      -2.989 122.338  22.516  1.00 74.16           N  
ATOM  10578  CA  ILE F 167      -3.779 123.326  23.259  1.00 73.90           C  
ATOM  10579  C   ILE F 167      -3.400 123.358  24.749  1.00 73.87           C  
ATOM  10580  O   ILE F 167      -4.175 123.820  25.586  1.00 73.75           O  
ATOM  10581  CB  ILE F 167      -5.310 123.091  23.067  1.00 73.94           C  
ATOM  10582  CG1 ILE F 167      -5.789 121.808  23.766  1.00 73.80           C  
ATOM  10583  CG2 ILE F 167      -5.645 123.020  21.579  1.00 73.77           C  
ATOM  10584  CD1 ILE F 167      -7.293 121.577  23.668  1.00 73.72           C  
ATOM  10585  N   GLY F 168      -2.209 122.856  25.071  1.00 73.94           N  
ATOM  10586  CA  GLY F 168      -1.649 122.956  26.414  1.00 73.88           C  
ATOM  10587  C   GLY F 168      -2.108 121.946  27.452  1.00 73.91           C  
ATOM  10588  O   GLY F 168      -1.941 122.187  28.637  1.00 73.83           O  
ATOM  10589  N   THR F 169      -2.682 120.821  27.035  1.00 74.11           N  
ATOM  10590  CA  THR F 169      -3.048 119.755  27.990  1.00 74.55           C  
ATOM  10591  C   THR F 169      -2.449 118.420  27.586  1.00 74.61           C  
ATOM  10592  O   THR F 169      -1.646 118.331  26.664  1.00 74.55           O  
ATOM  10593  CB  THR F 169      -4.593 119.518  28.097  1.00 74.53           C  
ATOM  10594  OG1 THR F 169      -5.303 120.651  27.603  1.00 75.47           O  
ATOM  10595  CG2 THR F 169      -5.003 119.243  29.541  1.00 74.17           C  
ATOM  10596  N   ILE F 170      -2.857 117.387  28.313  1.00 74.73           N  
ATOM  10597  CA  ILE F 170      -2.630 116.016  27.929  1.00 74.86           C  
ATOM  10598  C   ILE F 170      -4.006 115.346  27.814  1.00 75.33           C  
ATOM  10599  O   ILE F 170      -5.001 115.873  28.321  1.00 75.05           O  
ATOM  10600  CB  ILE F 170      -1.742 115.306  28.975  1.00 74.81           C  
ATOM  10601  CG1 ILE F 170      -2.530 114.982  30.249  1.00 74.14           C  
ATOM  10602  CG2 ILE F 170      -0.535 116.180  29.315  1.00 73.99           C  
ATOM  10603  CD1 ILE F 170      -1.693 114.387  31.308  1.00 74.52           C  
ATOM  10604  N   PRO F 171      -4.075 114.196  27.126  1.00 75.94           N  
ATOM  10605  CA  PRO F 171      -5.319 113.407  27.103  1.00 76.30           C  
ATOM  10606  C   PRO F 171      -5.763 112.986  28.509  1.00 76.76           C  
ATOM  10607  O   PRO F 171      -4.925 112.569  29.304  1.00 77.35           O  
ATOM  10608  CB  PRO F 171      -4.940 112.179  26.271  1.00 76.20           C  
ATOM  10609  CG  PRO F 171      -3.745 112.614  25.445  1.00 75.86           C  
ATOM  10610  CD  PRO F 171      -3.007 113.593  26.300  1.00 75.70           C  
ATOM  10611  N   GLY F 172      -7.057 113.092  28.811  1.00 76.99           N  
ATOM  10612  CA  GLY F 172      -7.570 112.776  30.149  1.00 77.25           C  
ATOM  10613  C   GLY F 172      -8.727 111.781  30.204  1.00 77.54           C  
ATOM  10614  O   GLY F 172      -9.501 111.788  31.162  1.00 77.96           O  
ATOM  10615  N   ALA F 173      -8.853 110.930  29.188  1.00 77.67           N  
ATOM  10616  CA  ALA F 173      -9.873 109.867  29.160  1.00 77.73           C  
ATOM  10617  C   ALA F 173      -9.239 108.539  28.694  1.00 77.84           C  
ATOM  10618  O   ALA F 173      -9.744 107.851  27.813  1.00 77.45           O  
ATOM  10619  CB  ALA F 173     -11.045 110.273  28.258  1.00 77.64           C  
ATOM  10620  N   GLY F 174      -8.111 108.199  29.308  1.00 78.45           N  
ATOM  10621  CA  GLY F 174      -7.360 107.005  28.953  1.00 78.81           C  
ATOM  10622  C   GLY F 174      -6.605 107.140  27.648  1.00 79.31           C  
ATOM  10623  O   GLY F 174      -6.152 106.141  27.084  1.00 79.77           O  
ATOM  10624  N   GLY F 175      -6.436 108.369  27.168  1.00 79.56           N  
ATOM  10625  CA  GLY F 175      -5.768 108.597  25.892  1.00 79.61           C  
ATOM  10626  C   GLY F 175      -4.316 108.165  25.858  1.00 79.56           C  
ATOM  10627  O   GLY F 175      -3.844 107.677  24.842  1.00 80.38           O  
ATOM  10628  N   THR F 176      -3.586 108.355  26.949  1.00 79.29           N  
ATOM  10629  CA  THR F 176      -2.194 107.915  26.991  1.00 78.97           C  
ATOM  10630  C   THR F 176      -2.131 106.433  27.349  1.00 78.91           C  
ATOM  10631  O   THR F 176      -1.136 105.768  27.078  1.00 79.81           O  
ATOM  10632  CB  THR F 176      -1.354 108.726  28.007  1.00 78.96           C  
ATOM  10633  OG1 THR F 176      -1.871 108.541  29.326  1.00 78.09           O  
ATOM  10634  CG2 THR F 176      -1.361 110.222  27.660  1.00 78.68           C  
ATOM  10635  N   GLN F 177      -3.202 105.912  27.938  1.00 78.15           N  
ATOM  10636  CA  GLN F 177      -3.191 104.580  28.500  1.00 77.23           C  
ATOM  10637  C   GLN F 177      -3.667 103.528  27.517  1.00 76.69           C  
ATOM  10638  O   GLN F 177      -2.973 102.541  27.301  1.00 76.70           O  
ATOM  10639  CB  GLN F 177      -4.030 104.558  29.765  1.00 77.11           C  
ATOM  10640  CG  GLN F 177      -3.587 105.585  30.788  1.00 77.11           C  
ATOM  10641  CD  GLN F 177      -2.163 105.381  31.259  1.00 76.49           C  
ATOM  10642  OE1 GLN F 177      -1.785 104.277  31.631  1.00 78.13           O  
ATOM  10643  NE2 GLN F 177      -1.372 106.447  31.260  1.00 75.93           N  
ATOM  10644  N   ARG F 178      -4.832 103.730  26.913  1.00 76.10           N  
ATOM  10645  CA  ARG F 178      -5.350 102.754  25.956  1.00 75.94           C  
ATOM  10646  C   ARG F 178      -4.595 102.801  24.637  1.00 75.82           C  
ATOM  10647  O   ARG F 178      -4.442 101.775  23.981  1.00 76.05           O  
ATOM  10648  CB  ARG F 178      -6.846 102.943  25.711  1.00 76.05           C  
ATOM  10649  CG  ARG F 178      -7.675 102.778  26.975  1.00 76.41           C  
ATOM  10650  CD  ARG F 178      -9.136 102.489  26.705  1.00 76.37           C  
ATOM  10651  NE  ARG F 178      -9.800 102.138  27.959  1.00 77.03           N  
ATOM  10652  CZ  ARG F 178     -10.179 103.007  28.896  1.00 76.36           C  
ATOM  10653  NH1 ARG F 178      -9.999 104.315  28.743  1.00 76.33           N  
ATOM  10654  NH2 ARG F 178     -10.747 102.558  30.004  1.00 76.25           N  
ATOM  10655  N   LEU F 179      -4.114 103.982  24.254  1.00 75.57           N  
ATOM  10656  CA  LEU F 179      -3.373 104.119  23.009  1.00 75.26           C  
ATOM  10657  C   LEU F 179      -2.054 103.376  23.096  1.00 75.12           C  
ATOM  10658  O   LEU F 179      -1.734 102.580  22.229  1.00 75.16           O  
ATOM  10659  CB  LEU F 179      -3.120 105.590  22.678  1.00 75.37           C  
ATOM  10660  CG  LEU F 179      -2.386 105.892  21.362  1.00 74.95           C  
ATOM  10661  CD1 LEU F 179      -3.168 105.375  20.148  1.00 75.13           C  
ATOM  10662  CD2 LEU F 179      -2.159 107.374  21.253  1.00 73.95           C  
ATOM  10663  N   THR F 180      -1.292 103.631  24.149  1.00 74.92           N  
ATOM  10664  CA  THR F 180       0.008 102.994  24.304  1.00 74.97           C  
ATOM  10665  C   THR F 180      -0.080 101.463  24.274  1.00 75.19           C  
ATOM  10666  O   THR F 180       0.697 100.803  23.597  1.00 75.18           O  
ATOM  10667  CB  THR F 180       0.669 103.465  25.606  1.00 75.04           C  
ATOM  10668  OG1 THR F 180       0.676 104.897  25.614  1.00 74.01           O  
ATOM  10669  CG2 THR F 180       2.091 102.928  25.725  1.00 73.52           C  
ATOM  10670  N   ARG F 181      -1.043 100.915  25.004  1.00 75.61           N  
ATOM  10671  CA  ARG F 181      -1.261  99.466  25.064  1.00 75.67           C  
ATOM  10672  C   ARG F 181      -1.744  98.856  23.736  1.00 75.68           C  
ATOM  10673  O   ARG F 181      -1.529  97.667  23.477  1.00 76.20           O  
ATOM  10674  CB  ARG F 181      -2.277  99.134  26.156  1.00 75.62           C  
ATOM  10675  CG  ARG F 181      -1.810  99.447  27.561  1.00 75.98           C  
ATOM  10676  CD  ARG F 181      -2.945  99.245  28.534  1.00 76.92           C  
ATOM  10677  NE  ARG F 181      -2.508  99.140  29.926  1.00 78.20           N  
ATOM  10678  CZ  ARG F 181      -2.215 100.169  30.724  1.00 78.62           C  
ATOM  10679  NH1 ARG F 181      -2.280 101.419  30.283  1.00 79.82           N  
ATOM  10680  NH2 ARG F 181      -1.851  99.943  31.978  1.00 78.32           N  
ATOM  10681  N   ALA F 182      -2.416  99.644  22.906  1.00 75.29           N  
ATOM  10682  CA  ALA F 182      -2.811  99.165  21.584  1.00 75.26           C  
ATOM  10683  C   ALA F 182      -1.592  99.173  20.674  1.00 75.53           C  
ATOM  10684  O   ALA F 182      -1.240  98.165  20.061  1.00 75.86           O  
ATOM  10685  CB  ALA F 182      -3.905 100.037  20.999  1.00 74.68           C  
ATOM  10686  N   VAL F 183      -0.928 100.322  20.645  1.00 75.54           N  
ATOM  10687  CA  VAL F 183      -0.069 100.732  19.541  1.00 75.07           C  
ATOM  10688  C   VAL F 183       1.417 100.594  19.835  1.00 74.75           C  
ATOM  10689  O   VAL F 183       2.201 100.379  18.912  1.00 75.20           O  
ATOM  10690  CB  VAL F 183      -0.391 102.198  19.191  1.00 74.93           C  
ATOM  10691  CG1 VAL F 183       0.851 102.995  19.027  1.00 75.48           C  
ATOM  10692  CG2 VAL F 183      -1.289 102.272  17.979  1.00 75.23           C  
ATOM  10693  N   GLY F 184       1.798 100.734  21.108  1.00 74.31           N  
ATOM  10694  CA  GLY F 184       3.193 100.666  21.540  1.00 73.84           C  
ATOM  10695  C   GLY F 184       3.819 102.026  21.790  1.00 73.93           C  
ATOM  10696  O   GLY F 184       3.353 103.059  21.264  1.00 74.14           O  
ATOM  10697  N   LYS F 185       4.917 102.013  22.541  1.00 73.85           N  
ATOM  10698  CA  LYS F 185       5.524 103.224  23.081  1.00 74.05           C  
ATOM  10699  C   LYS F 185       5.952 104.227  22.027  1.00 74.07           C  
ATOM  10700  O   LYS F 185       5.653 105.406  22.149  1.00 75.08           O  
ATOM  10701  CB  LYS F 185       6.733 102.906  23.971  1.00 74.12           C  
ATOM  10702  CG  LYS F 185       7.036 104.034  24.951  1.00 74.45           C  
ATOM  10703  CD  LYS F 185       8.202 103.719  25.874  1.00 74.13           C  
ATOM  10704  CE  LYS F 185       9.540 103.931  25.190  1.00 74.34           C  
ATOM  10705  NZ  LYS F 185      10.646 104.089  26.182  1.00 74.85           N  
ATOM  10706  N   SER F 186       6.646 103.786  20.993  1.00 73.63           N  
ATOM  10707  CA  SER F 186       7.167 104.729  20.015  1.00 73.30           C  
ATOM  10708  C   SER F 186       6.058 105.554  19.341  1.00 73.11           C  
ATOM  10709  O   SER F 186       6.110 106.782  19.334  1.00 72.53           O  
ATOM  10710  CB  SER F 186       8.033 104.014  18.975  1.00 73.19           C  
ATOM  10711  OG  SER F 186       8.480 104.923  17.969  1.00 74.28           O  
ATOM  10712  N   LEU F 187       5.055 104.877  18.788  1.00 73.29           N  
ATOM  10713  CA  LEU F 187       3.997 105.565  18.060  1.00 73.51           C  
ATOM  10714  C   LEU F 187       3.086 106.358  18.998  1.00 73.79           C  
ATOM  10715  O   LEU F 187       2.763 107.515  18.715  1.00 74.09           O  
ATOM  10716  CB  LEU F 187       3.182 104.593  17.208  1.00 73.26           C  
ATOM  10717  CG  LEU F 187       2.044 105.237  16.387  1.00 73.82           C  
ATOM  10718  CD1 LEU F 187       2.567 106.323  15.430  1.00 71.45           C  
ATOM  10719  CD2 LEU F 187       1.257 104.178  15.621  1.00 73.63           C  
ATOM  10720  N   ALA F 188       2.696 105.746  20.113  1.00 74.10           N  
ATOM  10721  CA  ALA F 188       1.953 106.455  21.158  1.00 74.25           C  
ATOM  10722  C   ALA F 188       2.692 107.719  21.605  1.00 74.06           C  
ATOM  10723  O   ALA F 188       2.102 108.793  21.651  1.00 74.17           O  
ATOM  10724  CB  ALA F 188       1.685 105.537  22.356  1.00 74.25           C  
ATOM  10725  N   MET F 189       3.980 107.602  21.914  1.00 74.06           N  
ATOM  10726  CA  MET F 189       4.764 108.780  22.306  1.00 74.17           C  
ATOM  10727  C   MET F 189       4.781 109.816  21.204  1.00 73.87           C  
ATOM  10728  O   MET F 189       4.639 111.003  21.477  1.00 73.80           O  
ATOM  10729  CB  MET F 189       6.201 108.426  22.685  1.00 74.29           C  
ATOM  10730  CG  MET F 189       6.341 107.768  24.062  1.00 75.43           C  
ATOM  10731  SD  MET F 189       6.217 108.922  25.442  1.00 77.39           S  
ATOM  10732  CE  MET F 189       7.162 108.090  26.716  1.00 75.29           C  
ATOM  10733  N   GLU F 190       4.943 109.375  19.960  1.00 73.87           N  
ATOM  10734  CA  GLU F 190       5.000 110.311  18.832  1.00 73.91           C  
ATOM  10735  C   GLU F 190       3.660 111.029  18.663  1.00 73.77           C  
ATOM  10736  O   GLU F 190       3.616 112.253  18.554  1.00 73.49           O  
ATOM  10737  CB  GLU F 190       5.413 109.587  17.547  1.00 73.91           C  
ATOM  10738  CG  GLU F 190       5.530 110.483  16.302  1.00 73.72           C  
ATOM  10739  CD  GLU F 190       6.167 109.755  15.114  1.00 74.16           C  
ATOM  10740  OE1 GLU F 190       6.254 108.499  15.167  1.00 74.35           O  
ATOM  10741  OE2 GLU F 190       6.581 110.427  14.134  1.00 71.26           O  
ATOM  10742  N   MET F 191       2.574 110.261  18.670  1.00 73.79           N  
ATOM  10743  CA  MET F 191       1.229 110.827  18.573  1.00 74.20           C  
ATOM  10744  C   MET F 191       0.905 111.805  19.689  1.00 73.74           C  
ATOM  10745  O   MET F 191       0.356 112.871  19.429  1.00 74.01           O  
ATOM  10746  CB  MET F 191       0.173 109.725  18.566  1.00 74.19           C  
ATOM  10747  CG  MET F 191       0.039 109.012  17.238  1.00 74.66           C  
ATOM  10748  SD  MET F 191      -1.264 107.765  17.291  1.00 76.14           S  
ATOM  10749  CE  MET F 191      -2.751 108.790  17.281  1.00 73.40           C  
ATOM  10750  N   VAL F 192       1.240 111.443  20.924  1.00 73.65           N  
ATOM  10751  CA  VAL F 192       0.884 112.261  22.092  1.00 73.49           C  
ATOM  10752  C   VAL F 192       1.736 113.531  22.237  1.00 73.37           C  
ATOM  10753  O   VAL F 192       1.223 114.586  22.591  1.00 72.97           O  
ATOM  10754  CB  VAL F 192       0.950 111.431  23.413  1.00 73.52           C  
ATOM  10755  CG1 VAL F 192       0.706 112.331  24.615  1.00 72.90           C  
ATOM  10756  CG2 VAL F 192      -0.063 110.270  23.386  1.00 72.21           C  
ATOM  10757  N   LEU F 193       3.030 113.420  21.968  1.00 73.71           N  
ATOM  10758  CA  LEU F 193       3.949 114.536  22.159  1.00 74.14           C  
ATOM  10759  C   LEU F 193       3.937 115.541  21.001  1.00 74.89           C  
ATOM  10760  O   LEU F 193       4.304 116.706  21.201  1.00 74.90           O  
ATOM  10761  CB  LEU F 193       5.363 114.015  22.396  1.00 74.10           C  
ATOM  10762  CG  LEU F 193       5.546 113.099  23.613  1.00 73.86           C  
ATOM  10763  CD1 LEU F 193       6.974 112.613  23.701  1.00 72.93           C  
ATOM  10764  CD2 LEU F 193       5.161 113.814  24.885  1.00 74.00           C  
ATOM  10765  N   THR F 194       3.521 115.100  19.807  1.00 75.70           N  
ATOM  10766  CA  THR F 194       3.382 115.990  18.638  1.00 76.46           C  
ATOM  10767  C   THR F 194       1.935 116.336  18.282  1.00 77.08           C  
ATOM  10768  O   THR F 194       1.683 117.374  17.678  1.00 77.26           O  
ATOM  10769  CB  THR F 194       3.978 115.373  17.359  1.00 76.52           C  
ATOM  10770  OG1 THR F 194       3.132 114.309  16.907  1.00 76.59           O  
ATOM  10771  CG2 THR F 194       5.397 114.857  17.594  1.00 76.44           C  
ATOM  10772  N   GLY F 195       0.996 115.456  18.619  1.00 77.87           N  
ATOM  10773  CA  GLY F 195      -0.400 115.610  18.192  1.00 78.29           C  
ATOM  10774  C   GLY F 195      -0.645 115.223  16.740  1.00 78.62           C  
ATOM  10775  O   GLY F 195      -1.685 115.553  16.173  1.00 78.16           O  
ATOM  10776  N   ASP F 196       0.297 114.500  16.141  1.00 79.29           N  
ATOM  10777  CA  ASP F 196       0.176 114.114  14.740  1.00 79.98           C  
ATOM  10778  C   ASP F 196      -0.829 112.981  14.539  1.00 80.20           C  
ATOM  10779  O   ASP F 196      -1.222 112.300  15.485  1.00 80.53           O  
ATOM  10780  CB  ASP F 196       1.548 113.766  14.139  1.00 80.06           C  
ATOM  10781  CG  ASP F 196       2.364 115.017  13.768  1.00 81.25           C  
ATOM  10782  OD1 ASP F 196       1.785 116.133  13.710  1.00 81.28           O  
ATOM  10783  OD2 ASP F 196       3.585 114.883  13.526  1.00 82.31           O  
ATOM  10784  N   ARG F 197      -1.225 112.795  13.287  1.00 80.55           N  
ATOM  10785  CA  ARG F 197      -2.394 112.015  12.930  1.00 80.76           C  
ATOM  10786  C   ARG F 197      -1.982 110.760  12.176  1.00 80.61           C  
ATOM  10787  O   ARG F 197      -1.017 110.781  11.407  1.00 80.86           O  
ATOM  10788  CB  ARG F 197      -3.308 112.869  12.063  1.00 80.90           C  
ATOM  10789  CG  ARG F 197      -3.217 114.349  12.420  1.00 82.49           C  
ATOM  10790  CD  ARG F 197      -4.400 115.156  11.935  1.00 83.78           C  
ATOM  10791  NE  ARG F 197      -4.470 115.204  10.478  1.00 84.49           N  
ATOM  10792  CZ  ARG F 197      -5.323 115.965   9.795  1.00 85.29           C  
ATOM  10793  NH1 ARG F 197      -6.180 116.759  10.435  1.00 85.44           N  
ATOM  10794  NH2 ARG F 197      -5.317 115.937   8.465  1.00 85.01           N  
ATOM  10795  N   ILE F 198      -2.703 109.668  12.408  1.00 80.04           N  
ATOM  10796  CA  ILE F 198      -2.432 108.418  11.710  1.00 79.66           C  
ATOM  10797  C   ILE F 198      -3.664 108.029  10.903  1.00 79.29           C  
ATOM  10798  O   ILE F 198      -4.790 108.330  11.291  1.00 79.25           O  
ATOM  10799  CB  ILE F 198      -2.019 107.284  12.696  1.00 79.66           C  
ATOM  10800  CG1 ILE F 198      -3.252 106.617  13.333  1.00 79.55           C  
ATOM  10801  CG2 ILE F 198      -1.069 107.840  13.766  1.00 79.47           C  
ATOM  10802  CD1 ILE F 198      -2.941 105.505  14.312  1.00 79.16           C  
ATOM  10803  N   SER F 199      -3.438 107.365   9.779  1.00 78.87           N  
ATOM  10804  CA  SER F 199      -4.530 106.888   8.951  1.00 78.70           C  
ATOM  10805  C   SER F 199      -5.103 105.584   9.482  1.00 78.41           C  
ATOM  10806  O   SER F 199      -4.518 104.936  10.345  1.00 78.47           O  
ATOM  10807  CB  SER F 199      -4.054 106.676   7.517  1.00 78.71           C  
ATOM  10808  OG  SER F 199      -3.124 105.612   7.447  1.00 79.38           O  
ATOM  10809  N   ALA F 200      -6.253 105.212   8.932  1.00 78.27           N  
ATOM  10810  CA  ALA F 200      -6.908 103.937   9.206  1.00 78.17           C  
ATOM  10811  C   ALA F 200      -5.976 102.768   8.914  1.00 78.12           C  
ATOM  10812  O   ALA F 200      -6.009 101.745   9.596  1.00 77.83           O  
ATOM  10813  CB  ALA F 200      -8.171 103.816   8.356  1.00 78.08           C  
ATOM  10814  N   GLN F 201      -5.145 102.940   7.893  1.00 78.24           N  
ATOM  10815  CA  GLN F 201      -4.218 101.909   7.459  1.00 78.23           C  
ATOM  10816  C   GLN F 201      -3.121 101.730   8.498  1.00 78.20           C  
ATOM  10817  O   GLN F 201      -2.729 100.601   8.781  1.00 78.29           O  
ATOM  10818  CB  GLN F 201      -3.636 102.254   6.082  1.00 78.29           C  
ATOM  10819  CG  GLN F 201      -4.670 102.233   4.928  1.00 78.68           C  
ATOM  10820  CD  GLN F 201      -5.605 103.458   4.885  1.00 78.54           C  
ATOM  10821  OE1 GLN F 201      -5.188 104.585   5.156  1.00 78.72           O  
ATOM  10822  NE2 GLN F 201      -6.866 103.232   4.528  1.00 78.13           N  
ATOM  10823  N   ASP F 202      -2.650 102.830   9.087  1.00 78.20           N  
ATOM  10824  CA  ASP F 202      -1.654 102.756  10.173  1.00 78.30           C  
ATOM  10825  C   ASP F 202      -2.250 102.147  11.455  1.00 77.82           C  
ATOM  10826  O   ASP F 202      -1.642 101.288  12.085  1.00 77.64           O  
ATOM  10827  CB  ASP F 202      -1.089 104.149  10.493  1.00 78.57           C  
ATOM  10828  CG  ASP F 202      -0.363 104.774   9.320  1.00 79.64           C  
ATOM  10829  OD1 ASP F 202       0.353 104.035   8.609  1.00 81.58           O  
ATOM  10830  OD2 ASP F 202      -0.500 106.006   9.113  1.00 80.41           O  
ATOM  10831  N   ALA F 203      -3.439 102.609  11.831  1.00 77.36           N  
ATOM  10832  CA  ALA F 203      -4.155 102.084  12.987  1.00 77.12           C  
ATOM  10833  C   ALA F 203      -4.371 100.567  12.914  1.00 76.90           C  
ATOM  10834  O   ALA F 203      -4.298  99.865  13.933  1.00 76.81           O  
ATOM  10835  CB  ALA F 203      -5.500 102.793  13.130  1.00 77.03           C  
ATOM  10836  N   LYS F 204      -4.665 100.073  11.716  1.00 76.62           N  
ATOM  10837  CA  LYS F 204      -4.940  98.657  11.511  1.00 76.65           C  
ATOM  10838  C   LYS F 204      -3.655  97.863  11.681  1.00 76.46           C  
ATOM  10839  O   LYS F 204      -3.619  96.879  12.429  1.00 76.51           O  
ATOM  10840  CB  LYS F 204      -5.570  98.425  10.127  1.00 76.98           C  
ATOM  10841  CG  LYS F 204      -5.716  96.957   9.678  1.00 77.44           C  
ATOM  10842  CD  LYS F 204      -6.455  96.072  10.691  1.00 78.46           C  
ATOM  10843  CE  LYS F 204      -6.316  94.589  10.327  1.00 78.62           C  
ATOM  10844  NZ  LYS F 204      -6.638  94.316   8.884  1.00 78.60           N  
ATOM  10845  N   GLN F 205      -2.594  98.310  11.010  1.00 76.25           N  
ATOM  10846  CA  GLN F 205      -1.266  97.708  11.182  1.00 75.96           C  
ATOM  10847  C   GLN F 205      -0.903  97.632  12.658  1.00 75.23           C  
ATOM  10848  O   GLN F 205      -0.472  96.586  13.119  1.00 75.66           O  
ATOM  10849  CB  GLN F 205      -0.179  98.474  10.404  1.00 76.02           C  
ATOM  10850  N   ALA F 206      -1.112  98.724  13.393  1.00 74.56           N  
ATOM  10851  CA  ALA F 206      -0.767  98.793  14.824  1.00 74.19           C  
ATOM  10852  C   ALA F 206      -1.811  98.169  15.763  1.00 74.23           C  
ATOM  10853  O   ALA F 206      -1.618  98.152  16.965  1.00 74.66           O  
ATOM  10854  CB  ALA F 206      -0.519 100.231  15.224  1.00 73.90           C  
ATOM  10855  N   GLY F 207      -2.925  97.677  15.243  1.00 74.32           N  
ATOM  10856  CA  GLY F 207      -3.901  96.997  16.089  1.00 74.40           C  
ATOM  10857  C   GLY F 207      -4.730  97.870  17.016  1.00 74.43           C  
ATOM  10858  O   GLY F 207      -5.261  97.369  18.003  1.00 74.24           O  
ATOM  10859  N   LEU F 208      -4.851  99.163  16.697  1.00 74.73           N  
ATOM  10860  CA  LEU F 208      -5.786 100.071  17.380  1.00 74.78           C  
ATOM  10861  C   LEU F 208      -7.211  99.783  16.894  1.00 75.36           C  
ATOM  10862  O   LEU F 208      -8.171  99.785  17.682  1.00 75.39           O  
ATOM  10863  CB  LEU F 208      -5.417 101.526  17.096  1.00 74.81           C  
ATOM  10864  CG  LEU F 208      -6.280 102.659  17.662  1.00 74.93           C  
ATOM  10865  CD1 LEU F 208      -6.312 102.646  19.188  1.00 75.26           C  
ATOM  10866  CD2 LEU F 208      -5.772 103.994  17.165  1.00 74.44           C  
ATOM  10867  N   VAL F 209      -7.332  99.545  15.590  1.00 75.67           N  
ATOM  10868  CA  VAL F 209      -8.571  99.087  14.982  1.00 75.85           C  
ATOM  10869  C   VAL F 209      -8.305  97.734  14.350  1.00 75.88           C  
ATOM  10870  O   VAL F 209      -7.157  97.409  14.047  1.00 76.30           O  
ATOM  10871  CB  VAL F 209      -9.030 100.046  13.906  1.00 75.83           C  
ATOM  10872  CG1 VAL F 209      -8.927 101.477  14.415  1.00 76.36           C  
ATOM  10873  CG2 VAL F 209      -8.187  99.864  12.663  1.00 75.99           C  
ATOM  10874  N   SER F 210      -9.360  96.952  14.146  1.00 75.75           N  
ATOM  10875  CA  SER F 210      -9.211  95.568  13.717  1.00 75.80           C  
ATOM  10876  C   SER F 210      -9.842  95.251  12.364  1.00 75.88           C  
ATOM  10877  O   SER F 210      -9.879  94.091  11.958  1.00 75.88           O  
ATOM  10878  CB  SER F 210      -9.780  94.640  14.784  1.00 75.68           C  
ATOM  10879  OG  SER F 210     -11.155  94.871  14.976  1.00 76.52           O  
ATOM  10880  N   LYS F 211     -10.334  96.276  11.671  1.00 76.17           N  
ATOM  10881  CA  LYS F 211     -10.924  96.119  10.337  1.00 76.19           C  
ATOM  10882  C   LYS F 211     -11.006  97.482   9.648  1.00 75.99           C  
ATOM  10883  O   LYS F 211     -11.246  98.495  10.296  1.00 75.69           O  
ATOM  10884  CB  LYS F 211     -12.321  95.479  10.417  1.00 76.25           C  
ATOM  10885  CG  LYS F 211     -12.680  94.627   9.196  1.00 76.70           C  
ATOM  10886  CD  LYS F 211     -14.170  94.272   9.131  1.00 76.69           C  
ATOM  10887  CE  LYS F 211     -14.510  93.438   7.881  1.00 77.73           C  
ATOM  10888  NZ  LYS F 211     -15.902  93.683   7.327  1.00 77.96           N  
ATOM  10889  N   ILE F 212     -10.781  97.495   8.340  1.00 76.16           N  
ATOM  10890  CA  ILE F 212     -10.959  98.690   7.518  1.00 76.17           C  
ATOM  10891  C   ILE F 212     -12.037  98.422   6.479  1.00 76.26           C  
ATOM  10892  O   ILE F 212     -12.052  97.357   5.868  1.00 76.09           O  
ATOM  10893  CB  ILE F 212      -9.662  99.079   6.795  1.00 76.25           C  
ATOM  10894  CG1 ILE F 212      -8.555  99.396   7.814  1.00 76.12           C  
ATOM  10895  CG2 ILE F 212      -9.903 100.269   5.888  1.00 75.36           C  
ATOM  10896  CD1 ILE F 212      -7.224  99.765   7.156  1.00 76.19           C  
ATOM  10897  N   CYS F 213     -12.933  99.390   6.289  1.00 76.54           N  
ATOM  10898  CA  CYS F 213     -14.073  99.243   5.383  1.00 76.82           C  
ATOM  10899  C   CYS F 213     -14.232 100.467   4.477  1.00 76.74           C  
ATOM  10900  O   CYS F 213     -13.733 101.545   4.789  1.00 76.69           O  
ATOM  10901  CB  CYS F 213     -15.371  99.063   6.184  1.00 76.99           C  
ATOM  10902  SG  CYS F 213     -15.319  97.820   7.512  1.00 78.51           S  
ATOM  10903  N   PRO F 214     -14.927 100.305   3.344  1.00 76.74           N  
ATOM  10904  CA  PRO F 214     -15.315 101.480   2.564  1.00 76.90           C  
ATOM  10905  C   PRO F 214     -16.250 102.401   3.349  1.00 76.87           C  
ATOM  10906  O   PRO F 214     -17.084 101.929   4.123  1.00 76.97           O  
ATOM  10907  CB  PRO F 214     -16.042 100.881   1.353  1.00 76.87           C  
ATOM  10908  CG  PRO F 214     -15.545  99.470   1.270  1.00 77.00           C  
ATOM  10909  CD  PRO F 214     -15.347  99.053   2.693  1.00 76.80           C  
ATOM  10910  N   VAL F 215     -16.108 103.702   3.144  1.00 76.72           N  
ATOM  10911  CA  VAL F 215     -16.892 104.685   3.877  1.00 76.59           C  
ATOM  10912  C   VAL F 215     -18.385 104.353   3.781  1.00 76.72           C  
ATOM  10913  O   VAL F 215     -19.105 104.377   4.778  1.00 76.46           O  
ATOM  10914  CB  VAL F 215     -16.629 106.111   3.336  1.00 76.61           C  
ATOM  10915  CG1 VAL F 215     -17.437 107.137   4.110  1.00 76.71           C  
ATOM  10916  CG2 VAL F 215     -15.138 106.443   3.395  1.00 75.99           C  
ATOM  10917  N   GLU F 216     -18.821 104.006   2.573  1.00 77.04           N  
ATOM  10918  CA  GLU F 216     -20.234 103.747   2.264  1.00 77.24           C  
ATOM  10919  C   GLU F 216     -20.841 102.616   3.094  1.00 76.96           C  
ATOM  10920  O   GLU F 216     -22.000 102.687   3.489  1.00 76.91           O  
ATOM  10921  CB  GLU F 216     -20.400 103.402   0.776  1.00 77.41           C  
ATOM  10922  CG  GLU F 216     -19.998 104.525  -0.202  1.00 78.82           C  
ATOM  10923  CD  GLU F 216     -18.491 104.580  -0.527  1.00 80.04           C  
ATOM  10924  OE1 GLU F 216     -17.743 103.635  -0.185  1.00 78.83           O  
ATOM  10925  OE2 GLU F 216     -18.062 105.589  -1.138  1.00 81.40           O  
ATOM  10926  N   THR F 217     -20.056 101.572   3.348  1.00 76.75           N  
ATOM  10927  CA  THR F 217     -20.562 100.367   4.001  1.00 76.44           C  
ATOM  10928  C   THR F 217     -20.028 100.176   5.429  1.00 76.24           C  
ATOM  10929  O   THR F 217     -20.239  99.123   6.028  1.00 76.36           O  
ATOM  10930  CB  THR F 217     -20.251  99.114   3.137  1.00 76.48           C  
ATOM  10931  OG1 THR F 217     -18.837  98.975   2.959  1.00 75.72           O  
ATOM  10932  CG2 THR F 217     -20.926  99.230   1.760  1.00 76.57           C  
ATOM  10933  N   LEU F 218     -19.379 101.195   5.991  1.00 75.89           N  
ATOM  10934  CA  LEU F 218     -18.731 101.060   7.302  1.00 75.90           C  
ATOM  10935  C   LEU F 218     -19.712 100.691   8.408  1.00 75.95           C  
ATOM  10936  O   LEU F 218     -19.563  99.651   9.048  1.00 75.99           O  
ATOM  10937  CB  LEU F 218     -17.985 102.343   7.679  1.00 75.78           C  
ATOM  10938  CG  LEU F 218     -17.320 102.397   9.050  1.00 75.34           C  
ATOM  10939  CD1 LEU F 218     -16.382 101.218   9.269  1.00 75.12           C  
ATOM  10940  CD2 LEU F 218     -16.574 103.699   9.171  1.00 75.62           C  
ATOM  10941  N   VAL F 219     -20.705 101.544   8.632  1.00 76.00           N  
ATOM  10942  CA  VAL F 219     -21.727 101.285   9.640  1.00 76.18           C  
ATOM  10943  C   VAL F 219     -22.437  99.951   9.355  1.00 76.62           C  
ATOM  10944  O   VAL F 219     -22.762  99.206  10.291  1.00 76.89           O  
ATOM  10945  CB  VAL F 219     -22.752 102.444   9.724  1.00 76.11           C  
ATOM  10946  CG1 VAL F 219     -23.887 102.098  10.680  1.00 76.01           C  
ATOM  10947  CG2 VAL F 219     -22.064 103.736  10.165  1.00 75.72           C  
ATOM  10948  N   GLU F 220     -22.640  99.648   8.072  1.00 76.82           N  
ATOM  10949  CA  GLU F 220     -23.236  98.379   7.631  1.00 77.30           C  
ATOM  10950  C   GLU F 220     -22.389  97.160   8.057  1.00 77.22           C  
ATOM  10951  O   GLU F 220     -22.935  96.172   8.559  1.00 77.23           O  
ATOM  10952  CB  GLU F 220     -23.443  98.390   6.104  1.00 77.34           C  
ATOM  10953  CG  GLU F 220     -24.419  97.338   5.566  1.00 78.07           C  
ATOM  10954  CD  GLU F 220     -24.529  97.340   4.025  1.00 78.53           C  
ATOM  10955  OE1 GLU F 220     -25.235  98.209   3.443  1.00 78.96           O  
ATOM  10956  OE2 GLU F 220     -23.916  96.448   3.392  1.00 80.54           O  
ATOM  10957  N   GLU F 221     -21.069  97.230   7.868  1.00 76.99           N  
ATOM  10958  CA  GLU F 221     -20.184  96.153   8.318  1.00 76.85           C  
ATOM  10959  C   GLU F 221     -20.213  96.071   9.842  1.00 76.41           C  
ATOM  10960  O   GLU F 221     -20.195  94.974  10.409  1.00 76.44           O  
ATOM  10961  CB  GLU F 221     -18.724  96.365   7.876  1.00 77.17           C  
ATOM  10962  CG  GLU F 221     -18.466  96.594   6.378  1.00 78.45           C  
ATOM  10963  CD  GLU F 221     -18.968  95.483   5.476  1.00 80.11           C  
ATOM  10964  OE1 GLU F 221     -19.058  94.320   5.927  1.00 81.50           O  
ATOM  10965  OE2 GLU F 221     -19.261  95.778   4.297  1.00 81.57           O  
ATOM  10966  N   ALA F 222     -20.233  97.231  10.501  1.00 75.87           N  
ATOM  10967  CA  ALA F 222     -20.234  97.285  11.968  1.00 75.51           C  
ATOM  10968  C   ALA F 222     -21.468  96.593  12.530  1.00 75.19           C  
ATOM  10969  O   ALA F 222     -21.373  95.858  13.507  1.00 75.02           O  
ATOM  10970  CB  ALA F 222     -20.154  98.727  12.472  1.00 75.15           C  
ATOM  10971  N   ILE F 223     -22.617  96.818  11.897  1.00 75.08           N  
ATOM  10972  CA  ILE F 223     -23.864  96.190  12.334  1.00 75.00           C  
ATOM  10973  C   ILE F 223     -23.812  94.676  12.128  1.00 75.15           C  
ATOM  10974  O   ILE F 223     -24.204  93.927  13.015  1.00 75.29           O  
ATOM  10975  CB  ILE F 223     -25.100  96.796  11.620  1.00 74.96           C  
ATOM  10976  CG1 ILE F 223     -25.300  98.248  12.056  1.00 74.60           C  
ATOM  10977  CG2 ILE F 223     -26.356  96.001  11.942  1.00 74.48           C  
ATOM  10978  CD1 ILE F 223     -25.989  99.096  11.027  1.00 74.17           C  
ATOM  10979  N   GLN F 224     -23.317  94.229  10.977  1.00 75.33           N  
ATOM  10980  CA  GLN F 224     -23.181  92.795  10.713  1.00 75.64           C  
ATOM  10981  C   GLN F 224     -22.309  92.122  11.768  1.00 75.68           C  
ATOM  10982  O   GLN F 224     -22.677  91.072  12.296  1.00 75.73           O  
ATOM  10983  CB  GLN F 224     -22.626  92.535   9.311  1.00 75.66           C  
ATOM  10984  CG  GLN F 224     -23.632  92.855   8.212  1.00 76.84           C  
ATOM  10985  CD  GLN F 224     -23.148  92.467   6.828  1.00 77.52           C  
ATOM  10986  OE1 GLN F 224     -21.944  92.317   6.591  1.00 78.00           O  
ATOM  10987  NE2 GLN F 224     -24.088  92.300   5.903  1.00 77.03           N  
ATOM  10988  N   CYS F 225     -21.165  92.728  12.084  1.00 75.70           N  
ATOM  10989  CA  CYS F 225     -20.330  92.230  13.178  1.00 75.61           C  
ATOM  10990  C   CYS F 225     -21.093  92.223  14.503  1.00 75.48           C  
ATOM  10991  O   CYS F 225     -21.068  91.229  15.232  1.00 75.45           O  
ATOM  10992  CB  CYS F 225     -19.063  93.063  13.323  1.00 75.59           C  
ATOM  10993  SG  CYS F 225     -18.120  92.655  14.799  1.00 76.25           S  
ATOM  10994  N   ALA F 226     -21.769  93.325  14.809  1.00 75.33           N  
ATOM  10995  CA  ALA F 226     -22.604  93.403  16.008  1.00 75.55           C  
ATOM  10996  C   ALA F 226     -23.711  92.347  16.007  1.00 75.78           C  
ATOM  10997  O   ALA F 226     -24.051  91.794  17.050  1.00 76.09           O  
ATOM  10998  CB  ALA F 226     -23.209  94.790  16.146  1.00 75.35           C  
ATOM  10999  N   GLU F 227     -24.256  92.062  14.832  1.00 75.89           N  
ATOM  11000  CA  GLU F 227     -25.383  91.143  14.696  1.00 76.22           C  
ATOM  11001  C   GLU F 227     -24.987  89.694  15.009  1.00 76.10           C  
ATOM  11002  O   GLU F 227     -25.786  88.947  15.571  1.00 75.98           O  
ATOM  11003  CB  GLU F 227     -25.985  91.263  13.286  1.00 76.35           C  
ATOM  11004  CG  GLU F 227     -27.373  90.670  13.126  1.00 77.26           C  
ATOM  11005  CD  GLU F 227     -28.133  91.264  11.940  1.00 78.49           C  
ATOM  11006  OE1 GLU F 227     -27.501  91.556  10.897  1.00 78.45           O  
ATOM  11007  OE2 GLU F 227     -29.369  91.438  12.061  1.00 78.99           O  
ATOM  11008  N   LYS F 228     -23.761  89.307  14.652  1.00 76.10           N  
ATOM  11009  CA  LYS F 228     -23.212  87.997  15.032  1.00 76.29           C  
ATOM  11010  C   LYS F 228     -23.059  87.893  16.543  1.00 75.83           C  
ATOM  11011  O   LYS F 228     -23.414  86.878  17.145  1.00 75.93           O  
ATOM  11012  CB  LYS F 228     -21.830  87.767  14.416  1.00 76.29           C  
ATOM  11013  CG  LYS F 228     -21.805  87.540  12.915  1.00 77.13           C  
ATOM  11014  CD  LYS F 228     -20.367  87.288  12.444  1.00 77.43           C  
ATOM  11015  CE  LYS F 228     -20.090  87.927  11.089  1.00 78.46           C  
ATOM  11016  NZ  LYS F 228     -18.626  88.083  10.883  1.00 79.38           N  
ATOM  11017  N   ILE F 229     -22.506  88.940  17.148  1.00 75.24           N  
ATOM  11018  CA  ILE F 229     -22.323  88.976  18.595  1.00 74.79           C  
ATOM  11019  C   ILE F 229     -23.671  88.886  19.303  1.00 74.39           C  
ATOM  11020  O   ILE F 229     -23.817  88.192  20.302  1.00 74.57           O  
ATOM  11021  CB  ILE F 229     -21.564  90.245  19.040  1.00 74.71           C  
ATOM  11022  CG1 ILE F 229     -20.099  90.165  18.594  1.00 73.96           C  
ATOM  11023  CG2 ILE F 229     -21.656  90.414  20.542  1.00 74.51           C  
ATOM  11024  CD1 ILE F 229     -19.311  91.439  18.801  1.00 72.61           C  
ATOM  11025  N   ALA F 230     -24.665  89.573  18.764  1.00 74.09           N  
ATOM  11026  CA  ALA F 230     -26.009  89.512  19.317  1.00 73.69           C  
ATOM  11027  C   ALA F 230     -26.598  88.099  19.263  1.00 73.42           C  
ATOM  11028  O   ALA F 230     -27.435  87.762  20.094  1.00 73.45           O  
ATOM  11029  CB  ALA F 230     -26.909  90.491  18.600  1.00 73.74           C  
ATOM  11030  N   SER F 231     -26.175  87.287  18.290  1.00 73.22           N  
ATOM  11031  CA  SER F 231     -26.658  85.898  18.150  1.00 73.13           C  
ATOM  11032  C   SER F 231     -26.282  85.014  19.326  1.00 72.85           C  
ATOM  11033  O   SER F 231     -27.049  84.136  19.716  1.00 73.00           O  
ATOM  11034  CB  SER F 231     -26.098  85.226  16.893  1.00 73.14           C  
ATOM  11035  OG  SER F 231     -26.381  85.973  15.740  1.00 73.55           O  
ATOM  11036  N   ASN F 232     -25.095  85.241  19.877  1.00 72.51           N  
ATOM  11037  CA  ASN F 232     -24.591  84.421  20.978  1.00 72.27           C  
ATOM  11038  C   ASN F 232     -25.344  84.668  22.300  1.00 72.11           C  
ATOM  11039  O   ASN F 232     -26.154  85.576  22.401  1.00 72.02           O  
ATOM  11040  CB  ASN F 232     -23.087  84.668  21.163  1.00 72.07           C  
ATOM  11041  CG  ASN F 232     -22.286  84.435  19.883  1.00 71.63           C  
ATOM  11042  OD1 ASN F 232     -22.650  83.598  19.061  1.00 70.83           O  
ATOM  11043  ND2 ASN F 232     -21.187  85.182  19.715  1.00 70.36           N  
ATOM  11044  N   SER F 233     -25.064  83.847  23.308  1.00 72.11           N  
ATOM  11045  CA  SER F 233     -25.642  84.025  24.643  1.00 72.01           C  
ATOM  11046  C   SER F 233     -25.187  85.340  25.292  1.00 72.04           C  
ATOM  11047  O   SER F 233     -23.996  85.594  25.406  1.00 72.03           O  
ATOM  11048  CB  SER F 233     -25.266  82.841  25.537  1.00 71.83           C  
ATOM  11049  OG  SER F 233     -25.683  83.055  26.870  1.00 70.94           O  
ATOM  11050  N   LYS F 234     -26.144  86.165  25.716  1.00 72.27           N  
ATOM  11051  CA  LYS F 234     -25.849  87.479  26.297  1.00 72.37           C  
ATOM  11052  C   LYS F 234     -25.008  87.344  27.562  1.00 72.42           C  
ATOM  11053  O   LYS F 234     -24.036  88.083  27.753  1.00 72.33           O  
ATOM  11054  CB  LYS F 234     -27.142  88.250  26.605  1.00 72.17           C  
ATOM  11055  N   ILE F 235     -25.380  86.387  28.408  1.00 72.47           N  
ATOM  11056  CA  ILE F 235     -24.661  86.127  29.657  1.00 72.55           C  
ATOM  11057  C   ILE F 235     -23.233  85.637  29.404  1.00 72.52           C  
ATOM  11058  O   ILE F 235     -22.294  86.107  30.055  1.00 73.02           O  
ATOM  11059  CB  ILE F 235     -25.425  85.124  30.561  1.00 72.55           C  
ATOM  11060  CG1 ILE F 235     -24.760  85.027  31.935  1.00 72.80           C  
ATOM  11061  CG2 ILE F 235     -25.494  83.748  29.919  1.00 72.42           C  
ATOM  11062  CD1 ILE F 235     -25.624  84.347  32.985  1.00 73.21           C  
ATOM  11063  N   VAL F 236     -23.066  84.732  28.441  1.00 72.39           N  
ATOM  11064  CA  VAL F 236     -21.753  84.143  28.153  1.00 72.70           C  
ATOM  11065  C   VAL F 236     -20.841  85.118  27.387  1.00 72.49           C  
ATOM  11066  O   VAL F 236     -19.629  85.140  27.605  1.00 72.20           O  
ATOM  11067  CB  VAL F 236     -21.878  82.772  27.426  1.00 72.69           C  
ATOM  11068  CG1 VAL F 236     -20.507  82.189  27.110  1.00 73.33           C  
ATOM  11069  CG2 VAL F 236     -22.657  81.794  28.291  1.00 72.74           C  
ATOM  11070  N   VAL F 237     -21.434  85.926  26.512  1.00 72.48           N  
ATOM  11071  CA  VAL F 237     -20.730  87.039  25.866  1.00 72.33           C  
ATOM  11072  C   VAL F 237     -20.202  88.009  26.914  1.00 72.62           C  
ATOM  11073  O   VAL F 237     -19.056  88.433  26.843  1.00 72.58           O  
ATOM  11074  CB  VAL F 237     -21.660  87.810  24.886  1.00 72.22           C  
ATOM  11075  CG1 VAL F 237     -21.130  89.216  24.599  1.00 71.39           C  
ATOM  11076  CG2 VAL F 237     -21.828  87.030  23.598  1.00 71.71           C  
ATOM  11077  N   ALA F 238     -21.044  88.349  27.886  1.00 73.08           N  
ATOM  11078  CA  ALA F 238     -20.661  89.260  28.963  1.00 73.40           C  
ATOM  11079  C   ALA F 238     -19.406  88.791  29.710  1.00 73.89           C  
ATOM  11080  O   ALA F 238     -18.546  89.601  30.040  1.00 73.71           O  
ATOM  11081  CB  ALA F 238     -21.816  89.442  29.935  1.00 73.02           C  
ATOM  11082  N   MET F 239     -19.307  87.489  29.975  1.00 74.61           N  
ATOM  11083  CA  MET F 239     -18.177  86.934  30.724  1.00 75.09           C  
ATOM  11084  C   MET F 239     -16.936  86.906  29.853  1.00 75.20           C  
ATOM  11085  O   MET F 239     -15.832  87.218  30.321  1.00 75.38           O  
ATOM  11086  CB  MET F 239     -18.483  85.521  31.219  1.00 75.20           C  
ATOM  11087  CG  MET F 239     -19.688  85.416  32.153  1.00 75.47           C  
ATOM  11088  SD  MET F 239     -20.114  83.699  32.522  1.00 76.91           S  
ATOM  11089  CE  MET F 239     -21.536  83.888  33.592  1.00 75.81           C  
ATOM  11090  N   ALA F 240     -17.110  86.540  28.583  1.00 75.21           N  
ATOM  11091  CA  ALA F 240     -16.010  86.609  27.619  1.00 75.30           C  
ATOM  11092  C   ALA F 240     -15.430  88.018  27.537  1.00 75.64           C  
ATOM  11093  O   ALA F 240     -14.212  88.183  27.473  1.00 75.73           O  
ATOM  11094  CB  ALA F 240     -16.455  86.138  26.247  1.00 75.01           C  
ATOM  11095  N   LYS F 241     -16.296  89.031  27.547  1.00 76.26           N  
ATOM  11096  CA  LYS F 241     -15.837  90.420  27.522  1.00 76.88           C  
ATOM  11097  C   LYS F 241     -15.013  90.742  28.766  1.00 77.59           C  
ATOM  11098  O   LYS F 241     -13.885  91.243  28.663  1.00 77.47           O  
ATOM  11099  CB  LYS F 241     -17.010  91.390  27.393  1.00 76.84           C  
ATOM  11100  CG  LYS F 241     -16.637  92.855  27.602  1.00 76.86           C  
ATOM  11101  CD  LYS F 241     -17.653  93.785  26.955  1.00 77.94           C  
ATOM  11102  CE  LYS F 241     -17.516  95.214  27.475  1.00 78.83           C  
ATOM  11103  NZ  LYS F 241     -18.144  96.236  26.573  1.00 79.10           N  
ATOM  11104  N   GLU F 242     -15.570  90.439  29.933  1.00 78.27           N  
ATOM  11105  CA  GLU F 242     -14.895  90.716  31.205  1.00 79.49           C  
ATOM  11106  C   GLU F 242     -13.497  90.058  31.266  1.00 79.03           C  
ATOM  11107  O   GLU F 242     -12.553  90.630  31.818  1.00 79.23           O  
ATOM  11108  CB  GLU F 242     -15.775  90.254  32.375  1.00 79.62           C  
ATOM  11109  CG  GLU F 242     -15.712  91.130  33.641  1.00 81.05           C  
ATOM  11110  CD  GLU F 242     -17.020  91.082  34.473  1.00 82.02           C  
ATOM  11111  OE1 GLU F 242     -17.817  90.115  34.326  1.00 83.89           O  
ATOM  11112  OE2 GLU F 242     -17.249  92.023  35.282  1.00 85.66           O  
ATOM  11113  N   SER F 243     -13.380  88.873  30.667  1.00 78.79           N  
ATOM  11114  CA  SER F 243     -12.138  88.096  30.638  1.00 78.39           C  
ATOM  11115  C   SER F 243     -11.062  88.756  29.764  1.00 77.91           C  
ATOM  11116  O   SER F 243      -9.911  88.862  30.178  1.00 77.84           O  
ATOM  11117  CB  SER F 243     -12.440  86.666  30.157  1.00 78.61           C  
ATOM  11118  OG  SER F 243     -11.282  85.852  30.048  1.00 79.47           O  
ATOM  11119  N   VAL F 244     -11.428  89.204  28.567  1.00 77.52           N  
ATOM  11120  CA  VAL F 244     -10.517  90.006  27.740  1.00 77.22           C  
ATOM  11121  C   VAL F 244     -10.060  91.292  28.449  1.00 76.93           C  
ATOM  11122  O   VAL F 244      -8.860  91.574  28.484  1.00 77.40           O  
ATOM  11123  CB  VAL F 244     -11.132  90.403  26.382  1.00 77.17           C  
ATOM  11124  CG1 VAL F 244     -10.227  91.389  25.671  1.00 77.25           C  
ATOM  11125  CG2 VAL F 244     -11.358  89.186  25.502  1.00 77.39           C  
ATOM  11126  N   ASN F 245     -10.999  92.056  29.008  1.00 76.50           N  
ATOM  11127  CA  ASN F 245     -10.676  93.280  29.775  1.00 76.34           C  
ATOM  11128  C   ASN F 245      -9.724  93.042  30.948  1.00 76.48           C  
ATOM  11129  O   ASN F 245      -8.895  93.902  31.259  1.00 76.19           O  
ATOM  11130  CB  ASN F 245     -11.948  93.957  30.303  1.00 76.19           C  
ATOM  11131  CG  ASN F 245     -12.582  94.919  29.291  1.00 75.56           C  
ATOM  11132  OD1 ASN F 245     -11.887  95.582  28.519  1.00 74.43           O  
ATOM  11133  ND2 ASN F 245     -13.910  95.014  29.319  1.00 74.06           N  
ATOM  11134  N   ALA F 246      -9.847  91.873  31.579  1.00 76.53           N  
ATOM  11135  CA  ALA F 246      -8.915  91.435  32.626  1.00 76.90           C  
ATOM  11136  C   ALA F 246      -7.420  91.500  32.229  1.00 77.29           C  
ATOM  11137  O   ALA F 246      -6.560  91.682  33.096  1.00 77.46           O  
ATOM  11138  CB  ALA F 246      -9.258  90.028  33.063  1.00 76.61           C  
ATOM  11139  N   ALA F 247      -7.108  91.349  30.937  1.00 77.24           N  
ATOM  11140  CA  ALA F 247      -5.709  91.224  30.503  1.00 77.28           C  
ATOM  11141  C   ALA F 247      -4.882  92.489  30.742  1.00 77.51           C  
ATOM  11142  O   ALA F 247      -3.646  92.429  30.779  1.00 77.77           O  
ATOM  11143  CB  ALA F 247      -5.638  90.822  29.049  1.00 77.29           C  
ATOM  11144  N   PHE F 248      -5.559  93.624  30.907  1.00 77.63           N  
ATOM  11145  CA  PHE F 248      -4.898  94.890  31.206  1.00 77.44           C  
ATOM  11146  C   PHE F 248      -4.939  95.264  32.683  1.00 77.30           C  
ATOM  11147  O   PHE F 248      -4.594  96.390  33.035  1.00 77.21           O  
ATOM  11148  CB  PHE F 248      -5.557  96.019  30.417  1.00 77.71           C  
ATOM  11149  CG  PHE F 248      -5.607  95.784  28.941  1.00 77.83           C  
ATOM  11150  CD1 PHE F 248      -4.460  95.893  28.172  1.00 77.78           C  
ATOM  11151  CD2 PHE F 248      -6.815  95.475  28.313  1.00 78.15           C  
ATOM  11152  CE1 PHE F 248      -4.505  95.688  26.792  1.00 78.39           C  
ATOM  11153  CE2 PHE F 248      -6.870  95.265  26.946  1.00 78.41           C  
ATOM  11154  CZ  PHE F 248      -5.709  95.369  26.178  1.00 78.09           C  
ATOM  11155  N   GLU F 249      -5.359  94.344  33.550  1.00 77.29           N  
ATOM  11156  CA  GLU F 249      -5.551  94.678  34.960  1.00 77.34           C  
ATOM  11157  C   GLU F 249      -4.899  93.716  35.956  1.00 77.07           C  
ATOM  11158  O   GLU F 249      -4.940  93.959  37.163  1.00 77.78           O  
ATOM  11159  CB  GLU F 249      -7.042  94.762  35.275  1.00 77.53           C  
ATOM  11160  CG  GLU F 249      -7.905  95.462  34.210  1.00 78.41           C  
ATOM  11161  CD  GLU F 249      -7.798  96.987  34.198  1.00 80.02           C  
ATOM  11162  OE1 GLU F 249      -7.141  97.574  35.095  1.00 80.82           O  
ATOM  11163  OE2 GLU F 249      -8.401  97.604  33.277  1.00 81.33           O  
ATOM  11164  N   MET F 250      -4.311  92.632  35.463  1.00 76.34           N  
ATOM  11165  CA  MET F 250      -3.700  91.600  36.306  1.00 75.62           C  
ATOM  11166  C   MET F 250      -2.506  91.028  35.577  1.00 73.80           C  
ATOM  11167  O   MET F 250      -2.369  91.192  34.378  1.00 73.28           O  
ATOM  11168  CB  MET F 250      -4.666  90.439  36.523  1.00 75.23           C  
ATOM  11169  CG  MET F 250      -6.020  90.804  37.042  1.00 77.02           C  
ATOM  11170  SD  MET F 250      -7.127  89.373  37.088  1.00 78.70           S  
ATOM  11171  CE  MET F 250      -6.814  88.786  35.441  1.00 81.49           C  
ATOM  11172  N   THR F 251      -1.672  90.297  36.300  1.00 72.87           N  
ATOM  11173  CA  THR F 251      -0.619  89.517  35.669  1.00 71.82           C  
ATOM  11174  C   THR F 251      -1.231  88.357  34.873  1.00 71.96           C  
ATOM  11175  O   THR F 251      -2.367  87.907  35.157  1.00 72.21           O  
ATOM  11176  CB  THR F 251       0.373  88.952  36.693  1.00 71.37           C  
ATOM  11177  OG1 THR F 251      -0.263  87.935  37.473  1.00 70.37           O  
ATOM  11178  CG2 THR F 251       0.929  90.049  37.587  1.00 69.79           C  
ATOM  11179  N   LEU F 252      -0.478  87.870  33.890  1.00 71.59           N  
ATOM  11180  CA  LEU F 252      -0.890  86.705  33.119  1.00 71.84           C  
ATOM  11181  C   LEU F 252      -1.284  85.538  34.028  1.00 72.57           C  
ATOM  11182  O   LEU F 252      -2.325  84.900  33.816  1.00 72.46           O  
ATOM  11183  CB  LEU F 252       0.218  86.264  32.156  1.00 71.98           C  
ATOM  11184  CG  LEU F 252      -0.162  85.109  31.227  1.00 71.81           C  
ATOM  11185  CD1 LEU F 252      -1.434  85.501  30.452  1.00 70.56           C  
ATOM  11186  CD2 LEU F 252       0.980  84.736  30.286  1.00 70.75           C  
ATOM  11187  N   THR F 253      -0.474  85.278  35.052  1.00 73.15           N  
ATOM  11188  CA  THR F 253      -0.787  84.216  35.998  1.00 73.78           C  
ATOM  11189  C   THR F 253      -2.216  84.306  36.525  1.00 74.30           C  
ATOM  11190  O   THR F 253      -2.933  83.299  36.560  1.00 74.78           O  
ATOM  11191  CB  THR F 253       0.172  84.231  37.187  1.00 74.02           C  
ATOM  11192  OG1 THR F 253       1.517  84.061  36.720  1.00 74.90           O  
ATOM  11193  CG2 THR F 253      -0.168  83.120  38.165  1.00 73.63           C  
ATOM  11194  N   GLU F 254      -2.635  85.501  36.938  1.00 74.75           N  
ATOM  11195  CA  GLU F 254      -3.924  85.645  37.611  1.00 74.97           C  
ATOM  11196  C   GLU F 254      -5.054  85.799  36.612  1.00 74.87           C  
ATOM  11197  O   GLU F 254      -6.187  85.443  36.911  1.00 74.96           O  
ATOM  11198  CB  GLU F 254      -3.913  86.816  38.594  1.00 75.15           C  
ATOM  11199  CG  GLU F 254      -2.897  86.687  39.728  1.00 75.72           C  
ATOM  11200  CD  GLU F 254      -3.046  85.413  40.581  1.00 77.67           C  
ATOM  11201  OE1 GLU F 254      -4.187  85.046  40.967  1.00 79.08           O  
ATOM  11202  OE2 GLU F 254      -2.001  84.793  40.899  1.00 78.17           O  
ATOM  11203  N   GLY F 255      -4.744  86.331  35.432  1.00 74.87           N  
ATOM  11204  CA  GLY F 255      -5.700  86.342  34.323  1.00 74.73           C  
ATOM  11205  C   GLY F 255      -6.173  84.942  34.024  1.00 74.77           C  
ATOM  11206  O   GLY F 255      -7.370  84.670  33.999  1.00 74.52           O  
ATOM  11207  N   SER F 256      -5.212  84.043  33.836  1.00 75.03           N  
ATOM  11208  CA  SER F 256      -5.497  82.641  33.582  1.00 75.00           C  
ATOM  11209  C   SER F 256      -6.386  82.034  34.660  1.00 75.15           C  
ATOM  11210  O   SER F 256      -7.339  81.336  34.339  1.00 75.20           O  
ATOM  11211  CB  SER F 256      -4.193  81.856  33.438  1.00 74.87           C  
ATOM  11212  OG  SER F 256      -3.555  82.213  32.222  1.00 75.09           O  
ATOM  11213  N   LYS F 257      -6.086  82.316  35.926  1.00 75.43           N  
ATOM  11214  CA  LYS F 257      -6.939  81.867  37.024  1.00 75.77           C  
ATOM  11215  C   LYS F 257      -8.340  82.465  36.931  1.00 75.80           C  
ATOM  11216  O   LYS F 257      -9.320  81.774  37.194  1.00 75.20           O  
ATOM  11217  CB  LYS F 257      -6.349  82.231  38.388  1.00 76.04           C  
ATOM  11218  CG  LYS F 257      -5.214  81.328  38.890  1.00 77.71           C  
ATOM  11219  CD  LYS F 257      -5.080  81.436  40.424  1.00 79.82           C  
ATOM  11220  CE  LYS F 257      -3.677  81.100  40.910  1.00 81.58           C  
ATOM  11221  NZ  LYS F 257      -2.659  82.134  40.516  1.00 83.19           N  
ATOM  11222  N   LEU F 258      -8.431  83.752  36.591  1.00 76.00           N  
ATOM  11223  CA  LEU F 258      -9.724  84.417  36.533  1.00 76.40           C  
ATOM  11224  C   LEU F 258     -10.554  83.846  35.389  1.00 76.52           C  
ATOM  11225  O   LEU F 258     -11.733  83.542  35.560  1.00 76.15           O  
ATOM  11226  CB  LEU F 258      -9.580  85.935  36.375  1.00 76.43           C  
ATOM  11227  CG  LEU F 258     -10.923  86.662  36.137  1.00 76.52           C  
ATOM  11228  CD1 LEU F 258     -11.898  86.320  37.240  1.00 76.74           C  
ATOM  11229  CD2 LEU F 258     -10.766  88.170  36.031  1.00 76.73           C  
ATOM  11230  N   GLU F 259      -9.912  83.709  34.232  1.00 76.91           N  
ATOM  11231  CA  GLU F 259     -10.517  83.113  33.045  1.00 77.57           C  
ATOM  11232  C   GLU F 259     -11.076  81.733  33.393  1.00 77.24           C  
ATOM  11233  O   GLU F 259     -12.262  81.458  33.157  1.00 76.89           O  
ATOM  11234  CB  GLU F 259      -9.472  83.006  31.914  1.00 77.60           C  
ATOM  11235  CG  GLU F 259     -10.003  82.573  30.542  1.00 78.40           C  
ATOM  11236  CD  GLU F 259      -8.896  82.028  29.616  1.00 79.48           C  
ATOM  11237  OE1 GLU F 259      -8.364  80.917  29.883  1.00 81.50           O  
ATOM  11238  OE2 GLU F 259      -8.564  82.695  28.604  1.00 82.43           O  
ATOM  11239  N   LYS F 260     -10.225  80.880  33.970  1.00 76.69           N  
ATOM  11240  CA  LYS F 260     -10.642  79.541  34.362  1.00 76.64           C  
ATOM  11241  C   LYS F 260     -11.927  79.585  35.180  1.00 76.23           C  
ATOM  11242  O   LYS F 260     -12.843  78.795  34.951  1.00 76.40           O  
ATOM  11243  CB  LYS F 260      -9.563  78.870  35.200  1.00 76.85           C  
ATOM  11244  CG  LYS F 260      -8.366  78.400  34.422  1.00 78.81           C  
ATOM  11245  CD  LYS F 260      -8.531  76.986  33.874  1.00 80.53           C  
ATOM  11246  CE  LYS F 260      -7.188  76.430  33.386  1.00 81.00           C  
ATOM  11247  NZ  LYS F 260      -6.485  77.331  32.417  1.00 80.54           N  
ATOM  11248  N   LYS F 261     -11.976  80.499  36.147  1.00 75.64           N  
ATOM  11249  CA  LYS F 261     -13.107  80.594  37.053  1.00 75.44           C  
ATOM  11250  C   LYS F 261     -14.376  81.005  36.300  1.00 75.05           C  
ATOM  11251  O   LYS F 261     -15.439  80.458  36.549  1.00 74.54           O  
ATOM  11252  CB  LYS F 261     -12.796  81.544  38.215  1.00 75.60           C  
ATOM  11253  CG  LYS F 261     -11.875  80.923  39.276  1.00 75.95           C  
ATOM  11254  CD  LYS F 261     -11.122  81.983  40.072  1.00 77.65           C  
ATOM  11255  CE  LYS F 261      -9.961  81.408  40.907  1.00 79.02           C  
ATOM  11256  NZ  LYS F 261      -8.785  82.379  41.041  1.00 80.13           N  
ATOM  11257  N   LEU F 262     -14.247  81.939  35.361  1.00 74.84           N  
ATOM  11258  CA  LEU F 262     -15.359  82.305  34.474  1.00 74.67           C  
ATOM  11259  C   LEU F 262     -15.726  81.144  33.547  1.00 74.59           C  
ATOM  11260  O   LEU F 262     -16.900  80.855  33.347  1.00 74.26           O  
ATOM  11261  CB  LEU F 262     -15.008  83.544  33.654  1.00 74.27           C  
ATOM  11262  CG  LEU F 262     -14.792  84.813  34.481  1.00 74.26           C  
ATOM  11263  CD1 LEU F 262     -14.173  85.890  33.629  1.00 73.88           C  
ATOM  11264  CD2 LEU F 262     -16.106  85.304  35.093  1.00 74.08           C  
ATOM  11265  N   PHE F 263     -14.709  80.478  33.001  1.00 74.83           N  
ATOM  11266  CA  PHE F 263     -14.892  79.287  32.175  1.00 74.86           C  
ATOM  11267  C   PHE F 263     -15.633  78.191  32.928  1.00 75.33           C  
ATOM  11268  O   PHE F 263     -16.413  77.465  32.327  1.00 75.58           O  
ATOM  11269  CB  PHE F 263     -13.538  78.761  31.680  1.00 74.82           C  
ATOM  11270  CG  PHE F 263     -13.601  77.395  31.042  1.00 74.48           C  
ATOM  11271  CD1 PHE F 263     -14.031  77.246  29.738  1.00 74.62           C  
ATOM  11272  CD2 PHE F 263     -13.217  76.270  31.739  1.00 74.31           C  
ATOM  11273  CE1 PHE F 263     -14.093  75.995  29.143  1.00 74.37           C  
ATOM  11274  CE2 PHE F 263     -13.275  75.021  31.152  1.00 74.62           C  
ATOM  11275  CZ  PHE F 263     -13.715  74.885  29.849  1.00 74.40           C  
ATOM  11276  N   TYR F 264     -15.388  78.067  34.231  1.00 75.66           N  
ATOM  11277  CA  TYR F 264     -16.176  77.154  35.062  1.00 76.10           C  
ATOM  11278  C   TYR F 264     -17.603  77.683  35.267  1.00 75.78           C  
ATOM  11279  O   TYR F 264     -18.556  76.914  35.249  1.00 75.85           O  
ATOM  11280  CB  TYR F 264     -15.498  76.912  36.421  1.00 76.77           C  
ATOM  11281  CG  TYR F 264     -14.127  76.245  36.368  1.00 77.50           C  
ATOM  11282  CD1 TYR F 264     -13.708  75.533  35.244  1.00 78.22           C  
ATOM  11283  CD2 TYR F 264     -13.267  76.293  37.465  1.00 78.23           C  
ATOM  11284  CE1 TYR F 264     -12.470  74.916  35.201  1.00 78.54           C  
ATOM  11285  CE2 TYR F 264     -12.022  75.676  37.433  1.00 78.63           C  
ATOM  11286  CZ  TYR F 264     -11.631  74.986  36.293  1.00 78.75           C  
ATOM  11287  OH  TYR F 264     -10.409  74.364  36.227  1.00 78.54           O  
ATOM  11288  N   SER F 265     -17.743  78.991  35.453  1.00 75.45           N  
ATOM  11289  CA  SER F 265     -19.049  79.621  35.626  1.00 75.61           C  
ATOM  11290  C   SER F 265     -20.021  79.303  34.485  1.00 75.51           C  
ATOM  11291  O   SER F 265     -21.225  79.102  34.719  1.00 74.97           O  
ATOM  11292  CB  SER F 265     -18.906  81.144  35.742  1.00 75.65           C  
ATOM  11293  OG  SER F 265     -18.280  81.509  36.956  1.00 76.42           O  
ATOM  11294  N   THR F 266     -19.502  79.262  33.258  1.00 75.12           N  
ATOM  11295  CA  THR F 266     -20.348  79.013  32.095  1.00 75.03           C  
ATOM  11296  C   THR F 266     -21.154  77.722  32.246  1.00 74.87           C  
ATOM  11297  O   THR F 266     -22.255  77.621  31.721  1.00 74.97           O  
ATOM  11298  CB  THR F 266     -19.536  78.925  30.801  1.00 74.79           C  
ATOM  11299  OG1 THR F 266     -18.597  77.846  30.909  1.00 75.65           O  
ATOM  11300  CG2 THR F 266     -18.808  80.227  30.542  1.00 74.26           C  
ATOM  11301  N   PHE F 267     -20.603  76.751  32.969  1.00 74.72           N  
ATOM  11302  CA  PHE F 267     -21.270  75.469  33.194  1.00 74.83           C  
ATOM  11303  C   PHE F 267     -22.432  75.548  34.189  1.00 74.86           C  
ATOM  11304  O   PHE F 267     -23.163  74.578  34.366  1.00 74.70           O  
ATOM  11305  CB  PHE F 267     -20.256  74.407  33.628  1.00 74.87           C  
ATOM  11306  CG  PHE F 267     -19.311  74.015  32.534  1.00 74.65           C  
ATOM  11307  CD1 PHE F 267     -18.286  74.858  32.159  1.00 74.31           C  
ATOM  11308  CD2 PHE F 267     -19.470  72.822  31.861  1.00 74.85           C  
ATOM  11309  CE1 PHE F 267     -17.427  74.511  31.150  1.00 75.10           C  
ATOM  11310  CE2 PHE F 267     -18.612  72.467  30.844  1.00 74.98           C  
ATOM  11311  CZ  PHE F 267     -17.590  73.314  30.487  1.00 75.23           C  
ATOM  11312  N   ALA F 268     -22.582  76.701  34.837  1.00 74.93           N  
ATOM  11313  CA  ALA F 268     -23.734  76.989  35.669  1.00 74.86           C  
ATOM  11314  C   ALA F 268     -24.904  77.459  34.805  1.00 74.91           C  
ATOM  11315  O   ALA F 268     -26.054  77.418  35.242  1.00 74.50           O  
ATOM  11316  CB  ALA F 268     -23.381  78.052  36.713  1.00 74.67           C  
ATOM  11317  N   THR F 269     -24.612  77.889  33.580  1.00 75.07           N  
ATOM  11318  CA  THR F 269     -25.629  78.487  32.720  1.00 75.57           C  
ATOM  11319  C   THR F 269     -26.253  77.463  31.770  1.00 75.98           C  
ATOM  11320  O   THR F 269     -25.612  76.476  31.399  1.00 76.31           O  
ATOM  11321  CB  THR F 269     -25.049  79.652  31.903  1.00 75.47           C  
ATOM  11322  OG1 THR F 269     -24.250  79.145  30.831  1.00 75.82           O  
ATOM  11323  CG2 THR F 269     -24.202  80.561  32.781  1.00 75.39           C  
ATOM  11324  N   ASP F 270     -27.506  77.712  31.386  1.00 76.33           N  
ATOM  11325  CA  ASP F 270     -28.230  76.863  30.433  1.00 76.73           C  
ATOM  11326  C   ASP F 270     -27.699  77.013  29.011  1.00 76.90           C  
ATOM  11327  O   ASP F 270     -27.620  76.040  28.263  1.00 77.15           O  
ATOM  11328  CB  ASP F 270     -29.731  77.201  30.429  1.00 76.70           C  
ATOM  11329  CG  ASP F 270     -30.391  76.980  31.781  1.00 77.06           C  
ATOM  11330  OD1 ASP F 270     -29.862  76.184  32.590  1.00 77.57           O  
ATOM  11331  OD2 ASP F 270     -31.451  77.601  32.029  1.00 77.83           O  
ATOM  11332  N   ASP F 271     -27.338  78.233  28.637  1.00 77.20           N  
ATOM  11333  CA  ASP F 271     -26.899  78.516  27.275  1.00 77.44           C  
ATOM  11334  C   ASP F 271     -25.615  77.791  26.864  1.00 77.67           C  
ATOM  11335  O   ASP F 271     -25.333  77.671  25.671  1.00 78.14           O  
ATOM  11336  CB  ASP F 271     -26.737  80.024  27.074  1.00 77.51           C  
ATOM  11337  CG  ASP F 271     -28.064  80.733  26.832  1.00 77.62           C  
ATOM  11338  OD1 ASP F 271     -29.128  80.065  26.841  1.00 77.98           O  
ATOM  11339  OD2 ASP F 271     -28.041  81.968  26.627  1.00 77.57           O  
ATOM  11340  N   ARG F 272     -24.839  77.315  27.831  1.00 77.65           N  
ATOM  11341  CA  ARG F 272     -23.673  76.494  27.520  1.00 77.76           C  
ATOM  11342  C   ARG F 272     -24.079  75.022  27.368  1.00 77.95           C  
ATOM  11343  O   ARG F 272     -23.639  74.351  26.440  1.00 77.80           O  
ATOM  11344  CB  ARG F 272     -22.582  76.692  28.580  1.00 77.81           C  
ATOM  11345  CG  ARG F 272     -21.460  75.668  28.553  1.00 77.26           C  
ATOM  11346  CD  ARG F 272     -21.627  74.733  29.713  1.00 77.92           C  
ATOM  11347  NE  ARG F 272     -21.743  73.332  29.328  1.00 78.22           N  
ATOM  11348  CZ  ARG F 272     -22.517  72.442  29.949  1.00 78.97           C  
ATOM  11349  NH1 ARG F 272     -22.538  71.187  29.522  1.00 79.54           N  
ATOM  11350  NH2 ARG F 272     -23.291  72.789  30.981  1.00 79.26           N  
ATOM  11351  N   LYS F 273     -24.917  74.527  28.273  1.00 78.35           N  
ATOM  11352  CA  LYS F 273     -25.510  73.196  28.117  1.00 78.79           C  
ATOM  11353  C   LYS F 273     -26.167  73.097  26.740  1.00 79.08           C  
ATOM  11354  O   LYS F 273     -26.029  72.090  26.039  1.00 79.06           O  
ATOM  11355  CB  LYS F 273     -26.547  72.920  29.221  1.00 78.78           C  
ATOM  11356  CG  LYS F 273     -26.923  71.444  29.398  1.00 79.07           C  
ATOM  11357  CD  LYS F 273     -28.202  71.268  30.233  1.00 78.67           C  
ATOM  11358  N   GLU F 274     -26.860  74.166  26.356  1.00 79.51           N  
ATOM  11359  CA  GLU F 274     -27.582  74.219  25.088  1.00 79.89           C  
ATOM  11360  C   GLU F 274     -26.647  74.358  23.889  1.00 80.04           C  
ATOM  11361  O   GLU F 274     -26.915  73.808  22.817  1.00 79.80           O  
ATOM  11362  CB  GLU F 274     -28.589  75.376  25.117  1.00 79.96           C  
ATOM  11363  CG  GLU F 274     -29.289  75.681  23.793  1.00 80.54           C  
ATOM  11364  CD  GLU F 274     -30.094  74.515  23.242  1.00 81.06           C  
ATOM  11365  OE1 GLU F 274     -30.175  73.455  23.904  1.00 81.49           O  
ATOM  11366  OE2 GLU F 274     -30.654  74.669  22.135  1.00 81.01           O  
ATOM  11367  N   GLY F 275     -25.559  75.103  24.071  1.00 80.46           N  
ATOM  11368  CA  GLY F 275     -24.614  75.370  22.991  1.00 80.71           C  
ATOM  11369  C   GLY F 275     -23.827  74.136  22.598  1.00 80.97           C  
ATOM  11370  O   GLY F 275     -23.632  73.859  21.414  1.00 80.92           O  
ATOM  11371  N   MET F 276     -23.388  73.384  23.601  1.00 81.34           N  
ATOM  11372  CA  MET F 276     -22.586  72.192  23.365  1.00 81.79           C  
ATOM  11373  C   MET F 276     -23.418  71.001  22.895  1.00 81.74           C  
ATOM  11374  O   MET F 276     -22.954  70.227  22.060  1.00 81.80           O  
ATOM  11375  CB  MET F 276     -21.779  71.826  24.615  1.00 81.77           C  
ATOM  11376  CG  MET F 276     -20.582  72.738  24.846  1.00 81.90           C  
ATOM  11377  SD  MET F 276     -19.545  72.163  26.204  1.00 83.09           S  
ATOM  11378  CE  MET F 276     -18.414  73.539  26.400  1.00 81.04           C  
ATOM  11379  N   THR F 277     -24.634  70.843  23.419  1.00 81.86           N  
ATOM  11380  CA  THR F 277     -25.475  69.711  23.017  1.00 81.96           C  
ATOM  11381  C   THR F 277     -26.037  69.911  21.601  1.00 82.09           C  
ATOM  11382  O   THR F 277     -26.306  68.938  20.891  1.00 82.10           O  
ATOM  11383  CB  THR F 277     -26.617  69.432  24.022  1.00 81.98           C  
ATOM  11384  OG1 THR F 277     -27.480  70.569  24.111  1.00 82.21           O  
ATOM  11385  CG2 THR F 277     -26.056  69.103  25.402  1.00 81.69           C  
ATOM  11386  N   ALA F 278     -26.202  71.171  21.196  1.00 82.18           N  
ATOM  11387  CA  ALA F 278     -26.566  71.505  19.815  1.00 82.22           C  
ATOM  11388  C   ALA F 278     -25.441  71.135  18.845  1.00 82.26           C  
ATOM  11389  O   ALA F 278     -25.700  70.726  17.710  1.00 82.37           O  
ATOM  11390  CB  ALA F 278     -26.893  72.988  19.694  1.00 82.11           C  
ATOM  11391  N   PHE F 279     -24.198  71.286  19.290  1.00 82.21           N  
ATOM  11392  CA  PHE F 279     -23.044  70.956  18.461  1.00 82.38           C  
ATOM  11393  C   PHE F 279     -22.935  69.447  18.245  1.00 82.39           C  
ATOM  11394  O   PHE F 279     -22.781  68.992  17.115  1.00 82.38           O  
ATOM  11395  CB  PHE F 279     -21.761  71.493  19.096  1.00 82.48           C  
ATOM  11396  CG  PHE F 279     -20.523  71.229  18.287  1.00 82.48           C  
ATOM  11397  CD1 PHE F 279     -20.075  72.157  17.355  1.00 82.84           C  
ATOM  11398  CD2 PHE F 279     -19.797  70.057  18.468  1.00 82.56           C  
ATOM  11399  CE1 PHE F 279     -18.922  71.922  16.607  1.00 83.10           C  
ATOM  11400  CE2 PHE F 279     -18.645  69.808  17.727  1.00 82.98           C  
ATOM  11401  CZ  PHE F 279     -18.206  70.744  16.794  1.00 83.27           C  
ATOM  11402  N   VAL F 280     -23.023  68.678  19.324  1.00 82.41           N  
ATOM  11403  CA  VAL F 280     -22.903  67.222  19.233  1.00 82.56           C  
ATOM  11404  C   VAL F 280     -24.102  66.594  18.506  1.00 82.59           C  
ATOM  11405  O   VAL F 280     -23.973  65.517  17.925  1.00 82.63           O  
ATOM  11406  CB  VAL F 280     -22.723  66.563  20.624  1.00 82.64           C  
ATOM  11407  CG1 VAL F 280     -22.542  65.049  20.486  1.00 82.57           C  
ATOM  11408  CG2 VAL F 280     -21.527  67.173  21.356  1.00 82.57           C  
ATOM  11409  N   GLU F 281     -25.251  67.266  18.534  1.00 82.63           N  
ATOM  11410  CA  GLU F 281     -26.421  66.840  17.750  1.00 82.63           C  
ATOM  11411  C   GLU F 281     -26.459  67.462  16.342  1.00 82.78           C  
ATOM  11412  O   GLU F 281     -27.439  67.293  15.618  1.00 82.76           O  
ATOM  11413  CB  GLU F 281     -27.718  67.156  18.511  1.00 82.65           C  
ATOM  11414  CG  GLU F 281     -27.896  66.321  19.784  1.00 82.55           C  
ATOM  11415  CD  GLU F 281     -29.184  66.628  20.541  1.00 82.29           C  
ATOM  11416  OE1 GLU F 281     -29.944  67.525  20.118  1.00 81.23           O  
ATOM  11417  OE2 GLU F 281     -29.434  65.964  21.570  1.00 81.63           O  
ATOM  11418  N   LYS F 282     -25.394  68.173  15.964  1.00 83.04           N  
ATOM  11419  CA  LYS F 282     -25.239  68.749  14.617  1.00 83.09           C  
ATOM  11420  C   LYS F 282     -26.433  69.626  14.197  1.00 83.22           C  
ATOM  11421  O   LYS F 282     -27.176  69.274  13.282  1.00 83.08           O  
ATOM  11422  CB  LYS F 282     -24.999  67.631  13.584  1.00 83.06           C  
ATOM  11423  CG  LYS F 282     -23.788  66.751  13.872  1.00 82.65           C  
ATOM  11424  N   ARG F 283     -26.608  70.764  14.868  1.00 83.37           N  
ATOM  11425  CA  ARG F 283     -27.724  71.676  14.565  1.00 83.42           C  
ATOM  11426  C   ARG F 283     -27.497  73.105  15.081  1.00 83.55           C  
ATOM  11427  O   ARG F 283     -26.496  73.378  15.764  1.00 83.77           O  
ATOM  11428  CB  ARG F 283     -29.034  71.115  15.126  1.00 83.35           C  
ATOM  11429  CG  ARG F 283     -29.055  70.876  16.637  1.00 83.37           C  
ATOM  11430  CD  ARG F 283     -30.500  70.808  17.148  1.00 83.40           C  
ATOM  11431  NE  ARG F 283     -30.611  70.436  18.560  1.00 83.35           N  
ATOM  11432  CZ  ARG F 283     -30.358  71.246  19.593  1.00 83.27           C  
ATOM  11433  NH1 ARG F 283     -29.954  72.501  19.402  1.00 82.99           N  
ATOM  11434  NH2 ARG F 283     -30.504  70.790  20.832  1.00 83.03           N  
ATOM  11435  N   LYS F 284     -28.423  74.005  14.736  1.00 83.56           N  
ATOM  11436  CA  LYS F 284     -28.400  75.400  15.198  1.00 83.57           C  
ATOM  11437  C   LYS F 284     -28.960  75.515  16.618  1.00 83.74           C  
ATOM  11438  O   LYS F 284     -29.974  74.892  16.943  1.00 83.79           O  
ATOM  11439  CB  LYS F 284     -29.198  76.302  14.252  1.00 83.38           C  
ATOM  11440  N   ALA F 285     -28.299  76.324  17.449  1.00 83.94           N  
ATOM  11441  CA  ALA F 285     -28.624  76.436  18.877  1.00 84.03           C  
ATOM  11442  C   ALA F 285     -29.558  77.607  19.162  1.00 84.12           C  
ATOM  11443  O   ALA F 285     -29.529  78.619  18.463  1.00 84.07           O  
ATOM  11444  CB  ALA F 285     -27.346  76.577  19.702  1.00 83.83           C  
ATOM  11445  N   ASN F 286     -30.366  77.460  20.210  1.00 84.37           N  
ATOM  11446  CA  ASN F 286     -31.319  78.488  20.625  1.00 84.63           C  
ATOM  11447  C   ASN F 286     -30.967  79.033  22.011  1.00 84.67           C  
ATOM  11448  O   ASN F 286     -31.292  78.421  23.033  1.00 84.72           O  
ATOM  11449  CB  ASN F 286     -32.748  77.919  20.615  1.00 84.66           C  
ATOM  11450  CG  ASN F 286     -33.811  79.001  20.503  1.00 85.06           C  
ATOM  11451  OD1 ASN F 286     -33.503  80.198  20.453  1.00 85.22           O  
ATOM  11452  ND2 ASN F 286     -35.075  78.585  20.453  1.00 85.02           N  
ATOM  11453  N   PHE F 287     -30.299  80.184  22.034  1.00 84.69           N  
ATOM  11454  CA  PHE F 287     -29.841  80.791  23.282  1.00 84.81           C  
ATOM  11455  C   PHE F 287     -30.933  81.658  23.885  1.00 85.00           C  
ATOM  11456  O   PHE F 287     -31.571  82.427  23.171  1.00 85.12           O  
ATOM  11457  CB  PHE F 287     -28.596  81.647  23.044  1.00 84.67           C  
ATOM  11458  CG  PHE F 287     -27.421  80.875  22.507  1.00 84.66           C  
ATOM  11459  CD1 PHE F 287     -26.746  79.958  23.309  1.00 84.89           C  
ATOM  11460  CD2 PHE F 287     -26.981  81.068  21.206  1.00 84.34           C  
ATOM  11461  CE1 PHE F 287     -25.655  79.248  22.816  1.00 84.58           C  
ATOM  11462  CE2 PHE F 287     -25.898  80.360  20.708  1.00 84.54           C  
ATOM  11463  CZ  PHE F 287     -25.231  79.451  21.516  1.00 84.53           C  
ATOM  11464  N   LYS F 288     -31.131  81.532  25.199  1.00 85.30           N  
ATOM  11465  CA  LYS F 288     -32.123  82.321  25.937  1.00 85.55           C  
ATOM  11466  C   LYS F 288     -31.477  83.306  26.932  1.00 85.84           C  
ATOM  11467  O   LYS F 288     -32.138  83.790  27.850  1.00 85.69           O  
ATOM  11468  CB  LYS F 288     -33.097  81.386  26.662  1.00 85.55           C  
ATOM  11469  CG  LYS F 288     -33.919  80.499  25.727  1.00 85.44           C  
ATOM  11470  N   ASP F 289     -30.190  83.603  26.731  1.00 86.37           N  
ATOM  11471  CA  ASP F 289     -29.449  84.596  27.537  1.00 86.72           C  
ATOM  11472  C   ASP F 289     -29.518  84.296  29.030  1.00 86.68           C  
ATOM  11473  O   ASP F 289     -29.791  85.175  29.849  1.00 86.78           O  
ATOM  11474  CB  ASP F 289     -29.956  86.014  27.242  1.00 86.84           C  
ATOM  11475  CG  ASP F 289     -29.859  86.370  25.770  1.00 87.41           C  
ATOM  11476  OD1 ASP F 289     -28.897  85.909  25.113  1.00 88.23           O  
ATOM  11477  OD2 ASP F 289     -30.737  87.110  25.270  1.00 87.43           O  
ATOM  11478  N   GLN F 290     -29.239  83.041  29.363  1.00 86.69           N  
ATOM  11479  CA  GLN F 290     -29.441  82.508  30.706  1.00 86.59           C  
ATOM  11480  C   GLN F 290     -28.522  81.294  30.897  1.00 86.45           C  
ATOM  11481  O   GLN F 290     -27.579  81.130  30.129  1.00 86.11           O  
ATOM  11482  CB  GLN F 290     -30.904  82.098  30.852  1.00 86.53           C  
ATOM  11483  CG  GLN F 290     -31.426  82.074  32.268  1.00 86.72           C  
ATOM  11484  CD  GLN F 290     -32.828  81.508  32.347  1.00 86.97           C  
ATOM  11485  OE1 GLN F 290     -33.441  81.182  31.330  1.00 86.69           O  
ATOM  11486  NE2 GLN F 290     -33.343  81.383  33.561  1.00 87.62           N  
ATOM  11487  OXT GLN F 290     -28.689  80.445  31.780  1.00 86.45           O  
TER   11488      GLN F 290                                                      
END
MOLECULE T0486.pdb
ATOM      1  N   PRO    32     -34.619 118.105  22.201  1.00 36.37           N  
ATOM      2  CA  PRO    32     -33.499 118.122  21.209  1.00 35.38           C  
ATOM      4  CB  PRO    32     -33.430 119.614  20.792  1.00 35.70           C  
ATOM      7  CG  PRO    32     -33.972 120.393  22.069  1.00 36.10           C  
ATOM     10  CD  PRO    32     -34.671 119.355  22.997  1.00 36.93           C  
ATOM     13  C   PRO    32     -32.165 117.592  21.848  1.00 33.74           C  
ATOM     14  O   PRO    32     -31.732 118.103  22.927  1.00 33.85           O  
ATOM     17  N   ARG    33     -31.582 116.543  21.238  1.00 30.52           N  
ATOM     18  CA  ARG    33     -30.447 115.793  21.849  1.00 27.98           C  
ATOM     20  CB  ARG    33     -30.865 114.408  22.341  1.00 28.20           C  
ATOM     23  CG  ARG    33     -31.393 114.428  23.789  1.00 29.12           C  
ATOM     26  CD  ARG    33     -32.244 113.222  24.112  1.00 29.44           C  
ATOM     29  NE  ARG    33     -31.441 112.010  24.221  1.00 34.76           N  
ATOM     31  CZ  ARG    33     -30.684 111.700  25.275  1.00 35.22           C  
ATOM     32  NH1 ARG    33     -30.631 112.499  26.343  1.00 36.88           N  
ATOM     35  NH2 ARG    33     -29.978 110.588  25.259  1.00 32.19           N  
ATOM     38  C   ARG    33     -29.262 115.677  20.906  1.00 25.16           C  
ATOM     39  O   ARG    33     -29.423 115.490  19.701  1.00 24.96           O  
ATOM     41  N   PRO    34     -28.053 115.856  21.441  1.00 22.90           N  
ATOM     42  CA  PRO    34     -26.892 115.796  20.552  1.00 21.60           C  
ATOM     44  CB  PRO    34     -25.813 116.476  21.373  1.00 21.42           C  
ATOM     47  CG  PRO    34     -26.259 116.398  22.777  1.00 21.04           C  
ATOM     50  CD  PRO    34     -27.713 116.344  22.796  1.00 21.80           C  
ATOM     53  C   PRO    34     -26.530 114.359  20.058  1.00 21.60           C  
ATOM     54  O   PRO    34     -25.855 114.222  19.035  1.00 19.72           O  
ATOM     55  N   THR    35     -27.041 113.315  20.739  1.00 21.90           N  
ATOM     56  CA  THR    35     -27.051 111.948  20.185  1.00 23.12           C  
ATOM     58  CB  THR    35     -26.409 110.928  21.125  1.00 22.50           C  
ATOM     60  OG1 THR    35     -27.132 110.918  22.364  1.00 25.34           O  
ATOM     62  CG2 THR    35     -24.919 111.265  21.369  1.00 21.08           C  
ATOM     66  C   THR    35     -28.454 111.425  19.823  1.00 23.98           C  
ATOM     67  O   THR    35     -29.444 111.807  20.428  1.00 23.83           O  
ATOM     69  N   SER    36     -28.514 110.537  18.832  1.00 25.38           N  
ATOM     70  CA  SER    36     -29.722 109.737  18.544  1.00 26.75           C  
ATOM     72  CB  SER    36     -30.314 110.035  17.140  1.00 27.55           C  
ATOM     75  OG  SER    36     -29.338 110.522  16.226  1.00 30.93           O  
ATOM     77  C   SER    36     -29.398 108.260  18.650  1.00 26.57           C  
ATOM     78  O   SER    36     -28.336 107.810  18.248  1.00 27.02           O  
ATOM     80  N   ALA    37     -30.314 107.511  19.238  1.00 26.96           N  
ATOM     81  CA  ALA    37     -30.143 106.081  19.431  1.00 27.11           C  
ATOM     83  CB  ALA    37     -29.956 105.773  20.900  1.00 26.60           C  
ATOM     87  C   ALA    37     -31.372 105.383  18.908  1.00 27.34           C  
ATOM     88  O   ALA    37     -32.470 105.853  19.106  1.00 28.07           O  
ATOM     90  N   ARG    38     -31.190 104.251  18.246  1.00 27.41           N  
ATOM     91  CA  ARG    38     -32.296 103.405  17.847  1.00 27.20           C  
ATOM     93  CB  ARG    38     -32.659 103.679  16.387  1.00 27.68           C  
ATOM     96  CG  ARG    38     -31.555 103.196  15.435  1.00 32.69           C  
ATOM     99  CD  ARG    38     -31.659 103.719  14.024  1.00 41.47           C  
ATOM    102  NE  ARG    38     -30.354 103.705  13.320  1.00 45.71           N  
ATOM    104  CZ  ARG    38     -29.427 104.668  13.420  1.00 50.50           C  
ATOM    105  NH1 ARG    38     -29.618 105.741  14.231  1.00 50.89           N  
ATOM    108  NH2 ARG    38     -28.289 104.552  12.723  1.00 52.00           N  
ATOM    111  C   ARG    38     -31.815 101.967  18.007  1.00 25.56           C  
ATOM    112  O   ARG    38     -30.678 101.662  17.715  1.00 25.50           O  
ATOM    114  N   GLN    39     -32.704 101.090  18.416  1.00 24.27           N  
ATOM    115  CA  GLN    39     -32.419  99.696  18.607  1.00 23.41           C  
ATOM    117  CB  GLN    39     -32.504  99.381  20.098  1.00 22.43           C  
ATOM    120  CG  GLN    39     -32.031  98.004  20.463  1.00 20.76           C  
ATOM    123  CD  GLN    39     -32.101  97.804  21.945  1.00 19.82           C  
ATOM    124  OE1 GLN    39     -31.617  98.641  22.700  1.00 21.67           O  
ATOM    125  NE2 GLN    39     -32.718  96.729  22.382  1.00 18.57           N  
ATOM    128  C   GLN    39     -33.376  98.795  17.807  1.00 23.80           C  
ATOM    129  O   GLN    39     -34.607  98.928  17.836  1.00 22.33           O  
ATOM    131  N   LEU    40     -32.781  97.833  17.122  1.00 24.93           N  
ATOM    132  CA  LEU    40     -33.517  96.918  16.193  1.00 24.93           C  
ATOM    134  CB  LEU    40     -33.638  97.621  14.868  1.00 23.82           C  
ATOM    137  CG  LEU    40     -34.317  97.048  13.632  1.00 25.78           C  
ATOM    139  CD1 LEU    40     -35.754  96.407  13.794  1.00 22.15           C  
ATOM    143  CD2 LEU    40     -34.332  98.285  12.734  1.00 27.38           C  
ATOM    147  C   LEU    40     -32.727  95.579  16.056  1.00 24.92           C  
ATOM    148  O   LEU    40     -31.532  95.556  15.665  1.00 24.12           O  
ATOM    150  N   ASP    41     -33.397  94.485  16.407  1.00 24.46           N  
ATOM    151  CA  ASP    41     -32.832  93.138  16.324  1.00 23.32           C  
ATOM    153  CB  ASP    41     -32.497  92.813  14.881  1.00 23.91           C  
ATOM    156  CG  ASP    41     -33.714  92.826  14.019  1.00 24.72           C  
ATOM    157  OD1 ASP    41     -34.776  92.365  14.493  1.00 26.36           O  
ATOM    158  OD2 ASP    41     -33.611  93.311  12.880  1.00 28.80           O  
ATOM    159  C   ASP    41     -31.614  92.967  17.229  1.00 21.87           C  
ATOM    160  O   ASP    41     -30.626  92.310  16.860  1.00 20.53           O  
ATOM    162  N   GLY    42     -31.746  93.566  18.411  1.00 20.42           N  
ATOM    163  CA  GLY    42     -30.736  93.512  19.459  1.00 20.29           C  
ATOM    166  C   GLY    42     -29.595  94.500  19.363  1.00 19.56           C  
ATOM    167  O   GLY    42     -28.794  94.588  20.317  1.00 18.21           O  
ATOM    169  N   ILE    43     -29.524  95.210  18.216  1.00 18.49           N  
ATOM    170  CA  ILE    43     -28.446  96.171  17.861  1.00 18.12           C  
ATOM    172  CB  ILE    43     -27.947  96.049  16.350  1.00 17.15           C  
ATOM    174  CG1 ILE    43     -27.750  94.566  15.978  1.00 17.41           C  
ATOM    177  CD1 ILE    43     -27.448  94.223  14.517  1.00 10.50           C  
ATOM    181  CG2 ILE    43     -26.679  96.919  16.144  1.00 16.46           C  
ATOM    185  C   ILE    43     -28.914  97.604  18.115  1.00 18.28           C  
ATOM    186  O   ILE    43     -29.876  98.098  17.509  1.00 18.83           O  
ATOM    188  N   ARG    44     -28.217  98.262  19.026  1.00 19.01           N  
ATOM    189  CA  ARG    44     -28.426  99.669  19.350  1.00 18.37           C  
ATOM    191  CB  ARG    44     -28.251  99.867  20.862  1.00 17.76           C  
ATOM    194  CG  ARG    44     -28.759 101.185  21.386  1.00 16.54           C  
ATOM    197  CD  ARG    44     -28.557 101.298  22.871  1.00 13.79           C  
ATOM    200  NE  ARG    44     -29.614 100.601  23.569  1.00 16.47           N  
ATOM    202  CZ  ARG    44     -29.743 100.548  24.895  1.00 14.91           C  
ATOM    203  NH1 ARG    44     -28.873 101.103  25.694  1.00 16.61           N  
ATOM    206  NH2 ARG    44     -30.739  99.908  25.406  1.00 13.62           N  
ATOM    209  C   ARG    44     -27.374 100.471  18.614  1.00 18.83           C  
ATOM    210  O   ARG    44     -26.207 100.233  18.807  1.00 19.07           O  
ATOM    212  N   ASN    45     -27.790 101.381  17.737  1.00 20.00           N  
ATOM    213  CA  ASN    45     -26.902 102.386  17.160  1.00 21.31           C  
ATOM    215  CB  ASN    45     -27.254 102.653  15.690  1.00 22.09           C  
ATOM    218  CG  ASN    45     -26.607 101.671  14.767  1.00 25.78           C  
ATOM    219  OD1 ASN    45     -25.428 101.800  14.420  1.00 29.25           O  
ATOM    220  ND2 ASN    45     -27.368 100.646  14.370  1.00 29.97           N  
ATOM    223  C   ASN    45     -27.097 103.694  17.913  1.00 20.17           C  
ATOM    224  O   ASN    45     -28.210 104.202  17.948  1.00 18.97           O  
ATOM    226  N   ILE    46     -26.014 104.210  18.466  1.00 18.93           N  
ATOM    227  CA  ILE    46     -25.987 105.493  19.103  1.00 19.48           C  
ATOM    229  CB  ILE    46     -25.365 105.470  20.503  1.00 20.23           C  
ATOM    231  CG1 ILE    46     -25.959 104.315  21.334  1.00 18.43           C  
ATOM    234  CD1 ILE    46     -25.395 104.142  22.715  1.00 16.72           C  
ATOM    238  CG2 ILE    46     -25.657 106.813  21.251  1.00 21.84           C  
ATOM    242  C   ILE    46     -25.153 106.373  18.195  1.00 19.86           C  
ATOM    243  O   ILE    46     -24.007 106.093  17.927  1.00 19.65           O  
ATOM    245  N   VAL    47     -25.783 107.396  17.626  1.00 19.12           N  
ATOM    246  CA  VAL    47     -25.130 108.216  16.637  1.00 17.92           C  
ATOM    248  CB  VAL    47     -26.000 108.295  15.342  1.00 18.43           C  
ATOM    250  CG1 VAL    47     -25.252 109.065  14.230  1.00 14.15           C  
ATOM    254  CG2 VAL    47     -26.458 106.884  14.946  1.00 15.51           C  
ATOM    258  C   VAL    47     -24.874 109.613  17.222  1.00 18.23           C  
ATOM    259  O   VAL    47     -25.789 110.245  17.749  1.00 16.54           O  
ATOM    261  N   LEU    48     -23.597 110.026  17.180  1.00 19.26           N  
ATOM    262  CA  LEU    48     -23.140 111.408  17.516  1.00 19.61           C  
ATOM    264  CB  LEU    48     -21.612 111.473  17.583  1.00 19.28           C  
ATOM    267  CG  LEU    48     -20.809 111.031  18.827  1.00 21.00           C  
ATOM    269  CD1 LEU    48     -21.282 109.801  19.431  1.00 21.01           C  
ATOM    273  CD2 LEU    48     -19.254 110.978  18.591  1.00 20.34           C  
ATOM    277  C   LEU    48     -23.683 112.346  16.433  1.00 19.02           C  
ATOM    278  O   LEU    48     -23.265 112.242  15.284  1.00 19.61           O  
ATOM    280  N   SER    49     -24.629 113.228  16.817  1.00 19.00           N  
ATOM    281  CA  SER    49     -25.459 113.967  15.907  1.00 19.54           C  
ATOM    283  CB  SER    49     -26.956 113.575  16.017  1.00 19.42           C  
ATOM    286  OG  SER    49     -27.184 112.207  15.968  1.00 22.18           O  
ATOM    288  C   SER    49     -25.374 115.453  16.188  1.00 19.35           C  
ATOM    289  O   SER    49     -26.415 116.121  16.348  1.00 20.03           O  
ATOM    291  N   ASN    50     -24.167 115.992  16.192  1.00 18.55           N  
ATOM    292  CA  ASN    50     -23.986 117.427  16.208  1.00 18.37           C  
ATOM    294  CB  ASN    50     -23.746 117.909  17.661  1.00 18.55           C  
ATOM    297  CG  ASN    50     -23.854 119.443  17.836  1.00 20.36           C  
ATOM    298  OD1 ASN    50     -24.433 120.176  17.010  1.00 23.36           O  
ATOM    299  ND2 ASN    50     -23.307 119.920  18.928  1.00 20.58           N  
ATOM    302  C   ASN    50     -22.845 117.817  15.253  1.00 17.76           C  
ATOM    303  O   ASN    50     -21.879 118.424  15.685  1.00 16.99           O  
ATOM    305  N   PRO    51     -22.976 117.488  13.948  1.00 17.55           N  
ATOM    306  CA  PRO    51     -21.879 117.662  12.995  1.00 17.89           C  
ATOM    308  CB  PRO    51     -22.410 117.004  11.717  1.00 17.83           C  
ATOM    311  CG  PRO    51     -23.910 117.044  11.828  1.00 17.67           C  
ATOM    314  CD  PRO    51     -24.125 116.811  13.314  1.00 18.65           C  
ATOM    317  C   PRO    51     -21.472 119.109  12.713  1.00 18.99           C  
ATOM    318  O   PRO    51     -20.383 119.318  12.162  1.00 19.27           O  
ATOM    319  N   LYS    52     -22.337 120.078  13.063  1.00 19.59           N  
ATOM    320  CA  LYS    52     -22.065 121.478  12.820  1.00 20.04           C  
ATOM    322  CB  LYS    52     -23.329 122.341  12.836  1.00 20.46           C  
ATOM    325  CG  LYS    52     -24.164 122.187  11.572  1.00 20.43           C  
ATOM    328  CD  LYS    52     -25.365 123.122  11.559  1.00 22.83           C  
ATOM    331  CE  LYS    52     -26.699 122.394  11.494  1.00 24.90           C  
ATOM    334  NZ  LYS    52     -27.829 123.330  11.277  1.00 24.95           N  
ATOM    338  C   LYS    52     -21.061 121.966  13.827  1.00 20.04           C  
ATOM    339  O   LYS    52     -20.398 122.970  13.602  1.00 20.00           O  
ATOM    341  N   LYS    53     -20.927 121.200  14.900  1.00 20.27           N  
ATOM    342  CA  LYS    53     -19.956 121.445  15.930  1.00 20.34           C  
ATOM    344  CB  LYS    53     -20.682 121.670  17.246  1.00 20.68           C  
ATOM    347  CG  LYS    53     -21.847 122.692  17.095  1.00 23.09           C  
ATOM    350  CD  LYS    53     -21.521 124.116  17.491  1.00 27.62           C  
ATOM    353  CE  LYS    53     -21.409 124.209  19.100  1.00 32.41           C  
ATOM    356  NZ  LYS    53     -22.460 123.426  19.934  1.00 31.15           N  
ATOM    360  C   LYS    53     -18.986 120.294  15.993  1.00 19.39           C  
ATOM    361  O   LYS    53     -18.420 120.077  17.023  1.00 18.49           O  
ATOM    363  N   ARG    54     -18.802 119.602  14.853  1.00 19.24           N  
ATOM    364  CA  ARG    54     -17.947 118.407  14.688  1.00 19.47           C  
ATOM    366  CB  ARG    54     -16.491 118.814  14.543  1.00 20.32           C  
ATOM    369  CG  ARG    54     -16.186 119.822  13.489  1.00 20.47           C  
ATOM    372  CD  ARG    54     -14.698 120.096  13.553  1.00 24.75           C  
ATOM    375  NE  ARG    54     -14.290 121.251  12.769  1.00 28.96           N  
ATOM    380  C   ARG    54     -18.064 117.358  15.813  1.00 19.60           C  
ATOM    381  O   ARG    54     -17.084 116.759  16.256  1.00 16.42           O  
ATOM    383  N   ASN    55     -19.290 117.172  16.282  1.00 19.25           N  
ATOM    384  CA  ASN    55     -19.541 116.166  17.282  1.00 18.54           C  
ATOM    386  CB  ASN    55     -19.436 114.785  16.625  1.00 18.50           C  
ATOM    389  CG  ASN    55     -20.554 114.554  15.636  1.00 17.41           C  
ATOM    390  OD1 ASN    55     -21.626 115.015  15.879  1.00 16.53           O  
ATOM    391  ND2 ASN    55     -20.289 113.919  14.511  1.00 15.60           N  
ATOM    394  C   ASN    55     -18.686 116.324  18.525  1.00 17.75           C  
ATOM    395  O   ASN    55     -18.268 115.349  19.146  1.00 16.70           O  
ATOM    397  N   THR    56     -18.423 117.568  18.899  0.50 17.45           N  
ATOM    399  CA  THR    56     -17.523 117.808  20.015  0.50 17.17           C  
ATOM    403  CB  THR    56     -17.134 119.322  20.215  0.50 16.76           C  
ATOM    407  OG1 THR    56     -18.308 120.136  20.261  0.50 15.81           O  
ATOM    411  CG2 THR    56     -16.202 119.812  19.093  0.50 16.14           C  
ATOM    419  C   THR    56     -18.163 117.235  21.281  0.50 17.32           C  
ATOM    421  O   THR    56     -19.389 117.253  21.438  0.50 16.51           O  
ATOM    425  N   LEU    57     -17.299 116.734  22.157  1.00 16.32           N  
ATOM    426  CA  LEU    57     -17.669 116.055  23.328  1.00 17.23           C  
ATOM    428  CB  LEU    57     -16.656 114.936  23.660  1.00 17.89           C  
ATOM    431  CG  LEU    57     -16.646 113.795  22.618  1.00 21.28           C  
ATOM    433  CD1 LEU    57     -15.502 112.788  22.902  1.00 18.00           C  
ATOM    437  CD2 LEU    57     -18.119 113.109  22.438  1.00 18.16           C  
ATOM    441  C   LEU    57     -17.801 117.054  24.455  1.00 16.91           C  
ATOM    442  O   LEU    57     -17.015 117.112  25.387  1.00 15.44           O  
ATOM    444  N   SER    58     -18.876 117.811  24.369  1.00 17.04           N  
ATOM    445  CA  SER    58     -19.218 118.780  25.376  1.00 17.02           C  
ATOM    447  CB  SER    58     -20.214 119.781  24.830  1.00 17.07           C  
ATOM    450  OG  SER    58     -21.405 119.120  24.399  1.00 18.63           O  
ATOM    452  C   SER    58     -19.837 118.015  26.481  1.00 17.85           C  
ATOM    453  O   SER    58     -20.266 116.837  26.284  1.00 19.18           O  
ATOM    455  N   LEU    59     -19.940 118.672  27.640  1.00 18.08           N  
ATOM    456  CA  LEU    59     -20.596 118.079  28.772  1.00 18.91           C  
ATOM    458  CB  LEU    59     -20.722 119.060  29.922  1.00 18.31           C  
ATOM    461  CG  LEU    59     -21.104 118.375  31.206  1.00 19.05           C  
ATOM    463  CD1 LEU    59     -20.058 117.332  31.631  1.00 13.20           C  
ATOM    467  CD2 LEU    59     -21.366 119.435  32.315  1.00 18.29           C  
ATOM    471  C   LEU    59     -21.975 117.511  28.356  1.00 19.34           C  
ATOM    472  O   LEU    59     -22.280 116.379  28.709  1.00 21.50           O  
ATOM    474  N   ALA    60     -22.751 118.247  27.558  1.00 19.33           N  
ATOM    475  CA  ALA    60     -24.113 117.845  27.145  1.00 19.25           C  
ATOM    477  CB  ALA    60     -24.852 119.063  26.474  1.00 17.30           C  
ATOM    481  C   ALA    60     -24.128 116.608  26.197  1.00 19.56           C  
ATOM    482  O   ALA    60     -24.965 115.726  26.338  1.00 20.09           O  
ATOM    484  N   MET    61     -23.207 116.582  25.220  1.00 20.39           N  
ATOM    485  CA  MET    61     -22.937 115.400  24.392  1.00 20.42           C  
ATOM    487  CB  MET    61     -21.851 115.762  23.403  1.00 20.30           C  
ATOM    490  CG  MET    61     -21.441 114.639  22.523  1.00 21.87           C  
ATOM    493  SD  MET    61     -22.682 114.165  21.333  1.00 17.95           S  
ATOM    494  CE  MET    61     -22.252 115.145  19.892  1.00 25.26           C  
ATOM    498  C   MET    61     -22.492 114.161  25.207  1.00 20.67           C  
ATOM    499  O   MET    61     -23.010 113.080  25.036  1.00 21.86           O  
ATOM    501  N   LEU    62     -21.560 114.336  26.128  1.00 19.50           N  
ATOM    502  CA  LEU    62     -21.183 113.264  27.017  1.00 19.05           C  
ATOM    504  CB  LEU    62     -20.032 113.730  27.953  1.00 18.43           C  
ATOM    507  CG  LEU    62     -18.673 113.886  27.303  1.00 16.64           C  
ATOM    509  CD1 LEU    62     -17.752 114.841  28.082  1.00 13.44           C  
ATOM    513  CD2 LEU    62     -18.074 112.458  27.050  1.00 10.71           C  
ATOM    517  C   LEU    62     -22.349 112.696  27.880  1.00 19.89           C  
ATOM    518  O   LEU    62     -22.421 111.472  28.107  1.00 20.69           O  
ATOM    520  N   LYS    63     -23.256 113.540  28.344  1.00 18.86           N  
ATOM    521  CA  LYS    63     -24.368 113.067  29.174  1.00 18.70           C  
ATOM    523  CB  LYS    63     -24.967 114.220  29.983  1.00 19.18           C  
ATOM    526  CG  LYS    63     -23.947 114.768  31.011  1.00 21.85           C  
ATOM    529  CD  LYS    63     -24.591 115.794  31.978  1.00 26.45           C  
ATOM    532  CE  LYS    63     -24.705 117.236  31.381  1.00 28.19           C  
ATOM    535  NZ  LYS    63     -24.745 118.338  32.430  1.00 27.09           N  
ATOM    539  C   LYS    63     -25.449 112.378  28.380  1.00 18.16           C  
ATOM    540  O   LYS    63     -26.060 111.407  28.863  1.00 14.99           O  
ATOM    542  N   SER    64     -25.679 112.890  27.169  1.00 18.16           N  
ATOM    543  CA  SER    64     -26.622 112.285  26.231  1.00 18.71           C  
ATOM    545  CB  SER    64     -26.765 113.206  24.997  1.00 18.48           C  
ATOM    548  OG  SER    64     -27.687 112.789  24.019  1.00 18.11           O  
ATOM    550  C   SER    64     -26.080 110.903  25.867  1.00 19.90           C  
ATOM    551  O   SER    64     -26.825 109.916  25.838  1.00 19.94           O  
ATOM    553  N   LEU    65     -24.766 110.841  25.586  1.00 20.77           N  
ATOM    554  CA  LEU    65     -24.115 109.603  25.140  1.00 20.75           C  
ATOM    556  CB  LEU    65     -22.684 109.865  24.635  1.00 20.13           C  
ATOM    559  CG  LEU    65     -21.825 108.617  24.301  1.00 20.27           C  
ATOM    561  CD1 LEU    65     -22.510 107.847  23.202  1.00 21.28           C  
ATOM    565  CD2 LEU    65     -20.409 109.031  23.868  1.00 19.72           C  
ATOM    569  C   LEU    65     -24.167 108.553  26.251  1.00 20.12           C  
ATOM    570  O   LEU    65     -24.622 107.439  26.031  1.00 20.44           O  
ATOM    572  N   GLN    66     -23.744 108.962  27.445  1.00 20.60           N  
ATOM    573  CA  GLN    66     -23.862 108.189  28.670  1.00 19.61           C  
ATOM    575  CB  GLN    66     -23.515 109.049  29.870  1.00 20.10           C  
ATOM    578  CG  GLN    66     -23.577 108.308  31.264  1.00 20.81           C  
ATOM    581  CD  GLN    66     -22.884 109.093  32.336  1.00 23.04           C  
ATOM    582  OE1 GLN    66     -21.735 108.798  32.653  1.00 29.45           O  
ATOM    583  NE2 GLN    66     -23.513 110.164  32.820  1.00 22.57           N  
ATOM    586  C   GLN    66     -25.235 107.644  28.881  1.00 20.02           C  
ATOM    587  O   GLN    66     -25.390 106.570  29.439  1.00 20.66           O  
ATOM    589  N   SER    67     -26.251 108.388  28.477  1.00 20.55           N  
ATOM    590  CA  SER    67     -27.633 108.053  28.778  1.00 19.80           C  
ATOM    592  CB  SER    67     -28.495 109.304  28.623  1.00 20.36           C  
ATOM    595  OG  SER    67     -29.550 109.291  29.502  1.00 22.20           O  
ATOM    597  C   SER    67     -28.104 106.978  27.819  1.00 19.85           C  
ATOM    598  O   SER    67     -28.780 106.002  28.204  1.00 19.35           O  
ATOM    600  N   ASP    68     -27.755 107.173  26.552  1.00 19.94           N  
ATOM    601  CA  ASP    68     -28.086 106.210  25.516  1.00 19.79           C  
ATOM    603  CB  ASP    68     -27.629 106.746  24.158  1.00 20.43           C  
ATOM    606  CG  ASP    68     -28.456 107.942  23.658  1.00 23.76           C  
ATOM    607  OD1 ASP    68     -29.557 108.215  24.195  1.00 23.98           O  
ATOM    608  OD2 ASP    68     -27.973 108.619  22.722  1.00 28.92           O  
ATOM    609  C   ASP    68     -27.404 104.851  25.801  1.00 19.43           C  
ATOM    610  O   ASP    68     -27.954 103.843  25.545  1.00 18.46           O  
ATOM    612  N   ILE    69     -26.173 104.862  26.312  1.00 19.12           N  
ATOM    613  CA  ILE    69     -25.446 103.638  26.632  1.00 18.47           C  
ATOM    615  CB  ILE    69     -23.958 103.948  26.929  1.00 18.25           C  
ATOM    617  CG1 ILE    69     -23.242 104.395  25.637  1.00 19.17           C  
ATOM    620  CD1 ILE    69     -21.812 104.999  25.889  1.00 15.75           C  
ATOM    624  CG2 ILE    69     -23.235 102.721  27.440  1.00 15.24           C  
ATOM    628  C   ILE    69     -26.089 102.850  27.785  1.00 18.01           C  
ATOM    629  O   ILE    69     -26.329 101.659  27.651  1.00 16.70           O  
ATOM    631  N   LEU    70     -26.426 103.562  28.858  1.00 18.44           N  
ATOM    632  CA  LEU    70     -26.958 102.993  30.087  1.00 18.51           C  
ATOM    634  CB  LEU    70     -26.781 104.008  31.221  1.00 18.02           C  
ATOM    637  CG  LEU    70     -25.282 104.191  31.605  1.00 17.56           C  
ATOM    639  CD1 LEU    70     -25.172 105.045  32.861  1.00 17.10           C  
ATOM    643  CD2 LEU    70     -24.507 102.850  31.759  1.00 16.31           C  
ATOM    647  C   LEU    70     -28.402 102.570  30.034  1.00 18.99           C  
ATOM    648  O   LEU    70     -28.889 101.779  30.891  1.00 19.34           O  
ATOM    650  N   HIS    71     -29.119 103.103  29.061  1.00 19.25           N  
ATOM    651  CA  HIS    71     -30.548 102.931  29.018  1.00 19.59           C  
ATOM    653  CB  HIS    71     -31.131 103.739  27.866  1.00 19.71           C  
ATOM    656  CG  HIS    71     -32.594 103.546  27.715  1.00 19.32           C  
ATOM    657  ND1 HIS    71     -33.145 102.695  26.782  1.00 19.54           N  
ATOM    659  CE1 HIS    71     -34.464 102.709  26.910  1.00 20.43           C  
ATOM    661  NE2 HIS    71     -34.779 103.515  27.909  1.00 19.47           N  
ATOM    663  CD2 HIS    71     -33.628 104.049  28.430  1.00 20.71           C  
ATOM    665  C   HIS    71     -30.896 101.469  28.799  1.00 20.07           C  
ATOM    666  O   HIS    71     -30.428 100.917  27.828  1.00 18.82           O  
ATOM    668  N   ASP    72     -31.700 100.854  29.682  1.00 21.27           N  
ATOM    669  CA  ASP    72     -32.105  99.434  29.518  1.00 22.29           C  
ATOM    671  CB  ASP    72     -32.970  99.278  28.269  1.00 23.59           C  
ATOM    674  CG  ASP    72     -34.388  99.232  28.573  1.00 25.09           C  
ATOM    675  OD1 ASP    72     -34.945 100.303  28.881  1.00 30.24           O  
ATOM    676  OD2 ASP    72     -34.935  98.108  28.543  1.00 29.83           O  
ATOM    677  C   ASP    72     -30.928  98.486  29.323  1.00 22.15           C  
ATOM    678  O   ASP    72     -31.034  97.497  28.625  1.00 23.16           O  
ATOM    680  N   ALA    73     -29.809  98.782  29.945  1.00 21.79           N  
ATOM    681  CA  ALA    73     -28.591  98.081  29.685  1.00 21.44           C  
ATOM    683  CB  ALA    73     -27.431  98.783  30.436  1.00 20.97           C  
ATOM    687  C   ALA    73     -28.700  96.590  30.095  1.00 21.85           C  
ATOM    688  O   ALA    73     -27.919  95.788  29.623  1.00 20.76           O  
ATOM    690  N   ASP    74     -29.630  96.237  30.997  1.00 22.22           N  
ATOM    691  CA  ASP    74     -29.750  94.857  31.470  1.00 23.54           C  
ATOM    693  CB  ASP    74     -29.886  94.810  32.985  1.00 23.82           C  
ATOM    696  CG  ASP    74     -28.784  95.618  33.696  1.00 28.77           C  
ATOM    697  OD1 ASP    74     -29.186  96.333  34.670  1.00 34.27           O  
ATOM    698  OD2 ASP    74     -27.556  95.561  33.294  1.00 29.12           O  
ATOM    699  C   ASP    74     -30.896  94.104  30.793  1.00 23.04           C  
ATOM    700  O   ASP    74     -31.244  92.988  31.192  1.00 22.85           O  
ATOM    702  N   SER    75     -31.474  94.734  29.777  1.00 22.85           N  
ATOM    703  CA  SER    75     -32.544  94.139  29.053  1.00 22.91           C  
ATOM    705  CB  SER    75     -33.246  95.169  28.172  1.00 23.24           C  
ATOM    708  OG  SER    75     -34.064  94.523  27.198  1.00 22.89           O  
ATOM    710  C   SER    75     -31.965  93.071  28.176  1.00 22.93           C  
ATOM    711  O   SER    75     -30.951  93.307  27.505  1.00 22.07           O  
ATOM    713  N   ASN    76     -32.664  91.933  28.118  1.00 22.63           N  
ATOM    714  CA  ASN    76     -32.244  90.843  27.259  1.00 22.95           C  
ATOM    716  CB  ASN    76     -32.966  89.545  27.612  1.00 24.11           C  
ATOM    719  CG  ASN    76     -32.336  88.850  28.783  1.00 26.98           C  
ATOM    720  OD1 ASN    76     -31.113  88.563  28.782  1.00 33.45           O  
ATOM    721  ND2 ASN    76     -33.158  88.541  29.789  1.00 30.14           N  
ATOM    724  C   ASN    76     -32.413  91.104  25.793  1.00 21.54           C  
ATOM    725  O   ASN    76     -31.859  90.375  25.007  1.00 21.30           O  
ATOM    727  N   ASP    77     -33.184  92.111  25.418  1.00 20.44           N  
ATOM    728  CA  ASP    77     -33.321  92.434  24.029  1.00 20.82           C  
ATOM    730  CB  ASP    77     -34.588  93.263  23.761  1.00 21.94           C  
ATOM    733  CG  ASP    77     -35.898  92.516  24.107  1.00 26.35           C  
ATOM    734  OD1 ASP    77     -35.962  91.239  24.040  1.00 30.79           O  
ATOM    735  OD2 ASP    77     -36.896  93.238  24.439  1.00 32.58           O  
ATOM    736  C   ASP    77     -32.091  93.168  23.480  1.00 19.61           C  
ATOM    737  O   ASP    77     -31.919  93.204  22.283  1.00 19.66           O  
ATOM    739  N   LEU    78     -31.251  93.749  24.344  1.00 18.80           N  
ATOM    740  CA  LEU    78     -30.023  94.404  23.932  1.00 17.27           C  
ATOM    742  CB  LEU    78     -29.623  95.472  24.947  1.00 16.54           C  
ATOM    745  CG  LEU    78     -28.321  96.230  24.692  1.00 13.70           C  
ATOM    747  CD1 LEU    78     -28.422  97.110  23.477  1.00  8.97           C  
ATOM    751  CD2 LEU    78     -27.875  97.031  25.932  1.00 13.55           C  
ATOM    755  C   LEU    78     -28.910  93.397  23.812  1.00 17.24           C  
ATOM    756  O   LEU    78     -28.530  92.762  24.795  1.00 17.67           O  
ATOM    758  N   LYS    79     -28.312  93.302  22.622  1.00 16.68           N  
ATOM    759  CA  LYS    79     -27.199  92.370  22.384  1.00 15.82           C  
ATOM    761  CB  LYS    79     -27.528  91.369  21.270  1.00 15.73           C  
ATOM    764  CG  LYS    79     -28.877  90.676  21.388  1.00 16.59           C  
ATOM    767  CD  LYS    79     -28.974  89.712  22.499  1.00 18.06           C  
ATOM    770  CE  LYS    79     -30.109  88.683  22.212  1.00 18.62           C  
ATOM    773  NZ  LYS    79     -31.314  89.066  22.909  1.00 17.95           N  
ATOM    777  C   LYS    79     -25.857  93.002  22.030  1.00 15.41           C  
ATOM    778  O   LYS    79     -24.845  92.355  22.179  1.00 15.62           O  
ATOM    780  N   VAL    80     -25.854  94.222  21.505  1.00 15.50           N  
ATOM    781  CA  VAL    80     -24.634  94.872  21.046  1.00 15.60           C  
ATOM    783  CB  VAL    80     -24.067  94.182  19.722  1.00 16.76           C  
ATOM    785  CG1 VAL    80     -25.070  94.308  18.564  1.00 13.79           C  
ATOM    789  CG2 VAL    80     -22.644  94.724  19.295  1.00 12.47           C  
ATOM    793  C   VAL    80     -24.910  96.353  20.822  1.00 16.02           C  
ATOM    794  O   VAL    80     -26.008  96.732  20.471  1.00 16.93           O  
ATOM    796  N   ILE    81     -23.877  97.178  20.990  1.00 16.52           N  
ATOM    797  CA  ILE    81     -23.916  98.629  20.694  1.00 15.56           C  
ATOM    799  CB  ILE    81     -23.690  99.507  21.943  1.00 15.15           C  
ATOM    801  CG1 ILE    81     -24.768  99.260  23.001  1.00 14.39           C  
ATOM    804  CD1 ILE    81     -24.524  99.793  24.350  1.00 11.87           C  
ATOM    808  CG2 ILE    81     -23.720 100.927  21.527  1.00 15.92           C  
ATOM    812  C   ILE    81     -22.909  99.028  19.600  1.00 15.42           C  
ATOM    813  O   ILE    81     -21.760  98.607  19.626  1.00 15.24           O  
ATOM    815  N   ILE    82     -23.363  99.853  18.649  1.00 14.63           N  
ATOM    816  CA  ILE    82     -22.498 100.522  17.680  1.00 14.36           C  
ATOM    818  CB  ILE    82     -22.980 100.304  16.200  1.00 15.79           C  
ATOM    820  CG1 ILE    82     -23.053  98.806  15.843  1.00 15.81           C  
ATOM    823  CD1 ILE    82     -23.912  98.475  14.628  1.00 16.96           C  
ATOM    827  CG2 ILE    82     -22.056 101.060  15.234  1.00 14.37           C  
ATOM    831  C   ILE    82     -22.516 102.016  17.977  1.00 14.01           C  
ATOM    832  O   ILE    82     -23.555 102.590  18.029  1.00 12.00           O  
ATOM    834  N   ILE    83     -21.361 102.641  18.257  1.00 15.53           N  
ATOM    835  CA  ILE    83     -21.295 104.105  18.325  1.00 15.80           C  
ATOM    837  CB  ILE    83     -20.506 104.634  19.502  1.00 17.01           C  
ATOM    839  CG1 ILE    83     -21.069 104.097  20.819  1.00 17.25           C  
ATOM    842  CD1 ILE    83     -20.076 104.162  22.048  1.00 18.56           C  
ATOM    846  CG2 ILE    83     -20.575 106.163  19.466  1.00 18.42           C  
ATOM    850  C   ILE    83     -20.693 104.607  17.020  1.00 16.12           C  
ATOM    851  O   ILE    83     -19.551 104.235  16.717  1.00 16.77           O  
ATOM    853  N   SER    84     -21.494 105.381  16.241  1.00 15.80           N  
ATOM    854  CA  SER    84     -21.076 106.080  15.032  1.00 16.15           C  
ATOM    856  CB  SER    84     -21.795 105.512  13.784  1.00 16.26           C  
ATOM    859  OG  SER    84     -23.117 105.324  14.014  1.00 13.91           O  
ATOM    861  C   SER    84     -21.340 107.580  15.115  1.00 16.70           C  
ATOM    862  O   SER    84     -21.732 108.078  16.160  1.00 13.67           O  
ATOM    864  N   ALA    85     -21.143 108.292  13.990  1.00 17.33           N  
ATOM    865  CA  ALA    85     -21.328 109.742  13.980  1.00 18.13           C  
ATOM    867  CB  ALA    85     -20.003 110.477  14.422  1.00 16.26           C  
ATOM    871  C   ALA    85     -21.818 110.265  12.627  1.00 18.58           C  
ATOM    872  O   ALA    85     -21.481 109.703  11.609  1.00 18.18           O  
ATOM    874  N   GLU    86     -22.588 111.367  12.663  1.00 19.55           N  
ATOM    875  CA  GLU    86     -23.096 112.098  11.481  1.00 20.31           C  
ATOM    877  CB  GLU    86     -24.170 113.112  11.933  1.00 21.00           C  
ATOM    880  CG  GLU    86     -25.599 113.067  11.409  1.00 23.95           C  
ATOM    883  CD  GLU    86     -26.391 114.364  11.807  1.00 28.72           C  
ATOM    884  OE1 GLU    86     -26.253 114.814  12.977  1.00 31.93           O  
ATOM    885  OE2 GLU    86     -27.118 114.972  10.952  1.00 31.70           O  
ATOM    886  C   GLU    86     -21.929 112.919  10.916  1.00 19.87           C  
ATOM    887  O   GLU    86     -21.230 113.606  11.651  1.00 18.05           O  
ATOM    889  N   GLY    87     -21.712 112.845   9.619  1.00 19.92           N  
ATOM    890  CA  GLY    87     -20.790 113.770   8.983  1.00 20.95           C  
ATOM    893  C   GLY    87     -19.335 113.339   9.028  1.00 21.41           C  
ATOM    894  O   GLY    87     -19.021 112.263   9.522  1.00 22.86           O  
ATOM    896  N   PRO    88     -18.435 114.181   8.506  1.00 21.29           N  
ATOM    897  CA  PRO    88     -17.064 113.774   8.110  1.00 20.91           C  
ATOM    899  CB  PRO    88     -16.718 114.801   7.035  1.00 20.21           C  
ATOM    902  CG  PRO    88     -17.484 116.017   7.442  1.00 20.92           C  
ATOM    905  CD  PRO    88     -18.780 115.518   7.976  1.00 20.77           C  
ATOM    908  C   PRO    88     -15.973 113.805   9.177  1.00 20.24           C  
ATOM    909  O   PRO    88     -14.824 113.450   8.903  1.00 19.80           O  
ATOM    910  N   VAL    89     -16.345 114.315  10.343  1.00 20.65           N  
ATOM    911  CA  VAL    89     -15.578 114.291  11.576  1.00 18.88           C  
ATOM    913  CB  VAL    89     -15.432 115.702  12.208  1.00 18.80           C  
ATOM    915  CG1 VAL    89     -14.743 115.625  13.537  1.00 16.50           C  
ATOM    919  CG2 VAL    89     -14.658 116.670  11.253  1.00 13.64           C  
ATOM    923  C   VAL    89     -16.376 113.390  12.498  1.00 20.43           C  
ATOM    924  O   VAL    89     -17.589 113.534  12.580  1.00 21.91           O  
ATOM    926  N   PHE    90     -15.695 112.468  13.184  1.00 19.72           N  
ATOM    927  CA  PHE    90     -16.301 111.531  14.041  1.00 19.43           C  
ATOM    929  CB  PHE    90     -15.414 110.245  14.121  1.00 19.48           C  
ATOM    932  CG  PHE    90     -15.877 109.287  15.158  1.00 20.01           C  
ATOM    933  CD1 PHE    90     -16.872 108.362  14.868  1.00 17.39           C  
ATOM    935  CE1 PHE    90     -17.370 107.504  15.841  1.00 18.93           C  
ATOM    937  CZ  PHE    90     -16.911 107.558  17.103  1.00 16.39           C  
ATOM    939  CE2 PHE    90     -15.896 108.507  17.428  1.00 18.94           C  
ATOM    941  CD2 PHE    90     -15.408 109.370  16.462  1.00 16.60           C  
ATOM    943  C   PHE    90     -16.550 112.239  15.403  1.00 21.11           C  
ATOM    944  O   PHE    90     -17.689 112.292  15.908  1.00 22.10           O  
ATOM    946  N   SER    91     -15.482 112.766  15.998  1.00 20.30           N  
ATOM    947  CA  SER    91     -15.576 113.800  17.007  1.00 20.57           C  
ATOM    949  CB  SER    91     -15.752 113.196  18.379  1.00 20.84           C  
ATOM    952  OG  SER    91     -15.846 114.234  19.320  1.00 22.57           O  
ATOM    954  C   SER    91     -14.248 114.511  17.033  1.00 21.11           C  
ATOM    955  O   SER    91     -13.221 113.881  16.841  1.00 21.08           O  
ATOM    957  N   SER    92     -14.277 115.783  17.401  1.00 21.15           N  
ATOM    958  CA  SER    92     -13.105 116.632  17.515  1.00 21.23           C  
ATOM    960  CB  SER    92     -13.489 118.059  17.139  1.00 20.94           C  
ATOM    963  OG  SER    92     -14.589 118.564  17.943  1.00 21.78           O  
ATOM    965  C   SER    92     -12.575 116.624  18.946  1.00 21.25           C  
ATOM    966  O   SER    92     -11.535 117.223  19.235  1.00 22.40           O  
ATOM    968  N   GLY    93     -13.301 115.985  19.841  1.00 20.58           N  
ATOM    969  CA  GLY    93     -12.948 115.936  21.260  1.00 19.95           C  
ATOM    972  C   GLY    93     -13.750 116.972  22.009  1.00 19.47           C  
ATOM    973  O   GLY    93     -14.794 117.442  21.566  1.00 20.34           O  
ATOM    975  N   HIS    94     -13.252 117.343  23.149  1.00 19.02           N  
ATOM    976  CA  HIS    94     -13.913 118.258  24.010  1.00 18.65           C  
ATOM    978  CB  HIS    94     -13.212 118.340  25.388  1.00 18.04           C  
ATOM    981  CG  HIS    94     -13.222 117.059  26.144  1.00 17.83           C  
ATOM    982  ND1 HIS    94     -14.362 116.316  26.320  1.00 19.55           N  
ATOM    984  CE1 HIS    94     -14.074 115.230  27.024  1.00 19.25           C  
ATOM    986  NE2 HIS    94     -12.801 115.280  27.377  1.00 19.12           N  
ATOM    988  CD2 HIS    94     -12.241 116.403  26.821  1.00 20.68           C  
ATOM    990  C   HIS    94     -13.972 119.647  23.426  1.00 18.42           C  
ATOM    991  O   HIS    94     -13.158 120.042  22.633  1.00 17.03           O  
ATOM    993  N   ASP    95     -15.017 120.360  23.847  1.00 19.61           N  
ATOM    994  CA  ASP    95     -15.202 121.784  23.545  1.00 19.31           C  
ATOM    996  CB  ASP    95     -16.648 122.164  23.827  1.00 19.16           C  
ATOM    999  CG  ASP    95     -17.011 123.572  23.311  1.00 21.32           C  
ATOM   1000  OD1 ASP    95     -16.166 124.344  22.761  1.00 22.64           O  
ATOM   1001  OD2 ASP    95     -18.190 123.904  23.461  1.00 24.08           O  
ATOM   1002  C   ASP    95     -14.290 122.653  24.378  1.00 18.37           C  
ATOM   1003  O   ASP    95     -14.398 122.688  25.598  1.00 18.35           O  
ATOM   1005  N   LEU    96     -13.401 123.378  23.732  1.00 18.38           N  
ATOM   1006  CA  LEU    96     -12.454 124.159  24.476  1.00 18.46           C  
ATOM   1008  CB  LEU    96     -11.342 124.659  23.572  1.00 18.82           C  
ATOM   1011  CG  LEU    96     -10.536 123.507  22.924  1.00 20.57           C  
ATOM   1013  CD1 LEU    96      -9.523 124.069  21.931  1.00 18.98           C  
ATOM   1017  CD2 LEU    96      -9.895 122.528  23.976  1.00 16.21           C  
ATOM   1021  C   LEU    96     -13.061 125.301  25.247  1.00 18.43           C  
ATOM   1022  O   LEU    96     -12.463 125.725  26.223  1.00 19.95           O  
ATOM   1024  N   LYS    97     -14.238 125.786  24.858  1.00 17.91           N  
ATOM   1025  CA  LYS    97     -14.921 126.857  25.603  1.00 18.00           C  
ATOM   1027  CB  LYS    97     -16.187 127.275  24.892  1.00 18.56           C  
ATOM   1030  CG  LYS    97     -15.959 127.874  23.482  1.00 19.92           C  
ATOM   1033  CD  LYS    97     -17.219 128.444  22.945  1.00 25.08           C  
ATOM   1036  CE  LYS    97     -17.489 127.989  21.508  1.00 27.41           C  
ATOM   1039  NZ  LYS    97     -17.434 126.508  21.314  1.00 24.52           N  
ATOM   1043  C   LYS    97     -15.276 126.479  27.029  1.00 18.48           C  
ATOM   1044  O   LYS    97     -15.389 127.335  27.890  1.00 17.64           O  
ATOM   1046  N   GLU    98     -15.406 125.165  27.260  1.00 19.13           N  
ATOM   1047  CA  GLU    98     -15.696 124.570  28.531  1.00 18.89           C  
ATOM   1049  CB  GLU    98     -16.448 123.268  28.308  1.00 20.08           C  
ATOM   1052  CG  GLU    98     -17.862 123.418  27.722  1.00 20.54           C  
ATOM   1055  CD  GLU    98     -18.743 122.139  27.922  1.00 21.91           C  
ATOM   1056  OE1 GLU    98     -18.271 121.035  27.670  1.00 21.23           O  
ATOM   1057  OE2 GLU    98     -19.924 122.226  28.330  1.00 28.69           O  
ATOM   1059  O   GLU    98     -14.760 124.443  30.541  1.00 10.39           O  
ATOM   1061  N   LEU    99     -13.540 124.717  29.023  1.00 13.44           N  
ATOM   1062  CA  LEU    99     -12.160 124.599  29.448  1.00 14.57           C  
ATOM   1064  CB  LEU    99     -11.425 123.586  28.556  1.00 13.88           C  
ATOM   1067  CG  LEU    99     -12.151 122.212  28.425  1.00 14.81           C  
ATOM   1069  CD1 LEU    99     -11.306 121.277  27.604  1.00 11.91           C  
ATOM   1073  CD2 LEU    99     -12.636 121.513  29.804  1.00 11.10           C  
ATOM   1077  C   LEU    99     -11.334 125.898  29.709  1.00 14.60           C  
ATOM   1078  O   LEU    99     -10.171 125.850  30.155  1.00 15.08           O  
ATOM   1080  N   THR   100     -11.960 127.042  29.512  1.00 14.98           N  
ATOM   1081  CA  THR   100     -11.367 128.347  29.722  1.00 14.61           C  
ATOM   1083  CB  THR   100     -12.111 129.442  28.938  1.00 14.62           C  
ATOM   1085  OG1 THR   100     -13.460 129.486  29.403  1.00 16.09           O  
ATOM   1087  CG2 THR   100     -12.108 129.222  27.413  1.00 12.66           C  
ATOM   1091  C   THR   100     -11.446 128.616  31.225  1.00 15.75           C  
ATOM   1092  O   THR   100     -12.296 128.057  31.918  1.00 15.40           O  
ATOM   1094  N   GLU   101     -10.519 129.422  31.723  1.00 16.75           N  
ATOM   1095  CA  GLU   101     -10.300 129.624  33.158  1.00 18.54           C  
ATOM   1097  CB  GLU   101      -9.309 130.784  33.353  1.00 18.95           C  
ATOM   1100  CG  GLU   101      -9.001 131.077  34.834  1.00 22.65           C  
ATOM   1103  CD  GLU   101      -8.032 132.231  35.060  1.00 29.16           C  
ATOM   1104  OE1 GLU   101      -7.267 132.606  34.119  1.00 32.26           O  
ATOM   1105  OE2 GLU   101      -8.025 132.771  36.207  1.00 34.97           O  
ATOM   1106  C   GLU   101     -11.574 129.957  33.914  1.00 18.85           C  
ATOM   1107  O   GLU   101     -11.785 129.513  35.024  1.00 19.24           O  
ATOM   1109  N   GLU   102     -12.376 130.809  33.295  1.00 19.48           N  
ATOM   1110  CA  GLU   102     -13.613 131.343  33.814  1.00 20.28           C  
ATOM   1112  CB  GLU   102     -14.160 132.354  32.785  1.00 21.28           C  
ATOM   1115  CG  GLU   102     -14.209 131.851  31.283  1.00 24.17           C  
ATOM   1118  CD  GLU   102     -13.063 132.402  30.307  1.00 29.37           C  
ATOM   1119  OE1 GLU   102     -11.828 132.567  30.753  1.00 25.64           O  
ATOM   1120  OE2 GLU   102     -13.436 132.634  29.075  1.00 28.75           O  
ATOM   1121  C   GLU   102     -14.688 130.295  34.206  1.00 20.36           C  
ATOM   1122  O   GLU   102     -15.533 130.559  35.055  1.00 20.79           O  
ATOM   1124  N   GLN   103     -14.620 129.103  33.632  1.00 19.97           N  
ATOM   1125  CA  GLN   103     -15.564 128.054  33.929  1.00 19.27           C  
ATOM   1127  CB  GLN   103     -15.493 126.951  32.879  1.00 18.37           C  
ATOM   1130  CG  GLN   103     -15.787 127.389  31.400  1.00 17.59           C  
ATOM   1133  CD  GLN   103     -17.184 127.918  31.150  1.00 15.51           C  
ATOM   1134  OE1 GLN   103     -17.995 128.061  32.091  1.00 11.69           O  
ATOM   1135  NE2 GLN   103     -17.483 128.225  29.851  1.00 10.46           N  
ATOM   1138  C   GLN   103     -15.307 127.493  35.302  1.00 18.92           C  
ATOM   1139  O   GLN   103     -16.216 126.940  35.921  1.00 19.77           O  
ATOM   1141  N   GLY   104     -14.085 127.649  35.783  1.00 18.10           N  
ATOM   1142  CA  GLY   104     -13.692 127.120  37.064  1.00 17.66           C  
ATOM   1145  C   GLY   104     -13.260 125.673  36.935  1.00 17.90           C  
ATOM   1146  O   GLY   104     -13.673 124.953  36.033  1.00 18.12           O  
ATOM   1148  N   ARG   105     -12.419 125.268  37.862  1.00 17.60           N  
ATOM   1149  CA  ARG   105     -11.850 123.943  37.905  1.00 18.31           C  
ATOM   1151  CB  ARG   105     -10.785 123.846  39.046  1.00 18.56           C  
ATOM   1154  CG  ARG   105      -9.597 124.622  38.911  1.00 18.52           C  
ATOM   1157  CD  ARG   105      -8.680 124.452  40.161  1.00 20.52           C  
ATOM   1160  NE  ARG   105      -8.054 123.166  40.123  1.00 18.48           N  
ATOM   1162  CZ  ARG   105      -6.790 122.867  39.821  1.00 13.75           C  
ATOM   1163  NH1 ARG   105      -5.866 123.743  39.483  1.00 11.33           N  
ATOM   1166  NH2 ARG   105      -6.464 121.606  39.843  1.00 12.71           N  
ATOM   1169  C   ARG   105     -12.866 122.841  38.195  1.00 17.38           C  
ATOM   1170  O   ARG   105     -12.644 121.738  37.811  1.00 17.17           O  
ATOM   1172  N   ASP   106     -13.894 123.121  38.980  1.00 16.80           N  
ATOM   1173  CA  ASP   106     -14.987 122.176  39.203  1.00 18.17           C  
ATOM   1175  CB  ASP   106     -16.037 122.801  40.117  1.00 19.03           C  
ATOM   1178  CG  ASP   106     -15.648 122.794  41.617  1.00 20.77           C  
ATOM   1179  OD1 ASP   106     -14.523 122.405  41.987  1.00 21.59           O  
ATOM   1180  OD2 ASP   106     -16.528 123.183  42.427  1.00 26.31           O  
ATOM   1181  C   ASP   106     -15.662 121.754  37.891  1.00 17.79           C  
ATOM   1182  O   ASP   106     -15.933 120.560  37.654  1.00 18.16           O  
ATOM   1184  N   TYR   107     -15.946 122.741  37.052  1.00 17.38           N  
ATOM   1185  CA  TYR   107     -16.546 122.486  35.733  1.00 17.07           C  
ATOM   1187  CB  TYR   107     -16.974 123.803  35.059  1.00 16.22           C  
ATOM   1190  CG  TYR   107     -17.938 123.593  33.901  1.00 17.26           C  
ATOM   1191  CD1 TYR   107     -19.301 123.391  34.120  1.00 18.97           C  
ATOM   1193  CE1 TYR   107     -20.171 123.222  33.089  1.00 16.44           C  
ATOM   1195  CZ  TYR   107     -19.689 123.179  31.795  1.00 16.92           C  
ATOM   1196  OH  TYR   107     -20.553 123.019  30.702  1.00 19.19           O  
ATOM   1198  CE2 TYR   107     -18.369 123.359  31.567  1.00 16.10           C  
ATOM   1200  CD2 TYR   107     -17.500 123.582  32.593  1.00 14.19           C  
ATOM   1202  C   TYR   107     -15.582 121.705  34.854  1.00 16.43           C  
ATOM   1203  O   TYR   107     -15.959 120.768  34.215  1.00 15.44           O  
ATOM   1205  N   HIS   108     -14.322 122.108  34.838  1.00 16.53           N  
ATOM   1206  CA  HIS   108     -13.307 121.377  34.111  1.00 15.88           C  
ATOM   1208  CB  HIS   108     -11.916 121.949  34.329  1.00 16.59           C  
ATOM   1211  CG  HIS   108     -11.718 123.383  33.917  1.00 16.50           C  
ATOM   1212  ND1 HIS   108     -10.588 124.083  34.293  1.00 15.51           N  
ATOM   1214  CE1 HIS   108     -10.637 125.301  33.769  1.00 16.01           C  
ATOM   1216  NE2 HIS   108     -11.757 125.417  33.086  1.00 15.37           N  
ATOM   1218  CD2 HIS   108     -12.459 124.234  33.166  1.00 16.00           C  
ATOM   1220  C   HIS   108     -13.235 119.921  34.646  1.00 15.19           C  
ATOM   1221  O   HIS   108     -13.155 118.995  33.914  1.00 14.28           O  
ATOM   1223  N   ALA   109     -13.224 119.734  35.940  1.00 15.65           N  
ATOM   1224  CA  ALA   109     -13.156 118.385  36.471  1.00 16.05           C  
ATOM   1226  CB  ALA   109     -12.982 118.414  37.948  1.00 15.64           C  
ATOM   1230  C   ALA   109     -14.389 117.577  36.057  1.00 16.76           C  
ATOM   1231  O   ALA   109     -14.296 116.376  35.833  1.00 16.84           O  
ATOM   1233  N   GLU   110     -15.530 118.244  35.907  1.00 18.11           N  
ATOM   1234  CA  GLU   110     -16.763 117.601  35.509  1.00 19.64           C  
ATOM   1236  CB  GLU   110     -17.944 118.562  35.725  1.00 20.98           C  
ATOM   1239  CG  GLU   110     -19.263 117.914  35.603  1.00 24.86           C  
ATOM   1242  CD  GLU   110     -20.462 118.763  36.071  1.00 31.30           C  
ATOM   1243  OE1 GLU   110     -20.310 119.940  36.553  1.00 33.93           O  
ATOM   1244  OE2 GLU   110     -21.590 118.225  35.910  1.00 33.70           O  
ATOM   1245  C   GLU   110     -16.703 117.087  34.095  1.00 19.32           C  
ATOM   1246  O   GLU   110     -17.168 116.035  33.832  1.00 19.73           O  
ATOM   1248  N   VAL   111     -16.090 117.823  33.180  1.00 19.93           N  
ATOM   1249  CA  VAL   111     -16.036 117.395  31.781  1.00 19.74           C  
ATOM   1251  CB  VAL   111     -15.417 118.506  30.864  1.00 18.83           C  
ATOM   1253  CG1 VAL   111     -15.077 117.966  29.594  1.00 17.21           C  
ATOM   1257  CG2 VAL   111     -16.404 119.747  30.729  1.00 18.98           C  
ATOM   1261  C   VAL   111     -15.230 116.100  31.695  1.00 19.31           C  
ATOM   1262  O   VAL   111     -15.681 115.136  31.122  1.00 19.55           O  
ATOM   1264  N   PHE   112     -14.048 116.102  32.277  1.00 19.15           N  
ATOM   1265  CA  PHE   112     -13.133 114.989  32.241  1.00 18.93           C  
ATOM   1267  CB  PHE   112     -11.763 115.437  32.754  1.00 19.07           C  
ATOM   1270  CG  PHE   112     -11.146 116.497  31.920  1.00 19.16           C  
ATOM   1271  CD1 PHE   112     -10.959 116.293  30.542  1.00 17.43           C  
ATOM   1273  CE1 PHE   112     -10.449 117.314  29.729  1.00 11.85           C  
ATOM   1275  CZ  PHE   112     -10.076 118.473  30.281  1.00 14.99           C  
ATOM   1277  CE2 PHE   112     -10.200 118.670  31.681  1.00 17.71           C  
ATOM   1279  CD2 PHE   112     -10.742 117.696  32.482  1.00 15.39           C  
ATOM   1281  C   PHE   112     -13.571 113.807  33.093  1.00 19.61           C  
ATOM   1282  O   PHE   112     -13.400 112.701  32.662  1.00 19.84           O  
ATOM   1284  N   GLN   113     -14.038 114.020  34.333  1.00 19.47           N  
ATOM   1285  CA  GLN   113     -14.712 112.919  35.058  1.00 20.19           C  
ATOM   1287  CB  GLN   113     -15.147 113.356  36.462  1.00 21.12           C  
ATOM   1290  CG  GLN   113     -13.895 113.637  37.417  1.00 24.34           C  
ATOM   1293  CD  GLN   113     -14.303 114.291  38.712  1.00 28.02           C  
ATOM   1294  OE1 GLN   113     -15.481 114.613  38.900  1.00 34.19           O  
ATOM   1295  NE2 GLN   113     -13.346 114.493  39.629  1.00 29.41           N  
ATOM   1298  C   GLN   113     -15.908 112.231  34.303  1.00 20.00           C  
ATOM   1299  O   GLN   113     -16.072 111.020  34.374  1.00 19.33           O  
ATOM   1301  N   THR   114     -16.704 112.989  33.569  1.00 19.93           N  
ATOM   1302  CA  THR   114     -17.845 112.436  32.832  1.00 18.45           C  
ATOM   1304  CB  THR   114     -18.870 113.557  32.392  1.00 18.41           C  
ATOM   1306  OG1 THR   114     -19.130 114.379  33.508  1.00 19.14           O  
ATOM   1308  CG2 THR   114     -20.240 112.995  31.904  1.00 15.13           C  
ATOM   1312  C   THR   114     -17.408 111.680  31.629  1.00 18.45           C  
ATOM   1313  O   THR   114     -18.021 110.672  31.235  1.00 18.46           O  
ATOM   1315  N   CYS   115     -16.405 112.205  30.969  1.00 17.05           N  
ATOM   1316  CA  CYS   115     -15.829 111.473  29.904  1.00 17.54           C  
ATOM   1318  CB  CYS   115     -14.759 112.350  29.292  1.00 18.42           C  
ATOM   1321  SG  CYS   115     -14.293 111.722  27.701  1.00 19.64           S  
ATOM   1323  C   CYS   115     -15.216 110.103  30.355  1.00 17.36           C  
ATOM   1324  O   CYS   115     -15.361 109.073  29.671  1.00 17.12           O  
ATOM   1326  N   SER   116     -14.533 110.100  31.516  1.00 16.47           N  
ATOM   1327  CA  SER   116     -13.910 108.902  32.049  1.00 16.74           C  
ATOM   1329  CB  SER   116     -12.991 109.261  33.235  1.00 18.02           C  
ATOM   1332  OG  SER   116     -11.972 110.188  32.826  1.00 19.25           O  
ATOM   1334  C   SER   116     -14.951 107.854  32.442  1.00 17.27           C  
ATOM   1335  O   SER   116     -14.746 106.695  32.185  1.00 18.02           O  
ATOM   1337  N   LYS   117     -16.017 108.248  33.143  1.00 17.76           N  
ATOM   1338  CA  LYS   117     -17.198 107.433  33.391  1.00 17.73           C  
ATOM   1340  CB  LYS   117     -18.288 108.271  34.036  1.00 18.80           C  
ATOM   1343  CG  LYS   117     -18.214 108.465  35.557  1.00 22.09           C  
ATOM   1346  CD  LYS   117     -19.399 109.382  35.976  1.00 29.44           C  
ATOM   1349  CE  LYS   117     -20.799 108.670  35.829  1.00 35.03           C  
ATOM   1352  NZ  LYS   117     -21.979 109.160  36.673  1.00 35.49           N  
ATOM   1356  C   LYS   117     -17.806 106.832  32.099  1.00 16.56           C  
ATOM   1357  O   LYS   117     -18.183 105.702  32.117  1.00 16.05           O  
ATOM   1359  N   VAL   118     -17.909 107.594  31.018  1.00 15.45           N  
ATOM   1360  CA  VAL   118     -18.408 107.055  29.765  1.00 16.58           C  
ATOM   1362  CB  VAL   118     -18.569 108.102  28.639  1.00 17.05           C  
ATOM   1364  CG1 VAL   118     -18.796 107.399  27.267  1.00 16.04           C  
ATOM   1368  CG2 VAL   118     -19.803 109.032  28.946  1.00 16.61           C  
ATOM   1372  C   VAL   118     -17.544 105.907  29.283  1.00 17.33           C  
ATOM   1373  O   VAL   118     -18.050 104.859  28.958  1.00 17.93           O  
ATOM   1375  N   MET   119     -16.232 106.124  29.277  1.00 17.29           N  
ATOM   1376  CA  MET   119     -15.268 105.152  28.901  1.00 16.83           C  
ATOM   1378  CB  MET   119     -13.847 105.771  29.086  1.00 18.48           C  
ATOM   1381  CG  MET   119     -13.346 106.789  27.945  1.00 17.68           C  
ATOM   1384  SD  MET   119     -14.396 106.780  26.536  1.00 25.44           S  
ATOM   1385  CE  MET   119     -14.656 108.485  26.051  1.00 25.86           C  
ATOM   1389  C   MET   119     -15.384 103.882  29.725  1.00 17.68           C  
ATOM   1390  O   MET   119     -15.300 102.785  29.203  1.00 16.23           O  
ATOM   1392  N   MET   120     -15.530 104.054  31.038  1.00 17.82           N  
ATOM   1393  CA  MET   120     -15.646 102.962  31.953  1.00 17.90           C  
ATOM   1395  CB  MET   120     -15.541 103.449  33.405  1.00 18.49           C  
ATOM   1398  CG  MET   120     -14.183 103.992  33.856  1.00 20.43           C  
ATOM   1401  SD  MET   120     -12.763 102.963  33.490  1.00 27.50           S  
ATOM   1402  CE  MET   120     -13.154 101.506  34.487  1.00 23.80           C  
ATOM   1406  C   MET   120     -16.976 102.242  31.806  1.00 18.07           C  
ATOM   1407  O   MET   120     -17.056 101.074  32.114  1.00 18.76           O  
ATOM   1409  N   HIS   121     -18.020 102.936  31.379  1.00 18.02           N  
ATOM   1410  CA  HIS   121     -19.310 102.326  31.191  1.00 16.84           C  
ATOM   1412  CB  HIS   121     -20.401 103.380  30.986  1.00 16.90           C  
ATOM   1415  CG  HIS   121     -20.886 104.029  32.249  1.00 15.18           C  
ATOM   1416  ND1 HIS   121     -21.278 103.309  33.350  1.00 17.39           N  
ATOM   1418  CE1 HIS   121     -21.695 104.137  34.298  1.00 19.88           C  
ATOM   1420  NE2 HIS   121     -21.639 105.370  33.820  1.00 19.45           N  
ATOM   1422  CD2 HIS   121     -21.103 105.327  32.553  1.00 15.34           C  
ATOM   1424  C   HIS   121     -19.233 101.442  29.958  1.00 17.12           C  
ATOM   1425  O   HIS   121     -19.898 100.408  29.892  1.00 17.67           O  
ATOM   1427  N   ILE   122     -18.502 101.874  28.948  1.00 16.86           N  
ATOM   1428  CA  ILE   122     -18.306 101.064  27.715  1.00 15.65           C  
ATOM   1430  CB  ILE   122     -17.560 101.861  26.674  1.00 15.30           C  
ATOM   1432  CG1 ILE   122     -18.452 103.000  26.114  1.00 16.20           C  
ATOM   1435  CD1 ILE   122     -17.690 103.930  25.081  1.00 12.70           C  
ATOM   1439  CG2 ILE   122     -16.998 100.971  25.496  1.00 14.97           C  
ATOM   1443  C   ILE   122     -17.555  99.752  28.097  1.00 15.69           C  
ATOM   1444  O   ILE   122     -17.972  98.646  27.746  1.00 17.26           O  
ATOM   1446  N   ARG   123     -16.481  99.880  28.863  1.00 15.27           N  
ATOM   1447  CA  ARG   123     -15.686  98.739  29.305  0.50 14.81           C  
ATOM   1451  CB  ARG   123     -14.432  99.242  30.018  0.50 14.77           C  
ATOM   1457  CG  ARG   123     -13.518  98.121  30.561  0.50 13.13           C  
ATOM   1463  CD  ARG   123     -13.132  98.482  31.954  0.50 10.58           C  
ATOM   1469  NE  ARG   123     -11.975  97.751  32.467  0.50 13.44           N  
ATOM   1473  CZ  ARG   123     -12.032  96.946  33.510  0.50  9.28           C  
ATOM   1475  NH1 ARG   123     -13.172  96.775  34.116  0.50  6.74           N  
ATOM   1481  NH2 ARG   123     -10.967  96.293  33.887  0.50 11.97           N  
ATOM   1487  C   ARG   123     -16.410  97.757  30.213  1.00 15.26           C  
ATOM   1488  O   ARG   123     -16.192  96.552  30.115  1.00 14.36           O  
ATOM   1490  N   ASN   124     -17.205  98.288  31.139  1.00 15.97           N  
ATOM   1491  CA  ASN   124     -17.955  97.518  32.062  1.00 16.12           C  
ATOM   1493  CB  ASN   124     -18.005  98.262  33.361  1.00 16.76           C  
ATOM   1496  CG  ASN   124     -16.642  98.358  34.019  1.00 17.50           C  
ATOM   1497  OD1 ASN   124     -15.867  97.451  33.968  1.00 22.01           O  
ATOM   1498  ND2 ASN   124     -16.384  99.436  34.661  1.00 20.81           N  
ATOM   1501  C   ASN   124     -19.372  97.139  31.575  1.00 16.10           C  
ATOM   1502  O   ASN   124     -20.131  96.542  32.309  1.00 15.88           O  
ATOM   1504  N   HIS   125     -19.703  97.442  30.336  1.00 16.02           N  
ATOM   1505  CA  HIS   125     -21.006  97.198  29.804  1.00 15.87           C  
ATOM   1507  CB  HIS   125     -21.182  97.819  28.406  1.00 16.42           C  
ATOM   1510  CG  HIS   125     -22.595  98.294  28.145  1.00 17.72           C  
ATOM   1511  ND1 HIS   125     -23.591  97.471  27.649  1.00 20.32           N  
ATOM   1513  CE1 HIS   125     -24.728  98.144  27.578  1.00 20.03           C  
ATOM   1515  NE2 HIS   125     -24.512  99.385  27.985  1.00 17.52           N  
ATOM   1517  CD2 HIS   125     -23.184  99.504  28.354  1.00 18.22           C  
ATOM   1519  C   HIS   125     -21.288  95.703  29.677  1.00 17.08           C  
ATOM   1520  O   HIS   125     -20.352  94.926  29.505  1.00 17.32           O  
ATOM   1522  N   PRO   126     -22.592  95.291  29.761  1.00 15.94           N  
ATOM   1523  CA  PRO   126     -22.859  93.897  29.646  1.00 15.53           C  
ATOM   1525  CB  PRO   126     -24.244  93.788  30.191  1.00 15.78           C  
ATOM   1528  CG  PRO   126     -24.607  95.092  30.745  1.00 15.31           C  
ATOM   1531  CD  PRO   126     -23.543  95.966  30.660  1.00 15.45           C  
ATOM   1534  C   PRO   126     -22.760  93.357  28.190  1.00 15.77           C  
ATOM   1535  O   PRO   126     -22.646  92.151  28.000  1.00 15.83           O  
ATOM   1536  N   VAL   127     -22.829  94.237  27.204  1.00 15.26           N  
ATOM   1537  CA  VAL   127     -22.769  93.868  25.821  1.00 14.48           C  
ATOM   1539  CB  VAL   127     -24.078  94.266  25.106  1.00 16.44           C  
ATOM   1541  CG1 VAL   127     -25.360  93.691  25.896  1.00 14.02           C  
ATOM   1545  CG2 VAL   127     -24.187  95.807  24.885  1.00 14.24           C  
ATOM   1549  C   VAL   127     -21.504  94.494  25.189  1.00 14.76           C  
ATOM   1550  O   VAL   127     -20.999  95.482  25.628  1.00 15.29           O  
ATOM   1552  N   PRO   128     -20.952  93.874  24.170  1.00 15.02           N  
ATOM   1553  CA  PRO   128     -19.949  94.518  23.375  1.00 13.57           C  
ATOM   1555  CB  PRO   128     -19.716  93.492  22.225  1.00 14.89           C  
ATOM   1558  CG  PRO   128     -20.237  92.224  22.689  1.00 13.79           C  
ATOM   1561  CD  PRO   128     -21.405  92.607  23.551  1.00 15.73           C  
ATOM   1564  C   PRO   128     -20.360  95.862  22.784  1.00 14.69           C  
ATOM   1565  O   PRO   128     -21.505  96.052  22.307  1.00 15.31           O  
ATOM   1566  N   VAL   129     -19.382  96.784  22.689  1.00 15.44           N  
ATOM   1567  CA  VAL   129     -19.582  98.111  22.039  1.00 12.97           C  
ATOM   1569  CB  VAL   129     -19.405  99.269  23.055  1.00 13.20           C  
ATOM   1571  CG1 VAL   129     -19.638 100.622  22.347  1.00  7.24           C  
ATOM   1575  CG2 VAL   129     -20.292  99.059  24.413  1.00  7.88           C  
ATOM   1579  C   VAL   129     -18.603  98.214  20.857  1.00 13.07           C  
ATOM   1580  O   VAL   129     -17.456  97.971  21.014  1.00 12.83           O  
ATOM   1582  N   ILE   130     -19.096  98.480  19.652  1.00 14.20           N  
ATOM   1583  CA  ILE   130     -18.300  98.659  18.459  1.00 11.93           C  
ATOM   1585  CB  ILE   130     -18.984  97.874  17.286  1.00 13.69           C  
ATOM   1587  CG1 ILE   130     -19.161  96.399  17.666  1.00 13.43           C  
ATOM   1590  CD1 ILE   130     -19.975  95.634  16.659  1.00 15.03           C  
ATOM   1594  CG2 ILE   130     -18.218  98.015  15.906  1.00  4.90           C  
ATOM   1598  C   ILE   130     -18.318 100.185  18.077  1.00 13.42           C  
ATOM   1599  O   ILE   130     -19.419 100.851  18.076  1.00 10.47           O  
ATOM   1601  N   ALA   131     -17.122 100.722  17.781  1.00 13.18           N  
ATOM   1602  CA  ALA   131     -16.957 102.062  17.185  1.00 13.55           C  
ATOM   1604  CB  ALA   131     -15.624 102.761  17.547  1.00 11.89           C  
ATOM   1608  C   ALA   131     -17.006 101.860  15.728  1.00 13.09           C  
ATOM   1609  O   ALA   131     -16.321 101.028  15.192  1.00 12.65           O  
ATOM   1611  N   MET   132     -17.852 102.615  15.068  1.00 15.32           N  
ATOM   1612  CA  MET   132     -17.940 102.582  13.563  1.00 13.93           C  
ATOM   1614  CB  MET   132     -19.335 102.230  13.107  1.00 13.98           C  
ATOM   1617  CG  MET   132     -19.509 102.357  11.534  1.00 16.51           C  
ATOM   1620  SD  MET   132     -21.151 101.970  10.883  1.00 18.40           S  
ATOM   1621  CE  MET   132     -21.122 102.807   9.309  1.00 24.32           C  
ATOM   1625  C   MET   132     -17.554 103.991  13.067  1.00 14.19           C  
ATOM   1626  O   MET   132     -18.360 104.888  13.056  1.00 16.29           O  
ATOM   1628  N   VAL   133     -16.333 104.173  12.608  1.00 13.14           N  
ATOM   1629  CA  VAL   133     -15.746 105.489  12.417  1.00 12.83           C  
ATOM   1631  CB  VAL   133     -14.311 105.497  13.055  1.00 10.70           C  
ATOM   1633  CG1 VAL   133     -13.673 106.899  12.793  1.00  9.23           C  
ATOM   1637  CG2 VAL   133     -14.369 105.055  14.518  1.00 11.76           C  
ATOM   1641  C   VAL   133     -15.547 105.798  10.938  1.00 14.21           C  
ATOM   1642  O   VAL   133     -14.987 104.969  10.290  1.00 12.77           O  
ATOM   1644  N   ASN   134     -15.930 106.997  10.458  1.00 15.70           N  
ATOM   1645  CA  ASN   134     -15.892 107.341   9.020  1.00 17.80           C  
ATOM   1647  CB  ASN   134     -17.294 107.206   8.446  1.00 18.10           C  
ATOM   1650  CG  ASN   134     -17.349 107.295   6.929  1.00 16.58           C  
ATOM   1651  OD1 ASN   134     -16.352 107.061   6.189  1.00 15.83           O  
ATOM   1652  ND2 ASN   134     -18.540 107.645   6.448  1.00 14.19           N  
ATOM   1655  C   ASN   134     -15.391 108.796   8.834  1.00 19.29           C  
ATOM   1656  O   ASN   134     -16.183 109.695   8.577  1.00 20.58           O  
ATOM   1658  N   GLY   135     -14.089 109.035   9.035  1.00 19.25           N  
ATOM   1659  CA  GLY   135     -13.543 110.390   8.996  1.00 17.79           C  
ATOM   1662  C   GLY   135     -12.605 110.549  10.177  1.00 17.04           C  
ATOM   1663  O   GLY   135     -12.035 109.561  10.632  1.00 16.93           O  
ATOM   1665  N   LEU   136     -12.466 111.788  10.667  1.00 15.81           N  
ATOM   1666  CA  LEU   136     -11.440 112.138  11.635  1.00 15.63           C  
ATOM   1668  CB  LEU   136     -11.044 113.617  11.520  1.00 16.59           C  
ATOM   1671  CG  LEU   136      -9.891 114.219  12.309  1.00 18.05           C  
ATOM   1673  CD1 LEU   136      -8.429 113.551  12.089  1.00 18.99           C  
ATOM   1677  CD2 LEU   136      -9.833 115.783  12.152  1.00 20.77           C  
ATOM   1681  C   LEU   136     -11.954 111.965  12.963  1.00 14.44           C  
ATOM   1682  O   LEU   136     -13.066 112.422  13.261  1.00 12.39           O  
ATOM   1684  N   ALA   137     -11.077 111.436  13.817  1.00 14.97           N  
ATOM   1685  CA  ALA   137     -11.376 111.250  15.202  1.00 14.20           C  
ATOM   1687  CB  ALA   137     -11.609 109.759  15.466  1.00 12.24           C  
ATOM   1691  C   ALA   137     -10.160 111.801  15.973  1.00 15.75           C  
ATOM   1692  O   ALA   137      -9.029 111.333  15.763  1.00 16.76           O  
ATOM   1694  N   THR   138     -10.362 112.837  16.809  1.00 16.53           N  
ATOM   1695  CA  THR   138      -9.252 113.551  17.381  1.00 16.52           C  
ATOM   1697  CB  THR   138      -8.919 114.929  16.739  1.00 16.69           C  
ATOM   1699  OG1 THR   138      -9.769 115.911  17.307  1.00 21.82           O  
ATOM   1701  CG2 THR   138      -9.014 115.076  15.082  1.00 17.09           C  
ATOM   1705  C   THR   138      -9.402 113.732  18.943  1.00 16.59           C  
ATOM   1706  O   THR   138     -10.504 114.058  19.468  1.00 17.31           O  
ATOM   1708  N   ALA   139      -8.278 113.646  19.641  1.00 14.84           N  
ATOM   1709  CA  ALA   139      -8.277 113.889  21.168  1.00 14.64           C  
ATOM   1711  CB  ALA   139      -8.517 115.349  21.540  1.00 12.76           C  
ATOM   1715  C   ALA   139      -9.300 112.981  21.721  1.00 14.52           C  
ATOM   1716  O   ALA   139      -9.168 111.760  21.532  1.00 14.92           O  
ATOM   1718  N   ALA   140     -10.322 113.519  22.401  1.00 16.51           N  
ATOM   1719  CA  ALA   140     -11.291 112.702  23.204  1.00 16.46           C  
ATOM   1721  CB  ALA   140     -12.166 113.531  24.163  1.00 15.96           C  
ATOM   1725  C   ALA   140     -12.142 111.890  22.295  1.00 16.99           C  
ATOM   1726  O   ALA   140     -12.700 110.882  22.738  1.00 17.32           O  
ATOM   1728  N   GLY   141     -12.260 112.322  21.015  1.00 17.55           N  
ATOM   1729  CA  GLY   141     -12.798 111.517  20.000  1.00 17.29           C  
ATOM   1732  C   GLY   141     -12.052 110.245  19.685  1.00 19.38           C  
ATOM   1733  O   GLY   141     -12.668 109.205  19.427  1.00 21.86           O  
ATOM   1735  N   CYS   142     -10.720 110.328  19.629  1.00 19.34           N  
ATOM   1736  CA  CYS   142      -9.878 109.194  19.497  1.00 18.07           C  
ATOM   1738  CB  CYS   142      -8.437 109.670  19.305  1.00 20.75           C  
ATOM   1741  SG  CYS   142      -7.434 108.399  18.490  1.00 21.27           S  
ATOM   1743  C   CYS   142      -9.947 108.334  20.733  1.00 17.69           C  
ATOM   1744  O   CYS   142     -10.031 107.119  20.635  1.00 19.11           O  
ATOM   1746  N   GLN   143      -9.923 108.948  21.907  1.00 15.10           N  
ATOM   1747  CA  GLN   143     -10.181 108.220  23.112  1.00 14.70           C  
ATOM   1749  CB  GLN   143     -10.384 109.228  24.244  1.00 15.37           C  
ATOM   1752  CG  GLN   143     -10.213 108.699  25.562  1.00 16.50           C  
ATOM   1755  CD  GLN   143     -10.624 109.665  26.587  1.00 15.66           C  
ATOM   1756  OE1 GLN   143     -11.172 109.277  27.546  1.00 21.03           O  
ATOM   1757  NE2 GLN   143     -10.363 110.904  26.395  1.00 14.30           N  
ATOM   1760  C   GLN   143     -11.391 107.289  22.958  1.00 14.94           C  
ATOM   1761  O   GLN   143     -11.356 106.109  23.216  1.00 15.30           O  
ATOM   1763  N   LEU   144     -12.489 107.835  22.491  1.00 16.72           N  
ATOM   1764  CA  LEU   144     -13.743 107.112  22.461  1.00 15.83           C  
ATOM   1766  CB  LEU   144     -14.866 108.027  21.963  1.00 15.53           C  
ATOM   1769  CG  LEU   144     -16.280 107.504  21.752  1.00 17.08           C  
ATOM   1771  CD1 LEU   144     -16.809 106.644  22.878  1.00 11.29           C  
ATOM   1775  CD2 LEU   144     -17.178 108.702  21.383  1.00 15.43           C  
ATOM   1779  C   LEU   144     -13.627 105.947  21.596  1.00 17.09           C  
ATOM   1780  O   LEU   144     -14.065 104.857  21.983  1.00 18.00           O  
ATOM   1782  N   VAL   145     -13.041 106.150  20.403  1.00 14.98           N  
ATOM   1783  CA  VAL   145     -12.867 105.031  19.542  1.00 14.78           C  
ATOM   1785  CB  VAL   145     -12.064 105.410  18.272  1.00 13.20           C  
ATOM   1787  CG1 VAL   145     -11.776 104.237  17.615  1.00 11.90           C  
ATOM   1791  CG2 VAL   145     -12.739 106.455  17.502  1.00  8.21           C  
ATOM   1795  C   VAL   145     -12.079 103.855  20.226  1.00 14.76           C  
ATOM   1796  O   VAL   145     -12.454 102.672  20.187  1.00 15.27           O  
ATOM   1798  N   ALA   146     -10.928 104.207  20.718  1.00 14.28           N  
ATOM   1799  CA  ALA   146      -9.999 103.265  21.296  1.00 14.65           C  
ATOM   1801  CB  ALA   146      -8.694 104.003  21.540  1.00 13.90           C  
ATOM   1805  C   ALA   146     -10.573 102.690  22.578  1.00 16.55           C  
ATOM   1806  O   ALA   146     -10.131 101.649  23.054  1.00 18.77           O  
ATOM   1808  N   SER   147     -11.567 103.346  23.155  1.00 15.98           N  
ATOM   1809  CA  SER   147     -12.355 102.748  24.250  1.00 17.16           C  
ATOM   1811  CB  SER   147     -13.099 103.897  25.013  1.00 16.86           C  
ATOM   1814  OG  SER   147     -12.018 104.685  25.615  1.00 20.51           O  
ATOM   1816  C   SER   147     -13.330 101.630  23.869  1.00 16.07           C  
ATOM   1817  O   SER   147     -13.759 100.933  24.701  1.00 12.98           O  
ATOM   1819  N   CYS   148     -13.790 101.551  22.619  1.00 17.13           N  
ATOM   1820  CA  CYS   148     -14.721 100.505  22.224  1.00 16.71           C  
ATOM   1822  CB  CYS   148     -15.343 100.877  20.885  1.00 18.29           C  
ATOM   1825  SG  CYS   148     -16.416 102.299  21.190  1.00 20.48           S  
ATOM   1827  C   CYS   148     -14.015  99.133  22.224  1.00 17.21           C  
ATOM   1828  O   CYS   148     -12.817  99.052  22.100  1.00 16.90           O  
ATOM   1830  N   ASP   149     -14.781  98.049  22.386  1.00 16.56           N  
ATOM   1831  CA  ASP   149     -14.248  96.671  22.327  1.00 15.21           C  
ATOM   1833  CB  ASP   149     -15.349  95.619  22.823  1.00 13.52           C  
ATOM   1836  CG  ASP   149     -15.848  95.882  24.217  1.00 16.68           C  
ATOM   1837  OD1 ASP   149     -17.059  96.102  24.440  1.00 17.98           O  
ATOM   1838  OD2 ASP   149     -15.021  95.858  25.170  1.00 20.31           O  
ATOM   1839  C   ASP   149     -13.735  96.331  20.910  1.00 14.93           C  
ATOM   1840  O   ASP   149     -12.711  95.631  20.781  1.00 15.16           O  
ATOM   1842  N   ILE   150     -14.444  96.820  19.883  1.00 13.57           N  
ATOM   1843  CA  ILE   150     -14.111  96.565  18.416  1.00 14.31           C  
ATOM   1845  CB  ILE   150     -15.095  95.522  17.733  1.00 12.77           C  
ATOM   1847  CG1 ILE   150     -14.892  94.146  18.399  1.00 15.91           C  
ATOM   1850  CD1 ILE   150     -16.059  93.224  18.301  1.00 13.77           C  
ATOM   1854  CG2 ILE   150     -14.941  95.404  16.247  1.00 13.56           C  
ATOM   1858  C   ILE   150     -14.247  97.871  17.746  1.00 13.95           C  
ATOM   1859  O   ILE   150     -15.051  98.691  18.219  1.00 16.22           O  
ATOM   1861  N   ALA   151     -13.385  98.172  16.777  1.00 12.47           N  
ATOM   1862  CA  ALA   151     -13.555  99.420  15.978  1.00 12.55           C  
ATOM   1864  CB  ALA   151     -12.576 100.535  16.376  1.00 13.16           C  
ATOM   1868  C   ALA   151     -13.361  99.119  14.555  1.00 11.59           C  
ATOM   1869  O   ALA   151     -12.459  98.428  14.221  1.00  9.67           O  
ATOM   1871  N   VAL   152     -14.239  99.649  13.723  1.00 13.17           N  
ATOM   1872  CA  VAL   152     -14.215  99.467  12.276  1.00 13.54           C  
ATOM   1874  CB  VAL   152     -15.538  98.720  11.775  1.00 14.14           C  
ATOM   1876  CG1 VAL   152     -15.402  98.283  10.412  1.00 11.83           C  
ATOM   1880  CG2 VAL   152     -15.927  97.558  12.693  1.00 11.37           C  
ATOM   1884  C   VAL   152     -14.215 100.896  11.702  1.00 15.05           C  
ATOM   1885  O   VAL   152     -15.007 101.694  12.153  1.00 15.86           O  
ATOM   1887  N   ALA   153     -13.434 101.177  10.651  1.00 16.38           N  
ATOM   1888  CA  ALA   153     -13.167 102.532  10.189  1.00 16.80           C  
ATOM   1890  CB  ALA   153     -11.780 103.072  10.794  1.00 15.60           C  
ATOM   1894  C   ALA   153     -13.144 102.479   8.685  1.00 16.53           C  
ATOM   1895  O   ALA   153     -12.680 101.499   8.135  1.00 18.86           O  
ATOM   1897  N   SER   154     -13.720 103.460   7.976  1.00 17.43           N  
ATOM   1898  CA  SER   154     -13.425 103.599   6.498  1.00 17.76           C  
ATOM   1900  CB  SER   154     -14.205 104.772   5.892  1.00 17.71           C  
ATOM   1903  OG  SER   154     -13.894 105.937   6.657  1.00 20.86           O  
ATOM   1905  C   SER   154     -11.941 103.874   6.287  1.00 17.98           C  
ATOM   1906  O   SER   154     -11.274 104.399   7.145  1.00 18.86           O  
ATOM   1908  N   ASP   155     -11.434 103.531   5.123  1.00 20.20           N  
ATOM   1909  CA  ASP   155     -10.016 103.718   4.775  1.00 20.53           C  
ATOM   1911  CB  ASP   155      -9.720 102.958   3.422  1.00 21.70           C  
ATOM   1914  CG  ASP   155     -10.661 103.332   2.321  1.00 25.16           C  
ATOM   1915  OD1 ASP   155     -11.393 104.326   2.548  1.00 32.18           O  
ATOM   1916  OD2 ASP   155     -10.704 102.656   1.233  1.00 31.33           O  
ATOM   1917  C   ASP   155      -9.580 105.200   4.717  1.00 19.69           C  
ATOM   1918  O   ASP   155      -8.400 105.484   4.732  1.00 20.26           O  
ATOM   1920  N   LYS   156     -10.531 106.140   4.626  1.00 19.70           N  
ATOM   1921  CA  LYS   156     -10.233 107.613   4.606  1.00 19.36           C  
ATOM   1923  CB  LYS   156     -11.287 108.402   3.848  1.00 18.32           C  
ATOM   1926  CG  LYS   156     -12.523 108.719   4.721  1.00 21.72           C  
ATOM   1929  CD  LYS   156     -13.605 109.442   3.926  1.00 28.34           C  
ATOM   1932  CE  LYS   156     -14.764 109.953   4.810  1.00 30.53           C  
ATOM   1935  NZ  LYS   156     -15.859 110.341   3.812  1.00 23.70           N  
ATOM   1939  C   LYS   156     -10.196 108.205   6.008  1.00 18.12           C  
ATOM   1940  O   LYS   156      -9.851 109.365   6.182  1.00 19.94           O  
ATOM   1942  N   SER   157     -10.707 107.475   6.967  1.00 15.93           N  
ATOM   1943  CA  SER   157     -10.481 107.827   8.387  1.00 14.77           C  
ATOM   1945  CB  SER   157     -10.962 106.683   9.196  1.00 13.82           C  
ATOM   1948  OG  SER   157     -12.318 106.488   9.139  1.00 14.81           O  
ATOM   1950  C   SER   157      -9.042 108.058   8.857  1.00 14.72           C  
ATOM   1951  O   SER   157      -8.125 107.444   8.356  1.00 14.23           O  
ATOM   1953  N   SER   158      -8.889 108.847   9.942  1.00 14.89           N  
ATOM   1954  CA  SER   158      -7.659 109.206  10.462  1.00 15.21           C  
ATOM   1956  CB  SER   158      -7.008 110.355   9.719  1.00 16.57           C  
ATOM   1959  OG  SER   158      -7.455 111.626  10.185  1.00 19.65           O  
ATOM   1961  C   SER   158      -7.864 109.556  11.938  1.00 15.60           C  
ATOM   1962  O   SER   158      -8.988 109.831  12.370  1.00 17.35           O  
ATOM   1964  N   PHE   159      -6.773 109.495  12.685  1.00 13.31           N  
ATOM   1965  CA  PHE   159      -6.797 109.518  14.183  1.00 13.16           C  
ATOM   1967  CB  PHE   159      -6.626 108.061  14.637  1.00 14.50           C  
ATOM   1970  CG  PHE   159      -7.597 107.116  13.922  1.00 14.84           C  
ATOM   1971  CD1 PHE   159      -7.268 106.551  12.741  1.00 18.81           C  
ATOM   1973  CE1 PHE   159      -8.215 105.735  12.070  1.00 19.96           C  
ATOM   1975  CZ  PHE   159      -9.499 105.507  12.689  1.00 19.89           C  
ATOM   1977  CE2 PHE   159      -9.808 106.080  13.773  1.00 10.53           C  
ATOM   1979  CD2 PHE   159      -8.873 106.890  14.430  1.00 18.37           C  
ATOM   1981  C   PHE   159      -5.650 110.331  14.658  1.00 11.23           C  
ATOM   1982  O   PHE   159      -4.558 110.173  14.074  1.00  7.55           O  
ATOM   1984  N   ALA   160      -5.854 111.185  15.710  1.00 11.91           N  
ATOM   1985  CA  ALA   160      -4.826 112.135  16.255  1.00 11.63           C  
ATOM   1987  CB  ALA   160      -4.717 113.434  15.370  1.00 10.32           C  
ATOM   1991  C   ALA   160      -5.100 112.562  17.718  1.00 12.81           C  
ATOM   1992  O   ALA   160      -6.225 112.448  18.208  1.00 14.16           O  
ATOM   1994  N   THR   161      -4.028 112.898  18.449  1.00 14.40           N  
ATOM   1995  CA  THR   161      -4.124 113.375  19.908  1.00 14.46           C  
ATOM   1997  CB  THR   161      -3.674 112.359  20.920  1.00 14.70           C  
ATOM   1999  OG1 THR   161      -2.354 111.948  20.692  1.00 18.82           O  
ATOM   2001  CG2 THR   161      -4.605 111.072  21.070  1.00 11.62           C  
ATOM   2005  C   THR   161      -3.342 114.724  19.891  1.00 13.93           C  
ATOM   2006  O   THR   161      -2.186 114.821  20.299  1.00 13.89           O  
ATOM   2008  N   PRO   162      -3.936 115.746  19.260  1.00 13.68           N  
ATOM   2009  CA  PRO   162      -3.314 117.035  19.113  1.00 14.50           C  
ATOM   2011  CB  PRO   162      -4.021 117.570  17.909  1.00 14.91           C  
ATOM   2014  CG  PRO   162      -5.495 117.147  18.299  1.00 13.72           C  
ATOM   2017  CD  PRO   162      -5.264 115.729  18.624  1.00 14.02           C  
ATOM   2020  C   PRO   162      -3.546 118.026  20.273  1.00 13.71           C  
ATOM   2021  O   PRO   162      -3.349 119.171  20.077  1.00 13.59           O  
ATOM   2022  N   GLY   163      -3.966 117.617  21.432  1.00 13.57           N  
ATOM   2023  CA  GLY   163      -4.009 118.567  22.602  1.00 15.24           C  
ATOM   2026  C   GLY   163      -2.896 119.618  22.674  1.00 16.04           C  
ATOM   2027  O   GLY   163      -3.162 120.804  22.979  1.00 16.72           O  
ATOM   2029  N   VAL   164      -1.668 119.202  22.341  1.00 15.79           N  
ATOM   2030  CA  VAL   164      -0.458 119.981  22.607  1.00 15.89           C  
ATOM   2032  CB  VAL   164       0.907 119.180  22.283  1.00 16.65           C  
ATOM   2034  CG1 VAL   164       1.292 118.356  23.398  1.00 19.97           C  
ATOM   2038  CG2 VAL   164       0.828 118.443  20.938  1.00 15.86           C  
ATOM   2042  C   VAL   164      -0.448 121.262  21.852  1.00 14.61           C  
ATOM   2043  O   VAL   164       0.088 122.249  22.319  1.00 13.93           O  
ATOM   2045  N   ASN   165      -0.969 121.224  20.629  1.00 16.04           N  
ATOM   2046  CA  ASN   165      -1.148 122.387  19.778  1.00 14.55           C  
ATOM   2048  CB  ASN   165      -1.761 121.915  18.480  1.00 14.16           C  
ATOM   2051  CG  ASN   165      -0.774 121.026  17.664  1.00 14.81           C  
ATOM   2052  OD1 ASN   165       0.415 121.018  17.949  1.00 17.41           O  
ATOM   2053  ND2 ASN   165      -1.256 120.334  16.641  1.00 12.60           N  
ATOM   2056  C   ASN   165      -1.980 123.516  20.470  1.00 15.76           C  
ATOM   2057  O   ASN   165      -1.754 124.706  20.185  1.00 18.72           O  
ATOM   2059  N   VAL   166      -2.891 123.162  21.400  1.00 14.92           N  
ATOM   2060  CA  VAL   166      -3.702 124.124  22.167  1.00 12.58           C  
ATOM   2062  CB  VAL   166      -5.210 123.861  22.031  1.00 12.92           C  
ATOM   2064  CG1 VAL   166      -5.615 123.744  20.418  1.00  7.18           C  
ATOM   2068  CG2 VAL   166      -5.718 122.593  22.756  1.00  8.71           C  
ATOM   2072  C   VAL   166      -3.289 124.120  23.607  1.00 13.26           C  
ATOM   2073  O   VAL   166      -4.050 124.481  24.482  1.00 13.86           O  
ATOM   2075  N   GLY   167      -2.067 123.782  23.873  1.00 12.52           N  
ATOM   2076  CA  GLY   167      -1.554 123.834  25.275  1.00 12.88           C  
ATOM   2079  C   GLY   167      -2.257 122.906  26.196  1.00 12.87           C  
ATOM   2080  O   GLY   167      -2.050 122.990  27.366  1.00 11.70           O  
ATOM   2082  N   LEU   168      -3.018 121.945  25.629  1.00 15.15           N  
ATOM   2083  CA  LEU   168      -3.711 120.940  26.430  1.00 15.27           C  
ATOM   2085  CB  LEU   168      -5.220 121.049  26.337  1.00 14.54           C  
ATOM   2088  CG  LEU   168      -6.044 120.150  27.318  1.00 15.01           C  
ATOM   2090  CD1 LEU   168      -5.635 120.183  28.793  1.00  8.44           C  
ATOM   2094  CD2 LEU   168      -7.475 120.492  27.192  1.00 12.90           C  
ATOM   2098  C   LEU   168      -3.300 119.519  26.054  1.00 15.66           C  
ATOM   2099  O   LEU   168      -3.986 118.919  25.340  1.00 14.16           O  
ATOM   2101  N   PHE   169      -2.277 118.941  26.750  1.00 15.84           N  
ATOM   2102  CA  PHE   169      -1.776 117.603  26.358  1.00 15.52           C  
ATOM   2104  CB  PHE   169      -0.632 117.222  27.284  1.00 15.49           C  
ATOM   2107  CG  PHE   169       0.273 116.083  26.783  1.00 19.77           C  
ATOM   2108  CD1 PHE   169       0.016 114.757  27.103  1.00 19.12           C  
ATOM   2110  CE1 PHE   169       0.845 113.751  26.725  1.00 12.77           C  
ATOM   2112  CZ  PHE   169       2.009 114.007  26.151  1.00 18.20           C  
ATOM   2114  CE2 PHE   169       2.320 115.311  25.776  1.00 23.08           C  
ATOM   2116  CD2 PHE   169       1.463 116.346  26.115  1.00 23.90           C  
ATOM   2118  C   PHE   169      -2.915 116.557  26.384  1.00 14.86           C  
ATOM   2119  O   PHE   169      -3.643 116.462  27.398  1.00 12.35           O  
ATOM   2121  N   CYS   170      -3.016 115.698  25.348  1.00 13.41           N  
ATOM   2122  CA  CYS   170      -4.035 114.596  25.361  1.00 11.88           C  
ATOM   2124  CB  CYS   170      -4.212 113.985  23.971  1.00 16.34           C  
ATOM   2127  SG  CYS   170      -5.066 115.119  22.882  1.00 14.15           S  
ATOM   2129  C   CYS   170      -3.822 113.535  26.415  1.00 12.88           C  
ATOM   2130  O   CYS   170      -3.758 112.371  26.134  1.00 11.10           O  
ATOM   2132  N   SER   171      -3.733 113.932  27.715  1.00 11.47           N  
ATOM   2133  CA  SER   171      -3.464 112.969  28.731  1.00 10.97           C  
ATOM   2135  CB  SER   171      -3.229 113.633  30.073  1.00 10.81           C  
ATOM   2138  OG  SER   171      -2.022 114.323  30.093  1.00 11.21           O  
ATOM   2140  C   SER   171      -4.525 111.918  28.919  1.00 12.85           C  
ATOM   2141  O   SER   171      -4.212 110.719  29.144  1.00 12.57           O  
ATOM   2143  N   THR   172      -5.771 112.381  28.822  1.00 13.91           N  
ATOM   2144  CA  THR   172      -6.954 111.541  28.875  1.00 14.21           C  
ATOM   2146  CB  THR   172      -8.245 112.376  28.810  1.00 11.99           C  
ATOM   2148  OG1 THR   172      -7.944 113.688  28.320  1.00 18.90           O  
ATOM   2150  CG2 THR   172      -8.876 112.488  30.190  1.00 12.58           C  
ATOM   2154  C   THR   172      -6.931 110.566  27.713  1.00 14.24           C  
ATOM   2155  O   THR   172      -6.909 109.354  27.927  1.00 14.96           O  
ATOM   2157  N   PRO   173      -6.924 111.071  26.480  1.00 13.79           N  
ATOM   2158  CA  PRO   173      -6.781 110.153  25.396  1.00 14.93           C  
ATOM   2160  CB  PRO   173      -6.706 111.045  24.184  1.00 15.71           C  
ATOM   2163  CG  PRO   173      -7.460 112.323  24.540  1.00 12.71           C  
ATOM   2166  CD  PRO   173      -7.051 112.455  26.023  1.00 13.35           C  
ATOM   2169  C   PRO   173      -5.521 109.199  25.422  1.00 17.61           C  
ATOM   2170  O   PRO   173      -5.580 108.103  24.913  1.00 19.27           O  
ATOM   2171  N   GLY   174      -4.387 109.629  25.969  1.00 17.70           N  
ATOM   2172  CA  GLY   174      -3.272 108.737  26.057  1.00 17.44           C  
ATOM   2175  C   GLY   174      -3.499 107.491  26.902  1.00 15.28           C  
ATOM   2176  O   GLY   174      -2.813 106.537  26.725  1.00 14.27           O  
ATOM   2178  N   VAL   175      -4.467 107.505  27.800  1.00 15.76           N  
ATOM   2179  CA  VAL   175      -4.896 106.271  28.511  1.00 15.71           C  
ATOM   2181  CB  VAL   175      -5.937 106.619  29.521  1.00 15.70           C  
ATOM   2183  CG1 VAL   175      -6.565 105.337  30.087  1.00 14.32           C  
ATOM   2187  CG2 VAL   175      -5.252 107.444  30.643  1.00 15.63           C  
ATOM   2191  C   VAL   175      -5.366 105.150  27.553  1.00 15.93           C  
ATOM   2192  O   VAL   175      -4.804 104.066  27.471  1.00 16.71           O  
ATOM   2194  N   ALA   176      -6.311 105.462  26.691  1.00 17.13           N  
ATOM   2195  CA  ALA   176      -6.865 104.471  25.816  1.00 15.80           C  
ATOM   2197  CB  ALA   176      -8.171 104.961  25.233  1.00 14.01           C  
ATOM   2201  C   ALA   176      -5.808 104.198  24.771  1.00 17.04           C  
ATOM   2202  O   ALA   176      -5.591 103.035  24.407  1.00 18.17           O  
ATOM   2204  N   LEU   177      -5.122 105.241  24.314  1.00 15.93           N  
ATOM   2205  CA  LEU   177      -4.075 105.075  23.291  1.00 15.60           C  
ATOM   2207  CB  LEU   177      -3.623 106.433  22.684  1.00 14.99           C  
ATOM   2210  CG  LEU   177      -2.831 106.520  21.396  1.00 15.86           C  
ATOM   2212  CD1 LEU   177      -3.655 106.014  20.179  1.00  9.70           C  
ATOM   2216  CD2 LEU   177      -2.241 107.883  21.203  1.00 12.41           C  
ATOM   2220  C   LEU   177      -2.907 104.225  23.790  1.00 13.61           C  
ATOM   2221  O   LEU   177      -2.461 103.392  23.100  1.00 12.97           O  
ATOM   2223  N   ALA   178      -2.379 104.413  25.010  1.00 15.02           N  
ATOM   2224  CA  ALA   178      -1.346 103.557  25.509  1.00 12.58           C  
ATOM   2226  CB  ALA   178      -0.913 104.031  27.090  1.00 12.50           C  
ATOM   2230  C   ALA   178      -1.803 102.057  25.497  1.00 13.24           C  
ATOM   2231  O   ALA   178      -0.988 101.166  25.426  1.00 14.17           O  
ATOM   2233  N   ARG   179      -3.103 101.769  25.688  1.00 13.68           N  
ATOM   2234  CA  ARG   179      -3.628 100.423  25.693  1.00 12.53           C  
ATOM   2236  CB  ARG   179      -4.741 100.327  26.661  1.00 13.34           C  
ATOM   2239  CG  ARG   179      -4.187 100.433  28.135  1.00 13.74           C  
ATOM   2242  CD  ARG   179      -5.181 101.036  29.004  1.00 12.81           C  
ATOM   2245  NE  ARG   179      -4.651 101.243  30.377  1.00 15.74           N  
ATOM   2247  CZ  ARG   179      -3.865 102.245  30.734  1.00 16.14           C  
ATOM   2248  NH1 ARG   179      -3.541 103.192  29.833  1.00 17.19           N  
ATOM   2251  NH2 ARG   179      -3.467 102.334  31.971  1.00 14.79           N  
ATOM   2254  C   ARG   179      -4.038  99.924  24.308  1.00 13.40           C  
ATOM   2255  O   ARG   179      -4.381  98.769  24.163  1.00 13.16           O  
ATOM   2257  N   ALA   180      -3.790 100.731  23.293  1.00 12.66           N  
ATOM   2258  CA  ALA   180      -4.220 100.412  21.896  1.00 13.32           C  
ATOM   2260  CB  ALA   180      -5.088 101.538  21.418  1.00  9.90           C  
ATOM   2264  C   ALA   180      -3.011 100.164  21.056  1.00 14.18           C  
ATOM   2265  O   ALA   180      -2.927  99.131  20.414  1.00 19.33           O  
ATOM   2267  N   VAL   181      -2.039 101.075  21.068  1.00 15.22           N  
ATOM   2268  CA  VAL   181      -0.849 100.991  20.255  1.00 13.85           C  
ATOM   2270  CB  VAL   181      -0.860 102.135  19.120  1.00 15.98           C  
ATOM   2272  CG1 VAL   181      -2.155 102.081  18.357  1.00  7.73           C  
ATOM   2276  CG2 VAL   181      -0.656 103.523  19.716  1.00 13.22           C  
ATOM   2280  C   VAL   181       0.461 100.901  21.028  1.00 15.16           C  
ATOM   2281  O   VAL   181       0.502 100.992  22.279  1.00 15.82           O  
ATOM   2283  N   PRO   182       1.573 100.616  20.315  1.00 14.19           N  
ATOM   2284  CA  PRO   182       2.868 100.628  21.001  1.00 13.75           C  
ATOM   2286  CB  PRO   182       3.843 100.160  19.916  1.00 13.53           C  
ATOM   2289  CG  PRO   182       3.032  99.343  19.051  1.00 13.09           C  
ATOM   2292  CD  PRO   182       1.682 100.081  18.971  1.00 12.60           C  
ATOM   2295  C   PRO   182       3.299 101.974  21.526  1.00 13.83           C  
ATOM   2296  O   PRO   182       2.954 102.954  20.942  1.00 12.62           O  
ATOM   2297  N   ARG   183       4.038 101.995  22.650  1.00 13.44           N  
ATOM   2298  CA  ARG   183       4.558 103.211  23.203  1.00 13.38           C  
ATOM   2300  CB  ARG   183       5.547 102.934  24.284  1.00 15.77           C  
ATOM   2303  CG  ARG   183       5.003 102.142  25.512  1.00 18.09           C  
ATOM   2306  CD  ARG   183       6.155 101.847  26.588  1.00 26.29           C  
ATOM   2309  NE  ARG   183       5.731 100.924  27.657  1.00 24.27           N  
ATOM   2311  CZ  ARG   183       6.371 100.749  28.824  1.00 29.69           C  
ATOM   2312  NH1 ARG   183       7.466 101.430  29.149  1.00 28.43           N  
ATOM   2315  NH2 ARG   183       5.873  99.907  29.739  1.00 32.30           N  
ATOM   2318  C   ARG   183       5.194 104.148  22.188  1.00 15.18           C  
ATOM   2319  O   ARG   183       4.927 105.346  22.173  1.00 14.34           O  
ATOM   2321  N   LYS   184       5.970 103.614  21.250  1.00 16.19           N  
ATOM   2322  CA  LYS   184       6.672 104.457  20.335  1.00 15.56           C  
ATOM   2324  CB  LYS   184       7.652 103.603  19.501  1.00 15.75           C  
ATOM   2327  CG  LYS   184       8.897 103.148  20.171  1.00 14.21           C  
ATOM   2330  CD  LYS   184       9.909 104.258  20.363  1.00 14.47           C  
ATOM   2333  CE  LYS   184      11.130 103.809  21.190  1.00 15.16           C  
ATOM   2336  NZ  LYS   184      10.767 103.122  22.463  1.00 11.42           N  
ATOM   2340  C   LYS   184       5.674 105.175  19.376  1.00 16.21           C  
ATOM   2341  O   LYS   184       6.000 106.188  18.817  1.00 18.28           O  
ATOM   2343  N   VAL   185       4.530 104.560  19.092  1.00 16.20           N  
ATOM   2344  CA  VAL   185       3.482 105.117  18.199  1.00 13.76           C  
ATOM   2346  CB  VAL   185       2.638 104.025  17.610  1.00 13.98           C  
ATOM   2348  CG1 VAL   185       1.288 104.568  16.898  1.00  9.73           C  
ATOM   2352  CG2 VAL   185       3.464 103.207  16.582  1.00 12.89           C  
ATOM   2356  C   VAL   185       2.705 106.100  19.084  1.00 13.72           C  
ATOM   2357  O   VAL   185       2.551 107.269  18.736  1.00 12.67           O  
ATOM   2359  N   ALA   186       2.331 105.677  20.296  1.00 12.27           N  
ATOM   2360  CA  ALA   186       1.546 106.569  21.141  1.00 11.47           C  
ATOM   2362  CB  ALA   186       1.073 105.873  22.447  1.00 10.23           C  
ATOM   2366  C   ALA   186       2.287 107.858  21.382  1.00 11.39           C  
ATOM   2367  O   ALA   186       1.712 108.967  21.396  1.00 11.13           O  
ATOM   2369  N   LEU   187       3.568 107.762  21.624  1.00 13.68           N  
ATOM   2370  CA  LEU   187       4.279 108.922  22.109  1.00 14.98           C  
ATOM   2372  CB  LEU   187       5.438 108.567  23.079  1.00 16.33           C  
ATOM   2375  CG  LEU   187       5.187 108.269  24.512  1.00 15.86           C  
ATOM   2377  CD1 LEU   187       6.406 107.556  25.136  1.00 15.26           C  
ATOM   2381  CD2 LEU   187       4.757 109.428  25.486  1.00 18.79           C  
ATOM   2385  C   LEU   187       4.650 109.852  20.973  1.00 14.07           C  
ATOM   2386  O   LEU   187       4.708 111.061  21.208  1.00 13.86           O  
ATOM   2388  N   GLU   188       4.748 109.370  19.711  1.00 16.26           N  
ATOM   2389  CA  GLU   188       4.968 110.277  18.638  1.00 13.66           C  
ATOM   2391  CB  GLU   188       5.315 109.608  17.304  1.00 15.77           C  
ATOM   2394  CG  GLU   188       5.935 110.580  16.321  1.00 11.44           C  
ATOM   2397  CD  GLU   188       6.002 110.080  14.897  1.00 21.65           C  
ATOM   2398  OE1 GLU   188       6.090 108.837  14.675  1.00 17.68           O  
ATOM   2399  OE2 GLU   188       5.983 110.977  13.985  1.00 20.00           O  
ATOM   2400  C   GLU   188       3.697 111.074  18.509  1.00 16.10           C  
ATOM   2401  O   GLU   188       3.728 112.300  18.403  1.00 19.11           O  
ATOM   2403  N   MET   189       2.568 110.373  18.503  1.00 15.67           N  
ATOM   2404  CA  MET   189       1.245 110.944  18.386  1.00 14.76           C  
ATOM   2406  CB  MET   189       0.223 109.820  18.476  1.00 16.05           C  
ATOM   2409  CG  MET   189      -0.192 109.235  17.113  1.00 11.41           C  
ATOM   2412  SD  MET   189      -1.299 107.831  17.427  1.00 15.18           S  
ATOM   2413  CE  MET   189      -2.885 108.711  17.284  1.00 10.20           C  
ATOM   2417  C   MET   189       0.881 111.983  19.415  1.00 13.16           C  
ATOM   2418  O   MET   189       0.362 113.020  19.111  1.00 12.74           O  
ATOM   2420  N   LEU   190       1.163 111.686  20.648  1.00 13.46           N  
ATOM   2421  CA  LEU   190       1.007 112.651  21.758  1.00 13.26           C  
ATOM   2423  CB  LEU   190       1.172 111.896  23.085  1.00 12.76           C  
ATOM   2426  CG  LEU   190      -0.041 110.953  23.427  1.00 15.20           C  
ATOM   2428  CD1 LEU   190       0.342 109.960  24.610  1.00 10.62           C  
ATOM   2432  CD2 LEU   190      -1.373 111.659  23.801  1.00  9.41           C  
ATOM   2436  C   LEU   190       1.916 113.923  21.809  1.00 13.41           C  
ATOM   2437  O   LEU   190       1.441 115.039  22.144  1.00 12.31           O  
ATOM   2439  N   PHE   191       3.219 113.734  21.593  1.00 13.82           N  
ATOM   2440  CA  PHE   191       4.180 114.821  21.611  1.00 13.38           C  
ATOM   2442  CB  PHE   191       5.621 114.271  21.785  1.00 13.20           C  
ATOM   2445  CG  PHE   191       5.928 113.726  23.145  1.00 15.67           C  
ATOM   2446  CD1 PHE   191       5.438 114.319  24.316  1.00 11.51           C  
ATOM   2448  CE1 PHE   191       5.760 113.755  25.521  1.00 14.34           C  
ATOM   2450  CZ  PHE   191       6.558 112.674  25.594  1.00 12.42           C  
ATOM   2452  CE2 PHE   191       7.108 112.149  24.432  1.00 13.47           C  
ATOM   2454  CD2 PHE   191       6.740 112.606  23.264  1.00 13.04           C  
ATOM   2456  C   PHE   191       4.137 115.686  20.356  1.00 14.04           C  
ATOM   2457  O   PHE   191       4.506 116.891  20.425  1.00 14.78           O  
ATOM   2459  N   THR   192       3.689 115.134  19.229  1.00 13.16           N  
ATOM   2460  CA  THR   192       3.681 115.936  17.956  1.00 13.89           C  
ATOM   2462  CB  THR   192       4.352 115.169  16.800  1.00 12.82           C  
ATOM   2464  OG1 THR   192       3.631 113.956  16.553  1.00 12.98           O  
ATOM   2466  CG2 THR   192       5.800 114.804  17.141  1.00 12.48           C  
ATOM   2470  C   THR   192       2.300 116.317  17.407  1.00 14.50           C  
ATOM   2471  O   THR   192       2.187 117.235  16.600  1.00 15.91           O  
ATOM   2473  N   GLY   193       1.261 115.554  17.731  1.00 15.16           N  
ATOM   2474  CA  GLY   193      -0.111 115.890  17.349  1.00 13.21           C  
ATOM   2477  C   GLY   193      -0.453 115.579  15.886  1.00 14.47           C  
ATOM   2478  O   GLY   193      -1.570 115.866  15.458  1.00 11.68           O  
ATOM   2480  N   GLU   194       0.378 114.845  15.193  1.00 14.01           N  
ATOM   2481  CA  GLU   194       0.022 114.437  13.862  1.00 16.76           C  
ATOM   2483  CB  GLU   194       1.277 114.336  13.000  1.00 17.80           C  
ATOM   2486  CG  GLU   194       2.118 115.670  12.989  1.00 22.11           C  
ATOM   2489  CD  GLU   194       1.936 116.482  11.769  1.00 24.74           C  
ATOM   2490  OE1 GLU   194       0.906 116.402  11.071  1.00 23.22           O  
ATOM   2491  OE2 GLU   194       2.886 117.207  11.450  1.00 34.60           O  
ATOM   2492  C   GLU   194      -0.850 113.190  13.715  1.00 15.67           C  
ATOM   2493  O   GLU   194      -0.580 112.138  14.278  1.00 14.15           O  
ATOM   2495  N   PRO   195      -1.886 113.300  12.895  1.00 14.69           N  
ATOM   2496  CA  PRO   195      -2.718 112.173  12.696  1.00 14.86           C  
ATOM   2498  CB  PRO   195      -3.653 112.671  11.550  1.00 15.80           C  
ATOM   2501  CG  PRO   195      -2.811 113.512  10.737  1.00 12.58           C  
ATOM   2504  CD  PRO   195      -2.018 114.261  11.786  1.00 15.77           C  
ATOM   2507  C   PRO   195      -1.901 110.912  12.128  1.00 14.58           C  
ATOM   2508  O   PRO   195      -0.835 111.053  11.564  1.00  8.63           O  
ATOM   2509  N   ILE   196      -2.412 109.726  12.465  1.00 14.84           N  
ATOM   2510  CA  ILE   196      -2.167 108.529  11.793  1.00 14.45           C  
ATOM   2512  CB  ILE   196      -1.750 107.326  12.600  1.00 14.39           C  
ATOM   2514  CG1 ILE   196      -2.928 106.781  13.464  1.00 15.65           C  
ATOM   2517  CD1 ILE   196      -2.544 105.621  14.499  1.00 11.63           C  
ATOM   2521  CG2 ILE   196      -0.395 107.632  13.279  1.00 13.20           C  
ATOM   2525  C   ILE   196      -3.455 108.204  11.051  1.00 15.62           C  
ATOM   2526  O   ILE   196      -4.602 108.541  11.511  1.00 14.49           O  
ATOM   2528  N   SER   197      -3.224 107.593   9.897  1.00 11.08           N  
ATOM   2529  CA  SER   197      -4.312 107.127   9.129  1.00 14.10           C  
ATOM   2531  CB  SER   197      -3.849 106.874   7.672  1.00 11.64           C  
ATOM   2534  OG  SER   197      -2.965 105.783   7.822  1.00 14.41           O  
ATOM   2536  C   SER   197      -4.818 105.784   9.650  1.00 12.85           C  
ATOM   2537  O   SER   197      -4.136 105.126  10.410  1.00 12.13           O  
ATOM   2539  N   ALA   198      -5.960 105.388   9.078  1.00 12.74           N  
ATOM   2540  CA  ALA   198      -6.697 104.195   9.380  1.00 12.91           C  
ATOM   2542  CB  ALA   198      -8.125 104.216   8.733  1.00 11.76           C  
ATOM   2546  C   ALA   198      -5.890 102.968   9.009  1.00 15.33           C  
ATOM   2547  O   ALA   198      -5.988 101.999   9.676  1.00 15.30           O  
ATOM   2549  N   GLN   199      -5.066 102.998   7.965  1.00 17.46           N  
ATOM   2550  CA  GLN   199      -4.204 101.844   7.708  1.00 18.62           C  
ATOM   2552  CB  GLN   199      -3.447 102.006   6.403  1.00 18.95           C  
ATOM   2555  CG  GLN   199      -4.292 102.060   5.089  1.00 19.74           C  
ATOM   2558  CD  GLN   199      -5.328 103.261   4.900  1.00 17.57           C  
ATOM   2559  OE1 GLN   199      -5.067 104.433   5.285  1.00 22.03           O  
ATOM   2560  NE2 GLN   199      -6.539 102.929   4.327  1.00  5.76           N  
ATOM   2563  C   GLN   199      -3.217 101.559   8.815  1.00 19.07           C  
ATOM   2564  O   GLN   199      -3.066 100.416   9.239  1.00 19.01           O  
ATOM   2566  N   GLU   200      -2.568 102.629   9.289  1.00 19.39           N  
ATOM   2567  CA  GLU   200      -1.639 102.627  10.372  1.00 17.75           C  
ATOM   2569  CB  GLU   200      -0.938 104.016  10.467  1.00 18.59           C  
ATOM   2572  CG  GLU   200      -0.123 104.440   9.146  1.00 19.47           C  
ATOM   2575  CD  GLU   200       0.227 105.995   9.049  1.00 23.04           C  
ATOM   2576  OE1 GLU   200      -0.213 106.792   9.926  1.00 23.16           O  
ATOM   2577  OE2 GLU   200       0.895 106.450   8.065  1.00 26.47           O  
ATOM   2578  C   GLU   200      -2.267 102.296  11.720  1.00 17.53           C  
ATOM   2579  O   GLU   200      -1.687 101.538  12.552  1.00 14.24           O  
ATOM   2581  N   ALA   201      -3.414 102.888  11.983  1.00 17.46           N  
ATOM   2582  CA  ALA   201      -4.134 102.512  13.218  1.00 15.81           C  
ATOM   2584  CB  ALA   201      -5.399 103.324  13.368  1.00 17.82           C  
ATOM   2588  C   ALA   201      -4.499 101.033  13.078  1.00 16.05           C  
ATOM   2589  O   ALA   201      -4.535 100.368  14.018  1.00 12.65           O  
ATOM   2591  N   LEU   202      -4.799 100.518  11.866  1.00 15.15           N  
ATOM   2592  CA  LEU   202      -5.079  99.062  11.761  1.00 16.60           C  
ATOM   2594  CB  LEU   202      -5.662  98.635  10.393  1.00 14.11           C  
ATOM   2597  CG  LEU   202      -5.909  97.131  10.254  1.00 14.17           C  
ATOM   2599  CD1 LEU   202      -6.933  96.662  11.181  1.00 10.30           C  
ATOM   2603  CD2 LEU   202      -6.276  96.674   8.762  1.00  6.93           C  
ATOM   2607  C   LEU   202      -3.807  98.222  12.129  1.00 17.80           C  
ATOM   2608  O   LEU   202      -3.878  97.379  13.019  1.00 20.48           O  
ATOM   2610  N   LEU   203      -2.656  98.555  11.544  1.00 17.59           N  
ATOM   2611  CA  LEU   203      -1.429  97.825  11.775  1.00 18.35           C  
ATOM   2613  CB  LEU   203      -0.297  98.488  11.010  1.00 18.94           C  
ATOM   2616  CG  LEU   203       1.043  97.768  10.922  1.00 21.00           C  
ATOM   2618  CD1 LEU   203       1.190  97.414   9.449  1.00 24.89           C  
ATOM   2622  CD2 LEU   203       2.209  98.632  11.305  1.00 26.89           C  
ATOM   2626  C   LEU   203      -0.998  97.807  13.218  1.00 18.20           C  
ATOM   2627  O   LEU   203      -0.338  96.856  13.663  1.00 20.33           O  
ATOM   2629  N   HIS   204      -1.273  98.900  13.907  1.00 17.02           N  
ATOM   2630  CA  HIS   204      -0.728  99.131  15.234  1.00 17.25           C  
ATOM   2632  CB  HIS   204      -0.203 100.553  15.369  1.00 16.74           C  
ATOM   2635  CG  HIS   204       1.093 100.729  14.676  1.00 18.87           C  
ATOM   2636  ND1 HIS   204       2.157  99.882  14.902  1.00 22.98           N  
ATOM   2638  CE1 HIS   204       3.153 100.212  14.106  1.00 21.31           C  
ATOM   2640  NE2 HIS   204       2.756 101.220  13.350  1.00 20.85           N  
ATOM   2642  CD2 HIS   204       1.477 101.566  13.687  1.00 18.98           C  
ATOM   2644  C   HIS   204      -1.654  98.782  16.358  1.00 16.73           C  
ATOM   2645  O   HIS   204      -1.243  98.784  17.497  1.00 18.93           O  
ATOM   2647  N   GLY   205      -2.879  98.408  16.047  1.00 16.80           N  
ATOM   2648  CA  GLY   205      -3.774  97.896  17.035  1.00 17.30           C  
ATOM   2651  C   GLY   205      -4.869  98.863  17.470  1.00 17.34           C  
ATOM   2652  O   GLY   205      -5.606  98.494  18.429  1.00 14.11           O  
ATOM   2654  N   LEU   206      -5.028 100.015  16.740  1.00 14.87           N  
ATOM   2655  CA  LEU   206      -6.093 100.963  17.128  1.00 15.55           C  
ATOM   2657  CB  LEU   206      -5.815 102.441  16.664  1.00 14.16           C  
ATOM   2660  CG  LEU   206      -6.820 103.556  17.045  1.00 12.78           C  
ATOM   2662  CD1 LEU   206      -7.503 103.424  18.333  1.00 20.82           C  
ATOM   2666  CD2 LEU   206      -6.183 104.910  16.994  1.00 15.60           C  
ATOM   2670  C   LEU   206      -7.477 100.488  16.711  1.00 14.99           C  
ATOM   2671  O   LEU   206      -8.414 100.664  17.458  1.00 14.65           O  
ATOM   2673  N   LEU   207      -7.548  99.925  15.485  1.00 14.78           N  
ATOM   2674  CA  LEU   207      -8.704  99.420  14.835  1.00 14.16           C  
ATOM   2676  CB  LEU   207      -8.769 100.007  13.376  1.00 14.90           C  
ATOM   2679  CG  LEU   207      -8.827 101.563  13.292  1.00 13.55           C  
ATOM   2681  CD1 LEU   207      -8.549 102.044  11.845  1.00 14.59           C  
ATOM   2685  CD2 LEU   207     -10.197 102.130  13.827  1.00  7.65           C  
ATOM   2689  C   LEU   207      -8.664  97.877  14.752  1.00 15.12           C  
ATOM   2690  O   LEU   207      -7.603  97.251  14.797  1.00 15.49           O  
ATOM   2692  N   SER   208      -9.848  97.286  14.559  1.00 15.66           N  
ATOM   2693  CA  SER   208     -10.067  95.832  14.288  1.00 14.66           C  
ATOM   2695  CB  SER   208     -11.378  95.301  14.949  1.00 13.97           C  
ATOM   2698  OG  SER   208     -11.455  95.674  16.324  1.00 12.76           O  
ATOM   2700  C   SER   208     -10.116  95.578  12.808  1.00 14.17           C  
ATOM   2701  O   SER   208      -9.495  94.620  12.297  1.00 11.84           O  
ATOM   2703  N   LYS   209     -10.831  96.455  12.113  1.00 15.33           N  
ATOM   2704  CA  LYS   209     -10.987  96.353  10.630  1.00 15.92           C  
ATOM   2706  CB  LYS   209     -12.322  95.634  10.279  1.00 15.35           C  
ATOM   2709  CG  LYS   209     -12.355  94.142  10.708  1.00 17.64           C  
ATOM   2712  CD  LYS   209     -11.567  93.203   9.711  1.00 20.11           C  
ATOM   2715  CE  LYS   209     -11.666  91.731  10.123  1.00 19.47           C  
ATOM   2718  NZ  LYS   209     -10.901  91.692  11.344  1.00 20.65           N  
ATOM   2722  C   LYS   209     -10.950  97.711   9.937  1.00 15.36           C  
ATOM   2723  O   LYS   209     -11.355  98.672  10.538  1.00 15.46           O  
ATOM   2725  N   VAL   210     -10.479  97.750   8.689  1.00 15.08           N  
ATOM   2726  CA  VAL   210     -10.553  98.951   7.829  1.00 15.57           C  
ATOM   2728  CB  VAL   210      -9.168  99.696   7.643  1.00 14.71           C  
ATOM   2730  CG1 VAL   210      -9.272 100.831   6.619  1.00 18.35           C  
ATOM   2734  CG2 VAL   210      -8.604 100.180   8.959  1.00 18.35           C  
ATOM   2738  C   VAL   210     -11.155  98.506   6.474  1.00 14.68           C  
ATOM   2739  O   VAL   210     -10.706  97.549   5.873  1.00 14.03           O  
ATOM   2741  N   VAL   211     -12.181  99.185   6.001  1.00 15.64           N  
ATOM   2742  CA  VAL   211     -12.831  98.810   4.697  1.00 15.09           C  
ATOM   2744  CB  VAL   211     -14.145  97.980   4.989  1.00 16.09           C  
ATOM   2746  CG1 VAL   211     -13.862  96.746   5.837  1.00 14.13           C  
ATOM   2750  CG2 VAL   211     -15.209  98.830   5.691  1.00 15.98           C  
ATOM   2754  C   VAL   211     -13.174 100.025   3.866  1.00 14.77           C  
ATOM   2755  O   VAL   211     -13.233 101.080   4.396  1.00 11.73           O  
ATOM   2757  N   PRO   212     -13.445  99.900   2.512  1.00 17.06           N  
ATOM   2758  CA  PRO   212     -13.921 101.159   1.922  1.00 17.19           C  
ATOM   2760  CB  PRO   212     -14.305 100.750   0.497  1.00 18.82           C  
ATOM   2763  CG  PRO   212     -13.353  99.628   0.192  1.00 19.04           C  
ATOM   2766  CD  PRO   212     -13.052  98.925   1.485  1.00 16.13           C  
ATOM   2769  C   PRO   212     -15.135 101.791   2.658  1.00 18.76           C  
ATOM   2770  O   PRO   212     -15.906 101.120   3.384  1.00 17.33           O  
ATOM   2771  N   GLU   213     -15.307 103.086   2.482  1.00 19.25           N  
ATOM   2772  CA  GLU   213     -16.484 103.738   3.022  1.00 20.79           C  
ATOM   2774  CB  GLU   213     -16.477 105.206   2.596  1.00 21.02           C  
ATOM   2777  CG  GLU   213     -17.736 105.977   2.967  1.00 24.18           C  
ATOM   2780  CD  GLU   213     -17.585 107.491   2.811  1.00 27.14           C  
ATOM   2781  OE1 GLU   213     -17.184 107.981   1.714  1.00 28.50           O  
ATOM   2782  OE2 GLU   213     -17.856 108.177   3.819  1.00 30.21           O  
ATOM   2783  C   GLU   213     -17.824 103.033   2.612  1.00 21.38           C  
ATOM   2784  O   GLU   213     -18.810 103.032   3.390  1.00 23.43           O  
ATOM   2786  N   ALA   214     -17.833 102.432   1.420  1.00 20.19           N  
ATOM   2787  CA  ALA   214     -18.988 101.723   0.852  1.00 20.15           C  
ATOM   2789  CB  ALA   214     -18.812 101.613  -0.714  1.00 18.33           C  
ATOM   2793  C   ALA   214     -19.225 100.332   1.504  1.00 19.74           C  
ATOM   2794  O   ALA   214     -20.290  99.769   1.359  1.00 17.74           O  
ATOM   2796  N   GLU   215     -18.262  99.812   2.283  1.00 21.29           N  
ATOM   2797  CA  GLU   215     -18.416  98.500   2.937  1.00 21.39           C  
ATOM   2799  CB  GLU   215     -17.210  97.622   2.623  1.00 21.99           C  
ATOM   2802  CG  GLU   215     -16.950  97.415   1.099  1.00 23.86           C  
ATOM   2805  CD  GLU   215     -15.724  96.513   0.816  1.00 26.03           C  
ATOM   2806  OE1 GLU   215     -14.945  96.119   1.730  1.00 27.52           O  
ATOM   2807  OE2 GLU   215     -15.547  96.163  -0.348  1.00 29.48           O  
ATOM   2808  C   GLU   215     -18.573  98.632   4.417  1.00 21.50           C  
ATOM   2809  O   GLU   215     -18.644  97.657   5.181  1.00 21.73           O  
ATOM   2811  N   LEU   216     -18.554  99.869   4.861  1.00 21.86           N  
ATOM   2812  CA  LEU   216     -18.421 100.145   6.284  1.00 19.44           C  
ATOM   2814  CB  LEU   216     -18.142 101.625   6.476  1.00 18.79           C  
ATOM   2817  CG  LEU   216     -18.039 102.169   7.936  1.00 16.12           C  
ATOM   2819  CD1 LEU   216     -16.962 101.490   8.719  1.00 13.83           C  
ATOM   2823  CD2 LEU   216     -17.864 103.637   7.891  1.00  9.01           C  
ATOM   2827  C   LEU   216     -19.643  99.749   7.082  1.00 20.22           C  
ATOM   2828  O   LEU   216     -19.529  99.118   8.115  1.00 22.13           O  
ATOM   2830  N   GLN   217     -20.798 100.216   6.668  1.00 22.03           N  
ATOM   2831  CA  GLN   217     -22.078  99.873   7.290  1.00 23.43           C  
ATOM   2833  CB  GLN   217     -23.216 100.646   6.575  1.00 24.69           C  
ATOM   2836  CG  GLN   217     -24.677 100.560   7.186  1.00 28.96           C  
ATOM   2839  CD  GLN   217     -24.820 101.076   8.653  1.00 33.30           C  
ATOM   2840  OE1 GLN   217     -24.511 102.243   8.968  1.00 36.19           O  
ATOM   2841  NE2 GLN   217     -25.338 100.214   9.528  1.00 34.41           N  
ATOM   2844  C   GLN   217     -22.291  98.352   7.283  1.00 23.28           C  
ATOM   2845  O   GLN   217     -22.572  97.784   8.308  1.00 23.33           O  
ATOM   2847  N   GLU   218     -22.105  97.687   6.152  1.00 23.93           N  
ATOM   2848  CA  GLU   218     -22.224  96.230   6.108  1.00 24.99           C  
ATOM   2850  CB  GLU   218     -22.186  95.694   4.692  1.00 25.20           C  
ATOM   2853  CG  GLU   218     -22.222  94.125   4.663  1.00 31.40           C  
ATOM   2856  CD  GLU   218     -23.501  93.449   5.354  1.00 37.43           C  
ATOM   2857  OE1 GLU   218     -24.658  93.787   4.944  1.00 42.00           O  
ATOM   2858  OE2 GLU   218     -23.341  92.552   6.252  1.00 37.45           O  
ATOM   2859  C   GLU   218     -21.175  95.488   6.917  1.00 24.20           C  
ATOM   2860  O   GLU   218     -21.494  94.466   7.552  1.00 23.78           O  
ATOM   2862  N   GLU   219     -19.934  95.982   6.912  1.00 24.03           N  
ATOM   2863  CA  GLU   219     -18.886  95.317   7.666  1.00 23.56           C  
ATOM   2865  CB  GLU   219     -17.507  95.828   7.309  1.00 24.48           C  
ATOM   2868  CG  GLU   219     -16.389  95.123   8.117  1.00 27.49           C  
ATOM   2871  CD  GLU   219     -16.099  93.700   7.628  1.00 31.58           C  
ATOM   2872  OE1 GLU   219     -16.823  93.172   6.722  1.00 34.57           O  
ATOM   2873  OE2 GLU   219     -15.128  93.120   8.153  1.00 34.06           O  
ATOM   2874  C   GLU   219     -19.093  95.427   9.124  1.00 21.74           C  
ATOM   2875  O   GLU   219     -18.815  94.496   9.865  1.00 24.10           O  
ATOM   2877  N   THR   220     -19.566  96.567   9.583  1.00 20.51           N  
ATOM   2878  CA  THR   220     -19.850  96.741  11.020  1.00 17.78           C  
ATOM   2880  CB  THR   220     -20.187  98.189  11.276  1.00 17.27           C  
ATOM   2882  OG1 THR   220     -19.047  98.984  10.954  1.00 17.78           O  
ATOM   2884  CG2 THR   220     -20.679  98.448  12.706  1.00 16.86           C  
ATOM   2888  C   THR   220     -21.082  95.937  11.434  1.00 17.39           C  
ATOM   2889  O   THR   220     -21.186  95.490  12.589  1.00 15.62           O  
ATOM   2891  N   MET   221     -22.050  95.831  10.501  1.00 16.50           N  
ATOM   2892  CA  MET   221     -23.284  95.049  10.724  1.00 17.34           C  
ATOM   2894  CB  MET   221     -24.372  95.341   9.642  1.00 17.93           C  
ATOM   2897  CG  MET   221     -25.119  96.659   9.843  1.00 19.23           C  
ATOM   2900  SD  MET   221     -25.605  96.801  11.607  1.00 24.57           S  
ATOM   2901  CE  MET   221     -27.246  96.093  11.392  1.00 21.33           C  
ATOM   2905  C   MET   221     -23.020  93.541  10.759  1.00 17.15           C  
ATOM   2906  O   MET   221     -23.736  92.839  11.393  1.00 16.60           O  
ATOM   2908  N   ARG   222     -22.043  93.059  10.007  1.00 17.61           N  
ATOM   2909  CA  ARG   222     -21.626  91.678  10.031  1.00 18.05           C  
ATOM   2911  CB  ARG   222     -20.470  91.443   9.043  1.00 18.43           C  
ATOM   2914  CG  ARG   222     -19.984  89.983   8.921  1.00 19.56           C  
ATOM   2917  CD  ARG   222     -18.661  89.841   8.102  1.00 22.18           C  
ATOM   2920  NE  ARG   222     -17.555  90.652   8.667  1.00 25.51           N  
ATOM   2922  CZ  ARG   222     -16.845  90.324   9.742  1.00 25.92           C  
ATOM   2923  NH1 ARG   222     -17.092  89.216  10.385  1.00 29.49           N  
ATOM   2926  NH2 ARG   222     -15.868  91.084  10.176  1.00 28.66           N  
ATOM   2929  C   ARG   222     -21.148  91.306  11.414  1.00 17.99           C  
ATOM   2930  O   ARG   222     -21.501  90.252  11.914  1.00 18.12           O  
ATOM   2932  N   ILE   223     -20.292  92.152  12.000  1.00 18.21           N  
ATOM   2933  CA  ILE   223     -19.815  91.929  13.376  1.00 17.43           C  
ATOM   2935  CB  ILE   223     -18.650  92.921  13.811  1.00 16.78           C  
ATOM   2937  CG1 ILE   223     -17.392  92.698  12.966  1.00 17.99           C  
ATOM   2940  CD1 ILE   223     -16.388  93.920  13.040  1.00 15.84           C  
ATOM   2944  CG2 ILE   223     -18.318  92.804  15.249  1.00 13.85           C  
ATOM   2948  C   ILE   223     -21.015  92.019  14.308  1.00 16.64           C  
ATOM   2949  O   ILE   223     -21.161  91.175  15.166  1.00 16.90           O  
ATOM   2951  N   ALA   224     -21.864  93.024  14.136  1.00 15.31           N  
ATOM   2952  CA  ALA   224     -22.905  93.273  15.158  1.00 15.78           C  
ATOM   2954  CB  ALA   224     -23.548  94.745  15.021  1.00 14.62           C  
ATOM   2958  C   ALA   224     -24.007  92.170  15.139  1.00 14.91           C  
ATOM   2959  O   ALA   224     -24.485  91.769  16.181  1.00 13.13           O  
ATOM   2961  N   ARG   225     -24.428  91.755  13.940  1.00 15.23           N  
ATOM   2962  CA  ARG   225     -25.376  90.669  13.750  1.00 16.23           C  
ATOM   2964  CB  ARG   225     -25.720  90.483  12.257  1.00 16.86           C  
ATOM   2967  CG  ARG   225     -26.643  91.504  11.776  1.00 20.23           C  
ATOM   2970  CD  ARG   225     -27.407  91.074  10.575  1.00 25.65           C  
ATOM   2973  NE  ARG   225     -27.654  92.232   9.717  1.00 29.44           N  
ATOM   2975  CZ  ARG   225     -26.869  92.596   8.698  1.00 32.85           C  
ATOM   2976  NH1 ARG   225     -25.752  91.896   8.383  1.00 32.04           N  
ATOM   2979  NH2 ARG   225     -27.211  93.666   7.980  1.00 32.54           N  
ATOM   2982  C   ARG   225     -24.836  89.365  14.231  1.00 16.34           C  
ATOM   2983  O   ARG   225     -25.607  88.558  14.761  1.00 18.15           O  
ATOM   2985  N   LYS   226     -23.546  89.096  13.984  1.00 15.65           N  
ATOM   2986  CA  LYS   226     -22.926  87.890  14.516  1.00 15.61           C  
ATOM   2988  CB  LYS   226     -21.485  87.748  14.104  1.00 15.11           C  
ATOM   2991  CG  LYS   226     -20.764  86.542  14.698  1.00 15.61           C  
ATOM   2994  CD  LYS   226     -21.543  85.216  14.583  1.00 14.54           C  
ATOM   2997  CE  LYS   226     -20.686  84.046  15.051  1.00 14.02           C  
ATOM   3000  NZ  LYS   226     -21.290  82.725  14.679  1.00 17.57           N  
ATOM   3004  C   LYS   226     -23.036  87.877  16.007  1.00 15.66           C  
ATOM   3005  O   LYS   226     -23.430  86.909  16.601  1.00 18.10           O  
ATOM   3007  N   ILE   227     -22.714  88.971  16.624  1.00 15.72           N  
ATOM   3008  CA  ILE   227     -22.786  89.054  18.077  1.00 15.33           C  
ATOM   3010  CB  ILE   227     -22.212  90.403  18.599  1.00 13.82           C  
ATOM   3012  CG1 ILE   227     -20.687  90.453  18.344  1.00 15.84           C  
ATOM   3015  CD1 ILE   227     -19.874  91.755  18.995  1.00  9.69           C  
ATOM   3019  CG2 ILE   227     -22.458  90.561  20.114  1.00 14.42           C  
ATOM   3023  C   ILE   227     -24.204  88.872  18.569  1.00 14.80           C  
ATOM   3024  O   ILE   227     -24.417  88.167  19.515  1.00 16.94           O  
ATOM   3026  N   ALA   228     -25.132  89.586  17.962  1.00 14.71           N  
ATOM   3027  CA  ALA   228     -26.551  89.567  18.275  1.00 15.02           C  
ATOM   3029  CB  ALA   228     -27.317  90.628  17.420  1.00 13.51           C  
ATOM   3033  C   ALA   228     -27.190  88.150  18.114  1.00 15.09           C  
ATOM   3034  O   ALA   228     -28.139  87.824  18.801  1.00 14.60           O  
ATOM   3036  N   SER   229     -26.619  87.346  17.220  1.00 15.04           N  
ATOM   3037  CA  SER   229     -26.992  85.970  17.044  1.00 14.66           C  
ATOM   3039  CB  SER   229     -26.544  85.498  15.676  1.00 14.33           C  
ATOM   3042  OG  SER   229     -25.239  85.032  15.696  1.00 13.00           O  
ATOM   3044  C   SER   229     -26.466  84.994  18.066  1.00 14.70           C  
ATOM   3045  O   SER   229     -26.821  83.830  17.973  1.00 14.93           O  
ATOM   3047  N   LEU   230     -25.578  85.424  18.958  1.00 13.97           N  
ATOM   3048  CA  LEU   230     -25.002  84.560  20.017  1.00 13.95           C  
ATOM   3050  CB  LEU   230     -23.507  84.855  20.251  1.00 13.31           C  
ATOM   3053  CG  LEU   230     -22.597  84.633  19.045  1.00 14.28           C  
ATOM   3055  CD1 LEU   230     -21.222  85.339  19.256  1.00 13.01           C  
ATOM   3059  CD2 LEU   230     -22.501  83.118  18.707  1.00 13.08           C  
ATOM   3063  C   LEU   230     -25.742  84.674  21.359  1.00 13.72           C  
ATOM   3064  O   LEU   230     -26.685  85.428  21.481  1.00 14.55           O  
ATOM   3066  N   SER   231     -25.347  83.875  22.355  1.00 13.96           N  
ATOM   3067  CA  SER   231     -25.977  83.950  23.669  1.00 13.31           C  
ATOM   3069  CB  SER   231     -25.675  82.726  24.476  1.00 12.96           C  
ATOM   3072  OG  SER   231     -25.981  82.958  25.830  1.00 11.33           O  
ATOM   3074  C   SER   231     -25.474  85.149  24.455  1.00 14.36           C  
ATOM   3075  O   SER   231     -24.297  85.218  24.802  1.00 15.12           O  
ATOM   3077  N   ARG   232     -26.377  86.069  24.786  1.00 14.66           N  
ATOM   3078  CA  ARG   232     -26.082  87.204  25.635  1.00 14.70           C  
ATOM   3080  CB  ARG   232     -27.326  88.030  25.937  1.00 13.46           C  
ATOM   3083  CG  ARG   232     -27.017  89.470  26.314  1.00 17.14           C  
ATOM   3086  CD  ARG   232     -28.102  90.058  27.218  1.00 21.44           C  
ATOM   3089  NE  ARG   232     -28.145  91.520  27.275  1.00 21.71           N  
ATOM   3091  CZ  ARG   232     -27.828  92.273  28.328  1.00 22.46           C  
ATOM   3092  NH1 ARG   232     -27.369  91.776  29.447  1.00 21.91           N  
ATOM   3095  NH2 ARG   232     -27.968  93.569  28.244  1.00 23.29           N  
ATOM   3098  C   ARG   232     -25.338  86.860  26.938  1.00 14.71           C  
ATOM   3099  O   ARG   232     -24.340  87.502  27.257  1.00 13.88           O  
ATOM   3101  N   PRO   233     -25.867  85.896  27.722  1.00 14.43           N  
ATOM   3102  CA  PRO   233     -25.228  85.611  28.983  1.00 13.83           C  
ATOM   3104  CB  PRO   233     -26.102  84.491  29.580  1.00 14.19           C  
ATOM   3107  CG  PRO   233     -27.290  84.370  28.758  1.00 13.80           C  
ATOM   3110  CD  PRO   233     -27.240  85.363  27.675  1.00 14.09           C  
ATOM   3113  C   PRO   233     -23.801  85.114  28.839  1.00 13.34           C  
ATOM   3114  O   PRO   233     -23.005  85.352  29.723  1.00 12.86           O  
ATOM   3115  N   VAL   234     -23.543  84.351  27.783  1.00 13.00           N  
ATOM   3116  CA  VAL   234     -22.222  83.802  27.500  1.00 13.12           C  
ATOM   3118  CB  VAL   234     -22.283  82.699  26.360  1.00 12.47           C  
ATOM   3120  CG1 VAL   234     -20.899  82.314  25.915  1.00  9.51           C  
ATOM   3124  CG2 VAL   234     -23.111  81.439  26.806  1.00 10.98           C  
ATOM   3128  C   VAL   234     -21.274  84.930  27.067  1.00 13.09           C  
ATOM   3129  O   VAL   234     -20.191  85.036  27.547  1.00 13.33           O  
ATOM   3131  N   VAL   235     -21.689  85.752  26.133  1.00 14.01           N  
ATOM   3132  CA  VAL   235     -20.871  86.882  25.672  1.00 14.81           C  
ATOM   3134  CB  VAL   235     -21.580  87.617  24.549  1.00 15.64           C  
ATOM   3136  CG1 VAL   235     -20.888  88.953  24.200  1.00 14.07           C  
ATOM   3140  CG2 VAL   235     -21.757  86.690  23.319  1.00 13.59           C  
ATOM   3144  C   VAL   235     -20.532  87.894  26.794  1.00 15.71           C  
ATOM   3145  O   VAL   235     -19.423  88.402  26.881  1.00 16.32           O  
ATOM   3147  N   SER   236     -21.491  88.121  27.674  1.00 16.30           N  
ATOM   3148  CA  SER   236     -21.417  89.115  28.709  1.00 16.39           C  
ATOM   3150  CB  SER   236     -22.835  89.340  29.250  1.00 16.90           C  
ATOM   3153  OG  SER   236     -22.921  90.286  30.306  1.00 20.09           O  
ATOM   3155  C   SER   236     -20.462  88.584  29.737  1.00 16.69           C  
ATOM   3156  O   SER   236     -19.653  89.322  30.190  1.00 18.06           O  
ATOM   3158  N   LEU   237     -20.565  87.295  30.083  1.00 16.27           N  
ATOM   3159  CA  LEU   237     -19.587  86.612  30.929  1.00 17.16           C  
ATOM   3161  CB  LEU   237     -20.034  85.167  31.247  1.00 17.51           C  
ATOM   3164  CG  LEU   237     -19.106  84.168  31.956  1.00 19.83           C  
ATOM   3166  CD1 LEU   237     -18.622  84.648  33.318  1.00 19.20           C  
ATOM   3170  CD2 LEU   237     -19.818  82.837  32.074  1.00 19.68           C  
ATOM   3174  C   LEU   237     -18.180  86.661  30.363  1.00 16.23           C  
ATOM   3175  O   LEU   237     -17.212  86.905  31.056  1.00 18.33           O  
ATOM   3177  N   GLY   238     -18.060  86.514  29.096  1.00 16.08           N  
ATOM   3178  CA  GLY   238     -16.758  86.513  28.507  1.00 16.44           C  
ATOM   3181  C   GLY   238     -16.094  87.852  28.509  1.00 15.20           C  
ATOM   3182  O   GLY   238     -14.926  87.918  28.808  1.00 15.04           O  
ATOM   3184  N   LYS   239     -16.828  88.867  28.078  1.00 15.89           N  
ATOM   3185  CA  LYS   239     -16.419  90.266  28.169  1.00 16.50           C  
ATOM   3187  CB  LYS   239     -17.515  91.213  27.587  1.00 17.97           C  
ATOM   3190  CG  LYS   239     -17.029  92.699  27.384  1.00 18.21           C  
ATOM   3193  CD  LYS   239     -18.095  93.714  27.203  1.00 15.23           C  
ATOM   3196  CE  LYS   239     -17.708  95.153  27.709  1.00 10.64           C  
ATOM   3199  NZ  LYS   239     -18.208  96.049  26.514  1.00 16.19           N  
ATOM   3203  C   LYS   239     -15.999  90.654  29.600  1.00 16.17           C  
ATOM   3204  O   LYS   239     -14.903  91.093  29.831  1.00 16.15           O  
ATOM   3206  N   ALA   240     -16.780  90.336  30.599  1.00 15.24           N  
ATOM   3207  CA  ALA   240     -16.382  90.754  31.931  1.00 14.55           C  
ATOM   3209  CB  ALA   240     -17.478  90.623  32.863  1.00 11.62           C  
ATOM   3213  C   ALA   240     -15.141  90.006  32.384  1.00 13.86           C  
ATOM   3214  O   ALA   240     -14.248  90.599  32.951  1.00 15.79           O  
ATOM   3216  N   THR   241     -15.070  88.721  32.062  1.00 13.46           N  
ATOM   3217  CA  THR   241     -13.985  87.878  32.402  1.00 12.24           C  
ATOM   3219  CB  THR   241     -14.328  86.380  32.117  1.00 13.61           C  
ATOM   3221  OG1 THR   241     -15.406  85.981  32.992  1.00 15.52           O  
ATOM   3223  CG2 THR   241     -13.110  85.445  32.439  1.00 12.03           C  
ATOM   3227  C   THR   241     -12.727  88.295  31.722  1.00 11.59           C  
ATOM   3228  O   THR   241     -11.692  88.273  32.327  1.00 10.25           O  
ATOM   3230  N   PHE   242     -12.819  88.652  30.458  1.00 11.97           N  
ATOM   3231  CA  PHE   242     -11.683  89.104  29.711  1.00 12.96           C  
ATOM   3233  CB  PHE   242     -12.092  89.523  28.344  1.00 12.42           C  
ATOM   3236  CG  PHE   242     -10.966  90.007  27.513  1.00 12.68           C  
ATOM   3237  CD1 PHE   242     -10.713  91.357  27.407  1.00 13.62           C  
ATOM   3239  CE1 PHE   242      -9.715  91.828  26.562  1.00 13.23           C  
ATOM   3241  CZ  PHE   242      -8.919  90.920  25.868  1.00 12.41           C  
ATOM   3243  CE2 PHE   242      -9.200  89.558  25.959  1.00 10.91           C  
ATOM   3245  CD2 PHE   242     -10.225  89.123  26.740  1.00 12.57           C  
ATOM   3247  C   PHE   242     -10.934  90.303  30.299  1.00 14.50           C  
ATOM   3248  O   PHE   242      -9.765  90.195  30.532  1.00 15.76           O  
ATOM   3250  N   TYR   243     -11.640  91.390  30.554  1.00 14.86           N  
ATOM   3251  CA  TYR   243     -11.114  92.582  31.220  1.00 15.32           C  
ATOM   3253  CB  TYR   243     -12.134  93.734  31.143  1.00 14.14           C  
ATOM   3256  CG  TYR   243     -12.354  94.274  29.730  1.00 15.55           C  
ATOM   3257  CD1 TYR   243     -11.319  94.883  29.058  1.00 12.40           C  
ATOM   3259  CE1 TYR   243     -11.455  95.424  27.797  1.00 16.47           C  
ATOM   3261  CZ  TYR   243     -12.617  95.329  27.133  1.00 15.94           C  
ATOM   3262  OH  TYR   243     -12.637  95.883  25.838  1.00 15.54           O  
ATOM   3264  CE2 TYR   243     -13.680  94.684  27.764  1.00 14.41           C  
ATOM   3266  CD2 TYR   243     -13.534  94.161  29.084  1.00 13.42           C  
ATOM   3268  C   TYR   243     -10.670  92.310  32.671  1.00 16.25           C  
ATOM   3269  O   TYR   243      -9.749  92.925  33.144  1.00 16.82           O  
ATOM   3271  N   LYS   244     -11.264  91.348  33.348  1.00 16.35           N  
ATOM   3272  CA  LYS   244     -10.777  90.987  34.700  1.00 16.38           C  
ATOM   3274  CB  LYS   244     -11.820  90.081  35.389  1.00 16.55           C  
ATOM   3277  CG  LYS   244     -11.793  90.174  36.865  1.00 20.30           C  
ATOM   3280  CD  LYS   244     -12.806  89.117  37.468  1.00 25.79           C  
ATOM   3283  CE  LYS   244     -12.569  88.804  39.009  1.00 28.29           C  
ATOM   3286  NZ  LYS   244     -13.477  87.694  39.518  1.00 28.12           N  
ATOM   3290  C   LYS   244      -9.410  90.248  34.688  1.00 15.29           C  
ATOM   3291  O   LYS   244      -8.528  90.525  35.467  1.00 14.12           O  
ATOM   3293  N   GLN   245      -9.248  89.308  33.776  1.00 15.77           N  
ATOM   3294  CA  GLN   245      -7.989  88.560  33.697  1.00 15.47           C  
ATOM   3296  CB  GLN   245      -8.114  87.323  32.799  1.00 14.94           C  
ATOM   3299  CG  GLN   245      -7.017  87.396  31.590  1.00 18.39           C  
ATOM   3302  CD  GLN   245      -7.719  87.433  30.399  1.00 18.97           C  
ATOM   3303  OE1 GLN   245      -8.889  87.273  30.462  1.00 24.01           O  
ATOM   3304  NE2 GLN   245      -7.090  87.566  29.311  1.00 18.44           N  
ATOM   3307  C   GLN   245      -6.885  89.413  33.107  1.00 15.01           C  
ATOM   3308  O   GLN   245      -5.733  89.199  33.387  1.00 13.93           O  
ATOM   3310  N   LEU   246      -7.258  90.292  32.180  1.00 16.78           N  
ATOM   3311  CA  LEU   246      -6.298  91.061  31.371  1.00 17.22           C  
ATOM   3313  CB  LEU   246      -7.069  92.069  30.605  1.00 17.45           C  
ATOM   3316  CG  LEU   246      -6.403  92.874  29.529  1.00 20.60           C  
ATOM   3318  CD1 LEU   246      -5.967  91.855  28.487  1.00 22.49           C  
ATOM   3322  CD2 LEU   246      -7.388  93.904  28.998  1.00 16.43           C  
ATOM   3326  C   LEU   246      -5.093  91.680  32.177  1.00 18.13           C  
ATOM   3327  O   LEU   246      -3.938  91.531  31.774  1.00 18.88           O  
ATOM   3329  N   PRO   247      -5.333  92.340  33.329  1.00 18.64           N  
ATOM   3330  CA  PRO   247      -4.169  92.804  34.081  1.00 18.65           C  
ATOM   3332  CB  PRO   247      -4.741  93.912  34.974  1.00 17.74           C  
ATOM   3335  CG  PRO   247      -6.112  93.627  35.135  1.00 18.41           C  
ATOM   3338  CD  PRO   247      -6.556  93.003  33.811  1.00 19.01           C  
ATOM   3341  C   PRO   247      -3.396  91.784  34.952  1.00 19.87           C  
ATOM   3342  O   PRO   247      -2.301  92.108  35.476  1.00 20.11           O  
ATOM   3343  N   GLN   248      -3.908  90.562  35.094  1.00 20.48           N  
ATOM   3344  CA  GLN   248      -3.413  89.685  36.130  1.00 20.67           C  
ATOM   3346  CB  GLN   248      -4.487  88.670  36.579  1.00 21.09           C  
ATOM   3349  CG  GLN   248      -5.791  89.254  36.862  1.00 20.16           C  
ATOM   3352  CD  GLN   248      -5.799  90.117  38.103  1.00 26.42           C  
ATOM   3353  OE1 GLN   248      -4.919  90.034  38.985  1.00 23.30           O  
ATOM   3354  NE2 GLN   248      -6.806  91.009  38.161  1.00 28.22           N  
ATOM   3357  C   GLN   248      -2.121  88.964  35.708  1.00 20.75           C  
ATOM   3358  O   GLN   248      -1.780  88.867  34.510  1.00 19.58           O  
ATOM   3360  N   ASP   249      -1.413  88.450  36.702  1.00 20.17           N  
ATOM   3361  CA  ASP   249      -0.324  87.538  36.403  1.00 21.64           C  
ATOM   3363  CB  ASP   249       0.532  87.195  37.647  1.00 22.42           C  
ATOM   3366  CG  ASP   249      -0.261  86.474  38.694  1.00 28.62           C  
ATOM   3367  OD1 ASP   249      -0.074  85.217  38.892  1.00 31.83           O  
ATOM   3368  OD2 ASP   249      -1.128  87.196  39.299  1.00 39.50           O  
ATOM   3369  C   ASP   249      -0.984  86.323  35.784  1.00 20.60           C  
ATOM   3370  O   ASP   249      -2.208  86.167  35.860  1.00 20.05           O  
ATOM   3372  N   LEU   250      -0.177  85.507  35.114  1.00 20.00           N  
ATOM   3373  CA  LEU   250      -0.673  84.453  34.241  1.00 18.80           C  
ATOM   3375  CB  LEU   250       0.477  83.835  33.449  1.00 19.27           C  
ATOM   3378  CG  LEU   250       0.119  82.967  32.259  1.00 19.48           C  
ATOM   3380  CD1 LEU   250      -0.528  83.830  31.155  1.00 20.42           C  
ATOM   3384  CD2 LEU   250       1.330  82.171  31.789  1.00 17.80           C  
ATOM   3388  C   LEU   250      -1.376  83.361  35.029  1.00 18.49           C  
ATOM   3389  O   LEU   250      -2.352  82.795  34.533  1.00 18.34           O  
ATOM   3391  N   GLY   251      -0.875  83.066  36.229  1.00 16.28           N  
ATOM   3392  CA  GLY   251      -1.447  82.076  37.077  1.00 15.57           C  
ATOM   3395  C   GLY   251      -2.828  82.465  37.580  1.00 15.10           C  
ATOM   3396  O   GLY   251      -3.757  81.628  37.611  1.00 15.44           O  
ATOM   3398  N   THR   252      -2.945  83.716  37.996  1.00 14.03           N  
ATOM   3399  CA  THR   252      -4.185  84.305  38.399  1.00 13.88           C  
ATOM   3401  CB  THR   252      -3.944  85.646  39.134  1.00 15.01           C  
ATOM   3403  OG1 THR   252      -3.006  85.385  40.184  1.00 12.61           O  
ATOM   3405  CG2 THR   252      -5.340  86.288  39.751  1.00 12.60           C  
ATOM   3409  C   THR   252      -5.130  84.406  37.241  1.00 14.87           C  
ATOM   3410  O   THR   252      -6.259  84.000  37.378  1.00 15.33           O  
ATOM   3412  N   ALA   253      -4.655  84.828  36.065  1.00 14.38           N  
ATOM   3413  CA  ALA   253      -5.496  84.872  34.908  1.00 14.68           C  
ATOM   3415  CB  ALA   253      -4.714  85.445  33.683  1.00 15.06           C  
ATOM   3419  C   ALA   253      -6.143  83.479  34.561  1.00 14.62           C  
ATOM   3420  O   ALA   253      -7.320  83.411  34.210  1.00 13.54           O  
ATOM   3422  N   TYR   254      -5.356  82.409  34.577  1.00 14.50           N  
ATOM   3423  CA  TYR   254      -5.859  81.065  34.383  1.00 14.79           C  
ATOM   3425  CB  TYR   254      -4.716  80.100  34.134  1.00 15.25           C  
ATOM   3428  CG  TYR   254      -4.192  80.157  32.758  1.00 13.84           C  
ATOM   3429  CD1 TYR   254      -5.070  80.061  31.662  1.00 16.28           C  
ATOM   3431  CE1 TYR   254      -4.607  80.141  30.368  1.00 16.44           C  
ATOM   3433  CZ  TYR   254      -3.268  80.253  30.147  1.00 14.73           C  
ATOM   3434  OH  TYR   254      -2.877  80.309  28.861  1.00 18.19           O  
ATOM   3436  CE2 TYR   254      -2.368  80.324  31.198  1.00 14.89           C  
ATOM   3438  CD2 TYR   254      -2.831  80.265  32.512  1.00 12.77           C  
ATOM   3440  C   TYR   254      -6.724  80.542  35.527  1.00 15.00           C  
ATOM   3441  O   TYR   254      -7.642  79.776  35.312  1.00 15.40           O  
ATOM   3443  N   TYR   255      -6.440  80.932  36.751  1.00 15.03           N  
ATOM   3444  CA  TYR   255      -7.344  80.591  37.789  1.00 14.99           C  
ATOM   3446  CB  TYR   255      -6.833  81.081  39.104  1.00 15.52           C  
ATOM   3449  CG  TYR   255      -7.879  80.974  40.148  1.00 19.34           C  
ATOM   3450  CD1 TYR   255      -8.102  79.764  40.844  1.00 21.68           C  
ATOM   3452  CE1 TYR   255      -9.139  79.674  41.783  1.00 22.89           C  
ATOM   3454  CZ  TYR   255      -9.939  80.792  41.976  1.00 23.33           C  
ATOM   3455  OH  TYR   255     -10.919  80.817  42.835  1.00 24.14           O  
ATOM   3457  CE2 TYR   255      -9.724  81.964  41.319  1.00 25.42           C  
ATOM   3459  CD2 TYR   255      -8.699  82.058  40.410  1.00 22.49           C  
ATOM   3461  C   TYR   255      -8.754  81.195  37.503  1.00 15.19           C  
ATOM   3462  O   TYR   255      -9.736  80.511  37.620  1.00 14.55           O  
ATOM   3464  N   LEU   256      -8.812  82.475  37.158  1.00 14.24           N  
ATOM   3465  CA  LEU   256     -10.017  83.180  37.100  1.00 15.51           C  
ATOM   3467  CB  LEU   256      -9.734  84.674  36.952  1.00 16.92           C  
ATOM   3470  CG  LEU   256      -9.208  85.548  38.092  1.00 18.49           C  
ATOM   3472  CD1 LEU   256      -8.906  86.875  37.472  1.00 16.42           C  
ATOM   3476  CD2 LEU   256     -10.166  85.652  39.328  1.00 19.57           C  
ATOM   3480  C   LEU   256     -10.854  82.698  35.902  1.00 15.68           C  
ATOM   3481  O   LEU   256     -12.043  82.522  36.037  1.00 15.03           O  
ATOM   3483  N   THR   257     -10.192  82.508  34.753  1.00 14.98           N  
ATOM   3484  CA  THR   257     -10.842  82.158  33.517  1.00 14.81           C  
ATOM   3486  CB  THR   257      -9.958  82.396  32.294  1.00 14.89           C  
ATOM   3488  OG1 THR   257      -8.706  81.722  32.460  1.00 13.21           O  
ATOM   3490  CG2 THR   257      -9.800  83.882  31.997  1.00 11.04           C  
ATOM   3494  C   THR   257     -11.281  80.721  33.548  1.00 16.93           C  
ATOM   3495  O   THR   257     -12.344  80.371  33.014  1.00 16.73           O  
ATOM   3497  N   SER   258     -10.521  79.865  34.207  1.00 17.51           N  
ATOM   3498  CA  SER   258     -10.950  78.510  34.160  1.00 19.01           C  
ATOM   3500  CB  SER   258      -9.773  77.512  34.338  1.00 20.45           C  
ATOM   3503  OG  SER   258      -9.316  77.509  35.639  1.00 23.59           O  
ATOM   3505  C   SER   258     -12.126  78.347  35.096  1.00 18.67           C  
ATOM   3506  O   SER   258     -12.997  77.493  34.873  1.00 19.57           O  
ATOM   3508  N   GLN   259     -12.238  79.196  36.099  1.00 18.69           N  
ATOM   3509  CA  GLN   259     -13.425  79.165  36.941  1.00 18.71           C  
ATOM   3511  CB  GLN   259     -13.208  79.943  38.205  1.00 18.89           C  
ATOM   3514  CG  GLN   259     -14.436  79.924  39.121  1.00 22.10           C  
ATOM   3517  CD  GLN   259     -14.809  78.488  39.619  1.00 24.17           C  
ATOM   3518  OE1 GLN   259     -13.960  77.763  40.195  1.00 22.27           O  
ATOM   3519  NE2 GLN   259     -16.071  78.093  39.390  1.00 22.64           N  
ATOM   3522  C   GLN   259     -14.587  79.783  36.160  1.00 18.68           C  
ATOM   3523  O   GLN   259     -15.716  79.404  36.341  1.00 19.98           O  
ATOM   3525  N   ALA   260     -14.316  80.713  35.267  1.00 18.49           N  
ATOM   3526  CA  ALA   260     -15.406  81.299  34.466  1.00 18.88           C  
ATOM   3528  CB  ALA   260     -15.008  82.587  33.917  1.00 18.05           C  
ATOM   3532  C   ALA   260     -15.893  80.294  33.379  1.00 18.43           C  
ATOM   3533  O   ALA   260     -17.078  80.236  33.047  1.00 17.88           O  
ATOM   3535  N   MET   261     -14.978  79.454  32.908  1.00 18.66           N  
ATOM   3536  CA  MET   261     -15.300  78.339  31.995  1.00 18.55           C  
ATOM   3538  CB  MET   261     -14.077  77.513  31.682  1.00 18.31           C  
ATOM   3541  CG  MET   261     -12.985  78.116  30.788  1.00 19.81           C  
ATOM   3544  SD  MET   261     -13.333  78.793  29.199  1.00 24.11           S  
ATOM   3545  CE  MET   261     -13.440  77.476  27.984  1.00 22.07           C  
ATOM   3549  C   MET   261     -16.319  77.398  32.622  1.00 18.09           C  
ATOM   3550  O   MET   261     -17.343  77.105  32.020  1.00 19.07           O  
ATOM   3552  N   VAL   262     -16.034  76.975  33.848  1.00 16.44           N  
ATOM   3553  CA  VAL   262     -16.888  76.112  34.624  1.00 15.77           C  
ATOM   3555  CB  VAL   262     -16.200  75.694  35.943  1.00 15.84           C  
ATOM   3557  CG1 VAL   262     -17.195  74.963  36.905  1.00 10.46           C  
ATOM   3561  CG2 VAL   262     -14.950  74.872  35.667  1.00 12.61           C  
ATOM   3565  C   VAL   262     -18.271  76.701  34.953  1.00 15.92           C  
ATOM   3566  O   VAL   262     -19.238  75.990  34.974  1.00 16.64           O  
ATOM   3568  N   ASP   263     -18.333  77.983  35.207  1.00 16.40           N  
ATOM   3569  CA  ASP   263     -19.572  78.720  35.391  1.00 16.92           C  
ATOM   3571  CB  ASP   263     -19.275  80.120  35.913  1.00 17.37           C  
ATOM   3574  CG  ASP   263     -18.690  80.097  37.320  1.00 19.14           C  
ATOM   3575  OD1 ASP   263     -18.804  79.022  37.926  1.00 25.39           O  
ATOM   3576  OD2 ASP   263     -18.098  81.107  37.802  1.00 20.04           O  
ATOM   3577  C   ASP   263     -20.375  78.808  34.110  1.00 16.33           C  
ATOM   3578  O   ASP   263     -21.570  78.606  34.126  1.00 16.76           O  
ATOM   3580  N   ASN   264     -19.687  79.048  33.004  1.00 15.92           N  
ATOM   3581  CA  ASN   264     -20.274  79.069  31.690  1.00 15.30           C  
ATOM   3583  CB  ASN   264     -19.179  79.430  30.683  1.00 15.94           C  
ATOM   3586  CG  ASN   264     -19.681  79.765  29.305  1.00 14.46           C  
ATOM   3587  OD1 ASN   264     -19.042  80.515  28.614  1.00 16.93           O  
ATOM   3588  ND2 ASN   264     -20.783  79.191  28.879  1.00 14.75           N  
ATOM   3591  C   ASN   264     -20.957  77.726  31.372  1.00 15.74           C  
ATOM   3592  O   ASN   264     -22.060  77.715  30.858  1.00 15.98           O  
ATOM   3594  N   LEU   265     -20.324  76.602  31.710  1.00 16.14           N  
ATOM   3595  CA  LEU   265     -20.868  75.318  31.446  1.00 15.32           C  
ATOM   3597  CB  LEU   265     -19.814  74.195  31.668  1.00 16.07           C  
ATOM   3600  CG  LEU   265     -18.634  74.140  30.675  1.00 14.27           C  
ATOM   3602  CD1 LEU   265     -17.518  73.185  31.107  1.00  9.14           C  
ATOM   3606  CD2 LEU   265     -19.115  73.927  29.252  1.00 12.77           C  
ATOM   3610  C   LEU   265     -22.099  75.049  32.309  1.00 15.67           C  
ATOM   3611  O   LEU   265     -22.898  74.250  31.941  1.00 15.91           O  
ATOM   3613  N   ALA   266     -22.239  75.676  33.467  1.00 15.88           N  
ATOM   3614  CA  ALA   266     -23.431  75.504  34.285  1.00 15.50           C  
ATOM   3616  CB  ALA   266     -23.122  75.784  35.754  1.00 14.19           C  
ATOM   3620  C   ALA   266     -24.614  76.401  33.769  1.00 16.61           C  
ATOM   3621  O   ALA   266     -25.738  76.291  34.266  1.00 16.60           O  
ATOM   3623  N   LEU   267     -24.382  77.272  32.781  1.00 16.32           N  
ATOM   3624  CA  LEU   267     -25.447  78.054  32.195  1.00 16.65           C  
ATOM   3626  CB  LEU   267     -24.914  79.299  31.429  1.00 17.03           C  
ATOM   3629  CG  LEU   267     -24.228  80.408  32.217  1.00 17.15           C  
ATOM   3631  CD1 LEU   267     -23.640  81.476  31.313  1.00 12.98           C  
ATOM   3635  CD2 LEU   267     -25.132  81.019  33.292  1.00 14.52           C  
ATOM   3639  C   LEU   267     -26.178  77.128  31.232  1.00 17.07           C  
ATOM   3640  O   LEU   267     -25.582  76.228  30.646  1.00 17.69           O  
ATOM   3642  N   ARG   268     -27.473  77.364  31.082  1.00 16.98           N  
ATOM   3643  CA  ARG   268     -28.336  76.672  30.128  1.00 17.74           C  
ATOM   3645  CB  ARG   268     -29.730  77.295  30.330  1.00 18.23           C  
ATOM   3648  CG  ARG   268     -30.855  76.676  29.614  1.00 21.78           C  
ATOM   3651  CD  ARG   268     -30.990  77.293  28.258  1.00 26.34           C  
ATOM   3654  NE  ARG   268     -31.884  76.548  27.390  1.00 30.79           N  
ATOM   3656  CZ  ARG   268     -31.983  76.756  26.076  1.00 32.50           C  
ATOM   3657  NH1 ARG   268     -31.216  77.703  25.475  1.00 29.98           N  
ATOM   3660  NH2 ARG   268     -32.836  76.001  25.367  1.00 30.43           N  
ATOM   3663  C   ARG   268     -27.826  76.820  28.665  1.00 17.31           C  
ATOM   3664  O   ARG   268     -27.837  75.900  27.899  1.00 17.30           O  
ATOM   3666  N   ASP   269     -27.377  77.998  28.287  1.00 17.77           N  
ATOM   3667  CA  ASP   269     -26.942  78.251  26.925  1.00 18.13           C  
ATOM   3669  CB  ASP   269     -26.851  79.743  26.725  1.00 19.45           C  
ATOM   3672  CG  ASP   269     -28.164  80.409  26.320  1.00 17.68           C  
ATOM   3673  OD1 ASP   269     -29.168  79.790  25.997  1.00 18.62           O  
ATOM   3674  OD2 ASP   269     -28.133  81.617  26.257  1.00 16.65           O  
ATOM   3675  C   ASP   269     -25.548  77.623  26.684  1.00 18.82           C  
ATOM   3676  O   ASP   269     -25.176  77.266  25.543  1.00 18.49           O  
ATOM   3678  N   GLY   270     -24.790  77.458  27.777  1.00 18.28           N  
ATOM   3679  CA  GLY   270     -23.562  76.661  27.751  1.00 17.69           C  
ATOM   3682  C   GLY   270     -23.852  75.286  27.241  1.00 17.52           C  
ATOM   3683  O   GLY   270     -23.225  74.812  26.280  1.00 18.29           O  
ATOM   3685  N   GLN   271     -24.819  74.639  27.885  1.00 17.84           N  
ATOM   3686  CA  GLN   271     -25.207  73.296  27.537  1.00 17.31           C  
ATOM   3688  CB  GLN   271     -25.973  72.655  28.703  1.00 17.49           C  
ATOM   3691  CG  GLN   271     -25.071  72.463  29.977  1.00 18.55           C  
ATOM   3694  CD  GLN   271     -23.775  71.619  29.698  1.00 18.76           C  
ATOM   3695  OE1 GLN   271     -23.842  70.600  29.025  1.00 20.90           O  
ATOM   3696  NE2 GLN   271     -22.624  72.066  30.194  1.00 15.37           N  
ATOM   3699  C   GLN   271     -25.941  73.174  26.193  1.00 16.72           C  
ATOM   3700  O   GLN   271     -25.699  72.242  25.442  1.00 16.67           O  
ATOM   3702  N   GLU   272     -26.829  74.108  25.895  1.00 17.32           N  
ATOM   3703  CA  GLU   272     -27.521  74.164  24.607  1.00 17.29           C  
ATOM   3705  CB  GLU   272     -28.480  75.358  24.574  1.00 17.40           C  
ATOM   3708  CG  GLU   272     -28.998  75.747  23.148  1.00 19.96           C  
ATOM   3711  CD  GLU   272     -29.833  74.641  22.410  1.00 19.67           C  
ATOM   3712  OE1 GLU   272     -30.244  73.631  23.037  1.00 19.02           O  
ATOM   3713  OE2 GLU   272     -30.084  74.812  21.193  1.00 18.08           O  
ATOM   3714  C   GLU   272     -26.555  74.227  23.413  1.00 16.62           C  
ATOM   3715  O   GLU   272     -26.725  73.488  22.466  1.00 15.91           O  
ATOM   3717  N   GLY   273     -25.555  75.117  23.492  1.00 17.41           N  
ATOM   3718  CA  GLY   273     -24.539  75.293  22.451  1.00 17.27           C  
ATOM   3721  C   GLY   273     -23.666  74.056  22.206  1.00 17.16           C  
ATOM   3722  O   GLY   273     -23.317  73.733  21.071  1.00 16.15           O  
ATOM   3724  N   ILE   274     -23.308  73.387  23.294  1.00 17.85           N  
ATOM   3725  CA  ILE   274     -22.526  72.165  23.271  1.00 19.06           C  
ATOM   3727  CB  ILE   274     -21.965  71.803  24.700  1.00 20.04           C  
ATOM   3729  CG1 ILE   274     -20.767  72.698  25.052  1.00 20.56           C  
ATOM   3732  CD1 ILE   274     -20.268  72.442  26.378  1.00 24.29           C  
ATOM   3736  CG2 ILE   274     -21.544  70.337  24.768  1.00 20.49           C  
ATOM   3740  C   ILE   274     -23.321  70.991  22.749  1.00 19.34           C  
ATOM   3741  O   ILE   274     -22.837  70.265  21.902  1.00 19.77           O  
ATOM   3743  N   THR   275     -24.537  70.812  23.252  1.00 19.54           N  
ATOM   3744  CA  THR   275     -25.437  69.803  22.733  1.00 19.78           C  
ATOM   3746  CB  THR   275     -26.806  69.815  23.470  1.00 20.28           C  
ATOM   3748  OG1 THR   275     -26.611  69.587  24.863  1.00 21.73           O  
ATOM   3750  CG2 THR   275     -27.735  68.761  22.930  1.00 18.40           C  
ATOM   3754  C   THR   275     -25.727  70.000  21.262  1.00 19.91           C  
ATOM   3755  O   THR   275     -25.693  69.038  20.506  1.00 21.60           O  
ATOM   3757  N   ALA   276     -26.076  71.228  20.875  1.00 19.52           N  
ATOM   3758  CA  ALA   276     -26.407  71.585  19.489  1.00 18.65           C  
ATOM   3760  CB  ALA   276     -26.728  73.068  19.429  1.00 17.36           C  
ATOM   3764  C   ALA   276     -25.258  71.240  18.517  1.00 19.26           C  
ATOM   3765  O   ALA   276     -25.469  70.783  17.380  1.00 19.23           O  
ATOM   3767  N   PHE   277     -24.029  71.444  18.971  1.00 19.66           N  
ATOM   3768  CA  PHE   277     -22.870  71.099  18.186  1.00 20.30           C  
ATOM   3770  CB  PHE   277     -21.613  71.656  18.854  1.00 20.07           C  
ATOM   3773  CG  PHE   277     -20.359  71.194  18.214  1.00 22.83           C  
ATOM   3774  CD1 PHE   277     -20.029  71.616  16.931  1.00 25.86           C  
ATOM   3776  CE1 PHE   277     -18.862  71.144  16.298  1.00 27.11           C  
ATOM   3778  CZ  PHE   277     -18.010  70.240  16.980  1.00 26.89           C  
ATOM   3780  CE2 PHE   277     -18.342  69.809  18.256  1.00 26.23           C  
ATOM   3782  CD2 PHE   277     -19.509  70.296  18.871  1.00 25.89           C  
ATOM   3784  C   PHE   277     -22.779  69.579  17.984  1.00 20.38           C  
ATOM   3785  O   PHE   277     -22.504  69.102  16.886  1.00 19.55           O  
ATOM   3787  N   LEU   278     -23.013  68.843  19.071  1.00 20.79           N  
ATOM   3788  CA  LEU   278     -22.844  67.397  19.108  1.00 21.08           C  
ATOM   3790  CB  LEU   278     -22.720  66.870  20.558  1.00 20.99           C  
ATOM   3793  CG  LEU   278     -21.467  67.170  21.381  1.00 20.36           C  
ATOM   3795  CD1 LEU   278     -21.608  66.644  22.840  1.00 19.50           C  
ATOM   3799  CD2 LEU   278     -20.252  66.596  20.706  1.00 18.64           C  
ATOM   3803  C   LEU   278     -23.997  66.704  18.399  1.00 21.38           C  
ATOM   3804  O   LEU   278     -23.825  65.598  17.905  1.00 21.01           O  
ATOM   3806  N   GLN   279     -25.159  67.361  18.341  1.00 22.27           N  
ATOM   3807  CA  GLN   279     -26.312  66.874  17.553  1.00 22.83           C  
ATOM   3809  CB  GLN   279     -27.623  67.193  18.283  1.00 22.82           C  
ATOM   3812  CG  GLN   279     -27.835  66.311  19.523  1.00 25.24           C  
ATOM   3815  CD  GLN   279     -29.040  66.716  20.406  1.00 27.57           C  
ATOM   3816  OE1 GLN   279     -29.729  67.711  20.150  1.00 28.31           O  
ATOM   3817  NE2 GLN   279     -29.258  65.953  21.479  1.00 28.92           N  
ATOM   3820  C   GLN   279     -26.344  67.425  16.111  1.00 23.07           C  
ATOM   3821  O   GLN   279     -27.294  67.172  15.363  1.00 23.70           O  
ATOM   3823  N   LYS   280     -25.300  68.156  15.716  1.00 23.50           N  
ATOM   3824  CA  LYS   280     -25.191  68.726  14.367  1.00 23.46           C  
ATOM   3826  CB  LYS   280     -25.006  67.613  13.320  1.00 23.78           C  
ATOM   3829  CG  LYS   280     -23.797  66.668  13.546  1.00 25.09           C  
ATOM   3832  CD  LYS   280     -22.483  67.422  13.608  1.00 23.65           C  
ATOM   3837  C   LYS   280     -26.390  69.612  14.000  1.00 23.14           C  
ATOM   3838  O   LYS   280     -26.873  69.578  12.878  1.00 23.12           O  
ATOM   3840  N   ARG   281     -26.859  70.411  14.955  1.00 23.19           N  
ATOM   3841  CA  ARG   281     -27.938  71.406  14.714  1.00 22.80           C  
ATOM   3843  CB  ARG   281     -29.234  70.952  15.390  1.00 22.47           C  
ATOM   3846  CG  ARG   281     -29.126  70.862  16.907  1.00 21.97           C  
ATOM   3849  CD  ARG   281     -30.462  70.709  17.490  1.00 22.22           C  
ATOM   3852  NE  ARG   281     -30.354  70.378  18.899  1.00 23.62           N  
ATOM   3854  CZ  ARG   281     -30.253  71.276  19.865  1.00 21.97           C  
ATOM   3855  NH1 ARG   281     -30.270  72.577  19.593  1.00 24.25           N  
ATOM   3858  NH2 ARG   281     -30.173  70.864  21.110  1.00 21.32           N  
ATOM   3861  C   ARG   281     -27.553  72.815  15.222  1.00 22.15           C  
ATOM   3862  O   ARG   281     -26.485  73.010  15.768  1.00 22.18           O  
ATOM   3864  N   LYS   282     -28.458  73.765  15.040  1.00 22.09           N  
ATOM   3865  CA  LYS   282     -28.247  75.137  15.375  1.00 22.30           C  
ATOM   3867  CB  LYS   282     -28.922  76.061  14.345  1.00 22.90           C  
ATOM   3870  CG  LYS   282     -28.144  76.086  13.021  1.00 25.63           C  
ATOM   3873  CD  LYS   282     -28.732  77.025  11.950  1.00 28.64           C  
ATOM   3876  CE  LYS   282     -28.027  76.854  10.561  1.00 29.15           C  
ATOM   3879  NZ  LYS   282     -26.972  77.866  10.199  1.00 27.68           N  
ATOM   3883  C   LYS   282     -28.776  75.362  16.779  1.00 22.26           C  
ATOM   3884  O   LYS   282     -29.891  74.926  17.099  1.00 21.41           O  
ATOM   3886  N   PRO   283     -27.961  76.030  17.638  1.00 21.82           N  
ATOM   3887  CA  PRO   283     -28.403  76.320  18.971  1.00 21.70           C  
ATOM   3889  CB  PRO   283     -27.143  76.863  19.619  1.00 22.12           C  
ATOM   3892  CG  PRO   283     -26.507  77.568  18.501  1.00 21.28           C  
ATOM   3895  CD  PRO   283     -26.672  76.687  17.361  1.00 21.06           C  
ATOM   3898  C   PRO   283     -29.504  77.368  18.939  1.00 21.68           C  
ATOM   3899  O   PRO   283     -29.479  78.264  18.126  1.00 22.29           O  
ATOM   3900  N   VAL   284     -30.489  77.190  19.793  1.00 22.11           N  
ATOM   3901  CA  VAL   284     -31.550  78.138  19.978  1.00 21.65           C  
ATOM   3903  CB  VAL   284     -32.963  77.473  19.939  1.00 22.24           C  
ATOM   3905  CG1 VAL   284     -34.085  78.522  20.123  1.00 21.74           C  
ATOM   3909  CG2 VAL   284     -33.179  76.687  18.609  1.00 19.77           C  
ATOM   3913  C   VAL   284     -31.207  78.615  21.359  1.00 21.91           C  
ATOM   3914  O   VAL   284     -31.265  77.830  22.310  1.00 22.28           O  
ATOM   3916  N   TRP   285     -30.788  79.869  21.463  1.00 21.10           N  
ATOM   3917  CA  TRP   285     -30.409  80.441  22.733  1.00 21.52           C  
ATOM   3919  CB  TRP   285     -29.451  81.659  22.563  1.00 20.67           C  
ATOM   3922  CG  TRP   285     -28.247  81.413  21.674  1.00 14.90           C  
ATOM   3923  CD1 TRP   285     -27.967  82.027  20.511  1.00 11.30           C  
ATOM   3925  NE1 TRP   285     -26.783  81.527  19.958  1.00  9.32           N  
ATOM   3927  CE2 TRP   285     -26.308  80.550  20.789  1.00 12.07           C  
ATOM   3928  CD2 TRP   285     -27.207  80.441  21.872  1.00 13.81           C  
ATOM   3929  CE3 TRP   285     -26.937  79.501  22.876  1.00 14.24           C  
ATOM   3931  CZ3 TRP   285     -25.809  78.730  22.763  1.00 14.11           C  
ATOM   3933  CH2 TRP   285     -24.918  78.877  21.656  1.00 12.25           C  
ATOM   3935  CZ2 TRP   285     -25.153  79.772  20.684  1.00 11.69           C  
ATOM   3937  C   TRP   285     -31.659  80.864  23.466  1.00 24.05           C  
ATOM   3938  O   TRP   285     -32.658  81.240  22.875  1.00 24.11           O  
ATOM   3940  N   SER   286     -31.591  80.827  24.778  1.00 27.76           N  
ATOM   3941  CA  SER   286     -32.662  81.360  25.580  1.00 30.76           C  
ATOM   3943  CB  SER   286     -32.863  80.501  26.816  1.00 31.14           C  
ATOM   3946  OG  SER   286     -32.578  81.222  27.980  1.00 33.19           O  
ATOM   3948  C   SER   286     -32.349  82.788  25.984  1.00 33.31           C  
ATOM   3949  O   SER   286     -33.235  83.667  25.898  1.00 34.43           O  
ATOM   3951  N   HIS   287     -31.066  83.002  26.360  1.00 35.50           N  
ATOM   3952  CA  HIS   287     -30.538  84.217  27.026  1.00 36.91           C  
ATOM   3954  CB  HIS   287     -30.657  85.533  26.180  1.00 38.14           C  
ATOM   3957  CG  HIS   287     -30.676  85.348  24.689  1.00 39.64           C  
ATOM   3958  ND1 HIS   287     -31.855  85.220  23.977  1.00 42.19           N  
ATOM   3960  CE1 HIS   287     -31.580  85.134  22.686  1.00 44.05           C  
ATOM   3962  NE2 HIS   287     -30.265  85.197  22.536  1.00 44.56           N  
ATOM   3964  CD2 HIS   287     -29.679  85.349  23.773  1.00 40.31           C  
ATOM   3966  C   HIS   287     -31.195  84.471  28.416  1.00 37.23           C  
ATOM   3967  O   HIS   287     -30.861  83.828  29.423  1.00 37.39           O  
END
