
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  260 ( 2016),  selected  260 , name 2uzf_A
# Molecule2: number of CA atoms  256 ( 1936),  selected  256 , name T0486.pdb
# PARAMETERS: 2uzf_A.T0486.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    W     6_A      P      32           -
LGA    E     7_A      -       -           -
LGA    T     8_A      -       -           -
LGA    L     9_A      -       -           -
LGA    R    10_A      -       -           -
LGA    E    11_A      -       -           -
LGA    Y    12_A      -       -           -
LGA    D    13_A      R      33          1.107
LGA    E    14_A      P      34          0.858
LGA    I    15_A      T      35          0.609
LGA    K    16_A      S      36          0.539
LGA    Y    17_A      A      37          0.681
LGA    E    18_A      R      38          1.121
LGA    F    19_A      Q      39          1.793
LGA    Y    20_A      L      40          2.912
LGA    E    21_A      D      41          1.920
LGA    G    22_A      G      42          1.488
LGA    I    23_A      I      43          0.584
LGA    A    24_A      R      44          0.254
LGA    K    25_A      N      45          0.729
LGA    V    26_A      I      46          0.857
LGA    T    27_A      V      47          0.847
LGA    I    28_A      L      48          0.777
LGA    N    29_A      S      49          0.688
LGA    R    30_A      N      50          0.647
LGA    P    31_A      P      51          0.255
LGA    E    32_A      K      52          0.303
LGA    V    33_A      K      53          1.081
LGA    R    34_A      R      54          1.020
LGA    N    35_A      N      55          0.896
LGA    A    36_A      T      56          0.659
LGA    F    37_A      L      57          1.689
LGA    T    38_A      S      58          1.242
LGA    P    39_A      L      59          0.544
LGA    K    40_A      A      60          1.040
LGA    T    41_A      M      61          0.973
LGA    V    42_A      L      62          0.609
LGA    A    43_A      K      63          0.681
LGA    E    44_A      S      64          0.859
LGA    M    45_A      L      65          0.819
LGA    I    46_A      Q      66          0.814
LGA    D    47_A      S      67          0.969
LGA    A    48_A      D      68          0.709
LGA    F    49_A      I      69          0.518
LGA    S    50_A      L      70          0.521
LGA    R    51_A      H      71          0.868
LGA    A    52_A      D      72           #
LGA    R    53_A      A      73          1.620
LGA    D    54_A      D      74          2.671
LGA    D    55_A      S      75          2.970
LGA    Q    56_A      N      76          2.040
LGA    N    57_A      D      77          1.248
LGA    V    58_A      L      78          1.612
LGA    S    59_A      K      79          0.425
LGA    V    60_A      V      80          0.610
LGA    I    61_A      I      81          0.206
LGA    V    62_A      I      82          0.665
LGA    L    63_A      I      83          0.625
LGA    T    64_A      S      84          1.039
LGA    G    65_A      A      85          0.805
LGA    E    66_A      E      86          1.335
LGA    G    67_A      G      87          2.668
LGA    D    68_A      -       -           -
LGA    L    69_A      P      88          0.803
LGA    A    70_A      V      89          1.566
LGA    F    71_A      F      90          1.156
LGA    C    72_A      S      91          1.004
LGA    S    73_A      S      92          1.037
LGA    G    74_A      G      93          0.949
LGA    G    75_A      H      94          1.268
LGA    D    76_A      D      95          1.534
LGA    Q    77_A      L      96          4.527
LGA    K    78_A      K      97          5.031
LGA    G    87_A      E      98           #
LGA    E    88_A      L      99           -
LGA    D    89_A      T     100           -
LGA    Q    90_A      E     101           -
LGA    I    91_A      E     102           -
LGA    -       -      Q     103           -
LGA    -       -      G     104           -
LGA    -       -      R     105           -
LGA    -       -      D     106           -
LGA    P    92_A      Y     107          0.792
LGA    R    93_A      H     108          5.099
LGA    -       -      A     109           -
LGA    -       -      E     110           -
LGA    L    94_A      V     111          1.932
LGA    -       -      F     112           -
LGA    -       -      Q     113           -
LGA    N    95_A      T     114          1.066
LGA    V    96_A      C     115          1.010
LGA    L    97_A      S     116          1.184
LGA    D    98_A      K     117          1.137
LGA    L    99_A      V     118          0.397
LGA    Q   100_A      M     119          0.858
LGA    R   101_A      M     120          0.661
LGA    L   102_A      H     121          0.486
LGA    I   103_A      I     122          0.610
LGA    R   104_A      R     123          0.585
LGA    I   105_A      N     124          0.364
LGA    I   106_A      H     125          0.383
LGA    P   107_A      P     126          1.372
LGA    K   108_A      V     127          0.635
LGA    P   109_A      P     128          0.615
LGA    V   110_A      V     129          0.496
LGA    I   111_A      I     130          0.336
LGA    A   112_A      A     131          0.338
LGA    M   113_A      M     132          0.319
LGA    V   114_A      V     133          0.384
LGA    K   115_A      N     134          0.654
LGA    G   116_A      G     135          0.543
LGA    Y   117_A      L     136          0.743
LGA    A   118_A      A     137          0.600
LGA    V   119_A      T     138          0.577
LGA    G   120_A      A     139          0.750
LGA    G   121_A      A     140          0.505
LGA    G   122_A      G     141          0.099
LGA    N   123_A      C     142          0.207
LGA    V   124_A      Q     143          0.331
LGA    L   125_A      L     144          0.514
LGA    N   126_A      V     145          0.449
LGA    V   127_A      A     146          0.383
LGA    V   128_A      S     147          0.761
LGA    C   129_A      C     148          0.283
LGA    D   130_A      D     149          0.451
LGA    L   131_A      I     150          0.482
LGA    T   132_A      A     151          0.412
LGA    I   133_A      V     152          0.560
LGA    A   134_A      A     153          0.502
LGA    A   135_A      S     154          0.779
LGA    D   136_A      D     155          1.566
LGA    N   137_A      K     156          2.084
LGA    A   138_A      S     157          0.672
LGA    I   139_A      S     158          1.007
LGA    F   140_A      F     159          0.454
LGA    G   141_A      A     160          0.827
LGA    Q   142_A      T     161          0.543
LGA    T   143_A      P     162          1.352
LGA    G   144_A      G     163          1.610
LGA    P   145_A      V     164          1.711
LGA    K   146_A      N     165          1.720
LGA    V   147_A      V     166          2.177
LGA    G   148_A      G     167          2.707
LGA    S   149_A      L     168          2.461
LGA    F   150_A      F     169          3.642
LGA    -       -      C     170           -
LGA    D   151_A      S     171          2.648
LGA    A   152_A      T     172          4.235
LGA    G   153_A      -       -           -
LGA    Y   154_A      -       -           -
LGA    G   155_A      P     173          2.984
LGA    S   156_A      G     174          2.609
LGA    G   157_A      V     175          4.199
LGA    Y   158_A      A     176          4.031
LGA    L   159_A      L     177          2.451
LGA    A   160_A      A     178          2.798
LGA    R   161_A      R     179          2.988
LGA    I   162_A      A     180          2.695
LGA    V   163_A      V     181          1.679
LGA    G   164_A      P     182          1.657
LGA    H   165_A      R     183          1.588
LGA    K   166_A      K     184          1.329
LGA    K   167_A      V     185          1.250
LGA    A   168_A      A     186          1.385
LGA    R   169_A      L     187          1.517
LGA    E   170_A      E     188          1.727
LGA    I   171_A      M     189          1.281
LGA    W   172_A      L     190          0.865
LGA    Y   173_A      F     191          1.236
LGA    L   174_A      T     192          1.505
LGA    C   175_A      G     193          1.333
LGA    R   176_A      E     194          0.853
LGA    Q   177_A      P     195          0.769
LGA    Y   178_A      I     196          1.319
LGA    N   179_A      S     197          1.468
LGA    A   180_A      A     198          1.416
LGA    Q   181_A      Q     199          1.129
LGA    E   182_A      E     200          1.689
LGA    A   183_A      A     201          1.458
LGA    L   184_A      L     202          1.363
LGA    D   185_A      L     203          1.951
LGA    M   186_A      H     204          1.578
LGA    G   187_A      G     205          2.184
LGA    L   188_A      L     206          1.323
LGA    V   189_A      L     207          0.835
LGA    N   190_A      S     208          1.226
LGA    T   191_A      K     209          1.205
LGA    V   192_A      V     210          1.082
LGA    V   193_A      V     211          1.113
LGA    P   194_A      P     212          1.147
LGA    L   195_A      E     213          1.136
LGA    E   196_A      A     214          2.076
LGA    K   197_A      E     215          2.095
LGA    V   198_A      L     216          1.267
LGA    E   199_A      Q     217          1.482
LGA    D   200_A      E     218          1.438
LGA    E   201_A      E     219          0.982
LGA    T   202_A      T     220          0.583
LGA    V   203_A      M     221          0.592
LGA    Q   204_A      R     222          0.865
LGA    W   205_A      I     223          0.960
LGA    C   206_A      A     224          0.669
LGA    K   207_A      R     225          1.066
LGA    E   208_A      K     226          1.424
LGA    I   209_A      I     227          1.379
LGA    M   210_A      A     228          2.180
LGA    K   211_A      S     229          2.913
LGA    H   212_A      L     230          2.597
LGA    S   213_A      S     231          2.635
LGA    P   214_A      R     232          2.136
LGA    T   215_A      P     233          2.311
LGA    A   216_A      V     234          2.588
LGA    L   217_A      V     235          1.906
LGA    R   218_A      S     236          1.719
LGA    F   219_A      L     237          2.454
LGA    L   220_A      G     238          2.455
LGA    K   221_A      K     239          1.684
LGA    A   222_A      A     240          1.755
LGA    A   223_A      T     241          2.730
LGA    M   224_A      F     242          3.030
LGA    N   225_A      Y     243          2.008
LGA    A   226_A      K     244          2.140
LGA    -       -      Q     245           -
LGA    D   227_A      L     246          1.721
LGA    T   228_A      P     247          3.608
LGA    D   229_A      Q     248           #
LGA    G   230_A      D     249           -
LGA    L   231_A      L     250           -
LGA    A   232_A      G     251           -
LGA    G   233_A      T     252           -
LGA    L   234_A      A     253           -
LGA    Q   235_A      Y     254           -
LGA    Q   236_A      Y     255           -
LGA    M   237_A      L     256           #
LGA    A   238_A      T     257           -
LGA    G   239_A      S     258           -
LGA    D   240_A      Q     259           -
LGA    A   241_A      A     260          6.967
LGA    T   242_A      M     261           -
LGA    L   243_A      V     262           -
LGA    L   244_A      D     263          6.264
LGA    Y   245_A      N     264           -
LGA    Y   246_A      L     265           -
LGA    T   247_A      -       -           -
LGA    T   248_A      A     266          7.196
LGA    D   249_A      L     267           -
LGA    E   250_A      R     268           -
LGA    A   251_A      D     269           -
LGA    K   252_A      G     270           -
LGA    E   253_A      Q     271           -
LGA    G   254_A      E     272           -
LGA    R   255_A      G     273           -
LGA    D   256_A      I     274           -
LGA    A   257_A      T     275           -
LGA    F   258_A      A     276           -
LGA    K   259_A      F     277           -
LGA    E   260_A      L     278           -
LGA    K   261_A      Q     279           -
LGA    R   262_A      K     280           -
LGA    D   263_A      R     281           -
LGA    P   264_A      K     282           -
LGA    D   265_A      P     283           -
LGA    F   266_A      V     284           -
LGA    D   267_A      W     285           -
LGA    Q   268_A      S     286           -
LGA    F   269_A      H     287           -
LGA    P   270_A      -       -           -
LGA    K   271_A      -       -           -
LGA    F   272_A      -       -           -
LGA    P   273_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  260  256    5.0    202    1.83    30.20     72.166    10.467

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.181498 * X  +  -0.679268 * Y  +   0.711093 * Z  +  -0.653806
  Y_new =   0.809421 * X  +  -0.513847 * Y  +  -0.284254 * Z  +  95.072388
  Z_new =   0.558477 * X  +   0.523982 * Y  +   0.643075 * Z  +  43.689735 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.683704   -2.457888  [ DEG:    39.1734   -140.8266 ]
  Theta =  -0.592549   -2.549044  [ DEG:   -33.9506   -146.0495 ]
  Phi   =   1.791380   -1.350213  [ DEG:   102.6385    -77.3615 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2uzf_A                                        
REMARK     2: T0486.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2uzf_A.T0486.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  260  256   5.0  202   1.83   30.20  72.166
REMARK  ---------------------------------------------------------- 
MOLECULE 2uzf_A
HEADER    LYASE                                   27-APR-07   2UZF              
TITLE     CRYSTAL STRUCTURE OF STAPHYLOCOCCUS AUREUS 1,4-DIHYDROXY-2-           
TITLE    2 NAPHTHOYL COA SYNTHASE (MENB) IN COMPLEX WITH ACETOACETYL            
TITLE    3 COA                                                                  
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: NAPHTHOATE SYNTHASE;                                       
COMPND   3 SYNONYM: DIHYDROXYNAPHTHOIC ACID SYNTHETASE, DHNA                    
COMPND   4  SYNTHETASE, 1,4-DIHYDROXYL-2-NAPHTHOYL COA SYNTHASE;                
COMPND   5 CHAIN: A, B;                                                         
COMPND   6 EC: 4.1.3.36;                                                        
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   3 EXPRESSION_SYSTEM_VECTOR: PET15B-TEV;                                
SOURCE   4 EXPRESSION_SYSTEM_CELL_LINE: BL21(DE3);                              
SOURCE   5 ORGANISM_SCIENTIFIC: STAPHYLOCOCCUS AUREUS;                          
SOURCE   6 ATCC: 35556                                                          
KEYWDS    LYASE, MENAQUINONE BIOSYNTHESIS                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    V.ULAGANATHAN,L.BUETOW,W.N.HUNTER                                     
REVDAT   1   13-NOV-07 2UZF    0                                                
JRNL        AUTH   V.ULAGANATHAN,M.F.AGACAN,L.BUETOW,L.B.TULLOCH,               
JRNL        AUTH 2 W.N.HUNTER                                                   
JRNL        TITL   STRUCTURE OF STAPHYLOCOCCUS AUREUS 1,4-                      
JRNL        TITL 2 DIHYDROXY-2-NAPHTHOYL-COA SYNTHASE (MENB) IN                 
JRNL        TITL 3 COMPLEX WITH ACETOACETYL-COA                                 
JRNL        REF    ACTA CRYSTALLOGR.,SECT.F      V.  63   908 2007              
JRNL        REFN   ASTM         DK ISSN 1744-3091                               
REMARK   2 RESOLUTION. 2.9  ANGSTROMS.                                          
DBREF  2UZF A    1   273  UNP    Q5HH38   MENB_STAAC       1    273             
DBREF  2UZF B    1   273  UNP    Q5HH38   MENB_STAAC       1    273             
SEQRES   1 A  273  MET THR ASN ARG GLN TRP GLU THR LEU ARG GLU TYR ASP          
SEQRES   2 A  273  GLU ILE LYS TYR GLU PHE TYR GLU GLY ILE ALA LYS VAL          
SEQRES   3 A  273  THR ILE ASN ARG PRO GLU VAL ARG ASN ALA PHE THR PRO          
SEQRES   4 A  273  LYS THR VAL ALA GLU MET ILE ASP ALA PHE SER ARG ALA          
SEQRES   5 A  273  ARG ASP ASP GLN ASN VAL SER VAL ILE VAL LEU THR GLY          
SEQRES   6 A  273  GLU GLY ASP LEU ALA PHE CYS SER GLY GLY ASP GLN LYS          
SEQRES   7 A  273  LYS ARG GLY HIS GLY GLY TYR VAL GLY GLU ASP GLN ILE          
SEQRES   8 A  273  PRO ARG LEU ASN VAL LEU ASP LEU GLN ARG LEU ILE ARG          
SEQRES   9 A  273  ILE ILE PRO LYS PRO VAL ILE ALA MET VAL LYS GLY TYR          
SEQRES  10 A  273  ALA VAL GLY GLY GLY ASN VAL LEU ASN VAL VAL CYS ASP          
SEQRES  11 A  273  LEU THR ILE ALA ALA ASP ASN ALA ILE PHE GLY GLN THR          
SEQRES  12 A  273  GLY PRO LYS VAL GLY SER PHE ASP ALA GLY TYR GLY SER          
SEQRES  13 A  273  GLY TYR LEU ALA ARG ILE VAL GLY HIS LYS LYS ALA ARG          
SEQRES  14 A  273  GLU ILE TRP TYR LEU CYS ARG GLN TYR ASN ALA GLN GLU          
SEQRES  15 A  273  ALA LEU ASP MET GLY LEU VAL ASN THR VAL VAL PRO LEU          
SEQRES  16 A  273  GLU LYS VAL GLU ASP GLU THR VAL GLN TRP CYS LYS GLU          
SEQRES  17 A  273  ILE MET LYS HIS SER PRO THR ALA LEU ARG PHE LEU LYS          
SEQRES  18 A  273  ALA ALA MET ASN ALA ASP THR ASP GLY LEU ALA GLY LEU          
SEQRES  19 A  273  GLN GLN MET ALA GLY ASP ALA THR LEU LEU TYR TYR THR          
SEQRES  20 A  273  THR ASP GLU ALA LYS GLU GLY ARG ASP ALA PHE LYS GLU          
SEQRES  21 A  273  LYS ARG ASP PRO ASP PHE ASP GLN PHE PRO LYS PHE PRO          
SEQRES   1 B  273  MET THR ASN ARG GLN TRP GLU THR LEU ARG GLU TYR ASP          
SEQRES   2 B  273  GLU ILE LYS TYR GLU PHE TYR GLU GLY ILE ALA LYS VAL          
SEQRES   3 B  273  THR ILE ASN ARG PRO GLU VAL ARG ASN ALA PHE THR PRO          
SEQRES   4 B  273  LYS THR VAL ALA GLU MET ILE ASP ALA PHE SER ARG ALA          
SEQRES   5 B  273  ARG ASP ASP GLN ASN VAL SER VAL ILE VAL LEU THR GLY          
SEQRES   6 B  273  GLU GLY ASP LEU ALA PHE CYS SER GLY GLY ASP GLN LYS          
SEQRES   7 B  273  LYS ARG GLY HIS GLY GLY TYR VAL GLY GLU ASP GLN ILE          
SEQRES   8 B  273  PRO ARG LEU ASN VAL LEU ASP LEU GLN ARG LEU ILE ARG          
SEQRES   9 B  273  ILE ILE PRO LYS PRO VAL ILE ALA MET VAL LYS GLY TYR          
SEQRES  10 B  273  ALA VAL GLY GLY GLY ASN VAL LEU ASN VAL VAL CYS ASP          
SEQRES  11 B  273  LEU THR ILE ALA ALA ASP ASN ALA ILE PHE GLY GLN THR          
SEQRES  12 B  273  GLY PRO LYS VAL GLY SER PHE ASP ALA GLY TYR GLY SER          
SEQRES  13 B  273  GLY TYR LEU ALA ARG ILE VAL GLY HIS LYS LYS ALA ARG          
SEQRES  14 B  273  GLU ILE TRP TYR LEU CYS ARG GLN TYR ASN ALA GLN GLU          
SEQRES  15 B  273  ALA LEU ASP MET GLY LEU VAL ASN THR VAL VAL PRO LEU          
SEQRES  16 B  273  GLU LYS VAL GLU ASP GLU THR VAL GLN TRP CYS LYS GLU          
SEQRES  17 B  273  ILE MET LYS HIS SER PRO THR ALA LEU ARG PHE LEU LYS          
SEQRES  18 B  273  ALA ALA MET ASN ALA ASP THR ASP GLY LEU ALA GLY LEU          
SEQRES  19 B  273  GLN GLN MET ALA GLY ASP ALA THR LEU LEU TYR TYR THR          
SEQRES  20 B  273  THR ASP GLU ALA LYS GLU GLY ARG ASP ALA PHE LYS GLU          
SEQRES  21 B  273  LYS ARG ASP PRO ASP PHE ASP GLN PHE PRO LYS PHE PRO          
HET    CAA  A1274      54                                                       
HETNAM     CAA ACETOACETYL-COENZYME A                                           
FORMUL   3  CAA    C25 H40 N7 O18 P3 S                                          
FORMUL   4  HOH   *62(H2 O1)                                                    
CRYST1  120.008  120.008  120.008  90.00  90.00  90.00 P 21 3       24          
ATOM      1  N   TRP A   6     -34.827 101.619   8.041  1.00 34.90           N  
ATOM      2  CA  TRP A   6     -33.467 101.876   8.597  1.00 35.09           C  
ATOM      3  C   TRP A   6     -33.515 102.403  10.031  1.00 35.28           C  
ATOM      4  O   TRP A   6     -33.393 103.611  10.252  1.00 35.56           O  
ATOM      5  CB  TRP A   6     -32.703 102.879   7.726  1.00 35.02           C  
ATOM      6  CG  TRP A   6     -31.804 102.285   6.684  1.00 34.97           C  
ATOM      7  CD1 TRP A   6     -30.854 101.321   6.870  1.00 34.75           C  
ATOM      8  CD2 TRP A   6     -31.738 102.651   5.298  1.00 34.85           C  
ATOM      9  NE1 TRP A   6     -30.217 101.048   5.683  1.00 35.01           N  
ATOM     10  CE2 TRP A   6     -30.738 101.852   4.702  1.00 34.88           C  
ATOM     11  CE3 TRP A   6     -32.433 103.572   4.500  1.00 34.63           C  
ATOM     12  CZ2 TRP A   6     -30.415 101.942   3.341  1.00 34.73           C  
ATOM     13  CZ3 TRP A   6     -32.110 103.662   3.147  1.00 34.85           C  
ATOM     14  CH2 TRP A   6     -31.110 102.850   2.584  1.00 34.75           C  
ATOM     15  N   GLU A   7     -33.692 101.494  10.993  1.00 35.25           N  
ATOM     16  CA  GLU A   7     -33.506 101.777  12.434  1.00 35.26           C  
ATOM     17  C   GLU A   7     -34.529 102.757  13.043  1.00 35.32           C  
ATOM     18  O   GLU A   7     -34.869 103.771  12.432  1.00 35.27           O  
ATOM     19  CB  GLU A   7     -32.051 102.213  12.728  1.00 35.09           C  
ATOM     20  CG  GLU A   7     -30.997 101.460  11.887  1.00 35.10           C  
ATOM     21  CD  GLU A   7     -29.556 101.648  12.347  1.00 35.42           C  
ATOM     22  OE1 GLU A   7     -29.239 101.333  13.519  1.00 35.62           O  
ATOM     23  OE2 GLU A   7     -28.730 102.080  11.514  1.00 35.09           O  
ATOM     24  N   THR A   8     -35.016 102.442  14.246  1.00 35.50           N  
ATOM     25  CA  THR A   8     -36.015 103.280  14.941  1.00 35.62           C  
ATOM     26  C   THR A   8     -35.338 104.473  15.641  1.00 35.57           C  
ATOM     27  O   THR A   8     -34.343 104.983  15.124  1.00 35.81           O  
ATOM     28  CB  THR A   8     -36.892 102.459  15.921  1.00 35.65           C  
ATOM     29  OG1 THR A   8     -36.955 101.092  15.494  1.00 35.46           O  
ATOM     30  CG2 THR A   8     -38.310 103.031  15.976  1.00 35.97           C  
ATOM     31  N   LEU A   9     -35.866 104.931  16.784  1.00 35.24           N  
ATOM     32  CA  LEU A   9     -35.264 106.068  17.515  1.00 35.07           C  
ATOM     33  C   LEU A   9     -35.882 106.417  18.882  1.00 34.72           C  
ATOM     34  O   LEU A   9     -37.087 106.238  19.088  1.00 34.76           O  
ATOM     35  CB  LEU A   9     -35.209 107.329  16.625  1.00 35.01           C  
ATOM     36  CG  LEU A   9     -36.489 108.097  16.291  1.00 35.47           C  
ATOM     37  CD1 LEU A   9     -36.706 109.217  17.304  1.00 36.26           C  
ATOM     38  CD2 LEU A   9     -36.427 108.662  14.877  1.00 35.64           C  
ATOM     39  N   ARG A  10     -35.031 106.920  19.791  1.00 34.31           N  
ATOM     40  C   ARG A  10     -35.003 108.863  21.331  1.00 33.60           C  
ATOM     41  O   ARG A  10     -33.889 109.240  20.955  1.00 33.45           O  
ATOM     42  CA  ARG A  10     -35.445 107.407  21.119  0.50 33.87           C  
ATOM     43  CB  ARG A  10     -34.877 106.504  22.224  0.50 33.80           C  
ATOM     44  CG  ARG A  10     -35.574 106.585  23.595  0.50 33.45           C  
ATOM     45  CD  ARG A  10     -35.023 107.713  24.476  0.50 32.36           C  
ATOM     46  NE  ARG A  10     -35.343 107.550  25.897  0.50 31.66           N  
ATOM     47  CZ  ARG A  10     -36.518 107.834  26.455  0.50 31.41           C  
ATOM     48  NH1 ARG A  10     -37.528 108.285  25.724  0.50 31.71           N  
ATOM     49  NH2 ARG A  10     -36.691 107.655  27.756  0.50 30.83           N  
ATOM     58  N   GLU A  11     -35.879 109.653  21.957  1.00 33.36           N  
ATOM     59  CA  GLU A  11     -35.732 111.111  22.156  1.00 32.91           C  
ATOM     60  C   GLU A  11     -34.430 111.619  22.795  1.00 32.66           C  
ATOM     61  O   GLU A  11     -34.176 111.384  23.978  1.00 32.80           O  
ATOM     62  CB  GLU A  11     -36.945 111.650  22.942  1.00 32.99           C  
ATOM     63  CG  GLU A  11     -37.141 110.999  24.321  1.00 32.63           C  
ATOM     64  CD  GLU A  11     -38.348 111.517  25.085  1.00 32.65           C  
ATOM     65  OE1 GLU A  11     -38.500 112.752  25.214  1.00 32.36           O  
ATOM     66  OE2 GLU A  11     -39.136 110.682  25.576  1.00 31.58           O  
ATOM     67  N   TYR A  12     -33.627 112.332  22.005  1.00 32.30           N  
ATOM     68  CA  TYR A  12     -32.429 113.023  22.506  1.00 32.25           C  
ATOM     69  C   TYR A  12     -32.136 114.309  21.726  1.00 32.26           C  
ATOM     70  O   TYR A  12     -32.489 114.425  20.551  1.00 32.24           O  
ATOM     71  CB  TYR A  12     -31.198 112.106  22.486  1.00 32.18           C  
ATOM     72  CG  TYR A  12     -31.155 111.076  23.595  1.00 31.85           C  
ATOM     73  CD1 TYR A  12     -30.795 111.433  24.894  1.00 31.53           C  
ATOM     74  CD2 TYR A  12     -31.465 109.743  23.340  1.00 31.64           C  
ATOM     75  CE1 TYR A  12     -30.752 110.487  25.913  1.00 31.66           C  
ATOM     76  CE2 TYR A  12     -31.424 108.790  24.351  1.00 32.19           C  
ATOM     77  CZ  TYR A  12     -31.066 109.167  25.632  1.00 32.13           C  
ATOM     78  OH  TYR A  12     -31.028 108.218  26.632  1.00 32.28           O  
ATOM     79  N   ASP A  13     -31.474 115.257  22.389  1.00 32.28           N  
ATOM     80  CA  ASP A  13     -31.214 116.591  21.829  1.00 32.21           C  
ATOM     81  C   ASP A  13     -29.929 116.709  21.006  1.00 31.84           C  
ATOM     82  O   ASP A  13     -29.925 117.343  19.953  1.00 32.10           O  
ATOM     83  CB  ASP A  13     -31.218 117.655  22.938  1.00 32.30           C  
ATOM     84  CG  ASP A  13     -32.609 118.195  23.234  1.00 33.19           C  
ATOM     85  OD1 ASP A  13     -32.719 119.405  23.527  1.00 34.07           O  
ATOM     86  OD2 ASP A  13     -33.591 117.422  23.174  1.00 34.01           O  
ATOM     87  N   GLU A  14     -28.843 116.115  21.487  1.00 31.28           N  
ATOM     88  CA  GLU A  14     -27.547 116.275  20.830  1.00 30.83           C  
ATOM     89  C   GLU A  14     -26.958 114.957  20.330  1.00 30.79           C  
ATOM     90  O   GLU A  14     -25.923 114.944  19.659  1.00 30.76           O  
ATOM     91  CB  GLU A  14     -26.566 116.994  21.756  1.00 30.86           C  
ATOM     92  CG  GLU A  14     -26.894 118.464  21.964  1.00 30.71           C  
ATOM     93  CD  GLU A  14     -25.954 119.154  22.928  1.00 30.51           C  
ATOM     94  OE1 GLU A  14     -24.783 118.738  23.031  1.00 30.05           O  
ATOM     95  OE2 GLU A  14     -26.388 120.125  23.582  1.00 30.44           O  
ATOM     96  N   ILE A  15     -27.619 113.853  20.668  1.00 30.56           N  
ATOM     97  CA  ILE A  15     -27.220 112.533  20.190  1.00 30.17           C  
ATOM     98  C   ILE A  15     -28.417 111.797  19.597  1.00 29.72           C  
ATOM     99  O   ILE A  15     -29.557 112.231  19.754  1.00 29.89           O  
ATOM    100  CB  ILE A  15     -26.547 111.678  21.310  1.00 30.40           C  
ATOM    101  CG1 ILE A  15     -27.543 111.290  22.408  1.00 31.14           C  
ATOM    102  CG2 ILE A  15     -25.334 112.388  21.898  1.00 30.31           C  
ATOM    103  CD1 ILE A  15     -28.006 109.845  22.327  1.00 33.05           C  
ATOM    104  N   LYS A  16     -28.153 110.691  18.909  1.00 29.30           N  
ATOM    105  CA  LYS A  16     -29.213 109.828  18.393  1.00 28.82           C  
ATOM    106  C   LYS A  16     -29.080 108.406  18.928  1.00 28.49           C  
ATOM    107  O   LYS A  16     -27.988 107.838  18.955  1.00 28.62           O  
ATOM    108  CB  LYS A  16     -29.235 109.844  16.865  1.00 28.70           C  
ATOM    109  CG  LYS A  16     -29.977 111.047  16.289  1.00 28.96           C  
ATOM    110  CD  LYS A  16     -29.517 111.401  14.880  1.00 28.56           C  
ATOM    111  CE  LYS A  16     -29.989 110.392  13.853  1.00 28.37           C  
ATOM    112  NZ  LYS A  16     -29.689 110.857  12.477  1.00 29.00           N  
ATOM    113  N   TYR A  17     -30.202 107.850  19.369  1.00 28.04           N  
ATOM    114  CA  TYR A  17     -30.244 106.514  19.947  1.00 27.61           C  
ATOM    115  C   TYR A  17     -31.233 105.681  19.137  1.00 27.35           C  
ATOM    116  O   TYR A  17     -32.449 105.884  19.212  1.00 26.95           O  
ATOM    117  CB  TYR A  17     -30.628 106.602  21.431  1.00 27.73           C  
ATOM    118  CG  TYR A  17     -30.607 105.299  22.212  1.00 27.49           C  
ATOM    119  CD1 TYR A  17     -31.778 104.786  22.767  1.00 28.10           C  
ATOM    120  CD2 TYR A  17     -29.421 104.596  22.418  1.00 27.41           C  
ATOM    121  CE1 TYR A  17     -31.776 103.602  23.493  1.00 28.47           C  
ATOM    122  CE2 TYR A  17     -29.406 103.406  23.145  1.00 27.79           C  
ATOM    123  CZ  TYR A  17     -30.588 102.915  23.680  1.00 28.29           C  
ATOM    124  OH  TYR A  17     -30.594 101.742  24.402  1.00 27.92           O  
ATOM    125  N   GLU A  18     -30.688 104.759  18.344  1.00 27.11           N  
ATOM    126  CA  GLU A  18     -31.468 103.992  17.370  1.00 26.94           C  
ATOM    127  C   GLU A  18     -31.248 102.479  17.518  1.00 26.76           C  
ATOM    128  O   GLU A  18     -30.411 102.043  18.306  1.00 26.53           O  
ATOM    129  CB  GLU A  18     -31.157 104.480  15.947  1.00 26.91           C  
ATOM    130  CG  GLU A  18     -31.666 105.900  15.659  1.00 26.79           C  
ATOM    131  CD  GLU A  18     -30.970 106.572  14.485  1.00 26.85           C  
ATOM    132  OE1 GLU A  18     -29.867 107.120  14.683  1.00 27.93           O  
ATOM    133  OE2 GLU A  18     -31.532 106.576  13.371  1.00 26.41           O  
ATOM    134  N   PHE A  19     -32.002 101.684  16.763  1.00 26.92           N  
ATOM    135  CA  PHE A  19     -32.009 100.232  16.945  1.00 27.08           C  
ATOM    136  C   PHE A  19     -32.230  99.472  15.635  1.00 27.12           C  
ATOM    137  O   PHE A  19     -33.152  99.775  14.885  1.00 27.04           O  
ATOM    138  CB  PHE A  19     -33.087  99.856  17.969  1.00 27.21           C  
ATOM    139  CG  PHE A  19     -33.182  98.384  18.256  1.00 27.31           C  
ATOM    140  CD1 PHE A  19     -34.131  97.597  17.612  1.00 27.89           C  
ATOM    141  CD2 PHE A  19     -32.340  97.788  19.189  1.00 27.27           C  
ATOM    142  CE1 PHE A  19     -34.231  96.237  17.880  1.00 28.25           C  
ATOM    143  CE2 PHE A  19     -32.433  96.429  19.467  1.00 27.68           C  
ATOM    144  CZ  PHE A  19     -33.381  95.653  18.813  1.00 28.16           C  
ATOM    145  N   TYR A  20     -31.383  98.477  15.377  1.00 27.29           N  
ATOM    146  CA  TYR A  20     -31.521  97.627  14.195  1.00 27.40           C  
ATOM    147  C   TYR A  20     -31.291  96.147  14.502  1.00 27.74           C  
ATOM    148  O   TYR A  20     -30.153  95.717  14.720  1.00 27.73           O  
ATOM    149  CB  TYR A  20     -30.584  98.085  13.072  1.00 27.28           C  
ATOM    150  CG  TYR A  20     -30.714  97.266  11.804  1.00 27.24           C  
ATOM    151  CD1 TYR A  20     -29.854  96.197  11.552  1.00 27.34           C  
ATOM    152  CD2 TYR A  20     -31.703  97.552  10.861  1.00 27.12           C  
ATOM    153  CE1 TYR A  20     -29.974  95.432  10.394  1.00 27.52           C  
ATOM    154  CE2 TYR A  20     -31.830  96.792   9.697  1.00 27.46           C  
ATOM    155  CZ  TYR A  20     -30.960  95.734   9.473  1.00 27.21           C  
ATOM    156  OH  TYR A  20     -31.071  94.977   8.332  1.00 27.14           O  
ATOM    157  N   GLU A  21     -32.386  95.384  14.514  1.00 28.01           N  
ATOM    158  CA  GLU A  21     -32.367  93.915  14.631  1.00 28.19           C  
ATOM    159  C   GLU A  21     -31.435  93.351  15.716  1.00 28.45           C  
ATOM    160  O   GLU A  21     -30.761  92.340  15.504  1.00 28.62           O  
ATOM    161  CB  GLU A  21     -32.048  93.275  13.273  1.00 28.06           C  
ATOM    162  CG  GLU A  21     -33.108  93.491  12.203  1.00 27.92           C  
ATOM    163  CD  GLU A  21     -32.785  92.779  10.902  1.00 28.21           C  
ATOM    164  OE1 GLU A  21     -31.656  92.259  10.761  1.00 28.12           O  
ATOM    165  OE2 GLU A  21     -33.664  92.740  10.014  1.00 28.54           O  
ATOM    166  N   GLY A  22     -31.407  94.005  16.874  1.00 28.58           N  
ATOM    167  CA  GLY A  22     -30.561  93.570  17.982  1.00 28.74           C  
ATOM    168  C   GLY A  22     -29.427  94.526  18.300  1.00 28.94           C  
ATOM    169  O   GLY A  22     -28.870  94.486  19.398  1.00 29.10           O  
ATOM    170  N   ILE A  23     -29.083  95.381  17.336  1.00 28.81           N  
ATOM    171  CA  ILE A  23     -28.017  96.364  17.515  1.00 28.79           C  
ATOM    172  C   ILE A  23     -28.581  97.677  18.042  1.00 28.91           C  
ATOM    173  O   ILE A  23     -29.576  98.179  17.520  1.00 29.03           O  
ATOM    174  CB  ILE A  23     -27.283  96.655  16.186  1.00 28.71           C  
ATOM    175  CG1 ILE A  23     -26.875  95.357  15.490  1.00 28.79           C  
ATOM    176  CG2 ILE A  23     -26.066  97.548  16.421  1.00 28.98           C  
ATOM    177  CD1 ILE A  23     -26.648  95.510  13.998  1.00 28.56           C  
ATOM    178  N   ALA A  24     -27.952  98.225  19.077  1.00 29.02           N  
ATOM    179  CA  ALA A  24     -28.231  99.597  19.497  1.00 29.27           C  
ATOM    180  C   ALA A  24     -27.172 100.515  18.910  1.00 29.47           C  
ATOM    181  O   ALA A  24     -25.995 100.146  18.839  1.00 29.57           O  
ATOM    182  CB  ALA A  24     -28.257  99.714  21.005  1.00 29.36           C  
ATOM    183  N   LYS A  25     -27.594 101.705  18.494  1.00 29.55           N  
ATOM    184  CA  LYS A  25     -26.708 102.643  17.814  1.00 29.85           C  
ATOM    185  C   LYS A  25     -26.744 104.029  18.449  1.00 29.96           C  
ATOM    186  O   LYS A  25     -27.684 104.805  18.228  1.00 30.18           O  
ATOM    187  CB  LYS A  25     -27.063 102.720  16.325  1.00 29.79           C  
ATOM    188  CG  LYS A  25     -26.051 103.466  15.462  1.00 30.24           C  
ATOM    189  CD  LYS A  25     -26.410 103.384  13.976  1.00 30.53           C  
ATOM    190  CE  LYS A  25     -27.420 104.456  13.562  1.00 31.65           C  
ATOM    191  NZ  LYS A  25     -26.868 105.840  13.680  1.00 32.09           N  
ATOM    192  N   VAL A  26     -25.717 104.326  19.243  1.00 29.89           N  
ATOM    193  CA  VAL A  26     -25.519 105.662  19.801  1.00 29.81           C  
ATOM    194  C   VAL A  26     -24.748 106.512  18.789  1.00 29.74           C  
ATOM    195  O   VAL A  26     -23.642 106.153  18.377  1.00 29.80           O  
ATOM    196  CB  VAL A  26     -24.794 105.613  21.173  1.00 29.98           C  
ATOM    197  CG1 VAL A  26     -24.372 107.012  21.632  1.00 29.69           C  
ATOM    198  CG2 VAL A  26     -25.686 104.951  22.221  1.00 29.82           C  
ATOM    199  N   THR A  27     -25.352 107.627  18.390  1.00 29.57           N  
ATOM    200  CA  THR A  27     -24.799 108.502  17.362  1.00 29.54           C  
ATOM    201  C   THR A  27     -24.584 109.900  17.933  1.00 29.64           C  
ATOM    202  O   THR A  27     -25.507 110.482  18.499  1.00 29.77           O  
ATOM    203  CB  THR A  27     -25.757 108.619  16.147  1.00 29.52           C  
ATOM    204  OG1 THR A  27     -26.413 107.365  15.907  1.00 29.58           O  
ATOM    205  CG2 THR A  27     -25.007 109.047  14.903  1.00 29.09           C  
ATOM    206  N   ILE A  28     -23.375 110.438  17.788  1.00 29.53           N  
ATOM    207  CA  ILE A  28     -23.110 111.827  18.169  1.00 29.40           C  
ATOM    208  C   ILE A  28     -23.667 112.758  17.089  1.00 29.07           C  
ATOM    209  O   ILE A  28     -23.158 112.798  15.967  1.00 28.82           O  
ATOM    210  CB  ILE A  28     -21.599 112.105  18.396  1.00 29.64           C  
ATOM    211  CG1 ILE A  28     -21.015 111.123  19.418  1.00 29.79           C  
ATOM    212  CG2 ILE A  28     -21.378 113.557  18.841  1.00 29.65           C  
ATOM    213  CD1 ILE A  28     -19.497 111.024  19.390  1.00 30.74           C  
ATOM    214  N   ASN A  29     -24.716 113.496  17.443  1.00 28.97           N  
ATOM    215  CA  ASN A  29     -25.446 114.332  16.490  1.00 28.88           C  
ATOM    216  C   ASN A  29     -25.096 115.822  16.619  1.00 28.86           C  
ATOM    217  O   ASN A  29     -25.942 116.654  16.948  1.00 28.82           O  
ATOM    218  CB  ASN A  29     -26.957 114.088  16.636  1.00 28.89           C  
ATOM    219  CG  ASN A  29     -27.786 114.876  15.636  1.00 28.65           C  
ATOM    220  OD1 ASN A  29     -27.570 114.802  14.429  1.00 29.13           O  
ATOM    221  ND2 ASN A  29     -28.748 115.633  16.143  1.00 28.35           N  
ATOM    222  N   ARG A  30     -23.831 116.142  16.363  1.00 28.89           N  
ATOM    223  CA  ARG A  30     -23.363 117.527  16.353  1.00 28.87           C  
ATOM    224  C   ARG A  30     -22.396 117.777  15.189  1.00 29.09           C  
ATOM    225  O   ARG A  30     -21.286 118.271  15.408  1.00 29.09           O  
ATOM    226  CB  ARG A  30     -22.705 117.890  17.692  1.00 28.79           C  
ATOM    227  CG  ARG A  30     -23.639 118.560  18.692  1.00 28.51           C  
ATOM    228  CD  ARG A  30     -23.031 118.637  20.090  1.00 28.58           C  
ATOM    229  NE  ARG A  30     -21.870 119.531  20.180  1.00 28.34           N  
ATOM    230  CZ  ARG A  30     -21.917 120.813  20.548  1.00 27.22           C  
ATOM    231  NH1 ARG A  30     -23.072 121.384  20.863  1.00 27.19           N  
ATOM    232  NH2 ARG A  30     -20.802 121.529  20.603  1.00 25.70           N  
ATOM    233  N   PRO A  31     -22.821 117.455  13.946  1.00 29.27           N  
ATOM    234  CA  PRO A  31     -21.928 117.534  12.780  1.00 29.46           C  
ATOM    235  C   PRO A  31     -21.438 118.945  12.447  1.00 29.53           C  
ATOM    236  O   PRO A  31     -20.407 119.091  11.786  1.00 29.61           O  
ATOM    237  CB  PRO A  31     -22.797 116.999  11.635  1.00 29.44           C  
ATOM    238  CG  PRO A  31     -24.194 117.240  12.078  1.00 29.57           C  
ATOM    239  CD  PRO A  31     -24.170 117.004  13.555  1.00 29.32           C  
ATOM    240  N   GLU A  32     -22.174 119.960  12.900  1.00 29.58           N  
ATOM    241  CA  GLU A  32     -21.834 121.365  12.659  1.00 29.84           C  
ATOM    242  C   GLU A  32     -20.509 121.732  13.331  1.00 29.77           C  
ATOM    243  O   GLU A  32     -19.697 122.471  12.769  1.00 29.76           O  
ATOM    244  CB  GLU A  32     -22.946 122.292  13.170  1.00 30.08           C  
ATOM    245  CG  GLU A  32     -24.338 121.653  13.289  1.00 31.33           C  
ATOM    246  CD  GLU A  32     -24.547 120.903  14.607  1.00 32.46           C  
ATOM    247  OE1 GLU A  32     -24.042 121.359  15.658  1.00 32.58           O  
ATOM    248  OE2 GLU A  32     -25.227 119.854  14.590  1.00 32.86           O  
ATOM    249  N   VAL A  33     -20.311 121.203  14.538  1.00 29.70           N  
ATOM    250  CA  VAL A  33     -19.078 121.383  15.302  1.00 29.38           C  
ATOM    251  C   VAL A  33     -18.171 120.150  15.114  1.00 29.20           C  
ATOM    252  O   VAL A  33     -17.189 119.956  15.842  1.00 29.03           O  
ATOM    253  CB  VAL A  33     -19.396 121.668  16.801  1.00 29.37           C  
ATOM    254  CG1 VAL A  33     -19.807 120.391  17.538  1.00 29.46           C  
ATOM    255  CG2 VAL A  33     -18.225 122.354  17.494  1.00 29.18           C  
ATOM    256  N   ARG A  34     -18.522 119.334  14.119  1.00 28.97           N  
ATOM    257  CA  ARG A  34     -17.763 118.142  13.720  1.00 28.94           C  
ATOM    258  C   ARG A  34     -17.785 117.044  14.800  1.00 29.00           C  
ATOM    259  O   ARG A  34     -16.806 116.318  15.002  1.00 29.03           O  
ATOM    260  CB  ARG A  34     -16.341 118.526  13.276  1.00 28.85           C  
ATOM    261  CG  ARG A  34     -15.774 117.664  12.162  1.00 28.97           C  
ATOM    262  CD  ARG A  34     -15.249 118.505  11.012  1.00 28.90           C  
ATOM    263  NE  ARG A  34     -16.339 118.989  10.165  1.00 29.84           N  
ATOM    264  CZ  ARG A  34     -16.188 119.784   9.107  1.00 30.41           C  
ATOM    265  NH1 ARG A  34     -17.251 120.165   8.408  1.00 30.03           N  
ATOM    266  NH2 ARG A  34     -14.981 120.204   8.744  1.00 30.60           N  
ATOM    267  N   ASN A  35     -18.930 116.941  15.478  1.00 28.90           N  
ATOM    268  CA  ASN A  35     -19.222 115.910  16.484  1.00 28.66           C  
ATOM    269  C   ASN A  35     -18.467 116.016  17.810  1.00 28.57           C  
ATOM    270  O   ASN A  35     -18.332 115.033  18.535  1.00 28.66           O  
ATOM    271  CB  ASN A  35     -19.115 114.499  15.891  1.00 28.78           C  
ATOM    272  CG  ASN A  35     -20.165 114.230  14.827  1.00 29.18           C  
ATOM    273  OD1 ASN A  35     -21.238 114.836  14.826  1.00 29.65           O  
ATOM    274  ND2 ASN A  35     -19.860 113.313  13.917  1.00 29.44           N  
ATOM    275  N   ALA A  36     -17.993 117.217  18.124  1.00 28.67           N  
ATOM    276  CA  ALA A  36     -17.425 117.505  19.438  1.00 28.91           C  
ATOM    277  C   ALA A  36     -18.513 117.407  20.509  1.00 29.10           C  
ATOM    278  O   ALA A  36     -19.679 117.725  20.247  1.00 29.24           O  
ATOM    279  CB  ALA A  36     -16.796 118.886  19.451  1.00 28.95           C  
ATOM    280  N   PHE A  37     -18.130 116.970  21.708  1.00 29.05           N  
ATOM    281  CA  PHE A  37     -19.081 116.824  22.811  1.00 29.01           C  
ATOM    282  C   PHE A  37     -19.026 117.952  23.840  1.00 29.22           C  
ATOM    283  O   PHE A  37     -17.950 118.442  24.201  1.00 29.34           O  
ATOM    284  CB  PHE A  37     -18.950 115.455  23.501  1.00 28.80           C  
ATOM    285  CG  PHE A  37     -17.545 115.100  23.912  1.00 29.02           C  
ATOM    286  CD1 PHE A  37     -16.980 115.631  25.067  1.00 28.98           C  
ATOM    287  CD2 PHE A  37     -16.795 114.212  23.153  1.00 29.29           C  
ATOM    288  CE1 PHE A  37     -15.685 115.297  25.441  1.00 28.49           C  
ATOM    289  CE2 PHE A  37     -15.500 113.869  23.524  1.00 28.29           C  
ATOM    290  CZ  PHE A  37     -14.947 114.413  24.671  1.00 28.41           C  
ATOM    291  N   THR A  38     -20.211 118.365  24.281  1.00 29.24           N  
ATOM    292  CA  THR A  38     -20.372 119.234  25.438  1.00 29.35           C  
ATOM    293  C   THR A  38     -20.609 118.326  26.654  1.00 29.36           C  
ATOM    294  O   THR A  38     -20.724 117.109  26.489  1.00 29.33           O  
ATOM    295  CB  THR A  38     -21.571 120.196  25.248  1.00 29.41           C  
ATOM    296  OG1 THR A  38     -22.770 119.442  25.040  1.00 29.82           O  
ATOM    297  CG2 THR A  38     -21.349 121.115  24.059  1.00 29.48           C  
ATOM    298  N   PRO A  39     -20.660 118.896  27.880  1.00 29.36           N  
ATOM    299  CA  PRO A  39     -21.076 118.080  29.028  1.00 29.25           C  
ATOM    300  C   PRO A  39     -22.459 117.442  28.852  1.00 29.14           C  
ATOM    301  O   PRO A  39     -22.660 116.304  29.284  1.00 29.11           O  
ATOM    302  CB  PRO A  39     -21.094 119.085  30.183  1.00 29.15           C  
ATOM    303  CG  PRO A  39     -20.109 120.115  29.781  1.00 29.33           C  
ATOM    304  CD  PRO A  39     -20.305 120.264  28.301  1.00 29.40           C  
ATOM    305  N   LYS A  40     -23.386 118.164  28.218  1.00 28.98           N  
ATOM    306  CA  LYS A  40     -24.733 117.650  27.958  1.00 28.88           C  
ATOM    307  C   LYS A  40     -24.703 116.458  27.002  1.00 29.05           C  
ATOM    308  O   LYS A  40     -25.443 115.489  27.186  1.00 29.22           O  
ATOM    309  CB  LYS A  40     -25.637 118.746  27.391  1.00 28.78           C  
ATOM    310  CG  LYS A  40     -27.110 118.364  27.337  1.00 28.53           C  
ATOM    311  CD  LYS A  40     -27.927 119.373  26.551  1.00 27.97           C  
ATOM    312  CE  LYS A  40     -29.390 118.967  26.509  1.00 28.25           C  
ATOM    313  NZ  LYS A  40     -30.169 119.773  25.528  1.00 28.45           N  
ATOM    314  N   THR A  41     -23.844 116.539  25.989  1.00 28.95           N  
ATOM    315  CA  THR A  41     -23.681 115.462  25.017  1.00 28.80           C  
ATOM    316  C   THR A  41     -23.249 114.171  25.712  1.00 28.67           C  
ATOM    317  O   THR A  41     -23.853 113.119  25.505  1.00 28.75           O  
ATOM    318  CB  THR A  41     -22.648 115.825  23.928  1.00 28.80           C  
ATOM    319  OG1 THR A  41     -22.642 117.240  23.711  1.00 28.68           O  
ATOM    320  CG2 THR A  41     -22.974 115.119  22.627  1.00 28.73           C  
ATOM    321  N   VAL A  42     -22.211 114.266  26.541  1.00 28.57           N  
ATOM    322  CA  VAL A  42     -21.707 113.113  27.290  1.00 28.61           C  
ATOM    323  C   VAL A  42     -22.808 112.548  28.191  1.00 28.99           C  
ATOM    324  O   VAL A  42     -23.043 111.337  28.202  1.00 28.97           O  
ATOM    325  CB  VAL A  42     -20.447 113.459  28.134  1.00 28.40           C  
ATOM    326  CG1 VAL A  42     -19.902 112.216  28.812  1.00 28.00           C  
ATOM    327  CG2 VAL A  42     -19.366 114.092  27.270  1.00 27.78           C  
ATOM    328  N   ALA A  43     -23.486 113.436  28.922  1.00 29.18           N  
ATOM    329  CA  ALA A  43     -24.579 113.052  29.821  1.00 29.36           C  
ATOM    330  C   ALA A  43     -25.701 112.305  29.093  1.00 29.47           C  
ATOM    331  O   ALA A  43     -26.319 111.398  29.659  1.00 29.44           O  
ATOM    332  CB  ALA A  43     -25.132 114.275  30.544  1.00 29.38           C  
ATOM    333  N   GLU A  44     -25.952 112.694  27.843  1.00 29.57           N  
ATOM    334  CA  GLU A  44     -26.906 111.992  26.987  1.00 29.51           C  
ATOM    335  C   GLU A  44     -26.365 110.617  26.576  1.00 29.78           C  
ATOM    336  O   GLU A  44     -27.089 109.622  26.631  1.00 29.97           O  
ATOM    337  CB  GLU A  44     -27.286 112.838  25.763  1.00 29.35           C  
ATOM    338  CG  GLU A  44     -28.095 114.098  26.108  1.00 29.30           C  
ATOM    339  CD  GLU A  44     -28.956 114.630  24.960  1.00 29.02           C  
ATOM    340  OE1 GLU A  44     -28.692 114.305  23.782  1.00 28.61           O  
ATOM    341  OE2 GLU A  44     -29.909 115.388  25.245  1.00 27.48           O  
ATOM    342  N   MET A  45     -25.089 110.563  26.192  1.00 29.86           N  
ATOM    343  CA  MET A  45     -24.436 109.299  25.829  1.00 30.07           C  
ATOM    344  C   MET A  45     -24.425 108.281  26.976  1.00 30.12           C  
ATOM    345  O   MET A  45     -24.678 107.097  26.761  1.00 30.08           O  
ATOM    346  CB  MET A  45     -23.011 109.544  25.320  1.00 30.08           C  
ATOM    347  CG  MET A  45     -22.943 110.026  23.879  1.00 30.42           C  
ATOM    348  SD  MET A  45     -21.261 110.183  23.241  1.00 30.03           S  
ATOM    349  CE  MET A  45     -20.803 111.805  23.852  1.00 29.87           C  
ATOM    350  N   ILE A  46     -24.134 108.754  28.187  1.00 30.18           N  
ATOM    351  CA  ILE A  46     -24.139 107.909  29.383  1.00 30.07           C  
ATOM    352  C   ILE A  46     -25.534 107.319  29.599  1.00 30.09           C  
ATOM    353  O   ILE A  46     -25.677 106.113  29.809  1.00 29.96           O  
ATOM    354  CB  ILE A  46     -23.655 108.689  30.638  1.00 30.01           C  
ATOM    355  CG1 ILE A  46     -22.172 109.052  30.496  1.00 30.15           C  
ATOM    356  CG2 ILE A  46     -23.885 107.879  31.915  1.00 29.81           C  
ATOM    357  CD1 ILE A  46     -21.691 110.139  31.443  1.00 30.09           C  
ATOM    358  N   ASP A  47     -26.551 108.177  29.518  1.00 30.19           N  
ATOM    359  CA  ASP A  47     -27.946 107.766  29.649  1.00 30.38           C  
ATOM    360  C   ASP A  47     -28.310 106.731  28.592  1.00 30.40           C  
ATOM    361  O   ASP A  47     -28.934 105.714  28.900  1.00 30.39           O  
ATOM    362  CB  ASP A  47     -28.873 108.978  29.521  1.00 30.59           C  
ATOM    363  CG  ASP A  47     -30.317 108.657  29.882  1.00 31.40           C  
ATOM    364  OD1 ASP A  47     -30.551 108.046  30.950  1.00 32.93           O  
ATOM    365  OD2 ASP A  47     -31.222 109.028  29.105  1.00 31.07           O  
ATOM    366  N   ALA A  48     -27.902 107.003  27.352  1.00 30.39           N  
ATOM    367  CA  ALA A  48     -28.193 106.138  26.213  1.00 30.24           C  
ATOM    368  C   ALA A  48     -27.591 104.754  26.404  1.00 30.23           C  
ATOM    369  O   ALA A  48     -28.265 103.746  26.196  1.00 30.41           O  
ATOM    370  CB  ALA A  48     -27.685 106.770  24.929  1.00 30.23           C  
ATOM    371  N   PHE A  49     -26.325 104.718  26.814  1.00 30.28           N  
ATOM    372  CA  PHE A  49     -25.623 103.469  27.088  1.00 30.03           C  
ATOM    373  C   PHE A  49     -26.222 102.721  28.275  1.00 29.82           C  
ATOM    374  O   PHE A  49     -26.326 101.496  28.241  1.00 29.89           O  
ATOM    375  CB  PHE A  49     -24.135 103.734  27.321  1.00 30.15           C  
ATOM    376  CG  PHE A  49     -23.326 103.804  26.058  1.00 30.38           C  
ATOM    377  CD1 PHE A  49     -22.667 102.678  25.577  1.00 31.17           C  
ATOM    378  CD2 PHE A  49     -23.219 104.995  25.349  1.00 30.64           C  
ATOM    379  CE1 PHE A  49     -21.911 102.733  24.409  1.00 31.57           C  
ATOM    380  CE2 PHE A  49     -22.468 105.063  24.179  1.00 31.71           C  
ATOM    381  CZ  PHE A  49     -21.812 103.929  23.707  1.00 31.52           C  
ATOM    382  N   SER A  50     -26.621 103.465  29.310  1.00 29.60           N  
ATOM    383  CA  SER A  50     -27.247 102.889  30.508  1.00 29.44           C  
ATOM    384  C   SER A  50     -28.538 102.158  30.168  1.00 29.45           C  
ATOM    385  O   SER A  50     -28.843 101.118  30.748  1.00 29.39           O  
ATOM    386  CB  SER A  50     -27.534 103.975  31.547  1.00 29.36           C  
ATOM    387  OG  SER A  50     -26.364 104.702  31.875  1.00 29.29           O  
ATOM    388  N   ARG A  51     -29.289 102.723  29.225  1.00 29.65           N  
ATOM    389  CA  ARG A  51     -30.515 102.118  28.715  1.00 29.63           C  
ATOM    390  C   ARG A  51     -30.196 100.950  27.789  1.00 29.93           C  
ATOM    391  O   ARG A  51     -30.917  99.954  27.764  1.00 30.04           O  
ATOM    392  CB  ARG A  51     -31.350 103.165  27.981  1.00 29.36           C  
ATOM    393  CG  ARG A  51     -31.837 104.274  28.890  1.00 29.19           C  
ATOM    394  CD  ARG A  51     -32.452 105.434  28.124  1.00 28.30           C  
ATOM    395  NE  ARG A  51     -33.164 106.325  29.037  1.00 27.03           N  
ATOM    396  CZ  ARG A  51     -34.428 106.158  29.411  1.00 25.99           C  
ATOM    397  NH1 ARG A  51     -35.134 105.142  28.934  1.00 25.69           N  
ATOM    398  NH2 ARG A  51     -34.990 107.010  30.258  1.00 25.29           N  
ATOM    399  N   ALA A  52     -29.105 101.079  27.037  1.00 30.20           N  
ATOM    400  CA  ALA A  52     -28.632 100.015  26.162  1.00 30.37           C  
ATOM    401  C   ALA A  52     -28.174  98.810  26.971  1.00 30.54           C  
ATOM    402  O   ALA A  52     -28.377  97.669  26.558  1.00 30.71           O  
ATOM    403  CB  ALA A  52     -27.509 100.520  25.268  1.00 30.52           C  
ATOM    404  N   ARG A  53     -27.563  99.071  28.127  1.00 30.63           N  
ATOM    405  CA  ARG A  53     -27.113  98.012  29.026  1.00 30.70           C  
ATOM    406  C   ARG A  53     -28.287  97.178  29.547  1.00 30.57           C  
ATOM    407  O   ARG A  53     -28.192  95.951  29.618  1.00 30.61           O  
ATOM    408  CB  ARG A  53     -26.300  98.593  30.188  1.00 30.41           C  
ATOM    409  CG  ARG A  53     -25.653  97.532  31.072  1.00 31.13           C  
ATOM    410  CD  ARG A  53     -24.770  98.114  32.166  1.00 31.28           C  
ATOM    411  NE  ARG A  53     -25.490  99.010  33.069  1.00 32.71           N  
ATOM    412  CZ  ARG A  53     -25.093  99.316  34.303  1.00 33.29           C  
ATOM    413  NH1 ARG A  53     -23.987  98.780  34.807  1.00 33.00           N  
ATOM    414  NH2 ARG A  53     -25.813 100.149  35.044  1.00 33.82           N  
ATOM    415  N   ASP A  54     -29.389  97.849  29.881  1.00 30.53           N  
ATOM    416  CA  ASP A  54     -30.556  97.212  30.502  1.00 30.76           C  
ATOM    417  C   ASP A  54     -31.498  96.502  29.522  1.00 30.80           C  
ATOM    418  O   ASP A  54     -32.043  95.442  29.839  1.00 30.65           O  
ATOM    419  CB  ASP A  54     -31.347  98.236  31.329  1.00 30.85           C  
ATOM    420  CG  ASP A  54     -30.764  98.454  32.720  1.00 31.37           C  
ATOM    421  OD1 ASP A  54     -29.583  98.856  32.839  1.00 30.96           O  
ATOM    422  OD2 ASP A  54     -31.504  98.233  33.704  1.00 32.58           O  
ATOM    423  N   ASP A  55     -31.692  97.092  28.343  1.00 31.03           N  
ATOM    424  CA  ASP A  55     -32.635  96.570  27.350  1.00 31.42           C  
ATOM    425  C   ASP A  55     -32.252  95.177  26.837  1.00 31.32           C  
ATOM    426  O   ASP A  55     -31.281  95.021  26.095  1.00 31.37           O  
ATOM    427  CB  ASP A  55     -32.785  97.551  26.177  1.00 31.73           C  
ATOM    428  CG  ASP A  55     -33.433  98.881  26.587  1.00 33.03           C  
ATOM    429  OD1 ASP A  55     -33.564  99.762  25.703  1.00 34.03           O  
ATOM    430  OD2 ASP A  55     -33.803  99.054  27.773  1.00 33.01           O  
ATOM    431  N   GLN A  56     -33.034  94.174  27.228  1.00 31.17           N  
ATOM    432  CA  GLN A  56     -32.766  92.776  26.866  1.00 31.13           C  
ATOM    433  C   GLN A  56     -32.816  92.492  25.358  1.00 31.01           C  
ATOM    434  O   GLN A  56     -32.347  91.448  24.900  1.00 30.95           O  
ATOM    435  CB  GLN A  56     -33.717  91.837  27.619  1.00 31.03           C  
ATOM    436  CG  GLN A  56     -33.532  91.863  29.135  1.00 31.43           C  
ATOM    437  CD  GLN A  56     -34.318  90.780  29.856  1.00 31.40           C  
ATOM    438  OE1 GLN A  56     -35.485  90.525  29.548  1.00 31.54           O  
ATOM    439  NE2 GLN A  56     -33.682  90.145  30.835  1.00 31.66           N  
ATOM    440  N   ASN A  57     -33.372  93.432  24.597  1.00 30.94           N  
ATOM    441  CA  ASN A  57     -33.496  93.298  23.145  1.00 30.78           C  
ATOM    442  C   ASN A  57     -32.177  93.510  22.411  1.00 30.74           C  
ATOM    443  O   ASN A  57     -31.958  92.929  21.346  1.00 30.73           O  
ATOM    444  CB  ASN A  57     -34.546  94.273  22.604  1.00 30.65           C  
ATOM    445  CG  ASN A  57     -35.912  94.069  23.230  1.00 30.46           C  
ATOM    446  OD1 ASN A  57     -36.549  93.032  23.045  1.00 30.17           O  
ATOM    447  ND2 ASN A  57     -36.374  95.069  23.969  1.00 30.51           N  
ATOM    448  N   VAL A  58     -31.310  94.347  22.978  1.00 30.67           N  
ATOM    449  CA  VAL A  58     -30.033  94.682  22.344  1.00 30.78           C  
ATOM    450  C   VAL A  58     -28.907  93.744  22.786  1.00 30.82           C  
ATOM    451  O   VAL A  58     -28.844  93.345  23.950  1.00 30.94           O  
ATOM    452  CB  VAL A  58     -29.638  96.180  22.552  1.00 30.78           C  
ATOM    453  CG1 VAL A  58     -29.795  96.601  23.995  1.00 30.79           C  
ATOM    454  CG2 VAL A  58     -28.216  96.446  22.080  1.00 30.86           C  
ATOM    455  N   SER A  59     -28.036  93.394  21.841  1.00 30.63           N  
ATOM    456  CA  SER A  59     -26.908  92.510  22.108  1.00 30.61           C  
ATOM    457  C   SER A  59     -25.558  93.175  21.858  1.00 30.68           C  
ATOM    458  O   SER A  59     -24.576  92.870  22.541  1.00 30.75           O  
ATOM    459  CB  SER A  59     -27.025  91.231  21.284  1.00 30.63           C  
ATOM    460  OG  SER A  59     -28.183  90.504  21.648  1.00 30.98           O  
ATOM    461  N   VAL A  60     -25.504  94.067  20.868  1.00 30.74           N  
ATOM    462  CA  VAL A  60     -24.279  94.813  20.554  1.00 30.77           C  
ATOM    463  C   VAL A  60     -24.574  96.307  20.424  1.00 30.73           C  
ATOM    464  O   VAL A  60     -25.599  96.705  19.863  1.00 30.66           O  
ATOM    465  CB  VAL A  60     -23.576  94.292  19.256  1.00 30.82           C  
ATOM    466  CG1 VAL A  60     -22.271  95.043  18.994  1.00 30.48           C  
ATOM    467  CG2 VAL A  60     -23.294  92.803  19.345  1.00 30.76           C  
ATOM    468  N   ILE A  61     -23.668  97.126  20.950  1.00 30.76           N  
ATOM    469  CA  ILE A  61     -23.775  98.578  20.836  1.00 31.02           C  
ATOM    470  C   ILE A  61     -22.737  99.110  19.846  1.00 31.06           C  
ATOM    471  O   ILE A  61     -21.617  98.601  19.780  1.00 31.06           O  
ATOM    472  CB  ILE A  61     -23.605  99.271  22.211  1.00 31.00           C  
ATOM    473  CG1 ILE A  61     -24.532  98.629  23.247  1.00 31.07           C  
ATOM    474  CG2 ILE A  61     -23.887 100.771  22.109  1.00 30.99           C  
ATOM    475  CD1 ILE A  61     -24.009  98.694  24.661  1.00 31.91           C  
ATOM    476  N   VAL A  62     -23.123 100.117  19.067  1.00 31.08           N  
ATOM    477  CA  VAL A  62     -22.185 100.814  18.189  1.00 31.18           C  
ATOM    478  C   VAL A  62     -22.176 102.327  18.440  1.00 31.41           C  
ATOM    479  O   VAL A  62     -23.230 102.952  18.601  1.00 31.48           O  
ATOM    480  CB  VAL A  62     -22.422 100.510  16.679  1.00 31.01           C  
ATOM    481  CG1 VAL A  62     -21.968  99.109  16.334  1.00 31.30           C  
ATOM    482  CG2 VAL A  62     -23.872 100.691  16.295  1.00 31.01           C  
ATOM    483  N   LEU A  63     -20.976 102.899  18.488  1.00 31.51           N  
ATOM    484  CA  LEU A  63     -20.804 104.341  18.631  1.00 31.53           C  
ATOM    485  C   LEU A  63     -20.272 104.928  17.334  1.00 31.69           C  
ATOM    486  O   LEU A  63     -19.358 104.372  16.722  1.00 31.96           O  
ATOM    487  CB  LEU A  63     -19.865 104.665  19.796  1.00 31.52           C  
ATOM    488  CG  LEU A  63     -19.440 106.120  20.035  1.00 31.51           C  
ATOM    489  CD1 LEU A  63     -20.634 107.038  20.272  1.00 31.82           C  
ATOM    490  CD2 LEU A  63     -18.468 106.193  21.200  1.00 31.49           C  
ATOM    491  N   THR A  64     -20.851 106.055  16.926  1.00 31.80           N  
ATOM    492  CA  THR A  64     -20.513 106.692  15.655  1.00 31.97           C  
ATOM    493  C   THR A  64     -20.909 108.173  15.629  1.00 32.07           C  
ATOM    494  O   THR A  64     -21.587 108.660  16.539  1.00 32.05           O  
ATOM    495  CB  THR A  64     -21.164 105.943  14.461  1.00 31.91           C  
ATOM    496  OG1 THR A  64     -20.719 106.516  13.228  1.00 32.36           O  
ATOM    497  CG2 THR A  64     -22.693 106.002  14.532  1.00 32.24           C  
ATOM    498  N   GLY A  65     -20.468 108.878  14.589  1.00 32.18           N  
ATOM    499  CA  GLY A  65     -20.852 110.270  14.357  1.00 32.47           C  
ATOM    500  C   GLY A  65     -22.029 110.357  13.406  1.00 32.76           C  
ATOM    501  O   GLY A  65     -22.386 109.360  12.776  1.00 32.87           O  
ATOM    502  N   GLU A  66     -22.622 111.545  13.294  1.00 33.02           N  
ATOM    503  CA  GLU A  66     -23.855 111.740  12.519  1.00 33.38           C  
ATOM    504  C   GLU A  66     -23.703 111.410  11.027  1.00 33.61           C  
ATOM    505  O   GLU A  66     -24.125 110.339  10.578  1.00 33.72           O  
ATOM    506  CB  GLU A  66     -24.438 113.149  12.751  1.00 33.36           C  
ATOM    507  CG  GLU A  66     -25.582 113.587  11.806  1.00 34.30           C  
ATOM    508  CD  GLU A  66     -26.638 112.508  11.554  1.00 35.27           C  
ATOM    509  OE1 GLU A  66     -27.125 111.892  12.529  1.00 35.84           O  
ATOM    510  OE2 GLU A  66     -26.983 112.284  10.372  1.00 34.83           O  
ATOM    511  N   GLY A  67     -23.113 112.328  10.265  1.00 33.69           N  
ATOM    512  CA  GLY A  67     -22.869 112.105   8.843  1.00 33.69           C  
ATOM    513  C   GLY A  67     -21.482 111.537   8.641  1.00 33.61           C  
ATOM    514  O   GLY A  67     -20.952 110.848   9.516  1.00 33.77           O  
ATOM    515  N   ASP A  68     -20.891 111.827   7.488  1.00 33.49           N  
ATOM    516  CA  ASP A  68     -19.500 111.474   7.242  1.00 33.59           C  
ATOM    517  C   ASP A  68     -18.596 112.566   7.814  1.00 33.43           C  
ATOM    518  O   ASP A  68     -19.048 113.414   8.591  1.00 33.46           O  
ATOM    519  CB  ASP A  68     -19.251 111.280   5.742  1.00 33.89           C  
ATOM    520  CG  ASP A  68     -20.124 110.187   5.131  1.00 34.78           C  
ATOM    521  OD1 ASP A  68     -20.756 109.414   5.889  1.00 35.64           O  
ATOM    522  OD2 ASP A  68     -20.178 110.104   3.883  1.00 35.14           O  
ATOM    523  N   LEU A  69     -17.318 112.533   7.438  1.00 33.17           N  
ATOM    524  CA  LEU A  69     -16.344 113.569   7.821  1.00 32.89           C  
ATOM    525  C   LEU A  69     -15.908 113.517   9.288  1.00 32.54           C  
ATOM    526  O   LEU A  69     -14.797 113.932   9.614  1.00 32.54           O  
ATOM    527  CB  LEU A  69     -16.849 114.983   7.469  1.00 32.92           C  
ATOM    528  CG  LEU A  69     -16.859 115.459   6.011  1.00 32.80           C  
ATOM    529  CD1 LEU A  69     -18.050 114.916   5.232  1.00 32.91           C  
ATOM    530  CD2 LEU A  69     -16.859 116.977   5.967  1.00 32.85           C  
ATOM    531  N   ALA A  70     -16.773 113.012  10.166  1.00 32.03           N  
ATOM    532  CA  ALA A  70     -16.477 113.009  11.596  1.00 31.73           C  
ATOM    533  C   ALA A  70     -16.997 111.802  12.375  1.00 31.60           C  
ATOM    534  O   ALA A  70     -18.028 111.209  12.036  1.00 31.74           O  
ATOM    535  CB  ALA A  70     -16.972 114.296  12.237  1.00 31.71           C  
ATOM    536  N   PHE A  71     -16.252 111.453  13.420  1.00 31.08           N  
ATOM    537  CA  PHE A  71     -16.682 110.516  14.443  1.00 30.57           C  
ATOM    538  C   PHE A  71     -16.865 111.320  15.724  1.00 30.41           C  
ATOM    539  O   PHE A  71     -17.941 111.310  16.325  1.00 30.40           O  
ATOM    540  CB  PHE A  71     -15.633 109.412  14.624  1.00 30.51           C  
ATOM    541  CG  PHE A  71     -15.852 108.533  15.836  1.00 30.29           C  
ATOM    542  CD1 PHE A  71     -15.049 108.674  16.967  1.00 29.93           C  
ATOM    543  CD2 PHE A  71     -16.842 107.554  15.839  1.00 29.68           C  
ATOM    544  CE1 PHE A  71     -15.237 107.862  18.084  1.00 29.24           C  
ATOM    545  CE2 PHE A  71     -17.036 106.740  16.952  1.00 29.45           C  
ATOM    546  CZ  PHE A  71     -16.232 106.895  18.075  1.00 29.39           C  
ATOM    547  N   CYS A  72     -15.807 112.029  16.121  1.00 30.23           N  
ATOM    548  CA  CYS A  72     -15.823 112.876  17.312  1.00 30.21           C  
ATOM    549  C   CYS A  72     -14.604 113.796  17.353  1.00 30.28           C  
ATOM    550  O   CYS A  72     -13.538 113.449  16.842  1.00 30.34           O  
ATOM    551  CB  CYS A  72     -15.875 112.021  18.576  1.00 30.13           C  
ATOM    552  SG  CYS A  72     -16.315 112.938  20.048  1.00 30.08           S  
ATOM    553  N   SER A  73     -14.768 114.966  17.967  1.00 30.48           N  
ATOM    554  CA  SER A  73     -13.695 115.960  18.039  1.00 30.76           C  
ATOM    555  C   SER A  73     -13.152 116.176  19.452  1.00 31.10           C  
ATOM    556  O   SER A  73     -11.972 116.487  19.618  1.00 31.32           O  
ATOM    557  CB  SER A  73     -14.157 117.297  17.460  1.00 30.61           C  
ATOM    558  OG  SER A  73     -14.517 117.171  16.100  1.00 30.41           O  
ATOM    559  N   GLY A  74     -14.011 116.026  20.457  1.00 31.34           N  
ATOM    560  CA  GLY A  74     -13.623 116.254  21.847  1.00 31.88           C  
ATOM    561  C   GLY A  74     -14.467 117.318  22.521  1.00 32.31           C  
ATOM    562  O   GLY A  74     -15.691 117.303  22.412  1.00 32.42           O  
ATOM    563  N   GLY A  75     -13.814 118.241  23.224  1.00 32.67           N  
ATOM    564  CA  GLY A  75     -14.502 119.371  23.854  1.00 33.30           C  
ATOM    565  C   GLY A  75     -14.716 120.504  22.869  1.00 33.77           C  
ATOM    566  O   GLY A  75     -14.734 120.271  21.658  1.00 33.84           O  
ATOM    567  N   ASP A  76     -14.883 121.727  23.376  1.00 34.20           N  
ATOM    568  CA  ASP A  76     -15.046 122.908  22.512  1.00 34.78           C  
ATOM    569  C   ASP A  76     -15.085 124.256  23.245  1.00 35.13           C  
ATOM    570  O   ASP A  76     -14.059 124.931  23.379  1.00 35.08           O  
ATOM    571  CB  ASP A  76     -16.283 122.767  21.600  1.00 34.88           C  
ATOM    572  CG  ASP A  76     -17.570 122.525  22.373  1.00 35.03           C  
ATOM    573  OD1 ASP A  76     -17.565 121.697  23.312  1.00 35.41           O  
ATOM    574  OD2 ASP A  76     -18.588 123.165  22.031  1.00 34.23           O  
ATOM    575  N   GLN A  77     -16.287 124.625  23.692  1.00 35.60           N  
ATOM    576  CA  GLN A  77     -16.620 125.923  24.296  1.00 35.82           C  
ATOM    577  C   GLN A  77     -16.664 127.079  23.292  1.00 36.07           C  
ATOM    578  O   GLN A  77     -16.850 128.239  23.676  1.00 36.27           O  
ATOM    579  CB  GLN A  77     -15.714 126.248  25.491  1.00 35.88           C  
ATOM    580  CG  GLN A  77     -16.491 126.546  26.759  1.00 35.74           C  
ATOM    581  CD  GLN A  77     -17.262 125.333  27.252  1.00 35.42           C  
ATOM    582  OE1 GLN A  77     -18.473 125.232  27.056  1.00 35.10           O  
ATOM    583  NE2 GLN A  77     -16.556 124.394  27.873  1.00 35.11           N  
ATOM    584  N   LYS A  78     -16.512 126.755  22.008  1.00 36.21           N  
ATOM    585  CA  LYS A  78     -16.572 127.752  20.936  1.00 36.30           C  
ATOM    586  C   LYS A  78     -17.944 127.777  20.267  1.00 36.23           C  
ATOM    587  O   LYS A  78     -18.962 127.486  20.900  1.00 36.24           O  
ATOM    588  CB  LYS A  78     -15.480 127.494  19.904  1.00 36.29           C  
ATOM    589  N   GLY A  87     -19.992 123.660  31.557  1.00 41.92           N  
ATOM    590  CA  GLY A  87     -20.917 123.587  30.431  1.00 41.99           C  
ATOM    591  C   GLY A  87     -22.236 124.291  30.689  1.00 42.03           C  
ATOM    592  O   GLY A  87     -22.302 125.522  30.660  1.00 42.07           O  
ATOM    593  N   GLU A  88     -23.284 123.505  30.938  1.00 41.99           N  
ATOM    594  CA  GLU A  88     -24.626 124.033  31.200  1.00 41.97           C  
ATOM    595  C   GLU A  88     -24.687 124.551  32.637  1.00 41.84           C  
ATOM    596  O   GLU A  88     -24.361 125.705  32.895  1.00 41.79           O  
ATOM    597  CB  GLU A  88     -25.704 122.953  30.988  1.00 41.99           C  
ATOM    598  CG  GLU A  88     -25.289 121.741  30.149  1.00 42.23           C  
ATOM    599  CD  GLU A  88     -25.144 122.049  28.668  1.00 42.99           C  
ATOM    600  OE1 GLU A  88     -24.163 121.568  28.058  1.00 43.26           O  
ATOM    601  OE2 GLU A  88     -26.006 122.766  28.113  1.00 43.15           O  
ATOM    602  N   ASP A  89     -25.147 123.685  33.539  1.00 41.73           N  
ATOM    603  CA  ASP A  89     -24.982 123.785  35.004  1.00 41.48           C  
ATOM    604  C   ASP A  89     -25.187 125.151  35.732  1.00 41.24           C  
ATOM    605  O   ASP A  89     -26.293 125.374  36.223  1.00 41.23           O  
ATOM    606  CB  ASP A  89     -23.738 123.000  35.460  1.00 41.45           C  
ATOM    607  CG  ASP A  89     -23.681 121.587  34.867  1.00 41.63           C  
ATOM    608  OD1 ASP A  89     -22.708 121.275  34.142  1.00 40.79           O  
ATOM    609  OD2 ASP A  89     -24.613 120.793  35.121  1.00 41.60           O  
ATOM    610  N   GLN A  90     -24.206 126.065  35.841  1.00 40.93           N  
ATOM    611  CA  GLN A  90     -22.823 125.981  35.344  1.00 40.51           C  
ATOM    612  C   GLN A  90     -21.894 125.330  36.362  1.00 40.24           C  
ATOM    613  O   GLN A  90     -21.926 125.660  37.550  1.00 40.35           O  
ATOM    614  CB  GLN A  90     -22.269 127.380  35.025  1.00 40.54           C  
ATOM    615  CG  GLN A  90     -22.991 128.173  33.933  1.00 40.41           C  
ATOM    616  CD  GLN A  90     -24.239 128.885  34.429  1.00 40.20           C  
ATOM    617  OE1 GLN A  90     -24.292 129.373  35.561  1.00 39.93           O  
ATOM    618  NE2 GLN A  90     -25.254 128.954  33.576  1.00 40.28           N  
ATOM    619  N   ILE A  91     -21.058 124.423  35.863  1.00 39.80           N  
ATOM    620  CA  ILE A  91     -20.067 123.682  36.644  1.00 39.31           C  
ATOM    621  C   ILE A  91     -19.106 123.021  35.653  1.00 38.89           C  
ATOM    622  O   ILE A  91     -19.552 122.330  34.727  1.00 38.88           O  
ATOM    623  CB  ILE A  91     -20.723 122.620  37.584  1.00 39.41           C  
ATOM    624  CG1 ILE A  91     -20.845 123.165  39.012  1.00 39.45           C  
ATOM    625  CG2 ILE A  91     -19.931 121.310  37.594  1.00 39.27           C  
ATOM    626  CD1 ILE A  91     -21.874 122.447  39.872  1.00 39.37           C  
ATOM    627  N   PRO A  92     -17.789 123.250  35.824  1.00 38.43           N  
ATOM    628  CA  PRO A  92     -16.803 122.567  34.988  1.00 37.85           C  
ATOM    629  C   PRO A  92     -16.801 121.062  35.255  1.00 37.23           C  
ATOM    630  O   PRO A  92     -16.059 120.579  36.115  1.00 37.24           O  
ATOM    631  CB  PRO A  92     -15.472 123.206  35.411  1.00 37.87           C  
ATOM    632  CG  PRO A  92     -15.849 124.475  36.115  1.00 38.30           C  
ATOM    633  CD  PRO A  92     -17.149 124.170  36.779  1.00 38.45           C  
ATOM    634  N   ARG A  93     -17.659 120.344  34.532  1.00 36.50           N  
ATOM    635  CA  ARG A  93     -17.730 118.888  34.609  1.00 35.82           C  
ATOM    636  C   ARG A  93     -16.661 118.255  33.727  1.00 35.05           C  
ATOM    637  O   ARG A  93     -16.159 118.884  32.792  1.00 35.00           O  
ATOM    638  CB  ARG A  93     -19.111 118.386  34.171  1.00 35.89           C  
ATOM    639  CG  ARG A  93     -20.124 118.210  35.297  1.00 36.49           C  
ATOM    640  CD  ARG A  93     -21.361 117.464  34.802  1.00 36.16           C  
ATOM    641  NE  ARG A  93     -22.198 116.965  35.893  1.00 36.66           N  
ATOM    642  CZ  ARG A  93     -23.231 116.136  35.736  1.00 37.15           C  
ATOM    643  NH1 ARG A  93     -23.571 115.700  34.528  1.00 37.47           N  
ATOM    644  NH2 ARG A  93     -23.928 115.737  36.791  1.00 37.02           N  
ATOM    645  N   LEU A  94     -16.318 117.009  34.037  1.00 34.19           N  
ATOM    646  CA  LEU A  94     -15.444 116.207  33.185  1.00 33.23           C  
ATOM    647  C   LEU A  94     -16.008 114.789  33.080  1.00 32.54           C  
ATOM    648  O   LEU A  94     -15.268 113.802  33.069  1.00 32.49           O  
ATOM    649  CB  LEU A  94     -14.015 116.212  33.729  1.00 33.16           C  
ATOM    650  CG  LEU A  94     -12.864 116.044  32.734  1.00 33.11           C  
ATOM    651  CD1 LEU A  94     -12.790 117.205  31.753  1.00 32.58           C  
ATOM    652  CD2 LEU A  94     -11.553 115.909  33.489  1.00 33.42           C  
ATOM    653  N   ASN A  95     -17.336 114.719  32.989  1.00 31.70           N  
ATOM    654  CA  ASN A  95     -18.093 113.467  32.933  1.00 30.91           C  
ATOM    655  C   ASN A  95     -17.731 112.567  31.754  1.00 30.43           C  
ATOM    656  O   ASN A  95     -18.195 111.429  31.662  1.00 30.42           O  
ATOM    657  CB  ASN A  95     -19.599 113.763  32.935  1.00 31.01           C  
ATOM    658  CG  ASN A  95     -20.026 114.688  31.799  1.00 30.70           C  
ATOM    659  OD1 ASN A  95     -19.213 115.107  30.973  1.00 30.48           O  
ATOM    660  ND2 ASN A  95     -21.312 115.005  31.755  1.00 30.65           N  
ATOM    661  N   VAL A  96     -16.906 113.097  30.855  1.00 29.85           N  
ATOM    662  CA  VAL A  96     -16.322 112.341  29.746  1.00 29.04           C  
ATOM    663  C   VAL A  96     -15.743 111.024  30.248  1.00 28.48           C  
ATOM    664  O   VAL A  96     -15.845 109.994  29.582  1.00 28.43           O  
ATOM    665  CB  VAL A  96     -15.194 113.145  29.073  1.00 29.04           C  
ATOM    666  CG1 VAL A  96     -14.822 112.529  27.739  1.00 29.22           C  
ATOM    667  CG2 VAL A  96     -15.603 114.611  28.904  1.00 29.37           C  
ATOM    668  N   LEU A  97     -15.154 111.075  31.439  1.00 27.87           N  
ATOM    669  CA  LEU A  97     -14.500 109.929  32.042  1.00 27.57           C  
ATOM    670  C   LEU A  97     -15.482 108.902  32.591  1.00 27.57           C  
ATOM    671  O   LEU A  97     -15.168 107.708  32.636  1.00 27.71           O  
ATOM    672  CB  LEU A  97     -13.523 110.391  33.122  1.00 27.47           C  
ATOM    673  CG  LEU A  97     -12.052 110.637  32.740  1.00 27.56           C  
ATOM    674  CD1 LEU A  97     -11.825 111.050  31.280  1.00 27.16           C  
ATOM    675  CD2 LEU A  97     -11.443 111.662  33.678  1.00 28.26           C  
ATOM    676  N   ASP A  98     -16.665 109.358  33.000  1.00 27.41           N  
ATOM    677  CA  ASP A  98     -17.716 108.443  33.451  1.00 27.59           C  
ATOM    678  C   ASP A  98     -18.112 107.512  32.308  1.00 27.76           C  
ATOM    679  O   ASP A  98     -18.239 106.299  32.500  1.00 27.92           O  
ATOM    680  CB  ASP A  98     -18.947 109.204  33.962  1.00 27.65           C  
ATOM    681  CG  ASP A  98     -18.642 110.108  35.153  1.00 27.80           C  
ATOM    682  OD1 ASP A  98     -19.532 110.903  35.525  1.00 28.06           O  
ATOM    683  OD2 ASP A  98     -17.529 110.036  35.718  1.00 27.55           O  
ATOM    684  N   LEU A  99     -18.286 108.094  31.123  1.00 27.80           N  
ATOM    685  CA  LEU A  99     -18.623 107.356  29.909  1.00 27.79           C  
ATOM    686  C   LEU A  99     -17.550 106.329  29.559  1.00 28.22           C  
ATOM    687  O   LEU A  99     -17.863 105.177  29.242  1.00 28.13           O  
ATOM    688  CB  LEU A  99     -18.834 108.328  28.739  1.00 27.64           C  
ATOM    689  CG  LEU A  99     -19.275 107.785  27.377  1.00 26.66           C  
ATOM    690  CD1 LEU A  99     -20.677 107.207  27.444  1.00 26.76           C  
ATOM    691  CD2 LEU A  99     -19.209 108.883  26.339  1.00 27.29           C  
ATOM    692  N   GLN A 100     -16.290 106.753  29.624  1.00 28.78           N  
ATOM    693  CA  GLN A 100     -15.155 105.874  29.351  1.00 29.56           C  
ATOM    694  C   GLN A 100     -15.269 104.568  30.128  1.00 29.97           C  
ATOM    695  O   GLN A 100     -15.140 103.485  29.554  1.00 30.11           O  
ATOM    696  CB  GLN A 100     -13.833 106.572  29.683  1.00 29.42           C  
ATOM    697  CG  GLN A 100     -13.496 107.735  28.767  1.00 29.93           C  
ATOM    698  CD  GLN A 100     -12.073 108.236  28.938  1.00 30.07           C  
ATOM    699  OE1 GLN A 100     -11.295 107.696  29.728  1.00 31.32           O  
ATOM    700  NE2 GLN A 100     -11.726 109.279  28.191  1.00 30.76           N  
ATOM    701  N   ARG A 101     -15.532 104.683  31.430  1.00 30.38           N  
ATOM    702  CA  ARG A 101     -15.690 103.521  32.302  1.00 30.89           C  
ATOM    703  C   ARG A 101     -16.943 102.719  31.960  1.00 31.09           C  
ATOM    704  O   ARG A 101     -16.935 101.488  32.021  1.00 31.20           O  
ATOM    705  CB  ARG A 101     -15.742 103.951  33.768  1.00 30.77           C  
ATOM    706  CG  ARG A 101     -14.514 104.702  34.248  1.00 31.16           C  
ATOM    707  CD  ARG A 101     -14.566 104.966  35.746  1.00 31.25           C  
ATOM    708  NE  ARG A 101     -15.694 105.816  36.127  1.00 31.73           N  
ATOM    709  CZ  ARG A 101     -15.641 107.141  36.232  1.00 32.01           C  
ATOM    710  NH1 ARG A 101     -14.511 107.794  35.985  1.00 32.20           N  
ATOM    711  NH2 ARG A 101     -16.726 107.816  36.587  1.00 31.68           N  
ATOM    712  N   LEU A 102     -18.011 103.420  31.591  1.00 31.24           N  
ATOM    713  CA  LEU A 102     -19.302 102.781  31.361  1.00 31.51           C  
ATOM    714  C   LEU A 102     -19.273 101.754  30.233  1.00 31.80           C  
ATOM    715  O   LEU A 102     -19.680 100.609  30.432  1.00 32.10           O  
ATOM    716  CB  LEU A 102     -20.399 103.827  31.124  1.00 31.43           C  
ATOM    717  CG  LEU A 102     -21.826 103.356  30.814  1.00 30.97           C  
ATOM    718  CD1 LEU A 102     -22.343 102.355  31.833  1.00 30.75           C  
ATOM    719  CD2 LEU A 102     -22.751 104.554  30.741  1.00 31.57           C  
ATOM    720  N   ILE A 103     -18.779 102.151  29.062  1.00 31.82           N  
ATOM    721  CA  ILE A 103     -18.849 101.280  27.888  1.00 32.02           C  
ATOM    722  C   ILE A 103     -18.056  99.979  28.059  1.00 32.19           C  
ATOM    723  O   ILE A 103     -18.338  98.985  27.389  1.00 32.35           O  
ATOM    724  CB  ILE A 103     -18.428 101.997  26.579  1.00 31.98           C  
ATOM    725  CG1 ILE A 103     -16.909 102.045  26.443  1.00 32.40           C  
ATOM    726  CG2 ILE A 103     -19.027 103.398  26.497  1.00 32.71           C  
ATOM    727  CD1 ILE A 103     -16.452 101.944  25.023  1.00 33.47           C  
ATOM    728  N   ARG A 104     -17.073  99.985  28.956  1.00 32.25           N  
ATOM    729  CA  ARG A 104     -16.251  98.797  29.166  1.00 32.19           C  
ATOM    730  C   ARG A 104     -16.651  97.969  30.394  1.00 32.04           C  
ATOM    731  O   ARG A 104     -16.085  96.897  30.630  1.00 32.03           O  
ATOM    732  CB  ARG A 104     -14.752  99.133  29.132  1.00 32.17           C  
ATOM    733  CG  ARG A 104     -14.207  99.913  30.319  1.00 32.34           C  
ATOM    734  CD  ARG A 104     -12.784 100.405  30.045  1.00 32.27           C  
ATOM    735  NE  ARG A 104     -11.945  99.381  29.417  1.00 32.44           N  
ATOM    736  CZ  ARG A 104     -10.950  98.736  30.019  1.00 32.22           C  
ATOM    737  NH1 ARG A 104     -10.638  99.006  31.277  1.00 31.80           N  
ATOM    738  NH2 ARG A 104     -10.256  97.819  29.357  1.00 32.32           N  
ATOM    739  N   ILE A 105     -17.632  98.455  31.155  1.00 31.75           N  
ATOM    740  CA  ILE A 105     -18.292  97.610  32.164  1.00 31.58           C  
ATOM    741  C   ILE A 105     -19.598  97.016  31.629  1.00 31.32           C  
ATOM    742  O   ILE A 105     -20.081  96.010  32.153  1.00 31.63           O  
ATOM    743  CB  ILE A 105     -18.509  98.306  33.557  1.00 31.49           C  
ATOM    744  CG1 ILE A 105     -19.553  99.426  33.492  1.00 31.62           C  
ATOM    745  CG2 ILE A 105     -17.190  98.802  34.144  1.00 31.64           C  
ATOM    746  CD1 ILE A 105     -20.951  98.985  33.850  1.00 30.67           C  
ATOM    747  N   ILE A 106     -20.162  97.638  30.592  1.00 30.84           N  
ATOM    748  CA  ILE A 106     -21.357  97.112  29.930  1.00 30.67           C  
ATOM    749  C   ILE A 106     -21.072  95.725  29.344  1.00 30.62           C  
ATOM    750  O   ILE A 106     -20.182  95.578  28.500  1.00 30.72           O  
ATOM    751  CB  ILE A 106     -21.888  98.059  28.820  1.00 30.74           C  
ATOM    752  CG1 ILE A 106     -22.500  99.320  29.435  1.00 30.94           C  
ATOM    753  CG2 ILE A 106     -22.933  97.352  27.956  1.00 30.30           C  
ATOM    754  CD1 ILE A 106     -22.747 100.439  28.441  1.00 30.54           C  
ATOM    755  N   PRO A 107     -21.837  94.704  29.783  1.00 30.34           N  
ATOM    756  CA  PRO A 107     -21.652  93.317  29.347  1.00 29.93           C  
ATOM    757  C   PRO A 107     -22.083  93.094  27.892  1.00 29.52           C  
ATOM    758  O   PRO A 107     -22.571  92.015  27.542  1.00 29.76           O  
ATOM    759  CB  PRO A 107     -22.556  92.521  30.301  1.00 29.83           C  
ATOM    760  CG  PRO A 107     -22.987  93.486  31.363  1.00 30.28           C  
ATOM    761  CD  PRO A 107     -22.957  94.827  30.731  1.00 30.24           C  
ATOM    762  N   LYS A 108     -21.896  94.117  27.061  1.00 28.70           N  
ATOM    763  CA  LYS A 108     -22.191  94.053  25.635  1.00 27.83           C  
ATOM    764  C   LYS A 108     -21.060  94.726  24.864  1.00 27.29           C  
ATOM    765  O   LYS A 108     -20.617  95.812  25.244  1.00 27.43           O  
ATOM    766  CB  LYS A 108     -23.528  94.743  25.325  1.00 27.83           C  
ATOM    767  CG  LYS A 108     -24.759  93.954  25.751  1.00 26.91           C  
ATOM    768  CD  LYS A 108     -25.979  94.842  25.924  1.00 24.99           C  
ATOM    769  CE  LYS A 108     -27.083  94.086  26.647  1.00 24.32           C  
ATOM    770  NZ  LYS A 108     -28.174  94.970  27.122  1.00 22.92           N  
ATOM    771  N   PRO A 109     -20.577  94.080  23.788  1.00 26.68           N  
ATOM    772  CA  PRO A 109     -19.532  94.657  22.945  1.00 26.34           C  
ATOM    773  C   PRO A 109     -19.905  96.042  22.421  1.00 26.12           C  
ATOM    774  O   PRO A 109     -21.036  96.255  21.981  1.00 26.24           O  
ATOM    775  CB  PRO A 109     -19.436  93.667  21.785  1.00 26.12           C  
ATOM    776  CG  PRO A 109     -19.876  92.380  22.368  1.00 26.34           C  
ATOM    777  CD  PRO A 109     -20.977  92.743  23.314  1.00 26.73           C  
ATOM    778  N   VAL A 110     -18.956  96.972  22.497  1.00 25.84           N  
ATOM    779  CA  VAL A 110     -19.139  98.326  21.980  1.00 25.42           C  
ATOM    780  C   VAL A 110     -18.200  98.539  20.796  1.00 25.50           C  
ATOM    781  O   VAL A 110     -16.973  98.499  20.944  1.00 25.73           O  
ATOM    782  CB  VAL A 110     -18.914  99.408  23.069  1.00 25.25           C  
ATOM    783  CG1 VAL A 110     -19.184 100.799  22.511  1.00 24.80           C  
ATOM    784  CG2 VAL A 110     -19.803  99.146  24.275  1.00 24.65           C  
ATOM    785  N   ILE A 111     -18.793  98.755  19.624  1.00 25.35           N  
ATOM    786  CA  ILE A 111     -18.052  98.867  18.370  1.00 25.07           C  
ATOM    787  C   ILE A 111     -18.031 100.311  17.870  1.00 25.21           C  
ATOM    788  O   ILE A 111     -19.081 100.945  17.742  1.00 25.18           O  
ATOM    789  CB  ILE A 111     -18.642  97.924  17.288  1.00 24.86           C  
ATOM    790  CG1 ILE A 111     -18.395  96.462  17.660  1.00 24.43           C  
ATOM    791  CG2 ILE A 111     -18.058  98.232  15.911  1.00 25.16           C  
ATOM    792  CD1 ILE A 111     -19.047  95.464  16.720  1.00 24.95           C  
ATOM    793  N   ALA A 112     -16.831 100.818  17.593  1.00 25.29           N  
ATOM    794  CA  ALA A 112     -16.659 102.173  17.070  1.00 25.46           C  
ATOM    795  C   ALA A 112     -16.680 102.194  15.542  1.00 25.60           C  
ATOM    796  O   ALA A 112     -15.759 101.695  14.893  1.00 26.04           O  
ATOM    797  CB  ALA A 112     -15.368 102.786  17.595  1.00 25.34           C  
ATOM    798  N   MET A 113     -17.736 102.769  14.976  1.00 25.41           N  
ATOM    799  CA  MET A 113     -17.863 102.889  13.527  1.00 25.41           C  
ATOM    800  C   MET A 113     -17.383 104.267  13.082  1.00 25.19           C  
ATOM    801  O   MET A 113     -18.183 105.178  12.859  1.00 25.25           O  
ATOM    802  CB  MET A 113     -19.314 102.642  13.094  1.00 25.52           C  
ATOM    803  CG  MET A 113     -19.525 102.523  11.588  1.00 25.34           C  
ATOM    804  SD  MET A 113     -21.267 102.430  11.119  1.00 25.95           S  
ATOM    805  CE  MET A 113     -21.791 104.133  11.287  1.00 25.25           C  
ATOM    806  N   VAL A 114     -16.069 104.414  12.958  1.00 25.01           N  
ATOM    807  CA  VAL A 114     -15.463 105.690  12.582  1.00 24.95           C  
ATOM    808  C   VAL A 114     -15.637 105.948  11.091  1.00 24.86           C  
ATOM    809  O   VAL A 114     -15.228 105.130  10.265  1.00 24.98           O  
ATOM    810  CB  VAL A 114     -13.953 105.729  12.938  1.00 25.13           C  
ATOM    811  CG1 VAL A 114     -13.376 107.117  12.694  1.00 24.60           C  
ATOM    812  CG2 VAL A 114     -13.723 105.291  14.390  1.00 25.35           C  
ATOM    813  N   LYS A 115     -16.245 107.084  10.753  1.00 24.90           N  
ATOM    814  CA  LYS A 115     -16.439 107.473   9.353  1.00 25.04           C  
ATOM    815  C   LYS A 115     -15.859 108.861   9.041  1.00 25.19           C  
ATOM    816  O   LYS A 115     -16.487 109.669   8.350  1.00 25.43           O  
ATOM    817  CB  LYS A 115     -17.922 107.392   8.968  1.00 24.82           C  
ATOM    818  N   GLY A 116     -14.655 109.121   9.546  1.00 25.21           N  
ATOM    819  CA  GLY A 116     -13.975 110.397   9.326  1.00 25.35           C  
ATOM    820  C   GLY A 116     -12.963 110.722  10.408  1.00 25.52           C  
ATOM    821  O   GLY A 116     -12.170 109.867  10.798  1.00 25.44           O  
ATOM    822  N   TYR A 117     -12.992 111.959  10.897  1.00 25.79           N  
ATOM    823  CA  TYR A 117     -12.064 112.401  11.940  1.00 26.05           C  
ATOM    824  C   TYR A 117     -12.421 111.822  13.305  1.00 26.46           C  
ATOM    825  O   TYR A 117     -13.532 112.012  13.804  1.00 26.61           O  
ATOM    826  CB  TYR A 117     -12.007 113.934  12.029  1.00 26.01           C  
ATOM    827  CG  TYR A 117     -11.273 114.617  10.891  1.00 25.82           C  
ATOM    828  CD1 TYR A 117     -11.976 115.225   9.857  1.00 25.46           C  
ATOM    829  CD2 TYR A 117      -9.880 114.664  10.857  1.00 25.60           C  
ATOM    830  CE1 TYR A 117     -11.316 115.850   8.812  1.00 25.88           C  
ATOM    831  CE2 TYR A 117      -9.207 115.292   9.813  1.00 25.42           C  
ATOM    832  CZ  TYR A 117      -9.934 115.884   8.795  1.00 26.12           C  
ATOM    833  OH  TYR A 117      -9.290 116.512   7.751  1.00 26.82           O  
ATOM    834  N   ALA A 118     -11.474 111.097  13.891  1.00 26.87           N  
ATOM    835  CA  ALA A 118     -11.565 110.686  15.285  1.00 27.26           C  
ATOM    836  C   ALA A 118     -10.313 111.197  15.982  1.00 27.80           C  
ATOM    837  O   ALA A 118      -9.313 110.483  16.097  1.00 27.91           O  
ATOM    838  CB  ALA A 118     -11.682 109.183  15.399  1.00 27.12           C  
ATOM    839  N   VAL A 119     -10.367 112.453  16.418  1.00 28.33           N  
ATOM    840  CA  VAL A 119      -9.202 113.114  17.007  1.00 28.87           C  
ATOM    841  C   VAL A 119      -9.450 113.609  18.428  1.00 29.12           C  
ATOM    842  O   VAL A 119     -10.592 113.838  18.825  1.00 29.30           O  
ATOM    843  CB  VAL A 119      -8.685 114.288  16.129  1.00 28.93           C  
ATOM    844  CG1 VAL A 119      -8.039 113.761  14.846  1.00 28.81           C  
ATOM    845  CG2 VAL A 119      -9.805 115.284  15.824  1.00 28.99           C  
ATOM    846  N   GLY A 120      -8.366 113.766  19.183  1.00 29.37           N  
ATOM    847  CA  GLY A 120      -8.433 114.277  20.546  1.00 29.80           C  
ATOM    848  C   GLY A 120      -9.181 113.341  21.471  1.00 30.17           C  
ATOM    849  O   GLY A 120      -8.872 112.147  21.547  1.00 30.18           O  
ATOM    850  N   GLY A 121     -10.172 113.892  22.170  1.00 30.41           N  
ATOM    851  CA  GLY A 121     -11.039 113.111  23.047  1.00 30.55           C  
ATOM    852  C   GLY A 121     -11.794 112.067  22.255  1.00 30.72           C  
ATOM    853  O   GLY A 121     -12.050 110.967  22.747  1.00 30.72           O  
ATOM    854  N   GLY A 122     -12.131 112.422  21.015  1.00 31.02           N  
ATOM    855  CA  GLY A 122     -12.837 111.541  20.087  1.00 31.25           C  
ATOM    856  C   GLY A 122     -12.135 110.227  19.818  1.00 31.54           C  
ATOM    857  O   GLY A 122     -12.789 109.195  19.666  1.00 31.73           O  
ATOM    858  N   ASN A 123     -10.804 110.263  19.763  1.00 31.73           N  
ATOM    859  CA  ASN A 123     -10.009 109.051  19.569  1.00 31.85           C  
ATOM    860  C   ASN A 123      -9.961 108.158  20.807  1.00 32.11           C  
ATOM    861  O   ASN A 123      -9.896 106.934  20.687  1.00 32.21           O  
ATOM    862  CB  ASN A 123      -8.584 109.387  19.125  1.00 31.68           C  
ATOM    863  CG  ASN A 123      -7.853 108.182  18.558  1.00 31.15           C  
ATOM    864  OD1 ASN A 123      -8.432 107.374  17.834  1.00 30.87           O  
ATOM    865  ND2 ASN A 123      -6.577 108.057  18.883  1.00 31.00           N  
ATOM    866  N   VAL A 124      -9.982 108.774  21.989  1.00 32.27           N  
ATOM    867  CA  VAL A 124      -9.951 108.024  23.247  1.00 32.31           C  
ATOM    868  C   VAL A 124     -11.227 107.189  23.390  1.00 32.62           C  
ATOM    869  O   VAL A 124     -11.175 106.028  23.808  1.00 32.61           O  
ATOM    870  CB  VAL A 124      -9.756 108.943  24.476  1.00 32.12           C  
ATOM    871  CG1 VAL A 124      -9.572 108.114  25.736  1.00 32.15           C  
ATOM    872  CG2 VAL A 124      -8.558 109.856  24.278  1.00 31.84           C  
ATOM    873  N   LEU A 125     -12.361 107.783  23.017  1.00 32.91           N  
ATOM    874  CA  LEU A 125     -13.638 107.071  22.963  1.00 33.24           C  
ATOM    875  C   LEU A 125     -13.551 105.918  21.968  1.00 33.52           C  
ATOM    876  O   LEU A 125     -14.149 104.859  22.172  1.00 33.57           O  
ATOM    877  CB  LEU A 125     -14.772 108.018  22.559  1.00 33.19           C  
ATOM    878  CG  LEU A 125     -15.057 109.245  23.430  1.00 33.84           C  
ATOM    879  CD1 LEU A 125     -15.928 110.234  22.674  1.00 33.57           C  
ATOM    880  CD2 LEU A 125     -15.698 108.858  24.764  1.00 34.71           C  
ATOM    881  N   ASN A 126     -12.798 106.136  20.894  1.00 33.62           N  
ATOM    882  CA  ASN A 126     -12.586 105.119  19.882  1.00 33.77           C  
ATOM    883  C   ASN A 126     -11.789 103.935  20.422  1.00 33.74           C  
ATOM    884  O   ASN A 126     -12.172 102.785  20.208  1.00 33.86           O  
ATOM    885  CB  ASN A 126     -11.916 105.735  18.648  1.00 34.05           C  
ATOM    886  CG  ASN A 126     -11.147 104.719  17.820  1.00 34.83           C  
ATOM    887  OD1 ASN A 126     -11.662 103.654  17.471  1.00 35.85           O  
ATOM    888  ND2 ASN A 126      -9.907 105.052  17.496  1.00 35.23           N  
ATOM    889  N   VAL A 127     -10.696 104.214  21.132  1.00 33.70           N  
ATOM    890  CA  VAL A 127      -9.811 103.144  21.606  1.00 33.50           C  
ATOM    891  C   VAL A 127     -10.438 102.314  22.722  1.00 33.40           C  
ATOM    892  O   VAL A 127     -10.180 101.115  22.824  1.00 33.38           O  
ATOM    893  CB  VAL A 127      -8.383 103.643  22.009  1.00 33.28           C  
ATOM    894  CG1 VAL A 127      -7.731 104.389  20.861  1.00 33.01           C  
ATOM    895  CG2 VAL A 127      -8.416 104.510  23.252  1.00 33.68           C  
ATOM    896  N   VAL A 128     -11.278 102.951  23.536  1.00 33.38           N  
ATOM    897  CA  VAL A 128     -11.930 102.265  24.657  1.00 33.44           C  
ATOM    898  C   VAL A 128     -13.062 101.334  24.182  1.00 33.44           C  
ATOM    899  O   VAL A 128     -13.433 100.392  24.887  1.00 33.59           O  
ATOM    900  CB  VAL A 128     -12.377 103.261  25.780  1.00 33.24           C  
ATOM    901  CG1 VAL A 128     -13.530 104.136  25.334  1.00 33.54           C  
ATOM    902  CG2 VAL A 128     -12.739 102.523  27.050  1.00 33.56           C  
ATOM    903  N   CYS A 129     -13.588 101.591  22.985  1.00 33.29           N  
ATOM    904  CA  CYS A 129     -14.537 100.681  22.347  1.00 33.34           C  
ATOM    905  C   CYS A 129     -13.845  99.370  22.002  1.00 33.17           C  
ATOM    906  O   CYS A 129     -12.739  99.380  21.465  1.00 33.37           O  
ATOM    907  CB  CYS A 129     -15.125 101.310  21.087  1.00 33.47           C  
ATOM    908  SG  CYS A 129     -16.295 102.648  21.399  1.00 34.54           S  
ATOM    909  N   ASP A 130     -14.499  98.252  22.322  1.00 32.85           N  
ATOM    910  CA  ASP A 130     -13.919  96.914  22.137  1.00 32.44           C  
ATOM    911  C   ASP A 130     -13.321  96.730  20.745  1.00 32.00           C  
ATOM    912  O   ASP A 130     -12.159  96.351  20.600  1.00 31.64           O  
ATOM    913  CB  ASP A 130     -14.969  95.824  22.381  1.00 32.60           C  
ATOM    914  CG  ASP A 130     -15.654  95.955  23.724  1.00 32.76           C  
ATOM    915  OD1 ASP A 130     -15.339  95.153  24.627  1.00 33.35           O  
ATOM    916  OD2 ASP A 130     -16.509  96.853  23.872  1.00 32.71           O  
ATOM    917  N   LEU A 131     -14.132  97.009  19.730  1.00 31.75           N  
ATOM    918  CA  LEU A 131     -13.732  96.853  18.338  1.00 31.46           C  
ATOM    919  C   LEU A 131     -13.922  98.162  17.592  1.00 31.29           C  
ATOM    920  O   LEU A 131     -14.692  99.027  18.020  1.00 31.48           O  
ATOM    921  CB  LEU A 131     -14.562  95.759  17.669  1.00 31.38           C  
ATOM    922  CG  LEU A 131     -14.684  94.436  18.421  1.00 31.47           C  
ATOM    923  CD1 LEU A 131     -15.877  93.641  17.927  1.00 32.54           C  
ATOM    924  CD2 LEU A 131     -13.412  93.640  18.290  1.00 31.45           C  
ATOM    925  N   THR A 132     -13.218  98.298  16.474  1.00 30.93           N  
ATOM    926  CA  THR A 132     -13.317  99.489  15.648  1.00 30.63           C  
ATOM    927  C   THR A 132     -13.472  99.130  14.173  1.00 30.56           C  
ATOM    928  O   THR A 132     -12.628  98.434  13.596  1.00 30.72           O  
ATOM    929  CB  THR A 132     -12.103 100.421  15.857  1.00 30.52           C  
ATOM    930  OG1 THR A 132     -12.031 100.807  17.234  1.00 29.67           O  
ATOM    931  CG2 THR A 132     -12.230 101.670  14.998  1.00 30.99           C  
ATOM    932  N   ILE A 133     -14.569  99.592  13.579  1.00 30.28           N  
ATOM    933  CA  ILE A 133     -14.756  99.499  12.136  1.00 30.27           C  
ATOM    934  C   ILE A 133     -14.417 100.857  11.539  1.00 30.03           C  
ATOM    935  O   ILE A 133     -15.030 101.874  11.884  1.00 29.96           O  
ATOM    936  CB  ILE A 133     -16.202  99.067  11.741  1.00 30.35           C  
ATOM    937  CG1 ILE A 133     -16.602  97.754  12.434  1.00 30.95           C  
ATOM    938  CG2 ILE A 133     -16.344  98.951  10.216  1.00 30.20           C  
ATOM    939  CD1 ILE A 133     -15.715  96.545  12.109  1.00 31.58           C  
ATOM    940  N   ALA A 134     -13.428 100.865  10.652  1.00 29.73           N  
ATOM    941  CA  ALA A 134     -12.930 102.104  10.075  1.00 29.62           C  
ATOM    942  C   ALA A 134     -13.308 102.243   8.609  1.00 29.49           C  
ATOM    943  O   ALA A 134     -13.097 101.327   7.811  1.00 29.42           O  
ATOM    944  CB  ALA A 134     -11.420 102.202  10.249  1.00 29.70           C  
ATOM    945  N   ALA A 135     -13.884 103.391   8.270  1.00 29.32           N  
ATOM    946  CA  ALA A 135     -14.080 103.772   6.881  1.00 29.28           C  
ATOM    947  C   ALA A 135     -12.756 104.300   6.344  1.00 29.30           C  
ATOM    948  O   ALA A 135     -11.974 104.891   7.090  1.00 29.21           O  
ATOM    949  CB  ALA A 135     -15.162 104.830   6.767  1.00 29.36           C  
ATOM    950  N   ASP A 136     -12.503 104.083   5.056  1.00 29.35           N  
ATOM    951  CA  ASP A 136     -11.279 104.568   4.408  1.00 29.34           C  
ATOM    952  C   ASP A 136     -11.052 106.062   4.647  1.00 29.05           C  
ATOM    953  O   ASP A 136      -9.914 106.530   4.668  1.00 28.92           O  
ATOM    954  CB  ASP A 136     -11.316 104.269   2.906  1.00 29.54           C  
ATOM    955  CG  ASP A 136     -12.542 104.854   2.215  1.00 30.53           C  
ATOM    956  OD1 ASP A 136     -13.513 105.235   2.908  1.00 31.30           O  
ATOM    957  OD2 ASP A 136     -12.535 104.926   0.968  1.00 31.62           O  
ATOM    958  N   ASN A 137     -12.153 106.786   4.840  1.00 29.00           N  
ATOM    959  CA  ASN A 137     -12.161 108.224   5.108  1.00 28.93           C  
ATOM    960  C   ASN A 137     -11.488 108.633   6.425  1.00 28.77           C  
ATOM    961  O   ASN A 137     -11.063 109.780   6.573  1.00 28.57           O  
ATOM    962  CB  ASN A 137     -13.611 108.728   5.104  1.00 28.89           C  
ATOM    963  CG  ASN A 137     -13.722 110.242   4.958  1.00 29.79           C  
ATOM    964  OD1 ASN A 137     -14.824 110.789   4.949  1.00 30.53           O  
ATOM    965  ND2 ASN A 137     -12.584 110.922   4.834  1.00 30.40           N  
ATOM    966  N   ALA A 138     -11.388 107.688   7.361  1.00 28.72           N  
ATOM    967  CA  ALA A 138     -11.024 107.977   8.753  1.00 28.44           C  
ATOM    968  C   ALA A 138      -9.621 108.520   8.973  1.00 28.30           C  
ATOM    969  O   ALA A 138      -8.664 108.079   8.335  1.00 28.57           O  
ATOM    970  CB  ALA A 138     -11.243 106.749   9.620  1.00 28.47           C  
ATOM    971  N   ILE A 139      -9.520 109.490   9.880  1.00 28.06           N  
ATOM    972  CA  ILE A 139      -8.239 110.021  10.347  1.00 27.84           C  
ATOM    973  C   ILE A 139      -8.203 110.020  11.877  1.00 27.78           C  
ATOM    974  O   ILE A 139      -9.118 110.527  12.533  1.00 27.85           O  
ATOM    975  CB  ILE A 139      -7.940 111.430   9.764  1.00 27.75           C  
ATOM    976  CG1 ILE A 139      -7.263 111.310   8.396  1.00 28.03           C  
ATOM    977  CG2 ILE A 139      -7.033 112.234  10.681  1.00 27.42           C  
ATOM    978  CD1 ILE A 139      -8.210 111.376   7.217  1.00 28.89           C  
ATOM    979  N   PHE A 140      -7.146 109.434  12.433  1.00 27.65           N  
ATOM    980  CA  PHE A 140      -7.015 109.264  13.876  1.00 27.58           C  
ATOM    981  C   PHE A 140      -5.859 110.083  14.426  1.00 27.59           C  
ATOM    982  O   PHE A 140      -4.845 110.266  13.749  1.00 27.54           O  
ATOM    983  CB  PHE A 140      -6.807 107.787  14.222  1.00 27.73           C  
ATOM    984  CG  PHE A 140      -7.914 106.891  13.757  1.00 27.24           C  
ATOM    985  CD1 PHE A 140      -7.835 106.249  12.526  1.00 27.53           C  
ATOM    986  CD2 PHE A 140      -9.036 106.686  14.549  1.00 26.89           C  
ATOM    987  CE1 PHE A 140      -8.862 105.419  12.088  1.00 27.86           C  
ATOM    988  CE2 PHE A 140     -10.065 105.860  14.124  1.00 27.61           C  
ATOM    989  CZ  PHE A 140      -9.981 105.225  12.887  1.00 27.95           C  
ATOM    990  N   GLY A 141      -6.014 110.562  15.659  1.00 27.61           N  
ATOM    991  CA  GLY A 141      -4.959 111.322  16.325  1.00 27.43           C  
ATOM    992  C   GLY A 141      -5.325 111.897  17.679  1.00 27.22           C  
ATOM    993  O   GLY A 141      -6.499 111.965  18.047  1.00 27.04           O  
ATOM    994  N   GLN A 142      -4.300 112.300  18.423  1.00 27.21           N  
ATOM    995  CA  GLN A 142      -4.469 113.027  19.674  1.00 27.20           C  
ATOM    996  C   GLN A 142      -3.987 114.461  19.482  1.00 27.21           C  
ATOM    997  O   GLN A 142      -2.978 114.700  18.823  1.00 27.26           O  
ATOM    998  CB  GLN A 142      -3.685 112.352  20.797  1.00 27.22           C  
ATOM    999  CG  GLN A 142      -3.956 110.858  20.951  1.00 27.58           C  
ATOM   1000  CD  GLN A 142      -5.314 110.546  21.559  1.00 28.18           C  
ATOM   1001  OE1 GLN A 142      -5.972 111.417  22.138  1.00 28.93           O  
ATOM   1002  NE2 GLN A 142      -5.734 109.291  21.440  1.00 27.82           N  
ATOM   1003  N   THR A 143      -4.716 115.413  20.054  1.00 27.32           N  
ATOM   1004  CA  THR A 143      -4.419 116.834  19.865  1.00 27.38           C  
ATOM   1005  C   THR A 143      -4.143 117.553  21.188  1.00 27.24           C  
ATOM   1006  O   THR A 143      -3.798 118.736  21.201  1.00 27.03           O  
ATOM   1007  CB  THR A 143      -5.564 117.553  19.112  1.00 27.40           C  
ATOM   1008  OG1 THR A 143      -6.822 117.202  19.701  1.00 27.26           O  
ATOM   1009  CG2 THR A 143      -5.572 117.163  17.640  1.00 27.65           C  
ATOM   1010  N   GLY A 144      -4.293 116.820  22.288  1.00 27.24           N  
ATOM   1011  CA  GLY A 144      -4.132 117.345  23.643  1.00 27.41           C  
ATOM   1012  C   GLY A 144      -3.071 118.413  23.862  1.00 27.48           C  
ATOM   1013  O   GLY A 144      -3.409 119.568  24.134  1.00 27.57           O  
ATOM   1014  N   PRO A 145      -1.778 118.035  23.769  1.00 27.44           N  
ATOM   1015  CA  PRO A 145      -0.678 118.984  23.980  1.00 27.35           C  
ATOM   1016  C   PRO A 145      -0.579 120.129  22.960  1.00 27.29           C  
ATOM   1017  O   PRO A 145       0.270 121.004  23.117  1.00 27.57           O  
ATOM   1018  CB  PRO A 145       0.569 118.095  23.912  1.00 27.42           C  
ATOM   1019  CG  PRO A 145       0.157 116.918  23.137  1.00 27.08           C  
ATOM   1020  CD  PRO A 145      -1.273 116.679  23.490  1.00 27.45           C  
ATOM   1021  N   LYS A 146      -1.426 120.121  21.932  1.00 27.08           N  
ATOM   1022  CA  LYS A 146      -1.535 121.259  21.018  1.00 26.94           C  
ATOM   1023  C   LYS A 146      -2.686 122.170  21.440  1.00 27.03           C  
ATOM   1024  O   LYS A 146      -2.711 123.353  21.096  1.00 27.04           O  
ATOM   1025  CB  LYS A 146      -1.725 120.785  19.582  1.00 26.76           C  
ATOM   1026  N   VAL A 147      -3.631 121.606  22.193  1.00 27.15           N  
ATOM   1027  CA  VAL A 147      -4.834 122.321  22.625  1.00 27.13           C  
ATOM   1028  C   VAL A 147      -4.909 122.454  24.162  1.00 27.18           C  
ATOM   1029  O   VAL A 147      -5.978 122.698  24.731  1.00 27.06           O  
ATOM   1030  CB  VAL A 147      -6.117 121.668  22.017  1.00 27.03           C  
ATOM   1031  CG1 VAL A 147      -6.522 120.399  22.772  1.00 27.10           C  
ATOM   1032  CG2 VAL A 147      -7.266 122.665  21.960  1.00 27.65           C  
ATOM   1033  N   GLY A 148      -3.761 122.302  24.822  1.00 27.31           N  
ATOM   1034  CA  GLY A 148      -3.662 122.460  26.275  1.00 27.60           C  
ATOM   1035  C   GLY A 148      -4.479 121.445  27.054  1.00 27.87           C  
ATOM   1036  O   GLY A 148      -5.210 121.798  27.984  1.00 27.66           O  
ATOM   1037  N   SER A 149      -4.344 120.179  26.673  1.00 28.23           N  
ATOM   1038  CA  SER A 149      -5.085 119.093  27.299  1.00 28.51           C  
ATOM   1039  C   SER A 149      -4.293 117.789  27.216  1.00 28.68           C  
ATOM   1040  O   SER A 149      -3.186 117.767  26.670  1.00 28.72           O  
ATOM   1041  CB  SER A 149      -6.453 118.938  26.628  1.00 28.51           C  
ATOM   1042  OG  SER A 149      -7.298 118.086  27.379  1.00 29.01           O  
ATOM   1043  N   PHE A 150      -4.850 116.721  27.794  1.00 28.86           N  
ATOM   1044  CA  PHE A 150      -4.320 115.354  27.675  1.00 28.81           C  
ATOM   1045  C   PHE A 150      -5.212 114.339  28.378  1.00 29.16           C  
ATOM   1046  O   PHE A 150      -5.810 114.641  29.414  1.00 28.96           O  
ATOM   1047  CB  PHE A 150      -2.879 115.237  28.203  1.00 28.56           C  
ATOM   1048  CG  PHE A 150      -2.692 115.715  29.622  1.00 27.73           C  
ATOM   1049  CD1 PHE A 150      -2.286 117.019  29.881  1.00 27.27           C  
ATOM   1050  CD2 PHE A 150      -2.891 114.854  30.694  1.00 27.22           C  
ATOM   1051  CE1 PHE A 150      -2.101 117.464  31.184  1.00 26.93           C  
ATOM   1052  CE2 PHE A 150      -2.710 115.290  31.999  1.00 27.02           C  
ATOM   1053  CZ  PHE A 150      -2.311 116.599  32.244  1.00 27.30           C  
ATOM   1054  N   ASP A 151      -5.305 113.143  27.798  1.00 29.77           N  
ATOM   1055  CA  ASP A 151      -5.915 112.001  28.473  1.00 30.59           C  
ATOM   1056  C   ASP A 151      -4.802 111.057  28.888  1.00 30.91           C  
ATOM   1057  O   ASP A 151      -4.295 110.278  28.078  1.00 30.99           O  
ATOM   1058  CB  ASP A 151      -6.928 111.283  27.577  1.00 30.84           C  
ATOM   1059  CG  ASP A 151      -7.897 110.402  28.367  1.00 32.01           C  
ATOM   1060  OD1 ASP A 151      -9.118 110.484  28.093  1.00 32.51           O  
ATOM   1061  OD2 ASP A 151      -7.451 109.638  29.257  1.00 32.14           O  
ATOM   1062  N   ALA A 152      -4.422 111.145  30.157  1.00 31.41           N  
ATOM   1063  CA  ALA A 152      -3.315 110.372  30.698  1.00 31.66           C  
ATOM   1064  C   ALA A 152      -3.767 109.036  31.295  1.00 31.79           C  
ATOM   1065  O   ALA A 152      -2.940 108.225  31.711  1.00 31.82           O  
ATOM   1066  CB  ALA A 152      -2.547 111.206  31.720  1.00 31.60           C  
ATOM   1067  N   GLY A 153      -5.079 108.811  31.322  1.00 32.13           N  
ATOM   1068  CA  GLY A 153      -5.646 107.556  31.817  1.00 32.68           C  
ATOM   1069  C   GLY A 153      -5.722 106.488  30.739  1.00 33.10           C  
ATOM   1070  O   GLY A 153      -4.701 105.925  30.338  1.00 33.02           O  
ATOM   1071  N   TYR A 154      -6.937 106.214  30.268  1.00 33.59           N  
ATOM   1072  CA  TYR A 154      -7.169 105.221  29.217  1.00 33.85           C  
ATOM   1073  C   TYR A 154      -6.609 105.649  27.863  1.00 33.73           C  
ATOM   1074  O   TYR A 154      -6.348 104.807  27.000  1.00 33.78           O  
ATOM   1075  CB  TYR A 154      -8.662 104.909  29.084  1.00 34.28           C  
ATOM   1076  CG  TYR A 154      -9.228 104.091  30.224  1.00 35.05           C  
ATOM   1077  CD1 TYR A 154     -10.223 104.609  31.050  1.00 35.49           C  
ATOM   1078  CD2 TYR A 154      -8.764 102.799  30.477  1.00 35.66           C  
ATOM   1079  CE1 TYR A 154     -10.748 103.861  32.097  1.00 35.73           C  
ATOM   1080  CE2 TYR A 154      -9.279 102.043  31.524  1.00 35.75           C  
ATOM   1081  CZ  TYR A 154     -10.270 102.579  32.328  1.00 35.94           C  
ATOM   1082  OH  TYR A 154     -10.782 101.834  33.365  1.00 35.84           O  
ATOM   1083  N   GLY A 155      -6.429 106.957  27.684  1.00 33.58           N  
ATOM   1084  CA  GLY A 155      -5.868 107.514  26.447  1.00 33.25           C  
ATOM   1085  C   GLY A 155      -4.382 107.248  26.258  1.00 32.76           C  
ATOM   1086  O   GLY A 155      -3.870 107.317  25.141  1.00 32.40           O  
ATOM   1087  N   SER A 156      -3.694 106.944  27.357  1.00 32.52           N  
ATOM   1088  CA  SER A 156      -2.260 106.699  27.332  1.00 32.21           C  
ATOM   1089  C   SER A 156      -1.959 105.227  27.576  1.00 32.02           C  
ATOM   1090  O   SER A 156      -1.537 104.514  26.667  1.00 32.20           O  
ATOM   1091  CB  SER A 156      -1.559 107.567  28.377  1.00 32.15           C  
ATOM   1092  OG  SER A 156      -1.833 108.936  28.157  1.00 32.15           O  
ATOM   1093  N   GLY A 157      -2.190 104.782  28.809  1.00 31.81           N  
ATOM   1094  CA  GLY A 157      -1.906 103.410  29.219  1.00 31.28           C  
ATOM   1095  C   GLY A 157      -2.551 102.364  28.335  1.00 30.86           C  
ATOM   1096  O   GLY A 157      -1.864 101.485  27.823  1.00 31.04           O  
ATOM   1097  N   TYR A 158      -3.868 102.474  28.147  1.00 30.38           N  
ATOM   1098  CA  TYR A 158      -4.648 101.493  27.386  1.00 29.89           C  
ATOM   1099  C   TYR A 158      -4.301 101.512  25.898  1.00 29.43           C  
ATOM   1100  O   TYR A 158      -4.415 100.496  25.208  1.00 29.07           O  
ATOM   1101  CB  TYR A 158      -6.153 101.711  27.604  1.00 30.15           C  
ATOM   1102  CG  TYR A 158      -7.041 100.640  26.999  1.00 30.53           C  
ATOM   1103  CD1 TYR A 158      -7.662 100.837  25.763  1.00 30.99           C  
ATOM   1104  CD2 TYR A 158      -7.259  99.430  27.658  1.00 30.99           C  
ATOM   1105  CE1 TYR A 158      -8.476  99.858  25.198  1.00 31.03           C  
ATOM   1106  CE2 TYR A 158      -8.072  98.440  27.099  1.00 31.76           C  
ATOM   1107  CZ  TYR A 158      -8.679  98.662  25.870  1.00 31.42           C  
ATOM   1108  OH  TYR A 158      -9.486  97.690  25.314  1.00 30.94           O  
ATOM   1109  N   LEU A 159      -3.871 102.673  25.416  1.00 29.17           N  
ATOM   1110  CA  LEU A 159      -3.450 102.823  24.031  1.00 28.96           C  
ATOM   1111  C   LEU A 159      -2.200 101.996  23.760  1.00 29.05           C  
ATOM   1112  O   LEU A 159      -2.107 101.310  22.741  1.00 29.43           O  
ATOM   1113  CB  LEU A 159      -3.199 104.294  23.711  1.00 28.67           C  
ATOM   1114  CG  LEU A 159      -2.785 104.647  22.285  1.00 28.29           C  
ATOM   1115  CD1 LEU A 159      -3.960 104.545  21.328  1.00 28.57           C  
ATOM   1116  CD2 LEU A 159      -2.225 106.041  22.285  1.00 28.37           C  
ATOM   1117  N   ALA A 160      -1.250 102.057  24.685  1.00 29.01           N  
ATOM   1118  CA  ALA A 160      -0.039 101.253  24.609  1.00 29.14           C  
ATOM   1119  C   ALA A 160      -0.374  99.763  24.575  1.00 29.29           C  
ATOM   1120  O   ALA A 160       0.338  98.975  23.950  1.00 29.34           O  
ATOM   1121  CB  ALA A 160       0.873 101.569  25.782  1.00 28.98           C  
ATOM   1122  N   ARG A 161      -1.475  99.395  25.231  1.00 29.43           N  
ATOM   1123  CA  ARG A 161      -1.917  98.002  25.317  1.00 29.66           C  
ATOM   1124  C   ARG A 161      -2.580  97.515  24.025  1.00 29.74           C  
ATOM   1125  O   ARG A 161      -3.095  96.394  23.967  1.00 29.90           O  
ATOM   1126  CB  ARG A 161      -2.868  97.812  26.501  1.00 29.71           C  
ATOM   1127  CG  ARG A 161      -2.526  98.643  27.726  1.00 30.09           C  
ATOM   1128  CD  ARG A 161      -1.411  98.050  28.566  1.00 31.09           C  
ATOM   1129  NE  ARG A 161      -1.945  97.206  29.632  1.00 31.71           N  
ATOM   1130  CZ  ARG A 161      -1.409  97.095  30.843  1.00 32.53           C  
ATOM   1131  NH1 ARG A 161      -0.316  97.777  31.165  1.00 32.40           N  
ATOM   1132  NH2 ARG A 161      -1.973  96.305  31.745  1.00 34.18           N  
ATOM   1133  N   ILE A 162      -2.566  98.365  22.998  1.00 29.60           N  
ATOM   1134  CA  ILE A 162      -3.040  98.000  21.667  1.00 29.40           C  
ATOM   1135  C   ILE A 162      -1.877  98.064  20.685  1.00 29.55           C  
ATOM   1136  O   ILE A 162      -1.512  97.060  20.065  1.00 29.75           O  
ATOM   1137  CB  ILE A 162      -4.161  98.949  21.167  1.00 29.37           C  
ATOM   1138  CG1 ILE A 162      -5.396  98.861  22.070  1.00 29.10           C  
ATOM   1139  CG2 ILE A 162      -4.520  98.642  19.705  1.00 29.39           C  
ATOM   1140  CD1 ILE A 162      -6.454  99.905  21.777  1.00 29.03           C  
ATOM   1141  N   VAL A 163      -1.291  99.255  20.574  1.00 29.38           N  
ATOM   1142  CA  VAL A 163      -0.338  99.575  19.511  1.00 29.02           C  
ATOM   1143  C   VAL A 163       1.129  99.311  19.872  1.00 28.99           C  
ATOM   1144  O   VAL A 163       1.981  99.211  18.989  1.00 29.10           O  
ATOM   1145  CB  VAL A 163      -0.518 101.042  19.033  1.00 28.96           C  
ATOM   1146  CG1 VAL A 163      -1.919 101.243  18.474  1.00 28.80           C  
ATOM   1147  CG2 VAL A 163      -0.246 102.034  20.163  1.00 28.06           C  
ATOM   1148  N   GLY A 164       1.412  99.184  21.164  1.00 28.95           N  
ATOM   1149  CA  GLY A 164       2.785  99.106  21.650  1.00 28.84           C  
ATOM   1150  C   GLY A 164       3.210 100.473  22.149  1.00 28.88           C  
ATOM   1151  O   GLY A 164       2.764 101.497  21.623  1.00 28.94           O  
ATOM   1152  N   HIS A 165       4.074 100.492  23.161  1.00 28.62           N  
ATOM   1153  CA  HIS A 165       4.470 101.744  23.804  1.00 28.27           C  
ATOM   1154  C   HIS A 165       5.032 102.800  22.858  1.00 28.06           C  
ATOM   1155  O   HIS A 165       4.608 103.951  22.918  1.00 28.22           O  
ATOM   1156  CB  HIS A 165       5.406 101.493  24.987  1.00 28.28           C  
ATOM   1157  CG  HIS A 165       4.689 101.384  26.295  1.00 28.44           C  
ATOM   1158  ND1 HIS A 165       3.912 100.296  26.629  1.00 28.48           N  
ATOM   1159  CD2 HIS A 165       4.606 102.240  27.340  1.00 28.61           C  
ATOM   1160  CE1 HIS A 165       3.391 100.481  27.828  1.00 29.02           C  
ATOM   1161  NE2 HIS A 165       3.795 101.655  28.281  1.00 28.81           N  
ATOM   1162  N   LYS A 166       5.952 102.400  21.980  1.00 27.56           N  
ATOM   1163  CA  LYS A 166       6.571 103.318  21.013  1.00 27.12           C  
ATOM   1164  C   LYS A 166       5.547 104.117  20.198  1.00 27.09           C  
ATOM   1165  O   LYS A 166       5.674 105.337  20.059  1.00 26.76           O  
ATOM   1166  CB  LYS A 166       7.512 102.563  20.065  1.00 26.98           C  
ATOM   1167  CG  LYS A 166       8.699 101.896  20.737  1.00 26.04           C  
ATOM   1168  CD  LYS A 166       9.875 102.844  20.928  1.00 24.92           C  
ATOM   1169  CE  LYS A 166      11.000 102.136  21.667  1.00 24.86           C  
ATOM   1170  NZ  LYS A 166      12.245 102.939  21.759  1.00 24.36           N  
ATOM   1171  N   LYS A 167       4.537 103.424  19.671  1.00 27.11           N  
ATOM   1172  CA  LYS A 167       3.485 104.062  18.870  1.00 27.12           C  
ATOM   1173  C   LYS A 167       2.578 104.974  19.695  1.00 27.07           C  
ATOM   1174  O   LYS A 167       2.159 106.031  19.224  1.00 27.13           O  
ATOM   1175  CB  LYS A 167       2.658 103.019  18.107  1.00 27.05           C  
ATOM   1176  CG  LYS A 167       3.232 102.640  16.748  1.00 27.06           C  
ATOM   1177  CD  LYS A 167       3.085 103.790  15.754  1.00 28.30           C  
ATOM   1178  CE  LYS A 167       3.923 103.569  14.504  1.00 28.94           C  
ATOM   1179  NZ  LYS A 167       3.920 104.785  13.643  1.00 29.08           N  
ATOM   1180  N   ALA A 168       2.281 104.558  20.922  1.00 27.04           N  
ATOM   1181  CA  ALA A 168       1.491 105.373  21.838  1.00 27.17           C  
ATOM   1182  C   ALA A 168       2.258 106.635  22.216  1.00 27.22           C  
ATOM   1183  O   ALA A 168       1.698 107.733  22.225  1.00 27.09           O  
ATOM   1184  CB  ALA A 168       1.122 104.575  23.077  1.00 27.30           C  
ATOM   1185  N   ARG A 169       3.544 106.459  22.514  1.00 27.48           N  
ATOM   1186  CA  ARG A 169       4.456 107.569  22.771  1.00 27.71           C  
ATOM   1187  C   ARG A 169       4.501 108.497  21.561  1.00 27.59           C  
ATOM   1188  O   ARG A 169       4.542 109.712  21.713  1.00 27.56           O  
ATOM   1189  CB  ARG A 169       5.864 107.054  23.098  1.00 28.01           C  
ATOM   1190  CG  ARG A 169       5.965 106.145  24.335  1.00 29.32           C  
ATOM   1191  CD  ARG A 169       6.235 106.919  25.622  1.00 31.62           C  
ATOM   1192  NE  ARG A 169       6.085 106.082  26.815  1.00 32.38           N  
ATOM   1193  CZ  ARG A 169       7.085 105.479  27.453  1.00 33.01           C  
ATOM   1194  NH1 ARG A 169       8.332 105.606  27.022  1.00 34.57           N  
ATOM   1195  NH2 ARG A 169       6.839 104.744  28.528  1.00 33.33           N  
ATOM   1196  N   GLU A 170       4.469 107.915  20.363  1.00 27.64           N  
ATOM   1197  CA  GLU A 170       4.505 108.682  19.114  1.00 27.65           C  
ATOM   1198  C   GLU A 170       3.293 109.595  18.924  1.00 27.69           C  
ATOM   1199  O   GLU A 170       3.448 110.792  18.669  1.00 27.64           O  
ATOM   1200  CB  GLU A 170       4.651 107.744  17.909  1.00 27.75           C  
ATOM   1201  CG  GLU A 170       4.835 108.454  16.567  1.00 27.49           C  
ATOM   1202  CD  GLU A 170       4.755 107.511  15.382  1.00 27.44           C  
ATOM   1203  OE1 GLU A 170       5.304 106.393  15.462  1.00 26.77           O  
ATOM   1204  OE2 GLU A 170       4.145 107.892  14.361  1.00 27.05           O  
ATOM   1205  N   ILE A 171       2.095 109.031  19.056  1.00 27.68           N  
ATOM   1206  CA  ILE A 171       0.876 109.756  18.694  1.00 27.71           C  
ATOM   1207  C   ILE A 171       0.536 110.888  19.668  1.00 27.56           C  
ATOM   1208  O   ILE A 171      -0.175 111.829  19.311  1.00 27.61           O  
ATOM   1209  CB  ILE A 171      -0.339 108.813  18.408  1.00 27.77           C  
ATOM   1210  CG1 ILE A 171      -1.010 108.335  19.689  1.00 27.89           C  
ATOM   1211  CG2 ILE A 171       0.082 107.613  17.559  1.00 27.65           C  
ATOM   1212  CD1 ILE A 171      -2.399 107.789  19.444  1.00 28.49           C  
ATOM   1213  N   TRP A 172       1.056 110.791  20.890  1.00 27.51           N  
ATOM   1214  CA  TRP A 172       0.844 111.816  21.915  1.00 27.61           C  
ATOM   1215  C   TRP A 172       1.862 112.959  21.852  1.00 27.42           C  
ATOM   1216  O   TRP A 172       1.515 114.115  22.079  1.00 27.21           O  
ATOM   1217  CB  TRP A 172       0.857 111.192  23.316  1.00 27.65           C  
ATOM   1218  CG  TRP A 172      -0.436 110.561  23.708  1.00 27.53           C  
ATOM   1219  CD1 TRP A 172      -0.695 109.228  23.815  1.00 27.82           C  
ATOM   1220  CD2 TRP A 172      -1.653 111.236  24.046  1.00 27.58           C  
ATOM   1221  NE1 TRP A 172      -1.999 109.027  24.201  1.00 27.79           N  
ATOM   1222  CE2 TRP A 172      -2.611 110.243  24.348  1.00 27.90           C  
ATOM   1223  CE3 TRP A 172      -2.030 112.584  24.117  1.00 27.36           C  
ATOM   1224  CZ2 TRP A 172      -3.923 110.555  24.722  1.00 27.85           C  
ATOM   1225  CZ3 TRP A 172      -3.334 112.894  24.491  1.00 27.52           C  
ATOM   1226  CH2 TRP A 172      -4.264 111.882  24.787  1.00 27.65           C  
ATOM   1227  N   TYR A 173       3.111 112.621  21.549  1.00 27.49           N  
ATOM   1228  CA  TYR A 173       4.206 113.587  21.543  1.00 27.73           C  
ATOM   1229  C   TYR A 173       4.203 114.452  20.280  1.00 27.96           C  
ATOM   1230  O   TYR A 173       4.264 115.679  20.360  1.00 27.78           O  
ATOM   1231  CB  TYR A 173       5.551 112.863  21.675  1.00 27.81           C  
ATOM   1232  CG  TYR A 173       5.829 112.189  23.008  1.00 27.61           C  
ATOM   1233  CD1 TYR A 173       4.805 111.909  23.918  1.00 27.63           C  
ATOM   1234  CD2 TYR A 173       7.123 111.788  23.337  1.00 27.49           C  
ATOM   1235  CE1 TYR A 173       5.072 111.274  25.129  1.00 28.15           C  
ATOM   1236  CE2 TYR A 173       7.400 111.154  24.542  1.00 27.65           C  
ATOM   1237  CZ  TYR A 173       6.372 110.901  25.431  1.00 27.79           C  
ATOM   1238  OH  TYR A 173       6.645 110.274  26.620  1.00 27.92           O  
ATOM   1239  N   LEU A 174       4.140 113.804  19.120  1.00 28.38           N  
ATOM   1240  CA  LEU A 174       4.141 114.508  17.837  1.00 28.82           C  
ATOM   1241  C   LEU A 174       2.753 114.978  17.410  1.00 29.15           C  
ATOM   1242  O   LEU A 174       2.634 115.902  16.601  1.00 29.40           O  
ATOM   1243  CB  LEU A 174       4.750 113.637  16.738  1.00 28.77           C  
ATOM   1244  CG  LEU A 174       6.264 113.447  16.757  1.00 28.93           C  
ATOM   1245  CD1 LEU A 174       6.632 112.210  17.552  1.00 30.12           C  
ATOM   1246  CD2 LEU A 174       6.777 113.333  15.340  1.00 29.30           C  
ATOM   1247  N   CYS A 175       1.717 114.329  17.943  1.00 29.45           N  
ATOM   1248  CA  CYS A 175       0.316 114.668  17.667  1.00 29.82           C  
ATOM   1249  C   CYS A 175      -0.073 114.636  16.187  1.00 29.92           C  
ATOM   1250  O   CYS A 175      -0.905 115.428  15.738  1.00 30.15           O  
ATOM   1251  CB  CYS A 175      -0.043 116.022  18.283  1.00 29.75           C  
ATOM   1252  SG  CYS A 175      -0.210 115.977  20.063  1.00 31.28           S  
ATOM   1253  N   ARG A 176       0.526 113.719  15.434  1.00 29.95           N  
ATOM   1254  CA  ARG A 176       0.264 113.632  14.004  1.00 30.39           C  
ATOM   1255  C   ARG A 176      -1.099 113.012  13.721  1.00 30.54           C  
ATOM   1256  O   ARG A 176      -1.717 112.413  14.605  1.00 30.78           O  
ATOM   1257  CB  ARG A 176       1.369 112.848  13.290  1.00 30.57           C  
ATOM   1258  CG  ARG A 176       2.715 113.554  13.267  1.00 31.88           C  
ATOM   1259  CD  ARG A 176       3.507 113.234  12.010  1.00 34.64           C  
ATOM   1260  NE  ARG A 176       4.039 111.872  12.005  1.00 37.06           N  
ATOM   1261  CZ  ARG A 176       4.941 111.418  11.138  1.00 38.21           C  
ATOM   1262  NH1 ARG A 176       5.433 112.212  10.191  1.00 38.57           N  
ATOM   1263  NH2 ARG A 176       5.357 110.163  11.217  1.00 38.65           N  
ATOM   1264  N   GLN A 177      -1.568 113.184  12.487  1.00 30.62           N  
ATOM   1265  CA  GLN A 177      -2.776 112.520  12.012  1.00 30.60           C  
ATOM   1266  C   GLN A 177      -2.419 111.153  11.427  1.00 30.56           C  
ATOM   1267  O   GLN A 177      -1.305 110.951  10.940  1.00 30.56           O  
ATOM   1268  CB  GLN A 177      -3.487 113.380  10.965  1.00 30.48           C  
ATOM   1269  CG  GLN A 177      -4.141 114.642  11.523  1.00 30.48           C  
ATOM   1270  CD  GLN A 177      -5.091 115.317  10.537  1.00 30.89           C  
ATOM   1271  OE1 GLN A 177      -6.080 115.929  10.939  1.00 31.40           O  
ATOM   1272  NE2 GLN A 177      -4.796 115.206   9.245  1.00 31.41           N  
ATOM   1273  N   TYR A 178      -3.362 110.215  11.489  1.00 30.58           N  
ATOM   1274  CA  TYR A 178      -3.143 108.865  10.971  1.00 30.64           C  
ATOM   1275  C   TYR A 178      -4.323 108.392  10.127  1.00 30.66           C  
ATOM   1276  O   TYR A 178      -5.455 108.324  10.611  1.00 30.54           O  
ATOM   1277  CB  TYR A 178      -2.856 107.879  12.114  1.00 30.65           C  
ATOM   1278  CG  TYR A 178      -1.595 108.203  12.886  1.00 31.10           C  
ATOM   1279  CD1 TYR A 178      -1.628 109.079  13.972  1.00 31.49           C  
ATOM   1280  CD2 TYR A 178      -0.367 107.648  12.525  1.00 30.65           C  
ATOM   1281  CE1 TYR A 178      -0.475 109.394  14.677  1.00 31.01           C  
ATOM   1282  CE2 TYR A 178       0.795 107.952  13.228  1.00 30.19           C  
ATOM   1283  CZ  TYR A 178       0.730 108.827  14.304  1.00 30.92           C  
ATOM   1284  OH  TYR A 178       1.868 109.141  15.015  1.00 31.38           O  
ATOM   1285  N   ASN A 179      -4.048 108.080   8.860  1.00 30.68           N  
ATOM   1286  CA  ASN A 179      -5.074 107.570   7.955  1.00 30.65           C  
ATOM   1287  C   ASN A 179      -5.458 106.135   8.294  1.00 30.64           C  
ATOM   1288  O   ASN A 179      -4.725 105.441   9.002  1.00 30.53           O  
ATOM   1289  CB  ASN A 179      -4.646 107.701   6.484  1.00 30.71           C  
ATOM   1290  CG  ASN A 179      -3.367 106.944   6.166  1.00 30.94           C  
ATOM   1291  OD1 ASN A 179      -3.338 105.713   6.159  1.00 31.83           O  
ATOM   1292  ND2 ASN A 179      -2.307 107.682   5.875  1.00 31.60           N  
ATOM   1293  N   ALA A 180      -6.608 105.706   7.781  1.00 30.72           N  
ATOM   1294  CA  ALA A 180      -7.156 104.380   8.054  1.00 30.91           C  
ATOM   1295  C   ALA A 180      -6.138 103.238   7.911  1.00 31.19           C  
ATOM   1296  O   ALA A 180      -6.128 102.312   8.728  1.00 31.38           O  
ATOM   1297  CB  ALA A 180      -8.371 104.129   7.180  1.00 30.84           C  
ATOM   1298  N   GLN A 181      -5.281 103.312   6.893  1.00 31.23           N  
ATOM   1299  CA  GLN A 181      -4.275 102.273   6.666  1.00 31.41           C  
ATOM   1300  C   GLN A 181      -3.132 102.318   7.680  1.00 31.63           C  
ATOM   1301  O   GLN A 181      -2.681 101.269   8.143  1.00 31.94           O  
ATOM   1302  CB  GLN A 181      -3.731 102.321   5.237  1.00 31.36           C  
ATOM   1303  CG  GLN A 181      -3.064 101.017   4.784  1.00 31.57           C  
ATOM   1304  CD  GLN A 181      -4.037  99.841   4.656  1.00 31.75           C  
ATOM   1305  OE1 GLN A 181      -5.253 100.023   4.535  1.00 31.45           O  
ATOM   1306  NE2 GLN A 181      -3.495  98.627   4.675  1.00 31.36           N  
ATOM   1307  N   GLU A 182      -2.670 103.524   8.015  1.00 31.63           N  
ATOM   1308  CA  GLU A 182      -1.683 103.717   9.083  1.00 31.72           C  
ATOM   1309  C   GLU A 182      -2.220 103.191  10.413  1.00 31.54           C  
ATOM   1310  O   GLU A 182      -1.472 102.656  11.231  1.00 31.63           O  
ATOM   1311  CB  GLU A 182      -1.326 105.197   9.236  1.00 31.74           C  
ATOM   1312  CG  GLU A 182      -0.454 105.766   8.130  1.00 32.18           C  
ATOM   1313  CD  GLU A 182      -0.132 107.236   8.342  1.00 32.16           C  
ATOM   1314  OE1 GLU A 182      -1.069 108.066   8.353  1.00 32.87           O  
ATOM   1315  OE2 GLU A 182       1.062 107.564   8.492  1.00 33.30           O  
ATOM   1316  N   ALA A 183      -3.523 103.364  10.618  1.00 31.35           N  
ATOM   1317  CA  ALA A 183      -4.197 102.873  11.807  1.00 31.29           C  
ATOM   1318  C   ALA A 183      -4.275 101.350  11.794  1.00 31.30           C  
ATOM   1319  O   ALA A 183      -4.027 100.700  12.814  1.00 31.73           O  
ATOM   1320  CB  ALA A 183      -5.582 103.479  11.910  1.00 31.29           C  
ATOM   1321  N   LEU A 184      -4.609 100.786  10.635  1.00 30.95           N  
ATOM   1322  CA  LEU A 184      -4.697  99.336  10.481  1.00 30.58           C  
ATOM   1323  C   LEU A 184      -3.339  98.672  10.669  1.00 30.52           C  
ATOM   1324  O   LEU A 184      -3.237  97.628  11.313  1.00 30.07           O  
ATOM   1325  CB  LEU A 184      -5.292  98.969   9.115  1.00 30.40           C  
ATOM   1326  CG  LEU A 184      -5.699  97.508   8.880  1.00 30.18           C  
ATOM   1327  CD1 LEU A 184      -6.781  97.057   9.857  1.00 29.32           C  
ATOM   1328  CD2 LEU A 184      -6.162  97.300   7.444  1.00 30.47           C  
ATOM   1329  N   ASP A 185      -2.301  99.303  10.121  1.00 30.92           N  
ATOM   1330  CA  ASP A 185      -0.950  98.745  10.122  1.00 31.43           C  
ATOM   1331  C   ASP A 185      -0.332  98.687  11.519  1.00 31.43           C  
ATOM   1332  O   ASP A 185       0.510  97.831  11.788  1.00 31.47           O  
ATOM   1333  CB  ASP A 185      -0.046  99.521   9.155  1.00 31.68           C  
ATOM   1334  CG  ASP A 185       1.237  98.772   8.819  1.00 33.23           C  
ATOM   1335  OD1 ASP A 185       2.179  98.793   9.643  1.00 34.73           O  
ATOM   1336  OD2 ASP A 185       1.311  98.173   7.725  1.00 34.38           O  
ATOM   1337  N   MET A 186      -0.756  99.586  12.405  1.00 31.51           N  
ATOM   1338  CA  MET A 186      -0.276  99.576  13.789  1.00 31.67           C  
ATOM   1339  C   MET A 186      -1.153  98.724  14.714  1.00 31.57           C  
ATOM   1340  O   MET A 186      -0.777  98.447  15.855  1.00 31.58           O  
ATOM   1341  CB  MET A 186      -0.116 101.002  14.331  1.00 31.52           C  
ATOM   1342  CG  MET A 186      -1.415 101.736  14.625  1.00 32.10           C  
ATOM   1343  SD  MET A 186      -1.155 103.313  15.467  1.00 32.11           S  
ATOM   1344  CE  MET A 186      -0.664 104.357  14.095  1.00 32.34           C  
ATOM   1345  N   GLY A 187      -2.316  98.312  14.215  1.00 31.51           N  
ATOM   1346  CA  GLY A 187      -3.228  97.450  14.967  1.00 31.31           C  
ATOM   1347  C   GLY A 187      -4.301  98.203  15.731  1.00 31.19           C  
ATOM   1348  O   GLY A 187      -5.092  97.598  16.461  1.00 30.97           O  
ATOM   1349  N   LEU A 188      -4.329  99.525  15.558  1.00 31.02           N  
ATOM   1350  CA  LEU A 188      -5.280 100.387  16.257  1.00 31.08           C  
ATOM   1351  C   LEU A 188      -6.737 100.079  15.880  1.00 31.19           C  
ATOM   1352  O   LEU A 188      -7.619 100.068  16.744  1.00 31.31           O  
ATOM   1353  CB  LEU A 188      -4.961 101.862  15.982  1.00 30.92           C  
ATOM   1354  CG  LEU A 188      -5.207 102.903  17.085  1.00 31.19           C  
ATOM   1355  CD1 LEU A 188      -4.844 104.298  16.586  1.00 30.66           C  
ATOM   1356  CD2 LEU A 188      -6.637 102.889  17.623  1.00 30.91           C  
ATOM   1357  N   VAL A 189      -6.982  99.836  14.592  1.00 30.93           N  
ATOM   1358  CA  VAL A 189      -8.325  99.527  14.099  1.00 30.52           C  
ATOM   1359  C   VAL A 189      -8.387  98.101  13.562  1.00 30.42           C  
ATOM   1360  O   VAL A 189      -7.358  97.524  13.200  1.00 30.42           O  
ATOM   1361  CB  VAL A 189      -8.802 100.534  13.018  1.00 30.51           C  
ATOM   1362  CG1 VAL A 189      -8.878 101.939  13.591  1.00 30.56           C  
ATOM   1363  CG2 VAL A 189      -7.893 100.505  11.801  1.00 30.53           C  
ATOM   1364  N   ASN A 190      -9.595  97.544  13.503  1.00 30.24           N  
ATOM   1365  CA  ASN A 190      -9.786  96.141  13.135  1.00 30.09           C  
ATOM   1366  C   ASN A 190      -9.848  95.869  11.628  1.00 30.12           C  
ATOM   1367  O   ASN A 190      -9.138  94.995  11.129  1.00 30.01           O  
ATOM   1368  CB  ASN A 190     -11.006  95.561  13.853  1.00 29.98           C  
ATOM   1369  CG  ASN A 190     -10.792  95.437  15.345  1.00 29.71           C  
ATOM   1370  OD1 ASN A 190     -10.644  94.339  15.869  1.00 30.09           O  
ATOM   1371  ND2 ASN A 190     -10.762  96.566  16.035  1.00 30.54           N  
ATOM   1372  N   THR A 191     -10.705  96.602  10.920  1.00 30.21           N  
ATOM   1373  CA  THR A 191     -10.771  96.533   9.458  1.00 30.53           C  
ATOM   1374  C   THR A 191     -10.952  97.915   8.859  1.00 30.60           C  
ATOM   1375  O   THR A 191     -11.412  98.844   9.529  1.00 30.81           O  
ATOM   1376  CB  THR A 191     -11.931  95.643   8.940  1.00 30.60           C  
ATOM   1377  OG1 THR A 191     -13.124  95.916   9.686  1.00 31.20           O  
ATOM   1378  CG2 THR A 191     -11.582  94.159   9.038  1.00 31.44           C  
ATOM   1379  N   VAL A 192     -10.582  98.041   7.590  1.00 30.67           N  
ATOM   1380  CA  VAL A 192     -10.831  99.255   6.829  1.00 30.57           C  
ATOM   1381  C   VAL A 192     -11.664  98.916   5.593  1.00 30.57           C  
ATOM   1382  O   VAL A 192     -11.266  98.085   4.772  1.00 30.43           O  
ATOM   1383  CB  VAL A 192      -9.515  99.965   6.438  1.00 30.68           C  
ATOM   1384  CG1 VAL A 192      -9.789 101.154   5.510  1.00 30.81           C  
ATOM   1385  CG2 VAL A 192      -8.758 100.411   7.691  1.00 30.01           C  
ATOM   1386  N   VAL A 193     -12.829  99.552   5.487  1.00 30.58           N  
ATOM   1387  CA  VAL A 193     -13.725  99.370   4.342  1.00 30.68           C  
ATOM   1388  C   VAL A 193     -14.078 100.717   3.697  1.00 30.93           C  
ATOM   1389  O   VAL A 193     -14.144 101.730   4.393  1.00 31.09           O  
ATOM   1390  CB  VAL A 193     -15.019  98.592   4.724  1.00 30.61           C  
ATOM   1391  CG1 VAL A 193     -14.697  97.137   5.036  1.00 30.35           C  
ATOM   1392  CG2 VAL A 193     -15.756  99.256   5.890  1.00 30.24           C  
ATOM   1393  N   PRO A 194     -14.286 100.736   2.363  1.00 31.09           N  
ATOM   1394  CA  PRO A 194     -14.700 101.964   1.673  1.00 31.29           C  
ATOM   1395  C   PRO A 194     -15.895 102.649   2.342  1.00 31.45           C  
ATOM   1396  O   PRO A 194     -16.827 101.968   2.773  1.00 31.60           O  
ATOM   1397  CB  PRO A 194     -15.084 101.465   0.279  1.00 31.37           C  
ATOM   1398  CG  PRO A 194     -14.238 100.263   0.073  1.00 31.28           C  
ATOM   1399  CD  PRO A 194     -14.118  99.612   1.421  1.00 31.10           C  
ATOM   1400  N   LEU A 195     -15.855 103.980   2.413  1.00 31.64           N  
ATOM   1401  CA  LEU A 195     -16.866 104.804   3.107  1.00 31.85           C  
ATOM   1402  C   LEU A 195     -18.325 104.402   2.845  1.00 31.95           C  
ATOM   1403  O   LEU A 195     -19.169 104.475   3.742  1.00 31.82           O  
ATOM   1404  CB  LEU A 195     -16.660 106.287   2.765  1.00 31.76           C  
ATOM   1405  CG  LEU A 195     -17.522 107.365   3.436  1.00 31.64           C  
ATOM   1406  CD1 LEU A 195     -17.233 107.482   4.926  1.00 31.91           C  
ATOM   1407  CD2 LEU A 195     -17.298 108.698   2.750  1.00 32.01           C  
ATOM   1408  N   GLU A 196     -18.603 103.984   1.614  1.00 32.17           N  
ATOM   1409  CA  GLU A 196     -19.933 103.539   1.195  1.00 32.53           C  
ATOM   1410  C   GLU A 196     -20.407 102.275   1.919  1.00 32.55           C  
ATOM   1411  O   GLU A 196     -21.609 102.074   2.111  1.00 32.50           O  
ATOM   1412  CB  GLU A 196     -19.940 103.298  -0.317  1.00 32.56           C  
ATOM   1413  CG  GLU A 196     -18.621 102.722  -0.840  1.00 33.46           C  
ATOM   1414  CD  GLU A 196     -18.740 102.074  -2.204  1.00 34.29           C  
ATOM   1415  OE1 GLU A 196     -17.806 102.245  -3.019  1.00 34.31           O  
ATOM   1416  OE2 GLU A 196     -19.755 101.388  -2.458  1.00 34.82           O  
ATOM   1417  N   LYS A 197     -19.456 101.434   2.320  1.00 32.61           N  
ATOM   1418  CA  LYS A 197     -19.753 100.112   2.876  1.00 32.78           C  
ATOM   1419  C   LYS A 197     -19.687 100.039   4.403  1.00 32.70           C  
ATOM   1420  O   LYS A 197     -19.923  98.978   4.986  1.00 32.76           O  
ATOM   1421  CB  LYS A 197     -18.809  99.065   2.267  1.00 32.67           C  
ATOM   1422  CG  LYS A 197     -19.299  98.451   0.959  1.00 32.88           C  
ATOM   1423  CD  LYS A 197     -18.166  97.832   0.130  1.00 33.15           C  
ATOM   1424  CE  LYS A 197     -17.500  96.630   0.811  1.00 34.25           C  
ATOM   1425  NZ  LYS A 197     -16.289  97.005   1.609  1.00 33.11           N  
ATOM   1426  N   VAL A 198     -19.377 101.162   5.049  1.00 32.68           N  
ATOM   1427  CA  VAL A 198     -19.137 101.168   6.494  1.00 32.76           C  
ATOM   1428  C   VAL A 198     -20.413 101.019   7.338  1.00 32.91           C  
ATOM   1429  O   VAL A 198     -20.343 100.584   8.488  1.00 32.81           O  
ATOM   1430  CB  VAL A 198     -18.277 102.394   6.933  1.00 32.67           C  
ATOM   1431  CG1 VAL A 198     -19.146 103.609   7.250  1.00 32.90           C  
ATOM   1432  CG2 VAL A 198     -17.399 102.033   8.122  1.00 32.54           C  
ATOM   1433  N   GLU A 199     -21.569 101.362   6.768  1.00 33.21           N  
ATOM   1434  CA  GLU A 199     -22.856 101.127   7.434  1.00 33.47           C  
ATOM   1435  C   GLU A 199     -23.191  99.635   7.431  1.00 33.42           C  
ATOM   1436  O   GLU A 199     -23.690  99.101   8.426  1.00 33.25           O  
ATOM   1437  CB  GLU A 199     -23.982 101.952   6.792  1.00 33.85           C  
ATOM   1438  CG  GLU A 199     -25.372 101.795   7.453  1.00 34.36           C  
ATOM   1439  CD  GLU A 199     -25.483 102.442   8.836  1.00 34.34           C  
ATOM   1440  OE1 GLU A 199     -24.513 102.391   9.621  1.00 33.76           O  
ATOM   1441  OE2 GLU A 199     -26.559 102.994   9.141  1.00 35.32           O  
ATOM   1442  N   ASP A 200     -22.915  98.973   6.306  1.00 33.46           N  
ATOM   1443  CA  ASP A 200     -22.852  97.516   6.255  1.00 33.50           C  
ATOM   1444  C   ASP A 200     -21.633  97.119   7.083  1.00 33.33           C  
ATOM   1445  O   ASP A 200     -21.176  97.910   7.911  1.00 33.54           O  
ATOM   1446  CB  ASP A 200     -22.703  97.028   4.811  1.00 33.76           C  
ATOM   1447  CG  ASP A 200     -23.765  97.597   3.882  1.00 35.03           C  
ATOM   1448  OD1 ASP A 200     -23.932  98.836   3.848  1.00 36.75           O  
ATOM   1449  OD2 ASP A 200     -24.423  96.805   3.170  1.00 35.63           O  
ATOM   1450  N   GLU A 201     -21.104  95.914   6.871  1.00 32.85           N  
ATOM   1451  CA  GLU A 201     -19.838  95.492   7.501  1.00 32.27           C  
ATOM   1452  C   GLU A 201     -19.869  95.570   9.031  1.00 31.69           C  
ATOM   1453  O   GLU A 201     -19.623  94.574   9.708  1.00 31.75           O  
ATOM   1454  CB  GLU A 201     -18.656  96.300   6.940  1.00 32.27           C  
ATOM   1455  CG  GLU A 201     -17.292  95.944   7.530  1.00 32.77           C  
ATOM   1456  CD  GLU A 201     -16.613  94.764   6.843  1.00 32.64           C  
ATOM   1457  OE1 GLU A 201     -17.242  94.093   5.996  1.00 32.76           O  
ATOM   1458  OE2 GLU A 201     -15.432  94.508   7.156  1.00 32.62           O  
ATOM   1459  N   THR A 202     -20.154  96.763   9.557  1.00 31.06           N  
ATOM   1460  CA  THR A 202     -20.378  96.986  10.985  1.00 30.32           C  
ATOM   1461  C   THR A 202     -21.574  96.167  11.456  1.00 29.86           C  
ATOM   1462  O   THR A 202     -21.542  95.581  12.536  1.00 29.67           O  
ATOM   1463  CB  THR A 202     -20.640  98.477  11.291  1.00 30.33           C  
ATOM   1464  OG1 THR A 202     -19.682  99.289  10.602  1.00 30.02           O  
ATOM   1465  CG2 THR A 202     -20.547  98.749  12.787  1.00 30.52           C  
ATOM   1466  N   VAL A 203     -22.622  96.131  10.633  1.00 29.44           N  
ATOM   1467  CA  VAL A 203     -23.790  95.299  10.904  1.00 29.18           C  
ATOM   1468  C   VAL A 203     -23.443  93.813  10.749  1.00 28.96           C  
ATOM   1469  O   VAL A 203     -23.889  92.989  11.546  1.00 28.83           O  
ATOM   1470  CB  VAL A 203     -25.032  95.714  10.046  1.00 29.20           C  
ATOM   1471  CG1 VAL A 203     -24.752  95.599   8.552  1.00 29.66           C  
ATOM   1472  CG2 VAL A 203     -26.264  94.896  10.426  1.00 29.05           C  
ATOM   1473  N   GLN A 204     -22.636  93.489   9.736  1.00 28.83           N  
ATOM   1474  CA  GLN A 204     -22.156  92.122   9.511  1.00 28.93           C  
ATOM   1475  C   GLN A 204     -21.376  91.628  10.728  1.00 28.86           C  
ATOM   1476  O   GLN A 204     -21.573  90.500  11.186  1.00 28.83           O  
ATOM   1477  CB  GLN A 204     -21.288  92.056   8.248  1.00 29.09           C  
ATOM   1478  CG  GLN A 204     -20.756  90.665   7.896  1.00 29.92           C  
ATOM   1479  CD  GLN A 204     -21.819  89.750   7.298  1.00 31.65           C  
ATOM   1480  OE1 GLN A 204     -22.508  90.114   6.342  1.00 32.12           O  
ATOM   1481  NE2 GLN A 204     -21.945  88.549   7.856  1.00 31.89           N  
ATOM   1482  N   TRP A 205     -20.495  92.491  11.236  1.00 28.73           N  
ATOM   1483  CA  TRP A 205     -19.765  92.261  12.476  1.00 28.67           C  
ATOM   1484  C   TRP A 205     -20.714  91.954  13.638  1.00 28.59           C  
ATOM   1485  O   TRP A 205     -20.568  90.934  14.308  1.00 28.43           O  
ATOM   1486  CB  TRP A 205     -18.916  93.490  12.806  1.00 29.06           C  
ATOM   1487  CG  TRP A 205     -17.429  93.316  12.642  1.00 29.63           C  
ATOM   1488  CD1 TRP A 205     -16.478  93.459  13.618  1.00 29.96           C  
ATOM   1489  CD2 TRP A 205     -16.721  92.983  11.442  1.00 29.76           C  
ATOM   1490  NE1 TRP A 205     -15.225  93.231  13.101  1.00 29.82           N  
ATOM   1491  CE2 TRP A 205     -15.344  92.939  11.767  1.00 29.98           C  
ATOM   1492  CE3 TRP A 205     -17.112  92.712  10.125  1.00 29.71           C  
ATOM   1493  CZ2 TRP A 205     -14.361  92.636  10.825  1.00 29.83           C  
ATOM   1494  CZ3 TRP A 205     -16.133  92.407   9.189  1.00 29.84           C  
ATOM   1495  CH2 TRP A 205     -14.774  92.374   9.542  1.00 30.05           C  
ATOM   1496  N   CYS A 206     -21.685  92.838  13.858  1.00 28.60           N  
ATOM   1497  CA  CYS A 206     -22.662  92.689  14.940  1.00 28.80           C  
ATOM   1498  C   CYS A 206     -23.492  91.413  14.804  1.00 28.84           C  
ATOM   1499  O   CYS A 206     -23.668  90.674  15.774  1.00 28.77           O  
ATOM   1500  CB  CYS A 206     -23.594  93.897  14.984  1.00 28.89           C  
ATOM   1501  SG  CYS A 206     -22.809  95.472  15.389  1.00 29.49           S  
ATOM   1502  N   LYS A 207     -24.000  91.175  13.594  1.00 28.96           N  
ATOM   1503  CA  LYS A 207     -24.752  89.964  13.250  1.00 28.98           C  
ATOM   1504  C   LYS A 207     -23.951  88.704  13.577  1.00 28.89           C  
ATOM   1505  O   LYS A 207     -24.519  87.659  13.910  1.00 28.90           O  
ATOM   1506  CB  LYS A 207     -25.133  90.003  11.764  1.00 28.98           C  
ATOM   1507  CG  LYS A 207     -25.643  88.703  11.168  1.00 29.46           C  
ATOM   1508  CD  LYS A 207     -25.482  88.720   9.651  1.00 30.29           C  
ATOM   1509  CE  LYS A 207     -25.582  87.326   9.052  1.00 29.95           C  
ATOM   1510  NZ  LYS A 207     -25.541  87.377   7.566  1.00 29.79           N  
ATOM   1511  N   GLU A 208     -22.629  88.824  13.493  1.00 28.82           N  
ATOM   1512  CA  GLU A 208     -21.713  87.731  13.787  1.00 28.78           C  
ATOM   1513  C   GLU A 208     -21.571  87.497  15.294  1.00 28.54           C  
ATOM   1514  O   GLU A 208     -21.320  86.368  15.724  1.00 28.44           O  
ATOM   1515  CB  GLU A 208     -20.351  88.024  13.165  1.00 28.88           C  
ATOM   1516  CG  GLU A 208     -19.725  86.861  12.427  1.00 29.13           C  
ATOM   1517  CD  GLU A 208     -18.861  87.326  11.272  1.00 29.44           C  
ATOM   1518  OE1 GLU A 208     -19.423  87.810  10.263  1.00 29.30           O  
ATOM   1519  OE2 GLU A 208     -17.622  87.209  11.371  1.00 29.41           O  
ATOM   1520  N   ILE A 209     -21.727  88.559  16.087  1.00 28.35           N  
ATOM   1521  CA  ILE A 209     -21.656  88.463  17.554  1.00 28.18           C  
ATOM   1522  C   ILE A 209     -22.916  87.801  18.118  1.00 28.12           C  
ATOM   1523  O   ILE A 209     -22.838  86.952  19.010  1.00 28.15           O  
ATOM   1524  CB  ILE A 209     -21.482  89.855  18.242  1.00 28.04           C  
ATOM   1525  CG1 ILE A 209     -20.437  90.730  17.534  1.00 28.07           C  
ATOM   1526  CG2 ILE A 209     -21.163  89.697  19.727  1.00 27.99           C  
ATOM   1527  CD1 ILE A 209     -18.994  90.357  17.791  1.00 26.70           C  
ATOM   1528  N   MET A 210     -24.068  88.192  17.580  1.00 27.98           N  
ATOM   1529  CA  MET A 210     -25.371  87.745  18.075  1.00 27.92           C  
ATOM   1530  C   MET A 210     -25.629  86.255  17.819  1.00 27.69           C  
ATOM   1531  O   MET A 210     -26.638  85.699  18.263  1.00 27.50           O  
ATOM   1532  CB  MET A 210     -26.483  88.619  17.486  1.00 27.93           C  
ATOM   1533  CG  MET A 210     -26.341  90.100  17.838  1.00 28.18           C  
ATOM   1534  SD  MET A 210     -27.687  91.156  17.265  1.00 28.41           S  
ATOM   1535  CE  MET A 210     -27.288  91.324  15.528  1.00 28.64           C  
ATOM   1536  N   LYS A 211     -24.703  85.622  17.103  1.00 27.68           N  
ATOM   1537  CA  LYS A 211     -24.702  84.176  16.900  1.00 27.51           C  
ATOM   1538  C   LYS A 211     -24.133  83.489  18.142  1.00 27.21           C  
ATOM   1539  O   LYS A 211     -24.474  82.342  18.441  1.00 27.12           O  
ATOM   1540  CB  LYS A 211     -23.875  83.825  15.651  1.00 27.56           C  
ATOM   1541  CG  LYS A 211     -23.919  82.355  15.212  1.00 28.58           C  
ATOM   1542  CD  LYS A 211     -22.752  81.531  15.785  1.00 29.86           C  
ATOM   1543  CE  LYS A 211     -21.559  81.450  14.830  1.00 29.87           C  
ATOM   1544  NZ  LYS A 211     -21.763  80.425  13.762  1.00 30.13           N  
ATOM   1545  N   HIS A 212     -23.282  84.213  18.868  1.00 26.99           N  
ATOM   1546  CA  HIS A 212     -22.564  83.666  20.017  1.00 26.73           C  
ATOM   1547  C   HIS A 212     -23.224  83.965  21.356  1.00 26.64           C  
ATOM   1548  O   HIS A 212     -24.002  84.910  21.484  1.00 26.49           O  
ATOM   1549  CB  HIS A 212     -21.123  84.170  20.030  1.00 26.63           C  
ATOM   1550  CG  HIS A 212     -20.373  83.876  18.771  1.00 26.64           C  
ATOM   1551  ND1 HIS A 212     -19.725  84.853  18.049  1.00 27.03           N  
ATOM   1552  CD2 HIS A 212     -20.182  82.719  18.097  1.00 26.73           C  
ATOM   1553  CE1 HIS A 212     -19.157  84.309  16.988  1.00 26.65           C  
ATOM   1554  NE2 HIS A 212     -19.418  83.015  16.994  1.00 26.89           N  
ATOM   1555  N   SER A 213     -22.882  83.146  22.349  1.00 26.70           N  
ATOM   1556  CA  SER A 213     -23.442  83.233  23.692  1.00 26.90           C  
ATOM   1557  C   SER A 213     -23.138  84.563  24.386  1.00 27.13           C  
ATOM   1558  O   SER A 213     -21.977  84.841  24.709  1.00 27.26           O  
ATOM   1559  CB  SER A 213     -22.924  82.074  24.545  1.00 26.74           C  
ATOM   1560  OG  SER A 213     -23.212  82.290  25.916  1.00 27.10           O  
ATOM   1561  N   PRO A 214     -24.186  85.379  24.638  1.00 27.15           N  
ATOM   1562  CA  PRO A 214     -24.038  86.684  25.295  1.00 27.23           C  
ATOM   1563  C   PRO A 214     -23.364  86.604  26.666  1.00 27.27           C  
ATOM   1564  O   PRO A 214     -22.693  87.551  27.078  1.00 27.22           O  
ATOM   1565  CB  PRO A 214     -25.485  87.174  25.442  1.00 27.03           C  
ATOM   1566  CG  PRO A 214     -26.328  85.959  25.284  1.00 27.04           C  
ATOM   1567  CD  PRO A 214     -25.595  85.097  24.318  1.00 26.96           C  
ATOM   1568  N   THR A 215     -23.538  85.479  27.354  1.00 27.57           N  
ATOM   1569  CA  THR A 215     -22.960  85.282  28.684  1.00 27.77           C  
ATOM   1570  C   THR A 215     -21.457  84.992  28.612  1.00 27.82           C  
ATOM   1571  O   THR A 215     -20.685  85.490  29.433  1.00 27.80           O  
ATOM   1572  CB  THR A 215     -23.707  84.173  29.468  1.00 27.73           C  
ATOM   1573  OG1 THR A 215     -25.100  84.499  29.543  1.00 27.48           O  
ATOM   1574  CG2 THR A 215     -23.157  84.038  30.875  1.00 27.16           C  
ATOM   1575  N   ALA A 216     -21.052  84.198  27.623  1.00 27.87           N  
ATOM   1576  CA  ALA A 216     -19.639  83.920  27.390  1.00 27.90           C  
ATOM   1577  C   ALA A 216     -18.909  85.202  27.012  1.00 28.15           C  
ATOM   1578  O   ALA A 216     -17.753  85.399  27.384  1.00 28.49           O  
ATOM   1579  CB  ALA A 216     -19.470  82.872  26.307  1.00 27.89           C  
ATOM   1580  N   LEU A 217     -19.599  86.077  26.288  1.00 28.33           N  
ATOM   1581  CA  LEU A 217     -19.030  87.347  25.841  1.00 28.35           C  
ATOM   1582  C   LEU A 217     -18.846  88.349  26.984  1.00 28.55           C  
ATOM   1583  O   LEU A 217     -17.844  89.068  27.019  1.00 28.72           O  
ATOM   1584  CB  LEU A 217     -19.883  87.954  24.724  1.00 28.11           C  
ATOM   1585  CG  LEU A 217     -20.075  87.086  23.476  1.00 27.58           C  
ATOM   1586  CD1 LEU A 217     -21.298  87.529  22.695  1.00 27.19           C  
ATOM   1587  CD2 LEU A 217     -18.835  87.087  22.597  1.00 27.13           C  
ATOM   1588  N   ARG A 218     -19.802  88.386  27.913  1.00 28.60           N  
ATOM   1589  CA  ARG A 218     -19.743  89.309  29.053  1.00 28.85           C  
ATOM   1590  C   ARG A 218     -18.603  88.960  30.020  1.00 28.86           C  
ATOM   1591  O   ARG A 218     -18.009  89.850  30.642  1.00 28.75           O  
ATOM   1592  CB  ARG A 218     -21.089  89.366  29.788  1.00 28.64           C  
ATOM   1593  CG  ARG A 218     -21.339  88.226  30.772  1.00 29.14           C  
ATOM   1594  CD  ARG A 218     -22.757  88.241  31.292  1.00 29.31           C  
ATOM   1595  NE  ARG A 218     -22.971  89.290  32.287  1.00 30.89           N  
ATOM   1596  CZ  ARG A 218     -24.089  90.008  32.384  1.00 31.54           C  
ATOM   1597  NH1 ARG A 218     -25.088  89.806  31.534  1.00 31.37           N  
ATOM   1598  NH2 ARG A 218     -24.200  90.941  33.320  1.00 31.58           N  
ATOM   1599  N   PHE A 219     -18.312  87.665  30.135  1.00 28.76           N  
ATOM   1600  CA  PHE A 219     -17.201  87.184  30.945  1.00 28.72           C  
ATOM   1601  C   PHE A 219     -15.868  87.526  30.305  1.00 28.68           C  
ATOM   1602  O   PHE A 219     -14.959  88.004  30.979  1.00 28.62           O  
ATOM   1603  CB  PHE A 219     -17.297  85.677  31.163  1.00 28.69           C  
ATOM   1604  CG  PHE A 219     -17.854  85.295  32.494  1.00 28.60           C  
ATOM   1605  CD1 PHE A 219     -17.105  85.484  33.654  1.00 28.74           C  
ATOM   1606  CD2 PHE A 219     -19.118  84.735  32.595  1.00 29.37           C  
ATOM   1607  CE1 PHE A 219     -17.614  85.129  34.896  1.00 28.90           C  
ATOM   1608  CE2 PHE A 219     -19.637  84.374  33.836  1.00 29.90           C  
ATOM   1609  CZ  PHE A 219     -18.882  84.570  34.988  1.00 29.49           C  
ATOM   1610  N   LEU A 220     -15.767  87.278  29.002  1.00 28.80           N  
ATOM   1611  CA  LEU A 220     -14.554  87.562  28.244  1.00 28.87           C  
ATOM   1612  C   LEU A 220     -14.242  89.051  28.219  1.00 29.15           C  
ATOM   1613  O   LEU A 220     -13.076  89.439  28.272  1.00 29.26           O  
ATOM   1614  CB  LEU A 220     -14.664  87.014  26.824  1.00 28.70           C  
ATOM   1615  CG  LEU A 220     -14.545  85.497  26.685  1.00 28.19           C  
ATOM   1616  CD1 LEU A 220     -15.175  85.040  25.382  1.00 28.47           C  
ATOM   1617  CD2 LEU A 220     -13.097  85.057  26.767  1.00 28.14           C  
ATOM   1618  N   LYS A 221     -15.285  89.878  28.148  1.00 29.41           N  
ATOM   1619  CA  LYS A 221     -15.114  91.329  28.218  1.00 29.72           C  
ATOM   1620  C   LYS A 221     -14.567  91.725  29.584  1.00 29.87           C  
ATOM   1621  O   LYS A 221     -13.609  92.494  29.674  1.00 29.82           O  
ATOM   1622  CB  LYS A 221     -16.428  92.065  27.928  1.00 29.71           C  
ATOM   1623  CG  LYS A 221     -16.271  93.578  27.854  1.00 29.70           C  
ATOM   1624  CD  LYS A 221     -17.405  94.246  27.105  1.00 29.54           C  
ATOM   1625  CE  LYS A 221     -17.218  95.756  27.099  1.00 29.61           C  
ATOM   1626  NZ  LYS A 221     -18.313  96.454  26.374  1.00 29.30           N  
ATOM   1627  N   ALA A 222     -15.177  91.176  30.635  1.00 30.19           N  
ATOM   1628  CA  ALA A 222     -14.759  91.415  32.016  1.00 30.19           C  
ATOM   1629  C   ALA A 222     -13.372  90.850  32.289  1.00 30.17           C  
ATOM   1630  O   ALA A 222     -12.644  91.367  33.136  1.00 30.29           O  
ATOM   1631  CB  ALA A 222     -15.770  90.819  32.984  1.00 30.36           C  
ATOM   1632  N   ALA A 223     -13.018  89.787  31.572  1.00 30.26           N  
ATOM   1633  CA  ALA A 223     -11.695  89.177  31.681  1.00 30.61           C  
ATOM   1634  C   ALA A 223     -10.624  90.066  31.056  1.00 30.97           C  
ATOM   1635  O   ALA A 223      -9.506  90.157  31.573  1.00 31.26           O  
ATOM   1636  CB  ALA A 223     -11.689  87.811  31.031  1.00 30.42           C  
ATOM   1637  N   MET A 224     -10.975  90.718  29.948  1.00 31.07           N  
ATOM   1638  CA  MET A 224     -10.065  91.625  29.258  1.00 31.13           C  
ATOM   1639  C   MET A 224      -9.854  92.909  30.054  1.00 30.94           C  
ATOM   1640  O   MET A 224      -8.784  93.506  29.990  1.00 31.34           O  
ATOM   1641  CB  MET A 224     -10.579  91.953  27.856  1.00 31.36           C  
ATOM   1642  CG  MET A 224     -10.735  90.751  26.922  1.00 32.28           C  
ATOM   1643  SD  MET A 224      -9.190  90.070  26.283  1.00 34.55           S  
ATOM   1644  CE  MET A 224      -8.619  91.436  25.280  1.00 34.92           C  
ATOM   1645  N   ASN A 225     -10.872  93.331  30.796  1.00 30.82           N  
ATOM   1646  CA  ASN A 225     -10.762  94.510  31.657  1.00 31.08           C  
ATOM   1647  C   ASN A 225      -9.920  94.230  32.903  1.00 31.40           C  
ATOM   1648  O   ASN A 225      -9.115  95.064  33.323  1.00 31.44           O  
ATOM   1649  CB  ASN A 225     -12.148  95.023  32.060  1.00 30.93           C  
ATOM   1650  CG  ASN A 225     -13.028  95.350  30.863  1.00 30.64           C  
ATOM   1651  OD1 ASN A 225     -12.572  95.917  29.871  1.00 30.64           O  
ATOM   1652  ND2 ASN A 225     -14.300  94.991  30.958  1.00 30.38           N  
ATOM   1653  N   ALA A 226     -10.109  93.044  33.479  1.00 31.67           N  
ATOM   1654  CA  ALA A 226      -9.379  92.608  34.668  1.00 31.72           C  
ATOM   1655  C   ALA A 226      -7.891  92.429  34.389  1.00 31.79           C  
ATOM   1656  O   ALA A 226      -7.076  92.404  35.314  1.00 31.92           O  
ATOM   1657  CB  ALA A 226      -9.976  91.318  35.199  1.00 31.76           C  
ATOM   1658  N   ASP A 227      -7.554  92.305  33.107  1.00 31.86           N  
ATOM   1659  CA  ASP A 227      -6.173  92.197  32.657  1.00 31.91           C  
ATOM   1660  C   ASP A 227      -5.416  93.487  32.947  1.00 31.93           C  
ATOM   1661  O   ASP A 227      -4.259  93.456  33.370  1.00 32.06           O  
ATOM   1662  CB  ASP A 227      -6.138  91.886  31.158  1.00 31.95           C  
ATOM   1663  CG  ASP A 227      -4.756  92.057  30.551  1.00 32.66           C  
ATOM   1664  OD1 ASP A 227      -4.605  92.900  29.641  1.00 32.65           O  
ATOM   1665  OD2 ASP A 227      -3.818  91.355  30.988  1.00 33.70           O  
ATOM   1666  N   THR A 228      -6.086  94.615  32.727  1.00 31.86           N  
ATOM   1667  CA  THR A 228      -5.460  95.930  32.825  1.00 31.70           C  
ATOM   1668  C   THR A 228      -5.867  96.707  34.079  1.00 31.49           C  
ATOM   1669  O   THR A 228      -5.024  97.340  34.715  1.00 31.74           O  
ATOM   1670  CB  THR A 228      -5.745  96.790  31.566  1.00 31.86           C  
ATOM   1671  OG1 THR A 228      -7.157  96.846  31.319  1.00 32.13           O  
ATOM   1672  CG2 THR A 228      -5.050  96.207  30.343  1.00 31.94           C  
ATOM   1673  N   ASP A 229      -7.149  96.641  34.438  1.00 31.14           N  
ATOM   1674  CA  ASP A 229      -7.714  97.475  35.504  1.00 30.64           C  
ATOM   1675  C   ASP A 229      -7.637  96.883  36.912  1.00 30.27           C  
ATOM   1676  O   ASP A 229      -8.483  97.180  37.758  1.00 30.17           O  
ATOM   1677  CB  ASP A 229      -9.163  97.845  35.172  1.00 30.53           C  
ATOM   1678  CG  ASP A 229      -9.266  98.797  34.000  1.00 30.92           C  
ATOM   1679  OD1 ASP A 229      -8.263  98.996  33.280  1.00 31.22           O  
ATOM   1680  OD2 ASP A 229     -10.362  99.350  33.792  1.00 31.77           O  
ATOM   1681  N   GLY A 230      -6.620  96.059  37.157  1.00 30.02           N  
ATOM   1682  CA  GLY A 230      -6.366  95.483  38.478  1.00 29.73           C  
ATOM   1683  C   GLY A 230      -7.596  95.023  39.240  1.00 29.51           C  
ATOM   1684  O   GLY A 230      -8.230  94.029  38.874  1.00 29.39           O  
ATOM   1685  N   LEU A 231      -7.938  95.764  40.292  1.00 29.36           N  
ATOM   1686  CA  LEU A 231      -9.000  95.364  41.217  1.00 29.45           C  
ATOM   1687  C   LEU A 231     -10.389  95.918  40.857  1.00 29.62           C  
ATOM   1688  O   LEU A 231     -11.405  95.479  41.407  1.00 29.55           O  
ATOM   1689  CB  LEU A 231      -8.613  95.738  42.652  1.00 29.27           C  
ATOM   1690  CG  LEU A 231      -9.087  94.818  43.782  1.00 29.75           C  
ATOM   1691  CD1 LEU A 231      -8.851  93.348  43.452  1.00 30.25           C  
ATOM   1692  CD2 LEU A 231      -8.405  95.181  45.095  1.00 29.51           C  
ATOM   1693  N   ALA A 232     -10.422  96.875  39.932  1.00 29.73           N  
ATOM   1694  CA  ALA A 232     -11.672  97.408  39.397  1.00 29.71           C  
ATOM   1695  C   ALA A 232     -12.223  96.496  38.310  1.00 29.89           C  
ATOM   1696  O   ALA A 232     -13.433  96.424  38.098  1.00 29.88           O  
ATOM   1697  CB  ALA A 232     -11.454  98.800  38.848  1.00 29.62           C  
ATOM   1698  N   GLY A 233     -11.318  95.815  37.615  1.00 30.32           N  
ATOM   1699  CA  GLY A 233     -11.685  94.867  36.574  1.00 30.86           C  
ATOM   1700  C   GLY A 233     -12.112  93.546  37.174  1.00 31.33           C  
ATOM   1701  O   GLY A 233     -13.042  92.906  36.678  1.00 31.52           O  
ATOM   1702  N   LEU A 234     -11.434  93.143  38.247  1.00 31.65           N  
ATOM   1703  CA  LEU A 234     -11.777  91.916  38.964  1.00 32.12           C  
ATOM   1704  C   LEU A 234     -13.181  91.993  39.559  1.00 32.33           C  
ATOM   1705  O   LEU A 234     -13.851  90.970  39.695  1.00 32.41           O  
ATOM   1706  CB  LEU A 234     -10.761  91.621  40.068  1.00 32.35           C  
ATOM   1707  CG  LEU A 234     -10.649  90.150  40.482  1.00 32.84           C  
ATOM   1708  CD1 LEU A 234      -9.580  89.460  39.650  1.00 33.59           C  
ATOM   1709  CD2 LEU A 234     -10.339  90.012  41.960  1.00 32.92           C  
ATOM   1710  N   GLN A 235     -13.612  93.205  39.910  1.00 32.66           N  
ATOM   1711  CA  GLN A 235     -14.974  93.454  40.389  1.00 32.84           C  
ATOM   1712  C   GLN A 235     -16.002  93.007  39.358  1.00 32.90           C  
ATOM   1713  O   GLN A 235     -16.990  92.349  39.695  1.00 32.92           O  
ATOM   1714  CB  GLN A 235     -15.179  94.939  40.701  1.00 32.70           C  
ATOM   1715  CG  GLN A 235     -16.491  95.237  41.422  1.00 33.33           C  
ATOM   1716  CD  GLN A 235     -16.896  96.700  41.364  1.00 34.15           C  
ATOM   1717  OE1 GLN A 235     -16.364  97.482  40.571  1.00 34.89           O  
ATOM   1718  NE2 GLN A 235     -17.848  97.076  42.208  1.00 33.65           N  
ATOM   1719  N   GLN A 236     -15.756  93.370  38.104  1.00 33.01           N  
ATOM   1720  CA  GLN A 236     -16.650  93.033  37.007  1.00 33.52           C  
ATOM   1721  C   GLN A 236     -16.712  91.515  36.821  1.00 33.73           C  
ATOM   1722  O   GLN A 236     -17.802  90.942  36.704  1.00 33.89           O  
ATOM   1723  CB  GLN A 236     -16.191  93.728  35.726  1.00 33.42           C  
ATOM   1724  CG  GLN A 236     -17.256  93.852  34.660  1.00 33.44           C  
ATOM   1725  CD  GLN A 236     -16.692  94.337  33.340  1.00 34.29           C  
ATOM   1726  OE1 GLN A 236     -15.728  95.104  33.307  1.00 33.77           O  
ATOM   1727  NE2 GLN A 236     -17.291  93.891  32.240  1.00 35.68           N  
ATOM   1728  N   MET A 237     -15.538  90.881  36.809  1.00 33.74           N  
ATOM   1729  CA  MET A 237     -15.411  89.421  36.766  1.00 33.76           C  
ATOM   1730  C   MET A 237     -16.195  88.747  37.894  1.00 33.73           C  
ATOM   1731  O   MET A 237     -16.927  87.781  37.663  1.00 33.72           O  
ATOM   1732  CB  MET A 237     -13.938  89.022  36.845  1.00 33.79           C  
ATOM   1733  CG  MET A 237     -13.268  88.841  35.504  1.00 34.18           C  
ATOM   1734  SD  MET A 237     -13.235  87.111  34.999  1.00 35.66           S  
ATOM   1735  CE  MET A 237     -11.743  86.545  35.813  1.00 35.30           C  
ATOM   1736  N   ALA A 238     -16.037  89.278  39.106  1.00 33.65           N  
ATOM   1737  CA  ALA A 238     -16.749  88.799  40.286  1.00 33.67           C  
ATOM   1738  C   ALA A 238     -18.266  88.918  40.135  1.00 33.78           C  
ATOM   1739  O   ALA A 238     -19.003  87.999  40.495  1.00 33.74           O  
ATOM   1740  CB  ALA A 238     -16.290  89.565  41.506  1.00 33.59           C  
ATOM   1741  N   GLY A 239     -18.718  90.055  39.606  1.00 33.76           N  
ATOM   1742  CA  GLY A 239     -20.144  90.341  39.468  1.00 33.70           C  
ATOM   1743  C   GLY A 239     -20.832  89.416  38.488  1.00 33.64           C  
ATOM   1744  O   GLY A 239     -21.988  89.035  38.686  1.00 33.55           O  
ATOM   1745  N   ASP A 240     -20.111  89.062  37.427  1.00 33.50           N  
ATOM   1746  CA  ASP A 240     -20.594  88.100  36.445  1.00 33.32           C  
ATOM   1747  C   ASP A 240     -20.585  86.693  37.033  1.00 32.82           C  
ATOM   1748  O   ASP A 240     -21.467  85.887  36.738  1.00 32.58           O  
ATOM   1749  CB  ASP A 240     -19.745  88.166  35.174  1.00 33.59           C  
ATOM   1750  CG  ASP A 240     -19.904  89.486  34.427  1.00 35.00           C  
ATOM   1751  OD1 ASP A 240     -18.868  90.102  34.093  1.00 36.19           O  
ATOM   1752  OD2 ASP A 240     -21.059  89.910  34.176  1.00 35.51           O  
ATOM   1753  N   ALA A 241     -19.583  86.411  37.865  1.00 32.28           N  
ATOM   1754  CA  ALA A 241     -19.496  85.147  38.590  1.00 31.54           C  
ATOM   1755  C   ALA A 241     -20.674  84.999  39.546  1.00 31.28           C  
ATOM   1756  O   ALA A 241     -21.421  84.026  39.463  1.00 31.32           O  
ATOM   1757  CB  ALA A 241     -18.196  85.064  39.342  1.00 31.43           C  
ATOM   1758  N   THR A 242     -20.834  85.978  40.437  1.00 30.91           N  
ATOM   1759  CA  THR A 242     -21.954  86.040  41.382  1.00 30.56           C  
ATOM   1760  C   THR A 242     -23.295  85.904  40.666  1.00 30.25           C  
ATOM   1761  O   THR A 242     -24.226  85.305  41.202  1.00 30.29           O  
ATOM   1762  CB  THR A 242     -21.932  87.361  42.192  1.00 30.70           C  
ATOM   1763  OG1 THR A 242     -20.638  87.543  42.781  1.00 31.46           O  
ATOM   1764  CG2 THR A 242     -22.984  87.356  43.297  1.00 30.66           C  
ATOM   1765  N   LEU A 243     -23.378  86.457  39.457  1.00 30.03           N  
ATOM   1766  CA  LEU A 243     -24.570  86.346  38.619  1.00 29.80           C  
ATOM   1767  C   LEU A 243     -24.834  84.914  38.152  1.00 29.44           C  
ATOM   1768  O   LEU A 243     -25.966  84.436  38.229  1.00 29.41           O  
ATOM   1769  CB  LEU A 243     -24.481  87.292  37.419  1.00 30.01           C  
ATOM   1770  CG  LEU A 243     -25.196  88.639  37.538  1.00 30.28           C  
ATOM   1771  CD1 LEU A 243     -24.528  89.680  36.663  1.00 31.36           C  
ATOM   1772  CD2 LEU A 243     -26.667  88.500  37.172  1.00 30.80           C  
ATOM   1773  N   LEU A 244     -23.792  84.240  37.671  1.00 29.17           N  
ATOM   1774  CA  LEU A 244     -23.909  82.843  37.244  1.00 29.12           C  
ATOM   1775  C   LEU A 244     -24.067  81.897  38.424  1.00 28.84           C  
ATOM   1776  O   LEU A 244     -24.823  80.930  38.346  1.00 28.99           O  
ATOM   1777  CB  LEU A 244     -22.719  82.412  36.373  1.00 29.24           C  
ATOM   1778  CG  LEU A 244     -22.830  82.577  34.849  1.00 29.88           C  
ATOM   1779  CD1 LEU A 244     -24.040  81.828  34.289  1.00 30.06           C  
ATOM   1780  CD2 LEU A 244     -22.880  84.047  34.431  1.00 30.35           C  
ATOM   1781  N   TYR A 245     -23.355  82.179  39.512  1.00 28.43           N  
ATOM   1782  CA  TYR A 245     -23.487  81.395  40.733  1.00 28.08           C  
ATOM   1783  C   TYR A 245     -24.912  81.482  41.277  1.00 28.07           C  
ATOM   1784  O   TYR A 245     -25.461  80.480  41.730  1.00 28.03           O  
ATOM   1785  CB  TYR A 245     -22.460  81.824  41.787  1.00 27.80           C  
ATOM   1786  CG  TYR A 245     -22.586  81.082  43.102  1.00 27.35           C  
ATOM   1787  CD1 TYR A 245     -23.035  81.735  44.247  1.00 27.14           C  
ATOM   1788  CD2 TYR A 245     -22.271  79.728  43.200  1.00 26.33           C  
ATOM   1789  CE1 TYR A 245     -23.155  81.065  45.453  1.00 26.76           C  
ATOM   1790  CE2 TYR A 245     -22.393  79.050  44.402  1.00 26.14           C  
ATOM   1791  CZ  TYR A 245     -22.835  79.726  45.524  1.00 26.76           C  
ATOM   1792  OH  TYR A 245     -22.961  79.067  46.725  1.00 27.29           O  
ATOM   1793  N   TYR A 246     -25.505  82.674  41.205  1.00 28.17           N  
ATOM   1794  CA  TYR A 246     -26.902  82.881  41.591  1.00 28.29           C  
ATOM   1795  C   TYR A 246     -27.842  81.888  40.906  1.00 28.24           C  
ATOM   1796  O   TYR A 246     -28.779  81.388  41.525  1.00 28.29           O  
ATOM   1797  CB  TYR A 246     -27.348  84.319  41.299  1.00 28.35           C  
ATOM   1798  CG  TYR A 246     -28.828  84.569  41.526  1.00 29.12           C  
ATOM   1799  CD1 TYR A 246     -29.748  84.441  40.478  1.00 29.47           C  
ATOM   1800  CD2 TYR A 246     -29.310  84.927  42.787  1.00 29.33           C  
ATOM   1801  CE1 TYR A 246     -31.108  84.662  40.682  1.00 28.97           C  
ATOM   1802  CE2 TYR A 246     -30.668  85.152  42.999  1.00 28.94           C  
ATOM   1803  CZ  TYR A 246     -31.560  85.019  41.944  1.00 29.37           C  
ATOM   1804  OH  TYR A 246     -32.905  85.242  42.152  1.00 29.73           O  
ATOM   1805  N   THR A 247     -27.573  81.601  39.634  1.00 28.35           N  
ATOM   1806  CA  THR A 247     -28.447  80.750  38.824  1.00 28.56           C  
ATOM   1807  C   THR A 247     -28.293  79.246  39.095  1.00 28.82           C  
ATOM   1808  O   THR A 247     -29.083  78.438  38.598  1.00 28.75           O  
ATOM   1809  CB  THR A 247     -28.264  81.029  37.315  1.00 28.45           C  
ATOM   1810  OG1 THR A 247     -26.931  80.692  36.922  1.00 28.30           O  
ATOM   1811  CG2 THR A 247     -28.526  82.498  37.002  1.00 28.47           C  
ATOM   1812  N   THR A 248     -27.288  78.880  39.889  1.00 29.19           N  
ATOM   1813  CA  THR A 248     -27.017  77.474  40.205  1.00 29.62           C  
ATOM   1814  C   THR A 248     -27.857  76.971  41.377  1.00 29.73           C  
ATOM   1815  O   THR A 248     -28.083  77.703  42.342  1.00 29.73           O  
ATOM   1816  CB  THR A 248     -25.535  77.242  40.545  1.00 29.73           C  
ATOM   1817  OG1 THR A 248     -25.216  77.908  41.772  1.00 29.85           O  
ATOM   1818  CG2 THR A 248     -24.629  77.755  39.426  1.00 29.96           C  
ATOM   1819  N   ASP A 249     -28.290  75.712  41.288  1.00 29.95           N  
ATOM   1820  CA  ASP A 249     -29.110  75.060  42.318  1.00 30.21           C  
ATOM   1821  C   ASP A 249     -28.529  75.179  43.723  1.00 30.33           C  
ATOM   1822  O   ASP A 249     -29.272  75.239  44.706  1.00 30.40           O  
ATOM   1823  CB  ASP A 249     -29.320  73.578  41.984  1.00 30.24           C  
ATOM   1824  CG  ASP A 249     -30.456  73.349  41.003  1.00 30.54           C  
ATOM   1825  OD1 ASP A 249     -30.522  72.243  40.424  1.00 30.96           O  
ATOM   1826  OD2 ASP A 249     -31.286  74.263  40.810  1.00 31.07           O  
ATOM   1827  N   GLU A 250     -27.201  75.199  43.801  1.00 30.41           N  
ATOM   1828  CA  GLU A 250     -26.485  75.344  45.062  1.00 30.60           C  
ATOM   1829  C   GLU A 250     -26.868  76.651  45.756  1.00 30.58           C  
ATOM   1830  O   GLU A 250     -27.298  76.637  46.912  1.00 30.82           O  
ATOM   1831  CB  GLU A 250     -24.980  75.289  44.805  1.00 30.55           C  
ATOM   1832  CG  GLU A 250     -24.103  75.160  46.040  1.00 30.58           C  
ATOM   1833  CD  GLU A 250     -22.624  75.092  45.685  1.00 31.06           C  
ATOM   1834  OE1 GLU A 250     -22.308  75.016  44.477  1.00 32.12           O  
ATOM   1835  OE2 GLU A 250     -21.777  75.112  46.604  1.00 30.97           O  
ATOM   1836  N   ALA A 251     -26.727  77.767  45.041  1.00 30.32           N  
ATOM   1837  CA  ALA A 251     -27.040  79.090  45.582  1.00 30.02           C  
ATOM   1838  C   ALA A 251     -28.486  79.186  46.048  1.00 30.04           C  
ATOM   1839  O   ALA A 251     -28.755  79.728  47.122  1.00 30.07           O  
ATOM   1840  CB  ALA A 251     -26.741  80.166  44.562  1.00 29.96           C  
ATOM   1841  N   LYS A 252     -29.406  78.656  45.241  1.00 30.03           N  
ATOM   1842  CA  LYS A 252     -30.825  78.623  45.594  1.00 30.04           C  
ATOM   1843  C   LYS A 252     -31.028  78.052  46.993  1.00 29.89           C  
ATOM   1844  O   LYS A 252     -31.803  78.592  47.780  1.00 29.91           O  
ATOM   1845  CB  LYS A 252     -31.633  77.808  44.576  1.00 30.24           C  
ATOM   1846  CG  LYS A 252     -32.060  78.585  43.334  1.00 30.87           C  
ATOM   1847  CD  LYS A 252     -31.151  78.311  42.139  1.00 31.04           C  
ATOM   1848  CE  LYS A 252     -31.260  79.392  41.068  1.00 30.73           C  
ATOM   1849  NZ  LYS A 252     -32.650  79.651  40.592  1.00 31.11           N  
ATOM   1850  N   GLU A 253     -30.305  76.975  47.294  1.00 29.79           N  
ATOM   1851  CA  GLU A 253     -30.401  76.290  48.580  1.00 29.81           C  
ATOM   1852  C   GLU A 253     -29.959  77.190  49.734  1.00 29.66           C  
ATOM   1853  O   GLU A 253     -30.556  77.168  50.811  1.00 29.68           O  
ATOM   1854  CB  GLU A 253     -29.569  75.005  48.552  1.00 29.81           C  
ATOM   1855  CG  GLU A 253     -30.171  73.843  49.332  1.00 30.78           C  
ATOM   1856  CD  GLU A 253     -30.032  73.990  50.836  1.00 31.86           C  
ATOM   1857  OE1 GLU A 253     -30.919  73.492  51.562  1.00 32.10           O  
ATOM   1858  OE2 GLU A 253     -29.040  74.600  51.294  1.00 32.50           O  
ATOM   1859  N   GLY A 254     -28.918  77.983  49.494  1.00 29.58           N  
ATOM   1860  CA  GLY A 254     -28.385  78.902  50.497  1.00 29.43           C  
ATOM   1861  C   GLY A 254     -29.345  80.007  50.897  1.00 29.36           C  
ATOM   1862  O   GLY A 254     -29.382  80.406  52.064  1.00 29.42           O  
ATOM   1863  N   ARG A 255     -30.119  80.501  49.931  1.00 29.18           N  
ATOM   1864  CA  ARG A 255     -31.090  81.569  50.189  1.00 28.99           C  
ATOM   1865  C   ARG A 255     -32.469  81.041  50.583  1.00 28.94           C  
ATOM   1866  O   ARG A 255     -33.252  81.749  51.224  1.00 29.03           O  
ATOM   1867  CB  ARG A 255     -31.193  82.540  49.008  1.00 28.93           C  
ATOM   1868  CG  ARG A 255     -31.456  81.907  47.657  1.00 28.94           C  
ATOM   1869  CD  ARG A 255     -32.009  82.944  46.698  1.00 29.38           C  
ATOM   1870  NE  ARG A 255     -31.615  82.682  45.317  1.00 29.81           N  
ATOM   1871  CZ  ARG A 255     -32.379  82.088  44.406  1.00 29.35           C  
ATOM   1872  NH1 ARG A 255     -31.910  81.908  43.180  1.00 29.29           N  
ATOM   1873  NH2 ARG A 255     -33.605  81.679  44.711  1.00 29.31           N  
ATOM   1874  N   ASP A 256     -32.760  79.801  50.196  1.00 28.69           N  
ATOM   1875  CA  ASP A 256     -33.972  79.131  50.645  1.00 28.57           C  
ATOM   1876  C   ASP A 256     -33.901  78.871  52.146  1.00 28.61           C  
ATOM   1877  O   ASP A 256     -34.871  79.110  52.868  1.00 28.77           O  
ATOM   1878  CB  ASP A 256     -34.194  77.822  49.880  1.00 28.54           C  
ATOM   1879  CG  ASP A 256     -34.824  78.039  48.511  1.00 28.55           C  
ATOM   1880  OD1 ASP A 256     -35.019  79.207  48.108  1.00 28.43           O  
ATOM   1881  OD2 ASP A 256     -35.124  77.032  47.833  1.00 28.51           O  
ATOM   1882  N   ALA A 257     -32.742  78.402  52.607  1.00 28.45           N  
ATOM   1883  CA  ALA A 257     -32.518  78.112  54.022  1.00 28.30           C  
ATOM   1884  C   ALA A 257     -32.632  79.357  54.899  1.00 28.37           C  
ATOM   1885  O   ALA A 257     -32.954  79.259  56.083  1.00 28.41           O  
ATOM   1886  CB  ALA A 257     -31.170  77.454  54.213  1.00 28.29           C  
ATOM   1887  N   PHE A 258     -32.366  80.524  54.315  1.00 28.47           N  
ATOM   1888  CA  PHE A 258     -32.511  81.791  55.028  1.00 28.59           C  
ATOM   1889  C   PHE A 258     -33.984  82.146  55.232  1.00 28.65           C  
ATOM   1890  O   PHE A 258     -34.388  82.540  56.327  1.00 28.61           O  
ATOM   1891  CB  PHE A 258     -31.777  82.918  54.292  1.00 28.55           C  
ATOM   1892  CG  PHE A 258     -31.822  84.238  55.009  1.00 28.50           C  
ATOM   1893  CD1 PHE A 258     -30.984  84.485  56.095  1.00 28.93           C  
ATOM   1894  CD2 PHE A 258     -32.700  85.236  54.600  1.00 28.36           C  
ATOM   1895  CE1 PHE A 258     -31.024  85.705  56.763  1.00 29.13           C  
ATOM   1896  CE2 PHE A 258     -32.747  86.459  55.261  1.00 28.58           C  
ATOM   1897  CZ  PHE A 258     -31.908  86.695  56.345  1.00 29.00           C  
ATOM   1898  N   LYS A 259     -34.775  81.999  54.171  1.00 28.74           N  
ATOM   1899  CA  LYS A 259     -36.215  82.237  54.227  1.00 28.89           C  
ATOM   1900  C   LYS A 259     -36.947  81.155  55.027  1.00 28.96           C  
ATOM   1901  O   LYS A 259     -38.060  81.379  55.511  1.00 28.95           O  
ATOM   1902  CB  LYS A 259     -36.784  82.339  52.818  1.00 28.94           C  
ATOM   1903  N   GLU A 260     -36.317  79.989  55.159  1.00 29.05           N  
ATOM   1904  CA  GLU A 260     -36.863  78.873  55.936  1.00 29.10           C  
ATOM   1905  C   GLU A 260     -36.299  78.828  57.360  1.00 28.97           C  
ATOM   1906  O   GLU A 260     -36.598  77.907  58.122  1.00 29.02           O  
ATOM   1907  CB  GLU A 260     -36.595  77.541  55.226  1.00 29.18           C  
ATOM   1908  CG  GLU A 260     -37.339  77.355  53.908  1.00 29.24           C  
ATOM   1909  CD  GLU A 260     -37.024  76.027  53.239  1.00 29.26           C  
ATOM   1910  OE1 GLU A 260     -37.137  74.977  53.909  1.00 29.22           O  
ATOM   1911  OE2 GLU A 260     -36.672  76.034  52.038  1.00 29.18           O  
ATOM   1912  N   LYS A 261     -35.476  79.820  57.698  1.00 29.04           N  
ATOM   1913  CA  LYS A 261     -34.875  79.980  59.035  1.00 29.23           C  
ATOM   1914  C   LYS A 261     -34.061  78.783  59.550  1.00 29.24           C  
ATOM   1915  O   LYS A 261     -33.592  78.795  60.692  1.00 29.31           O  
ATOM   1916  CB  LYS A 261     -35.926  80.392  60.078  1.00 29.38           C  
ATOM   1917  CG  LYS A 261     -36.486  81.802  59.919  1.00 29.68           C  
ATOM   1918  CD  LYS A 261     -37.848  81.791  59.234  1.00 29.99           C  
ATOM   1919  CE  LYS A 261     -38.605  83.092  59.465  1.00 29.97           C  
ATOM   1920  NZ  LYS A 261     -37.940  84.267  58.834  1.00 29.64           N  
ATOM   1921  N   ARG A 262     -33.894  77.762  58.712  1.00 29.18           N  
ATOM   1922  CA  ARG A 262     -33.117  76.575  59.079  1.00 29.09           C  
ATOM   1923  C   ARG A 262     -31.701  76.599  58.502  1.00 29.07           C  
ATOM   1924  O   ARG A 262     -31.319  77.555  57.828  1.00 28.98           O  
ATOM   1925  CB  ARG A 262     -33.860  75.286  58.690  1.00 29.08           C  
ATOM   1926  CG  ARG A 262     -34.519  75.287  57.314  1.00 28.90           C  
ATOM   1927  CD  ARG A 262     -33.577  74.809  56.226  1.00 28.60           C  
ATOM   1928  NE  ARG A 262     -34.302  74.437  55.014  1.00 28.29           N  
ATOM   1929  CZ  ARG A 262     -33.730  74.197  53.837  1.00 28.27           C  
ATOM   1930  NH1 ARG A 262     -32.414  74.294  53.694  1.00 28.08           N  
ATOM   1931  NH2 ARG A 262     -34.479  73.864  52.795  1.00 28.25           N  
ATOM   1932  N   ASP A 263     -30.926  75.556  58.784  1.00 29.24           N  
ATOM   1933  CA  ASP A 263     -29.544  75.470  58.311  1.00 29.49           C  
ATOM   1934  C   ASP A 263     -29.454  75.031  56.850  1.00 29.63           C  
ATOM   1935  O   ASP A 263     -30.230  74.180  56.409  1.00 29.66           O  
ATOM   1936  CB  ASP A 263     -28.721  74.534  59.203  1.00 29.60           C  
ATOM   1937  CG  ASP A 263     -27.998  75.272  60.324  1.00 29.84           C  
ATOM   1938  OD1 ASP A 263     -27.262  76.241  60.033  1.00 29.43           O  
ATOM   1939  OD2 ASP A 263     -28.154  74.871  61.497  1.00 30.22           O  
ATOM   1940  N   PRO A 264     -28.510  75.621  56.093  1.00 29.81           N  
ATOM   1941  CA  PRO A 264     -28.289  75.260  54.694  1.00 30.00           C  
ATOM   1942  C   PRO A 264     -27.669  73.876  54.545  1.00 30.29           C  
ATOM   1943  O   PRO A 264     -26.797  73.499  55.329  1.00 30.28           O  
ATOM   1944  CB  PRO A 264     -27.304  76.329  54.202  1.00 29.95           C  
ATOM   1945  CG  PRO A 264     -27.311  77.398  55.247  1.00 29.85           C  
ATOM   1946  CD  PRO A 264     -27.595  76.692  56.520  1.00 29.82           C  
ATOM   1947  N   ASP A 265     -28.123  73.138  53.537  1.00 30.73           N  
ATOM   1948  CA  ASP A 265     -27.622  71.794  53.277  1.00 31.18           C  
ATOM   1949  C   ASP A 265     -26.943  71.701  51.910  1.00 31.38           C  
ATOM   1950  O   ASP A 265     -27.572  71.337  50.912  1.00 31.37           O  
ATOM   1951  CB  ASP A 265     -28.759  70.771  53.393  1.00 31.36           C  
ATOM   1952  CG  ASP A 265     -28.252  69.349  53.579  1.00 32.03           C  
ATOM   1953  OD1 ASP A 265     -27.473  69.107  54.527  1.00 32.73           O  
ATOM   1954  OD2 ASP A 265     -28.648  68.468  52.784  1.00 32.47           O  
ATOM   1955  N   PHE A 266     -25.656  72.043  51.875  1.00 31.63           N  
ATOM   1956  CA  PHE A 266     -24.837  71.870  50.675  1.00 31.85           C  
ATOM   1957  C   PHE A 266     -24.226  70.467  50.648  1.00 32.43           C  
ATOM   1958  O   PHE A 266     -23.171  70.242  50.045  1.00 32.42           O  
ATOM   1959  CB  PHE A 266     -23.743  72.942  50.600  1.00 31.45           C  
ATOM   1960  CG  PHE A 266     -24.265  74.351  50.658  1.00 30.62           C  
ATOM   1961  CD1 PHE A 266     -24.063  75.133  51.790  1.00 29.89           C  
ATOM   1962  CD2 PHE A 266     -24.961  74.899  49.583  1.00 29.87           C  
ATOM   1963  CE1 PHE A 266     -24.541  76.436  51.851  1.00 29.20           C  
ATOM   1964  CE2 PHE A 266     -25.445  76.200  49.636  1.00 29.17           C  
ATOM   1965  CZ  PHE A 266     -25.235  76.970  50.773  1.00 29.69           C  
ATOM   1966  N   ASP A 267     -24.918  69.536  51.305  1.00 33.09           N  
ATOM   1967  CA  ASP A 267     -24.502  68.145  51.461  1.00 33.73           C  
ATOM   1968  C   ASP A 267     -24.389  67.433  50.116  1.00 34.13           C  
ATOM   1969  O   ASP A 267     -23.314  66.952  49.755  1.00 34.08           O  
ATOM   1970  CB  ASP A 267     -25.495  67.418  52.383  1.00 33.89           C  
ATOM   1971  CG  ASP A 267     -25.204  65.930  52.530  1.00 34.32           C  
ATOM   1972  OD1 ASP A 267     -24.129  65.571  53.059  1.00 34.93           O  
ATOM   1973  OD2 ASP A 267     -26.070  65.119  52.136  1.00 33.92           O  
ATOM   1974  N   GLN A 268     -25.496  67.374  49.379  1.00 34.86           N  
ATOM   1975  CA  GLN A 268     -25.518  66.681  48.094  1.00 35.65           C  
ATOM   1976  C   GLN A 268     -25.516  67.647  46.918  1.00 36.11           C  
ATOM   1977  O   GLN A 268     -26.551  67.925  46.309  1.00 36.18           O  
ATOM   1978  CB  GLN A 268     -26.687  65.687  48.003  1.00 35.76           C  
ATOM   1979  CG  GLN A 268     -26.536  64.430  48.873  1.00 36.08           C  
ATOM   1980  CD  GLN A 268     -25.236  63.657  48.631  1.00 36.53           C  
ATOM   1981  OE1 GLN A 268     -24.587  63.793  47.589  1.00 36.27           O  
ATOM   1982  NE2 GLN A 268     -24.860  62.830  49.602  1.00 36.64           N  
ATOM   1983  N   PHE A 269     -24.330  68.166  46.627  1.00 36.77           N  
ATOM   1984  CA  PHE A 269     -24.101  69.010  45.467  1.00 37.41           C  
ATOM   1985  C   PHE A 269     -22.734  68.667  44.880  1.00 37.93           C  
ATOM   1986  O   PHE A 269     -21.770  68.483  45.631  1.00 37.96           O  
ATOM   1987  CB  PHE A 269     -24.177  70.492  45.848  1.00 37.41           C  
ATOM   1988  CG  PHE A 269     -25.576  70.987  46.089  1.00 37.42           C  
ATOM   1989  CD1 PHE A 269     -26.095  71.042  47.377  1.00 37.57           C  
ATOM   1990  CD2 PHE A 269     -26.375  71.399  45.027  1.00 37.43           C  
ATOM   1991  CE1 PHE A 269     -27.389  71.499  47.606  1.00 37.57           C  
ATOM   1992  CE2 PHE A 269     -27.671  71.857  45.245  1.00 37.27           C  
ATOM   1993  CZ  PHE A 269     -28.177  71.909  46.536  1.00 37.38           C  
ATOM   1994  N   PRO A 270     -22.649  68.567  43.538  1.00 38.39           N  
ATOM   1995  CA  PRO A 270     -21.416  68.143  42.872  1.00 38.75           C  
ATOM   1996  C   PRO A 270     -20.233  69.063  43.174  1.00 39.11           C  
ATOM   1997  O   PRO A 270     -20.279  70.257  42.874  1.00 39.14           O  
ATOM   1998  CB  PRO A 270     -21.783  68.204  41.384  1.00 38.80           C  
ATOM   1999  CG  PRO A 270     -23.273  68.112  41.352  1.00 38.63           C  
ATOM   2000  CD  PRO A 270     -23.722  68.850  42.566  1.00 38.37           C  
ATOM   2001  N   LYS A 271     -19.192  68.501  43.784  1.00 39.62           N  
ATOM   2002  CA  LYS A 271     -17.976  69.246  44.093  1.00 40.10           C  
ATOM   2003  C   LYS A 271     -16.893  68.943  43.062  1.00 40.41           C  
ATOM   2004  O   LYS A 271     -16.415  67.808  42.963  1.00 40.56           O  
ATOM   2005  CB  LYS A 271     -17.489  68.921  45.504  1.00 40.09           C  
ATOM   2006  N   PHE A 272     -16.518  69.963  42.293  1.00 40.73           N  
ATOM   2007  CA  PHE A 272     -15.521  69.814  41.233  1.00 41.09           C  
ATOM   2008  C   PHE A 272     -14.106  70.110  41.740  1.00 41.27           C  
ATOM   2009  O   PHE A 272     -13.897  71.090  42.460  1.00 41.30           O  
ATOM   2010  CB  PHE A 272     -15.861  70.711  40.036  1.00 41.17           C  
ATOM   2011  CG  PHE A 272     -17.308  70.653  39.619  1.00 41.41           C  
ATOM   2012  CD1 PHE A 272     -18.173  71.698  39.928  1.00 41.42           C  
ATOM   2013  CD2 PHE A 272     -17.806  69.554  38.922  1.00 41.93           C  
ATOM   2014  CE1 PHE A 272     -19.512  71.651  39.548  1.00 41.72           C  
ATOM   2015  CE2 PHE A 272     -19.145  69.496  38.537  1.00 41.80           C  
ATOM   2016  CZ  PHE A 272     -20.000  70.546  38.851  1.00 41.72           C  
ATOM   2017  N   PRO A 273     -13.132  69.250  41.381  1.00 41.46           N  
ATOM   2018  CA  PRO A 273     -11.724  69.465  41.721  1.00 41.63           C  
ATOM   2019  C   PRO A 273     -11.104  70.621  40.936  1.00 41.69           C  
ATOM   2020  O   PRO A 273     -11.758  71.269  40.116  1.00 41.68           O  
ATOM   2021  CB  PRO A 273     -11.055  68.141  41.318  1.00 41.65           C  
ATOM   2022  CG  PRO A 273     -12.171  67.164  41.154  1.00 41.67           C  
ATOM   2023  CD  PRO A 273     -13.312  67.985  40.652  1.00 41.54           C  
ATOM   2024  OXT PRO A 273      -9.926  70.934  41.106  1.00 41.79           O  
TER    2025      PRO A 273                                                      
END
MOLECULE T0486.pdb
ATOM      1  N   PRO    32     -34.619 118.105  22.201  1.00 36.37           N  
ATOM      2  CA  PRO    32     -33.499 118.122  21.209  1.00 35.38           C  
ATOM      4  CB  PRO    32     -33.430 119.614  20.792  1.00 35.70           C  
ATOM      7  CG  PRO    32     -33.972 120.393  22.069  1.00 36.10           C  
ATOM     10  CD  PRO    32     -34.671 119.355  22.997  1.00 36.93           C  
ATOM     13  C   PRO    32     -32.165 117.592  21.848  1.00 33.74           C  
ATOM     14  O   PRO    32     -31.732 118.103  22.927  1.00 33.85           O  
ATOM     17  N   ARG    33     -31.582 116.543  21.238  1.00 30.52           N  
ATOM     18  CA  ARG    33     -30.447 115.793  21.849  1.00 27.98           C  
ATOM     20  CB  ARG    33     -30.865 114.408  22.341  1.00 28.20           C  
ATOM     23  CG  ARG    33     -31.393 114.428  23.789  1.00 29.12           C  
ATOM     26  CD  ARG    33     -32.244 113.222  24.112  1.00 29.44           C  
ATOM     29  NE  ARG    33     -31.441 112.010  24.221  1.00 34.76           N  
ATOM     31  CZ  ARG    33     -30.684 111.700  25.275  1.00 35.22           C  
ATOM     32  NH1 ARG    33     -30.631 112.499  26.343  1.00 36.88           N  
ATOM     35  NH2 ARG    33     -29.978 110.588  25.259  1.00 32.19           N  
ATOM     38  C   ARG    33     -29.262 115.677  20.906  1.00 25.16           C  
ATOM     39  O   ARG    33     -29.423 115.490  19.701  1.00 24.96           O  
ATOM     41  N   PRO    34     -28.053 115.856  21.441  1.00 22.90           N  
ATOM     42  CA  PRO    34     -26.892 115.796  20.552  1.00 21.60           C  
ATOM     44  CB  PRO    34     -25.813 116.476  21.373  1.00 21.42           C  
ATOM     47  CG  PRO    34     -26.259 116.398  22.777  1.00 21.04           C  
ATOM     50  CD  PRO    34     -27.713 116.344  22.796  1.00 21.80           C  
ATOM     53  C   PRO    34     -26.530 114.359  20.058  1.00 21.60           C  
ATOM     54  O   PRO    34     -25.855 114.222  19.035  1.00 19.72           O  
ATOM     55  N   THR    35     -27.041 113.315  20.739  1.00 21.90           N  
ATOM     56  CA  THR    35     -27.051 111.948  20.185  1.00 23.12           C  
ATOM     58  CB  THR    35     -26.409 110.928  21.125  1.00 22.50           C  
ATOM     60  OG1 THR    35     -27.132 110.918  22.364  1.00 25.34           O  
ATOM     62  CG2 THR    35     -24.919 111.265  21.369  1.00 21.08           C  
ATOM     66  C   THR    35     -28.454 111.425  19.823  1.00 23.98           C  
ATOM     67  O   THR    35     -29.444 111.807  20.428  1.00 23.83           O  
ATOM     69  N   SER    36     -28.514 110.537  18.832  1.00 25.38           N  
ATOM     70  CA  SER    36     -29.722 109.737  18.544  1.00 26.75           C  
ATOM     72  CB  SER    36     -30.314 110.035  17.140  1.00 27.55           C  
ATOM     75  OG  SER    36     -29.338 110.522  16.226  1.00 30.93           O  
ATOM     77  C   SER    36     -29.398 108.260  18.650  1.00 26.57           C  
ATOM     78  O   SER    36     -28.336 107.810  18.248  1.00 27.02           O  
ATOM     80  N   ALA    37     -30.314 107.511  19.238  1.00 26.96           N  
ATOM     81  CA  ALA    37     -30.143 106.081  19.431  1.00 27.11           C  
ATOM     83  CB  ALA    37     -29.956 105.773  20.900  1.00 26.60           C  
ATOM     87  C   ALA    37     -31.372 105.383  18.908  1.00 27.34           C  
ATOM     88  O   ALA    37     -32.470 105.853  19.106  1.00 28.07           O  
ATOM     90  N   ARG    38     -31.190 104.251  18.246  1.00 27.41           N  
ATOM     91  CA  ARG    38     -32.296 103.405  17.847  1.00 27.20           C  
ATOM     93  CB  ARG    38     -32.659 103.679  16.387  1.00 27.68           C  
ATOM     96  CG  ARG    38     -31.555 103.196  15.435  1.00 32.69           C  
ATOM     99  CD  ARG    38     -31.659 103.719  14.024  1.00 41.47           C  
ATOM    102  NE  ARG    38     -30.354 103.705  13.320  1.00 45.71           N  
ATOM    104  CZ  ARG    38     -29.427 104.668  13.420  1.00 50.50           C  
ATOM    105  NH1 ARG    38     -29.618 105.741  14.231  1.00 50.89           N  
ATOM    108  NH2 ARG    38     -28.289 104.552  12.723  1.00 52.00           N  
ATOM    111  C   ARG    38     -31.815 101.967  18.007  1.00 25.56           C  
ATOM    112  O   ARG    38     -30.678 101.662  17.715  1.00 25.50           O  
ATOM    114  N   GLN    39     -32.704 101.090  18.416  1.00 24.27           N  
ATOM    115  CA  GLN    39     -32.419  99.696  18.607  1.00 23.41           C  
ATOM    117  CB  GLN    39     -32.504  99.381  20.098  1.00 22.43           C  
ATOM    120  CG  GLN    39     -32.031  98.004  20.463  1.00 20.76           C  
ATOM    123  CD  GLN    39     -32.101  97.804  21.945  1.00 19.82           C  
ATOM    124  OE1 GLN    39     -31.617  98.641  22.700  1.00 21.67           O  
ATOM    125  NE2 GLN    39     -32.718  96.729  22.382  1.00 18.57           N  
ATOM    128  C   GLN    39     -33.376  98.795  17.807  1.00 23.80           C  
ATOM    129  O   GLN    39     -34.607  98.928  17.836  1.00 22.33           O  
ATOM    131  N   LEU    40     -32.781  97.833  17.122  1.00 24.93           N  
ATOM    132  CA  LEU    40     -33.517  96.918  16.193  1.00 24.93           C  
ATOM    134  CB  LEU    40     -33.638  97.621  14.868  1.00 23.82           C  
ATOM    137  CG  LEU    40     -34.317  97.048  13.632  1.00 25.78           C  
ATOM    139  CD1 LEU    40     -35.754  96.407  13.794  1.00 22.15           C  
ATOM    143  CD2 LEU    40     -34.332  98.285  12.734  1.00 27.38           C  
ATOM    147  C   LEU    40     -32.727  95.579  16.056  1.00 24.92           C  
ATOM    148  O   LEU    40     -31.532  95.556  15.665  1.00 24.12           O  
ATOM    150  N   ASP    41     -33.397  94.485  16.407  1.00 24.46           N  
ATOM    151  CA  ASP    41     -32.832  93.138  16.324  1.00 23.32           C  
ATOM    153  CB  ASP    41     -32.497  92.813  14.881  1.00 23.91           C  
ATOM    156  CG  ASP    41     -33.714  92.826  14.019  1.00 24.72           C  
ATOM    157  OD1 ASP    41     -34.776  92.365  14.493  1.00 26.36           O  
ATOM    158  OD2 ASP    41     -33.611  93.311  12.880  1.00 28.80           O  
ATOM    159  C   ASP    41     -31.614  92.967  17.229  1.00 21.87           C  
ATOM    160  O   ASP    41     -30.626  92.310  16.860  1.00 20.53           O  
ATOM    162  N   GLY    42     -31.746  93.566  18.411  1.00 20.42           N  
ATOM    163  CA  GLY    42     -30.736  93.512  19.459  1.00 20.29           C  
ATOM    166  C   GLY    42     -29.595  94.500  19.363  1.00 19.56           C  
ATOM    167  O   GLY    42     -28.794  94.588  20.317  1.00 18.21           O  
ATOM    169  N   ILE    43     -29.524  95.210  18.216  1.00 18.49           N  
ATOM    170  CA  ILE    43     -28.446  96.171  17.861  1.00 18.12           C  
ATOM    172  CB  ILE    43     -27.947  96.049  16.350  1.00 17.15           C  
ATOM    174  CG1 ILE    43     -27.750  94.566  15.978  1.00 17.41           C  
ATOM    177  CD1 ILE    43     -27.448  94.223  14.517  1.00 10.50           C  
ATOM    181  CG2 ILE    43     -26.679  96.919  16.144  1.00 16.46           C  
ATOM    185  C   ILE    43     -28.914  97.604  18.115  1.00 18.28           C  
ATOM    186  O   ILE    43     -29.876  98.098  17.509  1.00 18.83           O  
ATOM    188  N   ARG    44     -28.217  98.262  19.026  1.00 19.01           N  
ATOM    189  CA  ARG    44     -28.426  99.669  19.350  1.00 18.37           C  
ATOM    191  CB  ARG    44     -28.251  99.867  20.862  1.00 17.76           C  
ATOM    194  CG  ARG    44     -28.759 101.185  21.386  1.00 16.54           C  
ATOM    197  CD  ARG    44     -28.557 101.298  22.871  1.00 13.79           C  
ATOM    200  NE  ARG    44     -29.614 100.601  23.569  1.00 16.47           N  
ATOM    202  CZ  ARG    44     -29.743 100.548  24.895  1.00 14.91           C  
ATOM    203  NH1 ARG    44     -28.873 101.103  25.694  1.00 16.61           N  
ATOM    206  NH2 ARG    44     -30.739  99.908  25.406  1.00 13.62           N  
ATOM    209  C   ARG    44     -27.374 100.471  18.614  1.00 18.83           C  
ATOM    210  O   ARG    44     -26.207 100.233  18.807  1.00 19.07           O  
ATOM    212  N   ASN    45     -27.790 101.381  17.737  1.00 20.00           N  
ATOM    213  CA  ASN    45     -26.902 102.386  17.160  1.00 21.31           C  
ATOM    215  CB  ASN    45     -27.254 102.653  15.690  1.00 22.09           C  
ATOM    218  CG  ASN    45     -26.607 101.671  14.767  1.00 25.78           C  
ATOM    219  OD1 ASN    45     -25.428 101.800  14.420  1.00 29.25           O  
ATOM    220  ND2 ASN    45     -27.368 100.646  14.370  1.00 29.97           N  
ATOM    223  C   ASN    45     -27.097 103.694  17.913  1.00 20.17           C  
ATOM    224  O   ASN    45     -28.210 104.202  17.948  1.00 18.97           O  
ATOM    226  N   ILE    46     -26.014 104.210  18.466  1.00 18.93           N  
ATOM    227  CA  ILE    46     -25.987 105.493  19.103  1.00 19.48           C  
ATOM    229  CB  ILE    46     -25.365 105.470  20.503  1.00 20.23           C  
ATOM    231  CG1 ILE    46     -25.959 104.315  21.334  1.00 18.43           C  
ATOM    234  CD1 ILE    46     -25.395 104.142  22.715  1.00 16.72           C  
ATOM    238  CG2 ILE    46     -25.657 106.813  21.251  1.00 21.84           C  
ATOM    242  C   ILE    46     -25.153 106.373  18.195  1.00 19.86           C  
ATOM    243  O   ILE    46     -24.007 106.093  17.927  1.00 19.65           O  
ATOM    245  N   VAL    47     -25.783 107.396  17.626  1.00 19.12           N  
ATOM    246  CA  VAL    47     -25.130 108.216  16.637  1.00 17.92           C  
ATOM    248  CB  VAL    47     -26.000 108.295  15.342  1.00 18.43           C  
ATOM    250  CG1 VAL    47     -25.252 109.065  14.230  1.00 14.15           C  
ATOM    254  CG2 VAL    47     -26.458 106.884  14.946  1.00 15.51           C  
ATOM    258  C   VAL    47     -24.874 109.613  17.222  1.00 18.23           C  
ATOM    259  O   VAL    47     -25.789 110.245  17.749  1.00 16.54           O  
ATOM    261  N   LEU    48     -23.597 110.026  17.180  1.00 19.26           N  
ATOM    262  CA  LEU    48     -23.140 111.408  17.516  1.00 19.61           C  
ATOM    264  CB  LEU    48     -21.612 111.473  17.583  1.00 19.28           C  
ATOM    267  CG  LEU    48     -20.809 111.031  18.827  1.00 21.00           C  
ATOM    269  CD1 LEU    48     -21.282 109.801  19.431  1.00 21.01           C  
ATOM    273  CD2 LEU    48     -19.254 110.978  18.591  1.00 20.34           C  
ATOM    277  C   LEU    48     -23.683 112.346  16.433  1.00 19.02           C  
ATOM    278  O   LEU    48     -23.265 112.242  15.284  1.00 19.61           O  
ATOM    280  N   SER    49     -24.629 113.228  16.817  1.00 19.00           N  
ATOM    281  CA  SER    49     -25.459 113.967  15.907  1.00 19.54           C  
ATOM    283  CB  SER    49     -26.956 113.575  16.017  1.00 19.42           C  
ATOM    286  OG  SER    49     -27.184 112.207  15.968  1.00 22.18           O  
ATOM    288  C   SER    49     -25.374 115.453  16.188  1.00 19.35           C  
ATOM    289  O   SER    49     -26.415 116.121  16.348  1.00 20.03           O  
ATOM    291  N   ASN    50     -24.167 115.992  16.192  1.00 18.55           N  
ATOM    292  CA  ASN    50     -23.986 117.427  16.208  1.00 18.37           C  
ATOM    294  CB  ASN    50     -23.746 117.909  17.661  1.00 18.55           C  
ATOM    297  CG  ASN    50     -23.854 119.443  17.836  1.00 20.36           C  
ATOM    298  OD1 ASN    50     -24.433 120.176  17.010  1.00 23.36           O  
ATOM    299  ND2 ASN    50     -23.307 119.920  18.928  1.00 20.58           N  
ATOM    302  C   ASN    50     -22.845 117.817  15.253  1.00 17.76           C  
ATOM    303  O   ASN    50     -21.879 118.424  15.685  1.00 16.99           O  
ATOM    305  N   PRO    51     -22.976 117.488  13.948  1.00 17.55           N  
ATOM    306  CA  PRO    51     -21.879 117.662  12.995  1.00 17.89           C  
ATOM    308  CB  PRO    51     -22.410 117.004  11.717  1.00 17.83           C  
ATOM    311  CG  PRO    51     -23.910 117.044  11.828  1.00 17.67           C  
ATOM    314  CD  PRO    51     -24.125 116.811  13.314  1.00 18.65           C  
ATOM    317  C   PRO    51     -21.472 119.109  12.713  1.00 18.99           C  
ATOM    318  O   PRO    51     -20.383 119.318  12.162  1.00 19.27           O  
ATOM    319  N   LYS    52     -22.337 120.078  13.063  1.00 19.59           N  
ATOM    320  CA  LYS    52     -22.065 121.478  12.820  1.00 20.04           C  
ATOM    322  CB  LYS    52     -23.329 122.341  12.836  1.00 20.46           C  
ATOM    325  CG  LYS    52     -24.164 122.187  11.572  1.00 20.43           C  
ATOM    328  CD  LYS    52     -25.365 123.122  11.559  1.00 22.83           C  
ATOM    331  CE  LYS    52     -26.699 122.394  11.494  1.00 24.90           C  
ATOM    334  NZ  LYS    52     -27.829 123.330  11.277  1.00 24.95           N  
ATOM    338  C   LYS    52     -21.061 121.966  13.827  1.00 20.04           C  
ATOM    339  O   LYS    52     -20.398 122.970  13.602  1.00 20.00           O  
ATOM    341  N   LYS    53     -20.927 121.200  14.900  1.00 20.27           N  
ATOM    342  CA  LYS    53     -19.956 121.445  15.930  1.00 20.34           C  
ATOM    344  CB  LYS    53     -20.682 121.670  17.246  1.00 20.68           C  
ATOM    347  CG  LYS    53     -21.847 122.692  17.095  1.00 23.09           C  
ATOM    350  CD  LYS    53     -21.521 124.116  17.491  1.00 27.62           C  
ATOM    353  CE  LYS    53     -21.409 124.209  19.100  1.00 32.41           C  
ATOM    356  NZ  LYS    53     -22.460 123.426  19.934  1.00 31.15           N  
ATOM    360  C   LYS    53     -18.986 120.294  15.993  1.00 19.39           C  
ATOM    361  O   LYS    53     -18.420 120.077  17.023  1.00 18.49           O  
ATOM    363  N   ARG    54     -18.802 119.602  14.853  1.00 19.24           N  
ATOM    364  CA  ARG    54     -17.947 118.407  14.688  1.00 19.47           C  
ATOM    366  CB  ARG    54     -16.491 118.814  14.543  1.00 20.32           C  
ATOM    369  CG  ARG    54     -16.186 119.822  13.489  1.00 20.47           C  
ATOM    372  CD  ARG    54     -14.698 120.096  13.553  1.00 24.75           C  
ATOM    375  NE  ARG    54     -14.290 121.251  12.769  1.00 28.96           N  
ATOM    380  C   ARG    54     -18.064 117.358  15.813  1.00 19.60           C  
ATOM    381  O   ARG    54     -17.084 116.759  16.256  1.00 16.42           O  
ATOM    383  N   ASN    55     -19.290 117.172  16.282  1.00 19.25           N  
ATOM    384  CA  ASN    55     -19.541 116.166  17.282  1.00 18.54           C  
ATOM    386  CB  ASN    55     -19.436 114.785  16.625  1.00 18.50           C  
ATOM    389  CG  ASN    55     -20.554 114.554  15.636  1.00 17.41           C  
ATOM    390  OD1 ASN    55     -21.626 115.015  15.879  1.00 16.53           O  
ATOM    391  ND2 ASN    55     -20.289 113.919  14.511  1.00 15.60           N  
ATOM    394  C   ASN    55     -18.686 116.324  18.525  1.00 17.75           C  
ATOM    395  O   ASN    55     -18.268 115.349  19.146  1.00 16.70           O  
ATOM    397  N   THR    56     -18.423 117.568  18.899  0.50 17.45           N  
ATOM    399  CA  THR    56     -17.523 117.808  20.015  0.50 17.17           C  
ATOM    403  CB  THR    56     -17.134 119.322  20.215  0.50 16.76           C  
ATOM    407  OG1 THR    56     -18.308 120.136  20.261  0.50 15.81           O  
ATOM    411  CG2 THR    56     -16.202 119.812  19.093  0.50 16.14           C  
ATOM    419  C   THR    56     -18.163 117.235  21.281  0.50 17.32           C  
ATOM    421  O   THR    56     -19.389 117.253  21.438  0.50 16.51           O  
ATOM    425  N   LEU    57     -17.299 116.734  22.157  1.00 16.32           N  
ATOM    426  CA  LEU    57     -17.669 116.055  23.328  1.00 17.23           C  
ATOM    428  CB  LEU    57     -16.656 114.936  23.660  1.00 17.89           C  
ATOM    431  CG  LEU    57     -16.646 113.795  22.618  1.00 21.28           C  
ATOM    433  CD1 LEU    57     -15.502 112.788  22.902  1.00 18.00           C  
ATOM    437  CD2 LEU    57     -18.119 113.109  22.438  1.00 18.16           C  
ATOM    441  C   LEU    57     -17.801 117.054  24.455  1.00 16.91           C  
ATOM    442  O   LEU    57     -17.015 117.112  25.387  1.00 15.44           O  
ATOM    444  N   SER    58     -18.876 117.811  24.369  1.00 17.04           N  
ATOM    445  CA  SER    58     -19.218 118.780  25.376  1.00 17.02           C  
ATOM    447  CB  SER    58     -20.214 119.781  24.830  1.00 17.07           C  
ATOM    450  OG  SER    58     -21.405 119.120  24.399  1.00 18.63           O  
ATOM    452  C   SER    58     -19.837 118.015  26.481  1.00 17.85           C  
ATOM    453  O   SER    58     -20.266 116.837  26.284  1.00 19.18           O  
ATOM    455  N   LEU    59     -19.940 118.672  27.640  1.00 18.08           N  
ATOM    456  CA  LEU    59     -20.596 118.079  28.772  1.00 18.91           C  
ATOM    458  CB  LEU    59     -20.722 119.060  29.922  1.00 18.31           C  
ATOM    461  CG  LEU    59     -21.104 118.375  31.206  1.00 19.05           C  
ATOM    463  CD1 LEU    59     -20.058 117.332  31.631  1.00 13.20           C  
ATOM    467  CD2 LEU    59     -21.366 119.435  32.315  1.00 18.29           C  
ATOM    471  C   LEU    59     -21.975 117.511  28.356  1.00 19.34           C  
ATOM    472  O   LEU    59     -22.280 116.379  28.709  1.00 21.50           O  
ATOM    474  N   ALA    60     -22.751 118.247  27.558  1.00 19.33           N  
ATOM    475  CA  ALA    60     -24.113 117.845  27.145  1.00 19.25           C  
ATOM    477  CB  ALA    60     -24.852 119.063  26.474  1.00 17.30           C  
ATOM    481  C   ALA    60     -24.128 116.608  26.197  1.00 19.56           C  
ATOM    482  O   ALA    60     -24.965 115.726  26.338  1.00 20.09           O  
ATOM    484  N   MET    61     -23.207 116.582  25.220  1.00 20.39           N  
ATOM    485  CA  MET    61     -22.937 115.400  24.392  1.00 20.42           C  
ATOM    487  CB  MET    61     -21.851 115.762  23.403  1.00 20.30           C  
ATOM    490  CG  MET    61     -21.441 114.639  22.523  1.00 21.87           C  
ATOM    493  SD  MET    61     -22.682 114.165  21.333  1.00 17.95           S  
ATOM    494  CE  MET    61     -22.252 115.145  19.892  1.00 25.26           C  
ATOM    498  C   MET    61     -22.492 114.161  25.207  1.00 20.67           C  
ATOM    499  O   MET    61     -23.010 113.080  25.036  1.00 21.86           O  
ATOM    501  N   LEU    62     -21.560 114.336  26.128  1.00 19.50           N  
ATOM    502  CA  LEU    62     -21.183 113.264  27.017  1.00 19.05           C  
ATOM    504  CB  LEU    62     -20.032 113.730  27.953  1.00 18.43           C  
ATOM    507  CG  LEU    62     -18.673 113.886  27.303  1.00 16.64           C  
ATOM    509  CD1 LEU    62     -17.752 114.841  28.082  1.00 13.44           C  
ATOM    513  CD2 LEU    62     -18.074 112.458  27.050  1.00 10.71           C  
ATOM    517  C   LEU    62     -22.349 112.696  27.880  1.00 19.89           C  
ATOM    518  O   LEU    62     -22.421 111.472  28.107  1.00 20.69           O  
ATOM    520  N   LYS    63     -23.256 113.540  28.344  1.00 18.86           N  
ATOM    521  CA  LYS    63     -24.368 113.067  29.174  1.00 18.70           C  
ATOM    523  CB  LYS    63     -24.967 114.220  29.983  1.00 19.18           C  
ATOM    526  CG  LYS    63     -23.947 114.768  31.011  1.00 21.85           C  
ATOM    529  CD  LYS    63     -24.591 115.794  31.978  1.00 26.45           C  
ATOM    532  CE  LYS    63     -24.705 117.236  31.381  1.00 28.19           C  
ATOM    535  NZ  LYS    63     -24.745 118.338  32.430  1.00 27.09           N  
ATOM    539  C   LYS    63     -25.449 112.378  28.380  1.00 18.16           C  
ATOM    540  O   LYS    63     -26.060 111.407  28.863  1.00 14.99           O  
ATOM    542  N   SER    64     -25.679 112.890  27.169  1.00 18.16           N  
ATOM    543  CA  SER    64     -26.622 112.285  26.231  1.00 18.71           C  
ATOM    545  CB  SER    64     -26.765 113.206  24.997  1.00 18.48           C  
ATOM    548  OG  SER    64     -27.687 112.789  24.019  1.00 18.11           O  
ATOM    550  C   SER    64     -26.080 110.903  25.867  1.00 19.90           C  
ATOM    551  O   SER    64     -26.825 109.916  25.838  1.00 19.94           O  
ATOM    553  N   LEU    65     -24.766 110.841  25.586  1.00 20.77           N  
ATOM    554  CA  LEU    65     -24.115 109.603  25.140  1.00 20.75           C  
ATOM    556  CB  LEU    65     -22.684 109.865  24.635  1.00 20.13           C  
ATOM    559  CG  LEU    65     -21.825 108.617  24.301  1.00 20.27           C  
ATOM    561  CD1 LEU    65     -22.510 107.847  23.202  1.00 21.28           C  
ATOM    565  CD2 LEU    65     -20.409 109.031  23.868  1.00 19.72           C  
ATOM    569  C   LEU    65     -24.167 108.553  26.251  1.00 20.12           C  
ATOM    570  O   LEU    65     -24.622 107.439  26.031  1.00 20.44           O  
ATOM    572  N   GLN    66     -23.744 108.962  27.445  1.00 20.60           N  
ATOM    573  CA  GLN    66     -23.862 108.189  28.670  1.00 19.61           C  
ATOM    575  CB  GLN    66     -23.515 109.049  29.870  1.00 20.10           C  
ATOM    578  CG  GLN    66     -23.577 108.308  31.264  1.00 20.81           C  
ATOM    581  CD  GLN    66     -22.884 109.093  32.336  1.00 23.04           C  
ATOM    582  OE1 GLN    66     -21.735 108.798  32.653  1.00 29.45           O  
ATOM    583  NE2 GLN    66     -23.513 110.164  32.820  1.00 22.57           N  
ATOM    586  C   GLN    66     -25.235 107.644  28.881  1.00 20.02           C  
ATOM    587  O   GLN    66     -25.390 106.570  29.439  1.00 20.66           O  
ATOM    589  N   SER    67     -26.251 108.388  28.477  1.00 20.55           N  
ATOM    590  CA  SER    67     -27.633 108.053  28.778  1.00 19.80           C  
ATOM    592  CB  SER    67     -28.495 109.304  28.623  1.00 20.36           C  
ATOM    595  OG  SER    67     -29.550 109.291  29.502  1.00 22.20           O  
ATOM    597  C   SER    67     -28.104 106.978  27.819  1.00 19.85           C  
ATOM    598  O   SER    67     -28.780 106.002  28.204  1.00 19.35           O  
ATOM    600  N   ASP    68     -27.755 107.173  26.552  1.00 19.94           N  
ATOM    601  CA  ASP    68     -28.086 106.210  25.516  1.00 19.79           C  
ATOM    603  CB  ASP    68     -27.629 106.746  24.158  1.00 20.43           C  
ATOM    606  CG  ASP    68     -28.456 107.942  23.658  1.00 23.76           C  
ATOM    607  OD1 ASP    68     -29.557 108.215  24.195  1.00 23.98           O  
ATOM    608  OD2 ASP    68     -27.973 108.619  22.722  1.00 28.92           O  
ATOM    609  C   ASP    68     -27.404 104.851  25.801  1.00 19.43           C  
ATOM    610  O   ASP    68     -27.954 103.843  25.545  1.00 18.46           O  
ATOM    612  N   ILE    69     -26.173 104.862  26.312  1.00 19.12           N  
ATOM    613  CA  ILE    69     -25.446 103.638  26.632  1.00 18.47           C  
ATOM    615  CB  ILE    69     -23.958 103.948  26.929  1.00 18.25           C  
ATOM    617  CG1 ILE    69     -23.242 104.395  25.637  1.00 19.17           C  
ATOM    620  CD1 ILE    69     -21.812 104.999  25.889  1.00 15.75           C  
ATOM    624  CG2 ILE    69     -23.235 102.721  27.440  1.00 15.24           C  
ATOM    628  C   ILE    69     -26.089 102.850  27.785  1.00 18.01           C  
ATOM    629  O   ILE    69     -26.329 101.659  27.651  1.00 16.70           O  
ATOM    631  N   LEU    70     -26.426 103.562  28.858  1.00 18.44           N  
ATOM    632  CA  LEU    70     -26.958 102.993  30.087  1.00 18.51           C  
ATOM    634  CB  LEU    70     -26.781 104.008  31.221  1.00 18.02           C  
ATOM    637  CG  LEU    70     -25.282 104.191  31.605  1.00 17.56           C  
ATOM    639  CD1 LEU    70     -25.172 105.045  32.861  1.00 17.10           C  
ATOM    643  CD2 LEU    70     -24.507 102.850  31.759  1.00 16.31           C  
ATOM    647  C   LEU    70     -28.402 102.570  30.034  1.00 18.99           C  
ATOM    648  O   LEU    70     -28.889 101.779  30.891  1.00 19.34           O  
ATOM    650  N   HIS    71     -29.119 103.103  29.061  1.00 19.25           N  
ATOM    651  CA  HIS    71     -30.548 102.931  29.018  1.00 19.59           C  
ATOM    653  CB  HIS    71     -31.131 103.739  27.866  1.00 19.71           C  
ATOM    656  CG  HIS    71     -32.594 103.546  27.715  1.00 19.32           C  
ATOM    657  ND1 HIS    71     -33.145 102.695  26.782  1.00 19.54           N  
ATOM    659  CE1 HIS    71     -34.464 102.709  26.910  1.00 20.43           C  
ATOM    661  NE2 HIS    71     -34.779 103.515  27.909  1.00 19.47           N  
ATOM    663  CD2 HIS    71     -33.628 104.049  28.430  1.00 20.71           C  
ATOM    665  C   HIS    71     -30.896 101.469  28.799  1.00 20.07           C  
ATOM    666  O   HIS    71     -30.428 100.917  27.828  1.00 18.82           O  
ATOM    668  N   ASP    72     -31.700 100.854  29.682  1.00 21.27           N  
ATOM    669  CA  ASP    72     -32.105  99.434  29.518  1.00 22.29           C  
ATOM    671  CB  ASP    72     -32.970  99.278  28.269  1.00 23.59           C  
ATOM    674  CG  ASP    72     -34.388  99.232  28.573  1.00 25.09           C  
ATOM    675  OD1 ASP    72     -34.945 100.303  28.881  1.00 30.24           O  
ATOM    676  OD2 ASP    72     -34.935  98.108  28.543  1.00 29.83           O  
ATOM    677  C   ASP    72     -30.928  98.486  29.323  1.00 22.15           C  
ATOM    678  O   ASP    72     -31.034  97.497  28.625  1.00 23.16           O  
ATOM    680  N   ALA    73     -29.809  98.782  29.945  1.00 21.79           N  
ATOM    681  CA  ALA    73     -28.591  98.081  29.685  1.00 21.44           C  
ATOM    683  CB  ALA    73     -27.431  98.783  30.436  1.00 20.97           C  
ATOM    687  C   ALA    73     -28.700  96.590  30.095  1.00 21.85           C  
ATOM    688  O   ALA    73     -27.919  95.788  29.623  1.00 20.76           O  
ATOM    690  N   ASP    74     -29.630  96.237  30.997  1.00 22.22           N  
ATOM    691  CA  ASP    74     -29.750  94.857  31.470  1.00 23.54           C  
ATOM    693  CB  ASP    74     -29.886  94.810  32.985  1.00 23.82           C  
ATOM    696  CG  ASP    74     -28.784  95.618  33.696  1.00 28.77           C  
ATOM    697  OD1 ASP    74     -29.186  96.333  34.670  1.00 34.27           O  
ATOM    698  OD2 ASP    74     -27.556  95.561  33.294  1.00 29.12           O  
ATOM    699  C   ASP    74     -30.896  94.104  30.793  1.00 23.04           C  
ATOM    700  O   ASP    74     -31.244  92.988  31.192  1.00 22.85           O  
ATOM    702  N   SER    75     -31.474  94.734  29.777  1.00 22.85           N  
ATOM    703  CA  SER    75     -32.544  94.139  29.053  1.00 22.91           C  
ATOM    705  CB  SER    75     -33.246  95.169  28.172  1.00 23.24           C  
ATOM    708  OG  SER    75     -34.064  94.523  27.198  1.00 22.89           O  
ATOM    710  C   SER    75     -31.965  93.071  28.176  1.00 22.93           C  
ATOM    711  O   SER    75     -30.951  93.307  27.505  1.00 22.07           O  
ATOM    713  N   ASN    76     -32.664  91.933  28.118  1.00 22.63           N  
ATOM    714  CA  ASN    76     -32.244  90.843  27.259  1.00 22.95           C  
ATOM    716  CB  ASN    76     -32.966  89.545  27.612  1.00 24.11           C  
ATOM    719  CG  ASN    76     -32.336  88.850  28.783  1.00 26.98           C  
ATOM    720  OD1 ASN    76     -31.113  88.563  28.782  1.00 33.45           O  
ATOM    721  ND2 ASN    76     -33.158  88.541  29.789  1.00 30.14           N  
ATOM    724  C   ASN    76     -32.413  91.104  25.793  1.00 21.54           C  
ATOM    725  O   ASN    76     -31.859  90.375  25.007  1.00 21.30           O  
ATOM    727  N   ASP    77     -33.184  92.111  25.418  1.00 20.44           N  
ATOM    728  CA  ASP    77     -33.321  92.434  24.029  1.00 20.82           C  
ATOM    730  CB  ASP    77     -34.588  93.263  23.761  1.00 21.94           C  
ATOM    733  CG  ASP    77     -35.898  92.516  24.107  1.00 26.35           C  
ATOM    734  OD1 ASP    77     -35.962  91.239  24.040  1.00 30.79           O  
ATOM    735  OD2 ASP    77     -36.896  93.238  24.439  1.00 32.58           O  
ATOM    736  C   ASP    77     -32.091  93.168  23.480  1.00 19.61           C  
ATOM    737  O   ASP    77     -31.919  93.204  22.283  1.00 19.66           O  
ATOM    739  N   LEU    78     -31.251  93.749  24.344  1.00 18.80           N  
ATOM    740  CA  LEU    78     -30.023  94.404  23.932  1.00 17.27           C  
ATOM    742  CB  LEU    78     -29.623  95.472  24.947  1.00 16.54           C  
ATOM    745  CG  LEU    78     -28.321  96.230  24.692  1.00 13.70           C  
ATOM    747  CD1 LEU    78     -28.422  97.110  23.477  1.00  8.97           C  
ATOM    751  CD2 LEU    78     -27.875  97.031  25.932  1.00 13.55           C  
ATOM    755  C   LEU    78     -28.910  93.397  23.812  1.00 17.24           C  
ATOM    756  O   LEU    78     -28.530  92.762  24.795  1.00 17.67           O  
ATOM    758  N   LYS    79     -28.312  93.302  22.622  1.00 16.68           N  
ATOM    759  CA  LYS    79     -27.199  92.370  22.384  1.00 15.82           C  
ATOM    761  CB  LYS    79     -27.528  91.369  21.270  1.00 15.73           C  
ATOM    764  CG  LYS    79     -28.877  90.676  21.388  1.00 16.59           C  
ATOM    767  CD  LYS    79     -28.974  89.712  22.499  1.00 18.06           C  
ATOM    770  CE  LYS    79     -30.109  88.683  22.212  1.00 18.62           C  
ATOM    773  NZ  LYS    79     -31.314  89.066  22.909  1.00 17.95           N  
ATOM    777  C   LYS    79     -25.857  93.002  22.030  1.00 15.41           C  
ATOM    778  O   LYS    79     -24.845  92.355  22.179  1.00 15.62           O  
ATOM    780  N   VAL    80     -25.854  94.222  21.505  1.00 15.50           N  
ATOM    781  CA  VAL    80     -24.634  94.872  21.046  1.00 15.60           C  
ATOM    783  CB  VAL    80     -24.067  94.182  19.722  1.00 16.76           C  
ATOM    785  CG1 VAL    80     -25.070  94.308  18.564  1.00 13.79           C  
ATOM    789  CG2 VAL    80     -22.644  94.724  19.295  1.00 12.47           C  
ATOM    793  C   VAL    80     -24.910  96.353  20.822  1.00 16.02           C  
ATOM    794  O   VAL    80     -26.008  96.732  20.471  1.00 16.93           O  
ATOM    796  N   ILE    81     -23.877  97.178  20.990  1.00 16.52           N  
ATOM    797  CA  ILE    81     -23.916  98.629  20.694  1.00 15.56           C  
ATOM    799  CB  ILE    81     -23.690  99.507  21.943  1.00 15.15           C  
ATOM    801  CG1 ILE    81     -24.768  99.260  23.001  1.00 14.39           C  
ATOM    804  CD1 ILE    81     -24.524  99.793  24.350  1.00 11.87           C  
ATOM    808  CG2 ILE    81     -23.720 100.927  21.527  1.00 15.92           C  
ATOM    812  C   ILE    81     -22.909  99.028  19.600  1.00 15.42           C  
ATOM    813  O   ILE    81     -21.760  98.607  19.626  1.00 15.24           O  
ATOM    815  N   ILE    82     -23.363  99.853  18.649  1.00 14.63           N  
ATOM    816  CA  ILE    82     -22.498 100.522  17.680  1.00 14.36           C  
ATOM    818  CB  ILE    82     -22.980 100.304  16.200  1.00 15.79           C  
ATOM    820  CG1 ILE    82     -23.053  98.806  15.843  1.00 15.81           C  
ATOM    823  CD1 ILE    82     -23.912  98.475  14.628  1.00 16.96           C  
ATOM    827  CG2 ILE    82     -22.056 101.060  15.234  1.00 14.37           C  
ATOM    831  C   ILE    82     -22.516 102.016  17.977  1.00 14.01           C  
ATOM    832  O   ILE    82     -23.555 102.590  18.029  1.00 12.00           O  
ATOM    834  N   ILE    83     -21.361 102.641  18.257  1.00 15.53           N  
ATOM    835  CA  ILE    83     -21.295 104.105  18.325  1.00 15.80           C  
ATOM    837  CB  ILE    83     -20.506 104.634  19.502  1.00 17.01           C  
ATOM    839  CG1 ILE    83     -21.069 104.097  20.819  1.00 17.25           C  
ATOM    842  CD1 ILE    83     -20.076 104.162  22.048  1.00 18.56           C  
ATOM    846  CG2 ILE    83     -20.575 106.163  19.466  1.00 18.42           C  
ATOM    850  C   ILE    83     -20.693 104.607  17.020  1.00 16.12           C  
ATOM    851  O   ILE    83     -19.551 104.235  16.717  1.00 16.77           O  
ATOM    853  N   SER    84     -21.494 105.381  16.241  1.00 15.80           N  
ATOM    854  CA  SER    84     -21.076 106.080  15.032  1.00 16.15           C  
ATOM    856  CB  SER    84     -21.795 105.512  13.784  1.00 16.26           C  
ATOM    859  OG  SER    84     -23.117 105.324  14.014  1.00 13.91           O  
ATOM    861  C   SER    84     -21.340 107.580  15.115  1.00 16.70           C  
ATOM    862  O   SER    84     -21.732 108.078  16.160  1.00 13.67           O  
ATOM    864  N   ALA    85     -21.143 108.292  13.990  1.00 17.33           N  
ATOM    865  CA  ALA    85     -21.328 109.742  13.980  1.00 18.13           C  
ATOM    867  CB  ALA    85     -20.003 110.477  14.422  1.00 16.26           C  
ATOM    871  C   ALA    85     -21.818 110.265  12.627  1.00 18.58           C  
ATOM    872  O   ALA    85     -21.481 109.703  11.609  1.00 18.18           O  
ATOM    874  N   GLU    86     -22.588 111.367  12.663  1.00 19.55           N  
ATOM    875  CA  GLU    86     -23.096 112.098  11.481  1.00 20.31           C  
ATOM    877  CB  GLU    86     -24.170 113.112  11.933  1.00 21.00           C  
ATOM    880  CG  GLU    86     -25.599 113.067  11.409  1.00 23.95           C  
ATOM    883  CD  GLU    86     -26.391 114.364  11.807  1.00 28.72           C  
ATOM    884  OE1 GLU    86     -26.253 114.814  12.977  1.00 31.93           O  
ATOM    885  OE2 GLU    86     -27.118 114.972  10.952  1.00 31.70           O  
ATOM    886  C   GLU    86     -21.929 112.919  10.916  1.00 19.87           C  
ATOM    887  O   GLU    86     -21.230 113.606  11.651  1.00 18.05           O  
ATOM    889  N   GLY    87     -21.712 112.845   9.619  1.00 19.92           N  
ATOM    890  CA  GLY    87     -20.790 113.770   8.983  1.00 20.95           C  
ATOM    893  C   GLY    87     -19.335 113.339   9.028  1.00 21.41           C  
ATOM    894  O   GLY    87     -19.021 112.263   9.522  1.00 22.86           O  
ATOM    896  N   PRO    88     -18.435 114.181   8.506  1.00 21.29           N  
ATOM    897  CA  PRO    88     -17.064 113.774   8.110  1.00 20.91           C  
ATOM    899  CB  PRO    88     -16.718 114.801   7.035  1.00 20.21           C  
ATOM    902  CG  PRO    88     -17.484 116.017   7.442  1.00 20.92           C  
ATOM    905  CD  PRO    88     -18.780 115.518   7.976  1.00 20.77           C  
ATOM    908  C   PRO    88     -15.973 113.805   9.177  1.00 20.24           C  
ATOM    909  O   PRO    88     -14.824 113.450   8.903  1.00 19.80           O  
ATOM    910  N   VAL    89     -16.345 114.315  10.343  1.00 20.65           N  
ATOM    911  CA  VAL    89     -15.578 114.291  11.576  1.00 18.88           C  
ATOM    913  CB  VAL    89     -15.432 115.702  12.208  1.00 18.80           C  
ATOM    915  CG1 VAL    89     -14.743 115.625  13.537  1.00 16.50           C  
ATOM    919  CG2 VAL    89     -14.658 116.670  11.253  1.00 13.64           C  
ATOM    923  C   VAL    89     -16.376 113.390  12.498  1.00 20.43           C  
ATOM    924  O   VAL    89     -17.589 113.534  12.580  1.00 21.91           O  
ATOM    926  N   PHE    90     -15.695 112.468  13.184  1.00 19.72           N  
ATOM    927  CA  PHE    90     -16.301 111.531  14.041  1.00 19.43           C  
ATOM    929  CB  PHE    90     -15.414 110.245  14.121  1.00 19.48           C  
ATOM    932  CG  PHE    90     -15.877 109.287  15.158  1.00 20.01           C  
ATOM    933  CD1 PHE    90     -16.872 108.362  14.868  1.00 17.39           C  
ATOM    935  CE1 PHE    90     -17.370 107.504  15.841  1.00 18.93           C  
ATOM    937  CZ  PHE    90     -16.911 107.558  17.103  1.00 16.39           C  
ATOM    939  CE2 PHE    90     -15.896 108.507  17.428  1.00 18.94           C  
ATOM    941  CD2 PHE    90     -15.408 109.370  16.462  1.00 16.60           C  
ATOM    943  C   PHE    90     -16.550 112.239  15.403  1.00 21.11           C  
ATOM    944  O   PHE    90     -17.689 112.292  15.908  1.00 22.10           O  
ATOM    946  N   SER    91     -15.482 112.766  15.998  1.00 20.30           N  
ATOM    947  CA  SER    91     -15.576 113.800  17.007  1.00 20.57           C  
ATOM    949  CB  SER    91     -15.752 113.196  18.379  1.00 20.84           C  
ATOM    952  OG  SER    91     -15.846 114.234  19.320  1.00 22.57           O  
ATOM    954  C   SER    91     -14.248 114.511  17.033  1.00 21.11           C  
ATOM    955  O   SER    91     -13.221 113.881  16.841  1.00 21.08           O  
ATOM    957  N   SER    92     -14.277 115.783  17.401  1.00 21.15           N  
ATOM    958  CA  SER    92     -13.105 116.632  17.515  1.00 21.23           C  
ATOM    960  CB  SER    92     -13.489 118.059  17.139  1.00 20.94           C  
ATOM    963  OG  SER    92     -14.589 118.564  17.943  1.00 21.78           O  
ATOM    965  C   SER    92     -12.575 116.624  18.946  1.00 21.25           C  
ATOM    966  O   SER    92     -11.535 117.223  19.235  1.00 22.40           O  
ATOM    968  N   GLY    93     -13.301 115.985  19.841  1.00 20.58           N  
ATOM    969  CA  GLY    93     -12.948 115.936  21.260  1.00 19.95           C  
ATOM    972  C   GLY    93     -13.750 116.972  22.009  1.00 19.47           C  
ATOM    973  O   GLY    93     -14.794 117.442  21.566  1.00 20.34           O  
ATOM    975  N   HIS    94     -13.252 117.343  23.149  1.00 19.02           N  
ATOM    976  CA  HIS    94     -13.913 118.258  24.010  1.00 18.65           C  
ATOM    978  CB  HIS    94     -13.212 118.340  25.388  1.00 18.04           C  
ATOM    981  CG  HIS    94     -13.222 117.059  26.144  1.00 17.83           C  
ATOM    982  ND1 HIS    94     -14.362 116.316  26.320  1.00 19.55           N  
ATOM    984  CE1 HIS    94     -14.074 115.230  27.024  1.00 19.25           C  
ATOM    986  NE2 HIS    94     -12.801 115.280  27.377  1.00 19.12           N  
ATOM    988  CD2 HIS    94     -12.241 116.403  26.821  1.00 20.68           C  
ATOM    990  C   HIS    94     -13.972 119.647  23.426  1.00 18.42           C  
ATOM    991  O   HIS    94     -13.158 120.042  22.633  1.00 17.03           O  
ATOM    993  N   ASP    95     -15.017 120.360  23.847  1.00 19.61           N  
ATOM    994  CA  ASP    95     -15.202 121.784  23.545  1.00 19.31           C  
ATOM    996  CB  ASP    95     -16.648 122.164  23.827  1.00 19.16           C  
ATOM    999  CG  ASP    95     -17.011 123.572  23.311  1.00 21.32           C  
ATOM   1000  OD1 ASP    95     -16.166 124.344  22.761  1.00 22.64           O  
ATOM   1001  OD2 ASP    95     -18.190 123.904  23.461  1.00 24.08           O  
ATOM   1002  C   ASP    95     -14.290 122.653  24.378  1.00 18.37           C  
ATOM   1003  O   ASP    95     -14.398 122.688  25.598  1.00 18.35           O  
ATOM   1005  N   LEU    96     -13.401 123.378  23.732  1.00 18.38           N  
ATOM   1006  CA  LEU    96     -12.454 124.159  24.476  1.00 18.46           C  
ATOM   1008  CB  LEU    96     -11.342 124.659  23.572  1.00 18.82           C  
ATOM   1011  CG  LEU    96     -10.536 123.507  22.924  1.00 20.57           C  
ATOM   1013  CD1 LEU    96      -9.523 124.069  21.931  1.00 18.98           C  
ATOM   1017  CD2 LEU    96      -9.895 122.528  23.976  1.00 16.21           C  
ATOM   1021  C   LEU    96     -13.061 125.301  25.247  1.00 18.43           C  
ATOM   1022  O   LEU    96     -12.463 125.725  26.223  1.00 19.95           O  
ATOM   1024  N   LYS    97     -14.238 125.786  24.858  1.00 17.91           N  
ATOM   1025  CA  LYS    97     -14.921 126.857  25.603  1.00 18.00           C  
ATOM   1027  CB  LYS    97     -16.187 127.275  24.892  1.00 18.56           C  
ATOM   1030  CG  LYS    97     -15.959 127.874  23.482  1.00 19.92           C  
ATOM   1033  CD  LYS    97     -17.219 128.444  22.945  1.00 25.08           C  
ATOM   1036  CE  LYS    97     -17.489 127.989  21.508  1.00 27.41           C  
ATOM   1039  NZ  LYS    97     -17.434 126.508  21.314  1.00 24.52           N  
ATOM   1043  C   LYS    97     -15.276 126.479  27.029  1.00 18.48           C  
ATOM   1044  O   LYS    97     -15.389 127.335  27.890  1.00 17.64           O  
ATOM   1046  N   GLU    98     -15.406 125.165  27.260  1.00 19.13           N  
ATOM   1047  CA  GLU    98     -15.696 124.570  28.531  1.00 18.89           C  
ATOM   1049  CB  GLU    98     -16.448 123.268  28.308  1.00 20.08           C  
ATOM   1052  CG  GLU    98     -17.862 123.418  27.722  1.00 20.54           C  
ATOM   1055  CD  GLU    98     -18.743 122.139  27.922  1.00 21.91           C  
ATOM   1056  OE1 GLU    98     -18.271 121.035  27.670  1.00 21.23           O  
ATOM   1057  OE2 GLU    98     -19.924 122.226  28.330  1.00 28.69           O  
ATOM   1059  O   GLU    98     -14.760 124.443  30.541  1.00 10.39           O  
ATOM   1061  N   LEU    99     -13.540 124.717  29.023  1.00 13.44           N  
ATOM   1062  CA  LEU    99     -12.160 124.599  29.448  1.00 14.57           C  
ATOM   1064  CB  LEU    99     -11.425 123.586  28.556  1.00 13.88           C  
ATOM   1067  CG  LEU    99     -12.151 122.212  28.425  1.00 14.81           C  
ATOM   1069  CD1 LEU    99     -11.306 121.277  27.604  1.00 11.91           C  
ATOM   1073  CD2 LEU    99     -12.636 121.513  29.804  1.00 11.10           C  
ATOM   1077  C   LEU    99     -11.334 125.898  29.709  1.00 14.60           C  
ATOM   1078  O   LEU    99     -10.171 125.850  30.155  1.00 15.08           O  
ATOM   1080  N   THR   100     -11.960 127.042  29.512  1.00 14.98           N  
ATOM   1081  CA  THR   100     -11.367 128.347  29.722  1.00 14.61           C  
ATOM   1083  CB  THR   100     -12.111 129.442  28.938  1.00 14.62           C  
ATOM   1085  OG1 THR   100     -13.460 129.486  29.403  1.00 16.09           O  
ATOM   1087  CG2 THR   100     -12.108 129.222  27.413  1.00 12.66           C  
ATOM   1091  C   THR   100     -11.446 128.616  31.225  1.00 15.75           C  
ATOM   1092  O   THR   100     -12.296 128.057  31.918  1.00 15.40           O  
ATOM   1094  N   GLU   101     -10.519 129.422  31.723  1.00 16.75           N  
ATOM   1095  CA  GLU   101     -10.300 129.624  33.158  1.00 18.54           C  
ATOM   1097  CB  GLU   101      -9.309 130.784  33.353  1.00 18.95           C  
ATOM   1100  CG  GLU   101      -9.001 131.077  34.834  1.00 22.65           C  
ATOM   1103  CD  GLU   101      -8.032 132.231  35.060  1.00 29.16           C  
ATOM   1104  OE1 GLU   101      -7.267 132.606  34.119  1.00 32.26           O  
ATOM   1105  OE2 GLU   101      -8.025 132.771  36.207  1.00 34.97           O  
ATOM   1106  C   GLU   101     -11.574 129.957  33.914  1.00 18.85           C  
ATOM   1107  O   GLU   101     -11.785 129.513  35.024  1.00 19.24           O  
ATOM   1109  N   GLU   102     -12.376 130.809  33.295  1.00 19.48           N  
ATOM   1110  CA  GLU   102     -13.613 131.343  33.814  1.00 20.28           C  
ATOM   1112  CB  GLU   102     -14.160 132.354  32.785  1.00 21.28           C  
ATOM   1115  CG  GLU   102     -14.209 131.851  31.283  1.00 24.17           C  
ATOM   1118  CD  GLU   102     -13.063 132.402  30.307  1.00 29.37           C  
ATOM   1119  OE1 GLU   102     -11.828 132.567  30.753  1.00 25.64           O  
ATOM   1120  OE2 GLU   102     -13.436 132.634  29.075  1.00 28.75           O  
ATOM   1121  C   GLU   102     -14.688 130.295  34.206  1.00 20.36           C  
ATOM   1122  O   GLU   102     -15.533 130.559  35.055  1.00 20.79           O  
ATOM   1124  N   GLN   103     -14.620 129.103  33.632  1.00 19.97           N  
ATOM   1125  CA  GLN   103     -15.564 128.054  33.929  1.00 19.27           C  
ATOM   1127  CB  GLN   103     -15.493 126.951  32.879  1.00 18.37           C  
ATOM   1130  CG  GLN   103     -15.787 127.389  31.400  1.00 17.59           C  
ATOM   1133  CD  GLN   103     -17.184 127.918  31.150  1.00 15.51           C  
ATOM   1134  OE1 GLN   103     -17.995 128.061  32.091  1.00 11.69           O  
ATOM   1135  NE2 GLN   103     -17.483 128.225  29.851  1.00 10.46           N  
ATOM   1138  C   GLN   103     -15.307 127.493  35.302  1.00 18.92           C  
ATOM   1139  O   GLN   103     -16.216 126.940  35.921  1.00 19.77           O  
ATOM   1141  N   GLY   104     -14.085 127.649  35.783  1.00 18.10           N  
ATOM   1142  CA  GLY   104     -13.692 127.120  37.064  1.00 17.66           C  
ATOM   1145  C   GLY   104     -13.260 125.673  36.935  1.00 17.90           C  
ATOM   1146  O   GLY   104     -13.673 124.953  36.033  1.00 18.12           O  
ATOM   1148  N   ARG   105     -12.419 125.268  37.862  1.00 17.60           N  
ATOM   1149  CA  ARG   105     -11.850 123.943  37.905  1.00 18.31           C  
ATOM   1151  CB  ARG   105     -10.785 123.846  39.046  1.00 18.56           C  
ATOM   1154  CG  ARG   105      -9.597 124.622  38.911  1.00 18.52           C  
ATOM   1157  CD  ARG   105      -8.680 124.452  40.161  1.00 20.52           C  
ATOM   1160  NE  ARG   105      -8.054 123.166  40.123  1.00 18.48           N  
ATOM   1162  CZ  ARG   105      -6.790 122.867  39.821  1.00 13.75           C  
ATOM   1163  NH1 ARG   105      -5.866 123.743  39.483  1.00 11.33           N  
ATOM   1166  NH2 ARG   105      -6.464 121.606  39.843  1.00 12.71           N  
ATOM   1169  C   ARG   105     -12.866 122.841  38.195  1.00 17.38           C  
ATOM   1170  O   ARG   105     -12.644 121.738  37.811  1.00 17.17           O  
ATOM   1172  N   ASP   106     -13.894 123.121  38.980  1.00 16.80           N  
ATOM   1173  CA  ASP   106     -14.987 122.176  39.203  1.00 18.17           C  
ATOM   1175  CB  ASP   106     -16.037 122.801  40.117  1.00 19.03           C  
ATOM   1178  CG  ASP   106     -15.648 122.794  41.617  1.00 20.77           C  
ATOM   1179  OD1 ASP   106     -14.523 122.405  41.987  1.00 21.59           O  
ATOM   1180  OD2 ASP   106     -16.528 123.183  42.427  1.00 26.31           O  
ATOM   1181  C   ASP   106     -15.662 121.754  37.891  1.00 17.79           C  
ATOM   1182  O   ASP   106     -15.933 120.560  37.654  1.00 18.16           O  
ATOM   1184  N   TYR   107     -15.946 122.741  37.052  1.00 17.38           N  
ATOM   1185  CA  TYR   107     -16.546 122.486  35.733  1.00 17.07           C  
ATOM   1187  CB  TYR   107     -16.974 123.803  35.059  1.00 16.22           C  
ATOM   1190  CG  TYR   107     -17.938 123.593  33.901  1.00 17.26           C  
ATOM   1191  CD1 TYR   107     -19.301 123.391  34.120  1.00 18.97           C  
ATOM   1193  CE1 TYR   107     -20.171 123.222  33.089  1.00 16.44           C  
ATOM   1195  CZ  TYR   107     -19.689 123.179  31.795  1.00 16.92           C  
ATOM   1196  OH  TYR   107     -20.553 123.019  30.702  1.00 19.19           O  
ATOM   1198  CE2 TYR   107     -18.369 123.359  31.567  1.00 16.10           C  
ATOM   1200  CD2 TYR   107     -17.500 123.582  32.593  1.00 14.19           C  
ATOM   1202  C   TYR   107     -15.582 121.705  34.854  1.00 16.43           C  
ATOM   1203  O   TYR   107     -15.959 120.768  34.215  1.00 15.44           O  
ATOM   1205  N   HIS   108     -14.322 122.108  34.838  1.00 16.53           N  
ATOM   1206  CA  HIS   108     -13.307 121.377  34.111  1.00 15.88           C  
ATOM   1208  CB  HIS   108     -11.916 121.949  34.329  1.00 16.59           C  
ATOM   1211  CG  HIS   108     -11.718 123.383  33.917  1.00 16.50           C  
ATOM   1212  ND1 HIS   108     -10.588 124.083  34.293  1.00 15.51           N  
ATOM   1214  CE1 HIS   108     -10.637 125.301  33.769  1.00 16.01           C  
ATOM   1216  NE2 HIS   108     -11.757 125.417  33.086  1.00 15.37           N  
ATOM   1218  CD2 HIS   108     -12.459 124.234  33.166  1.00 16.00           C  
ATOM   1220  C   HIS   108     -13.235 119.921  34.646  1.00 15.19           C  
ATOM   1221  O   HIS   108     -13.155 118.995  33.914  1.00 14.28           O  
ATOM   1223  N   ALA   109     -13.224 119.734  35.940  1.00 15.65           N  
ATOM   1224  CA  ALA   109     -13.156 118.385  36.471  1.00 16.05           C  
ATOM   1226  CB  ALA   109     -12.982 118.414  37.948  1.00 15.64           C  
ATOM   1230  C   ALA   109     -14.389 117.577  36.057  1.00 16.76           C  
ATOM   1231  O   ALA   109     -14.296 116.376  35.833  1.00 16.84           O  
ATOM   1233  N   GLU   110     -15.530 118.244  35.907  1.00 18.11           N  
ATOM   1234  CA  GLU   110     -16.763 117.601  35.509  1.00 19.64           C  
ATOM   1236  CB  GLU   110     -17.944 118.562  35.725  1.00 20.98           C  
ATOM   1239  CG  GLU   110     -19.263 117.914  35.603  1.00 24.86           C  
ATOM   1242  CD  GLU   110     -20.462 118.763  36.071  1.00 31.30           C  
ATOM   1243  OE1 GLU   110     -20.310 119.940  36.553  1.00 33.93           O  
ATOM   1244  OE2 GLU   110     -21.590 118.225  35.910  1.00 33.70           O  
ATOM   1245  C   GLU   110     -16.703 117.087  34.095  1.00 19.32           C  
ATOM   1246  O   GLU   110     -17.168 116.035  33.832  1.00 19.73           O  
ATOM   1248  N   VAL   111     -16.090 117.823  33.180  1.00 19.93           N  
ATOM   1249  CA  VAL   111     -16.036 117.395  31.781  1.00 19.74           C  
ATOM   1251  CB  VAL   111     -15.417 118.506  30.864  1.00 18.83           C  
ATOM   1253  CG1 VAL   111     -15.077 117.966  29.594  1.00 17.21           C  
ATOM   1257  CG2 VAL   111     -16.404 119.747  30.729  1.00 18.98           C  
ATOM   1261  C   VAL   111     -15.230 116.100  31.695  1.00 19.31           C  
ATOM   1262  O   VAL   111     -15.681 115.136  31.122  1.00 19.55           O  
ATOM   1264  N   PHE   112     -14.048 116.102  32.277  1.00 19.15           N  
ATOM   1265  CA  PHE   112     -13.133 114.989  32.241  1.00 18.93           C  
ATOM   1267  CB  PHE   112     -11.763 115.437  32.754  1.00 19.07           C  
ATOM   1270  CG  PHE   112     -11.146 116.497  31.920  1.00 19.16           C  
ATOM   1271  CD1 PHE   112     -10.959 116.293  30.542  1.00 17.43           C  
ATOM   1273  CE1 PHE   112     -10.449 117.314  29.729  1.00 11.85           C  
ATOM   1275  CZ  PHE   112     -10.076 118.473  30.281  1.00 14.99           C  
ATOM   1277  CE2 PHE   112     -10.200 118.670  31.681  1.00 17.71           C  
ATOM   1279  CD2 PHE   112     -10.742 117.696  32.482  1.00 15.39           C  
ATOM   1281  C   PHE   112     -13.571 113.807  33.093  1.00 19.61           C  
ATOM   1282  O   PHE   112     -13.400 112.701  32.662  1.00 19.84           O  
ATOM   1284  N   GLN   113     -14.038 114.020  34.333  1.00 19.47           N  
ATOM   1285  CA  GLN   113     -14.712 112.919  35.058  1.00 20.19           C  
ATOM   1287  CB  GLN   113     -15.147 113.356  36.462  1.00 21.12           C  
ATOM   1290  CG  GLN   113     -13.895 113.637  37.417  1.00 24.34           C  
ATOM   1293  CD  GLN   113     -14.303 114.291  38.712  1.00 28.02           C  
ATOM   1294  OE1 GLN   113     -15.481 114.613  38.900  1.00 34.19           O  
ATOM   1295  NE2 GLN   113     -13.346 114.493  39.629  1.00 29.41           N  
ATOM   1298  C   GLN   113     -15.908 112.231  34.303  1.00 20.00           C  
ATOM   1299  O   GLN   113     -16.072 111.020  34.374  1.00 19.33           O  
ATOM   1301  N   THR   114     -16.704 112.989  33.569  1.00 19.93           N  
ATOM   1302  CA  THR   114     -17.845 112.436  32.832  1.00 18.45           C  
ATOM   1304  CB  THR   114     -18.870 113.557  32.392  1.00 18.41           C  
ATOM   1306  OG1 THR   114     -19.130 114.379  33.508  1.00 19.14           O  
ATOM   1308  CG2 THR   114     -20.240 112.995  31.904  1.00 15.13           C  
ATOM   1312  C   THR   114     -17.408 111.680  31.629  1.00 18.45           C  
ATOM   1313  O   THR   114     -18.021 110.672  31.235  1.00 18.46           O  
ATOM   1315  N   CYS   115     -16.405 112.205  30.969  1.00 17.05           N  
ATOM   1316  CA  CYS   115     -15.829 111.473  29.904  1.00 17.54           C  
ATOM   1318  CB  CYS   115     -14.759 112.350  29.292  1.00 18.42           C  
ATOM   1321  SG  CYS   115     -14.293 111.722  27.701  1.00 19.64           S  
ATOM   1323  C   CYS   115     -15.216 110.103  30.355  1.00 17.36           C  
ATOM   1324  O   CYS   115     -15.361 109.073  29.671  1.00 17.12           O  
ATOM   1326  N   SER   116     -14.533 110.100  31.516  1.00 16.47           N  
ATOM   1327  CA  SER   116     -13.910 108.902  32.049  1.00 16.74           C  
ATOM   1329  CB  SER   116     -12.991 109.261  33.235  1.00 18.02           C  
ATOM   1332  OG  SER   116     -11.972 110.188  32.826  1.00 19.25           O  
ATOM   1334  C   SER   116     -14.951 107.854  32.442  1.00 17.27           C  
ATOM   1335  O   SER   116     -14.746 106.695  32.185  1.00 18.02           O  
ATOM   1337  N   LYS   117     -16.017 108.248  33.143  1.00 17.76           N  
ATOM   1338  CA  LYS   117     -17.198 107.433  33.391  1.00 17.73           C  
ATOM   1340  CB  LYS   117     -18.288 108.271  34.036  1.00 18.80           C  
ATOM   1343  CG  LYS   117     -18.214 108.465  35.557  1.00 22.09           C  
ATOM   1346  CD  LYS   117     -19.399 109.382  35.976  1.00 29.44           C  
ATOM   1349  CE  LYS   117     -20.799 108.670  35.829  1.00 35.03           C  
ATOM   1352  NZ  LYS   117     -21.979 109.160  36.673  1.00 35.49           N  
ATOM   1356  C   LYS   117     -17.806 106.832  32.099  1.00 16.56           C  
ATOM   1357  O   LYS   117     -18.183 105.702  32.117  1.00 16.05           O  
ATOM   1359  N   VAL   118     -17.909 107.594  31.018  1.00 15.45           N  
ATOM   1360  CA  VAL   118     -18.408 107.055  29.765  1.00 16.58           C  
ATOM   1362  CB  VAL   118     -18.569 108.102  28.639  1.00 17.05           C  
ATOM   1364  CG1 VAL   118     -18.796 107.399  27.267  1.00 16.04           C  
ATOM   1368  CG2 VAL   118     -19.803 109.032  28.946  1.00 16.61           C  
ATOM   1372  C   VAL   118     -17.544 105.907  29.283  1.00 17.33           C  
ATOM   1373  O   VAL   118     -18.050 104.859  28.958  1.00 17.93           O  
ATOM   1375  N   MET   119     -16.232 106.124  29.277  1.00 17.29           N  
ATOM   1376  CA  MET   119     -15.268 105.152  28.901  1.00 16.83           C  
ATOM   1378  CB  MET   119     -13.847 105.771  29.086  1.00 18.48           C  
ATOM   1381  CG  MET   119     -13.346 106.789  27.945  1.00 17.68           C  
ATOM   1384  SD  MET   119     -14.396 106.780  26.536  1.00 25.44           S  
ATOM   1385  CE  MET   119     -14.656 108.485  26.051  1.00 25.86           C  
ATOM   1389  C   MET   119     -15.384 103.882  29.725  1.00 17.68           C  
ATOM   1390  O   MET   119     -15.300 102.785  29.203  1.00 16.23           O  
ATOM   1392  N   MET   120     -15.530 104.054  31.038  1.00 17.82           N  
ATOM   1393  CA  MET   120     -15.646 102.962  31.953  1.00 17.90           C  
ATOM   1395  CB  MET   120     -15.541 103.449  33.405  1.00 18.49           C  
ATOM   1398  CG  MET   120     -14.183 103.992  33.856  1.00 20.43           C  
ATOM   1401  SD  MET   120     -12.763 102.963  33.490  1.00 27.50           S  
ATOM   1402  CE  MET   120     -13.154 101.506  34.487  1.00 23.80           C  
ATOM   1406  C   MET   120     -16.976 102.242  31.806  1.00 18.07           C  
ATOM   1407  O   MET   120     -17.056 101.074  32.114  1.00 18.76           O  
ATOM   1409  N   HIS   121     -18.020 102.936  31.379  1.00 18.02           N  
ATOM   1410  CA  HIS   121     -19.310 102.326  31.191  1.00 16.84           C  
ATOM   1412  CB  HIS   121     -20.401 103.380  30.986  1.00 16.90           C  
ATOM   1415  CG  HIS   121     -20.886 104.029  32.249  1.00 15.18           C  
ATOM   1416  ND1 HIS   121     -21.278 103.309  33.350  1.00 17.39           N  
ATOM   1418  CE1 HIS   121     -21.695 104.137  34.298  1.00 19.88           C  
ATOM   1420  NE2 HIS   121     -21.639 105.370  33.820  1.00 19.45           N  
ATOM   1422  CD2 HIS   121     -21.103 105.327  32.553  1.00 15.34           C  
ATOM   1424  C   HIS   121     -19.233 101.442  29.958  1.00 17.12           C  
ATOM   1425  O   HIS   121     -19.898 100.408  29.892  1.00 17.67           O  
ATOM   1427  N   ILE   122     -18.502 101.874  28.948  1.00 16.86           N  
ATOM   1428  CA  ILE   122     -18.306 101.064  27.715  1.00 15.65           C  
ATOM   1430  CB  ILE   122     -17.560 101.861  26.674  1.00 15.30           C  
ATOM   1432  CG1 ILE   122     -18.452 103.000  26.114  1.00 16.20           C  
ATOM   1435  CD1 ILE   122     -17.690 103.930  25.081  1.00 12.70           C  
ATOM   1439  CG2 ILE   122     -16.998 100.971  25.496  1.00 14.97           C  
ATOM   1443  C   ILE   122     -17.555  99.752  28.097  1.00 15.69           C  
ATOM   1444  O   ILE   122     -17.972  98.646  27.746  1.00 17.26           O  
ATOM   1446  N   ARG   123     -16.481  99.880  28.863  1.00 15.27           N  
ATOM   1447  CA  ARG   123     -15.686  98.739  29.305  0.50 14.81           C  
ATOM   1451  CB  ARG   123     -14.432  99.242  30.018  0.50 14.77           C  
ATOM   1457  CG  ARG   123     -13.518  98.121  30.561  0.50 13.13           C  
ATOM   1463  CD  ARG   123     -13.132  98.482  31.954  0.50 10.58           C  
ATOM   1469  NE  ARG   123     -11.975  97.751  32.467  0.50 13.44           N  
ATOM   1473  CZ  ARG   123     -12.032  96.946  33.510  0.50  9.28           C  
ATOM   1475  NH1 ARG   123     -13.172  96.775  34.116  0.50  6.74           N  
ATOM   1481  NH2 ARG   123     -10.967  96.293  33.887  0.50 11.97           N  
ATOM   1487  C   ARG   123     -16.410  97.757  30.213  1.00 15.26           C  
ATOM   1488  O   ARG   123     -16.192  96.552  30.115  1.00 14.36           O  
ATOM   1490  N   ASN   124     -17.205  98.288  31.139  1.00 15.97           N  
ATOM   1491  CA  ASN   124     -17.955  97.518  32.062  1.00 16.12           C  
ATOM   1493  CB  ASN   124     -18.005  98.262  33.361  1.00 16.76           C  
ATOM   1496  CG  ASN   124     -16.642  98.358  34.019  1.00 17.50           C  
ATOM   1497  OD1 ASN   124     -15.867  97.451  33.968  1.00 22.01           O  
ATOM   1498  ND2 ASN   124     -16.384  99.436  34.661  1.00 20.81           N  
ATOM   1501  C   ASN   124     -19.372  97.139  31.575  1.00 16.10           C  
ATOM   1502  O   ASN   124     -20.131  96.542  32.309  1.00 15.88           O  
ATOM   1504  N   HIS   125     -19.703  97.442  30.336  1.00 16.02           N  
ATOM   1505  CA  HIS   125     -21.006  97.198  29.804  1.00 15.87           C  
ATOM   1507  CB  HIS   125     -21.182  97.819  28.406  1.00 16.42           C  
ATOM   1510  CG  HIS   125     -22.595  98.294  28.145  1.00 17.72           C  
ATOM   1511  ND1 HIS   125     -23.591  97.471  27.649  1.00 20.32           N  
ATOM   1513  CE1 HIS   125     -24.728  98.144  27.578  1.00 20.03           C  
ATOM   1515  NE2 HIS   125     -24.512  99.385  27.985  1.00 17.52           N  
ATOM   1517  CD2 HIS   125     -23.184  99.504  28.354  1.00 18.22           C  
ATOM   1519  C   HIS   125     -21.288  95.703  29.677  1.00 17.08           C  
ATOM   1520  O   HIS   125     -20.352  94.926  29.505  1.00 17.32           O  
ATOM   1522  N   PRO   126     -22.592  95.291  29.761  1.00 15.94           N  
ATOM   1523  CA  PRO   126     -22.859  93.897  29.646  1.00 15.53           C  
ATOM   1525  CB  PRO   126     -24.244  93.788  30.191  1.00 15.78           C  
ATOM   1528  CG  PRO   126     -24.607  95.092  30.745  1.00 15.31           C  
ATOM   1531  CD  PRO   126     -23.543  95.966  30.660  1.00 15.45           C  
ATOM   1534  C   PRO   126     -22.760  93.357  28.190  1.00 15.77           C  
ATOM   1535  O   PRO   126     -22.646  92.151  28.000  1.00 15.83           O  
ATOM   1536  N   VAL   127     -22.829  94.237  27.204  1.00 15.26           N  
ATOM   1537  CA  VAL   127     -22.769  93.868  25.821  1.00 14.48           C  
ATOM   1539  CB  VAL   127     -24.078  94.266  25.106  1.00 16.44           C  
ATOM   1541  CG1 VAL   127     -25.360  93.691  25.896  1.00 14.02           C  
ATOM   1545  CG2 VAL   127     -24.187  95.807  24.885  1.00 14.24           C  
ATOM   1549  C   VAL   127     -21.504  94.494  25.189  1.00 14.76           C  
ATOM   1550  O   VAL   127     -20.999  95.482  25.628  1.00 15.29           O  
ATOM   1552  N   PRO   128     -20.952  93.874  24.170  1.00 15.02           N  
ATOM   1553  CA  PRO   128     -19.949  94.518  23.375  1.00 13.57           C  
ATOM   1555  CB  PRO   128     -19.716  93.492  22.225  1.00 14.89           C  
ATOM   1558  CG  PRO   128     -20.237  92.224  22.689  1.00 13.79           C  
ATOM   1561  CD  PRO   128     -21.405  92.607  23.551  1.00 15.73           C  
ATOM   1564  C   PRO   128     -20.360  95.862  22.784  1.00 14.69           C  
ATOM   1565  O   PRO   128     -21.505  96.052  22.307  1.00 15.31           O  
ATOM   1566  N   VAL   129     -19.382  96.784  22.689  1.00 15.44           N  
ATOM   1567  CA  VAL   129     -19.582  98.111  22.039  1.00 12.97           C  
ATOM   1569  CB  VAL   129     -19.405  99.269  23.055  1.00 13.20           C  
ATOM   1571  CG1 VAL   129     -19.638 100.622  22.347  1.00  7.24           C  
ATOM   1575  CG2 VAL   129     -20.292  99.059  24.413  1.00  7.88           C  
ATOM   1579  C   VAL   129     -18.603  98.214  20.857  1.00 13.07           C  
ATOM   1580  O   VAL   129     -17.456  97.971  21.014  1.00 12.83           O  
ATOM   1582  N   ILE   130     -19.096  98.480  19.652  1.00 14.20           N  
ATOM   1583  CA  ILE   130     -18.300  98.659  18.459  1.00 11.93           C  
ATOM   1585  CB  ILE   130     -18.984  97.874  17.286  1.00 13.69           C  
ATOM   1587  CG1 ILE   130     -19.161  96.399  17.666  1.00 13.43           C  
ATOM   1590  CD1 ILE   130     -19.975  95.634  16.659  1.00 15.03           C  
ATOM   1594  CG2 ILE   130     -18.218  98.015  15.906  1.00  4.90           C  
ATOM   1598  C   ILE   130     -18.318 100.185  18.077  1.00 13.42           C  
ATOM   1599  O   ILE   130     -19.419 100.851  18.076  1.00 10.47           O  
ATOM   1601  N   ALA   131     -17.122 100.722  17.781  1.00 13.18           N  
ATOM   1602  CA  ALA   131     -16.957 102.062  17.185  1.00 13.55           C  
ATOM   1604  CB  ALA   131     -15.624 102.761  17.547  1.00 11.89           C  
ATOM   1608  C   ALA   131     -17.006 101.860  15.728  1.00 13.09           C  
ATOM   1609  O   ALA   131     -16.321 101.028  15.192  1.00 12.65           O  
ATOM   1611  N   MET   132     -17.852 102.615  15.068  1.00 15.32           N  
ATOM   1612  CA  MET   132     -17.940 102.582  13.563  1.00 13.93           C  
ATOM   1614  CB  MET   132     -19.335 102.230  13.107  1.00 13.98           C  
ATOM   1617  CG  MET   132     -19.509 102.357  11.534  1.00 16.51           C  
ATOM   1620  SD  MET   132     -21.151 101.970  10.883  1.00 18.40           S  
ATOM   1621  CE  MET   132     -21.122 102.807   9.309  1.00 24.32           C  
ATOM   1625  C   MET   132     -17.554 103.991  13.067  1.00 14.19           C  
ATOM   1626  O   MET   132     -18.360 104.888  13.056  1.00 16.29           O  
ATOM   1628  N   VAL   133     -16.333 104.173  12.608  1.00 13.14           N  
ATOM   1629  CA  VAL   133     -15.746 105.489  12.417  1.00 12.83           C  
ATOM   1631  CB  VAL   133     -14.311 105.497  13.055  1.00 10.70           C  
ATOM   1633  CG1 VAL   133     -13.673 106.899  12.793  1.00  9.23           C  
ATOM   1637  CG2 VAL   133     -14.369 105.055  14.518  1.00 11.76           C  
ATOM   1641  C   VAL   133     -15.547 105.798  10.938  1.00 14.21           C  
ATOM   1642  O   VAL   133     -14.987 104.969  10.290  1.00 12.77           O  
ATOM   1644  N   ASN   134     -15.930 106.997  10.458  1.00 15.70           N  
ATOM   1645  CA  ASN   134     -15.892 107.341   9.020  1.00 17.80           C  
ATOM   1647  CB  ASN   134     -17.294 107.206   8.446  1.00 18.10           C  
ATOM   1650  CG  ASN   134     -17.349 107.295   6.929  1.00 16.58           C  
ATOM   1651  OD1 ASN   134     -16.352 107.061   6.189  1.00 15.83           O  
ATOM   1652  ND2 ASN   134     -18.540 107.645   6.448  1.00 14.19           N  
ATOM   1655  C   ASN   134     -15.391 108.796   8.834  1.00 19.29           C  
ATOM   1656  O   ASN   134     -16.183 109.695   8.577  1.00 20.58           O  
ATOM   1658  N   GLY   135     -14.089 109.035   9.035  1.00 19.25           N  
ATOM   1659  CA  GLY   135     -13.543 110.390   8.996  1.00 17.79           C  
ATOM   1662  C   GLY   135     -12.605 110.549  10.177  1.00 17.04           C  
ATOM   1663  O   GLY   135     -12.035 109.561  10.632  1.00 16.93           O  
ATOM   1665  N   LEU   136     -12.466 111.788  10.667  1.00 15.81           N  
ATOM   1666  CA  LEU   136     -11.440 112.138  11.635  1.00 15.63           C  
ATOM   1668  CB  LEU   136     -11.044 113.617  11.520  1.00 16.59           C  
ATOM   1671  CG  LEU   136      -9.891 114.219  12.309  1.00 18.05           C  
ATOM   1673  CD1 LEU   136      -8.429 113.551  12.089  1.00 18.99           C  
ATOM   1677  CD2 LEU   136      -9.833 115.783  12.152  1.00 20.77           C  
ATOM   1681  C   LEU   136     -11.954 111.965  12.963  1.00 14.44           C  
ATOM   1682  O   LEU   136     -13.066 112.422  13.261  1.00 12.39           O  
ATOM   1684  N   ALA   137     -11.077 111.436  13.817  1.00 14.97           N  
ATOM   1685  CA  ALA   137     -11.376 111.250  15.202  1.00 14.20           C  
ATOM   1687  CB  ALA   137     -11.609 109.759  15.466  1.00 12.24           C  
ATOM   1691  C   ALA   137     -10.160 111.801  15.973  1.00 15.75           C  
ATOM   1692  O   ALA   137      -9.029 111.333  15.763  1.00 16.76           O  
ATOM   1694  N   THR   138     -10.362 112.837  16.809  1.00 16.53           N  
ATOM   1695  CA  THR   138      -9.252 113.551  17.381  1.00 16.52           C  
ATOM   1697  CB  THR   138      -8.919 114.929  16.739  1.00 16.69           C  
ATOM   1699  OG1 THR   138      -9.769 115.911  17.307  1.00 21.82           O  
ATOM   1701  CG2 THR   138      -9.014 115.076  15.082  1.00 17.09           C  
ATOM   1705  C   THR   138      -9.402 113.732  18.943  1.00 16.59           C  
ATOM   1706  O   THR   138     -10.504 114.058  19.468  1.00 17.31           O  
ATOM   1708  N   ALA   139      -8.278 113.646  19.641  1.00 14.84           N  
ATOM   1709  CA  ALA   139      -8.277 113.889  21.168  1.00 14.64           C  
ATOM   1711  CB  ALA   139      -8.517 115.349  21.540  1.00 12.76           C  
ATOM   1715  C   ALA   139      -9.300 112.981  21.721  1.00 14.52           C  
ATOM   1716  O   ALA   139      -9.168 111.760  21.532  1.00 14.92           O  
ATOM   1718  N   ALA   140     -10.322 113.519  22.401  1.00 16.51           N  
ATOM   1719  CA  ALA   140     -11.291 112.702  23.204  1.00 16.46           C  
ATOM   1721  CB  ALA   140     -12.166 113.531  24.163  1.00 15.96           C  
ATOM   1725  C   ALA   140     -12.142 111.890  22.295  1.00 16.99           C  
ATOM   1726  O   ALA   140     -12.700 110.882  22.738  1.00 17.32           O  
ATOM   1728  N   GLY   141     -12.260 112.322  21.015  1.00 17.55           N  
ATOM   1729  CA  GLY   141     -12.798 111.517  20.000  1.00 17.29           C  
ATOM   1732  C   GLY   141     -12.052 110.245  19.685  1.00 19.38           C  
ATOM   1733  O   GLY   141     -12.668 109.205  19.427  1.00 21.86           O  
ATOM   1735  N   CYS   142     -10.720 110.328  19.629  1.00 19.34           N  
ATOM   1736  CA  CYS   142      -9.878 109.194  19.497  1.00 18.07           C  
ATOM   1738  CB  CYS   142      -8.437 109.670  19.305  1.00 20.75           C  
ATOM   1741  SG  CYS   142      -7.434 108.399  18.490  1.00 21.27           S  
ATOM   1743  C   CYS   142      -9.947 108.334  20.733  1.00 17.69           C  
ATOM   1744  O   CYS   142     -10.031 107.119  20.635  1.00 19.11           O  
ATOM   1746  N   GLN   143      -9.923 108.948  21.907  1.00 15.10           N  
ATOM   1747  CA  GLN   143     -10.181 108.220  23.112  1.00 14.70           C  
ATOM   1749  CB  GLN   143     -10.384 109.228  24.244  1.00 15.37           C  
ATOM   1752  CG  GLN   143     -10.213 108.699  25.562  1.00 16.50           C  
ATOM   1755  CD  GLN   143     -10.624 109.665  26.587  1.00 15.66           C  
ATOM   1756  OE1 GLN   143     -11.172 109.277  27.546  1.00 21.03           O  
ATOM   1757  NE2 GLN   143     -10.363 110.904  26.395  1.00 14.30           N  
ATOM   1760  C   GLN   143     -11.391 107.289  22.958  1.00 14.94           C  
ATOM   1761  O   GLN   143     -11.356 106.109  23.216  1.00 15.30           O  
ATOM   1763  N   LEU   144     -12.489 107.835  22.491  1.00 16.72           N  
ATOM   1764  CA  LEU   144     -13.743 107.112  22.461  1.00 15.83           C  
ATOM   1766  CB  LEU   144     -14.866 108.027  21.963  1.00 15.53           C  
ATOM   1769  CG  LEU   144     -16.280 107.504  21.752  1.00 17.08           C  
ATOM   1771  CD1 LEU   144     -16.809 106.644  22.878  1.00 11.29           C  
ATOM   1775  CD2 LEU   144     -17.178 108.702  21.383  1.00 15.43           C  
ATOM   1779  C   LEU   144     -13.627 105.947  21.596  1.00 17.09           C  
ATOM   1780  O   LEU   144     -14.065 104.857  21.983  1.00 18.00           O  
ATOM   1782  N   VAL   145     -13.041 106.150  20.403  1.00 14.98           N  
ATOM   1783  CA  VAL   145     -12.867 105.031  19.542  1.00 14.78           C  
ATOM   1785  CB  VAL   145     -12.064 105.410  18.272  1.00 13.20           C  
ATOM   1787  CG1 VAL   145     -11.776 104.237  17.615  1.00 11.90           C  
ATOM   1791  CG2 VAL   145     -12.739 106.455  17.502  1.00  8.21           C  
ATOM   1795  C   VAL   145     -12.079 103.855  20.226  1.00 14.76           C  
ATOM   1796  O   VAL   145     -12.454 102.672  20.187  1.00 15.27           O  
ATOM   1798  N   ALA   146     -10.928 104.207  20.718  1.00 14.28           N  
ATOM   1799  CA  ALA   146      -9.999 103.265  21.296  1.00 14.65           C  
ATOM   1801  CB  ALA   146      -8.694 104.003  21.540  1.00 13.90           C  
ATOM   1805  C   ALA   146     -10.573 102.690  22.578  1.00 16.55           C  
ATOM   1806  O   ALA   146     -10.131 101.649  23.054  1.00 18.77           O  
ATOM   1808  N   SER   147     -11.567 103.346  23.155  1.00 15.98           N  
ATOM   1809  CA  SER   147     -12.355 102.748  24.250  1.00 17.16           C  
ATOM   1811  CB  SER   147     -13.099 103.897  25.013  1.00 16.86           C  
ATOM   1814  OG  SER   147     -12.018 104.685  25.615  1.00 20.51           O  
ATOM   1816  C   SER   147     -13.330 101.630  23.869  1.00 16.07           C  
ATOM   1817  O   SER   147     -13.759 100.933  24.701  1.00 12.98           O  
ATOM   1819  N   CYS   148     -13.790 101.551  22.619  1.00 17.13           N  
ATOM   1820  CA  CYS   148     -14.721 100.505  22.224  1.00 16.71           C  
ATOM   1822  CB  CYS   148     -15.343 100.877  20.885  1.00 18.29           C  
ATOM   1825  SG  CYS   148     -16.416 102.299  21.190  1.00 20.48           S  
ATOM   1827  C   CYS   148     -14.015  99.133  22.224  1.00 17.21           C  
ATOM   1828  O   CYS   148     -12.817  99.052  22.100  1.00 16.90           O  
ATOM   1830  N   ASP   149     -14.781  98.049  22.386  1.00 16.56           N  
ATOM   1831  CA  ASP   149     -14.248  96.671  22.327  1.00 15.21           C  
ATOM   1833  CB  ASP   149     -15.349  95.619  22.823  1.00 13.52           C  
ATOM   1836  CG  ASP   149     -15.848  95.882  24.217  1.00 16.68           C  
ATOM   1837  OD1 ASP   149     -17.059  96.102  24.440  1.00 17.98           O  
ATOM   1838  OD2 ASP   149     -15.021  95.858  25.170  1.00 20.31           O  
ATOM   1839  C   ASP   149     -13.735  96.331  20.910  1.00 14.93           C  
ATOM   1840  O   ASP   149     -12.711  95.631  20.781  1.00 15.16           O  
ATOM   1842  N   ILE   150     -14.444  96.820  19.883  1.00 13.57           N  
ATOM   1843  CA  ILE   150     -14.111  96.565  18.416  1.00 14.31           C  
ATOM   1845  CB  ILE   150     -15.095  95.522  17.733  1.00 12.77           C  
ATOM   1847  CG1 ILE   150     -14.892  94.146  18.399  1.00 15.91           C  
ATOM   1850  CD1 ILE   150     -16.059  93.224  18.301  1.00 13.77           C  
ATOM   1854  CG2 ILE   150     -14.941  95.404  16.247  1.00 13.56           C  
ATOM   1858  C   ILE   150     -14.247  97.871  17.746  1.00 13.95           C  
ATOM   1859  O   ILE   150     -15.051  98.691  18.219  1.00 16.22           O  
ATOM   1861  N   ALA   151     -13.385  98.172  16.777  1.00 12.47           N  
ATOM   1862  CA  ALA   151     -13.555  99.420  15.978  1.00 12.55           C  
ATOM   1864  CB  ALA   151     -12.576 100.535  16.376  1.00 13.16           C  
ATOM   1868  C   ALA   151     -13.361  99.119  14.555  1.00 11.59           C  
ATOM   1869  O   ALA   151     -12.459  98.428  14.221  1.00  9.67           O  
ATOM   1871  N   VAL   152     -14.239  99.649  13.723  1.00 13.17           N  
ATOM   1872  CA  VAL   152     -14.215  99.467  12.276  1.00 13.54           C  
ATOM   1874  CB  VAL   152     -15.538  98.720  11.775  1.00 14.14           C  
ATOM   1876  CG1 VAL   152     -15.402  98.283  10.412  1.00 11.83           C  
ATOM   1880  CG2 VAL   152     -15.927  97.558  12.693  1.00 11.37           C  
ATOM   1884  C   VAL   152     -14.215 100.896  11.702  1.00 15.05           C  
ATOM   1885  O   VAL   152     -15.007 101.694  12.153  1.00 15.86           O  
ATOM   1887  N   ALA   153     -13.434 101.177  10.651  1.00 16.38           N  
ATOM   1888  CA  ALA   153     -13.167 102.532  10.189  1.00 16.80           C  
ATOM   1890  CB  ALA   153     -11.780 103.072  10.794  1.00 15.60           C  
ATOM   1894  C   ALA   153     -13.144 102.479   8.685  1.00 16.53           C  
ATOM   1895  O   ALA   153     -12.680 101.499   8.135  1.00 18.86           O  
ATOM   1897  N   SER   154     -13.720 103.460   7.976  1.00 17.43           N  
ATOM   1898  CA  SER   154     -13.425 103.599   6.498  1.00 17.76           C  
ATOM   1900  CB  SER   154     -14.205 104.772   5.892  1.00 17.71           C  
ATOM   1903  OG  SER   154     -13.894 105.937   6.657  1.00 20.86           O  
ATOM   1905  C   SER   154     -11.941 103.874   6.287  1.00 17.98           C  
ATOM   1906  O   SER   154     -11.274 104.399   7.145  1.00 18.86           O  
ATOM   1908  N   ASP   155     -11.434 103.531   5.123  1.00 20.20           N  
ATOM   1909  CA  ASP   155     -10.016 103.718   4.775  1.00 20.53           C  
ATOM   1911  CB  ASP   155      -9.720 102.958   3.422  1.00 21.70           C  
ATOM   1914  CG  ASP   155     -10.661 103.332   2.321  1.00 25.16           C  
ATOM   1915  OD1 ASP   155     -11.393 104.326   2.548  1.00 32.18           O  
ATOM   1916  OD2 ASP   155     -10.704 102.656   1.233  1.00 31.33           O  
ATOM   1917  C   ASP   155      -9.580 105.200   4.717  1.00 19.69           C  
ATOM   1918  O   ASP   155      -8.400 105.484   4.732  1.00 20.26           O  
ATOM   1920  N   LYS   156     -10.531 106.140   4.626  1.00 19.70           N  
ATOM   1921  CA  LYS   156     -10.233 107.613   4.606  1.00 19.36           C  
ATOM   1923  CB  LYS   156     -11.287 108.402   3.848  1.00 18.32           C  
ATOM   1926  CG  LYS   156     -12.523 108.719   4.721  1.00 21.72           C  
ATOM   1929  CD  LYS   156     -13.605 109.442   3.926  1.00 28.34           C  
ATOM   1932  CE  LYS   156     -14.764 109.953   4.810  1.00 30.53           C  
ATOM   1935  NZ  LYS   156     -15.859 110.341   3.812  1.00 23.70           N  
ATOM   1939  C   LYS   156     -10.196 108.205   6.008  1.00 18.12           C  
ATOM   1940  O   LYS   156      -9.851 109.365   6.182  1.00 19.94           O  
ATOM   1942  N   SER   157     -10.707 107.475   6.967  1.00 15.93           N  
ATOM   1943  CA  SER   157     -10.481 107.827   8.387  1.00 14.77           C  
ATOM   1945  CB  SER   157     -10.962 106.683   9.196  1.00 13.82           C  
ATOM   1948  OG  SER   157     -12.318 106.488   9.139  1.00 14.81           O  
ATOM   1950  C   SER   157      -9.042 108.058   8.857  1.00 14.72           C  
ATOM   1951  O   SER   157      -8.125 107.444   8.356  1.00 14.23           O  
ATOM   1953  N   SER   158      -8.889 108.847   9.942  1.00 14.89           N  
ATOM   1954  CA  SER   158      -7.659 109.206  10.462  1.00 15.21           C  
ATOM   1956  CB  SER   158      -7.008 110.355   9.719  1.00 16.57           C  
ATOM   1959  OG  SER   158      -7.455 111.626  10.185  1.00 19.65           O  
ATOM   1961  C   SER   158      -7.864 109.556  11.938  1.00 15.60           C  
ATOM   1962  O   SER   158      -8.988 109.831  12.370  1.00 17.35           O  
ATOM   1964  N   PHE   159      -6.773 109.495  12.685  1.00 13.31           N  
ATOM   1965  CA  PHE   159      -6.797 109.518  14.183  1.00 13.16           C  
ATOM   1967  CB  PHE   159      -6.626 108.061  14.637  1.00 14.50           C  
ATOM   1970  CG  PHE   159      -7.597 107.116  13.922  1.00 14.84           C  
ATOM   1971  CD1 PHE   159      -7.268 106.551  12.741  1.00 18.81           C  
ATOM   1973  CE1 PHE   159      -8.215 105.735  12.070  1.00 19.96           C  
ATOM   1975  CZ  PHE   159      -9.499 105.507  12.689  1.00 19.89           C  
ATOM   1977  CE2 PHE   159      -9.808 106.080  13.773  1.00 10.53           C  
ATOM   1979  CD2 PHE   159      -8.873 106.890  14.430  1.00 18.37           C  
ATOM   1981  C   PHE   159      -5.650 110.331  14.658  1.00 11.23           C  
ATOM   1982  O   PHE   159      -4.558 110.173  14.074  1.00  7.55           O  
ATOM   1984  N   ALA   160      -5.854 111.185  15.710  1.00 11.91           N  
ATOM   1985  CA  ALA   160      -4.826 112.135  16.255  1.00 11.63           C  
ATOM   1987  CB  ALA   160      -4.717 113.434  15.370  1.00 10.32           C  
ATOM   1991  C   ALA   160      -5.100 112.562  17.718  1.00 12.81           C  
ATOM   1992  O   ALA   160      -6.225 112.448  18.208  1.00 14.16           O  
ATOM   1994  N   THR   161      -4.028 112.898  18.449  1.00 14.40           N  
ATOM   1995  CA  THR   161      -4.124 113.375  19.908  1.00 14.46           C  
ATOM   1997  CB  THR   161      -3.674 112.359  20.920  1.00 14.70           C  
ATOM   1999  OG1 THR   161      -2.354 111.948  20.692  1.00 18.82           O  
ATOM   2001  CG2 THR   161      -4.605 111.072  21.070  1.00 11.62           C  
ATOM   2005  C   THR   161      -3.342 114.724  19.891  1.00 13.93           C  
ATOM   2006  O   THR   161      -2.186 114.821  20.299  1.00 13.89           O  
ATOM   2008  N   PRO   162      -3.936 115.746  19.260  1.00 13.68           N  
ATOM   2009  CA  PRO   162      -3.314 117.035  19.113  1.00 14.50           C  
ATOM   2011  CB  PRO   162      -4.021 117.570  17.909  1.00 14.91           C  
ATOM   2014  CG  PRO   162      -5.495 117.147  18.299  1.00 13.72           C  
ATOM   2017  CD  PRO   162      -5.264 115.729  18.624  1.00 14.02           C  
ATOM   2020  C   PRO   162      -3.546 118.026  20.273  1.00 13.71           C  
ATOM   2021  O   PRO   162      -3.349 119.171  20.077  1.00 13.59           O  
ATOM   2022  N   GLY   163      -3.966 117.617  21.432  1.00 13.57           N  
ATOM   2023  CA  GLY   163      -4.009 118.567  22.602  1.00 15.24           C  
ATOM   2026  C   GLY   163      -2.896 119.618  22.674  1.00 16.04           C  
ATOM   2027  O   GLY   163      -3.162 120.804  22.979  1.00 16.72           O  
ATOM   2029  N   VAL   164      -1.668 119.202  22.341  1.00 15.79           N  
ATOM   2030  CA  VAL   164      -0.458 119.981  22.607  1.00 15.89           C  
ATOM   2032  CB  VAL   164       0.907 119.180  22.283  1.00 16.65           C  
ATOM   2034  CG1 VAL   164       1.292 118.356  23.398  1.00 19.97           C  
ATOM   2038  CG2 VAL   164       0.828 118.443  20.938  1.00 15.86           C  
ATOM   2042  C   VAL   164      -0.448 121.262  21.852  1.00 14.61           C  
ATOM   2043  O   VAL   164       0.088 122.249  22.319  1.00 13.93           O  
ATOM   2045  N   ASN   165      -0.969 121.224  20.629  1.00 16.04           N  
ATOM   2046  CA  ASN   165      -1.148 122.387  19.778  1.00 14.55           C  
ATOM   2048  CB  ASN   165      -1.761 121.915  18.480  1.00 14.16           C  
ATOM   2051  CG  ASN   165      -0.774 121.026  17.664  1.00 14.81           C  
ATOM   2052  OD1 ASN   165       0.415 121.018  17.949  1.00 17.41           O  
ATOM   2053  ND2 ASN   165      -1.256 120.334  16.641  1.00 12.60           N  
ATOM   2056  C   ASN   165      -1.980 123.516  20.470  1.00 15.76           C  
ATOM   2057  O   ASN   165      -1.754 124.706  20.185  1.00 18.72           O  
ATOM   2059  N   VAL   166      -2.891 123.162  21.400  1.00 14.92           N  
ATOM   2060  CA  VAL   166      -3.702 124.124  22.167  1.00 12.58           C  
ATOM   2062  CB  VAL   166      -5.210 123.861  22.031  1.00 12.92           C  
ATOM   2064  CG1 VAL   166      -5.615 123.744  20.418  1.00  7.18           C  
ATOM   2068  CG2 VAL   166      -5.718 122.593  22.756  1.00  8.71           C  
ATOM   2072  C   VAL   166      -3.289 124.120  23.607  1.00 13.26           C  
ATOM   2073  O   VAL   166      -4.050 124.481  24.482  1.00 13.86           O  
ATOM   2075  N   GLY   167      -2.067 123.782  23.873  1.00 12.52           N  
ATOM   2076  CA  GLY   167      -1.554 123.834  25.275  1.00 12.88           C  
ATOM   2079  C   GLY   167      -2.257 122.906  26.196  1.00 12.87           C  
ATOM   2080  O   GLY   167      -2.050 122.990  27.366  1.00 11.70           O  
ATOM   2082  N   LEU   168      -3.018 121.945  25.629  1.00 15.15           N  
ATOM   2083  CA  LEU   168      -3.711 120.940  26.430  1.00 15.27           C  
ATOM   2085  CB  LEU   168      -5.220 121.049  26.337  1.00 14.54           C  
ATOM   2088  CG  LEU   168      -6.044 120.150  27.318  1.00 15.01           C  
ATOM   2090  CD1 LEU   168      -5.635 120.183  28.793  1.00  8.44           C  
ATOM   2094  CD2 LEU   168      -7.475 120.492  27.192  1.00 12.90           C  
ATOM   2098  C   LEU   168      -3.300 119.519  26.054  1.00 15.66           C  
ATOM   2099  O   LEU   168      -3.986 118.919  25.340  1.00 14.16           O  
ATOM   2101  N   PHE   169      -2.277 118.941  26.750  1.00 15.84           N  
ATOM   2102  CA  PHE   169      -1.776 117.603  26.358  1.00 15.52           C  
ATOM   2104  CB  PHE   169      -0.632 117.222  27.284  1.00 15.49           C  
ATOM   2107  CG  PHE   169       0.273 116.083  26.783  1.00 19.77           C  
ATOM   2108  CD1 PHE   169       0.016 114.757  27.103  1.00 19.12           C  
ATOM   2110  CE1 PHE   169       0.845 113.751  26.725  1.00 12.77           C  
ATOM   2112  CZ  PHE   169       2.009 114.007  26.151  1.00 18.20           C  
ATOM   2114  CE2 PHE   169       2.320 115.311  25.776  1.00 23.08           C  
ATOM   2116  CD2 PHE   169       1.463 116.346  26.115  1.00 23.90           C  
ATOM   2118  C   PHE   169      -2.915 116.557  26.384  1.00 14.86           C  
ATOM   2119  O   PHE   169      -3.643 116.462  27.398  1.00 12.35           O  
ATOM   2121  N   CYS   170      -3.016 115.698  25.348  1.00 13.41           N  
ATOM   2122  CA  CYS   170      -4.035 114.596  25.361  1.00 11.88           C  
ATOM   2124  CB  CYS   170      -4.212 113.985  23.971  1.00 16.34           C  
ATOM   2127  SG  CYS   170      -5.066 115.119  22.882  1.00 14.15           S  
ATOM   2129  C   CYS   170      -3.822 113.535  26.415  1.00 12.88           C  
ATOM   2130  O   CYS   170      -3.758 112.371  26.134  1.00 11.10           O  
ATOM   2132  N   SER   171      -3.733 113.932  27.715  1.00 11.47           N  
ATOM   2133  CA  SER   171      -3.464 112.969  28.731  1.00 10.97           C  
ATOM   2135  CB  SER   171      -3.229 113.633  30.073  1.00 10.81           C  
ATOM   2138  OG  SER   171      -2.022 114.323  30.093  1.00 11.21           O  
ATOM   2140  C   SER   171      -4.525 111.918  28.919  1.00 12.85           C  
ATOM   2141  O   SER   171      -4.212 110.719  29.144  1.00 12.57           O  
ATOM   2143  N   THR   172      -5.771 112.381  28.822  1.00 13.91           N  
ATOM   2144  CA  THR   172      -6.954 111.541  28.875  1.00 14.21           C  
ATOM   2146  CB  THR   172      -8.245 112.376  28.810  1.00 11.99           C  
ATOM   2148  OG1 THR   172      -7.944 113.688  28.320  1.00 18.90           O  
ATOM   2150  CG2 THR   172      -8.876 112.488  30.190  1.00 12.58           C  
ATOM   2154  C   THR   172      -6.931 110.566  27.713  1.00 14.24           C  
ATOM   2155  O   THR   172      -6.909 109.354  27.927  1.00 14.96           O  
ATOM   2157  N   PRO   173      -6.924 111.071  26.480  1.00 13.79           N  
ATOM   2158  CA  PRO   173      -6.781 110.153  25.396  1.00 14.93           C  
ATOM   2160  CB  PRO   173      -6.706 111.045  24.184  1.00 15.71           C  
ATOM   2163  CG  PRO   173      -7.460 112.323  24.540  1.00 12.71           C  
ATOM   2166  CD  PRO   173      -7.051 112.455  26.023  1.00 13.35           C  
ATOM   2169  C   PRO   173      -5.521 109.199  25.422  1.00 17.61           C  
ATOM   2170  O   PRO   173      -5.580 108.103  24.913  1.00 19.27           O  
ATOM   2171  N   GLY   174      -4.387 109.629  25.969  1.00 17.70           N  
ATOM   2172  CA  GLY   174      -3.272 108.737  26.057  1.00 17.44           C  
ATOM   2175  C   GLY   174      -3.499 107.491  26.902  1.00 15.28           C  
ATOM   2176  O   GLY   174      -2.813 106.537  26.725  1.00 14.27           O  
ATOM   2178  N   VAL   175      -4.467 107.505  27.800  1.00 15.76           N  
ATOM   2179  CA  VAL   175      -4.896 106.271  28.511  1.00 15.71           C  
ATOM   2181  CB  VAL   175      -5.937 106.619  29.521  1.00 15.70           C  
ATOM   2183  CG1 VAL   175      -6.565 105.337  30.087  1.00 14.32           C  
ATOM   2187  CG2 VAL   175      -5.252 107.444  30.643  1.00 15.63           C  
ATOM   2191  C   VAL   175      -5.366 105.150  27.553  1.00 15.93           C  
ATOM   2192  O   VAL   175      -4.804 104.066  27.471  1.00 16.71           O  
ATOM   2194  N   ALA   176      -6.311 105.462  26.691  1.00 17.13           N  
ATOM   2195  CA  ALA   176      -6.865 104.471  25.816  1.00 15.80           C  
ATOM   2197  CB  ALA   176      -8.171 104.961  25.233  1.00 14.01           C  
ATOM   2201  C   ALA   176      -5.808 104.198  24.771  1.00 17.04           C  
ATOM   2202  O   ALA   176      -5.591 103.035  24.407  1.00 18.17           O  
ATOM   2204  N   LEU   177      -5.122 105.241  24.314  1.00 15.93           N  
ATOM   2205  CA  LEU   177      -4.075 105.075  23.291  1.00 15.60           C  
ATOM   2207  CB  LEU   177      -3.623 106.433  22.684  1.00 14.99           C  
ATOM   2210  CG  LEU   177      -2.831 106.520  21.396  1.00 15.86           C  
ATOM   2212  CD1 LEU   177      -3.655 106.014  20.179  1.00  9.70           C  
ATOM   2216  CD2 LEU   177      -2.241 107.883  21.203  1.00 12.41           C  
ATOM   2220  C   LEU   177      -2.907 104.225  23.790  1.00 13.61           C  
ATOM   2221  O   LEU   177      -2.461 103.392  23.100  1.00 12.97           O  
ATOM   2223  N   ALA   178      -2.379 104.413  25.010  1.00 15.02           N  
ATOM   2224  CA  ALA   178      -1.346 103.557  25.509  1.00 12.58           C  
ATOM   2226  CB  ALA   178      -0.913 104.031  27.090  1.00 12.50           C  
ATOM   2230  C   ALA   178      -1.803 102.057  25.497  1.00 13.24           C  
ATOM   2231  O   ALA   178      -0.988 101.166  25.426  1.00 14.17           O  
ATOM   2233  N   ARG   179      -3.103 101.769  25.688  1.00 13.68           N  
ATOM   2234  CA  ARG   179      -3.628 100.423  25.693  1.00 12.53           C  
ATOM   2236  CB  ARG   179      -4.741 100.327  26.661  1.00 13.34           C  
ATOM   2239  CG  ARG   179      -4.187 100.433  28.135  1.00 13.74           C  
ATOM   2242  CD  ARG   179      -5.181 101.036  29.004  1.00 12.81           C  
ATOM   2245  NE  ARG   179      -4.651 101.243  30.377  1.00 15.74           N  
ATOM   2247  CZ  ARG   179      -3.865 102.245  30.734  1.00 16.14           C  
ATOM   2248  NH1 ARG   179      -3.541 103.192  29.833  1.00 17.19           N  
ATOM   2251  NH2 ARG   179      -3.467 102.334  31.971  1.00 14.79           N  
ATOM   2254  C   ARG   179      -4.038  99.924  24.308  1.00 13.40           C  
ATOM   2255  O   ARG   179      -4.381  98.769  24.163  1.00 13.16           O  
ATOM   2257  N   ALA   180      -3.790 100.731  23.293  1.00 12.66           N  
ATOM   2258  CA  ALA   180      -4.220 100.412  21.896  1.00 13.32           C  
ATOM   2260  CB  ALA   180      -5.088 101.538  21.418  1.00  9.90           C  
ATOM   2264  C   ALA   180      -3.011 100.164  21.056  1.00 14.18           C  
ATOM   2265  O   ALA   180      -2.927  99.131  20.414  1.00 19.33           O  
ATOM   2267  N   VAL   181      -2.039 101.075  21.068  1.00 15.22           N  
ATOM   2268  CA  VAL   181      -0.849 100.991  20.255  1.00 13.85           C  
ATOM   2270  CB  VAL   181      -0.860 102.135  19.120  1.00 15.98           C  
ATOM   2272  CG1 VAL   181      -2.155 102.081  18.357  1.00  7.73           C  
ATOM   2276  CG2 VAL   181      -0.656 103.523  19.716  1.00 13.22           C  
ATOM   2280  C   VAL   181       0.461 100.901  21.028  1.00 15.16           C  
ATOM   2281  O   VAL   181       0.502 100.992  22.279  1.00 15.82           O  
ATOM   2283  N   PRO   182       1.573 100.616  20.315  1.00 14.19           N  
ATOM   2284  CA  PRO   182       2.868 100.628  21.001  1.00 13.75           C  
ATOM   2286  CB  PRO   182       3.843 100.160  19.916  1.00 13.53           C  
ATOM   2289  CG  PRO   182       3.032  99.343  19.051  1.00 13.09           C  
ATOM   2292  CD  PRO   182       1.682 100.081  18.971  1.00 12.60           C  
ATOM   2295  C   PRO   182       3.299 101.974  21.526  1.00 13.83           C  
ATOM   2296  O   PRO   182       2.954 102.954  20.942  1.00 12.62           O  
ATOM   2297  N   ARG   183       4.038 101.995  22.650  1.00 13.44           N  
ATOM   2298  CA  ARG   183       4.558 103.211  23.203  1.00 13.38           C  
ATOM   2300  CB  ARG   183       5.547 102.934  24.284  1.00 15.77           C  
ATOM   2303  CG  ARG   183       5.003 102.142  25.512  1.00 18.09           C  
ATOM   2306  CD  ARG   183       6.155 101.847  26.588  1.00 26.29           C  
ATOM   2309  NE  ARG   183       5.731 100.924  27.657  1.00 24.27           N  
ATOM   2311  CZ  ARG   183       6.371 100.749  28.824  1.00 29.69           C  
ATOM   2312  NH1 ARG   183       7.466 101.430  29.149  1.00 28.43           N  
ATOM   2315  NH2 ARG   183       5.873  99.907  29.739  1.00 32.30           N  
ATOM   2318  C   ARG   183       5.194 104.148  22.188  1.00 15.18           C  
ATOM   2319  O   ARG   183       4.927 105.346  22.173  1.00 14.34           O  
ATOM   2321  N   LYS   184       5.970 103.614  21.250  1.00 16.19           N  
ATOM   2322  CA  LYS   184       6.672 104.457  20.335  1.00 15.56           C  
ATOM   2324  CB  LYS   184       7.652 103.603  19.501  1.00 15.75           C  
ATOM   2327  CG  LYS   184       8.897 103.148  20.171  1.00 14.21           C  
ATOM   2330  CD  LYS   184       9.909 104.258  20.363  1.00 14.47           C  
ATOM   2333  CE  LYS   184      11.130 103.809  21.190  1.00 15.16           C  
ATOM   2336  NZ  LYS   184      10.767 103.122  22.463  1.00 11.42           N  
ATOM   2340  C   LYS   184       5.674 105.175  19.376  1.00 16.21           C  
ATOM   2341  O   LYS   184       6.000 106.188  18.817  1.00 18.28           O  
ATOM   2343  N   VAL   185       4.530 104.560  19.092  1.00 16.20           N  
ATOM   2344  CA  VAL   185       3.482 105.117  18.199  1.00 13.76           C  
ATOM   2346  CB  VAL   185       2.638 104.025  17.610  1.00 13.98           C  
ATOM   2348  CG1 VAL   185       1.288 104.568  16.898  1.00  9.73           C  
ATOM   2352  CG2 VAL   185       3.464 103.207  16.582  1.00 12.89           C  
ATOM   2356  C   VAL   185       2.705 106.100  19.084  1.00 13.72           C  
ATOM   2357  O   VAL   185       2.551 107.269  18.736  1.00 12.67           O  
ATOM   2359  N   ALA   186       2.331 105.677  20.296  1.00 12.27           N  
ATOM   2360  CA  ALA   186       1.546 106.569  21.141  1.00 11.47           C  
ATOM   2362  CB  ALA   186       1.073 105.873  22.447  1.00 10.23           C  
ATOM   2366  C   ALA   186       2.287 107.858  21.382  1.00 11.39           C  
ATOM   2367  O   ALA   186       1.712 108.967  21.396  1.00 11.13           O  
ATOM   2369  N   LEU   187       3.568 107.762  21.624  1.00 13.68           N  
ATOM   2370  CA  LEU   187       4.279 108.922  22.109  1.00 14.98           C  
ATOM   2372  CB  LEU   187       5.438 108.567  23.079  1.00 16.33           C  
ATOM   2375  CG  LEU   187       5.187 108.269  24.512  1.00 15.86           C  
ATOM   2377  CD1 LEU   187       6.406 107.556  25.136  1.00 15.26           C  
ATOM   2381  CD2 LEU   187       4.757 109.428  25.486  1.00 18.79           C  
ATOM   2385  C   LEU   187       4.650 109.852  20.973  1.00 14.07           C  
ATOM   2386  O   LEU   187       4.708 111.061  21.208  1.00 13.86           O  
ATOM   2388  N   GLU   188       4.748 109.370  19.711  1.00 16.26           N  
ATOM   2389  CA  GLU   188       4.968 110.277  18.638  1.00 13.66           C  
ATOM   2391  CB  GLU   188       5.315 109.608  17.304  1.00 15.77           C  
ATOM   2394  CG  GLU   188       5.935 110.580  16.321  1.00 11.44           C  
ATOM   2397  CD  GLU   188       6.002 110.080  14.897  1.00 21.65           C  
ATOM   2398  OE1 GLU   188       6.090 108.837  14.675  1.00 17.68           O  
ATOM   2399  OE2 GLU   188       5.983 110.977  13.985  1.00 20.00           O  
ATOM   2400  C   GLU   188       3.697 111.074  18.509  1.00 16.10           C  
ATOM   2401  O   GLU   188       3.728 112.300  18.403  1.00 19.11           O  
ATOM   2403  N   MET   189       2.568 110.373  18.503  1.00 15.67           N  
ATOM   2404  CA  MET   189       1.245 110.944  18.386  1.00 14.76           C  
ATOM   2406  CB  MET   189       0.223 109.820  18.476  1.00 16.05           C  
ATOM   2409  CG  MET   189      -0.192 109.235  17.113  1.00 11.41           C  
ATOM   2412  SD  MET   189      -1.299 107.831  17.427  1.00 15.18           S  
ATOM   2413  CE  MET   189      -2.885 108.711  17.284  1.00 10.20           C  
ATOM   2417  C   MET   189       0.881 111.983  19.415  1.00 13.16           C  
ATOM   2418  O   MET   189       0.362 113.020  19.111  1.00 12.74           O  
ATOM   2420  N   LEU   190       1.163 111.686  20.648  1.00 13.46           N  
ATOM   2421  CA  LEU   190       1.007 112.651  21.758  1.00 13.26           C  
ATOM   2423  CB  LEU   190       1.172 111.896  23.085  1.00 12.76           C  
ATOM   2426  CG  LEU   190      -0.041 110.953  23.427  1.00 15.20           C  
ATOM   2428  CD1 LEU   190       0.342 109.960  24.610  1.00 10.62           C  
ATOM   2432  CD2 LEU   190      -1.373 111.659  23.801  1.00  9.41           C  
ATOM   2436  C   LEU   190       1.916 113.923  21.809  1.00 13.41           C  
ATOM   2437  O   LEU   190       1.441 115.039  22.144  1.00 12.31           O  
ATOM   2439  N   PHE   191       3.219 113.734  21.593  1.00 13.82           N  
ATOM   2440  CA  PHE   191       4.180 114.821  21.611  1.00 13.38           C  
ATOM   2442  CB  PHE   191       5.621 114.271  21.785  1.00 13.20           C  
ATOM   2445  CG  PHE   191       5.928 113.726  23.145  1.00 15.67           C  
ATOM   2446  CD1 PHE   191       5.438 114.319  24.316  1.00 11.51           C  
ATOM   2448  CE1 PHE   191       5.760 113.755  25.521  1.00 14.34           C  
ATOM   2450  CZ  PHE   191       6.558 112.674  25.594  1.00 12.42           C  
ATOM   2452  CE2 PHE   191       7.108 112.149  24.432  1.00 13.47           C  
ATOM   2454  CD2 PHE   191       6.740 112.606  23.264  1.00 13.04           C  
ATOM   2456  C   PHE   191       4.137 115.686  20.356  1.00 14.04           C  
ATOM   2457  O   PHE   191       4.506 116.891  20.425  1.00 14.78           O  
ATOM   2459  N   THR   192       3.689 115.134  19.229  1.00 13.16           N  
ATOM   2460  CA  THR   192       3.681 115.936  17.956  1.00 13.89           C  
ATOM   2462  CB  THR   192       4.352 115.169  16.800  1.00 12.82           C  
ATOM   2464  OG1 THR   192       3.631 113.956  16.553  1.00 12.98           O  
ATOM   2466  CG2 THR   192       5.800 114.804  17.141  1.00 12.48           C  
ATOM   2470  C   THR   192       2.300 116.317  17.407  1.00 14.50           C  
ATOM   2471  O   THR   192       2.187 117.235  16.600  1.00 15.91           O  
ATOM   2473  N   GLY   193       1.261 115.554  17.731  1.00 15.16           N  
ATOM   2474  CA  GLY   193      -0.111 115.890  17.349  1.00 13.21           C  
ATOM   2477  C   GLY   193      -0.453 115.579  15.886  1.00 14.47           C  
ATOM   2478  O   GLY   193      -1.570 115.866  15.458  1.00 11.68           O  
ATOM   2480  N   GLU   194       0.378 114.845  15.193  1.00 14.01           N  
ATOM   2481  CA  GLU   194       0.022 114.437  13.862  1.00 16.76           C  
ATOM   2483  CB  GLU   194       1.277 114.336  13.000  1.00 17.80           C  
ATOM   2486  CG  GLU   194       2.118 115.670  12.989  1.00 22.11           C  
ATOM   2489  CD  GLU   194       1.936 116.482  11.769  1.00 24.74           C  
ATOM   2490  OE1 GLU   194       0.906 116.402  11.071  1.00 23.22           O  
ATOM   2491  OE2 GLU   194       2.886 117.207  11.450  1.00 34.60           O  
ATOM   2492  C   GLU   194      -0.850 113.190  13.715  1.00 15.67           C  
ATOM   2493  O   GLU   194      -0.580 112.138  14.278  1.00 14.15           O  
ATOM   2495  N   PRO   195      -1.886 113.300  12.895  1.00 14.69           N  
ATOM   2496  CA  PRO   195      -2.718 112.173  12.696  1.00 14.86           C  
ATOM   2498  CB  PRO   195      -3.653 112.671  11.550  1.00 15.80           C  
ATOM   2501  CG  PRO   195      -2.811 113.512  10.737  1.00 12.58           C  
ATOM   2504  CD  PRO   195      -2.018 114.261  11.786  1.00 15.77           C  
ATOM   2507  C   PRO   195      -1.901 110.912  12.128  1.00 14.58           C  
ATOM   2508  O   PRO   195      -0.835 111.053  11.564  1.00  8.63           O  
ATOM   2509  N   ILE   196      -2.412 109.726  12.465  1.00 14.84           N  
ATOM   2510  CA  ILE   196      -2.167 108.529  11.793  1.00 14.45           C  
ATOM   2512  CB  ILE   196      -1.750 107.326  12.600  1.00 14.39           C  
ATOM   2514  CG1 ILE   196      -2.928 106.781  13.464  1.00 15.65           C  
ATOM   2517  CD1 ILE   196      -2.544 105.621  14.499  1.00 11.63           C  
ATOM   2521  CG2 ILE   196      -0.395 107.632  13.279  1.00 13.20           C  
ATOM   2525  C   ILE   196      -3.455 108.204  11.051  1.00 15.62           C  
ATOM   2526  O   ILE   196      -4.602 108.541  11.511  1.00 14.49           O  
ATOM   2528  N   SER   197      -3.224 107.593   9.897  1.00 11.08           N  
ATOM   2529  CA  SER   197      -4.312 107.127   9.129  1.00 14.10           C  
ATOM   2531  CB  SER   197      -3.849 106.874   7.672  1.00 11.64           C  
ATOM   2534  OG  SER   197      -2.965 105.783   7.822  1.00 14.41           O  
ATOM   2536  C   SER   197      -4.818 105.784   9.650  1.00 12.85           C  
ATOM   2537  O   SER   197      -4.136 105.126  10.410  1.00 12.13           O  
ATOM   2539  N   ALA   198      -5.960 105.388   9.078  1.00 12.74           N  
ATOM   2540  CA  ALA   198      -6.697 104.195   9.380  1.00 12.91           C  
ATOM   2542  CB  ALA   198      -8.125 104.216   8.733  1.00 11.76           C  
ATOM   2546  C   ALA   198      -5.890 102.968   9.009  1.00 15.33           C  
ATOM   2547  O   ALA   198      -5.988 101.999   9.676  1.00 15.30           O  
ATOM   2549  N   GLN   199      -5.066 102.998   7.965  1.00 17.46           N  
ATOM   2550  CA  GLN   199      -4.204 101.844   7.708  1.00 18.62           C  
ATOM   2552  CB  GLN   199      -3.447 102.006   6.403  1.00 18.95           C  
ATOM   2555  CG  GLN   199      -4.292 102.060   5.089  1.00 19.74           C  
ATOM   2558  CD  GLN   199      -5.328 103.261   4.900  1.00 17.57           C  
ATOM   2559  OE1 GLN   199      -5.067 104.433   5.285  1.00 22.03           O  
ATOM   2560  NE2 GLN   199      -6.539 102.929   4.327  1.00  5.76           N  
ATOM   2563  C   GLN   199      -3.217 101.559   8.815  1.00 19.07           C  
ATOM   2564  O   GLN   199      -3.066 100.416   9.239  1.00 19.01           O  
ATOM   2566  N   GLU   200      -2.568 102.629   9.289  1.00 19.39           N  
ATOM   2567  CA  GLU   200      -1.639 102.627  10.372  1.00 17.75           C  
ATOM   2569  CB  GLU   200      -0.938 104.016  10.467  1.00 18.59           C  
ATOM   2572  CG  GLU   200      -0.123 104.440   9.146  1.00 19.47           C  
ATOM   2575  CD  GLU   200       0.227 105.995   9.049  1.00 23.04           C  
ATOM   2576  OE1 GLU   200      -0.213 106.792   9.926  1.00 23.16           O  
ATOM   2577  OE2 GLU   200       0.895 106.450   8.065  1.00 26.47           O  
ATOM   2578  C   GLU   200      -2.267 102.296  11.720  1.00 17.53           C  
ATOM   2579  O   GLU   200      -1.687 101.538  12.552  1.00 14.24           O  
ATOM   2581  N   ALA   201      -3.414 102.888  11.983  1.00 17.46           N  
ATOM   2582  CA  ALA   201      -4.134 102.512  13.218  1.00 15.81           C  
ATOM   2584  CB  ALA   201      -5.399 103.324  13.368  1.00 17.82           C  
ATOM   2588  C   ALA   201      -4.499 101.033  13.078  1.00 16.05           C  
ATOM   2589  O   ALA   201      -4.535 100.368  14.018  1.00 12.65           O  
ATOM   2591  N   LEU   202      -4.799 100.518  11.866  1.00 15.15           N  
ATOM   2592  CA  LEU   202      -5.079  99.062  11.761  1.00 16.60           C  
ATOM   2594  CB  LEU   202      -5.662  98.635  10.393  1.00 14.11           C  
ATOM   2597  CG  LEU   202      -5.909  97.131  10.254  1.00 14.17           C  
ATOM   2599  CD1 LEU   202      -6.933  96.662  11.181  1.00 10.30           C  
ATOM   2603  CD2 LEU   202      -6.276  96.674   8.762  1.00  6.93           C  
ATOM   2607  C   LEU   202      -3.807  98.222  12.129  1.00 17.80           C  
ATOM   2608  O   LEU   202      -3.878  97.379  13.019  1.00 20.48           O  
ATOM   2610  N   LEU   203      -2.656  98.555  11.544  1.00 17.59           N  
ATOM   2611  CA  LEU   203      -1.429  97.825  11.775  1.00 18.35           C  
ATOM   2613  CB  LEU   203      -0.297  98.488  11.010  1.00 18.94           C  
ATOM   2616  CG  LEU   203       1.043  97.768  10.922  1.00 21.00           C  
ATOM   2618  CD1 LEU   203       1.190  97.414   9.449  1.00 24.89           C  
ATOM   2622  CD2 LEU   203       2.209  98.632  11.305  1.00 26.89           C  
ATOM   2626  C   LEU   203      -0.998  97.807  13.218  1.00 18.20           C  
ATOM   2627  O   LEU   203      -0.338  96.856  13.663  1.00 20.33           O  
ATOM   2629  N   HIS   204      -1.273  98.900  13.907  1.00 17.02           N  
ATOM   2630  CA  HIS   204      -0.728  99.131  15.234  1.00 17.25           C  
ATOM   2632  CB  HIS   204      -0.203 100.553  15.369  1.00 16.74           C  
ATOM   2635  CG  HIS   204       1.093 100.729  14.676  1.00 18.87           C  
ATOM   2636  ND1 HIS   204       2.157  99.882  14.902  1.00 22.98           N  
ATOM   2638  CE1 HIS   204       3.153 100.212  14.106  1.00 21.31           C  
ATOM   2640  NE2 HIS   204       2.756 101.220  13.350  1.00 20.85           N  
ATOM   2642  CD2 HIS   204       1.477 101.566  13.687  1.00 18.98           C  
ATOM   2644  C   HIS   204      -1.654  98.782  16.358  1.00 16.73           C  
ATOM   2645  O   HIS   204      -1.243  98.784  17.497  1.00 18.93           O  
ATOM   2647  N   GLY   205      -2.879  98.408  16.047  1.00 16.80           N  
ATOM   2648  CA  GLY   205      -3.774  97.896  17.035  1.00 17.30           C  
ATOM   2651  C   GLY   205      -4.869  98.863  17.470  1.00 17.34           C  
ATOM   2652  O   GLY   205      -5.606  98.494  18.429  1.00 14.11           O  
ATOM   2654  N   LEU   206      -5.028 100.015  16.740  1.00 14.87           N  
ATOM   2655  CA  LEU   206      -6.093 100.963  17.128  1.00 15.55           C  
ATOM   2657  CB  LEU   206      -5.815 102.441  16.664  1.00 14.16           C  
ATOM   2660  CG  LEU   206      -6.820 103.556  17.045  1.00 12.78           C  
ATOM   2662  CD1 LEU   206      -7.503 103.424  18.333  1.00 20.82           C  
ATOM   2666  CD2 LEU   206      -6.183 104.910  16.994  1.00 15.60           C  
ATOM   2670  C   LEU   206      -7.477 100.488  16.711  1.00 14.99           C  
ATOM   2671  O   LEU   206      -8.414 100.664  17.458  1.00 14.65           O  
ATOM   2673  N   LEU   207      -7.548  99.925  15.485  1.00 14.78           N  
ATOM   2674  CA  LEU   207      -8.704  99.420  14.835  1.00 14.16           C  
ATOM   2676  CB  LEU   207      -8.769 100.007  13.376  1.00 14.90           C  
ATOM   2679  CG  LEU   207      -8.827 101.563  13.292  1.00 13.55           C  
ATOM   2681  CD1 LEU   207      -8.549 102.044  11.845  1.00 14.59           C  
ATOM   2685  CD2 LEU   207     -10.197 102.130  13.827  1.00  7.65           C  
ATOM   2689  C   LEU   207      -8.664  97.877  14.752  1.00 15.12           C  
ATOM   2690  O   LEU   207      -7.603  97.251  14.797  1.00 15.49           O  
ATOM   2692  N   SER   208      -9.848  97.286  14.559  1.00 15.66           N  
ATOM   2693  CA  SER   208     -10.067  95.832  14.288  1.00 14.66           C  
ATOM   2695  CB  SER   208     -11.378  95.301  14.949  1.00 13.97           C  
ATOM   2698  OG  SER   208     -11.455  95.674  16.324  1.00 12.76           O  
ATOM   2700  C   SER   208     -10.116  95.578  12.808  1.00 14.17           C  
ATOM   2701  O   SER   208      -9.495  94.620  12.297  1.00 11.84           O  
ATOM   2703  N   LYS   209     -10.831  96.455  12.113  1.00 15.33           N  
ATOM   2704  CA  LYS   209     -10.987  96.353  10.630  1.00 15.92           C  
ATOM   2706  CB  LYS   209     -12.322  95.634  10.279  1.00 15.35           C  
ATOM   2709  CG  LYS   209     -12.355  94.142  10.708  1.00 17.64           C  
ATOM   2712  CD  LYS   209     -11.567  93.203   9.711  1.00 20.11           C  
ATOM   2715  CE  LYS   209     -11.666  91.731  10.123  1.00 19.47           C  
ATOM   2718  NZ  LYS   209     -10.901  91.692  11.344  1.00 20.65           N  
ATOM   2722  C   LYS   209     -10.950  97.711   9.937  1.00 15.36           C  
ATOM   2723  O   LYS   209     -11.355  98.672  10.538  1.00 15.46           O  
ATOM   2725  N   VAL   210     -10.479  97.750   8.689  1.00 15.08           N  
ATOM   2726  CA  VAL   210     -10.553  98.951   7.829  1.00 15.57           C  
ATOM   2728  CB  VAL   210      -9.168  99.696   7.643  1.00 14.71           C  
ATOM   2730  CG1 VAL   210      -9.272 100.831   6.619  1.00 18.35           C  
ATOM   2734  CG2 VAL   210      -8.604 100.180   8.959  1.00 18.35           C  
ATOM   2738  C   VAL   210     -11.155  98.506   6.474  1.00 14.68           C  
ATOM   2739  O   VAL   210     -10.706  97.549   5.873  1.00 14.03           O  
ATOM   2741  N   VAL   211     -12.181  99.185   6.001  1.00 15.64           N  
ATOM   2742  CA  VAL   211     -12.831  98.810   4.697  1.00 15.09           C  
ATOM   2744  CB  VAL   211     -14.145  97.980   4.989  1.00 16.09           C  
ATOM   2746  CG1 VAL   211     -13.862  96.746   5.837  1.00 14.13           C  
ATOM   2750  CG2 VAL   211     -15.209  98.830   5.691  1.00 15.98           C  
ATOM   2754  C   VAL   211     -13.174 100.025   3.866  1.00 14.77           C  
ATOM   2755  O   VAL   211     -13.233 101.080   4.396  1.00 11.73           O  
ATOM   2757  N   PRO   212     -13.445  99.900   2.512  1.00 17.06           N  
ATOM   2758  CA  PRO   212     -13.921 101.159   1.922  1.00 17.19           C  
ATOM   2760  CB  PRO   212     -14.305 100.750   0.497  1.00 18.82           C  
ATOM   2763  CG  PRO   212     -13.353  99.628   0.192  1.00 19.04           C  
ATOM   2766  CD  PRO   212     -13.052  98.925   1.485  1.00 16.13           C  
ATOM   2769  C   PRO   212     -15.135 101.791   2.658  1.00 18.76           C  
ATOM   2770  O   PRO   212     -15.906 101.120   3.384  1.00 17.33           O  
ATOM   2771  N   GLU   213     -15.307 103.086   2.482  1.00 19.25           N  
ATOM   2772  CA  GLU   213     -16.484 103.738   3.022  1.00 20.79           C  
ATOM   2774  CB  GLU   213     -16.477 105.206   2.596  1.00 21.02           C  
ATOM   2777  CG  GLU   213     -17.736 105.977   2.967  1.00 24.18           C  
ATOM   2780  CD  GLU   213     -17.585 107.491   2.811  1.00 27.14           C  
ATOM   2781  OE1 GLU   213     -17.184 107.981   1.714  1.00 28.50           O  
ATOM   2782  OE2 GLU   213     -17.856 108.177   3.819  1.00 30.21           O  
ATOM   2783  C   GLU   213     -17.824 103.033   2.612  1.00 21.38           C  
ATOM   2784  O   GLU   213     -18.810 103.032   3.390  1.00 23.43           O  
ATOM   2786  N   ALA   214     -17.833 102.432   1.420  1.00 20.19           N  
ATOM   2787  CA  ALA   214     -18.988 101.723   0.852  1.00 20.15           C  
ATOM   2789  CB  ALA   214     -18.812 101.613  -0.714  1.00 18.33           C  
ATOM   2793  C   ALA   214     -19.225 100.332   1.504  1.00 19.74           C  
ATOM   2794  O   ALA   214     -20.290  99.769   1.359  1.00 17.74           O  
ATOM   2796  N   GLU   215     -18.262  99.812   2.283  1.00 21.29           N  
ATOM   2797  CA  GLU   215     -18.416  98.500   2.937  1.00 21.39           C  
ATOM   2799  CB  GLU   215     -17.210  97.622   2.623  1.00 21.99           C  
ATOM   2802  CG  GLU   215     -16.950  97.415   1.099  1.00 23.86           C  
ATOM   2805  CD  GLU   215     -15.724  96.513   0.816  1.00 26.03           C  
ATOM   2806  OE1 GLU   215     -14.945  96.119   1.730  1.00 27.52           O  
ATOM   2807  OE2 GLU   215     -15.547  96.163  -0.348  1.00 29.48           O  
ATOM   2808  C   GLU   215     -18.573  98.632   4.417  1.00 21.50           C  
ATOM   2809  O   GLU   215     -18.644  97.657   5.181  1.00 21.73           O  
ATOM   2811  N   LEU   216     -18.554  99.869   4.861  1.00 21.86           N  
ATOM   2812  CA  LEU   216     -18.421 100.145   6.284  1.00 19.44           C  
ATOM   2814  CB  LEU   216     -18.142 101.625   6.476  1.00 18.79           C  
ATOM   2817  CG  LEU   216     -18.039 102.169   7.936  1.00 16.12           C  
ATOM   2819  CD1 LEU   216     -16.962 101.490   8.719  1.00 13.83           C  
ATOM   2823  CD2 LEU   216     -17.864 103.637   7.891  1.00  9.01           C  
ATOM   2827  C   LEU   216     -19.643  99.749   7.082  1.00 20.22           C  
ATOM   2828  O   LEU   216     -19.529  99.118   8.115  1.00 22.13           O  
ATOM   2830  N   GLN   217     -20.798 100.216   6.668  1.00 22.03           N  
ATOM   2831  CA  GLN   217     -22.078  99.873   7.290  1.00 23.43           C  
ATOM   2833  CB  GLN   217     -23.216 100.646   6.575  1.00 24.69           C  
ATOM   2836  CG  GLN   217     -24.677 100.560   7.186  1.00 28.96           C  
ATOM   2839  CD  GLN   217     -24.820 101.076   8.653  1.00 33.30           C  
ATOM   2840  OE1 GLN   217     -24.511 102.243   8.968  1.00 36.19           O  
ATOM   2841  NE2 GLN   217     -25.338 100.214   9.528  1.00 34.41           N  
ATOM   2844  C   GLN   217     -22.291  98.352   7.283  1.00 23.28           C  
ATOM   2845  O   GLN   217     -22.572  97.784   8.308  1.00 23.33           O  
ATOM   2847  N   GLU   218     -22.105  97.687   6.152  1.00 23.93           N  
ATOM   2848  CA  GLU   218     -22.224  96.230   6.108  1.00 24.99           C  
ATOM   2850  CB  GLU   218     -22.186  95.694   4.692  1.00 25.20           C  
ATOM   2853  CG  GLU   218     -22.222  94.125   4.663  1.00 31.40           C  
ATOM   2856  CD  GLU   218     -23.501  93.449   5.354  1.00 37.43           C  
ATOM   2857  OE1 GLU   218     -24.658  93.787   4.944  1.00 42.00           O  
ATOM   2858  OE2 GLU   218     -23.341  92.552   6.252  1.00 37.45           O  
ATOM   2859  C   GLU   218     -21.175  95.488   6.917  1.00 24.20           C  
ATOM   2860  O   GLU   218     -21.494  94.466   7.552  1.00 23.78           O  
ATOM   2862  N   GLU   219     -19.934  95.982   6.912  1.00 24.03           N  
ATOM   2863  CA  GLU   219     -18.886  95.317   7.666  1.00 23.56           C  
ATOM   2865  CB  GLU   219     -17.507  95.828   7.309  1.00 24.48           C  
ATOM   2868  CG  GLU   219     -16.389  95.123   8.117  1.00 27.49           C  
ATOM   2871  CD  GLU   219     -16.099  93.700   7.628  1.00 31.58           C  
ATOM   2872  OE1 GLU   219     -16.823  93.172   6.722  1.00 34.57           O  
ATOM   2873  OE2 GLU   219     -15.128  93.120   8.153  1.00 34.06           O  
ATOM   2874  C   GLU   219     -19.093  95.427   9.124  1.00 21.74           C  
ATOM   2875  O   GLU   219     -18.815  94.496   9.865  1.00 24.10           O  
ATOM   2877  N   THR   220     -19.566  96.567   9.583  1.00 20.51           N  
ATOM   2878  CA  THR   220     -19.850  96.741  11.020  1.00 17.78           C  
ATOM   2880  CB  THR   220     -20.187  98.189  11.276  1.00 17.27           C  
ATOM   2882  OG1 THR   220     -19.047  98.984  10.954  1.00 17.78           O  
ATOM   2884  CG2 THR   220     -20.679  98.448  12.706  1.00 16.86           C  
ATOM   2888  C   THR   220     -21.082  95.937  11.434  1.00 17.39           C  
ATOM   2889  O   THR   220     -21.186  95.490  12.589  1.00 15.62           O  
ATOM   2891  N   MET   221     -22.050  95.831  10.501  1.00 16.50           N  
ATOM   2892  CA  MET   221     -23.284  95.049  10.724  1.00 17.34           C  
ATOM   2894  CB  MET   221     -24.372  95.341   9.642  1.00 17.93           C  
ATOM   2897  CG  MET   221     -25.119  96.659   9.843  1.00 19.23           C  
ATOM   2900  SD  MET   221     -25.605  96.801  11.607  1.00 24.57           S  
ATOM   2901  CE  MET   221     -27.246  96.093  11.392  1.00 21.33           C  
ATOM   2905  C   MET   221     -23.020  93.541  10.759  1.00 17.15           C  
ATOM   2906  O   MET   221     -23.736  92.839  11.393  1.00 16.60           O  
ATOM   2908  N   ARG   222     -22.043  93.059  10.007  1.00 17.61           N  
ATOM   2909  CA  ARG   222     -21.626  91.678  10.031  1.00 18.05           C  
ATOM   2911  CB  ARG   222     -20.470  91.443   9.043  1.00 18.43           C  
ATOM   2914  CG  ARG   222     -19.984  89.983   8.921  1.00 19.56           C  
ATOM   2917  CD  ARG   222     -18.661  89.841   8.102  1.00 22.18           C  
ATOM   2920  NE  ARG   222     -17.555  90.652   8.667  1.00 25.51           N  
ATOM   2922  CZ  ARG   222     -16.845  90.324   9.742  1.00 25.92           C  
ATOM   2923  NH1 ARG   222     -17.092  89.216  10.385  1.00 29.49           N  
ATOM   2926  NH2 ARG   222     -15.868  91.084  10.176  1.00 28.66           N  
ATOM   2929  C   ARG   222     -21.148  91.306  11.414  1.00 17.99           C  
ATOM   2930  O   ARG   222     -21.501  90.252  11.914  1.00 18.12           O  
ATOM   2932  N   ILE   223     -20.292  92.152  12.000  1.00 18.21           N  
ATOM   2933  CA  ILE   223     -19.815  91.929  13.376  1.00 17.43           C  
ATOM   2935  CB  ILE   223     -18.650  92.921  13.811  1.00 16.78           C  
ATOM   2937  CG1 ILE   223     -17.392  92.698  12.966  1.00 17.99           C  
ATOM   2940  CD1 ILE   223     -16.388  93.920  13.040  1.00 15.84           C  
ATOM   2944  CG2 ILE   223     -18.318  92.804  15.249  1.00 13.85           C  
ATOM   2948  C   ILE   223     -21.015  92.019  14.308  1.00 16.64           C  
ATOM   2949  O   ILE   223     -21.161  91.175  15.166  1.00 16.90           O  
ATOM   2951  N   ALA   224     -21.864  93.024  14.136  1.00 15.31           N  
ATOM   2952  CA  ALA   224     -22.905  93.273  15.158  1.00 15.78           C  
ATOM   2954  CB  ALA   224     -23.548  94.745  15.021  1.00 14.62           C  
ATOM   2958  C   ALA   224     -24.007  92.170  15.139  1.00 14.91           C  
ATOM   2959  O   ALA   224     -24.485  91.769  16.181  1.00 13.13           O  
ATOM   2961  N   ARG   225     -24.428  91.755  13.940  1.00 15.23           N  
ATOM   2962  CA  ARG   225     -25.376  90.669  13.750  1.00 16.23           C  
ATOM   2964  CB  ARG   225     -25.720  90.483  12.257  1.00 16.86           C  
ATOM   2967  CG  ARG   225     -26.643  91.504  11.776  1.00 20.23           C  
ATOM   2970  CD  ARG   225     -27.407  91.074  10.575  1.00 25.65           C  
ATOM   2973  NE  ARG   225     -27.654  92.232   9.717  1.00 29.44           N  
ATOM   2975  CZ  ARG   225     -26.869  92.596   8.698  1.00 32.85           C  
ATOM   2976  NH1 ARG   225     -25.752  91.896   8.383  1.00 32.04           N  
ATOM   2979  NH2 ARG   225     -27.211  93.666   7.980  1.00 32.54           N  
ATOM   2982  C   ARG   225     -24.836  89.365  14.231  1.00 16.34           C  
ATOM   2983  O   ARG   225     -25.607  88.558  14.761  1.00 18.15           O  
ATOM   2985  N   LYS   226     -23.546  89.096  13.984  1.00 15.65           N  
ATOM   2986  CA  LYS   226     -22.926  87.890  14.516  1.00 15.61           C  
ATOM   2988  CB  LYS   226     -21.485  87.748  14.104  1.00 15.11           C  
ATOM   2991  CG  LYS   226     -20.764  86.542  14.698  1.00 15.61           C  
ATOM   2994  CD  LYS   226     -21.543  85.216  14.583  1.00 14.54           C  
ATOM   2997  CE  LYS   226     -20.686  84.046  15.051  1.00 14.02           C  
ATOM   3000  NZ  LYS   226     -21.290  82.725  14.679  1.00 17.57           N  
ATOM   3004  C   LYS   226     -23.036  87.877  16.007  1.00 15.66           C  
ATOM   3005  O   LYS   226     -23.430  86.909  16.601  1.00 18.10           O  
ATOM   3007  N   ILE   227     -22.714  88.971  16.624  1.00 15.72           N  
ATOM   3008  CA  ILE   227     -22.786  89.054  18.077  1.00 15.33           C  
ATOM   3010  CB  ILE   227     -22.212  90.403  18.599  1.00 13.82           C  
ATOM   3012  CG1 ILE   227     -20.687  90.453  18.344  1.00 15.84           C  
ATOM   3015  CD1 ILE   227     -19.874  91.755  18.995  1.00  9.69           C  
ATOM   3019  CG2 ILE   227     -22.458  90.561  20.114  1.00 14.42           C  
ATOM   3023  C   ILE   227     -24.204  88.872  18.569  1.00 14.80           C  
ATOM   3024  O   ILE   227     -24.417  88.167  19.515  1.00 16.94           O  
ATOM   3026  N   ALA   228     -25.132  89.586  17.962  1.00 14.71           N  
ATOM   3027  CA  ALA   228     -26.551  89.567  18.275  1.00 15.02           C  
ATOM   3029  CB  ALA   228     -27.317  90.628  17.420  1.00 13.51           C  
ATOM   3033  C   ALA   228     -27.190  88.150  18.114  1.00 15.09           C  
ATOM   3034  O   ALA   228     -28.139  87.824  18.801  1.00 14.60           O  
ATOM   3036  N   SER   229     -26.619  87.346  17.220  1.00 15.04           N  
ATOM   3037  CA  SER   229     -26.992  85.970  17.044  1.00 14.66           C  
ATOM   3039  CB  SER   229     -26.544  85.498  15.676  1.00 14.33           C  
ATOM   3042  OG  SER   229     -25.239  85.032  15.696  1.00 13.00           O  
ATOM   3044  C   SER   229     -26.466  84.994  18.066  1.00 14.70           C  
ATOM   3045  O   SER   229     -26.821  83.830  17.973  1.00 14.93           O  
ATOM   3047  N   LEU   230     -25.578  85.424  18.958  1.00 13.97           N  
ATOM   3048  CA  LEU   230     -25.002  84.560  20.017  1.00 13.95           C  
ATOM   3050  CB  LEU   230     -23.507  84.855  20.251  1.00 13.31           C  
ATOM   3053  CG  LEU   230     -22.597  84.633  19.045  1.00 14.28           C  
ATOM   3055  CD1 LEU   230     -21.222  85.339  19.256  1.00 13.01           C  
ATOM   3059  CD2 LEU   230     -22.501  83.118  18.707  1.00 13.08           C  
ATOM   3063  C   LEU   230     -25.742  84.674  21.359  1.00 13.72           C  
ATOM   3064  O   LEU   230     -26.685  85.428  21.481  1.00 14.55           O  
ATOM   3066  N   SER   231     -25.347  83.875  22.355  1.00 13.96           N  
ATOM   3067  CA  SER   231     -25.977  83.950  23.669  1.00 13.31           C  
ATOM   3069  CB  SER   231     -25.675  82.726  24.476  1.00 12.96           C  
ATOM   3072  OG  SER   231     -25.981  82.958  25.830  1.00 11.33           O  
ATOM   3074  C   SER   231     -25.474  85.149  24.455  1.00 14.36           C  
ATOM   3075  O   SER   231     -24.297  85.218  24.802  1.00 15.12           O  
ATOM   3077  N   ARG   232     -26.377  86.069  24.786  1.00 14.66           N  
ATOM   3078  CA  ARG   232     -26.082  87.204  25.635  1.00 14.70           C  
ATOM   3080  CB  ARG   232     -27.326  88.030  25.937  1.00 13.46           C  
ATOM   3083  CG  ARG   232     -27.017  89.470  26.314  1.00 17.14           C  
ATOM   3086  CD  ARG   232     -28.102  90.058  27.218  1.00 21.44           C  
ATOM   3089  NE  ARG   232     -28.145  91.520  27.275  1.00 21.71           N  
ATOM   3091  CZ  ARG   232     -27.828  92.273  28.328  1.00 22.46           C  
ATOM   3092  NH1 ARG   232     -27.369  91.776  29.447  1.00 21.91           N  
ATOM   3095  NH2 ARG   232     -27.968  93.569  28.244  1.00 23.29           N  
ATOM   3098  C   ARG   232     -25.338  86.860  26.938  1.00 14.71           C  
ATOM   3099  O   ARG   232     -24.340  87.502  27.257  1.00 13.88           O  
ATOM   3101  N   PRO   233     -25.867  85.896  27.722  1.00 14.43           N  
ATOM   3102  CA  PRO   233     -25.228  85.611  28.983  1.00 13.83           C  
ATOM   3104  CB  PRO   233     -26.102  84.491  29.580  1.00 14.19           C  
ATOM   3107  CG  PRO   233     -27.290  84.370  28.758  1.00 13.80           C  
ATOM   3110  CD  PRO   233     -27.240  85.363  27.675  1.00 14.09           C  
ATOM   3113  C   PRO   233     -23.801  85.114  28.839  1.00 13.34           C  
ATOM   3114  O   PRO   233     -23.005  85.352  29.723  1.00 12.86           O  
ATOM   3115  N   VAL   234     -23.543  84.351  27.783  1.00 13.00           N  
ATOM   3116  CA  VAL   234     -22.222  83.802  27.500  1.00 13.12           C  
ATOM   3118  CB  VAL   234     -22.283  82.699  26.360  1.00 12.47           C  
ATOM   3120  CG1 VAL   234     -20.899  82.314  25.915  1.00  9.51           C  
ATOM   3124  CG2 VAL   234     -23.111  81.439  26.806  1.00 10.98           C  
ATOM   3128  C   VAL   234     -21.274  84.930  27.067  1.00 13.09           C  
ATOM   3129  O   VAL   234     -20.191  85.036  27.547  1.00 13.33           O  
ATOM   3131  N   VAL   235     -21.689  85.752  26.133  1.00 14.01           N  
ATOM   3132  CA  VAL   235     -20.871  86.882  25.672  1.00 14.81           C  
ATOM   3134  CB  VAL   235     -21.580  87.617  24.549  1.00 15.64           C  
ATOM   3136  CG1 VAL   235     -20.888  88.953  24.200  1.00 14.07           C  
ATOM   3140  CG2 VAL   235     -21.757  86.690  23.319  1.00 13.59           C  
ATOM   3144  C   VAL   235     -20.532  87.894  26.794  1.00 15.71           C  
ATOM   3145  O   VAL   235     -19.423  88.402  26.881  1.00 16.32           O  
ATOM   3147  N   SER   236     -21.491  88.121  27.674  1.00 16.30           N  
ATOM   3148  CA  SER   236     -21.417  89.115  28.709  1.00 16.39           C  
ATOM   3150  CB  SER   236     -22.835  89.340  29.250  1.00 16.90           C  
ATOM   3153  OG  SER   236     -22.921  90.286  30.306  1.00 20.09           O  
ATOM   3155  C   SER   236     -20.462  88.584  29.737  1.00 16.69           C  
ATOM   3156  O   SER   236     -19.653  89.322  30.190  1.00 18.06           O  
ATOM   3158  N   LEU   237     -20.565  87.295  30.083  1.00 16.27           N  
ATOM   3159  CA  LEU   237     -19.587  86.612  30.929  1.00 17.16           C  
ATOM   3161  CB  LEU   237     -20.034  85.167  31.247  1.00 17.51           C  
ATOM   3164  CG  LEU   237     -19.106  84.168  31.956  1.00 19.83           C  
ATOM   3166  CD1 LEU   237     -18.622  84.648  33.318  1.00 19.20           C  
ATOM   3170  CD2 LEU   237     -19.818  82.837  32.074  1.00 19.68           C  
ATOM   3174  C   LEU   237     -18.180  86.661  30.363  1.00 16.23           C  
ATOM   3175  O   LEU   237     -17.212  86.905  31.056  1.00 18.33           O  
ATOM   3177  N   GLY   238     -18.060  86.514  29.096  1.00 16.08           N  
ATOM   3178  CA  GLY   238     -16.758  86.513  28.507  1.00 16.44           C  
ATOM   3181  C   GLY   238     -16.094  87.852  28.509  1.00 15.20           C  
ATOM   3182  O   GLY   238     -14.926  87.918  28.808  1.00 15.04           O  
ATOM   3184  N   LYS   239     -16.828  88.867  28.078  1.00 15.89           N  
ATOM   3185  CA  LYS   239     -16.419  90.266  28.169  1.00 16.50           C  
ATOM   3187  CB  LYS   239     -17.515  91.213  27.587  1.00 17.97           C  
ATOM   3190  CG  LYS   239     -17.029  92.699  27.384  1.00 18.21           C  
ATOM   3193  CD  LYS   239     -18.095  93.714  27.203  1.00 15.23           C  
ATOM   3196  CE  LYS   239     -17.708  95.153  27.709  1.00 10.64           C  
ATOM   3199  NZ  LYS   239     -18.208  96.049  26.514  1.00 16.19           N  
ATOM   3203  C   LYS   239     -15.999  90.654  29.600  1.00 16.17           C  
ATOM   3204  O   LYS   239     -14.903  91.093  29.831  1.00 16.15           O  
ATOM   3206  N   ALA   240     -16.780  90.336  30.599  1.00 15.24           N  
ATOM   3207  CA  ALA   240     -16.382  90.754  31.931  1.00 14.55           C  
ATOM   3209  CB  ALA   240     -17.478  90.623  32.863  1.00 11.62           C  
ATOM   3213  C   ALA   240     -15.141  90.006  32.384  1.00 13.86           C  
ATOM   3214  O   ALA   240     -14.248  90.599  32.951  1.00 15.79           O  
ATOM   3216  N   THR   241     -15.070  88.721  32.062  1.00 13.46           N  
ATOM   3217  CA  THR   241     -13.985  87.878  32.402  1.00 12.24           C  
ATOM   3219  CB  THR   241     -14.328  86.380  32.117  1.00 13.61           C  
ATOM   3221  OG1 THR   241     -15.406  85.981  32.992  1.00 15.52           O  
ATOM   3223  CG2 THR   241     -13.110  85.445  32.439  1.00 12.03           C  
ATOM   3227  C   THR   241     -12.727  88.295  31.722  1.00 11.59           C  
ATOM   3228  O   THR   241     -11.692  88.273  32.327  1.00 10.25           O  
ATOM   3230  N   PHE   242     -12.819  88.652  30.458  1.00 11.97           N  
ATOM   3231  CA  PHE   242     -11.683  89.104  29.711  1.00 12.96           C  
ATOM   3233  CB  PHE   242     -12.092  89.523  28.344  1.00 12.42           C  
ATOM   3236  CG  PHE   242     -10.966  90.007  27.513  1.00 12.68           C  
ATOM   3237  CD1 PHE   242     -10.713  91.357  27.407  1.00 13.62           C  
ATOM   3239  CE1 PHE   242      -9.715  91.828  26.562  1.00 13.23           C  
ATOM   3241  CZ  PHE   242      -8.919  90.920  25.868  1.00 12.41           C  
ATOM   3243  CE2 PHE   242      -9.200  89.558  25.959  1.00 10.91           C  
ATOM   3245  CD2 PHE   242     -10.225  89.123  26.740  1.00 12.57           C  
ATOM   3247  C   PHE   242     -10.934  90.303  30.299  1.00 14.50           C  
ATOM   3248  O   PHE   242      -9.765  90.195  30.532  1.00 15.76           O  
ATOM   3250  N   TYR   243     -11.640  91.390  30.554  1.00 14.86           N  
ATOM   3251  CA  TYR   243     -11.114  92.582  31.220  1.00 15.32           C  
ATOM   3253  CB  TYR   243     -12.134  93.734  31.143  1.00 14.14           C  
ATOM   3256  CG  TYR   243     -12.354  94.274  29.730  1.00 15.55           C  
ATOM   3257  CD1 TYR   243     -11.319  94.883  29.058  1.00 12.40           C  
ATOM   3259  CE1 TYR   243     -11.455  95.424  27.797  1.00 16.47           C  
ATOM   3261  CZ  TYR   243     -12.617  95.329  27.133  1.00 15.94           C  
ATOM   3262  OH  TYR   243     -12.637  95.883  25.838  1.00 15.54           O  
ATOM   3264  CE2 TYR   243     -13.680  94.684  27.764  1.00 14.41           C  
ATOM   3266  CD2 TYR   243     -13.534  94.161  29.084  1.00 13.42           C  
ATOM   3268  C   TYR   243     -10.670  92.310  32.671  1.00 16.25           C  
ATOM   3269  O   TYR   243      -9.749  92.925  33.144  1.00 16.82           O  
ATOM   3271  N   LYS   244     -11.264  91.348  33.348  1.00 16.35           N  
ATOM   3272  CA  LYS   244     -10.777  90.987  34.700  1.00 16.38           C  
ATOM   3274  CB  LYS   244     -11.820  90.081  35.389  1.00 16.55           C  
ATOM   3277  CG  LYS   244     -11.793  90.174  36.865  1.00 20.30           C  
ATOM   3280  CD  LYS   244     -12.806  89.117  37.468  1.00 25.79           C  
ATOM   3283  CE  LYS   244     -12.569  88.804  39.009  1.00 28.29           C  
ATOM   3286  NZ  LYS   244     -13.477  87.694  39.518  1.00 28.12           N  
ATOM   3290  C   LYS   244      -9.410  90.248  34.688  1.00 15.29           C  
ATOM   3291  O   LYS   244      -8.528  90.525  35.467  1.00 14.12           O  
ATOM   3293  N   GLN   245      -9.248  89.308  33.776  1.00 15.77           N  
ATOM   3294  CA  GLN   245      -7.989  88.560  33.697  1.00 15.47           C  
ATOM   3296  CB  GLN   245      -8.114  87.323  32.799  1.00 14.94           C  
ATOM   3299  CG  GLN   245      -7.017  87.396  31.590  1.00 18.39           C  
ATOM   3302  CD  GLN   245      -7.719  87.433  30.399  1.00 18.97           C  
ATOM   3303  OE1 GLN   245      -8.889  87.273  30.462  1.00 24.01           O  
ATOM   3304  NE2 GLN   245      -7.090  87.566  29.311  1.00 18.44           N  
ATOM   3307  C   GLN   245      -6.885  89.413  33.107  1.00 15.01           C  
ATOM   3308  O   GLN   245      -5.733  89.199  33.387  1.00 13.93           O  
ATOM   3310  N   LEU   246      -7.258  90.292  32.180  1.00 16.78           N  
ATOM   3311  CA  LEU   246      -6.298  91.061  31.371  1.00 17.22           C  
ATOM   3313  CB  LEU   246      -7.069  92.069  30.605  1.00 17.45           C  
ATOM   3316  CG  LEU   246      -6.403  92.874  29.529  1.00 20.60           C  
ATOM   3318  CD1 LEU   246      -5.967  91.855  28.487  1.00 22.49           C  
ATOM   3322  CD2 LEU   246      -7.388  93.904  28.998  1.00 16.43           C  
ATOM   3326  C   LEU   246      -5.093  91.680  32.177  1.00 18.13           C  
ATOM   3327  O   LEU   246      -3.938  91.531  31.774  1.00 18.88           O  
ATOM   3329  N   PRO   247      -5.333  92.340  33.329  1.00 18.64           N  
ATOM   3330  CA  PRO   247      -4.169  92.804  34.081  1.00 18.65           C  
ATOM   3332  CB  PRO   247      -4.741  93.912  34.974  1.00 17.74           C  
ATOM   3335  CG  PRO   247      -6.112  93.627  35.135  1.00 18.41           C  
ATOM   3338  CD  PRO   247      -6.556  93.003  33.811  1.00 19.01           C  
ATOM   3341  C   PRO   247      -3.396  91.784  34.952  1.00 19.87           C  
ATOM   3342  O   PRO   247      -2.301  92.108  35.476  1.00 20.11           O  
ATOM   3343  N   GLN   248      -3.908  90.562  35.094  1.00 20.48           N  
ATOM   3344  CA  GLN   248      -3.413  89.685  36.130  1.00 20.67           C  
ATOM   3346  CB  GLN   248      -4.487  88.670  36.579  1.00 21.09           C  
ATOM   3349  CG  GLN   248      -5.791  89.254  36.862  1.00 20.16           C  
ATOM   3352  CD  GLN   248      -5.799  90.117  38.103  1.00 26.42           C  
ATOM   3353  OE1 GLN   248      -4.919  90.034  38.985  1.00 23.30           O  
ATOM   3354  NE2 GLN   248      -6.806  91.009  38.161  1.00 28.22           N  
ATOM   3357  C   GLN   248      -2.121  88.964  35.708  1.00 20.75           C  
ATOM   3358  O   GLN   248      -1.780  88.867  34.510  1.00 19.58           O  
ATOM   3360  N   ASP   249      -1.413  88.450  36.702  1.00 20.17           N  
ATOM   3361  CA  ASP   249      -0.324  87.538  36.403  1.00 21.64           C  
ATOM   3363  CB  ASP   249       0.532  87.195  37.647  1.00 22.42           C  
ATOM   3366  CG  ASP   249      -0.261  86.474  38.694  1.00 28.62           C  
ATOM   3367  OD1 ASP   249      -0.074  85.217  38.892  1.00 31.83           O  
ATOM   3368  OD2 ASP   249      -1.128  87.196  39.299  1.00 39.50           O  
ATOM   3369  C   ASP   249      -0.984  86.323  35.784  1.00 20.60           C  
ATOM   3370  O   ASP   249      -2.208  86.167  35.860  1.00 20.05           O  
ATOM   3372  N   LEU   250      -0.177  85.507  35.114  1.00 20.00           N  
ATOM   3373  CA  LEU   250      -0.673  84.453  34.241  1.00 18.80           C  
ATOM   3375  CB  LEU   250       0.477  83.835  33.449  1.00 19.27           C  
ATOM   3378  CG  LEU   250       0.119  82.967  32.259  1.00 19.48           C  
ATOM   3380  CD1 LEU   250      -0.528  83.830  31.155  1.00 20.42           C  
ATOM   3384  CD2 LEU   250       1.330  82.171  31.789  1.00 17.80           C  
ATOM   3388  C   LEU   250      -1.376  83.361  35.029  1.00 18.49           C  
ATOM   3389  O   LEU   250      -2.352  82.795  34.533  1.00 18.34           O  
ATOM   3391  N   GLY   251      -0.875  83.066  36.229  1.00 16.28           N  
ATOM   3392  CA  GLY   251      -1.447  82.076  37.077  1.00 15.57           C  
ATOM   3395  C   GLY   251      -2.828  82.465  37.580  1.00 15.10           C  
ATOM   3396  O   GLY   251      -3.757  81.628  37.611  1.00 15.44           O  
ATOM   3398  N   THR   252      -2.945  83.716  37.996  1.00 14.03           N  
ATOM   3399  CA  THR   252      -4.185  84.305  38.399  1.00 13.88           C  
ATOM   3401  CB  THR   252      -3.944  85.646  39.134  1.00 15.01           C  
ATOM   3403  OG1 THR   252      -3.006  85.385  40.184  1.00 12.61           O  
ATOM   3405  CG2 THR   252      -5.340  86.288  39.751  1.00 12.60           C  
ATOM   3409  C   THR   252      -5.130  84.406  37.241  1.00 14.87           C  
ATOM   3410  O   THR   252      -6.259  84.000  37.378  1.00 15.33           O  
ATOM   3412  N   ALA   253      -4.655  84.828  36.065  1.00 14.38           N  
ATOM   3413  CA  ALA   253      -5.496  84.872  34.908  1.00 14.68           C  
ATOM   3415  CB  ALA   253      -4.714  85.445  33.683  1.00 15.06           C  
ATOM   3419  C   ALA   253      -6.143  83.479  34.561  1.00 14.62           C  
ATOM   3420  O   ALA   253      -7.320  83.411  34.210  1.00 13.54           O  
ATOM   3422  N   TYR   254      -5.356  82.409  34.577  1.00 14.50           N  
ATOM   3423  CA  TYR   254      -5.859  81.065  34.383  1.00 14.79           C  
ATOM   3425  CB  TYR   254      -4.716  80.100  34.134  1.00 15.25           C  
ATOM   3428  CG  TYR   254      -4.192  80.157  32.758  1.00 13.84           C  
ATOM   3429  CD1 TYR   254      -5.070  80.061  31.662  1.00 16.28           C  
ATOM   3431  CE1 TYR   254      -4.607  80.141  30.368  1.00 16.44           C  
ATOM   3433  CZ  TYR   254      -3.268  80.253  30.147  1.00 14.73           C  
ATOM   3434  OH  TYR   254      -2.877  80.309  28.861  1.00 18.19           O  
ATOM   3436  CE2 TYR   254      -2.368  80.324  31.198  1.00 14.89           C  
ATOM   3438  CD2 TYR   254      -2.831  80.265  32.512  1.00 12.77           C  
ATOM   3440  C   TYR   254      -6.724  80.542  35.527  1.00 15.00           C  
ATOM   3441  O   TYR   254      -7.642  79.776  35.312  1.00 15.40           O  
ATOM   3443  N   TYR   255      -6.440  80.932  36.751  1.00 15.03           N  
ATOM   3444  CA  TYR   255      -7.344  80.591  37.789  1.00 14.99           C  
ATOM   3446  CB  TYR   255      -6.833  81.081  39.104  1.00 15.52           C  
ATOM   3449  CG  TYR   255      -7.879  80.974  40.148  1.00 19.34           C  
ATOM   3450  CD1 TYR   255      -8.102  79.764  40.844  1.00 21.68           C  
ATOM   3452  CE1 TYR   255      -9.139  79.674  41.783  1.00 22.89           C  
ATOM   3454  CZ  TYR   255      -9.939  80.792  41.976  1.00 23.33           C  
ATOM   3455  OH  TYR   255     -10.919  80.817  42.835  1.00 24.14           O  
ATOM   3457  CE2 TYR   255      -9.724  81.964  41.319  1.00 25.42           C  
ATOM   3459  CD2 TYR   255      -8.699  82.058  40.410  1.00 22.49           C  
ATOM   3461  C   TYR   255      -8.754  81.195  37.503  1.00 15.19           C  
ATOM   3462  O   TYR   255      -9.736  80.511  37.620  1.00 14.55           O  
ATOM   3464  N   LEU   256      -8.812  82.475  37.158  1.00 14.24           N  
ATOM   3465  CA  LEU   256     -10.017  83.180  37.100  1.00 15.51           C  
ATOM   3467  CB  LEU   256      -9.734  84.674  36.952  1.00 16.92           C  
ATOM   3470  CG  LEU   256      -9.208  85.548  38.092  1.00 18.49           C  
ATOM   3472  CD1 LEU   256      -8.906  86.875  37.472  1.00 16.42           C  
ATOM   3476  CD2 LEU   256     -10.166  85.652  39.328  1.00 19.57           C  
ATOM   3480  C   LEU   256     -10.854  82.698  35.902  1.00 15.68           C  
ATOM   3481  O   LEU   256     -12.043  82.522  36.037  1.00 15.03           O  
ATOM   3483  N   THR   257     -10.192  82.508  34.753  1.00 14.98           N  
ATOM   3484  CA  THR   257     -10.842  82.158  33.517  1.00 14.81           C  
ATOM   3486  CB  THR   257      -9.958  82.396  32.294  1.00 14.89           C  
ATOM   3488  OG1 THR   257      -8.706  81.722  32.460  1.00 13.21           O  
ATOM   3490  CG2 THR   257      -9.800  83.882  31.997  1.00 11.04           C  
ATOM   3494  C   THR   257     -11.281  80.721  33.548  1.00 16.93           C  
ATOM   3495  O   THR   257     -12.344  80.371  33.014  1.00 16.73           O  
ATOM   3497  N   SER   258     -10.521  79.865  34.207  1.00 17.51           N  
ATOM   3498  CA  SER   258     -10.950  78.510  34.160  1.00 19.01           C  
ATOM   3500  CB  SER   258      -9.773  77.512  34.338  1.00 20.45           C  
ATOM   3503  OG  SER   258      -9.316  77.509  35.639  1.00 23.59           O  
ATOM   3505  C   SER   258     -12.126  78.347  35.096  1.00 18.67           C  
ATOM   3506  O   SER   258     -12.997  77.493  34.873  1.00 19.57           O  
ATOM   3508  N   GLN   259     -12.238  79.196  36.099  1.00 18.69           N  
ATOM   3509  CA  GLN   259     -13.425  79.165  36.941  1.00 18.71           C  
ATOM   3511  CB  GLN   259     -13.208  79.943  38.205  1.00 18.89           C  
ATOM   3514  CG  GLN   259     -14.436  79.924  39.121  1.00 22.10           C  
ATOM   3517  CD  GLN   259     -14.809  78.488  39.619  1.00 24.17           C  
ATOM   3518  OE1 GLN   259     -13.960  77.763  40.195  1.00 22.27           O  
ATOM   3519  NE2 GLN   259     -16.071  78.093  39.390  1.00 22.64           N  
ATOM   3522  C   GLN   259     -14.587  79.783  36.160  1.00 18.68           C  
ATOM   3523  O   GLN   259     -15.716  79.404  36.341  1.00 19.98           O  
ATOM   3525  N   ALA   260     -14.316  80.713  35.267  1.00 18.49           N  
ATOM   3526  CA  ALA   260     -15.406  81.299  34.466  1.00 18.88           C  
ATOM   3528  CB  ALA   260     -15.008  82.587  33.917  1.00 18.05           C  
ATOM   3532  C   ALA   260     -15.893  80.294  33.379  1.00 18.43           C  
ATOM   3533  O   ALA   260     -17.078  80.236  33.047  1.00 17.88           O  
ATOM   3535  N   MET   261     -14.978  79.454  32.908  1.00 18.66           N  
ATOM   3536  CA  MET   261     -15.300  78.339  31.995  1.00 18.55           C  
ATOM   3538  CB  MET   261     -14.077  77.513  31.682  1.00 18.31           C  
ATOM   3541  CG  MET   261     -12.985  78.116  30.788  1.00 19.81           C  
ATOM   3544  SD  MET   261     -13.333  78.793  29.199  1.00 24.11           S  
ATOM   3545  CE  MET   261     -13.440  77.476  27.984  1.00 22.07           C  
ATOM   3549  C   MET   261     -16.319  77.398  32.622  1.00 18.09           C  
ATOM   3550  O   MET   261     -17.343  77.105  32.020  1.00 19.07           O  
ATOM   3552  N   VAL   262     -16.034  76.975  33.848  1.00 16.44           N  
ATOM   3553  CA  VAL   262     -16.888  76.112  34.624  1.00 15.77           C  
ATOM   3555  CB  VAL   262     -16.200  75.694  35.943  1.00 15.84           C  
ATOM   3557  CG1 VAL   262     -17.195  74.963  36.905  1.00 10.46           C  
ATOM   3561  CG2 VAL   262     -14.950  74.872  35.667  1.00 12.61           C  
ATOM   3565  C   VAL   262     -18.271  76.701  34.953  1.00 15.92           C  
ATOM   3566  O   VAL   262     -19.238  75.990  34.974  1.00 16.64           O  
ATOM   3568  N   ASP   263     -18.333  77.983  35.207  1.00 16.40           N  
ATOM   3569  CA  ASP   263     -19.572  78.720  35.391  1.00 16.92           C  
ATOM   3571  CB  ASP   263     -19.275  80.120  35.913  1.00 17.37           C  
ATOM   3574  CG  ASP   263     -18.690  80.097  37.320  1.00 19.14           C  
ATOM   3575  OD1 ASP   263     -18.804  79.022  37.926  1.00 25.39           O  
ATOM   3576  OD2 ASP   263     -18.098  81.107  37.802  1.00 20.04           O  
ATOM   3577  C   ASP   263     -20.375  78.808  34.110  1.00 16.33           C  
ATOM   3578  O   ASP   263     -21.570  78.606  34.126  1.00 16.76           O  
ATOM   3580  N   ASN   264     -19.687  79.048  33.004  1.00 15.92           N  
ATOM   3581  CA  ASN   264     -20.274  79.069  31.690  1.00 15.30           C  
ATOM   3583  CB  ASN   264     -19.179  79.430  30.683  1.00 15.94           C  
ATOM   3586  CG  ASN   264     -19.681  79.765  29.305  1.00 14.46           C  
ATOM   3587  OD1 ASN   264     -19.042  80.515  28.614  1.00 16.93           O  
ATOM   3588  ND2 ASN   264     -20.783  79.191  28.879  1.00 14.75           N  
ATOM   3591  C   ASN   264     -20.957  77.726  31.372  1.00 15.74           C  
ATOM   3592  O   ASN   264     -22.060  77.715  30.858  1.00 15.98           O  
ATOM   3594  N   LEU   265     -20.324  76.602  31.710  1.00 16.14           N  
ATOM   3595  CA  LEU   265     -20.868  75.318  31.446  1.00 15.32           C  
ATOM   3597  CB  LEU   265     -19.814  74.195  31.668  1.00 16.07           C  
ATOM   3600  CG  LEU   265     -18.634  74.140  30.675  1.00 14.27           C  
ATOM   3602  CD1 LEU   265     -17.518  73.185  31.107  1.00  9.14           C  
ATOM   3606  CD2 LEU   265     -19.115  73.927  29.252  1.00 12.77           C  
ATOM   3610  C   LEU   265     -22.099  75.049  32.309  1.00 15.67           C  
ATOM   3611  O   LEU   265     -22.898  74.250  31.941  1.00 15.91           O  
ATOM   3613  N   ALA   266     -22.239  75.676  33.467  1.00 15.88           N  
ATOM   3614  CA  ALA   266     -23.431  75.504  34.285  1.00 15.50           C  
ATOM   3616  CB  ALA   266     -23.122  75.784  35.754  1.00 14.19           C  
ATOM   3620  C   ALA   266     -24.614  76.401  33.769  1.00 16.61           C  
ATOM   3621  O   ALA   266     -25.738  76.291  34.266  1.00 16.60           O  
ATOM   3623  N   LEU   267     -24.382  77.272  32.781  1.00 16.32           N  
ATOM   3624  CA  LEU   267     -25.447  78.054  32.195  1.00 16.65           C  
ATOM   3626  CB  LEU   267     -24.914  79.299  31.429  1.00 17.03           C  
ATOM   3629  CG  LEU   267     -24.228  80.408  32.217  1.00 17.15           C  
ATOM   3631  CD1 LEU   267     -23.640  81.476  31.313  1.00 12.98           C  
ATOM   3635  CD2 LEU   267     -25.132  81.019  33.292  1.00 14.52           C  
ATOM   3639  C   LEU   267     -26.178  77.128  31.232  1.00 17.07           C  
ATOM   3640  O   LEU   267     -25.582  76.228  30.646  1.00 17.69           O  
ATOM   3642  N   ARG   268     -27.473  77.364  31.082  1.00 16.98           N  
ATOM   3643  CA  ARG   268     -28.336  76.672  30.128  1.00 17.74           C  
ATOM   3645  CB  ARG   268     -29.730  77.295  30.330  1.00 18.23           C  
ATOM   3648  CG  ARG   268     -30.855  76.676  29.614  1.00 21.78           C  
ATOM   3651  CD  ARG   268     -30.990  77.293  28.258  1.00 26.34           C  
ATOM   3654  NE  ARG   268     -31.884  76.548  27.390  1.00 30.79           N  
ATOM   3656  CZ  ARG   268     -31.983  76.756  26.076  1.00 32.50           C  
ATOM   3657  NH1 ARG   268     -31.216  77.703  25.475  1.00 29.98           N  
ATOM   3660  NH2 ARG   268     -32.836  76.001  25.367  1.00 30.43           N  
ATOM   3663  C   ARG   268     -27.826  76.820  28.665  1.00 17.31           C  
ATOM   3664  O   ARG   268     -27.837  75.900  27.899  1.00 17.30           O  
ATOM   3666  N   ASP   269     -27.377  77.998  28.287  1.00 17.77           N  
ATOM   3667  CA  ASP   269     -26.942  78.251  26.925  1.00 18.13           C  
ATOM   3669  CB  ASP   269     -26.851  79.743  26.725  1.00 19.45           C  
ATOM   3672  CG  ASP   269     -28.164  80.409  26.320  1.00 17.68           C  
ATOM   3673  OD1 ASP   269     -29.168  79.790  25.997  1.00 18.62           O  
ATOM   3674  OD2 ASP   269     -28.133  81.617  26.257  1.00 16.65           O  
ATOM   3675  C   ASP   269     -25.548  77.623  26.684  1.00 18.82           C  
ATOM   3676  O   ASP   269     -25.176  77.266  25.543  1.00 18.49           O  
ATOM   3678  N   GLY   270     -24.790  77.458  27.777  1.00 18.28           N  
ATOM   3679  CA  GLY   270     -23.562  76.661  27.751  1.00 17.69           C  
ATOM   3682  C   GLY   270     -23.852  75.286  27.241  1.00 17.52           C  
ATOM   3683  O   GLY   270     -23.225  74.812  26.280  1.00 18.29           O  
ATOM   3685  N   GLN   271     -24.819  74.639  27.885  1.00 17.84           N  
ATOM   3686  CA  GLN   271     -25.207  73.296  27.537  1.00 17.31           C  
ATOM   3688  CB  GLN   271     -25.973  72.655  28.703  1.00 17.49           C  
ATOM   3691  CG  GLN   271     -25.071  72.463  29.977  1.00 18.55           C  
ATOM   3694  CD  GLN   271     -23.775  71.619  29.698  1.00 18.76           C  
ATOM   3695  OE1 GLN   271     -23.842  70.600  29.025  1.00 20.90           O  
ATOM   3696  NE2 GLN   271     -22.624  72.066  30.194  1.00 15.37           N  
ATOM   3699  C   GLN   271     -25.941  73.174  26.193  1.00 16.72           C  
ATOM   3700  O   GLN   271     -25.699  72.242  25.442  1.00 16.67           O  
ATOM   3702  N   GLU   272     -26.829  74.108  25.895  1.00 17.32           N  
ATOM   3703  CA  GLU   272     -27.521  74.164  24.607  1.00 17.29           C  
ATOM   3705  CB  GLU   272     -28.480  75.358  24.574  1.00 17.40           C  
ATOM   3708  CG  GLU   272     -28.998  75.747  23.148  1.00 19.96           C  
ATOM   3711  CD  GLU   272     -29.833  74.641  22.410  1.00 19.67           C  
ATOM   3712  OE1 GLU   272     -30.244  73.631  23.037  1.00 19.02           O  
ATOM   3713  OE2 GLU   272     -30.084  74.812  21.193  1.00 18.08           O  
ATOM   3714  C   GLU   272     -26.555  74.227  23.413  1.00 16.62           C  
ATOM   3715  O   GLU   272     -26.725  73.488  22.466  1.00 15.91           O  
ATOM   3717  N   GLY   273     -25.555  75.117  23.492  1.00 17.41           N  
ATOM   3718  CA  GLY   273     -24.539  75.293  22.451  1.00 17.27           C  
ATOM   3721  C   GLY   273     -23.666  74.056  22.206  1.00 17.16           C  
ATOM   3722  O   GLY   273     -23.317  73.733  21.071  1.00 16.15           O  
ATOM   3724  N   ILE   274     -23.308  73.387  23.294  1.00 17.85           N  
ATOM   3725  CA  ILE   274     -22.526  72.165  23.271  1.00 19.06           C  
ATOM   3727  CB  ILE   274     -21.965  71.803  24.700  1.00 20.04           C  
ATOM   3729  CG1 ILE   274     -20.767  72.698  25.052  1.00 20.56           C  
ATOM   3732  CD1 ILE   274     -20.268  72.442  26.378  1.00 24.29           C  
ATOM   3736  CG2 ILE   274     -21.544  70.337  24.768  1.00 20.49           C  
ATOM   3740  C   ILE   274     -23.321  70.991  22.749  1.00 19.34           C  
ATOM   3741  O   ILE   274     -22.837  70.265  21.902  1.00 19.77           O  
ATOM   3743  N   THR   275     -24.537  70.812  23.252  1.00 19.54           N  
ATOM   3744  CA  THR   275     -25.437  69.803  22.733  1.00 19.78           C  
ATOM   3746  CB  THR   275     -26.806  69.815  23.470  1.00 20.28           C  
ATOM   3748  OG1 THR   275     -26.611  69.587  24.863  1.00 21.73           O  
ATOM   3750  CG2 THR   275     -27.735  68.761  22.930  1.00 18.40           C  
ATOM   3754  C   THR   275     -25.727  70.000  21.262  1.00 19.91           C  
ATOM   3755  O   THR   275     -25.693  69.038  20.506  1.00 21.60           O  
ATOM   3757  N   ALA   276     -26.076  71.228  20.875  1.00 19.52           N  
ATOM   3758  CA  ALA   276     -26.407  71.585  19.489  1.00 18.65           C  
ATOM   3760  CB  ALA   276     -26.728  73.068  19.429  1.00 17.36           C  
ATOM   3764  C   ALA   276     -25.258  71.240  18.517  1.00 19.26           C  
ATOM   3765  O   ALA   276     -25.469  70.783  17.380  1.00 19.23           O  
ATOM   3767  N   PHE   277     -24.029  71.444  18.971  1.00 19.66           N  
ATOM   3768  CA  PHE   277     -22.870  71.099  18.186  1.00 20.30           C  
ATOM   3770  CB  PHE   277     -21.613  71.656  18.854  1.00 20.07           C  
ATOM   3773  CG  PHE   277     -20.359  71.194  18.214  1.00 22.83           C  
ATOM   3774  CD1 PHE   277     -20.029  71.616  16.931  1.00 25.86           C  
ATOM   3776  CE1 PHE   277     -18.862  71.144  16.298  1.00 27.11           C  
ATOM   3778  CZ  PHE   277     -18.010  70.240  16.980  1.00 26.89           C  
ATOM   3780  CE2 PHE   277     -18.342  69.809  18.256  1.00 26.23           C  
ATOM   3782  CD2 PHE   277     -19.509  70.296  18.871  1.00 25.89           C  
ATOM   3784  C   PHE   277     -22.779  69.579  17.984  1.00 20.38           C  
ATOM   3785  O   PHE   277     -22.504  69.102  16.886  1.00 19.55           O  
ATOM   3787  N   LEU   278     -23.013  68.843  19.071  1.00 20.79           N  
ATOM   3788  CA  LEU   278     -22.844  67.397  19.108  1.00 21.08           C  
ATOM   3790  CB  LEU   278     -22.720  66.870  20.558  1.00 20.99           C  
ATOM   3793  CG  LEU   278     -21.467  67.170  21.381  1.00 20.36           C  
ATOM   3795  CD1 LEU   278     -21.608  66.644  22.840  1.00 19.50           C  
ATOM   3799  CD2 LEU   278     -20.252  66.596  20.706  1.00 18.64           C  
ATOM   3803  C   LEU   278     -23.997  66.704  18.399  1.00 21.38           C  
ATOM   3804  O   LEU   278     -23.825  65.598  17.905  1.00 21.01           O  
ATOM   3806  N   GLN   279     -25.159  67.361  18.341  1.00 22.27           N  
ATOM   3807  CA  GLN   279     -26.312  66.874  17.553  1.00 22.83           C  
ATOM   3809  CB  GLN   279     -27.623  67.193  18.283  1.00 22.82           C  
ATOM   3812  CG  GLN   279     -27.835  66.311  19.523  1.00 25.24           C  
ATOM   3815  CD  GLN   279     -29.040  66.716  20.406  1.00 27.57           C  
ATOM   3816  OE1 GLN   279     -29.729  67.711  20.150  1.00 28.31           O  
ATOM   3817  NE2 GLN   279     -29.258  65.953  21.479  1.00 28.92           N  
ATOM   3820  C   GLN   279     -26.344  67.425  16.111  1.00 23.07           C  
ATOM   3821  O   GLN   279     -27.294  67.172  15.363  1.00 23.70           O  
ATOM   3823  N   LYS   280     -25.300  68.156  15.716  1.00 23.50           N  
ATOM   3824  CA  LYS   280     -25.191  68.726  14.367  1.00 23.46           C  
ATOM   3826  CB  LYS   280     -25.006  67.613  13.320  1.00 23.78           C  
ATOM   3829  CG  LYS   280     -23.797  66.668  13.546  1.00 25.09           C  
ATOM   3832  CD  LYS   280     -22.483  67.422  13.608  1.00 23.65           C  
ATOM   3837  C   LYS   280     -26.390  69.612  14.000  1.00 23.14           C  
ATOM   3838  O   LYS   280     -26.873  69.578  12.878  1.00 23.12           O  
ATOM   3840  N   ARG   281     -26.859  70.411  14.955  1.00 23.19           N  
ATOM   3841  CA  ARG   281     -27.938  71.406  14.714  1.00 22.80           C  
ATOM   3843  CB  ARG   281     -29.234  70.952  15.390  1.00 22.47           C  
ATOM   3846  CG  ARG   281     -29.126  70.862  16.907  1.00 21.97           C  
ATOM   3849  CD  ARG   281     -30.462  70.709  17.490  1.00 22.22           C  
ATOM   3852  NE  ARG   281     -30.354  70.378  18.899  1.00 23.62           N  
ATOM   3854  CZ  ARG   281     -30.253  71.276  19.865  1.00 21.97           C  
ATOM   3855  NH1 ARG   281     -30.270  72.577  19.593  1.00 24.25           N  
ATOM   3858  NH2 ARG   281     -30.173  70.864  21.110  1.00 21.32           N  
ATOM   3861  C   ARG   281     -27.553  72.815  15.222  1.00 22.15           C  
ATOM   3862  O   ARG   281     -26.485  73.010  15.768  1.00 22.18           O  
ATOM   3864  N   LYS   282     -28.458  73.765  15.040  1.00 22.09           N  
ATOM   3865  CA  LYS   282     -28.247  75.137  15.375  1.00 22.30           C  
ATOM   3867  CB  LYS   282     -28.922  76.061  14.345  1.00 22.90           C  
ATOM   3870  CG  LYS   282     -28.144  76.086  13.021  1.00 25.63           C  
ATOM   3873  CD  LYS   282     -28.732  77.025  11.950  1.00 28.64           C  
ATOM   3876  CE  LYS   282     -28.027  76.854  10.561  1.00 29.15           C  
ATOM   3879  NZ  LYS   282     -26.972  77.866  10.199  1.00 27.68           N  
ATOM   3883  C   LYS   282     -28.776  75.362  16.779  1.00 22.26           C  
ATOM   3884  O   LYS   282     -29.891  74.926  17.099  1.00 21.41           O  
ATOM   3886  N   PRO   283     -27.961  76.030  17.638  1.00 21.82           N  
ATOM   3887  CA  PRO   283     -28.403  76.320  18.971  1.00 21.70           C  
ATOM   3889  CB  PRO   283     -27.143  76.863  19.619  1.00 22.12           C  
ATOM   3892  CG  PRO   283     -26.507  77.568  18.501  1.00 21.28           C  
ATOM   3895  CD  PRO   283     -26.672  76.687  17.361  1.00 21.06           C  
ATOM   3898  C   PRO   283     -29.504  77.368  18.939  1.00 21.68           C  
ATOM   3899  O   PRO   283     -29.479  78.264  18.126  1.00 22.29           O  
ATOM   3900  N   VAL   284     -30.489  77.190  19.793  1.00 22.11           N  
ATOM   3901  CA  VAL   284     -31.550  78.138  19.978  1.00 21.65           C  
ATOM   3903  CB  VAL   284     -32.963  77.473  19.939  1.00 22.24           C  
ATOM   3905  CG1 VAL   284     -34.085  78.522  20.123  1.00 21.74           C  
ATOM   3909  CG2 VAL   284     -33.179  76.687  18.609  1.00 19.77           C  
ATOM   3913  C   VAL   284     -31.207  78.615  21.359  1.00 21.91           C  
ATOM   3914  O   VAL   284     -31.265  77.830  22.310  1.00 22.28           O  
ATOM   3916  N   TRP   285     -30.788  79.869  21.463  1.00 21.10           N  
ATOM   3917  CA  TRP   285     -30.409  80.441  22.733  1.00 21.52           C  
ATOM   3919  CB  TRP   285     -29.451  81.659  22.563  1.00 20.67           C  
ATOM   3922  CG  TRP   285     -28.247  81.413  21.674  1.00 14.90           C  
ATOM   3923  CD1 TRP   285     -27.967  82.027  20.511  1.00 11.30           C  
ATOM   3925  NE1 TRP   285     -26.783  81.527  19.958  1.00  9.32           N  
ATOM   3927  CE2 TRP   285     -26.308  80.550  20.789  1.00 12.07           C  
ATOM   3928  CD2 TRP   285     -27.207  80.441  21.872  1.00 13.81           C  
ATOM   3929  CE3 TRP   285     -26.937  79.501  22.876  1.00 14.24           C  
ATOM   3931  CZ3 TRP   285     -25.809  78.730  22.763  1.00 14.11           C  
ATOM   3933  CH2 TRP   285     -24.918  78.877  21.656  1.00 12.25           C  
ATOM   3935  CZ2 TRP   285     -25.153  79.772  20.684  1.00 11.69           C  
ATOM   3937  C   TRP   285     -31.659  80.864  23.466  1.00 24.05           C  
ATOM   3938  O   TRP   285     -32.658  81.240  22.875  1.00 24.11           O  
ATOM   3940  N   SER   286     -31.591  80.827  24.778  1.00 27.76           N  
ATOM   3941  CA  SER   286     -32.662  81.360  25.580  1.00 30.76           C  
ATOM   3943  CB  SER   286     -32.863  80.501  26.816  1.00 31.14           C  
ATOM   3946  OG  SER   286     -32.578  81.222  27.980  1.00 33.19           O  
ATOM   3948  C   SER   286     -32.349  82.788  25.984  1.00 33.31           C  
ATOM   3949  O   SER   286     -33.235  83.667  25.898  1.00 34.43           O  
ATOM   3951  N   HIS   287     -31.066  83.002  26.360  1.00 35.50           N  
ATOM   3952  CA  HIS   287     -30.538  84.217  27.026  1.00 36.91           C  
ATOM   3954  CB  HIS   287     -30.657  85.533  26.180  1.00 38.14           C  
ATOM   3957  CG  HIS   287     -30.676  85.348  24.689  1.00 39.64           C  
ATOM   3958  ND1 HIS   287     -31.855  85.220  23.977  1.00 42.19           N  
ATOM   3960  CE1 HIS   287     -31.580  85.134  22.686  1.00 44.05           C  
ATOM   3962  NE2 HIS   287     -30.265  85.197  22.536  1.00 44.56           N  
ATOM   3964  CD2 HIS   287     -29.679  85.349  23.773  1.00 40.31           C  
ATOM   3966  C   HIS   287     -31.195  84.471  28.416  1.00 37.23           C  
ATOM   3967  O   HIS   287     -30.861  83.828  29.423  1.00 37.39           O  
END
