
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  119 (  971),  selected  119 , name 2czv_D
# Molecule2: number of CA atoms  164 ( 1308),  selected  164 , name T0487_13_176.pdb
# PARAMETERS: 2czv_D.T0487_13_176.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M     2_D      -       -           -
LGA    R     3_D      R      13          3.296
LGA    K     4_D      F      14          4.279
LGA    L     5_D      A      15          1.929
LGA    K     6_D      L      16          3.554
LGA    T     7_D      R      17          3.894
LGA    L     8_D      P      18          2.896
LGA    P     9_D      -       -           -
LGA    P    10_D      -       -           -
LGA    T    11_D      -       -           -
LGA    L    12_D      -       -           -
LGA    R    13_D      L      19          4.314
LGA    D    14_D      N      20           #
LGA    -       -      P      21           -
LGA    K    15_D      E      22          3.443
LGA    N    16_D      E      23          3.592
LGA    -       -      L      24           -
LGA    -       -      R      25           -
LGA    R    17_D      P      26          3.286
LGA    Y    18_D      W      27          1.160
LGA    I    19_D      R      28          2.062
LGA    A    20_D      L      29          2.195
LGA    F    21_D      E      30          0.953
LGA    E    22_D      V      31          2.287
LGA    I    23_D      V      32          1.233
LGA    I    24_D      L      33          3.075
LGA    S    25_D      D      34          1.898
LGA    D    26_D      P      35          2.173
LGA    G    27_D      P      36          3.330
LGA    D    28_D      P      37          2.107
LGA    -       -      G      38           -
LGA    -       -      R      39           -
LGA    -       -      E      40           -
LGA    F    29_D      E      41          3.112
LGA    T    30_D      V      42          3.297
LGA    K    31_D      Y      43          1.907
LGA    D    32_D      P      44          2.869
LGA    E    33_D      L      45          2.634
LGA    V    34_D      L      46          1.536
LGA    K    35_D      A      47          1.399
LGA    E    36_D      Q      48          2.556
LGA    L    37_D      V      49          3.260
LGA    I    38_D      A      50          2.386
LGA    W    39_D      R      51          1.560
LGA    K    40_D      R      52          3.656
LGA    S    41_D      A      53          4.367
LGA    S    42_D      G      54          2.133
LGA    L    43_D      -       -           -
LGA    E    44_D      -       -           -
LGA    V    45_D      -       -           -
LGA    L    46_D      -       -           -
LGA    G    47_D      -       -           -
LGA    E    48_D      -       -           -
LGA    T    49_D      -       -           -
LGA    G    50_D      -       -           -
LGA    T    51_D      -       -           -
LGA    A    52_D      -       -           -
LGA    I    53_D      -       -           -
LGA    V    54_D      G      55          3.628
LGA    K    55_D      V      56          1.979
LGA    P    56_D      T      57          2.226
LGA    W    57_D      -       -           -
LGA    L    58_D      V      58          1.223
LGA    I    59_D      R      59          4.174
LGA    K    60_D      M      60          1.659
LGA    F    61_D      G      61          3.116
LGA    D    62_D      D      62          2.879
LGA    P    63_D      -       -           -
LGA    N    64_D      -       -           -
LGA    T    65_D      -       -           -
LGA    K    66_D      -       -           -
LGA    T    67_D      -       -           -
LGA    G    68_D      G      63          1.122
LGA    I    69_D      L      64          2.800
LGA    V    70_D      A      65          1.801
LGA    R    71_D      S      66          1.333
LGA    S    72_D      W      67          2.177
LGA    D    73_D      S      68          2.416
LGA    R    74_D      -       -           -
LGA    E    75_D      -       -           -
LGA    Y    76_D      P      69          1.814
LGA    V    77_D      P      70          1.302
LGA    E    78_D      E      71          0.996
LGA    Y    79_D      V      72          1.164
LGA    L    80_D      L      73          1.377
LGA    R    81_D      -       -           -
LGA    F    82_D      -       -           -
LGA    A    83_D      V      74          0.829
LGA    L    84_D      L      75          2.628
LGA    M    85_D      E      76          1.811
LGA    L    86_D      -       -           -
LGA    V    87_D      G      77          0.852
LGA    S    88_D      T      78          2.636
LGA    E    89_D      L      79          3.165
LGA    F    90_D      A      80          2.770
LGA    N    91_D      R      81          2.493
LGA    -       -      M      82           -
LGA    -       -      G      83           -
LGA    G    92_D      Q      84          2.513
LGA    K    93_D      T      85          2.742
LGA    R    94_D      Y      86          2.074
LGA    L    95_D      A      87          2.210
LGA    I    96_D      Y      88          2.800
LGA    I    97_D      R      89          1.660
LGA    R    98_D      L      90          2.873
LGA    T    99_D      Y      91          0.684
LGA    L   100_D      P      92          4.504
LGA    G   101_D      K      93          0.836
LGA    V   102_D      G      94          1.067
LGA    S   103_D      R      95          1.106
LGA    G   104_D      -       -           -
LGA    T   105_D      R      96          2.853
LGA    I   106_D      P      97          3.069
LGA    K   107_D      L      98          5.445
LGA    R   108_D      D      99           -
LGA    L   109_D      P     100           -
LGA    K   110_D      K     101           -
LGA    R   111_D      D     102           -
LGA    K   112_D      P     103           -
LGA    F   113_D      G     104           -
LGA    L   114_D      E     105           -
LGA    A   115_D      R     106           -
LGA    K   116_D      S     107           -
LGA    Y   117_D      V     108           -
LGA    G   118_D      L     109           -
LGA    W   119_D      S     110           -
LGA    K   120_D      A     111           -
LGA    -       -      L     112           -
LGA    -       -      A     113           -
LGA    -       -      R     114           -
LGA    -       -      R     115           -
LGA    -       -      L     116           -
LGA    -       -      L     117           -
LGA    -       -      Q     118           -
LGA    -       -      E     119           -
LGA    -       -      R     120           -
LGA    -       -      L     121           -
LGA    -       -      R     122           -
LGA    -       -      R     123           -
LGA    -       -      L     124           -
LGA    -       -      E     125           -
LGA    -       -      G     126           -
LGA    -       -      V     127           -
LGA    -       -      W     128           -
LGA    -       -      V     129           -
LGA    -       -      E     130           -
LGA    -       -      G     131           -
LGA    -       -      L     132           -
LGA    -       -      A     133           -
LGA    -       -      V     134           -
LGA    -       -      Y     135           -
LGA    -       -      R     136           -
LGA    -       -      R     137           -
LGA    -       -      E     138           -
LGA    -       -      H     139           -
LGA    -       -      A     140           -
LGA    -       -      R     141           -
LGA    -       -      G     142           -
LGA    -       -      P     143           -
LGA    -       -      G     144           -
LGA    -       -      W     145           -
LGA    -       -      R     146           -
LGA    -       -      V     147           -
LGA    -       -      L     148           -
LGA    -       -      G     149           -
LGA    -       -      G     150           -
LGA    -       -      A     151           -
LGA    -       -      V     152           -
LGA    -       -      L     153           -
LGA    -       -      D     154           -
LGA    -       -      L     155           -
LGA    -       -      W     156           -
LGA    -       -      V     157           -
LGA    -       -      S     158           -
LGA    -       -      D     159           -
LGA    -       -      S     160           -
LGA    -       -      G     161           -
LGA    -       -      A     162           -
LGA    -       -      F     163           -
LGA    -       -      L     164           -
LGA    -       -      L     165           -
LGA    -       -      E     166           -
LGA    -       -      V     167           -
LGA    -       -      D     168           -
LGA    -       -      P     169           -
LGA    -       -      A     170           -
LGA    -       -      Y     171           -
LGA    -       -      R     172           -
LGA    -       -      I     173           -
LGA    -       -      L     174           -
LGA    -       -      C     175           -
LGA    -       -      E     176           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  119  164    5.0     77    2.63     7.79     29.406     2.823

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.262637 * X  +   0.118894 * Y  +   0.957542 * Z  +  69.988060
  Y_new =  -0.903601 * X  +   0.378364 * Y  +   0.200862 * Z  + -18.214575
  Z_new =  -0.338418 * X  +  -0.917990 * Y  +   0.206805 * Z  +  29.559584 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.349215    1.792378  [ DEG:   -77.3043    102.6957 ]
  Theta =   0.345235    2.796358  [ DEG:    19.7805    160.2195 ]
  Phi   =  -1.287934    1.853659  [ DEG:   -73.7932    106.2068 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2czv_D                                        
REMARK     2: T0487_13_176.pdb                              
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2czv_D.T0487_13_176.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  119  164   5.0   77   2.63    7.79  29.406
REMARK  ---------------------------------------------------------- 
MOLECULE 2czv_D
HEADER    HYDROLASE                               19-JUL-05   2CZV              
TITLE     CRYSTAL STRUCTURE OF ARCHEAL RNASE P PROTEIN PH1481P IN               
TITLE    2 COMPLEX WITH PH1877P                                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: RIBONUCLEASE P PROTEIN COMPONENT 3;                        
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: RNASE P COMPONENT 3;                                        
COMPND   5 EC: 3.1.26.5;                                                        
COMPND   6 ENGINEERED: YES;                                                     
COMPND   7 MOL_ID: 2;                                                           
COMPND   8 MOLECULE: RIBONUCLEASE P PROTEIN COMPONENT 2;                        
COMPND   9 CHAIN: C, D;                                                         
COMPND  10 SYNONYM: RNASE P COMPONENT 2;                                        
COMPND  11 EC: 3.1.26.5;                                                        
COMPND  12 ENGINEERED: YES;                                                     
COMPND  13 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: PYROCOCCUS HORIKOSHII;                          
SOURCE   3 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   4 GENE: PH1877;                                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21 CONDONPLUS (DE3) RIL;                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET-22B;                                  
SOURCE  10 MOL_ID: 2;                                                           
SOURCE  11 ORGANISM_SCIENTIFIC: PYROCOCCUS HORIKOSHII;                          
SOURCE  12 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE  13 GENE: PH1481;                                                        
SOURCE  14 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  15 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE  16 EXPRESSION_SYSTEM_STRAIN: BL21 CODONPLUS (DE3) RIL;                  
SOURCE  17 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  18 EXPRESSION_SYSTEM_PLASMID: PET-22B                                   
KEYWDS    RIBONUCLEASE, RNA BINDING PROTEIN, RNA RECOGNITION MOTIF,             
KEYWDS   2 PROTEIN-PROTEIN COMPLEX                                              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    S.KAWANO,Y.KAKUTA,T.NAKASHIMA,I.TANAKA,M.KIMURA                       
REVDAT   1   27-JUN-06 2CZV    0                                                
JRNL        AUTH   S.KAWANO,T.NAKASHIMA,Y.KAKUTA,I.TANAKA,M.KIMURA              
JRNL        TITL   CRYSTAL STRUCTURE OF PROTEIN PH1481P IN COMPLEX              
JRNL        TITL 2 WITH PROTEIN PH1877P OF ARCHAEAL RNASE P FROM                
JRNL        TITL 3 PYROCOCCUS HORIKOSHII OT3: IMPLICATION OF DIMER              
JRNL        TITL 4 FORMATION OF THE HOLOENZYME                                  
JRNL        REF    J.MOL.BIOL.                   V. 357   583 2006              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  2CZV A    1   212  UNP    O59543   RNP3_PYRHO       1    212             
DBREF  2CZV B    1   212  UNP    O59543   RNP3_PYRHO       1    212             
DBREF  2CZV C    1   120  UNP    O59150   RNP2_PYRHO       1    120             
DBREF  2CZV D    1   120  UNP    O59150   RNP2_PYRHO       1    120             
SEQRES   1 A  212  MET VAL GLY GLY GLY GLY VAL LYS PHE ILE GLU MET ASP          
SEQRES   2 A  212  ILE ARG ASP LYS GLU ALA TYR GLU LEU ALA LYS GLU TRP          
SEQRES   3 A  212  PHE ASP GLU VAL VAL VAL SER ILE LYS PHE ASN GLU GLU          
SEQRES   4 A  212  VAL ASP LYS GLU LYS LEU ARG GLU ALA ARG LYS GLU TYR          
SEQRES   5 A  212  GLY LYS VAL ALA ILE LEU LEU SER ASN PRO LYS PRO SER          
SEQRES   6 A  212  LEU VAL ARG ASP THR VAL GLN LYS PHE LYS SER TYR LEU          
SEQRES   7 A  212  ILE TYR VAL GLU SER ASN ASP LEU ARG VAL ILE ARG TYR          
SEQRES   8 A  212  SER ILE GLU LYS GLY VAL ASP ALA ILE ILE SER PRO TRP          
SEQRES   9 A  212  VAL ASN ARG LYS ASP PRO GLY ILE ASP HIS VAL LEU ALA          
SEQRES  10 A  212  LYS LEU MET VAL LYS LYS ASN VAL ALA LEU GLY PHE SER          
SEQRES  11 A  212  LEU ARG PRO LEU LEU TYR SER ASN PRO TYR GLU ARG ALA          
SEQRES  12 A  212  ASN LEU LEU ARG PHE MET MET LYS ALA TRP LYS LEU VAL          
SEQRES  13 A  212  GLU LYS TYR LYS VAL ARG ARG PHE LEU THR SER SER ALA          
SEQRES  14 A  212  GLN GLU LYS TRP ASP VAL ARG TYR PRO ARG ASP LEU ILE          
SEQRES  15 A  212  SER LEU GLY VAL VAL ILE GLY MET GLU ILE PRO GLN ALA          
SEQRES  16 A  212  LYS ALA SER ILE SER MET TYR PRO GLU ILE ILE LEU LYS          
SEQRES  17 A  212  ARG LEU LYS TYR                                              
SEQRES   1 B  212  MET VAL GLY GLY GLY GLY VAL LYS PHE ILE GLU MET ASP          
SEQRES   2 B  212  ILE ARG ASP LYS GLU ALA TYR GLU LEU ALA LYS GLU TRP          
SEQRES   3 B  212  PHE ASP GLU VAL VAL VAL SER ILE LYS PHE ASN GLU GLU          
SEQRES   4 B  212  VAL ASP LYS GLU LYS LEU ARG GLU ALA ARG LYS GLU TYR          
SEQRES   5 B  212  GLY LYS VAL ALA ILE LEU LEU SER ASN PRO LYS PRO SER          
SEQRES   6 B  212  LEU VAL ARG ASP THR VAL GLN LYS PHE LYS SER TYR LEU          
SEQRES   7 B  212  ILE TYR VAL GLU SER ASN ASP LEU ARG VAL ILE ARG TYR          
SEQRES   8 B  212  SER ILE GLU LYS GLY VAL ASP ALA ILE ILE SER PRO TRP          
SEQRES   9 B  212  VAL ASN ARG LYS ASP PRO GLY ILE ASP HIS VAL LEU ALA          
SEQRES  10 B  212  LYS LEU MET VAL LYS LYS ASN VAL ALA LEU GLY PHE SER          
SEQRES  11 B  212  LEU ARG PRO LEU LEU TYR SER ASN PRO TYR GLU ARG ALA          
SEQRES  12 B  212  ASN LEU LEU ARG PHE MET MET LYS ALA TRP LYS LEU VAL          
SEQRES  13 B  212  GLU LYS TYR LYS VAL ARG ARG PHE LEU THR SER SER ALA          
SEQRES  14 B  212  GLN GLU LYS TRP ASP VAL ARG TYR PRO ARG ASP LEU ILE          
SEQRES  15 B  212  SER LEU GLY VAL VAL ILE GLY MET GLU ILE PRO GLN ALA          
SEQRES  16 B  212  LYS ALA SER ILE SER MET TYR PRO GLU ILE ILE LEU LYS          
SEQRES  17 B  212  ARG LEU LYS TYR                                              
SEQRES   1 C  120  MET MET ARG LYS LEU LYS THR LEU PRO PRO THR LEU ARG          
SEQRES   2 C  120  ASP LYS ASN ARG TYR ILE ALA PHE GLU ILE ILE SER ASP          
SEQRES   3 C  120  GLY ASP PHE THR LYS ASP GLU VAL LYS GLU LEU ILE TRP          
SEQRES   4 C  120  LYS SER SER LEU GLU VAL LEU GLY GLU THR GLY THR ALA          
SEQRES   5 C  120  ILE VAL LYS PRO TRP LEU ILE LYS PHE ASP PRO ASN THR          
SEQRES   6 C  120  LYS THR GLY ILE VAL ARG SER ASP ARG GLU TYR VAL GLU          
SEQRES   7 C  120  TYR LEU ARG PHE ALA LEU MET LEU VAL SER GLU PHE ASN          
SEQRES   8 C  120  GLY LYS ARG LEU ILE ILE ARG THR LEU GLY VAL SER GLY          
SEQRES   9 C  120  THR ILE LYS ARG LEU LYS ARG LYS PHE LEU ALA LYS TYR          
SEQRES  10 C  120  GLY TRP LYS                                                  
SEQRES   1 D  120  MET MET ARG LYS LEU LYS THR LEU PRO PRO THR LEU ARG          
SEQRES   2 D  120  ASP LYS ASN ARG TYR ILE ALA PHE GLU ILE ILE SER ASP          
SEQRES   3 D  120  GLY ASP PHE THR LYS ASP GLU VAL LYS GLU LEU ILE TRP          
SEQRES   4 D  120  LYS SER SER LEU GLU VAL LEU GLY GLU THR GLY THR ALA          
SEQRES   5 D  120  ILE VAL LYS PRO TRP LEU ILE LYS PHE ASP PRO ASN THR          
SEQRES   6 D  120  LYS THR GLY ILE VAL ARG SER ASP ARG GLU TYR VAL GLU          
SEQRES   7 D  120  TYR LEU ARG PHE ALA LEU MET LEU VAL SER GLU PHE ASN          
SEQRES   8 D  120  GLY LYS ARG LEU ILE ILE ARG THR LEU GLY VAL SER GLY          
SEQRES   9 D  120  THR ILE LYS ARG LEU LYS ARG LYS PHE LEU ALA LYS TYR          
SEQRES  10 D  120  GLY TRP LYS                                                  
HET    BOG   1001      20                                                       
HET    BOG   1002      20                                                       
HET    ACY   2001       4                                                       
HET    ACY   2002       4                                                       
HET    ACY   2003       4                                                       
HET    ACY   2004       4                                                       
HET    ACY   2005       4                                                       
HET    ACY   2006       4                                                       
HET    ACY   2007       4                                                       
HET    ACY   2008       4                                                       
HET    ACY   2009       4                                                       
HET    ACY   2010       4                                                       
HET    ACY   2011       4                                                       
HET    ACY   2012       4                                                       
HET    ACY   2013       4                                                       
HET    ACY   2014       4                                                       
HET    ACY   2015       4                                                       
HET    ACY   2016       4                                                       
HETNAM     BOG B-OCTYLGLUCOSIDE                                                 
HETNAM     ACY ACETIC ACID                                                      
FORMUL   5  BOG    2(C14 H28 O6)                                                
FORMUL   7  ACY    16(C2 H4 O2)                                                 
FORMUL  23  HOH   *320(H2 O)                                                    
CRYST1   63.332   76.118  151.276  90.00  90.00  90.00 P 21 21 21    8          
ATOM   4378  N   MET D   2      30.336   7.156  44.809  1.00 62.41           N  
ATOM   4379  CA  MET D   2      29.975   6.062  43.863  1.00 62.48           C  
ATOM   4380  C   MET D   2      30.657   4.759  44.259  1.00 62.75           C  
ATOM   4381  O   MET D   2      31.203   4.642  45.357  1.00 62.11           O  
ATOM   4382  CB  MET D   2      30.372   6.449  42.444  1.00 63.01           C  
ATOM   4383  N   ARG D   3      30.626   3.782  43.357  1.00 63.13           N  
ATOM   4384  CA  ARG D   3      31.233   2.481  43.620  1.00 63.61           C  
ATOM   4385  C   ARG D   3      32.737   2.484  43.382  1.00 62.80           C  
ATOM   4386  O   ARG D   3      33.203   2.168  42.288  1.00 63.35           O  
ATOM   4387  CB  ARG D   3      30.584   1.406  42.742  1.00 64.98           C  
ATOM   4388  CG  ARG D   3      31.042  -0.017  43.056  1.00 67.00           C  
ATOM   4389  CD  ARG D   3      31.772  -0.652  41.879  1.00 68.67           C  
ATOM   4390  NE  ARG D   3      30.939  -0.701  40.678  1.00 69.82           N  
ATOM   4391  CZ  ARG D   3      31.293  -1.291  39.540  1.00 69.97           C  
ATOM   4392  NH1 ARG D   3      32.471  -1.895  39.430  1.00 69.17           N  
ATOM   4393  NH2 ARG D   3      30.464  -1.279  38.507  1.00 70.85           N  
ATOM   4394  N   LYS D   4      33.495   2.840  44.413  1.00 61.31           N  
ATOM   4395  CA  LYS D   4      34.946   2.867  44.314  1.00 60.00           C  
ATOM   4396  C   LYS D   4      35.456   1.464  43.993  1.00 59.13           C  
ATOM   4397  O   LYS D   4      34.797   0.473  44.299  1.00 59.15           O  
ATOM   4398  CB  LYS D   4      35.543   3.358  45.623  1.00 59.80           C  
ATOM   4399  N   LEU D   5      36.628   1.382  43.373  1.00 57.72           N  
ATOM   4400  CA  LEU D   5      37.208   0.094  43.020  1.00 56.81           C  
ATOM   4401  C   LEU D   5      37.373  -0.769  44.270  1.00 57.06           C  
ATOM   4402  O   LEU D   5      37.216  -0.287  45.390  1.00 57.04           O  
ATOM   4403  CB  LEU D   5      38.567   0.300  42.347  1.00 56.28           C  
ATOM   4404  CG  LEU D   5      38.584   1.153  41.074  1.00 55.34           C  
ATOM   4405  CD1 LEU D   5      40.022   1.444  40.679  1.00 55.04           C  
ATOM   4406  CD2 LEU D   5      37.853   0.433  39.952  1.00 53.40           C  
ATOM   4407  N   LYS D   6      37.683  -2.047  44.075  1.00 57.17           N  
ATOM   4408  CA  LYS D   6      37.867  -2.961  45.197  1.00 57.88           C  
ATOM   4409  C   LYS D   6      39.356  -3.030  45.520  1.00 57.64           C  
ATOM   4410  O   LYS D   6      40.186  -2.968  44.615  1.00 56.58           O  
ATOM   4411  CB  LYS D   6      37.344  -4.354  44.839  1.00 59.12           C  
ATOM   4412  CG  LYS D   6      36.023  -4.344  44.074  1.00 60.77           C  
ATOM   4413  CD  LYS D   6      34.945  -3.559  44.805  1.00 61.96           C  
ATOM   4414  CE  LYS D   6      33.709  -3.384  43.931  1.00 62.78           C  
ATOM   4415  NZ  LYS D   6      34.024  -2.692  42.645  1.00 61.84           N  
ATOM   4416  N   THR D   7      39.681  -3.159  46.805  1.00 56.92           N  
ATOM   4417  CA  THR D   7      41.067  -3.215  47.269  1.00 56.77           C  
ATOM   4418  C   THR D   7      42.062  -3.735  46.232  1.00 56.60           C  
ATOM   4419  O   THR D   7      42.514  -2.973  45.377  1.00 57.81           O  
ATOM   4420  CB  THR D   7      41.185  -4.060  48.552  1.00 57.07           C  
ATOM   4421  OG1 THR D   7      40.376  -3.472  49.577  1.00 57.45           O  
ATOM   4422  CG2 THR D   7      42.630  -4.110  49.033  1.00 55.84           C  
ATOM   4423  N   LEU D   8      42.406  -5.019  46.313  1.00 55.65           N  
ATOM   4424  CA  LEU D   8      43.353  -5.631  45.380  1.00 54.57           C  
ATOM   4425  C   LEU D   8      44.043  -6.814  46.050  1.00 54.64           C  
ATOM   4426  O   LEU D   8      44.432  -6.734  47.217  1.00 52.87           O  
ATOM   4427  CB  LEU D   8      44.419  -4.619  44.943  1.00 53.91           C  
ATOM   4428  CG  LEU D   8      44.984  -4.742  43.526  1.00 53.42           C  
ATOM   4429  CD1 LEU D   8      43.861  -4.564  42.513  1.00 52.92           C  
ATOM   4430  CD2 LEU D   8      46.056  -3.685  43.308  1.00 53.61           C  
ATOM   4431  N   PRO D   9      44.208  -7.928  45.315  1.00 55.33           N  
ATOM   4432  CA  PRO D   9      44.856  -9.134  45.838  1.00 56.10           C  
ATOM   4433  C   PRO D   9      46.138  -8.822  46.615  1.00 56.48           C  
ATOM   4434  O   PRO D   9      46.878  -7.904  46.264  1.00 55.98           O  
ATOM   4435  CB  PRO D   9      45.119  -9.949  44.578  1.00 55.93           C  
ATOM   4436  CG  PRO D   9      43.928  -9.618  43.741  1.00 55.41           C  
ATOM   4437  CD  PRO D   9      43.817  -8.118  43.906  1.00 54.77           C  
ATOM   4438  N   PRO D  10      46.408  -9.589  47.684  1.00 57.34           N  
ATOM   4439  CA  PRO D  10      47.592  -9.420  48.536  1.00 57.74           C  
ATOM   4440  C   PRO D  10      48.935  -9.659  47.843  1.00 57.68           C  
ATOM   4441  O   PRO D  10      49.941  -9.939  48.501  1.00 58.43           O  
ATOM   4442  CB  PRO D  10      47.337 -10.407  49.674  1.00 57.77           C  
ATOM   4443  CG  PRO D  10      46.550 -11.487  49.007  1.00 58.14           C  
ATOM   4444  CD  PRO D  10      45.574 -10.703  48.170  1.00 57.46           C  
ATOM   4445  N   THR D  11      48.948  -9.548  46.519  1.00 56.59           N  
ATOM   4446  CA  THR D  11      50.169  -9.731  45.743  1.00 55.35           C  
ATOM   4447  C   THR D  11      50.313  -8.615  44.714  1.00 54.21           C  
ATOM   4448  O   THR D  11      51.405  -8.362  44.204  1.00 54.59           O  
ATOM   4449  CB  THR D  11      50.190 -11.104  45.029  1.00 56.26           C  
ATOM   4450  OG1 THR D  11      48.886 -11.405  44.510  1.00 56.16           O  
ATOM   4451  CG2 THR D  11      50.625 -12.192  45.995  1.00 55.83           C  
ATOM   4452  N   LEU D  12      49.201  -7.950  44.418  1.00 52.72           N  
ATOM   4453  CA  LEU D  12      49.191  -6.843  43.468  1.00 50.72           C  
ATOM   4454  C   LEU D  12      49.080  -5.528  44.237  1.00 47.83           C  
ATOM   4455  O   LEU D  12      49.578  -4.493  43.798  1.00 50.33           O  
ATOM   4456  CB  LEU D  12      48.010  -6.980  42.505  1.00 50.67           C  
ATOM   4457  CG  LEU D  12      47.975  -8.242  41.645  1.00 50.92           C  
ATOM   4458  CD1 LEU D  12      46.738  -8.216  40.764  1.00 51.35           C  
ATOM   4459  CD2 LEU D  12      49.232  -8.325  40.797  1.00 50.75           C  
ATOM   4460  N   ARG D  13      48.417  -5.587  45.388  1.00 43.37           N  
ATOM   4461  CA  ARG D  13      48.226  -4.433  46.262  1.00 39.37           C  
ATOM   4462  C   ARG D  13      49.576  -3.748  46.485  1.00 36.12           C  
ATOM   4463  O   ARG D  13      50.601  -4.422  46.586  1.00 34.95           O  
ATOM   4464  CB  ARG D  13      47.671  -4.924  47.600  1.00 41.62           C  
ATOM   4465  CG  ARG D  13      47.077  -3.867  48.505  1.00 45.00           C  
ATOM   4466  CD  ARG D  13      46.607  -4.515  49.804  1.00 46.21           C  
ATOM   4467  NE  ARG D  13      45.900  -5.771  49.551  1.00 48.11           N  
ATOM   4468  CZ  ARG D  13      45.282  -6.489  50.486  1.00 48.27           C  
ATOM   4469  NH1 ARG D  13      45.275  -6.081  51.746  1.00 49.18           N  
ATOM   4470  NH2 ARG D  13      44.667  -7.618  50.160  1.00 48.95           N  
ATOM   4471  N   ASP D  14      49.593  -2.419  46.552  1.00 31.14           N  
ATOM   4472  CA  ASP D  14      50.860  -1.724  46.779  1.00 27.59           C  
ATOM   4473  C   ASP D  14      51.401  -2.069  48.160  1.00 24.39           C  
ATOM   4474  O   ASP D  14      50.647  -2.112  49.132  1.00 22.72           O  
ATOM   4475  CB  ASP D  14      50.690  -0.200  46.691  1.00 29.23           C  
ATOM   4476  CG  ASP D  14      50.446   0.284  45.273  1.00 28.94           C  
ATOM   4477  OD1 ASP D  14      51.048  -0.280  44.339  1.00 30.79           O  
ATOM   4478  OD2 ASP D  14      49.666   1.240  45.098  1.00 31.48           O  
ATOM   4479  N   LYS D  15      52.705  -2.322  48.233  1.00 21.79           N  
ATOM   4480  CA  LYS D  15      53.373  -2.630  49.494  1.00 21.49           C  
ATOM   4481  C   LYS D  15      53.938  -1.317  50.012  1.00 19.79           C  
ATOM   4482  O   LYS D  15      54.639  -0.610  49.285  1.00 18.67           O  
ATOM   4483  CB  LYS D  15      54.495  -3.647  49.278  1.00 21.54           C  
ATOM   4484  CG  LYS D  15      53.966  -5.049  48.980  1.00 28.85           C  
ATOM   4485  CD  LYS D  15      55.057  -6.097  49.083  1.00 29.76           C  
ATOM   4486  CE  LYS D  15      54.460  -7.497  49.160  1.00 30.04           C  
ATOM   4487  NZ  LYS D  15      53.603  -7.797  47.986  1.00 30.21           N  
ATOM   4488  N   ASN D  16      53.641  -1.002  51.269  1.00 17.64           N  
ATOM   4489  CA  ASN D  16      54.076   0.257  51.856  1.00 16.77           C  
ATOM   4490  C   ASN D  16      54.913   0.156  53.122  1.00 16.31           C  
ATOM   4491  O   ASN D  16      54.960  -0.877  53.794  1.00 12.12           O  
ATOM   4492  CB  ASN D  16      52.849   1.112  52.200  1.00 17.46           C  
ATOM   4493  CG  ASN D  16      51.827   1.170  51.072  1.00 20.10           C  
ATOM   4494  OD1 ASN D  16      52.132   1.621  49.980  1.00 22.13           O  
ATOM   4495  ND2 ASN D  16      50.608   0.716  51.345  1.00 20.46           N  
ATOM   4496  N   ARG D  17      55.579   1.264  53.424  1.00 15.60           N  
ATOM   4497  CA  ARG D  17      56.343   1.411  54.651  1.00 15.72           C  
ATOM   4498  C   ARG D  17      55.995   2.812  55.088  1.00 15.64           C  
ATOM   4499  O   ARG D  17      55.658   3.659  54.256  1.00 15.64           O  
ATOM   4500  CB  ARG D  17      57.848   1.247  54.437  1.00 13.47           C  
ATOM   4501  CG  ARG D  17      58.286  -0.135  54.901  1.00 14.50           C  
ATOM   4502  CD  ARG D  17      59.674  -0.563  54.449  1.00 11.79           C  
ATOM   4503  NE  ARG D  17      59.866  -1.978  54.773  1.00 12.35           N  
ATOM   4504  CZ  ARG D  17      60.601  -2.831  54.064  1.00 16.29           C  
ATOM   4505  NH1 ARG D  17      61.235  -2.419  52.968  1.00 12.80           N  
ATOM   4506  NH2 ARG D  17      60.691  -4.102  54.444  1.00 12.64           N  
ATOM   4507  N   TYR D  18      56.037   3.051  56.389  1.00 15.19           N  
ATOM   4508  CA  TYR D  18      55.694   4.360  56.897  1.00 13.55           C  
ATOM   4509  C   TYR D  18      56.867   4.977  57.616  1.00 14.11           C  
ATOM   4510  O   TYR D  18      57.586   4.306  58.364  1.00 13.75           O  
ATOM   4511  CB  TYR D  18      54.476   4.259  57.807  1.00 15.28           C  
ATOM   4512  CG  TYR D  18      53.277   3.659  57.097  1.00 15.31           C  
ATOM   4513  CD1 TYR D  18      53.141   2.278  56.958  1.00 15.59           C  
ATOM   4514  CD2 TYR D  18      52.307   4.477  56.523  1.00 14.70           C  
ATOM   4515  CE1 TYR D  18      52.066   1.730  56.263  1.00 19.10           C  
ATOM   4516  CE2 TYR D  18      51.236   3.943  55.827  1.00 17.85           C  
ATOM   4517  CZ  TYR D  18      51.116   2.573  55.701  1.00 16.94           C  
ATOM   4518  OH  TYR D  18      50.034   2.046  55.034  1.00 16.87           O  
ATOM   4519  N   ILE D  19      57.056   6.264  57.360  1.00 10.15           N  
ATOM   4520  CA  ILE D  19      58.144   7.031  57.934  1.00 13.05           C  
ATOM   4521  C   ILE D  19      57.581   8.039  58.922  1.00 12.86           C  
ATOM   4522  O   ILE D  19      56.619   8.749  58.618  1.00 13.82           O  
ATOM   4523  CB  ILE D  19      58.905   7.813  56.831  1.00 10.66           C  
ATOM   4524  CG1 ILE D  19      59.389   6.848  55.752  1.00 10.91           C  
ATOM   4525  CG2 ILE D  19      60.074   8.597  57.446  1.00 12.29           C  
ATOM   4526  CD1 ILE D  19      59.999   7.558  54.539  1.00 14.87           C  
ATOM   4527  N   ALA D  20      58.171   8.075  60.108  1.00 13.80           N  
ATOM   4528  CA  ALA D  20      57.767   9.008  61.146  1.00 14.15           C  
ATOM   4529  C   ALA D  20      58.829  10.094  61.062  1.00 13.62           C  
ATOM   4530  O   ALA D  20      60.012   9.789  61.011  1.00 16.23           O  
ATOM   4531  CB  ALA D  20      57.799   8.325  62.516  1.00 14.14           C  
ATOM   4532  N   PHE D  21      58.419  11.354  61.024  1.00 13.37           N  
ATOM   4533  CA  PHE D  21      59.385  12.434  60.917  1.00 12.41           C  
ATOM   4534  C   PHE D  21      59.042  13.609  61.817  1.00 13.65           C  
ATOM   4535  O   PHE D  21      57.939  13.699  62.358  1.00 14.29           O  
ATOM   4536  CB  PHE D  21      59.485  12.901  59.450  1.00 13.66           C  
ATOM   4537  CG  PHE D  21      58.224  13.554  58.921  1.00 13.27           C  
ATOM   4538  CD1 PHE D  21      58.019  14.923  59.065  1.00 14.70           C  
ATOM   4539  CD2 PHE D  21      57.242  12.797  58.293  1.00 11.55           C  
ATOM   4540  CE1 PHE D  21      56.851  15.529  58.587  1.00 12.46           C  
ATOM   4541  CE2 PHE D  21      56.074  13.392  57.815  1.00 10.20           C  
ATOM   4542  CZ  PHE D  21      55.881  14.760  57.962  1.00 11.38           C  
ATOM   4543  N   GLU D  22      60.018  14.490  61.992  1.00 13.26           N  
ATOM   4544  CA  GLU D  22      59.855  15.694  62.784  1.00 14.50           C  
ATOM   4545  C   GLU D  22      60.470  16.840  61.996  1.00 14.87           C  
ATOM   4546  O   GLU D  22      61.495  16.667  61.333  1.00 16.84           O  
ATOM   4547  CB  GLU D  22      60.566  15.558  64.133  1.00 16.22           C  
ATOM   4548  CG  GLU D  22      60.711  16.884  64.869  1.00 19.30           C  
ATOM   4549  CD  GLU D  22      61.558  16.770  66.126  1.00 21.75           C  
ATOM   4550  OE1 GLU D  22      62.640  16.144  66.068  1.00 23.15           O  
ATOM   4551  OE2 GLU D  22      61.149  17.326  67.163  1.00 22.42           O  
ATOM   4552  N   ILE D  23      59.829  18.000  62.042  1.00 13.75           N  
ATOM   4553  CA  ILE D  23      60.345  19.169  61.354  1.00 11.15           C  
ATOM   4554  C   ILE D  23      60.926  20.101  62.406  1.00 14.03           C  
ATOM   4555  O   ILE D  23      60.255  20.465  63.373  1.00 13.55           O  
ATOM   4556  CB  ILE D  23      59.233  19.920  60.578  1.00 13.33           C  
ATOM   4557  CG1 ILE D  23      58.853  19.136  59.324  1.00 12.17           C  
ATOM   4558  CG2 ILE D  23      59.705  21.330  60.214  1.00 12.89           C  
ATOM   4559  CD1 ILE D  23      57.608  19.672  58.620  1.00 15.69           C  
ATOM   4560  N   ILE D  24      62.189  20.456  62.227  1.00 13.39           N  
ATOM   4561  CA  ILE D  24      62.870  21.354  63.143  1.00 15.41           C  
ATOM   4562  C   ILE D  24      62.864  22.702  62.459  1.00 12.89           C  
ATOM   4563  O   ILE D  24      63.341  22.832  61.336  1.00 12.17           O  
ATOM   4564  CB  ILE D  24      64.318  20.884  63.388  1.00 17.36           C  
ATOM   4565  CG1 ILE D  24      64.285  19.488  64.017  1.00 18.75           C  
ATOM   4566  CG2 ILE D  24      65.048  21.867  64.292  1.00 16.17           C  
ATOM   4567  CD1 ILE D  24      65.588  18.772  63.977  1.00 24.00           C  
ATOM   4568  N   SER D  25      62.292  23.702  63.118  1.00 14.73           N  
ATOM   4569  CA  SER D  25      62.230  25.031  62.531  1.00 13.43           C  
ATOM   4570  C   SER D  25      61.785  26.071  63.542  1.00 15.26           C  
ATOM   4571  O   SER D  25      61.297  25.736  64.620  1.00 15.83           O  
ATOM   4572  CB  SER D  25      61.239  25.042  61.372  1.00 15.69           C  
ATOM   4573  OG  SER D  25      59.917  24.883  61.864  1.00 16.38           O  
ATOM   4574  N   ASP D  26      61.952  27.336  63.175  1.00 15.62           N  
ATOM   4575  CA  ASP D  26      61.537  28.436  64.032  1.00 18.33           C  
ATOM   4576  C   ASP D  26      60.097  28.775  63.681  1.00 17.40           C  
ATOM   4577  O   ASP D  26      59.298  29.092  64.553  1.00 20.04           O  
ATOM   4578  CB  ASP D  26      62.421  29.666  63.809  1.00 16.34           C  
ATOM   4579  CG  ASP D  26      63.843  29.453  64.276  1.00 20.06           C  
ATOM   4580  OD1 ASP D  26      64.050  28.658  65.216  1.00 22.33           O  
ATOM   4581  OD2 ASP D  26      64.753  30.097  63.714  1.00 24.38           O  
ATOM   4582  N   GLY D  27      59.773  28.711  62.393  1.00 18.47           N  
ATOM   4583  CA  GLY D  27      58.419  29.017  61.957  1.00 15.60           C  
ATOM   4584  C   GLY D  27      57.516  27.798  61.986  1.00 16.96           C  
ATOM   4585  O   GLY D  27      57.997  26.665  61.908  1.00 17.96           O  
ATOM   4586  N   ASP D  28      56.210  28.024  62.106  1.00 15.65           N  
ATOM   4587  CA  ASP D  28      55.245  26.936  62.125  1.00 16.34           C  
ATOM   4588  C   ASP D  28      54.930  26.520  60.688  1.00 15.72           C  
ATOM   4589  O   ASP D  28      55.228  27.234  59.726  1.00 17.45           O  
ATOM   4590  CB  ASP D  28      53.919  27.363  62.781  1.00 18.18           C  
ATOM   4591  CG  ASP D  28      54.043  27.678  64.267  1.00 21.93           C  
ATOM   4592  OD1 ASP D  28      54.865  27.049  64.970  1.00 21.06           O  
ATOM   4593  OD2 ASP D  28      53.281  28.552  64.737  1.00 20.88           O  
ATOM   4594  N   PHE D  29      54.310  25.358  60.561  1.00 14.59           N  
ATOM   4595  CA  PHE D  29      53.883  24.835  59.276  1.00 14.78           C  
ATOM   4596  C   PHE D  29      52.499  24.230  59.453  1.00 14.36           C  
ATOM   4597  O   PHE D  29      52.175  23.693  60.520  1.00 15.12           O  
ATOM   4598  CB  PHE D  29      54.835  23.747  58.765  1.00 16.40           C  
ATOM   4599  CG  PHE D  29      56.159  24.270  58.288  1.00 16.35           C  
ATOM   4600  CD1 PHE D  29      57.244  24.348  59.153  1.00 15.34           C  
ATOM   4601  CD2 PHE D  29      56.318  24.685  56.968  1.00 15.11           C  
ATOM   4602  CE1 PHE D  29      58.474  24.833  58.715  1.00 14.99           C  
ATOM   4603  CE2 PHE D  29      57.542  25.173  56.514  1.00 17.58           C  
ATOM   4604  CZ  PHE D  29      58.626  25.248  57.391  1.00 16.43           C  
ATOM   4605  N   THR D  30      51.680  24.336  58.415  1.00 12.02           N  
ATOM   4606  CA  THR D  30      50.341  23.766  58.431  1.00 14.20           C  
ATOM   4607  C   THR D  30      50.405  22.417  57.718  1.00 14.11           C  
ATOM   4608  O   THR D  30      51.365  22.139  56.998  1.00 10.88           O  
ATOM   4609  CB  THR D  30      49.334  24.639  57.666  1.00 16.95           C  
ATOM   4610  OG1 THR D  30      49.674  24.655  56.275  1.00 17.72           O  
ATOM   4611  CG2 THR D  30      49.346  26.063  58.206  1.00 17.17           C  
ATOM   4612  N   LYS D  31      49.382  21.591  57.918  1.00 14.31           N  
ATOM   4613  CA  LYS D  31      49.321  20.285  57.282  1.00 16.20           C  
ATOM   4614  C   LYS D  31      49.478  20.424  55.768  1.00 17.35           C  
ATOM   4615  O   LYS D  31      50.184  19.642  55.140  1.00 17.16           O  
ATOM   4616  CB  LYS D  31      47.987  19.609  57.595  1.00 19.11           C  
ATOM   4617  CG  LYS D  31      47.696  19.498  59.078  1.00 22.91           C  
ATOM   4618  CD  LYS D  31      46.345  18.853  59.336  1.00 26.81           C  
ATOM   4619  CE  LYS D  31      46.022  18.855  60.819  1.00 30.21           C  
ATOM   4620  NZ  LYS D  31      45.843  20.249  61.318  1.00 30.79           N  
ATOM   4621  N   ASP D  32      48.828  21.433  55.189  1.00 19.26           N  
ATOM   4622  CA  ASP D  32      48.893  21.653  53.746  1.00 18.93           C  
ATOM   4623  C   ASP D  32      50.282  22.029  53.245  1.00 17.11           C  
ATOM   4624  O   ASP D  32      50.688  21.594  52.164  1.00 13.84           O  
ATOM   4625  CB  ASP D  32      47.888  22.724  53.315  1.00 23.65           C  
ATOM   4626  CG  ASP D  32      46.444  22.290  53.520  1.00 30.08           C  
ATOM   4627  OD1 ASP D  32      46.130  21.099  53.293  1.00 33.28           O  
ATOM   4628  OD2 ASP D  32      45.616  23.150  53.889  1.00 36.23           O  
ATOM   4629  N   GLU D  33      51.008  22.840  54.011  1.00 13.13           N  
ATOM   4630  CA  GLU D  33      52.355  23.228  53.600  1.00 13.13           C  
ATOM   4631  C   GLU D  33      53.250  21.994  53.564  1.00 12.81           C  
ATOM   4632  O   GLU D  33      54.061  21.841  52.663  1.00 10.20           O  
ATOM   4633  CB  GLU D  33      52.969  24.246  54.564  1.00 12.38           C  
ATOM   4634  CG  GLU D  33      52.353  25.647  54.528  1.00 15.08           C  
ATOM   4635  CD  GLU D  33      53.027  26.576  55.524  1.00 15.93           C  
ATOM   4636  OE1 GLU D  33      53.775  27.479  55.096  1.00 16.35           O  
ATOM   4637  OE2 GLU D  33      52.822  26.385  56.746  1.00 14.02           O  
ATOM   4638  N   VAL D  34      53.109  21.123  54.563  1.00 12.67           N  
ATOM   4639  CA  VAL D  34      53.920  19.911  54.625  1.00 10.54           C  
ATOM   4640  C   VAL D  34      53.593  18.996  53.446  1.00 10.06           C  
ATOM   4641  O   VAL D  34      54.488  18.398  52.844  1.00  9.94           O  
ATOM   4642  CB  VAL D  34      53.694  19.162  55.969  1.00 11.84           C  
ATOM   4643  CG1 VAL D  34      54.563  17.905  56.029  1.00  9.61           C  
ATOM   4644  CG2 VAL D  34      54.017  20.102  57.135  1.00 12.04           C  
ATOM   4645  N   LYS D  35      52.316  18.883  53.104  1.00 11.30           N  
ATOM   4646  CA  LYS D  35      51.930  18.045  51.975  1.00 13.71           C  
ATOM   4647  C   LYS D  35      52.566  18.615  50.712  1.00 14.65           C  
ATOM   4648  O   LYS D  35      53.103  17.883  49.883  1.00 14.43           O  
ATOM   4649  CB  LYS D  35      50.408  18.022  51.810  1.00 17.94           C  
ATOM   4650  CG  LYS D  35      49.913  16.989  50.794  1.00 22.88           C  
ATOM   4651  CD  LYS D  35      48.405  17.083  50.583  1.00 24.79           C  
ATOM   4652  CE  LYS D  35      47.810  15.739  50.146  1.00 28.94           C  
ATOM   4653  NZ  LYS D  35      48.432  15.167  48.913  1.00 31.29           N  
ATOM   4654  N   GLU D  36      52.527  19.938  50.585  1.00 14.78           N  
ATOM   4655  CA  GLU D  36      53.083  20.610  49.423  1.00 14.52           C  
ATOM   4656  C   GLU D  36      54.607  20.525  49.308  1.00 14.93           C  
ATOM   4657  O   GLU D  36      55.132  20.261  48.226  1.00 15.08           O  
ATOM   4658  CB  GLU D  36      52.655  22.078  49.422  1.00 18.79           C  
ATOM   4659  CG  GLU D  36      52.889  22.780  48.100  1.00 27.71           C  
ATOM   4660  CD  GLU D  36      52.327  24.191  48.080  1.00 33.11           C  
ATOM   4661  OE1 GLU D  36      51.191  24.384  48.569  1.00 36.15           O  
ATOM   4662  OE2 GLU D  36      53.016  25.100  47.566  1.00 36.40           O  
ATOM   4663  N   LEU D  37      55.322  20.747  50.408  1.00 14.70           N  
ATOM   4664  CA  LEU D  37      56.783  20.698  50.365  1.00 13.72           C  
ATOM   4665  C   LEU D  37      57.295  19.282  50.080  1.00 15.58           C  
ATOM   4666  O   LEU D  37      58.331  19.117  49.431  1.00 15.16           O  
ATOM   4667  CB  LEU D  37      57.379  21.254  51.667  1.00 13.82           C  
ATOM   4668  CG  LEU D  37      57.372  20.479  52.983  1.00 14.78           C  
ATOM   4669  CD1 LEU D  37      58.594  19.562  53.067  1.00 11.74           C  
ATOM   4670  CD2 LEU D  37      57.418  21.480  54.134  1.00 16.34           C  
ATOM   4671  N   ILE D  38      56.570  18.265  50.546  1.00 12.13           N  
ATOM   4672  CA  ILE D  38      56.973  16.883  50.274  1.00 14.87           C  
ATOM   4673  C   ILE D  38      56.780  16.557  48.780  1.00 15.19           C  
ATOM   4674  O   ILE D  38      57.641  15.931  48.162  1.00 15.25           O  
ATOM   4675  CB  ILE D  38      56.166  15.877  51.133  1.00 12.81           C  
ATOM   4676  CG1 ILE D  38      56.591  15.999  52.599  1.00 13.11           C  
ATOM   4677  CG2 ILE D  38      56.411  14.445  50.647  1.00 12.34           C  
ATOM   4678  CD1 ILE D  38      55.757  15.153  53.545  1.00 11.57           C  
ATOM   4679  N   TRP D  39      55.656  16.970  48.200  1.00 15.48           N  
ATOM   4680  CA  TRP D  39      55.422  16.725  46.771  1.00 18.64           C  
ATOM   4681  C   TRP D  39      56.476  17.471  45.952  1.00 15.81           C  
ATOM   4682  O   TRP D  39      57.006  16.948  44.974  1.00 14.09           O  
ATOM   4683  CB  TRP D  39      54.041  17.229  46.333  1.00 21.45           C  
ATOM   4684  CG  TRP D  39      52.939  16.224  46.426  1.00 31.16           C  
ATOM   4685  CD1 TRP D  39      51.885  16.244  47.295  1.00 31.89           C  
ATOM   4686  CD2 TRP D  39      52.770  15.051  45.616  1.00 34.58           C  
ATOM   4687  NE1 TRP D  39      51.069  15.158  47.077  1.00 36.11           N  
ATOM   4688  CE2 TRP D  39      51.587  14.409  46.052  1.00 37.10           C  
ATOM   4689  CE3 TRP D  39      53.500  14.482  44.563  1.00 37.52           C  
ATOM   4690  CZ2 TRP D  39      51.119  13.222  45.473  1.00 37.96           C  
ATOM   4691  CZ3 TRP D  39      53.032  13.299  43.985  1.00 37.21           C  
ATOM   4692  CH2 TRP D  39      51.854  12.684  44.443  1.00 38.95           C  
ATOM   4693  N   LYS D  40      56.764  18.704  46.362  1.00 15.44           N  
ATOM   4694  CA  LYS D  40      57.730  19.560  45.671  1.00 15.25           C  
ATOM   4695  C   LYS D  40      59.133  18.982  45.660  1.00 14.53           C  
ATOM   4696  O   LYS D  40      59.802  18.964  44.622  1.00 11.91           O  
ATOM   4697  CB  LYS D  40      57.746  20.943  46.323  1.00 18.76           C  
ATOM   4698  CG  LYS D  40      58.736  21.926  45.741  1.00 21.75           C  
ATOM   4699  CD  LYS D  40      58.574  23.269  46.435  1.00 27.50           C  
ATOM   4700  CE  LYS D  40      59.595  24.280  45.968  1.00 28.34           C  
ATOM   4701  NZ  LYS D  40      59.415  25.556  46.718  1.00 35.12           N  
ATOM   4702  N   SER D  41      59.590  18.505  46.809  1.00 12.85           N  
ATOM   4703  CA  SER D  41      60.929  17.940  46.857  1.00 12.98           C  
ATOM   4704  C   SER D  41      60.980  16.640  46.064  1.00 12.77           C  
ATOM   4705  O   SER D  41      61.960  16.369  45.377  1.00 14.06           O  
ATOM   4706  CB  SER D  41      61.370  17.690  48.304  1.00 13.68           C  
ATOM   4707  OG  SER D  41      62.739  17.295  48.350  1.00 17.03           O  
ATOM   4708  N   SER D  42      59.924  15.839  46.147  1.00 12.21           N  
ATOM   4709  CA  SER D  42      59.906  14.577  45.424  1.00 13.26           C  
ATOM   4710  C   SER D  42      60.008  14.800  43.918  1.00 11.25           C  
ATOM   4711  O   SER D  42      60.777  14.136  43.235  1.00 11.04           O  
ATOM   4712  CB  SER D  42      58.631  13.793  45.728  1.00 13.24           C  
ATOM   4713  OG  SER D  42      58.692  12.515  45.101  1.00 14.64           O  
ATOM   4714  N   LEU D  43      59.214  15.732  43.410  1.00 10.57           N  
ATOM   4715  CA  LEU D  43      59.213  16.038  41.986  1.00 12.47           C  
ATOM   4716  C   LEU D  43      60.567  16.540  41.492  1.00 13.50           C  
ATOM   4717  O   LEU D  43      60.983  16.224  40.378  1.00 13.77           O  
ATOM   4718  CB  LEU D  43      58.109  17.061  41.678  1.00 12.29           C  
ATOM   4719  CG  LEU D  43      56.683  16.494  41.730  1.00 13.99           C  
ATOM   4720  CD1 LEU D  43      55.651  17.617  41.651  1.00 16.16           C  
ATOM   4721  CD2 LEU D  43      56.489  15.515  40.572  1.00 14.78           C  
ATOM   4722  N   GLU D  44      61.268  17.312  42.320  1.00 13.17           N  
ATOM   4723  CA  GLU D  44      62.571  17.838  41.928  1.00 14.32           C  
ATOM   4724  C   GLU D  44      63.671  16.777  42.026  1.00 13.46           C  
ATOM   4725  O   GLU D  44      64.430  16.543  41.079  1.00 11.25           O  
ATOM   4726  CB  GLU D  44      62.939  19.020  42.822  1.00 18.34           C  
ATOM   4727  CG  GLU D  44      64.218  19.703  42.422  1.00 25.16           C  
ATOM   4728  CD  GLU D  44      64.703  20.683  43.463  1.00 25.98           C  
ATOM   4729  OE1 GLU D  44      63.852  21.292  44.149  1.00 24.44           O  
ATOM   4730  OE2 GLU D  44      65.938  20.852  43.583  1.00 25.18           O  
ATOM   4731  N   VAL D  45      63.737  16.135  43.188  1.00 10.97           N  
ATOM   4732  CA  VAL D  45      64.740  15.124  43.477  1.00 11.87           C  
ATOM   4733  C   VAL D  45      64.562  13.784  42.777  1.00 12.35           C  
ATOM   4734  O   VAL D  45      65.540  13.195  42.313  1.00 10.12           O  
ATOM   4735  CB  VAL D  45      64.809  14.852  45.005  1.00 11.98           C  
ATOM   4736  CG1 VAL D  45      65.878  13.813  45.300  1.00 11.18           C  
ATOM   4737  CG2 VAL D  45      65.112  16.145  45.746  1.00 13.03           C  
ATOM   4738  N   LEU D  46      63.315  13.314  42.709  1.00 13.31           N  
ATOM   4739  CA  LEU D  46      62.991  12.021  42.117  1.00 13.27           C  
ATOM   4740  C   LEU D  46      62.348  12.129  40.733  1.00 15.57           C  
ATOM   4741  O   LEU D  46      62.279  11.139  39.993  1.00 13.58           O  
ATOM   4742  CB  LEU D  46      62.074  11.248  43.079  1.00 12.41           C  
ATOM   4743  CG  LEU D  46      62.629  11.171  44.513  1.00 12.03           C  
ATOM   4744  CD1 LEU D  46      61.616  10.531  45.462  1.00 11.50           C  
ATOM   4745  CD2 LEU D  46      63.927  10.381  44.492  1.00 14.08           C  
ATOM   4746  N   GLY D  47      61.889  13.332  40.391  1.00 13.82           N  
ATOM   4747  CA  GLY D  47      61.282  13.556  39.094  1.00 14.17           C  
ATOM   4748  C   GLY D  47      59.873  13.014  39.033  1.00 14.32           C  
ATOM   4749  O   GLY D  47      59.381  12.429  39.995  1.00 15.87           O  
ATOM   4750  N   GLU D  48      59.207  13.215  37.906  1.00 13.63           N  
ATOM   4751  CA  GLU D  48      57.851  12.719  37.765  1.00 12.65           C  
ATOM   4752  C   GLU D  48      57.840  11.196  37.817  1.00 12.63           C  
ATOM   4753  O   GLU D  48      56.973  10.599  38.448  1.00 11.45           O  
ATOM   4754  CB  GLU D  48      57.255  13.216  36.447  1.00 14.87           C  
ATOM   4755  CG  GLU D  48      56.922  14.704  36.485  1.00 12.53           C  
ATOM   4756  CD  GLU D  48      57.131  15.389  35.152  1.00 11.67           C  
ATOM   4757  OE1 GLU D  48      57.557  14.723  34.177  1.00 10.98           O  
ATOM   4758  OE2 GLU D  48      56.871  16.605  35.092  1.00 12.53           O  
ATOM   4759  N   THR D  49      58.817  10.572  37.167  1.00 11.09           N  
ATOM   4760  CA  THR D  49      58.890   9.109  37.146  1.00 13.17           C  
ATOM   4761  C   THR D  49      59.229   8.530  38.519  1.00 13.27           C  
ATOM   4762  O   THR D  49      58.560   7.606  39.004  1.00 13.47           O  
ATOM   4763  CB  THR D  49      59.937   8.627  36.120  1.00 14.07           C  
ATOM   4764  OG1 THR D  49      59.613   9.165  34.832  1.00 17.79           O  
ATOM   4765  CG2 THR D  49      59.946   7.090  36.032  1.00 15.98           C  
ATOM   4766  N   GLY D  50      60.274   9.071  39.139  1.00 12.06           N  
ATOM   4767  CA  GLY D  50      60.672   8.600  40.451  1.00 14.25           C  
ATOM   4768  C   GLY D  50      59.574   8.826  41.471  1.00 11.65           C  
ATOM   4769  O   GLY D  50      59.419   8.049  42.408  1.00 12.59           O  
ATOM   4770  N   THR D  51      58.798   9.890  41.296  1.00 12.31           N  
ATOM   4771  CA  THR D  51      57.715  10.164  42.238  1.00 10.07           C  
ATOM   4772  C   THR D  51      56.613   9.109  42.097  1.00 12.26           C  
ATOM   4773  O   THR D  51      56.016   8.691  43.095  1.00  9.38           O  
ATOM   4774  CB  THR D  51      57.152  11.587  42.035  1.00 12.47           C  
ATOM   4775  OG1 THR D  51      58.117  12.548  42.504  1.00  9.50           O  
ATOM   4776  CG2 THR D  51      55.833  11.769  42.802  1.00 14.13           C  
ATOM   4777  N   ALA D  52      56.377   8.654  40.865  1.00 11.31           N  
ATOM   4778  CA  ALA D  52      55.358   7.643  40.585  1.00 13.22           C  
ATOM   4779  C   ALA D  52      55.782   6.272  41.123  1.00 12.97           C  
ATOM   4780  O   ALA D  52      54.943   5.430  41.428  1.00 13.90           O  
ATOM   4781  CB  ALA D  52      55.106   7.558  39.079  1.00 12.30           C  
ATOM   4782  N   ILE D  53      57.092   6.062  41.210  1.00 13.14           N  
ATOM   4783  CA  ILE D  53      57.669   4.825  41.728  1.00 14.17           C  
ATOM   4784  C   ILE D  53      57.672   4.819  43.267  1.00 16.71           C  
ATOM   4785  O   ILE D  53      57.227   3.859  43.899  1.00 17.22           O  
ATOM   4786  CB  ILE D  53      59.130   4.669  41.253  1.00 17.04           C  
ATOM   4787  CG1 ILE D  53      59.176   4.459  39.733  1.00 20.76           C  
ATOM   4788  CG2 ILE D  53      59.807   3.524  42.009  1.00 20.76           C  
ATOM   4789  CD1 ILE D  53      60.576   4.561  39.158  1.00 15.81           C  
ATOM   4790  N   VAL D  54      58.189   5.891  43.862  1.00 17.06           N  
ATOM   4791  CA  VAL D  54      58.268   5.995  45.318  1.00 18.30           C  
ATOM   4792  C   VAL D  54      56.904   6.207  45.981  1.00 17.86           C  
ATOM   4793  O   VAL D  54      56.668   5.745  47.101  1.00 19.41           O  
ATOM   4794  CB  VAL D  54      59.222   7.134  45.728  1.00 19.24           C  
ATOM   4795  CG1 VAL D  54      59.320   7.215  47.245  1.00 20.18           C  
ATOM   4796  CG2 VAL D  54      60.595   6.890  45.130  1.00 18.11           C  
ATOM   4797  N   LYS D  55      56.016   6.897  45.276  1.00 17.27           N  
ATOM   4798  CA  LYS D  55      54.663   7.172  45.741  1.00 17.29           C  
ATOM   4799  C   LYS D  55      54.547   7.840  47.118  1.00 18.13           C  
ATOM   4800  O   LYS D  55      53.792   7.384  47.978  1.00 14.55           O  
ATOM   4801  CB  LYS D  55      53.825   5.882  45.720  1.00 18.76           C  
ATOM   4802  CG  LYS D  55      53.605   5.301  44.318  1.00 22.19           C  
ATOM   4803  CD  LYS D  55      52.671   4.090  44.337  1.00 23.31           C  
ATOM   4804  CE  LYS D  55      53.347   2.862  44.933  1.00 26.14           C  
ATOM   4805  NZ  LYS D  55      54.470   2.380  44.071  1.00 25.68           N  
ATOM   4806  N   PRO D  56      55.279   8.945  47.327  1.00 17.17           N  
ATOM   4807  CA  PRO D  56      55.253   9.683  48.598  1.00 16.32           C  
ATOM   4808  C   PRO D  56      53.802  10.047  48.929  1.00 16.26           C  
ATOM   4809  O   PRO D  56      53.080  10.524  48.055  1.00 14.70           O  
ATOM   4810  CB  PRO D  56      56.061  10.947  48.296  1.00 18.33           C  
ATOM   4811  CG  PRO D  56      56.908  10.576  47.097  1.00 21.50           C  
ATOM   4812  CD  PRO D  56      56.022   9.682  46.288  1.00 17.61           C  
ATOM   4813  N   TRP D  57      53.374   9.825  50.172  1.00 14.38           N  
ATOM   4814  CA  TRP D  57      52.011  10.174  50.563  1.00 15.50           C  
ATOM   4815  C   TRP D  57      51.904  10.523  52.042  1.00 14.44           C  
ATOM   4816  O   TRP D  57      52.072   9.670  52.913  1.00 13.63           O  
ATOM   4817  CB  TRP D  57      51.043   9.034  50.219  1.00 19.23           C  
ATOM   4818  CG  TRP D  57      49.604   9.395  50.422  1.00 23.67           C  
ATOM   4819  CD1 TRP D  57      48.840   9.153  51.530  1.00 26.47           C  
ATOM   4820  CD2 TRP D  57      48.763  10.098  49.501  1.00 28.39           C  
ATOM   4821  NE1 TRP D  57      47.573   9.664  51.353  1.00 27.61           N  
ATOM   4822  CE2 TRP D  57      47.500  10.248  50.116  1.00 29.89           C  
ATOM   4823  CE3 TRP D  57      48.954  10.617  48.210  1.00 32.27           C  
ATOM   4824  CZ2 TRP D  57      46.428  10.899  49.484  1.00 32.70           C  
ATOM   4825  CZ3 TRP D  57      47.886  11.265  47.581  1.00 34.99           C  
ATOM   4826  CH2 TRP D  57      46.640  11.397  48.222  1.00 33.62           C  
ATOM   4827  N   LEU D  58      51.623  11.790  52.316  1.00 15.57           N  
ATOM   4828  CA  LEU D  58      51.495  12.272  53.684  1.00 15.10           C  
ATOM   4829  C   LEU D  58      50.231  11.715  54.339  1.00 15.53           C  
ATOM   4830  O   LEU D  58      49.115  12.011  53.914  1.00 17.34           O  
ATOM   4831  CB  LEU D  58      51.454  13.800  53.693  1.00 13.31           C  
ATOM   4832  CG  LEU D  58      51.397  14.484  55.063  1.00 15.69           C  
ATOM   4833  CD1 LEU D  58      52.667  14.186  55.847  1.00 11.51           C  
ATOM   4834  CD2 LEU D  58      51.226  15.985  54.870  1.00 15.14           C  
ATOM   4835  N   ILE D  59      50.422  10.903  55.371  1.00 14.36           N  
ATOM   4836  CA  ILE D  59      49.321  10.289  56.108  1.00 14.51           C  
ATOM   4837  C   ILE D  59      48.742  11.282  57.108  1.00 15.04           C  
ATOM   4838  O   ILE D  59      47.534  11.454  57.198  1.00 15.50           O  
ATOM   4839  CB  ILE D  59      49.805   9.024  56.869  1.00 12.79           C  
ATOM   4840  CG1 ILE D  59      50.136   7.902  55.866  1.00 12.19           C  
ATOM   4841  CG2 ILE D  59      48.757   8.578  57.873  1.00 12.61           C  
ATOM   4842  CD1 ILE D  59      48.960   7.459  55.018  1.00 11.61           C  
ATOM   4843  N   LYS D  60      49.611  11.932  57.867  1.00 15.18           N  
ATOM   4844  CA  LYS D  60      49.163  12.921  58.842  1.00 15.57           C  
ATOM   4845  C   LYS D  60      50.317  13.773  59.338  1.00 15.33           C  
ATOM   4846  O   LYS D  60      51.463  13.320  59.401  1.00 15.47           O  
ATOM   4847  CB  LYS D  60      48.499  12.249  60.046  1.00 18.68           C  
ATOM   4848  CG  LYS D  60      47.965  13.249  61.067  1.00 24.65           C  
ATOM   4849  CD  LYS D  60      47.350  12.578  62.280  1.00 29.29           C  
ATOM   4850  CE  LYS D  60      46.723  13.620  63.204  1.00 33.65           C  
ATOM   4851  NZ  LYS D  60      46.179  13.031  64.457  1.00 35.76           N  
ATOM   4852  N   PHE D  61      50.004  15.019  59.668  1.00 14.60           N  
ATOM   4853  CA  PHE D  61      50.990  15.938  60.206  1.00 14.08           C  
ATOM   4854  C   PHE D  61      50.359  16.642  61.400  1.00 14.16           C  
ATOM   4855  O   PHE D  61      49.232  17.134  61.314  1.00 15.40           O  
ATOM   4856  CB  PHE D  61      51.406  16.983  59.181  1.00 12.93           C  
ATOM   4857  CG  PHE D  61      52.355  18.017  59.738  1.00 13.97           C  
ATOM   4858  CD1 PHE D  61      53.638  17.656  60.138  1.00 10.58           C  
ATOM   4859  CD2 PHE D  61      51.949  19.343  59.897  1.00 14.11           C  
ATOM   4860  CE1 PHE D  61      54.507  18.595  60.689  1.00 14.57           C  
ATOM   4861  CE2 PHE D  61      52.816  20.296  60.452  1.00 12.47           C  
ATOM   4862  CZ  PHE D  61      54.095  19.922  60.846  1.00 13.95           C  
ATOM   4863  N   ASP D  62      51.080  16.660  62.516  1.00 13.31           N  
ATOM   4864  CA  ASP D  62      50.611  17.322  63.739  1.00 13.14           C  
ATOM   4865  C   ASP D  62      51.325  18.666  63.866  1.00 11.89           C  
ATOM   4866  O   ASP D  62      52.496  18.718  64.231  1.00 11.44           O  
ATOM   4867  CB  ASP D  62      50.931  16.477  64.975  1.00 13.25           C  
ATOM   4868  CG  ASP D  62      50.661  17.229  66.271  1.00 16.24           C  
ATOM   4869  OD1 ASP D  62      49.607  17.888  66.356  1.00 16.60           O  
ATOM   4870  OD2 ASP D  62      51.492  17.162  67.199  1.00 19.42           O  
ATOM   4871  N   PRO D  63      50.631  19.770  63.563  1.00 12.69           N  
ATOM   4872  CA  PRO D  63      51.275  21.083  63.668  1.00 13.15           C  
ATOM   4873  C   PRO D  63      51.826  21.414  65.058  1.00 11.88           C  
ATOM   4874  O   PRO D  63      52.829  22.113  65.171  1.00 12.16           O  
ATOM   4875  CB  PRO D  63      50.166  22.047  63.239  1.00 14.68           C  
ATOM   4876  CG  PRO D  63      49.372  21.232  62.277  1.00 17.67           C  
ATOM   4877  CD  PRO D  63      49.289  19.888  62.974  1.00 12.58           C  
ATOM   4878  N   ASN D  64      51.189  20.907  66.114  1.00 12.88           N  
ATOM   4879  CA  ASN D  64      51.636  21.207  67.477  1.00 14.24           C  
ATOM   4880  C   ASN D  64      53.076  20.783  67.761  1.00 15.39           C  
ATOM   4881  O   ASN D  64      53.887  21.599  68.207  1.00 10.84           O  
ATOM   4882  CB  ASN D  64      50.702  20.557  68.514  1.00 15.23           C  
ATOM   4883  CG  ASN D  64      50.847  21.174  69.914  1.00 15.63           C  
ATOM   4884  OD1 ASN D  64      50.586  20.512  70.924  1.00 17.21           O  
ATOM   4885  ND2 ASN D  64      51.235  22.450  69.974  1.00  9.30           N  
ATOM   4886  N   THR D  65      53.391  19.508  67.511  1.00 15.90           N  
ATOM   4887  CA  THR D  65      54.737  18.991  67.750  1.00 14.98           C  
ATOM   4888  C   THR D  65      55.597  18.965  66.487  1.00 16.20           C  
ATOM   4889  O   THR D  65      56.786  18.627  66.542  1.00 12.27           O  
ATOM   4890  CB  THR D  65      54.705  17.554  68.294  1.00 16.45           C  
ATOM   4891  OG1 THR D  65      53.946  16.730  67.398  1.00 13.99           O  
ATOM   4892  CG2 THR D  65      54.096  17.514  69.697  1.00 14.47           C  
ATOM   4893  N   LYS D  66      54.994  19.326  65.361  1.00 14.46           N  
ATOM   4894  CA  LYS D  66      55.687  19.322  64.080  1.00 16.13           C  
ATOM   4895  C   LYS D  66      56.197  17.917  63.750  1.00 15.00           C  
ATOM   4896  O   LYS D  66      57.327  17.751  63.291  1.00 15.18           O  
ATOM   4897  CB  LYS D  66      56.866  20.295  64.092  1.00 15.34           C  
ATOM   4898  CG  LYS D  66      56.490  21.765  64.223  1.00 19.60           C  
ATOM   4899  CD  LYS D  66      57.756  22.600  64.281  1.00 20.78           C  
ATOM   4900  CE  LYS D  66      57.478  24.063  64.477  1.00 20.21           C  
ATOM   4901  NZ  LYS D  66      58.762  24.798  64.578  1.00 20.02           N  
ATOM   4902  N   THR D  67      55.372  16.909  64.010  1.00 14.56           N  
ATOM   4903  CA  THR D  67      55.739  15.533  63.697  1.00 13.64           C  
ATOM   4904  C   THR D  67      54.685  15.004  62.734  1.00 13.13           C  
ATOM   4905  O   THR D  67      53.575  15.528  62.668  1.00 13.02           O  
ATOM   4906  CB  THR D  67      55.785  14.625  64.958  1.00 12.40           C  
ATOM   4907  OG1 THR D  67      54.533  14.688  65.642  1.00 12.68           O  
ATOM   4908  CG2 THR D  67      56.902  15.056  65.895  1.00 12.94           C  
ATOM   4909  N   GLY D  68      55.026  13.968  61.978  1.00 12.14           N  
ATOM   4910  CA  GLY D  68      54.063  13.436  61.045  1.00  9.48           C  
ATOM   4911  C   GLY D  68      54.432  12.072  60.510  1.00 11.79           C  
ATOM   4912  O   GLY D  68      55.474  11.509  60.846  1.00 11.30           O  
ATOM   4913  N   ILE D  69      53.559  11.554  59.659  1.00 13.40           N  
ATOM   4914  CA  ILE D  69      53.747  10.253  59.045  1.00 12.06           C  
ATOM   4915  C   ILE D  69      53.647  10.386  57.542  1.00 11.05           C  
ATOM   4916  O   ILE D  69      52.674  10.940  57.032  1.00 12.54           O  
ATOM   4917  CB  ILE D  69      52.662   9.253  59.502  1.00  9.75           C  
ATOM   4918  CG1 ILE D  69      52.772   9.021  61.013  1.00  9.69           C  
ATOM   4919  CG2 ILE D  69      52.818   7.935  58.753  1.00 11.14           C  
ATOM   4920  CD1 ILE D  69      51.719   8.117  61.576  1.00 11.77           C  
ATOM   4921  N   VAL D  70      54.665   9.908  56.832  1.00 10.44           N  
ATOM   4922  CA  VAL D  70      54.614   9.933  55.387  1.00 11.49           C  
ATOM   4923  C   VAL D  70      54.847   8.508  54.896  1.00 13.39           C  
ATOM   4924  O   VAL D  70      55.740   7.806  55.387  1.00 13.03           O  
ATOM   4925  CB  VAL D  70      55.655  10.886  54.771  1.00 12.27           C  
ATOM   4926  CG1 VAL D  70      57.070  10.389  55.030  1.00 11.74           C  
ATOM   4927  CG2 VAL D  70      55.378  11.022  53.270  1.00 13.04           C  
ATOM   4928  N   ARG D  71      54.022   8.088  53.938  1.00 13.34           N  
ATOM   4929  CA  ARG D  71      54.090   6.745  53.363  1.00 12.86           C  
ATOM   4930  C   ARG D  71      54.907   6.698  52.070  1.00 13.88           C  
ATOM   4931  O   ARG D  71      55.009   7.686  51.340  1.00 13.24           O  
ATOM   4932  CB  ARG D  71      52.664   6.244  53.087  1.00 14.35           C  
ATOM   4933  CG  ARG D  71      52.560   4.802  52.602  1.00 15.72           C  
ATOM   4934  CD  ARG D  71      51.109   4.459  52.244  1.00 19.32           C  
ATOM   4935  NE  ARG D  71      50.710   5.063  50.976  1.00 22.75           N  
ATOM   4936  CZ  ARG D  71      49.467   5.428  50.670  1.00 25.20           C  
ATOM   4937  NH1 ARG D  71      48.484   5.254  51.541  1.00 27.47           N  
ATOM   4938  NH2 ARG D  71      49.204   5.970  49.487  1.00 26.59           N  
ATOM   4939  N   SER D  72      55.499   5.546  51.788  1.00 11.58           N  
ATOM   4940  CA  SER D  72      56.272   5.394  50.565  1.00 12.47           C  
ATOM   4941  C   SER D  72      56.209   3.948  50.109  1.00 13.08           C  
ATOM   4942  O   SER D  72      55.858   3.056  50.896  1.00 11.62           O  
ATOM   4943  CB  SER D  72      57.733   5.793  50.797  1.00 14.66           C  
ATOM   4944  OG  SER D  72      58.564   4.663  50.982  1.00 16.87           O  
ATOM   4945  N   ASP D  73      56.532   3.710  48.841  1.00 12.25           N  
ATOM   4946  CA  ASP D  73      56.553   2.334  48.348  1.00 13.40           C  
ATOM   4947  C   ASP D  73      57.524   1.646  49.303  1.00 12.82           C  
ATOM   4948  O   ASP D  73      58.537   2.225  49.685  1.00 11.83           O  
ATOM   4949  CB  ASP D  73      57.100   2.266  46.914  1.00 11.90           C  
ATOM   4950  CG  ASP D  73      57.104   0.844  46.356  1.00 15.55           C  
ATOM   4951  OD1 ASP D  73      56.198   0.510  45.562  1.00 16.26           O  
ATOM   4952  OD2 ASP D  73      58.001   0.055  46.727  1.00 16.94           O  
ATOM   4953  N   ARG D  74      57.198   0.421  49.695  1.00 13.72           N  
ATOM   4954  CA  ARG D  74      58.013  -0.355  50.622  1.00 15.92           C  
ATOM   4955  C   ARG D  74      59.507  -0.427  50.280  1.00 14.67           C  
ATOM   4956  O   ARG D  74      60.355  -0.325  51.162  1.00 13.33           O  
ATOM   4957  CB  ARG D  74      57.455  -1.783  50.712  1.00 18.81           C  
ATOM   4958  CG  ARG D  74      58.273  -2.741  51.578  1.00 23.31           C  
ATOM   4959  CD  ARG D  74      57.818  -4.199  51.411  1.00 25.15           C  
ATOM   4960  NE  ARG D  74      58.216  -4.782  50.124  1.00 27.58           N  
ATOM   4961  CZ  ARG D  74      58.117  -6.078  49.826  1.00 30.80           C  
ATOM   4962  NH1 ARG D  74      57.628  -6.934  50.720  1.00 29.95           N  
ATOM   4963  NH2 ARG D  74      58.516  -6.526  48.641  1.00 29.89           N  
ATOM   4964  N   GLU D  75      59.822  -0.596  49.004  1.00 12.80           N  
ATOM   4965  CA  GLU D  75      61.209  -0.755  48.584  1.00 14.45           C  
ATOM   4966  C   GLU D  75      62.052   0.477  48.279  1.00 14.04           C  
ATOM   4967  O   GLU D  75      63.222   0.332  47.943  1.00 13.18           O  
ATOM   4968  CB  GLU D  75      61.253  -1.716  47.382  1.00 18.27           C  
ATOM   4969  CG  GLU D  75      61.012  -3.174  47.776  1.00 24.21           C  
ATOM   4970  CD  GLU D  75      60.790  -4.101  46.584  1.00 26.92           C  
ATOM   4971  OE1 GLU D  75      61.404  -3.880  45.518  1.00 27.82           O  
ATOM   4972  OE2 GLU D  75      60.005  -5.063  46.727  1.00 30.89           O  
ATOM   4973  N   TYR D  76      61.487   1.675  48.422  1.00 11.65           N  
ATOM   4974  CA  TYR D  76      62.225   2.900  48.108  1.00 12.14           C  
ATOM   4975  C   TYR D  76      62.261   3.921  49.241  1.00 12.19           C  
ATOM   4976  O   TYR D  76      62.404   5.125  49.012  1.00  8.37           O  
ATOM   4977  CB  TYR D  76      61.636   3.553  46.841  1.00 12.12           C  
ATOM   4978  CG  TYR D  76      61.743   2.669  45.615  1.00 16.38           C  
ATOM   4979  CD1 TYR D  76      60.757   1.725  45.318  1.00 14.06           C  
ATOM   4980  CD2 TYR D  76      62.867   2.726  44.791  1.00 17.18           C  
ATOM   4981  CE1 TYR D  76      60.892   0.858  44.239  1.00 19.70           C  
ATOM   4982  CE2 TYR D  76      63.013   1.859  43.706  1.00 18.58           C  
ATOM   4983  CZ  TYR D  76      62.026   0.930  43.438  1.00 20.06           C  
ATOM   4984  OH  TYR D  76      62.173   0.077  42.369  1.00 23.45           O  
ATOM   4985  N   VAL D  77      62.144   3.434  50.468  1.00 11.34           N  
ATOM   4986  CA  VAL D  77      62.175   4.312  51.622  1.00 11.66           C  
ATOM   4987  C   VAL D  77      63.401   5.232  51.643  1.00 12.00           C  
ATOM   4988  O   VAL D  77      63.277   6.410  51.996  1.00 10.96           O  
ATOM   4989  CB  VAL D  77      62.126   3.489  52.940  1.00 11.82           C  
ATOM   4990  CG1 VAL D  77      62.271   4.402  54.141  1.00 14.46           C  
ATOM   4991  CG2 VAL D  77      60.806   2.725  53.023  1.00 13.35           C  
ATOM   4992  N   GLU D  78      64.576   4.729  51.255  1.00 10.04           N  
ATOM   4993  CA  GLU D  78      65.774   5.578  51.309  1.00 10.66           C  
ATOM   4994  C   GLU D  78      65.739   6.732  50.316  1.00 11.44           C  
ATOM   4995  O   GLU D  78      66.371   7.775  50.532  1.00  9.37           O  
ATOM   4996  CB  GLU D  78      67.052   4.755  51.103  1.00 12.88           C  
ATOM   4997  CG  GLU D  78      67.248   3.592  52.087  1.00 11.09           C  
ATOM   4998  CD  GLU D  78      67.142   3.995  53.556  1.00 16.12           C  
ATOM   4999  OE1 GLU D  78      67.672   5.057  53.938  1.00 16.18           O  
ATOM   5000  OE2 GLU D  78      66.544   3.227  54.339  1.00 14.07           O  
ATOM   5001  N   TYR D  79      65.010   6.552  49.221  1.00 10.82           N  
ATOM   5002  CA  TYR D  79      64.903   7.615  48.235  1.00 11.21           C  
ATOM   5003  C   TYR D  79      63.980   8.701  48.763  1.00 11.66           C  
ATOM   5004  O   TYR D  79      64.209   9.879  48.521  1.00 12.50           O  
ATOM   5005  CB  TYR D  79      64.399   7.062  46.898  1.00 11.32           C  
ATOM   5006  CG  TYR D  79      65.475   6.276  46.197  1.00 12.41           C  
ATOM   5007  CD1 TYR D  79      65.650   4.913  46.449  1.00 11.98           C  
ATOM   5008  CD2 TYR D  79      66.389   6.916  45.355  1.00 12.67           C  
ATOM   5009  CE1 TYR D  79      66.710   4.207  45.888  1.00 13.53           C  
ATOM   5010  CE2 TYR D  79      67.461   6.219  44.788  1.00 15.70           C  
ATOM   5011  CZ  TYR D  79      67.616   4.867  45.062  1.00 17.21           C  
ATOM   5012  OH  TYR D  79      68.693   4.184  44.546  1.00 16.58           O  
ATOM   5013  N   LEU D  80      62.936   8.322  49.490  1.00 13.04           N  
ATOM   5014  CA  LEU D  80      62.056   9.344  50.039  1.00 12.92           C  
ATOM   5015  C   LEU D  80      62.801  10.044  51.186  1.00 12.25           C  
ATOM   5016  O   LEU D  80      62.682  11.256  51.377  1.00 11.06           O  
ATOM   5017  CB  LEU D  80      60.744   8.740  50.543  1.00 13.20           C  
ATOM   5018  CG  LEU D  80      59.773   9.767  51.158  1.00 15.96           C  
ATOM   5019  CD1 LEU D  80      59.575  10.921  50.199  1.00 16.50           C  
ATOM   5020  CD2 LEU D  80      58.442   9.113  51.469  1.00 14.63           C  
ATOM   5021  N   ARG D  81      63.572   9.279  51.953  1.00 12.70           N  
ATOM   5022  CA  ARG D  81      64.325   9.870  53.056  1.00 12.63           C  
ATOM   5023  C   ARG D  81      65.317  10.892  52.489  1.00 13.16           C  
ATOM   5024  O   ARG D  81      65.548  11.950  53.084  1.00 10.59           O  
ATOM   5025  CB  ARG D  81      65.030   8.759  53.851  1.00 15.18           C  
ATOM   5026  CG  ARG D  81      66.201   9.202  54.692  1.00 19.46           C  
ATOM   5027  CD  ARG D  81      66.136   8.665  56.123  1.00 21.79           C  
ATOM   5028  NE  ARG D  81      65.736   7.266  56.252  1.00 22.47           N  
ATOM   5029  CZ  ARG D  81      65.567   6.662  57.426  1.00 22.49           C  
ATOM   5030  NH1 ARG D  81      65.764   7.338  58.542  1.00 24.46           N  
ATOM   5031  NH2 ARG D  81      65.206   5.389  57.490  1.00 26.40           N  
ATOM   5032  N   PHE D  82      65.860  10.586  51.312  1.00 12.80           N  
ATOM   5033  CA  PHE D  82      66.822  11.462  50.634  1.00 13.39           C  
ATOM   5034  C   PHE D  82      66.149  12.764  50.181  1.00 12.19           C  
ATOM   5035  O   PHE D  82      66.670  13.863  50.410  1.00 11.57           O  
ATOM   5036  CB  PHE D  82      67.430  10.715  49.432  1.00 13.63           C  
ATOM   5037  CG  PHE D  82      68.446  11.508  48.665  1.00 13.68           C  
ATOM   5038  CD1 PHE D  82      69.617  11.947  49.277  1.00 14.39           C  
ATOM   5039  CD2 PHE D  82      68.233  11.816  47.323  1.00 14.77           C  
ATOM   5040  CE1 PHE D  82      70.560  12.684  48.561  1.00 15.00           C  
ATOM   5041  CE2 PHE D  82      69.173  12.553  46.595  1.00 13.84           C  
ATOM   5042  CZ  PHE D  82      70.333  12.988  47.210  1.00 14.21           C  
ATOM   5043  N   ALA D  83      64.985  12.640  49.545  1.00 11.89           N  
ATOM   5044  CA  ALA D  83      64.241  13.818  49.093  1.00 11.84           C  
ATOM   5045  C   ALA D  83      63.868  14.720  50.280  1.00 10.93           C  
ATOM   5046  O   ALA D  83      63.914  15.945  50.179  1.00 10.39           O  
ATOM   5047  CB  ALA D  83      62.988  13.386  48.364  1.00 11.60           C  
ATOM   5048  N   LEU D  84      63.499  14.109  51.402  1.00  9.45           N  
ATOM   5049  CA  LEU D  84      63.125  14.877  52.591  1.00 11.80           C  
ATOM   5050  C   LEU D  84      64.338  15.595  53.179  1.00 13.70           C  
ATOM   5051  O   LEU D  84      64.234  16.736  53.631  1.00 11.35           O  
ATOM   5052  CB  LEU D  84      62.520  13.963  53.666  1.00 13.00           C  
ATOM   5053  CG  LEU D  84      61.213  13.217  53.355  1.00 15.47           C  
ATOM   5054  CD1 LEU D  84      60.851  12.329  54.540  1.00 15.50           C  
ATOM   5055  CD2 LEU D  84      60.090  14.203  53.056  1.00 15.44           C  
ATOM   5056  N   MET D  85      65.484  14.911  53.170  1.00 13.48           N  
ATOM   5057  CA  MET D  85      66.731  15.458  53.701  1.00 13.44           C  
ATOM   5058  C   MET D  85      67.209  16.673  52.916  1.00 11.62           C  
ATOM   5059  O   MET D  85      67.801  17.577  53.494  1.00  9.13           O  
ATOM   5060  CB  MET D  85      67.829  14.377  53.703  1.00 16.86           C  
ATOM   5061  CG  MET D  85      69.201  14.855  54.185  1.00 20.19           C  
ATOM   5062  SD  MET D  85      70.376  13.490  54.478  1.00 23.35           S  
ATOM   5063  CE  MET D  85      70.035  12.471  53.044  1.00 15.56           C  
ATOM   5064  N   LEU D  86      66.952  16.695  51.605  1.00 10.88           N  
ATOM   5065  CA  LEU D  86      67.387  17.814  50.776  1.00 11.76           C  
ATOM   5066  C   LEU D  86      66.546  19.074  50.945  1.00 15.00           C  
ATOM   5067  O   LEU D  86      66.871  20.113  50.377  1.00 16.36           O  
ATOM   5068  CB  LEU D  86      67.437  17.408  49.297  1.00 13.30           C  
ATOM   5069  CG  LEU D  86      68.487  16.334  48.989  1.00 14.97           C  
ATOM   5070  CD1 LEU D  86      68.498  15.991  47.497  1.00 15.75           C  
ATOM   5071  CD2 LEU D  86      69.840  16.844  49.414  1.00 16.74           C  
ATOM   5072  N   VAL D  87      65.466  18.991  51.719  1.00 13.56           N  
ATOM   5073  CA  VAL D  87      64.636  20.175  51.948  1.00 15.41           C  
ATOM   5074  C   VAL D  87      65.368  21.117  52.907  1.00 13.43           C  
ATOM   5075  O   VAL D  87      65.879  20.679  53.936  1.00 13.39           O  
ATOM   5076  CB  VAL D  87      63.270  19.803  52.571  1.00 12.29           C  
ATOM   5077  CG1 VAL D  87      62.498  21.065  52.924  1.00 14.65           C  
ATOM   5078  CG2 VAL D  87      62.480  18.952  51.595  1.00 13.22           C  
ATOM   5079  N   SER D  88      65.432  22.401  52.559  1.00 13.70           N  
ATOM   5080  CA  SER D  88      66.102  23.386  53.408  1.00 13.91           C  
ATOM   5081  C   SER D  88      65.164  24.534  53.809  1.00 15.01           C  
ATOM   5082  O   SER D  88      65.369  25.189  54.834  1.00 13.63           O  
ATOM   5083  CB  SER D  88      67.347  23.939  52.705  1.00 15.61           C  
ATOM   5084  OG  SER D  88      67.025  24.479  51.435  1.00 17.14           O  
ATOM   5085  N   GLU D  89      64.143  24.788  52.999  1.00 14.66           N  
ATOM   5086  CA  GLU D  89      63.182  25.829  53.340  1.00 20.51           C  
ATOM   5087  C   GLU D  89      61.907  25.797  52.510  1.00 18.90           C  
ATOM   5088  O   GLU D  89      61.889  25.305  51.385  1.00 20.37           O  
ATOM   5089  CB  GLU D  89      63.816  27.221  53.262  1.00 25.11           C  
ATOM   5090  CG  GLU D  89      64.186  27.708  51.893  1.00 29.80           C  
ATOM   5091  CD  GLU D  89      64.571  29.178  51.920  1.00 36.65           C  
ATOM   5092  OE1 GLU D  89      63.673  30.022  52.122  1.00 37.43           O  
ATOM   5093  OE2 GLU D  89      65.774  29.489  51.758  1.00 39.90           O  
ATOM   5094  N   PHE D  90      60.838  26.323  53.089  1.00 18.14           N  
ATOM   5095  CA  PHE D  90      59.555  26.361  52.410  1.00 17.21           C  
ATOM   5096  C   PHE D  90      58.798  27.601  52.862  1.00 16.80           C  
ATOM   5097  O   PHE D  90      58.699  27.882  54.056  1.00 12.69           O  
ATOM   5098  CB  PHE D  90      58.739  25.107  52.729  1.00 17.25           C  
ATOM   5099  CG  PHE D  90      57.564  24.920  51.826  1.00 19.25           C  
ATOM   5100  CD1 PHE D  90      57.751  24.610  50.482  1.00 18.87           C  
ATOM   5101  CD2 PHE D  90      56.271  25.098  52.300  1.00 17.07           C  
ATOM   5102  CE1 PHE D  90      56.661  24.483  49.619  1.00 19.30           C  
ATOM   5103  CE2 PHE D  90      55.175  24.974  51.448  1.00 20.69           C  
ATOM   5104  CZ  PHE D  90      55.372  24.666  50.104  1.00 17.95           C  
ATOM   5105  N   ASN D  91      58.265  28.337  51.895  1.00 18.44           N  
ATOM   5106  CA  ASN D  91      57.532  29.558  52.182  1.00 19.41           C  
ATOM   5107  C   ASN D  91      58.318  30.514  53.070  1.00 20.41           C  
ATOM   5108  O   ASN D  91      57.761  31.096  53.998  1.00 20.89           O  
ATOM   5109  CB  ASN D  91      56.186  29.243  52.837  1.00 21.51           C  
ATOM   5110  CG  ASN D  91      55.180  28.688  51.856  1.00 25.00           C  
ATOM   5111  OD1 ASN D  91      55.224  29.003  50.666  1.00 26.47           O  
ATOM   5112  ND2 ASN D  91      54.256  27.870  52.348  1.00 26.23           N  
ATOM   5113  N   GLY D  92      59.611  30.662  52.788  1.00 20.24           N  
ATOM   5114  CA  GLY D  92      60.445  31.574  53.553  1.00 21.72           C  
ATOM   5115  C   GLY D  92      60.873  31.115  54.932  1.00 21.56           C  
ATOM   5116  O   GLY D  92      61.532  31.864  55.660  1.00 20.39           O  
ATOM   5117  N   LYS D  93      60.517  29.891  55.302  1.00 17.81           N  
ATOM   5118  CA  LYS D  93      60.881  29.370  56.614  1.00 15.41           C  
ATOM   5119  C   LYS D  93      61.893  28.245  56.484  1.00 16.05           C  
ATOM   5120  O   LYS D  93      61.638  27.255  55.805  1.00 15.03           O  
ATOM   5121  CB  LYS D  93      59.630  28.871  57.341  1.00 14.54           C  
ATOM   5122  CG  LYS D  93      58.673  29.999  57.734  1.00 13.72           C  
ATOM   5123  CD  LYS D  93      57.301  29.485  58.135  1.00 13.97           C  
ATOM   5124  CE  LYS D  93      56.588  28.844  56.954  1.00 12.60           C  
ATOM   5125  NZ  LYS D  93      55.147  28.623  57.245  1.00 11.23           N  
ATOM   5126  N   ARG D  94      63.047  28.410  57.127  1.00 15.84           N  
ATOM   5127  CA  ARG D  94      64.091  27.394  57.071  1.00 17.46           C  
ATOM   5128  C   ARG D  94      63.663  26.210  57.916  1.00 16.98           C  
ATOM   5129  O   ARG D  94      62.925  26.366  58.887  1.00 15.31           O  
ATOM   5130  CB  ARG D  94      65.424  27.940  57.596  1.00 21.83           C  
ATOM   5131  CG  ARG D  94      65.927  29.153  56.838  1.00 26.22           C  
ATOM   5132  CD  ARG D  94      67.387  29.417  57.109  1.00 30.16           C  
ATOM   5133  NE  ARG D  94      68.234  28.373  56.535  1.00 35.65           N  
ATOM   5134  CZ  ARG D  94      69.557  28.453  56.439  1.00 36.30           C  
ATOM   5135  NH1 ARG D  94      70.194  29.535  56.875  1.00 39.00           N  
ATOM   5136  NH2 ARG D  94      70.247  27.451  55.912  1.00 38.10           N  
ATOM   5137  N   LEU D  95      64.120  25.020  57.548  1.00 13.10           N  
ATOM   5138  CA  LEU D  95      63.751  23.852  58.318  1.00 13.84           C  
ATOM   5139  C   LEU D  95      64.668  22.673  58.074  1.00 12.00           C  
ATOM   5140  O   LEU D  95      65.430  22.641  57.114  1.00 14.02           O  
ATOM   5141  CB  LEU D  95      62.311  23.429  57.997  1.00 14.44           C  
ATOM   5142  CG  LEU D  95      62.058  22.708  56.663  1.00 17.72           C  
ATOM   5143  CD1 LEU D  95      60.818  21.833  56.765  1.00 19.33           C  
ATOM   5144  CD2 LEU D  95      61.903  23.714  55.558  1.00 15.94           C  
ATOM   5145  N   ILE D  96      64.585  21.706  58.971  1.00 12.71           N  
ATOM   5146  CA  ILE D  96      65.339  20.474  58.847  1.00 12.38           C  
ATOM   5147  C   ILE D  96      64.323  19.377  59.100  1.00 15.44           C  
ATOM   5148  O   ILE D  96      63.613  19.405  60.116  1.00 16.55           O  
ATOM   5149  CB  ILE D  96      66.438  20.329  59.914  1.00 13.22           C  
ATOM   5150  CG1 ILE D  96      67.508  21.402  59.738  1.00 11.60           C  
ATOM   5151  CG2 ILE D  96      67.051  18.939  59.827  1.00 11.30           C  
ATOM   5152  CD1 ILE D  96      68.542  21.401  60.863  1.00 17.56           C  
ATOM   5153  N   ILE D  97      64.216  18.439  58.169  1.00 13.64           N  
ATOM   5154  CA  ILE D  97      63.312  17.329  58.369  1.00 14.33           C  
ATOM   5155  C   ILE D  97      64.197  16.205  58.867  1.00 17.03           C  
ATOM   5156  O   ILE D  97      65.255  15.937  58.302  1.00 18.27           O  
ATOM   5157  CB  ILE D  97      62.603  16.882  57.077  1.00 16.23           C  
ATOM   5158  CG1 ILE D  97      61.713  18.012  56.545  1.00 14.56           C  
ATOM   5159  CG2 ILE D  97      61.755  15.642  57.377  1.00 15.08           C  
ATOM   5160  CD1 ILE D  97      61.070  17.725  55.194  1.00 17.55           C  
ATOM   5161  N   ARG D  98      63.773  15.574  59.949  1.00 16.06           N  
ATOM   5162  CA  ARG D  98      64.528  14.486  60.535  1.00 18.71           C  
ATOM   5163  C   ARG D  98      63.631  13.264  60.618  1.00 17.63           C  
ATOM   5164  O   ARG D  98      62.511  13.346  61.118  1.00 17.02           O  
ATOM   5165  CB  ARG D  98      64.992  14.898  61.929  1.00 21.68           C  
ATOM   5166  CG  ARG D  98      65.486  13.770  62.791  1.00 27.28           C  
ATOM   5167  CD  ARG D  98      65.370  14.150  64.244  1.00 28.11           C  
ATOM   5168  NE  ARG D  98      65.580  12.992  65.103  1.00 35.18           N  
ATOM   5169  CZ  ARG D  98      65.348  12.992  66.407  1.00 31.43           C  
ATOM   5170  NH1 ARG D  98      64.899  14.091  66.997  1.00 35.54           N  
ATOM   5171  NH2 ARG D  98      65.552  11.894  67.113  1.00 35.41           N  
ATOM   5172  N   THR D  99      64.121  12.132  60.124  1.00 17.18           N  
ATOM   5173  CA  THR D  99      63.345  10.901  60.175  1.00 19.53           C  
ATOM   5174  C   THR D  99      63.553  10.230  61.529  1.00 20.17           C  
ATOM   5175  O   THR D  99      64.689   9.994  61.936  1.00 19.61           O  
ATOM   5176  CB  THR D  99      63.765   9.928  59.053  1.00 20.62           C  
ATOM   5177  OG1 THR D  99      63.294  10.433  57.796  1.00 24.66           O  
ATOM   5178  CG2 THR D  99      63.168   8.535  59.289  1.00 23.16           C  
ATOM   5179  N   LEU D 100      62.456   9.922  62.216  1.00 17.92           N  
ATOM   5180  CA  LEU D 100      62.530   9.283  63.531  1.00 17.08           C  
ATOM   5181  C   LEU D 100      62.570   7.761  63.453  1.00 17.95           C  
ATOM   5182  O   LEU D 100      63.219   7.113  64.272  1.00 18.61           O  
ATOM   5183  CB  LEU D 100      61.339   9.710  64.382  1.00 13.60           C  
ATOM   5184  CG  LEU D 100      61.161  11.224  64.488  1.00 16.54           C  
ATOM   5185  CD1 LEU D 100      59.837  11.533  65.148  1.00 14.16           C  
ATOM   5186  CD2 LEU D 100      62.327  11.823  65.267  1.00 17.19           C  
ATOM   5187  N   GLY D 101      61.870   7.184  62.481  1.00 16.25           N  
ATOM   5188  CA  GLY D 101      61.870   5.735  62.354  1.00 14.62           C  
ATOM   5189  C   GLY D 101      61.025   5.252  61.193  1.00 13.74           C  
ATOM   5190  O   GLY D 101      60.347   6.047  60.553  1.00 12.47           O  
ATOM   5191  N   VAL D 102      61.049   3.948  60.938  1.00 13.99           N  
ATOM   5192  CA  VAL D 102      60.300   3.363  59.834  1.00 13.56           C  
ATOM   5193  C   VAL D 102      59.608   2.079  60.266  1.00 14.97           C  
ATOM   5194  O   VAL D 102      60.143   1.319  61.069  1.00 16.13           O  
ATOM   5195  CB  VAL D 102      61.244   3.044  58.645  1.00 15.63           C  
ATOM   5196  CG1 VAL D 102      60.463   2.392  57.496  1.00 15.68           C  
ATOM   5197  CG2 VAL D 102      61.920   4.321  58.179  1.00 17.83           C  
ATOM   5198  N   SER D 103      58.419   1.831  59.730  1.00 15.60           N  
ATOM   5199  CA  SER D 103      57.677   0.624  60.084  1.00 16.10           C  
ATOM   5200  C   SER D 103      56.831   0.105  58.940  1.00 15.52           C  
ATOM   5201  O   SER D 103      56.574   0.811  57.965  1.00 15.01           O  
ATOM   5202  CB  SER D 103      56.769   0.889  61.285  1.00 15.98           C  
ATOM   5203  OG  SER D 103      56.011  -0.260  61.608  1.00 18.08           O  
ATOM   5204  N   GLY D 104      56.395  -1.143  59.076  1.00 14.93           N  
ATOM   5205  CA  GLY D 104      55.547  -1.750  58.072  1.00 13.75           C  
ATOM   5206  C   GLY D 104      54.100  -1.308  58.220  1.00 14.63           C  
ATOM   5207  O   GLY D 104      53.337  -1.374  57.258  1.00 14.51           O  
ATOM   5208  N   THR D 105      53.718  -0.857  59.415  1.00 13.74           N  
ATOM   5209  CA  THR D 105      52.346  -0.404  59.654  1.00 15.85           C  
ATOM   5210  C   THR D 105      52.288   0.922  60.412  1.00 15.59           C  
ATOM   5211  O   THR D 105      53.227   1.300  61.108  1.00 15.27           O  
ATOM   5212  CB  THR D 105      51.524  -1.419  60.485  1.00 18.18           C  
ATOM   5213  OG1 THR D 105      52.062  -1.488  61.811  1.00 17.04           O  
ATOM   5214  CG2 THR D 105      51.540  -2.808  59.842  1.00 19.92           C  
ATOM   5215  N   ILE D 106      51.164   1.619  60.284  1.00 16.70           N  
ATOM   5216  CA  ILE D 106      50.976   2.888  60.973  1.00 15.54           C  
ATOM   5217  C   ILE D 106      50.898   2.673  62.486  1.00 16.35           C  
ATOM   5218  O   ILE D 106      51.497   3.419  63.260  1.00 15.23           O  
ATOM   5219  CB  ILE D 106      49.695   3.583  60.470  1.00 17.61           C  
ATOM   5220  CG1 ILE D 106      49.916   4.072  59.032  1.00 16.80           C  
ATOM   5221  CG2 ILE D 106      49.316   4.742  61.401  1.00 17.45           C  
ATOM   5222  CD1 ILE D 106      48.658   4.575  58.345  1.00 19.51           C  
ATOM   5223  N   LYS D 107      50.169   1.642  62.905  1.00 16.44           N  
ATOM   5224  CA  LYS D 107      50.019   1.335  64.324  1.00 19.51           C  
ATOM   5225  C   LYS D 107      51.365   1.083  65.002  1.00 18.78           C  
ATOM   5226  O   LYS D 107      51.617   1.597  66.085  1.00 18.62           O  
ATOM   5227  CB  LYS D 107      49.113   0.113  64.519  1.00 21.10           C  
ATOM   5228  CG  LYS D 107      48.807  -0.176  65.980  1.00 28.30           C  
ATOM   5229  CD  LYS D 107      48.004  -1.460  66.164  1.00 32.93           C  
ATOM   5230  CE  LYS D 107      47.741  -1.716  67.645  1.00 34.65           C  
ATOM   5231  NZ  LYS D 107      47.027  -3.000  67.877  1.00 38.36           N  
ATOM   5232  N   ARG D 108      52.228   0.287  64.376  1.00 18.49           N  
ATOM   5233  CA  ARG D 108      53.539   0.016  64.960  1.00 18.15           C  
ATOM   5234  C   ARG D 108      54.403   1.269  64.966  1.00 15.90           C  
ATOM   5235  O   ARG D 108      55.095   1.551  65.949  1.00 15.97           O  
ATOM   5236  CB  ARG D 108      54.258  -1.107  64.200  1.00 22.64           C  
ATOM   5237  CG  ARG D 108      53.648  -2.484  64.428  1.00 27.78           C  
ATOM   5238  CD  ARG D 108      54.229  -3.544  63.492  1.00 31.59           C  
ATOM   5239  NE  ARG D 108      53.589  -4.840  63.703  1.00 31.57           N  
ATOM   5240  CZ  ARG D 108      53.788  -5.607  64.770  1.00 33.42           C  
ATOM   5241  NH1 ARG D 108      54.622  -5.212  65.723  1.00 32.79           N  
ATOM   5242  NH2 ARG D 108      53.140  -6.759  64.892  1.00 33.20           N  
ATOM   5243  N   LEU D 109      54.367   2.027  63.873  1.00 15.97           N  
ATOM   5244  CA  LEU D 109      55.153   3.259  63.789  1.00 13.78           C  
ATOM   5245  C   LEU D 109      54.799   4.185  64.952  1.00 14.31           C  
ATOM   5246  O   LEU D 109      55.679   4.697  65.642  1.00 14.34           O  
ATOM   5247  CB  LEU D 109      54.868   3.995  62.475  1.00 11.91           C  
ATOM   5248  CG  LEU D 109      55.742   5.221  62.199  1.00 10.56           C  
ATOM   5249  CD1 LEU D 109      57.137   4.781  61.747  1.00 10.05           C  
ATOM   5250  CD2 LEU D 109      55.090   6.069  61.110  1.00 10.00           C  
ATOM   5251  N   LYS D 110      53.505   4.405  65.151  1.00 15.26           N  
ATOM   5252  CA  LYS D 110      53.040   5.291  66.216  1.00 17.62           C  
ATOM   5253  C   LYS D 110      53.524   4.814  67.569  1.00 18.47           C  
ATOM   5254  O   LYS D 110      54.124   5.576  68.333  1.00 20.12           O  
ATOM   5255  CB  LYS D 110      51.512   5.359  66.245  1.00 19.49           C  
ATOM   5256  CG  LYS D 110      50.872   6.123  65.110  1.00 18.71           C  
ATOM   5257  CD  LYS D 110      49.361   6.140  65.310  1.00 26.41           C  
ATOM   5258  CE  LYS D 110      48.636   6.799  64.154  1.00 28.82           C  
ATOM   5259  NZ  LYS D 110      47.158   6.732  64.350  1.00 34.51           N  
ATOM   5260  N   ARG D 111      53.272   3.541  67.853  1.00 18.44           N  
ATOM   5261  CA  ARG D 111      53.661   2.967  69.127  1.00 20.81           C  
ATOM   5262  C   ARG D 111      55.131   3.179  69.483  1.00 21.51           C  
ATOM   5263  O   ARG D 111      55.442   3.596  70.590  1.00 20.49           O  
ATOM   5264  CB  ARG D 111      53.324   1.470  69.159  1.00 23.67           C  
ATOM   5265  CG  ARG D 111      53.513   0.833  70.531  1.00 28.48           C  
ATOM   5266  CD  ARG D 111      53.034  -0.613  70.558  1.00 31.53           C  
ATOM   5267  NE  ARG D 111      53.773  -1.453  69.617  1.00 35.68           N  
ATOM   5268  CZ  ARG D 111      53.235  -2.036  68.550  1.00 36.30           C  
ATOM   5269  NH1 ARG D 111      51.944  -1.876  68.279  1.00 36.49           N  
ATOM   5270  NH2 ARG D 111      53.989  -2.781  67.750  1.00 35.57           N  
ATOM   5271  N   LYS D 112      56.047   2.932  68.556  1.00 21.64           N  
ATOM   5272  CA  LYS D 112      57.447   3.090  68.920  1.00 22.14           C  
ATOM   5273  C   LYS D 112      58.127   4.428  68.638  1.00 20.39           C  
ATOM   5274  O   LYS D 112      59.181   4.707  69.202  1.00 18.85           O  
ATOM   5275  CB  LYS D 112      58.269   1.948  68.313  1.00 26.90           C  
ATOM   5276  CG  LYS D 112      58.246   1.878  66.811  1.00 30.59           C  
ATOM   5277  CD  LYS D 112      58.283   0.424  66.326  1.00 34.76           C  
ATOM   5278  CE  LYS D 112      59.434  -0.367  66.936  1.00 36.98           C  
ATOM   5279  NZ  LYS D 112      60.768   0.191  66.575  1.00 39.18           N  
ATOM   5280  N   PHE D 113      57.539   5.269  67.793  1.00 19.37           N  
ATOM   5281  CA  PHE D 113      58.185   6.539  67.492  1.00 17.76           C  
ATOM   5282  C   PHE D 113      57.374   7.803  67.772  1.00 18.23           C  
ATOM   5283  O   PHE D 113      57.954   8.871  67.994  1.00 18.50           O  
ATOM   5284  CB  PHE D 113      58.644   6.557  66.025  1.00 18.17           C  
ATOM   5285  CG  PHE D 113      59.570   5.427  65.661  1.00 17.35           C  
ATOM   5286  CD1 PHE D 113      59.163   4.436  64.772  1.00 19.04           C  
ATOM   5287  CD2 PHE D 113      60.842   5.342  66.223  1.00 18.27           C  
ATOM   5288  CE1 PHE D 113      60.009   3.372  64.448  1.00 21.91           C  
ATOM   5289  CE2 PHE D 113      61.699   4.281  65.907  1.00 19.51           C  
ATOM   5290  CZ  PHE D 113      61.282   3.294  65.019  1.00 18.05           C  
ATOM   5291  N   LEU D 114      56.048   7.698  67.773  1.00 17.09           N  
ATOM   5292  CA  LEU D 114      55.225   8.882  67.983  1.00 17.90           C  
ATOM   5293  C   LEU D 114      54.401   8.953  69.275  1.00 19.70           C  
ATOM   5294  O   LEU D 114      53.896  10.020  69.626  1.00 16.08           O  
ATOM   5295  CB  LEU D 114      54.321   9.082  66.762  1.00 14.93           C  
ATOM   5296  CG  LEU D 114      55.084   9.243  65.431  1.00 12.00           C  
ATOM   5297  CD1 LEU D 114      54.122   9.170  64.240  1.00 14.61           C  
ATOM   5298  CD2 LEU D 114      55.820  10.581  65.437  1.00 10.34           C  
ATOM   5299  N   ALA D 115      54.255   7.838  69.983  1.00 21.00           N  
ATOM   5300  CA  ALA D 115      53.489   7.873  71.232  1.00 24.30           C  
ATOM   5301  C   ALA D 115      54.111   8.955  72.115  1.00 23.32           C  
ATOM   5302  O   ALA D 115      53.412   9.721  72.776  1.00 23.38           O  
ATOM   5303  CB  ALA D 115      53.549   6.518  71.940  1.00 24.46           C  
ATOM   5304  N   LYS D 116      55.437   8.999  72.090  1.00 25.11           N  
ATOM   5305  CA  LYS D 116      56.239   9.957  72.838  1.00 26.83           C  
ATOM   5306  C   LYS D 116      55.796  11.387  72.550  1.00 27.93           C  
ATOM   5307  O   LYS D 116      55.859  12.253  73.425  1.00 29.88           O  
ATOM   5308  CB  LYS D 116      57.715   9.792  72.450  1.00 28.74           C  
ATOM   5309  CG  LYS D 116      58.626  10.921  72.915  1.00 33.90           C  
ATOM   5310  CD  LYS D 116      60.022  10.814  72.300  1.00 35.73           C  
ATOM   5311  CE  LYS D 116      60.888  11.995  72.720  1.00 38.92           C  
ATOM   5312  NZ  LYS D 116      62.217  12.004  72.047  1.00 41.04           N  
ATOM   5313  N   TYR D 117      55.363  11.636  71.318  1.00 25.23           N  
ATOM   5314  CA  TYR D 117      54.919  12.970  70.935  1.00 25.02           C  
ATOM   5315  C   TYR D 117      53.421  13.136  71.146  1.00 24.94           C  
ATOM   5316  O   TYR D 117      52.809  14.071  70.633  1.00 25.44           O  
ATOM   5317  CB  TYR D 117      55.302  13.268  69.478  1.00 21.23           C  
ATOM   5318  CG  TYR D 117      56.801  13.294  69.255  1.00 21.66           C  
ATOM   5319  CD1 TYR D 117      57.503  12.125  68.951  1.00 20.58           C  
ATOM   5320  CD2 TYR D 117      57.529  14.480  69.410  1.00 22.77           C  
ATOM   5321  CE1 TYR D 117      58.889  12.135  68.810  1.00 23.32           C  
ATOM   5322  CE2 TYR D 117      58.913  14.500  69.274  1.00 23.59           C  
ATOM   5323  CZ  TYR D 117      59.588  13.324  68.974  1.00 22.95           C  
ATOM   5324  OH  TYR D 117      60.954  13.339  68.843  1.00 23.11           O  
ATOM   5325  N   GLY D 118      52.844  12.214  71.910  1.00 24.65           N  
ATOM   5326  CA  GLY D 118      51.426  12.270  72.222  1.00 25.25           C  
ATOM   5327  C   GLY D 118      50.470  11.872  71.117  1.00 27.67           C  
ATOM   5328  O   GLY D 118      49.313  12.295  71.115  1.00 26.53           O  
ATOM   5329  N   TRP D 119      50.929  11.056  70.176  1.00 26.16           N  
ATOM   5330  CA  TRP D 119      50.053  10.645  69.092  1.00 28.29           C  
ATOM   5331  C   TRP D 119      48.933   9.725  69.544  1.00 33.07           C  
ATOM   5332  O   TRP D 119      47.758  10.095  69.469  1.00 36.29           O  
ATOM   5333  CB  TRP D 119      50.862   9.996  67.970  1.00 23.34           C  
ATOM   5334  CG  TRP D 119      51.431  11.021  67.044  1.00 18.92           C  
ATOM   5335  CD1 TRP D 119      52.325  12.006  67.357  1.00 18.95           C  
ATOM   5336  CD2 TRP D 119      51.121  11.187  65.657  1.00 18.30           C  
ATOM   5337  NE1 TRP D 119      52.594  12.774  66.245  1.00 17.15           N  
ATOM   5338  CE2 TRP D 119      51.869  12.293  65.189  1.00 15.65           C  
ATOM   5339  CE3 TRP D 119      50.285  10.508  64.764  1.00 16.98           C  
ATOM   5340  CZ2 TRP D 119      51.809  12.733  63.865  1.00 15.19           C  
ATOM   5341  CZ3 TRP D 119      50.225  10.945  63.444  1.00 15.69           C  
ATOM   5342  CH2 TRP D 119      50.985  12.048  63.008  1.00 17.23           C  
ATOM   5343  N   LYS D 120      49.287   8.536  70.021  1.00 35.84           N  
ATOM   5344  CA  LYS D 120      48.279   7.582  70.476  1.00 40.15           C  
ATOM   5345  C   LYS D 120      47.114   7.497  69.491  1.00 41.45           C  
ATOM   5346  O   LYS D 120      46.010   7.937  69.873  1.00 43.84           O  
ATOM   5347  CB  LYS D 120      47.763   7.985  71.857  1.00 41.08           C  
ATOM   5348  OXT LYS D 120      47.314   7.009  68.357  1.00 40.99           O  
TER    5349      LYS D 120                                                      
END
MOLECULE T0487_13_176.pdb
ATOM     73  N   ARG    13      31.973   4.298  40.466  1.00 59.39           N  
ATOM     74  CA  ARG    13      33.105   3.822  41.263  1.00 59.66           C  
ATOM     75  C   ARG    13      33.481   2.448  40.739  1.00 58.30           C  
ATOM     76  O   ARG    13      32.677   1.781  40.081  1.00 57.95           O  
ATOM     77  CB  ARG    13      32.738   3.647  42.732  1.00 61.21           C  
ATOM     78  CG  ARG    13      32.238   4.874  43.367  1.00 64.16           C  
ATOM     79  CD  ARG    13      31.922   4.635  44.811  1.00 64.95           C  
ATOM     80  NE  ARG    13      31.799   5.931  45.453  1.00 67.21           N  
ATOM     81  CZ  ARG    13      31.859   6.124  46.754  1.00 67.14           C  
ATOM     82  NH1 ARG    13      32.031   5.086  47.557  1.00 67.21           N  
ATOM     83  NH2 ARG    13      31.788   7.358  47.235  1.00 67.78           N  
ATOM     84  N   PHE    14      34.693   2.018  41.061  1.00 56.41           N  
ATOM     85  CA  PHE    14      35.175   0.726  40.616  1.00 56.49           C  
ATOM     86  C   PHE    14      36.086   0.154  41.681  1.00 57.15           C  
ATOM     87  O   PHE    14      36.900   0.879  42.249  1.00 58.82           O  
ATOM     88  CB  PHE    14      35.932   0.875  39.278  1.00 53.89           C  
ATOM     89  CG  PHE    14      35.121   1.536  38.191  1.00 49.26           C  
ATOM     90  CD1 PHE    14      34.945   2.918  38.170  1.00 47.28           C  
ATOM     91  CD2 PHE    14      34.490   0.773  37.217  1.00 47.81           C  
ATOM     92  CE1 PHE    14      34.149   3.519  37.193  1.00 45.49           C  
ATOM     93  CE2 PHE    14      33.687   1.367  36.231  1.00 43.95           C  
ATOM     94  CZ  PHE    14      33.520   2.730  36.220  1.00 45.62           C  
ATOM     95  N   ALA    15      35.957  -1.144  41.949  1.00 58.08           N  
ATOM     96  CA  ALA    15      36.778  -1.786  42.977  1.00 58.87           C  
ATOM     97  C   ALA    15      38.078  -2.370  42.429  1.00 59.13           C  
ATOM     98  O   ALA    15      38.104  -2.971  41.355  1.00 58.72           O  
ATOM     99  CB  ALA    15      35.973  -2.871  43.685  1.00 57.67           C  
ATOM    100  N   LEU    16      39.158  -2.183  43.178  1.00 59.18           N  
ATOM    101  CA  LEU    16      40.451  -2.692  42.771  1.00 60.54           C  
ATOM    102  C   LEU    16      41.004  -3.676  43.799  1.00 62.32           C  
ATOM    103  O   LEU    16      40.410  -3.886  44.849  1.00 61.77           O  
ATOM    104  CB  LEU    16      41.408  -1.530  42.524  1.00 60.96           C  
ATOM    105  CG  LEU    16      40.958  -0.626  41.353  1.00 62.16           C  
ATOM    106  CD1 LEU    16      41.844   0.609  41.279  1.00 60.09           C  
ATOM    107  CD2 LEU    16      41.002  -1.395  40.025  1.00 60.38           C  
ATOM    108  N   ARG    17      42.132  -4.299  43.491  1.00 64.81           N  
ATOM    109  CA  ARG    17      42.691  -5.285  44.397  1.00 67.20           C  
ATOM    110  C   ARG    17      42.740  -4.768  45.820  1.00 70.61           C  
ATOM    111  O   ARG    17      42.742  -3.564  46.052  1.00 71.60           O  
ATOM    112  CB  ARG    17      44.097  -5.685  43.957  1.00 65.33           C  
ATOM    113  CG  ARG    17      45.128  -4.601  44.135  1.00 65.08           C  
ATOM    114  CD  ARG    17      46.521  -5.172  44.309  1.00 63.68           C  
ATOM    115  NE  ARG    17      47.310  -4.329  45.200  1.00 65.95           N  
ATOM    116  CZ  ARG    17      48.390  -3.652  44.826  1.00 68.32           C  
ATOM    117  NH1 ARG    17      48.821  -3.724  43.574  1.00 70.06           N  
ATOM    118  NH2 ARG    17      49.024  -2.876  45.692  1.00 68.14           N  
ATOM    119  N   PRO    18      42.737  -5.676  46.804  1.00 73.90           N  
ATOM    120  CA  PRO    18      42.797  -5.206  48.191  1.00 75.11           C  
ATOM    121  C   PRO    18      44.229  -4.734  48.409  1.00 76.77           C  
ATOM    122  O   PRO    18      45.119  -5.076  47.631  1.00 76.09           O  
ATOM    123  CB  PRO    18      42.485  -6.464  48.998  1.00 74.96           C  
ATOM    124  CG  PRO    18      41.629  -7.278  48.054  1.00 74.85           C  
ATOM    125  CD  PRO    18      42.363  -7.100  46.749  1.00 74.46           C  
ATOM    126  N   LEU    19      44.460  -3.939  49.445  1.00 79.33           N  
ATOM    127  CA  LEU    19      45.815  -3.482  49.711  1.00 81.93           C  
ATOM    128  C   LEU    19      46.609  -4.638  50.331  1.00 84.42           C  
ATOM    129  O   LEU    19      46.132  -5.323  51.247  1.00 84.14           O  
ATOM    130  CB  LEU    19      45.805  -2.274  50.657  1.00 81.55           C  
ATOM    131  CG  LEU    19      45.371  -0.907  50.111  1.00 82.04           C  
ATOM    132  CD1 LEU    19      43.983  -1.003  49.491  1.00 82.27           C  
ATOM    133  CD2 LEU    19      45.377   0.124  51.236  1.00 81.12           C  
ATOM    134  N   ASN    20      47.811  -4.867  49.810  1.00 86.67           N  
ATOM    135  CA  ASN    20      48.664  -5.925  50.321  1.00 89.22           C  
ATOM    136  C   ASN    20      49.231  -5.463  51.655  1.00 91.10           C  
ATOM    137  O   ASN    20      49.189  -4.273  51.968  1.00 91.62           O  
ATOM    138  CB  ASN    20      49.797  -6.223  49.332  1.00 90.95           C  
ATOM    139  CG  ASN    20      50.740  -5.042  49.129  1.00 92.05           C  
ATOM    140  OD1 ASN    20      51.271  -4.479  50.088  1.00 93.47           O  
ATOM    141  ND2 ASN    20      50.972  -4.680  47.872  1.00 91.60           N  
ATOM    142  N   PRO    21      49.758  -6.394  52.469  1.00 92.64           N  
ATOM    143  CA  PRO    21      50.329  -6.043  53.777  1.00 93.03           C  
ATOM    144  C   PRO    21      51.253  -4.819  53.795  1.00 93.26           C  
ATOM    145  O   PRO    21      51.094  -3.941  54.648  1.00 94.03           O  
ATOM    146  CB  PRO    21      51.036  -7.333  54.212  1.00 93.16           C  
ATOM    147  CG  PRO    21      51.168  -8.143  52.932  1.00 93.95           C  
ATOM    148  CD  PRO    21      49.887  -7.837  52.217  1.00 92.99           C  
ATOM    149  N   GLU    22      52.196  -4.748  52.855  1.00 92.42           N  
ATOM    150  CA  GLU    22      53.135  -3.621  52.783  1.00 92.25           C  
ATOM    151  C   GLU    22      52.464  -2.242  52.784  1.00 90.18           C  
ATOM    152  O   GLU    22      52.927  -1.316  53.438  1.00 88.53           O  
ATOM    153  CB  GLU    22      54.008  -3.731  51.525  1.00 94.48           C  
ATOM    154  CG  GLU    22      54.916  -4.942  51.487  1.00 98.22           C  
ATOM    155  CD  GLU    22      54.143  -6.239  51.645  1.00101.59           C  
ATOM    156  OE1 GLU    22      53.215  -6.484  50.842  1.00101.73           O  
ATOM    157  OE2 GLU    22      54.462  -7.014  52.577  1.00103.69           O  
ATOM    158  N   GLU    23      51.374  -2.113  52.040  1.00 89.02           N  
ATOM    159  CA  GLU    23      50.660  -0.849  51.932  1.00 87.43           C  
ATOM    160  C   GLU    23      49.761  -0.589  53.128  1.00 86.72           C  
ATOM    161  O   GLU    23      49.181   0.489  53.258  1.00 86.51           O  
ATOM    162  CB  GLU    23      49.844  -0.845  50.641  1.00 87.07           C  
ATOM    163  CG  GLU    23      50.691  -1.231  49.439  1.00 86.82           C  
ATOM    164  CD  GLU    23      49.876  -1.575  48.209  1.00 86.51           C  
ATOM    165  OE1 GLU    23      48.796  -2.186  48.354  1.00 86.21           O  
ATOM    166  OE2 GLU    23      50.334  -1.251  47.092  1.00 86.66           O  
ATOM    167  N   LEU    24      49.636  -1.585  53.998  1.00 85.54           N  
ATOM    168  CA  LEU    24      48.811  -1.436  55.182  1.00 84.08           C  
ATOM    169  C   LEU    24      49.744  -1.004  56.299  1.00 84.53           C  
ATOM    170  O   LEU    24      49.316  -0.552  57.365  1.00 84.00           O  
ATOM    171  CB  LEU    24      48.119  -2.760  55.510  1.00 82.17           C  
ATOM    172  CG  LEU    24      46.849  -3.050  54.707  1.00 80.47           C  
ATOM    173  CD1 LEU    24      46.452  -4.502  54.869  1.00 80.15           C  
ATOM    174  CD2 LEU    24      45.729  -2.132  55.171  1.00 79.01           C  
ATOM    175  N   ARG    25      51.035  -1.131  56.020  1.00 85.12           N  
ATOM    176  CA  ARG    25      52.076  -0.756  56.959  1.00 86.52           C  
ATOM    177  C   ARG    25      53.008   0.280  56.323  1.00 85.98           C  
ATOM    178  O   ARG    25      54.157  -0.004  56.002  1.00 85.01           O  
ATOM    179  CB  ARG    25      52.871  -1.998  57.377  1.00 89.00           C  
ATOM    180  CG  ARG    25      52.353  -2.724  58.619  1.00 90.63           C  
ATOM    181  CD  ARG    25      50.940  -3.226  58.432  1.00 91.79           C  
ATOM    182  NE  ARG    25      50.573  -4.153  59.492  1.00 93.59           N  
ATOM    183  CZ  ARG    25      49.434  -4.833  59.530  1.00 94.01           C  
ATOM    184  NH1 ARG    25      48.539  -4.690  58.562  1.00 92.90           N  
ATOM    185  NH2 ARG    25      49.196  -5.665  60.537  1.00 95.41           N  
ATOM    186  N   PRO    26      52.512   1.501  56.114  1.00 85.68           N  
ATOM    187  CA  PRO    26      53.369   2.515  55.511  1.00 86.33           C  
ATOM    188  C   PRO    26      54.522   2.911  56.419  1.00 88.18           C  
ATOM    189  O   PRO    26      54.468   2.693  57.632  1.00 89.02           O  
ATOM    190  CB  PRO    26      52.409   3.666  55.273  1.00 85.60           C  
ATOM    191  CG  PRO    26      51.414   3.503  56.377  1.00 85.46           C  
ATOM    192  CD  PRO    26      51.162   2.032  56.357  1.00 85.05           C  
ATOM    193  N   TRP    27      55.562   3.484  55.812  1.00 89.03           N  
ATOM    194  CA  TRP    27      56.721   3.947  56.549  1.00 89.61           C  
ATOM    195  C   TRP    27      56.350   5.233  57.216  1.00 89.84           C  
ATOM    196  O   TRP    27      55.691   6.099  56.650  1.00 90.73           O  
ATOM    197  CB  TRP    27      57.891   4.243  55.644  1.00 90.76           C  
ATOM    198  CG  TRP    27      58.407   3.069  54.967  1.00 93.53           C  
ATOM    199  CD1 TRP    27      58.251   2.753  53.653  1.00 94.32           C  
ATOM    200  CD2 TRP    27      59.211   2.042  55.542  1.00 95.21           C  
ATOM    201  NE1 TRP    27      58.917   1.590  53.364  1.00 95.46           N  
ATOM    202  CE2 TRP    27      59.517   1.129  54.508  1.00 96.05           C  
ATOM    203  CE3 TRP    27      59.707   1.801  56.833  1.00 95.71           C  
ATOM    204  CZ2 TRP    27      60.300  -0.010  54.721  1.00 96.73           C  
ATOM    205  CZ3 TRP    27      60.487   0.668  57.047  1.00 97.12           C  
ATOM    206  CH2 TRP    27      60.775  -0.224  55.993  1.00 97.61           C  
ATOM    207  N   ARG    28      56.809   5.389  58.424  1.00 89.27           N  
ATOM    208  CA  ARG    28      56.479   6.588  59.067  1.00 88.62           C  
ATOM    209  C   ARG    28      57.739   7.418  59.206  1.00 87.21           C  
ATOM    210  O   ARG    28      58.815   6.859  59.380  1.00 86.01           O  
ATOM    211  CB  ARG    28      55.951   6.288  60.410  1.00 89.53           C  
ATOM    212  CG  ARG    28      55.979   7.487  61.163  1.00 91.62           C  
ATOM    213  CD  ARG    28      55.008   7.346  62.150  1.00 92.78           C  
ATOM    214  NE  ARG    28      55.270   8.338  63.155  1.00 94.63           N  
ATOM    215  CZ  ARG    28      55.643   8.040  64.383  1.00 94.78           C  
ATOM    216  NH1 ARG    28      55.791   6.771  64.727  1.00 94.53           N  
ATOM    217  NH2 ARG    28      55.840   9.010  65.258  1.00 93.97           N  
ATOM    218  N   LEU    29      57.609   8.743  59.150  1.00 85.77           N  
ATOM    219  CA  LEU    29      58.776   9.602  59.289  1.00 84.79           C  
ATOM    220  C   LEU    29      58.506  10.867  60.083  1.00 84.37           C  
ATOM    221  O   LEU    29      57.523  11.557  59.838  1.00 84.57           O  
ATOM    222  CB  LEU    29      59.323   9.975  57.922  1.00 84.38           C  
ATOM    223  CG  LEU    29      59.699   8.841  56.976  1.00 84.46           C  
ATOM    224  CD1 LEU    29      58.548   8.586  56.006  1.00 84.52           C  
ATOM    225  CD2 LEU    29      60.968   9.219  56.224  1.00 83.63           C  
ATOM    226  N   GLU    30      59.386  11.171  61.033  1.00 83.92           N  
ATOM    227  CA  GLU    30      59.229  12.361  61.854  1.00 83.24           C  
ATOM    228  C   GLU    30      59.919  13.503  61.112  1.00 81.00           C  
ATOM    229  O   GLU    30      60.964  13.317  60.477  1.00 79.58           O  
ATOM    230  CB  GLU    30      59.865  12.136  63.229  1.00 86.64           C  
ATOM    231  CG  GLU    30      59.418  13.111  64.318  1.00 91.21           C  
ATOM    232  CD  GLU    30      60.254  12.990  65.598  1.00 94.14           C  
ATOM    233  OE1 GLU    30      61.086  13.889  65.871  1.00 94.97           O  
ATOM    234  OE2 GLU    30      60.083  11.988  66.328  1.00 95.30           O  
ATOM    235  N   VAL    31      59.326  14.687  61.190  1.00 78.51           N  
ATOM    236  CA  VAL    31      59.869  15.849  60.503  1.00 75.45           C  
ATOM    237  C   VAL    31      60.233  16.901  61.495  1.00 73.49           C  
ATOM    238  O   VAL    31      59.770  16.878  62.629  1.00 74.45           O  
ATOM    239  CB  VAL    31      58.825  16.494  59.566  1.00 75.10           C  
ATOM    240  CG1 VAL    31      59.428  17.674  58.825  1.00 72.67           C  
ATOM    241  CG2 VAL    31      58.300  15.465  58.603  1.00 75.61           C  
ATOM    242  N   VAL    32      61.084  17.818  61.075  1.00 71.65           N  
ATOM    243  CA  VAL    32      61.409  18.934  61.931  1.00 70.33           C  
ATOM    244  C   VAL    32      61.700  20.122  61.044  1.00 68.33           C  
ATOM    245  O   VAL    32      62.335  20.003  59.997  1.00 67.15           O  
ATOM    246  CB  VAL    32      62.564  18.628  62.933  1.00 69.44           C  
ATOM    247  CG1 VAL    32      63.022  17.220  62.783  1.00 67.88           C  
ATOM    248  CG2 VAL    32      63.697  19.613  62.759  1.00 70.15           C  
ATOM    249  N   LEU    33      61.197  21.261  61.492  1.00 67.07           N  
ATOM    250  CA  LEU    33      61.298  22.515  60.769  1.00 67.34           C  
ATOM    251  C   LEU    33      62.083  23.589  61.507  1.00 67.65           C  
ATOM    252  O   LEU    33      61.953  23.741  62.723  1.00 69.45           O  
ATOM    253  CB  LEU    33      59.885  23.028  60.496  1.00 63.97           C  
ATOM    254  CG  LEU    33      58.997  21.936  59.913  1.00 62.34           C  
ATOM    255  CD1 LEU    33      57.564  22.417  59.838  1.00 59.52           C  
ATOM    256  CD2 LEU    33      59.547  21.524  58.548  1.00 59.47           C  
ATOM    257  N   ASP    34      62.882  24.346  60.764  1.00 66.75           N  
ATOM    258  CA  ASP    34      63.658  25.416  61.341  1.00 66.43           C  
ATOM    259  C   ASP    34      63.628  26.615  60.426  1.00 65.31           C  
ATOM    260  O   ASP    34      63.958  26.492  59.246  1.00 64.45           O  
ATOM    261  CB  ASP    34      65.122  24.988  61.521  1.00 67.99           C  
ATOM    262  CG  ASP    34      66.034  26.163  61.835  1.00 71.28           C  
ATOM    263  OD1 ASP    34      67.225  26.130  61.457  1.00 72.80           O  
ATOM    264  OD2 ASP    34      65.562  27.130  62.468  1.00 73.07           O  
ATOM    265  N   PRO    35      63.196  27.778  60.924  1.00 65.81           N  
ATOM    266  CA  PRO    35      62.809  28.058  62.311  1.00 64.91           C  
ATOM    267  C   PRO    35      61.395  27.567  62.593  1.00 65.55           C  
ATOM    268  O   PRO    35      60.620  27.355  61.672  1.00 65.15           O  
ATOM    269  CB  PRO    35      62.839  29.572  62.410  1.00 64.49           C  
ATOM    270  CG  PRO    35      63.707  30.002  61.235  1.00 65.74           C  
ATOM    271  CD  PRO    35      63.327  29.038  60.164  1.00 65.37           C  
ATOM    272  N   PRO    36      61.038  27.400  63.879  1.00 67.36           N  
ATOM    273  CA  PRO    36      59.690  26.944  64.231  1.00 67.75           C  
ATOM    274  C   PRO    36      58.681  27.928  63.648  1.00 69.15           C  
ATOM    275  O   PRO    36      58.806  29.139  63.823  1.00 69.02           O  
ATOM    276  CB  PRO    36      59.691  27.010  65.753  1.00 66.03           C  
ATOM    277  CG  PRO    36      61.070  26.692  66.092  1.00 66.85           C  
ATOM    278  CD  PRO    36      61.889  27.457  65.079  1.00 67.51           C  
ATOM    279  N   PRO    37      57.691  27.433  62.917  1.00 70.94           N  
ATOM    280  CA  PRO    37      56.737  28.402  62.382  1.00 73.88           C  
ATOM    281  C   PRO    37      55.571  28.545  63.350  1.00 76.23           C  
ATOM    282  O   PRO    37      55.579  27.934  64.421  1.00 75.43           O  
ATOM    283  CB  PRO    37      56.319  27.770  61.063  1.00 74.29           C  
ATOM    284  CG  PRO    37      56.323  26.319  61.399  1.00 73.65           C  
ATOM    285  CD  PRO    37      57.622  26.164  62.180  1.00 71.74           C  
ATOM    286  N   GLY    38      54.581  29.362  62.989  1.00 79.07           N  
ATOM    287  CA  GLY    38      53.415  29.515  63.845  1.00 81.68           C  
ATOM    288  C   GLY    38      52.726  28.163  63.860  1.00 83.87           C  
ATOM    289  O   GLY    38      52.696  27.489  62.832  1.00 84.64           O  
ATOM    290  N   ARG    39      52.172  27.749  64.994  1.00 85.64           N  
ATOM    291  CA  ARG    39      51.533  26.439  65.055  1.00 88.60           C  
ATOM    292  C   ARG    39      50.477  26.222  63.961  1.00 89.16           C  
ATOM    293  O   ARG    39      50.208  25.083  63.560  1.00 89.30           O  
ATOM    294  CB  ARG    39      50.929  26.212  66.447  1.00 90.49           C  
ATOM    295  CG  ARG    39      50.335  24.819  66.667  1.00 93.70           C  
ATOM    296  CD  ARG    39      50.658  24.306  68.066  1.00 96.75           C  
ATOM    297  NE  ARG    39      50.437  25.325  69.096  1.00 99.71           N  
ATOM    298  CZ  ARG    39      49.253  25.646  69.619  1.00100.35           C  
ATOM    299  NH1 ARG    39      48.148  25.028  69.225  1.00100.59           N  
ATOM    300  NH2 ARG    39      49.174  26.600  70.536  1.00101.42           N  
ATOM    301  N   GLU    40      49.898  27.309  63.462  1.00 89.11           N  
ATOM    302  CA  GLU    40      48.884  27.201  62.422  1.00 89.11           C  
ATOM    303  C   GLU    40      49.466  27.039  61.015  1.00 87.75           C  
ATOM    304  O   GLU    40      48.730  26.967  60.029  1.00 87.96           O  
ATOM    305  CB  GLU    40      47.917  28.399  62.493  1.00 91.15           C  
ATOM    306  CG  GLU    40      48.531  29.756  62.855  1.00 93.93           C  
ATOM    307  CD  GLU    40      49.389  30.342  61.744  1.00 96.61           C  
ATOM    308  OE1 GLU    40      49.021  30.171  60.562  1.00 99.17           O  
ATOM    309  OE2 GLU    40      50.420  30.988  62.040  1.00 96.55           O  
ATOM    310  N   GLU    41      50.791  26.961  60.933  1.00 86.14           N  
ATOM    311  CA  GLU    41      51.485  26.782  59.657  1.00 84.03           C  
ATOM    312  C   GLU    41      52.141  25.401  59.533  1.00 81.82           C  
ATOM    313  O   GLU    41      52.646  25.047  58.469  1.00 81.74           O  
ATOM    314  CB  GLU    41      52.586  27.827  59.485  1.00 85.41           C  
ATOM    315  CG  GLU    41      52.146  29.244  59.211  1.00 87.50           C  
ATOM    316  CD  GLU    41      53.328  30.122  58.797  1.00 89.89           C  
ATOM    317  OE1 GLU    41      53.784  30.011  57.632  1.00 89.96           O  
ATOM    318  OE2 GLU    41      53.816  30.910  59.643  1.00 90.33           O  
ATOM    319  N   VAL    42      52.143  24.633  60.618  1.00 78.99           N  
ATOM    320  CA  VAL    42      52.764  23.312  60.621  1.00 77.14           C  
ATOM    321  C   VAL    42      52.170  22.321  59.622  1.00 76.59           C  
ATOM    322  O   VAL    42      52.911  21.631  58.923  1.00 75.04           O  
ATOM    323  CB  VAL    42      52.735  22.670  62.050  1.00 76.62           C  
ATOM    324  CG1 VAL    42      53.079  21.191  61.976  1.00 74.68           C  
ATOM    325  CG2 VAL    42      53.738  23.370  62.957  1.00 74.61           C  
ATOM    326  N   TYR    43      50.844  22.241  59.557  1.00 76.64           N  
ATOM    327  CA  TYR    43      50.190  21.312  58.634  1.00 76.79           C  
ATOM    328  C   TYR    43      50.365  21.731  57.171  1.00 75.21           C  
ATOM    329  O   TYR    43      50.707  20.908  56.319  1.00 75.82           O  
ATOM    330  CB  TYR    43      48.704  21.175  58.986  1.00 78.99           C  
ATOM    331  CG  TYR    43      48.413  20.196  60.107  1.00 82.10           C  
ATOM    332  CD1 TYR    43      49.264  20.085  61.212  1.00 84.05           C  
ATOM    333  CD2 TYR    43      47.264  19.407  60.083  1.00 83.58           C  
ATOM    334  CE1 TYR    43      48.975  19.214  62.268  1.00 85.27           C  
ATOM    335  CE2 TYR    43      46.961  18.535  61.130  1.00 85.96           C  
ATOM    336  CZ  TYR    43      47.817  18.445  62.222  1.00 86.96           C  
ATOM    337  OH  TYR    43      47.482  17.617  63.279  1.00 88.17           O  
ATOM    338  N   PRO    44      50.123  23.012  56.856  1.00 73.13           N  
ATOM    339  CA  PRO    44      50.284  23.471  55.475  1.00 71.53           C  
ATOM    340  C   PRO    44      51.714  23.250  54.990  1.00 70.63           C  
ATOM    341  O   PRO    44      51.941  22.961  53.819  1.00 72.15           O  
ATOM    342  CB  PRO    44      49.932  24.946  55.564  1.00 72.22           C  
ATOM    343  CG  PRO    44      48.895  24.959  56.627  1.00 73.30           C  
ATOM    344  CD  PRO    44      49.486  24.055  57.677  1.00 72.90           C  
ATOM    345  N   LEU    45      52.677  23.390  55.899  1.00 68.68           N  
ATOM    346  CA  LEU    45      54.092  23.186  55.579  1.00 65.71           C  
ATOM    347  C   LEU    45      54.451  21.705  55.374  1.00 64.14           C  
ATOM    348  O   LEU    45      55.246  21.376  54.498  1.00 63.62           O  
ATOM    349  CB  LEU    45      54.959  23.773  56.696  1.00 65.90           C  
ATOM    350  CG  LEU    45      55.700  25.108  56.556  1.00 66.10           C  
ATOM    351  CD1 LEU    45      54.920  26.125  55.766  1.00 66.45           C  
ATOM    352  CD2 LEU    45      55.963  25.624  57.962  1.00 67.42           C  
ATOM    353  N   LEU    46      53.870  20.812  56.177  1.00 62.79           N  
ATOM    354  CA  LEU    46      54.163  19.388  56.049  1.00 61.78           C  
ATOM    355  C   LEU    46      53.647  18.834  54.749  1.00 61.50           C  
ATOM    356  O   LEU    46      54.210  17.873  54.210  1.00 61.61           O  
ATOM    357  CB  LEU    46      53.579  18.598  57.209  1.00 62.42           C  
ATOM    358  CG  LEU    46      54.315  18.821  58.528  1.00 62.71           C  
ATOM    359  CD1 LEU    46      53.836  17.808  59.523  1.00 62.77           C  
ATOM    360  CD2 LEU    46      55.815  18.683  58.332  1.00 62.98           C  
ATOM    361  N   ALA    47      52.557  19.422  54.258  1.00 59.18           N  
ATOM    362  CA  ALA    47      52.002  19.026  52.971  1.00 56.54           C  
ATOM    363  C   ALA    47      53.099  19.355  51.961  1.00 55.33           C  
ATOM    364  O   ALA    47      53.349  18.601  51.010  1.00 55.69           O  
ATOM    365  CB  ALA    47      50.751  19.842  52.660  1.00 55.00           C  
ATOM    366  N   GLN    48      53.775  20.479  52.187  1.00 53.26           N  
ATOM    367  CA  GLN    48      54.819  20.891  51.278  1.00 52.73           C  
ATOM    368  C   GLN    48      56.026  20.008  51.407  1.00 53.24           C  
ATOM    369  O   GLN    48      56.690  19.748  50.423  1.00 54.57           O  
ATOM    370  CB  GLN    48      55.221  22.351  51.496  1.00 52.80           C  
ATOM    371  CG  GLN    48      55.907  22.952  50.264  1.00 53.60           C  
ATOM    372  CD  GLN    48      56.562  24.314  50.497  1.00 52.96           C  
ATOM    373  OE1 GLN    48      55.935  25.240  50.994  1.00 52.63           O  
ATOM    374  NE2 GLN    48      57.832  24.435  50.109  1.00 53.67           N  
ATOM    375  N   VAL    49      56.317  19.535  52.614  1.00 54.81           N  
ATOM    376  CA  VAL    49      57.488  18.670  52.818  1.00 55.38           C  
ATOM    377  C   VAL    49      57.248  17.310  52.183  1.00 56.25           C  
ATOM    378  O   VAL    49      58.153  16.711  51.607  1.00 57.04           O  
ATOM    379  CB  VAL    49      57.783  18.430  54.314  1.00 54.78           C  
ATOM    380  CG1 VAL    49      59.066  17.615  54.462  1.00 50.71           C  
ATOM    381  CG2 VAL    49      57.867  19.753  55.047  1.00 55.07           C  
ATOM    382  N   ALA    50      56.021  16.822  52.316  1.00 56.76           N  
ATOM    383  CA  ALA    50      55.654  15.545  51.745  1.00 58.30           C  
ATOM    384  C   ALA    50      56.038  15.564  50.272  1.00 59.67           C  
ATOM    385  O   ALA    50      56.610  14.604  49.755  1.00 57.63           O  
ATOM    386  CB  ALA    50      54.160  15.322  51.907  1.00 58.34           C  
ATOM    387  N   ARG    51      55.737  16.682  49.611  1.00 62.19           N  
ATOM    388  CA  ARG    51      56.050  16.852  48.194  1.00 64.33           C  
ATOM    389  C   ARG    51      57.538  17.027  47.924  1.00 65.11           C  
ATOM    390  O   ARG    51      58.094  16.363  47.050  1.00 65.40           O  
ATOM    391  CB  ARG    51      55.268  18.040  47.623  1.00 64.80           C  
ATOM    392  CG  ARG    51      53.784  17.756  47.591  1.00 67.41           C  
ATOM    393  CD  ARG    51      52.989  18.839  46.943  1.00 69.05           C  
ATOM    394  NE  ARG    51      51.632  18.378  46.650  1.00 73.30           N  
ATOM    395  CZ  ARG    51      51.312  17.445  45.747  1.00 75.30           C  
ATOM    396  NH1 ARG    51      52.253  16.844  45.011  1.00 75.42           N  
ATOM    397  NH2 ARG    51      50.038  17.103  45.582  1.00 73.72           N  
ATOM    398  N   ARG    52      58.188  17.910  48.674  1.00 66.46           N  
ATOM    399  CA  ARG    52      59.610  18.147  48.470  1.00 68.40           C  
ATOM    400  C   ARG    52      60.370  16.847  48.623  1.00 67.46           C  
ATOM    401  O   ARG    52      61.349  16.604  47.923  1.00 67.71           O  
ATOM    402  CB  ARG    52      60.143  19.191  49.466  1.00 71.19           C  
ATOM    403  CG  ARG    52      59.565  20.612  49.287  1.00 74.64           C  
ATOM    404  CD  ARG    52      60.065  21.296  48.026  1.00 78.11           C  
ATOM    405  NE  ARG    52      61.428  21.808  48.163  1.00 81.30           N  
ATOM    406  CZ  ARG    52      62.066  22.498  47.219  1.00 82.30           C  
ATOM    407  NH1 ARG    52      61.461  22.753  46.064  1.00 83.72           N  
ATOM    408  NH2 ARG    52      63.300  22.945  47.434  1.00 81.84           N  
ATOM    409  N   ALA    53      59.901  16.001  49.528  1.00 67.30           N  
ATOM    410  CA  ALA    53      60.547  14.716  49.778  1.00 67.24           C  
ATOM    411  C   ALA    53      60.333  13.712  48.645  1.00 66.18           C  
ATOM    412  O   ALA    53      61.044  12.724  48.551  1.00 66.08           O  
ATOM    413  CB  ALA    53      60.049  14.130  51.104  1.00 66.91           C  
ATOM    414  N   GLY    54      59.346  13.959  47.796  1.00 66.61           N  
ATOM    415  CA  GLY    54      59.084  13.061  46.680  1.00 66.95           C  
ATOM    416  C   GLY    54      58.595  11.668  47.031  1.00 66.69           C  
ATOM    417  O   GLY    54      58.419  11.331  48.200  1.00 67.38           O  
ATOM    418  N   GLY    55      58.384  10.850  46.004  1.00 66.40           N  
ATOM    419  CA  GLY    55      57.902   9.493  46.208  1.00 64.83           C  
ATOM    420  C   GLY    55      56.413   9.507  46.505  1.00 63.83           C  
ATOM    421  O   GLY    55      55.736  10.518  46.283  1.00 65.46           O  
ATOM    422  N   VAL    56      55.882   8.388  46.980  1.00 61.06           N  
ATOM    423  CA  VAL    56      54.473   8.329  47.335  1.00 59.01           C  
ATOM    424  C   VAL    56      54.444   8.493  48.848  1.00 59.02           C  
ATOM    425  O   VAL    56      54.379   7.520  49.606  1.00 58.31           O  
ATOM    426  CB  VAL    56      53.846   6.993  46.899  1.00 58.00           C  
ATOM    427  CG1 VAL    56      52.431   6.861  47.430  1.00 55.48           C  
ATOM    428  CG2 VAL    56      53.833   6.935  45.398  1.00 56.94           C  
ATOM    429  N   THR    57      54.512   9.751  49.265  1.00 58.91           N  
ATOM    430  CA  THR    57      54.548  10.110  50.666  1.00 60.26           C  
ATOM    431  C   THR    57      53.554  11.222  51.005  1.00 61.07           C  
ATOM    432  O   THR    57      53.426  12.214  50.287  1.00 61.21           O  
ATOM    433  CB  THR    57      55.966  10.519  51.025  1.00 60.36           C  
ATOM    434  OG1 THR    57      56.173  11.890  50.698  1.00 63.16           O  
ATOM    435  CG2 THR    57      56.938   9.720  50.192  1.00 60.95           C  
ATOM    436  N   VAL    58      52.857  11.052  52.122  1.00 62.40           N  
ATOM    437  CA  VAL    58      51.830  11.994  52.541  1.00 63.10           C  
ATOM    438  C   VAL    58      52.006  12.429  53.998  1.00 64.42           C  
ATOM    439  O   VAL    58      52.817  11.868  54.725  1.00 64.39           O  
ATOM    440  CB  VAL    58      50.430  11.338  52.321  1.00 62.60           C  
ATOM    441  CG1 VAL    58      49.333  12.120  53.002  1.00 64.47           C  
ATOM    442  CG2 VAL    58      50.144  11.252  50.833  1.00 62.43           C  
ATOM    443  N   ARG    59      51.252  13.444  54.409  1.00 65.27           N  
ATOM    444  CA  ARG    59      51.307  13.944  55.766  1.00 65.37           C  
ATOM    445  C   ARG    59      50.472  13.036  56.649  1.00 67.10           C  
ATOM    446  O   ARG    59      49.337  12.709  56.301  1.00 67.36           O  
ATOM    447  CB  ARG    59      50.727  15.348  55.829  1.00 64.65           C  
ATOM    448  CG  ARG    59      50.998  16.066  57.145  1.00 66.50           C  
ATOM    449  CD  ARG    59      49.984  17.161  57.412  1.00 65.18           C  
ATOM    450  NE  ARG    59      48.749  16.619  57.956  1.00 66.57           N  
ATOM    451  CZ  ARG    59      47.566  17.206  57.834  1.00 69.54           C  
ATOM    452  NH1 ARG    59      47.461  18.355  57.176  1.00 71.36           N  
ATOM    453  NH2 ARG    59      46.488  16.653  58.372  1.00 70.05           N  
ATOM    454  N   MET    60      51.041  12.633  57.785  1.00 69.34           N  
ATOM    455  CA  MET    60      50.363  11.778  58.765  1.00 70.74           C  
ATOM    456  C   MET    60      50.589  12.388  60.148  1.00 71.28           C  
ATOM    457  O   MET    60      51.671  12.259  60.737  1.00 70.32           O  
ATOM    458  CB  MET    60      50.916  10.344  58.720  1.00 71.15           C  
ATOM    459  CG  MET    60      50.323   9.408  59.774  1.00 72.41           C  
ATOM    460  SD  MET    60      50.765   7.647  59.568  1.00 76.54           S  
ATOM    461  CE  MET    60      52.561   7.653  59.924  1.00 72.22           C  
ATOM    462  N   GLY    61      49.566  13.068  60.654  1.00 71.30           N  
ATOM    463  CA  GLY    61      49.688  13.708  61.951  1.00 72.47           C  
ATOM    464  C   GLY    61      50.655  14.874  61.890  1.00 72.49           C  
ATOM    465  O   GLY    61      50.389  15.862  61.218  1.00 72.00           O  
ATOM    466  N   ASP    62      51.774  14.765  62.600  1.00 73.53           N  
ATOM    467  CA  ASP    62      52.782  15.821  62.590  1.00 74.35           C  
ATOM    468  C   ASP    62      54.004  15.338  61.828  1.00 73.21           C  
ATOM    469  O   ASP    62      55.075  15.958  61.863  1.00 73.65           O  
ATOM    470  CB  ASP    62      53.168  16.235  64.016  1.00 76.58           C  
ATOM    471  CG  ASP    62      52.167  17.212  64.626  1.00 80.10           C  
ATOM    472  OD1 ASP    62      51.050  16.786  64.991  1.00 81.23           O  
ATOM    473  OD2 ASP    62      52.488  18.418  64.721  1.00 81.56           O  
ATOM    474  N   GLY    63      53.824  14.225  61.126  1.00 70.80           N  
ATOM    475  CA  GLY    63      54.908  13.669  60.344  1.00 68.57           C  
ATOM    476  C   GLY    63      54.435  13.196  58.981  1.00 66.72           C  
ATOM    477  O   GLY    63      53.360  13.570  58.503  1.00 64.94           O  
ATOM    478  N   LEU    64      55.255  12.357  58.364  1.00 65.09           N  
ATOM    479  CA  LEU    64      54.963  11.805  57.057  1.00 63.34           C  
ATOM    480  C   LEU    64      54.655  10.320  57.135  1.00 63.32           C  
ATOM    481  O   LEU    64      54.852   9.682  58.168  1.00 63.93           O  
ATOM    482  CB  LEU    64      56.157  12.028  56.125  1.00 61.08           C  
ATOM    483  CG  LEU    64      56.484  13.506  55.874  1.00 61.83           C  
ATOM    484  CD1 LEU    64      57.670  13.666  54.911  1.00 59.79           C  
ATOM    485  CD2 LEU    64      55.235  14.182  55.313  1.00 61.16           C  
ATOM    486  N   ALA    65      54.142   9.798  56.028  1.00 63.24           N  
ATOM    487  CA  ALA    65      53.818   8.386  55.854  1.00 63.13           C  
ATOM    488  C   ALA    65      54.170   8.162  54.388  1.00 63.94           C  
ATOM    489  O   ALA    65      53.835   8.989  53.534  1.00 62.58           O  
ATOM    490  CB  ALA    65      52.325   8.128  56.100  1.00 61.52           C  
ATOM    491  N   SER    66      54.863   7.071  54.087  1.00 65.58           N  
ATOM    492  CA  SER    66      55.246   6.820  52.704  1.00 67.35           C  
ATOM    493  C   SER    66      55.129   5.367  52.256  1.00 69.66           C  
ATOM    494  O   SER    66      55.250   4.444  53.059  1.00 70.26           O  
ATOM    495  CB  SER    66      56.668   7.315  52.477  1.00 64.54           C  
ATOM    496  OG  SER    66      57.061   7.109  51.139  1.00 63.06           O  
ATOM    497  N   TRP    67      54.871   5.179  50.965  1.00 72.52           N  
ATOM    498  CA  TRP    67      54.752   3.846  50.382  1.00 75.39           C  
ATOM    499  C   TRP    67      55.957   3.551  49.512  1.00 78.89           C  
ATOM    500  O   TRP    67      56.157   2.419  49.082  1.00 81.57           O  
ATOM    501  CB  TRP    67      53.505   3.719  49.507  1.00 72.67           C  
ATOM    502  CG  TRP    67      52.286   3.263  50.216  1.00 71.31           C  
ATOM    503  CD1 TRP    67      52.213   2.731  51.467  1.00 69.87           C  
ATOM    504  CD2 TRP    67      50.946   3.301  49.715  1.00 71.03           C  
ATOM    505  NE1 TRP    67      50.910   2.438  51.781  1.00 68.32           N  
ATOM    506  CE2 TRP    67      50.110   2.778  50.724  1.00 69.96           C  
ATOM    507  CE3 TRP    67      50.370   3.729  48.510  1.00 70.57           C  
ATOM    508  CZ2 TRP    67      48.725   2.671  50.567  1.00 69.36           C  
ATOM    509  CZ3 TRP    67      48.995   3.623  48.355  1.00 70.36           C  
ATOM    510  CH2 TRP    67      48.188   3.098  49.380  1.00 70.09           C  
ATOM    511  N   SER    68      56.748   4.567  49.212  1.00 81.18           N  
ATOM    512  CA  SER    68      57.914   4.330  48.394  1.00 83.94           C  
ATOM    513  C   SER    68      59.086   4.045  49.318  1.00 86.03           C  
ATOM    514  O   SER    68      59.099   4.489  50.467  1.00 86.11           O  
ATOM    515  CB  SER    68      58.191   5.540  47.500  1.00 83.99           C  
ATOM    516  OG  SER    68      57.568   6.694  48.017  1.00 85.05           O  
ATOM    517  N   PRO    69      60.077   3.276  48.837  1.00 88.14           N  
ATOM    518  CA  PRO    69      61.256   2.939  49.640  1.00 89.43           C  
ATOM    519  C   PRO    69      61.896   4.166  50.278  1.00 91.07           C  
ATOM    520  O   PRO    69      62.217   5.136  49.589  1.00 91.30           O  
ATOM    521  CB  PRO    69      62.181   2.253  48.629  1.00 88.99           C  
ATOM    522  CG  PRO    69      61.721   2.783  47.299  1.00 88.42           C  
ATOM    523  CD  PRO    69      60.230   2.776  47.460  1.00 88.67           C  
ATOM    524  N   PRO    70      62.088   4.136  51.611  1.00 92.83           N  
ATOM    525  CA  PRO    70      62.694   5.253  52.357  1.00 93.44           C  
ATOM    526  C   PRO    70      64.003   5.793  51.766  1.00 93.26           C  
ATOM    527  O   PRO    70      64.381   6.935  52.021  1.00 93.85           O  
ATOM    528  CB  PRO    70      62.879   4.670  53.760  1.00 93.43           C  
ATOM    529  CG  PRO    70      61.679   3.744  53.879  1.00 93.42           C  
ATOM    530  CD  PRO    70      61.673   3.051  52.525  1.00 92.86           C  
ATOM    531  N   GLU    71      64.682   4.974  50.972  1.00 92.77           N  
ATOM    532  CA  GLU    71      65.937   5.370  50.348  1.00 92.08           C  
ATOM    533  C   GLU    71      65.696   6.350  49.200  1.00 90.64           C  
ATOM    534  O   GLU    71      66.561   7.158  48.866  1.00 90.13           O  
ATOM    535  CB  GLU    71      66.655   4.128  49.823  1.00 94.88           C  
ATOM    536  CG  GLU    71      68.035   4.382  49.206  1.00 98.59           C  
ATOM    537  CD  GLU    71      69.138   4.633  50.239  1.00100.44           C  
ATOM    538  OE1 GLU    71      69.273   5.781  50.728  1.00100.50           O  
ATOM    539  OE2 GLU    71      69.873   3.670  50.563  1.00101.27           O  
ATOM    540  N   VAL    72      64.511   6.274  48.605  1.00 88.71           N  
ATOM    541  CA  VAL    72      64.144   7.141  47.490  1.00 87.53           C  
ATOM    542  C   VAL    72      63.788   8.579  47.885  1.00 86.28           C  
ATOM    543  O   VAL    72      63.810   9.481  47.048  1.00 85.94           O  
ATOM    544  CB  VAL    72      62.953   6.533  46.704  1.00 88.38           C  
ATOM    545  CG1 VAL    72      62.379   7.545  45.703  1.00 87.08           C  
ATOM    546  CG2 VAL    72      63.418   5.284  45.979  1.00 89.38           C  
ATOM    547  N   LEU    73      63.470   8.800  49.153  1.00 84.27           N  
ATOM    548  CA  LEU    73      63.096  10.134  49.600  1.00 83.00           C  
ATOM    549  C   LEU    73      64.208  11.174  49.630  1.00 82.79           C  
ATOM    550  O   LEU    73      65.390  10.837  49.631  1.00 84.98           O  
ATOM    551  CB  LEU    73      62.468  10.052  50.986  1.00 81.57           C  
ATOM    552  CG  LEU    73      61.165   9.263  51.040  1.00 80.89           C  
ATOM    553  CD1 LEU    73      60.605   9.287  52.444  1.00 79.10           C  
ATOM    554  CD2 LEU    73      60.181   9.867  50.058  1.00 79.77           C  
ATOM    555  N   VAL    74      63.803  12.443  49.626  1.00 81.87           N  
ATOM    556  CA  VAL    74      64.718  13.580  49.728  1.00 80.73           C  
ATOM    557  C   VAL    74      64.529  14.033  51.184  1.00 80.49           C  
ATOM    558  O   VAL    74      63.687  14.888  51.484  1.00 79.98           O  
ATOM    559  CB  VAL    74      64.328  14.730  48.756  1.00 80.73           C  
ATOM    560  CG1 VAL    74      65.025  16.023  49.150  1.00 80.34           C  
ATOM    561  CG2 VAL    74      64.725  14.368  47.335  1.00 80.16           C  
ATOM    562  N   LEU    75      65.304  13.415  52.074  1.00 79.27           N  
ATOM    563  CA  LEU    75      65.264  13.658  53.510  1.00 78.79           C  
ATOM    564  C   LEU    75      65.541  15.086  53.975  1.00 78.53           C  
ATOM    565  O   LEU    75      65.133  15.472  55.083  1.00 78.31           O  
ATOM    566  CB  LEU    75      66.242  12.714  54.201  1.00 80.83           C  
ATOM    567  CG  LEU    75      66.041  11.210  54.004  1.00 81.40           C  
ATOM    568  CD1 LEU    75      67.318  10.482  54.408  1.00 80.92           C  
ATOM    569  CD2 LEU    75      64.843  10.731  54.828  1.00 81.83           C  
ATOM    570  N   GLU    76      66.243  15.861  53.150  1.00 77.01           N  
ATOM    571  CA  GLU    76      66.552  17.248  53.492  1.00 76.77           C  
ATOM    572  C   GLU    76      66.292  18.249  52.360  1.00 75.25           C  
ATOM    573  O   GLU    76      66.612  18.000  51.196  1.00 74.23           O  
ATOM    574  CB  GLU    76      68.011  17.362  53.961  1.00 78.64           C  
ATOM    575  CG  GLU    76      68.243  16.965  55.417  1.00 80.93           C  
ATOM    576  CD  GLU    76      69.718  16.945  55.795  1.00 84.16           C  
ATOM    577  OE1 GLU    76      70.469  16.121  55.226  1.00 87.23           O  
ATOM    578  OE2 GLU    76      70.133  17.750  56.659  1.00 84.83           O  
ATOM    579  N   GLY    77      65.708  19.388  52.716  1.00 74.39           N  
ATOM    580  CA  GLY    77      65.423  20.415  51.730  1.00 74.55           C  
ATOM    581  C   GLY    77      64.874  21.683  52.359  1.00 74.98           C  
ATOM    582  O   GLY    77      64.799  21.788  53.590  1.00 74.12           O  
ATOM    583  N   THR    78      64.479  22.642  51.518  1.00 75.42           N  
ATOM    584  CA  THR    78      63.941  23.923  51.997  1.00 76.18           C  
ATOM    585  C   THR    78      62.475  24.113  51.596  1.00 75.16           C  
ATOM    586  O   THR    78      61.939  23.351  50.795  1.00 75.02           O  
ATOM    587  CB  THR    78      64.743  25.123  51.426  1.00 76.59           C  
ATOM    588  OG1 THR    78      64.280  25.409  50.100  1.00 77.86           O  
ATOM    589  CG2 THR    78      66.245  24.797  51.369  1.00 75.66           C  
ATOM    590  N   LEU    79      61.832  25.137  52.147  1.00 73.95           N  
ATOM    591  CA  LEU    79      60.433  25.405  51.828  1.00 73.24           C  
ATOM    592  C   LEU    79      60.121  26.901  51.788  1.00 73.64           C  
ATOM    593  O   LEU    79      60.907  27.731  52.254  1.00 74.38           O  
ATOM    594  CB  LEU    79      59.510  24.764  52.864  1.00 72.35           C  
ATOM    595  CG  LEU    79      59.750  23.337  53.337  1.00 72.03           C  
ATOM    596  CD1 LEU    79      60.847  23.354  54.385  1.00 71.90           C  
ATOM    597  CD2 LEU    79      58.462  22.769  53.929  1.00 70.59           C  
ATOM    598  N   ALA    80      58.962  27.238  51.234  1.00 72.27           N  
ATOM    599  CA  ALA    80      58.531  28.619  51.175  1.00 72.07           C  
ATOM    600  C   ALA    80      57.011  28.648  51.264  1.00 73.14           C  
ATOM    601  O   ALA    80      56.333  27.979  50.491  1.00 73.49           O  
ATOM    602  CB  ALA    80      59.012  29.266  49.884  1.00 69.04           C  
ATOM    603  N   ARG    81      56.482  29.376  52.237  1.00 75.37           N  
ATOM    604  CA  ARG    81      55.046  29.500  52.359  1.00 79.22           C  
ATOM    605  C   ARG    81      54.694  30.957  52.566  1.00 81.53           C  
ATOM    606  O   ARG    81      54.899  31.543  53.638  1.00 81.51           O  
ATOM    607  CB  ARG    81      54.475  28.670  53.496  1.00 79.76           C  
ATOM    608  CG  ARG    81      52.968  28.705  53.486  1.00 82.64           C  
ATOM    609  CD  ARG    81      52.389  27.430  54.022  1.00 85.88           C  
ATOM    610  NE  ARG    81      50.947  27.357  53.805  1.00 87.01           N  
ATOM    611  CZ  ARG    81      50.068  28.200  54.337  1.00 87.10           C  
ATOM    612  NH1 ARG    81      50.489  29.186  55.121  1.00 85.02           N  
ATOM    613  NH2 ARG    81      48.768  28.048  54.090  1.00 87.32           N  
ATOM    614  N   MET    82      54.161  31.538  51.503  1.00 84.70           N  
ATOM    615  CA  MET    82      53.818  32.938  51.454  1.00 88.04           C  
ATOM    616  C   MET    82      55.014  33.758  51.857  1.00 88.73           C  
ATOM    617  O   MET    82      55.102  34.234  53.000  1.00 88.17           O  
ATOM    618  CB  MET    82      52.680  33.325  52.364  1.00 90.34           C  
ATOM    619  CG  MET    82      51.747  34.203  51.557  1.00 95.42           C  
ATOM    620  SD  MET    82      51.571  35.953  51.960  1.00100.81           S  
ATOM    621  CE  MET    82      50.198  35.799  53.063  1.00 98.53           C  
ATOM    622  N   GLY    83      55.946  33.898  50.917  1.00 89.02           N  
ATOM    623  CA  GLY    83      57.141  34.684  51.149  1.00 89.17           C  
ATOM    624  C   GLY    83      58.145  34.055  52.095  1.00 90.26           C  
ATOM    625  O   GLY    83      59.344  34.004  51.778  1.00 89.99           O  
ATOM    626  N   GLN    84      57.657  33.588  53.249  1.00 89.71           N  
ATOM    627  CA  GLN    84      58.484  32.969  54.277  1.00 88.38           C  
ATOM    628  C   GLN    84      59.073  31.621  53.859  1.00 86.33           C  
ATOM    629  O   GLN    84      58.424  30.842  53.160  1.00 86.34           O  
ATOM    630  CB  GLN    84      57.661  32.810  55.555  1.00 89.73           C  
ATOM    631  CG  GLN    84      57.064  34.120  56.041  1.00 91.60           C  
ATOM    632  CD  GLN    84      56.553  34.030  57.467  1.00 93.44           C  
ATOM    633  OE1 GLN    84      55.661  33.235  57.774  1.00 94.84           O  
ATOM    634  NE2 GLN    84      57.121  34.849  58.351  1.00 93.63           N  
ATOM    635  N   THR    85      60.302  31.356  54.302  1.00 83.70           N  
ATOM    636  CA  THR    85      60.999  30.110  53.976  1.00 80.91           C  
ATOM    637  C   THR    85      61.573  29.385  55.211  1.00 80.01           C  
ATOM    638  O   THR    85      61.902  30.019  56.214  1.00 80.79           O  
ATOM    639  CB  THR    85      62.127  30.392  52.966  1.00 78.91           C  
ATOM    640  OG1 THR    85      63.369  29.897  53.472  1.00 78.65           O  
ATOM    641  CG2 THR    85      62.237  31.887  52.714  1.00 78.72           C  
ATOM    642  N   TYR    86      61.665  28.058  55.139  1.00 77.27           N  
ATOM    643  CA  TYR    86      62.197  27.254  56.239  1.00 75.05           C  
ATOM    644  C   TYR    86      62.973  26.059  55.707  1.00 73.22           C  
ATOM    645  O   TYR    86      62.961  25.774  54.512  1.00 74.03           O  
ATOM    646  CB  TYR    86      61.091  26.687  57.124  1.00 76.08           C  
ATOM    647  CG  TYR    86      59.963  27.611  57.466  1.00 77.76           C  
ATOM    648  CD1 TYR    86      58.968  27.900  56.536  1.00 78.94           C  
ATOM    649  CD2 TYR    86      59.852  28.150  58.746  1.00 79.84           C  
ATOM    650  CE1 TYR    86      57.886  28.698  56.871  1.00 81.19           C  
ATOM    651  CE2 TYR    86      58.772  28.951  59.094  1.00 81.98           C  
ATOM    652  CZ  TYR    86      57.792  29.219  58.152  1.00 82.21           C  
ATOM    653  OH  TYR    86      56.711  29.991  58.502  1.00 84.25           O  
ATOM    654  N   ALA    87      63.630  25.345  56.609  1.00 70.70           N  
ATOM    655  CA  ALA    87      64.391  24.167  56.226  1.00 69.87           C  
ATOM    656  C   ALA    87      63.853  22.974  57.010  1.00 68.73           C  
ATOM    657  O   ALA    87      63.520  23.099  58.190  1.00 67.93           O  
ATOM    658  CB  ALA    87      65.873  24.374  56.519  1.00 69.56           C  
ATOM    659  N   TYR    88      63.753  21.826  56.347  1.00 67.54           N  
ATOM    660  CA  TYR    88      63.246  20.629  56.994  1.00 66.96           C  
ATOM    661  C   TYR    88      64.239  19.482  56.955  1.00 67.90           C  
ATOM    662  O   TYR    88      65.100  19.413  56.069  1.00 66.41           O  
ATOM    663  CB  TYR    88      61.933  20.154  56.333  1.00 66.22           C  
ATOM    664  CG  TYR    88      62.093  19.490  54.977  1.00 63.63           C  
ATOM    665  CD1 TYR    88      62.032  20.237  53.809  1.00 63.98           C  
ATOM    666  CD2 TYR    88      62.351  18.121  54.867  1.00 64.14           C  
ATOM    667  CE1 TYR    88      62.223  19.651  52.563  1.00 63.38           C  
ATOM    668  CE2 TYR    88      62.548  17.518  53.622  1.00 63.25           C  
ATOM    669  CZ  TYR    88      62.479  18.295  52.476  1.00 63.94           C  
ATOM    670  OH  TYR    88      62.626  17.724  51.235  1.00 64.38           O  
ATOM    671  N   ARG    89      64.100  18.583  57.924  1.00 69.39           N  
ATOM    672  CA  ARG    89      64.931  17.386  58.005  1.00 72.92           C  
ATOM    673  C   ARG    89      64.022  16.229  58.406  1.00 73.09           C  
ATOM    674  O   ARG    89      63.246  16.349  59.352  1.00 73.31           O  
ATOM    675  CB  ARG    89      66.047  17.549  59.043  1.00 75.50           C  
ATOM    676  CG  ARG    89      67.085  16.427  58.994  1.00 79.80           C  
ATOM    677  CD  ARG    89      68.336  16.743  59.812  1.00 83.55           C  
ATOM    678  NE  ARG    89      69.440  15.845  59.469  1.00 87.05           N  
ATOM    679  CZ  ARG    89      70.708  16.028  59.833  1.00 88.31           C  
ATOM    680  NH1 ARG    89      71.044  17.083  60.568  1.00 88.19           N  
ATOM    681  NH2 ARG    89      71.649  15.170  59.438  1.00 88.27           N  
ATOM    682  N   LEU    90      64.106  15.114  57.689  1.00 73.07           N  
ATOM    683  CA  LEU    90      63.263  13.965  58.008  1.00 73.71           C  
ATOM    684  C   LEU    90      63.984  12.922  58.871  1.00 73.47           C  
ATOM    685  O   LEU    90      65.198  12.758  58.780  1.00 73.74           O  
ATOM    686  CB  LEU    90      62.772  13.324  56.707  1.00 73.94           C  
ATOM    687  CG  LEU    90      62.064  14.282  55.736  1.00 74.32           C  
ATOM    688  CD1 LEU    90      61.954  13.640  54.369  1.00 75.25           C  
ATOM    689  CD2 LEU    90      60.680  14.647  56.271  1.00 75.34           C  
ATOM    690  N   TYR    91      63.237  12.227  59.720  1.00 73.45           N  
ATOM    691  CA  TYR    91      63.823  11.192  60.568  1.00 73.97           C  
ATOM    692  C   TYR    91      63.073   9.884  60.436  1.00 73.33           C  
ATOM    693  O   TYR    91      62.068   9.671  61.111  1.00 71.48           O  
ATOM    694  CB  TYR    91      63.812  11.610  62.037  1.00 75.74           C  
ATOM    695  CG  TYR    91      64.724  12.767  62.341  1.00 77.59           C  
ATOM    696  CD1 TYR    91      64.381  14.065  61.955  1.00 78.20           C  
ATOM    697  CD2 TYR    91      65.936  12.571  63.005  1.00 76.37           C  
ATOM    698  CE1 TYR    91      65.221  15.140  62.225  1.00 77.92           C  
ATOM    699  CE2 TYR    91      66.779  13.640  63.278  1.00 77.61           C  
ATOM    700  CZ  TYR    91      66.412  14.922  62.884  1.00 77.79           C  
ATOM    701  OH  TYR    91      67.228  15.991  63.146  1.00 77.66           O  
ATOM    702  N   PRO    92      63.556   8.987  59.564  1.00 74.28           N  
ATOM    703  CA  PRO    92      62.923   7.681  59.340  1.00 75.86           C  
ATOM    704  C   PRO    92      62.678   6.945  60.657  1.00 77.85           C  
ATOM    705  O   PRO    92      63.617   6.696  61.413  1.00 78.12           O  
ATOM    706  CB  PRO    92      63.931   6.963  58.445  1.00 74.68           C  
ATOM    707  CG  PRO    92      64.537   8.083  57.657  1.00 73.69           C  
ATOM    708  CD  PRO    92      64.756   9.140  58.723  1.00 73.77           C  
ATOM    709  N   LYS    93      61.417   6.617  60.936  1.00 79.56           N  
ATOM    710  CA  LYS    93      61.076   5.921  62.169  1.00 82.42           C  
ATOM    711  C   LYS    93      60.353   4.603  61.942  1.00 84.41           C  
ATOM    712  O   LYS    93      59.466   4.219  62.714  1.00 84.83           O  
ATOM    713  CB  LYS    93      60.248   6.823  63.101  1.00 83.14           C  
ATOM    714  CG  LYS    93      61.108   7.787  63.920  1.00 83.86           C  
ATOM    715  CD  LYS    93      60.371   8.350  65.122  0.00 83.81           C  
ATOM    716  CE  LYS    93      61.326   9.128  66.018  0.00 83.93           C  
ATOM    717  NZ  LYS    93      60.673   9.602  67.268  0.00 83.98           N  
ATOM    718  N   GLY    94      60.738   3.909  60.877  1.00 86.02           N  
ATOM    719  CA  GLY    94      60.140   2.620  60.583  1.00 87.84           C  
ATOM    720  C   GLY    94      58.709   2.574  60.076  1.00 88.54           C  
ATOM    721  O   GLY    94      58.070   3.597  59.814  1.00 88.61           O  
ATOM    722  N   ARG    95      58.208   1.347  59.969  1.00 88.65           N  
ATOM    723  CA  ARG    95      56.875   1.062  59.460  1.00 88.95           C  
ATOM    724  C   ARG    95      55.827   0.993  60.542  1.00 89.53           C  
ATOM    725  O   ARG    95      56.041   0.434  61.607  1.00 90.38           O  
ATOM    726  CB  ARG    95      56.939  -0.235  58.692  1.00 89.03           C  
ATOM    727  CG  ARG    95      55.660  -0.635  58.057  1.00 89.80           C  
ATOM    728  CD  ARG    95      55.932  -1.702  56.996  1.00 90.85           C  
ATOM    729  NE  ARG    95      56.852  -1.235  55.958  1.00 91.92           N  
ATOM    730  CZ  ARG    95      56.714  -1.492  54.658  1.00 92.23           C  
ATOM    731  NH1 ARG    95      55.685  -2.210  54.226  1.00 92.90           N  
ATOM    732  NH2 ARG    95      57.609  -1.043  53.787  1.00 90.98           N  
ATOM    733  N   ARG    96      54.662   1.546  60.239  1.00 89.89           N  
ATOM    734  CA  ARG    96      53.595   1.621  61.228  1.00 91.08           C  
ATOM    735  C   ARG    96      52.238   1.360  60.619  1.00 91.66           C  
ATOM    736  O   ARG    96      51.778   2.109  59.757  1.00 93.50           O  
ATOM    737  CB  ARG    96      53.522   2.968  61.886  1.00 90.73           C  
ATOM    738  CG  ARG    96      52.038   3.342  62.122  1.00 92.57           C  
ATOM    739  CD  ARG    96      51.752   4.592  62.906  1.00 94.05           C  
ATOM    740  NE  ARG    96      50.313   4.789  63.076  1.00 95.71           N  
ATOM    741  CZ  ARG    96      49.713   5.946  63.352  1.00 96.92           C  
ATOM    742  NH1 ARG    96      50.425   7.053  63.495  1.00 96.76           N  
ATOM    743  NH2 ARG    96      48.383   5.987  63.475  1.00 96.38           N  
ATOM    744  N   PRO    97      51.524   0.356  61.154  1.00 90.60           N  
ATOM    745  CA  PRO    97      50.191  -0.065  60.693  1.00 89.48           C  
ATOM    746  C   PRO    97      48.978   0.872  60.896  1.00 88.63           C  
ATOM    747  O   PRO    97      48.822   1.536  61.935  1.00 88.58           O  
ATOM    748  CB  PRO    97      49.981  -1.359  61.459  1.00 90.16           C  
ATOM    749  CG  PRO    97      50.550  -0.981  62.800  1.00 90.97           C  
ATOM    750  CD  PRO    97      51.837  -0.271  62.462  1.00 90.82           C  
ATOM    751  N   LEU    98      48.086   0.876  59.908  1.00 87.92           N  
ATOM    752  CA  LEU    98      46.852   1.679  59.909  1.00 87.54           C  
ATOM    753  C   LEU    98      45.641   0.780  59.628  1.00 86.35           C  
ATOM    754  O   LEU    98      45.745  -0.173  58.859  1.00 86.40           O  
ATOM    755  CB  LEU    98      46.911   2.768  58.822  1.00 89.09           C  
ATOM    756  CG  LEU    98      47.644   4.109  58.968  1.00 88.65           C  
ATOM    757  CD1 LEU    98      49.045   3.940  59.521  1.00 89.22           C  
ATOM    758  CD2 LEU    98      47.712   4.745  57.589  1.00 89.87           C  
ATOM    759  N   ASP    99      44.496   1.091  60.237  1.00 85.53           N  
ATOM    760  CA  ASP    99      43.278   0.289  60.041  1.00 84.74           C  
ATOM    761  C   ASP    99      42.159   0.999  59.284  1.00 81.33           C  
ATOM    762  O   ASP    99      41.670   2.054  59.692  1.00 80.11           O  
ATOM    763  CB  ASP    99      42.725  -0.242  61.384  1.00 88.35           C  
ATOM    764  CG  ASP    99      42.224   0.868  62.316  1.00 92.89           C  
ATOM    765  OD1 ASP    99      41.730   0.534  63.424  1.00 95.55           O  
ATOM    766  OD2 ASP    99      42.325   2.066  61.956  1.00 93.80           O  
ATOM    767  N   PRO   100      41.737   0.410  58.163  1.00 78.86           N  
ATOM    768  CA  PRO   100      40.674   0.945  57.306  1.00 78.44           C  
ATOM    769  C   PRO   100      39.360   1.178  58.059  1.00 77.45           C  
ATOM    770  O   PRO   100      38.489   1.927  57.613  1.00 75.53           O  
ATOM    771  CB  PRO   100      40.540  -0.128  56.220  1.00 78.10           C  
ATOM    772  CG  PRO   100      41.927  -0.685  56.129  1.00 77.63           C  
ATOM    773  CD  PRO   100      42.346  -0.792  57.566  1.00 77.31           C  
ATOM    774  N   LYS   101      39.234   0.528  59.207  1.00 78.45           N  
ATOM    775  CA  LYS   101      38.036   0.627  60.029  1.00 79.90           C  
ATOM    776  C   LYS   101      37.967   1.948  60.801  1.00 79.56           C  
ATOM    777  O   LYS   101      36.885   2.405  61.159  1.00 77.93           O  
ATOM    778  CB  LYS   101      37.991  -0.549  61.005  1.00 81.68           C  
ATOM    779  CG  LYS   101      38.480  -1.865  60.414  1.00 83.52           C  
ATOM    780  CD  LYS   101      40.002  -1.878  60.264  1.00 83.96           C  
ATOM    781  CE  LYS   101      40.473  -3.135  59.539  1.00 84.31           C  
ATOM    782  NZ  LYS   101      41.955  -3.210  59.437  1.00 84.04           N  
ATOM    783  N   ASP   102      39.129   2.551  61.041  1.00 80.64           N  
ATOM    784  CA  ASP   102      39.234   3.817  61.761  1.00 82.70           C  
ATOM    785  C   ASP   102      39.176   5.025  60.814  1.00 82.44           C  
ATOM    786  O   ASP   102      40.081   5.235  59.997  1.00 79.79           O  
ATOM    787  CB  ASP   102      40.541   3.850  62.555  1.00 85.74           C  
ATOM    788  CG  ASP   102      40.646   5.056  63.475  1.00 89.25           C  
ATOM    789  OD1 ASP   102      40.780   6.196  62.968  1.00 89.10           O  
ATOM    790  OD2 ASP   102      40.594   4.852  64.716  1.00 92.75           O  
ATOM    791  N   PRO   103      38.118   5.851  60.944  1.00 82.42           N  
ATOM    792  CA  PRO   103      37.898   7.046  60.124  1.00 82.10           C  
ATOM    793  C   PRO   103      39.133   7.908  59.860  1.00 80.70           C  
ATOM    794  O   PRO   103      39.308   8.421  58.753  1.00 80.86           O  
ATOM    795  CB  PRO   103      36.808   7.792  60.897  1.00 81.86           C  
ATOM    796  CG  PRO   103      35.983   6.671  61.431  1.00 81.48           C  
ATOM    797  CD  PRO   103      37.062   5.740  61.971  1.00 82.18           C  
ATOM    798  N   GLY   104      39.988   8.049  60.864  1.00 79.06           N  
ATOM    799  CA  GLY   104      41.177   8.864  60.700  1.00 78.37           C  
ATOM    800  C   GLY   104      42.316   8.198  59.953  1.00 78.10           C  
ATOM    801  O   GLY   104      42.884   8.779  59.025  1.00 77.03           O  
ATOM    802  N   GLU   105      42.659   6.981  60.360  1.00 78.40           N  
ATOM    803  CA  GLU   105      43.744   6.240  59.725  1.00 78.99           C  
ATOM    804  C   GLU   105      43.413   5.894  58.278  1.00 77.22           C  
ATOM    805  O   GLU   105      44.285   5.858  57.419  1.00 77.36           O  
ATOM    806  CB  GLU   105      44.048   4.974  60.528  1.00 81.54           C  
ATOM    807  CG  GLU   105      45.054   5.222  61.641  1.00 87.07           C  
ATOM    808  CD  GLU   105      44.955   4.232  62.795  1.00 90.76           C  
ATOM    809  OE1 GLU   105      45.013   3.005  62.546  1.00 92.73           O  
ATOM    810  OE2 GLU   105      44.829   4.689  63.957  1.00 92.21           O  
ATOM    811  N   ARG   106      42.142   5.654  58.013  1.00 75.03           N  
ATOM    812  CA  ARG   106      41.705   5.331  56.675  1.00 73.33           C  
ATOM    813  C   ARG   106      41.866   6.555  55.777  1.00 72.50           C  
ATOM    814  O   ARG   106      42.196   6.428  54.598  1.00 72.89           O  
ATOM    815  CB  ARG   106      40.243   4.905  56.703  1.00 73.84           C  
ATOM    816  CG  ARG   106      39.655   4.610  55.355  1.00 77.66           C  
ATOM    817  CD  ARG   106      38.140   4.759  55.372  1.00 81.26           C  
ATOM    818  NE  ARG   106      37.583   4.603  54.032  1.00 85.82           N  
ATOM    819  CZ  ARG   106      36.351   4.962  53.678  1.00 88.83           C  
ATOM    820  NH1 ARG   106      35.532   5.506  54.572  1.00 89.61           N  
ATOM    821  NH2 ARG   106      35.940   4.785  52.423  1.00 89.25           N  
ATOM    822  N   SER   107      41.633   7.742  56.333  1.00 70.78           N  
ATOM    823  CA  SER   107      41.744   8.972  55.549  1.00 67.82           C  
ATOM    824  C   SER   107      43.176   9.174  55.080  1.00 66.49           C  
ATOM    825  O   SER   107      43.404   9.793  54.035  1.00 66.15           O  
ATOM    826  CB  SER   107      41.315  10.190  56.368  1.00 66.66           C  
ATOM    827  OG  SER   107      42.429  10.756  57.037  1.00 68.47           O  
ATOM    828  N   VAL   108      44.127   8.651  55.858  1.00 64.47           N  
ATOM    829  CA  VAL   108      45.549   8.755  55.549  1.00 62.95           C  
ATOM    830  C   VAL   108      45.921   7.759  54.472  1.00 63.50           C  
ATOM    831  O   VAL   108      46.596   8.109  53.502  1.00 64.63           O  
ATOM    832  CB  VAL   108      46.429   8.496  56.800  1.00 62.97           C  
ATOM    833  CG1 VAL   108      47.877   8.232  56.397  1.00 60.07           C  
ATOM    834  CG2 VAL   108      46.361   9.699  57.725  1.00 63.07           C  
ATOM    835  N   LEU   109      45.482   6.515  54.632  1.00 63.15           N  
ATOM    836  CA  LEU   109      45.787   5.491  53.635  1.00 62.19           C  
ATOM    837  C   LEU   109      45.290   5.942  52.257  1.00 60.92           C  
ATOM    838  O   LEU   109      45.945   5.686  51.249  1.00 60.16           O  
ATOM    839  CB  LEU   109      45.147   4.145  54.026  1.00 60.53           C  
ATOM    840  CG  LEU   109      45.900   3.301  55.070  1.00 60.39           C  
ATOM    841  CD1 LEU   109      44.999   2.165  55.552  1.00 58.69           C  
ATOM    842  CD2 LEU   109      47.205   2.765  54.486  1.00 55.69           C  
ATOM    843  N   SER   110      44.140   6.616  52.240  1.00 58.67           N  
ATOM    844  CA  SER   110      43.528   7.117  51.015  1.00 58.92           C  
ATOM    845  C   SER   110      44.305   8.276  50.422  1.00 58.98           C  
ATOM    846  O   SER   110      44.239   8.524  49.218  1.00 58.97           O  
ATOM    847  CB  SER   110      42.092   7.587  51.269  1.00 58.40           C  
ATOM    848  OG  SER   110      41.194   6.498  51.302  1.00 59.26           O  
ATOM    849  N   ALA   111      45.009   9.006  51.277  1.00 57.94           N  
ATOM    850  CA  ALA   111      45.800  10.128  50.821  1.00 56.24           C  
ATOM    851  C   ALA   111      46.970   9.522  50.079  1.00 55.63           C  
ATOM    852  O   ALA   111      47.416  10.037  49.065  1.00 57.35           O  
ATOM    853  CB  ALA   111      46.282  10.926  51.989  1.00 55.30           C  
ATOM    854  N   LEU   112      47.472   8.416  50.595  1.00 54.79           N  
ATOM    855  CA  LEU   112      48.578   7.749  49.942  1.00 55.19           C  
ATOM    856  C   LEU   112      48.104   7.275  48.576  1.00 53.33           C  
ATOM    857  O   LEU   112      48.802   7.438  47.587  1.00 53.50           O  
ATOM    858  CB  LEU   112      49.076   6.573  50.794  1.00 55.11           C  
ATOM    859  CG  LEU   112      49.862   7.035  52.030  1.00 56.18           C  
ATOM    860  CD1 LEU   112      49.829   5.963  53.111  1.00 55.35           C  
ATOM    861  CD2 LEU   112      51.307   7.388  51.622  1.00 54.94           C  
ATOM    862  N   ALA   113      46.907   6.709  48.533  1.00 51.67           N  
ATOM    863  CA  ALA   113      46.326   6.221  47.292  1.00 51.20           C  
ATOM    864  C   ALA   113      46.153   7.357  46.274  1.00 50.60           C  
ATOM    865  O   ALA   113      46.504   7.200  45.117  1.00 50.46           O  
ATOM    866  CB  ALA   113      44.989   5.575  47.576  1.00 52.01           C  
ATOM    867  N   ARG   114      45.613   8.489  46.716  1.00 49.15           N  
ATOM    868  CA  ARG   114      45.409   9.632  45.856  1.00 49.51           C  
ATOM    869  C   ARG   114      46.769   9.996  45.270  1.00 51.04           C  
ATOM    870  O   ARG   114      46.915  10.198  44.061  1.00 51.84           O  
ATOM    871  CB  ARG   114      44.826  10.810  46.660  1.00 49.19           C  
ATOM    872  CG  ARG   114      44.355  12.000  45.807  1.00 52.27           C  
ATOM    873  CD  ARG   114      43.813  13.194  46.619  1.00 55.32           C  
ATOM    874  NE  ARG   114      44.149  14.496  46.007  1.00 61.37           N  
ATOM    875  CZ  ARG   114      44.054  15.691  46.618  1.00 65.98           C  
ATOM    876  NH1 ARG   114      43.627  15.784  47.883  1.00 65.95           N  
ATOM    877  NH2 ARG   114      44.396  16.812  45.970  1.00 64.49           N  
ATOM    878  N   ARG   115      47.781  10.034  46.127  1.00 52.10           N  
ATOM    879  CA  ARG   115      49.120  10.377  45.690  1.00 52.46           C  
ATOM    880  C   ARG   115      49.695   9.356  44.726  1.00 51.72           C  
ATOM    881  O   ARG   115      50.507   9.687  43.874  1.00 50.66           O  
ATOM    882  CB  ARG   115      50.034  10.504  46.893  1.00 54.19           C  
ATOM    883  CG  ARG   115      51.333  11.201  46.591  1.00 58.70           C  
ATOM    884  CD  ARG   115      51.122  12.658  46.193  1.00 64.25           C  
ATOM    885  NE  ARG   115      52.386  13.379  46.300  1.00 71.61           N  
ATOM    886  CZ  ARG   115      53.425  13.202  45.483  1.00 74.87           C  
ATOM    887  NH1 ARG   115      53.351  12.338  44.479  1.00 75.09           N  
ATOM    888  NH2 ARG   115      54.562  13.858  45.696  1.00 77.88           N  
ATOM    889  N   LEU   116      49.270   8.108  44.875  1.00 53.33           N  
ATOM    890  CA  LEU   116      49.737   7.024  44.025  1.00 53.58           C  
ATOM    891  C   LEU   116      49.196   7.267  42.632  1.00 54.07           C  
ATOM    892  O   LEU   116      49.904   7.129  41.641  1.00 53.57           O  
ATOM    893  CB  LEU   116      49.223   5.685  44.541  1.00 53.00           C  
ATOM    894  CG  LEU   116      49.707   4.495  43.700  1.00 55.61           C  
ATOM    895  CD1 LEU   116      51.238   4.431  43.760  1.00 55.15           C  
ATOM    896  CD2 LEU   116      49.088   3.196  44.202  1.00 52.60           C  
ATOM    897  N   LEU   117      47.927   7.644  42.575  1.00 55.37           N  
ATOM    898  CA  LEU   117      47.273   7.909  41.312  1.00 56.86           C  
ATOM    899  C   LEU   117      48.001   9.045  40.601  1.00 58.79           C  
ATOM    900  O   LEU   117      48.218   8.992  39.397  1.00 57.58           O  
ATOM    901  CB  LEU   117      45.817   8.285  41.549  1.00 54.08           C  
ATOM    902  CG  LEU   117      45.092   8.604  40.250  1.00 55.91           C  
ATOM    903  CD1 LEU   117      45.068   7.355  39.383  1.00 52.57           C  
ATOM    904  CD2 LEU   117      43.685   9.124  40.549  1.00 54.28           C  
ATOM    905  N   GLN   118      48.364  10.076  41.357  1.00 61.30           N  
ATOM    906  CA  GLN   118      49.087  11.212  40.813  1.00 64.01           C  
ATOM    907  C   GLN   118      50.420  10.789  40.208  1.00 65.87           C  
ATOM    908  O   GLN   118      50.724  11.114  39.060  1.00 66.18           O  
ATOM    909  CB  GLN   118      49.369  12.240  41.904  1.00 66.27           C  
ATOM    910  CG  GLN   118      48.333  13.338  42.033  1.00 70.48           C  
ATOM    911  CD  GLN   118      48.967  14.674  42.403  1.00 71.81           C  
ATOM    912  OE1 GLN   118      49.490  14.842  43.507  1.00 72.65           O  
ATOM    913  NE2 GLN   118      48.936  15.627  41.470  1.00 71.99           N  
ATOM    914  N   GLU   119      51.226  10.070  40.984  1.00 67.06           N  
ATOM    915  CA  GLU   119      52.523   9.645  40.494  1.00 67.50           C  
ATOM    916  C   GLU   119      52.431   8.820  39.221  1.00 67.60           C  
ATOM    917  O   GLU   119      53.225   9.003  38.302  1.00 68.48           O  
ATOM    918  CB  GLU   119      53.275   8.878  41.573  1.00 68.66           C  
ATOM    919  CG  GLU   119      53.928   9.767  42.620  1.00 71.97           C  
ATOM    920  CD  GLU   119      54.828  10.844  42.016  1.00 74.74           C  
ATOM    921  OE1 GLU   119      55.733  10.510  41.209  1.00 75.46           O  
ATOM    922  OE2 GLU   119      54.630  12.031  42.356  1.00 75.41           O  
ATOM    923  N   ARG   120      51.465   7.918  39.154  1.00 67.09           N  
ATOM    924  CA  ARG   120      51.316   7.101  37.962  1.00 67.86           C  
ATOM    925  C   ARG   120      50.855   7.967  36.786  1.00 67.81           C  
ATOM    926  O   ARG   120      51.320   7.796  35.664  1.00 67.79           O  
ATOM    927  CB  ARG   120      50.324   5.966  38.224  1.00 68.54           C  
ATOM    928  CG  ARG   120      50.763   5.028  39.331  1.00 70.24           C  
ATOM    929  CD  ARG   120      50.838   3.592  38.829  1.00 73.28           C  
ATOM    930  NE  ARG   120      51.951   2.858  39.433  1.00 74.70           N  
ATOM    931  CZ  ARG   120      51.835   1.959  40.406  1.00 75.34           C  
ATOM    932  NH1 ARG   120      50.644   1.651  40.908  1.00 76.24           N  
ATOM    933  NH2 ARG   120      52.925   1.377  40.890  1.00 75.76           N  
ATOM    934  N   LEU   121      49.947   8.899  37.050  1.00 68.08           N  
ATOM    935  CA  LEU   121      49.439   9.791  36.018  1.00 68.24           C  
ATOM    936  C   LEU   121      50.554  10.682  35.488  1.00 70.62           C  
ATOM    937  O   LEU   121      50.622  10.976  34.292  1.00 71.40           O  
ATOM    938  CB  LEU   121      48.317  10.687  36.563  1.00 64.60           C  
ATOM    939  CG  LEU   121      46.905  10.115  36.721  1.00 63.20           C  
ATOM    940  CD1 LEU   121      45.941  11.241  37.003  1.00 62.27           C  
ATOM    941  CD2 LEU   121      46.476   9.417  35.457  1.00 62.87           C  
ATOM    942  N   ARG   122      51.433  11.111  36.385  1.00 72.33           N  
ATOM    943  CA  ARG   122      52.519  11.988  35.998  1.00 73.62           C  
ATOM    944  C   ARG   122      53.534  11.322  35.066  1.00 74.20           C  
ATOM    945  O   ARG   122      54.229  12.009  34.319  1.00 74.67           O  
ATOM    946  CB  ARG   122      53.219  12.521  37.242  1.00 74.51           C  
ATOM    947  CG  ARG   122      54.192  13.639  36.940  1.00 78.84           C  
ATOM    948  CD  ARG   122      54.973  14.074  38.172  1.00 81.78           C  
ATOM    949  NE  ARG   122      55.975  13.088  38.585  1.00 85.00           N  
ATOM    950  CZ  ARG   122      57.036  12.739  37.856  1.00 86.41           C  
ATOM    951  NH1 ARG   122      57.243  13.290  36.664  1.00 87.13           N  
ATOM    952  NH2 ARG   122      57.900  11.843  38.322  1.00 85.88           N  
ATOM    953  N   ARG   123      53.609   9.995  35.087  1.00 74.20           N  
ATOM    954  CA  ARG   123      54.559   9.288  34.242  1.00 75.77           C  
ATOM    955  C   ARG   123      53.935   8.726  32.975  1.00 76.88           C  
ATOM    956  O   ARG   123      54.529   7.891  32.286  1.00 77.15           O  
ATOM    957  CB  ARG   123      55.226   8.171  35.042  1.00 77.07           C  
ATOM    958  CG  ARG   123      56.273   8.678  36.018  1.00 79.66           C  
ATOM    959  CD  ARG   123      56.275   7.859  37.307  1.00 84.37           C  
ATOM    960  NE  ARG   123      57.260   8.341  38.279  1.00 87.36           N  
ATOM    961  CZ  ARG   123      58.298   7.629  38.714  1.00 88.63           C  
ATOM    962  NH1 ARG   123      58.499   6.390  38.268  1.00 88.48           N  
ATOM    963  NH2 ARG   123      59.143   8.157  39.595  1.00 88.92           N  
ATOM    964  N   LEU   124      52.736   9.194  32.660  1.00 78.38           N  
ATOM    965  CA  LEU   124      52.048   8.723  31.472  1.00 79.17           C  
ATOM    966  C   LEU   124      52.505   9.401  30.195  1.00 81.39           C  
ATOM    967  O   LEU   124      52.708  10.620  30.141  1.00 80.31           O  
ATOM    968  CB  LEU   124      50.540   8.876  31.631  1.00 77.62           C  
ATOM    969  CG  LEU   124      49.923   7.711  32.394  1.00 76.01           C  
ATOM    970  CD1 LEU   124      48.422   7.901  32.513  1.00 75.32           C  
ATOM    971  CD2 LEU   124      50.252   6.424  31.660  1.00 75.36           C  
ATOM    972  N   GLU   125      52.652   8.574  29.164  1.00 84.49           N  
ATOM    973  CA  GLU   125      53.110   8.994  27.845  1.00 85.71           C  
ATOM    974  C   GLU   125      52.056   9.689  26.994  1.00 85.14           C  
ATOM    975  O   GLU   125      50.935   9.205  26.858  1.00 85.22           O  
ATOM    976  CB  GLU   125      53.637   7.770  27.105  1.00 87.34           C  
ATOM    977  CG  GLU   125      52.672   6.596  27.120  1.00 90.13           C  
ATOM    978  CD  GLU   125      53.277   5.342  26.503  1.00 93.48           C  
ATOM    979  OE1 GLU   125      52.526   4.364  26.264  1.00 93.88           O  
ATOM    980  OE2 GLU   125      54.508   5.332  26.262  1.00 94.50           O  
ATOM    981  N   GLY   126      52.432  10.827  26.421  1.00 84.38           N  
ATOM    982  CA  GLY   126      51.525  11.569  25.567  1.00 84.11           C  
ATOM    983  C   GLY   126      50.109  11.654  26.094  1.00 84.57           C  
ATOM    984  O   GLY   126      49.202  10.961  25.621  1.00 84.45           O  
ATOM    985  N   VAL   127      49.923  12.512  27.088  1.00 84.08           N  
ATOM    986  CA  VAL   127      48.620  12.718  27.692  1.00 82.67           C  
ATOM    987  C   VAL   127      48.748  13.875  28.618  1.00 81.90           C  
ATOM    988  O   VAL   127      49.804  14.183  29.172  1.00 82.37           O  
ATOM    989  CB  VAL   127      48.136  11.527  28.488  1.00 83.19           C  
ATOM    990  CG1 VAL   127      48.848  11.468  29.813  1.00 83.20           C  
ATOM    991  CG2 VAL   127      46.632  11.661  28.705  1.00 85.44           C  
ATOM    992  N   TRP   128      47.632  14.468  28.887  1.00 80.51           N  
ATOM    993  CA  TRP   128      47.734  15.623  29.638  1.00 80.52           C  
ATOM    994  C   TRP   128      47.141  15.645  31.061  1.00 79.00           C  
ATOM    995  O   TRP   128      45.951  15.445  31.262  1.00 77.99           O  
ATOM    996  CB  TRP   128      47.134  16.624  28.761  1.00 82.46           C  
ATOM    997  CG  TRP   128      46.958  17.666  29.437  1.00 85.61           C  
ATOM    998  CD1 TRP   128      46.005  17.899  30.373  1.00 86.56           C  
ATOM    999  CD2 TRP   128      47.763  18.784  29.346  1.00 86.36           C  
ATOM   1000  NE1 TRP   128      46.174  19.156  30.883  1.00 86.71           N  
ATOM   1001  CE2 TRP   128      47.266  19.720  30.273  1.00 86.60           C  
ATOM   1002  CE3 TRP   128      48.886  19.099  28.561  1.00 87.01           C  
ATOM   1003  CZ2 TRP   128      47.840  20.951  30.448  1.00 86.74           C  
ATOM   1004  CZ3 TRP   128      49.470  20.322  28.713  1.00 87.31           C  
ATOM   1005  CH2 TRP   128      48.950  21.250  29.666  1.00 87.56           C  
ATOM   1006  N   VAL   129      47.980  15.960  32.033  1.00 75.97           N  
ATOM   1007  CA  VAL   129      47.559  15.911  33.410  1.00 75.60           C  
ATOM   1008  C   VAL   129      47.448  17.230  34.159  1.00 76.75           C  
ATOM   1009  O   VAL   129      48.377  18.013  34.180  1.00 77.49           O  
ATOM   1010  CB  VAL   129      48.481  14.982  34.158  1.00 73.90           C  
ATOM   1011  CG1 VAL   129      47.937  14.678  35.508  1.00 72.70           C  
ATOM   1012  CG2 VAL   129      48.676  13.740  33.319  1.00 74.83           C  
ATOM   1013  N   GLU   130      46.312  17.452  34.812  1.00 77.77           N  
ATOM   1014  CA  GLU   130      46.095  18.674  35.558  1.00 78.92           C  
ATOM   1015  C   GLU   130      45.676  18.287  36.984  1.00 78.24           C  
ATOM   1016  O   GLU   130      44.547  18.553  37.417  1.00 78.14           O  
ATOM   1017  CB  GLU   130      45.014  19.508  34.858  1.00 81.69           C  
ATOM   1018  CG  GLU   130      45.052  21.006  35.164  1.00 87.16           C  
ATOM   1019  CD  GLU   130      44.100  21.814  34.283  1.00 90.28           C  
ATOM   1020  OE1 GLU   130      42.880  21.856  34.573  1.00 91.28           O  
ATOM   1021  OE2 GLU   130      44.580  22.401  33.286  1.00 92.44           O  
ATOM   1022  N   GLY   131      46.598  17.647  37.702  1.00 76.55           N  
ATOM   1023  CA  GLY   131      46.330  17.230  39.068  1.00 74.58           C  
ATOM   1024  C   GLY   131      45.865  15.791  39.106  1.00 73.64           C  
ATOM   1025  O   GLY   131      46.671  14.882  38.911  1.00 73.38           O  
ATOM   1026  N   LEU   132      44.571  15.590  39.366  1.00 72.73           N  
ATOM   1027  CA  LEU   132      43.975  14.258  39.397  1.00 71.14           C  
ATOM   1028  C   LEU   132      43.165  14.024  38.134  1.00 70.81           C  
ATOM   1029  O   LEU   132      42.451  13.033  38.009  1.00 70.97           O  
ATOM   1030  CB  LEU   132      43.082  14.082  40.626  1.00 69.55           C  
ATOM   1031  CG  LEU   132      43.854  13.777  41.914  1.00 69.71           C  
ATOM   1032  CD1 LEU   132      42.862  13.482  43.025  1.00 68.93           C  
ATOM   1033  CD2 LEU   132      44.797  12.593  41.702  1.00 67.63           C  
ATOM   1034  N   ALA   133      43.291  14.946  37.190  1.00 70.99           N  
ATOM   1035  CA  ALA   133      42.580  14.843  35.932  1.00 70.67           C  
ATOM   1036  C   ALA   133      43.492  14.341  34.812  1.00 70.47           C  
ATOM   1037  O   ALA   133      44.708  14.505  34.855  1.00 69.45           O  
ATOM   1038  CB  ALA   133      41.990  16.195  35.566  1.00 70.41           C  
ATOM   1039  N   VAL   134      42.892  13.691  33.827  1.00 70.67           N  
ATOM   1040  CA  VAL   134      43.635  13.193  32.689  1.00 71.29           C  
ATOM   1041  C   VAL   134      42.827  13.645  31.498  1.00 72.40           C  
ATOM   1042  O   VAL   134      41.604  13.543  31.505  1.00 71.80           O  
ATOM   1043  CB  VAL   134      43.695  11.657  32.623  1.00 70.65           C  
ATOM   1044  CG1 VAL   134      44.702  11.235  31.579  1.00 69.82           C  
ATOM   1045  CG2 VAL   134      44.058  11.080  33.954  1.00 72.45           C  
ATOM   1046  N   TYR   135      43.514  14.167  30.492  1.00 73.97           N  
ATOM   1047  CA  TYR   135      42.872  14.607  29.267  1.00 74.92           C  
ATOM   1048  C   TYR   135      43.616  13.860  28.175  1.00 76.66           C  
ATOM   1049  O   TYR   135      44.782  14.113  27.913  1.00 77.04           O  
ATOM   1050  CB  TYR   135      42.971  16.128  29.138  1.00 72.52           C  
ATOM   1051  CG  TYR   135      42.156  16.810  30.207  1.00 70.54           C  
ATOM   1052  CD1 TYR   135      42.708  17.125  31.442  1.00 70.96           C  
ATOM   1053  CD2 TYR   135      40.795  17.033  30.027  1.00 71.86           C  
ATOM   1054  CE1 TYR   135      41.918  17.651  32.484  1.00 70.63           C  
ATOM   1055  CE2 TYR   135      39.989  17.548  31.060  1.00 71.08           C  
ATOM   1056  CZ  TYR   135      40.559  17.855  32.283  1.00 70.70           C  
ATOM   1057  OH  TYR   135      39.771  18.361  33.292  1.00 68.68           O  
ATOM   1058  N   ARG   136      42.931  12.891  27.579  1.00 79.43           N  
ATOM   1059  CA  ARG   136      43.527  12.047  26.553  1.00 82.21           C  
ATOM   1060  C   ARG   136      43.487  12.561  25.112  1.00 82.50           C  
ATOM   1061  O   ARG   136      44.511  12.540  24.426  1.00 83.13           O  
ATOM   1062  CB  ARG   136      42.885  10.662  26.595  1.00 84.89           C  
ATOM   1063  CG  ARG   136      42.700  10.095  27.989  1.00 89.03           C  
ATOM   1064  CD  ARG   136      42.321   8.624  27.926  1.00 94.02           C  
ATOM   1065  NE  ARG   136      41.072   8.379  27.196  1.00 98.32           N  
ATOM   1066  CZ  ARG   136      40.660   7.178  26.773  1.00100.24           C  
ATOM   1067  NH1 ARG   136      41.394   6.092  26.997  1.00100.92           N  
ATOM   1068  NH2 ARG   136      39.507   7.054  26.123  1.00 99.02           N  
ATOM   1069  N   ARG   137      42.323  13.020  24.652  1.00 81.91           N  
ATOM   1070  CA  ARG   137      42.193  13.456  23.266  1.00 80.78           C  
ATOM   1071  C   ARG   137      41.467  14.750  22.926  1.00 81.03           C  
ATOM   1072  O   ARG   137      40.510  15.150  23.587  1.00 80.59           O  
ATOM   1073  CB  ARG   137      41.551  12.334  22.471  1.00 81.17           C  
ATOM   1074  CG  ARG   137      40.339  11.709  23.145  1.00 79.96           C  
ATOM   1075  CD  ARG   137      39.832  10.566  22.298  1.00 81.08           C  
ATOM   1076  NE  ARG   137      40.939   9.735  21.829  1.00 82.40           N  
ATOM   1077  CZ  ARG   137      41.252   8.539  22.320  1.00 83.14           C  
ATOM   1078  NH1 ARG   137      40.541   8.007  23.307  1.00 84.17           N  
ATOM   1079  NH2 ARG   137      42.283   7.872  21.823  1.00 82.61           N  
ATOM   1080  N   GLU   138      41.920  15.368  21.837  1.00 82.42           N  
ATOM   1081  CA  GLU   138      41.378  16.626  21.331  1.00 83.22           C  
ATOM   1082  C   GLU   138      39.941  16.567  20.846  1.00 83.78           C  
ATOM   1083  O   GLU   138      39.455  15.521  20.442  1.00 84.00           O  
ATOM   1084  CB  GLU   138      42.252  17.147  20.198  1.00 83.28           C  
ATOM   1085  CG  GLU   138      43.532  17.798  20.665  1.00 85.60           C  
ATOM   1086  CD  GLU   138      44.228  18.547  19.553  1.00 87.23           C  
ATOM   1087  OE1 GLU   138      43.518  19.061  18.659  1.00 87.20           O  
ATOM   1088  OE2 GLU   138      45.477  18.632  19.582  1.00 88.25           O  
ATOM   1089  N   HIS   139      39.271  17.713  20.880  1.00 85.40           N  
ATOM   1090  CA  HIS   139      37.882  17.815  20.449  1.00 87.35           C  
ATOM   1091  C   HIS   139      37.633  19.055  19.610  1.00 87.96           C  
ATOM   1092  O   HIS   139      36.544  19.230  19.068  1.00 89.27           O  
ATOM   1093  CB  HIS   139      36.934  17.840  21.652  1.00 88.46           C  
ATOM   1094  CG  HIS   139      36.643  16.485  22.219  1.00 91.04           C  
ATOM   1095  ND1 HIS   139      37.569  15.763  22.942  1.00 92.06           N  
ATOM   1096  CD2 HIS   139      35.540  15.704  22.138  1.00 91.59           C  
ATOM   1097  CE1 HIS   139      37.049  14.596  23.281  1.00 91.95           C  
ATOM   1098  NE2 HIS   139      35.818  14.536  22.806  1.00 91.16           N  
ATOM   1099  N   ALA   140      38.641  19.912  19.507  1.00 87.65           N  
ATOM   1100  CA  ALA   140      38.535  21.147  18.742  1.00 87.55           C  
ATOM   1101  C   ALA   140      39.808  21.893  19.044  1.00 88.15           C  
ATOM   1102  O   ALA   140      40.442  21.615  20.060  1.00 88.01           O  
ATOM   1103  CB  ALA   140      37.340  21.957  19.209  1.00 87.03           C  
ATOM   1104  N   ARG   141      40.194  22.829  18.180  1.00 88.44           N  
ATOM   1105  CA  ARG   141      41.412  23.568  18.440  1.00 89.04           C  
ATOM   1106  C   ARG   141      41.438  25.018  17.965  1.00 90.28           C  
ATOM   1107  O   ARG   141      41.049  25.905  18.701  1.00 90.53           O  
ATOM   1108  CB  ARG   141      42.622  22.784  17.912  1.00 87.72           C  
ATOM   1109  CG  ARG   141      42.749  22.703  16.423  1.00 88.27           C  
ATOM   1110  CD  ARG   141      43.439  21.425  15.983  1.00 90.32           C  
ATOM   1111  NE  ARG   141      44.515  20.972  16.866  1.00 92.61           N  
ATOM   1112  CZ  ARG   141      45.688  21.580  17.032  1.00 93.88           C  
ATOM   1113  NH1 ARG   141      45.969  22.699  16.373  1.00 95.14           N  
ATOM   1114  NH2 ARG   141      46.588  21.054  17.857  1.00 93.25           N  
ATOM   1115  N   GLY   142      41.885  25.290  16.753  1.00 91.38           N  
ATOM   1116  CA  GLY   142      41.936  26.682  16.346  1.00 91.80           C  
ATOM   1117  C   GLY   142      43.212  27.332  16.866  1.00 91.86           C  
ATOM   1118  O   GLY   142      43.961  26.711  17.629  1.00 91.91           O  
ATOM   1119  N   PRO   143      43.475  28.595  16.496  1.00 91.92           N  
ATOM   1120  CA  PRO   143      44.680  29.316  16.926  1.00 91.04           C  
ATOM   1121  C   PRO   143      44.930  29.490  18.429  1.00 90.18           C  
ATOM   1122  O   PRO   143      44.177  30.172  19.126  1.00 89.84           O  
ATOM   1123  CB  PRO   143      44.547  30.656  16.206  1.00 91.64           C  
ATOM   1124  CG  PRO   143      43.056  30.866  16.185  1.00 92.31           C  
ATOM   1125  CD  PRO   143      42.544  29.498  15.788  1.00 91.67           C  
ATOM   1126  N   GLY   144      45.996  28.861  18.917  1.00 89.03           N  
ATOM   1127  CA  GLY   144      46.369  28.993  20.315  1.00 87.46           C  
ATOM   1128  C   GLY   144      45.532  28.326  21.392  1.00 85.90           C  
ATOM   1129  O   GLY   144      45.972  28.235  22.530  1.00 85.97           O  
ATOM   1130  N   TRP   145      44.322  27.892  21.078  1.00 84.14           N  
ATOM   1131  CA  TRP   145      43.525  27.220  22.092  1.00 82.52           C  
ATOM   1132  C   TRP   145      43.294  25.798  21.635  1.00 80.56           C  
ATOM   1133  O   TRP   145      43.558  25.467  20.483  1.00 81.96           O  
ATOM   1134  CB  TRP   145      42.188  27.921  22.320  1.00 83.40           C  
ATOM   1135  CG  TRP   145      41.329  28.067  21.105  1.00 86.17           C  
ATOM   1136  CD1 TRP   145      41.407  29.047  20.155  1.00 86.41           C  
ATOM   1137  CD2 TRP   145      40.204  27.254  20.748  1.00 88.09           C  
ATOM   1138  NE1 TRP   145      40.395  28.901  19.238  1.00 87.17           N  
ATOM   1139  CE2 TRP   145      39.641  27.811  19.575  1.00 87.21           C  
ATOM   1140  CE3 TRP   145      39.615  26.105  21.305  1.00 88.76           C  
ATOM   1141  CZ2 TRP   145      38.517  27.262  18.950  1.00 87.59           C  
ATOM   1142  CZ3 TRP   145      38.490  25.557  20.676  1.00 88.82           C  
ATOM   1143  CH2 TRP   145      37.957  26.140  19.513  1.00 88.14           C  
ATOM   1144  N   ARG   146      42.825  24.949  22.537  1.00 77.09           N  
ATOM   1145  CA  ARG   146      42.575  23.562  22.194  1.00 74.62           C  
ATOM   1146  C   ARG   146      41.838  22.850  23.318  1.00 72.32           C  
ATOM   1147  O   ARG   146      42.250  22.868  24.464  1.00 72.39           O  
ATOM   1148  CB  ARG   146      43.904  22.878  21.828  1.00 75.07           C  
ATOM   1149  CG  ARG   146      44.366  21.686  22.648  1.00 75.81           C  
ATOM   1150  CD  ARG   146      45.612  21.142  21.964  1.00 77.61           C  
ATOM   1151  NE  ARG   146      46.308  20.063  22.664  1.00 80.87           N  
ATOM   1152  CZ  ARG   146      47.153  20.233  23.679  1.00 82.13           C  
ATOM   1153  NH1 ARG   146      47.413  21.449  24.142  1.00 82.86           N  
ATOM   1154  NH2 ARG   146      47.776  19.182  24.205  1.00 82.93           N  
ATOM   1155  N   VAL   147      40.711  22.250  22.975  1.00 70.54           N  
ATOM   1156  CA  VAL   147      39.896  21.549  23.948  1.00 68.67           C  
ATOM   1157  C   VAL   147      40.288  20.081  24.042  1.00 67.90           C  
ATOM   1158  O   VAL   147      40.510  19.431  23.023  1.00 67.92           O  
ATOM   1159  CB  VAL   147      38.405  21.628  23.568  1.00 68.06           C  
ATOM   1160  CG1 VAL   147      37.590  20.726  24.466  1.00 67.90           C  
ATOM   1161  CG2 VAL   147      37.924  23.049  23.674  1.00 66.33           C  
ATOM   1162  N   LEU   148      40.385  19.564  25.266  1.00 66.41           N  
ATOM   1163  CA  LEU   148      40.715  18.157  25.464  1.00 63.56           C  
ATOM   1164  C   LEU   148      39.663  17.514  26.337  1.00 62.01           C  
ATOM   1165  O   LEU   148      39.061  18.161  27.191  1.00 60.42           O  
ATOM   1166  CB  LEU   148      42.079  17.995  26.111  1.00 62.43           C  
ATOM   1167  CG  LEU   148      43.245  18.583  25.330  1.00 63.05           C  
ATOM   1168  CD1 LEU   148      44.543  18.188  25.999  1.00 64.18           C  
ATOM   1169  CD2 LEU   148      43.223  18.070  23.913  1.00 62.67           C  
ATOM   1170  N   GLY   149      39.428  16.234  26.100  1.00 61.64           N  
ATOM   1171  CA  GLY   149      38.447  15.521  26.884  1.00 60.17           C  
ATOM   1172  C   GLY   149      39.090  14.360  27.600  1.00 60.50           C  
ATOM   1173  O   GLY   149      39.861  13.596  27.007  1.00 60.87           O  
ATOM   1174  N   GLY   150      38.782  14.245  28.888  1.00 59.65           N  
ATOM   1175  CA  GLY   150      39.302  13.161  29.702  1.00 57.19           C  
ATOM   1176  C   GLY   150      38.365  12.972  30.881  1.00 56.01           C  
ATOM   1177  O   GLY   150      37.140  12.950  30.697  1.00 54.74           O  
ATOM   1178  N   ALA   151      38.928  12.848  32.086  1.00 53.87           N  
ATOM   1179  CA  ALA   151      38.128  12.676  33.295  1.00 52.26           C  
ATOM   1180  C   ALA   151      38.894  13.034  34.565  1.00 51.67           C  
ATOM   1181  O   ALA   151      40.091  12.764  34.670  1.00 49.71           O  
ATOM   1182  CB  ALA   151      37.633  11.231  33.393  1.00 50.92           C  
ATOM   1183  N   VAL   152      38.213  13.660  35.521  1.00 51.42           N  
ATOM   1184  CA  VAL   152      38.858  13.962  36.797  1.00 52.53           C  
ATOM   1185  C   VAL   152      38.692  12.631  37.517  1.00 52.46           C  
ATOM   1186  O   VAL   152      37.633  12.014  37.446  1.00 53.17           O  
ATOM   1187  CB  VAL   152      38.157  15.115  37.561  1.00 52.93           C  
ATOM   1188  CG1 VAL   152      38.479  16.431  36.899  1.00 53.90           C  
ATOM   1189  CG2 VAL   152      36.666  14.941  37.533  1.00 54.66           C  
ATOM   1190  N   LEU   153      39.746  12.170  38.173  1.00 51.56           N  
ATOM   1191  CA  LEU   153      39.712  10.876  38.824  1.00 50.97           C  
ATOM   1192  C   LEU   153      40.001  10.939  40.304  1.00 53.35           C  
ATOM   1193  O   LEU   153      40.428  11.971  40.836  1.00 54.32           O  
ATOM   1194  CB  LEU   153      40.769   9.964  38.211  1.00 49.44           C  
ATOM   1195  CG  LEU   153      40.998   9.830  36.703  1.00 48.15           C  
ATOM   1196  CD1 LEU   153      42.318   9.086  36.495  1.00 47.23           C  
ATOM   1197  CD2 LEU   153      39.854   9.103  36.040  1.00 43.93           C  
ATOM   1198  N   ASP   154      39.778   9.812  40.971  1.00 53.61           N  
ATOM   1199  CA  ASP   154      40.093   9.718  42.380  1.00 53.31           C  
ATOM   1200  C   ASP   154      40.356   8.268  42.720  1.00 52.51           C  
ATOM   1201  O   ASP   154      39.785   7.369  42.110  1.00 51.87           O  
ATOM   1202  CB  ASP   154      38.972  10.285  43.243  1.00 55.47           C  
ATOM   1203  CG  ASP   154      39.475  10.759  44.603  1.00 56.67           C  
ATOM   1204  OD1 ASP   154      40.692  10.605  44.873  1.00 57.83           O  
ATOM   1205  OD2 ASP   154      38.663  11.285  45.392  1.00 56.10           O  
ATOM   1206  N   LEU   155      41.244   8.056  43.685  1.00 52.57           N  
ATOM   1207  CA  LEU   155      41.630   6.720  44.124  1.00 53.42           C  
ATOM   1208  C   LEU   155      41.853   6.732  45.624  1.00 54.92           C  
ATOM   1209  O   LEU   155      42.752   7.407  46.127  1.00 54.74           O  
ATOM   1210  CB  LEU   155      42.924   6.262  43.422  1.00 50.84           C  
ATOM   1211  CG  LEU   155      43.420   4.864  43.802  1.00 49.30           C  
ATOM   1212  CD1 LEU   155      42.417   3.820  43.326  1.00 49.80           C  
ATOM   1213  CD2 LEU   155      44.763   4.594  43.167  1.00 50.73           C  
ATOM   1214  N   TRP   156      41.027   5.974  46.334  1.00 57.64           N  
ATOM   1215  CA  TRP   156      41.112   5.880  47.790  1.00 59.74           C  
ATOM   1216  C   TRP   156      40.881   4.461  48.283  1.00 60.15           C  
ATOM   1217  O   TRP   156      40.627   3.544  47.497  1.00 59.26           O  
ATOM   1218  CB  TRP   156      40.082   6.811  48.433  1.00 60.32           C  
ATOM   1219  CG  TRP   156      38.930   7.049  47.558  1.00 63.67           C  
ATOM   1220  CD1 TRP   156      38.922   7.740  46.375  1.00 66.54           C  
ATOM   1221  CD2 TRP   156      37.614   6.535  47.731  1.00 65.16           C  
ATOM   1222  NE1 TRP   156      37.676   7.679  45.794  1.00 67.32           N  
ATOM   1223  CE2 TRP   156      36.854   6.944  46.607  1.00 67.03           C  
ATOM   1224  CE3 TRP   156      37.004   5.767  48.719  1.00 64.21           C  
ATOM   1225  CZ2 TRP   156      35.516   6.607  46.452  1.00 67.24           C  
ATOM   1226  CZ3 TRP   156      35.688   5.436  48.568  1.00 66.86           C  
ATOM   1227  CH2 TRP   156      34.950   5.855  47.437  1.00 68.51           C  
ATOM   1228  N   VAL   157      40.981   4.293  49.597  1.00 61.19           N  
ATOM   1229  CA  VAL   157      40.770   3.000  50.236  1.00 62.27           C  
ATOM   1230  C   VAL   157      39.403   2.961  50.958  1.00 62.56           C  
ATOM   1231  O   VAL   157      38.846   3.998  51.318  1.00 62.00           O  
ATOM   1232  CB  VAL   157      41.919   2.723  51.219  1.00 62.30           C  
ATOM   1233  CG1 VAL   157      41.728   1.388  51.909  1.00 64.43           C  
ATOM   1234  CG2 VAL   157      43.237   2.727  50.465  1.00 62.97           C  
ATOM   1235  N   SER   158      38.845   1.767  51.135  1.00 64.49           N  
ATOM   1236  CA  SER   158      37.560   1.625  51.831  1.00 67.24           C  
ATOM   1237  C   SER   158      37.751   1.081  53.262  1.00 68.87           C  
ATOM   1238  O   SER   158      38.877   0.755  53.675  1.00 67.12           O  
ATOM   1239  CB  SER   158      36.631   0.699  51.042  1.00 66.15           C  
ATOM   1240  OG  SER   158      37.240  -0.564  50.826  1.00 66.46           O  
ATOM   1241  N   ASP   159      36.654   1.003  54.021  1.00 71.30           N  
ATOM   1242  CA  ASP   159      36.709   0.479  55.396  1.00 73.47           C  
ATOM   1243  C   ASP   159      36.947  -1.027  55.344  1.00 72.53           C  
ATOM   1244  O   ASP   159      37.199  -1.660  56.365  1.00 72.71           O  
ATOM   1245  CB  ASP   159      35.409   0.762  56.154  1.00 75.20           C  
ATOM   1246  CG  ASP   159      34.196   0.151  55.480  1.00 78.36           C  
ATOM   1247  OD1 ASP   159      34.355  -0.832  54.717  1.00 79.99           O  
ATOM   1248  OD2 ASP   159      33.077   0.646  55.723  1.00 79.78           O  
ATOM   1249  N   SER   160      36.855  -1.572  54.134  1.00 71.61           N  
ATOM   1250  CA  SER   160      37.073  -2.983  53.856  1.00 72.21           C  
ATOM   1251  C   SER   160      38.554  -3.179  53.541  1.00 72.10           C  
ATOM   1252  O   SER   160      39.067  -4.295  53.606  1.00 72.06           O  
ATOM   1253  CB  SER   160      36.235  -3.423  52.643  1.00 74.47           C  
ATOM   1254  OG  SER   160      34.848  -3.133  52.811  1.00 75.86           O  
ATOM   1255  N   GLY   161      39.231  -2.092  53.162  1.00 71.78           N  
ATOM   1256  CA  GLY   161      40.656  -2.168  52.869  1.00 69.97           C  
ATOM   1257  C   GLY   161      41.140  -2.440  51.454  1.00 68.35           C  
ATOM   1258  O   GLY   161      42.212  -3.023  51.264  1.00 67.64           O  
ATOM   1259  N   ALA   162      40.368  -2.026  50.456  1.00 67.82           N  
ATOM   1260  CA  ALA   162      40.768  -2.219  49.060  1.00 66.31           C  
ATOM   1261  C   ALA   162      40.673  -0.886  48.323  1.00 64.90           C  
ATOM   1262  O   ALA   162      39.918   0.005  48.734  1.00 64.15           O  
ATOM   1263  CB  ALA   162      39.865  -3.249  48.383  1.00 65.17           C  
ATOM   1264  N   PHE   163      41.429  -0.753  47.235  1.00 61.59           N  
ATOM   1265  CA  PHE   163      41.395   0.472  46.449  1.00 58.00           C  
ATOM   1266  C   PHE   163      40.062   0.678  45.768  1.00 57.52           C  
ATOM   1267  O   PHE   163      39.458  -0.259  45.278  1.00 59.00           O  
ATOM   1268  CB  PHE   163      42.460   0.447  45.377  1.00 54.06           C  
ATOM   1269  CG  PHE   163      43.837   0.594  45.902  1.00 50.52           C  
ATOM   1270  CD1 PHE   163      44.718  -0.477  45.875  1.00 49.21           C  
ATOM   1271  CD2 PHE   163      44.269   1.815  46.392  1.00 48.02           C  
ATOM   1272  CE1 PHE   163      46.015  -0.330  46.326  1.00 49.90           C  
ATOM   1273  CE2 PHE   163      45.562   1.973  46.844  1.00 48.71           C  
ATOM   1274  CZ  PHE   163      46.443   0.902  46.813  1.00 49.07           C  
ATOM   1275  N   LEU   164      39.614   1.920  45.728  1.00 57.55           N  
ATOM   1276  CA  LEU   164      38.365   2.263  45.075  1.00 57.26           C  
ATOM   1277  C   LEU   164      38.730   3.412  44.124  1.00 57.53           C  
ATOM   1278  O   LEU   164      39.370   4.387  44.533  1.00 56.25           O  
ATOM   1279  CB  LEU   164      37.349   2.697  46.131  1.00 57.98           C  
ATOM   1280  CG  LEU   164      35.912   2.189  45.989  1.00 59.74           C  
ATOM   1281  CD1 LEU   164      35.844   0.674  46.042  1.00 59.30           C  
ATOM   1282  CD2 LEU   164      35.095   2.751  47.116  1.00 62.37           C  
ATOM   1283  N   LEU   165      38.351   3.285  42.854  1.00 57.37           N  
ATOM   1284  CA  LEU   165      38.675   4.297  41.850  1.00 55.98           C  
ATOM   1285  C   LEU   165      37.434   5.036  41.363  1.00 55.73           C  
ATOM   1286  O   LEU   165      36.470   4.404  40.963  1.00 56.30           O  
ATOM   1287  CB  LEU   165      39.378   3.626  40.653  1.00 54.80           C  
ATOM   1288  CG  LEU   165      39.518   4.427  39.344  1.00 52.01           C  
ATOM   1289  CD1 LEU   165      40.715   5.304  39.447  1.00 50.99           C  
ATOM   1290  CD2 LEU   165      39.648   3.522  38.158  1.00 48.67           C  
ATOM   1291  N   GLU   166      37.469   6.369  41.388  1.00 56.74           N  
ATOM   1292  CA  GLU   166      36.346   7.198  40.921  1.00 58.45           C  
ATOM   1293  C   GLU   166      36.673   7.782  39.546  1.00 57.73           C  
ATOM   1294  O   GLU   166      37.808   8.165  39.281  1.00 57.50           O  
ATOM   1295  CB  GLU   166      36.070   8.357  41.899  1.00 61.94           C  
ATOM   1296  CG  GLU   166      34.696   9.057  41.715  1.00 66.38           C  
ATOM   1297  CD  GLU   166      34.790  10.579  41.505  1.00 70.05           C  
ATOM   1298  OE1 GLU   166      33.887  11.304  41.984  1.00 71.91           O  
ATOM   1299  OE2 GLU   166      35.747  11.063  40.848  1.00 72.07           O  
ATOM   1300  N   VAL   167      35.673   7.868  38.680  1.00 57.94           N  
ATOM   1301  CA  VAL   167      35.885   8.387  37.335  1.00 58.56           C  
ATOM   1302  C   VAL   167      34.695   9.207  36.828  1.00 60.05           C  
ATOM   1303  O   VAL   167      33.565   8.727  36.847  1.00 60.55           O  
ATOM   1304  CB  VAL   167      36.104   7.236  36.323  1.00 57.58           C  
ATOM   1305  CG1 VAL   167      36.498   7.800  34.973  1.00 57.01           C  
ATOM   1306  CG2 VAL   167      37.151   6.277  36.838  1.00 58.12           C  
ATOM   1307  N   ASP   168      34.953  10.435  36.377  1.00 59.99           N  
ATOM   1308  CA  ASP   168      33.906  11.282  35.832  1.00 60.21           C  
ATOM   1309  C   ASP   168      34.446  12.147  34.689  1.00 62.04           C  
ATOM   1310  O   ASP   168      35.305  13.009  34.887  1.00 62.04           O  
ATOM   1311  CB  ASP   168      33.289  12.169  36.918  1.00 60.99           C  
ATOM   1312  CG  ASP   168      31.954  12.776  36.487  1.00 61.77           C  
ATOM   1313  OD1 ASP   168      31.289  12.180  35.623  1.00 61.73           O  
ATOM   1314  OD2 ASP   168      31.555  13.836  37.012  1.00 64.32           O  
ATOM   1315  N   PRO   169      33.954  11.906  33.465  1.00 62.54           N  
ATOM   1316  CA  PRO   169      34.358  12.640  32.267  1.00 62.04           C  
ATOM   1317  C   PRO   169      34.256  14.144  32.449  1.00 62.31           C  
ATOM   1318  O   PRO   169      33.307  14.649  33.057  1.00 60.82           O  
ATOM   1319  CB  PRO   169      33.379  12.142  31.215  1.00 62.41           C  
ATOM   1320  CG  PRO   169      33.167  10.738  31.618  1.00 63.31           C  
ATOM   1321  CD  PRO   169      32.999  10.839  33.120  1.00 62.76           C  
ATOM   1322  N   ALA   170      35.250  14.837  31.903  1.00 62.45           N  
ATOM   1323  CA  ALA   170      35.341  16.285  31.947  1.00 63.07           C  
ATOM   1324  C   ALA   170      36.097  16.741  30.689  1.00 64.66           C  
ATOM   1325  O   ALA   170      36.689  15.924  29.973  1.00 64.85           O  
ATOM   1326  CB  ALA   170      36.084  16.710  33.195  1.00 60.17           C  
ATOM   1327  N   TYR   171      36.066  18.034  30.403  1.00 64.63           N  
ATOM   1328  CA  TYR   171      36.787  18.537  29.245  1.00 66.52           C  
ATOM   1329  C   TYR   171      37.591  19.713  29.740  1.00 67.32           C  
ATOM   1330  O   TYR   171      37.192  20.375  30.693  1.00 69.33           O  
ATOM   1331  CB  TYR   171      35.827  19.018  28.160  1.00 66.79           C  
ATOM   1332  CG  TYR   171      34.923  20.122  28.638  1.00 68.70           C  
ATOM   1333  CD1 TYR   171      33.812  19.838  29.431  1.00 70.55           C  
ATOM   1334  CD2 TYR   171      35.204  21.458  28.354  1.00 68.74           C  
ATOM   1335  CE1 TYR   171      33.002  20.857  29.935  1.00 70.62           C  
ATOM   1336  CE2 TYR   171      34.399  22.489  28.854  1.00 69.66           C  
ATOM   1337  CZ  TYR   171      33.303  22.179  29.645  1.00 69.77           C  
ATOM   1338  OH  TYR   171      32.513  23.173  30.169  1.00 67.58           O  
ATOM   1339  N   ARG   172      38.723  19.979  29.108  1.00 66.90           N  
ATOM   1340  CA  ARG   172      39.522  21.109  29.521  1.00 66.95           C  
ATOM   1341  C   ARG   172      39.938  21.934  28.310  1.00 66.95           C  
ATOM   1342  O   ARG   172      40.433  21.392  27.316  1.00 66.90           O  
ATOM   1343  CB  ARG   172      40.772  20.645  30.268  1.00 67.46           C  
ATOM   1344  CG  ARG   172      41.364  21.719  31.162  1.00 70.04           C  
ATOM   1345  CD  ARG   172      40.433  21.940  32.339  1.00 74.46           C  
ATOM   1346  NE  ARG   172      40.334  23.324  32.784  1.00 76.61           N  
ATOM   1347  CZ  ARG   172      39.466  23.734  33.706  1.00 79.04           C  
ATOM   1348  NH1 ARG   172      38.638  22.855  34.273  1.00 77.36           N  
ATOM   1349  NH2 ARG   172      39.403  25.023  34.046  1.00 79.54           N  
ATOM   1350  N   ILE   173      39.723  23.243  28.390  1.00 65.29           N  
ATOM   1351  CA  ILE   173      40.124  24.129  27.312  1.00 63.66           C  
ATOM   1352  C   ILE   173      41.474  24.704  27.680  1.00 62.98           C  
ATOM   1353  O   ILE   173      41.576  25.455  28.637  1.00 62.68           O  
ATOM   1354  CB  ILE   173      39.162  25.310  27.140  1.00 62.85           C  
ATOM   1355  CG1 ILE   173      37.725  24.814  27.040  1.00 61.85           C  
ATOM   1356  CG2 ILE   173      39.515  26.064  25.875  1.00 62.71           C  
ATOM   1357  CD1 ILE   173      36.719  25.914  26.921  1.00 62.07           C  
ATOM   1358  N   LEU   174      42.508  24.347  26.936  1.00 63.11           N  
ATOM   1359  CA  LEU   174      43.834  24.875  27.208  1.00 65.88           C  
ATOM   1360  C   LEU   174      44.241  26.025  26.270  1.00 67.64           C  
ATOM   1361  O   LEU   174      43.879  26.044  25.098  1.00 67.57           O  
ATOM   1362  CB  LEU   174      44.884  23.771  27.089  1.00 66.60           C  
ATOM   1363  CG  LEU   174      44.896  22.548  28.011  1.00 68.44           C  
ATOM   1364  CD1 LEU   174      46.192  21.798  27.738  1.00 67.09           C  
ATOM   1365  CD2 LEU   174      44.821  22.931  29.487  1.00 67.41           C  
ATOM   1366  N   CYS   175      45.002  26.984  26.786  1.00 69.71           N  
ATOM   1367  CA  CYS   175      45.479  28.083  25.957  1.00 71.26           C  
ATOM   1368  C   CYS   175      46.927  27.756  25.633  1.00 72.34           C  
ATOM   1369  O   CYS   175      47.711  27.487  26.534  1.00 72.52           O  
ATOM   1370  CB  CYS   175      45.416  29.397  26.713  1.00 71.46           C  
ATOM   1371  SG  CYS   175      45.466  30.815  25.626  1.00 75.01           S  
ATOM   1372  N   GLU   176      47.282  27.779  24.354  1.00 74.58           N  
ATOM   1373  CA  GLU   176      48.641  27.449  23.915  1.00 76.40           C  
ATOM   1374  C   GLU   176      49.640  28.604  23.900  1.00 75.71           C  
ATOM   1375  O   GLU   176      50.763  28.438  23.428  1.00 75.54           O  
ATOM   1376  CB  GLU   176      48.603  26.806  22.517  1.00 79.08           C  
ATOM   1377  CG  GLU   176      48.006  25.390  22.486  1.00 84.44           C  
ATOM   1378  CD  GLU   176      48.012  24.747  21.089  1.00 87.05           C  
ATOM   1379  OE1 GLU   176      47.703  23.537  21.000  1.00 87.91           O  
ATOM   1380  OE2 GLU   176      48.314  25.441  20.086  1.00 87.82           O  
END
