
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   71 ( 1121),  selected   71 , name 1u5s_A
# Molecule2: number of CA atoms   88 (  675),  selected   88 , name T0487_178_265.pdb
# PARAMETERS: 1u5s_A.T0487_178_265.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    Q     1_A      S     178           -
LGA    G     2_A      L     179           -
LGA    S     3_A      E     180           -
LGA    R     4_A      A     181           -
LGA    V     5_A      W     182           -
LGA    -       -      L     183           -
LGA    -       -      A     184           -
LGA    -       -      Q     185           -
LGA    -       -      G     186           -
LGA    -       -      H     187           -
LGA    -       -      P     188           -
LGA    L     6_A      L     189          4.998
LGA    H     7_A      P     190          1.012
LGA    V     8_A      K     191          3.629
LGA    -       -      R     192           -
LGA    V     9_A      V     193          1.002
LGA    Q    10_A      R     194          1.303
LGA    T    11_A      N     195          1.256
LGA    L    12_A      A     196          1.911
LGA    Y    13_A      Y     197          1.879
LGA    P    14_A      -       -           -
LGA    F    15_A      -       -           -
LGA    S    16_A      -       -           -
LGA    S    17_A      -       -           -
LGA    V    18_A      -       -           -
LGA    T    19_A      -       -           -
LGA    E    20_A      -       -           -
LGA    E    21_A      -       -           -
LGA    E    22_A      -       -           -
LGA    L    23_A      -       -           -
LGA    N    24_A      -       -           -
LGA    F    25_A      -       -           -
LGA    E    26_A      -       -           -
LGA    K    27_A      D     198          2.961
LGA    G    28_A      R     199          2.062
LGA    E    29_A      R     200          2.082
LGA    T    30_A      T     201          1.872
LGA    M    31_A      W     202          1.063
LGA    E    32_A      E     203          1.108
LGA    V    33_A      L     204          1.238
LGA    I    34_A      L     205          0.900
LGA    E    35_A      R     206          1.307
LGA    K    36_A      L     207          0.039
LGA    P    37_A      G     208          1.693
LGA    E    38_A      E     209          2.180
LGA    N    39_A      E     210          1.939
LGA    D    40_A      D     211          2.347
LGA    P    41_A      P     212          2.499
LGA    -       -      K     213           -
LGA    -       -      E     214           -
LGA    -       -      L     215           -
LGA    -       -      P     216           -
LGA    -       -      L     217           -
LGA    -       -      P     218           -
LGA    -       -      G     219           -
LGA    -       -      G     220           -
LGA    -       -      L     221           -
LGA    -       -      S     222           -
LGA    -       -      L     223           -
LGA    -       -      L     224           -
LGA    -       -      D     225           -
LGA    -       -      Y     226           -
LGA    -       -      H     227           -
LGA    -       -      A     228           -
LGA    -       -      S     229           -
LGA    -       -      K     230           -
LGA    -       -      G     231           -
LGA    -       -      R     232           -
LGA    -       -      L     233           -
LGA    -       -      Q     234           -
LGA    -       -      G     235           -
LGA    -       -      R     236           -
LGA    -       -      E     237           -
LGA    -       -      G     238           -
LGA    -       -      G     239           -
LGA    E    42_A      R     240          2.105
LGA    W    43_A      V     241          1.370
LGA    W    44_A      A     242          1.293
LGA    K    45_A      W     243          1.080
LGA    C    46_A      V     244          0.826
LGA    K    47_A      A     245          0.810
LGA    N    48_A      D     246          1.848
LGA    A    49_A      P     247          1.937
LGA    R    50_A      K     248          3.257
LGA    G    51_A      D     249          2.220
LGA    -       -      P     250           -
LGA    -       -      R     251           -
LGA    Q    52_A      K     252          4.753
LGA    V    53_A      P     253          2.448
LGA    G    54_A      I     254          0.709
LGA    L    55_A      P     255          0.672
LGA    V    56_A      H     256          0.736
LGA    P    57_A      L     257          1.487
LGA    K    58_A      T     258          1.535
LGA    N    59_A      G     259          1.410
LGA    Y    60_A      L     260          1.359
LGA    V    61_A      L     261          1.205
LGA    V    62_A      V     262          0.457
LGA    V    63_A      P     263          1.018
LGA    L    64_A      V     264          2.697
LGA    S    65_A      L     265          3.498
LGA    D    66_A      -       -           -
LGA    G    67_A      -       -           -
LGA    P    68_A      -       -           -
LGA    A    69_A      -       -           -
LGA    L    70_A      -       -           -
LGA    H    71_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   71   88    5.0     47    2.04    19.15     47.194     2.200

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.221005 * X  +   0.748192 * Y  +   0.625592 * Z  +  55.092422
  Y_new =   0.382270 * X  +   0.656581 * Y  +  -0.650208 * Z  +  33.755577
  Z_new =  -0.897232 * X  +   0.095445 * Y  +  -0.431120 * Z  +  22.196230 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.923717   -0.217876  [ DEG:   167.5166    -12.4833 ]
  Theta =   1.113461    2.028131  [ DEG:    63.7966    116.2034 ]
  Phi   =   2.094987   -1.046606  [ DEG:   120.0339    -59.9661 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1u5s_A                                        
REMARK     2: T0487_178_265.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1u5s_A.T0487_178_265.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   71   88   5.0   47   2.04   19.15  47.194
REMARK  ---------------------------------------------------------- 
MOLECULE 1u5s_A
HEADER    METAL BINDING PROTEIN                   28-JUL-04   1U5S              
TITLE     NMR STRUCTURE OF THE COMPLEX BETWEEN NCK-2 SH3 DOMAIN AND             
TITLE    2 PINCH-1 LIM4 DOMAIN                                                  
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: CYTOPLASMIC PROTEIN NCK2;                                  
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: THIRD SH3 DOMAIN (RESIDUES 192-262);                       
COMPND   5 SYNONYM: NCK ADAPTOR PROTEIN 2, SH2/SH3 ADAPTOR PROTEIN              
COMPND   6 NCK-BETA, NCK-2;                                                     
COMPND   7 ENGINEERED: YES;                                                     
COMPND   8 MOL_ID: 2;                                                           
COMPND   9 MOLECULE: PINCH PROTEIN;                                             
COMPND  10 CHAIN: B;                                                            
COMPND  11 FRAGMENT: FOURTH LIM DOMAIN (RESIDUES 188-251);                      
COMPND  12 SYNONYM: PARTICULARLY INTERESTING NEW CYS-HIS PROTEIN, LIM           
COMPND  13 AND SENESCENT CELL ANTIGEN-LIKE DOMAINS 1;                           
COMPND  14 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: NCK2;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PTYB11;                                   
SOURCE  10 MOL_ID: 2;                                                           
SOURCE  11 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE  12 ORGANISM_COMMON: HUMAN;                                              
SOURCE  13 GENE: LIMS1;                                                         
SOURCE  14 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  15 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE  16 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE  17 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  18 EXPRESSION_SYSTEM_PLASMID: PGEX-4T-1                                 
KEYWDS    PROTEIN-PROTEIN COMPLEX, BETA BARREL, BETA SHEET, ZINC                
KEYWDS   2 FINGER                                                               
EXPDTA    NMR, 18 STRUCTURES                                                    
AUTHOR    J.VAYNBERG,T.FUKUDA,O.VINOGRADOVA,A.VELYVIS,L.NG,C.WU,J.QIN           
REVDAT   1   05-APR-05 1U5S    0                                                
JRNL        AUTH   J.VAYNBERG,T.FUKUDA,K.CHEN,O.VINOGRADOVA,A.VELYVIS,          
JRNL        AUTH 2 Y.TU,L.NG,C.WU,J.QIN                                         
JRNL        TITL   STRUCTURE OF AN ULTRAWEAK PROTEIN-PROTEIN COMPLEX            
JRNL        TITL 2 AND ITS CRUCIAL ROLE IN REGULATION OF CELL                   
JRNL        TITL 3 MORPHOLOGY AND MOTILITY.                                     
JRNL        REF    MOL.CELL                      V.  17   513 2005              
JRNL        REFN   ASTM MOCEFL  US ISSN 1097-2765                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1U5S A    1    71  UNP    O43639   NCK2_HUMAN     192    262             
DBREF  1U5S B   74   137  UNP    P48059   PINC_HUMAN     188    251             
SEQRES   1 A   71  GLN GLY SER ARG VAL LEU HIS VAL VAL GLN THR LEU TYR          
SEQRES   2 A   71  PRO PHE SER SER VAL THR GLU GLU GLU LEU ASN PHE GLU          
SEQRES   3 A   71  LYS GLY GLU THR MET GLU VAL ILE GLU LYS PRO GLU ASN          
SEQRES   4 A   71  ASP PRO GLU TRP TRP LYS CYS LYS ASN ALA ARG GLY GLN          
SEQRES   5 A   71  VAL GLY LEU VAL PRO LYS ASN TYR VAL VAL VAL LEU SER          
SEQRES   6 A   71  ASP GLY PRO ALA LEU HIS                                      
SEQRES   1 B   66  GLY SER MET GLY VAL PRO ILE CYS GLY ALA CYS ARG ARG          
SEQRES   2 B   66  PRO ILE GLU GLY ARG VAL VAL ASN ALA MET GLY LYS GLN          
SEQRES   3 B   66  TRP HIS VAL GLU HIS PHE VAL CYS ALA LYS CYS GLU LYS          
SEQRES   4 B   66  PRO PHE LEU GLY HIS ARG HIS TYR GLU ARG LYS GLY LEU          
SEQRES   5 B   66  ALA TYR CYS GLU THR HIS TYR ASN GLN LEU PHE GLY ASP          
SEQRES   6 B   66  VAL                                                          
HET     ZN  B 138       1                                                       
HET     ZN  B 139       1                                                       
HETNAM      ZN ZINC ION                                                         
FORMUL   3   ZN    2(ZN 2+)                                                     
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLN A   1      32.295  41.631  43.217  1.00  0.00           N  
ATOM      2  CA  GLN A   1      31.926  42.837  42.423  1.00  0.00           C  
ATOM      3  C   GLN A   1      32.911  43.007  41.268  1.00  0.00           C  
ATOM      4  O   GLN A   1      32.887  43.992  40.557  1.00  0.00           O  
ATOM      5  CB  GLN A   1      31.975  44.074  43.322  1.00  0.00           C  
ATOM      6  CG  GLN A   1      31.028  43.883  44.508  1.00  0.00           C  
ATOM      7  CD  GLN A   1      30.842  45.217  45.233  1.00  0.00           C  
ATOM      8  OE1 GLN A   1      29.792  45.821  45.158  1.00  0.00           O  
ATOM      9  NE2 GLN A   1      31.825  45.706  45.937  1.00  0.00           N  
ATOM     10  HA  GLN A   1      30.926  42.717  42.032  1.00  0.00           H  
ATOM     11  HB2 GLN A   1      32.984  44.214  43.685  1.00  0.00           H  
ATOM     12  HB3 GLN A   1      31.670  44.942  42.757  1.00  0.00           H  
ATOM     13  HG2 GLN A   1      30.072  43.529  44.152  1.00  0.00           H  
ATOM     14  HG3 GLN A   1      31.447  43.160  45.191  1.00  0.00           H  
ATOM     15 HE21 GLN A   1      32.673  45.218  45.998  1.00  0.00           H  
ATOM     16 HE22 GLN A   1      31.715  46.559  46.406  1.00  0.00           H  
ATOM     17  H1  GLN A   1      31.442  41.231  43.659  1.00  0.00           H  
ATOM     18  H2  GLN A   1      32.977  41.899  43.957  1.00  0.00           H  
ATOM     19  H3  GLN A   1      32.723  40.919  42.590  1.00  0.00           H  
ATOM     20  N   GLY A   2      33.783  42.053  41.072  1.00  0.00           N  
ATOM     21  CA  GLY A   2      34.767  42.162  39.961  1.00  0.00           C  
ATOM     22  C   GLY A   2      35.466  40.815  39.764  1.00  0.00           C  
ATOM     23  O   GLY A   2      36.610  40.638  40.134  1.00  0.00           O  
ATOM     24  H   GLY A   2      33.785  41.266  41.655  1.00  0.00           H  
ATOM     25  HA2 GLY A   2      34.254  42.439  39.050  1.00  0.00           H  
ATOM     26  HA3 GLY A   2      35.504  42.913  40.204  1.00  0.00           H  
ATOM     27  N   SER A   3      34.789  39.864  39.180  1.00  0.00           N  
ATOM     28  CA  SER A   3      35.417  38.533  38.960  1.00  0.00           C  
ATOM     29  C   SER A   3      34.630  37.764  37.899  1.00  0.00           C  
ATOM     30  O   SER A   3      34.495  36.558  37.963  1.00  0.00           O  
ATOM     31  CB  SER A   3      35.410  37.742  40.270  1.00  0.00           C  
ATOM     32  OG  SER A   3      34.067  37.511  40.671  1.00  0.00           O  
ATOM     33  H   SER A   3      33.868  40.026  38.888  1.00  0.00           H  
ATOM     34  HA  SER A   3      36.435  38.666  38.626  1.00  0.00           H  
ATOM     35  HB2 SER A   3      35.904  36.796  40.126  1.00  0.00           H  
ATOM     36  HB3 SER A   3      35.934  38.307  41.032  1.00  0.00           H  
ATOM     37  HG  SER A   3      33.793  38.243  41.230  1.00  0.00           H  
ATOM     38  N   ARG A   4      34.114  38.451  36.918  1.00  0.00           N  
ATOM     39  CA  ARG A   4      33.340  37.757  35.849  1.00  0.00           C  
ATOM     40  C   ARG A   4      34.307  36.986  34.951  1.00  0.00           C  
ATOM     41  O   ARG A   4      35.438  37.383  34.756  1.00  0.00           O  
ATOM     42  CB  ARG A   4      32.580  38.791  35.014  1.00  0.00           C  
ATOM     43  CG  ARG A   4      31.760  38.078  33.935  1.00  0.00           C  
ATOM     44  CD  ARG A   4      30.919  39.097  33.159  1.00  0.00           C  
ATOM     45  NE  ARG A   4      30.207  40.017  34.110  1.00  0.00           N  
ATOM     46  CZ  ARG A   4      29.405  39.561  35.035  1.00  0.00           C  
ATOM     47  NH1 ARG A   4      29.058  38.303  35.055  1.00  0.00           N  
ATOM     48  NH2 ARG A   4      28.901  40.383  35.915  1.00  0.00           N  
ATOM     49  H   ARG A   4      34.238  39.423  36.882  1.00  0.00           H  
ATOM     50  HA  ARG A   4      32.639  37.071  36.300  1.00  0.00           H  
ATOM     51  HB2 ARG A   4      31.922  39.356  35.658  1.00  0.00           H  
ATOM     52  HB3 ARG A   4      33.284  39.462  34.543  1.00  0.00           H  
ATOM     53  HG2 ARG A   4      32.431  37.578  33.251  1.00  0.00           H  
ATOM     54  HG3 ARG A   4      31.116  37.348  34.394  1.00  0.00           H  
ATOM     55  HD2 ARG A   4      31.568  39.700  32.553  1.00  0.00           H  
ATOM     56  HD3 ARG A   4      30.224  38.567  32.509  1.00  0.00           H  
ATOM     57  HE  ARG A   4      30.386  40.979  34.063  1.00  0.00           H  
ATOM     58 HH11 ARG A   4      29.404  37.679  34.357  1.00  0.00           H  
ATOM     59 HH12 ARG A   4      28.449  37.964  35.772  1.00  0.00           H  
ATOM     60 HH21 ARG A   4      29.129  41.356  35.879  1.00  0.00           H  
ATOM     61 HH22 ARG A   4      28.286  40.040  36.626  1.00  0.00           H  
ATOM     62  N   VAL A   5      33.875  35.882  34.402  1.00  0.00           N  
ATOM     63  CA  VAL A   5      34.779  35.095  33.519  1.00  0.00           C  
ATOM     64  C   VAL A   5      35.089  35.908  32.260  1.00  0.00           C  
ATOM     65  O   VAL A   5      34.363  35.862  31.286  1.00  0.00           O  
ATOM     66  CB  VAL A   5      34.093  33.783  33.130  1.00  0.00           C  
ATOM     67  CG1 VAL A   5      35.070  32.909  32.344  1.00  0.00           C  
ATOM     68  CG2 VAL A   5      33.654  33.045  34.395  1.00  0.00           C  
ATOM     69  H   VAL A   5      32.959  35.575  34.570  1.00  0.00           H  
ATOM     70  HA  VAL A   5      35.697  34.879  34.044  1.00  0.00           H  
ATOM     71  HB  VAL A   5      33.230  34.000  32.517  1.00  0.00           H  
ATOM     72 HG11 VAL A   5      35.993  32.815  32.896  1.00  0.00           H  
ATOM     73 HG12 VAL A   5      35.271  33.364  31.385  1.00  0.00           H  
ATOM     74 HG13 VAL A   5      34.637  31.931  32.195  1.00  0.00           H  
ATOM     75 HG21 VAL A   5      32.814  33.559  34.839  1.00  0.00           H  
ATOM     76 HG22 VAL A   5      34.473  33.019  35.099  1.00  0.00           H  
ATOM     77 HG23 VAL A   5      33.366  32.036  34.142  1.00  0.00           H  
ATOM     78  N   LEU A   6      36.174  36.641  32.275  1.00  0.00           N  
ATOM     79  CA  LEU A   6      36.574  37.462  31.088  1.00  0.00           C  
ATOM     80  C   LEU A   6      37.958  37.006  30.643  1.00  0.00           C  
ATOM     81  O   LEU A   6      38.178  36.648  29.502  1.00  0.00           O  
ATOM     82  CB  LEU A   6      36.627  38.943  31.477  1.00  0.00           C  
ATOM     83  CG  LEU A   6      35.202  39.484  31.711  1.00  0.00           C  
ATOM     84  CD1 LEU A   6      35.263  40.731  32.598  1.00  0.00           C  
ATOM     85  CD2 LEU A   6      34.547  39.863  30.373  1.00  0.00           C  
ATOM     86  H   LEU A   6      36.747  36.638  33.070  1.00  0.00           H  
ATOM     87  HA  LEU A   6      35.874  37.319  30.277  1.00  0.00           H  
ATOM     88  HB2 LEU A   6      37.206  39.049  32.385  1.00  0.00           H  
ATOM     89  HB3 LEU A   6      37.103  39.505  30.687  1.00  0.00           H  
ATOM     90  HG  LEU A   6      34.605  38.729  32.202  1.00  0.00           H  
ATOM     91 HD11 LEU A   6      34.292  41.202  32.622  1.00  0.00           H  
ATOM     92 HD12 LEU A   6      35.990  41.421  32.199  1.00  0.00           H  
ATOM     93 HD13 LEU A   6      35.549  40.446  33.601  1.00  0.00           H  
ATOM     94 HD21 LEU A   6      33.626  40.391  30.563  1.00  0.00           H  
ATOM     95 HD22 LEU A   6      34.335  38.971  29.804  1.00  0.00           H  
ATOM     96 HD23 LEU A   6      35.212  40.499  29.807  1.00  0.00           H  
ATOM     97  N   HIS A   7      38.896  37.012  31.553  1.00  0.00           N  
ATOM     98  CA  HIS A   7      40.279  36.579  31.223  1.00  0.00           C  
ATOM     99  C   HIS A   7      40.880  35.876  32.438  1.00  0.00           C  
ATOM    100  O   HIS A   7      41.735  36.409  33.113  1.00  0.00           O  
ATOM    101  CB  HIS A   7      41.128  37.800  30.865  1.00  0.00           C  
ATOM    102  CG  HIS A   7      40.490  38.535  29.719  1.00  0.00           C  
ATOM    103  ND1 HIS A   7      40.514  38.045  28.422  1.00  0.00           N  
ATOM    104  CD2 HIS A   7      39.811  39.726  29.656  1.00  0.00           C  
ATOM    105  CE1 HIS A   7      39.865  38.928  27.642  1.00  0.00           C  
ATOM    106  NE2 HIS A   7      39.415  39.973  28.344  1.00  0.00           N  
ATOM    107  H   HIS A   7      38.686  37.304  32.466  1.00  0.00           H  
ATOM    108  HA  HIS A   7      40.262  35.894  30.387  1.00  0.00           H  
ATOM    109  HB2 HIS A   7      41.192  38.456  31.722  1.00  0.00           H  
ATOM    110  HB3 HIS A   7      42.118  37.481  30.580  1.00  0.00           H  
ATOM    111  HD1 HIS A   7      40.926  37.204  28.127  1.00  0.00           H  
ATOM    112  HD2 HIS A   7      39.611  40.373  30.497  1.00  0.00           H  
ATOM    113  HE1 HIS A   7      39.725  38.810  26.578  1.00  0.00           H  
ATOM    114  N   VAL A   8      40.456  34.673  32.716  1.00  0.00           N  
ATOM    115  CA  VAL A   8      41.023  33.939  33.878  1.00  0.00           C  
ATOM    116  C   VAL A   8      42.463  33.593  33.521  1.00  0.00           C  
ATOM    117  O   VAL A   8      42.803  33.572  32.356  1.00  0.00           O  
ATOM    118  CB  VAL A   8      40.216  32.661  34.119  1.00  0.00           C  
ATOM    119  CG1 VAL A   8      40.904  31.815  35.186  1.00  0.00           C  
ATOM    120  CG2 VAL A   8      38.807  33.028  34.596  1.00  0.00           C  
ATOM    121  H   VAL A   8      39.776  34.251  32.150  1.00  0.00           H  
ATOM    122  HA  VAL A   8      40.997  34.567  34.758  1.00  0.00           H  
ATOM    123  HB  VAL A   8      40.152  32.098  33.198  1.00  0.00           H  
ATOM    124 HG11 VAL A   8      41.591  32.431  35.747  1.00  0.00           H  
ATOM    125 HG12 VAL A   8      41.446  31.011  34.711  1.00  0.00           H  
ATOM    126 HG13 VAL A   8      40.162  31.405  35.854  1.00  0.00           H  
ATOM    127 HG21 VAL A   8      38.080  32.426  34.071  1.00  0.00           H  
ATOM    128 HG22 VAL A   8      38.620  34.071  34.396  1.00  0.00           H  
ATOM    129 HG23 VAL A   8      38.728  32.845  35.656  1.00  0.00           H  
ATOM    130  N   VAL A   9      43.336  33.341  34.477  1.00  0.00           N  
ATOM    131  CA  VAL A   9      44.748  33.032  34.087  1.00  0.00           C  
ATOM    132  C   VAL A   9      45.380  32.005  35.024  1.00  0.00           C  
ATOM    133  O   VAL A   9      45.335  32.127  36.234  1.00  0.00           O  
ATOM    134  CB  VAL A   9      45.582  34.332  34.093  1.00  0.00           C  
ATOM    135  CG1 VAL A   9      44.811  35.455  33.394  1.00  0.00           C  
ATOM    136  CG2 VAL A   9      45.865  34.752  35.537  1.00  0.00           C  
ATOM    137  H   VAL A   9      43.075  33.369  35.431  1.00  0.00           H  
ATOM    138  HA  VAL A   9      44.757  32.621  33.090  1.00  0.00           H  
ATOM    139  HB  VAL A   9      46.514  34.163  33.575  1.00  0.00           H  
ATOM    140 HG11 VAL A   9      44.341  35.066  32.502  1.00  0.00           H  
ATOM    141 HG12 VAL A   9      45.493  36.247  33.123  1.00  0.00           H  
ATOM    142 HG13 VAL A   9      44.056  35.843  34.057  1.00  0.00           H  
ATOM    143 HG21 VAL A   9      45.009  34.526  36.155  1.00  0.00           H  
ATOM    144 HG22 VAL A   9      46.054  35.815  35.563  1.00  0.00           H  
ATOM    145 HG23 VAL A   9      46.729  34.223  35.912  1.00  0.00           H  
ATOM    146  N   GLN A  10      45.994  31.003  34.453  1.00  0.00           N  
ATOM    147  CA  GLN A  10      46.672  29.950  35.262  1.00  0.00           C  
ATOM    148  C   GLN A  10      48.175  30.234  35.295  1.00  0.00           C  
ATOM    149  O   GLN A  10      48.803  30.443  34.276  1.00  0.00           O  
ATOM    150  CB  GLN A  10      46.430  28.579  34.626  1.00  0.00           C  
ATOM    151  CG  GLN A  10      44.946  28.220  34.722  1.00  0.00           C  
ATOM    152  CD  GLN A  10      44.701  26.876  34.033  1.00  0.00           C  
ATOM    153  OE1 GLN A  10      45.628  26.234  33.580  1.00  0.00           O  
ATOM    154  NE2 GLN A  10      43.483  26.418  33.931  1.00  0.00           N  
ATOM    155  H   GLN A  10      46.017  30.950  33.481  1.00  0.00           H  
ATOM    156  HA  GLN A  10      46.286  29.953  36.267  1.00  0.00           H  
ATOM    157  HB2 GLN A  10      46.725  28.608  33.586  1.00  0.00           H  
ATOM    158  HB3 GLN A  10      47.011  27.832  35.143  1.00  0.00           H  
ATOM    159  HG2 GLN A  10      44.659  28.150  35.762  1.00  0.00           H  
ATOM    160  HG3 GLN A  10      44.358  28.983  34.235  1.00  0.00           H  
ATOM    161 HE21 GLN A  10      42.733  26.935  34.294  1.00  0.00           H  
ATOM    162 HE22 GLN A  10      43.317  25.560  33.490  1.00  0.00           H  
ATOM    163  N   THR A  11      48.752  30.247  36.462  1.00  0.00           N  
ATOM    164  CA  THR A  11      50.214  30.519  36.586  1.00  0.00           C  
ATOM    165  C   THR A  11      51.017  29.436  35.892  1.00  0.00           C  
ATOM    166  O   THR A  11      50.599  28.307  35.746  1.00  0.00           O  
ATOM    167  CB  THR A  11      50.592  30.540  38.055  1.00  0.00           C  
ATOM    168  OG1 THR A  11      49.778  31.484  38.733  1.00  0.00           O  
ATOM    169  CG2 THR A  11      52.074  30.906  38.231  1.00  0.00           C  
ATOM    170  H   THR A  11      48.221  30.076  37.268  1.00  0.00           H  
ATOM    171  HA  THR A  11      50.460  31.467  36.144  1.00  0.00           H  
ATOM    172  HB  THR A  11      50.421  29.569  38.456  1.00  0.00           H  
ATOM    173  HG1 THR A  11      49.498  32.147  38.097  1.00  0.00           H  
ATOM    174 HG21 THR A  11      52.217  31.359  39.201  1.00  0.00           H  
ATOM    175 HG22 THR A  11      52.379  31.601  37.462  1.00  0.00           H  
ATOM    176 HG23 THR A  11      52.673  30.013  38.164  1.00  0.00           H  
ATOM    177  N   LEU A  12      52.189  29.802  35.484  1.00  5.40           N  
ATOM    178  CA  LEU A  12      53.117  28.859  34.800  1.00  9.02           C  
ATOM    179  C   LEU A  12      54.323  28.665  35.719  1.00 10.54           C  
ATOM    180  O   LEU A  12      55.087  27.730  35.566  1.00 10.21           O  
ATOM    181  CB  LEU A  12      53.606  29.468  33.461  1.00  7.97           C  
ATOM    182  CG  LEU A  12      52.494  29.622  32.356  1.00  7.96           C  
ATOM    183  CD1 LEU A  12      53.049  30.426  31.179  1.00  6.40           C  
ATOM    184  CD2 LEU A  12      51.979  28.285  31.792  1.00  6.66           C  
ATOM    185  H   LEU A  12      52.470  30.718  35.653  1.00  0.00           H  
ATOM    186  HA  LEU A  12      52.653  27.902  34.643  1.00  0.00           H  
ATOM    187  HB2 LEU A  12      54.015  30.451  33.673  1.00  0.00           H  
ATOM    188  HB3 LEU A  12      54.408  28.846  33.078  1.00  0.00           H  
ATOM    189  HG  LEU A  12      51.659  30.170  32.778  1.00  0.00           H  
ATOM    190 HD11 LEU A  12      53.956  29.962  30.822  1.00  0.00           H  
ATOM    191 HD12 LEU A  12      53.261  31.435  31.500  1.00  0.00           H  
ATOM    192 HD13 LEU A  12      52.313  30.444  30.388  1.00  0.00           H  
ATOM    193 HD21 LEU A  12      51.208  27.889  32.434  1.00  0.00           H  
ATOM    194 HD22 LEU A  12      52.797  27.581  31.756  1.00  0.00           H  
ATOM    195 HD23 LEU A  12      51.594  28.427  30.800  1.00  0.00           H  
ATOM    196  N   TYR A  13      54.509  29.547  36.671  1.00 12.19           N  
ATOM    197  CA  TYR A  13      55.687  29.402  37.594  1.00 12.32           C  
ATOM    198  C   TYR A  13      55.358  29.976  38.996  1.00 14.17           C  
ATOM    199  O   TYR A  13      54.660  30.966  39.086  1.00 14.79           O  
ATOM    200  CB  TYR A  13      56.874  30.172  37.009  1.00 14.83           C  
ATOM    201  CG  TYR A  13      56.963  29.915  35.523  1.00 15.75           C  
ATOM    202  CD1 TYR A  13      57.513  28.717  35.051  1.00 18.39           C  
ATOM    203  CD2 TYR A  13      56.497  30.874  34.615  1.00 10.85           C  
ATOM    204  CE1 TYR A  13      57.598  28.479  33.675  1.00 12.56           C  
ATOM    205  CE2 TYR A  13      56.583  30.635  33.238  1.00 10.94           C  
ATOM    206  CZ  TYR A  13      57.133  29.438  32.768  1.00 12.35           C  
ATOM    207  OH  TYR A  13      57.217  29.202  31.411  1.00 12.20           O  
ATOM    208  H   TYR A  13      53.877  30.302  36.770  1.00  0.00           H  
ATOM    209  HA  TYR A  13      55.943  28.366  37.662  1.00  0.00           H  
ATOM    210  HB2 TYR A  13      56.738  31.231  37.184  1.00  0.00           H  
ATOM    211  HB3 TYR A  13      57.785  29.844  37.486  1.00  0.00           H  
ATOM    212  HD1 TYR A  13      57.873  27.977  35.752  1.00  0.00           H  
ATOM    213  HD2 TYR A  13      56.071  31.800  34.977  1.00  0.00           H  
ATOM    214  HE1 TYR A  13      58.023  27.555  33.314  1.00  0.00           H  
ATOM    215  HE2 TYR A  13      56.223  31.376  32.538  1.00  0.00           H  
ATOM    216  HH  TYR A  13      56.332  29.263  31.043  1.00  0.00           H  
ATOM    217  N   PRO A  14      55.884  29.368  40.062  1.00  0.00           N  
ATOM    218  CA  PRO A  14      55.647  29.874  41.437  1.00  0.00           C  
ATOM    219  C   PRO A  14      56.460  31.163  41.643  1.00  0.00           C  
ATOM    220  O   PRO A  14      57.542  31.143  42.198  1.00  0.00           O  
ATOM    221  CB  PRO A  14      56.172  28.754  42.359  1.00  0.00           C  
ATOM    222  CG  PRO A  14      57.071  27.838  41.485  1.00  0.00           C  
ATOM    223  CD  PRO A  14      56.737  28.149  40.008  1.00  0.00           C  
ATOM    224  HA  PRO A  14      54.595  30.051  41.610  1.00  0.00           H  
ATOM    225  HB2 PRO A  14      56.744  29.169  43.182  1.00  0.00           H  
ATOM    226  HB3 PRO A  14      55.343  28.179  42.747  1.00  0.00           H  
ATOM    227  HG2 PRO A  14      58.115  28.052  41.684  1.00  0.00           H  
ATOM    228  HG3 PRO A  14      56.864  26.799  41.697  1.00  0.00           H  
ATOM    229  HD2 PRO A  14      57.633  28.340  39.446  1.00  0.00           H  
ATOM    230  HD3 PRO A  14      56.198  27.330  39.574  1.00  0.00           H  
ATOM    231  N   PHE A  15      55.963  32.275  41.189  1.00  0.00           N  
ATOM    232  CA  PHE A  15      56.726  33.549  41.346  1.00  0.00           C  
ATOM    233  C   PHE A  15      56.725  34.009  42.800  1.00  0.00           C  
ATOM    234  O   PHE A  15      56.015  33.483  43.634  1.00  0.00           O  
ATOM    235  CB  PHE A  15      56.089  34.642  40.491  1.00  0.00           C  
ATOM    236  CG  PHE A  15      56.986  35.871  40.441  1.00  0.00           C  
ATOM    237  CD1 PHE A  15      58.310  35.778  39.978  1.00  0.00           C  
ATOM    238  CD2 PHE A  15      56.487  37.118  40.856  1.00  0.00           C  
ATOM    239  CE1 PHE A  15      59.121  36.918  39.931  1.00  0.00           C  
ATOM    240  CE2 PHE A  15      57.301  38.255  40.808  1.00  0.00           C  
ATOM    241  CZ  PHE A  15      58.616  38.156  40.346  1.00  0.00           C  
ATOM    242  H   PHE A  15      55.097  32.273  40.727  1.00  0.00           H  
ATOM    243  HA  PHE A  15      57.739  33.386  41.031  1.00  0.00           H  
ATOM    244  HB2 PHE A  15      55.927  34.266  39.500  1.00  0.00           H  
ATOM    245  HB3 PHE A  15      55.141  34.910  40.923  1.00  0.00           H  
ATOM    246  HD1 PHE A  15      58.707  34.831  39.653  1.00  0.00           H  
ATOM    247  HD2 PHE A  15      55.471  37.200  41.213  1.00  0.00           H  
ATOM    248  HE1 PHE A  15      60.137  36.845  39.573  1.00  0.00           H  
ATOM    249  HE2 PHE A  15      56.913  39.210  41.127  1.00  0.00           H  
ATOM    250  HZ  PHE A  15      59.243  39.034  40.309  1.00  0.00           H  
ATOM    251  N   SER A  16      57.520  35.002  43.098  1.00  0.00           N  
ATOM    252  CA  SER A  16      57.587  35.536  44.492  1.00  0.00           C  
ATOM    253  C   SER A  16      57.627  37.062  44.450  1.00  0.00           C  
ATOM    254  O   SER A  16      58.590  37.665  44.023  1.00  0.00           O  
ATOM    255  CB  SER A  16      58.844  35.009  45.186  1.00  0.00           C  
ATOM    256  OG  SER A  16      58.701  33.612  45.416  1.00  0.00           O  
ATOM    257  H   SER A  16      58.074  35.406  42.391  1.00  0.00           H  
ATOM    258  HA  SER A  16      56.711  35.232  45.047  1.00  0.00           H  
ATOM    259  HB2 SER A  16      59.703  35.177  44.558  1.00  0.00           H  
ATOM    260  HB3 SER A  16      58.980  35.528  46.124  1.00  0.00           H  
ATOM    261  HG  SER A  16      57.994  33.288  44.854  1.00  0.00           H  
ATOM    262  N   SER A  17      56.570  37.681  44.895  1.00  0.00           N  
ATOM    263  CA  SER A  17      56.489  39.168  44.901  1.00  0.00           C  
ATOM    264  C   SER A  17      55.945  39.612  46.261  1.00  0.00           C  
ATOM    265  O   SER A  17      54.799  39.375  46.580  1.00  0.00           O  
ATOM    266  CB  SER A  17      55.560  39.604  43.761  1.00  0.00           C  
ATOM    267  OG  SER A  17      56.040  40.817  43.205  1.00  0.00           O  
ATOM    268  H   SER A  17      55.811  37.158  45.230  1.00  0.00           H  
ATOM    269  HA  SER A  17      57.468  39.602  44.758  1.00  0.00           H  
ATOM    270  HB2 SER A  17      55.555  38.847  42.997  1.00  0.00           H  
ATOM    271  HB3 SER A  17      54.550  39.735  44.130  1.00  0.00           H  
ATOM    272  HG  SER A  17      55.712  40.882  42.306  1.00  0.00           H  
ATOM    273  N   VAL A  18      56.760  40.256  47.062  1.00  0.00           N  
ATOM    274  CA  VAL A  18      56.299  40.707  48.398  1.00  0.00           C  
ATOM    275  C   VAL A  18      56.657  42.173  48.582  1.00  0.00           C  
ATOM    276  O   VAL A  18      57.727  42.542  49.025  1.00  0.00           O  
ATOM    277  CB  VAL A  18      56.994  39.867  49.481  1.00  0.00           C  
ATOM    278  CG1 VAL A  18      56.694  38.382  49.252  1.00  0.00           C  
ATOM    279  CG2 VAL A  18      58.509  40.091  49.409  1.00  0.00           C  
ATOM    280  H   VAL A  18      57.664  40.450  46.783  1.00  0.00           H  
ATOM    281  HA  VAL A  18      55.227  40.593  48.489  1.00  0.00           H  
ATOM    282  HB  VAL A  18      56.630  40.157  50.458  1.00  0.00           H  
ATOM    283 HG11 VAL A  18      56.840  38.141  48.210  1.00  0.00           H  
ATOM    284 HG12 VAL A  18      55.671  38.174  49.530  1.00  0.00           H  
ATOM    285 HG13 VAL A  18      57.361  37.784  49.856  1.00  0.00           H  
ATOM    286 HG21 VAL A  18      58.761  40.542  48.460  1.00  0.00           H  
ATOM    287 HG22 VAL A  18      59.018  39.145  49.503  1.00  0.00           H  
ATOM    288 HG23 VAL A  18      58.815  40.746  50.210  1.00  0.00           H  
ATOM    289  N   THR A  19      55.719  42.989  48.268  1.00 38.32           N  
ATOM    290  CA  THR A  19      55.867  44.467  48.423  1.00 37.06           C  
ATOM    291  C   THR A  19      54.513  45.025  48.835  1.00 36.60           C  
ATOM    292  O   THR A  19      53.696  44.345  49.424  1.00 36.42           O  
ATOM    293  CB  THR A  19      56.306  45.121  47.092  1.00 37.05           C  
ATOM    294  OG1 THR A  19      57.299  44.313  46.478  1.00 37.96           O  
ATOM    295  CG2 THR A  19      56.886  46.517  47.355  1.00 37.86           C  
ATOM    296  H   THR A  19      54.887  42.616  47.927  1.00  0.00           H  
ATOM    297  HA  THR A  19      56.583  44.686  49.196  1.00  0.00           H  
ATOM    298  HB  THR A  19      55.451  45.218  46.427  1.00  0.00           H  
ATOM    299  HG1 THR A  19      57.529  44.713  45.636  1.00  0.00           H  
ATOM    300 HG21 THR A  19      56.348  47.246  46.769  1.00  0.00           H  
ATOM    301 HG22 THR A  19      57.930  46.532  47.077  1.00  0.00           H  
ATOM    302 HG23 THR A  19      56.788  46.756  48.404  1.00  0.00           H  
ATOM    303  N   GLU A  20      54.266  46.239  48.492  1.00 36.33           N  
ATOM    304  CA  GLU A  20      53.001  46.859  48.796  1.00 36.39           C  
ATOM    305  C   GLU A  20      52.014  46.420  47.702  1.00 30.94           C  
ATOM    306  O   GLU A  20      50.940  45.925  47.982  1.00 31.73           O  
ATOM    307  CB  GLU A  20      53.282  48.367  48.822  1.00 41.00           C  
ATOM    308  CG  GLU A  20      52.019  49.086  49.136  1.00 49.07           C  
ATOM    309  CD  GLU A  20      51.612  48.834  50.589  1.00 52.00           C  
ATOM    310  OE1 GLU A  20      52.393  48.233  51.307  1.00 54.38           O  
ATOM    311  OE2 GLU A  20      50.525  49.247  50.957  1.00 55.13           O  
ATOM    312  H   GLU A  20      54.916  46.759  47.991  1.00  0.00           H  
ATOM    313  HA  GLU A  20      52.619  46.566  49.736  1.00  0.00           H  
ATOM    314  HB2 GLU A  20      54.023  48.586  49.577  1.00  0.00           H  
ATOM    315  HB3 GLU A  20      53.646  48.683  47.856  1.00  0.00           H  
ATOM    316  HG2 GLU A  20      52.225  50.106  48.983  1.00  0.00           H  
ATOM    317  HG3 GLU A  20      51.238  48.760  48.467  1.00  0.00           H  
ATOM    318  N   GLU A  21      52.361  46.634  46.458  1.00  0.00           N  
ATOM    319  CA  GLU A  21      51.474  46.291  45.336  1.00  0.00           C  
ATOM    320  C   GLU A  21      52.028  45.082  44.551  1.00  0.00           C  
ATOM    321  O   GLU A  21      51.808  44.960  43.362  1.00  0.00           O  
ATOM    322  CB  GLU A  21      51.446  47.543  44.457  1.00  0.00           C  
ATOM    323  CG  GLU A  21      50.746  48.662  45.207  1.00  0.00           C  
ATOM    324  CD  GLU A  21      50.781  49.951  44.380  1.00  0.00           C  
ATOM    325  OE1 GLU A  21      51.261  49.903  43.260  1.00  0.00           O  
ATOM    326  OE2 GLU A  21      50.324  50.966  44.880  1.00  0.00           O  
ATOM    327  H   GLU A  21      53.201  47.066  46.248  1.00  0.00           H  
ATOM    328  HA  GLU A  21      50.477  46.078  45.690  1.00  0.00           H  
ATOM    329  HB2 GLU A  21      52.462  47.851  44.236  1.00  0.00           H  
ATOM    330  HB3 GLU A  21      50.951  47.338  43.546  1.00  0.00           H  
ATOM    331  HG2 GLU A  21      49.723  48.369  45.375  1.00  0.00           H  
ATOM    332  HG3 GLU A  21      51.230  48.821  46.137  1.00  0.00           H  
ATOM    333  N   GLU A  22      52.752  44.198  45.195  1.00  0.00           N  
ATOM    334  CA  GLU A  22      53.325  43.010  44.472  1.00  0.00           C  
ATOM    335  C   GLU A  22      52.454  41.764  44.740  1.00  0.00           C  
ATOM    336  O   GLU A  22      51.805  41.658  45.761  1.00  0.00           O  
ATOM    337  CB  GLU A  22      54.772  42.796  44.974  1.00  0.00           C  
ATOM    338  CG  GLU A  22      55.787  43.428  43.997  1.00  0.00           C  
ATOM    339  CD  GLU A  22      55.527  44.930  43.886  1.00  0.00           C  
ATOM    340  OE1 GLU A  22      54.557  45.387  44.470  1.00  0.00           O  
ATOM    341  OE2 GLU A  22      56.298  45.598  43.220  1.00  0.00           O  
ATOM    342  H   GLU A  22      52.925  44.316  46.152  1.00  0.00           H  
ATOM    343  HA  GLU A  22      53.332  43.200  43.408  1.00  0.00           H  
ATOM    344  HB2 GLU A  22      54.877  43.262  45.940  1.00  0.00           H  
ATOM    345  HB3 GLU A  22      54.982  41.748  45.070  1.00  0.00           H  
ATOM    346  HG2 GLU A  22      56.790  43.262  44.363  1.00  0.00           H  
ATOM    347  HG3 GLU A  22      55.686  42.978  43.021  1.00  0.00           H  
ATOM    348  N   LEU A  23      52.418  40.833  43.800  1.00 11.68           N  
ATOM    349  CA  LEU A  23      51.565  39.598  43.957  1.00  7.71           C  
ATOM    350  C   LEU A  23      52.443  38.349  44.132  1.00  8.71           C  
ATOM    351  O   LEU A  23      53.084  37.905  43.201  1.00 10.83           O  
ATOM    352  CB  LEU A  23      50.716  39.418  42.674  1.00  7.16           C  
ATOM    353  CG  LEU A  23      49.499  38.473  42.876  1.00  8.46           C  
ATOM    354  CD1 LEU A  23      49.809  37.327  43.844  1.00  6.77           C  
ATOM    355  CD2 LEU A  23      48.300  39.252  43.404  1.00  2.00           C  
ATOM    356  H   LEU A  23      52.933  40.959  42.978  1.00  0.00           H  
ATOM    357  HA  LEU A  23      50.917  39.712  44.812  1.00  0.00           H  
ATOM    358  HB2 LEU A  23      50.358  40.381  42.354  1.00  0.00           H  
ATOM    359  HB3 LEU A  23      51.345  39.013  41.892  1.00  0.00           H  
ATOM    360  HG  LEU A  23      49.238  38.046  41.918  1.00  0.00           H  
ATOM    361 HD11 LEU A  23      48.933  36.706  43.949  1.00  0.00           H  
ATOM    362 HD12 LEU A  23      50.080  37.718  44.810  1.00  0.00           H  
ATOM    363 HD13 LEU A  23      50.612  36.740  43.453  1.00  0.00           H  
ATOM    364 HD21 LEU A  23      47.424  38.622  43.380  1.00  0.00           H  
ATOM    365 HD22 LEU A  23      48.136  40.114  42.779  1.00  0.00           H  
ATOM    366 HD23 LEU A  23      48.490  39.566  44.417  1.00  0.00           H  
ATOM    367  N   ASN A  24      52.442  37.750  45.294  1.00  0.00           N  
ATOM    368  CA  ASN A  24      53.235  36.494  45.490  1.00  0.00           C  
ATOM    369  C   ASN A  24      52.268  35.333  45.271  1.00  0.00           C  
ATOM    370  O   ASN A  24      51.203  35.307  45.853  1.00  0.00           O  
ATOM    371  CB  ASN A  24      53.790  36.438  46.924  1.00  0.00           C  
ATOM    372  CG  ASN A  24      54.272  35.020  47.246  1.00  0.00           C  
ATOM    373  OD1 ASN A  24      54.110  34.548  48.354  1.00  0.00           O  
ATOM    374  ND2 ASN A  24      54.857  34.315  46.319  1.00  0.00           N  
ATOM    375  H   ASN A  24      51.890  38.098  46.025  1.00  0.00           H  
ATOM    376  HA  ASN A  24      54.045  36.440  44.774  1.00  0.00           H  
ATOM    377  HB2 ASN A  24      54.619  37.121  47.016  1.00  0.00           H  
ATOM    378  HB3 ASN A  24      53.015  36.719  47.621  1.00  0.00           H  
ATOM    379 HD21 ASN A  24      54.989  34.695  45.425  1.00  0.00           H  
ATOM    380 HD22 ASN A  24      55.171  33.407  46.516  1.00  0.00           H  
ATOM    381  N   PHE A  25      52.584  34.385  44.424  1.00  6.72           N  
ATOM    382  CA  PHE A  25      51.611  33.284  44.201  1.00  6.82           C  
ATOM    383  C   PHE A  25      52.320  32.012  43.774  1.00  7.56           C  
ATOM    384  O   PHE A  25      53.282  32.032  43.029  1.00  6.07           O  
ATOM    385  CB  PHE A  25      50.580  33.708  43.143  1.00  9.59           C  
ATOM    386  CG  PHE A  25      51.233  34.129  41.823  1.00  9.18           C  
ATOM    387  CD1 PHE A  25      52.144  35.204  41.760  1.00  5.54           C  
ATOM    388  CD2 PHE A  25      50.884  33.467  40.641  1.00 11.29           C  
ATOM    389  CE1 PHE A  25      52.690  35.590  40.532  1.00  5.32           C  
ATOM    390  CE2 PHE A  25      51.432  33.860  39.417  1.00 11.14           C  
ATOM    391  CZ  PHE A  25      52.336  34.917  39.362  1.00 12.44           C  
ATOM    392  H   PHE A  25      53.436  34.405  43.922  1.00  0.00           H  
ATOM    393  HA  PHE A  25      51.087  33.080  45.127  1.00  0.00           H  
ATOM    394  HB2 PHE A  25      49.913  32.879  42.962  1.00  0.00           H  
ATOM    395  HB3 PHE A  25      50.003  34.533  43.532  1.00  0.00           H  
ATOM    396  HD1 PHE A  25      52.431  35.731  42.646  1.00  0.00           H  
ATOM    397  HD2 PHE A  25      50.199  32.643  40.678  1.00  0.00           H  
ATOM    398  HE1 PHE A  25      53.392  36.409  40.489  1.00  0.00           H  
ATOM    399  HE2 PHE A  25      51.150  33.348  38.513  1.00  0.00           H  
ATOM    400  HZ  PHE A  25      52.757  35.223  38.415  1.00  0.00           H  
ATOM    401  N   GLU A  26      51.839  30.897  44.251  1.00  0.00           N  
ATOM    402  CA  GLU A  26      52.458  29.598  43.891  1.00  0.00           C  
ATOM    403  C   GLU A  26      51.878  29.148  42.559  1.00  0.00           C  
ATOM    404  O   GLU A  26      50.796  29.545  42.178  1.00  0.00           O  
ATOM    405  CB  GLU A  26      52.169  28.559  44.988  1.00  0.00           C  
ATOM    406  CG  GLU A  26      50.706  28.093  44.925  1.00  0.00           C  
ATOM    407  CD  GLU A  26      49.777  29.307  44.868  1.00  0.00           C  
ATOM    408  OE1 GLU A  26      49.975  30.219  45.655  1.00  0.00           O  
ATOM    409  OE2 GLU A  26      48.883  29.307  44.037  1.00  0.00           O  
ATOM    410  H   GLU A  26      51.058  30.919  44.841  1.00  0.00           H  
ATOM    411  HA  GLU A  26      53.529  29.722  43.790  1.00  0.00           H  
ATOM    412  HB2 GLU A  26      52.817  27.708  44.853  1.00  0.00           H  
ATOM    413  HB3 GLU A  26      52.359  29.000  45.954  1.00  0.00           H  
ATOM    414  HG2 GLU A  26      50.558  27.484  44.046  1.00  0.00           H  
ATOM    415  HG3 GLU A  26      50.477  27.512  45.806  1.00  0.00           H  
ATOM    416  N   LYS A  27      52.585  28.335  41.844  1.00  8.66           N  
ATOM    417  CA  LYS A  27      52.067  27.881  40.540  1.00  8.68           C  
ATOM    418  C   LYS A  27      50.688  27.248  40.729  1.00  6.65           C  
ATOM    419  O   LYS A  27      50.400  26.655  41.749  1.00 10.38           O  
ATOM    420  CB  LYS A  27      53.062  26.883  39.951  1.00 12.96           C  
ATOM    421  CG  LYS A  27      52.993  25.530  40.693  1.00 12.48           C  
ATOM    422  CD  LYS A  27      52.114  24.531  39.916  1.00 20.52           C  
ATOM    423  CE  LYS A  27      52.940  23.851  38.818  1.00 28.24           C  
ATOM    424  NZ  LYS A  27      53.826  22.823  39.430  1.00 29.03           N  
ATOM    425  H   LYS A  27      53.458  28.027  42.158  1.00  0.00           H  
ATOM    426  HA  LYS A  27      51.980  28.729  39.888  1.00  0.00           H  
ATOM    427  HB2 LYS A  27      52.862  26.750  38.903  1.00  0.00           H  
ATOM    428  HB3 LYS A  27      54.045  27.297  40.065  1.00  0.00           H  
ATOM    429  HG2 LYS A  27      53.995  25.129  40.791  1.00  0.00           H  
ATOM    430  HG3 LYS A  27      52.577  25.672  41.684  1.00  0.00           H  
ATOM    431  HD2 LYS A  27      51.735  23.782  40.597  1.00  0.00           H  
ATOM    432  HD3 LYS A  27      51.284  25.056  39.464  1.00  0.00           H  
ATOM    433  HE2 LYS A  27      52.274  23.380  38.109  1.00  0.00           H  
ATOM    434  HE3 LYS A  27      53.542  24.591  38.310  1.00  0.00           H  
ATOM    435  HZ1 LYS A  27      54.800  22.959  39.093  1.00  0.00           H  
ATOM    436  HZ2 LYS A  27      53.492  21.875  39.162  1.00  0.00           H  
ATOM    437  HZ3 LYS A  27      53.806  22.919  40.466  1.00  0.00           H  
ATOM    438  N   GLY A  28      49.826  27.391  39.757  1.00  5.06           N  
ATOM    439  CA  GLY A  28      48.455  26.818  39.886  1.00  4.39           C  
ATOM    440  C   GLY A  28      47.562  27.806  40.640  1.00  6.18           C  
ATOM    441  O   GLY A  28      46.814  27.428  41.519  1.00  5.61           O  
ATOM    442  H   GLY A  28      50.076  27.883  38.949  1.00  0.00           H  
ATOM    443  HA2 GLY A  28      48.047  26.637  38.902  1.00  0.00           H  
ATOM    444  HA3 GLY A  28      48.499  25.893  40.436  1.00  0.00           H  
ATOM    445  N   GLU A  29      47.642  29.073  40.305  1.00  7.06           N  
ATOM    446  CA  GLU A  29      46.806  30.108  41.001  1.00  6.19           C  
ATOM    447  C   GLU A  29      45.894  30.796  39.979  1.00  6.67           C  
ATOM    448  O   GLU A  29      46.351  31.500  39.101  1.00  8.12           O  
ATOM    449  CB  GLU A  29      47.737  31.168  41.622  1.00  6.64           C  
ATOM    450  CG  GLU A  29      47.030  32.052  42.697  1.00  9.52           C  
ATOM    451  CD  GLU A  29      45.502  31.921  42.648  1.00  8.21           C  
ATOM    452  OE1 GLU A  29      44.984  30.993  43.247  1.00  6.83           O  
ATOM    453  OE2 GLU A  29      44.878  32.756  42.019  1.00  8.99           O  
ATOM    454  H   GLU A  29      48.259  29.348  39.593  1.00  0.00           H  
ATOM    455  HA  GLU A  29      46.210  29.647  41.774  1.00  0.00           H  
ATOM    456  HB2 GLU A  29      48.580  30.662  42.074  1.00  0.00           H  
ATOM    457  HB3 GLU A  29      48.100  31.810  40.836  1.00  0.00           H  
ATOM    458  HG2 GLU A  29      47.372  31.764  43.680  1.00  0.00           H  
ATOM    459  HG3 GLU A  29      47.296  33.095  42.527  1.00  0.00           H  
ATOM    460  N   THR A  30      44.613  30.626  40.105  1.00  0.00           N  
ATOM    461  CA  THR A  30      43.677  31.302  39.164  1.00  0.00           C  
ATOM    462  C   THR A  30      43.659  32.776  39.518  1.00  0.00           C  
ATOM    463  O   THR A  30      43.117  33.145  40.539  1.00  0.00           O  
ATOM    464  CB  THR A  30      42.268  30.751  39.388  1.00  0.00           C  
ATOM    465  OG1 THR A  30      42.326  29.339  39.530  1.00  0.00           O  
ATOM    466  CG2 THR A  30      41.381  31.116  38.200  1.00  0.00           C  
ATOM    467  H   THR A  30      44.259  30.075  40.835  1.00  0.00           H  
ATOM    468  HA  THR A  30      43.986  31.163  38.123  1.00  0.00           H  
ATOM    469  HB  THR A  30      41.853  31.196  40.291  1.00  0.00           H  
ATOM    470  HG1 THR A  30      41.897  28.945  38.766  1.00  0.00           H  
ATOM    471 HG21 THR A  30      41.661  30.519  37.345  1.00  0.00           H  
ATOM    472 HG22 THR A  30      41.513  32.162  37.971  1.00  0.00           H  
ATOM    473 HG23 THR A  30      40.348  30.925  38.450  1.00  0.00           H  
ATOM    474  N   MET A  31      44.230  33.628  38.713  1.00  0.00           N  
ATOM    475  CA  MET A  31      44.210  35.075  39.066  1.00  0.00           C  
ATOM    476  C   MET A  31      43.218  35.820  38.199  1.00  0.00           C  
ATOM    477  O   MET A  31      43.130  35.656  36.999  1.00  0.00           O  
ATOM    478  CB  MET A  31      45.623  35.667  38.974  1.00  0.00           C  
ATOM    479  CG  MET A  31      46.478  35.142  40.164  1.00  0.00           C  
ATOM    480  SD  MET A  31      47.976  34.333  39.541  1.00  0.00           S  
ATOM    481  CE  MET A  31      48.910  35.846  39.197  1.00  0.00           C  
ATOM    482  H   MET A  31      44.665  33.323  37.889  1.00  0.00           H  
ATOM    483  HA  MET A  31      43.870  35.184  40.078  1.00  0.00           H  
ATOM    484  HB2 MET A  31      46.076  35.377  38.041  1.00  0.00           H  
ATOM    485  HB3 MET A  31      45.563  36.745  39.020  1.00  0.00           H  
ATOM    486  HG2 MET A  31      46.765  35.962  40.805  1.00  0.00           H  
ATOM    487  HG3 MET A  31      45.906  34.430  40.746  1.00  0.00           H  
ATOM    488  HE1 MET A  31      48.259  36.572  38.729  1.00  0.00           H  
ATOM    489  HE2 MET A  31      49.728  35.622  38.533  1.00  0.00           H  
ATOM    490  HE3 MET A  31      49.298  36.246  40.124  1.00  0.00           H  
ATOM    491  N   GLU A  32      42.453  36.625  38.858  1.00  0.00           N  
ATOM    492  CA  GLU A  32      41.397  37.425  38.214  1.00  0.00           C  
ATOM    493  C   GLU A  32      42.017  38.767  37.818  1.00  0.00           C  
ATOM    494  O   GLU A  32      42.267  39.619  38.645  1.00  0.00           O  
ATOM    495  CB  GLU A  32      40.248  37.598  39.243  1.00  0.00           C  
ATOM    496  CG  GLU A  32      40.709  37.115  40.644  1.00  0.00           C  
ATOM    497  CD  GLU A  32      39.676  37.536  41.689  1.00  0.00           C  
ATOM    498  OE1 GLU A  32      38.869  38.398  41.380  1.00  0.00           O  
ATOM    499  OE2 GLU A  32      39.706  36.990  42.777  1.00  0.00           O  
ATOM    500  H   GLU A  32      42.570  36.694  39.827  1.00  0.00           H  
ATOM    501  HA  GLU A  32      41.031  36.916  37.332  1.00  0.00           H  
ATOM    502  HB2 GLU A  32      39.958  38.638  39.302  1.00  0.00           H  
ATOM    503  HB3 GLU A  32      39.394  37.012  38.934  1.00  0.00           H  
ATOM    504  HG2 GLU A  32      40.818  36.028  40.661  1.00  0.00           H  
ATOM    505  HG3 GLU A  32      41.667  37.563  40.880  1.00  0.00           H  
ATOM    506  N   VAL A  33      42.312  38.929  36.561  1.00  0.00           N  
ATOM    507  CA  VAL A  33      42.970  40.183  36.107  1.00  0.00           C  
ATOM    508  C   VAL A  33      42.074  41.407  36.346  1.00  0.00           C  
ATOM    509  O   VAL A  33      41.278  41.770  35.502  1.00  0.00           O  
ATOM    510  CB  VAL A  33      43.297  40.072  34.615  1.00  0.00           C  
ATOM    511  CG1 VAL A  33      44.395  41.079  34.253  1.00  0.00           C  
ATOM    512  CG2 VAL A  33      43.789  38.657  34.304  1.00  0.00           C  
ATOM    513  H   VAL A  33      42.131  38.211  35.923  1.00  0.00           H  
ATOM    514  HA  VAL A  33      43.886  40.303  36.651  1.00  0.00           H  
ATOM    515  HB  VAL A  33      42.409  40.285  34.035  1.00  0.00           H  
ATOM    516 HG11 VAL A  33      45.352  40.699  34.573  1.00  0.00           H  
ATOM    517 HG12 VAL A  33      44.203  42.017  34.748  1.00  0.00           H  
ATOM    518 HG13 VAL A  33      44.408  41.230  33.183  1.00  0.00           H  
ATOM    519 HG21 VAL A  33      44.508  38.355  35.052  1.00  0.00           H  
ATOM    520 HG22 VAL A  33      44.255  38.643  33.330  1.00  0.00           H  
ATOM    521 HG23 VAL A  33      42.953  37.977  34.313  1.00  0.00           H  
ATOM    522  N   ILE A  34      42.210  42.063  37.472  1.00  0.00           N  
ATOM    523  CA  ILE A  34      41.366  43.277  37.723  1.00  0.00           C  
ATOM    524  C   ILE A  34      41.626  44.341  36.639  1.00  0.00           C  
ATOM    525  O   ILE A  34      40.707  44.890  36.067  1.00  0.00           O  
ATOM    526  CB  ILE A  34      41.693  43.911  39.089  1.00  0.00           C  
ATOM    527  CG1 ILE A  34      41.244  42.981  40.225  1.00  0.00           C  
ATOM    528  CG2 ILE A  34      40.960  45.264  39.207  1.00  0.00           C  
ATOM    529  CD1 ILE A  34      41.693  43.543  41.587  1.00  0.00           C  
ATOM    530  H   ILE A  34      42.862  41.758  38.149  1.00  0.00           H  
ATOM    531  HA  ILE A  34      40.323  42.997  37.701  1.00  0.00           H  
ATOM    532  HB  ILE A  34      42.760  44.082  39.157  1.00  0.00           H  
ATOM    533 HG12 ILE A  34      40.170  42.892  40.208  1.00  0.00           H  
ATOM    534 HG13 ILE A  34      41.685  42.006  40.081  1.00  0.00           H  
ATOM    535 HG21 ILE A  34      41.487  46.008  38.628  1.00  0.00           H  
ATOM    536 HG22 ILE A  34      40.926  45.576  40.239  1.00  0.00           H  
ATOM    537 HG23 ILE A  34      39.954  45.161  38.829  1.00  0.00           H  
ATOM    538 HD11 ILE A  34      41.650  44.623  41.575  1.00  0.00           H  
ATOM    539 HD12 ILE A  34      42.704  43.233  41.791  1.00  0.00           H  
ATOM    540 HD13 ILE A  34      41.037  43.174  42.360  1.00  0.00           H  
ATOM    541  N   GLU A  35      42.872  44.666  36.382  1.00  0.00           N  
ATOM    542  CA  GLU A  35      43.177  45.729  35.373  1.00  0.00           C  
ATOM    543  C   GLU A  35      44.477  45.431  34.656  1.00  0.00           C  
ATOM    544  O   GLU A  35      45.314  44.688  35.128  1.00  0.00           O  
ATOM    545  CB  GLU A  35      43.289  47.087  36.088  1.00  0.00           C  
ATOM    546  CG  GLU A  35      43.034  48.228  35.095  1.00  0.00           C  
ATOM    547  CD  GLU A  35      41.533  48.335  34.812  1.00  0.00           C  
ATOM    548  OE1 GLU A  35      40.773  48.390  35.765  1.00  0.00           O  
ATOM    549  OE2 GLU A  35      41.170  48.360  33.648  1.00  0.00           O  
ATOM    550  H   GLU A  35      43.597  44.232  36.869  1.00  0.00           H  
ATOM    551  HA  GLU A  35      42.394  45.763  34.635  1.00  0.00           H  
ATOM    552  HB2 GLU A  35      42.556  47.133  36.882  1.00  0.00           H  
ATOM    553  HB3 GLU A  35      44.286  47.196  36.512  1.00  0.00           H  
ATOM    554  HG2 GLU A  35      43.389  49.156  35.515  1.00  0.00           H  
ATOM    555  HG3 GLU A  35      43.557  48.027  34.172  1.00  0.00           H  
ATOM    556  N   LYS A  36      44.628  45.996  33.483  1.00  0.00           N  
ATOM    557  CA  LYS A  36      45.849  45.745  32.672  1.00  0.00           C  
ATOM    558  C   LYS A  36      46.393  47.061  32.082  1.00  0.00           C  
ATOM    559  O   LYS A  36      46.421  47.222  30.879  1.00  0.00           O  
ATOM    560  CB  LYS A  36      45.451  44.797  31.520  1.00  0.00           C  
ATOM    561  CG  LYS A  36      44.434  43.738  32.014  1.00  0.00           C  
ATOM    562  CD  LYS A  36      42.988  44.214  31.789  1.00  0.00           C  
ATOM    563  CE  LYS A  36      42.019  43.362  32.628  1.00  0.00           C  
ATOM    564  NZ  LYS A  36      42.392  43.415  34.069  1.00  0.00           N  
ATOM    565  H   LYS A  36      43.920  46.569  33.126  1.00  0.00           H  
ATOM    566  HA  LYS A  36      46.614  45.275  33.273  1.00  0.00           H  
ATOM    567  HB2 LYS A  36      45.010  45.368  30.712  1.00  0.00           H  
ATOM    568  HB3 LYS A  36      46.336  44.299  31.153  1.00  0.00           H  
ATOM    569  HG2 LYS A  36      44.586  42.816  31.471  1.00  0.00           H  
ATOM    570  HG3 LYS A  36      44.583  43.555  33.061  1.00  0.00           H  
ATOM    571  HD2 LYS A  36      42.896  45.251  32.076  1.00  0.00           H  
ATOM    572  HD3 LYS A  36      42.737  44.111  30.745  1.00  0.00           H  
ATOM    573  HE2 LYS A  36      41.020  43.748  32.518  1.00  0.00           H  
ATOM    574  HE3 LYS A  36      42.052  42.338  32.286  1.00  0.00           H  
ATOM    575  HZ1 LYS A  36      41.659  43.933  34.597  1.00  0.00           H  
ATOM    576  HZ2 LYS A  36      43.299  43.898  34.174  1.00  0.00           H  
ATOM    577  HZ3 LYS A  36      42.466  42.448  34.441  1.00  0.00           H  
ATOM    578  N   PRO A  37      46.850  47.956  32.935  1.00  0.00           N  
ATOM    579  CA  PRO A  37      47.434  49.224  32.483  1.00  0.00           C  
ATOM    580  C   PRO A  37      48.824  48.959  31.921  1.00  0.00           C  
ATOM    581  O   PRO A  37      49.410  47.917  32.135  1.00  0.00           O  
ATOM    582  CB  PRO A  37      47.532  50.100  33.740  1.00  0.00           C  
ATOM    583  CG  PRO A  37      47.324  49.158  34.950  1.00  0.00           C  
ATOM    584  CD  PRO A  37      46.809  47.802  34.404  1.00  0.00           C  
ATOM    585  HA  PRO A  37      46.803  49.695  31.741  1.00  0.00           H  
ATOM    586  HB2 PRO A  37      48.501  50.584  33.799  1.00  0.00           H  
ATOM    587  HB3 PRO A  37      46.751  50.851  33.728  1.00  0.00           H  
ATOM    588  HG2 PRO A  37      48.262  49.019  35.475  1.00  0.00           H  
ATOM    589  HG3 PRO A  37      46.601  49.585  35.607  1.00  0.00           H  
ATOM    590  HD2 PRO A  37      47.455  46.993  34.719  1.00  0.00           H  
ATOM    591  HD3 PRO A  37      45.800  47.631  34.731  1.00  0.00           H  
ATOM    592  N   GLU A  38      49.354  49.903  31.221  1.00  0.00           N  
ATOM    593  CA  GLU A  38      50.725  49.733  30.651  1.00  0.00           C  
ATOM    594  C   GLU A  38      51.732  50.298  31.653  1.00  0.00           C  
ATOM    595  O   GLU A  38      52.718  49.666  31.964  1.00  0.00           O  
ATOM    596  CB  GLU A  38      50.824  50.498  29.326  1.00  0.00           C  
ATOM    597  CG  GLU A  38      52.123  50.130  28.593  1.00  0.00           C  
ATOM    598  CD  GLU A  38      53.310  50.885  29.201  1.00  0.00           C  
ATOM    599  OE1 GLU A  38      53.082  51.795  29.980  1.00  0.00           O  
ATOM    600  OE2 GLU A  38      54.431  50.539  28.871  1.00  0.00           O  
ATOM    601  H   GLU A  38      48.858  50.736  31.091  1.00  0.00           H  
ATOM    602  HA  GLU A  38      50.925  48.683  30.484  1.00  0.00           H  
ATOM    603  HB2 GLU A  38      49.978  50.242  28.702  1.00  0.00           H  
ATOM    604  HB3 GLU A  38      50.812  51.559  29.521  1.00  0.00           H  
ATOM    605  HG2 GLU A  38      52.298  49.067  28.675  1.00  0.00           H  
ATOM    606  HG3 GLU A  38      52.033  50.397  27.551  1.00  0.00           H  
ATOM    607  N   ASN A  39      51.454  51.473  32.165  1.00  0.00           N  
ATOM    608  CA  ASN A  39      52.341  52.137  33.171  1.00  0.00           C  
ATOM    609  C   ASN A  39      53.748  52.307  32.596  1.00  0.00           C  
ATOM    610  O   ASN A  39      54.244  53.405  32.451  1.00  0.00           O  
ATOM    611  CB  ASN A  39      52.395  51.291  34.454  1.00  0.00           C  
ATOM    612  CG  ASN A  39      51.137  51.543  35.290  1.00  0.00           C  
ATOM    613  OD1 ASN A  39      50.288  52.328  34.915  1.00  0.00           O  
ATOM    614  ND2 ASN A  39      50.979  50.901  36.416  1.00  0.00           N  
ATOM    615  H   ASN A  39      50.644  51.923  31.890  1.00  0.00           H  
ATOM    616  HA  ASN A  39      51.941  53.114  33.403  1.00  0.00           H  
ATOM    617  HB2 ASN A  39      52.447  50.246  34.195  1.00  0.00           H  
ATOM    618  HB3 ASN A  39      53.266  51.566  35.032  1.00  0.00           H  
ATOM    619 HD21 ASN A  39      51.663  50.268  36.720  1.00  0.00           H  
ATOM    620 HD22 ASN A  39      50.178  51.054  36.960  1.00  0.00           H  
ATOM    621  N   ASP A  40      54.364  51.220  32.239  1.00  0.00           N  
ATOM    622  CA  ASP A  40      55.731  51.257  31.639  1.00  0.00           C  
ATOM    623  C   ASP A  40      56.409  49.861  31.616  1.00  0.00           C  
ATOM    624  O   ASP A  40      56.955  49.473  30.602  1.00  0.00           O  
ATOM    625  CB  ASP A  40      56.650  52.320  32.327  1.00  0.00           C  
ATOM    626  CG  ASP A  40      56.818  53.549  31.418  1.00  0.00           C  
ATOM    627  OD1 ASP A  40      55.871  53.883  30.727  1.00  0.00           O  
ATOM    628  OD2 ASP A  40      57.889  54.130  31.434  1.00  0.00           O  
ATOM    629  H   ASP A  40      53.895  50.367  32.333  1.00  0.00           H  
ATOM    630  HA  ASP A  40      55.589  51.513  30.665  1.00  0.00           H  
ATOM    631  HB2 ASP A  40      56.220  52.639  33.261  1.00  0.00           H  
ATOM    632  HB3 ASP A  40      57.626  51.892  32.517  1.00  0.00           H  
ATOM    633  N   PRO A  41      56.366  49.165  32.710  1.00  0.00           N  
ATOM    634  CA  PRO A  41      56.981  47.831  32.827  1.00  0.00           C  
ATOM    635  C   PRO A  41      56.209  46.822  31.967  1.00  0.00           C  
ATOM    636  O   PRO A  41      56.774  46.226  31.076  1.00  0.00           O  
ATOM    637  CB  PRO A  41      56.867  47.484  34.331  1.00  0.00           C  
ATOM    638  CG  PRO A  41      56.064  48.633  35.008  1.00  0.00           C  
ATOM    639  CD  PRO A  41      55.709  49.650  33.905  1.00  0.00           C  
ATOM    640  HA  PRO A  41      58.017  47.867  32.531  1.00  0.00           H  
ATOM    641  HB2 PRO A  41      56.349  46.543  34.463  1.00  0.00           H  
ATOM    642  HB3 PRO A  41      57.853  47.421  34.774  1.00  0.00           H  
ATOM    643  HG2 PRO A  41      55.161  48.238  35.460  1.00  0.00           H  
ATOM    644  HG3 PRO A  41      56.669  49.112  35.767  1.00  0.00           H  
ATOM    645  HD2 PRO A  41      54.657  49.681  33.733  1.00  0.00           H  
ATOM    646  HD3 PRO A  41      56.070  50.628  34.134  1.00  0.00           H  
ATOM    647  N   GLU A  42      54.926  46.656  32.260  1.00  0.00           N  
ATOM    648  CA  GLU A  42      54.009  45.701  31.521  1.00  0.00           C  
ATOM    649  C   GLU A  42      53.232  44.860  32.555  1.00  0.00           C  
ATOM    650  O   GLU A  42      52.551  43.914  32.220  1.00  0.00           O  
ATOM    651  CB  GLU A  42      54.783  44.762  30.569  1.00  0.00           C  
ATOM    652  CG  GLU A  42      55.091  45.475  29.237  1.00  0.00           C  
ATOM    653  CD  GLU A  42      53.789  45.776  28.487  1.00  0.00           C  
ATOM    654  OE1 GLU A  42      52.754  45.304  28.927  1.00  0.00           O  
ATOM    655  OE2 GLU A  42      53.850  46.471  27.486  1.00  0.00           O  
ATOM    656  H   GLU A  42      54.553  47.185  32.993  1.00  0.00           H  
ATOM    657  HA  GLU A  42      53.299  46.283  30.948  1.00  0.00           H  
ATOM    658  HB2 GLU A  42      55.714  44.475  31.038  1.00  0.00           H  
ATOM    659  HB3 GLU A  42      54.189  43.881  30.368  1.00  0.00           H  
ATOM    660  HG2 GLU A  42      55.605  46.405  29.437  1.00  0.00           H  
ATOM    661  HG3 GLU A  42      55.716  44.842  28.623  1.00  0.00           H  
ATOM    662  N   TRP A  43      53.325  45.203  33.816  1.00 14.29           N  
ATOM    663  CA  TRP A  43      52.598  44.424  34.867  1.00 10.30           C  
ATOM    664  C   TRP A  43      51.088  44.691  34.785  1.00  6.82           C  
ATOM    665  O   TRP A  43      50.648  45.614  34.131  1.00  6.91           O  
ATOM    666  CB  TRP A  43      53.114  44.826  36.244  1.00 13.39           C  
ATOM    667  CG  TRP A  43      54.608  44.859  36.251  1.00 11.71           C  
ATOM    668  CD1 TRP A  43      55.408  44.276  35.329  1.00 13.93           C  
ATOM    669  CD2 TRP A  43      55.494  45.489  37.220  1.00  7.44           C  
ATOM    670  NE1 TRP A  43      56.722  44.509  35.669  1.00  6.63           N  
ATOM    671  CE2 TRP A  43      56.830  45.253  36.824  1.00  8.43           C  
ATOM    672  CE3 TRP A  43      55.274  46.237  38.389  1.00  6.37           C  
ATOM    673  CZ2 TRP A  43      57.906  45.735  37.556  1.00 11.15           C  
ATOM    674  CZ3 TRP A  43      56.360  46.726  39.134  1.00  2.36           C  
ATOM    675  CH2 TRP A  43      57.675  46.476  38.717  1.00  8.17           C  
ATOM    676  H   TRP A  43      53.872  45.970  34.076  1.00  0.00           H  
ATOM    677  HA  TRP A  43      52.774  43.368  34.719  1.00  0.00           H  
ATOM    678  HB2 TRP A  43      52.736  45.803  36.502  1.00  0.00           H  
ATOM    679  HB3 TRP A  43      52.776  44.103  36.964  1.00  0.00           H  
ATOM    680  HD1 TRP A  43      55.078  43.720  34.470  1.00  0.00           H  
ATOM    681  HE1 TRP A  43      57.498  44.197  35.165  1.00  0.00           H  
ATOM    682  HE3 TRP A  43      54.263  46.434  38.718  1.00  0.00           H  
ATOM    683  HZ2 TRP A  43      58.912  45.536  37.227  1.00  0.00           H  
ATOM    684  HZ3 TRP A  43      56.181  47.301  40.033  1.00  0.00           H  
ATOM    685  HH2 TRP A  43      58.507  46.856  39.291  1.00  0.00           H  
ATOM    686  N   TRP A  44      50.300  43.871  35.445  1.00  6.17           N  
ATOM    687  CA  TRP A  44      48.806  44.027  35.419  1.00  5.58           C  
ATOM    688  C   TRP A  44      48.273  44.013  36.856  1.00  6.91           C  
ATOM    689  O   TRP A  44      48.743  43.263  37.688  1.00  8.86           O  
ATOM    690  CB  TRP A  44      48.184  42.799  34.710  1.00  2.99           C  
ATOM    691  CG  TRP A  44      48.210  42.873  33.203  1.00  7.04           C  
ATOM    692  CD1 TRP A  44      48.607  43.918  32.429  1.00  5.83           C  
ATOM    693  CD2 TRP A  44      47.789  41.829  32.273  1.00  5.23           C  
ATOM    694  NE1 TRP A  44      48.461  43.567  31.097  1.00  4.61           N  
ATOM    695  CE2 TRP A  44      47.959  42.295  30.952  1.00  9.27           C  
ATOM    696  CE3 TRP A  44      47.282  40.527  32.453  1.00  6.86           C  
ATOM    697  CZ2 TRP A  44      47.637  41.504  29.847  1.00 11.14           C  
ATOM    698  CZ3 TRP A  44      46.956  39.729  31.345  1.00 11.80           C  
ATOM    699  CH2 TRP A  44      47.133  40.218  30.043  1.00 11.72           C  
ATOM    700  H   TRP A  44      50.696  43.138  35.967  1.00  0.00           H  
ATOM    701  HA  TRP A  44      48.511  44.937  34.930  1.00  0.00           H  
ATOM    702  HB2 TRP A  44      48.728  41.920  35.012  1.00  0.00           H  
ATOM    703  HB3 TRP A  44      47.157  42.691  35.034  1.00  0.00           H  
ATOM    704  HD1 TRP A  44      48.980  44.861  32.777  1.00  0.00           H  
ATOM    705  HE1 TRP A  44      48.678  44.137  30.337  1.00  0.00           H  
ATOM    706  HE3 TRP A  44      47.144  40.140  33.450  1.00  0.00           H  
ATOM    707  HZ2 TRP A  44      47.773  41.889  28.845  1.00  0.00           H  
ATOM    708  HZ3 TRP A  44      46.567  38.733  31.496  1.00  0.00           H  
ATOM    709  HH2 TRP A  44      46.882  39.599  29.195  1.00  0.00           H  
ATOM    710  N   LYS A  45      47.241  44.769  37.146  1.00  0.00           N  
ATOM    711  CA  LYS A  45      46.663  44.689  38.511  1.00  0.00           C  
ATOM    712  C   LYS A  45      45.811  43.439  38.511  1.00  0.00           C  
ATOM    713  O   LYS A  45      44.690  43.459  38.047  1.00  0.00           O  
ATOM    714  CB  LYS A  45      45.758  45.886  38.827  1.00  0.00           C  
ATOM    715  CG  LYS A  45      45.317  45.816  40.321  1.00  0.00           C  
ATOM    716  CD  LYS A  45      44.453  47.046  40.681  1.00  0.00           C  
ATOM    717  CE  LYS A  45      44.033  46.983  42.154  1.00  0.00           C  
ATOM    718  NZ  LYS A  45      43.220  48.185  42.491  1.00  0.00           N  
ATOM    719  H   LYS A  45      46.822  45.329  36.459  1.00  0.00           H  
ATOM    720  HA  LYS A  45      47.448  44.603  39.248  1.00  0.00           H  
ATOM    721  HB2 LYS A  45      46.294  46.807  38.636  1.00  0.00           H  
ATOM    722  HB3 LYS A  45      44.877  45.853  38.198  1.00  0.00           H  
ATOM    723  HG2 LYS A  45      44.745  44.910  40.480  1.00  0.00           H  
ATOM    724  HG3 LYS A  45      46.199  45.793  40.972  1.00  0.00           H  
ATOM    725  HD2 LYS A  45      45.022  47.948  40.510  1.00  0.00           H  
ATOM    726  HD3 LYS A  45      43.568  47.059  40.063  1.00  0.00           H  
ATOM    727  HE2 LYS A  45      43.445  46.093  42.324  1.00  0.00           H  
ATOM    728  HE3 LYS A  45      44.915  46.959  42.780  1.00  0.00           H  
ATOM    729  HZ1 LYS A  45      42.831  48.595  41.619  1.00  0.00           H  
ATOM    730  HZ2 LYS A  45      43.819  48.890  42.968  1.00  0.00           H  
ATOM    731  HZ3 LYS A  45      42.438  47.913  43.119  1.00  0.00           H  
ATOM    732  N   CYS A  46      46.331  42.346  38.984  1.00  0.00           N  
ATOM    733  CA  CYS A  46      45.541  41.082  38.966  1.00  0.00           C  
ATOM    734  C   CYS A  46      45.271  40.613  40.374  1.00  0.00           C  
ATOM    735  O   CYS A  46      46.164  40.467  41.187  1.00  0.00           O  
ATOM    736  CB  CYS A  46      46.325  40.005  38.211  1.00  0.00           C  
ATOM    737  SG  CYS A  46      47.702  39.425  39.233  1.00  0.00           S  
ATOM    738  H   CYS A  46      47.247  42.348  39.327  1.00  0.00           H  
ATOM    739  HA  CYS A  46      44.593  41.240  38.478  1.00  0.00           H  
ATOM    740  HB2 CYS A  46      45.668  39.178  37.985  1.00  0.00           H  
ATOM    741  HB3 CYS A  46      46.709  40.423  37.292  1.00  0.00           H  
ATOM    742  HG  CYS A  46      47.349  38.825  39.895  1.00  0.00           H  
ATOM    743  N   LYS A  47      44.037  40.340  40.660  1.00  0.00           N  
ATOM    744  CA  LYS A  47      43.694  39.838  42.000  1.00  0.00           C  
ATOM    745  C   LYS A  47      43.967  38.348  41.983  1.00  0.00           C  
ATOM    746  O   LYS A  47      43.844  37.731  40.946  1.00  0.00           O  
ATOM    747  CB  LYS A  47      42.209  40.079  42.273  1.00  0.00           C  
ATOM    748  CG  LYS A  47      41.750  39.271  43.494  1.00  0.00           C  
ATOM    749  CD  LYS A  47      40.399  39.796  43.983  1.00  0.00           C  
ATOM    750  CE  LYS A  47      39.986  39.041  45.245  1.00  0.00           C  
ATOM    751  NZ  LYS A  47      38.819  39.719  45.874  1.00  0.00           N  
ATOM    752  H   LYS A  47      43.340  40.442  39.979  1.00  0.00           H  
ATOM    753  HA  LYS A  47      44.285  40.329  42.732  1.00  0.00           H  
ATOM    754  HB2 LYS A  47      42.053  41.125  42.467  1.00  0.00           H  
ATOM    755  HB3 LYS A  47      41.634  39.780  41.408  1.00  0.00           H  
ATOM    756  HG2 LYS A  47      41.658  38.231  43.220  1.00  0.00           H  
ATOM    757  HG3 LYS A  47      42.473  39.370  44.283  1.00  0.00           H  
ATOM    758  HD2 LYS A  47      40.481  40.851  44.201  1.00  0.00           H  
ATOM    759  HD3 LYS A  47      39.656  39.646  43.216  1.00  0.00           H  
ATOM    760  HE2 LYS A  47      39.719  38.028  44.989  1.00  0.00           H  
ATOM    761  HE3 LYS A  47      40.811  39.031  45.940  1.00  0.00           H  
ATOM    762  HZ1 LYS A  47      37.953  39.178  45.675  1.00  0.00           H  
ATOM    763  HZ2 LYS A  47      38.723  40.679  45.485  1.00  0.00           H  
ATOM    764  HZ3 LYS A  47      38.961  39.773  46.903  1.00  0.00           H  
ATOM    765  N   ASN A  48      44.320  37.728  43.088  1.00  0.00           N  
ATOM    766  CA  ASN A  48      44.530  36.237  43.007  1.00  0.00           C  
ATOM    767  C   ASN A  48      43.234  35.571  43.466  1.00  0.00           C  
ATOM    768  O   ASN A  48      42.699  35.934  44.486  1.00  0.00           O  
ATOM    769  CB  ASN A  48      45.780  35.771  43.803  1.00  0.00           C  
ATOM    770  CG  ASN A  48      45.614  35.741  45.333  1.00  0.00           C  
ATOM    771  OD1 ASN A  48      46.590  35.872  46.038  1.00  0.00           O  
ATOM    772  ND2 ASN A  48      44.463  35.518  45.889  1.00  0.00           N  
ATOM    773  H   ASN A  48      44.422  38.243  43.972  1.00  0.00           H  
ATOM    774  HA  ASN A  48      44.686  35.962  41.978  1.00  0.00           H  
ATOM    775  HB2 ASN A  48      46.033  34.777  43.480  1.00  0.00           H  
ATOM    776  HB3 ASN A  48      46.602  36.429  43.558  1.00  0.00           H  
ATOM    777 HD21 ASN A  48      43.673  35.360  45.344  1.00  0.00           H  
ATOM    778 HD22 ASN A  48      44.389  35.511  46.867  1.00  0.00           H  
ATOM    779  N   ALA A  49      42.659  34.639  42.717  1.00  0.00           N  
ATOM    780  CA  ALA A  49      41.378  34.055  43.199  1.00  0.00           C  
ATOM    781  C   ALA A  49      41.583  33.596  44.638  1.00  0.00           C  
ATOM    782  O   ALA A  49      40.643  33.428  45.390  1.00  0.00           O  
ATOM    783  CB  ALA A  49      40.970  32.867  42.330  1.00  0.00           C  
ATOM    784  H   ALA A  49      43.036  34.356  41.848  1.00  0.00           H  
ATOM    785  HA  ALA A  49      40.608  34.821  43.168  1.00  0.00           H  
ATOM    786  HB1 ALA A  49      40.909  33.178  41.298  1.00  0.00           H  
ATOM    787  HB2 ALA A  49      40.008  32.500  42.652  1.00  0.00           H  
ATOM    788  HB3 ALA A  49      41.705  32.083  42.429  1.00  0.00           H  
ATOM    789  N   ARG A  50      42.820  33.437  45.039  1.00  0.00           N  
ATOM    790  CA  ARG A  50      43.087  33.039  46.443  1.00  0.00           C  
ATOM    791  C   ARG A  50      42.598  34.193  47.313  1.00  0.00           C  
ATOM    792  O   ARG A  50      42.561  34.120  48.526  1.00  0.00           O  
ATOM    793  CB  ARG A  50      44.596  32.758  46.638  1.00  0.00           C  
ATOM    794  CG  ARG A  50      44.868  31.235  46.577  1.00  0.00           C  
ATOM    795  CD  ARG A  50      46.365  30.929  46.285  1.00  0.00           C  
ATOM    796  NE  ARG A  50      46.933  30.001  47.326  1.00  0.00           N  
ATOM    797  CZ  ARG A  50      46.835  30.254  48.607  1.00  0.00           C  
ATOM    798  NH1 ARG A  50      46.310  31.369  49.024  1.00  0.00           N  
ATOM    799  NH2 ARG A  50      47.294  29.392  49.474  1.00  0.00           N  
ATOM    800  H   ARG A  50      43.565  33.608  44.425  1.00  0.00           H  
ATOM    801  HA  ARG A  50      42.511  32.171  46.673  1.00  0.00           H  
ATOM    802  HB2 ARG A  50      45.148  33.246  45.850  1.00  0.00           H  
ATOM    803  HB3 ARG A  50      44.919  33.143  47.592  1.00  0.00           H  
ATOM    804  HG2 ARG A  50      44.579  30.784  47.511  1.00  0.00           H  
ATOM    805  HG3 ARG A  50      44.261  30.811  45.785  1.00  0.00           H  
ATOM    806  HD2 ARG A  50      46.447  30.424  45.339  1.00  0.00           H  
ATOM    807  HD3 ARG A  50      46.935  31.852  46.235  1.00  0.00           H  
ATOM    808  HE  ARG A  50      47.371  29.173  47.038  1.00  0.00           H  
ATOM    809 HH11 ARG A  50      45.981  32.039  48.363  1.00  0.00           H  
ATOM    810 HH12 ARG A  50      46.238  31.556  50.004  1.00  0.00           H  
ATOM    811 HH21 ARG A  50      47.719  28.542  49.159  1.00  0.00           H  
ATOM    812 HH22 ARG A  50      47.224  29.582  50.451  1.00  0.00           H  
ATOM    813  N   GLY A  51      42.173  35.244  46.665  1.00  8.07           N  
ATOM    814  CA  GLY A  51      41.616  36.425  47.365  1.00  7.79           C  
ATOM    815  C   GLY A  51      42.684  37.497  47.638  1.00  9.08           C  
ATOM    816  O   GLY A  51      42.613  38.182  48.638  1.00 14.41           O  
ATOM    817  H   GLY A  51      42.193  35.239  45.686  1.00  0.00           H  
ATOM    818  HA2 GLY A  51      40.843  36.846  46.736  1.00  0.00           H  
ATOM    819  HA3 GLY A  51      41.178  36.115  48.302  1.00  0.00           H  
ATOM    820  N   GLN A  52      43.667  37.677  46.769  1.00  0.00           N  
ATOM    821  CA  GLN A  52      44.703  38.753  47.040  1.00  0.00           C  
ATOM    822  C   GLN A  52      45.052  39.532  45.776  1.00  0.00           C  
ATOM    823  O   GLN A  52      44.729  39.138  44.696  1.00  0.00           O  
ATOM    824  CB  GLN A  52      45.949  38.133  47.737  1.00  0.00           C  
ATOM    825  CG  GLN A  52      47.248  38.395  46.952  1.00  0.00           C  
ATOM    826  CD  GLN A  52      48.393  37.636  47.591  1.00  0.00           C  
ATOM    827  OE1 GLN A  52      48.371  36.424  47.683  1.00  0.00           O  
ATOM    828  NE2 GLN A  52      49.407  38.311  48.040  1.00  0.00           N  
ATOM    829  H   GLN A  52      43.718  37.126  45.959  1.00  0.00           H  
ATOM    830  HA  GLN A  52      44.264  39.463  47.679  1.00  0.00           H  
ATOM    831  HB2 GLN A  52      46.054  38.555  48.726  1.00  0.00           H  
ATOM    832  HB3 GLN A  52      45.802  37.069  47.833  1.00  0.00           H  
ATOM    833  HG2 GLN A  52      47.132  38.080  45.928  1.00  0.00           H  
ATOM    834  HG3 GLN A  52      47.481  39.448  46.981  1.00  0.00           H  
ATOM    835 HE21 GLN A  52      49.419  39.289  47.961  1.00  0.00           H  
ATOM    836 HE22 GLN A  52      50.150  37.852  48.451  1.00  0.00           H  
ATOM    837  N   VAL A  53      45.681  40.685  45.924  1.00  0.00           N  
ATOM    838  CA  VAL A  53      46.005  41.519  44.720  1.00  0.00           C  
ATOM    839  C   VAL A  53      47.450  42.018  44.727  1.00  0.00           C  
ATOM    840  O   VAL A  53      48.081  42.165  45.753  1.00  0.00           O  
ATOM    841  CB  VAL A  53      45.066  42.735  44.679  1.00  0.00           C  
ATOM    842  CG1 VAL A  53      45.056  43.340  43.274  1.00  0.00           C  
ATOM    843  CG2 VAL A  53      43.644  42.320  45.071  1.00  0.00           C  
ATOM    844  H   VAL A  53      45.908  41.007  46.821  1.00  0.00           H  
ATOM    845  HA  VAL A  53      45.867  40.930  43.837  1.00  0.00           H  
ATOM    846  HB  VAL A  53      45.419  43.480  45.377  1.00  0.00           H  
ATOM    847 HG11 VAL A  53      46.032  43.750  43.053  1.00  0.00           H  
ATOM    848 HG12 VAL A  53      44.318  44.129  43.228  1.00  0.00           H  
ATOM    849 HG13 VAL A  53      44.814  42.579  42.552  1.00  0.00           H  
ATOM    850 HG21 VAL A  53      43.644  41.944  46.085  1.00  0.00           H  
ATOM    851 HG22 VAL A  53      43.293  41.553  44.404  1.00  0.00           H  
ATOM    852 HG23 VAL A  53      42.991  43.176  45.009  1.00  0.00           H  
ATOM    853  N   GLY A  54      47.954  42.283  43.548  1.00  3.62           N  
ATOM    854  CA  GLY A  54      49.351  42.784  43.394  1.00  3.70           C  
ATOM    855  C   GLY A  54      49.717  42.813  41.903  1.00  4.69           C  
ATOM    856  O   GLY A  54      49.149  42.096  41.102  1.00  7.25           O  
ATOM    857  H   GLY A  54      47.399  42.147  42.749  1.00  0.00           H  
ATOM    858  HA2 GLY A  54      49.417  43.782  43.801  1.00  0.00           H  
ATOM    859  HA3 GLY A  54      50.039  42.125  43.916  1.00  0.00           H  
ATOM    860  N   LEU A  55      50.669  43.623  41.532  1.00  0.00           N  
ATOM    861  CA  LEU A  55      51.089  43.691  40.098  1.00  0.00           C  
ATOM    862  C   LEU A  55      51.863  42.412  39.752  1.00  0.00           C  
ATOM    863  O   LEU A  55      52.487  41.809  40.602  1.00  0.00           O  
ATOM    864  CB  LEU A  55      51.988  44.930  39.911  1.00  0.00           C  
ATOM    865  CG  LEU A  55      51.136  46.166  39.566  1.00  0.00           C  
ATOM    866  CD1 LEU A  55      50.442  46.001  38.189  1.00  0.00           C  
ATOM    867  CD2 LEU A  55      50.089  46.371  40.669  1.00  0.00           C  
ATOM    868  H   LEU A  55      51.120  44.184  42.196  1.00  0.00           H  
ATOM    869  HA  LEU A  55      50.219  43.761  39.458  1.00  0.00           H  
ATOM    870  HB2 LEU A  55      52.523  45.115  40.831  1.00  0.00           H  
ATOM    871  HB3 LEU A  55      52.698  44.756  39.121  1.00  0.00           H  
ATOM    872  HG  LEU A  55      51.782  47.031  39.529  1.00  0.00           H  
ATOM    873 HD11 LEU A  55      49.373  45.881  38.318  1.00  0.00           H  
ATOM    874 HD12 LEU A  55      50.831  45.132  37.677  1.00  0.00           H  
ATOM    875 HD13 LEU A  55      50.631  46.879  37.590  1.00  0.00           H  
ATOM    876 HD21 LEU A  55      49.317  45.623  40.575  1.00  0.00           H  
ATOM    877 HD22 LEU A  55      49.652  47.355  40.569  1.00  0.00           H  
ATOM    878 HD23 LEU A  55      50.562  46.282  41.636  1.00  0.00           H  
ATOM    879  N   VAL A  56      51.823  41.977  38.515  1.00  0.00           N  
ATOM    880  CA  VAL A  56      52.550  40.726  38.140  1.00  0.00           C  
ATOM    881  C   VAL A  56      52.862  40.749  36.623  1.00  0.00           C  
ATOM    882  O   VAL A  56      51.993  41.099  35.850  1.00  0.00           O  
ATOM    883  CB  VAL A  56      51.638  39.523  38.472  1.00  0.00           C  
ATOM    884  CG1 VAL A  56      50.544  39.362  37.407  1.00  0.00           C  
ATOM    885  CG2 VAL A  56      52.461  38.240  38.536  1.00  0.00           C  
ATOM    886  H   VAL A  56      51.303  42.468  37.835  1.00  0.00           H  
ATOM    887  HA  VAL A  56      53.454  40.660  38.718  1.00  0.00           H  
ATOM    888  HB  VAL A  56      51.172  39.694  39.432  1.00  0.00           H  
ATOM    889 HG11 VAL A  56      49.799  38.671  37.762  1.00  0.00           H  
ATOM    890 HG12 VAL A  56      50.981  38.979  36.496  1.00  0.00           H  
ATOM    891 HG13 VAL A  56      50.086  40.321  37.211  1.00  0.00           H  
ATOM    892 HG21 VAL A  56      51.834  37.430  38.879  1.00  0.00           H  
ATOM    893 HG22 VAL A  56      53.283  38.370  39.223  1.00  0.00           H  
ATOM    894 HG23 VAL A  56      52.842  38.004  37.553  1.00  0.00           H  
ATOM    895  N   PRO A  57      54.063  40.364  36.207  1.00  3.33           N  
ATOM    896  CA  PRO A  57      54.384  40.349  34.769  1.00  2.75           C  
ATOM    897  C   PRO A  57      53.287  39.578  34.022  1.00  4.32           C  
ATOM    898  O   PRO A  57      53.111  38.389  34.203  1.00  4.76           O  
ATOM    899  CB  PRO A  57      55.760  39.654  34.669  1.00  2.92           C  
ATOM    900  CG  PRO A  57      56.287  39.458  36.121  1.00  3.30           C  
ATOM    901  CD  PRO A  57      55.172  39.923  37.087  1.00  2.53           C  
ATOM    902  HA  PRO A  57      54.446  41.361  34.393  1.00  0.00           H  
ATOM    903  HB2 PRO A  57      55.662  38.694  34.177  1.00  0.00           H  
ATOM    904  HB3 PRO A  57      56.451  40.277  34.114  1.00  0.00           H  
ATOM    905  HG2 PRO A  57      56.516  38.412  36.292  1.00  0.00           H  
ATOM    906  HG3 PRO A  57      57.177  40.053  36.277  1.00  0.00           H  
ATOM    907  HD2 PRO A  57      54.860  39.106  37.716  1.00  0.00           H  
ATOM    908  HD3 PRO A  57      55.517  40.751  37.691  1.00  0.00           H  
ATOM    909  N   LYS A  58      52.540  40.258  33.202  1.00  0.00           N  
ATOM    910  CA  LYS A  58      51.433  39.596  32.457  1.00  0.00           C  
ATOM    911  C   LYS A  58      51.978  38.477  31.560  1.00  0.00           C  
ATOM    912  O   LYS A  58      51.241  37.847  30.831  1.00  0.00           O  
ATOM    913  CB  LYS A  58      50.716  40.652  31.607  1.00  0.00           C  
ATOM    914  CG  LYS A  58      51.630  41.148  30.452  1.00  0.00           C  
ATOM    915  CD  LYS A  58      50.911  42.224  29.612  1.00  0.00           C  
ATOM    916  CE  LYS A  58      51.824  42.702  28.477  1.00  0.00           C  
ATOM    917  NZ  LYS A  58      51.124  43.751  27.685  1.00  0.00           N  
ATOM    918  H   LYS A  58      52.693  41.219  33.089  1.00  0.00           H  
ATOM    919  HA  LYS A  58      50.732  39.174  33.161  1.00  0.00           H  
ATOM    920  HB2 LYS A  58      49.807  40.227  31.211  1.00  0.00           H  
ATOM    921  HB3 LYS A  58      50.464  41.489  32.246  1.00  0.00           H  
ATOM    922  HG2 LYS A  58      52.530  41.577  30.868  1.00  0.00           H  
ATOM    923  HG3 LYS A  58      51.902  40.318  29.814  1.00  0.00           H  
ATOM    924  HD2 LYS A  58      50.007  41.812  29.196  1.00  0.00           H  
ATOM    925  HD3 LYS A  58      50.662  43.064  30.244  1.00  0.00           H  
ATOM    926  HE2 LYS A  58      52.733  43.108  28.893  1.00  0.00           H  
ATOM    927  HE3 LYS A  58      52.065  41.866  27.834  1.00  0.00           H  
ATOM    928  HZ1 LYS A  58      51.748  44.578  27.580  1.00  0.00           H  
ATOM    929  HZ2 LYS A  58      50.253  44.034  28.180  1.00  0.00           H  
ATOM    930  HZ3 LYS A  58      50.885  43.376  26.746  1.00  0.00           H  
ATOM    931  N   ASN A  59      53.262  38.222  31.614  1.00 10.56           N  
ATOM    932  CA  ASN A  59      53.861  37.137  30.769  1.00  9.74           C  
ATOM    933  C   ASN A  59      54.107  35.895  31.636  1.00  9.95           C  
ATOM    934  O   ASN A  59      54.466  34.844  31.143  1.00  8.95           O  
ATOM    935  CB  ASN A  59      55.191  37.637  30.178  1.00 10.40           C  
ATOM    936  CG  ASN A  59      54.914  38.676  29.090  1.00 12.58           C  
ATOM    937  OD1 ASN A  59      53.809  38.769  28.590  1.00 14.84           O  
ATOM    938  ND2 ASN A  59      55.873  39.468  28.701  1.00 14.09           N  
ATOM    939  H   ASN A  59      53.836  38.742  32.214  1.00  0.00           H  
ATOM    940  HA  ASN A  59      53.186  36.881  29.962  1.00  0.00           H  
ATOM    941  HB2 ASN A  59      55.796  38.082  30.957  1.00  0.00           H  
ATOM    942  HB3 ASN A  59      55.726  36.803  29.744  1.00  0.00           H  
ATOM    943 HD21 ASN A  59      56.762  39.397  29.107  1.00  0.00           H  
ATOM    944 HD22 ASN A  59      55.704  40.137  28.003  1.00  0.00           H  
ATOM    945  N   TYR A  60      53.923  36.013  32.924  1.00 10.23           N  
ATOM    946  CA  TYR A  60      54.151  34.847  33.832  1.00  5.50           C  
ATOM    947  C   TYR A  60      52.852  34.038  33.963  1.00  5.21           C  
ATOM    948  O   TYR A  60      52.753  33.137  34.772  1.00  7.16           O  
ATOM    949  CB  TYR A  60      54.564  35.370  35.221  1.00  3.37           C  
ATOM    950  CG  TYR A  60      56.061  35.609  35.280  1.00  2.00           C  
ATOM    951  CD1 TYR A  60      56.727  36.205  34.204  1.00  4.04           C  
ATOM    952  CD2 TYR A  60      56.774  35.240  36.426  1.00  2.00           C  
ATOM    953  CE1 TYR A  60      58.106  36.431  34.274  1.00  4.04           C  
ATOM    954  CE2 TYR A  60      58.152  35.463  36.496  1.00  2.69           C  
ATOM    955  CZ  TYR A  60      58.821  36.060  35.420  1.00  4.45           C  
ATOM    956  OH  TYR A  60      60.180  36.282  35.488  1.00  9.52           O  
ATOM    957  H   TYR A  60      53.640  36.874  33.299  1.00  0.00           H  
ATOM    958  HA  TYR A  60      54.931  34.215  33.430  1.00  0.00           H  
ATOM    959  HB2 TYR A  60      54.054  36.302  35.411  1.00  0.00           H  
ATOM    960  HB3 TYR A  60      54.288  34.652  35.981  1.00  0.00           H  
ATOM    961  HD1 TYR A  60      56.180  36.492  33.320  1.00  0.00           H  
ATOM    962  HD2 TYR A  60      56.260  34.778  37.254  1.00  0.00           H  
ATOM    963  HE1 TYR A  60      58.619  36.890  33.443  1.00  0.00           H  
ATOM    964  HE2 TYR A  60      58.701  35.178  37.382  1.00  0.00           H  
ATOM    965  HH  TYR A  60      60.480  36.563  34.621  1.00  0.00           H  
ATOM    966  N   VAL A  61      51.854  34.355  33.181  1.00  5.00           N  
ATOM    967  CA  VAL A  61      50.559  33.612  33.270  1.00  4.84           C  
ATOM    968  C   VAL A  61      49.910  33.548  31.884  1.00  5.03           C  
ATOM    969  O   VAL A  61      50.167  34.377  31.032  1.00  5.61           O  
ATOM    970  CB  VAL A  61      49.618  34.347  34.240  1.00  6.97           C  
ATOM    971  CG1 VAL A  61      50.237  34.377  35.638  1.00  2.00           C  
ATOM    972  CG2 VAL A  61      49.397  35.788  33.763  1.00  2.97           C  
ATOM    973  H   VAL A  61      51.953  35.086  32.541  1.00  0.00           H  
ATOM    974  HA  VAL A  61      50.736  32.608  33.629  1.00  0.00           H  
ATOM    975  HB  VAL A  61      48.670  33.830  34.280  1.00  0.00           H  
ATOM    976 HG11 VAL A  61      50.916  33.546  35.755  1.00  0.00           H  
ATOM    977 HG12 VAL A  61      49.454  34.305  36.379  1.00  0.00           H  
ATOM    978 HG13 VAL A  61      50.775  35.304  35.776  1.00  0.00           H  
ATOM    979 HG21 VAL A  61      50.132  36.436  34.217  1.00  0.00           H  
ATOM    980 HG22 VAL A  61      48.407  36.114  34.048  1.00  0.00           H  
ATOM    981 HG23 VAL A  61      49.495  35.830  32.689  1.00  0.00           H  
ATOM    982  N   VAL A  62      49.056  32.579  31.660  1.00  0.00           N  
ATOM    983  CA  VAL A  62      48.364  32.468  30.330  1.00  0.00           C  
ATOM    984  C   VAL A  62      46.910  32.892  30.508  1.00  0.00           C  
ATOM    985  O   VAL A  62      46.406  32.908  31.601  1.00  0.00           O  
ATOM    986  CB  VAL A  62      48.404  31.020  29.837  1.00  0.00           C  
ATOM    987  CG1 VAL A  62      47.836  30.093  30.914  1.00  0.00           C  
ATOM    988  CG2 VAL A  62      47.568  30.887  28.565  1.00  0.00           C  
ATOM    989  H   VAL A  62      48.853  31.929  32.375  1.00  0.00           H  
ATOM    990  HA  VAL A  62      48.841  33.111  29.603  1.00  0.00           H  
ATOM    991  HB  VAL A  62      49.426  30.743  29.631  1.00  0.00           H  
ATOM    992 HG11 VAL A  62      47.339  30.682  31.669  1.00  0.00           H  
ATOM    993 HG12 VAL A  62      48.639  29.529  31.365  1.00  0.00           H  
ATOM    994 HG13 VAL A  62      47.127  29.411  30.467  1.00  0.00           H  
ATOM    995 HG21 VAL A  62      46.518  30.948  28.815  1.00  0.00           H  
ATOM    996 HG22 VAL A  62      47.772  29.936  28.096  1.00  0.00           H  
ATOM    997 HG23 VAL A  62      47.820  31.684  27.884  1.00  0.00           H  
ATOM    998  N   VAL A  63      46.237  33.236  29.443  1.00  0.00           N  
ATOM    999  CA  VAL A  63      44.802  33.668  29.545  1.00  0.00           C  
ATOM   1000  C   VAL A  63      43.892  32.574  28.984  1.00  0.00           C  
ATOM   1001  O   VAL A  63      44.142  32.021  27.931  1.00  0.00           O  
ATOM   1002  CB  VAL A  63      44.602  34.958  28.748  1.00  0.00           C  
ATOM   1003  CG1 VAL A  63      44.798  34.679  27.255  1.00  0.00           C  
ATOM   1004  CG2 VAL A  63      43.186  35.485  28.988  1.00  0.00           C  
ATOM   1005  H   VAL A  63      46.677  33.212  28.575  1.00  0.00           H  
ATOM   1006  HA  VAL A  63      44.538  33.845  30.576  1.00  0.00           H  
ATOM   1007  HB  VAL A  63      45.322  35.694  29.073  1.00  0.00           H  
ATOM   1008 HG11 VAL A  63      45.444  33.826  27.128  1.00  0.00           H  
ATOM   1009 HG12 VAL A  63      45.246  35.544  26.785  1.00  0.00           H  
ATOM   1010 HG13 VAL A  63      43.842  34.480  26.797  1.00  0.00           H  
ATOM   1011 HG21 VAL A  63      43.138  36.525  28.701  1.00  0.00           H  
ATOM   1012 HG22 VAL A  63      42.936  35.386  30.033  1.00  0.00           H  
ATOM   1013 HG23 VAL A  63      42.485  34.916  28.395  1.00  0.00           H  
ATOM   1014  N   LEU A  64      42.834  32.259  29.691  1.00  0.00           N  
ATOM   1015  CA  LEU A  64      41.886  31.200  29.222  1.00  0.00           C  
ATOM   1016  C   LEU A  64      40.609  31.862  28.687  1.00  0.00           C  
ATOM   1017  O   LEU A  64      40.283  31.747  27.523  1.00  0.00           O  
ATOM   1018  CB  LEU A  64      41.540  30.277  30.406  1.00  0.00           C  
ATOM   1019  CG  LEU A  64      42.596  29.161  30.549  1.00  0.00           C  
ATOM   1020  CD1 LEU A  64      43.973  29.749  30.916  1.00  0.00           C  
ATOM   1021  CD2 LEU A  64      42.151  28.169  31.634  1.00  0.00           C  
ATOM   1022  H   LEU A  64      42.663  32.721  30.536  1.00  0.00           H  
ATOM   1023  HA  LEU A  64      42.339  30.620  28.432  1.00  0.00           H  
ATOM   1024  HB2 LEU A  64      41.527  30.863  31.316  1.00  0.00           H  
ATOM   1025  HB3 LEU A  64      40.568  29.834  30.254  1.00  0.00           H  
ATOM   1026  HG  LEU A  64      42.680  28.639  29.606  1.00  0.00           H  
ATOM   1027 HD11 LEU A  64      43.849  30.666  31.469  1.00  0.00           H  
ATOM   1028 HD12 LEU A  64      44.524  29.954  30.010  1.00  0.00           H  
ATOM   1029 HD13 LEU A  64      44.531  29.042  31.516  1.00  0.00           H  
ATOM   1030 HD21 LEU A  64      42.167  27.165  31.231  1.00  0.00           H  
ATOM   1031 HD22 LEU A  64      41.148  28.410  31.958  1.00  0.00           H  
ATOM   1032 HD23 LEU A  64      42.827  28.227  32.475  1.00  0.00           H  
ATOM   1033  N   SER A  65      39.881  32.553  29.527  1.00  0.00           N  
ATOM   1034  CA  SER A  65      38.629  33.215  29.051  1.00  0.00           C  
ATOM   1035  C   SER A  65      38.988  34.382  28.126  1.00  0.00           C  
ATOM   1036  O   SER A  65      40.039  34.978  28.244  1.00  0.00           O  
ATOM   1037  CB  SER A  65      37.822  33.731  30.247  1.00  0.00           C  
ATOM   1038  OG  SER A  65      37.266  32.622  30.942  1.00  0.00           O  
ATOM   1039  H   SER A  65      40.156  32.638  30.464  1.00  0.00           H  
ATOM   1040  HA  SER A  65      38.037  32.498  28.503  1.00  0.00           H  
ATOM   1041  HB2 SER A  65      38.462  34.285  30.916  1.00  0.00           H  
ATOM   1042  HB3 SER A  65      37.030  34.377  29.893  1.00  0.00           H  
ATOM   1043  HG  SER A  65      37.834  32.428  31.692  1.00  0.00           H  
ATOM   1044  N   ASP A  66      38.125  34.705  27.200  1.00  0.00           N  
ATOM   1045  CA  ASP A  66      38.414  35.831  26.260  1.00  0.00           C  
ATOM   1046  C   ASP A  66      37.105  36.537  25.896  1.00  0.00           C  
ATOM   1047  O   ASP A  66      36.044  35.947  25.916  1.00  0.00           O  
ATOM   1048  CB  ASP A  66      39.063  35.273  24.991  1.00  0.00           C  
ATOM   1049  CG  ASP A  66      38.080  34.342  24.276  1.00  0.00           C  
ATOM   1050  OD1 ASP A  66      37.031  34.081  24.839  1.00  0.00           O  
ATOM   1051  OD2 ASP A  66      38.396  33.907  23.181  1.00  0.00           O  
ATOM   1052  H   ASP A  66      37.285  34.207  27.119  1.00  0.00           H  
ATOM   1053  HA  ASP A  66      39.085  36.538  26.727  1.00  0.00           H  
ATOM   1054  HB2 ASP A  66      39.326  36.091  24.333  1.00  0.00           H  
ATOM   1055  HB3 ASP A  66      39.953  34.722  25.253  1.00  0.00           H  
ATOM   1056  N   GLY A  67      37.172  37.799  25.565  1.00  0.00           N  
ATOM   1057  CA  GLY A  67      35.931  38.543  25.200  1.00  0.00           C  
ATOM   1058  C   GLY A  67      35.589  38.286  23.725  1.00  0.00           C  
ATOM   1059  O   GLY A  67      34.593  37.651  23.433  1.00  0.00           O  
ATOM   1060  H   GLY A  67      38.037  38.259  25.555  1.00  0.00           H  
ATOM   1061  HA2 GLY A  67      35.112  38.202  25.822  1.00  0.00           H  
ATOM   1062  HA3 GLY A  67      36.080  39.598  25.356  1.00  0.00           H  
ATOM   1063  N   PRO A  68      36.420  38.777  22.829  1.00  0.00           N  
ATOM   1064  CA  PRO A  68      36.193  38.586  21.384  1.00  0.00           C  
ATOM   1065  C   PRO A  68      36.161  37.085  21.060  1.00  0.00           C  
ATOM   1066  O   PRO A  68      37.180  36.475  20.802  1.00  0.00           O  
ATOM   1067  CB  PRO A  68      37.383  39.293  20.693  1.00  0.00           C  
ATOM   1068  CG  PRO A  68      38.311  39.850  21.816  1.00  0.00           C  
ATOM   1069  CD  PRO A  68      37.635  39.549  23.172  1.00  0.00           C  
ATOM   1070  HA  PRO A  68      35.263  39.049  21.088  1.00  0.00           H  
ATOM   1071  HB2 PRO A  68      37.931  38.592  20.074  1.00  0.00           H  
ATOM   1072  HB3 PRO A  68      37.025  40.111  20.081  1.00  0.00           H  
ATOM   1073  HG2 PRO A  68      39.279  39.366  21.767  1.00  0.00           H  
ATOM   1074  HG3 PRO A  68      38.437  40.919  21.697  1.00  0.00           H  
ATOM   1075  HD2 PRO A  68      38.292  38.965  23.800  1.00  0.00           H  
ATOM   1076  HD3 PRO A  68      37.362  40.469  23.666  1.00  0.00           H  
ATOM   1077  N   ALA A  69      34.992  36.492  21.054  1.00  0.00           N  
ATOM   1078  CA  ALA A  69      34.863  35.046  20.734  1.00  0.00           C  
ATOM   1079  C   ALA A  69      34.072  34.919  19.441  1.00  0.00           C  
ATOM   1080  O   ALA A  69      32.877  34.688  19.436  1.00  0.00           O  
ATOM   1081  CB  ALA A  69      34.109  34.335  21.862  1.00  0.00           C  
ATOM   1082  H   ALA A  69      34.193  37.007  21.240  1.00  0.00           H  
ATOM   1083  HA  ALA A  69      35.838  34.593  20.607  1.00  0.00           H  
ATOM   1084  HB1 ALA A  69      34.017  33.286  21.630  1.00  0.00           H  
ATOM   1085  HB2 ALA A  69      33.125  34.769  21.967  1.00  0.00           H  
ATOM   1086  HB3 ALA A  69      34.656  34.454  22.788  1.00  0.00           H  
ATOM   1087  N   LEU A  70      34.740  35.067  18.344  1.00  0.00           N  
ATOM   1088  CA  LEU A  70      34.062  34.959  17.018  1.00  0.00           C  
ATOM   1089  C   LEU A  70      33.992  33.489  16.605  1.00  0.00           C  
ATOM   1090  O   LEU A  70      34.993  32.802  16.546  1.00  0.00           O  
ATOM   1091  CB  LEU A  70      34.861  35.747  15.972  1.00  0.00           C  
ATOM   1092  CG  LEU A  70      34.725  37.263  16.225  1.00  0.00           C  
ATOM   1093  CD1 LEU A  70      35.931  37.997  15.630  1.00  0.00           C  
ATOM   1094  CD2 LEU A  70      33.444  37.798  15.569  1.00  0.00           C  
ATOM   1095  H   LEU A  70      35.695  35.260  18.395  1.00  0.00           H  
ATOM   1096  HA  LEU A  70      33.063  35.362  17.088  1.00  0.00           H  
ATOM   1097  HB2 LEU A  70      35.903  35.460  16.038  1.00  0.00           H  
ATOM   1098  HB3 LEU A  70      34.493  35.509  14.986  1.00  0.00           H  
ATOM   1099  HG  LEU A  70      34.690  37.451  17.291  1.00  0.00           H  
ATOM   1100 HD11 LEU A  70      35.733  39.061  15.611  1.00  0.00           H  
ATOM   1101 HD12 LEU A  70      36.105  37.647  14.623  1.00  0.00           H  
ATOM   1102 HD13 LEU A  70      36.804  37.806  16.235  1.00  0.00           H  
ATOM   1103 HD21 LEU A  70      33.417  38.875  15.661  1.00  0.00           H  
ATOM   1104 HD22 LEU A  70      32.582  37.378  16.059  1.00  0.00           H  
ATOM   1105 HD23 LEU A  70      33.433  37.528  14.523  1.00  0.00           H  
ATOM   1106  N   HIS A  71      32.817  32.998  16.316  1.00  0.00           N  
ATOM   1107  CA  HIS A  71      32.686  31.571  15.906  1.00  0.00           C  
ATOM   1108  C   HIS A  71      33.416  30.682  16.916  1.00  0.00           C  
ATOM   1109  CB  HIS A  71      33.304  31.381  14.519  1.00  0.00           C  
ATOM   1110  CG  HIS A  71      32.934  30.025  13.984  1.00  0.00           C  
ATOM   1111  ND1 HIS A  71      32.346  29.054  14.778  1.00  0.00           N  
ATOM   1112  CD2 HIS A  71      33.058  29.465  12.736  1.00  0.00           C  
ATOM   1113  CE1 HIS A  71      32.141  27.969  14.007  1.00  0.00           C  
ATOM   1114  NE2 HIS A  71      32.558  28.167  12.754  1.00  0.00           N  
ATOM   1115  H   HIS A  71      32.022  33.568  16.367  1.00  0.00           H  
ATOM   1116  HA  HIS A  71      31.643  31.300  15.875  1.00  0.00           H  
ATOM   1117  HB2 HIS A  71      32.935  32.147  13.852  1.00  0.00           H  
ATOM   1118  HB3 HIS A  71      34.381  31.454  14.591  1.00  0.00           H  
ATOM   1119  HD1 HIS A  71      32.119  29.140  15.727  1.00  0.00           H  
ATOM   1120  HD2 HIS A  71      33.481  29.959  11.873  1.00  0.00           H  
ATOM   1121  HE1 HIS A  71      31.696  27.051  14.360  1.00  0.00           H  
TER    1122      HIS A  71                                                      
END
MOLECULE T0487_178_265.pdb
ATOM   1389  N   SER   178      50.886  32.816  25.767  1.00 72.79           N  
ATOM   1390  CA  SER   178      50.904  33.757  26.889  1.00 70.07           C  
ATOM   1391  C   SER   178      49.706  34.705  26.864  1.00 68.01           C  
ATOM   1392  O   SER   178      49.068  34.887  25.828  1.00 67.65           O  
ATOM   1393  CB  SER   178      52.174  34.607  26.842  1.00 70.56           C  
ATOM   1394  OG  SER   178      51.942  35.805  26.101  1.00 69.80           O  
ATOM   1395  N   LEU   179      49.423  35.323  28.008  1.00 65.44           N  
ATOM   1396  CA  LEU   179      48.324  36.270  28.111  1.00 64.41           C  
ATOM   1397  C   LEU   179      48.681  37.485  27.264  1.00 65.44           C  
ATOM   1398  O   LEU   179      47.803  38.213  26.811  1.00 64.49           O  
ATOM   1399  CB  LEU   179      48.133  36.706  29.564  1.00 63.05           C  
ATOM   1400  CG  LEU   179      46.806  37.324  30.046  1.00 63.07           C  
ATOM   1401  CD1 LEU   179      47.061  38.669  30.666  1.00 59.96           C  
ATOM   1402  CD2 LEU   179      45.810  37.439  28.911  1.00 63.32           C  
ATOM   1403  N   GLU   180      49.979  37.711  27.072  1.00 66.94           N  
ATOM   1404  CA  GLU   180      50.451  38.838  26.277  1.00 68.35           C  
ATOM   1405  C   GLU   180      50.122  38.532  24.826  1.00 69.37           C  
ATOM   1406  O   GLU   180      49.522  39.351  24.124  1.00 69.29           O  
ATOM   1407  CB  GLU   180      51.968  39.021  26.433  1.00 69.56           C  
ATOM   1408  CG  GLU   180      52.578  40.133  25.564  1.00 68.16           C  
ATOM   1409  CD  GLU   180      51.789  41.432  25.644  1.00 70.51           C  
ATOM   1410  OE1 GLU   180      51.352  41.804  26.751  1.00 71.02           O  
ATOM   1411  OE2 GLU   180      51.606  42.095  24.601  1.00 72.24           O  
ATOM   1412  N   ALA   181      50.509  37.339  24.387  1.00 68.86           N  
ATOM   1413  CA  ALA   181      50.246  36.915  23.020  1.00 68.70           C  
ATOM   1414  C   ALA   181      48.751  36.958  22.734  1.00 68.21           C  
ATOM   1415  O   ALA   181      48.298  37.630  21.811  1.00 67.78           O  
ATOM   1416  CB  ALA   181      50.778  35.493  22.799  1.00 68.81           C  
ATOM   1417  N   TRP   182      47.990  36.245  23.554  1.00 67.73           N  
ATOM   1418  CA  TRP   182      46.554  36.156  23.382  1.00 67.32           C  
ATOM   1419  C   TRP   182      45.879  37.511  23.267  1.00 66.70           C  
ATOM   1420  O   TRP   182      45.005  37.712  22.425  1.00 64.93           O  
ATOM   1421  CB  TRP   182      45.951  35.379  24.545  1.00 66.80           C  
ATOM   1422  CG  TRP   182      44.717  34.606  24.192  1.00 66.97           C  
ATOM   1423  CD1 TRP   182      44.627  33.513  23.363  1.00 67.71           C  
ATOM   1424  CD2 TRP   182      43.412  34.821  24.711  1.00 65.75           C  
ATOM   1425  NE1 TRP   182      43.337  33.031  23.348  1.00 66.31           N  
ATOM   1426  CE2 TRP   182      42.571  33.818  24.167  1.00 66.78           C  
ATOM   1427  CE3 TRP   182      42.866  35.761  25.585  1.00 65.78           C  
ATOM   1428  CZ2 TRP   182      41.213  33.734  24.476  1.00 68.00           C  
ATOM   1429  CZ3 TRP   182      41.513  35.680  25.893  1.00 68.30           C  
ATOM   1430  CH2 TRP   182      40.700  34.673  25.340  1.00 69.32           C  
ATOM   1431  N   LEU   183      46.271  38.438  24.128  1.00 67.37           N  
ATOM   1432  CA  LEU   183      45.668  39.763  24.101  1.00 68.70           C  
ATOM   1433  C   LEU   183      46.163  40.567  22.902  1.00 70.28           C  
ATOM   1434  O   LEU   183      45.409  41.379  22.354  1.00 70.00           O  
ATOM   1435  CB  LEU   183      45.960  40.523  25.397  1.00 65.92           C  
ATOM   1436  CG  LEU   183      45.158  40.159  26.643  1.00 64.80           C  
ATOM   1437  CD1 LEU   183      45.737  40.878  27.843  1.00 65.61           C  
ATOM   1438  CD2 LEU   183      43.717  40.543  26.469  1.00 63.29           C  
ATOM   1439  N   ALA   184      47.418  40.344  22.498  1.00 70.51           N  
ATOM   1440  CA  ALA   184      47.986  41.054  21.353  1.00 70.65           C  
ATOM   1441  C   ALA   184      47.157  40.725  20.112  1.00 72.14           C  
ATOM   1442  O   ALA   184      46.811  41.613  19.322  1.00 74.22           O  
ATOM   1443  CB  ALA   184      49.439  40.642  21.128  1.00 67.57           C  
ATOM   1444  N   GLN   185      46.823  39.448  19.959  1.00 71.41           N  
ATOM   1445  CA  GLN   185      46.055  38.988  18.822  1.00 70.02           C  
ATOM   1446  C   GLN   185      44.571  39.360  18.885  1.00 70.30           C  
ATOM   1447  O   GLN   185      43.754  38.814  18.140  1.00 72.30           O  
ATOM   1448  CB  GLN   185      46.250  37.478  18.668  1.00 70.34           C  
ATOM   1449  CG  GLN   185      47.700  37.106  18.314  1.00 71.08           C  
ATOM   1450  CD  GLN   185      48.049  35.632  18.569  1.00 73.18           C  
ATOM   1451  OE1 GLN   185      47.240  34.728  18.313  1.00 75.02           O  
ATOM   1452  NE2 GLN   185      49.270  35.386  19.059  1.00 70.57           N  
ATOM   1453  N   GLY   186      44.220  40.280  19.780  1.00 69.12           N  
ATOM   1454  CA  GLY   186      42.842  40.736  19.865  1.00 68.35           C  
ATOM   1455  C   GLY   186      41.785  40.064  20.725  1.00 68.79           C  
ATOM   1456  O   GLY   186      40.698  40.631  20.863  1.00 68.00           O  
ATOM   1457  N   HIS   187      42.061  38.888  21.297  1.00 70.02           N  
ATOM   1458  CA  HIS   187      41.061  38.198  22.133  1.00 70.95           C  
ATOM   1459  C   HIS   187      40.753  38.993  23.388  1.00 70.80           C  
ATOM   1460  O   HIS   187      41.644  39.608  23.966  1.00 72.87           O  
ATOM   1461  CB  HIS   187      41.548  36.818  22.568  1.00 72.13           C  
ATOM   1462  CG  HIS   187      41.837  35.881  21.435  1.00 75.45           C  
ATOM   1463  ND1 HIS   187      43.103  35.712  20.912  1.00 76.97           N  
ATOM   1464  CD2 HIS   187      41.031  35.032  20.752  1.00 75.28           C  
ATOM   1465  CE1 HIS   187      43.065  34.798  19.957  1.00 77.65           C  
ATOM   1466  NE2 HIS   187      41.820  34.370  19.841  1.00 77.28           N  
ATOM   1467  N   PRO   188      39.493  38.976  23.844  1.00 69.33           N  
ATOM   1468  CA  PRO   188      39.108  39.717  25.047  1.00 68.82           C  
ATOM   1469  C   PRO   188      39.831  39.288  26.332  1.00 69.05           C  
ATOM   1470  O   PRO   188      40.532  38.273  26.377  1.00 67.98           O  
ATOM   1471  CB  PRO   188      37.607  39.483  25.122  1.00 67.89           C  
ATOM   1472  CG  PRO   188      37.476  38.105  24.590  1.00 68.52           C  
ATOM   1473  CD  PRO   188      38.377  38.142  23.373  1.00 69.36           C  
ATOM   1474  N   LEU   189      39.631  40.088  27.375  1.00 69.24           N  
ATOM   1475  CA  LEU   189      40.226  39.893  28.694  1.00 68.26           C  
ATOM   1476  C   LEU   189      39.519  38.753  29.426  1.00 67.78           C  
ATOM   1477  O   LEU   189      38.325  38.853  29.703  1.00 67.72           O  
ATOM   1478  CB  LEU   189      40.048  41.184  29.487  1.00 68.50           C  
ATOM   1479  CG  LEU   189      41.061  41.714  30.495  1.00 69.40           C  
ATOM   1480  CD1 LEU   189      42.320  42.193  29.785  1.00 68.24           C  
ATOM   1481  CD2 LEU   189      40.423  42.861  31.252  1.00 69.17           C  
ATOM   1482  N   PRO   190      40.238  37.653  29.738  1.00 66.51           N  
ATOM   1483  CA  PRO   190      39.635  36.518  30.445  1.00 66.30           C  
ATOM   1484  C   PRO   190      39.386  36.844  31.906  1.00 65.77           C  
ATOM   1485  O   PRO   190      39.913  37.815  32.442  1.00 64.95           O  
ATOM   1486  CB  PRO   190      40.659  35.409  30.259  1.00 65.74           C  
ATOM   1487  CG  PRO   190      41.934  36.142  30.209  1.00 65.98           C  
ATOM   1488  CD  PRO   190      41.608  37.323  29.323  1.00 66.24           C  
ATOM   1489  N   LYS   191      38.574  36.029  32.555  1.00 66.90           N  
ATOM   1490  CA  LYS   191      38.252  36.281  33.940  1.00 68.59           C  
ATOM   1491  C   LYS   191      39.385  35.895  34.877  1.00 69.54           C  
ATOM   1492  O   LYS   191      39.714  36.611  35.811  1.00 69.46           O  
ATOM   1493  CB  LYS   191      36.971  35.507  34.339  1.00 66.50           C  
ATOM   1494  N   ARG   192      40.013  34.775  34.579  1.00 71.25           N  
ATOM   1495  CA  ARG   192      41.003  34.185  35.433  1.00 72.21           C  
ATOM   1496  C   ARG   192      42.272  33.878  34.698  1.00 71.41           C  
ATOM   1497  O   ARG   192      42.220  33.436  33.559  1.00 70.49           O  
ATOM   1498  CB  ARG   192      40.461  32.862  35.897  1.00 73.81           C  
ATOM   1499  CG  ARG   192      40.240  32.724  37.306  1.00 77.12           C  
ATOM   1500  CD  ARG   192      38.931  33.293  37.700  1.00 79.09           C  
ATOM   1501  NE  ARG   192      38.792  32.976  39.096  1.00 83.42           N  
ATOM   1502  CZ  ARG   192      38.232  33.757  40.002  1.00 85.75           C  
ATOM   1503  NH1 ARG   192      37.744  34.933  39.637  1.00 85.86           N  
ATOM   1504  NH2 ARG   192      38.175  33.346  41.272  1.00 86.41           N  
ATOM   1505  N   VAL   193      43.405  34.036  35.376  1.00 70.67           N  
ATOM   1506  CA  VAL   193      44.691  33.778  34.753  1.00 69.01           C  
ATOM   1507  C   VAL   193      45.496  32.785  35.566  1.00 68.15           C  
ATOM   1508  O   VAL   193      45.343  32.710  36.774  1.00 69.21           O  
ATOM   1509  CB  VAL   193      45.483  35.071  34.630  1.00 69.25           C  
ATOM   1510  CG1 VAL   193      46.781  34.825  33.918  1.00 71.90           C  
ATOM   1511  CG2 VAL   193      44.654  36.096  33.902  1.00 68.33           C  
ATOM   1512  N   ARG   194      46.379  32.039  34.916  1.00 67.11           N  
ATOM   1513  CA  ARG   194      47.211  31.081  35.619  1.00 66.36           C  
ATOM   1514  C   ARG   194      48.648  31.524  35.461  1.00 66.04           C  
ATOM   1515  O   ARG   194      48.986  32.188  34.495  1.00 66.50           O  
ATOM   1516  CB  ARG   194      47.041  29.706  35.003  1.00 68.43           C  
ATOM   1517  CG  ARG   194      47.425  28.562  35.902  1.00 71.86           C  
ATOM   1518  CD  ARG   194      48.589  27.803  35.321  1.00 76.27           C  
ATOM   1519  NE  ARG   194      48.386  27.429  33.922  1.00 80.71           N  
ATOM   1520  CZ  ARG   194      49.372  27.027  33.117  1.00 84.44           C  
ATOM   1521  NH1 ARG   194      50.617  26.949  33.581  1.00 85.78           N  
ATOM   1522  NH2 ARG   194      49.128  26.718  31.846  1.00 85.83           N  
ATOM   1523  N   ASN   195      49.496  31.182  36.421  1.00 65.91           N  
ATOM   1524  CA  ASN   195      50.898  31.535  36.310  1.00 64.68           C  
ATOM   1525  C   ASN   195      51.400  30.608  35.223  1.00 63.81           C  
ATOM   1526  O   ASN   195      50.868  29.512  35.058  1.00 62.14           O  
ATOM   1527  CB  ASN   195      51.664  31.234  37.606  1.00 65.09           C  
ATOM   1528  CG  ASN   195      51.538  32.338  38.641  1.00 66.86           C  
ATOM   1529  OD1 ASN   195      51.062  33.438  38.350  1.00 66.81           O  
ATOM   1530  ND2 ASN   195      51.982  32.051  39.858  1.00 66.69           N  
ATOM   1531  N   ALA   196      52.412  31.040  34.478  1.00 63.13           N  
ATOM   1532  CA  ALA   196      52.977  30.189  33.435  1.00 62.64           C  
ATOM   1533  C   ALA   196      53.970  29.213  34.062  1.00 62.41           C  
ATOM   1534  O   ALA   196      54.076  28.076  33.631  1.00 62.74           O  
ATOM   1535  CB  ALA   196      53.669  31.035  32.379  1.00 60.19           C  
ATOM   1536  N   TYR   197      54.673  29.665  35.097  1.00 63.83           N  
ATOM   1537  CA  TYR   197      55.675  28.856  35.796  1.00 64.54           C  
ATOM   1538  C   TYR   197      55.148  27.838  36.825  1.00 65.64           C  
ATOM   1539  O   TYR   197      55.920  27.054  37.385  1.00 67.88           O  
ATOM   1540  CB  TYR   197      56.705  29.770  36.462  1.00 61.90           C  
ATOM   1541  CG  TYR   197      56.102  30.959  37.159  1.00 58.48           C  
ATOM   1542  CD1 TYR   197      55.931  32.173  36.496  1.00 56.01           C  
ATOM   1543  CD2 TYR   197      55.685  30.866  38.483  1.00 58.22           C  
ATOM   1544  CE1 TYR   197      55.355  33.265  37.140  1.00 55.57           C  
ATOM   1545  CE2 TYR   197      55.111  31.947  39.131  1.00 56.93           C  
ATOM   1546  CZ  TYR   197      54.944  33.133  38.459  1.00 56.38           C  
ATOM   1547  OH  TYR   197      54.312  34.151  39.121  1.00 58.19           O  
ATOM   1548  N   ASP   198      53.850  27.871  37.099  1.00 65.09           N  
ATOM   1549  CA  ASP   198      53.227  26.901  37.998  1.00 63.43           C  
ATOM   1550  C   ASP   198      51.731  26.951  37.788  1.00 62.42           C  
ATOM   1551  O   ASP   198      51.239  27.730  36.974  1.00 63.52           O  
ATOM   1552  CB  ASP   198      53.611  27.109  39.479  1.00 64.26           C  
ATOM   1553  CG  ASP   198      53.151  28.434  40.053  1.00 65.88           C  
ATOM   1554  OD1 ASP   198      51.939  28.745  40.023  1.00 66.73           O  
ATOM   1555  OD2 ASP   198      54.022  29.161  40.570  1.00 66.88           O  
ATOM   1556  N   ARG   199      50.996  26.124  38.506  1.00 61.43           N  
ATOM   1557  CA  ARG   199      49.563  26.081  38.311  1.00 61.61           C  
ATOM   1558  C   ARG   199      48.703  27.055  39.118  1.00 61.63           C  
ATOM   1559  O   ARG   199      47.472  26.957  39.087  1.00 62.25           O  
ATOM   1560  CB  ARG   199      49.076  24.656  38.521  1.00 61.85           C  
ATOM   1561  N   ARG   200      49.303  28.003  39.825  1.00 61.76           N  
ATOM   1562  CA  ARG   200      48.470  28.929  40.580  1.00 63.49           C  
ATOM   1563  C   ARG   200      47.630  29.805  39.653  1.00 62.41           C  
ATOM   1564  O   ARG   200      48.124  30.305  38.645  1.00 62.12           O  
ATOM   1565  CB  ARG   200      49.307  29.824  41.497  1.00 66.92           C  
ATOM   1566  CG  ARG   200      48.426  30.796  42.301  1.00 71.18           C  
ATOM   1567  CD  ARG   200      49.138  31.366  43.512  1.00 74.24           C  
ATOM   1568  NE  ARG   200      48.225  32.139  44.348  1.00 78.08           N  
ATOM   1569  CZ  ARG   200      48.525  32.597  45.564  1.00 80.74           C  
ATOM   1570  NH1 ARG   200      49.720  32.362  46.097  1.00 79.79           N  
ATOM   1571  NH2 ARG   200      47.626  33.295  46.251  1.00 81.86           N  
ATOM   1572  N   THR   201      46.361  29.991  39.999  1.00 60.13           N  
ATOM   1573  CA  THR   201      45.482  30.804  39.180  1.00 60.15           C  
ATOM   1574  C   THR   201      45.130  32.081  39.904  1.00 59.16           C  
ATOM   1575  O   THR   201      45.423  32.222  41.081  1.00 60.04           O  
ATOM   1576  CB  THR   201      44.171  30.069  38.837  1.00 61.49           C  
ATOM   1577  OG1 THR   201      43.358  29.969  40.011  1.00 63.21           O  
ATOM   1578  CG2 THR   201      44.465  28.670  38.287  1.00 61.45           C  
ATOM   1579  N   TRP   202      44.508  33.013  39.192  1.00 58.57           N  
ATOM   1580  CA  TRP   202      44.117  34.287  39.774  1.00 58.33           C  
ATOM   1581  C   TRP   202      42.922  34.884  39.051  1.00 59.89           C  
ATOM   1582  O   TRP   202      42.480  34.403  38.015  1.00 57.22           O  
ATOM   1583  CB  TRP   202      45.230  35.342  39.687  1.00 56.73           C  
ATOM   1584  CG  TRP   202      46.623  34.925  39.996  1.00 56.77           C  
ATOM   1585  CD1 TRP   202      47.492  34.280  39.165  1.00 56.59           C  
ATOM   1586  CD2 TRP   202      47.355  35.223  41.186  1.00 57.19           C  
ATOM   1587  NE1 TRP   202      48.726  34.165  39.761  1.00 56.12           N  
ATOM   1588  CE2 TRP   202      48.668  34.735  41.001  1.00 57.56           C  
ATOM   1589  CE3 TRP   202      47.031  35.860  42.386  1.00 56.85           C  
ATOM   1590  CZ2 TRP   202      49.659  34.871  41.980  1.00 58.30           C  
ATOM   1591  CZ3 TRP   202      48.016  35.995  43.357  1.00 57.50           C  
ATOM   1592  CH2 TRP   202      49.315  35.501  43.148  1.00 58.22           C  
ATOM   1593  N   GLU   203      42.441  35.982  39.611  1.00 63.38           N  
ATOM   1594  CA  GLU   203      41.325  36.726  39.070  1.00 66.11           C  
ATOM   1595  C   GLU   203      42.001  37.892  38.363  1.00 65.79           C  
ATOM   1596  O   GLU   203      42.750  38.642  38.980  1.00 66.11           O  
ATOM   1597  CB  GLU   203      40.460  37.238  40.223  1.00 70.66           C  
ATOM   1598  CG  GLU   203      39.117  37.839  39.837  1.00 77.93           C  
ATOM   1599  CD  GLU   203      38.422  38.524  41.029  1.00 82.54           C  
ATOM   1600  OE1 GLU   203      38.918  38.381  42.172  1.00 84.18           O  
ATOM   1601  OE2 GLU   203      37.383  39.206  40.829  1.00 83.53           O  
ATOM   1602  N   LEU   204      41.769  38.031  37.066  1.00 65.73           N  
ATOM   1603  CA  LEU   204      42.370  39.123  36.329  1.00 65.17           C  
ATOM   1604  C   LEU   204      41.429  40.300  36.476  1.00 66.53           C  
ATOM   1605  O   LEU   204      40.241  40.183  36.197  1.00 67.24           O  
ATOM   1606  CB  LEU   204      42.514  38.754  34.865  1.00 63.65           C  
ATOM   1607  CG  LEU   204      43.641  39.447  34.119  1.00 61.57           C  
ATOM   1608  CD1 LEU   204      43.306  39.451  32.639  1.00 60.65           C  
ATOM   1609  CD2 LEU   204      43.821  40.845  34.639  1.00 61.03           C  
ATOM   1610  N   LEU   205      41.960  41.431  36.925  1.00 68.73           N  
ATOM   1611  CA  LEU   205      41.153  42.629  37.136  1.00 69.65           C  
ATOM   1612  C   LEU   205      41.264  43.606  35.975  1.00 71.33           C  
ATOM   1613  O   LEU   205      40.257  44.084  35.448  1.00 72.62           O  
ATOM   1614  CB  LEU   205      41.591  43.353  38.408  1.00 66.89           C  
ATOM   1615  CG  LEU   205      41.730  42.558  39.695  1.00 64.42           C  
ATOM   1616  CD1 LEU   205      42.144  43.511  40.811  1.00 63.12           C  
ATOM   1617  CD2 LEU   205      40.434  41.862  40.009  1.00 62.32           C  
ATOM   1618  N   ARG   206      42.495  43.910  35.588  1.00 71.79           N  
ATOM   1619  CA  ARG   206      42.729  44.851  34.515  1.00 72.64           C  
ATOM   1620  C   ARG   206      44.183  44.866  34.156  1.00 73.27           C  
ATOM   1621  O   ARG   206      44.993  44.216  34.793  1.00 72.83           O  
ATOM   1622  CB  ARG   206      42.315  46.258  34.952  1.00 73.68           C  
ATOM   1623  CG  ARG   206      42.461  46.518  36.461  1.00 76.14           C  
ATOM   1624  CD  ARG   206      42.338  48.005  36.799  1.00 77.52           C  
ATOM   1625  NE  ARG   206      43.537  48.740  36.395  1.00 79.70           N  
ATOM   1626  CZ  ARG   206      44.510  49.108  37.229  1.00 81.47           C  
ATOM   1627  NH1 ARG   206      44.430  48.823  38.531  1.00 82.03           N  
ATOM   1628  NH2 ARG   206      45.582  49.734  36.761  1.00 80.76           N  
ATOM   1629  N   LEU   207      44.507  45.614  33.116  1.00 76.18           N  
ATOM   1630  CA  LEU   207      45.886  45.752  32.681  1.00 78.80           C  
ATOM   1631  C   LEU   207      46.356  47.051  33.297  1.00 80.34           C  
ATOM   1632  O   LEU   207      45.544  47.817  33.814  1.00 80.93           O  
ATOM   1633  CB  LEU   207      45.969  45.846  31.162  1.00 78.21           C  
ATOM   1634  CG  LEU   207      46.783  44.769  30.459  1.00 79.21           C  
ATOM   1635  CD1 LEU   207      46.312  43.383  30.902  1.00 80.00           C  
ATOM   1636  CD2 LEU   207      46.622  44.939  28.956  1.00 80.04           C  
ATOM   1637  N   GLY   208      47.659  47.293  33.249  1.00 82.20           N  
ATOM   1638  CA  GLY   208      48.200  48.511  33.814  1.00 84.47           C  
ATOM   1639  C   GLY   208      49.210  49.157  32.894  1.00 86.77           C  
ATOM   1640  O   GLY   208      49.906  48.484  32.131  1.00 85.23           O  
ATOM   1641  N   GLU   209      49.303  50.477  32.983  1.00 90.43           N  
ATOM   1642  CA  GLU   209      50.223  51.236  32.148  1.00 93.67           C  
ATOM   1643  C   GLU   209      51.637  51.337  32.713  1.00 93.52           C  
ATOM   1644  O   GLU   209      52.574  51.663  31.979  1.00 93.73           O  
ATOM   1645  CB  GLU   209      49.648  52.640  31.882  1.00 97.33           C  
ATOM   1646  CG  GLU   209      49.114  53.377  33.116  1.00103.77           C  
ATOM   1647  CD  GLU   209      50.198  54.099  33.914  1.00107.89           C  
ATOM   1648  OE1 GLU   209      49.897  54.571  35.041  1.00109.42           O  
ATOM   1649  OE2 GLU   209      51.344  54.207  33.414  1.00109.63           O  
ATOM   1650  N   GLU   210      51.799  51.045  34.003  1.00 92.76           N  
ATOM   1651  CA  GLU   210      53.115  51.126  34.633  1.00 92.10           C  
ATOM   1652  C   GLU   210      54.162  50.242  33.971  1.00 92.41           C  
ATOM   1653  O   GLU   210      53.856  49.189  33.424  1.00 92.97           O  
ATOM   1654  CB  GLU   210      53.019  50.784  36.119  1.00 90.83           C  
ATOM   1655  CG  GLU   210      51.964  49.752  36.447  1.00 89.92           C  
ATOM   1656  CD  GLU   210      50.716  50.370  37.040  1.00 88.65           C  
ATOM   1657  OE1 GLU   210      50.829  51.040  38.088  1.00 88.65           O  
ATOM   1658  OE2 GLU   210      49.624  50.187  36.468  1.00 88.57           O  
ATOM   1659  N   ASP   211      55.407  50.688  34.017  1.00 93.17           N  
ATOM   1660  CA  ASP   211      56.503  49.945  33.425  1.00 94.06           C  
ATOM   1661  C   ASP   211      57.003  48.904  34.410  1.00 93.70           C  
ATOM   1662  O   ASP   211      57.480  49.241  35.489  1.00 94.07           O  
ATOM   1663  CB  ASP   211      57.641  50.895  33.073  1.00 96.52           C  
ATOM   1664  CG  ASP   211      57.981  51.834  34.219  1.00101.13           C  
ATOM   1665  OD1 ASP   211      58.979  52.590  34.113  1.00103.30           O  
ATOM   1666  OD2 ASP   211      57.242  51.818  35.233  1.00102.68           O  
ATOM   1667  N   PRO   212      56.896  47.619  34.055  1.00 93.56           N  
ATOM   1668  CA  PRO   212      57.354  46.539  34.933  1.00 93.11           C  
ATOM   1669  C   PRO   212      58.747  46.823  35.489  1.00 92.62           C  
ATOM   1670  O   PRO   212      59.014  46.663  36.685  1.00 93.34           O  
ATOM   1671  CB  PRO   212      57.335  45.316  34.014  1.00 92.72           C  
ATOM   1672  CG  PRO   212      57.444  45.909  32.631  1.00 93.18           C  
ATOM   1673  CD  PRO   212      56.528  47.086  32.735  1.00 94.11           C  
ATOM   1674  N   LYS   213      59.628  47.245  34.596  1.00 90.79           N  
ATOM   1675  CA  LYS   213      61.001  47.572  34.938  1.00 88.21           C  
ATOM   1676  C   LYS   213      61.120  48.491  36.153  1.00 85.96           C  
ATOM   1677  O   LYS   213      62.079  48.400  36.916  1.00 86.00           O  
ATOM   1678  CB  LYS   213      61.651  48.221  33.718  1.00 89.60           C  
ATOM   1679  CG  LYS   213      60.656  49.042  32.891  1.00 90.43           C  
ATOM   1680  CD  LYS   213      61.122  49.235  31.459  1.00 92.61           C  
ATOM   1681  CE  LYS   213      62.321  50.172  31.368  1.00 93.18           C  
ATOM   1682  NZ  LYS   213      62.789  50.344  29.956  1.00 94.14           N  
ATOM   1683  N   GLU   214      60.135  49.357  36.352  1.00 83.06           N  
ATOM   1684  CA  GLU   214      60.206  50.293  37.456  1.00 80.99           C  
ATOM   1685  C   GLU   214      59.077  50.234  38.479  1.00 78.99           C  
ATOM   1686  O   GLU   214      59.002  51.090  39.357  1.00 79.69           O  
ATOM   1687  CB  GLU   214      60.322  51.714  36.898  1.00 83.18           C  
ATOM   1688  CG  GLU   214      61.496  51.905  35.917  1.00 85.98           C  
ATOM   1689  CD  GLU   214      62.851  52.148  36.603  1.00 88.07           C  
ATOM   1690  OE1 GLU   214      63.899  51.964  35.933  1.00 88.14           O  
ATOM   1691  OE2 GLU   214      62.873  52.537  37.798  1.00 88.28           O  
ATOM   1692  N   LEU   215      58.195  49.245  38.389  1.00 75.56           N  
ATOM   1693  CA  LEU   215      57.118  49.149  39.370  1.00 70.81           C  
ATOM   1694  C   LEU   215      57.721  48.486  40.611  1.00 68.53           C  
ATOM   1695  O   LEU   215      58.277  47.394  40.536  1.00 68.45           O  
ATOM   1696  CB  LEU   215      55.957  48.322  38.816  1.00 69.76           C  
ATOM   1697  CG  LEU   215      54.730  48.203  39.723  1.00 68.23           C  
ATOM   1698  CD1 LEU   215      54.193  49.570  40.043  1.00 70.10           C  
ATOM   1699  CD2 LEU   215      53.673  47.400  39.033  1.00 68.21           C  
ATOM   1700  N   PRO   216      57.629  49.146  41.770  1.00 65.59           N  
ATOM   1701  CA  PRO   216      58.201  48.566  42.985  1.00 64.17           C  
ATOM   1702  C   PRO   216      57.308  47.687  43.856  1.00 63.09           C  
ATOM   1703  O   PRO   216      56.183  48.061  44.191  1.00 62.08           O  
ATOM   1704  CB  PRO   216      58.684  49.797  43.740  1.00 63.84           C  
ATOM   1705  CG  PRO   216      57.575  50.772  43.461  1.00 63.33           C  
ATOM   1706  CD  PRO   216      57.291  50.566  41.974  1.00 63.87           C  
ATOM   1707  N   LEU   217      57.828  46.517  44.224  1.00 61.66           N  
ATOM   1708  CA  LEU   217      57.116  45.601  45.104  1.00 58.98           C  
ATOM   1709  C   LEU   217      57.326  46.160  46.517  1.00 57.95           C  
ATOM   1710  O   LEU   217      58.306  46.866  46.772  1.00 57.13           O  
ATOM   1711  CB  LEU   217      57.681  44.188  44.940  1.00 58.92           C  
ATOM   1712  CG  LEU   217      56.956  43.286  43.917  1.00 59.54           C  
ATOM   1713  CD1 LEU   217      56.270  44.126  42.876  1.00 59.17           C  
ATOM   1714  CD2 LEU   217      57.934  42.316  43.259  1.00 58.01           C  
ATOM   1715  N   PRO   218      56.410  45.869  47.449  1.00 57.53           N  
ATOM   1716  CA  PRO   218      56.488  46.353  48.836  1.00 58.13           C  
ATOM   1717  C   PRO   218      57.834  46.826  49.406  1.00 59.75           C  
ATOM   1718  O   PRO   218      58.011  48.018  49.670  1.00 60.94           O  
ATOM   1719  CB  PRO   218      55.879  45.211  49.621  1.00 57.44           C  
ATOM   1720  CG  PRO   218      54.758  44.819  48.717  1.00 57.10           C  
ATOM   1721  CD  PRO   218      55.382  44.823  47.327  1.00 56.14           C  
ATOM   1722  N   GLY   219      58.785  45.921  49.601  1.00 60.14           N  
ATOM   1723  CA  GLY   219      60.059  46.357  50.154  1.00 59.45           C  
ATOM   1724  C   GLY   219      60.967  47.152  49.225  1.00 59.99           C  
ATOM   1725  O   GLY   219      62.113  47.456  49.593  1.00 60.44           O  
ATOM   1726  N   GLY   220      60.488  47.481  48.023  1.00 58.99           N  
ATOM   1727  CA  GLY   220      61.317  48.225  47.086  1.00 56.82           C  
ATOM   1728  C   GLY   220      61.831  47.485  45.855  1.00 55.36           C  
ATOM   1729  O   GLY   220      62.242  48.116  44.891  1.00 55.91           O  
ATOM   1730  N   LEU   221      61.819  46.159  45.869  1.00 55.10           N  
ATOM   1731  CA  LEU   221      62.285  45.375  44.716  1.00 55.13           C  
ATOM   1732  C   LEU   221      61.377  45.576  43.487  1.00 56.66           C  
ATOM   1733  O   LEU   221      60.147  45.629  43.609  1.00 55.89           O  
ATOM   1734  CB  LEU   221      62.324  43.894  45.104  1.00 52.43           C  
ATOM   1735  CG  LEU   221      62.834  42.780  44.185  1.00 50.13           C  
ATOM   1736  CD1 LEU   221      64.290  42.969  43.829  1.00 46.68           C  
ATOM   1737  CD2 LEU   221      62.650  41.449  44.918  1.00 48.43           C  
ATOM   1738  N   SER   222      61.975  45.692  42.303  1.00 58.20           N  
ATOM   1739  CA  SER   222      61.179  45.880  41.089  1.00 59.40           C  
ATOM   1740  C   SER   222      60.385  44.613  40.804  1.00 59.57           C  
ATOM   1741  O   SER   222      60.803  43.510  41.145  1.00 59.05           O  
ATOM   1742  CB  SER   222      62.063  46.194  39.879  1.00 60.08           C  
ATOM   1743  OG  SER   222      62.747  45.034  39.441  1.00 62.76           O  
ATOM   1744  N   LEU   223      59.232  44.786  40.177  1.00 60.43           N  
ATOM   1745  CA  LEU   223      58.363  43.680  39.845  1.00 60.50           C  
ATOM   1746  C   LEU   223      59.043  42.833  38.789  1.00 60.58           C  
ATOM   1747  O   LEU   223      58.850  41.619  38.727  1.00 60.06           O  
ATOM   1748  CB  LEU   223      57.019  44.227  39.359  1.00 62.23           C  
ATOM   1749  CG  LEU   223      55.925  43.312  38.809  1.00 64.78           C  
ATOM   1750  CD1 LEU   223      56.210  42.956  37.364  1.00 65.62           C  
ATOM   1751  CD2 LEU   223      55.841  42.080  39.642  1.00 65.49           C  
ATOM   1752  N   LEU   224      59.868  43.467  37.970  1.00 61.35           N  
ATOM   1753  CA  LEU   224      60.560  42.717  36.943  1.00 62.83           C  
ATOM   1754  C   LEU   224      61.664  41.895  37.577  1.00 62.41           C  
ATOM   1755  O   LEU   224      61.741  40.701  37.331  1.00 63.75           O  
ATOM   1756  CB  LEU   224      61.148  43.641  35.870  1.00 64.74           C  
ATOM   1757  CG  LEU   224      61.933  42.901  34.771  1.00 65.38           C  
ATOM   1758  CD1 LEU   224      60.998  42.149  33.833  1.00 63.50           C  
ATOM   1759  CD2 LEU   224      62.764  43.902  33.997  1.00 65.92           C  
ATOM   1760  N   ASP   225      62.511  42.516  38.393  1.00 61.75           N  
ATOM   1761  CA  ASP   225      63.603  41.777  39.047  1.00 63.10           C  
ATOM   1762  C   ASP   225      63.111  40.606  39.886  1.00 62.34           C  
ATOM   1763  O   ASP   225      63.825  39.628  40.077  1.00 63.44           O  
ATOM   1764  CB  ASP   225      64.425  42.672  39.977  1.00 65.55           C  
ATOM   1765  CG  ASP   225      65.271  43.676  39.233  1.00 69.26           C  
ATOM   1766  OD1 ASP   225      65.586  43.425  38.043  1.00 69.68           O  
ATOM   1767  OD2 ASP   225      65.631  44.706  39.857  1.00 70.29           O  
ATOM   1768  N   TYR   226      61.901  40.719  40.413  1.00 60.89           N  
ATOM   1769  CA  TYR   226      61.349  39.661  41.228  1.00 59.54           C  
ATOM   1770  C   TYR   226      61.302  38.376  40.404  1.00 60.29           C  
ATOM   1771  O   TYR   226      61.884  37.364  40.792  1.00 61.44           O  
ATOM   1772  CB  TYR   226      59.949  40.053  41.714  1.00 57.13           C  
ATOM   1773  CG  TYR   226      59.221  38.976  42.484  1.00 53.38           C  
ATOM   1774  CD1 TYR   226      59.530  38.703  43.809  1.00 51.58           C  
ATOM   1775  CD2 TYR   226      58.224  38.218  41.875  1.00 53.69           C  
ATOM   1776  CE1 TYR   226      58.862  37.698  44.507  1.00 49.73           C  
ATOM   1777  CE2 TYR   226      57.553  37.205  42.568  1.00 51.40           C  
ATOM   1778  CZ  TYR   226      57.881  36.955  43.876  1.00 49.11           C  
ATOM   1779  OH  TYR   226      57.251  35.937  44.531  1.00 47.84           O  
ATOM   1780  N   HIS   227      60.628  38.410  39.264  1.00 59.93           N  
ATOM   1781  CA  HIS   227      60.544  37.213  38.440  1.00 60.89           C  
ATOM   1782  C   HIS   227      61.894  36.975  37.746  1.00 63.81           C  
ATOM   1783  O   HIS   227      62.439  35.872  37.784  1.00 63.23           O  
ATOM   1784  CB  HIS   227      59.424  37.355  37.399  1.00 57.03           C  
ATOM   1785  CG  HIS   227      58.046  37.517  37.984  1.00 53.56           C  
ATOM   1786  ND1 HIS   227      57.316  36.463  38.493  1.00 52.36           N  
ATOM   1787  CD2 HIS   227      57.253  38.610  38.105  1.00 50.16           C  
ATOM   1788  CE1 HIS   227      56.136  36.898  38.897  1.00 48.37           C  
ATOM   1789  NE2 HIS   227      56.074  38.197  38.673  1.00 47.03           N  
ATOM   1790  N   ALA   228      62.439  38.021  37.134  1.00 67.61           N  
ATOM   1791  CA  ALA   228      63.722  37.933  36.423  1.00 71.57           C  
ATOM   1792  C   ALA   228      64.750  37.137  37.205  1.00 73.71           C  
ATOM   1793  O   ALA   228      65.389  36.230  36.668  1.00 74.28           O  
ATOM   1794  CB  ALA   228      64.274  39.333  36.134  1.00 70.89           C  
ATOM   1795  N   SER   229      64.902  37.483  38.479  1.00 76.15           N  
ATOM   1796  CA  SER   229      65.857  36.813  39.339  1.00 78.54           C  
ATOM   1797  C   SER   229      65.493  35.353  39.536  1.00 79.95           C  
ATOM   1798  O   SER   229      66.373  34.511  39.673  1.00 79.93           O  
ATOM   1799  CB  SER   229      65.932  37.519  40.699  1.00 79.76           C  
ATOM   1800  OG  SER   229      66.833  36.857  41.583  1.00 81.85           O  
ATOM   1801  N   LYS   230      64.199  35.048  39.548  1.00 82.19           N  
ATOM   1802  CA  LYS   230      63.756  33.670  39.743  1.00 84.10           C  
ATOM   1803  C   LYS   230      63.860  32.858  38.451  1.00 84.00           C  
ATOM   1804  O   LYS   230      63.264  31.787  38.322  1.00 83.71           O  
ATOM   1805  CB  LYS   230      62.319  33.637  40.290  1.00 85.98           C  
ATOM   1806  CG  LYS   230      62.157  34.242  41.697  1.00 89.07           C  
ATOM   1807  CD  LYS   230      63.028  33.528  42.739  1.00 91.74           C  
ATOM   1808  CE  LYS   230      62.970  34.220  44.110  1.00 93.04           C  
ATOM   1809  NZ  LYS   230      61.574  34.324  44.630  1.00 92.19           N  
ATOM   1810  N   GLY   231      64.628  33.386  37.502  1.00 83.88           N  
ATOM   1811  CA  GLY   231      64.835  32.715  36.233  1.00 85.07           C  
ATOM   1812  C   GLY   231      63.578  32.378  35.461  1.00 86.24           C  
ATOM   1813  O   GLY   231      63.610  31.550  34.546  1.00 87.35           O  
ATOM   1814  N   ARG   232      62.470  33.017  35.824  1.00 85.71           N  
ATOM   1815  CA  ARG   232      61.186  32.789  35.166  1.00 83.70           C  
ATOM   1816  C   ARG   232      61.158  33.593  33.898  1.00 85.17           C  
ATOM   1817  O   ARG   232      60.272  33.431  33.064  1.00 85.53           O  
ATOM   1818  CB  ARG   232      60.043  33.260  36.054  1.00 79.09           C  
ATOM   1819  CG  ARG   232      59.853  32.463  37.310  1.00 73.26           C  
ATOM   1820  CD  ARG   232      58.927  33.203  38.220  1.00 69.66           C  
ATOM   1821  NE  ARG   232      58.598  32.445  39.413  1.00 65.96           N  
ATOM   1822  CZ  ARG   232      57.974  32.968  40.458  1.00 65.19           C  
ATOM   1823  NH1 ARG   232      57.629  34.248  40.437  1.00 63.79           N  
ATOM   1824  NH2 ARG   232      57.688  32.216  41.513  1.00 64.60           N  
ATOM   1825  N   LEU   233      62.133  34.475  33.762  1.00 88.01           N  
ATOM   1826  CA  LEU   233      62.197  35.324  32.593  1.00 92.02           C  
ATOM   1827  C   LEU   233      62.992  34.656  31.482  1.00 94.37           C  
ATOM   1828  O   LEU   233      62.755  34.912  30.302  1.00 95.25           O  
ATOM   1829  CB  LEU   233      62.832  36.662  32.955  1.00 92.16           C  
ATOM   1830  CG  LEU   233      62.117  37.871  32.364  1.00 91.40           C  
ATOM   1831  CD1 LEU   233      60.835  38.131  33.136  1.00 90.38           C  
ATOM   1832  CD2 LEU   233      63.034  39.083  32.440  1.00 92.79           C  
ATOM   1833  N   GLN   234      63.933  33.796  31.857  1.00 97.19           N  
ATOM   1834  CA  GLN   234      64.749  33.108  30.862  1.00 99.93           C  
ATOM   1835  C   GLN   234      63.873  32.497  29.764  1.00101.35           C  
ATOM   1836  O   GLN   234      63.060  31.602  30.020  1.00102.29           O  
ATOM   1837  CB  GLN   234      65.598  32.025  31.530  1.00 98.68           C  
ATOM   1838  N   GLY   235      64.028  32.998  28.542  1.00101.54           N  
ATOM   1839  CA  GLY   235      63.252  32.472  27.430  1.00102.08           C  
ATOM   1840  C   GLY   235      61.855  33.048  27.268  1.00101.94           C  
ATOM   1841  O   GLY   235      60.982  32.403  26.681  1.00102.78           O  
ATOM   1842  N   ARG   236      61.632  34.258  27.765  1.00101.38           N  
ATOM   1843  CA  ARG   236      60.315  34.858  27.636  1.00 99.91           C  
ATOM   1844  C   ARG   236      60.363  36.370  27.416  1.00 98.87           C  
ATOM   1845  O   ARG   236      61.420  36.955  27.213  1.00 99.44           O  
ATOM   1846  CB  ARG   236      59.478  34.542  28.875  1.00 99.41           C  
ATOM   1847  N   GLU   237      59.185  36.974  27.444  1.00 97.86           N  
ATOM   1848  CA  GLU   237      59.022  38.410  27.289  1.00 96.78           C  
ATOM   1849  C   GLU   237      58.101  38.800  28.430  1.00 94.77           C  
ATOM   1850  O   GLU   237      57.024  38.224  28.581  1.00 94.97           O  
ATOM   1851  CB  GLU   237      58.349  38.751  25.959  1.00100.13           C  
ATOM   1852  CG  GLU   237      57.799  40.185  25.869  1.00102.17           C  
ATOM   1853  CD  GLU   237      56.387  40.238  25.296  1.00103.44           C  
ATOM   1854  OE1 GLU   237      56.036  39.337  24.505  1.00104.23           O  
ATOM   1855  OE2 GLU   237      55.633  41.182  25.627  1.00104.30           O  
ATOM   1856  N   GLY   238      58.525  39.772  29.229  1.00 91.48           N  
ATOM   1857  CA  GLY   238      57.721  40.217  30.350  1.00 87.77           C  
ATOM   1858  C   GLY   238      56.381  40.782  29.942  1.00 85.92           C  
ATOM   1859  O   GLY   238      55.385  40.574  30.627  1.00 85.39           O  
ATOM   1860  N   GLY   239      56.352  41.501  28.826  1.00 85.46           N  
ATOM   1861  CA  GLY   239      55.109  42.084  28.358  1.00 83.22           C  
ATOM   1862  C   GLY   239      54.712  43.275  29.196  1.00 82.47           C  
ATOM   1863  O   GLY   239      55.572  44.015  29.662  1.00 83.12           O  
ATOM   1864  N   ARG   240      53.410  43.452  29.391  1.00 82.23           N  
ATOM   1865  CA  ARG   240      52.865  44.560  30.173  1.00 82.73           C  
ATOM   1866  C   ARG   240      52.442  44.111  31.578  1.00 80.66           C  
ATOM   1867  O   ARG   240      52.334  42.918  31.851  1.00 81.00           O  
ATOM   1868  CB  ARG   240      51.655  45.146  29.437  1.00 87.53           C  
ATOM   1869  CG  ARG   240      51.031  46.391  30.075  1.00 95.10           C  
ATOM   1870  CD  ARG   240      51.879  47.672  29.882  1.00101.20           C  
ATOM   1871  NE  ARG   240      52.015  48.069  28.474  1.00104.62           N  
ATOM   1872  CZ  ARG   240      52.974  47.638  27.656  1.00106.63           C  
ATOM   1873  NH1 ARG   240      53.906  46.789  28.093  1.00107.58           N  
ATOM   1874  NH2 ARG   240      53.000  48.054  26.395  1.00106.50           N  
ATOM   1875  N   VAL   241      52.192  45.076  32.460  1.00 77.97           N  
ATOM   1876  CA  VAL   241      51.776  44.801  33.838  1.00 75.15           C  
ATOM   1877  C   VAL   241      50.311  44.411  33.946  1.00 74.21           C  
ATOM   1878  O   VAL   241      49.442  45.083  33.403  1.00 74.40           O  
ATOM   1879  CB  VAL   241      51.979  46.026  34.752  1.00 73.81           C  
ATOM   1880  CG1 VAL   241      51.329  45.773  36.094  1.00 72.30           C  
ATOM   1881  CG2 VAL   241      53.459  46.319  34.920  1.00 72.84           C  
ATOM   1882  N   ALA   242      50.038  43.344  34.685  1.00 73.49           N  
ATOM   1883  CA  ALA   242      48.668  42.872  34.856  1.00 72.06           C  
ATOM   1884  C   ALA   242      48.230  42.823  36.311  1.00 70.74           C  
ATOM   1885  O   ALA   242      48.684  41.986  37.068  1.00 71.78           O  
ATOM   1886  CB  ALA   242      48.518  41.495  34.231  1.00 72.17           C  
ATOM   1887  N   TRP   243      47.339  43.720  36.699  1.00 69.56           N  
ATOM   1888  CA  TRP   243      46.847  43.726  38.059  1.00 69.29           C  
ATOM   1889  C   TRP   243      45.968  42.512  38.220  1.00 68.40           C  
ATOM   1890  O   TRP   243      45.011  42.313  37.479  1.00 69.02           O  
ATOM   1891  CB  TRP   243      46.095  45.026  38.353  1.00 70.42           C  
ATOM   1892  CG  TRP   243      47.051  46.180  38.314  1.00 72.51           C  
ATOM   1893  CD1 TRP   243      47.309  47.003  37.248  1.00 72.80           C  
ATOM   1894  CD2 TRP   243      48.013  46.521  39.322  1.00 71.94           C  
ATOM   1895  NE1 TRP   243      48.376  47.823  37.530  1.00 72.94           N  
ATOM   1896  CE2 TRP   243      48.828  47.548  38.794  1.00 72.39           C  
ATOM   1897  CE3 TRP   243      48.268  46.052  40.615  1.00 71.00           C  
ATOM   1898  CZ2 TRP   243      49.885  48.116  39.517  1.00 72.37           C  
ATOM   1899  CZ3 TRP   243      49.318  46.618  41.333  1.00 72.44           C  
ATOM   1900  CH2 TRP   243      50.114  47.639  40.780  1.00 71.49           C  
ATOM   1901  N   VAL   244      46.318  41.704  39.206  1.00 67.98           N  
ATOM   1902  CA  VAL   244      45.651  40.450  39.487  1.00 68.63           C  
ATOM   1903  C   VAL   244      45.117  40.368  40.925  1.00 70.31           C  
ATOM   1904  O   VAL   244      45.485  41.172  41.780  1.00 70.28           O  
ATOM   1905  CB  VAL   244      46.669  39.324  39.179  1.00 67.10           C  
ATOM   1906  CG1 VAL   244      46.644  38.261  40.224  1.00 66.99           C  
ATOM   1907  CG2 VAL   244      46.400  38.759  37.816  1.00 65.37           C  
ATOM   1908  N   ALA   245      44.234  39.409  41.182  1.00 73.54           N  
ATOM   1909  CA  ALA   245      43.662  39.217  42.518  1.00 77.50           C  
ATOM   1910  C   ALA   245      43.900  37.775  42.973  1.00 80.10           C  
ATOM   1911  O   ALA   245      44.182  36.911  42.152  1.00 79.89           O  
ATOM   1912  CB  ALA   245      42.182  39.536  42.501  1.00 78.23           C  
ATOM   1913  N   ASP   246      43.741  37.504  44.266  1.00 84.91           N  
ATOM   1914  CA  ASP   246      44.034  36.180  44.786  1.00 91.11           C  
ATOM   1915  C   ASP   246      43.553  34.803  44.228  1.00 95.61           C  
ATOM   1916  O   ASP   246      44.370  34.029  43.736  1.00 97.23           O  
ATOM   1917  CB  ASP   246      43.799  36.129  46.303  1.00 89.52           C  
ATOM   1918  CG  ASP   246      44.490  34.941  46.945  1.00 89.61           C  
ATOM   1919  OD1 ASP   246      45.611  35.108  47.470  1.00 89.47           O  
ATOM   1920  OD2 ASP   246      43.923  33.829  46.896  1.00 89.35           O  
ATOM   1921  N   PRO   247      42.209  34.521  44.177  1.00 99.10           N  
ATOM   1922  CA  PRO   247      41.025  35.241  44.689  1.00101.63           C  
ATOM   1923  C   PRO   247      40.502  35.029  46.109  1.00102.89           C  
ATOM   1924  O   PRO   247      39.342  35.362  46.374  1.00104.01           O  
ATOM   1925  CB  PRO   247      39.978  34.787  43.675  1.00102.35           C  
ATOM   1926  CG  PRO   247      40.295  33.299  43.597  1.00101.05           C  
ATOM   1927  CD  PRO   247      41.818  33.287  43.484  1.00 99.68           C  
ATOM   1928  N   LYS   248      41.297  34.472  47.023  1.00104.59           N  
ATOM   1929  CA  LYS   248      40.804  34.299  48.395  1.00105.61           C  
ATOM   1930  C   LYS   248      40.737  35.689  49.049  1.00107.03           C  
ATOM   1931  O   LYS   248      40.015  35.908  50.026  1.00108.10           O  
ATOM   1932  CB  LYS   248      41.721  33.360  49.190  1.00104.00           C  
ATOM   1933  N   ASP   249      41.509  36.611  48.488  1.00107.31           N  
ATOM   1934  CA  ASP   249      41.545  38.012  48.916  1.00108.27           C  
ATOM   1935  C   ASP   249      41.176  38.757  47.634  1.00108.48           C  
ATOM   1936  O   ASP   249      42.017  39.403  47.008  1.00108.32           O  
ATOM   1937  CB  ASP   249      42.951  38.411  49.368  1.00109.73           C  
ATOM   1938  CG  ASP   249      43.093  38.453  50.881  1.00110.13           C  
ATOM   1939  OD1 ASP   249      44.167  38.872  51.364  1.00110.14           O  
ATOM   1940  OD2 ASP   249      42.137  38.070  51.586  1.00110.53           O  
ATOM   1941  N   PRO   250      39.901  38.668  47.225  1.00108.38           N  
ATOM   1942  CA  PRO   250      39.383  39.305  46.008  1.00108.07           C  
ATOM   1943  C   PRO   250      39.455  40.825  45.962  1.00107.62           C  
ATOM   1944  O   PRO   250      39.369  41.427  44.887  1.00108.06           O  
ATOM   1945  CB  PRO   250      37.944  38.807  45.956  1.00108.28           C  
ATOM   1946  CG  PRO   250      37.578  38.773  47.411  1.00108.01           C  
ATOM   1947  CD  PRO   250      38.795  38.123  48.037  1.00108.15           C  
ATOM   1948  N   ARG   251      39.624  41.439  47.127  1.00105.75           N  
ATOM   1949  CA  ARG   251      39.656  42.888  47.222  1.00103.19           C  
ATOM   1950  C   ARG   251      41.023  43.537  47.101  1.00100.58           C  
ATOM   1951  O   ARG   251      41.111  44.739  46.855  1.00100.45           O  
ATOM   1952  CB  ARG   251      39.020  43.317  48.540  1.00105.18           C  
ATOM   1953  CG  ARG   251      37.641  42.738  48.769  1.00106.09           C  
ATOM   1954  CD  ARG   251      36.659  43.834  49.107  1.00107.90           C  
ATOM   1955  NE  ARG   251      35.353  43.286  49.448  1.00110.15           N  
ATOM   1956  CZ  ARG   251      34.303  44.019  49.808  1.00110.84           C  
ATOM   1957  NH1 ARG   251      34.399  45.341  49.874  1.00110.87           N  
ATOM   1958  NH2 ARG   251      33.156  43.426  50.115  1.00111.15           N  
ATOM   1959  N   LYS   252      42.088  42.760  47.278  1.00 96.86           N  
ATOM   1960  CA  LYS   252      43.434  43.330  47.198  1.00 92.57           C  
ATOM   1961  C   LYS   252      44.222  42.903  45.971  1.00 86.47           C  
ATOM   1962  O   LYS   252      44.592  41.735  45.825  1.00 86.47           O  
ATOM   1963  CB  LYS   252      44.239  42.987  48.451  1.00 95.18           C  
ATOM   1964  CG  LYS   252      45.584  43.698  48.525  1.00 97.46           C  
ATOM   1965  CD  LYS   252      46.376  43.229  49.729  1.00101.35           C  
ATOM   1966  CE  LYS   252      46.871  41.801  49.534  1.00103.67           C  
ATOM   1967  NZ  LYS   252      45.775  40.831  49.223  1.00105.43           N  
ATOM   1968  N   PRO   253      44.501  43.862  45.080  1.00 80.97           N  
ATOM   1969  CA  PRO   253      45.245  43.670  43.833  1.00 76.84           C  
ATOM   1970  C   PRO   253      46.757  43.515  44.020  1.00 72.54           C  
ATOM   1971  O   PRO   253      47.378  44.239  44.802  1.00 71.39           O  
ATOM   1972  CB  PRO   253      44.901  44.929  43.045  1.00 76.95           C  
ATOM   1973  CG  PRO   253      44.826  45.960  44.125  1.00 77.70           C  
ATOM   1974  CD  PRO   253      44.011  45.249  45.183  1.00 79.13           C  
ATOM   1975  N   ILE   254      47.343  42.562  43.304  1.00 66.91           N  
ATOM   1976  CA  ILE   254      48.777  42.367  43.375  1.00 61.43           C  
ATOM   1977  C   ILE   254      49.269  42.508  41.954  1.00 58.54           C  
ATOM   1978  O   ILE   254      48.566  42.180  41.011  1.00 56.58           O  
ATOM   1979  CB  ILE   254      49.166  40.978  43.946  1.00 61.07           C  
ATOM   1980  CG1 ILE   254      49.621  40.062  42.826  1.00 60.73           C  
ATOM   1981  CG2 ILE   254      47.990  40.355  44.709  1.00 59.15           C  
ATOM   1982  CD1 ILE   254      50.156  38.762  43.329  1.00 63.47           C  
ATOM   1983  N   PRO   255      50.493  42.996  41.772  1.00 56.44           N  
ATOM   1984  CA  PRO   255      50.894  43.113  40.379  1.00 55.05           C  
ATOM   1985  C   PRO   255      51.501  41.860  39.788  1.00 53.92           C  
ATOM   1986  O   PRO   255      52.014  40.989  40.496  1.00 52.18           O  
ATOM   1987  CB  PRO   255      51.849  44.309  40.389  1.00 55.63           C  
ATOM   1988  CG  PRO   255      52.358  44.397  41.805  1.00 54.87           C  
ATOM   1989  CD  PRO   255      51.530  43.492  42.685  1.00 55.03           C  
ATOM   1990  N   HIS   256      51.419  41.786  38.468  1.00 52.62           N  
ATOM   1991  CA  HIS   256      51.942  40.659  37.731  1.00 52.33           C  
ATOM   1992  C   HIS   256      52.236  41.094  36.307  1.00 52.34           C  
ATOM   1993  O   HIS   256      52.075  42.245  35.938  1.00 53.29           O  
ATOM   1994  CB  HIS   256      50.957  39.504  37.754  1.00 50.07           C  
ATOM   1995  CG  HIS   256      51.606  38.159  37.677  1.00 49.66           C  
ATOM   1996  ND1 HIS   256      51.227  37.116  38.491  1.00 49.27           N  
ATOM   1997  CD2 HIS   256      52.599  37.678  36.888  1.00 49.16           C  
ATOM   1998  CE1 HIS   256      51.957  36.050  38.210  1.00 50.08           C  
ATOM   1999  NE2 HIS   256      52.797  36.364  37.238  1.00 49.02           N  
ATOM   2000  N   LEU   257      52.584  40.139  35.487  1.00 53.39           N  
ATOM   2001  CA  LEU   257      53.028  40.397  34.159  1.00 57.25           C  
ATOM   2002  C   LEU   257      52.472  39.530  33.080  1.00 59.33           C  
ATOM   2003  O   LEU   257      52.679  38.328  33.142  1.00 59.19           O  
ATOM   2004  CB  LEU   257      54.464  40.068  34.093  1.00 58.52           C  
ATOM   2005  CG  LEU   257      55.325  40.949  34.924  1.00 60.98           C  
ATOM   2006  CD1 LEU   257      56.699  40.450  34.716  1.00 57.94           C  
ATOM   2007  CD2 LEU   257      55.241  42.329  34.351  1.00 58.77           C  
ATOM   2008  N   THR   258      51.890  40.111  32.039  1.00 60.58           N  
ATOM   2009  CA  THR   258      51.320  39.300  30.955  1.00 61.79           C  
ATOM   2010  C   THR   258      52.248  38.232  30.323  1.00 61.26           C  
ATOM   2011  O   THR   258      51.813  37.128  29.960  1.00 60.52           O  
ATOM   2012  CB  THR   258      50.808  40.171  29.840  1.00 61.37           C  
ATOM   2013  OG1 THR   258      51.913  40.842  29.238  1.00 62.19           O  
ATOM   2014  CG2 THR   258      49.854  41.202  30.400  1.00 61.30           C  
ATOM   2015  N   GLY   259      53.518  38.565  30.149  1.00 60.95           N  
ATOM   2016  CA  GLY   259      54.425  37.605  29.564  1.00 60.64           C  
ATOM   2017  C   GLY   259      54.480  36.333  30.375  1.00 60.95           C  
ATOM   2018  O   GLY   259      54.717  35.267  29.830  1.00 61.41           O  
ATOM   2019  N   LEU   260      54.246  36.433  31.680  1.00 62.35           N  
ATOM   2020  CA  LEU   260      54.310  35.265  32.549  1.00 62.18           C  
ATOM   2021  C   LEU   260      52.969  34.671  32.929  1.00 61.39           C  
ATOM   2022  O   LEU   260      52.893  33.875  33.877  1.00 61.82           O  
ATOM   2023  CB  LEU   260      55.072  35.606  33.822  1.00 65.44           C  
ATOM   2024  CG  LEU   260      56.521  36.068  33.650  1.00 67.85           C  
ATOM   2025  CD1 LEU   260      57.054  36.588  34.987  1.00 67.43           C  
ATOM   2026  CD2 LEU   260      57.366  34.902  33.123  1.00 68.59           C  
ATOM   2027  N   LEU   261      51.921  35.034  32.195  1.00 58.54           N  
ATOM   2028  CA  LEU   261      50.586  34.520  32.479  1.00 57.94           C  
ATOM   2029  C   LEU   261      49.949  33.772  31.297  1.00 58.83           C  
ATOM   2030  O   LEU   261      50.301  33.991  30.127  1.00 59.31           O  
ATOM   2031  CB  LEU   261      49.673  35.669  32.931  1.00 55.50           C  
ATOM   2032  CG  LEU   261      50.062  36.391  34.231  1.00 54.35           C  
ATOM   2033  CD1 LEU   261      49.209  37.635  34.407  1.00 51.98           C  
ATOM   2034  CD2 LEU   261      49.887  35.446  35.428  1.00 51.89           C  
ATOM   2035  N   VAL   262      49.011  32.886  31.614  1.00 57.57           N  
ATOM   2036  CA  VAL   262      48.325  32.102  30.601  1.00 58.59           C  
ATOM   2037  C   VAL   262      46.838  32.221  30.902  1.00 58.98           C  
ATOM   2038  O   VAL   262      46.377  31.788  31.954  1.00 59.19           O  
ATOM   2039  CB  VAL   262      48.794  30.609  30.658  1.00 59.44           C  
ATOM   2040  CG1 VAL   262      48.057  29.754  29.607  1.00 57.60           C  
ATOM   2041  CG2 VAL   262      50.300  30.543  30.424  1.00 57.04           C  
ATOM   2042  N   PRO   263      46.061  32.823  29.986  1.00 59.23           N  
ATOM   2043  CA  PRO   263      44.625  32.959  30.254  1.00 60.04           C  
ATOM   2044  C   PRO   263      43.937  31.633  30.485  1.00 59.35           C  
ATOM   2045  O   PRO   263      44.226  30.658  29.813  1.00 57.78           O  
ATOM   2046  CB  PRO   263      44.102  33.676  29.010  1.00 58.23           C  
ATOM   2047  CG  PRO   263      44.988  33.154  27.956  1.00 59.23           C  
ATOM   2048  CD  PRO   263      46.365  33.206  28.599  1.00 59.04           C  
ATOM   2049  N   VAL   264      43.041  31.605  31.463  1.00 61.05           N  
ATOM   2050  CA  VAL   264      42.285  30.395  31.765  1.00 64.21           C  
ATOM   2051  C   VAL   264      41.010  30.540  30.933  1.00 66.60           C  
ATOM   2052  O   VAL   264      40.094  31.287  31.296  1.00 66.66           O  
ATOM   2053  CB  VAL   264      41.982  30.289  33.301  1.00 62.79           C  
ATOM   2054  CG1 VAL   264      41.001  29.171  33.586  1.00 59.66           C  
ATOM   2055  CG2 VAL   264      43.281  30.021  34.055  1.00 60.54           C  
ATOM   2056  N   LEU   265      40.973  29.837  29.802  1.00 69.38           N  
ATOM   2057  CA  LEU   265      39.838  29.937  28.892  1.00 72.80           C  
ATOM   2058  C   LEU   265      38.579  29.196  29.315  1.00 75.02           C  
ATOM   2059  O   LEU   265      38.618  28.118  29.914  1.00 73.83           O  
ATOM   2060  CB  LEU   265      40.229  29.498  27.479  1.00 72.18           C  
ATOM   2061  CG  LEU   265      41.657  29.735  27.015  1.00 71.44           C  
ATOM   2062  CD1 LEU   265      42.550  28.748  27.751  1.00 74.08           C  
ATOM   2063  CD2 LEU   265      41.775  29.505  25.518  1.00 71.15           C  
END
