
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   60 (  464),  selected   60 , name 1va7_D
# Molecule2: number of CA atoms   88 (  675),  selected   88 , name T0487_178_265.pdb
# PARAMETERS: 1va7_D.T0487_178_265.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      S     178           -
LGA    -       -      L     179           -
LGA    -       -      E     180           -
LGA    -       -      A     181           -
LGA    -       -      W     182           -
LGA    -       -      L     183           -
LGA    -       -      A     184           -
LGA    -       -      Q     185           -
LGA    -       -      G     186           -
LGA    -       -      H     187           -
LGA    -       -      P     188           -
LGA    -       -      L     189           -
LGA    D     3_D      P     190           #
LGA    P     4_D      K     191          0.387
LGA    K     5_D      R     192          0.520
LGA    F     6_D      V     193          0.674
LGA    E     7_D      R     194          0.723
LGA    A     8_D      N     195          0.561
LGA    A     9_D      A     196          0.182
LGA    Y    10_D      Y     197          2.392
LGA    D    11_D      -       -           -
LGA    F    12_D      -       -           -
LGA    P    13_D      -       -           -
LGA    G    14_D      -       -           -
LGA    S    15_D      -       -           -
LGA    G    16_D      -       -           -
LGA    S    17_D      -       -           -
LGA    S    18_D      -       -           -
LGA    S    19_D      -       -           -
LGA    E    20_D      -       -           -
LGA    L    21_D      -       -           -
LGA    P    22_D      -       -           -
LGA    L    23_D      -       -           -
LGA    K    24_D      -       -           -
LGA    K    25_D      D     198          1.652
LGA    G    26_D      R     199          1.090
LGA    D    27_D      R     200          0.829
LGA    I    28_D      T     201          0.627
LGA    V    29_D      W     202          0.508
LGA    F    30_D      E     203          0.926
LGA    I    31_D      L     204          1.140
LGA    S    32_D      L     205          1.176
LGA    R    33_D      R     206          1.359
LGA    D    34_D      L     207          0.746
LGA    E    35_D      G     208          1.963
LGA    P    36_D      E     209          3.642
LGA    S    37_D      E     210          3.773
LGA    -       -      D     211           -
LGA    -       -      P     212           -
LGA    -       -      K     213           -
LGA    -       -      E     214           -
LGA    -       -      L     215           -
LGA    -       -      P     216           -
LGA    -       -      L     217           -
LGA    -       -      P     218           -
LGA    -       -      G     219           -
LGA    -       -      G     220           -
LGA    -       -      L     221           -
LGA    -       -      S     222           -
LGA    -       -      L     223           -
LGA    -       -      L     224           -
LGA    -       -      D     225           -
LGA    -       -      Y     226           -
LGA    -       -      H     227           -
LGA    -       -      A     228           -
LGA    -       -      S     229           -
LGA    -       -      K     230           -
LGA    -       -      G     231           -
LGA    -       -      R     232           -
LGA    -       -      L     233           -
LGA    -       -      Q     234           -
LGA    -       -      G     235           -
LGA    -       -      R     236           -
LGA    -       -      E     237           -
LGA    -       -      G     238           -
LGA    -       -      G     239           -
LGA    G    38_D      R     240          1.650
LGA    W    39_D      V     241          0.710
LGA    S    40_D      A     242          0.686
LGA    L    41_D      W     243          0.585
LGA    A    42_D      V     244          0.342
LGA    K    43_D      A     245          0.250
LGA    L    44_D      D     246          0.900
LGA    L    45_D      P     247          1.917
LGA    D    46_D      K     248          2.038
LGA    G    47_D      D     249          2.555
LGA    S    48_D      P     250          5.127
LGA    -       -      R     251           -
LGA    K    49_D      K     252          4.282
LGA    E    50_D      P     253          2.310
LGA    G    51_D      I     254          0.779
LGA    W    52_D      P     255          0.613
LGA    V    53_D      H     256          0.636
LGA    P    54_D      L     257          1.239
LGA    T    55_D      T     258          1.750
LGA    A    56_D      G     259          1.242
LGA    Y    57_D      L     260          1.101
LGA    M    58_D      L     261          1.388
LGA    T    59_D      V     262          1.326
LGA    P    60_D      P     263          0.945
LGA    Y    61_D      V     264          0.851
LGA    K    62_D      L     265          4.140

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   60   88    5.0     45    1.83    13.33     47.628     2.333

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.495090 * X  +  -0.171964 * Y  +  -0.851654 * Z  +  65.335228
  Y_new =   0.847941 * X  +   0.309339 * Y  +   0.430471 * Z  +  42.781960
  Z_new =   0.189424 * X  +  -0.935274 * Y  +   0.298966 * Z  +  27.046551 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.261405    1.880187  [ DEG:   -72.2732    107.7268 ]
  Theta =  -0.190576   -2.951017  [ DEG:   -10.9192   -169.0808 ]
  Phi   =   1.042319   -2.099274  [ DEG:    59.7205   -120.2795 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1va7_D                                        
REMARK     2: T0487_178_265.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1va7_D.T0487_178_265.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   60   88   5.0   45   1.83   13.33  47.628
REMARK  ---------------------------------------------------------- 
MOLECULE 1va7_D
HEADER    CONTRACTILE PROTEIN                     12-FEB-04   1VA7              
TITLE     YEAST MYO3 SH3 DOMAIN, TRICLINIC CRYSTAL FORM                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: MYOSIN-3 ISOFORM;                                          
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 FRAGMENT: SH3 DOMAIN;                                                
COMPND   5 SYNONYM: MYO3;                                                       
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SACCHAROMYCES CEREVISIAE;                       
SOURCE   3 ORGANISM_COMMON: YEAST;                                              
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PDEST17                                   
KEYWDS    STRUCTURAL GENOMICS, SH3 DOMAIN                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    P.KURSULA,F.LEHMANN,Y.H.SONG,M.WILMANNS                               
REVDAT   1   14-JUN-05 1VA7    0                                                
JRNL        AUTH   P.KURSULA,F.LEHMANN,Y.H.SONG,M.WILMANNS                      
JRNL        TITL   HIGH-THROUGHPUT STRUCTURAL GENOMICS OF YEAST SH3             
JRNL        TITL 2 DOMAINS                                                      
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.90 ANGSTROMS.                                          
DBREF  1VA7 A    2    70  UNP    P36006   MYO3_YEAST    1122   1190             
DBREF  1VA7 B    2    70  UNP    P36006   MYO3_YEAST    1122   1190             
DBREF  1VA7 C    2    70  UNP    P36006   MYO3_YEAST    1122   1190             
DBREF  1VA7 D    2    70  UNP    P36006   MYO3_YEAST    1122   1190             
SEQRES   1 A   70  GLY LYS ASP PRO LYS PHE GLU ALA ALA TYR ASP PHE PRO          
SEQRES   2 A   70  GLY SER GLY SER SER SER GLU LEU PRO LEU LYS LYS GLY          
SEQRES   3 A   70  ASP ILE VAL PHE ILE SER ARG ASP GLU PRO SER GLY TRP          
SEQRES   4 A   70  SER LEU ALA LYS LEU LEU ASP GLY SER LYS GLU GLY TRP          
SEQRES   5 A   70  VAL PRO THR ALA TYR MET THR PRO TYR LYS ASP THR ARG          
SEQRES   6 A   70  ASN THR VAL PRO VAL                                          
SEQRES   1 B   70  GLY LYS ASP PRO LYS PHE GLU ALA ALA TYR ASP PHE PRO          
SEQRES   2 B   70  GLY SER GLY SER SER SER GLU LEU PRO LEU LYS LYS GLY          
SEQRES   3 B   70  ASP ILE VAL PHE ILE SER ARG ASP GLU PRO SER GLY TRP          
SEQRES   4 B   70  SER LEU ALA LYS LEU LEU ASP GLY SER LYS GLU GLY TRP          
SEQRES   5 B   70  VAL PRO THR ALA TYR MET THR PRO TYR LYS ASP THR ARG          
SEQRES   6 B   70  ASN THR VAL PRO VAL                                          
SEQRES   1 C   70  GLY LYS ASP PRO LYS PHE GLU ALA ALA TYR ASP PHE PRO          
SEQRES   2 C   70  GLY SER GLY SER SER SER GLU LEU PRO LEU LYS LYS GLY          
SEQRES   3 C   70  ASP ILE VAL PHE ILE SER ARG ASP GLU PRO SER GLY TRP          
SEQRES   4 C   70  SER LEU ALA LYS LEU LEU ASP GLY SER LYS GLU GLY TRP          
SEQRES   5 C   70  VAL PRO THR ALA TYR MET THR PRO TYR LYS ASP THR ARG          
SEQRES   6 C   70  ASN THR VAL PRO VAL                                          
SEQRES   1 D   70  GLY LYS ASP PRO LYS PHE GLU ALA ALA TYR ASP PHE PRO          
SEQRES   2 D   70  GLY SER GLY SER SER SER GLU LEU PRO LEU LYS LYS GLY          
SEQRES   3 D   70  ASP ILE VAL PHE ILE SER ARG ASP GLU PRO SER GLY TRP          
SEQRES   4 D   70  SER LEU ALA LYS LEU LEU ASP GLY SER LYS GLU GLY TRP          
SEQRES   5 D   70  VAL PRO THR ALA TYR MET THR PRO TYR LYS ASP THR ARG          
SEQRES   6 D   70  ASN THR VAL PRO VAL                                          
HET    GOL      1       6                                                       
HET    GOL      2       6                                                       
HETNAM     GOL GLYCEROL                                                         
FORMUL   5  GOL    2(C3 H8 O3)                                                  
CRYST1   38.800   48.750   48.840  60.70  70.74  70.60 P 1           4          
ATOM   1522  N   ASP D   3      34.617  38.936  36.386  1.00  6.28           N  
ATOM   1523  CA  ASP D   3      35.977  39.024  35.777  1.00  6.88           C  
ATOM   1524  C   ASP D   3      36.465  37.669  35.202  1.00  7.12           C  
ATOM   1525  O   ASP D   3      35.964  36.598  35.598  1.00  7.36           O  
ATOM   1526  CB  ASP D   3      37.016  39.544  36.803  1.00  6.94           C  
ATOM   1527  CG  ASP D   3      37.207  41.063  36.748  1.00  7.20           C  
ATOM   1528  OD1 ASP D   3      38.093  41.562  37.486  1.00  7.02           O  
ATOM   1529  OD2 ASP D   3      36.536  41.829  36.011  1.00  6.95           O  
ATOM   1530  N   PRO D   4      37.424  37.732  34.263  1.00  6.91           N  
ATOM   1531  CA  PRO D   4      38.088  36.539  33.701  1.00  6.62           C  
ATOM   1532  C   PRO D   4      39.259  36.004  34.550  1.00  6.51           C  
ATOM   1533  O   PRO D   4      39.913  36.780  35.258  1.00  6.30           O  
ATOM   1534  CB  PRO D   4      38.601  37.051  32.355  1.00  6.74           C  
ATOM   1535  CG  PRO D   4      38.853  38.544  32.585  1.00  6.92           C  
ATOM   1536  CD  PRO D   4      37.886  38.982  33.625  1.00  6.83           C  
ATOM   1537  N   LYS D   5      39.524  34.696  34.439  1.00  6.54           N  
ATOM   1538  CA  LYS D   5      40.567  33.995  35.222  1.00  6.44           C  
ATOM   1539  C   LYS D   5      41.807  33.649  34.408  1.00  6.46           C  
ATOM   1540  O   LYS D   5      41.698  33.073  33.332  1.00  6.51           O  
ATOM   1541  CB  LYS D   5      40.025  32.676  35.759  1.00  6.33           C  
ATOM   1542  CG  LYS D   5      38.786  32.805  36.614  1.00  6.65           C  
ATOM   1543  CD  LYS D   5      38.235  31.442  36.950  1.00  6.55           C  
ATOM   1544  CE  LYS D   5      37.431  31.469  38.220  1.00  6.58           C  
ATOM   1545  NZ  LYS D   5      36.551  30.280  38.277  1.00  6.88           N  
ATOM   1546  N   PHE D   6      42.983  33.956  34.945  1.00  6.54           N  
ATOM   1547  CA  PHE D   6      44.250  33.743  34.244  1.00  6.50           C  
ATOM   1548  C   PHE D   6      45.181  32.824  35.060  1.00  6.67           C  
ATOM   1549  O   PHE D   6      45.136  32.813  36.295  1.00  6.57           O  
ATOM   1550  CB  PHE D   6      44.933  35.087  33.962  1.00  6.33           C  
ATOM   1551  CG  PHE D   6      44.270  35.890  32.874  1.00  6.45           C  
ATOM   1552  CD1 PHE D   6      44.846  35.993  31.611  1.00  6.88           C  
ATOM   1553  CD2 PHE D   6      43.070  36.557  33.109  1.00  6.29           C  
ATOM   1554  CE1 PHE D   6      44.221  36.735  30.593  1.00  6.66           C  
ATOM   1555  CE2 PHE D   6      42.454  37.293  32.106  1.00  6.16           C  
ATOM   1556  CZ  PHE D   6      43.031  37.377  30.845  1.00  6.33           C  
ATOM   1557  N   GLU D   7      46.012  32.060  34.350  1.00  6.65           N  
ATOM   1558  CA  GLU D   7      46.928  31.111  34.954  1.00  6.55           C  
ATOM   1559  C   GLU D   7      48.351  31.631  34.899  1.00  6.45           C  
ATOM   1560  O   GLU D   7      48.793  32.117  33.866  1.00  6.31           O  
ATOM   1561  CB  GLU D   7      46.844  29.757  34.241  1.00  6.52           C  
ATOM   1562  CG  GLU D   7      47.273  28.614  35.151  1.00  6.81           C  
ATOM   1563  CD  GLU D   7      47.508  27.303  34.428  1.00  6.87           C  
ATOM   1564  OE1 GLU D   7      46.645  26.893  33.626  1.00  7.53           O  
ATOM   1565  OE2 GLU D   7      48.551  26.668  34.680  1.00  6.72           O  
ATOM   1566  N   ALA D   8      49.066  31.518  36.017  1.00  6.57           N  
ATOM   1567  CA  ALA D   8      50.492  31.833  36.064  1.00  6.46           C  
ATOM   1568  C   ALA D   8      51.235  30.735  35.329  1.00  6.35           C  
ATOM   1569  O   ALA D   8      51.081  29.559  35.645  1.00  6.11           O  
ATOM   1570  CB  ALA D   8      50.983  31.937  37.504  1.00  6.31           C  
ATOM   1571  N   ALA D   9      52.024  31.140  34.336  1.00  6.40           N  
ATOM   1572  CA  ALA D   9      52.825  30.224  33.529  1.00  6.37           C  
ATOM   1573  C   ALA D   9      54.259  30.171  34.045  1.00  6.43           C  
ATOM   1574  O   ALA D   9      54.996  29.224  33.747  1.00  6.42           O  
ATOM   1575  CB  ALA D   9      52.811  30.657  32.077  1.00  6.37           C  
ATOM   1576  N   TYR D  10      54.658  31.193  34.806  1.00  6.40           N  
ATOM   1577  CA  TYR D  10      55.965  31.203  35.440  1.00  6.35           C  
ATOM   1578  C   TYR D  10      55.823  31.639  36.888  1.00  6.27           C  
ATOM   1579  O   TYR D  10      54.911  32.395  37.221  1.00  5.93           O  
ATOM   1580  CB  TYR D  10      56.924  32.189  34.753  1.00  6.44           C  
ATOM   1581  CG  TYR D  10      57.160  32.049  33.264  1.00  5.97           C  
ATOM   1582  CD1 TYR D  10      58.349  31.549  32.785  1.00  6.15           C  
ATOM   1583  CD2 TYR D  10      56.223  32.496  32.338  1.00  6.50           C  
ATOM   1584  CE1 TYR D  10      58.600  31.454  31.415  1.00  6.38           C  
ATOM   1585  CE2 TYR D  10      56.450  32.402  30.968  1.00  6.11           C  
ATOM   1586  CZ  TYR D  10      57.639  31.882  30.510  1.00  6.25           C  
ATOM   1587  OH  TYR D  10      57.868  31.789  29.152  1.00  6.40           O  
ATOM   1588  N   ASP D  11      56.761  31.184  37.723  1.00  6.37           N  
ATOM   1589  CA  ASP D  11      56.991  31.765  39.048  1.00  6.33           C  
ATOM   1590  C   ASP D  11      57.295  33.258  38.964  1.00  6.27           C  
ATOM   1591  O   ASP D  11      58.007  33.712  38.070  1.00  6.25           O  
ATOM   1592  CB  ASP D  11      58.171  31.085  39.748  1.00  6.21           C  
ATOM   1593  CG  ASP D  11      57.869  29.676  40.142  1.00  6.40           C  
ATOM   1594  OD1 ASP D  11      56.786  29.219  39.778  1.00  6.80           O  
ATOM   1595  OD2 ASP D  11      58.633  28.947  40.813  1.00  6.41           O  
ATOM   1596  N   PHE D  12      56.743  34.001  39.916  1.00  6.29           N  
ATOM   1597  CA  PHE D  12      57.033  35.410  40.110  1.00  6.16           C  
ATOM   1598  C   PHE D  12      57.216  35.620  41.605  1.00  6.23           C  
ATOM   1599  O   PHE D  12      56.284  36.007  42.298  1.00  6.17           O  
ATOM   1600  CB  PHE D  12      55.892  36.284  39.566  1.00  6.27           C  
ATOM   1601  CG  PHE D  12      56.052  37.732  39.869  1.00  5.76           C  
ATOM   1602  CD1 PHE D  12      57.102  38.432  39.346  1.00  6.33           C  
ATOM   1603  CD2 PHE D  12      55.176  38.387  40.700  1.00  5.88           C  
ATOM   1604  CE1 PHE D  12      57.277  39.789  39.638  1.00  6.34           C  
ATOM   1605  CE2 PHE D  12      55.350  39.730  41.000  1.00  6.42           C  
ATOM   1606  CZ  PHE D  12      56.402  40.431  40.457  1.00  6.04           C  
ATOM   1607  N   PRO D  13      58.416  35.343  42.114  1.00  6.52           N  
ATOM   1608  CA  PRO D  13      58.728  35.582  43.527  1.00  6.58           C  
ATOM   1609  C   PRO D  13      58.829  37.063  43.817  1.00  6.78           C  
ATOM   1610  O   PRO D  13      58.782  37.401  44.993  1.00  7.11           O  
ATOM   1611  CB  PRO D  13      60.082  34.914  43.733  1.00  6.37           C  
ATOM   1612  CG  PRO D  13      60.572  34.538  42.422  1.00  6.45           C  
ATOM   1613  CD  PRO D  13      59.566  34.811  41.383  1.00  6.50           C  
ATOM   1614  N   GLY D  14      58.975  37.906  42.791  1.00  6.65           N  
ATOM   1615  CA  GLY D  14      58.957  39.347  42.970  1.00  6.65           C  
ATOM   1616  C   GLY D  14      60.156  39.934  43.722  1.00  6.64           C  
ATOM   1617  O   GLY D  14      61.246  39.363  43.721  1.00  6.55           O  
ATOM   1618  N   SER D  15      59.948  41.105  44.328  1.00  6.63           N  
ATOM   1619  CA  SER D  15      60.968  41.818  45.118  1.00  6.48           C  
ATOM   1620  C   SER D  15      60.674  41.874  46.618  1.00  6.51           C  
ATOM   1621  O   SER D  15      61.559  42.205  47.413  1.00  6.51           O  
ATOM   1622  CB  SER D  15      61.125  43.259  44.625  1.00  6.34           C  
ATOM   1623  OG  SER D  15      60.191  44.115  45.247  1.00  5.06           O  
ATOM   1624  N   GLY D  16      59.430  41.574  46.991  1.00  6.40           N  
ATOM   1625  CA  GLY D  16      58.987  41.654  48.371  1.00  6.22           C  
ATOM   1626  C   GLY D  16      58.002  42.785  48.626  1.00  6.14           C  
ATOM   1627  O   GLY D  16      57.436  42.891  49.710  1.00  5.80           O  
ATOM   1628  N   SER D  17      57.782  43.617  47.614  1.00  6.34           N  
ATOM   1629  CA  SER D  17      56.865  44.757  47.694  1.00  6.34           C  
ATOM   1630  C   SER D  17      55.434  44.293  47.951  1.00  6.28           C  
ATOM   1631  O   SER D  17      55.026  43.245  47.459  1.00  6.52           O  
ATOM   1632  CB  SER D  17      56.912  45.537  46.370  1.00  6.46           C  
ATOM   1633  OG  SER D  17      56.158  46.748  46.400  1.00  6.68           O  
ATOM   1634  N   SER D  18      54.677  45.090  48.696  1.00  6.23           N  
ATOM   1635  CA  SER D  18      53.261  44.807  48.975  1.00  6.41           C  
ATOM   1636  C   SER D  18      52.339  45.291  47.818  1.00  6.77           C  
ATOM   1637  O   SER D  18      51.122  45.053  47.847  1.00  6.94           O  
ATOM   1638  CB  SER D  18      52.836  45.467  50.284  1.00  6.28           C  
ATOM   1639  OG  SER D  18      53.157  46.843  50.279  1.00  6.41           O  
ATOM   1640  N   SER D  19      52.936  45.986  46.838  1.00  6.57           N  
ATOM   1641  CA  SER D  19      52.288  46.353  45.598  1.00  6.42           C  
ATOM   1642  C   SER D  19      52.319  45.186  44.636  1.00  6.51           C  
ATOM   1643  O   SER D  19      51.655  45.210  43.588  1.00  6.63           O  
ATOM   1644  CB  SER D  19      52.992  47.548  44.956  1.00  6.42           C  
ATOM   1645  OG  SER D  19      52.619  48.743  45.617  1.00  6.72           O  
ATOM   1646  N   GLU D  20      53.105  44.170  44.973  1.00  6.42           N  
ATOM   1647  CA  GLU D  20      53.296  42.999  44.113  1.00  6.46           C  
ATOM   1648  C   GLU D  20      52.449  41.870  44.652  1.00  6.17           C  
ATOM   1649  O   GLU D  20      52.223  41.802  45.829  1.00  6.39           O  
ATOM   1650  CB  GLU D  20      54.771  42.571  44.117  1.00  6.49           C  
ATOM   1651  CG  GLU D  20      55.636  43.203  43.031  1.00  6.76           C  
ATOM   1652  CD  GLU D  20      57.127  43.340  43.442  1.00  6.87           C  
ATOM   1653  OE1 GLU D  20      57.586  42.564  44.305  1.00  6.90           O  
ATOM   1654  OE2 GLU D  20      57.846  44.230  42.909  1.00  6.60           O  
ATOM   1655  N   LEU D  21      51.968  40.997  43.789  1.00  6.12           N  
ATOM   1656  CA  LEU D  21      51.354  39.768  44.220  1.00  6.12           C  
ATOM   1657  C   LEU D  21      52.302  38.688  43.778  1.00  6.21           C  
ATOM   1658  O   LEU D  21      52.398  38.446  42.571  1.00  6.14           O  
ATOM   1659  CB  LEU D  21      50.003  39.561  43.564  1.00  6.24           C  
ATOM   1660  CG  LEU D  21      49.242  38.296  43.993  1.00  6.35           C  
ATOM   1661  CD1 LEU D  21      48.573  38.519  45.317  1.00  6.68           C  
ATOM   1662  CD2 LEU D  21      48.198  37.905  42.980  1.00  6.76           C  
ATOM   1663  N   PRO D  22      53.017  38.068  44.728  1.00  6.05           N  
ATOM   1664  CA  PRO D  22      53.886  36.926  44.441  1.00  6.08           C  
ATOM   1665  C   PRO D  22      53.120  35.679  44.004  1.00  6.04           C  
ATOM   1666  O   PRO D  22      52.163  35.289  44.676  1.00  6.01           O  
ATOM   1667  CB  PRO D  22      54.560  36.656  45.786  1.00  6.32           C  
ATOM   1668  CG  PRO D  22      54.353  37.854  46.589  1.00  6.27           C  
ATOM   1669  CD  PRO D  22      53.070  38.431  46.149  1.00  6.05           C  
ATOM   1670  N   LEU D  23      53.549  35.061  42.905  1.00  6.13           N  
ATOM   1671  CA  LEU D  23      52.878  33.877  42.350  1.00  6.41           C  
ATOM   1672  C   LEU D  23      53.784  32.645  42.316  1.00  6.21           C  
ATOM   1673  O   LEU D  23      55.000  32.760  42.316  1.00  6.27           O  
ATOM   1674  CB  LEU D  23      52.369  34.177  40.918  1.00  6.34           C  
ATOM   1675  CG  LEU D  23      51.288  35.276  40.804  1.00  6.86           C  
ATOM   1676  CD1 LEU D  23      51.304  35.960  39.395  1.00  6.73           C  
ATOM   1677  CD2 LEU D  23      49.894  34.729  41.151  1.00  6.91           C  
ATOM   1678  N   LYS D  24      53.179  31.468  42.299  1.00  6.13           N  
ATOM   1679  CA  LYS D  24      53.865  30.277  41.806  1.00  6.45           C  
ATOM   1680  C   LYS D  24      53.263  29.899  40.451  1.00  6.38           C  
ATOM   1681  O   LYS D  24      52.259  30.445  40.044  1.00  6.74           O  
ATOM   1682  CB  LYS D  24      53.759  29.114  42.807  1.00  6.50           C  
ATOM   1683  CG  LYS D  24      54.440  29.368  44.167  1.00  6.60           C  
ATOM   1684  CD  LYS D  24      55.934  29.709  44.034  1.00  6.58           C  
ATOM   1685  CE  LYS D  24      56.684  29.496  45.350  1.00  6.95           C  
ATOM   1686  NZ  LYS D  24      58.106  29.085  45.141  1.00  7.03           N  
ATOM   1687  N   LYS D  25      53.875  28.957  39.757  1.00  6.38           N  
ATOM   1688  CA  LYS D  25      53.348  28.473  38.491  1.00  6.29           C  
ATOM   1689  C   LYS D  25      52.111  27.611  38.716  1.00  6.26           C  
ATOM   1690  O   LYS D  25      52.091  26.761  39.605  1.00  6.26           O  
ATOM   1691  CB  LYS D  25      54.411  27.647  37.776  1.00  6.48           C  
ATOM   1692  CG  LYS D  25      54.092  27.370  36.333  1.00  6.64           C  
ATOM   1693  CD  LYS D  25      55.130  26.467  35.689  1.00  6.62           C  
ATOM   1694  CE  LYS D  25      54.607  25.966  34.335  1.00  7.04           C  
ATOM   1695  NZ  LYS D  25      53.482  24.950  34.423  1.00  6.52           N  
ATOM   1696  N   GLY D  26      51.082  27.830  37.899  1.00  6.41           N  
ATOM   1697  CA  GLY D  26      49.828  27.090  37.997  1.00  6.39           C  
ATOM   1698  C   GLY D  26      48.779  27.757  38.879  1.00  6.38           C  
ATOM   1699  O   GLY D  26      47.652  27.262  38.984  1.00  6.52           O  
ATOM   1700  N   ASP D  27      49.160  28.866  39.523  1.00  6.34           N  
ATOM   1701  CA  ASP D  27      48.263  29.693  40.334  1.00  6.14           C  
ATOM   1702  C   ASP D  27      47.211  30.299  39.435  1.00  6.02           C  
ATOM   1703  O   ASP D  27      47.463  30.584  38.275  1.00  5.55           O  
ATOM   1704  CB  ASP D  27      49.025  30.844  41.020  1.00  6.14           C  
ATOM   1705  CG  ASP D  27      49.682  30.439  42.338  1.00  6.21           C  
ATOM   1706  OD1 ASP D  27      49.859  29.244  42.625  1.00  6.29           O  
ATOM   1707  OD2 ASP D  27      50.069  31.278  43.167  1.00  6.45           O  
ATOM   1708  N   ILE D  28      46.026  30.507  39.983  1.00  6.33           N  
ATOM   1709  CA  ILE D  28      44.909  31.056  39.212  1.00  6.37           C  
ATOM   1710  C   ILE D  28      44.361  32.319  39.878  1.00  6.19           C  
ATOM   1711  O   ILE D  28      44.041  32.316  41.065  1.00  5.90           O  
ATOM   1712  CB  ILE D  28      43.808  29.996  39.025  1.00  6.41           C  
ATOM   1713  CG1 ILE D  28      44.382  28.787  38.278  1.00  6.51           C  
ATOM   1714  CG2 ILE D  28      42.626  30.574  38.228  1.00  6.45           C  
ATOM   1715  CD1 ILE D  28      43.569  27.528  38.430  1.00  6.76           C  
ATOM   1716  N   VAL D  29      44.264  33.393  39.102  1.00  6.18           N  
ATOM   1717  CA  VAL D  29      43.859  34.696  39.620  1.00  6.33           C  
ATOM   1718  C   VAL D  29      42.843  35.349  38.700  1.00  6.10           C  
ATOM   1719  O   VAL D  29      42.557  34.853  37.618  1.00  5.66           O  
ATOM   1720  CB  VAL D  29      45.077  35.653  39.806  1.00  6.49           C  
ATOM   1721  CG1 VAL D  29      46.082  35.075  40.812  1.00  6.48           C  
ATOM   1722  CG2 VAL D  29      45.777  35.928  38.479  1.00  6.65           C  
ATOM   1723  N   PHE D  30      42.264  36.436  39.184  1.00  6.20           N  
ATOM   1724  CA  PHE D  30      41.448  37.317  38.368  1.00  6.34           C  
ATOM   1725  C   PHE D  30      42.320  38.449  37.910  1.00  6.23           C  
ATOM   1726  O   PHE D  30      43.329  38.751  38.523  1.00  6.65           O  
ATOM   1727  CB  PHE D  30      40.311  37.910  39.180  1.00  6.48           C  
ATOM   1728  CG  PHE D  30      39.267  36.919  39.583  1.00  6.51           C  
ATOM   1729  CD1 PHE D  30      38.450  36.330  38.632  1.00  6.41           C  
ATOM   1730  CD2 PHE D  30      39.084  36.598  40.923  1.00  6.39           C  
ATOM   1731  CE1 PHE D  30      37.481  35.423  39.003  1.00  6.42           C  
ATOM   1732  CE2 PHE D  30      38.111  35.699  41.306  1.00  6.35           C  
ATOM   1733  CZ  PHE D  30      37.305  35.106  40.344  1.00  6.51           C  
ATOM   1734  N   ILE D  31      41.940  39.075  36.824  1.00  6.13           N  
ATOM   1735  CA  ILE D  31      42.673  40.222  36.345  1.00  6.37           C  
ATOM   1736  C   ILE D  31      41.682  41.334  35.996  1.00  6.35           C  
ATOM   1737  O   ILE D  31      40.762  41.160  35.165  1.00  6.16           O  
ATOM   1738  CB  ILE D  31      43.551  39.833  35.131  1.00  6.52           C  
ATOM   1739  CG1 ILE D  31      44.521  38.732  35.546  1.00  6.11           C  
ATOM   1740  CG2 ILE D  31      44.252  41.090  34.529  1.00  6.57           C  
ATOM   1741  CD1 ILE D  31      45.910  38.834  34.979  1.00  6.64           C  
ATOM   1742  N   SER D  32      41.880  42.467  36.657  1.00  6.14           N  
ATOM   1743  CA  SER D  32      41.016  43.600  36.488  1.00  6.32           C  
ATOM   1744  C   SER D  32      41.623  44.639  35.542  1.00  6.37           C  
ATOM   1745  O   SER D  32      40.890  45.288  34.766  1.00  6.20           O  
ATOM   1746  CB  SER D  32      40.717  44.207  37.851  1.00  6.28           C  
ATOM   1747  OG  SER D  32      41.809  44.949  38.325  1.00  6.16           O  
ATOM   1748  N   ARG D  33      42.950  44.795  35.609  1.00  6.31           N  
ATOM   1749  CA  ARG D  33      43.661  45.800  34.795  1.00  6.37           C  
ATOM   1750  C   ARG D  33      44.939  45.302  34.169  1.00  6.31           C  
ATOM   1751  O   ARG D  33      45.702  44.617  34.817  1.00  6.77           O  
ATOM   1752  CB  ARG D  33      44.088  46.977  35.643  1.00  6.24           C  
ATOM   1753  CG  ARG D  33      42.989  47.646  36.384  1.00  6.55           C  
ATOM   1754  CD  ARG D  33      43.498  48.710  37.316  1.00  6.54           C  
ATOM   1755  NE  ARG D  33      44.331  49.693  36.615  1.00  7.04           N  
ATOM   1756  CZ  ARG D  33      44.880  50.769  37.187  1.00  7.40           C  
ATOM   1757  NH1 ARG D  33      44.694  51.024  38.486  1.00  7.50           N  
ATOM   1758  NH2 ARG D  33      45.622  51.595  36.457  1.00  7.46           N  
ATOM   1759  N   ASP D  34      45.160  45.665  32.909  1.00  6.43           N  
ATOM   1760  CA  ASP D  34      46.458  45.546  32.249  1.00  6.40           C  
ATOM   1761  C   ASP D  34      46.952  46.969  31.951  1.00  6.47           C  
ATOM   1762  O   ASP D  34      46.159  47.825  31.477  1.00  6.44           O  
ATOM   1763  CB  ASP D  34      46.334  44.774  30.928  1.00  6.32           C  
ATOM   1764  CG  ASP D  34      45.565  43.463  31.073  1.00  6.76           C  
ATOM   1765  OD1 ASP D  34      46.028  42.546  31.819  1.00  6.80           O  
ATOM   1766  OD2 ASP D  34      44.479  43.262  30.470  1.00  6.73           O  
ATOM   1767  N   GLU D  35      48.241  47.216  32.218  1.00  6.27           N  
ATOM   1768  CA  GLU D  35      48.857  48.515  31.964  1.00  6.30           C  
ATOM   1769  C   GLU D  35      49.945  48.388  30.906  1.00  6.30           C  
ATOM   1770  O   GLU D  35      50.473  47.298  30.723  1.00  6.28           O  
ATOM   1771  CB  GLU D  35      49.431  49.094  33.248  1.00  6.28           C  
ATOM   1772  CG  GLU D  35      48.402  49.784  34.133  1.00  6.74           C  
ATOM   1773  CD  GLU D  35      48.900  51.113  34.700  1.00  7.50           C  
ATOM   1774  OE1 GLU D  35      49.996  51.114  35.326  1.00  7.93           O  
ATOM   1775  OE2 GLU D  35      48.209  52.158  34.533  1.00  7.15           O  
ATOM   1776  N   PRO D  36      50.274  49.487  30.205  1.00  6.51           N  
ATOM   1777  CA  PRO D  36      51.313  49.456  29.163  1.00  6.39           C  
ATOM   1778  C   PRO D  36      52.753  49.242  29.695  1.00  6.31           C  
ATOM   1779  O   PRO D  36      53.603  48.794  28.934  1.00  6.25           O  
ATOM   1780  CB  PRO D  36      51.165  50.828  28.471  1.00  6.22           C  
ATOM   1781  CG  PRO D  36      50.501  51.714  29.449  1.00  6.00           C  
ATOM   1782  CD  PRO D  36      49.699  50.844  30.352  1.00  6.48           C  
ATOM   1783  N   SER D  37      53.019  49.551  30.962  1.00  6.32           N  
ATOM   1784  CA  SER D  37      54.298  49.220  31.600  1.00  6.44           C  
ATOM   1785  C   SER D  37      54.651  47.728  31.481  1.00  6.53           C  
ATOM   1786  O   SER D  37      55.825  47.344  31.554  1.00  6.68           O  
ATOM   1787  CB  SER D  37      54.237  49.583  33.084  1.00  6.54           C  
ATOM   1788  OG  SER D  37      53.163  48.899  33.705  1.00  6.55           O  
ATOM   1789  N   GLY D  38      53.620  46.900  31.332  1.00  6.45           N  
ATOM   1790  CA  GLY D  38      53.762  45.466  31.220  1.00  6.36           C  
ATOM   1791  C   GLY D  38      53.200  44.738  32.416  1.00  6.44           C  
ATOM   1792  O   GLY D  38      53.455  43.543  32.529  1.00  6.82           O  
ATOM   1793  N   TRP D  39      52.446  45.429  33.282  1.00  6.36           N  
ATOM   1794  CA  TRP D  39      51.927  44.849  34.530  1.00  6.32           C  
ATOM   1795  C   TRP D  39      50.397  44.665  34.479  1.00  6.19           C  
ATOM   1796  O   TRP D  39      49.680  45.425  33.814  1.00  5.83           O  
ATOM   1797  CB  TRP D  39      52.300  45.735  35.728  1.00  6.36           C  
ATOM   1798  CG  TRP D  39      53.764  45.794  36.058  1.00  6.12           C  
ATOM   1799  CD1 TRP D  39      54.655  46.742  35.650  1.00  5.91           C  
ATOM   1800  CD2 TRP D  39      54.503  44.885  36.879  1.00  6.14           C  
ATOM   1801  NE1 TRP D  39      55.902  46.476  36.158  1.00  6.00           N  
ATOM   1802  CE2 TRP D  39      55.842  45.342  36.919  1.00  6.16           C  
ATOM   1803  CE3 TRP D  39      54.174  43.726  37.590  1.00  6.42           C  
ATOM   1804  CZ2 TRP D  39      56.841  44.686  37.635  1.00  6.15           C  
ATOM   1805  CZ3 TRP D  39      55.175  43.064  38.309  1.00  6.21           C  
ATOM   1806  CH2 TRP D  39      56.490  43.555  38.328  1.00  6.15           C  
ATOM   1807  N   SER D  40      49.923  43.652  35.203  1.00  6.02           N  
ATOM   1808  CA  SER D  40      48.504  43.349  35.321  1.00  6.04           C  
ATOM   1809  C   SER D  40      48.088  43.270  36.774  1.00  6.22           C  
ATOM   1810  O   SER D  40      48.762  42.629  37.598  1.00  6.42           O  
ATOM   1811  CB  SER D  40      48.188  42.012  34.661  1.00  5.96           C  
ATOM   1812  OG  SER D  40      47.820  42.173  33.302  1.00  5.94           O  
ATOM   1813  N   LEU D  41      46.961  43.898  37.095  1.00  6.35           N  
ATOM   1814  CA  LEU D  41      46.462  43.890  38.467  1.00  6.44           C  
ATOM   1815  C   LEU D  41      45.661  42.618  38.770  1.00  6.26           C  
ATOM   1816  O   LEU D  41      44.527  42.463  38.310  1.00  6.07           O  
ATOM   1817  CB  LEU D  41      45.643  45.150  38.752  1.00  6.21           C  
ATOM   1818  CG  LEU D  41      45.383  45.361  40.245  1.00  6.56           C  
ATOM   1819  CD1 LEU D  41      46.704  45.554  41.065  1.00  6.86           C  
ATOM   1820  CD2 LEU D  41      44.435  46.517  40.456  1.00  6.33           C  
ATOM   1821  N   ALA D  42      46.269  41.726  39.553  1.00  6.14           N  
ATOM   1822  CA  ALA D  42      45.719  40.395  39.818  1.00  6.18           C  
ATOM   1823  C   ALA D  42      45.116  40.316  41.176  1.00  6.11           C  
ATOM   1824  O   ALA D  42      45.578  40.951  42.081  1.00  6.42           O  
ATOM   1825  CB  ALA D  42      46.785  39.380  39.727  1.00  6.40           C  
ATOM   1826  N   LYS D  43      44.080  39.513  41.320  1.00  6.29           N  
ATOM   1827  CA  LYS D  43      43.438  39.267  42.619  1.00  6.42           C  
ATOM   1828  C   LYS D  43      43.324  37.750  42.829  1.00  6.42           C  
ATOM   1829  O   LYS D  43      42.970  37.027  41.900  1.00  6.69           O  
ATOM   1830  CB  LYS D  43      42.041  39.907  42.638  1.00  6.47           C  
ATOM   1831  CG  LYS D  43      41.524  40.245  44.029  1.00  6.82           C  
ATOM   1832  CD  LYS D  43      40.225  41.092  44.001  1.00  6.85           C  
ATOM   1833  CE  LYS D  43      39.711  41.379  45.450  1.00  7.14           C  
ATOM   1834  NZ  LYS D  43      38.250  41.749  45.569  1.00  6.62           N  
ATOM   1835  N   LEU D  44      43.622  37.242  44.018  1.00  6.23           N  
ATOM   1836  CA  LEU D  44      43.400  35.816  44.261  1.00  6.38           C  
ATOM   1837  C   LEU D  44      41.903  35.502  44.116  1.00  6.38           C  
ATOM   1838  O   LEU D  44      41.077  36.405  44.126  1.00  6.47           O  
ATOM   1839  CB  LEU D  44      43.917  35.390  45.639  1.00  6.51           C  
ATOM   1840  CG  LEU D  44      45.414  35.520  45.946  1.00  6.32           C  
ATOM   1841  CD1 LEU D  44      45.761  34.874  47.266  1.00  6.48           C  
ATOM   1842  CD2 LEU D  44      46.239  34.911  44.851  1.00  6.54           C  
ATOM   1843  N   LEU D  45      41.564  34.226  43.962  1.00  6.39           N  
ATOM   1844  CA  LEU D  45      40.175  33.820  43.723  1.00  6.35           C  
ATOM   1845  C   LEU D  45      39.269  34.019  44.934  1.00  6.48           C  
ATOM   1846  O   LEU D  45      38.081  34.311  44.775  1.00  6.67           O  
ATOM   1847  CB  LEU D  45      40.098  32.356  43.291  1.00  6.40           C  
ATOM   1848  CG  LEU D  45      40.789  31.983  41.985  1.00  6.51           C  
ATOM   1849  CD1 LEU D  45      40.471  30.529  41.649  1.00  6.47           C  
ATOM   1850  CD2 LEU D  45      40.395  32.911  40.835  1.00  6.51           C  
ATOM   1851  N   ASP D  46      39.818  33.849  46.136  1.00  6.45           N  
ATOM   1852  CA  ASP D  46      39.062  34.107  47.355  1.00  6.27           C  
ATOM   1853  C   ASP D  46      39.016  35.593  47.735  1.00  6.20           C  
ATOM   1854  O   ASP D  46      38.342  35.964  48.677  1.00  6.22           O  
ATOM   1855  CB  ASP D  46      39.583  33.247  48.511  1.00  6.31           C  
ATOM   1856  CG  ASP D  46      41.017  33.571  48.917  1.00  6.30           C  
ATOM   1857  OD1 ASP D  46      41.658  34.453  48.320  1.00  5.84           O  
ATOM   1858  OD2 ASP D  46      41.591  32.972  49.848  1.00  6.59           O  
ATOM   1859  N   GLY D  47      39.728  36.436  46.993  1.00  6.35           N  
ATOM   1860  CA  GLY D  47      39.683  37.884  47.171  1.00  6.39           C  
ATOM   1861  C   GLY D  47      40.560  38.432  48.292  1.00  6.37           C  
ATOM   1862  O   GLY D  47      40.471  39.617  48.629  1.00  6.34           O  
ATOM   1863  N   SER D  48      41.435  37.583  48.832  1.00  6.31           N  
ATOM   1864  CA  SER D  48      42.189  37.883  50.057  1.00  6.29           C  
ATOM   1865  C   SER D  48      43.414  38.787  49.867  1.00  6.34           C  
ATOM   1866  O   SER D  48      43.831  39.482  50.797  1.00  6.18           O  
ATOM   1867  CB  SER D  48      42.613  36.571  50.738  1.00  6.21           C  
ATOM   1868  OG  SER D  48      43.549  35.838  49.969  1.00  5.96           O  
ATOM   1869  N   LYS D  49      44.003  38.745  48.673  1.00  6.62           N  
ATOM   1870  CA  LYS D  49      45.165  39.580  48.328  1.00  6.57           C  
ATOM   1871  C   LYS D  49      45.084  40.121  46.915  1.00  6.54           C  
ATOM   1872  O   LYS D  49      44.655  39.421  46.003  1.00  6.81           O  
ATOM   1873  CB  LYS D  49      46.465  38.793  48.488  1.00  6.48           C  
ATOM   1874  CG  LYS D  49      46.766  38.477  49.933  1.00  6.64           C  
ATOM   1875  CD  LYS D  49      48.193  38.018  50.140  1.00  6.75           C  
ATOM   1876  CE  LYS D  49      48.356  37.420  51.551  1.00  6.85           C  
ATOM   1877  NZ  LYS D  49      49.528  36.515  51.660  1.00  7.00           N  
ATOM   1878  N   GLU D  50      45.499  41.375  46.757  1.00  6.58           N  
ATOM   1879  CA  GLU D  50      45.528  42.059  45.464  1.00  6.43           C  
ATOM   1880  C   GLU D  50      46.916  42.696  45.261  1.00  6.40           C  
ATOM   1881  O   GLU D  50      47.465  43.339  46.163  1.00  6.24           O  
ATOM   1882  CB  GLU D  50      44.416  43.117  45.380  1.00  6.27           C  
ATOM   1883  CG  GLU D  50      44.286  43.779  44.015  1.00  6.44           C  
ATOM   1884  CD  GLU D  50      43.094  44.726  43.907  1.00  6.96           C  
ATOM   1885  OE1 GLU D  50      43.052  45.718  44.672  1.00  7.55           O  
ATOM   1886  OE2 GLU D  50      42.198  44.491  43.058  1.00  6.57           O  
ATOM   1887  N   GLY D  51      47.477  42.508  44.070  1.00  6.44           N  
ATOM   1888  CA  GLY D  51      48.776  43.064  43.724  1.00  6.33           C  
ATOM   1889  C   GLY D  51      49.228  42.790  42.301  1.00  6.28           C  
ATOM   1890  O   GLY D  51      48.787  41.835  41.654  1.00  6.36           O  
ATOM   1891  N   TRP D  52      50.152  43.612  41.828  1.00  6.24           N  
ATOM   1892  CA  TRP D  52      50.524  43.601  40.417  1.00  6.42           C  
ATOM   1893  C   TRP D  52      51.391  42.412  40.077  1.00  6.49           C  
ATOM   1894  O   TRP D  52      52.196  41.972  40.876  1.00  6.78           O  
ATOM   1895  CB  TRP D  52      51.288  44.861  40.054  1.00  6.42           C  
ATOM   1896  CG  TRP D  52      50.491  46.109  40.134  1.00  6.49           C  
ATOM   1897  CD1 TRP D  52      50.420  46.979  41.198  1.00  6.27           C  
ATOM   1898  CD2 TRP D  52      49.665  46.667  39.105  1.00  6.48           C  
ATOM   1899  NE1 TRP D  52      49.592  48.030  40.887  1.00  6.86           N  
ATOM   1900  CE2 TRP D  52      49.124  47.875  39.605  1.00  6.70           C  
ATOM   1901  CE3 TRP D  52      49.330  46.276  37.802  1.00  6.40           C  
ATOM   1902  CZ2 TRP D  52      48.260  48.681  38.851  1.00  6.31           C  
ATOM   1903  CZ3 TRP D  52      48.484  47.080  37.055  1.00  6.11           C  
ATOM   1904  CH2 TRP D  52      47.958  48.261  37.583  1.00  6.44           C  
ATOM   1905  N   VAL D  53      51.232  41.917  38.858  1.00  6.67           N  
ATOM   1906  CA  VAL D  53      52.019  40.805  38.345  1.00  6.47           C  
ATOM   1907  C   VAL D  53      52.443  41.086  36.897  1.00  6.34           C  
ATOM   1908  O   VAL D  53      51.868  41.929  36.200  1.00  5.92           O  
ATOM   1909  CB  VAL D  53      51.217  39.495  38.404  1.00  6.71           C  
ATOM   1910  CG1 VAL D  53      50.407  39.406  39.696  1.00  7.16           C  
ATOM   1911  CG2 VAL D  53      50.268  39.362  37.191  1.00  6.63           C  
ATOM   1912  N   PRO D  54      53.488  40.422  36.448  1.00  6.36           N  
ATOM   1913  CA  PRO D  54      53.882  40.521  35.048  1.00  6.37           C  
ATOM   1914  C   PRO D  54      52.808  39.969  34.113  1.00  6.20           C  
ATOM   1915  O   PRO D  54      52.490  38.784  34.171  1.00  6.30           O  
ATOM   1916  CB  PRO D  54      55.150  39.664  34.994  1.00  6.49           C  
ATOM   1917  CG  PRO D  54      55.636  39.632  36.347  1.00  6.35           C  
ATOM   1918  CD  PRO D  54      54.424  39.595  37.217  1.00  6.36           C  
ATOM   1919  N   THR D  55      52.259  40.831  33.270  1.00  5.97           N  
ATOM   1920  CA  THR D  55      51.257  40.446  32.276  1.00  6.17           C  
ATOM   1921  C   THR D  55      51.724  39.242  31.438  1.00  6.37           C  
ATOM   1922  O   THR D  55      50.918  38.436  30.958  1.00  6.31           O  
ATOM   1923  CB  THR D  55      50.973  41.674  31.339  1.00  6.23           C  
ATOM   1924  OG1 THR D  55      50.304  42.708  32.063  1.00  6.21           O  
ATOM   1925  CG2 THR D  55      49.983  41.350  30.209  1.00  6.36           C  
ATOM   1926  N   ALA D  56      53.041  39.187  31.225  1.00  6.68           N  
ATOM   1927  CA  ALA D  56      53.683  38.196  30.366  1.00  6.55           C  
ATOM   1928  C   ALA D  56      53.501  36.801  30.952  1.00  6.79           C  
ATOM   1929  O   ALA D  56      53.403  35.816  30.204  1.00  6.97           O  
ATOM   1930  CB  ALA D  56      55.163  38.514  30.223  1.00  6.51           C  
ATOM   1931  N   TYR D  57      53.437  36.710  32.280  1.00  6.59           N  
ATOM   1932  CA  TYR D  57      53.288  35.410  32.932  1.00  6.69           C  
ATOM   1933  C   TYR D  57      51.864  34.884  32.906  1.00  6.54           C  
ATOM   1934  O   TYR D  57      51.608  33.755  33.320  1.00  6.37           O  
ATOM   1935  CB  TYR D  57      53.766  35.485  34.383  1.00  6.64           C  
ATOM   1936  CG  TYR D  57      55.265  35.653  34.551  1.00  6.69           C  
ATOM   1937  CD1 TYR D  57      56.135  35.678  33.453  1.00  6.41           C  
ATOM   1938  CD2 TYR D  57      55.818  35.742  35.811  1.00  6.61           C  
ATOM   1939  CE1 TYR D  57      57.490  35.799  33.627  1.00  6.49           C  
ATOM   1940  CE2 TYR D  57      57.173  35.876  35.980  1.00  6.30           C  
ATOM   1941  CZ  TYR D  57      57.996  35.899  34.887  1.00  6.32           C  
ATOM   1942  OH  TYR D  57      59.345  36.040  35.049  1.00  7.11           O  
ATOM   1943  N   MET D  58      50.946  35.691  32.401  1.00  6.41           N  
ATOM   1944  CA  MET D  58      49.542  35.429  32.575  1.00  6.41           C  
ATOM   1945  C   MET D  58      48.927  35.010  31.282  1.00  6.35           C  
ATOM   1946  O   MET D  58      48.962  35.758  30.311  1.00  6.28           O  
ATOM   1947  CB  MET D  58      48.839  36.679  33.097  1.00  6.66           C  
ATOM   1948  CG  MET D  58      49.426  37.216  34.379  1.00  6.71           C  
ATOM   1949  SD  MET D  58      48.660  36.475  35.809  1.00  8.21           S  
ATOM   1950  CE  MET D  58      49.665  34.930  36.028  1.00  6.86           C  
ATOM   1951  N   THR D  59      48.318  33.826  31.320  1.00  6.56           N  
ATOM   1952  CA  THR D  59      47.684  33.179  30.168  1.00  6.55           C  
ATOM   1953  C   THR D  59      46.243  32.755  30.491  1.00  6.56           C  
ATOM   1954  O   THR D  59      46.002  32.224  31.570  1.00  6.57           O  
ATOM   1955  CB  THR D  59      48.498  31.934  29.749  1.00  6.50           C  
ATOM   1956  OG1 THR D  59      47.710  31.141  28.862  1.00  7.10           O  
ATOM   1957  CG2 THR D  59      48.756  30.949  30.907  1.00  6.43           C  
ATOM   1958  N   PRO D  60      45.292  32.955  29.570  1.00  6.57           N  
ATOM   1959  CA  PRO D  60      43.883  32.579  29.808  1.00  6.42           C  
ATOM   1960  C   PRO D  60      43.755  31.155  30.355  1.00  6.44           C  
ATOM   1961  O   PRO D  60      44.466  30.260  29.894  1.00  6.38           O  
ATOM   1962  CB  PRO D  60      43.233  32.691  28.419  1.00  6.34           C  
ATOM   1963  CG  PRO D  60      44.101  33.589  27.632  1.00  6.61           C  
ATOM   1964  CD  PRO D  60      45.483  33.557  28.239  1.00  6.54           C  
ATOM   1965  N   TYR D  61      42.855  30.960  31.319  1.00  6.52           N  
ATOM   1966  CA  TYR D  61      42.670  29.673  31.998  1.00  6.63           C  
ATOM   1967  C   TYR D  61      41.586  28.794  31.339  1.00  6.85           C  
ATOM   1968  O   TYR D  61      40.602  29.317  30.814  1.00  6.95           O  
ATOM   1969  CB  TYR D  61      42.259  29.931  33.449  1.00  6.59           C  
ATOM   1970  CG  TYR D  61      41.961  28.671  34.220  1.00  6.50           C  
ATOM   1971  CD1 TYR D  61      42.955  27.715  34.441  1.00  6.62           C  
ATOM   1972  CD2 TYR D  61      40.680  28.419  34.705  1.00  6.56           C  
ATOM   1973  CE1 TYR D  61      42.687  26.547  35.140  1.00  6.59           C  
ATOM   1974  CE2 TYR D  61      40.390  27.247  35.405  1.00  6.66           C  
ATOM   1975  CZ  TYR D  61      41.392  26.319  35.621  1.00  6.81           C  
ATOM   1976  OH  TYR D  61      41.069  25.168  36.312  1.00  6.57           O  
ATOM   1977  N   LYS D  62      41.738  27.464  31.387  1.00  7.12           N  
ATOM   1978  CA  LYS D  62      40.595  26.545  31.141  1.00  7.20           C  
ATOM   1979  C   LYS D  62      40.887  25.050  31.406  1.00  7.39           C  
ATOM   1980  O   LYS D  62      41.641  24.672  32.315  1.00  7.51           O  
ATOM   1981  CB  LYS D  62      40.045  26.700  29.713  1.00  7.13           C  
ATOM   1982  CG  LYS D  62      38.533  26.866  29.637  1.00  6.72           C  
ATOM   1983  CD  LYS D  62      37.818  25.511  29.673  1.00  6.38           C  
ATOM   1984  CE  LYS D  62      36.328  25.632  29.346  1.00  5.79           C  
ATOM   1985  NZ  LYS D  62      35.494  24.801  30.254  1.00  4.57           N  
TER    1986      LYS D  62                                                      
END
MOLECULE T0487_178_265.pdb
ATOM   1389  N   SER   178      50.886  32.816  25.767  1.00 72.79           N  
ATOM   1390  CA  SER   178      50.904  33.757  26.889  1.00 70.07           C  
ATOM   1391  C   SER   178      49.706  34.705  26.864  1.00 68.01           C  
ATOM   1392  O   SER   178      49.068  34.887  25.828  1.00 67.65           O  
ATOM   1393  CB  SER   178      52.174  34.607  26.842  1.00 70.56           C  
ATOM   1394  OG  SER   178      51.942  35.805  26.101  1.00 69.80           O  
ATOM   1395  N   LEU   179      49.423  35.323  28.008  1.00 65.44           N  
ATOM   1396  CA  LEU   179      48.324  36.270  28.111  1.00 64.41           C  
ATOM   1397  C   LEU   179      48.681  37.485  27.264  1.00 65.44           C  
ATOM   1398  O   LEU   179      47.803  38.213  26.811  1.00 64.49           O  
ATOM   1399  CB  LEU   179      48.133  36.706  29.564  1.00 63.05           C  
ATOM   1400  CG  LEU   179      46.806  37.324  30.046  1.00 63.07           C  
ATOM   1401  CD1 LEU   179      47.061  38.669  30.666  1.00 59.96           C  
ATOM   1402  CD2 LEU   179      45.810  37.439  28.911  1.00 63.32           C  
ATOM   1403  N   GLU   180      49.979  37.711  27.072  1.00 66.94           N  
ATOM   1404  CA  GLU   180      50.451  38.838  26.277  1.00 68.35           C  
ATOM   1405  C   GLU   180      50.122  38.532  24.826  1.00 69.37           C  
ATOM   1406  O   GLU   180      49.522  39.351  24.124  1.00 69.29           O  
ATOM   1407  CB  GLU   180      51.968  39.021  26.433  1.00 69.56           C  
ATOM   1408  CG  GLU   180      52.578  40.133  25.564  1.00 68.16           C  
ATOM   1409  CD  GLU   180      51.789  41.432  25.644  1.00 70.51           C  
ATOM   1410  OE1 GLU   180      51.352  41.804  26.751  1.00 71.02           O  
ATOM   1411  OE2 GLU   180      51.606  42.095  24.601  1.00 72.24           O  
ATOM   1412  N   ALA   181      50.509  37.339  24.387  1.00 68.86           N  
ATOM   1413  CA  ALA   181      50.246  36.915  23.020  1.00 68.70           C  
ATOM   1414  C   ALA   181      48.751  36.958  22.734  1.00 68.21           C  
ATOM   1415  O   ALA   181      48.298  37.630  21.811  1.00 67.78           O  
ATOM   1416  CB  ALA   181      50.778  35.493  22.799  1.00 68.81           C  
ATOM   1417  N   TRP   182      47.990  36.245  23.554  1.00 67.73           N  
ATOM   1418  CA  TRP   182      46.554  36.156  23.382  1.00 67.32           C  
ATOM   1419  C   TRP   182      45.879  37.511  23.267  1.00 66.70           C  
ATOM   1420  O   TRP   182      45.005  37.712  22.425  1.00 64.93           O  
ATOM   1421  CB  TRP   182      45.951  35.379  24.545  1.00 66.80           C  
ATOM   1422  CG  TRP   182      44.717  34.606  24.192  1.00 66.97           C  
ATOM   1423  CD1 TRP   182      44.627  33.513  23.363  1.00 67.71           C  
ATOM   1424  CD2 TRP   182      43.412  34.821  24.711  1.00 65.75           C  
ATOM   1425  NE1 TRP   182      43.337  33.031  23.348  1.00 66.31           N  
ATOM   1426  CE2 TRP   182      42.571  33.818  24.167  1.00 66.78           C  
ATOM   1427  CE3 TRP   182      42.866  35.761  25.585  1.00 65.78           C  
ATOM   1428  CZ2 TRP   182      41.213  33.734  24.476  1.00 68.00           C  
ATOM   1429  CZ3 TRP   182      41.513  35.680  25.893  1.00 68.30           C  
ATOM   1430  CH2 TRP   182      40.700  34.673  25.340  1.00 69.32           C  
ATOM   1431  N   LEU   183      46.271  38.438  24.128  1.00 67.37           N  
ATOM   1432  CA  LEU   183      45.668  39.763  24.101  1.00 68.70           C  
ATOM   1433  C   LEU   183      46.163  40.567  22.902  1.00 70.28           C  
ATOM   1434  O   LEU   183      45.409  41.379  22.354  1.00 70.00           O  
ATOM   1435  CB  LEU   183      45.960  40.523  25.397  1.00 65.92           C  
ATOM   1436  CG  LEU   183      45.158  40.159  26.643  1.00 64.80           C  
ATOM   1437  CD1 LEU   183      45.737  40.878  27.843  1.00 65.61           C  
ATOM   1438  CD2 LEU   183      43.717  40.543  26.469  1.00 63.29           C  
ATOM   1439  N   ALA   184      47.418  40.344  22.498  1.00 70.51           N  
ATOM   1440  CA  ALA   184      47.986  41.054  21.353  1.00 70.65           C  
ATOM   1441  C   ALA   184      47.157  40.725  20.112  1.00 72.14           C  
ATOM   1442  O   ALA   184      46.811  41.613  19.322  1.00 74.22           O  
ATOM   1443  CB  ALA   184      49.439  40.642  21.128  1.00 67.57           C  
ATOM   1444  N   GLN   185      46.823  39.448  19.959  1.00 71.41           N  
ATOM   1445  CA  GLN   185      46.055  38.988  18.822  1.00 70.02           C  
ATOM   1446  C   GLN   185      44.571  39.360  18.885  1.00 70.30           C  
ATOM   1447  O   GLN   185      43.754  38.814  18.140  1.00 72.30           O  
ATOM   1448  CB  GLN   185      46.250  37.478  18.668  1.00 70.34           C  
ATOM   1449  CG  GLN   185      47.700  37.106  18.314  1.00 71.08           C  
ATOM   1450  CD  GLN   185      48.049  35.632  18.569  1.00 73.18           C  
ATOM   1451  OE1 GLN   185      47.240  34.728  18.313  1.00 75.02           O  
ATOM   1452  NE2 GLN   185      49.270  35.386  19.059  1.00 70.57           N  
ATOM   1453  N   GLY   186      44.220  40.280  19.780  1.00 69.12           N  
ATOM   1454  CA  GLY   186      42.842  40.736  19.865  1.00 68.35           C  
ATOM   1455  C   GLY   186      41.785  40.064  20.725  1.00 68.79           C  
ATOM   1456  O   GLY   186      40.698  40.631  20.863  1.00 68.00           O  
ATOM   1457  N   HIS   187      42.061  38.888  21.297  1.00 70.02           N  
ATOM   1458  CA  HIS   187      41.061  38.198  22.133  1.00 70.95           C  
ATOM   1459  C   HIS   187      40.753  38.993  23.388  1.00 70.80           C  
ATOM   1460  O   HIS   187      41.644  39.608  23.966  1.00 72.87           O  
ATOM   1461  CB  HIS   187      41.548  36.818  22.568  1.00 72.13           C  
ATOM   1462  CG  HIS   187      41.837  35.881  21.435  1.00 75.45           C  
ATOM   1463  ND1 HIS   187      43.103  35.712  20.912  1.00 76.97           N  
ATOM   1464  CD2 HIS   187      41.031  35.032  20.752  1.00 75.28           C  
ATOM   1465  CE1 HIS   187      43.065  34.798  19.957  1.00 77.65           C  
ATOM   1466  NE2 HIS   187      41.820  34.370  19.841  1.00 77.28           N  
ATOM   1467  N   PRO   188      39.493  38.976  23.844  1.00 69.33           N  
ATOM   1468  CA  PRO   188      39.108  39.717  25.047  1.00 68.82           C  
ATOM   1469  C   PRO   188      39.831  39.288  26.332  1.00 69.05           C  
ATOM   1470  O   PRO   188      40.532  38.273  26.377  1.00 67.98           O  
ATOM   1471  CB  PRO   188      37.607  39.483  25.122  1.00 67.89           C  
ATOM   1472  CG  PRO   188      37.476  38.105  24.590  1.00 68.52           C  
ATOM   1473  CD  PRO   188      38.377  38.142  23.373  1.00 69.36           C  
ATOM   1474  N   LEU   189      39.631  40.088  27.375  1.00 69.24           N  
ATOM   1475  CA  LEU   189      40.226  39.893  28.694  1.00 68.26           C  
ATOM   1476  C   LEU   189      39.519  38.753  29.426  1.00 67.78           C  
ATOM   1477  O   LEU   189      38.325  38.853  29.703  1.00 67.72           O  
ATOM   1478  CB  LEU   189      40.048  41.184  29.487  1.00 68.50           C  
ATOM   1479  CG  LEU   189      41.061  41.714  30.495  1.00 69.40           C  
ATOM   1480  CD1 LEU   189      42.320  42.193  29.785  1.00 68.24           C  
ATOM   1481  CD2 LEU   189      40.423  42.861  31.252  1.00 69.17           C  
ATOM   1482  N   PRO   190      40.238  37.653  29.738  1.00 66.51           N  
ATOM   1483  CA  PRO   190      39.635  36.518  30.445  1.00 66.30           C  
ATOM   1484  C   PRO   190      39.386  36.844  31.906  1.00 65.77           C  
ATOM   1485  O   PRO   190      39.913  37.815  32.442  1.00 64.95           O  
ATOM   1486  CB  PRO   190      40.659  35.409  30.259  1.00 65.74           C  
ATOM   1487  CG  PRO   190      41.934  36.142  30.209  1.00 65.98           C  
ATOM   1488  CD  PRO   190      41.608  37.323  29.323  1.00 66.24           C  
ATOM   1489  N   LYS   191      38.574  36.029  32.555  1.00 66.90           N  
ATOM   1490  CA  LYS   191      38.252  36.281  33.940  1.00 68.59           C  
ATOM   1491  C   LYS   191      39.385  35.895  34.877  1.00 69.54           C  
ATOM   1492  O   LYS   191      39.714  36.611  35.811  1.00 69.46           O  
ATOM   1493  CB  LYS   191      36.971  35.507  34.339  1.00 66.50           C  
ATOM   1494  N   ARG   192      40.013  34.775  34.579  1.00 71.25           N  
ATOM   1495  CA  ARG   192      41.003  34.185  35.433  1.00 72.21           C  
ATOM   1496  C   ARG   192      42.272  33.878  34.698  1.00 71.41           C  
ATOM   1497  O   ARG   192      42.220  33.436  33.559  1.00 70.49           O  
ATOM   1498  CB  ARG   192      40.461  32.862  35.897  1.00 73.81           C  
ATOM   1499  CG  ARG   192      40.240  32.724  37.306  1.00 77.12           C  
ATOM   1500  CD  ARG   192      38.931  33.293  37.700  1.00 79.09           C  
ATOM   1501  NE  ARG   192      38.792  32.976  39.096  1.00 83.42           N  
ATOM   1502  CZ  ARG   192      38.232  33.757  40.002  1.00 85.75           C  
ATOM   1503  NH1 ARG   192      37.744  34.933  39.637  1.00 85.86           N  
ATOM   1504  NH2 ARG   192      38.175  33.346  41.272  1.00 86.41           N  
ATOM   1505  N   VAL   193      43.405  34.036  35.376  1.00 70.67           N  
ATOM   1506  CA  VAL   193      44.691  33.778  34.753  1.00 69.01           C  
ATOM   1507  C   VAL   193      45.496  32.785  35.566  1.00 68.15           C  
ATOM   1508  O   VAL   193      45.343  32.710  36.774  1.00 69.21           O  
ATOM   1509  CB  VAL   193      45.483  35.071  34.630  1.00 69.25           C  
ATOM   1510  CG1 VAL   193      46.781  34.825  33.918  1.00 71.90           C  
ATOM   1511  CG2 VAL   193      44.654  36.096  33.902  1.00 68.33           C  
ATOM   1512  N   ARG   194      46.379  32.039  34.916  1.00 67.11           N  
ATOM   1513  CA  ARG   194      47.211  31.081  35.619  1.00 66.36           C  
ATOM   1514  C   ARG   194      48.648  31.524  35.461  1.00 66.04           C  
ATOM   1515  O   ARG   194      48.986  32.188  34.495  1.00 66.50           O  
ATOM   1516  CB  ARG   194      47.041  29.706  35.003  1.00 68.43           C  
ATOM   1517  CG  ARG   194      47.425  28.562  35.902  1.00 71.86           C  
ATOM   1518  CD  ARG   194      48.589  27.803  35.321  1.00 76.27           C  
ATOM   1519  NE  ARG   194      48.386  27.429  33.922  1.00 80.71           N  
ATOM   1520  CZ  ARG   194      49.372  27.027  33.117  1.00 84.44           C  
ATOM   1521  NH1 ARG   194      50.617  26.949  33.581  1.00 85.78           N  
ATOM   1522  NH2 ARG   194      49.128  26.718  31.846  1.00 85.83           N  
ATOM   1523  N   ASN   195      49.496  31.182  36.421  1.00 65.91           N  
ATOM   1524  CA  ASN   195      50.898  31.535  36.310  1.00 64.68           C  
ATOM   1525  C   ASN   195      51.400  30.608  35.223  1.00 63.81           C  
ATOM   1526  O   ASN   195      50.868  29.512  35.058  1.00 62.14           O  
ATOM   1527  CB  ASN   195      51.664  31.234  37.606  1.00 65.09           C  
ATOM   1528  CG  ASN   195      51.538  32.338  38.641  1.00 66.86           C  
ATOM   1529  OD1 ASN   195      51.062  33.438  38.350  1.00 66.81           O  
ATOM   1530  ND2 ASN   195      51.982  32.051  39.858  1.00 66.69           N  
ATOM   1531  N   ALA   196      52.412  31.040  34.478  1.00 63.13           N  
ATOM   1532  CA  ALA   196      52.977  30.189  33.435  1.00 62.64           C  
ATOM   1533  C   ALA   196      53.970  29.213  34.062  1.00 62.41           C  
ATOM   1534  O   ALA   196      54.076  28.076  33.631  1.00 62.74           O  
ATOM   1535  CB  ALA   196      53.669  31.035  32.379  1.00 60.19           C  
ATOM   1536  N   TYR   197      54.673  29.665  35.097  1.00 63.83           N  
ATOM   1537  CA  TYR   197      55.675  28.856  35.796  1.00 64.54           C  
ATOM   1538  C   TYR   197      55.148  27.838  36.825  1.00 65.64           C  
ATOM   1539  O   TYR   197      55.920  27.054  37.385  1.00 67.88           O  
ATOM   1540  CB  TYR   197      56.705  29.770  36.462  1.00 61.90           C  
ATOM   1541  CG  TYR   197      56.102  30.959  37.159  1.00 58.48           C  
ATOM   1542  CD1 TYR   197      55.931  32.173  36.496  1.00 56.01           C  
ATOM   1543  CD2 TYR   197      55.685  30.866  38.483  1.00 58.22           C  
ATOM   1544  CE1 TYR   197      55.355  33.265  37.140  1.00 55.57           C  
ATOM   1545  CE2 TYR   197      55.111  31.947  39.131  1.00 56.93           C  
ATOM   1546  CZ  TYR   197      54.944  33.133  38.459  1.00 56.38           C  
ATOM   1547  OH  TYR   197      54.312  34.151  39.121  1.00 58.19           O  
ATOM   1548  N   ASP   198      53.850  27.871  37.099  1.00 65.09           N  
ATOM   1549  CA  ASP   198      53.227  26.901  37.998  1.00 63.43           C  
ATOM   1550  C   ASP   198      51.731  26.951  37.788  1.00 62.42           C  
ATOM   1551  O   ASP   198      51.239  27.730  36.974  1.00 63.52           O  
ATOM   1552  CB  ASP   198      53.611  27.109  39.479  1.00 64.26           C  
ATOM   1553  CG  ASP   198      53.151  28.434  40.053  1.00 65.88           C  
ATOM   1554  OD1 ASP   198      51.939  28.745  40.023  1.00 66.73           O  
ATOM   1555  OD2 ASP   198      54.022  29.161  40.570  1.00 66.88           O  
ATOM   1556  N   ARG   199      50.996  26.124  38.506  1.00 61.43           N  
ATOM   1557  CA  ARG   199      49.563  26.081  38.311  1.00 61.61           C  
ATOM   1558  C   ARG   199      48.703  27.055  39.118  1.00 61.63           C  
ATOM   1559  O   ARG   199      47.472  26.957  39.087  1.00 62.25           O  
ATOM   1560  CB  ARG   199      49.076  24.656  38.521  1.00 61.85           C  
ATOM   1561  N   ARG   200      49.303  28.003  39.825  1.00 61.76           N  
ATOM   1562  CA  ARG   200      48.470  28.929  40.580  1.00 63.49           C  
ATOM   1563  C   ARG   200      47.630  29.805  39.653  1.00 62.41           C  
ATOM   1564  O   ARG   200      48.124  30.305  38.645  1.00 62.12           O  
ATOM   1565  CB  ARG   200      49.307  29.824  41.497  1.00 66.92           C  
ATOM   1566  CG  ARG   200      48.426  30.796  42.301  1.00 71.18           C  
ATOM   1567  CD  ARG   200      49.138  31.366  43.512  1.00 74.24           C  
ATOM   1568  NE  ARG   200      48.225  32.139  44.348  1.00 78.08           N  
ATOM   1569  CZ  ARG   200      48.525  32.597  45.564  1.00 80.74           C  
ATOM   1570  NH1 ARG   200      49.720  32.362  46.097  1.00 79.79           N  
ATOM   1571  NH2 ARG   200      47.626  33.295  46.251  1.00 81.86           N  
ATOM   1572  N   THR   201      46.361  29.991  39.999  1.00 60.13           N  
ATOM   1573  CA  THR   201      45.482  30.804  39.180  1.00 60.15           C  
ATOM   1574  C   THR   201      45.130  32.081  39.904  1.00 59.16           C  
ATOM   1575  O   THR   201      45.423  32.222  41.081  1.00 60.04           O  
ATOM   1576  CB  THR   201      44.171  30.069  38.837  1.00 61.49           C  
ATOM   1577  OG1 THR   201      43.358  29.969  40.011  1.00 63.21           O  
ATOM   1578  CG2 THR   201      44.465  28.670  38.287  1.00 61.45           C  
ATOM   1579  N   TRP   202      44.508  33.013  39.192  1.00 58.57           N  
ATOM   1580  CA  TRP   202      44.117  34.287  39.774  1.00 58.33           C  
ATOM   1581  C   TRP   202      42.922  34.884  39.051  1.00 59.89           C  
ATOM   1582  O   TRP   202      42.480  34.403  38.015  1.00 57.22           O  
ATOM   1583  CB  TRP   202      45.230  35.342  39.687  1.00 56.73           C  
ATOM   1584  CG  TRP   202      46.623  34.925  39.996  1.00 56.77           C  
ATOM   1585  CD1 TRP   202      47.492  34.280  39.165  1.00 56.59           C  
ATOM   1586  CD2 TRP   202      47.355  35.223  41.186  1.00 57.19           C  
ATOM   1587  NE1 TRP   202      48.726  34.165  39.761  1.00 56.12           N  
ATOM   1588  CE2 TRP   202      48.668  34.735  41.001  1.00 57.56           C  
ATOM   1589  CE3 TRP   202      47.031  35.860  42.386  1.00 56.85           C  
ATOM   1590  CZ2 TRP   202      49.659  34.871  41.980  1.00 58.30           C  
ATOM   1591  CZ3 TRP   202      48.016  35.995  43.357  1.00 57.50           C  
ATOM   1592  CH2 TRP   202      49.315  35.501  43.148  1.00 58.22           C  
ATOM   1593  N   GLU   203      42.441  35.982  39.611  1.00 63.38           N  
ATOM   1594  CA  GLU   203      41.325  36.726  39.070  1.00 66.11           C  
ATOM   1595  C   GLU   203      42.001  37.892  38.363  1.00 65.79           C  
ATOM   1596  O   GLU   203      42.750  38.642  38.980  1.00 66.11           O  
ATOM   1597  CB  GLU   203      40.460  37.238  40.223  1.00 70.66           C  
ATOM   1598  CG  GLU   203      39.117  37.839  39.837  1.00 77.93           C  
ATOM   1599  CD  GLU   203      38.422  38.524  41.029  1.00 82.54           C  
ATOM   1600  OE1 GLU   203      38.918  38.381  42.172  1.00 84.18           O  
ATOM   1601  OE2 GLU   203      37.383  39.206  40.829  1.00 83.53           O  
ATOM   1602  N   LEU   204      41.769  38.031  37.066  1.00 65.73           N  
ATOM   1603  CA  LEU   204      42.370  39.123  36.329  1.00 65.17           C  
ATOM   1604  C   LEU   204      41.429  40.300  36.476  1.00 66.53           C  
ATOM   1605  O   LEU   204      40.241  40.183  36.197  1.00 67.24           O  
ATOM   1606  CB  LEU   204      42.514  38.754  34.865  1.00 63.65           C  
ATOM   1607  CG  LEU   204      43.641  39.447  34.119  1.00 61.57           C  
ATOM   1608  CD1 LEU   204      43.306  39.451  32.639  1.00 60.65           C  
ATOM   1609  CD2 LEU   204      43.821  40.845  34.639  1.00 61.03           C  
ATOM   1610  N   LEU   205      41.960  41.431  36.925  1.00 68.73           N  
ATOM   1611  CA  LEU   205      41.153  42.629  37.136  1.00 69.65           C  
ATOM   1612  C   LEU   205      41.264  43.606  35.975  1.00 71.33           C  
ATOM   1613  O   LEU   205      40.257  44.084  35.448  1.00 72.62           O  
ATOM   1614  CB  LEU   205      41.591  43.353  38.408  1.00 66.89           C  
ATOM   1615  CG  LEU   205      41.730  42.558  39.695  1.00 64.42           C  
ATOM   1616  CD1 LEU   205      42.144  43.511  40.811  1.00 63.12           C  
ATOM   1617  CD2 LEU   205      40.434  41.862  40.009  1.00 62.32           C  
ATOM   1618  N   ARG   206      42.495  43.910  35.588  1.00 71.79           N  
ATOM   1619  CA  ARG   206      42.729  44.851  34.515  1.00 72.64           C  
ATOM   1620  C   ARG   206      44.183  44.866  34.156  1.00 73.27           C  
ATOM   1621  O   ARG   206      44.993  44.216  34.793  1.00 72.83           O  
ATOM   1622  CB  ARG   206      42.315  46.258  34.952  1.00 73.68           C  
ATOM   1623  CG  ARG   206      42.461  46.518  36.461  1.00 76.14           C  
ATOM   1624  CD  ARG   206      42.338  48.005  36.799  1.00 77.52           C  
ATOM   1625  NE  ARG   206      43.537  48.740  36.395  1.00 79.70           N  
ATOM   1626  CZ  ARG   206      44.510  49.108  37.229  1.00 81.47           C  
ATOM   1627  NH1 ARG   206      44.430  48.823  38.531  1.00 82.03           N  
ATOM   1628  NH2 ARG   206      45.582  49.734  36.761  1.00 80.76           N  
ATOM   1629  N   LEU   207      44.507  45.614  33.116  1.00 76.18           N  
ATOM   1630  CA  LEU   207      45.886  45.752  32.681  1.00 78.80           C  
ATOM   1631  C   LEU   207      46.356  47.051  33.297  1.00 80.34           C  
ATOM   1632  O   LEU   207      45.544  47.817  33.814  1.00 80.93           O  
ATOM   1633  CB  LEU   207      45.969  45.846  31.162  1.00 78.21           C  
ATOM   1634  CG  LEU   207      46.783  44.769  30.459  1.00 79.21           C  
ATOM   1635  CD1 LEU   207      46.312  43.383  30.902  1.00 80.00           C  
ATOM   1636  CD2 LEU   207      46.622  44.939  28.956  1.00 80.04           C  
ATOM   1637  N   GLY   208      47.659  47.293  33.249  1.00 82.20           N  
ATOM   1638  CA  GLY   208      48.200  48.511  33.814  1.00 84.47           C  
ATOM   1639  C   GLY   208      49.210  49.157  32.894  1.00 86.77           C  
ATOM   1640  O   GLY   208      49.906  48.484  32.131  1.00 85.23           O  
ATOM   1641  N   GLU   209      49.303  50.477  32.983  1.00 90.43           N  
ATOM   1642  CA  GLU   209      50.223  51.236  32.148  1.00 93.67           C  
ATOM   1643  C   GLU   209      51.637  51.337  32.713  1.00 93.52           C  
ATOM   1644  O   GLU   209      52.574  51.663  31.979  1.00 93.73           O  
ATOM   1645  CB  GLU   209      49.648  52.640  31.882  1.00 97.33           C  
ATOM   1646  CG  GLU   209      49.114  53.377  33.116  1.00103.77           C  
ATOM   1647  CD  GLU   209      50.198  54.099  33.914  1.00107.89           C  
ATOM   1648  OE1 GLU   209      49.897  54.571  35.041  1.00109.42           O  
ATOM   1649  OE2 GLU   209      51.344  54.207  33.414  1.00109.63           O  
ATOM   1650  N   GLU   210      51.799  51.045  34.003  1.00 92.76           N  
ATOM   1651  CA  GLU   210      53.115  51.126  34.633  1.00 92.10           C  
ATOM   1652  C   GLU   210      54.162  50.242  33.971  1.00 92.41           C  
ATOM   1653  O   GLU   210      53.856  49.189  33.424  1.00 92.97           O  
ATOM   1654  CB  GLU   210      53.019  50.784  36.119  1.00 90.83           C  
ATOM   1655  CG  GLU   210      51.964  49.752  36.447  1.00 89.92           C  
ATOM   1656  CD  GLU   210      50.716  50.370  37.040  1.00 88.65           C  
ATOM   1657  OE1 GLU   210      50.829  51.040  38.088  1.00 88.65           O  
ATOM   1658  OE2 GLU   210      49.624  50.187  36.468  1.00 88.57           O  
ATOM   1659  N   ASP   211      55.407  50.688  34.017  1.00 93.17           N  
ATOM   1660  CA  ASP   211      56.503  49.945  33.425  1.00 94.06           C  
ATOM   1661  C   ASP   211      57.003  48.904  34.410  1.00 93.70           C  
ATOM   1662  O   ASP   211      57.480  49.241  35.489  1.00 94.07           O  
ATOM   1663  CB  ASP   211      57.641  50.895  33.073  1.00 96.52           C  
ATOM   1664  CG  ASP   211      57.981  51.834  34.219  1.00101.13           C  
ATOM   1665  OD1 ASP   211      58.979  52.590  34.113  1.00103.30           O  
ATOM   1666  OD2 ASP   211      57.242  51.818  35.233  1.00102.68           O  
ATOM   1667  N   PRO   212      56.896  47.619  34.055  1.00 93.56           N  
ATOM   1668  CA  PRO   212      57.354  46.539  34.933  1.00 93.11           C  
ATOM   1669  C   PRO   212      58.747  46.823  35.489  1.00 92.62           C  
ATOM   1670  O   PRO   212      59.014  46.663  36.685  1.00 93.34           O  
ATOM   1671  CB  PRO   212      57.335  45.316  34.014  1.00 92.72           C  
ATOM   1672  CG  PRO   212      57.444  45.909  32.631  1.00 93.18           C  
ATOM   1673  CD  PRO   212      56.528  47.086  32.735  1.00 94.11           C  
ATOM   1674  N   LYS   213      59.628  47.245  34.596  1.00 90.79           N  
ATOM   1675  CA  LYS   213      61.001  47.572  34.938  1.00 88.21           C  
ATOM   1676  C   LYS   213      61.120  48.491  36.153  1.00 85.96           C  
ATOM   1677  O   LYS   213      62.079  48.400  36.916  1.00 86.00           O  
ATOM   1678  CB  LYS   213      61.651  48.221  33.718  1.00 89.60           C  
ATOM   1679  CG  LYS   213      60.656  49.042  32.891  1.00 90.43           C  
ATOM   1680  CD  LYS   213      61.122  49.235  31.459  1.00 92.61           C  
ATOM   1681  CE  LYS   213      62.321  50.172  31.368  1.00 93.18           C  
ATOM   1682  NZ  LYS   213      62.789  50.344  29.956  1.00 94.14           N  
ATOM   1683  N   GLU   214      60.135  49.357  36.352  1.00 83.06           N  
ATOM   1684  CA  GLU   214      60.206  50.293  37.456  1.00 80.99           C  
ATOM   1685  C   GLU   214      59.077  50.234  38.479  1.00 78.99           C  
ATOM   1686  O   GLU   214      59.002  51.090  39.357  1.00 79.69           O  
ATOM   1687  CB  GLU   214      60.322  51.714  36.898  1.00 83.18           C  
ATOM   1688  CG  GLU   214      61.496  51.905  35.917  1.00 85.98           C  
ATOM   1689  CD  GLU   214      62.851  52.148  36.603  1.00 88.07           C  
ATOM   1690  OE1 GLU   214      63.899  51.964  35.933  1.00 88.14           O  
ATOM   1691  OE2 GLU   214      62.873  52.537  37.798  1.00 88.28           O  
ATOM   1692  N   LEU   215      58.195  49.245  38.389  1.00 75.56           N  
ATOM   1693  CA  LEU   215      57.118  49.149  39.370  1.00 70.81           C  
ATOM   1694  C   LEU   215      57.721  48.486  40.611  1.00 68.53           C  
ATOM   1695  O   LEU   215      58.277  47.394  40.536  1.00 68.45           O  
ATOM   1696  CB  LEU   215      55.957  48.322  38.816  1.00 69.76           C  
ATOM   1697  CG  LEU   215      54.730  48.203  39.723  1.00 68.23           C  
ATOM   1698  CD1 LEU   215      54.193  49.570  40.043  1.00 70.10           C  
ATOM   1699  CD2 LEU   215      53.673  47.400  39.033  1.00 68.21           C  
ATOM   1700  N   PRO   216      57.629  49.146  41.770  1.00 65.59           N  
ATOM   1701  CA  PRO   216      58.201  48.566  42.985  1.00 64.17           C  
ATOM   1702  C   PRO   216      57.308  47.687  43.856  1.00 63.09           C  
ATOM   1703  O   PRO   216      56.183  48.061  44.191  1.00 62.08           O  
ATOM   1704  CB  PRO   216      58.684  49.797  43.740  1.00 63.84           C  
ATOM   1705  CG  PRO   216      57.575  50.772  43.461  1.00 63.33           C  
ATOM   1706  CD  PRO   216      57.291  50.566  41.974  1.00 63.87           C  
ATOM   1707  N   LEU   217      57.828  46.517  44.224  1.00 61.66           N  
ATOM   1708  CA  LEU   217      57.116  45.601  45.104  1.00 58.98           C  
ATOM   1709  C   LEU   217      57.326  46.160  46.517  1.00 57.95           C  
ATOM   1710  O   LEU   217      58.306  46.866  46.772  1.00 57.13           O  
ATOM   1711  CB  LEU   217      57.681  44.188  44.940  1.00 58.92           C  
ATOM   1712  CG  LEU   217      56.956  43.286  43.917  1.00 59.54           C  
ATOM   1713  CD1 LEU   217      56.270  44.126  42.876  1.00 59.17           C  
ATOM   1714  CD2 LEU   217      57.934  42.316  43.259  1.00 58.01           C  
ATOM   1715  N   PRO   218      56.410  45.869  47.449  1.00 57.53           N  
ATOM   1716  CA  PRO   218      56.488  46.353  48.836  1.00 58.13           C  
ATOM   1717  C   PRO   218      57.834  46.826  49.406  1.00 59.75           C  
ATOM   1718  O   PRO   218      58.011  48.018  49.670  1.00 60.94           O  
ATOM   1719  CB  PRO   218      55.879  45.211  49.621  1.00 57.44           C  
ATOM   1720  CG  PRO   218      54.758  44.819  48.717  1.00 57.10           C  
ATOM   1721  CD  PRO   218      55.382  44.823  47.327  1.00 56.14           C  
ATOM   1722  N   GLY   219      58.785  45.921  49.601  1.00 60.14           N  
ATOM   1723  CA  GLY   219      60.059  46.357  50.154  1.00 59.45           C  
ATOM   1724  C   GLY   219      60.967  47.152  49.225  1.00 59.99           C  
ATOM   1725  O   GLY   219      62.113  47.456  49.593  1.00 60.44           O  
ATOM   1726  N   GLY   220      60.488  47.481  48.023  1.00 58.99           N  
ATOM   1727  CA  GLY   220      61.317  48.225  47.086  1.00 56.82           C  
ATOM   1728  C   GLY   220      61.831  47.485  45.855  1.00 55.36           C  
ATOM   1729  O   GLY   220      62.242  48.116  44.891  1.00 55.91           O  
ATOM   1730  N   LEU   221      61.819  46.159  45.869  1.00 55.10           N  
ATOM   1731  CA  LEU   221      62.285  45.375  44.716  1.00 55.13           C  
ATOM   1732  C   LEU   221      61.377  45.576  43.487  1.00 56.66           C  
ATOM   1733  O   LEU   221      60.147  45.629  43.609  1.00 55.89           O  
ATOM   1734  CB  LEU   221      62.324  43.894  45.104  1.00 52.43           C  
ATOM   1735  CG  LEU   221      62.834  42.780  44.185  1.00 50.13           C  
ATOM   1736  CD1 LEU   221      64.290  42.969  43.829  1.00 46.68           C  
ATOM   1737  CD2 LEU   221      62.650  41.449  44.918  1.00 48.43           C  
ATOM   1738  N   SER   222      61.975  45.692  42.303  1.00 58.20           N  
ATOM   1739  CA  SER   222      61.179  45.880  41.089  1.00 59.40           C  
ATOM   1740  C   SER   222      60.385  44.613  40.804  1.00 59.57           C  
ATOM   1741  O   SER   222      60.803  43.510  41.145  1.00 59.05           O  
ATOM   1742  CB  SER   222      62.063  46.194  39.879  1.00 60.08           C  
ATOM   1743  OG  SER   222      62.747  45.034  39.441  1.00 62.76           O  
ATOM   1744  N   LEU   223      59.232  44.786  40.177  1.00 60.43           N  
ATOM   1745  CA  LEU   223      58.363  43.680  39.845  1.00 60.50           C  
ATOM   1746  C   LEU   223      59.043  42.833  38.789  1.00 60.58           C  
ATOM   1747  O   LEU   223      58.850  41.619  38.727  1.00 60.06           O  
ATOM   1748  CB  LEU   223      57.019  44.227  39.359  1.00 62.23           C  
ATOM   1749  CG  LEU   223      55.925  43.312  38.809  1.00 64.78           C  
ATOM   1750  CD1 LEU   223      56.210  42.956  37.364  1.00 65.62           C  
ATOM   1751  CD2 LEU   223      55.841  42.080  39.642  1.00 65.49           C  
ATOM   1752  N   LEU   224      59.868  43.467  37.970  1.00 61.35           N  
ATOM   1753  CA  LEU   224      60.560  42.717  36.943  1.00 62.83           C  
ATOM   1754  C   LEU   224      61.664  41.895  37.577  1.00 62.41           C  
ATOM   1755  O   LEU   224      61.741  40.701  37.331  1.00 63.75           O  
ATOM   1756  CB  LEU   224      61.148  43.641  35.870  1.00 64.74           C  
ATOM   1757  CG  LEU   224      61.933  42.901  34.771  1.00 65.38           C  
ATOM   1758  CD1 LEU   224      60.998  42.149  33.833  1.00 63.50           C  
ATOM   1759  CD2 LEU   224      62.764  43.902  33.997  1.00 65.92           C  
ATOM   1760  N   ASP   225      62.511  42.516  38.393  1.00 61.75           N  
ATOM   1761  CA  ASP   225      63.603  41.777  39.047  1.00 63.10           C  
ATOM   1762  C   ASP   225      63.111  40.606  39.886  1.00 62.34           C  
ATOM   1763  O   ASP   225      63.825  39.628  40.077  1.00 63.44           O  
ATOM   1764  CB  ASP   225      64.425  42.672  39.977  1.00 65.55           C  
ATOM   1765  CG  ASP   225      65.271  43.676  39.233  1.00 69.26           C  
ATOM   1766  OD1 ASP   225      65.586  43.425  38.043  1.00 69.68           O  
ATOM   1767  OD2 ASP   225      65.631  44.706  39.857  1.00 70.29           O  
ATOM   1768  N   TYR   226      61.901  40.719  40.413  1.00 60.89           N  
ATOM   1769  CA  TYR   226      61.349  39.661  41.228  1.00 59.54           C  
ATOM   1770  C   TYR   226      61.302  38.376  40.404  1.00 60.29           C  
ATOM   1771  O   TYR   226      61.884  37.364  40.792  1.00 61.44           O  
ATOM   1772  CB  TYR   226      59.949  40.053  41.714  1.00 57.13           C  
ATOM   1773  CG  TYR   226      59.221  38.976  42.484  1.00 53.38           C  
ATOM   1774  CD1 TYR   226      59.530  38.703  43.809  1.00 51.58           C  
ATOM   1775  CD2 TYR   226      58.224  38.218  41.875  1.00 53.69           C  
ATOM   1776  CE1 TYR   226      58.862  37.698  44.507  1.00 49.73           C  
ATOM   1777  CE2 TYR   226      57.553  37.205  42.568  1.00 51.40           C  
ATOM   1778  CZ  TYR   226      57.881  36.955  43.876  1.00 49.11           C  
ATOM   1779  OH  TYR   226      57.251  35.937  44.531  1.00 47.84           O  
ATOM   1780  N   HIS   227      60.628  38.410  39.264  1.00 59.93           N  
ATOM   1781  CA  HIS   227      60.544  37.213  38.440  1.00 60.89           C  
ATOM   1782  C   HIS   227      61.894  36.975  37.746  1.00 63.81           C  
ATOM   1783  O   HIS   227      62.439  35.872  37.784  1.00 63.23           O  
ATOM   1784  CB  HIS   227      59.424  37.355  37.399  1.00 57.03           C  
ATOM   1785  CG  HIS   227      58.046  37.517  37.984  1.00 53.56           C  
ATOM   1786  ND1 HIS   227      57.316  36.463  38.493  1.00 52.36           N  
ATOM   1787  CD2 HIS   227      57.253  38.610  38.105  1.00 50.16           C  
ATOM   1788  CE1 HIS   227      56.136  36.898  38.897  1.00 48.37           C  
ATOM   1789  NE2 HIS   227      56.074  38.197  38.673  1.00 47.03           N  
ATOM   1790  N   ALA   228      62.439  38.021  37.134  1.00 67.61           N  
ATOM   1791  CA  ALA   228      63.722  37.933  36.423  1.00 71.57           C  
ATOM   1792  C   ALA   228      64.750  37.137  37.205  1.00 73.71           C  
ATOM   1793  O   ALA   228      65.389  36.230  36.668  1.00 74.28           O  
ATOM   1794  CB  ALA   228      64.274  39.333  36.134  1.00 70.89           C  
ATOM   1795  N   SER   229      64.902  37.483  38.479  1.00 76.15           N  
ATOM   1796  CA  SER   229      65.857  36.813  39.339  1.00 78.54           C  
ATOM   1797  C   SER   229      65.493  35.353  39.536  1.00 79.95           C  
ATOM   1798  O   SER   229      66.373  34.511  39.673  1.00 79.93           O  
ATOM   1799  CB  SER   229      65.932  37.519  40.699  1.00 79.76           C  
ATOM   1800  OG  SER   229      66.833  36.857  41.583  1.00 81.85           O  
ATOM   1801  N   LYS   230      64.199  35.048  39.548  1.00 82.19           N  
ATOM   1802  CA  LYS   230      63.756  33.670  39.743  1.00 84.10           C  
ATOM   1803  C   LYS   230      63.860  32.858  38.451  1.00 84.00           C  
ATOM   1804  O   LYS   230      63.264  31.787  38.322  1.00 83.71           O  
ATOM   1805  CB  LYS   230      62.319  33.637  40.290  1.00 85.98           C  
ATOM   1806  CG  LYS   230      62.157  34.242  41.697  1.00 89.07           C  
ATOM   1807  CD  LYS   230      63.028  33.528  42.739  1.00 91.74           C  
ATOM   1808  CE  LYS   230      62.970  34.220  44.110  1.00 93.04           C  
ATOM   1809  NZ  LYS   230      61.574  34.324  44.630  1.00 92.19           N  
ATOM   1810  N   GLY   231      64.628  33.386  37.502  1.00 83.88           N  
ATOM   1811  CA  GLY   231      64.835  32.715  36.233  1.00 85.07           C  
ATOM   1812  C   GLY   231      63.578  32.378  35.461  1.00 86.24           C  
ATOM   1813  O   GLY   231      63.610  31.550  34.546  1.00 87.35           O  
ATOM   1814  N   ARG   232      62.470  33.017  35.824  1.00 85.71           N  
ATOM   1815  CA  ARG   232      61.186  32.789  35.166  1.00 83.70           C  
ATOM   1816  C   ARG   232      61.158  33.593  33.898  1.00 85.17           C  
ATOM   1817  O   ARG   232      60.272  33.431  33.064  1.00 85.53           O  
ATOM   1818  CB  ARG   232      60.043  33.260  36.054  1.00 79.09           C  
ATOM   1819  CG  ARG   232      59.853  32.463  37.310  1.00 73.26           C  
ATOM   1820  CD  ARG   232      58.927  33.203  38.220  1.00 69.66           C  
ATOM   1821  NE  ARG   232      58.598  32.445  39.413  1.00 65.96           N  
ATOM   1822  CZ  ARG   232      57.974  32.968  40.458  1.00 65.19           C  
ATOM   1823  NH1 ARG   232      57.629  34.248  40.437  1.00 63.79           N  
ATOM   1824  NH2 ARG   232      57.688  32.216  41.513  1.00 64.60           N  
ATOM   1825  N   LEU   233      62.133  34.475  33.762  1.00 88.01           N  
ATOM   1826  CA  LEU   233      62.197  35.324  32.593  1.00 92.02           C  
ATOM   1827  C   LEU   233      62.992  34.656  31.482  1.00 94.37           C  
ATOM   1828  O   LEU   233      62.755  34.912  30.302  1.00 95.25           O  
ATOM   1829  CB  LEU   233      62.832  36.662  32.955  1.00 92.16           C  
ATOM   1830  CG  LEU   233      62.117  37.871  32.364  1.00 91.40           C  
ATOM   1831  CD1 LEU   233      60.835  38.131  33.136  1.00 90.38           C  
ATOM   1832  CD2 LEU   233      63.034  39.083  32.440  1.00 92.79           C  
ATOM   1833  N   GLN   234      63.933  33.796  31.857  1.00 97.19           N  
ATOM   1834  CA  GLN   234      64.749  33.108  30.862  1.00 99.93           C  
ATOM   1835  C   GLN   234      63.873  32.497  29.764  1.00101.35           C  
ATOM   1836  O   GLN   234      63.060  31.602  30.020  1.00102.29           O  
ATOM   1837  CB  GLN   234      65.598  32.025  31.530  1.00 98.68           C  
ATOM   1838  N   GLY   235      64.028  32.998  28.542  1.00101.54           N  
ATOM   1839  CA  GLY   235      63.252  32.472  27.430  1.00102.08           C  
ATOM   1840  C   GLY   235      61.855  33.048  27.268  1.00101.94           C  
ATOM   1841  O   GLY   235      60.982  32.403  26.681  1.00102.78           O  
ATOM   1842  N   ARG   236      61.632  34.258  27.765  1.00101.38           N  
ATOM   1843  CA  ARG   236      60.315  34.858  27.636  1.00 99.91           C  
ATOM   1844  C   ARG   236      60.363  36.370  27.416  1.00 98.87           C  
ATOM   1845  O   ARG   236      61.420  36.955  27.213  1.00 99.44           O  
ATOM   1846  CB  ARG   236      59.478  34.542  28.875  1.00 99.41           C  
ATOM   1847  N   GLU   237      59.185  36.974  27.444  1.00 97.86           N  
ATOM   1848  CA  GLU   237      59.022  38.410  27.289  1.00 96.78           C  
ATOM   1849  C   GLU   237      58.101  38.800  28.430  1.00 94.77           C  
ATOM   1850  O   GLU   237      57.024  38.224  28.581  1.00 94.97           O  
ATOM   1851  CB  GLU   237      58.349  38.751  25.959  1.00100.13           C  
ATOM   1852  CG  GLU   237      57.799  40.185  25.869  1.00102.17           C  
ATOM   1853  CD  GLU   237      56.387  40.238  25.296  1.00103.44           C  
ATOM   1854  OE1 GLU   237      56.036  39.337  24.505  1.00104.23           O  
ATOM   1855  OE2 GLU   237      55.633  41.182  25.627  1.00104.30           O  
ATOM   1856  N   GLY   238      58.525  39.772  29.229  1.00 91.48           N  
ATOM   1857  CA  GLY   238      57.721  40.217  30.350  1.00 87.77           C  
ATOM   1858  C   GLY   238      56.381  40.782  29.942  1.00 85.92           C  
ATOM   1859  O   GLY   238      55.385  40.574  30.627  1.00 85.39           O  
ATOM   1860  N   GLY   239      56.352  41.501  28.826  1.00 85.46           N  
ATOM   1861  CA  GLY   239      55.109  42.084  28.358  1.00 83.22           C  
ATOM   1862  C   GLY   239      54.712  43.275  29.196  1.00 82.47           C  
ATOM   1863  O   GLY   239      55.572  44.015  29.662  1.00 83.12           O  
ATOM   1864  N   ARG   240      53.410  43.452  29.391  1.00 82.23           N  
ATOM   1865  CA  ARG   240      52.865  44.560  30.173  1.00 82.73           C  
ATOM   1866  C   ARG   240      52.442  44.111  31.578  1.00 80.66           C  
ATOM   1867  O   ARG   240      52.334  42.918  31.851  1.00 81.00           O  
ATOM   1868  CB  ARG   240      51.655  45.146  29.437  1.00 87.53           C  
ATOM   1869  CG  ARG   240      51.031  46.391  30.075  1.00 95.10           C  
ATOM   1870  CD  ARG   240      51.879  47.672  29.882  1.00101.20           C  
ATOM   1871  NE  ARG   240      52.015  48.069  28.474  1.00104.62           N  
ATOM   1872  CZ  ARG   240      52.974  47.638  27.656  1.00106.63           C  
ATOM   1873  NH1 ARG   240      53.906  46.789  28.093  1.00107.58           N  
ATOM   1874  NH2 ARG   240      53.000  48.054  26.395  1.00106.50           N  
ATOM   1875  N   VAL   241      52.192  45.076  32.460  1.00 77.97           N  
ATOM   1876  CA  VAL   241      51.776  44.801  33.838  1.00 75.15           C  
ATOM   1877  C   VAL   241      50.311  44.411  33.946  1.00 74.21           C  
ATOM   1878  O   VAL   241      49.442  45.083  33.403  1.00 74.40           O  
ATOM   1879  CB  VAL   241      51.979  46.026  34.752  1.00 73.81           C  
ATOM   1880  CG1 VAL   241      51.329  45.773  36.094  1.00 72.30           C  
ATOM   1881  CG2 VAL   241      53.459  46.319  34.920  1.00 72.84           C  
ATOM   1882  N   ALA   242      50.038  43.344  34.685  1.00 73.49           N  
ATOM   1883  CA  ALA   242      48.668  42.872  34.856  1.00 72.06           C  
ATOM   1884  C   ALA   242      48.230  42.823  36.311  1.00 70.74           C  
ATOM   1885  O   ALA   242      48.684  41.986  37.068  1.00 71.78           O  
ATOM   1886  CB  ALA   242      48.518  41.495  34.231  1.00 72.17           C  
ATOM   1887  N   TRP   243      47.339  43.720  36.699  1.00 69.56           N  
ATOM   1888  CA  TRP   243      46.847  43.726  38.059  1.00 69.29           C  
ATOM   1889  C   TRP   243      45.968  42.512  38.220  1.00 68.40           C  
ATOM   1890  O   TRP   243      45.011  42.313  37.479  1.00 69.02           O  
ATOM   1891  CB  TRP   243      46.095  45.026  38.353  1.00 70.42           C  
ATOM   1892  CG  TRP   243      47.051  46.180  38.314  1.00 72.51           C  
ATOM   1893  CD1 TRP   243      47.309  47.003  37.248  1.00 72.80           C  
ATOM   1894  CD2 TRP   243      48.013  46.521  39.322  1.00 71.94           C  
ATOM   1895  NE1 TRP   243      48.376  47.823  37.530  1.00 72.94           N  
ATOM   1896  CE2 TRP   243      48.828  47.548  38.794  1.00 72.39           C  
ATOM   1897  CE3 TRP   243      48.268  46.052  40.615  1.00 71.00           C  
ATOM   1898  CZ2 TRP   243      49.885  48.116  39.517  1.00 72.37           C  
ATOM   1899  CZ3 TRP   243      49.318  46.618  41.333  1.00 72.44           C  
ATOM   1900  CH2 TRP   243      50.114  47.639  40.780  1.00 71.49           C  
ATOM   1901  N   VAL   244      46.318  41.704  39.206  1.00 67.98           N  
ATOM   1902  CA  VAL   244      45.651  40.450  39.487  1.00 68.63           C  
ATOM   1903  C   VAL   244      45.117  40.368  40.925  1.00 70.31           C  
ATOM   1904  O   VAL   244      45.485  41.172  41.780  1.00 70.28           O  
ATOM   1905  CB  VAL   244      46.669  39.324  39.179  1.00 67.10           C  
ATOM   1906  CG1 VAL   244      46.644  38.261  40.224  1.00 66.99           C  
ATOM   1907  CG2 VAL   244      46.400  38.759  37.816  1.00 65.37           C  
ATOM   1908  N   ALA   245      44.234  39.409  41.182  1.00 73.54           N  
ATOM   1909  CA  ALA   245      43.662  39.217  42.518  1.00 77.50           C  
ATOM   1910  C   ALA   245      43.900  37.775  42.973  1.00 80.10           C  
ATOM   1911  O   ALA   245      44.182  36.911  42.152  1.00 79.89           O  
ATOM   1912  CB  ALA   245      42.182  39.536  42.501  1.00 78.23           C  
ATOM   1913  N   ASP   246      43.741  37.504  44.266  1.00 84.91           N  
ATOM   1914  CA  ASP   246      44.034  36.180  44.786  1.00 91.11           C  
ATOM   1915  C   ASP   246      43.553  34.803  44.228  1.00 95.61           C  
ATOM   1916  O   ASP   246      44.370  34.029  43.736  1.00 97.23           O  
ATOM   1917  CB  ASP   246      43.799  36.129  46.303  1.00 89.52           C  
ATOM   1918  CG  ASP   246      44.490  34.941  46.945  1.00 89.61           C  
ATOM   1919  OD1 ASP   246      45.611  35.108  47.470  1.00 89.47           O  
ATOM   1920  OD2 ASP   246      43.923  33.829  46.896  1.00 89.35           O  
ATOM   1921  N   PRO   247      42.209  34.521  44.177  1.00 99.10           N  
ATOM   1922  CA  PRO   247      41.025  35.241  44.689  1.00101.63           C  
ATOM   1923  C   PRO   247      40.502  35.029  46.109  1.00102.89           C  
ATOM   1924  O   PRO   247      39.342  35.362  46.374  1.00104.01           O  
ATOM   1925  CB  PRO   247      39.978  34.787  43.675  1.00102.35           C  
ATOM   1926  CG  PRO   247      40.295  33.299  43.597  1.00101.05           C  
ATOM   1927  CD  PRO   247      41.818  33.287  43.484  1.00 99.68           C  
ATOM   1928  N   LYS   248      41.297  34.472  47.023  1.00104.59           N  
ATOM   1929  CA  LYS   248      40.804  34.299  48.395  1.00105.61           C  
ATOM   1930  C   LYS   248      40.737  35.689  49.049  1.00107.03           C  
ATOM   1931  O   LYS   248      40.015  35.908  50.026  1.00108.10           O  
ATOM   1932  CB  LYS   248      41.721  33.360  49.190  1.00104.00           C  
ATOM   1933  N   ASP   249      41.509  36.611  48.488  1.00107.31           N  
ATOM   1934  CA  ASP   249      41.545  38.012  48.916  1.00108.27           C  
ATOM   1935  C   ASP   249      41.176  38.757  47.634  1.00108.48           C  
ATOM   1936  O   ASP   249      42.017  39.403  47.008  1.00108.32           O  
ATOM   1937  CB  ASP   249      42.951  38.411  49.368  1.00109.73           C  
ATOM   1938  CG  ASP   249      43.093  38.453  50.881  1.00110.13           C  
ATOM   1939  OD1 ASP   249      44.167  38.872  51.364  1.00110.14           O  
ATOM   1940  OD2 ASP   249      42.137  38.070  51.586  1.00110.53           O  
ATOM   1941  N   PRO   250      39.901  38.668  47.225  1.00108.38           N  
ATOM   1942  CA  PRO   250      39.383  39.305  46.008  1.00108.07           C  
ATOM   1943  C   PRO   250      39.455  40.825  45.962  1.00107.62           C  
ATOM   1944  O   PRO   250      39.369  41.427  44.887  1.00108.06           O  
ATOM   1945  CB  PRO   250      37.944  38.807  45.956  1.00108.28           C  
ATOM   1946  CG  PRO   250      37.578  38.773  47.411  1.00108.01           C  
ATOM   1947  CD  PRO   250      38.795  38.123  48.037  1.00108.15           C  
ATOM   1948  N   ARG   251      39.624  41.439  47.127  1.00105.75           N  
ATOM   1949  CA  ARG   251      39.656  42.888  47.222  1.00103.19           C  
ATOM   1950  C   ARG   251      41.023  43.537  47.101  1.00100.58           C  
ATOM   1951  O   ARG   251      41.111  44.739  46.855  1.00100.45           O  
ATOM   1952  CB  ARG   251      39.020  43.317  48.540  1.00105.18           C  
ATOM   1953  CG  ARG   251      37.641  42.738  48.769  1.00106.09           C  
ATOM   1954  CD  ARG   251      36.659  43.834  49.107  1.00107.90           C  
ATOM   1955  NE  ARG   251      35.353  43.286  49.448  1.00110.15           N  
ATOM   1956  CZ  ARG   251      34.303  44.019  49.808  1.00110.84           C  
ATOM   1957  NH1 ARG   251      34.399  45.341  49.874  1.00110.87           N  
ATOM   1958  NH2 ARG   251      33.156  43.426  50.115  1.00111.15           N  
ATOM   1959  N   LYS   252      42.088  42.760  47.278  1.00 96.86           N  
ATOM   1960  CA  LYS   252      43.434  43.330  47.198  1.00 92.57           C  
ATOM   1961  C   LYS   252      44.222  42.903  45.971  1.00 86.47           C  
ATOM   1962  O   LYS   252      44.592  41.735  45.825  1.00 86.47           O  
ATOM   1963  CB  LYS   252      44.239  42.987  48.451  1.00 95.18           C  
ATOM   1964  CG  LYS   252      45.584  43.698  48.525  1.00 97.46           C  
ATOM   1965  CD  LYS   252      46.376  43.229  49.729  1.00101.35           C  
ATOM   1966  CE  LYS   252      46.871  41.801  49.534  1.00103.67           C  
ATOM   1967  NZ  LYS   252      45.775  40.831  49.223  1.00105.43           N  
ATOM   1968  N   PRO   253      44.501  43.862  45.080  1.00 80.97           N  
ATOM   1969  CA  PRO   253      45.245  43.670  43.833  1.00 76.84           C  
ATOM   1970  C   PRO   253      46.757  43.515  44.020  1.00 72.54           C  
ATOM   1971  O   PRO   253      47.378  44.239  44.802  1.00 71.39           O  
ATOM   1972  CB  PRO   253      44.901  44.929  43.045  1.00 76.95           C  
ATOM   1973  CG  PRO   253      44.826  45.960  44.125  1.00 77.70           C  
ATOM   1974  CD  PRO   253      44.011  45.249  45.183  1.00 79.13           C  
ATOM   1975  N   ILE   254      47.343  42.562  43.304  1.00 66.91           N  
ATOM   1976  CA  ILE   254      48.777  42.367  43.375  1.00 61.43           C  
ATOM   1977  C   ILE   254      49.269  42.508  41.954  1.00 58.54           C  
ATOM   1978  O   ILE   254      48.566  42.180  41.011  1.00 56.58           O  
ATOM   1979  CB  ILE   254      49.166  40.978  43.946  1.00 61.07           C  
ATOM   1980  CG1 ILE   254      49.621  40.062  42.826  1.00 60.73           C  
ATOM   1981  CG2 ILE   254      47.990  40.355  44.709  1.00 59.15           C  
ATOM   1982  CD1 ILE   254      50.156  38.762  43.329  1.00 63.47           C  
ATOM   1983  N   PRO   255      50.493  42.996  41.772  1.00 56.44           N  
ATOM   1984  CA  PRO   255      50.894  43.113  40.379  1.00 55.05           C  
ATOM   1985  C   PRO   255      51.501  41.860  39.788  1.00 53.92           C  
ATOM   1986  O   PRO   255      52.014  40.989  40.496  1.00 52.18           O  
ATOM   1987  CB  PRO   255      51.849  44.309  40.389  1.00 55.63           C  
ATOM   1988  CG  PRO   255      52.358  44.397  41.805  1.00 54.87           C  
ATOM   1989  CD  PRO   255      51.530  43.492  42.685  1.00 55.03           C  
ATOM   1990  N   HIS   256      51.419  41.786  38.468  1.00 52.62           N  
ATOM   1991  CA  HIS   256      51.942  40.659  37.731  1.00 52.33           C  
ATOM   1992  C   HIS   256      52.236  41.094  36.307  1.00 52.34           C  
ATOM   1993  O   HIS   256      52.075  42.245  35.938  1.00 53.29           O  
ATOM   1994  CB  HIS   256      50.957  39.504  37.754  1.00 50.07           C  
ATOM   1995  CG  HIS   256      51.606  38.159  37.677  1.00 49.66           C  
ATOM   1996  ND1 HIS   256      51.227  37.116  38.491  1.00 49.27           N  
ATOM   1997  CD2 HIS   256      52.599  37.678  36.888  1.00 49.16           C  
ATOM   1998  CE1 HIS   256      51.957  36.050  38.210  1.00 50.08           C  
ATOM   1999  NE2 HIS   256      52.797  36.364  37.238  1.00 49.02           N  
ATOM   2000  N   LEU   257      52.584  40.139  35.487  1.00 53.39           N  
ATOM   2001  CA  LEU   257      53.028  40.397  34.159  1.00 57.25           C  
ATOM   2002  C   LEU   257      52.472  39.530  33.080  1.00 59.33           C  
ATOM   2003  O   LEU   257      52.679  38.328  33.142  1.00 59.19           O  
ATOM   2004  CB  LEU   257      54.464  40.068  34.093  1.00 58.52           C  
ATOM   2005  CG  LEU   257      55.325  40.949  34.924  1.00 60.98           C  
ATOM   2006  CD1 LEU   257      56.699  40.450  34.716  1.00 57.94           C  
ATOM   2007  CD2 LEU   257      55.241  42.329  34.351  1.00 58.77           C  
ATOM   2008  N   THR   258      51.890  40.111  32.039  1.00 60.58           N  
ATOM   2009  CA  THR   258      51.320  39.300  30.955  1.00 61.79           C  
ATOM   2010  C   THR   258      52.248  38.232  30.323  1.00 61.26           C  
ATOM   2011  O   THR   258      51.813  37.128  29.960  1.00 60.52           O  
ATOM   2012  CB  THR   258      50.808  40.171  29.840  1.00 61.37           C  
ATOM   2013  OG1 THR   258      51.913  40.842  29.238  1.00 62.19           O  
ATOM   2014  CG2 THR   258      49.854  41.202  30.400  1.00 61.30           C  
ATOM   2015  N   GLY   259      53.518  38.565  30.149  1.00 60.95           N  
ATOM   2016  CA  GLY   259      54.425  37.605  29.564  1.00 60.64           C  
ATOM   2017  C   GLY   259      54.480  36.333  30.375  1.00 60.95           C  
ATOM   2018  O   GLY   259      54.717  35.267  29.830  1.00 61.41           O  
ATOM   2019  N   LEU   260      54.246  36.433  31.680  1.00 62.35           N  
ATOM   2020  CA  LEU   260      54.310  35.265  32.549  1.00 62.18           C  
ATOM   2021  C   LEU   260      52.969  34.671  32.929  1.00 61.39           C  
ATOM   2022  O   LEU   260      52.893  33.875  33.877  1.00 61.82           O  
ATOM   2023  CB  LEU   260      55.072  35.606  33.822  1.00 65.44           C  
ATOM   2024  CG  LEU   260      56.521  36.068  33.650  1.00 67.85           C  
ATOM   2025  CD1 LEU   260      57.054  36.588  34.987  1.00 67.43           C  
ATOM   2026  CD2 LEU   260      57.366  34.902  33.123  1.00 68.59           C  
ATOM   2027  N   LEU   261      51.921  35.034  32.195  1.00 58.54           N  
ATOM   2028  CA  LEU   261      50.586  34.520  32.479  1.00 57.94           C  
ATOM   2029  C   LEU   261      49.949  33.772  31.297  1.00 58.83           C  
ATOM   2030  O   LEU   261      50.301  33.991  30.127  1.00 59.31           O  
ATOM   2031  CB  LEU   261      49.673  35.669  32.931  1.00 55.50           C  
ATOM   2032  CG  LEU   261      50.062  36.391  34.231  1.00 54.35           C  
ATOM   2033  CD1 LEU   261      49.209  37.635  34.407  1.00 51.98           C  
ATOM   2034  CD2 LEU   261      49.887  35.446  35.428  1.00 51.89           C  
ATOM   2035  N   VAL   262      49.011  32.886  31.614  1.00 57.57           N  
ATOM   2036  CA  VAL   262      48.325  32.102  30.601  1.00 58.59           C  
ATOM   2037  C   VAL   262      46.838  32.221  30.902  1.00 58.98           C  
ATOM   2038  O   VAL   262      46.377  31.788  31.954  1.00 59.19           O  
ATOM   2039  CB  VAL   262      48.794  30.609  30.658  1.00 59.44           C  
ATOM   2040  CG1 VAL   262      48.057  29.754  29.607  1.00 57.60           C  
ATOM   2041  CG2 VAL   262      50.300  30.543  30.424  1.00 57.04           C  
ATOM   2042  N   PRO   263      46.061  32.823  29.986  1.00 59.23           N  
ATOM   2043  CA  PRO   263      44.625  32.959  30.254  1.00 60.04           C  
ATOM   2044  C   PRO   263      43.937  31.633  30.485  1.00 59.35           C  
ATOM   2045  O   PRO   263      44.226  30.658  29.813  1.00 57.78           O  
ATOM   2046  CB  PRO   263      44.102  33.676  29.010  1.00 58.23           C  
ATOM   2047  CG  PRO   263      44.988  33.154  27.956  1.00 59.23           C  
ATOM   2048  CD  PRO   263      46.365  33.206  28.599  1.00 59.04           C  
ATOM   2049  N   VAL   264      43.041  31.605  31.463  1.00 61.05           N  
ATOM   2050  CA  VAL   264      42.285  30.395  31.765  1.00 64.21           C  
ATOM   2051  C   VAL   264      41.010  30.540  30.933  1.00 66.60           C  
ATOM   2052  O   VAL   264      40.094  31.287  31.296  1.00 66.66           O  
ATOM   2053  CB  VAL   264      41.982  30.289  33.301  1.00 62.79           C  
ATOM   2054  CG1 VAL   264      41.001  29.171  33.586  1.00 59.66           C  
ATOM   2055  CG2 VAL   264      43.281  30.021  34.055  1.00 60.54           C  
ATOM   2056  N   LEU   265      40.973  29.837  29.802  1.00 69.38           N  
ATOM   2057  CA  LEU   265      39.838  29.937  28.892  1.00 72.80           C  
ATOM   2058  C   LEU   265      38.579  29.196  29.315  1.00 75.02           C  
ATOM   2059  O   LEU   265      38.618  28.118  29.914  1.00 73.83           O  
ATOM   2060  CB  LEU   265      40.229  29.498  27.479  1.00 72.18           C  
ATOM   2061  CG  LEU   265      41.657  29.735  27.015  1.00 71.44           C  
ATOM   2062  CD1 LEU   265      42.550  28.748  27.751  1.00 74.08           C  
ATOM   2063  CD2 LEU   265      41.775  29.505  25.518  1.00 71.15           C  
END
