
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  120 (  977),  selected  120 , name 1si2_A
# Molecule2: number of CA atoms   88 (  675),  selected   88 , name T0487_178_265.pdb
# PARAMETERS: 1si2_A.T0487_178_265.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M   224_A      -       -           -
LGA    A   225_A      -       -           -
LGA    Q   226_A      -       -           -
LGA    P   227_A      S     178          2.274
LGA    V   228_A      L     179          1.071
LGA    I   229_A      E     180          1.864
LGA    E   230_A      A     181          2.058
LGA    F   231_A      W     182          1.308
LGA    M   232_A      L     183          1.224
LGA    C   233_A      A     184          1.468
LGA    E   234_A      Q     185          1.281
LGA    V   235_A      G     186          1.303
LGA    L   236_A      H     187           -
LGA    D   237_A      -       -           -
LGA    I   238_A      -       -           -
LGA    R   239_A      -       -           -
LGA    N   240_A      -       -           -
LGA    I   241_A      -       -           -
LGA    D   242_A      -       -           -
LGA    E   243_A      -       -           -
LGA    Q   244_A      -       -           -
LGA    P   245_A      -       -           -
LGA    K   246_A      -       -           -
LGA    P   247_A      -       -           -
LGA    L   248_A      -       -           -
LGA    T   249_A      -       -           -
LGA    D   250_A      -       -           -
LGA    S   251_A      -       -           -
LGA    Q   252_A      -       -           -
LGA    R   253_A      -       -           -
LGA    V   254_A      -       -           -
LGA    R   255_A      -       -           -
LGA    F   256_A      -       -           -
LGA    T   257_A      -       -           -
LGA    K   258_A      -       -           -
LGA    E   259_A      P     188          3.140
LGA    I   260_A      L     189          1.686
LGA    K   261_A      P     190          5.903
LGA    G   262_A      K     191          3.004
LGA    L   263_A      -       -           -
LGA    K   264_A      R     192          1.232
LGA    V   265_A      V     193          1.262
LGA    E   266_A      R     194          1.144
LGA    V   267_A      N     195          0.950
LGA    T   268_A      A     196          1.415
LGA    H   269_A      Y     197          1.144
LGA    C   270_A      D     198          2.853
LGA    G   271_A      -       -           -
LGA    Q   272_A      -       -           -
LGA    M   273_A      -       -           -
LGA    K   274_A      R     199          0.451
LGA    R   275_A      R     200          0.785
LGA    K   276_A      T     201          1.047
LGA    Y   277_A      W     202          0.801
LGA    R   278_A      E     203          1.104
LGA    V   279_A      L     204          0.163
LGA    C   280_A      L     205          0.920
LGA    N   281_A      R     206          1.476
LGA    V   282_A      L     207          1.123
LGA    T   283_A      G     208          1.554
LGA    R   284_A      E     209          1.454
LGA    R   285_A      E     210          0.690
LGA    P   286_A      D     211          2.448
LGA    A   287_A      P     212          1.767
LGA    S   288_A      K     213          1.512
LGA    H   289_A      E     214          2.093
LGA    Q   290_A      L     215          2.142
LGA    T   291_A      P     216          2.004
LGA    F   292_A      L     217          2.019
LGA    P   293_A      P     218          0.771
LGA    L   294_A      G     219          3.840
LGA    Q   295_A      -       -           -
LGA    V   302_A      -       -           -
LGA    E   303_A      G     220          1.592
LGA    C   304_A      L     221          1.649
LGA    T   305_A      S     222          1.210
LGA    V   306_A      L     223          1.213
LGA    A   307_A      L     224          0.780
LGA    Q   308_A      D     225          0.253
LGA    Y   309_A      Y     226          0.348
LGA    F   310_A      H     227          0.672
LGA    K   311_A      A     228          1.599
LGA    Q   312_A      S     229          1.792
LGA    K   313_A      K     230          2.915
LGA    Y   314_A      G     231          3.741
LGA    N   315_A      R     232          5.204
LGA    L   316_A      L     233          2.578
LGA    Q   317_A      Q     234          4.653
LGA    L   318_A      G     235           #
LGA    K   319_A      R     236          3.851
LGA    Y   320_A      E     237          3.278
LGA    P   321_A      G     238          4.028
LGA    H   322_A      G     239          5.389
LGA    L   323_A      R     240          2.452
LGA    P   324_A      -       -           -
LGA    C   325_A      V     241          1.671
LGA    L   326_A      A     242          1.315
LGA    Q   327_A      W     243          1.396
LGA    V   328_A      V     244          1.395
LGA    G   329_A      A     245          1.118
LGA    -       -      D     246           -
LGA    -       -      P     247           -
LGA    -       -      K     248           -
LGA    Q   330_A      D     249          4.438
LGA    E   331_A      P     250          6.107
LGA    Q   332_A      R     251          4.870
LGA    K   333_A      K     252          2.819
LGA    H   334_A      P     253          2.925
LGA    T   335_A      I     254          1.361
LGA    Y   336_A      P     255          1.551
LGA    L   337_A      H     256          1.723
LGA    P   338_A      L     257          1.258
LGA    L   339_A      T     258          0.867
LGA    E   340_A      G     259          1.487
LGA    V   341_A      L     260          1.617
LGA    C   342_A      L     261          1.027
LGA    N   343_A      V     262          0.992
LGA    I   344_A      P     263          1.265
LGA    V   345_A      V     264          1.271
LGA    A   346_A      L     265          2.110
LGA    G   347_A      -       -           -
LGA    Q   348_A      -       -           -
LGA    R   349_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  120   88    5.0     83    2.34    12.05     71.804     3.404

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.996209 * X  +   0.061659 * Y  +   0.061373 * Z  +  33.966747
  Y_new =   0.084691 * X  +  -0.848708 * Y  +  -0.522037 * Z  +  95.798782
  Z_new =   0.019899 * X  +   0.525255 * Y  +  -0.850712 * Z  +  -5.642717 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.588455   -0.553137  [ DEG:   148.3076    -31.6924 ]
  Theta =  -0.019901   -3.121692  [ DEG:    -1.1402   -178.8598 ]
  Phi   =   0.084809   -3.056784  [ DEG:     4.8592   -175.1408 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1si2_A                                        
REMARK     2: T0487_178_265.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1si2_A.T0487_178_265.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  120   88   5.0   83   2.34   12.05  71.804
REMARK  ---------------------------------------------------------- 
MOLECULE 1si2_A
HEADER    GENE REGULATION/RNA/DNA                 26-FEB-04   1SI2              
TITLE     CRYSTAL STRUCTURE OF THE PAZ DOMAIN OF HUMAN EIF2C1 IN                
TITLE    2 COMPLEX WITH A 9-MER SIRNA-LIKE DUPLEX OF DEOXYNUCLEOTIDE            
TITLE    3 OVERHANG                                                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: EUKARYOTIC TRANSLATION INITIATION FACTOR 2C 1;             
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: PAZ DOMAIN (RESIDUES 225-369);                             
COMPND   5 SYNONYM: EIF2C 1, EIF-2C 1, PUTATIVE RNA-BINDING PROTEIN             
COMPND   6 Q99, ARGONAUTE 1;                                                    
COMPND   7 ENGINEERED: YES;                                                     
COMPND   8 MOL_ID: 2;                                                           
COMPND   9 MOLECULE: 5'-R(*CP*GP*UP*GP*AP*CP*U)-D(P*CP*T)-3';                   
COMPND  10 CHAIN: B;                                                            
COMPND  11 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: EIF2C1;                                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PET19B;                                   
SOURCE  10 MOL_ID: 2;                                                           
SOURCE  11 SYNTHETIC: YES                                                       
KEYWDS    PROTEIN-RNA COMPLEX, RNA INTERFERENCE, DOUBLE HELIX,                  
KEYWDS   2 OVERHANG                                                             
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.YE,J.B.MA,D.PATEL                                                   
REVDAT   1   25-MAY-04 1SI2    0                                                
JRNL        AUTH   J.B.MA,K.YE,D.J.PATEL                                        
JRNL        TITL   STRUCTURAL BASIS FOR OVERHANG-SPECIFIC SMALL                 
JRNL        TITL 2 INTERFERING RNA RECOGNITION BY THE PAZ DOMAIN.               
JRNL        REF    NATURE                        V. 429   318 2004              
JRNL        REFN   ASTM NATUAS  UK ISSN 0028-0836                               
REMARK   2 RESOLUTION. 2.60 ANGSTROMS.                                          
DBREF  1SI2 A  225   369  UNP    Q9UL18   I2C1_HUMAN     225    369             
SEQRES   1 A  149  GLY SER HIS MET ALA GLN PRO VAL ILE GLU PHE MET CYS          
SEQRES   2 A  149  GLU VAL LEU ASP ILE ARG ASN ILE ASP GLU GLN PRO LYS          
SEQRES   3 A  149  PRO LEU THR ASP SER GLN ARG VAL ARG PHE THR LYS GLU          
SEQRES   4 A  149  ILE LYS GLY LEU LYS VAL GLU VAL THR HIS CYS GLY GLN          
SEQRES   5 A  149  MET LYS ARG LYS TYR ARG VAL CYS ASN VAL THR ARG ARG          
SEQRES   6 A  149  PRO ALA SER HIS GLN THR PHE PRO LEU GLN LEU GLU SER          
SEQRES   7 A  149  GLY GLN THR VAL GLU CYS THR VAL ALA GLN TYR PHE LYS          
SEQRES   8 A  149  GLN LYS TYR ASN LEU GLN LEU LYS TYR PRO HIS LEU PRO          
SEQRES   9 A  149  CYS LEU GLN VAL GLY GLN GLU GLN LYS HIS THR TYR LEU          
SEQRES  10 A  149  PRO LEU GLU VAL CYS ASN ILE VAL ALA GLY GLN ARG CYS          
SEQRES  11 A  149  ILE LYS LYS LEU THR ASP ASN GLN THR SER THR MET ILE          
SEQRES  12 A  149  LYS ALA THR ALA ARG SER                                      
SEQRES   1 B    9    C   G   U   G   A   C   U  DC  DT                          
FORMUL   3  HOH   *16(H2 O)                                                     
CRYST1  100.051  100.051   34.438  90.00  90.00 120.00 P 64          6          
ATOM      1  N   MET A 224      42.963  23.389  25.544  1.00 52.38           N  
ATOM      2  CA  MET A 224      44.324  23.935  25.823  1.00 52.59           C  
ATOM      3  C   MET A 224      44.253  25.393  26.296  1.00 52.94           C  
ATOM      4  O   MET A 224      43.293  26.119  25.997  1.00 54.96           O  
ATOM      5  CB  MET A 224      45.192  23.844  24.562  1.00 50.91           C  
ATOM      6  N   ALA A 225      45.269  25.817  27.042  1.00 50.40           N  
ATOM      7  CA  ALA A 225      45.330  27.183  27.543  1.00 48.00           C  
ATOM      8  C   ALA A 225      46.055  28.069  26.525  1.00 47.11           C  
ATOM      9  O   ALA A 225      47.061  27.667  25.943  1.00 48.50           O  
ATOM     10  CB  ALA A 225      46.057  27.213  28.877  1.00 47.45           C  
ATOM     11  N   GLN A 226      45.540  29.274  26.306  1.00 44.10           N  
ATOM     12  CA  GLN A 226      46.151  30.199  25.355  1.00 40.99           C  
ATOM     13  C   GLN A 226      46.973  31.247  26.100  1.00 37.33           C  
ATOM     14  O   GLN A 226      46.497  31.820  27.074  1.00 37.18           O  
ATOM     15  CB  GLN A 226      45.056  30.879  24.524  1.00 40.68           C  
ATOM     16  CG  GLN A 226      45.531  32.044  23.679  1.00 43.58           C  
ATOM     17  CD  GLN A 226      44.377  32.804  23.017  1.00 45.62           C  
ATOM     18  OE1 GLN A 226      43.376  33.135  23.664  1.00 47.26           O  
ATOM     19  NE2 GLN A 226      44.524  33.094  21.731  1.00 45.40           N  
ATOM     20  N   PRO A 227      48.231  31.483  25.672  1.00 35.16           N  
ATOM     21  CA  PRO A 227      49.116  32.477  26.310  1.00 32.80           C  
ATOM     22  C   PRO A 227      48.422  33.834  26.254  1.00 31.10           C  
ATOM     23  O   PRO A 227      47.829  34.174  25.228  1.00 27.12           O  
ATOM     24  CB  PRO A 227      50.364  32.449  25.435  1.00 32.44           C  
ATOM     25  CG  PRO A 227      50.374  31.037  24.907  1.00 32.88           C  
ATOM     26  CD  PRO A 227      48.922  30.800  24.566  1.00 32.92           C  
ATOM     27  N   VAL A 228      48.474  34.611  27.332  1.00 30.03           N  
ATOM     28  CA  VAL A 228      47.776  35.879  27.277  1.00 31.96           C  
ATOM     29  C   VAL A 228      48.462  36.816  26.311  1.00 32.86           C  
ATOM     30  O   VAL A 228      47.831  37.749  25.805  1.00 33.50           O  
ATOM     31  CB  VAL A 228      47.595  36.551  28.683  1.00 32.17           C  
ATOM     32  CG1 VAL A 228      47.635  35.501  29.760  1.00 34.34           C  
ATOM     33  CG2 VAL A 228      48.601  37.646  28.910  1.00 30.53           C  
ATOM     34  N   ILE A 229      49.744  36.565  26.039  1.00 33.20           N  
ATOM     35  CA  ILE A 229      50.463  37.401  25.089  1.00 34.92           C  
ATOM     36  C   ILE A 229      49.790  37.260  23.730  1.00 36.35           C  
ATOM     37  O   ILE A 229      49.523  38.254  23.062  1.00 38.30           O  
ATOM     38  CB  ILE A 229      51.940  36.999  24.954  1.00 35.52           C  
ATOM     39  CG1 ILE A 229      52.713  37.396  26.211  1.00 36.34           C  
ATOM     40  CG2 ILE A 229      52.551  37.704  23.747  1.00 32.23           C  
ATOM     41  CD1 ILE A 229      53.021  38.890  26.292  1.00 38.17           C  
ATOM     42  N   GLU A 230      49.518  36.023  23.326  1.00 37.53           N  
ATOM     43  CA  GLU A 230      48.850  35.753  22.051  1.00 39.85           C  
ATOM     44  C   GLU A 230      47.433  36.319  22.031  1.00 39.61           C  
ATOM     45  O   GLU A 230      46.966  36.814  20.999  1.00 41.29           O  
ATOM     46  CB  GLU A 230      48.760  34.251  21.793  1.00 41.84           C  
ATOM     47  CG  GLU A 230      50.004  33.612  21.236  1.00 46.38           C  
ATOM     48  CD  GLU A 230      49.800  32.129  20.975  1.00 51.38           C  
ATOM     49  OE1 GLU A 230      48.696  31.755  20.488  1.00 54.04           O  
ATOM     50  OE2 GLU A 230      50.738  31.343  21.246  1.00 50.78           O  
ATOM     51  N   PHE A 231      46.740  36.216  23.162  1.00 37.57           N  
ATOM     52  CA  PHE A 231      45.379  36.720  23.266  1.00 36.65           C  
ATOM     53  C   PHE A 231      45.429  38.233  23.037  1.00 37.36           C  
ATOM     54  O   PHE A 231      44.607  38.796  22.302  1.00 36.35           O  
ATOM     55  CB  PHE A 231      44.801  36.395  24.647  1.00 34.48           C  
ATOM     56  CG  PHE A 231      43.431  36.963  24.878  1.00 33.71           C  
ATOM     57  CD1 PHE A 231      42.327  36.451  24.207  1.00 34.73           C  
ATOM     58  CD2 PHE A 231      43.240  38.009  25.772  1.00 32.23           C  
ATOM     59  CE1 PHE A 231      41.037  36.977  24.429  1.00 32.92           C  
ATOM     60  CE2 PHE A 231      41.969  38.539  25.999  1.00 31.09           C  
ATOM     61  CZ  PHE A 231      40.866  38.020  25.326  1.00 30.70           C  
ATOM     62  N   MET A 232      46.405  38.879  23.670  1.00 36.36           N  
ATOM     63  CA  MET A 232      46.604  40.308  23.531  1.00 36.15           C  
ATOM     64  C   MET A 232      46.823  40.669  22.063  1.00 37.14           C  
ATOM     65  O   MET A 232      46.103  41.487  21.489  1.00 39.46           O  
ATOM     66  CB  MET A 232      47.828  40.746  24.327  1.00 35.37           C  
ATOM     67  CG  MET A 232      48.191  42.203  24.096  1.00 38.18           C  
ATOM     68  SD  MET A 232      49.880  42.610  24.558  1.00 36.65           S  
ATOM     69  CE  MET A 232      49.591  43.302  26.105  1.00 40.66           C  
ATOM     70  N   CYS A 233      47.830  40.064  21.453  1.00 36.87           N  
ATOM     71  CA  CYS A 233      48.121  40.360  20.066  1.00 38.58           C  
ATOM     72  C   CYS A 233      46.855  40.242  19.219  1.00 39.51           C  
ATOM     73  O   CYS A 233      46.631  41.025  18.293  1.00 39.08           O  
ATOM     74  CB  CYS A 233      49.227  39.431  19.551  1.00 39.52           C  
ATOM     75  SG  CYS A 233      50.886  39.809  20.234  1.00 39.09           S  
ATOM     76  N   GLU A 234      46.013  39.273  19.544  1.00 40.02           N  
ATOM     77  CA  GLU A 234      44.779  39.101  18.796  1.00 41.18           C  
ATOM     78  C   GLU A 234      43.822  40.249  19.045  1.00 41.42           C  
ATOM     79  O   GLU A 234      43.157  40.725  18.121  1.00 41.31           O  
ATOM     80  CB  GLU A 234      44.095  37.801  19.183  1.00 43.27           C  
ATOM     81  CG  GLU A 234      44.652  36.582  18.502  1.00 47.38           C  
ATOM     82  CD  GLU A 234      43.886  35.352  18.898  1.00 49.81           C  
ATOM     83  OE1 GLU A 234      44.137  34.270  18.320  1.00 50.55           O  
ATOM     84  OE2 GLU A 234      43.027  35.482  19.798  1.00 49.97           O  
ATOM     85  N   VAL A 235      43.742  40.682  20.300  1.00 40.88           N  
ATOM     86  CA  VAL A 235      42.853  41.773  20.654  1.00 39.94           C  
ATOM     87  C   VAL A 235      43.312  43.079  20.006  1.00 41.16           C  
ATOM     88  O   VAL A 235      42.505  43.806  19.433  1.00 40.57           O  
ATOM     89  CB  VAL A 235      42.769  41.939  22.188  1.00 38.98           C  
ATOM     90  CG1 VAL A 235      41.923  43.170  22.549  1.00 37.30           C  
ATOM     91  CG2 VAL A 235      42.163  40.683  22.801  1.00 34.82           C  
ATOM     92  N   LEU A 236      44.612  43.356  20.068  1.00 43.03           N  
ATOM     93  CA  LEU A 236      45.166  44.586  19.501  1.00 44.18           C  
ATOM     94  C   LEU A 236      45.541  44.508  18.017  1.00 46.99           C  
ATOM     95  O   LEU A 236      46.062  45.477  17.454  1.00 46.39           O  
ATOM     96  CB  LEU A 236      46.393  44.997  20.301  1.00 41.70           C  
ATOM     97  CG  LEU A 236      46.147  45.204  21.794  1.00 41.15           C  
ATOM     98  CD1 LEU A 236      47.470  45.507  22.450  1.00 42.04           C  
ATOM     99  CD2 LEU A 236      45.152  46.331  22.035  1.00 38.51           C  
ATOM    100  N   ASP A 237      45.267  43.362  17.394  1.00 48.83           N  
ATOM    101  CA  ASP A 237      45.582  43.136  15.990  1.00 52.87           C  
ATOM    102  C   ASP A 237      47.075  43.265  15.684  1.00 55.31           C  
ATOM    103  O   ASP A 237      47.477  44.026  14.810  1.00 55.62           O  
ATOM    104  CB  ASP A 237      44.783  44.091  15.105  1.00 54.58           C  
ATOM    105  CG  ASP A 237      43.336  43.663  14.948  1.00 57.38           C  
ATOM    106  OD1 ASP A 237      42.514  44.475  14.468  1.00 58.01           O  
ATOM    107  OD2 ASP A 237      43.022  42.505  15.297  1.00 59.76           O  
ATOM    108  N   ILE A 238      47.892  42.515  16.415  1.00 58.11           N  
ATOM    109  CA  ILE A 238      49.337  42.529  16.215  1.00 61.54           C  
ATOM    110  C   ILE A 238      49.778  41.158  15.715  1.00 65.30           C  
ATOM    111  O   ILE A 238      49.158  40.145  16.043  1.00 65.49           O  
ATOM    112  CB  ILE A 238      50.100  42.803  17.531  1.00 60.01           C  
ATOM    113  CG1 ILE A 238      49.671  44.135  18.132  1.00 58.58           C  
ATOM    114  CG2 ILE A 238      51.589  42.829  17.271  1.00 58.16           C  
ATOM    115  CD1 ILE A 238      50.382  44.466  19.416  1.00 56.13           C  
ATOM    116  N   ARG A 239      50.841  41.131  14.916  1.00 69.89           N  
ATOM    117  CA  ARG A 239      51.388  39.876  14.402  1.00 74.71           C  
ATOM    118  C   ARG A 239      52.892  39.895  14.641  1.00 76.52           C  
ATOM    119  O   ARG A 239      53.532  38.855  14.787  1.00 76.84           O  
ATOM    120  CB  ARG A 239      51.118  39.724  12.896  1.00 76.15           C  
ATOM    121  CG  ARG A 239      49.649  39.696  12.506  1.00 78.93           C  
ATOM    122  CD  ARG A 239      49.458  39.287  11.041  1.00 81.78           C  
ATOM    123  NE  ARG A 239      48.066  39.444  10.612  1.00 84.06           N  
ATOM    124  CZ  ARG A 239      47.557  38.957   9.482  1.00 83.56           C  
ATOM    125  NH1 ARG A 239      48.319  38.270   8.643  1.00 83.45           N  
ATOM    126  NH2 ARG A 239      46.277  39.158   9.192  1.00 82.75           N  
ATOM    127  N   ASN A 240      53.432  41.106  14.703  1.00 79.88           N  
ATOM    128  CA  ASN A 240      54.860  41.352  14.890  1.00 82.09           C  
ATOM    129  C   ASN A 240      55.228  41.769  16.313  1.00 82.28           C  
ATOM    130  O   ASN A 240      56.052  42.668  16.504  1.00 81.15           O  
ATOM    131  CB  ASN A 240      55.296  42.455  13.924  1.00 84.41           C  
ATOM    132  CG  ASN A 240      54.517  43.757  14.131  1.00 85.46           C  
ATOM    133  OD1 ASN A 240      53.285  43.784  14.031  1.00 85.25           O  
ATOM    134  ND2 ASN A 240      55.235  44.837  14.424  1.00 85.27           N  
ATOM    135  N   ILE A 241      54.632  41.125  17.311  1.00 82.81           N  
ATOM    136  CA  ILE A 241      54.925  41.485  18.691  1.00 83.45           C  
ATOM    137  C   ILE A 241      56.424  41.475  18.953  1.00 84.72           C  
ATOM    138  O   ILE A 241      56.921  42.210  19.807  1.00 85.15           O  
ATOM    139  CB  ILE A 241      54.237  40.534  19.687  1.00 82.67           C  
ATOM    140  CG1 ILE A 241      54.519  41.006  21.114  1.00 81.66           C  
ATOM    141  CG2 ILE A 241      54.722  39.107  19.472  1.00 82.24           C  
ATOM    142  CD1 ILE A 241      53.814  40.213  22.167  1.00 82.39           C  
ATOM    143  N   ASP A 242      57.141  40.647  18.203  1.00 86.29           N  
ATOM    144  CA  ASP A 242      58.586  40.533  18.352  1.00 87.25           C  
ATOM    145  C   ASP A 242      59.334  41.351  17.312  1.00 86.99           C  
ATOM    146  O   ASP A 242      60.429  40.987  16.889  1.00 86.30           O  
ATOM    147  CB  ASP A 242      58.996  39.065  18.258  1.00 88.44           C  
ATOM    148  CG  ASP A 242      58.592  38.274  19.484  1.00 89.82           C  
ATOM    149  OD1 ASP A 242      58.547  37.027  19.405  1.00 90.72           O  
ATOM    150  OD2 ASP A 242      58.330  38.902  20.533  1.00 90.52           O  
ATOM    151  N   GLU A 243      58.734  42.462  16.905  1.00 87.05           N  
ATOM    152  CA  GLU A 243      59.337  43.341  15.915  1.00 87.22           C  
ATOM    153  C   GLU A 243      59.217  44.752  16.471  1.00 86.78           C  
ATOM    154  O   GLU A 243      60.060  45.616  16.226  1.00 86.45           O  
ATOM    155  CB  GLU A 243      58.583  43.210  14.591  1.00 88.04           C  
ATOM    156  CG  GLU A 243      59.283  43.815  13.388  1.00 90.84           C  
ATOM    157  CD  GLU A 243      58.574  43.485  12.080  1.00 93.05           C  
ATOM    158  OE1 GLU A 243      57.395  43.877  11.922  1.00 93.97           O  
ATOM    159  OE2 GLU A 243      59.195  42.831  11.210  1.00 93.68           O  
ATOM    160  N   GLN A 244      58.154  44.959  17.240  1.00 86.41           N  
ATOM    161  CA  GLN A 244      57.878  46.239  17.871  1.00 84.76           C  
ATOM    162  C   GLN A 244      58.029  46.135  19.379  1.00 83.00           C  
ATOM    163  O   GLN A 244      57.041  45.972  20.100  1.00 83.36           O  
ATOM    164  CB  GLN A 244      56.454  46.701  17.566  1.00 86.16           C  
ATOM    165  CG  GLN A 244      56.257  47.368  16.221  1.00 88.16           C  
ATOM    166  CD  GLN A 244      54.842  47.897  16.063  1.00 88.79           C  
ATOM    167  OE1 GLN A 244      54.347  48.635  16.917  1.00 88.89           O  
ATOM    168  NE2 GLN A 244      54.182  47.522  14.971  1.00 89.30           N  
ATOM    169  N   PRO A 245      59.270  46.202  19.878  1.00 80.90           N  
ATOM    170  CA  PRO A 245      59.470  46.118  21.329  1.00 78.97           C  
ATOM    171  C   PRO A 245      58.937  47.404  21.978  1.00 76.61           C  
ATOM    172  O   PRO A 245      59.408  47.832  23.036  1.00 76.48           O  
ATOM    173  CB  PRO A 245      60.986  45.980  21.461  1.00 79.18           C  
ATOM    174  CG  PRO A 245      61.373  45.288  20.178  1.00 79.96           C  
ATOM    175  CD  PRO A 245      60.545  46.031  19.161  1.00 80.00           C  
ATOM    176  N   LYS A 246      57.951  48.005  21.316  1.00 73.23           N  
ATOM    177  CA  LYS A 246      57.312  49.241  21.760  1.00 68.77           C  
ATOM    178  C   LYS A 246      56.281  48.964  22.845  1.00 64.22           C  
ATOM    179  O   LYS A 246      55.585  47.950  22.812  1.00 62.98           O  
ATOM    180  CB  LYS A 246      56.603  49.916  20.581  1.00 70.46           C  
ATOM    181  CG  LYS A 246      57.419  49.997  19.295  1.00 72.30           C  
ATOM    182  CD  LYS A 246      56.586  50.581  18.153  1.00 73.74           C  
ATOM    183  CE  LYS A 246      57.387  50.650  16.850  1.00 75.11           C  
ATOM    184  NZ  LYS A 246      56.624  51.287  15.730  1.00 73.49           N  
ATOM    185  N   PRO A 247      56.168  49.869  23.826  1.00 60.77           N  
ATOM    186  CA  PRO A 247      55.184  49.648  24.884  1.00 57.60           C  
ATOM    187  C   PRO A 247      53.797  49.787  24.264  1.00 55.28           C  
ATOM    188  O   PRO A 247      53.660  49.994  23.057  1.00 55.92           O  
ATOM    189  CB  PRO A 247      55.476  50.776  25.872  1.00 57.61           C  
ATOM    190  CG  PRO A 247      56.906  51.108  25.621  1.00 58.03           C  
ATOM    191  CD  PRO A 247      56.994  51.050  24.124  1.00 59.36           C  
ATOM    192  N   LEU A 248      52.767  49.677  25.088  1.00 51.83           N  
ATOM    193  CA  LEU A 248      51.410  49.812  24.597  1.00 47.06           C  
ATOM    194  C   LEU A 248      50.909  51.261  24.672  1.00 45.36           C  
ATOM    195  O   LEU A 248      51.283  52.022  25.571  1.00 43.17           O  
ATOM    196  CB  LEU A 248      50.474  48.908  25.399  1.00 43.07           C  
ATOM    197  CG  LEU A 248      50.582  47.409  25.136  1.00 42.14           C  
ATOM    198  CD1 LEU A 248      49.561  46.661  26.004  1.00 40.10           C  
ATOM    199  CD2 LEU A 248      50.338  47.133  23.664  1.00 37.81           C  
ATOM    200  N   THR A 249      50.074  51.641  23.712  1.00 43.18           N  
ATOM    201  CA  THR A 249      49.497  52.976  23.720  1.00 43.01           C  
ATOM    202  C   THR A 249      48.411  52.946  24.800  1.00 42.41           C  
ATOM    203  O   THR A 249      47.980  51.867  25.220  1.00 41.63           O  
ATOM    204  CB  THR A 249      48.845  53.321  22.360  1.00 43.99           C  
ATOM    205  OG1 THR A 249      47.700  52.483  22.141  1.00 43.31           O  
ATOM    206  CG2 THR A 249      49.834  53.105  21.222  1.00 43.10           C  
ATOM    207  N   ASP A 250      47.974  54.115  25.258  1.00 41.87           N  
ATOM    208  CA  ASP A 250      46.930  54.170  26.276  1.00 41.52           C  
ATOM    209  C   ASP A 250      45.674  53.577  25.677  1.00 39.85           C  
ATOM    210  O   ASP A 250      44.873  52.920  26.358  1.00 39.07           O  
ATOM    211  CB  ASP A 250      46.684  55.608  26.704  1.00 43.78           C  
ATOM    212  CG  ASP A 250      47.871  56.199  27.436  1.00 48.32           C  
ATOM    213  OD1 ASP A 250      48.142  55.743  28.572  1.00 48.21           O  
ATOM    214  OD2 ASP A 250      48.539  57.101  26.874  1.00 49.56           O  
ATOM    215  N   SER A 251      45.537  53.788  24.377  1.00 37.14           N  
ATOM    216  CA  SER A 251      44.412  53.287  23.624  1.00 35.28           C  
ATOM    217  C   SER A 251      44.470  51.759  23.618  1.00 35.70           C  
ATOM    218  O   SER A 251      43.476  51.079  23.885  1.00 36.45           O  
ATOM    219  CB  SER A 251      44.496  53.840  22.207  1.00 35.23           C  
ATOM    220  OG  SER A 251      43.380  53.488  21.430  1.00 34.72           O  
ATOM    221  N   GLN A 252      45.648  51.219  23.334  1.00 36.07           N  
ATOM    222  CA  GLN A 252      45.824  49.772  23.287  1.00 36.43           C  
ATOM    223  C   GLN A 252      45.621  49.102  24.642  1.00 35.84           C  
ATOM    224  O   GLN A 252      45.002  48.041  24.730  1.00 35.49           O  
ATOM    225  CB  GLN A 252      47.210  49.434  22.748  1.00 37.68           C  
ATOM    226  CG  GLN A 252      47.431  49.885  21.316  1.00 40.46           C  
ATOM    227  CD  GLN A 252      48.869  49.683  20.846  1.00 42.15           C  
ATOM    228  OE1 GLN A 252      49.823  50.221  21.434  1.00 39.89           O  
ATOM    229  NE2 GLN A 252      49.030  48.902  19.778  1.00 40.50           N  
ATOM    230  N   ARG A 253      46.147  49.720  25.694  1.00 35.21           N  
ATOM    231  CA  ARG A 253      46.016  49.173  27.036  1.00 34.65           C  
ATOM    232  C   ARG A 253      44.552  49.109  27.425  1.00 36.54           C  
ATOM    233  O   ARG A 253      44.096  48.097  27.959  1.00 36.61           O  
ATOM    234  CB  ARG A 253      46.786  50.034  28.041  1.00 34.72           C  
ATOM    235  CG  ARG A 253      46.591  49.636  29.498  1.00 35.92           C  
ATOM    236  CD  ARG A 253      47.543  50.400  30.417  1.00 35.57           C  
ATOM    237  NE  ARG A 253      47.580  51.815  30.080  1.00 36.80           N  
ATOM    238  CZ  ARG A 253      46.552  52.644  30.221  1.00 38.77           C  
ATOM    239  NH1 ARG A 253      46.675  53.920  29.874  1.00 38.11           N  
ATOM    240  NH2 ARG A 253      45.406  52.197  30.724  1.00 38.54           N  
ATOM    241  N   VAL A 254      43.815  50.189  27.159  1.00 37.64           N  
ATOM    242  CA  VAL A 254      42.388  50.237  27.482  1.00 37.26           C  
ATOM    243  C   VAL A 254      41.617  49.171  26.711  1.00 38.17           C  
ATOM    244  O   VAL A 254      40.699  48.547  27.256  1.00 38.65           O  
ATOM    245  CB  VAL A 254      41.766  51.622  27.167  1.00 36.43           C  
ATOM    246  CG1 VAL A 254      40.250  51.505  27.117  1.00 34.13           C  
ATOM    247  CG2 VAL A 254      42.163  52.632  28.244  1.00 33.45           C  
ATOM    248  N   ARG A 255      41.980  48.962  25.448  1.00 37.96           N  
ATOM    249  CA  ARG A 255      41.303  47.953  24.636  1.00 36.76           C  
ATOM    250  C   ARG A 255      41.630  46.549  25.124  1.00 34.69           C  
ATOM    251  O   ARG A 255      40.773  45.663  25.115  1.00 36.25           O  
ATOM    252  CB  ARG A 255      41.699  48.083  23.171  1.00 38.30           C  
ATOM    253  CG  ARG A 255      40.762  48.943  22.352  1.00 43.22           C  
ATOM    254  CD  ARG A 255      41.178  48.928  20.894  1.00 44.70           C  
ATOM    255  NE  ARG A 255      42.380  49.722  20.687  1.00 47.64           N  
ATOM    256  CZ  ARG A 255      43.318  49.432  19.796  1.00 48.16           C  
ATOM    257  NH1 ARG A 255      43.183  48.352  19.034  1.00 48.07           N  
ATOM    258  NH2 ARG A 255      44.378  50.225  19.666  1.00 46.39           N  
ATOM    259  N   PHE A 256      42.870  46.347  25.544  1.00 29.28           N  
ATOM    260  CA  PHE A 256      43.282  45.048  26.036  1.00 27.29           C  
ATOM    261  C   PHE A 256      42.653  44.767  27.413  1.00 27.59           C  
ATOM    262  O   PHE A 256      42.163  43.664  27.660  1.00 28.06           O  
ATOM    263  CB  PHE A 256      44.807  45.001  26.128  1.00 25.39           C  
ATOM    264  CG  PHE A 256      45.344  43.756  26.773  1.00 24.47           C  
ATOM    265  CD1 PHE A 256      46.256  43.840  27.820  1.00 24.94           C  
ATOM    266  CD2 PHE A 256      44.959  42.499  26.327  1.00 22.67           C  
ATOM    267  CE1 PHE A 256      46.770  42.682  28.404  1.00 25.93           C  
ATOM    268  CE2 PHE A 256      45.473  41.345  26.909  1.00 19.72           C  
ATOM    269  CZ  PHE A 256      46.371  41.434  27.937  1.00 20.32           C  
ATOM    270  N   THR A 257      42.664  45.766  28.294  1.00 25.59           N  
ATOM    271  CA  THR A 257      42.111  45.621  29.636  1.00 26.20           C  
ATOM    272  C   THR A 257      40.667  45.145  29.627  1.00 29.13           C  
ATOM    273  O   THR A 257      40.305  44.236  30.376  1.00 30.70           O  
ATOM    274  CB  THR A 257      42.174  46.942  30.418  1.00 24.74           C  
ATOM    275  OG1 THR A 257      43.531  47.395  30.495  1.00 23.79           O  
ATOM    276  CG2 THR A 257      41.648  46.748  31.818  1.00 22.13           C  
ATOM    277  N   LYS A 258      39.847  45.761  28.782  1.00 30.52           N  
ATOM    278  CA  LYS A 258      38.438  45.395  28.673  1.00 32.09           C  
ATOM    279  C   LYS A 258      38.223  43.920  28.420  1.00 32.38           C  
ATOM    280  O   LYS A 258      37.261  43.334  28.914  1.00 33.55           O  
ATOM    281  CB  LYS A 258      37.766  46.161  27.534  1.00 33.10           C  
ATOM    282  CG  LYS A 258      37.281  47.541  27.910  1.00 35.45           C  
ATOM    283  CD  LYS A 258      36.707  48.247  26.687  1.00 39.57           C  
ATOM    284  CE  LYS A 258      36.216  49.641  27.023  1.00 38.42           C  
ATOM    285  NZ  LYS A 258      35.798  50.366  25.795  1.00 40.54           N  
ATOM    286  N   GLU A 259      39.123  43.329  27.644  1.00 32.40           N  
ATOM    287  CA  GLU A 259      39.021  41.926  27.278  1.00 32.18           C  
ATOM    288  C   GLU A 259      39.576  40.952  28.293  1.00 31.65           C  
ATOM    289  O   GLU A 259      39.040  39.864  28.470  1.00 30.84           O  
ATOM    290  CB  GLU A 259      39.726  41.700  25.944  1.00 33.15           C  
ATOM    291  CG  GLU A 259      39.233  42.618  24.867  1.00 38.11           C  
ATOM    292  CD  GLU A 259      37.749  42.451  24.602  1.00 41.42           C  
ATOM    293  OE1 GLU A 259      37.113  43.415  24.121  1.00 44.27           O  
ATOM    294  OE2 GLU A 259      37.214  41.352  24.863  1.00 45.67           O  
ATOM    295  N   ILE A 260      40.659  41.330  28.954  1.00 31.09           N  
ATOM    296  CA  ILE A 260      41.265  40.427  29.909  1.00 30.60           C  
ATOM    297  C   ILE A 260      40.645  40.524  31.292  1.00 31.75           C  
ATOM    298  O   ILE A 260      40.656  39.558  32.047  1.00 33.59           O  
ATOM    299  CB  ILE A 260      42.788  40.660  29.987  1.00 29.45           C  
ATOM    300  CG1 ILE A 260      43.429  39.555  30.820  1.00 28.39           C  
ATOM    301  CG2 ILE A 260      43.089  42.037  30.533  1.00 28.77           C  
ATOM    302  CD1 ILE A 260      43.397  38.206  30.138  1.00 24.75           C  
ATOM    303  N   LYS A 261      40.092  41.685  31.624  1.00 32.87           N  
ATOM    304  CA  LYS A 261      39.465  41.874  32.922  1.00 32.84           C  
ATOM    305  C   LYS A 261      38.329  40.859  33.109  1.00 32.06           C  
ATOM    306  O   LYS A 261      37.421  40.771  32.287  1.00 31.79           O  
ATOM    307  CB  LYS A 261      38.920  43.297  33.026  1.00 35.86           C  
ATOM    308  CG  LYS A 261      38.567  43.727  34.440  1.00 40.84           C  
ATOM    309  CD  LYS A 261      38.025  45.166  34.486  1.00 45.18           C  
ATOM    310  CE  LYS A 261      39.069  46.187  34.054  1.00 49.21           C  
ATOM    311  NZ  LYS A 261      38.586  47.602  34.174  1.00 51.15           N  
ATOM    312  N   GLY A 262      38.392  40.073  34.175  1.00 31.02           N  
ATOM    313  CA  GLY A 262      37.340  39.103  34.421  1.00 30.28           C  
ATOM    314  C   GLY A 262      37.622  37.697  33.924  1.00 29.73           C  
ATOM    315  O   GLY A 262      36.913  36.768  34.291  1.00 30.16           O  
ATOM    316  N   LEU A 263      38.625  37.532  33.065  1.00 28.43           N  
ATOM    317  CA  LEU A 263      38.970  36.196  32.579  1.00 27.28           C  
ATOM    318  C   LEU A 263      39.812  35.494  33.641  1.00 26.61           C  
ATOM    319  O   LEU A 263      40.400  36.139  34.507  1.00 26.48           O  
ATOM    320  CB  LEU A 263      39.752  36.266  31.256  1.00 23.87           C  
ATOM    321  CG  LEU A 263      38.956  36.745  30.029  1.00 24.19           C  
ATOM    322  CD1 LEU A 263      39.703  36.374  28.739  1.00 15.15           C  
ATOM    323  CD2 LEU A 263      37.552  36.110  30.046  1.00 17.55           C  
ATOM    324  N   LYS A 264      39.850  34.172  33.588  1.00 28.49           N  
ATOM    325  CA  LYS A 264      40.635  33.408  34.550  1.00 29.38           C  
ATOM    326  C   LYS A 264      41.952  32.986  33.909  1.00 28.17           C  
ATOM    327  O   LYS A 264      41.975  32.526  32.752  1.00 24.66           O  
ATOM    328  CB  LYS A 264      39.877  32.159  35.015  1.00 31.34           C  
ATOM    329  CG  LYS A 264      40.676  31.316  36.010  1.00 36.49           C  
ATOM    330  CD  LYS A 264      39.971  30.016  36.368  1.00 41.39           C  
ATOM    331  CE  LYS A 264      38.679  30.260  37.145  1.00 43.50           C  
ATOM    332  NZ  LYS A 264      38.084  28.998  37.681  1.00 42.27           N  
ATOM    333  N   VAL A 265      43.042  33.138  34.655  1.00 25.32           N  
ATOM    334  CA  VAL A 265      44.338  32.743  34.124  1.00 26.67           C  
ATOM    335  C   VAL A 265      45.130  31.782  35.009  1.00 28.03           C  
ATOM    336  O   VAL A 265      44.927  31.719  36.222  1.00 28.96           O  
ATOM    337  CB  VAL A 265      45.227  33.970  33.829  1.00 24.50           C  
ATOM    338  CG1 VAL A 265      44.572  34.829  32.790  1.00 24.10           C  
ATOM    339  CG2 VAL A 265      45.489  34.759  35.106  1.00 22.56           C  
ATOM    340  N   GLU A 266      46.037  31.038  34.391  1.00 29.22           N  
ATOM    341  CA  GLU A 266      46.874  30.103  35.130  1.00 32.33           C  
ATOM    342  C   GLU A 266      48.349  30.414  34.904  1.00 32.11           C  
ATOM    343  O   GLU A 266      48.799  30.623  33.777  1.00 30.98           O  
ATOM    344  CB  GLU A 266      46.589  28.654  34.715  1.00 34.23           C  
ATOM    345  CG  GLU A 266      46.727  28.403  33.218  1.00 39.59           C  
ATOM    346  CD  GLU A 266      46.720  26.920  32.872  1.00 44.10           C  
ATOM    347  OE1 GLU A 266      45.908  26.168  33.471  1.00 45.32           O  
ATOM    348  OE2 GLU A 266      47.520  26.516  31.991  1.00 43.97           O  
ATOM    349  N   VAL A 267      49.079  30.446  36.007  1.00 33.48           N  
ATOM    350  CA  VAL A 267      50.508  30.715  36.031  1.00 36.30           C  
ATOM    351  C   VAL A 267      51.303  29.581  35.357  1.00 37.76           C  
ATOM    352  O   VAL A 267      50.932  28.413  35.485  1.00 38.75           O  
ATOM    353  CB  VAL A 267      50.930  30.904  37.496  1.00 36.73           C  
ATOM    354  CG1 VAL A 267      52.156  30.070  37.818  1.00 36.39           C  
ATOM    355  CG2 VAL A 267      51.144  32.386  37.767  1.00 37.99           C  
ATOM    356  N   THR A 268      52.384  29.915  34.643  1.00 38.55           N  
ATOM    357  CA  THR A 268      53.174  28.887  33.951  1.00 40.65           C  
ATOM    358  C   THR A 268      54.637  28.787  34.372  1.00 42.78           C  
ATOM    359  O   THR A 268      55.360  27.918  33.885  1.00 43.91           O  
ATOM    360  CB  THR A 268      53.218  29.103  32.430  1.00 41.09           C  
ATOM    361  OG1 THR A 268      54.071  30.217  32.135  1.00 41.89           O  
ATOM    362  CG2 THR A 268      51.825  29.347  31.871  1.00 41.27           C  
ATOM    363  N   HIS A 269      55.073  29.670  35.266  1.00 43.11           N  
ATOM    364  CA  HIS A 269      56.456  29.688  35.707  1.00 42.38           C  
ATOM    365  C   HIS A 269      56.762  28.819  36.923  1.00 43.85           C  
ATOM    366  O   HIS A 269      57.875  28.857  37.445  1.00 43.19           O  
ATOM    367  CB  HIS A 269      56.863  31.127  36.012  1.00 43.97           C  
ATOM    368  CG  HIS A 269      56.143  31.716  37.183  1.00 42.84           C  
ATOM    369  ND1 HIS A 269      54.779  31.917  37.191  1.00 42.27           N  
ATOM    370  CD2 HIS A 269      56.589  32.105  38.400  1.00 42.38           C  
ATOM    371  CE1 HIS A 269      54.417  32.402  38.366  1.00 43.29           C  
ATOM    372  NE2 HIS A 269      55.495  32.525  39.118  1.00 42.96           N  
ATOM    373  N   CYS A 270      55.791  28.037  37.379  1.00 43.93           N  
ATOM    374  CA  CYS A 270      56.011  27.200  38.548  1.00 44.15           C  
ATOM    375  C   CYS A 270      55.867  25.720  38.285  1.00 44.77           C  
ATOM    376  O   CYS A 270      55.526  24.959  39.181  1.00 45.09           O  
ATOM    377  CB  CYS A 270      55.056  27.606  39.654  1.00 44.22           C  
ATOM    378  SG  CYS A 270      55.264  29.312  40.096  1.00 49.20           S  
ATOM    379  N   GLY A 271      56.136  25.314  37.055  1.00 46.55           N  
ATOM    380  CA  GLY A 271      56.022  23.914  36.710  1.00 47.98           C  
ATOM    381  C   GLY A 271      54.584  23.431  36.684  1.00 49.54           C  
ATOM    382  O   GLY A 271      53.755  23.917  35.905  1.00 50.66           O  
ATOM    383  N   GLN A 272      54.287  22.464  37.545  1.00 49.67           N  
ATOM    384  CA  GLN A 272      52.957  21.898  37.616  1.00 49.68           C  
ATOM    385  C   GLN A 272      52.084  22.570  38.665  1.00 47.75           C  
ATOM    386  O   GLN A 272      50.930  22.178  38.882  1.00 46.39           O  
ATOM    387  CB  GLN A 272      53.054  20.396  37.868  1.00 53.12           C  
ATOM    388  CG  GLN A 272      53.380  19.607  36.613  1.00 56.51           C  
ATOM    389  CD  GLN A 272      52.271  19.694  35.569  1.00 58.69           C  
ATOM    390  OE1 GLN A 272      51.159  19.190  35.779  1.00 57.15           O  
ATOM    391  NE2 GLN A 272      52.569  20.343  34.438  1.00 59.73           N  
ATOM    392  N   MET A 273      52.639  23.575  39.325  1.00 44.89           N  
ATOM    393  CA  MET A 273      51.869  24.308  40.309  1.00 45.87           C  
ATOM    394  C   MET A 273      51.220  25.443  39.509  1.00 45.29           C  
ATOM    395  O   MET A 273      51.629  26.605  39.603  1.00 44.54           O  
ATOM    396  CB  MET A 273      52.778  24.876  41.395  1.00 46.64           C  
ATOM    397  CG  MET A 273      52.007  25.489  42.542  1.00 49.54           C  
ATOM    398  SD  MET A 273      53.032  26.556  43.557  1.00 52.31           S  
ATOM    399  CE  MET A 273      53.934  25.292  44.484  1.00 56.47           C  
ATOM    400  N   LYS A 274      50.221  25.089  38.703  1.00 43.03           N  
ATOM    401  CA  LYS A 274      49.532  26.058  37.861  1.00 41.85           C  
ATOM    402  C   LYS A 274      48.435  26.816  38.601  1.00 39.43           C  
ATOM    403  O   LYS A 274      47.250  26.645  38.328  1.00 38.71           O  
ATOM    404  CB  LYS A 274      48.948  25.349  36.644  1.00 42.33           C  
ATOM    405  CG  LYS A 274      49.988  24.680  35.787  1.00 43.62           C  
ATOM    406  CD  LYS A 274      49.341  23.995  34.605  1.00 45.77           C  
ATOM    407  CE  LYS A 274      50.382  23.376  33.699  1.00 47.03           C  
ATOM    408  NZ  LYS A 274      49.752  22.759  32.500  1.00 47.93           N  
ATOM    409  N   ARG A 275      48.848  27.660  39.533  1.00 36.42           N  
ATOM    410  CA  ARG A 275      47.916  28.436  40.321  1.00 35.22           C  
ATOM    411  C   ARG A 275      47.034  29.292  39.415  1.00 36.07           C  
ATOM    412  O   ARG A 275      47.513  29.916  38.466  1.00 34.88           O  
ATOM    413  CB  ARG A 275      48.690  29.317  41.287  1.00 34.45           C  
ATOM    414  CG  ARG A 275      47.841  29.965  42.339  1.00 34.01           C  
ATOM    415  CD  ARG A 275      48.722  30.702  43.299  1.00 32.07           C  
ATOM    416  NE  ARG A 275      47.974  31.250  44.422  1.00 32.64           N  
ATOM    417  CZ  ARG A 275      48.557  31.819  45.469  1.00 33.30           C  
ATOM    418  NH1 ARG A 275      49.878  31.904  45.515  1.00 32.72           N  
ATOM    419  NH2 ARG A 275      47.830  32.299  46.469  1.00 35.23           N  
ATOM    420  N   LYS A 276      45.741  29.312  39.715  1.00 36.59           N  
ATOM    421  CA  LYS A 276      44.781  30.068  38.929  1.00 35.68           C  
ATOM    422  C   LYS A 276      44.430  31.387  39.578  1.00 35.91           C  
ATOM    423  O   LYS A 276      44.292  31.476  40.796  1.00 36.51           O  
ATOM    424  CB  LYS A 276      43.497  29.269  38.752  1.00 36.96           C  
ATOM    425  CG  LYS A 276      43.650  27.979  37.978  1.00 38.97           C  
ATOM    426  CD  LYS A 276      42.285  27.397  37.666  1.00 40.10           C  
ATOM    427  CE  LYS A 276      42.409  26.175  36.789  1.00 45.29           C  
ATOM    428  NZ  LYS A 276      41.096  25.840  36.148  1.00 52.08           N  
ATOM    429  N   TYR A 277      44.282  32.412  38.749  1.00 35.05           N  
ATOM    430  CA  TYR A 277      43.915  33.732  39.233  1.00 34.79           C  
ATOM    431  C   TYR A 277      42.820  34.354  38.369  1.00 34.67           C  
ATOM    432  O   TYR A 277      42.612  33.978  37.203  1.00 35.57           O  
ATOM    433  CB  TYR A 277      45.112  34.677  39.221  1.00 34.62           C  
ATOM    434  CG  TYR A 277      46.277  34.275  40.078  1.00 35.57           C  
ATOM    435  CD1 TYR A 277      47.247  33.399  39.602  1.00 35.06           C  
ATOM    436  CD2 TYR A 277      46.452  34.831  41.350  1.00 38.06           C  
ATOM    437  CE1 TYR A 277      48.369  33.095  40.361  1.00 35.93           C  
ATOM    438  CE2 TYR A 277      47.572  34.533  42.125  1.00 35.69           C  
ATOM    439  CZ  TYR A 277      48.527  33.670  41.622  1.00 37.89           C  
ATOM    440  OH  TYR A 277      49.656  33.400  42.363  1.00 41.44           O  
ATOM    441  N   ARG A 278      42.123  35.313  38.955  1.00 33.77           N  
ATOM    442  CA  ARG A 278      41.079  36.028  38.251  1.00 33.18           C  
ATOM    443  C   ARG A 278      41.707  37.366  37.923  1.00 32.50           C  
ATOM    444  O   ARG A 278      42.171  38.077  38.810  1.00 33.59           O  
ATOM    445  CB  ARG A 278      39.868  36.245  39.151  1.00 33.55           C  
ATOM    446  CG  ARG A 278      38.829  37.174  38.553  1.00 34.79           C  
ATOM    447  CD  ARG A 278      38.118  36.508  37.382  1.00 35.47           C  
ATOM    448  NE  ARG A 278      37.388  35.317  37.809  1.00 33.67           N  
ATOM    449  CZ  ARG A 278      36.875  34.416  36.975  1.00 35.74           C  
ATOM    450  NH1 ARG A 278      37.009  34.566  35.663  1.00 31.40           N  
ATOM    451  NH2 ARG A 278      36.233  33.356  37.457  1.00 35.90           N  
ATOM    452  N   VAL A 279      41.759  37.705  36.651  1.00 32.16           N  
ATOM    453  CA  VAL A 279      42.338  38.971  36.280  1.00 34.20           C  
ATOM    454  C   VAL A 279      41.359  40.071  36.658  1.00 35.66           C  
ATOM    455  O   VAL A 279      40.212  40.047  36.227  1.00 36.67           O  
ATOM    456  CB  VAL A 279      42.595  39.032  34.776  1.00 33.98           C  
ATOM    457  CG1 VAL A 279      43.155  40.399  34.403  1.00 34.45           C  
ATOM    458  CG2 VAL A 279      43.550  37.930  34.378  1.00 32.60           C  
ATOM    459  N   CYS A 280      41.787  41.026  37.475  1.00 36.74           N  
ATOM    460  CA  CYS A 280      40.879  42.106  37.842  1.00 37.85           C  
ATOM    461  C   CYS A 280      41.263  43.442  37.202  1.00 37.71           C  
ATOM    462  O   CYS A 280      40.471  44.388  37.216  1.00 38.62           O  
ATOM    463  CB  CYS A 280      40.784  42.252  39.366  1.00 38.40           C  
ATOM    464  SG  CYS A 280      42.253  42.863  40.189  1.00 44.08           S  
ATOM    465  N   ASN A 281      42.462  43.522  36.627  1.00 36.33           N  
ATOM    466  CA  ASN A 281      42.889  44.760  35.979  1.00 36.11           C  
ATOM    467  C   ASN A 281      44.231  44.620  35.255  1.00 35.50           C  
ATOM    468  O   ASN A 281      44.877  43.582  35.350  1.00 35.55           O  
ATOM    469  CB  ASN A 281      42.969  45.871  37.028  1.00 35.81           C  
ATOM    470  CG  ASN A 281      42.651  47.245  36.460  1.00 35.93           C  
ATOM    471  OD1 ASN A 281      42.484  48.202  37.207  1.00 37.24           O  
ATOM    472  ND2 ASN A 281      42.564  47.348  35.142  1.00 34.01           N  
ATOM    473  N   VAL A 282      44.625  45.654  34.512  1.00 35.54           N  
ATOM    474  CA  VAL A 282      45.909  45.676  33.802  1.00 36.69           C  
ATOM    475  C   VAL A 282      46.661  46.912  34.285  1.00 38.42           C  
ATOM    476  O   VAL A 282      46.092  48.007  34.334  1.00 40.36           O  
ATOM    477  CB  VAL A 282      45.746  45.783  32.267  1.00 36.25           C  
ATOM    478  CG1 VAL A 282      47.119  45.931  31.606  1.00 37.24           C  
ATOM    479  CG2 VAL A 282      45.063  44.550  31.722  1.00 36.16           C  
ATOM    480  N   THR A 283      47.930  46.749  34.646  1.00 38.96           N  
ATOM    481  CA  THR A 283      48.714  47.881  35.138  1.00 38.61           C  
ATOM    482  C   THR A 283      49.013  48.889  34.046  1.00 38.20           C  
ATOM    483  O   THR A 283      48.970  48.570  32.860  1.00 39.07           O  
ATOM    484  CB  THR A 283      50.071  47.432  35.740  1.00 40.15           C  
ATOM    485  OG1 THR A 283      50.870  46.801  34.727  1.00 41.61           O  
ATOM    486  CG2 THR A 283      49.851  46.467  36.888  1.00 38.95           C  
ATOM    487  N   ARG A 284      49.311  50.116  34.449  1.00 38.54           N  
ATOM    488  CA  ARG A 284      49.652  51.151  33.483  1.00 40.32           C  
ATOM    489  C   ARG A 284      51.153  51.106  33.238  1.00 41.22           C  
ATOM    490  O   ARG A 284      51.618  51.386  32.137  1.00 42.58           O  
ATOM    491  CB  ARG A 284      49.260  52.543  33.993  1.00 39.04           C  
ATOM    492  CG  ARG A 284      47.775  52.810  33.954  1.00 39.29           C  
ATOM    493  CD  ARG A 284      47.454  54.263  34.240  1.00 40.14           C  
ATOM    494  NE  ARG A 284      46.015  54.502  34.180  1.00 39.38           N  
ATOM    495  CZ  ARG A 284      45.443  55.683  34.369  1.00 37.72           C  
ATOM    496  NH1 ARG A 284      46.185  56.749  34.629  1.00 39.25           N  
ATOM    497  NH2 ARG A 284      44.127  55.795  34.302  1.00 39.36           N  
ATOM    498  N   ARG A 285      51.905  50.742  34.271  1.00 41.76           N  
ATOM    499  CA  ARG A 285      53.355  50.668  34.177  1.00 42.14           C  
ATOM    500  C   ARG A 285      53.821  49.307  33.663  1.00 40.66           C  
ATOM    501  O   ARG A 285      53.198  48.282  33.938  1.00 39.32           O  
ATOM    502  CB  ARG A 285      53.958  50.958  35.547  1.00 43.17           C  
ATOM    503  CG  ARG A 285      53.280  52.131  36.234  1.00 46.88           C  
ATOM    504  CD  ARG A 285      54.084  52.634  37.418  1.00 50.54           C  
ATOM    505  NE  ARG A 285      55.441  52.986  37.002  1.00 54.36           N  
ATOM    506  CZ  ARG A 285      56.319  53.630  37.762  1.00 53.31           C  
ATOM    507  NH1 ARG A 285      55.981  54.003  38.993  1.00 51.65           N  
ATOM    508  NH2 ARG A 285      57.535  53.891  37.289  1.00 51.80           N  
ATOM    509  N   PRO A 286      54.928  49.282  32.900  1.00 41.12           N  
ATOM    510  CA  PRO A 286      55.430  48.012  32.373  1.00 40.25           C  
ATOM    511  C   PRO A 286      56.013  47.190  33.508  1.00 40.81           C  
ATOM    512  O   PRO A 286      56.288  47.724  34.587  1.00 40.14           O  
ATOM    513  CB  PRO A 286      56.500  48.441  31.374  1.00 38.91           C  
ATOM    514  CG  PRO A 286      56.212  49.891  31.109  1.00 40.34           C  
ATOM    515  CD  PRO A 286      55.771  50.393  32.443  1.00 40.30           C  
ATOM    516  N   ALA A 287      56.188  45.895  33.271  1.00 41.69           N  
ATOM    517  CA  ALA A 287      56.747  45.013  34.281  1.00 43.01           C  
ATOM    518  C   ALA A 287      58.119  45.553  34.691  1.00 45.34           C  
ATOM    519  O   ALA A 287      58.560  45.390  35.828  1.00 43.55           O  
ATOM    520  CB  ALA A 287      56.870  43.618  33.723  1.00 42.85           C  
ATOM    521  N   SER A 288      58.788  46.211  33.751  1.00 48.31           N  
ATOM    522  CA  SER A 288      60.089  46.787  34.022  1.00 50.21           C  
ATOM    523  C   SER A 288      59.991  47.861  35.101  1.00 52.31           C  
ATOM    524  O   SER A 288      60.928  48.050  35.866  1.00 54.12           O  
ATOM    525  CB  SER A 288      60.680  47.391  32.746  1.00 50.74           C  
ATOM    526  OG  SER A 288      59.925  48.500  32.291  1.00 50.67           O  
ATOM    527  N   HIS A 289      58.855  48.552  35.184  1.00 54.34           N  
ATOM    528  CA  HIS A 289      58.694  49.610  36.180  1.00 55.00           C  
ATOM    529  C   HIS A 289      57.648  49.389  37.264  1.00 55.76           C  
ATOM    530  O   HIS A 289      57.683  50.062  38.292  1.00 55.66           O  
ATOM    531  CB  HIS A 289      58.412  50.939  35.487  1.00 56.46           C  
ATOM    532  CG  HIS A 289      59.552  51.429  34.655  1.00 58.35           C  
ATOM    533  ND1 HIS A 289      59.992  50.761  33.533  1.00 58.13           N  
ATOM    534  CD2 HIS A 289      60.372  52.496  34.806  1.00 59.19           C  
ATOM    535  CE1 HIS A 289      61.037  51.394  33.030  1.00 59.37           C  
ATOM    536  NE2 HIS A 289      61.288  52.449  33.784  1.00 59.52           N  
ATOM    537  N   GLN A 290      56.714  48.470  37.047  1.00 56.52           N  
ATOM    538  CA  GLN A 290      55.696  48.218  38.066  1.00 57.42           C  
ATOM    539  C   GLN A 290      56.368  47.789  39.363  1.00 58.18           C  
ATOM    540  O   GLN A 290      57.113  46.807  39.407  1.00 58.08           O  
ATOM    541  CB  GLN A 290      54.709  47.135  37.624  1.00 56.34           C  
ATOM    542  CG  GLN A 290      53.603  46.910  38.646  1.00 54.79           C  
ATOM    543  CD  GLN A 290      52.783  48.168  38.913  1.00 54.99           C  
ATOM    544  OE1 GLN A 290      52.346  48.407  40.037  1.00 56.16           O  
ATOM    545  NE2 GLN A 290      52.563  48.970  37.876  1.00 53.73           N  
ATOM    546  N   THR A 291      56.089  48.529  40.422  1.00 59.07           N  
ATOM    547  CA  THR A 291      56.683  48.253  41.715  1.00 59.96           C  
ATOM    548  C   THR A 291      55.675  47.701  42.711  1.00 60.42           C  
ATOM    549  O   THR A 291      54.467  47.878  42.545  1.00 59.54           O  
ATOM    550  CB  THR A 291      57.304  49.538  42.282  1.00 59.90           C  
ATOM    551  OG1 THR A 291      57.559  49.366  43.679  1.00 62.63           O  
ATOM    552  CG2 THR A 291      56.368  50.721  42.067  1.00 58.73           C  
ATOM    553  N   PHE A 292      56.179  47.021  43.740  1.00 61.07           N  
ATOM    554  CA  PHE A 292      55.318  46.460  44.780  1.00 62.42           C  
ATOM    555  C   PHE A 292      56.073  46.218  46.099  1.00 63.69           C  
ATOM    556  O   PHE A 292      57.298  46.051  46.114  1.00 61.95           O  
ATOM    557  CB  PHE A 292      54.678  45.150  44.302  1.00 60.90           C  
ATOM    558  CG  PHE A 292      55.637  44.000  44.228  1.00 60.60           C  
ATOM    559  CD1 PHE A 292      56.556  43.906  43.193  1.00 59.65           C  
ATOM    560  CD2 PHE A 292      55.655  43.031  45.228  1.00 60.22           C  
ATOM    561  CE1 PHE A 292      57.485  42.861  43.154  1.00 59.51           C  
ATOM    562  CE2 PHE A 292      56.576  41.986  45.199  1.00 59.15           C  
ATOM    563  CZ  PHE A 292      57.493  41.902  44.159  1.00 58.95           C  
ATOM    564  N   PRO A 293      55.339  46.208  47.228  1.00 65.04           N  
ATOM    565  CA  PRO A 293      55.851  45.995  48.588  1.00 65.93           C  
ATOM    566  C   PRO A 293      56.432  44.599  48.815  1.00 67.26           C  
ATOM    567  O   PRO A 293      55.708  43.673  49.184  1.00 67.39           O  
ATOM    568  CB  PRO A 293      54.620  46.236  49.461  1.00 66.06           C  
ATOM    569  CG  PRO A 293      53.812  47.197  48.659  1.00 65.30           C  
ATOM    570  CD  PRO A 293      53.924  46.617  47.275  1.00 65.37           C  
ATOM    571  N   LEU A 294      57.737  44.455  48.604  1.00 68.77           N  
ATOM    572  CA  LEU A 294      58.408  43.169  48.790  1.00 70.32           C  
ATOM    573  C   LEU A 294      59.056  43.062  50.175  1.00 71.64           C  
ATOM    574  O   LEU A 294      59.782  43.969  50.604  1.00 72.65           O  
ATOM    575  CB  LEU A 294      59.465  42.975  47.698  1.00 69.67           C  
ATOM    576  CG  LEU A 294      60.319  41.705  47.760  1.00 70.34           C  
ATOM    577  CD1 LEU A 294      59.442  40.480  47.967  1.00 69.97           C  
ATOM    578  CD2 LEU A 294      61.124  41.583  46.472  1.00 70.46           C  
ATOM    579  N   GLN A 295      58.794  41.953  50.868  1.00 71.39           N  
ATOM    580  CA  GLN A 295      59.337  41.729  52.207  1.00 71.95           C  
ATOM    581  C   GLN A 295      60.663  40.975  52.187  1.00 72.75           C  
ATOM    582  O   GLN A 295      61.447  41.055  53.138  1.00 73.44           O  
ATOM    583  CB  GLN A 295      58.332  40.956  53.063  1.00 72.02           C  
ATOM    584  N   VAL A 302      60.523  46.810  51.809  1.00 86.32           N  
ATOM    585  CA  VAL A 302      61.218  47.493  50.718  1.00 87.86           C  
ATOM    586  C   VAL A 302      60.617  47.138  49.359  1.00 87.90           C  
ATOM    587  O   VAL A 302      60.415  45.962  49.044  1.00 88.06           O  
ATOM    588  CB  VAL A 302      62.719  47.132  50.691  1.00 88.39           C  
ATOM    589  CG1 VAL A 302      63.354  47.460  52.031  1.00 89.10           C  
ATOM    590  CG2 VAL A 302      62.902  45.658  50.352  1.00 88.71           C  
ATOM    591  N   GLU A 303      60.349  48.158  48.548  1.00 87.12           N  
ATOM    592  CA  GLU A 303      59.757  47.946  47.235  1.00 86.26           C  
ATOM    593  C   GLU A 303      60.685  47.388  46.167  1.00 84.30           C  
ATOM    594  O   GLU A 303      61.882  47.676  46.140  1.00 83.27           O  
ATOM    595  CB  GLU A 303      59.103  49.236  46.744  1.00 88.24           C  
ATOM    596  CG  GLU A 303      57.690  49.398  47.281  1.00 92.25           C  
ATOM    597  CD  GLU A 303      57.043  50.700  46.864  1.00 94.85           C  
ATOM    598  OE1 GLU A 303      57.195  51.089  45.683  1.00 96.33           O  
ATOM    599  OE2 GLU A 303      56.370  51.324  47.717  1.00 96.22           O  
ATOM    600  N   CYS A 304      60.098  46.585  45.283  1.00 82.49           N  
ATOM    601  CA  CYS A 304      60.822  45.932  44.200  1.00 79.77           C  
ATOM    602  C   CYS A 304      60.052  45.979  42.881  1.00 77.15           C  
ATOM    603  O   CYS A 304      58.865  46.302  42.842  1.00 77.56           O  
ATOM    604  CB  CYS A 304      61.090  44.470  44.581  1.00 80.74           C  
ATOM    605  SG  CYS A 304      61.929  43.457  43.331  1.00 81.98           S  
ATOM    606  N   THR A 305      60.749  45.649  41.804  1.00 73.66           N  
ATOM    607  CA  THR A 305      60.169  45.622  40.475  1.00 71.33           C  
ATOM    608  C   THR A 305      59.780  44.187  40.117  1.00 70.96           C  
ATOM    609  O   THR A 305      60.562  43.259  40.318  1.00 70.60           O  
ATOM    610  CB  THR A 305      61.178  46.172  39.453  1.00 70.29           C  
ATOM    611  OG1 THR A 305      60.888  47.548  39.207  1.00 68.48           O  
ATOM    612  CG2 THR A 305      61.132  45.398  38.152  1.00 70.42           C  
ATOM    613  N   VAL A 306      58.576  44.008  39.581  1.00 70.18           N  
ATOM    614  CA  VAL A 306      58.116  42.671  39.218  1.00 69.82           C  
ATOM    615  C   VAL A 306      59.076  41.967  38.266  1.00 69.49           C  
ATOM    616  O   VAL A 306      59.234  40.751  38.338  1.00 70.30           O  
ATOM    617  CB  VAL A 306      56.702  42.696  38.573  1.00 69.63           C  
ATOM    618  CG1 VAL A 306      55.734  43.456  39.466  1.00 69.44           C  
ATOM    619  CG2 VAL A 306      56.760  43.312  37.199  1.00 69.44           C  
ATOM    620  N   ALA A 307      59.715  42.723  37.377  1.00 68.88           N  
ATOM    621  CA  ALA A 307      60.658  42.136  36.432  1.00 69.36           C  
ATOM    622  C   ALA A 307      61.839  41.563  37.206  1.00 70.40           C  
ATOM    623  O   ALA A 307      62.334  40.472  36.896  1.00 70.01           O  
ATOM    624  CB  ALA A 307      61.138  43.185  35.448  1.00 68.77           C  
ATOM    625  N   GLN A 308      62.281  42.315  38.211  1.00 71.06           N  
ATOM    626  CA  GLN A 308      63.388  41.909  39.066  1.00 71.74           C  
ATOM    627  C   GLN A 308      63.018  40.593  39.702  1.00 70.87           C  
ATOM    628  O   GLN A 308      63.777  39.625  39.656  1.00 71.21           O  
ATOM    629  CB  GLN A 308      63.611  42.932  40.180  1.00 74.18           C  
ATOM    630  CG  GLN A 308      64.802  43.858  39.987  1.00 77.44           C  
ATOM    631  CD  GLN A 308      64.877  44.936  41.067  1.00 78.87           C  
ATOM    632  OE1 GLN A 308      64.966  44.635  42.264  1.00 78.84           O  
ATOM    633  NE2 GLN A 308      64.838  46.201  40.644  1.00 77.76           N  
ATOM    634  N   TYR A 309      61.831  40.582  40.299  1.00 69.00           N  
ATOM    635  CA  TYR A 309      61.307  39.416  40.984  1.00 67.07           C  
ATOM    636  C   TYR A 309      61.473  38.132  40.180  1.00 66.36           C  
ATOM    637  O   TYR A 309      62.072  37.173  40.657  1.00 65.97           O  
ATOM    638  CB  TYR A 309      59.832  39.629  41.305  1.00 66.72           C  
ATOM    639  CG  TYR A 309      59.256  38.589  42.230  1.00 65.80           C  
ATOM    640  CD1 TYR A 309      59.339  38.731  43.615  1.00 65.17           C  
ATOM    641  CD2 TYR A 309      58.648  37.445  41.721  1.00 66.36           C  
ATOM    642  CE1 TYR A 309      58.828  37.756  44.472  1.00 64.54           C  
ATOM    643  CE2 TYR A 309      58.138  36.465  42.566  1.00 66.13           C  
ATOM    644  CZ  TYR A 309      58.231  36.628  43.937  1.00 65.09           C  
ATOM    645  OH  TYR A 309      57.723  35.655  44.759  1.00 65.43           O  
ATOM    646  N   PHE A 310      60.953  38.105  38.958  1.00 65.42           N  
ATOM    647  CA  PHE A 310      61.057  36.899  38.143  1.00 65.25           C  
ATOM    648  C   PHE A 310      62.474  36.598  37.666  1.00 67.69           C  
ATOM    649  O   PHE A 310      62.743  35.524  37.132  1.00 67.44           O  
ATOM    650  CB  PHE A 310      60.084  36.972  36.960  1.00 60.02           C  
ATOM    651  CG  PHE A 310      58.654  36.727  37.354  1.00 55.79           C  
ATOM    652  CD1 PHE A 310      57.966  37.646  38.142  1.00 53.17           C  
ATOM    653  CD2 PHE A 310      58.016  35.540  37.004  1.00 54.49           C  
ATOM    654  CE1 PHE A 310      56.671  37.382  38.583  1.00 51.58           C  
ATOM    655  CE2 PHE A 310      56.716  35.266  37.443  1.00 52.64           C  
ATOM    656  CZ  PHE A 310      56.046  36.191  38.235  1.00 50.39           C  
ATOM    657  N   LYS A 311      63.381  37.545  37.877  1.00 70.70           N  
ATOM    658  CA  LYS A 311      64.775  37.369  37.485  1.00 73.08           C  
ATOM    659  C   LYS A 311      65.559  36.906  38.714  1.00 74.37           C  
ATOM    660  O   LYS A 311      66.493  36.106  38.614  1.00 74.38           O  
ATOM    661  CB  LYS A 311      65.348  38.692  36.969  1.00 74.31           C  
ATOM    662  CG  LYS A 311      66.659  38.576  36.195  1.00 75.51           C  
ATOM    663  CD  LYS A 311      67.856  38.235  37.073  1.00 77.07           C  
ATOM    664  CE  LYS A 311      69.135  38.147  36.237  1.00 77.54           C  
ATOM    665  NZ  LYS A 311      70.338  37.782  37.044  1.00 76.64           N  
ATOM    666  N   GLN A 312      65.167  37.412  39.878  1.00 74.40           N  
ATOM    667  CA  GLN A 312      65.839  37.057  41.114  1.00 74.68           C  
ATOM    668  C   GLN A 312      65.314  35.736  41.655  1.00 74.01           C  
ATOM    669  O   GLN A 312      66.062  34.768  41.773  1.00 75.35           O  
ATOM    670  CB  GLN A 312      65.650  38.170  42.154  1.00 76.43           C  
ATOM    671  CG  GLN A 312      65.919  39.574  41.597  1.00 79.02           C  
ATOM    672  CD  GLN A 312      65.976  40.652  42.669  1.00 80.22           C  
ATOM    673  OE1 GLN A 312      65.096  40.744  43.529  1.00 80.73           O  
ATOM    674  NE2 GLN A 312      67.014  41.484  42.613  1.00 80.56           N  
ATOM    675  N   LYS A 313      64.021  35.692  41.958  1.00 73.23           N  
ATOM    676  CA  LYS A 313      63.389  34.497  42.514  1.00 71.19           C  
ATOM    677  C   LYS A 313      63.209  33.312  41.572  1.00 69.45           C  
ATOM    678  O   LYS A 313      63.292  32.166  42.007  1.00 70.28           O  
ATOM    679  CB  LYS A 313      62.030  34.857  43.122  1.00 70.77           C  
ATOM    680  CG  LYS A 313      61.338  33.691  43.805  1.00 71.13           C  
ATOM    681  CD  LYS A 313      60.283  34.187  44.776  1.00 72.53           C  
ATOM    682  CE  LYS A 313      59.670  33.047  45.570  1.00 73.27           C  
ATOM    683  NZ  LYS A 313      58.809  33.550  46.684  1.00 72.90           N  
ATOM    684  N   TYR A 314      62.959  33.572  40.295  1.00 67.69           N  
ATOM    685  CA  TYR A 314      62.761  32.486  39.338  1.00 66.49           C  
ATOM    686  C   TYR A 314      63.851  32.449  38.291  1.00 66.43           C  
ATOM    687  O   TYR A 314      63.896  31.552  37.449  1.00 65.90           O  
ATOM    688  CB  TYR A 314      61.392  32.615  38.669  1.00 64.57           C  
ATOM    689  CG  TYR A 314      60.280  32.376  39.645  1.00 63.11           C  
ATOM    690  CD1 TYR A 314      60.066  31.108  40.173  1.00 62.04           C  
ATOM    691  CD2 TYR A 314      59.495  33.426  40.116  1.00 62.39           C  
ATOM    692  CE1 TYR A 314      59.109  30.889  41.145  1.00 61.77           C  
ATOM    693  CE2 TYR A 314      58.534  33.217  41.093  1.00 61.68           C  
ATOM    694  CZ  TYR A 314      58.350  31.945  41.604  1.00 61.57           C  
ATOM    695  OH  TYR A 314      57.415  31.722  42.585  1.00 62.43           O  
ATOM    696  N   ASN A 315      64.733  33.433  38.350  1.00 66.61           N  
ATOM    697  CA  ASN A 315      65.826  33.506  37.410  1.00 66.87           C  
ATOM    698  C   ASN A 315      65.309  33.385  35.979  1.00 66.28           C  
ATOM    699  O   ASN A 315      65.641  32.438  35.265  1.00 66.39           O  
ATOM    700  CB  ASN A 315      66.837  32.395  37.707  1.00 68.07           C  
ATOM    701  CG  ASN A 315      68.186  32.651  37.066  1.00 70.16           C  
ATOM    702  OD1 ASN A 315      68.320  32.651  35.840  1.00 70.49           O  
ATOM    703  ND2 ASN A 315      69.199  32.878  37.897  1.00 71.57           N  
ATOM    704  N   LEU A 316      64.475  34.336  35.572  1.00 65.88           N  
ATOM    705  CA  LEU A 316      63.949  34.346  34.213  1.00 65.34           C  
ATOM    706  C   LEU A 316      63.775  35.780  33.722  1.00 64.53           C  
ATOM    707  O   LEU A 316      62.877  36.504  34.152  1.00 64.79           O  
ATOM    708  CB  LEU A 316      62.624  33.557  34.119  1.00 65.65           C  
ATOM    709  CG  LEU A 316      61.238  34.074  34.533  1.00 65.63           C  
ATOM    710  CD1 LEU A 316      60.607  34.872  33.400  1.00 64.00           C  
ATOM    711  CD2 LEU A 316      60.340  32.885  34.860  1.00 64.59           C  
ATOM    712  N   GLN A 317      64.676  36.198  32.845  1.00 64.06           N  
ATOM    713  CA  GLN A 317      64.607  37.535  32.286  1.00 63.68           C  
ATOM    714  C   GLN A 317      63.320  37.543  31.485  1.00 61.16           C  
ATOM    715  O   GLN A 317      63.076  36.642  30.683  1.00 60.29           O  
ATOM    716  CB  GLN A 317      65.797  37.800  31.356  1.00 66.69           C  
ATOM    717  CG  GLN A 317      67.155  37.884  32.047  1.00 70.80           C  
ATOM    718  CD  GLN A 317      67.397  39.227  32.722  1.00 73.13           C  
ATOM    719  OE1 GLN A 317      66.655  39.626  33.620  1.00 74.95           O  
ATOM    720  NE2 GLN A 317      68.441  39.931  32.289  1.00 74.12           N  
ATOM    721  N   LEU A 318      62.490  38.547  31.712  1.00 58.29           N  
ATOM    722  CA  LEU A 318      61.234  38.636  30.990  1.00 56.91           C  
ATOM    723  C   LEU A 318      61.462  39.001  29.527  1.00 55.70           C  
ATOM    724  O   LEU A 318      62.290  39.855  29.215  1.00 57.11           O  
ATOM    725  CB  LEU A 318      60.332  39.677  31.658  1.00 56.01           C  
ATOM    726  CG  LEU A 318      59.913  39.303  33.077  1.00 55.58           C  
ATOM    727  CD1 LEU A 318      59.300  40.489  33.788  1.00 56.30           C  
ATOM    728  CD2 LEU A 318      58.942  38.149  33.005  1.00 55.74           C  
ATOM    729  N   LYS A 319      60.743  38.341  28.627  1.00 53.92           N  
ATOM    730  CA  LYS A 319      60.860  38.646  27.206  1.00 53.10           C  
ATOM    731  C   LYS A 319      60.232  40.006  26.884  1.00 52.09           C  
ATOM    732  O   LYS A 319      60.695  40.702  25.985  1.00 53.07           O  
ATOM    733  CB  LYS A 319      60.171  37.571  26.359  1.00 54.56           C  
ATOM    734  CG  LYS A 319      61.022  36.358  26.045  1.00 55.20           C  
ATOM    735  CD  LYS A 319      60.261  35.346  25.190  1.00 56.72           C  
ATOM    736  CE  LYS A 319      59.215  34.589  26.003  1.00 56.97           C  
ATOM    737  NZ  LYS A 319      58.517  33.566  25.180  1.00 56.94           N  
ATOM    738  N   TYR A 320      59.181  40.376  27.619  1.00 50.52           N  
ATOM    739  CA  TYR A 320      58.479  41.641  27.390  1.00 48.56           C  
ATOM    740  C   TYR A 320      58.322  42.503  28.646  1.00 47.66           C  
ATOM    741  O   TYR A 320      57.208  42.712  29.137  1.00 45.64           O  
ATOM    742  CB  TYR A 320      57.087  41.374  26.802  1.00 48.77           C  
ATOM    743  CG  TYR A 320      57.076  40.394  25.654  1.00 48.66           C  
ATOM    744  CD1 TYR A 320      57.002  39.019  25.886  1.00 49.05           C  
ATOM    745  CD2 TYR A 320      57.168  40.837  24.335  1.00 48.58           C  
ATOM    746  CE1 TYR A 320      57.023  38.109  24.827  1.00 48.43           C  
ATOM    747  CE2 TYR A 320      57.193  39.938  23.269  1.00 46.70           C  
ATOM    748  CZ  TYR A 320      57.122  38.581  23.524  1.00 48.15           C  
ATOM    749  OH  TYR A 320      57.174  37.693  22.481  1.00 49.00           O  
ATOM    750  N   PRO A 321      59.441  43.028  29.176  1.00 47.35           N  
ATOM    751  CA  PRO A 321      59.415  43.872  30.377  1.00 46.22           C  
ATOM    752  C   PRO A 321      58.721  45.198  30.095  1.00 45.46           C  
ATOM    753  O   PRO A 321      58.384  45.944  31.013  1.00 45.04           O  
ATOM    754  CB  PRO A 321      60.897  44.070  30.695  1.00 45.89           C  
ATOM    755  CG  PRO A 321      61.565  42.896  30.043  1.00 45.92           C  
ATOM    756  CD  PRO A 321      60.826  42.783  28.746  1.00 46.28           C  
ATOM    757  N   HIS A 322      58.519  45.478  28.811  1.00 44.85           N  
ATOM    758  CA  HIS A 322      57.875  46.709  28.358  1.00 45.05           C  
ATOM    759  C   HIS A 322      56.344  46.661  28.343  1.00 42.56           C  
ATOM    760  O   HIS A 322      55.698  47.701  28.328  1.00 42.53           O  
ATOM    761  CB  HIS A 322      58.385  47.068  26.965  1.00 46.55           C  
ATOM    762  CG  HIS A 322      58.381  45.917  26.009  1.00 49.13           C  
ATOM    763  ND1 HIS A 322      57.601  45.896  24.873  1.00 49.34           N  
ATOM    764  CD2 HIS A 322      59.062  44.747  26.021  1.00 49.08           C  
ATOM    765  CE1 HIS A 322      57.804  44.763  24.224  1.00 49.65           C  
ATOM    766  NE2 HIS A 322      58.686  44.048  24.901  1.00 50.54           N  
ATOM    767  N   LEU A 323      55.771  45.461  28.330  1.00 40.09           N  
ATOM    768  CA  LEU A 323      54.320  45.307  28.346  1.00 36.10           C  
ATOM    769  C   LEU A 323      53.863  45.334  29.804  1.00 35.40           C  
ATOM    770  O   LEU A 323      54.647  45.085  30.708  1.00 34.99           O  
ATOM    771  CB  LEU A 323      53.915  43.986  27.686  1.00 32.54           C  
ATOM    772  CG  LEU A 323      54.368  43.848  26.232  1.00 30.89           C  
ATOM    773  CD1 LEU A 323      54.007  42.475  25.712  1.00 32.09           C  
ATOM    774  CD2 LEU A 323      53.735  44.929  25.382  1.00 29.21           C  
ATOM    775  N   PRO A 324      52.586  45.650  30.050  1.00 35.02           N  
ATOM    776  CA  PRO A 324      52.073  45.705  31.420  1.00 35.13           C  
ATOM    777  C   PRO A 324      51.983  44.348  32.116  1.00 35.58           C  
ATOM    778  O   PRO A 324      52.249  43.299  31.527  1.00 35.84           O  
ATOM    779  CB  PRO A 324      50.683  46.318  31.244  1.00 33.30           C  
ATOM    780  CG  PRO A 324      50.779  47.054  29.973  1.00 33.19           C  
ATOM    781  CD  PRO A 324      51.575  46.140  29.105  1.00 33.70           C  
ATOM    782  N   CYS A 325      51.578  44.399  33.379  1.00 35.92           N  
ATOM    783  CA  CYS A 325      51.378  43.219  34.198  1.00 36.16           C  
ATOM    784  C   CYS A 325      49.881  43.153  34.437  1.00 36.56           C  
ATOM    785  O   CYS A 325      49.165  44.168  34.322  1.00 33.62           O  
ATOM    786  CB  CYS A 325      52.054  43.360  35.562  1.00 37.72           C  
ATOM    787  SG  CYS A 325      53.797  43.735  35.492  1.00 43.60           S  
ATOM    788  N   LEU A 326      49.415  41.956  34.772  1.00 35.56           N  
ATOM    789  CA  LEU A 326      48.014  41.751  35.071  1.00 33.96           C  
ATOM    790  C   LEU A 326      47.883  41.872  36.575  1.00 33.88           C  
ATOM    791  O   LEU A 326      48.815  41.543  37.310  1.00 33.02           O  
ATOM    792  CB  LEU A 326      47.567  40.346  34.670  1.00 33.23           C  
ATOM    793  CG  LEU A 326      47.563  39.913  33.206  1.00 32.54           C  
ATOM    794  CD1 LEU A 326      47.014  38.497  33.112  1.00 31.97           C  
ATOM    795  CD2 LEU A 326      46.716  40.861  32.392  1.00 31.70           C  
ATOM    796  N   GLN A 327      46.753  42.382  37.040  1.00 33.00           N  
ATOM    797  CA  GLN A 327      46.547  42.425  38.469  1.00 34.71           C  
ATOM    798  C   GLN A 327      45.585  41.265  38.707  1.00 34.75           C  
ATOM    799  O   GLN A 327      44.570  41.130  38.013  1.00 34.79           O  
ATOM    800  CB  GLN A 327      45.923  43.740  38.941  1.00 35.47           C  
ATOM    801  CG  GLN A 327      45.735  43.754  40.465  1.00 36.86           C  
ATOM    802  CD  GLN A 327      45.183  45.060  41.015  1.00 38.87           C  
ATOM    803  OE1 GLN A 327      44.839  45.142  42.193  1.00 41.73           O  
ATOM    804  NE2 GLN A 327      45.107  46.088  40.176  1.00 38.07           N  
ATOM    805  N   VAL A 328      45.912  40.409  39.665  1.00 33.61           N  
ATOM    806  CA  VAL A 328      45.059  39.271  39.940  1.00 33.65           C  
ATOM    807  C   VAL A 328      44.661  39.227  41.395  1.00 35.70           C  
ATOM    808  O   VAL A 328      45.313  39.839  42.233  1.00 36.69           O  
ATOM    809  CB  VAL A 328      45.763  37.957  39.560  1.00 32.39           C  
ATOM    810  CG1 VAL A 328      45.929  37.883  38.031  1.00 28.65           C  
ATOM    811  CG2 VAL A 328      47.117  37.869  40.262  1.00 26.77           C  
ATOM    812  N   GLY A 329      43.583  38.511  41.689  1.00 37.22           N  
ATOM    813  CA  GLY A 329      43.123  38.400  43.059  1.00 42.71           C  
ATOM    814  C   GLY A 329      42.418  39.644  43.572  1.00 46.77           C  
ATOM    815  O   GLY A 329      41.983  40.490  42.796  1.00 47.74           O  
ATOM    816  N   GLN A 330      42.303  39.747  44.890  1.00 50.28           N  
ATOM    817  CA  GLN A 330      41.653  40.880  45.531  1.00 54.78           C  
ATOM    818  C   GLN A 330      42.370  42.174  45.169  1.00 56.60           C  
ATOM    819  O   GLN A 330      43.597  42.209  45.137  1.00 56.33           O  
ATOM    820  CB  GLN A 330      41.689  40.678  47.040  1.00 57.29           C  
ATOM    821  CG  GLN A 330      41.181  39.314  47.471  1.00 61.70           C  
ATOM    822  CD  GLN A 330      41.781  38.851  48.791  1.00 64.92           C  
ATOM    823  OE1 GLN A 330      41.347  37.849  49.363  1.00 66.12           O  
ATOM    824  NE2 GLN A 330      42.790  39.573  49.277  1.00 65.82           N  
ATOM    825  N   GLU A 331      41.609  43.231  44.895  1.00 59.28           N  
ATOM    826  CA  GLU A 331      42.202  44.521  44.544  1.00 62.10           C  
ATOM    827  C   GLU A 331      43.268  44.884  45.566  1.00 63.46           C  
ATOM    828  O   GLU A 331      44.463  44.903  45.261  1.00 63.94           O  
ATOM    829  CB  GLU A 331      41.163  45.649  44.565  1.00 64.78           C  
ATOM    830  CG  GLU A 331      39.855  45.401  43.830  1.00 67.11           C  
ATOM    831  CD  GLU A 331      38.879  46.570  43.989  1.00 67.90           C  
ATOM    832  OE1 GLU A 331      38.599  46.962  45.149  1.00 66.09           O  
ATOM    833  OE2 GLU A 331      38.397  47.096  42.955  1.00 68.02           O  
ATOM    834  N   GLN A 332      42.804  45.175  46.784  1.00 64.21           N  
ATOM    835  CA  GLN A 332      43.657  45.581  47.902  1.00 65.49           C  
ATOM    836  C   GLN A 332      44.902  44.726  48.131  1.00 64.30           C  
ATOM    837  O   GLN A 332      45.764  45.097  48.922  1.00 64.93           O  
ATOM    838  CB  GLN A 332      42.826  45.643  49.201  1.00 68.39           C  
ATOM    839  CG  GLN A 332      41.878  46.861  49.298  1.00 72.03           C  
ATOM    840  CD  GLN A 332      40.698  46.657  50.264  1.00 73.55           C  
ATOM    841  OE1 GLN A 332      39.858  45.772  50.064  1.00 74.65           O  
ATOM    842  NE2 GLN A 332      40.627  47.488  51.306  1.00 72.52           N  
ATOM    843  N   LYS A 333      45.005  43.595  47.438  1.00 62.97           N  
ATOM    844  CA  LYS A 333      46.156  42.709  47.592  1.00 60.71           C  
ATOM    845  C   LYS A 333      47.303  43.098  46.654  1.00 59.46           C  
ATOM    846  O   LYS A 333      48.449  42.691  46.848  1.00 59.82           O  
ATOM    847  CB  LYS A 333      45.732  41.263  47.334  1.00 61.31           C  
ATOM    848  CG  LYS A 333      46.502  40.236  48.140  1.00 61.76           C  
ATOM    849  CD  LYS A 333      46.010  38.830  47.851  1.00 63.58           C  
ATOM    850  CE  LYS A 333      46.650  37.814  48.794  1.00 64.13           C  
ATOM    851  NZ  LYS A 333      48.138  37.839  48.731  1.00 65.23           N  
ATOM    852  N   HIS A 334      46.984  43.879  45.631  1.00 58.26           N  
ATOM    853  CA  HIS A 334      47.967  44.348  44.663  1.00 57.84           C  
ATOM    854  C   HIS A 334      48.991  43.320  44.165  1.00 55.62           C  
ATOM    855  O   HIS A 334      50.206  43.523  44.270  1.00 55.27           O  
ATOM    856  CB  HIS A 334      48.673  45.580  45.230  1.00 60.62           C  
ATOM    857  CG  HIS A 334      47.729  46.684  45.595  1.00 65.82           C  
ATOM    858  ND1 HIS A 334      46.822  47.213  44.698  1.00 66.69           N  
ATOM    859  CD2 HIS A 334      47.510  47.325  46.769  1.00 66.65           C  
ATOM    860  CE1 HIS A 334      46.084  48.127  45.304  1.00 66.78           C  
ATOM    861  NE2 HIS A 334      46.481  48.213  46.562  1.00 67.97           N  
ATOM    862  N   THR A 335      48.483  42.222  43.607  1.00 52.17           N  
ATOM    863  CA  THR A 335      49.323  41.162  43.055  1.00 47.09           C  
ATOM    864  C   THR A 335      49.434  41.353  41.549  1.00 44.39           C  
ATOM    865  O   THR A 335      48.434  41.349  40.837  1.00 43.55           O  
ATOM    866  CB  THR A 335      48.723  39.790  43.328  1.00 45.76           C  
ATOM    867  OG1 THR A 335      48.446  39.673  44.727  1.00 46.32           O  
ATOM    868  CG2 THR A 335      49.693  38.694  42.915  1.00 43.56           C  
ATOM    869  N   TYR A 336      50.658  41.528  41.071  1.00 43.52           N  
ATOM    870  CA  TYR A 336      50.900  41.745  39.649  1.00 42.00           C  
ATOM    871  C   TYR A 336      51.651  40.580  39.024  1.00 40.04           C  
ATOM    872  O   TYR A 336      52.605  40.077  39.591  1.00 40.94           O  
ATOM    873  CB  TYR A 336      51.691  43.038  39.452  1.00 41.55           C  
ATOM    874  CG  TYR A 336      51.096  44.215  40.176  1.00 41.54           C  
ATOM    875  CD1 TYR A 336      51.787  44.839  41.217  1.00 43.23           C  
ATOM    876  CD2 TYR A 336      49.840  44.712  39.824  1.00 42.86           C  
ATOM    877  CE1 TYR A 336      51.249  45.934  41.894  1.00 42.35           C  
ATOM    878  CE2 TYR A 336      49.285  45.810  40.492  1.00 44.44           C  
ATOM    879  CZ  TYR A 336      49.999  46.417  41.527  1.00 45.31           C  
ATOM    880  OH  TYR A 336      49.471  47.513  42.184  1.00 46.38           O  
ATOM    881  N   LEU A 337      51.210  40.157  37.849  1.00 38.71           N  
ATOM    882  CA  LEU A 337      51.823  39.044  37.144  1.00 35.93           C  
ATOM    883  C   LEU A 337      52.205  39.476  35.748  1.00 35.63           C  
ATOM    884  O   LEU A 337      51.434  40.152  35.062  1.00 37.35           O  
ATOM    885  CB  LEU A 337      50.836  37.878  37.046  1.00 33.42           C  
ATOM    886  CG  LEU A 337      50.823  36.790  38.122  1.00 33.47           C  
ATOM    887  CD1 LEU A 337      51.056  37.370  39.494  1.00 33.19           C  
ATOM    888  CD2 LEU A 337      49.484  36.059  38.053  1.00 34.01           C  
ATOM    889  N   PRO A 338      53.408  39.098  35.302  1.00 34.10           N  
ATOM    890  CA  PRO A 338      53.854  39.470  33.952  1.00 33.28           C  
ATOM    891  C   PRO A 338      52.999  38.690  32.955  1.00 31.07           C  
ATOM    892  O   PRO A 338      52.665  37.538  33.213  1.00 31.45           O  
ATOM    893  CB  PRO A 338      55.321  39.020  33.926  1.00 33.37           C  
ATOM    894  CG  PRO A 338      55.694  38.913  35.390  1.00 35.29           C  
ATOM    895  CD  PRO A 338      54.457  38.376  36.036  1.00 32.26           C  
ATOM    896  N   LEU A 339      52.645  39.298  31.832  1.00 28.86           N  
ATOM    897  CA  LEU A 339      51.827  38.605  30.847  1.00 31.15           C  
ATOM    898  C   LEU A 339      52.473  37.293  30.396  1.00 33.70           C  
ATOM    899  O   LEU A 339      51.793  36.282  30.207  1.00 33.56           O  
ATOM    900  CB  LEU A 339      51.586  39.490  29.622  1.00 30.32           C  
ATOM    901  CG  LEU A 339      51.081  40.924  29.817  1.00 31.16           C  
ATOM    902  CD1 LEU A 339      50.674  41.450  28.462  1.00 29.62           C  
ATOM    903  CD2 LEU A 339      49.897  40.984  30.775  1.00 30.86           C  
ATOM    904  N   GLU A 340      53.787  37.315  30.218  1.00 36.50           N  
ATOM    905  CA  GLU A 340      54.536  36.138  29.782  1.00 37.70           C  
ATOM    906  C   GLU A 340      54.216  34.842  30.496  1.00 36.74           C  
ATOM    907  O   GLU A 340      54.098  33.802  29.857  1.00 39.27           O  
ATOM    908  CB  GLU A 340      56.023  36.374  29.947  1.00 40.83           C  
ATOM    909  CG  GLU A 340      56.596  37.355  28.984  1.00 45.47           C  
ATOM    910  CD  GLU A 340      57.965  37.757  29.402  1.00 46.33           C  
ATOM    911  OE1 GLU A 340      58.790  36.851  29.653  1.00 48.35           O  
ATOM    912  OE2 GLU A 340      58.207  38.975  29.490  1.00 48.59           O  
ATOM    913  N   VAL A 341      54.108  34.904  31.818  1.00 34.94           N  
ATOM    914  CA  VAL A 341      53.838  33.721  32.632  1.00 32.82           C  
ATOM    915  C   VAL A 341      52.367  33.343  32.714  1.00 32.12           C  
ATOM    916  O   VAL A 341      52.002  32.427  33.451  1.00 31.96           O  
ATOM    917  CB  VAL A 341      54.350  33.909  34.087  1.00 32.35           C  
ATOM    918  CG1 VAL A 341      55.818  34.274  34.087  1.00 31.94           C  
ATOM    919  CG2 VAL A 341      53.546  34.972  34.790  1.00 29.46           C  
ATOM    920  N   CYS A 342      51.521  34.030  31.955  1.00 31.12           N  
ATOM    921  CA  CYS A 342      50.095  33.749  32.010  1.00 30.77           C  
ATOM    922  C   CYS A 342      49.427  33.117  30.793  1.00 30.37           C  
ATOM    923  O   CYS A 342      49.700  33.470  29.647  1.00 29.94           O  
ATOM    924  CB  CYS A 342      49.340  35.021  32.377  1.00 28.44           C  
ATOM    925  SG  CYS A 342      49.687  35.604  34.021  1.00 29.09           S  
ATOM    926  N   ASN A 343      48.529  32.184  31.084  1.00 30.18           N  
ATOM    927  CA  ASN A 343      47.754  31.478  30.083  1.00 32.93           C  
ATOM    928  C   ASN A 343      46.271  31.637  30.436  1.00 35.25           C  
ATOM    929  O   ASN A 343      45.898  31.559  31.611  1.00 36.84           O  
ATOM    930  CB  ASN A 343      48.107  29.995  30.096  1.00 35.16           C  
ATOM    931  CG  ASN A 343      49.230  29.659  29.165  1.00 34.75           C  
ATOM    932  OD1 ASN A 343      50.299  30.241  29.228  1.00 38.51           O  
ATOM    933  ND2 ASN A 343      48.992  28.708  28.285  1.00 39.61           N  
ATOM    934  N   ILE A 344      45.429  31.863  29.436  1.00 34.94           N  
ATOM    935  CA  ILE A 344      44.007  32.004  29.699  1.00 36.46           C  
ATOM    936  C   ILE A 344      43.435  30.623  29.924  1.00 39.31           C  
ATOM    937  O   ILE A 344      43.646  29.721  29.114  1.00 40.56           O  
ATOM    938  CB  ILE A 344      43.251  32.678  28.515  1.00 34.41           C  
ATOM    939  CG1 ILE A 344      43.592  34.168  28.470  1.00 33.68           C  
ATOM    940  CG2 ILE A 344      41.733  32.486  28.668  1.00 30.60           C  
ATOM    941  CD1 ILE A 344      42.907  34.917  27.365  1.00 34.75           C  
ATOM    942  N   VAL A 345      42.714  30.469  31.032  1.00 41.53           N  
ATOM    943  CA  VAL A 345      42.094  29.198  31.382  1.00 43.96           C  
ATOM    944  C   VAL A 345      40.719  29.099  30.726  1.00 47.07           C  
ATOM    945  O   VAL A 345      39.820  29.897  31.007  1.00 47.26           O  
ATOM    946  CB  VAL A 345      41.936  29.069  32.919  1.00 43.15           C  
ATOM    947  CG1 VAL A 345      41.278  27.739  33.277  1.00 40.81           C  
ATOM    948  CG2 VAL A 345      43.289  29.197  33.588  1.00 41.40           C  
ATOM    949  N   ALA A 346      40.562  28.121  29.844  1.00 51.26           N  
ATOM    950  CA  ALA A 346      39.288  27.917  29.160  1.00 55.85           C  
ATOM    951  C   ALA A 346      38.285  27.199  30.075  1.00 58.47           C  
ATOM    952  O   ALA A 346      38.648  26.258  30.793  1.00 58.20           O  
ATOM    953  CB  ALA A 346      39.509  27.111  27.878  1.00 54.37           C  
ATOM    954  N   GLY A 347      37.031  27.654  30.051  1.00 61.19           N  
ATOM    955  CA  GLY A 347      35.991  27.040  30.863  1.00 64.21           C  
ATOM    956  C   GLY A 347      35.804  25.575  30.499  1.00 66.99           C  
ATOM    957  O   GLY A 347      36.233  25.136  29.428  1.00 66.12           O  
ATOM    958  N   GLN A 348      35.166  24.811  31.380  1.00 69.57           N  
ATOM    959  CA  GLN A 348      34.959  23.394  31.110  1.00 72.70           C  
ATOM    960  C   GLN A 348      33.531  22.911  31.337  1.00 74.13           C  
ATOM    961  O   GLN A 348      33.320  21.764  31.730  1.00 75.40           O  
ATOM    962  CB  GLN A 348      35.916  22.551  31.955  1.00 71.99           C  
ATOM    963  CG  GLN A 348      37.377  22.923  31.792  1.00 72.94           C  
ATOM    964  CD  GLN A 348      38.313  21.777  32.137  1.00 73.57           C  
ATOM    965  OE1 GLN A 348      38.400  20.790  31.403  1.00 73.02           O  
ATOM    966  NE2 GLN A 348      39.018  21.902  33.260  1.00 73.34           N  
ATOM    967  N   ARG A 349      32.552  23.777  31.088  1.00 75.57           N  
ATOM    968  CA  ARG A 349      31.151  23.402  31.271  1.00 76.53           C  
ATOM    969  C   ARG A 349      30.818  22.097  30.544  1.00 76.32           C  
ATOM    970  O   ARG A 349      31.431  21.759  29.530  1.00 75.86           O  
ATOM    971  CB  ARG A 349      30.225  24.517  30.766  1.00 77.53           C  
ATOM    972  CG  ARG A 349      30.038  25.688  31.722  1.00 77.97           C  
ATOM    973  CD  ARG A 349      29.034  26.676  31.143  1.00 79.51           C  
ATOM    974  NE  ARG A 349      28.692  27.760  32.060  1.00 81.74           N  
ATOM    975  CZ  ARG A 349      29.574  28.586  32.618  1.00 82.97           C  
ATOM    976  NH1 ARG A 349      30.870  28.455  32.362  1.00 83.72           N  
ATOM    977  NH2 ARG A 349      29.157  29.550  33.428  1.00 83.50           N  
TER     978      ARG A 349                                                      
END
MOLECULE T0487_178_265.pdb
ATOM   1389  N   SER   178      50.886  32.816  25.767  1.00 72.79           N  
ATOM   1390  CA  SER   178      50.904  33.757  26.889  1.00 70.07           C  
ATOM   1391  C   SER   178      49.706  34.705  26.864  1.00 68.01           C  
ATOM   1392  O   SER   178      49.068  34.887  25.828  1.00 67.65           O  
ATOM   1393  CB  SER   178      52.174  34.607  26.842  1.00 70.56           C  
ATOM   1394  OG  SER   178      51.942  35.805  26.101  1.00 69.80           O  
ATOM   1395  N   LEU   179      49.423  35.323  28.008  1.00 65.44           N  
ATOM   1396  CA  LEU   179      48.324  36.270  28.111  1.00 64.41           C  
ATOM   1397  C   LEU   179      48.681  37.485  27.264  1.00 65.44           C  
ATOM   1398  O   LEU   179      47.803  38.213  26.811  1.00 64.49           O  
ATOM   1399  CB  LEU   179      48.133  36.706  29.564  1.00 63.05           C  
ATOM   1400  CG  LEU   179      46.806  37.324  30.046  1.00 63.07           C  
ATOM   1401  CD1 LEU   179      47.061  38.669  30.666  1.00 59.96           C  
ATOM   1402  CD2 LEU   179      45.810  37.439  28.911  1.00 63.32           C  
ATOM   1403  N   GLU   180      49.979  37.711  27.072  1.00 66.94           N  
ATOM   1404  CA  GLU   180      50.451  38.838  26.277  1.00 68.35           C  
ATOM   1405  C   GLU   180      50.122  38.532  24.826  1.00 69.37           C  
ATOM   1406  O   GLU   180      49.522  39.351  24.124  1.00 69.29           O  
ATOM   1407  CB  GLU   180      51.968  39.021  26.433  1.00 69.56           C  
ATOM   1408  CG  GLU   180      52.578  40.133  25.564  1.00 68.16           C  
ATOM   1409  CD  GLU   180      51.789  41.432  25.644  1.00 70.51           C  
ATOM   1410  OE1 GLU   180      51.352  41.804  26.751  1.00 71.02           O  
ATOM   1411  OE2 GLU   180      51.606  42.095  24.601  1.00 72.24           O  
ATOM   1412  N   ALA   181      50.509  37.339  24.387  1.00 68.86           N  
ATOM   1413  CA  ALA   181      50.246  36.915  23.020  1.00 68.70           C  
ATOM   1414  C   ALA   181      48.751  36.958  22.734  1.00 68.21           C  
ATOM   1415  O   ALA   181      48.298  37.630  21.811  1.00 67.78           O  
ATOM   1416  CB  ALA   181      50.778  35.493  22.799  1.00 68.81           C  
ATOM   1417  N   TRP   182      47.990  36.245  23.554  1.00 67.73           N  
ATOM   1418  CA  TRP   182      46.554  36.156  23.382  1.00 67.32           C  
ATOM   1419  C   TRP   182      45.879  37.511  23.267  1.00 66.70           C  
ATOM   1420  O   TRP   182      45.005  37.712  22.425  1.00 64.93           O  
ATOM   1421  CB  TRP   182      45.951  35.379  24.545  1.00 66.80           C  
ATOM   1422  CG  TRP   182      44.717  34.606  24.192  1.00 66.97           C  
ATOM   1423  CD1 TRP   182      44.627  33.513  23.363  1.00 67.71           C  
ATOM   1424  CD2 TRP   182      43.412  34.821  24.711  1.00 65.75           C  
ATOM   1425  NE1 TRP   182      43.337  33.031  23.348  1.00 66.31           N  
ATOM   1426  CE2 TRP   182      42.571  33.818  24.167  1.00 66.78           C  
ATOM   1427  CE3 TRP   182      42.866  35.761  25.585  1.00 65.78           C  
ATOM   1428  CZ2 TRP   182      41.213  33.734  24.476  1.00 68.00           C  
ATOM   1429  CZ3 TRP   182      41.513  35.680  25.893  1.00 68.30           C  
ATOM   1430  CH2 TRP   182      40.700  34.673  25.340  1.00 69.32           C  
ATOM   1431  N   LEU   183      46.271  38.438  24.128  1.00 67.37           N  
ATOM   1432  CA  LEU   183      45.668  39.763  24.101  1.00 68.70           C  
ATOM   1433  C   LEU   183      46.163  40.567  22.902  1.00 70.28           C  
ATOM   1434  O   LEU   183      45.409  41.379  22.354  1.00 70.00           O  
ATOM   1435  CB  LEU   183      45.960  40.523  25.397  1.00 65.92           C  
ATOM   1436  CG  LEU   183      45.158  40.159  26.643  1.00 64.80           C  
ATOM   1437  CD1 LEU   183      45.737  40.878  27.843  1.00 65.61           C  
ATOM   1438  CD2 LEU   183      43.717  40.543  26.469  1.00 63.29           C  
ATOM   1439  N   ALA   184      47.418  40.344  22.498  1.00 70.51           N  
ATOM   1440  CA  ALA   184      47.986  41.054  21.353  1.00 70.65           C  
ATOM   1441  C   ALA   184      47.157  40.725  20.112  1.00 72.14           C  
ATOM   1442  O   ALA   184      46.811  41.613  19.322  1.00 74.22           O  
ATOM   1443  CB  ALA   184      49.439  40.642  21.128  1.00 67.57           C  
ATOM   1444  N   GLN   185      46.823  39.448  19.959  1.00 71.41           N  
ATOM   1445  CA  GLN   185      46.055  38.988  18.822  1.00 70.02           C  
ATOM   1446  C   GLN   185      44.571  39.360  18.885  1.00 70.30           C  
ATOM   1447  O   GLN   185      43.754  38.814  18.140  1.00 72.30           O  
ATOM   1448  CB  GLN   185      46.250  37.478  18.668  1.00 70.34           C  
ATOM   1449  CG  GLN   185      47.700  37.106  18.314  1.00 71.08           C  
ATOM   1450  CD  GLN   185      48.049  35.632  18.569  1.00 73.18           C  
ATOM   1451  OE1 GLN   185      47.240  34.728  18.313  1.00 75.02           O  
ATOM   1452  NE2 GLN   185      49.270  35.386  19.059  1.00 70.57           N  
ATOM   1453  N   GLY   186      44.220  40.280  19.780  1.00 69.12           N  
ATOM   1454  CA  GLY   186      42.842  40.736  19.865  1.00 68.35           C  
ATOM   1455  C   GLY   186      41.785  40.064  20.725  1.00 68.79           C  
ATOM   1456  O   GLY   186      40.698  40.631  20.863  1.00 68.00           O  
ATOM   1457  N   HIS   187      42.061  38.888  21.297  1.00 70.02           N  
ATOM   1458  CA  HIS   187      41.061  38.198  22.133  1.00 70.95           C  
ATOM   1459  C   HIS   187      40.753  38.993  23.388  1.00 70.80           C  
ATOM   1460  O   HIS   187      41.644  39.608  23.966  1.00 72.87           O  
ATOM   1461  CB  HIS   187      41.548  36.818  22.568  1.00 72.13           C  
ATOM   1462  CG  HIS   187      41.837  35.881  21.435  1.00 75.45           C  
ATOM   1463  ND1 HIS   187      43.103  35.712  20.912  1.00 76.97           N  
ATOM   1464  CD2 HIS   187      41.031  35.032  20.752  1.00 75.28           C  
ATOM   1465  CE1 HIS   187      43.065  34.798  19.957  1.00 77.65           C  
ATOM   1466  NE2 HIS   187      41.820  34.370  19.841  1.00 77.28           N  
ATOM   1467  N   PRO   188      39.493  38.976  23.844  1.00 69.33           N  
ATOM   1468  CA  PRO   188      39.108  39.717  25.047  1.00 68.82           C  
ATOM   1469  C   PRO   188      39.831  39.288  26.332  1.00 69.05           C  
ATOM   1470  O   PRO   188      40.532  38.273  26.377  1.00 67.98           O  
ATOM   1471  CB  PRO   188      37.607  39.483  25.122  1.00 67.89           C  
ATOM   1472  CG  PRO   188      37.476  38.105  24.590  1.00 68.52           C  
ATOM   1473  CD  PRO   188      38.377  38.142  23.373  1.00 69.36           C  
ATOM   1474  N   LEU   189      39.631  40.088  27.375  1.00 69.24           N  
ATOM   1475  CA  LEU   189      40.226  39.893  28.694  1.00 68.26           C  
ATOM   1476  C   LEU   189      39.519  38.753  29.426  1.00 67.78           C  
ATOM   1477  O   LEU   189      38.325  38.853  29.703  1.00 67.72           O  
ATOM   1478  CB  LEU   189      40.048  41.184  29.487  1.00 68.50           C  
ATOM   1479  CG  LEU   189      41.061  41.714  30.495  1.00 69.40           C  
ATOM   1480  CD1 LEU   189      42.320  42.193  29.785  1.00 68.24           C  
ATOM   1481  CD2 LEU   189      40.423  42.861  31.252  1.00 69.17           C  
ATOM   1482  N   PRO   190      40.238  37.653  29.738  1.00 66.51           N  
ATOM   1483  CA  PRO   190      39.635  36.518  30.445  1.00 66.30           C  
ATOM   1484  C   PRO   190      39.386  36.844  31.906  1.00 65.77           C  
ATOM   1485  O   PRO   190      39.913  37.815  32.442  1.00 64.95           O  
ATOM   1486  CB  PRO   190      40.659  35.409  30.259  1.00 65.74           C  
ATOM   1487  CG  PRO   190      41.934  36.142  30.209  1.00 65.98           C  
ATOM   1488  CD  PRO   190      41.608  37.323  29.323  1.00 66.24           C  
ATOM   1489  N   LYS   191      38.574  36.029  32.555  1.00 66.90           N  
ATOM   1490  CA  LYS   191      38.252  36.281  33.940  1.00 68.59           C  
ATOM   1491  C   LYS   191      39.385  35.895  34.877  1.00 69.54           C  
ATOM   1492  O   LYS   191      39.714  36.611  35.811  1.00 69.46           O  
ATOM   1493  CB  LYS   191      36.971  35.507  34.339  1.00 66.50           C  
ATOM   1494  N   ARG   192      40.013  34.775  34.579  1.00 71.25           N  
ATOM   1495  CA  ARG   192      41.003  34.185  35.433  1.00 72.21           C  
ATOM   1496  C   ARG   192      42.272  33.878  34.698  1.00 71.41           C  
ATOM   1497  O   ARG   192      42.220  33.436  33.559  1.00 70.49           O  
ATOM   1498  CB  ARG   192      40.461  32.862  35.897  1.00 73.81           C  
ATOM   1499  CG  ARG   192      40.240  32.724  37.306  1.00 77.12           C  
ATOM   1500  CD  ARG   192      38.931  33.293  37.700  1.00 79.09           C  
ATOM   1501  NE  ARG   192      38.792  32.976  39.096  1.00 83.42           N  
ATOM   1502  CZ  ARG   192      38.232  33.757  40.002  1.00 85.75           C  
ATOM   1503  NH1 ARG   192      37.744  34.933  39.637  1.00 85.86           N  
ATOM   1504  NH2 ARG   192      38.175  33.346  41.272  1.00 86.41           N  
ATOM   1505  N   VAL   193      43.405  34.036  35.376  1.00 70.67           N  
ATOM   1506  CA  VAL   193      44.691  33.778  34.753  1.00 69.01           C  
ATOM   1507  C   VAL   193      45.496  32.785  35.566  1.00 68.15           C  
ATOM   1508  O   VAL   193      45.343  32.710  36.774  1.00 69.21           O  
ATOM   1509  CB  VAL   193      45.483  35.071  34.630  1.00 69.25           C  
ATOM   1510  CG1 VAL   193      46.781  34.825  33.918  1.00 71.90           C  
ATOM   1511  CG2 VAL   193      44.654  36.096  33.902  1.00 68.33           C  
ATOM   1512  N   ARG   194      46.379  32.039  34.916  1.00 67.11           N  
ATOM   1513  CA  ARG   194      47.211  31.081  35.619  1.00 66.36           C  
ATOM   1514  C   ARG   194      48.648  31.524  35.461  1.00 66.04           C  
ATOM   1515  O   ARG   194      48.986  32.188  34.495  1.00 66.50           O  
ATOM   1516  CB  ARG   194      47.041  29.706  35.003  1.00 68.43           C  
ATOM   1517  CG  ARG   194      47.425  28.562  35.902  1.00 71.86           C  
ATOM   1518  CD  ARG   194      48.589  27.803  35.321  1.00 76.27           C  
ATOM   1519  NE  ARG   194      48.386  27.429  33.922  1.00 80.71           N  
ATOM   1520  CZ  ARG   194      49.372  27.027  33.117  1.00 84.44           C  
ATOM   1521  NH1 ARG   194      50.617  26.949  33.581  1.00 85.78           N  
ATOM   1522  NH2 ARG   194      49.128  26.718  31.846  1.00 85.83           N  
ATOM   1523  N   ASN   195      49.496  31.182  36.421  1.00 65.91           N  
ATOM   1524  CA  ASN   195      50.898  31.535  36.310  1.00 64.68           C  
ATOM   1525  C   ASN   195      51.400  30.608  35.223  1.00 63.81           C  
ATOM   1526  O   ASN   195      50.868  29.512  35.058  1.00 62.14           O  
ATOM   1527  CB  ASN   195      51.664  31.234  37.606  1.00 65.09           C  
ATOM   1528  CG  ASN   195      51.538  32.338  38.641  1.00 66.86           C  
ATOM   1529  OD1 ASN   195      51.062  33.438  38.350  1.00 66.81           O  
ATOM   1530  ND2 ASN   195      51.982  32.051  39.858  1.00 66.69           N  
ATOM   1531  N   ALA   196      52.412  31.040  34.478  1.00 63.13           N  
ATOM   1532  CA  ALA   196      52.977  30.189  33.435  1.00 62.64           C  
ATOM   1533  C   ALA   196      53.970  29.213  34.062  1.00 62.41           C  
ATOM   1534  O   ALA   196      54.076  28.076  33.631  1.00 62.74           O  
ATOM   1535  CB  ALA   196      53.669  31.035  32.379  1.00 60.19           C  
ATOM   1536  N   TYR   197      54.673  29.665  35.097  1.00 63.83           N  
ATOM   1537  CA  TYR   197      55.675  28.856  35.796  1.00 64.54           C  
ATOM   1538  C   TYR   197      55.148  27.838  36.825  1.00 65.64           C  
ATOM   1539  O   TYR   197      55.920  27.054  37.385  1.00 67.88           O  
ATOM   1540  CB  TYR   197      56.705  29.770  36.462  1.00 61.90           C  
ATOM   1541  CG  TYR   197      56.102  30.959  37.159  1.00 58.48           C  
ATOM   1542  CD1 TYR   197      55.931  32.173  36.496  1.00 56.01           C  
ATOM   1543  CD2 TYR   197      55.685  30.866  38.483  1.00 58.22           C  
ATOM   1544  CE1 TYR   197      55.355  33.265  37.140  1.00 55.57           C  
ATOM   1545  CE2 TYR   197      55.111  31.947  39.131  1.00 56.93           C  
ATOM   1546  CZ  TYR   197      54.944  33.133  38.459  1.00 56.38           C  
ATOM   1547  OH  TYR   197      54.312  34.151  39.121  1.00 58.19           O  
ATOM   1548  N   ASP   198      53.850  27.871  37.099  1.00 65.09           N  
ATOM   1549  CA  ASP   198      53.227  26.901  37.998  1.00 63.43           C  
ATOM   1550  C   ASP   198      51.731  26.951  37.788  1.00 62.42           C  
ATOM   1551  O   ASP   198      51.239  27.730  36.974  1.00 63.52           O  
ATOM   1552  CB  ASP   198      53.611  27.109  39.479  1.00 64.26           C  
ATOM   1553  CG  ASP   198      53.151  28.434  40.053  1.00 65.88           C  
ATOM   1554  OD1 ASP   198      51.939  28.745  40.023  1.00 66.73           O  
ATOM   1555  OD2 ASP   198      54.022  29.161  40.570  1.00 66.88           O  
ATOM   1556  N   ARG   199      50.996  26.124  38.506  1.00 61.43           N  
ATOM   1557  CA  ARG   199      49.563  26.081  38.311  1.00 61.61           C  
ATOM   1558  C   ARG   199      48.703  27.055  39.118  1.00 61.63           C  
ATOM   1559  O   ARG   199      47.472  26.957  39.087  1.00 62.25           O  
ATOM   1560  CB  ARG   199      49.076  24.656  38.521  1.00 61.85           C  
ATOM   1561  N   ARG   200      49.303  28.003  39.825  1.00 61.76           N  
ATOM   1562  CA  ARG   200      48.470  28.929  40.580  1.00 63.49           C  
ATOM   1563  C   ARG   200      47.630  29.805  39.653  1.00 62.41           C  
ATOM   1564  O   ARG   200      48.124  30.305  38.645  1.00 62.12           O  
ATOM   1565  CB  ARG   200      49.307  29.824  41.497  1.00 66.92           C  
ATOM   1566  CG  ARG   200      48.426  30.796  42.301  1.00 71.18           C  
ATOM   1567  CD  ARG   200      49.138  31.366  43.512  1.00 74.24           C  
ATOM   1568  NE  ARG   200      48.225  32.139  44.348  1.00 78.08           N  
ATOM   1569  CZ  ARG   200      48.525  32.597  45.564  1.00 80.74           C  
ATOM   1570  NH1 ARG   200      49.720  32.362  46.097  1.00 79.79           N  
ATOM   1571  NH2 ARG   200      47.626  33.295  46.251  1.00 81.86           N  
ATOM   1572  N   THR   201      46.361  29.991  39.999  1.00 60.13           N  
ATOM   1573  CA  THR   201      45.482  30.804  39.180  1.00 60.15           C  
ATOM   1574  C   THR   201      45.130  32.081  39.904  1.00 59.16           C  
ATOM   1575  O   THR   201      45.423  32.222  41.081  1.00 60.04           O  
ATOM   1576  CB  THR   201      44.171  30.069  38.837  1.00 61.49           C  
ATOM   1577  OG1 THR   201      43.358  29.969  40.011  1.00 63.21           O  
ATOM   1578  CG2 THR   201      44.465  28.670  38.287  1.00 61.45           C  
ATOM   1579  N   TRP   202      44.508  33.013  39.192  1.00 58.57           N  
ATOM   1580  CA  TRP   202      44.117  34.287  39.774  1.00 58.33           C  
ATOM   1581  C   TRP   202      42.922  34.884  39.051  1.00 59.89           C  
ATOM   1582  O   TRP   202      42.480  34.403  38.015  1.00 57.22           O  
ATOM   1583  CB  TRP   202      45.230  35.342  39.687  1.00 56.73           C  
ATOM   1584  CG  TRP   202      46.623  34.925  39.996  1.00 56.77           C  
ATOM   1585  CD1 TRP   202      47.492  34.280  39.165  1.00 56.59           C  
ATOM   1586  CD2 TRP   202      47.355  35.223  41.186  1.00 57.19           C  
ATOM   1587  NE1 TRP   202      48.726  34.165  39.761  1.00 56.12           N  
ATOM   1588  CE2 TRP   202      48.668  34.735  41.001  1.00 57.56           C  
ATOM   1589  CE3 TRP   202      47.031  35.860  42.386  1.00 56.85           C  
ATOM   1590  CZ2 TRP   202      49.659  34.871  41.980  1.00 58.30           C  
ATOM   1591  CZ3 TRP   202      48.016  35.995  43.357  1.00 57.50           C  
ATOM   1592  CH2 TRP   202      49.315  35.501  43.148  1.00 58.22           C  
ATOM   1593  N   GLU   203      42.441  35.982  39.611  1.00 63.38           N  
ATOM   1594  CA  GLU   203      41.325  36.726  39.070  1.00 66.11           C  
ATOM   1595  C   GLU   203      42.001  37.892  38.363  1.00 65.79           C  
ATOM   1596  O   GLU   203      42.750  38.642  38.980  1.00 66.11           O  
ATOM   1597  CB  GLU   203      40.460  37.238  40.223  1.00 70.66           C  
ATOM   1598  CG  GLU   203      39.117  37.839  39.837  1.00 77.93           C  
ATOM   1599  CD  GLU   203      38.422  38.524  41.029  1.00 82.54           C  
ATOM   1600  OE1 GLU   203      38.918  38.381  42.172  1.00 84.18           O  
ATOM   1601  OE2 GLU   203      37.383  39.206  40.829  1.00 83.53           O  
ATOM   1602  N   LEU   204      41.769  38.031  37.066  1.00 65.73           N  
ATOM   1603  CA  LEU   204      42.370  39.123  36.329  1.00 65.17           C  
ATOM   1604  C   LEU   204      41.429  40.300  36.476  1.00 66.53           C  
ATOM   1605  O   LEU   204      40.241  40.183  36.197  1.00 67.24           O  
ATOM   1606  CB  LEU   204      42.514  38.754  34.865  1.00 63.65           C  
ATOM   1607  CG  LEU   204      43.641  39.447  34.119  1.00 61.57           C  
ATOM   1608  CD1 LEU   204      43.306  39.451  32.639  1.00 60.65           C  
ATOM   1609  CD2 LEU   204      43.821  40.845  34.639  1.00 61.03           C  
ATOM   1610  N   LEU   205      41.960  41.431  36.925  1.00 68.73           N  
ATOM   1611  CA  LEU   205      41.153  42.629  37.136  1.00 69.65           C  
ATOM   1612  C   LEU   205      41.264  43.606  35.975  1.00 71.33           C  
ATOM   1613  O   LEU   205      40.257  44.084  35.448  1.00 72.62           O  
ATOM   1614  CB  LEU   205      41.591  43.353  38.408  1.00 66.89           C  
ATOM   1615  CG  LEU   205      41.730  42.558  39.695  1.00 64.42           C  
ATOM   1616  CD1 LEU   205      42.144  43.511  40.811  1.00 63.12           C  
ATOM   1617  CD2 LEU   205      40.434  41.862  40.009  1.00 62.32           C  
ATOM   1618  N   ARG   206      42.495  43.910  35.588  1.00 71.79           N  
ATOM   1619  CA  ARG   206      42.729  44.851  34.515  1.00 72.64           C  
ATOM   1620  C   ARG   206      44.183  44.866  34.156  1.00 73.27           C  
ATOM   1621  O   ARG   206      44.993  44.216  34.793  1.00 72.83           O  
ATOM   1622  CB  ARG   206      42.315  46.258  34.952  1.00 73.68           C  
ATOM   1623  CG  ARG   206      42.461  46.518  36.461  1.00 76.14           C  
ATOM   1624  CD  ARG   206      42.338  48.005  36.799  1.00 77.52           C  
ATOM   1625  NE  ARG   206      43.537  48.740  36.395  1.00 79.70           N  
ATOM   1626  CZ  ARG   206      44.510  49.108  37.229  1.00 81.47           C  
ATOM   1627  NH1 ARG   206      44.430  48.823  38.531  1.00 82.03           N  
ATOM   1628  NH2 ARG   206      45.582  49.734  36.761  1.00 80.76           N  
ATOM   1629  N   LEU   207      44.507  45.614  33.116  1.00 76.18           N  
ATOM   1630  CA  LEU   207      45.886  45.752  32.681  1.00 78.80           C  
ATOM   1631  C   LEU   207      46.356  47.051  33.297  1.00 80.34           C  
ATOM   1632  O   LEU   207      45.544  47.817  33.814  1.00 80.93           O  
ATOM   1633  CB  LEU   207      45.969  45.846  31.162  1.00 78.21           C  
ATOM   1634  CG  LEU   207      46.783  44.769  30.459  1.00 79.21           C  
ATOM   1635  CD1 LEU   207      46.312  43.383  30.902  1.00 80.00           C  
ATOM   1636  CD2 LEU   207      46.622  44.939  28.956  1.00 80.04           C  
ATOM   1637  N   GLY   208      47.659  47.293  33.249  1.00 82.20           N  
ATOM   1638  CA  GLY   208      48.200  48.511  33.814  1.00 84.47           C  
ATOM   1639  C   GLY   208      49.210  49.157  32.894  1.00 86.77           C  
ATOM   1640  O   GLY   208      49.906  48.484  32.131  1.00 85.23           O  
ATOM   1641  N   GLU   209      49.303  50.477  32.983  1.00 90.43           N  
ATOM   1642  CA  GLU   209      50.223  51.236  32.148  1.00 93.67           C  
ATOM   1643  C   GLU   209      51.637  51.337  32.713  1.00 93.52           C  
ATOM   1644  O   GLU   209      52.574  51.663  31.979  1.00 93.73           O  
ATOM   1645  CB  GLU   209      49.648  52.640  31.882  1.00 97.33           C  
ATOM   1646  CG  GLU   209      49.114  53.377  33.116  1.00103.77           C  
ATOM   1647  CD  GLU   209      50.198  54.099  33.914  1.00107.89           C  
ATOM   1648  OE1 GLU   209      49.897  54.571  35.041  1.00109.42           O  
ATOM   1649  OE2 GLU   209      51.344  54.207  33.414  1.00109.63           O  
ATOM   1650  N   GLU   210      51.799  51.045  34.003  1.00 92.76           N  
ATOM   1651  CA  GLU   210      53.115  51.126  34.633  1.00 92.10           C  
ATOM   1652  C   GLU   210      54.162  50.242  33.971  1.00 92.41           C  
ATOM   1653  O   GLU   210      53.856  49.189  33.424  1.00 92.97           O  
ATOM   1654  CB  GLU   210      53.019  50.784  36.119  1.00 90.83           C  
ATOM   1655  CG  GLU   210      51.964  49.752  36.447  1.00 89.92           C  
ATOM   1656  CD  GLU   210      50.716  50.370  37.040  1.00 88.65           C  
ATOM   1657  OE1 GLU   210      50.829  51.040  38.088  1.00 88.65           O  
ATOM   1658  OE2 GLU   210      49.624  50.187  36.468  1.00 88.57           O  
ATOM   1659  N   ASP   211      55.407  50.688  34.017  1.00 93.17           N  
ATOM   1660  CA  ASP   211      56.503  49.945  33.425  1.00 94.06           C  
ATOM   1661  C   ASP   211      57.003  48.904  34.410  1.00 93.70           C  
ATOM   1662  O   ASP   211      57.480  49.241  35.489  1.00 94.07           O  
ATOM   1663  CB  ASP   211      57.641  50.895  33.073  1.00 96.52           C  
ATOM   1664  CG  ASP   211      57.981  51.834  34.219  1.00101.13           C  
ATOM   1665  OD1 ASP   211      58.979  52.590  34.113  1.00103.30           O  
ATOM   1666  OD2 ASP   211      57.242  51.818  35.233  1.00102.68           O  
ATOM   1667  N   PRO   212      56.896  47.619  34.055  1.00 93.56           N  
ATOM   1668  CA  PRO   212      57.354  46.539  34.933  1.00 93.11           C  
ATOM   1669  C   PRO   212      58.747  46.823  35.489  1.00 92.62           C  
ATOM   1670  O   PRO   212      59.014  46.663  36.685  1.00 93.34           O  
ATOM   1671  CB  PRO   212      57.335  45.316  34.014  1.00 92.72           C  
ATOM   1672  CG  PRO   212      57.444  45.909  32.631  1.00 93.18           C  
ATOM   1673  CD  PRO   212      56.528  47.086  32.735  1.00 94.11           C  
ATOM   1674  N   LYS   213      59.628  47.245  34.596  1.00 90.79           N  
ATOM   1675  CA  LYS   213      61.001  47.572  34.938  1.00 88.21           C  
ATOM   1676  C   LYS   213      61.120  48.491  36.153  1.00 85.96           C  
ATOM   1677  O   LYS   213      62.079  48.400  36.916  1.00 86.00           O  
ATOM   1678  CB  LYS   213      61.651  48.221  33.718  1.00 89.60           C  
ATOM   1679  CG  LYS   213      60.656  49.042  32.891  1.00 90.43           C  
ATOM   1680  CD  LYS   213      61.122  49.235  31.459  1.00 92.61           C  
ATOM   1681  CE  LYS   213      62.321  50.172  31.368  1.00 93.18           C  
ATOM   1682  NZ  LYS   213      62.789  50.344  29.956  1.00 94.14           N  
ATOM   1683  N   GLU   214      60.135  49.357  36.352  1.00 83.06           N  
ATOM   1684  CA  GLU   214      60.206  50.293  37.456  1.00 80.99           C  
ATOM   1685  C   GLU   214      59.077  50.234  38.479  1.00 78.99           C  
ATOM   1686  O   GLU   214      59.002  51.090  39.357  1.00 79.69           O  
ATOM   1687  CB  GLU   214      60.322  51.714  36.898  1.00 83.18           C  
ATOM   1688  CG  GLU   214      61.496  51.905  35.917  1.00 85.98           C  
ATOM   1689  CD  GLU   214      62.851  52.148  36.603  1.00 88.07           C  
ATOM   1690  OE1 GLU   214      63.899  51.964  35.933  1.00 88.14           O  
ATOM   1691  OE2 GLU   214      62.873  52.537  37.798  1.00 88.28           O  
ATOM   1692  N   LEU   215      58.195  49.245  38.389  1.00 75.56           N  
ATOM   1693  CA  LEU   215      57.118  49.149  39.370  1.00 70.81           C  
ATOM   1694  C   LEU   215      57.721  48.486  40.611  1.00 68.53           C  
ATOM   1695  O   LEU   215      58.277  47.394  40.536  1.00 68.45           O  
ATOM   1696  CB  LEU   215      55.957  48.322  38.816  1.00 69.76           C  
ATOM   1697  CG  LEU   215      54.730  48.203  39.723  1.00 68.23           C  
ATOM   1698  CD1 LEU   215      54.193  49.570  40.043  1.00 70.10           C  
ATOM   1699  CD2 LEU   215      53.673  47.400  39.033  1.00 68.21           C  
ATOM   1700  N   PRO   216      57.629  49.146  41.770  1.00 65.59           N  
ATOM   1701  CA  PRO   216      58.201  48.566  42.985  1.00 64.17           C  
ATOM   1702  C   PRO   216      57.308  47.687  43.856  1.00 63.09           C  
ATOM   1703  O   PRO   216      56.183  48.061  44.191  1.00 62.08           O  
ATOM   1704  CB  PRO   216      58.684  49.797  43.740  1.00 63.84           C  
ATOM   1705  CG  PRO   216      57.575  50.772  43.461  1.00 63.33           C  
ATOM   1706  CD  PRO   216      57.291  50.566  41.974  1.00 63.87           C  
ATOM   1707  N   LEU   217      57.828  46.517  44.224  1.00 61.66           N  
ATOM   1708  CA  LEU   217      57.116  45.601  45.104  1.00 58.98           C  
ATOM   1709  C   LEU   217      57.326  46.160  46.517  1.00 57.95           C  
ATOM   1710  O   LEU   217      58.306  46.866  46.772  1.00 57.13           O  
ATOM   1711  CB  LEU   217      57.681  44.188  44.940  1.00 58.92           C  
ATOM   1712  CG  LEU   217      56.956  43.286  43.917  1.00 59.54           C  
ATOM   1713  CD1 LEU   217      56.270  44.126  42.876  1.00 59.17           C  
ATOM   1714  CD2 LEU   217      57.934  42.316  43.259  1.00 58.01           C  
ATOM   1715  N   PRO   218      56.410  45.869  47.449  1.00 57.53           N  
ATOM   1716  CA  PRO   218      56.488  46.353  48.836  1.00 58.13           C  
ATOM   1717  C   PRO   218      57.834  46.826  49.406  1.00 59.75           C  
ATOM   1718  O   PRO   218      58.011  48.018  49.670  1.00 60.94           O  
ATOM   1719  CB  PRO   218      55.879  45.211  49.621  1.00 57.44           C  
ATOM   1720  CG  PRO   218      54.758  44.819  48.717  1.00 57.10           C  
ATOM   1721  CD  PRO   218      55.382  44.823  47.327  1.00 56.14           C  
ATOM   1722  N   GLY   219      58.785  45.921  49.601  1.00 60.14           N  
ATOM   1723  CA  GLY   219      60.059  46.357  50.154  1.00 59.45           C  
ATOM   1724  C   GLY   219      60.967  47.152  49.225  1.00 59.99           C  
ATOM   1725  O   GLY   219      62.113  47.456  49.593  1.00 60.44           O  
ATOM   1726  N   GLY   220      60.488  47.481  48.023  1.00 58.99           N  
ATOM   1727  CA  GLY   220      61.317  48.225  47.086  1.00 56.82           C  
ATOM   1728  C   GLY   220      61.831  47.485  45.855  1.00 55.36           C  
ATOM   1729  O   GLY   220      62.242  48.116  44.891  1.00 55.91           O  
ATOM   1730  N   LEU   221      61.819  46.159  45.869  1.00 55.10           N  
ATOM   1731  CA  LEU   221      62.285  45.375  44.716  1.00 55.13           C  
ATOM   1732  C   LEU   221      61.377  45.576  43.487  1.00 56.66           C  
ATOM   1733  O   LEU   221      60.147  45.629  43.609  1.00 55.89           O  
ATOM   1734  CB  LEU   221      62.324  43.894  45.104  1.00 52.43           C  
ATOM   1735  CG  LEU   221      62.834  42.780  44.185  1.00 50.13           C  
ATOM   1736  CD1 LEU   221      64.290  42.969  43.829  1.00 46.68           C  
ATOM   1737  CD2 LEU   221      62.650  41.449  44.918  1.00 48.43           C  
ATOM   1738  N   SER   222      61.975  45.692  42.303  1.00 58.20           N  
ATOM   1739  CA  SER   222      61.179  45.880  41.089  1.00 59.40           C  
ATOM   1740  C   SER   222      60.385  44.613  40.804  1.00 59.57           C  
ATOM   1741  O   SER   222      60.803  43.510  41.145  1.00 59.05           O  
ATOM   1742  CB  SER   222      62.063  46.194  39.879  1.00 60.08           C  
ATOM   1743  OG  SER   222      62.747  45.034  39.441  1.00 62.76           O  
ATOM   1744  N   LEU   223      59.232  44.786  40.177  1.00 60.43           N  
ATOM   1745  CA  LEU   223      58.363  43.680  39.845  1.00 60.50           C  
ATOM   1746  C   LEU   223      59.043  42.833  38.789  1.00 60.58           C  
ATOM   1747  O   LEU   223      58.850  41.619  38.727  1.00 60.06           O  
ATOM   1748  CB  LEU   223      57.019  44.227  39.359  1.00 62.23           C  
ATOM   1749  CG  LEU   223      55.925  43.312  38.809  1.00 64.78           C  
ATOM   1750  CD1 LEU   223      56.210  42.956  37.364  1.00 65.62           C  
ATOM   1751  CD2 LEU   223      55.841  42.080  39.642  1.00 65.49           C  
ATOM   1752  N   LEU   224      59.868  43.467  37.970  1.00 61.35           N  
ATOM   1753  CA  LEU   224      60.560  42.717  36.943  1.00 62.83           C  
ATOM   1754  C   LEU   224      61.664  41.895  37.577  1.00 62.41           C  
ATOM   1755  O   LEU   224      61.741  40.701  37.331  1.00 63.75           O  
ATOM   1756  CB  LEU   224      61.148  43.641  35.870  1.00 64.74           C  
ATOM   1757  CG  LEU   224      61.933  42.901  34.771  1.00 65.38           C  
ATOM   1758  CD1 LEU   224      60.998  42.149  33.833  1.00 63.50           C  
ATOM   1759  CD2 LEU   224      62.764  43.902  33.997  1.00 65.92           C  
ATOM   1760  N   ASP   225      62.511  42.516  38.393  1.00 61.75           N  
ATOM   1761  CA  ASP   225      63.603  41.777  39.047  1.00 63.10           C  
ATOM   1762  C   ASP   225      63.111  40.606  39.886  1.00 62.34           C  
ATOM   1763  O   ASP   225      63.825  39.628  40.077  1.00 63.44           O  
ATOM   1764  CB  ASP   225      64.425  42.672  39.977  1.00 65.55           C  
ATOM   1765  CG  ASP   225      65.271  43.676  39.233  1.00 69.26           C  
ATOM   1766  OD1 ASP   225      65.586  43.425  38.043  1.00 69.68           O  
ATOM   1767  OD2 ASP   225      65.631  44.706  39.857  1.00 70.29           O  
ATOM   1768  N   TYR   226      61.901  40.719  40.413  1.00 60.89           N  
ATOM   1769  CA  TYR   226      61.349  39.661  41.228  1.00 59.54           C  
ATOM   1770  C   TYR   226      61.302  38.376  40.404  1.00 60.29           C  
ATOM   1771  O   TYR   226      61.884  37.364  40.792  1.00 61.44           O  
ATOM   1772  CB  TYR   226      59.949  40.053  41.714  1.00 57.13           C  
ATOM   1773  CG  TYR   226      59.221  38.976  42.484  1.00 53.38           C  
ATOM   1774  CD1 TYR   226      59.530  38.703  43.809  1.00 51.58           C  
ATOM   1775  CD2 TYR   226      58.224  38.218  41.875  1.00 53.69           C  
ATOM   1776  CE1 TYR   226      58.862  37.698  44.507  1.00 49.73           C  
ATOM   1777  CE2 TYR   226      57.553  37.205  42.568  1.00 51.40           C  
ATOM   1778  CZ  TYR   226      57.881  36.955  43.876  1.00 49.11           C  
ATOM   1779  OH  TYR   226      57.251  35.937  44.531  1.00 47.84           O  
ATOM   1780  N   HIS   227      60.628  38.410  39.264  1.00 59.93           N  
ATOM   1781  CA  HIS   227      60.544  37.213  38.440  1.00 60.89           C  
ATOM   1782  C   HIS   227      61.894  36.975  37.746  1.00 63.81           C  
ATOM   1783  O   HIS   227      62.439  35.872  37.784  1.00 63.23           O  
ATOM   1784  CB  HIS   227      59.424  37.355  37.399  1.00 57.03           C  
ATOM   1785  CG  HIS   227      58.046  37.517  37.984  1.00 53.56           C  
ATOM   1786  ND1 HIS   227      57.316  36.463  38.493  1.00 52.36           N  
ATOM   1787  CD2 HIS   227      57.253  38.610  38.105  1.00 50.16           C  
ATOM   1788  CE1 HIS   227      56.136  36.898  38.897  1.00 48.37           C  
ATOM   1789  NE2 HIS   227      56.074  38.197  38.673  1.00 47.03           N  
ATOM   1790  N   ALA   228      62.439  38.021  37.134  1.00 67.61           N  
ATOM   1791  CA  ALA   228      63.722  37.933  36.423  1.00 71.57           C  
ATOM   1792  C   ALA   228      64.750  37.137  37.205  1.00 73.71           C  
ATOM   1793  O   ALA   228      65.389  36.230  36.668  1.00 74.28           O  
ATOM   1794  CB  ALA   228      64.274  39.333  36.134  1.00 70.89           C  
ATOM   1795  N   SER   229      64.902  37.483  38.479  1.00 76.15           N  
ATOM   1796  CA  SER   229      65.857  36.813  39.339  1.00 78.54           C  
ATOM   1797  C   SER   229      65.493  35.353  39.536  1.00 79.95           C  
ATOM   1798  O   SER   229      66.373  34.511  39.673  1.00 79.93           O  
ATOM   1799  CB  SER   229      65.932  37.519  40.699  1.00 79.76           C  
ATOM   1800  OG  SER   229      66.833  36.857  41.583  1.00 81.85           O  
ATOM   1801  N   LYS   230      64.199  35.048  39.548  1.00 82.19           N  
ATOM   1802  CA  LYS   230      63.756  33.670  39.743  1.00 84.10           C  
ATOM   1803  C   LYS   230      63.860  32.858  38.451  1.00 84.00           C  
ATOM   1804  O   LYS   230      63.264  31.787  38.322  1.00 83.71           O  
ATOM   1805  CB  LYS   230      62.319  33.637  40.290  1.00 85.98           C  
ATOM   1806  CG  LYS   230      62.157  34.242  41.697  1.00 89.07           C  
ATOM   1807  CD  LYS   230      63.028  33.528  42.739  1.00 91.74           C  
ATOM   1808  CE  LYS   230      62.970  34.220  44.110  1.00 93.04           C  
ATOM   1809  NZ  LYS   230      61.574  34.324  44.630  1.00 92.19           N  
ATOM   1810  N   GLY   231      64.628  33.386  37.502  1.00 83.88           N  
ATOM   1811  CA  GLY   231      64.835  32.715  36.233  1.00 85.07           C  
ATOM   1812  C   GLY   231      63.578  32.378  35.461  1.00 86.24           C  
ATOM   1813  O   GLY   231      63.610  31.550  34.546  1.00 87.35           O  
ATOM   1814  N   ARG   232      62.470  33.017  35.824  1.00 85.71           N  
ATOM   1815  CA  ARG   232      61.186  32.789  35.166  1.00 83.70           C  
ATOM   1816  C   ARG   232      61.158  33.593  33.898  1.00 85.17           C  
ATOM   1817  O   ARG   232      60.272  33.431  33.064  1.00 85.53           O  
ATOM   1818  CB  ARG   232      60.043  33.260  36.054  1.00 79.09           C  
ATOM   1819  CG  ARG   232      59.853  32.463  37.310  1.00 73.26           C  
ATOM   1820  CD  ARG   232      58.927  33.203  38.220  1.00 69.66           C  
ATOM   1821  NE  ARG   232      58.598  32.445  39.413  1.00 65.96           N  
ATOM   1822  CZ  ARG   232      57.974  32.968  40.458  1.00 65.19           C  
ATOM   1823  NH1 ARG   232      57.629  34.248  40.437  1.00 63.79           N  
ATOM   1824  NH2 ARG   232      57.688  32.216  41.513  1.00 64.60           N  
ATOM   1825  N   LEU   233      62.133  34.475  33.762  1.00 88.01           N  
ATOM   1826  CA  LEU   233      62.197  35.324  32.593  1.00 92.02           C  
ATOM   1827  C   LEU   233      62.992  34.656  31.482  1.00 94.37           C  
ATOM   1828  O   LEU   233      62.755  34.912  30.302  1.00 95.25           O  
ATOM   1829  CB  LEU   233      62.832  36.662  32.955  1.00 92.16           C  
ATOM   1830  CG  LEU   233      62.117  37.871  32.364  1.00 91.40           C  
ATOM   1831  CD1 LEU   233      60.835  38.131  33.136  1.00 90.38           C  
ATOM   1832  CD2 LEU   233      63.034  39.083  32.440  1.00 92.79           C  
ATOM   1833  N   GLN   234      63.933  33.796  31.857  1.00 97.19           N  
ATOM   1834  CA  GLN   234      64.749  33.108  30.862  1.00 99.93           C  
ATOM   1835  C   GLN   234      63.873  32.497  29.764  1.00101.35           C  
ATOM   1836  O   GLN   234      63.060  31.602  30.020  1.00102.29           O  
ATOM   1837  CB  GLN   234      65.598  32.025  31.530  1.00 98.68           C  
ATOM   1838  N   GLY   235      64.028  32.998  28.542  1.00101.54           N  
ATOM   1839  CA  GLY   235      63.252  32.472  27.430  1.00102.08           C  
ATOM   1840  C   GLY   235      61.855  33.048  27.268  1.00101.94           C  
ATOM   1841  O   GLY   235      60.982  32.403  26.681  1.00102.78           O  
ATOM   1842  N   ARG   236      61.632  34.258  27.765  1.00101.38           N  
ATOM   1843  CA  ARG   236      60.315  34.858  27.636  1.00 99.91           C  
ATOM   1844  C   ARG   236      60.363  36.370  27.416  1.00 98.87           C  
ATOM   1845  O   ARG   236      61.420  36.955  27.213  1.00 99.44           O  
ATOM   1846  CB  ARG   236      59.478  34.542  28.875  1.00 99.41           C  
ATOM   1847  N   GLU   237      59.185  36.974  27.444  1.00 97.86           N  
ATOM   1848  CA  GLU   237      59.022  38.410  27.289  1.00 96.78           C  
ATOM   1849  C   GLU   237      58.101  38.800  28.430  1.00 94.77           C  
ATOM   1850  O   GLU   237      57.024  38.224  28.581  1.00 94.97           O  
ATOM   1851  CB  GLU   237      58.349  38.751  25.959  1.00100.13           C  
ATOM   1852  CG  GLU   237      57.799  40.185  25.869  1.00102.17           C  
ATOM   1853  CD  GLU   237      56.387  40.238  25.296  1.00103.44           C  
ATOM   1854  OE1 GLU   237      56.036  39.337  24.505  1.00104.23           O  
ATOM   1855  OE2 GLU   237      55.633  41.182  25.627  1.00104.30           O  
ATOM   1856  N   GLY   238      58.525  39.772  29.229  1.00 91.48           N  
ATOM   1857  CA  GLY   238      57.721  40.217  30.350  1.00 87.77           C  
ATOM   1858  C   GLY   238      56.381  40.782  29.942  1.00 85.92           C  
ATOM   1859  O   GLY   238      55.385  40.574  30.627  1.00 85.39           O  
ATOM   1860  N   GLY   239      56.352  41.501  28.826  1.00 85.46           N  
ATOM   1861  CA  GLY   239      55.109  42.084  28.358  1.00 83.22           C  
ATOM   1862  C   GLY   239      54.712  43.275  29.196  1.00 82.47           C  
ATOM   1863  O   GLY   239      55.572  44.015  29.662  1.00 83.12           O  
ATOM   1864  N   ARG   240      53.410  43.452  29.391  1.00 82.23           N  
ATOM   1865  CA  ARG   240      52.865  44.560  30.173  1.00 82.73           C  
ATOM   1866  C   ARG   240      52.442  44.111  31.578  1.00 80.66           C  
ATOM   1867  O   ARG   240      52.334  42.918  31.851  1.00 81.00           O  
ATOM   1868  CB  ARG   240      51.655  45.146  29.437  1.00 87.53           C  
ATOM   1869  CG  ARG   240      51.031  46.391  30.075  1.00 95.10           C  
ATOM   1870  CD  ARG   240      51.879  47.672  29.882  1.00101.20           C  
ATOM   1871  NE  ARG   240      52.015  48.069  28.474  1.00104.62           N  
ATOM   1872  CZ  ARG   240      52.974  47.638  27.656  1.00106.63           C  
ATOM   1873  NH1 ARG   240      53.906  46.789  28.093  1.00107.58           N  
ATOM   1874  NH2 ARG   240      53.000  48.054  26.395  1.00106.50           N  
ATOM   1875  N   VAL   241      52.192  45.076  32.460  1.00 77.97           N  
ATOM   1876  CA  VAL   241      51.776  44.801  33.838  1.00 75.15           C  
ATOM   1877  C   VAL   241      50.311  44.411  33.946  1.00 74.21           C  
ATOM   1878  O   VAL   241      49.442  45.083  33.403  1.00 74.40           O  
ATOM   1879  CB  VAL   241      51.979  46.026  34.752  1.00 73.81           C  
ATOM   1880  CG1 VAL   241      51.329  45.773  36.094  1.00 72.30           C  
ATOM   1881  CG2 VAL   241      53.459  46.319  34.920  1.00 72.84           C  
ATOM   1882  N   ALA   242      50.038  43.344  34.685  1.00 73.49           N  
ATOM   1883  CA  ALA   242      48.668  42.872  34.856  1.00 72.06           C  
ATOM   1884  C   ALA   242      48.230  42.823  36.311  1.00 70.74           C  
ATOM   1885  O   ALA   242      48.684  41.986  37.068  1.00 71.78           O  
ATOM   1886  CB  ALA   242      48.518  41.495  34.231  1.00 72.17           C  
ATOM   1887  N   TRP   243      47.339  43.720  36.699  1.00 69.56           N  
ATOM   1888  CA  TRP   243      46.847  43.726  38.059  1.00 69.29           C  
ATOM   1889  C   TRP   243      45.968  42.512  38.220  1.00 68.40           C  
ATOM   1890  O   TRP   243      45.011  42.313  37.479  1.00 69.02           O  
ATOM   1891  CB  TRP   243      46.095  45.026  38.353  1.00 70.42           C  
ATOM   1892  CG  TRP   243      47.051  46.180  38.314  1.00 72.51           C  
ATOM   1893  CD1 TRP   243      47.309  47.003  37.248  1.00 72.80           C  
ATOM   1894  CD2 TRP   243      48.013  46.521  39.322  1.00 71.94           C  
ATOM   1895  NE1 TRP   243      48.376  47.823  37.530  1.00 72.94           N  
ATOM   1896  CE2 TRP   243      48.828  47.548  38.794  1.00 72.39           C  
ATOM   1897  CE3 TRP   243      48.268  46.052  40.615  1.00 71.00           C  
ATOM   1898  CZ2 TRP   243      49.885  48.116  39.517  1.00 72.37           C  
ATOM   1899  CZ3 TRP   243      49.318  46.618  41.333  1.00 72.44           C  
ATOM   1900  CH2 TRP   243      50.114  47.639  40.780  1.00 71.49           C  
ATOM   1901  N   VAL   244      46.318  41.704  39.206  1.00 67.98           N  
ATOM   1902  CA  VAL   244      45.651  40.450  39.487  1.00 68.63           C  
ATOM   1903  C   VAL   244      45.117  40.368  40.925  1.00 70.31           C  
ATOM   1904  O   VAL   244      45.485  41.172  41.780  1.00 70.28           O  
ATOM   1905  CB  VAL   244      46.669  39.324  39.179  1.00 67.10           C  
ATOM   1906  CG1 VAL   244      46.644  38.261  40.224  1.00 66.99           C  
ATOM   1907  CG2 VAL   244      46.400  38.759  37.816  1.00 65.37           C  
ATOM   1908  N   ALA   245      44.234  39.409  41.182  1.00 73.54           N  
ATOM   1909  CA  ALA   245      43.662  39.217  42.518  1.00 77.50           C  
ATOM   1910  C   ALA   245      43.900  37.775  42.973  1.00 80.10           C  
ATOM   1911  O   ALA   245      44.182  36.911  42.152  1.00 79.89           O  
ATOM   1912  CB  ALA   245      42.182  39.536  42.501  1.00 78.23           C  
ATOM   1913  N   ASP   246      43.741  37.504  44.266  1.00 84.91           N  
ATOM   1914  CA  ASP   246      44.034  36.180  44.786  1.00 91.11           C  
ATOM   1915  C   ASP   246      43.553  34.803  44.228  1.00 95.61           C  
ATOM   1916  O   ASP   246      44.370  34.029  43.736  1.00 97.23           O  
ATOM   1917  CB  ASP   246      43.799  36.129  46.303  1.00 89.52           C  
ATOM   1918  CG  ASP   246      44.490  34.941  46.945  1.00 89.61           C  
ATOM   1919  OD1 ASP   246      45.611  35.108  47.470  1.00 89.47           O  
ATOM   1920  OD2 ASP   246      43.923  33.829  46.896  1.00 89.35           O  
ATOM   1921  N   PRO   247      42.209  34.521  44.177  1.00 99.10           N  
ATOM   1922  CA  PRO   247      41.025  35.241  44.689  1.00101.63           C  
ATOM   1923  C   PRO   247      40.502  35.029  46.109  1.00102.89           C  
ATOM   1924  O   PRO   247      39.342  35.362  46.374  1.00104.01           O  
ATOM   1925  CB  PRO   247      39.978  34.787  43.675  1.00102.35           C  
ATOM   1926  CG  PRO   247      40.295  33.299  43.597  1.00101.05           C  
ATOM   1927  CD  PRO   247      41.818  33.287  43.484  1.00 99.68           C  
ATOM   1928  N   LYS   248      41.297  34.472  47.023  1.00104.59           N  
ATOM   1929  CA  LYS   248      40.804  34.299  48.395  1.00105.61           C  
ATOM   1930  C   LYS   248      40.737  35.689  49.049  1.00107.03           C  
ATOM   1931  O   LYS   248      40.015  35.908  50.026  1.00108.10           O  
ATOM   1932  CB  LYS   248      41.721  33.360  49.190  1.00104.00           C  
ATOM   1933  N   ASP   249      41.509  36.611  48.488  1.00107.31           N  
ATOM   1934  CA  ASP   249      41.545  38.012  48.916  1.00108.27           C  
ATOM   1935  C   ASP   249      41.176  38.757  47.634  1.00108.48           C  
ATOM   1936  O   ASP   249      42.017  39.403  47.008  1.00108.32           O  
ATOM   1937  CB  ASP   249      42.951  38.411  49.368  1.00109.73           C  
ATOM   1938  CG  ASP   249      43.093  38.453  50.881  1.00110.13           C  
ATOM   1939  OD1 ASP   249      44.167  38.872  51.364  1.00110.14           O  
ATOM   1940  OD2 ASP   249      42.137  38.070  51.586  1.00110.53           O  
ATOM   1941  N   PRO   250      39.901  38.668  47.225  1.00108.38           N  
ATOM   1942  CA  PRO   250      39.383  39.305  46.008  1.00108.07           C  
ATOM   1943  C   PRO   250      39.455  40.825  45.962  1.00107.62           C  
ATOM   1944  O   PRO   250      39.369  41.427  44.887  1.00108.06           O  
ATOM   1945  CB  PRO   250      37.944  38.807  45.956  1.00108.28           C  
ATOM   1946  CG  PRO   250      37.578  38.773  47.411  1.00108.01           C  
ATOM   1947  CD  PRO   250      38.795  38.123  48.037  1.00108.15           C  
ATOM   1948  N   ARG   251      39.624  41.439  47.127  1.00105.75           N  
ATOM   1949  CA  ARG   251      39.656  42.888  47.222  1.00103.19           C  
ATOM   1950  C   ARG   251      41.023  43.537  47.101  1.00100.58           C  
ATOM   1951  O   ARG   251      41.111  44.739  46.855  1.00100.45           O  
ATOM   1952  CB  ARG   251      39.020  43.317  48.540  1.00105.18           C  
ATOM   1953  CG  ARG   251      37.641  42.738  48.769  1.00106.09           C  
ATOM   1954  CD  ARG   251      36.659  43.834  49.107  1.00107.90           C  
ATOM   1955  NE  ARG   251      35.353  43.286  49.448  1.00110.15           N  
ATOM   1956  CZ  ARG   251      34.303  44.019  49.808  1.00110.84           C  
ATOM   1957  NH1 ARG   251      34.399  45.341  49.874  1.00110.87           N  
ATOM   1958  NH2 ARG   251      33.156  43.426  50.115  1.00111.15           N  
ATOM   1959  N   LYS   252      42.088  42.760  47.278  1.00 96.86           N  
ATOM   1960  CA  LYS   252      43.434  43.330  47.198  1.00 92.57           C  
ATOM   1961  C   LYS   252      44.222  42.903  45.971  1.00 86.47           C  
ATOM   1962  O   LYS   252      44.592  41.735  45.825  1.00 86.47           O  
ATOM   1963  CB  LYS   252      44.239  42.987  48.451  1.00 95.18           C  
ATOM   1964  CG  LYS   252      45.584  43.698  48.525  1.00 97.46           C  
ATOM   1965  CD  LYS   252      46.376  43.229  49.729  1.00101.35           C  
ATOM   1966  CE  LYS   252      46.871  41.801  49.534  1.00103.67           C  
ATOM   1967  NZ  LYS   252      45.775  40.831  49.223  1.00105.43           N  
ATOM   1968  N   PRO   253      44.501  43.862  45.080  1.00 80.97           N  
ATOM   1969  CA  PRO   253      45.245  43.670  43.833  1.00 76.84           C  
ATOM   1970  C   PRO   253      46.757  43.515  44.020  1.00 72.54           C  
ATOM   1971  O   PRO   253      47.378  44.239  44.802  1.00 71.39           O  
ATOM   1972  CB  PRO   253      44.901  44.929  43.045  1.00 76.95           C  
ATOM   1973  CG  PRO   253      44.826  45.960  44.125  1.00 77.70           C  
ATOM   1974  CD  PRO   253      44.011  45.249  45.183  1.00 79.13           C  
ATOM   1975  N   ILE   254      47.343  42.562  43.304  1.00 66.91           N  
ATOM   1976  CA  ILE   254      48.777  42.367  43.375  1.00 61.43           C  
ATOM   1977  C   ILE   254      49.269  42.508  41.954  1.00 58.54           C  
ATOM   1978  O   ILE   254      48.566  42.180  41.011  1.00 56.58           O  
ATOM   1979  CB  ILE   254      49.166  40.978  43.946  1.00 61.07           C  
ATOM   1980  CG1 ILE   254      49.621  40.062  42.826  1.00 60.73           C  
ATOM   1981  CG2 ILE   254      47.990  40.355  44.709  1.00 59.15           C  
ATOM   1982  CD1 ILE   254      50.156  38.762  43.329  1.00 63.47           C  
ATOM   1983  N   PRO   255      50.493  42.996  41.772  1.00 56.44           N  
ATOM   1984  CA  PRO   255      50.894  43.113  40.379  1.00 55.05           C  
ATOM   1985  C   PRO   255      51.501  41.860  39.788  1.00 53.92           C  
ATOM   1986  O   PRO   255      52.014  40.989  40.496  1.00 52.18           O  
ATOM   1987  CB  PRO   255      51.849  44.309  40.389  1.00 55.63           C  
ATOM   1988  CG  PRO   255      52.358  44.397  41.805  1.00 54.87           C  
ATOM   1989  CD  PRO   255      51.530  43.492  42.685  1.00 55.03           C  
ATOM   1990  N   HIS   256      51.419  41.786  38.468  1.00 52.62           N  
ATOM   1991  CA  HIS   256      51.942  40.659  37.731  1.00 52.33           C  
ATOM   1992  C   HIS   256      52.236  41.094  36.307  1.00 52.34           C  
ATOM   1993  O   HIS   256      52.075  42.245  35.938  1.00 53.29           O  
ATOM   1994  CB  HIS   256      50.957  39.504  37.754  1.00 50.07           C  
ATOM   1995  CG  HIS   256      51.606  38.159  37.677  1.00 49.66           C  
ATOM   1996  ND1 HIS   256      51.227  37.116  38.491  1.00 49.27           N  
ATOM   1997  CD2 HIS   256      52.599  37.678  36.888  1.00 49.16           C  
ATOM   1998  CE1 HIS   256      51.957  36.050  38.210  1.00 50.08           C  
ATOM   1999  NE2 HIS   256      52.797  36.364  37.238  1.00 49.02           N  
ATOM   2000  N   LEU   257      52.584  40.139  35.487  1.00 53.39           N  
ATOM   2001  CA  LEU   257      53.028  40.397  34.159  1.00 57.25           C  
ATOM   2002  C   LEU   257      52.472  39.530  33.080  1.00 59.33           C  
ATOM   2003  O   LEU   257      52.679  38.328  33.142  1.00 59.19           O  
ATOM   2004  CB  LEU   257      54.464  40.068  34.093  1.00 58.52           C  
ATOM   2005  CG  LEU   257      55.325  40.949  34.924  1.00 60.98           C  
ATOM   2006  CD1 LEU   257      56.699  40.450  34.716  1.00 57.94           C  
ATOM   2007  CD2 LEU   257      55.241  42.329  34.351  1.00 58.77           C  
ATOM   2008  N   THR   258      51.890  40.111  32.039  1.00 60.58           N  
ATOM   2009  CA  THR   258      51.320  39.300  30.955  1.00 61.79           C  
ATOM   2010  C   THR   258      52.248  38.232  30.323  1.00 61.26           C  
ATOM   2011  O   THR   258      51.813  37.128  29.960  1.00 60.52           O  
ATOM   2012  CB  THR   258      50.808  40.171  29.840  1.00 61.37           C  
ATOM   2013  OG1 THR   258      51.913  40.842  29.238  1.00 62.19           O  
ATOM   2014  CG2 THR   258      49.854  41.202  30.400  1.00 61.30           C  
ATOM   2015  N   GLY   259      53.518  38.565  30.149  1.00 60.95           N  
ATOM   2016  CA  GLY   259      54.425  37.605  29.564  1.00 60.64           C  
ATOM   2017  C   GLY   259      54.480  36.333  30.375  1.00 60.95           C  
ATOM   2018  O   GLY   259      54.717  35.267  29.830  1.00 61.41           O  
ATOM   2019  N   LEU   260      54.246  36.433  31.680  1.00 62.35           N  
ATOM   2020  CA  LEU   260      54.310  35.265  32.549  1.00 62.18           C  
ATOM   2021  C   LEU   260      52.969  34.671  32.929  1.00 61.39           C  
ATOM   2022  O   LEU   260      52.893  33.875  33.877  1.00 61.82           O  
ATOM   2023  CB  LEU   260      55.072  35.606  33.822  1.00 65.44           C  
ATOM   2024  CG  LEU   260      56.521  36.068  33.650  1.00 67.85           C  
ATOM   2025  CD1 LEU   260      57.054  36.588  34.987  1.00 67.43           C  
ATOM   2026  CD2 LEU   260      57.366  34.902  33.123  1.00 68.59           C  
ATOM   2027  N   LEU   261      51.921  35.034  32.195  1.00 58.54           N  
ATOM   2028  CA  LEU   261      50.586  34.520  32.479  1.00 57.94           C  
ATOM   2029  C   LEU   261      49.949  33.772  31.297  1.00 58.83           C  
ATOM   2030  O   LEU   261      50.301  33.991  30.127  1.00 59.31           O  
ATOM   2031  CB  LEU   261      49.673  35.669  32.931  1.00 55.50           C  
ATOM   2032  CG  LEU   261      50.062  36.391  34.231  1.00 54.35           C  
ATOM   2033  CD1 LEU   261      49.209  37.635  34.407  1.00 51.98           C  
ATOM   2034  CD2 LEU   261      49.887  35.446  35.428  1.00 51.89           C  
ATOM   2035  N   VAL   262      49.011  32.886  31.614  1.00 57.57           N  
ATOM   2036  CA  VAL   262      48.325  32.102  30.601  1.00 58.59           C  
ATOM   2037  C   VAL   262      46.838  32.221  30.902  1.00 58.98           C  
ATOM   2038  O   VAL   262      46.377  31.788  31.954  1.00 59.19           O  
ATOM   2039  CB  VAL   262      48.794  30.609  30.658  1.00 59.44           C  
ATOM   2040  CG1 VAL   262      48.057  29.754  29.607  1.00 57.60           C  
ATOM   2041  CG2 VAL   262      50.300  30.543  30.424  1.00 57.04           C  
ATOM   2042  N   PRO   263      46.061  32.823  29.986  1.00 59.23           N  
ATOM   2043  CA  PRO   263      44.625  32.959  30.254  1.00 60.04           C  
ATOM   2044  C   PRO   263      43.937  31.633  30.485  1.00 59.35           C  
ATOM   2045  O   PRO   263      44.226  30.658  29.813  1.00 57.78           O  
ATOM   2046  CB  PRO   263      44.102  33.676  29.010  1.00 58.23           C  
ATOM   2047  CG  PRO   263      44.988  33.154  27.956  1.00 59.23           C  
ATOM   2048  CD  PRO   263      46.365  33.206  28.599  1.00 59.04           C  
ATOM   2049  N   VAL   264      43.041  31.605  31.463  1.00 61.05           N  
ATOM   2050  CA  VAL   264      42.285  30.395  31.765  1.00 64.21           C  
ATOM   2051  C   VAL   264      41.010  30.540  30.933  1.00 66.60           C  
ATOM   2052  O   VAL   264      40.094  31.287  31.296  1.00 66.66           O  
ATOM   2053  CB  VAL   264      41.982  30.289  33.301  1.00 62.79           C  
ATOM   2054  CG1 VAL   264      41.001  29.171  33.586  1.00 59.66           C  
ATOM   2055  CG2 VAL   264      43.281  30.021  34.055  1.00 60.54           C  
ATOM   2056  N   LEU   265      40.973  29.837  29.802  1.00 69.38           N  
ATOM   2057  CA  LEU   265      39.838  29.937  28.892  1.00 72.80           C  
ATOM   2058  C   LEU   265      38.579  29.196  29.315  1.00 75.02           C  
ATOM   2059  O   LEU   265      38.618  28.118  29.914  1.00 73.83           O  
ATOM   2060  CB  LEU   265      40.229  29.498  27.479  1.00 72.18           C  
ATOM   2061  CG  LEU   265      41.657  29.735  27.015  1.00 71.44           C  
ATOM   2062  CD1 LEU   265      42.550  28.748  27.751  1.00 74.08           C  
ATOM   2063  CD2 LEU   265      41.775  29.505  25.518  1.00 71.15           C  
END
