
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   77 ( 1093),  selected   77 , name 2enm_A
# Molecule2: number of CA atoms   88 (  675),  selected   88 , name T0487_178_265.pdb
# PARAMETERS: 2enm_A.T0487_178_265.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      S     178           -
LGA    S     2_A      L     179           -
LGA    S     3_A      E     180           -
LGA    G     4_A      A     181           -
LGA    S     5_A      W     182           -
LGA    -       -      L     183           -
LGA    -       -      A     184           -
LGA    -       -      Q     185           -
LGA    -       -      G     186           -
LGA    -       -      H     187           -
LGA    S     6_A      P     188           #
LGA    G     7_A      L     189           -
LGA    M     8_A      -       -           -
LGA    A     9_A      P     190          5.476
LGA    T    10_A      K     191          1.811
LGA    K    11_A      R     192          1.581
LGA    A    12_A      V     193          1.190
LGA    R    13_A      R     194          1.386
LGA    V    14_A      N     195          0.789
LGA    M    15_A      A     196          1.019
LGA    Y    16_A      Y     197          1.229
LGA    D    17_A      -       -           -
LGA    F    18_A      -       -           -
LGA    A    19_A      -       -           -
LGA    A    20_A      -       -           -
LGA    E    21_A      -       -           -
LGA    P    22_A      -       -           -
LGA    G    23_A      -       -           -
LGA    N    24_A      -       -           -
LGA    N    25_A      -       -           -
LGA    E    26_A      -       -           -
LGA    L    27_A      -       -           -
LGA    T    28_A      -       -           -
LGA    V    29_A      -       -           -
LGA    T    30_A      -       -           -
LGA    E    31_A      D     198          1.054
LGA    G    32_A      R     199          0.626
LGA    E    33_A      R     200          1.193
LGA    I    34_A      T     201          0.994
LGA    I    35_A      W     202          0.673
LGA    T    36_A      E     203          0.375
LGA    V    37_A      L     204          0.266
LGA    T    38_A      L     205          0.307
LGA    N    39_A      R     206          1.318
LGA    P    40_A      L     207          2.510
LGA    N    41_A      G     208          3.760
LGA    V    42_A      E     209          3.645
LGA    G    43_A      E     210          3.634
LGA    G    44_A      D     211          3.863
LGA    -       -      P     212           -
LGA    -       -      K     213           -
LGA    -       -      E     214           -
LGA    -       -      L     215           -
LGA    -       -      P     216           -
LGA    -       -      L     217           -
LGA    -       -      P     218           -
LGA    -       -      G     219           -
LGA    -       -      G     220           -
LGA    -       -      L     221           -
LGA    -       -      S     222           -
LGA    -       -      L     223           -
LGA    -       -      L     224           -
LGA    -       -      D     225           -
LGA    -       -      Y     226           -
LGA    -       -      H     227           -
LGA    -       -      A     228           -
LGA    -       -      S     229           -
LGA    -       -      K     230           -
LGA    -       -      G     231           -
LGA    -       -      R     232           -
LGA    -       -      L     233           -
LGA    -       -      Q     234           -
LGA    -       -      G     235           -
LGA    -       -      R     236           -
LGA    -       -      E     237           -
LGA    -       -      G     238           -
LGA    -       -      G     239           -
LGA    G    45_A      R     240          0.620
LGA    W    46_A      V     241          0.711
LGA    L    47_A      A     242          0.333
LGA    E    48_A      W     243          0.530
LGA    G    49_A      V     244          0.673
LGA    K    50_A      A     245          0.708
LGA    N    51_A      D     246          0.646
LGA    N    52_A      P     247          2.907
LGA    K    53_A      K     248          3.372
LGA    G    54_A      D     249          1.670
LGA    -       -      P     250           -
LGA    -       -      R     251           -
LGA    E    55_A      K     252          2.531
LGA    Q    56_A      P     253          1.375
LGA    G    57_A      I     254          0.640
LGA    L    58_A      P     255          0.460
LGA    V    59_A      H     256          0.606
LGA    P    60_A      L     257          1.741
LGA    T    61_A      T     258          1.636
LGA    D    62_A      G     259          1.934
LGA    Y    63_A      L     260          1.673
LGA    V    64_A      L     261          1.212
LGA    E    65_A      V     262          2.314
LGA    I    66_A      P     263          2.556
LGA    L    67_A      V     264          3.781
LGA    P    68_A      L     265          4.192
LGA    N    69_A      -       -           -
LGA    D    70_A      -       -           -
LGA    G    71_A      -       -           -
LGA    K    72_A      -       -           -
LGA    D    73_A      -       -           -
LGA    P    74_A      -       -           -
LGA    F    75_A      -       -           -
LGA    S    76_A      -       -           -
LGA    C    77_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   77   88    5.0     46    2.10     8.70     47.396     2.092

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.390922 * X  +  -0.916635 * Y  +  -0.083433 * Z  +  49.788227
  Y_new =  -0.247787 * X  +   0.192106 * Y  +  -0.949577 * Z  +  34.056053
  Z_new =   0.886443 * X  +  -0.350537 * Y  +  -0.302228 * Z  +  36.898918 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.282323    0.859270  [ DEG:  -130.7675     49.2325 ]
  Theta =  -1.089603   -2.051989  [ DEG:   -62.4297   -117.5703 ]
  Phi   =  -2.576653    0.564940  [ DEG:  -147.6313     32.3687 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2enm_A                                        
REMARK     2: T0487_178_265.pdb                             
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2enm_A.T0487_178_265.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   77   88   5.0   46   2.10    8.70  47.396
REMARK  ---------------------------------------------------------- 
MOLECULE 2enm_A
HEADER    ENDOCYTOSIS                             28-MAR-07   2ENM              
TITLE     SOLUTION STRUCTURE OF THE SH3 DOMAIN FROM MOUSE SORTING               
TITLE    2 NEXIN-9                                                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SORTING NEXIN-9;                                           
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: SH3 DOMAIN;                                                
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MUS MUSCULUS;                                   
SOURCE   3 ORGANISM_COMMON: MOUSE;                                              
SOURCE   4 GENE: SNX9;                                                          
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P060130-11;                               
SOURCE   7 OTHER_DETAILS: CELL FREE PROTEIN SYNTHESIS                           
KEYWDS    SH3-LIKE BARREL, PROTEIN TRANSPORT, STRUCTURAL GENOMICS,              
KEYWDS   2 NPPSFA, NATIONAL PROJECT ON PROTEIN STRUCTURAL AND                   
KEYWDS   3 FUNCTIONAL ANALYSES, RIKEN STRUCTURAL GENOMICS/PROTEOMICS            
KEYWDS   4 INITIATIVE, RSGI, ENDOCYTOSIS                                        
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    M.WAKABAYASHI,C.KUROSAKI,M.YOSHIDA,F.HAYASHI,S.YOKOYAMA,              
AUTHOR   2 RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)               
REVDAT   1   02-OCT-07 2ENM    0                                                
JRNL        AUTH   M.WAKABAYASHI,C.KUROSAKI,M.YOSHIDA,F.HAYASHI,                
JRNL        AUTH 2 S.YOKOYAMA                                                   
JRNL        TITL   SOLUTION STRUCTURE OF THE SH3 DOMAIN FROM MOUSE              
JRNL        TITL 2 SORTING NEXIN-9                                              
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2ENM A    8    77  UNP    Q91VH2   SNX9_MOUSE       1     70             
SEQRES   1 A   77  GLY SER SER GLY SER SER GLY MET ALA THR LYS ALA ARG          
SEQRES   2 A   77  VAL MET TYR ASP PHE ALA ALA GLU PRO GLY ASN ASN GLU          
SEQRES   3 A   77  LEU THR VAL THR GLU GLY GLU ILE ILE THR VAL THR ASN          
SEQRES   4 A   77  PRO ASN VAL GLY GLY GLY TRP LEU GLU GLY LYS ASN ASN          
SEQRES   5 A   77  LYS GLY GLU GLN GLY LEU VAL PRO THR ASP TYR VAL GLU          
SEQRES   6 A   77  ILE LEU PRO ASN ASP GLY LYS ASP PRO PHE SER CYS              
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      18.987  35.589  27.987  1.00  0.00           N  
ATOM      2  CA  GLY A   1      19.363  34.742  29.105  1.00  0.00           C  
ATOM      3  C   GLY A   1      20.706  35.122  29.694  1.00  0.00           C  
ATOM      4  O   GLY A   1      20.829  35.316  30.903  1.00  0.00           O  
ATOM      5  H1  GLY A   1      19.124  35.274  27.069  1.00  0.00           H  
ATOM      6  HA2 GLY A   1      18.608  34.823  29.873  1.00  0.00           H  
ATOM      7  HA3 GLY A   1      19.409  33.718  28.765  1.00  0.00           H  
ATOM      8  N   SER A   2      21.718  35.227  28.837  1.00  0.00           N  
ATOM      9  CA  SER A   2      23.061  35.581  29.282  1.00  0.00           C  
ATOM     10  C   SER A   2      23.434  36.985  28.817  1.00  0.00           C  
ATOM     11  O   SER A   2      22.679  37.633  28.091  1.00  0.00           O  
ATOM     12  CB  SER A   2      24.079  34.569  28.753  1.00  0.00           C  
ATOM     13  OG  SER A   2      24.082  34.541  27.336  1.00  0.00           O  
ATOM     14  H   SER A   2      21.557  35.060  27.885  1.00  0.00           H  
ATOM     15  HA  SER A   2      23.070  35.558  30.361  1.00  0.00           H  
ATOM     16  HB2 SER A   2      25.066  34.840  29.097  1.00  0.00           H  
ATOM     17  HB3 SER A   2      23.828  33.584  29.120  1.00  0.00           H  
ATOM     18  HG  SER A   2      24.166  35.435  26.998  1.00  0.00           H  
ATOM     19  N   SER A   3      24.606  37.449  29.239  1.00  0.00           N  
ATOM     20  CA  SER A   3      25.080  38.778  28.869  1.00  0.00           C  
ATOM     21  C   SER A   3      26.571  38.753  28.546  1.00  0.00           C  
ATOM     22  O   SER A   3      27.386  38.316  29.357  1.00  0.00           O  
ATOM     23  CB  SER A   3      24.808  39.773  30.000  1.00  0.00           C  
ATOM     24  OG  SER A   3      23.424  39.842  30.297  1.00  0.00           O  
ATOM     25  H   SER A   3      25.164  36.885  29.814  1.00  0.00           H  
ATOM     26  HA  SER A   3      24.538  39.091  27.989  1.00  0.00           H  
ATOM     27  HB2 SER A   3      25.339  39.460  30.886  1.00  0.00           H  
ATOM     28  HB3 SER A   3      25.150  40.753  29.703  1.00  0.00           H  
ATOM     29  HG  SER A   3      23.218  40.703  30.666  1.00  0.00           H  
ATOM     30  N   GLY A   4      26.919  39.227  27.353  1.00  0.00           N  
ATOM     31  CA  GLY A   4      28.311  39.250  26.942  1.00  0.00           C  
ATOM     32  C   GLY A   4      28.717  37.993  26.198  1.00  0.00           C  
ATOM     33  O   GLY A   4      28.378  36.884  26.610  1.00  0.00           O  
ATOM     34  H   GLY A   4      26.226  39.563  26.748  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      28.472  40.103  26.301  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      28.932  39.350  27.821  1.00  0.00           H  
ATOM     37  N   SER A   5      29.443  38.167  25.098  1.00  0.00           N  
ATOM     38  CA  SER A   5      29.891  37.038  24.292  1.00  0.00           C  
ATOM     39  C   SER A   5      31.166  36.429  24.869  1.00  0.00           C  
ATOM     40  O   SER A   5      31.198  35.251  25.224  1.00  0.00           O  
ATOM     41  CB  SER A   5      30.132  37.480  22.847  1.00  0.00           C  
ATOM     42  OG  SER A   5      30.674  36.423  22.074  1.00  0.00           O  
ATOM     43  H   SER A   5      29.682  39.077  24.823  1.00  0.00           H  
ATOM     44  HA  SER A   5      29.111  36.291  24.306  1.00  0.00           H  
ATOM     45  HB2 SER A   5      29.197  37.789  22.407  1.00  0.00           H  
ATOM     46  HB3 SER A   5      30.826  38.309  22.838  1.00  0.00           H  
ATOM     47  HG  SER A   5      31.563  36.227  22.378  1.00  0.00           H  
ATOM     48  N   SER A   6      32.213  37.241  24.960  1.00  0.00           N  
ATOM     49  CA  SER A   6      33.492  36.783  25.490  1.00  0.00           C  
ATOM     50  C   SER A   6      33.438  36.665  27.011  1.00  0.00           C  
ATOM     51  O   SER A   6      33.790  35.631  27.577  1.00  0.00           O  
ATOM     52  CB  SER A   6      34.611  37.743  25.081  1.00  0.00           C  
ATOM     53  OG  SER A   6      35.838  37.386  25.693  1.00  0.00           O  
ATOM     54  H   SER A   6      32.125  38.171  24.661  1.00  0.00           H  
ATOM     55  HA  SER A   6      33.694  35.808  25.073  1.00  0.00           H  
ATOM     56  HB2 SER A   6      34.735  37.712  24.009  1.00  0.00           H  
ATOM     57  HB3 SER A   6      34.350  38.747  25.384  1.00  0.00           H  
ATOM     58  HG  SER A   6      35.970  37.918  26.480  1.00  0.00           H  
ATOM     59  N   GLY A   7      32.997  37.735  27.666  1.00  0.00           N  
ATOM     60  CA  GLY A   7      32.905  37.732  29.115  1.00  0.00           C  
ATOM     61  C   GLY A   7      33.862  38.715  29.758  1.00  0.00           C  
ATOM     62  O   GLY A   7      34.922  39.008  29.208  1.00  0.00           O  
ATOM     63  H   GLY A   7      32.730  38.532  27.162  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      31.895  37.987  29.401  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      33.130  36.739  29.476  1.00  0.00           H  
ATOM     66  N   MET A   8      33.486  39.226  30.926  1.00  0.00           N  
ATOM     67  CA  MET A   8      34.320  40.184  31.645  1.00  0.00           C  
ATOM     68  C   MET A   8      35.252  39.469  32.617  1.00  0.00           C  
ATOM     69  O   MET A   8      36.337  39.962  32.927  1.00  0.00           O  
ATOM     70  CB  MET A   8      33.446  41.186  32.400  1.00  0.00           C  
ATOM     71  CG  MET A   8      32.811  42.237  31.503  1.00  0.00           C  
ATOM     72  SD  MET A   8      33.940  43.585  31.106  1.00  0.00           S  
ATOM     73  CE  MET A   8      33.783  44.601  32.573  1.00  0.00           C  
ATOM     74  H   MET A   8      32.628  38.954  31.314  1.00  0.00           H  
ATOM     75  HA  MET A   8      34.914  40.715  30.917  1.00  0.00           H  
ATOM     76  HB2 MET A   8      32.656  40.649  32.905  1.00  0.00           H  
ATOM     77  HB3 MET A   8      34.052  41.692  33.136  1.00  0.00           H  
ATOM     78  HG2 MET A   8      32.498  41.765  30.584  1.00  0.00           H  
ATOM     79  HG3 MET A   8      31.947  42.645  32.007  1.00  0.00           H  
ATOM     80  HE1 MET A   8      34.535  44.312  33.292  1.00  0.00           H  
ATOM     81  HE2 MET A   8      33.919  45.639  32.307  1.00  0.00           H  
ATOM     82  HE3 MET A   8      32.802  44.464  33.002  1.00  0.00           H  
ATOM     83  N   ALA A   9      34.823  38.305  33.096  1.00  0.00           N  
ATOM     84  CA  ALA A   9      35.621  37.524  34.031  1.00  0.00           C  
ATOM     85  C   ALA A   9      36.815  36.882  33.332  1.00  0.00           C  
ATOM     86  O   ALA A   9      36.743  35.737  32.883  1.00  0.00           O  
ATOM     87  CB  ALA A   9      34.761  36.459  34.697  1.00  0.00           C  
ATOM     88  H   ALA A   9      33.949  37.965  32.812  1.00  0.00           H  
ATOM     89  HA  ALA A   9      35.983  38.191  34.800  1.00  0.00           H  
ATOM     90  HB1 ALA A   9      34.490  36.784  35.690  1.00  0.00           H  
ATOM     91  HB2 ALA A   9      33.866  36.303  34.112  1.00  0.00           H  
ATOM     92  HB3 ALA A   9      35.316  35.536  34.759  1.00  0.00           H  
ATOM     93  N   THR A  10      37.913  37.626  33.243  1.00  0.00           N  
ATOM     94  CA  THR A  10      39.121  37.130  32.597  1.00  0.00           C  
ATOM     95  C   THR A  10      39.969  36.317  33.569  1.00  0.00           C  
ATOM     96  O   THR A  10      40.116  36.680  34.736  1.00  0.00           O  
ATOM     97  CB  THR A  10      39.971  38.285  32.033  1.00  0.00           C  
ATOM     98  OG1 THR A  10      39.196  39.057  31.109  1.00  0.00           O  
ATOM     99  CG2 THR A  10      41.215  37.752  31.340  1.00  0.00           C  
ATOM    100  H   THR A  10      37.908  38.529  33.621  1.00  0.00           H  
ATOM    101  HA  THR A  10      38.824  36.495  31.775  1.00  0.00           H  
ATOM    102  HB  THR A  10      40.278  38.919  32.853  1.00  0.00           H  
ATOM    103  HG1 THR A  10      38.624  39.656  31.594  1.00  0.00           H  
ATOM    104 HG21 THR A  10      42.094  38.179  31.799  1.00  0.00           H  
ATOM    105 HG22 THR A  10      41.188  38.021  30.294  1.00  0.00           H  
ATOM    106 HG23 THR A  10      41.247  36.676  31.434  1.00  0.00           H  
ATOM    107  N   LYS A  11      40.527  35.214  33.078  1.00  0.00           N  
ATOM    108  CA  LYS A  11      41.363  34.349  33.903  1.00  0.00           C  
ATOM    109  C   LYS A  11      42.741  34.167  33.275  1.00  0.00           C  
ATOM    110  O   LYS A  11      42.899  34.271  32.059  1.00  0.00           O  
ATOM    111  CB  LYS A  11      40.693  32.986  34.090  1.00  0.00           C  
ATOM    112  CG  LYS A  11      39.474  33.027  34.997  1.00  0.00           C  
ATOM    113  CD  LYS A  11      39.867  33.251  36.448  1.00  0.00           C  
ATOM    114  CE  LYS A  11      38.745  32.853  37.395  1.00  0.00           C  
ATOM    115  NZ  LYS A  11      38.726  31.385  37.647  1.00  0.00           N  
ATOM    116  H   LYS A  11      40.372  34.976  32.140  1.00  0.00           H  
ATOM    117  HA  LYS A  11      41.479  34.820  34.867  1.00  0.00           H  
ATOM    118  HB2 LYS A  11      40.385  32.613  33.125  1.00  0.00           H  
ATOM    119  HB3 LYS A  11      41.411  32.302  34.519  1.00  0.00           H  
ATOM    120  HG2 LYS A  11      38.829  33.834  34.681  1.00  0.00           H  
ATOM    121  HG3 LYS A  11      38.946  32.088  34.917  1.00  0.00           H  
ATOM    122  HD2 LYS A  11      40.740  32.657  36.672  1.00  0.00           H  
ATOM    123  HD3 LYS A  11      40.094  34.297  36.593  1.00  0.00           H  
ATOM    124  HE2 LYS A  11      38.883  33.369  38.333  1.00  0.00           H  
ATOM    125  HE3 LYS A  11      37.801  33.147  36.959  1.00  0.00           H  
ATOM    126  HZ1 LYS A  11      38.482  30.876  36.774  1.00  0.00           H  
ATOM    127  HZ2 LYS A  11      38.022  31.158  38.378  1.00  0.00           H  
ATOM    128  HZ3 LYS A  11      39.661  31.067  37.972  1.00  0.00           H  
ATOM    129  N   ALA A  12      43.736  33.893  34.112  1.00  0.00           N  
ATOM    130  CA  ALA A  12      45.100  33.693  33.639  1.00  0.00           C  
ATOM    131  C   ALA A  12      45.793  32.578  34.415  1.00  0.00           C  
ATOM    132  O   ALA A  12      45.678  32.496  35.637  1.00  0.00           O  
ATOM    133  CB  ALA A  12      45.894  34.987  33.752  1.00  0.00           C  
ATOM    134  H   ALA A  12      43.549  33.822  35.071  1.00  0.00           H  
ATOM    135  HA  ALA A  12      45.054  33.417  32.595  1.00  0.00           H  
ATOM    136  HB1 ALA A  12      45.517  35.703  33.036  1.00  0.00           H  
ATOM    137  HB2 ALA A  12      45.789  35.386  34.750  1.00  0.00           H  
ATOM    138  HB3 ALA A  12      46.935  34.789  33.550  1.00  0.00           H  
ATOM    139  N   ARG A  13      46.510  31.721  33.695  1.00  0.00           N  
ATOM    140  CA  ARG A  13      47.219  30.608  34.316  1.00  0.00           C  
ATOM    141  C   ARG A  13      48.704  30.929  34.473  1.00  0.00           C  
ATOM    142  O   ARG A  13      49.341  31.434  33.549  1.00  0.00           O  
ATOM    143  CB  ARG A  13      47.047  29.337  33.483  1.00  0.00           C  
ATOM    144  CG  ARG A  13      48.021  28.230  33.852  1.00  0.00           C  
ATOM    145  CD  ARG A  13      49.304  28.324  33.042  1.00  0.00           C  
ATOM    146  NE  ARG A  13      50.158  27.155  33.232  1.00  0.00           N  
ATOM    147  CZ  ARG A  13      51.139  26.818  32.402  1.00  0.00           C  
ATOM    148  NH1 ARG A  13      51.389  27.559  31.330  1.00  0.00           N  
ATOM    149  NH2 ARG A  13      51.873  25.739  32.641  1.00  0.00           N  
ATOM    150  H   ARG A  13      46.564  31.839  32.724  1.00  0.00           H  
ATOM    151  HA  ARG A  13      46.793  30.448  35.295  1.00  0.00           H  
ATOM    152  HB2 ARG A  13      46.042  28.963  33.622  1.00  0.00           H  
ATOM    153  HB3 ARG A  13      47.191  29.581  32.442  1.00  0.00           H  
ATOM    154  HG2 ARG A  13      48.264  28.312  34.902  1.00  0.00           H  
ATOM    155  HG3 ARG A  13      47.554  27.275  33.663  1.00  0.00           H  
ATOM    156  HD2 ARG A  13      49.048  28.405  31.997  1.00  0.00           H  
ATOM    157  HD3 ARG A  13      49.844  29.206  33.350  1.00  0.00           H  
ATOM    158  HE  ARG A  13      49.991  26.593  34.017  1.00  0.00           H  
ATOM    159 HH11 ARG A  13      50.838  28.373  31.148  1.00  0.00           H  
ATOM    160 HH12 ARG A  13      52.128  27.304  30.707  1.00  0.00           H  
ATOM    161 HH21 ARG A  13      51.687  25.178  33.448  1.00  0.00           H  
ATOM    162 HH22 ARG A  13      52.610  25.486  32.016  1.00  0.00           H  
ATOM    163  N   VAL A  14      49.246  30.633  35.650  1.00  0.00           N  
ATOM    164  CA  VAL A  14      50.655  30.890  35.928  1.00  0.00           C  
ATOM    165  C   VAL A  14      51.542  29.823  35.294  1.00  0.00           C  
ATOM    166  O   VAL A  14      51.369  28.631  35.543  1.00  0.00           O  
ATOM    167  CB  VAL A  14      50.928  30.936  37.442  1.00  0.00           C  
ATOM    168  CG1 VAL A  14      52.330  31.457  37.716  1.00  0.00           C  
ATOM    169  CG2 VAL A  14      49.886  31.793  38.146  1.00  0.00           C  
ATOM    170  H   VAL A  14      48.686  30.233  36.347  1.00  0.00           H  
ATOM    171  HA  VAL A  14      50.908  31.852  35.507  1.00  0.00           H  
ATOM    172  HB  VAL A  14      50.859  29.931  37.831  1.00  0.00           H  
ATOM    173 HG11 VAL A  14      52.329  32.536  37.670  1.00  0.00           H  
ATOM    174 HG12 VAL A  14      52.649  31.138  38.697  1.00  0.00           H  
ATOM    175 HG13 VAL A  14      53.011  31.067  36.973  1.00  0.00           H  
ATOM    176 HG21 VAL A  14      49.701  31.398  39.133  1.00  0.00           H  
ATOM    177 HG22 VAL A  14      50.249  32.807  38.225  1.00  0.00           H  
ATOM    178 HG23 VAL A  14      48.967  31.782  37.577  1.00  0.00           H  
ATOM    179  N   MET A  15      52.492  30.262  34.476  1.00  0.00           N  
ATOM    180  CA  MET A  15      53.410  29.345  33.808  1.00  0.00           C  
ATOM    181  C   MET A  15      54.597  29.015  34.707  1.00  0.00           C  
ATOM    182  O   MET A  15      55.091  27.887  34.708  1.00  0.00           O  
ATOM    183  CB  MET A  15      53.903  29.951  32.493  1.00  0.00           C  
ATOM    184  CG  MET A  15      52.812  30.651  31.700  1.00  0.00           C  
ATOM    185  SD  MET A  15      53.141  30.661  29.927  1.00  0.00           S  
ATOM    186  CE  MET A  15      53.811  32.309  29.717  1.00  0.00           C  
ATOM    187  H   MET A  15      52.581  31.226  34.317  1.00  0.00           H  
ATOM    188  HA  MET A  15      52.870  28.435  33.595  1.00  0.00           H  
ATOM    189  HB2 MET A  15      54.678  30.671  32.710  1.00  0.00           H  
ATOM    190  HB3 MET A  15      54.315  29.165  31.880  1.00  0.00           H  
ATOM    191  HG2 MET A  15      51.875  30.143  31.873  1.00  0.00           H  
ATOM    192  HG3 MET A  15      52.733  31.671  32.044  1.00  0.00           H  
ATOM    193  HE1 MET A  15      54.324  32.370  28.768  1.00  0.00           H  
ATOM    194  HE2 MET A  15      53.007  33.031  29.739  1.00  0.00           H  
ATOM    195  HE3 MET A  15      54.506  32.519  30.515  1.00  0.00           H  
ATOM    196  N   TYR A  16      55.052  30.004  35.467  1.00  0.00           N  
ATOM    197  CA  TYR A  16      56.184  29.818  36.368  1.00  0.00           C  
ATOM    198  C   TYR A  16      55.867  30.357  37.759  1.00  0.00           C  
ATOM    199  O   TYR A  16      55.239  31.406  37.903  1.00  0.00           O  
ATOM    200  CB  TYR A  16      57.426  30.515  35.809  1.00  0.00           C  
ATOM    201  CG  TYR A  16      57.620  30.307  34.324  1.00  0.00           C  
ATOM    202  CD1 TYR A  16      57.905  29.048  33.810  1.00  0.00           C  
ATOM    203  CD2 TYR A  16      57.519  31.370  33.435  1.00  0.00           C  
ATOM    204  CE1 TYR A  16      58.085  28.854  32.455  1.00  0.00           C  
ATOM    205  CE2 TYR A  16      57.695  31.185  32.077  1.00  0.00           C  
ATOM    206  CZ  TYR A  16      57.979  29.925  31.593  1.00  0.00           C  
ATOM    207  OH  TYR A  16      58.156  29.735  30.240  1.00  0.00           O  
ATOM    208  H   TYR A  16      54.617  30.882  35.421  1.00  0.00           H  
ATOM    209  HA  TYR A  16      56.379  28.759  36.440  1.00  0.00           H  
ATOM    210  HB2 TYR A  16      57.345  31.576  35.987  1.00  0.00           H  
ATOM    211  HB3 TYR A  16      58.301  30.135  36.315  1.00  0.00           H  
ATOM    212  HD1 TYR A  16      57.988  28.211  34.488  1.00  0.00           H  
ATOM    213  HD2 TYR A  16      57.296  32.355  33.818  1.00  0.00           H  
ATOM    214  HE1 TYR A  16      58.307  27.867  32.075  1.00  0.00           H  
ATOM    215  HE2 TYR A  16      57.612  32.023  31.401  1.00  0.00           H  
ATOM    216  HH  TYR A  16      57.472  30.208  29.759  1.00  0.00           H  
ATOM    217  N   ASP A  17      56.307  29.631  38.781  1.00  0.00           N  
ATOM    218  CA  ASP A  17      56.073  30.036  40.163  1.00  0.00           C  
ATOM    219  C   ASP A  17      56.762  31.363  40.465  1.00  0.00           C  
ATOM    220  O   ASP A  17      57.989  31.434  40.536  1.00  0.00           O  
ATOM    221  CB  ASP A  17      56.573  28.957  41.125  1.00  0.00           C  
ATOM    222  CG  ASP A  17      56.341  27.555  40.592  1.00  0.00           C  
ATOM    223  OD1 ASP A  17      57.168  27.083  39.785  1.00  0.00           O  
ATOM    224  OD2 ASP A  17      55.332  26.932  40.984  1.00  0.00           O  
ATOM    225  H   ASP A  17      56.801  28.804  38.602  1.00  0.00           H  
ATOM    226  HA  ASP A  17      55.009  30.159  40.297  1.00  0.00           H  
ATOM    227  HB2 ASP A  17      57.633  29.090  41.285  1.00  0.00           H  
ATOM    228  HB3 ASP A  17      56.055  29.055  42.066  1.00  0.00           H  
ATOM    229  N   PHE A  18      55.966  32.412  40.640  1.00  0.00           N  
ATOM    230  CA  PHE A  18      56.500  33.737  40.932  1.00  0.00           C  
ATOM    231  C   PHE A  18      56.262  34.109  42.394  1.00  0.00           C  
ATOM    232  O   PHE A  18      55.250  33.733  42.984  1.00  0.00           O  
ATOM    233  CB  PHE A  18      55.856  34.782  40.018  1.00  0.00           C  
ATOM    234  CG  PHE A  18      56.443  36.156  40.173  1.00  0.00           C  
ATOM    235  CD1 PHE A  18      57.773  36.394  39.872  1.00  0.00           C  
ATOM    236  CD2 PHE A  18      55.662  37.210  40.622  1.00  0.00           C  
ATOM    237  CE1 PHE A  18      58.315  37.658  40.013  1.00  0.00           C  
ATOM    238  CE2 PHE A  18      56.198  38.474  40.766  1.00  0.00           C  
ATOM    239  CZ  PHE A  18      57.526  38.700  40.462  1.00  0.00           C  
ATOM    240  H   PHE A  18      54.995  32.291  40.571  1.00  0.00           H  
ATOM    241  HA  PHE A  18      57.562  33.713  40.747  1.00  0.00           H  
ATOM    242  HB2 PHE A  18      55.988  34.480  38.990  1.00  0.00           H  
ATOM    243  HB3 PHE A  18      54.801  34.842  40.239  1.00  0.00           H  
ATOM    244  HD1 PHE A  18      58.392  35.579  39.522  1.00  0.00           H  
ATOM    245  HD2 PHE A  18      54.623  37.035  40.861  1.00  0.00           H  
ATOM    246  HE1 PHE A  18      59.354  37.830  39.775  1.00  0.00           H  
ATOM    247  HE2 PHE A  18      55.579  39.287  41.117  1.00  0.00           H  
ATOM    248  HZ  PHE A  18      57.948  39.688  40.574  1.00  0.00           H  
ATOM    249  N   ALA A  19      57.204  34.849  42.970  1.00  0.00           N  
ATOM    250  CA  ALA A  19      57.097  35.273  44.360  1.00  0.00           C  
ATOM    251  C   ALA A  19      57.166  36.792  44.478  1.00  0.00           C  
ATOM    252  O   ALA A  19      57.983  37.438  43.822  1.00  0.00           O  
ATOM    253  CB  ALA A  19      58.194  34.626  45.194  1.00  0.00           C  
ATOM    254  H   ALA A  19      57.987  35.117  42.446  1.00  0.00           H  
ATOM    255  HA  ALA A  19      56.144  34.935  44.740  1.00  0.00           H  
ATOM    256  HB1 ALA A  19      58.805  34.001  44.561  1.00  0.00           H  
ATOM    257  HB2 ALA A  19      58.806  35.396  45.640  1.00  0.00           H  
ATOM    258  HB3 ALA A  19      57.746  34.025  45.972  1.00  0.00           H  
ATOM    259  N   ALA A  20      56.304  37.356  45.316  1.00  0.00           N  
ATOM    260  CA  ALA A  20      56.267  38.798  45.520  1.00  0.00           C  
ATOM    261  C   ALA A  20      56.882  39.178  46.864  1.00  0.00           C  
ATOM    262  O   ALA A  20      56.552  38.592  47.894  1.00  0.00           O  
ATOM    263  CB  ALA A  20      54.838  39.309  45.428  1.00  0.00           C  
ATOM    264  H   ALA A  20      55.677  36.787  45.811  1.00  0.00           H  
ATOM    265  HA  ALA A  20      56.841  39.261  44.730  1.00  0.00           H  
ATOM    266  HB1 ALA A  20      54.799  40.150  44.751  1.00  0.00           H  
ATOM    267  HB2 ALA A  20      54.198  38.521  45.060  1.00  0.00           H  
ATOM    268  HB3 ALA A  20      54.502  39.619  46.407  1.00  0.00           H  
ATOM    269  N   GLU A  21      57.775  40.162  46.843  1.00  0.00           N  
ATOM    270  CA  GLU A  21      58.436  40.618  48.061  1.00  0.00           C  
ATOM    271  C   GLU A  21      57.413  41.089  49.091  1.00  0.00           C  
ATOM    272  O   GLU A  21      56.316  41.535  48.755  1.00  0.00           O  
ATOM    273  CB  GLU A  21      59.415  41.750  47.743  1.00  0.00           C  
ATOM    274  CG  GLU A  21      60.809  41.267  47.381  1.00  0.00           C  
ATOM    275  CD  GLU A  21      61.561  42.254  46.511  1.00  0.00           C  
ATOM    276  OE1 GLU A  21      61.438  42.168  45.272  1.00  0.00           O  
ATOM    277  OE2 GLU A  21      62.273  43.115  47.069  1.00  0.00           O  
ATOM    278  H   GLU A  21      57.997  40.590  45.990  1.00  0.00           H  
ATOM    279  HA  GLU A  21      58.986  39.785  48.471  1.00  0.00           H  
ATOM    280  HB2 GLU A  21      59.027  42.322  46.913  1.00  0.00           H  
ATOM    281  HB3 GLU A  21      59.492  42.396  48.606  1.00  0.00           H  
ATOM    282  HG2 GLU A  21      61.370  41.113  48.292  1.00  0.00           H  
ATOM    283  HG3 GLU A  21      60.726  40.332  46.850  1.00  0.00           H  
ATOM    284  N   PRO A  22      57.780  40.985  50.378  1.00  0.00           N  
ATOM    285  CA  PRO A  22      56.909  41.395  51.483  1.00  0.00           C  
ATOM    286  C   PRO A  22      56.733  42.908  51.553  1.00  0.00           C  
ATOM    287  O   PRO A  22      57.709  43.655  51.587  1.00  0.00           O  
ATOM    288  CB  PRO A  22      57.648  40.885  52.724  1.00  0.00           C  
ATOM    289  CG  PRO A  22      59.078  40.819  52.311  1.00  0.00           C  
ATOM    290  CD  PRO A  22      59.072  40.462  50.851  1.00  0.00           C  
ATOM    291  HA  PRO A  22      55.940  40.923  51.420  1.00  0.00           H  
ATOM    292  HB2 PRO A  22      57.503  41.577  53.541  1.00  0.00           H  
ATOM    293  HB3 PRO A  22      57.270  39.912  52.997  1.00  0.00           H  
ATOM    294  HG2 PRO A  22      59.549  41.778  52.462  1.00  0.00           H  
ATOM    295  HG3 PRO A  22      59.588  40.056  52.881  1.00  0.00           H  
ATOM    296  HD2 PRO A  22      59.894  40.944  50.342  1.00  0.00           H  
ATOM    297  HD3 PRO A  22      59.123  39.391  50.723  1.00  0.00           H  
ATOM    298  N   GLY A  23      55.480  43.353  51.574  1.00  0.00           N  
ATOM    299  CA  GLY A  23      55.199  44.775  51.640  1.00  0.00           C  
ATOM    300  C   GLY A  23      55.460  45.480  50.323  1.00  0.00           C  
ATOM    301  O   GLY A  23      56.002  46.584  50.299  1.00  0.00           O  
ATOM    302  H   GLY A  23      54.740  42.710  51.545  1.00  0.00           H  
ATOM    303  HA2 GLY A  23      54.163  44.914  51.912  1.00  0.00           H  
ATOM    304  HA3 GLY A  23      55.823  45.219  52.401  1.00  0.00           H  
ATOM    305  N   ASN A  24      55.076  44.838  49.224  1.00  0.00           N  
ATOM    306  CA  ASN A  24      55.274  45.409  47.897  1.00  0.00           C  
ATOM    307  C   ASN A  24      53.963  45.442  47.117  1.00  0.00           C  
ATOM    308  O   ASN A  24      52.976  44.828  47.519  1.00  0.00           O  
ATOM    309  CB  ASN A  24      56.320  44.604  47.124  1.00  0.00           C  
ATOM    310  CG  ASN A  24      55.868  43.183  46.848  1.00  0.00           C  
ATOM    311  OD1 ASN A  24      54.787  42.770  47.269  1.00  0.00           O  
ATOM    312  ND2 ASN A  24      56.696  42.426  46.136  1.00  0.00           N  
ATOM    313  H   ASN A  24      54.649  43.959  49.308  1.00  0.00           H  
ATOM    314  HA  ASN A  24      55.631  46.420  48.022  1.00  0.00           H  
ATOM    315  HB2 ASN A  24      56.513  45.090  46.178  1.00  0.00           H  
ATOM    316  HB3 ASN A  24      57.234  44.566  47.697  1.00  0.00           H  
ATOM    317 HD21 ASN A  24      57.540  42.822  45.834  1.00  0.00           H  
ATOM    318 HD22 ASN A  24      56.429  41.504  45.942  1.00  0.00           H  
ATOM    319  N   ASN A  25      53.962  46.162  46.001  1.00  0.00           N  
ATOM    320  CA  ASN A  25      52.773  46.276  45.165  1.00  0.00           C  
ATOM    321  C   ASN A  25      52.684  45.110  44.185  1.00  0.00           C  
ATOM    322  O   ASN A  25      52.131  45.244  43.094  1.00  0.00           O  
ATOM    323  CB  ASN A  25      52.786  47.600  44.399  1.00  0.00           C  
ATOM    324  CG  ASN A  25      52.187  48.739  45.203  1.00  0.00           C  
ATOM    325  OD1 ASN A  25      50.968  48.864  45.308  1.00  0.00           O  
ATOM    326  ND2 ASN A  25      53.046  49.575  45.774  1.00  0.00           N  
ATOM    327  H   ASN A  25      54.781  46.629  45.733  1.00  0.00           H  
ATOM    328  HA  ASN A  25      51.910  46.253  45.813  1.00  0.00           H  
ATOM    329  HB2 ASN A  25      53.806  47.856  44.153  1.00  0.00           H  
ATOM    330  HB3 ASN A  25      52.217  47.488  43.488  1.00  0.00           H  
ATOM    331 HD21 ASN A  25      54.004  49.413  45.647  1.00  0.00           H  
ATOM    332 HD22 ASN A  25      52.686  50.319  46.300  1.00  0.00           H  
ATOM    333  N   GLU A  26      53.231  43.966  44.583  1.00  0.00           N  
ATOM    334  CA  GLU A  26      53.214  42.776  43.740  1.00  0.00           C  
ATOM    335  C   GLU A  26      52.462  41.637  44.421  1.00  0.00           C  
ATOM    336  O   GLU A  26      52.326  41.612  45.646  1.00  0.00           O  
ATOM    337  CB  GLU A  26      54.642  42.335  43.412  1.00  0.00           C  
ATOM    338  CG  GLU A  26      55.365  43.271  42.458  1.00  0.00           C  
ATOM    339  CD  GLU A  26      56.520  42.598  41.743  1.00  0.00           C  
ATOM    340  OE1 GLU A  26      56.261  41.746  40.868  1.00  0.00           O  
ATOM    341  OE2 GLU A  26      57.684  42.923  42.060  1.00  0.00           O  
ATOM    342  H   GLU A  26      53.657  43.921  45.464  1.00  0.00           H  
ATOM    343  HA  GLU A  26      52.706  43.029  42.822  1.00  0.00           H  
ATOM    344  HB2 GLU A  26      55.209  42.282  44.330  1.00  0.00           H  
ATOM    345  HB3 GLU A  26      54.608  41.353  42.963  1.00  0.00           H  
ATOM    346  HG2 GLU A  26      54.662  43.625  41.720  1.00  0.00           H  
ATOM    347  HG3 GLU A  26      55.748  44.111  43.019  1.00  0.00           H  
ATOM    348  N   LEU A  27      51.974  40.696  43.620  1.00  0.00           N  
ATOM    349  CA  LEU A  27      51.234  39.553  44.144  1.00  0.00           C  
ATOM    350  C   LEU A  27      52.040  38.267  43.992  1.00  0.00           C  
ATOM    351  O   LEU A  27      52.815  38.114  43.048  1.00  0.00           O  
ATOM    352  CB  LEU A  27      49.892  39.415  43.424  1.00  0.00           C  
ATOM    353  CG  LEU A  27      48.761  38.775  44.229  1.00  0.00           C  
ATOM    354  CD1 LEU A  27      48.378  39.658  45.407  1.00  0.00           C  
ATOM    355  CD2 LEU A  27      47.552  38.518  43.340  1.00  0.00           C  
ATOM    356  H   LEU A  27      52.114  40.770  42.653  1.00  0.00           H  
ATOM    357  HA  LEU A  27      51.054  39.728  45.194  1.00  0.00           H  
ATOM    358  HB2 LEU A  27      49.571  40.404  43.131  1.00  0.00           H  
ATOM    359  HB3 LEU A  27      50.052  38.814  42.540  1.00  0.00           H  
ATOM    360  HG  LEU A  27      49.098  37.825  44.620  1.00  0.00           H  
ATOM    361 HD11 LEU A  27      48.797  40.643  45.270  1.00  0.00           H  
ATOM    362 HD12 LEU A  27      48.764  39.227  46.320  1.00  0.00           H  
ATOM    363 HD13 LEU A  27      47.302  39.729  45.470  1.00  0.00           H  
ATOM    364 HD21 LEU A  27      47.590  37.506  42.966  1.00  0.00           H  
ATOM    365 HD22 LEU A  27      47.563  39.210  42.510  1.00  0.00           H  
ATOM    366 HD23 LEU A  27      46.647  38.657  43.914  1.00  0.00           H  
ATOM    367  N   THR A  28      51.850  37.342  44.929  1.00  0.00           N  
ATOM    368  CA  THR A  28      52.558  36.069  44.899  1.00  0.00           C  
ATOM    369  C   THR A  28      51.679  34.964  44.323  1.00  0.00           C  
ATOM    370  O   THR A  28      50.571  34.725  44.804  1.00  0.00           O  
ATOM    371  CB  THR A  28      53.029  35.654  46.306  1.00  0.00           C  
ATOM    372  OG1 THR A  28      53.761  36.725  46.913  1.00  0.00           O  
ATOM    373  CG2 THR A  28      53.902  34.409  46.240  1.00  0.00           C  
ATOM    374  H   THR A  28      51.219  37.523  45.657  1.00  0.00           H  
ATOM    375  HA  THR A  28      53.430  36.185  44.271  1.00  0.00           H  
ATOM    376  HB  THR A  28      52.160  35.434  46.909  1.00  0.00           H  
ATOM    377  HG1 THR A  28      53.215  37.515  46.933  1.00  0.00           H  
ATOM    378 HG21 THR A  28      53.772  33.930  45.282  1.00  0.00           H  
ATOM    379 HG22 THR A  28      53.614  33.727  47.026  1.00  0.00           H  
ATOM    380 HG23 THR A  28      54.936  34.689  46.366  1.00  0.00           H  
ATOM    381  N   VAL A  29      52.180  34.292  43.292  1.00  0.00           N  
ATOM    382  CA  VAL A  29      51.440  33.211  42.652  1.00  0.00           C  
ATOM    383  C   VAL A  29      52.325  31.987  42.445  1.00  0.00           C  
ATOM    384  O   VAL A  29      53.533  32.032  42.680  1.00  0.00           O  
ATOM    385  CB  VAL A  29      50.866  33.652  41.292  1.00  0.00           C  
ATOM    386  CG1 VAL A  29      49.941  34.846  41.465  1.00  0.00           C  
ATOM    387  CG2 VAL A  29      51.990  33.974  40.319  1.00  0.00           C  
ATOM    388  H   VAL A  29      53.069  34.528  42.954  1.00  0.00           H  
ATOM    389  HA  VAL A  29      50.616  32.942  43.297  1.00  0.00           H  
ATOM    390  HB  VAL A  29      50.290  32.834  40.886  1.00  0.00           H  
ATOM    391 HG11 VAL A  29      49.044  34.693  40.882  1.00  0.00           H  
ATOM    392 HG12 VAL A  29      49.680  34.952  42.508  1.00  0.00           H  
ATOM    393 HG13 VAL A  29      50.442  35.741  41.126  1.00  0.00           H  
ATOM    394 HG21 VAL A  29      52.220  33.098  39.731  1.00  0.00           H  
ATOM    395 HG22 VAL A  29      51.681  34.776  39.667  1.00  0.00           H  
ATOM    396 HG23 VAL A  29      52.868  34.277  40.871  1.00  0.00           H  
ATOM    397  N   THR A  30      51.716  30.891  42.003  1.00  0.00           N  
ATOM    398  CA  THR A  30      52.448  29.653  41.764  1.00  0.00           C  
ATOM    399  C   THR A  30      52.037  29.018  40.442  1.00  0.00           C  
ATOM    400  O   THR A  30      50.938  29.260  39.941  1.00  0.00           O  
ATOM    401  CB  THR A  30      52.221  28.639  42.901  1.00  0.00           C  
ATOM    402  OG1 THR A  30      50.830  28.313  42.998  1.00  0.00           O  
ATOM    403  CG2 THR A  30      52.710  29.196  44.229  1.00  0.00           C  
ATOM    404  H   THR A  30      50.752  30.917  41.834  1.00  0.00           H  
ATOM    405  HA  THR A  30      53.501  29.890  41.726  1.00  0.00           H  
ATOM    406  HB  THR A  30      52.778  27.740  42.678  1.00  0.00           H  
ATOM    407  HG1 THR A  30      50.497  28.070  42.130  1.00  0.00           H  
ATOM    408 HG21 THR A  30      52.602  28.444  44.996  1.00  0.00           H  
ATOM    409 HG22 THR A  30      52.124  30.065  44.493  1.00  0.00           H  
ATOM    410 HG23 THR A  30      53.750  29.476  44.142  1.00  0.00           H  
ATOM    411  N   GLU A  31      52.924  28.202  39.881  1.00  0.00           N  
ATOM    412  CA  GLU A  31      52.651  27.532  38.615  1.00  0.00           C  
ATOM    413  C   GLU A  31      51.404  26.658  38.719  1.00  0.00           C  
ATOM    414  O   GLU A  31      51.262  25.868  39.652  1.00  0.00           O  
ATOM    415  CB  GLU A  31      53.850  26.678  38.195  1.00  0.00           C  
ATOM    416  CG  GLU A  31      53.556  25.744  37.034  1.00  0.00           C  
ATOM    417  CD  GLU A  31      53.008  24.405  37.487  1.00  0.00           C  
ATOM    418  OE1 GLU A  31      53.459  23.903  38.537  1.00  0.00           O  
ATOM    419  OE2 GLU A  31      52.127  23.860  36.790  1.00  0.00           O  
ATOM    420  H   GLU A  31      53.782  28.049  40.328  1.00  0.00           H  
ATOM    421  HA  GLU A  31      52.483  28.291  37.867  1.00  0.00           H  
ATOM    422  HB2 GLU A  31      54.660  27.334  37.908  1.00  0.00           H  
ATOM    423  HB3 GLU A  31      54.164  26.081  39.038  1.00  0.00           H  
ATOM    424  HG2 GLU A  31      52.830  26.213  36.386  1.00  0.00           H  
ATOM    425  HG3 GLU A  31      54.471  25.575  36.484  1.00  0.00           H  
ATOM    426  N   GLY A  32      50.501  26.808  37.755  1.00  0.00           N  
ATOM    427  CA  GLY A  32      49.277  26.029  37.756  1.00  0.00           C  
ATOM    428  C   GLY A  32      48.146  26.726  38.485  1.00  0.00           C  
ATOM    429  O   GLY A  32      46.974  26.450  38.233  1.00  0.00           O  
ATOM    430  H   GLY A  32      50.668  27.453  37.035  1.00  0.00           H  
ATOM    431  HA2 GLY A  32      48.976  25.848  36.735  1.00  0.00           H  
ATOM    432  HA3 GLY A  32      49.469  25.081  38.237  1.00  0.00           H  
ATOM    433  N   GLU A  33      48.498  27.632  39.393  1.00  0.00           N  
ATOM    434  CA  GLU A  33      47.503  28.369  40.162  1.00  0.00           C  
ATOM    435  C   GLU A  33      46.821  29.427  39.299  1.00  0.00           C  
ATOM    436  O   GLU A  33      47.481  30.159  38.560  1.00  0.00           O  
ATOM    437  CB  GLU A  33      48.154  29.030  41.379  1.00  0.00           C  
ATOM    438  CG  GLU A  33      47.219  29.954  42.142  1.00  0.00           C  
ATOM    439  CD  GLU A  33      46.104  29.204  42.846  1.00  0.00           C  
ATOM    440  OE1 GLU A  33      46.375  28.592  43.900  1.00  0.00           O  
ATOM    441  OE2 GLU A  33      44.962  29.231  42.343  1.00  0.00           O  
ATOM    442  H   GLU A  33      49.450  27.808  39.548  1.00  0.00           H  
ATOM    443  HA  GLU A  33      46.759  27.665  40.502  1.00  0.00           H  
ATOM    444  HB2 GLU A  33      48.495  28.259  42.054  1.00  0.00           H  
ATOM    445  HB3 GLU A  33      49.005  29.607  41.048  1.00  0.00           H  
ATOM    446  HG2 GLU A  33      47.792  30.494  42.881  1.00  0.00           H  
ATOM    447  HG3 GLU A  33      46.779  30.654  41.447  1.00  0.00           H  
ATOM    448  N   ILE A  34      45.499  29.499  39.397  1.00  0.00           N  
ATOM    449  CA  ILE A  34      44.728  30.467  38.627  1.00  0.00           C  
ATOM    450  C   ILE A  34      44.182  31.574  39.522  1.00  0.00           C  
ATOM    451  O   ILE A  34      43.869  31.343  40.690  1.00  0.00           O  
ATOM    452  CB  ILE A  34      43.556  29.794  37.889  1.00  0.00           C  
ATOM    453  CG1 ILE A  34      44.058  28.608  37.064  1.00  0.00           C  
ATOM    454  CG2 ILE A  34      42.842  30.800  36.999  1.00  0.00           C  
ATOM    455  CD1 ILE A  34      44.627  29.005  35.719  1.00  0.00           C  
ATOM    456  H   ILE A  34      45.030  28.889  40.003  1.00  0.00           H  
ATOM    457  HA  ILE A  34      45.386  30.906  37.890  1.00  0.00           H  
ATOM    458  HB  ILE A  34      42.853  29.438  38.625  1.00  0.00           H  
ATOM    459 HG12 ILE A  34      44.833  28.096  37.613  1.00  0.00           H  
ATOM    460 HG13 ILE A  34      43.238  27.926  36.889  1.00  0.00           H  
ATOM    461 HG21 ILE A  34      43.569  31.444  36.528  1.00  0.00           H  
ATOM    462 HG22 ILE A  34      42.282  30.275  36.240  1.00  0.00           H  
ATOM    463 HG23 ILE A  34      42.168  31.396  37.597  1.00  0.00           H  
ATOM    464 HD11 ILE A  34      45.532  28.443  35.531  1.00  0.00           H  
ATOM    465 HD12 ILE A  34      43.905  28.791  34.945  1.00  0.00           H  
ATOM    466 HD13 ILE A  34      44.853  30.059  35.721  1.00  0.00           H  
ATOM    467  N   ILE A  35      44.069  32.775  38.966  1.00  0.00           N  
ATOM    468  CA  ILE A  35      43.558  33.917  39.713  1.00  0.00           C  
ATOM    469  C   ILE A  35      42.609  34.753  38.860  1.00  0.00           C  
ATOM    470  O   ILE A  35      42.390  34.459  37.685  1.00  0.00           O  
ATOM    471  CB  ILE A  35      44.700  34.816  40.221  1.00  0.00           C  
ATOM    472  CG1 ILE A  35      45.647  35.172  39.073  1.00  0.00           C  
ATOM    473  CG2 ILE A  35      45.458  34.124  41.345  1.00  0.00           C  
ATOM    474  CD1 ILE A  35      46.458  36.423  39.325  1.00  0.00           C  
ATOM    475  H   ILE A  35      44.334  32.897  38.031  1.00  0.00           H  
ATOM    476  HA  ILE A  35      43.016  33.540  40.569  1.00  0.00           H  
ATOM    477  HB  ILE A  35      44.268  35.722  40.617  1.00  0.00           H  
ATOM    478 HG12 ILE A  35      46.336  34.356  38.917  1.00  0.00           H  
ATOM    479 HG13 ILE A  35      45.068  35.326  38.174  1.00  0.00           H  
ATOM    480 HG21 ILE A  35      44.921  34.251  42.273  1.00  0.00           H  
ATOM    481 HG22 ILE A  35      45.548  33.071  41.124  1.00  0.00           H  
ATOM    482 HG23 ILE A  35      46.442  34.558  41.437  1.00  0.00           H  
ATOM    483 HD11 ILE A  35      46.593  36.557  40.390  1.00  0.00           H  
ATOM    484 HD12 ILE A  35      47.424  36.328  38.851  1.00  0.00           H  
ATOM    485 HD13 ILE A  35      45.939  37.277  38.919  1.00  0.00           H  
ATOM    486  N   THR A  36      42.050  35.800  39.459  1.00  0.00           N  
ATOM    487  CA  THR A  36      41.127  36.680  38.755  1.00  0.00           C  
ATOM    488  C   THR A  36      41.836  37.932  38.251  1.00  0.00           C  
ATOM    489  O   THR A  36      42.501  38.631  39.016  1.00  0.00           O  
ATOM    490  CB  THR A  36      39.950  37.098  39.657  1.00  0.00           C  
ATOM    491  OG1 THR A  36      39.421  35.952  40.334  1.00  0.00           O  
ATOM    492  CG2 THR A  36      38.852  37.763  38.841  1.00  0.00           C  
ATOM    493  H   THR A  36      42.264  35.984  40.397  1.00  0.00           H  
ATOM    494  HA  THR A  36      40.729  36.139  37.908  1.00  0.00           H  
ATOM    495  HB  THR A  36      40.312  37.805  40.390  1.00  0.00           H  
ATOM    496  HG1 THR A  36      40.127  35.507  40.810  1.00  0.00           H  
ATOM    497 HG21 THR A  36      38.873  38.828  39.010  1.00  0.00           H  
ATOM    498 HG22 THR A  36      37.892  37.370  39.141  1.00  0.00           H  
ATOM    499 HG23 THR A  36      39.010  37.561  37.791  1.00  0.00           H  
ATOM    500  N   VAL A  37      41.689  38.212  36.960  1.00  0.00           N  
ATOM    501  CA  VAL A  37      42.315  39.381  36.355  1.00  0.00           C  
ATOM    502  C   VAL A  37      41.399  40.598  36.438  1.00  0.00           C  
ATOM    503  O   VAL A  37      40.234  40.542  36.044  1.00  0.00           O  
ATOM    504  CB  VAL A  37      42.676  39.124  34.880  1.00  0.00           C  
ATOM    505  CG1 VAL A  37      43.184  40.400  34.224  1.00  0.00           C  
ATOM    506  CG2 VAL A  37      43.708  38.012  34.772  1.00  0.00           C  
ATOM    507  H   VAL A  37      41.146  37.617  36.401  1.00  0.00           H  
ATOM    508  HA  VAL A  37      43.225  39.590  36.896  1.00  0.00           H  
ATOM    509  HB  VAL A  37      41.783  38.811  34.361  1.00  0.00           H  
ATOM    510 HG11 VAL A  37      44.117  40.692  34.684  1.00  0.00           H  
ATOM    511 HG12 VAL A  37      43.339  40.226  33.170  1.00  0.00           H  
ATOM    512 HG13 VAL A  37      42.456  41.187  34.357  1.00  0.00           H  
ATOM    513 HG21 VAL A  37      44.374  38.053  35.620  1.00  0.00           H  
ATOM    514 HG22 VAL A  37      43.205  37.056  34.753  1.00  0.00           H  
ATOM    515 HG23 VAL A  37      44.277  38.137  33.862  1.00  0.00           H  
ATOM    516  N   THR A  38      41.935  41.700  36.953  1.00  0.00           N  
ATOM    517  CA  THR A  38      41.168  42.932  37.089  1.00  0.00           C  
ATOM    518  C   THR A  38      41.717  44.025  36.180  1.00  0.00           C  
ATOM    519  O   THR A  38      40.962  44.713  35.495  1.00  0.00           O  
ATOM    520  CB  THR A  38      41.172  43.439  38.543  1.00  0.00           C  
ATOM    521  OG1 THR A  38      42.519  43.580  39.010  1.00  0.00           O  
ATOM    522  CG2 THR A  38      40.413  42.484  39.452  1.00  0.00           C  
ATOM    523  H   THR A  38      42.870  41.683  37.250  1.00  0.00           H  
ATOM    524  HA  THR A  38      40.147  42.721  36.806  1.00  0.00           H  
ATOM    525  HB  THR A  38      40.686  44.404  38.574  1.00  0.00           H  
ATOM    526  HG1 THR A  38      42.559  44.279  39.666  1.00  0.00           H  
ATOM    527 HG21 THR A  38      39.531  42.128  38.942  1.00  0.00           H  
ATOM    528 HG22 THR A  38      40.123  43.000  40.355  1.00  0.00           H  
ATOM    529 HG23 THR A  38      41.047  41.647  39.703  1.00  0.00           H  
ATOM    530  N   ASN A  39      43.038  44.179  36.179  1.00  0.00           N  
ATOM    531  CA  ASN A  39      43.689  45.190  35.353  1.00  0.00           C  
ATOM    532  C   ASN A  39      44.796  44.571  34.507  1.00  0.00           C  
ATOM    533  O   ASN A  39      45.979  44.638  34.843  1.00  0.00           O  
ATOM    534  CB  ASN A  39      44.264  46.303  36.231  1.00  0.00           C  
ATOM    535  CG  ASN A  39      44.771  47.477  35.417  1.00  0.00           C  
ATOM    536  OD1 ASN A  39      44.702  47.471  34.188  1.00  0.00           O  
ATOM    537  ND2 ASN A  39      45.284  48.493  36.101  1.00  0.00           N  
ATOM    538  H   ASN A  39      43.587  43.600  36.746  1.00  0.00           H  
ATOM    539  HA  ASN A  39      42.943  45.611  34.695  1.00  0.00           H  
ATOM    540  HB2 ASN A  39      43.494  46.660  36.899  1.00  0.00           H  
ATOM    541  HB3 ASN A  39      45.084  45.909  36.811  1.00  0.00           H  
ATOM    542 HD21 ASN A  39      45.307  48.430  37.078  1.00  0.00           H  
ATOM    543 HD22 ASN A  39      45.619  49.266  35.599  1.00  0.00           H  
ATOM    544  N   PRO A  40      44.407  43.952  33.382  1.00  0.00           N  
ATOM    545  CA  PRO A  40      45.353  43.309  32.464  1.00  0.00           C  
ATOM    546  C   PRO A  40      46.221  44.321  31.724  1.00  0.00           C  
ATOM    547  O   PRO A  40      47.272  43.975  31.186  1.00  0.00           O  
ATOM    548  CB  PRO A  40      44.444  42.565  31.483  1.00  0.00           C  
ATOM    549  CG  PRO A  40      43.158  43.315  31.515  1.00  0.00           C  
ATOM    550  CD  PRO A  40      43.015  43.833  32.920  1.00  0.00           C  
ATOM    551  HA  PRO A  40      45.986  42.601  32.979  1.00  0.00           H  
ATOM    552  HB2 PRO A  40      44.886  42.580  30.497  1.00  0.00           H  
ATOM    553  HB3 PRO A  40      44.314  41.545  31.809  1.00  0.00           H  
ATOM    554  HG2 PRO A  40      43.193  44.136  30.814  1.00  0.00           H  
ATOM    555  HG3 PRO A  40      42.339  42.651  31.276  1.00  0.00           H  
ATOM    556  HD2 PRO A  40      42.525  44.795  32.919  1.00  0.00           H  
ATOM    557  HD3 PRO A  40      42.466  43.129  33.528  1.00  0.00           H  
ATOM    558  N   ASN A  41      45.775  45.572  31.701  1.00  0.00           N  
ATOM    559  CA  ASN A  41      46.512  46.634  31.027  1.00  0.00           C  
ATOM    560  C   ASN A  41      46.910  47.731  32.011  1.00  0.00           C  
ATOM    561  O   ASN A  41      46.256  48.770  32.097  1.00  0.00           O  
ATOM    562  CB  ASN A  41      45.670  47.229  29.897  1.00  0.00           C  
ATOM    563  CG  ASN A  41      45.018  46.163  29.038  1.00  0.00           C  
ATOM    564  OD1 ASN A  41      45.351  44.982  29.136  1.00  0.00           O  
ATOM    565  ND2 ASN A  41      44.082  46.576  28.192  1.00  0.00           N  
ATOM    566  H   ASN A  41      44.930  45.787  32.149  1.00  0.00           H  
ATOM    567  HA  ASN A  41      47.407  46.202  30.607  1.00  0.00           H  
ATOM    568  HB2 ASN A  41      44.892  47.847  30.322  1.00  0.00           H  
ATOM    569  HB3 ASN A  41      46.302  47.837  29.266  1.00  0.00           H  
ATOM    570 HD21 ASN A  41      43.868  47.531  28.168  1.00  0.00           H  
ATOM    571 HD22 ASN A  41      43.643  45.907  27.625  1.00  0.00           H  
ATOM    572  N   VAL A  42      47.986  47.491  32.753  1.00  0.00           N  
ATOM    573  CA  VAL A  42      48.473  48.458  33.730  1.00  0.00           C  
ATOM    574  C   VAL A  42      49.316  49.538  33.062  1.00  0.00           C  
ATOM    575  O   VAL A  42      49.012  50.726  33.161  1.00  0.00           O  
ATOM    576  CB  VAL A  42      49.310  47.774  34.828  1.00  0.00           C  
ATOM    577  CG1 VAL A  42      49.645  48.760  35.936  1.00  0.00           C  
ATOM    578  CG2 VAL A  42      48.573  46.564  35.383  1.00  0.00           C  
ATOM    579  H   VAL A  42      48.465  46.643  32.640  1.00  0.00           H  
ATOM    580  HA  VAL A  42      47.616  48.920  34.197  1.00  0.00           H  
ATOM    581  HB  VAL A  42      50.235  47.434  34.386  1.00  0.00           H  
ATOM    582 HG11 VAL A  42      49.007  48.573  36.788  1.00  0.00           H  
ATOM    583 HG12 VAL A  42      50.678  48.639  36.225  1.00  0.00           H  
ATOM    584 HG13 VAL A  42      49.485  49.768  35.582  1.00  0.00           H  
ATOM    585 HG21 VAL A  42      47.752  46.311  34.729  1.00  0.00           H  
ATOM    586 HG22 VAL A  42      49.253  45.728  35.448  1.00  0.00           H  
ATOM    587 HG23 VAL A  42      48.192  46.795  36.367  1.00  0.00           H  
ATOM    588  N   GLY A  43      50.376  49.115  32.380  1.00  0.00           N  
ATOM    589  CA  GLY A  43      51.247  50.059  31.705  1.00  0.00           C  
ATOM    590  C   GLY A  43      52.694  49.605  31.689  1.00  0.00           C  
ATOM    591  O   GLY A  43      53.428  49.819  32.652  1.00  0.00           O  
ATOM    592  H   GLY A  43      50.569  48.155  32.336  1.00  0.00           H  
ATOM    593  HA2 GLY A  43      50.909  50.180  30.687  1.00  0.00           H  
ATOM    594  HA3 GLY A  43      51.187  51.013  32.210  1.00  0.00           H  
ATOM    595  N   GLY A  44      53.103  48.976  30.593  1.00  0.00           N  
ATOM    596  CA  GLY A  44      54.469  48.498  30.477  1.00  0.00           C  
ATOM    597  C   GLY A  44      54.543  47.001  30.250  1.00  0.00           C  
ATOM    598  O   GLY A  44      55.593  46.472  29.890  1.00  0.00           O  
ATOM    599  H   GLY A  44      52.473  48.833  29.855  1.00  0.00           H  
ATOM    600  HA2 GLY A  44      54.946  49.001  29.650  1.00  0.00           H  
ATOM    601  HA3 GLY A  44      55.001  48.738  31.387  1.00  0.00           H  
ATOM    602  N   GLY A  45      53.424  46.316  30.463  1.00  0.00           N  
ATOM    603  CA  GLY A  45      53.388  44.877  30.275  1.00  0.00           C  
ATOM    604  C   GLY A  45      53.104  44.132  31.565  1.00  0.00           C  
ATOM    605  O   GLY A  45      53.602  43.025  31.772  1.00  0.00           O  
ATOM    606  H   GLY A  45      52.616  46.791  30.750  1.00  0.00           H  
ATOM    607  HA2 GLY A  45      52.619  44.638  29.557  1.00  0.00           H  
ATOM    608  HA3 GLY A  45      54.343  44.552  29.888  1.00  0.00           H  
ATOM    609  N   TRP A  46      52.304  44.739  32.433  1.00  0.00           N  
ATOM    610  CA  TRP A  46      51.956  44.125  33.710  1.00  0.00           C  
ATOM    611  C   TRP A  46      50.444  44.042  33.880  1.00  0.00           C  
ATOM    612  O   TRP A  46      49.690  44.693  33.154  1.00  0.00           O  
ATOM    613  CB  TRP A  46      52.569  44.920  34.865  1.00  0.00           C  
ATOM    614  CG  TRP A  46      54.065  44.845  34.909  1.00  0.00           C  
ATOM    615  CD1 TRP A  46      54.937  45.298  33.961  1.00  0.00           C  
ATOM    616  CD2 TRP A  46      54.864  44.281  35.954  1.00  0.00           C  
ATOM    617  NE1 TRP A  46      56.231  45.050  34.354  1.00  0.00           N  
ATOM    618  CE2 TRP A  46      56.213  44.427  35.574  1.00  0.00           C  
ATOM    619  CE3 TRP A  46      54.572  43.668  37.176  1.00  0.00           C  
ATOM    620  CZ2 TRP A  46      57.263  43.982  36.371  1.00  0.00           C  
ATOM    621  CZ3 TRP A  46      55.617  43.226  37.966  1.00  0.00           C  
ATOM    622  CH2 TRP A  46      56.948  43.386  37.561  1.00  0.00           C  
ATOM    623  H   TRP A  46      51.937  45.620  32.211  1.00  0.00           H  
ATOM    624  HA  TRP A  46      52.363  43.124  33.717  1.00  0.00           H  
ATOM    625  HB2 TRP A  46      52.290  45.958  34.767  1.00  0.00           H  
ATOM    626  HB3 TRP A  46      52.187  44.535  35.799  1.00  0.00           H  
ATOM    627  HD1 TRP A  46      54.639  45.778  33.040  1.00  0.00           H  
ATOM    628  HE1 TRP A  46      57.034  45.283  33.843  1.00  0.00           H  
ATOM    629  HE3 TRP A  46      53.552  43.535  37.505  1.00  0.00           H  
ATOM    630  HZ2 TRP A  46      58.296  44.098  36.073  1.00  0.00           H  
ATOM    631  HZ3 TRP A  46      55.410  42.750  38.913  1.00  0.00           H  
ATOM    632  HH2 TRP A  46      57.732  43.025  38.210  1.00  0.00           H  
ATOM    633  N   LEU A  47      50.003  43.239  34.842  1.00  0.00           N  
ATOM    634  CA  LEU A  47      48.579  43.071  35.108  1.00  0.00           C  
ATOM    635  C   LEU A  47      48.312  42.975  36.607  1.00  0.00           C  
ATOM    636  O   LEU A  47      49.165  42.527  37.370  1.00  0.00           O  
ATOM    637  CB  LEU A  47      48.053  41.819  34.404  1.00  0.00           C  
ATOM    638  CG  LEU A  47      48.604  40.484  34.906  1.00  0.00           C  
ATOM    639  CD1 LEU A  47      47.764  39.960  36.059  1.00  0.00           C  
ATOM    640  CD2 LEU A  47      48.653  39.468  33.774  1.00  0.00           C  
ATOM    641  H   LEU A  47      50.652  42.746  35.387  1.00  0.00           H  
ATOM    642  HA  LEU A  47      48.066  43.937  34.717  1.00  0.00           H  
ATOM    643  HB2 LEU A  47      46.980  41.799  34.522  1.00  0.00           H  
ATOM    644  HB3 LEU A  47      48.294  41.905  33.353  1.00  0.00           H  
ATOM    645  HG  LEU A  47      49.612  40.633  35.267  1.00  0.00           H  
ATOM    646 HD11 LEU A  47      46.813  40.470  36.073  1.00  0.00           H  
ATOM    647 HD12 LEU A  47      48.282  40.138  36.990  1.00  0.00           H  
ATOM    648 HD13 LEU A  47      47.604  38.899  35.934  1.00  0.00           H  
ATOM    649 HD21 LEU A  47      47.911  38.702  33.946  1.00  0.00           H  
ATOM    650 HD22 LEU A  47      49.633  39.019  33.736  1.00  0.00           H  
ATOM    651 HD23 LEU A  47      48.448  39.964  32.835  1.00  0.00           H  
ATOM    652  N   GLU A  48      47.121  43.399  37.019  1.00  0.00           N  
ATOM    653  CA  GLU A  48      46.742  43.358  38.425  1.00  0.00           C  
ATOM    654  C   GLU A  48      45.710  42.263  38.681  1.00  0.00           C  
ATOM    655  O   GLU A  48      44.631  42.262  38.091  1.00  0.00           O  
ATOM    656  CB  GLU A  48      46.182  44.713  38.865  1.00  0.00           C  
ATOM    657  CG  GLU A  48      46.139  44.894  40.372  1.00  0.00           C  
ATOM    658  CD  GLU A  48      45.689  46.284  40.780  1.00  0.00           C  
ATOM    659  OE1 GLU A  48      44.514  46.625  40.530  1.00  0.00           O  
ATOM    660  OE2 GLU A  48      46.513  47.029  41.351  1.00  0.00           O  
ATOM    661  H   GLU A  48      46.483  43.745  36.360  1.00  0.00           H  
ATOM    662  HA  GLU A  48      47.628  43.142  39.002  1.00  0.00           H  
ATOM    663  HB2 GLU A  48      46.796  45.496  38.446  1.00  0.00           H  
ATOM    664  HB3 GLU A  48      45.177  44.814  38.482  1.00  0.00           H  
ATOM    665  HG2 GLU A  48      45.451  44.173  40.789  1.00  0.00           H  
ATOM    666  HG3 GLU A  48      47.126  44.719  40.772  1.00  0.00           H  
ATOM    667  N   GLY A  49      46.053  41.330  39.564  1.00  0.00           N  
ATOM    668  CA  GLY A  49      45.147  40.241  39.881  1.00  0.00           C  
ATOM    669  C   GLY A  49      44.856  40.144  41.365  1.00  0.00           C  
ATOM    670  O   GLY A  49      45.655  40.581  42.193  1.00  0.00           O  
ATOM    671  H   GLY A  49      46.928  41.381  40.003  1.00  0.00           H  
ATOM    672  HA2 GLY A  49      44.219  40.393  39.351  1.00  0.00           H  
ATOM    673  HA3 GLY A  49      45.590  39.313  39.552  1.00  0.00           H  
ATOM    674  N   LYS A  50      43.707  39.569  41.704  1.00  0.00           N  
ATOM    675  CA  LYS A  50      43.310  39.415  43.099  1.00  0.00           C  
ATOM    676  C   LYS A  50      43.318  37.946  43.508  1.00  0.00           C  
ATOM    677  O   LYS A  50      43.053  37.063  42.693  1.00  0.00           O  
ATOM    678  CB  LYS A  50      41.918  40.010  43.323  1.00  0.00           C  
ATOM    679  CG  LYS A  50      41.434  39.902  44.759  1.00  0.00           C  
ATOM    680  CD  LYS A  50      40.250  40.818  45.019  1.00  0.00           C  
ATOM    681  CE  LYS A  50      38.931  40.121  44.719  1.00  0.00           C  
ATOM    682  NZ  LYS A  50      37.770  40.868  45.278  1.00  0.00           N  
ATOM    683  H   LYS A  50      43.111  39.239  41.000  1.00  0.00           H  
ATOM    684  HA  LYS A  50      44.023  39.949  43.708  1.00  0.00           H  
ATOM    685  HB2 LYS A  50      41.938  41.055  43.050  1.00  0.00           H  
ATOM    686  HB3 LYS A  50      41.213  39.494  42.688  1.00  0.00           H  
ATOM    687  HG2 LYS A  50      41.137  38.883  44.954  1.00  0.00           H  
ATOM    688  HG3 LYS A  50      42.242  40.176  45.423  1.00  0.00           H  
ATOM    689  HD2 LYS A  50      40.257  41.117  46.056  1.00  0.00           H  
ATOM    690  HD3 LYS A  50      40.337  41.693  44.390  1.00  0.00           H  
ATOM    691  HE2 LYS A  50      38.816  40.044  43.648  1.00  0.00           H  
ATOM    692  HE3 LYS A  50      38.955  39.132  45.151  1.00  0.00           H  
ATOM    693  HZ1 LYS A  50      37.008  40.206  45.529  1.00  0.00           H  
ATOM    694  HZ2 LYS A  50      37.410  41.545  44.576  1.00  0.00           H  
ATOM    695  HZ3 LYS A  50      38.057  41.390  46.130  1.00  0.00           H  
ATOM    696  N   ASN A  51      43.622  37.691  44.777  1.00  0.00           N  
ATOM    697  CA  ASN A  51      43.663  36.327  45.294  1.00  0.00           C  
ATOM    698  C   ASN A  51      42.448  36.042  46.170  1.00  0.00           C  
ATOM    699  O   ASN A  51      41.639  36.929  46.436  1.00  0.00           O  
ATOM    700  CB  ASN A  51      44.948  36.102  46.094  1.00  0.00           C  
ATOM    701  CG  ASN A  51      45.319  37.304  46.941  1.00  0.00           C  
ATOM    702  OD1 ASN A  51      44.493  38.180  47.192  1.00  0.00           O  
ATOM    703  ND2 ASN A  51      46.570  37.350  47.385  1.00  0.00           N  
ATOM    704  H   ASN A  51      43.824  38.436  45.380  1.00  0.00           H  
ATOM    705  HA  ASN A  51      43.651  35.653  44.451  1.00  0.00           H  
ATOM    706  HB2 ASN A  51      44.813  35.254  46.749  1.00  0.00           H  
ATOM    707  HB3 ASN A  51      45.760  35.899  45.411  1.00  0.00           H  
ATOM    708 HD21 ASN A  51      47.175  36.617  47.144  1.00  0.00           H  
ATOM    709 HD22 ASN A  51      46.838  38.116  47.935  1.00  0.00           H  
ATOM    710  N   ASN A  52      42.327  34.795  46.617  1.00  0.00           N  
ATOM    711  CA  ASN A  52      41.210  34.392  47.463  1.00  0.00           C  
ATOM    712  C   ASN A  52      41.122  35.273  48.705  1.00  0.00           C  
ATOM    713  O   ASN A  52      40.031  35.568  49.195  1.00  0.00           O  
ATOM    714  CB  ASN A  52      41.360  32.926  47.875  1.00  0.00           C  
ATOM    715  CG  ASN A  52      41.111  31.972  46.722  1.00  0.00           C  
ATOM    716  OD1 ASN A  52      41.065  32.383  45.563  1.00  0.00           O  
ATOM    717  ND2 ASN A  52      40.951  30.693  47.037  1.00  0.00           N  
ATOM    718  H   ASN A  52      43.004  34.131  46.370  1.00  0.00           H  
ATOM    719  HA  ASN A  52      40.302  34.504  46.890  1.00  0.00           H  
ATOM    720  HB2 ASN A  52      42.362  32.762  48.242  1.00  0.00           H  
ATOM    721  HB3 ASN A  52      40.653  32.704  48.660  1.00  0.00           H  
ATOM    722 HD21 ASN A  52      41.000  30.438  47.983  1.00  0.00           H  
ATOM    723 HD22 ASN A  52      40.789  30.054  46.311  1.00  0.00           H  
ATOM    724  N   LYS A  53      42.278  35.694  49.209  1.00  0.00           N  
ATOM    725  CA  LYS A  53      42.333  36.545  50.391  1.00  0.00           C  
ATOM    726  C   LYS A  53      41.692  37.901  50.116  1.00  0.00           C  
ATOM    727  O   LYS A  53      41.308  38.615  51.041  1.00  0.00           O  
ATOM    728  CB  LYS A  53      43.784  36.736  50.840  1.00  0.00           C  
ATOM    729  CG  LYS A  53      44.302  35.610  51.718  1.00  0.00           C  
ATOM    730  CD  LYS A  53      44.829  34.452  50.887  1.00  0.00           C  
ATOM    731  CE  LYS A  53      46.287  34.656  50.507  1.00  0.00           C  
ATOM    732  NZ  LYS A  53      46.437  35.618  49.379  1.00  0.00           N  
ATOM    733  H   LYS A  53      43.115  35.425  48.773  1.00  0.00           H  
ATOM    734  HA  LYS A  53      41.783  36.052  51.180  1.00  0.00           H  
ATOM    735  HB2 LYS A  53      44.413  36.801  49.964  1.00  0.00           H  
ATOM    736  HB3 LYS A  53      43.857  37.661  51.395  1.00  0.00           H  
ATOM    737  HG2 LYS A  53      45.102  35.988  52.337  1.00  0.00           H  
ATOM    738  HG3 LYS A  53      43.497  35.255  52.345  1.00  0.00           H  
ATOM    739  HD2 LYS A  53      44.742  33.541  51.459  1.00  0.00           H  
ATOM    740  HD3 LYS A  53      44.239  34.370  49.985  1.00  0.00           H  
ATOM    741  HE2 LYS A  53      46.820  35.035  51.366  1.00  0.00           H  
ATOM    742  HE3 LYS A  53      46.706  33.704  50.215  1.00  0.00           H  
ATOM    743  HZ1 LYS A  53      46.436  36.593  49.739  1.00  0.00           H  
ATOM    744  HZ2 LYS A  53      45.651  35.505  48.708  1.00  0.00           H  
ATOM    745  HZ3 LYS A  53      47.333  35.444  48.879  1.00  0.00           H  
ATOM    746  N   GLY A  54      41.578  38.249  48.839  1.00  0.00           N  
ATOM    747  CA  GLY A  54      40.981  39.518  48.466  1.00  0.00           C  
ATOM    748  C   GLY A  54      42.018  40.592  48.204  1.00  0.00           C  
ATOM    749  O   GLY A  54      41.675  41.728  47.878  1.00  0.00           O  
ATOM    750  H   GLY A  54      41.901  37.638  48.143  1.00  0.00           H  
ATOM    751  HA2 GLY A  54      40.390  39.378  47.573  1.00  0.00           H  
ATOM    752  HA3 GLY A  54      40.333  39.847  49.265  1.00  0.00           H  
ATOM    753  N   GLU A  55      43.290  40.232  48.348  1.00  0.00           N  
ATOM    754  CA  GLU A  55      44.380  41.175  48.128  1.00  0.00           C  
ATOM    755  C   GLU A  55      44.700  41.299  46.640  1.00  0.00           C  
ATOM    756  O   GLU A  55      44.579  40.333  45.887  1.00  0.00           O  
ATOM    757  CB  GLU A  55      45.628  40.734  48.895  1.00  0.00           C  
ATOM    758  CG  GLU A  55      45.461  40.776  50.404  1.00  0.00           C  
ATOM    759  CD  GLU A  55      45.519  42.187  50.958  1.00  0.00           C  
ATOM    760  OE1 GLU A  55      46.637  42.724  51.099  1.00  0.00           O  
ATOM    761  OE2 GLU A  55      44.445  42.753  51.251  1.00  0.00           O  
ATOM    762  H   GLU A  55      43.500  39.311  48.610  1.00  0.00           H  
ATOM    763  HA  GLU A  55      44.064  42.139  48.496  1.00  0.00           H  
ATOM    764  HB2 GLU A  55      45.874  39.723  48.608  1.00  0.00           H  
ATOM    765  HB3 GLU A  55      46.448  41.384  48.626  1.00  0.00           H  
ATOM    766  HG2 GLU A  55      44.506  40.345  50.660  1.00  0.00           H  
ATOM    767  HG3 GLU A  55      46.251  40.195  50.857  1.00  0.00           H  
ATOM    768  N   GLN A  56      45.108  42.493  46.226  1.00  0.00           N  
ATOM    769  CA  GLN A  56      45.444  42.744  44.830  1.00  0.00           C  
ATOM    770  C   GLN A  56      46.898  43.181  44.690  1.00  0.00           C  
ATOM    771  O   GLN A  56      47.387  44.004  45.463  1.00  0.00           O  
ATOM    772  CB  GLN A  56      44.520  43.812  44.244  1.00  0.00           C  
ATOM    773  CG  GLN A  56      43.162  43.276  43.820  1.00  0.00           C  
ATOM    774  CD  GLN A  56      42.073  44.329  43.881  1.00  0.00           C  
ATOM    775  OE1 GLN A  56      42.230  45.363  44.532  1.00  0.00           O  
ATOM    776  NE2 GLN A  56      40.962  44.073  43.201  1.00  0.00           N  
ATOM    777  H   GLN A  56      45.185  43.223  46.875  1.00  0.00           H  
ATOM    778  HA  GLN A  56      45.304  41.822  44.285  1.00  0.00           H  
ATOM    779  HB2 GLN A  56      44.364  44.582  44.985  1.00  0.00           H  
ATOM    780  HB3 GLN A  56      44.996  44.248  43.379  1.00  0.00           H  
ATOM    781  HG2 GLN A  56      43.233  42.912  42.805  1.00  0.00           H  
ATOM    782  HG3 GLN A  56      42.891  42.461  44.475  1.00  0.00           H  
ATOM    783 HE21 GLN A  56      40.907  43.228  42.706  1.00  0.00           H  
ATOM    784 HE22 GLN A  56      40.242  44.736  43.224  1.00  0.00           H  
ATOM    785  N   GLY A  57      47.586  42.622  43.698  1.00  0.00           N  
ATOM    786  CA  GLY A  57      48.978  42.966  43.475  1.00  0.00           C  
ATOM    787  C   GLY A  57      49.359  42.923  42.008  1.00  0.00           C  
ATOM    788  O   GLY A  57      48.640  42.349  41.189  1.00  0.00           O  
ATOM    789  H   GLY A  57      47.144  41.972  43.112  1.00  0.00           H  
ATOM    790  HA2 GLY A  57      49.157  43.962  43.853  1.00  0.00           H  
ATOM    791  HA3 GLY A  57      49.601  42.269  44.017  1.00  0.00           H  
ATOM    792  N   LEU A  58      50.492  43.530  41.675  1.00  0.00           N  
ATOM    793  CA  LEU A  58      50.967  43.560  40.295  1.00  0.00           C  
ATOM    794  C   LEU A  58      51.721  42.279  39.952  1.00  0.00           C  
ATOM    795  O   LEU A  58      52.481  41.756  40.767  1.00  0.00           O  
ATOM    796  CB  LEU A  58      51.871  44.774  40.072  1.00  0.00           C  
ATOM    797  CG  LEU A  58      51.214  46.142  40.253  1.00  0.00           C  
ATOM    798  CD1 LEU A  58      52.270  47.231  40.365  1.00  0.00           C  
ATOM    799  CD2 LEU A  58      50.265  46.434  39.100  1.00  0.00           C  
ATOM    800  H   LEU A  58      51.022  43.969  42.371  1.00  0.00           H  
ATOM    801  HA  LEU A  58      50.105  43.641  39.650  1.00  0.00           H  
ATOM    802  HB2 LEU A  58      52.692  44.706  40.770  1.00  0.00           H  
ATOM    803  HB3 LEU A  58      52.253  44.719  39.063  1.00  0.00           H  
ATOM    804  HG  LEU A  58      50.639  46.141  41.169  1.00  0.00           H  
ATOM    805 HD11 LEU A  58      52.930  47.181  39.512  1.00  0.00           H  
ATOM    806 HD12 LEU A  58      52.841  47.087  41.271  1.00  0.00           H  
ATOM    807 HD13 LEU A  58      51.789  48.197  40.392  1.00  0.00           H  
ATOM    808 HD21 LEU A  58      49.762  45.524  38.809  1.00  0.00           H  
ATOM    809 HD22 LEU A  58      50.825  46.820  38.262  1.00  0.00           H  
ATOM    810 HD23 LEU A  58      49.534  47.167  39.413  1.00  0.00           H  
ATOM    811  N   VAL A  59      51.507  41.780  38.738  1.00  0.00           N  
ATOM    812  CA  VAL A  59      52.169  40.563  38.284  1.00  0.00           C  
ATOM    813  C   VAL A  59      52.625  40.693  36.835  1.00  0.00           C  
ATOM    814  O   VAL A  59      51.919  41.230  35.983  1.00  0.00           O  
ATOM    815  CB  VAL A  59      51.242  39.340  38.412  1.00  0.00           C  
ATOM    816  CG1 VAL A  59      51.918  38.096  37.854  1.00  0.00           C  
ATOM    817  CG2 VAL A  59      50.835  39.129  39.863  1.00  0.00           C  
ATOM    818  H   VAL A  59      50.890  42.243  38.133  1.00  0.00           H  
ATOM    819  HA  VAL A  59      53.034  40.400  38.911  1.00  0.00           H  
ATOM    820  HB  VAL A  59      50.350  39.527  37.833  1.00  0.00           H  
ATOM    821 HG11 VAL A  59      52.465  38.356  36.958  1.00  0.00           H  
ATOM    822 HG12 VAL A  59      52.601  37.697  38.589  1.00  0.00           H  
ATOM    823 HG13 VAL A  59      51.170  37.355  37.616  1.00  0.00           H  
ATOM    824 HG21 VAL A  59      51.509  39.671  40.509  1.00  0.00           H  
ATOM    825 HG22 VAL A  59      49.827  39.490  40.009  1.00  0.00           H  
ATOM    826 HG23 VAL A  59      50.877  38.075  40.100  1.00  0.00           H  
ATOM    827  N   PRO A  60      53.834  40.188  36.548  1.00  0.00           N  
ATOM    828  CA  PRO A  60      54.413  40.235  35.202  1.00  0.00           C  
ATOM    829  C   PRO A  60      53.687  39.311  34.228  1.00  0.00           C  
ATOM    830  O   PRO A  60      53.639  38.097  34.427  1.00  0.00           O  
ATOM    831  CB  PRO A  60      55.852  39.760  35.418  1.00  0.00           C  
ATOM    832  CG  PRO A  60      55.794  38.922  36.647  1.00  0.00           C  
ATOM    833  CD  PRO A  60      54.730  39.533  37.516  1.00  0.00           C  
ATOM    834  HA  PRO A  60      54.417  41.239  34.807  1.00  0.00           H  
ATOM    835  HB2 PRO A  60      56.176  39.186  34.561  1.00  0.00           H  
ATOM    836  HB3 PRO A  60      56.499  40.614  35.551  1.00  0.00           H  
ATOM    837  HG2 PRO A  60      55.530  37.908  36.388  1.00  0.00           H  
ATOM    838  HG3 PRO A  60      56.749  38.946  37.151  1.00  0.00           H  
ATOM    839  HD2 PRO A  60      54.208  38.766  38.068  1.00  0.00           H  
ATOM    840  HD3 PRO A  60      55.164  40.257  38.191  1.00  0.00           H  
ATOM    841  N   THR A  61      53.125  39.895  33.174  1.00  0.00           N  
ATOM    842  CA  THR A  61      52.402  39.125  32.170  1.00  0.00           C  
ATOM    843  C   THR A  61      53.297  38.062  31.543  1.00  0.00           C  
ATOM    844  O   THR A  61      52.810  37.085  30.973  1.00  0.00           O  
ATOM    845  CB  THR A  61      51.847  40.034  31.058  1.00  0.00           C  
ATOM    846  OG1 THR A  61      52.911  40.784  30.460  1.00  0.00           O  
ATOM    847  CG2 THR A  61      50.797  40.986  31.610  1.00  0.00           C  
ATOM    848  H   THR A  61      53.197  40.867  33.072  1.00  0.00           H  
ATOM    849  HA  THR A  61      51.569  38.638  32.658  1.00  0.00           H  
ATOM    850  HB  THR A  61      51.387  39.413  30.302  1.00  0.00           H  
ATOM    851  HG1 THR A  61      53.509  40.185  30.006  1.00  0.00           H  
ATOM    852 HG21 THR A  61      50.776  40.912  32.687  1.00  0.00           H  
ATOM    853 HG22 THR A  61      49.828  40.724  31.212  1.00  0.00           H  
ATOM    854 HG23 THR A  61      51.042  41.998  31.323  1.00  0.00           H  
ATOM    855  N   ASP A  62      54.606  38.259  31.652  1.00  0.00           N  
ATOM    856  CA  ASP A  62      55.569  37.315  31.096  1.00  0.00           C  
ATOM    857  C   ASP A  62      55.575  36.012  31.891  1.00  0.00           C  
ATOM    858  O   ASP A  62      55.992  34.969  31.389  1.00  0.00           O  
ATOM    859  CB  ASP A  62      56.970  37.929  31.090  1.00  0.00           C  
ATOM    860  CG  ASP A  62      56.954  39.407  30.754  1.00  0.00           C  
ATOM    861  OD1 ASP A  62      56.296  39.782  29.761  1.00  0.00           O  
ATOM    862  OD2 ASP A  62      57.599  40.188  31.483  1.00  0.00           O  
ATOM    863  H   ASP A  62      54.933  39.057  32.118  1.00  0.00           H  
ATOM    864  HA  ASP A  62      55.276  37.101  30.080  1.00  0.00           H  
ATOM    865  HB2 ASP A  62      57.415  37.806  32.067  1.00  0.00           H  
ATOM    866  HB3 ASP A  62      57.577  37.418  30.357  1.00  0.00           H  
ATOM    867  N   TYR A  63      55.110  36.082  33.134  1.00  0.00           N  
ATOM    868  CA  TYR A  63      55.065  34.909  33.999  1.00  0.00           C  
ATOM    869  C   TYR A  63      53.745  34.162  33.835  1.00  0.00           C  
ATOM    870  O   TYR A  63      53.695  32.937  33.941  1.00  0.00           O  
ATOM    871  CB  TYR A  63      55.252  35.321  35.461  1.00  0.00           C  
ATOM    872  CG  TYR A  63      56.690  35.612  35.829  1.00  0.00           C  
ATOM    873  CD1 TYR A  63      57.374  36.674  35.249  1.00  0.00           C  
ATOM    874  CD2 TYR A  63      57.363  34.826  36.754  1.00  0.00           C  
ATOM    875  CE1 TYR A  63      58.688  36.943  35.581  1.00  0.00           C  
ATOM    876  CE2 TYR A  63      58.676  35.089  37.093  1.00  0.00           C  
ATOM    877  CZ  TYR A  63      59.334  36.148  36.504  1.00  0.00           C  
ATOM    878  OH  TYR A  63      60.642  36.413  36.838  1.00  0.00           O  
ATOM    879  H   TYR A  63      54.792  36.942  33.478  1.00  0.00           H  
ATOM    880  HA  TYR A  63      55.874  34.254  33.713  1.00  0.00           H  
ATOM    881  HB2 TYR A  63      54.674  36.211  35.654  1.00  0.00           H  
ATOM    882  HB3 TYR A  63      54.900  34.524  36.100  1.00  0.00           H  
ATOM    883  HD1 TYR A  63      56.864  37.294  34.526  1.00  0.00           H  
ATOM    884  HD2 TYR A  63      56.846  33.996  37.214  1.00  0.00           H  
ATOM    885  HE1 TYR A  63      59.203  37.773  35.120  1.00  0.00           H  
ATOM    886  HE2 TYR A  63      59.184  34.466  37.816  1.00  0.00           H  
ATOM    887  HH  TYR A  63      60.670  36.884  37.675  1.00  0.00           H  
ATOM    888  N   VAL A  64      52.677  34.910  33.575  1.00  0.00           N  
ATOM    889  CA  VAL A  64      51.357  34.320  33.393  1.00  0.00           C  
ATOM    890  C   VAL A  64      50.762  34.707  32.045  1.00  0.00           C  
ATOM    891  O   VAL A  64      50.825  35.867  31.637  1.00  0.00           O  
ATOM    892  CB  VAL A  64      50.389  34.754  34.512  1.00  0.00           C  
ATOM    893  CG1 VAL A  64      51.075  34.682  35.868  1.00  0.00           C  
ATOM    894  CG2 VAL A  64      49.862  36.155  34.245  1.00  0.00           C  
ATOM    895  H   VAL A  64      52.781  35.882  33.503  1.00  0.00           H  
ATOM    896  HA  VAL A  64      51.462  33.245  33.435  1.00  0.00           H  
ATOM    897  HB  VAL A  64      49.551  34.072  34.520  1.00  0.00           H  
ATOM    898 HG11 VAL A  64      51.818  35.462  35.937  1.00  0.00           H  
ATOM    899 HG12 VAL A  64      50.341  34.811  36.650  1.00  0.00           H  
ATOM    900 HG13 VAL A  64      51.553  33.720  35.979  1.00  0.00           H  
ATOM    901 HG21 VAL A  64      49.247  36.146  33.358  1.00  0.00           H  
ATOM    902 HG22 VAL A  64      49.273  36.484  35.089  1.00  0.00           H  
ATOM    903 HG23 VAL A  64      50.691  36.831  34.101  1.00  0.00           H  
ATOM    904  N   GLU A  65      50.185  33.728  31.355  1.00  0.00           N  
ATOM    905  CA  GLU A  65      49.578  33.967  30.050  1.00  0.00           C  
ATOM    906  C   GLU A  65      48.056  33.900  30.136  1.00  0.00           C  
ATOM    907  O   GLU A  65      47.478  32.822  30.273  1.00  0.00           O  
ATOM    908  CB  GLU A  65      50.087  32.945  29.032  1.00  0.00           C  
ATOM    909  CG  GLU A  65      49.412  33.049  27.675  1.00  0.00           C  
ATOM    910  CD  GLU A  65      49.977  34.172  26.827  1.00  0.00           C  
ATOM    911  OE1 GLU A  65      51.106  34.022  26.318  1.00  0.00           O  
ATOM    912  OE2 GLU A  65      49.287  35.203  26.672  1.00  0.00           O  
ATOM    913  H   GLU A  65      50.166  32.824  31.733  1.00  0.00           H  
ATOM    914  HA  GLU A  65      49.866  34.956  29.728  1.00  0.00           H  
ATOM    915  HB2 GLU A  65      51.150  33.089  28.895  1.00  0.00           H  
ATOM    916  HB3 GLU A  65      49.916  31.952  29.421  1.00  0.00           H  
ATOM    917  HG2 GLU A  65      49.547  32.118  27.147  1.00  0.00           H  
ATOM    918  HG3 GLU A  65      48.357  33.227  27.826  1.00  0.00           H  
ATOM    919  N   ILE A  66      47.414  35.061  30.058  1.00  0.00           N  
ATOM    920  CA  ILE A  66      45.960  35.135  30.127  1.00  0.00           C  
ATOM    921  C   ILE A  66      45.314  34.117  29.194  1.00  0.00           C  
ATOM    922  O   ILE A  66      45.772  33.909  28.070  1.00  0.00           O  
ATOM    923  CB  ILE A  66      45.450  36.543  29.764  1.00  0.00           C  
ATOM    924  CG1 ILE A  66      45.948  37.567  30.785  1.00  0.00           C  
ATOM    925  CG2 ILE A  66      43.931  36.553  29.692  1.00  0.00           C  
ATOM    926  CD1 ILE A  66      45.629  38.998  30.411  1.00  0.00           C  
ATOM    927  H   ILE A  66      47.930  35.887  29.950  1.00  0.00           H  
ATOM    928  HA  ILE A  66      45.664  34.916  31.142  1.00  0.00           H  
ATOM    929  HB  ILE A  66      45.834  36.800  28.789  1.00  0.00           H  
ATOM    930 HG12 ILE A  66      45.491  37.365  31.741  1.00  0.00           H  
ATOM    931 HG13 ILE A  66      47.020  37.479  30.878  1.00  0.00           H  
ATOM    932 HG21 ILE A  66      43.573  37.568  29.783  1.00  0.00           H  
ATOM    933 HG22 ILE A  66      43.612  36.144  28.746  1.00  0.00           H  
ATOM    934 HG23 ILE A  66      43.527  35.957  30.498  1.00  0.00           H  
ATOM    935 HD11 ILE A  66      45.024  39.009  29.515  1.00  0.00           H  
ATOM    936 HD12 ILE A  66      45.086  39.469  31.217  1.00  0.00           H  
ATOM    937 HD13 ILE A  66      46.546  39.536  30.230  1.00  0.00           H  
ATOM    938  N   LEU A  67      44.244  33.485  29.667  1.00  0.00           N  
ATOM    939  CA  LEU A  67      43.532  32.489  28.875  1.00  0.00           C  
ATOM    940  C   LEU A  67      42.265  33.082  28.265  1.00  0.00           C  
ATOM    941  O   LEU A  67      41.585  33.911  28.870  1.00  0.00           O  
ATOM    942  CB  LEU A  67      43.177  31.279  29.741  1.00  0.00           C  
ATOM    943  CG  LEU A  67      44.356  30.513  30.340  1.00  0.00           C  
ATOM    944  CD1 LEU A  67      43.867  29.483  31.348  1.00  0.00           C  
ATOM    945  CD2 LEU A  67      45.170  29.844  29.244  1.00  0.00           C  
ATOM    946  H   LEU A  67      43.926  33.693  30.570  1.00  0.00           H  
ATOM    947  HA  LEU A  67      44.186  32.171  28.077  1.00  0.00           H  
ATOM    948  HB2 LEU A  67      42.559  31.626  30.555  1.00  0.00           H  
ATOM    949  HB3 LEU A  67      42.610  30.591  29.130  1.00  0.00           H  
ATOM    950  HG  LEU A  67      45.000  31.208  30.861  1.00  0.00           H  
ATOM    951 HD11 LEU A  67      42.927  29.808  31.767  1.00  0.00           H  
ATOM    952 HD12 LEU A  67      44.597  29.376  32.137  1.00  0.00           H  
ATOM    953 HD13 LEU A  67      43.731  28.532  30.853  1.00  0.00           H  
ATOM    954 HD21 LEU A  67      44.601  29.032  28.816  1.00  0.00           H  
ATOM    955 HD22 LEU A  67      46.089  29.459  29.662  1.00  0.00           H  
ATOM    956 HD23 LEU A  67      45.400  30.567  28.474  1.00  0.00           H  
ATOM    957  N   PRO A  68      41.940  32.647  27.039  1.00  0.00           N  
ATOM    958  CA  PRO A  68      40.752  33.120  26.321  1.00  0.00           C  
ATOM    959  C   PRO A  68      39.457  32.618  26.951  1.00  0.00           C  
ATOM    960  O   PRO A  68      39.475  31.747  27.819  1.00  0.00           O  
ATOM    961  CB  PRO A  68      40.927  32.532  24.919  1.00  0.00           C  
ATOM    962  CG  PRO A  68      41.784  31.329  25.116  1.00  0.00           C  
ATOM    963  CD  PRO A  68      42.704  31.660  26.259  1.00  0.00           C  
ATOM    964  HA  PRO A  68      40.727  34.198  26.262  1.00  0.00           H  
ATOM    965  HB2 PRO A  68      39.961  32.268  24.514  1.00  0.00           H  
ATOM    966  HB3 PRO A  68      41.407  33.257  24.278  1.00  0.00           H  
ATOM    967  HG2 PRO A  68      41.170  30.478  25.364  1.00  0.00           H  
ATOM    968  HG3 PRO A  68      42.355  31.135  24.220  1.00  0.00           H  
ATOM    969  HD2 PRO A  68      42.909  30.778  26.847  1.00  0.00           H  
ATOM    970  HD3 PRO A  68      43.624  32.090  25.890  1.00  0.00           H  
ATOM    971  N   ASN A  69      38.334  33.174  26.506  1.00  0.00           N  
ATOM    972  CA  ASN A  69      37.029  32.782  27.026  1.00  0.00           C  
ATOM    973  C   ASN A  69      36.223  32.034  25.969  1.00  0.00           C  
ATOM    974  O   ASN A  69      36.672  31.870  24.834  1.00  0.00           O  
ATOM    975  CB  ASN A  69      36.254  34.015  27.497  1.00  0.00           C  
ATOM    976  CG  ASN A  69      37.134  35.006  28.231  1.00  0.00           C  
ATOM    977  OD1 ASN A  69      38.199  34.652  28.737  1.00  0.00           O  
ATOM    978  ND2 ASN A  69      36.693  36.257  28.294  1.00  0.00           N  
ATOM    979  H   ASN A  69      38.384  33.864  25.812  1.00  0.00           H  
ATOM    980  HA  ASN A  69      37.192  32.127  27.869  1.00  0.00           H  
ATOM    981  HB2 ASN A  69      35.824  34.511  26.640  1.00  0.00           H  
ATOM    982  HB3 ASN A  69      35.462  33.702  28.161  1.00  0.00           H  
ATOM    983 HD21 ASN A  69      35.835  36.467  27.868  1.00  0.00           H  
ATOM    984 HD22 ASN A  69      37.243  36.919  28.762  1.00  0.00           H  
ATOM    985  N   ASP A  70      35.034  31.583  26.348  1.00  0.00           N  
ATOM    986  CA  ASP A  70      34.164  30.854  25.432  1.00  0.00           C  
ATOM    987  C   ASP A  70      33.779  31.724  24.239  1.00  0.00           C  
ATOM    988  O   ASP A  70      32.882  32.559  24.332  1.00  0.00           O  
ATOM    989  CB  ASP A  70      32.905  30.379  26.159  1.00  0.00           C  
ATOM    990  CG  ASP A  70      31.832  29.895  25.204  1.00  0.00           C  
ATOM    991  OD1 ASP A  70      32.027  28.826  24.587  1.00  0.00           O  
ATOM    992  OD2 ASP A  70      30.798  30.583  25.073  1.00  0.00           O  
ATOM    993  H   ASP A  70      34.732  31.746  27.267  1.00  0.00           H  
ATOM    994  HA  ASP A  70      34.708  29.993  25.074  1.00  0.00           H  
ATOM    995  HB2 ASP A  70      33.165  29.566  26.822  1.00  0.00           H  
ATOM    996  HB3 ASP A  70      32.503  31.196  26.740  1.00  0.00           H  
ATOM    997  N   GLY A  71      34.467  31.521  23.120  1.00  0.00           N  
ATOM    998  CA  GLY A  71      34.184  32.296  21.925  1.00  0.00           C  
ATOM    999  C   GLY A  71      32.941  31.814  21.204  1.00  0.00           C  
ATOM   1000  O   GLY A  71      32.570  30.645  21.301  1.00  0.00           O  
ATOM   1001  H   GLY A  71      35.173  30.841  23.104  1.00  0.00           H  
ATOM   1002  HA2 GLY A  71      34.049  33.330  22.203  1.00  0.00           H  
ATOM   1003  HA3 GLY A  71      35.027  32.220  21.254  1.00  0.00           H  
ATOM   1004  N   LYS A  72      32.292  32.719  20.477  1.00  0.00           N  
ATOM   1005  CA  LYS A  72      31.083  32.382  19.737  1.00  0.00           C  
ATOM   1006  C   LYS A  72      31.154  30.957  19.198  1.00  0.00           C  
ATOM   1007  O   LYS A  72      31.961  30.656  18.317  1.00  0.00           O  
ATOM   1008  CB  LYS A  72      30.876  33.366  18.583  1.00  0.00           C  
ATOM   1009  CG  LYS A  72      29.740  32.981  17.652  1.00  0.00           C  
ATOM   1010  CD  LYS A  72      29.580  33.985  16.522  1.00  0.00           C  
ATOM   1011  CE  LYS A  72      30.612  33.761  15.427  1.00  0.00           C  
ATOM   1012  NZ  LYS A  72      30.302  32.554  14.611  1.00  0.00           N  
ATOM   1013  H   LYS A  72      32.637  33.637  20.439  1.00  0.00           H  
ATOM   1014  HA  LYS A  72      30.247  32.456  20.415  1.00  0.00           H  
ATOM   1015  HB2 LYS A  72      30.664  34.342  18.991  1.00  0.00           H  
ATOM   1016  HB3 LYS A  72      31.787  33.418  18.003  1.00  0.00           H  
ATOM   1017  HG2 LYS A  72      29.947  32.009  17.228  1.00  0.00           H  
ATOM   1018  HG3 LYS A  72      28.821  32.940  18.217  1.00  0.00           H  
ATOM   1019  HD2 LYS A  72      28.593  33.882  16.097  1.00  0.00           H  
ATOM   1020  HD3 LYS A  72      29.700  34.983  16.920  1.00  0.00           H  
ATOM   1021  HE2 LYS A  72      30.627  34.626  14.782  1.00  0.00           H  
ATOM   1022  HE3 LYS A  72      31.582  33.636  15.884  1.00  0.00           H  
ATOM   1023  HZ1 LYS A  72      30.486  32.745  13.606  1.00  0.00           H  
ATOM   1024  HZ2 LYS A  72      29.302  32.292  14.727  1.00  0.00           H  
ATOM   1025  HZ3 LYS A  72      30.894  31.755  14.916  1.00  0.00           H  
ATOM   1026  N   ASP A  73      30.305  30.084  19.729  1.00  0.00           N  
ATOM   1027  CA  ASP A  73      30.270  28.692  19.299  1.00  0.00           C  
ATOM   1028  C   ASP A  73      29.908  28.588  17.821  1.00  0.00           C  
ATOM   1029  O   ASP A  73      29.125  29.377  17.292  1.00  0.00           O  
ATOM   1030  CB  ASP A  73      29.266  27.901  20.140  1.00  0.00           C  
ATOM   1031  CG  ASP A  73      27.867  27.939  19.558  1.00  0.00           C  
ATOM   1032  OD1 ASP A  73      27.540  27.052  18.740  1.00  0.00           O  
ATOM   1033  OD2 ASP A  73      27.098  28.854  19.919  1.00  0.00           O  
ATOM   1034  H   ASP A  73      29.686  30.385  20.428  1.00  0.00           H  
ATOM   1035  HA  ASP A  73      31.256  28.275  19.446  1.00  0.00           H  
ATOM   1036  HB2 ASP A  73      29.586  26.870  20.196  1.00  0.00           H  
ATOM   1037  HB3 ASP A  73      29.234  28.318  21.136  1.00  0.00           H  
ATOM   1038  N   PRO A  74      30.491  27.593  17.137  1.00  0.00           N  
ATOM   1039  CA  PRO A  74      30.245  27.363  15.711  1.00  0.00           C  
ATOM   1040  C   PRO A  74      28.834  26.854  15.440  1.00  0.00           C  
ATOM   1041  O   PRO A  74      28.218  26.218  16.296  1.00  0.00           O  
ATOM   1042  CB  PRO A  74      31.279  26.297  15.339  1.00  0.00           C  
ATOM   1043  CG  PRO A  74      31.563  25.583  16.617  1.00  0.00           C  
ATOM   1044  CD  PRO A  74      31.435  26.615  17.704  1.00  0.00           C  
ATOM   1045  HA  PRO A  74      30.422  28.256  15.129  1.00  0.00           H  
ATOM   1046  HB2 PRO A  74      30.862  25.630  14.598  1.00  0.00           H  
ATOM   1047  HB3 PRO A  74      32.166  26.771  14.947  1.00  0.00           H  
ATOM   1048  HG2 PRO A  74      30.843  24.793  16.763  1.00  0.00           H  
ATOM   1049  HG3 PRO A  74      32.565  25.182  16.598  1.00  0.00           H  
ATOM   1050  HD2 PRO A  74      31.035  26.169  18.602  1.00  0.00           H  
ATOM   1051  HD3 PRO A  74      32.392  27.075  17.902  1.00  0.00           H  
ATOM   1052  N   PHE A  75      28.327  27.134  14.244  1.00  0.00           N  
ATOM   1053  CA  PHE A  75      26.987  26.705  13.862  1.00  0.00           C  
ATOM   1054  C   PHE A  75      26.902  25.183  13.795  1.00  0.00           C  
ATOM   1055  O   PHE A  75      27.911  24.488  13.918  1.00  0.00           O  
ATOM   1056  CB  PHE A  75      26.602  27.309  12.509  1.00  0.00           C  
ATOM   1057  CG  PHE A  75      25.124  27.525  12.349  1.00  0.00           C  
ATOM   1058  CD1 PHE A  75      24.503  28.617  12.936  1.00  0.00           C  
ATOM   1059  CD2 PHE A  75      24.356  26.638  11.612  1.00  0.00           C  
ATOM   1060  CE1 PHE A  75      23.144  28.818  12.790  1.00  0.00           C  
ATOM   1061  CE2 PHE A  75      22.996  26.836  11.464  1.00  0.00           C  
ATOM   1062  CZ  PHE A  75      22.390  27.927  12.052  1.00  0.00           C  
ATOM   1063  H   PHE A  75      28.866  27.645  13.604  1.00  0.00           H  
ATOM   1064  HA  PHE A  75      26.299  27.059  14.614  1.00  0.00           H  
ATOM   1065  HB2 PHE A  75      27.091  28.264  12.398  1.00  0.00           H  
ATOM   1066  HB3 PHE A  75      26.928  26.646  11.722  1.00  0.00           H  
ATOM   1067  HD1 PHE A  75      25.092  29.316  13.512  1.00  0.00           H  
ATOM   1068  HD2 PHE A  75      24.829  25.784  11.150  1.00  0.00           H  
ATOM   1069  HE1 PHE A  75      22.672  29.673  13.251  1.00  0.00           H  
ATOM   1070  HE2 PHE A  75      22.409  26.137  10.886  1.00  0.00           H  
ATOM   1071  HZ  PHE A  75      21.327  28.084  11.937  1.00  0.00           H  
ATOM   1072  N   SER A  76      25.691  24.671  13.599  1.00  0.00           N  
ATOM   1073  CA  SER A  76      25.473  23.232  13.521  1.00  0.00           C  
ATOM   1074  C   SER A  76      26.497  22.577  12.599  1.00  0.00           C  
ATOM   1075  O   SER A  76      26.484  22.791  11.386  1.00  0.00           O  
ATOM   1076  CB  SER A  76      24.058  22.936  13.021  1.00  0.00           C  
ATOM   1077  OG  SER A  76      23.710  21.581  13.248  1.00  0.00           O  
ATOM   1078  H   SER A  76      24.926  25.277  13.508  1.00  0.00           H  
ATOM   1079  HA  SER A  76      25.588  22.824  14.514  1.00  0.00           H  
ATOM   1080  HB2 SER A  76      23.355  23.568  13.542  1.00  0.00           H  
ATOM   1081  HB3 SER A  76      24.004  23.136  11.960  1.00  0.00           H  
ATOM   1082  HG  SER A  76      23.917  21.061  12.467  1.00  0.00           H  
ATOM   1083  N   CYS A  77      27.383  21.778  13.183  1.00  0.00           N  
ATOM   1084  CA  CYS A  77      28.416  21.091  12.415  1.00  0.00           C  
ATOM   1085  C   CYS A  77      27.805  20.021  11.516  1.00  0.00           C  
ATOM   1086  O   CYS A  77      27.788  20.159  10.294  1.00  0.00           O  
ATOM   1087  CB  CYS A  77      29.444  20.458  13.355  1.00  0.00           C  
ATOM   1088  SG  CYS A  77      28.740  19.283  14.535  1.00  0.00           S  
ATOM   1089  H   CYS A  77      27.343  21.646  14.153  1.00  0.00           H  
ATOM   1090  HA  CYS A  77      28.910  21.824  11.796  1.00  0.00           H  
ATOM   1091  HB2 CYS A  77      30.181  19.932  12.767  1.00  0.00           H  
ATOM   1092  HB3 CYS A  77      29.933  21.240  13.919  1.00  0.00           H  
ATOM   1093  HG  CYS A  77      29.636  18.331  14.745  1.00  0.00           H  
TER    1094      CYS A  77                                                      
END
MOLECULE T0487_178_265.pdb
ATOM   1389  N   SER   178      50.886  32.816  25.767  1.00 72.79           N  
ATOM   1390  CA  SER   178      50.904  33.757  26.889  1.00 70.07           C  
ATOM   1391  C   SER   178      49.706  34.705  26.864  1.00 68.01           C  
ATOM   1392  O   SER   178      49.068  34.887  25.828  1.00 67.65           O  
ATOM   1393  CB  SER   178      52.174  34.607  26.842  1.00 70.56           C  
ATOM   1394  OG  SER   178      51.942  35.805  26.101  1.00 69.80           O  
ATOM   1395  N   LEU   179      49.423  35.323  28.008  1.00 65.44           N  
ATOM   1396  CA  LEU   179      48.324  36.270  28.111  1.00 64.41           C  
ATOM   1397  C   LEU   179      48.681  37.485  27.264  1.00 65.44           C  
ATOM   1398  O   LEU   179      47.803  38.213  26.811  1.00 64.49           O  
ATOM   1399  CB  LEU   179      48.133  36.706  29.564  1.00 63.05           C  
ATOM   1400  CG  LEU   179      46.806  37.324  30.046  1.00 63.07           C  
ATOM   1401  CD1 LEU   179      47.061  38.669  30.666  1.00 59.96           C  
ATOM   1402  CD2 LEU   179      45.810  37.439  28.911  1.00 63.32           C  
ATOM   1403  N   GLU   180      49.979  37.711  27.072  1.00 66.94           N  
ATOM   1404  CA  GLU   180      50.451  38.838  26.277  1.00 68.35           C  
ATOM   1405  C   GLU   180      50.122  38.532  24.826  1.00 69.37           C  
ATOM   1406  O   GLU   180      49.522  39.351  24.124  1.00 69.29           O  
ATOM   1407  CB  GLU   180      51.968  39.021  26.433  1.00 69.56           C  
ATOM   1408  CG  GLU   180      52.578  40.133  25.564  1.00 68.16           C  
ATOM   1409  CD  GLU   180      51.789  41.432  25.644  1.00 70.51           C  
ATOM   1410  OE1 GLU   180      51.352  41.804  26.751  1.00 71.02           O  
ATOM   1411  OE2 GLU   180      51.606  42.095  24.601  1.00 72.24           O  
ATOM   1412  N   ALA   181      50.509  37.339  24.387  1.00 68.86           N  
ATOM   1413  CA  ALA   181      50.246  36.915  23.020  1.00 68.70           C  
ATOM   1414  C   ALA   181      48.751  36.958  22.734  1.00 68.21           C  
ATOM   1415  O   ALA   181      48.298  37.630  21.811  1.00 67.78           O  
ATOM   1416  CB  ALA   181      50.778  35.493  22.799  1.00 68.81           C  
ATOM   1417  N   TRP   182      47.990  36.245  23.554  1.00 67.73           N  
ATOM   1418  CA  TRP   182      46.554  36.156  23.382  1.00 67.32           C  
ATOM   1419  C   TRP   182      45.879  37.511  23.267  1.00 66.70           C  
ATOM   1420  O   TRP   182      45.005  37.712  22.425  1.00 64.93           O  
ATOM   1421  CB  TRP   182      45.951  35.379  24.545  1.00 66.80           C  
ATOM   1422  CG  TRP   182      44.717  34.606  24.192  1.00 66.97           C  
ATOM   1423  CD1 TRP   182      44.627  33.513  23.363  1.00 67.71           C  
ATOM   1424  CD2 TRP   182      43.412  34.821  24.711  1.00 65.75           C  
ATOM   1425  NE1 TRP   182      43.337  33.031  23.348  1.00 66.31           N  
ATOM   1426  CE2 TRP   182      42.571  33.818  24.167  1.00 66.78           C  
ATOM   1427  CE3 TRP   182      42.866  35.761  25.585  1.00 65.78           C  
ATOM   1428  CZ2 TRP   182      41.213  33.734  24.476  1.00 68.00           C  
ATOM   1429  CZ3 TRP   182      41.513  35.680  25.893  1.00 68.30           C  
ATOM   1430  CH2 TRP   182      40.700  34.673  25.340  1.00 69.32           C  
ATOM   1431  N   LEU   183      46.271  38.438  24.128  1.00 67.37           N  
ATOM   1432  CA  LEU   183      45.668  39.763  24.101  1.00 68.70           C  
ATOM   1433  C   LEU   183      46.163  40.567  22.902  1.00 70.28           C  
ATOM   1434  O   LEU   183      45.409  41.379  22.354  1.00 70.00           O  
ATOM   1435  CB  LEU   183      45.960  40.523  25.397  1.00 65.92           C  
ATOM   1436  CG  LEU   183      45.158  40.159  26.643  1.00 64.80           C  
ATOM   1437  CD1 LEU   183      45.737  40.878  27.843  1.00 65.61           C  
ATOM   1438  CD2 LEU   183      43.717  40.543  26.469  1.00 63.29           C  
ATOM   1439  N   ALA   184      47.418  40.344  22.498  1.00 70.51           N  
ATOM   1440  CA  ALA   184      47.986  41.054  21.353  1.00 70.65           C  
ATOM   1441  C   ALA   184      47.157  40.725  20.112  1.00 72.14           C  
ATOM   1442  O   ALA   184      46.811  41.613  19.322  1.00 74.22           O  
ATOM   1443  CB  ALA   184      49.439  40.642  21.128  1.00 67.57           C  
ATOM   1444  N   GLN   185      46.823  39.448  19.959  1.00 71.41           N  
ATOM   1445  CA  GLN   185      46.055  38.988  18.822  1.00 70.02           C  
ATOM   1446  C   GLN   185      44.571  39.360  18.885  1.00 70.30           C  
ATOM   1447  O   GLN   185      43.754  38.814  18.140  1.00 72.30           O  
ATOM   1448  CB  GLN   185      46.250  37.478  18.668  1.00 70.34           C  
ATOM   1449  CG  GLN   185      47.700  37.106  18.314  1.00 71.08           C  
ATOM   1450  CD  GLN   185      48.049  35.632  18.569  1.00 73.18           C  
ATOM   1451  OE1 GLN   185      47.240  34.728  18.313  1.00 75.02           O  
ATOM   1452  NE2 GLN   185      49.270  35.386  19.059  1.00 70.57           N  
ATOM   1453  N   GLY   186      44.220  40.280  19.780  1.00 69.12           N  
ATOM   1454  CA  GLY   186      42.842  40.736  19.865  1.00 68.35           C  
ATOM   1455  C   GLY   186      41.785  40.064  20.725  1.00 68.79           C  
ATOM   1456  O   GLY   186      40.698  40.631  20.863  1.00 68.00           O  
ATOM   1457  N   HIS   187      42.061  38.888  21.297  1.00 70.02           N  
ATOM   1458  CA  HIS   187      41.061  38.198  22.133  1.00 70.95           C  
ATOM   1459  C   HIS   187      40.753  38.993  23.388  1.00 70.80           C  
ATOM   1460  O   HIS   187      41.644  39.608  23.966  1.00 72.87           O  
ATOM   1461  CB  HIS   187      41.548  36.818  22.568  1.00 72.13           C  
ATOM   1462  CG  HIS   187      41.837  35.881  21.435  1.00 75.45           C  
ATOM   1463  ND1 HIS   187      43.103  35.712  20.912  1.00 76.97           N  
ATOM   1464  CD2 HIS   187      41.031  35.032  20.752  1.00 75.28           C  
ATOM   1465  CE1 HIS   187      43.065  34.798  19.957  1.00 77.65           C  
ATOM   1466  NE2 HIS   187      41.820  34.370  19.841  1.00 77.28           N  
ATOM   1467  N   PRO   188      39.493  38.976  23.844  1.00 69.33           N  
ATOM   1468  CA  PRO   188      39.108  39.717  25.047  1.00 68.82           C  
ATOM   1469  C   PRO   188      39.831  39.288  26.332  1.00 69.05           C  
ATOM   1470  O   PRO   188      40.532  38.273  26.377  1.00 67.98           O  
ATOM   1471  CB  PRO   188      37.607  39.483  25.122  1.00 67.89           C  
ATOM   1472  CG  PRO   188      37.476  38.105  24.590  1.00 68.52           C  
ATOM   1473  CD  PRO   188      38.377  38.142  23.373  1.00 69.36           C  
ATOM   1474  N   LEU   189      39.631  40.088  27.375  1.00 69.24           N  
ATOM   1475  CA  LEU   189      40.226  39.893  28.694  1.00 68.26           C  
ATOM   1476  C   LEU   189      39.519  38.753  29.426  1.00 67.78           C  
ATOM   1477  O   LEU   189      38.325  38.853  29.703  1.00 67.72           O  
ATOM   1478  CB  LEU   189      40.048  41.184  29.487  1.00 68.50           C  
ATOM   1479  CG  LEU   189      41.061  41.714  30.495  1.00 69.40           C  
ATOM   1480  CD1 LEU   189      42.320  42.193  29.785  1.00 68.24           C  
ATOM   1481  CD2 LEU   189      40.423  42.861  31.252  1.00 69.17           C  
ATOM   1482  N   PRO   190      40.238  37.653  29.738  1.00 66.51           N  
ATOM   1483  CA  PRO   190      39.635  36.518  30.445  1.00 66.30           C  
ATOM   1484  C   PRO   190      39.386  36.844  31.906  1.00 65.77           C  
ATOM   1485  O   PRO   190      39.913  37.815  32.442  1.00 64.95           O  
ATOM   1486  CB  PRO   190      40.659  35.409  30.259  1.00 65.74           C  
ATOM   1487  CG  PRO   190      41.934  36.142  30.209  1.00 65.98           C  
ATOM   1488  CD  PRO   190      41.608  37.323  29.323  1.00 66.24           C  
ATOM   1489  N   LYS   191      38.574  36.029  32.555  1.00 66.90           N  
ATOM   1490  CA  LYS   191      38.252  36.281  33.940  1.00 68.59           C  
ATOM   1491  C   LYS   191      39.385  35.895  34.877  1.00 69.54           C  
ATOM   1492  O   LYS   191      39.714  36.611  35.811  1.00 69.46           O  
ATOM   1493  CB  LYS   191      36.971  35.507  34.339  1.00 66.50           C  
ATOM   1494  N   ARG   192      40.013  34.775  34.579  1.00 71.25           N  
ATOM   1495  CA  ARG   192      41.003  34.185  35.433  1.00 72.21           C  
ATOM   1496  C   ARG   192      42.272  33.878  34.698  1.00 71.41           C  
ATOM   1497  O   ARG   192      42.220  33.436  33.559  1.00 70.49           O  
ATOM   1498  CB  ARG   192      40.461  32.862  35.897  1.00 73.81           C  
ATOM   1499  CG  ARG   192      40.240  32.724  37.306  1.00 77.12           C  
ATOM   1500  CD  ARG   192      38.931  33.293  37.700  1.00 79.09           C  
ATOM   1501  NE  ARG   192      38.792  32.976  39.096  1.00 83.42           N  
ATOM   1502  CZ  ARG   192      38.232  33.757  40.002  1.00 85.75           C  
ATOM   1503  NH1 ARG   192      37.744  34.933  39.637  1.00 85.86           N  
ATOM   1504  NH2 ARG   192      38.175  33.346  41.272  1.00 86.41           N  
ATOM   1505  N   VAL   193      43.405  34.036  35.376  1.00 70.67           N  
ATOM   1506  CA  VAL   193      44.691  33.778  34.753  1.00 69.01           C  
ATOM   1507  C   VAL   193      45.496  32.785  35.566  1.00 68.15           C  
ATOM   1508  O   VAL   193      45.343  32.710  36.774  1.00 69.21           O  
ATOM   1509  CB  VAL   193      45.483  35.071  34.630  1.00 69.25           C  
ATOM   1510  CG1 VAL   193      46.781  34.825  33.918  1.00 71.90           C  
ATOM   1511  CG2 VAL   193      44.654  36.096  33.902  1.00 68.33           C  
ATOM   1512  N   ARG   194      46.379  32.039  34.916  1.00 67.11           N  
ATOM   1513  CA  ARG   194      47.211  31.081  35.619  1.00 66.36           C  
ATOM   1514  C   ARG   194      48.648  31.524  35.461  1.00 66.04           C  
ATOM   1515  O   ARG   194      48.986  32.188  34.495  1.00 66.50           O  
ATOM   1516  CB  ARG   194      47.041  29.706  35.003  1.00 68.43           C  
ATOM   1517  CG  ARG   194      47.425  28.562  35.902  1.00 71.86           C  
ATOM   1518  CD  ARG   194      48.589  27.803  35.321  1.00 76.27           C  
ATOM   1519  NE  ARG   194      48.386  27.429  33.922  1.00 80.71           N  
ATOM   1520  CZ  ARG   194      49.372  27.027  33.117  1.00 84.44           C  
ATOM   1521  NH1 ARG   194      50.617  26.949  33.581  1.00 85.78           N  
ATOM   1522  NH2 ARG   194      49.128  26.718  31.846  1.00 85.83           N  
ATOM   1523  N   ASN   195      49.496  31.182  36.421  1.00 65.91           N  
ATOM   1524  CA  ASN   195      50.898  31.535  36.310  1.00 64.68           C  
ATOM   1525  C   ASN   195      51.400  30.608  35.223  1.00 63.81           C  
ATOM   1526  O   ASN   195      50.868  29.512  35.058  1.00 62.14           O  
ATOM   1527  CB  ASN   195      51.664  31.234  37.606  1.00 65.09           C  
ATOM   1528  CG  ASN   195      51.538  32.338  38.641  1.00 66.86           C  
ATOM   1529  OD1 ASN   195      51.062  33.438  38.350  1.00 66.81           O  
ATOM   1530  ND2 ASN   195      51.982  32.051  39.858  1.00 66.69           N  
ATOM   1531  N   ALA   196      52.412  31.040  34.478  1.00 63.13           N  
ATOM   1532  CA  ALA   196      52.977  30.189  33.435  1.00 62.64           C  
ATOM   1533  C   ALA   196      53.970  29.213  34.062  1.00 62.41           C  
ATOM   1534  O   ALA   196      54.076  28.076  33.631  1.00 62.74           O  
ATOM   1535  CB  ALA   196      53.669  31.035  32.379  1.00 60.19           C  
ATOM   1536  N   TYR   197      54.673  29.665  35.097  1.00 63.83           N  
ATOM   1537  CA  TYR   197      55.675  28.856  35.796  1.00 64.54           C  
ATOM   1538  C   TYR   197      55.148  27.838  36.825  1.00 65.64           C  
ATOM   1539  O   TYR   197      55.920  27.054  37.385  1.00 67.88           O  
ATOM   1540  CB  TYR   197      56.705  29.770  36.462  1.00 61.90           C  
ATOM   1541  CG  TYR   197      56.102  30.959  37.159  1.00 58.48           C  
ATOM   1542  CD1 TYR   197      55.931  32.173  36.496  1.00 56.01           C  
ATOM   1543  CD2 TYR   197      55.685  30.866  38.483  1.00 58.22           C  
ATOM   1544  CE1 TYR   197      55.355  33.265  37.140  1.00 55.57           C  
ATOM   1545  CE2 TYR   197      55.111  31.947  39.131  1.00 56.93           C  
ATOM   1546  CZ  TYR   197      54.944  33.133  38.459  1.00 56.38           C  
ATOM   1547  OH  TYR   197      54.312  34.151  39.121  1.00 58.19           O  
ATOM   1548  N   ASP   198      53.850  27.871  37.099  1.00 65.09           N  
ATOM   1549  CA  ASP   198      53.227  26.901  37.998  1.00 63.43           C  
ATOM   1550  C   ASP   198      51.731  26.951  37.788  1.00 62.42           C  
ATOM   1551  O   ASP   198      51.239  27.730  36.974  1.00 63.52           O  
ATOM   1552  CB  ASP   198      53.611  27.109  39.479  1.00 64.26           C  
ATOM   1553  CG  ASP   198      53.151  28.434  40.053  1.00 65.88           C  
ATOM   1554  OD1 ASP   198      51.939  28.745  40.023  1.00 66.73           O  
ATOM   1555  OD2 ASP   198      54.022  29.161  40.570  1.00 66.88           O  
ATOM   1556  N   ARG   199      50.996  26.124  38.506  1.00 61.43           N  
ATOM   1557  CA  ARG   199      49.563  26.081  38.311  1.00 61.61           C  
ATOM   1558  C   ARG   199      48.703  27.055  39.118  1.00 61.63           C  
ATOM   1559  O   ARG   199      47.472  26.957  39.087  1.00 62.25           O  
ATOM   1560  CB  ARG   199      49.076  24.656  38.521  1.00 61.85           C  
ATOM   1561  N   ARG   200      49.303  28.003  39.825  1.00 61.76           N  
ATOM   1562  CA  ARG   200      48.470  28.929  40.580  1.00 63.49           C  
ATOM   1563  C   ARG   200      47.630  29.805  39.653  1.00 62.41           C  
ATOM   1564  O   ARG   200      48.124  30.305  38.645  1.00 62.12           O  
ATOM   1565  CB  ARG   200      49.307  29.824  41.497  1.00 66.92           C  
ATOM   1566  CG  ARG   200      48.426  30.796  42.301  1.00 71.18           C  
ATOM   1567  CD  ARG   200      49.138  31.366  43.512  1.00 74.24           C  
ATOM   1568  NE  ARG   200      48.225  32.139  44.348  1.00 78.08           N  
ATOM   1569  CZ  ARG   200      48.525  32.597  45.564  1.00 80.74           C  
ATOM   1570  NH1 ARG   200      49.720  32.362  46.097  1.00 79.79           N  
ATOM   1571  NH2 ARG   200      47.626  33.295  46.251  1.00 81.86           N  
ATOM   1572  N   THR   201      46.361  29.991  39.999  1.00 60.13           N  
ATOM   1573  CA  THR   201      45.482  30.804  39.180  1.00 60.15           C  
ATOM   1574  C   THR   201      45.130  32.081  39.904  1.00 59.16           C  
ATOM   1575  O   THR   201      45.423  32.222  41.081  1.00 60.04           O  
ATOM   1576  CB  THR   201      44.171  30.069  38.837  1.00 61.49           C  
ATOM   1577  OG1 THR   201      43.358  29.969  40.011  1.00 63.21           O  
ATOM   1578  CG2 THR   201      44.465  28.670  38.287  1.00 61.45           C  
ATOM   1579  N   TRP   202      44.508  33.013  39.192  1.00 58.57           N  
ATOM   1580  CA  TRP   202      44.117  34.287  39.774  1.00 58.33           C  
ATOM   1581  C   TRP   202      42.922  34.884  39.051  1.00 59.89           C  
ATOM   1582  O   TRP   202      42.480  34.403  38.015  1.00 57.22           O  
ATOM   1583  CB  TRP   202      45.230  35.342  39.687  1.00 56.73           C  
ATOM   1584  CG  TRP   202      46.623  34.925  39.996  1.00 56.77           C  
ATOM   1585  CD1 TRP   202      47.492  34.280  39.165  1.00 56.59           C  
ATOM   1586  CD2 TRP   202      47.355  35.223  41.186  1.00 57.19           C  
ATOM   1587  NE1 TRP   202      48.726  34.165  39.761  1.00 56.12           N  
ATOM   1588  CE2 TRP   202      48.668  34.735  41.001  1.00 57.56           C  
ATOM   1589  CE3 TRP   202      47.031  35.860  42.386  1.00 56.85           C  
ATOM   1590  CZ2 TRP   202      49.659  34.871  41.980  1.00 58.30           C  
ATOM   1591  CZ3 TRP   202      48.016  35.995  43.357  1.00 57.50           C  
ATOM   1592  CH2 TRP   202      49.315  35.501  43.148  1.00 58.22           C  
ATOM   1593  N   GLU   203      42.441  35.982  39.611  1.00 63.38           N  
ATOM   1594  CA  GLU   203      41.325  36.726  39.070  1.00 66.11           C  
ATOM   1595  C   GLU   203      42.001  37.892  38.363  1.00 65.79           C  
ATOM   1596  O   GLU   203      42.750  38.642  38.980  1.00 66.11           O  
ATOM   1597  CB  GLU   203      40.460  37.238  40.223  1.00 70.66           C  
ATOM   1598  CG  GLU   203      39.117  37.839  39.837  1.00 77.93           C  
ATOM   1599  CD  GLU   203      38.422  38.524  41.029  1.00 82.54           C  
ATOM   1600  OE1 GLU   203      38.918  38.381  42.172  1.00 84.18           O  
ATOM   1601  OE2 GLU   203      37.383  39.206  40.829  1.00 83.53           O  
ATOM   1602  N   LEU   204      41.769  38.031  37.066  1.00 65.73           N  
ATOM   1603  CA  LEU   204      42.370  39.123  36.329  1.00 65.17           C  
ATOM   1604  C   LEU   204      41.429  40.300  36.476  1.00 66.53           C  
ATOM   1605  O   LEU   204      40.241  40.183  36.197  1.00 67.24           O  
ATOM   1606  CB  LEU   204      42.514  38.754  34.865  1.00 63.65           C  
ATOM   1607  CG  LEU   204      43.641  39.447  34.119  1.00 61.57           C  
ATOM   1608  CD1 LEU   204      43.306  39.451  32.639  1.00 60.65           C  
ATOM   1609  CD2 LEU   204      43.821  40.845  34.639  1.00 61.03           C  
ATOM   1610  N   LEU   205      41.960  41.431  36.925  1.00 68.73           N  
ATOM   1611  CA  LEU   205      41.153  42.629  37.136  1.00 69.65           C  
ATOM   1612  C   LEU   205      41.264  43.606  35.975  1.00 71.33           C  
ATOM   1613  O   LEU   205      40.257  44.084  35.448  1.00 72.62           O  
ATOM   1614  CB  LEU   205      41.591  43.353  38.408  1.00 66.89           C  
ATOM   1615  CG  LEU   205      41.730  42.558  39.695  1.00 64.42           C  
ATOM   1616  CD1 LEU   205      42.144  43.511  40.811  1.00 63.12           C  
ATOM   1617  CD2 LEU   205      40.434  41.862  40.009  1.00 62.32           C  
ATOM   1618  N   ARG   206      42.495  43.910  35.588  1.00 71.79           N  
ATOM   1619  CA  ARG   206      42.729  44.851  34.515  1.00 72.64           C  
ATOM   1620  C   ARG   206      44.183  44.866  34.156  1.00 73.27           C  
ATOM   1621  O   ARG   206      44.993  44.216  34.793  1.00 72.83           O  
ATOM   1622  CB  ARG   206      42.315  46.258  34.952  1.00 73.68           C  
ATOM   1623  CG  ARG   206      42.461  46.518  36.461  1.00 76.14           C  
ATOM   1624  CD  ARG   206      42.338  48.005  36.799  1.00 77.52           C  
ATOM   1625  NE  ARG   206      43.537  48.740  36.395  1.00 79.70           N  
ATOM   1626  CZ  ARG   206      44.510  49.108  37.229  1.00 81.47           C  
ATOM   1627  NH1 ARG   206      44.430  48.823  38.531  1.00 82.03           N  
ATOM   1628  NH2 ARG   206      45.582  49.734  36.761  1.00 80.76           N  
ATOM   1629  N   LEU   207      44.507  45.614  33.116  1.00 76.18           N  
ATOM   1630  CA  LEU   207      45.886  45.752  32.681  1.00 78.80           C  
ATOM   1631  C   LEU   207      46.356  47.051  33.297  1.00 80.34           C  
ATOM   1632  O   LEU   207      45.544  47.817  33.814  1.00 80.93           O  
ATOM   1633  CB  LEU   207      45.969  45.846  31.162  1.00 78.21           C  
ATOM   1634  CG  LEU   207      46.783  44.769  30.459  1.00 79.21           C  
ATOM   1635  CD1 LEU   207      46.312  43.383  30.902  1.00 80.00           C  
ATOM   1636  CD2 LEU   207      46.622  44.939  28.956  1.00 80.04           C  
ATOM   1637  N   GLY   208      47.659  47.293  33.249  1.00 82.20           N  
ATOM   1638  CA  GLY   208      48.200  48.511  33.814  1.00 84.47           C  
ATOM   1639  C   GLY   208      49.210  49.157  32.894  1.00 86.77           C  
ATOM   1640  O   GLY   208      49.906  48.484  32.131  1.00 85.23           O  
ATOM   1641  N   GLU   209      49.303  50.477  32.983  1.00 90.43           N  
ATOM   1642  CA  GLU   209      50.223  51.236  32.148  1.00 93.67           C  
ATOM   1643  C   GLU   209      51.637  51.337  32.713  1.00 93.52           C  
ATOM   1644  O   GLU   209      52.574  51.663  31.979  1.00 93.73           O  
ATOM   1645  CB  GLU   209      49.648  52.640  31.882  1.00 97.33           C  
ATOM   1646  CG  GLU   209      49.114  53.377  33.116  1.00103.77           C  
ATOM   1647  CD  GLU   209      50.198  54.099  33.914  1.00107.89           C  
ATOM   1648  OE1 GLU   209      49.897  54.571  35.041  1.00109.42           O  
ATOM   1649  OE2 GLU   209      51.344  54.207  33.414  1.00109.63           O  
ATOM   1650  N   GLU   210      51.799  51.045  34.003  1.00 92.76           N  
ATOM   1651  CA  GLU   210      53.115  51.126  34.633  1.00 92.10           C  
ATOM   1652  C   GLU   210      54.162  50.242  33.971  1.00 92.41           C  
ATOM   1653  O   GLU   210      53.856  49.189  33.424  1.00 92.97           O  
ATOM   1654  CB  GLU   210      53.019  50.784  36.119  1.00 90.83           C  
ATOM   1655  CG  GLU   210      51.964  49.752  36.447  1.00 89.92           C  
ATOM   1656  CD  GLU   210      50.716  50.370  37.040  1.00 88.65           C  
ATOM   1657  OE1 GLU   210      50.829  51.040  38.088  1.00 88.65           O  
ATOM   1658  OE2 GLU   210      49.624  50.187  36.468  1.00 88.57           O  
ATOM   1659  N   ASP   211      55.407  50.688  34.017  1.00 93.17           N  
ATOM   1660  CA  ASP   211      56.503  49.945  33.425  1.00 94.06           C  
ATOM   1661  C   ASP   211      57.003  48.904  34.410  1.00 93.70           C  
ATOM   1662  O   ASP   211      57.480  49.241  35.489  1.00 94.07           O  
ATOM   1663  CB  ASP   211      57.641  50.895  33.073  1.00 96.52           C  
ATOM   1664  CG  ASP   211      57.981  51.834  34.219  1.00101.13           C  
ATOM   1665  OD1 ASP   211      58.979  52.590  34.113  1.00103.30           O  
ATOM   1666  OD2 ASP   211      57.242  51.818  35.233  1.00102.68           O  
ATOM   1667  N   PRO   212      56.896  47.619  34.055  1.00 93.56           N  
ATOM   1668  CA  PRO   212      57.354  46.539  34.933  1.00 93.11           C  
ATOM   1669  C   PRO   212      58.747  46.823  35.489  1.00 92.62           C  
ATOM   1670  O   PRO   212      59.014  46.663  36.685  1.00 93.34           O  
ATOM   1671  CB  PRO   212      57.335  45.316  34.014  1.00 92.72           C  
ATOM   1672  CG  PRO   212      57.444  45.909  32.631  1.00 93.18           C  
ATOM   1673  CD  PRO   212      56.528  47.086  32.735  1.00 94.11           C  
ATOM   1674  N   LYS   213      59.628  47.245  34.596  1.00 90.79           N  
ATOM   1675  CA  LYS   213      61.001  47.572  34.938  1.00 88.21           C  
ATOM   1676  C   LYS   213      61.120  48.491  36.153  1.00 85.96           C  
ATOM   1677  O   LYS   213      62.079  48.400  36.916  1.00 86.00           O  
ATOM   1678  CB  LYS   213      61.651  48.221  33.718  1.00 89.60           C  
ATOM   1679  CG  LYS   213      60.656  49.042  32.891  1.00 90.43           C  
ATOM   1680  CD  LYS   213      61.122  49.235  31.459  1.00 92.61           C  
ATOM   1681  CE  LYS   213      62.321  50.172  31.368  1.00 93.18           C  
ATOM   1682  NZ  LYS   213      62.789  50.344  29.956  1.00 94.14           N  
ATOM   1683  N   GLU   214      60.135  49.357  36.352  1.00 83.06           N  
ATOM   1684  CA  GLU   214      60.206  50.293  37.456  1.00 80.99           C  
ATOM   1685  C   GLU   214      59.077  50.234  38.479  1.00 78.99           C  
ATOM   1686  O   GLU   214      59.002  51.090  39.357  1.00 79.69           O  
ATOM   1687  CB  GLU   214      60.322  51.714  36.898  1.00 83.18           C  
ATOM   1688  CG  GLU   214      61.496  51.905  35.917  1.00 85.98           C  
ATOM   1689  CD  GLU   214      62.851  52.148  36.603  1.00 88.07           C  
ATOM   1690  OE1 GLU   214      63.899  51.964  35.933  1.00 88.14           O  
ATOM   1691  OE2 GLU   214      62.873  52.537  37.798  1.00 88.28           O  
ATOM   1692  N   LEU   215      58.195  49.245  38.389  1.00 75.56           N  
ATOM   1693  CA  LEU   215      57.118  49.149  39.370  1.00 70.81           C  
ATOM   1694  C   LEU   215      57.721  48.486  40.611  1.00 68.53           C  
ATOM   1695  O   LEU   215      58.277  47.394  40.536  1.00 68.45           O  
ATOM   1696  CB  LEU   215      55.957  48.322  38.816  1.00 69.76           C  
ATOM   1697  CG  LEU   215      54.730  48.203  39.723  1.00 68.23           C  
ATOM   1698  CD1 LEU   215      54.193  49.570  40.043  1.00 70.10           C  
ATOM   1699  CD2 LEU   215      53.673  47.400  39.033  1.00 68.21           C  
ATOM   1700  N   PRO   216      57.629  49.146  41.770  1.00 65.59           N  
ATOM   1701  CA  PRO   216      58.201  48.566  42.985  1.00 64.17           C  
ATOM   1702  C   PRO   216      57.308  47.687  43.856  1.00 63.09           C  
ATOM   1703  O   PRO   216      56.183  48.061  44.191  1.00 62.08           O  
ATOM   1704  CB  PRO   216      58.684  49.797  43.740  1.00 63.84           C  
ATOM   1705  CG  PRO   216      57.575  50.772  43.461  1.00 63.33           C  
ATOM   1706  CD  PRO   216      57.291  50.566  41.974  1.00 63.87           C  
ATOM   1707  N   LEU   217      57.828  46.517  44.224  1.00 61.66           N  
ATOM   1708  CA  LEU   217      57.116  45.601  45.104  1.00 58.98           C  
ATOM   1709  C   LEU   217      57.326  46.160  46.517  1.00 57.95           C  
ATOM   1710  O   LEU   217      58.306  46.866  46.772  1.00 57.13           O  
ATOM   1711  CB  LEU   217      57.681  44.188  44.940  1.00 58.92           C  
ATOM   1712  CG  LEU   217      56.956  43.286  43.917  1.00 59.54           C  
ATOM   1713  CD1 LEU   217      56.270  44.126  42.876  1.00 59.17           C  
ATOM   1714  CD2 LEU   217      57.934  42.316  43.259  1.00 58.01           C  
ATOM   1715  N   PRO   218      56.410  45.869  47.449  1.00 57.53           N  
ATOM   1716  CA  PRO   218      56.488  46.353  48.836  1.00 58.13           C  
ATOM   1717  C   PRO   218      57.834  46.826  49.406  1.00 59.75           C  
ATOM   1718  O   PRO   218      58.011  48.018  49.670  1.00 60.94           O  
ATOM   1719  CB  PRO   218      55.879  45.211  49.621  1.00 57.44           C  
ATOM   1720  CG  PRO   218      54.758  44.819  48.717  1.00 57.10           C  
ATOM   1721  CD  PRO   218      55.382  44.823  47.327  1.00 56.14           C  
ATOM   1722  N   GLY   219      58.785  45.921  49.601  1.00 60.14           N  
ATOM   1723  CA  GLY   219      60.059  46.357  50.154  1.00 59.45           C  
ATOM   1724  C   GLY   219      60.967  47.152  49.225  1.00 59.99           C  
ATOM   1725  O   GLY   219      62.113  47.456  49.593  1.00 60.44           O  
ATOM   1726  N   GLY   220      60.488  47.481  48.023  1.00 58.99           N  
ATOM   1727  CA  GLY   220      61.317  48.225  47.086  1.00 56.82           C  
ATOM   1728  C   GLY   220      61.831  47.485  45.855  1.00 55.36           C  
ATOM   1729  O   GLY   220      62.242  48.116  44.891  1.00 55.91           O  
ATOM   1730  N   LEU   221      61.819  46.159  45.869  1.00 55.10           N  
ATOM   1731  CA  LEU   221      62.285  45.375  44.716  1.00 55.13           C  
ATOM   1732  C   LEU   221      61.377  45.576  43.487  1.00 56.66           C  
ATOM   1733  O   LEU   221      60.147  45.629  43.609  1.00 55.89           O  
ATOM   1734  CB  LEU   221      62.324  43.894  45.104  1.00 52.43           C  
ATOM   1735  CG  LEU   221      62.834  42.780  44.185  1.00 50.13           C  
ATOM   1736  CD1 LEU   221      64.290  42.969  43.829  1.00 46.68           C  
ATOM   1737  CD2 LEU   221      62.650  41.449  44.918  1.00 48.43           C  
ATOM   1738  N   SER   222      61.975  45.692  42.303  1.00 58.20           N  
ATOM   1739  CA  SER   222      61.179  45.880  41.089  1.00 59.40           C  
ATOM   1740  C   SER   222      60.385  44.613  40.804  1.00 59.57           C  
ATOM   1741  O   SER   222      60.803  43.510  41.145  1.00 59.05           O  
ATOM   1742  CB  SER   222      62.063  46.194  39.879  1.00 60.08           C  
ATOM   1743  OG  SER   222      62.747  45.034  39.441  1.00 62.76           O  
ATOM   1744  N   LEU   223      59.232  44.786  40.177  1.00 60.43           N  
ATOM   1745  CA  LEU   223      58.363  43.680  39.845  1.00 60.50           C  
ATOM   1746  C   LEU   223      59.043  42.833  38.789  1.00 60.58           C  
ATOM   1747  O   LEU   223      58.850  41.619  38.727  1.00 60.06           O  
ATOM   1748  CB  LEU   223      57.019  44.227  39.359  1.00 62.23           C  
ATOM   1749  CG  LEU   223      55.925  43.312  38.809  1.00 64.78           C  
ATOM   1750  CD1 LEU   223      56.210  42.956  37.364  1.00 65.62           C  
ATOM   1751  CD2 LEU   223      55.841  42.080  39.642  1.00 65.49           C  
ATOM   1752  N   LEU   224      59.868  43.467  37.970  1.00 61.35           N  
ATOM   1753  CA  LEU   224      60.560  42.717  36.943  1.00 62.83           C  
ATOM   1754  C   LEU   224      61.664  41.895  37.577  1.00 62.41           C  
ATOM   1755  O   LEU   224      61.741  40.701  37.331  1.00 63.75           O  
ATOM   1756  CB  LEU   224      61.148  43.641  35.870  1.00 64.74           C  
ATOM   1757  CG  LEU   224      61.933  42.901  34.771  1.00 65.38           C  
ATOM   1758  CD1 LEU   224      60.998  42.149  33.833  1.00 63.50           C  
ATOM   1759  CD2 LEU   224      62.764  43.902  33.997  1.00 65.92           C  
ATOM   1760  N   ASP   225      62.511  42.516  38.393  1.00 61.75           N  
ATOM   1761  CA  ASP   225      63.603  41.777  39.047  1.00 63.10           C  
ATOM   1762  C   ASP   225      63.111  40.606  39.886  1.00 62.34           C  
ATOM   1763  O   ASP   225      63.825  39.628  40.077  1.00 63.44           O  
ATOM   1764  CB  ASP   225      64.425  42.672  39.977  1.00 65.55           C  
ATOM   1765  CG  ASP   225      65.271  43.676  39.233  1.00 69.26           C  
ATOM   1766  OD1 ASP   225      65.586  43.425  38.043  1.00 69.68           O  
ATOM   1767  OD2 ASP   225      65.631  44.706  39.857  1.00 70.29           O  
ATOM   1768  N   TYR   226      61.901  40.719  40.413  1.00 60.89           N  
ATOM   1769  CA  TYR   226      61.349  39.661  41.228  1.00 59.54           C  
ATOM   1770  C   TYR   226      61.302  38.376  40.404  1.00 60.29           C  
ATOM   1771  O   TYR   226      61.884  37.364  40.792  1.00 61.44           O  
ATOM   1772  CB  TYR   226      59.949  40.053  41.714  1.00 57.13           C  
ATOM   1773  CG  TYR   226      59.221  38.976  42.484  1.00 53.38           C  
ATOM   1774  CD1 TYR   226      59.530  38.703  43.809  1.00 51.58           C  
ATOM   1775  CD2 TYR   226      58.224  38.218  41.875  1.00 53.69           C  
ATOM   1776  CE1 TYR   226      58.862  37.698  44.507  1.00 49.73           C  
ATOM   1777  CE2 TYR   226      57.553  37.205  42.568  1.00 51.40           C  
ATOM   1778  CZ  TYR   226      57.881  36.955  43.876  1.00 49.11           C  
ATOM   1779  OH  TYR   226      57.251  35.937  44.531  1.00 47.84           O  
ATOM   1780  N   HIS   227      60.628  38.410  39.264  1.00 59.93           N  
ATOM   1781  CA  HIS   227      60.544  37.213  38.440  1.00 60.89           C  
ATOM   1782  C   HIS   227      61.894  36.975  37.746  1.00 63.81           C  
ATOM   1783  O   HIS   227      62.439  35.872  37.784  1.00 63.23           O  
ATOM   1784  CB  HIS   227      59.424  37.355  37.399  1.00 57.03           C  
ATOM   1785  CG  HIS   227      58.046  37.517  37.984  1.00 53.56           C  
ATOM   1786  ND1 HIS   227      57.316  36.463  38.493  1.00 52.36           N  
ATOM   1787  CD2 HIS   227      57.253  38.610  38.105  1.00 50.16           C  
ATOM   1788  CE1 HIS   227      56.136  36.898  38.897  1.00 48.37           C  
ATOM   1789  NE2 HIS   227      56.074  38.197  38.673  1.00 47.03           N  
ATOM   1790  N   ALA   228      62.439  38.021  37.134  1.00 67.61           N  
ATOM   1791  CA  ALA   228      63.722  37.933  36.423  1.00 71.57           C  
ATOM   1792  C   ALA   228      64.750  37.137  37.205  1.00 73.71           C  
ATOM   1793  O   ALA   228      65.389  36.230  36.668  1.00 74.28           O  
ATOM   1794  CB  ALA   228      64.274  39.333  36.134  1.00 70.89           C  
ATOM   1795  N   SER   229      64.902  37.483  38.479  1.00 76.15           N  
ATOM   1796  CA  SER   229      65.857  36.813  39.339  1.00 78.54           C  
ATOM   1797  C   SER   229      65.493  35.353  39.536  1.00 79.95           C  
ATOM   1798  O   SER   229      66.373  34.511  39.673  1.00 79.93           O  
ATOM   1799  CB  SER   229      65.932  37.519  40.699  1.00 79.76           C  
ATOM   1800  OG  SER   229      66.833  36.857  41.583  1.00 81.85           O  
ATOM   1801  N   LYS   230      64.199  35.048  39.548  1.00 82.19           N  
ATOM   1802  CA  LYS   230      63.756  33.670  39.743  1.00 84.10           C  
ATOM   1803  C   LYS   230      63.860  32.858  38.451  1.00 84.00           C  
ATOM   1804  O   LYS   230      63.264  31.787  38.322  1.00 83.71           O  
ATOM   1805  CB  LYS   230      62.319  33.637  40.290  1.00 85.98           C  
ATOM   1806  CG  LYS   230      62.157  34.242  41.697  1.00 89.07           C  
ATOM   1807  CD  LYS   230      63.028  33.528  42.739  1.00 91.74           C  
ATOM   1808  CE  LYS   230      62.970  34.220  44.110  1.00 93.04           C  
ATOM   1809  NZ  LYS   230      61.574  34.324  44.630  1.00 92.19           N  
ATOM   1810  N   GLY   231      64.628  33.386  37.502  1.00 83.88           N  
ATOM   1811  CA  GLY   231      64.835  32.715  36.233  1.00 85.07           C  
ATOM   1812  C   GLY   231      63.578  32.378  35.461  1.00 86.24           C  
ATOM   1813  O   GLY   231      63.610  31.550  34.546  1.00 87.35           O  
ATOM   1814  N   ARG   232      62.470  33.017  35.824  1.00 85.71           N  
ATOM   1815  CA  ARG   232      61.186  32.789  35.166  1.00 83.70           C  
ATOM   1816  C   ARG   232      61.158  33.593  33.898  1.00 85.17           C  
ATOM   1817  O   ARG   232      60.272  33.431  33.064  1.00 85.53           O  
ATOM   1818  CB  ARG   232      60.043  33.260  36.054  1.00 79.09           C  
ATOM   1819  CG  ARG   232      59.853  32.463  37.310  1.00 73.26           C  
ATOM   1820  CD  ARG   232      58.927  33.203  38.220  1.00 69.66           C  
ATOM   1821  NE  ARG   232      58.598  32.445  39.413  1.00 65.96           N  
ATOM   1822  CZ  ARG   232      57.974  32.968  40.458  1.00 65.19           C  
ATOM   1823  NH1 ARG   232      57.629  34.248  40.437  1.00 63.79           N  
ATOM   1824  NH2 ARG   232      57.688  32.216  41.513  1.00 64.60           N  
ATOM   1825  N   LEU   233      62.133  34.475  33.762  1.00 88.01           N  
ATOM   1826  CA  LEU   233      62.197  35.324  32.593  1.00 92.02           C  
ATOM   1827  C   LEU   233      62.992  34.656  31.482  1.00 94.37           C  
ATOM   1828  O   LEU   233      62.755  34.912  30.302  1.00 95.25           O  
ATOM   1829  CB  LEU   233      62.832  36.662  32.955  1.00 92.16           C  
ATOM   1830  CG  LEU   233      62.117  37.871  32.364  1.00 91.40           C  
ATOM   1831  CD1 LEU   233      60.835  38.131  33.136  1.00 90.38           C  
ATOM   1832  CD2 LEU   233      63.034  39.083  32.440  1.00 92.79           C  
ATOM   1833  N   GLN   234      63.933  33.796  31.857  1.00 97.19           N  
ATOM   1834  CA  GLN   234      64.749  33.108  30.862  1.00 99.93           C  
ATOM   1835  C   GLN   234      63.873  32.497  29.764  1.00101.35           C  
ATOM   1836  O   GLN   234      63.060  31.602  30.020  1.00102.29           O  
ATOM   1837  CB  GLN   234      65.598  32.025  31.530  1.00 98.68           C  
ATOM   1838  N   GLY   235      64.028  32.998  28.542  1.00101.54           N  
ATOM   1839  CA  GLY   235      63.252  32.472  27.430  1.00102.08           C  
ATOM   1840  C   GLY   235      61.855  33.048  27.268  1.00101.94           C  
ATOM   1841  O   GLY   235      60.982  32.403  26.681  1.00102.78           O  
ATOM   1842  N   ARG   236      61.632  34.258  27.765  1.00101.38           N  
ATOM   1843  CA  ARG   236      60.315  34.858  27.636  1.00 99.91           C  
ATOM   1844  C   ARG   236      60.363  36.370  27.416  1.00 98.87           C  
ATOM   1845  O   ARG   236      61.420  36.955  27.213  1.00 99.44           O  
ATOM   1846  CB  ARG   236      59.478  34.542  28.875  1.00 99.41           C  
ATOM   1847  N   GLU   237      59.185  36.974  27.444  1.00 97.86           N  
ATOM   1848  CA  GLU   237      59.022  38.410  27.289  1.00 96.78           C  
ATOM   1849  C   GLU   237      58.101  38.800  28.430  1.00 94.77           C  
ATOM   1850  O   GLU   237      57.024  38.224  28.581  1.00 94.97           O  
ATOM   1851  CB  GLU   237      58.349  38.751  25.959  1.00100.13           C  
ATOM   1852  CG  GLU   237      57.799  40.185  25.869  1.00102.17           C  
ATOM   1853  CD  GLU   237      56.387  40.238  25.296  1.00103.44           C  
ATOM   1854  OE1 GLU   237      56.036  39.337  24.505  1.00104.23           O  
ATOM   1855  OE2 GLU   237      55.633  41.182  25.627  1.00104.30           O  
ATOM   1856  N   GLY   238      58.525  39.772  29.229  1.00 91.48           N  
ATOM   1857  CA  GLY   238      57.721  40.217  30.350  1.00 87.77           C  
ATOM   1858  C   GLY   238      56.381  40.782  29.942  1.00 85.92           C  
ATOM   1859  O   GLY   238      55.385  40.574  30.627  1.00 85.39           O  
ATOM   1860  N   GLY   239      56.352  41.501  28.826  1.00 85.46           N  
ATOM   1861  CA  GLY   239      55.109  42.084  28.358  1.00 83.22           C  
ATOM   1862  C   GLY   239      54.712  43.275  29.196  1.00 82.47           C  
ATOM   1863  O   GLY   239      55.572  44.015  29.662  1.00 83.12           O  
ATOM   1864  N   ARG   240      53.410  43.452  29.391  1.00 82.23           N  
ATOM   1865  CA  ARG   240      52.865  44.560  30.173  1.00 82.73           C  
ATOM   1866  C   ARG   240      52.442  44.111  31.578  1.00 80.66           C  
ATOM   1867  O   ARG   240      52.334  42.918  31.851  1.00 81.00           O  
ATOM   1868  CB  ARG   240      51.655  45.146  29.437  1.00 87.53           C  
ATOM   1869  CG  ARG   240      51.031  46.391  30.075  1.00 95.10           C  
ATOM   1870  CD  ARG   240      51.879  47.672  29.882  1.00101.20           C  
ATOM   1871  NE  ARG   240      52.015  48.069  28.474  1.00104.62           N  
ATOM   1872  CZ  ARG   240      52.974  47.638  27.656  1.00106.63           C  
ATOM   1873  NH1 ARG   240      53.906  46.789  28.093  1.00107.58           N  
ATOM   1874  NH2 ARG   240      53.000  48.054  26.395  1.00106.50           N  
ATOM   1875  N   VAL   241      52.192  45.076  32.460  1.00 77.97           N  
ATOM   1876  CA  VAL   241      51.776  44.801  33.838  1.00 75.15           C  
ATOM   1877  C   VAL   241      50.311  44.411  33.946  1.00 74.21           C  
ATOM   1878  O   VAL   241      49.442  45.083  33.403  1.00 74.40           O  
ATOM   1879  CB  VAL   241      51.979  46.026  34.752  1.00 73.81           C  
ATOM   1880  CG1 VAL   241      51.329  45.773  36.094  1.00 72.30           C  
ATOM   1881  CG2 VAL   241      53.459  46.319  34.920  1.00 72.84           C  
ATOM   1882  N   ALA   242      50.038  43.344  34.685  1.00 73.49           N  
ATOM   1883  CA  ALA   242      48.668  42.872  34.856  1.00 72.06           C  
ATOM   1884  C   ALA   242      48.230  42.823  36.311  1.00 70.74           C  
ATOM   1885  O   ALA   242      48.684  41.986  37.068  1.00 71.78           O  
ATOM   1886  CB  ALA   242      48.518  41.495  34.231  1.00 72.17           C  
ATOM   1887  N   TRP   243      47.339  43.720  36.699  1.00 69.56           N  
ATOM   1888  CA  TRP   243      46.847  43.726  38.059  1.00 69.29           C  
ATOM   1889  C   TRP   243      45.968  42.512  38.220  1.00 68.40           C  
ATOM   1890  O   TRP   243      45.011  42.313  37.479  1.00 69.02           O  
ATOM   1891  CB  TRP   243      46.095  45.026  38.353  1.00 70.42           C  
ATOM   1892  CG  TRP   243      47.051  46.180  38.314  1.00 72.51           C  
ATOM   1893  CD1 TRP   243      47.309  47.003  37.248  1.00 72.80           C  
ATOM   1894  CD2 TRP   243      48.013  46.521  39.322  1.00 71.94           C  
ATOM   1895  NE1 TRP   243      48.376  47.823  37.530  1.00 72.94           N  
ATOM   1896  CE2 TRP   243      48.828  47.548  38.794  1.00 72.39           C  
ATOM   1897  CE3 TRP   243      48.268  46.052  40.615  1.00 71.00           C  
ATOM   1898  CZ2 TRP   243      49.885  48.116  39.517  1.00 72.37           C  
ATOM   1899  CZ3 TRP   243      49.318  46.618  41.333  1.00 72.44           C  
ATOM   1900  CH2 TRP   243      50.114  47.639  40.780  1.00 71.49           C  
ATOM   1901  N   VAL   244      46.318  41.704  39.206  1.00 67.98           N  
ATOM   1902  CA  VAL   244      45.651  40.450  39.487  1.00 68.63           C  
ATOM   1903  C   VAL   244      45.117  40.368  40.925  1.00 70.31           C  
ATOM   1904  O   VAL   244      45.485  41.172  41.780  1.00 70.28           O  
ATOM   1905  CB  VAL   244      46.669  39.324  39.179  1.00 67.10           C  
ATOM   1906  CG1 VAL   244      46.644  38.261  40.224  1.00 66.99           C  
ATOM   1907  CG2 VAL   244      46.400  38.759  37.816  1.00 65.37           C  
ATOM   1908  N   ALA   245      44.234  39.409  41.182  1.00 73.54           N  
ATOM   1909  CA  ALA   245      43.662  39.217  42.518  1.00 77.50           C  
ATOM   1910  C   ALA   245      43.900  37.775  42.973  1.00 80.10           C  
ATOM   1911  O   ALA   245      44.182  36.911  42.152  1.00 79.89           O  
ATOM   1912  CB  ALA   245      42.182  39.536  42.501  1.00 78.23           C  
ATOM   1913  N   ASP   246      43.741  37.504  44.266  1.00 84.91           N  
ATOM   1914  CA  ASP   246      44.034  36.180  44.786  1.00 91.11           C  
ATOM   1915  C   ASP   246      43.553  34.803  44.228  1.00 95.61           C  
ATOM   1916  O   ASP   246      44.370  34.029  43.736  1.00 97.23           O  
ATOM   1917  CB  ASP   246      43.799  36.129  46.303  1.00 89.52           C  
ATOM   1918  CG  ASP   246      44.490  34.941  46.945  1.00 89.61           C  
ATOM   1919  OD1 ASP   246      45.611  35.108  47.470  1.00 89.47           O  
ATOM   1920  OD2 ASP   246      43.923  33.829  46.896  1.00 89.35           O  
ATOM   1921  N   PRO   247      42.209  34.521  44.177  1.00 99.10           N  
ATOM   1922  CA  PRO   247      41.025  35.241  44.689  1.00101.63           C  
ATOM   1923  C   PRO   247      40.502  35.029  46.109  1.00102.89           C  
ATOM   1924  O   PRO   247      39.342  35.362  46.374  1.00104.01           O  
ATOM   1925  CB  PRO   247      39.978  34.787  43.675  1.00102.35           C  
ATOM   1926  CG  PRO   247      40.295  33.299  43.597  1.00101.05           C  
ATOM   1927  CD  PRO   247      41.818  33.287  43.484  1.00 99.68           C  
ATOM   1928  N   LYS   248      41.297  34.472  47.023  1.00104.59           N  
ATOM   1929  CA  LYS   248      40.804  34.299  48.395  1.00105.61           C  
ATOM   1930  C   LYS   248      40.737  35.689  49.049  1.00107.03           C  
ATOM   1931  O   LYS   248      40.015  35.908  50.026  1.00108.10           O  
ATOM   1932  CB  LYS   248      41.721  33.360  49.190  1.00104.00           C  
ATOM   1933  N   ASP   249      41.509  36.611  48.488  1.00107.31           N  
ATOM   1934  CA  ASP   249      41.545  38.012  48.916  1.00108.27           C  
ATOM   1935  C   ASP   249      41.176  38.757  47.634  1.00108.48           C  
ATOM   1936  O   ASP   249      42.017  39.403  47.008  1.00108.32           O  
ATOM   1937  CB  ASP   249      42.951  38.411  49.368  1.00109.73           C  
ATOM   1938  CG  ASP   249      43.093  38.453  50.881  1.00110.13           C  
ATOM   1939  OD1 ASP   249      44.167  38.872  51.364  1.00110.14           O  
ATOM   1940  OD2 ASP   249      42.137  38.070  51.586  1.00110.53           O  
ATOM   1941  N   PRO   250      39.901  38.668  47.225  1.00108.38           N  
ATOM   1942  CA  PRO   250      39.383  39.305  46.008  1.00108.07           C  
ATOM   1943  C   PRO   250      39.455  40.825  45.962  1.00107.62           C  
ATOM   1944  O   PRO   250      39.369  41.427  44.887  1.00108.06           O  
ATOM   1945  CB  PRO   250      37.944  38.807  45.956  1.00108.28           C  
ATOM   1946  CG  PRO   250      37.578  38.773  47.411  1.00108.01           C  
ATOM   1947  CD  PRO   250      38.795  38.123  48.037  1.00108.15           C  
ATOM   1948  N   ARG   251      39.624  41.439  47.127  1.00105.75           N  
ATOM   1949  CA  ARG   251      39.656  42.888  47.222  1.00103.19           C  
ATOM   1950  C   ARG   251      41.023  43.537  47.101  1.00100.58           C  
ATOM   1951  O   ARG   251      41.111  44.739  46.855  1.00100.45           O  
ATOM   1952  CB  ARG   251      39.020  43.317  48.540  1.00105.18           C  
ATOM   1953  CG  ARG   251      37.641  42.738  48.769  1.00106.09           C  
ATOM   1954  CD  ARG   251      36.659  43.834  49.107  1.00107.90           C  
ATOM   1955  NE  ARG   251      35.353  43.286  49.448  1.00110.15           N  
ATOM   1956  CZ  ARG   251      34.303  44.019  49.808  1.00110.84           C  
ATOM   1957  NH1 ARG   251      34.399  45.341  49.874  1.00110.87           N  
ATOM   1958  NH2 ARG   251      33.156  43.426  50.115  1.00111.15           N  
ATOM   1959  N   LYS   252      42.088  42.760  47.278  1.00 96.86           N  
ATOM   1960  CA  LYS   252      43.434  43.330  47.198  1.00 92.57           C  
ATOM   1961  C   LYS   252      44.222  42.903  45.971  1.00 86.47           C  
ATOM   1962  O   LYS   252      44.592  41.735  45.825  1.00 86.47           O  
ATOM   1963  CB  LYS   252      44.239  42.987  48.451  1.00 95.18           C  
ATOM   1964  CG  LYS   252      45.584  43.698  48.525  1.00 97.46           C  
ATOM   1965  CD  LYS   252      46.376  43.229  49.729  1.00101.35           C  
ATOM   1966  CE  LYS   252      46.871  41.801  49.534  1.00103.67           C  
ATOM   1967  NZ  LYS   252      45.775  40.831  49.223  1.00105.43           N  
ATOM   1968  N   PRO   253      44.501  43.862  45.080  1.00 80.97           N  
ATOM   1969  CA  PRO   253      45.245  43.670  43.833  1.00 76.84           C  
ATOM   1970  C   PRO   253      46.757  43.515  44.020  1.00 72.54           C  
ATOM   1971  O   PRO   253      47.378  44.239  44.802  1.00 71.39           O  
ATOM   1972  CB  PRO   253      44.901  44.929  43.045  1.00 76.95           C  
ATOM   1973  CG  PRO   253      44.826  45.960  44.125  1.00 77.70           C  
ATOM   1974  CD  PRO   253      44.011  45.249  45.183  1.00 79.13           C  
ATOM   1975  N   ILE   254      47.343  42.562  43.304  1.00 66.91           N  
ATOM   1976  CA  ILE   254      48.777  42.367  43.375  1.00 61.43           C  
ATOM   1977  C   ILE   254      49.269  42.508  41.954  1.00 58.54           C  
ATOM   1978  O   ILE   254      48.566  42.180  41.011  1.00 56.58           O  
ATOM   1979  CB  ILE   254      49.166  40.978  43.946  1.00 61.07           C  
ATOM   1980  CG1 ILE   254      49.621  40.062  42.826  1.00 60.73           C  
ATOM   1981  CG2 ILE   254      47.990  40.355  44.709  1.00 59.15           C  
ATOM   1982  CD1 ILE   254      50.156  38.762  43.329  1.00 63.47           C  
ATOM   1983  N   PRO   255      50.493  42.996  41.772  1.00 56.44           N  
ATOM   1984  CA  PRO   255      50.894  43.113  40.379  1.00 55.05           C  
ATOM   1985  C   PRO   255      51.501  41.860  39.788  1.00 53.92           C  
ATOM   1986  O   PRO   255      52.014  40.989  40.496  1.00 52.18           O  
ATOM   1987  CB  PRO   255      51.849  44.309  40.389  1.00 55.63           C  
ATOM   1988  CG  PRO   255      52.358  44.397  41.805  1.00 54.87           C  
ATOM   1989  CD  PRO   255      51.530  43.492  42.685  1.00 55.03           C  
ATOM   1990  N   HIS   256      51.419  41.786  38.468  1.00 52.62           N  
ATOM   1991  CA  HIS   256      51.942  40.659  37.731  1.00 52.33           C  
ATOM   1992  C   HIS   256      52.236  41.094  36.307  1.00 52.34           C  
ATOM   1993  O   HIS   256      52.075  42.245  35.938  1.00 53.29           O  
ATOM   1994  CB  HIS   256      50.957  39.504  37.754  1.00 50.07           C  
ATOM   1995  CG  HIS   256      51.606  38.159  37.677  1.00 49.66           C  
ATOM   1996  ND1 HIS   256      51.227  37.116  38.491  1.00 49.27           N  
ATOM   1997  CD2 HIS   256      52.599  37.678  36.888  1.00 49.16           C  
ATOM   1998  CE1 HIS   256      51.957  36.050  38.210  1.00 50.08           C  
ATOM   1999  NE2 HIS   256      52.797  36.364  37.238  1.00 49.02           N  
ATOM   2000  N   LEU   257      52.584  40.139  35.487  1.00 53.39           N  
ATOM   2001  CA  LEU   257      53.028  40.397  34.159  1.00 57.25           C  
ATOM   2002  C   LEU   257      52.472  39.530  33.080  1.00 59.33           C  
ATOM   2003  O   LEU   257      52.679  38.328  33.142  1.00 59.19           O  
ATOM   2004  CB  LEU   257      54.464  40.068  34.093  1.00 58.52           C  
ATOM   2005  CG  LEU   257      55.325  40.949  34.924  1.00 60.98           C  
ATOM   2006  CD1 LEU   257      56.699  40.450  34.716  1.00 57.94           C  
ATOM   2007  CD2 LEU   257      55.241  42.329  34.351  1.00 58.77           C  
ATOM   2008  N   THR   258      51.890  40.111  32.039  1.00 60.58           N  
ATOM   2009  CA  THR   258      51.320  39.300  30.955  1.00 61.79           C  
ATOM   2010  C   THR   258      52.248  38.232  30.323  1.00 61.26           C  
ATOM   2011  O   THR   258      51.813  37.128  29.960  1.00 60.52           O  
ATOM   2012  CB  THR   258      50.808  40.171  29.840  1.00 61.37           C  
ATOM   2013  OG1 THR   258      51.913  40.842  29.238  1.00 62.19           O  
ATOM   2014  CG2 THR   258      49.854  41.202  30.400  1.00 61.30           C  
ATOM   2015  N   GLY   259      53.518  38.565  30.149  1.00 60.95           N  
ATOM   2016  CA  GLY   259      54.425  37.605  29.564  1.00 60.64           C  
ATOM   2017  C   GLY   259      54.480  36.333  30.375  1.00 60.95           C  
ATOM   2018  O   GLY   259      54.717  35.267  29.830  1.00 61.41           O  
ATOM   2019  N   LEU   260      54.246  36.433  31.680  1.00 62.35           N  
ATOM   2020  CA  LEU   260      54.310  35.265  32.549  1.00 62.18           C  
ATOM   2021  C   LEU   260      52.969  34.671  32.929  1.00 61.39           C  
ATOM   2022  O   LEU   260      52.893  33.875  33.877  1.00 61.82           O  
ATOM   2023  CB  LEU   260      55.072  35.606  33.822  1.00 65.44           C  
ATOM   2024  CG  LEU   260      56.521  36.068  33.650  1.00 67.85           C  
ATOM   2025  CD1 LEU   260      57.054  36.588  34.987  1.00 67.43           C  
ATOM   2026  CD2 LEU   260      57.366  34.902  33.123  1.00 68.59           C  
ATOM   2027  N   LEU   261      51.921  35.034  32.195  1.00 58.54           N  
ATOM   2028  CA  LEU   261      50.586  34.520  32.479  1.00 57.94           C  
ATOM   2029  C   LEU   261      49.949  33.772  31.297  1.00 58.83           C  
ATOM   2030  O   LEU   261      50.301  33.991  30.127  1.00 59.31           O  
ATOM   2031  CB  LEU   261      49.673  35.669  32.931  1.00 55.50           C  
ATOM   2032  CG  LEU   261      50.062  36.391  34.231  1.00 54.35           C  
ATOM   2033  CD1 LEU   261      49.209  37.635  34.407  1.00 51.98           C  
ATOM   2034  CD2 LEU   261      49.887  35.446  35.428  1.00 51.89           C  
ATOM   2035  N   VAL   262      49.011  32.886  31.614  1.00 57.57           N  
ATOM   2036  CA  VAL   262      48.325  32.102  30.601  1.00 58.59           C  
ATOM   2037  C   VAL   262      46.838  32.221  30.902  1.00 58.98           C  
ATOM   2038  O   VAL   262      46.377  31.788  31.954  1.00 59.19           O  
ATOM   2039  CB  VAL   262      48.794  30.609  30.658  1.00 59.44           C  
ATOM   2040  CG1 VAL   262      48.057  29.754  29.607  1.00 57.60           C  
ATOM   2041  CG2 VAL   262      50.300  30.543  30.424  1.00 57.04           C  
ATOM   2042  N   PRO   263      46.061  32.823  29.986  1.00 59.23           N  
ATOM   2043  CA  PRO   263      44.625  32.959  30.254  1.00 60.04           C  
ATOM   2044  C   PRO   263      43.937  31.633  30.485  1.00 59.35           C  
ATOM   2045  O   PRO   263      44.226  30.658  29.813  1.00 57.78           O  
ATOM   2046  CB  PRO   263      44.102  33.676  29.010  1.00 58.23           C  
ATOM   2047  CG  PRO   263      44.988  33.154  27.956  1.00 59.23           C  
ATOM   2048  CD  PRO   263      46.365  33.206  28.599  1.00 59.04           C  
ATOM   2049  N   VAL   264      43.041  31.605  31.463  1.00 61.05           N  
ATOM   2050  CA  VAL   264      42.285  30.395  31.765  1.00 64.21           C  
ATOM   2051  C   VAL   264      41.010  30.540  30.933  1.00 66.60           C  
ATOM   2052  O   VAL   264      40.094  31.287  31.296  1.00 66.66           O  
ATOM   2053  CB  VAL   264      41.982  30.289  33.301  1.00 62.79           C  
ATOM   2054  CG1 VAL   264      41.001  29.171  33.586  1.00 59.66           C  
ATOM   2055  CG2 VAL   264      43.281  30.021  34.055  1.00 60.54           C  
ATOM   2056  N   LEU   265      40.973  29.837  29.802  1.00 69.38           N  
ATOM   2057  CA  LEU   265      39.838  29.937  28.892  1.00 72.80           C  
ATOM   2058  C   LEU   265      38.579  29.196  29.315  1.00 75.02           C  
ATOM   2059  O   LEU   265      38.618  28.118  29.914  1.00 73.83           O  
ATOM   2060  CB  LEU   265      40.229  29.498  27.479  1.00 72.18           C  
ATOM   2061  CG  LEU   265      41.657  29.735  27.015  1.00 71.44           C  
ATOM   2062  CD1 LEU   265      42.550  28.748  27.751  1.00 74.08           C  
ATOM   2063  CD2 LEU   265      41.775  29.505  25.518  1.00 71.15           C  
END
