
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  110 ( 1561),  selected  110 , name 1x5q_A
# Molecule2: number of CA atoms   95 (  723),  selected   95 , name T0488.pdb
# PARAMETERS: 1x5q_A.T0488.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      -       -           -
LGA    S     2_A      -       -           -
LGA    S     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    E     8_A      -       -           -
LGA    P     9_A      -       -           -
LGA    A    10_A      -       -           -
LGA    R    11_A      -       -           -
LGA    I    12_A      -       -           -
LGA    E    13_A      S       1          0.650
LGA    E    14_A      M       2          0.989
LGA    E    15_A      E       3          2.021
LGA    E    16_A      I       4          1.055
LGA    L    17_A      L       5          0.893
LGA    T    18_A      Q       6          0.537
LGA    L    19_A      V       7          0.434
LGA    T    20_A      A       8          0.849
LGA    I    21_A      L       9          0.732
LGA    L    22_A      H      10          1.422
LGA    R    23_A      K      11          0.494
LGA    Q    24_A      R      12          0.867
LGA    T    25_A      D      13          3.048
LGA    -       -      S      14           -
LGA    G    26_A      G      15          2.121
LGA    G    27_A      E      16          3.070
LGA    L    28_A      Q      17          2.779
LGA    -       -      L      18           -
LGA    G    29_A      G      19          0.820
LGA    I    30_A      I      20          0.775
LGA    S    31_A      K      21          0.883
LGA    I    32_A      L      22          0.224
LGA    A    33_A      V      23          0.229
LGA    G    34_A      R      24          0.378
LGA    G    35_A      -       -           -
LGA    K    36_A      -       -           -
LGA    G    37_A      -       -           -
LGA    S    38_A      -       -           -
LGA    T    39_A      -       -           -
LGA    P    40_A      R      25          0.821
LGA    Y    41_A      -       -           -
LGA    K    42_A      -       -           -
LGA    G    43_A      T      26           #
LGA    D    44_A      D      27          1.374
LGA    D    45_A      E      28          0.999
LGA    E    46_A      P      29          1.693
LGA    G    47_A      G      30          0.873
LGA    I    48_A      V      31          0.334
LGA    F    49_A      F      32          0.318
LGA    I    50_A      I      33          0.436
LGA    S    51_A      L      34          1.696
LGA    R    52_A      D      35          1.954
LGA    V    53_A      L      36          0.351
LGA    S    54_A      L      37          1.449
LGA    E    55_A      E      38          2.623
LGA    E    56_A      G      39          0.770
LGA    G    57_A      G      40          1.013
LGA    P    58_A      L      41          0.612
LGA    A    59_A      A      42          0.720
LGA    A    60_A      A      43          1.242
LGA    R    61_A      Q      44          2.447
LGA    A    62_A      D      45          2.619
LGA    G    63_A      G      46          2.526
LGA    -       -      R      47           -
LGA    V    64_A      L      48          1.116
LGA    R    65_A      S      49          0.695
LGA    V    66_A      S      50          1.283
LGA    G    67_A      N      51          1.101
LGA    D    68_A      D      52          0.611
LGA    K    69_A      R      53          0.480
LGA    L    70_A      V      54          0.495
LGA    L    71_A      L      55          0.504
LGA    E    72_A      A      56          0.883
LGA    V    73_A      I      57          0.574
LGA    N    74_A      N      58          1.084
LGA    G    75_A      G      59          1.074
LGA    V    76_A      H      60          0.844
LGA    A    77_A      D      61          0.713
LGA    L    78_A      L      62          0.731
LGA    Q    79_A      K      63          0.846
LGA    G    80_A      Y      64          1.168
LGA    A    81_A      G      65          0.616
LGA    E    82_A      T      66          2.433
LGA    H    83_A      P      67          2.713
LGA    H    84_A      E      68          1.844
LGA    E    85_A      L      69          1.347
LGA    A    86_A      A      70          1.766
LGA    V    87_A      A      71          1.482
LGA    E    88_A      Q      72          0.939
LGA    A    89_A      I      73          1.699
LGA    L    90_A      I      74          1.795
LGA    R    91_A      Q      75          1.519
LGA    G    92_A      A      76          2.734
LGA    A    93_A      S      77          1.653
LGA    G    94_A      G      78          1.646
LGA    T    95_A      E      79          1.468
LGA    A    96_A      R      80          1.757
LGA    V    97_A      V      81          0.948
LGA    Q    98_A      N      82          0.563
LGA    M    99_A      L      83          0.499
LGA    R   100_A      T      84          0.772
LGA    V   101_A      I      85          0.961
LGA    W   102_A      A      86          0.623
LGA    R   103_A      R      87          0.891
LGA    -       -      P      88           -
LGA    E   104_A      G      89          4.587
LGA    S   105_A      -       -           -
LGA    G   106_A      K      90          6.090
LGA    P   107_A      P      91          1.969
LGA    S   108_A      E      92          4.827
LGA    S   109_A      I      93          5.129
LGA    G   110_A      E      94           -
LGA    -       -      L      95           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  110   95    5.0     88    1.76    27.27     85.660     4.732

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.234137 * X  +   0.120426 * Y  +  -0.964716 * Z  +   8.189205
  Y_new =   0.805784 * X  +  -0.579241 * Y  +   0.123258 * Z  +  16.916084
  Z_new =  -0.543960 * X  +  -0.806212 * Y  +  -0.232659 * Z  +  10.285664 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.851746    1.289846  [ DEG:  -106.0972     73.9028 ]
  Theta =   0.575149    2.566444  [ DEG:    32.9536    147.0464 ]
  Phi   =   1.288012   -1.853580  [ DEG:    73.7977   -106.2023 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1x5q_A                                        
REMARK     2: T0488.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1x5q_A.T0488.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  110   95   5.0   88   1.76   27.27  85.660
REMARK  ---------------------------------------------------------- 
MOLECULE 1x5q_A
HEADER    CELL ADHESION, CELL CYCLE               16-MAY-05   1X5Q              
TITLE     SOLUTION STRUCTURE OF THE FIRST PDZ DOMAIN OF SCRIBBLE                
TITLE    2 HOMOLOG PROTEIN (HSCRIB)                                             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: LAP4 PROTEIN;                                              
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: PDZ DOMAIN;                                                
COMPND   5 SYNONYM: SCRIBBLE HOMOLOG PROTEIN, HSCRIB;                           
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: SCRIB, CRIB1, KIAA0147, LAP4, SCRB1, VARTUL;                   
SOURCE   5 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   6 EXPRESSION_SYSTEM_PLASMID: P040628-05;                               
SOURCE   7 OTHER_DETAILS: CELL FREE PROTEIN SYNTHESIS                           
KEYWDS    PDZ DOMAIN, LAP4 PROTEIN, SCRIBBLE HOMOLOG PROTEIN, HSCRIB ,          
KEYWDS   2 STRUCTURAL GENOMICS, NPPSFA, NATIONAL PROJECT ON PROTEIN             
KEYWDS   3 STRUCTURAL AND FUNCTIONAL ANALYSES, RIKEN STRUCTURAL                 
KEYWDS   4 GENOMICS/PROTEOMICS INITIATIVE, RSGI                                 
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    X.R.QIN,T.NAGASHIMA,F.HAYASHI,S.YOKOYAMA,RIKEN STRUCTURAL             
AUTHOR   2 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   1   16-NOV-05 1X5Q    0                                                
JRNL        AUTH   X.R.QIN,T.NAGASHIMA,F.HAYASHI,S.YOKOYAMA                     
JRNL        TITL   SOLUTION STRUCTURE OF THE FIRST PDZ DOMAIN OF                
JRNL        TITL 2 SCRIBBLE HOMOLOG PROTEIN (HSCRIB)                            
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  1X5Q A    8   104  UNP    Q14160   LAP4_HUMAN     718    814             
SEQRES   1 A  110  GLY SER SER GLY SER SER GLY GLU PRO ALA ARG ILE GLU          
SEQRES   2 A  110  GLU GLU GLU LEU THR LEU THR ILE LEU ARG GLN THR GLY          
SEQRES   3 A  110  GLY LEU GLY ILE SER ILE ALA GLY GLY LYS GLY SER THR          
SEQRES   4 A  110  PRO TYR LYS GLY ASP ASP GLU GLY ILE PHE ILE SER ARG          
SEQRES   5 A  110  VAL SER GLU GLU GLY PRO ALA ALA ARG ALA GLY VAL ARG          
SEQRES   6 A  110  VAL GLY ASP LYS LEU LEU GLU VAL ASN GLY VAL ALA LEU          
SEQRES   7 A  110  GLN GLY ALA GLU HIS HIS GLU ALA VAL GLU ALA LEU ARG          
SEQRES   8 A  110  GLY ALA GLY THR ALA VAL GLN MET ARG VAL TRP ARG GLU          
SEQRES   9 A  110  SER GLY PRO SER SER GLY                                      
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      40.018 -12.222  37.893  1.00  0.00           N  
ATOM      2  CA  GLY A   1      39.486 -11.682  36.653  1.00  0.00           C  
ATOM      3  C   GLY A   1      39.708 -10.170  36.575  1.00  0.00           C  
ATOM      4  O   GLY A   1      40.836  -9.697  36.708  1.00  0.00           O  
ATOM      5  HA2 GLY A   1      39.967 -12.168  35.804  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      38.420 -11.900  36.584  1.00  0.00           H  
ATOM      7  H1  GLY A   1      39.996 -11.595  38.671  1.00  0.00           H  
ATOM      8  N   SER A   2      38.614  -9.454  36.360  1.00  0.00           N  
ATOM      9  CA  SER A   2      38.675  -8.006  36.263  1.00  0.00           C  
ATOM     10  C   SER A   2      37.514  -7.380  37.037  1.00  0.00           C  
ATOM     11  O   SER A   2      36.538  -8.058  37.354  1.00  0.00           O  
ATOM     12  CB  SER A   2      38.646  -7.550  34.802  1.00  0.00           C  
ATOM     13  OG  SER A   2      37.500  -8.041  34.112  1.00  0.00           O  
ATOM     14  H   SER A   2      37.701  -9.846  36.253  1.00  0.00           H  
ATOM     15  HA  SER A   2      39.629  -7.726  36.710  1.00  0.00           H  
ATOM     16  HB2 SER A   2      38.654  -6.461  34.762  1.00  0.00           H  
ATOM     17  HB3 SER A   2      39.548  -7.894  34.297  1.00  0.00           H  
ATOM     18  HG  SER A   2      37.775  -8.458  33.245  1.00  0.00           H  
ATOM     19  N   SER A   3      37.658  -6.093  37.319  1.00  0.00           N  
ATOM     20  CA  SER A   3      36.633  -5.368  38.052  1.00  0.00           C  
ATOM     21  C   SER A   3      36.304  -4.058  37.332  1.00  0.00           C  
ATOM     22  O   SER A   3      37.060  -3.614  36.469  1.00  0.00           O  
ATOM     23  CB  SER A   3      37.076  -5.088  39.488  1.00  0.00           C  
ATOM     24  OG  SER A   3      35.971  -4.804  40.342  1.00  0.00           O  
ATOM     25  H   SER A   3      38.455  -5.549  37.058  1.00  0.00           H  
ATOM     26  HA  SER A   3      35.765  -6.028  38.061  1.00  0.00           H  
ATOM     27  HB2 SER A   3      37.620  -5.950  39.875  1.00  0.00           H  
ATOM     28  HB3 SER A   3      37.767  -4.245  39.497  1.00  0.00           H  
ATOM     29  HG  SER A   3      35.717  -5.622  40.856  1.00  0.00           H  
ATOM     30  N   GLY A   4      35.176  -3.478  37.714  1.00  0.00           N  
ATOM     31  CA  GLY A   4      34.739  -2.228  37.117  1.00  0.00           C  
ATOM     32  C   GLY A   4      35.740  -1.106  37.396  1.00  0.00           C  
ATOM     33  O   GLY A   4      35.967  -0.743  38.550  1.00  0.00           O  
ATOM     34  H   GLY A   4      34.568  -3.847  38.416  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      34.621  -2.356  36.040  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      33.761  -1.954  37.513  1.00  0.00           H  
ATOM     37  N   SER A   5      36.315  -0.588  36.321  1.00  0.00           N  
ATOM     38  CA  SER A   5      37.288   0.486  36.435  1.00  0.00           C  
ATOM     39  C   SER A   5      36.895   1.648  35.521  1.00  0.00           C  
ATOM     40  O   SER A   5      36.702   2.770  35.985  1.00  0.00           O  
ATOM     41  CB  SER A   5      38.694  -0.008  36.092  1.00  0.00           C  
ATOM     42  OG  SER A   5      39.630   0.285  37.127  1.00  0.00           O  
ATOM     43  H   SER A   5      36.126  -0.888  35.386  1.00  0.00           H  
ATOM     44  HA  SER A   5      37.256   0.794  37.480  1.00  0.00           H  
ATOM     45  HB2 SER A   5      38.670  -1.083  35.920  1.00  0.00           H  
ATOM     46  HB3 SER A   5      39.025   0.457  35.163  1.00  0.00           H  
ATOM     47  HG  SER A   5      39.527   1.235  37.422  1.00  0.00           H  
ATOM     48  N   SER A   6      36.788   1.339  34.237  1.00  0.00           N  
ATOM     49  CA  SER A   6      36.422   2.344  33.253  1.00  0.00           C  
ATOM     50  C   SER A   6      35.100   3.007  33.650  1.00  0.00           C  
ATOM     51  O   SER A   6      34.343   2.460  34.450  1.00  0.00           O  
ATOM     52  CB  SER A   6      36.309   1.731  31.856  1.00  0.00           C  
ATOM     53  OG  SER A   6      36.848   2.588  30.853  1.00  0.00           O  
ATOM     54  H   SER A   6      36.946   0.423  33.867  1.00  0.00           H  
ATOM     55  HA  SER A   6      37.234   3.070  33.267  1.00  0.00           H  
ATOM     56  HB2 SER A   6      36.834   0.776  31.835  1.00  0.00           H  
ATOM     57  HB3 SER A   6      35.263   1.525  31.633  1.00  0.00           H  
ATOM     58  HG  SER A   6      37.846   2.521  30.845  1.00  0.00           H  
ATOM     59  N   GLY A   7      34.865   4.176  33.072  1.00  0.00           N  
ATOM     60  CA  GLY A   7      33.649   4.919  33.353  1.00  0.00           C  
ATOM     61  C   GLY A   7      33.300   5.860  32.198  1.00  0.00           C  
ATOM     62  O   GLY A   7      32.651   5.454  31.236  1.00  0.00           O  
ATOM     63  H   GLY A   7      35.487   4.613  32.421  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      32.826   4.226  33.524  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      33.775   5.494  34.271  1.00  0.00           H  
ATOM     66  N   GLU A   8      33.748   7.100  32.333  1.00  0.00           N  
ATOM     67  CA  GLU A   8      33.491   8.102  31.312  1.00  0.00           C  
ATOM     68  C   GLU A   8      32.007   8.112  30.939  1.00  0.00           C  
ATOM     69  O   GLU A   8      31.592   7.421  30.010  1.00  0.00           O  
ATOM     70  CB  GLU A   8      34.365   7.864  30.079  1.00  0.00           C  
ATOM     71  CG  GLU A   8      35.296   9.052  29.830  1.00  0.00           C  
ATOM     72  CD  GLU A   8      34.834   9.868  28.621  1.00  0.00           C  
ATOM     73  OE1 GLU A   8      35.289   9.538  27.505  1.00  0.00           O  
ATOM     74  OE2 GLU A   8      34.035  10.804  28.840  1.00  0.00           O  
ATOM     75  H   GLU A   8      34.275   7.423  33.119  1.00  0.00           H  
ATOM     76  HA  GLU A   8      33.766   9.054  31.766  1.00  0.00           H  
ATOM     77  HB2 GLU A   8      34.954   6.958  30.215  1.00  0.00           H  
ATOM     78  HB3 GLU A   8      33.732   7.705  29.205  1.00  0.00           H  
ATOM     79  HG2 GLU A   8      35.324   9.689  30.713  1.00  0.00           H  
ATOM     80  HG3 GLU A   8      36.313   8.693  29.664  1.00  0.00           H  
ATOM     81  N   PRO A   9      31.229   8.925  31.702  1.00  0.00           N  
ATOM     82  CA  PRO A   9      29.801   9.035  31.462  1.00  0.00           C  
ATOM     83  C   PRO A   9      29.517   9.876  30.215  1.00  0.00           C  
ATOM     84  O   PRO A   9      29.842  11.062  30.174  1.00  0.00           O  
ATOM     85  CB  PRO A   9      29.233   9.647  32.732  1.00  0.00           C  
ATOM     86  CG  PRO A   9      30.411  10.284  33.451  1.00  0.00           C  
ATOM     87  CD  PRO A   9      31.687   9.759  32.810  1.00  0.00           C  
ATOM     88  HA  PRO A   9      29.410   8.133  31.277  1.00  0.00           H  
ATOM     89  HB2 PRO A   9      28.469  10.388  32.501  1.00  0.00           H  
ATOM     90  HB3 PRO A   9      28.761   8.887  33.355  1.00  0.00           H  
ATOM     91  HG2 PRO A   9      30.365  11.370  33.373  1.00  0.00           H  
ATOM     92  HG3 PRO A   9      30.389  10.039  34.512  1.00  0.00           H  
ATOM     93  HD2 PRO A   9      32.317  10.575  32.458  1.00  0.00           H  
ATOM     94  HD3 PRO A   9      32.278   9.182  33.521  1.00  0.00           H  
ATOM     95  N   ALA A  10      28.915   9.230  29.229  1.00  0.00           N  
ATOM     96  CA  ALA A  10      28.584   9.903  27.984  1.00  0.00           C  
ATOM     97  C   ALA A  10      27.144  10.414  28.053  1.00  0.00           C  
ATOM     98  O   ALA A  10      26.267   9.741  28.593  1.00  0.00           O  
ATOM     99  CB  ALA A  10      28.808   8.947  26.811  1.00  0.00           C  
ATOM    100  H   ALA A  10      28.653   8.265  29.269  1.00  0.00           H  
ATOM    101  HA  ALA A  10      29.258  10.754  27.878  1.00  0.00           H  
ATOM    102  HB1 ALA A  10      29.273   8.030  27.173  1.00  0.00           H  
ATOM    103  HB2 ALA A  10      27.851   8.710  26.347  1.00  0.00           H  
ATOM    104  HB3 ALA A  10      29.460   9.420  26.077  1.00  0.00           H  
ATOM    105  N   ARG A  11      26.943  11.601  27.499  1.00  0.00           N  
ATOM    106  CA  ARG A  11      25.624  12.210  27.491  1.00  0.00           C  
ATOM    107  C   ARG A  11      24.839  11.759  26.257  1.00  0.00           C  
ATOM    108  O   ARG A  11      25.401  11.633  25.170  1.00  0.00           O  
ATOM    109  CB  ARG A  11      25.722  13.737  27.493  1.00  0.00           C  
ATOM    110  CG  ARG A  11      26.154  14.256  28.867  1.00  0.00           C  
ATOM    111  CD  ARG A  11      25.520  15.616  29.163  1.00  0.00           C  
ATOM    112  NE  ARG A  11      25.273  15.754  30.616  1.00  0.00           N  
ATOM    113  CZ  ARG A  11      24.809  16.869  31.196  1.00  0.00           C  
ATOM    114  NH1 ARG A  11      24.538  17.949  30.451  1.00  0.00           N  
ATOM    115  NH2 ARG A  11      24.615  16.904  32.522  1.00  0.00           N  
ATOM    116  H   ARG A  11      27.662  12.142  27.062  1.00  0.00           H  
ATOM    117  HA  ARG A  11      25.149  11.860  28.406  1.00  0.00           H  
ATOM    118  HB2 ARG A  11      26.438  14.060  26.738  1.00  0.00           H  
ATOM    119  HB3 ARG A  11      24.758  14.168  27.224  1.00  0.00           H  
ATOM    120  HG2 ARG A  11      25.865  13.540  29.637  1.00  0.00           H  
ATOM    121  HG3 ARG A  11      27.240  14.341  28.902  1.00  0.00           H  
ATOM    122  HD2 ARG A  11      26.177  16.415  28.820  1.00  0.00           H  
ATOM    123  HD3 ARG A  11      24.582  15.717  28.616  1.00  0.00           H  
ATOM    124  HE  ARG A  11      25.465  14.966  31.201  1.00  0.00           H  
ATOM    125 HH11 ARG A  11      24.682  17.924  29.462  1.00  0.00           H  
ATOM    126 HH12 ARG A  11      24.191  18.781  30.884  1.00  0.00           H  
ATOM    127 HH21 ARG A  11      24.817  16.097  33.078  1.00  0.00           H  
ATOM    128 HH22 ARG A  11      24.268  17.736  32.955  1.00  0.00           H  
ATOM    129  N   ILE A  12      23.551  11.527  26.467  1.00  0.00           N  
ATOM    130  CA  ILE A  12      22.683  11.093  25.385  1.00  0.00           C  
ATOM    131  C   ILE A  12      21.696  12.213  25.049  1.00  0.00           C  
ATOM    132  O   ILE A  12      21.146  12.850  25.946  1.00  0.00           O  
ATOM    133  CB  ILE A  12      22.010   9.766  25.738  1.00  0.00           C  
ATOM    134  CG1 ILE A  12      23.052   8.674  25.994  1.00  0.00           C  
ATOM    135  CG2 ILE A  12      21.004   9.357  24.661  1.00  0.00           C  
ATOM    136  CD1 ILE A  12      23.675   8.192  24.682  1.00  0.00           C  
ATOM    137  H   ILE A  12      23.102  11.633  27.354  1.00  0.00           H  
ATOM    138  HA  ILE A  12      23.313  10.914  24.514  1.00  0.00           H  
ATOM    139  HB  ILE A  12      21.453   9.901  26.665  1.00  0.00           H  
ATOM    140 HG12 ILE A  12      23.832   9.058  26.652  1.00  0.00           H  
ATOM    141 HG13 ILE A  12      22.585   7.835  26.510  1.00  0.00           H  
ATOM    142 HG21 ILE A  12      20.006   9.309  25.096  1.00  0.00           H  
ATOM    143 HG22 ILE A  12      21.015  10.091  23.856  1.00  0.00           H  
ATOM    144 HG23 ILE A  12      21.275   8.379  24.263  1.00  0.00           H  
ATOM    145 HD11 ILE A  12      23.341   8.832  23.865  1.00  0.00           H  
ATOM    146 HD12 ILE A  12      24.761   8.236  24.758  1.00  0.00           H  
ATOM    147 HD13 ILE A  12      23.365   7.166  24.488  1.00  0.00           H  
ATOM    148  N   GLU A  13      21.501  12.418  23.754  1.00  0.00           N  
ATOM    149  CA  GLU A  13      20.590  13.448  23.289  1.00  0.00           C  
ATOM    150  C   GLU A  13      20.494  13.421  21.762  1.00  0.00           C  
ATOM    151  O   GLU A  13      21.501  13.258  21.075  1.00  0.00           O  
ATOM    152  CB  GLU A  13      21.023  14.829  23.786  1.00  0.00           C  
ATOM    153  CG  GLU A  13      22.297  15.292  23.078  1.00  0.00           C  
ATOM    154  CD  GLU A  13      22.729  16.674  23.573  1.00  0.00           C  
ATOM    155  OE1 GLU A  13      23.314  16.725  24.675  1.00  0.00           O  
ATOM    156  OE2 GLU A  13      22.462  17.649  22.836  1.00  0.00           O  
ATOM    157  H   GLU A  13      21.952  11.895  23.032  1.00  0.00           H  
ATOM    158  HA  GLU A  13      19.623  13.199  23.725  1.00  0.00           H  
ATOM    159  HB2 GLU A  13      20.224  15.550  23.612  1.00  0.00           H  
ATOM    160  HB3 GLU A  13      21.192  14.795  24.863  1.00  0.00           H  
ATOM    161  HG2 GLU A  13      23.098  14.573  23.255  1.00  0.00           H  
ATOM    162  HG3 GLU A  13      22.129  15.323  22.002  1.00  0.00           H  
ATOM    163  N   GLU A  14      19.272  13.584  21.275  1.00  0.00           N  
ATOM    164  CA  GLU A  14      19.030  13.580  19.842  1.00  0.00           C  
ATOM    165  C   GLU A  14      20.169  14.293  19.111  1.00  0.00           C  
ATOM    166  O   GLU A  14      20.762  15.231  19.641  1.00  0.00           O  
ATOM    167  CB  GLU A  14      17.681  14.221  19.512  1.00  0.00           C  
ATOM    168  CG  GLU A  14      16.555  13.188  19.571  1.00  0.00           C  
ATOM    169  CD  GLU A  14      15.781  13.293  20.887  1.00  0.00           C  
ATOM    170  OE1 GLU A  14      15.230  14.387  21.135  1.00  0.00           O  
ATOM    171  OE2 GLU A  14      15.760  12.278  21.616  1.00  0.00           O  
ATOM    172  H   GLU A  14      18.458  13.717  21.841  1.00  0.00           H  
ATOM    173  HA  GLU A  14      19.007  12.530  19.555  1.00  0.00           H  
ATOM    174  HB2 GLU A  14      17.476  15.029  20.216  1.00  0.00           H  
ATOM    175  HB3 GLU A  14      17.719  14.667  18.517  1.00  0.00           H  
ATOM    176  HG2 GLU A  14      15.874  13.339  18.732  1.00  0.00           H  
ATOM    177  HG3 GLU A  14      16.970  12.185  19.468  1.00  0.00           H  
ATOM    178  N   GLU A  15      20.442  13.819  17.903  1.00  0.00           N  
ATOM    179  CA  GLU A  15      21.499  14.400  17.093  1.00  0.00           C  
ATOM    180  C   GLU A  15      20.917  15.009  15.816  1.00  0.00           C  
ATOM    181  O   GLU A  15      19.761  14.758  15.476  1.00  0.00           O  
ATOM    182  CB  GLU A  15      22.572  13.360  16.765  1.00  0.00           C  
ATOM    183  CG  GLU A  15      21.937  12.027  16.360  1.00  0.00           C  
ATOM    184  CD  GLU A  15      23.009  11.004  15.978  1.00  0.00           C  
ATOM    185  OE1 GLU A  15      23.879  10.745  16.837  1.00  0.00           O  
ATOM    186  OE2 GLU A  15      22.934  10.504  14.835  1.00  0.00           O  
ATOM    187  H   GLU A  15      19.955  13.057  17.479  1.00  0.00           H  
ATOM    188  HA  GLU A  15      21.939  15.185  17.709  1.00  0.00           H  
ATOM    189  HB2 GLU A  15      23.204  13.727  15.956  1.00  0.00           H  
ATOM    190  HB3 GLU A  15      23.217  13.211  17.631  1.00  0.00           H  
ATOM    191  HG2 GLU A  15      21.338  11.640  17.184  1.00  0.00           H  
ATOM    192  HG3 GLU A  15      21.261  12.183  15.519  1.00  0.00           H  
ATOM    193  N   GLU A  16      21.743  15.795  15.143  1.00  0.00           N  
ATOM    194  CA  GLU A  16      21.324  16.442  13.911  1.00  0.00           C  
ATOM    195  C   GLU A  16      21.510  15.493  12.725  1.00  0.00           C  
ATOM    196  O   GLU A  16      22.538  14.825  12.615  1.00  0.00           O  
ATOM    197  CB  GLU A  16      22.085  17.750  13.692  1.00  0.00           C  
ATOM    198  CG  GLU A  16      21.460  18.890  14.499  1.00  0.00           C  
ATOM    199  CD  GLU A  16      22.533  19.694  15.235  1.00  0.00           C  
ATOM    200  OE1 GLU A  16      23.578  19.960  14.603  1.00  0.00           O  
ATOM    201  OE2 GLU A  16      22.284  20.023  16.416  1.00  0.00           O  
ATOM    202  H   GLU A  16      22.681  15.994  15.426  1.00  0.00           H  
ATOM    203  HA  GLU A  16      20.265  16.663  14.045  1.00  0.00           H  
ATOM    204  HB2 GLU A  16      23.128  17.622  13.984  1.00  0.00           H  
ATOM    205  HB3 GLU A  16      22.081  18.005  12.631  1.00  0.00           H  
ATOM    206  HG2 GLU A  16      20.902  19.548  13.832  1.00  0.00           H  
ATOM    207  HG3 GLU A  16      20.747  18.484  15.216  1.00  0.00           H  
ATOM    208  N   LEU A  17      20.503  15.467  11.865  1.00  0.00           N  
ATOM    209  CA  LEU A  17      20.543  14.611  10.691  1.00  0.00           C  
ATOM    210  C   LEU A  17      20.022  15.389   9.481  1.00  0.00           C  
ATOM    211  O   LEU A  17      19.201  16.295   9.627  1.00  0.00           O  
ATOM    212  CB  LEU A  17      19.790  13.306  10.953  1.00  0.00           C  
ATOM    213  CG  LEU A  17      19.819  12.792  12.394  1.00  0.00           C  
ATOM    214  CD1 LEU A  17      18.660  11.828  12.657  1.00  0.00           C  
ATOM    215  CD2 LEU A  17      21.174  12.163  12.726  1.00  0.00           C  
ATOM    216  H   LEU A  17      19.671  16.014  11.962  1.00  0.00           H  
ATOM    217  HA  LEU A  17      21.586  14.352  10.511  1.00  0.00           H  
ATOM    218  HB2 LEU A  17      18.750  13.443  10.659  1.00  0.00           H  
ATOM    219  HB3 LEU A  17      20.206  12.533  10.306  1.00  0.00           H  
ATOM    220  HG  LEU A  17      19.687  13.644  13.063  1.00  0.00           H  
ATOM    221 HD11 LEU A  17      17.777  12.394  12.954  1.00  0.00           H  
ATOM    222 HD12 LEU A  17      18.443  11.267  11.748  1.00  0.00           H  
ATOM    223 HD13 LEU A  17      18.935  11.139  13.454  1.00  0.00           H  
ATOM    224 HD21 LEU A  17      21.021  11.271  13.333  1.00  0.00           H  
ATOM    225 HD22 LEU A  17      21.684  11.892  11.802  1.00  0.00           H  
ATOM    226 HD23 LEU A  17      21.781  12.880  13.280  1.00  0.00           H  
ATOM    227  N   THR A  18      20.518  15.007   8.314  1.00  0.00           N  
ATOM    228  CA  THR A  18      20.112  15.658   7.079  1.00  0.00           C  
ATOM    229  C   THR A  18      19.627  14.620   6.065  1.00  0.00           C  
ATOM    230  O   THR A  18      20.325  13.648   5.784  1.00  0.00           O  
ATOM    231  CB  THR A  18      21.290  16.494   6.577  1.00  0.00           C  
ATOM    232  OG1 THR A  18      21.589  17.362   7.666  1.00  0.00           O  
ATOM    233  CG2 THR A  18      20.893  17.443   5.443  1.00  0.00           C  
ATOM    234  H   THR A  18      21.184  14.270   8.204  1.00  0.00           H  
ATOM    235  HA  THR A  18      19.268  16.312   7.297  1.00  0.00           H  
ATOM    236  HB  THR A  18      22.122  15.856   6.278  1.00  0.00           H  
ATOM    237  HG1 THR A  18      22.387  17.023   8.165  1.00  0.00           H  
ATOM    238 HG21 THR A  18      21.640  18.231   5.350  1.00  0.00           H  
ATOM    239 HG22 THR A  18      20.835  16.886   4.507  1.00  0.00           H  
ATOM    240 HG23 THR A  18      19.922  17.886   5.663  1.00  0.00           H  
ATOM    241  N   LEU A  19      18.433  14.864   5.543  1.00  0.00           N  
ATOM    242  CA  LEU A  19      17.847  13.963   4.566  1.00  0.00           C  
ATOM    243  C   LEU A  19      17.571  14.731   3.271  1.00  0.00           C  
ATOM    244  O   LEU A  19      17.345  15.940   3.298  1.00  0.00           O  
ATOM    245  CB  LEU A  19      16.610  13.274   5.146  1.00  0.00           C  
ATOM    246  CG  LEU A  19      16.869  12.264   6.266  1.00  0.00           C  
ATOM    247  CD1 LEU A  19      15.594  11.996   7.069  1.00  0.00           C  
ATOM    248  CD2 LEU A  19      17.479  10.975   5.711  1.00  0.00           C  
ATOM    249  H   LEU A  19      17.872  15.658   5.777  1.00  0.00           H  
ATOM    250  HA  LEU A  19      18.581  13.185   4.356  1.00  0.00           H  
ATOM    251  HB2 LEU A  19      15.935  14.042   5.525  1.00  0.00           H  
ATOM    252  HB3 LEU A  19      16.089  12.763   4.337  1.00  0.00           H  
ATOM    253  HG  LEU A  19      17.597  12.695   6.953  1.00  0.00           H  
ATOM    254 HD11 LEU A  19      14.731  12.047   6.406  1.00  0.00           H  
ATOM    255 HD12 LEU A  19      15.650  11.005   7.518  1.00  0.00           H  
ATOM    256 HD13 LEU A  19      15.495  12.746   7.854  1.00  0.00           H  
ATOM    257 HD21 LEU A  19      18.249  11.223   4.981  1.00  0.00           H  
ATOM    258 HD22 LEU A  19      17.922  10.403   6.527  1.00  0.00           H  
ATOM    259 HD23 LEU A  19      16.701  10.381   5.233  1.00  0.00           H  
ATOM    260  N   THR A  20      17.600  13.997   2.169  1.00  0.00           N  
ATOM    261  CA  THR A  20      17.356  14.595   0.866  1.00  0.00           C  
ATOM    262  C   THR A  20      16.118  13.974   0.218  1.00  0.00           C  
ATOM    263  O   THR A  20      16.070  12.765  -0.006  1.00  0.00           O  
ATOM    264  CB  THR A  20      18.625  14.434   0.027  1.00  0.00           C  
ATOM    265  OG1 THR A  20      19.665  14.913   0.877  1.00  0.00           O  
ATOM    266  CG2 THR A  20      18.658  15.384  -1.172  1.00  0.00           C  
ATOM    267  H   THR A  20      17.785  13.015   2.154  1.00  0.00           H  
ATOM    268  HA  THR A  20      17.145  15.654   1.008  1.00  0.00           H  
ATOM    269  HB  THR A  20      18.754  13.400  -0.291  1.00  0.00           H  
ATOM    270  HG1 THR A  20      19.724  14.345   1.698  1.00  0.00           H  
ATOM    271 HG21 THR A  20      17.751  15.256  -1.762  1.00  0.00           H  
ATOM    272 HG22 THR A  20      18.720  16.413  -0.820  1.00  0.00           H  
ATOM    273 HG23 THR A  20      19.528  15.158  -1.791  1.00  0.00           H  
ATOM    274  N   ILE A  21      15.146  14.828  -0.066  1.00  0.00           N  
ATOM    275  CA  ILE A  21      13.909  14.378  -0.684  1.00  0.00           C  
ATOM    276  C   ILE A  21      13.893  14.807  -2.152  1.00  0.00           C  
ATOM    277  O   ILE A  21      14.555  15.774  -2.527  1.00  0.00           O  
ATOM    278  CB  ILE A  21      12.701  14.871   0.115  1.00  0.00           C  
ATOM    279  CG1 ILE A  21      12.791  14.426   1.576  1.00  0.00           C  
ATOM    280  CG2 ILE A  21      11.392  14.424  -0.541  1.00  0.00           C  
ATOM    281  CD1 ILE A  21      12.238  15.503   2.511  1.00  0.00           C  
ATOM    282  H   ILE A  21      15.192  15.809   0.120  1.00  0.00           H  
ATOM    283  HA  ILE A  21      13.901  13.289  -0.642  1.00  0.00           H  
ATOM    284  HB  ILE A  21      12.709  15.960   0.108  1.00  0.00           H  
ATOM    285 HG12 ILE A  21      12.233  13.499   1.713  1.00  0.00           H  
ATOM    286 HG13 ILE A  21      13.829  14.215   1.832  1.00  0.00           H  
ATOM    287 HG21 ILE A  21      10.549  14.809   0.032  1.00  0.00           H  
ATOM    288 HG22 ILE A  21      11.346  14.811  -1.559  1.00  0.00           H  
ATOM    289 HG23 ILE A  21      11.350  13.335  -0.563  1.00  0.00           H  
ATOM    290 HD11 ILE A  21      11.459  16.066   1.996  1.00  0.00           H  
ATOM    291 HD12 ILE A  21      11.817  15.032   3.399  1.00  0.00           H  
ATOM    292 HD13 ILE A  21      13.041  16.179   2.803  1.00  0.00           H  
ATOM    293  N   LEU A  22      13.131  14.067  -2.943  1.00  0.00           N  
ATOM    294  CA  LEU A  22      13.019  14.358  -4.363  1.00  0.00           C  
ATOM    295  C   LEU A  22      11.619  14.897  -4.660  1.00  0.00           C  
ATOM    296  O   LEU A  22      10.631  14.397  -4.123  1.00  0.00           O  
ATOM    297  CB  LEU A  22      13.395  13.130  -5.193  1.00  0.00           C  
ATOM    298  CG  LEU A  22      14.798  13.135  -5.802  1.00  0.00           C  
ATOM    299  CD1 LEU A  22      14.963  11.997  -6.811  1.00  0.00           C  
ATOM    300  CD2 LEU A  22      15.123  14.498  -6.418  1.00  0.00           C  
ATOM    301  H   LEU A  22      12.596  13.282  -2.630  1.00  0.00           H  
ATOM    302  HA  LEU A  22      13.746  15.138  -4.594  1.00  0.00           H  
ATOM    303  HB2 LEU A  22      13.298  12.246  -4.562  1.00  0.00           H  
ATOM    304  HB3 LEU A  22      12.670  13.026  -6.001  1.00  0.00           H  
ATOM    305  HG  LEU A  22      15.519  12.964  -5.003  1.00  0.00           H  
ATOM    306 HD11 LEU A  22      14.744  11.046  -6.325  1.00  0.00           H  
ATOM    307 HD12 LEU A  22      14.274  12.146  -7.643  1.00  0.00           H  
ATOM    308 HD13 LEU A  22      15.986  11.987  -7.185  1.00  0.00           H  
ATOM    309 HD21 LEU A  22      15.602  14.354  -7.387  1.00  0.00           H  
ATOM    310 HD22 LEU A  22      14.202  15.066  -6.549  1.00  0.00           H  
ATOM    311 HD23 LEU A  22      15.797  15.044  -5.758  1.00  0.00           H  
ATOM    312  N   ARG A  23      11.578  15.910  -5.513  1.00  0.00           N  
ATOM    313  CA  ARG A  23      10.315  16.522  -5.888  1.00  0.00           C  
ATOM    314  C   ARG A  23      10.109  16.431  -7.402  1.00  0.00           C  
ATOM    315  O   ARG A  23      10.729  17.174  -8.162  1.00  0.00           O  
ATOM    316  CB  ARG A  23      10.265  17.990  -5.461  1.00  0.00           C  
ATOM    317  CG  ARG A  23       9.168  18.744  -6.215  1.00  0.00           C  
ATOM    318  CD  ARG A  23       9.101  20.206  -5.767  1.00  0.00           C  
ATOM    319  NE  ARG A  23       7.948  20.878  -6.407  1.00  0.00           N  
ATOM    320  CZ  ARG A  23       7.864  22.201  -6.605  1.00  0.00           C  
ATOM    321  NH1 ARG A  23       8.865  23.001  -6.213  1.00  0.00           N  
ATOM    322  NH2 ARG A  23       6.780  22.723  -7.193  1.00  0.00           N  
ATOM    323  H   ARG A  23      12.386  16.310  -5.944  1.00  0.00           H  
ATOM    324  HA  ARG A  23       9.557  15.947  -5.354  1.00  0.00           H  
ATOM    325  HB2 ARG A  23      10.084  18.054  -4.388  1.00  0.00           H  
ATOM    326  HB3 ARG A  23      11.230  18.461  -5.650  1.00  0.00           H  
ATOM    327  HG2 ARG A  23       9.360  18.697  -7.287  1.00  0.00           H  
ATOM    328  HG3 ARG A  23       8.205  18.262  -6.042  1.00  0.00           H  
ATOM    329  HD2 ARG A  23       9.008  20.259  -4.683  1.00  0.00           H  
ATOM    330  HD3 ARG A  23      10.025  20.719  -6.034  1.00  0.00           H  
ATOM    331  HE  ARG A  23       7.182  20.309  -6.711  1.00  0.00           H  
ATOM    332 HH11 ARG A  23       9.674  22.611  -5.775  1.00  0.00           H  
ATOM    333 HH12 ARG A  23       8.802  23.988  -6.361  1.00  0.00           H  
ATOM    334 HH21 ARG A  23       6.033  22.126  -7.484  1.00  0.00           H  
ATOM    335 HH22 ARG A  23       6.718  23.711  -7.340  1.00  0.00           H  
ATOM    336  N   GLN A  24       9.237  15.514  -7.795  1.00  0.00           N  
ATOM    337  CA  GLN A  24       8.943  15.316  -9.204  1.00  0.00           C  
ATOM    338  C   GLN A  24       7.535  15.821  -9.527  1.00  0.00           C  
ATOM    339  O   GLN A  24       7.123  15.819 -10.686  1.00  0.00           O  
ATOM    340  CB  GLN A  24       9.102  13.846  -9.596  1.00  0.00           C  
ATOM    341  CG  GLN A  24       8.192  12.952  -8.752  1.00  0.00           C  
ATOM    342  CD  GLN A  24       8.238  11.504  -9.244  1.00  0.00           C  
ATOM    343  OE1 GLN A  24       8.904  10.651  -8.681  1.00  0.00           O  
ATOM    344  NE2 GLN A  24       7.495  11.275 -10.323  1.00  0.00           N  
ATOM    345  H   GLN A  24       8.738  14.914  -7.170  1.00  0.00           H  
ATOM    346  HA  GLN A  24       9.681  15.912  -9.741  1.00  0.00           H  
ATOM    347  HB2 GLN A  24       8.864  13.721 -10.653  1.00  0.00           H  
ATOM    348  HB3 GLN A  24      10.140  13.542  -9.466  1.00  0.00           H  
ATOM    349  HG2 GLN A  24       8.501  12.995  -7.707  1.00  0.00           H  
ATOM    350  HG3 GLN A  24       7.168  13.323  -8.797  1.00  0.00           H  
ATOM    351 HE21 GLN A  24       6.972  12.020 -10.737  1.00  0.00           H  
ATOM    352 HE22 GLN A  24       7.460  10.359 -10.721  1.00  0.00           H  
ATOM    353  N   THR A  25       6.837  16.242  -8.483  1.00  0.00           N  
ATOM    354  CA  THR A  25       5.485  16.749  -8.642  1.00  0.00           C  
ATOM    355  C   THR A  25       4.987  17.360  -7.331  1.00  0.00           C  
ATOM    356  O   THR A  25       5.407  16.948  -6.250  1.00  0.00           O  
ATOM    357  CB  THR A  25       4.607  15.603  -9.149  1.00  0.00           C  
ATOM    358  OG1 THR A  25       3.287  16.138  -9.123  1.00  0.00           O  
ATOM    359  CG2 THR A  25       4.552  14.428  -8.170  1.00  0.00           C  
ATOM    360  H   THR A  25       7.181  16.241  -7.544  1.00  0.00           H  
ATOM    361  HA  THR A  25       5.502  17.549  -9.382  1.00  0.00           H  
ATOM    362  HB  THR A  25       4.932  15.272 -10.136  1.00  0.00           H  
ATOM    363  HG1 THR A  25       2.839  15.987 -10.005  1.00  0.00           H  
ATOM    364 HG21 THR A  25       5.129  14.673  -7.277  1.00  0.00           H  
ATOM    365 HG22 THR A  25       3.516  14.236  -7.892  1.00  0.00           H  
ATOM    366 HG23 THR A  25       4.974  13.542  -8.642  1.00  0.00           H  
ATOM    367  N   GLY A  26       4.098  18.334  -7.469  1.00  0.00           N  
ATOM    368  CA  GLY A  26       3.539  19.006  -6.309  1.00  0.00           C  
ATOM    369  C   GLY A  26       4.608  19.232  -5.237  1.00  0.00           C  
ATOM    370  O   GLY A  26       5.605  19.910  -5.482  1.00  0.00           O  
ATOM    371  H   GLY A  26       3.762  18.662  -8.351  1.00  0.00           H  
ATOM    372  HA2 GLY A  26       3.112  19.964  -6.609  1.00  0.00           H  
ATOM    373  HA3 GLY A  26       2.725  18.410  -5.895  1.00  0.00           H  
ATOM    374  N   GLY A  27       4.363  18.650  -4.072  1.00  0.00           N  
ATOM    375  CA  GLY A  27       5.293  18.779  -2.961  1.00  0.00           C  
ATOM    376  C   GLY A  27       5.759  17.406  -2.475  1.00  0.00           C  
ATOM    377  O   GLY A  27       5.778  16.444  -3.242  1.00  0.00           O  
ATOM    378  H   GLY A  27       3.550  18.101  -3.880  1.00  0.00           H  
ATOM    379  HA2 GLY A  27       6.154  19.371  -3.271  1.00  0.00           H  
ATOM    380  HA3 GLY A  27       4.814  19.317  -2.143  1.00  0.00           H  
ATOM    381  N   LEU A  28       6.122  17.357  -1.202  1.00  0.00           N  
ATOM    382  CA  LEU A  28       6.587  16.117  -0.603  1.00  0.00           C  
ATOM    383  C   LEU A  28       5.384  15.319  -0.095  1.00  0.00           C  
ATOM    384  O   LEU A  28       4.243  15.627  -0.433  1.00  0.00           O  
ATOM    385  CB  LEU A  28       7.635  16.403   0.475  1.00  0.00           C  
ATOM    386  CG  LEU A  28       8.713  17.425   0.108  1.00  0.00           C  
ATOM    387  CD1 LEU A  28       9.622  17.716   1.304  1.00  0.00           C  
ATOM    388  CD2 LEU A  28       9.507  16.968  -1.117  1.00  0.00           C  
ATOM    389  H   LEU A  28       6.103  18.143  -0.584  1.00  0.00           H  
ATOM    390  HA  LEU A  28       7.079  15.541  -1.386  1.00  0.00           H  
ATOM    391  HB2 LEU A  28       7.121  16.753   1.370  1.00  0.00           H  
ATOM    392  HB3 LEU A  28       8.125  15.465   0.735  1.00  0.00           H  
ATOM    393  HG  LEU A  28       8.221  18.360  -0.158  1.00  0.00           H  
ATOM    394 HD11 LEU A  28       9.407  18.713   1.690  1.00  0.00           H  
ATOM    395 HD12 LEU A  28       9.442  16.977   2.086  1.00  0.00           H  
ATOM    396 HD13 LEU A  28      10.665  17.665   0.989  1.00  0.00           H  
ATOM    397 HD21 LEU A  28       9.047  16.073  -1.536  1.00  0.00           H  
ATOM    398 HD22 LEU A  28       9.508  17.761  -1.865  1.00  0.00           H  
ATOM    399 HD23 LEU A  28      10.533  16.745  -0.822  1.00  0.00           H  
ATOM    400  N   GLY A  29       5.683  14.309   0.709  1.00  0.00           N  
ATOM    401  CA  GLY A  29       4.640  13.464   1.266  1.00  0.00           C  
ATOM    402  C   GLY A  29       4.843  13.262   2.770  1.00  0.00           C  
ATOM    403  O   GLY A  29       5.059  12.141   3.225  1.00  0.00           O  
ATOM    404  H   GLY A  29       6.613  14.065   0.979  1.00  0.00           H  
ATOM    405  HA2 GLY A  29       3.664  13.916   1.085  1.00  0.00           H  
ATOM    406  HA3 GLY A  29       4.642  12.497   0.763  1.00  0.00           H  
ATOM    407  N   ILE A  30       4.767  14.367   3.498  1.00  0.00           N  
ATOM    408  CA  ILE A  30       4.940  14.325   4.940  1.00  0.00           C  
ATOM    409  C   ILE A  30       4.004  15.346   5.590  1.00  0.00           C  
ATOM    410  O   ILE A  30       3.393  16.161   4.901  1.00  0.00           O  
ATOM    411  CB  ILE A  30       6.412  14.518   5.308  1.00  0.00           C  
ATOM    412  CG1 ILE A  30       7.043  15.639   4.481  1.00  0.00           C  
ATOM    413  CG2 ILE A  30       7.186  13.205   5.178  1.00  0.00           C  
ATOM    414  CD1 ILE A  30       7.622  16.729   5.387  1.00  0.00           C  
ATOM    415  H   ILE A  30       4.591  15.275   3.119  1.00  0.00           H  
ATOM    416  HA  ILE A  30       4.651  13.329   5.275  1.00  0.00           H  
ATOM    417  HB  ILE A  30       6.466  14.820   6.354  1.00  0.00           H  
ATOM    418 HG12 ILE A  30       7.830  15.231   3.848  1.00  0.00           H  
ATOM    419 HG13 ILE A  30       6.293  16.072   3.819  1.00  0.00           H  
ATOM    420 HG21 ILE A  30       8.255  13.405   5.247  1.00  0.00           H  
ATOM    421 HG22 ILE A  30       6.891  12.528   5.980  1.00  0.00           H  
ATOM    422 HG23 ILE A  30       6.963  12.746   4.215  1.00  0.00           H  
ATOM    423 HD11 ILE A  30       8.669  16.508   5.596  1.00  0.00           H  
ATOM    424 HD12 ILE A  30       7.549  17.694   4.886  1.00  0.00           H  
ATOM    425 HD13 ILE A  30       7.063  16.760   6.321  1.00  0.00           H  
ATOM    426  N   SER A  31       3.922  15.269   6.911  1.00  0.00           N  
ATOM    427  CA  SER A  31       3.072  16.175   7.662  1.00  0.00           C  
ATOM    428  C   SER A  31       3.862  16.802   8.812  1.00  0.00           C  
ATOM    429  O   SER A  31       4.660  16.129   9.462  1.00  0.00           O  
ATOM    430  CB  SER A  31       1.836  15.452   8.200  1.00  0.00           C  
ATOM    431  OG  SER A  31       0.902  15.149   7.167  1.00  0.00           O  
ATOM    432  H   SER A  31       4.423  14.603   7.464  1.00  0.00           H  
ATOM    433  HA  SER A  31       2.763  16.939   6.949  1.00  0.00           H  
ATOM    434  HB2 SER A  31       2.142  14.530   8.695  1.00  0.00           H  
ATOM    435  HB3 SER A  31       1.352  16.073   8.955  1.00  0.00           H  
ATOM    436  HG  SER A  31       1.127  15.663   6.340  1.00  0.00           H  
ATOM    437  N   ILE A  32       3.613  18.086   9.028  1.00  0.00           N  
ATOM    438  CA  ILE A  32       4.292  18.811  10.088  1.00  0.00           C  
ATOM    439  C   ILE A  32       3.267  19.256  11.134  1.00  0.00           C  
ATOM    440  O   ILE A  32       2.083  19.394  10.828  1.00  0.00           O  
ATOM    441  CB  ILE A  32       5.116  19.962   9.508  1.00  0.00           C  
ATOM    442  CG1 ILE A  32       4.218  20.974   8.794  1.00  0.00           C  
ATOM    443  CG2 ILE A  32       6.226  19.435   8.594  1.00  0.00           C  
ATOM    444  CD1 ILE A  32       4.936  22.314   8.618  1.00  0.00           C  
ATOM    445  H   ILE A  32       2.962  18.627   8.495  1.00  0.00           H  
ATOM    446  HA  ILE A  32       4.991  18.121  10.562  1.00  0.00           H  
ATOM    447  HB  ILE A  32       5.600  20.486  10.332  1.00  0.00           H  
ATOM    448 HG12 ILE A  32       3.928  20.583   7.818  1.00  0.00           H  
ATOM    449 HG13 ILE A  32       3.302  21.120   9.365  1.00  0.00           H  
ATOM    450 HG21 ILE A  32       5.785  19.035   7.681  1.00  0.00           H  
ATOM    451 HG22 ILE A  32       6.907  20.248   8.344  1.00  0.00           H  
ATOM    452 HG23 ILE A  32       6.775  18.646   9.108  1.00  0.00           H  
ATOM    453 HD11 ILE A  32       4.495  23.053   9.287  1.00  0.00           H  
ATOM    454 HD12 ILE A  32       5.992  22.195   8.854  1.00  0.00           H  
ATOM    455 HD13 ILE A  32       4.830  22.651   7.586  1.00  0.00           H  
ATOM    456  N   ALA A  33       3.758  19.470  12.345  1.00  0.00           N  
ATOM    457  CA  ALA A  33       2.900  19.897  13.437  1.00  0.00           C  
ATOM    458  C   ALA A  33       3.727  20.692  14.449  1.00  0.00           C  
ATOM    459  O   ALA A  33       4.918  20.438  14.619  1.00  0.00           O  
ATOM    460  CB  ALA A  33       2.228  18.674  14.066  1.00  0.00           C  
ATOM    461  H   ALA A  33       4.722  19.356  12.586  1.00  0.00           H  
ATOM    462  HA  ALA A  33       2.130  20.544  13.019  1.00  0.00           H  
ATOM    463  HB1 ALA A  33       1.479  18.277  13.380  1.00  0.00           H  
ATOM    464  HB2 ALA A  33       2.979  17.909  14.266  1.00  0.00           H  
ATOM    465  HB3 ALA A  33       1.747  18.964  15.000  1.00  0.00           H  
ATOM    466  N   GLY A  34       3.061  21.640  15.094  1.00  0.00           N  
ATOM    467  CA  GLY A  34       3.719  22.474  16.084  1.00  0.00           C  
ATOM    468  C   GLY A  34       3.753  23.936  15.633  1.00  0.00           C  
ATOM    469  O   GLY A  34       2.710  24.533  15.372  1.00  0.00           O  
ATOM    470  H   GLY A  34       2.092  21.840  14.949  1.00  0.00           H  
ATOM    471  HA2 GLY A  34       3.196  22.396  17.037  1.00  0.00           H  
ATOM    472  HA3 GLY A  34       4.736  22.117  16.249  1.00  0.00           H  
ATOM    473  N   GLY A  35       4.963  24.471  15.557  1.00  0.00           N  
ATOM    474  CA  GLY A  35       5.146  25.851  15.142  1.00  0.00           C  
ATOM    475  C   GLY A  35       4.666  26.817  16.226  1.00  0.00           C  
ATOM    476  O   GLY A  35       3.611  26.610  16.824  1.00  0.00           O  
ATOM    477  H   GLY A  35       5.806  23.978  15.771  1.00  0.00           H  
ATOM    478  HA2 GLY A  35       6.200  26.033  14.929  1.00  0.00           H  
ATOM    479  HA3 GLY A  35       4.598  26.034  14.218  1.00  0.00           H  
ATOM    480  N   LYS A  36       5.463  27.853  16.447  1.00  0.00           N  
ATOM    481  CA  LYS A  36       5.131  28.853  17.448  1.00  0.00           C  
ATOM    482  C   LYS A  36       3.720  29.383  17.186  1.00  0.00           C  
ATOM    483  O   LYS A  36       3.358  29.654  16.042  1.00  0.00           O  
ATOM    484  CB  LYS A  36       6.202  29.945  17.490  1.00  0.00           C  
ATOM    485  CG  LYS A  36       5.728  31.146  18.311  1.00  0.00           C  
ATOM    486  CD  LYS A  36       6.704  32.317  18.183  1.00  0.00           C  
ATOM    487  CE  LYS A  36       7.999  32.037  18.945  1.00  0.00           C  
ATOM    488  NZ  LYS A  36       8.089  32.895  20.148  1.00  0.00           N  
ATOM    489  H   LYS A  36       6.318  28.015  15.955  1.00  0.00           H  
ATOM    490  HA  LYS A  36       5.138  28.356  18.419  1.00  0.00           H  
ATOM    491  HB2 LYS A  36       7.119  29.544  17.920  1.00  0.00           H  
ATOM    492  HB3 LYS A  36       6.439  30.265  16.475  1.00  0.00           H  
ATOM    493  HG2 LYS A  36       4.738  31.454  17.974  1.00  0.00           H  
ATOM    494  HG3 LYS A  36       5.633  30.860  19.358  1.00  0.00           H  
ATOM    495  HD2 LYS A  36       6.927  32.494  17.131  1.00  0.00           H  
ATOM    496  HD3 LYS A  36       6.240  33.225  18.568  1.00  0.00           H  
ATOM    497  HE2 LYS A  36       8.038  30.987  19.236  1.00  0.00           H  
ATOM    498  HE3 LYS A  36       8.857  32.219  18.298  1.00  0.00           H  
ATOM    499  HZ1 LYS A  36       7.314  33.526  20.166  1.00  0.00           H  
ATOM    500  HZ2 LYS A  36       8.071  32.323  20.968  1.00  0.00           H  
ATOM    501  HZ3 LYS A  36       8.942  33.415  20.124  1.00  0.00           H  
ATOM    502  N   GLY A  37       2.962  29.516  18.265  1.00  0.00           N  
ATOM    503  CA  GLY A  37       1.599  30.010  18.165  1.00  0.00           C  
ATOM    504  C   GLY A  37       0.590  28.881  18.381  1.00  0.00           C  
ATOM    505  O   GLY A  37      -0.386  29.046  19.111  1.00  0.00           O  
ATOM    506  H   GLY A  37       3.265  29.294  19.191  1.00  0.00           H  
ATOM    507  HA2 GLY A  37       1.438  30.793  18.906  1.00  0.00           H  
ATOM    508  HA3 GLY A  37       1.442  30.460  17.185  1.00  0.00           H  
ATOM    509  N   SER A  38       0.860  27.757  17.732  1.00  0.00           N  
ATOM    510  CA  SER A  38      -0.013  26.601  17.844  1.00  0.00           C  
ATOM    511  C   SER A  38       0.536  25.631  18.893  1.00  0.00           C  
ATOM    512  O   SER A  38       1.622  25.841  19.430  1.00  0.00           O  
ATOM    513  CB  SER A  38      -0.165  25.894  16.496  1.00  0.00           C  
ATOM    514  OG  SER A  38      -1.464  25.333  16.330  1.00  0.00           O  
ATOM    515  H   SER A  38       1.656  27.630  17.140  1.00  0.00           H  
ATOM    516  HA  SER A  38      -0.979  26.997  18.157  1.00  0.00           H  
ATOM    517  HB2 SER A  38       0.030  26.602  15.691  1.00  0.00           H  
ATOM    518  HB3 SER A  38       0.583  25.105  16.414  1.00  0.00           H  
ATOM    519  HG  SER A  38      -2.046  25.584  17.105  1.00  0.00           H  
ATOM    520  N   THR A  39      -0.242  24.590  19.154  1.00  0.00           N  
ATOM    521  CA  THR A  39       0.152  23.588  20.129  1.00  0.00           C  
ATOM    522  C   THR A  39       1.354  22.791  19.619  1.00  0.00           C  
ATOM    523  O   THR A  39       1.474  22.542  18.421  1.00  0.00           O  
ATOM    524  CB  THR A  39      -1.070  22.719  20.433  1.00  0.00           C  
ATOM    525  OG1 THR A  39      -1.850  23.514  21.321  1.00  0.00           O  
ATOM    526  CG2 THR A  39      -0.716  21.479  21.257  1.00  0.00           C  
ATOM    527  H   THR A  39      -1.124  24.427  18.712  1.00  0.00           H  
ATOM    528  HA  THR A  39       0.470  24.099  21.038  1.00  0.00           H  
ATOM    529  HB  THR A  39      -1.588  22.441  19.516  1.00  0.00           H  
ATOM    530  HG1 THR A  39      -1.273  23.875  22.054  1.00  0.00           H  
ATOM    531 HG21 THR A  39       0.299  21.161  21.018  1.00  0.00           H  
ATOM    532 HG22 THR A  39      -0.781  21.718  22.319  1.00  0.00           H  
ATOM    533 HG23 THR A  39      -1.413  20.675  21.023  1.00  0.00           H  
ATOM    534  N   PRO A  40       2.235  22.402  20.579  1.00  0.00           N  
ATOM    535  CA  PRO A  40       3.423  21.637  20.239  1.00  0.00           C  
ATOM    536  C   PRO A  40       3.068  20.182  19.927  1.00  0.00           C  
ATOM    537  O   PRO A  40       1.990  19.712  20.287  1.00  0.00           O  
ATOM    538  CB  PRO A  40       4.340  21.780  21.443  1.00  0.00           C  
ATOM    539  CG  PRO A  40       3.452  22.226  22.593  1.00  0.00           C  
ATOM    540  CD  PRO A  40       2.124  22.679  22.008  1.00  0.00           C  
ATOM    541  HA  PRO A  40       3.843  22.001  19.408  1.00  0.00           H  
ATOM    542  HB2 PRO A  40       4.833  20.835  21.673  1.00  0.00           H  
ATOM    543  HB3 PRO A  40       5.127  22.510  21.250  1.00  0.00           H  
ATOM    544  HG2 PRO A  40       3.300  21.408  23.297  1.00  0.00           H  
ATOM    545  HG3 PRO A  40       3.924  23.039  23.145  1.00  0.00           H  
ATOM    546  HD2 PRO A  40       1.290  22.136  22.453  1.00  0.00           H  
ATOM    547  HD3 PRO A  40       1.950  23.739  22.194  1.00  0.00           H  
ATOM    548  N   TYR A  41       3.995  19.511  19.260  1.00  0.00           N  
ATOM    549  CA  TYR A  41       3.794  18.118  18.896  1.00  0.00           C  
ATOM    550  C   TYR A  41       4.324  17.184  19.985  1.00  0.00           C  
ATOM    551  O   TYR A  41       3.735  16.138  20.251  1.00  0.00           O  
ATOM    552  CB  TYR A  41       4.600  17.898  17.614  1.00  0.00           C  
ATOM    553  CG  TYR A  41       4.465  16.490  17.030  1.00  0.00           C  
ATOM    554  CD1 TYR A  41       3.382  16.173  16.235  1.00  0.00           C  
ATOM    555  CD2 TYR A  41       5.427  15.537  17.297  1.00  0.00           C  
ATOM    556  CE1 TYR A  41       3.255  14.849  15.685  1.00  0.00           C  
ATOM    557  CE2 TYR A  41       5.300  14.212  16.746  1.00  0.00           C  
ATOM    558  CZ  TYR A  41       4.221  13.934  15.967  1.00  0.00           C  
ATOM    559  OH  TYR A  41       4.101  12.682  15.448  1.00  0.00           O  
ATOM    560  H   TYR A  41       4.869  19.901  18.971  1.00  0.00           H  
ATOM    561  HA  TYR A  41       2.723  17.954  18.776  1.00  0.00           H  
ATOM    562  HB2 TYR A  41       4.279  18.623  16.867  1.00  0.00           H  
ATOM    563  HB3 TYR A  41       5.652  18.095  17.821  1.00  0.00           H  
ATOM    564  HD1 TYR A  41       2.622  16.926  16.024  1.00  0.00           H  
ATOM    565  HD2 TYR A  41       6.283  15.787  17.923  1.00  0.00           H  
ATOM    566  HE1 TYR A  41       2.405  14.586  15.056  1.00  0.00           H  
ATOM    567  HE2 TYR A  41       6.053  13.451  16.949  1.00  0.00           H  
ATOM    568  HH  TYR A  41       3.137  12.426  15.391  1.00  0.00           H  
ATOM    569  N   LYS A  42       5.431  17.595  20.585  1.00  0.00           N  
ATOM    570  CA  LYS A  42       6.048  16.808  21.640  1.00  0.00           C  
ATOM    571  C   LYS A  42       6.230  17.682  22.882  1.00  0.00           C  
ATOM    572  O   LYS A  42       6.965  18.667  22.851  1.00  0.00           O  
ATOM    573  CB  LYS A  42       7.346  16.169  21.142  1.00  0.00           C  
ATOM    574  CG  LYS A  42       7.098  14.745  20.638  1.00  0.00           C  
ATOM    575  CD  LYS A  42       8.227  14.287  19.715  1.00  0.00           C  
ATOM    576  CE  LYS A  42       8.765  12.920  20.143  1.00  0.00           C  
ATOM    577  NZ  LYS A  42       9.003  12.062  18.960  1.00  0.00           N  
ATOM    578  H   LYS A  42       5.905  18.447  20.363  1.00  0.00           H  
ATOM    579  HA  LYS A  42       5.362  15.997  21.884  1.00  0.00           H  
ATOM    580  HB2 LYS A  42       7.769  16.774  20.341  1.00  0.00           H  
ATOM    581  HB3 LYS A  42       8.078  16.150  21.949  1.00  0.00           H  
ATOM    582  HG2 LYS A  42       7.016  14.064  21.486  1.00  0.00           H  
ATOM    583  HG3 LYS A  42       6.147  14.705  20.104  1.00  0.00           H  
ATOM    584  HD2 LYS A  42       7.863  14.233  18.688  1.00  0.00           H  
ATOM    585  HD3 LYS A  42       9.033  15.019  19.728  1.00  0.00           H  
ATOM    586  HE2 LYS A  42       9.693  13.046  20.701  1.00  0.00           H  
ATOM    587  HE3 LYS A  42       8.054  12.436  20.813  1.00  0.00           H  
ATOM    588  HZ1 LYS A  42       9.956  12.153  18.670  1.00  0.00           H  
ATOM    589  HZ2 LYS A  42       8.816  11.109  19.197  1.00  0.00           H  
ATOM    590  HZ3 LYS A  42       8.399  12.345  18.216  1.00  0.00           H  
ATOM    591  N   GLY A  43       5.545  17.289  23.948  1.00  0.00           N  
ATOM    592  CA  GLY A  43       5.623  18.024  25.199  1.00  0.00           C  
ATOM    593  C   GLY A  43       5.588  19.534  24.951  1.00  0.00           C  
ATOM    594  O   GLY A  43       4.950  19.997  24.007  1.00  0.00           O  
ATOM    595  H   GLY A  43       4.948  16.487  23.965  1.00  0.00           H  
ATOM    596  HA2 GLY A  43       4.791  17.739  25.843  1.00  0.00           H  
ATOM    597  HA3 GLY A  43       6.540  17.759  25.725  1.00  0.00           H  
ATOM    598  N   ASP A  44       6.284  20.258  25.815  1.00  0.00           N  
ATOM    599  CA  ASP A  44       6.342  21.706  25.701  1.00  0.00           C  
ATOM    600  C   ASP A  44       7.536  22.098  24.828  1.00  0.00           C  
ATOM    601  O   ASP A  44       8.503  22.680  25.316  1.00  0.00           O  
ATOM    602  CB  ASP A  44       6.526  22.359  27.073  1.00  0.00           C  
ATOM    603  CG  ASP A  44       7.463  21.613  28.024  1.00  0.00           C  
ATOM    604  OD1 ASP A  44       8.239  20.776  27.515  1.00  0.00           O  
ATOM    605  OD2 ASP A  44       7.382  21.897  29.238  1.00  0.00           O  
ATOM    606  H   ASP A  44       6.801  19.873  26.579  1.00  0.00           H  
ATOM    607  HA  ASP A  44       5.389  21.997  25.259  1.00  0.00           H  
ATOM    608  HB2 ASP A  44       6.907  23.370  26.928  1.00  0.00           H  
ATOM    609  HB3 ASP A  44       5.548  22.452  27.547  1.00  0.00           H  
ATOM    610  N   ASP A  45       7.429  21.763  23.550  1.00  0.00           N  
ATOM    611  CA  ASP A  45       8.487  22.072  22.604  1.00  0.00           C  
ATOM    612  C   ASP A  45       7.885  22.771  21.383  1.00  0.00           C  
ATOM    613  O   ASP A  45       7.267  22.129  20.537  1.00  0.00           O  
ATOM    614  CB  ASP A  45       9.185  20.799  22.122  1.00  0.00           C  
ATOM    615  CG  ASP A  45      10.223  20.226  23.090  1.00  0.00           C  
ATOM    616  OD1 ASP A  45       9.803  19.806  24.190  1.00  0.00           O  
ATOM    617  OD2 ASP A  45      11.413  20.219  22.707  1.00  0.00           O  
ATOM    618  H   ASP A  45       6.638  21.289  23.161  1.00  0.00           H  
ATOM    619  HA  ASP A  45       9.181  22.710  23.150  1.00  0.00           H  
ATOM    620  HB2 ASP A  45       8.429  20.038  21.932  1.00  0.00           H  
ATOM    621  HB3 ASP A  45       9.673  21.007  21.171  1.00  0.00           H  
ATOM    622  N   GLU A  46       8.088  24.080  21.331  1.00  0.00           N  
ATOM    623  CA  GLU A  46       7.574  24.874  20.228  1.00  0.00           C  
ATOM    624  C   GLU A  46       8.429  24.663  18.978  1.00  0.00           C  
ATOM    625  O   GLU A  46       8.960  25.619  18.415  1.00  0.00           O  
ATOM    626  CB  GLU A  46       7.507  26.355  20.603  1.00  0.00           C  
ATOM    627  CG  GLU A  46       8.890  26.887  20.987  1.00  0.00           C  
ATOM    628  CD  GLU A  46       8.996  27.097  22.499  1.00  0.00           C  
ATOM    629  OE1 GLU A  46       8.106  27.790  23.040  1.00  0.00           O  
ATOM    630  OE2 GLU A  46       9.964  26.561  23.080  1.00  0.00           O  
ATOM    631  H   GLU A  46       8.593  24.595  22.024  1.00  0.00           H  
ATOM    632  HA  GLU A  46       6.564  24.504  20.052  1.00  0.00           H  
ATOM    633  HB2 GLU A  46       7.114  26.929  19.764  1.00  0.00           H  
ATOM    634  HB3 GLU A  46       6.817  26.493  21.436  1.00  0.00           H  
ATOM    635  HG2 GLU A  46       9.657  26.184  20.661  1.00  0.00           H  
ATOM    636  HG3 GLU A  46       9.079  27.828  20.471  1.00  0.00           H  
ATOM    637  N   GLY A  47       8.537  23.404  18.579  1.00  0.00           N  
ATOM    638  CA  GLY A  47       9.319  23.054  17.405  1.00  0.00           C  
ATOM    639  C   GLY A  47       8.443  22.394  16.340  1.00  0.00           C  
ATOM    640  O   GLY A  47       7.305  22.015  16.613  1.00  0.00           O  
ATOM    641  H   GLY A  47       8.102  22.630  19.042  1.00  0.00           H  
ATOM    642  HA2 GLY A  47       9.785  23.950  16.995  1.00  0.00           H  
ATOM    643  HA3 GLY A  47      10.125  22.378  17.689  1.00  0.00           H  
ATOM    644  N   ILE A  48       9.007  22.274  15.146  1.00  0.00           N  
ATOM    645  CA  ILE A  48       8.291  21.666  14.038  1.00  0.00           C  
ATOM    646  C   ILE A  48       8.680  20.190  13.933  1.00  0.00           C  
ATOM    647  O   ILE A  48       9.793  19.866  13.522  1.00  0.00           O  
ATOM    648  CB  ILE A  48       8.527  22.456  12.749  1.00  0.00           C  
ATOM    649  CG1 ILE A  48       7.877  23.839  12.827  1.00  0.00           C  
ATOM    650  CG2 ILE A  48       8.052  21.668  11.528  1.00  0.00           C  
ATOM    651  CD1 ILE A  48       6.352  23.733  12.753  1.00  0.00           C  
ATOM    652  H   ILE A  48       9.934  22.585  14.932  1.00  0.00           H  
ATOM    653  HA  ILE A  48       7.227  21.727  14.263  1.00  0.00           H  
ATOM    654  HB  ILE A  48       9.600  22.611  12.635  1.00  0.00           H  
ATOM    655 HG12 ILE A  48       8.165  24.328  13.757  1.00  0.00           H  
ATOM    656 HG13 ILE A  48       8.242  24.464  12.012  1.00  0.00           H  
ATOM    657 HG21 ILE A  48       8.793  20.910  11.274  1.00  0.00           H  
ATOM    658 HG22 ILE A  48       7.101  21.184  11.754  1.00  0.00           H  
ATOM    659 HG23 ILE A  48       7.923  22.347  10.684  1.00  0.00           H  
ATOM    660 HD11 ILE A  48       6.072  23.134  11.886  1.00  0.00           H  
ATOM    661 HD12 ILE A  48       5.976  23.259  13.659  1.00  0.00           H  
ATOM    662 HD13 ILE A  48       5.922  24.731  12.659  1.00  0.00           H  
ATOM    663  N   PHE A  49       7.743  19.335  14.313  1.00  0.00           N  
ATOM    664  CA  PHE A  49       7.974  17.901  14.268  1.00  0.00           C  
ATOM    665  C   PHE A  49       7.077  17.234  13.223  1.00  0.00           C  
ATOM    666  O   PHE A  49       6.016  17.757  12.886  1.00  0.00           O  
ATOM    667  CB  PHE A  49       7.624  17.348  15.651  1.00  0.00           C  
ATOM    668  CG  PHE A  49       8.666  17.659  16.727  1.00  0.00           C  
ATOM    669  CD1 PHE A  49       9.008  18.948  16.990  1.00  0.00           C  
ATOM    670  CD2 PHE A  49       9.250  16.645  17.422  1.00  0.00           C  
ATOM    671  CE1 PHE A  49       9.975  19.237  17.989  1.00  0.00           C  
ATOM    672  CE2 PHE A  49      10.216  16.934  18.421  1.00  0.00           C  
ATOM    673  CZ  PHE A  49      10.559  18.223  18.683  1.00  0.00           C  
ATOM    674  H   PHE A  49       6.840  19.607  14.647  1.00  0.00           H  
ATOM    675  HA  PHE A  49       9.019  17.751  13.997  1.00  0.00           H  
ATOM    676  HB2 PHE A  49       6.662  17.757  15.962  1.00  0.00           H  
ATOM    677  HB3 PHE A  49       7.503  16.267  15.579  1.00  0.00           H  
ATOM    678  HD1 PHE A  49       8.540  19.761  16.434  1.00  0.00           H  
ATOM    679  HD2 PHE A  49       8.975  15.612  17.211  1.00  0.00           H  
ATOM    680  HE1 PHE A  49      10.249  20.271  18.200  1.00  0.00           H  
ATOM    681  HE2 PHE A  49      10.684  16.122  18.978  1.00  0.00           H  
ATOM    682  HZ  PHE A  49      11.301  18.445  19.451  1.00  0.00           H  
ATOM    683  N   ILE A  50       7.538  16.090  12.739  1.00  0.00           N  
ATOM    684  CA  ILE A  50       6.790  15.346  11.740  1.00  0.00           C  
ATOM    685  C   ILE A  50       5.515  14.786  12.374  1.00  0.00           C  
ATOM    686  O   ILE A  50       5.569  14.144  13.422  1.00  0.00           O  
ATOM    687  CB  ILE A  50       7.676  14.278  11.093  1.00  0.00           C  
ATOM    688  CG1 ILE A  50       8.876  14.914  10.390  1.00  0.00           C  
ATOM    689  CG2 ILE A  50       6.863  13.389  10.149  1.00  0.00           C  
ATOM    690  CD1 ILE A  50       8.425  15.988   9.398  1.00  0.00           C  
ATOM    691  H   ILE A  50       8.401  15.671  13.019  1.00  0.00           H  
ATOM    692  HA  ILE A  50       6.506  16.047  10.955  1.00  0.00           H  
ATOM    693  HB  ILE A  50       8.067  13.636  11.882  1.00  0.00           H  
ATOM    694 HG12 ILE A  50       9.544  15.355  11.131  1.00  0.00           H  
ATOM    695 HG13 ILE A  50       9.445  14.146   9.866  1.00  0.00           H  
ATOM    696 HG21 ILE A  50       7.523  12.659   9.681  1.00  0.00           H  
ATOM    697 HG22 ILE A  50       6.089  12.870  10.716  1.00  0.00           H  
ATOM    698 HG23 ILE A  50       6.398  14.006   9.380  1.00  0.00           H  
ATOM    699 HD11 ILE A  50       8.354  16.948   9.909  1.00  0.00           H  
ATOM    700 HD12 ILE A  50       9.150  16.061   8.587  1.00  0.00           H  
ATOM    701 HD13 ILE A  50       7.450  15.719   8.991  1.00  0.00           H  
ATOM    702  N   SER A  51       4.398  15.048  11.712  1.00  0.00           N  
ATOM    703  CA  SER A  51       3.112  14.578  12.198  1.00  0.00           C  
ATOM    704  C   SER A  51       2.712  13.297  11.464  1.00  0.00           C  
ATOM    705  O   SER A  51       1.946  12.490  11.989  1.00  0.00           O  
ATOM    706  CB  SER A  51       2.033  15.648  12.023  1.00  0.00           C  
ATOM    707  OG  SER A  51       0.762  15.206  12.492  1.00  0.00           O  
ATOM    708  H   SER A  51       4.363  15.570  10.860  1.00  0.00           H  
ATOM    709  HA  SER A  51       3.259  14.381  13.260  1.00  0.00           H  
ATOM    710  HB2 SER A  51       2.325  16.549  12.564  1.00  0.00           H  
ATOM    711  HB3 SER A  51       1.957  15.919  10.970  1.00  0.00           H  
ATOM    712  HG  SER A  51       0.838  14.283  12.867  1.00  0.00           H  
ATOM    713  N   ARG A  52       3.248  13.149  10.262  1.00  0.00           N  
ATOM    714  CA  ARG A  52       2.956  11.979   9.450  1.00  0.00           C  
ATOM    715  C   ARG A  52       4.013  11.816   8.356  1.00  0.00           C  
ATOM    716  O   ARG A  52       4.651  12.787   7.953  1.00  0.00           O  
ATOM    717  CB  ARG A  52       1.574  12.089   8.803  1.00  0.00           C  
ATOM    718  CG  ARG A  52       0.871  10.730   8.778  1.00  0.00           C  
ATOM    719  CD  ARG A  52      -0.296  10.734   7.789  1.00  0.00           C  
ATOM    720  NE  ARG A  52      -1.294   9.713   8.178  1.00  0.00           N  
ATOM    721  CZ  ARG A  52      -1.101   8.392   8.064  1.00  0.00           C  
ATOM    722  NH1 ARG A  52       0.052   7.923   7.568  1.00  0.00           N  
ATOM    723  NH2 ARG A  52      -2.063   7.540   8.442  1.00  0.00           N  
ATOM    724  H   ARG A  52       3.869  13.810   9.842  1.00  0.00           H  
ATOM    725  HA  ARG A  52       2.982  11.143  10.149  1.00  0.00           H  
ATOM    726  HB2 ARG A  52       0.967  12.806   9.354  1.00  0.00           H  
ATOM    727  HB3 ARG A  52       1.674  12.469   7.786  1.00  0.00           H  
ATOM    728  HG2 ARG A  52       1.584   9.952   8.501  1.00  0.00           H  
ATOM    729  HG3 ARG A  52       0.506  10.487   9.776  1.00  0.00           H  
ATOM    730  HD2 ARG A  52      -0.761  11.719   7.767  1.00  0.00           H  
ATOM    731  HD3 ARG A  52       0.069  10.532   6.782  1.00  0.00           H  
ATOM    732  HE  ARG A  52      -2.166  10.029   8.552  1.00  0.00           H  
ATOM    733 HH11 ARG A  52       0.770   8.560   7.285  1.00  0.00           H  
ATOM    734 HH12 ARG A  52       0.196   6.938   7.481  1.00  0.00           H  
ATOM    735 HH21 ARG A  52      -2.924   7.889   8.812  1.00  0.00           H  
ATOM    736 HH22 ARG A  52      -1.920   6.554   8.356  1.00  0.00           H  
ATOM    737  N   VAL A  53       4.165  10.579   7.906  1.00  0.00           N  
ATOM    738  CA  VAL A  53       5.133  10.275   6.865  1.00  0.00           C  
ATOM    739  C   VAL A  53       4.487   9.358   5.825  1.00  0.00           C  
ATOM    740  O   VAL A  53       4.377   8.151   6.039  1.00  0.00           O  
ATOM    741  CB  VAL A  53       6.397   9.678   7.486  1.00  0.00           C  
ATOM    742  CG1 VAL A  53       7.171   8.846   6.460  1.00  0.00           C  
ATOM    743  CG2 VAL A  53       7.283  10.772   8.085  1.00  0.00           C  
ATOM    744  H   VAL A  53       3.642   9.794   8.237  1.00  0.00           H  
ATOM    745  HA  VAL A  53       5.404  11.214   6.384  1.00  0.00           H  
ATOM    746  HB  VAL A  53       6.093   9.014   8.294  1.00  0.00           H  
ATOM    747 HG11 VAL A  53       8.132   8.550   6.883  1.00  0.00           H  
ATOM    748 HG12 VAL A  53       6.596   7.956   6.206  1.00  0.00           H  
ATOM    749 HG13 VAL A  53       7.337   9.440   5.562  1.00  0.00           H  
ATOM    750 HG21 VAL A  53       8.257  10.760   7.595  1.00  0.00           H  
ATOM    751 HG22 VAL A  53       6.812  11.744   7.935  1.00  0.00           H  
ATOM    752 HG23 VAL A  53       7.412  10.592   9.153  1.00  0.00           H  
ATOM    753  N   SER A  54       4.075   9.965   4.721  1.00  0.00           N  
ATOM    754  CA  SER A  54       3.442   9.218   3.648  1.00  0.00           C  
ATOM    755  C   SER A  54       4.239   7.944   3.356  1.00  0.00           C  
ATOM    756  O   SER A  54       5.394   8.013   2.938  1.00  0.00           O  
ATOM    757  CB  SER A  54       3.320  10.069   2.382  1.00  0.00           C  
ATOM    758  OG  SER A  54       2.464  11.191   2.574  1.00  0.00           O  
ATOM    759  H   SER A  54       4.168  10.946   4.556  1.00  0.00           H  
ATOM    760  HA  SER A  54       2.447   8.970   4.016  1.00  0.00           H  
ATOM    761  HB2 SER A  54       4.309  10.415   2.081  1.00  0.00           H  
ATOM    762  HB3 SER A  54       2.936   9.455   1.568  1.00  0.00           H  
ATOM    763  HG  SER A  54       2.360  11.379   3.551  1.00  0.00           H  
ATOM    764  N   GLU A  55       3.591   6.812   3.588  1.00  0.00           N  
ATOM    765  CA  GLU A  55       4.225   5.526   3.356  1.00  0.00           C  
ATOM    766  C   GLU A  55       4.791   5.461   1.936  1.00  0.00           C  
ATOM    767  O   GLU A  55       5.962   5.139   1.745  1.00  0.00           O  
ATOM    768  CB  GLU A  55       3.245   4.379   3.608  1.00  0.00           C  
ATOM    769  CG  GLU A  55       3.736   3.477   4.742  1.00  0.00           C  
ATOM    770  CD  GLU A  55       3.516   2.001   4.404  1.00  0.00           C  
ATOM    771  OE1 GLU A  55       2.343   1.642   4.166  1.00  0.00           O  
ATOM    772  OE2 GLU A  55       4.527   1.266   4.392  1.00  0.00           O  
ATOM    773  H   GLU A  55       2.652   6.766   3.929  1.00  0.00           H  
ATOM    774  HA  GLU A  55       5.036   5.468   4.081  1.00  0.00           H  
ATOM    775  HB2 GLU A  55       2.264   4.782   3.858  1.00  0.00           H  
ATOM    776  HB3 GLU A  55       3.125   3.791   2.698  1.00  0.00           H  
ATOM    777  HG2 GLU A  55       4.795   3.659   4.924  1.00  0.00           H  
ATOM    778  HG3 GLU A  55       3.208   3.725   5.664  1.00  0.00           H  
ATOM    779  N   GLU A  56       3.932   5.774   0.977  1.00  0.00           N  
ATOM    780  CA  GLU A  56       4.331   5.756  -0.420  1.00  0.00           C  
ATOM    781  C   GLU A  56       4.514   7.184  -0.939  1.00  0.00           C  
ATOM    782  O   GLU A  56       3.695   7.676  -1.713  1.00  0.00           O  
ATOM    783  CB  GLU A  56       3.317   4.989  -1.271  1.00  0.00           C  
ATOM    784  CG  GLU A  56       3.919   3.685  -1.800  1.00  0.00           C  
ATOM    785  CD  GLU A  56       2.860   2.585  -1.878  1.00  0.00           C  
ATOM    786  OE1 GLU A  56       2.125   2.431  -0.878  1.00  0.00           O  
ATOM    787  OE2 GLU A  56       2.807   1.922  -2.936  1.00  0.00           O  
ATOM    788  H   GLU A  56       2.981   6.035   1.141  1.00  0.00           H  
ATOM    789  HA  GLU A  56       5.286   5.230  -0.442  1.00  0.00           H  
ATOM    790  HB2 GLU A  56       2.430   4.769  -0.676  1.00  0.00           H  
ATOM    791  HB3 GLU A  56       2.994   5.610  -2.106  1.00  0.00           H  
ATOM    792  HG2 GLU A  56       4.348   3.853  -2.788  1.00  0.00           H  
ATOM    793  HG3 GLU A  56       4.732   3.366  -1.149  1.00  0.00           H  
ATOM    794  N   GLY A  57       5.593   7.808  -0.491  1.00  0.00           N  
ATOM    795  CA  GLY A  57       5.894   9.169  -0.900  1.00  0.00           C  
ATOM    796  C   GLY A  57       7.396   9.356  -1.125  1.00  0.00           C  
ATOM    797  O   GLY A  57       8.165   8.401  -1.030  1.00  0.00           O  
ATOM    798  H   GLY A  57       6.255   7.400   0.138  1.00  0.00           H  
ATOM    799  HA2 GLY A  57       5.354   9.405  -1.818  1.00  0.00           H  
ATOM    800  HA3 GLY A  57       5.547   9.867  -0.139  1.00  0.00           H  
ATOM    801  N   PRO A  58       7.779  10.626  -1.426  1.00  0.00           N  
ATOM    802  CA  PRO A  58       9.176  10.950  -1.663  1.00  0.00           C  
ATOM    803  C   PRO A  58       9.962  10.987  -0.351  1.00  0.00           C  
ATOM    804  O   PRO A  58      11.136  10.621  -0.316  1.00  0.00           O  
ATOM    805  CB  PRO A  58       9.152  12.290  -2.379  1.00  0.00           C  
ATOM    806  CG  PRO A  58       7.780  12.886  -2.103  1.00  0.00           C  
ATOM    807  CD  PRO A  58       6.897  11.783  -1.546  1.00  0.00           C  
ATOM    808  HA  PRO A  58       9.607  10.240  -2.220  1.00  0.00           H  
ATOM    809  HB2 PRO A  58       9.943  12.944  -2.011  1.00  0.00           H  
ATOM    810  HB3 PRO A  58       9.315  12.164  -3.450  1.00  0.00           H  
ATOM    811  HG2 PRO A  58       7.858  13.708  -1.392  1.00  0.00           H  
ATOM    812  HG3 PRO A  58       7.350  13.295  -3.018  1.00  0.00           H  
ATOM    813  HD2 PRO A  58       6.476  12.062  -0.581  1.00  0.00           H  
ATOM    814  HD3 PRO A  58       6.058  11.573  -2.211  1.00  0.00           H  
ATOM    815  N   ALA A  59       9.282  11.432   0.696  1.00  0.00           N  
ATOM    816  CA  ALA A  59       9.902  11.521   2.007  1.00  0.00           C  
ATOM    817  C   ALA A  59      10.275  10.117   2.487  1.00  0.00           C  
ATOM    818  O   ALA A  59      11.440   9.844   2.774  1.00  0.00           O  
ATOM    819  CB  ALA A  59       8.953  12.234   2.973  1.00  0.00           C  
ATOM    820  H   ALA A  59       8.327  11.726   0.659  1.00  0.00           H  
ATOM    821  HA  ALA A  59      10.811  12.114   1.905  1.00  0.00           H  
ATOM    822  HB1 ALA A  59       8.388  11.494   3.538  1.00  0.00           H  
ATOM    823  HB2 ALA A  59       9.531  12.852   3.659  1.00  0.00           H  
ATOM    824  HB3 ALA A  59       8.266  12.863   2.408  1.00  0.00           H  
ATOM    825  N   ALA A  60       9.264   9.263   2.560  1.00  0.00           N  
ATOM    826  CA  ALA A  60       9.472   7.895   3.000  1.00  0.00           C  
ATOM    827  C   ALA A  60      10.770   7.358   2.393  1.00  0.00           C  
ATOM    828  O   ALA A  60      11.530   6.660   3.062  1.00  0.00           O  
ATOM    829  CB  ALA A  60       8.258   7.045   2.619  1.00  0.00           C  
ATOM    830  H   ALA A  60       8.320   9.492   2.325  1.00  0.00           H  
ATOM    831  HA  ALA A  60       9.566   7.905   4.085  1.00  0.00           H  
ATOM    832  HB1 ALA A  60       7.909   6.495   3.493  1.00  0.00           H  
ATOM    833  HB2 ALA A  60       7.460   7.694   2.257  1.00  0.00           H  
ATOM    834  HB3 ALA A  60       8.537   6.341   1.834  1.00  0.00           H  
ATOM    835  N   ARG A  61      10.986   7.708   1.134  1.00  0.00           N  
ATOM    836  CA  ARG A  61      12.179   7.272   0.430  1.00  0.00           C  
ATOM    837  C   ARG A  61      13.428   7.870   1.080  1.00  0.00           C  
ATOM    838  O   ARG A  61      14.377   7.151   1.388  1.00  0.00           O  
ATOM    839  CB  ARG A  61      12.132   7.685  -1.043  1.00  0.00           C  
ATOM    840  CG  ARG A  61      10.980   6.990  -1.771  1.00  0.00           C  
ATOM    841  CD  ARG A  61      11.353   6.686  -3.224  1.00  0.00           C  
ATOM    842  NE  ARG A  61      11.316   5.226  -3.461  1.00  0.00           N  
ATOM    843  CZ  ARG A  61      11.848   4.626  -4.535  1.00  0.00           C  
ATOM    844  NH1 ARG A  61      12.460   5.356  -5.476  1.00  0.00           N  
ATOM    845  NH2 ARG A  61      11.766   3.294  -4.667  1.00  0.00           N  
ATOM    846  H   ARG A  61      10.363   8.277   0.597  1.00  0.00           H  
ATOM    847  HA  ARG A  61      12.174   6.185   0.517  1.00  0.00           H  
ATOM    848  HB2 ARG A  61      12.015   8.766  -1.117  1.00  0.00           H  
ATOM    849  HB3 ARG A  61      13.077   7.433  -1.526  1.00  0.00           H  
ATOM    850  HG2 ARG A  61      10.725   6.063  -1.256  1.00  0.00           H  
ATOM    851  HG3 ARG A  61      10.094   7.623  -1.745  1.00  0.00           H  
ATOM    852  HD2 ARG A  61      10.662   7.190  -3.898  1.00  0.00           H  
ATOM    853  HD3 ARG A  61      12.349   7.073  -3.441  1.00  0.00           H  
ATOM    854  HE  ARG A  61      10.866   4.652  -2.777  1.00  0.00           H  
ATOM    855 HH11 ARG A  61      12.521   6.350  -5.377  1.00  0.00           H  
ATOM    856 HH12 ARG A  61      12.856   4.908  -6.277  1.00  0.00           H  
ATOM    857 HH21 ARG A  61      11.309   2.749  -3.964  1.00  0.00           H  
ATOM    858 HH22 ARG A  61      12.164   2.847  -5.468  1.00  0.00           H  
ATOM    859  N   ALA A  62      13.388   9.181   1.270  1.00  0.00           N  
ATOM    860  CA  ALA A  62      14.504   9.884   1.878  1.00  0.00           C  
ATOM    861  C   ALA A  62      14.905   9.173   3.173  1.00  0.00           C  
ATOM    862  O   ALA A  62      16.091   9.039   3.471  1.00  0.00           O  
ATOM    863  CB  ALA A  62      14.121  11.347   2.112  1.00  0.00           C  
ATOM    864  H   ALA A  62      12.612   9.758   1.016  1.00  0.00           H  
ATOM    865  HA  ALA A  62      15.340   9.847   1.180  1.00  0.00           H  
ATOM    866  HB1 ALA A  62      14.879  11.828   2.728  1.00  0.00           H  
ATOM    867  HB2 ALA A  62      14.051  11.861   1.153  1.00  0.00           H  
ATOM    868  HB3 ALA A  62      13.157  11.393   2.619  1.00  0.00           H  
ATOM    869  N   GLY A  63      13.892   8.734   3.907  1.00  0.00           N  
ATOM    870  CA  GLY A  63      14.124   8.040   5.162  1.00  0.00           C  
ATOM    871  C   GLY A  63      13.602   8.858   6.346  1.00  0.00           C  
ATOM    872  O   GLY A  63      14.093   8.719   7.465  1.00  0.00           O  
ATOM    873  H   GLY A  63      12.930   8.846   3.657  1.00  0.00           H  
ATOM    874  HA2 GLY A  63      13.630   7.068   5.141  1.00  0.00           H  
ATOM    875  HA3 GLY A  63      15.190   7.853   5.287  1.00  0.00           H  
ATOM    876  N   VAL A  64      12.614   9.692   6.057  1.00  0.00           N  
ATOM    877  CA  VAL A  64      12.021  10.532   7.083  1.00  0.00           C  
ATOM    878  C   VAL A  64      11.261   9.654   8.079  1.00  0.00           C  
ATOM    879  O   VAL A  64      10.704   8.623   7.704  1.00  0.00           O  
ATOM    880  CB  VAL A  64      11.140  11.604   6.437  1.00  0.00           C  
ATOM    881  CG1 VAL A  64       9.876  10.986   5.836  1.00  0.00           C  
ATOM    882  CG2 VAL A  64      10.788  12.703   7.442  1.00  0.00           C  
ATOM    883  H   VAL A  64      12.220   9.799   5.144  1.00  0.00           H  
ATOM    884  HA  VAL A  64      12.833  11.035   7.608  1.00  0.00           H  
ATOM    885  HB  VAL A  64      11.708  12.061   5.627  1.00  0.00           H  
ATOM    886 HG11 VAL A  64       9.668  10.034   6.326  1.00  0.00           H  
ATOM    887 HG12 VAL A  64       9.034  11.662   5.984  1.00  0.00           H  
ATOM    888 HG13 VAL A  64      10.025  10.819   4.769  1.00  0.00           H  
ATOM    889 HG21 VAL A  64       9.742  12.608   7.734  1.00  0.00           H  
ATOM    890 HG22 VAL A  64      11.421  12.605   8.324  1.00  0.00           H  
ATOM    891 HG23 VAL A  64      10.950  13.678   6.985  1.00  0.00           H  
ATOM    892  N   ARG A  65      11.262  10.094   9.329  1.00  0.00           N  
ATOM    893  CA  ARG A  65      10.580   9.361  10.381  1.00  0.00           C  
ATOM    894  C   ARG A  65       9.714  10.309  11.213  1.00  0.00           C  
ATOM    895  O   ARG A  65      10.159  11.392  11.589  1.00  0.00           O  
ATOM    896  CB  ARG A  65      11.580   8.656  11.299  1.00  0.00           C  
ATOM    897  CG  ARG A  65      12.314   7.538  10.556  1.00  0.00           C  
ATOM    898  CD  ARG A  65      13.167   6.708  11.518  1.00  0.00           C  
ATOM    899  NE  ARG A  65      14.083   5.832  10.754  1.00  0.00           N  
ATOM    900  CZ  ARG A  65      13.703   4.705  10.136  1.00  0.00           C  
ATOM    901  NH1 ARG A  65      12.424   4.310  10.189  1.00  0.00           N  
ATOM    902  NH2 ARG A  65      14.604   3.972   9.466  1.00  0.00           N  
ATOM    903  H   ARG A  65      11.718  10.933   9.625  1.00  0.00           H  
ATOM    904  HA  ARG A  65       9.966   8.628   9.858  1.00  0.00           H  
ATOM    905  HB2 ARG A  65      12.302   9.379  11.680  1.00  0.00           H  
ATOM    906  HB3 ARG A  65      11.059   8.242  12.162  1.00  0.00           H  
ATOM    907  HG2 ARG A  65      11.591   6.893  10.057  1.00  0.00           H  
ATOM    908  HG3 ARG A  65      12.948   7.968   9.780  1.00  0.00           H  
ATOM    909  HD2 ARG A  65      13.741   7.367  12.169  1.00  0.00           H  
ATOM    910  HD3 ARG A  65      12.525   6.105  12.159  1.00  0.00           H  
ATOM    911  HE  ARG A  65      15.046   6.098  10.694  1.00  0.00           H  
ATOM    912 HH11 ARG A  65      11.753   4.857  10.689  1.00  0.00           H  
ATOM    913 HH12 ARG A  65      12.141   3.469   9.729  1.00  0.00           H  
ATOM    914 HH21 ARG A  65      15.558   4.267   9.427  1.00  0.00           H  
ATOM    915 HH22 ARG A  65      14.320   3.131   9.006  1.00  0.00           H  
ATOM    916  N   VAL A  66       8.493   9.867  11.477  1.00  0.00           N  
ATOM    917  CA  VAL A  66       7.561  10.662  12.258  1.00  0.00           C  
ATOM    918  C   VAL A  66       8.176  10.963  13.626  1.00  0.00           C  
ATOM    919  O   VAL A  66       8.805  10.097  14.232  1.00  0.00           O  
ATOM    920  CB  VAL A  66       6.212   9.946  12.353  1.00  0.00           C  
ATOM    921  CG1 VAL A  66       5.272  10.674  13.315  1.00  0.00           C  
ATOM    922  CG2 VAL A  66       5.575   9.794  10.971  1.00  0.00           C  
ATOM    923  H   VAL A  66       8.139   8.985  11.167  1.00  0.00           H  
ATOM    924  HA  VAL A  66       7.407  11.603  11.728  1.00  0.00           H  
ATOM    925  HB  VAL A  66       6.392   8.947  12.751  1.00  0.00           H  
ATOM    926 HG11 VAL A  66       5.708  11.633  13.593  1.00  0.00           H  
ATOM    927 HG12 VAL A  66       4.311  10.839  12.827  1.00  0.00           H  
ATOM    928 HG13 VAL A  66       5.126  10.067  14.209  1.00  0.00           H  
ATOM    929 HG21 VAL A  66       6.230   9.204  10.331  1.00  0.00           H  
ATOM    930 HG22 VAL A  66       4.612   9.291  11.069  1.00  0.00           H  
ATOM    931 HG23 VAL A  66       5.426  10.779  10.529  1.00  0.00           H  
ATOM    932  N   GLY A  67       7.973  12.194  14.073  1.00  0.00           N  
ATOM    933  CA  GLY A  67       8.500  12.620  15.358  1.00  0.00           C  
ATOM    934  C   GLY A  67       9.806  13.399  15.185  1.00  0.00           C  
ATOM    935  O   GLY A  67      10.271  14.051  16.118  1.00  0.00           O  
ATOM    936  H   GLY A  67       7.461  12.893  13.574  1.00  0.00           H  
ATOM    937  HA2 GLY A  67       7.765  13.244  15.868  1.00  0.00           H  
ATOM    938  HA3 GLY A  67       8.673  11.749  15.990  1.00  0.00           H  
ATOM    939  N   ASP A  68      10.358  13.305  13.984  1.00  0.00           N  
ATOM    940  CA  ASP A  68      11.601  13.992  13.677  1.00  0.00           C  
ATOM    941  C   ASP A  68      11.401  15.500  13.850  1.00  0.00           C  
ATOM    942  O   ASP A  68      10.459  16.072  13.303  1.00  0.00           O  
ATOM    943  CB  ASP A  68      12.030  13.736  12.232  1.00  0.00           C  
ATOM    944  CG  ASP A  68      13.147  12.706  12.062  1.00  0.00           C  
ATOM    945  OD1 ASP A  68      14.186  12.878  12.735  1.00  0.00           O  
ATOM    946  OD2 ASP A  68      12.938  11.767  11.263  1.00  0.00           O  
ATOM    947  H   ASP A  68       9.973  12.772  13.232  1.00  0.00           H  
ATOM    948  HA  ASP A  68      12.334  13.586  14.375  1.00  0.00           H  
ATOM    949  HB2 ASP A  68      11.160  13.403  11.664  1.00  0.00           H  
ATOM    950  HB3 ASP A  68      12.355  14.679  11.792  1.00  0.00           H  
ATOM    951  N   LYS A  69      12.302  16.100  14.614  1.00  0.00           N  
ATOM    952  CA  LYS A  69      12.237  17.529  14.867  1.00  0.00           C  
ATOM    953  C   LYS A  69      12.999  18.273  13.768  1.00  0.00           C  
ATOM    954  O   LYS A  69      14.226  18.353  13.804  1.00  0.00           O  
ATOM    955  CB  LYS A  69      12.729  17.847  16.279  1.00  0.00           C  
ATOM    956  CG  LYS A  69      12.896  19.355  16.476  1.00  0.00           C  
ATOM    957  CD  LYS A  69      13.727  19.658  17.725  1.00  0.00           C  
ATOM    958  CE  LYS A  69      13.529  21.105  18.179  1.00  0.00           C  
ATOM    959  NZ  LYS A  69      14.086  22.043  17.177  1.00  0.00           N  
ATOM    960  H   LYS A  69      13.064  15.628  15.057  1.00  0.00           H  
ATOM    961  HA  LYS A  69      11.187  17.822  14.817  1.00  0.00           H  
ATOM    962  HB2 LYS A  69      12.022  17.458  17.012  1.00  0.00           H  
ATOM    963  HB3 LYS A  69      13.681  17.346  16.459  1.00  0.00           H  
ATOM    964  HG2 LYS A  69      13.379  19.788  15.600  1.00  0.00           H  
ATOM    965  HG3 LYS A  69      11.917  19.826  16.564  1.00  0.00           H  
ATOM    966  HD2 LYS A  69      13.441  18.979  18.529  1.00  0.00           H  
ATOM    967  HD3 LYS A  69      14.781  19.479  17.516  1.00  0.00           H  
ATOM    968  HE2 LYS A  69      12.467  21.306  18.323  1.00  0.00           H  
ATOM    969  HE3 LYS A  69      14.016  21.260  19.141  1.00  0.00           H  
ATOM    970  HZ1 LYS A  69      14.057  22.974  17.540  1.00  0.00           H  
ATOM    971  HZ2 LYS A  69      15.032  21.792  16.976  1.00  0.00           H  
ATOM    972  HZ3 LYS A  69      13.543  21.995  16.338  1.00  0.00           H  
ATOM    973  N   LEU A  70      12.241  18.797  12.816  1.00  0.00           N  
ATOM    974  CA  LEU A  70      12.830  19.530  11.709  1.00  0.00           C  
ATOM    975  C   LEU A  70      13.654  20.698  12.258  1.00  0.00           C  
ATOM    976  O   LEU A  70      13.203  21.418  13.146  1.00  0.00           O  
ATOM    977  CB  LEU A  70      11.749  19.956  10.714  1.00  0.00           C  
ATOM    978  CG  LEU A  70      12.045  19.667   9.240  1.00  0.00           C  
ATOM    979  CD1 LEU A  70      13.425  20.193   8.844  1.00  0.00           C  
ATOM    980  CD2 LEU A  70      11.889  18.176   8.932  1.00  0.00           C  
ATOM    981  H   LEU A  70      11.244  18.727  12.794  1.00  0.00           H  
ATOM    982  HA  LEU A  70      13.500  18.849  11.186  1.00  0.00           H  
ATOM    983  HB2 LEU A  70      10.818  19.457  10.982  1.00  0.00           H  
ATOM    984  HB3 LEU A  70      11.580  21.026  10.826  1.00  0.00           H  
ATOM    985  HG  LEU A  70      11.311  20.198   8.634  1.00  0.00           H  
ATOM    986 HD11 LEU A  70      14.190  19.682   9.429  1.00  0.00           H  
ATOM    987 HD12 LEU A  70      13.594  20.006   7.783  1.00  0.00           H  
ATOM    988 HD13 LEU A  70      13.474  21.265   9.036  1.00  0.00           H  
ATOM    989 HD21 LEU A  70      11.172  18.045   8.122  1.00  0.00           H  
ATOM    990 HD22 LEU A  70      12.852  17.764   8.634  1.00  0.00           H  
ATOM    991 HD23 LEU A  70      11.531  17.657   9.821  1.00  0.00           H  
ATOM    992  N   LEU A  71      14.850  20.847  11.705  1.00  0.00           N  
ATOM    993  CA  LEU A  71      15.741  21.913  12.127  1.00  0.00           C  
ATOM    994  C   LEU A  71      15.987  22.861  10.952  1.00  0.00           C  
ATOM    995  O   LEU A  71      15.998  24.079  11.123  1.00  0.00           O  
ATOM    996  CB  LEU A  71      17.022  21.334  12.729  1.00  0.00           C  
ATOM    997  CG  LEU A  71      16.855  20.066  13.570  1.00  0.00           C  
ATOM    998  CD1 LEU A  71      18.187  19.330  13.723  1.00  0.00           C  
ATOM    999  CD2 LEU A  71      16.219  20.388  14.925  1.00  0.00           C  
ATOM   1000  H   LEU A  71      15.209  20.256  10.982  1.00  0.00           H  
ATOM   1001  HA  LEU A  71      15.236  22.467  12.918  1.00  0.00           H  
ATOM   1002  HB2 LEU A  71      17.717  21.117  11.916  1.00  0.00           H  
ATOM   1003  HB3 LEU A  71      17.487  22.099  13.350  1.00  0.00           H  
ATOM   1004  HG  LEU A  71      16.174  19.396  13.046  1.00  0.00           H  
ATOM   1005 HD11 LEU A  71      18.946  19.823  13.117  1.00  0.00           H  
ATOM   1006 HD12 LEU A  71      18.492  19.343  14.769  1.00  0.00           H  
ATOM   1007 HD13 LEU A  71      18.072  18.298  13.392  1.00  0.00           H  
ATOM   1008 HD21 LEU A  71      16.944  20.206  15.718  1.00  0.00           H  
ATOM   1009 HD22 LEU A  71      15.913  21.434  14.944  1.00  0.00           H  
ATOM   1010 HD23 LEU A  71      15.347  19.751  15.076  1.00  0.00           H  
ATOM   1011  N   GLU A  72      16.179  22.266   9.784  1.00  0.00           N  
ATOM   1012  CA  GLU A  72      16.426  23.043   8.580  1.00  0.00           C  
ATOM   1013  C   GLU A  72      15.703  22.415   7.387  1.00  0.00           C  
ATOM   1014  O   GLU A  72      15.361  21.234   7.415  1.00  0.00           O  
ATOM   1015  CB  GLU A  72      17.926  23.171   8.307  1.00  0.00           C  
ATOM   1016  CG  GLU A  72      18.384  24.625   8.430  1.00  0.00           C  
ATOM   1017  CD  GLU A  72      19.877  24.705   8.756  1.00  0.00           C  
ATOM   1018  OE1 GLU A  72      20.344  23.815   9.499  1.00  0.00           O  
ATOM   1019  OE2 GLU A  72      20.517  25.654   8.255  1.00  0.00           O  
ATOM   1020  H   GLU A  72      16.170  21.275   9.652  1.00  0.00           H  
ATOM   1021  HA  GLU A  72      16.015  24.031   8.785  1.00  0.00           H  
ATOM   1022  HB2 GLU A  72      18.481  22.550   9.011  1.00  0.00           H  
ATOM   1023  HB3 GLU A  72      18.151  22.798   7.308  1.00  0.00           H  
ATOM   1024  HG2 GLU A  72      18.182  25.154   7.498  1.00  0.00           H  
ATOM   1025  HG3 GLU A  72      17.810  25.126   9.210  1.00  0.00           H  
ATOM   1026  N   VAL A  73      15.491  23.234   6.367  1.00  0.00           N  
ATOM   1027  CA  VAL A  73      14.815  22.773   5.166  1.00  0.00           C  
ATOM   1028  C   VAL A  73      15.344  23.551   3.958  1.00  0.00           C  
ATOM   1029  O   VAL A  73      15.009  24.719   3.773  1.00  0.00           O  
ATOM   1030  CB  VAL A  73      13.300  22.896   5.339  1.00  0.00           C  
ATOM   1031  CG1 VAL A  73      12.592  22.903   3.982  1.00  0.00           C  
ATOM   1032  CG2 VAL A  73      12.758  21.780   6.234  1.00  0.00           C  
ATOM   1033  H   VAL A  73      15.772  24.193   6.352  1.00  0.00           H  
ATOM   1034  HA  VAL A  73      15.055  21.718   5.037  1.00  0.00           H  
ATOM   1035  HB  VAL A  73      13.095  23.848   5.828  1.00  0.00           H  
ATOM   1036 HG11 VAL A  73      11.648  22.364   4.062  1.00  0.00           H  
ATOM   1037 HG12 VAL A  73      12.399  23.932   3.678  1.00  0.00           H  
ATOM   1038 HG13 VAL A  73      13.226  22.419   3.239  1.00  0.00           H  
ATOM   1039 HG21 VAL A  73      13.271  20.846   6.002  1.00  0.00           H  
ATOM   1040 HG22 VAL A  73      12.928  22.039   7.279  1.00  0.00           H  
ATOM   1041 HG23 VAL A  73      11.689  21.661   6.059  1.00  0.00           H  
ATOM   1042  N   ASN A  74      16.161  22.870   3.169  1.00  0.00           N  
ATOM   1043  CA  ASN A  74      16.741  23.481   1.984  1.00  0.00           C  
ATOM   1044  C   ASN A  74      17.725  24.573   2.409  1.00  0.00           C  
ATOM   1045  O   ASN A  74      18.180  25.359   1.579  1.00  0.00           O  
ATOM   1046  CB  ASN A  74      15.660  24.130   1.117  1.00  0.00           C  
ATOM   1047  CG  ASN A  74      15.705  23.586  -0.312  1.00  0.00           C  
ATOM   1048  OD1 ASN A  74      16.358  24.127  -1.190  1.00  0.00           O  
ATOM   1049  ND2 ASN A  74      14.975  22.489  -0.497  1.00  0.00           N  
ATOM   1050  H   ASN A  74      16.429  21.919   3.326  1.00  0.00           H  
ATOM   1051  HA  ASN A  74      17.227  22.665   1.450  1.00  0.00           H  
ATOM   1052  HB2 ASN A  74      14.677  23.942   1.551  1.00  0.00           H  
ATOM   1053  HB3 ASN A  74      15.801  25.210   1.102  1.00  0.00           H  
ATOM   1054 HD21 ASN A  74      14.462  22.096   0.266  1.00  0.00           H  
ATOM   1055 HD22 ASN A  74      14.941  22.057  -1.398  1.00  0.00           H  
ATOM   1056  N   GLY A  75      18.024  24.585   3.699  1.00  0.00           N  
ATOM   1057  CA  GLY A  75      18.947  25.568   4.244  1.00  0.00           C  
ATOM   1058  C   GLY A  75      18.227  26.528   5.193  1.00  0.00           C  
ATOM   1059  O   GLY A  75      18.855  27.140   6.055  1.00  0.00           O  
ATOM   1060  H   GLY A  75      17.649  23.942   4.367  1.00  0.00           H  
ATOM   1061  HA2 GLY A  75      19.752  25.060   4.775  1.00  0.00           H  
ATOM   1062  HA3 GLY A  75      19.406  26.130   3.431  1.00  0.00           H  
ATOM   1063  N   VAL A  76      16.920  26.630   5.001  1.00  0.00           N  
ATOM   1064  CA  VAL A  76      16.110  27.506   5.830  1.00  0.00           C  
ATOM   1065  C   VAL A  76      16.052  26.946   7.253  1.00  0.00           C  
ATOM   1066  O   VAL A  76      15.969  25.734   7.444  1.00  0.00           O  
ATOM   1067  CB  VAL A  76      14.725  27.686   5.202  1.00  0.00           C  
ATOM   1068  CG1 VAL A  76      13.882  26.420   5.361  1.00  0.00           C  
ATOM   1069  CG2 VAL A  76      14.008  28.901   5.795  1.00  0.00           C  
ATOM   1070  H   VAL A  76      16.417  26.129   4.298  1.00  0.00           H  
ATOM   1071  HA  VAL A  76      16.598  28.480   5.855  1.00  0.00           H  
ATOM   1072  HB  VAL A  76      14.862  27.866   4.136  1.00  0.00           H  
ATOM   1073 HG11 VAL A  76      14.514  25.605   5.714  1.00  0.00           H  
ATOM   1074 HG12 VAL A  76      13.086  26.601   6.083  1.00  0.00           H  
ATOM   1075 HG13 VAL A  76      13.445  26.151   4.400  1.00  0.00           H  
ATOM   1076 HG21 VAL A  76      12.932  28.726   5.790  1.00  0.00           H  
ATOM   1077 HG22 VAL A  76      14.346  29.057   6.820  1.00  0.00           H  
ATOM   1078 HG23 VAL A  76      14.235  29.784   5.199  1.00  0.00           H  
ATOM   1079  N   ALA A  77      16.099  27.856   8.215  1.00  0.00           N  
ATOM   1080  CA  ALA A  77      16.053  27.469   9.614  1.00  0.00           C  
ATOM   1081  C   ALA A  77      14.594  27.358  10.061  1.00  0.00           C  
ATOM   1082  O   ALA A  77      13.855  28.342  10.029  1.00  0.00           O  
ATOM   1083  CB  ALA A  77      16.843  28.478  10.450  1.00  0.00           C  
ATOM   1084  H   ALA A  77      16.165  28.841   8.051  1.00  0.00           H  
ATOM   1085  HA  ALA A  77      16.526  26.491   9.704  1.00  0.00           H  
ATOM   1086  HB1 ALA A  77      16.397  28.558  11.441  1.00  0.00           H  
ATOM   1087  HB2 ALA A  77      17.877  28.142  10.543  1.00  0.00           H  
ATOM   1088  HB3 ALA A  77      16.821  29.452   9.961  1.00  0.00           H  
ATOM   1089  N   LEU A  78      14.222  26.154  10.468  1.00  0.00           N  
ATOM   1090  CA  LEU A  78      12.865  25.902  10.921  1.00  0.00           C  
ATOM   1091  C   LEU A  78      12.849  25.817  12.448  1.00  0.00           C  
ATOM   1092  O   LEU A  78      11.993  25.149  13.027  1.00  0.00           O  
ATOM   1093  CB  LEU A  78      12.291  24.663  10.230  1.00  0.00           C  
ATOM   1094  CG  LEU A  78      12.034  24.791   8.727  1.00  0.00           C  
ATOM   1095  CD1 LEU A  78      11.246  23.591   8.200  1.00  0.00           C  
ATOM   1096  CD2 LEU A  78      11.346  26.118   8.399  1.00  0.00           C  
ATOM   1097  H   LEU A  78      14.830  25.359  10.490  1.00  0.00           H  
ATOM   1098  HA  LEU A  78      12.255  26.753  10.615  1.00  0.00           H  
ATOM   1099  HB2 LEU A  78      12.975  23.831  10.391  1.00  0.00           H  
ATOM   1100  HB3 LEU A  78      11.351  24.403  10.718  1.00  0.00           H  
ATOM   1101  HG  LEU A  78      12.997  24.794   8.215  1.00  0.00           H  
ATOM   1102 HD11 LEU A  78      10.192  23.709   8.453  1.00  0.00           H  
ATOM   1103 HD12 LEU A  78      11.356  23.530   7.118  1.00  0.00           H  
ATOM   1104 HD13 LEU A  78      11.628  22.677   8.656  1.00  0.00           H  
ATOM   1105 HD21 LEU A  78      10.736  26.431   9.248  1.00  0.00           H  
ATOM   1106 HD22 LEU A  78      12.099  26.878   8.193  1.00  0.00           H  
ATOM   1107 HD23 LEU A  78      10.709  25.991   7.523  1.00  0.00           H  
ATOM   1108  N   GLN A  79      13.804  26.504  13.057  1.00  0.00           N  
ATOM   1109  CA  GLN A  79      13.911  26.514  14.506  1.00  0.00           C  
ATOM   1110  C   GLN A  79      12.812  27.389  15.112  1.00  0.00           C  
ATOM   1111  O   GLN A  79      12.804  28.604  14.921  1.00  0.00           O  
ATOM   1112  CB  GLN A  79      15.296  26.987  14.950  1.00  0.00           C  
ATOM   1113  CG  GLN A  79      16.147  25.813  15.438  1.00  0.00           C  
ATOM   1114  CD  GLN A  79      17.059  26.236  16.591  1.00  0.00           C  
ATOM   1115  OE1 GLN A  79      17.625  27.317  16.603  1.00  0.00           O  
ATOM   1116  NE2 GLN A  79      17.169  25.328  17.556  1.00  0.00           N  
ATOM   1117  H   GLN A  79      14.496  27.045  12.578  1.00  0.00           H  
ATOM   1118  HA  GLN A  79      13.771  25.478  14.814  1.00  0.00           H  
ATOM   1119  HB2 GLN A  79      15.798  27.484  14.121  1.00  0.00           H  
ATOM   1120  HB3 GLN A  79      15.195  27.723  15.748  1.00  0.00           H  
ATOM   1121  HG2 GLN A  79      15.497  25.000  15.764  1.00  0.00           H  
ATOM   1122  HG3 GLN A  79      16.749  25.428  14.615  1.00  0.00           H  
ATOM   1123 HE21 GLN A  79      16.678  24.461  17.485  1.00  0.00           H  
ATOM   1124 HE22 GLN A  79      17.744  25.513  18.353  1.00  0.00           H  
ATOM   1125  N   GLY A  80      11.911  26.737  15.832  1.00  0.00           N  
ATOM   1126  CA  GLY A  80      10.810  27.441  16.468  1.00  0.00           C  
ATOM   1127  C   GLY A  80      10.140  28.409  15.490  1.00  0.00           C  
ATOM   1128  O   GLY A  80       9.883  29.563  15.831  1.00  0.00           O  
ATOM   1129  H   GLY A  80      11.924  25.749  15.983  1.00  0.00           H  
ATOM   1130  HA2 GLY A  80      10.076  26.723  16.833  1.00  0.00           H  
ATOM   1131  HA3 GLY A  80      11.177  27.991  17.335  1.00  0.00           H  
ATOM   1132  N   ALA A  81       9.875  27.903  14.295  1.00  0.00           N  
ATOM   1133  CA  ALA A  81       9.240  28.708  13.265  1.00  0.00           C  
ATOM   1134  C   ALA A  81       7.736  28.426  13.259  1.00  0.00           C  
ATOM   1135  O   ALA A  81       7.311  27.300  13.511  1.00  0.00           O  
ATOM   1136  CB  ALA A  81       9.893  28.415  11.912  1.00  0.00           C  
ATOM   1137  H   ALA A  81      10.087  26.963  14.025  1.00  0.00           H  
ATOM   1138  HA  ALA A  81       9.404  29.756  13.515  1.00  0.00           H  
ATOM   1139  HB1 ALA A  81      10.202  27.371  11.877  1.00  0.00           H  
ATOM   1140  HB2 ALA A  81       9.177  28.611  11.114  1.00  0.00           H  
ATOM   1141  HB3 ALA A  81      10.765  29.056  11.784  1.00  0.00           H  
ATOM   1142  N   GLU A  82       6.972  29.469  12.970  1.00  0.00           N  
ATOM   1143  CA  GLU A  82       5.525  29.348  12.927  1.00  0.00           C  
ATOM   1144  C   GLU A  82       5.104  28.395  11.808  1.00  0.00           C  
ATOM   1145  O   GLU A  82       5.842  28.199  10.844  1.00  0.00           O  
ATOM   1146  CB  GLU A  82       4.865  30.718  12.759  1.00  0.00           C  
ATOM   1147  CG  GLU A  82       5.123  31.606  13.978  1.00  0.00           C  
ATOM   1148  CD  GLU A  82       4.470  32.979  13.804  1.00  0.00           C  
ATOM   1149  OE1 GLU A  82       3.223  33.028  13.878  1.00  0.00           O  
ATOM   1150  OE2 GLU A  82       5.233  33.948  13.600  1.00  0.00           O  
ATOM   1151  H   GLU A  82       7.326  30.382  12.767  1.00  0.00           H  
ATOM   1152  HA  GLU A  82       5.241  28.932  13.895  1.00  0.00           H  
ATOM   1153  HB2 GLU A  82       5.252  31.204  11.863  1.00  0.00           H  
ATOM   1154  HB3 GLU A  82       3.791  30.594  12.614  1.00  0.00           H  
ATOM   1155  HG2 GLU A  82       4.730  31.123  14.873  1.00  0.00           H  
ATOM   1156  HG3 GLU A  82       6.196  31.725  14.125  1.00  0.00           H  
ATOM   1157  N   HIS A  83       3.919  27.826  11.973  1.00  0.00           N  
ATOM   1158  CA  HIS A  83       3.391  26.897  10.988  1.00  0.00           C  
ATOM   1159  C   HIS A  83       3.638  27.445   9.581  1.00  0.00           C  
ATOM   1160  O   HIS A  83       4.284  26.794   8.762  1.00  0.00           O  
ATOM   1161  CB  HIS A  83       1.913  26.601  11.257  1.00  0.00           C  
ATOM   1162  CG  HIS A  83       1.483  25.210  10.859  1.00  0.00           C  
ATOM   1163  ND1 HIS A  83       1.868  24.078  11.557  1.00  0.00           N  
ATOM   1164  CD2 HIS A  83       0.699  24.780   9.831  1.00  0.00           C  
ATOM   1165  CE1 HIS A  83       1.333  23.019  10.965  1.00  0.00           C  
ATOM   1166  NE2 HIS A  83       0.610  23.456   9.895  1.00  0.00           N  
ATOM   1167  H   HIS A  83       3.324  27.991  12.760  1.00  0.00           H  
ATOM   1168  HA  HIS A  83       3.943  25.966  11.108  1.00  0.00           H  
ATOM   1169  HB2 HIS A  83       1.713  26.743  12.319  1.00  0.00           H  
ATOM   1170  HB3 HIS A  83       1.304  27.326  10.718  1.00  0.00           H  
ATOM   1171  HD1 HIS A  83       2.451  24.061  12.370  1.00  0.00           H  
ATOM   1172  HD2 HIS A  83       0.225  25.414   9.082  1.00  0.00           H  
ATOM   1173  HE1 HIS A  83       1.452  21.983  11.279  1.00  0.00           H  
ATOM   1174  N   HIS A  84       3.110  28.638   9.344  1.00  0.00           N  
ATOM   1175  CA  HIS A  84       3.266  29.281   8.050  1.00  0.00           C  
ATOM   1176  C   HIS A  84       4.735  29.232   7.626  1.00  0.00           C  
ATOM   1177  O   HIS A  84       5.058  28.735   6.549  1.00  0.00           O  
ATOM   1178  CB  HIS A  84       2.704  30.704   8.080  1.00  0.00           C  
ATOM   1179  CG  HIS A  84       3.635  31.718   8.701  1.00  0.00           C  
ATOM   1180  ND1 HIS A  84       4.433  32.563   7.950  1.00  0.00           N  
ATOM   1181  CD2 HIS A  84       3.885  32.015  10.009  1.00  0.00           C  
ATOM   1182  CE1 HIS A  84       5.129  33.328   8.778  1.00  0.00           C  
ATOM   1183  NE2 HIS A  84       4.787  32.987  10.054  1.00  0.00           N  
ATOM   1184  H   HIS A  84       2.586  29.161  10.015  1.00  0.00           H  
ATOM   1185  HA  HIS A  84       2.673  28.704   7.341  1.00  0.00           H  
ATOM   1186  HB2 HIS A  84       2.475  31.014   7.061  1.00  0.00           H  
ATOM   1187  HB3 HIS A  84       1.765  30.701   8.632  1.00  0.00           H  
ATOM   1188  HD1 HIS A  84       4.478  32.590   6.951  1.00  0.00           H  
ATOM   1189  HD2 HIS A  84       3.420  31.534  10.871  1.00  0.00           H  
ATOM   1190  HE1 HIS A  84       5.847  34.096   8.491  1.00  0.00           H  
ATOM   1191  N   GLU A  85       5.587  29.754   8.496  1.00  0.00           N  
ATOM   1192  CA  GLU A  85       7.014  29.776   8.226  1.00  0.00           C  
ATOM   1193  C   GLU A  85       7.479  28.411   7.716  1.00  0.00           C  
ATOM   1194  O   GLU A  85       8.160  28.325   6.695  1.00  0.00           O  
ATOM   1195  CB  GLU A  85       7.802  30.194   9.470  1.00  0.00           C  
ATOM   1196  CG  GLU A  85       7.602  31.680   9.771  1.00  0.00           C  
ATOM   1197  CD  GLU A  85       8.930  32.349  10.137  1.00  0.00           C  
ATOM   1198  OE1 GLU A  85       9.825  32.345   9.265  1.00  0.00           O  
ATOM   1199  OE2 GLU A  85       9.019  32.846  11.280  1.00  0.00           O  
ATOM   1200  H   GLU A  85       5.316  30.156   9.372  1.00  0.00           H  
ATOM   1201  HA  GLU A  85       7.150  30.528   7.448  1.00  0.00           H  
ATOM   1202  HB2 GLU A  85       7.481  29.599  10.324  1.00  0.00           H  
ATOM   1203  HB3 GLU A  85       8.862  29.988   9.320  1.00  0.00           H  
ATOM   1204  HG2 GLU A  85       7.169  32.176   8.904  1.00  0.00           H  
ATOM   1205  HG3 GLU A  85       6.894  31.797  10.592  1.00  0.00           H  
ATOM   1206  N   ALA A  86       7.093  27.377   8.449  1.00  0.00           N  
ATOM   1207  CA  ALA A  86       7.461  26.020   8.084  1.00  0.00           C  
ATOM   1208  C   ALA A  86       6.833  25.673   6.733  1.00  0.00           C  
ATOM   1209  O   ALA A  86       7.542  25.352   5.779  1.00  0.00           O  
ATOM   1210  CB  ALA A  86       7.030  25.058   9.192  1.00  0.00           C  
ATOM   1211  H   ALA A  86       6.540  27.457   9.278  1.00  0.00           H  
ATOM   1212  HA  ALA A  86       8.547  25.985   7.991  1.00  0.00           H  
ATOM   1213  HB1 ALA A  86       6.377  25.579   9.892  1.00  0.00           H  
ATOM   1214  HB2 ALA A  86       6.496  24.215   8.754  1.00  0.00           H  
ATOM   1215  HB3 ALA A  86       7.912  24.694   9.720  1.00  0.00           H  
ATOM   1216  N   VAL A  87       5.511  25.748   6.694  1.00  0.00           N  
ATOM   1217  CA  VAL A  87       4.779  25.445   5.476  1.00  0.00           C  
ATOM   1218  C   VAL A  87       5.463  26.130   4.292  1.00  0.00           C  
ATOM   1219  O   VAL A  87       5.856  25.472   3.330  1.00  0.00           O  
ATOM   1220  CB  VAL A  87       3.311  25.846   5.633  1.00  0.00           C  
ATOM   1221  CG1 VAL A  87       2.574  25.760   4.296  1.00  0.00           C  
ATOM   1222  CG2 VAL A  87       2.620  24.990   6.697  1.00  0.00           C  
ATOM   1223  H   VAL A  87       4.943  26.009   7.474  1.00  0.00           H  
ATOM   1224  HA  VAL A  87       4.820  24.365   5.327  1.00  0.00           H  
ATOM   1225  HB  VAL A  87       3.281  26.883   5.967  1.00  0.00           H  
ATOM   1226 HG11 VAL A  87       2.476  24.716   4.001  1.00  0.00           H  
ATOM   1227 HG12 VAL A  87       1.582  26.203   4.399  1.00  0.00           H  
ATOM   1228 HG13 VAL A  87       3.135  26.302   3.535  1.00  0.00           H  
ATOM   1229 HG21 VAL A  87       3.074  25.182   7.669  1.00  0.00           H  
ATOM   1230 HG22 VAL A  87       1.561  25.242   6.734  1.00  0.00           H  
ATOM   1231 HG23 VAL A  87       2.734  23.935   6.445  1.00  0.00           H  
ATOM   1232  N   GLU A  88       5.584  27.446   4.400  1.00  0.00           N  
ATOM   1233  CA  GLU A  88       6.213  28.228   3.350  1.00  0.00           C  
ATOM   1234  C   GLU A  88       7.547  27.598   2.945  1.00  0.00           C  
ATOM   1235  O   GLU A  88       7.778  27.329   1.767  1.00  0.00           O  
ATOM   1236  CB  GLU A  88       6.405  29.682   3.790  1.00  0.00           C  
ATOM   1237  CG  GLU A  88       5.792  30.647   2.774  1.00  0.00           C  
ATOM   1238  CD  GLU A  88       6.763  30.925   1.625  1.00  0.00           C  
ATOM   1239  OE1 GLU A  88       6.907  30.021   0.773  1.00  0.00           O  
ATOM   1240  OE2 GLU A  88       7.340  32.034   1.625  1.00  0.00           O  
ATOM   1241  H   GLU A  88       5.262  27.974   5.186  1.00  0.00           H  
ATOM   1242  HA  GLU A  88       5.520  28.198   2.511  1.00  0.00           H  
ATOM   1243  HB2 GLU A  88       5.945  29.834   4.766  1.00  0.00           H  
ATOM   1244  HB3 GLU A  88       7.469  29.894   3.902  1.00  0.00           H  
ATOM   1245  HG2 GLU A  88       4.867  30.226   2.380  1.00  0.00           H  
ATOM   1246  HG3 GLU A  88       5.531  31.583   3.268  1.00  0.00           H  
ATOM   1247  N   ALA A  89       8.391  27.379   3.943  1.00  0.00           N  
ATOM   1248  CA  ALA A  89       9.695  26.785   3.705  1.00  0.00           C  
ATOM   1249  C   ALA A  89       9.538  25.575   2.783  1.00  0.00           C  
ATOM   1250  O   ALA A  89      10.179  25.501   1.736  1.00  0.00           O  
ATOM   1251  CB  ALA A  89      10.340  26.419   5.044  1.00  0.00           C  
ATOM   1252  H   ALA A  89       8.195  27.600   4.899  1.00  0.00           H  
ATOM   1253  HA  ALA A  89      10.314  27.532   3.209  1.00  0.00           H  
ATOM   1254  HB1 ALA A  89       9.903  27.025   5.836  1.00  0.00           H  
ATOM   1255  HB2 ALA A  89      10.166  25.364   5.254  1.00  0.00           H  
ATOM   1256  HB3 ALA A  89      11.413  26.606   4.992  1.00  0.00           H  
ATOM   1257  N   LEU A  90       8.682  24.655   3.205  1.00  0.00           N  
ATOM   1258  CA  LEU A  90       8.433  23.452   2.430  1.00  0.00           C  
ATOM   1259  C   LEU A  90       8.134  23.838   0.979  1.00  0.00           C  
ATOM   1260  O   LEU A  90       8.764  23.327   0.055  1.00  0.00           O  
ATOM   1261  CB  LEU A  90       7.333  22.612   3.082  1.00  0.00           C  
ATOM   1262  CG  LEU A  90       7.762  21.758   4.276  1.00  0.00           C  
ATOM   1263  CD1 LEU A  90       6.546  21.280   5.073  1.00  0.00           C  
ATOM   1264  CD2 LEU A  90       8.645  20.592   3.827  1.00  0.00           C  
ATOM   1265  H   LEU A  90       8.165  24.723   4.058  1.00  0.00           H  
ATOM   1266  HA  LEU A  90       9.346  22.858   2.448  1.00  0.00           H  
ATOM   1267  HB2 LEU A  90       6.537  23.281   3.407  1.00  0.00           H  
ATOM   1268  HB3 LEU A  90       6.907  21.955   2.324  1.00  0.00           H  
ATOM   1269  HG  LEU A  90       8.360  22.377   4.943  1.00  0.00           H  
ATOM   1270 HD11 LEU A  90       6.878  20.667   5.911  1.00  0.00           H  
ATOM   1271 HD12 LEU A  90       5.997  22.143   5.450  1.00  0.00           H  
ATOM   1272 HD13 LEU A  90       5.896  20.691   4.426  1.00  0.00           H  
ATOM   1273 HD21 LEU A  90       8.050  19.680   3.783  1.00  0.00           H  
ATOM   1274 HD22 LEU A  90       9.056  20.806   2.840  1.00  0.00           H  
ATOM   1275 HD23 LEU A  90       9.461  20.459   4.538  1.00  0.00           H  
ATOM   1276  N   ARG A  91       7.172  24.736   0.826  1.00  0.00           N  
ATOM   1277  CA  ARG A  91       6.782  25.197  -0.496  1.00  0.00           C  
ATOM   1278  C   ARG A  91       8.011  25.652  -1.284  1.00  0.00           C  
ATOM   1279  O   ARG A  91       8.111  25.403  -2.485  1.00  0.00           O  
ATOM   1280  CB  ARG A  91       5.786  26.355  -0.405  1.00  0.00           C  
ATOM   1281  CG  ARG A  91       4.378  25.844  -0.091  1.00  0.00           C  
ATOM   1282  CD  ARG A  91       3.796  26.557   1.132  1.00  0.00           C  
ATOM   1283  NE  ARG A  91       3.444  27.952   0.784  1.00  0.00           N  
ATOM   1284  CZ  ARG A  91       2.450  28.290  -0.049  1.00  0.00           C  
ATOM   1285  NH1 ARG A  91       1.703  27.338  -0.623  1.00  0.00           N  
ATOM   1286  NH2 ARG A  91       2.203  29.582  -0.307  1.00  0.00           N  
ATOM   1287  H   ARG A  91       6.665  25.148   1.583  1.00  0.00           H  
ATOM   1288  HA  ARG A  91       6.314  24.332  -0.965  1.00  0.00           H  
ATOM   1289  HB2 ARG A  91       6.105  27.052   0.370  1.00  0.00           H  
ATOM   1290  HB3 ARG A  91       5.776  26.905  -1.345  1.00  0.00           H  
ATOM   1291  HG2 ARG A  91       3.731  26.003  -0.952  1.00  0.00           H  
ATOM   1292  HG3 ARG A  91       4.410  24.770   0.091  1.00  0.00           H  
ATOM   1293  HD2 ARG A  91       2.912  26.027   1.484  1.00  0.00           H  
ATOM   1294  HD3 ARG A  91       4.519  26.548   1.947  1.00  0.00           H  
ATOM   1295  HE  ARG A  91       3.982  28.687   1.195  1.00  0.00           H  
ATOM   1296 HH11 ARG A  91       1.888  26.374  -0.431  1.00  0.00           H  
ATOM   1297 HH12 ARG A  91       0.961  27.590  -1.244  1.00  0.00           H  
ATOM   1298 HH21 ARG A  91       2.760  30.293   0.122  1.00  0.00           H  
ATOM   1299 HH22 ARG A  91       1.460  29.834  -0.927  1.00  0.00           H  
ATOM   1300  N   GLY A  92       8.918  26.310  -0.577  1.00  0.00           N  
ATOM   1301  CA  GLY A  92      10.138  26.801  -1.196  1.00  0.00           C  
ATOM   1302  C   GLY A  92      11.201  25.703  -1.261  1.00  0.00           C  
ATOM   1303  O   GLY A  92      12.015  25.567  -0.351  1.00  0.00           O  
ATOM   1304  H   GLY A  92       8.830  26.507   0.400  1.00  0.00           H  
ATOM   1305  HA2 GLY A  92       9.920  27.163  -2.200  1.00  0.00           H  
ATOM   1306  HA3 GLY A  92      10.521  27.650  -0.628  1.00  0.00           H  
ATOM   1307  N   ALA A  93      11.159  24.948  -2.350  1.00  0.00           N  
ATOM   1308  CA  ALA A  93      12.108  23.866  -2.547  1.00  0.00           C  
ATOM   1309  C   ALA A  93      11.905  23.262  -3.938  1.00  0.00           C  
ATOM   1310  O   ALA A  93      10.773  23.032  -4.360  1.00  0.00           O  
ATOM   1311  CB  ALA A  93      11.941  22.831  -1.433  1.00  0.00           C  
ATOM   1312  H   ALA A  93      10.493  25.066  -3.086  1.00  0.00           H  
ATOM   1313  HA  ALA A  93      13.111  24.289  -2.485  1.00  0.00           H  
ATOM   1314  HB1 ALA A  93      11.932  23.335  -0.466  1.00  0.00           H  
ATOM   1315  HB2 ALA A  93      11.001  22.296  -1.572  1.00  0.00           H  
ATOM   1316  HB3 ALA A  93      12.770  22.123  -1.466  1.00  0.00           H  
ATOM   1317  N   GLY A  94      13.020  23.025  -4.613  1.00  0.00           N  
ATOM   1318  CA  GLY A  94      12.980  22.453  -5.949  1.00  0.00           C  
ATOM   1319  C   GLY A  94      13.005  20.925  -5.891  1.00  0.00           C  
ATOM   1320  O   GLY A  94      12.698  20.333  -4.857  1.00  0.00           O  
ATOM   1321  H   GLY A  94      13.937  23.216  -4.263  1.00  0.00           H  
ATOM   1322  HA2 GLY A  94      12.079  22.786  -6.463  1.00  0.00           H  
ATOM   1323  HA3 GLY A  94      13.829  22.813  -6.528  1.00  0.00           H  
ATOM   1324  N   THR A  95      13.374  20.328  -7.015  1.00  0.00           N  
ATOM   1325  CA  THR A  95      13.444  18.880  -7.106  1.00  0.00           C  
ATOM   1326  C   THR A  95      13.983  18.289  -5.801  1.00  0.00           C  
ATOM   1327  O   THR A  95      13.218  17.777  -4.986  1.00  0.00           O  
ATOM   1328  CB  THR A  95      14.291  18.523  -8.330  1.00  0.00           C  
ATOM   1329  OG1 THR A  95      15.513  19.225  -8.123  1.00  0.00           O  
ATOM   1330  CG2 THR A  95      13.731  19.120  -9.623  1.00  0.00           C  
ATOM   1331  H   THR A  95      13.623  20.816  -7.852  1.00  0.00           H  
ATOM   1332  HA  THR A  95      12.433  18.495  -7.239  1.00  0.00           H  
ATOM   1333  HB  THR A  95      14.410  17.443  -8.419  1.00  0.00           H  
ATOM   1334  HG1 THR A  95      16.289  18.620  -8.301  1.00  0.00           H  
ATOM   1335 HG21 THR A  95      13.467  18.316 -10.310  1.00  0.00           H  
ATOM   1336 HG22 THR A  95      12.844  19.711  -9.396  1.00  0.00           H  
ATOM   1337 HG23 THR A  95      14.485  19.759 -10.083  1.00  0.00           H  
ATOM   1338  N   ALA A  96      15.295  18.380  -5.646  1.00  0.00           N  
ATOM   1339  CA  ALA A  96      15.945  17.861  -4.454  1.00  0.00           C  
ATOM   1340  C   ALA A  96      15.675  18.803  -3.280  1.00  0.00           C  
ATOM   1341  O   ALA A  96      15.997  19.989  -3.344  1.00  0.00           O  
ATOM   1342  CB  ALA A  96      17.440  17.680  -4.726  1.00  0.00           C  
ATOM   1343  H   ALA A  96      15.910  18.799  -6.314  1.00  0.00           H  
ATOM   1344  HA  ALA A  96      15.507  16.886  -4.235  1.00  0.00           H  
ATOM   1345  HB1 ALA A  96      17.577  16.996  -5.562  1.00  0.00           H  
ATOM   1346  HB2 ALA A  96      17.884  18.645  -4.968  1.00  0.00           H  
ATOM   1347  HB3 ALA A  96      17.923  17.270  -3.838  1.00  0.00           H  
ATOM   1348  N   VAL A  97      15.088  18.241  -2.233  1.00  0.00           N  
ATOM   1349  CA  VAL A  97      14.771  19.017  -1.047  1.00  0.00           C  
ATOM   1350  C   VAL A  97      15.493  18.414   0.160  1.00  0.00           C  
ATOM   1351  O   VAL A  97      15.260  17.258   0.513  1.00  0.00           O  
ATOM   1352  CB  VAL A  97      13.254  19.091  -0.859  1.00  0.00           C  
ATOM   1353  CG1 VAL A  97      12.898  19.778   0.461  1.00  0.00           C  
ATOM   1354  CG2 VAL A  97      12.589  19.797  -2.043  1.00  0.00           C  
ATOM   1355  H   VAL A  97      14.828  17.276  -2.190  1.00  0.00           H  
ATOM   1356  HA  VAL A  97      15.141  20.030  -1.207  1.00  0.00           H  
ATOM   1357  HB  VAL A  97      12.871  18.071  -0.820  1.00  0.00           H  
ATOM   1358 HG11 VAL A  97      12.159  20.558   0.277  1.00  0.00           H  
ATOM   1359 HG12 VAL A  97      12.487  19.043   1.153  1.00  0.00           H  
ATOM   1360 HG13 VAL A  97      13.795  20.222   0.892  1.00  0.00           H  
ATOM   1361 HG21 VAL A  97      11.714  20.345  -1.692  1.00  0.00           H  
ATOM   1362 HG22 VAL A  97      13.297  20.493  -2.495  1.00  0.00           H  
ATOM   1363 HG23 VAL A  97      12.283  19.058  -2.782  1.00  0.00           H  
ATOM   1364  N   GLN A  98      16.355  19.222   0.758  1.00  0.00           N  
ATOM   1365  CA  GLN A  98      17.113  18.782   1.917  1.00  0.00           C  
ATOM   1366  C   GLN A  98      16.416  19.221   3.205  1.00  0.00           C  
ATOM   1367  O   GLN A  98      16.037  20.383   3.346  1.00  0.00           O  
ATOM   1368  CB  GLN A  98      18.550  19.308   1.864  1.00  0.00           C  
ATOM   1369  CG  GLN A  98      19.544  18.228   2.296  1.00  0.00           C  
ATOM   1370  CD  GLN A  98      20.969  18.784   2.345  1.00  0.00           C  
ATOM   1371  OE1 GLN A  98      21.360  19.483   3.265  1.00  0.00           O  
ATOM   1372  NE2 GLN A  98      21.721  18.436   1.305  1.00  0.00           N  
ATOM   1373  H   GLN A  98      16.539  20.160   0.464  1.00  0.00           H  
ATOM   1374  HA  GLN A  98      17.130  17.694   1.856  1.00  0.00           H  
ATOM   1375  HB2 GLN A  98      18.783  19.638   0.852  1.00  0.00           H  
ATOM   1376  HB3 GLN A  98      18.646  20.177   2.514  1.00  0.00           H  
ATOM   1377  HG2 GLN A  98      19.267  17.845   3.278  1.00  0.00           H  
ATOM   1378  HG3 GLN A  98      19.501  17.390   1.602  1.00  0.00           H  
ATOM   1379 HE21 GLN A  98      21.339  17.860   0.582  1.00  0.00           H  
ATOM   1380 HE22 GLN A  98      22.669  18.750   1.245  1.00  0.00           H  
ATOM   1381  N   MET A  99      16.268  18.268   4.114  1.00  0.00           N  
ATOM   1382  CA  MET A  99      15.622  18.543   5.387  1.00  0.00           C  
ATOM   1383  C   MET A  99      16.467  18.026   6.553  1.00  0.00           C  
ATOM   1384  O   MET A  99      16.743  16.831   6.643  1.00  0.00           O  
ATOM   1385  CB  MET A  99      14.247  17.873   5.416  1.00  0.00           C  
ATOM   1386  CG  MET A  99      13.235  18.660   4.582  1.00  0.00           C  
ATOM   1387  SD  MET A  99      11.663  18.721   5.426  1.00  0.00           S  
ATOM   1388  CE  MET A  99      10.606  18.041   4.159  1.00  0.00           C  
ATOM   1389  H   MET A  99      16.579  17.326   3.993  1.00  0.00           H  
ATOM   1390  HA  MET A  99      15.536  19.628   5.444  1.00  0.00           H  
ATOM   1391  HB2 MET A  99      14.326  16.855   5.034  1.00  0.00           H  
ATOM   1392  HB3 MET A  99      13.896  17.800   6.446  1.00  0.00           H  
ATOM   1393  HG2 MET A  99      13.602  19.672   4.408  1.00  0.00           H  
ATOM   1394  HG3 MET A  99      13.115  18.193   3.605  1.00  0.00           H  
ATOM   1395  HE1 MET A  99      10.579  16.955   4.252  1.00  0.00           H  
ATOM   1396  HE2 MET A  99       9.597  18.439   4.274  1.00  0.00           H  
ATOM   1397  HE3 MET A  99      10.993  18.312   3.177  1.00  0.00           H  
ATOM   1398  N   ARG A 100      16.854  18.953   7.418  1.00  0.00           N  
ATOM   1399  CA  ARG A 100      17.663  18.606   8.574  1.00  0.00           C  
ATOM   1400  C   ARG A 100      16.768  18.340   9.786  1.00  0.00           C  
ATOM   1401  O   ARG A 100      16.232  19.273  10.383  1.00  0.00           O  
ATOM   1402  CB  ARG A 100      18.649  19.726   8.913  1.00  0.00           C  
ATOM   1403  CG  ARG A 100      19.663  19.264   9.961  1.00  0.00           C  
ATOM   1404  CD  ARG A 100      20.634  20.391  10.317  1.00  0.00           C  
ATOM   1405  NE  ARG A 100      22.029  19.942  10.107  1.00  0.00           N  
ATOM   1406  CZ  ARG A 100      23.109  20.666  10.433  1.00  0.00           C  
ATOM   1407  NH1 ARG A 100      22.961  21.878  10.985  1.00  0.00           N  
ATOM   1408  NH2 ARG A 100      24.336  20.178  10.205  1.00  0.00           N  
ATOM   1409  H   ARG A 100      16.625  19.923   7.337  1.00  0.00           H  
ATOM   1410  HA  ARG A 100      18.201  17.705   8.278  1.00  0.00           H  
ATOM   1411  HB2 ARG A 100      19.172  20.040   8.009  1.00  0.00           H  
ATOM   1412  HB3 ARG A 100      18.106  20.595   9.284  1.00  0.00           H  
ATOM   1413  HG2 ARG A 100      19.139  18.935  10.859  1.00  0.00           H  
ATOM   1414  HG3 ARG A 100      20.218  18.407   9.584  1.00  0.00           H  
ATOM   1415  HD2 ARG A 100      20.429  21.268   9.702  1.00  0.00           H  
ATOM   1416  HD3 ARG A 100      20.494  20.691  11.355  1.00  0.00           H  
ATOM   1417  HE  ARG A 100      22.175  19.043   9.696  1.00  0.00           H  
ATOM   1418 HH11 ARG A 100      22.045  22.242  11.155  1.00  0.00           H  
ATOM   1419 HH12 ARG A 100      23.767  22.418  11.228  1.00  0.00           H  
ATOM   1420 HH21 ARG A 100      24.446  19.274   9.792  1.00  0.00           H  
ATOM   1421 HH22 ARG A 100      25.141  20.719  10.448  1.00  0.00           H  
ATOM   1422  N   VAL A 101      16.635  17.064  10.115  1.00  0.00           N  
ATOM   1423  CA  VAL A 101      15.814  16.664  11.245  1.00  0.00           C  
ATOM   1424  C   VAL A 101      16.717  16.348  12.439  1.00  0.00           C  
ATOM   1425  O   VAL A 101      17.924  16.166  12.278  1.00  0.00           O  
ATOM   1426  CB  VAL A 101      14.915  15.490  10.850  1.00  0.00           C  
ATOM   1427  CG1 VAL A 101      13.915  15.907   9.768  1.00  0.00           C  
ATOM   1428  CG2 VAL A 101      15.747  14.291  10.395  1.00  0.00           C  
ATOM   1429  H   VAL A 101      17.074  16.312   9.625  1.00  0.00           H  
ATOM   1430  HA  VAL A 101      15.174  17.507  11.502  1.00  0.00           H  
ATOM   1431  HB  VAL A 101      14.348  15.190  11.731  1.00  0.00           H  
ATOM   1432 HG11 VAL A 101      14.441  16.430   8.970  1.00  0.00           H  
ATOM   1433 HG12 VAL A 101      13.428  15.020   9.363  1.00  0.00           H  
ATOM   1434 HG13 VAL A 101      13.164  16.567  10.203  1.00  0.00           H  
ATOM   1435 HG21 VAL A 101      15.420  13.399  10.929  1.00  0.00           H  
ATOM   1436 HG22 VAL A 101      15.613  14.141   9.323  1.00  0.00           H  
ATOM   1437 HG23 VAL A 101      16.800  14.477  10.607  1.00  0.00           H  
ATOM   1438  N   TRP A 102      16.099  16.292  13.610  1.00  0.00           N  
ATOM   1439  CA  TRP A 102      16.832  16.002  14.831  1.00  0.00           C  
ATOM   1440  C   TRP A 102      16.304  14.682  15.396  1.00  0.00           C  
ATOM   1441  O   TRP A 102      15.103  14.532  15.615  1.00  0.00           O  
ATOM   1442  CB  TRP A 102      16.727  17.162  15.822  1.00  0.00           C  
ATOM   1443  CG  TRP A 102      17.760  17.112  16.950  1.00  0.00           C  
ATOM   1444  CD1 TRP A 102      19.094  17.042  16.844  1.00  0.00           C  
ATOM   1445  CD2 TRP A 102      17.488  17.132  18.367  1.00  0.00           C  
ATOM   1446  NE1 TRP A 102      19.699  17.015  18.085  1.00  0.00           N  
ATOM   1447  CE2 TRP A 102      18.690  17.071  19.040  1.00  0.00           C  
ATOM   1448  CE3 TRP A 102      16.264  17.199  19.057  1.00  0.00           C  
ATOM   1449  CZ2 TRP A 102      18.789  17.072  20.436  1.00  0.00           C  
ATOM   1450  CZ3 TRP A 102      16.379  17.198  20.453  1.00  0.00           C  
ATOM   1451  CH2 TRP A 102      17.583  17.138  21.145  1.00  0.00           C  
ATOM   1452  H   TRP A 102      15.118  16.442  13.731  1.00  0.00           H  
ATOM   1453  HA  TRP A 102      17.885  15.901  14.570  1.00  0.00           H  
ATOM   1454  HB2 TRP A 102      16.840  18.102  15.281  1.00  0.00           H  
ATOM   1455  HB3 TRP A 102      15.728  17.165  16.258  1.00  0.00           H  
ATOM   1456  HD1 TRP A 102      19.634  17.010  15.898  1.00  0.00           H  
ATOM   1457  HE1 TRP A 102      20.770  16.959  18.279  1.00  0.00           H  
ATOM   1458  HE3 TRP A 102      15.301  17.247  18.549  1.00  0.00           H  
ATOM   1459  HZ2 TRP A 102      19.751  17.023  20.945  1.00  0.00           H  
ATOM   1460  HZ3 TRP A 102      15.461  17.248  21.037  1.00  0.00           H  
ATOM   1461  HH2 TRP A 102      17.588  17.141  22.235  1.00  0.00           H  
ATOM   1462  N   ARG A 103      17.229  13.758  15.617  1.00  0.00           N  
ATOM   1463  CA  ARG A 103      16.871  12.456  16.153  1.00  0.00           C  
ATOM   1464  C   ARG A 103      18.080  11.813  16.836  1.00  0.00           C  
ATOM   1465  O   ARG A 103      19.223  12.145  16.524  1.00  0.00           O  
ATOM   1466  CB  ARG A 103      16.364  11.526  15.048  1.00  0.00           C  
ATOM   1467  CG  ARG A 103      15.626  10.323  15.641  1.00  0.00           C  
ATOM   1468  CD  ARG A 103      15.082   9.416  14.535  1.00  0.00           C  
ATOM   1469  NE  ARG A 103      13.637   9.668  14.340  1.00  0.00           N  
ATOM   1470  CZ  ARG A 103      12.675   9.188  15.139  1.00  0.00           C  
ATOM   1471  NH1 ARG A 103      12.998   8.425  16.192  1.00  0.00           N  
ATOM   1472  NH2 ARG A 103      11.389   9.468  14.885  1.00  0.00           N  
ATOM   1473  H   ARG A 103      18.203  13.888  15.437  1.00  0.00           H  
ATOM   1474  HA  ARG A 103      16.077  12.659  16.871  1.00  0.00           H  
ATOM   1475  HB2 ARG A 103      15.697  12.075  14.384  1.00  0.00           H  
ATOM   1476  HB3 ARG A 103      17.204  11.181  14.445  1.00  0.00           H  
ATOM   1477  HG2 ARG A 103      16.302   9.757  16.282  1.00  0.00           H  
ATOM   1478  HG3 ARG A 103      14.806  10.670  16.269  1.00  0.00           H  
ATOM   1479  HD2 ARG A 103      15.621   9.598  13.606  1.00  0.00           H  
ATOM   1480  HD3 ARG A 103      15.244   8.371  14.799  1.00  0.00           H  
ATOM   1481  HE  ARG A 103      13.361  10.234  13.562  1.00  0.00           H  
ATOM   1482 HH11 ARG A 103      13.957   8.216  16.382  1.00  0.00           H  
ATOM   1483 HH12 ARG A 103      12.280   8.066  16.789  1.00  0.00           H  
ATOM   1484 HH21 ARG A 103      11.148  10.037  14.097  1.00  0.00           H  
ATOM   1485 HH22 ARG A 103      10.672   9.109  15.480  1.00  0.00           H  
ATOM   1486  N   GLU A 104      17.786  10.906  17.755  1.00  0.00           N  
ATOM   1487  CA  GLU A 104      18.835  10.214  18.486  1.00  0.00           C  
ATOM   1488  C   GLU A 104      19.289   8.973  17.714  1.00  0.00           C  
ATOM   1489  O   GLU A 104      18.464   8.232  17.182  1.00  0.00           O  
ATOM   1490  CB  GLU A 104      18.369   9.843  19.895  1.00  0.00           C  
ATOM   1491  CG  GLU A 104      19.493   9.167  20.684  1.00  0.00           C  
ATOM   1492  CD  GLU A 104      18.991   7.893  21.369  1.00  0.00           C  
ATOM   1493  OE1 GLU A 104      18.475   8.022  22.500  1.00  0.00           O  
ATOM   1494  OE2 GLU A 104      19.136   6.820  20.745  1.00  0.00           O  
ATOM   1495  H   GLU A 104      16.854  10.642  18.003  1.00  0.00           H  
ATOM   1496  HA  GLU A 104      19.657  10.926  18.557  1.00  0.00           H  
ATOM   1497  HB2 GLU A 104      18.041  10.740  20.421  1.00  0.00           H  
ATOM   1498  HB3 GLU A 104      17.510   9.177  19.834  1.00  0.00           H  
ATOM   1499  HG2 GLU A 104      20.317   8.923  20.013  1.00  0.00           H  
ATOM   1500  HG3 GLU A 104      19.883   9.856  21.432  1.00  0.00           H  
ATOM   1501  N   SER A 105      20.600   8.784  17.678  1.00  0.00           N  
ATOM   1502  CA  SER A 105      21.173   7.645  16.981  1.00  0.00           C  
ATOM   1503  C   SER A 105      20.468   6.358  17.412  1.00  0.00           C  
ATOM   1504  O   SER A 105      20.723   5.841  18.499  1.00  0.00           O  
ATOM   1505  CB  SER A 105      22.677   7.540  17.242  1.00  0.00           C  
ATOM   1506  OG  SER A 105      22.967   7.339  18.622  1.00  0.00           O  
ATOM   1507  H   SER A 105      21.264   9.392  18.114  1.00  0.00           H  
ATOM   1508  HA  SER A 105      21.001   7.840  15.922  1.00  0.00           H  
ATOM   1509  HB2 SER A 105      23.088   6.715  16.660  1.00  0.00           H  
ATOM   1510  HB3 SER A 105      23.170   8.450  16.897  1.00  0.00           H  
ATOM   1511  HG  SER A 105      23.954   7.369  18.773  1.00  0.00           H  
ATOM   1512  N   GLY A 106      19.595   5.878  16.539  1.00  0.00           N  
ATOM   1513  CA  GLY A 106      18.852   4.661  16.815  1.00  0.00           C  
ATOM   1514  C   GLY A 106      17.414   4.979  17.232  1.00  0.00           C  
ATOM   1515  O   GLY A 106      17.048   6.146  17.370  1.00  0.00           O  
ATOM   1516  H   GLY A 106      19.394   6.305  15.656  1.00  0.00           H  
ATOM   1517  HA2 GLY A 106      18.845   4.025  15.931  1.00  0.00           H  
ATOM   1518  HA3 GLY A 106      19.348   4.100  17.608  1.00  0.00           H  
ATOM   1519  N   PRO A 107      16.618   3.894  17.425  1.00  0.00           N  
ATOM   1520  CA  PRO A 107      15.228   4.047  17.822  1.00  0.00           C  
ATOM   1521  C   PRO A 107      15.120   4.433  19.299  1.00  0.00           C  
ATOM   1522  O   PRO A 107      15.927   3.997  20.118  1.00  0.00           O  
ATOM   1523  CB  PRO A 107      14.580   2.708  17.508  1.00  0.00           C  
ATOM   1524  CG  PRO A 107      15.722   1.712  17.383  1.00  0.00           C  
ATOM   1525  CD  PRO A 107      17.017   2.499  17.269  1.00  0.00           C  
ATOM   1526  HA  PRO A 107      14.802   4.794  17.312  1.00  0.00           H  
ATOM   1527  HB2 PRO A 107      13.890   2.413  18.298  1.00  0.00           H  
ATOM   1528  HB3 PRO A 107      14.004   2.760  16.585  1.00  0.00           H  
ATOM   1529  HG2 PRO A 107      15.750   1.052  18.250  1.00  0.00           H  
ATOM   1530  HG3 PRO A 107      15.581   1.080  16.506  1.00  0.00           H  
ATOM   1531  HD2 PRO A 107      17.729   2.203  18.041  1.00  0.00           H  
ATOM   1532  HD3 PRO A 107      17.501   2.329  16.307  1.00  0.00           H  
ATOM   1533  N   SER A 108      14.115   5.245  19.593  1.00  0.00           N  
ATOM   1534  CA  SER A 108      13.890   5.693  20.957  1.00  0.00           C  
ATOM   1535  C   SER A 108      12.493   5.278  21.421  1.00  0.00           C  
ATOM   1536  O   SER A 108      11.492   5.730  20.867  1.00  0.00           O  
ATOM   1537  CB  SER A 108      14.059   7.210  21.072  1.00  0.00           C  
ATOM   1538  OG  SER A 108      15.395   7.621  20.790  1.00  0.00           O  
ATOM   1539  H   SER A 108      13.464   5.594  18.920  1.00  0.00           H  
ATOM   1540  HA  SER A 108      14.655   5.196  21.554  1.00  0.00           H  
ATOM   1541  HB2 SER A 108      13.374   7.705  20.383  1.00  0.00           H  
ATOM   1542  HB3 SER A 108      13.787   7.529  22.078  1.00  0.00           H  
ATOM   1543  HG  SER A 108      15.952   7.564  21.617  1.00  0.00           H  
ATOM   1544  N   SER A 109      12.470   4.423  22.433  1.00  0.00           N  
ATOM   1545  CA  SER A 109      11.212   3.942  22.976  1.00  0.00           C  
ATOM   1546  C   SER A 109      10.447   3.156  21.911  1.00  0.00           C  
ATOM   1547  O   SER A 109      10.460   1.926  21.912  1.00  0.00           O  
ATOM   1548  CB  SER A 109      10.358   5.100  23.498  1.00  0.00           C  
ATOM   1549  OG  SER A 109      10.908   5.680  24.677  1.00  0.00           O  
ATOM   1550  H   SER A 109      13.289   4.060  22.877  1.00  0.00           H  
ATOM   1551  HA  SER A 109      11.487   3.292  23.808  1.00  0.00           H  
ATOM   1552  HB2 SER A 109      10.274   5.864  22.724  1.00  0.00           H  
ATOM   1553  HB3 SER A 109       9.351   4.742  23.705  1.00  0.00           H  
ATOM   1554  HG  SER A 109      11.696   5.147  24.986  1.00  0.00           H  
ATOM   1555  N   GLY A 110       9.798   3.898  21.025  1.00  0.00           N  
ATOM   1556  CA  GLY A 110       9.028   3.286  19.956  1.00  0.00           C  
ATOM   1557  C   GLY A 110       7.583   3.789  19.963  1.00  0.00           C  
ATOM   1558  O   GLY A 110       7.011   4.060  18.909  1.00  0.00           O  
ATOM   1559  H   GLY A 110       9.792   4.898  21.032  1.00  0.00           H  
ATOM   1560  HA2 GLY A 110       9.491   3.511  18.995  1.00  0.00           H  
ATOM   1561  HA3 GLY A 110       9.040   2.202  20.069  1.00  0.00           H  
TER    1562      GLY A 110                                                      
END
MOLECULE T0488.pdb
ATOM      1  N   SER     1      20.128  12.809  24.526  1.00 19.40           N
ATOM      2  CA  SER     1      20.938  12.899  23.283  1.00 14.62           C
ATOM      4  CB  SER     1      21.786  11.646  23.101  1.00 17.49           C
ATOM      7  OG  SER     1      20.984  10.481  22.955  1.00 25.56           O
ATOM      9  C   SER     1      20.052  13.074  22.065  1.00 13.47           C
ATOM     10  O   SER     1      18.834  12.879  22.117  1.00 15.69           O
ATOM     14  N   MET     2      20.684  13.412  20.957  1.00 10.92           N
ATOM     15  CA  MET     2      20.000  13.465  19.689  1.00  9.70           C
ATOM     17  CB  MET     2      19.319  14.815  19.493  1.00 12.91           C
ATOM     20  CG  MET     2      20.286  15.963  19.402  1.00 15.71           C
ATOM     23  SD  MET     2      19.467  17.568  19.366  1.00 19.52           S
ATOM     24  CE  MET     2      18.819  17.665  21.032  1.00 31.08           C
ATOM     28  C   MET     2      20.956  13.195  18.552  1.00  9.06           C
ATOM     29  O   MET     2      22.158  13.370  18.682  1.00 13.20           O
ATOM     31  N   GLU     3      20.384  12.759  17.442  1.00  7.47           N
ATOM     32  CA  GLU     3      21.090  12.632  16.203  1.00  7.61           C
ATOM     34  CB  GLU     3      20.756  11.297  15.535  1.00  9.77           C
ATOM     37  CG  GLU     3      21.552  11.077  14.264  1.00 14.79           C
ATOM     40  CD  GLU     3      21.122   9.855  13.502  1.00 26.53           C
ATOM     41  OE1 GLU     3      20.303   9.074  14.028  1.00 31.96           O
ATOM     42  OE2 GLU     3      21.613   9.684  12.363  1.00 32.73           O
ATOM     43  C   GLU     3      20.689  13.781  15.297  1.00  8.80           C
ATOM     44  O   GLU     3      19.509  14.082  15.173  1.00 10.63           O
ATOM     46  N   ILE     4      21.679  14.418  14.693  1.00  7.18           N
ATOM     47  CA  ILE     4      21.451  15.424  13.665  1.00  7.38           C
ATOM     49  CB  ILE     4      22.306  16.675  13.857  1.00  9.41           C
ATOM     51  CG1 ILE     4      22.197  17.198  15.271  1.00 12.88           C
ATOM     54  CD1 ILE     4      20.874  17.635  15.639  1.00 14.81           C
ATOM     58  CG2 ILE     4      21.949  17.745  12.806  1.00 11.50           C
ATOM     62  C   ILE     4      21.801  14.808  12.341  1.00  7.35           C
ATOM     63  O   ILE     4      22.895  14.249  12.178  1.00  9.86           O
ATOM     65  N   LEU     5      20.875  14.902  11.402  1.00  7.58           N
ATOM     66  CA  LEU     5      21.132  14.378  10.062  1.00  8.65           C
ATOM     68  CB  LEU     5      20.731  12.925   9.943  1.00 13.90           C
ATOM     71  CG  LEU     5      19.252  12.666  10.057  1.00 13.10           C
ATOM     73  CD1 LEU     5      18.882  11.388   9.287  1.00 20.34           C
ATOM     77  CD2 LEU     5      18.772  12.562  11.493  1.00 19.29           C
ATOM     81  C   LEU     5      20.456  15.222   8.993  1.00  7.20           C
ATOM     82  O   LEU     5      19.584  16.031   9.280  1.00  8.46           O
ATOM     84  N   GLN     6      20.928  15.069   7.768  1.00  7.20           N
ATOM     85  CA  GLN     6      20.395  15.791   6.642  1.00  7.97           C
ATOM     87  CB  GLN     6      21.472  16.631   5.956  1.00 11.22           C
ATOM     90  CG  GLN     6      22.010  17.704   6.886  1.00 17.34           C
ATOM     93  CD  GLN     6      22.853  18.757   6.211  1.00 25.58           C
ATOM     94  OE1 GLN     6      22.673  19.078   5.034  1.00 22.54           O
ATOM     95  NE2 GLN     6      23.778  19.328   6.973  1.00 35.80           N
ATOM     98  C   GLN     6      19.774  14.804   5.678  1.00  8.78           C
ATOM     99  O   GLN     6      20.362  13.773   5.376  1.00 12.62           O
ATOM    101  N   VAL     7      18.567  15.128   5.237  1.00  6.69           N
ATOM    102  CA  VAL     7      17.825  14.314   4.312  1.00  6.49           C
ATOM    104  CB  VAL     7      16.555  13.757   4.961  1.00  7.24           C
ATOM    106  CG1 VAL     7      15.691  13.030   3.954  1.00  9.62           C
ATOM    110  CG2 VAL     7      16.911  12.821   6.122  1.00  9.31           C
ATOM    114  C   VAL     7      17.450  15.146   3.110  1.00  6.92           C
ATOM    115  O   VAL     7      16.765  16.128   3.242  1.00  9.54           O
ATOM    117  N   ALA     8      17.874  14.713   1.934  1.00  7.20           N
ATOM    118  CA  ALA     8      17.555  15.401   0.689  1.00  8.32           C
ATOM    120  CB  ALA     8      18.823  15.574  -0.152  1.00 12.50           C
ATOM    124  C   ALA     8      16.514  14.615  -0.079  1.00  7.94           C
ATOM    125  O   ALA     8      16.711  13.451  -0.375  1.00 12.11           O
ATOM    127  N   LEU     9      15.396  15.253  -0.365  1.00  7.05           N
ATOM    128  CA  LEU     9      14.331  14.704  -1.186  1.00  7.53           C
ATOM    130  CB  LEU     9      12.989  14.824  -0.479  1.00  7.05           C
ATOM    133  CG  LEU     9      12.915  14.175   0.902  1.00  6.94           C
ATOM    135  CD1 LEU     9      11.557  14.422   1.532  1.00 10.28           C
ATOM    139  CD2 LEU     9      13.241  12.665   0.874  1.00  9.01           C
ATOM    143  C   LEU     9      14.296  15.466  -2.509  1.00  6.69           C
ATOM    144  O   LEU     9      14.683  16.629  -2.573  1.00  9.96           O
ATOM    146  N   HIS    10      13.820  14.806  -3.557  1.00  7.45           N
ATOM    147  CA  HIS    10      13.788  15.443  -4.867  1.00  8.58           C
ATOM    149  CB  HIS    10      14.817  14.786  -5.773  1.00 10.46           C
ATOM    152  CG  HIS    10      16.223  15.001  -5.303  1.00 12.40           C
ATOM    153  ND1 HIS    10      16.996  16.053  -5.741  1.00 16.70           N
ATOM    155  CE1 HIS    10      18.175  16.010  -5.143  1.00 18.81           C
ATOM    157  NE2 HIS    10      18.179  14.989  -4.305  1.00 19.15           N
ATOM    159  CD2 HIS    10      16.965  14.349  -4.376  1.00 19.64           C
ATOM    161  C   HIS    10      12.402  15.443  -5.494  1.00  7.84           C
ATOM    162  O   HIS    10      11.834  14.379  -5.778  1.00 11.03           O
ATOM    164  N   LYS    11      11.837  16.643  -5.638  1.00  9.81           N
ATOM    165  CA  LYS    11      10.512  16.790  -6.253  1.00 10.04           C
ATOM    167  CB  LYS    11       9.985  18.217  -6.073  1.00 12.34           C
ATOM    170  CG  LYS    11       9.686  18.625  -4.623  1.00 12.62           C
ATOM    173  CD  LYS    11       8.576  19.704  -4.546  1.00 31.05           C
ATOM    176  CE  LYS    11       8.996  21.073  -5.051  1.00 24.45           C
ATOM    179  NZ  LYS    11       8.322  22.218  -4.361  1.00 21.96           N
ATOM    183  C   LYS    11      10.588  16.474  -7.733  1.00 12.69           C
ATOM    184  O   LYS    11      11.432  17.042  -8.419  1.00 14.69           O
ATOM    186  N   ARG    12       9.704  15.604  -8.215  1.00 13.65           N
ATOM    187  CA  ARG    12       9.688  15.217  -9.636  1.00 17.02           C
ATOM    189  CB  ARG    12       9.080  13.819  -9.812  1.00 18.82           C
ATOM    192  CG  ARG    12       9.882  12.720  -9.103  1.00 23.83           C
ATOM    195  CD  ARG    12      10.108  11.497  -9.984  1.00 35.96           C
ATOM    198  NE  ARG    12      10.943  10.483  -9.336  1.00 41.80           N
ATOM    200  CZ  ARG    12      11.421   9.393  -9.940  1.00 38.74           C
ATOM    201  NH1 ARG    12      11.158   9.156 -11.222  1.00 41.88           N
ATOM    204  NH2 ARG    12      12.172   8.530  -9.257  1.00 33.93           N
ATOM    207  C   ARG    12       8.948  16.257 -10.475  1.00 17.99           C
ATOM    208  O   ARG    12       9.156  16.335 -11.696  1.00 22.78           O
ATOM    210  N   ASP    13       8.081  17.035  -9.822  1.00 16.60           N
ATOM    211  CA  ASP    13       7.475  18.241 -10.404  1.00 17.38           C
ATOM    213  CB  ASP    13       6.064  17.959 -10.970  1.00 19.09           C
ATOM    216  CG  ASP    13       5.028  17.642  -9.898  1.00 19.81           C
ATOM    217  OD1 ASP    13       4.382  18.582  -9.384  1.00 22.06           O
ATOM    218  OD2 ASP    13       4.810  16.436  -9.621  1.00 23.43           O
ATOM    219  C   ASP    13       7.449  19.320  -9.327  1.00 14.18           C
ATOM    220  O   ASP    13       7.531  19.010  -8.142  1.00 14.00           O
ATOM    222  N   SER    14       7.329  20.578  -9.725  1.00 13.19           N
ATOM    223  CA  SER    14       7.384  21.702  -8.783  1.00 13.78           C
ATOM    225  CB  SER    14       7.433  23.044  -9.519  1.00 14.22           C
ATOM    228  OG  SER    14       6.243  23.269 -10.244  1.00 16.20           O
ATOM    230  C   SER    14       6.252  21.710  -7.764  1.00 11.76           C
ATOM    231  O   SER    14       6.341  22.373  -6.725  1.00 14.54           O
ATOM    233  N   GLY    15       5.172  20.998  -8.084  1.00 11.38           N
ATOM    234  CA  GLY    15       4.049  20.871  -7.180  1.00 10.63           C
ATOM    237  C   GLY    15       3.987  19.585  -6.383  1.00 10.54           C
ATOM    238  O   GLY    15       2.994  19.372  -5.694  1.00 11.58           O
ATOM    240  N   GLU    16       5.011  18.735  -6.462  1.00 10.14           N
ATOM    241  CA  GLU    16       4.979  17.475  -5.723  1.00 10.90           C
ATOM    243  CB  GLU    16       6.077  16.500  -6.154  1.00 11.37           C
ATOM    246  CG  GLU    16       5.878  15.118  -5.509  1.00 13.41           C
ATOM    249  CD  GLU    16       6.796  14.031  -6.016  1.00 14.39           C
ATOM    250  OE1 GLU    16       7.821  14.327  -6.657  1.00 17.24           O
ATOM    251  OE2 GLU    16       6.498  12.847  -5.728  1.00 19.88           O
ATOM    252  C   GLU    16       5.094  17.732  -4.229  1.00 11.70           C
ATOM    253  O   GLU    16       5.900  18.539  -3.792  1.00 12.51           O
ATOM    255  N   GLN    17       4.285  17.037  -3.431  1.00 13.12           N
ATOM    256  CA  GLN    17       4.419  17.166  -1.988  1.00 13.43           C
ATOM    258  CB  GLN    17       3.109  16.888  -1.274  1.00 17.00           C
ATOM    261  CG  GLN    17       2.086  17.994  -1.457  0.50 13.19           C
ATOM    264  CD  GLN    17       0.701  17.540  -1.069  0.50 12.56           C
ATOM    265  OE1 GLN    17       0.216  16.501  -1.557  0.50 18.97           O
ATOM    266  NE2 GLN    17       0.049  18.301  -0.192  0.50 15.21           N
ATOM    269  C   GLN    17       5.510  16.223  -1.502  1.00  9.97           C
ATOM    270  O   GLN    17       5.923  15.294  -2.196  1.00 11.21           O
ATOM    272  N   LEU    18       5.980  16.475  -0.298  1.00  9.09           N
ATOM    273  CA  LEU    18       7.002  15.642   0.309  1.00  7.79           C
ATOM    275  CB  LEU    18       7.785  16.430   1.341  1.00 10.03           C
ATOM    278  CG  LEU    18       8.464  17.680   0.774  1.00 13.65           C
ATOM    280  CD1 LEU    18       9.327  18.337   1.851  1.00 16.68           C
ATOM    284  CD2 LEU    18       9.285  17.333  -0.465  1.00 14.79           C
ATOM    288  C   LEU    18       6.406  14.423   0.970  1.00  6.95           C
ATOM    289  O   LEU    18       7.112  13.436   1.174  1.00  7.83           O
ATOM    291  N   GLY    19       5.127  14.475   1.336  1.00  6.45           N
ATOM    292  CA  GLY    19       4.529  13.361   2.072  1.00  5.80           C
ATOM    295  C   GLY    19       4.856  13.345   3.551  1.00  5.53           C
ATOM    296  O   GLY    19       5.144  12.296   4.119  1.00  6.57           O
ATOM    298  N   ILE    20       4.790  14.519   4.179  1.00  6.22           N
ATOM    299  CA  ILE    20       5.150  14.697   5.587  1.00  6.82           C
ATOM    301  CB  ILE    20       6.489  15.508   5.743  1.00  8.22           C
ATOM    303  CG1 ILE    20       7.649  14.867   4.981  1.00  9.99           C
ATOM    306  CD1 ILE    20       8.873  15.766   4.839  1.00 13.13           C
ATOM    310  CG2 ILE    20       6.832  15.684   7.223  1.00 12.01           C
ATOM    314  C   ILE    20       4.027  15.459   6.274  1.00  6.99           C
ATOM    315  O   ILE    20       3.566  16.461   5.762  1.00  9.28           O
ATOM    317  N   LYS    21       3.586  14.957   7.413  1.00  7.07           N
ATOM    318  CA  LYS    21       2.690  15.683   8.288  1.00  6.19           C
ATOM    320  CB  LYS    21       1.699  14.734   8.954  1.00  8.22           C
ATOM    323  CG  LYS    21       0.953  13.836   7.994  1.00 15.14           C
ATOM    326  CD  LYS    21      -0.238  13.152   8.664  1.00 20.17           C
ATOM    329  CE  LYS    21      -0.766  11.971   7.851  1.00 17.14           C
ATOM    332  NZ  LYS    21      -1.781  11.169   8.587  1.00 23.82           N
ATOM    336  C   LYS    21       3.510  16.425   9.341  1.00  8.23           C
ATOM    337  O   LYS    21       4.179  15.810  10.163  1.00  8.25           O
ATOM    339  N   LEU    22       3.477  17.754   9.278  1.00  6.53           N
ATOM    340  CA  LEU    22       4.253  18.608  10.175  1.00  7.05           C
ATOM    342  CB  LEU    22       4.977  19.717   9.405  1.00  9.04           C
ATOM    345  CG  LEU    22       6.120  19.350   8.473  1.00 11.98           C
ATOM    347  CD1 LEU    22       6.685  20.618   7.819  1.00 16.38           C
ATOM    351  CD2 LEU    22       7.190  18.609   9.229  1.00 12.08           C
ATOM    355  C   LEU    22       3.340  19.222  11.220  1.00  6.95           C
ATOM    356  O   LEU    22       2.267  19.693  10.894  1.00  8.65           O
ATOM    358  N   VAL    23       3.808  19.255  12.458  1.00  6.35           N
ATOM    359  CA  VAL    23       3.041  19.777  13.571  1.00  6.35           C
ATOM    361  CB  VAL    23       2.419  18.631  14.430  1.00  7.14           C
ATOM    363  CG1 VAL    23       1.471  17.776  13.574  1.00 10.40           C
ATOM    367  CG2 VAL    23       3.466  17.784  15.139  1.00  8.76           C
ATOM    371  C   VAL    23       3.855  20.658  14.495  1.00  6.32           C
ATOM    372  O   VAL    23       5.072  20.554  14.588  1.00  7.02           O
ATOM    374  N   ARG    24       3.147  21.542  15.177  1.00  6.06           N
ATOM    375  CA  ARG    24       3.667  22.214  16.353  1.00  6.42           C
ATOM    377  CB  ARG    24       3.154  23.651  16.436  1.00  7.91           C
ATOM    380  CG  ARG    24       1.670  23.812  16.738  1.00  8.11           C
ATOM    383  CD  ARG    24       1.240  25.229  16.426  1.00 11.78           C
ATOM    386  NE  ARG    24      -0.147  25.442  16.818  1.00 11.84           N
ATOM    388  CZ  ARG    24      -0.924  26.419  16.356  1.00 13.32           C
ATOM    389  NH1 ARG    24      -0.470  27.304  15.491  1.00 13.58           N
ATOM    392  NH2 ARG    24      -2.176  26.505  16.774  1.00 15.33           N
ATOM    395  C   ARG    24       3.277  21.419  17.588  1.00  7.93           C
ATOM    396  O   ARG    24       2.320  20.643  17.569  1.00 10.12           O
ATOM    398  N   ARG    25       4.018  21.637  18.670  1.00  7.87           N
ATOM    399  CA  ARG    25       3.751  20.948  19.936  1.00 10.55           C
ATOM    401  CB  ARG    25       4.972  20.177  20.387  1.00 11.13           C
ATOM    404  CG  ARG    25       5.165  18.961  19.570  1.00 14.31           C
ATOM    407  CD  ARG    25       6.317  18.166  20.053  1.00 14.64           C
ATOM    410  NE  ARG    25       6.432  16.964  19.256  1.00 20.85           N
ATOM    412  CZ  ARG    25       7.389  16.056  19.399  1.00 21.75           C
ATOM    413  NH1 ARG    25       8.324  16.190  20.332  1.00 26.11           N
ATOM    416  NH2 ARG    25       7.410  15.002  18.596  1.00 19.78           N
ATOM    419  C   ARG    25       3.407  21.916  21.018  1.00 12.37           C
ATOM    420  O   ARG    25       3.895  23.032  21.024  1.00 12.41           O
ATOM    422  N   THR    26       2.593  21.449  21.958  1.00 13.46           N
ATOM    423  CA  THR    26       2.064  22.292  23.024  1.00 16.07           C
ATOM    425  CB  THR    26       0.724  21.742  23.541  1.00 15.98           C
ATOM    427  OG1 THR    26       0.901  20.365  23.892  1.00 20.67           O
ATOM    429  CG2 THR    26      -0.319  21.846  22.445  1.00 18.95           C
ATOM    433  C   THR    26       3.003  22.470  24.213  1.00 14.82           C
ATOM    434  O   THR    26       2.719  23.286  25.078  1.00 19.95           O
ATOM    436  N   ASP    27       4.122  21.754  24.245  1.00 16.37           N
ATOM    437  CA  ASP    27       5.000  21.772  25.411  1.00 18.65           C
ATOM    439  CB  ASP    27       4.850  20.464  26.181  1.00 23.44           C
ATOM    442  CG  ASP    27       5.179  19.239  25.334  1.00 31.95           C
ATOM    443  OD1 ASP    27       5.466  19.385  24.118  1.00 29.18           O
ATOM    444  OD2 ASP    27       5.137  18.121  25.887  1.00 45.79           O
ATOM    445  C   ASP    27       6.472  21.999  25.078  1.00 17.69           C
ATOM    446  O   ASP    27       7.320  21.926  25.961  1.00 20.53           O
ATOM    448  N   GLU    28       6.790  22.264  23.815  1.00 15.18           N
ATOM    449  CA  GLU    28       8.160  22.554  23.416  1.00 15.75           C
ATOM    451  CB  GLU    28       8.999  21.268  23.355  1.00 17.87           C
ATOM    454  CG  GLU    28       8.564  20.268  22.295  1.00 15.99           C
ATOM    457  CD  GLU    28       9.431  19.010  22.286  1.00 17.81           C
ATOM    458  OE1 GLU    28      10.659  19.146  22.161  1.00 25.99           O
ATOM    459  OE2 GLU    28       8.881  17.905  22.411  1.00 32.00           O
ATOM    460  C   GLU    28       8.153  23.236  22.054  1.00 13.50           C
ATOM    461  O   GLU    28       7.240  23.042  21.248  1.00 11.92           O
ATOM    463  N   PRO    29       9.178  24.036  21.791  1.00 11.31           N
ATOM    464  CA  PRO    29       9.234  24.766  20.542  1.00  9.48           C
ATOM    466  CB  PRO    29      10.283  25.836  20.815  1.00 13.51           C
ATOM    469  CG  PRO    29      11.215  25.168  21.786  1.00 13.32           C
ATOM    472  CD  PRO    29      10.337  24.320  22.656  1.00 13.95           C
ATOM    475  C   PRO    29       9.672  23.871  19.401  1.00 10.21           C
ATOM    476  O   PRO    29      10.263  22.802  19.630  1.00 10.48           O
ATOM    477  N   GLY    30       9.388  24.307  18.178  1.00  8.28           N
ATOM    478  CA  GLY    30       9.868  23.605  17.007  1.00  8.52           C
ATOM    481  C   GLY    30       8.771  23.103  16.084  1.00  7.13           C
ATOM    482  O   GLY    30       7.579  23.153  16.414  1.00  7.59           O
ATOM    484  N   VAL    31       9.206  22.606  14.930  1.00  6.41           N
ATOM    485  CA  VAL    31       8.341  21.984  13.950  1.00  6.55           C
ATOM    487  CB  VAL    31       8.562  22.633  12.560  1.00  9.09           C
ATOM    489  CG1 VAL    31       7.696  21.998  11.538  1.00 11.32           C
ATOM    493  CG2 VAL    31       8.330  24.131  12.631  1.00 12.01           C
ATOM    497  C   VAL    31       8.734  20.517  13.912  1.00  5.36           C
ATOM    498  O   VAL    31       9.921  20.186  13.789  1.00  6.15           O
ATOM    500  N   PHE    32       7.745  19.636  14.012  1.00  5.13           N
ATOM    501  CA  PHE    32       7.985  18.206  14.179  1.00  6.39           C
ATOM    503  CB  PHE    32       7.554  17.743  15.584  1.00  6.64           C
ATOM    506  CG  PHE    32       8.328  18.414  16.676  1.00  6.56           C
ATOM    507  CD1 PHE    32       9.453  17.844  17.194  1.00  6.87           C
ATOM    509  CE1 PHE    32      10.178  18.486  18.181  1.00  8.33           C
ATOM    511  CZ  PHE    32       9.765  19.681  18.653  1.00  8.49           C
ATOM    513  CE2 PHE    32       8.641  20.269  18.156  1.00  8.36           C
ATOM    515  CD2 PHE    32       7.922  19.638  17.169  1.00  6.58           C
ATOM    517  C   PHE    32       7.260  17.401  13.145  1.00  6.13           C
ATOM    518  O   PHE    32       6.154  17.747  12.715  1.00  8.29           O
ATOM    520  N   ILE    33       7.866  16.282  12.766  1.00  5.72           N
ATOM    521  CA  ILE    33       7.185  15.310  11.921  1.00  5.98           C
ATOM    523  CB  ILE    33       8.192  14.401  11.195  1.00  6.56           C
ATOM    525  CG1 ILE    33       9.084  15.265  10.320  1.00  7.81           C
ATOM    528  CD1 ILE    33      10.065  14.515   9.462  1.00  9.96           C
ATOM    532  CG2 ILE    33       7.493  13.339  10.346  1.00  8.37           C
ATOM    536  C   ILE    33       6.274  14.467  12.801  1.00  7.53           C
ATOM    537  O   ILE    33       6.726  13.828  13.751  1.00  8.02           O
ATOM    539  N   LEU    34       4.981  14.441  12.481  1.00  6.69           N
ATOM    540  CA  LEU    34       4.062  13.561  13.167  1.00  9.23           C
ATOM    542  CB  LEU    34       2.651  14.122  13.100  1.00  9.63           C
ATOM    545  CG  LEU    34       1.589  13.339  13.869  1.00 10.85           C
ATOM    547  CD1 LEU    34       1.808  13.508  15.371  1.00 13.84           C
ATOM    551  CD2 LEU    34       0.192  13.819  13.461  1.00 17.22           C
ATOM    555  C   LEU    34       4.149  12.162  12.550  1.00  8.28           C
ATOM    556  O   LEU    34       4.259  11.163  13.265  1.00  9.20           O
ATOM    558  N   ASP    35       4.066  12.102  11.222  1.00  8.00           N
ATOM    559  CA  ASP    35       4.172  10.849  10.482  1.00  8.97           C
ATOM    561  CB  ASP    35       2.937   9.975  10.701  1.00 15.92           C
ATOM    564  CG  ASP    35       1.688  10.662  10.296  1.00 18.18           C
ATOM    565  OD1 ASP    35       1.592  10.998   9.115  1.00 27.37           O
ATOM    566  OD2 ASP    35       0.793  10.869  11.145  1.00 37.45           O
ATOM    567  C   ASP    35       4.374  11.200   9.011  1.00  7.38           C
ATOM    568  O   ASP    35       4.342  12.361   8.636  1.00  7.85           O
ATOM    570  N   LEU    36       4.617  10.172   8.213  1.00  9.96           N
ATOM    571  CA  LEU    36       4.789  10.277   6.792  1.00  9.02           C
ATOM    573  CB  LEU    36       6.040   9.523   6.346  1.00  9.54           C
ATOM    576  CG  LEU    36       7.348   9.882   7.039  1.00 11.95           C
ATOM    578  CD1 LEU    36       8.469   9.086   6.358  1.00 12.55           C
ATOM    582  CD2 LEU    36       7.634  11.373   6.998  1.00 10.74           C
ATOM    586  C   LEU    36       3.575   9.694   6.086  1.00 10.85           C
ATOM    587  O   LEU    36       2.923   8.753   6.590  1.00 16.71           O
ATOM    589  N   LEU    37       3.267  10.244   4.924  1.00 10.18           N
ATOM    590  CA  LEU    37       2.173   9.751   4.101  1.00  9.91           C
ATOM    592  CB  LEU    37       1.680  10.825   3.129  1.00 11.13           C
ATOM    595  CG  LEU    37       1.134  12.139   3.683  0.50 15.44           C
ATOM    599  CD1 LEU    37       0.485  12.974   2.576  0.50 17.87           C
ATOM    607  CD2 LEU    37       0.158  11.845   4.773  0.50 17.28           C
ATOM    615  C   LEU    37       2.603   8.536   3.287  1.00  9.77           C
ATOM    616  O   LEU    37       3.694   8.497   2.729  1.00  9.19           O
ATOM    618  N   GLU    38       1.707   7.561   3.187  1.00 12.24           N
ATOM    619  CA  GLU    38       1.930   6.353   2.392  1.00 14.34           C
ATOM    621  CB  GLU    38       0.618   5.543   2.312  1.00 18.79           C
ATOM    624  CG  GLU    38       0.785   4.168   1.682  1.00 22.16           C
ATOM    627  CD  GLU    38      -0.488   3.358   1.710  1.00 31.25           C
ATOM    628  OE1 GLU    38      -1.564   3.948   1.927  1.00 23.39           O
ATOM    629  OE2 GLU    38      -0.412   2.128   1.508  1.00 44.28           O
ATOM    630  C   GLU    38       2.369   6.686   0.979  1.00 13.82           C
ATOM    631  O   GLU    38       1.738   7.485   0.314  1.00 14.65           O
ATOM    633  N   GLY    39       3.467   6.086   0.533  1.00 11.43           N
ATOM    634  CA  GLY    39       3.898   6.213  -0.864  1.00 14.98           C
ATOM    637  C   GLY    39       4.490   7.564  -1.252  1.00 12.08           C
ATOM    638  O   GLY    39       4.870   7.772  -2.408  1.00 13.34           O
ATOM    640  N   GLY    40       4.612   8.482  -0.299  1.00  9.86           N
ATOM    641  CA  GLY    40       5.146   9.787  -0.608  1.00  9.55           C
ATOM    644  C   GLY    40       6.653   9.766  -0.727  1.00  7.46           C
ATOM    645  O   GLY    40       7.303   8.764  -0.407  1.00  7.40           O
ATOM    647  N   LEU    41       7.222  10.891  -1.146  1.00  7.62           N
ATOM    648  CA  LEU    41       8.672  10.979  -1.316  1.00  8.00           C
ATOM    650  CB  LEU    41       9.091  12.399  -1.714  1.00 10.73           C
ATOM    653  CG  LEU    41       8.977  12.843  -3.153  1.00 14.71           C
ATOM    655  CD1 LEU    41       9.439  14.280  -3.194  1.00 13.54           C
ATOM    659  CD2 LEU    41       9.823  11.953  -4.047  1.00 13.69           C
ATOM    663  C   LEU    41       9.398  10.637  -0.047  1.00  6.30           C
ATOM    664  O   LEU    41      10.426   9.958  -0.078  1.00  6.05           O
ATOM    666  N   ALA    42       8.923  11.169   1.076  1.00  6.10           N
ATOM    667  CA  ALA    42       9.617  10.951   2.343  1.00  5.50           C
ATOM    669  CB  ALA    42       9.039  11.836   3.429  1.00  6.62           C
ATOM    673  C   ALA    42       9.603   9.484   2.750  1.00  6.00           C
ATOM    674  O   ALA    42      10.614   8.938   3.177  1.00  5.85           O
ATOM    676  N   ALA    43       8.451   8.841   2.592  1.00  5.17           N
ATOM    677  CA  ALA    43       8.324   7.429   2.900  1.00  5.95           C
ATOM    679  CB  ALA    43       6.877   6.965   2.811  1.00  8.50           C
ATOM    683  C   ALA    43       9.207   6.590   1.979  1.00  6.68           C
ATOM    684  O   ALA    43       9.846   5.647   2.421  1.00  7.67           O
ATOM    686  N   GLN    44       9.239   6.927   0.693  1.00  6.75           N
ATOM    687  CA  GLN    44      10.080   6.208  -0.242  1.00  5.96           C
ATOM    689  CB  GLN    44       9.884   6.725  -1.657  1.00  6.18           C
ATOM    692  CG  GLN    44       8.528   6.335  -2.259  1.00  8.92           C
ATOM    695  CD  GLN    44       8.364   6.902  -3.633  1.00 11.62           C
ATOM    696  OE1 GLN    44       9.187   6.663  -4.520  1.00 14.68           O
ATOM    697  NE2 GLN    44       7.314   7.675  -3.818  1.00 14.96           N
ATOM    700  C   GLN    44      11.545   6.330   0.121  1.00  5.84           C
ATOM    701  O   GLN    44      12.322   5.375  -0.015  1.00  6.68           O
ATOM    703  N   ASP    45      11.944   7.519   0.550  1.00  5.19           N
ATOM    704  CA  ASP    45      13.315   7.747   0.941  1.00  5.40           C
ATOM    706  CB  ASP    45      13.577   9.248   1.150  1.00  5.38           C
ATOM    709  CG  ASP    45      14.928   9.517   1.707  1.00  7.25           C
ATOM    710  OD1 ASP    45      15.893   9.620   0.899  1.00  7.92           O
ATOM    711  OD2 ASP    45      15.039   9.605   2.962  1.00  7.45           O
ATOM    712  C   ASP    45      13.687   6.947   2.180  1.00  6.21           C
ATOM    713  O   ASP    45      14.794   6.435   2.255  1.00  7.92           O
ATOM    715  N   GLY    46      12.777   6.884   3.146  1.00  6.05           N
ATOM    716  CA  GLY    46      12.890   6.010   4.303  1.00  8.24           C
ATOM    719  C   GLY    46      13.464   6.635   5.554  1.00  8.42           C
ATOM    720  O   GLY    46      13.208   6.144   6.652  1.00 12.24           O
ATOM    722  N   ARG    47      14.251   7.704   5.407  1.00  6.54           N
ATOM    723  CA  ARG    47      15.018   8.218   6.545  1.00  8.04           C
ATOM    725  CB  ARG    47      16.169   9.085   6.066  1.00  7.42           C
ATOM    728  CG  ARG    47      17.222   8.284   5.355  1.00  9.19           C
ATOM    731  CD  ARG    47      18.320   9.143   4.763  1.00  9.89           C
ATOM    734  NE  ARG    47      17.874   9.848   3.578  1.00  8.34           N
ATOM    736  CZ  ARG    47      18.629  10.670   2.865  1.00  7.37           C
ATOM    737  NH1 ARG    47      19.872  10.932   3.235  1.00 10.70           N
ATOM    740  NH2 ARG    47      18.144  11.253   1.797  1.00  8.55           N
ATOM    743  C   ARG    47      14.197   8.973   7.569  1.00  8.63           C
ATOM    744  O   ARG    47      14.369   8.776   8.766  1.00 13.68           O
ATOM    746  N   LEU    48      13.341   9.866   7.116  1.00  7.63           N
ATOM    747  CA  LEU    48      12.584  10.684   8.035  1.00  7.29           C
ATOM    749  CB  LEU    48      11.816  11.766   7.291  1.00  7.30           C
ATOM    752  CG  LEU    48      12.687  12.823   6.589  1.00  8.01           C
ATOM    754  CD1 LEU    48      11.836  13.663   5.678  1.00 10.86           C
ATOM    758  CD2 LEU    48      13.434  13.710   7.580  1.00  9.67           C
ATOM    762  C   LEU    48      11.646   9.839   8.871  1.00  9.21           C
ATOM    763  O   LEU    48      11.231   8.751   8.454  1.00 11.25           O
ATOM    765  N   SER    49      11.325  10.343  10.062  1.00  7.94           N
ATOM    766  CA  SER    49      10.576   9.586  11.039  1.00  8.89           C
ATOM    768  CB  SER    49      11.569   8.839  11.926  1.00 10.93           C
ATOM    771  OG  SER    49      10.887   7.933  12.776  1.00 14.79           O
ATOM    773  C   SER    49       9.708  10.456  11.922  1.00  7.68           C
ATOM    774  O   SER    49      10.045  11.579  12.207  1.00  7.74           O
ATOM    776  N   SER    50       8.643   9.859  12.435  1.00  7.02           N
ATOM    777  CA  SER    50       7.847  10.451  13.491  1.00  7.93           C
ATOM    779  CB  SER    50       6.847   9.400  13.997  0.50  7.51           C
ATOM    785  OG  SER    50       5.958   9.906  14.963  0.50  6.38           O
ATOM    789  C   SER    50       8.764  10.917  14.610  1.00  6.25           C
ATOM    790  O   SER    50       9.705  10.210  14.994  1.00  8.15           O
ATOM    792  N   ASN    51       8.476  12.127  15.105  1.00  5.84           N
ATOM    793  CA  ASN    51       9.180  12.780  16.210  1.00  6.94           C
ATOM    795  CB  ASN    51       9.345  11.845  17.409  1.00  8.16           C
ATOM    798  CG  ASN    51       8.018  11.464  17.982  1.00  9.85           C
ATOM    799  OD1 ASN    51       7.313  12.311  18.530  1.00 12.30           O
ATOM    800  ND2 ASN    51       7.642  10.213  17.832  1.00  9.84           N
ATOM    803  C   ASN    51      10.454  13.506  15.833  1.00  6.49           C
ATOM    804  O   ASN    51      11.045  14.165  16.682  1.00  8.19           O
ATOM    806  N   ASP    52      10.845  13.450  14.563  1.00  6.15           N
ATOM    807  CA  ASP    52      11.970  14.223  14.106  1.00  5.99           C
ATOM    809  CB  ASP    52      12.290  13.888  12.648  1.00  6.83           C
ATOM    812  CG  ASP    52      13.037  12.585  12.472  1.00  8.10           C
ATOM    813  OD1 ASP    52      13.484  11.982  13.468  1.00  8.15           O
ATOM    814  OD2 ASP    52      13.210  12.189  11.298  1.00  8.89           O
ATOM    815  C   ASP    52      11.601  15.697  14.206  1.00  6.29           C
ATOM    816  O   ASP    52      10.491  16.107  13.839  1.00  6.95           O
ATOM    818  N   ARG    53      12.550  16.500  14.650  1.00  5.25           N
ATOM    819  CA  ARG    53      12.408  17.938  14.683  1.00  4.99           C
ATOM    821  CB  ARG    53      13.041  18.529  15.935  1.00  6.14           C
ATOM    824  CG  ARG    53      12.863  20.012  16.008  1.00  7.50           C
ATOM    827  CD  ARG    53      13.501  20.585  17.212  1.00  8.27           C
ATOM    830  NE  ARG    53      13.318  22.031  17.331  1.00  8.88           N
ATOM    832  CZ  ARG    53      13.737  22.686  18.396  1.00 11.23           C
ATOM    833  NH1 ARG    53      14.346  22.016  19.366  1.00 16.53           N
ATOM    836  NH2 ARG    53      13.543  23.977  18.514  1.00 13.37           N
ATOM    839  C   ARG    53      13.100  18.513  13.447  1.00  4.96           C
ATOM    840  O   ARG    53      14.246  18.205  13.173  1.00  6.86           O
ATOM    842  N   VAL    54      12.379  19.326  12.678  1.00  5.73           N
ATOM    843  CA  VAL    54      12.946  19.961  11.493  1.00  6.02           C
ATOM    845  CB  VAL    54      11.865  20.242  10.411  1.00  6.77           C
ATOM    847  CG1 VAL    54      12.525  20.854   9.177  1.00  7.75           C
ATOM    851  CG2 VAL    54      11.100  18.960  10.023  1.00  9.25           C
ATOM    855  C   VAL    54      13.643  21.257  11.915  1.00  5.20           C
ATOM    856  O   VAL    54      12.992  22.215  12.306  1.00  6.89           O
ATOM    858  N   LEU    55      14.971  21.250  11.874  1.00  4.90           N
ATOM    859  CA  LEU    55      15.774  22.399  12.259  1.00  5.97           C
ATOM    861  CB  LEU    55      17.164  21.952  12.706  1.00  6.50           C
ATOM    864  CG  LEU    55      17.211  21.067  13.939  1.00  7.90           C
ATOM    866  CD1 LEU    55      18.665  20.650  14.173  1.00 10.54           C
ATOM    870  CD2 LEU    55      16.639  21.761  15.161  1.00 12.65           C
ATOM    874  C   LEU    55      15.917  23.418  11.129  1.00  5.73           C
ATOM    875  O   LEU    55      16.055  24.599  11.409  1.00  6.02           O
ATOM    877  N   ALA    56      15.899  22.967   9.877  1.00  4.96           N
ATOM    878  CA  ALA    56      16.078  23.839   8.738  1.00  5.86           C
ATOM    880  CB  ALA    56      17.559  24.243   8.565  1.00  7.39           C
ATOM    884  C   ALA    56      15.613  23.097   7.501  1.00  4.94           C
ATOM    885  O   ALA    56      15.630  21.863   7.462  1.00  5.30           O
ATOM    887  N   ILE    57      15.205  23.857   6.494  1.00  4.78           N
ATOM    888  CA  ILE    57      14.911  23.339   5.159  1.00  5.74           C
ATOM    890  CB  ILE    57      13.401  23.285   4.848  1.00  7.45           C
ATOM    892  CG1 ILE    57      12.699  22.291   5.772  1.00  8.31           C
ATOM    895  CD1 ILE    57      11.186  22.199   5.602  1.00 11.74           C
ATOM    899  CG2 ILE    57      13.155  22.833   3.436  1.00  7.99           C
ATOM    903  C   ILE    57      15.615  24.249   4.162  1.00  5.48           C
ATOM    904  O   ILE    57      15.437  25.465   4.181  1.00  5.95           O
ATOM    906  N   ASN    58      16.488  23.659   3.347  1.00  5.37           N
ATOM    907  CA  ASN    58      17.202  24.406   2.311  1.00  5.56           C
ATOM    909  CB  ASN    58      16.242  24.820   1.190  1.00  6.55           C
ATOM    912  CG  ASN    58      15.844  23.658   0.321  1.00  5.43           C
ATOM    913  OD1 ASN    58      16.462  22.598   0.393  1.00  7.68           O
ATOM    914  ND2 ASN    58      14.804  23.840  -0.499  1.00  9.08           N
ATOM    917  C   ASN    58      17.968  25.593   2.877  1.00  5.61           C
ATOM    918  O   ASN    58      18.065  26.640   2.259  1.00  6.22           O
ATOM    920  N   GLY    59      18.531  25.413   4.066  1.00  7.13           N
ATOM    921  CA  GLY    59      19.286  26.446   4.761  1.00  6.57           C
ATOM    924  C   GLY    59      18.476  27.481   5.496  1.00  6.87           C
ATOM    925  O   GLY    59      19.058  28.366   6.131  1.00 10.12           O
ATOM    927  N   HIS    60      17.151  27.403   5.379  1.00  5.84           N
ATOM    928  CA  HIS    60      16.246  28.308   6.057  1.00  6.38           C
ATOM    930  CB  HIS    60      14.923  28.422   5.291  1.00  7.41           C
ATOM    933  CG  HIS    60      15.059  28.970   3.905  1.00  9.29           C
ATOM    934  ND1 HIS    60      14.673  30.244   3.565  1.00 15.26           N
ATOM    936  CE1 HIS    60      14.916  30.455   2.284  1.00 15.78           C
ATOM    938  NE2 HIS    60      15.439  29.353   1.773  1.00 10.90           N
ATOM    940  CD2 HIS    60      15.508  28.403   2.762  1.00 11.08           C
ATOM    942  C   HIS    60      15.969  27.768   7.456  1.00  6.08           C
ATOM    943  O   HIS    60      15.431  26.677   7.615  1.00  7.61           O
ATOM    945  N   ASP    61      16.284  28.556   8.478  1.00  7.12           N
ATOM    946  CA  ASP    61      16.130  28.131   9.868  1.00  7.26           C
ATOM    948  CB  ASP    61      16.723  29.213  10.787  1.00  9.51           C
ATOM    951  CG  ASP    61      16.625  28.881  12.261  1.00 11.69           C
ATOM    952  OD1 ASP    61      16.644  27.691  12.621  1.00 11.87           O
ATOM    953  OD2 ASP    61      16.534  29.843  13.051  1.00 19.75           O
ATOM    954  C   ASP    61      14.659  27.919  10.218  1.00  7.26           C
ATOM    955  O   ASP    61      13.821  28.778   9.948  1.00  9.44           O
ATOM    957  N   LEU    62      14.365  26.784  10.844  1.00  6.81           N
ATOM    958  CA  LEU    62      13.042  26.461  11.358  1.00  7.03           C
ATOM    960  CB  LEU    62      12.435  25.351  10.511  1.00  8.04           C
ATOM    963  CG  LEU    62      11.842  25.803   9.173  1.00  9.58           C
ATOM    965  CD1 LEU    62      11.547  24.580   8.318  1.00 14.23           C
ATOM    969  CD2 LEU    62      10.558  26.562   9.377  1.00 11.51           C
ATOM    973  C   LEU    62      13.065  26.067  12.836  1.00  6.56           C
ATOM    974  O   LEU    62      12.072  25.571  13.367  1.00  7.03           O
ATOM    976  N   LYS    63      14.176  26.298  13.525  1.00  6.57           N
ATOM    977  CA  LYS    63      14.275  25.871  14.918  1.00  7.54           C
ATOM    979  CB  LYS    63      15.603  26.320  15.527  1.00  9.50           C
ATOM    982  CG  LYS    63      15.877  25.737  16.905  1.00 14.00           C
ATOM    985  CD  LYS    63      17.286  25.997  17.394  1.00 18.24           C
ATOM    988  CE  LYS    63      17.444  25.472  18.815  1.00 23.48           C
ATOM    992  C   LYS    63      13.103  26.393  15.750  1.00  6.86           C
ATOM    993  O   LYS    63      12.524  25.652  16.546  1.00  7.88           O
ATOM    995  N   TYR    64      12.751  27.663  15.566  1.00  7.48           N
ATOM    996  CA  TYR    64      11.624  28.256  16.273  1.00  8.17           C
ATOM    998  CB  TYR    64      12.093  29.470  17.089  1.00 11.09           C
ATOM   1001  CG  TYR    64      13.152  29.097  18.092  1.00 11.97           C
ATOM   1002  CD1 TYR    64      12.812  28.444  19.262  1.00 14.21           C
ATOM   1004  CE1 TYR    64      13.775  28.061  20.178  1.00 17.55           C
ATOM   1006  CZ  TYR    64      15.099  28.298  19.905  1.00 20.25           C
ATOM   1007  OH  TYR    64      16.053  27.918  20.816  1.00 26.55           O
ATOM   1009  CE2 TYR    64      15.471  28.924  18.736  1.00 20.96           C
ATOM   1011  CD2 TYR    64      14.501  29.305  17.825  1.00 15.02           C
ATOM   1013  C   TYR    64      10.497  28.626  15.316  1.00  8.44           C
ATOM   1014  O   TYR    64       9.719  29.543  15.565  1.00 11.33           O
ATOM   1016  N   GLY    65      10.391  27.868  14.226  1.00  7.80           N
ATOM   1017  CA  GLY    65       9.456  28.141  13.163  1.00  8.27           C
ATOM   1020  C   GLY    65       8.106  27.507  13.394  1.00  7.91           C
ATOM   1021  O   GLY    65       7.804  27.015  14.472  1.00  7.59           O
ATOM   1023  N   THR    66       7.300  27.515  12.346  1.00  9.49           N
ATOM   1024  CA  THR    66       5.936  27.018  12.364  1.00  9.40           C
ATOM   1026  CB  THR    66       4.949  28.188  12.187  1.00  9.92           C
ATOM   1028  OG1 THR    66       5.184  28.803  10.915  1.00 12.44           O
ATOM   1030  CG2 THR    66       5.102  29.213  13.287  1.00 13.80           C
ATOM   1034  C   THR    66       5.689  26.091  11.183  1.00  9.04           C
ATOM   1035  O   THR    66       6.401  26.156  10.182  1.00  8.82           O
ATOM   1037  N   PRO    67       4.658  25.244  11.275  1.00  9.53           N
ATOM   1038  CA  PRO    67       4.247  24.481  10.100  1.00  8.74           C
ATOM   1040  CB  PRO    67       2.977  23.778  10.578  1.00 10.07           C
ATOM   1043  CG  PRO    67       3.200  23.593  12.032  1.00 11.46           C
ATOM   1046  CD  PRO    67       3.906  24.839  12.476  1.00 11.37           C
ATOM   1049  C   PRO    67       3.988  25.364   8.877  1.00  9.67           C
ATOM   1050  O   PRO    67       4.337  24.995   7.759  1.00 10.04           O
ATOM   1051  N   GLU    68       3.394  26.533   9.096  1.00  9.78           N
ATOM   1052  CA  GLU    68       3.116  27.444   8.001  1.00 11.62           C
ATOM   1054  CB  GLU    68       2.371  28.680   8.504  1.00 15.78           C
ATOM   1057  CG  GLU    68       0.939  28.454   8.841  1.00 22.69           C
ATOM   1060  CD  GLU    68       0.730  27.530  10.025  1.00 38.18           C
ATOM   1061  OE1 GLU    68       1.509  27.567  11.019  1.00 30.10           O
ATOM   1062  OE2 GLU    68      -0.241  26.753   9.956  1.00 46.84           O
ATOM   1063  C   GLU    68       4.362  27.913   7.288  1.00 10.80           C
ATOM   1064  O   GLU    68       4.391  27.980   6.050  1.00 13.59           O
ATOM   1066  N   LEU    69       5.377  28.283   8.060  1.00 10.10           N
ATOM   1067  CA  LEU    69       6.635  28.728   7.469  1.00 10.16           C
ATOM   1069  CB  LEU    69       7.557  29.283   8.549  1.00 13.39           C
ATOM   1072  CG  LEU    69       8.913  29.806   8.085  1.00 13.91           C
ATOM   1074  CD1 LEU    69       8.763  30.875   7.002  1.00 16.82           C
ATOM   1078  CD2 LEU    69       9.710  30.307   9.286  1.00 16.06           C
ATOM   1082  C   LEU    69       7.287  27.576   6.700  1.00  9.38           C
ATOM   1083  O   LEU    69       7.778  27.764   5.595  1.00 10.31           O
ATOM   1085  N   ALA    70       7.282  26.382   7.275  1.00  9.22           N
ATOM   1086  CA  ALA    70       7.801  25.207   6.554  1.00  8.31           C
ATOM   1088  CB  ALA    70       7.687  23.984   7.411  1.00  9.24           C
ATOM   1092  C   ALA    70       7.056  24.999   5.230  1.00  8.63           C
ATOM   1093  O   ALA    70       7.679  24.743   4.207  1.00  9.95           O
ATOM   1095  N   ALA    71       5.729  25.125   5.262  1.00  9.56           N
ATOM   1096  CA  ALA    71       4.901  24.975   4.076  1.00 10.82           C
ATOM   1098  CB  ALA    71       3.435  25.119   4.431  1.00 12.69           C
ATOM   1102  C   ALA    71       5.282  25.984   3.003  1.00 10.30           C
ATOM   1103  O   ALA    71       5.370  25.639   1.841  1.00 11.75           O
ATOM   1105  N   GLN    72       5.506  27.233   3.406  1.00 11.39           N
ATOM   1106  CA  GLN    72       5.878  28.302   2.476  1.00 12.45           C
ATOM   1108  CB  GLN    72       5.975  29.639   3.207  1.00 15.12           C
ATOM   1111  CG  GLN    72       4.633  30.242   3.569  1.00 26.64           C
ATOM   1114  CD  GLN    72       4.759  31.571   4.300  1.00 41.76           C
ATOM   1115  OE1 GLN    72       5.777  31.860   4.936  1.00 44.64           O
ATOM   1116  NE2 GLN    72       3.713  32.385   4.216  1.00 48.57           N
ATOM   1119  C   GLN    72       7.207  27.962   1.806  1.00 12.12           C
ATOM   1120  O   GLN    72       7.353  28.082   0.581  1.00 12.87           O
ATOM   1122  N   ILE    73       8.179  27.518   2.597  1.00 10.78           N
ATOM   1123  CA  ILE    73       9.494  27.153   2.059  1.00 11.01           C
ATOM   1125  CB  ILE    73      10.495  26.822   3.185  1.00 10.04           C
ATOM   1127  CG1 ILE    73      10.756  28.065   4.042  1.00 12.22           C
ATOM   1130  CD1 ILE    73      11.281  27.733   5.431  1.00 13.45           C
ATOM   1134  CG2 ILE    73      11.806  26.269   2.626  1.00 11.05           C
ATOM   1138  C   ILE    73       9.399  25.976   1.090  1.00  9.44           C
ATOM   1139  O   ILE    73       9.934  26.028  -0.020  1.00 11.21           O
ATOM   1141  N   ILE    74       8.672  24.931   1.481  1.00  9.74           N
ATOM   1142  CA  ILE    74       8.569  23.728   0.661  1.00  9.95           C
ATOM   1144  CB  ILE    74       7.907  22.592   1.429  1.00 10.93           C
ATOM   1146  CG1 ILE    74       8.843  22.115   2.522  1.00 10.18           C
ATOM   1149  CD1 ILE    74       8.119  21.328   3.647  1.00 13.36           C
ATOM   1153  CG2 ILE    74       7.582  21.426   0.509  1.00 12.72           C
ATOM   1157  C   ILE    74       7.825  24.010  -0.644  1.00 11.91           C
ATOM   1158  O   ILE    74       8.246  23.557  -1.726  1.00 13.89           O
ATOM   1160  N   GLN    75       6.741  24.780  -0.564  1.00 12.93           N
ATOM   1161  CA  GLN    75       5.961  25.074  -1.768  1.00 13.68           C
ATOM   1163  CB  GLN    75       4.657  25.750  -1.402  1.00 16.16           C
ATOM   1166  CG  GLN    75       3.669  24.773  -0.769  1.00 18.38           C
ATOM   1169  CD  GLN    75       2.441  25.471  -0.235  1.00 26.27           C
ATOM   1170  OE1 GLN    75       2.313  26.691  -0.338  1.00 34.21           O
ATOM   1171  NE2 GLN    75       1.530  24.705   0.337  1.00 29.94           N
ATOM   1174  C   GLN    75       6.746  25.917  -2.773  1.00 13.60           C
ATOM   1175  O   GLN    75       6.574  25.734  -3.965  1.00 17.87           O
ATOM   1177  N   ALA    76       7.609  26.812  -2.296  1.00 10.43           N
ATOM   1178  CA  ALA    76       8.437  27.639  -3.166  1.00 11.32           C
ATOM   1180  CB  ALA    76       8.707  28.987  -2.509  1.00 13.58           C
ATOM   1184  C   ALA    76       9.748  26.982  -3.584  1.00 11.10           C
ATOM   1185  O   ALA    76      10.468  27.561  -4.377  1.00 13.90           O
ATOM   1187  N   SER    77      10.065  25.793  -3.059  1.00  9.06           N
ATOM   1188  CA  SER    77      11.372  25.165  -3.256  1.00  9.49           C
ATOM   1190  CB  SER    77      11.469  23.906  -2.429  0.50  9.76           C
ATOM   1196  OG  SER    77      10.601  22.959  -2.991  0.50 13.23           O
ATOM   1200  C   SER    77      11.592  24.786  -4.692  1.00 10.15           C
ATOM   1201  O   SER    77      10.639  24.562  -5.437  1.00 14.75           O
ATOM   1203  N   GLY    78      12.861  24.707  -5.079  1.00  7.78           N
ATOM   1204  CA  GLY    78      13.221  24.044  -6.296  1.00  9.54           C
ATOM   1207  C   GLY    78      13.129  22.543  -6.113  1.00  8.94           C
ATOM   1208  O   GLY    78      12.615  22.045  -5.120  1.00 10.77           O
ATOM   1210  N   GLU    79      13.674  21.791  -7.049  1.00  9.79           N
ATOM   1211  CA  GLU    79      13.501  20.344  -7.016  1.00  9.89           C
ATOM   1213  CB  GLU    79      13.953  19.685  -8.320  1.00 16.21           C
ATOM   1216  CG  GLU    79      15.398  19.861  -8.639  1.00 16.42           C
ATOM   1219  CD  GLU    79      16.323  18.856  -7.970  1.00 22.12           C
ATOM   1220  OE1 GLU    79      15.852  17.773  -7.589  1.00 22.98           O
ATOM   1221  OE2 GLU    79      17.531  19.158  -7.834  1.00 30.49           O
ATOM   1222  C   GLU    79      14.129  19.674  -5.794  1.00  9.48           C
ATOM   1223  O   GLU    79      13.577  18.718  -5.290  1.00 11.29           O
ATOM   1225  N   ARG    80      15.251  20.178  -5.304  1.00  8.87           N
ATOM   1226  CA  ARG    80      15.911  19.591  -4.148  1.00  8.68           C
ATOM   1228  CB  ARG    80      17.430  19.716  -4.256  1.00 11.07           C
ATOM   1231  CG  ARG    80      18.176  19.033  -3.108  1.00 13.32           C
ATOM   1234  CD  ARG    80      19.682  19.112  -3.324  1.00 24.79           C
ATOM   1237  NE  ARG    80      20.448  18.479  -2.245  1.00 27.84           N
ATOM   1239  CZ  ARG    80      20.993  19.118  -1.207  1.00 36.19           C
ATOM   1240  NH1 ARG    80      20.863  20.433  -1.054  1.00 33.72           N
ATOM   1243  NH2 ARG    80      21.671  18.426  -0.295  1.00 41.41           N
ATOM   1246  C   ARG    80      15.411  20.246  -2.878  1.00  8.11           C
ATOM   1247  O   ARG    80      15.445  21.473  -2.722  1.00  9.37           O
ATOM   1249  N   VAL    81      14.959  19.401  -1.963  1.00  6.86           N
ATOM   1250  CA  VAL    81      14.513  19.835  -0.643  1.00  6.31           C
ATOM   1252  CB  VAL    81      13.028  19.562  -0.396  1.00  7.85           C
ATOM   1254  CG1 VAL    81      12.610  20.149   0.932  1.00  9.26           C
ATOM   1258  CG2 VAL    81      12.177  20.137  -1.532  1.00 10.85           C
ATOM   1262  C   VAL    81      15.382  19.116   0.383  1.00  6.33           C
ATOM   1263  O   VAL    81      15.236  17.909   0.611  1.00  8.05           O
ATOM   1265  N   ASN    82      16.280  19.870   0.997  1.00  5.57           N
ATOM   1266  CA  ASN    82      17.158  19.331   2.032  1.00  5.84           C
ATOM   1268  CB  ASN    82      18.579  19.900   1.896  1.00  8.13           C
ATOM   1271  CG  ASN    82      19.516  19.209   2.822  1.00 12.01           C
ATOM   1272  OD1 ASN    82      19.750  18.001   2.675  1.00 16.43           O
ATOM   1273  ND2 ASN    82      19.968  19.910   3.861  1.00 16.19           N
ATOM   1276  C   ASN    82      16.603  19.693   3.400  1.00  5.43           C
ATOM   1277  O   ASN    82      16.397  20.860   3.676  1.00  9.69           O
ATOM   1279  N   LEU    83      16.354  18.700   4.242  1.00  5.52           N
ATOM   1280  CA  LEU    83      15.875  18.917   5.599  1.00  5.39           C
ATOM   1282  CB  LEU    83      14.653  18.038   5.889  1.00  6.63           C
ATOM   1285  CG  LEU    83      13.448  18.253   4.967  1.00  7.62           C
ATOM   1287  CD1 LEU    83      13.437  17.282   3.780  1.00 10.23           C
ATOM   1291  CD2 LEU    83      12.167  18.112   5.799  1.00 11.84           C
ATOM   1295  C   LEU    83      16.980  18.565   6.561  1.00  5.82           C
ATOM   1296  O   LEU    83      17.545  17.489   6.480  1.00  8.00           O
ATOM   1298  N   THR    84      17.279  19.480   7.477  1.00  5.80           N
ATOM   1299  CA  THR    84      18.161  19.195   8.594  1.00  5.83           C
ATOM   1301  CB  THR    84      19.072  20.384   8.934  1.00  7.22           C
ATOM   1303  OG1 THR    84      19.806  20.767   7.757  1.00 11.03           O
ATOM   1305  CG2 THR    84      20.050  20.060  10.048  1.00  9.42           C
ATOM   1309  C   THR    84      17.285  18.858   9.778  1.00  5.81           C
ATOM   1310  O   THR    84      16.420  19.644  10.181  1.00  6.34           O
ATOM   1312  N   ILE    85      17.508  17.664  10.320  1.00  4.76           N
ATOM   1313  CA  ILE    85      16.683  17.063  11.339  1.00  6.86           C
ATOM   1315  CB  ILE    85      16.266  15.653  10.761  1.00 14.19           C
ATOM   1317  CG1 ILE    85      15.517  15.810   9.448  1.00 13.77           C
ATOM   1320  CD1 ILE    85      14.351  16.566   9.612  1.00 10.45           C
ATOM   1324  CG2 ILE    85      15.551  14.836  11.763  1.00 17.42           C
ATOM   1328  C   ILE    85      17.431  16.795  12.632  1.00  6.23           C
ATOM   1329  O   ILE    85      18.594  16.410  12.577  1.00  6.95           O
ATOM   1331  N   ALA    86      16.739  16.976  13.757  1.00  6.25           N
ATOM   1332  CA  ALA    86      17.190  16.463  15.050  1.00  6.59           C
ATOM   1334  CB  ALA    86      17.200  17.563  16.105  1.00  8.55           C
ATOM   1338  C   ALA    86      16.266  15.319  15.464  1.00  6.81           C
ATOM   1339  O   ALA    86      15.051  15.490  15.528  1.00  8.22           O
ATOM   1341  N   ARG    87      16.864  14.166  15.753  1.00  7.51           N
ATOM   1342  CA  ARG    87      16.141  12.966  16.135  1.00  8.14           C
ATOM   1344  CB  ARG    87      16.548  11.809  15.238  1.00  8.42           C
ATOM   1347  CG  ARG    87      15.882  10.496  15.579  1.00  9.40           C
ATOM   1350  CD  ARG    87      16.088   9.500  14.466  1.00 10.06           C
ATOM   1353  NE  ARG    87      15.444   9.990  13.256  1.00  8.90           N
ATOM   1355  CZ  ARG    87      15.734   9.569  12.031  1.00 11.27           C
ATOM   1356  NH1 ARG    87      16.620   8.604  11.820  1.00 12.83           N
ATOM   1359  NH2 ARG    87      15.145  10.122  11.007  1.00 11.16           N
ATOM   1362  C   ARG    87      16.500  12.689  17.593  1.00  7.99           C
ATOM   1363  O   ARG    87      17.564  12.158  17.886  1.00  8.23           O
ATOM   1365  N   PRO    88      15.638  13.098  18.531  1.00 10.73           N
ATOM   1366  CA  PRO    88      16.030  12.918  19.925  1.00 10.69           C
ATOM   1368  CB  PRO    88      15.102  13.869  20.685  1.00 14.27           C
ATOM   1371  CG  PRO    88      14.609  14.838  19.670  1.00 18.94           C
ATOM   1374  CD  PRO    88      14.509  14.034  18.416  1.00 14.24           C
ATOM   1377  C   PRO    88      15.854  11.499  20.425  1.00 10.66           C
ATOM   1378  O   PRO    88      15.081  10.700  19.871  1.00 14.66           O
ATOM   1379  N   GLY    89      16.590  11.193  21.476  1.00 10.65           N
ATOM   1380  CA  GLY    89      16.292  10.059  22.300  1.00 14.39           C
ATOM   1383  C   GLY    89      16.821   8.730  21.823  1.00 12.94           C
ATOM   1384  O   GLY    89      17.450   8.599  20.778  1.00 16.65           O
ATOM   1386  N   LYS    90      16.595   7.725  22.648  1.00 13.32           N
ATOM   1387  CA  LYS    90      17.063   6.385  22.376  1.00 11.77           C
ATOM   1389  CB  LYS    90      17.224   5.631  23.701  1.00 13.46           C
ATOM   1392  CG  LYS    90      18.208   6.274  24.672  1.00 15.32           C
ATOM   1395  CD  LYS    90      18.301   5.467  25.954  1.00 14.96           C
ATOM   1398  CE  LYS    90      19.261   6.115  26.964  1.00 15.66           C
ATOM   1401  NZ  LYS    90      19.404   5.284  28.187  1.00 22.41           N
ATOM   1405  C   LYS    90      16.058   5.637  21.500  1.00 10.89           C
ATOM   1406  O   LYS    90      14.853   5.785  21.671  1.00 14.13           O
ATOM   1408  N   PRO    91      16.552   4.802  20.591  1.00  9.91           N
ATOM   1409  CA  PRO    91      15.651   4.023  19.745  1.00 12.24           C
ATOM   1411  CB  PRO    91      16.556   3.534  18.608  1.00 15.51           C
ATOM   1414  CG  PRO    91      17.917   3.641  19.116  1.00 15.26           C
ATOM   1417  CD  PRO    91      17.936   4.756  20.099  1.00 12.95           C
ATOM   1420  C   PRO    91      15.025   2.841  20.462  1.00  9.07           C
ATOM   1421  O   PRO    91      14.020   2.324  20.007  1.00  9.13           O
ATOM   1422  N   GLU    92      15.643   2.418  21.560  1.00  7.37           N
ATOM   1423  CA  GLU    92      15.206   1.255  22.324  1.00  7.95           C
ATOM   1425  CB  GLU    92      16.009  -0.003  21.975  1.00 10.27           C
ATOM   1428  CG  GLU    92      15.660  -1.161  22.901  1.00 14.89           C
ATOM   1431  CD  GLU    92      16.260  -2.480  22.466  1.00 18.63           C
ATOM   1432  OE1 GLU    92      17.066  -2.497  21.502  1.00 29.25           O
ATOM   1433  OE2 GLU    92      15.921  -3.515  23.099  1.00 20.57           O
ATOM   1434  C   GLU    92      15.405   1.564  23.788  1.00  8.05           C
ATOM   1435  O   GLU    92      16.476   2.010  24.200  1.00  9.27           O
ATOM   1437  N   ILE    93      14.387   1.273  24.590  1.00  8.17           N
ATOM   1438  CA  ILE    93      14.469   1.437  26.046  1.00  8.79           C
ATOM   1440  CB  ILE    93      13.775   2.735  26.554  1.00  9.36           C
ATOM   1442  CG1 ILE    93      14.392   3.978  25.905  1.00 12.22           C
ATOM   1445  CD1 ILE    93      13.736   5.273  26.334  1.00 14.74           C
ATOM   1449  CG2 ILE    93      13.850   2.873  28.091  1.00 13.41           C
ATOM   1453  C   ILE    93      13.839   0.215  26.685  1.00  8.69           C
ATOM   1454  O   ILE    93      12.716  -0.158  26.382  1.00  8.14           O
ATOM   1456  N   GLU    94      14.587  -0.408  27.588  1.00  8.99           N
ATOM   1457  CA  GLU    94      14.057  -1.493  28.389  1.00  8.22           C
ATOM   1459  CB  GLU    94      15.122  -2.569  28.575  1.00 11.04           C
ATOM   1462  CG  GLU    94      15.738  -2.924  27.220  1.00 16.67           C
ATOM   1465  CD  GLU    94      16.767  -4.011  27.276  1.00 16.35           C
ATOM   1466  OE1 GLU    94      16.762  -4.808  28.236  1.00 19.51           O
ATOM   1467  OE2 GLU    94      17.608  -4.048  26.330  1.00 22.62           O
ATOM   1468  C   GLU    94      13.584  -0.886  29.689  1.00  8.96           C
ATOM   1469  O   GLU    94      14.327  -0.151  30.370  1.00 11.67           O
ATOM   1471  N   LEU    95      12.324  -1.163  30.007  1.00 11.21           N
ATOM   1472  CA  LEU    95      11.677  -0.524  31.139  1.00 14.71           C
ATOM   1474  CB  LEU    95      10.988   0.768  30.675  1.00 20.18           C
ATOM   1477  CG  LEU    95      10.244   0.748  29.337  1.00 20.27           C
ATOM   1479  CD1 LEU    95       9.020  -0.139  29.452  1.00 23.09           C
ATOM   1483  CD2 LEU    95       9.858   2.172  28.859  1.00 23.60           C
ATOM   1487  C   LEU    95      10.696  -1.450  31.825  1.00 17.18           C
ATOM   1488  O   LEU    95      10.717  -2.674  31.585  1.00 14.01           O
ATOM   1490  OXT LEU    95       9.915  -0.965  32.662  1.00 21.45           O
END
