
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  124 ( 1861),  selected  124 , name 2daz_A
# Molecule2: number of CA atoms   95 (  723),  selected   95 , name T0488.pdb
# PARAMETERS: 2daz_A.T0488.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      -       -           -
LGA    S     2_A      -       -           -
LGA    S     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    D     8_A      -       -           -
LGA    A     9_A      -       -           -
LGA    F    10_A      -       -           -
LGA    T    11_A      -       -           -
LGA    D    12_A      -       -           -
LGA    Q    13_A      -       -           -
LGA    K    14_A      -       -           -
LGA    I    15_A      -       -           -
LGA    R    16_A      -       -           -
LGA    Q    17_A      -       -           -
LGA    R    18_A      -       -           -
LGA    Y    19_A      -       -           -
LGA    A    20_A      -       -           -
LGA    D    21_A      -       -           -
LGA    L    22_A      -       -           -
LGA    P    23_A      S       1          2.352
LGA    G    24_A      M       2          0.921
LGA    E    25_A      E       3          0.348
LGA    L    26_A      I       4          0.361
LGA    H    27_A      L       5          1.193
LGA    I    28_A      Q       6          0.521
LGA    I    29_A      V       7          1.384
LGA    E    30_A      A       8          0.731
LGA    L    31_A      L       9          0.696
LGA    E    32_A      H      10          0.646
LGA    K    33_A      K      11          2.195
LGA    D    34_A      R      12          4.682
LGA    K    35_A      D      13          5.054
LGA    -       -      S      14           -
LGA    -       -      G      15           -
LGA    N    36_A      E      16          2.255
LGA    G    37_A      Q      17          2.210
LGA    L    38_A      L      18          1.308
LGA    G    39_A      G      19          1.823
LGA    L    40_A      I      20          0.575
LGA    S    41_A      K      21          0.616
LGA    L    42_A      L      22          0.962
LGA    A    43_A      V      23          1.146
LGA    G    44_A      R      24          1.045
LGA    N    45_A      R      25          1.743
LGA    K    46_A      T      26          2.777
LGA    D    47_A      D      27          2.005
LGA    R    48_A      -       -           -
LGA    S    49_A      -       -           -
LGA    R    50_A      E      28          2.926
LGA    M    51_A      P      29          1.819
LGA    S    52_A      G      30          0.941
LGA    I    53_A      V      31          0.902
LGA    F    54_A      F      32          0.991
LGA    V    55_A      I      33          0.760
LGA    V    56_A      L      34          0.710
LGA    G    57_A      D      35          0.859
LGA    I    58_A      L      36          0.635
LGA    N    59_A      L      37          1.354
LGA    P    60_A      E      38          1.867
LGA    E    61_A      G      39          2.969
LGA    G    62_A      G      40          1.977
LGA    P    63_A      L      41          0.977
LGA    A    64_A      A      42          0.772
LGA    A    65_A      A      43          0.847
LGA    A    66_A      Q      44          0.954
LGA    D    67_A      D      45          0.932
LGA    G    68_A      G      46          1.019
LGA    R    69_A      R      47          1.172
LGA    M    70_A      L      48          0.941
LGA    R    71_A      S      49          1.179
LGA    I    72_A      S      50          1.018
LGA    G    73_A      N      51          1.207
LGA    D    74_A      D      52          0.708
LGA    E    75_A      R      53          0.397
LGA    L    76_A      V      54          0.281
LGA    L    77_A      L      55          0.354
LGA    E    78_A      A      56          0.516
LGA    I    79_A      I      57          0.418
LGA    N    80_A      N      58          0.908
LGA    N    81_A      G      59          1.317
LGA    Q    82_A      H      60          0.194
LGA    I    83_A      D      61          0.247
LGA    L    84_A      L      62          0.724
LGA    Y    85_A      K      63          1.211
LGA    G    86_A      Y      64          1.118
LGA    R    87_A      G      65          1.550
LGA    S    88_A      T      66          1.014
LGA    H    89_A      P      67          1.483
LGA    Q    90_A      E      68          1.635
LGA    N    91_A      L      69          0.971
LGA    A    92_A      A      70          0.575
LGA    S    93_A      A      71          1.598
LGA    A    94_A      Q      72          1.206
LGA    I    95_A      I      73          0.328
LGA    I    96_A      I      74          0.971
LGA    K    97_A      Q      75          0.904
LGA    T    98_A      A      76          0.619
LGA    A    99_A      S      77          0.891
LGA    P   100_A      G      78          0.478
LGA    S   101_A      E      79          0.853
LGA    K   102_A      R      80          0.681
LGA    V   103_A      V      81          1.266
LGA    K   104_A      N      82          1.058
LGA    L   105_A      L      83          0.735
LGA    V   106_A      T      84          0.316
LGA    F   107_A      I      85          0.519
LGA    I   108_A      A      86          1.127
LGA    R   109_A      R      87          1.320
LGA    N   110_A      P      88          1.699
LGA    E   111_A      G      89          3.428
LGA    D   112_A      K      90          6.555
LGA    A   113_A      P      91           -
LGA    V   114_A      E      92           -
LGA    N   115_A      I      93           -
LGA    Q   116_A      E      94           -
LGA    M   117_A      L      95           -
LGA    A   118_A      -       -           -
LGA    S   119_A      -       -           -
LGA    G   120_A      -       -           -
LGA    P   121_A      -       -           -
LGA    S   122_A      -       -           -
LGA    S   123_A      -       -           -
LGA    G   124_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  124   95    5.0     88    1.63    28.41     86.768     5.092

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.420231 * X  +  -0.209867 * Y  +   0.882815 * Z  +  12.635233
  Y_new =  -0.227150 * X  +  -0.966242 * Y  +  -0.121573 * Z  +  18.745970
  Z_new =   0.878526 * X  +  -0.149443 * Y  +  -0.453716 * Z  +   9.274071 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.823409    0.318183  [ DEG:  -161.7694     18.2306 ]
  Theta =  -1.072768   -2.068824  [ DEG:   -61.4651   -118.5349 ]
  Phi   =  -0.495548    2.646045  [ DEG:   -28.3928    151.6072 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2daz_A                                        
REMARK     2: T0488.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2daz_A.T0488.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  124   95   5.0   88   1.63   28.41  86.768
REMARK  ---------------------------------------------------------- 
MOLECULE 2daz_A
HEADER    PROTEIN BINDING                         14-DEC-05   2DAZ              
TITLE     SOLUTION STRUCTURE OF THE 7TH PDZ DOMAIN OF INAD-LIKE                 
TITLE    2 PROTEIN                                                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: INAD-LIKE PROTEIN;                                         
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: PDZ DOMAIN;                                                
COMPND   5 SYNONYM: INADL PROTEIN, HINADL, PALS1-ASSOCIATED TIGHT               
COMPND   6 JUNCTION PROTEIN, PROTEIN ASSOCIATED TO TIGHT JUNCTIONS;             
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: INADL, PATJ;                                                   
SOURCE   5 EXPRESSION_SYSTEM: CELL FREE SYNTHESIS;                              
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: P050302-33;                               
SOURCE   8 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    PDZ DOMAIN, INAD-LIKE PROTEIN, INADL PROTEIN, HINADL, PALS1-          
KEYWDS   2 ASSOCIATED TIGHT JUNCTION PROTEIN, PROTEIN ASSOCIATED TO             
KEYWDS   3 TIGHT JUNCTIONS, INADL, PATJ , STRUCTURAL GENOMICS, NPPSFA,          
KEYWDS   4 NATIONAL PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL                
KEYWDS   5 ANALYSES, RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE,           
KEYWDS   6 RSGI                                                                 
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    K.INOUE,T.NAGASHIMA,K.IZUMI,F.HAYASHI,S.YOKOYAMA,RIKEN                
AUTHOR   2 STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE (RSGI)                     
REVDAT   1   14-JUN-06 2DAZ    0                                                
JRNL        AUTH   K.INOUE,T.NAGASHIMA,K.IZUMI,F.HAYASHI,S.YOKOYAMA             
JRNL        TITL   SOLUTION STRUCTURE OF THE 7TH PDZ DOMAIN OF                  
JRNL        TITL 2 INAD-LIKE PROTEIN                                            
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2DAZ A    8   118  UNP    Q8NI35   INADL_HUMAN   1219   1329             
SEQRES   1 A  124  GLY SER SER GLY SER SER GLY ASP ALA PHE THR ASP GLN          
SEQRES   2 A  124  LYS ILE ARG GLN ARG TYR ALA ASP LEU PRO GLY GLU LEU          
SEQRES   3 A  124  HIS ILE ILE GLU LEU GLU LYS ASP LYS ASN GLY LEU GLY          
SEQRES   4 A  124  LEU SER LEU ALA GLY ASN LYS ASP ARG SER ARG MET SER          
SEQRES   5 A  124  ILE PHE VAL VAL GLY ILE ASN PRO GLU GLY PRO ALA ALA          
SEQRES   6 A  124  ALA ASP GLY ARG MET ARG ILE GLY ASP GLU LEU LEU GLU          
SEQRES   7 A  124  ILE ASN ASN GLN ILE LEU TYR GLY ARG SER HIS GLN ASN          
SEQRES   8 A  124  ALA SER ALA ILE ILE LYS THR ALA PRO SER LYS VAL LYS          
SEQRES   9 A  124  LEU VAL PHE ILE ARG ASN GLU ASP ALA VAL ASN GLN MET          
SEQRES  10 A  124  ALA SER GLY PRO SER SER GLY                                  
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      35.006  41.117  -6.861  1.00  0.00           N  
ATOM      2  CA  GLY A   1      35.587  39.991  -7.569  1.00  0.00           C  
ATOM      3  C   GLY A   1      34.816  38.706  -7.347  1.00  0.00           C  
ATOM      4  O   GLY A   1      35.205  37.874  -6.527  1.00  0.00           O  
ATOM      5  HA2 GLY A   1      35.601  40.213  -8.626  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      36.602  39.852  -7.228  1.00  0.00           H  
ATOM      7  H1  GLY A   1      35.588  41.800  -6.468  1.00  0.00           H  
ATOM      8  N   SER A   2      33.718  38.543  -8.077  1.00  0.00           N  
ATOM      9  CA  SER A   2      32.886  37.351  -7.952  1.00  0.00           C  
ATOM     10  C   SER A   2      32.569  37.062  -6.489  1.00  0.00           C  
ATOM     11  O   SER A   2      32.596  35.911  -6.052  1.00  0.00           O  
ATOM     12  CB  SER A   2      33.587  36.146  -8.582  1.00  0.00           C  
ATOM     13  OG  SER A   2      33.645  36.269  -9.993  1.00  0.00           O  
ATOM     14  H   SER A   2      33.459  39.242  -8.714  1.00  0.00           H  
ATOM     15  HA  SER A   2      31.962  37.534  -8.480  1.00  0.00           H  
ATOM     16  HB2 SER A   2      34.594  36.077  -8.198  1.00  0.00           H  
ATOM     17  HB3 SER A   2      33.045  35.246  -8.332  1.00  0.00           H  
ATOM     18  HG  SER A   2      33.207  35.515 -10.397  1.00  0.00           H  
ATOM     19  N   SER A   3      32.267  38.115  -5.736  1.00  0.00           N  
ATOM     20  CA  SER A   3      31.949  37.975  -4.319  1.00  0.00           C  
ATOM     21  C   SER A   3      30.792  38.892  -3.931  1.00  0.00           C  
ATOM     22  O   SER A   3      30.789  40.078  -4.256  1.00  0.00           O  
ATOM     23  CB  SER A   3      33.177  38.295  -3.464  1.00  0.00           C  
ATOM     24  OG  SER A   3      33.472  39.680  -3.493  1.00  0.00           O  
ATOM     25  H   SER A   3      32.263  39.006  -6.142  1.00  0.00           H  
ATOM     26  HA  SER A   3      31.655  36.951  -4.144  1.00  0.00           H  
ATOM     27  HB2 SER A   3      32.988  38.000  -2.443  1.00  0.00           H  
ATOM     28  HB3 SER A   3      34.028  37.748  -3.845  1.00  0.00           H  
ATOM     29  HG  SER A   3      34.386  39.818  -3.234  1.00  0.00           H  
ATOM     30  N   GLY A   4      29.810  38.330  -3.232  1.00  0.00           N  
ATOM     31  CA  GLY A   4      28.660  39.109  -2.810  1.00  0.00           C  
ATOM     32  C   GLY A   4      28.322  38.899  -1.348  1.00  0.00           C  
ATOM     33  O   GLY A   4      29.147  39.158  -0.470  1.00  0.00           O  
ATOM     34  H   GLY A   4      29.866  37.379  -3.001  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      28.869  40.156  -2.974  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      27.808  38.825  -3.409  1.00  0.00           H  
ATOM     37  N   SER A   5      27.107  38.431  -1.083  1.00  0.00           N  
ATOM     38  CA  SER A   5      26.661  38.191   0.284  1.00  0.00           C  
ATOM     39  C   SER A   5      27.333  36.953   0.866  1.00  0.00           C  
ATOM     40  O   SER A   5      26.973  35.823   0.533  1.00  0.00           O  
ATOM     41  CB  SER A   5      25.140  38.028   0.325  1.00  0.00           C  
ATOM     42  OG  SER A   5      24.630  38.317   1.616  1.00  0.00           O  
ATOM     43  H   SER A   5      26.495  38.244  -1.827  1.00  0.00           H  
ATOM     44  HA  SER A   5      26.938  39.049   0.878  1.00  0.00           H  
ATOM     45  HB2 SER A   5      24.689  38.703  -0.387  1.00  0.00           H  
ATOM     46  HB3 SER A   5      24.883  37.010   0.068  1.00  0.00           H  
ATOM     47  HG  SER A   5      24.930  37.648   2.235  1.00  0.00           H  
ATOM     48  N   SER A   6      28.312  37.172   1.737  1.00  0.00           N  
ATOM     49  CA  SER A   6      29.038  36.073   2.363  1.00  0.00           C  
ATOM     50  C   SER A   6      28.328  35.605   3.630  1.00  0.00           C  
ATOM     51  O   SER A   6      27.638  36.379   4.291  1.00  0.00           O  
ATOM     52  CB  SER A   6      30.468  36.504   2.697  1.00  0.00           C  
ATOM     53  OG  SER A   6      31.171  36.889   1.528  1.00  0.00           O  
ATOM     54  H   SER A   6      28.554  38.095   1.963  1.00  0.00           H  
ATOM     55  HA  SER A   6      29.073  35.255   1.661  1.00  0.00           H  
ATOM     56  HB2 SER A   6      30.440  37.341   3.378  1.00  0.00           H  
ATOM     57  HB3 SER A   6      30.991  35.680   3.162  1.00  0.00           H  
ATOM     58  HG  SER A   6      32.005  36.415   1.485  1.00  0.00           H  
ATOM     59  N   GLY A   7      28.503  34.330   3.962  1.00  0.00           N  
ATOM     60  CA  GLY A   7      27.874  33.778   5.147  1.00  0.00           C  
ATOM     61  C   GLY A   7      27.926  32.263   5.181  1.00  0.00           C  
ATOM     62  O   GLY A   7      26.987  31.594   4.751  1.00  0.00           O  
ATOM     63  H   GLY A   7      29.065  33.758   3.398  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      28.376  34.164   6.021  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      26.841  34.091   5.171  1.00  0.00           H  
ATOM     66  N   ASP A   8      29.027  31.722   5.690  1.00  0.00           N  
ATOM     67  CA  ASP A   8      29.198  30.277   5.777  1.00  0.00           C  
ATOM     68  C   ASP A   8      28.649  29.742   7.096  1.00  0.00           C  
ATOM     69  O   ASP A   8      29.246  28.864   7.718  1.00  0.00           O  
ATOM     70  CB  ASP A   8      30.676  29.908   5.639  1.00  0.00           C  
ATOM     71  CG  ASP A   8      31.301  30.479   4.381  1.00  0.00           C  
ATOM     72  OD1 ASP A   8      31.211  31.709   4.180  1.00  0.00           O  
ATOM     73  OD2 ASP A   8      31.879  29.696   3.597  1.00  0.00           O  
ATOM     74  H   ASP A   8      29.741  32.309   6.016  1.00  0.00           H  
ATOM     75  HA  ASP A   8      28.648  29.828   4.964  1.00  0.00           H  
ATOM     76  HB2 ASP A   8      31.217  30.290   6.493  1.00  0.00           H  
ATOM     77  HB3 ASP A   8      30.771  28.832   5.610  1.00  0.00           H  
ATOM     78  N   ALA A   9      27.509  30.279   7.517  1.00  0.00           N  
ATOM     79  CA  ALA A   9      26.878  29.857   8.761  1.00  0.00           C  
ATOM     80  C   ALA A   9      25.894  28.717   8.518  1.00  0.00           C  
ATOM     81  O   ALA A   9      25.361  28.133   9.461  1.00  0.00           O  
ATOM     82  CB  ALA A   9      26.175  31.032   9.423  1.00  0.00           C  
ATOM     83  H   ALA A   9      27.081  30.977   6.977  1.00  0.00           H  
ATOM     84  HA  ALA A   9      27.655  29.511   9.428  1.00  0.00           H  
ATOM     85  HB1 ALA A   9      26.286  30.959  10.495  1.00  0.00           H  
ATOM     86  HB2 ALA A   9      26.615  31.955   9.077  1.00  0.00           H  
ATOM     87  HB3 ALA A   9      25.127  31.014   9.166  1.00  0.00           H  
ATOM     88  N   PHE A  10      25.658  28.406   7.247  1.00  0.00           N  
ATOM     89  CA  PHE A  10      24.736  27.337   6.882  1.00  0.00           C  
ATOM     90  C   PHE A  10      25.497  26.101   6.412  1.00  0.00           C  
ATOM     91  O   PHE A  10      24.915  25.181   5.836  1.00  0.00           O  
ATOM     92  CB  PHE A  10      23.784  27.811   5.782  1.00  0.00           C  
ATOM     93  CG  PHE A  10      22.814  28.862   6.241  1.00  0.00           C  
ATOM     94  CD1 PHE A  10      21.626  28.504   6.858  1.00  0.00           C  
ATOM     95  CD2 PHE A  10      23.089  30.207   6.057  1.00  0.00           C  
ATOM     96  CE1 PHE A  10      20.730  29.468   7.281  1.00  0.00           C  
ATOM     97  CE2 PHE A  10      22.198  31.175   6.478  1.00  0.00           C  
ATOM     98  CZ  PHE A  10      21.018  30.806   7.092  1.00  0.00           C  
ATOM     99  H   PHE A  10      26.114  28.908   6.540  1.00  0.00           H  
ATOM    100  HA  PHE A  10      24.161  27.081   7.758  1.00  0.00           H  
ATOM    101  HB2 PHE A  10      24.361  28.227   4.969  1.00  0.00           H  
ATOM    102  HB3 PHE A  10      23.216  26.968   5.419  1.00  0.00           H  
ATOM    103  HD1 PHE A  10      21.400  27.457   7.007  1.00  0.00           H  
ATOM    104  HD2 PHE A  10      24.013  30.497   5.577  1.00  0.00           H  
ATOM    105  HE1 PHE A  10      19.808  29.176   7.760  1.00  0.00           H  
ATOM    106  HE2 PHE A  10      22.426  32.221   6.329  1.00  0.00           H  
ATOM    107  HZ  PHE A  10      20.320  31.561   7.421  1.00  0.00           H  
ATOM    108  N   THR A  11      26.802  26.085   6.665  1.00  0.00           N  
ATOM    109  CA  THR A  11      27.644  24.962   6.268  1.00  0.00           C  
ATOM    110  C   THR A  11      27.415  23.757   7.172  1.00  0.00           C  
ATOM    111  O   THR A  11      27.279  23.898   8.388  1.00  0.00           O  
ATOM    112  CB  THR A  11      29.137  25.341   6.303  1.00  0.00           C  
ATOM    113  OG1 THR A  11      29.434  26.049   7.510  1.00  0.00           O  
ATOM    114  CG2 THR A  11      29.506  26.198   5.101  1.00  0.00           C  
ATOM    115  H   THR A  11      27.207  26.847   7.128  1.00  0.00           H  
ATOM    116  HA  THR A  11      27.385  24.694   5.254  1.00  0.00           H  
ATOM    117  HB  THR A  11      29.723  24.433   6.271  1.00  0.00           H  
ATOM    118  HG1 THR A  11      30.045  25.532   8.042  1.00  0.00           H  
ATOM    119 HG21 THR A  11      29.278  27.232   5.314  1.00  0.00           H  
ATOM    120 HG22 THR A  11      28.939  25.874   4.240  1.00  0.00           H  
ATOM    121 HG23 THR A  11      30.561  26.096   4.897  1.00  0.00           H  
ATOM    122  N   ASP A  12      27.375  22.573   6.572  1.00  0.00           N  
ATOM    123  CA  ASP A  12      27.165  21.341   7.325  1.00  0.00           C  
ATOM    124  C   ASP A  12      27.933  21.372   8.642  1.00  0.00           C  
ATOM    125  O   ASP A  12      27.348  21.231   9.716  1.00  0.00           O  
ATOM    126  CB  ASP A  12      27.598  20.131   6.495  1.00  0.00           C  
ATOM    127  CG  ASP A  12      28.741  20.454   5.554  1.00  0.00           C  
ATOM    128  OD1 ASP A  12      28.525  21.234   4.602  1.00  0.00           O  
ATOM    129  OD2 ASP A  12      29.853  19.927   5.768  1.00  0.00           O  
ATOM    130  H   ASP A  12      27.490  22.525   5.600  1.00  0.00           H  
ATOM    131  HA  ASP A  12      26.110  21.259   7.540  1.00  0.00           H  
ATOM    132  HB2 ASP A  12      27.916  19.342   7.160  1.00  0.00           H  
ATOM    133  HB3 ASP A  12      26.759  19.786   5.909  1.00  0.00           H  
ATOM    134  N   GLN A  13      29.246  21.554   8.552  1.00  0.00           N  
ATOM    135  CA  GLN A  13      30.095  21.600   9.736  1.00  0.00           C  
ATOM    136  C   GLN A  13      29.487  22.503  10.805  1.00  0.00           C  
ATOM    137  O   GLN A  13      29.513  22.182  11.993  1.00  0.00           O  
ATOM    138  CB  GLN A  13      31.495  22.095   9.369  1.00  0.00           C  
ATOM    139  CG  GLN A  13      31.502  23.464   8.709  1.00  0.00           C  
ATOM    140  CD  GLN A  13      32.893  23.906   8.296  1.00  0.00           C  
ATOM    141  OE1 GLN A  13      33.183  24.055   7.110  1.00  0.00           O  
ATOM    142  NE2 GLN A  13      33.762  24.117   9.278  1.00  0.00           N  
ATOM    143  H   GLN A  13      29.655  21.659   7.667  1.00  0.00           H  
ATOM    144  HA  GLN A  13      30.169  20.598  10.131  1.00  0.00           H  
ATOM    145  HB2 GLN A  13      32.092  22.148  10.266  1.00  0.00           H  
ATOM    146  HB3 GLN A  13      31.945  21.388   8.687  1.00  0.00           H  
ATOM    147  HG2 GLN A  13      30.877  23.429   7.828  1.00  0.00           H  
ATOM    148  HG3 GLN A  13      31.102  24.187   9.404  1.00  0.00           H  
ATOM    149 HE21 GLN A  13      33.461  23.975  10.201  1.00  0.00           H  
ATOM    150 HE22 GLN A  13      34.668  24.402   9.041  1.00  0.00           H  
ATOM    151  N   LYS A  14      28.944  23.637  10.376  1.00  0.00           N  
ATOM    152  CA  LYS A  14      28.329  24.588  11.293  1.00  0.00           C  
ATOM    153  C   LYS A  14      26.961  24.094  11.753  1.00  0.00           C  
ATOM    154  O   LYS A  14      26.556  24.331  12.891  1.00  0.00           O  
ATOM    155  CB  LYS A  14      28.191  25.957  10.625  1.00  0.00           C  
ATOM    156  CG  LYS A  14      29.457  26.794  10.687  1.00  0.00           C  
ATOM    157  CD  LYS A  14      29.586  27.515  12.018  1.00  0.00           C  
ATOM    158  CE  LYS A  14      31.033  27.870  12.321  1.00  0.00           C  
ATOM    159  NZ  LYS A  14      31.735  26.771  13.041  1.00  0.00           N  
ATOM    160  H   LYS A  14      28.955  23.838   9.415  1.00  0.00           H  
ATOM    161  HA  LYS A  14      28.973  24.680  12.156  1.00  0.00           H  
ATOM    162  HB2 LYS A  14      27.929  25.813   9.588  1.00  0.00           H  
ATOM    163  HB3 LYS A  14      27.399  26.505  11.115  1.00  0.00           H  
ATOM    164  HG2 LYS A  14      30.312  26.148  10.555  1.00  0.00           H  
ATOM    165  HG3 LYS A  14      29.433  27.527   9.892  1.00  0.00           H  
ATOM    166  HD2 LYS A  14      29.003  28.424  11.984  1.00  0.00           H  
ATOM    167  HD3 LYS A  14      29.210  26.872  12.802  1.00  0.00           H  
ATOM    168  HE2 LYS A  14      31.545  28.065  11.392  1.00  0.00           H  
ATOM    169  HE3 LYS A  14      31.050  28.759  12.935  1.00  0.00           H  
ATOM    170  HZ1 LYS A  14      31.744  26.963  14.063  1.00  0.00           H  
ATOM    171  HZ2 LYS A  14      32.717  26.694  12.705  1.00  0.00           H  
ATOM    172  HZ3 LYS A  14      31.250  25.867  12.873  1.00  0.00           H  
ATOM    173  N   ILE A  15      26.255  23.407  10.861  1.00  0.00           N  
ATOM    174  CA  ILE A  15      24.933  22.878  11.177  1.00  0.00           C  
ATOM    175  C   ILE A  15      25.014  21.806  12.256  1.00  0.00           C  
ATOM    176  O   ILE A  15      24.278  21.846  13.243  1.00  0.00           O  
ATOM    177  CB  ILE A  15      24.252  22.286   9.929  1.00  0.00           C  
ATOM    178  CG1 ILE A  15      24.059  23.366   8.864  1.00  0.00           C  
ATOM    179  CG2 ILE A  15      22.917  21.658  10.303  1.00  0.00           C  
ATOM    180  CD1 ILE A  15      23.518  22.835   7.555  1.00  0.00           C  
ATOM    181  H   ILE A  15      26.632  23.252   9.970  1.00  0.00           H  
ATOM    182  HA  ILE A  15      24.326  23.695  11.540  1.00  0.00           H  
ATOM    183  HB  ILE A  15      24.889  21.509   9.534  1.00  0.00           H  
ATOM    184 HG12 ILE A  15      23.367  24.107   9.232  1.00  0.00           H  
ATOM    185 HG13 ILE A  15      25.010  23.837   8.663  1.00  0.00           H  
ATOM    186 HG21 ILE A  15      22.876  20.647   9.923  1.00  0.00           H  
ATOM    187 HG22 ILE A  15      22.816  21.642  11.377  1.00  0.00           H  
ATOM    188 HG23 ILE A  15      22.114  22.237   9.873  1.00  0.00           H  
ATOM    189 HD11 ILE A  15      22.894  23.584   7.092  1.00  0.00           H  
ATOM    190 HD12 ILE A  15      24.338  22.592   6.897  1.00  0.00           H  
ATOM    191 HD13 ILE A  15      22.931  21.946   7.742  1.00  0.00           H  
ATOM    192  N   ARG A  16      25.916  20.848  12.066  1.00  0.00           N  
ATOM    193  CA  ARG A  16      26.094  19.763  13.024  1.00  0.00           C  
ATOM    194  C   ARG A  16      26.590  20.299  14.364  1.00  0.00           C  
ATOM    195  O   ARG A  16      26.165  19.838  15.422  1.00  0.00           O  
ATOM    196  CB  ARG A  16      27.080  18.729  12.478  1.00  0.00           C  
ATOM    197  CG  ARG A  16      28.488  19.270  12.293  1.00  0.00           C  
ATOM    198  CD  ARG A  16      29.430  18.199  11.765  1.00  0.00           C  
ATOM    199  NE  ARG A  16      30.826  18.498  12.072  1.00  0.00           N  
ATOM    200  CZ  ARG A  16      31.853  17.864  11.517  1.00  0.00           C  
ATOM    201  NH1 ARG A  16      31.642  16.900  10.631  1.00  0.00           N  
ATOM    202  NH2 ARG A  16      33.095  18.193  11.848  1.00  0.00           N  
ATOM    203  H   ARG A  16      26.473  20.870  11.261  1.00  0.00           H  
ATOM    204  HA  ARG A  16      25.135  19.291  13.172  1.00  0.00           H  
ATOM    205  HB2 ARG A  16      27.125  17.896  13.165  1.00  0.00           H  
ATOM    206  HB3 ARG A  16      26.722  18.379  11.522  1.00  0.00           H  
ATOM    207  HG2 ARG A  16      28.460  20.088  11.589  1.00  0.00           H  
ATOM    208  HG3 ARG A  16      28.856  19.623  13.245  1.00  0.00           H  
ATOM    209  HD2 ARG A  16      29.167  17.253  12.215  1.00  0.00           H  
ATOM    210  HD3 ARG A  16      29.313  18.133  10.694  1.00  0.00           H  
ATOM    211  HE  ARG A  16      31.006  19.205  12.725  1.00  0.00           H  
ATOM    212 HH11 ARG A  16      30.706  16.652  10.378  1.00  0.00           H  
ATOM    213 HH12 ARG A  16      32.416  16.426  10.213  1.00  0.00           H  
ATOM    214 HH21 ARG A  16      33.259  18.918  12.516  1.00  0.00           H  
ATOM    215 HH22 ARG A  16      33.867  17.715  11.430  1.00  0.00           H  
ATOM    216  N   GLN A  17      27.492  21.273  14.309  1.00  0.00           N  
ATOM    217  CA  GLN A  17      28.047  21.870  15.518  1.00  0.00           C  
ATOM    218  C   GLN A  17      27.034  22.798  16.182  1.00  0.00           C  
ATOM    219  O   GLN A  17      27.042  22.971  17.401  1.00  0.00           O  
ATOM    220  CB  GLN A  17      29.326  22.643  15.190  1.00  0.00           C  
ATOM    221  CG  GLN A  17      30.585  21.793  15.262  1.00  0.00           C  
ATOM    222  CD  GLN A  17      31.835  22.621  15.484  1.00  0.00           C  
ATOM    223  OE1 GLN A  17      31.769  23.844  15.614  1.00  0.00           O  
ATOM    224  NE2 GLN A  17      32.985  21.958  15.528  1.00  0.00           N  
ATOM    225  H   GLN A  17      27.792  21.599  13.434  1.00  0.00           H  
ATOM    226  HA  GLN A  17      28.286  21.070  16.202  1.00  0.00           H  
ATOM    227  HB2 GLN A  17      29.244  23.043  14.191  1.00  0.00           H  
ATOM    228  HB3 GLN A  17      29.428  23.459  15.890  1.00  0.00           H  
ATOM    229  HG2 GLN A  17      30.486  21.094  16.080  1.00  0.00           H  
ATOM    230  HG3 GLN A  17      30.690  21.249  14.335  1.00  0.00           H  
ATOM    231 HE21 GLN A  17      32.962  20.984  15.416  1.00  0.00           H  
ATOM    232 HE22 GLN A  17      33.808  22.468  15.669  1.00  0.00           H  
ATOM    233  N   ARG A  18      26.164  23.391  15.372  1.00  0.00           N  
ATOM    234  CA  ARG A  18      25.146  24.303  15.880  1.00  0.00           C  
ATOM    235  C   ARG A  18      24.086  23.545  16.674  1.00  0.00           C  
ATOM    236  O   ARG A  18      23.608  24.021  17.704  1.00  0.00           O  
ATOM    237  CB  ARG A  18      24.489  25.063  14.726  1.00  0.00           C  
ATOM    238  CG  ARG A  18      23.208  25.781  15.121  1.00  0.00           C  
ATOM    239  CD  ARG A  18      22.879  26.906  14.152  1.00  0.00           C  
ATOM    240  NE  ARG A  18      23.968  27.872  14.046  1.00  0.00           N  
ATOM    241  CZ  ARG A  18      23.896  28.985  13.325  1.00  0.00           C  
ATOM    242  NH1 ARG A  18      22.792  29.269  12.648  1.00  0.00           N  
ATOM    243  NH2 ARG A  18      24.930  29.816  13.279  1.00  0.00           N  
ATOM    244  H   ARG A  18      26.208  23.214  14.409  1.00  0.00           H  
ATOM    245  HA  ARG A  18      25.632  25.011  16.536  1.00  0.00           H  
ATOM    246  HB2 ARG A  18      25.186  25.797  14.351  1.00  0.00           H  
ATOM    247  HB3 ARG A  18      24.256  24.363  13.937  1.00  0.00           H  
ATOM    248  HG2 ARG A  18      22.395  25.071  15.121  1.00  0.00           H  
ATOM    249  HG3 ARG A  18      23.329  26.193  16.111  1.00  0.00           H  
ATOM    250  HD2 ARG A  18      22.693  26.480  13.177  1.00  0.00           H  
ATOM    251  HD3 ARG A  18      21.992  27.413  14.499  1.00  0.00           H  
ATOM    252  HE  ARG A  18      24.794  27.682  14.539  1.00  0.00           H  
ATOM    253 HH11 ARG A  18      22.011  28.645  12.681  1.00  0.00           H  
ATOM    254 HH12 ARG A  18      22.739  30.108  12.105  1.00  0.00           H  
ATOM    255 HH21 ARG A  18      25.764  29.606  13.787  1.00  0.00           H  
ATOM    256 HH22 ARG A  18      24.874  30.653  12.734  1.00  0.00           H  
ATOM    257  N   TYR A  19      23.722  22.364  16.187  1.00  0.00           N  
ATOM    258  CA  TYR A  19      22.715  21.542  16.848  1.00  0.00           C  
ATOM    259  C   TYR A  19      23.359  20.339  17.533  1.00  0.00           C  
ATOM    260  O   TYR A  19      22.672  19.408  17.952  1.00  0.00           O  
ATOM    261  CB  TYR A  19      21.669  21.068  15.839  1.00  0.00           C  
ATOM    262  CG  TYR A  19      20.876  22.195  15.215  1.00  0.00           C  
ATOM    263  CD1 TYR A  19      19.931  22.897  15.952  1.00  0.00           C  
ATOM    264  CD2 TYR A  19      21.074  22.558  13.888  1.00  0.00           C  
ATOM    265  CE1 TYR A  19      19.204  23.927  15.386  1.00  0.00           C  
ATOM    266  CE2 TYR A  19      20.353  23.588  13.315  1.00  0.00           C  
ATOM    267  CZ  TYR A  19      19.419  24.268  14.067  1.00  0.00           C  
ATOM    268  OH  TYR A  19      18.698  25.294  13.500  1.00  0.00           O  
ATOM    269  H   TYR A  19      24.138  22.038  15.362  1.00  0.00           H  
ATOM    270  HA  TYR A  19      22.230  22.150  17.597  1.00  0.00           H  
ATOM    271  HB2 TYR A  19      22.162  20.532  15.044  1.00  0.00           H  
ATOM    272  HB3 TYR A  19      20.972  20.408  16.335  1.00  0.00           H  
ATOM    273  HD1 TYR A  19      19.765  22.627  16.985  1.00  0.00           H  
ATOM    274  HD2 TYR A  19      21.807  22.023  13.302  1.00  0.00           H  
ATOM    275  HE1 TYR A  19      18.473  24.460  15.976  1.00  0.00           H  
ATOM    276  HE2 TYR A  19      20.520  23.855  12.282  1.00  0.00           H  
ATOM    277  HH  TYR A  19      19.129  26.131  13.690  1.00  0.00           H  
ATOM    278  N   ALA A  20      24.683  20.368  17.642  1.00  0.00           N  
ATOM    279  CA  ALA A  20      25.420  19.283  18.277  1.00  0.00           C  
ATOM    280  C   ALA A  20      25.051  19.157  19.750  1.00  0.00           C  
ATOM    281  O   ALA A  20      25.268  18.113  20.368  1.00  0.00           O  
ATOM    282  CB  ALA A  20      26.918  19.501  18.122  1.00  0.00           C  
ATOM    283  H   ALA A  20      25.176  21.137  17.288  1.00  0.00           H  
ATOM    284  HA  ALA A  20      25.162  18.362  17.771  1.00  0.00           H  
ATOM    285  HB1 ALA A  20      27.097  20.484  17.711  1.00  0.00           H  
ATOM    286  HB2 ALA A  20      27.395  19.422  19.088  1.00  0.00           H  
ATOM    287  HB3 ALA A  20      27.325  18.753  17.458  1.00  0.00           H  
ATOM    288  N   ASP A  21      24.494  20.225  20.309  1.00  0.00           N  
ATOM    289  CA  ASP A  21      24.094  20.235  21.712  1.00  0.00           C  
ATOM    290  C   ASP A  21      22.854  19.374  21.929  1.00  0.00           C  
ATOM    291  O   ASP A  21      22.660  18.804  23.005  1.00  0.00           O  
ATOM    292  CB  ASP A  21      23.825  21.666  22.178  1.00  0.00           C  
ATOM    293  CG  ASP A  21      25.072  22.527  22.152  1.00  0.00           C  
ATOM    294  OD1 ASP A  21      25.580  22.803  21.045  1.00  0.00           O  
ATOM    295  OD2 ASP A  21      25.540  22.927  23.239  1.00  0.00           O  
ATOM    296  H   ASP A  21      24.347  21.027  19.765  1.00  0.00           H  
ATOM    297  HA  ASP A  21      24.907  19.824  22.291  1.00  0.00           H  
ATOM    298  HB2 ASP A  21      23.086  22.116  21.531  1.00  0.00           H  
ATOM    299  HB3 ASP A  21      23.446  21.642  23.189  1.00  0.00           H  
ATOM    300  N   LEU A  22      22.016  19.283  20.903  1.00  0.00           N  
ATOM    301  CA  LEU A  22      20.793  18.492  20.980  1.00  0.00           C  
ATOM    302  C   LEU A  22      21.100  17.051  21.375  1.00  0.00           C  
ATOM    303  O   LEU A  22      22.174  16.520  21.091  1.00  0.00           O  
ATOM    304  CB  LEU A  22      20.058  18.520  19.640  1.00  0.00           C  
ATOM    305  CG  LEU A  22      19.787  19.905  19.051  1.00  0.00           C  
ATOM    306  CD1 LEU A  22      18.892  19.799  17.826  1.00  0.00           C  
ATOM    307  CD2 LEU A  22      19.159  20.815  20.096  1.00  0.00           C  
ATOM    308  H   LEU A  22      22.224  19.758  20.071  1.00  0.00           H  
ATOM    309  HA  LEU A  22      20.162  18.932  21.737  1.00  0.00           H  
ATOM    310  HB2 LEU A  22      20.649  17.967  18.926  1.00  0.00           H  
ATOM    311  HB3 LEU A  22      19.106  18.025  19.775  1.00  0.00           H  
ATOM    312  HG  LEU A  22      20.725  20.347  18.740  1.00  0.00           H  
ATOM    313 HD11 LEU A  22      17.899  19.504  18.131  1.00  0.00           H  
ATOM    314 HD12 LEU A  22      19.293  19.062  17.148  1.00  0.00           H  
ATOM    315 HD13 LEU A  22      18.846  20.758  17.329  1.00  0.00           H  
ATOM    316 HD21 LEU A  22      18.530  21.544  19.607  1.00  0.00           H  
ATOM    317 HD22 LEU A  22      19.939  21.325  20.644  1.00  0.00           H  
ATOM    318 HD23 LEU A  22      18.567  20.225  20.778  1.00  0.00           H  
ATOM    319  N   PRO A  23      20.135  16.401  22.043  1.00  0.00           N  
ATOM    320  CA  PRO A  23      20.278  15.011  22.487  1.00  0.00           C  
ATOM    321  C   PRO A  23      20.272  14.026  21.323  1.00  0.00           C  
ATOM    322  O   PRO A  23      21.139  13.158  21.227  1.00  0.00           O  
ATOM    323  CB  PRO A  23      19.052  14.795  23.377  1.00  0.00           C  
ATOM    324  CG  PRO A  23      18.047  15.777  22.880  1.00  0.00           C  
ATOM    325  CD  PRO A  23      18.830  16.972  22.414  1.00  0.00           C  
ATOM    326  HA  PRO A  23      21.177  14.873  23.071  1.00  0.00           H  
ATOM    327  HB2 PRO A  23      18.700  13.779  23.269  1.00  0.00           H  
ATOM    328  HB3 PRO A  23      19.312  14.985  24.407  1.00  0.00           H  
ATOM    329  HG2 PRO A  23      17.491  15.350  22.060  1.00  0.00           H  
ATOM    330  HG3 PRO A  23      17.380  16.056  23.683  1.00  0.00           H  
ATOM    331  HD2 PRO A  23      18.351  17.427  21.559  1.00  0.00           H  
ATOM    332  HD3 PRO A  23      18.937  17.689  23.214  1.00  0.00           H  
ATOM    333  N   GLY A  24      19.288  14.168  20.440  1.00  0.00           N  
ATOM    334  CA  GLY A  24      19.188  13.283  19.294  1.00  0.00           C  
ATOM    335  C   GLY A  24      20.404  13.363  18.391  1.00  0.00           C  
ATOM    336  O   GLY A  24      21.430  13.925  18.772  1.00  0.00           O  
ATOM    337  H   GLY A  24      18.625  14.878  20.567  1.00  0.00           H  
ATOM    338  HA2 GLY A  24      19.080  12.268  19.645  1.00  0.00           H  
ATOM    339  HA3 GLY A  24      18.312  13.551  18.722  1.00  0.00           H  
ATOM    340  N   GLU A  25      20.288  12.800  17.192  1.00  0.00           N  
ATOM    341  CA  GLU A  25      21.388  12.809  16.235  1.00  0.00           C  
ATOM    342  C   GLU A  25      20.971  13.489  14.935  1.00  0.00           C  
ATOM    343  O   GLU A  25      20.011  13.074  14.284  1.00  0.00           O  
ATOM    344  CB  GLU A  25      21.857  11.381  15.950  1.00  0.00           C  
ATOM    345  CG  GLU A  25      23.289  11.299  15.452  1.00  0.00           C  
ATOM    346  CD  GLU A  25      24.298  11.240  16.583  1.00  0.00           C  
ATOM    347  OE1 GLU A  25      24.667  12.312  17.106  1.00  0.00           O  
ATOM    348  OE2 GLU A  25      24.718  10.121  16.944  1.00  0.00           O  
ATOM    349  H   GLU A  25      19.443  12.367  16.947  1.00  0.00           H  
ATOM    350  HA  GLU A  25      22.203  13.365  16.673  1.00  0.00           H  
ATOM    351  HB2 GLU A  25      21.779  10.800  16.858  1.00  0.00           H  
ATOM    352  HB3 GLU A  25      21.212  10.947  15.200  1.00  0.00           H  
ATOM    353  HG2 GLU A  25      23.397  10.410  14.847  1.00  0.00           H  
ATOM    354  HG3 GLU A  25      23.498  12.170  14.848  1.00  0.00           H  
ATOM    355  N   LEU A  26      21.699  14.537  14.561  1.00  0.00           N  
ATOM    356  CA  LEU A  26      21.405  15.275  13.339  1.00  0.00           C  
ATOM    357  C   LEU A  26      21.417  14.349  12.126  1.00  0.00           C  
ATOM    358  O   LEU A  26      22.368  13.594  11.918  1.00  0.00           O  
ATOM    359  CB  LEU A  26      22.421  16.402  13.144  1.00  0.00           C  
ATOM    360  CG  LEU A  26      21.969  17.570  12.267  1.00  0.00           C  
ATOM    361  CD1 LEU A  26      21.069  18.510  13.054  1.00  0.00           C  
ATOM    362  CD2 LEU A  26      23.172  18.319  11.714  1.00  0.00           C  
ATOM    363  H   LEU A  26      22.451  14.820  15.121  1.00  0.00           H  
ATOM    364  HA  LEU A  26      20.419  15.704  13.439  1.00  0.00           H  
ATOM    365  HB2 LEU A  26      22.668  16.796  14.117  1.00  0.00           H  
ATOM    366  HB3 LEU A  26      23.306  15.974  12.696  1.00  0.00           H  
ATOM    367  HG  LEU A  26      21.400  17.186  11.432  1.00  0.00           H  
ATOM    368 HD11 LEU A  26      20.727  18.015  13.950  1.00  0.00           H  
ATOM    369 HD12 LEU A  26      20.219  18.786  12.448  1.00  0.00           H  
ATOM    370 HD13 LEU A  26      21.623  19.399  13.321  1.00  0.00           H  
ATOM    371 HD21 LEU A  26      23.323  19.226  12.280  1.00  0.00           H  
ATOM    372 HD22 LEU A  26      22.996  18.567  10.677  1.00  0.00           H  
ATOM    373 HD23 LEU A  26      24.050  17.696  11.791  1.00  0.00           H  
ATOM    374  N   HIS A  27      20.357  14.413  11.329  1.00  0.00           N  
ATOM    375  CA  HIS A  27      20.246  13.583  10.135  1.00  0.00           C  
ATOM    376  C   HIS A  27      19.919  14.432   8.910  1.00  0.00           C  
ATOM    377  O   HIS A  27      18.766  14.809   8.695  1.00  0.00           O  
ATOM    378  CB  HIS A  27      19.171  12.513  10.330  1.00  0.00           C  
ATOM    379  CG  HIS A  27      19.693  11.243  10.929  1.00  0.00           C  
ATOM    380  ND1 HIS A  27      19.424   9.997  10.402  1.00  0.00           N  
ATOM    381  CD2 HIS A  27      20.471  11.030  12.015  1.00  0.00           C  
ATOM    382  CE1 HIS A  27      20.014   9.073  11.140  1.00  0.00           C  
ATOM    383  NE2 HIS A  27      20.657   9.674  12.125  1.00  0.00           N  
ATOM    384  H   HIS A  27      19.631  15.035  11.547  1.00  0.00           H  
ATOM    385  HA  HIS A  27      21.198  13.099   9.977  1.00  0.00           H  
ATOM    386  HB2 HIS A  27      18.404  12.898  10.986  1.00  0.00           H  
ATOM    387  HB3 HIS A  27      18.732  12.273   9.372  1.00  0.00           H  
ATOM    388  HD1 HIS A  27      18.881   9.817   9.608  1.00  0.00           H  
ATOM    389  HD2 HIS A  27      20.873  11.787  12.675  1.00  0.00           H  
ATOM    390  HE1 HIS A  27      19.978   8.008  10.967  1.00  0.00           H  
ATOM    391  HE2 HIS A  27      21.107   9.219  12.866  1.00  0.00           H  
ATOM    392  N   ILE A  28      20.939  14.729   8.113  1.00  0.00           N  
ATOM    393  CA  ILE A  28      20.759  15.533   6.910  1.00  0.00           C  
ATOM    394  C   ILE A  28      20.583  14.650   5.679  1.00  0.00           C  
ATOM    395  O   ILE A  28      21.524  13.990   5.237  1.00  0.00           O  
ATOM    396  CB  ILE A  28      21.953  16.480   6.682  1.00  0.00           C  
ATOM    397  CG1 ILE A  28      22.194  17.339   7.925  1.00  0.00           C  
ATOM    398  CG2 ILE A  28      21.706  17.358   5.464  1.00  0.00           C  
ATOM    399  CD1 ILE A  28      23.479  18.137   7.867  1.00  0.00           C  
ATOM    400  H   ILE A  28      21.834  14.400   8.338  1.00  0.00           H  
ATOM    401  HA  ILE A  28      19.870  16.132   7.040  1.00  0.00           H  
ATOM    402  HB  ILE A  28      22.829  15.880   6.492  1.00  0.00           H  
ATOM    403 HG12 ILE A  28      21.378  18.034   8.039  1.00  0.00           H  
ATOM    404 HG13 ILE A  28      22.240  16.698   8.793  1.00  0.00           H  
ATOM    405 HG21 ILE A  28      21.599  18.386   5.778  1.00  0.00           H  
ATOM    406 HG22 ILE A  28      22.542  17.275   4.787  1.00  0.00           H  
ATOM    407 HG23 ILE A  28      20.804  17.038   4.966  1.00  0.00           H  
ATOM    408 HD11 ILE A  28      23.674  18.431   6.847  1.00  0.00           H  
ATOM    409 HD12 ILE A  28      23.384  19.017   8.485  1.00  0.00           H  
ATOM    410 HD13 ILE A  28      24.296  17.530   8.229  1.00  0.00           H  
ATOM    411  N   ILE A  29      19.373  14.644   5.130  1.00  0.00           N  
ATOM    412  CA  ILE A  29      19.075  13.844   3.950  1.00  0.00           C  
ATOM    413  C   ILE A  29      18.399  14.686   2.872  1.00  0.00           C  
ATOM    414  O   ILE A  29      17.530  15.505   3.166  1.00  0.00           O  
ATOM    415  CB  ILE A  29      18.168  12.647   4.293  1.00  0.00           C  
ATOM    416  CG1 ILE A  29      16.811  13.137   4.803  1.00  0.00           C  
ATOM    417  CG2 ILE A  29      18.838  11.756   5.328  1.00  0.00           C  
ATOM    418  CD1 ILE A  29      15.832  12.020   5.086  1.00  0.00           C  
ATOM    419  H   ILE A  29      18.665  15.190   5.530  1.00  0.00           H  
ATOM    420  HA  ILE A  29      20.008  13.463   3.561  1.00  0.00           H  
ATOM    421  HB  ILE A  29      18.019  12.067   3.396  1.00  0.00           H  
ATOM    422 HG12 ILE A  29      16.955  13.690   5.718  1.00  0.00           H  
ATOM    423 HG13 ILE A  29      16.370  13.787   4.061  1.00  0.00           H  
ATOM    424 HG21 ILE A  29      19.899  11.959   5.344  1.00  0.00           H  
ATOM    425 HG22 ILE A  29      18.419  11.958   6.303  1.00  0.00           H  
ATOM    426 HG23 ILE A  29      18.673  10.720   5.072  1.00  0.00           H  
ATOM    427 HD11 ILE A  29      14.987  12.105   4.420  1.00  0.00           H  
ATOM    428 HD12 ILE A  29      16.318  11.068   4.933  1.00  0.00           H  
ATOM    429 HD13 ILE A  29      15.491  12.090   6.108  1.00  0.00           H  
ATOM    430  N   GLU A  30      18.805  14.475   1.623  1.00  0.00           N  
ATOM    431  CA  GLU A  30      18.237  15.215   0.503  1.00  0.00           C  
ATOM    432  C   GLU A  30      17.100  14.431  -0.146  1.00  0.00           C  
ATOM    433  O   GLU A  30      17.299  13.321  -0.640  1.00  0.00           O  
ATOM    434  CB  GLU A  30      19.318  15.519  -0.537  1.00  0.00           C  
ATOM    435  CG  GLU A  30      20.035  16.837  -0.300  1.00  0.00           C  
ATOM    436  CD  GLU A  30      21.462  16.826  -0.815  1.00  0.00           C  
ATOM    437  OE1 GLU A  30      21.649  16.672  -2.040  1.00  0.00           O  
ATOM    438  OE2 GLU A  30      22.391  16.972   0.007  1.00  0.00           O  
ATOM    439  H   GLU A  30      19.501  13.808   1.453  1.00  0.00           H  
ATOM    440  HA  GLU A  30      17.844  16.146   0.883  1.00  0.00           H  
ATOM    441  HB2 GLU A  30      20.051  14.725  -0.519  1.00  0.00           H  
ATOM    442  HB3 GLU A  30      18.862  15.553  -1.514  1.00  0.00           H  
ATOM    443  HG2 GLU A  30      19.493  17.623  -0.805  1.00  0.00           H  
ATOM    444  HG3 GLU A  30      20.052  17.039   0.761  1.00  0.00           H  
ATOM    445  N   LEU A  31      15.907  15.016  -0.140  1.00  0.00           N  
ATOM    446  CA  LEU A  31      14.736  14.374  -0.727  1.00  0.00           C  
ATOM    447  C   LEU A  31      14.187  15.199  -1.887  1.00  0.00           C  
ATOM    448  O   LEU A  31      13.801  16.353  -1.712  1.00  0.00           O  
ATOM    449  CB  LEU A  31      13.652  14.180   0.334  1.00  0.00           C  
ATOM    450  CG  LEU A  31      14.088  13.474   1.618  1.00  0.00           C  
ATOM    451  CD1 LEU A  31      12.935  13.407   2.609  1.00  0.00           C  
ATOM    452  CD2 LEU A  31      14.611  12.078   1.310  1.00  0.00           C  
ATOM    453  H   LEU A  31      15.810  15.902   0.268  1.00  0.00           H  
ATOM    454  HA  LEU A  31      15.041  13.407  -1.101  1.00  0.00           H  
ATOM    455  HB2 LEU A  31      13.274  15.153   0.603  1.00  0.00           H  
ATOM    456  HB3 LEU A  31      12.856  13.597  -0.110  1.00  0.00           H  
ATOM    457  HG  LEU A  31      14.888  14.039   2.077  1.00  0.00           H  
ATOM    458 HD11 LEU A  31      12.005  13.589   2.091  1.00  0.00           H  
ATOM    459 HD12 LEU A  31      13.074  14.157   3.374  1.00  0.00           H  
ATOM    460 HD13 LEU A  31      12.909  12.428   3.065  1.00  0.00           H  
ATOM    461 HD21 LEU A  31      14.709  11.960   0.241  1.00  0.00           H  
ATOM    462 HD22 LEU A  31      13.919  11.343   1.692  1.00  0.00           H  
ATOM    463 HD23 LEU A  31      15.574  11.944   1.777  1.00  0.00           H  
ATOM    464  N   GLU A  32      14.152  14.594  -3.071  1.00  0.00           N  
ATOM    465  CA  GLU A  32      13.648  15.274  -4.259  1.00  0.00           C  
ATOM    466  C   GLU A  32      12.125  15.355  -4.235  1.00  0.00           C  
ATOM    467  O   GLU A  32      11.435  14.338  -4.315  1.00  0.00           O  
ATOM    468  CB  GLU A  32      14.111  14.546  -5.523  1.00  0.00           C  
ATOM    469  CG  GLU A  32      14.286  15.461  -6.723  1.00  0.00           C  
ATOM    470  CD  GLU A  32      14.764  14.722  -7.958  1.00  0.00           C  
ATOM    471  OE1 GLU A  32      15.976  14.430  -8.044  1.00  0.00           O  
ATOM    472  OE2 GLU A  32      13.926  14.433  -8.837  1.00  0.00           O  
ATOM    473  H   GLU A  32      14.473  13.672  -3.147  1.00  0.00           H  
ATOM    474  HA  GLU A  32      14.051  16.275  -4.265  1.00  0.00           H  
ATOM    475  HB2 GLU A  32      15.056  14.063  -5.323  1.00  0.00           H  
ATOM    476  HB3 GLU A  32      13.379  13.792  -5.777  1.00  0.00           H  
ATOM    477  HG2 GLU A  32      13.338  15.927  -6.947  1.00  0.00           H  
ATOM    478  HG3 GLU A  32      15.011  16.223  -6.476  1.00  0.00           H  
ATOM    479  N   LYS A  33      11.606  16.572  -4.121  1.00  0.00           N  
ATOM    480  CA  LYS A  33      10.164  16.790  -4.086  1.00  0.00           C  
ATOM    481  C   LYS A  33       9.455  15.901  -5.102  1.00  0.00           C  
ATOM    482  O   LYS A  33       9.820  15.872  -6.277  1.00  0.00           O  
ATOM    483  CB  LYS A  33       9.842  18.260  -4.366  1.00  0.00           C  
ATOM    484  CG  LYS A  33      10.114  19.178  -3.186  1.00  0.00           C  
ATOM    485  CD  LYS A  33       9.212  20.400  -3.211  1.00  0.00           C  
ATOM    486  CE  LYS A  33       9.664  21.404  -4.262  1.00  0.00           C  
ATOM    487  NZ  LYS A  33       9.042  21.138  -5.588  1.00  0.00           N  
ATOM    488  H   LYS A  33      12.207  17.345  -4.061  1.00  0.00           H  
ATOM    489  HA  LYS A  33       9.814  16.536  -3.096  1.00  0.00           H  
ATOM    490  HB2 LYS A  33      10.440  18.595  -5.200  1.00  0.00           H  
ATOM    491  HB3 LYS A  33       8.797  18.343  -4.627  1.00  0.00           H  
ATOM    492  HG2 LYS A  33       9.939  18.633  -2.271  1.00  0.00           H  
ATOM    493  HG3 LYS A  33      11.145  19.501  -3.223  1.00  0.00           H  
ATOM    494  HD2 LYS A  33       8.204  20.088  -3.439  1.00  0.00           H  
ATOM    495  HD3 LYS A  33       9.234  20.873  -2.240  1.00  0.00           H  
ATOM    496  HE2 LYS A  33       9.385  22.395  -3.936  1.00  0.00           H  
ATOM    497  HE3 LYS A  33      10.738  21.345  -4.358  1.00  0.00           H  
ATOM    498  HZ1 LYS A  33       9.597  20.427  -6.106  1.00  0.00           H  
ATOM    499  HZ2 LYS A  33       9.010  22.012  -6.149  1.00  0.00           H  
ATOM    500  HZ3 LYS A  33       8.073  20.782  -5.464  1.00  0.00           H  
ATOM    501  N   ASP A  34       8.439  15.179  -4.642  1.00  0.00           N  
ATOM    502  CA  ASP A  34       7.676  14.291  -5.511  1.00  0.00           C  
ATOM    503  C   ASP A  34       6.527  15.039  -6.179  1.00  0.00           C  
ATOM    504  O   ASP A  34       6.293  16.216  -5.902  1.00  0.00           O  
ATOM    505  CB  ASP A  34       7.134  13.103  -4.714  1.00  0.00           C  
ATOM    506  CG  ASP A  34       6.735  11.943  -5.603  1.00  0.00           C  
ATOM    507  OD1 ASP A  34       7.587  11.478  -6.390  1.00  0.00           O  
ATOM    508  OD2 ASP A  34       5.572  11.498  -5.512  1.00  0.00           O  
ATOM    509  H   ASP A  34       8.195  15.246  -3.695  1.00  0.00           H  
ATOM    510  HA  ASP A  34       8.343  13.923  -6.277  1.00  0.00           H  
ATOM    511  HB2 ASP A  34       7.894  12.762  -4.027  1.00  0.00           H  
ATOM    512  HB3 ASP A  34       6.265  13.421  -4.155  1.00  0.00           H  
ATOM    513  N   LYS A  35       5.813  14.350  -7.062  1.00  0.00           N  
ATOM    514  CA  LYS A  35       4.687  14.948  -7.771  1.00  0.00           C  
ATOM    515  C   LYS A  35       3.956  15.951  -6.883  1.00  0.00           C  
ATOM    516  O   LYS A  35       3.449  16.963  -7.364  1.00  0.00           O  
ATOM    517  CB  LYS A  35       3.716  13.861  -8.238  1.00  0.00           C  
ATOM    518  CG  LYS A  35       4.348  12.839  -9.166  1.00  0.00           C  
ATOM    519  CD  LYS A  35       3.296  11.982  -9.851  1.00  0.00           C  
ATOM    520  CE  LYS A  35       2.801  10.871  -8.939  1.00  0.00           C  
ATOM    521  NZ  LYS A  35       1.769  10.026  -9.602  1.00  0.00           N  
ATOM    522  H   LYS A  35       6.048  13.414  -7.241  1.00  0.00           H  
ATOM    523  HA  LYS A  35       5.077  15.466  -8.634  1.00  0.00           H  
ATOM    524  HB2 LYS A  35       3.333  13.341  -7.371  1.00  0.00           H  
ATOM    525  HB3 LYS A  35       2.894  14.329  -8.758  1.00  0.00           H  
ATOM    526  HG2 LYS A  35       4.923  13.356  -9.920  1.00  0.00           H  
ATOM    527  HG3 LYS A  35       5.001  12.198  -8.590  1.00  0.00           H  
ATOM    528  HD2 LYS A  35       2.458  12.607 -10.125  1.00  0.00           H  
ATOM    529  HD3 LYS A  35       3.726  11.543 -10.740  1.00  0.00           H  
ATOM    530  HE2 LYS A  35       3.639  10.250  -8.662  1.00  0.00           H  
ATOM    531  HE3 LYS A  35       2.374  11.315  -8.052  1.00  0.00           H  
ATOM    532  HZ1 LYS A  35       0.897  10.018  -9.037  1.00  0.00           H  
ATOM    533  HZ2 LYS A  35       2.115   9.050  -9.699  1.00  0.00           H  
ATOM    534  HZ3 LYS A  35       1.554  10.402 -10.547  1.00  0.00           H  
ATOM    535  N   ASN A  36       3.909  15.662  -5.587  1.00  0.00           N  
ATOM    536  CA  ASN A  36       3.241  16.539  -4.633  1.00  0.00           C  
ATOM    537  C   ASN A  36       4.259  17.293  -3.782  1.00  0.00           C  
ATOM    538  O   ASN A  36       3.993  18.396  -3.309  1.00  0.00           O  
ATOM    539  CB  ASN A  36       2.306  15.731  -3.732  1.00  0.00           C  
ATOM    540  CG  ASN A  36       1.946  16.471  -2.459  1.00  0.00           C  
ATOM    541  OD1 ASN A  36       1.073  17.339  -2.458  1.00  0.00           O  
ATOM    542  ND2 ASN A  36       2.619  16.131  -1.365  1.00  0.00           N  
ATOM    543  H   ASN A  36       4.333  14.839  -5.265  1.00  0.00           H  
ATOM    544  HA  ASN A  36       2.658  17.254  -5.192  1.00  0.00           H  
ATOM    545  HB2 ASN A  36       1.395  15.515  -4.271  1.00  0.00           H  
ATOM    546  HB3 ASN A  36       2.789  14.803  -3.463  1.00  0.00           H  
ATOM    547 HD21 ASN A  36       3.301  15.431  -1.441  1.00  0.00           H  
ATOM    548 HD22 ASN A  36       2.406  16.594  -0.529  1.00  0.00           H  
ATOM    549  N   GLY A  37       5.429  16.688  -3.593  1.00  0.00           N  
ATOM    550  CA  GLY A  37       6.469  17.316  -2.799  1.00  0.00           C  
ATOM    551  C   GLY A  37       6.741  16.572  -1.508  1.00  0.00           C  
ATOM    552  O   GLY A  37       6.293  15.439  -1.328  1.00  0.00           O  
ATOM    553  H   GLY A  37       5.585  15.807  -3.994  1.00  0.00           H  
ATOM    554  HA2 GLY A  37       7.378  17.352  -3.382  1.00  0.00           H  
ATOM    555  HA3 GLY A  37       6.165  18.324  -2.563  1.00  0.00           H  
ATOM    556  N   LEU A  38       7.482  17.207  -0.606  1.00  0.00           N  
ATOM    557  CA  LEU A  38       7.817  16.598   0.677  1.00  0.00           C  
ATOM    558  C   LEU A  38       6.580  16.480   1.562  1.00  0.00           C  
ATOM    559  O   LEU A  38       6.307  17.354   2.383  1.00  0.00           O  
ATOM    560  CB  LEU A  38       8.892  17.419   1.389  1.00  0.00           C  
ATOM    561  CG  LEU A  38      10.064  17.884   0.525  1.00  0.00           C  
ATOM    562  CD1 LEU A  38      11.018  18.747   1.337  1.00  0.00           C  
ATOM    563  CD2 LEU A  38      10.797  16.688  -0.068  1.00  0.00           C  
ATOM    564  H   LEU A  38       7.812  18.107  -0.807  1.00  0.00           H  
ATOM    565  HA  LEU A  38       8.201  15.607   0.483  1.00  0.00           H  
ATOM    566  HB2 LEU A  38       8.419  18.295   1.803  1.00  0.00           H  
ATOM    567  HB3 LEU A  38       9.291  16.815   2.191  1.00  0.00           H  
ATOM    568  HG  LEU A  38       9.685  18.483  -0.292  1.00  0.00           H  
ATOM    569 HD11 LEU A  38      11.985  18.270   1.383  1.00  0.00           H  
ATOM    570 HD12 LEU A  38      10.628  18.869   2.337  1.00  0.00           H  
ATOM    571 HD13 LEU A  38      11.115  19.715   0.868  1.00  0.00           H  
ATOM    572 HD21 LEU A  38      11.857  16.893  -0.092  1.00  0.00           H  
ATOM    573 HD22 LEU A  38      10.442  16.511  -1.073  1.00  0.00           H  
ATOM    574 HD23 LEU A  38      10.612  15.816   0.540  1.00  0.00           H  
ATOM    575  N   GLY A  39       5.837  15.390   1.391  1.00  0.00           N  
ATOM    576  CA  GLY A  39       4.640  15.177   2.183  1.00  0.00           C  
ATOM    577  C   GLY A  39       4.949  14.642   3.568  1.00  0.00           C  
ATOM    578  O   GLY A  39       5.163  13.442   3.745  1.00  0.00           O  
ATOM    579  H   GLY A  39       6.103  14.726   0.721  1.00  0.00           H  
ATOM    580  HA2 GLY A  39       4.113  16.115   2.280  1.00  0.00           H  
ATOM    581  HA3 GLY A  39       4.004  14.469   1.671  1.00  0.00           H  
ATOM    582  N   LEU A  40       4.973  15.534   4.552  1.00  0.00           N  
ATOM    583  CA  LEU A  40       5.259  15.146   5.929  1.00  0.00           C  
ATOM    584  C   LEU A  40       4.315  15.847   6.900  1.00  0.00           C  
ATOM    585  O   LEU A  40       4.050  17.042   6.770  1.00  0.00           O  
ATOM    586  CB  LEU A  40       6.711  15.478   6.282  1.00  0.00           C  
ATOM    587  CG  LEU A  40       7.782  14.775   5.448  1.00  0.00           C  
ATOM    588  CD1 LEU A  40       9.033  15.634   5.351  1.00  0.00           C  
ATOM    589  CD2 LEU A  40       8.112  13.413   6.041  1.00  0.00           C  
ATOM    590  H   LEU A  40       4.794  16.476   4.349  1.00  0.00           H  
ATOM    591  HA  LEU A  40       5.113  14.079   6.009  1.00  0.00           H  
ATOM    592  HB2 LEU A  40       6.845  16.542   6.162  1.00  0.00           H  
ATOM    593  HB3 LEU A  40       6.868  15.211   7.317  1.00  0.00           H  
ATOM    594  HG  LEU A  40       7.406  14.622   4.445  1.00  0.00           H  
ATOM    595 HD11 LEU A  40       9.623  15.318   4.505  1.00  0.00           H  
ATOM    596 HD12 LEU A  40       9.613  15.526   6.256  1.00  0.00           H  
ATOM    597 HD13 LEU A  40       8.750  16.669   5.227  1.00  0.00           H  
ATOM    598 HD21 LEU A  40       8.996  13.494   6.656  1.00  0.00           H  
ATOM    599 HD22 LEU A  40       8.292  12.707   5.244  1.00  0.00           H  
ATOM    600 HD23 LEU A  40       7.284  13.073   6.645  1.00  0.00           H  
ATOM    601  N   SER A  41       3.813  15.095   7.874  1.00  0.00           N  
ATOM    602  CA  SER A  41       2.896  15.644   8.867  1.00  0.00           C  
ATOM    603  C   SER A  41       3.662  16.341   9.987  1.00  0.00           C  
ATOM    604  O   SER A  41       4.398  15.705  10.742  1.00  0.00           O  
ATOM    605  CB  SER A  41       2.017  14.535   9.449  1.00  0.00           C  
ATOM    606  OG  SER A  41       1.159  13.993   8.460  1.00  0.00           O  
ATOM    607  H   SER A  41       4.061  14.149   7.925  1.00  0.00           H  
ATOM    608  HA  SER A  41       2.266  16.368   8.373  1.00  0.00           H  
ATOM    609  HB2 SER A  41       2.645  13.747   9.835  1.00  0.00           H  
ATOM    610  HB3 SER A  41       1.414  14.940  10.249  1.00  0.00           H  
ATOM    611  HG  SER A  41       1.540  14.139   7.591  1.00  0.00           H  
ATOM    612  N   LEU A  42       3.484  17.654  10.089  1.00  0.00           N  
ATOM    613  CA  LEU A  42       4.158  18.440  11.117  1.00  0.00           C  
ATOM    614  C   LEU A  42       3.197  18.798  12.246  1.00  0.00           C  
ATOM    615  O   LEU A  42       1.992  18.924  12.032  1.00  0.00           O  
ATOM    616  CB  LEU A  42       4.744  19.715  10.508  1.00  0.00           C  
ATOM    617  CG  LEU A  42       5.590  19.530   9.248  1.00  0.00           C  
ATOM    618  CD1 LEU A  42       6.060  20.875   8.717  1.00  0.00           C  
ATOM    619  CD2 LEU A  42       6.779  18.622   9.531  1.00  0.00           C  
ATOM    620  H   LEU A  42       2.885  18.106   9.460  1.00  0.00           H  
ATOM    621  HA  LEU A  42       4.960  17.841  11.519  1.00  0.00           H  
ATOM    622  HB2 LEU A  42       3.924  20.371  10.262  1.00  0.00           H  
ATOM    623  HB3 LEU A  42       5.366  20.184  11.259  1.00  0.00           H  
ATOM    624  HG  LEU A  42       4.986  19.062   8.482  1.00  0.00           H  
ATOM    625 HD11 LEU A  42       6.679  21.358   9.458  1.00  0.00           H  
ATOM    626 HD12 LEU A  42       5.203  21.497   8.504  1.00  0.00           H  
ATOM    627 HD13 LEU A  42       6.630  20.727   7.812  1.00  0.00           H  
ATOM    628 HD21 LEU A  42       7.597  18.888   8.880  1.00  0.00           H  
ATOM    629 HD22 LEU A  42       6.497  17.594   9.355  1.00  0.00           H  
ATOM    630 HD23 LEU A  42       7.085  18.740  10.561  1.00  0.00           H  
ATOM    631  N   ALA A  43       3.740  18.961  13.448  1.00  0.00           N  
ATOM    632  CA  ALA A  43       2.932  19.309  14.611  1.00  0.00           C  
ATOM    633  C   ALA A  43       3.772  20.009  15.674  1.00  0.00           C  
ATOM    634  O   ALA A  43       4.896  19.600  15.959  1.00  0.00           O  
ATOM    635  CB  ALA A  43       2.277  18.063  15.188  1.00  0.00           C  
ATOM    636  H   ALA A  43       4.707  18.846  13.556  1.00  0.00           H  
ATOM    637  HA  ALA A  43       2.150  19.979  14.285  1.00  0.00           H  
ATOM    638  HB1 ALA A  43       2.190  18.168  16.261  1.00  0.00           H  
ATOM    639  HB2 ALA A  43       1.294  17.940  14.758  1.00  0.00           H  
ATOM    640  HB3 ALA A  43       2.882  17.199  14.960  1.00  0.00           H  
ATOM    641  N   GLY A  44       3.218  21.068  16.255  1.00  0.00           N  
ATOM    642  CA  GLY A  44       3.931  21.810  17.280  1.00  0.00           C  
ATOM    643  C   GLY A  44       4.174  20.985  18.529  1.00  0.00           C  
ATOM    644  O   GLY A  44       3.616  19.899  18.681  1.00  0.00           O  
ATOM    645  H   GLY A  44       2.319  21.350  15.987  1.00  0.00           H  
ATOM    646  HA2 GLY A  44       4.883  22.129  16.882  1.00  0.00           H  
ATOM    647  HA3 GLY A  44       3.352  22.682  17.546  1.00  0.00           H  
ATOM    648  N   ASN A  45       5.010  21.502  19.423  1.00  0.00           N  
ATOM    649  CA  ASN A  45       5.328  20.804  20.664  1.00  0.00           C  
ATOM    650  C   ASN A  45       4.141  20.833  21.623  1.00  0.00           C  
ATOM    651  O   ASN A  45       3.386  21.804  21.666  1.00  0.00           O  
ATOM    652  CB  ASN A  45       6.551  21.436  21.330  1.00  0.00           C  
ATOM    653  CG  ASN A  45       7.038  20.638  22.523  1.00  0.00           C  
ATOM    654  OD1 ASN A  45       6.328  20.494  23.519  1.00  0.00           O  
ATOM    655  ND2 ASN A  45       8.254  20.113  22.428  1.00  0.00           N  
ATOM    656  H   ASN A  45       5.425  22.372  19.245  1.00  0.00           H  
ATOM    657  HA  ASN A  45       5.553  19.777  20.418  1.00  0.00           H  
ATOM    658  HB2 ASN A  45       7.355  21.496  20.610  1.00  0.00           H  
ATOM    659  HB3 ASN A  45       6.298  22.431  21.664  1.00  0.00           H  
ATOM    660 HD21 ASN A  45       8.762  20.268  21.605  1.00  0.00           H  
ATOM    661 HD22 ASN A  45       8.593  19.591  23.185  1.00  0.00           H  
ATOM    662  N   LYS A  46       3.983  19.760  22.392  1.00  0.00           N  
ATOM    663  CA  LYS A  46       2.891  19.661  23.352  1.00  0.00           C  
ATOM    664  C   LYS A  46       2.580  21.023  23.965  1.00  0.00           C  
ATOM    665  O   LYS A  46       1.430  21.461  23.976  1.00  0.00           O  
ATOM    666  CB  LYS A  46       3.244  18.661  24.456  1.00  0.00           C  
ATOM    667  CG  LYS A  46       3.035  17.211  24.053  1.00  0.00           C  
ATOM    668  CD  LYS A  46       3.623  16.257  25.079  1.00  0.00           C  
ATOM    669  CE  LYS A  46       3.138  14.833  24.858  1.00  0.00           C  
ATOM    670  NZ  LYS A  46       1.702  14.675  25.215  1.00  0.00           N  
ATOM    671  H   LYS A  46       4.618  19.016  22.311  1.00  0.00           H  
ATOM    672  HA  LYS A  46       2.017  19.309  22.825  1.00  0.00           H  
ATOM    673  HB2 LYS A  46       4.281  18.793  24.725  1.00  0.00           H  
ATOM    674  HB3 LYS A  46       2.628  18.865  25.320  1.00  0.00           H  
ATOM    675  HG2 LYS A  46       1.975  17.020  23.966  1.00  0.00           H  
ATOM    676  HG3 LYS A  46       3.512  17.040  23.099  1.00  0.00           H  
ATOM    677  HD2 LYS A  46       4.701  16.275  24.997  1.00  0.00           H  
ATOM    678  HD3 LYS A  46       3.330  16.580  26.067  1.00  0.00           H  
ATOM    679  HE2 LYS A  46       3.272  14.578  23.818  1.00  0.00           H  
ATOM    680  HE3 LYS A  46       3.728  14.167  25.470  1.00  0.00           H  
ATOM    681  HZ1 LYS A  46       1.269  15.607  25.374  1.00  0.00           H  
ATOM    682  HZ2 LYS A  46       1.609  14.109  26.083  1.00  0.00           H  
ATOM    683  HZ3 LYS A  46       1.193  14.195  24.446  1.00  0.00           H  
ATOM    684  N   ASP A  47       3.612  21.686  24.473  1.00  0.00           N  
ATOM    685  CA  ASP A  47       3.450  23.000  25.085  1.00  0.00           C  
ATOM    686  C   ASP A  47       3.685  24.109  24.064  1.00  0.00           C  
ATOM    687  O   ASP A  47       4.781  24.243  23.520  1.00  0.00           O  
ATOM    688  CB  ASP A  47       4.414  23.161  26.261  1.00  0.00           C  
ATOM    689  CG  ASP A  47       3.877  24.096  27.328  1.00  0.00           C  
ATOM    690  OD1 ASP A  47       2.728  23.888  27.774  1.00  0.00           O  
ATOM    691  OD2 ASP A  47       4.604  25.033  27.715  1.00  0.00           O  
ATOM    692  H   ASP A  47       4.505  21.284  24.434  1.00  0.00           H  
ATOM    693  HA  ASP A  47       2.436  23.073  25.450  1.00  0.00           H  
ATOM    694  HB2 ASP A  47       4.587  22.194  26.712  1.00  0.00           H  
ATOM    695  HB3 ASP A  47       5.351  23.558  25.900  1.00  0.00           H  
ATOM    696  N   ARG A  48       2.649  24.901  23.808  1.00  0.00           N  
ATOM    697  CA  ARG A  48       2.741  25.995  22.851  1.00  0.00           C  
ATOM    698  C   ARG A  48       4.019  26.802  23.069  1.00  0.00           C  
ATOM    699  O   ARG A  48       4.790  27.026  22.136  1.00  0.00           O  
ATOM    700  CB  ARG A  48       1.521  26.911  22.971  1.00  0.00           C  
ATOM    701  CG  ARG A  48       1.655  28.210  22.191  1.00  0.00           C  
ATOM    702  CD  ARG A  48       1.423  27.992  20.703  1.00  0.00           C  
ATOM    703  NE  ARG A  48       1.487  29.242  19.952  1.00  0.00           N  
ATOM    704  CZ  ARG A  48       0.496  30.126  19.910  1.00  0.00           C  
ATOM    705  NH1 ARG A  48      -0.628  29.899  20.575  1.00  0.00           N  
ATOM    706  NH2 ARG A  48       0.630  31.241  19.204  1.00  0.00           N  
ATOM    707  H   ARG A  48       1.800  24.743  24.274  1.00  0.00           H  
ATOM    708  HA  ARG A  48       2.764  25.568  21.859  1.00  0.00           H  
ATOM    709  HB2 ARG A  48       0.653  26.385  22.604  1.00  0.00           H  
ATOM    710  HB3 ARG A  48       1.371  27.156  24.011  1.00  0.00           H  
ATOM    711  HG2 ARG A  48       0.926  28.915  22.558  1.00  0.00           H  
ATOM    712  HG3 ARG A  48       2.649  28.605  22.338  1.00  0.00           H  
ATOM    713  HD2 ARG A  48       2.180  27.319  20.330  1.00  0.00           H  
ATOM    714  HD3 ARG A  48       0.448  27.549  20.567  1.00  0.00           H  
ATOM    715  HE  ARG A  48       2.309  29.431  19.453  1.00  0.00           H  
ATOM    716 HH11 ARG A  48      -0.730  29.059  21.109  1.00  0.00           H  
ATOM    717 HH12 ARG A  48      -1.372  30.567  20.543  1.00  0.00           H  
ATOM    718 HH21 ARG A  48       1.476  31.417  18.702  1.00  0.00           H  
ATOM    719 HH22 ARG A  48      -0.116  31.906  19.173  1.00  0.00           H  
ATOM    720  N   SER A  49       4.235  27.234  24.306  1.00  0.00           N  
ATOM    721  CA  SER A  49       5.416  28.019  24.646  1.00  0.00           C  
ATOM    722  C   SER A  49       6.659  27.450  23.968  1.00  0.00           C  
ATOM    723  O   SER A  49       7.550  28.194  23.556  1.00  0.00           O  
ATOM    724  CB  SER A  49       5.617  28.047  26.163  1.00  0.00           C  
ATOM    725  OG  SER A  49       4.626  28.841  26.793  1.00  0.00           O  
ATOM    726  H   SER A  49       3.583  27.023  25.007  1.00  0.00           H  
ATOM    727  HA  SER A  49       5.258  29.027  24.293  1.00  0.00           H  
ATOM    728  HB2 SER A  49       5.556  27.042  26.550  1.00  0.00           H  
ATOM    729  HB3 SER A  49       6.589  28.462  26.386  1.00  0.00           H  
ATOM    730  HG  SER A  49       4.586  28.621  27.726  1.00  0.00           H  
ATOM    731  N   ARG A  50       6.712  26.127  23.857  1.00  0.00           N  
ATOM    732  CA  ARG A  50       7.845  25.457  23.231  1.00  0.00           C  
ATOM    733  C   ARG A  50       7.623  25.300  21.729  1.00  0.00           C  
ATOM    734  O   ARG A  50       6.737  24.563  21.298  1.00  0.00           O  
ATOM    735  CB  ARG A  50       8.072  24.086  23.870  1.00  0.00           C  
ATOM    736  CG  ARG A  50       8.880  24.140  25.157  1.00  0.00           C  
ATOM    737  CD  ARG A  50       9.275  22.748  25.624  1.00  0.00           C  
ATOM    738  NE  ARG A  50      10.406  22.782  26.548  1.00  0.00           N  
ATOM    739  CZ  ARG A  50      11.633  23.143  26.194  1.00  0.00           C  
ATOM    740  NH1 ARG A  50      11.888  23.502  24.944  1.00  0.00           N  
ATOM    741  NH2 ARG A  50      12.610  23.149  27.093  1.00  0.00           N  
ATOM    742  H   ARG A  50       5.972  25.588  24.205  1.00  0.00           H  
ATOM    743  HA  ARG A  50       8.722  26.068  23.391  1.00  0.00           H  
ATOM    744  HB2 ARG A  50       7.112  23.642  24.092  1.00  0.00           H  
ATOM    745  HB3 ARG A  50       8.597  23.457  23.167  1.00  0.00           H  
ATOM    746  HG2 ARG A  50       9.776  24.717  24.984  1.00  0.00           H  
ATOM    747  HG3 ARG A  50       8.286  24.613  25.924  1.00  0.00           H  
ATOM    748  HD2 ARG A  50       8.430  22.296  26.121  1.00  0.00           H  
ATOM    749  HD3 ARG A  50       9.544  22.155  24.762  1.00  0.00           H  
ATOM    750  HE  ARG A  50      10.240  22.521  27.478  1.00  0.00           H  
ATOM    751 HH11 ARG A  50      11.154  23.500  24.264  1.00  0.00           H  
ATOM    752 HH12 ARG A  50      12.813  23.775  24.680  1.00  0.00           H  
ATOM    753 HH21 ARG A  50      12.422  22.879  28.037  1.00  0.00           H  
ATOM    754 HH22 ARG A  50      13.533  23.421  26.826  1.00  0.00           H  
ATOM    755  N   MET A  51       8.433  25.998  20.941  1.00  0.00           N  
ATOM    756  CA  MET A  51       8.324  25.935  19.487  1.00  0.00           C  
ATOM    757  C   MET A  51       9.254  24.869  18.918  1.00  0.00           C  
ATOM    758  O   MET A  51      10.451  24.856  19.209  1.00  0.00           O  
ATOM    759  CB  MET A  51       8.651  27.297  18.870  1.00  0.00           C  
ATOM    760  CG  MET A  51       7.436  28.194  18.699  1.00  0.00           C  
ATOM    761  SD  MET A  51       6.153  27.439  17.680  1.00  0.00           S  
ATOM    762  CE  MET A  51       6.199  28.499  16.237  1.00  0.00           C  
ATOM    763  H   MET A  51       9.120  26.568  21.343  1.00  0.00           H  
ATOM    764  HA  MET A  51       7.305  25.675  19.243  1.00  0.00           H  
ATOM    765  HB2 MET A  51       9.360  27.805  19.506  1.00  0.00           H  
ATOM    766  HB3 MET A  51       9.096  27.141  17.899  1.00  0.00           H  
ATOM    767  HG2 MET A  51       7.021  28.406  19.673  1.00  0.00           H  
ATOM    768  HG3 MET A  51       7.750  29.116  18.234  1.00  0.00           H  
ATOM    769  HE1 MET A  51       5.372  28.258  15.587  1.00  0.00           H  
ATOM    770  HE2 MET A  51       6.125  29.531  16.548  1.00  0.00           H  
ATOM    771  HE3 MET A  51       7.129  28.348  15.709  1.00  0.00           H  
ATOM    772  N   SER A  52       8.698  23.976  18.106  1.00  0.00           N  
ATOM    773  CA  SER A  52       9.478  22.904  17.498  1.00  0.00           C  
ATOM    774  C   SER A  52       8.628  22.100  16.520  1.00  0.00           C  
ATOM    775  O   SER A  52       7.524  21.667  16.851  1.00  0.00           O  
ATOM    776  CB  SER A  52      10.042  21.981  18.580  1.00  0.00           C  
ATOM    777  OG  SER A  52      10.753  20.898  18.006  1.00  0.00           O  
ATOM    778  H   SER A  52       7.739  24.039  17.911  1.00  0.00           H  
ATOM    779  HA  SER A  52      10.298  23.355  16.960  1.00  0.00           H  
ATOM    780  HB2 SER A  52      10.713  22.540  19.214  1.00  0.00           H  
ATOM    781  HB3 SER A  52       9.229  21.587  19.173  1.00  0.00           H  
ATOM    782  HG  SER A  52      10.181  20.426  17.396  1.00  0.00           H  
ATOM    783  N   ILE A  53       9.149  21.907  15.314  1.00  0.00           N  
ATOM    784  CA  ILE A  53       8.440  21.154  14.287  1.00  0.00           C  
ATOM    785  C   ILE A  53       8.831  19.680  14.315  1.00  0.00           C  
ATOM    786  O   ILE A  53       9.974  19.326  14.029  1.00  0.00           O  
ATOM    787  CB  ILE A  53       8.716  21.720  12.882  1.00  0.00           C  
ATOM    788  CG1 ILE A  53       8.471  23.231  12.859  1.00  0.00           C  
ATOM    789  CG2 ILE A  53       7.846  21.021  11.848  1.00  0.00           C  
ATOM    790  CD1 ILE A  53       9.236  23.950  11.771  1.00  0.00           C  
ATOM    791  H   ILE A  53      10.033  22.277  15.109  1.00  0.00           H  
ATOM    792  HA  ILE A  53       7.380  21.238  14.484  1.00  0.00           H  
ATOM    793  HB  ILE A  53       9.750  21.527  12.637  1.00  0.00           H  
ATOM    794 HG12 ILE A  53       7.421  23.416  12.704  1.00  0.00           H  
ATOM    795 HG13 ILE A  53       8.770  23.650  13.809  1.00  0.00           H  
ATOM    796 HG21 ILE A  53       7.064  21.692  11.524  1.00  0.00           H  
ATOM    797 HG22 ILE A  53       8.451  20.738  11.000  1.00  0.00           H  
ATOM    798 HG23 ILE A  53       7.404  20.139  12.286  1.00  0.00           H  
ATOM    799 HD11 ILE A  53       9.410  24.973  12.068  1.00  0.00           H  
ATOM    800 HD12 ILE A  53      10.182  23.456  11.607  1.00  0.00           H  
ATOM    801 HD13 ILE A  53       8.660  23.936  10.857  1.00  0.00           H  
ATOM    802  N   PHE A  54       7.874  18.826  14.660  1.00  0.00           N  
ATOM    803  CA  PHE A  54       8.117  17.390  14.726  1.00  0.00           C  
ATOM    804  C   PHE A  54       7.419  16.667  13.578  1.00  0.00           C  
ATOM    805  O   PHE A  54       6.524  17.218  12.936  1.00  0.00           O  
ATOM    806  CB  PHE A  54       7.635  16.830  16.065  1.00  0.00           C  
ATOM    807  CG  PHE A  54       8.402  17.353  17.245  1.00  0.00           C  
ATOM    808  CD1 PHE A  54       9.750  17.064  17.396  1.00  0.00           C  
ATOM    809  CD2 PHE A  54       7.777  18.133  18.204  1.00  0.00           C  
ATOM    810  CE1 PHE A  54      10.458  17.545  18.481  1.00  0.00           C  
ATOM    811  CE2 PHE A  54       8.481  18.618  19.290  1.00  0.00           C  
ATOM    812  CZ  PHE A  54       9.823  18.322  19.429  1.00  0.00           C  
ATOM    813  H   PHE A  54       6.982  19.170  14.878  1.00  0.00           H  
ATOM    814  HA  PHE A  54       9.181  17.231  14.640  1.00  0.00           H  
ATOM    815  HB2 PHE A  54       6.596  17.090  16.203  1.00  0.00           H  
ATOM    816  HB3 PHE A  54       7.734  15.754  16.054  1.00  0.00           H  
ATOM    817  HD1 PHE A  54      10.247  16.456  16.654  1.00  0.00           H  
ATOM    818  HD2 PHE A  54       6.727  18.365  18.097  1.00  0.00           H  
ATOM    819  HE1 PHE A  54      11.508  17.312  18.586  1.00  0.00           H  
ATOM    820  HE2 PHE A  54       7.982  19.224  20.031  1.00  0.00           H  
ATOM    821  HZ  PHE A  54      10.375  18.699  20.278  1.00  0.00           H  
ATOM    822  N   VAL A  55       7.834  15.430  13.324  1.00  0.00           N  
ATOM    823  CA  VAL A  55       7.248  14.630  12.255  1.00  0.00           C  
ATOM    824  C   VAL A  55       6.336  13.546  12.816  1.00  0.00           C  
ATOM    825  O   VAL A  55       6.798  12.476  13.215  1.00  0.00           O  
ATOM    826  CB  VAL A  55       8.337  13.972  11.387  1.00  0.00           C  
ATOM    827  CG1 VAL A  55       7.707  13.179  10.251  1.00  0.00           C  
ATOM    828  CG2 VAL A  55       9.295  15.023  10.847  1.00  0.00           C  
ATOM    829  H   VAL A  55       8.551  15.045  13.871  1.00  0.00           H  
ATOM    830  HA  VAL A  55       6.666  15.288  11.627  1.00  0.00           H  
ATOM    831  HB  VAL A  55       8.898  13.288  12.006  1.00  0.00           H  
ATOM    832 HG11 VAL A  55       8.483  12.799   9.604  1.00  0.00           H  
ATOM    833 HG12 VAL A  55       7.141  12.355  10.659  1.00  0.00           H  
ATOM    834 HG13 VAL A  55       7.051  13.823   9.685  1.00  0.00           H  
ATOM    835 HG21 VAL A  55      10.162  14.536  10.426  1.00  0.00           H  
ATOM    836 HG22 VAL A  55       8.800  15.602  10.080  1.00  0.00           H  
ATOM    837 HG23 VAL A  55       9.604  15.677  11.649  1.00  0.00           H  
ATOM    838  N   VAL A  56       5.038  13.829  12.846  1.00  0.00           N  
ATOM    839  CA  VAL A  56       4.059  12.877  13.357  1.00  0.00           C  
ATOM    840  C   VAL A  56       3.448  12.056  12.226  1.00  0.00           C  
ATOM    841  O   VAL A  56       2.378  11.469  12.379  1.00  0.00           O  
ATOM    842  CB  VAL A  56       2.932  13.589  14.127  1.00  0.00           C  
ATOM    843  CG1 VAL A  56       3.511  14.524  15.177  1.00  0.00           C  
ATOM    844  CG2 VAL A  56       2.027  14.347  13.166  1.00  0.00           C  
ATOM    845  H   VAL A  56       4.731  14.698  12.514  1.00  0.00           H  
ATOM    846  HA  VAL A  56       4.566  12.210  14.038  1.00  0.00           H  
ATOM    847  HB  VAL A  56       2.338  12.840  14.631  1.00  0.00           H  
ATOM    848 HG11 VAL A  56       3.796  13.953  16.049  1.00  0.00           H  
ATOM    849 HG12 VAL A  56       4.379  15.025  14.775  1.00  0.00           H  
ATOM    850 HG13 VAL A  56       2.768  15.257  15.455  1.00  0.00           H  
ATOM    851 HG21 VAL A  56       2.145  15.409  13.324  1.00  0.00           H  
ATOM    852 HG22 VAL A  56       2.298  14.104  12.149  1.00  0.00           H  
ATOM    853 HG23 VAL A  56       1.000  14.068  13.342  1.00  0.00           H  
ATOM    854  N   GLY A  57       4.136  12.021  11.089  1.00  0.00           N  
ATOM    855  CA  GLY A  57       3.646  11.269   9.948  1.00  0.00           C  
ATOM    856  C   GLY A  57       4.474  11.503   8.700  1.00  0.00           C  
ATOM    857  O   GLY A  57       5.047  12.579   8.520  1.00  0.00           O  
ATOM    858  H   GLY A  57       4.984  12.509  11.024  1.00  0.00           H  
ATOM    859  HA2 GLY A  57       3.666  10.217  10.188  1.00  0.00           H  
ATOM    860  HA3 GLY A  57       2.626  11.563   9.750  1.00  0.00           H  
ATOM    861  N   ILE A  58       4.538  10.495   7.837  1.00  0.00           N  
ATOM    862  CA  ILE A  58       5.303  10.597   6.600  1.00  0.00           C  
ATOM    863  C   ILE A  58       4.498  10.081   5.412  1.00  0.00           C  
ATOM    864  O   ILE A  58       4.474   8.883   5.140  1.00  0.00           O  
ATOM    865  CB  ILE A  58       6.625   9.812   6.689  1.00  0.00           C  
ATOM    866  CG1 ILE A  58       7.503  10.374   7.809  1.00  0.00           C  
ATOM    867  CG2 ILE A  58       7.360   9.859   5.359  1.00  0.00           C  
ATOM    868  CD1 ILE A  58       8.739   9.546   8.082  1.00  0.00           C  
ATOM    869  H   ILE A  58       4.061   9.664   8.036  1.00  0.00           H  
ATOM    870  HA  ILE A  58       5.537  11.640   6.438  1.00  0.00           H  
ATOM    871  HB  ILE A  58       6.392   8.781   6.909  1.00  0.00           H  
ATOM    872 HG12 ILE A  58       7.824  11.370   7.542  1.00  0.00           H  
ATOM    873 HG13 ILE A  58       6.925  10.421   8.721  1.00  0.00           H  
ATOM    874 HG21 ILE A  58       7.335  10.866   4.969  1.00  0.00           H  
ATOM    875 HG22 ILE A  58       8.386   9.557   5.503  1.00  0.00           H  
ATOM    876 HG23 ILE A  58       6.882   9.189   4.659  1.00  0.00           H  
ATOM    877 HD11 ILE A  58       9.618  10.166   7.982  1.00  0.00           H  
ATOM    878 HD12 ILE A  58       8.692   9.147   9.084  1.00  0.00           H  
ATOM    879 HD13 ILE A  58       8.791   8.733   7.372  1.00  0.00           H  
ATOM    880  N   ASN A  59       3.842  10.997   4.708  1.00  0.00           N  
ATOM    881  CA  ASN A  59       3.036  10.636   3.547  1.00  0.00           C  
ATOM    882  C   ASN A  59       3.702   9.518   2.749  1.00  0.00           C  
ATOM    883  O   ASN A  59       4.826   9.653   2.264  1.00  0.00           O  
ATOM    884  CB  ASN A  59       2.818  11.856   2.651  1.00  0.00           C  
ATOM    885  CG  ASN A  59       1.553  11.746   1.822  1.00  0.00           C  
ATOM    886  OD1 ASN A  59       0.588  11.096   2.223  1.00  0.00           O  
ATOM    887  ND2 ASN A  59       1.552  12.385   0.657  1.00  0.00           N  
ATOM    888  H   ASN A  59       3.900  11.938   4.974  1.00  0.00           H  
ATOM    889  HA  ASN A  59       2.079  10.286   3.903  1.00  0.00           H  
ATOM    890  HB2 ASN A  59       2.744  12.740   3.269  1.00  0.00           H  
ATOM    891  HB3 ASN A  59       3.658  11.960   1.981  1.00  0.00           H  
ATOM    892 HD21 ASN A  59       2.356  12.883   0.401  1.00  0.00           H  
ATOM    893 HD22 ASN A  59       0.746  12.330   0.101  1.00  0.00           H  
ATOM    894  N   PRO A  60       2.993   8.388   2.609  1.00  0.00           N  
ATOM    895  CA  PRO A  60       3.495   7.226   1.870  1.00  0.00           C  
ATOM    896  C   PRO A  60       3.570   7.481   0.368  1.00  0.00           C  
ATOM    897  O   PRO A  60       4.068   6.648  -0.387  1.00  0.00           O  
ATOM    898  CB  PRO A  60       2.463   6.138   2.177  1.00  0.00           C  
ATOM    899  CG  PRO A  60       1.212   6.882   2.495  1.00  0.00           C  
ATOM    900  CD  PRO A  60       1.648   8.158   3.161  1.00  0.00           C  
ATOM    901  HA  PRO A  60       4.465   6.916   2.229  1.00  0.00           H  
ATOM    902  HB2 PRO A  60       2.336   5.503   1.311  1.00  0.00           H  
ATOM    903  HB3 PRO A  60       2.796   5.548   3.017  1.00  0.00           H  
ATOM    904  HG2 PRO A  60       0.671   7.097   1.587  1.00  0.00           H  
ATOM    905  HG3 PRO A  60       0.600   6.299   3.168  1.00  0.00           H  
ATOM    906  HD2 PRO A  60       0.980   8.967   2.899  1.00  0.00           H  
ATOM    907  HD3 PRO A  60       1.687   8.031   4.233  1.00  0.00           H  
ATOM    908  N   GLU A  61       3.070   8.638  -0.056  1.00  0.00           N  
ATOM    909  CA  GLU A  61       3.081   9.002  -1.468  1.00  0.00           C  
ATOM    910  C   GLU A  61       4.160  10.043  -1.754  1.00  0.00           C  
ATOM    911  O   GLU A  61       4.517  10.282  -2.907  1.00  0.00           O  
ATOM    912  CB  GLU A  61       1.713   9.542  -1.889  1.00  0.00           C  
ATOM    913  CG  GLU A  61       0.590   8.528  -1.752  1.00  0.00           C  
ATOM    914  CD  GLU A  61      -0.783   9.171  -1.771  1.00  0.00           C  
ATOM    915  OE1 GLU A  61      -1.280   9.543  -0.687  1.00  0.00           O  
ATOM    916  OE2 GLU A  61      -1.361   9.302  -2.870  1.00  0.00           O  
ATOM    917  H   GLU A  61       2.687   9.262   0.595  1.00  0.00           H  
ATOM    918  HA  GLU A  61       3.297   8.111  -2.039  1.00  0.00           H  
ATOM    919  HB2 GLU A  61       1.474  10.399  -1.276  1.00  0.00           H  
ATOM    920  HB3 GLU A  61       1.765   9.853  -2.921  1.00  0.00           H  
ATOM    921  HG2 GLU A  61       0.653   7.827  -2.571  1.00  0.00           H  
ATOM    922  HG3 GLU A  61       0.711   8.000  -0.817  1.00  0.00           H  
ATOM    923  N   GLY A  62       4.676  10.659  -0.694  1.00  0.00           N  
ATOM    924  CA  GLY A  62       5.709  11.667  -0.851  1.00  0.00           C  
ATOM    925  C   GLY A  62       7.090  11.062  -1.004  1.00  0.00           C  
ATOM    926  O   GLY A  62       7.260   9.843  -1.021  1.00  0.00           O  
ATOM    927  H   GLY A  62       4.353  10.427   0.202  1.00  0.00           H  
ATOM    928  HA2 GLY A  62       5.487  12.259  -1.727  1.00  0.00           H  
ATOM    929  HA3 GLY A  62       5.703  12.309   0.017  1.00  0.00           H  
ATOM    930  N   PRO A  63       8.109  11.927  -1.120  1.00  0.00           N  
ATOM    931  CA  PRO A  63       9.500  11.495  -1.276  1.00  0.00           C  
ATOM    932  C   PRO A  63      10.056  10.860  -0.006  1.00  0.00           C  
ATOM    933  O   PRO A  63      10.616   9.765  -0.041  1.00  0.00           O  
ATOM    934  CB  PRO A  63      10.243  12.795  -1.592  1.00  0.00           C  
ATOM    935  CG  PRO A  63       9.403  13.868  -0.991  1.00  0.00           C  
ATOM    936  CD  PRO A  63       7.980  13.394  -1.109  1.00  0.00           C  
ATOM    937  HA  PRO A  63       9.612  10.804  -2.100  1.00  0.00           H  
ATOM    938  HB2 PRO A  63      11.228  12.767  -1.149  1.00  0.00           H  
ATOM    939  HB3 PRO A  63      10.328  12.914  -2.663  1.00  0.00           H  
ATOM    940  HG2 PRO A  63       9.668  14.003   0.047  1.00  0.00           H  
ATOM    941  HG3 PRO A  63       9.537  14.789  -1.537  1.00  0.00           H  
ATOM    942  HD2 PRO A  63       7.401  13.723  -0.258  1.00  0.00           H  
ATOM    943  HD3 PRO A  63       7.539  13.749  -2.029  1.00  0.00           H  
ATOM    944  N   ALA A  64       9.896  11.555   1.116  1.00  0.00           N  
ATOM    945  CA  ALA A  64      10.380  11.057   2.398  1.00  0.00           C  
ATOM    946  C   ALA A  64      10.050   9.579   2.573  1.00  0.00           C  
ATOM    947  O   ALA A  64      10.818   8.829   3.174  1.00  0.00           O  
ATOM    948  CB  ALA A  64       9.786  11.872   3.537  1.00  0.00           C  
ATOM    949  H   ALA A  64       9.442  12.422   1.080  1.00  0.00           H  
ATOM    950  HA  ALA A  64      11.453  11.182   2.421  1.00  0.00           H  
ATOM    951  HB1 ALA A  64      10.077  12.907   3.429  1.00  0.00           H  
ATOM    952  HB2 ALA A  64       8.708  11.796   3.511  1.00  0.00           H  
ATOM    953  HB3 ALA A  64      10.151  11.492   4.480  1.00  0.00           H  
ATOM    954  N   ALA A  65       8.901   9.168   2.046  1.00  0.00           N  
ATOM    955  CA  ALA A  65       8.470   7.779   2.143  1.00  0.00           C  
ATOM    956  C   ALA A  65       9.236   6.896   1.163  1.00  0.00           C  
ATOM    957  O   ALA A  65       9.678   5.802   1.514  1.00  0.00           O  
ATOM    958  CB  ALA A  65       6.973   7.671   1.894  1.00  0.00           C  
ATOM    959  H   ALA A  65       8.331   9.814   1.579  1.00  0.00           H  
ATOM    960  HA  ALA A  65       8.668   7.438   3.150  1.00  0.00           H  
ATOM    961  HB1 ALA A  65       6.635   8.546   1.356  1.00  0.00           H  
ATOM    962  HB2 ALA A  65       6.768   6.787   1.309  1.00  0.00           H  
ATOM    963  HB3 ALA A  65       6.455   7.608   2.838  1.00  0.00           H  
ATOM    964  N   ALA A  66       9.390   7.379  -0.065  1.00  0.00           N  
ATOM    965  CA  ALA A  66      10.104   6.634  -1.095  1.00  0.00           C  
ATOM    966  C   ALA A  66      11.543   6.358  -0.673  1.00  0.00           C  
ATOM    967  O   ALA A  66      12.015   5.222  -0.749  1.00  0.00           O  
ATOM    968  CB  ALA A  66      10.074   7.395  -2.413  1.00  0.00           C  
ATOM    969  H   ALA A  66       9.015   8.257  -0.284  1.00  0.00           H  
ATOM    970  HA  ALA A  66       9.594   5.693  -1.239  1.00  0.00           H  
ATOM    971  HB1 ALA A  66       9.128   7.907  -2.510  1.00  0.00           H  
ATOM    972  HB2 ALA A  66      10.878   8.115  -2.430  1.00  0.00           H  
ATOM    973  HB3 ALA A  66      10.193   6.701  -3.231  1.00  0.00           H  
ATOM    974  N   ASP A  67      12.236   7.401  -0.232  1.00  0.00           N  
ATOM    975  CA  ASP A  67      13.623   7.271   0.202  1.00  0.00           C  
ATOM    976  C   ASP A  67      13.743   6.266   1.344  1.00  0.00           C  
ATOM    977  O   ASP A  67      14.637   5.422   1.350  1.00  0.00           O  
ATOM    978  CB  ASP A  67      14.172   8.629   0.640  1.00  0.00           C  
ATOM    979  CG  ASP A  67      15.688   8.659   0.664  1.00  0.00           C  
ATOM    980  OD1 ASP A  67      16.310   7.848  -0.054  1.00  0.00           O  
ATOM    981  OD2 ASP A  67      16.252   9.496   1.400  1.00  0.00           O  
ATOM    982  H   ASP A  67      11.805   8.281  -0.196  1.00  0.00           H  
ATOM    983  HA  ASP A  67      14.200   6.914  -0.638  1.00  0.00           H  
ATOM    984  HB2 ASP A  67      13.827   9.389  -0.046  1.00  0.00           H  
ATOM    985  HB3 ASP A  67      13.810   8.854   1.631  1.00  0.00           H  
ATOM    986  N   GLY A  68      12.835   6.367   2.310  1.00  0.00           N  
ATOM    987  CA  GLY A  68      12.858   5.462   3.445  1.00  0.00           C  
ATOM    988  C   GLY A  68      13.917   5.835   4.463  1.00  0.00           C  
ATOM    989  O   GLY A  68      14.500   4.965   5.109  1.00  0.00           O  
ATOM    990  H   GLY A  68      12.144   7.060   2.253  1.00  0.00           H  
ATOM    991  HA2 GLY A  68      11.890   5.479   3.925  1.00  0.00           H  
ATOM    992  HA3 GLY A  68      13.054   4.461   3.089  1.00  0.00           H  
ATOM    993  N   ARG A  69      14.168   7.133   4.605  1.00  0.00           N  
ATOM    994  CA  ARG A  69      15.167   7.619   5.549  1.00  0.00           C  
ATOM    995  C   ARG A  69      14.504   8.348   6.714  1.00  0.00           C  
ATOM    996  O   ARG A  69      14.775   8.055   7.878  1.00  0.00           O  
ATOM    997  CB  ARG A  69      16.154   8.551   4.844  1.00  0.00           C  
ATOM    998  CG  ARG A  69      17.069   7.839   3.862  1.00  0.00           C  
ATOM    999  CD  ARG A  69      18.340   7.350   4.538  1.00  0.00           C  
ATOM   1000  NE  ARG A  69      18.119   6.121   5.296  1.00  0.00           N  
ATOM   1001  CZ  ARG A  69      19.079   5.480   5.952  1.00  0.00           C  
ATOM   1002  NH1 ARG A  69      20.319   5.949   5.945  1.00  0.00           N  
ATOM   1003  NH2 ARG A  69      18.800   4.368   6.619  1.00  0.00           N  
ATOM   1004  H   ARG A  69      13.671   7.779   4.060  1.00  0.00           H  
ATOM   1005  HA  ARG A  69      15.703   6.765   5.933  1.00  0.00           H  
ATOM   1006  HB2 ARG A  69      15.599   9.304   4.304  1.00  0.00           H  
ATOM   1007  HB3 ARG A  69      16.768   9.034   5.590  1.00  0.00           H  
ATOM   1008  HG2 ARG A  69      16.546   6.990   3.448  1.00  0.00           H  
ATOM   1009  HG3 ARG A  69      17.333   8.524   3.070  1.00  0.00           H  
ATOM   1010  HD2 ARG A  69      19.087   7.165   3.780  1.00  0.00           H  
ATOM   1011  HD3 ARG A  69      18.693   8.118   5.210  1.00  0.00           H  
ATOM   1012  HE  ARG A  69      17.210   5.757   5.315  1.00  0.00           H  
ATOM   1013 HH11 ARG A  69      20.533   6.788   5.444  1.00  0.00           H  
ATOM   1014 HH12 ARG A  69      21.040   5.465   6.441  1.00  0.00           H  
ATOM   1015 HH21 ARG A  69      17.866   4.011   6.627  1.00  0.00           H  
ATOM   1016 HH22 ARG A  69      19.523   3.886   7.113  1.00  0.00           H  
ATOM   1017  N   MET A  70      13.635   9.301   6.391  1.00  0.00           N  
ATOM   1018  CA  MET A  70      12.933  10.073   7.410  1.00  0.00           C  
ATOM   1019  C   MET A  70      11.984   9.183   8.207  1.00  0.00           C  
ATOM   1020  O   MET A  70      11.389   8.253   7.664  1.00  0.00           O  
ATOM   1021  CB  MET A  70      12.155  11.222   6.766  1.00  0.00           C  
ATOM   1022  CG  MET A  70      12.955  12.509   6.653  1.00  0.00           C  
ATOM   1023  SD  MET A  70      11.908  13.977   6.628  1.00  0.00           S  
ATOM   1024  CE  MET A  70      11.478  14.116   8.361  1.00  0.00           C  
ATOM   1025  H   MET A  70      13.462   9.490   5.445  1.00  0.00           H  
ATOM   1026  HA  MET A  70      13.672  10.482   8.082  1.00  0.00           H  
ATOM   1027  HB2 MET A  70      11.852  10.923   5.774  1.00  0.00           H  
ATOM   1028  HB3 MET A  70      11.275  11.421   7.358  1.00  0.00           H  
ATOM   1029  HG2 MET A  70      13.624  12.578   7.498  1.00  0.00           H  
ATOM   1030  HG3 MET A  70      13.532  12.479   5.740  1.00  0.00           H  
ATOM   1031  HE1 MET A  70      12.006  14.951   8.797  1.00  0.00           H  
ATOM   1032  HE2 MET A  70      10.414  14.273   8.456  1.00  0.00           H  
ATOM   1033  HE3 MET A  70      11.757  13.207   8.875  1.00  0.00           H  
ATOM   1034  N   ARG A  71      11.848   9.476   9.496  1.00  0.00           N  
ATOM   1035  CA  ARG A  71      10.972   8.702  10.366  1.00  0.00           C  
ATOM   1036  C   ARG A  71      10.154   9.620  11.271  1.00  0.00           C  
ATOM   1037  O   ARG A  71      10.336  10.837  11.263  1.00  0.00           O  
ATOM   1038  CB  ARG A  71      11.791   7.729  11.216  1.00  0.00           C  
ATOM   1039  CG  ARG A  71      12.509   6.665  10.402  1.00  0.00           C  
ATOM   1040  CD  ARG A  71      11.654   5.418  10.239  1.00  0.00           C  
ATOM   1041  NE  ARG A  71      12.092   4.596   9.115  1.00  0.00           N  
ATOM   1042  CZ  ARG A  71      11.416   3.546   8.664  1.00  0.00           C  
ATOM   1043  NH1 ARG A  71      10.274   3.192   9.238  1.00  0.00           N  
ATOM   1044  NH2 ARG A  71      11.879   2.848   7.635  1.00  0.00           N  
ATOM   1045  H   ARG A  71      12.349  10.230   9.870  1.00  0.00           H  
ATOM   1046  HA  ARG A  71      10.295   8.138   9.741  1.00  0.00           H  
ATOM   1047  HB2 ARG A  71      12.533   8.288  11.769  1.00  0.00           H  
ATOM   1048  HB3 ARG A  71      11.132   7.234  11.913  1.00  0.00           H  
ATOM   1049  HG2 ARG A  71      12.733   7.064   9.423  1.00  0.00           H  
ATOM   1050  HG3 ARG A  71      13.426   6.399  10.904  1.00  0.00           H  
ATOM   1051  HD2 ARG A  71      11.718   4.833  11.146  1.00  0.00           H  
ATOM   1052  HD3 ARG A  71      10.629   5.718  10.076  1.00  0.00           H  
ATOM   1053  HE  ARG A  71      12.933   4.840   8.675  1.00  0.00           H  
ATOM   1054 HH11 ARG A  71       9.921   3.717  10.012  1.00  0.00           H  
ATOM   1055 HH12 ARG A  71       9.765   2.402   8.896  1.00  0.00           H  
ATOM   1056 HH21 ARG A  71      12.739   3.111   7.199  1.00  0.00           H  
ATOM   1057 HH22 ARG A  71      11.369   2.058   7.296  1.00  0.00           H  
ATOM   1058  N   ILE A  72       9.255   9.027  12.050  1.00  0.00           N  
ATOM   1059  CA  ILE A  72       8.412   9.792  12.961  1.00  0.00           C  
ATOM   1060  C   ILE A  72       9.180  10.192  14.216  1.00  0.00           C  
ATOM   1061  O   ILE A  72       9.733   9.344  14.914  1.00  0.00           O  
ATOM   1062  CB  ILE A  72       7.159   8.995  13.370  1.00  0.00           C  
ATOM   1063  CG1 ILE A  72       6.546   8.306  12.150  1.00  0.00           C  
ATOM   1064  CG2 ILE A  72       6.142   9.911  14.034  1.00  0.00           C  
ATOM   1065  CD1 ILE A  72       6.375   9.222  10.959  1.00  0.00           C  
ATOM   1066  H   ILE A  72       9.158   8.054  12.012  1.00  0.00           H  
ATOM   1067  HA  ILE A  72       8.094  10.687  12.446  1.00  0.00           H  
ATOM   1068  HB  ILE A  72       7.455   8.245  14.087  1.00  0.00           H  
ATOM   1069 HG12 ILE A  72       7.180   7.487  11.849  1.00  0.00           H  
ATOM   1070 HG13 ILE A  72       5.571   7.921  12.415  1.00  0.00           H  
ATOM   1071 HG21 ILE A  72       5.419   9.316  14.572  1.00  0.00           H  
ATOM   1072 HG22 ILE A  72       6.649  10.571  14.723  1.00  0.00           H  
ATOM   1073 HG23 ILE A  72       5.638  10.496  13.280  1.00  0.00           H  
ATOM   1074 HD11 ILE A  72       7.346   9.542  10.608  1.00  0.00           H  
ATOM   1075 HD12 ILE A  72       5.861   8.697  10.169  1.00  0.00           H  
ATOM   1076 HD13 ILE A  72       5.796  10.087  11.251  1.00  0.00           H  
ATOM   1077  N   GLY A  73       9.206  11.491  14.499  1.00  0.00           N  
ATOM   1078  CA  GLY A  73       9.906  11.980  15.671  1.00  0.00           C  
ATOM   1079  C   GLY A  73      10.974  12.999  15.326  1.00  0.00           C  
ATOM   1080  O   GLY A  73      11.432  13.747  16.191  1.00  0.00           O  
ATOM   1081  H   GLY A  73       8.747  12.121  13.906  1.00  0.00           H  
ATOM   1082  HA2 GLY A  73       9.192  12.436  16.340  1.00  0.00           H  
ATOM   1083  HA3 GLY A  73      10.372  11.145  16.174  1.00  0.00           H  
ATOM   1084  N   ASP A  74      11.373  13.030  14.059  1.00  0.00           N  
ATOM   1085  CA  ASP A  74      12.394  13.965  13.601  1.00  0.00           C  
ATOM   1086  C   ASP A  74      11.958  15.407  13.842  1.00  0.00           C  
ATOM   1087  O   ASP A  74      10.788  15.747  13.671  1.00  0.00           O  
ATOM   1088  CB  ASP A  74      12.684  13.747  12.115  1.00  0.00           C  
ATOM   1089  CG  ASP A  74      13.240  12.367  11.829  1.00  0.00           C  
ATOM   1090  OD1 ASP A  74      14.166  11.938  12.549  1.00  0.00           O  
ATOM   1091  OD2 ASP A  74      12.748  11.713  10.886  1.00  0.00           O  
ATOM   1092  H   ASP A  74      10.970  12.408  13.416  1.00  0.00           H  
ATOM   1093  HA  ASP A  74      13.294  13.775  14.165  1.00  0.00           H  
ATOM   1094  HB2 ASP A  74      11.770  13.870  11.554  1.00  0.00           H  
ATOM   1095  HB3 ASP A  74      13.405  14.481  11.785  1.00  0.00           H  
ATOM   1096  N   GLU A  75      12.906  16.248  14.240  1.00  0.00           N  
ATOM   1097  CA  GLU A  75      12.619  17.653  14.506  1.00  0.00           C  
ATOM   1098  C   GLU A  75      13.320  18.553  13.493  1.00  0.00           C  
ATOM   1099  O   GLU A  75      14.491  18.898  13.658  1.00  0.00           O  
ATOM   1100  CB  GLU A  75      13.055  18.026  15.924  1.00  0.00           C  
ATOM   1101  CG  GLU A  75      13.106  19.524  16.171  1.00  0.00           C  
ATOM   1102  CD  GLU A  75      13.611  19.870  17.559  1.00  0.00           C  
ATOM   1103  OE1 GLU A  75      13.482  19.021  18.465  1.00  0.00           O  
ATOM   1104  OE2 GLU A  75      14.134  20.989  17.738  1.00  0.00           O  
ATOM   1105  H   GLU A  75      13.821  15.916  14.359  1.00  0.00           H  
ATOM   1106  HA  GLU A  75      11.552  17.794  14.418  1.00  0.00           H  
ATOM   1107  HB2 GLU A  75      12.362  17.588  16.628  1.00  0.00           H  
ATOM   1108  HB3 GLU A  75      14.040  17.620  16.104  1.00  0.00           H  
ATOM   1109  HG2 GLU A  75      13.764  19.974  15.443  1.00  0.00           H  
ATOM   1110  HG3 GLU A  75      12.111  19.929  16.055  1.00  0.00           H  
ATOM   1111  N   LEU A  76      12.597  18.928  12.444  1.00  0.00           N  
ATOM   1112  CA  LEU A  76      13.149  19.788  11.403  1.00  0.00           C  
ATOM   1113  C   LEU A  76      13.846  21.001  12.010  1.00  0.00           C  
ATOM   1114  O   LEU A  76      13.357  21.593  12.974  1.00  0.00           O  
ATOM   1115  CB  LEU A  76      12.041  20.245  10.451  1.00  0.00           C  
ATOM   1116  CG  LEU A  76      11.451  19.168   9.541  1.00  0.00           C  
ATOM   1117  CD1 LEU A  76      10.318  19.739   8.703  1.00  0.00           C  
ATOM   1118  CD2 LEU A  76      12.531  18.573   8.649  1.00  0.00           C  
ATOM   1119  H   LEU A  76      11.670  18.621  12.367  1.00  0.00           H  
ATOM   1120  HA  LEU A  76      13.874  19.213  10.848  1.00  0.00           H  
ATOM   1121  HB2 LEU A  76      11.238  20.649  11.049  1.00  0.00           H  
ATOM   1122  HB3 LEU A  76      12.447  21.025   9.823  1.00  0.00           H  
ATOM   1123  HG  LEU A  76      11.045  18.372  10.151  1.00  0.00           H  
ATOM   1124 HD11 LEU A  76       9.813  20.512   9.260  1.00  0.00           H  
ATOM   1125 HD12 LEU A  76       9.618  18.953   8.460  1.00  0.00           H  
ATOM   1126 HD13 LEU A  76      10.720  20.156   7.791  1.00  0.00           H  
ATOM   1127 HD21 LEU A  76      13.415  19.192   8.693  1.00  0.00           H  
ATOM   1128 HD22 LEU A  76      12.173  18.532   7.630  1.00  0.00           H  
ATOM   1129 HD23 LEU A  76      12.771  17.577   8.988  1.00  0.00           H  
ATOM   1130  N   LEU A  77      14.988  21.368  11.440  1.00  0.00           N  
ATOM   1131  CA  LEU A  77      15.752  22.513  11.925  1.00  0.00           C  
ATOM   1132  C   LEU A  77      15.979  23.527  10.809  1.00  0.00           C  
ATOM   1133  O   LEU A  77      15.887  24.735  11.027  1.00  0.00           O  
ATOM   1134  CB  LEU A  77      17.096  22.052  12.491  1.00  0.00           C  
ATOM   1135  CG  LEU A  77      17.031  21.031  13.628  1.00  0.00           C  
ATOM   1136  CD1 LEU A  77      18.382  20.362  13.823  1.00  0.00           C  
ATOM   1137  CD2 LEU A  77      16.573  21.698  14.917  1.00  0.00           C  
ATOM   1138  H   LEU A  77      15.327  20.858  10.676  1.00  0.00           H  
ATOM   1139  HA  LEU A  77      15.180  22.983  12.712  1.00  0.00           H  
ATOM   1140  HB2 LEU A  77      17.661  21.612  11.684  1.00  0.00           H  
ATOM   1141  HB3 LEU A  77      17.616  22.925  12.858  1.00  0.00           H  
ATOM   1142  HG  LEU A  77      16.312  20.264  13.374  1.00  0.00           H  
ATOM   1143 HD11 LEU A  77      18.263  19.290  13.777  1.00  0.00           H  
ATOM   1144 HD12 LEU A  77      18.786  20.640  14.785  1.00  0.00           H  
ATOM   1145 HD13 LEU A  77      19.058  20.683  13.044  1.00  0.00           H  
ATOM   1146 HD21 LEU A  77      17.431  21.904  15.539  1.00  0.00           H  
ATOM   1147 HD22 LEU A  77      15.897  21.039  15.443  1.00  0.00           H  
ATOM   1148 HD23 LEU A  77      16.066  22.622  14.684  1.00  0.00           H  
ATOM   1149  N   GLU A  78      16.272  23.028   9.612  1.00  0.00           N  
ATOM   1150  CA  GLU A  78      16.510  23.892   8.462  1.00  0.00           C  
ATOM   1151  C   GLU A  78      16.046  23.220   7.173  1.00  0.00           C  
ATOM   1152  O   GLU A  78      16.039  21.993   7.067  1.00  0.00           O  
ATOM   1153  CB  GLU A  78      17.996  24.245   8.361  1.00  0.00           C  
ATOM   1154  CG  GLU A  78      18.583  24.781   9.654  1.00  0.00           C  
ATOM   1155  CD  GLU A  78      20.028  25.218   9.502  1.00  0.00           C  
ATOM   1156  OE1 GLU A  78      20.275  26.206   8.780  1.00  0.00           O  
ATOM   1157  OE2 GLU A  78      20.910  24.572  10.106  1.00  0.00           O  
ATOM   1158  H   GLU A  78      16.331  22.056   9.501  1.00  0.00           H  
ATOM   1159  HA  GLU A  78      15.943  24.798   8.605  1.00  0.00           H  
ATOM   1160  HB2 GLU A  78      18.546  23.359   8.078  1.00  0.00           H  
ATOM   1161  HB3 GLU A  78      18.123  24.995   7.594  1.00  0.00           H  
ATOM   1162  HG2 GLU A  78      17.999  25.630   9.977  1.00  0.00           H  
ATOM   1163  HG3 GLU A  78      18.535  24.005  10.405  1.00  0.00           H  
ATOM   1164  N   ILE A  79      15.661  24.034   6.194  1.00  0.00           N  
ATOM   1165  CA  ILE A  79      15.196  23.518   4.912  1.00  0.00           C  
ATOM   1166  C   ILE A  79      15.511  24.493   3.783  1.00  0.00           C  
ATOM   1167  O   ILE A  79      15.012  25.617   3.761  1.00  0.00           O  
ATOM   1168  CB  ILE A  79      13.681  23.244   4.932  1.00  0.00           C  
ATOM   1169  CG1 ILE A  79      13.344  22.196   5.993  1.00  0.00           C  
ATOM   1170  CG2 ILE A  79      13.209  22.787   3.560  1.00  0.00           C  
ATOM   1171  CD1 ILE A  79      11.903  21.739   5.954  1.00  0.00           C  
ATOM   1172  H   ILE A  79      15.691  25.002   6.338  1.00  0.00           H  
ATOM   1173  HA  ILE A  79      15.709  22.587   4.722  1.00  0.00           H  
ATOM   1174  HB  ILE A  79      13.174  24.166   5.172  1.00  0.00           H  
ATOM   1175 HG12 ILE A  79      13.970  21.331   5.848  1.00  0.00           H  
ATOM   1176 HG13 ILE A  79      13.534  22.613   6.972  1.00  0.00           H  
ATOM   1177 HG21 ILE A  79      12.758  21.809   3.642  1.00  0.00           H  
ATOM   1178 HG22 ILE A  79      12.481  23.487   3.178  1.00  0.00           H  
ATOM   1179 HG23 ILE A  79      14.051  22.739   2.885  1.00  0.00           H  
ATOM   1180 HD11 ILE A  79      11.474  21.815   6.943  1.00  0.00           H  
ATOM   1181 HD12 ILE A  79      11.345  22.359   5.269  1.00  0.00           H  
ATOM   1182 HD13 ILE A  79      11.861  20.710   5.624  1.00  0.00           H  
ATOM   1183  N   ASN A  80      16.343  24.053   2.843  1.00  0.00           N  
ATOM   1184  CA  ASN A  80      16.723  24.887   1.708  1.00  0.00           C  
ATOM   1185  C   ASN A  80      17.423  26.159   2.178  1.00  0.00           C  
ATOM   1186  O   ASN A  80      17.138  27.252   1.690  1.00  0.00           O  
ATOM   1187  CB  ASN A  80      15.491  25.246   0.876  1.00  0.00           C  
ATOM   1188  CG  ASN A  80      15.855  25.885  -0.449  1.00  0.00           C  
ATOM   1189  OD1 ASN A  80      15.855  27.109  -0.581  1.00  0.00           O  
ATOM   1190  ND2 ASN A  80      16.165  25.058  -1.440  1.00  0.00           N  
ATOM   1191  H   ASN A  80      16.709  23.147   2.914  1.00  0.00           H  
ATOM   1192  HA  ASN A  80      17.407  24.319   1.095  1.00  0.00           H  
ATOM   1193  HB2 ASN A  80      14.924  24.347   0.677  1.00  0.00           H  
ATOM   1194  HB3 ASN A  80      14.877  25.938   1.433  1.00  0.00           H  
ATOM   1195 HD21 ASN A  80      16.144  24.094  -1.263  1.00  0.00           H  
ATOM   1196 HD22 ASN A  80      16.406  25.445  -2.308  1.00  0.00           H  
ATOM   1197  N   ASN A  81      18.339  26.008   3.128  1.00  0.00           N  
ATOM   1198  CA  ASN A  81      19.080  27.144   3.664  1.00  0.00           C  
ATOM   1199  C   ASN A  81      18.143  28.121   4.366  1.00  0.00           C  
ATOM   1200  O   ASN A  81      18.250  29.335   4.190  1.00  0.00           O  
ATOM   1201  CB  ASN A  81      19.835  27.861   2.543  1.00  0.00           C  
ATOM   1202  CG  ASN A  81      20.751  26.928   1.774  1.00  0.00           C  
ATOM   1203  OD1 ASN A  81      20.579  25.710   1.802  1.00  0.00           O  
ATOM   1204  ND2 ASN A  81      21.730  27.499   1.082  1.00  0.00           N  
ATOM   1205  H   ASN A  81      18.522  25.111   3.478  1.00  0.00           H  
ATOM   1206  HA  ASN A  81      19.792  26.767   4.382  1.00  0.00           H  
ATOM   1207  HB2 ASN A  81      19.122  28.286   1.851  1.00  0.00           H  
ATOM   1208  HB3 ASN A  81      20.433  28.653   2.969  1.00  0.00           H  
ATOM   1209 HD21 ASN A  81      21.807  28.475   1.106  1.00  0.00           H  
ATOM   1210 HD22 ASN A  81      22.336  26.919   0.575  1.00  0.00           H  
ATOM   1211  N   GLN A  82      17.224  27.583   5.164  1.00  0.00           N  
ATOM   1212  CA  GLN A  82      16.268  28.408   5.892  1.00  0.00           C  
ATOM   1213  C   GLN A  82      15.947  27.796   7.251  1.00  0.00           C  
ATOM   1214  O   GLN A  82      15.316  26.741   7.334  1.00  0.00           O  
ATOM   1215  CB  GLN A  82      14.984  28.578   5.079  1.00  0.00           C  
ATOM   1216  CG  GLN A  82      15.010  29.776   4.144  1.00  0.00           C  
ATOM   1217  CD  GLN A  82      14.485  31.038   4.799  1.00  0.00           C  
ATOM   1218  OE1 GLN A  82      15.209  32.023   4.944  1.00  0.00           O  
ATOM   1219  NE2 GLN A  82      13.219  31.016   5.198  1.00  0.00           N  
ATOM   1220  H   GLN A  82      17.189  26.609   5.262  1.00  0.00           H  
ATOM   1221  HA  GLN A  82      16.716  29.378   6.046  1.00  0.00           H  
ATOM   1222  HB2 GLN A  82      14.827  27.688   4.487  1.00  0.00           H  
ATOM   1223  HB3 GLN A  82      14.154  28.697   5.759  1.00  0.00           H  
ATOM   1224  HG2 GLN A  82      16.028  29.949   3.829  1.00  0.00           H  
ATOM   1225  HG3 GLN A  82      14.400  29.555   3.281  1.00  0.00           H  
ATOM   1226 HE21 GLN A  82      12.701  30.196   5.050  1.00  0.00           H  
ATOM   1227 HE22 GLN A  82      12.854  31.818   5.625  1.00  0.00           H  
ATOM   1228  N   ILE A  83      16.383  28.463   8.315  1.00  0.00           N  
ATOM   1229  CA  ILE A  83      16.141  27.984   9.670  1.00  0.00           C  
ATOM   1230  C   ILE A  83      14.663  28.080  10.030  1.00  0.00           C  
ATOM   1231  O   ILE A  83      14.032  29.121   9.841  1.00  0.00           O  
ATOM   1232  CB  ILE A  83      16.962  28.777  10.703  1.00  0.00           C  
ATOM   1233  CG1 ILE A  83      18.447  28.752  10.334  1.00  0.00           C  
ATOM   1234  CG2 ILE A  83      16.747  28.211  12.098  1.00  0.00           C  
ATOM   1235  CD1 ILE A  83      19.319  29.542  11.285  1.00  0.00           C  
ATOM   1236  H   ILE A  83      16.881  29.297   8.184  1.00  0.00           H  
ATOM   1237  HA  ILE A  83      16.445  26.948   9.716  1.00  0.00           H  
ATOM   1238  HB  ILE A  83      16.615  29.799  10.697  1.00  0.00           H  
ATOM   1239 HG12 ILE A  83      18.794  27.731  10.337  1.00  0.00           H  
ATOM   1240 HG13 ILE A  83      18.572  29.168   9.345  1.00  0.00           H  
ATOM   1241 HG21 ILE A  83      17.021  28.953  12.834  1.00  0.00           H  
ATOM   1242 HG22 ILE A  83      15.708  27.948  12.223  1.00  0.00           H  
ATOM   1243 HG23 ILE A  83      17.360  27.332  12.229  1.00  0.00           H  
ATOM   1244 HD11 ILE A  83      20.309  29.111  11.308  1.00  0.00           H  
ATOM   1245 HD12 ILE A  83      19.378  30.567  10.953  1.00  0.00           H  
ATOM   1246 HD13 ILE A  83      18.891  29.510  12.277  1.00  0.00           H  
ATOM   1247  N   LEU A  84      14.114  26.988  10.552  1.00  0.00           N  
ATOM   1248  CA  LEU A  84      12.709  26.949  10.941  1.00  0.00           C  
ATOM   1249  C   LEU A  84      12.559  27.093  12.452  1.00  0.00           C  
ATOM   1250  O   LEU A  84      11.512  27.514  12.945  1.00  0.00           O  
ATOM   1251  CB  LEU A  84      12.066  25.640  10.476  1.00  0.00           C  
ATOM   1252  CG  LEU A  84      12.458  25.161   9.078  1.00  0.00           C  
ATOM   1253  CD1 LEU A  84      12.056  23.708   8.881  1.00  0.00           C  
ATOM   1254  CD2 LEU A  84      11.820  26.042   8.014  1.00  0.00           C  
ATOM   1255  H   LEU A  84      14.666  26.189  10.678  1.00  0.00           H  
ATOM   1256  HA  LEU A  84      12.209  27.777  10.461  1.00  0.00           H  
ATOM   1257  HB2 LEU A  84      12.342  24.870  11.179  1.00  0.00           H  
ATOM   1258  HB3 LEU A  84      10.994  25.776  10.492  1.00  0.00           H  
ATOM   1259  HG  LEU A  84      13.532  25.227   8.969  1.00  0.00           H  
ATOM   1260 HD11 LEU A  84      11.526  23.604   7.946  1.00  0.00           H  
ATOM   1261 HD12 LEU A  84      11.416  23.397   9.694  1.00  0.00           H  
ATOM   1262 HD13 LEU A  84      12.942  23.089   8.864  1.00  0.00           H  
ATOM   1263 HD21 LEU A  84      12.518  26.811   7.717  1.00  0.00           H  
ATOM   1264 HD22 LEU A  84      10.928  26.501   8.415  1.00  0.00           H  
ATOM   1265 HD23 LEU A  84      11.561  25.439   7.156  1.00  0.00           H  
ATOM   1266  N   TYR A  85      13.612  26.744  13.182  1.00  0.00           N  
ATOM   1267  CA  TYR A  85      13.598  26.835  14.637  1.00  0.00           C  
ATOM   1268  C   TYR A  85      12.951  28.138  15.096  1.00  0.00           C  
ATOM   1269  O   TYR A  85      13.520  29.216  14.937  1.00  0.00           O  
ATOM   1270  CB  TYR A  85      15.020  26.736  15.189  1.00  0.00           C  
ATOM   1271  CG  TYR A  85      15.093  26.830  16.697  1.00  0.00           C  
ATOM   1272  CD1 TYR A  85      15.064  28.062  17.339  1.00  0.00           C  
ATOM   1273  CD2 TYR A  85      15.190  25.686  17.479  1.00  0.00           C  
ATOM   1274  CE1 TYR A  85      15.130  28.151  18.716  1.00  0.00           C  
ATOM   1275  CE2 TYR A  85      15.256  25.766  18.857  1.00  0.00           C  
ATOM   1276  CZ  TYR A  85      15.225  27.000  19.470  1.00  0.00           C  
ATOM   1277  OH  TYR A  85      15.292  27.085  20.842  1.00  0.00           O  
ATOM   1278  H   TYR A  85      14.419  26.416  12.732  1.00  0.00           H  
ATOM   1279  HA  TYR A  85      13.018  26.005  15.016  1.00  0.00           H  
ATOM   1280  HB2 TYR A  85      15.449  25.791  14.896  1.00  0.00           H  
ATOM   1281  HB3 TYR A  85      15.614  27.540  14.779  1.00  0.00           H  
ATOM   1282  HD1 TYR A  85      14.989  28.961  16.745  1.00  0.00           H  
ATOM   1283  HD2 TYR A  85      15.215  24.719  16.996  1.00  0.00           H  
ATOM   1284  HE1 TYR A  85      15.106  29.118  19.197  1.00  0.00           H  
ATOM   1285  HE2 TYR A  85      15.331  24.864  19.448  1.00  0.00           H  
ATOM   1286  HH  TYR A  85      15.984  26.503  21.165  1.00  0.00           H  
ATOM   1287  N   GLY A  86      11.754  28.028  15.666  1.00  0.00           N  
ATOM   1288  CA  GLY A  86      11.048  29.204  16.140  1.00  0.00           C  
ATOM   1289  C   GLY A  86       9.778  29.473  15.357  1.00  0.00           C  
ATOM   1290  O   GLY A  86       8.761  29.867  15.928  1.00  0.00           O  
ATOM   1291  H   GLY A  86      11.348  27.142  15.766  1.00  0.00           H  
ATOM   1292  HA2 GLY A  86      10.795  29.064  17.180  1.00  0.00           H  
ATOM   1293  HA3 GLY A  86      11.700  30.062  16.051  1.00  0.00           H  
ATOM   1294  N   ARG A  87       9.836  29.259  14.046  1.00  0.00           N  
ATOM   1295  CA  ARG A  87       8.683  29.484  13.184  1.00  0.00           C  
ATOM   1296  C   ARG A  87       7.652  28.370  13.354  1.00  0.00           C  
ATOM   1297  O   ARG A  87       7.945  27.322  13.929  1.00  0.00           O  
ATOM   1298  CB  ARG A  87       9.122  29.569  11.721  1.00  0.00           C  
ATOM   1299  CG  ARG A  87      10.120  30.682  11.448  1.00  0.00           C  
ATOM   1300  CD  ARG A  87      10.803  30.500  10.101  1.00  0.00           C  
ATOM   1301  NE  ARG A  87      10.053  31.130   9.018  1.00  0.00           N  
ATOM   1302  CZ  ARG A  87       9.924  32.445   8.882  1.00  0.00           C  
ATOM   1303  NH1 ARG A  87      10.493  33.265   9.756  1.00  0.00           N  
ATOM   1304  NH2 ARG A  87       9.226  32.942   7.870  1.00  0.00           N  
ATOM   1305  H   ARG A  87      10.675  28.945  13.650  1.00  0.00           H  
ATOM   1306  HA  ARG A  87       8.232  30.422  13.471  1.00  0.00           H  
ATOM   1307  HB2 ARG A  87       9.575  28.630  11.438  1.00  0.00           H  
ATOM   1308  HB3 ARG A  87       8.250  29.738  11.106  1.00  0.00           H  
ATOM   1309  HG2 ARG A  87       9.600  31.627  11.451  1.00  0.00           H  
ATOM   1310  HG3 ARG A  87      10.869  30.678  12.226  1.00  0.00           H  
ATOM   1311  HD2 ARG A  87      11.787  30.941  10.150  1.00  0.00           H  
ATOM   1312  HD3 ARG A  87      10.892  29.443   9.898  1.00  0.00           H  
ATOM   1313  HE  ARG A  87       9.625  30.543   8.362  1.00  0.00           H  
ATOM   1314 HH11 ARG A  87      11.020  32.892  10.520  1.00  0.00           H  
ATOM   1315 HH12 ARG A  87      10.395  34.254   9.651  1.00  0.00           H  
ATOM   1316 HH21 ARG A  87       8.797  32.329   7.209  1.00  0.00           H  
ATOM   1317 HH22 ARG A  87       9.129  33.932   7.768  1.00  0.00           H  
ATOM   1318  N   SER A  88       6.446  28.606  12.849  1.00  0.00           N  
ATOM   1319  CA  SER A  88       5.371  27.625  12.948  1.00  0.00           C  
ATOM   1320  C   SER A  88       5.470  26.596  11.826  1.00  0.00           C  
ATOM   1321  O   SER A  88       5.796  26.931  10.687  1.00  0.00           O  
ATOM   1322  CB  SER A  88       4.010  28.322  12.898  1.00  0.00           C  
ATOM   1323  OG  SER A  88       3.694  28.915  14.146  1.00  0.00           O  
ATOM   1324  H   SER A  88       6.273  29.461  12.401  1.00  0.00           H  
ATOM   1325  HA  SER A  88       5.472  27.118  13.896  1.00  0.00           H  
ATOM   1326  HB2 SER A  88       4.030  29.093  12.142  1.00  0.00           H  
ATOM   1327  HB3 SER A  88       3.247  27.598  12.654  1.00  0.00           H  
ATOM   1328  HG  SER A  88       3.893  29.853  14.115  1.00  0.00           H  
ATOM   1329  N   HIS A  89       5.185  25.340  12.157  1.00  0.00           N  
ATOM   1330  CA  HIS A  89       5.241  24.260  11.178  1.00  0.00           C  
ATOM   1331  C   HIS A  89       4.684  24.718   9.833  1.00  0.00           C  
ATOM   1332  O   HIS A  89       5.244  24.405   8.782  1.00  0.00           O  
ATOM   1333  CB  HIS A  89       4.459  23.047  11.680  1.00  0.00           C  
ATOM   1334  CG  HIS A  89       3.050  23.365  12.078  1.00  0.00           C  
ATOM   1335  ND1 HIS A  89       1.993  23.331  11.193  1.00  0.00           N  
ATOM   1336  CD2 HIS A  89       2.526  23.722  13.273  1.00  0.00           C  
ATOM   1337  CE1 HIS A  89       0.880  23.656  11.827  1.00  0.00           C  
ATOM   1338  NE2 HIS A  89       1.177  23.897  13.091  1.00  0.00           N  
ATOM   1339  H   HIS A  89       4.932  25.135  13.081  1.00  0.00           H  
ATOM   1340  HA  HIS A  89       6.276  23.982  11.049  1.00  0.00           H  
ATOM   1341  HB2 HIS A  89       4.423  22.301  10.900  1.00  0.00           H  
ATOM   1342  HB3 HIS A  89       4.962  22.634  12.543  1.00  0.00           H  
ATOM   1343  HD1 HIS A  89       2.051  23.106  10.241  1.00  0.00           H  
ATOM   1344  HD2 HIS A  89       3.068  23.847  14.200  1.00  0.00           H  
ATOM   1345  HE1 HIS A  89      -0.104  23.715  11.387  1.00  0.00           H  
ATOM   1346  HE2 HIS A  89       0.550  24.241  13.761  1.00  0.00           H  
ATOM   1347  N   GLN A  90       3.582  25.458   9.875  1.00  0.00           N  
ATOM   1348  CA  GLN A  90       2.949  25.956   8.658  1.00  0.00           C  
ATOM   1349  C   GLN A  90       3.974  26.621   7.746  1.00  0.00           C  
ATOM   1350  O   GLN A  90       3.983  26.394   6.537  1.00  0.00           O  
ATOM   1351  CB  GLN A  90       1.838  26.948   9.006  1.00  0.00           C  
ATOM   1352  CG  GLN A  90       0.756  26.361   9.898  1.00  0.00           C  
ATOM   1353  CD  GLN A  90       0.087  27.407  10.768  1.00  0.00           C  
ATOM   1354  OE1 GLN A  90       0.636  28.486  10.995  1.00  0.00           O  
ATOM   1355  NE2 GLN A  90      -1.105  27.092  11.261  1.00  0.00           N  
ATOM   1356  H   GLN A  90       3.183  25.674  10.743  1.00  0.00           H  
ATOM   1357  HA  GLN A  90       2.518  25.113   8.140  1.00  0.00           H  
ATOM   1358  HB2 GLN A  90       2.274  27.795   9.514  1.00  0.00           H  
ATOM   1359  HB3 GLN A  90       1.375  27.286   8.090  1.00  0.00           H  
ATOM   1360  HG2 GLN A  90       0.004  25.900   9.274  1.00  0.00           H  
ATOM   1361  HG3 GLN A  90       1.201  25.613  10.536  1.00  0.00           H  
ATOM   1362 HE21 GLN A  90      -1.480  26.214  11.039  1.00  0.00           H  
ATOM   1363 HE22 GLN A  90      -1.560  27.749  11.828  1.00  0.00           H  
ATOM   1364  N   ASN A  91       4.837  27.444   8.334  1.00  0.00           N  
ATOM   1365  CA  ASN A  91       5.866  28.143   7.572  1.00  0.00           C  
ATOM   1366  C   ASN A  91       6.761  27.155   6.831  1.00  0.00           C  
ATOM   1367  O   ASN A  91       6.944  27.257   5.618  1.00  0.00           O  
ATOM   1368  CB  ASN A  91       6.712  29.016   8.502  1.00  0.00           C  
ATOM   1369  CG  ASN A  91       5.872  29.989   9.306  1.00  0.00           C  
ATOM   1370  OD1 ASN A  91       5.144  29.593  10.217  1.00  0.00           O  
ATOM   1371  ND2 ASN A  91       5.968  31.270   8.972  1.00  0.00           N  
ATOM   1372  H   ASN A  91       4.780  27.585   9.302  1.00  0.00           H  
ATOM   1373  HA  ASN A  91       5.372  28.776   6.851  1.00  0.00           H  
ATOM   1374  HB2 ASN A  91       7.251  28.381   9.190  1.00  0.00           H  
ATOM   1375  HB3 ASN A  91       7.419  29.580   7.912  1.00  0.00           H  
ATOM   1376 HD21 ASN A  91       6.568  31.513   8.236  1.00  0.00           H  
ATOM   1377 HD22 ASN A  91       5.437  31.921   9.475  1.00  0.00           H  
ATOM   1378  N   ALA A  92       7.313  26.197   7.568  1.00  0.00           N  
ATOM   1379  CA  ALA A  92       8.186  25.188   6.980  1.00  0.00           C  
ATOM   1380  C   ALA A  92       7.669  24.742   5.617  1.00  0.00           C  
ATOM   1381  O   ALA A  92       8.352  24.891   4.603  1.00  0.00           O  
ATOM   1382  CB  ALA A  92       8.316  23.994   7.914  1.00  0.00           C  
ATOM   1383  H   ALA A  92       7.129  26.167   8.529  1.00  0.00           H  
ATOM   1384  HA  ALA A  92       9.166  25.627   6.856  1.00  0.00           H  
ATOM   1385  HB1 ALA A  92       7.350  23.763   8.338  1.00  0.00           H  
ATOM   1386  HB2 ALA A  92       8.679  23.142   7.359  1.00  0.00           H  
ATOM   1387  HB3 ALA A  92       9.010  24.232   8.707  1.00  0.00           H  
ATOM   1388  N   SER A  93       6.458  24.193   5.599  1.00  0.00           N  
ATOM   1389  CA  SER A  93       5.851  23.722   4.359  1.00  0.00           C  
ATOM   1390  C   SER A  93       5.961  24.779   3.264  1.00  0.00           C  
ATOM   1391  O   SER A  93       6.321  24.474   2.128  1.00  0.00           O  
ATOM   1392  CB  SER A  93       4.383  23.361   4.592  1.00  0.00           C  
ATOM   1393  OG  SER A  93       3.602  24.522   4.818  1.00  0.00           O  
ATOM   1394  H   SER A  93       5.963  24.103   6.440  1.00  0.00           H  
ATOM   1395  HA  SER A  93       6.385  22.837   4.045  1.00  0.00           H  
ATOM   1396  HB2 SER A  93       3.999  22.848   3.723  1.00  0.00           H  
ATOM   1397  HB3 SER A  93       4.306  22.716   5.454  1.00  0.00           H  
ATOM   1398  HG  SER A  93       2.719  24.265   5.092  1.00  0.00           H  
ATOM   1399  N   ALA A  94       5.645  26.020   3.616  1.00  0.00           N  
ATOM   1400  CA  ALA A  94       5.710  27.123   2.664  1.00  0.00           C  
ATOM   1401  C   ALA A  94       7.091  27.218   2.027  1.00  0.00           C  
ATOM   1402  O   ALA A  94       7.217  27.340   0.808  1.00  0.00           O  
ATOM   1403  CB  ALA A  94       5.351  28.433   3.350  1.00  0.00           C  
ATOM   1404  H   ALA A  94       5.365  26.200   4.537  1.00  0.00           H  
ATOM   1405  HA  ALA A  94       4.979  26.938   1.889  1.00  0.00           H  
ATOM   1406  HB1 ALA A  94       4.806  28.225   4.259  1.00  0.00           H  
ATOM   1407  HB2 ALA A  94       6.255  28.974   3.587  1.00  0.00           H  
ATOM   1408  HB3 ALA A  94       4.737  29.028   2.690  1.00  0.00           H  
ATOM   1409  N   ILE A  95       8.127  27.163   2.858  1.00  0.00           N  
ATOM   1410  CA  ILE A  95       9.499  27.242   2.375  1.00  0.00           C  
ATOM   1411  C   ILE A  95       9.782  26.157   1.341  1.00  0.00           C  
ATOM   1412  O   ILE A  95      10.394  26.419   0.304  1.00  0.00           O  
ATOM   1413  CB  ILE A  95      10.511  27.112   3.529  1.00  0.00           C  
ATOM   1414  CG1 ILE A  95      10.239  28.173   4.597  1.00  0.00           C  
ATOM   1415  CG2 ILE A  95      11.934  27.234   3.003  1.00  0.00           C  
ATOM   1416  CD1 ILE A  95      10.842  27.842   5.944  1.00  0.00           C  
ATOM   1417  H   ILE A  95       7.963  27.064   3.819  1.00  0.00           H  
ATOM   1418  HA  ILE A  95       9.634  28.209   1.913  1.00  0.00           H  
ATOM   1419  HB  ILE A  95      10.398  26.132   3.967  1.00  0.00           H  
ATOM   1420 HG12 ILE A  95      10.650  29.115   4.273  1.00  0.00           H  
ATOM   1421 HG13 ILE A  95       9.171  28.276   4.727  1.00  0.00           H  
ATOM   1422 HG21 ILE A  95      12.585  26.588   3.573  1.00  0.00           H  
ATOM   1423 HG22 ILE A  95      11.959  26.943   1.963  1.00  0.00           H  
ATOM   1424 HG23 ILE A  95      12.266  28.257   3.098  1.00  0.00           H  
ATOM   1425 HD11 ILE A  95      11.608  27.090   5.822  1.00  0.00           H  
ATOM   1426 HD12 ILE A  95      11.276  28.732   6.374  1.00  0.00           H  
ATOM   1427 HD13 ILE A  95      10.071  27.465   6.601  1.00  0.00           H  
ATOM   1428  N   ILE A  96       9.332  24.942   1.629  1.00  0.00           N  
ATOM   1429  CA  ILE A  96       9.534  23.818   0.723  1.00  0.00           C  
ATOM   1430  C   ILE A  96       8.837  24.057  -0.612  1.00  0.00           C  
ATOM   1431  O   ILE A  96       9.404  23.802  -1.676  1.00  0.00           O  
ATOM   1432  CB  ILE A  96       9.014  22.503   1.331  1.00  0.00           C  
ATOM   1433  CG1 ILE A  96       9.832  22.130   2.569  1.00  0.00           C  
ATOM   1434  CG2 ILE A  96       9.065  21.385   0.301  1.00  0.00           C  
ATOM   1435  CD1 ILE A  96       9.155  21.108   3.456  1.00  0.00           C  
ATOM   1436  H   ILE A  96       8.852  24.796   2.471  1.00  0.00           H  
ATOM   1437  HA  ILE A  96      10.596  23.717   0.549  1.00  0.00           H  
ATOM   1438  HB  ILE A  96       7.984  22.648   1.620  1.00  0.00           H  
ATOM   1439 HG12 ILE A  96      10.780  21.720   2.257  1.00  0.00           H  
ATOM   1440 HG13 ILE A  96      10.006  23.019   3.158  1.00  0.00           H  
ATOM   1441 HG21 ILE A  96       9.900  21.546  -0.363  1.00  0.00           H  
ATOM   1442 HG22 ILE A  96       9.183  20.438   0.803  1.00  0.00           H  
ATOM   1443 HG23 ILE A  96       8.147  21.379  -0.269  1.00  0.00           H  
ATOM   1444 HD11 ILE A  96       8.186  21.479   3.757  1.00  0.00           H  
ATOM   1445 HD12 ILE A  96       9.036  20.183   2.915  1.00  0.00           H  
ATOM   1446 HD13 ILE A  96       9.761  20.936   4.334  1.00  0.00           H  
ATOM   1447  N   LYS A  97       7.606  24.551  -0.551  1.00  0.00           N  
ATOM   1448  CA  LYS A  97       6.830  24.828  -1.755  1.00  0.00           C  
ATOM   1449  C   LYS A  97       7.616  25.716  -2.715  1.00  0.00           C  
ATOM   1450  O   LYS A  97       7.655  25.463  -3.919  1.00  0.00           O  
ATOM   1451  CB  LYS A  97       5.505  25.501  -1.388  1.00  0.00           C  
ATOM   1452  CG  LYS A  97       4.378  25.191  -2.359  1.00  0.00           C  
ATOM   1453  CD  LYS A  97       3.025  25.568  -1.780  1.00  0.00           C  
ATOM   1454  CE  LYS A  97       2.605  24.611  -0.675  1.00  0.00           C  
ATOM   1455  NZ  LYS A  97       1.159  24.746  -0.345  1.00  0.00           N  
ATOM   1456  H   LYS A  97       7.207  24.733   0.326  1.00  0.00           H  
ATOM   1457  HA  LYS A  97       6.624  23.887  -2.241  1.00  0.00           H  
ATOM   1458  HB2 LYS A  97       5.207  25.170  -0.405  1.00  0.00           H  
ATOM   1459  HB3 LYS A  97       5.651  26.571  -1.371  1.00  0.00           H  
ATOM   1460  HG2 LYS A  97       4.536  25.748  -3.271  1.00  0.00           H  
ATOM   1461  HG3 LYS A  97       4.383  24.132  -2.576  1.00  0.00           H  
ATOM   1462  HD2 LYS A  97       3.083  26.567  -1.373  1.00  0.00           H  
ATOM   1463  HD3 LYS A  97       2.286  25.541  -2.568  1.00  0.00           H  
ATOM   1464  HE2 LYS A  97       2.798  23.600  -1.000  1.00  0.00           H  
ATOM   1465  HE3 LYS A  97       3.188  24.823   0.208  1.00  0.00           H  
ATOM   1466  HZ1 LYS A  97       0.708  23.809  -0.326  1.00  0.00           H  
ATOM   1467  HZ2 LYS A  97       0.683  25.333  -1.058  1.00  0.00           H  
ATOM   1468  HZ3 LYS A  97       1.045  25.192   0.587  1.00  0.00           H  
ATOM   1469  N   THR A  98       8.241  26.757  -2.173  1.00  0.00           N  
ATOM   1470  CA  THR A  98       9.025  27.683  -2.981  1.00  0.00           C  
ATOM   1471  C   THR A  98      10.366  27.071  -3.370  1.00  0.00           C  
ATOM   1472  O   THR A  98      10.965  27.454  -4.375  1.00  0.00           O  
ATOM   1473  CB  THR A  98       9.274  29.007  -2.236  1.00  0.00           C  
ATOM   1474  OG1 THR A  98      10.053  28.767  -1.058  1.00  0.00           O  
ATOM   1475  CG2 THR A  98       7.959  29.669  -1.854  1.00  0.00           C  
ATOM   1476  H   THR A  98       8.171  26.906  -1.207  1.00  0.00           H  
ATOM   1477  HA  THR A  98       8.465  27.899  -3.879  1.00  0.00           H  
ATOM   1478  HB  THR A  98       9.820  29.673  -2.889  1.00  0.00           H  
ATOM   1479  HG1 THR A  98      10.930  28.468  -1.310  1.00  0.00           H  
ATOM   1480 HG21 THR A  98       7.178  28.924  -1.816  1.00  0.00           H  
ATOM   1481 HG22 THR A  98       7.707  30.419  -2.590  1.00  0.00           H  
ATOM   1482 HG23 THR A  98       8.059  30.134  -0.885  1.00  0.00           H  
ATOM   1483  N   ALA A  99      10.833  26.118  -2.570  1.00  0.00           N  
ATOM   1484  CA  ALA A  99      12.102  25.453  -2.833  1.00  0.00           C  
ATOM   1485  C   ALA A  99      12.024  24.601  -4.095  1.00  0.00           C  
ATOM   1486  O   ALA A  99      10.967  24.085  -4.461  1.00  0.00           O  
ATOM   1487  CB  ALA A  99      12.506  24.597  -1.641  1.00  0.00           C  
ATOM   1488  H   ALA A  99      10.309  25.857  -1.784  1.00  0.00           H  
ATOM   1489  HA  ALA A  99      12.855  26.214  -2.971  1.00  0.00           H  
ATOM   1490  HB1 ALA A  99      12.820  25.237  -0.829  1.00  0.00           H  
ATOM   1491  HB2 ALA A  99      11.663  24.000  -1.324  1.00  0.00           H  
ATOM   1492  HB3 ALA A  99      13.321  23.948  -1.924  1.00  0.00           H  
ATOM   1493  N   PRO A 100      13.166  24.449  -4.780  1.00  0.00           N  
ATOM   1494  CA  PRO A 100      13.253  23.661  -6.012  1.00  0.00           C  
ATOM   1495  C   PRO A 100      13.094  22.166  -5.757  1.00  0.00           C  
ATOM   1496  O   PRO A 100      13.090  21.720  -4.609  1.00  0.00           O  
ATOM   1497  CB  PRO A 100      14.660  23.967  -6.532  1.00  0.00           C  
ATOM   1498  CG  PRO A 100      15.437  24.348  -5.320  1.00  0.00           C  
ATOM   1499  CD  PRO A 100      14.464  25.036  -4.403  1.00  0.00           C  
ATOM   1500  HA  PRO A 100      12.522  23.980  -6.740  1.00  0.00           H  
ATOM   1501  HB2 PRO A 100      15.071  23.087  -7.006  1.00  0.00           H  
ATOM   1502  HB3 PRO A 100      14.615  24.778  -7.243  1.00  0.00           H  
ATOM   1503  HG2 PRO A 100      15.836  23.464  -4.847  1.00  0.00           H  
ATOM   1504  HG3 PRO A 100      16.235  25.022  -5.592  1.00  0.00           H  
ATOM   1505  HD2 PRO A 100      14.699  24.821  -3.371  1.00  0.00           H  
ATOM   1506  HD3 PRO A 100      14.469  26.102  -4.579  1.00  0.00           H  
ATOM   1507  N   SER A 101      12.964  21.396  -6.833  1.00  0.00           N  
ATOM   1508  CA  SER A 101      12.802  19.951  -6.723  1.00  0.00           C  
ATOM   1509  C   SER A 101      13.645  19.394  -5.581  1.00  0.00           C  
ATOM   1510  O   SER A 101      13.122  18.790  -4.644  1.00  0.00           O  
ATOM   1511  CB  SER A 101      13.192  19.273  -8.038  1.00  0.00           C  
ATOM   1512  OG  SER A 101      12.458  18.075  -8.231  1.00  0.00           O  
ATOM   1513  H   SER A 101      12.976  21.811  -7.720  1.00  0.00           H  
ATOM   1514  HA  SER A 101      11.761  19.749  -6.519  1.00  0.00           H  
ATOM   1515  HB2 SER A 101      12.988  19.942  -8.860  1.00  0.00           H  
ATOM   1516  HB3 SER A 101      14.246  19.036  -8.020  1.00  0.00           H  
ATOM   1517  HG  SER A 101      12.503  17.817  -9.155  1.00  0.00           H  
ATOM   1518  N   LYS A 102      14.955  19.601  -5.665  1.00  0.00           N  
ATOM   1519  CA  LYS A 102      15.873  19.121  -4.640  1.00  0.00           C  
ATOM   1520  C   LYS A 102      15.883  20.059  -3.436  1.00  0.00           C  
ATOM   1521  O   LYS A 102      16.099  21.264  -3.577  1.00  0.00           O  
ATOM   1522  CB  LYS A 102      17.288  18.995  -5.211  1.00  0.00           C  
ATOM   1523  CG  LYS A 102      18.153  17.987  -4.474  1.00  0.00           C  
ATOM   1524  CD  LYS A 102      19.217  17.395  -5.384  1.00  0.00           C  
ATOM   1525  CE  LYS A 102      18.708  16.154  -6.103  1.00  0.00           C  
ATOM   1526  NZ  LYS A 102      19.760  15.537  -6.956  1.00  0.00           N  
ATOM   1527  H   LYS A 102      15.313  20.089  -6.437  1.00  0.00           H  
ATOM   1528  HA  LYS A 102      15.535  18.148  -4.320  1.00  0.00           H  
ATOM   1529  HB2 LYS A 102      17.219  18.691  -6.246  1.00  0.00           H  
ATOM   1530  HB3 LYS A 102      17.772  19.959  -5.159  1.00  0.00           H  
ATOM   1531  HG2 LYS A 102      18.638  18.480  -3.645  1.00  0.00           H  
ATOM   1532  HG3 LYS A 102      17.524  17.190  -4.104  1.00  0.00           H  
ATOM   1533  HD2 LYS A 102      19.499  18.132  -6.121  1.00  0.00           H  
ATOM   1534  HD3 LYS A 102      20.079  17.128  -4.790  1.00  0.00           H  
ATOM   1535  HE2 LYS A 102      18.388  15.434  -5.365  1.00  0.00           H  
ATOM   1536  HE3 LYS A 102      17.869  16.432  -6.723  1.00  0.00           H  
ATOM   1537  HZ1 LYS A 102      20.306  14.844  -6.405  1.00  0.00           H  
ATOM   1538  HZ2 LYS A 102      20.409  16.269  -7.309  1.00  0.00           H  
ATOM   1539  HZ3 LYS A 102      19.325  15.055  -7.768  1.00  0.00           H  
ATOM   1540  N   VAL A 103      15.648  19.499  -2.254  1.00  0.00           N  
ATOM   1541  CA  VAL A 103      15.632  20.285  -1.026  1.00  0.00           C  
ATOM   1542  C   VAL A 103      16.393  19.578   0.089  1.00  0.00           C  
ATOM   1543  O   VAL A 103      16.159  18.402   0.368  1.00  0.00           O  
ATOM   1544  CB  VAL A 103      14.192  20.559  -0.554  1.00  0.00           C  
ATOM   1545  CG1 VAL A 103      14.194  21.443   0.684  1.00  0.00           C  
ATOM   1546  CG2 VAL A 103      13.378  21.195  -1.671  1.00  0.00           C  
ATOM   1547  H   VAL A 103      15.483  18.535  -2.206  1.00  0.00           H  
ATOM   1548  HA  VAL A 103      16.108  21.233  -1.229  1.00  0.00           H  
ATOM   1549  HB  VAL A 103      13.733  19.616  -0.296  1.00  0.00           H  
ATOM   1550 HG11 VAL A 103      15.136  21.333   1.202  1.00  0.00           H  
ATOM   1551 HG12 VAL A 103      14.061  22.474   0.392  1.00  0.00           H  
ATOM   1552 HG13 VAL A 103      13.388  21.147   1.339  1.00  0.00           H  
ATOM   1553 HG21 VAL A 103      14.045  21.645  -2.391  1.00  0.00           H  
ATOM   1554 HG22 VAL A 103      12.780  20.438  -2.158  1.00  0.00           H  
ATOM   1555 HG23 VAL A 103      12.730  21.954  -1.258  1.00  0.00           H  
ATOM   1556  N   LYS A 104      17.308  20.302   0.725  1.00  0.00           N  
ATOM   1557  CA  LYS A 104      18.106  19.746   1.812  1.00  0.00           C  
ATOM   1558  C   LYS A 104      17.385  19.897   3.147  1.00  0.00           C  
ATOM   1559  O   LYS A 104      17.181  21.010   3.633  1.00  0.00           O  
ATOM   1560  CB  LYS A 104      19.470  20.436   1.876  1.00  0.00           C  
ATOM   1561  CG  LYS A 104      20.516  19.646   2.642  1.00  0.00           C  
ATOM   1562  CD  LYS A 104      21.731  20.499   2.968  1.00  0.00           C  
ATOM   1563  CE  LYS A 104      21.570  21.211   4.302  1.00  0.00           C  
ATOM   1564  NZ  LYS A 104      22.298  22.510   4.329  1.00  0.00           N  
ATOM   1565  H   LYS A 104      17.451  21.235   0.457  1.00  0.00           H  
ATOM   1566  HA  LYS A 104      18.253  18.696   1.611  1.00  0.00           H  
ATOM   1567  HB2 LYS A 104      19.830  20.590   0.869  1.00  0.00           H  
ATOM   1568  HB3 LYS A 104      19.351  21.397   2.358  1.00  0.00           H  
ATOM   1569  HG2 LYS A 104      20.082  19.290   3.564  1.00  0.00           H  
ATOM   1570  HG3 LYS A 104      20.829  18.804   2.040  1.00  0.00           H  
ATOM   1571  HD2 LYS A 104      22.604  19.864   3.016  1.00  0.00           H  
ATOM   1572  HD3 LYS A 104      21.862  21.236   2.188  1.00  0.00           H  
ATOM   1573  HE2 LYS A 104      20.521  21.394   4.473  1.00  0.00           H  
ATOM   1574  HE3 LYS A 104      21.958  20.574   5.084  1.00  0.00           H  
ATOM   1575  HZ1 LYS A 104      23.326  22.343   4.307  1.00  0.00           H  
ATOM   1576  HZ2 LYS A 104      22.062  23.035   5.194  1.00  0.00           H  
ATOM   1577  HZ3 LYS A 104      22.034  23.085   3.503  1.00  0.00           H  
ATOM   1578  N   LEU A 105      17.002  18.770   3.738  1.00  0.00           N  
ATOM   1579  CA  LEU A 105      16.304  18.776   5.019  1.00  0.00           C  
ATOM   1580  C   LEU A 105      17.262  18.452   6.162  1.00  0.00           C  
ATOM   1581  O   LEU A 105      17.913  17.408   6.164  1.00  0.00           O  
ATOM   1582  CB  LEU A 105      15.155  17.767   5.001  1.00  0.00           C  
ATOM   1583  CG  LEU A 105      14.169  17.893   3.840  1.00  0.00           C  
ATOM   1584  CD1 LEU A 105      13.566  16.539   3.500  1.00  0.00           C  
ATOM   1585  CD2 LEU A 105      13.075  18.897   4.176  1.00  0.00           C  
ATOM   1586  H   LEU A 105      17.193  17.913   3.303  1.00  0.00           H  
ATOM   1587  HA  LEU A 105      15.902  19.766   5.172  1.00  0.00           H  
ATOM   1588  HB2 LEU A 105      15.583  16.777   4.963  1.00  0.00           H  
ATOM   1589  HB3 LEU A 105      14.601  17.882   5.922  1.00  0.00           H  
ATOM   1590  HG  LEU A 105      14.696  18.253   2.966  1.00  0.00           H  
ATOM   1591 HD11 LEU A 105      12.676  16.679   2.906  1.00  0.00           H  
ATOM   1592 HD12 LEU A 105      13.312  16.019   4.413  1.00  0.00           H  
ATOM   1593 HD13 LEU A 105      14.284  15.956   2.943  1.00  0.00           H  
ATOM   1594 HD21 LEU A 105      12.416  18.474   4.920  1.00  0.00           H  
ATOM   1595 HD22 LEU A 105      12.510  19.127   3.284  1.00  0.00           H  
ATOM   1596 HD23 LEU A 105      13.522  19.801   4.563  1.00  0.00           H  
ATOM   1597  N   VAL A 106      17.341  19.356   7.134  1.00  0.00           N  
ATOM   1598  CA  VAL A 106      18.216  19.165   8.285  1.00  0.00           C  
ATOM   1599  C   VAL A 106      17.410  19.034   9.572  1.00  0.00           C  
ATOM   1600  O   VAL A 106      16.953  20.028  10.136  1.00  0.00           O  
ATOM   1601  CB  VAL A 106      19.211  20.331   8.431  1.00  0.00           C  
ATOM   1602  CG1 VAL A 106      20.069  20.148   9.675  1.00  0.00           C  
ATOM   1603  CG2 VAL A 106      20.078  20.451   7.188  1.00  0.00           C  
ATOM   1604  H   VAL A 106      16.797  20.169   7.077  1.00  0.00           H  
ATOM   1605  HA  VAL A 106      18.779  18.256   8.129  1.00  0.00           H  
ATOM   1606  HB  VAL A 106      18.648  21.247   8.543  1.00  0.00           H  
ATOM   1607 HG11 VAL A 106      21.040  19.772   9.389  1.00  0.00           H  
ATOM   1608 HG12 VAL A 106      20.183  21.097  10.177  1.00  0.00           H  
ATOM   1609 HG13 VAL A 106      19.592  19.443  10.340  1.00  0.00           H  
ATOM   1610 HG21 VAL A 106      20.969  19.853   7.312  1.00  0.00           H  
ATOM   1611 HG22 VAL A 106      19.527  20.101   6.328  1.00  0.00           H  
ATOM   1612 HG23 VAL A 106      20.356  21.484   7.040  1.00  0.00           H  
ATOM   1613  N   PHE A 107      17.239  17.799  10.034  1.00  0.00           N  
ATOM   1614  CA  PHE A 107      16.487  17.537  11.255  1.00  0.00           C  
ATOM   1615  C   PHE A 107      17.312  16.702  12.232  1.00  0.00           C  
ATOM   1616  O   PHE A 107      18.466  16.371  11.961  1.00  0.00           O  
ATOM   1617  CB  PHE A 107      15.179  16.814  10.928  1.00  0.00           C  
ATOM   1618  CG  PHE A 107      15.378  15.419  10.409  1.00  0.00           C  
ATOM   1619  CD1 PHE A 107      15.701  14.384  11.271  1.00  0.00           C  
ATOM   1620  CD2 PHE A 107      15.240  15.142   9.058  1.00  0.00           C  
ATOM   1621  CE1 PHE A 107      15.886  13.099  10.795  1.00  0.00           C  
ATOM   1622  CE2 PHE A 107      15.423  13.859   8.577  1.00  0.00           C  
ATOM   1623  CZ  PHE A 107      15.745  12.837   9.447  1.00  0.00           C  
ATOM   1624  H   PHE A 107      17.628  17.046   9.539  1.00  0.00           H  
ATOM   1625  HA  PHE A 107      16.260  18.486  11.713  1.00  0.00           H  
ATOM   1626  HB2 PHE A 107      14.578  16.752  11.822  1.00  0.00           H  
ATOM   1627  HB3 PHE A 107      14.644  17.376  10.178  1.00  0.00           H  
ATOM   1628  HD1 PHE A 107      15.810  14.587  12.326  1.00  0.00           H  
ATOM   1629  HD2 PHE A 107      14.988  15.943   8.377  1.00  0.00           H  
ATOM   1630  HE1 PHE A 107      16.137  12.301  11.477  1.00  0.00           H  
ATOM   1631  HE2 PHE A 107      15.312  13.658   7.522  1.00  0.00           H  
ATOM   1632  HZ  PHE A 107      15.889  11.834   9.072  1.00  0.00           H  
ATOM   1633  N   ILE A 108      16.711  16.369  13.369  1.00  0.00           N  
ATOM   1634  CA  ILE A 108      17.388  15.575  14.385  1.00  0.00           C  
ATOM   1635  C   ILE A 108      16.579  14.331  14.741  1.00  0.00           C  
ATOM   1636  O   ILE A 108      15.349  14.360  14.746  1.00  0.00           O  
ATOM   1637  CB  ILE A 108      17.638  16.393  15.666  1.00  0.00           C  
ATOM   1638  CG1 ILE A 108      18.432  15.566  16.679  1.00  0.00           C  
ATOM   1639  CG2 ILE A 108      16.318  16.853  16.267  1.00  0.00           C  
ATOM   1640  CD1 ILE A 108      19.281  16.403  17.610  1.00  0.00           C  
ATOM   1641  H   ILE A 108      15.790  16.664  13.527  1.00  0.00           H  
ATOM   1642  HA  ILE A 108      18.344  15.267  13.986  1.00  0.00           H  
ATOM   1643  HB  ILE A 108      18.209  17.269  15.400  1.00  0.00           H  
ATOM   1644 HG12 ILE A 108      17.746  14.994  17.283  1.00  0.00           H  
ATOM   1645 HG13 ILE A 108      19.086  14.891  16.147  1.00  0.00           H  
ATOM   1646 HG21 ILE A 108      15.544  16.141  16.023  1.00  0.00           H  
ATOM   1647 HG22 ILE A 108      16.416  16.924  17.340  1.00  0.00           H  
ATOM   1648 HG23 ILE A 108      16.057  17.821  15.865  1.00  0.00           H  
ATOM   1649 HD11 ILE A 108      20.196  16.685  17.107  1.00  0.00           H  
ATOM   1650 HD12 ILE A 108      18.737  17.291  17.893  1.00  0.00           H  
ATOM   1651 HD13 ILE A 108      19.520  15.830  18.493  1.00  0.00           H  
ATOM   1652  N   ARG A 109      17.279  13.241  15.038  1.00  0.00           N  
ATOM   1653  CA  ARG A 109      16.627  11.987  15.395  1.00  0.00           C  
ATOM   1654  C   ARG A 109      16.758  11.713  16.890  1.00  0.00           C  
ATOM   1655  O   ARG A 109      17.851  11.457  17.391  1.00  0.00           O  
ATOM   1656  CB  ARG A 109      17.230  10.829  14.599  1.00  0.00           C  
ATOM   1657  CG  ARG A 109      16.414   9.549  14.672  1.00  0.00           C  
ATOM   1658  CD  ARG A 109      16.730   8.620  13.511  1.00  0.00           C  
ATOM   1659  NE  ARG A 109      15.612   7.733  13.199  1.00  0.00           N  
ATOM   1660  CZ  ARG A 109      15.375   6.595  13.844  1.00  0.00           C  
ATOM   1661  NH1 ARG A 109      16.174   6.208  14.829  1.00  0.00           N  
ATOM   1662  NH2 ARG A 109      14.337   5.841  13.502  1.00  0.00           N  
ATOM   1663  H   ARG A 109      18.259  13.281  15.015  1.00  0.00           H  
ATOM   1664  HA  ARG A 109      15.580  12.076  15.147  1.00  0.00           H  
ATOM   1665  HB2 ARG A 109      17.307  11.121  13.562  1.00  0.00           H  
ATOM   1666  HB3 ARG A 109      18.219  10.622  14.980  1.00  0.00           H  
ATOM   1667  HG2 ARG A 109      16.641   9.041  15.597  1.00  0.00           H  
ATOM   1668  HG3 ARG A 109      15.364   9.801  14.645  1.00  0.00           H  
ATOM   1669  HD2 ARG A 109      16.956   9.217  12.640  1.00  0.00           H  
ATOM   1670  HD3 ARG A 109      17.590   8.021  13.771  1.00  0.00           H  
ATOM   1671  HE  ARG A 109      15.009   7.999  12.475  1.00  0.00           H  
ATOM   1672 HH11 ARG A 109      16.956   6.774  15.088  1.00  0.00           H  
ATOM   1673 HH12 ARG A 109      15.993   5.352  15.312  1.00  0.00           H  
ATOM   1674 HH21 ARG A 109      13.733   6.130  12.761  1.00  0.00           H  
ATOM   1675 HH22 ARG A 109      14.160   4.986  13.987  1.00  0.00           H  
ATOM   1676  N   ASN A 110      15.633  11.770  17.596  1.00  0.00           N  
ATOM   1677  CA  ASN A 110      15.622  11.529  19.035  1.00  0.00           C  
ATOM   1678  C   ASN A 110      14.484  10.589  19.420  1.00  0.00           C  
ATOM   1679  O   ASN A 110      13.317  10.866  19.143  1.00  0.00           O  
ATOM   1680  CB  ASN A 110      15.487  12.850  19.794  1.00  0.00           C  
ATOM   1681  CG  ASN A 110      15.633  12.674  21.293  1.00  0.00           C  
ATOM   1682  OD1 ASN A 110      15.807  11.558  21.784  1.00  0.00           O  
ATOM   1683  ND2 ASN A 110      15.560  13.777  22.029  1.00  0.00           N  
ATOM   1684  H   ASN A 110      14.792  11.978  17.141  1.00  0.00           H  
ATOM   1685  HA  ASN A 110      16.561  11.065  19.301  1.00  0.00           H  
ATOM   1686  HB2 ASN A 110      16.253  13.532  19.455  1.00  0.00           H  
ATOM   1687  HB3 ASN A 110      14.516  13.277  19.593  1.00  0.00           H  
ATOM   1688 HD21 ASN A 110      15.419  14.631  21.569  1.00  0.00           H  
ATOM   1689 HD22 ASN A 110      15.651  13.692  23.000  1.00  0.00           H  
ATOM   1690  N   GLU A 111      14.831   9.478  20.063  1.00  0.00           N  
ATOM   1691  CA  GLU A 111      13.838   8.498  20.485  1.00  0.00           C  
ATOM   1692  C   GLU A 111      12.889   9.097  21.519  1.00  0.00           C  
ATOM   1693  O   GLU A 111      11.867   8.499  21.860  1.00  0.00           O  
ATOM   1694  CB  GLU A 111      14.525   7.260  21.064  1.00  0.00           C  
ATOM   1695  CG  GLU A 111      15.235   7.518  22.382  1.00  0.00           C  
ATOM   1696  CD  GLU A 111      16.606   8.140  22.194  1.00  0.00           C  
ATOM   1697  OE1 GLU A 111      17.545   7.404  21.825  1.00  0.00           O  
ATOM   1698  OE2 GLU A 111      16.739   9.362  22.414  1.00  0.00           O  
ATOM   1699  H   GLU A 111      15.777   9.313  20.256  1.00  0.00           H  
ATOM   1700  HA  GLU A 111      13.267   8.208  19.616  1.00  0.00           H  
ATOM   1701  HB2 GLU A 111      13.782   6.492  21.224  1.00  0.00           H  
ATOM   1702  HB3 GLU A 111      15.252   6.900  20.352  1.00  0.00           H  
ATOM   1703  HG2 GLU A 111      14.633   8.188  22.977  1.00  0.00           H  
ATOM   1704  HG3 GLU A 111      15.351   6.580  22.905  1.00  0.00           H  
ATOM   1705  N   ASP A 112      13.234  10.281  22.014  1.00  0.00           N  
ATOM   1706  CA  ASP A 112      12.413  10.961  23.010  1.00  0.00           C  
ATOM   1707  C   ASP A 112      11.496  11.986  22.348  1.00  0.00           C  
ATOM   1708  O   ASP A 112      10.500  12.411  22.933  1.00  0.00           O  
ATOM   1709  CB  ASP A 112      13.300  11.648  24.049  1.00  0.00           C  
ATOM   1710  CG  ASP A 112      13.830  10.680  25.088  1.00  0.00           C  
ATOM   1711  OD1 ASP A 112      14.334   9.606  24.697  1.00  0.00           O  
ATOM   1712  OD2 ASP A 112      13.741  10.996  26.293  1.00  0.00           O  
ATOM   1713  H   ASP A 112      14.059  10.706  21.703  1.00  0.00           H  
ATOM   1714  HA  ASP A 112      11.805  10.219  23.502  1.00  0.00           H  
ATOM   1715  HB2 ASP A 112      14.140  12.107  23.549  1.00  0.00           H  
ATOM   1716  HB3 ASP A 112      12.726  12.412  24.554  1.00  0.00           H  
ATOM   1717  N   ALA A 113      11.841  12.379  21.126  1.00  0.00           N  
ATOM   1718  CA  ALA A 113      11.048  13.352  20.386  1.00  0.00           C  
ATOM   1719  C   ALA A 113       9.572  12.965  20.373  1.00  0.00           C  
ATOM   1720  O   ALA A 113       8.706  13.772  20.710  1.00  0.00           O  
ATOM   1721  CB  ALA A 113      11.571  13.487  18.963  1.00  0.00           C  
ATOM   1722  H   ALA A 113      12.646  12.004  20.713  1.00  0.00           H  
ATOM   1723  HA  ALA A 113      11.154  14.310  20.874  1.00  0.00           H  
ATOM   1724  HB1 ALA A 113      12.610  13.783  18.989  1.00  0.00           H  
ATOM   1725  HB2 ALA A 113      11.480  12.538  18.455  1.00  0.00           H  
ATOM   1726  HB3 ALA A 113      10.997  14.234  18.438  1.00  0.00           H  
ATOM   1727  N   VAL A 114       9.294  11.726  19.983  1.00  0.00           N  
ATOM   1728  CA  VAL A 114       7.924  11.231  19.928  1.00  0.00           C  
ATOM   1729  C   VAL A 114       7.166  11.570  21.206  1.00  0.00           C  
ATOM   1730  O   VAL A 114       5.952  11.771  21.184  1.00  0.00           O  
ATOM   1731  CB  VAL A 114       7.885   9.707  19.712  1.00  0.00           C  
ATOM   1732  CG1 VAL A 114       8.464   9.345  18.352  1.00  0.00           C  
ATOM   1733  CG2 VAL A 114       8.635   8.991  20.826  1.00  0.00           C  
ATOM   1734  H   VAL A 114      10.028  11.129  19.727  1.00  0.00           H  
ATOM   1735  HA  VAL A 114       7.432  11.704  19.092  1.00  0.00           H  
ATOM   1736  HB  VAL A 114       6.855   9.386  19.736  1.00  0.00           H  
ATOM   1737 HG11 VAL A 114       8.141   8.352  18.076  1.00  0.00           H  
ATOM   1738 HG12 VAL A 114       8.119  10.055  17.614  1.00  0.00           H  
ATOM   1739 HG13 VAL A 114       9.542   9.372  18.401  1.00  0.00           H  
ATOM   1740 HG21 VAL A 114       8.530   9.548  21.745  1.00  0.00           H  
ATOM   1741 HG22 VAL A 114       8.225   8.001  20.958  1.00  0.00           H  
ATOM   1742 HG23 VAL A 114       9.681   8.917  20.567  1.00  0.00           H  
ATOM   1743  N   ASN A 115       7.889  11.635  22.319  1.00  0.00           N  
ATOM   1744  CA  ASN A 115       7.284  11.952  23.607  1.00  0.00           C  
ATOM   1745  C   ASN A 115       7.100  13.457  23.766  1.00  0.00           C  
ATOM   1746  O   ASN A 115       6.217  13.910  24.495  1.00  0.00           O  
ATOM   1747  CB  ASN A 115       8.149  11.408  24.747  1.00  0.00           C  
ATOM   1748  CG  ASN A 115       8.344   9.907  24.661  1.00  0.00           C  
ATOM   1749  OD1 ASN A 115       7.480   9.186  24.160  1.00  0.00           O  
ATOM   1750  ND2 ASN A 115       9.482   9.429  25.149  1.00  0.00           N  
ATOM   1751  H   ASN A 115       8.854  11.465  22.272  1.00  0.00           H  
ATOM   1752  HA  ASN A 115       6.316  11.476  23.644  1.00  0.00           H  
ATOM   1753  HB2 ASN A 115       9.120  11.880  24.710  1.00  0.00           H  
ATOM   1754  HB3 ASN A 115       7.678  11.639  25.690  1.00  0.00           H  
ATOM   1755 HD21 ASN A 115      10.123  10.063  25.533  1.00  0.00           H  
ATOM   1756 HD22 ASN A 115       9.633   8.462  25.106  1.00  0.00           H  
ATOM   1757  N   GLN A 116       7.939  14.227  23.080  1.00  0.00           N  
ATOM   1758  CA  GLN A 116       7.868  15.682  23.146  1.00  0.00           C  
ATOM   1759  C   GLN A 116       6.786  16.216  22.213  1.00  0.00           C  
ATOM   1760  O   GLN A 116       5.904  16.963  22.635  1.00  0.00           O  
ATOM   1761  CB  GLN A 116       9.221  16.296  22.783  1.00  0.00           C  
ATOM   1762  CG  GLN A 116      10.338  15.917  23.743  1.00  0.00           C  
ATOM   1763  CD  GLN A 116      11.566  16.790  23.581  1.00  0.00           C  
ATOM   1764  OE1 GLN A 116      11.493  17.891  23.035  1.00  0.00           O  
ATOM   1765  NE2 GLN A 116      12.707  16.302  24.057  1.00  0.00           N  
ATOM   1766  H   GLN A 116       8.621  13.807  22.517  1.00  0.00           H  
ATOM   1767  HA  GLN A 116       7.618  15.956  24.160  1.00  0.00           H  
ATOM   1768  HB2 GLN A 116       9.498  15.968  21.793  1.00  0.00           H  
ATOM   1769  HB3 GLN A 116       9.125  17.372  22.783  1.00  0.00           H  
ATOM   1770  HG2 GLN A 116       9.975  16.018  24.755  1.00  0.00           H  
ATOM   1771  HG3 GLN A 116      10.618  14.890  23.562  1.00  0.00           H  
ATOM   1772 HE21 GLN A 116      12.690  15.417  24.478  1.00  0.00           H  
ATOM   1773 HE22 GLN A 116      13.516  16.845  23.965  1.00  0.00           H  
ATOM   1774  N   MET A 117       6.863  15.831  20.944  1.00  0.00           N  
ATOM   1775  CA  MET A 117       5.890  16.271  19.952  1.00  0.00           C  
ATOM   1776  C   MET A 117       4.474  16.219  20.518  1.00  0.00           C  
ATOM   1777  O   MET A 117       4.235  15.612  21.561  1.00  0.00           O  
ATOM   1778  CB  MET A 117       5.981  15.403  18.696  1.00  0.00           C  
ATOM   1779  CG  MET A 117       6.181  13.926  18.991  1.00  0.00           C  
ATOM   1780  SD  MET A 117       5.441  12.860  17.739  1.00  0.00           S  
ATOM   1781  CE  MET A 117       6.818  12.657  16.612  1.00  0.00           C  
ATOM   1782  H   MET A 117       7.590  15.235  20.667  1.00  0.00           H  
ATOM   1783  HA  MET A 117       6.122  17.293  19.690  1.00  0.00           H  
ATOM   1784  HB2 MET A 117       5.069  15.515  18.128  1.00  0.00           H  
ATOM   1785  HB3 MET A 117       6.813  15.743  18.096  1.00  0.00           H  
ATOM   1786  HG2 MET A 117       7.240  13.721  19.037  1.00  0.00           H  
ATOM   1787  HG3 MET A 117       5.730  13.701  19.947  1.00  0.00           H  
ATOM   1788  HE1 MET A 117       7.364  11.761  16.868  1.00  0.00           H  
ATOM   1789  HE2 MET A 117       6.448  12.576  15.601  1.00  0.00           H  
ATOM   1790  HE3 MET A 117       7.475  13.511  16.688  1.00  0.00           H  
ATOM   1791  N   ALA A 118       3.540  16.861  19.824  1.00  0.00           N  
ATOM   1792  CA  ALA A 118       2.148  16.886  20.257  1.00  0.00           C  
ATOM   1793  C   ALA A 118       1.353  15.755  19.614  1.00  0.00           C  
ATOM   1794  O   ALA A 118       0.378  15.266  20.185  1.00  0.00           O  
ATOM   1795  CB  ALA A 118       1.517  18.231  19.929  1.00  0.00           C  
ATOM   1796  H   ALA A 118       3.792  17.328  18.999  1.00  0.00           H  
ATOM   1797  HA  ALA A 118       2.131  16.760  21.330  1.00  0.00           H  
ATOM   1798  HB1 ALA A 118       1.883  18.574  18.971  1.00  0.00           H  
ATOM   1799  HB2 ALA A 118       0.443  18.123  19.885  1.00  0.00           H  
ATOM   1800  HB3 ALA A 118       1.778  18.947  20.692  1.00  0.00           H  
ATOM   1801  N   SER A 119       1.775  15.343  18.422  1.00  0.00           N  
ATOM   1802  CA  SER A 119       1.099  14.272  17.700  1.00  0.00           C  
ATOM   1803  C   SER A 119      -0.379  14.597  17.504  1.00  0.00           C  
ATOM   1804  O   SER A 119      -1.253  13.810  17.864  1.00  0.00           O  
ATOM   1805  CB  SER A 119       1.246  12.949  18.454  1.00  0.00           C  
ATOM   1806  OG  SER A 119       0.977  11.846  17.603  1.00  0.00           O  
ATOM   1807  H   SER A 119       2.559  15.772  18.019  1.00  0.00           H  
ATOM   1808  HA  SER A 119       1.567  14.179  16.732  1.00  0.00           H  
ATOM   1809  HB2 SER A 119       2.253  12.861  18.830  1.00  0.00           H  
ATOM   1810  HB3 SER A 119       0.549  12.929  19.279  1.00  0.00           H  
ATOM   1811  HG  SER A 119       1.558  11.117  17.834  1.00  0.00           H  
ATOM   1812  N   GLY A 120      -0.650  15.766  16.929  1.00  0.00           N  
ATOM   1813  CA  GLY A 120      -2.021  16.176  16.694  1.00  0.00           C  
ATOM   1814  C   GLY A 120      -2.122  17.321  15.705  1.00  0.00           C  
ATOM   1815  O   GLY A 120      -2.246  18.487  16.083  1.00  0.00           O  
ATOM   1816  H   GLY A 120       0.088  16.353  16.662  1.00  0.00           H  
ATOM   1817  HA2 GLY A 120      -2.577  15.334  16.312  1.00  0.00           H  
ATOM   1818  HA3 GLY A 120      -2.458  16.487  17.632  1.00  0.00           H  
ATOM   1819  N   PRO A 121      -2.069  16.992  14.405  1.00  0.00           N  
ATOM   1820  CA  PRO A 121      -2.153  17.987  13.333  1.00  0.00           C  
ATOM   1821  C   PRO A 121      -3.543  18.603  13.221  1.00  0.00           C  
ATOM   1822  O   PRO A 121      -3.706  19.700  12.686  1.00  0.00           O  
ATOM   1823  CB  PRO A 121      -1.822  17.182  12.074  1.00  0.00           C  
ATOM   1824  CG  PRO A 121      -2.195  15.780  12.414  1.00  0.00           C  
ATOM   1825  CD  PRO A 121      -1.923  15.623  13.883  1.00  0.00           C  
ATOM   1826  HA  PRO A 121      -1.422  18.773  13.463  1.00  0.00           H  
ATOM   1827  HB2 PRO A 121      -2.401  17.555  11.242  1.00  0.00           H  
ATOM   1828  HB3 PRO A 121      -0.768  17.267  11.855  1.00  0.00           H  
ATOM   1829  HG2 PRO A 121      -3.241  15.618  12.206  1.00  0.00           H  
ATOM   1830  HG3 PRO A 121      -1.587  15.091  11.845  1.00  0.00           H  
ATOM   1831  HD2 PRO A 121      -2.648  14.960  14.333  1.00  0.00           H  
ATOM   1832  HD3 PRO A 121      -0.921  15.254  14.045  1.00  0.00           H  
ATOM   1833  N   SER A 122      -4.544  17.890  13.728  1.00  0.00           N  
ATOM   1834  CA  SER A 122      -5.922  18.365  13.681  1.00  0.00           C  
ATOM   1835  C   SER A 122      -6.298  18.802  12.269  1.00  0.00           C  
ATOM   1836  O   SER A 122      -6.789  19.912  12.060  1.00  0.00           O  
ATOM   1837  CB  SER A 122      -6.116  19.528  14.655  1.00  0.00           C  
ATOM   1838  OG  SER A 122      -6.315  19.059  15.978  1.00  0.00           O  
ATOM   1839  H   SER A 122      -4.351  17.022  14.141  1.00  0.00           H  
ATOM   1840  HA  SER A 122      -6.564  17.549  13.977  1.00  0.00           H  
ATOM   1841  HB2 SER A 122      -5.240  20.159  14.638  1.00  0.00           H  
ATOM   1842  HB3 SER A 122      -6.979  20.105  14.357  1.00  0.00           H  
ATOM   1843  HG  SER A 122      -7.059  19.520  16.372  1.00  0.00           H  
ATOM   1844  N   SER A 123      -6.065  17.919  11.302  1.00  0.00           N  
ATOM   1845  CA  SER A 123      -6.376  18.214   9.907  1.00  0.00           C  
ATOM   1846  C   SER A 123      -7.859  17.996   9.623  1.00  0.00           C  
ATOM   1847  O   SER A 123      -8.511  18.828   8.995  1.00  0.00           O  
ATOM   1848  CB  SER A 123      -5.533  17.338   8.979  1.00  0.00           C  
ATOM   1849  OG  SER A 123      -5.901  15.975   9.092  1.00  0.00           O  
ATOM   1850  H   SER A 123      -5.672  17.051  11.532  1.00  0.00           H  
ATOM   1851  HA  SER A 123      -6.136  19.251   9.726  1.00  0.00           H  
ATOM   1852  HB2 SER A 123      -5.679  17.655   7.958  1.00  0.00           H  
ATOM   1853  HB3 SER A 123      -4.489  17.441   9.242  1.00  0.00           H  
ATOM   1854  HG  SER A 123      -6.055  15.611   8.217  1.00  0.00           H  
ATOM   1855  N   GLY A 124      -8.384  16.868  10.092  1.00  0.00           N  
ATOM   1856  CA  GLY A 124      -9.786  16.558   9.879  1.00  0.00           C  
ATOM   1857  C   GLY A 124     -10.498  16.180  11.162  1.00  0.00           C  
ATOM   1858  O   GLY A 124     -11.316  15.261  11.179  1.00  0.00           O  
ATOM   1859  H   GLY A 124      -7.816  16.240  10.585  1.00  0.00           H  
ATOM   1860  HA2 GLY A 124     -10.273  17.422   9.449  1.00  0.00           H  
ATOM   1861  HA3 GLY A 124      -9.860  15.734   9.184  1.00  0.00           H  
TER    1862      GLY A 124                                                      
END
MOLECULE T0488.pdb
ATOM      1  N   SER     1      20.128  12.809  24.526  1.00 19.40           N
ATOM      2  CA  SER     1      20.938  12.899  23.283  1.00 14.62           C
ATOM      4  CB  SER     1      21.786  11.646  23.101  1.00 17.49           C
ATOM      7  OG  SER     1      20.984  10.481  22.955  1.00 25.56           O
ATOM      9  C   SER     1      20.052  13.074  22.065  1.00 13.47           C
ATOM     10  O   SER     1      18.834  12.879  22.117  1.00 15.69           O
ATOM     14  N   MET     2      20.684  13.412  20.957  1.00 10.92           N
ATOM     15  CA  MET     2      20.000  13.465  19.689  1.00  9.70           C
ATOM     17  CB  MET     2      19.319  14.815  19.493  1.00 12.91           C
ATOM     20  CG  MET     2      20.286  15.963  19.402  1.00 15.71           C
ATOM     23  SD  MET     2      19.467  17.568  19.366  1.00 19.52           S
ATOM     24  CE  MET     2      18.819  17.665  21.032  1.00 31.08           C
ATOM     28  C   MET     2      20.956  13.195  18.552  1.00  9.06           C
ATOM     29  O   MET     2      22.158  13.370  18.682  1.00 13.20           O
ATOM     31  N   GLU     3      20.384  12.759  17.442  1.00  7.47           N
ATOM     32  CA  GLU     3      21.090  12.632  16.203  1.00  7.61           C
ATOM     34  CB  GLU     3      20.756  11.297  15.535  1.00  9.77           C
ATOM     37  CG  GLU     3      21.552  11.077  14.264  1.00 14.79           C
ATOM     40  CD  GLU     3      21.122   9.855  13.502  1.00 26.53           C
ATOM     41  OE1 GLU     3      20.303   9.074  14.028  1.00 31.96           O
ATOM     42  OE2 GLU     3      21.613   9.684  12.363  1.00 32.73           O
ATOM     43  C   GLU     3      20.689  13.781  15.297  1.00  8.80           C
ATOM     44  O   GLU     3      19.509  14.082  15.173  1.00 10.63           O
ATOM     46  N   ILE     4      21.679  14.418  14.693  1.00  7.18           N
ATOM     47  CA  ILE     4      21.451  15.424  13.665  1.00  7.38           C
ATOM     49  CB  ILE     4      22.306  16.675  13.857  1.00  9.41           C
ATOM     51  CG1 ILE     4      22.197  17.198  15.271  1.00 12.88           C
ATOM     54  CD1 ILE     4      20.874  17.635  15.639  1.00 14.81           C
ATOM     58  CG2 ILE     4      21.949  17.745  12.806  1.00 11.50           C
ATOM     62  C   ILE     4      21.801  14.808  12.341  1.00  7.35           C
ATOM     63  O   ILE     4      22.895  14.249  12.178  1.00  9.86           O
ATOM     65  N   LEU     5      20.875  14.902  11.402  1.00  7.58           N
ATOM     66  CA  LEU     5      21.132  14.378  10.062  1.00  8.65           C
ATOM     68  CB  LEU     5      20.731  12.925   9.943  1.00 13.90           C
ATOM     71  CG  LEU     5      19.252  12.666  10.057  1.00 13.10           C
ATOM     73  CD1 LEU     5      18.882  11.388   9.287  1.00 20.34           C
ATOM     77  CD2 LEU     5      18.772  12.562  11.493  1.00 19.29           C
ATOM     81  C   LEU     5      20.456  15.222   8.993  1.00  7.20           C
ATOM     82  O   LEU     5      19.584  16.031   9.280  1.00  8.46           O
ATOM     84  N   GLN     6      20.928  15.069   7.768  1.00  7.20           N
ATOM     85  CA  GLN     6      20.395  15.791   6.642  1.00  7.97           C
ATOM     87  CB  GLN     6      21.472  16.631   5.956  1.00 11.22           C
ATOM     90  CG  GLN     6      22.010  17.704   6.886  1.00 17.34           C
ATOM     93  CD  GLN     6      22.853  18.757   6.211  1.00 25.58           C
ATOM     94  OE1 GLN     6      22.673  19.078   5.034  1.00 22.54           O
ATOM     95  NE2 GLN     6      23.778  19.328   6.973  1.00 35.80           N
ATOM     98  C   GLN     6      19.774  14.804   5.678  1.00  8.78           C
ATOM     99  O   GLN     6      20.362  13.773   5.376  1.00 12.62           O
ATOM    101  N   VAL     7      18.567  15.128   5.237  1.00  6.69           N
ATOM    102  CA  VAL     7      17.825  14.314   4.312  1.00  6.49           C
ATOM    104  CB  VAL     7      16.555  13.757   4.961  1.00  7.24           C
ATOM    106  CG1 VAL     7      15.691  13.030   3.954  1.00  9.62           C
ATOM    110  CG2 VAL     7      16.911  12.821   6.122  1.00  9.31           C
ATOM    114  C   VAL     7      17.450  15.146   3.110  1.00  6.92           C
ATOM    115  O   VAL     7      16.765  16.128   3.242  1.00  9.54           O
ATOM    117  N   ALA     8      17.874  14.713   1.934  1.00  7.20           N
ATOM    118  CA  ALA     8      17.555  15.401   0.689  1.00  8.32           C
ATOM    120  CB  ALA     8      18.823  15.574  -0.152  1.00 12.50           C
ATOM    124  C   ALA     8      16.514  14.615  -0.079  1.00  7.94           C
ATOM    125  O   ALA     8      16.711  13.451  -0.375  1.00 12.11           O
ATOM    127  N   LEU     9      15.396  15.253  -0.365  1.00  7.05           N
ATOM    128  CA  LEU     9      14.331  14.704  -1.186  1.00  7.53           C
ATOM    130  CB  LEU     9      12.989  14.824  -0.479  1.00  7.05           C
ATOM    133  CG  LEU     9      12.915  14.175   0.902  1.00  6.94           C
ATOM    135  CD1 LEU     9      11.557  14.422   1.532  1.00 10.28           C
ATOM    139  CD2 LEU     9      13.241  12.665   0.874  1.00  9.01           C
ATOM    143  C   LEU     9      14.296  15.466  -2.509  1.00  6.69           C
ATOM    144  O   LEU     9      14.683  16.629  -2.573  1.00  9.96           O
ATOM    146  N   HIS    10      13.820  14.806  -3.557  1.00  7.45           N
ATOM    147  CA  HIS    10      13.788  15.443  -4.867  1.00  8.58           C
ATOM    149  CB  HIS    10      14.817  14.786  -5.773  1.00 10.46           C
ATOM    152  CG  HIS    10      16.223  15.001  -5.303  1.00 12.40           C
ATOM    153  ND1 HIS    10      16.996  16.053  -5.741  1.00 16.70           N
ATOM    155  CE1 HIS    10      18.175  16.010  -5.143  1.00 18.81           C
ATOM    157  NE2 HIS    10      18.179  14.989  -4.305  1.00 19.15           N
ATOM    159  CD2 HIS    10      16.965  14.349  -4.376  1.00 19.64           C
ATOM    161  C   HIS    10      12.402  15.443  -5.494  1.00  7.84           C
ATOM    162  O   HIS    10      11.834  14.379  -5.778  1.00 11.03           O
ATOM    164  N   LYS    11      11.837  16.643  -5.638  1.00  9.81           N
ATOM    165  CA  LYS    11      10.512  16.790  -6.253  1.00 10.04           C
ATOM    167  CB  LYS    11       9.985  18.217  -6.073  1.00 12.34           C
ATOM    170  CG  LYS    11       9.686  18.625  -4.623  1.00 12.62           C
ATOM    173  CD  LYS    11       8.576  19.704  -4.546  1.00 31.05           C
ATOM    176  CE  LYS    11       8.996  21.073  -5.051  1.00 24.45           C
ATOM    179  NZ  LYS    11       8.322  22.218  -4.361  1.00 21.96           N
ATOM    183  C   LYS    11      10.588  16.474  -7.733  1.00 12.69           C
ATOM    184  O   LYS    11      11.432  17.042  -8.419  1.00 14.69           O
ATOM    186  N   ARG    12       9.704  15.604  -8.215  1.00 13.65           N
ATOM    187  CA  ARG    12       9.688  15.217  -9.636  1.00 17.02           C
ATOM    189  CB  ARG    12       9.080  13.819  -9.812  1.00 18.82           C
ATOM    192  CG  ARG    12       9.882  12.720  -9.103  1.00 23.83           C
ATOM    195  CD  ARG    12      10.108  11.497  -9.984  1.00 35.96           C
ATOM    198  NE  ARG    12      10.943  10.483  -9.336  1.00 41.80           N
ATOM    200  CZ  ARG    12      11.421   9.393  -9.940  1.00 38.74           C
ATOM    201  NH1 ARG    12      11.158   9.156 -11.222  1.00 41.88           N
ATOM    204  NH2 ARG    12      12.172   8.530  -9.257  1.00 33.93           N
ATOM    207  C   ARG    12       8.948  16.257 -10.475  1.00 17.99           C
ATOM    208  O   ARG    12       9.156  16.335 -11.696  1.00 22.78           O
ATOM    210  N   ASP    13       8.081  17.035  -9.822  1.00 16.60           N
ATOM    211  CA  ASP    13       7.475  18.241 -10.404  1.00 17.38           C
ATOM    213  CB  ASP    13       6.064  17.959 -10.970  1.00 19.09           C
ATOM    216  CG  ASP    13       5.028  17.642  -9.898  1.00 19.81           C
ATOM    217  OD1 ASP    13       4.382  18.582  -9.384  1.00 22.06           O
ATOM    218  OD2 ASP    13       4.810  16.436  -9.621  1.00 23.43           O
ATOM    219  C   ASP    13       7.449  19.320  -9.327  1.00 14.18           C
ATOM    220  O   ASP    13       7.531  19.010  -8.142  1.00 14.00           O
ATOM    222  N   SER    14       7.329  20.578  -9.725  1.00 13.19           N
ATOM    223  CA  SER    14       7.384  21.702  -8.783  1.00 13.78           C
ATOM    225  CB  SER    14       7.433  23.044  -9.519  1.00 14.22           C
ATOM    228  OG  SER    14       6.243  23.269 -10.244  1.00 16.20           O
ATOM    230  C   SER    14       6.252  21.710  -7.764  1.00 11.76           C
ATOM    231  O   SER    14       6.341  22.373  -6.725  1.00 14.54           O
ATOM    233  N   GLY    15       5.172  20.998  -8.084  1.00 11.38           N
ATOM    234  CA  GLY    15       4.049  20.871  -7.180  1.00 10.63           C
ATOM    237  C   GLY    15       3.987  19.585  -6.383  1.00 10.54           C
ATOM    238  O   GLY    15       2.994  19.372  -5.694  1.00 11.58           O
ATOM    240  N   GLU    16       5.011  18.735  -6.462  1.00 10.14           N
ATOM    241  CA  GLU    16       4.979  17.475  -5.723  1.00 10.90           C
ATOM    243  CB  GLU    16       6.077  16.500  -6.154  1.00 11.37           C
ATOM    246  CG  GLU    16       5.878  15.118  -5.509  1.00 13.41           C
ATOM    249  CD  GLU    16       6.796  14.031  -6.016  1.00 14.39           C
ATOM    250  OE1 GLU    16       7.821  14.327  -6.657  1.00 17.24           O
ATOM    251  OE2 GLU    16       6.498  12.847  -5.728  1.00 19.88           O
ATOM    252  C   GLU    16       5.094  17.732  -4.229  1.00 11.70           C
ATOM    253  O   GLU    16       5.900  18.539  -3.792  1.00 12.51           O
ATOM    255  N   GLN    17       4.285  17.037  -3.431  1.00 13.12           N
ATOM    256  CA  GLN    17       4.419  17.166  -1.988  1.00 13.43           C
ATOM    258  CB  GLN    17       3.109  16.888  -1.274  1.00 17.00           C
ATOM    261  CG  GLN    17       2.086  17.994  -1.457  0.50 13.19           C
ATOM    264  CD  GLN    17       0.701  17.540  -1.069  0.50 12.56           C
ATOM    265  OE1 GLN    17       0.216  16.501  -1.557  0.50 18.97           O
ATOM    266  NE2 GLN    17       0.049  18.301  -0.192  0.50 15.21           N
ATOM    269  C   GLN    17       5.510  16.223  -1.502  1.00  9.97           C
ATOM    270  O   GLN    17       5.923  15.294  -2.196  1.00 11.21           O
ATOM    272  N   LEU    18       5.980  16.475  -0.298  1.00  9.09           N
ATOM    273  CA  LEU    18       7.002  15.642   0.309  1.00  7.79           C
ATOM    275  CB  LEU    18       7.785  16.430   1.341  1.00 10.03           C
ATOM    278  CG  LEU    18       8.464  17.680   0.774  1.00 13.65           C
ATOM    280  CD1 LEU    18       9.327  18.337   1.851  1.00 16.68           C
ATOM    284  CD2 LEU    18       9.285  17.333  -0.465  1.00 14.79           C
ATOM    288  C   LEU    18       6.406  14.423   0.970  1.00  6.95           C
ATOM    289  O   LEU    18       7.112  13.436   1.174  1.00  7.83           O
ATOM    291  N   GLY    19       5.127  14.475   1.336  1.00  6.45           N
ATOM    292  CA  GLY    19       4.529  13.361   2.072  1.00  5.80           C
ATOM    295  C   GLY    19       4.856  13.345   3.551  1.00  5.53           C
ATOM    296  O   GLY    19       5.144  12.296   4.119  1.00  6.57           O
ATOM    298  N   ILE    20       4.790  14.519   4.179  1.00  6.22           N
ATOM    299  CA  ILE    20       5.150  14.697   5.587  1.00  6.82           C
ATOM    301  CB  ILE    20       6.489  15.508   5.743  1.00  8.22           C
ATOM    303  CG1 ILE    20       7.649  14.867   4.981  1.00  9.99           C
ATOM    306  CD1 ILE    20       8.873  15.766   4.839  1.00 13.13           C
ATOM    310  CG2 ILE    20       6.832  15.684   7.223  1.00 12.01           C
ATOM    314  C   ILE    20       4.027  15.459   6.274  1.00  6.99           C
ATOM    315  O   ILE    20       3.566  16.461   5.762  1.00  9.28           O
ATOM    317  N   LYS    21       3.586  14.957   7.413  1.00  7.07           N
ATOM    318  CA  LYS    21       2.690  15.683   8.288  1.00  6.19           C
ATOM    320  CB  LYS    21       1.699  14.734   8.954  1.00  8.22           C
ATOM    323  CG  LYS    21       0.953  13.836   7.994  1.00 15.14           C
ATOM    326  CD  LYS    21      -0.238  13.152   8.664  1.00 20.17           C
ATOM    329  CE  LYS    21      -0.766  11.971   7.851  1.00 17.14           C
ATOM    332  NZ  LYS    21      -1.781  11.169   8.587  1.00 23.82           N
ATOM    336  C   LYS    21       3.510  16.425   9.341  1.00  8.23           C
ATOM    337  O   LYS    21       4.179  15.810  10.163  1.00  8.25           O
ATOM    339  N   LEU    22       3.477  17.754   9.278  1.00  6.53           N
ATOM    340  CA  LEU    22       4.253  18.608  10.175  1.00  7.05           C
ATOM    342  CB  LEU    22       4.977  19.717   9.405  1.00  9.04           C
ATOM    345  CG  LEU    22       6.120  19.350   8.473  1.00 11.98           C
ATOM    347  CD1 LEU    22       6.685  20.618   7.819  1.00 16.38           C
ATOM    351  CD2 LEU    22       7.190  18.609   9.229  1.00 12.08           C
ATOM    355  C   LEU    22       3.340  19.222  11.220  1.00  6.95           C
ATOM    356  O   LEU    22       2.267  19.693  10.894  1.00  8.65           O
ATOM    358  N   VAL    23       3.808  19.255  12.458  1.00  6.35           N
ATOM    359  CA  VAL    23       3.041  19.777  13.571  1.00  6.35           C
ATOM    361  CB  VAL    23       2.419  18.631  14.430  1.00  7.14           C
ATOM    363  CG1 VAL    23       1.471  17.776  13.574  1.00 10.40           C
ATOM    367  CG2 VAL    23       3.466  17.784  15.139  1.00  8.76           C
ATOM    371  C   VAL    23       3.855  20.658  14.495  1.00  6.32           C
ATOM    372  O   VAL    23       5.072  20.554  14.588  1.00  7.02           O
ATOM    374  N   ARG    24       3.147  21.542  15.177  1.00  6.06           N
ATOM    375  CA  ARG    24       3.667  22.214  16.353  1.00  6.42           C
ATOM    377  CB  ARG    24       3.154  23.651  16.436  1.00  7.91           C
ATOM    380  CG  ARG    24       1.670  23.812  16.738  1.00  8.11           C
ATOM    383  CD  ARG    24       1.240  25.229  16.426  1.00 11.78           C
ATOM    386  NE  ARG    24      -0.147  25.442  16.818  1.00 11.84           N
ATOM    388  CZ  ARG    24      -0.924  26.419  16.356  1.00 13.32           C
ATOM    389  NH1 ARG    24      -0.470  27.304  15.491  1.00 13.58           N
ATOM    392  NH2 ARG    24      -2.176  26.505  16.774  1.00 15.33           N
ATOM    395  C   ARG    24       3.277  21.419  17.588  1.00  7.93           C
ATOM    396  O   ARG    24       2.320  20.643  17.569  1.00 10.12           O
ATOM    398  N   ARG    25       4.018  21.637  18.670  1.00  7.87           N
ATOM    399  CA  ARG    25       3.751  20.948  19.936  1.00 10.55           C
ATOM    401  CB  ARG    25       4.972  20.177  20.387  1.00 11.13           C
ATOM    404  CG  ARG    25       5.165  18.961  19.570  1.00 14.31           C
ATOM    407  CD  ARG    25       6.317  18.166  20.053  1.00 14.64           C
ATOM    410  NE  ARG    25       6.432  16.964  19.256  1.00 20.85           N
ATOM    412  CZ  ARG    25       7.389  16.056  19.399  1.00 21.75           C
ATOM    413  NH1 ARG    25       8.324  16.190  20.332  1.00 26.11           N
ATOM    416  NH2 ARG    25       7.410  15.002  18.596  1.00 19.78           N
ATOM    419  C   ARG    25       3.407  21.916  21.018  1.00 12.37           C
ATOM    420  O   ARG    25       3.895  23.032  21.024  1.00 12.41           O
ATOM    422  N   THR    26       2.593  21.449  21.958  1.00 13.46           N
ATOM    423  CA  THR    26       2.064  22.292  23.024  1.00 16.07           C
ATOM    425  CB  THR    26       0.724  21.742  23.541  1.00 15.98           C
ATOM    427  OG1 THR    26       0.901  20.365  23.892  1.00 20.67           O
ATOM    429  CG2 THR    26      -0.319  21.846  22.445  1.00 18.95           C
ATOM    433  C   THR    26       3.003  22.470  24.213  1.00 14.82           C
ATOM    434  O   THR    26       2.719  23.286  25.078  1.00 19.95           O
ATOM    436  N   ASP    27       4.122  21.754  24.245  1.00 16.37           N
ATOM    437  CA  ASP    27       5.000  21.772  25.411  1.00 18.65           C
ATOM    439  CB  ASP    27       4.850  20.464  26.181  1.00 23.44           C
ATOM    442  CG  ASP    27       5.179  19.239  25.334  1.00 31.95           C
ATOM    443  OD1 ASP    27       5.466  19.385  24.118  1.00 29.18           O
ATOM    444  OD2 ASP    27       5.137  18.121  25.887  1.00 45.79           O
ATOM    445  C   ASP    27       6.472  21.999  25.078  1.00 17.69           C
ATOM    446  O   ASP    27       7.320  21.926  25.961  1.00 20.53           O
ATOM    448  N   GLU    28       6.790  22.264  23.815  1.00 15.18           N
ATOM    449  CA  GLU    28       8.160  22.554  23.416  1.00 15.75           C
ATOM    451  CB  GLU    28       8.999  21.268  23.355  1.00 17.87           C
ATOM    454  CG  GLU    28       8.564  20.268  22.295  1.00 15.99           C
ATOM    457  CD  GLU    28       9.431  19.010  22.286  1.00 17.81           C
ATOM    458  OE1 GLU    28      10.659  19.146  22.161  1.00 25.99           O
ATOM    459  OE2 GLU    28       8.881  17.905  22.411  1.00 32.00           O
ATOM    460  C   GLU    28       8.153  23.236  22.054  1.00 13.50           C
ATOM    461  O   GLU    28       7.240  23.042  21.248  1.00 11.92           O
ATOM    463  N   PRO    29       9.178  24.036  21.791  1.00 11.31           N
ATOM    464  CA  PRO    29       9.234  24.766  20.542  1.00  9.48           C
ATOM    466  CB  PRO    29      10.283  25.836  20.815  1.00 13.51           C
ATOM    469  CG  PRO    29      11.215  25.168  21.786  1.00 13.32           C
ATOM    472  CD  PRO    29      10.337  24.320  22.656  1.00 13.95           C
ATOM    475  C   PRO    29       9.672  23.871  19.401  1.00 10.21           C
ATOM    476  O   PRO    29      10.263  22.802  19.630  1.00 10.48           O
ATOM    477  N   GLY    30       9.388  24.307  18.178  1.00  8.28           N
ATOM    478  CA  GLY    30       9.868  23.605  17.007  1.00  8.52           C
ATOM    481  C   GLY    30       8.771  23.103  16.084  1.00  7.13           C
ATOM    482  O   GLY    30       7.579  23.153  16.414  1.00  7.59           O
ATOM    484  N   VAL    31       9.206  22.606  14.930  1.00  6.41           N
ATOM    485  CA  VAL    31       8.341  21.984  13.950  1.00  6.55           C
ATOM    487  CB  VAL    31       8.562  22.633  12.560  1.00  9.09           C
ATOM    489  CG1 VAL    31       7.696  21.998  11.538  1.00 11.32           C
ATOM    493  CG2 VAL    31       8.330  24.131  12.631  1.00 12.01           C
ATOM    497  C   VAL    31       8.734  20.517  13.912  1.00  5.36           C
ATOM    498  O   VAL    31       9.921  20.186  13.789  1.00  6.15           O
ATOM    500  N   PHE    32       7.745  19.636  14.012  1.00  5.13           N
ATOM    501  CA  PHE    32       7.985  18.206  14.179  1.00  6.39           C
ATOM    503  CB  PHE    32       7.554  17.743  15.584  1.00  6.64           C
ATOM    506  CG  PHE    32       8.328  18.414  16.676  1.00  6.56           C
ATOM    507  CD1 PHE    32       9.453  17.844  17.194  1.00  6.87           C
ATOM    509  CE1 PHE    32      10.178  18.486  18.181  1.00  8.33           C
ATOM    511  CZ  PHE    32       9.765  19.681  18.653  1.00  8.49           C
ATOM    513  CE2 PHE    32       8.641  20.269  18.156  1.00  8.36           C
ATOM    515  CD2 PHE    32       7.922  19.638  17.169  1.00  6.58           C
ATOM    517  C   PHE    32       7.260  17.401  13.145  1.00  6.13           C
ATOM    518  O   PHE    32       6.154  17.747  12.715  1.00  8.29           O
ATOM    520  N   ILE    33       7.866  16.282  12.766  1.00  5.72           N
ATOM    521  CA  ILE    33       7.185  15.310  11.921  1.00  5.98           C
ATOM    523  CB  ILE    33       8.192  14.401  11.195  1.00  6.56           C
ATOM    525  CG1 ILE    33       9.084  15.265  10.320  1.00  7.81           C
ATOM    528  CD1 ILE    33      10.065  14.515   9.462  1.00  9.96           C
ATOM    532  CG2 ILE    33       7.493  13.339  10.346  1.00  8.37           C
ATOM    536  C   ILE    33       6.274  14.467  12.801  1.00  7.53           C
ATOM    537  O   ILE    33       6.726  13.828  13.751  1.00  8.02           O
ATOM    539  N   LEU    34       4.981  14.441  12.481  1.00  6.69           N
ATOM    540  CA  LEU    34       4.062  13.561  13.167  1.00  9.23           C
ATOM    542  CB  LEU    34       2.651  14.122  13.100  1.00  9.63           C
ATOM    545  CG  LEU    34       1.589  13.339  13.869  1.00 10.85           C
ATOM    547  CD1 LEU    34       1.808  13.508  15.371  1.00 13.84           C
ATOM    551  CD2 LEU    34       0.192  13.819  13.461  1.00 17.22           C
ATOM    555  C   LEU    34       4.149  12.162  12.550  1.00  8.28           C
ATOM    556  O   LEU    34       4.259  11.163  13.265  1.00  9.20           O
ATOM    558  N   ASP    35       4.066  12.102  11.222  1.00  8.00           N
ATOM    559  CA  ASP    35       4.172  10.849  10.482  1.00  8.97           C
ATOM    561  CB  ASP    35       2.937   9.975  10.701  1.00 15.92           C
ATOM    564  CG  ASP    35       1.688  10.662  10.296  1.00 18.18           C
ATOM    565  OD1 ASP    35       1.592  10.998   9.115  1.00 27.37           O
ATOM    566  OD2 ASP    35       0.793  10.869  11.145  1.00 37.45           O
ATOM    567  C   ASP    35       4.374  11.200   9.011  1.00  7.38           C
ATOM    568  O   ASP    35       4.342  12.361   8.636  1.00  7.85           O
ATOM    570  N   LEU    36       4.617  10.172   8.213  1.00  9.96           N
ATOM    571  CA  LEU    36       4.789  10.277   6.792  1.00  9.02           C
ATOM    573  CB  LEU    36       6.040   9.523   6.346  1.00  9.54           C
ATOM    576  CG  LEU    36       7.348   9.882   7.039  1.00 11.95           C
ATOM    578  CD1 LEU    36       8.469   9.086   6.358  1.00 12.55           C
ATOM    582  CD2 LEU    36       7.634  11.373   6.998  1.00 10.74           C
ATOM    586  C   LEU    36       3.575   9.694   6.086  1.00 10.85           C
ATOM    587  O   LEU    36       2.923   8.753   6.590  1.00 16.71           O
ATOM    589  N   LEU    37       3.267  10.244   4.924  1.00 10.18           N
ATOM    590  CA  LEU    37       2.173   9.751   4.101  1.00  9.91           C
ATOM    592  CB  LEU    37       1.680  10.825   3.129  1.00 11.13           C
ATOM    595  CG  LEU    37       1.134  12.139   3.683  0.50 15.44           C
ATOM    599  CD1 LEU    37       0.485  12.974   2.576  0.50 17.87           C
ATOM    607  CD2 LEU    37       0.158  11.845   4.773  0.50 17.28           C
ATOM    615  C   LEU    37       2.603   8.536   3.287  1.00  9.77           C
ATOM    616  O   LEU    37       3.694   8.497   2.729  1.00  9.19           O
ATOM    618  N   GLU    38       1.707   7.561   3.187  1.00 12.24           N
ATOM    619  CA  GLU    38       1.930   6.353   2.392  1.00 14.34           C
ATOM    621  CB  GLU    38       0.618   5.543   2.312  1.00 18.79           C
ATOM    624  CG  GLU    38       0.785   4.168   1.682  1.00 22.16           C
ATOM    627  CD  GLU    38      -0.488   3.358   1.710  1.00 31.25           C
ATOM    628  OE1 GLU    38      -1.564   3.948   1.927  1.00 23.39           O
ATOM    629  OE2 GLU    38      -0.412   2.128   1.508  1.00 44.28           O
ATOM    630  C   GLU    38       2.369   6.686   0.979  1.00 13.82           C
ATOM    631  O   GLU    38       1.738   7.485   0.314  1.00 14.65           O
ATOM    633  N   GLY    39       3.467   6.086   0.533  1.00 11.43           N
ATOM    634  CA  GLY    39       3.898   6.213  -0.864  1.00 14.98           C
ATOM    637  C   GLY    39       4.490   7.564  -1.252  1.00 12.08           C
ATOM    638  O   GLY    39       4.870   7.772  -2.408  1.00 13.34           O
ATOM    640  N   GLY    40       4.612   8.482  -0.299  1.00  9.86           N
ATOM    641  CA  GLY    40       5.146   9.787  -0.608  1.00  9.55           C
ATOM    644  C   GLY    40       6.653   9.766  -0.727  1.00  7.46           C
ATOM    645  O   GLY    40       7.303   8.764  -0.407  1.00  7.40           O
ATOM    647  N   LEU    41       7.222  10.891  -1.146  1.00  7.62           N
ATOM    648  CA  LEU    41       8.672  10.979  -1.316  1.00  8.00           C
ATOM    650  CB  LEU    41       9.091  12.399  -1.714  1.00 10.73           C
ATOM    653  CG  LEU    41       8.977  12.843  -3.153  1.00 14.71           C
ATOM    655  CD1 LEU    41       9.439  14.280  -3.194  1.00 13.54           C
ATOM    659  CD2 LEU    41       9.823  11.953  -4.047  1.00 13.69           C
ATOM    663  C   LEU    41       9.398  10.637  -0.047  1.00  6.30           C
ATOM    664  O   LEU    41      10.426   9.958  -0.078  1.00  6.05           O
ATOM    666  N   ALA    42       8.923  11.169   1.076  1.00  6.10           N
ATOM    667  CA  ALA    42       9.617  10.951   2.343  1.00  5.50           C
ATOM    669  CB  ALA    42       9.039  11.836   3.429  1.00  6.62           C
ATOM    673  C   ALA    42       9.603   9.484   2.750  1.00  6.00           C
ATOM    674  O   ALA    42      10.614   8.938   3.177  1.00  5.85           O
ATOM    676  N   ALA    43       8.451   8.841   2.592  1.00  5.17           N
ATOM    677  CA  ALA    43       8.324   7.429   2.900  1.00  5.95           C
ATOM    679  CB  ALA    43       6.877   6.965   2.811  1.00  8.50           C
ATOM    683  C   ALA    43       9.207   6.590   1.979  1.00  6.68           C
ATOM    684  O   ALA    43       9.846   5.647   2.421  1.00  7.67           O
ATOM    686  N   GLN    44       9.239   6.927   0.693  1.00  6.75           N
ATOM    687  CA  GLN    44      10.080   6.208  -0.242  1.00  5.96           C
ATOM    689  CB  GLN    44       9.884   6.725  -1.657  1.00  6.18           C
ATOM    692  CG  GLN    44       8.528   6.335  -2.259  1.00  8.92           C
ATOM    695  CD  GLN    44       8.364   6.902  -3.633  1.00 11.62           C
ATOM    696  OE1 GLN    44       9.187   6.663  -4.520  1.00 14.68           O
ATOM    697  NE2 GLN    44       7.314   7.675  -3.818  1.00 14.96           N
ATOM    700  C   GLN    44      11.545   6.330   0.121  1.00  5.84           C
ATOM    701  O   GLN    44      12.322   5.375  -0.015  1.00  6.68           O
ATOM    703  N   ASP    45      11.944   7.519   0.550  1.00  5.19           N
ATOM    704  CA  ASP    45      13.315   7.747   0.941  1.00  5.40           C
ATOM    706  CB  ASP    45      13.577   9.248   1.150  1.00  5.38           C
ATOM    709  CG  ASP    45      14.928   9.517   1.707  1.00  7.25           C
ATOM    710  OD1 ASP    45      15.893   9.620   0.899  1.00  7.92           O
ATOM    711  OD2 ASP    45      15.039   9.605   2.962  1.00  7.45           O
ATOM    712  C   ASP    45      13.687   6.947   2.180  1.00  6.21           C
ATOM    713  O   ASP    45      14.794   6.435   2.255  1.00  7.92           O
ATOM    715  N   GLY    46      12.777   6.884   3.146  1.00  6.05           N
ATOM    716  CA  GLY    46      12.890   6.010   4.303  1.00  8.24           C
ATOM    719  C   GLY    46      13.464   6.635   5.554  1.00  8.42           C
ATOM    720  O   GLY    46      13.208   6.144   6.652  1.00 12.24           O
ATOM    722  N   ARG    47      14.251   7.704   5.407  1.00  6.54           N
ATOM    723  CA  ARG    47      15.018   8.218   6.545  1.00  8.04           C
ATOM    725  CB  ARG    47      16.169   9.085   6.066  1.00  7.42           C
ATOM    728  CG  ARG    47      17.222   8.284   5.355  1.00  9.19           C
ATOM    731  CD  ARG    47      18.320   9.143   4.763  1.00  9.89           C
ATOM    734  NE  ARG    47      17.874   9.848   3.578  1.00  8.34           N
ATOM    736  CZ  ARG    47      18.629  10.670   2.865  1.00  7.37           C
ATOM    737  NH1 ARG    47      19.872  10.932   3.235  1.00 10.70           N
ATOM    740  NH2 ARG    47      18.144  11.253   1.797  1.00  8.55           N
ATOM    743  C   ARG    47      14.197   8.973   7.569  1.00  8.63           C
ATOM    744  O   ARG    47      14.369   8.776   8.766  1.00 13.68           O
ATOM    746  N   LEU    48      13.341   9.866   7.116  1.00  7.63           N
ATOM    747  CA  LEU    48      12.584  10.684   8.035  1.00  7.29           C
ATOM    749  CB  LEU    48      11.816  11.766   7.291  1.00  7.30           C
ATOM    752  CG  LEU    48      12.687  12.823   6.589  1.00  8.01           C
ATOM    754  CD1 LEU    48      11.836  13.663   5.678  1.00 10.86           C
ATOM    758  CD2 LEU    48      13.434  13.710   7.580  1.00  9.67           C
ATOM    762  C   LEU    48      11.646   9.839   8.871  1.00  9.21           C
ATOM    763  O   LEU    48      11.231   8.751   8.454  1.00 11.25           O
ATOM    765  N   SER    49      11.325  10.343  10.062  1.00  7.94           N
ATOM    766  CA  SER    49      10.576   9.586  11.039  1.00  8.89           C
ATOM    768  CB  SER    49      11.569   8.839  11.926  1.00 10.93           C
ATOM    771  OG  SER    49      10.887   7.933  12.776  1.00 14.79           O
ATOM    773  C   SER    49       9.708  10.456  11.922  1.00  7.68           C
ATOM    774  O   SER    49      10.045  11.579  12.207  1.00  7.74           O
ATOM    776  N   SER    50       8.643   9.859  12.435  1.00  7.02           N
ATOM    777  CA  SER    50       7.847  10.451  13.491  1.00  7.93           C
ATOM    779  CB  SER    50       6.847   9.400  13.997  0.50  7.51           C
ATOM    785  OG  SER    50       5.958   9.906  14.963  0.50  6.38           O
ATOM    789  C   SER    50       8.764  10.917  14.610  1.00  6.25           C
ATOM    790  O   SER    50       9.705  10.210  14.994  1.00  8.15           O
ATOM    792  N   ASN    51       8.476  12.127  15.105  1.00  5.84           N
ATOM    793  CA  ASN    51       9.180  12.780  16.210  1.00  6.94           C
ATOM    795  CB  ASN    51       9.345  11.845  17.409  1.00  8.16           C
ATOM    798  CG  ASN    51       8.018  11.464  17.982  1.00  9.85           C
ATOM    799  OD1 ASN    51       7.313  12.311  18.530  1.00 12.30           O
ATOM    800  ND2 ASN    51       7.642  10.213  17.832  1.00  9.84           N
ATOM    803  C   ASN    51      10.454  13.506  15.833  1.00  6.49           C
ATOM    804  O   ASN    51      11.045  14.165  16.682  1.00  8.19           O
ATOM    806  N   ASP    52      10.845  13.450  14.563  1.00  6.15           N
ATOM    807  CA  ASP    52      11.970  14.223  14.106  1.00  5.99           C
ATOM    809  CB  ASP    52      12.290  13.888  12.648  1.00  6.83           C
ATOM    812  CG  ASP    52      13.037  12.585  12.472  1.00  8.10           C
ATOM    813  OD1 ASP    52      13.484  11.982  13.468  1.00  8.15           O
ATOM    814  OD2 ASP    52      13.210  12.189  11.298  1.00  8.89           O
ATOM    815  C   ASP    52      11.601  15.697  14.206  1.00  6.29           C
ATOM    816  O   ASP    52      10.491  16.107  13.839  1.00  6.95           O
ATOM    818  N   ARG    53      12.550  16.500  14.650  1.00  5.25           N
ATOM    819  CA  ARG    53      12.408  17.938  14.683  1.00  4.99           C
ATOM    821  CB  ARG    53      13.041  18.529  15.935  1.00  6.14           C
ATOM    824  CG  ARG    53      12.863  20.012  16.008  1.00  7.50           C
ATOM    827  CD  ARG    53      13.501  20.585  17.212  1.00  8.27           C
ATOM    830  NE  ARG    53      13.318  22.031  17.331  1.00  8.88           N
ATOM    832  CZ  ARG    53      13.737  22.686  18.396  1.00 11.23           C
ATOM    833  NH1 ARG    53      14.346  22.016  19.366  1.00 16.53           N
ATOM    836  NH2 ARG    53      13.543  23.977  18.514  1.00 13.37           N
ATOM    839  C   ARG    53      13.100  18.513  13.447  1.00  4.96           C
ATOM    840  O   ARG    53      14.246  18.205  13.173  1.00  6.86           O
ATOM    842  N   VAL    54      12.379  19.326  12.678  1.00  5.73           N
ATOM    843  CA  VAL    54      12.946  19.961  11.493  1.00  6.02           C
ATOM    845  CB  VAL    54      11.865  20.242  10.411  1.00  6.77           C
ATOM    847  CG1 VAL    54      12.525  20.854   9.177  1.00  7.75           C
ATOM    851  CG2 VAL    54      11.100  18.960  10.023  1.00  9.25           C
ATOM    855  C   VAL    54      13.643  21.257  11.915  1.00  5.20           C
ATOM    856  O   VAL    54      12.992  22.215  12.306  1.00  6.89           O
ATOM    858  N   LEU    55      14.971  21.250  11.874  1.00  4.90           N
ATOM    859  CA  LEU    55      15.774  22.399  12.259  1.00  5.97           C
ATOM    861  CB  LEU    55      17.164  21.952  12.706  1.00  6.50           C
ATOM    864  CG  LEU    55      17.211  21.067  13.939  1.00  7.90           C
ATOM    866  CD1 LEU    55      18.665  20.650  14.173  1.00 10.54           C
ATOM    870  CD2 LEU    55      16.639  21.761  15.161  1.00 12.65           C
ATOM    874  C   LEU    55      15.917  23.418  11.129  1.00  5.73           C
ATOM    875  O   LEU    55      16.055  24.599  11.409  1.00  6.02           O
ATOM    877  N   ALA    56      15.899  22.967   9.877  1.00  4.96           N
ATOM    878  CA  ALA    56      16.078  23.839   8.738  1.00  5.86           C
ATOM    880  CB  ALA    56      17.559  24.243   8.565  1.00  7.39           C
ATOM    884  C   ALA    56      15.613  23.097   7.501  1.00  4.94           C
ATOM    885  O   ALA    56      15.630  21.863   7.462  1.00  5.30           O
ATOM    887  N   ILE    57      15.205  23.857   6.494  1.00  4.78           N
ATOM    888  CA  ILE    57      14.911  23.339   5.159  1.00  5.74           C
ATOM    890  CB  ILE    57      13.401  23.285   4.848  1.00  7.45           C
ATOM    892  CG1 ILE    57      12.699  22.291   5.772  1.00  8.31           C
ATOM    895  CD1 ILE    57      11.186  22.199   5.602  1.00 11.74           C
ATOM    899  CG2 ILE    57      13.155  22.833   3.436  1.00  7.99           C
ATOM    903  C   ILE    57      15.615  24.249   4.162  1.00  5.48           C
ATOM    904  O   ILE    57      15.437  25.465   4.181  1.00  5.95           O
ATOM    906  N   ASN    58      16.488  23.659   3.347  1.00  5.37           N
ATOM    907  CA  ASN    58      17.202  24.406   2.311  1.00  5.56           C
ATOM    909  CB  ASN    58      16.242  24.820   1.190  1.00  6.55           C
ATOM    912  CG  ASN    58      15.844  23.658   0.321  1.00  5.43           C
ATOM    913  OD1 ASN    58      16.462  22.598   0.393  1.00  7.68           O
ATOM    914  ND2 ASN    58      14.804  23.840  -0.499  1.00  9.08           N
ATOM    917  C   ASN    58      17.968  25.593   2.877  1.00  5.61           C
ATOM    918  O   ASN    58      18.065  26.640   2.259  1.00  6.22           O
ATOM    920  N   GLY    59      18.531  25.413   4.066  1.00  7.13           N
ATOM    921  CA  GLY    59      19.286  26.446   4.761  1.00  6.57           C
ATOM    924  C   GLY    59      18.476  27.481   5.496  1.00  6.87           C
ATOM    925  O   GLY    59      19.058  28.366   6.131  1.00 10.12           O
ATOM    927  N   HIS    60      17.151  27.403   5.379  1.00  5.84           N
ATOM    928  CA  HIS    60      16.246  28.308   6.057  1.00  6.38           C
ATOM    930  CB  HIS    60      14.923  28.422   5.291  1.00  7.41           C
ATOM    933  CG  HIS    60      15.059  28.970   3.905  1.00  9.29           C
ATOM    934  ND1 HIS    60      14.673  30.244   3.565  1.00 15.26           N
ATOM    936  CE1 HIS    60      14.916  30.455   2.284  1.00 15.78           C
ATOM    938  NE2 HIS    60      15.439  29.353   1.773  1.00 10.90           N
ATOM    940  CD2 HIS    60      15.508  28.403   2.762  1.00 11.08           C
ATOM    942  C   HIS    60      15.969  27.768   7.456  1.00  6.08           C
ATOM    943  O   HIS    60      15.431  26.677   7.615  1.00  7.61           O
ATOM    945  N   ASP    61      16.284  28.556   8.478  1.00  7.12           N
ATOM    946  CA  ASP    61      16.130  28.131   9.868  1.00  7.26           C
ATOM    948  CB  ASP    61      16.723  29.213  10.787  1.00  9.51           C
ATOM    951  CG  ASP    61      16.625  28.881  12.261  1.00 11.69           C
ATOM    952  OD1 ASP    61      16.644  27.691  12.621  1.00 11.87           O
ATOM    953  OD2 ASP    61      16.534  29.843  13.051  1.00 19.75           O
ATOM    954  C   ASP    61      14.659  27.919  10.218  1.00  7.26           C
ATOM    955  O   ASP    61      13.821  28.778   9.948  1.00  9.44           O
ATOM    957  N   LEU    62      14.365  26.784  10.844  1.00  6.81           N
ATOM    958  CA  LEU    62      13.042  26.461  11.358  1.00  7.03           C
ATOM    960  CB  LEU    62      12.435  25.351  10.511  1.00  8.04           C
ATOM    963  CG  LEU    62      11.842  25.803   9.173  1.00  9.58           C
ATOM    965  CD1 LEU    62      11.547  24.580   8.318  1.00 14.23           C
ATOM    969  CD2 LEU    62      10.558  26.562   9.377  1.00 11.51           C
ATOM    973  C   LEU    62      13.065  26.067  12.836  1.00  6.56           C
ATOM    974  O   LEU    62      12.072  25.571  13.367  1.00  7.03           O
ATOM    976  N   LYS    63      14.176  26.298  13.525  1.00  6.57           N
ATOM    977  CA  LYS    63      14.275  25.871  14.918  1.00  7.54           C
ATOM    979  CB  LYS    63      15.603  26.320  15.527  1.00  9.50           C
ATOM    982  CG  LYS    63      15.877  25.737  16.905  1.00 14.00           C
ATOM    985  CD  LYS    63      17.286  25.997  17.394  1.00 18.24           C
ATOM    988  CE  LYS    63      17.444  25.472  18.815  1.00 23.48           C
ATOM    992  C   LYS    63      13.103  26.393  15.750  1.00  6.86           C
ATOM    993  O   LYS    63      12.524  25.652  16.546  1.00  7.88           O
ATOM    995  N   TYR    64      12.751  27.663  15.566  1.00  7.48           N
ATOM    996  CA  TYR    64      11.624  28.256  16.273  1.00  8.17           C
ATOM    998  CB  TYR    64      12.093  29.470  17.089  1.00 11.09           C
ATOM   1001  CG  TYR    64      13.152  29.097  18.092  1.00 11.97           C
ATOM   1002  CD1 TYR    64      12.812  28.444  19.262  1.00 14.21           C
ATOM   1004  CE1 TYR    64      13.775  28.061  20.178  1.00 17.55           C
ATOM   1006  CZ  TYR    64      15.099  28.298  19.905  1.00 20.25           C
ATOM   1007  OH  TYR    64      16.053  27.918  20.816  1.00 26.55           O
ATOM   1009  CE2 TYR    64      15.471  28.924  18.736  1.00 20.96           C
ATOM   1011  CD2 TYR    64      14.501  29.305  17.825  1.00 15.02           C
ATOM   1013  C   TYR    64      10.497  28.626  15.316  1.00  8.44           C
ATOM   1014  O   TYR    64       9.719  29.543  15.565  1.00 11.33           O
ATOM   1016  N   GLY    65      10.391  27.868  14.226  1.00  7.80           N
ATOM   1017  CA  GLY    65       9.456  28.141  13.163  1.00  8.27           C
ATOM   1020  C   GLY    65       8.106  27.507  13.394  1.00  7.91           C
ATOM   1021  O   GLY    65       7.804  27.015  14.472  1.00  7.59           O
ATOM   1023  N   THR    66       7.300  27.515  12.346  1.00  9.49           N
ATOM   1024  CA  THR    66       5.936  27.018  12.364  1.00  9.40           C
ATOM   1026  CB  THR    66       4.949  28.188  12.187  1.00  9.92           C
ATOM   1028  OG1 THR    66       5.184  28.803  10.915  1.00 12.44           O
ATOM   1030  CG2 THR    66       5.102  29.213  13.287  1.00 13.80           C
ATOM   1034  C   THR    66       5.689  26.091  11.183  1.00  9.04           C
ATOM   1035  O   THR    66       6.401  26.156  10.182  1.00  8.82           O
ATOM   1037  N   PRO    67       4.658  25.244  11.275  1.00  9.53           N
ATOM   1038  CA  PRO    67       4.247  24.481  10.100  1.00  8.74           C
ATOM   1040  CB  PRO    67       2.977  23.778  10.578  1.00 10.07           C
ATOM   1043  CG  PRO    67       3.200  23.593  12.032  1.00 11.46           C
ATOM   1046  CD  PRO    67       3.906  24.839  12.476  1.00 11.37           C
ATOM   1049  C   PRO    67       3.988  25.364   8.877  1.00  9.67           C
ATOM   1050  O   PRO    67       4.337  24.995   7.759  1.00 10.04           O
ATOM   1051  N   GLU    68       3.394  26.533   9.096  1.00  9.78           N
ATOM   1052  CA  GLU    68       3.116  27.444   8.001  1.00 11.62           C
ATOM   1054  CB  GLU    68       2.371  28.680   8.504  1.00 15.78           C
ATOM   1057  CG  GLU    68       0.939  28.454   8.841  1.00 22.69           C
ATOM   1060  CD  GLU    68       0.730  27.530  10.025  1.00 38.18           C
ATOM   1061  OE1 GLU    68       1.509  27.567  11.019  1.00 30.10           O
ATOM   1062  OE2 GLU    68      -0.241  26.753   9.956  1.00 46.84           O
ATOM   1063  C   GLU    68       4.362  27.913   7.288  1.00 10.80           C
ATOM   1064  O   GLU    68       4.391  27.980   6.050  1.00 13.59           O
ATOM   1066  N   LEU    69       5.377  28.283   8.060  1.00 10.10           N
ATOM   1067  CA  LEU    69       6.635  28.728   7.469  1.00 10.16           C
ATOM   1069  CB  LEU    69       7.557  29.283   8.549  1.00 13.39           C
ATOM   1072  CG  LEU    69       8.913  29.806   8.085  1.00 13.91           C
ATOM   1074  CD1 LEU    69       8.763  30.875   7.002  1.00 16.82           C
ATOM   1078  CD2 LEU    69       9.710  30.307   9.286  1.00 16.06           C
ATOM   1082  C   LEU    69       7.287  27.576   6.700  1.00  9.38           C
ATOM   1083  O   LEU    69       7.778  27.764   5.595  1.00 10.31           O
ATOM   1085  N   ALA    70       7.282  26.382   7.275  1.00  9.22           N
ATOM   1086  CA  ALA    70       7.801  25.207   6.554  1.00  8.31           C
ATOM   1088  CB  ALA    70       7.687  23.984   7.411  1.00  9.24           C
ATOM   1092  C   ALA    70       7.056  24.999   5.230  1.00  8.63           C
ATOM   1093  O   ALA    70       7.679  24.743   4.207  1.00  9.95           O
ATOM   1095  N   ALA    71       5.729  25.125   5.262  1.00  9.56           N
ATOM   1096  CA  ALA    71       4.901  24.975   4.076  1.00 10.82           C
ATOM   1098  CB  ALA    71       3.435  25.119   4.431  1.00 12.69           C
ATOM   1102  C   ALA    71       5.282  25.984   3.003  1.00 10.30           C
ATOM   1103  O   ALA    71       5.370  25.639   1.841  1.00 11.75           O
ATOM   1105  N   GLN    72       5.506  27.233   3.406  1.00 11.39           N
ATOM   1106  CA  GLN    72       5.878  28.302   2.476  1.00 12.45           C
ATOM   1108  CB  GLN    72       5.975  29.639   3.207  1.00 15.12           C
ATOM   1111  CG  GLN    72       4.633  30.242   3.569  1.00 26.64           C
ATOM   1114  CD  GLN    72       4.759  31.571   4.300  1.00 41.76           C
ATOM   1115  OE1 GLN    72       5.777  31.860   4.936  1.00 44.64           O
ATOM   1116  NE2 GLN    72       3.713  32.385   4.216  1.00 48.57           N
ATOM   1119  C   GLN    72       7.207  27.962   1.806  1.00 12.12           C
ATOM   1120  O   GLN    72       7.353  28.082   0.581  1.00 12.87           O
ATOM   1122  N   ILE    73       8.179  27.518   2.597  1.00 10.78           N
ATOM   1123  CA  ILE    73       9.494  27.153   2.059  1.00 11.01           C
ATOM   1125  CB  ILE    73      10.495  26.822   3.185  1.00 10.04           C
ATOM   1127  CG1 ILE    73      10.756  28.065   4.042  1.00 12.22           C
ATOM   1130  CD1 ILE    73      11.281  27.733   5.431  1.00 13.45           C
ATOM   1134  CG2 ILE    73      11.806  26.269   2.626  1.00 11.05           C
ATOM   1138  C   ILE    73       9.399  25.976   1.090  1.00  9.44           C
ATOM   1139  O   ILE    73       9.934  26.028  -0.020  1.00 11.21           O
ATOM   1141  N   ILE    74       8.672  24.931   1.481  1.00  9.74           N
ATOM   1142  CA  ILE    74       8.569  23.728   0.661  1.00  9.95           C
ATOM   1144  CB  ILE    74       7.907  22.592   1.429  1.00 10.93           C
ATOM   1146  CG1 ILE    74       8.843  22.115   2.522  1.00 10.18           C
ATOM   1149  CD1 ILE    74       8.119  21.328   3.647  1.00 13.36           C
ATOM   1153  CG2 ILE    74       7.582  21.426   0.509  1.00 12.72           C
ATOM   1157  C   ILE    74       7.825  24.010  -0.644  1.00 11.91           C
ATOM   1158  O   ILE    74       8.246  23.557  -1.726  1.00 13.89           O
ATOM   1160  N   GLN    75       6.741  24.780  -0.564  1.00 12.93           N
ATOM   1161  CA  GLN    75       5.961  25.074  -1.768  1.00 13.68           C
ATOM   1163  CB  GLN    75       4.657  25.750  -1.402  1.00 16.16           C
ATOM   1166  CG  GLN    75       3.669  24.773  -0.769  1.00 18.38           C
ATOM   1169  CD  GLN    75       2.441  25.471  -0.235  1.00 26.27           C
ATOM   1170  OE1 GLN    75       2.313  26.691  -0.338  1.00 34.21           O
ATOM   1171  NE2 GLN    75       1.530  24.705   0.337  1.00 29.94           N
ATOM   1174  C   GLN    75       6.746  25.917  -2.773  1.00 13.60           C
ATOM   1175  O   GLN    75       6.574  25.734  -3.965  1.00 17.87           O
ATOM   1177  N   ALA    76       7.609  26.812  -2.296  1.00 10.43           N
ATOM   1178  CA  ALA    76       8.437  27.639  -3.166  1.00 11.32           C
ATOM   1180  CB  ALA    76       8.707  28.987  -2.509  1.00 13.58           C
ATOM   1184  C   ALA    76       9.748  26.982  -3.584  1.00 11.10           C
ATOM   1185  O   ALA    76      10.468  27.561  -4.377  1.00 13.90           O
ATOM   1187  N   SER    77      10.065  25.793  -3.059  1.00  9.06           N
ATOM   1188  CA  SER    77      11.372  25.165  -3.256  1.00  9.49           C
ATOM   1190  CB  SER    77      11.469  23.906  -2.429  0.50  9.76           C
ATOM   1196  OG  SER    77      10.601  22.959  -2.991  0.50 13.23           O
ATOM   1200  C   SER    77      11.592  24.786  -4.692  1.00 10.15           C
ATOM   1201  O   SER    77      10.639  24.562  -5.437  1.00 14.75           O
ATOM   1203  N   GLY    78      12.861  24.707  -5.079  1.00  7.78           N
ATOM   1204  CA  GLY    78      13.221  24.044  -6.296  1.00  9.54           C
ATOM   1207  C   GLY    78      13.129  22.543  -6.113  1.00  8.94           C
ATOM   1208  O   GLY    78      12.615  22.045  -5.120  1.00 10.77           O
ATOM   1210  N   GLU    79      13.674  21.791  -7.049  1.00  9.79           N
ATOM   1211  CA  GLU    79      13.501  20.344  -7.016  1.00  9.89           C
ATOM   1213  CB  GLU    79      13.953  19.685  -8.320  1.00 16.21           C
ATOM   1216  CG  GLU    79      15.398  19.861  -8.639  1.00 16.42           C
ATOM   1219  CD  GLU    79      16.323  18.856  -7.970  1.00 22.12           C
ATOM   1220  OE1 GLU    79      15.852  17.773  -7.589  1.00 22.98           O
ATOM   1221  OE2 GLU    79      17.531  19.158  -7.834  1.00 30.49           O
ATOM   1222  C   GLU    79      14.129  19.674  -5.794  1.00  9.48           C
ATOM   1223  O   GLU    79      13.577  18.718  -5.290  1.00 11.29           O
ATOM   1225  N   ARG    80      15.251  20.178  -5.304  1.00  8.87           N
ATOM   1226  CA  ARG    80      15.911  19.591  -4.148  1.00  8.68           C
ATOM   1228  CB  ARG    80      17.430  19.716  -4.256  1.00 11.07           C
ATOM   1231  CG  ARG    80      18.176  19.033  -3.108  1.00 13.32           C
ATOM   1234  CD  ARG    80      19.682  19.112  -3.324  1.00 24.79           C
ATOM   1237  NE  ARG    80      20.448  18.479  -2.245  1.00 27.84           N
ATOM   1239  CZ  ARG    80      20.993  19.118  -1.207  1.00 36.19           C
ATOM   1240  NH1 ARG    80      20.863  20.433  -1.054  1.00 33.72           N
ATOM   1243  NH2 ARG    80      21.671  18.426  -0.295  1.00 41.41           N
ATOM   1246  C   ARG    80      15.411  20.246  -2.878  1.00  8.11           C
ATOM   1247  O   ARG    80      15.445  21.473  -2.722  1.00  9.37           O
ATOM   1249  N   VAL    81      14.959  19.401  -1.963  1.00  6.86           N
ATOM   1250  CA  VAL    81      14.513  19.835  -0.643  1.00  6.31           C
ATOM   1252  CB  VAL    81      13.028  19.562  -0.396  1.00  7.85           C
ATOM   1254  CG1 VAL    81      12.610  20.149   0.932  1.00  9.26           C
ATOM   1258  CG2 VAL    81      12.177  20.137  -1.532  1.00 10.85           C
ATOM   1262  C   VAL    81      15.382  19.116   0.383  1.00  6.33           C
ATOM   1263  O   VAL    81      15.236  17.909   0.611  1.00  8.05           O
ATOM   1265  N   ASN    82      16.280  19.870   0.997  1.00  5.57           N
ATOM   1266  CA  ASN    82      17.158  19.331   2.032  1.00  5.84           C
ATOM   1268  CB  ASN    82      18.579  19.900   1.896  1.00  8.13           C
ATOM   1271  CG  ASN    82      19.516  19.209   2.822  1.00 12.01           C
ATOM   1272  OD1 ASN    82      19.750  18.001   2.675  1.00 16.43           O
ATOM   1273  ND2 ASN    82      19.968  19.910   3.861  1.00 16.19           N
ATOM   1276  C   ASN    82      16.603  19.693   3.400  1.00  5.43           C
ATOM   1277  O   ASN    82      16.397  20.860   3.676  1.00  9.69           O
ATOM   1279  N   LEU    83      16.354  18.700   4.242  1.00  5.52           N
ATOM   1280  CA  LEU    83      15.875  18.917   5.599  1.00  5.39           C
ATOM   1282  CB  LEU    83      14.653  18.038   5.889  1.00  6.63           C
ATOM   1285  CG  LEU    83      13.448  18.253   4.967  1.00  7.62           C
ATOM   1287  CD1 LEU    83      13.437  17.282   3.780  1.00 10.23           C
ATOM   1291  CD2 LEU    83      12.167  18.112   5.799  1.00 11.84           C
ATOM   1295  C   LEU    83      16.980  18.565   6.561  1.00  5.82           C
ATOM   1296  O   LEU    83      17.545  17.489   6.480  1.00  8.00           O
ATOM   1298  N   THR    84      17.279  19.480   7.477  1.00  5.80           N
ATOM   1299  CA  THR    84      18.161  19.195   8.594  1.00  5.83           C
ATOM   1301  CB  THR    84      19.072  20.384   8.934  1.00  7.22           C
ATOM   1303  OG1 THR    84      19.806  20.767   7.757  1.00 11.03           O
ATOM   1305  CG2 THR    84      20.050  20.060  10.048  1.00  9.42           C
ATOM   1309  C   THR    84      17.285  18.858   9.778  1.00  5.81           C
ATOM   1310  O   THR    84      16.420  19.644  10.181  1.00  6.34           O
ATOM   1312  N   ILE    85      17.508  17.664  10.320  1.00  4.76           N
ATOM   1313  CA  ILE    85      16.683  17.063  11.339  1.00  6.86           C
ATOM   1315  CB  ILE    85      16.266  15.653  10.761  1.00 14.19           C
ATOM   1317  CG1 ILE    85      15.517  15.810   9.448  1.00 13.77           C
ATOM   1320  CD1 ILE    85      14.351  16.566   9.612  1.00 10.45           C
ATOM   1324  CG2 ILE    85      15.551  14.836  11.763  1.00 17.42           C
ATOM   1328  C   ILE    85      17.431  16.795  12.632  1.00  6.23           C
ATOM   1329  O   ILE    85      18.594  16.410  12.577  1.00  6.95           O
ATOM   1331  N   ALA    86      16.739  16.976  13.757  1.00  6.25           N
ATOM   1332  CA  ALA    86      17.190  16.463  15.050  1.00  6.59           C
ATOM   1334  CB  ALA    86      17.200  17.563  16.105  1.00  8.55           C
ATOM   1338  C   ALA    86      16.266  15.319  15.464  1.00  6.81           C
ATOM   1339  O   ALA    86      15.051  15.490  15.528  1.00  8.22           O
ATOM   1341  N   ARG    87      16.864  14.166  15.753  1.00  7.51           N
ATOM   1342  CA  ARG    87      16.141  12.966  16.135  1.00  8.14           C
ATOM   1344  CB  ARG    87      16.548  11.809  15.238  1.00  8.42           C
ATOM   1347  CG  ARG    87      15.882  10.496  15.579  1.00  9.40           C
ATOM   1350  CD  ARG    87      16.088   9.500  14.466  1.00 10.06           C
ATOM   1353  NE  ARG    87      15.444   9.990  13.256  1.00  8.90           N
ATOM   1355  CZ  ARG    87      15.734   9.569  12.031  1.00 11.27           C
ATOM   1356  NH1 ARG    87      16.620   8.604  11.820  1.00 12.83           N
ATOM   1359  NH2 ARG    87      15.145  10.122  11.007  1.00 11.16           N
ATOM   1362  C   ARG    87      16.500  12.689  17.593  1.00  7.99           C
ATOM   1363  O   ARG    87      17.564  12.158  17.886  1.00  8.23           O
ATOM   1365  N   PRO    88      15.638  13.098  18.531  1.00 10.73           N
ATOM   1366  CA  PRO    88      16.030  12.918  19.925  1.00 10.69           C
ATOM   1368  CB  PRO    88      15.102  13.869  20.685  1.00 14.27           C
ATOM   1371  CG  PRO    88      14.609  14.838  19.670  1.00 18.94           C
ATOM   1374  CD  PRO    88      14.509  14.034  18.416  1.00 14.24           C
ATOM   1377  C   PRO    88      15.854  11.499  20.425  1.00 10.66           C
ATOM   1378  O   PRO    88      15.081  10.700  19.871  1.00 14.66           O
ATOM   1379  N   GLY    89      16.590  11.193  21.476  1.00 10.65           N
ATOM   1380  CA  GLY    89      16.292  10.059  22.300  1.00 14.39           C
ATOM   1383  C   GLY    89      16.821   8.730  21.823  1.00 12.94           C
ATOM   1384  O   GLY    89      17.450   8.599  20.778  1.00 16.65           O
ATOM   1386  N   LYS    90      16.595   7.725  22.648  1.00 13.32           N
ATOM   1387  CA  LYS    90      17.063   6.385  22.376  1.00 11.77           C
ATOM   1389  CB  LYS    90      17.224   5.631  23.701  1.00 13.46           C
ATOM   1392  CG  LYS    90      18.208   6.274  24.672  1.00 15.32           C
ATOM   1395  CD  LYS    90      18.301   5.467  25.954  1.00 14.96           C
ATOM   1398  CE  LYS    90      19.261   6.115  26.964  1.00 15.66           C
ATOM   1401  NZ  LYS    90      19.404   5.284  28.187  1.00 22.41           N
ATOM   1405  C   LYS    90      16.058   5.637  21.500  1.00 10.89           C
ATOM   1406  O   LYS    90      14.853   5.785  21.671  1.00 14.13           O
ATOM   1408  N   PRO    91      16.552   4.802  20.591  1.00  9.91           N
ATOM   1409  CA  PRO    91      15.651   4.023  19.745  1.00 12.24           C
ATOM   1411  CB  PRO    91      16.556   3.534  18.608  1.00 15.51           C
ATOM   1414  CG  PRO    91      17.917   3.641  19.116  1.00 15.26           C
ATOM   1417  CD  PRO    91      17.936   4.756  20.099  1.00 12.95           C
ATOM   1420  C   PRO    91      15.025   2.841  20.462  1.00  9.07           C
ATOM   1421  O   PRO    91      14.020   2.324  20.007  1.00  9.13           O
ATOM   1422  N   GLU    92      15.643   2.418  21.560  1.00  7.37           N
ATOM   1423  CA  GLU    92      15.206   1.255  22.324  1.00  7.95           C
ATOM   1425  CB  GLU    92      16.009  -0.003  21.975  1.00 10.27           C
ATOM   1428  CG  GLU    92      15.660  -1.161  22.901  1.00 14.89           C
ATOM   1431  CD  GLU    92      16.260  -2.480  22.466  1.00 18.63           C
ATOM   1432  OE1 GLU    92      17.066  -2.497  21.502  1.00 29.25           O
ATOM   1433  OE2 GLU    92      15.921  -3.515  23.099  1.00 20.57           O
ATOM   1434  C   GLU    92      15.405   1.564  23.788  1.00  8.05           C
ATOM   1435  O   GLU    92      16.476   2.010  24.200  1.00  9.27           O
ATOM   1437  N   ILE    93      14.387   1.273  24.590  1.00  8.17           N
ATOM   1438  CA  ILE    93      14.469   1.437  26.046  1.00  8.79           C
ATOM   1440  CB  ILE    93      13.775   2.735  26.554  1.00  9.36           C
ATOM   1442  CG1 ILE    93      14.392   3.978  25.905  1.00 12.22           C
ATOM   1445  CD1 ILE    93      13.736   5.273  26.334  1.00 14.74           C
ATOM   1449  CG2 ILE    93      13.850   2.873  28.091  1.00 13.41           C
ATOM   1453  C   ILE    93      13.839   0.215  26.685  1.00  8.69           C
ATOM   1454  O   ILE    93      12.716  -0.158  26.382  1.00  8.14           O
ATOM   1456  N   GLU    94      14.587  -0.408  27.588  1.00  8.99           N
ATOM   1457  CA  GLU    94      14.057  -1.493  28.389  1.00  8.22           C
ATOM   1459  CB  GLU    94      15.122  -2.569  28.575  1.00 11.04           C
ATOM   1462  CG  GLU    94      15.738  -2.924  27.220  1.00 16.67           C
ATOM   1465  CD  GLU    94      16.767  -4.011  27.276  1.00 16.35           C
ATOM   1466  OE1 GLU    94      16.762  -4.808  28.236  1.00 19.51           O
ATOM   1467  OE2 GLU    94      17.608  -4.048  26.330  1.00 22.62           O
ATOM   1468  C   GLU    94      13.584  -0.886  29.689  1.00  8.96           C
ATOM   1469  O   GLU    94      14.327  -0.151  30.370  1.00 11.67           O
ATOM   1471  N   LEU    95      12.324  -1.163  30.007  1.00 11.21           N
ATOM   1472  CA  LEU    95      11.677  -0.524  31.139  1.00 14.71           C
ATOM   1474  CB  LEU    95      10.988   0.768  30.675  1.00 20.18           C
ATOM   1477  CG  LEU    95      10.244   0.748  29.337  1.00 20.27           C
ATOM   1479  CD1 LEU    95       9.020  -0.139  29.452  1.00 23.09           C
ATOM   1483  CD2 LEU    95       9.858   2.172  28.859  1.00 23.60           C
ATOM   1487  C   LEU    95      10.696  -1.450  31.825  1.00 17.18           C
ATOM   1488  O   LEU    95      10.717  -2.674  31.585  1.00 14.01           O
ATOM   1490  OXT LEU    95       9.915  -0.965  32.662  1.00 21.45           O
END
