
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  129 ( 1857),  selected  129 , name 2dmz_A
# Molecule2: number of CA atoms   95 (  723),  selected   95 , name T0488.pdb
# PARAMETERS: 2dmz_A.T0488.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     1_A      -       -           -
LGA    S     2_A      -       -           -
LGA    S     3_A      -       -           -
LGA    G     4_A      -       -           -
LGA    S     5_A      -       -           -
LGA    S     6_A      -       -           -
LGA    G     7_A      -       -           -
LGA    G     8_A      -       -           -
LGA    S     9_A      -       -           -
LGA    D    10_A      -       -           -
LGA    S    11_A      -       -           -
LGA    S    12_A      -       -           -
LGA    L    13_A      S       1          1.687
LGA    F    14_A      M       2          0.834
LGA    E    15_A      E       3          1.593
LGA    T    16_A      I       4          0.675
LGA    Y    17_A      L       5          0.484
LGA    N    18_A      Q       6          0.442
LGA    V    19_A      V       7          0.375
LGA    E    20_A      A       8          0.710
LGA    L    21_A      L       9          0.566
LGA    V    22_A      H      10          1.311
LGA    R    23_A      K      11          1.295
LGA    K    24_A      R      12          1.783
LGA    D    25_A      D      13          3.686
LGA    G    26_A      S      14          5.768
LGA    Q    27_A      G      15          5.652
LGA    S    28_A      E      16          2.118
LGA    -       -      Q      17           -
LGA    L    29_A      L      18          1.255
LGA    G    30_A      G      19          1.529
LGA    I    31_A      I      20          1.147
LGA    R    32_A      K      21          1.241
LGA    I    33_A      L      22          0.578
LGA    V    34_A      V      23          0.463
LGA    G    35_A      R      24          1.202
LGA    Y    36_A      R      25          1.549
LGA    V    37_A      T      26          3.235
LGA    G    38_A      D      27          1.615
LGA    T    39_A      -       -           -
LGA    S    40_A      -       -           -
LGA    H    41_A      -       -           -
LGA    T    42_A      -       -           -
LGA    G    43_A      -       -           -
LGA    E    44_A      -       -           -
LGA    A    45_A      E      28          3.370
LGA    S    46_A      P      29          3.096
LGA    G    47_A      G      30          1.988
LGA    I    48_A      V      31          1.108
LGA    Y    49_A      F      32          0.900
LGA    V    50_A      I      33          0.744
LGA    K    51_A      L      34          1.827
LGA    S    52_A      D      35          2.242
LGA    V    53_A      L      36          1.320
LGA    I    54_A      L      37          1.741
LGA    P    55_A      E      38          1.954
LGA    G    56_A      G      39          2.225
LGA    S    57_A      G      40          1.768
LGA    A    58_A      L      41          1.349
LGA    A    59_A      A      42          0.772
LGA    Y    60_A      A      43          1.299
LGA    H    61_A      Q      44          1.208
LGA    N    62_A      D      45          0.737
LGA    G    63_A      G      46          0.824
LGA    H    64_A      R      47          1.058
LGA    I    65_A      L      48          1.186
LGA    Q    66_A      S      49          2.120
LGA    V    67_A      S      50          1.506
LGA    N    68_A      N      51          1.697
LGA    D    69_A      D      52          1.114
LGA    K    70_A      R      53          0.948
LGA    I    71_A      V      54          0.916
LGA    V    72_A      L      55          0.969
LGA    A    73_A      A      56          0.876
LGA    V    74_A      I      57          1.147
LGA    D    75_A      N      58          1.957
LGA    G    76_A      G      59          1.512
LGA    V    77_A      H      60          1.117
LGA    N    78_A      D      61          0.688
LGA    I    79_A      L      62          0.760
LGA    Q    80_A      K      63          0.917
LGA    G    81_A      Y      64          1.338
LGA    F    82_A      G      65          1.333
LGA    A    83_A      T      66          2.102
LGA    N    84_A      P      67          2.226
LGA    H    85_A      E      68          1.401
LGA    D    86_A      L      69          1.595
LGA    V    87_A      A      70          1.779
LGA    V    88_A      A      71          1.203
LGA    E    89_A      Q      72          0.287
LGA    V    90_A      I      73          1.079
LGA    L    91_A      I      74          1.237
LGA    R    92_A      Q      75          0.949
LGA    N    93_A      A      76          1.694
LGA    A    94_A      S      77          1.797
LGA    G    95_A      G      78          1.631
LGA    Q    96_A      E      79          1.279
LGA    V    97_A      R      80          1.060
LGA    V    98_A      V      81          0.916
LGA    H    99_A      N      82          0.834
LGA    L   100_A      L      83          0.583
LGA    T   101_A      T      84          0.920
LGA    L   102_A      I      85          0.823
LGA    V   103_A      A      86          0.811
LGA    R   104_A      R      87          1.067
LGA    R   105_A      P      88          2.512
LGA    K   106_A      G      89          5.361
LGA    T   107_A      K      90          4.534
LGA    S   108_A      P      91          2.652
LGA    S   109_A      E      92           #
LGA    S   110_A      I      93           -
LGA    T   111_A      E      94           -
LGA    S   112_A      L      95           -
LGA    P   113_A      -       -           -
LGA    L   114_A      -       -           -
LGA    E   115_A      -       -           -
LGA    P   116_A      -       -           -
LGA    P   117_A      -       -           -
LGA    S   118_A      -       -           -
LGA    D   119_A      -       -           -
LGA    R   120_A      -       -           -
LGA    G   121_A      -       -           -
LGA    T   122_A      -       -           -
LGA    V   123_A      -       -           -
LGA    S   124_A      -       -           -
LGA    G   125_A      -       -           -
LGA    P   126_A      -       -           -
LGA    S   127_A      -       -           -
LGA    S   128_A      -       -           -
LGA    G   129_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  129   95    5.0     90    1.87    23.33     87.068     4.575

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.171743 * X  +   0.177502 * Y  +  -0.969019 * Z  +   7.370178
  Y_new =   0.556455 * X  +  -0.794211 * Y  +  -0.244104 * Z  +  14.233974
  Z_new =  -0.812934 * X  +  -0.581138 * Y  +   0.037628 * Z  +  15.541682 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.506137    1.635455  [ DEG:   -86.2953     93.7047 ]
  Theta =   0.949173    2.192419  [ DEG:    54.3836    125.6164 ]
  Phi   =   1.870158   -1.271434  [ DEG:   107.1522    -72.8478 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2dmz_A                                        
REMARK     2: T0488.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2dmz_A.T0488.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  129   95   5.0   90   1.87   23.33  87.068
REMARK  ---------------------------------------------------------- 
MOLECULE 2dmz_A
HEADER    PROTEIN BINDING                         24-APR-06   2DMZ              
TITLE     SOLUTION STRUCTURE OF THE THIRD PDZ DOMAIN OF HUMAN INAD-             
TITLE    2 LIKE PROTEIN                                                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: INAD-LIKE PROTEIN;                                         
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: PDZ DOMAIN;                                                
COMPND   5 SYNONYM: INADL PROTEIN, HINADL, PALS1-ASSOCIATED TIGHT               
COMPND   6 JUNCTION PROTEIN, PROTEIN ASSOCIATED TO TIGHT JUNCTIONS;             
COMPND   7 ENGINEERED: YES;                                                     
COMPND   8 MUTATION: YES                                                        
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: INADL, PATJ;                                                   
SOURCE   5 EXPRESSION_SYSTEM: CELL FREE SYNTHESIS;                              
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: P050627-17;                               
SOURCE   8 OTHER_DETAILS: CELL-FREE PROTEIN SYNTHESIS                           
KEYWDS    PDZ DOMAIN, INAD-LIKE PROTEIN, INADL PROTEIN, HINADL, PALS1-          
KEYWDS   2 ASSOCIATED TIGHT JUNCTION PROTEIN, PROTEIN ASSOCIATED TO             
KEYWDS   3 TIGHT JUNCTIONS, INADL, PATJ, STRUCTURAL GENOMICS, NPPSFA,           
KEYWDS   4 NATIONAL PROJECT ON PROTEIN STRUCTURAL AND FUNCTIONAL                
KEYWDS   5 ANALYSES, RIKEN STRUCTURAL GENOMICS/PROTEOMICS INITIATIVE,           
KEYWDS   6 RSGI                                                                 
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    K.INOUE,T.NAGASHIMA,F.HAYASHI,S.YOKOYAMA,RIKEN STRUCTURAL             
AUTHOR   2 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   1   24-OCT-06 2DMZ    0                                                
JRNL        AUTH   K.INOUE,T.NAGASHIMA,F.HAYASHI,S.YOKOYAMA                     
JRNL        TITL   SOLUTION STRUCTURE OF THE THIRD PDZ DOMAIN OF                
JRNL        TITL 2 HUMAN INAD-LIKE PROTEIN                                      
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2DMZ A    8   123  UNP    Q8NI35   INADL_HUMAN    355    470             
SEQRES   1 A  129  GLY SER SER GLY SER SER GLY GLY SER ASP SER SER LEU          
SEQRES   2 A  129  PHE GLU THR TYR ASN VAL GLU LEU VAL ARG LYS ASP GLY          
SEQRES   3 A  129  GLN SER LEU GLY ILE ARG ILE VAL GLY TYR VAL GLY THR          
SEQRES   4 A  129  SER HIS THR GLY GLU ALA SER GLY ILE TYR VAL LYS SER          
SEQRES   5 A  129  VAL ILE PRO GLY SER ALA ALA TYR HIS ASN GLY HIS ILE          
SEQRES   6 A  129  GLN VAL ASN ASP LYS ILE VAL ALA VAL ASP GLY VAL ASN          
SEQRES   7 A  129  ILE GLN GLY PHE ALA ASN HIS ASP VAL VAL GLU VAL LEU          
SEQRES   8 A  129  ARG ASN ALA GLY GLN VAL VAL HIS LEU THR LEU VAL ARG          
SEQRES   9 A  129  ARG LYS THR SER SER SER THR SER PRO LEU GLU PRO PRO          
SEQRES  10 A  129  SER ASP ARG GLY THR VAL SER GLY PRO SER SER GLY              
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   1      39.765  -7.997  21.384  1.00  0.00           N  
ATOM      2  CA  GLY A   1      39.579  -6.560  21.474  1.00  0.00           C  
ATOM      3  C   GLY A   1      38.591  -6.169  22.554  1.00  0.00           C  
ATOM      4  O   GLY A   1      38.098  -7.023  23.292  1.00  0.00           O  
ATOM      5  HA2 GLY A   1      40.532  -6.098  21.686  1.00  0.00           H  
ATOM      6  HA3 GLY A   1      39.219  -6.197  20.523  1.00  0.00           H  
ATOM      7  H1  GLY A   1      40.269  -8.468  22.081  1.00  0.00           H  
ATOM      8  N   SER A   2      38.302  -4.876  22.649  1.00  0.00           N  
ATOM      9  CA  SER A   2      37.370  -4.372  23.652  1.00  0.00           C  
ATOM     10  C   SER A   2      36.349  -3.430  23.020  1.00  0.00           C  
ATOM     11  O   SER A   2      36.423  -3.125  21.829  1.00  0.00           O  
ATOM     12  CB  SER A   2      38.128  -3.649  24.766  1.00  0.00           C  
ATOM     13  OG  SER A   2      38.897  -2.577  24.247  1.00  0.00           O  
ATOM     14  H   SER A   2      38.729  -4.244  22.032  1.00  0.00           H  
ATOM     15  HA  SER A   2      36.849  -5.219  24.073  1.00  0.00           H  
ATOM     16  HB2 SER A   2      37.422  -3.255  25.481  1.00  0.00           H  
ATOM     17  HB3 SER A   2      38.790  -4.345  25.259  1.00  0.00           H  
ATOM     18  HG  SER A   2      39.343  -2.862  23.446  1.00  0.00           H  
ATOM     19  N   SER A   3      35.397  -2.973  23.826  1.00  0.00           N  
ATOM     20  CA  SER A   3      34.359  -2.068  23.347  1.00  0.00           C  
ATOM     21  C   SER A   3      34.584  -0.654  23.875  1.00  0.00           C  
ATOM     22  O   SER A   3      35.137  -0.464  24.958  1.00  0.00           O  
ATOM     23  CB  SER A   3      32.979  -2.571  23.774  1.00  0.00           C  
ATOM     24  OG  SER A   3      32.586  -3.697  23.009  1.00  0.00           O  
ATOM     25  H   SER A   3      35.392  -3.252  24.766  1.00  0.00           H  
ATOM     26  HA  SER A   3      34.408  -2.049  22.269  1.00  0.00           H  
ATOM     27  HB2 SER A   3      33.007  -2.851  24.817  1.00  0.00           H  
ATOM     28  HB3 SER A   3      32.252  -1.783  23.633  1.00  0.00           H  
ATOM     29  HG  SER A   3      33.171  -3.790  22.253  1.00  0.00           H  
ATOM     30  N   GLY A   4      34.151   0.335  23.100  1.00  0.00           N  
ATOM     31  CA  GLY A   4      34.313   1.720  23.504  1.00  0.00           C  
ATOM     32  C   GLY A   4      33.115   2.574  23.143  1.00  0.00           C  
ATOM     33  O   GLY A   4      31.970   2.162  23.332  1.00  0.00           O  
ATOM     34  H   GLY A   4      33.717   0.124  22.247  1.00  0.00           H  
ATOM     35  HA2 GLY A   4      34.459   1.756  24.573  1.00  0.00           H  
ATOM     36  HA3 GLY A   4      35.189   2.124  23.018  1.00  0.00           H  
ATOM     37  N   SER A   5      33.377   3.768  22.622  1.00  0.00           N  
ATOM     38  CA  SER A   5      32.311   4.686  22.238  1.00  0.00           C  
ATOM     39  C   SER A   5      31.121   4.562  23.184  1.00  0.00           C  
ATOM     40  O   SER A   5      29.972   4.477  22.748  1.00  0.00           O  
ATOM     41  CB  SER A   5      31.865   4.410  20.800  1.00  0.00           C  
ATOM     42  OG  SER A   5      31.202   3.161  20.703  1.00  0.00           O  
ATOM     43  H   SER A   5      34.311   4.040  22.495  1.00  0.00           H  
ATOM     44  HA  SER A   5      32.700   5.691  22.297  1.00  0.00           H  
ATOM     45  HB2 SER A   5      31.189   5.188  20.480  1.00  0.00           H  
ATOM     46  HB3 SER A   5      32.731   4.396  20.155  1.00  0.00           H  
ATOM     47  HG  SER A   5      31.488   2.590  21.420  1.00  0.00           H  
ATOM     48  N   SER A   6      31.404   4.551  24.483  1.00  0.00           N  
ATOM     49  CA  SER A   6      30.358   4.434  25.492  1.00  0.00           C  
ATOM     50  C   SER A   6      30.465   5.558  26.519  1.00  0.00           C  
ATOM     51  O   SER A   6      31.442   5.645  27.260  1.00  0.00           O  
ATOM     52  CB  SER A   6      30.447   3.077  26.194  1.00  0.00           C  
ATOM     53  OG  SER A   6      31.493   3.065  27.150  1.00  0.00           O  
ATOM     54  H   SER A   6      32.339   4.622  24.769  1.00  0.00           H  
ATOM     55  HA  SER A   6      29.404   4.509  24.992  1.00  0.00           H  
ATOM     56  HB2 SER A   6      29.513   2.873  26.695  1.00  0.00           H  
ATOM     57  HB3 SER A   6      30.637   2.308  25.460  1.00  0.00           H  
ATOM     58  HG  SER A   6      32.289   2.712  26.749  1.00  0.00           H  
ATOM     59  N   GLY A   7      29.451   6.417  26.554  1.00  0.00           N  
ATOM     60  CA  GLY A   7      29.450   7.525  27.492  1.00  0.00           C  
ATOM     61  C   GLY A   7      30.086   8.774  26.916  1.00  0.00           C  
ATOM     62  O   GLY A   7      30.821   8.706  25.931  1.00  0.00           O  
ATOM     63  H   GLY A   7      28.698   6.298  25.938  1.00  0.00           H  
ATOM     64  HA2 GLY A   7      28.430   7.747  27.768  1.00  0.00           H  
ATOM     65  HA3 GLY A   7      29.995   7.232  28.377  1.00  0.00           H  
ATOM     66  N   GLY A   8      29.803   9.918  27.530  1.00  0.00           N  
ATOM     67  CA  GLY A   8      30.359  11.172  27.056  1.00  0.00           C  
ATOM     68  C   GLY A   8      29.517  12.367  27.454  1.00  0.00           C  
ATOM     69  O   GLY A   8      28.319  12.236  27.703  1.00  0.00           O  
ATOM     70  H   GLY A   8      29.210   9.911  28.311  1.00  0.00           H  
ATOM     71  HA2 GLY A   8      31.351  11.291  27.466  1.00  0.00           H  
ATOM     72  HA3 GLY A   8      30.428  11.138  25.978  1.00  0.00           H  
ATOM     73  N   SER A   9      30.144  13.538  27.516  1.00  0.00           N  
ATOM     74  CA  SER A   9      29.445  14.761  27.892  1.00  0.00           C  
ATOM     75  C   SER A   9      28.013  14.750  27.368  1.00  0.00           C  
ATOM     76  O   SER A   9      27.766  14.413  26.210  1.00  0.00           O  
ATOM     77  CB  SER A   9      30.189  15.984  27.353  1.00  0.00           C  
ATOM     78  OG  SER A   9      31.420  16.172  28.029  1.00  0.00           O  
ATOM     79  H   SER A   9      31.101  13.578  27.306  1.00  0.00           H  
ATOM     80  HA  SER A   9      29.422  14.811  28.971  1.00  0.00           H  
ATOM     81  HB2 SER A   9      30.387  15.847  26.301  1.00  0.00           H  
ATOM     82  HB3 SER A   9      29.578  16.864  27.493  1.00  0.00           H  
ATOM     83  HG  SER A   9      31.891  15.337  28.076  1.00  0.00           H  
ATOM     84  N   ASP A  10      27.073  15.124  28.230  1.00  0.00           N  
ATOM     85  CA  ASP A  10      25.663  15.160  27.855  1.00  0.00           C  
ATOM     86  C   ASP A  10      25.324  16.464  27.141  1.00  0.00           C  
ATOM     87  O   ASP A  10      24.296  17.084  27.413  1.00  0.00           O  
ATOM     88  CB  ASP A  10      24.780  14.997  29.093  1.00  0.00           C  
ATOM     89  CG  ASP A  10      25.033  16.074  30.130  1.00  0.00           C  
ATOM     90  OD1 ASP A  10      26.178  16.568  30.205  1.00  0.00           O  
ATOM     91  OD2 ASP A  10      24.086  16.423  30.866  1.00  0.00           O  
ATOM     92  H   ASP A  10      27.332  15.382  29.139  1.00  0.00           H  
ATOM     93  HA  ASP A  10      25.478  14.336  27.182  1.00  0.00           H  
ATOM     94  HB2 ASP A  10      23.743  15.047  28.796  1.00  0.00           H  
ATOM     95  HB3 ASP A  10      24.977  14.035  29.544  1.00  0.00           H  
ATOM     96  N   SER A  11      26.196  16.876  26.225  1.00  0.00           N  
ATOM     97  CA  SER A  11      25.991  18.109  25.475  1.00  0.00           C  
ATOM     98  C   SER A  11      25.032  17.882  24.310  1.00  0.00           C  
ATOM     99  O   SER A  11      23.962  18.487  24.246  1.00  0.00           O  
ATOM    100  CB  SER A  11      27.327  18.642  24.955  1.00  0.00           C  
ATOM    101  OG  SER A  11      27.300  20.054  24.831  1.00  0.00           O  
ATOM    102  H   SER A  11      26.996  16.337  26.053  1.00  0.00           H  
ATOM    103  HA  SER A  11      25.559  18.837  26.145  1.00  0.00           H  
ATOM    104  HB2 SER A  11      28.113  18.368  25.641  1.00  0.00           H  
ATOM    105  HB3 SER A  11      27.530  18.211  23.985  1.00  0.00           H  
ATOM    106  HG  SER A  11      26.558  20.404  25.330  1.00  0.00           H  
ATOM    107  N   SER A  12      25.426  17.009  23.389  1.00  0.00           N  
ATOM    108  CA  SER A  12      24.604  16.704  22.223  1.00  0.00           C  
ATOM    109  C   SER A  12      23.931  15.343  22.373  1.00  0.00           C  
ATOM    110  O   SER A  12      24.341  14.362  21.753  1.00  0.00           O  
ATOM    111  CB  SER A  12      25.456  16.726  20.953  1.00  0.00           C  
ATOM    112  OG  SER A  12      26.200  17.929  20.860  1.00  0.00           O  
ATOM    113  H   SER A  12      26.290  16.558  23.496  1.00  0.00           H  
ATOM    114  HA  SER A  12      23.841  17.464  22.148  1.00  0.00           H  
ATOM    115  HB2 SER A  12      26.142  15.894  20.967  1.00  0.00           H  
ATOM    116  HB3 SER A  12      24.811  16.648  20.089  1.00  0.00           H  
ATOM    117  HG  SER A  12      25.810  18.495  20.189  1.00  0.00           H  
ATOM    118  N   LEU A  13      22.893  15.292  23.201  1.00  0.00           N  
ATOM    119  CA  LEU A  13      22.160  14.052  23.434  1.00  0.00           C  
ATOM    120  C   LEU A  13      21.584  13.507  22.131  1.00  0.00           C  
ATOM    121  O   LEU A  13      21.561  12.296  21.909  1.00  0.00           O  
ATOM    122  CB  LEU A  13      21.036  14.283  24.444  1.00  0.00           C  
ATOM    123  CG  LEU A  13      21.464  14.414  25.906  1.00  0.00           C  
ATOM    124  CD1 LEU A  13      22.185  13.157  26.366  1.00  0.00           C  
ATOM    125  CD2 LEU A  13      22.347  15.639  26.097  1.00  0.00           C  
ATOM    126  H   LEU A  13      22.611  16.107  23.667  1.00  0.00           H  
ATOM    127  HA  LEU A  13      22.853  13.329  23.838  1.00  0.00           H  
ATOM    128  HB2 LEU A  13      20.523  15.192  24.167  1.00  0.00           H  
ATOM    129  HB3 LEU A  13      20.351  13.450  24.373  1.00  0.00           H  
ATOM    130  HG  LEU A  13      20.584  14.537  26.523  1.00  0.00           H  
ATOM    131 HD11 LEU A  13      21.730  12.791  27.273  1.00  0.00           H  
ATOM    132 HD12 LEU A  13      23.224  13.387  26.552  1.00  0.00           H  
ATOM    133 HD13 LEU A  13      22.117  12.402  25.598  1.00  0.00           H  
ATOM    134 HD21 LEU A  13      22.541  15.783  27.148  1.00  0.00           H  
ATOM    135 HD22 LEU A  13      21.845  16.509  25.700  1.00  0.00           H  
ATOM    136 HD23 LEU A  13      23.281  15.493  25.574  1.00  0.00           H  
ATOM    137  N   PHE A  14      21.122  14.409  21.271  1.00  0.00           N  
ATOM    138  CA  PHE A  14      20.548  14.018  19.989  1.00  0.00           C  
ATOM    139  C   PHE A  14      21.555  14.210  18.860  1.00  0.00           C  
ATOM    140  O   PHE A  14      22.627  14.781  19.061  1.00  0.00           O  
ATOM    141  CB  PHE A  14      19.284  14.832  19.703  1.00  0.00           C  
ATOM    142  CG  PHE A  14      18.426  15.055  20.916  1.00  0.00           C  
ATOM    143  CD1 PHE A  14      18.744  16.044  21.833  1.00  0.00           C  
ATOM    144  CD2 PHE A  14      17.303  14.276  21.139  1.00  0.00           C  
ATOM    145  CE1 PHE A  14      17.958  16.250  22.951  1.00  0.00           C  
ATOM    146  CE2 PHE A  14      16.513  14.478  22.255  1.00  0.00           C  
ATOM    147  CZ  PHE A  14      16.840  15.466  23.161  1.00  0.00           C  
ATOM    148  H   PHE A  14      21.168  15.359  21.505  1.00  0.00           H  
ATOM    149  HA  PHE A  14      20.286  12.973  20.049  1.00  0.00           H  
ATOM    150  HB2 PHE A  14      19.568  15.800  19.316  1.00  0.00           H  
ATOM    151  HB3 PHE A  14      18.690  14.315  18.966  1.00  0.00           H  
ATOM    152  HD1 PHE A  14      19.618  16.658  21.671  1.00  0.00           H  
ATOM    153  HD2 PHE A  14      17.046  13.501  20.431  1.00  0.00           H  
ATOM    154  HE1 PHE A  14      18.216  17.025  23.658  1.00  0.00           H  
ATOM    155  HE2 PHE A  14      15.640  13.863  22.416  1.00  0.00           H  
ATOM    156  HZ  PHE A  14      16.224  15.626  24.034  1.00  0.00           H  
ATOM    157  N   GLU A  15      21.204  13.727  17.672  1.00  0.00           N  
ATOM    158  CA  GLU A  15      22.079  13.843  16.511  1.00  0.00           C  
ATOM    159  C   GLU A  15      21.320  14.405  15.313  1.00  0.00           C  
ATOM    160  O   GLU A  15      20.243  13.922  14.963  1.00  0.00           O  
ATOM    161  CB  GLU A  15      22.678  12.481  16.157  1.00  0.00           C  
ATOM    162  CG  GLU A  15      21.636  11.399  15.928  1.00  0.00           C  
ATOM    163  CD  GLU A  15      22.103  10.336  14.952  1.00  0.00           C  
ATOM    164  OE1 GLU A  15      22.895   9.461  15.363  1.00  0.00           O  
ATOM    165  OE2 GLU A  15      21.677  10.378  13.779  1.00  0.00           O  
ATOM    166  H   GLU A  15      20.337  13.281  17.575  1.00  0.00           H  
ATOM    167  HA  GLU A  15      22.879  14.522  16.767  1.00  0.00           H  
ATOM    168  HB2 GLU A  15      23.266  12.582  15.257  1.00  0.00           H  
ATOM    169  HB3 GLU A  15      23.322  12.164  16.964  1.00  0.00           H  
ATOM    170  HG2 GLU A  15      21.413  10.926  16.872  1.00  0.00           H  
ATOM    171  HG3 GLU A  15      20.739  11.857  15.536  1.00  0.00           H  
ATOM    172  N   THR A  16      21.891  15.430  14.686  1.00  0.00           N  
ATOM    173  CA  THR A  16      21.268  16.059  13.529  1.00  0.00           C  
ATOM    174  C   THR A  16      21.800  15.466  12.228  1.00  0.00           C  
ATOM    175  O   THR A  16      22.975  15.109  12.132  1.00  0.00           O  
ATOM    176  CB  THR A  16      21.508  17.581  13.520  1.00  0.00           C  
ATOM    177  OG1 THR A  16      20.948  18.172  14.698  1.00  0.00           O  
ATOM    178  CG2 THR A  16      20.891  18.219  12.285  1.00  0.00           C  
ATOM    179  H   THR A  16      22.750  15.769  15.013  1.00  0.00           H  
ATOM    180  HA  THR A  16      20.204  15.884  13.585  1.00  0.00           H  
ATOM    181  HB  THR A  16      22.573  17.762  13.506  1.00  0.00           H  
ATOM    182  HG1 THR A  16      21.283  19.066  14.798  1.00  0.00           H  
ATOM    183 HG21 THR A  16      19.920  17.782  12.100  1.00  0.00           H  
ATOM    184 HG22 THR A  16      21.531  18.047  11.433  1.00  0.00           H  
ATOM    185 HG23 THR A  16      20.782  19.281  12.445  1.00  0.00           H  
ATOM    186  N   TYR A  17      20.928  15.363  11.231  1.00  0.00           N  
ATOM    187  CA  TYR A  17      21.310  14.810   9.937  1.00  0.00           C  
ATOM    188  C   TYR A  17      20.513  15.461   8.811  1.00  0.00           C  
ATOM    189  O   TYR A  17      19.354  15.835   8.991  1.00  0.00           O  
ATOM    190  CB  TYR A  17      21.095  13.296   9.921  1.00  0.00           C  
ATOM    191  CG  TYR A  17      19.673  12.884  10.232  1.00  0.00           C  
ATOM    192  CD1 TYR A  17      19.235  12.767  11.545  1.00  0.00           C  
ATOM    193  CD2 TYR A  17      18.770  12.610   9.213  1.00  0.00           C  
ATOM    194  CE1 TYR A  17      17.937  12.389  11.833  1.00  0.00           C  
ATOM    195  CE2 TYR A  17      17.471  12.234   9.491  1.00  0.00           C  
ATOM    196  CZ  TYR A  17      17.059  12.125  10.804  1.00  0.00           C  
ATOM    197  OH  TYR A  17      15.765  11.749  11.087  1.00  0.00           O  
ATOM    198  H   TYR A  17      20.006  15.664  11.369  1.00  0.00           H  
ATOM    199  HA  TYR A  17      22.360  15.016   9.785  1.00  0.00           H  
ATOM    200  HB2 TYR A  17      21.344  12.914   8.944  1.00  0.00           H  
ATOM    201  HB3 TYR A  17      21.741  12.840  10.657  1.00  0.00           H  
ATOM    202  HD1 TYR A  17      19.925  12.974  12.349  1.00  0.00           H  
ATOM    203  HD2 TYR A  17      19.096  12.697   8.186  1.00  0.00           H  
ATOM    204  HE1 TYR A  17      17.615  12.304  12.861  1.00  0.00           H  
ATOM    205  HE2 TYR A  17      16.783  12.027   8.685  1.00  0.00           H  
ATOM    206  HH  TYR A  17      15.594  11.871  12.023  1.00  0.00           H  
ATOM    207  N   ASN A  18      21.142  15.590   7.647  1.00  0.00           N  
ATOM    208  CA  ASN A  18      20.491  16.195   6.490  1.00  0.00           C  
ATOM    209  C   ASN A  18      19.951  15.123   5.548  1.00  0.00           C  
ATOM    210  O   ASN A  18      20.605  14.109   5.302  1.00  0.00           O  
ATOM    211  CB  ASN A  18      21.473  17.099   5.742  1.00  0.00           C  
ATOM    212  CG  ASN A  18      21.491  18.512   6.292  1.00  0.00           C  
ATOM    213  OD1 ASN A  18      21.046  19.452   5.633  1.00  0.00           O  
ATOM    214  ND2 ASN A  18      22.008  18.668   7.505  1.00  0.00           N  
ATOM    215  H   ASN A  18      22.065  15.272   7.564  1.00  0.00           H  
ATOM    216  HA  ASN A  18      19.667  16.792   6.848  1.00  0.00           H  
ATOM    217  HB2 ASN A  18      22.468  16.688   5.827  1.00  0.00           H  
ATOM    218  HB3 ASN A  18      21.193  17.140   4.700  1.00  0.00           H  
ATOM    219 HD21 ASN A  18      22.344  17.875   7.971  1.00  0.00           H  
ATOM    220 HD22 ASN A  18      22.031  19.572   7.885  1.00  0.00           H  
ATOM    221  N   VAL A  19      18.751  15.355   5.023  1.00  0.00           N  
ATOM    222  CA  VAL A  19      18.124  14.410   4.107  1.00  0.00           C  
ATOM    223  C   VAL A  19      17.765  15.082   2.786  1.00  0.00           C  
ATOM    224  O   VAL A  19      16.911  15.967   2.741  1.00  0.00           O  
ATOM    225  CB  VAL A  19      16.851  13.795   4.719  1.00  0.00           C  
ATOM    226  CG1 VAL A  19      16.496  12.493   4.018  1.00  0.00           C  
ATOM    227  CG2 VAL A  19      17.034  13.573   6.213  1.00  0.00           C  
ATOM    228  H   VAL A  19      18.279  16.180   5.257  1.00  0.00           H  
ATOM    229  HA  VAL A  19      18.827  13.613   3.914  1.00  0.00           H  
ATOM    230  HB  VAL A  19      16.036  14.489   4.576  1.00  0.00           H  
ATOM    231 HG11 VAL A  19      16.834  12.533   2.993  1.00  0.00           H  
ATOM    232 HG12 VAL A  19      16.977  11.668   4.525  1.00  0.00           H  
ATOM    233 HG13 VAL A  19      15.426  12.354   4.038  1.00  0.00           H  
ATOM    234 HG21 VAL A  19      16.739  12.566   6.466  1.00  0.00           H  
ATOM    235 HG22 VAL A  19      18.072  13.722   6.476  1.00  0.00           H  
ATOM    236 HG23 VAL A  19      16.421  14.276   6.760  1.00  0.00           H  
ATOM    237  N   GLU A  20      18.422  14.655   1.713  1.00  0.00           N  
ATOM    238  CA  GLU A  20      18.172  15.215   0.390  1.00  0.00           C  
ATOM    239  C   GLU A  20      17.052  14.459  -0.319  1.00  0.00           C  
ATOM    240  O   GLU A  20      17.280  13.405  -0.914  1.00  0.00           O  
ATOM    241  CB  GLU A  20      19.447  15.174  -0.456  1.00  0.00           C  
ATOM    242  CG  GLU A  20      19.270  15.744  -1.852  1.00  0.00           C  
ATOM    243  CD  GLU A  20      20.187  15.095  -2.870  1.00  0.00           C  
ATOM    244  OE1 GLU A  20      21.279  14.634  -2.475  1.00  0.00           O  
ATOM    245  OE2 GLU A  20      19.813  15.046  -4.060  1.00  0.00           O  
ATOM    246  H   GLU A  20      19.091  13.945   1.813  1.00  0.00           H  
ATOM    247  HA  GLU A  20      17.871  16.244   0.518  1.00  0.00           H  
ATOM    248  HB2 GLU A  20      20.217  15.739   0.048  1.00  0.00           H  
ATOM    249  HB3 GLU A  20      19.769  14.147  -0.548  1.00  0.00           H  
ATOM    250  HG2 GLU A  20      18.247  15.591  -2.163  1.00  0.00           H  
ATOM    251  HG3 GLU A  20      19.480  16.803  -1.824  1.00  0.00           H  
ATOM    252  N   LEU A  21      15.843  15.004  -0.251  1.00  0.00           N  
ATOM    253  CA  LEU A  21      14.687  14.382  -0.886  1.00  0.00           C  
ATOM    254  C   LEU A  21      14.580  14.795  -2.350  1.00  0.00           C  
ATOM    255  O   LEU A  21      14.955  15.909  -2.720  1.00  0.00           O  
ATOM    256  CB  LEU A  21      13.405  14.763  -0.143  1.00  0.00           C  
ATOM    257  CG  LEU A  21      13.376  14.441   1.352  1.00  0.00           C  
ATOM    258  CD1 LEU A  21      12.127  15.021   1.998  1.00  0.00           C  
ATOM    259  CD2 LEU A  21      13.446  12.938   1.576  1.00  0.00           C  
ATOM    260  H   LEU A  21      15.724  15.845   0.238  1.00  0.00           H  
ATOM    261  HA  LEU A  21      14.818  13.311  -0.836  1.00  0.00           H  
ATOM    262  HB2 LEU A  21      13.262  15.826  -0.254  1.00  0.00           H  
ATOM    263  HB3 LEU A  21      12.584  14.238  -0.611  1.00  0.00           H  
ATOM    264  HG  LEU A  21      14.236  14.892   1.828  1.00  0.00           H  
ATOM    265 HD11 LEU A  21      11.403  14.234   2.150  1.00  0.00           H  
ATOM    266 HD12 LEU A  21      11.707  15.778   1.354  1.00  0.00           H  
ATOM    267 HD13 LEU A  21      12.385  15.461   2.950  1.00  0.00           H  
ATOM    268 HD21 LEU A  21      14.170  12.723   2.348  1.00  0.00           H  
ATOM    269 HD22 LEU A  21      13.743  12.450   0.659  1.00  0.00           H  
ATOM    270 HD23 LEU A  21      12.476  12.574   1.880  1.00  0.00           H  
ATOM    271  N   VAL A  22      14.066  13.893  -3.179  1.00  0.00           N  
ATOM    272  CA  VAL A  22      13.908  14.165  -4.603  1.00  0.00           C  
ATOM    273  C   VAL A  22      12.435  14.275  -4.980  1.00  0.00           C  
ATOM    274  O   VAL A  22      11.614  13.456  -4.568  1.00  0.00           O  
ATOM    275  CB  VAL A  22      14.565  13.067  -5.461  1.00  0.00           C  
ATOM    276  CG1 VAL A  22      13.822  11.750  -5.303  1.00  0.00           C  
ATOM    277  CG2 VAL A  22      14.612  13.491  -6.922  1.00  0.00           C  
ATOM    278  H   VAL A  22      13.786  13.023  -2.825  1.00  0.00           H  
ATOM    279  HA  VAL A  22      14.396  15.104  -4.820  1.00  0.00           H  
ATOM    280  HB  VAL A  22      15.579  12.928  -5.115  1.00  0.00           H  
ATOM    281 HG11 VAL A  22      12.879  11.803  -5.828  1.00  0.00           H  
ATOM    282 HG12 VAL A  22      14.419  10.948  -5.713  1.00  0.00           H  
ATOM    283 HG13 VAL A  22      13.639  11.563  -4.254  1.00  0.00           H  
ATOM    284 HG21 VAL A  22      13.664  13.273  -7.389  1.00  0.00           H  
ATOM    285 HG22 VAL A  22      14.809  14.551  -6.983  1.00  0.00           H  
ATOM    286 HG23 VAL A  22      15.397  12.949  -7.429  1.00  0.00           H  
ATOM    287  N   ARG A  23      12.106  15.295  -5.767  1.00  0.00           N  
ATOM    288  CA  ARG A  23      10.732  15.515  -6.200  1.00  0.00           C  
ATOM    289  C   ARG A  23      10.551  15.116  -7.661  1.00  0.00           C  
ATOM    290  O   ARG A  23      10.984  15.829  -8.569  1.00  0.00           O  
ATOM    291  CB  ARG A  23      10.341  16.981  -6.008  1.00  0.00           C  
ATOM    292  CG  ARG A  23      10.417  17.448  -4.563  1.00  0.00           C  
ATOM    293  CD  ARG A  23       9.401  18.543  -4.278  1.00  0.00           C  
ATOM    294  NE  ARG A  23       9.651  19.741  -5.074  1.00  0.00           N  
ATOM    295  CZ  ARG A  23       8.712  20.631  -5.378  1.00  0.00           C  
ATOM    296  NH1 ARG A  23       7.469  20.457  -4.953  1.00  0.00           N  
ATOM    297  NH2 ARG A  23       9.017  21.696  -6.108  1.00  0.00           N  
ATOM    298  H   ARG A  23      12.805  15.916  -6.062  1.00  0.00           H  
ATOM    299  HA  ARG A  23      10.089  14.897  -5.589  1.00  0.00           H  
ATOM    300  HB2 ARG A  23      11.004  17.598  -6.597  1.00  0.00           H  
ATOM    301  HB3 ARG A  23       9.328  17.120  -6.356  1.00  0.00           H  
ATOM    302  HG2 ARG A  23      10.217  16.609  -3.913  1.00  0.00           H  
ATOM    303  HG3 ARG A  23      11.408  17.827  -4.369  1.00  0.00           H  
ATOM    304  HD2 ARG A  23       8.414  18.170  -4.506  1.00  0.00           H  
ATOM    305  HD3 ARG A  23       9.455  18.801  -3.230  1.00  0.00           H  
ATOM    306  HE  ARG A  23      10.564  19.889  -5.398  1.00  0.00           H  
ATOM    307 HH11 ARG A  23       7.236  19.656  -4.402  1.00  0.00           H  
ATOM    308 HH12 ARG A  23       6.763  21.129  -5.182  1.00  0.00           H  
ATOM    309 HH21 ARG A  23       9.954  21.830  -6.429  1.00  0.00           H  
ATOM    310 HH22 ARG A  23       8.310  22.365  -6.336  1.00  0.00           H  
ATOM    311  N   LYS A  24       9.912  13.973  -7.884  1.00  0.00           N  
ATOM    312  CA  LYS A  24       9.674  13.479  -9.235  1.00  0.00           C  
ATOM    313  C   LYS A  24       9.047  14.562 -10.108  1.00  0.00           C  
ATOM    314  O   LYS A  24       8.734  15.653  -9.631  1.00  0.00           O  
ATOM    315  CB  LYS A  24       8.764  12.249  -9.198  1.00  0.00           C  
ATOM    316  CG  LYS A  24       9.519  10.938  -9.067  1.00  0.00           C  
ATOM    317  CD  LYS A  24       9.990  10.428 -10.418  1.00  0.00           C  
ATOM    318  CE  LYS A  24       8.966   9.497 -11.051  1.00  0.00           C  
ATOM    319  NZ  LYS A  24       8.028  10.229 -11.945  1.00  0.00           N  
ATOM    320  H   LYS A  24       9.591  13.449  -7.120  1.00  0.00           H  
ATOM    321  HA  LYS A  24      10.626  13.199  -9.659  1.00  0.00           H  
ATOM    322  HB2 LYS A  24       8.092  12.340  -8.357  1.00  0.00           H  
ATOM    323  HB3 LYS A  24       8.185  12.217 -10.109  1.00  0.00           H  
ATOM    324  HG2 LYS A  24      10.380  11.090  -8.432  1.00  0.00           H  
ATOM    325  HG3 LYS A  24       8.867  10.200  -8.621  1.00  0.00           H  
ATOM    326  HD2 LYS A  24      10.148  11.270 -11.076  1.00  0.00           H  
ATOM    327  HD3 LYS A  24      10.919   9.892 -10.288  1.00  0.00           H  
ATOM    328  HE2 LYS A  24       9.487   8.748 -11.626  1.00  0.00           H  
ATOM    329  HE3 LYS A  24       8.400   9.019 -10.264  1.00  0.00           H  
ATOM    330  HZ1 LYS A  24       7.062   9.864 -11.827  1.00  0.00           H  
ATOM    331  HZ2 LYS A  24       8.313  10.108 -12.938  1.00  0.00           H  
ATOM    332  HZ3 LYS A  24       8.034  11.244 -11.716  1.00  0.00           H  
ATOM    333  N   ASP A  25       8.866  14.253 -11.387  1.00  0.00           N  
ATOM    334  CA  ASP A  25       8.273  15.199 -12.326  1.00  0.00           C  
ATOM    335  C   ASP A  25       6.809  15.457 -11.986  1.00  0.00           C  
ATOM    336  O   ASP A  25       5.910  14.846 -12.562  1.00  0.00           O  
ATOM    337  CB  ASP A  25       8.392  14.672 -13.757  1.00  0.00           C  
ATOM    338  CG  ASP A  25       9.834  14.549 -14.210  1.00  0.00           C  
ATOM    339  OD1 ASP A  25      10.599  15.518 -14.025  1.00  0.00           O  
ATOM    340  OD2 ASP A  25      10.197  13.482 -14.749  1.00  0.00           O  
ATOM    341  H   ASP A  25       9.135  13.366 -11.708  1.00  0.00           H  
ATOM    342  HA  ASP A  25       8.817  16.128 -12.247  1.00  0.00           H  
ATOM    343  HB2 ASP A  25       7.931  13.697 -13.814  1.00  0.00           H  
ATOM    344  HB3 ASP A  25       7.879  15.348 -14.426  1.00  0.00           H  
ATOM    345  N   GLY A  26       6.577  16.367 -11.043  1.00  0.00           N  
ATOM    346  CA  GLY A  26       5.220  16.689 -10.642  1.00  0.00           C  
ATOM    347  C   GLY A  26       4.832  16.034  -9.332  1.00  0.00           C  
ATOM    348  O   GLY A  26       3.710  15.550  -9.181  1.00  0.00           O  
ATOM    349  H   GLY A  26       7.333  16.822 -10.618  1.00  0.00           H  
ATOM    350  HA2 GLY A  26       5.132  17.761 -10.537  1.00  0.00           H  
ATOM    351  HA3 GLY A  26       4.540  16.356 -11.412  1.00  0.00           H  
ATOM    352  N   GLN A  27       5.762  16.017  -8.383  1.00  0.00           N  
ATOM    353  CA  GLN A  27       5.512  15.412  -7.079  1.00  0.00           C  
ATOM    354  C   GLN A  27       5.676  16.439  -5.962  1.00  0.00           C  
ATOM    355  O   GLN A  27       6.316  17.474  -6.148  1.00  0.00           O  
ATOM    356  CB  GLN A  27       6.458  14.234  -6.848  1.00  0.00           C  
ATOM    357  CG  GLN A  27       6.220  13.509  -5.534  1.00  0.00           C  
ATOM    358  CD  GLN A  27       6.863  12.136  -5.498  1.00  0.00           C  
ATOM    359  OE1 GLN A  27       6.174  11.118  -5.447  1.00  0.00           O  
ATOM    360  NE2 GLN A  27       8.190  12.103  -5.526  1.00  0.00           N  
ATOM    361  H   GLN A  27       6.636  16.418  -8.563  1.00  0.00           H  
ATOM    362  HA  GLN A  27       4.494  15.052  -7.071  1.00  0.00           H  
ATOM    363  HB2 GLN A  27       6.334  13.525  -7.653  1.00  0.00           H  
ATOM    364  HB3 GLN A  27       7.476  14.598  -6.855  1.00  0.00           H  
ATOM    365  HG2 GLN A  27       6.632  14.103  -4.731  1.00  0.00           H  
ATOM    366  HG3 GLN A  27       5.156  13.398  -5.388  1.00  0.00           H  
ATOM    367 HE21 GLN A  27       8.673  12.956  -5.566  1.00  0.00           H  
ATOM    368 HE22 GLN A  27       8.631  11.230  -5.503  1.00  0.00           H  
ATOM    369  N   SER A  28       5.096  16.144  -4.805  1.00  0.00           N  
ATOM    370  CA  SER A  28       5.175  17.044  -3.659  1.00  0.00           C  
ATOM    371  C   SER A  28       6.029  16.437  -2.550  1.00  0.00           C  
ATOM    372  O   SER A  28       6.527  15.317  -2.676  1.00  0.00           O  
ATOM    373  CB  SER A  28       3.774  17.352  -3.128  1.00  0.00           C  
ATOM    374  OG  SER A  28       3.216  16.224  -2.476  1.00  0.00           O  
ATOM    375  H   SER A  28       4.599  15.303  -4.718  1.00  0.00           H  
ATOM    376  HA  SER A  28       5.635  17.962  -3.991  1.00  0.00           H  
ATOM    377  HB2 SER A  28       3.830  18.168  -2.423  1.00  0.00           H  
ATOM    378  HB3 SER A  28       3.133  17.631  -3.952  1.00  0.00           H  
ATOM    379  HG  SER A  28       3.492  16.217  -1.556  1.00  0.00           H  
ATOM    380  N   LEU A  29       6.196  17.184  -1.465  1.00  0.00           N  
ATOM    381  CA  LEU A  29       6.990  16.721  -0.332  1.00  0.00           C  
ATOM    382  C   LEU A  29       6.300  15.561   0.380  1.00  0.00           C  
ATOM    383  O   LEU A  29       6.897  14.505   0.589  1.00  0.00           O  
ATOM    384  CB  LEU A  29       7.228  17.869   0.652  1.00  0.00           C  
ATOM    385  CG  LEU A  29       8.531  17.809   1.450  1.00  0.00           C  
ATOM    386  CD1 LEU A  29       9.732  17.845   0.517  1.00  0.00           C  
ATOM    387  CD2 LEU A  29       8.597  18.954   2.450  1.00  0.00           C  
ATOM    388  H   LEU A  29       5.775  18.067  -1.423  1.00  0.00           H  
ATOM    389  HA  LEU A  29       7.941  16.380  -0.711  1.00  0.00           H  
ATOM    390  HB2 LEU A  29       7.226  18.790   0.091  1.00  0.00           H  
ATOM    391  HB3 LEU A  29       6.408  17.876   1.356  1.00  0.00           H  
ATOM    392  HG  LEU A  29       8.566  16.879   2.001  1.00  0.00           H  
ATOM    393 HD11 LEU A  29      10.396  18.641   0.816  1.00  0.00           H  
ATOM    394 HD12 LEU A  29       9.395  18.016  -0.495  1.00  0.00           H  
ATOM    395 HD13 LEU A  29      10.254  16.901   0.566  1.00  0.00           H  
ATOM    396 HD21 LEU A  29       7.611  19.372   2.582  1.00  0.00           H  
ATOM    397 HD22 LEU A  29       9.266  19.717   2.080  1.00  0.00           H  
ATOM    398 HD23 LEU A  29       8.962  18.583   3.397  1.00  0.00           H  
ATOM    399  N   GLY A  30       5.039  15.765   0.747  1.00  0.00           N  
ATOM    400  CA  GLY A  30       4.288  14.727   1.428  1.00  0.00           C  
ATOM    401  C   GLY A  30       4.710  14.560   2.875  1.00  0.00           C  
ATOM    402  O   GLY A  30       4.870  13.438   3.356  1.00  0.00           O  
ATOM    403  H   GLY A  30       4.615  16.627   0.554  1.00  0.00           H  
ATOM    404  HA2 GLY A  30       3.238  14.978   1.398  1.00  0.00           H  
ATOM    405  HA3 GLY A  30       4.439  13.791   0.912  1.00  0.00           H  
ATOM    406  N   ILE A  31       4.893  15.679   3.568  1.00  0.00           N  
ATOM    407  CA  ILE A  31       5.300  15.651   4.968  1.00  0.00           C  
ATOM    408  C   ILE A  31       4.422  16.567   5.814  1.00  0.00           C  
ATOM    409  O   ILE A  31       4.370  17.776   5.588  1.00  0.00           O  
ATOM    410  CB  ILE A  31       6.772  16.072   5.134  1.00  0.00           C  
ATOM    411  CG1 ILE A  31       7.689  15.110   4.375  1.00  0.00           C  
ATOM    412  CG2 ILE A  31       7.148  16.116   6.608  1.00  0.00           C  
ATOM    413  CD1 ILE A  31       9.120  15.592   4.276  1.00  0.00           C  
ATOM    414  H   ILE A  31       4.749  16.542   3.129  1.00  0.00           H  
ATOM    415  HA  ILE A  31       5.194  14.637   5.325  1.00  0.00           H  
ATOM    416  HB  ILE A  31       6.888  17.065   4.728  1.00  0.00           H  
ATOM    417 HG12 ILE A  31       7.695  14.156   4.876  1.00  0.00           H  
ATOM    418 HG13 ILE A  31       7.312  14.983   3.371  1.00  0.00           H  
ATOM    419 HG21 ILE A  31       6.251  16.071   7.209  1.00  0.00           H  
ATOM    420 HG22 ILE A  31       7.780  15.275   6.843  1.00  0.00           H  
ATOM    421 HG23 ILE A  31       7.675  17.035   6.818  1.00  0.00           H  
ATOM    422 HD11 ILE A  31       9.648  15.004   3.539  1.00  0.00           H  
ATOM    423 HD12 ILE A  31       9.132  16.630   3.986  1.00  0.00           H  
ATOM    424 HD13 ILE A  31       9.603  15.481   5.236  1.00  0.00           H  
ATOM    425  N   ARG A  32       3.736  15.983   6.791  1.00  0.00           N  
ATOM    426  CA  ARG A  32       2.861  16.747   7.672  1.00  0.00           C  
ATOM    427  C   ARG A  32       3.624  17.248   8.895  1.00  0.00           C  
ATOM    428  O   ARG A  32       4.395  16.506   9.504  1.00  0.00           O  
ATOM    429  CB  ARG A  32       1.674  15.890   8.114  1.00  0.00           C  
ATOM    430  CG  ARG A  32       0.804  15.413   6.962  1.00  0.00           C  
ATOM    431  CD  ARG A  32       0.009  16.557   6.353  1.00  0.00           C  
ATOM    432  NE  ARG A  32      -1.103  16.077   5.536  1.00  0.00           N  
ATOM    433  CZ  ARG A  32      -1.876  16.873   4.807  1.00  0.00           C  
ATOM    434  NH1 ARG A  32      -1.661  18.182   4.793  1.00  0.00           N  
ATOM    435  NH2 ARG A  32      -2.868  16.362   4.090  1.00  0.00           N  
ATOM    436  H   ARG A  32       3.819  15.016   6.922  1.00  0.00           H  
ATOM    437  HA  ARG A  32       2.494  17.598   7.118  1.00  0.00           H  
ATOM    438  HB2 ARG A  32       2.046  15.023   8.639  1.00  0.00           H  
ATOM    439  HB3 ARG A  32       1.058  16.469   8.785  1.00  0.00           H  
ATOM    440  HG2 ARG A  32       1.438  14.984   6.199  1.00  0.00           H  
ATOM    441  HG3 ARG A  32       0.119  14.663   7.327  1.00  0.00           H  
ATOM    442  HD2 ARG A  32      -0.382  17.171   7.151  1.00  0.00           H  
ATOM    443  HD3 ARG A  32       0.669  17.147   5.735  1.00  0.00           H  
ATOM    444  HE  ARG A  32      -1.279  15.114   5.531  1.00  0.00           H  
ATOM    445 HH11 ARG A  32      -0.913  18.569   5.332  1.00  0.00           H  
ATOM    446 HH12 ARG A  32      -2.244  18.779   4.242  1.00  0.00           H  
ATOM    447 HH21 ARG A  32      -3.034  15.376   4.097  1.00  0.00           H  
ATOM    448 HH22 ARG A  32      -3.450  16.961   3.542  1.00  0.00           H  
ATOM    449  N   ILE A  33       3.404  18.510   9.247  1.00  0.00           N  
ATOM    450  CA  ILE A  33       4.069  19.109  10.397  1.00  0.00           C  
ATOM    451  C   ILE A  33       3.068  19.456  11.493  1.00  0.00           C  
ATOM    452  O   ILE A  33       1.869  19.575  11.239  1.00  0.00           O  
ATOM    453  CB  ILE A  33       4.842  20.381  10.001  1.00  0.00           C  
ATOM    454  CG1 ILE A  33       3.892  21.407   9.380  1.00  0.00           C  
ATOM    455  CG2 ILE A  33       5.966  20.040   9.035  1.00  0.00           C  
ATOM    456  CD1 ILE A  33       4.323  22.840   9.600  1.00  0.00           C  
ATOM    457  H   ILE A  33       2.778  19.050   8.722  1.00  0.00           H  
ATOM    458  HA  ILE A  33       4.776  18.389  10.785  1.00  0.00           H  
ATOM    459  HB  ILE A  33       5.280  20.801  10.892  1.00  0.00           H  
ATOM    460 HG12 ILE A  33       3.834  21.239   8.316  1.00  0.00           H  
ATOM    461 HG13 ILE A  33       2.909  21.285   9.813  1.00  0.00           H  
ATOM    462 HG21 ILE A  33       6.627  20.888   8.939  1.00  0.00           H  
ATOM    463 HG22 ILE A  33       6.520  19.193   9.413  1.00  0.00           H  
ATOM    464 HG23 ILE A  33       5.550  19.796   8.069  1.00  0.00           H  
ATOM    465 HD11 ILE A  33       4.882  22.912  10.521  1.00  0.00           H  
ATOM    466 HD12 ILE A  33       4.942  23.161   8.776  1.00  0.00           H  
ATOM    467 HD13 ILE A  33       3.450  23.474   9.660  1.00  0.00           H  
ATOM    468  N   VAL A  34       3.567  19.619  12.715  1.00  0.00           N  
ATOM    469  CA  VAL A  34       2.717  19.956  13.849  1.00  0.00           C  
ATOM    470  C   VAL A  34       3.325  21.084  14.676  1.00  0.00           C  
ATOM    471  O   VAL A  34       4.539  21.142  14.868  1.00  0.00           O  
ATOM    472  CB  VAL A  34       2.486  18.735  14.760  1.00  0.00           C  
ATOM    473  CG1 VAL A  34       3.707  18.476  15.627  1.00  0.00           C  
ATOM    474  CG2 VAL A  34       1.245  18.936  15.616  1.00  0.00           C  
ATOM    475  H   VAL A  34       4.531  19.510  12.855  1.00  0.00           H  
ATOM    476  HA  VAL A  34       1.761  20.280  13.466  1.00  0.00           H  
ATOM    477  HB  VAL A  34       2.328  17.869  14.133  1.00  0.00           H  
ATOM    478 HG11 VAL A  34       4.540  18.192  15.002  1.00  0.00           H  
ATOM    479 HG12 VAL A  34       3.957  19.373  16.175  1.00  0.00           H  
ATOM    480 HG13 VAL A  34       3.492  17.678  16.323  1.00  0.00           H  
ATOM    481 HG21 VAL A  34       0.983  19.984  15.627  1.00  0.00           H  
ATOM    482 HG22 VAL A  34       0.425  18.365  15.204  1.00  0.00           H  
ATOM    483 HG23 VAL A  34       1.445  18.604  16.623  1.00  0.00           H  
ATOM    484  N   GLY A  35       2.472  21.978  15.165  1.00  0.00           N  
ATOM    485  CA  GLY A  35       2.944  23.093  15.966  1.00  0.00           C  
ATOM    486  C   GLY A  35       2.673  22.898  17.445  1.00  0.00           C  
ATOM    487  O   GLY A  35       1.525  22.953  17.885  1.00  0.00           O  
ATOM    488  H   GLY A  35       1.514  21.881  14.979  1.00  0.00           H  
ATOM    489  HA2 GLY A  35       4.007  23.204  15.816  1.00  0.00           H  
ATOM    490  HA3 GLY A  35       2.447  23.993  15.637  1.00  0.00           H  
ATOM    491  N   TYR A  36       3.733  22.670  18.212  1.00  0.00           N  
ATOM    492  CA  TYR A  36       3.604  22.463  19.650  1.00  0.00           C  
ATOM    493  C   TYR A  36       3.946  23.738  20.417  1.00  0.00           C  
ATOM    494  O   TYR A  36       4.792  24.523  19.993  1.00  0.00           O  
ATOM    495  CB  TYR A  36       4.515  21.321  20.106  1.00  0.00           C  
ATOM    496  CG  TYR A  36       3.819  19.981  20.171  1.00  0.00           C  
ATOM    497  CD1 TYR A  36       3.785  19.140  19.064  1.00  0.00           C  
ATOM    498  CD2 TYR A  36       3.195  19.556  21.336  1.00  0.00           C  
ATOM    499  CE1 TYR A  36       3.150  17.914  19.119  1.00  0.00           C  
ATOM    500  CE2 TYR A  36       2.558  18.331  21.400  1.00  0.00           C  
ATOM    501  CZ  TYR A  36       2.539  17.514  20.288  1.00  0.00           C  
ATOM    502  OH  TYR A  36       1.905  16.294  20.348  1.00  0.00           O  
ATOM    503  H   TYR A  36       4.623  22.638  17.803  1.00  0.00           H  
ATOM    504  HA  TYR A  36       2.578  22.196  19.857  1.00  0.00           H  
ATOM    505  HB2 TYR A  36       5.342  21.233  19.418  1.00  0.00           H  
ATOM    506  HB3 TYR A  36       4.897  21.546  21.091  1.00  0.00           H  
ATOM    507  HD1 TYR A  36       4.265  19.456  18.150  1.00  0.00           H  
ATOM    508  HD2 TYR A  36       3.212  20.198  22.205  1.00  0.00           H  
ATOM    509  HE1 TYR A  36       3.135  17.275  18.249  1.00  0.00           H  
ATOM    510  HE2 TYR A  36       2.080  18.018  22.316  1.00  0.00           H  
ATOM    511  HH  TYR A  36       1.090  16.382  20.848  1.00  0.00           H  
ATOM    512  N   VAL A  37       3.280  23.934  21.550  1.00  0.00           N  
ATOM    513  CA  VAL A  37       3.512  25.112  22.378  1.00  0.00           C  
ATOM    514  C   VAL A  37       3.994  24.718  23.771  1.00  0.00           C  
ATOM    515  O   VAL A  37       4.697  25.479  24.434  1.00  0.00           O  
ATOM    516  CB  VAL A  37       2.237  25.965  22.512  1.00  0.00           C  
ATOM    517  CG1 VAL A  37       2.480  27.149  23.434  1.00  0.00           C  
ATOM    518  CG2 VAL A  37       1.764  26.433  21.144  1.00  0.00           C  
ATOM    519  H   VAL A  37       2.616  23.272  21.836  1.00  0.00           H  
ATOM    520  HA  VAL A  37       4.273  25.712  21.901  1.00  0.00           H  
ATOM    521  HB  VAL A  37       1.461  25.351  22.947  1.00  0.00           H  
ATOM    522 HG11 VAL A  37       1.584  27.750  23.493  1.00  0.00           H  
ATOM    523 HG12 VAL A  37       2.740  26.792  24.420  1.00  0.00           H  
ATOM    524 HG13 VAL A  37       3.289  27.750  23.043  1.00  0.00           H  
ATOM    525 HG21 VAL A  37       2.608  26.494  20.473  1.00  0.00           H  
ATOM    526 HG22 VAL A  37       1.043  25.729  20.751  1.00  0.00           H  
ATOM    527 HG23 VAL A  37       1.303  27.405  21.235  1.00  0.00           H  
ATOM    528  N   GLY A  38       3.612  23.522  24.206  1.00  0.00           N  
ATOM    529  CA  GLY A  38       4.014  23.047  25.517  1.00  0.00           C  
ATOM    530  C   GLY A  38       3.498  23.928  26.638  1.00  0.00           C  
ATOM    531  O   GLY A  38       4.254  24.704  27.227  1.00  0.00           O  
ATOM    532  H   GLY A  38       3.050  22.957  23.635  1.00  0.00           H  
ATOM    533  HA2 GLY A  38       3.635  22.046  25.657  1.00  0.00           H  
ATOM    534  HA3 GLY A  38       5.094  23.022  25.562  1.00  0.00           H  
ATOM    535  N   THR A  39       2.208  23.813  26.933  1.00  0.00           N  
ATOM    536  CA  THR A  39       1.591  24.607  27.988  1.00  0.00           C  
ATOM    537  C   THR A  39       2.252  24.342  29.335  1.00  0.00           C  
ATOM    538  O   THR A  39       3.147  23.503  29.443  1.00  0.00           O  
ATOM    539  CB  THR A  39       0.083  24.315  28.103  1.00  0.00           C  
ATOM    540  OG1 THR A  39      -0.549  25.311  28.914  1.00  0.00           O  
ATOM    541  CG2 THR A  39      -0.158  22.938  28.702  1.00  0.00           C  
ATOM    542  H   THR A  39       1.658  23.178  26.428  1.00  0.00           H  
ATOM    543  HA  THR A  39       1.716  25.650  27.736  1.00  0.00           H  
ATOM    544  HB  THR A  39      -0.350  24.341  27.112  1.00  0.00           H  
ATOM    545  HG1 THR A  39      -0.619  24.991  29.817  1.00  0.00           H  
ATOM    546 HG21 THR A  39       0.481  22.216  28.214  1.00  0.00           H  
ATOM    547 HG22 THR A  39      -1.191  22.659  28.560  1.00  0.00           H  
ATOM    548 HG23 THR A  39       0.068  22.962  29.758  1.00  0.00           H  
ATOM    549  N   SER A  40       1.807  25.060  30.361  1.00  0.00           N  
ATOM    550  CA  SER A  40       2.358  24.904  31.700  1.00  0.00           C  
ATOM    551  C   SER A  40       1.646  23.784  32.454  1.00  0.00           C  
ATOM    552  O   SER A  40       0.510  23.430  32.135  1.00  0.00           O  
ATOM    553  CB  SER A  40       2.239  26.214  32.481  1.00  0.00           C  
ATOM    554  OG  SER A  40       3.244  26.310  33.475  1.00  0.00           O  
ATOM    555  H   SER A  40       1.091  25.714  30.210  1.00  0.00           H  
ATOM    556  HA  SER A  40       3.403  24.647  31.602  1.00  0.00           H  
ATOM    557  HB2 SER A  40       2.342  27.046  31.801  1.00  0.00           H  
ATOM    558  HB3 SER A  40       1.271  26.259  32.960  1.00  0.00           H  
ATOM    559  HG  SER A  40       3.991  25.760  33.228  1.00  0.00           H  
ATOM    560  N   HIS A  41       2.322  23.230  33.455  1.00  0.00           N  
ATOM    561  CA  HIS A  41       1.755  22.150  34.256  1.00  0.00           C  
ATOM    562  C   HIS A  41       1.476  20.924  33.393  1.00  0.00           C  
ATOM    563  O   HIS A  41       0.501  20.204  33.613  1.00  0.00           O  
ATOM    564  CB  HIS A  41       0.467  22.613  34.936  1.00  0.00           C  
ATOM    565  CG  HIS A  41       0.173  21.894  36.216  1.00  0.00           C  
ATOM    566  ND1 HIS A  41       0.474  22.413  37.457  1.00  0.00           N  
ATOM    567  CD2 HIS A  41      -0.400  20.689  36.443  1.00  0.00           C  
ATOM    568  CE1 HIS A  41       0.100  21.557  38.392  1.00  0.00           C  
ATOM    569  NE2 HIS A  41      -0.433  20.503  37.803  1.00  0.00           N  
ATOM    570  H   HIS A  41       3.223  23.555  33.661  1.00  0.00           H  
ATOM    571  HA  HIS A  41       2.477  21.885  35.013  1.00  0.00           H  
ATOM    572  HB2 HIS A  41       0.544  23.667  35.159  1.00  0.00           H  
ATOM    573  HB3 HIS A  41      -0.365  22.452  34.265  1.00  0.00           H  
ATOM    574  HD1 HIS A  41       0.899  23.279  37.628  1.00  0.00           H  
ATOM    575  HD2 HIS A  41      -0.763  19.999  35.693  1.00  0.00           H  
ATOM    576  HE1 HIS A  41       0.212  21.697  39.458  1.00  0.00           H  
ATOM    577  HE2 HIS A  41      -0.714  19.683  38.260  1.00  0.00           H  
ATOM    578  N   THR A  42       2.338  20.691  32.407  1.00  0.00           N  
ATOM    579  CA  THR A  42       2.183  19.553  31.509  1.00  0.00           C  
ATOM    580  C   THR A  42       3.535  19.064  31.003  1.00  0.00           C  
ATOM    581  O   THR A  42       4.504  19.822  30.961  1.00  0.00           O  
ATOM    582  CB  THR A  42       1.292  19.906  30.303  1.00  0.00           C  
ATOM    583  OG1 THR A  42       1.774  21.096  29.670  1.00  0.00           O  
ATOM    584  CG2 THR A  42      -0.152  20.104  30.737  1.00  0.00           C  
ATOM    585  H   THR A  42       3.095  21.300  32.281  1.00  0.00           H  
ATOM    586  HA  THR A  42       1.707  18.755  32.061  1.00  0.00           H  
ATOM    587  HB  THR A  42       1.331  19.090  29.596  1.00  0.00           H  
ATOM    588  HG1 THR A  42       2.507  21.454  30.177  1.00  0.00           H  
ATOM    589 HG21 THR A  42      -0.807  19.944  29.893  1.00  0.00           H  
ATOM    590 HG22 THR A  42      -0.281  21.111  31.106  1.00  0.00           H  
ATOM    591 HG23 THR A  42      -0.393  19.401  31.519  1.00  0.00           H  
ATOM    592  N   GLY A  43       3.594  17.792  30.619  1.00  0.00           N  
ATOM    593  CA  GLY A  43       4.832  17.225  30.119  1.00  0.00           C  
ATOM    594  C   GLY A  43       4.883  17.187  28.605  1.00  0.00           C  
ATOM    595  O   GLY A  43       5.411  16.242  28.018  1.00  0.00           O  
ATOM    596  H   GLY A  43       2.789  17.235  30.674  1.00  0.00           H  
ATOM    597  HA2 GLY A  43       5.659  17.818  30.481  1.00  0.00           H  
ATOM    598  HA3 GLY A  43       4.931  16.218  30.496  1.00  0.00           H  
ATOM    599  N   GLU A  44       4.332  18.216  27.969  1.00  0.00           N  
ATOM    600  CA  GLU A  44       4.314  18.293  26.513  1.00  0.00           C  
ATOM    601  C   GLU A  44       5.629  18.858  25.983  1.00  0.00           C  
ATOM    602  O   GLU A  44       6.525  19.203  26.754  1.00  0.00           O  
ATOM    603  CB  GLU A  44       3.147  19.162  26.040  1.00  0.00           C  
ATOM    604  CG  GLU A  44       1.787  18.636  26.463  1.00  0.00           C  
ATOM    605  CD  GLU A  44       1.386  17.380  25.713  1.00  0.00           C  
ATOM    606  OE1 GLU A  44       1.387  17.409  24.464  1.00  0.00           O  
ATOM    607  OE2 GLU A  44       1.074  16.368  26.374  1.00  0.00           O  
ATOM    608  H   GLU A  44       3.926  18.939  28.492  1.00  0.00           H  
ATOM    609  HA  GLU A  44       4.185  17.293  26.128  1.00  0.00           H  
ATOM    610  HB2 GLU A  44       3.267  20.157  26.444  1.00  0.00           H  
ATOM    611  HB3 GLU A  44       3.169  19.216  24.962  1.00  0.00           H  
ATOM    612  HG2 GLU A  44       1.814  18.411  27.519  1.00  0.00           H  
ATOM    613  HG3 GLU A  44       1.045  19.400  26.279  1.00  0.00           H  
ATOM    614  N   ALA A  45       5.738  18.947  24.662  1.00  0.00           N  
ATOM    615  CA  ALA A  45       6.943  19.471  24.028  1.00  0.00           C  
ATOM    616  C   ALA A  45       6.660  20.789  23.314  1.00  0.00           C  
ATOM    617  O   ALA A  45       5.553  21.322  23.392  1.00  0.00           O  
ATOM    618  CB  ALA A  45       7.511  18.452  23.051  1.00  0.00           C  
ATOM    619  H   ALA A  45       4.991  18.657  24.099  1.00  0.00           H  
ATOM    620  HA  ALA A  45       7.679  19.642  24.800  1.00  0.00           H  
ATOM    621  HB1 ALA A  45       6.701  17.974  22.519  1.00  0.00           H  
ATOM    622  HB2 ALA A  45       8.160  18.951  22.348  1.00  0.00           H  
ATOM    623  HB3 ALA A  45       8.072  17.707  23.595  1.00  0.00           H  
ATOM    624  N   SER A  46       7.667  21.309  22.621  1.00  0.00           N  
ATOM    625  CA  SER A  46       7.526  22.567  21.897  1.00  0.00           C  
ATOM    626  C   SER A  46       8.412  22.580  20.655  1.00  0.00           C  
ATOM    627  O   SER A  46       9.627  22.414  20.742  1.00  0.00           O  
ATOM    628  CB  SER A  46       7.886  23.745  22.805  1.00  0.00           C  
ATOM    629  OG  SER A  46       9.281  23.797  23.044  1.00  0.00           O  
ATOM    630  H   SER A  46       8.525  20.836  22.597  1.00  0.00           H  
ATOM    631  HA  SER A  46       6.495  22.660  21.591  1.00  0.00           H  
ATOM    632  HB2 SER A  46       7.579  24.666  22.333  1.00  0.00           H  
ATOM    633  HB3 SER A  46       7.373  23.636  23.750  1.00  0.00           H  
ATOM    634  HG  SER A  46       9.443  24.168  23.915  1.00  0.00           H  
ATOM    635  N   GLY A  47       7.791  22.780  19.495  1.00  0.00           N  
ATOM    636  CA  GLY A  47       8.535  22.811  18.250  1.00  0.00           C  
ATOM    637  C   GLY A  47       7.797  22.129  17.115  1.00  0.00           C  
ATOM    638  O   GLY A  47       6.678  21.648  17.294  1.00  0.00           O  
ATOM    639  H   GLY A  47       6.819  22.906  19.486  1.00  0.00           H  
ATOM    640  HA2 GLY A  47       8.720  23.840  17.979  1.00  0.00           H  
ATOM    641  HA3 GLY A  47       9.483  22.313  18.399  1.00  0.00           H  
ATOM    642  N   ILE A  48       8.424  22.088  15.945  1.00  0.00           N  
ATOM    643  CA  ILE A  48       7.819  21.461  14.776  1.00  0.00           C  
ATOM    644  C   ILE A  48       8.181  19.981  14.698  1.00  0.00           C  
ATOM    645  O   ILE A  48       9.357  19.620  14.668  1.00  0.00           O  
ATOM    646  CB  ILE A  48       8.258  22.155  13.473  1.00  0.00           C  
ATOM    647  CG1 ILE A  48       7.847  23.629  13.491  1.00  0.00           C  
ATOM    648  CG2 ILE A  48       7.658  21.447  12.268  1.00  0.00           C  
ATOM    649  CD1 ILE A  48       6.378  23.843  13.780  1.00  0.00           C  
ATOM    650  H   ILE A  48       9.315  22.488  15.864  1.00  0.00           H  
ATOM    651  HA  ILE A  48       6.747  21.554  14.867  1.00  0.00           H  
ATOM    652  HB  ILE A  48       9.333  22.090  13.402  1.00  0.00           H  
ATOM    653 HG12 ILE A  48       8.412  24.144  14.251  1.00  0.00           H  
ATOM    654 HG13 ILE A  48       8.063  24.066  12.527  1.00  0.00           H  
ATOM    655 HG21 ILE A  48       8.402  21.374  11.487  1.00  0.00           H  
ATOM    656 HG22 ILE A  48       7.340  20.456  12.554  1.00  0.00           H  
ATOM    657 HG23 ILE A  48       6.810  22.007  11.906  1.00  0.00           H  
ATOM    658 HD11 ILE A  48       6.189  23.673  14.830  1.00  0.00           H  
ATOM    659 HD12 ILE A  48       6.103  24.854  13.522  1.00  0.00           H  
ATOM    660 HD13 ILE A  48       5.791  23.150  13.194  1.00  0.00           H  
ATOM    661  N   TYR A  49       7.161  19.130  14.661  1.00  0.00           N  
ATOM    662  CA  TYR A  49       7.371  17.689  14.587  1.00  0.00           C  
ATOM    663  C   TYR A  49       6.587  17.084  13.425  1.00  0.00           C  
ATOM    664  O   TYR A  49       5.537  17.594  13.038  1.00  0.00           O  
ATOM    665  CB  TYR A  49       6.954  17.023  15.899  1.00  0.00           C  
ATOM    666  CG  TYR A  49       7.777  17.463  17.089  1.00  0.00           C  
ATOM    667  CD1 TYR A  49       7.501  18.657  17.745  1.00  0.00           C  
ATOM    668  CD2 TYR A  49       8.829  16.687  17.558  1.00  0.00           C  
ATOM    669  CE1 TYR A  49       8.250  19.064  18.832  1.00  0.00           C  
ATOM    670  CE2 TYR A  49       9.582  17.084  18.646  1.00  0.00           C  
ATOM    671  CZ  TYR A  49       9.288  18.274  19.279  1.00  0.00           C  
ATOM    672  OH  TYR A  49      10.037  18.675  20.362  1.00  0.00           O  
ATOM    673  H   TYR A  49       6.246  19.479  14.688  1.00  0.00           H  
ATOM    674  HA  TYR A  49       8.425  17.516  14.425  1.00  0.00           H  
ATOM    675  HB2 TYR A  49       5.922  17.261  16.104  1.00  0.00           H  
ATOM    676  HB3 TYR A  49       7.059  15.953  15.801  1.00  0.00           H  
ATOM    677  HD1 TYR A  49       6.687  19.275  17.392  1.00  0.00           H  
ATOM    678  HD2 TYR A  49       9.055  15.756  17.059  1.00  0.00           H  
ATOM    679  HE1 TYR A  49       8.021  19.996  19.328  1.00  0.00           H  
ATOM    680  HE2 TYR A  49      10.395  16.466  18.995  1.00  0.00           H  
ATOM    681  HH  TYR A  49       9.607  19.419  20.790  1.00  0.00           H  
ATOM    682  N   VAL A  50       7.108  15.993  12.874  1.00  0.00           N  
ATOM    683  CA  VAL A  50       6.459  15.315  11.758  1.00  0.00           C  
ATOM    684  C   VAL A  50       5.201  14.584  12.216  1.00  0.00           C  
ATOM    685  O   VAL A  50       5.268  13.454  12.698  1.00  0.00           O  
ATOM    686  CB  VAL A  50       7.409  14.308  11.083  1.00  0.00           C  
ATOM    687  CG1 VAL A  50       6.685  13.545   9.984  1.00  0.00           C  
ATOM    688  CG2 VAL A  50       8.635  15.020  10.532  1.00  0.00           C  
ATOM    689  H   VAL A  50       7.949  15.634  13.227  1.00  0.00           H  
ATOM    690  HA  VAL A  50       6.184  16.064  11.028  1.00  0.00           H  
ATOM    691  HB  VAL A  50       7.735  13.598  11.828  1.00  0.00           H  
ATOM    692 HG11 VAL A  50       7.017  13.902   9.020  1.00  0.00           H  
ATOM    693 HG12 VAL A  50       6.903  12.491  10.074  1.00  0.00           H  
ATOM    694 HG13 VAL A  50       5.620  13.703  10.079  1.00  0.00           H  
ATOM    695 HG21 VAL A  50       9.121  15.566  11.326  1.00  0.00           H  
ATOM    696 HG22 VAL A  50       9.321  14.291  10.124  1.00  0.00           H  
ATOM    697 HG23 VAL A  50       8.334  15.704   9.754  1.00  0.00           H  
ATOM    698  N   LYS A  51       4.055  15.238  12.061  1.00  0.00           N  
ATOM    699  CA  LYS A  51       2.780  14.650  12.455  1.00  0.00           C  
ATOM    700  C   LYS A  51       2.534  13.339  11.718  1.00  0.00           C  
ATOM    701  O   LYS A  51       2.131  12.343  12.321  1.00  0.00           O  
ATOM    702  CB  LYS A  51       1.637  15.628  12.176  1.00  0.00           C  
ATOM    703  CG  LYS A  51       0.272  15.099  12.579  1.00  0.00           C  
ATOM    704  CD  LYS A  51       0.093  15.109  14.088  1.00  0.00           C  
ATOM    705  CE  LYS A  51      -1.377  15.087  14.476  1.00  0.00           C  
ATOM    706  NZ  LYS A  51      -1.597  14.405  15.782  1.00  0.00           N  
ATOM    707  H   LYS A  51       4.067  16.137  11.670  1.00  0.00           H  
ATOM    708  HA  LYS A  51       2.821  14.451  13.516  1.00  0.00           H  
ATOM    709  HB2 LYS A  51       1.819  16.543  12.719  1.00  0.00           H  
ATOM    710  HB3 LYS A  51       1.616  15.846  11.117  1.00  0.00           H  
ATOM    711  HG2 LYS A  51      -0.492  15.719  12.134  1.00  0.00           H  
ATOM    712  HG3 LYS A  51       0.169  14.084  12.221  1.00  0.00           H  
ATOM    713  HD2 LYS A  51       0.576  14.238  14.506  1.00  0.00           H  
ATOM    714  HD3 LYS A  51       0.550  16.003  14.490  1.00  0.00           H  
ATOM    715  HE2 LYS A  51      -1.733  16.104  14.547  1.00  0.00           H  
ATOM    716  HE3 LYS A  51      -1.931  14.565  13.709  1.00  0.00           H  
ATOM    717  HZ1 LYS A  51      -1.047  14.877  16.528  1.00  0.00           H  
ATOM    718  HZ2 LYS A  51      -1.296  13.411  15.721  1.00  0.00           H  
ATOM    719  HZ3 LYS A  51      -2.605  14.437  16.036  1.00  0.00           H  
ATOM    720  N   SER A  52       2.779  13.344  10.412  1.00  0.00           N  
ATOM    721  CA  SER A  52       2.582  12.155   9.592  1.00  0.00           C  
ATOM    722  C   SER A  52       3.384  12.247   8.298  1.00  0.00           C  
ATOM    723  O   SER A  52       4.070  13.239   8.049  1.00  0.00           O  
ATOM    724  CB  SER A  52       1.097  11.970   9.272  1.00  0.00           C  
ATOM    725  OG  SER A  52       0.418  11.343  10.346  1.00  0.00           O  
ATOM    726  H   SER A  52       3.099  14.169   9.989  1.00  0.00           H  
ATOM    727  HA  SER A  52       2.928  11.302  10.156  1.00  0.00           H  
ATOM    728  HB2 SER A  52       0.647  12.935   9.093  1.00  0.00           H  
ATOM    729  HB3 SER A  52       0.995  11.357   8.390  1.00  0.00           H  
ATOM    730  HG  SER A  52       0.117  12.008  10.968  1.00  0.00           H  
ATOM    731  N   VAL A  53       3.294  11.205   7.477  1.00  0.00           N  
ATOM    732  CA  VAL A  53       4.010  11.168   6.208  1.00  0.00           C  
ATOM    733  C   VAL A  53       3.124  10.625   5.092  1.00  0.00           C  
ATOM    734  O   VAL A  53       2.793   9.439   5.070  1.00  0.00           O  
ATOM    735  CB  VAL A  53       5.281  10.303   6.305  1.00  0.00           C  
ATOM    736  CG1 VAL A  53       6.026  10.297   4.980  1.00  0.00           C  
ATOM    737  CG2 VAL A  53       6.178  10.799   7.429  1.00  0.00           C  
ATOM    738  H   VAL A  53       2.732  10.444   7.730  1.00  0.00           H  
ATOM    739  HA  VAL A  53       4.306  12.177   5.961  1.00  0.00           H  
ATOM    740  HB  VAL A  53       4.985   9.289   6.531  1.00  0.00           H  
ATOM    741 HG11 VAL A  53       6.982   9.809   5.106  1.00  0.00           H  
ATOM    742 HG12 VAL A  53       5.444   9.766   4.241  1.00  0.00           H  
ATOM    743 HG13 VAL A  53       6.184  11.314   4.652  1.00  0.00           H  
ATOM    744 HG21 VAL A  53       5.620  11.469   8.065  1.00  0.00           H  
ATOM    745 HG22 VAL A  53       6.527   9.958   8.010  1.00  0.00           H  
ATOM    746 HG23 VAL A  53       7.024  11.322   7.010  1.00  0.00           H  
ATOM    747  N   ILE A  54       2.743  11.501   4.168  1.00  0.00           N  
ATOM    748  CA  ILE A  54       1.896  11.110   3.048  1.00  0.00           C  
ATOM    749  C   ILE A  54       2.567  10.033   2.202  1.00  0.00           C  
ATOM    750  O   ILE A  54       3.712  10.170   1.771  1.00  0.00           O  
ATOM    751  CB  ILE A  54       1.557  12.314   2.151  1.00  0.00           C  
ATOM    752  CG1 ILE A  54       0.558  13.236   2.853  1.00  0.00           C  
ATOM    753  CG2 ILE A  54       1.001  11.841   0.816  1.00  0.00           C  
ATOM    754  CD1 ILE A  54       1.204  14.201   3.822  1.00  0.00           C  
ATOM    755  H   ILE A  54       3.040  12.432   4.241  1.00  0.00           H  
ATOM    756  HA  ILE A  54       0.974  10.714   3.450  1.00  0.00           H  
ATOM    757  HB  ILE A  54       2.468  12.861   1.960  1.00  0.00           H  
ATOM    758 HG12 ILE A  54       0.030  13.815   2.112  1.00  0.00           H  
ATOM    759 HG13 ILE A  54      -0.149  12.634   3.405  1.00  0.00           H  
ATOM    760 HG21 ILE A  54       1.735  11.222   0.320  1.00  0.00           H  
ATOM    761 HG22 ILE A  54       0.103  11.266   0.984  1.00  0.00           H  
ATOM    762 HG23 ILE A  54       0.773  12.695   0.197  1.00  0.00           H  
ATOM    763 HD11 ILE A  54       1.976  14.760   3.313  1.00  0.00           H  
ATOM    764 HD12 ILE A  54       0.459  14.880   4.206  1.00  0.00           H  
ATOM    765 HD13 ILE A  54       1.643  13.648   4.641  1.00  0.00           H  
ATOM    766  N   PRO A  55       1.837   8.934   1.957  1.00  0.00           N  
ATOM    767  CA  PRO A  55       2.341   7.812   1.159  1.00  0.00           C  
ATOM    768  C   PRO A  55       2.481   8.168  -0.318  1.00  0.00           C  
ATOM    769  O   PRO A  55       1.724   8.982  -0.844  1.00  0.00           O  
ATOM    770  CB  PRO A  55       1.271   6.733   1.350  1.00  0.00           C  
ATOM    771  CG  PRO A  55       0.027   7.486   1.672  1.00  0.00           C  
ATOM    772  CD  PRO A  55       0.466   8.702   2.439  1.00  0.00           C  
ATOM    773  HA  PRO A  55       3.288   7.452   1.532  1.00  0.00           H  
ATOM    774  HB2 PRO A  55       1.165   6.164   0.437  1.00  0.00           H  
ATOM    775  HB3 PRO A  55       1.556   6.078   2.158  1.00  0.00           H  
ATOM    776  HG2 PRO A  55      -0.472   7.779   0.760  1.00  0.00           H  
ATOM    777  HG3 PRO A  55      -0.624   6.875   2.279  1.00  0.00           H  
ATOM    778  HD2 PRO A  55      -0.171   9.544   2.210  1.00  0.00           H  
ATOM    779  HD3 PRO A  55       0.460   8.501   3.501  1.00  0.00           H  
ATOM    780  N   GLY A  56       3.454   7.550  -0.981  1.00  0.00           N  
ATOM    781  CA  GLY A  56       3.674   7.815  -2.391  1.00  0.00           C  
ATOM    782  C   GLY A  56       4.249   9.195  -2.638  1.00  0.00           C  
ATOM    783  O   GLY A  56       4.018   9.794  -3.689  1.00  0.00           O  
ATOM    784  H   GLY A  56       4.025   6.910  -0.509  1.00  0.00           H  
ATOM    785  HA2 GLY A  56       4.357   7.076  -2.783  1.00  0.00           H  
ATOM    786  HA3 GLY A  56       2.732   7.732  -2.913  1.00  0.00           H  
ATOM    787  N   SER A  57       5.002   9.704  -1.667  1.00  0.00           N  
ATOM    788  CA  SER A  57       5.608  11.025  -1.782  1.00  0.00           C  
ATOM    789  C   SER A  57       7.124  10.942  -1.637  1.00  0.00           C  
ATOM    790  O   SER A  57       7.674   9.879  -1.351  1.00  0.00           O  
ATOM    791  CB  SER A  57       5.034  11.967  -0.722  1.00  0.00           C  
ATOM    792  OG  SER A  57       5.743  11.852   0.500  1.00  0.00           O  
ATOM    793  H   SER A  57       5.149   9.179  -0.853  1.00  0.00           H  
ATOM    794  HA  SER A  57       5.372  11.414  -2.761  1.00  0.00           H  
ATOM    795  HB2 SER A  57       5.106  12.986  -1.072  1.00  0.00           H  
ATOM    796  HB3 SER A  57       3.997  11.718  -0.547  1.00  0.00           H  
ATOM    797  HG  SER A  57       5.174  11.462   1.166  1.00  0.00           H  
ATOM    798  N   ALA A  58       7.794  12.072  -1.837  1.00  0.00           N  
ATOM    799  CA  ALA A  58       9.246  12.129  -1.728  1.00  0.00           C  
ATOM    800  C   ALA A  58       9.719  11.559  -0.395  1.00  0.00           C  
ATOM    801  O   ALA A  58      10.536  10.638  -0.357  1.00  0.00           O  
ATOM    802  CB  ALA A  58       9.734  13.560  -1.894  1.00  0.00           C  
ATOM    803  H   ALA A  58       7.300  12.887  -2.063  1.00  0.00           H  
ATOM    804  HA  ALA A  58       9.666  11.537  -2.529  1.00  0.00           H  
ATOM    805  HB1 ALA A  58       9.422  14.146  -1.041  1.00  0.00           H  
ATOM    806  HB2 ALA A  58      10.811  13.568  -1.962  1.00  0.00           H  
ATOM    807  HB3 ALA A  58       9.311  13.981  -2.793  1.00  0.00           H  
ATOM    808  N   ALA A  59       9.201  12.111   0.697  1.00  0.00           N  
ATOM    809  CA  ALA A  59       9.568  11.655   2.032  1.00  0.00           C  
ATOM    810  C   ALA A  59       9.402  10.146   2.163  1.00  0.00           C  
ATOM    811  O   ALA A  59      10.345   9.434   2.512  1.00  0.00           O  
ATOM    812  CB  ALA A  59       8.735  12.374   3.083  1.00  0.00           C  
ATOM    813  H   ALA A  59       8.554  12.841   0.603  1.00  0.00           H  
ATOM    814  HA  ALA A  59      10.606  11.909   2.197  1.00  0.00           H  
ATOM    815  HB1 ALA A  59       9.377  12.703   3.887  1.00  0.00           H  
ATOM    816  HB2 ALA A  59       8.251  13.229   2.635  1.00  0.00           H  
ATOM    817  HB3 ALA A  59       7.987  11.699   3.471  1.00  0.00           H  
ATOM    818  N   TYR A  60       8.197   9.663   1.883  1.00  0.00           N  
ATOM    819  CA  TYR A  60       7.905   8.237   1.972  1.00  0.00           C  
ATOM    820  C   TYR A  60       8.894   7.425   1.140  1.00  0.00           C  
ATOM    821  O   TYR A  60       9.498   6.470   1.629  1.00  0.00           O  
ATOM    822  CB  TYR A  60       6.477   7.956   1.504  1.00  0.00           C  
ATOM    823  CG  TYR A  60       6.079   6.501   1.613  1.00  0.00           C  
ATOM    824  CD1 TYR A  60       5.625   5.973   2.815  1.00  0.00           C  
ATOM    825  CD2 TYR A  60       6.154   5.656   0.513  1.00  0.00           C  
ATOM    826  CE1 TYR A  60       5.261   4.644   2.920  1.00  0.00           C  
ATOM    827  CE2 TYR A  60       5.791   4.327   0.607  1.00  0.00           C  
ATOM    828  CZ  TYR A  60       5.345   3.825   1.812  1.00  0.00           C  
ATOM    829  OH  TYR A  60       4.982   2.502   1.912  1.00  0.00           O  
ATOM    830  H   TYR A  60       7.485  10.279   1.610  1.00  0.00           H  
ATOM    831  HA  TYR A  60       7.999   7.943   3.007  1.00  0.00           H  
ATOM    832  HB2 TYR A  60       5.789   8.533   2.103  1.00  0.00           H  
ATOM    833  HB3 TYR A  60       6.380   8.250   0.469  1.00  0.00           H  
ATOM    834  HD1 TYR A  60       5.559   6.618   3.680  1.00  0.00           H  
ATOM    835  HD2 TYR A  60       6.504   6.051  -0.430  1.00  0.00           H  
ATOM    836  HE1 TYR A  60       4.911   4.252   3.862  1.00  0.00           H  
ATOM    837  HE2 TYR A  60       5.857   3.684  -0.258  1.00  0.00           H  
ATOM    838  HH  TYR A  60       5.768   1.951   1.883  1.00  0.00           H  
ATOM    839  N   HIS A  61       9.053   7.813  -0.122  1.00  0.00           N  
ATOM    840  CA  HIS A  61       9.969   7.123  -1.023  1.00  0.00           C  
ATOM    841  C   HIS A  61      11.376   7.072  -0.434  1.00  0.00           C  
ATOM    842  O   HIS A  61      11.965   6.001  -0.302  1.00  0.00           O  
ATOM    843  CB  HIS A  61       9.999   7.820  -2.384  1.00  0.00           C  
ATOM    844  CG  HIS A  61       8.689   7.773  -3.109  1.00  0.00           C  
ATOM    845  ND1 HIS A  61       7.970   6.611  -3.290  1.00  0.00           N  
ATOM    846  CD2 HIS A  61       7.968   8.755  -3.698  1.00  0.00           C  
ATOM    847  CE1 HIS A  61       6.864   6.879  -3.961  1.00  0.00           C  
ATOM    848  NE2 HIS A  61       6.838   8.175  -4.220  1.00  0.00           N  
ATOM    849  H   HIS A  61       8.543   8.581  -0.453  1.00  0.00           H  
ATOM    850  HA  HIS A  61       9.611   6.114  -1.152  1.00  0.00           H  
ATOM    851  HB2 HIS A  61      10.264   8.858  -2.245  1.00  0.00           H  
ATOM    852  HB3 HIS A  61      10.742   7.344  -3.009  1.00  0.00           H  
ATOM    853  HD1 HIS A  61       8.232   5.721  -2.977  1.00  0.00           H  
ATOM    854  HD2 HIS A  61       8.231   9.803  -3.748  1.00  0.00           H  
ATOM    855  HE1 HIS A  61       6.109   6.163  -4.249  1.00  0.00           H  
ATOM    856  HE2 HIS A  61       6.172   8.625  -4.779  1.00  0.00           H  
ATOM    857  N   ASN A  62      11.908   8.239  -0.083  1.00  0.00           N  
ATOM    858  CA  ASN A  62      13.246   8.327   0.491  1.00  0.00           C  
ATOM    859  C   ASN A  62      13.408   7.344   1.646  1.00  0.00           C  
ATOM    860  O   ASN A  62      14.335   6.535   1.662  1.00  0.00           O  
ATOM    861  CB  ASN A  62      13.523   9.751   0.974  1.00  0.00           C  
ATOM    862  CG  ASN A  62      14.993  10.116   0.889  1.00  0.00           C  
ATOM    863  OD1 ASN A  62      15.666   9.801  -0.093  1.00  0.00           O  
ATOM    864  ND2 ASN A  62      15.498  10.782   1.921  1.00  0.00           N  
ATOM    865  H   ASN A  62      11.389   9.060  -0.213  1.00  0.00           H  
ATOM    866  HA  ASN A  62      13.955   8.075  -0.283  1.00  0.00           H  
ATOM    867  HB2 ASN A  62      12.964  10.448   0.366  1.00  0.00           H  
ATOM    868  HB3 ASN A  62      13.207   9.844   2.003  1.00  0.00           H  
ATOM    869 HD21 ASN A  62      14.903  10.998   2.669  1.00  0.00           H  
ATOM    870 HD22 ASN A  62      16.446  11.030   1.892  1.00  0.00           H  
ATOM    871  N   GLY A  63      12.499   7.421   2.613  1.00  0.00           N  
ATOM    872  CA  GLY A  63      12.558   6.532   3.759  1.00  0.00           C  
ATOM    873  C   GLY A  63      13.522   7.020   4.821  1.00  0.00           C  
ATOM    874  O   GLY A  63      14.111   6.220   5.551  1.00  0.00           O  
ATOM    875  H   GLY A  63      11.781   8.085   2.547  1.00  0.00           H  
ATOM    876  HA2 GLY A  63      11.571   6.454   4.191  1.00  0.00           H  
ATOM    877  HA3 GLY A  63      12.872   5.553   3.426  1.00  0.00           H  
ATOM    878  N   HIS A  64      13.689   8.335   4.908  1.00  0.00           N  
ATOM    879  CA  HIS A  64      14.591   8.929   5.889  1.00  0.00           C  
ATOM    880  C   HIS A  64      13.818   9.778   6.894  1.00  0.00           C  
ATOM    881  O   HIS A  64      14.110   9.759   8.090  1.00  0.00           O  
ATOM    882  CB  HIS A  64      15.649   9.783   5.188  1.00  0.00           C  
ATOM    883  CG  HIS A  64      16.695   8.979   4.481  1.00  0.00           C  
ATOM    884  ND1 HIS A  64      17.997   9.405   4.329  1.00  0.00           N  
ATOM    885  CD2 HIS A  64      16.625   7.766   3.882  1.00  0.00           C  
ATOM    886  CE1 HIS A  64      18.683   8.490   3.666  1.00  0.00           C  
ATOM    887  NE2 HIS A  64      17.873   7.485   3.383  1.00  0.00           N  
ATOM    888  H   HIS A  64      13.192   8.921   4.300  1.00  0.00           H  
ATOM    889  HA  HIS A  64      15.082   8.125   6.417  1.00  0.00           H  
ATOM    890  HB2 HIS A  64      15.166  10.415   4.458  1.00  0.00           H  
ATOM    891  HB3 HIS A  64      16.145  10.402   5.922  1.00  0.00           H  
ATOM    892  HD1 HIS A  64      18.364  10.252   4.656  1.00  0.00           H  
ATOM    893  HD2 HIS A  64      15.750   7.136   3.809  1.00  0.00           H  
ATOM    894  HE1 HIS A  64      19.728   8.552   3.400  1.00  0.00           H  
ATOM    895  HE2 HIS A  64      18.104   6.716   2.825  1.00  0.00           H  
ATOM    896  N   ILE A  65      12.834  10.523   6.400  1.00  0.00           N  
ATOM    897  CA  ILE A  65      12.021  11.377   7.255  1.00  0.00           C  
ATOM    898  C   ILE A  65      10.710  10.695   7.627  1.00  0.00           C  
ATOM    899  O   ILE A  65       9.929  10.311   6.756  1.00  0.00           O  
ATOM    900  CB  ILE A  65      11.711  12.723   6.574  1.00  0.00           C  
ATOM    901  CG1 ILE A  65      13.009  13.460   6.237  1.00  0.00           C  
ATOM    902  CG2 ILE A  65      10.827  13.578   7.469  1.00  0.00           C  
ATOM    903  CD1 ILE A  65      12.901  14.346   5.016  1.00  0.00           C  
ATOM    904  H   ILE A  65      12.651  10.495   5.438  1.00  0.00           H  
ATOM    905  HA  ILE A  65      12.581  11.574   8.159  1.00  0.00           H  
ATOM    906  HB  ILE A  65      11.172  12.523   5.660  1.00  0.00           H  
ATOM    907 HG12 ILE A  65      13.290  14.082   7.073  1.00  0.00           H  
ATOM    908 HG13 ILE A  65      13.789  12.735   6.055  1.00  0.00           H  
ATOM    909 HG21 ILE A  65      10.300  12.944   8.167  1.00  0.00           H  
ATOM    910 HG22 ILE A  65      11.439  14.281   8.013  1.00  0.00           H  
ATOM    911 HG23 ILE A  65      10.113  14.116   6.863  1.00  0.00           H  
ATOM    912 HD11 ILE A  65      12.012  14.955   5.089  1.00  0.00           H  
ATOM    913 HD12 ILE A  65      13.770  14.983   4.955  1.00  0.00           H  
ATOM    914 HD13 ILE A  65      12.843  13.731   4.129  1.00  0.00           H  
ATOM    915  N   GLN A  66      10.473  10.547   8.927  1.00  0.00           N  
ATOM    916  CA  GLN A  66       9.255   9.912   9.414  1.00  0.00           C  
ATOM    917  C   GLN A  66       8.767  10.579  10.696  1.00  0.00           C  
ATOM    918  O   GLN A  66       9.479  11.383  11.299  1.00  0.00           O  
ATOM    919  CB  GLN A  66       9.495   8.421   9.660  1.00  0.00           C  
ATOM    920  CG  GLN A  66      10.183   7.718   8.502  1.00  0.00           C  
ATOM    921  CD  GLN A  66      11.694   7.739   8.620  1.00  0.00           C  
ATOM    922  OE1 GLN A  66      12.247   8.329   9.549  1.00  0.00           O  
ATOM    923  NE2 GLN A  66      12.372   7.094   7.677  1.00  0.00           N  
ATOM    924  H   GLN A  66      11.133  10.874   9.573  1.00  0.00           H  
ATOM    925  HA  GLN A  66       8.496  10.024   8.654  1.00  0.00           H  
ATOM    926  HB2 GLN A  66      10.111   8.309  10.539  1.00  0.00           H  
ATOM    927  HB3 GLN A  66       8.544   7.940   9.831  1.00  0.00           H  
ATOM    928  HG2 GLN A  66       9.855   6.689   8.476  1.00  0.00           H  
ATOM    929  HG3 GLN A  66       9.901   8.207   7.581  1.00  0.00           H  
ATOM    930 HE21 GLN A  66      11.865   6.647   6.967  1.00  0.00           H  
ATOM    931 HE22 GLN A  66      13.350   7.093   7.730  1.00  0.00           H  
ATOM    932  N   VAL A  67       7.550  10.240  11.109  1.00  0.00           N  
ATOM    933  CA  VAL A  67       6.968  10.805  12.320  1.00  0.00           C  
ATOM    934  C   VAL A  67       7.932  10.694  13.497  1.00  0.00           C  
ATOM    935  O   VAL A  67       8.965  10.032  13.405  1.00  0.00           O  
ATOM    936  CB  VAL A  67       5.646  10.106  12.686  1.00  0.00           C  
ATOM    937  CG1 VAL A  67       4.600  10.344  11.608  1.00  0.00           C  
ATOM    938  CG2 VAL A  67       5.872   8.617  12.902  1.00  0.00           C  
ATOM    939  H   VAL A  67       7.032   9.593  10.586  1.00  0.00           H  
ATOM    940  HA  VAL A  67       6.760  11.849  12.135  1.00  0.00           H  
ATOM    941  HB  VAL A  67       5.282  10.531  13.610  1.00  0.00           H  
ATOM    942 HG11 VAL A  67       3.711   9.774  11.837  1.00  0.00           H  
ATOM    943 HG12 VAL A  67       4.354  11.395  11.570  1.00  0.00           H  
ATOM    944 HG13 VAL A  67       4.992  10.031  10.651  1.00  0.00           H  
ATOM    945 HG21 VAL A  67       6.470   8.469  13.790  1.00  0.00           H  
ATOM    946 HG22 VAL A  67       4.920   8.121  13.022  1.00  0.00           H  
ATOM    947 HG23 VAL A  67       6.387   8.204  12.048  1.00  0.00           H  
ATOM    948  N   ASN A  68       7.586  11.345  14.601  1.00  0.00           N  
ATOM    949  CA  ASN A  68       8.421  11.320  15.798  1.00  0.00           C  
ATOM    950  C   ASN A  68       9.786  11.941  15.521  1.00  0.00           C  
ATOM    951  O   ASN A  68      10.814  11.432  15.968  1.00  0.00           O  
ATOM    952  CB  ASN A  68       8.593   9.883  16.293  1.00  0.00           C  
ATOM    953  CG  ASN A  68       7.299   9.094  16.240  1.00  0.00           C  
ATOM    954  OD1 ASN A  68       6.210   9.657  16.354  1.00  0.00           O  
ATOM    955  ND2 ASN A  68       7.413   7.782  16.065  1.00  0.00           N  
ATOM    956  H   ASN A  68       6.750  11.856  14.613  1.00  0.00           H  
ATOM    957  HA  ASN A  68       7.923  11.898  16.561  1.00  0.00           H  
ATOM    958  HB2 ASN A  68       9.325   9.381  15.677  1.00  0.00           H  
ATOM    959  HB3 ASN A  68       8.941   9.900  17.315  1.00  0.00           H  
ATOM    960 HD21 ASN A  68       8.314   7.402  15.983  1.00  0.00           H  
ATOM    961 HD22 ASN A  68       6.593   7.248  16.026  1.00  0.00           H  
ATOM    962  N   ASP A  69       9.789  13.045  14.782  1.00  0.00           N  
ATOM    963  CA  ASP A  69      11.027  13.738  14.447  1.00  0.00           C  
ATOM    964  C   ASP A  69      10.884  15.243  14.658  1.00  0.00           C  
ATOM    965  O   ASP A  69       9.801  15.803  14.486  1.00  0.00           O  
ATOM    966  CB  ASP A  69      11.422  13.450  12.998  1.00  0.00           C  
ATOM    967  CG  ASP A  69      12.255  12.191  12.864  1.00  0.00           C  
ATOM    968  OD1 ASP A  69      13.401  12.182  13.359  1.00  0.00           O  
ATOM    969  OD2 ASP A  69      11.760  11.212  12.264  1.00  0.00           O  
ATOM    970  H   ASP A  69       8.937  13.404  14.454  1.00  0.00           H  
ATOM    971  HA  ASP A  69      11.802  13.368  15.101  1.00  0.00           H  
ATOM    972  HB2 ASP A  69      10.527  13.332  12.404  1.00  0.00           H  
ATOM    973  HB3 ASP A  69      11.996  14.281  12.615  1.00  0.00           H  
ATOM    974  N   LYS A  70      11.981  15.890  15.033  1.00  0.00           N  
ATOM    975  CA  LYS A  70      11.978  17.329  15.268  1.00  0.00           C  
ATOM    976  C   LYS A  70      12.756  18.059  14.179  1.00  0.00           C  
ATOM    977  O   LYS A  70      13.979  17.942  14.092  1.00  0.00           O  
ATOM    978  CB  LYS A  70      12.582  17.644  16.639  1.00  0.00           C  
ATOM    979  CG  LYS A  70      12.054  18.927  17.256  1.00  0.00           C  
ATOM    980  CD  LYS A  70      13.048  19.524  18.239  1.00  0.00           C  
ATOM    981  CE  LYS A  70      14.141  20.301  17.523  1.00  0.00           C  
ATOM    982  NZ  LYS A  70      15.399  20.351  18.318  1.00  0.00           N  
ATOM    983  H   LYS A  70      12.815  15.387  15.155  1.00  0.00           H  
ATOM    984  HA  LYS A  70      10.953  17.666  15.251  1.00  0.00           H  
ATOM    985  HB2 LYS A  70      12.361  16.828  17.312  1.00  0.00           H  
ATOM    986  HB3 LYS A  70      13.654  17.733  16.535  1.00  0.00           H  
ATOM    987  HG2 LYS A  70      11.867  19.644  16.470  1.00  0.00           H  
ATOM    988  HG3 LYS A  70      11.132  18.712  17.777  1.00  0.00           H  
ATOM    989  HD2 LYS A  70      12.525  20.192  18.906  1.00  0.00           H  
ATOM    990  HD3 LYS A  70      13.501  18.725  18.809  1.00  0.00           H  
ATOM    991  HE2 LYS A  70      14.342  19.824  16.575  1.00  0.00           H  
ATOM    992  HE3 LYS A  70      13.794  21.310  17.351  1.00  0.00           H  
ATOM    993  HZ1 LYS A  70      15.735  21.331  18.395  1.00  0.00           H  
ATOM    994  HZ2 LYS A  70      16.136  19.780  17.857  1.00  0.00           H  
ATOM    995  HZ3 LYS A  70      15.233  19.976  19.273  1.00  0.00           H  
ATOM    996  N   ILE A  71      12.041  18.814  13.352  1.00  0.00           N  
ATOM    997  CA  ILE A  71      12.665  19.566  12.271  1.00  0.00           C  
ATOM    998  C   ILE A  71      13.231  20.888  12.775  1.00  0.00           C  
ATOM    999  O   ILE A  71      12.504  21.723  13.314  1.00  0.00           O  
ATOM   1000  CB  ILE A  71      11.667  19.849  11.133  1.00  0.00           C  
ATOM   1001  CG1 ILE A  71      11.081  18.539  10.601  1.00  0.00           C  
ATOM   1002  CG2 ILE A  71      12.345  20.626  10.014  1.00  0.00           C  
ATOM   1003  CD1 ILE A  71       9.820  18.108  11.315  1.00  0.00           C  
ATOM   1004  H   ILE A  71      11.070  18.868  13.473  1.00  0.00           H  
ATOM   1005  HA  ILE A  71      13.474  18.968  11.874  1.00  0.00           H  
ATOM   1006  HB  ILE A  71      10.868  20.458  11.528  1.00  0.00           H  
ATOM   1007 HG12 ILE A  71      10.846  18.656   9.555  1.00  0.00           H  
ATOM   1008 HG13 ILE A  71      11.814  17.754  10.714  1.00  0.00           H  
ATOM   1009 HG21 ILE A  71      12.813  21.510  10.422  1.00  0.00           H  
ATOM   1010 HG22 ILE A  71      13.097  20.004   9.549  1.00  0.00           H  
ATOM   1011 HG23 ILE A  71      11.610  20.914   9.278  1.00  0.00           H  
ATOM   1012 HD11 ILE A  71      10.081  17.580  12.221  1.00  0.00           H  
ATOM   1013 HD12 ILE A  71       9.229  18.976  11.561  1.00  0.00           H  
ATOM   1014 HD13 ILE A  71       9.248  17.453  10.671  1.00  0.00           H  
ATOM   1015  N   VAL A  72      14.536  21.073  12.598  1.00  0.00           N  
ATOM   1016  CA  VAL A  72      15.200  22.296  13.033  1.00  0.00           C  
ATOM   1017  C   VAL A  72      15.470  23.224  11.855  1.00  0.00           C  
ATOM   1018  O   VAL A  72      15.624  24.433  12.026  1.00  0.00           O  
ATOM   1019  CB  VAL A  72      16.531  21.989  13.744  1.00  0.00           C  
ATOM   1020  CG1 VAL A  72      16.278  21.428  15.135  1.00  0.00           C  
ATOM   1021  CG2 VAL A  72      17.368  21.024  12.916  1.00  0.00           C  
ATOM   1022  H   VAL A  72      15.063  20.371  12.163  1.00  0.00           H  
ATOM   1023  HA  VAL A  72      14.550  22.798  13.734  1.00  0.00           H  
ATOM   1024  HB  VAL A  72      17.083  22.911  13.847  1.00  0.00           H  
ATOM   1025 HG11 VAL A  72      15.312  20.945  15.157  1.00  0.00           H  
ATOM   1026 HG12 VAL A  72      17.046  20.709  15.380  1.00  0.00           H  
ATOM   1027 HG13 VAL A  72      16.293  22.232  15.856  1.00  0.00           H  
ATOM   1028 HG21 VAL A  72      17.078  20.009  13.147  1.00  0.00           H  
ATOM   1029 HG22 VAL A  72      17.204  21.214  11.865  1.00  0.00           H  
ATOM   1030 HG23 VAL A  72      18.413  21.162  13.148  1.00  0.00           H  
ATOM   1031  N   ALA A  73      15.524  22.651  10.657  1.00  0.00           N  
ATOM   1032  CA  ALA A  73      15.772  23.427   9.448  1.00  0.00           C  
ATOM   1033  C   ALA A  73      15.321  22.667   8.205  1.00  0.00           C  
ATOM   1034  O   ALA A  73      15.443  21.444   8.135  1.00  0.00           O  
ATOM   1035  CB  ALA A  73      17.246  23.786   9.345  1.00  0.00           C  
ATOM   1036  H   ALA A  73      15.393  21.683  10.584  1.00  0.00           H  
ATOM   1037  HA  ALA A  73      15.207  24.346   9.520  1.00  0.00           H  
ATOM   1038  HB1 ALA A  73      17.839  22.884   9.383  1.00  0.00           H  
ATOM   1039  HB2 ALA A  73      17.428  24.296   8.410  1.00  0.00           H  
ATOM   1040  HB3 ALA A  73      17.519  24.431  10.166  1.00  0.00           H  
ATOM   1041  N   VAL A  74      14.799  23.399   7.226  1.00  0.00           N  
ATOM   1042  CA  VAL A  74      14.331  22.795   5.985  1.00  0.00           C  
ATOM   1043  C   VAL A  74      15.162  23.265   4.797  1.00  0.00           C  
ATOM   1044  O   VAL A  74      15.162  24.448   4.456  1.00  0.00           O  
ATOM   1045  CB  VAL A  74      12.850  23.124   5.725  1.00  0.00           C  
ATOM   1046  CG1 VAL A  74      12.397  22.537   4.397  1.00  0.00           C  
ATOM   1047  CG2 VAL A  74      11.982  22.613   6.865  1.00  0.00           C  
ATOM   1048  H   VAL A  74      14.729  24.370   7.341  1.00  0.00           H  
ATOM   1049  HA  VAL A  74      14.429  21.723   6.078  1.00  0.00           H  
ATOM   1050  HB  VAL A  74      12.743  24.197   5.673  1.00  0.00           H  
ATOM   1051 HG11 VAL A  74      11.751  23.241   3.894  1.00  0.00           H  
ATOM   1052 HG12 VAL A  74      13.260  22.333   3.780  1.00  0.00           H  
ATOM   1053 HG13 VAL A  74      11.857  21.618   4.575  1.00  0.00           H  
ATOM   1054 HG21 VAL A  74      11.485  21.704   6.561  1.00  0.00           H  
ATOM   1055 HG22 VAL A  74      12.602  22.413   7.728  1.00  0.00           H  
ATOM   1056 HG23 VAL A  74      11.244  23.359   7.119  1.00  0.00           H  
ATOM   1057  N   ASP A  75      15.867  22.331   4.168  1.00  0.00           N  
ATOM   1058  CA  ASP A  75      16.701  22.650   3.015  1.00  0.00           C  
ATOM   1059  C   ASP A  75      17.628  23.821   3.322  1.00  0.00           C  
ATOM   1060  O   ASP A  75      17.937  24.628   2.446  1.00  0.00           O  
ATOM   1061  CB  ASP A  75      15.828  22.977   1.802  1.00  0.00           C  
ATOM   1062  CG  ASP A  75      15.116  24.308   1.944  1.00  0.00           C  
ATOM   1063  OD1 ASP A  75      15.770  25.354   1.749  1.00  0.00           O  
ATOM   1064  OD2 ASP A  75      13.905  24.304   2.251  1.00  0.00           O  
ATOM   1065  H   ASP A  75      15.825  21.405   4.487  1.00  0.00           H  
ATOM   1066  HA  ASP A  75      17.302  21.781   2.790  1.00  0.00           H  
ATOM   1067  HB2 ASP A  75      16.450  23.015   0.919  1.00  0.00           H  
ATOM   1068  HB3 ASP A  75      15.086  22.203   1.682  1.00  0.00           H  
ATOM   1069  N   GLY A  76      18.068  23.909   4.573  1.00  0.00           N  
ATOM   1070  CA  GLY A  76      18.955  24.986   4.974  1.00  0.00           C  
ATOM   1071  C   GLY A  76      18.227  26.090   5.716  1.00  0.00           C  
ATOM   1072  O   GLY A  76      18.836  26.848   6.470  1.00  0.00           O  
ATOM   1073  H   GLY A  76      17.789  23.237   5.230  1.00  0.00           H  
ATOM   1074  HA2 GLY A  76      19.725  24.584   5.614  1.00  0.00           H  
ATOM   1075  HA3 GLY A  76      19.416  25.405   4.091  1.00  0.00           H  
ATOM   1076  N   VAL A  77      16.918  26.184   5.499  1.00  0.00           N  
ATOM   1077  CA  VAL A  77      16.107  27.204   6.152  1.00  0.00           C  
ATOM   1078  C   VAL A  77      15.972  26.927   7.645  1.00  0.00           C  
ATOM   1079  O   VAL A  77      15.300  25.981   8.053  1.00  0.00           O  
ATOM   1080  CB  VAL A  77      14.701  27.287   5.528  1.00  0.00           C  
ATOM   1081  CG1 VAL A  77      13.845  28.299   6.273  1.00  0.00           C  
ATOM   1082  CG2 VAL A  77      14.794  27.639   4.051  1.00  0.00           C  
ATOM   1083  H   VAL A  77      16.489  25.551   4.886  1.00  0.00           H  
ATOM   1084  HA  VAL A  77      16.595  28.158   6.015  1.00  0.00           H  
ATOM   1085  HB  VAL A  77      14.233  26.318   5.616  1.00  0.00           H  
ATOM   1086 HG11 VAL A  77      13.765  29.203   5.688  1.00  0.00           H  
ATOM   1087 HG12 VAL A  77      12.859  27.886   6.437  1.00  0.00           H  
ATOM   1088 HG13 VAL A  77      14.302  28.526   7.225  1.00  0.00           H  
ATOM   1089 HG21 VAL A  77      14.791  26.733   3.464  1.00  0.00           H  
ATOM   1090 HG22 VAL A  77      13.948  28.252   3.773  1.00  0.00           H  
ATOM   1091 HG23 VAL A  77      15.708  28.184   3.867  1.00  0.00           H  
ATOM   1092  N   ASN A  78      16.618  27.759   8.456  1.00  0.00           N  
ATOM   1093  CA  ASN A  78      16.571  27.604   9.906  1.00  0.00           C  
ATOM   1094  C   ASN A  78      15.178  27.922  10.441  1.00  0.00           C  
ATOM   1095  O   ASN A  78      14.899  29.054  10.837  1.00  0.00           O  
ATOM   1096  CB  ASN A  78      17.606  28.513  10.571  1.00  0.00           C  
ATOM   1097  CG  ASN A  78      17.880  28.120  12.010  1.00  0.00           C  
ATOM   1098  OD1 ASN A  78      17.572  28.867  12.938  1.00  0.00           O  
ATOM   1099  ND2 ASN A  78      18.463  26.943  12.201  1.00  0.00           N  
ATOM   1100  H   ASN A  78      17.139  28.494   8.071  1.00  0.00           H  
ATOM   1101  HA  ASN A  78      16.806  26.576  10.137  1.00  0.00           H  
ATOM   1102  HB2 ASN A  78      18.533  28.455  10.019  1.00  0.00           H  
ATOM   1103  HB3 ASN A  78      17.245  29.529  10.556  1.00  0.00           H  
ATOM   1104 HD21 ASN A  78      18.680  26.400  11.414  1.00  0.00           H  
ATOM   1105 HD22 ASN A  78      18.651  26.664  13.121  1.00  0.00           H  
ATOM   1106  N   ILE A  79      14.310  26.917  10.452  1.00  0.00           N  
ATOM   1107  CA  ILE A  79      12.947  27.089  10.941  1.00  0.00           C  
ATOM   1108  C   ILE A  79      12.874  26.877  12.449  1.00  0.00           C  
ATOM   1109  O   ILE A  79      11.790  26.714  13.010  1.00  0.00           O  
ATOM   1110  CB  ILE A  79      11.973  26.117  10.249  1.00  0.00           C  
ATOM   1111  CG1 ILE A  79      12.322  24.671  10.607  1.00  0.00           C  
ATOM   1112  CG2 ILE A  79      12.006  26.319   8.741  1.00  0.00           C  
ATOM   1113  CD1 ILE A  79      11.125  23.746  10.617  1.00  0.00           C  
ATOM   1114  H   ILE A  79      14.592  26.038  10.123  1.00  0.00           H  
ATOM   1115  HA  ILE A  79      12.638  28.100  10.715  1.00  0.00           H  
ATOM   1116  HB  ILE A  79      10.975  26.336  10.595  1.00  0.00           H  
ATOM   1117 HG12 ILE A  79      13.029  24.289   9.886  1.00  0.00           H  
ATOM   1118 HG13 ILE A  79      12.769  24.648  11.589  1.00  0.00           H  
ATOM   1119 HG21 ILE A  79      11.129  25.870   8.299  1.00  0.00           H  
ATOM   1120 HG22 ILE A  79      12.019  27.375   8.520  1.00  0.00           H  
ATOM   1121 HG23 ILE A  79      12.892  25.854   8.334  1.00  0.00           H  
ATOM   1122 HD11 ILE A  79      10.265  24.263  10.219  1.00  0.00           H  
ATOM   1123 HD12 ILE A  79      11.335  22.877  10.013  1.00  0.00           H  
ATOM   1124 HD13 ILE A  79      10.919  23.437  11.632  1.00  0.00           H  
ATOM   1125  N   GLN A  80      14.034  26.881  13.099  1.00  0.00           N  
ATOM   1126  CA  GLN A  80      14.100  26.690  14.543  1.00  0.00           C  
ATOM   1127  C   GLN A  80      12.932  27.382  15.238  1.00  0.00           C  
ATOM   1128  O   GLN A  80      12.109  26.736  15.885  1.00  0.00           O  
ATOM   1129  CB  GLN A  80      15.424  27.226  15.089  1.00  0.00           C  
ATOM   1130  CG  GLN A  80      16.591  26.271  14.898  1.00  0.00           C  
ATOM   1131  CD  GLN A  80      17.843  26.727  15.622  1.00  0.00           C  
ATOM   1132  OE1 GLN A  80      18.039  27.920  15.857  1.00  0.00           O  
ATOM   1133  NE2 GLN A  80      18.698  25.777  15.982  1.00  0.00           N  
ATOM   1134  H   GLN A  80      14.863  27.015  12.596  1.00  0.00           H  
ATOM   1135  HA  GLN A  80      14.042  25.630  14.740  1.00  0.00           H  
ATOM   1136  HB2 GLN A  80      15.658  28.152  14.587  1.00  0.00           H  
ATOM   1137  HB3 GLN A  80      15.313  27.416  16.146  1.00  0.00           H  
ATOM   1138  HG2 GLN A  80      16.310  25.299  15.275  1.00  0.00           H  
ATOM   1139  HG3 GLN A  80      16.810  26.198  13.843  1.00  0.00           H  
ATOM   1140 HE21 GLN A  80      18.477  24.848  15.762  1.00  0.00           H  
ATOM   1141 HE22 GLN A  80      19.515  26.043  16.451  1.00  0.00           H  
ATOM   1142  N   GLY A  81      12.867  28.704  15.100  1.00  0.00           N  
ATOM   1143  CA  GLY A  81      11.797  29.462  15.721  1.00  0.00           C  
ATOM   1144  C   GLY A  81      10.780  29.961  14.714  1.00  0.00           C  
ATOM   1145  O   GLY A  81      10.408  31.134  14.724  1.00  0.00           O  
ATOM   1146  H   GLY A  81      13.551  29.167  14.573  1.00  0.00           H  
ATOM   1147  HA2 GLY A  81      11.296  28.833  16.442  1.00  0.00           H  
ATOM   1148  HA3 GLY A  81      12.224  30.312  16.234  1.00  0.00           H  
ATOM   1149  N   PHE A  82      10.329  29.068  13.838  1.00  0.00           N  
ATOM   1150  CA  PHE A  82       9.350  29.424  12.818  1.00  0.00           C  
ATOM   1151  C   PHE A  82       7.955  28.951  13.213  1.00  0.00           C  
ATOM   1152  O   PHE A  82       7.794  28.176  14.154  1.00  0.00           O  
ATOM   1153  CB  PHE A  82       9.745  28.817  11.469  1.00  0.00           C  
ATOM   1154  CG  PHE A  82      10.725  29.654  10.698  1.00  0.00           C  
ATOM   1155  CD1 PHE A  82      11.777  30.283  11.343  1.00  0.00           C  
ATOM   1156  CD2 PHE A  82      10.592  29.814   9.329  1.00  0.00           C  
ATOM   1157  CE1 PHE A  82      12.681  31.055  10.637  1.00  0.00           C  
ATOM   1158  CE2 PHE A  82      11.494  30.583   8.616  1.00  0.00           C  
ATOM   1159  CZ  PHE A  82      12.538  31.204   9.272  1.00  0.00           C  
ATOM   1160  H   PHE A  82      10.662  28.147  13.880  1.00  0.00           H  
ATOM   1161  HA  PHE A  82       9.341  30.500  12.729  1.00  0.00           H  
ATOM   1162  HB2 PHE A  82      10.194  27.850  11.636  1.00  0.00           H  
ATOM   1163  HB3 PHE A  82       8.858  28.698  10.864  1.00  0.00           H  
ATOM   1164  HD1 PHE A  82      11.890  30.165  12.412  1.00  0.00           H  
ATOM   1165  HD2 PHE A  82       9.775  29.329   8.814  1.00  0.00           H  
ATOM   1166  HE1 PHE A  82      13.497  31.539  11.153  1.00  0.00           H  
ATOM   1167  HE2 PHE A  82      11.379  30.700   7.549  1.00  0.00           H  
ATOM   1168  HZ  PHE A  82      13.243  31.806   8.718  1.00  0.00           H  
ATOM   1169  N   ALA A  83       6.948  29.425  12.486  1.00  0.00           N  
ATOM   1170  CA  ALA A  83       5.566  29.050  12.759  1.00  0.00           C  
ATOM   1171  C   ALA A  83       5.047  28.070  11.713  1.00  0.00           C  
ATOM   1172  O   ALA A  83       5.512  28.059  10.574  1.00  0.00           O  
ATOM   1173  CB  ALA A  83       4.683  30.288  12.811  1.00  0.00           C  
ATOM   1174  H   ALA A  83       7.139  30.040  11.748  1.00  0.00           H  
ATOM   1175  HA  ALA A  83       5.534  28.575  13.729  1.00  0.00           H  
ATOM   1176  HB1 ALA A  83       5.273  31.137  13.126  1.00  0.00           H  
ATOM   1177  HB2 ALA A  83       4.273  30.478  11.829  1.00  0.00           H  
ATOM   1178  HB3 ALA A  83       3.879  30.128  13.513  1.00  0.00           H  
ATOM   1179  N   ASN A  84       4.079  27.249  12.107  1.00  0.00           N  
ATOM   1180  CA  ASN A  84       3.496  26.264  11.201  1.00  0.00           C  
ATOM   1181  C   ASN A  84       3.357  26.835   9.794  1.00  0.00           C  
ATOM   1182  O   ASN A  84       3.839  26.249   8.824  1.00  0.00           O  
ATOM   1183  CB  ASN A  84       2.129  25.812  11.719  1.00  0.00           C  
ATOM   1184  CG  ASN A  84       2.232  25.009  13.002  1.00  0.00           C  
ATOM   1185  OD1 ASN A  84       2.053  25.543  14.097  1.00  0.00           O  
ATOM   1186  ND2 ASN A  84       2.523  23.721  12.872  1.00  0.00           N  
ATOM   1187  H   ASN A  84       3.748  27.306  13.028  1.00  0.00           H  
ATOM   1188  HA  ASN A  84       4.158  25.413  11.169  1.00  0.00           H  
ATOM   1189  HB2 ASN A  84       1.517  26.682  11.909  1.00  0.00           H  
ATOM   1190  HB3 ASN A  84       1.653  25.198  10.970  1.00  0.00           H  
ATOM   1191 HD21 ASN A  84       2.653  23.364  11.968  1.00  0.00           H  
ATOM   1192 HD22 ASN A  84       2.596  23.179  13.685  1.00  0.00           H  
ATOM   1193  N   HIS A  85       2.693  27.982   9.689  1.00  0.00           N  
ATOM   1194  CA  HIS A  85       2.491  28.632   8.400  1.00  0.00           C  
ATOM   1195  C   HIS A  85       3.824  29.044   7.783  1.00  0.00           C  
ATOM   1196  O   HIS A  85       4.049  28.862   6.587  1.00  0.00           O  
ATOM   1197  CB  HIS A  85       1.590  29.858   8.559  1.00  0.00           C  
ATOM   1198  CG  HIS A  85       1.938  30.708   9.743  1.00  0.00           C  
ATOM   1199  ND1 HIS A  85       1.263  30.639  10.943  1.00  0.00           N  
ATOM   1200  CD2 HIS A  85       2.899  31.648   9.906  1.00  0.00           C  
ATOM   1201  CE1 HIS A  85       1.791  31.501  11.793  1.00  0.00           C  
ATOM   1202  NE2 HIS A  85       2.786  32.125  11.189  1.00  0.00           N  
ATOM   1203  H   HIS A  85       2.331  28.400  10.497  1.00  0.00           H  
ATOM   1204  HA  HIS A  85       2.007  27.925   7.744  1.00  0.00           H  
ATOM   1205  HB2 HIS A  85       1.671  30.474   7.675  1.00  0.00           H  
ATOM   1206  HB3 HIS A  85       0.567  29.532   8.673  1.00  0.00           H  
ATOM   1207  HD1 HIS A  85       0.508  30.047  11.141  1.00  0.00           H  
ATOM   1208  HD2 HIS A  85       3.620  31.963   9.166  1.00  0.00           H  
ATOM   1209  HE1 HIS A  85       1.467  31.667  12.809  1.00  0.00           H  
ATOM   1210  HE2 HIS A  85       3.293  32.875  11.565  1.00  0.00           H  
ATOM   1211  N   ASP A  86       4.706  29.599   8.608  1.00  0.00           N  
ATOM   1212  CA  ASP A  86       6.018  30.035   8.144  1.00  0.00           C  
ATOM   1213  C   ASP A  86       6.814  28.861   7.582  1.00  0.00           C  
ATOM   1214  O   ASP A  86       7.627  29.027   6.674  1.00  0.00           O  
ATOM   1215  CB  ASP A  86       6.793  30.694   9.286  1.00  0.00           C  
ATOM   1216  CG  ASP A  86       7.825  31.687   8.787  1.00  0.00           C  
ATOM   1217  OD1 ASP A  86       8.285  31.536   7.637  1.00  0.00           O  
ATOM   1218  OD2 ASP A  86       8.173  32.615   9.549  1.00  0.00           O  
ATOM   1219  H   ASP A  86       4.468  29.717   9.552  1.00  0.00           H  
ATOM   1220  HA  ASP A  86       5.868  30.760   7.358  1.00  0.00           H  
ATOM   1221  HB2 ASP A  86       6.099  31.216   9.929  1.00  0.00           H  
ATOM   1222  HB3 ASP A  86       7.301  29.930   9.855  1.00  0.00           H  
ATOM   1223  N   VAL A  87       6.574  27.674   8.132  1.00  0.00           N  
ATOM   1224  CA  VAL A  87       7.269  26.472   7.686  1.00  0.00           C  
ATOM   1225  C   VAL A  87       6.664  25.934   6.394  1.00  0.00           C  
ATOM   1226  O   VAL A  87       7.374  25.416   5.532  1.00  0.00           O  
ATOM   1227  CB  VAL A  87       7.224  25.368   8.759  1.00  0.00           C  
ATOM   1228  CG1 VAL A  87       7.941  24.119   8.271  1.00  0.00           C  
ATOM   1229  CG2 VAL A  87       7.832  25.866  10.062  1.00  0.00           C  
ATOM   1230  H   VAL A  87       5.914  27.606   8.852  1.00  0.00           H  
ATOM   1231  HA  VAL A  87       8.303  26.730   7.508  1.00  0.00           H  
ATOM   1232  HB  VAL A  87       6.190  25.114   8.943  1.00  0.00           H  
ATOM   1233 HG11 VAL A  87       8.893  24.029   8.775  1.00  0.00           H  
ATOM   1234 HG12 VAL A  87       7.337  23.249   8.485  1.00  0.00           H  
ATOM   1235 HG13 VAL A  87       8.105  24.191   7.206  1.00  0.00           H  
ATOM   1236 HG21 VAL A  87       7.606  26.916  10.185  1.00  0.00           H  
ATOM   1237 HG22 VAL A  87       7.417  25.310  10.890  1.00  0.00           H  
ATOM   1238 HG23 VAL A  87       8.902  25.727  10.036  1.00  0.00           H  
ATOM   1239  N   VAL A  88       5.347  26.061   6.266  1.00  0.00           N  
ATOM   1240  CA  VAL A  88       4.645  25.590   5.078  1.00  0.00           C  
ATOM   1241  C   VAL A  88       5.181  26.265   3.821  1.00  0.00           C  
ATOM   1242  O   VAL A  88       5.556  25.596   2.858  1.00  0.00           O  
ATOM   1243  CB  VAL A  88       3.130  25.848   5.182  1.00  0.00           C  
ATOM   1244  CG1 VAL A  88       2.426  25.417   3.904  1.00  0.00           C  
ATOM   1245  CG2 VAL A  88       2.549  25.128   6.389  1.00  0.00           C  
ATOM   1246  H   VAL A  88       4.835  26.483   6.987  1.00  0.00           H  
ATOM   1247  HA  VAL A  88       4.803  24.524   4.998  1.00  0.00           H  
ATOM   1248  HB  VAL A  88       2.974  26.909   5.312  1.00  0.00           H  
ATOM   1249 HG11 VAL A  88       1.372  25.289   4.099  1.00  0.00           H  
ATOM   1250 HG12 VAL A  88       2.564  26.173   3.145  1.00  0.00           H  
ATOM   1251 HG13 VAL A  88       2.845  24.482   3.561  1.00  0.00           H  
ATOM   1252 HG21 VAL A  88       3.347  24.661   6.947  1.00  0.00           H  
ATOM   1253 HG22 VAL A  88       2.036  25.839   7.021  1.00  0.00           H  
ATOM   1254 HG23 VAL A  88       1.851  24.374   6.058  1.00  0.00           H  
ATOM   1255  N   GLU A  89       5.212  27.594   3.836  1.00  0.00           N  
ATOM   1256  CA  GLU A  89       5.701  28.358   2.695  1.00  0.00           C  
ATOM   1257  C   GLU A  89       7.119  27.936   2.323  1.00  0.00           C  
ATOM   1258  O   GLU A  89       7.467  27.857   1.145  1.00  0.00           O  
ATOM   1259  CB  GLU A  89       5.668  29.856   3.005  1.00  0.00           C  
ATOM   1260  CG  GLU A  89       6.607  30.265   4.128  1.00  0.00           C  
ATOM   1261  CD  GLU A  89       6.569  31.756   4.406  1.00  0.00           C  
ATOM   1262  OE1 GLU A  89       5.722  32.187   5.217  1.00  0.00           O  
ATOM   1263  OE2 GLU A  89       7.386  32.491   3.813  1.00  0.00           O  
ATOM   1264  H   GLU A  89       4.899  28.070   4.633  1.00  0.00           H  
ATOM   1265  HA  GLU A  89       5.048  28.160   1.858  1.00  0.00           H  
ATOM   1266  HB2 GLU A  89       5.946  30.403   2.116  1.00  0.00           H  
ATOM   1267  HB3 GLU A  89       4.663  30.131   3.287  1.00  0.00           H  
ATOM   1268  HG2 GLU A  89       6.322  29.740   5.027  1.00  0.00           H  
ATOM   1269  HG3 GLU A  89       7.615  29.989   3.857  1.00  0.00           H  
ATOM   1270  N   VAL A  90       7.934  27.664   3.338  1.00  0.00           N  
ATOM   1271  CA  VAL A  90       9.315  27.249   3.119  1.00  0.00           C  
ATOM   1272  C   VAL A  90       9.380  25.981   2.275  1.00  0.00           C  
ATOM   1273  O   VAL A  90      10.163  25.892   1.328  1.00  0.00           O  
ATOM   1274  CB  VAL A  90      10.044  27.002   4.453  1.00  0.00           C  
ATOM   1275  CG1 VAL A  90      11.432  26.429   4.206  1.00  0.00           C  
ATOM   1276  CG2 VAL A  90      10.127  28.289   5.261  1.00  0.00           C  
ATOM   1277  H   VAL A  90       7.599  27.745   4.255  1.00  0.00           H  
ATOM   1278  HA  VAL A  90       9.824  28.044   2.597  1.00  0.00           H  
ATOM   1279  HB  VAL A  90       9.477  26.281   5.023  1.00  0.00           H  
ATOM   1280 HG11 VAL A  90      12.176  27.115   4.580  1.00  0.00           H  
ATOM   1281 HG12 VAL A  90      11.525  25.480   4.714  1.00  0.00           H  
ATOM   1282 HG13 VAL A  90      11.577  26.286   3.145  1.00  0.00           H  
ATOM   1283 HG21 VAL A  90      10.092  28.055   6.314  1.00  0.00           H  
ATOM   1284 HG22 VAL A  90      11.053  28.797   5.036  1.00  0.00           H  
ATOM   1285 HG23 VAL A  90       9.294  28.928   5.006  1.00  0.00           H  
ATOM   1286  N   LEU A  91       8.552  25.002   2.623  1.00  0.00           N  
ATOM   1287  CA  LEU A  91       8.514  23.737   1.897  1.00  0.00           C  
ATOM   1288  C   LEU A  91       8.169  23.963   0.429  1.00  0.00           C  
ATOM   1289  O   LEU A  91       8.828  23.427  -0.463  1.00  0.00           O  
ATOM   1290  CB  LEU A  91       7.494  22.791   2.534  1.00  0.00           C  
ATOM   1291  CG  LEU A  91       7.678  22.511   4.025  1.00  0.00           C  
ATOM   1292  CD1 LEU A  91       6.433  21.858   4.603  1.00  0.00           C  
ATOM   1293  CD2 LEU A  91       8.899  21.632   4.256  1.00  0.00           C  
ATOM   1294  H   LEU A  91       7.952  25.131   3.387  1.00  0.00           H  
ATOM   1295  HA  LEU A  91       9.495  23.290   1.959  1.00  0.00           H  
ATOM   1296  HB2 LEU A  91       6.514  23.223   2.397  1.00  0.00           H  
ATOM   1297  HB3 LEU A  91       7.547  21.848   2.009  1.00  0.00           H  
ATOM   1298  HG  LEU A  91       7.835  23.446   4.545  1.00  0.00           H  
ATOM   1299 HD11 LEU A  91       6.702  21.268   5.465  1.00  0.00           H  
ATOM   1300 HD12 LEU A  91       5.983  21.218   3.858  1.00  0.00           H  
ATOM   1301 HD13 LEU A  91       5.727  22.621   4.894  1.00  0.00           H  
ATOM   1302 HD21 LEU A  91       8.614  20.766   4.834  1.00  0.00           H  
ATOM   1303 HD22 LEU A  91       9.649  22.194   4.794  1.00  0.00           H  
ATOM   1304 HD23 LEU A  91       9.300  21.315   3.305  1.00  0.00           H  
ATOM   1305  N   ARG A  92       7.134  24.759   0.185  1.00  0.00           N  
ATOM   1306  CA  ARG A  92       6.703  25.057  -1.176  1.00  0.00           C  
ATOM   1307  C   ARG A  92       7.805  25.770  -1.953  1.00  0.00           C  
ATOM   1308  O   ARG A  92       8.034  25.485  -3.127  1.00  0.00           O  
ATOM   1309  CB  ARG A  92       5.439  25.919  -1.155  1.00  0.00           C  
ATOM   1310  CG  ARG A  92       4.279  25.283  -0.406  1.00  0.00           C  
ATOM   1311  CD  ARG A  92       3.038  26.160  -0.452  1.00  0.00           C  
ATOM   1312  NE  ARG A  92       1.809  25.373  -0.392  1.00  0.00           N  
ATOM   1313  CZ  ARG A  92       1.235  24.824  -1.457  1.00  0.00           C  
ATOM   1314  NH1 ARG A  92       1.776  24.975  -2.658  1.00  0.00           N  
ATOM   1315  NH2 ARG A  92       0.117  24.121  -1.321  1.00  0.00           N  
ATOM   1316  H   ARG A  92       6.648  25.156   0.938  1.00  0.00           H  
ATOM   1317  HA  ARG A  92       6.481  24.120  -1.665  1.00  0.00           H  
ATOM   1318  HB2 ARG A  92       5.668  26.863  -0.684  1.00  0.00           H  
ATOM   1319  HB3 ARG A  92       5.125  26.101  -2.172  1.00  0.00           H  
ATOM   1320  HG2 ARG A  92       4.050  24.329  -0.859  1.00  0.00           H  
ATOM   1321  HG3 ARG A  92       4.567  25.135   0.624  1.00  0.00           H  
ATOM   1322  HD2 ARG A  92       3.061  26.838   0.387  1.00  0.00           H  
ATOM   1323  HD3 ARG A  92       3.048  26.725  -1.372  1.00  0.00           H  
ATOM   1324  HE  ARG A  92       1.393  25.248   0.486  1.00  0.00           H  
ATOM   1325 HH11 ARG A  92       2.618  25.503  -2.763  1.00  0.00           H  
ATOM   1326 HH12 ARG A  92       1.342  24.559  -3.458  1.00  0.00           H  
ATOM   1327 HH21 ARG A  92      -0.293  24.005  -0.417  1.00  0.00           H  
ATOM   1328 HH22 ARG A  92      -0.314  23.709  -2.122  1.00  0.00           H  
ATOM   1329  N   ASN A  93       8.485  26.698  -1.287  1.00  0.00           N  
ATOM   1330  CA  ASN A  93       9.564  27.452  -1.915  1.00  0.00           C  
ATOM   1331  C   ASN A  93      10.717  26.533  -2.302  1.00  0.00           C  
ATOM   1332  O   ASN A  93      11.336  26.705  -3.352  1.00  0.00           O  
ATOM   1333  CB  ASN A  93      10.064  28.548  -0.972  1.00  0.00           C  
ATOM   1334  CG  ASN A  93       9.248  29.822  -1.080  1.00  0.00           C  
ATOM   1335  OD1 ASN A  93       9.255  30.491  -2.113  1.00  0.00           O  
ATOM   1336  ND2 ASN A  93       8.540  30.164  -0.010  1.00  0.00           N  
ATOM   1337  H   ASN A  93       8.257  26.880  -0.352  1.00  0.00           H  
ATOM   1338  HA  ASN A  93       9.169  27.912  -2.809  1.00  0.00           H  
ATOM   1339  HB2 ASN A  93      10.006  28.192   0.046  1.00  0.00           H  
ATOM   1340  HB3 ASN A  93      11.092  28.779  -1.210  1.00  0.00           H  
ATOM   1341 HD21 ASN A  93       8.583  29.582   0.778  1.00  0.00           H  
ATOM   1342 HD22 ASN A  93       8.003  30.982  -0.052  1.00  0.00           H  
ATOM   1343  N   ALA A  94      11.001  25.556  -1.448  1.00  0.00           N  
ATOM   1344  CA  ALA A  94      12.078  24.608  -1.701  1.00  0.00           C  
ATOM   1345  C   ALA A  94      11.919  23.949  -3.067  1.00  0.00           C  
ATOM   1346  O   ALA A  94      10.802  23.698  -3.520  1.00  0.00           O  
ATOM   1347  CB  ALA A  94      12.121  23.553  -0.605  1.00  0.00           C  
ATOM   1348  H   ALA A  94      10.471  25.470  -0.627  1.00  0.00           H  
ATOM   1349  HA  ALA A  94      13.012  25.150  -1.681  1.00  0.00           H  
ATOM   1350  HB1 ALA A  94      12.774  22.746  -0.908  1.00  0.00           H  
ATOM   1351  HB2 ALA A  94      12.494  23.995   0.306  1.00  0.00           H  
ATOM   1352  HB3 ALA A  94      11.127  23.167  -0.438  1.00  0.00           H  
ATOM   1353  N   GLY A  95      13.043  23.669  -3.720  1.00  0.00           N  
ATOM   1354  CA  GLY A  95      13.006  23.042  -5.027  1.00  0.00           C  
ATOM   1355  C   GLY A  95      13.157  21.536  -4.953  1.00  0.00           C  
ATOM   1356  O   GLY A  95      12.883  20.929  -3.916  1.00  0.00           O  
ATOM   1357  H   GLY A  95      13.905  23.891  -3.309  1.00  0.00           H  
ATOM   1358  HA2 GLY A  95      12.064  23.276  -5.500  1.00  0.00           H  
ATOM   1359  HA3 GLY A  95      13.808  23.443  -5.629  1.00  0.00           H  
ATOM   1360  N   GLN A  96      13.592  20.931  -6.053  1.00  0.00           N  
ATOM   1361  CA  GLN A  96      13.776  19.485  -6.108  1.00  0.00           C  
ATOM   1362  C   GLN A  96      14.623  19.000  -4.937  1.00  0.00           C  
ATOM   1363  O   GLN A  96      14.162  18.216  -4.106  1.00  0.00           O  
ATOM   1364  CB  GLN A  96      14.433  19.083  -7.430  1.00  0.00           C  
ATOM   1365  CG  GLN A  96      14.205  17.628  -7.805  1.00  0.00           C  
ATOM   1366  CD  GLN A  96      14.301  17.389  -9.299  1.00  0.00           C  
ATOM   1367  OE1 GLN A  96      15.289  17.756  -9.935  1.00  0.00           O  
ATOM   1368  NE2 GLN A  96      13.273  16.769  -9.866  1.00  0.00           N  
ATOM   1369  H   GLN A  96      13.793  21.469  -6.847  1.00  0.00           H  
ATOM   1370  HA  GLN A  96      12.802  19.025  -6.047  1.00  0.00           H  
ATOM   1371  HB2 GLN A  96      14.036  19.703  -8.220  1.00  0.00           H  
ATOM   1372  HB3 GLN A  96      15.498  19.250  -7.354  1.00  0.00           H  
ATOM   1373  HG2 GLN A  96      14.950  17.021  -7.311  1.00  0.00           H  
ATOM   1374  HG3 GLN A  96      13.222  17.334  -7.470  1.00  0.00           H  
ATOM   1375 HE21 GLN A  96      12.519  16.507  -9.296  1.00  0.00           H  
ATOM   1376 HE22 GLN A  96      13.308  16.602 -10.831  1.00  0.00           H  
ATOM   1377  N   VAL A  97      15.865  19.470  -4.876  1.00  0.00           N  
ATOM   1378  CA  VAL A  97      16.777  19.084  -3.805  1.00  0.00           C  
ATOM   1379  C   VAL A  97      16.362  19.710  -2.478  1.00  0.00           C  
ATOM   1380  O   VAL A  97      16.632  20.883  -2.221  1.00  0.00           O  
ATOM   1381  CB  VAL A  97      18.225  19.498  -4.125  1.00  0.00           C  
ATOM   1382  CG1 VAL A  97      19.142  19.184  -2.953  1.00  0.00           C  
ATOM   1383  CG2 VAL A  97      18.709  18.808  -5.391  1.00  0.00           C  
ATOM   1384  H   VAL A  97      16.175  20.091  -5.567  1.00  0.00           H  
ATOM   1385  HA  VAL A  97      16.745  18.008  -3.711  1.00  0.00           H  
ATOM   1386  HB  VAL A  97      18.244  20.565  -4.293  1.00  0.00           H  
ATOM   1387 HG11 VAL A  97      18.614  18.572  -2.237  1.00  0.00           H  
ATOM   1388 HG12 VAL A  97      20.013  18.655  -3.309  1.00  0.00           H  
ATOM   1389 HG13 VAL A  97      19.449  20.106  -2.481  1.00  0.00           H  
ATOM   1390 HG21 VAL A  97      18.212  17.854  -5.493  1.00  0.00           H  
ATOM   1391 HG22 VAL A  97      18.481  19.425  -6.248  1.00  0.00           H  
ATOM   1392 HG23 VAL A  97      19.776  18.653  -5.333  1.00  0.00           H  
ATOM   1393  N   VAL A  98      15.705  18.917  -1.637  1.00  0.00           N  
ATOM   1394  CA  VAL A  98      15.254  19.393  -0.334  1.00  0.00           C  
ATOM   1395  C   VAL A  98      16.044  18.739   0.793  1.00  0.00           C  
ATOM   1396  O   VAL A  98      15.839  17.568   1.112  1.00  0.00           O  
ATOM   1397  CB  VAL A  98      13.753  19.114  -0.124  1.00  0.00           C  
ATOM   1398  CG1 VAL A  98      13.306  19.604   1.245  1.00  0.00           C  
ATOM   1399  CG2 VAL A  98      12.931  19.763  -1.227  1.00  0.00           C  
ATOM   1400  H   VAL A  98      15.519  17.992  -1.898  1.00  0.00           H  
ATOM   1401  HA  VAL A  98      15.408  20.462  -0.297  1.00  0.00           H  
ATOM   1402  HB  VAL A  98      13.598  18.046  -0.167  1.00  0.00           H  
ATOM   1403 HG11 VAL A  98      13.803  19.030   2.013  1.00  0.00           H  
ATOM   1404 HG12 VAL A  98      13.559  20.649   1.353  1.00  0.00           H  
ATOM   1405 HG13 VAL A  98      12.237  19.481   1.340  1.00  0.00           H  
ATOM   1406 HG21 VAL A  98      13.522  19.818  -2.129  1.00  0.00           H  
ATOM   1407 HG22 VAL A  98      12.046  19.171  -1.413  1.00  0.00           H  
ATOM   1408 HG23 VAL A  98      12.641  20.757  -0.923  1.00  0.00           H  
ATOM   1409  N   HIS A  99      16.950  19.504   1.395  1.00  0.00           N  
ATOM   1410  CA  HIS A  99      17.772  19.000   2.488  1.00  0.00           C  
ATOM   1411  C   HIS A  99      17.099  19.252   3.834  1.00  0.00           C  
ATOM   1412  O   HIS A  99      17.260  20.318   4.430  1.00  0.00           O  
ATOM   1413  CB  HIS A  99      19.152  19.658   2.463  1.00  0.00           C  
ATOM   1414  CG  HIS A  99      20.111  19.002   1.517  1.00  0.00           C  
ATOM   1415  ND1 HIS A  99      20.711  19.671   0.471  1.00  0.00           N  
ATOM   1416  CD2 HIS A  99      20.574  17.732   1.465  1.00  0.00           C  
ATOM   1417  CE1 HIS A  99      21.500  18.839  -0.185  1.00  0.00           C  
ATOM   1418  NE2 HIS A  99      21.436  17.656   0.399  1.00  0.00           N  
ATOM   1419  H   HIS A  99      17.068  20.430   1.095  1.00  0.00           H  
ATOM   1420  HA  HIS A  99      17.888  17.934   2.352  1.00  0.00           H  
ATOM   1421  HB2 HIS A  99      19.046  20.690   2.165  1.00  0.00           H  
ATOM   1422  HB3 HIS A  99      19.582  19.616   3.453  1.00  0.00           H  
ATOM   1423  HD1 HIS A  99      20.576  20.614   0.243  1.00  0.00           H  
ATOM   1424  HD2 HIS A  99      20.314  16.925   2.137  1.00  0.00           H  
ATOM   1425  HE1 HIS A  99      22.098  19.085  -1.050  1.00  0.00           H  
ATOM   1426  HE2 HIS A  99      21.857  16.838   0.063  1.00  0.00           H  
ATOM   1427  N   LEU A 100      16.347  18.265   4.308  1.00  0.00           N  
ATOM   1428  CA  LEU A 100      15.648  18.381   5.584  1.00  0.00           C  
ATOM   1429  C   LEU A 100      16.606  18.161   6.750  1.00  0.00           C  
ATOM   1430  O   LEU A 100      17.421  17.237   6.733  1.00  0.00           O  
ATOM   1431  CB  LEU A 100      14.501  17.371   5.653  1.00  0.00           C  
ATOM   1432  CG  LEU A 100      13.285  17.792   6.478  1.00  0.00           C  
ATOM   1433  CD1 LEU A 100      13.723  18.396   7.804  1.00  0.00           C  
ATOM   1434  CD2 LEU A 100      12.427  18.779   5.699  1.00  0.00           C  
ATOM   1435  H   LEU A 100      16.256  17.441   3.788  1.00  0.00           H  
ATOM   1436  HA  LEU A 100      15.243  19.379   5.651  1.00  0.00           H  
ATOM   1437  HB2 LEU A 100      14.166  17.182   4.644  1.00  0.00           H  
ATOM   1438  HB3 LEU A 100      14.891  16.458   6.079  1.00  0.00           H  
ATOM   1439  HG  LEU A 100      12.683  16.920   6.691  1.00  0.00           H  
ATOM   1440 HD11 LEU A 100      13.951  19.442   7.666  1.00  0.00           H  
ATOM   1441 HD12 LEU A 100      14.601  17.879   8.163  1.00  0.00           H  
ATOM   1442 HD13 LEU A 100      12.926  18.293   8.527  1.00  0.00           H  
ATOM   1443 HD21 LEU A 100      12.554  18.607   4.641  1.00  0.00           H  
ATOM   1444 HD22 LEU A 100      12.731  19.788   5.939  1.00  0.00           H  
ATOM   1445 HD23 LEU A 100      11.389  18.642   5.965  1.00  0.00           H  
ATOM   1446  N   THR A 101      16.502  19.014   7.765  1.00  0.00           N  
ATOM   1447  CA  THR A 101      17.357  18.912   8.940  1.00  0.00           C  
ATOM   1448  C   THR A 101      16.572  18.420  10.150  1.00  0.00           C  
ATOM   1449  O   THR A 101      15.780  19.161  10.733  1.00  0.00           O  
ATOM   1450  CB  THR A 101      18.007  20.266   9.280  1.00  0.00           C  
ATOM   1451  OG1 THR A 101      18.558  20.856   8.097  1.00  0.00           O  
ATOM   1452  CG2 THR A 101      19.100  20.095  10.325  1.00  0.00           C  
ATOM   1453  H   THR A 101      15.833  19.729   7.720  1.00  0.00           H  
ATOM   1454  HA  THR A 101      18.143  18.204   8.721  1.00  0.00           H  
ATOM   1455  HB  THR A 101      17.247  20.923   9.680  1.00  0.00           H  
ATOM   1456  HG1 THR A 101      19.178  20.243   7.694  1.00  0.00           H  
ATOM   1457 HG21 THR A 101      19.770  19.306  10.018  1.00  0.00           H  
ATOM   1458 HG22 THR A 101      18.653  19.839  11.275  1.00  0.00           H  
ATOM   1459 HG23 THR A 101      19.651  21.018  10.423  1.00  0.00           H  
ATOM   1460  N   LEU A 102      16.796  17.164  10.524  1.00  0.00           N  
ATOM   1461  CA  LEU A 102      16.109  16.572  11.667  1.00  0.00           C  
ATOM   1462  C   LEU A 102      17.102  16.192  12.760  1.00  0.00           C  
ATOM   1463  O   LEU A 102      18.293  16.018  12.501  1.00  0.00           O  
ATOM   1464  CB  LEU A 102      15.317  15.338  11.229  1.00  0.00           C  
ATOM   1465  CG  LEU A 102      14.521  15.479   9.931  1.00  0.00           C  
ATOM   1466  CD1 LEU A 102      15.406  15.196   8.727  1.00  0.00           C  
ATOM   1467  CD2 LEU A 102      13.317  14.548   9.941  1.00  0.00           C  
ATOM   1468  H   LEU A 102      17.437  16.622  10.020  1.00  0.00           H  
ATOM   1469  HA  LEU A 102      15.424  17.309  12.060  1.00  0.00           H  
ATOM   1470  HB2 LEU A 102      16.016  14.526  11.101  1.00  0.00           H  
ATOM   1471  HB3 LEU A 102      14.623  15.094  12.020  1.00  0.00           H  
ATOM   1472  HG  LEU A 102      14.158  16.494   9.847  1.00  0.00           H  
ATOM   1473 HD11 LEU A 102      16.393  14.918   9.064  1.00  0.00           H  
ATOM   1474 HD12 LEU A 102      15.472  16.083   8.113  1.00  0.00           H  
ATOM   1475 HD13 LEU A 102      14.981  14.390   8.150  1.00  0.00           H  
ATOM   1476 HD21 LEU A 102      13.115  14.232  10.954  1.00  0.00           H  
ATOM   1477 HD22 LEU A 102      13.528  13.681   9.330  1.00  0.00           H  
ATOM   1478 HD23 LEU A 102      12.457  15.066   9.547  1.00  0.00           H  
ATOM   1479  N   VAL A 103      16.603  16.060  13.986  1.00  0.00           N  
ATOM   1480  CA  VAL A 103      17.445  15.697  15.119  1.00  0.00           C  
ATOM   1481  C   VAL A 103      16.723  14.731  16.053  1.00  0.00           C  
ATOM   1482  O   VAL A 103      15.748  15.099  16.710  1.00  0.00           O  
ATOM   1483  CB  VAL A 103      17.878  16.940  15.918  1.00  0.00           C  
ATOM   1484  CG1 VAL A 103      16.670  17.788  16.284  1.00  0.00           C  
ATOM   1485  CG2 VAL A 103      18.649  16.530  17.165  1.00  0.00           C  
ATOM   1486  H   VAL A 103      15.646  16.212  14.131  1.00  0.00           H  
ATOM   1487  HA  VAL A 103      18.332  15.214  14.735  1.00  0.00           H  
ATOM   1488  HB  VAL A 103      18.532  17.534  15.296  1.00  0.00           H  
ATOM   1489 HG11 VAL A 103      16.748  18.751  15.803  1.00  0.00           H  
ATOM   1490 HG12 VAL A 103      15.769  17.291  15.956  1.00  0.00           H  
ATOM   1491 HG13 VAL A 103      16.636  17.924  17.355  1.00  0.00           H  
ATOM   1492 HG21 VAL A 103      18.713  17.370  17.840  1.00  0.00           H  
ATOM   1493 HG22 VAL A 103      18.136  15.714  17.654  1.00  0.00           H  
ATOM   1494 HG23 VAL A 103      19.643  16.214  16.886  1.00  0.00           H  
ATOM   1495  N   ARG A 104      17.207  13.496  16.107  1.00  0.00           N  
ATOM   1496  CA  ARG A 104      16.608  12.476  16.961  1.00  0.00           C  
ATOM   1497  C   ARG A 104      17.561  12.077  18.083  1.00  0.00           C  
ATOM   1498  O   ARG A 104      18.780  12.201  17.949  1.00  0.00           O  
ATOM   1499  CB  ARG A 104      16.231  11.246  16.134  1.00  0.00           C  
ATOM   1500  CG  ARG A 104      17.419  10.580  15.459  1.00  0.00           C  
ATOM   1501  CD  ARG A 104      17.014   9.904  14.158  1.00  0.00           C  
ATOM   1502  NE  ARG A 104      16.206   8.709  14.390  1.00  0.00           N  
ATOM   1503  CZ  ARG A 104      15.385   8.190  13.484  1.00  0.00           C  
ATOM   1504  NH1 ARG A 104      15.266   8.756  12.291  1.00  0.00           N  
ATOM   1505  NH2 ARG A 104      14.684   7.100  13.769  1.00  0.00           N  
ATOM   1506  H   ARG A 104      17.987  13.263  15.560  1.00  0.00           H  
ATOM   1507  HA  ARG A 104      15.712  12.894  17.396  1.00  0.00           H  
ATOM   1508  HB2 ARG A 104      15.761  10.522  16.782  1.00  0.00           H  
ATOM   1509  HB3 ARG A 104      15.530  11.542  15.369  1.00  0.00           H  
ATOM   1510  HG2 ARG A 104      18.167  11.328  15.245  1.00  0.00           H  
ATOM   1511  HG3 ARG A 104      17.831   9.837  16.127  1.00  0.00           H  
ATOM   1512  HD2 ARG A 104      16.442  10.604  13.568  1.00  0.00           H  
ATOM   1513  HD3 ARG A 104      17.907   9.625  13.620  1.00  0.00           H  
ATOM   1514  HE  ARG A 104      16.281   8.274  15.264  1.00  0.00           H  
ATOM   1515 HH11 ARG A 104      15.793   9.577  12.073  1.00  0.00           H  
ATOM   1516 HH12 ARG A 104      14.648   8.362  11.610  1.00  0.00           H  
ATOM   1517 HH21 ARG A 104      14.773   6.669  14.667  1.00  0.00           H  
ATOM   1518 HH22 ARG A 104      14.067   6.710  13.087  1.00  0.00           H  
ATOM   1519  N   ARG A 105      16.999  11.599  19.188  1.00  0.00           N  
ATOM   1520  CA  ARG A 105      17.799  11.183  20.333  1.00  0.00           C  
ATOM   1521  C   ARG A 105      18.735  10.038  19.957  1.00  0.00           C  
ATOM   1522  O   ARG A 105      18.300   9.015  19.427  1.00  0.00           O  
ATOM   1523  CB  ARG A 105      16.891  10.755  21.488  1.00  0.00           C  
ATOM   1524  CG  ARG A 105      17.594  10.721  22.835  1.00  0.00           C  
ATOM   1525  CD  ARG A 105      16.603  10.834  23.983  1.00  0.00           C  
ATOM   1526  NE  ARG A 105      15.967   9.554  24.285  1.00  0.00           N  
ATOM   1527  CZ  ARG A 105      15.446   9.254  25.468  1.00  0.00           C  
ATOM   1528  NH1 ARG A 105      15.483  10.137  26.457  1.00  0.00           N  
ATOM   1529  NH2 ARG A 105      14.883   8.068  25.666  1.00  0.00           N  
ATOM   1530  H   ARG A 105      16.023  11.524  19.235  1.00  0.00           H  
ATOM   1531  HA  ARG A 105      18.392  12.028  20.648  1.00  0.00           H  
ATOM   1532  HB2 ARG A 105      16.063  11.446  21.555  1.00  0.00           H  
ATOM   1533  HB3 ARG A 105      16.509   9.766  21.281  1.00  0.00           H  
ATOM   1534  HG2 ARG A 105      18.131   9.789  22.928  1.00  0.00           H  
ATOM   1535  HG3 ARG A 105      18.289  11.545  22.889  1.00  0.00           H  
ATOM   1536  HD2 ARG A 105      17.128  11.179  24.861  1.00  0.00           H  
ATOM   1537  HD3 ARG A 105      15.840  11.550  23.714  1.00  0.00           H  
ATOM   1538  HE  ARG A 105      15.928   8.887  23.569  1.00  0.00           H  
ATOM   1539 HH11 ARG A 105      15.906  11.031  26.311  1.00  0.00           H  
ATOM   1540 HH12 ARG A 105      15.089   9.908  27.347  1.00  0.00           H  
ATOM   1541 HH21 ARG A 105      14.852   7.399  24.924  1.00  0.00           H  
ATOM   1542 HH22 ARG A 105      14.491   7.843  26.558  1.00  0.00           H  
ATOM   1543  N   LYS A 106      20.022  10.217  20.232  1.00  0.00           N  
ATOM   1544  CA  LYS A 106      21.021   9.201  19.923  1.00  0.00           C  
ATOM   1545  C   LYS A 106      20.756   7.922  20.713  1.00  0.00           C  
ATOM   1546  O   LYS A 106      19.921   7.898  21.617  1.00  0.00           O  
ATOM   1547  CB  LYS A 106      22.424   9.724  20.234  1.00  0.00           C  
ATOM   1548  CG  LYS A 106      22.835  10.909  19.377  1.00  0.00           C  
ATOM   1549  CD  LYS A 106      23.917  11.735  20.051  1.00  0.00           C  
ATOM   1550  CE  LYS A 106      24.769  12.476  19.031  1.00  0.00           C  
ATOM   1551  NZ  LYS A 106      25.897  13.206  19.675  1.00  0.00           N  
ATOM   1552  H   LYS A 106      20.308  11.054  20.655  1.00  0.00           H  
ATOM   1553  HA  LYS A 106      20.953   8.979  18.869  1.00  0.00           H  
ATOM   1554  HB2 LYS A 106      22.462  10.025  21.270  1.00  0.00           H  
ATOM   1555  HB3 LYS A 106      23.136   8.927  20.073  1.00  0.00           H  
ATOM   1556  HG2 LYS A 106      23.210  10.546  18.432  1.00  0.00           H  
ATOM   1557  HG3 LYS A 106      21.970  11.535  19.207  1.00  0.00           H  
ATOM   1558  HD2 LYS A 106      23.454  12.457  20.707  1.00  0.00           H  
ATOM   1559  HD3 LYS A 106      24.553  11.078  20.628  1.00  0.00           H  
ATOM   1560  HE2 LYS A 106      25.169  11.761  18.328  1.00  0.00           H  
ATOM   1561  HE3 LYS A 106      24.145  13.184  18.507  1.00  0.00           H  
ATOM   1562  HZ1 LYS A 106      26.319  12.620  20.424  1.00  0.00           H  
ATOM   1563  HZ2 LYS A 106      25.553  14.093  20.095  1.00  0.00           H  
ATOM   1564  HZ3 LYS A 106      26.627  13.428  18.969  1.00  0.00           H  
ATOM   1565  N   THR A 107      21.476   6.859  20.367  1.00  0.00           N  
ATOM   1566  CA  THR A 107      21.321   5.577  21.043  1.00  0.00           C  
ATOM   1567  C   THR A 107      19.936   4.988  20.793  1.00  0.00           C  
ATOM   1568  O   THR A 107      19.275   4.517  21.718  1.00  0.00           O  
ATOM   1569  CB  THR A 107      21.541   5.713  22.561  1.00  0.00           C  
ATOM   1570  OG1 THR A 107      22.582   6.662  22.822  1.00  0.00           O  
ATOM   1571  CG2 THR A 107      21.909   4.370  23.176  1.00  0.00           C  
ATOM   1572  H   THR A 107      22.126   6.940  19.638  1.00  0.00           H  
ATOM   1573  HA  THR A 107      22.065   4.900  20.650  1.00  0.00           H  
ATOM   1574  HB  THR A 107      20.624   6.060  23.014  1.00  0.00           H  
ATOM   1575  HG1 THR A 107      22.434   7.070  23.678  1.00  0.00           H  
ATOM   1576 HG21 THR A 107      22.764   3.959  22.660  1.00  0.00           H  
ATOM   1577 HG22 THR A 107      21.073   3.692  23.084  1.00  0.00           H  
ATOM   1578 HG23 THR A 107      22.149   4.507  24.219  1.00  0.00           H  
ATOM   1579  N   SER A 108      19.504   5.019  19.536  1.00  0.00           N  
ATOM   1580  CA  SER A 108      18.196   4.491  19.166  1.00  0.00           C  
ATOM   1581  C   SER A 108      18.318   3.497  18.013  1.00  0.00           C  
ATOM   1582  O   SER A 108      19.404   3.282  17.478  1.00  0.00           O  
ATOM   1583  CB  SER A 108      17.254   5.631  18.773  1.00  0.00           C  
ATOM   1584  OG  SER A 108      15.899   5.256  18.949  1.00  0.00           O  
ATOM   1585  H   SER A 108      20.077   5.408  18.843  1.00  0.00           H  
ATOM   1586  HA  SER A 108      17.789   3.978  20.025  1.00  0.00           H  
ATOM   1587  HB2 SER A 108      17.460   6.492  19.391  1.00  0.00           H  
ATOM   1588  HB3 SER A 108      17.413   5.885  17.735  1.00  0.00           H  
ATOM   1589  HG  SER A 108      15.397   5.492  18.167  1.00  0.00           H  
ATOM   1590  N   SER A 109      17.194   2.896  17.637  1.00  0.00           N  
ATOM   1591  CA  SER A 109      17.174   1.922  16.552  1.00  0.00           C  
ATOM   1592  C   SER A 109      18.165   2.308  15.458  1.00  0.00           C  
ATOM   1593  O   SER A 109      18.879   1.460  14.924  1.00  0.00           O  
ATOM   1594  CB  SER A 109      15.766   1.811  15.964  1.00  0.00           C  
ATOM   1595  OG  SER A 109      15.350   3.044  15.401  1.00  0.00           O  
ATOM   1596  H   SER A 109      16.358   3.110  18.104  1.00  0.00           H  
ATOM   1597  HA  SER A 109      17.461   0.965  16.960  1.00  0.00           H  
ATOM   1598  HB2 SER A 109      15.758   1.057  15.192  1.00  0.00           H  
ATOM   1599  HB3 SER A 109      15.073   1.534  16.746  1.00  0.00           H  
ATOM   1600  HG  SER A 109      15.890   3.244  14.633  1.00  0.00           H  
ATOM   1601  N   SER A 110      18.202   3.596  15.130  1.00  0.00           N  
ATOM   1602  CA  SER A 110      19.103   4.096  14.097  1.00  0.00           C  
ATOM   1603  C   SER A 110      20.497   3.497  14.256  1.00  0.00           C  
ATOM   1604  O   SER A 110      20.812   2.889  15.279  1.00  0.00           O  
ATOM   1605  CB  SER A 110      19.181   5.622  14.155  1.00  0.00           C  
ATOM   1606  OG  SER A 110      18.097   6.215  13.461  1.00  0.00           O  
ATOM   1607  H   SER A 110      17.609   4.224  15.592  1.00  0.00           H  
ATOM   1608  HA  SER A 110      18.704   3.800  13.139  1.00  0.00           H  
ATOM   1609  HB2 SER A 110      19.153   5.943  15.185  1.00  0.00           H  
ATOM   1610  HB3 SER A 110      20.106   5.949  13.701  1.00  0.00           H  
ATOM   1611  HG  SER A 110      17.610   5.537  12.986  1.00  0.00           H  
ATOM   1612  N   THR A 111      21.330   3.674  13.234  1.00  0.00           N  
ATOM   1613  CA  THR A 111      22.689   3.150  13.258  1.00  0.00           C  
ATOM   1614  C   THR A 111      23.698   4.254  13.558  1.00  0.00           C  
ATOM   1615  O   THR A 111      23.480   5.416  13.217  1.00  0.00           O  
ATOM   1616  CB  THR A 111      23.059   2.484  11.919  1.00  0.00           C  
ATOM   1617  OG1 THR A 111      24.381   1.939  11.992  1.00  0.00           O  
ATOM   1618  CG2 THR A 111      22.979   3.484  10.777  1.00  0.00           C  
ATOM   1619  H   THR A 111      21.020   4.167  12.447  1.00  0.00           H  
ATOM   1620  HA  THR A 111      22.746   2.403  14.036  1.00  0.00           H  
ATOM   1621  HB  THR A 111      22.358   1.684  11.728  1.00  0.00           H  
ATOM   1622  HG1 THR A 111      24.338   1.033  12.305  1.00  0.00           H  
ATOM   1623 HG21 THR A 111      22.683   4.448  11.162  1.00  0.00           H  
ATOM   1624 HG22 THR A 111      22.252   3.147  10.053  1.00  0.00           H  
ATOM   1625 HG23 THR A 111      23.945   3.568  10.304  1.00  0.00           H  
ATOM   1626  N   SER A 112      24.802   3.882  14.199  1.00  0.00           N  
ATOM   1627  CA  SER A 112      25.843   4.842  14.548  1.00  0.00           C  
ATOM   1628  C   SER A 112      26.070   5.834  13.412  1.00  0.00           C  
ATOM   1629  O   SER A 112      25.861   5.531  12.237  1.00  0.00           O  
ATOM   1630  CB  SER A 112      27.149   4.114  14.872  1.00  0.00           C  
ATOM   1631  OG  SER A 112      26.966   3.182  15.924  1.00  0.00           O  
ATOM   1632  H   SER A 112      24.917   2.940  14.444  1.00  0.00           H  
ATOM   1633  HA  SER A 112      25.515   5.383  15.423  1.00  0.00           H  
ATOM   1634  HB2 SER A 112      27.491   3.587  13.995  1.00  0.00           H  
ATOM   1635  HB3 SER A 112      27.894   4.836  15.173  1.00  0.00           H  
ATOM   1636  HG  SER A 112      26.038   2.939  15.978  1.00  0.00           H  
ATOM   1637  N   PRO A 113      26.507   7.051  13.768  1.00  0.00           N  
ATOM   1638  CA  PRO A 113      26.773   8.114  12.794  1.00  0.00           C  
ATOM   1639  C   PRO A 113      27.996   7.819  11.933  1.00  0.00           C  
ATOM   1640  O   PRO A 113      28.505   6.698  11.924  1.00  0.00           O  
ATOM   1641  CB  PRO A 113      27.019   9.345  13.671  1.00  0.00           C  
ATOM   1642  CG  PRO A 113      27.491   8.795  14.973  1.00  0.00           C  
ATOM   1643  CD  PRO A 113      26.777   7.483  15.150  1.00  0.00           C  
ATOM   1644  HA  PRO A 113      25.918   8.290  12.157  1.00  0.00           H  
ATOM   1645  HB2 PRO A 113      27.770   9.972  13.211  1.00  0.00           H  
ATOM   1646  HB3 PRO A 113      26.100   9.900  13.787  1.00  0.00           H  
ATOM   1647  HG2 PRO A 113      28.558   8.639  14.940  1.00  0.00           H  
ATOM   1648  HG3 PRO A 113      27.232   9.473  15.772  1.00  0.00           H  
ATOM   1649  HD2 PRO A 113      27.413   6.773  15.659  1.00  0.00           H  
ATOM   1650  HD3 PRO A 113      25.856   7.626  15.696  1.00  0.00           H  
ATOM   1651  N   LEU A 114      28.463   8.832  11.211  1.00  0.00           N  
ATOM   1652  CA  LEU A 114      29.628   8.681  10.346  1.00  0.00           C  
ATOM   1653  C   LEU A 114      30.896   9.151  11.053  1.00  0.00           C  
ATOM   1654  O   LEU A 114      31.853   8.393  11.200  1.00  0.00           O  
ATOM   1655  CB  LEU A 114      29.432   9.469   9.050  1.00  0.00           C  
ATOM   1656  CG  LEU A 114      28.152   9.168   8.269  1.00  0.00           C  
ATOM   1657  CD1 LEU A 114      27.954  10.183   7.154  1.00  0.00           C  
ATOM   1658  CD2 LEU A 114      28.192   7.755   7.705  1.00  0.00           C  
ATOM   1659  H   LEU A 114      28.015   9.701  11.260  1.00  0.00           H  
ATOM   1660  HA  LEU A 114      29.731   7.633  10.109  1.00  0.00           H  
ATOM   1661  HB2 LEU A 114      29.426  10.519   9.299  1.00  0.00           H  
ATOM   1662  HB3 LEU A 114      30.272   9.258   8.404  1.00  0.00           H  
ATOM   1663  HG  LEU A 114      27.305   9.238   8.938  1.00  0.00           H  
ATOM   1664 HD11 LEU A 114      28.590   9.928   6.319  1.00  0.00           H  
ATOM   1665 HD12 LEU A 114      28.212  11.168   7.516  1.00  0.00           H  
ATOM   1666 HD13 LEU A 114      26.922  10.174   6.838  1.00  0.00           H  
ATOM   1667 HD21 LEU A 114      27.605   7.712   6.799  1.00  0.00           H  
ATOM   1668 HD22 LEU A 114      27.783   7.065   8.431  1.00  0.00           H  
ATOM   1669 HD23 LEU A 114      29.214   7.484   7.486  1.00  0.00           H  
ATOM   1670  N   GLU A 115      30.892  10.407  11.490  1.00  0.00           N  
ATOM   1671  CA  GLU A 115      32.041  10.977  12.183  1.00  0.00           C  
ATOM   1672  C   GLU A 115      31.606  11.705  13.451  1.00  0.00           C  
ATOM   1673  O   GLU A 115      31.605  12.935  13.523  1.00  0.00           O  
ATOM   1674  CB  GLU A 115      32.794  11.940  11.262  1.00  0.00           C  
ATOM   1675  CG  GLU A 115      34.014  12.573  11.909  1.00  0.00           C  
ATOM   1676  CD  GLU A 115      35.269  11.740  11.728  1.00  0.00           C  
ATOM   1677  OE1 GLU A 115      35.874  11.805  10.638  1.00  0.00           O  
ATOM   1678  OE2 GLU A 115      35.646  11.022  12.679  1.00  0.00           O  
ATOM   1679  H   GLU A 115      30.099  10.963  11.342  1.00  0.00           H  
ATOM   1680  HA  GLU A 115      32.700  10.166  12.456  1.00  0.00           H  
ATOM   1681  HB2 GLU A 115      33.116  11.401  10.383  1.00  0.00           H  
ATOM   1682  HB3 GLU A 115      32.122  12.730  10.961  1.00  0.00           H  
ATOM   1683  HG2 GLU A 115      34.179  13.544  11.466  1.00  0.00           H  
ATOM   1684  HG3 GLU A 115      33.826  12.689  12.966  1.00  0.00           H  
ATOM   1685  N   PRO A 116      31.226  10.929  14.477  1.00  0.00           N  
ATOM   1686  CA  PRO A 116      30.781  11.479  15.762  1.00  0.00           C  
ATOM   1687  C   PRO A 116      31.921  12.122  16.543  1.00  0.00           C  
ATOM   1688  O   PRO A 116      33.076  11.702  16.463  1.00  0.00           O  
ATOM   1689  CB  PRO A 116      30.250  10.251  16.506  1.00  0.00           C  
ATOM   1690  CG  PRO A 116      30.977   9.098  15.905  1.00  0.00           C  
ATOM   1691  CD  PRO A 116      31.203   9.457  14.463  1.00  0.00           C  
ATOM   1692  HA  PRO A 116      29.985  12.196  15.633  1.00  0.00           H  
ATOM   1693  HB2 PRO A 116      30.461  10.347  17.562  1.00  0.00           H  
ATOM   1694  HB3 PRO A 116      29.183  10.167  16.354  1.00  0.00           H  
ATOM   1695  HG2 PRO A 116      31.921   8.957  16.408  1.00  0.00           H  
ATOM   1696  HG3 PRO A 116      30.375   8.206  15.979  1.00  0.00           H  
ATOM   1697  HD2 PRO A 116      32.145   9.059  14.118  1.00  0.00           H  
ATOM   1698  HD3 PRO A 116      30.390   9.092  13.852  1.00  0.00           H  
ATOM   1699  N   PRO A 117      31.593  13.167  17.318  1.00  0.00           N  
ATOM   1700  CA  PRO A 117      32.575  13.890  18.130  1.00  0.00           C  
ATOM   1701  C   PRO A 117      33.087  13.057  19.300  1.00  0.00           C  
ATOM   1702  O   PRO A 117      32.504  12.029  19.643  1.00  0.00           O  
ATOM   1703  CB  PRO A 117      31.792  15.103  18.638  1.00  0.00           C  
ATOM   1704  CG  PRO A 117      30.368  14.666  18.623  1.00  0.00           C  
ATOM   1705  CD  PRO A 117      30.236  13.721  17.462  1.00  0.00           C  
ATOM   1706  HA  PRO A 117      33.413  14.225  17.535  1.00  0.00           H  
ATOM   1707  HB2 PRO A 117      32.119  15.353  19.637  1.00  0.00           H  
ATOM   1708  HB3 PRO A 117      31.954  15.943  17.979  1.00  0.00           H  
ATOM   1709  HG2 PRO A 117      30.128  14.163  19.547  1.00  0.00           H  
ATOM   1710  HG3 PRO A 117      29.724  15.522  18.484  1.00  0.00           H  
ATOM   1711  HD2 PRO A 117      29.523  12.942  17.688  1.00  0.00           H  
ATOM   1712  HD3 PRO A 117      29.943  14.257  16.570  1.00  0.00           H  
ATOM   1713  N   SER A 118      34.178  13.509  19.910  1.00  0.00           N  
ATOM   1714  CA  SER A 118      34.769  12.803  21.041  1.00  0.00           C  
ATOM   1715  C   SER A 118      35.002  13.752  22.213  1.00  0.00           C  
ATOM   1716  O   SER A 118      35.399  14.902  22.024  1.00  0.00           O  
ATOM   1717  CB  SER A 118      36.090  12.150  20.628  1.00  0.00           C  
ATOM   1718  OG  SER A 118      35.872  10.864  20.075  1.00  0.00           O  
ATOM   1719  H   SER A 118      34.596  14.335  19.590  1.00  0.00           H  
ATOM   1720  HA  SER A 118      34.078  12.032  21.349  1.00  0.00           H  
ATOM   1721  HB2 SER A 118      36.578  12.769  19.891  1.00  0.00           H  
ATOM   1722  HB3 SER A 118      36.727  12.054  21.496  1.00  0.00           H  
ATOM   1723  HG  SER A 118      34.990  10.564  20.300  1.00  0.00           H  
ATOM   1724  N   ASP A 119      34.751  13.262  23.421  1.00  0.00           N  
ATOM   1725  CA  ASP A 119      34.933  14.065  24.625  1.00  0.00           C  
ATOM   1726  C   ASP A 119      36.374  13.981  25.121  1.00  0.00           C  
ATOM   1727  O   ASP A 119      36.680  13.226  26.044  1.00  0.00           O  
ATOM   1728  CB  ASP A 119      33.975  13.601  25.723  1.00  0.00           C  
ATOM   1729  CG  ASP A 119      32.520  13.768  25.331  1.00  0.00           C  
ATOM   1730  OD1 ASP A 119      32.104  14.917  25.070  1.00  0.00           O  
ATOM   1731  OD2 ASP A 119      31.799  12.750  25.284  1.00  0.00           O  
ATOM   1732  H   ASP A 119      34.435  12.337  23.506  1.00  0.00           H  
ATOM   1733  HA  ASP A 119      34.710  15.091  24.376  1.00  0.00           H  
ATOM   1734  HB2 ASP A 119      34.155  12.556  25.932  1.00  0.00           H  
ATOM   1735  HB3 ASP A 119      34.157  14.178  26.618  1.00  0.00           H  
ATOM   1736  N   ARG A 120      37.253  14.761  24.501  1.00  0.00           N  
ATOM   1737  CA  ARG A 120      38.662  14.774  24.877  1.00  0.00           C  
ATOM   1738  C   ARG A 120      38.869  15.537  26.184  1.00  0.00           C  
ATOM   1739  O   ARG A 120      38.189  16.527  26.450  1.00  0.00           O  
ATOM   1740  CB  ARG A 120      39.503  15.405  23.767  1.00  0.00           C  
ATOM   1741  CG  ARG A 120      39.371  16.917  23.688  1.00  0.00           C  
ATOM   1742  CD  ARG A 120      38.141  17.328  22.894  1.00  0.00           C  
ATOM   1743  NE  ARG A 120      38.275  18.669  22.332  1.00  0.00           N  
ATOM   1744  CZ  ARG A 120      37.592  19.096  21.275  1.00  0.00           C  
ATOM   1745  NH1 ARG A 120      36.732  18.289  20.668  1.00  0.00           N  
ATOM   1746  NH2 ARG A 120      37.769  20.330  20.823  1.00  0.00           N  
ATOM   1747  H   ARG A 120      36.949  15.342  23.773  1.00  0.00           H  
ATOM   1748  HA  ARG A 120      38.977  13.751  25.019  1.00  0.00           H  
ATOM   1749  HB2 ARG A 120      40.542  15.166  23.938  1.00  0.00           H  
ATOM   1750  HB3 ARG A 120      39.197  14.989  22.819  1.00  0.00           H  
ATOM   1751  HG2 ARG A 120      39.290  17.315  24.688  1.00  0.00           H  
ATOM   1752  HG3 ARG A 120      40.251  17.321  23.207  1.00  0.00           H  
ATOM   1753  HD2 ARG A 120      37.997  16.624  22.088  1.00  0.00           H  
ATOM   1754  HD3 ARG A 120      37.283  17.306  23.548  1.00  0.00           H  
ATOM   1755  HE  ARG A 120      38.905  19.282  22.765  1.00  0.00           H  
ATOM   1756 HH11 ARG A 120      36.596  17.358  21.007  1.00  0.00           H  
ATOM   1757 HH12 ARG A 120      36.218  18.613  19.874  1.00  0.00           H  
ATOM   1758 HH21 ARG A 120      38.417  20.941  21.278  1.00  0.00           H  
ATOM   1759 HH22 ARG A 120      37.255  20.650  20.028  1.00  0.00           H  
ATOM   1760  N   GLY A 121      39.814  15.068  26.993  1.00  0.00           N  
ATOM   1761  CA  GLY A 121      40.092  15.717  28.260  1.00  0.00           C  
ATOM   1762  C   GLY A 121      41.196  16.750  28.153  1.00  0.00           C  
ATOM   1763  O   GLY A 121      42.121  16.770  28.965  1.00  0.00           O  
ATOM   1764  H   GLY A 121      40.325  14.275  26.728  1.00  0.00           H  
ATOM   1765  HA2 GLY A 121      39.193  16.202  28.610  1.00  0.00           H  
ATOM   1766  HA3 GLY A 121      40.388  14.966  28.979  1.00  0.00           H  
ATOM   1767  N   THR A 122      41.102  17.612  27.143  1.00  0.00           N  
ATOM   1768  CA  THR A 122      42.102  18.650  26.929  1.00  0.00           C  
ATOM   1769  C   THR A 122      43.491  18.166  27.329  1.00  0.00           C  
ATOM   1770  O   THR A 122      44.277  18.916  27.909  1.00  0.00           O  
ATOM   1771  CB  THR A 122      41.766  19.926  27.725  1.00  0.00           C  
ATOM   1772  OG1 THR A 122      42.703  20.962  27.409  1.00  0.00           O  
ATOM   1773  CG2 THR A 122      41.789  19.652  29.222  1.00  0.00           C  
ATOM   1774  H   THR A 122      40.342  17.544  26.530  1.00  0.00           H  
ATOM   1775  HA  THR A 122      42.106  18.898  25.878  1.00  0.00           H  
ATOM   1776  HB  THR A 122      40.773  20.253  27.449  1.00  0.00           H  
ATOM   1777  HG1 THR A 122      42.393  21.795  27.771  1.00  0.00           H  
ATOM   1778 HG21 THR A 122      41.993  20.571  29.752  1.00  0.00           H  
ATOM   1779 HG22 THR A 122      42.560  18.930  29.444  1.00  0.00           H  
ATOM   1780 HG23 THR A 122      40.831  19.263  29.530  1.00  0.00           H  
ATOM   1781  N   VAL A 123      43.789  16.910  27.016  1.00  0.00           N  
ATOM   1782  CA  VAL A 123      45.085  16.327  27.341  1.00  0.00           C  
ATOM   1783  C   VAL A 123      46.095  16.577  26.226  1.00  0.00           C  
ATOM   1784  O   VAL A 123      45.746  16.566  25.045  1.00  0.00           O  
ATOM   1785  CB  VAL A 123      44.973  14.811  27.587  1.00  0.00           C  
ATOM   1786  CG1 VAL A 123      44.304  14.125  26.405  1.00  0.00           C  
ATOM   1787  CG2 VAL A 123      46.345  14.212  27.855  1.00  0.00           C  
ATOM   1788  H   VAL A 123      43.121  16.361  26.553  1.00  0.00           H  
ATOM   1789  HA  VAL A 123      45.442  16.792  28.248  1.00  0.00           H  
ATOM   1790  HB  VAL A 123      44.358  14.653  28.462  1.00  0.00           H  
ATOM   1791 HG11 VAL A 123      44.443  13.057  26.484  1.00  0.00           H  
ATOM   1792 HG12 VAL A 123      43.248  14.354  26.406  1.00  0.00           H  
ATOM   1793 HG13 VAL A 123      44.748  14.479  25.486  1.00  0.00           H  
ATOM   1794 HG21 VAL A 123      46.245  13.152  28.037  1.00  0.00           H  
ATOM   1795 HG22 VAL A 123      46.981  14.371  26.996  1.00  0.00           H  
ATOM   1796 HG23 VAL A 123      46.784  14.687  28.720  1.00  0.00           H  
ATOM   1797  N   SER A 124      47.348  16.799  26.610  1.00  0.00           N  
ATOM   1798  CA  SER A 124      48.409  17.054  25.642  1.00  0.00           C  
ATOM   1799  C   SER A 124      49.133  15.762  25.278  1.00  0.00           C  
ATOM   1800  O   SER A 124      50.361  15.728  25.193  1.00  0.00           O  
ATOM   1801  CB  SER A 124      49.405  18.071  26.203  1.00  0.00           C  
ATOM   1802  OG  SER A 124      50.095  17.544  27.322  1.00  0.00           O  
ATOM   1803  H   SER A 124      47.563  16.794  27.566  1.00  0.00           H  
ATOM   1804  HA  SER A 124      47.955  17.462  24.752  1.00  0.00           H  
ATOM   1805  HB2 SER A 124      50.124  18.325  25.439  1.00  0.00           H  
ATOM   1806  HB3 SER A 124      48.874  18.961  26.508  1.00  0.00           H  
ATOM   1807  HG  SER A 124      49.575  16.840  27.719  1.00  0.00           H  
ATOM   1808  N   GLY A 125      48.364  14.699  25.062  1.00  0.00           N  
ATOM   1809  CA  GLY A 125      48.949  13.419  24.709  1.00  0.00           C  
ATOM   1810  C   GLY A 125      49.255  12.567  25.925  1.00  0.00           C  
ATOM   1811  O   GLY A 125      48.793  12.839  27.033  1.00  0.00           O  
ATOM   1812  H   GLY A 125      47.391  14.786  25.144  1.00  0.00           H  
ATOM   1813  HA2 GLY A 125      48.260  12.885  24.072  1.00  0.00           H  
ATOM   1814  HA3 GLY A 125      49.866  13.593  24.166  1.00  0.00           H  
ATOM   1815  N   PRO A 126      50.052  11.507  25.723  1.00  0.00           N  
ATOM   1816  CA  PRO A 126      50.437  10.589  26.800  1.00  0.00           C  
ATOM   1817  C   PRO A 126      51.387  11.237  27.802  1.00  0.00           C  
ATOM   1818  O   PRO A 126      51.826  10.598  28.757  1.00  0.00           O  
ATOM   1819  CB  PRO A 126      51.136   9.447  26.061  1.00  0.00           C  
ATOM   1820  CG  PRO A 126      51.640  10.064  24.801  1.00  0.00           C  
ATOM   1821  CD  PRO A 126      50.640  11.122  24.429  1.00  0.00           C  
ATOM   1822  HA  PRO A 126      49.572  10.207  27.323  1.00  0.00           H  
ATOM   1823  HB2 PRO A 126      51.947   9.065  26.667  1.00  0.00           H  
ATOM   1824  HB3 PRO A 126      50.429   8.658  25.857  1.00  0.00           H  
ATOM   1825  HG2 PRO A 126      52.609  10.507  24.973  1.00  0.00           H  
ATOM   1826  HG3 PRO A 126      51.700   9.315  24.025  1.00  0.00           H  
ATOM   1827  HD2 PRO A 126      51.134  11.962  23.965  1.00  0.00           H  
ATOM   1828  HD3 PRO A 126      49.886  10.714  23.771  1.00  0.00           H  
ATOM   1829  N   SER A 127      51.699  12.509  27.577  1.00  0.00           N  
ATOM   1830  CA  SER A 127      52.601  13.242  28.458  1.00  0.00           C  
ATOM   1831  C   SER A 127      52.163  13.112  29.914  1.00  0.00           C  
ATOM   1832  O   SER A 127      52.960  13.299  30.833  1.00  0.00           O  
ATOM   1833  CB  SER A 127      52.650  14.719  28.059  1.00  0.00           C  
ATOM   1834  OG  SER A 127      51.344  15.247  27.897  1.00  0.00           O  
ATOM   1835  H   SER A 127      51.316  12.965  26.798  1.00  0.00           H  
ATOM   1836  HA  SER A 127      53.587  12.816  28.352  1.00  0.00           H  
ATOM   1837  HB2 SER A 127      53.159  15.280  28.827  1.00  0.00           H  
ATOM   1838  HB3 SER A 127      53.185  14.819  27.126  1.00  0.00           H  
ATOM   1839  HG  SER A 127      50.720  14.527  27.780  1.00  0.00           H  
ATOM   1840  N   SER A 128      50.889  12.790  30.115  1.00  0.00           N  
ATOM   1841  CA  SER A 128      50.342  12.638  31.459  1.00  0.00           C  
ATOM   1842  C   SER A 128      49.336  11.493  31.509  1.00  0.00           C  
ATOM   1843  O   SER A 128      48.850  11.033  30.476  1.00  0.00           O  
ATOM   1844  CB  SER A 128      49.676  13.939  31.911  1.00  0.00           C  
ATOM   1845  OG  SER A 128      49.277  13.862  33.269  1.00  0.00           O  
ATOM   1846  H   SER A 128      50.302  12.654  29.342  1.00  0.00           H  
ATOM   1847  HA  SER A 128      51.161  12.412  32.126  1.00  0.00           H  
ATOM   1848  HB2 SER A 128      50.372  14.755  31.798  1.00  0.00           H  
ATOM   1849  HB3 SER A 128      48.802  14.123  31.301  1.00  0.00           H  
ATOM   1850  HG  SER A 128      49.128  14.747  33.609  1.00  0.00           H  
ATOM   1851  N   GLY A 129      49.028  11.036  32.719  1.00  0.00           N  
ATOM   1852  CA  GLY A 129      48.081   9.949  32.883  1.00  0.00           C  
ATOM   1853  C   GLY A 129      48.159   8.937  31.757  1.00  0.00           C  
ATOM   1854  O   GLY A 129      47.146   8.601  31.144  1.00  0.00           O  
ATOM   1855  H   GLY A 129      49.447  11.442  33.507  1.00  0.00           H  
ATOM   1856  HA2 GLY A 129      48.284   9.447  33.818  1.00  0.00           H  
ATOM   1857  HA3 GLY A 129      47.082  10.358  32.915  1.00  0.00           H  
TER    1858      GLY A 129                                                      
END
MOLECULE T0488.pdb
ATOM      1  N   SER     1      20.128  12.809  24.526  1.00 19.40           N
ATOM      2  CA  SER     1      20.938  12.899  23.283  1.00 14.62           C
ATOM      4  CB  SER     1      21.786  11.646  23.101  1.00 17.49           C
ATOM      7  OG  SER     1      20.984  10.481  22.955  1.00 25.56           O
ATOM      9  C   SER     1      20.052  13.074  22.065  1.00 13.47           C
ATOM     10  O   SER     1      18.834  12.879  22.117  1.00 15.69           O
ATOM     14  N   MET     2      20.684  13.412  20.957  1.00 10.92           N
ATOM     15  CA  MET     2      20.000  13.465  19.689  1.00  9.70           C
ATOM     17  CB  MET     2      19.319  14.815  19.493  1.00 12.91           C
ATOM     20  CG  MET     2      20.286  15.963  19.402  1.00 15.71           C
ATOM     23  SD  MET     2      19.467  17.568  19.366  1.00 19.52           S
ATOM     24  CE  MET     2      18.819  17.665  21.032  1.00 31.08           C
ATOM     28  C   MET     2      20.956  13.195  18.552  1.00  9.06           C
ATOM     29  O   MET     2      22.158  13.370  18.682  1.00 13.20           O
ATOM     31  N   GLU     3      20.384  12.759  17.442  1.00  7.47           N
ATOM     32  CA  GLU     3      21.090  12.632  16.203  1.00  7.61           C
ATOM     34  CB  GLU     3      20.756  11.297  15.535  1.00  9.77           C
ATOM     37  CG  GLU     3      21.552  11.077  14.264  1.00 14.79           C
ATOM     40  CD  GLU     3      21.122   9.855  13.502  1.00 26.53           C
ATOM     41  OE1 GLU     3      20.303   9.074  14.028  1.00 31.96           O
ATOM     42  OE2 GLU     3      21.613   9.684  12.363  1.00 32.73           O
ATOM     43  C   GLU     3      20.689  13.781  15.297  1.00  8.80           C
ATOM     44  O   GLU     3      19.509  14.082  15.173  1.00 10.63           O
ATOM     46  N   ILE     4      21.679  14.418  14.693  1.00  7.18           N
ATOM     47  CA  ILE     4      21.451  15.424  13.665  1.00  7.38           C
ATOM     49  CB  ILE     4      22.306  16.675  13.857  1.00  9.41           C
ATOM     51  CG1 ILE     4      22.197  17.198  15.271  1.00 12.88           C
ATOM     54  CD1 ILE     4      20.874  17.635  15.639  1.00 14.81           C
ATOM     58  CG2 ILE     4      21.949  17.745  12.806  1.00 11.50           C
ATOM     62  C   ILE     4      21.801  14.808  12.341  1.00  7.35           C
ATOM     63  O   ILE     4      22.895  14.249  12.178  1.00  9.86           O
ATOM     65  N   LEU     5      20.875  14.902  11.402  1.00  7.58           N
ATOM     66  CA  LEU     5      21.132  14.378  10.062  1.00  8.65           C
ATOM     68  CB  LEU     5      20.731  12.925   9.943  1.00 13.90           C
ATOM     71  CG  LEU     5      19.252  12.666  10.057  1.00 13.10           C
ATOM     73  CD1 LEU     5      18.882  11.388   9.287  1.00 20.34           C
ATOM     77  CD2 LEU     5      18.772  12.562  11.493  1.00 19.29           C
ATOM     81  C   LEU     5      20.456  15.222   8.993  1.00  7.20           C
ATOM     82  O   LEU     5      19.584  16.031   9.280  1.00  8.46           O
ATOM     84  N   GLN     6      20.928  15.069   7.768  1.00  7.20           N
ATOM     85  CA  GLN     6      20.395  15.791   6.642  1.00  7.97           C
ATOM     87  CB  GLN     6      21.472  16.631   5.956  1.00 11.22           C
ATOM     90  CG  GLN     6      22.010  17.704   6.886  1.00 17.34           C
ATOM     93  CD  GLN     6      22.853  18.757   6.211  1.00 25.58           C
ATOM     94  OE1 GLN     6      22.673  19.078   5.034  1.00 22.54           O
ATOM     95  NE2 GLN     6      23.778  19.328   6.973  1.00 35.80           N
ATOM     98  C   GLN     6      19.774  14.804   5.678  1.00  8.78           C
ATOM     99  O   GLN     6      20.362  13.773   5.376  1.00 12.62           O
ATOM    101  N   VAL     7      18.567  15.128   5.237  1.00  6.69           N
ATOM    102  CA  VAL     7      17.825  14.314   4.312  1.00  6.49           C
ATOM    104  CB  VAL     7      16.555  13.757   4.961  1.00  7.24           C
ATOM    106  CG1 VAL     7      15.691  13.030   3.954  1.00  9.62           C
ATOM    110  CG2 VAL     7      16.911  12.821   6.122  1.00  9.31           C
ATOM    114  C   VAL     7      17.450  15.146   3.110  1.00  6.92           C
ATOM    115  O   VAL     7      16.765  16.128   3.242  1.00  9.54           O
ATOM    117  N   ALA     8      17.874  14.713   1.934  1.00  7.20           N
ATOM    118  CA  ALA     8      17.555  15.401   0.689  1.00  8.32           C
ATOM    120  CB  ALA     8      18.823  15.574  -0.152  1.00 12.50           C
ATOM    124  C   ALA     8      16.514  14.615  -0.079  1.00  7.94           C
ATOM    125  O   ALA     8      16.711  13.451  -0.375  1.00 12.11           O
ATOM    127  N   LEU     9      15.396  15.253  -0.365  1.00  7.05           N
ATOM    128  CA  LEU     9      14.331  14.704  -1.186  1.00  7.53           C
ATOM    130  CB  LEU     9      12.989  14.824  -0.479  1.00  7.05           C
ATOM    133  CG  LEU     9      12.915  14.175   0.902  1.00  6.94           C
ATOM    135  CD1 LEU     9      11.557  14.422   1.532  1.00 10.28           C
ATOM    139  CD2 LEU     9      13.241  12.665   0.874  1.00  9.01           C
ATOM    143  C   LEU     9      14.296  15.466  -2.509  1.00  6.69           C
ATOM    144  O   LEU     9      14.683  16.629  -2.573  1.00  9.96           O
ATOM    146  N   HIS    10      13.820  14.806  -3.557  1.00  7.45           N
ATOM    147  CA  HIS    10      13.788  15.443  -4.867  1.00  8.58           C
ATOM    149  CB  HIS    10      14.817  14.786  -5.773  1.00 10.46           C
ATOM    152  CG  HIS    10      16.223  15.001  -5.303  1.00 12.40           C
ATOM    153  ND1 HIS    10      16.996  16.053  -5.741  1.00 16.70           N
ATOM    155  CE1 HIS    10      18.175  16.010  -5.143  1.00 18.81           C
ATOM    157  NE2 HIS    10      18.179  14.989  -4.305  1.00 19.15           N
ATOM    159  CD2 HIS    10      16.965  14.349  -4.376  1.00 19.64           C
ATOM    161  C   HIS    10      12.402  15.443  -5.494  1.00  7.84           C
ATOM    162  O   HIS    10      11.834  14.379  -5.778  1.00 11.03           O
ATOM    164  N   LYS    11      11.837  16.643  -5.638  1.00  9.81           N
ATOM    165  CA  LYS    11      10.512  16.790  -6.253  1.00 10.04           C
ATOM    167  CB  LYS    11       9.985  18.217  -6.073  1.00 12.34           C
ATOM    170  CG  LYS    11       9.686  18.625  -4.623  1.00 12.62           C
ATOM    173  CD  LYS    11       8.576  19.704  -4.546  1.00 31.05           C
ATOM    176  CE  LYS    11       8.996  21.073  -5.051  1.00 24.45           C
ATOM    179  NZ  LYS    11       8.322  22.218  -4.361  1.00 21.96           N
ATOM    183  C   LYS    11      10.588  16.474  -7.733  1.00 12.69           C
ATOM    184  O   LYS    11      11.432  17.042  -8.419  1.00 14.69           O
ATOM    186  N   ARG    12       9.704  15.604  -8.215  1.00 13.65           N
ATOM    187  CA  ARG    12       9.688  15.217  -9.636  1.00 17.02           C
ATOM    189  CB  ARG    12       9.080  13.819  -9.812  1.00 18.82           C
ATOM    192  CG  ARG    12       9.882  12.720  -9.103  1.00 23.83           C
ATOM    195  CD  ARG    12      10.108  11.497  -9.984  1.00 35.96           C
ATOM    198  NE  ARG    12      10.943  10.483  -9.336  1.00 41.80           N
ATOM    200  CZ  ARG    12      11.421   9.393  -9.940  1.00 38.74           C
ATOM    201  NH1 ARG    12      11.158   9.156 -11.222  1.00 41.88           N
ATOM    204  NH2 ARG    12      12.172   8.530  -9.257  1.00 33.93           N
ATOM    207  C   ARG    12       8.948  16.257 -10.475  1.00 17.99           C
ATOM    208  O   ARG    12       9.156  16.335 -11.696  1.00 22.78           O
ATOM    210  N   ASP    13       8.081  17.035  -9.822  1.00 16.60           N
ATOM    211  CA  ASP    13       7.475  18.241 -10.404  1.00 17.38           C
ATOM    213  CB  ASP    13       6.064  17.959 -10.970  1.00 19.09           C
ATOM    216  CG  ASP    13       5.028  17.642  -9.898  1.00 19.81           C
ATOM    217  OD1 ASP    13       4.382  18.582  -9.384  1.00 22.06           O
ATOM    218  OD2 ASP    13       4.810  16.436  -9.621  1.00 23.43           O
ATOM    219  C   ASP    13       7.449  19.320  -9.327  1.00 14.18           C
ATOM    220  O   ASP    13       7.531  19.010  -8.142  1.00 14.00           O
ATOM    222  N   SER    14       7.329  20.578  -9.725  1.00 13.19           N
ATOM    223  CA  SER    14       7.384  21.702  -8.783  1.00 13.78           C
ATOM    225  CB  SER    14       7.433  23.044  -9.519  1.00 14.22           C
ATOM    228  OG  SER    14       6.243  23.269 -10.244  1.00 16.20           O
ATOM    230  C   SER    14       6.252  21.710  -7.764  1.00 11.76           C
ATOM    231  O   SER    14       6.341  22.373  -6.725  1.00 14.54           O
ATOM    233  N   GLY    15       5.172  20.998  -8.084  1.00 11.38           N
ATOM    234  CA  GLY    15       4.049  20.871  -7.180  1.00 10.63           C
ATOM    237  C   GLY    15       3.987  19.585  -6.383  1.00 10.54           C
ATOM    238  O   GLY    15       2.994  19.372  -5.694  1.00 11.58           O
ATOM    240  N   GLU    16       5.011  18.735  -6.462  1.00 10.14           N
ATOM    241  CA  GLU    16       4.979  17.475  -5.723  1.00 10.90           C
ATOM    243  CB  GLU    16       6.077  16.500  -6.154  1.00 11.37           C
ATOM    246  CG  GLU    16       5.878  15.118  -5.509  1.00 13.41           C
ATOM    249  CD  GLU    16       6.796  14.031  -6.016  1.00 14.39           C
ATOM    250  OE1 GLU    16       7.821  14.327  -6.657  1.00 17.24           O
ATOM    251  OE2 GLU    16       6.498  12.847  -5.728  1.00 19.88           O
ATOM    252  C   GLU    16       5.094  17.732  -4.229  1.00 11.70           C
ATOM    253  O   GLU    16       5.900  18.539  -3.792  1.00 12.51           O
ATOM    255  N   GLN    17       4.285  17.037  -3.431  1.00 13.12           N
ATOM    256  CA  GLN    17       4.419  17.166  -1.988  1.00 13.43           C
ATOM    258  CB  GLN    17       3.109  16.888  -1.274  1.00 17.00           C
ATOM    261  CG  GLN    17       2.086  17.994  -1.457  0.50 13.19           C
ATOM    264  CD  GLN    17       0.701  17.540  -1.069  0.50 12.56           C
ATOM    265  OE1 GLN    17       0.216  16.501  -1.557  0.50 18.97           O
ATOM    266  NE2 GLN    17       0.049  18.301  -0.192  0.50 15.21           N
ATOM    269  C   GLN    17       5.510  16.223  -1.502  1.00  9.97           C
ATOM    270  O   GLN    17       5.923  15.294  -2.196  1.00 11.21           O
ATOM    272  N   LEU    18       5.980  16.475  -0.298  1.00  9.09           N
ATOM    273  CA  LEU    18       7.002  15.642   0.309  1.00  7.79           C
ATOM    275  CB  LEU    18       7.785  16.430   1.341  1.00 10.03           C
ATOM    278  CG  LEU    18       8.464  17.680   0.774  1.00 13.65           C
ATOM    280  CD1 LEU    18       9.327  18.337   1.851  1.00 16.68           C
ATOM    284  CD2 LEU    18       9.285  17.333  -0.465  1.00 14.79           C
ATOM    288  C   LEU    18       6.406  14.423   0.970  1.00  6.95           C
ATOM    289  O   LEU    18       7.112  13.436   1.174  1.00  7.83           O
ATOM    291  N   GLY    19       5.127  14.475   1.336  1.00  6.45           N
ATOM    292  CA  GLY    19       4.529  13.361   2.072  1.00  5.80           C
ATOM    295  C   GLY    19       4.856  13.345   3.551  1.00  5.53           C
ATOM    296  O   GLY    19       5.144  12.296   4.119  1.00  6.57           O
ATOM    298  N   ILE    20       4.790  14.519   4.179  1.00  6.22           N
ATOM    299  CA  ILE    20       5.150  14.697   5.587  1.00  6.82           C
ATOM    301  CB  ILE    20       6.489  15.508   5.743  1.00  8.22           C
ATOM    303  CG1 ILE    20       7.649  14.867   4.981  1.00  9.99           C
ATOM    306  CD1 ILE    20       8.873  15.766   4.839  1.00 13.13           C
ATOM    310  CG2 ILE    20       6.832  15.684   7.223  1.00 12.01           C
ATOM    314  C   ILE    20       4.027  15.459   6.274  1.00  6.99           C
ATOM    315  O   ILE    20       3.566  16.461   5.762  1.00  9.28           O
ATOM    317  N   LYS    21       3.586  14.957   7.413  1.00  7.07           N
ATOM    318  CA  LYS    21       2.690  15.683   8.288  1.00  6.19           C
ATOM    320  CB  LYS    21       1.699  14.734   8.954  1.00  8.22           C
ATOM    323  CG  LYS    21       0.953  13.836   7.994  1.00 15.14           C
ATOM    326  CD  LYS    21      -0.238  13.152   8.664  1.00 20.17           C
ATOM    329  CE  LYS    21      -0.766  11.971   7.851  1.00 17.14           C
ATOM    332  NZ  LYS    21      -1.781  11.169   8.587  1.00 23.82           N
ATOM    336  C   LYS    21       3.510  16.425   9.341  1.00  8.23           C
ATOM    337  O   LYS    21       4.179  15.810  10.163  1.00  8.25           O
ATOM    339  N   LEU    22       3.477  17.754   9.278  1.00  6.53           N
ATOM    340  CA  LEU    22       4.253  18.608  10.175  1.00  7.05           C
ATOM    342  CB  LEU    22       4.977  19.717   9.405  1.00  9.04           C
ATOM    345  CG  LEU    22       6.120  19.350   8.473  1.00 11.98           C
ATOM    347  CD1 LEU    22       6.685  20.618   7.819  1.00 16.38           C
ATOM    351  CD2 LEU    22       7.190  18.609   9.229  1.00 12.08           C
ATOM    355  C   LEU    22       3.340  19.222  11.220  1.00  6.95           C
ATOM    356  O   LEU    22       2.267  19.693  10.894  1.00  8.65           O
ATOM    358  N   VAL    23       3.808  19.255  12.458  1.00  6.35           N
ATOM    359  CA  VAL    23       3.041  19.777  13.571  1.00  6.35           C
ATOM    361  CB  VAL    23       2.419  18.631  14.430  1.00  7.14           C
ATOM    363  CG1 VAL    23       1.471  17.776  13.574  1.00 10.40           C
ATOM    367  CG2 VAL    23       3.466  17.784  15.139  1.00  8.76           C
ATOM    371  C   VAL    23       3.855  20.658  14.495  1.00  6.32           C
ATOM    372  O   VAL    23       5.072  20.554  14.588  1.00  7.02           O
ATOM    374  N   ARG    24       3.147  21.542  15.177  1.00  6.06           N
ATOM    375  CA  ARG    24       3.667  22.214  16.353  1.00  6.42           C
ATOM    377  CB  ARG    24       3.154  23.651  16.436  1.00  7.91           C
ATOM    380  CG  ARG    24       1.670  23.812  16.738  1.00  8.11           C
ATOM    383  CD  ARG    24       1.240  25.229  16.426  1.00 11.78           C
ATOM    386  NE  ARG    24      -0.147  25.442  16.818  1.00 11.84           N
ATOM    388  CZ  ARG    24      -0.924  26.419  16.356  1.00 13.32           C
ATOM    389  NH1 ARG    24      -0.470  27.304  15.491  1.00 13.58           N
ATOM    392  NH2 ARG    24      -2.176  26.505  16.774  1.00 15.33           N
ATOM    395  C   ARG    24       3.277  21.419  17.588  1.00  7.93           C
ATOM    396  O   ARG    24       2.320  20.643  17.569  1.00 10.12           O
ATOM    398  N   ARG    25       4.018  21.637  18.670  1.00  7.87           N
ATOM    399  CA  ARG    25       3.751  20.948  19.936  1.00 10.55           C
ATOM    401  CB  ARG    25       4.972  20.177  20.387  1.00 11.13           C
ATOM    404  CG  ARG    25       5.165  18.961  19.570  1.00 14.31           C
ATOM    407  CD  ARG    25       6.317  18.166  20.053  1.00 14.64           C
ATOM    410  NE  ARG    25       6.432  16.964  19.256  1.00 20.85           N
ATOM    412  CZ  ARG    25       7.389  16.056  19.399  1.00 21.75           C
ATOM    413  NH1 ARG    25       8.324  16.190  20.332  1.00 26.11           N
ATOM    416  NH2 ARG    25       7.410  15.002  18.596  1.00 19.78           N
ATOM    419  C   ARG    25       3.407  21.916  21.018  1.00 12.37           C
ATOM    420  O   ARG    25       3.895  23.032  21.024  1.00 12.41           O
ATOM    422  N   THR    26       2.593  21.449  21.958  1.00 13.46           N
ATOM    423  CA  THR    26       2.064  22.292  23.024  1.00 16.07           C
ATOM    425  CB  THR    26       0.724  21.742  23.541  1.00 15.98           C
ATOM    427  OG1 THR    26       0.901  20.365  23.892  1.00 20.67           O
ATOM    429  CG2 THR    26      -0.319  21.846  22.445  1.00 18.95           C
ATOM    433  C   THR    26       3.003  22.470  24.213  1.00 14.82           C
ATOM    434  O   THR    26       2.719  23.286  25.078  1.00 19.95           O
ATOM    436  N   ASP    27       4.122  21.754  24.245  1.00 16.37           N
ATOM    437  CA  ASP    27       5.000  21.772  25.411  1.00 18.65           C
ATOM    439  CB  ASP    27       4.850  20.464  26.181  1.00 23.44           C
ATOM    442  CG  ASP    27       5.179  19.239  25.334  1.00 31.95           C
ATOM    443  OD1 ASP    27       5.466  19.385  24.118  1.00 29.18           O
ATOM    444  OD2 ASP    27       5.137  18.121  25.887  1.00 45.79           O
ATOM    445  C   ASP    27       6.472  21.999  25.078  1.00 17.69           C
ATOM    446  O   ASP    27       7.320  21.926  25.961  1.00 20.53           O
ATOM    448  N   GLU    28       6.790  22.264  23.815  1.00 15.18           N
ATOM    449  CA  GLU    28       8.160  22.554  23.416  1.00 15.75           C
ATOM    451  CB  GLU    28       8.999  21.268  23.355  1.00 17.87           C
ATOM    454  CG  GLU    28       8.564  20.268  22.295  1.00 15.99           C
ATOM    457  CD  GLU    28       9.431  19.010  22.286  1.00 17.81           C
ATOM    458  OE1 GLU    28      10.659  19.146  22.161  1.00 25.99           O
ATOM    459  OE2 GLU    28       8.881  17.905  22.411  1.00 32.00           O
ATOM    460  C   GLU    28       8.153  23.236  22.054  1.00 13.50           C
ATOM    461  O   GLU    28       7.240  23.042  21.248  1.00 11.92           O
ATOM    463  N   PRO    29       9.178  24.036  21.791  1.00 11.31           N
ATOM    464  CA  PRO    29       9.234  24.766  20.542  1.00  9.48           C
ATOM    466  CB  PRO    29      10.283  25.836  20.815  1.00 13.51           C
ATOM    469  CG  PRO    29      11.215  25.168  21.786  1.00 13.32           C
ATOM    472  CD  PRO    29      10.337  24.320  22.656  1.00 13.95           C
ATOM    475  C   PRO    29       9.672  23.871  19.401  1.00 10.21           C
ATOM    476  O   PRO    29      10.263  22.802  19.630  1.00 10.48           O
ATOM    477  N   GLY    30       9.388  24.307  18.178  1.00  8.28           N
ATOM    478  CA  GLY    30       9.868  23.605  17.007  1.00  8.52           C
ATOM    481  C   GLY    30       8.771  23.103  16.084  1.00  7.13           C
ATOM    482  O   GLY    30       7.579  23.153  16.414  1.00  7.59           O
ATOM    484  N   VAL    31       9.206  22.606  14.930  1.00  6.41           N
ATOM    485  CA  VAL    31       8.341  21.984  13.950  1.00  6.55           C
ATOM    487  CB  VAL    31       8.562  22.633  12.560  1.00  9.09           C
ATOM    489  CG1 VAL    31       7.696  21.998  11.538  1.00 11.32           C
ATOM    493  CG2 VAL    31       8.330  24.131  12.631  1.00 12.01           C
ATOM    497  C   VAL    31       8.734  20.517  13.912  1.00  5.36           C
ATOM    498  O   VAL    31       9.921  20.186  13.789  1.00  6.15           O
ATOM    500  N   PHE    32       7.745  19.636  14.012  1.00  5.13           N
ATOM    501  CA  PHE    32       7.985  18.206  14.179  1.00  6.39           C
ATOM    503  CB  PHE    32       7.554  17.743  15.584  1.00  6.64           C
ATOM    506  CG  PHE    32       8.328  18.414  16.676  1.00  6.56           C
ATOM    507  CD1 PHE    32       9.453  17.844  17.194  1.00  6.87           C
ATOM    509  CE1 PHE    32      10.178  18.486  18.181  1.00  8.33           C
ATOM    511  CZ  PHE    32       9.765  19.681  18.653  1.00  8.49           C
ATOM    513  CE2 PHE    32       8.641  20.269  18.156  1.00  8.36           C
ATOM    515  CD2 PHE    32       7.922  19.638  17.169  1.00  6.58           C
ATOM    517  C   PHE    32       7.260  17.401  13.145  1.00  6.13           C
ATOM    518  O   PHE    32       6.154  17.747  12.715  1.00  8.29           O
ATOM    520  N   ILE    33       7.866  16.282  12.766  1.00  5.72           N
ATOM    521  CA  ILE    33       7.185  15.310  11.921  1.00  5.98           C
ATOM    523  CB  ILE    33       8.192  14.401  11.195  1.00  6.56           C
ATOM    525  CG1 ILE    33       9.084  15.265  10.320  1.00  7.81           C
ATOM    528  CD1 ILE    33      10.065  14.515   9.462  1.00  9.96           C
ATOM    532  CG2 ILE    33       7.493  13.339  10.346  1.00  8.37           C
ATOM    536  C   ILE    33       6.274  14.467  12.801  1.00  7.53           C
ATOM    537  O   ILE    33       6.726  13.828  13.751  1.00  8.02           O
ATOM    539  N   LEU    34       4.981  14.441  12.481  1.00  6.69           N
ATOM    540  CA  LEU    34       4.062  13.561  13.167  1.00  9.23           C
ATOM    542  CB  LEU    34       2.651  14.122  13.100  1.00  9.63           C
ATOM    545  CG  LEU    34       1.589  13.339  13.869  1.00 10.85           C
ATOM    547  CD1 LEU    34       1.808  13.508  15.371  1.00 13.84           C
ATOM    551  CD2 LEU    34       0.192  13.819  13.461  1.00 17.22           C
ATOM    555  C   LEU    34       4.149  12.162  12.550  1.00  8.28           C
ATOM    556  O   LEU    34       4.259  11.163  13.265  1.00  9.20           O
ATOM    558  N   ASP    35       4.066  12.102  11.222  1.00  8.00           N
ATOM    559  CA  ASP    35       4.172  10.849  10.482  1.00  8.97           C
ATOM    561  CB  ASP    35       2.937   9.975  10.701  1.00 15.92           C
ATOM    564  CG  ASP    35       1.688  10.662  10.296  1.00 18.18           C
ATOM    565  OD1 ASP    35       1.592  10.998   9.115  1.00 27.37           O
ATOM    566  OD2 ASP    35       0.793  10.869  11.145  1.00 37.45           O
ATOM    567  C   ASP    35       4.374  11.200   9.011  1.00  7.38           C
ATOM    568  O   ASP    35       4.342  12.361   8.636  1.00  7.85           O
ATOM    570  N   LEU    36       4.617  10.172   8.213  1.00  9.96           N
ATOM    571  CA  LEU    36       4.789  10.277   6.792  1.00  9.02           C
ATOM    573  CB  LEU    36       6.040   9.523   6.346  1.00  9.54           C
ATOM    576  CG  LEU    36       7.348   9.882   7.039  1.00 11.95           C
ATOM    578  CD1 LEU    36       8.469   9.086   6.358  1.00 12.55           C
ATOM    582  CD2 LEU    36       7.634  11.373   6.998  1.00 10.74           C
ATOM    586  C   LEU    36       3.575   9.694   6.086  1.00 10.85           C
ATOM    587  O   LEU    36       2.923   8.753   6.590  1.00 16.71           O
ATOM    589  N   LEU    37       3.267  10.244   4.924  1.00 10.18           N
ATOM    590  CA  LEU    37       2.173   9.751   4.101  1.00  9.91           C
ATOM    592  CB  LEU    37       1.680  10.825   3.129  1.00 11.13           C
ATOM    595  CG  LEU    37       1.134  12.139   3.683  0.50 15.44           C
ATOM    599  CD1 LEU    37       0.485  12.974   2.576  0.50 17.87           C
ATOM    607  CD2 LEU    37       0.158  11.845   4.773  0.50 17.28           C
ATOM    615  C   LEU    37       2.603   8.536   3.287  1.00  9.77           C
ATOM    616  O   LEU    37       3.694   8.497   2.729  1.00  9.19           O
ATOM    618  N   GLU    38       1.707   7.561   3.187  1.00 12.24           N
ATOM    619  CA  GLU    38       1.930   6.353   2.392  1.00 14.34           C
ATOM    621  CB  GLU    38       0.618   5.543   2.312  1.00 18.79           C
ATOM    624  CG  GLU    38       0.785   4.168   1.682  1.00 22.16           C
ATOM    627  CD  GLU    38      -0.488   3.358   1.710  1.00 31.25           C
ATOM    628  OE1 GLU    38      -1.564   3.948   1.927  1.00 23.39           O
ATOM    629  OE2 GLU    38      -0.412   2.128   1.508  1.00 44.28           O
ATOM    630  C   GLU    38       2.369   6.686   0.979  1.00 13.82           C
ATOM    631  O   GLU    38       1.738   7.485   0.314  1.00 14.65           O
ATOM    633  N   GLY    39       3.467   6.086   0.533  1.00 11.43           N
ATOM    634  CA  GLY    39       3.898   6.213  -0.864  1.00 14.98           C
ATOM    637  C   GLY    39       4.490   7.564  -1.252  1.00 12.08           C
ATOM    638  O   GLY    39       4.870   7.772  -2.408  1.00 13.34           O
ATOM    640  N   GLY    40       4.612   8.482  -0.299  1.00  9.86           N
ATOM    641  CA  GLY    40       5.146   9.787  -0.608  1.00  9.55           C
ATOM    644  C   GLY    40       6.653   9.766  -0.727  1.00  7.46           C
ATOM    645  O   GLY    40       7.303   8.764  -0.407  1.00  7.40           O
ATOM    647  N   LEU    41       7.222  10.891  -1.146  1.00  7.62           N
ATOM    648  CA  LEU    41       8.672  10.979  -1.316  1.00  8.00           C
ATOM    650  CB  LEU    41       9.091  12.399  -1.714  1.00 10.73           C
ATOM    653  CG  LEU    41       8.977  12.843  -3.153  1.00 14.71           C
ATOM    655  CD1 LEU    41       9.439  14.280  -3.194  1.00 13.54           C
ATOM    659  CD2 LEU    41       9.823  11.953  -4.047  1.00 13.69           C
ATOM    663  C   LEU    41       9.398  10.637  -0.047  1.00  6.30           C
ATOM    664  O   LEU    41      10.426   9.958  -0.078  1.00  6.05           O
ATOM    666  N   ALA    42       8.923  11.169   1.076  1.00  6.10           N
ATOM    667  CA  ALA    42       9.617  10.951   2.343  1.00  5.50           C
ATOM    669  CB  ALA    42       9.039  11.836   3.429  1.00  6.62           C
ATOM    673  C   ALA    42       9.603   9.484   2.750  1.00  6.00           C
ATOM    674  O   ALA    42      10.614   8.938   3.177  1.00  5.85           O
ATOM    676  N   ALA    43       8.451   8.841   2.592  1.00  5.17           N
ATOM    677  CA  ALA    43       8.324   7.429   2.900  1.00  5.95           C
ATOM    679  CB  ALA    43       6.877   6.965   2.811  1.00  8.50           C
ATOM    683  C   ALA    43       9.207   6.590   1.979  1.00  6.68           C
ATOM    684  O   ALA    43       9.846   5.647   2.421  1.00  7.67           O
ATOM    686  N   GLN    44       9.239   6.927   0.693  1.00  6.75           N
ATOM    687  CA  GLN    44      10.080   6.208  -0.242  1.00  5.96           C
ATOM    689  CB  GLN    44       9.884   6.725  -1.657  1.00  6.18           C
ATOM    692  CG  GLN    44       8.528   6.335  -2.259  1.00  8.92           C
ATOM    695  CD  GLN    44       8.364   6.902  -3.633  1.00 11.62           C
ATOM    696  OE1 GLN    44       9.187   6.663  -4.520  1.00 14.68           O
ATOM    697  NE2 GLN    44       7.314   7.675  -3.818  1.00 14.96           N
ATOM    700  C   GLN    44      11.545   6.330   0.121  1.00  5.84           C
ATOM    701  O   GLN    44      12.322   5.375  -0.015  1.00  6.68           O
ATOM    703  N   ASP    45      11.944   7.519   0.550  1.00  5.19           N
ATOM    704  CA  ASP    45      13.315   7.747   0.941  1.00  5.40           C
ATOM    706  CB  ASP    45      13.577   9.248   1.150  1.00  5.38           C
ATOM    709  CG  ASP    45      14.928   9.517   1.707  1.00  7.25           C
ATOM    710  OD1 ASP    45      15.893   9.620   0.899  1.00  7.92           O
ATOM    711  OD2 ASP    45      15.039   9.605   2.962  1.00  7.45           O
ATOM    712  C   ASP    45      13.687   6.947   2.180  1.00  6.21           C
ATOM    713  O   ASP    45      14.794   6.435   2.255  1.00  7.92           O
ATOM    715  N   GLY    46      12.777   6.884   3.146  1.00  6.05           N
ATOM    716  CA  GLY    46      12.890   6.010   4.303  1.00  8.24           C
ATOM    719  C   GLY    46      13.464   6.635   5.554  1.00  8.42           C
ATOM    720  O   GLY    46      13.208   6.144   6.652  1.00 12.24           O
ATOM    722  N   ARG    47      14.251   7.704   5.407  1.00  6.54           N
ATOM    723  CA  ARG    47      15.018   8.218   6.545  1.00  8.04           C
ATOM    725  CB  ARG    47      16.169   9.085   6.066  1.00  7.42           C
ATOM    728  CG  ARG    47      17.222   8.284   5.355  1.00  9.19           C
ATOM    731  CD  ARG    47      18.320   9.143   4.763  1.00  9.89           C
ATOM    734  NE  ARG    47      17.874   9.848   3.578  1.00  8.34           N
ATOM    736  CZ  ARG    47      18.629  10.670   2.865  1.00  7.37           C
ATOM    737  NH1 ARG    47      19.872  10.932   3.235  1.00 10.70           N
ATOM    740  NH2 ARG    47      18.144  11.253   1.797  1.00  8.55           N
ATOM    743  C   ARG    47      14.197   8.973   7.569  1.00  8.63           C
ATOM    744  O   ARG    47      14.369   8.776   8.766  1.00 13.68           O
ATOM    746  N   LEU    48      13.341   9.866   7.116  1.00  7.63           N
ATOM    747  CA  LEU    48      12.584  10.684   8.035  1.00  7.29           C
ATOM    749  CB  LEU    48      11.816  11.766   7.291  1.00  7.30           C
ATOM    752  CG  LEU    48      12.687  12.823   6.589  1.00  8.01           C
ATOM    754  CD1 LEU    48      11.836  13.663   5.678  1.00 10.86           C
ATOM    758  CD2 LEU    48      13.434  13.710   7.580  1.00  9.67           C
ATOM    762  C   LEU    48      11.646   9.839   8.871  1.00  9.21           C
ATOM    763  O   LEU    48      11.231   8.751   8.454  1.00 11.25           O
ATOM    765  N   SER    49      11.325  10.343  10.062  1.00  7.94           N
ATOM    766  CA  SER    49      10.576   9.586  11.039  1.00  8.89           C
ATOM    768  CB  SER    49      11.569   8.839  11.926  1.00 10.93           C
ATOM    771  OG  SER    49      10.887   7.933  12.776  1.00 14.79           O
ATOM    773  C   SER    49       9.708  10.456  11.922  1.00  7.68           C
ATOM    774  O   SER    49      10.045  11.579  12.207  1.00  7.74           O
ATOM    776  N   SER    50       8.643   9.859  12.435  1.00  7.02           N
ATOM    777  CA  SER    50       7.847  10.451  13.491  1.00  7.93           C
ATOM    779  CB  SER    50       6.847   9.400  13.997  0.50  7.51           C
ATOM    785  OG  SER    50       5.958   9.906  14.963  0.50  6.38           O
ATOM    789  C   SER    50       8.764  10.917  14.610  1.00  6.25           C
ATOM    790  O   SER    50       9.705  10.210  14.994  1.00  8.15           O
ATOM    792  N   ASN    51       8.476  12.127  15.105  1.00  5.84           N
ATOM    793  CA  ASN    51       9.180  12.780  16.210  1.00  6.94           C
ATOM    795  CB  ASN    51       9.345  11.845  17.409  1.00  8.16           C
ATOM    798  CG  ASN    51       8.018  11.464  17.982  1.00  9.85           C
ATOM    799  OD1 ASN    51       7.313  12.311  18.530  1.00 12.30           O
ATOM    800  ND2 ASN    51       7.642  10.213  17.832  1.00  9.84           N
ATOM    803  C   ASN    51      10.454  13.506  15.833  1.00  6.49           C
ATOM    804  O   ASN    51      11.045  14.165  16.682  1.00  8.19           O
ATOM    806  N   ASP    52      10.845  13.450  14.563  1.00  6.15           N
ATOM    807  CA  ASP    52      11.970  14.223  14.106  1.00  5.99           C
ATOM    809  CB  ASP    52      12.290  13.888  12.648  1.00  6.83           C
ATOM    812  CG  ASP    52      13.037  12.585  12.472  1.00  8.10           C
ATOM    813  OD1 ASP    52      13.484  11.982  13.468  1.00  8.15           O
ATOM    814  OD2 ASP    52      13.210  12.189  11.298  1.00  8.89           O
ATOM    815  C   ASP    52      11.601  15.697  14.206  1.00  6.29           C
ATOM    816  O   ASP    52      10.491  16.107  13.839  1.00  6.95           O
ATOM    818  N   ARG    53      12.550  16.500  14.650  1.00  5.25           N
ATOM    819  CA  ARG    53      12.408  17.938  14.683  1.00  4.99           C
ATOM    821  CB  ARG    53      13.041  18.529  15.935  1.00  6.14           C
ATOM    824  CG  ARG    53      12.863  20.012  16.008  1.00  7.50           C
ATOM    827  CD  ARG    53      13.501  20.585  17.212  1.00  8.27           C
ATOM    830  NE  ARG    53      13.318  22.031  17.331  1.00  8.88           N
ATOM    832  CZ  ARG    53      13.737  22.686  18.396  1.00 11.23           C
ATOM    833  NH1 ARG    53      14.346  22.016  19.366  1.00 16.53           N
ATOM    836  NH2 ARG    53      13.543  23.977  18.514  1.00 13.37           N
ATOM    839  C   ARG    53      13.100  18.513  13.447  1.00  4.96           C
ATOM    840  O   ARG    53      14.246  18.205  13.173  1.00  6.86           O
ATOM    842  N   VAL    54      12.379  19.326  12.678  1.00  5.73           N
ATOM    843  CA  VAL    54      12.946  19.961  11.493  1.00  6.02           C
ATOM    845  CB  VAL    54      11.865  20.242  10.411  1.00  6.77           C
ATOM    847  CG1 VAL    54      12.525  20.854   9.177  1.00  7.75           C
ATOM    851  CG2 VAL    54      11.100  18.960  10.023  1.00  9.25           C
ATOM    855  C   VAL    54      13.643  21.257  11.915  1.00  5.20           C
ATOM    856  O   VAL    54      12.992  22.215  12.306  1.00  6.89           O
ATOM    858  N   LEU    55      14.971  21.250  11.874  1.00  4.90           N
ATOM    859  CA  LEU    55      15.774  22.399  12.259  1.00  5.97           C
ATOM    861  CB  LEU    55      17.164  21.952  12.706  1.00  6.50           C
ATOM    864  CG  LEU    55      17.211  21.067  13.939  1.00  7.90           C
ATOM    866  CD1 LEU    55      18.665  20.650  14.173  1.00 10.54           C
ATOM    870  CD2 LEU    55      16.639  21.761  15.161  1.00 12.65           C
ATOM    874  C   LEU    55      15.917  23.418  11.129  1.00  5.73           C
ATOM    875  O   LEU    55      16.055  24.599  11.409  1.00  6.02           O
ATOM    877  N   ALA    56      15.899  22.967   9.877  1.00  4.96           N
ATOM    878  CA  ALA    56      16.078  23.839   8.738  1.00  5.86           C
ATOM    880  CB  ALA    56      17.559  24.243   8.565  1.00  7.39           C
ATOM    884  C   ALA    56      15.613  23.097   7.501  1.00  4.94           C
ATOM    885  O   ALA    56      15.630  21.863   7.462  1.00  5.30           O
ATOM    887  N   ILE    57      15.205  23.857   6.494  1.00  4.78           N
ATOM    888  CA  ILE    57      14.911  23.339   5.159  1.00  5.74           C
ATOM    890  CB  ILE    57      13.401  23.285   4.848  1.00  7.45           C
ATOM    892  CG1 ILE    57      12.699  22.291   5.772  1.00  8.31           C
ATOM    895  CD1 ILE    57      11.186  22.199   5.602  1.00 11.74           C
ATOM    899  CG2 ILE    57      13.155  22.833   3.436  1.00  7.99           C
ATOM    903  C   ILE    57      15.615  24.249   4.162  1.00  5.48           C
ATOM    904  O   ILE    57      15.437  25.465   4.181  1.00  5.95           O
ATOM    906  N   ASN    58      16.488  23.659   3.347  1.00  5.37           N
ATOM    907  CA  ASN    58      17.202  24.406   2.311  1.00  5.56           C
ATOM    909  CB  ASN    58      16.242  24.820   1.190  1.00  6.55           C
ATOM    912  CG  ASN    58      15.844  23.658   0.321  1.00  5.43           C
ATOM    913  OD1 ASN    58      16.462  22.598   0.393  1.00  7.68           O
ATOM    914  ND2 ASN    58      14.804  23.840  -0.499  1.00  9.08           N
ATOM    917  C   ASN    58      17.968  25.593   2.877  1.00  5.61           C
ATOM    918  O   ASN    58      18.065  26.640   2.259  1.00  6.22           O
ATOM    920  N   GLY    59      18.531  25.413   4.066  1.00  7.13           N
ATOM    921  CA  GLY    59      19.286  26.446   4.761  1.00  6.57           C
ATOM    924  C   GLY    59      18.476  27.481   5.496  1.00  6.87           C
ATOM    925  O   GLY    59      19.058  28.366   6.131  1.00 10.12           O
ATOM    927  N   HIS    60      17.151  27.403   5.379  1.00  5.84           N
ATOM    928  CA  HIS    60      16.246  28.308   6.057  1.00  6.38           C
ATOM    930  CB  HIS    60      14.923  28.422   5.291  1.00  7.41           C
ATOM    933  CG  HIS    60      15.059  28.970   3.905  1.00  9.29           C
ATOM    934  ND1 HIS    60      14.673  30.244   3.565  1.00 15.26           N
ATOM    936  CE1 HIS    60      14.916  30.455   2.284  1.00 15.78           C
ATOM    938  NE2 HIS    60      15.439  29.353   1.773  1.00 10.90           N
ATOM    940  CD2 HIS    60      15.508  28.403   2.762  1.00 11.08           C
ATOM    942  C   HIS    60      15.969  27.768   7.456  1.00  6.08           C
ATOM    943  O   HIS    60      15.431  26.677   7.615  1.00  7.61           O
ATOM    945  N   ASP    61      16.284  28.556   8.478  1.00  7.12           N
ATOM    946  CA  ASP    61      16.130  28.131   9.868  1.00  7.26           C
ATOM    948  CB  ASP    61      16.723  29.213  10.787  1.00  9.51           C
ATOM    951  CG  ASP    61      16.625  28.881  12.261  1.00 11.69           C
ATOM    952  OD1 ASP    61      16.644  27.691  12.621  1.00 11.87           O
ATOM    953  OD2 ASP    61      16.534  29.843  13.051  1.00 19.75           O
ATOM    954  C   ASP    61      14.659  27.919  10.218  1.00  7.26           C
ATOM    955  O   ASP    61      13.821  28.778   9.948  1.00  9.44           O
ATOM    957  N   LEU    62      14.365  26.784  10.844  1.00  6.81           N
ATOM    958  CA  LEU    62      13.042  26.461  11.358  1.00  7.03           C
ATOM    960  CB  LEU    62      12.435  25.351  10.511  1.00  8.04           C
ATOM    963  CG  LEU    62      11.842  25.803   9.173  1.00  9.58           C
ATOM    965  CD1 LEU    62      11.547  24.580   8.318  1.00 14.23           C
ATOM    969  CD2 LEU    62      10.558  26.562   9.377  1.00 11.51           C
ATOM    973  C   LEU    62      13.065  26.067  12.836  1.00  6.56           C
ATOM    974  O   LEU    62      12.072  25.571  13.367  1.00  7.03           O
ATOM    976  N   LYS    63      14.176  26.298  13.525  1.00  6.57           N
ATOM    977  CA  LYS    63      14.275  25.871  14.918  1.00  7.54           C
ATOM    979  CB  LYS    63      15.603  26.320  15.527  1.00  9.50           C
ATOM    982  CG  LYS    63      15.877  25.737  16.905  1.00 14.00           C
ATOM    985  CD  LYS    63      17.286  25.997  17.394  1.00 18.24           C
ATOM    988  CE  LYS    63      17.444  25.472  18.815  1.00 23.48           C
ATOM    992  C   LYS    63      13.103  26.393  15.750  1.00  6.86           C
ATOM    993  O   LYS    63      12.524  25.652  16.546  1.00  7.88           O
ATOM    995  N   TYR    64      12.751  27.663  15.566  1.00  7.48           N
ATOM    996  CA  TYR    64      11.624  28.256  16.273  1.00  8.17           C
ATOM    998  CB  TYR    64      12.093  29.470  17.089  1.00 11.09           C
ATOM   1001  CG  TYR    64      13.152  29.097  18.092  1.00 11.97           C
ATOM   1002  CD1 TYR    64      12.812  28.444  19.262  1.00 14.21           C
ATOM   1004  CE1 TYR    64      13.775  28.061  20.178  1.00 17.55           C
ATOM   1006  CZ  TYR    64      15.099  28.298  19.905  1.00 20.25           C
ATOM   1007  OH  TYR    64      16.053  27.918  20.816  1.00 26.55           O
ATOM   1009  CE2 TYR    64      15.471  28.924  18.736  1.00 20.96           C
ATOM   1011  CD2 TYR    64      14.501  29.305  17.825  1.00 15.02           C
ATOM   1013  C   TYR    64      10.497  28.626  15.316  1.00  8.44           C
ATOM   1014  O   TYR    64       9.719  29.543  15.565  1.00 11.33           O
ATOM   1016  N   GLY    65      10.391  27.868  14.226  1.00  7.80           N
ATOM   1017  CA  GLY    65       9.456  28.141  13.163  1.00  8.27           C
ATOM   1020  C   GLY    65       8.106  27.507  13.394  1.00  7.91           C
ATOM   1021  O   GLY    65       7.804  27.015  14.472  1.00  7.59           O
ATOM   1023  N   THR    66       7.300  27.515  12.346  1.00  9.49           N
ATOM   1024  CA  THR    66       5.936  27.018  12.364  1.00  9.40           C
ATOM   1026  CB  THR    66       4.949  28.188  12.187  1.00  9.92           C
ATOM   1028  OG1 THR    66       5.184  28.803  10.915  1.00 12.44           O
ATOM   1030  CG2 THR    66       5.102  29.213  13.287  1.00 13.80           C
ATOM   1034  C   THR    66       5.689  26.091  11.183  1.00  9.04           C
ATOM   1035  O   THR    66       6.401  26.156  10.182  1.00  8.82           O
ATOM   1037  N   PRO    67       4.658  25.244  11.275  1.00  9.53           N
ATOM   1038  CA  PRO    67       4.247  24.481  10.100  1.00  8.74           C
ATOM   1040  CB  PRO    67       2.977  23.778  10.578  1.00 10.07           C
ATOM   1043  CG  PRO    67       3.200  23.593  12.032  1.00 11.46           C
ATOM   1046  CD  PRO    67       3.906  24.839  12.476  1.00 11.37           C
ATOM   1049  C   PRO    67       3.988  25.364   8.877  1.00  9.67           C
ATOM   1050  O   PRO    67       4.337  24.995   7.759  1.00 10.04           O
ATOM   1051  N   GLU    68       3.394  26.533   9.096  1.00  9.78           N
ATOM   1052  CA  GLU    68       3.116  27.444   8.001  1.00 11.62           C
ATOM   1054  CB  GLU    68       2.371  28.680   8.504  1.00 15.78           C
ATOM   1057  CG  GLU    68       0.939  28.454   8.841  1.00 22.69           C
ATOM   1060  CD  GLU    68       0.730  27.530  10.025  1.00 38.18           C
ATOM   1061  OE1 GLU    68       1.509  27.567  11.019  1.00 30.10           O
ATOM   1062  OE2 GLU    68      -0.241  26.753   9.956  1.00 46.84           O
ATOM   1063  C   GLU    68       4.362  27.913   7.288  1.00 10.80           C
ATOM   1064  O   GLU    68       4.391  27.980   6.050  1.00 13.59           O
ATOM   1066  N   LEU    69       5.377  28.283   8.060  1.00 10.10           N
ATOM   1067  CA  LEU    69       6.635  28.728   7.469  1.00 10.16           C
ATOM   1069  CB  LEU    69       7.557  29.283   8.549  1.00 13.39           C
ATOM   1072  CG  LEU    69       8.913  29.806   8.085  1.00 13.91           C
ATOM   1074  CD1 LEU    69       8.763  30.875   7.002  1.00 16.82           C
ATOM   1078  CD2 LEU    69       9.710  30.307   9.286  1.00 16.06           C
ATOM   1082  C   LEU    69       7.287  27.576   6.700  1.00  9.38           C
ATOM   1083  O   LEU    69       7.778  27.764   5.595  1.00 10.31           O
ATOM   1085  N   ALA    70       7.282  26.382   7.275  1.00  9.22           N
ATOM   1086  CA  ALA    70       7.801  25.207   6.554  1.00  8.31           C
ATOM   1088  CB  ALA    70       7.687  23.984   7.411  1.00  9.24           C
ATOM   1092  C   ALA    70       7.056  24.999   5.230  1.00  8.63           C
ATOM   1093  O   ALA    70       7.679  24.743   4.207  1.00  9.95           O
ATOM   1095  N   ALA    71       5.729  25.125   5.262  1.00  9.56           N
ATOM   1096  CA  ALA    71       4.901  24.975   4.076  1.00 10.82           C
ATOM   1098  CB  ALA    71       3.435  25.119   4.431  1.00 12.69           C
ATOM   1102  C   ALA    71       5.282  25.984   3.003  1.00 10.30           C
ATOM   1103  O   ALA    71       5.370  25.639   1.841  1.00 11.75           O
ATOM   1105  N   GLN    72       5.506  27.233   3.406  1.00 11.39           N
ATOM   1106  CA  GLN    72       5.878  28.302   2.476  1.00 12.45           C
ATOM   1108  CB  GLN    72       5.975  29.639   3.207  1.00 15.12           C
ATOM   1111  CG  GLN    72       4.633  30.242   3.569  1.00 26.64           C
ATOM   1114  CD  GLN    72       4.759  31.571   4.300  1.00 41.76           C
ATOM   1115  OE1 GLN    72       5.777  31.860   4.936  1.00 44.64           O
ATOM   1116  NE2 GLN    72       3.713  32.385   4.216  1.00 48.57           N
ATOM   1119  C   GLN    72       7.207  27.962   1.806  1.00 12.12           C
ATOM   1120  O   GLN    72       7.353  28.082   0.581  1.00 12.87           O
ATOM   1122  N   ILE    73       8.179  27.518   2.597  1.00 10.78           N
ATOM   1123  CA  ILE    73       9.494  27.153   2.059  1.00 11.01           C
ATOM   1125  CB  ILE    73      10.495  26.822   3.185  1.00 10.04           C
ATOM   1127  CG1 ILE    73      10.756  28.065   4.042  1.00 12.22           C
ATOM   1130  CD1 ILE    73      11.281  27.733   5.431  1.00 13.45           C
ATOM   1134  CG2 ILE    73      11.806  26.269   2.626  1.00 11.05           C
ATOM   1138  C   ILE    73       9.399  25.976   1.090  1.00  9.44           C
ATOM   1139  O   ILE    73       9.934  26.028  -0.020  1.00 11.21           O
ATOM   1141  N   ILE    74       8.672  24.931   1.481  1.00  9.74           N
ATOM   1142  CA  ILE    74       8.569  23.728   0.661  1.00  9.95           C
ATOM   1144  CB  ILE    74       7.907  22.592   1.429  1.00 10.93           C
ATOM   1146  CG1 ILE    74       8.843  22.115   2.522  1.00 10.18           C
ATOM   1149  CD1 ILE    74       8.119  21.328   3.647  1.00 13.36           C
ATOM   1153  CG2 ILE    74       7.582  21.426   0.509  1.00 12.72           C
ATOM   1157  C   ILE    74       7.825  24.010  -0.644  1.00 11.91           C
ATOM   1158  O   ILE    74       8.246  23.557  -1.726  1.00 13.89           O
ATOM   1160  N   GLN    75       6.741  24.780  -0.564  1.00 12.93           N
ATOM   1161  CA  GLN    75       5.961  25.074  -1.768  1.00 13.68           C
ATOM   1163  CB  GLN    75       4.657  25.750  -1.402  1.00 16.16           C
ATOM   1166  CG  GLN    75       3.669  24.773  -0.769  1.00 18.38           C
ATOM   1169  CD  GLN    75       2.441  25.471  -0.235  1.00 26.27           C
ATOM   1170  OE1 GLN    75       2.313  26.691  -0.338  1.00 34.21           O
ATOM   1171  NE2 GLN    75       1.530  24.705   0.337  1.00 29.94           N
ATOM   1174  C   GLN    75       6.746  25.917  -2.773  1.00 13.60           C
ATOM   1175  O   GLN    75       6.574  25.734  -3.965  1.00 17.87           O
ATOM   1177  N   ALA    76       7.609  26.812  -2.296  1.00 10.43           N
ATOM   1178  CA  ALA    76       8.437  27.639  -3.166  1.00 11.32           C
ATOM   1180  CB  ALA    76       8.707  28.987  -2.509  1.00 13.58           C
ATOM   1184  C   ALA    76       9.748  26.982  -3.584  1.00 11.10           C
ATOM   1185  O   ALA    76      10.468  27.561  -4.377  1.00 13.90           O
ATOM   1187  N   SER    77      10.065  25.793  -3.059  1.00  9.06           N
ATOM   1188  CA  SER    77      11.372  25.165  -3.256  1.00  9.49           C
ATOM   1190  CB  SER    77      11.469  23.906  -2.429  0.50  9.76           C
ATOM   1196  OG  SER    77      10.601  22.959  -2.991  0.50 13.23           O
ATOM   1200  C   SER    77      11.592  24.786  -4.692  1.00 10.15           C
ATOM   1201  O   SER    77      10.639  24.562  -5.437  1.00 14.75           O
ATOM   1203  N   GLY    78      12.861  24.707  -5.079  1.00  7.78           N
ATOM   1204  CA  GLY    78      13.221  24.044  -6.296  1.00  9.54           C
ATOM   1207  C   GLY    78      13.129  22.543  -6.113  1.00  8.94           C
ATOM   1208  O   GLY    78      12.615  22.045  -5.120  1.00 10.77           O
ATOM   1210  N   GLU    79      13.674  21.791  -7.049  1.00  9.79           N
ATOM   1211  CA  GLU    79      13.501  20.344  -7.016  1.00  9.89           C
ATOM   1213  CB  GLU    79      13.953  19.685  -8.320  1.00 16.21           C
ATOM   1216  CG  GLU    79      15.398  19.861  -8.639  1.00 16.42           C
ATOM   1219  CD  GLU    79      16.323  18.856  -7.970  1.00 22.12           C
ATOM   1220  OE1 GLU    79      15.852  17.773  -7.589  1.00 22.98           O
ATOM   1221  OE2 GLU    79      17.531  19.158  -7.834  1.00 30.49           O
ATOM   1222  C   GLU    79      14.129  19.674  -5.794  1.00  9.48           C
ATOM   1223  O   GLU    79      13.577  18.718  -5.290  1.00 11.29           O
ATOM   1225  N   ARG    80      15.251  20.178  -5.304  1.00  8.87           N
ATOM   1226  CA  ARG    80      15.911  19.591  -4.148  1.00  8.68           C
ATOM   1228  CB  ARG    80      17.430  19.716  -4.256  1.00 11.07           C
ATOM   1231  CG  ARG    80      18.176  19.033  -3.108  1.00 13.32           C
ATOM   1234  CD  ARG    80      19.682  19.112  -3.324  1.00 24.79           C
ATOM   1237  NE  ARG    80      20.448  18.479  -2.245  1.00 27.84           N
ATOM   1239  CZ  ARG    80      20.993  19.118  -1.207  1.00 36.19           C
ATOM   1240  NH1 ARG    80      20.863  20.433  -1.054  1.00 33.72           N
ATOM   1243  NH2 ARG    80      21.671  18.426  -0.295  1.00 41.41           N
ATOM   1246  C   ARG    80      15.411  20.246  -2.878  1.00  8.11           C
ATOM   1247  O   ARG    80      15.445  21.473  -2.722  1.00  9.37           O
ATOM   1249  N   VAL    81      14.959  19.401  -1.963  1.00  6.86           N
ATOM   1250  CA  VAL    81      14.513  19.835  -0.643  1.00  6.31           C
ATOM   1252  CB  VAL    81      13.028  19.562  -0.396  1.00  7.85           C
ATOM   1254  CG1 VAL    81      12.610  20.149   0.932  1.00  9.26           C
ATOM   1258  CG2 VAL    81      12.177  20.137  -1.532  1.00 10.85           C
ATOM   1262  C   VAL    81      15.382  19.116   0.383  1.00  6.33           C
ATOM   1263  O   VAL    81      15.236  17.909   0.611  1.00  8.05           O
ATOM   1265  N   ASN    82      16.280  19.870   0.997  1.00  5.57           N
ATOM   1266  CA  ASN    82      17.158  19.331   2.032  1.00  5.84           C
ATOM   1268  CB  ASN    82      18.579  19.900   1.896  1.00  8.13           C
ATOM   1271  CG  ASN    82      19.516  19.209   2.822  1.00 12.01           C
ATOM   1272  OD1 ASN    82      19.750  18.001   2.675  1.00 16.43           O
ATOM   1273  ND2 ASN    82      19.968  19.910   3.861  1.00 16.19           N
ATOM   1276  C   ASN    82      16.603  19.693   3.400  1.00  5.43           C
ATOM   1277  O   ASN    82      16.397  20.860   3.676  1.00  9.69           O
ATOM   1279  N   LEU    83      16.354  18.700   4.242  1.00  5.52           N
ATOM   1280  CA  LEU    83      15.875  18.917   5.599  1.00  5.39           C
ATOM   1282  CB  LEU    83      14.653  18.038   5.889  1.00  6.63           C
ATOM   1285  CG  LEU    83      13.448  18.253   4.967  1.00  7.62           C
ATOM   1287  CD1 LEU    83      13.437  17.282   3.780  1.00 10.23           C
ATOM   1291  CD2 LEU    83      12.167  18.112   5.799  1.00 11.84           C
ATOM   1295  C   LEU    83      16.980  18.565   6.561  1.00  5.82           C
ATOM   1296  O   LEU    83      17.545  17.489   6.480  1.00  8.00           O
ATOM   1298  N   THR    84      17.279  19.480   7.477  1.00  5.80           N
ATOM   1299  CA  THR    84      18.161  19.195   8.594  1.00  5.83           C
ATOM   1301  CB  THR    84      19.072  20.384   8.934  1.00  7.22           C
ATOM   1303  OG1 THR    84      19.806  20.767   7.757  1.00 11.03           O
ATOM   1305  CG2 THR    84      20.050  20.060  10.048  1.00  9.42           C
ATOM   1309  C   THR    84      17.285  18.858   9.778  1.00  5.81           C
ATOM   1310  O   THR    84      16.420  19.644  10.181  1.00  6.34           O
ATOM   1312  N   ILE    85      17.508  17.664  10.320  1.00  4.76           N
ATOM   1313  CA  ILE    85      16.683  17.063  11.339  1.00  6.86           C
ATOM   1315  CB  ILE    85      16.266  15.653  10.761  1.00 14.19           C
ATOM   1317  CG1 ILE    85      15.517  15.810   9.448  1.00 13.77           C
ATOM   1320  CD1 ILE    85      14.351  16.566   9.612  1.00 10.45           C
ATOM   1324  CG2 ILE    85      15.551  14.836  11.763  1.00 17.42           C
ATOM   1328  C   ILE    85      17.431  16.795  12.632  1.00  6.23           C
ATOM   1329  O   ILE    85      18.594  16.410  12.577  1.00  6.95           O
ATOM   1331  N   ALA    86      16.739  16.976  13.757  1.00  6.25           N
ATOM   1332  CA  ALA    86      17.190  16.463  15.050  1.00  6.59           C
ATOM   1334  CB  ALA    86      17.200  17.563  16.105  1.00  8.55           C
ATOM   1338  C   ALA    86      16.266  15.319  15.464  1.00  6.81           C
ATOM   1339  O   ALA    86      15.051  15.490  15.528  1.00  8.22           O
ATOM   1341  N   ARG    87      16.864  14.166  15.753  1.00  7.51           N
ATOM   1342  CA  ARG    87      16.141  12.966  16.135  1.00  8.14           C
ATOM   1344  CB  ARG    87      16.548  11.809  15.238  1.00  8.42           C
ATOM   1347  CG  ARG    87      15.882  10.496  15.579  1.00  9.40           C
ATOM   1350  CD  ARG    87      16.088   9.500  14.466  1.00 10.06           C
ATOM   1353  NE  ARG    87      15.444   9.990  13.256  1.00  8.90           N
ATOM   1355  CZ  ARG    87      15.734   9.569  12.031  1.00 11.27           C
ATOM   1356  NH1 ARG    87      16.620   8.604  11.820  1.00 12.83           N
ATOM   1359  NH2 ARG    87      15.145  10.122  11.007  1.00 11.16           N
ATOM   1362  C   ARG    87      16.500  12.689  17.593  1.00  7.99           C
ATOM   1363  O   ARG    87      17.564  12.158  17.886  1.00  8.23           O
ATOM   1365  N   PRO    88      15.638  13.098  18.531  1.00 10.73           N
ATOM   1366  CA  PRO    88      16.030  12.918  19.925  1.00 10.69           C
ATOM   1368  CB  PRO    88      15.102  13.869  20.685  1.00 14.27           C
ATOM   1371  CG  PRO    88      14.609  14.838  19.670  1.00 18.94           C
ATOM   1374  CD  PRO    88      14.509  14.034  18.416  1.00 14.24           C
ATOM   1377  C   PRO    88      15.854  11.499  20.425  1.00 10.66           C
ATOM   1378  O   PRO    88      15.081  10.700  19.871  1.00 14.66           O
ATOM   1379  N   GLY    89      16.590  11.193  21.476  1.00 10.65           N
ATOM   1380  CA  GLY    89      16.292  10.059  22.300  1.00 14.39           C
ATOM   1383  C   GLY    89      16.821   8.730  21.823  1.00 12.94           C
ATOM   1384  O   GLY    89      17.450   8.599  20.778  1.00 16.65           O
ATOM   1386  N   LYS    90      16.595   7.725  22.648  1.00 13.32           N
ATOM   1387  CA  LYS    90      17.063   6.385  22.376  1.00 11.77           C
ATOM   1389  CB  LYS    90      17.224   5.631  23.701  1.00 13.46           C
ATOM   1392  CG  LYS    90      18.208   6.274  24.672  1.00 15.32           C
ATOM   1395  CD  LYS    90      18.301   5.467  25.954  1.00 14.96           C
ATOM   1398  CE  LYS    90      19.261   6.115  26.964  1.00 15.66           C
ATOM   1401  NZ  LYS    90      19.404   5.284  28.187  1.00 22.41           N
ATOM   1405  C   LYS    90      16.058   5.637  21.500  1.00 10.89           C
ATOM   1406  O   LYS    90      14.853   5.785  21.671  1.00 14.13           O
ATOM   1408  N   PRO    91      16.552   4.802  20.591  1.00  9.91           N
ATOM   1409  CA  PRO    91      15.651   4.023  19.745  1.00 12.24           C
ATOM   1411  CB  PRO    91      16.556   3.534  18.608  1.00 15.51           C
ATOM   1414  CG  PRO    91      17.917   3.641  19.116  1.00 15.26           C
ATOM   1417  CD  PRO    91      17.936   4.756  20.099  1.00 12.95           C
ATOM   1420  C   PRO    91      15.025   2.841  20.462  1.00  9.07           C
ATOM   1421  O   PRO    91      14.020   2.324  20.007  1.00  9.13           O
ATOM   1422  N   GLU    92      15.643   2.418  21.560  1.00  7.37           N
ATOM   1423  CA  GLU    92      15.206   1.255  22.324  1.00  7.95           C
ATOM   1425  CB  GLU    92      16.009  -0.003  21.975  1.00 10.27           C
ATOM   1428  CG  GLU    92      15.660  -1.161  22.901  1.00 14.89           C
ATOM   1431  CD  GLU    92      16.260  -2.480  22.466  1.00 18.63           C
ATOM   1432  OE1 GLU    92      17.066  -2.497  21.502  1.00 29.25           O
ATOM   1433  OE2 GLU    92      15.921  -3.515  23.099  1.00 20.57           O
ATOM   1434  C   GLU    92      15.405   1.564  23.788  1.00  8.05           C
ATOM   1435  O   GLU    92      16.476   2.010  24.200  1.00  9.27           O
ATOM   1437  N   ILE    93      14.387   1.273  24.590  1.00  8.17           N
ATOM   1438  CA  ILE    93      14.469   1.437  26.046  1.00  8.79           C
ATOM   1440  CB  ILE    93      13.775   2.735  26.554  1.00  9.36           C
ATOM   1442  CG1 ILE    93      14.392   3.978  25.905  1.00 12.22           C
ATOM   1445  CD1 ILE    93      13.736   5.273  26.334  1.00 14.74           C
ATOM   1449  CG2 ILE    93      13.850   2.873  28.091  1.00 13.41           C
ATOM   1453  C   ILE    93      13.839   0.215  26.685  1.00  8.69           C
ATOM   1454  O   ILE    93      12.716  -0.158  26.382  1.00  8.14           O
ATOM   1456  N   GLU    94      14.587  -0.408  27.588  1.00  8.99           N
ATOM   1457  CA  GLU    94      14.057  -1.493  28.389  1.00  8.22           C
ATOM   1459  CB  GLU    94      15.122  -2.569  28.575  1.00 11.04           C
ATOM   1462  CG  GLU    94      15.738  -2.924  27.220  1.00 16.67           C
ATOM   1465  CD  GLU    94      16.767  -4.011  27.276  1.00 16.35           C
ATOM   1466  OE1 GLU    94      16.762  -4.808  28.236  1.00 19.51           O
ATOM   1467  OE2 GLU    94      17.608  -4.048  26.330  1.00 22.62           O
ATOM   1468  C   GLU    94      13.584  -0.886  29.689  1.00  8.96           C
ATOM   1469  O   GLU    94      14.327  -0.151  30.370  1.00 11.67           O
ATOM   1471  N   LEU    95      12.324  -1.163  30.007  1.00 11.21           N
ATOM   1472  CA  LEU    95      11.677  -0.524  31.139  1.00 14.71           C
ATOM   1474  CB  LEU    95      10.988   0.768  30.675  1.00 20.18           C
ATOM   1477  CG  LEU    95      10.244   0.748  29.337  1.00 20.27           C
ATOM   1479  CD1 LEU    95       9.020  -0.139  29.452  1.00 23.09           C
ATOM   1483  CD2 LEU    95       9.858   2.172  28.859  1.00 23.60           C
ATOM   1487  C   LEU    95      10.696  -1.450  31.825  1.00 17.18           C
ATOM   1488  O   LEU    95      10.717  -2.674  31.585  1.00 14.01           O
ATOM   1490  OXT LEU    95       9.915  -0.965  32.662  1.00 21.45           O
END
