
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  104 ( 1579),  selected  104 , name 2k1z_A
# Molecule2: number of CA atoms   95 (  723),  selected   95 , name T0488.pdb
# PARAMETERS: 2k1z_A.T0488.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     7_A      -       -           -
LGA    T     8_A      S       1          0.772
LGA    R     9_A      M       2          1.208
LGA    E    10_A      E       3          1.658
LGA    F    11_A      I       4          0.855
LGA    L    12_A      L       5          1.202
LGA    T    13_A      Q       6          0.636
LGA    F    14_A      V       7          0.504
LGA    E    15_A      A       8          0.478
LGA    V    16_A      L       9          1.301
LGA    P    17_A      H      10          1.400
LGA    L    18_A      K      11          2.058
LGA    N    19_A      R      12          1.676
LGA    D    20_A      D      13          4.033
LGA    -       -      S      14           -
LGA    S    21_A      G      15          6.520
LGA    G    22_A      E      16          1.481
LGA    S    23_A      -       -           -
LGA    A    24_A      -       -           -
LGA    G    25_A      Q      17          2.329
LGA    L    26_A      L      18          1.245
LGA    G    27_A      G      19          1.174
LGA    V    28_A      I      20          1.269
LGA    S    29_A      K      21          0.903
LGA    V    30_A      L      22          0.765
LGA    K    31_A      V      23          0.833
LGA    G    32_A      R      24          0.751
LGA    N    33_A      R      25          0.873
LGA    R    34_A      T      26          3.228
LGA    S    35_A      D      27          2.198
LGA    K    36_A      -       -           -
LGA    E    37_A      -       -           -
LGA    N    38_A      -       -           -
LGA    H    39_A      -       -           -
LGA    A    40_A      -       -           -
LGA    D    41_A      E      28          4.536
LGA    L    42_A      P      29          1.424
LGA    G    43_A      G      30          0.987
LGA    I    44_A      V      31          1.656
LGA    F    45_A      F      32          1.352
LGA    V    46_A      I      33          0.854
LGA    K    47_A      L      34          1.338
LGA    S    48_A      D      35          2.037
LGA    I    49_A      L      36          1.221
LGA    I    50_A      L      37          1.812
LGA    N    51_A      E      38          2.556
LGA    G    52_A      G      39          2.450
LGA    G    53_A      G      40          2.787
LGA    A    54_A      L      41          1.629
LGA    A    55_A      A      42          1.076
LGA    S    56_A      A      43          2.044
LGA    K    57_A      Q      44          1.933
LGA    D    58_A      D      45          1.403
LGA    G    59_A      G      46          1.023
LGA    R    60_A      R      47          0.711
LGA    L    61_A      L      48          0.875
LGA    R    62_A      S      49          0.289
LGA    V    63_A      S      50          1.449
LGA    N    64_A      N      51          1.410
LGA    D    65_A      D      52          0.748
LGA    Q    66_A      R      53          1.037
LGA    L    67_A      V      54          1.147
LGA    I    68_A      L      55          0.829
LGA    A    69_A      A      56          0.803
LGA    V    70_A      I      57          0.666
LGA    N    71_A      N      58          0.620
LGA    G    72_A      G      59          0.354
LGA    E    73_A      H      60          1.014
LGA    S    74_A      D      61          1.187
LGA    L    75_A      L      62          0.813
LGA    L    76_A      K      63          0.902
LGA    G    77_A      Y      64          3.238
LGA    K    78_A      G      65          2.573
LGA    A    79_A      -       -           -
LGA    N    80_A      -       -           -
LGA    Q    81_A      T      66          2.870
LGA    E    82_A      -       -           -
LGA    A    83_A      -       -           -
LGA    M    84_A      P      67          1.290
LGA    E    85_A      E      68          2.117
LGA    T    86_A      L      69          2.438
LGA    L    87_A      A      70          1.362
LGA    R    88_A      A      71          0.522
LGA    R    89_A      Q      72          1.157
LGA    S    90_A      I      73          2.266
LGA    M    91_A      I      74          2.234
LGA    S    92_A      Q      75          1.054
LGA    T    93_A      A      76          1.480
LGA    E    94_A      S      77          2.092
LGA    G    95_A      -       -           -
LGA    N    96_A      -       -           -
LGA    K    97_A      G      78          1.820
LGA    R    98_A      E      79          2.454
LGA    G    99_A      -       -           -
LGA    M   100_A      R      80          2.419
LGA    I   101_A      V      81          0.214
LGA    Q   102_A      N      82          0.651
LGA    L   103_A      L      83          0.595
LGA    I   104_A      T      84          0.865
LGA    V   105_A      I      85          1.031
LGA    A   106_A      A      86          0.641
LGA    R   107_A      R      87          1.099
LGA    R   108_A      P      88          1.762
LGA    I   109_A      G      89          3.187
LGA    S   110_A      K      90          3.113
LGA    -       -      P      91           -
LGA    -       -      E      92           -
LGA    -       -      I      93           -
LGA    -       -      E      94           -
LGA    -       -      L      95           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  104   95    5.0     89    1.83    26.97     85.148     4.608

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.251495 * X  +  -0.031139 * Y  +  -0.967357 * Z  +   9.868974
  Y_new =   0.930312 * X  +  -0.267908 * Y  +   0.250488 * Z  +  17.504990
  Z_new =  -0.266963 * X  +  -0.962941 * Y  +  -0.038408 * Z  +  12.057527 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.610662    1.530931  [ DEG:   -92.2841     87.7159 ]
  Theta =   0.270241    2.871352  [ DEG:    15.4836    164.5164 ]
  Phi   =   1.306773   -1.834820  [ DEG:    74.8726   -105.1274 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2k1z_A                                        
REMARK     2: T0488.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2k1z_A.T0488.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  104   95   5.0   89   1.83   26.97  85.148
REMARK  ---------------------------------------------------------- 
MOLECULE 2k1z_A
HEADER    SIGNALING PROTEIN                       18-MAR-08   2K1Z              
TITLE     SOLUTION STRUCTURE OF PAR-3 PDZ3                                      
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PARTITIONING-DEFECTIVE 3 HOMOLOG;                          
COMPND   3 CHAIN: A;                                                            
COMPND   4 FRAGMENT: PDZ 3 DOMAIN;                                              
COMPND   5 SYNONYM: PARD-3, PAR-3, ATYPICAL PKC ISOTYPE-SPECIFIC-               
COMPND   6 INTERACTING PROTEIN, ASIP, ATYPICAL PKC-SPECIFIC-BINDING             
COMPND   7 PROTEIN, ASBP;                                                       
COMPND   8 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: RATTUS NORVEGICUS;                              
SOURCE   3 ORGANISM_COMMON: RAT;                                                
SOURCE   4 GENE: PARD3, PAR3;                                                   
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_VECTOR: PET32A                                     
KEYWDS    PAR-3, PDZ DOMAIN, SCAFFOLD PROTEIN, CELL POLARITY,                   
KEYWDS   2 ALTERNATIVE SPLICING, CELL CYCLE, CELL DIVISION, CELL                
KEYWDS   3 JUNCTION, COILED COIL, MEMBRANE, PHOSPHOPROTEIN, TIGHT               
KEYWDS   4 JUNCTION, SIGNALING PROTEIN                                          
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    W.FENG,H.WU,L.CHAN,M.ZHANG                                            
REVDAT   1   10-JUN-08 2K1Z    0                                                
JRNL        AUTH   W.FENG,H.WU,L.CHAN,M.ZHANG                                   
JRNL        TITL   SOLUTION STRUCTURE OF PAR-3 PDZ3                             
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2K1Z A    7   110  UNP    Q9Z340   PARD3_RAT      582    685             
SEQRES   1 A  104  GLY THR ARG GLU PHE LEU THR PHE GLU VAL PRO LEU ASN          
SEQRES   2 A  104  ASP SER GLY SER ALA GLY LEU GLY VAL SER VAL LYS GLY          
SEQRES   3 A  104  ASN ARG SER LYS GLU ASN HIS ALA ASP LEU GLY ILE PHE          
SEQRES   4 A  104  VAL LYS SER ILE ILE ASN GLY GLY ALA ALA SER LYS ASP          
SEQRES   5 A  104  GLY ARG LEU ARG VAL ASN ASP GLN LEU ILE ALA VAL ASN          
SEQRES   6 A  104  GLY GLU SER LEU LEU GLY LYS ALA ASN GLN GLU ALA MET          
SEQRES   7 A  104  GLU THR LEU ARG ARG SER MET SER THR GLU GLY ASN LYS          
SEQRES   8 A  104  ARG GLY MET ILE GLN LEU ILE VAL ALA ARG ARG ILE SER          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   GLY A   7      18.606  11.892  27.312  1.00  0.00           N  
ATOM      2  CA  GLY A   7      18.978  13.293  27.276  1.00  0.00           C  
ATOM      3  C   GLY A   7      20.010  13.567  26.207  1.00  0.00           C  
ATOM      4  O   GLY A   7      20.825  14.482  26.333  1.00  0.00           O  
ATOM      5  H1  GLY A   7      19.040  11.258  26.701  1.00  0.00           H  
ATOM      6  HA2 GLY A   7      18.097  13.885  27.076  1.00  0.00           H  
ATOM      7  HA3 GLY A   7      19.382  13.574  28.237  1.00  0.00           H  
ATOM      8  N   THR A   8      19.980  12.757  25.156  1.00  0.00           N  
ATOM      9  CA  THR A   8      20.919  12.892  24.055  1.00  0.00           C  
ATOM     10  C   THR A   8      20.189  13.078  22.732  1.00  0.00           C  
ATOM     11  O   THR A   8      19.168  12.439  22.478  1.00  0.00           O  
ATOM     12  CB  THR A   8      21.838  11.672  24.006  1.00  0.00           C  
ATOM     13  OG1 THR A   8      21.232  10.562  24.647  1.00  0.00           O  
ATOM     14  CG2 THR A   8      23.174  11.910  24.671  1.00  0.00           C  
ATOM     15  H   THR A   8      19.305  12.043  25.126  1.00  0.00           H  
ATOM     16  HA  THR A   8      21.519  13.763  24.230  1.00  0.00           H  
ATOM     17  HB  THR A   8      22.023  11.412  22.979  1.00  0.00           H  
ATOM     18  HG1 THR A   8      20.316  10.494  24.372  1.00  0.00           H  
ATOM     19 HG21 THR A   8      23.019  12.364  25.639  1.00  0.00           H  
ATOM     20 HG22 THR A   8      23.769  12.568  24.057  1.00  0.00           H  
ATOM     21 HG23 THR A   8      23.687  10.968  24.793  1.00  0.00           H  
ATOM     22  N   ARG A   9      20.717  13.969  21.893  1.00  0.00           N  
ATOM     23  CA  ARG A   9      20.115  14.256  20.595  1.00  0.00           C  
ATOM     24  C   ARG A   9      21.155  14.164  19.482  1.00  0.00           C  
ATOM     25  O   ARG A   9      22.357  14.209  19.739  1.00  0.00           O  
ATOM     26  CB  ARG A   9      19.484  15.648  20.599  1.00  0.00           C  
ATOM     27  CG  ARG A   9      18.500  15.865  21.736  1.00  0.00           C  
ATOM     28  CD  ARG A   9      17.962  17.287  21.742  1.00  0.00           C  
ATOM     29  NE  ARG A   9      18.944  18.241  22.251  1.00  0.00           N  
ATOM     30  CZ  ARG A   9      19.205  18.415  23.546  1.00  0.00           C  
ATOM     31  NH1 ARG A   9      18.560  17.704  24.462  1.00  0.00           N  
ATOM     32  NH2 ARG A   9      20.114  19.303  23.923  1.00  0.00           N  
ATOM     33  H   ARG A   9      21.526  14.450  22.160  1.00  0.00           H  
ATOM     34  HA  ARG A   9      19.344  13.522  20.415  1.00  0.00           H  
ATOM     35  HB2 ARG A   9      20.269  16.386  20.684  1.00  0.00           H  
ATOM     36  HB3 ARG A   9      18.961  15.798  19.666  1.00  0.00           H  
ATOM     37  HG2 ARG A   9      17.676  15.179  21.621  1.00  0.00           H  
ATOM     38  HG3 ARG A   9      19.001  15.676  22.674  1.00  0.00           H  
ATOM     39  HD2 ARG A   9      17.698  17.563  20.733  1.00  0.00           H  
ATOM     40  HD3 ARG A   9      17.082  17.322  22.366  1.00  0.00           H  
ATOM     41  HE  ARG A   9      19.434  18.781  21.596  1.00  0.00           H  
ATOM     42 HH11 ARG A   9      17.872  17.034  24.184  1.00  0.00           H  
ATOM     43 HH12 ARG A   9      18.761  17.840  25.433  1.00  0.00           H  
ATOM     44 HH21 ARG A   9      20.604  19.842  23.238  1.00  0.00           H  
ATOM     45 HH22 ARG A   9      20.313  19.433  24.896  1.00  0.00           H  
ATOM     46  N   GLU A  10      20.683  14.038  18.245  1.00  0.00           N  
ATOM     47  CA  GLU A  10      21.575  13.943  17.094  1.00  0.00           C  
ATOM     48  C   GLU A  10      20.946  14.587  15.861  1.00  0.00           C  
ATOM     49  O   GLU A  10      19.809  14.282  15.501  1.00  0.00           O  
ATOM     50  CB  GLU A  10      21.914  12.480  16.803  1.00  0.00           C  
ATOM     51  CG  GLU A  10      20.692  11.586  16.675  1.00  0.00           C  
ATOM     52  CD  GLU A  10      21.012  10.252  16.030  1.00  0.00           C  
ATOM     53  OE1 GLU A  10      21.720  10.244  15.003  1.00  0.00           O  
ATOM     54  OE2 GLU A  10      20.553   9.215  16.555  1.00  0.00           O  
ATOM     55  H   GLU A  10      19.713  14.008  18.103  1.00  0.00           H  
ATOM     56  HA  GLU A  10      22.484  14.474  17.337  1.00  0.00           H  
ATOM     57  HB2 GLU A  10      22.471  12.429  15.881  1.00  0.00           H  
ATOM     58  HB3 GLU A  10      22.529  12.100  17.606  1.00  0.00           H  
ATOM     59  HG2 GLU A  10      20.289  11.406  17.660  1.00  0.00           H  
ATOM     60  HG3 GLU A  10      19.955  12.094  16.072  1.00  0.00           H  
ATOM     61  N   PHE A  11      21.696  15.477  15.218  1.00  0.00           N  
ATOM     62  CA  PHE A  11      21.214  16.163  14.024  1.00  0.00           C  
ATOM     63  C   PHE A  11      21.233  15.230  12.816  1.00  0.00           C  
ATOM     64  O   PHE A  11      22.123  14.388  12.687  1.00  0.00           O  
ATOM     65  CB  PHE A  11      22.072  17.397  13.738  1.00  0.00           C  
ATOM     66  CG  PHE A  11      21.711  18.589  14.580  1.00  0.00           C  
ATOM     67  CD1 PHE A  11      20.739  19.481  14.160  1.00  0.00           C  
ATOM     68  CD2 PHE A  11      22.348  18.815  15.789  1.00  0.00           C  
ATOM     69  CE1 PHE A  11      20.406  20.578  14.933  1.00  0.00           C  
ATOM     70  CE2 PHE A  11      22.021  19.909  16.566  1.00  0.00           C  
ATOM     71  CZ  PHE A  11      21.047  20.793  16.138  1.00  0.00           C  
ATOM     72  H   PHE A  11      22.595  15.676  15.554  1.00  0.00           H  
ATOM     73  HA  PHE A  11      20.197  16.477  14.207  1.00  0.00           H  
ATOM     74  HB2 PHE A  11      23.108  17.159  13.926  1.00  0.00           H  
ATOM     75  HB3 PHE A  11      21.956  17.675  12.701  1.00  0.00           H  
ATOM     76  HD1 PHE A  11      20.237  19.313  13.219  1.00  0.00           H  
ATOM     77  HD2 PHE A  11      23.110  18.126  16.126  1.00  0.00           H  
ATOM     78  HE1 PHE A  11      19.645  21.265  14.595  1.00  0.00           H  
ATOM     79  HE2 PHE A  11      22.525  20.075  17.507  1.00  0.00           H  
ATOM     80  HZ  PHE A  11      20.789  21.649  16.742  1.00  0.00           H  
ATOM     81  N   LEU A  12      20.246  15.381  11.938  1.00  0.00           N  
ATOM     82  CA  LEU A  12      20.157  14.547  10.745  1.00  0.00           C  
ATOM     83  C   LEU A  12      19.718  15.360   9.533  1.00  0.00           C  
ATOM     84  O   LEU A  12      18.841  16.217   9.628  1.00  0.00           O  
ATOM     85  CB  LEU A  12      19.178  13.394  10.974  1.00  0.00           C  
ATOM     86  CG  LEU A  12      19.251  12.746  12.355  1.00  0.00           C  
ATOM     87  CD1 LEU A  12      17.914  12.120  12.723  1.00  0.00           C  
ATOM     88  CD2 LEU A  12      20.359  11.704  12.398  1.00  0.00           C  
ATOM     89  H   LEU A  12      19.565  16.069  12.094  1.00  0.00           H  
ATOM     90  HA  LEU A  12      21.139  14.139  10.552  1.00  0.00           H  
ATOM     91  HB2 LEU A  12      18.175  13.767  10.826  1.00  0.00           H  
ATOM     92  HB3 LEU A  12      19.374  12.632  10.233  1.00  0.00           H  
ATOM     93  HG  LEU A  12      19.476  13.504  13.088  1.00  0.00           H  
ATOM     94 HD11 LEU A  12      17.722  12.272  13.775  1.00  0.00           H  
ATOM     95 HD12 LEU A  12      17.942  11.061  12.510  1.00  0.00           H  
ATOM     96 HD13 LEU A  12      17.129  12.584  12.145  1.00  0.00           H  
ATOM     97 HD21 LEU A  12      21.089  11.924  11.632  1.00  0.00           H  
ATOM     98 HD22 LEU A  12      19.938  10.725  12.226  1.00  0.00           H  
ATOM     99 HD23 LEU A  12      20.836  11.726  13.366  1.00  0.00           H  
ATOM    100  N   THR A  13      20.333  15.073   8.389  1.00  0.00           N  
ATOM    101  CA  THR A  13      20.008  15.765   7.146  1.00  0.00           C  
ATOM    102  C   THR A  13      19.312  14.813   6.180  1.00  0.00           C  
ATOM    103  O   THR A  13      19.757  13.680   5.989  1.00  0.00           O  
ATOM    104  CB  THR A  13      21.274  16.329   6.501  1.00  0.00           C  
ATOM    105  OG1 THR A  13      22.013  17.098   7.433  1.00  0.00           O  
ATOM    106  CG2 THR A  13      20.993  17.207   5.301  1.00  0.00           C  
ATOM    107  H   THR A  13      21.019  14.374   8.381  1.00  0.00           H  
ATOM    108  HA  THR A  13      19.336  16.576   7.381  1.00  0.00           H  
ATOM    109  HB  THR A  13      21.894  15.507   6.172  1.00  0.00           H  
ATOM    110  HG1 THR A  13      22.942  17.089   7.192  1.00  0.00           H  
ATOM    111 HG21 THR A  13      21.507  18.150   5.415  1.00  0.00           H  
ATOM    112 HG22 THR A  13      19.931  17.381   5.223  1.00  0.00           H  
ATOM    113 HG23 THR A  13      21.342  16.713   4.405  1.00  0.00           H  
ATOM    114  N   PHE A  14      18.216  15.266   5.581  1.00  0.00           N  
ATOM    115  CA  PHE A  14      17.468  14.429   4.648  1.00  0.00           C  
ATOM    116  C   PHE A  14      17.122  15.175   3.362  1.00  0.00           C  
ATOM    117  O   PHE A  14      16.514  16.243   3.391  1.00  0.00           O  
ATOM    118  CB  PHE A  14      16.186  13.923   5.312  1.00  0.00           C  
ATOM    119  CG  PHE A  14      16.420  13.240   6.630  1.00  0.00           C  
ATOM    120  CD1 PHE A  14      17.469  12.349   6.789  1.00  0.00           C  
ATOM    121  CD2 PHE A  14      15.590  13.492   7.711  1.00  0.00           C  
ATOM    122  CE1 PHE A  14      17.685  11.721   8.000  1.00  0.00           C  
ATOM    123  CE2 PHE A  14      15.802  12.866   8.925  1.00  0.00           C  
ATOM    124  CZ  PHE A  14      16.850  11.980   9.070  1.00  0.00           C  
ATOM    125  H   PHE A  14      17.899  16.174   5.776  1.00  0.00           H  
ATOM    126  HA  PHE A  14      18.088  13.582   4.400  1.00  0.00           H  
ATOM    127  HB2 PHE A  14      15.524  14.757   5.483  1.00  0.00           H  
ATOM    128  HB3 PHE A  14      15.703  13.216   4.653  1.00  0.00           H  
ATOM    129  HD1 PHE A  14      18.121  12.146   5.954  1.00  0.00           H  
ATOM    130  HD2 PHE A  14      14.770  14.186   7.599  1.00  0.00           H  
ATOM    131  HE1 PHE A  14      18.505  11.027   8.111  1.00  0.00           H  
ATOM    132  HE2 PHE A  14      15.148  13.071   9.759  1.00  0.00           H  
ATOM    133  HZ  PHE A  14      17.017  11.490  10.018  1.00  0.00           H  
ATOM    134  N   GLU A  15      17.499  14.581   2.231  1.00  0.00           N  
ATOM    135  CA  GLU A  15      17.216  15.157   0.922  1.00  0.00           C  
ATOM    136  C   GLU A  15      15.956  14.524   0.345  1.00  0.00           C  
ATOM    137  O   GLU A  15      15.978  13.376  -0.099  1.00  0.00           O  
ATOM    138  CB  GLU A  15      18.398  14.936  -0.024  1.00  0.00           C  
ATOM    139  CG  GLU A  15      19.697  15.549   0.471  1.00  0.00           C  
ATOM    140  CD  GLU A  15      20.539  14.569   1.262  1.00  0.00           C  
ATOM    141  OE1 GLU A  15      19.982  13.562   1.745  1.00  0.00           O  
ATOM    142  OE2 GLU A  15      21.759  14.807   1.397  1.00  0.00           O  
ATOM    143  H   GLU A  15      17.965  13.721   2.280  1.00  0.00           H  
ATOM    144  HA  GLU A  15      17.052  16.219   1.046  1.00  0.00           H  
ATOM    145  HB2 GLU A  15      18.551  13.874  -0.147  1.00  0.00           H  
ATOM    146  HB3 GLU A  15      18.164  15.369  -0.984  1.00  0.00           H  
ATOM    147  HG2 GLU A  15      20.268  15.889  -0.380  1.00  0.00           H  
ATOM    148  HG3 GLU A  15      19.463  16.393   1.106  1.00  0.00           H  
ATOM    149  N   VAL A  16      14.854  15.265   0.375  1.00  0.00           N  
ATOM    150  CA  VAL A  16      13.580  14.754  -0.124  1.00  0.00           C  
ATOM    151  C   VAL A  16      13.277  15.268  -1.532  1.00  0.00           C  
ATOM    152  O   VAL A  16      13.026  16.458  -1.724  1.00  0.00           O  
ATOM    153  CB  VAL A  16      12.415  15.134   0.814  1.00  0.00           C  
ATOM    154  CG1 VAL A  16      11.372  14.025   0.841  1.00  0.00           C  
ATOM    155  CG2 VAL A  16      12.916  15.427   2.221  1.00  0.00           C  
ATOM    156  H   VAL A  16      14.894  16.167   0.754  1.00  0.00           H  
ATOM    157  HA  VAL A  16      13.648  13.678  -0.153  1.00  0.00           H  
ATOM    158  HB  VAL A  16      11.948  16.028   0.431  1.00  0.00           H  
ATOM    159 HG11 VAL A  16      11.513  13.377  -0.011  1.00  0.00           H  
ATOM    160 HG12 VAL A  16      10.383  14.456   0.803  1.00  0.00           H  
ATOM    161 HG13 VAL A  16      11.480  13.452   1.749  1.00  0.00           H  
ATOM    162 HG21 VAL A  16      12.146  15.177   2.937  1.00  0.00           H  
ATOM    163 HG22 VAL A  16      13.160  16.475   2.305  1.00  0.00           H  
ATOM    164 HG23 VAL A  16      13.797  14.836   2.419  1.00  0.00           H  
ATOM    165  N   PRO A  17      13.297  14.373  -2.538  1.00  0.00           N  
ATOM    166  CA  PRO A  17      13.025  14.737  -3.930  1.00  0.00           C  
ATOM    167  C   PRO A  17      11.535  14.781  -4.252  1.00  0.00           C  
ATOM    168  O   PRO A  17      10.919  13.745  -4.512  1.00  0.00           O  
ATOM    169  CB  PRO A  17      13.700  13.613  -4.709  1.00  0.00           C  
ATOM    170  CG  PRO A  17      13.572  12.420  -3.823  1.00  0.00           C  
ATOM    171  CD  PRO A  17      13.591  12.931  -2.404  1.00  0.00           C  
ATOM    172  HA  PRO A  17      13.476  15.679  -4.191  1.00  0.00           H  
ATOM    173  HB2 PRO A  17      13.190  13.465  -5.649  1.00  0.00           H  
ATOM    174  HB3 PRO A  17      14.735  13.864  -4.887  1.00  0.00           H  
ATOM    175  HG2 PRO A  17      12.640  11.913  -4.024  1.00  0.00           H  
ATOM    176  HG3 PRO A  17      14.405  11.752  -3.990  1.00  0.00           H  
ATOM    177  HD2 PRO A  17      12.831  12.439  -1.816  1.00  0.00           H  
ATOM    178  HD3 PRO A  17      14.565  12.781  -1.963  1.00  0.00           H  
ATOM    179  N   LEU A  18      10.959  15.983  -4.252  1.00  0.00           N  
ATOM    180  CA  LEU A  18       9.540  16.148  -4.556  1.00  0.00           C  
ATOM    181  C   LEU A  18       9.326  16.382  -6.046  1.00  0.00           C  
ATOM    182  O   LEU A  18       8.318  16.957  -6.460  1.00  0.00           O  
ATOM    183  CB  LEU A  18       8.953  17.303  -3.759  1.00  0.00           C  
ATOM    184  CG  LEU A  18       9.373  18.684  -4.242  1.00  0.00           C  
ATOM    185  CD1 LEU A  18       8.269  19.316  -5.082  1.00  0.00           C  
ATOM    186  CD2 LEU A  18       9.727  19.575  -3.061  1.00  0.00           C  
ATOM    187  H   LEU A  18      11.500  16.773  -4.050  1.00  0.00           H  
ATOM    188  HA  LEU A  18       9.041  15.239  -4.279  1.00  0.00           H  
ATOM    189  HB2 LEU A  18       7.877  17.238  -3.804  1.00  0.00           H  
ATOM    190  HB3 LEU A  18       9.262  17.196  -2.735  1.00  0.00           H  
ATOM    191  HG  LEU A  18      10.251  18.573  -4.863  1.00  0.00           H  
ATOM    192 HD11 LEU A  18       8.612  19.432  -6.100  1.00  0.00           H  
ATOM    193 HD12 LEU A  18       8.014  20.285  -4.677  1.00  0.00           H  
ATOM    194 HD13 LEU A  18       7.395  18.681  -5.068  1.00  0.00           H  
ATOM    195 HD21 LEU A  18      10.601  20.161  -3.302  1.00  0.00           H  
ATOM    196 HD22 LEU A  18       9.932  18.963  -2.195  1.00  0.00           H  
ATOM    197 HD23 LEU A  18       8.899  20.236  -2.846  1.00  0.00           H  
ATOM    198  N   ASN A  19      10.282  15.922  -6.839  1.00  0.00           N  
ATOM    199  CA  ASN A  19      10.237  16.052  -8.291  1.00  0.00           C  
ATOM    200  C   ASN A  19       8.825  15.837  -8.841  1.00  0.00           C  
ATOM    201  O   ASN A  19       8.461  16.404  -9.871  1.00  0.00           O  
ATOM    202  CB  ASN A  19      11.201  15.041  -8.916  1.00  0.00           C  
ATOM    203  CG  ASN A  19      10.672  13.614  -8.879  1.00  0.00           C  
ATOM    204  OD1 ASN A  19      10.674  12.915  -9.892  1.00  0.00           O  
ATOM    205  ND2 ASN A  19      10.213  13.169  -7.706  1.00  0.00           N  
ATOM    206  H   ASN A  19      11.047  15.475  -6.435  1.00  0.00           H  
ATOM    207  HA  ASN A  19      10.561  17.048  -8.546  1.00  0.00           H  
ATOM    208  HB2 ASN A  19      11.375  15.313  -9.947  1.00  0.00           H  
ATOM    209  HB3 ASN A  19      12.138  15.072  -8.378  1.00  0.00           H  
ATOM    210 HD21 ASN A  19      10.239  13.775  -6.937  1.00  0.00           H  
ATOM    211 HD22 ASN A  19       9.863  12.251  -7.662  1.00  0.00           H  
ATOM    212  N   ASP A  20       8.040  15.014  -8.152  1.00  0.00           N  
ATOM    213  CA  ASP A  20       6.676  14.730  -8.587  1.00  0.00           C  
ATOM    214  C   ASP A  20       5.749  14.485  -7.398  1.00  0.00           C  
ATOM    215  O   ASP A  20       4.715  13.834  -7.536  1.00  0.00           O  
ATOM    216  CB  ASP A  20       6.660  13.515  -9.517  1.00  0.00           C  
ATOM    217  CG  ASP A  20       7.249  12.279  -8.865  1.00  0.00           C  
ATOM    218  OD1 ASP A  20       7.315  12.241  -7.619  1.00  0.00           O  
ATOM    219  OD2 ASP A  20       7.642  11.350  -9.602  1.00  0.00           O  
ATOM    220  H   ASP A  20       8.385  14.587  -7.341  1.00  0.00           H  
ATOM    221  HA  ASP A  20       6.320  15.591  -9.130  1.00  0.00           H  
ATOM    222  HB2 ASP A  20       5.640  13.300  -9.799  1.00  0.00           H  
ATOM    223  HB3 ASP A  20       7.235  13.742 -10.404  1.00  0.00           H  
ATOM    224  N   SER A  21       6.118  15.010  -6.234  1.00  0.00           N  
ATOM    225  CA  SER A  21       5.304  14.842  -5.035  1.00  0.00           C  
ATOM    226  C   SER A  21       4.704  16.175  -4.586  1.00  0.00           C  
ATOM    227  O   SER A  21       3.800  16.206  -3.752  1.00  0.00           O  
ATOM    228  CB  SER A  21       6.135  14.233  -3.906  1.00  0.00           C  
ATOM    229  OG  SER A  21       7.061  15.171  -3.388  1.00  0.00           O  
ATOM    230  H   SER A  21       6.953  15.523  -6.178  1.00  0.00           H  
ATOM    231  HA  SER A  21       4.500  14.167  -5.277  1.00  0.00           H  
ATOM    232  HB2 SER A  21       5.478  13.917  -3.110  1.00  0.00           H  
ATOM    233  HB3 SER A  21       6.679  13.381  -4.285  1.00  0.00           H  
ATOM    234  HG  SER A  21       6.597  15.967  -3.124  1.00  0.00           H  
ATOM    235  N   GLY A  22       5.212  17.274  -5.144  1.00  0.00           N  
ATOM    236  CA  GLY A  22       4.713  18.591  -4.786  1.00  0.00           C  
ATOM    237  C   GLY A  22       3.200  18.686  -4.855  1.00  0.00           C  
ATOM    238  O   GLY A  22       2.590  19.500  -4.163  1.00  0.00           O  
ATOM    239  H   GLY A  22       5.933  17.190  -5.802  1.00  0.00           H  
ATOM    240  HA2 GLY A  22       5.029  18.821  -3.780  1.00  0.00           H  
ATOM    241  HA3 GLY A  22       5.139  19.320  -5.460  1.00  0.00           H  
ATOM    242  N   SER A  23       2.591  17.848  -5.691  1.00  0.00           N  
ATOM    243  CA  SER A  23       1.140  17.840  -5.845  1.00  0.00           C  
ATOM    244  C   SER A  23       0.452  17.658  -4.495  1.00  0.00           C  
ATOM    245  O   SER A  23      -0.653  18.152  -4.275  1.00  0.00           O  
ATOM    246  CB  SER A  23       0.712  16.730  -6.804  1.00  0.00           C  
ATOM    247  OG  SER A  23      -0.685  16.765  -7.035  1.00  0.00           O  
ATOM    248  H   SER A  23       3.130  17.220  -6.215  1.00  0.00           H  
ATOM    249  HA  SER A  23       0.846  18.795  -6.258  1.00  0.00           H  
ATOM    250  HB2 SER A  23       1.223  16.853  -7.746  1.00  0.00           H  
ATOM    251  HB3 SER A  23       0.969  15.770  -6.377  1.00  0.00           H  
ATOM    252  HG  SER A  23      -0.874  16.416  -7.910  1.00  0.00           H  
ATOM    253  N   ALA A  24       1.119  16.945  -3.592  1.00  0.00           N  
ATOM    254  CA  ALA A  24       0.580  16.696  -2.262  1.00  0.00           C  
ATOM    255  C   ALA A  24       1.302  17.538  -1.214  1.00  0.00           C  
ATOM    256  O   ALA A  24       0.733  17.877  -0.177  1.00  0.00           O  
ATOM    257  CB  ALA A  24       0.689  15.218  -1.918  1.00  0.00           C  
ATOM    258  H   ALA A  24       1.997  16.580  -3.827  1.00  0.00           H  
ATOM    259  HA  ALA A  24      -0.466  16.965  -2.269  1.00  0.00           H  
ATOM    260  HB1 ALA A  24      -0.190  14.909  -1.373  1.00  0.00           H  
ATOM    261  HB2 ALA A  24       1.567  15.052  -1.310  1.00  0.00           H  
ATOM    262  HB3 ALA A  24       0.769  14.641  -2.829  1.00  0.00           H  
ATOM    263  N   GLY A  25       2.559  17.869  -1.495  1.00  0.00           N  
ATOM    264  CA  GLY A  25       3.342  18.667  -0.569  1.00  0.00           C  
ATOM    265  C   GLY A  25       4.517  17.899   0.002  1.00  0.00           C  
ATOM    266  O   GLY A  25       4.786  17.967   1.201  1.00  0.00           O  
ATOM    267  H   GLY A  25       2.959  17.568  -2.336  1.00  0.00           H  
ATOM    268  HA2 GLY A  25       3.716  19.537  -1.091  1.00  0.00           H  
ATOM    269  HA3 GLY A  25       2.708  18.990   0.242  1.00  0.00           H  
ATOM    270  N   LEU A  26       5.213  17.169  -0.870  1.00  0.00           N  
ATOM    271  CA  LEU A  26       6.380  16.369  -0.487  1.00  0.00           C  
ATOM    272  C   LEU A  26       5.988  14.974  -0.015  1.00  0.00           C  
ATOM    273  O   LEU A  26       6.799  14.048  -0.072  1.00  0.00           O  
ATOM    274  CB  LEU A  26       7.209  17.064   0.598  1.00  0.00           C  
ATOM    275  CG  LEU A  26       8.603  16.474   0.806  1.00  0.00           C  
ATOM    276  CD1 LEU A  26       9.374  16.457  -0.504  1.00  0.00           C  
ATOM    277  CD2 LEU A  26       9.365  17.260   1.860  1.00  0.00           C  
ATOM    278  H   LEU A  26       4.935  17.170  -1.809  1.00  0.00           H  
ATOM    279  HA  LEU A  26       6.992  16.266  -1.367  1.00  0.00           H  
ATOM    280  HB2 LEU A  26       7.314  18.107   0.333  1.00  0.00           H  
ATOM    281  HB3 LEU A  26       6.672  16.998   1.532  1.00  0.00           H  
ATOM    282  HG  LEU A  26       8.507  15.454   1.152  1.00  0.00           H  
ATOM    283 HD11 LEU A  26       9.531  17.471  -0.840  1.00  0.00           H  
ATOM    284 HD12 LEU A  26       8.812  15.914  -1.247  1.00  0.00           H  
ATOM    285 HD13 LEU A  26      10.327  15.978  -0.355  1.00  0.00           H  
ATOM    286 HD21 LEU A  26      10.309  16.778   2.057  1.00  0.00           H  
ATOM    287 HD22 LEU A  26       8.783  17.299   2.769  1.00  0.00           H  
ATOM    288 HD23 LEU A  26       9.541  18.263   1.501  1.00  0.00           H  
ATOM    289  N   GLY A  27       4.755  14.817   0.457  1.00  0.00           N  
ATOM    290  CA  GLY A  27       4.317  13.524   0.929  1.00  0.00           C  
ATOM    291  C   GLY A  27       4.595  13.330   2.403  1.00  0.00           C  
ATOM    292  O   GLY A  27       5.129  12.300   2.810  1.00  0.00           O  
ATOM    293  H   GLY A  27       4.142  15.577   0.491  1.00  0.00           H  
ATOM    294  HA2 GLY A  27       3.254  13.433   0.757  1.00  0.00           H  
ATOM    295  HA3 GLY A  27       4.830  12.754   0.370  1.00  0.00           H  
ATOM    296  N   VAL A  28       4.217  14.320   3.207  1.00  0.00           N  
ATOM    297  CA  VAL A  28       4.416  14.252   4.652  1.00  0.00           C  
ATOM    298  C   VAL A  28       3.630  15.341   5.375  1.00  0.00           C  
ATOM    299  O   VAL A  28       3.317  16.385   4.800  1.00  0.00           O  
ATOM    300  CB  VAL A  28       5.908  14.377   5.045  1.00  0.00           C  
ATOM    301  CG1 VAL A  28       6.479  13.019   5.418  1.00  0.00           C  
ATOM    302  CG2 VAL A  28       6.719  15.017   3.928  1.00  0.00           C  
ATOM    303  H   VAL A  28       3.785  15.109   2.821  1.00  0.00           H  
ATOM    304  HA  VAL A  28       4.059  13.289   4.985  1.00  0.00           H  
ATOM    305  HB  VAL A  28       5.974  15.015   5.915  1.00  0.00           H  
ATOM    306 HG11 VAL A  28       6.033  12.261   4.797  1.00  0.00           H  
ATOM    307 HG12 VAL A  28       6.262  12.810   6.454  1.00  0.00           H  
ATOM    308 HG13 VAL A  28       7.548  13.025   5.266  1.00  0.00           H  
ATOM    309 HG21 VAL A  28       7.728  15.195   4.269  1.00  0.00           H  
ATOM    310 HG22 VAL A  28       6.265  15.956   3.645  1.00  0.00           H  
ATOM    311 HG23 VAL A  28       6.741  14.358   3.073  1.00  0.00           H  
ATOM    312  N   SER A  29       3.327  15.090   6.644  1.00  0.00           N  
ATOM    313  CA  SER A  29       2.591  16.041   7.465  1.00  0.00           C  
ATOM    314  C   SER A  29       3.324  16.275   8.780  1.00  0.00           C  
ATOM    315  O   SER A  29       3.762  15.328   9.431  1.00  0.00           O  
ATOM    316  CB  SER A  29       1.175  15.531   7.736  1.00  0.00           C  
ATOM    317  OG  SER A  29       0.691  14.764   6.646  1.00  0.00           O  
ATOM    318  H   SER A  29       3.615  14.241   7.042  1.00  0.00           H  
ATOM    319  HA  SER A  29       2.535  16.974   6.924  1.00  0.00           H  
ATOM    320  HB2 SER A  29       1.180  14.912   8.621  1.00  0.00           H  
ATOM    321  HB3 SER A  29       0.514  16.372   7.889  1.00  0.00           H  
ATOM    322  HG  SER A  29       0.895  15.211   5.824  1.00  0.00           H  
ATOM    323  N   VAL A  30       3.468  17.539   9.162  1.00  0.00           N  
ATOM    324  CA  VAL A  30       4.164  17.882  10.399  1.00  0.00           C  
ATOM    325  C   VAL A  30       3.233  18.540  11.409  1.00  0.00           C  
ATOM    326  O   VAL A  30       2.217  19.135  11.043  1.00  0.00           O  
ATOM    327  CB  VAL A  30       5.359  18.823  10.135  1.00  0.00           C  
ATOM    328  CG1 VAL A  30       6.353  18.750  11.283  1.00  0.00           C  
ATOM    329  CG2 VAL A  30       6.036  18.479   8.816  1.00  0.00           C  
ATOM    330  H   VAL A  30       3.106  18.256   8.601  1.00  0.00           H  
ATOM    331  HA  VAL A  30       4.548  16.969  10.825  1.00  0.00           H  
ATOM    332  HB  VAL A  30       4.988  19.835  10.074  1.00  0.00           H  
ATOM    333 HG11 VAL A  30       7.201  19.380  11.063  1.00  0.00           H  
ATOM    334 HG12 VAL A  30       6.686  17.730  11.405  1.00  0.00           H  
ATOM    335 HG13 VAL A  30       5.878  19.086  12.192  1.00  0.00           H  
ATOM    336 HG21 VAL A  30       5.488  18.931   8.001  1.00  0.00           H  
ATOM    337 HG22 VAL A  30       6.053  17.408   8.686  1.00  0.00           H  
ATOM    338 HG23 VAL A  30       7.048  18.858   8.821  1.00  0.00           H  
ATOM    339  N   LYS A  31       3.589  18.425  12.684  1.00  0.00           N  
ATOM    340  CA  LYS A  31       2.796  19.004  13.761  1.00  0.00           C  
ATOM    341  C   LYS A  31       3.701  19.692  14.782  1.00  0.00           C  
ATOM    342  O   LYS A  31       4.725  19.142  15.189  1.00  0.00           O  
ATOM    343  CB  LYS A  31       1.942  17.921  14.430  1.00  0.00           C  
ATOM    344  CG  LYS A  31       2.668  17.131  15.506  1.00  0.00           C  
ATOM    345  CD  LYS A  31       2.620  17.854  16.837  1.00  0.00           C  
ATOM    346  CE  LYS A  31       2.589  16.879  18.003  1.00  0.00           C  
ATOM    347  NZ  LYS A  31       1.206  16.418  18.303  1.00  0.00           N  
ATOM    348  H   LYS A  31       4.410  17.939  12.906  1.00  0.00           H  
ATOM    349  HA  LYS A  31       2.143  19.745  13.332  1.00  0.00           H  
ATOM    350  HB2 LYS A  31       1.080  18.390  14.882  1.00  0.00           H  
ATOM    351  HB3 LYS A  31       1.605  17.228  13.672  1.00  0.00           H  
ATOM    352  HG2 LYS A  31       2.197  16.165  15.613  1.00  0.00           H  
ATOM    353  HG3 LYS A  31       3.701  17.002  15.210  1.00  0.00           H  
ATOM    354  HD2 LYS A  31       3.496  18.481  16.925  1.00  0.00           H  
ATOM    355  HD3 LYS A  31       1.732  18.469  16.866  1.00  0.00           H  
ATOM    356  HE2 LYS A  31       3.198  16.023  17.755  1.00  0.00           H  
ATOM    357  HE3 LYS A  31       2.995  17.370  18.876  1.00  0.00           H  
ATOM    358  HZ1 LYS A  31       0.840  15.846  17.515  1.00  0.00           H  
ATOM    359  HZ2 LYS A  31       0.578  17.237  18.443  1.00  0.00           H  
ATOM    360  HZ3 LYS A  31       1.201  15.840  19.168  1.00  0.00           H  
ATOM    361  N   GLY A  32       3.319  20.900  15.186  1.00  0.00           N  
ATOM    362  CA  GLY A  32       4.110  21.643  16.150  1.00  0.00           C  
ATOM    363  C   GLY A  32       3.447  21.723  17.511  1.00  0.00           C  
ATOM    364  O   GLY A  32       2.222  21.763  17.611  1.00  0.00           O  
ATOM    365  H   GLY A  32       2.497  21.289  14.825  1.00  0.00           H  
ATOM    366  HA2 GLY A  32       5.071  21.162  16.257  1.00  0.00           H  
ATOM    367  HA3 GLY A  32       4.263  22.645  15.776  1.00  0.00           H  
ATOM    368  N   ASN A  33       4.264  21.746  18.561  1.00  0.00           N  
ATOM    369  CA  ASN A  33       3.749  21.821  19.924  1.00  0.00           C  
ATOM    370  C   ASN A  33       4.554  22.812  20.759  1.00  0.00           C  
ATOM    371  O   ASN A  33       5.446  23.489  20.250  1.00  0.00           O  
ATOM    372  CB  ASN A  33       3.781  20.439  20.580  1.00  0.00           C  
ATOM    373  CG  ASN A  33       2.438  19.743  20.524  1.00  0.00           C  
ATOM    374  OD1 ASN A  33       1.814  19.487  21.555  1.00  0.00           O  
ATOM    375  ND2 ASN A  33       1.982  19.431  19.317  1.00  0.00           N  
ATOM    376  H   ASN A  33       5.231  21.712  18.415  1.00  0.00           H  
ATOM    377  HA  ASN A  33       2.725  22.162  19.873  1.00  0.00           H  
ATOM    378  HB2 ASN A  33       4.506  19.823  20.071  1.00  0.00           H  
ATOM    379  HB3 ASN A  33       4.070  20.545  21.615  1.00  0.00           H  
ATOM    380 HD21 ASN A  33       2.536  19.664  18.540  1.00  0.00           H  
ATOM    381 HD22 ASN A  33       1.113  18.978  19.252  1.00  0.00           H  
ATOM    382  N   ARG A  34       4.230  22.889  22.046  1.00  0.00           N  
ATOM    383  CA  ARG A  34       4.920  23.794  22.958  1.00  0.00           C  
ATOM    384  C   ARG A  34       5.123  23.138  24.320  1.00  0.00           C  
ATOM    385  O   ARG A  34       4.521  22.106  24.620  1.00  0.00           O  
ATOM    386  CB  ARG A  34       4.131  25.095  23.117  1.00  0.00           C  
ATOM    387  CG  ARG A  34       2.642  24.886  23.338  1.00  0.00           C  
ATOM    388  CD  ARG A  34       2.275  24.989  24.811  1.00  0.00           C  
ATOM    389  NE  ARG A  34       1.874  23.698  25.366  1.00  0.00           N  
ATOM    390  CZ  ARG A  34       1.177  23.559  26.492  1.00  0.00           C  
ATOM    391  NH1 ARG A  34       0.805  24.627  27.185  1.00  0.00           N  
ATOM    392  NH2 ARG A  34       0.854  22.348  26.926  1.00  0.00           N  
ATOM    393  H   ARG A  34       3.509  22.322  22.391  1.00  0.00           H  
ATOM    394  HA  ARG A  34       5.886  24.018  22.533  1.00  0.00           H  
ATOM    395  HB2 ARG A  34       4.525  25.641  23.961  1.00  0.00           H  
ATOM    396  HB3 ARG A  34       4.261  25.691  22.225  1.00  0.00           H  
ATOM    397  HG2 ARG A  34       2.097  25.641  22.790  1.00  0.00           H  
ATOM    398  HG3 ARG A  34       2.368  23.907  22.975  1.00  0.00           H  
ATOM    399  HD2 ARG A  34       3.129  25.355  25.358  1.00  0.00           H  
ATOM    400  HD3 ARG A  34       1.455  25.685  24.916  1.00  0.00           H  
ATOM    401  HE  ARG A  34       2.136  22.893  24.874  1.00  0.00           H  
ATOM    402 HH11 ARG A  34       1.047  25.543  26.865  1.00  0.00           H  
ATOM    403 HH12 ARG A  34       0.283  24.516  28.032  1.00  0.00           H  
ATOM    404 HH21 ARG A  34       1.134  21.540  26.405  1.00  0.00           H  
ATOM    405 HH22 ARG A  34       0.333  22.243  27.771  1.00  0.00           H  
ATOM    406  N   SER A  35       5.978  23.742  25.142  1.00  0.00           N  
ATOM    407  CA  SER A  35       6.266  23.219  26.475  1.00  0.00           C  
ATOM    408  C   SER A  35       4.982  22.857  27.216  1.00  0.00           C  
ATOM    409  O   SER A  35       3.974  23.556  27.113  1.00  0.00           O  
ATOM    410  CB  SER A  35       7.060  24.244  27.285  1.00  0.00           C  
ATOM    411  OG  SER A  35       7.549  23.678  28.487  1.00  0.00           O  
ATOM    412  H   SER A  35       6.427  24.561  24.843  1.00  0.00           H  
ATOM    413  HA  SER A  35       6.863  22.328  26.359  1.00  0.00           H  
ATOM    414  HB2 SER A  35       7.898  24.592  26.699  1.00  0.00           H  
ATOM    415  HB3 SER A  35       6.420  25.081  27.529  1.00  0.00           H  
ATOM    416  HG  SER A  35       8.386  23.238  28.317  1.00  0.00           H  
ATOM    417  N   LYS A  36       5.025  21.758  27.962  1.00  0.00           N  
ATOM    418  CA  LYS A  36       3.865  21.303  28.720  1.00  0.00           C  
ATOM    419  C   LYS A  36       3.695  22.106  30.011  1.00  0.00           C  
ATOM    420  O   LYS A  36       2.698  21.957  30.716  1.00  0.00           O  
ATOM    421  CB  LYS A  36       3.998  19.814  29.048  1.00  0.00           C  
ATOM    422  CG  LYS A  36       3.268  18.908  28.069  1.00  0.00           C  
ATOM    423  CD  LYS A  36       3.820  19.051  26.661  1.00  0.00           C  
ATOM    424  CE  LYS A  36       2.710  19.010  25.622  1.00  0.00           C  
ATOM    425  NZ  LYS A  36       3.249  18.942  24.235  1.00  0.00           N  
ATOM    426  H   LYS A  36       5.857  21.241  28.004  1.00  0.00           H  
ATOM    427  HA  LYS A  36       2.991  21.448  28.104  1.00  0.00           H  
ATOM    428  HB2 LYS A  36       5.046  19.547  29.039  1.00  0.00           H  
ATOM    429  HB3 LYS A  36       3.601  19.635  30.035  1.00  0.00           H  
ATOM    430  HG2 LYS A  36       3.383  17.884  28.388  1.00  0.00           H  
ATOM    431  HG3 LYS A  36       2.221  19.171  28.065  1.00  0.00           H  
ATOM    432  HD2 LYS A  36       4.339  19.993  26.580  1.00  0.00           H  
ATOM    433  HD3 LYS A  36       4.509  18.240  26.470  1.00  0.00           H  
ATOM    434  HE2 LYS A  36       2.097  18.141  25.804  1.00  0.00           H  
ATOM    435  HE3 LYS A  36       2.108  19.902  25.721  1.00  0.00           H  
ATOM    436  HZ1 LYS A  36       3.850  19.769  24.044  1.00  0.00           H  
ATOM    437  HZ2 LYS A  36       2.468  18.927  23.548  1.00  0.00           H  
ATOM    438  HZ3 LYS A  36       3.817  18.079  24.115  1.00  0.00           H  
ATOM    439  N   GLU A  37       4.673  22.958  30.316  1.00  0.00           N  
ATOM    440  CA  GLU A  37       4.622  23.777  31.521  1.00  0.00           C  
ATOM    441  C   GLU A  37       4.231  25.213  31.189  1.00  0.00           C  
ATOM    442  O   GLU A  37       3.627  25.908  32.006  1.00  0.00           O  
ATOM    443  CB  GLU A  37       5.976  23.760  32.235  1.00  0.00           C  
ATOM    444  CG  GLU A  37       6.655  22.400  32.227  1.00  0.00           C  
ATOM    445  CD  GLU A  37       7.491  22.174  30.982  1.00  0.00           C  
ATOM    446  OE1 GLU A  37       8.594  22.753  30.894  1.00  0.00           O  
ATOM    447  OE2 GLU A  37       7.043  21.419  30.093  1.00  0.00           O  
ATOM    448  H   GLU A  37       5.445  23.037  29.721  1.00  0.00           H  
ATOM    449  HA  GLU A  37       3.875  23.355  32.175  1.00  0.00           H  
ATOM    450  HB2 GLU A  37       6.632  24.469  31.752  1.00  0.00           H  
ATOM    451  HB3 GLU A  37       5.831  24.059  33.263  1.00  0.00           H  
ATOM    452  HG2 GLU A  37       7.298  22.328  33.090  1.00  0.00           H  
ATOM    453  HG3 GLU A  37       5.897  21.633  32.278  1.00  0.00           H  
ATOM    454  N   ASN A  38       4.582  25.654  29.984  1.00  0.00           N  
ATOM    455  CA  ASN A  38       4.271  27.009  29.548  1.00  0.00           C  
ATOM    456  C   ASN A  38       3.947  27.040  28.055  1.00  0.00           C  
ATOM    457  O   ASN A  38       3.774  25.996  27.427  1.00  0.00           O  
ATOM    458  CB  ASN A  38       5.447  27.943  29.851  1.00  0.00           C  
ATOM    459  CG  ASN A  38       6.673  27.633  29.014  1.00  0.00           C  
ATOM    460  OD1 ASN A  38       7.090  28.438  28.181  1.00  0.00           O  
ATOM    461  ND2 ASN A  38       7.260  26.460  29.230  1.00  0.00           N  
ATOM    462  H   ASN A  38       5.065  25.055  29.378  1.00  0.00           H  
ATOM    463  HA  ASN A  38       3.406  27.344  30.097  1.00  0.00           H  
ATOM    464  HB2 ASN A  38       5.148  28.962  29.653  1.00  0.00           H  
ATOM    465  HB3 ASN A  38       5.713  27.848  30.894  1.00  0.00           H  
ATOM    466 HD21 ASN A  38       6.873  25.866  29.910  1.00  0.00           H  
ATOM    467 HD22 ASN A  38       8.057  26.235  28.700  1.00  0.00           H  
ATOM    468  N   HIS A  39       3.867  28.242  27.495  1.00  0.00           N  
ATOM    469  CA  HIS A  39       3.564  28.405  26.077  1.00  0.00           C  
ATOM    470  C   HIS A  39       4.846  28.561  25.263  1.00  0.00           C  
ATOM    471  O   HIS A  39       4.923  29.388  24.356  1.00  0.00           O  
ATOM    472  CB  HIS A  39       2.657  29.619  25.865  1.00  0.00           C  
ATOM    473  CG  HIS A  39       1.198  29.287  25.898  1.00  0.00           C  
ATOM    474  ND1 HIS A  39       0.387  29.559  26.981  1.00  0.00           N  
ATOM    475  CD2 HIS A  39       0.402  28.702  24.971  1.00  0.00           C  
ATOM    476  CE1 HIS A  39      -0.844  29.155  26.719  1.00  0.00           C  
ATOM    477  NE2 HIS A  39      -0.862  28.633  25.508  1.00  0.00           N  
ATOM    478  H   HIS A  39       4.014  29.037  28.046  1.00  0.00           H  
ATOM    479  HA  HIS A  39       3.048  27.518  25.746  1.00  0.00           H  
ATOM    480  HB2 HIS A  39       2.850  30.344  26.642  1.00  0.00           H  
ATOM    481  HB3 HIS A  39       2.876  30.061  24.903  1.00  0.00           H  
ATOM    482  HD1 HIS A  39       0.672  29.985  27.816  1.00  0.00           H  
ATOM    483  HD2 HIS A  39       0.702  28.354  23.993  1.00  0.00           H  
ATOM    484  HE1 HIS A  39      -1.691  29.240  27.385  1.00  0.00           H  
ATOM    485  HE2 HIS A  39      -1.665  28.334  25.034  1.00  0.00           H  
ATOM    486  N   ALA A  40       5.851  27.759  25.598  1.00  0.00           N  
ATOM    487  CA  ALA A  40       7.131  27.804  24.902  1.00  0.00           C  
ATOM    488  C   ALA A  40       7.173  26.798  23.760  1.00  0.00           C  
ATOM    489  O   ALA A  40       7.372  25.604  23.979  1.00  0.00           O  
ATOM    490  CB  ALA A  40       8.270  27.546  25.879  1.00  0.00           C  
ATOM    491  H   ALA A  40       5.730  27.121  26.332  1.00  0.00           H  
ATOM    492  HA  ALA A  40       7.255  28.800  24.499  1.00  0.00           H  
ATOM    493  HB1 ALA A  40       9.088  27.070  25.358  1.00  0.00           H  
ATOM    494  HB2 ALA A  40       7.921  26.900  26.673  1.00  0.00           H  
ATOM    495  HB3 ALA A  40       8.605  28.483  26.298  1.00  0.00           H  
ATOM    496  N   ASP A  41       6.985  27.287  22.538  1.00  0.00           N  
ATOM    497  CA  ASP A  41       7.001  26.427  21.358  1.00  0.00           C  
ATOM    498  C   ASP A  41       8.309  25.644  21.276  1.00  0.00           C  
ATOM    499  O   ASP A  41       9.394  26.221  21.310  1.00  0.00           O  
ATOM    500  CB  ASP A  41       6.816  27.262  20.090  1.00  0.00           C  
ATOM    501  CG  ASP A  41       7.725  28.477  20.058  1.00  0.00           C  
ATOM    502  OD1 ASP A  41       8.863  28.352  19.562  1.00  0.00           O  
ATOM    503  OD2 ASP A  41       7.298  29.551  20.533  1.00  0.00           O  
ATOM    504  H   ASP A  41       6.832  28.248  22.425  1.00  0.00           H  
ATOM    505  HA  ASP A  41       6.181  25.732  21.444  1.00  0.00           H  
ATOM    506  HB2 ASP A  41       7.035  26.650  19.227  1.00  0.00           H  
ATOM    507  HB3 ASP A  41       5.792  27.602  20.037  1.00  0.00           H  
ATOM    508  N   LEU A  42       8.196  24.323  21.175  1.00  0.00           N  
ATOM    509  CA  LEU A  42       9.368  23.460  21.092  1.00  0.00           C  
ATOM    510  C   LEU A  42       9.801  23.263  19.643  1.00  0.00           C  
ATOM    511  O   LEU A  42      10.991  23.156  19.351  1.00  0.00           O  
ATOM    512  CB  LEU A  42       9.075  22.105  21.741  1.00  0.00           C  
ATOM    513  CG  LEU A  42       8.523  22.174  23.165  1.00  0.00           C  
ATOM    514  CD1 LEU A  42       8.357  20.777  23.741  1.00  0.00           C  
ATOM    515  CD2 LEU A  42       9.433  23.014  24.050  1.00  0.00           C  
ATOM    516  H   LEU A  42       7.304  23.920  21.154  1.00  0.00           H  
ATOM    517  HA  LEU A  42      10.169  23.942  21.631  1.00  0.00           H  
ATOM    518  HB2 LEU A  42       8.360  21.583  21.123  1.00  0.00           H  
ATOM    519  HB3 LEU A  42       9.993  21.536  21.762  1.00  0.00           H  
ATOM    520  HG  LEU A  42       7.551  22.645  23.145  1.00  0.00           H  
ATOM    521 HD11 LEU A  42       8.229  20.069  22.937  1.00  0.00           H  
ATOM    522 HD12 LEU A  42       7.489  20.754  24.384  1.00  0.00           H  
ATOM    523 HD13 LEU A  42       9.235  20.517  24.314  1.00  0.00           H  
ATOM    524 HD21 LEU A  42       9.095  24.040  24.044  1.00  0.00           H  
ATOM    525 HD22 LEU A  42      10.444  22.965  23.674  1.00  0.00           H  
ATOM    526 HD23 LEU A  42       9.405  22.631  25.060  1.00  0.00           H  
ATOM    527  N   GLY A  43       8.828  23.216  18.741  1.00  0.00           N  
ATOM    528  CA  GLY A  43       9.132  23.033  17.332  1.00  0.00           C  
ATOM    529  C   GLY A  43       8.115  22.159  16.626  1.00  0.00           C  
ATOM    530  O   GLY A  43       6.979  22.021  17.081  1.00  0.00           O  
ATOM    531  H   GLY A  43       7.897  23.309  19.030  1.00  0.00           H  
ATOM    532  HA2 GLY A  43       9.155  23.998  16.853  1.00  0.00           H  
ATOM    533  HA3 GLY A  43      10.106  22.576  17.245  1.00  0.00           H  
ATOM    534  N   ILE A  44       8.522  21.567  15.507  1.00  0.00           N  
ATOM    535  CA  ILE A  44       7.641  20.703  14.730  1.00  0.00           C  
ATOM    536  C   ILE A  44       8.230  19.299  14.597  1.00  0.00           C  
ATOM    537  O   ILE A  44       9.444  19.131  14.495  1.00  0.00           O  
ATOM    538  CB  ILE A  44       7.366  21.271  13.314  1.00  0.00           C  
ATOM    539  CG1 ILE A  44       8.220  22.516  13.043  1.00  0.00           C  
ATOM    540  CG2 ILE A  44       5.889  21.597  13.148  1.00  0.00           C  
ATOM    541  CD1 ILE A  44       7.794  23.733  13.840  1.00  0.00           C  
ATOM    542  H   ILE A  44       9.440  21.716  15.194  1.00  0.00           H  
ATOM    543  HA  ILE A  44       6.699  20.633  15.257  1.00  0.00           H  
ATOM    544  HB  ILE A  44       7.619  20.511  12.592  1.00  0.00           H  
ATOM    545 HG12 ILE A  44       9.247  22.300  13.294  1.00  0.00           H  
ATOM    546 HG13 ILE A  44       8.153  22.767  11.993  1.00  0.00           H  
ATOM    547 HG21 ILE A  44       5.573  22.252  13.945  1.00  0.00           H  
ATOM    548 HG22 ILE A  44       5.313  20.685  13.182  1.00  0.00           H  
ATOM    549 HG23 ILE A  44       5.733  22.084  12.197  1.00  0.00           H  
ATOM    550 HD11 ILE A  44       7.221  24.396  13.206  1.00  0.00           H  
ATOM    551 HD12 ILE A  44       8.669  24.249  14.204  1.00  0.00           H  
ATOM    552 HD13 ILE A  44       7.185  23.421  14.677  1.00  0.00           H  
ATOM    553  N   PHE A  45       7.356  18.298  14.599  1.00  0.00           N  
ATOM    554  CA  PHE A  45       7.779  16.904  14.478  1.00  0.00           C  
ATOM    555  C   PHE A  45       6.954  16.190  13.415  1.00  0.00           C  
ATOM    556  O   PHE A  45       5.755  16.435  13.282  1.00  0.00           O  
ATOM    557  CB  PHE A  45       7.638  16.176  15.821  1.00  0.00           C  
ATOM    558  CG  PHE A  45       7.559  17.095  17.011  1.00  0.00           C  
ATOM    559  CD1 PHE A  45       8.596  17.966  17.300  1.00  0.00           C  
ATOM    560  CD2 PHE A  45       6.445  17.086  17.835  1.00  0.00           C  
ATOM    561  CE1 PHE A  45       8.526  18.813  18.389  1.00  0.00           C  
ATOM    562  CE2 PHE A  45       6.369  17.929  18.929  1.00  0.00           C  
ATOM    563  CZ  PHE A  45       7.411  18.793  19.206  1.00  0.00           C  
ATOM    564  H   PHE A  45       6.401  18.499  14.682  1.00  0.00           H  
ATOM    565  HA  PHE A  45       8.817  16.891  14.179  1.00  0.00           H  
ATOM    566  HB2 PHE A  45       6.738  15.580  15.806  1.00  0.00           H  
ATOM    567  HB3 PHE A  45       8.488  15.526  15.960  1.00  0.00           H  
ATOM    568  HD1 PHE A  45       9.468  17.982  16.662  1.00  0.00           H  
ATOM    569  HD2 PHE A  45       5.632  16.410  17.620  1.00  0.00           H  
ATOM    570  HE1 PHE A  45       9.341  19.487  18.603  1.00  0.00           H  
ATOM    571  HE2 PHE A  45       5.497  17.912  19.564  1.00  0.00           H  
ATOM    572  HZ  PHE A  45       7.353  19.454  20.058  1.00  0.00           H  
ATOM    573  N   VAL A  46       7.598  15.307  12.658  1.00  0.00           N  
ATOM    574  CA  VAL A  46       6.911  14.564  11.608  1.00  0.00           C  
ATOM    575  C   VAL A  46       5.658  13.885  12.153  1.00  0.00           C  
ATOM    576  O   VAL A  46       5.739  12.961  12.961  1.00  0.00           O  
ATOM    577  CB  VAL A  46       7.824  13.500  10.972  1.00  0.00           C  
ATOM    578  CG1 VAL A  46       7.174  12.909   9.730  1.00  0.00           C  
ATOM    579  CG2 VAL A  46       9.185  14.093  10.638  1.00  0.00           C  
ATOM    580  H   VAL A  46       8.557  15.154  12.810  1.00  0.00           H  
ATOM    581  HA  VAL A  46       6.621  15.264  10.839  1.00  0.00           H  
ATOM    582  HB  VAL A  46       7.967  12.706  11.687  1.00  0.00           H  
ATOM    583 HG11 VAL A  46       7.898  12.316   9.193  1.00  0.00           H  
ATOM    584 HG12 VAL A  46       6.819  13.707   9.095  1.00  0.00           H  
ATOM    585 HG13 VAL A  46       6.342  12.285  10.022  1.00  0.00           H  
ATOM    586 HG21 VAL A  46       9.585  13.605   9.762  1.00  0.00           H  
ATOM    587 HG22 VAL A  46       9.857  13.947  11.472  1.00  0.00           H  
ATOM    588 HG23 VAL A  46       9.079  15.151  10.444  1.00  0.00           H  
ATOM    589  N   LYS A  47       4.499  14.360  11.711  1.00  0.00           N  
ATOM    590  CA  LYS A  47       3.223  13.815  12.156  1.00  0.00           C  
ATOM    591  C   LYS A  47       2.849  12.570  11.359  1.00  0.00           C  
ATOM    592  O   LYS A  47       2.367  11.586  11.921  1.00  0.00           O  
ATOM    593  CB  LYS A  47       2.124  14.871  12.020  1.00  0.00           C  
ATOM    594  CG  LYS A  47       0.751  14.384  12.447  1.00  0.00           C  
ATOM    595  CD  LYS A  47       0.612  14.360  13.961  1.00  0.00           C  
ATOM    596  CE  LYS A  47       0.031  13.043  14.449  1.00  0.00           C  
ATOM    597  NZ  LYS A  47      -0.465  13.138  15.849  1.00  0.00           N  
ATOM    598  H   LYS A  47       4.501  15.102  11.072  1.00  0.00           H  
ATOM    599  HA  LYS A  47       3.324  13.545  13.195  1.00  0.00           H  
ATOM    600  HB2 LYS A  47       2.385  15.724  12.630  1.00  0.00           H  
ATOM    601  HB3 LYS A  47       2.068  15.182  10.987  1.00  0.00           H  
ATOM    602  HG2 LYS A  47       0.002  15.046  12.037  1.00  0.00           H  
ATOM    603  HG3 LYS A  47       0.598  13.385  12.064  1.00  0.00           H  
ATOM    604  HD2 LYS A  47       1.586  14.498  14.406  1.00  0.00           H  
ATOM    605  HD3 LYS A  47      -0.043  15.164  14.265  1.00  0.00           H  
ATOM    606  HE2 LYS A  47      -0.789  12.764  13.803  1.00  0.00           H  
ATOM    607  HE3 LYS A  47       0.801  12.286  14.398  1.00  0.00           H  
ATOM    608  HZ1 LYS A  47      -1.321  12.558  15.965  1.00  0.00           H  
ATOM    609  HZ2 LYS A  47      -0.693  14.125  16.081  1.00  0.00           H  
ATOM    610  HZ3 LYS A  47       0.263  12.796  16.510  1.00  0.00           H  
ATOM    611  N   SER A  48       3.064  12.620  10.050  1.00  0.00           N  
ATOM    612  CA  SER A  48       2.741  11.493   9.184  1.00  0.00           C  
ATOM    613  C   SER A  48       3.500  11.576   7.866  1.00  0.00           C  
ATOM    614  O   SER A  48       4.142  12.583   7.568  1.00  0.00           O  
ATOM    615  CB  SER A  48       1.234  11.447   8.915  1.00  0.00           C  
ATOM    616  OG  SER A  48       0.763  10.112   8.880  1.00  0.00           O  
ATOM    617  H   SER A  48       3.448  13.435   9.658  1.00  0.00           H  
ATOM    618  HA  SER A  48       3.032  10.588   9.697  1.00  0.00           H  
ATOM    619  HB2 SER A  48       0.716  11.979   9.699  1.00  0.00           H  
ATOM    620  HB3 SER A  48       1.027  11.914   7.964  1.00  0.00           H  
ATOM    621  HG  SER A  48       0.466   9.854   9.756  1.00  0.00           H  
ATOM    622  N   ILE A  49       3.423  10.506   7.081  1.00  0.00           N  
ATOM    623  CA  ILE A  49       4.106  10.452   5.795  1.00  0.00           C  
ATOM    624  C   ILE A  49       3.202   9.853   4.722  1.00  0.00           C  
ATOM    625  O   ILE A  49       2.336   9.029   5.011  1.00  0.00           O  
ATOM    626  CB  ILE A  49       5.399   9.620   5.879  1.00  0.00           C  
ATOM    627  CG1 ILE A  49       6.146   9.930   7.178  1.00  0.00           C  
ATOM    628  CG2 ILE A  49       6.293   9.873   4.672  1.00  0.00           C  
ATOM    629  CD1 ILE A  49       7.436   9.153   7.340  1.00  0.00           C  
ATOM    630  H   ILE A  49       2.900   9.733   7.374  1.00  0.00           H  
ATOM    631  HA  ILE A  49       4.367  11.460   5.512  1.00  0.00           H  
ATOM    632  HB  ILE A  49       5.125   8.581   5.870  1.00  0.00           H  
ATOM    633 HG12 ILE A  49       6.390  10.983   7.203  1.00  0.00           H  
ATOM    634 HG13 ILE A  49       5.508   9.691   8.016  1.00  0.00           H  
ATOM    635 HG21 ILE A  49       6.550   8.930   4.211  1.00  0.00           H  
ATOM    636 HG22 ILE A  49       7.194  10.376   4.990  1.00  0.00           H  
ATOM    637 HG23 ILE A  49       5.770  10.490   3.959  1.00  0.00           H  
ATOM    638 HD11 ILE A  49       7.209   8.132   7.606  1.00  0.00           H  
ATOM    639 HD12 ILE A  49       8.033   9.606   8.117  1.00  0.00           H  
ATOM    640 HD13 ILE A  49       7.983   9.169   6.409  1.00  0.00           H  
ATOM    641  N   ILE A  50       3.425  10.270   3.485  1.00  0.00           N  
ATOM    642  CA  ILE A  50       2.648   9.782   2.353  1.00  0.00           C  
ATOM    643  C   ILE A  50       3.490   8.836   1.501  1.00  0.00           C  
ATOM    644  O   ILE A  50       4.349   9.276   0.738  1.00  0.00           O  
ATOM    645  CB  ILE A  50       2.142  10.944   1.467  1.00  0.00           C  
ATOM    646  CG1 ILE A  50       1.158  11.827   2.240  1.00  0.00           C  
ATOM    647  CG2 ILE A  50       1.485  10.411   0.200  1.00  0.00           C  
ATOM    648  CD1 ILE A  50       1.815  12.901   3.069  1.00  0.00           C  
ATOM    649  H   ILE A  50       4.137  10.920   3.330  1.00  0.00           H  
ATOM    650  HA  ILE A  50       1.792   9.245   2.737  1.00  0.00           H  
ATOM    651  HB  ILE A  50       2.991  11.537   1.175  1.00  0.00           H  
ATOM    652 HG12 ILE A  50       0.497  12.316   1.540  1.00  0.00           H  
ATOM    653 HG13 ILE A  50       0.579  11.210   2.904  1.00  0.00           H  
ATOM    654 HG21 ILE A  50       2.240  10.240  -0.552  1.00  0.00           H  
ATOM    655 HG22 ILE A  50       0.768  11.129  -0.165  1.00  0.00           H  
ATOM    656 HG23 ILE A  50       0.981   9.481   0.421  1.00  0.00           H  
ATOM    657 HD11 ILE A  50       2.657  12.481   3.600  1.00  0.00           H  
ATOM    658 HD12 ILE A  50       1.103  13.293   3.779  1.00  0.00           H  
ATOM    659 HD13 ILE A  50       2.155  13.695   2.422  1.00  0.00           H  
ATOM    660  N   ASN A  51       3.241   7.538   1.641  1.00  0.00           N  
ATOM    661  CA  ASN A  51       3.984   6.536   0.881  1.00  0.00           C  
ATOM    662  C   ASN A  51       3.663   6.636  -0.606  1.00  0.00           C  
ATOM    663  O   ASN A  51       2.964   5.790  -1.164  1.00  0.00           O  
ATOM    664  CB  ASN A  51       3.672   5.126   1.390  1.00  0.00           C  
ATOM    665  CG  ASN A  51       2.204   4.927   1.719  1.00  0.00           C  
ATOM    666  OD1 ASN A  51       1.841   4.705   2.874  1.00  0.00           O  
ATOM    667  ND2 ASN A  51       1.351   5.003   0.703  1.00  0.00           N  
ATOM    668  H   ASN A  51       2.546   7.251   2.268  1.00  0.00           H  
ATOM    669  HA  ASN A  51       5.037   6.734   1.021  1.00  0.00           H  
ATOM    670  HB2 ASN A  51       3.951   4.411   0.630  1.00  0.00           H  
ATOM    671  HB3 ASN A  51       4.252   4.939   2.282  1.00  0.00           H  
ATOM    672 HD21 ASN A  51       1.713   5.182  -0.193  1.00  0.00           H  
ATOM    673 HD22 ASN A  51       0.394   4.876   0.892  1.00  0.00           H  
ATOM    674  N   GLY A  52       4.180   7.680  -1.240  1.00  0.00           N  
ATOM    675  CA  GLY A  52       3.945   7.884  -2.656  1.00  0.00           C  
ATOM    676  C   GLY A  52       4.862   8.933  -3.258  1.00  0.00           C  
ATOM    677  O   GLY A  52       5.160   8.889  -4.450  1.00  0.00           O  
ATOM    678  H   GLY A  52       4.725   8.317  -0.740  1.00  0.00           H  
ATOM    679  HA2 GLY A  52       4.101   6.948  -3.173  1.00  0.00           H  
ATOM    680  HA3 GLY A  52       2.920   8.194  -2.797  1.00  0.00           H  
ATOM    681  N   GLY A  53       5.304   9.886  -2.437  1.00  0.00           N  
ATOM    682  CA  GLY A  53       6.179  10.933  -2.929  1.00  0.00           C  
ATOM    683  C   GLY A  53       7.552  10.911  -2.283  1.00  0.00           C  
ATOM    684  O   GLY A  53       7.934   9.933  -1.642  1.00  0.00           O  
ATOM    685  H   GLY A  53       5.034   9.880  -1.495  1.00  0.00           H  
ATOM    686  HA2 GLY A  53       6.298  10.816  -3.997  1.00  0.00           H  
ATOM    687  HA3 GLY A  53       5.720  11.891  -2.735  1.00  0.00           H  
ATOM    688  N   ALA A  54       8.293  11.995  -2.472  1.00  0.00           N  
ATOM    689  CA  ALA A  54       9.643  12.133  -1.933  1.00  0.00           C  
ATOM    690  C   ALA A  54       9.780  11.584  -0.513  1.00  0.00           C  
ATOM    691  O   ALA A  54      10.659  10.769  -0.241  1.00  0.00           O  
ATOM    692  CB  ALA A  54      10.053  13.594  -1.964  1.00  0.00           C  
ATOM    693  H   ALA A  54       7.926  12.730  -3.007  1.00  0.00           H  
ATOM    694  HA  ALA A  54      10.311  11.587  -2.574  1.00  0.00           H  
ATOM    695  HB1 ALA A  54       9.755  14.070  -1.043  1.00  0.00           H  
ATOM    696  HB2 ALA A  54       9.569  14.085  -2.795  1.00  0.00           H  
ATOM    697  HB3 ALA A  54      11.124  13.666  -2.076  1.00  0.00           H  
ATOM    698  N   ALA A  55       8.924  12.047   0.387  1.00  0.00           N  
ATOM    699  CA  ALA A  55       8.975  11.605   1.779  1.00  0.00           C  
ATOM    700  C   ALA A  55       8.984  10.083   1.881  1.00  0.00           C  
ATOM    701  O   ALA A  55       9.598   9.517   2.784  1.00  0.00           O  
ATOM    702  CB  ALA A  55       7.805  12.180   2.558  1.00  0.00           C  
ATOM    703  H   ALA A  55       8.253  12.704   0.114  1.00  0.00           H  
ATOM    704  HA  ALA A  55       9.886  11.987   2.213  1.00  0.00           H  
ATOM    705  HB1 ALA A  55       7.175  11.378   2.912  1.00  0.00           H  
ATOM    706  HB2 ALA A  55       7.230  12.832   1.917  1.00  0.00           H  
ATOM    707  HB3 ALA A  55       8.176  12.743   3.403  1.00  0.00           H  
ATOM    708  N   SER A  56       8.307   9.427   0.947  1.00  0.00           N  
ATOM    709  CA  SER A  56       8.247   7.972   0.931  1.00  0.00           C  
ATOM    710  C   SER A  56       9.538   7.387   0.386  1.00  0.00           C  
ATOM    711  O   SER A  56      10.213   6.602   1.053  1.00  0.00           O  
ATOM    712  CB  SER A  56       7.072   7.502   0.078  1.00  0.00           C  
ATOM    713  OG  SER A  56       7.375   7.578  -1.305  1.00  0.00           O  
ATOM    714  H   SER A  56       7.842   9.935   0.249  1.00  0.00           H  
ATOM    715  HA  SER A  56       8.103   7.631   1.945  1.00  0.00           H  
ATOM    716  HB2 SER A  56       6.840   6.478   0.323  1.00  0.00           H  
ATOM    717  HB3 SER A  56       6.217   8.126   0.281  1.00  0.00           H  
ATOM    718  HG  SER A  56       7.609   6.707  -1.630  1.00  0.00           H  
ATOM    719  N   LYS A  57       9.875   7.777  -0.836  1.00  0.00           N  
ATOM    720  CA  LYS A  57      11.089   7.291  -1.485  1.00  0.00           C  
ATOM    721  C   LYS A  57      12.328   7.655  -0.671  1.00  0.00           C  
ATOM    722  O   LYS A  57      13.361   6.994  -0.769  1.00  0.00           O  
ATOM    723  CB  LYS A  57      11.218   7.839  -2.912  1.00  0.00           C  
ATOM    724  CG  LYS A  57      10.764   9.279  -3.075  1.00  0.00           C  
ATOM    725  CD  LYS A  57       9.801   9.425  -4.246  1.00  0.00           C  
ATOM    726  CE  LYS A  57      10.095  10.674  -5.061  1.00  0.00           C  
ATOM    727  NZ  LYS A  57       8.852  11.417  -5.407  1.00  0.00           N  
ATOM    728  H   LYS A  57       9.288   8.404  -1.313  1.00  0.00           H  
ATOM    729  HA  LYS A  57      11.020   6.216  -1.535  1.00  0.00           H  
ATOM    730  HB2 LYS A  57      12.254   7.779  -3.212  1.00  0.00           H  
ATOM    731  HB3 LYS A  57      10.629   7.220  -3.572  1.00  0.00           H  
ATOM    732  HG2 LYS A  57      10.269   9.601  -2.174  1.00  0.00           H  
ATOM    733  HG3 LYS A  57      11.627   9.900  -3.255  1.00  0.00           H  
ATOM    734  HD2 LYS A  57       9.896   8.561  -4.885  1.00  0.00           H  
ATOM    735  HD3 LYS A  57       8.793   9.482  -3.863  1.00  0.00           H  
ATOM    736  HE2 LYS A  57      10.741  11.322  -4.487  1.00  0.00           H  
ATOM    737  HE3 LYS A  57      10.595  10.384  -5.972  1.00  0.00           H  
ATOM    738  HZ1 LYS A  57       8.117  11.237  -4.692  1.00  0.00           H  
ATOM    739  HZ2 LYS A  57       8.499  11.110  -6.335  1.00  0.00           H  
ATOM    740  HZ3 LYS A  57       9.042  12.438  -5.442  1.00  0.00           H  
ATOM    741  N   ASP A  58      12.217   8.707   0.137  1.00  0.00           N  
ATOM    742  CA  ASP A  58      13.329   9.150   0.968  1.00  0.00           C  
ATOM    743  C   ASP A  58      13.821   8.015   1.862  1.00  0.00           C  
ATOM    744  O   ASP A  58      15.023   7.776   1.975  1.00  0.00           O  
ATOM    745  CB  ASP A  58      12.910  10.351   1.824  1.00  0.00           C  
ATOM    746  CG  ASP A  58      13.637  11.623   1.433  1.00  0.00           C  
ATOM    747  OD1 ASP A  58      14.317  11.621   0.385  1.00  0.00           O  
ATOM    748  OD2 ASP A  58      13.525  12.622   2.174  1.00  0.00           O  
ATOM    749  H   ASP A  58      11.367   9.194   0.175  1.00  0.00           H  
ATOM    750  HA  ASP A  58      14.132   9.451   0.314  1.00  0.00           H  
ATOM    751  HB2 ASP A  58      11.849  10.514   1.705  1.00  0.00           H  
ATOM    752  HB3 ASP A  58      13.124  10.140   2.861  1.00  0.00           H  
ATOM    753  N   GLY A  59      12.882   7.317   2.489  1.00  0.00           N  
ATOM    754  CA  GLY A  59      13.233   6.210   3.360  1.00  0.00           C  
ATOM    755  C   GLY A  59      14.161   6.617   4.488  1.00  0.00           C  
ATOM    756  O   GLY A  59      14.833   5.772   5.081  1.00  0.00           O  
ATOM    757  H   GLY A  59      11.939   7.552   2.357  1.00  0.00           H  
ATOM    758  HA2 GLY A  59      12.327   5.802   3.786  1.00  0.00           H  
ATOM    759  HA3 GLY A  59      13.715   5.444   2.772  1.00  0.00           H  
ATOM    760  N   ARG A  60      14.199   7.910   4.794  1.00  0.00           N  
ATOM    761  CA  ARG A  60      15.053   8.416   5.863  1.00  0.00           C  
ATOM    762  C   ARG A  60      14.265   9.287   6.843  1.00  0.00           C  
ATOM    763  O   ARG A  60      14.835   9.854   7.775  1.00  0.00           O  
ATOM    764  CB  ARG A  60      16.221   9.214   5.280  1.00  0.00           C  
ATOM    765  CG  ARG A  60      15.796  10.501   4.592  1.00  0.00           C  
ATOM    766  CD  ARG A  60      16.837  10.962   3.586  1.00  0.00           C  
ATOM    767  NE  ARG A  60      16.448  10.637   2.216  1.00  0.00           N  
ATOM    768  CZ  ARG A  60      17.165  10.970   1.145  1.00  0.00           C  
ATOM    769  NH1 ARG A  60      18.313  11.623   1.281  1.00  0.00           N  
ATOM    770  NH2 ARG A  60      16.735  10.650  -0.068  1.00  0.00           N  
ATOM    771  H   ARG A  60      13.641   8.539   4.290  1.00  0.00           H  
ATOM    772  HA  ARG A  60      15.446   7.564   6.397  1.00  0.00           H  
ATOM    773  HB2 ARG A  60      16.902   9.465   6.078  1.00  0.00           H  
ATOM    774  HB3 ARG A  60      16.736   8.599   4.558  1.00  0.00           H  
ATOM    775  HG2 ARG A  60      14.863  10.332   4.077  1.00  0.00           H  
ATOM    776  HG3 ARG A  60      15.664  11.269   5.339  1.00  0.00           H  
ATOM    777  HD2 ARG A  60      16.955  12.031   3.673  1.00  0.00           H  
ATOM    778  HD3 ARG A  60      17.776  10.476   3.809  1.00  0.00           H  
ATOM    779  HE  ARG A  60      15.608  10.149   2.089  1.00  0.00           H  
ATOM    780 HH11 ARG A  60      18.647  11.866   2.192  1.00  0.00           H  
ATOM    781 HH12 ARG A  60      18.847  11.871   0.472  1.00  0.00           H  
ATOM    782 HH21 ARG A  60      15.871  10.157  -0.178  1.00  0.00           H  
ATOM    783 HH22 ARG A  60      17.273  10.902  -0.872  1.00  0.00           H  
ATOM    784  N   LEU A  61      12.955   9.388   6.630  1.00  0.00           N  
ATOM    785  CA  LEU A  61      12.102  10.189   7.498  1.00  0.00           C  
ATOM    786  C   LEU A  61      11.567   9.354   8.658  1.00  0.00           C  
ATOM    787  O   LEU A  61      11.466   8.131   8.560  1.00  0.00           O  
ATOM    788  CB  LEU A  61      10.936  10.777   6.701  1.00  0.00           C  
ATOM    789  CG  LEU A  61      11.299  11.954   5.794  1.00  0.00           C  
ATOM    790  CD1 LEU A  61      11.771  13.140   6.620  1.00  0.00           C  
ATOM    791  CD2 LEU A  61      12.365  11.543   4.791  1.00  0.00           C  
ATOM    792  H   LEU A  61      12.553   8.915   5.873  1.00  0.00           H  
ATOM    793  HA  LEU A  61      12.698  10.997   7.897  1.00  0.00           H  
ATOM    794  HB2 LEU A  61      10.515   9.994   6.089  1.00  0.00           H  
ATOM    795  HB3 LEU A  61      10.182  11.110   7.399  1.00  0.00           H  
ATOM    796  HG  LEU A  61      10.421  12.260   5.244  1.00  0.00           H  
ATOM    797 HD11 LEU A  61      11.379  13.059   7.624  1.00  0.00           H  
ATOM    798 HD12 LEU A  61      11.418  14.058   6.171  1.00  0.00           H  
ATOM    799 HD13 LEU A  61      12.851  13.149   6.657  1.00  0.00           H  
ATOM    800 HD21 LEU A  61      13.338  11.830   5.161  1.00  0.00           H  
ATOM    801 HD22 LEU A  61      12.179  12.035   3.848  1.00  0.00           H  
ATOM    802 HD23 LEU A  61      12.334  10.473   4.652  1.00  0.00           H  
ATOM    803  N   ARG A  62      11.227  10.024   9.753  1.00  0.00           N  
ATOM    804  CA  ARG A  62      10.701   9.349  10.932  1.00  0.00           C  
ATOM    805  C   ARG A  62       9.538  10.132  11.528  1.00  0.00           C  
ATOM    806  O   ARG A  62       9.670  11.316  11.838  1.00  0.00           O  
ATOM    807  CB  ARG A  62      11.805   9.166  11.975  1.00  0.00           C  
ATOM    808  CG  ARG A  62      12.422   7.777  11.975  1.00  0.00           C  
ATOM    809  CD  ARG A  62      11.547   6.781  12.717  1.00  0.00           C  
ATOM    810  NE  ARG A  62      10.197   6.723  12.164  1.00  0.00           N  
ATOM    811  CZ  ARG A  62       9.860   5.995  11.101  1.00  0.00           C  
ATOM    812  NH1 ARG A  62      10.773   5.275  10.465  1.00  0.00           N  
ATOM    813  NH2 ARG A  62       8.606   5.996  10.668  1.00  0.00           N  
ATOM    814  H   ARG A  62      11.329  10.997   9.771  1.00  0.00           H  
ATOM    815  HA  ARG A  62      10.345   8.378  10.622  1.00  0.00           H  
ATOM    816  HB2 ARG A  62      12.587   9.884  11.783  1.00  0.00           H  
ATOM    817  HB3 ARG A  62      11.392   9.352  12.957  1.00  0.00           H  
ATOM    818  HG2 ARG A  62      12.539   7.447  10.953  1.00  0.00           H  
ATOM    819  HG3 ARG A  62      13.389   7.823  12.454  1.00  0.00           H  
ATOM    820  HD2 ARG A  62      11.996   5.802  12.647  1.00  0.00           H  
ATOM    821  HD3 ARG A  62      11.489   7.078  13.754  1.00  0.00           H  
ATOM    822  HE  ARG A  62       9.504   7.256  12.607  1.00  0.00           H  
ATOM    823 HH11 ARG A  62      11.722   5.275  10.781  1.00  0.00           H  
ATOM    824 HH12 ARG A  62      10.513   4.731   9.666  1.00  0.00           H  
ATOM    825 HH21 ARG A  62       7.914   6.542  11.141  1.00  0.00           H  
ATOM    826 HH22 ARG A  62       8.354   5.449   9.870  1.00  0.00           H  
ATOM    827  N   VAL A  63       8.399   9.466  11.683  1.00  0.00           N  
ATOM    828  CA  VAL A  63       7.207  10.100  12.239  1.00  0.00           C  
ATOM    829  C   VAL A  63       7.400  10.443  13.716  1.00  0.00           C  
ATOM    830  O   VAL A  63       6.787   9.831  14.590  1.00  0.00           O  
ATOM    831  CB  VAL A  63       5.969   9.195  12.091  1.00  0.00           C  
ATOM    832  CG1 VAL A  63       4.711   9.931  12.531  1.00  0.00           C  
ATOM    833  CG2 VAL A  63       5.832   8.705  10.656  1.00  0.00           C  
ATOM    834  H   VAL A  63       8.354   8.524  11.416  1.00  0.00           H  
ATOM    835  HA  VAL A  63       7.029  11.011  11.688  1.00  0.00           H  
ATOM    836  HB  VAL A  63       6.097   8.334  12.731  1.00  0.00           H  
ATOM    837 HG11 VAL A  63       4.190  10.305  11.663  1.00  0.00           H  
ATOM    838 HG12 VAL A  63       4.983  10.756  13.171  1.00  0.00           H  
ATOM    839 HG13 VAL A  63       4.068   9.252  13.073  1.00  0.00           H  
ATOM    840 HG21 VAL A  63       5.551   7.663  10.657  1.00  0.00           H  
ATOM    841 HG22 VAL A  63       6.774   8.823  10.143  1.00  0.00           H  
ATOM    842 HG23 VAL A  63       5.071   9.282  10.150  1.00  0.00           H  
ATOM    843  N   ASN A  64       8.256  11.430  13.986  1.00  0.00           N  
ATOM    844  CA  ASN A  64       8.532  11.862  15.358  1.00  0.00           C  
ATOM    845  C   ASN A  64       9.754  12.781  15.423  1.00  0.00           C  
ATOM    846  O   ASN A  64       9.925  13.530  16.386  1.00  0.00           O  
ATOM    847  CB  ASN A  64       8.756  10.655  16.276  1.00  0.00           C  
ATOM    848  CG  ASN A  64       9.615   9.587  15.628  1.00  0.00           C  
ATOM    849  OD1 ASN A  64      10.839   9.700  15.584  1.00  0.00           O  
ATOM    850  ND2 ASN A  64       8.974   8.541  15.119  1.00  0.00           N  
ATOM    851  H   ASN A  64       8.707  11.880  13.245  1.00  0.00           H  
ATOM    852  HA  ASN A  64       7.669  12.408  15.709  1.00  0.00           H  
ATOM    853  HB2 ASN A  64       9.247  10.983  17.179  1.00  0.00           H  
ATOM    854  HB3 ASN A  64       7.801  10.220  16.527  1.00  0.00           H  
ATOM    855 HD21 ASN A  64       7.995   8.520  15.190  1.00  0.00           H  
ATOM    856 HD22 ASN A  64       9.506   7.835  14.691  1.00  0.00           H  
ATOM    857  N   ASP A  65      10.606  12.717  14.402  1.00  0.00           N  
ATOM    858  CA  ASP A  65      11.811  13.536  14.355  1.00  0.00           C  
ATOM    859  C   ASP A  65      11.479  15.020  14.470  1.00  0.00           C  
ATOM    860  O   ASP A  65      10.469  15.484  13.939  1.00  0.00           O  
ATOM    861  CB  ASP A  65      12.579  13.272  13.059  1.00  0.00           C  
ATOM    862  CG  ASP A  65      13.589  12.151  13.203  1.00  0.00           C  
ATOM    863  OD1 ASP A  65      13.449  11.342  14.148  1.00  0.00           O  
ATOM    864  OD2 ASP A  65      14.519  12.079  12.374  1.00  0.00           O  
ATOM    865  H   ASP A  65      10.425  12.101  13.668  1.00  0.00           H  
ATOM    866  HA  ASP A  65      12.433  13.255  15.192  1.00  0.00           H  
ATOM    867  HB2 ASP A  65      11.879  13.002  12.281  1.00  0.00           H  
ATOM    868  HB3 ASP A  65      13.104  14.170  12.770  1.00  0.00           H  
ATOM    869  N   GLN A  66      12.344  15.755  15.164  1.00  0.00           N  
ATOM    870  CA  GLN A  66      12.158  17.190  15.356  1.00  0.00           C  
ATOM    871  C   GLN A  66      12.798  17.973  14.213  1.00  0.00           C  
ATOM    872  O   GLN A  66      13.956  17.746  13.865  1.00  0.00           O  
ATOM    873  CB  GLN A  66      12.767  17.621  16.695  1.00  0.00           C  
ATOM    874  CG  GLN A  66      12.815  19.129  16.895  1.00  0.00           C  
ATOM    875  CD  GLN A  66      11.966  19.591  18.060  1.00  0.00           C  
ATOM    876  OE1 GLN A  66      11.756  18.856  19.024  1.00  0.00           O  
ATOM    877  NE2 GLN A  66      11.468  20.818  17.974  1.00  0.00           N  
ATOM    878  H   GLN A  66      13.130  15.320  15.559  1.00  0.00           H  
ATOM    879  HA  GLN A  66      11.099  17.392  15.369  1.00  0.00           H  
ATOM    880  HB2 GLN A  66      12.182  17.193  17.495  1.00  0.00           H  
ATOM    881  HB3 GLN A  66      13.775  17.239  16.756  1.00  0.00           H  
ATOM    882  HG2 GLN A  66      13.838  19.422  17.077  1.00  0.00           H  
ATOM    883  HG3 GLN A  66      12.461  19.611  15.995  1.00  0.00           H  
ATOM    884 HE21 GLN A  66      11.676  21.349  17.173  1.00  0.00           H  
ATOM    885 HE22 GLN A  66      10.913  21.145  18.714  1.00  0.00           H  
ATOM    886  N   LEU A  67      12.039  18.901  13.635  1.00  0.00           N  
ATOM    887  CA  LEU A  67      12.538  19.722  12.538  1.00  0.00           C  
ATOM    888  C   LEU A  67      13.321  20.916  13.073  1.00  0.00           C  
ATOM    889  O   LEU A  67      12.860  21.618  13.974  1.00  0.00           O  
ATOM    890  CB  LEU A  67      11.382  20.207  11.664  1.00  0.00           C  
ATOM    891  CG  LEU A  67      10.668  19.110  10.875  1.00  0.00           C  
ATOM    892  CD1 LEU A  67       9.474  19.684  10.125  1.00  0.00           C  
ATOM    893  CD2 LEU A  67      11.629  18.428   9.912  1.00  0.00           C  
ATOM    894  H   LEU A  67      11.124  19.041  13.962  1.00  0.00           H  
ATOM    895  HA  LEU A  67      13.200  19.112  11.942  1.00  0.00           H  
ATOM    896  HB2 LEU A  67      10.658  20.696  12.299  1.00  0.00           H  
ATOM    897  HB3 LEU A  67      11.768  20.930  10.961  1.00  0.00           H  
ATOM    898  HG  LEU A  67      10.299  18.365  11.564  1.00  0.00           H  
ATOM    899 HD11 LEU A  67       8.924  20.348  10.777  1.00  0.00           H  
ATOM    900 HD12 LEU A  67       8.829  18.880   9.803  1.00  0.00           H  
ATOM    901 HD13 LEU A  67       9.822  20.235   9.263  1.00  0.00           H  
ATOM    902 HD21 LEU A  67      11.630  17.364  10.097  1.00  0.00           H  
ATOM    903 HD22 LEU A  67      12.626  18.819  10.059  1.00  0.00           H  
ATOM    904 HD23 LEU A  67      11.318  18.616   8.896  1.00  0.00           H  
ATOM    905  N   ILE A  68      14.509  21.134  12.522  1.00  0.00           N  
ATOM    906  CA  ILE A  68      15.354  22.241  12.956  1.00  0.00           C  
ATOM    907  C   ILE A  68      15.766  23.141  11.793  1.00  0.00           C  
ATOM    908  O   ILE A  68      16.114  24.302  11.999  1.00  0.00           O  
ATOM    909  CB  ILE A  68      16.620  21.728  13.670  1.00  0.00           C  
ATOM    910  CG1 ILE A  68      16.246  20.697  14.737  1.00  0.00           C  
ATOM    911  CG2 ILE A  68      17.385  22.889  14.289  1.00  0.00           C  
ATOM    912  CD1 ILE A  68      17.429  20.182  15.526  1.00  0.00           C  
ATOM    913  H   ILE A  68      14.826  20.534  11.815  1.00  0.00           H  
ATOM    914  HA  ILE A  68      14.788  22.828  13.665  1.00  0.00           H  
ATOM    915  HB  ILE A  68      17.258  21.260  12.934  1.00  0.00           H  
ATOM    916 HG12 ILE A  68      15.553  21.145  15.433  1.00  0.00           H  
ATOM    917 HG13 ILE A  68      15.774  19.850  14.257  1.00  0.00           H  
ATOM    918 HG21 ILE A  68      18.133  22.508  14.968  1.00  0.00           H  
ATOM    919 HG22 ILE A  68      16.700  23.525  14.828  1.00  0.00           H  
ATOM    920 HG23 ILE A  68      17.867  23.461  13.508  1.00  0.00           H  
ATOM    921 HD11 ILE A  68      17.079  19.697  16.424  1.00  0.00           H  
ATOM    922 HD12 ILE A  68      18.070  21.010  15.794  1.00  0.00           H  
ATOM    923 HD13 ILE A  68      17.983  19.476  14.927  1.00  0.00           H  
ATOM    924  N   ALA A  69      15.736  22.607  10.574  1.00  0.00           N  
ATOM    925  CA  ALA A  69      16.118  23.390   9.402  1.00  0.00           C  
ATOM    926  C   ALA A  69      15.529  22.810   8.120  1.00  0.00           C  
ATOM    927  O   ALA A  69      15.207  21.624   8.049  1.00  0.00           O  
ATOM    928  CB  ALA A  69      17.635  23.471   9.301  1.00  0.00           C  
ATOM    929  H   ALA A  69      15.458  21.674  10.460  1.00  0.00           H  
ATOM    930  HA  ALA A  69      15.739  24.392   9.537  1.00  0.00           H  
ATOM    931  HB1 ALA A  69      17.957  24.479   9.515  1.00  0.00           H  
ATOM    932  HB2 ALA A  69      17.947  23.196   8.304  1.00  0.00           H  
ATOM    933  HB3 ALA A  69      18.079  22.794  10.017  1.00  0.00           H  
ATOM    934  N   VAL A  70      15.395  23.663   7.106  1.00  0.00           N  
ATOM    935  CA  VAL A  70      14.849  23.251   5.816  1.00  0.00           C  
ATOM    936  C   VAL A  70      15.380  24.135   4.691  1.00  0.00           C  
ATOM    937  O   VAL A  70      15.110  25.336   4.652  1.00  0.00           O  
ATOM    938  CB  VAL A  70      13.307  23.297   5.809  1.00  0.00           C  
ATOM    939  CG1 VAL A  70      12.810  24.715   6.057  1.00  0.00           C  
ATOM    940  CG2 VAL A  70      12.758  22.751   4.498  1.00  0.00           C  
ATOM    941  H   VAL A  70      15.673  24.595   7.230  1.00  0.00           H  
ATOM    942  HA  VAL A  70      15.160  22.230   5.632  1.00  0.00           H  
ATOM    943  HB  VAL A  70      12.947  22.671   6.613  1.00  0.00           H  
ATOM    944 HG11 VAL A  70      12.012  24.694   6.784  1.00  0.00           H  
ATOM    945 HG12 VAL A  70      12.444  25.134   5.132  1.00  0.00           H  
ATOM    946 HG13 VAL A  70      13.623  25.322   6.431  1.00  0.00           H  
ATOM    947 HG21 VAL A  70      12.328  21.775   4.665  1.00  0.00           H  
ATOM    948 HG22 VAL A  70      13.558  22.673   3.776  1.00  0.00           H  
ATOM    949 HG23 VAL A  70      11.996  23.417   4.119  1.00  0.00           H  
ATOM    950  N   ASN A  71      16.135  23.533   3.778  1.00  0.00           N  
ATOM    951  CA  ASN A  71      16.704  24.266   2.653  1.00  0.00           C  
ATOM    952  C   ASN A  71      17.636  25.372   3.134  1.00  0.00           C  
ATOM    953  O   ASN A  71      17.716  26.439   2.528  1.00  0.00           O  
ATOM    954  CB  ASN A  71      15.591  24.866   1.791  1.00  0.00           C  
ATOM    955  CG  ASN A  71      14.764  23.805   1.092  1.00  0.00           C  
ATOM    956  OD1 ASN A  71      15.241  23.134   0.176  1.00  0.00           O  
ATOM    957  ND2 ASN A  71      13.517  23.648   1.521  1.00  0.00           N  
ATOM    958  H   ASN A  71      16.315  22.574   3.863  1.00  0.00           H  
ATOM    959  HA  ASN A  71      17.272  23.568   2.055  1.00  0.00           H  
ATOM    960  HB2 ASN A  71      14.933  25.451   2.419  1.00  0.00           H  
ATOM    961  HB3 ASN A  71      16.028  25.506   1.041  1.00  0.00           H  
ATOM    962 HD21 ASN A  71      13.204  24.219   2.257  1.00  0.00           H  
ATOM    963 HD22 ASN A  71      12.959  22.967   1.083  1.00  0.00           H  
ATOM    964  N   GLY A  72      18.341  25.110   4.231  1.00  0.00           N  
ATOM    965  CA  GLY A  72      19.259  26.094   4.774  1.00  0.00           C  
ATOM    966  C   GLY A  72      18.635  26.927   5.877  1.00  0.00           C  
ATOM    967  O   GLY A  72      19.339  27.463   6.733  1.00  0.00           O  
ATOM    968  H   GLY A  72      18.237  24.243   4.673  1.00  0.00           H  
ATOM    969  HA2 GLY A  72      20.124  25.583   5.170  1.00  0.00           H  
ATOM    970  HA3 GLY A  72      19.575  26.750   3.978  1.00  0.00           H  
ATOM    971  N   GLU A  73      17.309  27.035   5.860  1.00  0.00           N  
ATOM    972  CA  GLU A  73      16.595  27.809   6.868  1.00  0.00           C  
ATOM    973  C   GLU A  73      16.638  27.101   8.218  1.00  0.00           C  
ATOM    974  O   GLU A  73      16.801  25.885   8.286  1.00  0.00           O  
ATOM    975  CB  GLU A  73      15.143  28.033   6.437  1.00  0.00           C  
ATOM    976  CG  GLU A  73      14.855  29.458   5.995  1.00  0.00           C  
ATOM    977  CD  GLU A  73      15.222  30.479   7.054  1.00  0.00           C  
ATOM    978  OE1 GLU A  73      15.060  30.176   8.254  1.00  0.00           O  
ATOM    979  OE2 GLU A  73      15.669  31.585   6.680  1.00  0.00           O  
ATOM    980  H   GLU A  73      16.802  26.584   5.154  1.00  0.00           H  
ATOM    981  HA  GLU A  73      17.085  28.765   6.960  1.00  0.00           H  
ATOM    982  HB2 GLU A  73      14.919  27.371   5.612  1.00  0.00           H  
ATOM    983  HB3 GLU A  73      14.490  27.794   7.264  1.00  0.00           H  
ATOM    984  HG2 GLU A  73      15.421  29.667   5.103  1.00  0.00           H  
ATOM    985  HG3 GLU A  73      13.798  29.546   5.781  1.00  0.00           H  
ATOM    986  N   SER A  74      16.495  27.872   9.291  1.00  0.00           N  
ATOM    987  CA  SER A  74      16.520  27.318  10.641  1.00  0.00           C  
ATOM    988  C   SER A  74      15.147  27.417  11.296  1.00  0.00           C  
ATOM    989  O   SER A  74      14.669  28.509  11.604  1.00  0.00           O  
ATOM    990  CB  SER A  74      17.562  28.047  11.492  1.00  0.00           C  
ATOM    991  OG  SER A  74      17.337  27.826  12.873  1.00  0.00           O  
ATOM    992  H   SER A  74      16.369  28.837   9.173  1.00  0.00           H  
ATOM    993  HA  SER A  74      16.794  26.276  10.565  1.00  0.00           H  
ATOM    994  HB2 SER A  74      18.547  27.681  11.240  1.00  0.00           H  
ATOM    995  HB3 SER A  74      17.506  29.106  11.293  1.00  0.00           H  
ATOM    996  HG  SER A  74      17.807  27.037  13.154  1.00  0.00           H  
ATOM    997  N   LEU A  75      14.515  26.266  11.502  1.00  0.00           N  
ATOM    998  CA  LEU A  75      13.192  26.213  12.117  1.00  0.00           C  
ATOM    999  C   LEU A  75      13.273  26.417  13.629  1.00  0.00           C  
ATOM   1000  O   LEU A  75      12.301  26.835  14.259  1.00  0.00           O  
ATOM   1001  CB  LEU A  75      12.528  24.868  11.815  1.00  0.00           C  
ATOM   1002  CG  LEU A  75      12.239  24.590  10.337  1.00  0.00           C  
ATOM   1003  CD1 LEU A  75      11.361  23.356  10.190  1.00  0.00           C  
ATOM   1004  CD2 LEU A  75      11.579  25.795   9.687  1.00  0.00           C  
ATOM   1005  H   LEU A  75      14.947  25.429  11.231  1.00  0.00           H  
ATOM   1006  HA  LEU A  75      12.593  27.006  11.689  1.00  0.00           H  
ATOM   1007  HB2 LEU A  75      13.173  24.082  12.185  1.00  0.00           H  
ATOM   1008  HB3 LEU A  75      11.595  24.822  12.354  1.00  0.00           H  
ATOM   1009  HG  LEU A  75      13.170  24.399   9.824  1.00  0.00           H  
ATOM   1010 HD11 LEU A  75      11.950  22.540   9.802  1.00  0.00           H  
ATOM   1011 HD12 LEU A  75      10.549  23.570   9.509  1.00  0.00           H  
ATOM   1012 HD13 LEU A  75      10.957  23.083  11.154  1.00  0.00           H  
ATOM   1013 HD21 LEU A  75      11.060  25.482   8.792  1.00  0.00           H  
ATOM   1014 HD22 LEU A  75      12.333  26.523   9.429  1.00  0.00           H  
ATOM   1015 HD23 LEU A  75      10.876  26.233  10.376  1.00  0.00           H  
ATOM   1016  N   LEU A  76      14.433  26.112  14.208  1.00  0.00           N  
ATOM   1017  CA  LEU A  76      14.635  26.254  15.652  1.00  0.00           C  
ATOM   1018  C   LEU A  76      14.104  27.592  16.161  1.00  0.00           C  
ATOM   1019  O   LEU A  76      13.098  27.640  16.871  1.00  0.00           O  
ATOM   1020  CB  LEU A  76      16.121  26.113  15.996  1.00  0.00           C  
ATOM   1021  CG  LEU A  76      16.429  25.115  17.113  1.00  0.00           C  
ATOM   1022  CD1 LEU A  76      17.924  24.848  17.192  1.00  0.00           C  
ATOM   1023  CD2 LEU A  76      15.907  25.631  18.446  1.00  0.00           C  
ATOM   1024  H   LEU A  76      15.168  25.776  13.656  1.00  0.00           H  
ATOM   1025  HA  LEU A  76      14.089  25.460  16.136  1.00  0.00           H  
ATOM   1026  HB2 LEU A  76      16.646  25.799  15.105  1.00  0.00           H  
ATOM   1027  HB3 LEU A  76      16.495  27.080  16.293  1.00  0.00           H  
ATOM   1028  HG  LEU A  76      15.933  24.179  16.898  1.00  0.00           H  
ATOM   1029 HD11 LEU A  76      18.161  23.962  16.620  1.00  0.00           H  
ATOM   1030 HD12 LEU A  76      18.209  24.698  18.222  1.00  0.00           H  
ATOM   1031 HD13 LEU A  76      18.462  25.691  16.787  1.00  0.00           H  
ATOM   1032 HD21 LEU A  76      16.696  26.157  18.962  1.00  0.00           H  
ATOM   1033 HD22 LEU A  76      15.574  24.799  19.049  1.00  0.00           H  
ATOM   1034 HD23 LEU A  76      15.079  26.303  18.272  1.00  0.00           H  
ATOM   1035  N   GLY A  77      14.780  28.678  15.793  1.00  0.00           N  
ATOM   1036  CA  GLY A  77      14.353  29.998  16.224  1.00  0.00           C  
ATOM   1037  C   GLY A  77      12.888  30.261  15.923  1.00  0.00           C  
ATOM   1038  O   GLY A  77      12.244  31.072  16.589  1.00  0.00           O  
ATOM   1039  H   GLY A  77      15.572  28.581  15.225  1.00  0.00           H  
ATOM   1040  HA2 GLY A  77      14.511  30.087  17.290  1.00  0.00           H  
ATOM   1041  HA3 GLY A  77      14.952  30.740  15.718  1.00  0.00           H  
ATOM   1042  N   LYS A  78      12.367  29.569  14.917  1.00  0.00           N  
ATOM   1043  CA  LYS A  78      10.970  29.719  14.519  1.00  0.00           C  
ATOM   1044  C   LYS A  78      10.057  28.903  15.412  1.00  0.00           C  
ATOM   1045  O   LYS A  78      10.392  27.791  15.819  1.00  0.00           O  
ATOM   1046  CB  LYS A  78      10.787  29.280  13.071  1.00  0.00           C  
ATOM   1047  CG  LYS A  78      11.067  30.381  12.067  1.00  0.00           C  
ATOM   1048  CD  LYS A  78      10.550  30.036  10.684  1.00  0.00           C  
ATOM   1049  CE  LYS A  78      11.079  28.699  10.207  1.00  0.00           C  
ATOM   1050  NZ  LYS A  78      12.464  28.811   9.670  1.00  0.00           N  
ATOM   1051  H   LYS A  78      12.932  28.938  14.428  1.00  0.00           H  
ATOM   1052  HA  LYS A  78      10.698  30.760  14.609  1.00  0.00           H  
ATOM   1053  HB2 LYS A  78      11.456  28.459  12.869  1.00  0.00           H  
ATOM   1054  HB3 LYS A  78       9.769  28.946  12.933  1.00  0.00           H  
ATOM   1055  HG2 LYS A  78      10.584  31.285  12.400  1.00  0.00           H  
ATOM   1056  HG3 LYS A  78      12.133  30.536  12.012  1.00  0.00           H  
ATOM   1057  HD2 LYS A  78       9.475  29.993  10.713  1.00  0.00           H  
ATOM   1058  HD3 LYS A  78      10.865  30.802   9.993  1.00  0.00           H  
ATOM   1059  HE2 LYS A  78      11.076  28.010  11.038  1.00  0.00           H  
ATOM   1060  HE3 LYS A  78      10.428  28.330   9.435  1.00  0.00           H  
ATOM   1061  HZ1 LYS A  78      13.104  28.184  10.199  1.00  0.00           H  
ATOM   1062  HZ2 LYS A  78      12.806  29.789   9.757  1.00  0.00           H  
ATOM   1063  HZ3 LYS A  78      12.484  28.536   8.668  1.00  0.00           H  
ATOM   1064  N   ALA A  79       8.890  29.457  15.695  1.00  0.00           N  
ATOM   1065  CA  ALA A  79       7.913  28.779  16.518  1.00  0.00           C  
ATOM   1066  C   ALA A  79       7.232  27.689  15.706  1.00  0.00           C  
ATOM   1067  O   ALA A  79       7.660  27.379  14.594  1.00  0.00           O  
ATOM   1068  CB  ALA A  79       6.893  29.769  17.052  1.00  0.00           C  
ATOM   1069  H   ALA A  79       8.676  30.338  15.326  1.00  0.00           H  
ATOM   1070  HA  ALA A  79       8.427  28.328  17.355  1.00  0.00           H  
ATOM   1071  HB1 ALA A  79       6.238  29.272  17.749  1.00  0.00           H  
ATOM   1072  HB2 ALA A  79       6.313  30.166  16.230  1.00  0.00           H  
ATOM   1073  HB3 ALA A  79       7.408  30.579  17.550  1.00  0.00           H  
ATOM   1074  N   ASN A  80       6.175  27.116  16.250  1.00  0.00           N  
ATOM   1075  CA  ASN A  80       5.452  26.070  15.549  1.00  0.00           C  
ATOM   1076  C   ASN A  80       4.840  26.614  14.260  1.00  0.00           C  
ATOM   1077  O   ASN A  80       4.916  25.979  13.211  1.00  0.00           O  
ATOM   1078  CB  ASN A  80       4.358  25.488  16.448  1.00  0.00           C  
ATOM   1079  CG  ASN A  80       3.364  26.539  16.896  1.00  0.00           C  
ATOM   1080  OD1 ASN A  80       2.340  26.758  16.248  1.00  0.00           O  
ATOM   1081  ND2 ASN A  80       3.663  27.195  18.009  1.00  0.00           N  
ATOM   1082  H   ASN A  80       5.874  27.402  17.137  1.00  0.00           H  
ATOM   1083  HA  ASN A  80       6.154  25.292  15.301  1.00  0.00           H  
ATOM   1084  HB2 ASN A  80       3.826  24.721  15.909  1.00  0.00           H  
ATOM   1085  HB3 ASN A  80       4.817  25.055  17.325  1.00  0.00           H  
ATOM   1086 HD21 ASN A  80       4.498  26.965  18.474  1.00  0.00           H  
ATOM   1087 HD22 ASN A  80       3.039  27.884  18.321  1.00  0.00           H  
ATOM   1088  N   GLN A  81       4.225  27.789  14.357  1.00  0.00           N  
ATOM   1089  CA  GLN A  81       3.582  28.424  13.210  1.00  0.00           C  
ATOM   1090  C   GLN A  81       4.582  28.927  12.165  1.00  0.00           C  
ATOM   1091  O   GLN A  81       4.338  28.810  10.964  1.00  0.00           O  
ATOM   1092  CB  GLN A  81       2.699  29.584  13.678  1.00  0.00           C  
ATOM   1093  CG  GLN A  81       3.395  30.525  14.650  1.00  0.00           C  
ATOM   1094  CD  GLN A  81       3.435  31.957  14.152  1.00  0.00           C  
ATOM   1095  OE1 GLN A  81       3.177  32.894  14.904  1.00  0.00           O  
ATOM   1096  NE2 GLN A  81       3.757  32.131  12.876  1.00  0.00           N  
ATOM   1097  H   GLN A  81       4.196  28.239  15.227  1.00  0.00           H  
ATOM   1098  HA  GLN A  81       2.950  27.683  12.743  1.00  0.00           H  
ATOM   1099  HB2 GLN A  81       2.390  30.156  12.816  1.00  0.00           H  
ATOM   1100  HB3 GLN A  81       1.824  29.182  14.166  1.00  0.00           H  
ATOM   1101  HG2 GLN A  81       2.868  30.503  15.591  1.00  0.00           H  
ATOM   1102  HG3 GLN A  81       4.410  30.183  14.799  1.00  0.00           H  
ATOM   1103 HE21 GLN A  81       3.948  31.334  12.333  1.00  0.00           H  
ATOM   1104 HE22 GLN A  81       3.789  33.050  12.528  1.00  0.00           H  
ATOM   1105  N   GLU A  82       5.697  29.504  12.612  1.00  0.00           N  
ATOM   1106  CA  GLU A  82       6.692  30.033  11.690  1.00  0.00           C  
ATOM   1107  C   GLU A  82       7.379  28.915  10.920  1.00  0.00           C  
ATOM   1108  O   GLU A  82       7.589  29.021   9.711  1.00  0.00           O  
ATOM   1109  CB  GLU A  82       7.730  30.865  12.445  1.00  0.00           C  
ATOM   1110  CG  GLU A  82       7.123  31.997  13.260  1.00  0.00           C  
ATOM   1111  CD  GLU A  82       7.259  33.344  12.577  1.00  0.00           C  
ATOM   1112  OE1 GLU A  82       8.404  33.826  12.436  1.00  0.00           O  
ATOM   1113  OE2 GLU A  82       6.221  33.918  12.185  1.00  0.00           O  
ATOM   1114  H   GLU A  82       5.852  29.588  13.576  1.00  0.00           H  
ATOM   1115  HA  GLU A  82       6.181  30.670  10.983  1.00  0.00           H  
ATOM   1116  HB2 GLU A  82       8.274  30.220  13.116  1.00  0.00           H  
ATOM   1117  HB3 GLU A  82       8.419  31.295  11.733  1.00  0.00           H  
ATOM   1118  HG2 GLU A  82       6.074  31.792  13.411  1.00  0.00           H  
ATOM   1119  HG3 GLU A  82       7.623  32.042  14.216  1.00  0.00           H  
ATOM   1120  N   ALA A  83       7.724  27.843  11.617  1.00  0.00           N  
ATOM   1121  CA  ALA A  83       8.378  26.715  10.982  1.00  0.00           C  
ATOM   1122  C   ALA A  83       7.403  25.996  10.068  1.00  0.00           C  
ATOM   1123  O   ALA A  83       7.784  25.459   9.027  1.00  0.00           O  
ATOM   1124  CB  ALA A  83       8.944  25.770  12.028  1.00  0.00           C  
ATOM   1125  H   ALA A  83       7.523  27.805  12.574  1.00  0.00           H  
ATOM   1126  HA  ALA A  83       9.195  27.094  10.390  1.00  0.00           H  
ATOM   1127  HB1 ALA A  83       8.454  25.946  12.973  1.00  0.00           H  
ATOM   1128  HB2 ALA A  83      10.004  25.948  12.133  1.00  0.00           H  
ATOM   1129  HB3 ALA A  83       8.780  24.749  11.719  1.00  0.00           H  
ATOM   1130  N   MET A  84       6.136  26.001  10.463  1.00  0.00           N  
ATOM   1131  CA  MET A  84       5.093  25.359   9.678  1.00  0.00           C  
ATOM   1132  C   MET A  84       4.863  26.118   8.378  1.00  0.00           C  
ATOM   1133  O   MET A  84       4.503  25.531   7.357  1.00  0.00           O  
ATOM   1134  CB  MET A  84       3.792  25.273  10.468  1.00  0.00           C  
ATOM   1135  CG  MET A  84       3.481  23.863  10.924  1.00  0.00           C  
ATOM   1136  SD  MET A  84       2.207  23.805  12.190  1.00  0.00           S  
ATOM   1137  CE  MET A  84       3.227  23.930  13.651  1.00  0.00           C  
ATOM   1138  H   MET A  84       5.900  26.457  11.300  1.00  0.00           H  
ATOM   1139  HA  MET A  84       5.425  24.359   9.448  1.00  0.00           H  
ATOM   1140  HB2 MET A  84       3.864  25.908  11.338  1.00  0.00           H  
ATOM   1141  HB3 MET A  84       2.978  25.616   9.847  1.00  0.00           H  
ATOM   1142  HG2 MET A  84       3.153  23.289  10.073  1.00  0.00           H  
ATOM   1143  HG3 MET A  84       4.386  23.428  11.323  1.00  0.00           H  
ATOM   1144  HE1 MET A  84       2.969  23.141  14.337  1.00  0.00           H  
ATOM   1145  HE2 MET A  84       3.066  24.887  14.119  1.00  0.00           H  
ATOM   1146  HE3 MET A  84       4.266  23.838  13.368  1.00  0.00           H  
ATOM   1147  N   GLU A  85       5.086  27.428   8.421  1.00  0.00           N  
ATOM   1148  CA  GLU A  85       4.915  28.268   7.248  1.00  0.00           C  
ATOM   1149  C   GLU A  85       6.122  28.122   6.338  1.00  0.00           C  
ATOM   1150  O   GLU A  85       5.988  28.039   5.124  1.00  0.00           O  
ATOM   1151  CB  GLU A  85       4.700  29.734   7.669  1.00  0.00           C  
ATOM   1152  CG  GLU A  85       5.921  30.629   7.495  1.00  0.00           C  
ATOM   1153  CD  GLU A  85       5.646  32.068   7.887  1.00  0.00           C  
ATOM   1154  OE1 GLU A  85       5.101  32.818   7.049  1.00  0.00           O  
ATOM   1155  OE2 GLU A  85       5.976  32.444   9.030  1.00  0.00           O  
ATOM   1156  H   GLU A  85       5.381  27.835   9.263  1.00  0.00           H  
ATOM   1157  HA  GLU A  85       4.042  27.914   6.714  1.00  0.00           H  
ATOM   1158  HB2 GLU A  85       3.895  30.148   7.082  1.00  0.00           H  
ATOM   1159  HB3 GLU A  85       4.416  29.754   8.711  1.00  0.00           H  
ATOM   1160  HG2 GLU A  85       6.720  30.251   8.113  1.00  0.00           H  
ATOM   1161  HG3 GLU A  85       6.225  30.605   6.459  1.00  0.00           H  
ATOM   1162  N   THR A  86       7.300  28.054   6.941  1.00  0.00           N  
ATOM   1163  CA  THR A  86       8.525  27.874   6.187  1.00  0.00           C  
ATOM   1164  C   THR A  86       8.477  26.519   5.492  1.00  0.00           C  
ATOM   1165  O   THR A  86       8.954  26.359   4.369  1.00  0.00           O  
ATOM   1166  CB  THR A  86       9.735  27.969   7.117  1.00  0.00           C  
ATOM   1167  OG1 THR A  86      10.116  29.321   7.302  1.00  0.00           O  
ATOM   1168  CG2 THR A  86      10.953  27.213   6.622  1.00  0.00           C  
ATOM   1169  H   THR A  86       7.342  28.102   7.915  1.00  0.00           H  
ATOM   1170  HA  THR A  86       8.578  28.654   5.443  1.00  0.00           H  
ATOM   1171  HB  THR A  86       9.464  27.560   8.079  1.00  0.00           H  
ATOM   1172  HG1 THR A  86      10.924  29.362   7.818  1.00  0.00           H  
ATOM   1173 HG21 THR A  86      11.757  27.323   7.332  1.00  0.00           H  
ATOM   1174 HG22 THR A  86      11.258  27.610   5.666  1.00  0.00           H  
ATOM   1175 HG23 THR A  86      10.708  26.167   6.518  1.00  0.00           H  
ATOM   1176  N   LEU A  87       7.862  25.554   6.170  1.00  0.00           N  
ATOM   1177  CA  LEU A  87       7.706  24.215   5.626  1.00  0.00           C  
ATOM   1178  C   LEU A  87       6.726  24.269   4.470  1.00  0.00           C  
ATOM   1179  O   LEU A  87       7.022  23.811   3.369  1.00  0.00           O  
ATOM   1180  CB  LEU A  87       7.207  23.249   6.702  1.00  0.00           C  
ATOM   1181  CG  LEU A  87       8.239  22.873   7.764  1.00  0.00           C  
ATOM   1182  CD1 LEU A  87       7.552  22.480   9.062  1.00  0.00           C  
ATOM   1183  CD2 LEU A  87       9.128  21.742   7.264  1.00  0.00           C  
ATOM   1184  H   LEU A  87       7.482  25.757   7.048  1.00  0.00           H  
ATOM   1185  HA  LEU A  87       8.669  23.884   5.262  1.00  0.00           H  
ATOM   1186  HB2 LEU A  87       6.360  23.702   7.198  1.00  0.00           H  
ATOM   1187  HB3 LEU A  87       6.876  22.344   6.216  1.00  0.00           H  
ATOM   1188  HG  LEU A  87       8.869  23.728   7.967  1.00  0.00           H  
ATOM   1189 HD11 LEU A  87       6.559  22.115   8.848  1.00  0.00           H  
ATOM   1190 HD12 LEU A  87       7.488  23.340   9.711  1.00  0.00           H  
ATOM   1191 HD13 LEU A  87       8.123  21.703   9.551  1.00  0.00           H  
ATOM   1192 HD21 LEU A  87      10.136  21.891   7.623  1.00  0.00           H  
ATOM   1193 HD22 LEU A  87       9.126  21.735   6.185  1.00  0.00           H  
ATOM   1194 HD23 LEU A  87       8.751  20.799   7.632  1.00  0.00           H  
ATOM   1195  N   ARG A  88       5.565  24.869   4.721  1.00  0.00           N  
ATOM   1196  CA  ARG A  88       4.556  25.019   3.687  1.00  0.00           C  
ATOM   1197  C   ARG A  88       5.119  25.874   2.553  1.00  0.00           C  
ATOM   1198  O   ARG A  88       4.763  25.705   1.388  1.00  0.00           O  
ATOM   1199  CB  ARG A  88       3.268  25.633   4.262  1.00  0.00           C  
ATOM   1200  CG  ARG A  88       3.227  27.154   4.244  1.00  0.00           C  
ATOM   1201  CD  ARG A  88       1.968  27.686   4.909  1.00  0.00           C  
ATOM   1202  NE  ARG A  88       1.840  27.223   6.288  1.00  0.00           N  
ATOM   1203  CZ  ARG A  88       0.846  27.577   7.100  1.00  0.00           C  
ATOM   1204  NH1 ARG A  88      -0.109  28.394   6.673  1.00  0.00           N  
ATOM   1205  NH2 ARG A  88       0.807  27.111   8.340  1.00  0.00           N  
ATOM   1206  H   ARG A  88       5.399  25.238   5.612  1.00  0.00           H  
ATOM   1207  HA  ARG A  88       4.336  24.041   3.307  1.00  0.00           H  
ATOM   1208  HB2 ARG A  88       2.428  25.269   3.690  1.00  0.00           H  
ATOM   1209  HB3 ARG A  88       3.161  25.305   5.286  1.00  0.00           H  
ATOM   1210  HG2 ARG A  88       4.085  27.533   4.772  1.00  0.00           H  
ATOM   1211  HG3 ARG A  88       3.255  27.494   3.219  1.00  0.00           H  
ATOM   1212  HD2 ARG A  88       2.003  28.765   4.904  1.00  0.00           H  
ATOM   1213  HD3 ARG A  88       1.111  27.351   4.346  1.00  0.00           H  
ATOM   1214  HE  ARG A  88       2.532  26.618   6.629  1.00  0.00           H  
ATOM   1215 HH11 ARG A  88      -0.086  28.747   5.739  1.00  0.00           H  
ATOM   1216 HH12 ARG A  88      -0.854  28.656   7.288  1.00  0.00           H  
ATOM   1217 HH21 ARG A  88       1.524  26.495   8.667  1.00  0.00           H  
ATOM   1218 HH22 ARG A  88       0.060  27.377   8.950  1.00  0.00           H  
ATOM   1219  N   ARG A  89       6.029  26.776   2.919  1.00  0.00           N  
ATOM   1220  CA  ARG A  89       6.680  27.652   1.954  1.00  0.00           C  
ATOM   1221  C   ARG A  89       7.675  26.857   1.117  1.00  0.00           C  
ATOM   1222  O   ARG A  89       7.791  27.058  -0.094  1.00  0.00           O  
ATOM   1223  CB  ARG A  89       7.366  28.818   2.688  1.00  0.00           C  
ATOM   1224  CG  ARG A  89       8.840  29.013   2.371  1.00  0.00           C  
ATOM   1225  CD  ARG A  89       9.269  30.441   2.645  1.00  0.00           C  
ATOM   1226  NE  ARG A  89      10.711  30.623   2.491  1.00  0.00           N  
ATOM   1227  CZ  ARG A  89      11.604  30.268   3.412  1.00  0.00           C  
ATOM   1228  NH1 ARG A  89      11.210  29.711   4.550  1.00  0.00           N  
ATOM   1229  NH2 ARG A  89      12.896  30.470   3.192  1.00  0.00           N  
ATOM   1230  H   ARG A  89       6.284  26.840   3.865  1.00  0.00           H  
ATOM   1231  HA  ARG A  89       5.919  28.051   1.303  1.00  0.00           H  
ATOM   1232  HB2 ARG A  89       6.851  29.732   2.437  1.00  0.00           H  
ATOM   1233  HB3 ARG A  89       7.275  28.655   3.750  1.00  0.00           H  
ATOM   1234  HG2 ARG A  89       9.423  28.346   2.990  1.00  0.00           H  
ATOM   1235  HG3 ARG A  89       9.012  28.787   1.331  1.00  0.00           H  
ATOM   1236  HD2 ARG A  89       8.758  31.094   1.952  1.00  0.00           H  
ATOM   1237  HD3 ARG A  89       8.987  30.698   3.655  1.00  0.00           H  
ATOM   1238  HE  ARG A  89      11.030  31.029   1.659  1.00  0.00           H  
ATOM   1239 HH11 ARG A  89      10.236  29.556   4.721  1.00  0.00           H  
ATOM   1240 HH12 ARG A  89      11.884  29.449   5.237  1.00  0.00           H  
ATOM   1241 HH21 ARG A  89      13.199  30.887   2.337  1.00  0.00           H  
ATOM   1242 HH22 ARG A  89      13.568  30.203   3.883  1.00  0.00           H  
ATOM   1243  N   SER A  90       8.387  25.943   1.771  1.00  0.00           N  
ATOM   1244  CA  SER A  90       9.366  25.109   1.091  1.00  0.00           C  
ATOM   1245  C   SER A  90       8.667  24.079   0.214  1.00  0.00           C  
ATOM   1246  O   SER A  90       9.100  23.797  -0.905  1.00  0.00           O  
ATOM   1247  CB  SER A  90      10.269  24.408   2.107  1.00  0.00           C  
ATOM   1248  OG  SER A  90      11.469  25.135   2.311  1.00  0.00           O  
ATOM   1249  H   SER A  90       8.245  25.827   2.733  1.00  0.00           H  
ATOM   1250  HA  SER A  90       9.967  25.747   0.467  1.00  0.00           H  
ATOM   1251  HB2 SER A  90       9.749  24.325   3.050  1.00  0.00           H  
ATOM   1252  HB3 SER A  90      10.517  23.421   1.745  1.00  0.00           H  
ATOM   1253  HG  SER A  90      11.818  25.419   1.464  1.00  0.00           H  
ATOM   1254  N   MET A  91       7.577  23.527   0.730  1.00  0.00           N  
ATOM   1255  CA  MET A  91       6.799  22.536  -0.000  1.00  0.00           C  
ATOM   1256  C   MET A  91       5.924  23.210  -1.054  1.00  0.00           C  
ATOM   1257  O   MET A  91       5.388  22.553  -1.945  1.00  0.00           O  
ATOM   1258  CB  MET A  91       5.913  21.736   0.961  1.00  0.00           C  
ATOM   1259  CG  MET A  91       6.587  21.393   2.281  1.00  0.00           C  
ATOM   1260  SD  MET A  91       6.850  19.624   2.494  1.00  0.00           S  
ATOM   1261  CE  MET A  91       8.354  19.636   3.462  1.00  0.00           C  
ATOM   1262  H   MET A  91       7.283  23.800   1.621  1.00  0.00           H  
ATOM   1263  HA  MET A  91       7.488  21.861  -0.488  1.00  0.00           H  
ATOM   1264  HB2 MET A  91       5.027  22.315   1.177  1.00  0.00           H  
ATOM   1265  HB3 MET A  91       5.620  20.816   0.480  1.00  0.00           H  
ATOM   1266  HG2 MET A  91       7.544  21.890   2.320  1.00  0.00           H  
ATOM   1267  HG3 MET A  91       5.966  21.752   3.089  1.00  0.00           H  
ATOM   1268  HE1 MET A  91       8.364  20.508   4.100  1.00  0.00           H  
ATOM   1269  HE2 MET A  91       9.206  19.664   2.802  1.00  0.00           H  
ATOM   1270  HE3 MET A  91       8.398  18.744   4.070  1.00  0.00           H  
ATOM   1271  N   SER A  92       5.765  24.527  -0.929  1.00  0.00           N  
ATOM   1272  CA  SER A  92       4.933  25.290  -1.854  1.00  0.00           C  
ATOM   1273  C   SER A  92       5.688  25.707  -3.112  1.00  0.00           C  
ATOM   1274  O   SER A  92       5.229  25.456  -4.228  1.00  0.00           O  
ATOM   1275  CB  SER A  92       4.375  26.532  -1.157  1.00  0.00           C  
ATOM   1276  OG  SER A  92       3.808  27.432  -2.095  1.00  0.00           O  
ATOM   1277  H   SER A  92       6.203  24.993  -0.184  1.00  0.00           H  
ATOM   1278  HA  SER A  92       4.109  24.662  -2.144  1.00  0.00           H  
ATOM   1279  HB2 SER A  92       3.609  26.236  -0.454  1.00  0.00           H  
ATOM   1280  HB3 SER A  92       5.171  27.035  -0.628  1.00  0.00           H  
ATOM   1281  HG  SER A  92       3.140  26.976  -2.611  1.00  0.00           H  
ATOM   1282  N   THR A  93       6.829  26.365  -2.939  1.00  0.00           N  
ATOM   1283  CA  THR A  93       7.605  26.832  -4.086  1.00  0.00           C  
ATOM   1284  C   THR A  93       8.952  27.424  -3.670  1.00  0.00           C  
ATOM   1285  O   THR A  93       9.264  28.568  -4.005  1.00  0.00           O  
ATOM   1286  CB  THR A  93       6.805  27.890  -4.836  1.00  0.00           C  
ATOM   1287  OG1 THR A  93       7.511  28.342  -5.980  1.00  0.00           O  
ATOM   1288  CG2 THR A  93       6.493  29.093  -3.977  1.00  0.00           C  
ATOM   1289  H   THR A  93       7.140  26.555  -2.032  1.00  0.00           H  
ATOM   1290  HA  THR A  93       7.778  25.991  -4.740  1.00  0.00           H  
ATOM   1291  HB  THR A  93       5.868  27.460  -5.161  1.00  0.00           H  
ATOM   1292  HG1 THR A  93       7.002  29.026  -6.421  1.00  0.00           H  
ATOM   1293 HG21 THR A  93       6.253  28.765  -2.974  1.00  0.00           H  
ATOM   1294 HG22 THR A  93       5.654  29.628  -4.391  1.00  0.00           H  
ATOM   1295 HG23 THR A  93       7.355  29.744  -3.944  1.00  0.00           H  
ATOM   1296  N   GLU A  94       9.749  26.647  -2.956  1.00  0.00           N  
ATOM   1297  CA  GLU A  94      11.064  27.097  -2.513  1.00  0.00           C  
ATOM   1298  C   GLU A  94      11.937  25.892  -2.239  1.00  0.00           C  
ATOM   1299  O   GLU A  94      13.058  25.789  -2.735  1.00  0.00           O  
ATOM   1300  CB  GLU A  94      10.955  27.961  -1.255  1.00  0.00           C  
ATOM   1301  CG  GLU A  94      10.114  29.214  -1.436  1.00  0.00           C  
ATOM   1302  CD  GLU A  94      10.736  30.198  -2.405  1.00  0.00           C  
ATOM   1303  OE1 GLU A  94      11.980  30.309  -2.424  1.00  0.00           O  
ATOM   1304  OE2 GLU A  94       9.978  30.860  -3.147  1.00  0.00           O  
ATOM   1305  H   GLU A  94       9.456  25.740  -2.728  1.00  0.00           H  
ATOM   1306  HA  GLU A  94      11.508  27.674  -3.313  1.00  0.00           H  
ATOM   1307  HB2 GLU A  94      10.515  27.371  -0.466  1.00  0.00           H  
ATOM   1308  HB3 GLU A  94      11.949  28.261  -0.954  1.00  0.00           H  
ATOM   1309  HG2 GLU A  94       9.142  28.928  -1.807  1.00  0.00           H  
ATOM   1310  HG3 GLU A  94      10.004  29.695  -0.476  1.00  0.00           H  
ATOM   1311  N   GLY A  95      11.391  24.960  -1.473  1.00  0.00           N  
ATOM   1312  CA  GLY A  95      12.109  23.746  -1.178  1.00  0.00           C  
ATOM   1313  C   GLY A  95      12.307  22.936  -2.437  1.00  0.00           C  
ATOM   1314  O   GLY A  95      13.267  22.180  -2.558  1.00  0.00           O  
ATOM   1315  H   GLY A  95      10.483  25.087  -1.137  1.00  0.00           H  
ATOM   1316  HA2 GLY A  95      13.072  23.996  -0.755  1.00  0.00           H  
ATOM   1317  HA3 GLY A  95      11.546  23.162  -0.466  1.00  0.00           H  
ATOM   1318  N   ASN A  96      11.395  23.121  -3.389  1.00  0.00           N  
ATOM   1319  CA  ASN A  96      11.471  22.428  -4.661  1.00  0.00           C  
ATOM   1320  C   ASN A  96      12.246  23.279  -5.670  1.00  0.00           C  
ATOM   1321  O   ASN A  96      13.447  23.474  -5.515  1.00  0.00           O  
ATOM   1322  CB  ASN A  96      10.064  22.096  -5.179  1.00  0.00           C  
ATOM   1323  CG  ASN A  96      10.088  21.383  -6.522  1.00  0.00           C  
ATOM   1324  OD1 ASN A  96       9.193  21.563  -7.347  1.00  0.00           O  
ATOM   1325  ND2 ASN A  96      11.114  20.570  -6.747  1.00  0.00           N  
ATOM   1326  H   ASN A  96      10.662  23.755  -3.233  1.00  0.00           H  
ATOM   1327  HA  ASN A  96      12.012  21.509  -4.497  1.00  0.00           H  
ATOM   1328  HB2 ASN A  96       9.563  21.464  -4.467  1.00  0.00           H  
ATOM   1329  HB3 ASN A  96       9.505  23.015  -5.292  1.00  0.00           H  
ATOM   1330 HD21 ASN A  96      11.790  20.467  -6.044  1.00  0.00           H  
ATOM   1331 HD22 ASN A  96      11.161  20.115  -7.616  1.00  0.00           H  
ATOM   1332  N   LYS A  97      11.567  23.792  -6.699  1.00  0.00           N  
ATOM   1333  CA  LYS A  97      12.221  24.620  -7.703  1.00  0.00           C  
ATOM   1334  C   LYS A  97      13.427  23.906  -8.328  1.00  0.00           C  
ATOM   1335  O   LYS A  97      14.208  24.518  -9.054  1.00  0.00           O  
ATOM   1336  CB  LYS A  97      12.658  25.945  -7.070  1.00  0.00           C  
ATOM   1337  CG  LYS A  97      11.502  26.765  -6.517  1.00  0.00           C  
ATOM   1338  CD  LYS A  97      10.414  26.971  -7.559  1.00  0.00           C  
ATOM   1339  CE  LYS A  97       9.297  25.950  -7.406  1.00  0.00           C  
ATOM   1340  NZ  LYS A  97       7.971  26.520  -7.769  1.00  0.00           N  
ATOM   1341  H   LYS A  97      10.609  23.623  -6.779  1.00  0.00           H  
ATOM   1342  HA  LYS A  97      11.502  24.826  -8.481  1.00  0.00           H  
ATOM   1343  HB2 LYS A  97      13.339  25.738  -6.260  1.00  0.00           H  
ATOM   1344  HB3 LYS A  97      13.168  26.539  -7.815  1.00  0.00           H  
ATOM   1345  HG2 LYS A  97      11.081  26.248  -5.670  1.00  0.00           H  
ATOM   1346  HG3 LYS A  97      11.876  27.730  -6.206  1.00  0.00           H  
ATOM   1347  HD2 LYS A  97       9.999  27.961  -7.442  1.00  0.00           H  
ATOM   1348  HD3 LYS A  97      10.847  26.872  -8.544  1.00  0.00           H  
ATOM   1349  HE2 LYS A  97       9.507  25.107  -8.049  1.00  0.00           H  
ATOM   1350  HE3 LYS A  97       9.269  25.619  -6.379  1.00  0.00           H  
ATOM   1351  HZ1 LYS A  97       7.986  27.555  -7.668  1.00  0.00           H  
ATOM   1352  HZ2 LYS A  97       7.233  26.133  -7.145  1.00  0.00           H  
ATOM   1353  HZ3 LYS A  97       7.737  26.281  -8.754  1.00  0.00           H  
ATOM   1354  N   ARG A  98      13.579  22.608  -8.039  1.00  0.00           N  
ATOM   1355  CA  ARG A  98      14.690  21.823  -8.572  1.00  0.00           C  
ATOM   1356  C   ARG A  98      14.290  20.357  -8.707  1.00  0.00           C  
ATOM   1357  O   ARG A  98      14.590  19.705  -9.709  1.00  0.00           O  
ATOM   1358  CB  ARG A  98      15.931  21.922  -7.666  1.00  0.00           C  
ATOM   1359  CG  ARG A  98      15.974  23.142  -6.754  1.00  0.00           C  
ATOM   1360  CD  ARG A  98      15.995  22.748  -5.286  1.00  0.00           C  
ATOM   1361  NE  ARG A  98      17.249  22.100  -4.910  1.00  0.00           N  
ATOM   1362  CZ  ARG A  98      17.614  21.862  -3.651  1.00  0.00           C  
ATOM   1363  NH1 ARG A  98      16.821  22.215  -2.646  1.00  0.00           N  
ATOM   1364  NH2 ARG A  98      18.771  21.267  -3.398  1.00  0.00           N  
ATOM   1365  H   ARG A  98      12.931  22.168  -7.458  1.00  0.00           H  
ATOM   1366  HA  ARG A  98      14.932  22.209  -9.546  1.00  0.00           H  
ATOM   1367  HB2 ARG A  98      15.969  21.041  -7.044  1.00  0.00           H  
ATOM   1368  HB3 ARG A  98      16.809  21.940  -8.293  1.00  0.00           H  
ATOM   1369  HG2 ARG A  98      16.865  23.708  -6.973  1.00  0.00           H  
ATOM   1370  HG3 ARG A  98      15.109  23.755  -6.936  1.00  0.00           H  
ATOM   1371  HD2 ARG A  98      15.865  23.638  -4.685  1.00  0.00           H  
ATOM   1372  HD3 ARG A  98      15.178  22.067  -5.097  1.00  0.00           H  
ATOM   1373  HE  ARG A  98      17.852  21.829  -5.632  1.00  0.00           H  
ATOM   1374 HH11 ARG A  98      15.946  22.662  -2.830  1.00  0.00           H  
ATOM   1375 HH12 ARG A  98      17.101  22.032  -1.703  1.00  0.00           H  
ATOM   1376 HH21 ARG A  98      19.371  20.999  -4.151  1.00  0.00           H  
ATOM   1377 HH22 ARG A  98      19.045  21.088  -2.453  1.00  0.00           H  
ATOM   1378  N   GLY A  99      13.621  19.851  -7.681  1.00  0.00           N  
ATOM   1379  CA  GLY A  99      13.188  18.465  -7.669  1.00  0.00           C  
ATOM   1380  C   GLY A  99      13.476  17.783  -6.340  1.00  0.00           C  
ATOM   1381  O   GLY A  99      13.466  16.557  -6.251  1.00  0.00           O  
ATOM   1382  H   GLY A  99      13.424  20.427  -6.919  1.00  0.00           H  
ATOM   1383  HA2 GLY A  99      12.126  18.428  -7.859  1.00  0.00           H  
ATOM   1384  HA3 GLY A  99      13.703  17.931  -8.454  1.00  0.00           H  
ATOM   1385  N   MET A 100      13.737  18.587  -5.308  1.00  0.00           N  
ATOM   1386  CA  MET A 100      14.035  18.074  -3.981  1.00  0.00           C  
ATOM   1387  C   MET A 100      14.253  19.219  -2.995  1.00  0.00           C  
ATOM   1388  O   MET A 100      14.533  20.347  -3.397  1.00  0.00           O  
ATOM   1389  CB  MET A 100      15.275  17.183  -4.033  1.00  0.00           C  
ATOM   1390  CG  MET A 100      16.585  17.947  -4.151  1.00  0.00           C  
ATOM   1391  SD  MET A 100      17.836  17.370  -2.985  1.00  0.00           S  
ATOM   1392  CE  MET A 100      16.924  17.461  -1.445  1.00  0.00           C  
ATOM   1393  H   MET A 100      13.731  19.546  -5.444  1.00  0.00           H  
ATOM   1394  HA  MET A 100      13.190  17.491  -3.656  1.00  0.00           H  
ATOM   1395  HB2 MET A 100      15.307  16.587  -3.136  1.00  0.00           H  
ATOM   1396  HB3 MET A 100      15.191  16.528  -4.887  1.00  0.00           H  
ATOM   1397  HG2 MET A 100      16.966  17.825  -5.152  1.00  0.00           H  
ATOM   1398  HG3 MET A 100      16.397  18.992  -3.965  1.00  0.00           H  
ATOM   1399  HE1 MET A 100      16.383  18.392  -1.402  1.00  0.00           H  
ATOM   1400  HE2 MET A 100      17.613  17.404  -0.615  1.00  0.00           H  
ATOM   1401  HE3 MET A 100      16.228  16.637  -1.390  1.00  0.00           H  
ATOM   1402  N   ILE A 101      14.131  18.920  -1.705  1.00  0.00           N  
ATOM   1403  CA  ILE A 101      14.322  19.930  -0.667  1.00  0.00           C  
ATOM   1404  C   ILE A 101      15.074  19.345   0.527  1.00  0.00           C  
ATOM   1405  O   ILE A 101      14.884  18.183   0.885  1.00  0.00           O  
ATOM   1406  CB  ILE A 101      12.970  20.551  -0.211  1.00  0.00           C  
ATOM   1407  CG1 ILE A 101      12.759  20.424   1.302  1.00  0.00           C  
ATOM   1408  CG2 ILE A 101      11.805  19.918  -0.955  1.00  0.00           C  
ATOM   1409  CD1 ILE A 101      11.485  21.089   1.779  1.00  0.00           C  
ATOM   1410  H   ILE A 101      13.913  18.001  -1.445  1.00  0.00           H  
ATOM   1411  HA  ILE A 101      14.925  20.720  -1.093  1.00  0.00           H  
ATOM   1412  HB  ILE A 101      12.991  21.598  -0.468  1.00  0.00           H  
ATOM   1413 HG12 ILE A 101      12.706  19.378   1.567  1.00  0.00           H  
ATOM   1414 HG13 ILE A 101      13.591  20.885   1.815  1.00  0.00           H  
ATOM   1415 HG21 ILE A 101      12.033  19.877  -2.010  1.00  0.00           H  
ATOM   1416 HG22 ILE A 101      10.916  20.512  -0.803  1.00  0.00           H  
ATOM   1417 HG23 ILE A 101      11.640  18.919  -0.582  1.00  0.00           H  
ATOM   1418 HD11 ILE A 101      10.869  21.341   0.927  1.00  0.00           H  
ATOM   1419 HD12 ILE A 101      11.731  21.990   2.323  1.00  0.00           H  
ATOM   1420 HD13 ILE A 101      10.946  20.414   2.424  1.00  0.00           H  
ATOM   1421  N   GLN A 102      15.929  20.162   1.137  1.00  0.00           N  
ATOM   1422  CA  GLN A 102      16.709  19.727   2.288  1.00  0.00           C  
ATOM   1423  C   GLN A 102      15.935  19.957   3.580  1.00  0.00           C  
ATOM   1424  O   GLN A 102      15.257  20.971   3.735  1.00  0.00           O  
ATOM   1425  CB  GLN A 102      18.043  20.474   2.339  1.00  0.00           C  
ATOM   1426  CG  GLN A 102      19.146  19.704   3.048  1.00  0.00           C  
ATOM   1427  CD  GLN A 102      20.124  20.614   3.764  1.00  0.00           C  
ATOM   1428  OE1 GLN A 102      20.069  20.767   4.985  1.00  0.00           O  
ATOM   1429  NE2 GLN A 102      21.027  21.224   3.007  1.00  0.00           N  
ATOM   1430  H   GLN A 102      16.036  21.075   0.806  1.00  0.00           H  
ATOM   1431  HA  GLN A 102      16.902  18.669   2.180  1.00  0.00           H  
ATOM   1432  HB2 GLN A 102      18.368  20.675   1.329  1.00  0.00           H  
ATOM   1433  HB3 GLN A 102      17.898  21.410   2.855  1.00  0.00           H  
ATOM   1434  HG2 GLN A 102      18.696  19.041   3.772  1.00  0.00           H  
ATOM   1435  HG3 GLN A 102      19.687  19.121   2.316  1.00  0.00           H  
ATOM   1436 HE21 GLN A 102      21.013  21.055   2.038  1.00  0.00           H  
ATOM   1437 HE22 GLN A 102      21.675  21.820   3.446  1.00  0.00           H  
ATOM   1438  N   LEU A 103      16.037  19.006   4.500  1.00  0.00           N  
ATOM   1439  CA  LEU A 103      15.340  19.109   5.773  1.00  0.00           C  
ATOM   1440  C   LEU A 103      16.173  18.521   6.906  1.00  0.00           C  
ATOM   1441  O   LEU A 103      16.398  17.312   6.964  1.00  0.00           O  
ATOM   1442  CB  LEU A 103      13.991  18.391   5.697  1.00  0.00           C  
ATOM   1443  CG  LEU A 103      12.848  19.225   5.110  1.00  0.00           C  
ATOM   1444  CD1 LEU A 103      11.969  18.369   4.212  1.00  0.00           C  
ATOM   1445  CD2 LEU A 103      12.024  19.854   6.223  1.00  0.00           C  
ATOM   1446  H   LEU A 103      16.590  18.217   4.319  1.00  0.00           H  
ATOM   1447  HA  LEU A 103      15.168  20.155   5.975  1.00  0.00           H  
ATOM   1448  HB2 LEU A 103      14.112  17.506   5.092  1.00  0.00           H  
ATOM   1449  HB3 LEU A 103      13.709  18.090   6.694  1.00  0.00           H  
ATOM   1450  HG  LEU A 103      13.263  20.020   4.508  1.00  0.00           H  
ATOM   1451 HD11 LEU A 103      12.504  18.133   3.304  1.00  0.00           H  
ATOM   1452 HD12 LEU A 103      11.067  18.910   3.967  1.00  0.00           H  
ATOM   1453 HD13 LEU A 103      11.711  17.453   4.724  1.00  0.00           H  
ATOM   1454 HD21 LEU A 103      11.545  19.076   6.800  1.00  0.00           H  
ATOM   1455 HD22 LEU A 103      11.268  20.496   5.792  1.00  0.00           H  
ATOM   1456 HD23 LEU A 103      12.668  20.435   6.865  1.00  0.00           H  
ATOM   1457  N   ILE A 104      16.618  19.385   7.812  1.00  0.00           N  
ATOM   1458  CA  ILE A 104      17.413  18.949   8.952  1.00  0.00           C  
ATOM   1459  C   ILE A 104      16.522  18.718  10.161  1.00  0.00           C  
ATOM   1460  O   ILE A 104      15.561  19.454  10.388  1.00  0.00           O  
ATOM   1461  CB  ILE A 104      18.504  19.974   9.317  1.00  0.00           C  
ATOM   1462  CG1 ILE A 104      19.418  20.223   8.122  1.00  0.00           C  
ATOM   1463  CG2 ILE A 104      19.315  19.490  10.511  1.00  0.00           C  
ATOM   1464  CD1 ILE A 104      20.017  18.961   7.539  1.00  0.00           C  
ATOM   1465  H   ILE A 104      16.400  20.335   7.717  1.00  0.00           H  
ATOM   1466  HA  ILE A 104      17.893  18.020   8.688  1.00  0.00           H  
ATOM   1467  HB  ILE A 104      18.022  20.899   9.592  1.00  0.00           H  
ATOM   1468 HG12 ILE A 104      18.853  20.711   7.341  1.00  0.00           H  
ATOM   1469 HG13 ILE A 104      20.231  20.863   8.431  1.00  0.00           H  
ATOM   1470 HG21 ILE A 104      19.808  18.562  10.261  1.00  0.00           H  
ATOM   1471 HG22 ILE A 104      18.656  19.329  11.354  1.00  0.00           H  
ATOM   1472 HG23 ILE A 104      20.054  20.233  10.770  1.00  0.00           H  
ATOM   1473 HD11 ILE A 104      21.014  19.169   7.179  1.00  0.00           H  
ATOM   1474 HD12 ILE A 104      19.403  18.615   6.722  1.00  0.00           H  
ATOM   1475 HD13 ILE A 104      20.062  18.198   8.302  1.00  0.00           H  
ATOM   1476  N   VAL A 105      16.843  17.689  10.927  1.00  0.00           N  
ATOM   1477  CA  VAL A 105      16.065  17.353  12.111  1.00  0.00           C  
ATOM   1478  C   VAL A 105      16.953  16.894  13.260  1.00  0.00           C  
ATOM   1479  O   VAL A 105      18.175  16.824  13.129  1.00  0.00           O  
ATOM   1480  CB  VAL A 105      15.037  16.247  11.806  1.00  0.00           C  
ATOM   1481  CG1 VAL A 105      13.923  16.782  10.921  1.00  0.00           C  
ATOM   1482  CG2 VAL A 105      15.719  15.052  11.157  1.00  0.00           C  
ATOM   1483  H   VAL A 105      17.623  17.143  10.687  1.00  0.00           H  
ATOM   1484  HA  VAL A 105      15.527  18.239  12.415  1.00  0.00           H  
ATOM   1485  HB  VAL A 105      14.602  15.922  12.739  1.00  0.00           H  
ATOM   1486 HG11 VAL A 105      13.552  15.986  10.290  1.00  0.00           H  
ATOM   1487 HG12 VAL A 105      14.304  17.582  10.304  1.00  0.00           H  
ATOM   1488 HG13 VAL A 105      13.119  17.156  11.539  1.00  0.00           H  
ATOM   1489 HG21 VAL A 105      15.202  14.147  11.439  1.00  0.00           H  
ATOM   1490 HG22 VAL A 105      16.746  14.999  11.490  1.00  0.00           H  
ATOM   1491 HG23 VAL A 105      15.693  15.163  10.082  1.00  0.00           H  
ATOM   1492  N   ALA A 106      16.322  16.578  14.386  1.00  0.00           N  
ATOM   1493  CA  ALA A 106      17.037  16.115  15.566  1.00  0.00           C  
ATOM   1494  C   ALA A 106      16.391  14.854  16.129  1.00  0.00           C  
ATOM   1495  O   ALA A 106      15.170  14.781  16.264  1.00  0.00           O  
ATOM   1496  CB  ALA A 106      17.077  17.209  16.624  1.00  0.00           C  
ATOM   1497  H   ALA A 106      15.347  16.653  14.421  1.00  0.00           H  
ATOM   1498  HA  ALA A 106      18.054  15.891  15.274  1.00  0.00           H  
ATOM   1499  HB1 ALA A 106      17.119  16.759  17.604  1.00  0.00           H  
ATOM   1500  HB2 ALA A 106      16.187  17.816  16.546  1.00  0.00           H  
ATOM   1501  HB3 ALA A 106      17.949  17.827  16.471  1.00  0.00           H  
ATOM   1502  N   ARG A 107      17.217  13.865  16.449  1.00  0.00           N  
ATOM   1503  CA  ARG A 107      16.724  12.605  16.994  1.00  0.00           C  
ATOM   1504  C   ARG A 107      17.326  12.342  18.370  1.00  0.00           C  
ATOM   1505  O   ARG A 107      18.519  12.549  18.586  1.00  0.00           O  
ATOM   1506  CB  ARG A 107      17.051  11.451  16.039  1.00  0.00           C  
ATOM   1507  CG  ARG A 107      16.779  10.071  16.620  1.00  0.00           C  
ATOM   1508  CD  ARG A 107      15.333   9.927  17.065  1.00  0.00           C  
ATOM   1509  NE  ARG A 107      14.534   9.178  16.099  1.00  0.00           N  
ATOM   1510  CZ  ARG A 107      14.582   7.854  15.963  1.00  0.00           C  
ATOM   1511  NH1 ARG A 107      15.391   7.131  16.729  1.00  0.00           N  
ATOM   1512  NH2 ARG A 107      13.820   7.252  15.060  1.00  0.00           N  
ATOM   1513  H   ARG A 107      18.180  13.983  16.315  1.00  0.00           H  
ATOM   1514  HA  ARG A 107      15.652  12.686  17.092  1.00  0.00           H  
ATOM   1515  HB2 ARG A 107      16.459  11.562  15.144  1.00  0.00           H  
ATOM   1516  HB3 ARG A 107      18.097  11.505  15.776  1.00  0.00           H  
ATOM   1517  HG2 ARG A 107      16.986   9.327  15.865  1.00  0.00           H  
ATOM   1518  HG3 ARG A 107      17.426   9.916  17.470  1.00  0.00           H  
ATOM   1519  HD2 ARG A 107      15.313   9.409  18.014  1.00  0.00           H  
ATOM   1520  HD3 ARG A 107      14.906  10.911  17.186  1.00  0.00           H  
ATOM   1521  HE  ARG A 107      13.928   9.687  15.522  1.00  0.00           H  
ATOM   1522 HH11 ARG A 107      15.968   7.579  17.411  1.00  0.00           H  
ATOM   1523 HH12 ARG A 107      15.423   6.137  16.622  1.00  0.00           H  
ATOM   1524 HH21 ARG A 107      13.210   7.792  14.482  1.00  0.00           H  
ATOM   1525 HH22 ARG A 107      13.857   6.257  14.958  1.00  0.00           H  
ATOM   1526  N   ARG A 108      16.490  11.886  19.297  1.00  0.00           N  
ATOM   1527  CA  ARG A 108      16.940  11.597  20.653  1.00  0.00           C  
ATOM   1528  C   ARG A 108      17.736  10.297  20.702  1.00  0.00           C  
ATOM   1529  O   ARG A 108      17.722   9.511  19.755  1.00  0.00           O  
ATOM   1530  CB  ARG A 108      15.745  11.517  21.606  1.00  0.00           C  
ATOM   1531  CG  ARG A 108      16.005  12.151  22.962  1.00  0.00           C  
ATOM   1532  CD  ARG A 108      16.125  13.664  22.859  1.00  0.00           C  
ATOM   1533  NE  ARG A 108      15.014  14.343  23.522  1.00  0.00           N  
ATOM   1534  CZ  ARG A 108      14.528  15.525  23.145  1.00  0.00           C  
ATOM   1535  NH1 ARG A 108      15.053  16.173  22.111  1.00  0.00           N  
ATOM   1536  NH2 ARG A 108      13.512  16.064  23.806  1.00  0.00           N  
ATOM   1537  H   ARG A 108      15.550  11.741  19.064  1.00  0.00           H  
ATOM   1538  HA  ARG A 108      17.580  12.408  20.965  1.00  0.00           H  
ATOM   1539  HB2 ARG A 108      14.904  12.019  21.153  1.00  0.00           H  
ATOM   1540  HB3 ARG A 108      15.493  10.477  21.761  1.00  0.00           H  
ATOM   1541  HG2 ARG A 108      15.188  11.910  23.623  1.00  0.00           H  
ATOM   1542  HG3 ARG A 108      16.925  11.753  23.366  1.00  0.00           H  
ATOM   1543  HD2 ARG A 108      17.051  13.971  23.323  1.00  0.00           H  
ATOM   1544  HD3 ARG A 108      16.137  13.939  21.816  1.00  0.00           H  
ATOM   1545  HE  ARG A 108      14.604  13.892  24.291  1.00  0.00           H  
ATOM   1546 HH11 ARG A 108      15.819  15.778  21.609  1.00  0.00           H  
ATOM   1547 HH12 ARG A 108      14.680  17.059  21.839  1.00  0.00           H  
ATOM   1548 HH21 ARG A 108      13.112  15.581  24.586  1.00  0.00           H  
ATOM   1549 HH22 ARG A 108      13.146  16.951  23.526  1.00  0.00           H  
ATOM   1550  N   ILE A 109      18.431  10.082  21.813  1.00  0.00           N  
ATOM   1551  CA  ILE A 109      19.238   8.882  21.994  1.00  0.00           C  
ATOM   1552  C   ILE A 109      18.994   8.265  23.370  1.00  0.00           C  
ATOM   1553  O   ILE A 109      18.570   8.949  24.300  1.00  0.00           O  
ATOM   1554  CB  ILE A 109      20.741   9.194  21.835  1.00  0.00           C  
ATOM   1555  CG1 ILE A 109      21.006   9.845  20.478  1.00  0.00           C  
ATOM   1556  CG2 ILE A 109      21.569   7.928  21.995  1.00  0.00           C  
ATOM   1557  CD1 ILE A 109      21.210  11.341  20.541  1.00  0.00           C  
ATOM   1558  H   ILE A 109      18.402  10.749  22.530  1.00  0.00           H  
ATOM   1559  HA  ILE A 109      18.955   8.169  21.233  1.00  0.00           H  
ATOM   1560  HB  ILE A 109      21.025   9.876  22.614  1.00  0.00           H  
ATOM   1561 HG12 ILE A 109      21.895   9.412  20.043  1.00  0.00           H  
ATOM   1562 HG13 ILE A 109      20.165   9.662  19.832  1.00  0.00           H  
ATOM   1563 HG21 ILE A 109      21.174   7.154  21.353  1.00  0.00           H  
ATOM   1564 HG22 ILE A 109      21.529   7.598  23.022  1.00  0.00           H  
ATOM   1565 HG23 ILE A 109      22.594   8.133  21.722  1.00  0.00           H  
ATOM   1566 HD11 ILE A 109      21.657  11.681  19.619  1.00  0.00           H  
ATOM   1567 HD12 ILE A 109      21.860  11.584  21.365  1.00  0.00           H  
ATOM   1568 HD13 ILE A 109      20.258  11.823  20.678  1.00  0.00           H  
ATOM   1569  N   SER A 110      19.265   6.968  23.489  1.00  0.00           N  
ATOM   1570  CA  SER A 110      19.073   6.263  24.750  1.00  0.00           C  
ATOM   1571  C   SER A 110      19.693   4.871  24.698  1.00  0.00           C  
ATOM   1572  O   SER A 110      20.357   4.512  23.725  1.00  0.00           O  
ATOM   1573  CB  SER A 110      17.582   6.158  25.077  1.00  0.00           C  
ATOM   1574  OG  SER A 110      16.930   5.254  24.203  1.00  0.00           O  
ATOM   1575  H   SER A 110      19.601   6.476  22.711  1.00  0.00           H  
ATOM   1576  HA  SER A 110      19.563   6.834  25.527  1.00  0.00           H  
ATOM   1577  HB2 SER A 110      17.463   5.806  26.091  1.00  0.00           H  
ATOM   1578  HB3 SER A 110      17.124   7.131  24.978  1.00  0.00           H  
ATOM   1579  HG  SER A 110      17.147   4.353  24.454  1.00  0.00           H  
TER    1580      SER A 110                                                      
END
MOLECULE T0488.pdb
ATOM      1  N   SER     1      20.128  12.809  24.526  1.00 19.40           N
ATOM      2  CA  SER     1      20.938  12.899  23.283  1.00 14.62           C
ATOM      4  CB  SER     1      21.786  11.646  23.101  1.00 17.49           C
ATOM      7  OG  SER     1      20.984  10.481  22.955  1.00 25.56           O
ATOM      9  C   SER     1      20.052  13.074  22.065  1.00 13.47           C
ATOM     10  O   SER     1      18.834  12.879  22.117  1.00 15.69           O
ATOM     14  N   MET     2      20.684  13.412  20.957  1.00 10.92           N
ATOM     15  CA  MET     2      20.000  13.465  19.689  1.00  9.70           C
ATOM     17  CB  MET     2      19.319  14.815  19.493  1.00 12.91           C
ATOM     20  CG  MET     2      20.286  15.963  19.402  1.00 15.71           C
ATOM     23  SD  MET     2      19.467  17.568  19.366  1.00 19.52           S
ATOM     24  CE  MET     2      18.819  17.665  21.032  1.00 31.08           C
ATOM     28  C   MET     2      20.956  13.195  18.552  1.00  9.06           C
ATOM     29  O   MET     2      22.158  13.370  18.682  1.00 13.20           O
ATOM     31  N   GLU     3      20.384  12.759  17.442  1.00  7.47           N
ATOM     32  CA  GLU     3      21.090  12.632  16.203  1.00  7.61           C
ATOM     34  CB  GLU     3      20.756  11.297  15.535  1.00  9.77           C
ATOM     37  CG  GLU     3      21.552  11.077  14.264  1.00 14.79           C
ATOM     40  CD  GLU     3      21.122   9.855  13.502  1.00 26.53           C
ATOM     41  OE1 GLU     3      20.303   9.074  14.028  1.00 31.96           O
ATOM     42  OE2 GLU     3      21.613   9.684  12.363  1.00 32.73           O
ATOM     43  C   GLU     3      20.689  13.781  15.297  1.00  8.80           C
ATOM     44  O   GLU     3      19.509  14.082  15.173  1.00 10.63           O
ATOM     46  N   ILE     4      21.679  14.418  14.693  1.00  7.18           N
ATOM     47  CA  ILE     4      21.451  15.424  13.665  1.00  7.38           C
ATOM     49  CB  ILE     4      22.306  16.675  13.857  1.00  9.41           C
ATOM     51  CG1 ILE     4      22.197  17.198  15.271  1.00 12.88           C
ATOM     54  CD1 ILE     4      20.874  17.635  15.639  1.00 14.81           C
ATOM     58  CG2 ILE     4      21.949  17.745  12.806  1.00 11.50           C
ATOM     62  C   ILE     4      21.801  14.808  12.341  1.00  7.35           C
ATOM     63  O   ILE     4      22.895  14.249  12.178  1.00  9.86           O
ATOM     65  N   LEU     5      20.875  14.902  11.402  1.00  7.58           N
ATOM     66  CA  LEU     5      21.132  14.378  10.062  1.00  8.65           C
ATOM     68  CB  LEU     5      20.731  12.925   9.943  1.00 13.90           C
ATOM     71  CG  LEU     5      19.252  12.666  10.057  1.00 13.10           C
ATOM     73  CD1 LEU     5      18.882  11.388   9.287  1.00 20.34           C
ATOM     77  CD2 LEU     5      18.772  12.562  11.493  1.00 19.29           C
ATOM     81  C   LEU     5      20.456  15.222   8.993  1.00  7.20           C
ATOM     82  O   LEU     5      19.584  16.031   9.280  1.00  8.46           O
ATOM     84  N   GLN     6      20.928  15.069   7.768  1.00  7.20           N
ATOM     85  CA  GLN     6      20.395  15.791   6.642  1.00  7.97           C
ATOM     87  CB  GLN     6      21.472  16.631   5.956  1.00 11.22           C
ATOM     90  CG  GLN     6      22.010  17.704   6.886  1.00 17.34           C
ATOM     93  CD  GLN     6      22.853  18.757   6.211  1.00 25.58           C
ATOM     94  OE1 GLN     6      22.673  19.078   5.034  1.00 22.54           O
ATOM     95  NE2 GLN     6      23.778  19.328   6.973  1.00 35.80           N
ATOM     98  C   GLN     6      19.774  14.804   5.678  1.00  8.78           C
ATOM     99  O   GLN     6      20.362  13.773   5.376  1.00 12.62           O
ATOM    101  N   VAL     7      18.567  15.128   5.237  1.00  6.69           N
ATOM    102  CA  VAL     7      17.825  14.314   4.312  1.00  6.49           C
ATOM    104  CB  VAL     7      16.555  13.757   4.961  1.00  7.24           C
ATOM    106  CG1 VAL     7      15.691  13.030   3.954  1.00  9.62           C
ATOM    110  CG2 VAL     7      16.911  12.821   6.122  1.00  9.31           C
ATOM    114  C   VAL     7      17.450  15.146   3.110  1.00  6.92           C
ATOM    115  O   VAL     7      16.765  16.128   3.242  1.00  9.54           O
ATOM    117  N   ALA     8      17.874  14.713   1.934  1.00  7.20           N
ATOM    118  CA  ALA     8      17.555  15.401   0.689  1.00  8.32           C
ATOM    120  CB  ALA     8      18.823  15.574  -0.152  1.00 12.50           C
ATOM    124  C   ALA     8      16.514  14.615  -0.079  1.00  7.94           C
ATOM    125  O   ALA     8      16.711  13.451  -0.375  1.00 12.11           O
ATOM    127  N   LEU     9      15.396  15.253  -0.365  1.00  7.05           N
ATOM    128  CA  LEU     9      14.331  14.704  -1.186  1.00  7.53           C
ATOM    130  CB  LEU     9      12.989  14.824  -0.479  1.00  7.05           C
ATOM    133  CG  LEU     9      12.915  14.175   0.902  1.00  6.94           C
ATOM    135  CD1 LEU     9      11.557  14.422   1.532  1.00 10.28           C
ATOM    139  CD2 LEU     9      13.241  12.665   0.874  1.00  9.01           C
ATOM    143  C   LEU     9      14.296  15.466  -2.509  1.00  6.69           C
ATOM    144  O   LEU     9      14.683  16.629  -2.573  1.00  9.96           O
ATOM    146  N   HIS    10      13.820  14.806  -3.557  1.00  7.45           N
ATOM    147  CA  HIS    10      13.788  15.443  -4.867  1.00  8.58           C
ATOM    149  CB  HIS    10      14.817  14.786  -5.773  1.00 10.46           C
ATOM    152  CG  HIS    10      16.223  15.001  -5.303  1.00 12.40           C
ATOM    153  ND1 HIS    10      16.996  16.053  -5.741  1.00 16.70           N
ATOM    155  CE1 HIS    10      18.175  16.010  -5.143  1.00 18.81           C
ATOM    157  NE2 HIS    10      18.179  14.989  -4.305  1.00 19.15           N
ATOM    159  CD2 HIS    10      16.965  14.349  -4.376  1.00 19.64           C
ATOM    161  C   HIS    10      12.402  15.443  -5.494  1.00  7.84           C
ATOM    162  O   HIS    10      11.834  14.379  -5.778  1.00 11.03           O
ATOM    164  N   LYS    11      11.837  16.643  -5.638  1.00  9.81           N
ATOM    165  CA  LYS    11      10.512  16.790  -6.253  1.00 10.04           C
ATOM    167  CB  LYS    11       9.985  18.217  -6.073  1.00 12.34           C
ATOM    170  CG  LYS    11       9.686  18.625  -4.623  1.00 12.62           C
ATOM    173  CD  LYS    11       8.576  19.704  -4.546  1.00 31.05           C
ATOM    176  CE  LYS    11       8.996  21.073  -5.051  1.00 24.45           C
ATOM    179  NZ  LYS    11       8.322  22.218  -4.361  1.00 21.96           N
ATOM    183  C   LYS    11      10.588  16.474  -7.733  1.00 12.69           C
ATOM    184  O   LYS    11      11.432  17.042  -8.419  1.00 14.69           O
ATOM    186  N   ARG    12       9.704  15.604  -8.215  1.00 13.65           N
ATOM    187  CA  ARG    12       9.688  15.217  -9.636  1.00 17.02           C
ATOM    189  CB  ARG    12       9.080  13.819  -9.812  1.00 18.82           C
ATOM    192  CG  ARG    12       9.882  12.720  -9.103  1.00 23.83           C
ATOM    195  CD  ARG    12      10.108  11.497  -9.984  1.00 35.96           C
ATOM    198  NE  ARG    12      10.943  10.483  -9.336  1.00 41.80           N
ATOM    200  CZ  ARG    12      11.421   9.393  -9.940  1.00 38.74           C
ATOM    201  NH1 ARG    12      11.158   9.156 -11.222  1.00 41.88           N
ATOM    204  NH2 ARG    12      12.172   8.530  -9.257  1.00 33.93           N
ATOM    207  C   ARG    12       8.948  16.257 -10.475  1.00 17.99           C
ATOM    208  O   ARG    12       9.156  16.335 -11.696  1.00 22.78           O
ATOM    210  N   ASP    13       8.081  17.035  -9.822  1.00 16.60           N
ATOM    211  CA  ASP    13       7.475  18.241 -10.404  1.00 17.38           C
ATOM    213  CB  ASP    13       6.064  17.959 -10.970  1.00 19.09           C
ATOM    216  CG  ASP    13       5.028  17.642  -9.898  1.00 19.81           C
ATOM    217  OD1 ASP    13       4.382  18.582  -9.384  1.00 22.06           O
ATOM    218  OD2 ASP    13       4.810  16.436  -9.621  1.00 23.43           O
ATOM    219  C   ASP    13       7.449  19.320  -9.327  1.00 14.18           C
ATOM    220  O   ASP    13       7.531  19.010  -8.142  1.00 14.00           O
ATOM    222  N   SER    14       7.329  20.578  -9.725  1.00 13.19           N
ATOM    223  CA  SER    14       7.384  21.702  -8.783  1.00 13.78           C
ATOM    225  CB  SER    14       7.433  23.044  -9.519  1.00 14.22           C
ATOM    228  OG  SER    14       6.243  23.269 -10.244  1.00 16.20           O
ATOM    230  C   SER    14       6.252  21.710  -7.764  1.00 11.76           C
ATOM    231  O   SER    14       6.341  22.373  -6.725  1.00 14.54           O
ATOM    233  N   GLY    15       5.172  20.998  -8.084  1.00 11.38           N
ATOM    234  CA  GLY    15       4.049  20.871  -7.180  1.00 10.63           C
ATOM    237  C   GLY    15       3.987  19.585  -6.383  1.00 10.54           C
ATOM    238  O   GLY    15       2.994  19.372  -5.694  1.00 11.58           O
ATOM    240  N   GLU    16       5.011  18.735  -6.462  1.00 10.14           N
ATOM    241  CA  GLU    16       4.979  17.475  -5.723  1.00 10.90           C
ATOM    243  CB  GLU    16       6.077  16.500  -6.154  1.00 11.37           C
ATOM    246  CG  GLU    16       5.878  15.118  -5.509  1.00 13.41           C
ATOM    249  CD  GLU    16       6.796  14.031  -6.016  1.00 14.39           C
ATOM    250  OE1 GLU    16       7.821  14.327  -6.657  1.00 17.24           O
ATOM    251  OE2 GLU    16       6.498  12.847  -5.728  1.00 19.88           O
ATOM    252  C   GLU    16       5.094  17.732  -4.229  1.00 11.70           C
ATOM    253  O   GLU    16       5.900  18.539  -3.792  1.00 12.51           O
ATOM    255  N   GLN    17       4.285  17.037  -3.431  1.00 13.12           N
ATOM    256  CA  GLN    17       4.419  17.166  -1.988  1.00 13.43           C
ATOM    258  CB  GLN    17       3.109  16.888  -1.274  1.00 17.00           C
ATOM    261  CG  GLN    17       2.086  17.994  -1.457  0.50 13.19           C
ATOM    264  CD  GLN    17       0.701  17.540  -1.069  0.50 12.56           C
ATOM    265  OE1 GLN    17       0.216  16.501  -1.557  0.50 18.97           O
ATOM    266  NE2 GLN    17       0.049  18.301  -0.192  0.50 15.21           N
ATOM    269  C   GLN    17       5.510  16.223  -1.502  1.00  9.97           C
ATOM    270  O   GLN    17       5.923  15.294  -2.196  1.00 11.21           O
ATOM    272  N   LEU    18       5.980  16.475  -0.298  1.00  9.09           N
ATOM    273  CA  LEU    18       7.002  15.642   0.309  1.00  7.79           C
ATOM    275  CB  LEU    18       7.785  16.430   1.341  1.00 10.03           C
ATOM    278  CG  LEU    18       8.464  17.680   0.774  1.00 13.65           C
ATOM    280  CD1 LEU    18       9.327  18.337   1.851  1.00 16.68           C
ATOM    284  CD2 LEU    18       9.285  17.333  -0.465  1.00 14.79           C
ATOM    288  C   LEU    18       6.406  14.423   0.970  1.00  6.95           C
ATOM    289  O   LEU    18       7.112  13.436   1.174  1.00  7.83           O
ATOM    291  N   GLY    19       5.127  14.475   1.336  1.00  6.45           N
ATOM    292  CA  GLY    19       4.529  13.361   2.072  1.00  5.80           C
ATOM    295  C   GLY    19       4.856  13.345   3.551  1.00  5.53           C
ATOM    296  O   GLY    19       5.144  12.296   4.119  1.00  6.57           O
ATOM    298  N   ILE    20       4.790  14.519   4.179  1.00  6.22           N
ATOM    299  CA  ILE    20       5.150  14.697   5.587  1.00  6.82           C
ATOM    301  CB  ILE    20       6.489  15.508   5.743  1.00  8.22           C
ATOM    303  CG1 ILE    20       7.649  14.867   4.981  1.00  9.99           C
ATOM    306  CD1 ILE    20       8.873  15.766   4.839  1.00 13.13           C
ATOM    310  CG2 ILE    20       6.832  15.684   7.223  1.00 12.01           C
ATOM    314  C   ILE    20       4.027  15.459   6.274  1.00  6.99           C
ATOM    315  O   ILE    20       3.566  16.461   5.762  1.00  9.28           O
ATOM    317  N   LYS    21       3.586  14.957   7.413  1.00  7.07           N
ATOM    318  CA  LYS    21       2.690  15.683   8.288  1.00  6.19           C
ATOM    320  CB  LYS    21       1.699  14.734   8.954  1.00  8.22           C
ATOM    323  CG  LYS    21       0.953  13.836   7.994  1.00 15.14           C
ATOM    326  CD  LYS    21      -0.238  13.152   8.664  1.00 20.17           C
ATOM    329  CE  LYS    21      -0.766  11.971   7.851  1.00 17.14           C
ATOM    332  NZ  LYS    21      -1.781  11.169   8.587  1.00 23.82           N
ATOM    336  C   LYS    21       3.510  16.425   9.341  1.00  8.23           C
ATOM    337  O   LYS    21       4.179  15.810  10.163  1.00  8.25           O
ATOM    339  N   LEU    22       3.477  17.754   9.278  1.00  6.53           N
ATOM    340  CA  LEU    22       4.253  18.608  10.175  1.00  7.05           C
ATOM    342  CB  LEU    22       4.977  19.717   9.405  1.00  9.04           C
ATOM    345  CG  LEU    22       6.120  19.350   8.473  1.00 11.98           C
ATOM    347  CD1 LEU    22       6.685  20.618   7.819  1.00 16.38           C
ATOM    351  CD2 LEU    22       7.190  18.609   9.229  1.00 12.08           C
ATOM    355  C   LEU    22       3.340  19.222  11.220  1.00  6.95           C
ATOM    356  O   LEU    22       2.267  19.693  10.894  1.00  8.65           O
ATOM    358  N   VAL    23       3.808  19.255  12.458  1.00  6.35           N
ATOM    359  CA  VAL    23       3.041  19.777  13.571  1.00  6.35           C
ATOM    361  CB  VAL    23       2.419  18.631  14.430  1.00  7.14           C
ATOM    363  CG1 VAL    23       1.471  17.776  13.574  1.00 10.40           C
ATOM    367  CG2 VAL    23       3.466  17.784  15.139  1.00  8.76           C
ATOM    371  C   VAL    23       3.855  20.658  14.495  1.00  6.32           C
ATOM    372  O   VAL    23       5.072  20.554  14.588  1.00  7.02           O
ATOM    374  N   ARG    24       3.147  21.542  15.177  1.00  6.06           N
ATOM    375  CA  ARG    24       3.667  22.214  16.353  1.00  6.42           C
ATOM    377  CB  ARG    24       3.154  23.651  16.436  1.00  7.91           C
ATOM    380  CG  ARG    24       1.670  23.812  16.738  1.00  8.11           C
ATOM    383  CD  ARG    24       1.240  25.229  16.426  1.00 11.78           C
ATOM    386  NE  ARG    24      -0.147  25.442  16.818  1.00 11.84           N
ATOM    388  CZ  ARG    24      -0.924  26.419  16.356  1.00 13.32           C
ATOM    389  NH1 ARG    24      -0.470  27.304  15.491  1.00 13.58           N
ATOM    392  NH2 ARG    24      -2.176  26.505  16.774  1.00 15.33           N
ATOM    395  C   ARG    24       3.277  21.419  17.588  1.00  7.93           C
ATOM    396  O   ARG    24       2.320  20.643  17.569  1.00 10.12           O
ATOM    398  N   ARG    25       4.018  21.637  18.670  1.00  7.87           N
ATOM    399  CA  ARG    25       3.751  20.948  19.936  1.00 10.55           C
ATOM    401  CB  ARG    25       4.972  20.177  20.387  1.00 11.13           C
ATOM    404  CG  ARG    25       5.165  18.961  19.570  1.00 14.31           C
ATOM    407  CD  ARG    25       6.317  18.166  20.053  1.00 14.64           C
ATOM    410  NE  ARG    25       6.432  16.964  19.256  1.00 20.85           N
ATOM    412  CZ  ARG    25       7.389  16.056  19.399  1.00 21.75           C
ATOM    413  NH1 ARG    25       8.324  16.190  20.332  1.00 26.11           N
ATOM    416  NH2 ARG    25       7.410  15.002  18.596  1.00 19.78           N
ATOM    419  C   ARG    25       3.407  21.916  21.018  1.00 12.37           C
ATOM    420  O   ARG    25       3.895  23.032  21.024  1.00 12.41           O
ATOM    422  N   THR    26       2.593  21.449  21.958  1.00 13.46           N
ATOM    423  CA  THR    26       2.064  22.292  23.024  1.00 16.07           C
ATOM    425  CB  THR    26       0.724  21.742  23.541  1.00 15.98           C
ATOM    427  OG1 THR    26       0.901  20.365  23.892  1.00 20.67           O
ATOM    429  CG2 THR    26      -0.319  21.846  22.445  1.00 18.95           C
ATOM    433  C   THR    26       3.003  22.470  24.213  1.00 14.82           C
ATOM    434  O   THR    26       2.719  23.286  25.078  1.00 19.95           O
ATOM    436  N   ASP    27       4.122  21.754  24.245  1.00 16.37           N
ATOM    437  CA  ASP    27       5.000  21.772  25.411  1.00 18.65           C
ATOM    439  CB  ASP    27       4.850  20.464  26.181  1.00 23.44           C
ATOM    442  CG  ASP    27       5.179  19.239  25.334  1.00 31.95           C
ATOM    443  OD1 ASP    27       5.466  19.385  24.118  1.00 29.18           O
ATOM    444  OD2 ASP    27       5.137  18.121  25.887  1.00 45.79           O
ATOM    445  C   ASP    27       6.472  21.999  25.078  1.00 17.69           C
ATOM    446  O   ASP    27       7.320  21.926  25.961  1.00 20.53           O
ATOM    448  N   GLU    28       6.790  22.264  23.815  1.00 15.18           N
ATOM    449  CA  GLU    28       8.160  22.554  23.416  1.00 15.75           C
ATOM    451  CB  GLU    28       8.999  21.268  23.355  1.00 17.87           C
ATOM    454  CG  GLU    28       8.564  20.268  22.295  1.00 15.99           C
ATOM    457  CD  GLU    28       9.431  19.010  22.286  1.00 17.81           C
ATOM    458  OE1 GLU    28      10.659  19.146  22.161  1.00 25.99           O
ATOM    459  OE2 GLU    28       8.881  17.905  22.411  1.00 32.00           O
ATOM    460  C   GLU    28       8.153  23.236  22.054  1.00 13.50           C
ATOM    461  O   GLU    28       7.240  23.042  21.248  1.00 11.92           O
ATOM    463  N   PRO    29       9.178  24.036  21.791  1.00 11.31           N
ATOM    464  CA  PRO    29       9.234  24.766  20.542  1.00  9.48           C
ATOM    466  CB  PRO    29      10.283  25.836  20.815  1.00 13.51           C
ATOM    469  CG  PRO    29      11.215  25.168  21.786  1.00 13.32           C
ATOM    472  CD  PRO    29      10.337  24.320  22.656  1.00 13.95           C
ATOM    475  C   PRO    29       9.672  23.871  19.401  1.00 10.21           C
ATOM    476  O   PRO    29      10.263  22.802  19.630  1.00 10.48           O
ATOM    477  N   GLY    30       9.388  24.307  18.178  1.00  8.28           N
ATOM    478  CA  GLY    30       9.868  23.605  17.007  1.00  8.52           C
ATOM    481  C   GLY    30       8.771  23.103  16.084  1.00  7.13           C
ATOM    482  O   GLY    30       7.579  23.153  16.414  1.00  7.59           O
ATOM    484  N   VAL    31       9.206  22.606  14.930  1.00  6.41           N
ATOM    485  CA  VAL    31       8.341  21.984  13.950  1.00  6.55           C
ATOM    487  CB  VAL    31       8.562  22.633  12.560  1.00  9.09           C
ATOM    489  CG1 VAL    31       7.696  21.998  11.538  1.00 11.32           C
ATOM    493  CG2 VAL    31       8.330  24.131  12.631  1.00 12.01           C
ATOM    497  C   VAL    31       8.734  20.517  13.912  1.00  5.36           C
ATOM    498  O   VAL    31       9.921  20.186  13.789  1.00  6.15           O
ATOM    500  N   PHE    32       7.745  19.636  14.012  1.00  5.13           N
ATOM    501  CA  PHE    32       7.985  18.206  14.179  1.00  6.39           C
ATOM    503  CB  PHE    32       7.554  17.743  15.584  1.00  6.64           C
ATOM    506  CG  PHE    32       8.328  18.414  16.676  1.00  6.56           C
ATOM    507  CD1 PHE    32       9.453  17.844  17.194  1.00  6.87           C
ATOM    509  CE1 PHE    32      10.178  18.486  18.181  1.00  8.33           C
ATOM    511  CZ  PHE    32       9.765  19.681  18.653  1.00  8.49           C
ATOM    513  CE2 PHE    32       8.641  20.269  18.156  1.00  8.36           C
ATOM    515  CD2 PHE    32       7.922  19.638  17.169  1.00  6.58           C
ATOM    517  C   PHE    32       7.260  17.401  13.145  1.00  6.13           C
ATOM    518  O   PHE    32       6.154  17.747  12.715  1.00  8.29           O
ATOM    520  N   ILE    33       7.866  16.282  12.766  1.00  5.72           N
ATOM    521  CA  ILE    33       7.185  15.310  11.921  1.00  5.98           C
ATOM    523  CB  ILE    33       8.192  14.401  11.195  1.00  6.56           C
ATOM    525  CG1 ILE    33       9.084  15.265  10.320  1.00  7.81           C
ATOM    528  CD1 ILE    33      10.065  14.515   9.462  1.00  9.96           C
ATOM    532  CG2 ILE    33       7.493  13.339  10.346  1.00  8.37           C
ATOM    536  C   ILE    33       6.274  14.467  12.801  1.00  7.53           C
ATOM    537  O   ILE    33       6.726  13.828  13.751  1.00  8.02           O
ATOM    539  N   LEU    34       4.981  14.441  12.481  1.00  6.69           N
ATOM    540  CA  LEU    34       4.062  13.561  13.167  1.00  9.23           C
ATOM    542  CB  LEU    34       2.651  14.122  13.100  1.00  9.63           C
ATOM    545  CG  LEU    34       1.589  13.339  13.869  1.00 10.85           C
ATOM    547  CD1 LEU    34       1.808  13.508  15.371  1.00 13.84           C
ATOM    551  CD2 LEU    34       0.192  13.819  13.461  1.00 17.22           C
ATOM    555  C   LEU    34       4.149  12.162  12.550  1.00  8.28           C
ATOM    556  O   LEU    34       4.259  11.163  13.265  1.00  9.20           O
ATOM    558  N   ASP    35       4.066  12.102  11.222  1.00  8.00           N
ATOM    559  CA  ASP    35       4.172  10.849  10.482  1.00  8.97           C
ATOM    561  CB  ASP    35       2.937   9.975  10.701  1.00 15.92           C
ATOM    564  CG  ASP    35       1.688  10.662  10.296  1.00 18.18           C
ATOM    565  OD1 ASP    35       1.592  10.998   9.115  1.00 27.37           O
ATOM    566  OD2 ASP    35       0.793  10.869  11.145  1.00 37.45           O
ATOM    567  C   ASP    35       4.374  11.200   9.011  1.00  7.38           C
ATOM    568  O   ASP    35       4.342  12.361   8.636  1.00  7.85           O
ATOM    570  N   LEU    36       4.617  10.172   8.213  1.00  9.96           N
ATOM    571  CA  LEU    36       4.789  10.277   6.792  1.00  9.02           C
ATOM    573  CB  LEU    36       6.040   9.523   6.346  1.00  9.54           C
ATOM    576  CG  LEU    36       7.348   9.882   7.039  1.00 11.95           C
ATOM    578  CD1 LEU    36       8.469   9.086   6.358  1.00 12.55           C
ATOM    582  CD2 LEU    36       7.634  11.373   6.998  1.00 10.74           C
ATOM    586  C   LEU    36       3.575   9.694   6.086  1.00 10.85           C
ATOM    587  O   LEU    36       2.923   8.753   6.590  1.00 16.71           O
ATOM    589  N   LEU    37       3.267  10.244   4.924  1.00 10.18           N
ATOM    590  CA  LEU    37       2.173   9.751   4.101  1.00  9.91           C
ATOM    592  CB  LEU    37       1.680  10.825   3.129  1.00 11.13           C
ATOM    595  CG  LEU    37       1.134  12.139   3.683  0.50 15.44           C
ATOM    599  CD1 LEU    37       0.485  12.974   2.576  0.50 17.87           C
ATOM    607  CD2 LEU    37       0.158  11.845   4.773  0.50 17.28           C
ATOM    615  C   LEU    37       2.603   8.536   3.287  1.00  9.77           C
ATOM    616  O   LEU    37       3.694   8.497   2.729  1.00  9.19           O
ATOM    618  N   GLU    38       1.707   7.561   3.187  1.00 12.24           N
ATOM    619  CA  GLU    38       1.930   6.353   2.392  1.00 14.34           C
ATOM    621  CB  GLU    38       0.618   5.543   2.312  1.00 18.79           C
ATOM    624  CG  GLU    38       0.785   4.168   1.682  1.00 22.16           C
ATOM    627  CD  GLU    38      -0.488   3.358   1.710  1.00 31.25           C
ATOM    628  OE1 GLU    38      -1.564   3.948   1.927  1.00 23.39           O
ATOM    629  OE2 GLU    38      -0.412   2.128   1.508  1.00 44.28           O
ATOM    630  C   GLU    38       2.369   6.686   0.979  1.00 13.82           C
ATOM    631  O   GLU    38       1.738   7.485   0.314  1.00 14.65           O
ATOM    633  N   GLY    39       3.467   6.086   0.533  1.00 11.43           N
ATOM    634  CA  GLY    39       3.898   6.213  -0.864  1.00 14.98           C
ATOM    637  C   GLY    39       4.490   7.564  -1.252  1.00 12.08           C
ATOM    638  O   GLY    39       4.870   7.772  -2.408  1.00 13.34           O
ATOM    640  N   GLY    40       4.612   8.482  -0.299  1.00  9.86           N
ATOM    641  CA  GLY    40       5.146   9.787  -0.608  1.00  9.55           C
ATOM    644  C   GLY    40       6.653   9.766  -0.727  1.00  7.46           C
ATOM    645  O   GLY    40       7.303   8.764  -0.407  1.00  7.40           O
ATOM    647  N   LEU    41       7.222  10.891  -1.146  1.00  7.62           N
ATOM    648  CA  LEU    41       8.672  10.979  -1.316  1.00  8.00           C
ATOM    650  CB  LEU    41       9.091  12.399  -1.714  1.00 10.73           C
ATOM    653  CG  LEU    41       8.977  12.843  -3.153  1.00 14.71           C
ATOM    655  CD1 LEU    41       9.439  14.280  -3.194  1.00 13.54           C
ATOM    659  CD2 LEU    41       9.823  11.953  -4.047  1.00 13.69           C
ATOM    663  C   LEU    41       9.398  10.637  -0.047  1.00  6.30           C
ATOM    664  O   LEU    41      10.426   9.958  -0.078  1.00  6.05           O
ATOM    666  N   ALA    42       8.923  11.169   1.076  1.00  6.10           N
ATOM    667  CA  ALA    42       9.617  10.951   2.343  1.00  5.50           C
ATOM    669  CB  ALA    42       9.039  11.836   3.429  1.00  6.62           C
ATOM    673  C   ALA    42       9.603   9.484   2.750  1.00  6.00           C
ATOM    674  O   ALA    42      10.614   8.938   3.177  1.00  5.85           O
ATOM    676  N   ALA    43       8.451   8.841   2.592  1.00  5.17           N
ATOM    677  CA  ALA    43       8.324   7.429   2.900  1.00  5.95           C
ATOM    679  CB  ALA    43       6.877   6.965   2.811  1.00  8.50           C
ATOM    683  C   ALA    43       9.207   6.590   1.979  1.00  6.68           C
ATOM    684  O   ALA    43       9.846   5.647   2.421  1.00  7.67           O
ATOM    686  N   GLN    44       9.239   6.927   0.693  1.00  6.75           N
ATOM    687  CA  GLN    44      10.080   6.208  -0.242  1.00  5.96           C
ATOM    689  CB  GLN    44       9.884   6.725  -1.657  1.00  6.18           C
ATOM    692  CG  GLN    44       8.528   6.335  -2.259  1.00  8.92           C
ATOM    695  CD  GLN    44       8.364   6.902  -3.633  1.00 11.62           C
ATOM    696  OE1 GLN    44       9.187   6.663  -4.520  1.00 14.68           O
ATOM    697  NE2 GLN    44       7.314   7.675  -3.818  1.00 14.96           N
ATOM    700  C   GLN    44      11.545   6.330   0.121  1.00  5.84           C
ATOM    701  O   GLN    44      12.322   5.375  -0.015  1.00  6.68           O
ATOM    703  N   ASP    45      11.944   7.519   0.550  1.00  5.19           N
ATOM    704  CA  ASP    45      13.315   7.747   0.941  1.00  5.40           C
ATOM    706  CB  ASP    45      13.577   9.248   1.150  1.00  5.38           C
ATOM    709  CG  ASP    45      14.928   9.517   1.707  1.00  7.25           C
ATOM    710  OD1 ASP    45      15.893   9.620   0.899  1.00  7.92           O
ATOM    711  OD2 ASP    45      15.039   9.605   2.962  1.00  7.45           O
ATOM    712  C   ASP    45      13.687   6.947   2.180  1.00  6.21           C
ATOM    713  O   ASP    45      14.794   6.435   2.255  1.00  7.92           O
ATOM    715  N   GLY    46      12.777   6.884   3.146  1.00  6.05           N
ATOM    716  CA  GLY    46      12.890   6.010   4.303  1.00  8.24           C
ATOM    719  C   GLY    46      13.464   6.635   5.554  1.00  8.42           C
ATOM    720  O   GLY    46      13.208   6.144   6.652  1.00 12.24           O
ATOM    722  N   ARG    47      14.251   7.704   5.407  1.00  6.54           N
ATOM    723  CA  ARG    47      15.018   8.218   6.545  1.00  8.04           C
ATOM    725  CB  ARG    47      16.169   9.085   6.066  1.00  7.42           C
ATOM    728  CG  ARG    47      17.222   8.284   5.355  1.00  9.19           C
ATOM    731  CD  ARG    47      18.320   9.143   4.763  1.00  9.89           C
ATOM    734  NE  ARG    47      17.874   9.848   3.578  1.00  8.34           N
ATOM    736  CZ  ARG    47      18.629  10.670   2.865  1.00  7.37           C
ATOM    737  NH1 ARG    47      19.872  10.932   3.235  1.00 10.70           N
ATOM    740  NH2 ARG    47      18.144  11.253   1.797  1.00  8.55           N
ATOM    743  C   ARG    47      14.197   8.973   7.569  1.00  8.63           C
ATOM    744  O   ARG    47      14.369   8.776   8.766  1.00 13.68           O
ATOM    746  N   LEU    48      13.341   9.866   7.116  1.00  7.63           N
ATOM    747  CA  LEU    48      12.584  10.684   8.035  1.00  7.29           C
ATOM    749  CB  LEU    48      11.816  11.766   7.291  1.00  7.30           C
ATOM    752  CG  LEU    48      12.687  12.823   6.589  1.00  8.01           C
ATOM    754  CD1 LEU    48      11.836  13.663   5.678  1.00 10.86           C
ATOM    758  CD2 LEU    48      13.434  13.710   7.580  1.00  9.67           C
ATOM    762  C   LEU    48      11.646   9.839   8.871  1.00  9.21           C
ATOM    763  O   LEU    48      11.231   8.751   8.454  1.00 11.25           O
ATOM    765  N   SER    49      11.325  10.343  10.062  1.00  7.94           N
ATOM    766  CA  SER    49      10.576   9.586  11.039  1.00  8.89           C
ATOM    768  CB  SER    49      11.569   8.839  11.926  1.00 10.93           C
ATOM    771  OG  SER    49      10.887   7.933  12.776  1.00 14.79           O
ATOM    773  C   SER    49       9.708  10.456  11.922  1.00  7.68           C
ATOM    774  O   SER    49      10.045  11.579  12.207  1.00  7.74           O
ATOM    776  N   SER    50       8.643   9.859  12.435  1.00  7.02           N
ATOM    777  CA  SER    50       7.847  10.451  13.491  1.00  7.93           C
ATOM    779  CB  SER    50       6.847   9.400  13.997  0.50  7.51           C
ATOM    785  OG  SER    50       5.958   9.906  14.963  0.50  6.38           O
ATOM    789  C   SER    50       8.764  10.917  14.610  1.00  6.25           C
ATOM    790  O   SER    50       9.705  10.210  14.994  1.00  8.15           O
ATOM    792  N   ASN    51       8.476  12.127  15.105  1.00  5.84           N
ATOM    793  CA  ASN    51       9.180  12.780  16.210  1.00  6.94           C
ATOM    795  CB  ASN    51       9.345  11.845  17.409  1.00  8.16           C
ATOM    798  CG  ASN    51       8.018  11.464  17.982  1.00  9.85           C
ATOM    799  OD1 ASN    51       7.313  12.311  18.530  1.00 12.30           O
ATOM    800  ND2 ASN    51       7.642  10.213  17.832  1.00  9.84           N
ATOM    803  C   ASN    51      10.454  13.506  15.833  1.00  6.49           C
ATOM    804  O   ASN    51      11.045  14.165  16.682  1.00  8.19           O
ATOM    806  N   ASP    52      10.845  13.450  14.563  1.00  6.15           N
ATOM    807  CA  ASP    52      11.970  14.223  14.106  1.00  5.99           C
ATOM    809  CB  ASP    52      12.290  13.888  12.648  1.00  6.83           C
ATOM    812  CG  ASP    52      13.037  12.585  12.472  1.00  8.10           C
ATOM    813  OD1 ASP    52      13.484  11.982  13.468  1.00  8.15           O
ATOM    814  OD2 ASP    52      13.210  12.189  11.298  1.00  8.89           O
ATOM    815  C   ASP    52      11.601  15.697  14.206  1.00  6.29           C
ATOM    816  O   ASP    52      10.491  16.107  13.839  1.00  6.95           O
ATOM    818  N   ARG    53      12.550  16.500  14.650  1.00  5.25           N
ATOM    819  CA  ARG    53      12.408  17.938  14.683  1.00  4.99           C
ATOM    821  CB  ARG    53      13.041  18.529  15.935  1.00  6.14           C
ATOM    824  CG  ARG    53      12.863  20.012  16.008  1.00  7.50           C
ATOM    827  CD  ARG    53      13.501  20.585  17.212  1.00  8.27           C
ATOM    830  NE  ARG    53      13.318  22.031  17.331  1.00  8.88           N
ATOM    832  CZ  ARG    53      13.737  22.686  18.396  1.00 11.23           C
ATOM    833  NH1 ARG    53      14.346  22.016  19.366  1.00 16.53           N
ATOM    836  NH2 ARG    53      13.543  23.977  18.514  1.00 13.37           N
ATOM    839  C   ARG    53      13.100  18.513  13.447  1.00  4.96           C
ATOM    840  O   ARG    53      14.246  18.205  13.173  1.00  6.86           O
ATOM    842  N   VAL    54      12.379  19.326  12.678  1.00  5.73           N
ATOM    843  CA  VAL    54      12.946  19.961  11.493  1.00  6.02           C
ATOM    845  CB  VAL    54      11.865  20.242  10.411  1.00  6.77           C
ATOM    847  CG1 VAL    54      12.525  20.854   9.177  1.00  7.75           C
ATOM    851  CG2 VAL    54      11.100  18.960  10.023  1.00  9.25           C
ATOM    855  C   VAL    54      13.643  21.257  11.915  1.00  5.20           C
ATOM    856  O   VAL    54      12.992  22.215  12.306  1.00  6.89           O
ATOM    858  N   LEU    55      14.971  21.250  11.874  1.00  4.90           N
ATOM    859  CA  LEU    55      15.774  22.399  12.259  1.00  5.97           C
ATOM    861  CB  LEU    55      17.164  21.952  12.706  1.00  6.50           C
ATOM    864  CG  LEU    55      17.211  21.067  13.939  1.00  7.90           C
ATOM    866  CD1 LEU    55      18.665  20.650  14.173  1.00 10.54           C
ATOM    870  CD2 LEU    55      16.639  21.761  15.161  1.00 12.65           C
ATOM    874  C   LEU    55      15.917  23.418  11.129  1.00  5.73           C
ATOM    875  O   LEU    55      16.055  24.599  11.409  1.00  6.02           O
ATOM    877  N   ALA    56      15.899  22.967   9.877  1.00  4.96           N
ATOM    878  CA  ALA    56      16.078  23.839   8.738  1.00  5.86           C
ATOM    880  CB  ALA    56      17.559  24.243   8.565  1.00  7.39           C
ATOM    884  C   ALA    56      15.613  23.097   7.501  1.00  4.94           C
ATOM    885  O   ALA    56      15.630  21.863   7.462  1.00  5.30           O
ATOM    887  N   ILE    57      15.205  23.857   6.494  1.00  4.78           N
ATOM    888  CA  ILE    57      14.911  23.339   5.159  1.00  5.74           C
ATOM    890  CB  ILE    57      13.401  23.285   4.848  1.00  7.45           C
ATOM    892  CG1 ILE    57      12.699  22.291   5.772  1.00  8.31           C
ATOM    895  CD1 ILE    57      11.186  22.199   5.602  1.00 11.74           C
ATOM    899  CG2 ILE    57      13.155  22.833   3.436  1.00  7.99           C
ATOM    903  C   ILE    57      15.615  24.249   4.162  1.00  5.48           C
ATOM    904  O   ILE    57      15.437  25.465   4.181  1.00  5.95           O
ATOM    906  N   ASN    58      16.488  23.659   3.347  1.00  5.37           N
ATOM    907  CA  ASN    58      17.202  24.406   2.311  1.00  5.56           C
ATOM    909  CB  ASN    58      16.242  24.820   1.190  1.00  6.55           C
ATOM    912  CG  ASN    58      15.844  23.658   0.321  1.00  5.43           C
ATOM    913  OD1 ASN    58      16.462  22.598   0.393  1.00  7.68           O
ATOM    914  ND2 ASN    58      14.804  23.840  -0.499  1.00  9.08           N
ATOM    917  C   ASN    58      17.968  25.593   2.877  1.00  5.61           C
ATOM    918  O   ASN    58      18.065  26.640   2.259  1.00  6.22           O
ATOM    920  N   GLY    59      18.531  25.413   4.066  1.00  7.13           N
ATOM    921  CA  GLY    59      19.286  26.446   4.761  1.00  6.57           C
ATOM    924  C   GLY    59      18.476  27.481   5.496  1.00  6.87           C
ATOM    925  O   GLY    59      19.058  28.366   6.131  1.00 10.12           O
ATOM    927  N   HIS    60      17.151  27.403   5.379  1.00  5.84           N
ATOM    928  CA  HIS    60      16.246  28.308   6.057  1.00  6.38           C
ATOM    930  CB  HIS    60      14.923  28.422   5.291  1.00  7.41           C
ATOM    933  CG  HIS    60      15.059  28.970   3.905  1.00  9.29           C
ATOM    934  ND1 HIS    60      14.673  30.244   3.565  1.00 15.26           N
ATOM    936  CE1 HIS    60      14.916  30.455   2.284  1.00 15.78           C
ATOM    938  NE2 HIS    60      15.439  29.353   1.773  1.00 10.90           N
ATOM    940  CD2 HIS    60      15.508  28.403   2.762  1.00 11.08           C
ATOM    942  C   HIS    60      15.969  27.768   7.456  1.00  6.08           C
ATOM    943  O   HIS    60      15.431  26.677   7.615  1.00  7.61           O
ATOM    945  N   ASP    61      16.284  28.556   8.478  1.00  7.12           N
ATOM    946  CA  ASP    61      16.130  28.131   9.868  1.00  7.26           C
ATOM    948  CB  ASP    61      16.723  29.213  10.787  1.00  9.51           C
ATOM    951  CG  ASP    61      16.625  28.881  12.261  1.00 11.69           C
ATOM    952  OD1 ASP    61      16.644  27.691  12.621  1.00 11.87           O
ATOM    953  OD2 ASP    61      16.534  29.843  13.051  1.00 19.75           O
ATOM    954  C   ASP    61      14.659  27.919  10.218  1.00  7.26           C
ATOM    955  O   ASP    61      13.821  28.778   9.948  1.00  9.44           O
ATOM    957  N   LEU    62      14.365  26.784  10.844  1.00  6.81           N
ATOM    958  CA  LEU    62      13.042  26.461  11.358  1.00  7.03           C
ATOM    960  CB  LEU    62      12.435  25.351  10.511  1.00  8.04           C
ATOM    963  CG  LEU    62      11.842  25.803   9.173  1.00  9.58           C
ATOM    965  CD1 LEU    62      11.547  24.580   8.318  1.00 14.23           C
ATOM    969  CD2 LEU    62      10.558  26.562   9.377  1.00 11.51           C
ATOM    973  C   LEU    62      13.065  26.067  12.836  1.00  6.56           C
ATOM    974  O   LEU    62      12.072  25.571  13.367  1.00  7.03           O
ATOM    976  N   LYS    63      14.176  26.298  13.525  1.00  6.57           N
ATOM    977  CA  LYS    63      14.275  25.871  14.918  1.00  7.54           C
ATOM    979  CB  LYS    63      15.603  26.320  15.527  1.00  9.50           C
ATOM    982  CG  LYS    63      15.877  25.737  16.905  1.00 14.00           C
ATOM    985  CD  LYS    63      17.286  25.997  17.394  1.00 18.24           C
ATOM    988  CE  LYS    63      17.444  25.472  18.815  1.00 23.48           C
ATOM    992  C   LYS    63      13.103  26.393  15.750  1.00  6.86           C
ATOM    993  O   LYS    63      12.524  25.652  16.546  1.00  7.88           O
ATOM    995  N   TYR    64      12.751  27.663  15.566  1.00  7.48           N
ATOM    996  CA  TYR    64      11.624  28.256  16.273  1.00  8.17           C
ATOM    998  CB  TYR    64      12.093  29.470  17.089  1.00 11.09           C
ATOM   1001  CG  TYR    64      13.152  29.097  18.092  1.00 11.97           C
ATOM   1002  CD1 TYR    64      12.812  28.444  19.262  1.00 14.21           C
ATOM   1004  CE1 TYR    64      13.775  28.061  20.178  1.00 17.55           C
ATOM   1006  CZ  TYR    64      15.099  28.298  19.905  1.00 20.25           C
ATOM   1007  OH  TYR    64      16.053  27.918  20.816  1.00 26.55           O
ATOM   1009  CE2 TYR    64      15.471  28.924  18.736  1.00 20.96           C
ATOM   1011  CD2 TYR    64      14.501  29.305  17.825  1.00 15.02           C
ATOM   1013  C   TYR    64      10.497  28.626  15.316  1.00  8.44           C
ATOM   1014  O   TYR    64       9.719  29.543  15.565  1.00 11.33           O
ATOM   1016  N   GLY    65      10.391  27.868  14.226  1.00  7.80           N
ATOM   1017  CA  GLY    65       9.456  28.141  13.163  1.00  8.27           C
ATOM   1020  C   GLY    65       8.106  27.507  13.394  1.00  7.91           C
ATOM   1021  O   GLY    65       7.804  27.015  14.472  1.00  7.59           O
ATOM   1023  N   THR    66       7.300  27.515  12.346  1.00  9.49           N
ATOM   1024  CA  THR    66       5.936  27.018  12.364  1.00  9.40           C
ATOM   1026  CB  THR    66       4.949  28.188  12.187  1.00  9.92           C
ATOM   1028  OG1 THR    66       5.184  28.803  10.915  1.00 12.44           O
ATOM   1030  CG2 THR    66       5.102  29.213  13.287  1.00 13.80           C
ATOM   1034  C   THR    66       5.689  26.091  11.183  1.00  9.04           C
ATOM   1035  O   THR    66       6.401  26.156  10.182  1.00  8.82           O
ATOM   1037  N   PRO    67       4.658  25.244  11.275  1.00  9.53           N
ATOM   1038  CA  PRO    67       4.247  24.481  10.100  1.00  8.74           C
ATOM   1040  CB  PRO    67       2.977  23.778  10.578  1.00 10.07           C
ATOM   1043  CG  PRO    67       3.200  23.593  12.032  1.00 11.46           C
ATOM   1046  CD  PRO    67       3.906  24.839  12.476  1.00 11.37           C
ATOM   1049  C   PRO    67       3.988  25.364   8.877  1.00  9.67           C
ATOM   1050  O   PRO    67       4.337  24.995   7.759  1.00 10.04           O
ATOM   1051  N   GLU    68       3.394  26.533   9.096  1.00  9.78           N
ATOM   1052  CA  GLU    68       3.116  27.444   8.001  1.00 11.62           C
ATOM   1054  CB  GLU    68       2.371  28.680   8.504  1.00 15.78           C
ATOM   1057  CG  GLU    68       0.939  28.454   8.841  1.00 22.69           C
ATOM   1060  CD  GLU    68       0.730  27.530  10.025  1.00 38.18           C
ATOM   1061  OE1 GLU    68       1.509  27.567  11.019  1.00 30.10           O
ATOM   1062  OE2 GLU    68      -0.241  26.753   9.956  1.00 46.84           O
ATOM   1063  C   GLU    68       4.362  27.913   7.288  1.00 10.80           C
ATOM   1064  O   GLU    68       4.391  27.980   6.050  1.00 13.59           O
ATOM   1066  N   LEU    69       5.377  28.283   8.060  1.00 10.10           N
ATOM   1067  CA  LEU    69       6.635  28.728   7.469  1.00 10.16           C
ATOM   1069  CB  LEU    69       7.557  29.283   8.549  1.00 13.39           C
ATOM   1072  CG  LEU    69       8.913  29.806   8.085  1.00 13.91           C
ATOM   1074  CD1 LEU    69       8.763  30.875   7.002  1.00 16.82           C
ATOM   1078  CD2 LEU    69       9.710  30.307   9.286  1.00 16.06           C
ATOM   1082  C   LEU    69       7.287  27.576   6.700  1.00  9.38           C
ATOM   1083  O   LEU    69       7.778  27.764   5.595  1.00 10.31           O
ATOM   1085  N   ALA    70       7.282  26.382   7.275  1.00  9.22           N
ATOM   1086  CA  ALA    70       7.801  25.207   6.554  1.00  8.31           C
ATOM   1088  CB  ALA    70       7.687  23.984   7.411  1.00  9.24           C
ATOM   1092  C   ALA    70       7.056  24.999   5.230  1.00  8.63           C
ATOM   1093  O   ALA    70       7.679  24.743   4.207  1.00  9.95           O
ATOM   1095  N   ALA    71       5.729  25.125   5.262  1.00  9.56           N
ATOM   1096  CA  ALA    71       4.901  24.975   4.076  1.00 10.82           C
ATOM   1098  CB  ALA    71       3.435  25.119   4.431  1.00 12.69           C
ATOM   1102  C   ALA    71       5.282  25.984   3.003  1.00 10.30           C
ATOM   1103  O   ALA    71       5.370  25.639   1.841  1.00 11.75           O
ATOM   1105  N   GLN    72       5.506  27.233   3.406  1.00 11.39           N
ATOM   1106  CA  GLN    72       5.878  28.302   2.476  1.00 12.45           C
ATOM   1108  CB  GLN    72       5.975  29.639   3.207  1.00 15.12           C
ATOM   1111  CG  GLN    72       4.633  30.242   3.569  1.00 26.64           C
ATOM   1114  CD  GLN    72       4.759  31.571   4.300  1.00 41.76           C
ATOM   1115  OE1 GLN    72       5.777  31.860   4.936  1.00 44.64           O
ATOM   1116  NE2 GLN    72       3.713  32.385   4.216  1.00 48.57           N
ATOM   1119  C   GLN    72       7.207  27.962   1.806  1.00 12.12           C
ATOM   1120  O   GLN    72       7.353  28.082   0.581  1.00 12.87           O
ATOM   1122  N   ILE    73       8.179  27.518   2.597  1.00 10.78           N
ATOM   1123  CA  ILE    73       9.494  27.153   2.059  1.00 11.01           C
ATOM   1125  CB  ILE    73      10.495  26.822   3.185  1.00 10.04           C
ATOM   1127  CG1 ILE    73      10.756  28.065   4.042  1.00 12.22           C
ATOM   1130  CD1 ILE    73      11.281  27.733   5.431  1.00 13.45           C
ATOM   1134  CG2 ILE    73      11.806  26.269   2.626  1.00 11.05           C
ATOM   1138  C   ILE    73       9.399  25.976   1.090  1.00  9.44           C
ATOM   1139  O   ILE    73       9.934  26.028  -0.020  1.00 11.21           O
ATOM   1141  N   ILE    74       8.672  24.931   1.481  1.00  9.74           N
ATOM   1142  CA  ILE    74       8.569  23.728   0.661  1.00  9.95           C
ATOM   1144  CB  ILE    74       7.907  22.592   1.429  1.00 10.93           C
ATOM   1146  CG1 ILE    74       8.843  22.115   2.522  1.00 10.18           C
ATOM   1149  CD1 ILE    74       8.119  21.328   3.647  1.00 13.36           C
ATOM   1153  CG2 ILE    74       7.582  21.426   0.509  1.00 12.72           C
ATOM   1157  C   ILE    74       7.825  24.010  -0.644  1.00 11.91           C
ATOM   1158  O   ILE    74       8.246  23.557  -1.726  1.00 13.89           O
ATOM   1160  N   GLN    75       6.741  24.780  -0.564  1.00 12.93           N
ATOM   1161  CA  GLN    75       5.961  25.074  -1.768  1.00 13.68           C
ATOM   1163  CB  GLN    75       4.657  25.750  -1.402  1.00 16.16           C
ATOM   1166  CG  GLN    75       3.669  24.773  -0.769  1.00 18.38           C
ATOM   1169  CD  GLN    75       2.441  25.471  -0.235  1.00 26.27           C
ATOM   1170  OE1 GLN    75       2.313  26.691  -0.338  1.00 34.21           O
ATOM   1171  NE2 GLN    75       1.530  24.705   0.337  1.00 29.94           N
ATOM   1174  C   GLN    75       6.746  25.917  -2.773  1.00 13.60           C
ATOM   1175  O   GLN    75       6.574  25.734  -3.965  1.00 17.87           O
ATOM   1177  N   ALA    76       7.609  26.812  -2.296  1.00 10.43           N
ATOM   1178  CA  ALA    76       8.437  27.639  -3.166  1.00 11.32           C
ATOM   1180  CB  ALA    76       8.707  28.987  -2.509  1.00 13.58           C
ATOM   1184  C   ALA    76       9.748  26.982  -3.584  1.00 11.10           C
ATOM   1185  O   ALA    76      10.468  27.561  -4.377  1.00 13.90           O
ATOM   1187  N   SER    77      10.065  25.793  -3.059  1.00  9.06           N
ATOM   1188  CA  SER    77      11.372  25.165  -3.256  1.00  9.49           C
ATOM   1190  CB  SER    77      11.469  23.906  -2.429  0.50  9.76           C
ATOM   1196  OG  SER    77      10.601  22.959  -2.991  0.50 13.23           O
ATOM   1200  C   SER    77      11.592  24.786  -4.692  1.00 10.15           C
ATOM   1201  O   SER    77      10.639  24.562  -5.437  1.00 14.75           O
ATOM   1203  N   GLY    78      12.861  24.707  -5.079  1.00  7.78           N
ATOM   1204  CA  GLY    78      13.221  24.044  -6.296  1.00  9.54           C
ATOM   1207  C   GLY    78      13.129  22.543  -6.113  1.00  8.94           C
ATOM   1208  O   GLY    78      12.615  22.045  -5.120  1.00 10.77           O
ATOM   1210  N   GLU    79      13.674  21.791  -7.049  1.00  9.79           N
ATOM   1211  CA  GLU    79      13.501  20.344  -7.016  1.00  9.89           C
ATOM   1213  CB  GLU    79      13.953  19.685  -8.320  1.00 16.21           C
ATOM   1216  CG  GLU    79      15.398  19.861  -8.639  1.00 16.42           C
ATOM   1219  CD  GLU    79      16.323  18.856  -7.970  1.00 22.12           C
ATOM   1220  OE1 GLU    79      15.852  17.773  -7.589  1.00 22.98           O
ATOM   1221  OE2 GLU    79      17.531  19.158  -7.834  1.00 30.49           O
ATOM   1222  C   GLU    79      14.129  19.674  -5.794  1.00  9.48           C
ATOM   1223  O   GLU    79      13.577  18.718  -5.290  1.00 11.29           O
ATOM   1225  N   ARG    80      15.251  20.178  -5.304  1.00  8.87           N
ATOM   1226  CA  ARG    80      15.911  19.591  -4.148  1.00  8.68           C
ATOM   1228  CB  ARG    80      17.430  19.716  -4.256  1.00 11.07           C
ATOM   1231  CG  ARG    80      18.176  19.033  -3.108  1.00 13.32           C
ATOM   1234  CD  ARG    80      19.682  19.112  -3.324  1.00 24.79           C
ATOM   1237  NE  ARG    80      20.448  18.479  -2.245  1.00 27.84           N
ATOM   1239  CZ  ARG    80      20.993  19.118  -1.207  1.00 36.19           C
ATOM   1240  NH1 ARG    80      20.863  20.433  -1.054  1.00 33.72           N
ATOM   1243  NH2 ARG    80      21.671  18.426  -0.295  1.00 41.41           N
ATOM   1246  C   ARG    80      15.411  20.246  -2.878  1.00  8.11           C
ATOM   1247  O   ARG    80      15.445  21.473  -2.722  1.00  9.37           O
ATOM   1249  N   VAL    81      14.959  19.401  -1.963  1.00  6.86           N
ATOM   1250  CA  VAL    81      14.513  19.835  -0.643  1.00  6.31           C
ATOM   1252  CB  VAL    81      13.028  19.562  -0.396  1.00  7.85           C
ATOM   1254  CG1 VAL    81      12.610  20.149   0.932  1.00  9.26           C
ATOM   1258  CG2 VAL    81      12.177  20.137  -1.532  1.00 10.85           C
ATOM   1262  C   VAL    81      15.382  19.116   0.383  1.00  6.33           C
ATOM   1263  O   VAL    81      15.236  17.909   0.611  1.00  8.05           O
ATOM   1265  N   ASN    82      16.280  19.870   0.997  1.00  5.57           N
ATOM   1266  CA  ASN    82      17.158  19.331   2.032  1.00  5.84           C
ATOM   1268  CB  ASN    82      18.579  19.900   1.896  1.00  8.13           C
ATOM   1271  CG  ASN    82      19.516  19.209   2.822  1.00 12.01           C
ATOM   1272  OD1 ASN    82      19.750  18.001   2.675  1.00 16.43           O
ATOM   1273  ND2 ASN    82      19.968  19.910   3.861  1.00 16.19           N
ATOM   1276  C   ASN    82      16.603  19.693   3.400  1.00  5.43           C
ATOM   1277  O   ASN    82      16.397  20.860   3.676  1.00  9.69           O
ATOM   1279  N   LEU    83      16.354  18.700   4.242  1.00  5.52           N
ATOM   1280  CA  LEU    83      15.875  18.917   5.599  1.00  5.39           C
ATOM   1282  CB  LEU    83      14.653  18.038   5.889  1.00  6.63           C
ATOM   1285  CG  LEU    83      13.448  18.253   4.967  1.00  7.62           C
ATOM   1287  CD1 LEU    83      13.437  17.282   3.780  1.00 10.23           C
ATOM   1291  CD2 LEU    83      12.167  18.112   5.799  1.00 11.84           C
ATOM   1295  C   LEU    83      16.980  18.565   6.561  1.00  5.82           C
ATOM   1296  O   LEU    83      17.545  17.489   6.480  1.00  8.00           O
ATOM   1298  N   THR    84      17.279  19.480   7.477  1.00  5.80           N
ATOM   1299  CA  THR    84      18.161  19.195   8.594  1.00  5.83           C
ATOM   1301  CB  THR    84      19.072  20.384   8.934  1.00  7.22           C
ATOM   1303  OG1 THR    84      19.806  20.767   7.757  1.00 11.03           O
ATOM   1305  CG2 THR    84      20.050  20.060  10.048  1.00  9.42           C
ATOM   1309  C   THR    84      17.285  18.858   9.778  1.00  5.81           C
ATOM   1310  O   THR    84      16.420  19.644  10.181  1.00  6.34           O
ATOM   1312  N   ILE    85      17.508  17.664  10.320  1.00  4.76           N
ATOM   1313  CA  ILE    85      16.683  17.063  11.339  1.00  6.86           C
ATOM   1315  CB  ILE    85      16.266  15.653  10.761  1.00 14.19           C
ATOM   1317  CG1 ILE    85      15.517  15.810   9.448  1.00 13.77           C
ATOM   1320  CD1 ILE    85      14.351  16.566   9.612  1.00 10.45           C
ATOM   1324  CG2 ILE    85      15.551  14.836  11.763  1.00 17.42           C
ATOM   1328  C   ILE    85      17.431  16.795  12.632  1.00  6.23           C
ATOM   1329  O   ILE    85      18.594  16.410  12.577  1.00  6.95           O
ATOM   1331  N   ALA    86      16.739  16.976  13.757  1.00  6.25           N
ATOM   1332  CA  ALA    86      17.190  16.463  15.050  1.00  6.59           C
ATOM   1334  CB  ALA    86      17.200  17.563  16.105  1.00  8.55           C
ATOM   1338  C   ALA    86      16.266  15.319  15.464  1.00  6.81           C
ATOM   1339  O   ALA    86      15.051  15.490  15.528  1.00  8.22           O
ATOM   1341  N   ARG    87      16.864  14.166  15.753  1.00  7.51           N
ATOM   1342  CA  ARG    87      16.141  12.966  16.135  1.00  8.14           C
ATOM   1344  CB  ARG    87      16.548  11.809  15.238  1.00  8.42           C
ATOM   1347  CG  ARG    87      15.882  10.496  15.579  1.00  9.40           C
ATOM   1350  CD  ARG    87      16.088   9.500  14.466  1.00 10.06           C
ATOM   1353  NE  ARG    87      15.444   9.990  13.256  1.00  8.90           N
ATOM   1355  CZ  ARG    87      15.734   9.569  12.031  1.00 11.27           C
ATOM   1356  NH1 ARG    87      16.620   8.604  11.820  1.00 12.83           N
ATOM   1359  NH2 ARG    87      15.145  10.122  11.007  1.00 11.16           N
ATOM   1362  C   ARG    87      16.500  12.689  17.593  1.00  7.99           C
ATOM   1363  O   ARG    87      17.564  12.158  17.886  1.00  8.23           O
ATOM   1365  N   PRO    88      15.638  13.098  18.531  1.00 10.73           N
ATOM   1366  CA  PRO    88      16.030  12.918  19.925  1.00 10.69           C
ATOM   1368  CB  PRO    88      15.102  13.869  20.685  1.00 14.27           C
ATOM   1371  CG  PRO    88      14.609  14.838  19.670  1.00 18.94           C
ATOM   1374  CD  PRO    88      14.509  14.034  18.416  1.00 14.24           C
ATOM   1377  C   PRO    88      15.854  11.499  20.425  1.00 10.66           C
ATOM   1378  O   PRO    88      15.081  10.700  19.871  1.00 14.66           O
ATOM   1379  N   GLY    89      16.590  11.193  21.476  1.00 10.65           N
ATOM   1380  CA  GLY    89      16.292  10.059  22.300  1.00 14.39           C
ATOM   1383  C   GLY    89      16.821   8.730  21.823  1.00 12.94           C
ATOM   1384  O   GLY    89      17.450   8.599  20.778  1.00 16.65           O
ATOM   1386  N   LYS    90      16.595   7.725  22.648  1.00 13.32           N
ATOM   1387  CA  LYS    90      17.063   6.385  22.376  1.00 11.77           C
ATOM   1389  CB  LYS    90      17.224   5.631  23.701  1.00 13.46           C
ATOM   1392  CG  LYS    90      18.208   6.274  24.672  1.00 15.32           C
ATOM   1395  CD  LYS    90      18.301   5.467  25.954  1.00 14.96           C
ATOM   1398  CE  LYS    90      19.261   6.115  26.964  1.00 15.66           C
ATOM   1401  NZ  LYS    90      19.404   5.284  28.187  1.00 22.41           N
ATOM   1405  C   LYS    90      16.058   5.637  21.500  1.00 10.89           C
ATOM   1406  O   LYS    90      14.853   5.785  21.671  1.00 14.13           O
ATOM   1408  N   PRO    91      16.552   4.802  20.591  1.00  9.91           N
ATOM   1409  CA  PRO    91      15.651   4.023  19.745  1.00 12.24           C
ATOM   1411  CB  PRO    91      16.556   3.534  18.608  1.00 15.51           C
ATOM   1414  CG  PRO    91      17.917   3.641  19.116  1.00 15.26           C
ATOM   1417  CD  PRO    91      17.936   4.756  20.099  1.00 12.95           C
ATOM   1420  C   PRO    91      15.025   2.841  20.462  1.00  9.07           C
ATOM   1421  O   PRO    91      14.020   2.324  20.007  1.00  9.13           O
ATOM   1422  N   GLU    92      15.643   2.418  21.560  1.00  7.37           N
ATOM   1423  CA  GLU    92      15.206   1.255  22.324  1.00  7.95           C
ATOM   1425  CB  GLU    92      16.009  -0.003  21.975  1.00 10.27           C
ATOM   1428  CG  GLU    92      15.660  -1.161  22.901  1.00 14.89           C
ATOM   1431  CD  GLU    92      16.260  -2.480  22.466  1.00 18.63           C
ATOM   1432  OE1 GLU    92      17.066  -2.497  21.502  1.00 29.25           O
ATOM   1433  OE2 GLU    92      15.921  -3.515  23.099  1.00 20.57           O
ATOM   1434  C   GLU    92      15.405   1.564  23.788  1.00  8.05           C
ATOM   1435  O   GLU    92      16.476   2.010  24.200  1.00  9.27           O
ATOM   1437  N   ILE    93      14.387   1.273  24.590  1.00  8.17           N
ATOM   1438  CA  ILE    93      14.469   1.437  26.046  1.00  8.79           C
ATOM   1440  CB  ILE    93      13.775   2.735  26.554  1.00  9.36           C
ATOM   1442  CG1 ILE    93      14.392   3.978  25.905  1.00 12.22           C
ATOM   1445  CD1 ILE    93      13.736   5.273  26.334  1.00 14.74           C
ATOM   1449  CG2 ILE    93      13.850   2.873  28.091  1.00 13.41           C
ATOM   1453  C   ILE    93      13.839   0.215  26.685  1.00  8.69           C
ATOM   1454  O   ILE    93      12.716  -0.158  26.382  1.00  8.14           O
ATOM   1456  N   GLU    94      14.587  -0.408  27.588  1.00  8.99           N
ATOM   1457  CA  GLU    94      14.057  -1.493  28.389  1.00  8.22           C
ATOM   1459  CB  GLU    94      15.122  -2.569  28.575  1.00 11.04           C
ATOM   1462  CG  GLU    94      15.738  -2.924  27.220  1.00 16.67           C
ATOM   1465  CD  GLU    94      16.767  -4.011  27.276  1.00 16.35           C
ATOM   1466  OE1 GLU    94      16.762  -4.808  28.236  1.00 19.51           O
ATOM   1467  OE2 GLU    94      17.608  -4.048  26.330  1.00 22.62           O
ATOM   1468  C   GLU    94      13.584  -0.886  29.689  1.00  8.96           C
ATOM   1469  O   GLU    94      14.327  -0.151  30.370  1.00 11.67           O
ATOM   1471  N   LEU    95      12.324  -1.163  30.007  1.00 11.21           N
ATOM   1472  CA  LEU    95      11.677  -0.524  31.139  1.00 14.71           C
ATOM   1474  CB  LEU    95      10.988   0.768  30.675  1.00 20.18           C
ATOM   1477  CG  LEU    95      10.244   0.748  29.337  1.00 20.27           C
ATOM   1479  CD1 LEU    95       9.020  -0.139  29.452  1.00 23.09           C
ATOM   1483  CD2 LEU    95       9.858   2.172  28.859  1.00 23.60           C
ATOM   1487  C   LEU    95      10.696  -1.450  31.825  1.00 17.18           C
ATOM   1488  O   LEU    95      10.717  -2.674  31.585  1.00 14.01           O
ATOM   1490  OXT LEU    95       9.915  -0.965  32.662  1.00 21.45           O
END
