
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   95 (  719),  selected   95 , name 2vrf_A
# Molecule2: number of CA atoms   95 (  723),  selected   95 , name T0488.pdb
# PARAMETERS: 2vrf_A.T0488.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    S    -1_A      S       1          2.620
LGA    M     0_A      M       2          0.988
LGA    P   112_A      E       3          1.804
LGA    V   113_A      I       4          0.442
LGA    R   114_A      L       5          0.431
LGA    R   115_A      Q       6          0.634
LGA    V   116_A      V       7          0.637
LGA    R   117_A      A       8          0.741
LGA    V   118_A      L       9          0.812
LGA    V   119_A      H      10          1.169
LGA    K   120_A      K      11          1.993
LGA    Q   121_A      R      12          3.038
LGA    E   122_A      D      13          0.573
LGA    -       -      S      14           -
LGA    A   123_A      G      15          3.703
LGA    G   124_A      E      16          1.537
LGA    G   125_A      Q      17          0.918
LGA    L   126_A      L      18          0.502
LGA    G   127_A      G      19          0.712
LGA    I   128_A      I      20          0.865
LGA    S   129_A      K      21          0.716
LGA    I   130_A      L      22          0.389
LGA    K   131_A      V      23          0.269
LGA    G   132_A      R      24          0.888
LGA    G   133_A      R      25          6.345
LGA    R   134_A      -       -           -
LGA    E   135_A      -       -           -
LGA    N   136_A      T      26          5.164
LGA    -       -      D      27           -
LGA    R   137_A      E      28          4.267
LGA    M   138_A      P      29          2.729
LGA    P   139_A      G      30          1.616
LGA    I   140_A      V      31          0.733
LGA    L   141_A      F      32          0.790
LGA    I   142_A      I      33          0.738
LGA    S   143_A      L      34          0.909
LGA    K   144_A      D      35          1.699
LGA    I   145_A      L      36          0.701
LGA    F   146_A      L      37          1.217
LGA    P   147_A      E      38          1.964
LGA    G   148_A      G      39          1.780
LGA    L   149_A      G      40          1.206
LGA    A   150_A      L      41          0.545
LGA    A   151_A      A      42          0.591
LGA    D   152_A      A      43          1.027
LGA    Q   153_A      Q      44          1.503
LGA    S   154_A      D      45          1.244
LGA    R   155_A      G      46          1.526
LGA    A   156_A      R      47          1.209
LGA    L   157_A      L      48          0.938
LGA    R   158_A      S      49          1.060
LGA    L   159_A      S      50          1.312
LGA    G   160_A      N      51          1.242
LGA    D   161_A      D      52          0.830
LGA    A   162_A      R      53          0.749
LGA    I   163_A      V      54          0.704
LGA    L   164_A      L      55          0.595
LGA    S   165_A      A      56          0.428
LGA    V   166_A      I      57          0.494
LGA    N   167_A      N      58          0.535
LGA    G   168_A      G      59          0.514
LGA    T   169_A      H      60          0.222
LGA    D   170_A      D      61          0.534
LGA    L   171_A      L      62          0.229
LGA    R   172_A      K      63          0.201
LGA    Q   173_A      Y      64          0.961
LGA    A   174_A      G      65          0.779
LGA    T   175_A      T      66          2.496
LGA    H   176_A      P      67          2.850
LGA    D   177_A      E      68          1.594
LGA    Q   178_A      L      69          1.477
LGA    A   179_A      A      70          2.146
LGA    V   180_A      A      71          2.055
LGA    Q   181_A      Q      72          1.332
LGA    A   182_A      I      73          1.869
LGA    L   183_A      I      74          2.431
LGA    K   184_A      Q      75          2.266
LGA    R   185_A      A      76          2.029
LGA    A   186_A      S      77          2.536
LGA    G   187_A      G      78          2.207
LGA    K   188_A      E      79          1.993
LGA    E   189_A      R      80          1.211
LGA    V   190_A      V      81          0.815
LGA    L   191_A      N      82          0.932
LGA    L   192_A      L      83          0.621
LGA    E   193_A      T      84          0.409
LGA    V   194_A      I      85          0.614
LGA    K   195_A      A      86          1.322
LGA    F   196_A      R      87          1.251
LGA    I   197_A      P      88          2.891
LGA    R   198_A      G      89          3.138
LGA    E   199_A      K      90           -
LGA    -       -      P      91           -
LGA    -       -      E      92           -
LGA    V   200_A      I      93           #
LGA    N   201_A      E      94           -
LGA    T   202_A      L      95           -
LGA    V   203_A      -       -           -
LGA    V   204_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   95   95    5.0     87    1.76    27.59     85.332     4.689

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.910365 * X  +   0.162313 * Y  +   0.380644 * Z  +  17.758772
  Y_new =  -0.023231 * X  +  -0.938457 * Y  +   0.344613 * Z  +  24.893726
  Z_new =   0.413153 * X  +   0.304881 * Y  +   0.858109 * Z  +   0.532729 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.341383   -2.800210  [ DEG:    19.5598   -160.4402 ]
  Theta =  -0.425914   -2.715678  [ DEG:   -24.4031   -155.5969 ]
  Phi   =  -3.116080    0.025513  [ DEG:  -178.5382      1.4618 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2vrf_A                                        
REMARK     2: T0488.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2vrf_A.T0488.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   95   95   5.0   87   1.76   27.59  85.332
REMARK  ---------------------------------------------------------- 
MOLECULE 2vrf_A
HEADER    PROTEIN-BINDING                         31-MAR-08   2VRF              
TITLE     CRYSTAL STRUCTURE OF THE HUMAN BETA-2-SYNTROPHIN PDZ DOMAIN           
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: BETA-2-SYNTROPHIN;                                         
COMPND   3 SYNONYM: 59 KDA DYSTROPHIN-ASSOCIATED PROTEIN A1 BASIC               
COMPND   4  COMPONENT 2, SYNTROPHIN-3, SNT3, SYNTROPHIN-LIKE, SNTL;             
COMPND   5 CHAIN: A, B, C, D;                                                   
COMPND   6 FRAGMENT: PDZ DOMAIN, RESIDUES 112-200;                              
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   3 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   4 EXPRESSION_SYSTEM_PLASMID: PNIC28-BSA4;                              
SOURCE   5 EXPRESSION_SYSTEM_VARIANT: R3-PRARE2;                                
SOURCE   6 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   7 ORGANISM_COMMON: HUMAN                                               
KEYWDS    ALTERNATIVE SPLICING, PROTEIN-BINDING,                                
KEYWDS   2 MICROTUBULE, POLYMORPHISM, CYTOSKELETON, ACTIN-BINDING,              
KEYWDS   3 SNT3, SNTL, SNTB2, CALCIUM, MEMBRANE, CYTOPLASM,                     
KEYWDS   4 CALMODULIN-BINDING, CYTOPLASMIC VESICLE,                             
KEYWDS   5 PHOSPHOPROTEIN, ADAPTER PROTEIN, ACTIN CYTOSKELETON                  
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Z.SUN,A.K.ROOS,A.C.W.PIKE,E.S.PILKA,C.COOPER,J.M.ELKINS,              
AUTHOR   2 J.MURRAY,C.H.ARROWSMITH,D.DOYLE,A.EDWARDS,F.VONDELFT,                
AUTHOR   3 C.BOUNTRA,U.OPPERMANN                                                
REVDAT   1   22-APR-08 2VRF    0                                                
JRNL        AUTH   Z.SUN,A.K.ROOS,A.C.W.PIKE,E.S.PILKA,C.COOPER,                
JRNL        AUTH 2 J.M.ELKINS,J.MURRAY,C.H.ARROWSMITH,D.DOYLE,                  
JRNL        AUTH 3 A.EDWARDS,F.VONDELFT,C.BOUNTRA,U.OPPERMANN                   
JRNL        TITL   CRYSTAL STRUCTURE OF THE HUMAN BETA-2-SYNTROPHIN             
JRNL        TITL 2 PDZ DOMAIN                                                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.0  ANGSTROMS.                                          
DBREF  2VRF A   -1     0  PDB    2VRF     2VRF            -1      0             
DBREF  2VRF A  112   200  UNP    Q13425   SNTB2_HUMAN    112    200             
DBREF  2VRF A  201   204  PDB    2VRF     2VRF           201    204             
DBREF  2VRF B   -1     0  PDB    2VRF     2VRF            -1      0             
DBREF  2VRF B  112   200  UNP    Q13425   SNTB2_HUMAN    112    200             
DBREF  2VRF B  201   204  PDB    2VRF     2VRF           201    204             
DBREF  2VRF C   -1     0  PDB    2VRF     2VRF            -1      0             
DBREF  2VRF C  112   200  UNP    Q13425   SNTB2_HUMAN    112    200             
DBREF  2VRF C  201   204  PDB    2VRF     2VRF           201    204             
DBREF  2VRF D   -1     0  PDB    2VRF     2VRF            -1      0             
DBREF  2VRF D  112   200  UNP    Q13425   SNTB2_HUMAN    112    200             
DBREF  2VRF D  201   204  PDB    2VRF     2VRF           201    204             
SEQRES   1 A   95  SER MET PRO VAL ARG ARG VAL ARG VAL VAL LYS GLN GLU          
SEQRES   2 A   95  ALA GLY GLY LEU GLY ILE SER ILE LYS GLY GLY ARG GLU          
SEQRES   3 A   95  ASN ARG MET PRO ILE LEU ILE SER LYS ILE PHE PRO GLY          
SEQRES   4 A   95  LEU ALA ALA ASP GLN SER ARG ALA LEU ARG LEU GLY ASP          
SEQRES   5 A   95  ALA ILE LEU SER VAL ASN GLY THR ASP LEU ARG GLN ALA          
SEQRES   6 A   95  THR HIS ASP GLN ALA VAL GLN ALA LEU LYS ARG ALA GLY          
SEQRES   7 A   95  LYS GLU VAL LEU LEU GLU VAL LYS PHE ILE ARG GLU VAL          
SEQRES   8 A   95  ASN THR VAL VAL                                              
SEQRES   1 B   95  SER MET PRO VAL ARG ARG VAL ARG VAL VAL LYS GLN GLU          
SEQRES   2 B   95  ALA GLY GLY LEU GLY ILE SER ILE LYS GLY GLY ARG GLU          
SEQRES   3 B   95  ASN ARG MET PRO ILE LEU ILE SER LYS ILE PHE PRO GLY          
SEQRES   4 B   95  LEU ALA ALA ASP GLN SER ARG ALA LEU ARG LEU GLY ASP          
SEQRES   5 B   95  ALA ILE LEU SER VAL ASN GLY THR ASP LEU ARG GLN ALA          
SEQRES   6 B   95  THR HIS ASP GLN ALA VAL GLN ALA LEU LYS ARG ALA GLY          
SEQRES   7 B   95  LYS GLU VAL LEU LEU GLU VAL LYS PHE ILE ARG GLU VAL          
SEQRES   8 B   95  ASN THR VAL VAL                                              
SEQRES   1 C   95  SER MET PRO VAL ARG ARG VAL ARG VAL VAL LYS GLN GLU          
SEQRES   2 C   95  ALA GLY GLY LEU GLY ILE SER ILE LYS GLY GLY ARG GLU          
SEQRES   3 C   95  ASN ARG MET PRO ILE LEU ILE SER LYS ILE PHE PRO GLY          
SEQRES   4 C   95  LEU ALA ALA ASP GLN SER ARG ALA LEU ARG LEU GLY ASP          
SEQRES   5 C   95  ALA ILE LEU SER VAL ASN GLY THR ASP LEU ARG GLN ALA          
SEQRES   6 C   95  THR HIS ASP GLN ALA VAL GLN ALA LEU LYS ARG ALA GLY          
SEQRES   7 C   95  LYS GLU VAL LEU LEU GLU VAL LYS PHE ILE ARG GLU VAL          
SEQRES   8 C   95  ASN THR VAL VAL                                              
SEQRES   1 D   95  SER MET PRO VAL ARG ARG VAL ARG VAL VAL LYS GLN GLU          
SEQRES   2 D   95  ALA GLY GLY LEU GLY ILE SER ILE LYS GLY GLY ARG GLU          
SEQRES   3 D   95  ASN ARG MET PRO ILE LEU ILE SER LYS ILE PHE PRO GLY          
SEQRES   4 D   95  LEU ALA ALA ASP GLN SER ARG ALA LEU ARG LEU GLY ASP          
SEQRES   5 D   95  ALA ILE LEU SER VAL ASN GLY THR ASP LEU ARG GLN ALA          
SEQRES   6 D   95  THR HIS ASP GLN ALA VAL GLN ALA LEU LYS ARG ALA GLY          
SEQRES   7 D   95  LYS GLU VAL LEU LEU GLU VAL LYS PHE ILE ARG GLU VAL          
SEQRES   8 D   95  ASN THR VAL VAL                                              
HET    EDO  C1205       4                                                       
HET    EDO  A1205       4                                                       
HET    EDO  A1206       4                                                       
HETNAM     EDO 1,2-ETHANEDIOL                                                   
FORMUL   5  EDO    3(C2 H6 O2)                                                  
FORMUL   6  HOH   *165(H2 O1)                                                   
CRYST1   56.687   29.503  128.382  90.00  95.78  90.00 P 1 21 1      8          
ATOM      1  N   SER A  -1      19.470  15.330  22.211  1.00 29.83           N  
ATOM      2  CA  SER A  -1      20.945  15.181  21.995  1.00 28.95           C  
ATOM      3  C   SER A  -1      21.232  14.063  20.994  1.00 24.65           C  
ATOM      4  O   SER A  -1      22.336  13.523  20.961  1.00 27.25           O  
ATOM      5  N   MET A   0      20.225  13.713  20.193  1.00 22.17           N  
ATOM      6  CA  MET A   0      20.393  12.750  19.131  1.00 17.85           C  
ATOM      7  C   MET A   0      21.225  13.471  18.075  1.00 13.91           C  
ATOM      8  O   MET A   0      21.171  14.707  17.995  1.00  8.85           O  
ATOM      9  CB  MET A   0      19.032  12.313  18.559  1.00 17.33           C  
ATOM     10  CG  MET A   0      18.190  11.493  19.507  1.00 25.40           C  
ATOM     11  SD  MET A   0      18.831   9.844  19.797  1.00 36.56           S  
ATOM     12  CE  MET A   0      18.295   8.976  18.317  1.00 34.77           C  
ATOM     13  N   PRO A 112      22.021  12.715  17.289  1.00 10.91           N  
ATOM     14  CA  PRO A 112      22.746  13.346  16.178  1.00  8.37           C  
ATOM     15  C   PRO A 112      21.875  13.989  15.102  1.00  8.96           C  
ATOM     16  O   PRO A 112      20.792  13.480  14.726  1.00  4.95           O  
ATOM     17  CB  PRO A 112      23.591  12.198  15.588  1.00 11.12           C  
ATOM     18  CG  PRO A 112      23.182  10.940  16.336  1.00  9.73           C  
ATOM     19  CD  PRO A 112      22.357  11.288  17.475  1.00  6.97           C  
ATOM     20  N   VAL A 113      22.352  15.081  14.539  1.00 10.37           N  
ATOM     21  CA  VAL A 113      21.675  15.613  13.334  1.00 10.00           C  
ATOM     22  C   VAL A 113      22.005  14.784  12.087  1.00  8.20           C  
ATOM     23  O   VAL A 113      23.141  14.331  11.905  1.00  9.60           O  
ATOM     24  CB  VAL A 113      22.064  17.081  13.076  1.00 15.88           C  
ATOM     25  CG1 VAL A 113      21.161  17.666  12.006  1.00 15.48           C  
ATOM     26  CG2 VAL A 113      21.922  17.897  14.359  1.00 14.62           C  
ATOM     27  N   ARG A 114      21.006  14.629  11.221  1.00  6.75           N  
ATOM     28  CA  ARG A 114      21.099  13.965   9.940  1.00  8.04           C  
ATOM     29  C   ARG A 114      20.664  14.953   8.836  1.00  6.02           C  
ATOM     30  O   ARG A 114      19.688  15.698   8.993  1.00  5.19           O  
ATOM     31  CB  ARG A 114      20.170  12.768   9.945  1.00  8.44           C  
ATOM     32  CG  ARG A 114      20.049  12.140  11.370  1.00 11.74           C  
ATOM     33  CD  ARG A 114      19.513  10.786  11.357  1.00 17.26           C  
ATOM     34  NE  ARG A 114      18.247  10.650  10.626  1.00 15.33           N  
ATOM     35  CZ  ARG A 114      17.045  10.864  11.146  1.00 19.48           C  
ATOM     36  NH1 ARG A 114      16.920  11.308  12.392  1.00 18.50           N  
ATOM     37  NH2 ARG A 114      15.955  10.624  10.402  1.00 11.58           N  
ATOM     38  N   ARG A 115      21.407  14.984   7.738  1.00  4.27           N  
ATOM     39  CA  ARG A 115      21.026  15.825   6.588  1.00  2.14           C  
ATOM     40  C   ARG A 115      20.506  14.891   5.525  1.00  7.32           C  
ATOM     41  O   ARG A 115      21.215  13.983   5.080  1.00  8.72           O  
ATOM     42  CB  ARG A 115      22.127  16.659   6.059  1.00  9.94           C  
ATOM     43  CG  ARG A 115      22.497  17.712   7.010  1.00 16.98           C  
ATOM     44  CD  ARG A 115      23.181  18.854   6.348  1.00 14.76           C  
ATOM     45  NE  ARG A 115      23.740  19.667   7.399  1.00 14.54           N  
ATOM     46  CZ  ARG A 115      24.901  19.429   7.988  1.00 19.49           C  
ATOM     47  NH1 ARG A 115      25.669  18.414   7.604  1.00 22.70           N  
ATOM     48  NH2 ARG A 115      25.316  20.240   8.942  1.00 30.93           N  
ATOM     49  N   VAL A 116      19.248  15.095   5.200  1.00  3.76           N  
ATOM     50  CA  VAL A 116      18.427  14.131   4.407  1.00  5.85           C  
ATOM     51  C   VAL A 116      17.895  14.783   3.151  1.00  8.94           C  
ATOM     52  O   VAL A 116      17.296  15.863   3.227  1.00 10.73           O  
ATOM     53  CB  VAL A 116      17.251  13.624   5.200  1.00  4.27           C  
ATOM     54  CG1 VAL A 116      16.341  12.699   4.332  1.00  4.40           C  
ATOM     55  CG2 VAL A 116      17.693  12.770   6.459  1.00  2.00           C  
ATOM     56  N   ARG A 117      18.094  14.135   2.003  1.00  5.42           N  
ATOM     57  CA  ARG A 117      17.591  14.662   0.717  1.00  6.48           C  
ATOM     58  C   ARG A 117      16.238  14.032   0.443  1.00  6.79           C  
ATOM     59  O   ARG A 117      16.077  12.833   0.553  1.00  6.63           O  
ATOM     60  CB  ARG A 117      18.555  14.321  -0.404  1.00  9.50           C  
ATOM     61  CG  ARG A 117      18.061  14.577  -1.855  1.00  8.28           C  
ATOM     62  CD  ARG A 117      18.989  13.848  -2.767  1.00 15.85           C  
ATOM     63  NE  ARG A 117      18.556  13.800  -4.148  1.00 23.14           N  
ATOM     64  CZ  ARG A 117      18.310  12.685  -4.838  1.00 27.92           C  
ATOM     65  NH1 ARG A 117      18.426  11.473  -4.307  1.00 34.09           N  
ATOM     66  NH2 ARG A 117      17.906  12.799  -6.082  1.00 22.73           N  
ATOM     67  N   VAL A 118      15.277  14.874   0.073  1.00  7.97           N  
ATOM     68  CA  VAL A 118      13.991  14.480  -0.484  1.00  5.27           C  
ATOM     69  C   VAL A 118      13.790  15.195  -1.827  1.00  6.20           C  
ATOM     70  O   VAL A 118      14.056  16.399  -1.959  1.00  4.56           O  
ATOM     71  CB  VAL A 118      12.846  14.839   0.519  1.00  8.49           C  
ATOM     72  CG1 VAL A 118      11.419  14.431  -0.034  1.00  4.03           C  
ATOM     73  CG2 VAL A 118      13.119  14.190   1.822  1.00  6.18           C  
ATOM     74  N   VAL A 119      13.353  14.445  -2.833  1.00  6.09           N  
ATOM     75  CA  VAL A 119      13.010  15.015  -4.107  1.00  9.77           C  
ATOM     76  C   VAL A 119      11.512  14.898  -4.265  1.00  9.98           C  
ATOM     77  O   VAL A 119      10.945  13.805  -4.217  1.00  6.93           O  
ATOM     78  CB  VAL A 119      13.763  14.335  -5.292  1.00  9.67           C  
ATOM     79  CG1 VAL A 119      13.400  15.010  -6.642  1.00 10.02           C  
ATOM     80  CG2 VAL A 119      15.230  14.395  -5.053  1.00 11.78           C  
ATOM     81  N   LYS A 120      10.874  16.046  -4.442  1.00 11.97           N  
ATOM     82  CA  LYS A 120       9.461  16.114  -4.700  1.00 12.81           C  
ATOM     83  C   LYS A 120       9.161  15.673  -6.134  1.00 13.42           C  
ATOM     84  O   LYS A 120       9.973  15.799  -7.065  1.00 11.29           O  
ATOM     85  CB  LYS A 120       8.948  17.551  -4.505  1.00  9.07           C  
ATOM     86  CG  LYS A 120       9.127  18.157  -3.112  1.00  8.19           C  
ATOM     87  CD  LYS A 120       8.604  19.618  -3.100  1.00  7.52           C  
ATOM     88  CE  LYS A 120       9.091  20.385  -1.863  1.00  6.31           C  
ATOM     89  NZ  LYS A 120       8.843  21.840  -1.991  1.00  8.29           N  
ATOM     90  N   GLN A 121       7.947  15.204  -6.327  1.00 15.91           N  
ATOM     91  CA  GLN A 121       7.388  15.106  -7.654  1.00 19.73           C  
ATOM     92  C   GLN A 121       7.265  16.548  -8.219  1.00 24.08           C  
ATOM     93  O   GLN A 121       7.189  17.545  -7.464  1.00 18.60           O  
ATOM     94  CB  GLN A 121       6.022  14.393  -7.548  1.00 21.62           C  
ATOM     95  CG  GLN A 121       5.628  13.464  -8.648  1.00 23.99           C  
ATOM     96  CD  GLN A 121       6.715  12.529  -9.108  1.00 17.08           C  
ATOM     97  OE1 GLN A 121       7.358  12.814 -10.099  1.00  9.43           O  
ATOM     98  NE2 GLN A 121       6.882  11.377  -8.437  1.00 13.57           N  
ATOM     99  N   GLU A 122       7.278  16.676  -9.538  1.00 25.53           N  
ATOM    100  CA  GLU A 122       7.045  17.976 -10.135  1.00 28.86           C  
ATOM    101  C   GLU A 122       5.622  18.454  -9.819  1.00 27.63           C  
ATOM    102  O   GLU A 122       5.400  19.647  -9.667  1.00 27.97           O  
ATOM    103  CB  GLU A 122       7.303  17.954 -11.638  1.00 30.99           C  
ATOM    104  CG  GLU A 122       7.267  19.337 -12.272  1.00 37.23           C  
ATOM    105  CD  GLU A 122       8.205  19.467 -13.466  1.00 52.16           C  
ATOM    106  OE1 GLU A 122       7.720  19.355 -14.617  1.00 51.86           O  
ATOM    107  OE2 GLU A 122       9.426  19.672 -13.252  1.00 56.61           O  
ATOM    108  N   ALA A 123       4.678  17.528  -9.693  1.00 26.86           N  
ATOM    109  CA  ALA A 123       3.329  17.868  -9.224  1.00 29.04           C  
ATOM    110  C   ALA A 123       3.053  17.156  -7.921  1.00 29.02           C  
ATOM    111  O   ALA A 123       2.286  16.183  -7.868  1.00 33.73           O  
ATOM    112  CB  ALA A 123       2.253  17.512 -10.273  1.00 28.26           C  
ATOM    113  N   GLY A 124       3.672  17.663  -6.862  1.00 26.39           N  
ATOM    114  CA  GLY A 124       3.500  17.096  -5.545  1.00 22.97           C  
ATOM    115  C   GLY A 124       4.371  17.776  -4.509  1.00 22.09           C  
ATOM    116  O   GLY A 124       5.055  18.766  -4.798  1.00 19.04           O  
ATOM    117  N   GLY A 125       4.328  17.231  -3.299  1.00 20.33           N  
ATOM    118  CA  GLY A 125       5.109  17.738  -2.186  1.00 17.88           C  
ATOM    119  C   GLY A 125       5.975  16.673  -1.570  1.00 13.43           C  
ATOM    120  O   GLY A 125       6.382  15.732  -2.228  1.00 15.18           O  
ATOM    121  N   LEU A 126       6.206  16.823  -0.274  1.00 13.19           N  
ATOM    122  CA  LEU A 126       7.195  16.081   0.458  1.00 16.08           C  
ATOM    123  C   LEU A 126       6.633  14.763   0.916  1.00 12.76           C  
ATOM    124  O   LEU A 126       7.372  13.847   1.172  1.00 16.87           O  
ATOM    125  CB  LEU A 126       7.708  16.895   1.657  1.00 16.80           C  
ATOM    126  CG  LEU A 126       8.688  18.046   1.383  1.00 19.68           C  
ATOM    127  CD1 LEU A 126       9.054  18.763   2.705  1.00 11.23           C  
ATOM    128  CD2 LEU A 126       9.964  17.595   0.679  1.00 13.77           C  
ATOM    129  N   GLY A 127       5.325  14.643   0.980  1.00 11.75           N  
ATOM    130  CA  GLY A 127       4.729  13.398   1.390  1.00 10.74           C  
ATOM    131  C   GLY A 127       4.865  13.147   2.871  1.00  8.32           C  
ATOM    132  O   GLY A 127       5.078  12.000   3.287  1.00  6.36           O  
ATOM    133  N   ILE A 128       4.728  14.230   3.652  1.00  6.22           N  
ATOM    134  CA  ILE A 128       4.666  14.164   5.107  1.00  8.42           C  
ATOM    135  C   ILE A 128       3.616  15.154   5.616  1.00 10.98           C  
ATOM    136  O   ILE A 128       3.221  16.073   4.897  1.00  8.28           O  
ATOM    137  CB  ILE A 128       6.002  14.554   5.788  1.00 11.86           C  
ATOM    138  CG1 ILE A 128       6.314  16.053   5.566  1.00 11.28           C  
ATOM    139  CG2 ILE A 128       7.135  13.691   5.277  1.00  7.85           C  
ATOM    140  CD1 ILE A 128       7.617  16.524   6.211  1.00 13.43           C  
ATOM    141  N   SER A 129       3.192  14.951   6.863  1.00  3.95           N  
ATOM    142  CA  SER A 129       2.551  15.985   7.654  1.00  6.30           C  
ATOM    143  C   SER A 129       3.515  16.420   8.735  1.00  7.58           C  
ATOM    144  O   SER A 129       4.400  15.638   9.112  1.00  7.21           O  
ATOM    145  CB  SER A 129       1.255  15.451   8.305  1.00  3.43           C  
ATOM    146  OG  SER A 129       0.389  15.001   7.278  1.00 27.42           O  
ATOM    147  N   ILE A 130       3.358  17.673   9.169  1.00  5.83           N  
ATOM    148  CA  ILE A 130       4.141  18.249  10.274  1.00  7.47           C  
ATOM    149  C   ILE A 130       3.171  18.824  11.303  1.00  6.09           C  
ATOM    150  O   ILE A 130       2.056  19.184  10.964  1.00  6.82           O  
ATOM    151  CB  ILE A 130       5.170  19.330   9.831  1.00 12.22           C  
ATOM    152  CG1 ILE A 130       4.506  20.511   9.119  1.00 11.83           C  
ATOM    153  CG2 ILE A 130       6.236  18.703   8.895  1.00  6.89           C  
ATOM    154  CD1 ILE A 130       5.414  21.778   9.083  1.00  4.39           C  
ATOM    155  N   LYS A 131       3.617  18.857  12.550  1.00  5.67           N  
ATOM    156  CA  LYS A 131       2.957  19.530  13.636  1.00  6.96           C  
ATOM    157  C   LYS A 131       4.012  20.363  14.363  1.00  3.83           C  
ATOM    158  O   LYS A 131       5.197  20.240  14.115  1.00 11.56           O  
ATOM    159  CB  LYS A 131       2.334  18.505  14.596  1.00  6.23           C  
ATOM    160  CG  LYS A 131       3.328  17.544  15.216  1.00 17.00           C  
ATOM    161  CD  LYS A 131       2.632  16.601  16.194  1.00 19.40           C  
ATOM    162  CE  LYS A 131       3.611  15.745  16.956  1.00 29.27           C  
ATOM    163  NZ  LYS A 131       2.869  14.904  17.973  1.00 33.26           N  
ATOM    164  N   GLY A 132       3.569  21.223  15.256  1.00  6.34           N  
ATOM    165  CA  GLY A 132       4.477  21.911  16.153  1.00 10.51           C  
ATOM    166  C   GLY A 132       4.672  23.335  15.713  1.00 10.31           C  
ATOM    167  O   GLY A 132       3.952  23.809  14.863  1.00  9.20           O  
ATOM    168  N   GLY A 133       5.651  24.024  16.289  1.00 10.76           N  
ATOM    169  CA  GLY A 133       5.840  25.410  15.938  1.00  8.88           C  
ATOM    170  C   GLY A 133       6.132  26.296  17.103  1.00  8.98           C  
ATOM    171  O   GLY A 133       5.810  25.960  18.235  1.00  4.82           O  
ATOM    172  N   ARG A 134       6.740  27.448  16.819  1.00  9.36           N  
ATOM    173  CA  ARG A 134       7.225  28.336  17.855  1.00  9.25           C  
ATOM    174  C   ARG A 134       6.094  28.922  18.653  1.00  9.83           C  
ATOM    175  O   ARG A 134       6.275  29.212  19.820  1.00 10.55           O  
ATOM    176  CB  ARG A 134       8.042  29.490  17.275  1.00 13.51           C  
ATOM    177  CG  ARG A 134       8.872  30.196  18.328  1.00 13.65           C  
ATOM    178  CD  ARG A 134       9.394  31.525  17.831  1.00 36.13           C  
ATOM    179  NE  ARG A 134       9.661  32.458  18.926  1.00 52.91           N  
ATOM    180  CZ  ARG A 134      10.586  32.291  19.878  1.00 59.95           C  
ATOM    181  NH1 ARG A 134      11.357  31.202  19.920  1.00 56.64           N  
ATOM    182  NH2 ARG A 134      10.727  33.225  20.816  1.00 63.53           N  
ATOM    183  N   GLU A 135       4.929  29.108  18.047  1.00 14.75           N  
ATOM    184  CA  GLU A 135       3.817  29.760  18.766  1.00 18.58           C  
ATOM    185  C   GLU A 135       3.452  29.006  20.043  1.00 21.44           C  
ATOM    186  O   GLU A 135       2.862  29.583  20.970  1.00 21.64           O  
ATOM    187  CB  GLU A 135       2.583  29.973  17.871  1.00 22.17           C  
ATOM    188  CG  GLU A 135       1.918  28.700  17.306  1.00 19.31           C  
ATOM    189  CD  GLU A 135       2.503  28.289  15.967  1.00 31.92           C  
ATOM    190  OE1 GLU A 135       3.717  28.239  15.894  1.00 14.34           O  
ATOM    191  OE2 GLU A 135       1.780  28.033  14.986  1.00 33.79           O  
ATOM    192  N   ASN A 136       3.807  27.724  20.094  1.00 22.20           N  
ATOM    193  CA  ASN A 136       3.610  26.899  21.278  1.00 22.72           C  
ATOM    194  C   ASN A 136       4.885  26.343  21.852  1.00 24.20           C  
ATOM    195  O   ASN A 136       4.841  25.392  22.621  1.00 23.91           O  
ATOM    196  CB  ASN A 136       2.695  25.741  20.929  1.00 23.11           C  
ATOM    197  CG  ASN A 136       1.283  26.189  20.651  1.00 31.46           C  
ATOM    198  OD1 ASN A 136       0.694  26.969  21.408  1.00 33.73           O  
ATOM    199  ND2 ASN A 136       0.712  25.673  19.574  1.00 46.62           N  
ATOM    200  N   ARG A 137       6.027  26.911  21.462  1.00 20.75           N  
ATOM    201  CA  ARG A 137       7.307  26.471  21.954  1.00 21.46           C  
ATOM    202  C   ARG A 137       7.546  24.992  21.655  1.00 20.47           C  
ATOM    203  O   ARG A 137       8.284  24.308  22.373  1.00 19.73           O  
ATOM    204  CB  ARG A 137       7.437  26.775  23.443  1.00 22.54           C  
ATOM    205  CG  ARG A 137       7.243  28.258  23.758  1.00 31.60           C  
ATOM    206  CD  ARG A 137       8.165  28.731  24.890  1.00 38.94           C  
ATOM    207  N   MET A 138       6.942  24.531  20.556  1.00 20.21           N  
ATOM    208  CA  MET A 138       7.065  23.175  20.086  1.00 20.28           C  
ATOM    209  C   MET A 138       7.969  23.165  18.858  1.00 21.11           C  
ATOM    210  O   MET A 138       7.875  24.034  17.997  1.00 17.89           O  
ATOM    211  CB  MET A 138       5.707  22.646  19.647  1.00 22.40           C  
ATOM    212  CG  MET A 138       4.660  22.534  20.754  1.00 30.27           C  
ATOM    213  SD  MET A 138       5.023  21.134  21.821  1.00 38.33           S  
ATOM    214  CE  MET A 138       5.170  19.828  20.594  1.00 36.79           C  
ATOM    215  N   PRO A 139       8.817  22.148  18.735  1.00 22.64           N  
ATOM    216  CA  PRO A 139       9.561  22.091  17.483  1.00 18.27           C  
ATOM    217  C   PRO A 139       8.672  21.621  16.342  1.00 14.48           C  
ATOM    218  O   PRO A 139       7.623  21.025  16.557  1.00 18.21           O  
ATOM    219  CB  PRO A 139      10.659  21.070  17.765  1.00 23.10           C  
ATOM    220  CG  PRO A 139      10.501  20.603  19.114  1.00 25.70           C  
ATOM    221  CD  PRO A 139       9.142  21.020  19.614  1.00 27.48           C  
ATOM    222  N   ILE A 140       9.100  21.867  15.129  1.00 15.10           N  
ATOM    223  CA  ILE A 140       8.486  21.266  13.977  1.00 13.64           C  
ATOM    224  C   ILE A 140       8.835  19.778  13.884  1.00 17.23           C  
ATOM    225  O   ILE A 140      10.011  19.439  13.777  1.00 19.01           O  
ATOM    226  CB  ILE A 140       8.963  21.941  12.694  1.00 15.15           C  
ATOM    227  CG1 ILE A 140       8.737  23.452  12.730  1.00 20.07           C  
ATOM    228  CG2 ILE A 140       8.237  21.316  11.550  1.00 16.42           C  
ATOM    229  CD1 ILE A 140       7.283  23.890  12.854  1.00 10.64           C  
ATOM    230  N   LEU A 141       7.808  18.908  13.909  1.00 19.64           N  
ATOM    231  CA  LEU A 141       7.999  17.464  13.908  1.00 18.89           C  
ATOM    232  C   LEU A 141       7.197  16.808  12.824  1.00 15.13           C  
ATOM    233  O   LEU A 141       6.076  17.204  12.545  1.00 13.87           O  
ATOM    234  CB  LEU A 141       7.539  16.830  15.213  1.00 19.41           C  
ATOM    235  CG  LEU A 141       8.178  17.310  16.496  1.00 21.79           C  
ATOM    236  CD1 LEU A 141       7.238  16.892  17.659  1.00 31.24           C  
ATOM    237  CD2 LEU A 141       9.528  16.741  16.641  1.00 20.90           C  
ATOM    238  N   ILE A 142       7.766  15.741  12.284  1.00 17.50           N  
ATOM    239  CA  ILE A 142       7.086  14.920  11.302  1.00 17.06           C  
ATOM    240  C   ILE A 142       6.112  14.069  12.020  1.00 12.82           C  
ATOM    241  O   ILE A 142       6.507  13.283  12.896  1.00 11.59           O  
ATOM    242  CB  ILE A 142       8.074  13.988  10.588  1.00 15.61           C  
ATOM    243  CG1 ILE A 142       9.019  14.818   9.756  1.00 16.95           C  
ATOM    244  CG2 ILE A 142       7.292  13.045   9.694  1.00 20.91           C  
ATOM    245  CD1 ILE A 142      10.240  14.053   9.148  1.00 20.60           C  
ATOM    246  N   SER A 143       4.823  14.189  11.652  1.00 19.63           N  
ATOM    247  CA  SER A 143       3.781  13.450  12.310  1.00 21.35           C  
ATOM    248  C   SER A 143       3.226  12.369  11.408  1.00 22.02           C  
ATOM    249  O   SER A 143       2.603  11.480  11.889  1.00 17.97           O  
ATOM    250  CB  SER A 143       2.640  14.355  12.799  1.00 22.29           C  
ATOM    251  OG  SER A 143       2.223  15.275  11.812  1.00 21.36           O  
ATOM    252  N   LYS A 144       3.476  12.430  10.109  1.00 21.06           N  
ATOM    253  CA  LYS A 144       3.127  11.342   9.236  1.00 18.09           C  
ATOM    254  C   LYS A 144       4.054  11.290   8.035  1.00 19.31           C  
ATOM    255  O   LYS A 144       4.488  12.342   7.522  1.00 16.38           O  
ATOM    256  CB  LYS A 144       1.651  11.442   8.796  1.00 21.44           C  
ATOM    257  CG  LYS A 144       1.149  10.149   8.166  1.00 24.87           C  
ATOM    258  CD  LYS A 144      -0.367  10.055   8.033  1.00 40.56           C  
ATOM    259  CE  LYS A 144      -0.735   8.759   7.272  1.00 45.31           C  
ATOM    260  NZ  LYS A 144      -2.208   8.581   7.076  1.00 53.41           N  
ATOM    261  N   ILE A 145       4.395  10.078   7.617  1.00 15.34           N  
ATOM    262  CA  ILE A 145       5.119   9.845   6.349  1.00 15.64           C  
ATOM    263  C   ILE A 145       4.206   8.982   5.484  1.00 17.98           C  
ATOM    264  O   ILE A 145       3.879   7.858   5.835  1.00 20.38           O  
ATOM    265  CB  ILE A 145       6.508   9.198   6.550  1.00 19.01           C  
ATOM    266  CG1 ILE A 145       7.428  10.175   7.280  1.00 19.67           C  
ATOM    267  CG2 ILE A 145       7.215   8.923   5.215  1.00 10.72           C  
ATOM    268  CD1 ILE A 145       8.703   9.550   7.797  1.00 24.33           C  
ATOM    269  N   PHE A 146       3.756   9.541   4.374  1.00 18.27           N  
ATOM    270  CA  PHE A 146       2.796   8.871   3.537  1.00 16.98           C  
ATOM    271  C   PHE A 146       3.504   7.809   2.687  1.00 14.87           C  
ATOM    272  O   PHE A 146       4.475   8.101   1.990  1.00 15.11           O  
ATOM    273  CB  PHE A 146       1.998   9.892   2.704  1.00 18.87           C  
ATOM    274  CG  PHE A 146       1.107  10.786   3.544  1.00 11.91           C  
ATOM    275  CD1 PHE A 146       1.471  12.058   3.865  1.00 18.91           C  
ATOM    276  CD2 PHE A 146      -0.124  10.311   4.017  1.00 22.46           C  
ATOM    277  CE1 PHE A 146       0.661  12.867   4.683  1.00 16.65           C  
ATOM    278  CE2 PHE A 146      -0.946  11.117   4.796  1.00 21.20           C  
ATOM    279  CZ  PHE A 146      -0.537  12.393   5.140  1.00 26.71           C  
ATOM    280  N   PRO A 147       3.009   6.573   2.739  1.00 15.08           N  
ATOM    281  CA  PRO A 147       3.644   5.443   2.087  1.00 15.33           C  
ATOM    282  C   PRO A 147       3.896   5.666   0.601  1.00 19.18           C  
ATOM    283  O   PRO A 147       2.993   6.089  -0.130  1.00 19.72           O  
ATOM    284  CB  PRO A 147       2.650   4.308   2.282  1.00 18.22           C  
ATOM    285  CG  PRO A 147       1.785   4.726   3.386  1.00 25.90           C  
ATOM    286  CD  PRO A 147       1.712   6.204   3.342  1.00 18.23           C  
ATOM    287  N   GLY A 148       5.126   5.409   0.168  1.00 19.78           N  
ATOM    288  CA  GLY A 148       5.460   5.453  -1.251  1.00 16.40           C  
ATOM    289  C   GLY A 148       5.673   6.816  -1.867  1.00 16.96           C  
ATOM    290  O   GLY A 148       6.139   6.887  -3.007  1.00 19.46           O  
ATOM    291  N   LEU A 149       5.333   7.892  -1.150  1.00 15.43           N  
ATOM    292  CA  LEU A 149       5.573   9.272  -1.611  1.00 15.22           C  
ATOM    293  C   LEU A 149       6.996   9.691  -1.264  1.00 20.10           C  
ATOM    294  O   LEU A 149       7.768   8.901  -0.722  1.00 17.85           O  
ATOM    295  CB  LEU A 149       4.520  10.255  -1.015  1.00 18.82           C  
ATOM    296  CG  LEU A 149       3.044   9.918  -1.301  1.00 16.31           C  
ATOM    297  CD1 LEU A 149       2.051  11.039  -0.867  1.00 16.30           C  
ATOM    298  CD2 LEU A 149       2.846   9.580  -2.755  1.00 15.12           C  
ATOM    299  N   ALA A 150       7.325  10.947  -1.553  1.00 18.68           N  
ATOM    300  CA  ALA A 150       8.685  11.392  -1.672  1.00 16.92           C  
ATOM    301  C   ALA A 150       9.539  11.133  -0.442  1.00 16.05           C  
ATOM    302  O   ALA A 150      10.646  10.620  -0.567  1.00 13.14           O  
ATOM    303  CB  ALA A 150       8.734  12.914  -2.093  1.00 17.64           C  
ATOM    304  N   ALA A 151       9.065  11.513   0.740  1.00 15.50           N  
ATOM    305  CA  ALA A 151       9.856  11.340   1.967  1.00 13.96           C  
ATOM    306  C   ALA A 151      10.023   9.859   2.259  1.00 18.00           C  
ATOM    307  O   ALA A 151      11.048   9.428   2.755  1.00 16.29           O  
ATOM    308  CB  ALA A 151       9.176  12.015   3.162  1.00 15.33           C  
ATOM    309  N   ASP A 152       8.974   9.082   2.016  1.00 17.76           N  
ATOM    310  CA  ASP A 152       9.056   7.643   2.212  1.00 18.58           C  
ATOM    311  C   ASP A 152      10.104   7.017   1.278  1.00 15.20           C  
ATOM    312  O   ASP A 152      10.886   6.174   1.709  1.00 16.18           O  
ATOM    313  CB  ASP A 152       7.686   6.985   2.016  1.00 15.47           C  
ATOM    314  CG  ASP A 152       7.664   5.523   2.471  1.00 27.39           C  
ATOM    315  OD1 ASP A 152       8.135   5.236   3.584  1.00 28.98           O  
ATOM    316  OD2 ASP A 152       7.163   4.659   1.702  1.00 23.96           O  
ATOM    317  N   GLN A 153      10.187   7.491   0.037  1.00 17.68           N  
ATOM    318  CA  GLN A 153      11.184   6.980  -0.910  1.00 15.53           C  
ATOM    319  C   GLN A 153      12.612   7.300  -0.532  1.00 15.32           C  
ATOM    320  O   GLN A 153      13.521   6.608  -0.984  1.00 17.26           O  
ATOM    321  CB  GLN A 153      10.947   7.489  -2.328  1.00 18.93           C  
ATOM    322  CG  GLN A 153       9.595   7.109  -2.963  1.00 19.25           C  
ATOM    323  CD  GLN A 153       9.473   5.636  -3.308  1.00 26.58           C  
ATOM    324  OE1 GLN A 153      10.467   4.949  -3.533  1.00 29.57           O  
ATOM    325  NE2 GLN A 153       8.240   5.145  -3.376  1.00 32.97           N  
ATOM    326  N   SER A 154      12.837   8.336   0.263  1.00 13.37           N  
ATOM    327  CA  SER A 154      14.182   8.618   0.744  1.00 13.13           C  
ATOM    328  C   SER A 154      14.675   7.537   1.701  1.00 14.43           C  
ATOM    329  O   SER A 154      15.864   7.380   1.869  1.00 22.92           O  
ATOM    330  CB  SER A 154      14.240   9.959   1.495  1.00 17.42           C  
ATOM    331  OG  SER A 154      13.636   9.859   2.799  1.00 15.39           O  
ATOM    332  N   ARG A 155      13.753   6.837   2.376  1.00 12.69           N  
ATOM    333  CA  ARG A 155      14.074   5.779   3.368  1.00 12.67           C  
ATOM    334  C   ARG A 155      14.967   6.297   4.485  1.00 14.83           C  
ATOM    335  O   ARG A 155      15.679   5.541   5.097  1.00 16.94           O  
ATOM    336  CB  ARG A 155      14.761   4.589   2.711  1.00 16.85           C  
ATOM    337  CG  ARG A 155      13.996   3.937   1.579  1.00 18.13           C  
ATOM    338  CD  ARG A 155      12.783   3.246   2.087  1.00 31.73           C  
ATOM    339  NE  ARG A 155      12.271   2.349   1.052  1.00 48.44           N  
ATOM    340  CZ  ARG A 155      11.110   2.491   0.418  1.00 47.73           C  
ATOM    341  NH1 ARG A 155      10.295   3.490   0.721  1.00 36.68           N  
ATOM    342  NH2 ARG A 155      10.758   1.601  -0.512  1.00 48.93           N  
ATOM    343  N   ALA A 156      14.935   7.597   4.737  1.00 11.88           N  
ATOM    344  CA  ALA A 156      15.857   8.216   5.674  1.00 13.93           C  
ATOM    345  C   ALA A 156      15.156   9.051   6.751  1.00 12.38           C  
ATOM    346  O   ALA A 156      15.830   9.660   7.587  1.00 12.67           O  
ATOM    347  CB  ALA A 156      16.815   9.113   4.919  1.00 16.48           C  
ATOM    348  N   LEU A 157      13.860   9.175   6.670  1.00 12.12           N  
ATOM    349  CA  LEU A 157      13.112   9.989   7.690  1.00 15.93           C  
ATOM    350  C   LEU A 157      12.331   9.103   8.611  1.00 16.43           C  
ATOM    351  O   LEU A 157      12.070   7.962   8.290  1.00 17.48           O  
ATOM    352  CB  LEU A 157      12.167  10.950   6.988  1.00 15.07           C  
ATOM    353  CG  LEU A 157      12.888  12.073   6.247  1.00 14.14           C  
ATOM    354  CD1 LEU A 157      11.927  12.761   5.337  1.00 21.11           C  
ATOM    355  CD2 LEU A 157      13.417  13.031   7.246  1.00 14.93           C  
ATOM    356  N   ARG A 158      11.958   9.628   9.769  1.00 14.20           N  
ATOM    357  CA  ARG A 158      11.291   8.848  10.776  1.00 15.12           C  
ATOM    358  C   ARG A 158      10.169   9.707  11.326  1.00 17.27           C  
ATOM    359  O   ARG A 158      10.332  10.912  11.507  1.00 12.41           O  
ATOM    360  CB  ARG A 158      12.246   8.560  11.947  1.00 15.47           C  
ATOM    361  CG  ARG A 158      13.424   7.700  11.651  1.00 27.56           C  
ATOM    362  CD  ARG A 158      14.362   7.645  12.868  1.00 34.89           C  
ATOM    363  NE  ARG A 158      15.772   7.665  12.461  1.00 39.26           N  
ATOM    364  CZ  ARG A 158      16.809   7.777  13.291  1.00 33.25           C  
ATOM    365  NH1 ARG A 158      18.035   7.799  12.798  1.00 36.02           N  
ATOM    366  NH2 ARG A 158      16.646   7.868  14.611  1.00 18.76           N  
ATOM    367  N   LEU A 159       9.042   9.079  11.591  1.00 21.13           N  
ATOM    368  CA  LEU A 159       8.018   9.659  12.459  1.00 23.19           C  
ATOM    369  C   LEU A 159       8.677  10.165  13.730  1.00 22.50           C  
ATOM    370  O   LEU A 159       9.354   9.400  14.434  1.00 17.85           O  
ATOM    371  CB  LEU A 159       6.991   8.614  12.845  1.00 24.25           C  
ATOM    372  CG  LEU A 159       5.669   8.671  12.109  1.00 36.17           C  
ATOM    373  CD1 LEU A 159       4.936   7.343  12.252  1.00 44.96           C  
ATOM    374  CD2 LEU A 159       4.859   9.782  12.731  1.00 40.85           C  
ATOM    375  N   GLY A 160       8.482  11.452  14.020  1.00 21.04           N  
ATOM    376  CA  GLY A 160       8.967  12.020  15.251  1.00 21.14           C  
ATOM    377  C   GLY A 160      10.306  12.707  15.132  1.00 20.05           C  
ATOM    378  O   GLY A 160      10.817  13.160  16.135  1.00 20.71           O  
ATOM    379  N   ASP A 161      10.845  12.795  13.909  1.00 14.85           N  
ATOM    380  CA  ASP A 161      12.052  13.550  13.627  1.00 17.08           C  
ATOM    381  C   ASP A 161      11.649  15.012  13.694  1.00 15.73           C  
ATOM    382  O   ASP A 161      10.565  15.385  13.230  1.00 14.32           O  
ATOM    383  CB  ASP A 161      12.545  13.292  12.193  1.00 14.99           C  
ATOM    384  CG  ASP A 161      13.438  12.088  12.048  1.00 22.69           C  
ATOM    385  OD1 ASP A 161      14.147  11.679  12.998  1.00 34.81           O  
ATOM    386  OD2 ASP A 161      13.553  11.630  10.889  1.00 23.12           O  
ATOM    387  N   ALA A 162      12.510  15.818  14.299  1.00 12.70           N  
ATOM    388  CA  ALA A 162      12.350  17.268  14.353  1.00 14.84           C  
ATOM    389  C   ALA A 162      12.974  17.789  13.059  1.00 16.24           C  
ATOM    390  O   ALA A 162      14.083  17.383  12.737  1.00 14.84           O  
ATOM    391  CB  ALA A 162      13.125  17.813  15.553  1.00 11.71           C  
ATOM    392  N   ILE A 163      12.271  18.626  12.313  1.00 14.52           N  
ATOM    393  CA  ILE A 163      12.864  19.341  11.168  1.00 11.00           C  
ATOM    394  C   ILE A 163      13.462  20.645  11.642  1.00 16.47           C  
ATOM    395  O   ILE A 163      12.757  21.508  12.072  1.00 14.57           O  
ATOM    396  CB  ILE A 163      11.907  19.605  10.042  1.00 13.05           C  
ATOM    397  CG1 ILE A 163      11.215  18.287   9.619  1.00 15.94           C  
ATOM    398  CG2 ILE A 163      12.661  20.190   8.788  1.00 12.26           C  
ATOM    399  CD1 ILE A 163      10.148  18.474   8.548  1.00 18.45           C  
ATOM    400  N   LEU A 164      14.799  20.735  11.602  1.00 11.14           N  
ATOM    401  CA  LEU A 164      15.532  21.875  12.114  1.00 15.05           C  
ATOM    402  C   LEU A 164      15.765  22.931  11.025  1.00 15.34           C  
ATOM    403  O   LEU A 164      15.807  24.140  11.314  1.00 13.17           O  
ATOM    404  CB  LEU A 164      16.899  21.440  12.667  1.00 12.60           C  
ATOM    405  CG  LEU A 164      16.875  20.278  13.692  1.00 19.27           C  
ATOM    406  CD1 LEU A 164      18.277  19.859  14.123  1.00 22.00           C  
ATOM    407  CD2 LEU A 164      16.046  20.675  14.891  1.00 19.57           C  
ATOM    408  N   SER A 165      15.953  22.483   9.791  1.00 13.84           N  
ATOM    409  CA  SER A 165      16.109  23.416   8.675  1.00 14.19           C  
ATOM    410  C   SER A 165      15.843  22.779   7.340  1.00 10.43           C  
ATOM    411  O   SER A 165      15.901  21.571   7.208  1.00 11.35           O  
ATOM    412  CB  SER A 165      17.530  24.003   8.661  1.00 11.35           C  
ATOM    413  OG  SER A 165      18.436  22.983   8.326  1.00 25.22           O  
ATOM    414  N   VAL A 166      15.608  23.622   6.335  1.00 11.49           N  
ATOM    415  CA  VAL A 166      15.355  23.185   5.009  1.00 10.36           C  
ATOM    416  C   VAL A 166      16.075  24.107   4.024  1.00 13.81           C  
ATOM    417  O   VAL A 166      15.830  25.309   3.978  1.00 11.71           O  
ATOM    418  CB  VAL A 166      13.826  23.101   4.679  1.00 17.81           C  
ATOM    419  CG1 VAL A 166      13.085  24.450   4.920  1.00 13.67           C  
ATOM    420  CG2 VAL A 166      13.640  22.610   3.231  1.00 21.67           C  
ATOM    421  N   ASN A 167      16.979  23.537   3.236  1.00 10.25           N  
ATOM    422  CA  ASN A 167      17.726  24.354   2.220  1.00 13.47           C  
ATOM    423  C   ASN A 167      18.221  25.700   2.751  1.00 11.05           C  
ATOM    424  O   ASN A 167      18.056  26.757   2.135  1.00 14.73           O  
ATOM    425  CB  ASN A 167      16.846  24.562   1.005  1.00  7.37           C  
ATOM    426  CG  ASN A 167      16.806  23.348   0.079  1.00 18.03           C  
ATOM    427  OD1 ASN A 167      17.521  22.404   0.272  1.00 16.44           O  
ATOM    428  ND2 ASN A 167      15.941  23.384  -0.936  1.00  9.59           N  
ATOM    429  N   GLY A 168      18.834  25.679   3.932  1.00 11.79           N  
ATOM    430  CA  GLY A 168      19.430  26.852   4.481  1.00  7.02           C  
ATOM    431  C   GLY A 168      18.427  27.701   5.282  1.00 10.38           C  
ATOM    432  O   GLY A 168      18.807  28.694   5.851  1.00  7.17           O  
ATOM    433  N   THR A 169      17.155  27.358   5.256  1.00 11.60           N  
ATOM    434  CA  THR A 169      16.171  28.100   6.032  1.00 14.97           C  
ATOM    435  C   THR A 169      15.985  27.412   7.394  1.00 15.26           C  
ATOM    436  O   THR A 169      15.638  26.244   7.454  1.00 10.97           O  
ATOM    437  CB  THR A 169      14.808  28.258   5.289  1.00 15.75           C  
ATOM    438  OG1 THR A 169      15.023  29.047   4.099  1.00 16.38           O  
ATOM    439  CG2 THR A 169      13.803  28.992   6.218  1.00 15.12           C  
ATOM    440  N   ASP A 170      16.244  28.146   8.473  1.00 17.32           N  
ATOM    441  CA  ASP A 170      16.232  27.608   9.831  1.00 18.16           C  
ATOM    442  C   ASP A 170      14.791  27.544  10.303  1.00 21.55           C  
ATOM    443  O   ASP A 170      14.045  28.460  10.066  1.00 16.87           O  
ATOM    444  CB  ASP A 170      17.059  28.491  10.775  1.00 19.70           C  
ATOM    445  CG  ASP A 170      16.946  28.080  12.232  1.00 31.75           C  
ATOM    446  OD1 ASP A 170      16.722  26.894  12.505  1.00 25.49           O  
ATOM    447  OD2 ASP A 170      17.078  28.942  13.129  1.00 48.04           O  
ATOM    448  N   LEU A 171      14.402  26.438  10.936  1.00 18.08           N  
ATOM    449  CA  LEU A 171      13.015  26.233  11.354  1.00 19.16           C  
ATOM    450  C   LEU A 171      12.916  25.927  12.839  1.00 17.90           C  
ATOM    451  O   LEU A 171      11.839  25.595  13.338  1.00 20.08           O  
ATOM    452  CB  LEU A 171      12.358  25.103  10.553  1.00 20.65           C  
ATOM    453  CG  LEU A 171      12.156  25.215   9.045  1.00 19.87           C  
ATOM    454  CD1 LEU A 171      11.406  23.999   8.539  1.00 25.16           C  
ATOM    455  CD2 LEU A 171      11.457  26.516   8.574  1.00 13.65           C  
ATOM    456  N   ARG A 172      14.028  26.077  13.552  1.00 18.62           N  
ATOM    457  CA  ARG A 172      14.095  25.798  14.969  1.00 19.57           C  
ATOM    458  C   ARG A 172      13.212  26.749  15.759  1.00 22.01           C  
ATOM    459  O   ARG A 172      12.686  26.363  16.797  1.00 24.02           O  
ATOM    460  CB  ARG A 172      15.529  25.885  15.469  1.00 21.29           C  
ATOM    461  CG  ARG A 172      16.442  24.794  14.919  1.00 15.93           C  
ATOM    462  CD  ARG A 172      17.892  25.214  15.046  1.00 18.51           C  
ATOM    463  NE  ARG A 172      18.819  24.205  14.534  1.00 18.48           N  
ATOM    464  CZ  ARG A 172      19.217  24.096  13.274  1.00 16.89           C  
ATOM    465  NH1 ARG A 172      18.772  24.906  12.320  1.00 22.33           N  
ATOM    466  NH2 ARG A 172      20.055  23.134  12.953  1.00 28.66           N  
ATOM    467  N   GLN A 173      13.018  27.963  15.237  1.00 22.77           N  
ATOM    468  CA  GLN A 173      12.140  28.948  15.851  1.00 22.43           C  
ATOM    469  C   GLN A 173      11.037  29.399  14.896  1.00 21.19           C  
ATOM    470  O   GLN A 173      10.496  30.474  15.034  1.00 19.51           O  
ATOM    471  CB  GLN A 173      12.972  30.140  16.322  1.00 23.04           C  
ATOM    472  CG  GLN A 173      13.907  29.771  17.434  1.00 30.46           C  
ATOM    473  CD  GLN A 173      14.688  30.948  17.950  1.00 46.91           C  
ATOM    474  OE1 GLN A 173      14.929  31.914  17.223  1.00 57.46           O  
ATOM    475  NE2 GLN A 173      15.097  30.878  19.211  1.00 52.66           N  
ATOM    476  N   ALA A 174      10.653  28.549  13.958  1.00 19.44           N  
ATOM    477  CA  ALA A 174       9.591  28.898  13.042  1.00 17.57           C  
ATOM    478  C   ALA A 174       8.215  28.635  13.682  1.00 13.27           C  
ATOM    479  O   ALA A 174       8.023  27.686  14.468  1.00 15.70           O  
ATOM    480  CB  ALA A 174       9.749  28.115  11.729  1.00 18.40           C  
ATOM    481  N   THR A 175       7.259  29.479  13.355  1.00 15.18           N  
ATOM    482  CA  THR A 175       5.872  29.171  13.627  1.00 14.42           C  
ATOM    483  C   THR A 175       5.467  28.060  12.688  1.00 14.60           C  
ATOM    484  O   THR A 175       6.133  27.792  11.667  1.00 12.71           O  
ATOM    485  CB  THR A 175       4.975  30.355  13.354  1.00 17.35           C  
ATOM    486  OG1 THR A 175       5.113  30.737  11.973  1.00 11.76           O  
ATOM    487  CG2 THR A 175       5.342  31.524  14.268  1.00 14.86           C  
ATOM    488  N   HIS A 176       4.350  27.432  13.002  1.00 11.91           N  
ATOM    489  CA  HIS A 176       3.826  26.397  12.167  1.00 14.15           C  
ATOM    490  C   HIS A 176       3.676  26.869  10.721  1.00 15.24           C  
ATOM    491  O   HIS A 176       4.202  26.240   9.801  1.00 10.70           O  
ATOM    492  CB  HIS A 176       2.493  25.913  12.675  1.00 13.19           C  
ATOM    493  CG  HIS A 176       1.978  24.721  11.939  1.00  9.73           C  
ATOM    494  ND1 HIS A 176       2.412  23.445  12.208  1.00 13.02           N  
ATOM    495  CD2 HIS A 176       1.085  24.612  10.931  1.00 12.09           C  
ATOM    496  CE1 HIS A 176       1.789  22.595  11.417  1.00  8.76           C  
ATOM    497  NE2 HIS A 176       1.007  23.278  10.605  1.00 11.70           N  
ATOM    498  N   ASP A 177       2.982  27.973  10.518  1.00 13.47           N  
ATOM    499  CA  ASP A 177       2.698  28.464   9.153  1.00 18.75           C  
ATOM    500  C   ASP A 177       3.951  28.838   8.369  1.00 13.87           C  
ATOM    501  O   ASP A 177       3.988  28.621   7.175  1.00 19.14           O  
ATOM    502  CB  ASP A 177       1.670  29.602   9.159  1.00 21.33           C  
ATOM    503  CG  ASP A 177       0.234  29.102   9.445  1.00 35.94           C  
ATOM    504  OD1 ASP A 177      -0.084  27.921   9.130  1.00 39.16           O  
ATOM    505  OD2 ASP A 177      -0.573  29.891   9.990  1.00 48.94           O  
ATOM    506  N   GLN A 178       4.970  29.332   9.076  1.00 13.89           N  
ATOM    507  CA  GLN A 178       6.281  29.678   8.542  1.00 16.60           C  
ATOM    508  C   GLN A 178       7.042  28.424   8.104  1.00 15.91           C  
ATOM    509  O   GLN A 178       7.694  28.420   7.059  1.00 14.26           O  
ATOM    510  CB  GLN A 178       7.110  30.428   9.589  1.00 16.70           C  
ATOM    511  CG  GLN A 178       6.653  31.901   9.923  1.00 23.27           C  
ATOM    512  CD  GLN A 178       7.325  32.499  11.190  1.00 33.00           C  
ATOM    513  OE1 GLN A 178       8.162  31.858  11.845  1.00 22.25           O  
ATOM    514  NE2 GLN A 178       6.939  33.738  11.539  1.00 38.88           N  
ATOM    515  N   ALA A 179       6.977  27.357   8.899  1.00 15.07           N  
ATOM    516  CA  ALA A 179       7.536  26.078   8.497  1.00 13.70           C  
ATOM    517  C   ALA A 179       6.841  25.540   7.269  1.00  9.56           C  
ATOM    518  O   ALA A 179       7.477  25.118   6.310  1.00 17.67           O  
ATOM    519  CB  ALA A 179       7.471  25.056   9.660  1.00 13.59           C  
ATOM    520  N   VAL A 180       5.529  25.577   7.261  1.00 12.79           N  
ATOM    521  CA  VAL A 180       4.777  25.022   6.127  1.00 10.18           C  
ATOM    522  C   VAL A 180       5.214  25.776   4.836  1.00 16.18           C  
ATOM    523  O   VAL A 180       5.501  25.139   3.799  1.00 14.02           O  
ATOM    524  CB  VAL A 180       3.295  25.122   6.371  1.00 13.65           C  
ATOM    525  CG1 VAL A 180       2.484  24.798   5.096  1.00 11.32           C  
ATOM    526  CG2 VAL A 180       2.909  24.228   7.561  1.00 11.43           C  
ATOM    527  N   GLN A 181       5.293  27.110   4.914  1.00 15.19           N  
ATOM    528  CA  GLN A 181       5.665  27.936   3.739  1.00 12.61           C  
ATOM    529  C   GLN A 181       7.069  27.691   3.241  1.00 12.70           C  
ATOM    530  O   GLN A 181       7.320  27.674   2.042  1.00 16.75           O  
ATOM    531  CB  GLN A 181       5.480  29.430   4.034  1.00 10.32           C  
ATOM    532  CG  GLN A 181       3.988  29.813   4.119  1.00 21.90           C  
ATOM    533  CD  GLN A 181       3.184  29.377   2.882  1.00 35.84           C  
ATOM    534  OE1 GLN A 181       3.608  29.588   1.734  1.00 38.89           O  
ATOM    535  NE2 GLN A 181       2.011  28.770   3.117  1.00 37.04           N  
ATOM    536  N   ALA A 182       7.972  27.495   4.183  1.00 12.76           N  
ATOM    537  CA  ALA A 182       9.357  27.319   3.916  1.00 15.24           C  
ATOM    538  C   ALA A 182       9.615  25.983   3.177  1.00 15.60           C  
ATOM    539  O   ALA A 182      10.377  25.895   2.221  1.00 15.69           O  
ATOM    540  CB  ALA A 182      10.088  27.369   5.209  1.00  9.14           C  
ATOM    541  N   LEU A 183       8.922  24.963   3.609  1.00 16.73           N  
ATOM    542  CA  LEU A 183       9.051  23.651   3.043  1.00 18.72           C  
ATOM    543  C   LEU A 183       8.356  23.628   1.666  1.00 20.97           C  
ATOM    544  O   LEU A 183       8.853  23.043   0.706  1.00 20.74           O  
ATOM    545  CB  LEU A 183       8.428  22.636   3.991  1.00 15.78           C  
ATOM    546  CG  LEU A 183       9.169  22.317   5.286  1.00 18.20           C  
ATOM    547  CD1 LEU A 183       8.292  21.631   6.287  1.00 12.07           C  
ATOM    548  CD2 LEU A 183      10.332  21.437   5.001  1.00 12.60           C  
ATOM    549  N   LYS A 184       7.225  24.306   1.564  1.00 18.30           N  
ATOM    550  CA  LYS A 184       6.495  24.335   0.307  1.00 20.88           C  
ATOM    551  C   LYS A 184       7.242  25.111  -0.750  1.00 20.94           C  
ATOM    552  O   LYS A 184       7.093  24.825  -1.923  1.00 25.83           O  
ATOM    553  CB  LYS A 184       5.090  24.917   0.496  1.00 24.53           C  
ATOM    554  CG  LYS A 184       4.143  23.941   1.189  1.00 29.71           C  
ATOM    555  CD  LYS A 184       2.724  24.494   1.243  1.00 31.89           C  
ATOM    556  CE  LYS A 184       1.720  23.385   1.429  1.00 30.72           C  
ATOM    557  NZ  LYS A 184       0.331  23.839   1.117  1.00 49.98           N  
ATOM    558  N   ARG A 185       8.094  26.049  -0.344  1.00 17.09           N  
ATOM    559  CA  ARG A 185       8.754  26.908  -1.300  1.00 19.28           C  
ATOM    560  C   ARG A 185      10.247  26.629  -1.453  1.00 16.24           C  
ATOM    561  O   ARG A 185      10.951  27.357  -2.134  1.00 13.00           O  
ATOM    562  CB  ARG A 185       8.513  28.348  -0.908  1.00 20.96           C  
ATOM    563  CG  ARG A 185       7.029  28.762  -1.069  1.00 31.31           C  
ATOM    564  CD  ARG A 185       6.715  29.118  -2.544  1.00 47.38           C  
ATOM    565  NE  ARG A 185       5.289  29.011  -2.867  1.00 63.73           N  
ATOM    566  CZ  ARG A 185       4.729  29.414  -4.010  1.00 65.30           C  
ATOM    567  NH1 ARG A 185       5.457  29.972  -4.973  1.00 66.06           N  
ATOM    568  NH2 ARG A 185       3.421  29.264  -4.186  1.00 65.28           N  
ATOM    569  N   ALA A 186      10.705  25.536  -0.879  1.00 11.97           N  
ATOM    570  CA  ALA A 186      12.131  25.246  -0.838  1.00 15.79           C  
ATOM    571  C   ALA A 186      12.625  24.721  -2.202  1.00 13.53           C  
ATOM    572  O   ALA A 186      13.827  24.554  -2.403  1.00 12.66           O  
ATOM    573  CB  ALA A 186      12.424  24.232   0.274  1.00 16.27           C  
ATOM    574  N   GLY A 187      11.695  24.445  -3.123  1.00 10.53           N  
ATOM    575  CA  GLY A 187      12.037  23.924  -4.437  1.00 14.94           C  
ATOM    576  C   GLY A 187      11.686  22.451  -4.572  1.00 15.25           C  
ATOM    577  O   GLY A 187      11.035  21.843  -3.696  1.00 16.79           O  
ATOM    578  N   LYS A 188      12.156  21.856  -5.650  1.00 11.90           N  
ATOM    579  CA  LYS A 188      11.841  20.485  -5.922  1.00 13.51           C  
ATOM    580  C   LYS A 188      12.757  19.513  -5.209  1.00 13.29           C  
ATOM    581  O   LYS A 188      12.357  18.410  -4.951  1.00 15.80           O  
ATOM    582  CB  LYS A 188      11.783  20.217  -7.430  1.00 17.91           C  
ATOM    583  CG  LYS A 188      10.516  20.814  -8.060  1.00 21.56           C  
ATOM    584  CD  LYS A 188       9.237  20.090  -7.509  1.00 37.86           C  
ATOM    585  CE  LYS A 188       7.959  20.917  -7.583  1.00 38.81           C  
ATOM    586  NZ  LYS A 188       6.914  20.372  -6.657  1.00 25.06           N  
ATOM    587  N   GLU A 189      13.990  19.884  -4.920  1.00 13.82           N  
ATOM    588  CA  GLU A 189      14.833  19.041  -4.100  1.00 11.63           C  
ATOM    589  C   GLU A 189      15.150  19.797  -2.815  1.00 15.01           C  
ATOM    590  O   GLU A 189      15.472  20.997  -2.851  1.00 14.95           O  
ATOM    591  CB  GLU A 189      16.085  18.634  -4.859  1.00 11.59           C  
ATOM    592  CG  GLU A 189      17.061  17.893  -3.993  1.00 17.78           C  
ATOM    593  CD  GLU A 189      18.281  17.378  -4.764  1.00 27.46           C  
ATOM    594  OE1 GLU A 189      18.315  17.427  -6.019  1.00 24.03           O  
ATOM    595  OE2 GLU A 189      19.228  16.923  -4.100  1.00 35.50           O  
ATOM    596  N   VAL A 190      14.996  19.100  -1.681  1.00 11.23           N  
ATOM    597  CA  VAL A 190      15.268  19.668  -0.387  1.00 11.94           C  
ATOM    598  C   VAL A 190      16.305  18.892   0.373  1.00 13.45           C  
ATOM    599  O   VAL A 190      16.294  17.665   0.368  1.00 16.75           O  
ATOM    600  CB  VAL A 190      13.998  19.782   0.483  1.00 18.72           C  
ATOM    601  CG1 VAL A 190      12.942  20.577  -0.268  1.00 24.29           C  
ATOM    602  CG2 VAL A 190      13.542  18.444   0.910  1.00 19.71           C  
ATOM    603  N   LEU A 191      17.208  19.619   1.017  1.00 12.52           N  
ATOM    604  CA  LEU A 191      18.045  19.046   2.021  1.00 12.33           C  
ATOM    605  C   LEU A 191      17.450  19.468   3.359  1.00 12.56           C  
ATOM    606  O   LEU A 191      17.351  20.671   3.664  1.00 13.49           O  
ATOM    607  CB  LEU A 191      19.463  19.538   1.883  1.00 15.90           C  
ATOM    608  CG  LEU A 191      20.543  18.778   2.658  1.00 24.97           C  
ATOM    609  CD1 LEU A 191      20.628  17.298   2.193  1.00 27.00           C  
ATOM    610  CD2 LEU A 191      21.908  19.500   2.426  1.00 22.21           C  
ATOM    611  N   LEU A 192      17.010  18.475   4.117  1.00 11.66           N  
ATOM    612  CA  LEU A 192      16.431  18.681   5.452  1.00 13.26           C  
ATOM    613  C   LEU A 192      17.446  18.343   6.489  1.00 16.06           C  
ATOM    614  O   LEU A 192      18.103  17.275   6.430  1.00 15.13           O  
ATOM    615  CB  LEU A 192      15.253  17.774   5.663  1.00 16.41           C  
ATOM    616  CG  LEU A 192      14.074  17.946   4.735  1.00 22.77           C  
ATOM    617  CD1 LEU A 192      13.029  16.852   5.049  1.00 21.68           C  
ATOM    618  CD2 LEU A 192      13.492  19.352   4.899  1.00 12.68           C  
ATOM    619  N   GLU A 193      17.614  19.239   7.452  1.00 14.19           N  
ATOM    620  CA  GLU A 193      18.384  18.854   8.626  1.00 10.79           C  
ATOM    621  C   GLU A 193      17.359  18.371   9.681  1.00 11.26           C  
ATOM    622  O   GLU A 193      16.438  19.114  10.000  1.00 14.92           O  
ATOM    623  CB  GLU A 193      19.147  20.030   9.121  1.00 13.73           C  
ATOM    624  CG  GLU A 193      20.074  19.764  10.163  1.00 25.08           C  
ATOM    625  CD  GLU A 193      20.775  21.070  10.599  1.00 53.09           C  
ATOM    626  OE1 GLU A 193      20.716  22.085   9.848  1.00 46.54           O  
ATOM    627  OE2 GLU A 193      21.375  21.092  11.703  1.00 63.97           O  
ATOM    628  N   VAL A 194      17.526  17.146  10.169  1.00 17.83           N  
ATOM    629  CA  VAL A 194      16.546  16.517  11.095  1.00 18.98           C  
ATOM    630  C   VAL A 194      17.288  15.907  12.280  1.00 16.87           C  
ATOM    631  O   VAL A 194      18.494  15.644  12.229  1.00 15.75           O  
ATOM    632  CB  VAL A 194      15.695  15.457  10.403  1.00 16.23           C  
ATOM    633  CG1 VAL A 194      14.967  16.071   9.175  1.00 14.19           C  
ATOM    634  CG2 VAL A 194      16.562  14.250  10.001  1.00 18.06           C  
ATOM    635  N   LYS A 195      16.568  15.812  13.402  1.00 17.11           N  
ATOM    636  CA  LYS A 195      17.053  15.222  14.616  1.00 19.71           C  
ATOM    637  C   LYS A 195      15.892  14.443  15.227  1.00 19.44           C  
ATOM    638  O   LYS A 195      14.775  14.960  15.377  1.00 18.79           O  
ATOM    639  CB  LYS A 195      17.542  16.329  15.527  1.00 20.48           C  
ATOM    640  CG  LYS A 195      18.275  15.901  16.746  1.00 29.89           C  
ATOM    641  CD  LYS A 195      18.884  17.115  17.468  1.00 29.52           C  
ATOM    642  CE  LYS A 195      17.831  17.932  18.222  1.00 42.59           C  
ATOM    643  NZ  LYS A 195      18.460  19.033  19.022  1.00 50.25           N  
ATOM    644  N   PHE A 196      16.117  13.179  15.532  1.00 19.88           N  
ATOM    645  CA  PHE A 196      15.034  12.387  16.076  1.00 19.88           C  
ATOM    646  C   PHE A 196      14.822  12.837  17.524  1.00 21.84           C  
ATOM    647  O   PHE A 196      15.791  13.156  18.238  1.00 21.59           O  
ATOM    648  CB  PHE A 196      15.382  10.909  16.040  1.00 16.90           C  
ATOM    649  CG  PHE A 196      14.296  10.028  16.555  1.00 24.08           C  
ATOM    650  CD1 PHE A 196      13.097   9.870  15.837  1.00 13.71           C  
ATOM    651  CD2 PHE A 196      14.457   9.342  17.756  1.00 26.51           C  
ATOM    652  CE1 PHE A 196      12.113   9.022  16.300  1.00 29.05           C  
ATOM    653  CE2 PHE A 196      13.453   8.514  18.234  1.00 25.09           C  
ATOM    654  CZ  PHE A 196      12.283   8.352  17.504  1.00 30.81           C  
ATOM    655  N   ILE A 197      13.567  12.921  17.932  1.00 26.78           N  
ATOM    656  CA  ILE A 197      13.217  13.236  19.337  1.00 26.07           C  
ATOM    657  C   ILE A 197      12.784  11.936  20.025  1.00 23.83           C  
ATOM    658  O   ILE A 197      11.814  11.317  19.622  1.00 23.18           O  
ATOM    659  CB  ILE A 197      12.099  14.290  19.418  1.00 29.65           C  
ATOM    660  CG1 ILE A 197      12.568  15.612  18.815  1.00 29.85           C  
ATOM    661  CG2 ILE A 197      11.659  14.544  20.889  1.00 27.53           C  
ATOM    662  CD1 ILE A 197      11.703  16.783  19.238  1.00 37.59           C  
ATOM    663  N   ARG A 198      13.571  11.483  20.995  1.00 25.96           N  
ATOM    664  CA  ARG A 198      13.207  10.315  21.785  1.00 30.64           C  
ATOM    665  C   ARG A 198      12.181  10.806  22.777  1.00 31.87           C  
ATOM    666  O   ARG A 198      12.516  11.572  23.670  1.00 38.22           O  
ATOM    667  CB  ARG A 198      14.397   9.751  22.553  1.00 31.67           C  
ATOM    668  CG  ARG A 198      15.177   8.699  21.778  1.00 43.73           C  
ATOM    669  CD  ARG A 198      16.426   8.239  22.514  1.00 49.27           C  
ATOM    670  NE  ARG A 198      16.111   7.578  23.783  1.00 60.96           N  
ATOM    671  CZ  ARG A 198      16.915   6.726  24.421  1.00 64.19           C  
ATOM    672  NH1 ARG A 198      18.104   6.388  23.913  1.00 61.64           N  
ATOM    673  NH2 ARG A 198      16.517   6.194  25.575  1.00 60.63           N  
ATOM    674  N   GLU A 199      10.943  10.410  22.591  1.00 34.31           N  
ATOM    675  CA  GLU A 199       9.926  10.735  23.578  1.00 41.52           C  
ATOM    676  C   GLU A 199       9.925   9.702  24.695  1.00 36.32           C  
ATOM    677  O   GLU A 199       9.888   8.494  24.469  1.00 33.52           O  
ATOM    678  CB  GLU A 199       8.536  10.905  22.965  1.00 43.54           C  
ATOM    679  CG  GLU A 199       7.888   9.677  22.364  1.00 56.02           C  
ATOM    680  CD  GLU A 199       6.403   9.908  22.146  1.00 65.40           C  
ATOM    681  OE1 GLU A 199       5.664   9.978  23.158  1.00 67.87           O  
ATOM    682  OE2 GLU A 199       5.983  10.037  20.973  1.00 67.23           O  
ATOM    683  N   VAL A 200      10.034  10.231  25.901  1.00 34.55           N  
ATOM    684  CA  VAL A 200       9.891   9.481  27.102  1.00 29.83           C  
ATOM    685  C   VAL A 200       8.564   9.957  27.707  1.00 27.81           C  
ATOM    686  O   VAL A 200       8.269  11.148  27.733  1.00 30.32           O  
ATOM    687  CB  VAL A 200      11.062   9.792  28.031  1.00 27.98           C  
ATOM    688  CG1 VAL A 200      10.979   8.980  29.314  1.00 24.58           C  
ATOM    689  CG2 VAL A 200      12.393   9.532  27.289  1.00 35.67           C  
ATOM    690  N   ASN A 201       7.742   9.020  28.124  1.00 23.02           N  
ATOM    691  CA  ASN A 201       6.527   9.325  28.821  1.00 24.43           C  
ATOM    692  C   ASN A 201       6.755   8.730  30.183  1.00 21.30           C  
ATOM    693  O   ASN A 201       7.069   7.557  30.288  1.00 25.71           O  
ATOM    694  CB  ASN A 201       5.324   8.689  28.119  1.00 25.00           C  
ATOM    695  CG  ASN A 201       4.991   9.357  26.785  1.00 34.67           C  
ATOM    696  OD1 ASN A 201       4.259  10.339  26.740  1.00 26.46           O  
ATOM    697  ND2 ASN A 201       5.496   8.796  25.693  1.00 37.03           N  
ATOM    698  N   THR A 202       6.673   9.539  31.218  1.00 18.50           N  
ATOM    699  CA  THR A 202       6.836   9.065  32.565  1.00 21.01           C  
ATOM    700  C   THR A 202       5.535   9.231  33.300  1.00 22.74           C  
ATOM    701  O   THR A 202       4.997  10.345  33.348  1.00 18.97           O  
ATOM    702  CB  THR A 202       7.872   9.906  33.338  1.00 23.01           C  
ATOM    703  OG1 THR A 202       9.071   9.986  32.571  1.00 24.22           O  
ATOM    704  CG2 THR A 202       8.147   9.301  34.735  1.00 16.84           C  
ATOM    705  N   VAL A 203       5.064   8.136  33.905  1.00 23.29           N  
ATOM    706  CA  VAL A 203       3.914   8.198  34.807  1.00 22.74           C  
ATOM    707  C   VAL A 203       4.291   8.889  36.109  1.00 26.46           C  
ATOM    708  O   VAL A 203       5.271   8.523  36.773  1.00 21.62           O  
ATOM    709  CB  VAL A 203       3.317   6.804  35.089  1.00 23.93           C  
ATOM    710  CG1 VAL A 203       2.118   6.902  36.042  1.00 17.99           C  
ATOM    711  CG2 VAL A 203       2.898   6.139  33.781  1.00 12.40           C  
ATOM    712  N   VAL A 204       3.491   9.901  36.459  1.00 29.12           N  
ATOM    713  CA  VAL A 204       3.665  10.688  37.674  1.00 32.81           C  
ATOM    714  C   VAL A 204       2.301  10.888  38.411  1.00 36.79           C  
ATOM    715  O   VAL A 204       2.204  11.476  39.503  1.00 36.39           O  
ATOM    716  CB  VAL A 204       4.309  12.045  37.338  1.00 33.45           C  
ATOM    717  CG1 VAL A 204       5.633  11.835  36.598  1.00 31.07           C  
ATOM    718  CG2 VAL A 204       3.369  12.888  36.499  1.00 32.64           C  
ATOM    719  OXT VAL A 204       1.232  10.452  37.943  1.00 37.53           O  
TER     720      VAL A 204                                                      
END
MOLECULE T0488.pdb
ATOM      1  N   SER     1      20.128  12.809  24.526  1.00 19.40           N
ATOM      2  CA  SER     1      20.938  12.899  23.283  1.00 14.62           C
ATOM      4  CB  SER     1      21.786  11.646  23.101  1.00 17.49           C
ATOM      7  OG  SER     1      20.984  10.481  22.955  1.00 25.56           O
ATOM      9  C   SER     1      20.052  13.074  22.065  1.00 13.47           C
ATOM     10  O   SER     1      18.834  12.879  22.117  1.00 15.69           O
ATOM     14  N   MET     2      20.684  13.412  20.957  1.00 10.92           N
ATOM     15  CA  MET     2      20.000  13.465  19.689  1.00  9.70           C
ATOM     17  CB  MET     2      19.319  14.815  19.493  1.00 12.91           C
ATOM     20  CG  MET     2      20.286  15.963  19.402  1.00 15.71           C
ATOM     23  SD  MET     2      19.467  17.568  19.366  1.00 19.52           S
ATOM     24  CE  MET     2      18.819  17.665  21.032  1.00 31.08           C
ATOM     28  C   MET     2      20.956  13.195  18.552  1.00  9.06           C
ATOM     29  O   MET     2      22.158  13.370  18.682  1.00 13.20           O
ATOM     31  N   GLU     3      20.384  12.759  17.442  1.00  7.47           N
ATOM     32  CA  GLU     3      21.090  12.632  16.203  1.00  7.61           C
ATOM     34  CB  GLU     3      20.756  11.297  15.535  1.00  9.77           C
ATOM     37  CG  GLU     3      21.552  11.077  14.264  1.00 14.79           C
ATOM     40  CD  GLU     3      21.122   9.855  13.502  1.00 26.53           C
ATOM     41  OE1 GLU     3      20.303   9.074  14.028  1.00 31.96           O
ATOM     42  OE2 GLU     3      21.613   9.684  12.363  1.00 32.73           O
ATOM     43  C   GLU     3      20.689  13.781  15.297  1.00  8.80           C
ATOM     44  O   GLU     3      19.509  14.082  15.173  1.00 10.63           O
ATOM     46  N   ILE     4      21.679  14.418  14.693  1.00  7.18           N
ATOM     47  CA  ILE     4      21.451  15.424  13.665  1.00  7.38           C
ATOM     49  CB  ILE     4      22.306  16.675  13.857  1.00  9.41           C
ATOM     51  CG1 ILE     4      22.197  17.198  15.271  1.00 12.88           C
ATOM     54  CD1 ILE     4      20.874  17.635  15.639  1.00 14.81           C
ATOM     58  CG2 ILE     4      21.949  17.745  12.806  1.00 11.50           C
ATOM     62  C   ILE     4      21.801  14.808  12.341  1.00  7.35           C
ATOM     63  O   ILE     4      22.895  14.249  12.178  1.00  9.86           O
ATOM     65  N   LEU     5      20.875  14.902  11.402  1.00  7.58           N
ATOM     66  CA  LEU     5      21.132  14.378  10.062  1.00  8.65           C
ATOM     68  CB  LEU     5      20.731  12.925   9.943  1.00 13.90           C
ATOM     71  CG  LEU     5      19.252  12.666  10.057  1.00 13.10           C
ATOM     73  CD1 LEU     5      18.882  11.388   9.287  1.00 20.34           C
ATOM     77  CD2 LEU     5      18.772  12.562  11.493  1.00 19.29           C
ATOM     81  C   LEU     5      20.456  15.222   8.993  1.00  7.20           C
ATOM     82  O   LEU     5      19.584  16.031   9.280  1.00  8.46           O
ATOM     84  N   GLN     6      20.928  15.069   7.768  1.00  7.20           N
ATOM     85  CA  GLN     6      20.395  15.791   6.642  1.00  7.97           C
ATOM     87  CB  GLN     6      21.472  16.631   5.956  1.00 11.22           C
ATOM     90  CG  GLN     6      22.010  17.704   6.886  1.00 17.34           C
ATOM     93  CD  GLN     6      22.853  18.757   6.211  1.00 25.58           C
ATOM     94  OE1 GLN     6      22.673  19.078   5.034  1.00 22.54           O
ATOM     95  NE2 GLN     6      23.778  19.328   6.973  1.00 35.80           N
ATOM     98  C   GLN     6      19.774  14.804   5.678  1.00  8.78           C
ATOM     99  O   GLN     6      20.362  13.773   5.376  1.00 12.62           O
ATOM    101  N   VAL     7      18.567  15.128   5.237  1.00  6.69           N
ATOM    102  CA  VAL     7      17.825  14.314   4.312  1.00  6.49           C
ATOM    104  CB  VAL     7      16.555  13.757   4.961  1.00  7.24           C
ATOM    106  CG1 VAL     7      15.691  13.030   3.954  1.00  9.62           C
ATOM    110  CG2 VAL     7      16.911  12.821   6.122  1.00  9.31           C
ATOM    114  C   VAL     7      17.450  15.146   3.110  1.00  6.92           C
ATOM    115  O   VAL     7      16.765  16.128   3.242  1.00  9.54           O
ATOM    117  N   ALA     8      17.874  14.713   1.934  1.00  7.20           N
ATOM    118  CA  ALA     8      17.555  15.401   0.689  1.00  8.32           C
ATOM    120  CB  ALA     8      18.823  15.574  -0.152  1.00 12.50           C
ATOM    124  C   ALA     8      16.514  14.615  -0.079  1.00  7.94           C
ATOM    125  O   ALA     8      16.711  13.451  -0.375  1.00 12.11           O
ATOM    127  N   LEU     9      15.396  15.253  -0.365  1.00  7.05           N
ATOM    128  CA  LEU     9      14.331  14.704  -1.186  1.00  7.53           C
ATOM    130  CB  LEU     9      12.989  14.824  -0.479  1.00  7.05           C
ATOM    133  CG  LEU     9      12.915  14.175   0.902  1.00  6.94           C
ATOM    135  CD1 LEU     9      11.557  14.422   1.532  1.00 10.28           C
ATOM    139  CD2 LEU     9      13.241  12.665   0.874  1.00  9.01           C
ATOM    143  C   LEU     9      14.296  15.466  -2.509  1.00  6.69           C
ATOM    144  O   LEU     9      14.683  16.629  -2.573  1.00  9.96           O
ATOM    146  N   HIS    10      13.820  14.806  -3.557  1.00  7.45           N
ATOM    147  CA  HIS    10      13.788  15.443  -4.867  1.00  8.58           C
ATOM    149  CB  HIS    10      14.817  14.786  -5.773  1.00 10.46           C
ATOM    152  CG  HIS    10      16.223  15.001  -5.303  1.00 12.40           C
ATOM    153  ND1 HIS    10      16.996  16.053  -5.741  1.00 16.70           N
ATOM    155  CE1 HIS    10      18.175  16.010  -5.143  1.00 18.81           C
ATOM    157  NE2 HIS    10      18.179  14.989  -4.305  1.00 19.15           N
ATOM    159  CD2 HIS    10      16.965  14.349  -4.376  1.00 19.64           C
ATOM    161  C   HIS    10      12.402  15.443  -5.494  1.00  7.84           C
ATOM    162  O   HIS    10      11.834  14.379  -5.778  1.00 11.03           O
ATOM    164  N   LYS    11      11.837  16.643  -5.638  1.00  9.81           N
ATOM    165  CA  LYS    11      10.512  16.790  -6.253  1.00 10.04           C
ATOM    167  CB  LYS    11       9.985  18.217  -6.073  1.00 12.34           C
ATOM    170  CG  LYS    11       9.686  18.625  -4.623  1.00 12.62           C
ATOM    173  CD  LYS    11       8.576  19.704  -4.546  1.00 31.05           C
ATOM    176  CE  LYS    11       8.996  21.073  -5.051  1.00 24.45           C
ATOM    179  NZ  LYS    11       8.322  22.218  -4.361  1.00 21.96           N
ATOM    183  C   LYS    11      10.588  16.474  -7.733  1.00 12.69           C
ATOM    184  O   LYS    11      11.432  17.042  -8.419  1.00 14.69           O
ATOM    186  N   ARG    12       9.704  15.604  -8.215  1.00 13.65           N
ATOM    187  CA  ARG    12       9.688  15.217  -9.636  1.00 17.02           C
ATOM    189  CB  ARG    12       9.080  13.819  -9.812  1.00 18.82           C
ATOM    192  CG  ARG    12       9.882  12.720  -9.103  1.00 23.83           C
ATOM    195  CD  ARG    12      10.108  11.497  -9.984  1.00 35.96           C
ATOM    198  NE  ARG    12      10.943  10.483  -9.336  1.00 41.80           N
ATOM    200  CZ  ARG    12      11.421   9.393  -9.940  1.00 38.74           C
ATOM    201  NH1 ARG    12      11.158   9.156 -11.222  1.00 41.88           N
ATOM    204  NH2 ARG    12      12.172   8.530  -9.257  1.00 33.93           N
ATOM    207  C   ARG    12       8.948  16.257 -10.475  1.00 17.99           C
ATOM    208  O   ARG    12       9.156  16.335 -11.696  1.00 22.78           O
ATOM    210  N   ASP    13       8.081  17.035  -9.822  1.00 16.60           N
ATOM    211  CA  ASP    13       7.475  18.241 -10.404  1.00 17.38           C
ATOM    213  CB  ASP    13       6.064  17.959 -10.970  1.00 19.09           C
ATOM    216  CG  ASP    13       5.028  17.642  -9.898  1.00 19.81           C
ATOM    217  OD1 ASP    13       4.382  18.582  -9.384  1.00 22.06           O
ATOM    218  OD2 ASP    13       4.810  16.436  -9.621  1.00 23.43           O
ATOM    219  C   ASP    13       7.449  19.320  -9.327  1.00 14.18           C
ATOM    220  O   ASP    13       7.531  19.010  -8.142  1.00 14.00           O
ATOM    222  N   SER    14       7.329  20.578  -9.725  1.00 13.19           N
ATOM    223  CA  SER    14       7.384  21.702  -8.783  1.00 13.78           C
ATOM    225  CB  SER    14       7.433  23.044  -9.519  1.00 14.22           C
ATOM    228  OG  SER    14       6.243  23.269 -10.244  1.00 16.20           O
ATOM    230  C   SER    14       6.252  21.710  -7.764  1.00 11.76           C
ATOM    231  O   SER    14       6.341  22.373  -6.725  1.00 14.54           O
ATOM    233  N   GLY    15       5.172  20.998  -8.084  1.00 11.38           N
ATOM    234  CA  GLY    15       4.049  20.871  -7.180  1.00 10.63           C
ATOM    237  C   GLY    15       3.987  19.585  -6.383  1.00 10.54           C
ATOM    238  O   GLY    15       2.994  19.372  -5.694  1.00 11.58           O
ATOM    240  N   GLU    16       5.011  18.735  -6.462  1.00 10.14           N
ATOM    241  CA  GLU    16       4.979  17.475  -5.723  1.00 10.90           C
ATOM    243  CB  GLU    16       6.077  16.500  -6.154  1.00 11.37           C
ATOM    246  CG  GLU    16       5.878  15.118  -5.509  1.00 13.41           C
ATOM    249  CD  GLU    16       6.796  14.031  -6.016  1.00 14.39           C
ATOM    250  OE1 GLU    16       7.821  14.327  -6.657  1.00 17.24           O
ATOM    251  OE2 GLU    16       6.498  12.847  -5.728  1.00 19.88           O
ATOM    252  C   GLU    16       5.094  17.732  -4.229  1.00 11.70           C
ATOM    253  O   GLU    16       5.900  18.539  -3.792  1.00 12.51           O
ATOM    255  N   GLN    17       4.285  17.037  -3.431  1.00 13.12           N
ATOM    256  CA  GLN    17       4.419  17.166  -1.988  1.00 13.43           C
ATOM    258  CB  GLN    17       3.109  16.888  -1.274  1.00 17.00           C
ATOM    261  CG  GLN    17       2.086  17.994  -1.457  0.50 13.19           C
ATOM    264  CD  GLN    17       0.701  17.540  -1.069  0.50 12.56           C
ATOM    265  OE1 GLN    17       0.216  16.501  -1.557  0.50 18.97           O
ATOM    266  NE2 GLN    17       0.049  18.301  -0.192  0.50 15.21           N
ATOM    269  C   GLN    17       5.510  16.223  -1.502  1.00  9.97           C
ATOM    270  O   GLN    17       5.923  15.294  -2.196  1.00 11.21           O
ATOM    272  N   LEU    18       5.980  16.475  -0.298  1.00  9.09           N
ATOM    273  CA  LEU    18       7.002  15.642   0.309  1.00  7.79           C
ATOM    275  CB  LEU    18       7.785  16.430   1.341  1.00 10.03           C
ATOM    278  CG  LEU    18       8.464  17.680   0.774  1.00 13.65           C
ATOM    280  CD1 LEU    18       9.327  18.337   1.851  1.00 16.68           C
ATOM    284  CD2 LEU    18       9.285  17.333  -0.465  1.00 14.79           C
ATOM    288  C   LEU    18       6.406  14.423   0.970  1.00  6.95           C
ATOM    289  O   LEU    18       7.112  13.436   1.174  1.00  7.83           O
ATOM    291  N   GLY    19       5.127  14.475   1.336  1.00  6.45           N
ATOM    292  CA  GLY    19       4.529  13.361   2.072  1.00  5.80           C
ATOM    295  C   GLY    19       4.856  13.345   3.551  1.00  5.53           C
ATOM    296  O   GLY    19       5.144  12.296   4.119  1.00  6.57           O
ATOM    298  N   ILE    20       4.790  14.519   4.179  1.00  6.22           N
ATOM    299  CA  ILE    20       5.150  14.697   5.587  1.00  6.82           C
ATOM    301  CB  ILE    20       6.489  15.508   5.743  1.00  8.22           C
ATOM    303  CG1 ILE    20       7.649  14.867   4.981  1.00  9.99           C
ATOM    306  CD1 ILE    20       8.873  15.766   4.839  1.00 13.13           C
ATOM    310  CG2 ILE    20       6.832  15.684   7.223  1.00 12.01           C
ATOM    314  C   ILE    20       4.027  15.459   6.274  1.00  6.99           C
ATOM    315  O   ILE    20       3.566  16.461   5.762  1.00  9.28           O
ATOM    317  N   LYS    21       3.586  14.957   7.413  1.00  7.07           N
ATOM    318  CA  LYS    21       2.690  15.683   8.288  1.00  6.19           C
ATOM    320  CB  LYS    21       1.699  14.734   8.954  1.00  8.22           C
ATOM    323  CG  LYS    21       0.953  13.836   7.994  1.00 15.14           C
ATOM    326  CD  LYS    21      -0.238  13.152   8.664  1.00 20.17           C
ATOM    329  CE  LYS    21      -0.766  11.971   7.851  1.00 17.14           C
ATOM    332  NZ  LYS    21      -1.781  11.169   8.587  1.00 23.82           N
ATOM    336  C   LYS    21       3.510  16.425   9.341  1.00  8.23           C
ATOM    337  O   LYS    21       4.179  15.810  10.163  1.00  8.25           O
ATOM    339  N   LEU    22       3.477  17.754   9.278  1.00  6.53           N
ATOM    340  CA  LEU    22       4.253  18.608  10.175  1.00  7.05           C
ATOM    342  CB  LEU    22       4.977  19.717   9.405  1.00  9.04           C
ATOM    345  CG  LEU    22       6.120  19.350   8.473  1.00 11.98           C
ATOM    347  CD1 LEU    22       6.685  20.618   7.819  1.00 16.38           C
ATOM    351  CD2 LEU    22       7.190  18.609   9.229  1.00 12.08           C
ATOM    355  C   LEU    22       3.340  19.222  11.220  1.00  6.95           C
ATOM    356  O   LEU    22       2.267  19.693  10.894  1.00  8.65           O
ATOM    358  N   VAL    23       3.808  19.255  12.458  1.00  6.35           N
ATOM    359  CA  VAL    23       3.041  19.777  13.571  1.00  6.35           C
ATOM    361  CB  VAL    23       2.419  18.631  14.430  1.00  7.14           C
ATOM    363  CG1 VAL    23       1.471  17.776  13.574  1.00 10.40           C
ATOM    367  CG2 VAL    23       3.466  17.784  15.139  1.00  8.76           C
ATOM    371  C   VAL    23       3.855  20.658  14.495  1.00  6.32           C
ATOM    372  O   VAL    23       5.072  20.554  14.588  1.00  7.02           O
ATOM    374  N   ARG    24       3.147  21.542  15.177  1.00  6.06           N
ATOM    375  CA  ARG    24       3.667  22.214  16.353  1.00  6.42           C
ATOM    377  CB  ARG    24       3.154  23.651  16.436  1.00  7.91           C
ATOM    380  CG  ARG    24       1.670  23.812  16.738  1.00  8.11           C
ATOM    383  CD  ARG    24       1.240  25.229  16.426  1.00 11.78           C
ATOM    386  NE  ARG    24      -0.147  25.442  16.818  1.00 11.84           N
ATOM    388  CZ  ARG    24      -0.924  26.419  16.356  1.00 13.32           C
ATOM    389  NH1 ARG    24      -0.470  27.304  15.491  1.00 13.58           N
ATOM    392  NH2 ARG    24      -2.176  26.505  16.774  1.00 15.33           N
ATOM    395  C   ARG    24       3.277  21.419  17.588  1.00  7.93           C
ATOM    396  O   ARG    24       2.320  20.643  17.569  1.00 10.12           O
ATOM    398  N   ARG    25       4.018  21.637  18.670  1.00  7.87           N
ATOM    399  CA  ARG    25       3.751  20.948  19.936  1.00 10.55           C
ATOM    401  CB  ARG    25       4.972  20.177  20.387  1.00 11.13           C
ATOM    404  CG  ARG    25       5.165  18.961  19.570  1.00 14.31           C
ATOM    407  CD  ARG    25       6.317  18.166  20.053  1.00 14.64           C
ATOM    410  NE  ARG    25       6.432  16.964  19.256  1.00 20.85           N
ATOM    412  CZ  ARG    25       7.389  16.056  19.399  1.00 21.75           C
ATOM    413  NH1 ARG    25       8.324  16.190  20.332  1.00 26.11           N
ATOM    416  NH2 ARG    25       7.410  15.002  18.596  1.00 19.78           N
ATOM    419  C   ARG    25       3.407  21.916  21.018  1.00 12.37           C
ATOM    420  O   ARG    25       3.895  23.032  21.024  1.00 12.41           O
ATOM    422  N   THR    26       2.593  21.449  21.958  1.00 13.46           N
ATOM    423  CA  THR    26       2.064  22.292  23.024  1.00 16.07           C
ATOM    425  CB  THR    26       0.724  21.742  23.541  1.00 15.98           C
ATOM    427  OG1 THR    26       0.901  20.365  23.892  1.00 20.67           O
ATOM    429  CG2 THR    26      -0.319  21.846  22.445  1.00 18.95           C
ATOM    433  C   THR    26       3.003  22.470  24.213  1.00 14.82           C
ATOM    434  O   THR    26       2.719  23.286  25.078  1.00 19.95           O
ATOM    436  N   ASP    27       4.122  21.754  24.245  1.00 16.37           N
ATOM    437  CA  ASP    27       5.000  21.772  25.411  1.00 18.65           C
ATOM    439  CB  ASP    27       4.850  20.464  26.181  1.00 23.44           C
ATOM    442  CG  ASP    27       5.179  19.239  25.334  1.00 31.95           C
ATOM    443  OD1 ASP    27       5.466  19.385  24.118  1.00 29.18           O
ATOM    444  OD2 ASP    27       5.137  18.121  25.887  1.00 45.79           O
ATOM    445  C   ASP    27       6.472  21.999  25.078  1.00 17.69           C
ATOM    446  O   ASP    27       7.320  21.926  25.961  1.00 20.53           O
ATOM    448  N   GLU    28       6.790  22.264  23.815  1.00 15.18           N
ATOM    449  CA  GLU    28       8.160  22.554  23.416  1.00 15.75           C
ATOM    451  CB  GLU    28       8.999  21.268  23.355  1.00 17.87           C
ATOM    454  CG  GLU    28       8.564  20.268  22.295  1.00 15.99           C
ATOM    457  CD  GLU    28       9.431  19.010  22.286  1.00 17.81           C
ATOM    458  OE1 GLU    28      10.659  19.146  22.161  1.00 25.99           O
ATOM    459  OE2 GLU    28       8.881  17.905  22.411  1.00 32.00           O
ATOM    460  C   GLU    28       8.153  23.236  22.054  1.00 13.50           C
ATOM    461  O   GLU    28       7.240  23.042  21.248  1.00 11.92           O
ATOM    463  N   PRO    29       9.178  24.036  21.791  1.00 11.31           N
ATOM    464  CA  PRO    29       9.234  24.766  20.542  1.00  9.48           C
ATOM    466  CB  PRO    29      10.283  25.836  20.815  1.00 13.51           C
ATOM    469  CG  PRO    29      11.215  25.168  21.786  1.00 13.32           C
ATOM    472  CD  PRO    29      10.337  24.320  22.656  1.00 13.95           C
ATOM    475  C   PRO    29       9.672  23.871  19.401  1.00 10.21           C
ATOM    476  O   PRO    29      10.263  22.802  19.630  1.00 10.48           O
ATOM    477  N   GLY    30       9.388  24.307  18.178  1.00  8.28           N
ATOM    478  CA  GLY    30       9.868  23.605  17.007  1.00  8.52           C
ATOM    481  C   GLY    30       8.771  23.103  16.084  1.00  7.13           C
ATOM    482  O   GLY    30       7.579  23.153  16.414  1.00  7.59           O
ATOM    484  N   VAL    31       9.206  22.606  14.930  1.00  6.41           N
ATOM    485  CA  VAL    31       8.341  21.984  13.950  1.00  6.55           C
ATOM    487  CB  VAL    31       8.562  22.633  12.560  1.00  9.09           C
ATOM    489  CG1 VAL    31       7.696  21.998  11.538  1.00 11.32           C
ATOM    493  CG2 VAL    31       8.330  24.131  12.631  1.00 12.01           C
ATOM    497  C   VAL    31       8.734  20.517  13.912  1.00  5.36           C
ATOM    498  O   VAL    31       9.921  20.186  13.789  1.00  6.15           O
ATOM    500  N   PHE    32       7.745  19.636  14.012  1.00  5.13           N
ATOM    501  CA  PHE    32       7.985  18.206  14.179  1.00  6.39           C
ATOM    503  CB  PHE    32       7.554  17.743  15.584  1.00  6.64           C
ATOM    506  CG  PHE    32       8.328  18.414  16.676  1.00  6.56           C
ATOM    507  CD1 PHE    32       9.453  17.844  17.194  1.00  6.87           C
ATOM    509  CE1 PHE    32      10.178  18.486  18.181  1.00  8.33           C
ATOM    511  CZ  PHE    32       9.765  19.681  18.653  1.00  8.49           C
ATOM    513  CE2 PHE    32       8.641  20.269  18.156  1.00  8.36           C
ATOM    515  CD2 PHE    32       7.922  19.638  17.169  1.00  6.58           C
ATOM    517  C   PHE    32       7.260  17.401  13.145  1.00  6.13           C
ATOM    518  O   PHE    32       6.154  17.747  12.715  1.00  8.29           O
ATOM    520  N   ILE    33       7.866  16.282  12.766  1.00  5.72           N
ATOM    521  CA  ILE    33       7.185  15.310  11.921  1.00  5.98           C
ATOM    523  CB  ILE    33       8.192  14.401  11.195  1.00  6.56           C
ATOM    525  CG1 ILE    33       9.084  15.265  10.320  1.00  7.81           C
ATOM    528  CD1 ILE    33      10.065  14.515   9.462  1.00  9.96           C
ATOM    532  CG2 ILE    33       7.493  13.339  10.346  1.00  8.37           C
ATOM    536  C   ILE    33       6.274  14.467  12.801  1.00  7.53           C
ATOM    537  O   ILE    33       6.726  13.828  13.751  1.00  8.02           O
ATOM    539  N   LEU    34       4.981  14.441  12.481  1.00  6.69           N
ATOM    540  CA  LEU    34       4.062  13.561  13.167  1.00  9.23           C
ATOM    542  CB  LEU    34       2.651  14.122  13.100  1.00  9.63           C
ATOM    545  CG  LEU    34       1.589  13.339  13.869  1.00 10.85           C
ATOM    547  CD1 LEU    34       1.808  13.508  15.371  1.00 13.84           C
ATOM    551  CD2 LEU    34       0.192  13.819  13.461  1.00 17.22           C
ATOM    555  C   LEU    34       4.149  12.162  12.550  1.00  8.28           C
ATOM    556  O   LEU    34       4.259  11.163  13.265  1.00  9.20           O
ATOM    558  N   ASP    35       4.066  12.102  11.222  1.00  8.00           N
ATOM    559  CA  ASP    35       4.172  10.849  10.482  1.00  8.97           C
ATOM    561  CB  ASP    35       2.937   9.975  10.701  1.00 15.92           C
ATOM    564  CG  ASP    35       1.688  10.662  10.296  1.00 18.18           C
ATOM    565  OD1 ASP    35       1.592  10.998   9.115  1.00 27.37           O
ATOM    566  OD2 ASP    35       0.793  10.869  11.145  1.00 37.45           O
ATOM    567  C   ASP    35       4.374  11.200   9.011  1.00  7.38           C
ATOM    568  O   ASP    35       4.342  12.361   8.636  1.00  7.85           O
ATOM    570  N   LEU    36       4.617  10.172   8.213  1.00  9.96           N
ATOM    571  CA  LEU    36       4.789  10.277   6.792  1.00  9.02           C
ATOM    573  CB  LEU    36       6.040   9.523   6.346  1.00  9.54           C
ATOM    576  CG  LEU    36       7.348   9.882   7.039  1.00 11.95           C
ATOM    578  CD1 LEU    36       8.469   9.086   6.358  1.00 12.55           C
ATOM    582  CD2 LEU    36       7.634  11.373   6.998  1.00 10.74           C
ATOM    586  C   LEU    36       3.575   9.694   6.086  1.00 10.85           C
ATOM    587  O   LEU    36       2.923   8.753   6.590  1.00 16.71           O
ATOM    589  N   LEU    37       3.267  10.244   4.924  1.00 10.18           N
ATOM    590  CA  LEU    37       2.173   9.751   4.101  1.00  9.91           C
ATOM    592  CB  LEU    37       1.680  10.825   3.129  1.00 11.13           C
ATOM    595  CG  LEU    37       1.134  12.139   3.683  0.50 15.44           C
ATOM    599  CD1 LEU    37       0.485  12.974   2.576  0.50 17.87           C
ATOM    607  CD2 LEU    37       0.158  11.845   4.773  0.50 17.28           C
ATOM    615  C   LEU    37       2.603   8.536   3.287  1.00  9.77           C
ATOM    616  O   LEU    37       3.694   8.497   2.729  1.00  9.19           O
ATOM    618  N   GLU    38       1.707   7.561   3.187  1.00 12.24           N
ATOM    619  CA  GLU    38       1.930   6.353   2.392  1.00 14.34           C
ATOM    621  CB  GLU    38       0.618   5.543   2.312  1.00 18.79           C
ATOM    624  CG  GLU    38       0.785   4.168   1.682  1.00 22.16           C
ATOM    627  CD  GLU    38      -0.488   3.358   1.710  1.00 31.25           C
ATOM    628  OE1 GLU    38      -1.564   3.948   1.927  1.00 23.39           O
ATOM    629  OE2 GLU    38      -0.412   2.128   1.508  1.00 44.28           O
ATOM    630  C   GLU    38       2.369   6.686   0.979  1.00 13.82           C
ATOM    631  O   GLU    38       1.738   7.485   0.314  1.00 14.65           O
ATOM    633  N   GLY    39       3.467   6.086   0.533  1.00 11.43           N
ATOM    634  CA  GLY    39       3.898   6.213  -0.864  1.00 14.98           C
ATOM    637  C   GLY    39       4.490   7.564  -1.252  1.00 12.08           C
ATOM    638  O   GLY    39       4.870   7.772  -2.408  1.00 13.34           O
ATOM    640  N   GLY    40       4.612   8.482  -0.299  1.00  9.86           N
ATOM    641  CA  GLY    40       5.146   9.787  -0.608  1.00  9.55           C
ATOM    644  C   GLY    40       6.653   9.766  -0.727  1.00  7.46           C
ATOM    645  O   GLY    40       7.303   8.764  -0.407  1.00  7.40           O
ATOM    647  N   LEU    41       7.222  10.891  -1.146  1.00  7.62           N
ATOM    648  CA  LEU    41       8.672  10.979  -1.316  1.00  8.00           C
ATOM    650  CB  LEU    41       9.091  12.399  -1.714  1.00 10.73           C
ATOM    653  CG  LEU    41       8.977  12.843  -3.153  1.00 14.71           C
ATOM    655  CD1 LEU    41       9.439  14.280  -3.194  1.00 13.54           C
ATOM    659  CD2 LEU    41       9.823  11.953  -4.047  1.00 13.69           C
ATOM    663  C   LEU    41       9.398  10.637  -0.047  1.00  6.30           C
ATOM    664  O   LEU    41      10.426   9.958  -0.078  1.00  6.05           O
ATOM    666  N   ALA    42       8.923  11.169   1.076  1.00  6.10           N
ATOM    667  CA  ALA    42       9.617  10.951   2.343  1.00  5.50           C
ATOM    669  CB  ALA    42       9.039  11.836   3.429  1.00  6.62           C
ATOM    673  C   ALA    42       9.603   9.484   2.750  1.00  6.00           C
ATOM    674  O   ALA    42      10.614   8.938   3.177  1.00  5.85           O
ATOM    676  N   ALA    43       8.451   8.841   2.592  1.00  5.17           N
ATOM    677  CA  ALA    43       8.324   7.429   2.900  1.00  5.95           C
ATOM    679  CB  ALA    43       6.877   6.965   2.811  1.00  8.50           C
ATOM    683  C   ALA    43       9.207   6.590   1.979  1.00  6.68           C
ATOM    684  O   ALA    43       9.846   5.647   2.421  1.00  7.67           O
ATOM    686  N   GLN    44       9.239   6.927   0.693  1.00  6.75           N
ATOM    687  CA  GLN    44      10.080   6.208  -0.242  1.00  5.96           C
ATOM    689  CB  GLN    44       9.884   6.725  -1.657  1.00  6.18           C
ATOM    692  CG  GLN    44       8.528   6.335  -2.259  1.00  8.92           C
ATOM    695  CD  GLN    44       8.364   6.902  -3.633  1.00 11.62           C
ATOM    696  OE1 GLN    44       9.187   6.663  -4.520  1.00 14.68           O
ATOM    697  NE2 GLN    44       7.314   7.675  -3.818  1.00 14.96           N
ATOM    700  C   GLN    44      11.545   6.330   0.121  1.00  5.84           C
ATOM    701  O   GLN    44      12.322   5.375  -0.015  1.00  6.68           O
ATOM    703  N   ASP    45      11.944   7.519   0.550  1.00  5.19           N
ATOM    704  CA  ASP    45      13.315   7.747   0.941  1.00  5.40           C
ATOM    706  CB  ASP    45      13.577   9.248   1.150  1.00  5.38           C
ATOM    709  CG  ASP    45      14.928   9.517   1.707  1.00  7.25           C
ATOM    710  OD1 ASP    45      15.893   9.620   0.899  1.00  7.92           O
ATOM    711  OD2 ASP    45      15.039   9.605   2.962  1.00  7.45           O
ATOM    712  C   ASP    45      13.687   6.947   2.180  1.00  6.21           C
ATOM    713  O   ASP    45      14.794   6.435   2.255  1.00  7.92           O
ATOM    715  N   GLY    46      12.777   6.884   3.146  1.00  6.05           N
ATOM    716  CA  GLY    46      12.890   6.010   4.303  1.00  8.24           C
ATOM    719  C   GLY    46      13.464   6.635   5.554  1.00  8.42           C
ATOM    720  O   GLY    46      13.208   6.144   6.652  1.00 12.24           O
ATOM    722  N   ARG    47      14.251   7.704   5.407  1.00  6.54           N
ATOM    723  CA  ARG    47      15.018   8.218   6.545  1.00  8.04           C
ATOM    725  CB  ARG    47      16.169   9.085   6.066  1.00  7.42           C
ATOM    728  CG  ARG    47      17.222   8.284   5.355  1.00  9.19           C
ATOM    731  CD  ARG    47      18.320   9.143   4.763  1.00  9.89           C
ATOM    734  NE  ARG    47      17.874   9.848   3.578  1.00  8.34           N
ATOM    736  CZ  ARG    47      18.629  10.670   2.865  1.00  7.37           C
ATOM    737  NH1 ARG    47      19.872  10.932   3.235  1.00 10.70           N
ATOM    740  NH2 ARG    47      18.144  11.253   1.797  1.00  8.55           N
ATOM    743  C   ARG    47      14.197   8.973   7.569  1.00  8.63           C
ATOM    744  O   ARG    47      14.369   8.776   8.766  1.00 13.68           O
ATOM    746  N   LEU    48      13.341   9.866   7.116  1.00  7.63           N
ATOM    747  CA  LEU    48      12.584  10.684   8.035  1.00  7.29           C
ATOM    749  CB  LEU    48      11.816  11.766   7.291  1.00  7.30           C
ATOM    752  CG  LEU    48      12.687  12.823   6.589  1.00  8.01           C
ATOM    754  CD1 LEU    48      11.836  13.663   5.678  1.00 10.86           C
ATOM    758  CD2 LEU    48      13.434  13.710   7.580  1.00  9.67           C
ATOM    762  C   LEU    48      11.646   9.839   8.871  1.00  9.21           C
ATOM    763  O   LEU    48      11.231   8.751   8.454  1.00 11.25           O
ATOM    765  N   SER    49      11.325  10.343  10.062  1.00  7.94           N
ATOM    766  CA  SER    49      10.576   9.586  11.039  1.00  8.89           C
ATOM    768  CB  SER    49      11.569   8.839  11.926  1.00 10.93           C
ATOM    771  OG  SER    49      10.887   7.933  12.776  1.00 14.79           O
ATOM    773  C   SER    49       9.708  10.456  11.922  1.00  7.68           C
ATOM    774  O   SER    49      10.045  11.579  12.207  1.00  7.74           O
ATOM    776  N   SER    50       8.643   9.859  12.435  1.00  7.02           N
ATOM    777  CA  SER    50       7.847  10.451  13.491  1.00  7.93           C
ATOM    779  CB  SER    50       6.847   9.400  13.997  0.50  7.51           C
ATOM    785  OG  SER    50       5.958   9.906  14.963  0.50  6.38           O
ATOM    789  C   SER    50       8.764  10.917  14.610  1.00  6.25           C
ATOM    790  O   SER    50       9.705  10.210  14.994  1.00  8.15           O
ATOM    792  N   ASN    51       8.476  12.127  15.105  1.00  5.84           N
ATOM    793  CA  ASN    51       9.180  12.780  16.210  1.00  6.94           C
ATOM    795  CB  ASN    51       9.345  11.845  17.409  1.00  8.16           C
ATOM    798  CG  ASN    51       8.018  11.464  17.982  1.00  9.85           C
ATOM    799  OD1 ASN    51       7.313  12.311  18.530  1.00 12.30           O
ATOM    800  ND2 ASN    51       7.642  10.213  17.832  1.00  9.84           N
ATOM    803  C   ASN    51      10.454  13.506  15.833  1.00  6.49           C
ATOM    804  O   ASN    51      11.045  14.165  16.682  1.00  8.19           O
ATOM    806  N   ASP    52      10.845  13.450  14.563  1.00  6.15           N
ATOM    807  CA  ASP    52      11.970  14.223  14.106  1.00  5.99           C
ATOM    809  CB  ASP    52      12.290  13.888  12.648  1.00  6.83           C
ATOM    812  CG  ASP    52      13.037  12.585  12.472  1.00  8.10           C
ATOM    813  OD1 ASP    52      13.484  11.982  13.468  1.00  8.15           O
ATOM    814  OD2 ASP    52      13.210  12.189  11.298  1.00  8.89           O
ATOM    815  C   ASP    52      11.601  15.697  14.206  1.00  6.29           C
ATOM    816  O   ASP    52      10.491  16.107  13.839  1.00  6.95           O
ATOM    818  N   ARG    53      12.550  16.500  14.650  1.00  5.25           N
ATOM    819  CA  ARG    53      12.408  17.938  14.683  1.00  4.99           C
ATOM    821  CB  ARG    53      13.041  18.529  15.935  1.00  6.14           C
ATOM    824  CG  ARG    53      12.863  20.012  16.008  1.00  7.50           C
ATOM    827  CD  ARG    53      13.501  20.585  17.212  1.00  8.27           C
ATOM    830  NE  ARG    53      13.318  22.031  17.331  1.00  8.88           N
ATOM    832  CZ  ARG    53      13.737  22.686  18.396  1.00 11.23           C
ATOM    833  NH1 ARG    53      14.346  22.016  19.366  1.00 16.53           N
ATOM    836  NH2 ARG    53      13.543  23.977  18.514  1.00 13.37           N
ATOM    839  C   ARG    53      13.100  18.513  13.447  1.00  4.96           C
ATOM    840  O   ARG    53      14.246  18.205  13.173  1.00  6.86           O
ATOM    842  N   VAL    54      12.379  19.326  12.678  1.00  5.73           N
ATOM    843  CA  VAL    54      12.946  19.961  11.493  1.00  6.02           C
ATOM    845  CB  VAL    54      11.865  20.242  10.411  1.00  6.77           C
ATOM    847  CG1 VAL    54      12.525  20.854   9.177  1.00  7.75           C
ATOM    851  CG2 VAL    54      11.100  18.960  10.023  1.00  9.25           C
ATOM    855  C   VAL    54      13.643  21.257  11.915  1.00  5.20           C
ATOM    856  O   VAL    54      12.992  22.215  12.306  1.00  6.89           O
ATOM    858  N   LEU    55      14.971  21.250  11.874  1.00  4.90           N
ATOM    859  CA  LEU    55      15.774  22.399  12.259  1.00  5.97           C
ATOM    861  CB  LEU    55      17.164  21.952  12.706  1.00  6.50           C
ATOM    864  CG  LEU    55      17.211  21.067  13.939  1.00  7.90           C
ATOM    866  CD1 LEU    55      18.665  20.650  14.173  1.00 10.54           C
ATOM    870  CD2 LEU    55      16.639  21.761  15.161  1.00 12.65           C
ATOM    874  C   LEU    55      15.917  23.418  11.129  1.00  5.73           C
ATOM    875  O   LEU    55      16.055  24.599  11.409  1.00  6.02           O
ATOM    877  N   ALA    56      15.899  22.967   9.877  1.00  4.96           N
ATOM    878  CA  ALA    56      16.078  23.839   8.738  1.00  5.86           C
ATOM    880  CB  ALA    56      17.559  24.243   8.565  1.00  7.39           C
ATOM    884  C   ALA    56      15.613  23.097   7.501  1.00  4.94           C
ATOM    885  O   ALA    56      15.630  21.863   7.462  1.00  5.30           O
ATOM    887  N   ILE    57      15.205  23.857   6.494  1.00  4.78           N
ATOM    888  CA  ILE    57      14.911  23.339   5.159  1.00  5.74           C
ATOM    890  CB  ILE    57      13.401  23.285   4.848  1.00  7.45           C
ATOM    892  CG1 ILE    57      12.699  22.291   5.772  1.00  8.31           C
ATOM    895  CD1 ILE    57      11.186  22.199   5.602  1.00 11.74           C
ATOM    899  CG2 ILE    57      13.155  22.833   3.436  1.00  7.99           C
ATOM    903  C   ILE    57      15.615  24.249   4.162  1.00  5.48           C
ATOM    904  O   ILE    57      15.437  25.465   4.181  1.00  5.95           O
ATOM    906  N   ASN    58      16.488  23.659   3.347  1.00  5.37           N
ATOM    907  CA  ASN    58      17.202  24.406   2.311  1.00  5.56           C
ATOM    909  CB  ASN    58      16.242  24.820   1.190  1.00  6.55           C
ATOM    912  CG  ASN    58      15.844  23.658   0.321  1.00  5.43           C
ATOM    913  OD1 ASN    58      16.462  22.598   0.393  1.00  7.68           O
ATOM    914  ND2 ASN    58      14.804  23.840  -0.499  1.00  9.08           N
ATOM    917  C   ASN    58      17.968  25.593   2.877  1.00  5.61           C
ATOM    918  O   ASN    58      18.065  26.640   2.259  1.00  6.22           O
ATOM    920  N   GLY    59      18.531  25.413   4.066  1.00  7.13           N
ATOM    921  CA  GLY    59      19.286  26.446   4.761  1.00  6.57           C
ATOM    924  C   GLY    59      18.476  27.481   5.496  1.00  6.87           C
ATOM    925  O   GLY    59      19.058  28.366   6.131  1.00 10.12           O
ATOM    927  N   HIS    60      17.151  27.403   5.379  1.00  5.84           N
ATOM    928  CA  HIS    60      16.246  28.308   6.057  1.00  6.38           C
ATOM    930  CB  HIS    60      14.923  28.422   5.291  1.00  7.41           C
ATOM    933  CG  HIS    60      15.059  28.970   3.905  1.00  9.29           C
ATOM    934  ND1 HIS    60      14.673  30.244   3.565  1.00 15.26           N
ATOM    936  CE1 HIS    60      14.916  30.455   2.284  1.00 15.78           C
ATOM    938  NE2 HIS    60      15.439  29.353   1.773  1.00 10.90           N
ATOM    940  CD2 HIS    60      15.508  28.403   2.762  1.00 11.08           C
ATOM    942  C   HIS    60      15.969  27.768   7.456  1.00  6.08           C
ATOM    943  O   HIS    60      15.431  26.677   7.615  1.00  7.61           O
ATOM    945  N   ASP    61      16.284  28.556   8.478  1.00  7.12           N
ATOM    946  CA  ASP    61      16.130  28.131   9.868  1.00  7.26           C
ATOM    948  CB  ASP    61      16.723  29.213  10.787  1.00  9.51           C
ATOM    951  CG  ASP    61      16.625  28.881  12.261  1.00 11.69           C
ATOM    952  OD1 ASP    61      16.644  27.691  12.621  1.00 11.87           O
ATOM    953  OD2 ASP    61      16.534  29.843  13.051  1.00 19.75           O
ATOM    954  C   ASP    61      14.659  27.919  10.218  1.00  7.26           C
ATOM    955  O   ASP    61      13.821  28.778   9.948  1.00  9.44           O
ATOM    957  N   LEU    62      14.365  26.784  10.844  1.00  6.81           N
ATOM    958  CA  LEU    62      13.042  26.461  11.358  1.00  7.03           C
ATOM    960  CB  LEU    62      12.435  25.351  10.511  1.00  8.04           C
ATOM    963  CG  LEU    62      11.842  25.803   9.173  1.00  9.58           C
ATOM    965  CD1 LEU    62      11.547  24.580   8.318  1.00 14.23           C
ATOM    969  CD2 LEU    62      10.558  26.562   9.377  1.00 11.51           C
ATOM    973  C   LEU    62      13.065  26.067  12.836  1.00  6.56           C
ATOM    974  O   LEU    62      12.072  25.571  13.367  1.00  7.03           O
ATOM    976  N   LYS    63      14.176  26.298  13.525  1.00  6.57           N
ATOM    977  CA  LYS    63      14.275  25.871  14.918  1.00  7.54           C
ATOM    979  CB  LYS    63      15.603  26.320  15.527  1.00  9.50           C
ATOM    982  CG  LYS    63      15.877  25.737  16.905  1.00 14.00           C
ATOM    985  CD  LYS    63      17.286  25.997  17.394  1.00 18.24           C
ATOM    988  CE  LYS    63      17.444  25.472  18.815  1.00 23.48           C
ATOM    992  C   LYS    63      13.103  26.393  15.750  1.00  6.86           C
ATOM    993  O   LYS    63      12.524  25.652  16.546  1.00  7.88           O
ATOM    995  N   TYR    64      12.751  27.663  15.566  1.00  7.48           N
ATOM    996  CA  TYR    64      11.624  28.256  16.273  1.00  8.17           C
ATOM    998  CB  TYR    64      12.093  29.470  17.089  1.00 11.09           C
ATOM   1001  CG  TYR    64      13.152  29.097  18.092  1.00 11.97           C
ATOM   1002  CD1 TYR    64      12.812  28.444  19.262  1.00 14.21           C
ATOM   1004  CE1 TYR    64      13.775  28.061  20.178  1.00 17.55           C
ATOM   1006  CZ  TYR    64      15.099  28.298  19.905  1.00 20.25           C
ATOM   1007  OH  TYR    64      16.053  27.918  20.816  1.00 26.55           O
ATOM   1009  CE2 TYR    64      15.471  28.924  18.736  1.00 20.96           C
ATOM   1011  CD2 TYR    64      14.501  29.305  17.825  1.00 15.02           C
ATOM   1013  C   TYR    64      10.497  28.626  15.316  1.00  8.44           C
ATOM   1014  O   TYR    64       9.719  29.543  15.565  1.00 11.33           O
ATOM   1016  N   GLY    65      10.391  27.868  14.226  1.00  7.80           N
ATOM   1017  CA  GLY    65       9.456  28.141  13.163  1.00  8.27           C
ATOM   1020  C   GLY    65       8.106  27.507  13.394  1.00  7.91           C
ATOM   1021  O   GLY    65       7.804  27.015  14.472  1.00  7.59           O
ATOM   1023  N   THR    66       7.300  27.515  12.346  1.00  9.49           N
ATOM   1024  CA  THR    66       5.936  27.018  12.364  1.00  9.40           C
ATOM   1026  CB  THR    66       4.949  28.188  12.187  1.00  9.92           C
ATOM   1028  OG1 THR    66       5.184  28.803  10.915  1.00 12.44           O
ATOM   1030  CG2 THR    66       5.102  29.213  13.287  1.00 13.80           C
ATOM   1034  C   THR    66       5.689  26.091  11.183  1.00  9.04           C
ATOM   1035  O   THR    66       6.401  26.156  10.182  1.00  8.82           O
ATOM   1037  N   PRO    67       4.658  25.244  11.275  1.00  9.53           N
ATOM   1038  CA  PRO    67       4.247  24.481  10.100  1.00  8.74           C
ATOM   1040  CB  PRO    67       2.977  23.778  10.578  1.00 10.07           C
ATOM   1043  CG  PRO    67       3.200  23.593  12.032  1.00 11.46           C
ATOM   1046  CD  PRO    67       3.906  24.839  12.476  1.00 11.37           C
ATOM   1049  C   PRO    67       3.988  25.364   8.877  1.00  9.67           C
ATOM   1050  O   PRO    67       4.337  24.995   7.759  1.00 10.04           O
ATOM   1051  N   GLU    68       3.394  26.533   9.096  1.00  9.78           N
ATOM   1052  CA  GLU    68       3.116  27.444   8.001  1.00 11.62           C
ATOM   1054  CB  GLU    68       2.371  28.680   8.504  1.00 15.78           C
ATOM   1057  CG  GLU    68       0.939  28.454   8.841  1.00 22.69           C
ATOM   1060  CD  GLU    68       0.730  27.530  10.025  1.00 38.18           C
ATOM   1061  OE1 GLU    68       1.509  27.567  11.019  1.00 30.10           O
ATOM   1062  OE2 GLU    68      -0.241  26.753   9.956  1.00 46.84           O
ATOM   1063  C   GLU    68       4.362  27.913   7.288  1.00 10.80           C
ATOM   1064  O   GLU    68       4.391  27.980   6.050  1.00 13.59           O
ATOM   1066  N   LEU    69       5.377  28.283   8.060  1.00 10.10           N
ATOM   1067  CA  LEU    69       6.635  28.728   7.469  1.00 10.16           C
ATOM   1069  CB  LEU    69       7.557  29.283   8.549  1.00 13.39           C
ATOM   1072  CG  LEU    69       8.913  29.806   8.085  1.00 13.91           C
ATOM   1074  CD1 LEU    69       8.763  30.875   7.002  1.00 16.82           C
ATOM   1078  CD2 LEU    69       9.710  30.307   9.286  1.00 16.06           C
ATOM   1082  C   LEU    69       7.287  27.576   6.700  1.00  9.38           C
ATOM   1083  O   LEU    69       7.778  27.764   5.595  1.00 10.31           O
ATOM   1085  N   ALA    70       7.282  26.382   7.275  1.00  9.22           N
ATOM   1086  CA  ALA    70       7.801  25.207   6.554  1.00  8.31           C
ATOM   1088  CB  ALA    70       7.687  23.984   7.411  1.00  9.24           C
ATOM   1092  C   ALA    70       7.056  24.999   5.230  1.00  8.63           C
ATOM   1093  O   ALA    70       7.679  24.743   4.207  1.00  9.95           O
ATOM   1095  N   ALA    71       5.729  25.125   5.262  1.00  9.56           N
ATOM   1096  CA  ALA    71       4.901  24.975   4.076  1.00 10.82           C
ATOM   1098  CB  ALA    71       3.435  25.119   4.431  1.00 12.69           C
ATOM   1102  C   ALA    71       5.282  25.984   3.003  1.00 10.30           C
ATOM   1103  O   ALA    71       5.370  25.639   1.841  1.00 11.75           O
ATOM   1105  N   GLN    72       5.506  27.233   3.406  1.00 11.39           N
ATOM   1106  CA  GLN    72       5.878  28.302   2.476  1.00 12.45           C
ATOM   1108  CB  GLN    72       5.975  29.639   3.207  1.00 15.12           C
ATOM   1111  CG  GLN    72       4.633  30.242   3.569  1.00 26.64           C
ATOM   1114  CD  GLN    72       4.759  31.571   4.300  1.00 41.76           C
ATOM   1115  OE1 GLN    72       5.777  31.860   4.936  1.00 44.64           O
ATOM   1116  NE2 GLN    72       3.713  32.385   4.216  1.00 48.57           N
ATOM   1119  C   GLN    72       7.207  27.962   1.806  1.00 12.12           C
ATOM   1120  O   GLN    72       7.353  28.082   0.581  1.00 12.87           O
ATOM   1122  N   ILE    73       8.179  27.518   2.597  1.00 10.78           N
ATOM   1123  CA  ILE    73       9.494  27.153   2.059  1.00 11.01           C
ATOM   1125  CB  ILE    73      10.495  26.822   3.185  1.00 10.04           C
ATOM   1127  CG1 ILE    73      10.756  28.065   4.042  1.00 12.22           C
ATOM   1130  CD1 ILE    73      11.281  27.733   5.431  1.00 13.45           C
ATOM   1134  CG2 ILE    73      11.806  26.269   2.626  1.00 11.05           C
ATOM   1138  C   ILE    73       9.399  25.976   1.090  1.00  9.44           C
ATOM   1139  O   ILE    73       9.934  26.028  -0.020  1.00 11.21           O
ATOM   1141  N   ILE    74       8.672  24.931   1.481  1.00  9.74           N
ATOM   1142  CA  ILE    74       8.569  23.728   0.661  1.00  9.95           C
ATOM   1144  CB  ILE    74       7.907  22.592   1.429  1.00 10.93           C
ATOM   1146  CG1 ILE    74       8.843  22.115   2.522  1.00 10.18           C
ATOM   1149  CD1 ILE    74       8.119  21.328   3.647  1.00 13.36           C
ATOM   1153  CG2 ILE    74       7.582  21.426   0.509  1.00 12.72           C
ATOM   1157  C   ILE    74       7.825  24.010  -0.644  1.00 11.91           C
ATOM   1158  O   ILE    74       8.246  23.557  -1.726  1.00 13.89           O
ATOM   1160  N   GLN    75       6.741  24.780  -0.564  1.00 12.93           N
ATOM   1161  CA  GLN    75       5.961  25.074  -1.768  1.00 13.68           C
ATOM   1163  CB  GLN    75       4.657  25.750  -1.402  1.00 16.16           C
ATOM   1166  CG  GLN    75       3.669  24.773  -0.769  1.00 18.38           C
ATOM   1169  CD  GLN    75       2.441  25.471  -0.235  1.00 26.27           C
ATOM   1170  OE1 GLN    75       2.313  26.691  -0.338  1.00 34.21           O
ATOM   1171  NE2 GLN    75       1.530  24.705   0.337  1.00 29.94           N
ATOM   1174  C   GLN    75       6.746  25.917  -2.773  1.00 13.60           C
ATOM   1175  O   GLN    75       6.574  25.734  -3.965  1.00 17.87           O
ATOM   1177  N   ALA    76       7.609  26.812  -2.296  1.00 10.43           N
ATOM   1178  CA  ALA    76       8.437  27.639  -3.166  1.00 11.32           C
ATOM   1180  CB  ALA    76       8.707  28.987  -2.509  1.00 13.58           C
ATOM   1184  C   ALA    76       9.748  26.982  -3.584  1.00 11.10           C
ATOM   1185  O   ALA    76      10.468  27.561  -4.377  1.00 13.90           O
ATOM   1187  N   SER    77      10.065  25.793  -3.059  1.00  9.06           N
ATOM   1188  CA  SER    77      11.372  25.165  -3.256  1.00  9.49           C
ATOM   1190  CB  SER    77      11.469  23.906  -2.429  0.50  9.76           C
ATOM   1196  OG  SER    77      10.601  22.959  -2.991  0.50 13.23           O
ATOM   1200  C   SER    77      11.592  24.786  -4.692  1.00 10.15           C
ATOM   1201  O   SER    77      10.639  24.562  -5.437  1.00 14.75           O
ATOM   1203  N   GLY    78      12.861  24.707  -5.079  1.00  7.78           N
ATOM   1204  CA  GLY    78      13.221  24.044  -6.296  1.00  9.54           C
ATOM   1207  C   GLY    78      13.129  22.543  -6.113  1.00  8.94           C
ATOM   1208  O   GLY    78      12.615  22.045  -5.120  1.00 10.77           O
ATOM   1210  N   GLU    79      13.674  21.791  -7.049  1.00  9.79           N
ATOM   1211  CA  GLU    79      13.501  20.344  -7.016  1.00  9.89           C
ATOM   1213  CB  GLU    79      13.953  19.685  -8.320  1.00 16.21           C
ATOM   1216  CG  GLU    79      15.398  19.861  -8.639  1.00 16.42           C
ATOM   1219  CD  GLU    79      16.323  18.856  -7.970  1.00 22.12           C
ATOM   1220  OE1 GLU    79      15.852  17.773  -7.589  1.00 22.98           O
ATOM   1221  OE2 GLU    79      17.531  19.158  -7.834  1.00 30.49           O
ATOM   1222  C   GLU    79      14.129  19.674  -5.794  1.00  9.48           C
ATOM   1223  O   GLU    79      13.577  18.718  -5.290  1.00 11.29           O
ATOM   1225  N   ARG    80      15.251  20.178  -5.304  1.00  8.87           N
ATOM   1226  CA  ARG    80      15.911  19.591  -4.148  1.00  8.68           C
ATOM   1228  CB  ARG    80      17.430  19.716  -4.256  1.00 11.07           C
ATOM   1231  CG  ARG    80      18.176  19.033  -3.108  1.00 13.32           C
ATOM   1234  CD  ARG    80      19.682  19.112  -3.324  1.00 24.79           C
ATOM   1237  NE  ARG    80      20.448  18.479  -2.245  1.00 27.84           N
ATOM   1239  CZ  ARG    80      20.993  19.118  -1.207  1.00 36.19           C
ATOM   1240  NH1 ARG    80      20.863  20.433  -1.054  1.00 33.72           N
ATOM   1243  NH2 ARG    80      21.671  18.426  -0.295  1.00 41.41           N
ATOM   1246  C   ARG    80      15.411  20.246  -2.878  1.00  8.11           C
ATOM   1247  O   ARG    80      15.445  21.473  -2.722  1.00  9.37           O
ATOM   1249  N   VAL    81      14.959  19.401  -1.963  1.00  6.86           N
ATOM   1250  CA  VAL    81      14.513  19.835  -0.643  1.00  6.31           C
ATOM   1252  CB  VAL    81      13.028  19.562  -0.396  1.00  7.85           C
ATOM   1254  CG1 VAL    81      12.610  20.149   0.932  1.00  9.26           C
ATOM   1258  CG2 VAL    81      12.177  20.137  -1.532  1.00 10.85           C
ATOM   1262  C   VAL    81      15.382  19.116   0.383  1.00  6.33           C
ATOM   1263  O   VAL    81      15.236  17.909   0.611  1.00  8.05           O
ATOM   1265  N   ASN    82      16.280  19.870   0.997  1.00  5.57           N
ATOM   1266  CA  ASN    82      17.158  19.331   2.032  1.00  5.84           C
ATOM   1268  CB  ASN    82      18.579  19.900   1.896  1.00  8.13           C
ATOM   1271  CG  ASN    82      19.516  19.209   2.822  1.00 12.01           C
ATOM   1272  OD1 ASN    82      19.750  18.001   2.675  1.00 16.43           O
ATOM   1273  ND2 ASN    82      19.968  19.910   3.861  1.00 16.19           N
ATOM   1276  C   ASN    82      16.603  19.693   3.400  1.00  5.43           C
ATOM   1277  O   ASN    82      16.397  20.860   3.676  1.00  9.69           O
ATOM   1279  N   LEU    83      16.354  18.700   4.242  1.00  5.52           N
ATOM   1280  CA  LEU    83      15.875  18.917   5.599  1.00  5.39           C
ATOM   1282  CB  LEU    83      14.653  18.038   5.889  1.00  6.63           C
ATOM   1285  CG  LEU    83      13.448  18.253   4.967  1.00  7.62           C
ATOM   1287  CD1 LEU    83      13.437  17.282   3.780  1.00 10.23           C
ATOM   1291  CD2 LEU    83      12.167  18.112   5.799  1.00 11.84           C
ATOM   1295  C   LEU    83      16.980  18.565   6.561  1.00  5.82           C
ATOM   1296  O   LEU    83      17.545  17.489   6.480  1.00  8.00           O
ATOM   1298  N   THR    84      17.279  19.480   7.477  1.00  5.80           N
ATOM   1299  CA  THR    84      18.161  19.195   8.594  1.00  5.83           C
ATOM   1301  CB  THR    84      19.072  20.384   8.934  1.00  7.22           C
ATOM   1303  OG1 THR    84      19.806  20.767   7.757  1.00 11.03           O
ATOM   1305  CG2 THR    84      20.050  20.060  10.048  1.00  9.42           C
ATOM   1309  C   THR    84      17.285  18.858   9.778  1.00  5.81           C
ATOM   1310  O   THR    84      16.420  19.644  10.181  1.00  6.34           O
ATOM   1312  N   ILE    85      17.508  17.664  10.320  1.00  4.76           N
ATOM   1313  CA  ILE    85      16.683  17.063  11.339  1.00  6.86           C
ATOM   1315  CB  ILE    85      16.266  15.653  10.761  1.00 14.19           C
ATOM   1317  CG1 ILE    85      15.517  15.810   9.448  1.00 13.77           C
ATOM   1320  CD1 ILE    85      14.351  16.566   9.612  1.00 10.45           C
ATOM   1324  CG2 ILE    85      15.551  14.836  11.763  1.00 17.42           C
ATOM   1328  C   ILE    85      17.431  16.795  12.632  1.00  6.23           C
ATOM   1329  O   ILE    85      18.594  16.410  12.577  1.00  6.95           O
ATOM   1331  N   ALA    86      16.739  16.976  13.757  1.00  6.25           N
ATOM   1332  CA  ALA    86      17.190  16.463  15.050  1.00  6.59           C
ATOM   1334  CB  ALA    86      17.200  17.563  16.105  1.00  8.55           C
ATOM   1338  C   ALA    86      16.266  15.319  15.464  1.00  6.81           C
ATOM   1339  O   ALA    86      15.051  15.490  15.528  1.00  8.22           O
ATOM   1341  N   ARG    87      16.864  14.166  15.753  1.00  7.51           N
ATOM   1342  CA  ARG    87      16.141  12.966  16.135  1.00  8.14           C
ATOM   1344  CB  ARG    87      16.548  11.809  15.238  1.00  8.42           C
ATOM   1347  CG  ARG    87      15.882  10.496  15.579  1.00  9.40           C
ATOM   1350  CD  ARG    87      16.088   9.500  14.466  1.00 10.06           C
ATOM   1353  NE  ARG    87      15.444   9.990  13.256  1.00  8.90           N
ATOM   1355  CZ  ARG    87      15.734   9.569  12.031  1.00 11.27           C
ATOM   1356  NH1 ARG    87      16.620   8.604  11.820  1.00 12.83           N
ATOM   1359  NH2 ARG    87      15.145  10.122  11.007  1.00 11.16           N
ATOM   1362  C   ARG    87      16.500  12.689  17.593  1.00  7.99           C
ATOM   1363  O   ARG    87      17.564  12.158  17.886  1.00  8.23           O
ATOM   1365  N   PRO    88      15.638  13.098  18.531  1.00 10.73           N
ATOM   1366  CA  PRO    88      16.030  12.918  19.925  1.00 10.69           C
ATOM   1368  CB  PRO    88      15.102  13.869  20.685  1.00 14.27           C
ATOM   1371  CG  PRO    88      14.609  14.838  19.670  1.00 18.94           C
ATOM   1374  CD  PRO    88      14.509  14.034  18.416  1.00 14.24           C
ATOM   1377  C   PRO    88      15.854  11.499  20.425  1.00 10.66           C
ATOM   1378  O   PRO    88      15.081  10.700  19.871  1.00 14.66           O
ATOM   1379  N   GLY    89      16.590  11.193  21.476  1.00 10.65           N
ATOM   1380  CA  GLY    89      16.292  10.059  22.300  1.00 14.39           C
ATOM   1383  C   GLY    89      16.821   8.730  21.823  1.00 12.94           C
ATOM   1384  O   GLY    89      17.450   8.599  20.778  1.00 16.65           O
ATOM   1386  N   LYS    90      16.595   7.725  22.648  1.00 13.32           N
ATOM   1387  CA  LYS    90      17.063   6.385  22.376  1.00 11.77           C
ATOM   1389  CB  LYS    90      17.224   5.631  23.701  1.00 13.46           C
ATOM   1392  CG  LYS    90      18.208   6.274  24.672  1.00 15.32           C
ATOM   1395  CD  LYS    90      18.301   5.467  25.954  1.00 14.96           C
ATOM   1398  CE  LYS    90      19.261   6.115  26.964  1.00 15.66           C
ATOM   1401  NZ  LYS    90      19.404   5.284  28.187  1.00 22.41           N
ATOM   1405  C   LYS    90      16.058   5.637  21.500  1.00 10.89           C
ATOM   1406  O   LYS    90      14.853   5.785  21.671  1.00 14.13           O
ATOM   1408  N   PRO    91      16.552   4.802  20.591  1.00  9.91           N
ATOM   1409  CA  PRO    91      15.651   4.023  19.745  1.00 12.24           C
ATOM   1411  CB  PRO    91      16.556   3.534  18.608  1.00 15.51           C
ATOM   1414  CG  PRO    91      17.917   3.641  19.116  1.00 15.26           C
ATOM   1417  CD  PRO    91      17.936   4.756  20.099  1.00 12.95           C
ATOM   1420  C   PRO    91      15.025   2.841  20.462  1.00  9.07           C
ATOM   1421  O   PRO    91      14.020   2.324  20.007  1.00  9.13           O
ATOM   1422  N   GLU    92      15.643   2.418  21.560  1.00  7.37           N
ATOM   1423  CA  GLU    92      15.206   1.255  22.324  1.00  7.95           C
ATOM   1425  CB  GLU    92      16.009  -0.003  21.975  1.00 10.27           C
ATOM   1428  CG  GLU    92      15.660  -1.161  22.901  1.00 14.89           C
ATOM   1431  CD  GLU    92      16.260  -2.480  22.466  1.00 18.63           C
ATOM   1432  OE1 GLU    92      17.066  -2.497  21.502  1.00 29.25           O
ATOM   1433  OE2 GLU    92      15.921  -3.515  23.099  1.00 20.57           O
ATOM   1434  C   GLU    92      15.405   1.564  23.788  1.00  8.05           C
ATOM   1435  O   GLU    92      16.476   2.010  24.200  1.00  9.27           O
ATOM   1437  N   ILE    93      14.387   1.273  24.590  1.00  8.17           N
ATOM   1438  CA  ILE    93      14.469   1.437  26.046  1.00  8.79           C
ATOM   1440  CB  ILE    93      13.775   2.735  26.554  1.00  9.36           C
ATOM   1442  CG1 ILE    93      14.392   3.978  25.905  1.00 12.22           C
ATOM   1445  CD1 ILE    93      13.736   5.273  26.334  1.00 14.74           C
ATOM   1449  CG2 ILE    93      13.850   2.873  28.091  1.00 13.41           C
ATOM   1453  C   ILE    93      13.839   0.215  26.685  1.00  8.69           C
ATOM   1454  O   ILE    93      12.716  -0.158  26.382  1.00  8.14           O
ATOM   1456  N   GLU    94      14.587  -0.408  27.588  1.00  8.99           N
ATOM   1457  CA  GLU    94      14.057  -1.493  28.389  1.00  8.22           C
ATOM   1459  CB  GLU    94      15.122  -2.569  28.575  1.00 11.04           C
ATOM   1462  CG  GLU    94      15.738  -2.924  27.220  1.00 16.67           C
ATOM   1465  CD  GLU    94      16.767  -4.011  27.276  1.00 16.35           C
ATOM   1466  OE1 GLU    94      16.762  -4.808  28.236  1.00 19.51           O
ATOM   1467  OE2 GLU    94      17.608  -4.048  26.330  1.00 22.62           O
ATOM   1468  C   GLU    94      13.584  -0.886  29.689  1.00  8.96           C
ATOM   1469  O   GLU    94      14.327  -0.151  30.370  1.00 11.67           O
ATOM   1471  N   LEU    95      12.324  -1.163  30.007  1.00 11.21           N
ATOM   1472  CA  LEU    95      11.677  -0.524  31.139  1.00 14.71           C
ATOM   1474  CB  LEU    95      10.988   0.768  30.675  1.00 20.18           C
ATOM   1477  CG  LEU    95      10.244   0.748  29.337  1.00 20.27           C
ATOM   1479  CD1 LEU    95       9.020  -0.139  29.452  1.00 23.09           C
ATOM   1483  CD2 LEU    95       9.858   2.172  28.859  1.00 23.60           C
ATOM   1487  C   LEU    95      10.696  -1.450  31.825  1.00 17.18           C
ATOM   1488  O   LEU    95      10.717  -2.674  31.585  1.00 14.01           O
ATOM   1490  OXT LEU    95       9.915  -0.965  32.662  1.00 21.45           O
END
