
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  113 (  835),  selected  113 , name 1ue1_A
# Molecule2: number of CA atoms   98 (  734),  selected   98 , name T0491.pdb
# PARAMETERS: 1ue1_A.T0491.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     3_A      -       -           -
LGA    D     4_A      M       1          3.009
LGA    T     5_A      N       2          1.106
LGA    T     6_A      T       3          0.341
LGA    I     7_A      L       4          0.955
LGA    T     8_A      E       5          0.762
LGA    I     9_A      L       6          0.909
LGA    V    10_A      S       7          0.570
LGA    G    11_A      A       8          1.004
LGA    N    12_A      R       9          0.462
LGA    L    13_A      V      10          0.918
LGA    T    14_A      L      11          0.811
LGA    A    15_A      E      12          1.390
LGA    D    16_A      C      13          2.488
LGA    P    17_A      G      14          3.667
LGA    E    18_A      A      15          2.839
LGA    L    19_A      M      16          1.461
LGA    R    20_A      R      17          1.082
LGA    F    21_A      H      18          1.398
LGA    T    22_A      T      19          1.918
LGA    P    23_A      P      20          2.465
LGA    S    24_A      A      21          2.149
LGA    G    25_A      G      22          1.306
LGA    A    26_A      L      23          1.146
LGA    A    27_A      P      24          0.689
LGA    V    28_A      A      25          0.288
LGA    A    29_A      L      26          1.095
LGA    N    30_A      E      27          0.832
LGA    F    31_A      L      28          0.363
LGA    T    32_A      L      29          1.539
LGA    V    33_A      L      30          0.998
LGA    A    34_A      V      31          0.542
LGA    S    35_A      H      32          0.205
LGA    T    36_A      E      33          1.318
LGA    P    37_A      S      34          1.859
LGA    R    38_A      E      35          4.407
LGA    -       -      V      36           -
LGA    -       -      V      37           -
LGA    -       -      E      38           -
LGA    -       -      A      39           -
LGA    -       -      G      40           -
LGA    -       -      H      41           -
LGA    I    39_A      P      42           #
LGA    Y    40_A      -       -           -
LGA    D    41_A      -       -           -
LGA    W    47_A      -       -           -
LGA    K    48_A      -       -           -
LGA    D    49_A      -       -           -
LGA    G    50_A      R      43           #
LGA    E    51_A      R      44          3.643
LGA    -       -      V      45           -
LGA    A    52_A      E      46          0.738
LGA    L    53_A      L      47          0.548
LGA    F    54_A      T      48          1.097
LGA    L    55_A      I      49          1.477
LGA    R    56_A      S      50          1.043
LGA    C    57_A      A      51          0.767
LGA    N    58_A      V      52          0.816
LGA    I    59_A      A      53          1.134
LGA    W    60_A      L      54          0.842
LGA    R    61_A      G      55          1.068
LGA    E    62_A      D      56          2.310
LGA    A    63_A      L      57          1.892
LGA    A    64_A      A      58          0.649
LGA    E    65_A      L      59          1.312
LGA    N    66_A      L      60          1.474
LGA    V    67_A      L      61          0.888
LGA    A    68_A      A      62          0.305
LGA    E    69_A      D      63          4.150
LGA    S    70_A      -       -           -
LGA    L    71_A      T      64          1.357
LGA    T    72_A      P      65          1.696
LGA    R    73_A      L      66          0.802
LGA    G    74_A      G      67          0.816
LGA    A    75_A      T      68          0.896
LGA    R    76_A      E      69          0.802
LGA    V    77_A      M      70          0.307
LGA    I    78_A      Q      71          0.448
LGA    V    79_A      V      72          0.665
LGA    S    80_A      Q      73          0.591
LGA    G    81_A      G      74          0.475
LGA    R    82_A      F      75          0.608
LGA    L    83_A      L      76          1.177
LGA    K    84_A      A      77          1.202
LGA    Q    85_A      P      78          2.335
LGA    -       -      A      79           -
LGA    -       -      R      80           -
LGA    R    86_A      K      81          4.663
LGA    S    87_A      D      82          2.432
LGA    F    88_A      S      83          3.847
LGA    E    89_A      -       -           -
LGA    T    90_A      -       -           -
LGA    R    91_A      -       -           -
LGA    E    92_A      -       -           -
LGA    G    93_A      -       -           -
LGA    E    94_A      -       -           -
LGA    K    95_A      -       -           -
LGA    R    96_A      -       -           -
LGA    T    97_A      V      84          1.128
LGA    V    98_A      K      85          0.833
LGA    I    99_A      V      86          0.293
LGA    E   100_A      K      87          0.764
LGA    V   101_A      L      88          0.864
LGA    E   102_A      H      89          0.987
LGA    V   103_A      L      90          0.524
LGA    D   104_A      Q      91          0.641
LGA    E   105_A      Q      92          0.461
LGA    I   106_A      A      93          0.466
LGA    G   107_A      R      94          1.006
LGA    P   108_A      R      95          0.930
LGA    S   109_A      I      96          1.868
LGA    L   110_A      A      97          4.024
LGA    R   111_A      -       -           -
LGA    Y   112_A      -       -           -
LGA    A   113_A      G      98          0.576
LGA    T   114_A      -       -           -
LGA    A   115_A      -       -           -
LGA    K   116_A      -       -           -
LGA    V   117_A      -       -           -
LGA    N   118_A      -       -           -
LGA    K   119_A      -       -           -
LGA    A   120_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  113   98    5.0     87    1.66    13.79     83.145     4.936

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.095353 * X  +   0.726228 * Y  +  -0.680809 * Z  + -12.230436
  Y_new =   0.980758 * X  +  -0.185585 * Y  +  -0.060602 * Z  +  37.258297
  Z_new =  -0.170358 * X  +  -0.661930 * Y  +  -0.729950 * Z  +  98.058876 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.405024    0.736568  [ DEG:  -137.7977     42.2023 ]
  Theta =   0.171193    2.970399  [ DEG:     9.8087    170.1913 ]
  Phi   =   1.473877   -1.667716  [ DEG:    84.4469    -95.5531 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1ue1_A                                        
REMARK     2: T0491.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1ue1_A.T0491.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  113   98   5.0   87   1.66   13.79  83.145
REMARK  ---------------------------------------------------------- 
MOLECULE 1ue1_A
HEADER    DNA BINDING PROTEIN                     08-MAY-03   1UE1              
TITLE     CRYSTAL STRUCTURE OF THE SINGLE-STRANDED DNA-BINDING                  
TITLE    2 PROTEIN FROM MYCOBACTERIUM TUBERCULOSIS                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SINGLE-STRAND BINDING PROTEIN;                             
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: SINGLE-STRANDED DNA-BINDING PROTEIN;                        
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MYCOBACTERIUM TUBERCULOSIS;                     
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET11D                                    
KEYWDS    OLIGONUCLEOTIDE BINDING FOLD, DNA-BINDING PROTEIN,                    
KEYWDS   2 STRUCTURAL GENOMICS, PSI, PROTEIN STRUCTURE INITIATIVE, TB           
KEYWDS   3 STRUCTURAL GENOMICS CONSORTIUM, TBSGC                                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.SAIKRISHNAN,J.JEYAKANTHAN,J.VENKATESH,N.ACHARYA,K.SEKAR,            
AUTHOR   2 U.VARSHNEY,M.VIJAYAN,TB STRUCTURAL GENOMICS CONSORTIUM               
AUTHOR   3 (TBSGC)                                                              
REVDAT   2   01-FEB-05 1UE1    1       AUTHOR KEYWDS REMARK                     
REVDAT   1   10-FEB-04 1UE1    0                                                
JRNL        AUTH   K.SAIKRISHNAN,J.JEYAKANTHAN,J.VENKATESH,N.ACHARYA,           
JRNL        AUTH 2 K.SEKAR,U.VARSHNEY,M.VIJAYAN                                 
JRNL        TITL   STRUCTURE OF MYCOBACTERIUM TUBERCULOSIS                      
JRNL        TITL 2 SINGLE-STRANDED DNA-BINDING PROTEIN. VARIABILITY             
JRNL        TITL 3 IN QUATERNARY STRUCTURE AND ITS IMPLICATIONS                 
JRNL        REF    J.MOL.BIOL.                   V. 331   385 2003              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 2.50 ANGSTROMS.                                          
DBREF  1UE1 A    1   164  UNP    P0A610   SSB_MYCTU        1    164             
DBREF  1UE1 B    1   164  UNP    P0A610   SSB_MYCTU        1    164             
SEQRES   1 A  164  MET ALA GLY ASP THR THR ILE THR ILE VAL GLY ASN LEU          
SEQRES   2 A  164  THR ALA ASP PRO GLU LEU ARG PHE THR PRO SER GLY ALA          
SEQRES   3 A  164  ALA VAL ALA ASN PHE THR VAL ALA SER THR PRO ARG ILE          
SEQRES   4 A  164  TYR ASP ARG GLN THR GLY GLU TRP LYS ASP GLY GLU ALA          
SEQRES   5 A  164  LEU PHE LEU ARG CYS ASN ILE TRP ARG GLU ALA ALA GLU          
SEQRES   6 A  164  ASN VAL ALA GLU SER LEU THR ARG GLY ALA ARG VAL ILE          
SEQRES   7 A  164  VAL SER GLY ARG LEU LYS GLN ARG SER PHE GLU THR ARG          
SEQRES   8 A  164  GLU GLY GLU LYS ARG THR VAL ILE GLU VAL GLU VAL ASP          
SEQRES   9 A  164  GLU ILE GLY PRO SER LEU ARG TYR ALA THR ALA LYS VAL          
SEQRES  10 A  164  ASN LYS ALA SER ARG SER GLY GLY PHE GLY SER GLY SER          
SEQRES  11 A  164  ARG PRO ALA PRO ALA GLN THR SER SER ALA SER GLY ASP          
SEQRES  12 A  164  ASP PRO TRP GLY SER ALA PRO ALA SER GLY SER PHE GLY          
SEQRES  13 A  164  GLY GLY ASP ASP GLU PRO PRO PHE                              
SEQRES   1 B  164  MET ALA GLY ASP THR THR ILE THR ILE VAL GLY ASN LEU          
SEQRES   2 B  164  THR ALA ASP PRO GLU LEU ARG PHE THR PRO SER GLY ALA          
SEQRES   3 B  164  ALA VAL ALA ASN PHE THR VAL ALA SER THR PRO ARG ILE          
SEQRES   4 B  164  TYR ASP ARG GLN THR GLY GLU TRP LYS ASP GLY GLU ALA          
SEQRES   5 B  164  LEU PHE LEU ARG CYS ASN ILE TRP ARG GLU ALA ALA GLU          
SEQRES   6 B  164  ASN VAL ALA GLU SER LEU THR ARG GLY ALA ARG VAL ILE          
SEQRES   7 B  164  VAL SER GLY ARG LEU LYS GLN ARG SER PHE GLU THR ARG          
SEQRES   8 B  164  GLU GLY GLU LYS ARG THR VAL ILE GLU VAL GLU VAL ASP          
SEQRES   9 B  164  GLU ILE GLY PRO SER LEU ARG TYR ALA THR ALA LYS VAL          
SEQRES  10 B  164  ASN LYS ALA SER ARG SER GLY GLY PHE GLY SER GLY SER          
SEQRES  11 B  164  ARG PRO ALA PRO ALA GLN THR SER SER ALA SER GLY ASP          
SEQRES  12 B  164  ASP PRO TRP GLY SER ALA PRO ALA SER GLY SER PHE GLY          
SEQRES  13 B  164  GLY GLY ASP ASP GLU PRO PRO PHE                              
HET     ZN    400       1                                                       
HETNAM      ZN ZINC ION                                                         
FORMUL   3   ZN    ZN 2+                                                        
FORMUL   4  HOH   *212(H2 O)                                                    
CRYST1   78.720   78.720   77.160  90.00  90.00 120.00 P 31 2 1     12          
ATOM      1  N   GLY A   3      28.161  27.037  23.818  1.00 75.84           N  
ATOM      2  CA  GLY A   3      28.133  25.578  23.499  1.00 64.04           C  
ATOM      3  C   GLY A   3      27.521  24.743  24.609  1.00 66.50           C  
ATOM      4  O   GLY A   3      26.557  24.009  24.390  1.00 67.99           O  
ATOM      5  N   ASP A   4      28.078  24.847  25.808  1.00 55.93           N  
ATOM      6  CA  ASP A   4      27.560  24.086  26.933  1.00 56.72           C  
ATOM      7  C   ASP A   4      26.269  24.682  27.463  1.00 62.48           C  
ATOM      8  O   ASP A   4      25.924  25.822  27.161  1.00 54.28           O  
ATOM      9  CB  ASP A   4      28.573  24.041  28.078  1.00 53.32           C  
ATOM     10  CG  ASP A   4      29.624  22.979  27.885  1.00 63.15           C  
ATOM     11  OD1 ASP A   4      29.253  21.794  27.757  1.00 64.08           O  
ATOM     12  OD2 ASP A   4      30.821  23.330  27.870  1.00 71.53           O  
ATOM     13  N   THR A   5      25.563  23.885  28.257  1.00 54.46           N  
ATOM     14  CA  THR A   5      24.329  24.305  28.880  1.00 31.01           C  
ATOM     15  C   THR A   5      24.659  24.668  30.330  1.00 43.32           C  
ATOM     16  O   THR A   5      25.137  23.836  31.104  1.00 31.45           O  
ATOM     17  CB  THR A   5      23.313  23.188  28.881  1.00 34.93           C  
ATOM     18  OG1 THR A   5      22.943  22.881  27.528  1.00 44.39           O  
ATOM     19  CG2 THR A   5      22.093  23.603  29.686  1.00 24.72           C  
ATOM     20  N   THR A   6      24.409  25.917  30.693  1.00 40.48           N  
ATOM     21  CA  THR A   6      24.704  26.365  32.035  1.00 41.64           C  
ATOM     22  C   THR A   6      23.443  26.668  32.813  1.00 43.40           C  
ATOM     23  O   THR A   6      22.377  26.873  32.236  1.00 45.52           O  
ATOM     24  CB  THR A   6      25.555  27.632  32.014  1.00 51.68           C  
ATOM     25  OG1 THR A   6      24.799  28.698  31.426  1.00 50.08           O  
ATOM     26  CG2 THR A   6      26.822  27.406  31.208  1.00 48.09           C  
ATOM     27  N   ILE A   7      23.582  26.688  34.136  1.00 41.71           N  
ATOM     28  CA  ILE A   7      22.470  26.986  35.014  1.00 31.03           C  
ATOM     29  C   ILE A   7      22.960  27.634  36.290  1.00 39.62           C  
ATOM     30  O   ILE A   7      24.148  27.604  36.610  1.00 49.77           O  
ATOM     31  CB  ILE A   7      21.705  25.729  35.423  1.00 43.48           C  
ATOM     32  CG1 ILE A   7      22.661  24.789  36.150  1.00 13.50           C  
ATOM     33  CG2 ILE A   7      21.022  25.085  34.202  1.00 35.71           C  
ATOM     34  CD1 ILE A   7      21.924  23.793  37.011  1.00 46.31           C  
ATOM     35  N   THR A   8      22.010  28.213  37.013  1.00 42.35           N  
ATOM     36  CA  THR A   8      22.243  28.869  38.286  1.00 30.36           C  
ATOM     37  C   THR A   8      21.264  28.239  39.244  1.00 30.51           C  
ATOM     38  O   THR A   8      20.065  28.245  38.998  1.00 41.47           O  
ATOM     39  CB  THR A   8      21.905  30.363  38.247  1.00 26.77           C  
ATOM     40  OG1 THR A   8      22.899  31.069  37.501  1.00 42.94           O  
ATOM     41  CG2 THR A   8      21.839  30.917  39.653  1.00 33.70           C  
ATOM     42  N   ILE A   9      21.763  27.679  40.329  1.00 33.07           N  
ATOM     43  CA  ILE A   9      20.856  27.097  41.288  1.00 35.90           C  
ATOM     44  C   ILE A   9      21.157  27.698  42.648  1.00 40.69           C  
ATOM     45  O   ILE A   9      22.318  27.781  43.059  1.00 33.62           O  
ATOM     46  CB  ILE A   9      20.961  25.539  41.330  1.00 27.30           C  
ATOM     47  CG1 ILE A   9      20.026  24.985  42.421  1.00 50.44           C  
ATOM     48  CG2 ILE A   9      22.396  25.105  41.570  1.00 43.29           C  
ATOM     49  CD1 ILE A   9      19.715  23.453  42.343  1.00 16.99           C  
ATOM     50  N   VAL A  10      20.100  28.175  43.302  1.00 35.56           N  
ATOM     51  CA  VAL A  10      20.187  28.753  44.632  1.00 30.64           C  
ATOM     52  C   VAL A  10      19.539  27.715  45.526  1.00 36.55           C  
ATOM     53  O   VAL A  10      18.445  27.262  45.243  1.00 27.65           O  
ATOM     54  CB  VAL A  10      19.399  30.072  44.733  1.00 43.72           C  
ATOM     55  CG1 VAL A  10      19.175  30.445  46.194  1.00 32.12           C  
ATOM     56  CG2 VAL A  10      20.163  31.177  44.036  1.00 38.85           C  
ATOM     57  N   GLY A  11      20.223  27.323  46.592  1.00 39.45           N  
ATOM     58  CA  GLY A  11      19.667  26.322  47.481  1.00 39.09           C  
ATOM     59  C   GLY A  11      20.651  26.114  48.605  1.00 48.08           C  
ATOM     60  O   GLY A  11      21.673  26.796  48.652  1.00 45.10           O  
ATOM     61  N   ASN A  12      20.368  25.175  49.499  1.00 37.46           N  
ATOM     62  CA  ASN A  12      21.259  24.931  50.621  1.00 44.48           C  
ATOM     63  C   ASN A  12      21.923  23.592  50.474  1.00 35.56           C  
ATOM     64  O   ASN A  12      21.330  22.658  49.933  1.00 38.11           O  
ATOM     65  CB  ASN A  12      20.494  24.967  51.947  1.00 51.88           C  
ATOM     66  CG  ASN A  12      19.365  25.975  51.942  1.00 53.99           C  
ATOM     67  OD1 ASN A  12      18.285  25.705  51.421  1.00 49.38           O  
ATOM     68  ND2 ASN A  12      19.615  27.148  52.506  1.00 54.46           N  
ATOM     69  N   LEU A  13      23.160  23.502  50.948  1.00 37.35           N  
ATOM     70  CA  LEU A  13      23.905  22.251  50.871  1.00 43.94           C  
ATOM     71  C   LEU A  13      23.197  21.281  51.790  1.00 38.55           C  
ATOM     72  O   LEU A  13      22.805  21.663  52.885  1.00 37.57           O  
ATOM     73  CB  LEU A  13      25.348  22.445  51.340  1.00 27.29           C  
ATOM     74  CG  LEU A  13      26.171  23.558  50.682  1.00 32.88           C  
ATOM     75  CD1 LEU A  13      27.587  23.477  51.214  1.00 46.87           C  
ATOM     76  CD2 LEU A  13      26.185  23.413  49.171  1.00 38.42           C  
ATOM     77  N   THR A  14      23.015  20.043  51.342  1.00 43.18           N  
ATOM     78  CA  THR A  14      22.335  19.043  52.154  1.00 42.10           C  
ATOM     79  C   THR A  14      23.285  18.457  53.176  1.00 45.44           C  
ATOM     80  O   THR A  14      22.872  17.716  54.062  1.00 54.59           O  
ATOM     81  CB  THR A  14      21.793  17.877  51.305  1.00 36.62           C  
ATOM     82  OG1 THR A  14      22.850  17.359  50.494  1.00 44.45           O  
ATOM     83  CG2 THR A  14      20.649  18.328  50.422  1.00 46.29           C  
ATOM     84  N   ALA A  15      24.565  18.783  53.049  1.00 49.29           N  
ATOM     85  CA  ALA A  15      25.566  18.268  53.973  1.00 53.47           C  
ATOM     86  C   ALA A  15      26.911  18.930  53.722  1.00 54.44           C  
ATOM     87  O   ALA A  15      27.148  19.453  52.638  1.00 45.38           O  
ATOM     88  CB  ALA A  15      25.687  16.765  53.807  1.00 44.60           C  
ATOM     89  N   ASP A  16      27.790  18.909  54.720  1.00 55.11           N  
ATOM     90  CA  ASP A  16      29.109  19.512  54.562  1.00 58.10           C  
ATOM     91  C   ASP A  16      29.777  19.010  53.282  1.00 59.39           C  
ATOM     92  O   ASP A  16      29.563  17.872  52.859  1.00 59.75           O  
ATOM     93  CB  ASP A  16      30.019  19.165  55.744  1.00 67.26           C  
ATOM     94  CG  ASP A  16      29.388  19.464  57.077  1.00 63.12           C  
ATOM     95  OD1 ASP A  16      28.791  20.551  57.215  1.00 69.20           O  
ATOM     96  OD2 ASP A  16      29.506  18.613  57.988  1.00 66.87           O  
ATOM     97  N   PRO A  17      30.591  19.861  52.642  1.00 62.77           N  
ATOM     98  CA  PRO A  17      31.289  19.479  51.409  1.00 64.00           C  
ATOM     99  C   PRO A  17      32.388  18.434  51.646  1.00 65.08           C  
ATOM    100  O   PRO A  17      33.298  18.646  52.451  1.00 74.62           O  
ATOM    101  CB  PRO A  17      31.866  20.804  50.919  1.00 52.49           C  
ATOM    102  CG  PRO A  17      30.889  21.800  51.423  1.00 49.42           C  
ATOM    103  CD  PRO A  17      30.637  21.322  52.826  1.00 56.22           C  
ATOM    104  N   GLU A  18      32.293  17.304  50.950  1.00 63.80           N  
ATOM    105  CA  GLU A  18      33.286  16.241  51.054  1.00 52.13           C  
ATOM    106  C   GLU A  18      34.549  16.698  50.343  1.00 54.14           C  
ATOM    107  O   GLU A  18      34.560  16.788  49.121  1.00 66.67           O  
ATOM    108  CB  GLU A  18      32.793  14.971  50.356  1.00 57.17           C  
ATOM    109  CG  GLU A  18      31.974  14.001  51.192  1.00 56.10           C  
ATOM    110  CD  GLU A  18      31.476  12.822  50.366  1.00 60.30           C  
ATOM    111  OE1 GLU A  18      32.265  12.270  49.570  1.00 74.88           O  
ATOM    112  OE2 GLU A  18      30.296  12.439  50.511  1.00 65.40           O  
ATOM    113  N   LEU A  19      35.612  16.998  51.080  1.00 62.35           N  
ATOM    114  CA  LEU A  19      36.842  17.409  50.412  1.00 68.48           C  
ATOM    115  C   LEU A  19      37.845  16.276  50.368  1.00 77.34           C  
ATOM    116  O   LEU A  19      38.538  16.004  51.350  1.00 82.93           O  
ATOM    117  CB  LEU A  19      37.493  18.609  51.097  1.00 57.95           C  
ATOM    118  CG  LEU A  19      38.895  18.894  50.539  1.00 53.37           C  
ATOM    119  CD1 LEU A  19      38.839  19.029  49.013  1.00 40.14           C  
ATOM    120  CD2 LEU A  19      39.462  20.160  51.168  1.00 52.98           C  
ATOM    121  N   ARG A  20      37.918  15.618  49.219  1.00 80.16           N  
ATOM    122  CA  ARG A  20      38.849  14.517  49.026  1.00 75.83           C  
ATOM    123  C   ARG A  20      39.907  14.924  48.011  1.00 70.36           C  
ATOM    124  O   ARG A  20      39.717  15.878  47.254  1.00 72.20           O  
ATOM    125  CB  ARG A  20      38.098  13.265  48.554  1.00 71.07           C  
ATOM    126  CG  ARG A  20      37.547  12.402  49.692  1.00 81.60           C  
ATOM    127  CD  ARG A  20      36.692  13.204  50.670  1.00 81.10           C  
ATOM    128  NE  ARG A  20      36.190  12.382  51.770  1.00 74.09           N  
ATOM    129  CZ  ARG A  20      35.460  12.847  52.781  1.00 72.02           C  
ATOM    130  NH1 ARG A  20      35.049  12.026  53.736  1.00 78.84           N  
ATOM    131  NH2 ARG A  20      35.138  14.132  52.841  1.00 71.08           N  
ATOM    132  N   PHE A  21      41.029  14.211  48.009  1.00 67.09           N  
ATOM    133  CA  PHE A  21      42.100  14.510  47.077  1.00 66.96           C  
ATOM    134  C   PHE A  21      42.355  13.364  46.121  1.00 78.00           C  
ATOM    135  O   PHE A  21      42.050  12.211  46.421  1.00 79.30           O  
ATOM    136  CB  PHE A  21      43.389  14.831  47.823  1.00 50.64           C  
ATOM    137  CG  PHE A  21      43.342  16.124  48.573  1.00 64.43           C  
ATOM    138  CD1 PHE A  21      42.638  16.227  49.765  1.00 63.77           C  
ATOM    139  CD2 PHE A  21      44.010  17.245  48.089  1.00 73.87           C  
ATOM    140  CE1 PHE A  21      42.599  17.428  50.467  1.00 73.00           C  
ATOM    141  CE2 PHE A  21      43.976  18.451  48.784  1.00 77.68           C  
ATOM    142  CZ  PHE A  21      43.272  18.542  49.975  1.00 69.63           C  
ATOM    143  N   THR A  22      42.909  13.701  44.960  1.00 93.43           N  
ATOM    144  CA  THR A  22      43.237  12.718  43.940  1.00114.06           C  
ATOM    145  C   THR A  22      44.707  12.353  44.119  1.00119.38           C  
ATOM    146  O   THR A  22      45.464  13.096  44.746  1.00112.28           O  
ATOM    147  CB  THR A  22      43.022  13.291  42.520  1.00122.49           C  
ATOM    148  OG1 THR A  22      43.873  14.427  42.326  1.00125.20           O  
ATOM    149  CG2 THR A  22      41.572  13.709  42.327  1.00127.36           C  
ATOM    150  N   PRO A  23      45.133  11.205  43.568  1.00125.77           N  
ATOM    151  CA  PRO A  23      46.532  10.792  43.705  1.00126.52           C  
ATOM    152  C   PRO A  23      47.504  11.894  43.293  1.00121.52           C  
ATOM    153  O   PRO A  23      48.519  12.121  43.953  1.00117.02           O  
ATOM    154  CB  PRO A  23      46.617   9.567  42.797  1.00134.07           C  
ATOM    155  CG  PRO A  23      45.599   9.867  41.736  1.00136.79           C  
ATOM    156  CD  PRO A  23      44.444  10.378  42.563  1.00130.57           C  
ATOM    157  N   SER A  24      47.176  12.577  42.202  1.00116.72           N  
ATOM    158  CA  SER A  24      48.010  13.654  41.692  1.00112.46           C  
ATOM    159  C   SER A  24      48.107  14.831  42.667  1.00109.52           C  
ATOM    160  O   SER A  24      48.950  15.715  42.498  1.00110.68           O  
ATOM    161  CB  SER A  24      47.484  14.123  40.327  1.00106.86           C  
ATOM    162  OG  SER A  24      46.082  14.330  40.348  1.00110.90           O  
ATOM    163  N   GLY A  25      47.248  14.842  43.683  1.00106.00           N  
ATOM    164  CA  GLY A  25      47.289  15.912  44.668  1.00107.24           C  
ATOM    165  C   GLY A  25      46.186  16.957  44.606  1.00105.82           C  
ATOM    166  O   GLY A  25      45.836  17.550  45.630  1.00 97.44           O  
ATOM    167  N   ALA A  26      45.644  17.195  43.413  1.00101.08           N  
ATOM    168  CA  ALA A  26      44.580  18.180  43.232  1.00 90.06           C  
ATOM    169  C   ALA A  26      43.405  17.856  44.146  1.00 87.10           C  
ATOM    170  O   ALA A  26      43.103  16.690  44.394  1.00 94.01           O  
ATOM    171  CB  ALA A  26      44.127  18.200  41.776  1.00 76.58           C  
ATOM    172  N   ALA A  27      42.747  18.896  44.647  1.00 86.44           N  
ATOM    173  CA  ALA A  27      41.617  18.718  45.544  1.00 73.05           C  
ATOM    174  C   ALA A  27      40.296  18.746  44.795  1.00 76.16           C  
ATOM    175  O   ALA A  27      40.158  19.420  43.774  1.00 73.98           O  
ATOM    176  CB  ALA A  27      41.628  19.797  46.605  1.00 78.84           C  
ATOM    177  N   VAL A  28      39.324  18.009  45.316  1.00 70.35           N  
ATOM    178  CA  VAL A  28      38.006  17.950  44.708  1.00 65.53           C  
ATOM    179  C   VAL A  28      36.950  18.072  45.787  1.00 61.80           C  
ATOM    180  O   VAL A  28      36.972  17.339  46.775  1.00 64.36           O  
ATOM    181  CB  VAL A  28      37.755  16.614  43.991  1.00 72.89           C  
ATOM    182  CG1 VAL A  28      36.701  16.797  42.914  1.00 58.82           C  
ATOM    183  CG2 VAL A  28      39.043  16.074  43.426  1.00 80.91           C  
ATOM    184  N   ALA A  29      36.024  18.998  45.596  1.00 57.72           N  
ATOM    185  CA  ALA A  29      34.950  19.183  46.549  1.00 54.37           C  
ATOM    186  C   ALA A  29      33.636  18.730  45.913  1.00 50.97           C  
ATOM    187  O   ALA A  29      33.297  19.117  44.789  1.00 48.40           O  
ATOM    188  CB  ALA A  29      34.870  20.637  46.969  1.00 38.73           C  
ATOM    189  N   ASN A  30      32.921  17.877  46.636  1.00 50.50           N  
ATOM    190  CA  ASN A  30      31.638  17.355  46.198  1.00 41.35           C  
ATOM    191  C   ASN A  30      30.565  17.777  47.187  1.00 47.64           C  
ATOM    192  O   ASN A  30      30.810  17.862  48.389  1.00 33.92           O  
ATOM    193  CB  ASN A  30      31.671  15.829  46.119  1.00 40.99           C  
ATOM    194  CG  ASN A  30      32.135  15.324  44.768  1.00 46.26           C  
ATOM    195  OD1 ASN A  30      33.326  15.104  44.546  1.00 57.55           O  
ATOM    196  ND2 ASN A  30      31.190  15.154  43.845  1.00 40.27           N  
ATOM    197  N   PHE A  31      29.374  18.043  46.675  1.00 42.79           N  
ATOM    198  CA  PHE A  31      28.263  18.455  47.511  1.00 39.61           C  
ATOM    199  C   PHE A  31      27.028  18.563  46.641  1.00 39.08           C  
ATOM    200  O   PHE A  31      27.118  18.804  45.433  1.00 32.83           O  
ATOM    201  CB  PHE A  31      28.564  19.805  48.179  1.00 28.60           C  
ATOM    202  CG  PHE A  31      28.900  20.912  47.207  1.00 35.81           C  
ATOM    203  CD1 PHE A  31      30.198  21.371  47.079  1.00 41.40           C  
ATOM    204  CD2 PHE A  31      27.906  21.500  46.422  1.00 45.69           C  
ATOM    205  CE1 PHE A  31      30.508  22.404  46.182  1.00 32.32           C  
ATOM    206  CE2 PHE A  31      28.200  22.527  45.526  1.00 18.88           C  
ATOM    207  CZ  PHE A  31      29.503  22.979  45.407  1.00 49.89           C  
ATOM    208  N   THR A  32      25.870  18.351  47.248  1.00 34.96           N  
ATOM    209  CA  THR A  32      24.630  18.456  46.511  1.00 24.62           C  
ATOM    210  C   THR A  32      23.819  19.619  47.059  1.00 32.08           C  
ATOM    211  O   THR A  32      23.572  19.720  48.266  1.00 30.26           O  
ATOM    212  CB  THR A  32      23.795  17.152  46.580  1.00 30.38           C  
ATOM    213  OG1 THR A  32      23.428  16.875  47.929  1.00 54.42           O  
ATOM    214  CG2 THR A  32      24.593  15.990  46.053  1.00 23.84           C  
ATOM    215  N   VAL A  33      23.442  20.521  46.160  1.00 35.75           N  
ATOM    216  CA  VAL A  33      22.642  21.678  46.520  1.00 31.64           C  
ATOM    217  C   VAL A  33      21.173  21.274  46.399  1.00 43.71           C  
ATOM    218  O   VAL A  33      20.767  20.639  45.420  1.00 44.05           O  
ATOM    219  CB  VAL A  33      22.935  22.852  45.574  1.00 35.16           C  
ATOM    220  CG1 VAL A  33      21.891  23.925  45.731  1.00 19.15           C  
ATOM    221  CG2 VAL A  33      24.310  23.405  45.861  1.00 40.20           C  
ATOM    222  N   ALA A  34      20.385  21.621  47.410  1.00 40.71           N  
ATOM    223  CA  ALA A  34      18.965  21.296  47.418  1.00 27.55           C  
ATOM    224  C   ALA A  34      18.177  22.586  47.323  1.00 26.18           C  
ATOM    225  O   ALA A  34      18.079  23.340  48.290  1.00 33.56           O  
ATOM    226  CB  ALA A  34      18.608  20.565  48.691  1.00 30.37           C  
ATOM    227  N   SER A  35      17.605  22.851  46.159  1.00 34.44           N  
ATOM    228  CA  SER A  35      16.854  24.083  45.984  1.00 44.39           C  
ATOM    229  C   SER A  35      15.367  23.900  46.197  1.00 53.58           C  
ATOM    230  O   SER A  35      14.734  23.098  45.514  1.00 65.04           O  
ATOM    231  CB  SER A  35      17.102  24.643  44.589  1.00 38.60           C  
ATOM    232  OG  SER A  35      16.236  25.727  44.324  1.00 61.55           O  
ATOM    233  N   THR A  36      14.807  24.655  47.139  1.00 70.20           N  
ATOM    234  CA  THR A  36      13.381  24.571  47.437  1.00 78.85           C  
ATOM    235  C   THR A  36      12.710  25.952  47.445  1.00 80.20           C  
ATOM    236  O   THR A  36      13.103  26.848  48.193  1.00 85.53           O  
ATOM    237  CB  THR A  36      13.141  23.864  48.781  1.00 84.83           C  
ATOM    238  OG1 THR A  36      13.854  22.622  48.792  1.00 87.44           O  
ATOM    239  CG2 THR A  36      11.659  23.571  48.970  1.00 96.44           C  
ATOM    240  N   PRO A  37      11.683  26.123  46.591  1.00 80.78           N  
ATOM    241  CA  PRO A  37      10.805  27.266  46.295  1.00 88.95           C  
ATOM    242  C   PRO A  37       9.975  28.027  47.343  1.00 98.88           C  
ATOM    243  O   PRO A  37      10.137  27.883  48.557  1.00 94.15           O  
ATOM    244  CB  PRO A  37       9.910  26.713  45.189  1.00 86.79           C  
ATOM    245  CG  PRO A  37      10.826  25.796  44.472  1.00 80.72           C  
ATOM    246  CD  PRO A  37      11.441  25.048  45.616  1.00 73.95           C  
ATOM    247  N   ARG A  38       9.071  28.846  46.806  1.00110.12           N  
ATOM    248  CA  ARG A  38       8.170  29.716  47.557  1.00115.61           C  
ATOM    249  C   ARG A  38       6.687  29.427  47.253  1.00126.16           C  
ATOM    250  O   ARG A  38       6.376  28.553  46.439  1.00125.33           O  
ATOM    251  CB  ARG A  38       8.510  31.169  47.203  1.00114.76           C  
ATOM    252  CG  ARG A  38       8.859  31.399  45.713  1.00103.67           C  
ATOM    253  CD  ARG A  38       7.623  31.345  44.819  1.00104.42           C  
ATOM    254  NE  ARG A  38       7.912  31.572  43.402  1.00107.20           N  
ATOM    255  CZ  ARG A  38       8.098  30.608  42.503  1.00112.45           C  
ATOM    256  NH1 ARG A  38       8.353  30.917  41.239  1.00115.71           N  
ATOM    257  NH2 ARG A  38       8.026  29.332  42.863  1.00102.25           N  
ATOM    258  N   ILE A  39       5.782  30.156  47.911  1.00134.09           N  
ATOM    259  CA  ILE A  39       4.339  29.982  47.697  1.00134.73           C  
ATOM    260  C   ILE A  39       3.529  31.260  47.960  1.00134.91           C  
ATOM    261  O   ILE A  39       4.091  32.355  48.008  1.00132.95           O  
ATOM    262  CB  ILE A  39       3.810  28.843  48.559  1.00134.87           C  
ATOM    263  N   TYR A  40       2.214  31.117  48.134  1.00135.74           N  
ATOM    264  CA  TYR A  40       1.343  32.271  48.360  1.00136.11           C  
ATOM    265  C   TYR A  40       0.166  32.043  49.320  1.00140.24           C  
ATOM    266  O   TYR A  40      -0.162  30.908  49.666  1.00142.58           O  
ATOM    267  CB  TYR A  40       0.816  32.778  47.019  1.00129.32           C  
ATOM    268  N   ASP A  41      -0.461  33.148  49.731  1.00144.32           N  
ATOM    269  CA  ASP A  41      -1.608  33.161  50.648  1.00144.33           C  
ATOM    270  C   ASP A  41      -1.453  32.322  51.914  1.00146.26           C  
ATOM    271  O   ASP A  41      -2.328  31.465  52.164  1.00147.69           O  
ATOM    272  CB  ASP A  41      -2.885  32.737  49.912  1.00144.37           C  
ATOM    273  CG  ASP A  41      -3.446  33.840  49.033  1.00143.16           C  
ATOM    274  OD1 ASP A  41      -2.751  34.266  48.088  1.00139.71           O  
ATOM    275  OD2 ASP A  41      -4.586  34.282  49.291  1.00147.94           O  
ATOM    276  N   TRP A  47       1.624  30.657  53.787  1.00119.09           N  
ATOM    277  CA  TRP A  47       1.130  29.336  53.293  1.00129.23           C  
ATOM    278  C   TRP A  47       2.177  28.546  52.524  1.00137.04           C  
ATOM    279  O   TRP A  47       1.974  27.384  52.184  1.00138.26           O  
ATOM    280  N   LYS A  48       3.323  29.192  52.308  1.00140.98           N  
ATOM    281  CA  LYS A  48       4.469  28.679  51.549  1.00146.05           C  
ATOM    282  C   LYS A  48       4.935  27.220  51.474  1.00148.96           C  
ATOM    283  O   LYS A  48       4.331  26.316  52.057  1.00150.52           O  
ATOM    284  CB  LYS A  48       5.682  29.585  51.857  1.00145.30           C  
ATOM    285  CG  LYS A  48       5.370  31.048  51.617  1.00141.29           C  
ATOM    286  CD  LYS A  48       6.090  31.937  52.600  1.00129.16           C  
ATOM    287  CE  LYS A  48       5.718  33.376  52.342  1.00125.82           C  
ATOM    288  NZ  LYS A  48       6.449  34.282  53.259  1.00126.87           N  
ATOM    289  N   ASP A  49       6.009  27.034  50.693  1.00149.01           N  
ATOM    290  CA  ASP A  49       6.711  25.765  50.407  1.00140.55           C  
ATOM    291  C   ASP A  49       6.156  24.715  49.429  1.00134.06           C  
ATOM    292  O   ASP A  49       4.956  24.410  49.393  1.00140.01           O  
ATOM    293  CB  ASP A  49       7.116  25.069  51.708  1.00139.93           C  
ATOM    294  CG  ASP A  49       8.286  25.758  52.376  1.00133.27           C  
ATOM    295  OD1 ASP A  49       8.148  26.946  52.745  1.00128.65           O  
ATOM    296  OD2 ASP A  49       9.350  25.123  52.518  1.00120.35           O  
ATOM    297  N   GLY A  50       7.081  24.173  48.633  1.00123.97           N  
ATOM    298  CA  GLY A  50       6.770  23.164  47.628  1.00116.91           C  
ATOM    299  C   GLY A  50       7.966  22.768  46.760  1.00119.03           C  
ATOM    300  O   GLY A  50       9.107  22.821  47.198  1.00122.49           O  
ATOM    301  N   GLU A  51       7.685  22.358  45.523  1.00114.65           N  
ATOM    302  CA  GLU A  51       8.687  21.933  44.532  1.00111.18           C  
ATOM    303  C   GLU A  51       9.887  21.090  45.007  1.00104.91           C  
ATOM    304  O   GLU A  51       9.691  19.994  45.540  1.00108.47           O  
ATOM    305  CB  GLU A  51       9.186  23.158  43.760  1.00115.14           C  
ATOM    306  N   ALA A  52      11.111  21.589  44.789  1.00 88.21           N  
ATOM    307  CA  ALA A  52      12.359  20.914  45.196  1.00 71.47           C  
ATOM    308  C   ALA A  52      13.216  20.393  44.048  1.00 64.85           C  
ATOM    309  O   ALA A  52      12.715  19.827  43.074  1.00 77.25           O  
ATOM    310  CB  ALA A  52      12.073  19.762  46.165  1.00 64.68           C  
ATOM    311  N   LEU A  53      14.521  20.597  44.189  1.00 47.99           N  
ATOM    312  CA  LEU A  53      15.513  20.181  43.203  1.00 48.94           C  
ATOM    313  C   LEU A  53      16.862  19.921  43.888  1.00 46.18           C  
ATOM    314  O   LEU A  53      17.414  20.793  44.563  1.00 45.62           O  
ATOM    315  CB  LEU A  53      15.693  21.272  42.149  1.00 53.58           C  
ATOM    316  CG  LEU A  53      16.236  20.822  40.797  1.00 43.36           C  
ATOM    317  CD1 LEU A  53      15.110  20.133  40.043  1.00 50.36           C  
ATOM    318  CD2 LEU A  53      16.745  22.011  40.009  1.00 41.21           C  
ATOM    319  N   PHE A  54      17.390  18.718  43.713  1.00 45.36           N  
ATOM    320  CA  PHE A  54      18.667  18.344  44.310  1.00 29.76           C  
ATOM    321  C   PHE A  54      19.703  18.104  43.211  1.00 37.07           C  
ATOM    322  O   PHE A  54      19.611  17.120  42.484  1.00 36.69           O  
ATOM    323  CB  PHE A  54      18.530  17.046  45.120  1.00 34.05           C  
ATOM    324  CG  PHE A  54      17.705  17.176  46.378  1.00 45.88           C  
ATOM    325  CD1 PHE A  54      16.317  17.233  46.318  1.00 46.97           C  
ATOM    326  CD2 PHE A  54      18.328  17.232  47.630  1.00 35.10           C  
ATOM    327  CE1 PHE A  54      15.553  17.344  47.487  1.00 49.93           C  
ATOM    328  CE2 PHE A  54      17.581  17.344  48.804  1.00 37.92           C  
ATOM    329  CZ  PHE A  54      16.191  17.399  48.735  1.00 53.19           C  
ATOM    330  N   LEU A  55      20.700  18.977  43.097  1.00 37.82           N  
ATOM    331  CA  LEU A  55      21.725  18.788  42.084  1.00 28.39           C  
ATOM    332  C   LEU A  55      23.135  18.518  42.616  1.00 41.70           C  
ATOM    333  O   LEU A  55      23.731  19.341  43.311  1.00 41.48           O  
ATOM    334  CB  LEU A  55      21.744  19.998  41.166  1.00 34.61           C  
ATOM    335  CG  LEU A  55      20.449  20.139  40.376  1.00 33.24           C  
ATOM    336  CD1 LEU A  55      20.531  21.349  39.470  1.00 24.26           C  
ATOM    337  CD2 LEU A  55      20.230  18.852  39.566  1.00 28.85           C  
ATOM    338  N   ARG A  56      23.675  17.360  42.270  1.00 34.06           N  
ATOM    339  CA  ARG A  56      25.020  16.988  42.699  1.00 24.41           C  
ATOM    340  C   ARG A  56      26.025  17.898  42.011  1.00 18.64           C  
ATOM    341  O   ARG A  56      26.017  18.021  40.790  1.00 38.05           O  
ATOM    342  CB  ARG A  56      25.309  15.532  42.317  1.00 15.81           C  
ATOM    343  CG  ARG A  56      24.429  14.500  43.022  1.00 39.61           C  
ATOM    344  CD  ARG A  56      24.434  13.162  42.282  1.00 46.38           C  
ATOM    345  NE  ARG A  56      25.767  12.819  41.801  1.00 49.21           N  
ATOM    346  CZ  ARG A  56      26.085  12.655  40.519  1.00 63.05           C  
ATOM    347  NH1 ARG A  56      27.329  12.349  40.184  1.00 47.85           N  
ATOM    348  NH2 ARG A  56      25.162  12.780  39.569  1.00 66.95           N  
ATOM    349  N   CYS A  57      26.905  18.519  42.787  1.00 41.59           N  
ATOM    350  CA  CYS A  57      27.913  19.425  42.226  1.00 35.23           C  
ATOM    351  C   CYS A  57      29.336  19.017  42.579  1.00 40.49           C  
ATOM    352  O   CYS A  57      29.568  18.259  43.520  1.00 35.49           O  
ATOM    353  CB  CYS A  57      27.713  20.852  42.749  1.00 26.74           C  
ATOM    354  SG  CYS A  57      26.069  21.584  42.493  1.00 44.88           S  
ATOM    355  N   ASN A  58      30.287  19.528  41.807  1.00 31.72           N  
ATOM    356  CA  ASN A  58      31.687  19.286  42.079  1.00 46.11           C  
ATOM    357  C   ASN A  58      32.531  20.434  41.560  1.00 54.44           C  
ATOM    358  O   ASN A  58      32.402  20.861  40.416  1.00 51.41           O  
ATOM    359  CB  ASN A  58      32.173  17.958  41.487  1.00 46.50           C  
ATOM    360  CG  ASN A  58      31.780  17.775  40.048  1.00 39.87           C  
ATOM    361  OD1 ASN A  58      30.667  17.358  39.750  1.00 49.12           O  
ATOM    362  ND2 ASN A  58      32.698  18.078  39.141  1.00 50.80           N  
ATOM    363  N   ILE A  59      33.370  20.955  42.441  1.00 54.87           N  
ATOM    364  CA  ILE A  59      34.270  22.044  42.108  1.00 46.97           C  
ATOM    365  C   ILE A  59      35.620  21.382  42.305  1.00 46.90           C  
ATOM    366  O   ILE A  59      35.696  20.362  42.988  1.00 37.46           O  
ATOM    367  CB  ILE A  59      34.106  23.232  43.095  1.00 39.06           C  
ATOM    368  CG1 ILE A  59      35.013  24.393  42.692  1.00 50.37           C  
ATOM    369  CG2 ILE A  59      34.429  22.789  44.497  1.00 39.16           C  
ATOM    370  CD1 ILE A  59      34.671  24.997  41.354  1.00 64.97           C  
ATOM    371  N   TRP A  60      36.667  21.931  41.696  1.00 50.72           N  
ATOM    372  CA  TRP A  60      38.008  21.363  41.834  1.00 60.53           C  
ATOM    373  C   TRP A  60      39.012  22.454  42.147  1.00 50.45           C  
ATOM    374  O   TRP A  60      38.659  23.620  42.247  1.00 59.39           O  
ATOM    375  CB  TRP A  60      38.465  20.658  40.545  1.00 60.02           C  
ATOM    376  CG  TRP A  60      37.657  19.467  40.108  1.00 55.34           C  
ATOM    377  CD1 TRP A  60      36.399  19.476  39.580  1.00 60.16           C  
ATOM    378  CD2 TRP A  60      38.081  18.098  40.111  1.00 59.40           C  
ATOM    379  NE1 TRP A  60      36.014  18.198  39.244  1.00 56.43           N  
ATOM    380  CE2 TRP A  60      37.027  17.333  39.557  1.00 47.75           C  
ATOM    381  CE3 TRP A  60      39.248  17.444  40.517  1.00 59.13           C  
ATOM    382  CZ2 TRP A  60      37.104  15.946  39.408  0.00 56.77           C  
ATOM    383  CZ3 TRP A  60      39.323  16.059  40.367  1.00 64.96           C  
ATOM    384  CH2 TRP A  60      38.257  15.330  39.814  1.00 54.30           C  
ATOM    385  N   ARG A  61      40.270  22.054  42.292  1.00 53.40           N  
ATOM    386  CA  ARG A  61      41.361  22.977  42.563  1.00 48.98           C  
ATOM    387  C   ARG A  61      41.161  23.757  43.860  1.00 45.76           C  
ATOM    388  O   ARG A  61      40.551  23.260  44.802  1.00 54.85           O  
ATOM    389  CB  ARG A  61      41.521  23.949  41.389  1.00 64.16           C  
ATOM    390  CG  ARG A  61      41.587  23.290  40.000  1.00 96.57           C  
ATOM    391  CD  ARG A  61      42.724  22.270  39.877  1.00113.46           C  
ATOM    392  NE  ARG A  61      42.945  21.818  38.498  1.00123.63           N  
ATOM    393  CZ  ARG A  61      42.045  21.185  37.748  1.00124.99           C  
ATOM    394  NH1 ARG A  61      40.838  20.914  38.226  1.00121.68           N  
ATOM    395  NH2 ARG A  61      42.356  20.820  36.511  1.00124.76           N  
ATOM    396  N   GLU A  62      41.677  24.981  43.906  1.00 55.62           N  
ATOM    397  CA  GLU A  62      41.565  25.818  45.100  1.00 62.89           C  
ATOM    398  C   GLU A  62      40.123  26.186  45.454  1.00 58.30           C  
ATOM    399  O   GLU A  62      39.785  26.335  46.630  1.00 47.67           O  
ATOM    400  CB  GLU A  62      42.399  27.097  44.946  1.00 67.03           C  
ATOM    401  CG  GLU A  62      43.885  26.974  45.318  1.00 82.00           C  
ATOM    402  CD  GLU A  62      44.735  26.306  44.244  1.00 97.36           C  
ATOM    403  OE1 GLU A  62      44.580  26.660  43.055  1.00 90.73           O  
ATOM    404  OE2 GLU A  62      45.572  25.440  44.591  1.00 98.23           O  
ATOM    405  N   ALA A  63      39.274  26.341  44.444  1.00 53.27           N  
ATOM    406  CA  ALA A  63      37.878  26.675  44.702  1.00 39.78           C  
ATOM    407  C   ALA A  63      37.263  25.548  45.524  1.00 34.98           C  
ATOM    408  O   ALA A  63      36.390  25.784  46.354  1.00 42.53           O  
ATOM    409  CB  ALA A  63      37.119  26.845  43.389  1.00 29.12           C  
ATOM    410  N   ALA A  64      37.739  24.325  45.299  1.00 36.58           N  
ATOM    411  CA  ALA A  64      37.232  23.157  46.013  1.00 42.97           C  
ATOM    412  C   ALA A  64      37.566  23.199  47.498  1.00 50.46           C  
ATOM    413  O   ALA A  64      36.752  22.784  48.328  1.00 55.53           O  
ATOM    414  CB  ALA A  64      37.779  21.869  45.384  1.00 37.01           C  
ATOM    415  N   GLU A  65      38.754  23.700  47.839  1.00 49.27           N  
ATOM    416  CA  GLU A  65      39.149  23.781  49.243  1.00 51.67           C  
ATOM    417  C   GLU A  65      38.489  24.965  49.926  1.00 59.17           C  
ATOM    418  O   GLU A  65      38.146  24.904  51.113  1.00 59.65           O  
ATOM    419  CB  GLU A  65      40.663  23.890  49.368  1.00 49.67           C  
ATOM    420  CG  GLU A  65      41.380  22.611  49.004  1.00 69.29           C  
ATOM    421  CD  GLU A  65      42.873  22.717  49.194  1.00 75.97           C  
ATOM    422  OE1 GLU A  65      43.300  23.046  50.319  1.00 80.11           O  
ATOM    423  OE2 GLU A  65      43.615  22.469  48.220  1.00 83.74           O  
ATOM    424  N   ASN A  66      38.310  26.046  49.174  1.00 51.64           N  
ATOM    425  CA  ASN A  66      37.658  27.220  49.726  1.00 48.12           C  
ATOM    426  C   ASN A  66      36.211  26.833  50.011  1.00 58.81           C  
ATOM    427  O   ASN A  66      35.679  27.153  51.077  1.00 58.56           O  
ATOM    428  CB  ASN A  66      37.737  28.380  48.747  1.00 54.94           C  
ATOM    429  CG  ASN A  66      39.159  28.707  48.364  1.00 55.26           C  
ATOM    430  OD1 ASN A  66      40.053  28.710  49.211  1.00 67.28           O  
ATOM    431  ND2 ASN A  66      39.381  28.990  47.089  1.00 63.11           N  
ATOM    432  N   VAL A  67      35.579  26.142  49.062  1.00 38.47           N  
ATOM    433  CA  VAL A  67      34.213  25.671  49.254  1.00 34.30           C  
ATOM    434  C   VAL A  67      34.233  24.820  50.526  1.00 36.71           C  
ATOM    435  O   VAL A  67      33.439  25.013  51.433  1.00 43.45           O  
ATOM    436  CB  VAL A  67      33.756  24.774  48.069  1.00 46.28           C  
ATOM    437  CG1 VAL A  67      32.578  23.882  48.495  1.00 14.67           C  
ATOM    438  CG2 VAL A  67      33.383  25.647  46.867  1.00 34.61           C  
ATOM    439  N   ALA A  68      35.175  23.887  50.570  1.00 42.76           N  
ATOM    440  CA  ALA A  68      35.338  22.971  51.690  1.00 48.70           C  
ATOM    441  C   ALA A  68      35.468  23.654  53.039  1.00 41.12           C  
ATOM    442  O   ALA A  68      34.818  23.249  53.994  1.00 58.17           O  
ATOM    443  CB  ALA A  68      36.552  22.071  51.451  1.00 44.86           C  
ATOM    444  N   GLU A  69      36.298  24.688  53.120  1.00 48.51           N  
ATOM    445  CA  GLU A  69      36.506  25.392  54.388  1.00 58.65           C  
ATOM    446  C   GLU A  69      35.559  26.580  54.638  1.00 57.70           C  
ATOM    447  O   GLU A  69      35.629  27.223  55.683  1.00 51.90           O  
ATOM    448  CB  GLU A  69      37.952  25.894  54.475  1.00 58.14           C  
ATOM    449  CG  GLU A  69      38.393  26.261  55.892  1.00 92.58           C  
ATOM    450  CD  GLU A  69      39.270  27.504  55.946  1.00104.21           C  
ATOM    451  OE1 GLU A  69      38.728  28.625  55.854  1.00115.70           O  
ATOM    452  OE2 GLU A  69      40.504  27.362  56.077  1.00114.47           O  
ATOM    453  N   SER A  70      34.669  26.868  53.696  1.00 57.59           N  
ATOM    454  CA  SER A  70      33.773  28.002  53.855  1.00 34.87           C  
ATOM    455  C   SER A  70      32.305  27.611  53.908  1.00 42.59           C  
ATOM    456  O   SER A  70      31.455  28.439  54.212  1.00 36.49           O  
ATOM    457  CB  SER A  70      33.988  28.987  52.710  1.00 48.17           C  
ATOM    458  OG  SER A  70      35.366  29.147  52.419  1.00 47.37           O  
ATOM    459  N   LEU A  71      31.990  26.356  53.617  1.00 38.73           N  
ATOM    460  CA  LEU A  71      30.590  25.947  53.641  1.00 40.33           C  
ATOM    461  C   LEU A  71      30.319  24.751  54.539  1.00 53.15           C  
ATOM    462  O   LEU A  71      31.171  23.871  54.710  1.00 61.22           O  
ATOM    463  CB  LEU A  71      30.100  25.641  52.218  1.00 34.14           C  
ATOM    464  CG  LEU A  71      30.171  26.788  51.216  1.00 18.20           C  
ATOM    465  CD1 LEU A  71      29.709  26.315  49.872  1.00 40.86           C  
ATOM    466  CD2 LEU A  71      29.325  27.924  51.690  1.00 11.28           C  
ATOM    467  N   THR A  72      29.122  24.739  55.119  1.00 53.27           N  
ATOM    468  CA  THR A  72      28.690  23.661  55.997  1.00 50.06           C  
ATOM    469  C   THR A  72      27.275  23.288  55.581  1.00 47.92           C  
ATOM    470  O   THR A  72      26.752  23.805  54.596  1.00 52.97           O  
ATOM    471  CB  THR A  72      28.686  24.098  57.479  1.00 54.07           C  
ATOM    472  OG1 THR A  72      27.585  24.984  57.727  1.00 58.04           O  
ATOM    473  CG2 THR A  72      29.982  24.822  57.816  1.00 61.48           C  
ATOM    474  N   ARG A  73      26.659  22.393  56.333  1.00 42.64           N  
ATOM    475  CA  ARG A  73      25.314  21.955  56.024  1.00 40.18           C  
ATOM    476  C   ARG A  73      24.380  23.159  56.047  1.00 37.06           C  
ATOM    477  O   ARG A  73      24.721  24.204  56.598  1.00 48.00           O  
ATOM    478  CB  ARG A  73      24.881  20.905  57.048  1.00 52.31           C  
ATOM    479  CG  ARG A  73      23.753  19.972  56.609  1.00 66.05           C  
ATOM    480  CD  ARG A  73      23.679  18.778  57.554  1.00 46.74           C  
ATOM    481  NE  ARG A  73      23.813  19.219  58.938  1.00 63.71           N  
ATOM    482  CZ  ARG A  73      24.231  18.448  59.936  1.00 76.33           C  
ATOM    483  NH1 ARG A  73      24.320  18.943  61.165  1.00 70.01           N  
ATOM    484  NH2 ARG A  73      24.565  17.184  59.707  1.00 69.53           N  
ATOM    485  N   GLY A  74      23.217  23.016  55.417  1.00 29.96           N  
ATOM    486  CA  GLY A  74      22.233  24.086  55.382  1.00 23.74           C  
ATOM    487  C   GLY A  74      22.615  25.374  54.673  1.00 36.06           C  
ATOM    488  O   GLY A  74      21.744  26.171  54.336  1.00 47.93           O  
ATOM    489  N   ALA A  75      23.900  25.588  54.426  1.00 26.13           N  
ATOM    490  CA  ALA A  75      24.338  26.813  53.771  1.00 29.34           C  
ATOM    491  C   ALA A  75      23.611  27.117  52.453  1.00 41.08           C  
ATOM    492  O   ALA A  75      23.514  26.271  51.549  1.00 37.86           O  
ATOM    493  CB  ALA A  75      25.837  26.760  53.536  1.00 13.73           C  
ATOM    494  N   ARG A  76      23.112  28.346  52.357  1.00 34.73           N  
ATOM    495  CA  ARG A  76      22.407  28.819  51.177  1.00 26.34           C  
ATOM    496  C   ARG A  76      23.441  29.348  50.198  1.00 39.38           C  
ATOM    497  O   ARG A  76      24.110  30.345  50.471  1.00 51.10           O  
ATOM    498  CB  ARG A  76      21.446  29.932  51.554  1.00 25.38           C  
ATOM    499  CG  ARG A  76      20.486  30.297  50.453  1.00 30.37           C  
ATOM    500  CD  ARG A  76      19.695  31.540  50.807  1.00 25.96           C  
ATOM    501  NE  ARG A  76      18.738  31.881  49.759  1.00 48.30           N  
ATOM    502  CZ  ARG A  76      17.683  31.135  49.436  1.00 40.39           C  
ATOM    503  NH1 ARG A  76      17.446  29.995  50.075  1.00 36.98           N  
ATOM    504  NH2 ARG A  76      16.853  31.538  48.484  1.00 34.16           N  
ATOM    505  N   VAL A  77      23.555  28.689  49.048  1.00 27.87           N  
ATOM    506  CA  VAL A  77      24.541  29.057  48.056  1.00 18.67           C  
ATOM    507  C   VAL A  77      23.994  29.455  46.693  1.00 26.58           C  
ATOM    508  O   VAL A  77      22.827  29.216  46.362  1.00 32.45           O  
ATOM    509  CB  VAL A  77      25.520  27.890  47.827  1.00 32.96           C  
ATOM    510  CG1 VAL A  77      26.398  27.657  49.057  1.00 16.67           C  
ATOM    511  CG2 VAL A  77      24.731  26.635  47.520  1.00 31.86           C  
ATOM    512  N   ILE A  78      24.861  30.092  45.919  1.00 29.86           N  
ATOM    513  CA  ILE A  78      24.545  30.482  44.563  1.00 32.84           C  
ATOM    514  C   ILE A  78      25.578  29.691  43.786  1.00 38.96           C  
ATOM    515  O   ILE A  78      26.770  29.735  44.103  1.00 40.24           O  
ATOM    516  CB  ILE A  78      24.765  31.974  44.289  1.00 43.92           C  
ATOM    517  CG1 ILE A  78      23.959  32.814  45.273  1.00 25.00           C  
ATOM    518  CG2 ILE A  78      24.314  32.303  42.854  1.00 31.86           C  
ATOM    519  CD1 ILE A  78      24.155  34.286  45.086  1.00 45.41           C  
ATOM    520  N   VAL A  79      25.112  28.955  42.786  1.00 46.04           N  
ATOM    521  CA  VAL A  79      25.987  28.116  41.991  1.00 43.02           C  
ATOM    522  C   VAL A  79      25.747  28.264  40.500  1.00 32.42           C  
ATOM    523  O   VAL A  79      24.625  28.100  40.015  1.00 37.78           O  
ATOM    524  CB  VAL A  79      25.807  26.617  42.383  1.00 35.70           C  
ATOM    525  CG1 VAL A  79      26.535  25.726  41.409  1.00 26.10           C  
ATOM    526  CG2 VAL A  79      26.331  26.382  43.788  1.00 20.54           C  
ATOM    527  N   SER A  80      26.815  28.593  39.786  1.00 37.59           N  
ATOM    528  CA  SER A  80      26.760  28.729  38.341  1.00 33.34           C  
ATOM    529  C   SER A  80      27.709  27.670  37.804  1.00 41.50           C  
ATOM    530  O   SER A  80      28.884  27.620  38.179  1.00 35.55           O  
ATOM    531  CB  SER A  80      27.225  30.114  37.899  1.00 35.47           C  
ATOM    532  OG  SER A  80      27.208  30.232  36.486  1.00 45.64           O  
ATOM    533  N   GLY A  81      27.194  26.802  36.942  1.00 32.91           N  
ATOM    534  CA  GLY A  81      28.044  25.767  36.398  1.00 27.00           C  
ATOM    535  C   GLY A  81      27.504  25.218  35.106  1.00 42.40           C  
ATOM    536  O   GLY A  81      26.696  25.861  34.430  1.00 44.60           O  
ATOM    537  N   ARG A  82      27.938  24.012  34.775  1.00 42.97           N  
ATOM    538  CA  ARG A  82      27.523  23.381  33.543  1.00 40.61           C  
ATOM    539  C   ARG A  82      26.890  22.043  33.838  1.00 40.35           C  
ATOM    540  O   ARG A  82      27.436  21.251  34.602  1.00 35.82           O  
ATOM    541  CB  ARG A  82      28.744  23.197  32.636  1.00 49.93           C  
ATOM    542  CG  ARG A  82      29.432  24.515  32.276  1.00 83.68           C  
ATOM    543  CD  ARG A  82      30.720  24.341  31.462  1.00 94.54           C  
ATOM    544  NE  ARG A  82      31.912  24.195  32.297  1.00100.77           N  
ATOM    545  CZ  ARG A  82      32.322  23.053  32.841  1.00100.84           C  
ATOM    546  NH1 ARG A  82      31.637  21.936  32.637  1.00102.60           N  
ATOM    547  NH2 ARG A  82      33.416  23.031  33.591  1.00 98.04           N  
ATOM    548  N   LEU A  83      25.726  21.800  33.243  1.00 41.09           N  
ATOM    549  CA  LEU A  83      25.040  20.530  33.429  1.00 37.85           C  
ATOM    550  C   LEU A  83      25.791  19.473  32.648  1.00 40.01           C  
ATOM    551  O   LEU A  83      26.170  19.689  31.497  1.00 43.08           O  
ATOM    552  CB  LEU A  83      23.621  20.583  32.888  1.00 29.90           C  
ATOM    553  CG  LEU A  83      22.547  21.250  33.722  1.00 40.22           C  
ATOM    554  CD1 LEU A  83      21.215  21.102  32.982  1.00 35.59           C  
ATOM    555  CD2 LEU A  83      22.479  20.602  35.093  1.00 29.43           C  
ATOM    556  N   LYS A  84      26.011  18.331  33.276  1.00 33.95           N  
ATOM    557  CA  LYS A  84      26.692  17.231  32.622  1.00 34.12           C  
ATOM    558  C   LYS A  84      25.817  16.032  32.892  1.00 29.61           C  
ATOM    559  O   LYS A  84      25.348  15.852  34.010  1.00 39.31           O  
ATOM    560  CB  LYS A  84      28.091  17.028  33.213  1.00 38.24           C  
ATOM    561  CG  LYS A  84      29.210  17.281  32.214  1.00 58.60           C  
ATOM    562  CD  LYS A  84      28.994  18.582  31.430  1.00 53.87           C  
ATOM    563  CE  LYS A  84      30.059  18.784  30.347  1.00 69.70           C  
ATOM    564  NZ  LYS A  84      29.813  20.015  29.535  1.00 54.13           N  
ATOM    565  N   GLN A  85      25.554  15.235  31.868  1.00 32.32           N  
ATOM    566  CA  GLN A  85      24.724  14.068  32.073  1.00 47.84           C  
ATOM    567  C   GLN A  85      25.331  12.843  31.406  1.00 53.53           C  
ATOM    568  O   GLN A  85      25.918  12.933  30.327  1.00 55.78           O  
ATOM    569  CB  GLN A  85      23.327  14.298  31.508  1.00 41.59           C  
ATOM    570  CG  GLN A  85      23.239  13.941  30.055  1.00 34.77           C  
ATOM    571  CD  GLN A  85      21.833  13.725  29.602  1.00 34.74           C  
ATOM    572  OE1 GLN A  85      20.923  13.594  30.416  1.00 26.33           O  
ATOM    573  NE2 GLN A  85      21.638  13.670  28.290  1.00 26.70           N  
ATOM    574  N   ARG A  86      25.181  11.698  32.061  1.00 64.23           N  
ATOM    575  CA  ARG A  86      25.683  10.436  31.540  1.00 76.62           C  
ATOM    576  C   ARG A  86      24.521   9.445  31.429  1.00 82.02           C  
ATOM    577  O   ARG A  86      23.571   9.509  32.212  1.00 88.30           O  
ATOM    578  CB  ARG A  86      26.795   9.888  32.455  1.00 80.25           C  
ATOM    579  CG  ARG A  86      28.206  10.232  31.970  1.00 80.68           C  
ATOM    580  CD  ARG A  86      29.303   9.725  32.904  1.00 94.25           C  
ATOM    581  NE  ARG A  86      30.599   9.607  32.231  1.00105.91           N  
ATOM    582  CZ  ARG A  86      31.174  10.577  31.523  1.00117.54           C  
ATOM    583  NH1 ARG A  86      30.576  11.754  31.388  1.00127.87           N  
ATOM    584  NH2 ARG A  86      32.345  10.373  30.939  1.00122.80           N  
ATOM    585  N   SER A  87      24.592   8.548  30.446  1.00 88.33           N  
ATOM    586  CA  SER A  87      23.551   7.543  30.222  1.00 83.36           C  
ATOM    587  C   SER A  87      24.137   6.154  30.420  1.00 78.47           C  
ATOM    588  O   SER A  87      25.105   5.790  29.755  1.00 81.14           O  
ATOM    589  CB  SER A  87      23.012   7.663  28.802  1.00 85.65           C  
ATOM    590  OG  SER A  87      22.593   8.986  28.535  1.00 98.35           O  
ATOM    591  N   PHE A  88      23.544   5.368  31.309  1.00 76.06           N  
ATOM    592  CA  PHE A  88      24.075   4.038  31.569  1.00 80.37           C  
ATOM    593  C   PHE A  88      23.254   2.837  31.105  1.00 86.97           C  
ATOM    594  O   PHE A  88      22.226   2.955  30.434  1.00 81.26           O  
ATOM    595  CB  PHE A  88      24.391   3.892  33.065  1.00 53.75           C  
ATOM    596  N   GLU A  89      23.790   1.682  31.487  1.00100.07           N  
ATOM    597  CA  GLU A  89      23.300   0.324  31.253  1.00108.67           C  
ATOM    598  C   GLU A  89      22.186  -0.070  30.280  1.00115.42           C  
ATOM    599  O   GLU A  89      21.719   0.703  29.440  1.00111.05           O  
ATOM    600  CB  GLU A  89      23.001  -0.300  32.602  1.00103.96           C  
ATOM    601  N   THR A  90      21.820  -1.343  30.443  1.00124.08           N  
ATOM    602  CA  THR A  90      20.796  -2.099  29.718  1.00130.90           C  
ATOM    603  C   THR A  90      21.195  -3.566  29.933  1.00140.11           C  
ATOM    604  O   THR A  90      20.356  -4.468  29.896  1.00145.57           O  
ATOM    605  CB  THR A  90      20.764  -1.786  28.200  1.00127.18           C  
ATOM    606  OG1 THR A  90      20.142  -0.513  27.984  1.00121.02           O  
ATOM    607  CG2 THR A  90      19.968  -2.853  27.451  1.00113.80           C  
ATOM    608  N   ARG A  91      22.489  -3.777  30.172  1.00147.56           N  
ATOM    609  CA  ARG A  91      23.061  -5.099  30.434  1.00147.68           C  
ATOM    610  C   ARG A  91      23.122  -5.252  31.951  1.00147.13           C  
ATOM    611  O   ARG A  91      24.192  -5.422  32.527  1.00146.38           O  
ATOM    612  CB  ARG A  91      24.477  -5.194  29.839  1.00149.95           C  
ATOM    613  CG  ARG A  91      25.257  -6.469  30.181  1.00146.61           C  
ATOM    614  CD  ARG A  91      24.792  -7.671  29.376  1.00148.77           C  
ATOM    615  NE  ARG A  91      25.532  -7.829  28.125  1.00150.52           N  
ATOM    616  CZ  ARG A  91      26.805  -8.212  28.047  1.00150.52           C  
ATOM    617  NH1 ARG A  91      27.492  -8.478  29.152  1.00150.52           N  
ATOM    618  NH2 ARG A  91      27.393  -8.335  26.862  1.00150.52           N  
ATOM    619  N   GLU A  92      21.959  -5.166  32.588  1.00148.80           N  
ATOM    620  CA  GLU A  92      21.830  -5.277  34.038  1.00150.31           C  
ATOM    621  C   GLU A  92      20.398  -4.885  34.387  1.00150.52           C  
ATOM    622  O   GLU A  92      19.859  -5.289  35.420  1.00149.99           O  
ATOM    623  CB  GLU A  92      22.819  -4.334  34.739  1.00147.51           C  
ATOM    624  CG  GLU A  92      22.669  -2.869  34.354  1.00149.82           C  
ATOM    625  CD  GLU A  92      21.485  -2.195  35.025  1.00150.52           C  
ATOM    626  OE1 GLU A  92      21.120  -1.076  34.609  1.00150.25           O  
ATOM    627  OE2 GLU A  92      20.925  -2.780  35.975  1.00150.52           O  
ATOM    628  N   GLY A  93      19.796  -4.092  33.505  1.00149.15           N  
ATOM    629  CA  GLY A  93      18.433  -3.627  33.691  1.00142.04           C  
ATOM    630  C   GLY A  93      17.893  -2.999  32.417  1.00134.78           C  
ATOM    631  O   GLY A  93      17.654  -3.707  31.435  1.00139.18           O  
ATOM    632  N   GLU A  94      17.698  -1.679  32.425  1.00123.21           N  
ATOM    633  CA  GLU A  94      17.189  -0.970  31.250  1.00112.05           C  
ATOM    634  C   GLU A  94      17.083   0.561  31.386  1.00109.81           C  
ATOM    635  O   GLU A  94      16.156   1.083  32.009  1.00105.15           O  
ATOM    636  CB  GLU A  94      15.836  -1.545  30.841  1.00105.73           C  
ATOM    637  N   LYS A  95      18.048   1.254  30.779  1.00104.62           N  
ATOM    638  CA  LYS A  95      18.151   2.719  30.737  1.00 92.81           C  
ATOM    639  C   LYS A  95      18.119   3.550  32.013  1.00 84.07           C  
ATOM    640  O   LYS A  95      17.079   3.716  32.648  1.00 85.70           O  
ATOM    641  CB  LYS A  95      17.124   3.289  29.754  1.00 97.25           C  
ATOM    642  CG  LYS A  95      17.621   3.329  28.311  1.00106.07           C  
ATOM    643  CD  LYS A  95      16.589   3.952  27.377  1.00110.75           C  
ATOM    644  CE  LYS A  95      17.111   4.071  25.948  1.00110.29           C  
ATOM    645  NZ  LYS A  95      16.095   4.663  25.028  1.00109.85           N  
ATOM    646  N   ARG A  96      19.282   4.106  32.343  1.00 79.63           N  
ATOM    647  CA  ARG A  96      19.459   4.952  33.518  1.00 71.70           C  
ATOM    648  C   ARG A  96      20.137   6.264  33.104  1.00 65.11           C  
ATOM    649  O   ARG A  96      21.032   6.271  32.253  1.00 52.40           O  
ATOM    650  CB  ARG A  96      20.324   4.247  34.565  1.00 59.43           C  
ATOM    651  CG  ARG A  96      20.315   4.951  35.910  1.00 81.35           C  
ATOM    652  CD  ARG A  96      21.431   4.495  36.832  1.00 62.66           C  
ATOM    653  NE  ARG A  96      21.318   5.152  38.128  1.00 65.29           N  
ATOM    654  CZ  ARG A  96      22.249   5.115  39.076  1.00 72.15           C  
ATOM    655  NH1 ARG A  96      23.376   4.449  38.871  1.00 74.82           N  
ATOM    656  NH2 ARG A  96      22.049   5.744  40.227  1.00 65.30           N  
ATOM    657  N   THR A  97      19.705   7.364  33.717  1.00 51.59           N  
ATOM    658  CA  THR A  97      20.241   8.685  33.426  1.00 39.31           C  
ATOM    659  C   THR A  97      20.630   9.382  34.716  1.00 47.58           C  
ATOM    660  O   THR A  97      19.930   9.279  35.719  1.00 54.56           O  
ATOM    661  CB  THR A  97      19.195   9.574  32.736  1.00 35.05           C  
ATOM    662  OG1 THR A  97      19.837  10.698  32.134  1.00 37.97           O  
ATOM    663  CG2 THR A  97      18.206  10.110  33.746  1.00 40.46           C  
ATOM    664  N   VAL A  98      21.745  10.095  34.697  1.00 47.64           N  
ATOM    665  CA  VAL A  98      22.167  10.825  35.883  1.00 55.73           C  
ATOM    666  C   VAL A  98      22.726  12.160  35.438  1.00 57.36           C  
ATOM    667  O   VAL A  98      23.167  12.310  34.300  1.00 58.39           O  
ATOM    668  CB  VAL A  98      23.182  10.011  36.723  1.00 56.70           C  
ATOM    669  CG1 VAL A  98      23.860  10.896  37.763  1.00 53.34           C  
ATOM    670  CG2 VAL A  98      22.434   8.890  37.440  1.00 42.84           C  
ATOM    671  N   ILE A  99      22.693  13.136  36.335  1.00 54.42           N  
ATOM    672  CA  ILE A  99      23.139  14.467  35.995  1.00 40.40           C  
ATOM    673  C   ILE A  99      23.993  15.076  37.110  1.00 39.94           C  
ATOM    674  O   ILE A  99      23.827  14.731  38.283  1.00 47.31           O  
ATOM    675  CB  ILE A  99      21.876  15.311  35.672  1.00 42.26           C  
ATOM    676  CG1 ILE A  99      22.148  16.222  34.486  1.00 64.07           C  
ATOM    677  CG2 ILE A  99      21.404  16.070  36.895  1.00 51.40           C  
ATOM    678  CD1 ILE A  99      20.872  16.660  33.779  1.00 73.34           C  
ATOM    679  N   GLU A 100      24.924  15.956  36.739  1.00 33.10           N  
ATOM    680  CA  GLU A 100      25.810  16.602  37.715  1.00 39.61           C  
ATOM    681  C   GLU A 100      26.185  17.988  37.217  1.00 35.75           C  
ATOM    682  O   GLU A 100      26.176  18.242  36.019  1.00 41.66           O  
ATOM    683  CB  GLU A 100      27.087  15.767  37.957  1.00 29.79           C  
ATOM    684  CG  GLU A 100      27.990  15.575  36.736  1.00 58.83           C  
ATOM    685  CD  GLU A 100      29.249  14.734  37.019  1.00 74.56           C  
ATOM    686  OE1 GLU A 100      29.131  13.566  37.458  1.00 59.32           O  
ATOM    687  OE2 GLU A 100      30.368  15.244  36.790  1.00 74.31           O  
ATOM    688  N   VAL A 101      26.505  18.886  38.138  1.00 34.98           N  
ATOM    689  CA  VAL A 101      26.866  20.250  37.778  1.00 32.93           C  
ATOM    690  C   VAL A 101      28.346  20.551  38.008  1.00 24.39           C  
ATOM    691  O   VAL A 101      28.832  20.484  39.132  1.00 42.39           O  
ATOM    692  CB  VAL A 101      25.996  21.266  38.575  1.00 46.17           C  
ATOM    693  CG1 VAL A 101      26.548  22.684  38.432  1.00 38.65           C  
ATOM    694  CG2 VAL A 101      24.556  21.215  38.070  1.00 46.89           C  
ATOM    695  N   GLU A 102      29.065  20.845  36.930  1.00 27.74           N  
ATOM    696  CA  GLU A 102      30.479  21.193  37.032  1.00 34.57           C  
ATOM    697  C   GLU A 102      30.436  22.669  37.417  1.00 40.19           C  
ATOM    698  O   GLU A 102      30.131  23.530  36.583  1.00 41.49           O  
ATOM    699  CB  GLU A 102      31.204  21.027  35.682  1.00 23.73           C  
ATOM    700  CG  GLU A 102      31.467  19.589  35.243  1.00 40.18           C  
ATOM    701  CD  GLU A 102      32.436  19.495  34.053  1.00 61.91           C  
ATOM    702  OE1 GLU A 102      32.172  18.688  33.135  1.00 57.56           O  
ATOM    703  OE2 GLU A 102      33.463  20.219  34.041  1.00 42.58           O  
ATOM    704  N   VAL A 103      30.727  22.954  38.681  1.00 33.90           N  
ATOM    705  CA  VAL A 103      30.673  24.316  39.199  1.00 32.86           C  
ATOM    706  C   VAL A 103      31.772  25.276  38.757  1.00 39.70           C  
ATOM    707  O   VAL A 103      32.955  25.041  39.001  1.00 51.21           O  
ATOM    708  CB  VAL A 103      30.650  24.302  40.745  1.00 37.36           C  
ATOM    709  CG1 VAL A 103      30.446  25.704  41.276  1.00 30.36           C  
ATOM    710  CG2 VAL A 103      29.546  23.388  41.238  1.00 34.72           C  
ATOM    711  N   ASP A 104      31.361  26.371  38.121  1.00 36.41           N  
ATOM    712  CA  ASP A 104      32.287  27.405  37.674  1.00 38.13           C  
ATOM    713  C   ASP A 104      32.511  28.369  38.834  1.00 39.14           C  
ATOM    714  O   ASP A 104      33.644  28.638  39.220  1.00 57.00           O  
ATOM    715  CB  ASP A 104      31.711  28.166  36.473  1.00 37.39           C  
ATOM    716  CG  ASP A 104      31.768  27.357  35.192  1.00 56.54           C  
ATOM    717  OD1 ASP A 104      32.863  26.837  34.879  1.00 57.79           O  
ATOM    718  OD2 ASP A 104      30.729  27.245  34.499  1.00 59.31           O  
ATOM    719  N   GLU A 105      31.420  28.888  39.386  1.00 48.17           N  
ATOM    720  CA  GLU A 105      31.491  29.809  40.513  1.00 46.61           C  
ATOM    721  C   GLU A 105      30.405  29.437  41.513  1.00 38.78           C  
ATOM    722  O   GLU A 105      29.312  28.987  41.144  1.00 36.22           O  
ATOM    723  CB  GLU A 105      31.275  31.258  40.073  1.00 44.78           C  
ATOM    724  CG  GLU A 105      32.223  31.790  39.018  1.00 51.46           C  
ATOM    725  CD  GLU A 105      33.519  32.337  39.592  1.00 67.19           C  
ATOM    726  OE1 GLU A 105      33.481  32.952  40.678  1.00 49.30           O  
ATOM    727  OE2 GLU A 105      34.575  32.173  38.938  1.00 61.88           O  
ATOM    728  N   ILE A 106      30.727  29.643  42.780  1.00 35.01           N  
ATOM    729  CA  ILE A 106      29.839  29.353  43.888  1.00 42.33           C  
ATOM    730  C   ILE A 106      30.262  30.239  45.028  1.00 42.51           C  
ATOM    731  O   ILE A 106      31.450  30.535  45.187  1.00 37.78           O  
ATOM    732  CB  ILE A 106      29.986  27.912  44.380  1.00 45.93           C  
ATOM    733  CG1 ILE A 106      29.090  27.698  45.594  1.00 22.55           C  
ATOM    734  CG2 ILE A 106      31.434  27.643  44.761  1.00 42.26           C  
ATOM    735  CD1 ILE A 106      29.051  26.278  46.088  1.00 19.12           C  
ATOM    736  N   GLY A 107      29.290  30.645  45.829  1.00 47.31           N  
ATOM    737  CA  GLY A 107      29.581  31.498  46.962  1.00 40.25           C  
ATOM    738  C   GLY A 107      28.380  31.499  47.873  1.00 42.73           C  
ATOM    739  O   GLY A 107      27.251  31.325  47.400  1.00 56.41           O  
ATOM    740  N   PRO A 108      28.582  31.671  49.187  1.00 41.19           N  
ATOM    741  CA  PRO A 108      27.438  31.677  50.100  1.00 38.30           C  
ATOM    742  C   PRO A 108      26.555  32.867  49.793  1.00 25.85           C  
ATOM    743  O   PRO A 108      27.055  33.955  49.559  1.00 35.42           O  
ATOM    744  CB  PRO A 108      28.098  31.772  51.473  1.00 41.47           C  
ATOM    745  CG  PRO A 108      29.368  32.544  51.197  1.00 27.74           C  
ATOM    746  CD  PRO A 108      29.844  31.895  49.918  1.00 38.65           C  
ATOM    747  N   SER A 109      25.244  32.656  49.769  1.00 38.95           N  
ATOM    748  CA  SER A 109      24.311  33.741  49.479  1.00 32.69           C  
ATOM    749  C   SER A 109      24.094  34.654  50.684  1.00 38.76           C  
ATOM    750  O   SER A 109      23.986  34.181  51.822  1.00 22.86           O  
ATOM    751  CB  SER A 109      22.965  33.167  49.028  1.00 32.15           C  
ATOM    752  OG  SER A 109      21.945  34.154  49.027  1.00 25.18           O  
ATOM    753  N   LEU A 110      24.017  35.959  50.422  1.00 37.99           N  
ATOM    754  CA  LEU A 110      23.794  36.954  51.470  1.00 37.20           C  
ATOM    755  C   LEU A 110      22.335  37.415  51.559  1.00 41.13           C  
ATOM    756  O   LEU A 110      22.069  38.587  51.798  1.00 39.69           O  
ATOM    757  CB  LEU A 110      24.669  38.178  51.221  1.00 38.06           C  
ATOM    758  CG  LEU A 110      26.177  37.991  51.094  1.00 25.12           C  
ATOM    759  CD1 LEU A 110      26.781  39.347  50.849  1.00 33.64           C  
ATOM    760  CD2 LEU A 110      26.762  37.365  52.357  1.00 28.67           C  
ATOM    761  N   ARG A 111      21.389  36.503  51.371  1.00 45.98           N  
ATOM    762  CA  ARG A 111      19.981  36.878  51.441  1.00 43.33           C  
ATOM    763  C   ARG A 111      19.472  36.766  52.869  1.00 35.03           C  
ATOM    764  O   ARG A 111      18.694  37.596  53.320  1.00 46.16           O  
ATOM    765  CB  ARG A 111      19.154  35.989  50.509  1.00 48.82           C  
ATOM    766  CG  ARG A 111      17.692  36.363  50.381  1.00 39.40           C  
ATOM    767  CD  ARG A 111      17.068  35.536  49.277  1.00 57.21           C  
ATOM    768  NE  ARG A 111      15.615  35.643  49.215  1.00 70.99           N  
ATOM    769  CZ  ARG A 111      14.880  35.192  48.201  1.00 79.72           C  
ATOM    770  NH1 ARG A 111      15.463  34.609  47.157  1.00 71.25           N  
ATOM    771  NH2 ARG A 111      13.559  35.308  48.235  1.00 74.06           N  
ATOM    772  N   TYR A 112      19.908  35.734  53.577  1.00 34.33           N  
ATOM    773  CA  TYR A 112      19.497  35.551  54.960  1.00 33.53           C  
ATOM    774  C   TYR A 112      20.741  35.380  55.836  1.00 35.03           C  
ATOM    775  O   TYR A 112      20.747  34.587  56.770  1.00 42.21           O  
ATOM    776  CB  TYR A 112      18.622  34.310  55.092  1.00 28.70           C  
ATOM    777  CG  TYR A 112      17.406  34.308  54.208  1.00 41.72           C  
ATOM    778  CD1 TYR A 112      17.145  33.238  53.365  1.00 35.34           C  
ATOM    779  CD2 TYR A 112      16.495  35.352  54.242  1.00 39.04           C  
ATOM    780  CE1 TYR A 112      15.997  33.197  52.585  1.00 53.34           C  
ATOM    781  CE2 TYR A 112      15.340  35.322  53.464  1.00 55.99           C  
ATOM    782  CZ  TYR A 112      15.095  34.241  52.637  1.00 53.29           C  
ATOM    783  OH  TYR A 112      13.929  34.177  51.897  1.00 40.76           O  
ATOM    784  N   ALA A 113      21.805  36.112  55.538  1.00 29.38           N  
ATOM    785  CA  ALA A 113      23.011  35.959  56.342  1.00 39.83           C  
ATOM    786  C   ALA A 113      24.115  36.921  55.968  1.00 38.46           C  
ATOM    787  O   ALA A 113      23.957  37.770  55.085  1.00 45.12           O  
ATOM    788  CB  ALA A 113      23.529  34.527  56.227  1.00 42.68           C  
ATOM    789  N   THR A 114      25.237  36.778  56.660  1.00 28.34           N  
ATOM    790  CA  THR A 114      26.403  37.605  56.395  1.00 40.68           C  
ATOM    791  C   THR A 114      27.593  36.686  56.348  1.00 38.04           C  
ATOM    792  O   THR A 114      27.478  35.491  56.602  1.00 43.56           O  
ATOM    793  CB  THR A 114      26.652  38.680  57.489  1.00 43.12           C  
ATOM    794  OG1 THR A 114      26.723  38.060  58.784  1.00 43.64           O  
ATOM    795  CG2 THR A 114      25.551  39.726  57.459  1.00 33.35           C  
ATOM    796  N   ALA A 115      28.739  37.245  56.010  1.00 45.02           N  
ATOM    797  CA  ALA A 115      29.944  36.460  55.951  1.00 47.62           C  
ATOM    798  C   ALA A 115      31.100  37.413  55.925  1.00 54.33           C  
ATOM    799  O   ALA A 115      30.984  38.519  55.403  1.00 47.78           O  
ATOM    800  CB  ALA A 115      29.949  35.604  54.700  1.00 59.94           C  
ATOM    801  N   LYS A 116      32.211  36.999  56.515  1.00 60.25           N  
ATOM    802  CA  LYS A 116      33.396  37.828  56.489  1.00 69.33           C  
ATOM    803  C   LYS A 116      34.262  37.235  55.394  1.00 70.22           C  
ATOM    804  O   LYS A 116      34.711  36.091  55.483  1.00 70.55           O  
ATOM    805  CB  LYS A 116      34.094  37.815  57.848  1.00 79.52           C  
ATOM    806  CG  LYS A 116      33.287  38.575  58.897  1.00 99.94           C  
ATOM    807  CD  LYS A 116      34.040  38.804  60.194  1.00 99.36           C  
ATOM    808  CE  LYS A 116      33.202  39.644  61.148  1.00 99.61           C  
ATOM    809  NZ  LYS A 116      33.880  39.889  62.449  1.00110.87           N  
ATOM    810  N   VAL A 117      34.446  38.018  54.338  1.00 64.62           N  
ATOM    811  CA  VAL A 117      35.227  37.596  53.187  1.00 66.59           C  
ATOM    812  C   VAL A 117      36.693  37.993  53.325  1.00 70.60           C  
ATOM    813  O   VAL A 117      37.030  39.172  53.273  1.00 70.33           O  
ATOM    814  CB  VAL A 117      34.648  38.216  51.892  1.00 67.89           C  
ATOM    815  CG1 VAL A 117      35.520  37.864  50.700  1.00 66.67           C  
ATOM    816  CG2 VAL A 117      33.222  37.723  51.679  1.00 66.29           C  
ATOM    817  N   ASN A 118      37.559  36.998  53.495  1.00 75.36           N  
ATOM    818  CA  ASN A 118      38.990  37.241  53.642  1.00 87.25           C  
ATOM    819  C   ASN A 118      39.741  36.991  52.332  1.00 95.50           C  
ATOM    820  O   ASN A 118      39.797  35.858  51.852  1.00104.12           O  
ATOM    821  CB  ASN A 118      39.553  36.351  54.744  1.00 61.71           C  
ATOM    822  N   LYS A 119      40.314  38.051  51.759  1.00104.98           N  
ATOM    823  CA  LYS A 119      41.064  37.947  50.505  1.00103.72           C  
ATOM    824  C   LYS A 119      42.309  37.083  50.640  1.00107.63           C  
ATOM    825  O   LYS A 119      42.461  36.311  51.586  1.00104.33           O  
ATOM    826  CB  LYS A 119      41.523  39.324  50.017  1.00105.54           C  
ATOM    827  CG  LYS A 119      40.546  40.121  49.172  1.00108.51           C  
ATOM    828  CD  LYS A 119      41.329  41.127  48.323  1.00108.68           C  
ATOM    829  CE  LYS A 119      40.757  42.535  48.389  1.00112.60           C  
ATOM    830  NZ  LYS A 119      41.675  43.526  47.747  1.00111.14           N  
ATOM    831  N   ALA A 120      43.207  37.249  49.673  1.00112.32           N  
ATOM    832  CA  ALA A 120      44.473  36.529  49.626  1.00119.59           C  
ATOM    833  C   ALA A 120      45.408  37.208  48.622  1.00124.41           C  
ATOM    834  O   ALA A 120      46.508  37.640  49.034  1.00124.93           O  
ATOM    835  CB  ALA A 120      44.236  35.075  49.231  1.00121.32           C  
TER     836      ALA A 120                                                      
END
MOLECULE T0491.pdb
ATOM      1  CB  MET     1      24.494  26.786  25.043  1.00 74.26      A   
ATOM      2  CG  MET     1      23.701  27.585  26.072  1.00 83.32      A   
ATOM      3  SD  MET     1      24.779  28.804  27.139  1.00101.46      A   
ATOM      4  CE  MET     1      25.295  30.073  25.774  1.00 95.61      A   
ATOM      5  C   MET     1      25.321  25.000  26.603  1.00 28.93      A   
ATOM      6  O   MET     1      24.649  24.022  26.272  1.00 27.36      A   
ATOM      7  N   MET     1      26.470  25.414  24.459  1.00 32.31      A   
ATOM      8  CA  MET     1      25.731  26.058  25.583  1.00 34.03      A   
ATOM      9  N   ASN     2      25.748  25.199  27.844  1.00 27.92      A   
ATOM     10  CA  ASN     2      25.434  24.272  28.928  1.00 26.69      A   
ATOM     11  CB  ASN     2      26.294  23.018  28.793  1.00 24.03      A   
ATOM     12  CG  ASN     2      26.048  22.008  29.900  1.00 24.02      A   
ATOM     13  OD1 ASN     2      25.221  22.214  30.793  1.00 23.82      A   
ATOM     14  ND2 ASN     2      26.771  20.899  29.840  1.00 20.34      A   
ATOM     15  C   ASN     2      25.750  24.978  30.234  1.00 24.38      A   
ATOM     16  O   ASN     2      26.841  24.844  30.755  1.00 24.74      A   
ATOM     17  N   THR     3      24.797  25.741  30.750  1.00 21.49      A   
ATOM     18  CA  THR     3      25.026  26.468  31.987  1.00 24.29      A   
ATOM     19  CB  THR     3      25.575  27.893  31.722  1.00 27.90      A   
ATOM     20  OG1 THR     3      25.660  28.614  32.964  1.00 31.66      A   
ATOM     21  CG2 THR     3      24.655  28.654  30.771  1.00 28.43      A   
ATOM     22  C   THR     3      23.798  26.589  32.865  1.00 23.19      A   
ATOM     23  O   THR     3      22.763  27.126  32.470  1.00 25.48      A   
ATOM     24  N   LEU     4      23.934  26.069  34.073  1.00 23.57      A   
ATOM     25  CA  LEU     4      22.876  26.123  35.060  1.00 22.87      A   
ATOM     26  CB  LEU     4      22.698  24.767  35.738  1.00 24.04      A   
ATOM     27  CG  LEU     4      21.742  24.754  36.940  1.00 23.22      A   
ATOM     28  CD1 LEU     4      20.290  24.831  36.473  1.00 21.74      A   
ATOM     29  CD2 LEU     4      21.934  23.474  37.721  1.00 22.90      A   
ATOM     30  C   LEU     4      23.257  27.132  36.127  1.00 25.19      A   
ATOM     31  O   LEU     4      24.405  27.148  36.591  1.00 26.88      A   
ATOM     32  N   GLU     5      22.305  27.977  36.505  1.00 23.62      A   
ATOM     33  CA  GLU     5      22.514  28.944  37.578  1.00 25.83      A   
ATOM     34  CB  GLU     5      22.287  30.373  37.090  1.00 40.19      A   
ATOM     35  CG  GLU     5      23.504  30.937  36.383  1.00 46.33      A   
ATOM     36  CD  GLU     5      23.285  32.346  35.896  1.00 49.75      A   
ATOM     37  OE1 GLU     5      22.490  33.076  36.533  1.00 51.69      A   
ATOM     38  OE2 GLU     5      23.920  32.725  34.888  1.00 51.36      A   
ATOM     39  C   GLU     5      21.471  28.546  38.603  1.00 23.17      A   
ATOM     40  O   GLU     5      20.295  28.409  38.282  1.00 24.66      A   
ATOM     41  N   LEU     6      21.903  28.348  39.839  1.00 25.06      A   
ATOM     42  CA  LEU     6      20.999  27.892  40.873  1.00 23.09      A   
ATOM     43  CB  LEU     6      21.109  26.372  40.969  1.00 24.01      A   
ATOM     44  CG  LEU     6      20.122  25.610  41.845  1.00 25.36      A   
ATOM     45  CD1 LEU     6      18.801  25.483  41.105  1.00 22.71      A   
ATOM     46  CD2 LEU     6      20.682  24.216  42.139  1.00 28.71      A   
ATOM     47  C   LEU     6      21.297  28.479  42.240  1.00 24.57      A   
ATOM     48  O   LEU     6      22.462  28.697  42.585  1.00 23.80      A   
ATOM     49  N   SER     7      20.243  28.719  43.017  1.00 23.82      A   
ATOM     50  CA  SER     7      20.406  29.213  44.377  1.00 26.53      A   
ATOM     51  CB  SER     7      19.457  30.382  44.667  1.00 28.18      A   
ATOM     52  OG  SER     7      18.107  29.985  44.524  1.00 32.55      A   
ATOM     53  C   SER     7      20.038  28.003  45.233  1.00 26.53      A   
ATOM     54  O   SER     7      19.038  27.338  44.976  1.00 27.01      A   
ATOM     55  N   ALA     8      20.830  27.715  46.255  1.00 26.33      A   
ATOM     56  CA  ALA     8      20.552  26.541  47.062  1.00 26.48      A   
ATOM     57  CB  ALA     8      21.060  25.300  46.331  1.00 24.59      A   
ATOM     58  C   ALA     8      21.137  26.577  48.456  1.00 28.39      A   
ATOM     59  O   ALA     8      21.896  27.480  48.816  1.00 28.01      A   
ATOM     60  N   ARG     9      20.764  25.563  49.227  1.00 24.68      A   
ATOM     61  CA  ARG     9      21.223  25.391  50.591  1.00 27.29      A   
ATOM     62  CB  ARG     9      20.004  25.199  51.497  1.00 59.09      A   
ATOM     63  CG  ARG     9      20.307  24.858  52.937  1.00 65.71      A   
ATOM     64  CD  ARG     9      19.394  23.737  53.436  1.00 70.65      A   
ATOM     65  NE  ARG     9      18.032  23.854  52.913  1.00 73.40      A   
ATOM     66  CZ  ARG     9      17.078  22.946  53.109  1.00 74.78      A   
ATOM     67  NH1 ARG     9      17.329  21.852  53.819  1.00 74.28      A   
ATOM     68  NH2 ARG     9      15.874  23.121  52.578  1.00 75.97      A   
ATOM     69  C   ARG     9      22.088  24.130  50.595  1.00 25.32      A   
ATOM     70  O   ARG     9      21.748  23.150  49.930  1.00 23.53      A   
ATOM     71  N   VAL    10      23.209  24.157  51.314  1.00 26.68      A   
ATOM     72  CA  VAL    10      24.075  22.985  51.396  1.00 26.58      A   
ATOM     73  CB  VAL    10      25.467  23.332  51.942  1.00 27.91      A   
ATOM     74  CG1 VAL    10      26.304  22.056  52.069  1.00 29.79      A   
ATOM     75  CG2 VAL    10      26.158  24.320  51.008  1.00 26.57      A   
ATOM     76  C   VAL    10      23.454  21.954  52.320  1.00 27.37      A   
ATOM     77  O   VAL    10      23.337  22.172  53.528  1.00 30.15      A   
ATOM     78  N   LEU    11      23.064  20.825  51.749  1.00 27.52      A   
ATOM     79  CA  LEU    11      22.444  19.759  52.517  1.00 27.26      A   
ATOM     80  CB  LEU    11      21.413  19.040  51.651  1.00 27.95      A   
ATOM     81  CG  LEU    11      20.469  18.035  52.310  1.00 31.34      A   
ATOM     82  CD1 LEU    11      19.627  18.705  53.403  1.00 31.87      A   
ATOM     83  CD2 LEU    11      19.572  17.470  51.226  1.00 29.70      A   
ATOM     84  C   LEU    11      23.475  18.765  53.031  1.00 26.39      A   
ATOM     85  O   LEU    11      23.264  18.113  54.036  1.00 26.52      A   
ATOM     86  N   GLU    12      24.581  18.636  52.311  1.00 26.78      A   
ATOM     87  CA  GLU    12      25.654  17.731  52.694  1.00 26.21      A   
ATOM     88  CB  GLU    12      25.364  16.296  52.219  1.00 37.59      A   
ATOM     89  CG  GLU    12      26.547  15.339  52.386  1.00 41.96      A   
ATOM     90  CD  GLU    12      26.179  13.871  52.173  1.00 46.60      A   
ATOM     91  OE1 GLU    12      25.409  13.570  51.235  1.00 47.54      A   
ATOM     92  OE2 GLU    12      26.678  13.012  52.938  1.00 48.21      A   
ATOM     93  C   GLU    12      26.919  18.255  52.041  1.00 24.78      A   
ATOM     94  O   GLU    12      26.881  18.759  50.910  1.00 21.33      A   
ATOM     95  N   CYS    13      28.031  18.172  52.760  1.00 24.07      A   
ATOM     96  CA  CYS    13      29.304  18.648  52.237  1.00 25.07      A   
ATOM     97  CB  CYS    13      29.699  19.967  52.912  1.00 27.16      A   
ATOM     98  SG  CYS    13      31.211  20.744  52.267  1.00 28.15      A   
ATOM     99  C   CYS    13      30.338  17.584  52.520  1.00 27.03      A   
ATOM    100  O   CYS    13      30.720  17.369  53.671  1.00 29.10      A   
ATOM    101  N   GLY    14      30.788  16.910  51.467  1.00 31.16      A   
ATOM    102  CA  GLY    14      31.763  15.850  51.634  1.00 32.73      A   
ATOM    103  C   GLY    14      33.106  16.283  52.187  1.00 33.43      A   
ATOM    104  O   GLY    14      33.356  17.472  52.401  1.00 32.99      A   
ATOM    105  N   ALA    15      33.968  15.307  52.450  1.00 30.50      A   
ATOM    106  CA  ALA    15      35.301  15.600  52.948  1.00 31.73      A   
ATOM    107  CB  ALA    15      35.849  14.383  53.713  1.00 43.10      A   
ATOM    108  C   ALA    15      36.195  15.931  51.743  1.00 31.06      A   
ATOM    109  O   ALA    15      35.925  15.500  50.621  1.00 30.10      A   
ATOM    110  N   MET    16      37.248  16.706  51.974  1.00 33.75      A   
ATOM    111  CA  MET    16      38.175  17.079  50.909  1.00 34.44      A   
ATOM    112  CB  MET    16      39.190  18.088  51.437  1.00 36.40      A   
ATOM    113  CG  MET    16      40.158  18.580  50.380  1.00 42.50      A   
ATOM    114  SD  MET    16      39.215  19.523  48.978  1.00 51.77      A   
ATOM    115  CE  MET    16      39.181  21.260  49.790  1.00 42.94      A   
ATOM    116  C   MET    16      38.932  15.864  50.372  1.00 34.78      A   
ATOM    117  O   MET    16      39.434  15.055  51.147  1.00 35.45      A   
ATOM    118  N   ARG    17      39.010  15.730  49.050  1.00 31.64      A   
ATOM    119  CA  ARG    17      39.746  14.626  48.430  1.00 32.60      A   
ATOM    120  CB  ARG    17      38.805  13.684  47.663  1.00 45.02      A   
ATOM    121  CG  ARG    17      37.628  13.162  48.453  1.00 51.95      A   
ATOM    122  CD  ARG    17      36.742  12.282  47.579  1.00 58.07      A   
ATOM    123  NE  ARG    17      36.175  12.984  46.421  1.00 62.07      A   
ATOM    124  CZ  ARG    17      35.360  14.037  46.491  1.00 63.33      A   
ATOM    125  NH1 ARG    17      34.996  14.533  47.668  1.00 65.34      A   
ATOM    126  NH2 ARG    17      34.912  14.609  45.380  1.00 63.27      A   
ATOM    127  C   ARG    17      40.705  15.276  47.437  1.00 31.59      A   
ATOM    128  O   ARG    17      40.657  16.490  47.235  1.00 29.81      A   
ATOM    129  N   HIS    18      41.579  14.483  46.829  1.00 31.03      A   
ATOM    130  CA  HIS    18      42.501  15.013  45.835  1.00 30.31      A   
ATOM    131  CB  HIS    18      43.885  15.278  46.431  1.00 30.18      A   
ATOM    132  CG  HIS    18      43.891  16.339  47.478  1.00 27.06      A   
ATOM    133  CD2 HIS    18      44.146  17.666  47.400  1.00 25.93      A   
ATOM    134  ND1 HIS    18      43.549  16.089  48.787  1.00 26.80      A   
ATOM    135  CE1 HIS    18      43.592  17.217  49.473  1.00 27.01      A   
ATOM    136  NE2 HIS    18      43.951  18.189  48.654  1.00 26.49      A   
ATOM    137  C   HIS    18      42.649  14.033  44.700  1.00 30.86      A   
ATOM    138  O   HIS    18      42.610  12.822  44.903  1.00 29.79      A   
ATOM    139  N   THR    19      42.797  14.569  43.498  1.00 31.93      A   
ATOM    140  CA  THR    19      42.999  13.738  42.333  1.00 32.14      A   
ATOM    141  CB  THR    19      42.770  14.536  41.041  1.00 33.79      A   
ATOM    142  OG1 THR    19      43.730  15.601  40.957  1.00 33.43      A   
ATOM    143  CG2 THR    19      41.351  15.112  41.018  1.00 30.25      A   
ATOM    144  C   THR    19      44.467  13.305  42.404  1.00 32.81      A   
ATOM    145  O   THR    19      45.213  13.776  43.263  1.00 31.81      A   
ATOM    146  N   PRO    20      44.894  12.387  41.518  1.00 35.99      A   
ATOM    147  CD  PRO    20      44.089  11.552  40.605  1.00 38.03      A   
ATOM    148  CA  PRO    20      46.290  11.934  41.533  1.00 34.64      A   
ATOM    149  CB  PRO    20      46.335  10.915  40.400  1.00 36.73      A   
ATOM    150  CG  PRO    20      44.959  10.318  40.452  1.00 40.37      A   
ATOM    151  C   PRO    20      47.268  13.077  41.308  1.00 33.24      A   
ATOM    152  O   PRO    20      48.397  13.034  41.795  1.00 33.18      A   
ATOM    153  N   ALA    21      46.838  14.088  40.556  1.00 28.39      A   
ATOM    154  CA  ALA    21      47.687  15.246  40.285  1.00 26.67      A   
ATOM    155  CB  ALA    21      47.260  15.941  39.000  1.00 30.23      A   
ATOM    156  C   ALA    21      47.613  16.230  41.450  1.00 26.44      A   
ATOM    157  O   ALA    21      48.135  17.344  41.361  1.00 26.22      A   
ATOM    158  N   GLY    22      46.942  15.824  42.528  1.00 28.68      A   
ATOM    159  CA  GLY    22      46.829  16.670  43.709  1.00 26.14      A   
ATOM    160  C   GLY    22      45.780  17.777  43.657  1.00 28.37      A   
ATOM    161  O   GLY    22      45.741  18.655  44.524  1.00 26.71      A   
ATOM    162  N   LEU    23      44.932  17.758  42.640  1.00 25.27      A   
ATOM    163  CA  LEU    23      43.883  18.767  42.538  1.00 27.04      A   
ATOM    164  CB  LEU    23      43.262  18.705  41.144  1.00 36.58      A   
ATOM    165  CG  LEU    23      42.296  19.803  40.693  1.00 40.73      A   
ATOM    166  CD1 LEU    23      42.848  21.197  41.031  1.00 40.54      A   
ATOM    167  CD2 LEU    23      42.086  19.653  39.190  1.00 40.02      A   
ATOM    168  C   LEU    23      42.804  18.542  43.619  1.00 27.04      A   
ATOM    169  O   LEU    23      42.299  17.430  43.788  1.00 26.83      A   
ATOM    170  N   PRO    24      42.457  19.588  44.392  1.00 26.02      A   
ATOM    171  CD  PRO    24      43.071  20.917  44.540  1.00 33.80      A   
ATOM    172  CA  PRO    24      41.424  19.366  45.414  1.00 25.32      A   
ATOM    173  CB  PRO    24      41.406  20.682  46.200  1.00 34.41      A   
ATOM    174  CG  PRO    24      41.988  21.680  45.246  1.00 35.64      A   
ATOM    175  C   PRO    24      40.082  19.031  44.770  1.00 23.75      A   
ATOM    176  O   PRO    24      39.735  19.570  43.725  1.00 22.81      A   
ATOM    177  N   ALA    25      39.337  18.125  45.388  1.00 23.67      A   
ATOM    178  CA  ALA    25      38.056  17.700  44.842  1.00 25.97      A   
ATOM    179  CB  ALA    25      38.209  16.362  44.128  1.00 30.92      A   
ATOM    180  C   ALA    25      37.048  17.578  45.962  1.00 25.13      A   
ATOM    181  O   ALA    25      37.319  16.978  46.994  1.00 25.71      A   
ATOM    182  N   LEU    26      35.865  18.135  45.742  1.00 25.68      A   
ATOM    183  CA  LEU    26      34.833  18.115  46.765  1.00 25.29      A   
ATOM    184  CB  LEU    26      34.834  19.465  47.486  1.00 25.63      A   
ATOM    185  CG  LEU    26      33.739  19.749  48.513  1.00 27.37      A   
ATOM    186  CD1 LEU    26      33.997  18.903  49.772  1.00 29.57      A   
ATOM    187  CD2 LEU    26      33.745  21.244  48.858  1.00 28.02      A   
ATOM    188  C   LEU    26      33.448  17.825  46.194  1.00 26.42      A   
ATOM    189  O   LEU    26      33.075  18.346  45.143  1.00 27.62      A   
ATOM    190  N   GLU    27      32.690  16.992  46.898  1.00 23.95      A   
ATOM    191  CA  GLU    27      31.341  16.630  46.477  1.00 27.32      A   
ATOM    192  CB  GLU    27      31.216  15.094  46.439  1.00 50.38      A   
ATOM    193  CG  GLU    27      29.804  14.530  46.600  1.00 58.68      A   
ATOM    194  CD  GLU    27      29.034  14.409  45.289  1.00 62.89      A   
ATOM    195  OE1 GLU    27      29.407  13.553  44.457  1.00 66.03      A   
ATOM    196  OE2 GLU    27      28.057  15.162  45.092  1.00 66.47      A   
ATOM    197  C   GLU    27      30.350  17.226  47.477  1.00 26.08      A   
ATOM    198  O   GLU    27      30.550  17.128  48.687  1.00 24.71      A   
ATOM    199  N   LEU    28      29.303  17.876  46.979  1.00 26.78      A   
ATOM    200  CA  LEU    28      28.299  18.445  47.872  1.00 26.53      A   
ATOM    201  CB  LEU    28      28.413  19.975  47.964  1.00 27.40      A   
ATOM    202  CG  LEU    28      29.738  20.650  48.326  1.00 27.58      A   
ATOM    203  CD1 LEU    28      30.465  21.049  47.038  1.00 28.75      A   
ATOM    204  CD2 LEU    28      29.463  21.884  49.182  1.00 27.49      A   
ATOM    205  C   LEU    28      26.905  18.094  47.382  1.00 24.94      A   
ATOM    206  O   LEU    28      26.715  17.720  46.225  1.00 26.86      A   
ATOM    207  N   LEU    29      25.939  18.208  48.283  1.00 23.67      A   
ATOM    208  CA  LEU    29      24.546  17.948  47.961  1.00 25.26      A   
ATOM    209  CB  LEU    29      23.980  16.847  48.859  1.00 32.81      A   
ATOM    210  CG  LEU    29      22.619  16.271  48.455  1.00 36.98      A   
ATOM    211  CD1 LEU    29      22.643  15.862  46.983  1.00 39.93      A   
ATOM    212  CD2 LEU    29      22.291  15.061  49.329  1.00 38.53      A   
ATOM    213  C   LEU    29      23.811  19.261  48.211  1.00 25.49      A   
ATOM    214  O   LEU    29      23.820  19.794  49.326  1.00 25.02      A   
ATOM    215  N   LEU    30      23.173  19.782  47.171  1.00 25.15      A   
ATOM    216  CA  LEU    30      22.457  21.048  47.272  1.00 24.89      A   
ATOM    217  CB  LEU    30      22.923  21.976  46.151  1.00 25.89      A   
ATOM    218  CG  LEU    30      24.446  22.117  46.006  1.00 27.08      A   
ATOM    219  CD1 LEU    30      24.786  22.905  44.744  1.00 25.50      A   
ATOM    220  CD2 LEU    30      25.035  22.788  47.246  1.00 25.99      A   
ATOM    221  C   LEU    30      20.951  20.854  47.160  1.00 25.18      A   
ATOM    222  O   LEU    30      20.493  19.983  46.426  1.00 23.82      A   
ATOM    223  N   VAL    31      20.184  21.652  47.898  1.00 23.42      A   
ATOM    224  CA  VAL    31      18.731  21.571  47.822  1.00 23.61      A   
ATOM    225  CB  VAL    31      18.115  21.034  49.138  1.00 30.26      A   
ATOM    226  CG1 VAL    31      18.591  21.859  50.313  1.00 32.68      A   
ATOM    227  CG2 VAL    31      16.583  21.037  49.031  1.00 31.06      A   
ATOM    228  C   VAL    31      18.191  22.959  47.489  1.00 24.03      A   
ATOM    229  O   VAL    31      18.484  23.941  48.167  1.00 21.81      A   
ATOM    230  N   HIS    32      17.430  23.033  46.404  1.00 26.38      A   
ATOM    231  CA  HIS    32      16.854  24.282  45.936  1.00 26.95      A   
ATOM    232  CB  HIS    32      17.186  24.467  44.452  1.00 28.09      A   
ATOM    233  CG  HIS    32      16.364  25.515  43.771  1.00 24.39      A   
ATOM    234  CD2 HIS    32      16.612  26.824  43.529  1.00 25.91      A   
ATOM    235  ND1 HIS    32      15.111  25.262  43.257  1.00 28.36      A   
ATOM    236  CE1 HIS    32      14.620  26.367  42.727  1.00 25.17      A   
ATOM    237  NE2 HIS    32      15.510  27.330  42.878  1.00 29.12      A   
ATOM    238  C   HIS    32      15.345  24.302  46.114  1.00 28.72      A   
ATOM    239  O   HIS    32      14.689  23.281  45.933  1.00 29.57      A   
ATOM    240  N   GLU    33      14.803  25.462  46.478  1.00 30.22      A   
ATOM    241  CA  GLU    33      13.356  25.614  46.631  1.00 31.31      A   
ATOM    242  CB  GLU    33      12.914  25.405  48.084  1.00 56.19      A   
ATOM    243  CG  GLU    33      11.397  25.481  48.265  1.00 62.70      A   
ATOM    244  CD  GLU    33      10.952  25.161  49.681  1.00 67.35      A   
ATOM    245  OE1 GLU    33      11.378  25.863  50.626  1.00 70.69      A   
ATOM    246  OE2 GLU    33      10.169  24.200  49.849  1.00 69.26      A   
ATOM    247  C   GLU    33      12.931  27.003  46.171  1.00 31.37      A   
ATOM    248  O   GLU    33      13.559  28.002  46.512  1.00 29.09      A   
ATOM    249  N   SER    34      11.863  27.060  45.385  1.00 32.63      A   
ATOM    250  CA  SER    34      11.370  28.329  44.878  1.00 32.82      A   
ATOM    251  CB  SER    34      12.356  28.929  43.871  1.00 30.99      A   
ATOM    252  OG  SER    34      12.385  28.179  42.669  1.00 27.65      A   
ATOM    253  C   SER    34      10.050  28.103  44.186  1.00 34.11      A   
ATOM    254  O   SER    34       9.665  26.960  43.931  1.00 34.53      A   
ATOM    255  N   GLU    35       9.363  29.196  43.879  1.00 31.65      A   
ATOM    256  CA  GLU    35       8.087  29.133  43.189  1.00 35.16      A   
ATOM    257  CB  GLU    35       7.055  30.018  43.895  1.00 64.06      A   
ATOM    258  CG  GLU    35       6.638  29.524  45.271  1.00 69.41      A   
ATOM    259  CD  GLU    35       5.649  28.378  45.201  1.00 72.73      A   
ATOM    260  OE1 GLU    35       4.592  28.550  44.555  1.00 75.53      A   
ATOM    261  OE2 GLU    35       5.924  27.311  45.795  1.00 75.35      A   
ATOM    262  C   GLU    35       8.346  29.668  41.791  1.00 34.94      A   
ATOM    263  O   GLU    35       9.034  30.674  41.635  1.00 34.58      A   
ATOM    264  N   VAL    36       7.822  28.988  40.779  1.00 35.89      A   
ATOM    265  CA  VAL    36       7.996  29.433  39.401  1.00 37.61      A   
ATOM    266  CB  VAL    36       8.982  28.532  38.621  1.00 33.61      A   
ATOM    267  CG1 VAL    36      10.338  28.512  39.308  1.00 32.75      A   
ATOM    268  CG2 VAL    36       8.426  27.132  38.502  1.00 34.51      A   
ATOM    269  C   VAL    36       6.659  29.434  38.663  1.00 38.71      A   
ATOM    270  O   VAL    36       5.709  28.755  39.062  1.00 38.69      A   
ATOM    271  N   VAL    37       6.590  30.203  37.587  1.00 39.43      A   
ATOM    272  CA  VAL    37       5.372  30.286  36.795  1.00 40.19      A   
ATOM    273  CB  VAL    37       5.102  31.739  36.378  1.00 49.29      A   
ATOM    274  CG1 VAL    37       6.312  32.290  35.638  1.00 50.63      A   
ATOM    275  CG2 VAL    37       3.848  31.811  35.525  1.00 50.21      A   
ATOM    276  C   VAL    37       5.529  29.414  35.553  1.00 40.89      A   
ATOM    277  O   VAL    37       6.507  29.533  34.818  1.00 38.12      A   
ATOM    278  N   GLU    38       4.566  28.528  35.324  1.00 42.38      A   
ATOM    279  CA  GLU    38       4.634  27.638  34.175  1.00 45.57      A   
ATOM    280  CB  GLU    38       4.986  26.229  34.652  1.00 50.02      A   
ATOM    281  CG  GLU    38       5.164  25.214  33.557  1.00 50.17      A   
ATOM    282  CD  GLU    38       5.800  23.942  34.073  1.00 51.94      A   
ATOM    283  OE1 GLU    38       5.411  23.486  35.169  1.00 52.48      A   
ATOM    284  OE2 GLU    38       6.684  23.393  33.385  1.00 51.85      A   
ATOM    285  C   GLU    38       3.333  27.633  33.383  1.00 46.60      A   
ATOM    286  O   GLU    38       2.289  27.217  33.886  1.00 45.91      A   
ATOM    287  N   ALA    39       3.415  28.095  32.137  1.00 66.00      A   
ATOM    288  CA  ALA    39       2.250  28.172  31.268  1.00 67.47      A   
ATOM    289  CB  ALA    39       1.708  26.771  30.984  1.00 62.56      A   
ATOM    290  C   ALA    39       1.193  29.021  31.959  1.00 67.93      A   
ATOM    291  O   ALA    39      -0.003  28.756  31.846  1.00 68.09      A   
ATOM    292  N   GLY    40       1.648  30.039  32.682  1.00 50.35      A   
ATOM    293  CA  GLY    40       0.732  30.919  33.383  1.00 50.51      A   
ATOM    294  C   GLY    40       0.170  30.337  34.663  1.00 51.76      A   
ATOM    295  O   GLY    40      -0.970  30.631  35.025  1.00 52.84      A   
ATOM    296  N   HIS    41       0.949  29.513  35.360  1.00 51.87      A   
ATOM    297  CA  HIS    41       0.475  28.912  36.607  1.00 52.47      A   
ATOM    298  CB  HIS    41      -0.160  27.541  36.330  1.00 71.49      A   
ATOM    299  CG  HIS    41      -1.320  27.592  35.387  1.00 73.74      A   
ATOM    300  CD2 HIS    41      -1.448  27.161  34.110  1.00 74.29      A   
ATOM    301  ND1 HIS    41      -2.525  28.173  35.719  1.00 74.30      A   
ATOM    302  CE1 HIS    41      -3.346  28.098  34.686  1.00 75.45      A   
ATOM    303  NE2 HIS    41      -2.716  27.488  33.697  1.00 74.43      A   
ATOM    304  C   HIS    41       1.594  28.756  37.639  1.00 52.24      A   
ATOM    305  O   HIS    41       2.702  28.355  37.303  1.00 51.82      A   
ATOM    306  N   PRO    42       1.312  29.073  38.913  1.00 59.44      A   
ATOM    307  CD  PRO    42       0.040  29.603  39.440  1.00 62.08      A   
ATOM    308  CA  PRO    42       2.316  28.955  39.980  1.00 59.00      A   
ATOM    309  CB  PRO    42       1.661  29.686  41.149  1.00 62.01      A   
ATOM    310  CG  PRO    42       0.194  29.389  40.935  1.00 61.96      A   
ATOM    311  C   PRO    42       2.647  27.493  40.304  1.00 58.49      A   
ATOM    312  O   PRO    42       1.778  26.620  40.245  1.00 57.97      A   
ATOM    313  N   ARG    43       3.904  27.232  40.647  1.00 45.42      A   
ATOM    314  CA  ARG    43       4.343  25.872  40.949  1.00 45.16      A   
ATOM    315  CB  ARG    43       4.783  25.181  39.655  1.00 63.38      A   
ATOM    316  CG  ARG    43       5.300  23.757  39.816  1.00 67.94      A   
ATOM    317  CD  ARG    43       5.748  23.220  38.463  1.00 69.41      A   
ATOM    318  NE  ARG    43       6.267  21.856  38.528  1.00 71.62      A   
ATOM    319  CZ  ARG    43       7.413  21.510  39.108  1.00 73.06      A   
ATOM    320  NH1 ARG    43       8.178  22.428  39.686  1.00 74.20      A   
ATOM    321  NH2 ARG    43       7.804  20.241  39.096  1.00 72.22      A   
ATOM    322  C   ARG    43       5.485  25.836  41.961  1.00 43.06      A   
ATOM    323  O   ARG    43       6.401  26.650  41.916  1.00 40.53      A   
ATOM    324  N   ARG    44       5.431  24.877  42.871  1.00 42.86      A   
ATOM    325  CA  ARG    44       6.470  24.750  43.880  1.00 41.76      A   
ATOM    326  CB  ARG    44       5.900  24.056  45.119  1.00 80.16      A   
ATOM    327  CG  ARG    44       4.566  24.626  45.605  1.00 86.18      A   
ATOM    328  CD  ARG    44       3.908  23.753  46.665  1.00 89.94      A   
ATOM    329  NE  ARG    44       4.813  23.455  47.768  1.00 94.16      A   
ATOM    330  CZ  ARG    44       4.432  22.910  48.918  1.00 95.74      A   
ATOM    331  NH1 ARG    44       5.325  22.667  49.869  1.00 97.16      A   
ATOM    332  NH2 ARG    44       3.155  22.624  49.118  1.00 96.57      A   
ATOM    333  C   ARG    44       7.605  23.894  43.314  1.00 39.20      A   
ATOM    334  O   ARG    44       7.365  22.771  42.882  1.00 38.72      A   
ATOM    335  N   VAL    45       8.832  24.409  43.303  1.00 31.89      A   
ATOM    336  CA  VAL    45       9.956  23.617  42.808  1.00 30.53      A   
ATOM    337  CB  VAL    45      10.784  24.353  41.715  1.00 48.89      A   
ATOM    338  CG1 VAL    45      11.869  23.422  41.192  1.00 49.73      A   
ATOM    339  CG2 VAL    45       9.891  24.820  40.581  1.00 51.08      A   
ATOM    340  C   VAL    45      10.910  23.307  43.956  1.00 28.97      A   
ATOM    341  O   VAL    45      11.385  24.212  44.638  1.00 29.10      A   
ATOM    342  N   GLU    46      11.169  22.026  44.181  1.00 35.62      A   
ATOM    343  CA  GLU    46      12.113  21.609  45.212  1.00 35.83      A   
ATOM    344  CB  GLU    46      11.406  20.961  46.396  1.00 50.70      A   
ATOM    345  CG  GLU    46      12.377  20.379  47.412  1.00 56.00      A   
ATOM    346  CD  GLU    46      11.755  20.213  48.790  1.00 59.28      A   
ATOM    347  OE1 GLU    46      10.675  19.590  48.894  1.00 59.61      A   
ATOM    348  OE2 GLU    46      12.350  20.708  49.772  1.00 60.11      A   
ATOM    349  C   GLU    46      13.061  20.610  44.562  1.00 33.49      A   
ATOM    350  O   GLU    46      12.681  19.484  44.254  1.00 33.63      A   
ATOM    351  N   LEU    47      14.301  21.032  44.368  1.00 31.55      A   
ATOM    352  CA  LEU    47      15.299  20.201  43.707  1.00 29.40      A   
ATOM    353  CB  LEU    47      15.774  20.916  42.436  1.00 26.79      A   
ATOM    354  CG  LEU    47      16.912  20.320  41.595  1.00 26.96      A   
ATOM    355  CD1 LEU    47      16.414  19.106  40.818  1.00 29.61      A   
ATOM    356  CD2 LEU    47      17.427  21.372  40.624  1.00 26.03      A   
ATOM    357  C   LEU    47      16.514  19.888  44.567  1.00 27.14      A   
ATOM    358  O   LEU    47      17.041  20.759  45.244  1.00 24.59      A   
ATOM    359  N   THR    48      16.955  18.637  44.536  1.00 27.05      A   
ATOM    360  CA  THR    48      18.148  18.238  45.270  1.00 27.97      A   
ATOM    361  CB  THR    48      17.846  17.132  46.290  1.00 29.86      A   
ATOM    362  OG1 THR    48      16.987  17.668  47.301  1.00 30.72      A   
ATOM    363  CG2 THR    48      19.119  16.634  46.949  1.00 27.80      A   
ATOM    364  C   THR    48      19.072  17.738  44.170  1.00 28.24      A   
ATOM    365  O   THR    48      18.683  16.926  43.312  1.00 27.20      A   
ATOM    366  N   ILE    49      20.293  18.247  44.174  1.00 25.73      A   
ATOM    367  CA  ILE    49      21.238  17.880  43.141  1.00 25.79      A   
ATOM    368  CB  ILE    49      21.192  18.916  42.015  1.00 27.68      A   
ATOM    369  CG2 ILE    49      21.423  20.305  42.588  1.00 25.33      A   
ATOM    370  CG1 ILE    49      22.222  18.580  40.936  1.00 31.67      A   
ATOM    371  CD1 ILE    49      21.795  17.477  40.017  1.00 35.55      A   
ATOM    372  C   ILE    49      22.652  17.813  43.685  1.00 25.13      A   
ATOM    373  O   ILE    49      23.056  18.645  44.502  1.00 22.88      A   
ATOM    374  N   SER    50      23.406  16.824  43.226  1.00 25.95      A   
ATOM    375  CA  SER    50      24.784  16.693  43.671  1.00 27.21      A   
ATOM    376  CB  SER    50      25.263  15.247  43.538  1.00 39.72      A   
ATOM    377  OG  SER    50      25.384  14.891  42.179  1.00 49.33      A   
ATOM    378  C   SER    50      25.674  17.616  42.843  1.00 26.32      A   
ATOM    379  O   SER    50      25.502  17.746  41.627  1.00 26.27      A   
ATOM    380  N   ALA    51      26.625  18.259  43.510  1.00 23.67      A   
ATOM    381  CA  ALA    51      27.524  19.173  42.837  1.00 24.76      A   
ATOM    382  CB  ALA    51      27.260  20.593  43.298  1.00 24.09      A   
ATOM    383  C   ALA    51      28.948  18.792  43.150  1.00 26.32      A   
ATOM    384  O   ALA    51      29.249  18.353  44.266  1.00 24.18      A   
ATOM    385  N   VAL    52      29.816  18.962  42.159  1.00 25.72      A   
ATOM    386  CA  VAL    52      31.227  18.656  42.319  1.00 26.52      A   
ATOM    387  CB  VAL    52      31.681  17.537  41.336  1.00 38.51      A   
ATOM    388  CG1 VAL    52      33.196  17.407  41.350  1.00 40.69      A   
ATOM    389  CG2 VAL    52      31.058  16.202  41.742  1.00 39.67      A   
ATOM    390  C   VAL    52      32.049  19.916  42.069  1.00 26.65      A   
ATOM    391  O   VAL    52      31.793  20.675  41.125  1.00 23.27      A   
ATOM    392  N   ALA    53      33.015  20.139  42.951  1.00 24.95      A   
ATOM    393  CA  ALA    53      33.918  21.274  42.862  1.00 25.72      A   
ATOM    394  CB  ALA    53      33.850  22.101  44.144  1.00 32.05      A   
ATOM    395  C   ALA    53      35.301  20.657  42.687  1.00 25.08      A   
ATOM    396  O   ALA    53      35.597  19.614  43.271  1.00 26.05      A   
ATOM    397  N   LEU    54      36.135  21.282  41.870  1.00 29.44      A   
ATOM    398  CA  LEU    54      37.469  20.761  41.597  1.00 31.81      A   
ATOM    399  CB  LEU    54      37.441  19.976  40.275  1.00 36.23      A   
ATOM    400  CG  LEU    54      38.631  19.161  39.744  1.00 42.22      A   
ATOM    401  CD1 LEU    54      39.140  18.197  40.806  1.00 42.20      A   
ATOM    402  CD2 LEU    54      38.185  18.384  38.490  1.00 41.90      A   
ATOM    403  C   LEU    54      38.401  21.958  41.497  1.00 32.80      A   
ATOM    404  O   LEU    54      38.203  22.831  40.653  1.00 34.37      A   
ATOM    405  N   GLY    55      39.405  22.010  42.367  1.00 27.13      A   
ATOM    406  CA  GLY    55      40.327  23.127  42.343  1.00 26.95      A   
ATOM    407  C   GLY    55      40.002  24.211  43.362  1.00 26.29      A   
ATOM    408  O   GLY    55      39.674  23.931  44.518  1.00 24.22      A   
ATOM    409  N   ASP    56      40.072  25.459  42.920  1.00 27.38      A   
ATOM    410  CA  ASP    56      39.824  26.590  43.793  1.00 28.10      A   
ATOM    411  CB  ASP    56      40.083  27.885  43.026  1.00 27.21      A   
ATOM    412  CG  ASP    56      41.571  28.149  42.824  1.00 31.36      A   
ATOM    413  OD1 ASP    56      41.919  29.030  42.010  1.00 30.34      A   
ATOM    414  OD2 ASP    56      42.396  27.478  43.489  1.00 28.38      A   
ATOM    415  C   ASP    56      38.455  26.625  44.475  1.00 26.99      A   
ATOM    416  O   ASP    56      38.355  27.024  45.631  1.00 25.86      A   
ATOM    417  N   LEU    57      37.409  26.201  43.778  1.00 26.03      A   
ATOM    418  CA  LEU    57      36.077  26.203  44.367  1.00 26.48      A   
ATOM    419  CB  LEU    57      35.009  25.940  43.301  1.00 36.39      A   
ATOM    420  CG  LEU    57      34.632  27.127  42.419  1.00 36.95      A   
ATOM    421  CD1 LEU    57      33.485  26.718  41.510  1.00 38.53      A   
ATOM    422  CD2 LEU    57      34.200  28.297  43.287  1.00 38.10      A   
ATOM    423  C   LEU    57      35.972  25.146  45.449  1.00 25.86      A   
ATOM    424  O   LEU    57      35.247  25.313  46.426  1.00 25.71      A   
ATOM    425  N   ALA    58      36.692  24.047  45.276  1.00 25.28      A   
ATOM    426  CA  ALA    58      36.663  22.995  46.279  1.00 23.68      A   
ATOM    427  CB  ALA    58      37.433  21.754  45.778  1.00 18.74      A   
ATOM    428  C   ALA    58      37.292  23.548  47.565  1.00 24.16      A   
ATOM    429  O   ALA    58      36.825  23.279  48.676  1.00 24.86      A   
ATOM    430  N   LEU    59      38.346  24.340  47.420  1.00 24.80      A   
ATOM    431  CA  LEU    59      39.009  24.912  48.594  1.00 25.22      A   
ATOM    432  CB  LEU    59      40.301  25.620  48.173  1.00 25.53      A   
ATOM    433  CG  LEU    59      41.408  24.698  47.635  1.00 23.74      A   
ATOM    434  CD1 LEU    59      42.621  25.539  47.185  1.00 28.11      A   
ATOM    435  CD2 LEU    59      41.819  23.735  48.726  1.00 25.60      A   
ATOM    436  C   LEU    59      38.075  25.896  49.282  1.00 26.66      A   
ATOM    437  O   LEU    59      37.977  25.945  50.514  1.00 25.80      A   
ATOM    438  N   LEU    60      37.380  26.675  48.469  1.00 26.26      A   
ATOM    439  CA  LEU    60      36.454  27.660  48.999  1.00 28.13      A   
ATOM    440  CB  LEU    60      35.907  28.519  47.858  1.00 28.63      A   
ATOM    441  CG  LEU    60      35.022  29.723  48.203  1.00 33.95      A   
ATOM    442  CD1 LEU    60      35.829  30.845  48.888  1.00 33.12      A   
ATOM    443  CD2 LEU    60      34.412  30.234  46.899  1.00 35.66      A   
ATOM    444  C   LEU    60      35.297  26.996  49.739  1.00 27.53      A   
ATOM    445  O   LEU    60      34.984  27.358  50.866  1.00 27.40      A   
ATOM    446  N   LEU    61      34.675  26.006  49.109  1.00 23.07      A   
ATOM    447  CA  LEU    61      33.526  25.334  49.705  1.00 22.98      A   
ATOM    448  CB  LEU    61      32.680  24.689  48.598  1.00 23.07      A   
ATOM    449  CG  LEU    61      32.164  25.739  47.597  1.00 26.73      A   
ATOM    450  CD1 LEU    61      31.443  25.061  46.434  1.00 24.40      A   
ATOM    451  CD2 LEU    61      31.237  26.720  48.324  1.00 27.56      A   
ATOM    452  C   LEU    61      33.819  24.320  50.796  1.00 22.65      A   
ATOM    453  O   LEU    61      32.915  23.903  51.503  1.00 21.35      A   
ATOM    454  N   ALA    62      35.075  23.920  50.951  1.00 25.49      A   
ATOM    455  CA  ALA    62      35.398  22.957  51.988  1.00 28.72      A   
ATOM    456  CB  ALA    62      36.917  22.823  52.118  1.00 45.83      A   
ATOM    457  C   ALA    62      34.788  23.337  53.346  1.00 29.14      A   
ATOM    458  O   ALA    62      34.822  24.498  53.757  1.00 29.36      A   
ATOM    459  N   ASP    63      34.216  22.350  54.025  1.00 29.35      A   
ATOM    460  CA  ASP    63      33.626  22.560  55.340  1.00 30.52      A   
ATOM    461  CB  ASP    63      34.732  22.890  56.348  1.00 46.08      A   
ATOM    462  CG  ASP    63      35.839  21.853  56.353  1.00 49.24      A   
ATOM    463  OD1 ASP    63      35.531  20.666  56.581  1.00 50.62      A   
ATOM    464  OD2 ASP    63      37.012  22.220  56.122  1.00 52.95      A   
ATOM    465  C   ASP    63      32.541  23.633  55.418  1.00 30.03      A   
ATOM    466  O   ASP    63      32.391  24.279  56.451  1.00 29.98      A   
ATOM    467  N   THR    64      31.779  23.838  54.347  1.00 27.75      A   
ATOM    468  CA  THR    64      30.705  24.833  54.407  1.00 28.05      A   
ATOM    469  CB  THR    64      29.982  24.997  53.054  1.00 31.02      A   
ATOM    470  OG1 THR    64      30.929  25.362  52.049  1.00 29.72      A   
ATOM    471  CG2 THR    64      28.917  26.094  53.142  1.00 31.52      A   
ATOM    472  C   THR    64      29.685  24.312  55.409  1.00 28.21      A   
ATOM    473  O   THR    64      29.289  23.145  55.342  1.00 25.04      A   
ATOM    474  N   PRO    65      29.257  25.153  56.365  1.00 31.00      A   
ATOM    475  CD  PRO    65      29.811  26.446  56.816  1.00 31.55      A   
ATOM    476  CA  PRO    65      28.272  24.635  57.321  1.00 31.25      A   
ATOM    477  CB  PRO    65      28.004  25.837  58.233  1.00 31.38      A   
ATOM    478  CG  PRO    65      29.332  26.534  58.272  1.00 31.89      A   
ATOM    479  C   PRO    65      27.000  24.171  56.610  1.00 32.82      A   
ATOM    480  O   PRO    65      26.565  24.802  55.645  1.00 33.91      A   
ATOM    481  N   LEU    66      26.397  23.084  57.081  1.00 29.49      A   
ATOM    482  CA  LEU    66      25.160  22.609  56.462  1.00 32.04      A   
ATOM    483  CB  LEU    66      24.726  21.262  57.051  1.00 38.32      A   
ATOM    484  CG  LEU    66      25.796  20.180  56.907  1.00 42.26      A   
ATOM    485  CD1 LEU    66      25.271  18.857  57.429  1.00 42.26      A   
ATOM    486  CD2 LEU    66      26.187  20.053  55.442  1.00 41.30      A   
ATOM    487  C   LEU    66      24.068  23.641  56.679  1.00 30.22      A   
ATOM    488  O   LEU    66      24.003  24.275  57.734  1.00 29.76      A   
ATOM    489  N   GLY    67      23.204  23.804  55.683  1.00 29.89      A   
ATOM    490  CA  GLY    67      22.145  24.789  55.787  1.00 27.82      A   
ATOM    491  C   GLY    67      22.556  26.109  55.145  1.00 27.55      A   
ATOM    492  O   GLY    67      21.704  26.954  54.861  1.00 27.26      A   
ATOM    493  N   THR    68      23.856  26.298  54.912  1.00 25.80      A   
ATOM    494  CA  THR    68      24.353  27.536  54.300  1.00 26.75      A   
ATOM    495  CB  THR    68      25.879  27.500  54.089  1.00 31.47      A   
ATOM    496  OG1 THR    68      26.531  27.304  55.345  1.00 32.99      A   
ATOM    497  CG2 THR    68      26.375  28.822  53.488  1.00 31.56      A   
ATOM    498  C   THR    68      23.731  27.803  52.937  1.00 28.81      A   
ATOM    499  O   THR    68      23.567  26.882  52.133  1.00 26.16      A   
ATOM    500  N   GLU    69      23.409  29.066  52.674  1.00 31.53      A   
ATOM    501  CA  GLU    69      22.826  29.467  51.399  1.00 34.95      A   
ATOM    502  CB  GLU    69      22.024  30.760  51.558  1.00 59.01      A   
ATOM    503  CG  GLU    69      21.170  31.132  50.347  1.00 66.23      A   
ATOM    504  CD  GLU    69      20.135  30.050  50.054  1.00 71.75      A   
ATOM    509  C   GLU    69      23.938  29.686  50.384  1.00 35.52      A   
ATOM    510  O   GLU    69      24.977  30.273  50.702  1.00 37.15      A   
ATOM    511  N   MET    70      23.695  29.239  49.157  1.00 27.26      A   
ATOM    512  CA  MET    70      24.663  29.338  48.078  0.50 29.37      A   
ATOM    513  CB  MET    70      25.252  27.954  47.788  0.50 53.54      A   
ATOM    514  CG  MET    70      25.898  27.307  48.976  0.50 59.96      A   
ATOM    515  SD  MET    70      27.190  28.525  49.679  0.50 69.62      A   
ATOM    516  CE  MET    70      28.377  28.589  48.155  0.50 67.14      A   
ATOM    517  C   MET    70      24.064  29.869  46.788  1.00 28.37      A   
ATOM    518  O   MET    70      22.861  29.775  46.564  1.00 28.60      A   
ATOM    519  N   GLN    71      24.931  30.416  45.946  1.00 32.77      A   
ATOM    520  CA  GLN    71      24.554  30.924  44.636  1.00 33.87      A   
ATOM    521  CB  GLN    71      24.610  32.452  44.622  1.00 55.43      A   
ATOM    522  CG  GLN    71      23.690  33.092  43.609  1.00 61.78      A   
ATOM    523  CD  GLN    71      23.401  34.545  43.937  1.00 63.91      A   
ATOM    524  OE1 GLN    71      22.963  34.868  45.043  1.00 64.97      A   
ATOM    525  NE2 GLN    71      23.639  35.428  42.975  1.00 64.85      A   
ATOM    526  C   GLN    71      25.634  30.313  43.749  1.00 30.52      A   
ATOM    527  O   GLN    71      26.811  30.644  43.875  1.00 30.63      A   
ATOM    528  N   VAL    72      25.248  29.401  42.866  1.00 27.97      A   
ATOM    529  CA  VAL    72      26.238  28.730  42.033  1.00 25.03      A   
ATOM    530  CB  VAL    72      26.467  27.273  42.499  1.00 26.61      A   
ATOM    531  CG1 VAL    72      26.901  27.239  43.951  1.00 27.06      A   
ATOM    532  CG2 VAL    72      25.179  26.471  42.318  1.00 26.00      A   
ATOM    533  C   VAL    72      25.862  28.658  40.569  1.00 26.84      A   
ATOM    534  O   VAL    72      24.712  28.888  40.198  1.00 27.56      A   
ATOM    535  N   GLN    73      26.856  28.316  39.754  1.00 27.71      A   
ATOM    536  CA  GLN    73      26.687  28.143  38.317  1.00 27.13      A   
ATOM    537  CB  GLN    73      26.831  29.481  37.570  1.00 38.19      A   
ATOM    538  CG  GLN    73      28.234  29.910  37.209  1.00 44.88      A   
ATOM    539  CD  GLN    73      28.772  29.236  35.954  1.00 45.71      A   
ATOM    540  OE1 GLN    73      28.021  28.672  35.152  1.00 49.24      A   
ATOM    541  NE2 GLN    73      30.079  29.307  35.774  1.00 46.81      A   
ATOM    542  C   GLN    73      27.744  27.150  37.854  1.00 26.57      A   
ATOM    543  O   GLN    73      28.808  27.020  38.475  1.00 22.41      A   
ATOM    544  N   GLY    74      27.434  26.424  36.784  1.00 23.92      A   
ATOM    545  CA  GLY    74      28.367  25.451  36.252  1.00 24.43      A   
ATOM    546  C   GLY    74      27.689  24.689  35.136  1.00 22.75      A   
ATOM    547  O   GLY    74      26.615  25.086  34.683  1.00 23.35      A   
ATOM    548  N   PHE    75      28.301  23.598  34.690  1.00 25.04      A   
ATOM    549  CA  PHE    75      27.713  22.808  33.620  1.00 25.32      A   
ATOM    550  CB  PHE    75      28.725  22.635  32.481  1.00 25.85      A   
ATOM    551  CG  PHE    75      29.955  21.841  32.858  1.00 27.05      A   
ATOM    552  CD1 PHE    75      30.002  20.452  32.677  1.00 25.82      A   
ATOM    553  CD2 PHE    75      31.082  22.487  33.367  1.00 28.65      A   
ATOM    554  CE1 PHE    75      31.164  19.712  33.000  1.00 25.68      A   
ATOM    555  CE2 PHE    75      32.241  21.771  33.692  1.00 28.59      A   
ATOM    556  CZ  PHE    75      32.285  20.375  33.506  1.00 28.50      A   
ATOM    557  C   PHE    75      27.237  21.455  34.128  1.00 25.44      A   
ATOM    558  O   PHE    75      27.764  20.928  35.107  1.00 26.99      A   
ATOM    559  N   LEU    76      26.224  20.908  33.464  1.00 25.34      A   
ATOM    560  CA  LEU    76      25.661  19.615  33.832  1.00 25.23      A   
ATOM    561  CB  LEU    76      24.162  19.579  33.505  1.00 29.09      A   
ATOM    562  CG  LEU    76      23.305  20.609  34.243  1.00 32.39      A   
ATOM    563  CD1 LEU    76      21.852  20.511  33.803  1.00 33.79      A   
ATOM    564  CD2 LEU    76      23.432  20.354  35.744  1.00 30.67      A   
ATOM    565  C   LEU    76      26.363  18.496  33.084  1.00 26.07      A   
ATOM    566  O   LEU    76      26.751  18.667  31.935  1.00 24.95      A   
ATOM    567  N   ALA    77      26.540  17.355  33.739  1.00 22.60      A   
ATOM    568  CA  ALA    77      27.177  16.230  33.077  1.00 24.61      A   
ATOM    569  CB  ALA    77      28.713  16.251  33.315  1.00 33.80      A   
ATOM    570  C   ALA    77      26.572  14.960  33.624  1.00 24.60      A   
ATOM    571  O   ALA    77      26.036  14.945  34.732  1.00 25.29      A   
ATOM    572  N   PRO    78      26.617  13.876  32.842  1.00 25.80      A   
ATOM    573  CD  PRO    78      27.189  13.690  31.497  1.00 32.45      A   
ATOM    574  CA  PRO    78      26.048  12.631  33.351  1.00 26.85      A   
ATOM    575  CB  PRO    78      26.263  11.648  32.194  1.00 31.58      A   
ATOM    576  CG  PRO    78      27.464  12.200  31.481  1.00 32.92      A   
ATOM    577  C   PRO    78      26.820  12.245  34.612  1.00 28.40      A   
ATOM    578  O   PRO    78      28.010  12.519  34.722  1.00 27.48      A   
ATOM    579  N   ALA    79      26.137  11.635  35.570  1.00 28.15      A   
ATOM    580  CA  ALA    79      26.780  11.240  36.811  1.00 32.75      A   
ATOM    581  CB  ALA    79      25.735  10.691  37.789  1.00 37.42      A   
ATOM    582  C   ALA    79      27.832  10.179  36.541  1.00 35.06      A   
ATOM    583  O   ALA    79      28.909  10.193  37.125  1.00 36.08      A   
ATOM    584  N   ARG    80      27.492   9.263  35.642  1.00 41.92      A   
ATOM    585  CA  ARG    80      28.339   8.133  35.266  1.00 46.18      A   
ATOM    586  CB  ARG    80      27.786   6.882  35.964  1.00 73.73      A   
ATOM    587  CG  ARG    80      28.511   5.572  35.732  1.00 79.35      A   
ATOM    588  CD  ARG    80      27.713   4.428  36.364  1.00 81.88      A   
ATOM    589  NE  ARG    80      28.500   3.208  36.494  1.00 85.97      A   
ATOM    590  CZ  ARG    80      29.561   3.084  37.286  1.00 87.59      A   
ATOM    591  NH1 ARG    80      29.967   4.110  38.025  1.00 88.43      A   
ATOM    592  NH2 ARG    80      30.217   1.933  37.340  1.00 88.57      A   
ATOM    593  C   ARG    80      28.209   8.006  33.749  1.00 47.15      A   
ATOM    594  O   ARG    80      27.216   8.471  33.180  1.00 46.35      A   
ATOM    595  N   LYS    81      29.184   7.387  33.084  1.00 38.64      A   
ATOM    596  CA  LYS    81      29.091   7.254  31.632  1.00 39.16      A   
ATOM    597  CB  LYS    81      30.202   6.368  31.060  1.00 63.40      A   
ATOM    598  CG  LYS    81      30.154   6.338  29.533  1.00 66.98      A   
ATOM    599  CD  LYS    81      30.962   5.215  28.914  1.00 70.58      A   
ATOM    600  CE  LYS    81      30.789   5.220  27.397  1.00 71.45      A   
ATOM    601  NZ  LYS    81      31.537   4.113  26.726  1.00 72.84      A   
ATOM    602  C   LYS    81      27.745   6.650  31.241  1.00 38.59      A   
ATOM    603  O   LYS    81      27.293   5.668  31.834  1.00 37.24      A   
ATOM    604  N   ASP    82      27.110   7.254  30.241  1.00 52.57      A   
ATOM    605  CA  ASP    82      25.816   6.807  29.730  1.00 52.05      A   
ATOM    606  CB  ASP    82      25.911   5.366  29.220  1.00 68.98      A   
ATOM    607  CG  ASP    82      27.001   5.185  28.182  1.00 70.72      A   
ATOM    608  OD1 ASP    82      27.046   5.992  27.231  1.00 72.42      A   
ATOM    609  OD2 ASP    82      27.804   4.235  28.316  1.00 72.35      A   
ATOM    610  C   ASP    82      24.682   6.897  30.740  1.00 50.43      A   
ATOM    611  O   ASP    82      23.577   6.408  30.490  1.00 51.73      A   
ATOM    612  N   SER    83      24.945   7.517  31.881  1.00 39.89      A   
ATOM    613  CA  SER    83      23.913   7.644  32.899  1.00 36.24      A   
ATOM    614  CB  SER    83      24.530   7.944  34.265  1.00 33.61      A   
ATOM    615  OG  SER    83      23.522   8.223  35.221  1.00 28.96      A   
ATOM    616  C   SER    83      22.911   8.738  32.572  1.00 33.85      A   
ATOM    617  O   SER    83      23.245   9.741  31.931  1.00 33.01      A   
ATOM    618  N   VAL    84      21.680   8.543  33.025  1.00 29.61      A   
ATOM    619  CA  VAL    84      20.651   9.537  32.810  1.00 29.31      A   
ATOM    620  CB  VAL    84      19.262   8.886  32.603  1.00 39.19      A   
ATOM    621  CG1 VAL    84      19.294   7.998  31.360  1.00 39.94      A   
ATOM    622  CG2 VAL    84      18.858   8.081  33.831  1.00 40.95      A   
ATOM    623  C   VAL    84      20.641  10.458  34.032  1.00 28.11      A   
ATOM    624  O   VAL    84      19.996  11.503  34.020  1.00 26.08      A   
ATOM    625  N   LYS    85      21.366  10.070  35.084  1.00 22.87      A   
ATOM    626  CA  LYS    85      21.445  10.895  36.293  1.00 22.83      A   
ATOM    627  CB  LYS    85      22.032  10.112  37.478  1.00 22.58      A   
ATOM    628  CG  LYS    85      21.174   8.979  38.029  1.00 28.58      A   
ATOM    629  CD  LYS    85      21.958   8.197  39.104  1.00 30.17      A   
ATOM    630  CE  LYS    85      21.265   6.899  39.500  1.00 34.34      A   
ATOM    631  NZ  LYS    85      22.133   6.072  40.407  1.00 31.90      A   
ATOM    632  C   LYS    85      22.382  12.043  35.974  1.00 22.94      A   
ATOM    633  O   LYS    85      23.359  11.853  35.252  1.00 22.47      A   
ATOM    634  N   VAL    86      22.135  13.217  36.543  1.00 27.51      A   
ATOM    635  CA  VAL    86      22.988  14.356  36.220  1.00 27.63      A   
ATOM    636  CB  VAL    86      22.190  15.440  35.448  1.00 25.37      A   
ATOM    637  CG1 VAL    86      21.432  14.805  34.289  1.00 26.36      A   
ATOM    638  CG2 VAL    86      21.223  16.150  36.390  1.00 27.29      A   
ATOM    639  C   VAL    86      23.616  15.002  37.443  1.00 29.12      A   
ATOM    640  O   VAL    86      23.017  15.023  38.522  1.00 30.61      A   
ATOM    641  N   LYS    87      24.809  15.556  37.248  1.00 22.01      A   
ATOM    642  CA  LYS    87      25.548  16.208  38.314  1.00 24.43      A   
ATOM    643  CB  LYS    87      26.761  15.336  38.671  1.00 40.98      A   
ATOM    644  CG  LYS    87      27.433  15.627  40.001  1.00 46.69      A   
ATOM    645  CD  LYS    87      28.325  14.450  40.447  1.00 48.24      A   
ATOM    646  CE  LYS    87      27.499  13.214  40.797  1.00 51.31      A   
ATOM    647  NZ  LYS    87      28.341  12.049  41.233  1.00 55.32      A   
ATOM    648  C   LYS    87      25.984  17.591  37.836  1.00 23.09      A   
ATOM    649  O   LYS    87      26.281  17.787  36.657  1.00 22.07      A   
ATOM    650  N   LEU    88      25.987  18.555  38.748  1.00 24.75      A   
ATOM    651  CA  LEU    88      26.404  19.905  38.422  1.00 25.06      A   
ATOM    652  CB  LEU    88      25.617  20.921  39.247  1.00 23.11      A   
ATOM    653  CG  LEU    88      26.078  22.376  39.097  1.00 25.69      A   
ATOM    654  CD1 LEU    88      25.804  22.876  37.676  1.00 22.82      A   
ATOM    655  CD2 LEU    88      25.346  23.244  40.126  1.00 23.24      A   
ATOM    656  C   LEU    88      27.898  20.086  38.685  1.00 24.86      A   
ATOM    657  O   LEU    88      28.363  19.882  39.801  1.00 26.07      A   
ATOM    658  N   HIS    89      28.646  20.443  37.645  1.00 22.24      A   
ATOM    659  CA  HIS    89      30.079  20.678  37.772  1.00 22.99      A   
ATOM    660  CB  HIS    89      30.815  20.154  36.552  1.00 28.93      A   
ATOM    661  CG  HIS    89      30.842  18.660  36.478  1.00 32.11      A   
ATOM    662  CD2 HIS    89      29.846  17.745  36.531  1.00 29.81      A   
ATOM    663  ND1 HIS    89      32.012  17.945  36.332  1.00 33.49      A   
ATOM    664  CE1 HIS    89      31.734  16.654  36.296  1.00 32.57      A   
ATOM    665  NE2 HIS    89      30.426  16.505  36.413  1.00 31.69      A   
ATOM    666  C   HIS    89      30.294  22.168  37.932  1.00 23.14      A   
ATOM    667  O   HIS    89      30.226  22.933  36.974  1.00 21.94      A   
ATOM    668  N   LEU    90      30.546  22.556  39.176  1.00 25.38      A   
ATOM    669  CA  LEU    90      30.716  23.946  39.568  1.00 25.66      A   
ATOM    670  CB  LEU    90      30.891  24.017  41.093  1.00 24.41      A   
ATOM    671  CG  LEU    90      29.697  23.422  41.858  1.00 24.48      A   
ATOM    672  CD1 LEU    90      30.026  23.294  43.349  1.00 25.49      A   
ATOM    673  CD2 LEU    90      28.469  24.309  41.660  1.00 23.44      A   
ATOM    674  C   LEU    90      31.827  24.715  38.882  1.00 26.58      A   
ATOM    675  O   LEU    90      32.948  24.216  38.725  1.00 24.89      A   
ATOM    676  N   GLN    91      31.503  25.937  38.467  1.00 23.53      A   
ATOM    677  CA  GLN    91      32.473  26.808  37.815  1.00 25.88      A   
ATOM    678  CB  GLN    91      32.095  27.034  36.348  1.00 27.74      A   
ATOM    679  CG  GLN    91      32.159  25.782  35.506  1.00 28.30      A   
ATOM    680  CD  GLN    91      31.774  26.050  34.068  1.00 30.80      A   
ATOM    681  OE1 GLN    91      30.673  26.513  33.794  1.00 27.87      A   
ATOM    682  NE2 GLN    91      32.684  25.763  33.140  1.00 32.48      A   
ATOM    683  C   GLN    91      32.515  28.131  38.568  1.00 26.48      A   
ATOM    684  O   GLN    91      33.488  28.875  38.477  1.00 28.32      A   
ATOM    685  N   GLN    92      31.442  28.422  39.298  1.00 26.61      A   
ATOM    686  CA  GLN    92      31.355  29.626  40.113  1.00 27.30      A   
ATOM    687  CB  GLN    92      30.724  30.797  39.352  1.00 41.60      A   
ATOM    688  CG  GLN    92      31.445  31.244  38.093  1.00 45.91      A   
ATOM    689  CD  GLN    92      30.909  32.574  37.586  1.00 49.65      A   
ATOM    690  OE1 GLN    92      29.706  32.814  37.603  1.00 52.22      A   
ATOM    691  NE2 GLN    92      31.801  33.438  37.130  1.00 52.57      A   
ATOM    692  C   GLN    92      30.486  29.326  41.328  1.00 28.32      A   
ATOM    693  O   GLN    92      29.496  28.590  41.244  1.00 25.42      A   
ATOM    694  N   ALA    93      30.856  29.897  42.464  1.00 25.17      A   
ATOM    695  CA  ALA    93      30.080  29.688  43.672  1.00 28.30      A   
ATOM    696  CB  ALA    93      30.458  28.362  44.319  1.00 41.80      A   
ATOM    697  C   ALA    93      30.330  30.823  44.640  1.00 30.53      A   
ATOM    698  O   ALA    93      31.444  31.339  44.722  1.00 29.69      A   
ATOM    699  N   ARG    94      29.284  31.224  45.353  1.00 29.52      A   
ATOM    700  CA  ARG    94      29.399  32.275  46.349  1.00 36.47      A   
ATOM    701  CB  ARG    94      29.080  33.652  45.749  1.00 66.16      A   
ATOM    702  CG  ARG    94      27.760  33.735  45.008  1.00 71.03      A   
ATOM    703  CD  ARG    94      26.758  34.634  45.723  1.00 76.08      A   
ATOM    704  NE  ARG    94      27.222  36.015  45.829  1.00 79.33      A   
ATOM    705  CZ  ARG    94      26.520  37.001  46.383  1.00 81.20      A   
ATOM    706  NH1 ARG    94      27.029  38.225  46.436  1.00 82.52      A   
ATOM    707  NH2 ARG    94      25.308  36.771  46.878  1.00 82.63      A   
ATOM    708  C   ARG    94      28.478  31.973  47.525  1.00 39.20      A   
ATOM    709  O   ARG    94      27.302  31.636  47.360  1.00 37.22      A   
ATOM    710  N   ARG    95      29.048  32.083  48.717  1.00 48.54      A   
ATOM    711  CA  ARG    95      28.346  31.826  49.964  1.00 54.70      A   
ATOM    712  CB  ARG    95      29.371  31.419  51.026  1.00 65.41      A   
ATOM    713  CG  ARG    95      28.864  31.285  52.442  1.00 68.11      A   
ATOM    714  CD  ARG    95      29.987  30.725  53.310  1.00 70.28      A   
ATOM    715  NE  ARG    95      29.590  30.495  54.696  1.00 72.39      A   
ATOM    716  CZ  ARG    95      30.260  29.720  55.544  1.00 72.88      A   
ATOM    717  NH1 ARG    95      31.364  29.096  55.149  1.00 73.41      A   
ATOM    718  NH2 ARG    95      29.824  29.563  56.786  1.00 74.05      A   
ATOM    719  C   ARG    95      27.595  33.077  50.395  1.00 57.64      A   
ATOM    720  O   ARG    95      28.201  34.125  50.610  1.00 58.67      A   
ATOM    721  N   ILE    96      26.273  32.969  50.506  1.00 76.07      A   
ATOM    722  CA  ILE    96      25.449  34.102  50.916  1.00 79.88      A   
ATOM    723  CB  ILE    96      24.011  34.007  50.355  1.00 69.35      A   
ATOM    724  CG2 ILE    96      23.276  35.308  50.633  1.00 69.35      A   
ATOM    725  CG1 ILE    96      24.042  33.731  48.850  1.00 69.24      A   
ATOM    726  CD1 ILE    96      22.682  33.474  48.244  1.00 69.56      A   
ATOM    727  C   ILE    96      25.353  34.158  52.440  1.00 82.47      A   
ATOM    728  O   ILE    96      24.751  33.284  53.064  1.00 82.91      A   
ATOM    729  N   ALA    97      25.946  35.189  53.034  1.00 94.57      A   
ATOM    730  CA  ALA    97      25.927  35.352  54.483  1.00 97.13      A   
ATOM    731  CB  ALA    97      27.216  36.007  54.952  1.00 79.37      A   
ATOM    732  C   ALA    97      24.739  36.199  54.903  1.00 98.75      A   
ATOM    733  O   ALA    97      24.671  37.386  54.585  1.00 99.27      A   
ATOM    734  N   GLY    98      23.806  35.583  55.621  1.00 99.99      A   
ATOM    735  CA  GLY    98      22.629  36.298  56.077  1.00101.66      A   
ATOM    736  C   GLY    98      22.852  36.898  57.451  1.00102.77      A   
ATOM    737  O   GLY    98      23.977  36.751  57.976  1.00103.27      A   
ATOM    738  OXT GLY    98      21.912  37.513  58.004  1.00 93.70      A   
END
