
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   98 (  712),  selected   98 , name 1ue7_C
# Molecule2: number of CA atoms   98 (  734),  selected   98 , name T0491.pdb
# PARAMETERS: 1ue7_C.T0491.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     2_C      -       -           -
LGA    G     3_C      -       -           -
LGA    D     4_C      M       1          1.369
LGA    T     5_C      N       2          1.341
LGA    T     6_C      T       3          0.173
LGA    I     7_C      L       4          0.615
LGA    T     8_C      E       5          0.537
LGA    I     9_C      L       6          0.823
LGA    V    10_C      S       7          0.691
LGA    G    11_C      A       8          1.117
LGA    N    12_C      R       9          0.387
LGA    L    13_C      V      10          0.689
LGA    T    14_C      L      11          0.754
LGA    A    15_C      E      12          1.835
LGA    D    16_C      C      13          2.684
LGA    P    17_C      G      14          3.907
LGA    E    18_C      A      15          3.069
LGA    L    19_C      M      16          1.653
LGA    R    20_C      R      17          0.811
LGA    F    21_C      H      18          0.691
LGA    T    22_C      T      19          3.031
LGA    P    23_C      P      20          1.946
LGA    S    24_C      A      21          1.996
LGA    G    25_C      G      22          1.510
LGA    A    26_C      L      23          1.347
LGA    A    27_C      P      24          0.823
LGA    V    28_C      A      25          0.617
LGA    A    29_C      L      26          0.837
LGA    N    30_C      E      27          0.998
LGA    F    31_C      L      28          0.105
LGA    T    32_C      L      29          1.314
LGA    V    33_C      L      30          0.758
LGA    A    34_C      V      31          0.139
LGA    S    35_C      H      32          0.534
LGA    T    36_C      E      33          1.194
LGA    -       -      S      34           -
LGA    -       -      E      35           -
LGA    -       -      V      36           -
LGA    -       -      V      37           -
LGA    -       -      E      38           -
LGA    -       -      A      39           -
LGA    -       -      G      40           -
LGA    -       -      H      41           -
LGA    -       -      P      42           -
LGA    -       -      R      43           -
LGA    -       -      R      44           -
LGA    E    51_C      V      45          3.239
LGA    A    52_C      E      46          1.842
LGA    L    53_C      L      47          0.615
LGA    F    54_C      T      48          0.986
LGA    L    55_C      I      49          1.130
LGA    R    56_C      S      50          0.503
LGA    C    57_C      A      51          0.499
LGA    N    58_C      V      52          0.730
LGA    I    59_C      A      53          0.981
LGA    W    60_C      L      54          0.568
LGA    R    61_C      G      55          0.981
LGA    E    62_C      D      56          2.604
LGA    A    63_C      L      57          2.065
LGA    A    64_C      A      58          0.876
LGA    E    65_C      L      59          1.349
LGA    N    66_C      L      60          1.456
LGA    V    67_C      L      61          0.819
LGA    A    68_C      A      62          0.740
LGA    E    69_C      D      63          4.312
LGA    S    70_C      -       -           -
LGA    L    71_C      T      64          1.874
LGA    T    72_C      P      65          1.593
LGA    R    73_C      L      66          0.910
LGA    G    74_C      G      67          0.821
LGA    A    75_C      T      68          0.805
LGA    R    76_C      E      69          0.847
LGA    V    77_C      M      70          0.190
LGA    I    78_C      Q      71          0.507
LGA    V    79_C      V      72          0.742
LGA    S    80_C      Q      73          0.534
LGA    G    81_C      G      74          0.484
LGA    R    82_C      F      75          0.556
LGA    L    83_C      L      76          0.848
LGA    K    84_C      A      77          1.227
LGA    Q    85_C      P      78          2.387
LGA    R    91_C      -       -           -
LGA    E    92_C      -       -           -
LGA    G    93_C      -       -           -
LGA    E    94_C      -       -           -
LGA    K    95_C      A      79           #
LGA    R    96_C      R      80          1.368
LGA    -       -      K      81           -
LGA    -       -      D      82           -
LGA    T    97_C      S      83          1.245
LGA    -       -      V      84           -
LGA    V    98_C      K      85          1.665
LGA    I    99_C      V      86          0.451
LGA    E   100_C      K      87          0.621
LGA    V   101_C      L      88          0.611
LGA    E   102_C      H      89          0.711
LGA    V   103_C      L      90          0.452
LGA    D   104_C      Q      91          0.647
LGA    E   105_C      Q      92          0.760
LGA    I   106_C      A      93          0.725
LGA    G   107_C      R      94          1.153
LGA    P   108_C      R      95          1.062
LGA    S   109_C      I      96          1.910
LGA    L   110_C      A      97          3.870
LGA    R   111_C      -       -           -
LGA    Y   112_C      -       -           -
LGA    A   113_C      G      98          0.830
LGA    T   114_C      -       -           -
LGA    A   115_C      -       -           -
LGA    K   116_C      -       -           -
LGA    V   117_C      -       -           -
LGA    N   118_C      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   98   98    5.0     83    1.47    15.66     80.147     5.278

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.857440 * X  +   0.258740 * Y  +   0.444804 * Z  + -32.225071
  Y_new =  -0.224420 * X  +  -0.965884 * Y  +   0.129241 * Z  + 106.746857
  Z_new =   0.463069 * X  +   0.010993 * Y  +   0.886254 * Z  + -94.448441 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   0.012404   -3.129189  [ DEG:     0.7107   -179.2893 ]
  Theta =  -0.481455   -2.660138  [ DEG:   -27.5853   -152.4147 ]
  Phi   =  -2.885603    0.255990  [ DEG:  -165.3329     14.6671 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1ue7_C                                        
REMARK     2: T0491.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1ue7_C.T0491.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   98   98   5.0   83   1.47   15.66  80.147
REMARK  ---------------------------------------------------------- 
MOLECULE 1ue7_C
HEADER    DNA BINDING PROTEIN                     09-MAY-03   1UE7              
TITLE     CRYSTAL STRUCTURE OF THE SINGLE-STRANDED DNA-BINDING                  
TITLE    2 PROTEIN FROM MYCOBACTERIUM TUBERCULOSIS                              
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SINGLE-STRAND BINDING PROTEIN;                             
COMPND   3 CHAIN: A, B, C, D;                                                   
COMPND   4 SYNONYM: SINGLE-STRANDED DNA-BINDING PROTEIN;                        
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MYCOBACTERIUM TUBERCULOSIS;                     
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET11D                                    
KEYWDS    OLIGONUCLEOTIDE BINDING FOLD, DNA-BINDING PROTEIN,                    
KEYWDS   2 STRUCTURAL GENOMICS, PSI, PROTEIN STRUCTURE INITIATIVE, TB           
KEYWDS   3 STRUCTURAL GENOMICS CONSORTIUM, TBSGC                                
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.SAIKRISHNAN,J.JEYAKANTHAN,J.VENKATESH,N.ACHARYA,K.SEKAR,            
AUTHOR   2 U.VARSHNEY,M.VIJAYAN,TB STRUCTURAL GENOMICS CONSORTIUM               
AUTHOR   3 (TBSGC)                                                              
REVDAT   2   01-FEB-05 1UE7    1       AUTHOR KEYWDS REMARK                     
REVDAT   1   10-FEB-04 1UE7    0                                                
JRNL        AUTH   K.SAIKRISHNAN,J.JEYAKANTHAN,J.VENKATESH,N.ACHARYA,           
JRNL        AUTH 2 K.SEKAR,U.VARSHNEY,M.VIJAYAN                                 
JRNL        TITL   STRUCTURE OF MYCOBACTERIUM TUBERCULOSIS                      
JRNL        TITL 2 SINGLE-STRANDED DNA-BINDING PROTEIN. VARIABILITY             
JRNL        TITL 3 IN QUATERNARY STRUCTURE AND ITS IMPLICATIONS                 
JRNL        REF    J.MOL.BIOL.                   V. 331   385 2003              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. 3.20 ANGSTROMS.                                          
DBREF  1UE7 A    1   164  UNP    P0A610   SSB_MYCTU        1    164             
DBREF  1UE7 B    1   164  UNP    P0A610   SSB_MYCTU        1    164             
DBREF  1UE7 C    1   164  UNP    P0A610   SSB_MYCTU        1    164             
DBREF  1UE7 D    1   164  UNP    P0A610   SSB_MYCTU        1    164             
SEQRES   1 A  164  MET ALA GLY ASP THR THR ILE THR ILE VAL GLY ASN LEU          
SEQRES   2 A  164  THR ALA ASP PRO GLU LEU ARG PHE THR PRO SER GLY ALA          
SEQRES   3 A  164  ALA VAL ALA ASN PHE THR VAL ALA SER THR PRO ARG ILE          
SEQRES   4 A  164  TYR ASP ARG GLN THR GLY GLU TRP LYS ASP GLY GLU ALA          
SEQRES   5 A  164  LEU PHE LEU ARG CYS ASN ILE TRP ARG GLU ALA ALA GLU          
SEQRES   6 A  164  ASN VAL ALA GLU SER LEU THR ARG GLY ALA ARG VAL ILE          
SEQRES   7 A  164  VAL SER GLY ARG LEU LYS GLN ARG SER PHE GLU THR ARG          
SEQRES   8 A  164  GLU GLY GLU LYS ARG THR VAL ILE GLU VAL GLU VAL ASP          
SEQRES   9 A  164  GLU ILE GLY PRO SER LEU ARG TYR ALA THR ALA LYS VAL          
SEQRES  10 A  164  ASN LYS ALA SER ARG SER GLY GLY PHE GLY SER GLY SER          
SEQRES  11 A  164  ARG PRO ALA PRO ALA GLN THR SER SER ALA SER GLY ASP          
SEQRES  12 A  164  ASP PRO TRP GLY SER ALA PRO ALA SER GLY SER PHE GLY          
SEQRES  13 A  164  GLY GLY ASP ASP GLU PRO PRO PHE                              
SEQRES   1 B  164  MET ALA GLY ASP THR THR ILE THR ILE VAL GLY ASN LEU          
SEQRES   2 B  164  THR ALA ASP PRO GLU LEU ARG PHE THR PRO SER GLY ALA          
SEQRES   3 B  164  ALA VAL ALA ASN PHE THR VAL ALA SER THR PRO ARG ILE          
SEQRES   4 B  164  TYR ASP ARG GLN THR GLY GLU TRP LYS ASP GLY GLU ALA          
SEQRES   5 B  164  LEU PHE LEU ARG CYS ASN ILE TRP ARG GLU ALA ALA GLU          
SEQRES   6 B  164  ASN VAL ALA GLU SER LEU THR ARG GLY ALA ARG VAL ILE          
SEQRES   7 B  164  VAL SER GLY ARG LEU LYS GLN ARG SER PHE GLU THR ARG          
SEQRES   8 B  164  GLU GLY GLU LYS ARG THR VAL ILE GLU VAL GLU VAL ASP          
SEQRES   9 B  164  GLU ILE GLY PRO SER LEU ARG TYR ALA THR ALA LYS VAL          
SEQRES  10 B  164  ASN LYS ALA SER ARG SER GLY GLY PHE GLY SER GLY SER          
SEQRES  11 B  164  ARG PRO ALA PRO ALA GLN THR SER SER ALA SER GLY ASP          
SEQRES  12 B  164  ASP PRO TRP GLY SER ALA PRO ALA SER GLY SER PHE GLY          
SEQRES  13 B  164  GLY GLY ASP ASP GLU PRO PRO PHE                              
SEQRES   1 C  164  MET ALA GLY ASP THR THR ILE THR ILE VAL GLY ASN LEU          
SEQRES   2 C  164  THR ALA ASP PRO GLU LEU ARG PHE THR PRO SER GLY ALA          
SEQRES   3 C  164  ALA VAL ALA ASN PHE THR VAL ALA SER THR PRO ARG ILE          
SEQRES   4 C  164  TYR ASP ARG GLN THR GLY GLU TRP LYS ASP GLY GLU ALA          
SEQRES   5 C  164  LEU PHE LEU ARG CYS ASN ILE TRP ARG GLU ALA ALA GLU          
SEQRES   6 C  164  ASN VAL ALA GLU SER LEU THR ARG GLY ALA ARG VAL ILE          
SEQRES   7 C  164  VAL SER GLY ARG LEU LYS GLN ARG SER PHE GLU THR ARG          
SEQRES   8 C  164  GLU GLY GLU LYS ARG THR VAL ILE GLU VAL GLU VAL ASP          
SEQRES   9 C  164  GLU ILE GLY PRO SER LEU ARG TYR ALA THR ALA LYS VAL          
SEQRES  10 C  164  ASN LYS ALA SER ARG SER GLY GLY PHE GLY SER GLY SER          
SEQRES  11 C  164  ARG PRO ALA PRO ALA GLN THR SER SER ALA SER GLY ASP          
SEQRES  12 C  164  ASP PRO TRP GLY SER ALA PRO ALA SER GLY SER PHE GLY          
SEQRES  13 C  164  GLY GLY ASP ASP GLU PRO PRO PHE                              
SEQRES   1 D  164  MET ALA GLY ASP THR THR ILE THR ILE VAL GLY ASN LEU          
SEQRES   2 D  164  THR ALA ASP PRO GLU LEU ARG PHE THR PRO SER GLY ALA          
SEQRES   3 D  164  ALA VAL ALA ASN PHE THR VAL ALA SER THR PRO ARG ILE          
SEQRES   4 D  164  TYR ASP ARG GLN THR GLY GLU TRP LYS ASP GLY GLU ALA          
SEQRES   5 D  164  LEU PHE LEU ARG CYS ASN ILE TRP ARG GLU ALA ALA GLU          
SEQRES   6 D  164  ASN VAL ALA GLU SER LEU THR ARG GLY ALA ARG VAL ILE          
SEQRES   7 D  164  VAL SER GLY ARG LEU LYS GLN ARG SER PHE GLU THR ARG          
SEQRES   8 D  164  GLU GLY GLU LYS ARG THR VAL ILE GLU VAL GLU VAL ASP          
SEQRES   9 D  164  GLU ILE GLY PRO SER LEU ARG TYR ALA THR ALA LYS VAL          
SEQRES  10 D  164  ASN LYS ALA SER ARG SER GLY GLY PHE GLY SER GLY SER          
SEQRES  11 D  164  ARG PRO ALA PRO ALA GLN THR SER SER ALA SER GLY ASP          
SEQRES  12 D  164  ASP PRO TRP GLY SER ALA PRO ALA SER GLY SER PHE GLY          
SEQRES  13 D  164  GLY GLY ASP ASP GLU PRO PRO PHE                              
FORMUL   5  HOH   *183(H2 O)                                                    
CRYST1   60.223  116.720  177.885  90.00  90.00  90.00 I 21 21 21   32          
ATOM   1466  N   ALA C   2      28.801  29.887  21.662  1.00 88.86           N  
ATOM   1467  CA  ALA C   2      27.851  29.226  22.597  1.00 88.86           C  
ATOM   1468  C   ALA C   2      28.415  29.044  24.014  1.00 88.86           C  
ATOM   1469  O   ALA C   2      28.344  29.962  24.835  1.00 88.86           O  
ATOM   1470  CB  ALA C   2      27.412  27.875  22.027  1.00 27.10           C  
ATOM   1471  N   GLY C   3      28.998  27.877  24.295  1.00101.61           N  
ATOM   1472  CA  GLY C   3      29.501  27.605  25.637  1.00101.61           C  
ATOM   1473  C   GLY C   3      28.216  27.349  26.400  1.00101.61           C  
ATOM   1474  O   GLY C   3      27.749  28.203  27.158  1.00101.61           O  
ATOM   1475  N   ASP C   4      27.651  26.156  26.204  1.00101.61           N  
ATOM   1476  CA  ASP C   4      26.353  25.819  26.779  1.00101.61           C  
ATOM   1477  C   ASP C   4      26.110  24.900  27.974  1.00101.61           C  
ATOM   1478  O   ASP C   4      27.024  24.484  28.695  1.00101.61           O  
ATOM   1479  CB  ASP C   4      25.431  25.360  25.646  1.00101.61           C  
ATOM   1480  CG  ASP C   4      24.242  26.278  25.462  1.00101.61           C  
ATOM   1481  OD1 ASP C   4      24.451  27.501  25.278  1.00101.61           O  
ATOM   1482  OD2 ASP C   4      23.098  25.774  25.505  1.00101.61           O  
ATOM   1483  N   THR C   5      24.814  24.608  28.123  1.00 91.53           N  
ATOM   1484  CA  THR C   5      24.199  23.814  29.183  1.00 91.53           C  
ATOM   1485  C   THR C   5      24.645  24.343  30.527  1.00 91.53           C  
ATOM   1486  O   THR C   5      25.002  23.586  31.427  1.00 91.53           O  
ATOM   1487  CB  THR C   5      24.483  22.296  29.066  1.00101.48           C  
ATOM   1488  OG1 THR C   5      23.673  21.601  30.021  1.00101.48           O  
ATOM   1489  CG2 THR C   5      25.946  21.979  29.326  1.00101.48           C  
ATOM   1490  N   THR C   6      24.608  25.671  30.630  1.00 52.93           N  
ATOM   1491  CA  THR C   6      24.975  26.399  31.837  1.00 52.93           C  
ATOM   1492  C   THR C   6      23.740  26.588  32.724  1.00 52.93           C  
ATOM   1493  O   THR C   6      22.623  26.753  32.221  1.00 52.93           O  
ATOM   1494  CB  THR C   6      25.541  27.777  31.480  1.00 58.53           C  
ATOM   1495  OG1 THR C   6      24.687  28.404  30.514  1.00 58.53           O  
ATOM   1496  CG2 THR C   6      26.934  27.643  30.911  1.00 58.53           C  
ATOM   1497  N   ILE C   7      23.946  26.569  34.040  1.00 24.11           N  
ATOM   1498  CA  ILE C   7      22.846  26.732  34.980  1.00 24.11           C  
ATOM   1499  C   ILE C   7      23.239  27.499  36.235  1.00 24.11           C  
ATOM   1500  O   ILE C   7      24.404  27.507  36.636  1.00 24.11           O  
ATOM   1501  CB  ILE C   7      22.330  25.373  35.461  1.00 26.93           C  
ATOM   1502  CG1 ILE C   7      21.104  25.557  36.363  1.00 26.93           C  
ATOM   1503  CG2 ILE C   7      23.413  24.678  36.270  1.00 26.93           C  
ATOM   1504  CD1 ILE C   7      20.554  24.266  36.946  1.00 26.93           C  
ATOM   1505  N   THR C   8      22.259  28.151  36.849  1.00 25.25           N  
ATOM   1506  CA  THR C   8      22.497  28.845  38.106  1.00 25.25           C  
ATOM   1507  C   THR C   8      21.520  28.240  39.099  1.00 25.25           C  
ATOM   1508  O   THR C   8      20.317  28.124  38.817  1.00 25.25           O  
ATOM   1509  CB  THR C   8      22.257  30.350  38.011  1.00 25.52           C  
ATOM   1510  OG1 THR C   8      23.356  30.952  37.325  1.00 25.52           O  
ATOM   1511  CG2 THR C   8      22.174  30.960  39.396  1.00 25.52           C  
ATOM   1512  N   ILE C   9      22.049  27.830  40.250  1.00 45.92           N  
ATOM   1513  CA  ILE C   9      21.232  27.217  41.282  1.00 45.92           C  
ATOM   1514  C   ILE C   9      21.298  28.032  42.558  1.00 45.92           C  
ATOM   1515  O   ILE C   9      22.285  28.728  42.832  1.00 45.92           O  
ATOM   1516  CB  ILE C   9      21.702  25.772  41.615  1.00 59.41           C  
ATOM   1517  CG1 ILE C   9      21.829  24.934  40.341  1.00 59.41           C  
ATOM   1518  CG2 ILE C   9      20.698  25.102  42.522  1.00 59.41           C  
ATOM   1519  CD1 ILE C   9      23.098  25.171  39.568  1.00 59.41           C  
ATOM   1520  N   VAL C  10      20.226  27.940  43.331  1.00 70.86           N  
ATOM   1521  CA  VAL C  10      20.131  28.622  44.605  1.00 70.86           C  
ATOM   1522  C   VAL C  10      19.506  27.634  45.574  1.00 70.86           C  
ATOM   1523  O   VAL C  10      18.481  27.003  45.277  1.00 70.86           O  
ATOM   1524  CB  VAL C  10      19.254  29.869  44.503  1.00 24.32           C  
ATOM   1525  CG1 VAL C  10      19.279  30.632  45.806  1.00 24.32           C  
ATOM   1526  CG2 VAL C  10      19.752  30.747  43.358  1.00 24.32           C  
ATOM   1527  N   GLY C  11      20.145  27.482  46.724  1.00 45.41           N  
ATOM   1528  CA  GLY C  11      19.645  26.552  47.714  1.00 45.41           C  
ATOM   1529  C   GLY C  11      20.643  26.349  48.835  1.00 45.41           C  
ATOM   1530  O   GLY C  11      21.710  26.973  48.863  1.00 45.41           O  
ATOM   1531  N   ASN C  12      20.287  25.470  49.764  1.00 45.85           N  
ATOM   1532  CA  ASN C  12      21.130  25.181  50.903  1.00 45.85           C  
ATOM   1533  C   ASN C  12      21.795  23.834  50.720  1.00 45.85           C  
ATOM   1534  O   ASN C  12      21.278  22.956  50.035  1.00 45.85           O  
ATOM   1535  CB  ASN C  12      20.288  25.175  52.168  1.00 60.76           C  
ATOM   1536  CG  ASN C  12      19.370  26.365  52.247  1.00 60.76           C  
ATOM   1537  OD1 ASN C  12      19.808  27.503  52.457  1.00 60.76           O  
ATOM   1538  ND2 ASN C  12      18.080  26.117  52.057  1.00 60.76           N  
ATOM   1539  N   LEU C  13      22.956  23.680  51.335  1.00 32.14           N  
ATOM   1540  CA  LEU C  13      23.688  22.434  51.249  1.00 32.14           C  
ATOM   1541  C   LEU C  13      23.022  21.362  52.119  1.00 32.14           C  
ATOM   1542  O   LEU C  13      22.642  21.605  53.274  1.00 32.14           O  
ATOM   1543  CB  LEU C  13      25.137  22.646  51.697  1.00 50.85           C  
ATOM   1544  CG  LEU C  13      25.948  23.596  50.825  1.00 50.85           C  
ATOM   1545  CD1 LEU C  13      27.360  23.731  51.372  1.00 50.85           C  
ATOM   1546  CD2 LEU C  13      25.962  23.057  49.416  1.00 50.85           C  
ATOM   1547  N   THR C  14      22.874  20.173  51.549  1.00 73.65           N  
ATOM   1548  CA  THR C  14      22.272  19.068  52.269  1.00 73.65           C  
ATOM   1549  C   THR C  14      23.148  18.712  53.458  1.00 73.65           C  
ATOM   1550  O   THR C  14      22.649  18.333  54.516  1.00 73.65           O  
ATOM   1551  CB  THR C  14      22.126  17.856  51.361  1.00 21.98           C  
ATOM   1552  OG1 THR C  14      23.334  17.669  50.620  1.00 21.98           O  
ATOM   1553  CG2 THR C  14      20.993  18.074  50.390  1.00 21.98           C  
ATOM   1554  N   ALA C  15      24.457  18.841  53.275  1.00 71.10           N  
ATOM   1555  CA  ALA C  15      25.423  18.539  54.325  1.00 71.10           C  
ATOM   1556  C   ALA C  15      26.671  19.348  54.050  1.00 71.10           C  
ATOM   1557  O   ALA C  15      26.685  20.186  53.155  1.00 71.10           O  
ATOM   1558  CB  ALA C  15      25.759  17.055  54.329  1.00 75.93           C  
ATOM   1559  N   ASP C  16      27.723  19.096  54.819  1.00 48.97           N  
ATOM   1560  CA  ASP C  16      28.984  19.811  54.635  1.00 48.97           C  
ATOM   1561  C   ASP C  16      29.683  19.296  53.371  1.00 48.97           C  
ATOM   1562  O   ASP C  16      29.504  18.152  52.969  1.00 48.97           O  
ATOM   1563  CB  ASP C  16      29.887  19.631  55.869  1.00101.33           C  
ATOM   1564  CG  ASP C  16      29.233  20.130  57.157  1.00101.33           C  
ATOM   1565  OD1 ASP C  16      29.923  20.206  58.200  1.00101.33           O  
ATOM   1566  OD2 ASP C  16      28.024  20.441  57.127  1.00101.33           O  
ATOM   1567  N   PRO C  17      30.477  20.145  52.721  1.00 56.65           N  
ATOM   1568  CA  PRO C  17      31.162  19.709  51.507  1.00 56.65           C  
ATOM   1569  C   PRO C  17      32.159  18.584  51.751  1.00 56.65           C  
ATOM   1570  O   PRO C  17      32.957  18.651  52.681  1.00 56.65           O  
ATOM   1571  CB  PRO C  17      31.843  20.983  51.026  1.00 64.32           C  
ATOM   1572  CG  PRO C  17      30.948  22.054  51.538  1.00 64.32           C  
ATOM   1573  CD  PRO C  17      30.654  21.585  52.933  1.00 64.32           C  
ATOM   1574  N   GLU C  18      32.118  17.552  50.912  1.00 50.29           N  
ATOM   1575  CA  GLU C  18      33.040  16.430  51.046  1.00 50.29           C  
ATOM   1576  C   GLU C  18      34.285  16.700  50.220  1.00 50.29           C  
ATOM   1577  O   GLU C  18      34.197  16.966  49.022  1.00 50.29           O  
ATOM   1578  CB  GLU C  18      32.372  15.139  50.577  1.00100.65           C  
ATOM   1579  CG  GLU C  18      31.073  14.813  51.301  1.00100.65           C  
ATOM   1580  CD  GLU C  18      30.663  13.352  51.155  1.00100.65           C  
ATOM   1581  OE1 GLU C  18      29.527  13.007  51.548  1.00100.65           O  
ATOM   1582  OE2 GLU C  18      31.478  12.542  50.656  1.00100.65           O  
ATOM   1583  N   LEU C  19      35.446  16.627  50.861  1.00 92.01           N  
ATOM   1584  CA  LEU C  19      36.705  16.890  50.177  1.00 92.01           C  
ATOM   1585  C   LEU C  19      37.506  15.633  49.839  1.00 92.01           C  
ATOM   1586  O   LEU C  19      37.538  14.674  50.613  1.00 92.01           O  
ATOM   1587  CB  LEU C  19      37.565  17.816  51.029  1.00 27.05           C  
ATOM   1588  CG  LEU C  19      38.256  18.922  50.242  1.00 27.05           C  
ATOM   1589  CD1 LEU C  19      39.240  19.638  51.140  1.00 27.05           C  
ATOM   1590  CD2 LEU C  19      38.962  18.331  49.045  1.00 27.05           C  
ATOM   1591  N   ARG C  20      38.164  15.658  48.680  1.00 48.25           N  
ATOM   1592  CA  ARG C  20      38.972  14.531  48.207  1.00 48.25           C  
ATOM   1593  C   ARG C  20      40.043  14.996  47.215  1.00 48.25           C  
ATOM   1594  O   ARG C  20      39.945  16.091  46.652  1.00 48.25           O  
ATOM   1595  CB  ARG C  20      38.069  13.475  47.543  1.00 46.61           C  
ATOM   1596  N   PHE C  21      41.063  14.159  47.014  1.00 77.61           N  
ATOM   1597  CA  PHE C  21      42.158  14.469  46.087  1.00 77.61           C  
ATOM   1598  C   PHE C  21      42.417  13.257  45.186  1.00 77.61           C  
ATOM   1599  O   PHE C  21      41.480  12.693  44.626  1.00 77.61           O  
ATOM   1600  CB  PHE C  21      43.453  14.799  46.848  1.00 52.28           C  
ATOM   1601  CG  PHE C  21      43.296  15.826  47.939  1.00 52.28           C  
ATOM   1602  CD1 PHE C  21      42.552  15.543  49.084  1.00 52.28           C  
ATOM   1603  CD2 PHE C  21      43.933  17.062  47.842  1.00 52.28           C  
ATOM   1604  CE1 PHE C  21      42.446  16.478  50.122  1.00 52.28           C  
ATOM   1605  CE2 PHE C  21      43.837  18.003  48.869  1.00 52.28           C  
ATOM   1606  CZ  PHE C  21      43.092  17.709  50.011  1.00 52.28           C  
ATOM   1607  N   THR C  22      43.697  12.900  45.038  1.00101.61           N  
ATOM   1608  CA  THR C  22      44.159  11.725  44.279  1.00101.61           C  
ATOM   1609  C   THR C  22      44.292  11.794  42.735  1.00101.61           C  
ATOM   1610  O   THR C  22      43.833  12.754  42.114  1.00101.61           O  
ATOM   1611  CB  THR C  22      43.323  10.476  44.705  1.00101.61           C  
ATOM   1612  OG1 THR C  22      41.952  10.635  44.326  1.00101.61           O  
ATOM   1613  CG2 THR C  22      43.416  10.264  46.213  1.00101.61           C  
ATOM   1614  N   PRO C  23      44.916  10.759  42.107  1.00101.61           N  
ATOM   1615  CA  PRO C  23      45.167  10.595  40.678  1.00101.61           C  
ATOM   1616  C   PRO C  23      45.212  11.827  39.802  1.00101.61           C  
ATOM   1617  O   PRO C  23      44.620  11.873  38.722  1.00101.61           O  
ATOM   1618  CB  PRO C  23      44.104   9.585  40.284  1.00101.61           C  
ATOM   1619  CG  PRO C  23      44.114   8.628  41.530  1.00101.61           C  
ATOM   1620  CD  PRO C  23      44.845   9.400  42.659  1.00101.61           C  
ATOM   1621  N   SER C  24      45.974  12.800  40.284  1.00101.61           N  
ATOM   1622  CA  SER C  24      46.192  14.090  39.644  1.00101.61           C  
ATOM   1623  C   SER C  24      46.861  14.876  40.749  1.00101.61           C  
ATOM   1624  O   SER C  24      47.756  15.690  40.516  1.00101.61           O  
ATOM   1625  CB  SER C  24      44.867  14.784  39.298  1.00101.61           C  
ATOM   1626  OG  SER C  24      44.103  14.071  38.343  1.00101.61           O  
ATOM   1627  N   GLY C  25      46.413  14.585  41.968  1.00101.61           N  
ATOM   1628  CA  GLY C  25      46.902  15.271  43.144  1.00101.61           C  
ATOM   1629  C   GLY C  25      45.972  16.455  43.309  1.00101.61           C  
ATOM   1630  O   GLY C  25      46.265  17.409  44.034  1.00101.61           O  
ATOM   1631  N   ALA C  26      44.837  16.373  42.617  1.00 91.93           N  
ATOM   1632  CA  ALA C  26      43.823  17.424  42.618  1.00 91.93           C  
ATOM   1633  C   ALA C  26      42.926  17.394  43.848  1.00 91.93           C  
ATOM   1634  O   ALA C  26      42.915  16.414  44.584  1.00 91.93           O  
ATOM   1635  CB  ALA C  26      42.972  17.304  41.370  1.00 64.79           C  
ATOM   1636  N   ALA C  27      42.178  18.479  44.056  1.00 91.98           N  
ATOM   1637  CA  ALA C  27      41.247  18.598  45.177  1.00 91.98           C  
ATOM   1638  C   ALA C  27      39.823  18.597  44.623  1.00 91.98           C  
ATOM   1639  O   ALA C  27      39.408  19.537  43.953  1.00 91.98           O  
ATOM   1640  CB  ALA C  27      41.515  19.890  45.952  1.00 29.73           C  
ATOM   1641  N   VAL C  28      39.078  17.540  44.907  1.00 61.44           N  
ATOM   1642  CA  VAL C  28      37.720  17.423  44.405  1.00 61.44           C  
ATOM   1643  C   VAL C  28      36.654  17.490  45.488  1.00 61.44           C  
ATOM   1644  O   VAL C  28      36.264  16.467  46.044  1.00 61.44           O  
ATOM   1645  CB  VAL C  28      37.526  16.096  43.647  1.00 77.30           C  
ATOM   1646  CG1 VAL C  28      36.180  16.091  42.945  1.00 77.30           C  
ATOM   1647  CG2 VAL C  28      38.652  15.890  42.659  1.00 77.30           C  
ATOM   1648  N   ALA C  29      36.178  18.696  45.772  1.00 40.39           N  
ATOM   1649  CA  ALA C  29      35.136  18.895  46.768  1.00 40.39           C  
ATOM   1650  C   ALA C  29      33.792  18.663  46.107  1.00 40.39           C  
ATOM   1651  O   ALA C  29      33.525  19.191  45.032  1.00 40.39           O  
ATOM   1652  CB  ALA C  29      35.202  20.312  47.328  1.00 70.69           C  
ATOM   1653  N   ASN C  30      32.956  17.855  46.746  1.00 48.35           N  
ATOM   1654  CA  ASN C  30      31.622  17.557  46.235  1.00 48.35           C  
ATOM   1655  C   ASN C  30      30.618  18.053  47.258  1.00 48.35           C  
ATOM   1656  O   ASN C  30      30.996  18.550  48.310  1.00 48.35           O  
ATOM   1657  CB  ASN C  30      31.435  16.048  46.019  1.00 88.42           C  
ATOM   1658  CG  ASN C  30      32.220  15.522  44.832  1.00 88.42           C  
ATOM   1659  OD1 ASN C  30      33.437  15.683  44.756  1.00 88.42           O  
ATOM   1660  ND2 ASN C  30      31.524  14.883  43.899  1.00 88.42           N  
ATOM   1661  N   PHE C  31      29.341  17.915  46.943  1.00 47.31           N  
ATOM   1662  CA  PHE C  31      28.274  18.355  47.825  1.00 47.31           C  
ATOM   1663  C   PHE C  31      27.045  18.536  46.974  1.00 47.31           C  
ATOM   1664  O   PHE C  31      27.159  18.817  45.784  1.00 47.31           O  
ATOM   1665  CB  PHE C  31      28.615  19.693  48.465  1.00 45.94           C  
ATOM   1666  CG  PHE C  31      28.793  20.803  47.478  1.00 45.94           C  
ATOM   1667  CD1 PHE C  31      29.965  20.927  46.747  1.00 45.94           C  
ATOM   1668  CD2 PHE C  31      27.781  21.721  47.275  1.00 45.94           C  
ATOM   1669  CE1 PHE C  31      30.126  21.948  45.825  1.00 45.94           C  
ATOM   1670  CE2 PHE C  31      27.928  22.750  46.351  1.00 45.94           C  
ATOM   1671  CZ  PHE C  31      29.105  22.863  45.625  1.00 45.94           C  
ATOM   1672  N   THR C  32      25.869  18.388  47.569  1.00 23.35           N  
ATOM   1673  CA  THR C  32      24.649  18.558  46.802  1.00 23.35           C  
ATOM   1674  C   THR C  32      23.792  19.689  47.380  1.00 23.35           C  
ATOM   1675  O   THR C  32      23.650  19.814  48.601  1.00 23.35           O  
ATOM   1676  CB  THR C  32      23.844  17.238  46.732  1.00  8.28           C  
ATOM   1677  OG1 THR C  32      22.655  17.357  47.522  1.00  8.28           O  
ATOM   1678  CG2 THR C  32      24.694  16.067  47.236  1.00  8.28           C  
ATOM   1679  N   VAL C  33      23.265  20.524  46.480  1.00 29.73           N  
ATOM   1680  CA  VAL C  33      22.429  21.668  46.837  1.00 29.73           C  
ATOM   1681  C   VAL C  33      20.967  21.238  46.832  1.00 29.73           C  
ATOM   1682  O   VAL C  33      20.558  20.430  45.989  1.00 29.73           O  
ATOM   1683  CB  VAL C  33      22.601  22.821  45.814  1.00 29.08           C  
ATOM   1684  CG1 VAL C  33      21.841  24.064  46.267  1.00 29.08           C  
ATOM   1685  CG2 VAL C  33      24.065  23.143  45.647  1.00 29.08           C  
ATOM   1686  N   ALA C  34      20.184  21.761  47.775  1.00 45.76           N  
ATOM   1687  CA  ALA C  34      18.763  21.441  47.856  1.00 45.76           C  
ATOM   1688  C   ALA C  34      17.978  22.704  47.521  1.00 45.76           C  
ATOM   1689  O   ALA C  34      17.981  23.671  48.280  1.00 45.76           O  
ATOM   1690  CB  ALA C  34      18.412  20.955  49.247  1.00 97.04           C  
ATOM   1691  N   SER C  35      17.312  22.696  46.374  1.00 54.11           N  
ATOM   1692  CA  SER C  35      16.541  23.850  45.937  1.00 54.11           C  
ATOM   1693  C   SER C  35      15.077  23.721  46.364  1.00 54.11           C  
ATOM   1694  O   SER C  35      14.430  22.701  46.100  1.00 54.11           O  
ATOM   1695  CB  SER C  35      16.646  23.987  44.417  1.00 55.20           C  
ATOM   1696  OG  SER C  35      15.977  25.141  43.941  1.00 55.20           O  
ATOM   1697  N   THR C  36      14.575  24.767  47.027  1.00101.61           N  
ATOM   1698  CA  THR C  36      13.195  24.850  47.534  1.00101.61           C  
ATOM   1699  C   THR C  36      12.689  23.578  48.211  1.00101.61           C  
ATOM   1700  O   THR C  36      13.518  22.697  48.514  1.00101.61           O  
ATOM   1701  CB  THR C  36      12.184  25.250  46.420  1.00 86.42           C  
ATOM   1702  OG1 THR C  36      12.264  24.318  45.332  1.00 86.42           O  
ATOM   1703  CG2 THR C  36      12.476  26.658  45.909  1.00 86.42           C  
ATOM   1704  N   GLU C  51       8.521  20.598  43.773  1.00100.27           N  
ATOM   1705  CA  GLU C  51       9.314  21.210  44.879  1.00100.27           C  
ATOM   1706  C   GLU C  51      10.514  20.335  45.255  1.00100.27           C  
ATOM   1707  O   GLU C  51      10.522  19.130  44.989  1.00100.27           O  
ATOM   1708  CB  GLU C  51       8.418  21.423  46.095  1.00 91.20           C  
ATOM   1709  N   ALA C  52      11.524  20.953  45.864  1.00101.61           N  
ATOM   1710  CA  ALA C  52      12.741  20.259  46.296  1.00101.61           C  
ATOM   1711  C   ALA C  52      13.498  19.525  45.185  1.00101.61           C  
ATOM   1712  O   ALA C  52      13.206  18.369  44.884  1.00101.61           O  
ATOM   1713  CB  ALA C  52      12.409  19.280  47.429  1.00 39.00           C  
ATOM   1714  N   LEU C  53      14.478  20.198  44.588  1.00 55.61           N  
ATOM   1715  CA  LEU C  53      15.293  19.614  43.525  1.00 55.61           C  
ATOM   1716  C   LEU C  53      16.637  19.322  44.184  1.00 55.61           C  
ATOM   1717  O   LEU C  53      17.099  20.107  45.001  1.00 55.61           O  
ATOM   1718  CB  LEU C  53      15.469  20.629  42.393  1.00 34.58           C  
ATOM   1719  CG  LEU C  53      15.983  20.220  41.009  1.00 34.58           C  
ATOM   1720  CD1 LEU C  53      16.750  21.421  40.451  1.00 34.58           C  
ATOM   1721  CD2 LEU C  53      16.898  19.003  41.062  1.00 34.58           C  
ATOM   1722  N   PHE C  54      17.265  18.200  43.848  1.00 49.08           N  
ATOM   1723  CA  PHE C  54      18.553  17.862  44.454  1.00 49.08           C  
ATOM   1724  C   PHE C  54      19.668  17.646  43.443  1.00 49.08           C  
ATOM   1725  O   PHE C  54      19.794  16.563  42.876  1.00 49.08           O  
ATOM   1726  CB  PHE C  54      18.446  16.593  45.302  1.00101.34           C  
ATOM   1727  CG  PHE C  54      17.472  16.693  46.430  1.00101.34           C  
ATOM   1728  CD1 PHE C  54      16.101  16.657  46.188  1.00101.34           C  
ATOM   1729  CD2 PHE C  54      17.921  16.803  47.739  1.00101.34           C  
ATOM   1730  CE1 PHE C  54      15.186  16.728  47.236  1.00101.34           C  
ATOM   1731  CE2 PHE C  54      17.018  16.875  48.793  1.00101.34           C  
ATOM   1732  CZ  PHE C  54      15.645  16.835  48.541  1.00101.34           C  
ATOM   1733  N   LEU C  55      20.495  18.661  43.235  1.00 71.07           N  
ATOM   1734  CA  LEU C  55      21.605  18.538  42.299  1.00 71.07           C  
ATOM   1735  C   LEU C  55      22.927  18.352  43.042  1.00 71.07           C  
ATOM   1736  O   LEU C  55      23.286  19.148  43.916  1.00 71.07           O  
ATOM   1737  CB  LEU C  55      21.698  19.780  41.416  1.00 54.96           C  
ATOM   1738  CG  LEU C  55      20.415  20.174  40.686  1.00 54.96           C  
ATOM   1739  CD1 LEU C  55      20.624  21.487  39.933  1.00 54.96           C  
ATOM   1740  CD2 LEU C  55      20.004  19.062  39.733  1.00 54.96           C  
ATOM   1741  N   ARG C  56      23.648  17.290  42.702  1.00 51.79           N  
ATOM   1742  CA  ARG C  56      24.932  17.033  43.330  1.00 51.79           C  
ATOM   1743  C   ARG C  56      25.962  17.814  42.511  1.00 51.79           C  
ATOM   1744  O   ARG C  56      25.978  17.726  41.285  1.00 51.79           O  
ATOM   1745  CB  ARG C  56      25.226  15.523  43.336  1.00101.61           C  
ATOM   1746  CG  ARG C  56      24.243  14.648  42.522  1.00101.61           C  
ATOM   1747  CD  ARG C  56      22.803  14.593  43.086  1.00101.61           C  
ATOM   1748  NE  ARG C  56      22.704  13.974  44.414  1.00101.61           N  
ATOM   1749  CZ  ARG C  56      21.557  13.703  45.045  1.00101.61           C  
ATOM   1750  NH1 ARG C  56      20.392  13.988  44.478  1.00101.61           N  
ATOM   1751  NH2 ARG C  56      21.569  13.152  46.253  1.00101.61           N  
ATOM   1752  N   CYS C  57      26.799  18.599  43.186  1.00 44.86           N  
ATOM   1753  CA  CYS C  57      27.814  19.430  42.524  1.00 44.86           C  
ATOM   1754  C   CYS C  57      29.270  19.006  42.736  1.00 44.86           C  
ATOM   1755  O   CYS C  57      29.602  18.289  43.683  1.00 44.86           O  
ATOM   1756  CB  CYS C  57      27.689  20.874  42.994  1.00 42.89           C  
ATOM   1757  SG  CYS C  57      26.126  21.624  42.654  1.00 42.89           S  
ATOM   1758  N   ASN C  58      30.143  19.495  41.863  1.00 61.68           N  
ATOM   1759  CA  ASN C  58      31.562  19.188  41.947  1.00 61.68           C  
ATOM   1760  C   ASN C  58      32.352  20.430  41.610  1.00 61.68           C  
ATOM   1761  O   ASN C  58      32.041  21.123  40.639  1.00 61.68           O  
ATOM   1762  CB  ASN C  58      31.925  18.106  40.942  1.00 57.53           C  
ATOM   1763  CG  ASN C  58      30.905  17.020  40.889  1.00 57.53           C  
ATOM   1764  OD1 ASN C  58      30.789  16.222  41.818  1.00 57.53           O  
ATOM   1765  ND2 ASN C  58      30.132  16.986  39.806  1.00 57.53           N  
ATOM   1766  N   ILE C  59      33.363  20.723  42.416  1.00 48.37           N  
ATOM   1767  CA  ILE C  59      34.215  21.869  42.141  1.00 48.37           C  
ATOM   1768  C   ILE C  59      35.660  21.493  42.463  1.00 48.37           C  
ATOM   1769  O   ILE C  59      36.004  21.172  43.601  1.00 48.37           O  
ATOM   1770  CB  ILE C  59      33.759  23.118  42.921  1.00 18.61           C  
ATOM   1771  CG1 ILE C  59      34.497  24.354  42.370  1.00 18.61           C  
ATOM   1772  CG2 ILE C  59      33.912  22.885  44.425  1.00 18.61           C  
ATOM   1773  CD1 ILE C  59      33.945  25.694  42.831  1.00 18.61           C  
ATOM   1774  N   TRP C  60      36.485  21.509  41.423  1.00 66.36           N  
ATOM   1775  CA  TRP C  60      37.888  21.132  41.502  1.00 66.36           C  
ATOM   1776  C   TRP C  60      38.849  22.219  41.981  1.00 66.36           C  
ATOM   1777  O   TRP C  60      38.438  23.324  42.346  1.00 66.36           O  
ATOM   1778  CB  TRP C  60      38.333  20.617  40.122  1.00 70.34           C  
ATOM   1779  CG  TRP C  60      38.309  19.120  39.989  1.00 70.34           C  
ATOM   1780  CD1 TRP C  60      39.354  18.267  40.197  1.00 70.34           C  
ATOM   1781  CD2 TRP C  60      37.168  18.297  39.718  1.00 70.34           C  
ATOM   1782  NE1 TRP C  60      38.934  16.965  40.081  1.00 70.34           N  
ATOM   1783  CE2 TRP C  60      37.600  16.954  39.792  1.00 70.34           C  
ATOM   1784  CE3 TRP C  60      35.827  18.565  39.430  1.00 70.34           C  
ATOM   1785  CZ2 TRP C  60      36.729  15.875  39.585  1.00 70.34           C  
ATOM   1786  CZ3 TRP C  60      34.959  17.487  39.224  1.00 70.34           C  
ATOM   1787  CH2 TRP C  60      35.418  16.160  39.305  1.00 70.34           C  
ATOM   1788  N   ARG C  61      40.136  21.866  41.983  1.00 53.77           N  
ATOM   1789  CA  ARG C  61      41.230  22.744  42.378  1.00 53.77           C  
ATOM   1790  C   ARG C  61      41.032  23.460  43.714  1.00 53.77           C  
ATOM   1791  O   ARG C  61      40.246  23.018  44.560  1.00 53.77           O  
ATOM   1792  CB  ARG C  61      41.493  23.759  41.269  1.00 57.15           C  
ATOM   1793  N   GLU C  62      41.762  24.564  43.888  1.00 57.98           N  
ATOM   1794  CA  GLU C  62      41.720  25.380  45.104  1.00 57.98           C  
ATOM   1795  C   GLU C  62      40.301  25.758  45.529  1.00 57.98           C  
ATOM   1796  O   GLU C  62      39.981  25.745  46.718  1.00 57.98           O  
ATOM   1797  CB  GLU C  62      42.553  26.635  44.904  1.00 76.21           C  
ATOM   1798  N   ALA C  63      39.459  26.097  44.553  1.00 85.65           N  
ATOM   1799  CA  ALA C  63      38.074  26.467  44.821  1.00 85.65           C  
ATOM   1800  C   ALA C  63      37.467  25.471  45.798  1.00 85.65           C  
ATOM   1801  O   ALA C  63      36.596  25.816  46.595  1.00 85.65           O  
ATOM   1802  CB  ALA C  63      37.284  26.474  43.529  1.00101.61           C  
ATOM   1803  N   ALA C  64      37.933  24.228  45.724  1.00 99.42           N  
ATOM   1804  CA  ALA C  64      37.453  23.180  46.608  1.00 99.42           C  
ATOM   1805  C   ALA C  64      37.930  23.481  48.024  1.00 99.42           C  
ATOM   1806  O   ALA C  64      37.162  23.370  48.985  1.00 99.42           O  
ATOM   1807  CB  ALA C  64      37.976  21.832  46.151  1.00 93.64           C  
ATOM   1808  N   GLU C  65      39.203  23.856  48.154  1.00 97.84           N  
ATOM   1809  CA  GLU C  65      39.746  24.194  49.466  1.00 97.84           C  
ATOM   1810  C   GLU C  65      38.776  25.198  50.090  1.00 97.84           C  
ATOM   1811  O   GLU C  65      38.247  24.976  51.178  1.00 97.84           O  
ATOM   1812  CB  GLU C  65      41.165  24.810  49.351  1.00 99.81           C  
ATOM   1813  CG  GLU C  65      42.331  23.791  49.326  1.00 99.81           C  
ATOM   1814  CD  GLU C  65      43.739  24.427  49.302  1.00 99.81           C  
ATOM   1815  OE1 GLU C  65      44.059  25.246  50.194  1.00 99.81           O  
ATOM   1816  OE2 GLU C  65      44.536  24.089  48.393  1.00 99.81           O  
ATOM   1817  N   ASN C  66      38.515  26.280  49.361  1.00 53.46           N  
ATOM   1818  CA  ASN C  66      37.619  27.345  49.814  1.00 53.46           C  
ATOM   1819  C   ASN C  66      36.177  26.909  50.083  1.00 53.46           C  
ATOM   1820  O   ASN C  66      35.572  27.355  51.056  1.00 53.46           O  
ATOM   1821  CB  ASN C  66      37.626  28.491  48.798  1.00 51.97           C  
ATOM   1822  CG  ASN C  66      39.031  28.954  48.458  1.00 51.97           C  
ATOM   1823  OD1 ASN C  66      39.769  29.417  49.321  1.00 51.97           O  
ATOM   1824  ND2 ASN C  66      39.408  28.820  47.196  1.00 51.97           N  
ATOM   1825  N   VAL C  67      35.623  26.055  49.228  1.00 55.12           N  
ATOM   1826  CA  VAL C  67      34.251  25.592  49.422  1.00 55.12           C  
ATOM   1827  C   VAL C  67      34.112  24.914  50.770  1.00 55.12           C  
ATOM   1828  O   VAL C  67      33.118  25.076  51.459  1.00 55.12           O  
ATOM   1829  CB  VAL C  67      33.802  24.633  48.303  1.00 52.86           C  
ATOM   1830  CG1 VAL C  67      32.509  23.934  48.702  1.00 52.86           C  
ATOM   1831  CG2 VAL C  67      33.586  25.415  47.006  1.00 52.86           C  
ATOM   1832  N   ALA C  68      35.129  24.129  51.133  1.00 89.04           N  
ATOM   1833  CA  ALA C  68      35.150  23.491  52.436  1.00 89.04           C  
ATOM   1834  C   ALA C  68      36.109  24.179  53.325  1.00 89.04           C  
ATOM   1835  O   ALA C  68      37.303  23.843  53.349  1.00 89.04           O  
ATOM   1836  CB  ALA C  68      35.452  22.015  52.293  1.00 66.84           C  
ATOM   1837  N   GLU C  69      35.593  25.243  53.972  1.00 79.66           N  
ATOM   1838  CA  GLU C  69      36.125  26.063  55.063  1.00 79.66           C  
ATOM   1839  C   GLU C  69      35.398  27.303  55.030  1.00 79.66           C  
ATOM   1840  O   GLU C  69      35.830  28.338  55.527  1.00 79.66           O  
ATOM   1841  CB  GLU C  69      37.729  26.190  55.179  1.00 51.60           C  
ATOM   1842  N   SER C  70      34.249  27.216  54.382  1.00 49.28           N  
ATOM   1843  CA  SER C  70      33.349  28.354  54.299  1.00 49.28           C  
ATOM   1844  C   SER C  70      31.941  27.838  54.490  1.00 49.28           C  
ATOM   1845  O   SER C  70      31.256  28.147  55.480  1.00 49.28           O  
ATOM   1846  CB  SER C  70      33.443  29.023  52.930  1.00 18.34           C  
ATOM   1847  OG  SER C  70      34.735  29.546  52.709  1.00 18.34           O  
ATOM   1848  N   LEU C  71      31.535  27.015  53.531  1.00 53.70           N  
ATOM   1849  CA  LEU C  71      30.213  26.415  53.531  1.00 53.70           C  
ATOM   1850  C   LEU C  71      30.072  25.229  54.494  1.00 53.70           C  
ATOM   1851  O   LEU C  71      31.043  24.515  54.789  1.00 53.70           O  
ATOM   1852  CB  LEU C  71      29.848  25.968  52.113  1.00 61.24           C  
ATOM   1853  CG  LEU C  71      30.078  26.968  50.973  1.00 61.24           C  
ATOM   1854  CD1 LEU C  71      29.280  26.535  49.741  1.00 61.24           C  
ATOM   1855  CD2 LEU C  71      29.646  28.350  51.408  1.00 61.24           C  
ATOM   1856  N   THR C  72      28.844  25.035  54.976  1.00 58.69           N  
ATOM   1857  CA  THR C  72      28.510  23.956  55.900  1.00 58.69           C  
ATOM   1858  C   THR C  72      27.082  23.523  55.592  1.00 58.69           C  
ATOM   1859  O   THR C  72      26.380  24.202  54.847  1.00 58.69           O  
ATOM   1860  CB  THR C  72      28.609  24.439  57.355  1.00 54.21           C  
ATOM   1861  OG1 THR C  72      27.936  25.700  57.487  1.00 54.21           O  
ATOM   1862  CG2 THR C  72      30.062  24.609  57.751  1.00 54.21           C  
ATOM   1863  N   ARG C  73      26.644  22.405  56.160  1.00 42.92           N  
ATOM   1864  CA  ARG C  73      25.299  21.919  55.885  1.00 42.92           C  
ATOM   1865  C   ARG C  73      24.240  22.959  56.196  1.00 42.92           C  
ATOM   1866  O   ARG C  73      24.307  23.626  57.230  1.00 42.92           O  
ATOM   1867  CB  ARG C  73      24.992  20.664  56.691  1.00 66.24           C  
ATOM   1868  CG  ARG C  73      24.626  20.924  58.139  1.00 66.24           C  
ATOM   1869  CD  ARG C  73      23.744  19.817  58.672  1.00 66.24           C  
ATOM   1870  NE  ARG C  73      22.476  19.756  57.950  1.00 66.24           N  
ATOM   1871  CZ  ARG C  73      21.400  19.111  58.389  1.00 66.24           C  
ATOM   1872  NH1 ARG C  73      20.284  19.106  57.669  1.00 66.24           N  
ATOM   1873  NH2 ARG C  73      21.440  18.478  59.552  1.00 66.24           N  
ATOM   1874  N   GLY C  74      23.256  23.076  55.300  1.00 53.72           N  
ATOM   1875  CA  GLY C  74      22.172  24.030  55.475  1.00 53.72           C  
ATOM   1876  C   GLY C  74      22.492  25.429  54.968  1.00 53.72           C  
ATOM   1877  O   GLY C  74      21.678  26.347  55.091  1.00 53.72           O  
ATOM   1878  N   ALA C  75      23.675  25.598  54.390  1.00 44.90           N  
ATOM   1879  CA  ALA C  75      24.086  26.899  53.886  1.00 44.90           C  
ATOM   1880  C   ALA C  75      23.470  27.229  52.540  1.00 44.90           C  
ATOM   1881  O   ALA C  75      23.545  26.430  51.609  1.00 44.90           O  
ATOM   1882  CB  ALA C  75      25.586  26.952  53.776  1.00  2.61           C  
ATOM   1883  N   ARG C  76      22.864  28.411  52.444  1.00 37.73           N  
ATOM   1884  CA  ARG C  76      22.262  28.868  51.197  1.00 37.73           C  
ATOM   1885  C   ARG C  76      23.390  29.442  50.340  1.00 37.73           C  
ATOM   1886  O   ARG C  76      24.089  30.385  50.741  1.00 37.73           O  
ATOM   1887  CB  ARG C  76      21.208  29.937  51.465  1.00 34.12           C  
ATOM   1888  CG  ARG C  76      20.634  30.537  50.208  1.00 34.12           C  
ATOM   1889  CD  ARG C  76      19.795  31.737  50.558  1.00 34.12           C  
ATOM   1890  NE  ARG C  76      18.377  31.492  50.316  1.00 34.12           N  
ATOM   1891  CZ  ARG C  76      17.753  31.772  49.169  1.00 34.12           C  
ATOM   1892  NH1 ARG C  76      18.426  32.314  48.159  1.00 34.12           N  
ATOM   1893  NH2 ARG C  76      16.454  31.514  49.019  1.00 34.12           N  
ATOM   1894  N   VAL C  77      23.547  28.861  49.154  1.00 26.81           N  
ATOM   1895  CA  VAL C  77      24.595  29.236  48.223  1.00 26.81           C  
ATOM   1896  C   VAL C  77      24.075  29.581  46.817  1.00 26.81           C  
ATOM   1897  O   VAL C  77      22.900  29.370  46.495  1.00 26.81           O  
ATOM   1898  CB  VAL C  77      25.577  28.061  48.075  1.00 25.40           C  
ATOM   1899  CG1 VAL C  77      26.313  27.810  49.368  1.00 25.40           C  
ATOM   1900  CG2 VAL C  77      24.802  26.817  47.680  1.00 25.40           C  
ATOM   1901  N   ILE C  78      24.963  30.121  45.986  1.00 31.42           N  
ATOM   1902  CA  ILE C  78      24.624  30.423  44.602  1.00 31.42           C  
ATOM   1903  C   ILE C  78      25.654  29.685  43.783  1.00 31.42           C  
ATOM   1904  O   ILE C  78      26.849  29.901  43.912  1.00 31.42           O  
ATOM   1905  CB  ILE C  78      24.696  31.912  44.277  1.00 31.98           C  
ATOM   1906  CG1 ILE C  78      23.655  32.650  45.096  1.00 31.98           C  
ATOM   1907  CG2 ILE C  78      24.377  32.148  42.814  1.00 31.98           C  
ATOM   1908  CD1 ILE C  78      23.405  34.041  44.614  1.00 31.98           C  
ATOM   1909  N   VAL C  79      25.184  28.784  42.951  1.00 21.86           N  
ATOM   1910  CA  VAL C  79      26.088  28.011  42.141  1.00 21.86           C  
ATOM   1911  C   VAL C  79      25.861  28.354  40.686  1.00 21.86           C  
ATOM   1912  O   VAL C  79      24.731  28.643  40.265  1.00 21.86           O  
ATOM   1913  CB  VAL C  79      25.837  26.508  42.312  1.00 19.13           C  
ATOM   1914  CG1 VAL C  79      26.950  25.723  41.653  1.00 19.13           C  
ATOM   1915  CG2 VAL C  79      25.721  26.161  43.790  1.00 19.13           C  
ATOM   1916  N   SER C  80      26.944  28.339  39.920  1.00 52.61           N  
ATOM   1917  CA  SER C  80      26.879  28.608  38.494  1.00 52.61           C  
ATOM   1918  C   SER C  80      27.761  27.539  37.866  1.00 52.61           C  
ATOM   1919  O   SER C  80      28.923  27.383  38.263  1.00 52.61           O  
ATOM   1920  CB  SER C  80      27.427  30.000  38.182  1.00 68.75           C  
ATOM   1921  OG  SER C  80      27.129  30.351  36.847  1.00 68.75           O  
ATOM   1922  N   GLY C  81      27.208  26.790  36.911  1.00 28.01           N  
ATOM   1923  CA  GLY C  81      27.984  25.747  36.275  1.00 28.01           C  
ATOM   1924  C   GLY C  81      27.295  24.986  35.169  1.00 28.01           C  
ATOM   1925  O   GLY C  81      26.107  25.156  34.931  1.00 28.01           O  
ATOM   1926  N   ARG C  82      28.062  24.121  34.511  1.00 52.84           N  
ATOM   1927  CA  ARG C  82      27.596  23.302  33.392  1.00 52.84           C  
ATOM   1928  C   ARG C  82      26.977  21.997  33.865  1.00 52.84           C  
ATOM   1929  O   ARG C  82      27.496  21.374  34.789  1.00 52.84           O  
ATOM   1930  CB  ARG C  82      28.776  22.960  32.475  1.00 96.47           C  
ATOM   1931  CG  ARG C  82      29.609  24.147  32.018  1.00 96.47           C  
ATOM   1932  CD  ARG C  82      31.029  23.706  31.667  1.00 96.47           C  
ATOM   1933  NE  ARG C  82      31.869  23.554  32.861  1.00 96.47           N  
ATOM   1934  CZ  ARG C  82      32.866  22.678  32.980  1.00 96.47           C  
ATOM   1935  NH1 ARG C  82      33.151  21.859  31.974  1.00 96.47           N  
ATOM   1936  NH2 ARG C  82      33.584  22.628  34.100  1.00 96.47           N  
ATOM   1937  N   LEU C  83      25.876  21.585  33.243  1.00 25.43           N  
ATOM   1938  CA  LEU C  83      25.250  20.319  33.600  1.00 25.43           C  
ATOM   1939  C   LEU C  83      26.177  19.247  33.023  1.00 25.43           C  
ATOM   1940  O   LEU C  83      26.442  19.239  31.814  1.00 25.43           O  
ATOM   1941  CB  LEU C  83      23.852  20.212  32.989  1.00 32.56           C  
ATOM   1942  CG  LEU C  83      22.749  20.990  33.695  1.00 32.56           C  
ATOM   1943  CD1 LEU C  83      21.456  20.743  33.003  1.00 32.56           C  
ATOM   1944  CD2 LEU C  83      22.632  20.551  35.131  1.00 32.56           C  
ATOM   1945  N   LYS C  84      26.661  18.342  33.873  1.00 16.21           N  
ATOM   1946  CA  LYS C  84      27.603  17.325  33.429  1.00 16.21           C  
ATOM   1947  C   LYS C  84      27.148  15.897  33.207  1.00 16.21           C  
ATOM   1948  O   LYS C  84      26.008  15.519  33.477  1.00 16.21           O  
ATOM   1949  CB  LYS C  84      28.813  17.312  34.367  1.00 60.68           C  
ATOM   1950  CG  LYS C  84      29.963  18.167  33.894  1.00 60.68           C  
ATOM   1951  CD  LYS C  84      30.678  17.518  32.713  1.00 60.68           C  
ATOM   1952  CE  LYS C  84      31.880  18.351  32.260  1.00 60.68           C  
ATOM   1953  NZ  LYS C  84      32.670  17.724  31.146  1.00 60.68           N  
ATOM   1954  N   GLN C  85      28.111  15.115  32.724  1.00101.61           N  
ATOM   1955  CA  GLN C  85      27.954  13.709  32.402  1.00101.61           C  
ATOM   1956  C   GLN C  85      26.978  13.579  31.254  1.00101.61           C  
ATOM   1957  O   GLN C  85      27.457  13.412  30.111  1.00101.61           O  
ATOM   1958  CB  GLN C  85      27.446  12.927  33.613  1.00 69.00           C  
ATOM   1959  CG  GLN C  85      28.350  11.767  34.006  1.00 69.00           C  
ATOM   1960  CD  GLN C  85      27.838  11.012  35.217  1.00 69.00           C  
ATOM   1961  OE1 GLN C  85      26.732  10.462  35.202  1.00 69.00           O  
ATOM   1962  NE2 GLN C  85      28.640  10.985  36.278  1.00 69.00           N  
ATOM   1963  N   ARG C  91      24.740  -5.513  39.801  1.00 85.36           N  
ATOM   1964  CA  ARG C  91      26.107  -4.981  40.080  1.00 85.36           C  
ATOM   1965  C   ARG C  91      26.007  -3.689  40.896  1.00 85.36           C  
ATOM   1966  O   ARG C  91      27.004  -3.016  41.170  1.00 85.36           O  
ATOM   1967  CB  ARG C  91      26.850  -4.735  38.755  1.00101.16           C  
ATOM   1968  CG  ARG C  91      26.039  -4.004  37.681  1.00101.16           C  
ATOM   1969  CD  ARG C  91      26.893  -3.747  36.441  1.00101.16           C  
ATOM   1970  NE  ARG C  91      26.178  -3.014  35.400  1.00101.16           N  
ATOM   1971  CZ  ARG C  91      25.248  -3.542  34.612  1.00101.16           C  
ATOM   1972  NH1 ARG C  91      24.916  -4.815  34.742  1.00101.16           N  
ATOM   1973  NH2 ARG C  91      24.650  -2.797  33.695  1.00101.16           N  
ATOM   1974  N   GLU C  92      24.780  -3.368  41.288  1.00101.61           N  
ATOM   1975  CA  GLU C  92      24.477  -2.176  42.065  1.00101.61           C  
ATOM   1976  C   GLU C  92      25.044  -0.901  41.459  1.00101.61           C  
ATOM   1977  O   GLU C  92      25.003   0.157  42.082  1.00101.61           O  
ATOM   1978  CB  GLU C  92      24.949  -2.339  43.511  1.00100.79           C  
ATOM   1979  CG  GLU C  92      23.830  -2.139  44.543  1.00100.79           C  
ATOM   1980  CD  GLU C  92      22.627  -3.046  44.305  1.00100.79           C  
ATOM   1981  OE1 GLU C  92      22.776  -4.286  44.358  1.00100.79           O  
ATOM   1982  OE2 GLU C  92      21.525  -2.515  44.062  1.00100.79           O  
ATOM   1983  N   GLY C  93      25.584  -1.004  40.250  1.00 95.53           N  
ATOM   1984  CA  GLY C  93      26.083   0.184  39.589  1.00 95.53           C  
ATOM   1985  C   GLY C  93      27.535   0.397  39.219  1.00 95.53           C  
ATOM   1986  O   GLY C  93      28.469  -0.018  39.899  1.00 95.53           O  
ATOM   1987  N   GLU C  94      27.678   1.082  38.093  1.00 87.04           N  
ATOM   1988  CA  GLU C  94      28.945   1.495  37.505  1.00 87.04           C  
ATOM   1989  C   GLU C  94      28.543   2.913  37.132  1.00 87.04           C  
ATOM   1990  O   GLU C  94      29.113   3.898  37.593  1.00 87.04           O  
ATOM   1991  CB  GLU C  94      29.241   0.716  36.223  1.00101.61           C  
ATOM   1992  CG  GLU C  94      29.057  -0.787  36.319  1.00101.61           C  
ATOM   1993  CD  GLU C  94      29.434  -1.493  35.028  1.00101.61           C  
ATOM   1994  OE1 GLU C  94      30.582  -1.312  34.570  1.00101.61           O  
ATOM   1995  OE2 GLU C  94      28.590  -2.228  34.471  1.00101.61           O  
ATOM   1996  N   LYS C  95      27.517   2.965  36.290  1.00 98.58           N  
ATOM   1997  CA  LYS C  95      26.884   4.183  35.792  1.00 98.58           C  
ATOM   1998  C   LYS C  95      27.647   5.473  35.514  1.00 98.58           C  
ATOM   1999  O   LYS C  95      28.830   5.639  35.815  1.00 98.58           O  
ATOM   2000  CB  LYS C  95      25.696   4.541  36.692  1.00 87.02           C  
ATOM   2001  CG  LYS C  95      24.340   4.013  36.238  1.00 87.02           C  
ATOM   2002  CD  LYS C  95      23.289   4.499  37.210  1.00 87.02           C  
ATOM   2003  CE  LYS C  95      21.917   3.988  36.875  1.00 87.02           C  
ATOM   2004  NZ  LYS C  95      20.960   4.376  37.948  1.00 87.02           N  
ATOM   2005  N   ARG C  96      26.878   6.383  34.925  1.00101.61           N  
ATOM   2006  CA  ARG C  96      27.267   7.722  34.522  1.00101.61           C  
ATOM   2007  C   ARG C  96      25.985   8.238  33.852  1.00101.61           C  
ATOM   2008  O   ARG C  96      26.024   8.941  32.843  1.00101.61           O  
ATOM   2009  CB  ARG C  96      28.425   7.670  33.523  1.00 57.07           C  
ATOM   2010  N   THR C  97      24.846   7.851  34.429  1.00 99.06           N  
ATOM   2011  CA  THR C  97      23.527   8.228  33.929  1.00 99.06           C  
ATOM   2012  C   THR C  97      22.852   9.203  34.877  1.00 99.06           C  
ATOM   2013  O   THR C  97      21.633   9.173  35.054  1.00 99.06           O  
ATOM   2014  CB  THR C  97      22.603   7.004  33.787  1.00101.61           C  
ATOM   2015  OG1 THR C  97      22.302   6.476  35.086  1.00101.61           O  
ATOM   2016  CG2 THR C  97      23.271   5.927  32.944  1.00101.61           C  
ATOM   2017  N   VAL C  98      23.650  10.051  35.508  1.00 40.92           N  
ATOM   2018  CA  VAL C  98      23.100  11.041  36.407  1.00 40.92           C  
ATOM   2019  C   VAL C  98      23.478  12.441  35.960  1.00 40.92           C  
ATOM   2020  O   VAL C  98      24.397  12.634  35.158  1.00 40.92           O  
ATOM   2021  CB  VAL C  98      23.580  10.839  37.845  1.00 43.04           C  
ATOM   2022  CG1 VAL C  98      22.883   9.643  38.447  1.00 43.04           C  
ATOM   2023  CG2 VAL C  98      25.081  10.656  37.878  1.00 43.04           C  
ATOM   2024  N   ILE C  99      22.747  13.419  36.469  1.00 44.22           N  
ATOM   2025  CA  ILE C  99      23.015  14.798  36.137  1.00 44.22           C  
ATOM   2026  C   ILE C  99      23.545  15.557  37.354  1.00 44.22           C  
ATOM   2027  O   ILE C  99      22.888  15.655  38.401  1.00 44.22           O  
ATOM   2028  CB  ILE C  99      21.755  15.443  35.568  1.00 46.98           C  
ATOM   2029  CG1 ILE C  99      21.576  14.944  34.139  1.00 46.98           C  
ATOM   2030  CG2 ILE C  99      21.847  16.961  35.613  1.00 46.98           C  
ATOM   2031  CD1 ILE C  99      20.275  15.342  33.532  1.00 46.98           C  
ATOM   2032  N   GLU C 100      24.768  16.063  37.210  1.00 41.03           N  
ATOM   2033  CA  GLU C 100      25.421  16.814  38.271  1.00 41.03           C  
ATOM   2034  C   GLU C 100      25.787  18.199  37.731  1.00 41.03           C  
ATOM   2035  O   GLU C 100      25.589  18.483  36.549  1.00 41.03           O  
ATOM   2036  CB  GLU C 100      26.670  16.062  38.732  1.00100.28           C  
ATOM   2037  CG  GLU C 100      26.456  14.554  38.860  1.00100.28           C  
ATOM   2038  CD  GLU C 100      27.604  13.850  39.564  1.00100.28           C  
ATOM   2039  OE1 GLU C 100      28.769  14.086  39.185  1.00100.28           O  
ATOM   2040  OE2 GLU C 100      27.341  13.054  40.493  1.00100.28           O  
ATOM   2041  N   VAL C 101      26.318  19.054  38.596  1.00 47.25           N  
ATOM   2042  CA  VAL C 101      26.689  20.402  38.209  1.00 47.25           C  
ATOM   2043  C   VAL C 101      28.170  20.603  38.386  1.00 47.25           C  
ATOM   2044  O   VAL C 101      28.687  20.441  39.482  1.00 47.25           O  
ATOM   2045  CB  VAL C 101      25.962  21.446  39.076  1.00 13.54           C  
ATOM   2046  CG1 VAL C 101      26.345  22.841  38.646  1.00 13.54           C  
ATOM   2047  CG2 VAL C 101      24.457  21.253  38.965  1.00 13.54           C  
ATOM   2048  N   GLU C 102      28.846  20.957  37.303  1.00 45.45           N  
ATOM   2049  CA  GLU C 102      30.282  21.204  37.339  1.00 45.45           C  
ATOM   2050  C   GLU C 102      30.492  22.658  37.775  1.00 45.45           C  
ATOM   2051  O   GLU C 102      30.842  23.508  36.955  1.00 45.45           O  
ATOM   2052  CB  GLU C 102      30.890  20.984  35.950  1.00 88.54           C  
ATOM   2053  CG  GLU C 102      32.411  20.884  35.920  1.00 88.54           C  
ATOM   2054  CD  GLU C 102      32.936  19.589  36.526  1.00 88.54           C  
ATOM   2055  OE1 GLU C 102      32.500  18.495  36.101  1.00 88.54           O  
ATOM   2056  OE2 GLU C 102      33.795  19.665  37.425  1.00 88.54           O  
ATOM   2057  N   VAL C 103      30.285  22.918  39.069  1.00 20.33           N  
ATOM   2058  CA  VAL C 103      30.396  24.248  39.671  1.00 20.33           C  
ATOM   2059  C   VAL C 103      31.571  25.122  39.255  1.00 20.33           C  
ATOM   2060  O   VAL C 103      32.722  24.747  39.477  1.00 20.33           O  
ATOM   2061  CB  VAL C 103      30.465  24.151  41.189  1.00 25.78           C  
ATOM   2062  CG1 VAL C 103      30.366  25.533  41.797  1.00 25.78           C  
ATOM   2063  CG2 VAL C 103      29.378  23.265  41.690  1.00 25.78           C  
ATOM   2064  N   ASP C 104      31.288  26.297  38.689  1.00 61.95           N  
ATOM   2065  CA  ASP C 104      32.338  27.238  38.280  1.00 61.95           C  
ATOM   2066  C   ASP C 104      32.561  28.235  39.406  1.00 61.95           C  
ATOM   2067  O   ASP C 104      33.670  28.373  39.932  1.00 61.95           O  
ATOM   2068  CB  ASP C 104      31.920  28.012  37.033  1.00101.61           C  
ATOM   2069  CG  ASP C 104      31.875  27.150  35.806  1.00101.61           C  
ATOM   2070  OD1 ASP C 104      31.393  27.631  34.761  1.00101.61           O  
ATOM   2071  OD2 ASP C 104      32.325  25.991  35.888  1.00101.61           O  
ATOM   2072  N   GLU C 105      31.482  28.932  39.749  1.00 36.88           N  
ATOM   2073  CA  GLU C 105      31.495  29.926  40.798  1.00 36.88           C  
ATOM   2074  C   GLU C 105      30.536  29.481  41.880  1.00 36.88           C  
ATOM   2075  O   GLU C 105      29.447  28.998  41.601  1.00 36.88           O  
ATOM   2076  CB  GLU C 105      31.054  31.279  40.254  1.00 25.51           C  
ATOM   2077  CG  GLU C 105      31.895  31.858  39.129  1.00 25.51           C  
ATOM   2078  CD  GLU C 105      33.302  32.195  39.553  1.00 25.51           C  
ATOM   2079  OE1 GLU C 105      33.468  32.710  40.680  1.00 25.51           O  
ATOM   2080  OE2 GLU C 105      34.237  31.959  38.755  1.00 25.51           O  
ATOM   2081  N   ILE C 106      30.957  29.642  43.121  1.00 56.66           N  
ATOM   2082  CA  ILE C 106      30.142  29.268  44.260  1.00 56.66           C  
ATOM   2083  C   ILE C 106      30.352  30.385  45.276  1.00 56.66           C  
ATOM   2084  O   ILE C 106      31.339  31.125  45.195  1.00 56.66           O  
ATOM   2085  CB  ILE C 106      30.607  27.909  44.854  1.00 38.03           C  
ATOM   2086  CG1 ILE C 106      29.612  27.408  45.901  1.00 38.03           C  
ATOM   2087  CG2 ILE C 106      31.986  28.054  45.485  1.00 38.03           C  
ATOM   2088  CD1 ILE C 106      28.349  26.876  45.323  1.00 38.03           C  
ATOM   2089  N   GLY C 107      29.419  30.517  46.213  1.00 35.66           N  
ATOM   2090  CA  GLY C 107      29.529  31.542  47.229  1.00 35.66           C  
ATOM   2091  C   GLY C 107      28.301  31.534  48.115  1.00 35.66           C  
ATOM   2092  O   GLY C 107      27.197  31.252  47.635  1.00 35.66           O  
ATOM   2093  N   PRO C 108      28.459  31.849  49.416  1.00 49.39           N  
ATOM   2094  CA  PRO C 108      27.387  31.891  50.414  1.00 49.39           C  
ATOM   2095  C   PRO C 108      26.362  32.942  50.019  1.00 49.39           C  
ATOM   2096  O   PRO C 108      26.727  34.057  49.654  1.00 49.39           O  
ATOM   2097  CB  PRO C 108      28.121  32.288  51.703  1.00 42.02           C  
ATOM   2098  CG  PRO C 108      29.554  31.959  51.440  1.00 42.02           C  
ATOM   2099  CD  PRO C 108      29.716  32.339  50.003  1.00 42.02           C  
ATOM   2100  N   SER C 109      25.084  32.607  50.108  1.00 75.43           N  
ATOM   2101  CA  SER C 109      24.045  33.562  49.740  1.00 75.43           C  
ATOM   2102  C   SER C 109      23.786  34.626  50.794  1.00 75.43           C  
ATOM   2103  O   SER C 109      23.113  34.375  51.801  1.00 75.43           O  
ATOM   2104  CB  SER C 109      22.745  32.834  49.442  1.00 50.62           C  
ATOM   2105  OG  SER C 109      21.726  33.761  49.118  1.00 50.62           O  
ATOM   2106  N   LEU C 110      24.313  35.821  50.536  1.00 58.80           N  
ATOM   2107  CA  LEU C 110      24.174  36.959  51.431  1.00 58.80           C  
ATOM   2108  C   LEU C 110      22.727  37.347  51.654  1.00 58.80           C  
ATOM   2109  O   LEU C 110      22.449  38.342  52.308  1.00 58.80           O  
ATOM   2110  CB  LEU C 110      24.940  38.157  50.874  1.00 33.47           C  
ATOM   2111  CG  LEU C 110      26.464  38.038  50.929  1.00 33.47           C  
ATOM   2112  CD1 LEU C 110      27.119  39.227  50.237  1.00 33.47           C  
ATOM   2113  CD2 LEU C 110      26.898  37.945  52.389  1.00 33.47           C  
ATOM   2114  N   ARG C 111      21.803  36.568  51.108  1.00 57.03           N  
ATOM   2115  CA  ARG C 111      20.392  36.863  51.289  1.00 57.03           C  
ATOM   2116  C   ARG C 111      20.014  36.756  52.762  1.00 57.03           C  
ATOM   2117  O   ARG C 111      19.773  37.763  53.415  1.00 57.03           O  
ATOM   2118  CB  ARG C 111      19.538  35.899  50.466  1.00 71.20           C  
ATOM   2119  CG  ARG C 111      18.067  35.846  50.881  1.00 71.20           C  
ATOM   2120  CD  ARG C 111      17.152  36.705  50.022  1.00 71.20           C  
ATOM   2121  NE  ARG C 111      16.582  35.952  48.908  1.00 71.20           N  
ATOM   2122  CZ  ARG C 111      15.450  36.270  48.291  1.00 71.20           C  
ATOM   2123  NH1 ARG C 111      14.762  37.329  48.683  1.00 71.20           N  
ATOM   2124  NH2 ARG C 111      15.003  35.525  47.288  1.00 71.20           N  
ATOM   2125  N   TYR C 112      19.979  35.532  53.280  1.00101.61           N  
ATOM   2126  CA  TYR C 112      19.609  35.282  54.674  1.00101.61           C  
ATOM   2127  C   TYR C 112      20.806  35.090  55.619  1.00101.61           C  
ATOM   2128  O   TYR C 112      20.717  34.350  56.603  1.00101.61           O  
ATOM   2129  CB  TYR C 112      18.705  34.040  54.736  1.00 54.05           C  
ATOM   2130  CG  TYR C 112      17.353  34.203  54.072  1.00 54.05           C  
ATOM   2131  CD1 TYR C 112      16.560  33.092  53.776  1.00 54.05           C  
ATOM   2132  CD2 TYR C 112      16.843  35.466  53.785  1.00 54.05           C  
ATOM   2133  CE1 TYR C 112      15.289  33.238  53.199  1.00 54.05           C  
ATOM   2134  CE2 TYR C 112      15.575  35.627  53.207  1.00 54.05           C  
ATOM   2135  CZ  TYR C 112      14.797  34.512  52.925  1.00 54.05           C  
ATOM   2136  OH  TYR C 112      13.534  34.683  52.384  1.00 54.05           O  
ATOM   2137  N   ALA C 113      21.917  35.768  55.337  1.00 64.57           N  
ATOM   2138  CA  ALA C 113      23.106  35.625  56.172  1.00 64.57           C  
ATOM   2139  C   ALA C 113      24.190  36.653  55.896  1.00 64.57           C  
ATOM   2140  O   ALA C 113      24.205  37.300  54.851  1.00 64.57           O  
ATOM   2141  CB  ALA C 113      23.685  34.230  55.995  1.00 55.81           C  
ATOM   2142  N   THR C 114      25.101  36.789  56.852  1.00100.40           N  
ATOM   2143  CA  THR C 114      26.220  37.712  56.737  1.00100.40           C  
ATOM   2144  C   THR C 114      27.439  36.897  56.315  1.00100.40           C  
ATOM   2145  O   THR C 114      27.367  35.672  56.245  1.00100.40           O  
ATOM   2146  CB  THR C 114      26.492  38.416  58.082  1.00101.61           C  
ATOM   2147  OG1 THR C 114      26.174  37.525  59.157  1.00101.61           O  
ATOM   2148  CG2 THR C 114      25.646  39.673  58.212  1.00101.61           C  
ATOM   2149  N   ALA C 115      28.554  37.559  56.029  1.00 69.97           N  
ATOM   2150  CA  ALA C 115      29.738  36.828  55.610  1.00 69.97           C  
ATOM   2151  C   ALA C 115      31.041  37.596  55.799  1.00 69.97           C  
ATOM   2152  O   ALA C 115      31.099  38.810  55.611  1.00 69.97           O  
ATOM   2153  CB  ALA C 115      29.589  36.407  54.162  1.00 68.36           C  
ATOM   2154  N   LYS C 116      32.086  36.860  56.172  1.00 71.30           N  
ATOM   2155  CA  LYS C 116      33.419  37.413  56.406  1.00 71.30           C  
ATOM   2156  C   LYS C 116      34.304  36.956  55.255  1.00 71.30           C  
ATOM   2157  O   LYS C 116      34.753  35.821  55.224  1.00 71.30           O  
ATOM   2158  CB  LYS C 116      33.960  36.885  57.745  1.00 99.13           C  
ATOM   2159  CG  LYS C 116      35.449  37.128  58.016  1.00 99.13           C  
ATOM   2160  CD  LYS C 116      35.744  38.509  58.584  1.00 99.13           C  
ATOM   2161  CE  LYS C 116      37.232  38.656  58.853  1.00 99.13           C  
ATOM   2162  NZ  LYS C 116      37.572  39.974  59.437  1.00 99.13           N  
ATOM   2163  N   VAL C 117      34.556  37.851  54.313  1.00 54.06           N  
ATOM   2164  CA  VAL C 117      35.359  37.512  53.147  1.00 54.06           C  
ATOM   2165  C   VAL C 117      36.865  37.707  53.310  1.00 54.06           C  
ATOM   2166  O   VAL C 117      37.310  38.760  53.756  1.00 54.06           O  
ATOM   2167  CB  VAL C 117      34.895  38.333  51.932  1.00 64.83           C  
ATOM   2168  CG1 VAL C 117      35.697  37.952  50.694  1.00 64.83           C  
ATOM   2169  CG2 VAL C 117      33.418  38.098  51.699  1.00 64.83           C  
ATOM   2170  N   ASN C 118      37.638  36.693  52.917  1.00 94.15           N  
ATOM   2171  CA  ASN C 118      39.106  36.721  52.996  1.00 94.15           C  
ATOM   2172  C   ASN C 118      39.590  37.010  54.422  1.00 94.15           C  
ATOM   2173  O   ASN C 118      40.345  37.990  54.620  1.00 94.15           O  
ATOM   2174  CB  ASN C 118      39.681  37.771  52.025  1.00 82.77           C  
ATOM   2175  CG  ASN C 118      40.677  37.177  51.027  1.00 82.77           C  
ATOM   2176  OD1 ASN C 118      41.575  36.421  51.400  1.00 82.77           O  
ATOM   2177  ND2 ASN C 118      40.526  37.535  49.756  1.00 82.77           N  
TER    2178      ASN C 118                                                      
END
MOLECULE T0491.pdb
ATOM      1  CB  MET     1      24.494  26.786  25.043  1.00 74.26      A   
ATOM      2  CG  MET     1      23.701  27.585  26.072  1.00 83.32      A   
ATOM      3  SD  MET     1      24.779  28.804  27.139  1.00101.46      A   
ATOM      4  CE  MET     1      25.295  30.073  25.774  1.00 95.61      A   
ATOM      5  C   MET     1      25.321  25.000  26.603  1.00 28.93      A   
ATOM      6  O   MET     1      24.649  24.022  26.272  1.00 27.36      A   
ATOM      7  N   MET     1      26.470  25.414  24.459  1.00 32.31      A   
ATOM      8  CA  MET     1      25.731  26.058  25.583  1.00 34.03      A   
ATOM      9  N   ASN     2      25.748  25.199  27.844  1.00 27.92      A   
ATOM     10  CA  ASN     2      25.434  24.272  28.928  1.00 26.69      A   
ATOM     11  CB  ASN     2      26.294  23.018  28.793  1.00 24.03      A   
ATOM     12  CG  ASN     2      26.048  22.008  29.900  1.00 24.02      A   
ATOM     13  OD1 ASN     2      25.221  22.214  30.793  1.00 23.82      A   
ATOM     14  ND2 ASN     2      26.771  20.899  29.840  1.00 20.34      A   
ATOM     15  C   ASN     2      25.750  24.978  30.234  1.00 24.38      A   
ATOM     16  O   ASN     2      26.841  24.844  30.755  1.00 24.74      A   
ATOM     17  N   THR     3      24.797  25.741  30.750  1.00 21.49      A   
ATOM     18  CA  THR     3      25.026  26.468  31.987  1.00 24.29      A   
ATOM     19  CB  THR     3      25.575  27.893  31.722  1.00 27.90      A   
ATOM     20  OG1 THR     3      25.660  28.614  32.964  1.00 31.66      A   
ATOM     21  CG2 THR     3      24.655  28.654  30.771  1.00 28.43      A   
ATOM     22  C   THR     3      23.798  26.589  32.865  1.00 23.19      A   
ATOM     23  O   THR     3      22.763  27.126  32.470  1.00 25.48      A   
ATOM     24  N   LEU     4      23.934  26.069  34.073  1.00 23.57      A   
ATOM     25  CA  LEU     4      22.876  26.123  35.060  1.00 22.87      A   
ATOM     26  CB  LEU     4      22.698  24.767  35.738  1.00 24.04      A   
ATOM     27  CG  LEU     4      21.742  24.754  36.940  1.00 23.22      A   
ATOM     28  CD1 LEU     4      20.290  24.831  36.473  1.00 21.74      A   
ATOM     29  CD2 LEU     4      21.934  23.474  37.721  1.00 22.90      A   
ATOM     30  C   LEU     4      23.257  27.132  36.127  1.00 25.19      A   
ATOM     31  O   LEU     4      24.405  27.148  36.591  1.00 26.88      A   
ATOM     32  N   GLU     5      22.305  27.977  36.505  1.00 23.62      A   
ATOM     33  CA  GLU     5      22.514  28.944  37.578  1.00 25.83      A   
ATOM     34  CB  GLU     5      22.287  30.373  37.090  1.00 40.19      A   
ATOM     35  CG  GLU     5      23.504  30.937  36.383  1.00 46.33      A   
ATOM     36  CD  GLU     5      23.285  32.346  35.896  1.00 49.75      A   
ATOM     37  OE1 GLU     5      22.490  33.076  36.533  1.00 51.69      A   
ATOM     38  OE2 GLU     5      23.920  32.725  34.888  1.00 51.36      A   
ATOM     39  C   GLU     5      21.471  28.546  38.603  1.00 23.17      A   
ATOM     40  O   GLU     5      20.295  28.409  38.282  1.00 24.66      A   
ATOM     41  N   LEU     6      21.903  28.348  39.839  1.00 25.06      A   
ATOM     42  CA  LEU     6      20.999  27.892  40.873  1.00 23.09      A   
ATOM     43  CB  LEU     6      21.109  26.372  40.969  1.00 24.01      A   
ATOM     44  CG  LEU     6      20.122  25.610  41.845  1.00 25.36      A   
ATOM     45  CD1 LEU     6      18.801  25.483  41.105  1.00 22.71      A   
ATOM     46  CD2 LEU     6      20.682  24.216  42.139  1.00 28.71      A   
ATOM     47  C   LEU     6      21.297  28.479  42.240  1.00 24.57      A   
ATOM     48  O   LEU     6      22.462  28.697  42.585  1.00 23.80      A   
ATOM     49  N   SER     7      20.243  28.719  43.017  1.00 23.82      A   
ATOM     50  CA  SER     7      20.406  29.213  44.377  1.00 26.53      A   
ATOM     51  CB  SER     7      19.457  30.382  44.667  1.00 28.18      A   
ATOM     52  OG  SER     7      18.107  29.985  44.524  1.00 32.55      A   
ATOM     53  C   SER     7      20.038  28.003  45.233  1.00 26.53      A   
ATOM     54  O   SER     7      19.038  27.338  44.976  1.00 27.01      A   
ATOM     55  N   ALA     8      20.830  27.715  46.255  1.00 26.33      A   
ATOM     56  CA  ALA     8      20.552  26.541  47.062  1.00 26.48      A   
ATOM     57  CB  ALA     8      21.060  25.300  46.331  1.00 24.59      A   
ATOM     58  C   ALA     8      21.137  26.577  48.456  1.00 28.39      A   
ATOM     59  O   ALA     8      21.896  27.480  48.816  1.00 28.01      A   
ATOM     60  N   ARG     9      20.764  25.563  49.227  1.00 24.68      A   
ATOM     61  CA  ARG     9      21.223  25.391  50.591  1.00 27.29      A   
ATOM     62  CB  ARG     9      20.004  25.199  51.497  1.00 59.09      A   
ATOM     63  CG  ARG     9      20.307  24.858  52.937  1.00 65.71      A   
ATOM     64  CD  ARG     9      19.394  23.737  53.436  1.00 70.65      A   
ATOM     65  NE  ARG     9      18.032  23.854  52.913  1.00 73.40      A   
ATOM     66  CZ  ARG     9      17.078  22.946  53.109  1.00 74.78      A   
ATOM     67  NH1 ARG     9      17.329  21.852  53.819  1.00 74.28      A   
ATOM     68  NH2 ARG     9      15.874  23.121  52.578  1.00 75.97      A   
ATOM     69  C   ARG     9      22.088  24.130  50.595  1.00 25.32      A   
ATOM     70  O   ARG     9      21.748  23.150  49.930  1.00 23.53      A   
ATOM     71  N   VAL    10      23.209  24.157  51.314  1.00 26.68      A   
ATOM     72  CA  VAL    10      24.075  22.985  51.396  1.00 26.58      A   
ATOM     73  CB  VAL    10      25.467  23.332  51.942  1.00 27.91      A   
ATOM     74  CG1 VAL    10      26.304  22.056  52.069  1.00 29.79      A   
ATOM     75  CG2 VAL    10      26.158  24.320  51.008  1.00 26.57      A   
ATOM     76  C   VAL    10      23.454  21.954  52.320  1.00 27.37      A   
ATOM     77  O   VAL    10      23.337  22.172  53.528  1.00 30.15      A   
ATOM     78  N   LEU    11      23.064  20.825  51.749  1.00 27.52      A   
ATOM     79  CA  LEU    11      22.444  19.759  52.517  1.00 27.26      A   
ATOM     80  CB  LEU    11      21.413  19.040  51.651  1.00 27.95      A   
ATOM     81  CG  LEU    11      20.469  18.035  52.310  1.00 31.34      A   
ATOM     82  CD1 LEU    11      19.627  18.705  53.403  1.00 31.87      A   
ATOM     83  CD2 LEU    11      19.572  17.470  51.226  1.00 29.70      A   
ATOM     84  C   LEU    11      23.475  18.765  53.031  1.00 26.39      A   
ATOM     85  O   LEU    11      23.264  18.113  54.036  1.00 26.52      A   
ATOM     86  N   GLU    12      24.581  18.636  52.311  1.00 26.78      A   
ATOM     87  CA  GLU    12      25.654  17.731  52.694  1.00 26.21      A   
ATOM     88  CB  GLU    12      25.364  16.296  52.219  1.00 37.59      A   
ATOM     89  CG  GLU    12      26.547  15.339  52.386  1.00 41.96      A   
ATOM     90  CD  GLU    12      26.179  13.871  52.173  1.00 46.60      A   
ATOM     91  OE1 GLU    12      25.409  13.570  51.235  1.00 47.54      A   
ATOM     92  OE2 GLU    12      26.678  13.012  52.938  1.00 48.21      A   
ATOM     93  C   GLU    12      26.919  18.255  52.041  1.00 24.78      A   
ATOM     94  O   GLU    12      26.881  18.759  50.910  1.00 21.33      A   
ATOM     95  N   CYS    13      28.031  18.172  52.760  1.00 24.07      A   
ATOM     96  CA  CYS    13      29.304  18.648  52.237  1.00 25.07      A   
ATOM     97  CB  CYS    13      29.699  19.967  52.912  1.00 27.16      A   
ATOM     98  SG  CYS    13      31.211  20.744  52.267  1.00 28.15      A   
ATOM     99  C   CYS    13      30.338  17.584  52.520  1.00 27.03      A   
ATOM    100  O   CYS    13      30.720  17.369  53.671  1.00 29.10      A   
ATOM    101  N   GLY    14      30.788  16.910  51.467  1.00 31.16      A   
ATOM    102  CA  GLY    14      31.763  15.850  51.634  1.00 32.73      A   
ATOM    103  C   GLY    14      33.106  16.283  52.187  1.00 33.43      A   
ATOM    104  O   GLY    14      33.356  17.472  52.401  1.00 32.99      A   
ATOM    105  N   ALA    15      33.968  15.307  52.450  1.00 30.50      A   
ATOM    106  CA  ALA    15      35.301  15.600  52.948  1.00 31.73      A   
ATOM    107  CB  ALA    15      35.849  14.383  53.713  1.00 43.10      A   
ATOM    108  C   ALA    15      36.195  15.931  51.743  1.00 31.06      A   
ATOM    109  O   ALA    15      35.925  15.500  50.621  1.00 30.10      A   
ATOM    110  N   MET    16      37.248  16.706  51.974  1.00 33.75      A   
ATOM    111  CA  MET    16      38.175  17.079  50.909  1.00 34.44      A   
ATOM    112  CB  MET    16      39.190  18.088  51.437  1.00 36.40      A   
ATOM    113  CG  MET    16      40.158  18.580  50.380  1.00 42.50      A   
ATOM    114  SD  MET    16      39.215  19.523  48.978  1.00 51.77      A   
ATOM    115  CE  MET    16      39.181  21.260  49.790  1.00 42.94      A   
ATOM    116  C   MET    16      38.932  15.864  50.372  1.00 34.78      A   
ATOM    117  O   MET    16      39.434  15.055  51.147  1.00 35.45      A   
ATOM    118  N   ARG    17      39.010  15.730  49.050  1.00 31.64      A   
ATOM    119  CA  ARG    17      39.746  14.626  48.430  1.00 32.60      A   
ATOM    120  CB  ARG    17      38.805  13.684  47.663  1.00 45.02      A   
ATOM    121  CG  ARG    17      37.628  13.162  48.453  1.00 51.95      A   
ATOM    122  CD  ARG    17      36.742  12.282  47.579  1.00 58.07      A   
ATOM    123  NE  ARG    17      36.175  12.984  46.421  1.00 62.07      A   
ATOM    124  CZ  ARG    17      35.360  14.037  46.491  1.00 63.33      A   
ATOM    125  NH1 ARG    17      34.996  14.533  47.668  1.00 65.34      A   
ATOM    126  NH2 ARG    17      34.912  14.609  45.380  1.00 63.27      A   
ATOM    127  C   ARG    17      40.705  15.276  47.437  1.00 31.59      A   
ATOM    128  O   ARG    17      40.657  16.490  47.235  1.00 29.81      A   
ATOM    129  N   HIS    18      41.579  14.483  46.829  1.00 31.03      A   
ATOM    130  CA  HIS    18      42.501  15.013  45.835  1.00 30.31      A   
ATOM    131  CB  HIS    18      43.885  15.278  46.431  1.00 30.18      A   
ATOM    132  CG  HIS    18      43.891  16.339  47.478  1.00 27.06      A   
ATOM    133  CD2 HIS    18      44.146  17.666  47.400  1.00 25.93      A   
ATOM    134  ND1 HIS    18      43.549  16.089  48.787  1.00 26.80      A   
ATOM    135  CE1 HIS    18      43.592  17.217  49.473  1.00 27.01      A   
ATOM    136  NE2 HIS    18      43.951  18.189  48.654  1.00 26.49      A   
ATOM    137  C   HIS    18      42.649  14.033  44.700  1.00 30.86      A   
ATOM    138  O   HIS    18      42.610  12.822  44.903  1.00 29.79      A   
ATOM    139  N   THR    19      42.797  14.569  43.498  1.00 31.93      A   
ATOM    140  CA  THR    19      42.999  13.738  42.333  1.00 32.14      A   
ATOM    141  CB  THR    19      42.770  14.536  41.041  1.00 33.79      A   
ATOM    142  OG1 THR    19      43.730  15.601  40.957  1.00 33.43      A   
ATOM    143  CG2 THR    19      41.351  15.112  41.018  1.00 30.25      A   
ATOM    144  C   THR    19      44.467  13.305  42.404  1.00 32.81      A   
ATOM    145  O   THR    19      45.213  13.776  43.263  1.00 31.81      A   
ATOM    146  N   PRO    20      44.894  12.387  41.518  1.00 35.99      A   
ATOM    147  CD  PRO    20      44.089  11.552  40.605  1.00 38.03      A   
ATOM    148  CA  PRO    20      46.290  11.934  41.533  1.00 34.64      A   
ATOM    149  CB  PRO    20      46.335  10.915  40.400  1.00 36.73      A   
ATOM    150  CG  PRO    20      44.959  10.318  40.452  1.00 40.37      A   
ATOM    151  C   PRO    20      47.268  13.077  41.308  1.00 33.24      A   
ATOM    152  O   PRO    20      48.397  13.034  41.795  1.00 33.18      A   
ATOM    153  N   ALA    21      46.838  14.088  40.556  1.00 28.39      A   
ATOM    154  CA  ALA    21      47.687  15.246  40.285  1.00 26.67      A   
ATOM    155  CB  ALA    21      47.260  15.941  39.000  1.00 30.23      A   
ATOM    156  C   ALA    21      47.613  16.230  41.450  1.00 26.44      A   
ATOM    157  O   ALA    21      48.135  17.344  41.361  1.00 26.22      A   
ATOM    158  N   GLY    22      46.942  15.824  42.528  1.00 28.68      A   
ATOM    159  CA  GLY    22      46.829  16.670  43.709  1.00 26.14      A   
ATOM    160  C   GLY    22      45.780  17.777  43.657  1.00 28.37      A   
ATOM    161  O   GLY    22      45.741  18.655  44.524  1.00 26.71      A   
ATOM    162  N   LEU    23      44.932  17.758  42.640  1.00 25.27      A   
ATOM    163  CA  LEU    23      43.883  18.767  42.538  1.00 27.04      A   
ATOM    164  CB  LEU    23      43.262  18.705  41.144  1.00 36.58      A   
ATOM    165  CG  LEU    23      42.296  19.803  40.693  1.00 40.73      A   
ATOM    166  CD1 LEU    23      42.848  21.197  41.031  1.00 40.54      A   
ATOM    167  CD2 LEU    23      42.086  19.653  39.190  1.00 40.02      A   
ATOM    168  C   LEU    23      42.804  18.542  43.619  1.00 27.04      A   
ATOM    169  O   LEU    23      42.299  17.430  43.788  1.00 26.83      A   
ATOM    170  N   PRO    24      42.457  19.588  44.392  1.00 26.02      A   
ATOM    171  CD  PRO    24      43.071  20.917  44.540  1.00 33.80      A   
ATOM    172  CA  PRO    24      41.424  19.366  45.414  1.00 25.32      A   
ATOM    173  CB  PRO    24      41.406  20.682  46.200  1.00 34.41      A   
ATOM    174  CG  PRO    24      41.988  21.680  45.246  1.00 35.64      A   
ATOM    175  C   PRO    24      40.082  19.031  44.770  1.00 23.75      A   
ATOM    176  O   PRO    24      39.735  19.570  43.725  1.00 22.81      A   
ATOM    177  N   ALA    25      39.337  18.125  45.388  1.00 23.67      A   
ATOM    178  CA  ALA    25      38.056  17.700  44.842  1.00 25.97      A   
ATOM    179  CB  ALA    25      38.209  16.362  44.128  1.00 30.92      A   
ATOM    180  C   ALA    25      37.048  17.578  45.962  1.00 25.13      A   
ATOM    181  O   ALA    25      37.319  16.978  46.994  1.00 25.71      A   
ATOM    182  N   LEU    26      35.865  18.135  45.742  1.00 25.68      A   
ATOM    183  CA  LEU    26      34.833  18.115  46.765  1.00 25.29      A   
ATOM    184  CB  LEU    26      34.834  19.465  47.486  1.00 25.63      A   
ATOM    185  CG  LEU    26      33.739  19.749  48.513  1.00 27.37      A   
ATOM    186  CD1 LEU    26      33.997  18.903  49.772  1.00 29.57      A   
ATOM    187  CD2 LEU    26      33.745  21.244  48.858  1.00 28.02      A   
ATOM    188  C   LEU    26      33.448  17.825  46.194  1.00 26.42      A   
ATOM    189  O   LEU    26      33.075  18.346  45.143  1.00 27.62      A   
ATOM    190  N   GLU    27      32.690  16.992  46.898  1.00 23.95      A   
ATOM    191  CA  GLU    27      31.341  16.630  46.477  1.00 27.32      A   
ATOM    192  CB  GLU    27      31.216  15.094  46.439  1.00 50.38      A   
ATOM    193  CG  GLU    27      29.804  14.530  46.600  1.00 58.68      A   
ATOM    194  CD  GLU    27      29.034  14.409  45.289  1.00 62.89      A   
ATOM    195  OE1 GLU    27      29.407  13.553  44.457  1.00 66.03      A   
ATOM    196  OE2 GLU    27      28.057  15.162  45.092  1.00 66.47      A   
ATOM    197  C   GLU    27      30.350  17.226  47.477  1.00 26.08      A   
ATOM    198  O   GLU    27      30.550  17.128  48.687  1.00 24.71      A   
ATOM    199  N   LEU    28      29.303  17.876  46.979  1.00 26.78      A   
ATOM    200  CA  LEU    28      28.299  18.445  47.872  1.00 26.53      A   
ATOM    201  CB  LEU    28      28.413  19.975  47.964  1.00 27.40      A   
ATOM    202  CG  LEU    28      29.738  20.650  48.326  1.00 27.58      A   
ATOM    203  CD1 LEU    28      30.465  21.049  47.038  1.00 28.75      A   
ATOM    204  CD2 LEU    28      29.463  21.884  49.182  1.00 27.49      A   
ATOM    205  C   LEU    28      26.905  18.094  47.382  1.00 24.94      A   
ATOM    206  O   LEU    28      26.715  17.720  46.225  1.00 26.86      A   
ATOM    207  N   LEU    29      25.939  18.208  48.283  1.00 23.67      A   
ATOM    208  CA  LEU    29      24.546  17.948  47.961  1.00 25.26      A   
ATOM    209  CB  LEU    29      23.980  16.847  48.859  1.00 32.81      A   
ATOM    210  CG  LEU    29      22.619  16.271  48.455  1.00 36.98      A   
ATOM    211  CD1 LEU    29      22.643  15.862  46.983  1.00 39.93      A   
ATOM    212  CD2 LEU    29      22.291  15.061  49.329  1.00 38.53      A   
ATOM    213  C   LEU    29      23.811  19.261  48.211  1.00 25.49      A   
ATOM    214  O   LEU    29      23.820  19.794  49.326  1.00 25.02      A   
ATOM    215  N   LEU    30      23.173  19.782  47.171  1.00 25.15      A   
ATOM    216  CA  LEU    30      22.457  21.048  47.272  1.00 24.89      A   
ATOM    217  CB  LEU    30      22.923  21.976  46.151  1.00 25.89      A   
ATOM    218  CG  LEU    30      24.446  22.117  46.006  1.00 27.08      A   
ATOM    219  CD1 LEU    30      24.786  22.905  44.744  1.00 25.50      A   
ATOM    220  CD2 LEU    30      25.035  22.788  47.246  1.00 25.99      A   
ATOM    221  C   LEU    30      20.951  20.854  47.160  1.00 25.18      A   
ATOM    222  O   LEU    30      20.493  19.983  46.426  1.00 23.82      A   
ATOM    223  N   VAL    31      20.184  21.652  47.898  1.00 23.42      A   
ATOM    224  CA  VAL    31      18.731  21.571  47.822  1.00 23.61      A   
ATOM    225  CB  VAL    31      18.115  21.034  49.138  1.00 30.26      A   
ATOM    226  CG1 VAL    31      18.591  21.859  50.313  1.00 32.68      A   
ATOM    227  CG2 VAL    31      16.583  21.037  49.031  1.00 31.06      A   
ATOM    228  C   VAL    31      18.191  22.959  47.489  1.00 24.03      A   
ATOM    229  O   VAL    31      18.484  23.941  48.167  1.00 21.81      A   
ATOM    230  N   HIS    32      17.430  23.033  46.404  1.00 26.38      A   
ATOM    231  CA  HIS    32      16.854  24.282  45.936  1.00 26.95      A   
ATOM    232  CB  HIS    32      17.186  24.467  44.452  1.00 28.09      A   
ATOM    233  CG  HIS    32      16.364  25.515  43.771  1.00 24.39      A   
ATOM    234  CD2 HIS    32      16.612  26.824  43.529  1.00 25.91      A   
ATOM    235  ND1 HIS    32      15.111  25.262  43.257  1.00 28.36      A   
ATOM    236  CE1 HIS    32      14.620  26.367  42.727  1.00 25.17      A   
ATOM    237  NE2 HIS    32      15.510  27.330  42.878  1.00 29.12      A   
ATOM    238  C   HIS    32      15.345  24.302  46.114  1.00 28.72      A   
ATOM    239  O   HIS    32      14.689  23.281  45.933  1.00 29.57      A   
ATOM    240  N   GLU    33      14.803  25.462  46.478  1.00 30.22      A   
ATOM    241  CA  GLU    33      13.356  25.614  46.631  1.00 31.31      A   
ATOM    242  CB  GLU    33      12.914  25.405  48.084  1.00 56.19      A   
ATOM    243  CG  GLU    33      11.397  25.481  48.265  1.00 62.70      A   
ATOM    244  CD  GLU    33      10.952  25.161  49.681  1.00 67.35      A   
ATOM    245  OE1 GLU    33      11.378  25.863  50.626  1.00 70.69      A   
ATOM    246  OE2 GLU    33      10.169  24.200  49.849  1.00 69.26      A   
ATOM    247  C   GLU    33      12.931  27.003  46.171  1.00 31.37      A   
ATOM    248  O   GLU    33      13.559  28.002  46.512  1.00 29.09      A   
ATOM    249  N   SER    34      11.863  27.060  45.385  1.00 32.63      A   
ATOM    250  CA  SER    34      11.370  28.329  44.878  1.00 32.82      A   
ATOM    251  CB  SER    34      12.356  28.929  43.871  1.00 30.99      A   
ATOM    252  OG  SER    34      12.385  28.179  42.669  1.00 27.65      A   
ATOM    253  C   SER    34      10.050  28.103  44.186  1.00 34.11      A   
ATOM    254  O   SER    34       9.665  26.960  43.931  1.00 34.53      A   
ATOM    255  N   GLU    35       9.363  29.196  43.879  1.00 31.65      A   
ATOM    256  CA  GLU    35       8.087  29.133  43.189  1.00 35.16      A   
ATOM    257  CB  GLU    35       7.055  30.018  43.895  1.00 64.06      A   
ATOM    258  CG  GLU    35       6.638  29.524  45.271  1.00 69.41      A   
ATOM    259  CD  GLU    35       5.649  28.378  45.201  1.00 72.73      A   
ATOM    260  OE1 GLU    35       4.592  28.550  44.555  1.00 75.53      A   
ATOM    261  OE2 GLU    35       5.924  27.311  45.795  1.00 75.35      A   
ATOM    262  C   GLU    35       8.346  29.668  41.791  1.00 34.94      A   
ATOM    263  O   GLU    35       9.034  30.674  41.635  1.00 34.58      A   
ATOM    264  N   VAL    36       7.822  28.988  40.779  1.00 35.89      A   
ATOM    265  CA  VAL    36       7.996  29.433  39.401  1.00 37.61      A   
ATOM    266  CB  VAL    36       8.982  28.532  38.621  1.00 33.61      A   
ATOM    267  CG1 VAL    36      10.338  28.512  39.308  1.00 32.75      A   
ATOM    268  CG2 VAL    36       8.426  27.132  38.502  1.00 34.51      A   
ATOM    269  C   VAL    36       6.659  29.434  38.663  1.00 38.71      A   
ATOM    270  O   VAL    36       5.709  28.755  39.062  1.00 38.69      A   
ATOM    271  N   VAL    37       6.590  30.203  37.587  1.00 39.43      A   
ATOM    272  CA  VAL    37       5.372  30.286  36.795  1.00 40.19      A   
ATOM    273  CB  VAL    37       5.102  31.739  36.378  1.00 49.29      A   
ATOM    274  CG1 VAL    37       6.312  32.290  35.638  1.00 50.63      A   
ATOM    275  CG2 VAL    37       3.848  31.811  35.525  1.00 50.21      A   
ATOM    276  C   VAL    37       5.529  29.414  35.553  1.00 40.89      A   
ATOM    277  O   VAL    37       6.507  29.533  34.818  1.00 38.12      A   
ATOM    278  N   GLU    38       4.566  28.528  35.324  1.00 42.38      A   
ATOM    279  CA  GLU    38       4.634  27.638  34.175  1.00 45.57      A   
ATOM    280  CB  GLU    38       4.986  26.229  34.652  1.00 50.02      A   
ATOM    281  CG  GLU    38       5.164  25.214  33.557  1.00 50.17      A   
ATOM    282  CD  GLU    38       5.800  23.942  34.073  1.00 51.94      A   
ATOM    283  OE1 GLU    38       5.411  23.486  35.169  1.00 52.48      A   
ATOM    284  OE2 GLU    38       6.684  23.393  33.385  1.00 51.85      A   
ATOM    285  C   GLU    38       3.333  27.633  33.383  1.00 46.60      A   
ATOM    286  O   GLU    38       2.289  27.217  33.886  1.00 45.91      A   
ATOM    287  N   ALA    39       3.415  28.095  32.137  1.00 66.00      A   
ATOM    288  CA  ALA    39       2.250  28.172  31.268  1.00 67.47      A   
ATOM    289  CB  ALA    39       1.708  26.771  30.984  1.00 62.56      A   
ATOM    290  C   ALA    39       1.193  29.021  31.959  1.00 67.93      A   
ATOM    291  O   ALA    39      -0.003  28.756  31.846  1.00 68.09      A   
ATOM    292  N   GLY    40       1.648  30.039  32.682  1.00 50.35      A   
ATOM    293  CA  GLY    40       0.732  30.919  33.383  1.00 50.51      A   
ATOM    294  C   GLY    40       0.170  30.337  34.663  1.00 51.76      A   
ATOM    295  O   GLY    40      -0.970  30.631  35.025  1.00 52.84      A   
ATOM    296  N   HIS    41       0.949  29.513  35.360  1.00 51.87      A   
ATOM    297  CA  HIS    41       0.475  28.912  36.607  1.00 52.47      A   
ATOM    298  CB  HIS    41      -0.160  27.541  36.330  1.00 71.49      A   
ATOM    299  CG  HIS    41      -1.320  27.592  35.387  1.00 73.74      A   
ATOM    300  CD2 HIS    41      -1.448  27.161  34.110  1.00 74.29      A   
ATOM    301  ND1 HIS    41      -2.525  28.173  35.719  1.00 74.30      A   
ATOM    302  CE1 HIS    41      -3.346  28.098  34.686  1.00 75.45      A   
ATOM    303  NE2 HIS    41      -2.716  27.488  33.697  1.00 74.43      A   
ATOM    304  C   HIS    41       1.594  28.756  37.639  1.00 52.24      A   
ATOM    305  O   HIS    41       2.702  28.355  37.303  1.00 51.82      A   
ATOM    306  N   PRO    42       1.312  29.073  38.913  1.00 59.44      A   
ATOM    307  CD  PRO    42       0.040  29.603  39.440  1.00 62.08      A   
ATOM    308  CA  PRO    42       2.316  28.955  39.980  1.00 59.00      A   
ATOM    309  CB  PRO    42       1.661  29.686  41.149  1.00 62.01      A   
ATOM    310  CG  PRO    42       0.194  29.389  40.935  1.00 61.96      A   
ATOM    311  C   PRO    42       2.647  27.493  40.304  1.00 58.49      A   
ATOM    312  O   PRO    42       1.778  26.620  40.245  1.00 57.97      A   
ATOM    313  N   ARG    43       3.904  27.232  40.647  1.00 45.42      A   
ATOM    314  CA  ARG    43       4.343  25.872  40.949  1.00 45.16      A   
ATOM    315  CB  ARG    43       4.783  25.181  39.655  1.00 63.38      A   
ATOM    316  CG  ARG    43       5.300  23.757  39.816  1.00 67.94      A   
ATOM    317  CD  ARG    43       5.748  23.220  38.463  1.00 69.41      A   
ATOM    318  NE  ARG    43       6.267  21.856  38.528  1.00 71.62      A   
ATOM    319  CZ  ARG    43       7.413  21.510  39.108  1.00 73.06      A   
ATOM    320  NH1 ARG    43       8.178  22.428  39.686  1.00 74.20      A   
ATOM    321  NH2 ARG    43       7.804  20.241  39.096  1.00 72.22      A   
ATOM    322  C   ARG    43       5.485  25.836  41.961  1.00 43.06      A   
ATOM    323  O   ARG    43       6.401  26.650  41.916  1.00 40.53      A   
ATOM    324  N   ARG    44       5.431  24.877  42.871  1.00 42.86      A   
ATOM    325  CA  ARG    44       6.470  24.750  43.880  1.00 41.76      A   
ATOM    326  CB  ARG    44       5.900  24.056  45.119  1.00 80.16      A   
ATOM    327  CG  ARG    44       4.566  24.626  45.605  1.00 86.18      A   
ATOM    328  CD  ARG    44       3.908  23.753  46.665  1.00 89.94      A   
ATOM    329  NE  ARG    44       4.813  23.455  47.768  1.00 94.16      A   
ATOM    330  CZ  ARG    44       4.432  22.910  48.918  1.00 95.74      A   
ATOM    331  NH1 ARG    44       5.325  22.667  49.869  1.00 97.16      A   
ATOM    332  NH2 ARG    44       3.155  22.624  49.118  1.00 96.57      A   
ATOM    333  C   ARG    44       7.605  23.894  43.314  1.00 39.20      A   
ATOM    334  O   ARG    44       7.365  22.771  42.882  1.00 38.72      A   
ATOM    335  N   VAL    45       8.832  24.409  43.303  1.00 31.89      A   
ATOM    336  CA  VAL    45       9.956  23.617  42.808  1.00 30.53      A   
ATOM    337  CB  VAL    45      10.784  24.353  41.715  1.00 48.89      A   
ATOM    338  CG1 VAL    45      11.869  23.422  41.192  1.00 49.73      A   
ATOM    339  CG2 VAL    45       9.891  24.820  40.581  1.00 51.08      A   
ATOM    340  C   VAL    45      10.910  23.307  43.956  1.00 28.97      A   
ATOM    341  O   VAL    45      11.385  24.212  44.638  1.00 29.10      A   
ATOM    342  N   GLU    46      11.169  22.026  44.181  1.00 35.62      A   
ATOM    343  CA  GLU    46      12.113  21.609  45.212  1.00 35.83      A   
ATOM    344  CB  GLU    46      11.406  20.961  46.396  1.00 50.70      A   
ATOM    345  CG  GLU    46      12.377  20.379  47.412  1.00 56.00      A   
ATOM    346  CD  GLU    46      11.755  20.213  48.790  1.00 59.28      A   
ATOM    347  OE1 GLU    46      10.675  19.590  48.894  1.00 59.61      A   
ATOM    348  OE2 GLU    46      12.350  20.708  49.772  1.00 60.11      A   
ATOM    349  C   GLU    46      13.061  20.610  44.562  1.00 33.49      A   
ATOM    350  O   GLU    46      12.681  19.484  44.254  1.00 33.63      A   
ATOM    351  N   LEU    47      14.301  21.032  44.368  1.00 31.55      A   
ATOM    352  CA  LEU    47      15.299  20.201  43.707  1.00 29.40      A   
ATOM    353  CB  LEU    47      15.774  20.916  42.436  1.00 26.79      A   
ATOM    354  CG  LEU    47      16.912  20.320  41.595  1.00 26.96      A   
ATOM    355  CD1 LEU    47      16.414  19.106  40.818  1.00 29.61      A   
ATOM    356  CD2 LEU    47      17.427  21.372  40.624  1.00 26.03      A   
ATOM    357  C   LEU    47      16.514  19.888  44.567  1.00 27.14      A   
ATOM    358  O   LEU    47      17.041  20.759  45.244  1.00 24.59      A   
ATOM    359  N   THR    48      16.955  18.637  44.536  1.00 27.05      A   
ATOM    360  CA  THR    48      18.148  18.238  45.270  1.00 27.97      A   
ATOM    361  CB  THR    48      17.846  17.132  46.290  1.00 29.86      A   
ATOM    362  OG1 THR    48      16.987  17.668  47.301  1.00 30.72      A   
ATOM    363  CG2 THR    48      19.119  16.634  46.949  1.00 27.80      A   
ATOM    364  C   THR    48      19.072  17.738  44.170  1.00 28.24      A   
ATOM    365  O   THR    48      18.683  16.926  43.312  1.00 27.20      A   
ATOM    366  N   ILE    49      20.293  18.247  44.174  1.00 25.73      A   
ATOM    367  CA  ILE    49      21.238  17.880  43.141  1.00 25.79      A   
ATOM    368  CB  ILE    49      21.192  18.916  42.015  1.00 27.68      A   
ATOM    369  CG2 ILE    49      21.423  20.305  42.588  1.00 25.33      A   
ATOM    370  CG1 ILE    49      22.222  18.580  40.936  1.00 31.67      A   
ATOM    371  CD1 ILE    49      21.795  17.477  40.017  1.00 35.55      A   
ATOM    372  C   ILE    49      22.652  17.813  43.685  1.00 25.13      A   
ATOM    373  O   ILE    49      23.056  18.645  44.502  1.00 22.88      A   
ATOM    374  N   SER    50      23.406  16.824  43.226  1.00 25.95      A   
ATOM    375  CA  SER    50      24.784  16.693  43.671  1.00 27.21      A   
ATOM    376  CB  SER    50      25.263  15.247  43.538  1.00 39.72      A   
ATOM    377  OG  SER    50      25.384  14.891  42.179  1.00 49.33      A   
ATOM    378  C   SER    50      25.674  17.616  42.843  1.00 26.32      A   
ATOM    379  O   SER    50      25.502  17.746  41.627  1.00 26.27      A   
ATOM    380  N   ALA    51      26.625  18.259  43.510  1.00 23.67      A   
ATOM    381  CA  ALA    51      27.524  19.173  42.837  1.00 24.76      A   
ATOM    382  CB  ALA    51      27.260  20.593  43.298  1.00 24.09      A   
ATOM    383  C   ALA    51      28.948  18.792  43.150  1.00 26.32      A   
ATOM    384  O   ALA    51      29.249  18.353  44.266  1.00 24.18      A   
ATOM    385  N   VAL    52      29.816  18.962  42.159  1.00 25.72      A   
ATOM    386  CA  VAL    52      31.227  18.656  42.319  1.00 26.52      A   
ATOM    387  CB  VAL    52      31.681  17.537  41.336  1.00 38.51      A   
ATOM    388  CG1 VAL    52      33.196  17.407  41.350  1.00 40.69      A   
ATOM    389  CG2 VAL    52      31.058  16.202  41.742  1.00 39.67      A   
ATOM    390  C   VAL    52      32.049  19.916  42.069  1.00 26.65      A   
ATOM    391  O   VAL    52      31.793  20.675  41.125  1.00 23.27      A   
ATOM    392  N   ALA    53      33.015  20.139  42.951  1.00 24.95      A   
ATOM    393  CA  ALA    53      33.918  21.274  42.862  1.00 25.72      A   
ATOM    394  CB  ALA    53      33.850  22.101  44.144  1.00 32.05      A   
ATOM    395  C   ALA    53      35.301  20.657  42.687  1.00 25.08      A   
ATOM    396  O   ALA    53      35.597  19.614  43.271  1.00 26.05      A   
ATOM    397  N   LEU    54      36.135  21.282  41.870  1.00 29.44      A   
ATOM    398  CA  LEU    54      37.469  20.761  41.597  1.00 31.81      A   
ATOM    399  CB  LEU    54      37.441  19.976  40.275  1.00 36.23      A   
ATOM    400  CG  LEU    54      38.631  19.161  39.744  1.00 42.22      A   
ATOM    401  CD1 LEU    54      39.140  18.197  40.806  1.00 42.20      A   
ATOM    402  CD2 LEU    54      38.185  18.384  38.490  1.00 41.90      A   
ATOM    403  C   LEU    54      38.401  21.958  41.497  1.00 32.80      A   
ATOM    404  O   LEU    54      38.203  22.831  40.653  1.00 34.37      A   
ATOM    405  N   GLY    55      39.405  22.010  42.367  1.00 27.13      A   
ATOM    406  CA  GLY    55      40.327  23.127  42.343  1.00 26.95      A   
ATOM    407  C   GLY    55      40.002  24.211  43.362  1.00 26.29      A   
ATOM    408  O   GLY    55      39.674  23.931  44.518  1.00 24.22      A   
ATOM    409  N   ASP    56      40.072  25.459  42.920  1.00 27.38      A   
ATOM    410  CA  ASP    56      39.824  26.590  43.793  1.00 28.10      A   
ATOM    411  CB  ASP    56      40.083  27.885  43.026  1.00 27.21      A   
ATOM    412  CG  ASP    56      41.571  28.149  42.824  1.00 31.36      A   
ATOM    413  OD1 ASP    56      41.919  29.030  42.010  1.00 30.34      A   
ATOM    414  OD2 ASP    56      42.396  27.478  43.489  1.00 28.38      A   
ATOM    415  C   ASP    56      38.455  26.625  44.475  1.00 26.99      A   
ATOM    416  O   ASP    56      38.355  27.024  45.631  1.00 25.86      A   
ATOM    417  N   LEU    57      37.409  26.201  43.778  1.00 26.03      A   
ATOM    418  CA  LEU    57      36.077  26.203  44.367  1.00 26.48      A   
ATOM    419  CB  LEU    57      35.009  25.940  43.301  1.00 36.39      A   
ATOM    420  CG  LEU    57      34.632  27.127  42.419  1.00 36.95      A   
ATOM    421  CD1 LEU    57      33.485  26.718  41.510  1.00 38.53      A   
ATOM    422  CD2 LEU    57      34.200  28.297  43.287  1.00 38.10      A   
ATOM    423  C   LEU    57      35.972  25.146  45.449  1.00 25.86      A   
ATOM    424  O   LEU    57      35.247  25.313  46.426  1.00 25.71      A   
ATOM    425  N   ALA    58      36.692  24.047  45.276  1.00 25.28      A   
ATOM    426  CA  ALA    58      36.663  22.995  46.279  1.00 23.68      A   
ATOM    427  CB  ALA    58      37.433  21.754  45.778  1.00 18.74      A   
ATOM    428  C   ALA    58      37.292  23.548  47.565  1.00 24.16      A   
ATOM    429  O   ALA    58      36.825  23.279  48.676  1.00 24.86      A   
ATOM    430  N   LEU    59      38.346  24.340  47.420  1.00 24.80      A   
ATOM    431  CA  LEU    59      39.009  24.912  48.594  1.00 25.22      A   
ATOM    432  CB  LEU    59      40.301  25.620  48.173  1.00 25.53      A   
ATOM    433  CG  LEU    59      41.408  24.698  47.635  1.00 23.74      A   
ATOM    434  CD1 LEU    59      42.621  25.539  47.185  1.00 28.11      A   
ATOM    435  CD2 LEU    59      41.819  23.735  48.726  1.00 25.60      A   
ATOM    436  C   LEU    59      38.075  25.896  49.282  1.00 26.66      A   
ATOM    437  O   LEU    59      37.977  25.945  50.514  1.00 25.80      A   
ATOM    438  N   LEU    60      37.380  26.675  48.469  1.00 26.26      A   
ATOM    439  CA  LEU    60      36.454  27.660  48.999  1.00 28.13      A   
ATOM    440  CB  LEU    60      35.907  28.519  47.858  1.00 28.63      A   
ATOM    441  CG  LEU    60      35.022  29.723  48.203  1.00 33.95      A   
ATOM    442  CD1 LEU    60      35.829  30.845  48.888  1.00 33.12      A   
ATOM    443  CD2 LEU    60      34.412  30.234  46.899  1.00 35.66      A   
ATOM    444  C   LEU    60      35.297  26.996  49.739  1.00 27.53      A   
ATOM    445  O   LEU    60      34.984  27.358  50.866  1.00 27.40      A   
ATOM    446  N   LEU    61      34.675  26.006  49.109  1.00 23.07      A   
ATOM    447  CA  LEU    61      33.526  25.334  49.705  1.00 22.98      A   
ATOM    448  CB  LEU    61      32.680  24.689  48.598  1.00 23.07      A   
ATOM    449  CG  LEU    61      32.164  25.739  47.597  1.00 26.73      A   
ATOM    450  CD1 LEU    61      31.443  25.061  46.434  1.00 24.40      A   
ATOM    451  CD2 LEU    61      31.237  26.720  48.324  1.00 27.56      A   
ATOM    452  C   LEU    61      33.819  24.320  50.796  1.00 22.65      A   
ATOM    453  O   LEU    61      32.915  23.903  51.503  1.00 21.35      A   
ATOM    454  N   ALA    62      35.075  23.920  50.951  1.00 25.49      A   
ATOM    455  CA  ALA    62      35.398  22.957  51.988  1.00 28.72      A   
ATOM    456  CB  ALA    62      36.917  22.823  52.118  1.00 45.83      A   
ATOM    457  C   ALA    62      34.788  23.337  53.346  1.00 29.14      A   
ATOM    458  O   ALA    62      34.822  24.498  53.757  1.00 29.36      A   
ATOM    459  N   ASP    63      34.216  22.350  54.025  1.00 29.35      A   
ATOM    460  CA  ASP    63      33.626  22.560  55.340  1.00 30.52      A   
ATOM    461  CB  ASP    63      34.732  22.890  56.348  1.00 46.08      A   
ATOM    462  CG  ASP    63      35.839  21.853  56.353  1.00 49.24      A   
ATOM    463  OD1 ASP    63      35.531  20.666  56.581  1.00 50.62      A   
ATOM    464  OD2 ASP    63      37.012  22.220  56.122  1.00 52.95      A   
ATOM    465  C   ASP    63      32.541  23.633  55.418  1.00 30.03      A   
ATOM    466  O   ASP    63      32.391  24.279  56.451  1.00 29.98      A   
ATOM    467  N   THR    64      31.779  23.838  54.347  1.00 27.75      A   
ATOM    468  CA  THR    64      30.705  24.833  54.407  1.00 28.05      A   
ATOM    469  CB  THR    64      29.982  24.997  53.054  1.00 31.02      A   
ATOM    470  OG1 THR    64      30.929  25.362  52.049  1.00 29.72      A   
ATOM    471  CG2 THR    64      28.917  26.094  53.142  1.00 31.52      A   
ATOM    472  C   THR    64      29.685  24.312  55.409  1.00 28.21      A   
ATOM    473  O   THR    64      29.289  23.145  55.342  1.00 25.04      A   
ATOM    474  N   PRO    65      29.257  25.153  56.365  1.00 31.00      A   
ATOM    475  CD  PRO    65      29.811  26.446  56.816  1.00 31.55      A   
ATOM    476  CA  PRO    65      28.272  24.635  57.321  1.00 31.25      A   
ATOM    477  CB  PRO    65      28.004  25.837  58.233  1.00 31.38      A   
ATOM    478  CG  PRO    65      29.332  26.534  58.272  1.00 31.89      A   
ATOM    479  C   PRO    65      27.000  24.171  56.610  1.00 32.82      A   
ATOM    480  O   PRO    65      26.565  24.802  55.645  1.00 33.91      A   
ATOM    481  N   LEU    66      26.397  23.084  57.081  1.00 29.49      A   
ATOM    482  CA  LEU    66      25.160  22.609  56.462  1.00 32.04      A   
ATOM    483  CB  LEU    66      24.726  21.262  57.051  1.00 38.32      A   
ATOM    484  CG  LEU    66      25.796  20.180  56.907  1.00 42.26      A   
ATOM    485  CD1 LEU    66      25.271  18.857  57.429  1.00 42.26      A   
ATOM    486  CD2 LEU    66      26.187  20.053  55.442  1.00 41.30      A   
ATOM    487  C   LEU    66      24.068  23.641  56.679  1.00 30.22      A   
ATOM    488  O   LEU    66      24.003  24.275  57.734  1.00 29.76      A   
ATOM    489  N   GLY    67      23.204  23.804  55.683  1.00 29.89      A   
ATOM    490  CA  GLY    67      22.145  24.789  55.787  1.00 27.82      A   
ATOM    491  C   GLY    67      22.556  26.109  55.145  1.00 27.55      A   
ATOM    492  O   GLY    67      21.704  26.954  54.861  1.00 27.26      A   
ATOM    493  N   THR    68      23.856  26.298  54.912  1.00 25.80      A   
ATOM    494  CA  THR    68      24.353  27.536  54.300  1.00 26.75      A   
ATOM    495  CB  THR    68      25.879  27.500  54.089  1.00 31.47      A   
ATOM    496  OG1 THR    68      26.531  27.304  55.345  1.00 32.99      A   
ATOM    497  CG2 THR    68      26.375  28.822  53.488  1.00 31.56      A   
ATOM    498  C   THR    68      23.731  27.803  52.937  1.00 28.81      A   
ATOM    499  O   THR    68      23.567  26.882  52.133  1.00 26.16      A   
ATOM    500  N   GLU    69      23.409  29.066  52.674  1.00 31.53      A   
ATOM    501  CA  GLU    69      22.826  29.467  51.399  1.00 34.95      A   
ATOM    502  CB  GLU    69      22.024  30.760  51.558  1.00 59.01      A   
ATOM    503  CG  GLU    69      21.170  31.132  50.347  1.00 66.23      A   
ATOM    504  CD  GLU    69      20.135  30.050  50.054  1.00 71.75      A   
ATOM    509  C   GLU    69      23.938  29.686  50.384  1.00 35.52      A   
ATOM    510  O   GLU    69      24.977  30.273  50.702  1.00 37.15      A   
ATOM    511  N   MET    70      23.695  29.239  49.157  1.00 27.26      A   
ATOM    512  CA  MET    70      24.663  29.338  48.078  0.50 29.37      A   
ATOM    513  CB  MET    70      25.252  27.954  47.788  0.50 53.54      A   
ATOM    514  CG  MET    70      25.898  27.307  48.976  0.50 59.96      A   
ATOM    515  SD  MET    70      27.190  28.525  49.679  0.50 69.62      A   
ATOM    516  CE  MET    70      28.377  28.589  48.155  0.50 67.14      A   
ATOM    517  C   MET    70      24.064  29.869  46.788  1.00 28.37      A   
ATOM    518  O   MET    70      22.861  29.775  46.564  1.00 28.60      A   
ATOM    519  N   GLN    71      24.931  30.416  45.946  1.00 32.77      A   
ATOM    520  CA  GLN    71      24.554  30.924  44.636  1.00 33.87      A   
ATOM    521  CB  GLN    71      24.610  32.452  44.622  1.00 55.43      A   
ATOM    522  CG  GLN    71      23.690  33.092  43.609  1.00 61.78      A   
ATOM    523  CD  GLN    71      23.401  34.545  43.937  1.00 63.91      A   
ATOM    524  OE1 GLN    71      22.963  34.868  45.043  1.00 64.97      A   
ATOM    525  NE2 GLN    71      23.639  35.428  42.975  1.00 64.85      A   
ATOM    526  C   GLN    71      25.634  30.313  43.749  1.00 30.52      A   
ATOM    527  O   GLN    71      26.811  30.644  43.875  1.00 30.63      A   
ATOM    528  N   VAL    72      25.248  29.401  42.866  1.00 27.97      A   
ATOM    529  CA  VAL    72      26.238  28.730  42.033  1.00 25.03      A   
ATOM    530  CB  VAL    72      26.467  27.273  42.499  1.00 26.61      A   
ATOM    531  CG1 VAL    72      26.901  27.239  43.951  1.00 27.06      A   
ATOM    532  CG2 VAL    72      25.179  26.471  42.318  1.00 26.00      A   
ATOM    533  C   VAL    72      25.862  28.658  40.569  1.00 26.84      A   
ATOM    534  O   VAL    72      24.712  28.888  40.198  1.00 27.56      A   
ATOM    535  N   GLN    73      26.856  28.316  39.754  1.00 27.71      A   
ATOM    536  CA  GLN    73      26.687  28.143  38.317  1.00 27.13      A   
ATOM    537  CB  GLN    73      26.831  29.481  37.570  1.00 38.19      A   
ATOM    538  CG  GLN    73      28.234  29.910  37.209  1.00 44.88      A   
ATOM    539  CD  GLN    73      28.772  29.236  35.954  1.00 45.71      A   
ATOM    540  OE1 GLN    73      28.021  28.672  35.152  1.00 49.24      A   
ATOM    541  NE2 GLN    73      30.079  29.307  35.774  1.00 46.81      A   
ATOM    542  C   GLN    73      27.744  27.150  37.854  1.00 26.57      A   
ATOM    543  O   GLN    73      28.808  27.020  38.475  1.00 22.41      A   
ATOM    544  N   GLY    74      27.434  26.424  36.784  1.00 23.92      A   
ATOM    545  CA  GLY    74      28.367  25.451  36.252  1.00 24.43      A   
ATOM    546  C   GLY    74      27.689  24.689  35.136  1.00 22.75      A   
ATOM    547  O   GLY    74      26.615  25.086  34.683  1.00 23.35      A   
ATOM    548  N   PHE    75      28.301  23.598  34.690  1.00 25.04      A   
ATOM    549  CA  PHE    75      27.713  22.808  33.620  1.00 25.32      A   
ATOM    550  CB  PHE    75      28.725  22.635  32.481  1.00 25.85      A   
ATOM    551  CG  PHE    75      29.955  21.841  32.858  1.00 27.05      A   
ATOM    552  CD1 PHE    75      30.002  20.452  32.677  1.00 25.82      A   
ATOM    553  CD2 PHE    75      31.082  22.487  33.367  1.00 28.65      A   
ATOM    554  CE1 PHE    75      31.164  19.712  33.000  1.00 25.68      A   
ATOM    555  CE2 PHE    75      32.241  21.771  33.692  1.00 28.59      A   
ATOM    556  CZ  PHE    75      32.285  20.375  33.506  1.00 28.50      A   
ATOM    557  C   PHE    75      27.237  21.455  34.128  1.00 25.44      A   
ATOM    558  O   PHE    75      27.764  20.928  35.107  1.00 26.99      A   
ATOM    559  N   LEU    76      26.224  20.908  33.464  1.00 25.34      A   
ATOM    560  CA  LEU    76      25.661  19.615  33.832  1.00 25.23      A   
ATOM    561  CB  LEU    76      24.162  19.579  33.505  1.00 29.09      A   
ATOM    562  CG  LEU    76      23.305  20.609  34.243  1.00 32.39      A   
ATOM    563  CD1 LEU    76      21.852  20.511  33.803  1.00 33.79      A   
ATOM    564  CD2 LEU    76      23.432  20.354  35.744  1.00 30.67      A   
ATOM    565  C   LEU    76      26.363  18.496  33.084  1.00 26.07      A   
ATOM    566  O   LEU    76      26.751  18.667  31.935  1.00 24.95      A   
ATOM    567  N   ALA    77      26.540  17.355  33.739  1.00 22.60      A   
ATOM    568  CA  ALA    77      27.177  16.230  33.077  1.00 24.61      A   
ATOM    569  CB  ALA    77      28.713  16.251  33.315  1.00 33.80      A   
ATOM    570  C   ALA    77      26.572  14.960  33.624  1.00 24.60      A   
ATOM    571  O   ALA    77      26.036  14.945  34.732  1.00 25.29      A   
ATOM    572  N   PRO    78      26.617  13.876  32.842  1.00 25.80      A   
ATOM    573  CD  PRO    78      27.189  13.690  31.497  1.00 32.45      A   
ATOM    574  CA  PRO    78      26.048  12.631  33.351  1.00 26.85      A   
ATOM    575  CB  PRO    78      26.263  11.648  32.194  1.00 31.58      A   
ATOM    576  CG  PRO    78      27.464  12.200  31.481  1.00 32.92      A   
ATOM    577  C   PRO    78      26.820  12.245  34.612  1.00 28.40      A   
ATOM    578  O   PRO    78      28.010  12.519  34.722  1.00 27.48      A   
ATOM    579  N   ALA    79      26.137  11.635  35.570  1.00 28.15      A   
ATOM    580  CA  ALA    79      26.780  11.240  36.811  1.00 32.75      A   
ATOM    581  CB  ALA    79      25.735  10.691  37.789  1.00 37.42      A   
ATOM    582  C   ALA    79      27.832  10.179  36.541  1.00 35.06      A   
ATOM    583  O   ALA    79      28.909  10.193  37.125  1.00 36.08      A   
ATOM    584  N   ARG    80      27.492   9.263  35.642  1.00 41.92      A   
ATOM    585  CA  ARG    80      28.339   8.133  35.266  1.00 46.18      A   
ATOM    586  CB  ARG    80      27.786   6.882  35.964  1.00 73.73      A   
ATOM    587  CG  ARG    80      28.511   5.572  35.732  1.00 79.35      A   
ATOM    588  CD  ARG    80      27.713   4.428  36.364  1.00 81.88      A   
ATOM    589  NE  ARG    80      28.500   3.208  36.494  1.00 85.97      A   
ATOM    590  CZ  ARG    80      29.561   3.084  37.286  1.00 87.59      A   
ATOM    591  NH1 ARG    80      29.967   4.110  38.025  1.00 88.43      A   
ATOM    592  NH2 ARG    80      30.217   1.933  37.340  1.00 88.57      A   
ATOM    593  C   ARG    80      28.209   8.006  33.749  1.00 47.15      A   
ATOM    594  O   ARG    80      27.216   8.471  33.180  1.00 46.35      A   
ATOM    595  N   LYS    81      29.184   7.387  33.084  1.00 38.64      A   
ATOM    596  CA  LYS    81      29.091   7.254  31.632  1.00 39.16      A   
ATOM    597  CB  LYS    81      30.202   6.368  31.060  1.00 63.40      A   
ATOM    598  CG  LYS    81      30.154   6.338  29.533  1.00 66.98      A   
ATOM    599  CD  LYS    81      30.962   5.215  28.914  1.00 70.58      A   
ATOM    600  CE  LYS    81      30.789   5.220  27.397  1.00 71.45      A   
ATOM    601  NZ  LYS    81      31.537   4.113  26.726  1.00 72.84      A   
ATOM    602  C   LYS    81      27.745   6.650  31.241  1.00 38.59      A   
ATOM    603  O   LYS    81      27.293   5.668  31.834  1.00 37.24      A   
ATOM    604  N   ASP    82      27.110   7.254  30.241  1.00 52.57      A   
ATOM    605  CA  ASP    82      25.816   6.807  29.730  1.00 52.05      A   
ATOM    606  CB  ASP    82      25.911   5.366  29.220  1.00 68.98      A   
ATOM    607  CG  ASP    82      27.001   5.185  28.182  1.00 70.72      A   
ATOM    608  OD1 ASP    82      27.046   5.992  27.231  1.00 72.42      A   
ATOM    609  OD2 ASP    82      27.804   4.235  28.316  1.00 72.35      A   
ATOM    610  C   ASP    82      24.682   6.897  30.740  1.00 50.43      A   
ATOM    611  O   ASP    82      23.577   6.408  30.490  1.00 51.73      A   
ATOM    612  N   SER    83      24.945   7.517  31.881  1.00 39.89      A   
ATOM    613  CA  SER    83      23.913   7.644  32.899  1.00 36.24      A   
ATOM    614  CB  SER    83      24.530   7.944  34.265  1.00 33.61      A   
ATOM    615  OG  SER    83      23.522   8.223  35.221  1.00 28.96      A   
ATOM    616  C   SER    83      22.911   8.738  32.572  1.00 33.85      A   
ATOM    617  O   SER    83      23.245   9.741  31.931  1.00 33.01      A   
ATOM    618  N   VAL    84      21.680   8.543  33.025  1.00 29.61      A   
ATOM    619  CA  VAL    84      20.651   9.537  32.810  1.00 29.31      A   
ATOM    620  CB  VAL    84      19.262   8.886  32.603  1.00 39.19      A   
ATOM    621  CG1 VAL    84      19.294   7.998  31.360  1.00 39.94      A   
ATOM    622  CG2 VAL    84      18.858   8.081  33.831  1.00 40.95      A   
ATOM    623  C   VAL    84      20.641  10.458  34.032  1.00 28.11      A   
ATOM    624  O   VAL    84      19.996  11.503  34.020  1.00 26.08      A   
ATOM    625  N   LYS    85      21.366  10.070  35.084  1.00 22.87      A   
ATOM    626  CA  LYS    85      21.445  10.895  36.293  1.00 22.83      A   
ATOM    627  CB  LYS    85      22.032  10.112  37.478  1.00 22.58      A   
ATOM    628  CG  LYS    85      21.174   8.979  38.029  1.00 28.58      A   
ATOM    629  CD  LYS    85      21.958   8.197  39.104  1.00 30.17      A   
ATOM    630  CE  LYS    85      21.265   6.899  39.500  1.00 34.34      A   
ATOM    631  NZ  LYS    85      22.133   6.072  40.407  1.00 31.90      A   
ATOM    632  C   LYS    85      22.382  12.043  35.974  1.00 22.94      A   
ATOM    633  O   LYS    85      23.359  11.853  35.252  1.00 22.47      A   
ATOM    634  N   VAL    86      22.135  13.217  36.543  1.00 27.51      A   
ATOM    635  CA  VAL    86      22.988  14.356  36.220  1.00 27.63      A   
ATOM    636  CB  VAL    86      22.190  15.440  35.448  1.00 25.37      A   
ATOM    637  CG1 VAL    86      21.432  14.805  34.289  1.00 26.36      A   
ATOM    638  CG2 VAL    86      21.223  16.150  36.390  1.00 27.29      A   
ATOM    639  C   VAL    86      23.616  15.002  37.443  1.00 29.12      A   
ATOM    640  O   VAL    86      23.017  15.023  38.522  1.00 30.61      A   
ATOM    641  N   LYS    87      24.809  15.556  37.248  1.00 22.01      A   
ATOM    642  CA  LYS    87      25.548  16.208  38.314  1.00 24.43      A   
ATOM    643  CB  LYS    87      26.761  15.336  38.671  1.00 40.98      A   
ATOM    644  CG  LYS    87      27.433  15.627  40.001  1.00 46.69      A   
ATOM    645  CD  LYS    87      28.325  14.450  40.447  1.00 48.24      A   
ATOM    646  CE  LYS    87      27.499  13.214  40.797  1.00 51.31      A   
ATOM    647  NZ  LYS    87      28.341  12.049  41.233  1.00 55.32      A   
ATOM    648  C   LYS    87      25.984  17.591  37.836  1.00 23.09      A   
ATOM    649  O   LYS    87      26.281  17.787  36.657  1.00 22.07      A   
ATOM    650  N   LEU    88      25.987  18.555  38.748  1.00 24.75      A   
ATOM    651  CA  LEU    88      26.404  19.905  38.422  1.00 25.06      A   
ATOM    652  CB  LEU    88      25.617  20.921  39.247  1.00 23.11      A   
ATOM    653  CG  LEU    88      26.078  22.376  39.097  1.00 25.69      A   
ATOM    654  CD1 LEU    88      25.804  22.876  37.676  1.00 22.82      A   
ATOM    655  CD2 LEU    88      25.346  23.244  40.126  1.00 23.24      A   
ATOM    656  C   LEU    88      27.898  20.086  38.685  1.00 24.86      A   
ATOM    657  O   LEU    88      28.363  19.882  39.801  1.00 26.07      A   
ATOM    658  N   HIS    89      28.646  20.443  37.645  1.00 22.24      A   
ATOM    659  CA  HIS    89      30.079  20.678  37.772  1.00 22.99      A   
ATOM    660  CB  HIS    89      30.815  20.154  36.552  1.00 28.93      A   
ATOM    661  CG  HIS    89      30.842  18.660  36.478  1.00 32.11      A   
ATOM    662  CD2 HIS    89      29.846  17.745  36.531  1.00 29.81      A   
ATOM    663  ND1 HIS    89      32.012  17.945  36.332  1.00 33.49      A   
ATOM    664  CE1 HIS    89      31.734  16.654  36.296  1.00 32.57      A   
ATOM    665  NE2 HIS    89      30.426  16.505  36.413  1.00 31.69      A   
ATOM    666  C   HIS    89      30.294  22.168  37.932  1.00 23.14      A   
ATOM    667  O   HIS    89      30.226  22.933  36.974  1.00 21.94      A   
ATOM    668  N   LEU    90      30.546  22.556  39.176  1.00 25.38      A   
ATOM    669  CA  LEU    90      30.716  23.946  39.568  1.00 25.66      A   
ATOM    670  CB  LEU    90      30.891  24.017  41.093  1.00 24.41      A   
ATOM    671  CG  LEU    90      29.697  23.422  41.858  1.00 24.48      A   
ATOM    672  CD1 LEU    90      30.026  23.294  43.349  1.00 25.49      A   
ATOM    673  CD2 LEU    90      28.469  24.309  41.660  1.00 23.44      A   
ATOM    674  C   LEU    90      31.827  24.715  38.882  1.00 26.58      A   
ATOM    675  O   LEU    90      32.948  24.216  38.725  1.00 24.89      A   
ATOM    676  N   GLN    91      31.503  25.937  38.467  1.00 23.53      A   
ATOM    677  CA  GLN    91      32.473  26.808  37.815  1.00 25.88      A   
ATOM    678  CB  GLN    91      32.095  27.034  36.348  1.00 27.74      A   
ATOM    679  CG  GLN    91      32.159  25.782  35.506  1.00 28.30      A   
ATOM    680  CD  GLN    91      31.774  26.050  34.068  1.00 30.80      A   
ATOM    681  OE1 GLN    91      30.673  26.513  33.794  1.00 27.87      A   
ATOM    682  NE2 GLN    91      32.684  25.763  33.140  1.00 32.48      A   
ATOM    683  C   GLN    91      32.515  28.131  38.568  1.00 26.48      A   
ATOM    684  O   GLN    91      33.488  28.875  38.477  1.00 28.32      A   
ATOM    685  N   GLN    92      31.442  28.422  39.298  1.00 26.61      A   
ATOM    686  CA  GLN    92      31.355  29.626  40.113  1.00 27.30      A   
ATOM    687  CB  GLN    92      30.724  30.797  39.352  1.00 41.60      A   
ATOM    688  CG  GLN    92      31.445  31.244  38.093  1.00 45.91      A   
ATOM    689  CD  GLN    92      30.909  32.574  37.586  1.00 49.65      A   
ATOM    690  OE1 GLN    92      29.706  32.814  37.603  1.00 52.22      A   
ATOM    691  NE2 GLN    92      31.801  33.438  37.130  1.00 52.57      A   
ATOM    692  C   GLN    92      30.486  29.326  41.328  1.00 28.32      A   
ATOM    693  O   GLN    92      29.496  28.590  41.244  1.00 25.42      A   
ATOM    694  N   ALA    93      30.856  29.897  42.464  1.00 25.17      A   
ATOM    695  CA  ALA    93      30.080  29.688  43.672  1.00 28.30      A   
ATOM    696  CB  ALA    93      30.458  28.362  44.319  1.00 41.80      A   
ATOM    697  C   ALA    93      30.330  30.823  44.640  1.00 30.53      A   
ATOM    698  O   ALA    93      31.444  31.339  44.722  1.00 29.69      A   
ATOM    699  N   ARG    94      29.284  31.224  45.353  1.00 29.52      A   
ATOM    700  CA  ARG    94      29.399  32.275  46.349  1.00 36.47      A   
ATOM    701  CB  ARG    94      29.080  33.652  45.749  1.00 66.16      A   
ATOM    702  CG  ARG    94      27.760  33.735  45.008  1.00 71.03      A   
ATOM    703  CD  ARG    94      26.758  34.634  45.723  1.00 76.08      A   
ATOM    704  NE  ARG    94      27.222  36.015  45.829  1.00 79.33      A   
ATOM    705  CZ  ARG    94      26.520  37.001  46.383  1.00 81.20      A   
ATOM    706  NH1 ARG    94      27.029  38.225  46.436  1.00 82.52      A   
ATOM    707  NH2 ARG    94      25.308  36.771  46.878  1.00 82.63      A   
ATOM    708  C   ARG    94      28.478  31.973  47.525  1.00 39.20      A   
ATOM    709  O   ARG    94      27.302  31.636  47.360  1.00 37.22      A   
ATOM    710  N   ARG    95      29.048  32.083  48.717  1.00 48.54      A   
ATOM    711  CA  ARG    95      28.346  31.826  49.964  1.00 54.70      A   
ATOM    712  CB  ARG    95      29.371  31.419  51.026  1.00 65.41      A   
ATOM    713  CG  ARG    95      28.864  31.285  52.442  1.00 68.11      A   
ATOM    714  CD  ARG    95      29.987  30.725  53.310  1.00 70.28      A   
ATOM    715  NE  ARG    95      29.590  30.495  54.696  1.00 72.39      A   
ATOM    716  CZ  ARG    95      30.260  29.720  55.544  1.00 72.88      A   
ATOM    717  NH1 ARG    95      31.364  29.096  55.149  1.00 73.41      A   
ATOM    718  NH2 ARG    95      29.824  29.563  56.786  1.00 74.05      A   
ATOM    719  C   ARG    95      27.595  33.077  50.395  1.00 57.64      A   
ATOM    720  O   ARG    95      28.201  34.125  50.610  1.00 58.67      A   
ATOM    721  N   ILE    96      26.273  32.969  50.506  1.00 76.07      A   
ATOM    722  CA  ILE    96      25.449  34.102  50.916  1.00 79.88      A   
ATOM    723  CB  ILE    96      24.011  34.007  50.355  1.00 69.35      A   
ATOM    724  CG2 ILE    96      23.276  35.308  50.633  1.00 69.35      A   
ATOM    725  CG1 ILE    96      24.042  33.731  48.850  1.00 69.24      A   
ATOM    726  CD1 ILE    96      22.682  33.474  48.244  1.00 69.56      A   
ATOM    727  C   ILE    96      25.353  34.158  52.440  1.00 82.47      A   
ATOM    728  O   ILE    96      24.751  33.284  53.064  1.00 82.91      A   
ATOM    729  N   ALA    97      25.946  35.189  53.034  1.00 94.57      A   
ATOM    730  CA  ALA    97      25.927  35.352  54.483  1.00 97.13      A   
ATOM    731  CB  ALA    97      27.216  36.007  54.952  1.00 79.37      A   
ATOM    732  C   ALA    97      24.739  36.199  54.903  1.00 98.75      A   
ATOM    733  O   ALA    97      24.671  37.386  54.585  1.00 99.27      A   
ATOM    734  N   GLY    98      23.806  35.583  55.621  1.00 99.99      A   
ATOM    735  CA  GLY    98      22.629  36.298  56.077  1.00101.66      A   
ATOM    736  C   GLY    98      22.852  36.898  57.451  1.00102.77      A   
ATOM    737  O   GLY    98      23.977  36.751  57.976  1.00103.27      A   
ATOM    738  OXT GLY    98      21.912  37.513  58.004  1.00 93.70      A   
END
