
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   89 (  724),  selected   89 , name 1z9f_A
# Molecule2: number of CA atoms   98 (  734),  selected   98 , name T0491.pdb
# PARAMETERS: 1z9f_A.T0491.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    H     0_A      -       -           -
LGA    M     1_A      -       -           -
LGA    S     2_A      -       -           -
LGA    F     3_A      -       -           -
LGA    F     4_A      M       1          0.343
LGA    N     5_A      N       2          0.420
LGA    K     6_A      T       3          0.496
LGA    I     7_A      L       4          0.441
LGA    I     8_A      E       5          0.538
LGA    L     9_A      L       6          0.587
LGA    I    10_A      S       7          0.446
LGA    G    11_A      A       8          0.655
LGA    R    12_A      R       9          0.463
LGA    L    13_A      V      10          0.375
LGA    V    14_A      L      11          0.858
LGA    R    15_A      E      12          1.771
LGA    D    16_A      C      13          2.592
LGA    P    17_A      G      14          3.198
LGA    E    18_A      A      15          2.909
LGA    E    19_A      M      16          1.606
LGA    R    20_A      R      17          1.937
LGA    Y    21_A      H      18          1.313
LGA    T    22_A      T      19          1.314
LGA    L    23_A      P      20          1.191
LGA    -       -      A      21           -
LGA    -       -      G      22           -
LGA    T    26_A      L      23          1.494
LGA    P    27_A      P      24          0.845
LGA    V    28_A      A      25          0.525
LGA    T    29_A      L      26          0.555
LGA    T    30_A      E      27          0.985
LGA    F    31_A      L      28          0.432
LGA    T    32_A      L      29          0.940
LGA    I    33_A      L      30          0.797
LGA    A    34_A      V      31          0.649
LGA    V    35_A      H      32          0.238
LGA    D    36_A      E      33          1.292
LGA    R    37_A      S      34          3.021
LGA    T    49_A      E      35           -
LGA    -       -      V      36           -
LGA    -       -      V      37           -
LGA    -       -      E      38           -
LGA    -       -      A      39           -
LGA    -       -      G      40           -
LGA    -       -      H      41           -
LGA    -       -      P      42           -
LGA    -       -      R      43           -
LGA    -       -      R      44           -
LGA    -       -      V      45           -
LGA    T    50_A      E      46          1.612
LGA    D    51_A      L      47          0.513
LGA    F    52_A      T      48          0.386
LGA    F    53_A      I      49          0.986
LGA    R    54_A      S      50          0.552
LGA    I    55_A      A      51          0.903
LGA    V    56_A      V      52          0.554
LGA    T    57_A      A      53          0.462
LGA    F    58_A      L      54          0.602
LGA    G    59_A      G      55          0.805
LGA    R    60_A      D      56          1.479
LGA    L    61_A      L      57          1.102
LGA    A    62_A      A      58          0.760
LGA    E    63_A      L      59          1.184
LGA    F    64_A      L      60          1.205
LGA    A    65_A      L      61          1.120
LGA    R    66_A      A      62          0.773
LGA    T    67_A      D      63          4.493
LGA    Y    68_A      -       -           -
LGA    L    69_A      T      64          1.460
LGA    T    70_A      P      65          1.789
LGA    K    71_A      L      66          0.543
LGA    G    72_A      G      67          0.320
LGA    R    73_A      T      68          0.215
LGA    L    74_A      E      69          0.216
LGA    V    75_A      M      70          0.396
LGA    L    76_A      Q      71          0.547
LGA    V    77_A      V      72          0.873
LGA    E    78_A      Q      73          0.818
LGA    G    79_A      G      74          0.510
LGA    E    80_A      F      75          0.571
LGA    M    81_A      L      76          1.258
LGA    R    82_A      A      77          1.225
LGA    M    83_A      P      78          2.449
LGA    R    84_A      A      79          3.777
LGA    R    85_A      R      80          3.839
LGA    -       -      K      81           -
LGA    K    93_A      D      82          3.603
LGA    R    94_A      S      83          2.813
LGA    V    95_A      V      84          2.502
LGA    S    96_A      K      85          2.639
LGA    P    97_A      V      86          0.867
LGA    E    98_A      K      87          0.757
LGA    V    99_A      L      88          0.645
LGA    V   100_A      H      89          0.556
LGA    A   101_A      L      90          0.567
LGA    N   102_A      Q      91          0.628
LGA    V   103_A      Q      92          0.820
LGA    V   104_A      A      93          0.987
LGA    R   105_A      R      94          0.254
LGA    F   106_A      R      95          0.801
LGA    M   107_A      I      96          1.396
LGA    D   108_A      A      97          2.424
LGA    -       -      G      98           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   89   98    5.0     83    1.51    19.28     79.511     5.155

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.991561 * X  +   0.049655 * Y  +  -0.119758 * Z  +  16.847366
  Y_new =   0.109229 * X  +  -0.177607 * Y  +  -0.978021 * Z  +  -9.593678
  Z_new =  -0.069834 * X  +  -0.982848 * Y  +   0.170684 * Z  +  40.439289 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.398848    1.742744  [ DEG:   -80.1481     99.8519 ]
  Theta =   0.069891    3.071702  [ DEG:     4.0044    175.9956 ]
  Phi   =   3.031876   -0.109716  [ DEG:   173.7137     -6.2863 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1z9f_A                                        
REMARK     2: T0491.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1z9f_A.T0491.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   89   98   5.0   83   1.51   19.28  79.511
REMARK  ---------------------------------------------------------- 
MOLECULE 1z9f_A
HEADER    DNA BINDING PROTEIN                     01-APR-05   1Z9F              
TITLE     CRYSTAL STRUCTURE OF SINGLE STRANDED DNA-BINDING PROTEIN              
TITLE    2 (TM0604) FROM THERMOTOGA MARITIMA AT 2.60 A RESOLUTION               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SINGLE-STRAND BINDING PROTEIN;                             
COMPND   3 CHAIN: A;                                                            
COMPND   4 SYNONYM: SSB, HELIX-DESTABILIZING PROTEIN;                           
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: THERMOTOGA MARITIMA;                            
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: SSB;                                                           
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    TM0604, SINGLE STRANDED DNA-BINDING PROTEIN, STRUCTURAL               
KEYWDS   2 GENOMICS, JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG,                
KEYWDS   3 PROTEIN STRUCTURE INITIATIVE, PSI                                    
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   3   03-OCT-06 1Z9F    1       JRNL                                     
REVDAT   2   03-MAY-05 1Z9F    1       REMARK                                   
REVDAT   1   12-APR-05 1Z9F    0                                                
JRNL        AUTH   M.DIDONATO,S.S.KRISHNA,R.SCHWARZENBACHER,                    
JRNL        AUTH 2 D.MCMULLAN,L.JAROSZEWSKI,M.D.MILLER,P.ABDUBEK,               
JRNL        AUTH 3 S.AGARWALLA,E.AMBING,H.AXELROD,T.BIORAC,H.J.CHIU,            
JRNL        AUTH 4 A.M.DEACON,M.A.ELSLIGER,J.FEUERHELM,A.GODZIK,                
JRNL        AUTH 5 C.GRITTINI,S.K.GRZECHNIK,J.HALE,E.HAMPTON,J.HAUGEN,          
JRNL        AUTH 6 M.HORNSBY,H.E.KLOCK,M.W.KNUTH,E.KOESEMA,A.KREUSCH,           
JRNL        AUTH 7 P.KUHN,S.A.LESLEY,K.MOY,E.NIGOGHOSSIAN,L.OKACH,              
JRNL        AUTH 8 J.PAULSEN,K.QUIJANO,R.REYES,C.RIFE,G.SPRAGGON,               
JRNL        AUTH 9 R.C.STEVENS,H.VAN DEN BEDEM,J.VELASQUEZ,A.WHITE,             
JRNL        AUTH10 G.WOLF,Q.XU,K.O.HODGSON,J.WOOLEY,I.A.WILSON                  
JRNL        TITL   CRYSTAL STRUCTURE OF A SINGLE-STRANDED DNA-BINDING           
JRNL        TITL 2 PROTEIN (TM0604) FROM THERMOTOGA MARITIMA AT 2.60            
JRNL        TITL 3 A RESOLUTION.                                                
JRNL        REF    PROTEINS                      V.  63   256 2006              
JRNL        REFN   ASTM PSFGEY  US ISSN 0887-3585                               
REMARK   2 RESOLUTION. 2.30 ANGSTROMS.                                          
DBREF  1Z9F A    1   141  UNP    Q9WZ73   SSB_THEMA        1    141             
SEQRES   1 A  153  MET GLY SER ASP LYS ILE HIS HIS HIS HIS HIS HIS MET          
SEQRES   2 A  153  SER PHE PHE ASN LYS ILE ILE LEU ILE GLY ARG LEU VAL          
SEQRES   3 A  153  ARG ASP PRO GLU GLU ARG TYR THR LEU SER GLY THR PRO          
SEQRES   4 A  153  VAL THR THR PHE THR ILE ALA VAL ASP ARG VAL PRO ARG          
SEQRES   5 A  153  LYS ASN ALA PRO ASP ASP ALA GLN THR THR ASP PHE PHE          
SEQRES   6 A  153  ARG ILE VAL THR PHE GLY ARG LEU ALA GLU PHE ALA ARG          
SEQRES   7 A  153  THR TYR LEU THR LYS GLY ARG LEU VAL LEU VAL GLU GLY          
SEQRES   8 A  153  GLU MET ARG MET ARG ARG TRP GLU THR PRO THR GLY GLU          
SEQRES   9 A  153  LYS ARG VAL SER PRO GLU VAL VAL ALA ASN VAL VAL ARG          
SEQRES  10 A  153  PHE MET ASP ARG LYS PRO ALA GLU THR VAL SER GLU THR          
SEQRES  11 A  153  GLU GLU GLU LEU GLU ILE PRO GLU GLU ASP PHE SER SER          
SEQRES  12 A  153  ASP THR PHE SER GLU ASP GLU PRO PRO PHE                      
FORMUL   2  HOH   *14(H2 O)                                                     
CRYST1   76.589   83.406   86.431  90.00  90.00  90.00 F 2 2 2      16          
ATOM      1  N   HIS A   0      34.626  29.449  20.324  1.00 90.48           N  
ATOM      2  CA  HIS A   0      33.689  28.829  19.325  1.00 90.62           C  
ATOM      3  C   HIS A   0      33.270  27.428  19.767  1.00 89.79           C  
ATOM      4  O   HIS A   0      33.965  26.799  20.586  1.00 90.23           O  
ATOM      5  CB  HIS A   0      34.341  28.734  17.933  1.00 91.27           C  
ATOM      6  CG  HIS A   0      35.190  27.506  17.738  1.00 93.03           C  
ATOM      7  ND1 HIS A   0      36.560  27.503  17.915  1.00 94.71           N  
ATOM      8  CD2 HIS A   0      34.853  26.235  17.399  1.00 94.21           C  
ATOM      9  CE1 HIS A   0      37.028  26.285  17.695  1.00 95.10           C  
ATOM     10  NE2 HIS A   0      36.013  25.497  17.381  1.00 94.83           N  
ATOM     11  N   MET A   1      32.167  26.941  19.187  1.00 88.55           N  
ATOM     12  CA  MET A   1      31.684  25.560  19.372  1.00 87.59           C  
ATOM     13  C   MET A   1      30.295  25.357  18.730  1.00 86.71           C  
ATOM     14  O   MET A   1      30.143  24.483  17.871  1.00 86.79           O  
ATOM     15  CB  MET A   1      31.621  25.184  20.860  1.00 88.02           C  
ATOM     16  CG  MET A   1      31.446  23.701  21.156  1.00 88.69           C  
ATOM     17  SD  MET A   1      31.584  23.374  22.941  1.00 89.76           S  
ATOM     18  CE  MET A   1      33.302  22.819  23.014  1.00 90.31           C  
ATOM     19  N   SER A   2      29.314  26.163  19.166  1.00 85.18           N  
ATOM     20  CA  SER A   2      27.902  26.173  18.675  1.00 84.24           C  
ATOM     21  C   SER A   2      26.920  25.515  19.661  1.00 82.60           C  
ATOM     22  O   SER A   2      25.812  25.123  19.296  1.00 82.43           O  
ATOM     23  CB  SER A   2      27.756  25.541  17.286  1.00 83.93           C  
ATOM     24  OG  SER A   2      26.501  25.852  16.718  1.00 83.74           O  
ATOM     25  N   PHE A   3      27.343  25.418  20.914  1.00 80.95           N  
ATOM     26  CA  PHE A   3      26.610  24.746  21.964  1.00 79.60           C  
ATOM     27  C   PHE A   3      26.807  25.546  23.245  1.00 78.29           C  
ATOM     28  O   PHE A   3      27.664  26.421  23.286  1.00 78.52           O  
ATOM     29  CB  PHE A   3      27.129  23.320  22.129  1.00 79.86           C  
ATOM     30  CG  PHE A   3      26.879  22.448  20.927  1.00 80.42           C  
ATOM     31  CD1 PHE A   3      25.670  21.773  20.781  1.00 80.94           C  
ATOM     32  CD2 PHE A   3      27.844  22.313  19.927  1.00 81.19           C  
ATOM     33  CE1 PHE A   3      25.420  20.969  19.661  1.00 80.71           C  
ATOM     34  CE2 PHE A   3      27.607  21.506  18.796  1.00 81.18           C  
ATOM     35  CZ  PHE A   3      26.389  20.834  18.669  1.00 80.82           C  
ATOM     36  N   PHE A   4      26.020  25.270  24.280  1.00 76.48           N  
ATOM     37  CA  PHE A   4      26.060  26.069  25.485  1.00 75.32           C  
ATOM     38  C   PHE A   4      25.403  25.328  26.610  1.00 75.02           C  
ATOM     39  O   PHE A   4      24.428  24.654  26.421  1.00 74.44           O  
ATOM     40  CB  PHE A   4      25.362  27.413  25.259  1.00 75.49           C  
ATOM     41  CG  PHE A   4      25.507  28.383  26.405  1.00 75.23           C  
ATOM     42  CD1 PHE A   4      26.745  28.906  26.720  1.00 76.33           C  
ATOM     43  CD2 PHE A   4      24.417  28.773  27.160  1.00 75.58           C  
ATOM     44  CE1 PHE A   4      26.911  29.802  27.747  1.00 75.82           C  
ATOM     45  CE2 PHE A   4      24.567  29.670  28.203  1.00 76.20           C  
ATOM     46  CZ  PHE A   4      25.847  30.183  28.497  1.00 77.04           C  
ATOM     47  N   ASN A   5      25.950  25.441  27.800  1.00 75.71           N  
ATOM     48  CA  ASN A   5      25.425  24.692  28.927  1.00 76.28           C  
ATOM     49  C   ASN A   5      25.707  25.497  30.171  1.00 76.96           C  
ATOM     50  O   ASN A   5      26.826  25.607  30.561  1.00 77.06           O  
ATOM     51  CB  ASN A   5      26.099  23.323  28.977  1.00 75.46           C  
ATOM     52  CG  ASN A   5      25.711  22.508  30.176  1.00 75.60           C  
ATOM     53  OD1 ASN A   5      25.364  23.036  31.228  1.00 75.77           O  
ATOM     54  ND2 ASN A   5      25.808  21.179  30.032  1.00 74.70           N  
ATOM     55  N   LYS A   6      24.677  26.086  30.767  1.00 77.42           N  
ATOM     56  CA  LYS A   6      24.872  26.932  31.902  1.00 77.48           C  
ATOM     57  C   LYS A   6      23.807  26.682  32.915  1.00 78.25           C  
ATOM     58  O   LYS A   6      22.606  26.732  32.591  1.00 77.90           O  
ATOM     59  CB  LYS A   6      24.769  28.360  31.414  1.00 78.60           C  
ATOM     60  CG  LYS A   6      25.170  29.414  32.376  1.00 79.79           C  
ATOM     61  CD  LYS A   6      26.377  29.062  32.976  1.00 82.62           C  
ATOM     62  CE  LYS A   6      27.131  30.171  33.556  0.65 85.40           C  
ATOM     64  NZ  LYS A   6      28.474  29.590  33.980  0.65 84.16           N  
ATOM     66  N   ILE A   7      24.221  26.432  34.154  1.00 78.33           N  
ATOM     67  CA  ILE A   7      23.238  26.315  35.224  1.00 78.13           C  
ATOM     68  C   ILE A   7      23.603  27.251  36.394  1.00 77.94           C  
ATOM     69  O   ILE A   7      24.736  27.361  36.763  1.00 77.56           O  
ATOM     70  CB  ILE A   7      22.976  24.827  35.660  1.00 78.59           C  
ATOM     71  CG1 ILE A   7      21.743  24.775  36.577  1.00 79.19           C  
ATOM     72  CG2 ILE A   7      24.177  24.206  36.348  1.00 76.60           C  
ATOM     73  CD1 ILE A   7      21.212  23.443  36.784  1.00 78.03           C  
ATOM     74  N   ILE A   8      22.597  27.946  36.918  1.00 78.43           N  
ATOM     75  CA  ILE A   8      22.731  28.829  38.056  1.00 78.28           C  
ATOM     76  C   ILE A   8      21.657  28.447  39.051  1.00 78.56           C  
ATOM     77  O   ILE A   8      20.469  28.479  38.734  1.00 78.63           O  
ATOM     78  CB  ILE A   8      22.545  30.286  37.673  1.00 77.86           C  
ATOM     79  CG1 ILE A   8      23.526  30.643  36.563  1.00 78.93           C  
ATOM     80  CG2 ILE A   8      22.672  31.174  38.903  1.00 76.84           C  
ATOM     81  CD1 ILE A   8      23.278  31.970  35.927  1.00 81.29           C  
ATOM     82  N   LEU A   9      22.103  28.092  40.251  1.00 79.14           N  
ATOM     83  CA  LEU A   9      21.233  27.584  41.314  1.00 79.13           C  
ATOM     84  C   LEU A   9      21.549  28.395  42.538  1.00 79.55           C  
ATOM     85  O   LEU A   9      22.688  28.812  42.703  1.00 80.33           O  
ATOM     86  CB  LEU A   9      21.538  26.109  41.605  1.00 79.08           C  
ATOM     87  CG  LEU A   9      21.422  25.175  40.395  1.00 78.06           C  
ATOM     88  CD1 LEU A   9      22.037  23.863  40.661  1.00 78.13           C  
ATOM     89  CD2 LEU A   9      19.976  25.029  39.963  1.00 77.12           C  
ATOM     90  N   ILE A  10      20.532  28.682  43.344  1.00 79.30           N  
ATOM     91  CA  ILE A  10      20.716  29.205  44.698  1.00 78.90           C  
ATOM     92  C   ILE A  10      19.958  28.280  45.658  1.00 79.12           C  
ATOM     93  O   ILE A  10      18.735  28.148  45.559  1.00 78.40           O  
ATOM     94  CB  ILE A  10      20.208  30.633  44.859  1.00 78.70           C  
ATOM     95  CG1 ILE A  10      21.064  31.595  44.045  1.00 78.61           C  
ATOM     96  CG2 ILE A  10      20.263  31.046  46.313  1.00 78.41           C  
ATOM     97  CD1 ILE A  10      20.554  33.010  44.041  1.00 78.35           C  
ATOM     98  N   GLY A  11      20.697  27.628  46.559  1.00 79.05           N  
ATOM     99  CA  GLY A  11      20.108  26.712  47.512  1.00 79.32           C  
ATOM    100  C   GLY A  11      20.940  26.542  48.761  1.00 79.64           C  
ATOM    101  O   GLY A  11      22.058  27.042  48.848  1.00 79.79           O  
ATOM    102  N   ARG A  12      20.372  25.839  49.744  0.50 79.82           N  
ATOM    104  CA  ARG A  12      21.067  25.546  50.999  0.50 79.79           C  
ATOM    106  C   ARG A  12      21.912  24.293  50.781  0.50 80.05           C  
ATOM    108  O   ARG A  12      21.558  23.452  49.956  0.50 79.95           O  
ATOM    110  CB  ARG A  12      20.102  25.284  52.179  0.50 79.73           C  
ATOM    112  CG  ARG A  12      18.717  25.963  52.187  0.50 79.32           C  
ATOM    114  CD  ARG A  12      18.708  27.499  52.270  0.50 78.47           C  
ATOM    116  NE  ARG A  12      19.596  28.061  53.294  0.50 77.98           N  
ATOM    118  CZ  ARG A  12      19.347  29.165  54.004  0.50 77.29           C  
ATOM    120  NH1 ARG A  12      20.236  29.579  54.899  0.50 77.41           N  
ATOM    122  NH2 ARG A  12      18.230  29.869  53.835  0.50 76.56           N  
ATOM    124  N   LEU A  13      23.022  24.172  51.511  1.00 80.28           N  
ATOM    125  CA  LEU A  13      23.763  22.906  51.589  1.00 80.74           C  
ATOM    126  C   LEU A  13      23.010  22.043  52.581  1.00 81.22           C  
ATOM    127  O   LEU A  13      22.810  22.460  53.719  1.00 81.48           O  
ATOM    128  CB  LEU A  13      25.195  23.092  52.094  1.00 80.63           C  
ATOM    129  CG  LEU A  13      26.318  23.172  51.065  1.00 80.38           C  
ATOM    130  CD1 LEU A  13      26.422  24.583  50.506  1.00 79.78           C  
ATOM    131  CD2 LEU A  13      27.655  22.729  51.688  1.00 80.79           C  
ATOM    132  N   VAL A  14      22.586  20.853  52.161  1.00 81.70           N  
ATOM    133  CA  VAL A  14      21.797  19.972  53.038  1.00 81.84           C  
ATOM    134  C   VAL A  14      22.667  18.988  53.793  1.00 81.95           C  
ATOM    135  O   VAL A  14      22.200  18.351  54.725  1.00 82.08           O  
ATOM    136  CB  VAL A  14      20.684  19.207  52.288  1.00 81.95           C  
ATOM    137  CG1 VAL A  14      19.520  20.137  52.016  1.00 81.85           C  
ATOM    138  CG2 VAL A  14      21.207  18.579  50.996  1.00 82.29           C  
ATOM    139  N   ARG A  15      23.920  18.850  53.371  1.00 82.12           N  
ATOM    140  CA  ARG A  15      24.961  18.289  54.226  1.00 82.25           C  
ATOM    141  C   ARG A  15      26.344  18.823  53.861  1.00 81.92           C  
ATOM    142  O   ARG A  15      26.545  19.433  52.800  1.00 81.33           O  
ATOM    143  CB  ARG A  15      24.942  16.747  54.251  1.00 82.35           C  
ATOM    144  CG  ARG A  15      24.531  16.040  52.960  1.00 82.91           C  
ATOM    145  CD  ARG A  15      24.154  14.580  53.257  1.00 83.37           C  
ATOM    146  NE  ARG A  15      23.128  14.065  52.350  1.00 83.81           N  
ATOM    147  CZ  ARG A  15      22.480  12.909  52.513  1.00 84.99           C  
ATOM    148  NH1 ARG A  15      22.722  12.110  53.558  1.00 83.76           N  
ATOM    149  NH2 ARG A  15      21.564  12.548  51.619  1.00 85.95           N  
ATOM    150  N   ASP A  16      27.281  18.577  54.775  1.00 81.69           N  
ATOM    151  CA  ASP A  16      28.636  19.103  54.699  1.00 81.52           C  
ATOM    152  C   ASP A  16      29.373  18.561  53.482  1.00 81.51           C  
ATOM    153  O   ASP A  16      29.103  17.446  53.029  1.00 80.82           O  
ATOM    154  CB  ASP A  16      29.409  18.770  55.984  1.00 81.64           C  
ATOM    155  CG  ASP A  16      28.778  19.390  57.223  1.00 81.59           C  
ATOM    156  OD1 ASP A  16      28.248  20.520  57.116  1.00 81.77           O  
ATOM    157  OD2 ASP A  16      28.801  18.751  58.295  1.00 80.28           O  
ATOM    158  N   PRO A  17      30.282  19.372  52.923  1.00 81.90           N  
ATOM    159  CA  PRO A  17      31.012  18.957  51.738  1.00 82.42           C  
ATOM    160  C   PRO A  17      31.981  17.799  51.992  1.00 83.25           C  
ATOM    161  O   PRO A  17      32.503  17.645  53.101  1.00 83.40           O  
ATOM    162  CB  PRO A  17      31.759  20.223  51.325  1.00 82.37           C  
ATOM    163  CG  PRO A  17      31.827  21.052  52.534  1.00 82.07           C  
ATOM    164  CD  PRO A  17      30.644  20.732  53.356  1.00 81.70           C  
ATOM    165  N   GLU A  18      32.191  16.982  50.965  1.00 84.21           N  
ATOM    166  CA  GLU A  18      33.131  15.873  51.030  1.00 85.14           C  
ATOM    167  C   GLU A  18      34.372  16.231  50.227  1.00 86.23           C  
ATOM    168  O   GLU A  18      34.285  16.379  49.005  1.00 86.33           O  
ATOM    169  CB  GLU A  18      32.502  14.602  50.459  1.00 84.98           C  
ATOM    170  CG  GLU A  18      31.428  14.001  51.345  1.00 84.89           C  
ATOM    171  CD  GLU A  18      30.870  12.706  50.789  1.00 84.99           C  
ATOM    172  OE1 GLU A  18      30.519  12.664  49.587  1.00 84.23           O  
ATOM    173  OE2 GLU A  18      30.789  11.723  51.555  1.00 86.30           O  
ATOM    174  N   GLU A  19      35.505  16.397  50.914  1.00 87.23           N  
ATOM    175  CA  GLU A  19      36.804  16.561  50.250  1.00 88.02           C  
ATOM    176  C   GLU A  19      37.345  15.190  49.895  1.00 88.61           C  
ATOM    177  O   GLU A  19      37.282  14.245  50.680  1.00 88.88           O  
ATOM    178  CB  GLU A  19      37.822  17.300  51.126  1.00 88.04           C  
ATOM    179  CG  GLU A  19      39.214  17.555  50.490  1.00 87.86           C  
ATOM    180  CD  GLU A  19      39.240  18.688  49.456  1.00 87.53           C  
ATOM    181  OE1 GLU A  19      38.476  18.634  48.473  1.00 87.99           O  
ATOM    182  OE2 GLU A  19      40.053  19.626  49.615  1.00 87.66           O  
ATOM    183  N   ARG A  20      37.942  15.134  48.718  1.00 89.32           N  
ATOM    184  CA  ARG A  20      38.008  13.928  47.937  1.00 89.84           C  
ATOM    185  C   ARG A  20      39.059  14.269  46.873  1.00 90.11           C  
ATOM    186  O   ARG A  20      38.752  14.757  45.799  1.00 90.69           O  
ATOM    187  CB  ARG A  20      36.560  13.626  47.443  1.00 89.91           C  
ATOM    188  CG  ARG A  20      36.306  13.109  46.028  1.00 90.74           C  
ATOM    189  CD  ARG A  20      36.322  11.595  45.938  1.00 92.10           C  
ATOM    190  NE  ARG A  20      36.433  11.181  44.537  1.00 93.16           N  
ATOM    191  CZ  ARG A  20      36.798   9.976  44.106  1.00 92.58           C  
ATOM    192  NH1 ARG A  20      37.106   9.014  44.956  1.00 93.18           N  
ATOM    193  NH2 ARG A  20      36.872   9.741  42.802  1.00 92.98           N  
ATOM    194  N   TYR A  21      40.322  14.071  47.229  1.00 90.72           N  
ATOM    195  CA  TYR A  21      41.447  14.446  46.374  1.00 90.91           C  
ATOM    196  C   TYR A  21      41.687  13.423  45.270  1.00 90.82           C  
ATOM    197  O   TYR A  21      41.901  12.246  45.571  1.00 90.56           O  
ATOM    198  CB  TYR A  21      42.737  14.514  47.196  1.00 91.35           C  
ATOM    199  CG  TYR A  21      42.741  15.492  48.344  1.00 91.85           C  
ATOM    200  CD1 TYR A  21      42.782  16.860  48.115  1.00 92.34           C  
ATOM    201  CD2 TYR A  21      42.754  15.046  49.664  1.00 92.78           C  
ATOM    202  CE1 TYR A  21      42.801  17.761  49.164  1.00 92.61           C  
ATOM    203  CE2 TYR A  21      42.782  15.936  50.721  1.00 92.93           C  
ATOM    204  CZ  TYR A  21      42.800  17.292  50.465  1.00 92.81           C  
ATOM    205  OH  TYR A  21      42.824  18.181  51.510  1.00 92.98           O  
ATOM    206  N   THR A  22      41.697  13.856  44.005  1.00 90.56           N  
ATOM    207  CA  THR A  22      42.119  12.956  42.917  1.00 90.66           C  
ATOM    208  C   THR A  22      43.637  12.778  42.866  1.00 90.89           C  
ATOM    209  O   THR A  22      44.359  13.061  43.828  1.00 90.84           O  
ATOM    210  CB  THR A  22      41.731  13.453  41.497  1.00 90.48           C  
ATOM    211  OG1 THR A  22      42.715  14.391  41.033  1.00 90.38           O  
ATOM    212  CG2 THR A  22      40.363  14.050  41.446  1.00 89.78           C  
ATOM    213  N   LEU A  23      44.068  12.210  41.739  1.00 91.20           N  
ATOM    214  CA  LEU A  23      45.349  12.493  41.065  1.00 91.21           C  
ATOM    215  C   LEU A  23      46.148  13.685  41.615  1.00 91.04           C  
ATOM    216  O   LEU A  23      46.567  13.711  42.803  1.00 90.93           O  
ATOM    217  CB  LEU A  23      45.054  12.794  39.577  1.00 91.49           C  
ATOM    218  CG  LEU A  23      43.903  12.087  38.832  1.00 91.37           C  
ATOM    219  CD1 LEU A  23      43.709  12.694  37.456  1.00 91.12           C  
ATOM    220  CD2 LEU A  23      44.153  10.585  38.726  1.00 92.15           C  
ATOM    221  N   THR A  26      43.851  18.281  41.649  1.00 84.27           N  
ATOM    222  CA  THR A  26      43.833  17.285  42.720  1.00 84.06           C  
ATOM    223  C   THR A  26      42.543  17.400  43.549  1.00 83.69           C  
ATOM    224  O   THR A  26      41.754  16.458  43.586  1.00 83.99           O  
ATOM    225  CB  THR A  26      45.100  17.377  43.633  1.00 84.11           C  
ATOM    226  OG1 THR A  26      46.256  16.925  42.914  1.00 85.02           O  
ATOM    227  CG2 THR A  26      44.949  16.530  44.903  1.00 84.23           C  
ATOM    228  N   PRO A  27      42.311  18.555  44.203  1.00 83.02           N  
ATOM    229  CA  PRO A  27      41.240  18.572  45.193  1.00 82.50           C  
ATOM    230  C   PRO A  27      39.840  18.600  44.579  1.00 82.02           C  
ATOM    231  O   PRO A  27      39.553  19.413  43.700  1.00 82.38           O  
ATOM    232  CB  PRO A  27      41.527  19.847  46.005  1.00 82.44           C  
ATOM    233  CG  PRO A  27      42.886  20.341  45.525  1.00 82.79           C  
ATOM    234  CD  PRO A  27      42.965  19.869  44.119  1.00 83.09           C  
ATOM    235  N   VAL A  28      38.983  17.694  45.040  1.00 81.29           N  
ATOM    236  CA  VAL A  28      37.594  17.633  44.603  1.00 80.50           C  
ATOM    237  C   VAL A  28      36.715  17.627  45.832  1.00 79.73           C  
ATOM    238  O   VAL A  28      36.908  16.835  46.745  1.00 79.84           O  
ATOM    239  CB  VAL A  28      37.298  16.364  43.780  1.00 80.57           C  
ATOM    240  CG1 VAL A  28      36.054  16.533  42.968  1.00 80.04           C  
ATOM    241  CG2 VAL A  28      38.466  16.044  42.881  1.00 80.99           C  
ATOM    242  N   THR A  29      35.754  18.530  45.845  1.00 79.03           N  
ATOM    243  CA  THR A  29      34.808  18.647  46.922  1.00 78.47           C  
ATOM    244  C   THR A  29      33.415  18.586  46.288  1.00 78.36           C  
ATOM    245  O   THR A  29      33.152  19.209  45.272  1.00 77.53           O  
ATOM    246  CB  THR A  29      35.036  19.945  47.710  1.00 78.39           C  
ATOM    247  OG1 THR A  29      36.394  19.980  48.180  1.00 78.92           O  
ATOM    248  CG2 THR A  29      34.096  20.039  48.888  1.00 77.84           C  
ATOM    249  N   THR A  30      32.562  17.754  46.865  1.00 78.22           N  
ATOM    250  CA  THR A  30      31.225  17.606  46.409  1.00 78.15           C  
ATOM    251  C   THR A  30      30.312  17.977  47.555  1.00 78.32           C  
ATOM    252  O   THR A  30      30.697  17.906  48.726  1.00 77.47           O  
ATOM    253  CB  THR A  30      30.921  16.177  45.916  1.00 78.22           C  
ATOM    254  OG1 THR A  30      31.017  15.238  47.002  1.00 78.30           O  
ATOM    255  CG2 THR A  30      31.875  15.791  44.795  1.00 78.47           C  
ATOM    256  N   PHE A  31      29.118  18.428  47.181  1.00 78.55           N  
ATOM    257  CA  PHE A  31      28.041  18.693  48.113  1.00 78.79           C  
ATOM    258  C   PHE A  31      26.756  18.823  47.313  1.00 78.79           C  
ATOM    259  O   PHE A  31      26.782  19.062  46.120  1.00 78.62           O  
ATOM    260  CB  PHE A  31      28.300  19.951  48.950  1.00 78.89           C  
ATOM    261  CG  PHE A  31      28.557  21.185  48.151  1.00 78.43           C  
ATOM    262  CD1 PHE A  31      29.824  21.460  47.665  1.00 78.87           C  
ATOM    263  CD2 PHE A  31      27.544  22.105  47.927  1.00 79.36           C  
ATOM    264  CE1 PHE A  31      30.082  22.627  46.943  1.00 79.26           C  
ATOM    265  CE2 PHE A  31      27.783  23.282  47.197  1.00 79.13           C  
ATOM    266  CZ  PHE A  31      29.059  23.539  46.706  1.00 79.07           C  
ATOM    267  N   THR A  32      25.639  18.605  47.982  1.00 79.41           N  
ATOM    268  CA  THR A  32      24.350  18.634  47.349  1.00 79.62           C  
ATOM    269  C   THR A  32      23.607  19.762  48.012  1.00 80.26           C  
ATOM    270  O   THR A  32      23.686  19.944  49.234  1.00 79.30           O  
ATOM    271  CB  THR A  32      23.567  17.293  47.484  1.00 80.14           C  
ATOM    272  OG1 THR A  32      22.738  17.314  48.654  1.00 80.80           O  
ATOM    273  CG2 THR A  32      24.528  16.070  47.528  1.00 78.89           C  
ATOM    274  N   ILE A  33      22.917  20.543  47.182  1.00 81.33           N  
ATOM    275  CA  ILE A  33      22.137  21.666  47.660  1.00 81.98           C  
ATOM    276  C   ILE A  33      20.647  21.376  47.505  1.00 82.39           C  
ATOM    277  O   ILE A  33      20.236  20.583  46.645  1.00 82.57           O  
ATOM    278  CB  ILE A  33      22.538  22.989  46.961  1.00 82.15           C  
ATOM    279  CG1 ILE A  33      22.484  22.851  45.433  1.00 81.76           C  
ATOM    280  CG2 ILE A  33      23.941  23.413  47.429  1.00 82.79           C  
ATOM    281  CD1 ILE A  33      22.690  24.152  44.703  1.00 82.51           C  
ATOM    282  N   ALA A  34      19.848  21.992  48.370  1.00 82.61           N  
ATOM    283  CA  ALA A  34      18.405  21.894  48.281  1.00 82.69           C  
ATOM    284  C   ALA A  34      17.955  23.174  47.634  1.00 82.85           C  
ATOM    285  O   ALA A  34      18.178  24.245  48.194  1.00 83.04           O  
ATOM    286  CB  ALA A  34      17.783  21.749  49.655  1.00 82.76           C  
ATOM    287  N   VAL A  35      17.353  23.061  46.450  1.00 82.91           N  
ATOM    288  CA  VAL A  35      16.832  24.212  45.710  1.00 82.90           C  
ATOM    289  C   VAL A  35      15.326  24.060  45.602  1.00 83.07           C  
ATOM    290  O   VAL A  35      14.809  23.469  44.643  1.00 82.76           O  
ATOM    291  CB  VAL A  35      17.437  24.289  44.281  1.00 82.99           C  
ATOM    292  CG1 VAL A  35      16.823  25.462  43.471  1.00 82.08           C  
ATOM    293  CG2 VAL A  35      18.980  24.384  44.336  1.00 82.99           C  
ATOM    294  N   ASP A  36      14.600  24.567  46.589  1.00 83.43           N  
ATOM    295  CA  ASP A  36      13.163  24.338  46.556  1.00 84.06           C  
ATOM    296  C   ASP A  36      12.452  25.312  45.615  1.00 84.15           C  
ATOM    297  O   ASP A  36      12.912  26.424  45.372  1.00 83.53           O  
ATOM    298  CB  ASP A  36      12.501  24.193  47.967  1.00 84.37           C  
ATOM    299  CG  ASP A  36      12.766  25.371  48.902  1.00 84.81           C  
ATOM    300  OD1 ASP A  36      13.190  26.447  48.413  1.00 84.84           O  
ATOM    301  OD2 ASP A  36      12.533  25.201  50.130  1.00 82.74           O  
ATOM    302  N   ARG A  37      11.337  24.832  45.067  1.00 84.70           N  
ATOM    303  CA  ARG A  37      10.583  25.534  44.044  1.00 85.14           C  
ATOM    304  C   ARG A  37       9.672  26.559  44.717  1.00 85.04           C  
ATOM    305  O   ARG A  37       8.471  26.342  44.876  1.00 85.22           O  
ATOM    306  CB  ARG A  37       9.773  24.534  43.204  1.00 85.13           C  
ATOM    307  CG  ARG A  37      10.594  23.357  42.651  1.00 85.44           C  
ATOM    308  CD  ARG A  37       9.688  22.287  42.071  1.00 86.15           C  
ATOM    309  NE  ARG A  37      10.416  21.111  41.592  1.00 86.95           N  
ATOM    310  CZ  ARG A  37       9.837  20.068  40.997  1.00 87.52           C  
ATOM    311  NH1 ARG A  37       8.519  20.019  40.829  1.00 88.65           N  
ATOM    312  NH2 ARG A  37      10.573  19.047  40.583  1.00 88.08           N  
ATOM    313  N   THR A  49       7.734  21.361  46.492  1.00 80.40           N  
ATOM    314  CA  THR A  49       8.700  20.272  46.481  1.00 80.02           C  
ATOM    315  C   THR A  49      10.082  20.818  46.093  1.00 79.95           C  
ATOM    316  O   THR A  49      10.189  21.860  45.441  1.00 80.20           O  
ATOM    317  CB  THR A  49       8.245  19.115  45.536  1.00 80.08           C  
ATOM    318  OG1 THR A  49       9.181  18.030  45.598  1.00 79.48           O  
ATOM    319  CG2 THR A  49       8.099  19.603  44.084  1.00 79.72           C  
ATOM    320  N   THR A  50      11.127  20.110  46.523  1.00 79.39           N  
ATOM    321  CA  THR A  50      12.504  20.535  46.349  1.00 78.86           C  
ATOM    322  C   THR A  50      13.163  19.748  45.236  1.00 78.37           C  
ATOM    323  O   THR A  50      12.763  18.624  44.924  1.00 78.21           O  
ATOM    324  CB  THR A  50      13.336  20.339  47.644  1.00 78.78           C  
ATOM    325  OG1 THR A  50      12.678  20.977  48.739  1.00 79.54           O  
ATOM    326  CG2 THR A  50      14.712  20.950  47.518  1.00 79.29           C  
ATOM    327  N   ASP A  51      14.164  20.381  44.629  1.00 78.13           N  
ATOM    328  CA  ASP A  51      15.089  19.734  43.722  1.00 77.96           C  
ATOM    329  C   ASP A  51      16.452  19.681  44.377  1.00 77.96           C  
ATOM    330  O   ASP A  51      16.964  20.703  44.849  1.00 78.05           O  
ATOM    331  CB  ASP A  51      15.194  20.520  42.427  1.00 78.07           C  
ATOM    332  CG  ASP A  51      13.988  20.364  41.570  1.00 77.49           C  
ATOM    333  OD1 ASP A  51      13.690  19.214  41.201  1.00 75.89           O  
ATOM    334  OD2 ASP A  51      13.340  21.382  41.262  1.00 77.21           O  
ATOM    335  N   PHE A  52      17.039  18.490  44.394  1.00 77.98           N  
ATOM    336  CA  PHE A  52      18.368  18.285  44.957  1.00 77.91           C  
ATOM    337  C   PHE A  52      19.392  18.129  43.843  1.00 77.77           C  
ATOM    338  O   PHE A  52      19.152  17.437  42.849  1.00 76.72           O  
ATOM    339  CB  PHE A  52      18.370  17.067  45.879  1.00 78.15           C  
ATOM    340  CG  PHE A  52      17.595  17.282  47.145  1.00 78.49           C  
ATOM    341  CD1 PHE A  52      18.214  17.831  48.262  1.00 79.00           C  
ATOM    342  CD2 PHE A  52      16.249  16.965  47.219  1.00 77.88           C  
ATOM    343  CE1 PHE A  52      17.505  18.047  49.433  1.00 78.93           C  
ATOM    344  CE2 PHE A  52      15.532  17.181  48.397  1.00 78.34           C  
ATOM    345  CZ  PHE A  52      16.160  17.720  49.503  1.00 78.38           C  
ATOM    346  N   PHE A  53      20.531  18.789  44.021  1.00 77.96           N  
ATOM    347  CA  PHE A  53      21.590  18.794  43.027  1.00 79.08           C  
ATOM    348  C   PHE A  53      22.940  18.433  43.648  1.00 79.11           C  
ATOM    349  O   PHE A  53      23.382  19.089  44.586  1.00 79.25           O  
ATOM    350  CB  PHE A  53      21.695  20.195  42.396  1.00 79.59           C  
ATOM    351  CG  PHE A  53      20.439  20.633  41.674  1.00 80.57           C  
ATOM    352  CD1 PHE A  53      19.450  21.322  42.340  1.00 80.38           C  
ATOM    353  CD2 PHE A  53      20.270  20.365  40.329  1.00 81.22           C  
ATOM    354  CE1 PHE A  53      18.323  21.707  41.696  1.00 82.41           C  
ATOM    355  CE2 PHE A  53      19.148  20.765  39.675  1.00 81.66           C  
ATOM    356  CZ  PHE A  53      18.162  21.422  40.356  1.00 82.12           C  
ATOM    357  N   ARG A  54      23.596  17.413  43.112  1.00 79.29           N  
ATOM    358  CA  ARG A  54      25.005  17.144  43.442  1.00 79.11           C  
ATOM    359  C   ARG A  54      25.904  18.214  42.810  1.00 79.05           C  
ATOM    360  O   ARG A  54      25.950  18.308  41.587  1.00 79.17           O  
ATOM    361  CB  ARG A  54      25.414  15.756  42.926  1.00 78.99           C  
ATOM    362  CG  ARG A  54      26.850  15.354  43.280  1.00 79.44           C  
ATOM    363  CD  ARG A  54      27.075  13.857  43.136  1.00 79.22           C  
ATOM    364  N   ILE A  55      26.577  19.030  43.636  1.00 79.07           N  
ATOM    365  CA  ILE A  55      27.585  20.009  43.173  1.00 78.74           C  
ATOM    366  C   ILE A  55      29.023  19.436  43.281  1.00 78.53           C  
ATOM    367  O   ILE A  55      29.427  18.930  44.324  1.00 77.74           O  
ATOM    368  CB  ILE A  55      27.547  21.344  43.999  1.00 79.19           C  
ATOM    369  CG1 ILE A  55      26.120  21.892  44.207  1.00 78.71           C  
ATOM    370  CG2 ILE A  55      28.434  22.414  43.362  1.00 78.89           C  
ATOM    371  CD1 ILE A  55      25.308  22.006  42.974  1.00 78.31           C  
ATOM    372  N   VAL A  56      29.782  19.545  42.191  1.00 78.13           N  
ATOM    373  CA  VAL A  56      31.187  19.183  42.151  1.00 77.64           C  
ATOM    374  C   VAL A  56      32.051  20.435  41.957  1.00 77.34           C  
ATOM    375  O   VAL A  56      31.750  21.257  41.107  1.00 77.37           O  
ATOM    376  CB  VAL A  56      31.497  18.205  40.989  1.00 77.44           C  
ATOM    377  CG1 VAL A  56      32.827  17.493  41.230  1.00 78.05           C  
ATOM    378  CG2 VAL A  56      30.407  17.191  40.855  1.00 78.11           C  
ATOM    379  N   THR A  57      33.128  20.544  42.736  1.00 77.04           N  
ATOM    380  CA  THR A  57      34.130  21.600  42.613  1.00 77.03           C  
ATOM    381  C   THR A  57      35.543  20.992  42.486  1.00 77.02           C  
ATOM    382  O   THR A  57      35.806  19.914  42.997  1.00 76.06           O  
ATOM    383  CB  THR A  57      34.096  22.513  43.842  1.00 76.84           C  
ATOM    384  OG1 THR A  57      34.252  21.720  45.014  1.00 77.80           O  
ATOM    385  CG2 THR A  57      32.777  23.240  43.934  1.00 77.77           C  
ATOM    386  N   PHE A  58      36.433  21.698  41.787  1.00 77.26           N  
ATOM    387  CA  PHE A  58      37.812  21.252  41.540  1.00 77.22           C  
ATOM    388  C   PHE A  58      38.805  22.362  41.869  1.00 77.42           C  
ATOM    389  O   PHE A  58      38.465  23.544  41.798  1.00 77.78           O  
ATOM    390  CB  PHE A  58      37.979  20.841  40.079  1.00 77.03           C  
ATOM    391  CG  PHE A  58      37.185  19.634  39.711  1.00 77.43           C  
ATOM    392  CD1 PHE A  58      35.864  19.744  39.329  1.00 77.43           C  
ATOM    393  CD2 PHE A  58      37.759  18.366  39.766  1.00 78.82           C  
ATOM    394  CE1 PHE A  58      35.125  18.620  39.001  1.00 77.56           C  
ATOM    395  CE2 PHE A  58      37.018  17.237  39.432  1.00 79.03           C  
ATOM    396  CZ  PHE A  58      35.692  17.369  39.050  1.00 76.67           C  
ATOM    397  N   GLY A  59      40.027  21.983  42.233  1.00 77.70           N  
ATOM    398  CA  GLY A  59      41.098  22.950  42.493  1.00 77.86           C  
ATOM    399  C   GLY A  59      40.787  23.871  43.659  1.00 78.15           C  
ATOM    400  O   GLY A  59      40.215  23.438  44.658  1.00 78.22           O  
ATOM    401  N   ARG A  60      41.143  25.147  43.521  1.00 78.42           N  
ATOM    402  CA  ARG A  60      40.973  26.132  44.603  1.00 78.66           C  
ATOM    403  C   ARG A  60      39.527  26.273  45.072  1.00 78.82           C  
ATOM    404  O   ARG A  60      39.269  26.594  46.233  1.00 79.08           O  
ATOM    405  CB  ARG A  60      41.492  27.503  44.166  1.00 78.67           C  
ATOM    406  N   LEU A  61      38.590  26.046  44.159  1.00 78.88           N  
ATOM    407  CA  LEU A  61      37.168  26.097  44.477  1.00 78.60           C  
ATOM    408  C   LEU A  61      36.746  24.919  45.352  1.00 78.95           C  
ATOM    409  O   LEU A  61      35.985  25.098  46.305  1.00 78.81           O  
ATOM    410  CB  LEU A  61      36.359  26.105  43.189  1.00 78.65           C  
ATOM    411  CG  LEU A  61      34.925  26.599  43.305  1.00 78.10           C  
ATOM    412  CD1 LEU A  61      34.893  28.029  43.809  1.00 77.36           C  
ATOM    413  CD2 LEU A  61      34.274  26.474  41.958  1.00 78.11           C  
ATOM    414  N   ALA A  62      37.231  23.720  45.010  1.00 79.16           N  
ATOM    415  CA  ALA A  62      37.149  22.547  45.904  1.00 79.36           C  
ATOM    416  C   ALA A  62      37.740  22.893  47.252  1.00 79.78           C  
ATOM    417  O   ALA A  62      37.119  22.649  48.277  1.00 79.90           O  
ATOM    418  CB  ALA A  62      37.871  21.345  45.312  1.00 78.91           C  
ATOM    419  N   GLU A  63      38.935  23.483  47.234  1.00 80.39           N  
ATOM    420  CA  GLU A  63      39.610  23.900  48.461  1.00 81.02           C  
ATOM    421  C   GLU A  63      38.760  24.910  49.224  1.00 81.00           C  
ATOM    422  O   GLU A  63      38.531  24.750  50.426  1.00 81.29           O  
ATOM    423  CB  GLU A  63      40.990  24.507  48.171  1.00 81.07           C  
ATOM    424  CG  GLU A  63      41.991  23.550  47.552  1.00 81.71           C  
ATOM    425  CD  GLU A  63      43.321  24.212  47.262  1.00 81.83           C  
ATOM    426  OE1 GLU A  63      43.978  24.666  48.227  1.00 83.26           O  
ATOM    427  OE2 GLU A  63      43.713  24.271  46.073  1.00 83.24           O  
ATOM    428  N   PHE A  64      38.301  25.949  48.528  1.00 80.88           N  
ATOM    429  CA  PHE A  64      37.408  26.937  49.134  1.00 80.81           C  
ATOM    430  C   PHE A  64      36.158  26.261  49.690  1.00 80.46           C  
ATOM    431  O   PHE A  64      35.712  26.579  50.791  1.00 80.08           O  
ATOM    432  CB  PHE A  64      37.010  28.031  48.133  1.00 80.90           C  
ATOM    433  CG  PHE A  64      35.712  28.723  48.480  1.00 81.30           C  
ATOM    434  CD1 PHE A  64      34.508  28.268  47.959  1.00 81.03           C  
ATOM    435  CD2 PHE A  64      35.694  29.803  49.350  1.00 81.81           C  
ATOM    436  CE1 PHE A  64      33.314  28.875  48.303  1.00 81.62           C  
ATOM    437  CE2 PHE A  64      34.500  30.429  49.686  1.00 81.05           C  
ATOM    438  CZ  PHE A  64      33.311  29.964  49.164  1.00 81.51           C  
ATOM    439  N   ALA A  65      35.604  25.321  48.925  1.00 80.44           N  
ATOM    440  CA  ALA A  65      34.340  24.684  49.293  1.00 80.47           C  
ATOM    441  C   ALA A  65      34.476  23.984  50.625  1.00 79.85           C  
ATOM    442  O   ALA A  65      33.824  24.345  51.597  1.00 79.46           O  
ATOM    443  CB  ALA A  65      33.874  23.698  48.217  1.00 80.79           C  
ATOM    444  N   ARG A  66      35.362  23.003  50.661  1.00 79.85           N  
ATOM    445  CA  ARG A  66      35.631  22.228  51.878  1.00 79.73           C  
ATOM    446  C   ARG A  66      36.001  23.058  53.119  1.00 78.96           C  
ATOM    447  O   ARG A  66      35.454  22.817  54.193  1.00 78.27           O  
ATOM    448  CB  ARG A  66      36.708  21.198  51.604  1.00 79.57           C  
ATOM    449  CG  ARG A  66      37.108  20.429  52.831  1.00 82.12           C  
ATOM    450  CD  ARG A  66      35.985  19.496  53.338  1.00 83.95           C  
ATOM    451  NE  ARG A  66      36.213  19.016  54.706  1.00 83.11           N  
ATOM    452  CZ  ARG A  66      37.256  18.301  55.106  1.00 84.16           C  
ATOM    453  NH1 ARG A  66      38.232  17.972  54.269  1.00 85.06           N  
ATOM    454  NH2 ARG A  66      37.337  17.914  56.373  1.00 84.84           N  
ATOM    455  N   THR A  67      36.889  24.039  52.979  1.00 78.81           N  
ATOM    456  CA  THR A  67      37.330  24.810  54.155  1.00 79.21           C  
ATOM    457  C   THR A  67      36.364  25.929  54.579  1.00 79.35           C  
ATOM    458  O   THR A  67      36.548  26.521  55.642  1.00 79.59           O  
ATOM    459  CB  THR A  67      38.802  25.374  54.037  1.00 78.98           C  
ATOM    460  OG1 THR A  67      38.840  26.587  53.284  1.00 78.46           O  
ATOM    461  CG2 THR A  67      39.752  24.358  53.413  1.00 79.42           C  
ATOM    462  N   TYR A  68      35.345  26.219  53.770  1.00 79.71           N  
ATOM    463  CA  TYR A  68      34.377  27.276  54.111  1.00 79.80           C  
ATOM    464  C   TYR A  68      32.900  26.860  54.127  1.00 79.85           C  
ATOM    465  O   TYR A  68      32.141  27.396  54.929  1.00 79.85           O  
ATOM    466  CB  TYR A  68      34.584  28.506  53.220  1.00 79.80           C  
ATOM    467  CG  TYR A  68      35.912  29.188  53.461  1.00 79.82           C  
ATOM    468  CD1 TYR A  68      36.077  30.071  54.519  1.00 79.78           C  
ATOM    469  CD2 TYR A  68      37.007  28.934  52.644  1.00 79.82           C  
ATOM    470  CE1 TYR A  68      37.291  30.692  54.750  1.00 79.68           C  
ATOM    471  CE2 TYR A  68      38.225  29.545  52.866  1.00 79.70           C  
ATOM    472  CZ  TYR A  68      38.368  30.423  53.920  1.00 80.07           C  
ATOM    473  OH  TYR A  68      39.595  31.024  54.139  1.00 79.95           O  
ATOM    474  N   LEU A  69      32.489  25.919  53.274  1.00 80.19           N  
ATOM    475  CA  LEU A  69      31.063  25.533  53.177  1.00 80.39           C  
ATOM    476  C   LEU A  69      30.637  24.529  54.257  1.00 80.58           C  
ATOM    477  O   LEU A  69      31.338  23.550  54.508  1.00 80.57           O  
ATOM    478  CB  LEU A  69      30.738  24.930  51.803  1.00 80.46           C  
ATOM    479  CG  LEU A  69      31.111  25.699  50.536  1.00 80.59           C  
ATOM    480  CD1 LEU A  69      30.475  25.037  49.314  1.00 80.41           C  
ATOM    481  CD2 LEU A  69      30.696  27.146  50.624  1.00 81.03           C  
ATOM    482  N   THR A  70      29.479  24.772  54.877  1.00 80.73           N  
ATOM    483  CA  THR A  70      28.888  23.832  55.846  1.00 80.71           C  
ATOM    484  C   THR A  70      27.376  23.709  55.623  1.00 80.88           C  
ATOM    485  O   THR A  70      26.772  24.561  54.984  1.00 81.11           O  
ATOM    486  CB  THR A  70      29.168  24.249  57.315  1.00 80.61           C  
ATOM    487  OG1 THR A  70      28.521  25.494  57.607  1.00 80.45           O  
ATOM    488  CG2 THR A  70      30.659  24.387  57.563  1.00 80.18           C  
ATOM    489  N   LYS A  71      26.772  22.648  56.154  1.00 81.08           N  
ATOM    490  CA  LYS A  71      25.335  22.392  55.996  1.00 81.08           C  
ATOM    491  C   LYS A  71      24.474  23.591  56.399  1.00 81.20           C  
ATOM    492  O   LYS A  71      24.853  24.384  57.263  1.00 81.09           O  
ATOM    493  CB  LYS A  71      24.914  21.164  56.813  1.00 81.01           C  
ATOM    494  N   GLY A  72      23.319  23.720  55.751  1.00 81.53           N  
ATOM    495  CA  GLY A  72      22.379  24.818  56.003  1.00 81.71           C  
ATOM    496  C   GLY A  72      22.695  26.085  55.227  1.00 81.85           C  
ATOM    497  O   GLY A  72      21.792  26.757  54.729  1.00 82.00           O  
ATOM    498  N   ARG A  73      23.983  26.411  55.150  1.00 81.94           N  
ATOM    499  CA  ARG A  73      24.490  27.594  54.455  1.00 81.97           C  
ATOM    500  C   ARG A  73      23.906  27.735  53.033  1.00 81.85           C  
ATOM    501  O   ARG A  73      23.825  26.752  52.300  1.00 81.93           O  
ATOM    502  CB  ARG A  73      26.025  27.496  54.413  1.00 82.04           C  
ATOM    503  CG  ARG A  73      26.745  28.674  53.805  1.00 82.39           C  
ATOM    504  CD  ARG A  73      26.920  29.809  54.779  1.00 82.58           C  
ATOM    505  NE  ARG A  73      28.012  29.567  55.714  1.00 82.75           N  
ATOM    506  CZ  ARG A  73      28.602  30.514  56.443  1.00 83.31           C  
ATOM    507  NH1 ARG A  73      28.210  31.784  56.356  1.00 83.46           N  
ATOM    508  NH2 ARG A  73      29.595  30.192  57.269  1.00 83.61           N  
ATOM    509  N   LEU A  74      23.506  28.957  52.668  1.00 81.73           N  
ATOM    510  CA  LEU A  74      22.868  29.257  51.370  1.00 81.63           C  
ATOM    511  C   LEU A  74      23.893  29.728  50.351  1.00 81.55           C  
ATOM    512  O   LEU A  74      24.536  30.759  50.545  1.00 81.62           O  
ATOM    513  CB  LEU A  74      21.813  30.358  51.536  1.00 81.62           C  
ATOM    514  CG  LEU A  74      21.050  30.847  50.292  1.00 81.64           C  
ATOM    515  CD1 LEU A  74      20.093  29.797  49.780  1.00 81.43           C  
ATOM    516  CD2 LEU A  74      20.289  32.121  50.601  1.00 81.46           C  
ATOM    517  N   VAL A  75      24.026  28.994  49.252  1.00 81.49           N  
ATOM    518  CA  VAL A  75      25.026  29.333  48.238  1.00 81.25           C  
ATOM    519  C   VAL A  75      24.438  29.550  46.834  1.00 81.07           C  
ATOM    520  O   VAL A  75      23.392  29.001  46.474  1.00 81.12           O  
ATOM    521  CB  VAL A  75      26.163  28.288  48.182  1.00 81.36           C  
ATOM    522  CG1 VAL A  75      26.948  28.300  49.491  1.00 81.77           C  
ATOM    523  CG2 VAL A  75      25.639  26.881  47.884  1.00 81.48           C  
ATOM    524  N   LEU A  76      25.113  30.401  46.069  1.00 80.37           N  
ATOM    525  CA  LEU A  76      24.895  30.496  44.649  1.00 79.62           C  
ATOM    526  C   LEU A  76      25.854  29.520  44.031  1.00 79.50           C  
ATOM    527  O   LEU A  76      27.012  29.455  44.430  1.00 79.82           O  
ATOM    528  CB  LEU A  76      25.198  31.901  44.127  1.00 79.62           C  
ATOM    529  CG  LEU A  76      24.913  32.023  42.625  1.00 79.43           C  
ATOM    530  CD1 LEU A  76      24.194  33.298  42.368  1.00 80.01           C  
ATOM    531  CD2 LEU A  76      26.152  31.886  41.716  1.00 78.46           C  
ATOM    532  N   VAL A  77      25.379  28.744  43.073  1.00 79.21           N  
ATOM    533  CA  VAL A  77      26.249  27.897  42.294  1.00 79.18           C  
ATOM    534  C   VAL A  77      26.069  28.188  40.816  1.00 78.52           C  
ATOM    535  O   VAL A  77      24.972  28.142  40.292  1.00 78.11           O  
ATOM    536  CB  VAL A  77      26.005  26.403  42.600  1.00 79.68           C  
ATOM    537  CG1 VAL A  77      26.686  25.514  41.572  1.00 80.60           C  
ATOM    538  CG2 VAL A  77      26.505  26.069  44.018  1.00 79.85           C  
ATOM    539  N   GLU A  78      27.176  28.471  40.158  1.00 78.34           N  
ATOM    540  CA  GLU A  78      27.201  28.623  38.736  1.00 78.58           C  
ATOM    541  C   GLU A  78      28.066  27.532  38.127  1.00 78.98           C  
ATOM    542  O   GLU A  78      29.183  27.294  38.555  1.00 78.50           O  
ATOM    543  CB  GLU A  78      27.785  29.970  38.378  1.00 79.25           C  
ATOM    544  CG  GLU A  78      27.521  30.294  36.970  1.00 80.69           C  
ATOM    545  CD  GLU A  78      28.259  31.434  36.530  1.00 83.60           C  
ATOM    546  OE1 GLU A  78      28.424  32.353  37.343  1.00 90.25           O  
ATOM    547  OE2 GLU A  78      28.673  31.449  35.361  1.00 87.79           O  
ATOM    548  N   GLY A  79      27.558  26.856  37.115  1.00 79.56           N  
ATOM    549  CA  GLY A  79      28.402  25.931  36.420  1.00 79.40           C  
ATOM    550  C   GLY A  79      27.722  25.251  35.272  1.00 79.71           C  
ATOM    551  O   GLY A  79      26.912  25.857  34.579  1.00 78.37           O  
ATOM    552  N   GLU A  80      28.083  23.979  35.062  1.00 80.21           N  
ATOM    553  CA  GLU A  80      27.523  23.221  33.965  1.00 80.92           C  
ATOM    554  C   GLU A  80      26.758  22.048  34.452  1.00 80.75           C  
ATOM    555  O   GLU A  80      27.076  21.464  35.474  1.00 81.61           O  
ATOM    556  CB  GLU A  80      28.605  22.794  33.014  1.00 81.27           C  
ATOM    557  CG  GLU A  80      29.042  23.892  32.128  1.00 83.29           C  
ATOM    558  CD  GLU A  80      30.150  23.458  31.206  1.00 89.19           C  
ATOM    559  OE1 GLU A  80      30.567  22.284  31.350  1.00 90.82           O  
ATOM    560  OE2 GLU A  80      30.616  24.286  30.366  1.00 91.52           O  
ATOM    561  N   MET A  81      25.700  21.723  33.738  1.00 81.79           N  
ATOM    562  CA  MET A  81      24.896  20.573  34.112  1.00 81.45           C  
ATOM    563  C   MET A  81      25.465  19.403  33.330  1.00 81.07           C  
ATOM    564  O   MET A  81      25.342  19.336  32.109  1.00 79.42           O  
ATOM    565  CB  MET A  81      23.419  20.832  33.824  1.00 81.68           C  
ATOM    566  CG  MET A  81      22.455  19.761  34.385  1.00 82.92           C  
ATOM    567  SD  MET A  81      22.570  19.505  36.172  1.00 86.62           S  
ATOM    568  CE  MET A  81      23.319  17.947  36.266  1.00 86.00           C  
ATOM    569  N   ARG A  82      26.164  18.526  34.047  1.00 82.04           N  
ATOM    570  CA  ARG A  82      26.658  17.269  33.467  1.00 82.81           C  
ATOM    571  C   ARG A  82      25.664  16.124  33.613  1.00 82.04           C  
ATOM    572  O   ARG A  82      25.129  15.864  34.688  1.00 81.31           O  
ATOM    573  CB  ARG A  82      28.007  16.849  34.061  1.00 83.87           C  
ATOM    574  CG  ARG A  82      29.193  17.762  33.731  1.00 86.29           C  
ATOM    575  CD  ARG A  82      29.115  18.404  32.342  1.00 89.90           C  
ATOM    576  NE  ARG A  82      30.415  18.966  31.926  1.00 91.48           N  
ATOM    577  CZ  ARG A  82      30.589  19.851  30.933  1.00 93.12           C  
ATOM    578  NH1 ARG A  82      29.549  20.326  30.234  1.00 94.03           N  
ATOM    579  NH2 ARG A  82      31.816  20.283  30.642  1.00 93.52           N  
ATOM    580  N   MET A  83      25.459  15.438  32.499  1.00 81.82           N  
ATOM    581  CA  MET A  83      24.548  14.312  32.390  1.00 82.00           C  
ATOM    582  C   MET A  83      25.377  13.050  32.183  1.00 81.39           C  
ATOM    583  O   MET A  83      25.409  12.480  31.093  1.00 80.33           O  
ATOM    584  CB  MET A  83      23.619  14.551  31.199  1.00 82.35           C  
ATOM    585  CG  MET A  83      22.675  15.707  31.404  1.00 83.21           C  
ATOM    586  SD  MET A  83      21.350  15.193  32.523  1.00 87.36           S  
ATOM    587  CE  MET A  83      21.861  16.069  33.976  1.00 85.63           C  
ATOM    588  N   ARG A  84      26.070  12.643  33.237  1.00 81.33           N  
ATOM    589  CA  ARG A  84      27.161  11.697  33.081  1.00 82.00           C  
ATOM    590  C   ARG A  84      26.625  10.273  33.130  1.00 81.40           C  
ATOM    591  O   ARG A  84      25.960   9.869  34.084  1.00 80.90           O  
ATOM    592  CB  ARG A  84      28.287  11.946  34.100  1.00 82.15           C  
ATOM    593  CG  ARG A  84      28.489  10.855  35.125  1.00 83.31           C  
ATOM    594  CD  ARG A  84      29.848  10.930  35.814  1.00 83.78           C  
ATOM    595  NE  ARG A  84      29.731  10.457  37.189  1.00 84.86           N  
ATOM    596  CZ  ARG A  84      29.494   9.199  37.540  1.00 87.57           C  
ATOM    597  NH1 ARG A  84      29.389   8.224  36.631  1.00 89.17           N  
ATOM    598  NH2 ARG A  84      29.396   8.897  38.829  1.00 89.05           N  
ATOM    599  N   ARG A  85      26.919   9.530  32.074  1.00 81.24           N  
ATOM    600  CA  ARG A  85      26.452   8.162  31.923  1.00 81.14           C  
ATOM    601  C   ARG A  85      27.542   7.228  32.428  1.00 80.96           C  
ATOM    602  O   ARG A  85      28.729   7.457  32.186  1.00 80.57           O  
ATOM    603  CB  ARG A  85      26.121   7.872  30.453  1.00 81.16           C  
ATOM    604  CG  ARG A  85      25.612   9.079  29.666  1.00 81.03           C  
ATOM    605  CD  ARG A  85      25.282   8.716  28.232  1.00 81.17           C  
ATOM    606  NE  ARG A  85      25.544   9.843  27.344  1.00 81.64           N  
ATOM    607  CZ  ARG A  85      26.724  10.133  26.796  1.00 81.77           C  
ATOM    608  NH1 ARG A  85      27.791   9.371  27.010  1.00 82.12           N  
ATOM    609  NH2 ARG A  85      26.837  11.200  26.016  1.00 81.81           N  
ATOM    610  N   LYS A  93      27.154   2.711  32.080  1.00 85.47           N  
ATOM    611  CA  LYS A  93      26.633   4.068  31.925  1.00 85.37           C  
ATOM    612  C   LYS A  93      25.160   4.147  32.344  1.00 85.42           C  
ATOM    613  O   LYS A  93      24.293   3.529  31.717  1.00 85.24           O  
ATOM    614  CB  LYS A  93      26.803   4.527  30.472  1.00 85.29           C  
ATOM    615  CG  LYS A  93      28.241   4.889  30.087  1.00 85.07           C  
ATOM    616  CD  LYS A  93      28.566   4.493  28.650  1.00 84.88           C  
ATOM    617  CE  LYS A  93      28.874   3.003  28.534  1.00 84.38           C  
ATOM    618  NZ  LYS A  93      28.872   2.557  27.120  1.00 84.34           N  
ATOM    619  N   ARG A  94      24.886   4.900  33.411  1.00 85.42           N  
ATOM    620  CA  ARG A  94      23.523   5.054  33.923  1.00 85.35           C  
ATOM    621  C   ARG A  94      23.398   6.484  34.415  1.00 84.98           C  
ATOM    622  O   ARG A  94      23.935   6.831  35.462  1.00 85.61           O  
ATOM    623  CB  ARG A  94      23.241   4.020  35.034  1.00 85.51           C  
ATOM    624  CG  ARG A  94      21.780   3.930  35.501  1.00 85.54           C  
ATOM    625  CD  ARG A  94      20.834   3.670  34.348  1.00 85.88           C  
ATOM    626  NE  ARG A  94      21.258   2.493  33.588  1.00 87.60           N  
ATOM    627  CZ  ARG A  94      20.889   2.207  32.339  1.00 87.65           C  
ATOM    628  NH1 ARG A  94      20.078   3.020  31.661  1.00 88.50           N  
ATOM    629  NH2 ARG A  94      21.351   1.105  31.758  1.00 85.96           N  
ATOM    630  N   VAL A  95      22.684   7.311  33.650  1.00 84.48           N  
ATOM    631  CA  VAL A  95      22.887   8.797  33.653  1.00 83.86           C  
ATOM    632  C   VAL A  95      22.788   9.525  35.016  1.00 83.61           C  
ATOM    633  O   VAL A  95      21.683   9.636  35.620  1.00 83.61           O  
ATOM    634  CB  VAL A  95      21.935   9.517  32.647  1.00 83.90           C  
ATOM    635  CG1 VAL A  95      22.237  11.017  32.583  1.00 83.52           C  
ATOM    636  CG2 VAL A  95      22.042   8.892  31.250  1.00 84.05           C  
ATOM    637  N   SER A  96      23.936  10.072  35.458  1.00 83.05           N  
ATOM    638  CA  SER A  96      24.038  10.741  36.759  1.00 82.94           C  
ATOM    639  C   SER A  96      24.277  12.258  36.636  1.00 82.46           C  
ATOM    640  O   SER A  96      25.324  12.672  36.122  1.00 81.54           O  
ATOM    641  CB  SER A  96      25.178  10.142  37.570  1.00 83.17           C  
ATOM    642  OG  SER A  96      25.473  10.980  38.677  1.00 85.11           O  
ATOM    643  N   PRO A  97      23.331  13.079  37.147  1.00 82.06           N  
ATOM    644  CA  PRO A  97      23.340  14.542  36.990  1.00 82.11           C  
ATOM    645  C   PRO A  97      24.176  15.241  38.047  1.00 81.58           C  
ATOM    646  O   PRO A  97      23.820  15.194  39.219  1.00 82.56           O  
ATOM    647  CB  PRO A  97      21.852  14.926  37.173  1.00 81.84           C  
ATOM    648  CG  PRO A  97      21.148  13.643  37.594  1.00 81.93           C  
ATOM    649  CD  PRO A  97      22.175  12.658  37.954  1.00 81.76           C  
ATOM    650  N   GLU A  98      25.273  15.875  37.647  1.00 80.80           N  
ATOM    651  CA  GLU A  98      26.063  16.698  38.574  1.00 80.40           C  
ATOM    652  C   GLU A  98      26.280  18.081  38.000  1.00 79.89           C  
ATOM    653  O   GLU A  98      26.420  18.218  36.785  1.00 80.28           O  
ATOM    654  CB  GLU A  98      27.468  16.148  38.772  1.00 80.24           C  
ATOM    655  CG  GLU A  98      27.594  14.705  39.099  1.00 80.66           C  
ATOM    656  CD  GLU A  98      28.927  14.166  38.648  1.00 80.08           C  
ATOM    657  OE1 GLU A  98      29.794  15.026  38.292  1.00 79.06           O  
ATOM    658  OE2 GLU A  98      29.086  12.922  38.635  1.00 72.56           O  
ATOM    659  N   VAL A  99      26.376  19.083  38.877  1.00 79.02           N  
ATOM    660  CA  VAL A  99      26.790  20.419  38.479  1.00 78.54           C  
ATOM    661  C   VAL A  99      28.284  20.573  38.715  1.00 78.43           C  
ATOM    662  O   VAL A  99      28.748  20.560  39.867  1.00 78.64           O  
ATOM    663  CB  VAL A  99      26.028  21.501  39.282  1.00 78.85           C  
ATOM    664  CG1 VAL A  99      26.372  22.859  38.804  1.00 79.55           C  
ATOM    665  CG2 VAL A  99      24.508  21.299  39.183  1.00 77.89           C  
ATOM    666  N   VAL A 100      29.050  20.704  37.632  1.00 77.49           N  
ATOM    667  CA  VAL A 100      30.449  21.093  37.750  1.00 76.29           C  
ATOM    668  C   VAL A 100      30.421  22.614  37.875  1.00 77.38           C  
ATOM    669  O   VAL A 100      30.139  23.341  36.904  1.00 77.31           O  
ATOM    670  CB  VAL A 100      31.292  20.619  36.545  1.00 75.82           C  
ATOM    671  CG1 VAL A 100      32.728  21.046  36.703  1.00 74.44           C  
ATOM    672  CG2 VAL A 100      31.198  19.058  36.388  1.00 74.07           C  
ATOM    673  N   ALA A 101      30.677  23.085  39.094  1.00 77.58           N  
ATOM    674  CA  ALA A 101      30.581  24.474  39.414  1.00 77.44           C  
ATOM    675  C   ALA A 101      31.829  25.185  38.973  1.00 78.59           C  
ATOM    676  O   ALA A 101      32.962  24.695  39.160  1.00 78.96           O  
ATOM    677  CB  ALA A 101      30.334  24.678  40.891  1.00 77.02           C  
ATOM    678  N   ASN A 102      31.636  26.356  38.371  1.00 79.31           N  
ATOM    679  CA  ASN A 102      32.758  27.249  38.160  1.00 80.05           C  
ATOM    680  C   ASN A 102      32.765  28.344  39.212  1.00 79.53           C  
ATOM    681  O   ASN A 102      33.760  28.968  39.401  1.00 79.91           O  
ATOM    682  CB  ASN A 102      32.795  27.781  36.718  1.00 80.61           C  
ATOM    683  CG  ASN A 102      31.545  28.520  36.307  1.00 84.35           C  
ATOM    684  OD1 ASN A 102      30.560  27.912  35.842  1.00 91.25           O  
ATOM    685  ND2 ASN A 102      31.590  29.860  36.385  1.00 89.05           N  
ATOM    686  N   VAL A 103      31.650  28.563  39.904  1.00 79.84           N  
ATOM    687  CA  VAL A 103      31.531  29.620  40.914  1.00 79.11           C  
ATOM    688  C   VAL A 103      30.684  29.110  42.079  1.00 79.11           C  
ATOM    689  O   VAL A 103      29.671  28.469  41.864  1.00 78.24           O  
ATOM    690  CB  VAL A 103      30.869  30.882  40.296  1.00 79.23           C  
ATOM    691  CG1 VAL A 103      30.391  31.870  41.370  1.00 80.01           C  
ATOM    692  CG2 VAL A 103      31.821  31.573  39.363  1.00 78.28           C  
ATOM    693  N   VAL A 104      31.127  29.361  43.307  1.00 79.40           N  
ATOM    694  CA  VAL A 104      30.285  29.184  44.495  1.00 79.56           C  
ATOM    695  C   VAL A 104      30.467  30.366  45.446  1.00 79.75           C  
ATOM    696  O   VAL A 104      31.556  30.560  46.003  1.00 79.76           O  
ATOM    697  CB  VAL A 104      30.595  27.893  45.278  1.00 79.88           C  
ATOM    698  CG1 VAL A 104      29.639  27.762  46.474  1.00 79.66           C  
ATOM    699  CG2 VAL A 104      30.503  26.669  44.383  1.00 80.01           C  
ATOM    700  N   ARG A 105      29.406  31.152  45.609  1.00 80.01           N  
ATOM    701  CA  ARG A 105      29.354  32.226  46.594  1.00 80.21           C  
ATOM    702  C   ARG A 105      28.359  31.949  47.710  1.00 80.91           C  
ATOM    703  O   ARG A 105      27.239  31.477  47.465  1.00 80.69           O  
ATOM    704  CB  ARG A 105      28.925  33.536  45.957  1.00 79.95           C  
ATOM    705  CG  ARG A 105      29.672  33.883  44.729  1.00 79.56           C  
ATOM    706  CD  ARG A 105      29.768  35.365  44.545  1.00 79.95           C  
ATOM    707  NE  ARG A 105      30.757  35.591  43.511  1.00 81.31           N  
ATOM    708  CZ  ARG A 105      30.524  35.509  42.209  1.00 82.33           C  
ATOM    709  NH1 ARG A 105      29.308  35.271  41.770  1.00 85.30           N  
ATOM    710  NH2 ARG A 105      31.505  35.691  41.335  1.00 81.72           N  
ATOM    711  N   PHE A 106      28.763  32.286  48.934  1.00 81.56           N  
ATOM    712  CA  PHE A 106      27.817  32.424  50.027  1.00 82.01           C  
ATOM    713  C   PHE A 106      26.819  33.502  49.655  1.00 82.24           C  
ATOM    714  O   PHE A 106      27.190  34.513  49.059  1.00 82.13           O  
ATOM    715  CB  PHE A 106      28.512  32.835  51.321  1.00 82.00           C  
ATOM    716  CG  PHE A 106      29.461  31.816  51.843  1.00 82.27           C  
ATOM    717  CD1 PHE A 106      29.034  30.522  52.096  1.00 82.52           C  
ATOM    718  CD2 PHE A 106      30.783  32.147  52.092  1.00 82.50           C  
ATOM    719  CE1 PHE A 106      29.909  29.579  52.584  1.00 82.55           C  
ATOM    720  CE2 PHE A 106      31.667  31.204  52.583  1.00 82.53           C  
ATOM    721  CZ  PHE A 106      31.228  29.919  52.827  1.00 82.45           C  
ATOM    722  N   MET A 107      25.556  33.270  49.998  1.00 82.74           N  
ATOM    723  CA  MET A 107      24.522  34.291  49.889  1.00 83.01           C  
ATOM    724  C   MET A 107      24.213  34.912  51.259  1.00 83.11           C  
ATOM    725  O   MET A 107      24.085  36.131  51.371  1.00 83.25           O  
ATOM    726  CB  MET A 107      23.259  33.701  49.255  1.00 83.28           C  
ATOM    727  CG  MET A 107      23.346  33.519  47.737  1.00 83.76           C  
ATOM    728  SD  MET A 107      23.848  35.009  46.829  1.00 86.10           S  
ATOM    729  CE  MET A 107      22.920  36.306  47.642  1.00 85.45           C  
ATOM    730  N   ASP A 108      24.120  34.079  52.294  1.00 83.20           N  
ATOM    731  CA  ASP A 108      23.796  34.550  53.651  1.00 83.32           C  
ATOM    732  C   ASP A 108      24.964  35.273  54.335  1.00 83.27           C  
ATOM    733  O   ASP A 108      26.080  34.758  54.415  1.00 83.15           O  
ATOM    734  CB  ASP A 108      23.286  33.394  54.529  1.00 83.39           C  
ATOM    735  CG  ASP A 108      24.133  32.137  54.406  1.00 83.80           C  
ATOM    736  OD1 ASP A 108      25.269  32.227  53.896  1.00 84.83           O  
ATOM    737  OD2 ASP A 108      23.654  31.053  54.810  1.00 84.12           O  
TER     738      ASP A 108                                                      
END
MOLECULE T0491.pdb
ATOM      1  CB  MET     1      24.494  26.786  25.043  1.00 74.26      A   
ATOM      2  CG  MET     1      23.701  27.585  26.072  1.00 83.32      A   
ATOM      3  SD  MET     1      24.779  28.804  27.139  1.00101.46      A   
ATOM      4  CE  MET     1      25.295  30.073  25.774  1.00 95.61      A   
ATOM      5  C   MET     1      25.321  25.000  26.603  1.00 28.93      A   
ATOM      6  O   MET     1      24.649  24.022  26.272  1.00 27.36      A   
ATOM      7  N   MET     1      26.470  25.414  24.459  1.00 32.31      A   
ATOM      8  CA  MET     1      25.731  26.058  25.583  1.00 34.03      A   
ATOM      9  N   ASN     2      25.748  25.199  27.844  1.00 27.92      A   
ATOM     10  CA  ASN     2      25.434  24.272  28.928  1.00 26.69      A   
ATOM     11  CB  ASN     2      26.294  23.018  28.793  1.00 24.03      A   
ATOM     12  CG  ASN     2      26.048  22.008  29.900  1.00 24.02      A   
ATOM     13  OD1 ASN     2      25.221  22.214  30.793  1.00 23.82      A   
ATOM     14  ND2 ASN     2      26.771  20.899  29.840  1.00 20.34      A   
ATOM     15  C   ASN     2      25.750  24.978  30.234  1.00 24.38      A   
ATOM     16  O   ASN     2      26.841  24.844  30.755  1.00 24.74      A   
ATOM     17  N   THR     3      24.797  25.741  30.750  1.00 21.49      A   
ATOM     18  CA  THR     3      25.026  26.468  31.987  1.00 24.29      A   
ATOM     19  CB  THR     3      25.575  27.893  31.722  1.00 27.90      A   
ATOM     20  OG1 THR     3      25.660  28.614  32.964  1.00 31.66      A   
ATOM     21  CG2 THR     3      24.655  28.654  30.771  1.00 28.43      A   
ATOM     22  C   THR     3      23.798  26.589  32.865  1.00 23.19      A   
ATOM     23  O   THR     3      22.763  27.126  32.470  1.00 25.48      A   
ATOM     24  N   LEU     4      23.934  26.069  34.073  1.00 23.57      A   
ATOM     25  CA  LEU     4      22.876  26.123  35.060  1.00 22.87      A   
ATOM     26  CB  LEU     4      22.698  24.767  35.738  1.00 24.04      A   
ATOM     27  CG  LEU     4      21.742  24.754  36.940  1.00 23.22      A   
ATOM     28  CD1 LEU     4      20.290  24.831  36.473  1.00 21.74      A   
ATOM     29  CD2 LEU     4      21.934  23.474  37.721  1.00 22.90      A   
ATOM     30  C   LEU     4      23.257  27.132  36.127  1.00 25.19      A   
ATOM     31  O   LEU     4      24.405  27.148  36.591  1.00 26.88      A   
ATOM     32  N   GLU     5      22.305  27.977  36.505  1.00 23.62      A   
ATOM     33  CA  GLU     5      22.514  28.944  37.578  1.00 25.83      A   
ATOM     34  CB  GLU     5      22.287  30.373  37.090  1.00 40.19      A   
ATOM     35  CG  GLU     5      23.504  30.937  36.383  1.00 46.33      A   
ATOM     36  CD  GLU     5      23.285  32.346  35.896  1.00 49.75      A   
ATOM     37  OE1 GLU     5      22.490  33.076  36.533  1.00 51.69      A   
ATOM     38  OE2 GLU     5      23.920  32.725  34.888  1.00 51.36      A   
ATOM     39  C   GLU     5      21.471  28.546  38.603  1.00 23.17      A   
ATOM     40  O   GLU     5      20.295  28.409  38.282  1.00 24.66      A   
ATOM     41  N   LEU     6      21.903  28.348  39.839  1.00 25.06      A   
ATOM     42  CA  LEU     6      20.999  27.892  40.873  1.00 23.09      A   
ATOM     43  CB  LEU     6      21.109  26.372  40.969  1.00 24.01      A   
ATOM     44  CG  LEU     6      20.122  25.610  41.845  1.00 25.36      A   
ATOM     45  CD1 LEU     6      18.801  25.483  41.105  1.00 22.71      A   
ATOM     46  CD2 LEU     6      20.682  24.216  42.139  1.00 28.71      A   
ATOM     47  C   LEU     6      21.297  28.479  42.240  1.00 24.57      A   
ATOM     48  O   LEU     6      22.462  28.697  42.585  1.00 23.80      A   
ATOM     49  N   SER     7      20.243  28.719  43.017  1.00 23.82      A   
ATOM     50  CA  SER     7      20.406  29.213  44.377  1.00 26.53      A   
ATOM     51  CB  SER     7      19.457  30.382  44.667  1.00 28.18      A   
ATOM     52  OG  SER     7      18.107  29.985  44.524  1.00 32.55      A   
ATOM     53  C   SER     7      20.038  28.003  45.233  1.00 26.53      A   
ATOM     54  O   SER     7      19.038  27.338  44.976  1.00 27.01      A   
ATOM     55  N   ALA     8      20.830  27.715  46.255  1.00 26.33      A   
ATOM     56  CA  ALA     8      20.552  26.541  47.062  1.00 26.48      A   
ATOM     57  CB  ALA     8      21.060  25.300  46.331  1.00 24.59      A   
ATOM     58  C   ALA     8      21.137  26.577  48.456  1.00 28.39      A   
ATOM     59  O   ALA     8      21.896  27.480  48.816  1.00 28.01      A   
ATOM     60  N   ARG     9      20.764  25.563  49.227  1.00 24.68      A   
ATOM     61  CA  ARG     9      21.223  25.391  50.591  1.00 27.29      A   
ATOM     62  CB  ARG     9      20.004  25.199  51.497  1.00 59.09      A   
ATOM     63  CG  ARG     9      20.307  24.858  52.937  1.00 65.71      A   
ATOM     64  CD  ARG     9      19.394  23.737  53.436  1.00 70.65      A   
ATOM     65  NE  ARG     9      18.032  23.854  52.913  1.00 73.40      A   
ATOM     66  CZ  ARG     9      17.078  22.946  53.109  1.00 74.78      A   
ATOM     67  NH1 ARG     9      17.329  21.852  53.819  1.00 74.28      A   
ATOM     68  NH2 ARG     9      15.874  23.121  52.578  1.00 75.97      A   
ATOM     69  C   ARG     9      22.088  24.130  50.595  1.00 25.32      A   
ATOM     70  O   ARG     9      21.748  23.150  49.930  1.00 23.53      A   
ATOM     71  N   VAL    10      23.209  24.157  51.314  1.00 26.68      A   
ATOM     72  CA  VAL    10      24.075  22.985  51.396  1.00 26.58      A   
ATOM     73  CB  VAL    10      25.467  23.332  51.942  1.00 27.91      A   
ATOM     74  CG1 VAL    10      26.304  22.056  52.069  1.00 29.79      A   
ATOM     75  CG2 VAL    10      26.158  24.320  51.008  1.00 26.57      A   
ATOM     76  C   VAL    10      23.454  21.954  52.320  1.00 27.37      A   
ATOM     77  O   VAL    10      23.337  22.172  53.528  1.00 30.15      A   
ATOM     78  N   LEU    11      23.064  20.825  51.749  1.00 27.52      A   
ATOM     79  CA  LEU    11      22.444  19.759  52.517  1.00 27.26      A   
ATOM     80  CB  LEU    11      21.413  19.040  51.651  1.00 27.95      A   
ATOM     81  CG  LEU    11      20.469  18.035  52.310  1.00 31.34      A   
ATOM     82  CD1 LEU    11      19.627  18.705  53.403  1.00 31.87      A   
ATOM     83  CD2 LEU    11      19.572  17.470  51.226  1.00 29.70      A   
ATOM     84  C   LEU    11      23.475  18.765  53.031  1.00 26.39      A   
ATOM     85  O   LEU    11      23.264  18.113  54.036  1.00 26.52      A   
ATOM     86  N   GLU    12      24.581  18.636  52.311  1.00 26.78      A   
ATOM     87  CA  GLU    12      25.654  17.731  52.694  1.00 26.21      A   
ATOM     88  CB  GLU    12      25.364  16.296  52.219  1.00 37.59      A   
ATOM     89  CG  GLU    12      26.547  15.339  52.386  1.00 41.96      A   
ATOM     90  CD  GLU    12      26.179  13.871  52.173  1.00 46.60      A   
ATOM     91  OE1 GLU    12      25.409  13.570  51.235  1.00 47.54      A   
ATOM     92  OE2 GLU    12      26.678  13.012  52.938  1.00 48.21      A   
ATOM     93  C   GLU    12      26.919  18.255  52.041  1.00 24.78      A   
ATOM     94  O   GLU    12      26.881  18.759  50.910  1.00 21.33      A   
ATOM     95  N   CYS    13      28.031  18.172  52.760  1.00 24.07      A   
ATOM     96  CA  CYS    13      29.304  18.648  52.237  1.00 25.07      A   
ATOM     97  CB  CYS    13      29.699  19.967  52.912  1.00 27.16      A   
ATOM     98  SG  CYS    13      31.211  20.744  52.267  1.00 28.15      A   
ATOM     99  C   CYS    13      30.338  17.584  52.520  1.00 27.03      A   
ATOM    100  O   CYS    13      30.720  17.369  53.671  1.00 29.10      A   
ATOM    101  N   GLY    14      30.788  16.910  51.467  1.00 31.16      A   
ATOM    102  CA  GLY    14      31.763  15.850  51.634  1.00 32.73      A   
ATOM    103  C   GLY    14      33.106  16.283  52.187  1.00 33.43      A   
ATOM    104  O   GLY    14      33.356  17.472  52.401  1.00 32.99      A   
ATOM    105  N   ALA    15      33.968  15.307  52.450  1.00 30.50      A   
ATOM    106  CA  ALA    15      35.301  15.600  52.948  1.00 31.73      A   
ATOM    107  CB  ALA    15      35.849  14.383  53.713  1.00 43.10      A   
ATOM    108  C   ALA    15      36.195  15.931  51.743  1.00 31.06      A   
ATOM    109  O   ALA    15      35.925  15.500  50.621  1.00 30.10      A   
ATOM    110  N   MET    16      37.248  16.706  51.974  1.00 33.75      A   
ATOM    111  CA  MET    16      38.175  17.079  50.909  1.00 34.44      A   
ATOM    112  CB  MET    16      39.190  18.088  51.437  1.00 36.40      A   
ATOM    113  CG  MET    16      40.158  18.580  50.380  1.00 42.50      A   
ATOM    114  SD  MET    16      39.215  19.523  48.978  1.00 51.77      A   
ATOM    115  CE  MET    16      39.181  21.260  49.790  1.00 42.94      A   
ATOM    116  C   MET    16      38.932  15.864  50.372  1.00 34.78      A   
ATOM    117  O   MET    16      39.434  15.055  51.147  1.00 35.45      A   
ATOM    118  N   ARG    17      39.010  15.730  49.050  1.00 31.64      A   
ATOM    119  CA  ARG    17      39.746  14.626  48.430  1.00 32.60      A   
ATOM    120  CB  ARG    17      38.805  13.684  47.663  1.00 45.02      A   
ATOM    121  CG  ARG    17      37.628  13.162  48.453  1.00 51.95      A   
ATOM    122  CD  ARG    17      36.742  12.282  47.579  1.00 58.07      A   
ATOM    123  NE  ARG    17      36.175  12.984  46.421  1.00 62.07      A   
ATOM    124  CZ  ARG    17      35.360  14.037  46.491  1.00 63.33      A   
ATOM    125  NH1 ARG    17      34.996  14.533  47.668  1.00 65.34      A   
ATOM    126  NH2 ARG    17      34.912  14.609  45.380  1.00 63.27      A   
ATOM    127  C   ARG    17      40.705  15.276  47.437  1.00 31.59      A   
ATOM    128  O   ARG    17      40.657  16.490  47.235  1.00 29.81      A   
ATOM    129  N   HIS    18      41.579  14.483  46.829  1.00 31.03      A   
ATOM    130  CA  HIS    18      42.501  15.013  45.835  1.00 30.31      A   
ATOM    131  CB  HIS    18      43.885  15.278  46.431  1.00 30.18      A   
ATOM    132  CG  HIS    18      43.891  16.339  47.478  1.00 27.06      A   
ATOM    133  CD2 HIS    18      44.146  17.666  47.400  1.00 25.93      A   
ATOM    134  ND1 HIS    18      43.549  16.089  48.787  1.00 26.80      A   
ATOM    135  CE1 HIS    18      43.592  17.217  49.473  1.00 27.01      A   
ATOM    136  NE2 HIS    18      43.951  18.189  48.654  1.00 26.49      A   
ATOM    137  C   HIS    18      42.649  14.033  44.700  1.00 30.86      A   
ATOM    138  O   HIS    18      42.610  12.822  44.903  1.00 29.79      A   
ATOM    139  N   THR    19      42.797  14.569  43.498  1.00 31.93      A   
ATOM    140  CA  THR    19      42.999  13.738  42.333  1.00 32.14      A   
ATOM    141  CB  THR    19      42.770  14.536  41.041  1.00 33.79      A   
ATOM    142  OG1 THR    19      43.730  15.601  40.957  1.00 33.43      A   
ATOM    143  CG2 THR    19      41.351  15.112  41.018  1.00 30.25      A   
ATOM    144  C   THR    19      44.467  13.305  42.404  1.00 32.81      A   
ATOM    145  O   THR    19      45.213  13.776  43.263  1.00 31.81      A   
ATOM    146  N   PRO    20      44.894  12.387  41.518  1.00 35.99      A   
ATOM    147  CD  PRO    20      44.089  11.552  40.605  1.00 38.03      A   
ATOM    148  CA  PRO    20      46.290  11.934  41.533  1.00 34.64      A   
ATOM    149  CB  PRO    20      46.335  10.915  40.400  1.00 36.73      A   
ATOM    150  CG  PRO    20      44.959  10.318  40.452  1.00 40.37      A   
ATOM    151  C   PRO    20      47.268  13.077  41.308  1.00 33.24      A   
ATOM    152  O   PRO    20      48.397  13.034  41.795  1.00 33.18      A   
ATOM    153  N   ALA    21      46.838  14.088  40.556  1.00 28.39      A   
ATOM    154  CA  ALA    21      47.687  15.246  40.285  1.00 26.67      A   
ATOM    155  CB  ALA    21      47.260  15.941  39.000  1.00 30.23      A   
ATOM    156  C   ALA    21      47.613  16.230  41.450  1.00 26.44      A   
ATOM    157  O   ALA    21      48.135  17.344  41.361  1.00 26.22      A   
ATOM    158  N   GLY    22      46.942  15.824  42.528  1.00 28.68      A   
ATOM    159  CA  GLY    22      46.829  16.670  43.709  1.00 26.14      A   
ATOM    160  C   GLY    22      45.780  17.777  43.657  1.00 28.37      A   
ATOM    161  O   GLY    22      45.741  18.655  44.524  1.00 26.71      A   
ATOM    162  N   LEU    23      44.932  17.758  42.640  1.00 25.27      A   
ATOM    163  CA  LEU    23      43.883  18.767  42.538  1.00 27.04      A   
ATOM    164  CB  LEU    23      43.262  18.705  41.144  1.00 36.58      A   
ATOM    165  CG  LEU    23      42.296  19.803  40.693  1.00 40.73      A   
ATOM    166  CD1 LEU    23      42.848  21.197  41.031  1.00 40.54      A   
ATOM    167  CD2 LEU    23      42.086  19.653  39.190  1.00 40.02      A   
ATOM    168  C   LEU    23      42.804  18.542  43.619  1.00 27.04      A   
ATOM    169  O   LEU    23      42.299  17.430  43.788  1.00 26.83      A   
ATOM    170  N   PRO    24      42.457  19.588  44.392  1.00 26.02      A   
ATOM    171  CD  PRO    24      43.071  20.917  44.540  1.00 33.80      A   
ATOM    172  CA  PRO    24      41.424  19.366  45.414  1.00 25.32      A   
ATOM    173  CB  PRO    24      41.406  20.682  46.200  1.00 34.41      A   
ATOM    174  CG  PRO    24      41.988  21.680  45.246  1.00 35.64      A   
ATOM    175  C   PRO    24      40.082  19.031  44.770  1.00 23.75      A   
ATOM    176  O   PRO    24      39.735  19.570  43.725  1.00 22.81      A   
ATOM    177  N   ALA    25      39.337  18.125  45.388  1.00 23.67      A   
ATOM    178  CA  ALA    25      38.056  17.700  44.842  1.00 25.97      A   
ATOM    179  CB  ALA    25      38.209  16.362  44.128  1.00 30.92      A   
ATOM    180  C   ALA    25      37.048  17.578  45.962  1.00 25.13      A   
ATOM    181  O   ALA    25      37.319  16.978  46.994  1.00 25.71      A   
ATOM    182  N   LEU    26      35.865  18.135  45.742  1.00 25.68      A   
ATOM    183  CA  LEU    26      34.833  18.115  46.765  1.00 25.29      A   
ATOM    184  CB  LEU    26      34.834  19.465  47.486  1.00 25.63      A   
ATOM    185  CG  LEU    26      33.739  19.749  48.513  1.00 27.37      A   
ATOM    186  CD1 LEU    26      33.997  18.903  49.772  1.00 29.57      A   
ATOM    187  CD2 LEU    26      33.745  21.244  48.858  1.00 28.02      A   
ATOM    188  C   LEU    26      33.448  17.825  46.194  1.00 26.42      A   
ATOM    189  O   LEU    26      33.075  18.346  45.143  1.00 27.62      A   
ATOM    190  N   GLU    27      32.690  16.992  46.898  1.00 23.95      A   
ATOM    191  CA  GLU    27      31.341  16.630  46.477  1.00 27.32      A   
ATOM    192  CB  GLU    27      31.216  15.094  46.439  1.00 50.38      A   
ATOM    193  CG  GLU    27      29.804  14.530  46.600  1.00 58.68      A   
ATOM    194  CD  GLU    27      29.034  14.409  45.289  1.00 62.89      A   
ATOM    195  OE1 GLU    27      29.407  13.553  44.457  1.00 66.03      A   
ATOM    196  OE2 GLU    27      28.057  15.162  45.092  1.00 66.47      A   
ATOM    197  C   GLU    27      30.350  17.226  47.477  1.00 26.08      A   
ATOM    198  O   GLU    27      30.550  17.128  48.687  1.00 24.71      A   
ATOM    199  N   LEU    28      29.303  17.876  46.979  1.00 26.78      A   
ATOM    200  CA  LEU    28      28.299  18.445  47.872  1.00 26.53      A   
ATOM    201  CB  LEU    28      28.413  19.975  47.964  1.00 27.40      A   
ATOM    202  CG  LEU    28      29.738  20.650  48.326  1.00 27.58      A   
ATOM    203  CD1 LEU    28      30.465  21.049  47.038  1.00 28.75      A   
ATOM    204  CD2 LEU    28      29.463  21.884  49.182  1.00 27.49      A   
ATOM    205  C   LEU    28      26.905  18.094  47.382  1.00 24.94      A   
ATOM    206  O   LEU    28      26.715  17.720  46.225  1.00 26.86      A   
ATOM    207  N   LEU    29      25.939  18.208  48.283  1.00 23.67      A   
ATOM    208  CA  LEU    29      24.546  17.948  47.961  1.00 25.26      A   
ATOM    209  CB  LEU    29      23.980  16.847  48.859  1.00 32.81      A   
ATOM    210  CG  LEU    29      22.619  16.271  48.455  1.00 36.98      A   
ATOM    211  CD1 LEU    29      22.643  15.862  46.983  1.00 39.93      A   
ATOM    212  CD2 LEU    29      22.291  15.061  49.329  1.00 38.53      A   
ATOM    213  C   LEU    29      23.811  19.261  48.211  1.00 25.49      A   
ATOM    214  O   LEU    29      23.820  19.794  49.326  1.00 25.02      A   
ATOM    215  N   LEU    30      23.173  19.782  47.171  1.00 25.15      A   
ATOM    216  CA  LEU    30      22.457  21.048  47.272  1.00 24.89      A   
ATOM    217  CB  LEU    30      22.923  21.976  46.151  1.00 25.89      A   
ATOM    218  CG  LEU    30      24.446  22.117  46.006  1.00 27.08      A   
ATOM    219  CD1 LEU    30      24.786  22.905  44.744  1.00 25.50      A   
ATOM    220  CD2 LEU    30      25.035  22.788  47.246  1.00 25.99      A   
ATOM    221  C   LEU    30      20.951  20.854  47.160  1.00 25.18      A   
ATOM    222  O   LEU    30      20.493  19.983  46.426  1.00 23.82      A   
ATOM    223  N   VAL    31      20.184  21.652  47.898  1.00 23.42      A   
ATOM    224  CA  VAL    31      18.731  21.571  47.822  1.00 23.61      A   
ATOM    225  CB  VAL    31      18.115  21.034  49.138  1.00 30.26      A   
ATOM    226  CG1 VAL    31      18.591  21.859  50.313  1.00 32.68      A   
ATOM    227  CG2 VAL    31      16.583  21.037  49.031  1.00 31.06      A   
ATOM    228  C   VAL    31      18.191  22.959  47.489  1.00 24.03      A   
ATOM    229  O   VAL    31      18.484  23.941  48.167  1.00 21.81      A   
ATOM    230  N   HIS    32      17.430  23.033  46.404  1.00 26.38      A   
ATOM    231  CA  HIS    32      16.854  24.282  45.936  1.00 26.95      A   
ATOM    232  CB  HIS    32      17.186  24.467  44.452  1.00 28.09      A   
ATOM    233  CG  HIS    32      16.364  25.515  43.771  1.00 24.39      A   
ATOM    234  CD2 HIS    32      16.612  26.824  43.529  1.00 25.91      A   
ATOM    235  ND1 HIS    32      15.111  25.262  43.257  1.00 28.36      A   
ATOM    236  CE1 HIS    32      14.620  26.367  42.727  1.00 25.17      A   
ATOM    237  NE2 HIS    32      15.510  27.330  42.878  1.00 29.12      A   
ATOM    238  C   HIS    32      15.345  24.302  46.114  1.00 28.72      A   
ATOM    239  O   HIS    32      14.689  23.281  45.933  1.00 29.57      A   
ATOM    240  N   GLU    33      14.803  25.462  46.478  1.00 30.22      A   
ATOM    241  CA  GLU    33      13.356  25.614  46.631  1.00 31.31      A   
ATOM    242  CB  GLU    33      12.914  25.405  48.084  1.00 56.19      A   
ATOM    243  CG  GLU    33      11.397  25.481  48.265  1.00 62.70      A   
ATOM    244  CD  GLU    33      10.952  25.161  49.681  1.00 67.35      A   
ATOM    245  OE1 GLU    33      11.378  25.863  50.626  1.00 70.69      A   
ATOM    246  OE2 GLU    33      10.169  24.200  49.849  1.00 69.26      A   
ATOM    247  C   GLU    33      12.931  27.003  46.171  1.00 31.37      A   
ATOM    248  O   GLU    33      13.559  28.002  46.512  1.00 29.09      A   
ATOM    249  N   SER    34      11.863  27.060  45.385  1.00 32.63      A   
ATOM    250  CA  SER    34      11.370  28.329  44.878  1.00 32.82      A   
ATOM    251  CB  SER    34      12.356  28.929  43.871  1.00 30.99      A   
ATOM    252  OG  SER    34      12.385  28.179  42.669  1.00 27.65      A   
ATOM    253  C   SER    34      10.050  28.103  44.186  1.00 34.11      A   
ATOM    254  O   SER    34       9.665  26.960  43.931  1.00 34.53      A   
ATOM    255  N   GLU    35       9.363  29.196  43.879  1.00 31.65      A   
ATOM    256  CA  GLU    35       8.087  29.133  43.189  1.00 35.16      A   
ATOM    257  CB  GLU    35       7.055  30.018  43.895  1.00 64.06      A   
ATOM    258  CG  GLU    35       6.638  29.524  45.271  1.00 69.41      A   
ATOM    259  CD  GLU    35       5.649  28.378  45.201  1.00 72.73      A   
ATOM    260  OE1 GLU    35       4.592  28.550  44.555  1.00 75.53      A   
ATOM    261  OE2 GLU    35       5.924  27.311  45.795  1.00 75.35      A   
ATOM    262  C   GLU    35       8.346  29.668  41.791  1.00 34.94      A   
ATOM    263  O   GLU    35       9.034  30.674  41.635  1.00 34.58      A   
ATOM    264  N   VAL    36       7.822  28.988  40.779  1.00 35.89      A   
ATOM    265  CA  VAL    36       7.996  29.433  39.401  1.00 37.61      A   
ATOM    266  CB  VAL    36       8.982  28.532  38.621  1.00 33.61      A   
ATOM    267  CG1 VAL    36      10.338  28.512  39.308  1.00 32.75      A   
ATOM    268  CG2 VAL    36       8.426  27.132  38.502  1.00 34.51      A   
ATOM    269  C   VAL    36       6.659  29.434  38.663  1.00 38.71      A   
ATOM    270  O   VAL    36       5.709  28.755  39.062  1.00 38.69      A   
ATOM    271  N   VAL    37       6.590  30.203  37.587  1.00 39.43      A   
ATOM    272  CA  VAL    37       5.372  30.286  36.795  1.00 40.19      A   
ATOM    273  CB  VAL    37       5.102  31.739  36.378  1.00 49.29      A   
ATOM    274  CG1 VAL    37       6.312  32.290  35.638  1.00 50.63      A   
ATOM    275  CG2 VAL    37       3.848  31.811  35.525  1.00 50.21      A   
ATOM    276  C   VAL    37       5.529  29.414  35.553  1.00 40.89      A   
ATOM    277  O   VAL    37       6.507  29.533  34.818  1.00 38.12      A   
ATOM    278  N   GLU    38       4.566  28.528  35.324  1.00 42.38      A   
ATOM    279  CA  GLU    38       4.634  27.638  34.175  1.00 45.57      A   
ATOM    280  CB  GLU    38       4.986  26.229  34.652  1.00 50.02      A   
ATOM    281  CG  GLU    38       5.164  25.214  33.557  1.00 50.17      A   
ATOM    282  CD  GLU    38       5.800  23.942  34.073  1.00 51.94      A   
ATOM    283  OE1 GLU    38       5.411  23.486  35.169  1.00 52.48      A   
ATOM    284  OE2 GLU    38       6.684  23.393  33.385  1.00 51.85      A   
ATOM    285  C   GLU    38       3.333  27.633  33.383  1.00 46.60      A   
ATOM    286  O   GLU    38       2.289  27.217  33.886  1.00 45.91      A   
ATOM    287  N   ALA    39       3.415  28.095  32.137  1.00 66.00      A   
ATOM    288  CA  ALA    39       2.250  28.172  31.268  1.00 67.47      A   
ATOM    289  CB  ALA    39       1.708  26.771  30.984  1.00 62.56      A   
ATOM    290  C   ALA    39       1.193  29.021  31.959  1.00 67.93      A   
ATOM    291  O   ALA    39      -0.003  28.756  31.846  1.00 68.09      A   
ATOM    292  N   GLY    40       1.648  30.039  32.682  1.00 50.35      A   
ATOM    293  CA  GLY    40       0.732  30.919  33.383  1.00 50.51      A   
ATOM    294  C   GLY    40       0.170  30.337  34.663  1.00 51.76      A   
ATOM    295  O   GLY    40      -0.970  30.631  35.025  1.00 52.84      A   
ATOM    296  N   HIS    41       0.949  29.513  35.360  1.00 51.87      A   
ATOM    297  CA  HIS    41       0.475  28.912  36.607  1.00 52.47      A   
ATOM    298  CB  HIS    41      -0.160  27.541  36.330  1.00 71.49      A   
ATOM    299  CG  HIS    41      -1.320  27.592  35.387  1.00 73.74      A   
ATOM    300  CD2 HIS    41      -1.448  27.161  34.110  1.00 74.29      A   
ATOM    301  ND1 HIS    41      -2.525  28.173  35.719  1.00 74.30      A   
ATOM    302  CE1 HIS    41      -3.346  28.098  34.686  1.00 75.45      A   
ATOM    303  NE2 HIS    41      -2.716  27.488  33.697  1.00 74.43      A   
ATOM    304  C   HIS    41       1.594  28.756  37.639  1.00 52.24      A   
ATOM    305  O   HIS    41       2.702  28.355  37.303  1.00 51.82      A   
ATOM    306  N   PRO    42       1.312  29.073  38.913  1.00 59.44      A   
ATOM    307  CD  PRO    42       0.040  29.603  39.440  1.00 62.08      A   
ATOM    308  CA  PRO    42       2.316  28.955  39.980  1.00 59.00      A   
ATOM    309  CB  PRO    42       1.661  29.686  41.149  1.00 62.01      A   
ATOM    310  CG  PRO    42       0.194  29.389  40.935  1.00 61.96      A   
ATOM    311  C   PRO    42       2.647  27.493  40.304  1.00 58.49      A   
ATOM    312  O   PRO    42       1.778  26.620  40.245  1.00 57.97      A   
ATOM    313  N   ARG    43       3.904  27.232  40.647  1.00 45.42      A   
ATOM    314  CA  ARG    43       4.343  25.872  40.949  1.00 45.16      A   
ATOM    315  CB  ARG    43       4.783  25.181  39.655  1.00 63.38      A   
ATOM    316  CG  ARG    43       5.300  23.757  39.816  1.00 67.94      A   
ATOM    317  CD  ARG    43       5.748  23.220  38.463  1.00 69.41      A   
ATOM    318  NE  ARG    43       6.267  21.856  38.528  1.00 71.62      A   
ATOM    319  CZ  ARG    43       7.413  21.510  39.108  1.00 73.06      A   
ATOM    320  NH1 ARG    43       8.178  22.428  39.686  1.00 74.20      A   
ATOM    321  NH2 ARG    43       7.804  20.241  39.096  1.00 72.22      A   
ATOM    322  C   ARG    43       5.485  25.836  41.961  1.00 43.06      A   
ATOM    323  O   ARG    43       6.401  26.650  41.916  1.00 40.53      A   
ATOM    324  N   ARG    44       5.431  24.877  42.871  1.00 42.86      A   
ATOM    325  CA  ARG    44       6.470  24.750  43.880  1.00 41.76      A   
ATOM    326  CB  ARG    44       5.900  24.056  45.119  1.00 80.16      A   
ATOM    327  CG  ARG    44       4.566  24.626  45.605  1.00 86.18      A   
ATOM    328  CD  ARG    44       3.908  23.753  46.665  1.00 89.94      A   
ATOM    329  NE  ARG    44       4.813  23.455  47.768  1.00 94.16      A   
ATOM    330  CZ  ARG    44       4.432  22.910  48.918  1.00 95.74      A   
ATOM    331  NH1 ARG    44       5.325  22.667  49.869  1.00 97.16      A   
ATOM    332  NH2 ARG    44       3.155  22.624  49.118  1.00 96.57      A   
ATOM    333  C   ARG    44       7.605  23.894  43.314  1.00 39.20      A   
ATOM    334  O   ARG    44       7.365  22.771  42.882  1.00 38.72      A   
ATOM    335  N   VAL    45       8.832  24.409  43.303  1.00 31.89      A   
ATOM    336  CA  VAL    45       9.956  23.617  42.808  1.00 30.53      A   
ATOM    337  CB  VAL    45      10.784  24.353  41.715  1.00 48.89      A   
ATOM    338  CG1 VAL    45      11.869  23.422  41.192  1.00 49.73      A   
ATOM    339  CG2 VAL    45       9.891  24.820  40.581  1.00 51.08      A   
ATOM    340  C   VAL    45      10.910  23.307  43.956  1.00 28.97      A   
ATOM    341  O   VAL    45      11.385  24.212  44.638  1.00 29.10      A   
ATOM    342  N   GLU    46      11.169  22.026  44.181  1.00 35.62      A   
ATOM    343  CA  GLU    46      12.113  21.609  45.212  1.00 35.83      A   
ATOM    344  CB  GLU    46      11.406  20.961  46.396  1.00 50.70      A   
ATOM    345  CG  GLU    46      12.377  20.379  47.412  1.00 56.00      A   
ATOM    346  CD  GLU    46      11.755  20.213  48.790  1.00 59.28      A   
ATOM    347  OE1 GLU    46      10.675  19.590  48.894  1.00 59.61      A   
ATOM    348  OE2 GLU    46      12.350  20.708  49.772  1.00 60.11      A   
ATOM    349  C   GLU    46      13.061  20.610  44.562  1.00 33.49      A   
ATOM    350  O   GLU    46      12.681  19.484  44.254  1.00 33.63      A   
ATOM    351  N   LEU    47      14.301  21.032  44.368  1.00 31.55      A   
ATOM    352  CA  LEU    47      15.299  20.201  43.707  1.00 29.40      A   
ATOM    353  CB  LEU    47      15.774  20.916  42.436  1.00 26.79      A   
ATOM    354  CG  LEU    47      16.912  20.320  41.595  1.00 26.96      A   
ATOM    355  CD1 LEU    47      16.414  19.106  40.818  1.00 29.61      A   
ATOM    356  CD2 LEU    47      17.427  21.372  40.624  1.00 26.03      A   
ATOM    357  C   LEU    47      16.514  19.888  44.567  1.00 27.14      A   
ATOM    358  O   LEU    47      17.041  20.759  45.244  1.00 24.59      A   
ATOM    359  N   THR    48      16.955  18.637  44.536  1.00 27.05      A   
ATOM    360  CA  THR    48      18.148  18.238  45.270  1.00 27.97      A   
ATOM    361  CB  THR    48      17.846  17.132  46.290  1.00 29.86      A   
ATOM    362  OG1 THR    48      16.987  17.668  47.301  1.00 30.72      A   
ATOM    363  CG2 THR    48      19.119  16.634  46.949  1.00 27.80      A   
ATOM    364  C   THR    48      19.072  17.738  44.170  1.00 28.24      A   
ATOM    365  O   THR    48      18.683  16.926  43.312  1.00 27.20      A   
ATOM    366  N   ILE    49      20.293  18.247  44.174  1.00 25.73      A   
ATOM    367  CA  ILE    49      21.238  17.880  43.141  1.00 25.79      A   
ATOM    368  CB  ILE    49      21.192  18.916  42.015  1.00 27.68      A   
ATOM    369  CG2 ILE    49      21.423  20.305  42.588  1.00 25.33      A   
ATOM    370  CG1 ILE    49      22.222  18.580  40.936  1.00 31.67      A   
ATOM    371  CD1 ILE    49      21.795  17.477  40.017  1.00 35.55      A   
ATOM    372  C   ILE    49      22.652  17.813  43.685  1.00 25.13      A   
ATOM    373  O   ILE    49      23.056  18.645  44.502  1.00 22.88      A   
ATOM    374  N   SER    50      23.406  16.824  43.226  1.00 25.95      A   
ATOM    375  CA  SER    50      24.784  16.693  43.671  1.00 27.21      A   
ATOM    376  CB  SER    50      25.263  15.247  43.538  1.00 39.72      A   
ATOM    377  OG  SER    50      25.384  14.891  42.179  1.00 49.33      A   
ATOM    378  C   SER    50      25.674  17.616  42.843  1.00 26.32      A   
ATOM    379  O   SER    50      25.502  17.746  41.627  1.00 26.27      A   
ATOM    380  N   ALA    51      26.625  18.259  43.510  1.00 23.67      A   
ATOM    381  CA  ALA    51      27.524  19.173  42.837  1.00 24.76      A   
ATOM    382  CB  ALA    51      27.260  20.593  43.298  1.00 24.09      A   
ATOM    383  C   ALA    51      28.948  18.792  43.150  1.00 26.32      A   
ATOM    384  O   ALA    51      29.249  18.353  44.266  1.00 24.18      A   
ATOM    385  N   VAL    52      29.816  18.962  42.159  1.00 25.72      A   
ATOM    386  CA  VAL    52      31.227  18.656  42.319  1.00 26.52      A   
ATOM    387  CB  VAL    52      31.681  17.537  41.336  1.00 38.51      A   
ATOM    388  CG1 VAL    52      33.196  17.407  41.350  1.00 40.69      A   
ATOM    389  CG2 VAL    52      31.058  16.202  41.742  1.00 39.67      A   
ATOM    390  C   VAL    52      32.049  19.916  42.069  1.00 26.65      A   
ATOM    391  O   VAL    52      31.793  20.675  41.125  1.00 23.27      A   
ATOM    392  N   ALA    53      33.015  20.139  42.951  1.00 24.95      A   
ATOM    393  CA  ALA    53      33.918  21.274  42.862  1.00 25.72      A   
ATOM    394  CB  ALA    53      33.850  22.101  44.144  1.00 32.05      A   
ATOM    395  C   ALA    53      35.301  20.657  42.687  1.00 25.08      A   
ATOM    396  O   ALA    53      35.597  19.614  43.271  1.00 26.05      A   
ATOM    397  N   LEU    54      36.135  21.282  41.870  1.00 29.44      A   
ATOM    398  CA  LEU    54      37.469  20.761  41.597  1.00 31.81      A   
ATOM    399  CB  LEU    54      37.441  19.976  40.275  1.00 36.23      A   
ATOM    400  CG  LEU    54      38.631  19.161  39.744  1.00 42.22      A   
ATOM    401  CD1 LEU    54      39.140  18.197  40.806  1.00 42.20      A   
ATOM    402  CD2 LEU    54      38.185  18.384  38.490  1.00 41.90      A   
ATOM    403  C   LEU    54      38.401  21.958  41.497  1.00 32.80      A   
ATOM    404  O   LEU    54      38.203  22.831  40.653  1.00 34.37      A   
ATOM    405  N   GLY    55      39.405  22.010  42.367  1.00 27.13      A   
ATOM    406  CA  GLY    55      40.327  23.127  42.343  1.00 26.95      A   
ATOM    407  C   GLY    55      40.002  24.211  43.362  1.00 26.29      A   
ATOM    408  O   GLY    55      39.674  23.931  44.518  1.00 24.22      A   
ATOM    409  N   ASP    56      40.072  25.459  42.920  1.00 27.38      A   
ATOM    410  CA  ASP    56      39.824  26.590  43.793  1.00 28.10      A   
ATOM    411  CB  ASP    56      40.083  27.885  43.026  1.00 27.21      A   
ATOM    412  CG  ASP    56      41.571  28.149  42.824  1.00 31.36      A   
ATOM    413  OD1 ASP    56      41.919  29.030  42.010  1.00 30.34      A   
ATOM    414  OD2 ASP    56      42.396  27.478  43.489  1.00 28.38      A   
ATOM    415  C   ASP    56      38.455  26.625  44.475  1.00 26.99      A   
ATOM    416  O   ASP    56      38.355  27.024  45.631  1.00 25.86      A   
ATOM    417  N   LEU    57      37.409  26.201  43.778  1.00 26.03      A   
ATOM    418  CA  LEU    57      36.077  26.203  44.367  1.00 26.48      A   
ATOM    419  CB  LEU    57      35.009  25.940  43.301  1.00 36.39      A   
ATOM    420  CG  LEU    57      34.632  27.127  42.419  1.00 36.95      A   
ATOM    421  CD1 LEU    57      33.485  26.718  41.510  1.00 38.53      A   
ATOM    422  CD2 LEU    57      34.200  28.297  43.287  1.00 38.10      A   
ATOM    423  C   LEU    57      35.972  25.146  45.449  1.00 25.86      A   
ATOM    424  O   LEU    57      35.247  25.313  46.426  1.00 25.71      A   
ATOM    425  N   ALA    58      36.692  24.047  45.276  1.00 25.28      A   
ATOM    426  CA  ALA    58      36.663  22.995  46.279  1.00 23.68      A   
ATOM    427  CB  ALA    58      37.433  21.754  45.778  1.00 18.74      A   
ATOM    428  C   ALA    58      37.292  23.548  47.565  1.00 24.16      A   
ATOM    429  O   ALA    58      36.825  23.279  48.676  1.00 24.86      A   
ATOM    430  N   LEU    59      38.346  24.340  47.420  1.00 24.80      A   
ATOM    431  CA  LEU    59      39.009  24.912  48.594  1.00 25.22      A   
ATOM    432  CB  LEU    59      40.301  25.620  48.173  1.00 25.53      A   
ATOM    433  CG  LEU    59      41.408  24.698  47.635  1.00 23.74      A   
ATOM    434  CD1 LEU    59      42.621  25.539  47.185  1.00 28.11      A   
ATOM    435  CD2 LEU    59      41.819  23.735  48.726  1.00 25.60      A   
ATOM    436  C   LEU    59      38.075  25.896  49.282  1.00 26.66      A   
ATOM    437  O   LEU    59      37.977  25.945  50.514  1.00 25.80      A   
ATOM    438  N   LEU    60      37.380  26.675  48.469  1.00 26.26      A   
ATOM    439  CA  LEU    60      36.454  27.660  48.999  1.00 28.13      A   
ATOM    440  CB  LEU    60      35.907  28.519  47.858  1.00 28.63      A   
ATOM    441  CG  LEU    60      35.022  29.723  48.203  1.00 33.95      A   
ATOM    442  CD1 LEU    60      35.829  30.845  48.888  1.00 33.12      A   
ATOM    443  CD2 LEU    60      34.412  30.234  46.899  1.00 35.66      A   
ATOM    444  C   LEU    60      35.297  26.996  49.739  1.00 27.53      A   
ATOM    445  O   LEU    60      34.984  27.358  50.866  1.00 27.40      A   
ATOM    446  N   LEU    61      34.675  26.006  49.109  1.00 23.07      A   
ATOM    447  CA  LEU    61      33.526  25.334  49.705  1.00 22.98      A   
ATOM    448  CB  LEU    61      32.680  24.689  48.598  1.00 23.07      A   
ATOM    449  CG  LEU    61      32.164  25.739  47.597  1.00 26.73      A   
ATOM    450  CD1 LEU    61      31.443  25.061  46.434  1.00 24.40      A   
ATOM    451  CD2 LEU    61      31.237  26.720  48.324  1.00 27.56      A   
ATOM    452  C   LEU    61      33.819  24.320  50.796  1.00 22.65      A   
ATOM    453  O   LEU    61      32.915  23.903  51.503  1.00 21.35      A   
ATOM    454  N   ALA    62      35.075  23.920  50.951  1.00 25.49      A   
ATOM    455  CA  ALA    62      35.398  22.957  51.988  1.00 28.72      A   
ATOM    456  CB  ALA    62      36.917  22.823  52.118  1.00 45.83      A   
ATOM    457  C   ALA    62      34.788  23.337  53.346  1.00 29.14      A   
ATOM    458  O   ALA    62      34.822  24.498  53.757  1.00 29.36      A   
ATOM    459  N   ASP    63      34.216  22.350  54.025  1.00 29.35      A   
ATOM    460  CA  ASP    63      33.626  22.560  55.340  1.00 30.52      A   
ATOM    461  CB  ASP    63      34.732  22.890  56.348  1.00 46.08      A   
ATOM    462  CG  ASP    63      35.839  21.853  56.353  1.00 49.24      A   
ATOM    463  OD1 ASP    63      35.531  20.666  56.581  1.00 50.62      A   
ATOM    464  OD2 ASP    63      37.012  22.220  56.122  1.00 52.95      A   
ATOM    465  C   ASP    63      32.541  23.633  55.418  1.00 30.03      A   
ATOM    466  O   ASP    63      32.391  24.279  56.451  1.00 29.98      A   
ATOM    467  N   THR    64      31.779  23.838  54.347  1.00 27.75      A   
ATOM    468  CA  THR    64      30.705  24.833  54.407  1.00 28.05      A   
ATOM    469  CB  THR    64      29.982  24.997  53.054  1.00 31.02      A   
ATOM    470  OG1 THR    64      30.929  25.362  52.049  1.00 29.72      A   
ATOM    471  CG2 THR    64      28.917  26.094  53.142  1.00 31.52      A   
ATOM    472  C   THR    64      29.685  24.312  55.409  1.00 28.21      A   
ATOM    473  O   THR    64      29.289  23.145  55.342  1.00 25.04      A   
ATOM    474  N   PRO    65      29.257  25.153  56.365  1.00 31.00      A   
ATOM    475  CD  PRO    65      29.811  26.446  56.816  1.00 31.55      A   
ATOM    476  CA  PRO    65      28.272  24.635  57.321  1.00 31.25      A   
ATOM    477  CB  PRO    65      28.004  25.837  58.233  1.00 31.38      A   
ATOM    478  CG  PRO    65      29.332  26.534  58.272  1.00 31.89      A   
ATOM    479  C   PRO    65      27.000  24.171  56.610  1.00 32.82      A   
ATOM    480  O   PRO    65      26.565  24.802  55.645  1.00 33.91      A   
ATOM    481  N   LEU    66      26.397  23.084  57.081  1.00 29.49      A   
ATOM    482  CA  LEU    66      25.160  22.609  56.462  1.00 32.04      A   
ATOM    483  CB  LEU    66      24.726  21.262  57.051  1.00 38.32      A   
ATOM    484  CG  LEU    66      25.796  20.180  56.907  1.00 42.26      A   
ATOM    485  CD1 LEU    66      25.271  18.857  57.429  1.00 42.26      A   
ATOM    486  CD2 LEU    66      26.187  20.053  55.442  1.00 41.30      A   
ATOM    487  C   LEU    66      24.068  23.641  56.679  1.00 30.22      A   
ATOM    488  O   LEU    66      24.003  24.275  57.734  1.00 29.76      A   
ATOM    489  N   GLY    67      23.204  23.804  55.683  1.00 29.89      A   
ATOM    490  CA  GLY    67      22.145  24.789  55.787  1.00 27.82      A   
ATOM    491  C   GLY    67      22.556  26.109  55.145  1.00 27.55      A   
ATOM    492  O   GLY    67      21.704  26.954  54.861  1.00 27.26      A   
ATOM    493  N   THR    68      23.856  26.298  54.912  1.00 25.80      A   
ATOM    494  CA  THR    68      24.353  27.536  54.300  1.00 26.75      A   
ATOM    495  CB  THR    68      25.879  27.500  54.089  1.00 31.47      A   
ATOM    496  OG1 THR    68      26.531  27.304  55.345  1.00 32.99      A   
ATOM    497  CG2 THR    68      26.375  28.822  53.488  1.00 31.56      A   
ATOM    498  C   THR    68      23.731  27.803  52.937  1.00 28.81      A   
ATOM    499  O   THR    68      23.567  26.882  52.133  1.00 26.16      A   
ATOM    500  N   GLU    69      23.409  29.066  52.674  1.00 31.53      A   
ATOM    501  CA  GLU    69      22.826  29.467  51.399  1.00 34.95      A   
ATOM    502  CB  GLU    69      22.024  30.760  51.558  1.00 59.01      A   
ATOM    503  CG  GLU    69      21.170  31.132  50.347  1.00 66.23      A   
ATOM    504  CD  GLU    69      20.135  30.050  50.054  1.00 71.75      A   
ATOM    509  C   GLU    69      23.938  29.686  50.384  1.00 35.52      A   
ATOM    510  O   GLU    69      24.977  30.273  50.702  1.00 37.15      A   
ATOM    511  N   MET    70      23.695  29.239  49.157  1.00 27.26      A   
ATOM    512  CA  MET    70      24.663  29.338  48.078  0.50 29.37      A   
ATOM    513  CB  MET    70      25.252  27.954  47.788  0.50 53.54      A   
ATOM    514  CG  MET    70      25.898  27.307  48.976  0.50 59.96      A   
ATOM    515  SD  MET    70      27.190  28.525  49.679  0.50 69.62      A   
ATOM    516  CE  MET    70      28.377  28.589  48.155  0.50 67.14      A   
ATOM    517  C   MET    70      24.064  29.869  46.788  1.00 28.37      A   
ATOM    518  O   MET    70      22.861  29.775  46.564  1.00 28.60      A   
ATOM    519  N   GLN    71      24.931  30.416  45.946  1.00 32.77      A   
ATOM    520  CA  GLN    71      24.554  30.924  44.636  1.00 33.87      A   
ATOM    521  CB  GLN    71      24.610  32.452  44.622  1.00 55.43      A   
ATOM    522  CG  GLN    71      23.690  33.092  43.609  1.00 61.78      A   
ATOM    523  CD  GLN    71      23.401  34.545  43.937  1.00 63.91      A   
ATOM    524  OE1 GLN    71      22.963  34.868  45.043  1.00 64.97      A   
ATOM    525  NE2 GLN    71      23.639  35.428  42.975  1.00 64.85      A   
ATOM    526  C   GLN    71      25.634  30.313  43.749  1.00 30.52      A   
ATOM    527  O   GLN    71      26.811  30.644  43.875  1.00 30.63      A   
ATOM    528  N   VAL    72      25.248  29.401  42.866  1.00 27.97      A   
ATOM    529  CA  VAL    72      26.238  28.730  42.033  1.00 25.03      A   
ATOM    530  CB  VAL    72      26.467  27.273  42.499  1.00 26.61      A   
ATOM    531  CG1 VAL    72      26.901  27.239  43.951  1.00 27.06      A   
ATOM    532  CG2 VAL    72      25.179  26.471  42.318  1.00 26.00      A   
ATOM    533  C   VAL    72      25.862  28.658  40.569  1.00 26.84      A   
ATOM    534  O   VAL    72      24.712  28.888  40.198  1.00 27.56      A   
ATOM    535  N   GLN    73      26.856  28.316  39.754  1.00 27.71      A   
ATOM    536  CA  GLN    73      26.687  28.143  38.317  1.00 27.13      A   
ATOM    537  CB  GLN    73      26.831  29.481  37.570  1.00 38.19      A   
ATOM    538  CG  GLN    73      28.234  29.910  37.209  1.00 44.88      A   
ATOM    539  CD  GLN    73      28.772  29.236  35.954  1.00 45.71      A   
ATOM    540  OE1 GLN    73      28.021  28.672  35.152  1.00 49.24      A   
ATOM    541  NE2 GLN    73      30.079  29.307  35.774  1.00 46.81      A   
ATOM    542  C   GLN    73      27.744  27.150  37.854  1.00 26.57      A   
ATOM    543  O   GLN    73      28.808  27.020  38.475  1.00 22.41      A   
ATOM    544  N   GLY    74      27.434  26.424  36.784  1.00 23.92      A   
ATOM    545  CA  GLY    74      28.367  25.451  36.252  1.00 24.43      A   
ATOM    546  C   GLY    74      27.689  24.689  35.136  1.00 22.75      A   
ATOM    547  O   GLY    74      26.615  25.086  34.683  1.00 23.35      A   
ATOM    548  N   PHE    75      28.301  23.598  34.690  1.00 25.04      A   
ATOM    549  CA  PHE    75      27.713  22.808  33.620  1.00 25.32      A   
ATOM    550  CB  PHE    75      28.725  22.635  32.481  1.00 25.85      A   
ATOM    551  CG  PHE    75      29.955  21.841  32.858  1.00 27.05      A   
ATOM    552  CD1 PHE    75      30.002  20.452  32.677  1.00 25.82      A   
ATOM    553  CD2 PHE    75      31.082  22.487  33.367  1.00 28.65      A   
ATOM    554  CE1 PHE    75      31.164  19.712  33.000  1.00 25.68      A   
ATOM    555  CE2 PHE    75      32.241  21.771  33.692  1.00 28.59      A   
ATOM    556  CZ  PHE    75      32.285  20.375  33.506  1.00 28.50      A   
ATOM    557  C   PHE    75      27.237  21.455  34.128  1.00 25.44      A   
ATOM    558  O   PHE    75      27.764  20.928  35.107  1.00 26.99      A   
ATOM    559  N   LEU    76      26.224  20.908  33.464  1.00 25.34      A   
ATOM    560  CA  LEU    76      25.661  19.615  33.832  1.00 25.23      A   
ATOM    561  CB  LEU    76      24.162  19.579  33.505  1.00 29.09      A   
ATOM    562  CG  LEU    76      23.305  20.609  34.243  1.00 32.39      A   
ATOM    563  CD1 LEU    76      21.852  20.511  33.803  1.00 33.79      A   
ATOM    564  CD2 LEU    76      23.432  20.354  35.744  1.00 30.67      A   
ATOM    565  C   LEU    76      26.363  18.496  33.084  1.00 26.07      A   
ATOM    566  O   LEU    76      26.751  18.667  31.935  1.00 24.95      A   
ATOM    567  N   ALA    77      26.540  17.355  33.739  1.00 22.60      A   
ATOM    568  CA  ALA    77      27.177  16.230  33.077  1.00 24.61      A   
ATOM    569  CB  ALA    77      28.713  16.251  33.315  1.00 33.80      A   
ATOM    570  C   ALA    77      26.572  14.960  33.624  1.00 24.60      A   
ATOM    571  O   ALA    77      26.036  14.945  34.732  1.00 25.29      A   
ATOM    572  N   PRO    78      26.617  13.876  32.842  1.00 25.80      A   
ATOM    573  CD  PRO    78      27.189  13.690  31.497  1.00 32.45      A   
ATOM    574  CA  PRO    78      26.048  12.631  33.351  1.00 26.85      A   
ATOM    575  CB  PRO    78      26.263  11.648  32.194  1.00 31.58      A   
ATOM    576  CG  PRO    78      27.464  12.200  31.481  1.00 32.92      A   
ATOM    577  C   PRO    78      26.820  12.245  34.612  1.00 28.40      A   
ATOM    578  O   PRO    78      28.010  12.519  34.722  1.00 27.48      A   
ATOM    579  N   ALA    79      26.137  11.635  35.570  1.00 28.15      A   
ATOM    580  CA  ALA    79      26.780  11.240  36.811  1.00 32.75      A   
ATOM    581  CB  ALA    79      25.735  10.691  37.789  1.00 37.42      A   
ATOM    582  C   ALA    79      27.832  10.179  36.541  1.00 35.06      A   
ATOM    583  O   ALA    79      28.909  10.193  37.125  1.00 36.08      A   
ATOM    584  N   ARG    80      27.492   9.263  35.642  1.00 41.92      A   
ATOM    585  CA  ARG    80      28.339   8.133  35.266  1.00 46.18      A   
ATOM    586  CB  ARG    80      27.786   6.882  35.964  1.00 73.73      A   
ATOM    587  CG  ARG    80      28.511   5.572  35.732  1.00 79.35      A   
ATOM    588  CD  ARG    80      27.713   4.428  36.364  1.00 81.88      A   
ATOM    589  NE  ARG    80      28.500   3.208  36.494  1.00 85.97      A   
ATOM    590  CZ  ARG    80      29.561   3.084  37.286  1.00 87.59      A   
ATOM    591  NH1 ARG    80      29.967   4.110  38.025  1.00 88.43      A   
ATOM    592  NH2 ARG    80      30.217   1.933  37.340  1.00 88.57      A   
ATOM    593  C   ARG    80      28.209   8.006  33.749  1.00 47.15      A   
ATOM    594  O   ARG    80      27.216   8.471  33.180  1.00 46.35      A   
ATOM    595  N   LYS    81      29.184   7.387  33.084  1.00 38.64      A   
ATOM    596  CA  LYS    81      29.091   7.254  31.632  1.00 39.16      A   
ATOM    597  CB  LYS    81      30.202   6.368  31.060  1.00 63.40      A   
ATOM    598  CG  LYS    81      30.154   6.338  29.533  1.00 66.98      A   
ATOM    599  CD  LYS    81      30.962   5.215  28.914  1.00 70.58      A   
ATOM    600  CE  LYS    81      30.789   5.220  27.397  1.00 71.45      A   
ATOM    601  NZ  LYS    81      31.537   4.113  26.726  1.00 72.84      A   
ATOM    602  C   LYS    81      27.745   6.650  31.241  1.00 38.59      A   
ATOM    603  O   LYS    81      27.293   5.668  31.834  1.00 37.24      A   
ATOM    604  N   ASP    82      27.110   7.254  30.241  1.00 52.57      A   
ATOM    605  CA  ASP    82      25.816   6.807  29.730  1.00 52.05      A   
ATOM    606  CB  ASP    82      25.911   5.366  29.220  1.00 68.98      A   
ATOM    607  CG  ASP    82      27.001   5.185  28.182  1.00 70.72      A   
ATOM    608  OD1 ASP    82      27.046   5.992  27.231  1.00 72.42      A   
ATOM    609  OD2 ASP    82      27.804   4.235  28.316  1.00 72.35      A   
ATOM    610  C   ASP    82      24.682   6.897  30.740  1.00 50.43      A   
ATOM    611  O   ASP    82      23.577   6.408  30.490  1.00 51.73      A   
ATOM    612  N   SER    83      24.945   7.517  31.881  1.00 39.89      A   
ATOM    613  CA  SER    83      23.913   7.644  32.899  1.00 36.24      A   
ATOM    614  CB  SER    83      24.530   7.944  34.265  1.00 33.61      A   
ATOM    615  OG  SER    83      23.522   8.223  35.221  1.00 28.96      A   
ATOM    616  C   SER    83      22.911   8.738  32.572  1.00 33.85      A   
ATOM    617  O   SER    83      23.245   9.741  31.931  1.00 33.01      A   
ATOM    618  N   VAL    84      21.680   8.543  33.025  1.00 29.61      A   
ATOM    619  CA  VAL    84      20.651   9.537  32.810  1.00 29.31      A   
ATOM    620  CB  VAL    84      19.262   8.886  32.603  1.00 39.19      A   
ATOM    621  CG1 VAL    84      19.294   7.998  31.360  1.00 39.94      A   
ATOM    622  CG2 VAL    84      18.858   8.081  33.831  1.00 40.95      A   
ATOM    623  C   VAL    84      20.641  10.458  34.032  1.00 28.11      A   
ATOM    624  O   VAL    84      19.996  11.503  34.020  1.00 26.08      A   
ATOM    625  N   LYS    85      21.366  10.070  35.084  1.00 22.87      A   
ATOM    626  CA  LYS    85      21.445  10.895  36.293  1.00 22.83      A   
ATOM    627  CB  LYS    85      22.032  10.112  37.478  1.00 22.58      A   
ATOM    628  CG  LYS    85      21.174   8.979  38.029  1.00 28.58      A   
ATOM    629  CD  LYS    85      21.958   8.197  39.104  1.00 30.17      A   
ATOM    630  CE  LYS    85      21.265   6.899  39.500  1.00 34.34      A   
ATOM    631  NZ  LYS    85      22.133   6.072  40.407  1.00 31.90      A   
ATOM    632  C   LYS    85      22.382  12.043  35.974  1.00 22.94      A   
ATOM    633  O   LYS    85      23.359  11.853  35.252  1.00 22.47      A   
ATOM    634  N   VAL    86      22.135  13.217  36.543  1.00 27.51      A   
ATOM    635  CA  VAL    86      22.988  14.356  36.220  1.00 27.63      A   
ATOM    636  CB  VAL    86      22.190  15.440  35.448  1.00 25.37      A   
ATOM    637  CG1 VAL    86      21.432  14.805  34.289  1.00 26.36      A   
ATOM    638  CG2 VAL    86      21.223  16.150  36.390  1.00 27.29      A   
ATOM    639  C   VAL    86      23.616  15.002  37.443  1.00 29.12      A   
ATOM    640  O   VAL    86      23.017  15.023  38.522  1.00 30.61      A   
ATOM    641  N   LYS    87      24.809  15.556  37.248  1.00 22.01      A   
ATOM    642  CA  LYS    87      25.548  16.208  38.314  1.00 24.43      A   
ATOM    643  CB  LYS    87      26.761  15.336  38.671  1.00 40.98      A   
ATOM    644  CG  LYS    87      27.433  15.627  40.001  1.00 46.69      A   
ATOM    645  CD  LYS    87      28.325  14.450  40.447  1.00 48.24      A   
ATOM    646  CE  LYS    87      27.499  13.214  40.797  1.00 51.31      A   
ATOM    647  NZ  LYS    87      28.341  12.049  41.233  1.00 55.32      A   
ATOM    648  C   LYS    87      25.984  17.591  37.836  1.00 23.09      A   
ATOM    649  O   LYS    87      26.281  17.787  36.657  1.00 22.07      A   
ATOM    650  N   LEU    88      25.987  18.555  38.748  1.00 24.75      A   
ATOM    651  CA  LEU    88      26.404  19.905  38.422  1.00 25.06      A   
ATOM    652  CB  LEU    88      25.617  20.921  39.247  1.00 23.11      A   
ATOM    653  CG  LEU    88      26.078  22.376  39.097  1.00 25.69      A   
ATOM    654  CD1 LEU    88      25.804  22.876  37.676  1.00 22.82      A   
ATOM    655  CD2 LEU    88      25.346  23.244  40.126  1.00 23.24      A   
ATOM    656  C   LEU    88      27.898  20.086  38.685  1.00 24.86      A   
ATOM    657  O   LEU    88      28.363  19.882  39.801  1.00 26.07      A   
ATOM    658  N   HIS    89      28.646  20.443  37.645  1.00 22.24      A   
ATOM    659  CA  HIS    89      30.079  20.678  37.772  1.00 22.99      A   
ATOM    660  CB  HIS    89      30.815  20.154  36.552  1.00 28.93      A   
ATOM    661  CG  HIS    89      30.842  18.660  36.478  1.00 32.11      A   
ATOM    662  CD2 HIS    89      29.846  17.745  36.531  1.00 29.81      A   
ATOM    663  ND1 HIS    89      32.012  17.945  36.332  1.00 33.49      A   
ATOM    664  CE1 HIS    89      31.734  16.654  36.296  1.00 32.57      A   
ATOM    665  NE2 HIS    89      30.426  16.505  36.413  1.00 31.69      A   
ATOM    666  C   HIS    89      30.294  22.168  37.932  1.00 23.14      A   
ATOM    667  O   HIS    89      30.226  22.933  36.974  1.00 21.94      A   
ATOM    668  N   LEU    90      30.546  22.556  39.176  1.00 25.38      A   
ATOM    669  CA  LEU    90      30.716  23.946  39.568  1.00 25.66      A   
ATOM    670  CB  LEU    90      30.891  24.017  41.093  1.00 24.41      A   
ATOM    671  CG  LEU    90      29.697  23.422  41.858  1.00 24.48      A   
ATOM    672  CD1 LEU    90      30.026  23.294  43.349  1.00 25.49      A   
ATOM    673  CD2 LEU    90      28.469  24.309  41.660  1.00 23.44      A   
ATOM    674  C   LEU    90      31.827  24.715  38.882  1.00 26.58      A   
ATOM    675  O   LEU    90      32.948  24.216  38.725  1.00 24.89      A   
ATOM    676  N   GLN    91      31.503  25.937  38.467  1.00 23.53      A   
ATOM    677  CA  GLN    91      32.473  26.808  37.815  1.00 25.88      A   
ATOM    678  CB  GLN    91      32.095  27.034  36.348  1.00 27.74      A   
ATOM    679  CG  GLN    91      32.159  25.782  35.506  1.00 28.30      A   
ATOM    680  CD  GLN    91      31.774  26.050  34.068  1.00 30.80      A   
ATOM    681  OE1 GLN    91      30.673  26.513  33.794  1.00 27.87      A   
ATOM    682  NE2 GLN    91      32.684  25.763  33.140  1.00 32.48      A   
ATOM    683  C   GLN    91      32.515  28.131  38.568  1.00 26.48      A   
ATOM    684  O   GLN    91      33.488  28.875  38.477  1.00 28.32      A   
ATOM    685  N   GLN    92      31.442  28.422  39.298  1.00 26.61      A   
ATOM    686  CA  GLN    92      31.355  29.626  40.113  1.00 27.30      A   
ATOM    687  CB  GLN    92      30.724  30.797  39.352  1.00 41.60      A   
ATOM    688  CG  GLN    92      31.445  31.244  38.093  1.00 45.91      A   
ATOM    689  CD  GLN    92      30.909  32.574  37.586  1.00 49.65      A   
ATOM    690  OE1 GLN    92      29.706  32.814  37.603  1.00 52.22      A   
ATOM    691  NE2 GLN    92      31.801  33.438  37.130  1.00 52.57      A   
ATOM    692  C   GLN    92      30.486  29.326  41.328  1.00 28.32      A   
ATOM    693  O   GLN    92      29.496  28.590  41.244  1.00 25.42      A   
ATOM    694  N   ALA    93      30.856  29.897  42.464  1.00 25.17      A   
ATOM    695  CA  ALA    93      30.080  29.688  43.672  1.00 28.30      A   
ATOM    696  CB  ALA    93      30.458  28.362  44.319  1.00 41.80      A   
ATOM    697  C   ALA    93      30.330  30.823  44.640  1.00 30.53      A   
ATOM    698  O   ALA    93      31.444  31.339  44.722  1.00 29.69      A   
ATOM    699  N   ARG    94      29.284  31.224  45.353  1.00 29.52      A   
ATOM    700  CA  ARG    94      29.399  32.275  46.349  1.00 36.47      A   
ATOM    701  CB  ARG    94      29.080  33.652  45.749  1.00 66.16      A   
ATOM    702  CG  ARG    94      27.760  33.735  45.008  1.00 71.03      A   
ATOM    703  CD  ARG    94      26.758  34.634  45.723  1.00 76.08      A   
ATOM    704  NE  ARG    94      27.222  36.015  45.829  1.00 79.33      A   
ATOM    705  CZ  ARG    94      26.520  37.001  46.383  1.00 81.20      A   
ATOM    706  NH1 ARG    94      27.029  38.225  46.436  1.00 82.52      A   
ATOM    707  NH2 ARG    94      25.308  36.771  46.878  1.00 82.63      A   
ATOM    708  C   ARG    94      28.478  31.973  47.525  1.00 39.20      A   
ATOM    709  O   ARG    94      27.302  31.636  47.360  1.00 37.22      A   
ATOM    710  N   ARG    95      29.048  32.083  48.717  1.00 48.54      A   
ATOM    711  CA  ARG    95      28.346  31.826  49.964  1.00 54.70      A   
ATOM    712  CB  ARG    95      29.371  31.419  51.026  1.00 65.41      A   
ATOM    713  CG  ARG    95      28.864  31.285  52.442  1.00 68.11      A   
ATOM    714  CD  ARG    95      29.987  30.725  53.310  1.00 70.28      A   
ATOM    715  NE  ARG    95      29.590  30.495  54.696  1.00 72.39      A   
ATOM    716  CZ  ARG    95      30.260  29.720  55.544  1.00 72.88      A   
ATOM    717  NH1 ARG    95      31.364  29.096  55.149  1.00 73.41      A   
ATOM    718  NH2 ARG    95      29.824  29.563  56.786  1.00 74.05      A   
ATOM    719  C   ARG    95      27.595  33.077  50.395  1.00 57.64      A   
ATOM    720  O   ARG    95      28.201  34.125  50.610  1.00 58.67      A   
ATOM    721  N   ILE    96      26.273  32.969  50.506  1.00 76.07      A   
ATOM    722  CA  ILE    96      25.449  34.102  50.916  1.00 79.88      A   
ATOM    723  CB  ILE    96      24.011  34.007  50.355  1.00 69.35      A   
ATOM    724  CG2 ILE    96      23.276  35.308  50.633  1.00 69.35      A   
ATOM    725  CG1 ILE    96      24.042  33.731  48.850  1.00 69.24      A   
ATOM    726  CD1 ILE    96      22.682  33.474  48.244  1.00 69.56      A   
ATOM    727  C   ILE    96      25.353  34.158  52.440  1.00 82.47      A   
ATOM    728  O   ILE    96      24.751  33.284  53.064  1.00 82.91      A   
ATOM    729  N   ALA    97      25.946  35.189  53.034  1.00 94.57      A   
ATOM    730  CA  ALA    97      25.927  35.352  54.483  1.00 97.13      A   
ATOM    731  CB  ALA    97      27.216  36.007  54.952  1.00 79.37      A   
ATOM    732  C   ALA    97      24.739  36.199  54.903  1.00 98.75      A   
ATOM    733  O   ALA    97      24.671  37.386  54.585  1.00 99.27      A   
ATOM    734  N   GLY    98      23.806  35.583  55.621  1.00 99.99      A   
ATOM    735  CA  GLY    98      22.629  36.298  56.077  1.00101.66      A   
ATOM    736  C   GLY    98      22.852  36.898  57.451  1.00102.77      A   
ATOM    737  O   GLY    98      23.977  36.751  57.976  1.00103.27      A   
ATOM    738  OXT GLY    98      21.912  37.513  58.004  1.00 93.70      A   
END
