
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  119 (  877),  selected  119 , name 1x3e_B
# Molecule2: number of CA atoms   98 (  734),  selected   98 , name T0491.pdb
# PARAMETERS: 1x3e_B.T0491.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    A     2_B      -       -           -
LGA    G     3_B      -       -           -
LGA    D     4_B      M       1          2.963
LGA    T     5_B      N       2          0.869
LGA    T     6_B      T       3          0.728
LGA    I     7_B      L       4          1.319
LGA    T     8_B      E       5          0.701
LGA    V     9_B      L       6          0.371
LGA    V    10_B      S       7          0.284
LGA    G    11_B      A       8          0.969
LGA    N    12_B      R       9          0.465
LGA    L    13_B      V      10          1.043
LGA    T    14_B      L      11          0.983
LGA    A    15_B      E      12          1.215
LGA    D    16_B      C      13          2.432
LGA    P    17_B      G      14          3.668
LGA    E    18_B      A      15          3.554
LGA    L    19_B      M      16          2.043
LGA    R    20_B      R      17          1.135
LGA    F    21_B      H      18          0.962
LGA    T    22_B      T      19          1.294
LGA    P    23_B      P      20          1.923
LGA    S    24_B      A      21          1.955
LGA    G    25_B      G      22          1.401
LGA    A    26_B      L      23          1.100
LGA    A    27_B      P      24          0.807
LGA    V    28_B      A      25          0.582
LGA    A    29_B      L      26          0.726
LGA    N    30_B      E      27          1.077
LGA    F    31_B      L      28          0.716
LGA    T    32_B      L      29          1.749
LGA    V    33_B      L      30          1.369
LGA    A    34_B      V      31          0.512
LGA    S    35_B      H      32          0.523
LGA    T    36_B      E      33          0.794
LGA    P    37_B      S      34          1.653
LGA    R    38_B      E      35          2.486
LGA    -       -      V      36           -
LGA    -       -      V      37           -
LGA    -       -      E      38           -
LGA    -       -      A      39           -
LGA    -       -      G      40           -
LGA    -       -      H      41           -
LGA    M    39_B      P      42          4.332
LGA    F    40_B      R      43           #
LGA    D    41_B      -       -           -
LGA    R    42_B      -       -           -
LGA    Q    43_B      -       -           -
LGA    S    44_B      -       -           -
LGA    G    45_B      -       -           -
LGA    E    46_B      -       -           -
LGA    W    47_B      -       -           -
LGA    K    48_B      -       -           -
LGA    D    49_B      -       -           -
LGA    G    50_B      R      44          2.202
LGA    E    51_B      V      45          4.133
LGA    A    52_B      E      46          1.202
LGA    L    53_B      L      47          0.791
LGA    F    54_B      T      48          1.249
LGA    L    55_B      I      49          1.690
LGA    R    56_B      S      50          1.300
LGA    C    57_B      A      51          1.029
LGA    N    58_B      V      52          1.117
LGA    I    59_B      A      53          1.146
LGA    W    60_B      L      54          0.969
LGA    R    61_B      G      55          1.464
LGA    E    62_B      D      56          2.306
LGA    A    63_B      L      57          1.968
LGA    A    64_B      A      58          0.536
LGA    E    65_B      L      59          1.271
LGA    N    66_B      L      60          1.508
LGA    V    67_B      L      61          0.818
LGA    A    68_B      A      62          0.108
LGA    E    69_B      D      63          4.547
LGA    S    70_B      -       -           -
LGA    L    71_B      T      64          1.365
LGA    T    72_B      P      65          2.241
LGA    R    73_B      L      66          1.366
LGA    G    74_B      G      67          0.924
LGA    S    75_B      T      68          0.918
LGA    R    76_B      E      69          0.722
LGA    V    77_B      M      70          0.302
LGA    I    78_B      Q      71          0.241
LGA    V    79_B      V      72          0.228
LGA    T    80_B      Q      73          1.007
LGA    G    81_B      G      74          0.853
LGA    R    82_B      F      75          1.259
LGA    L    83_B      L      76          1.669
LGA    K    84_B      A      77          1.744
LGA    Q    85_B      P      78          2.114
LGA    R    86_B      A      79          3.074
LGA    S    87_B      R      80          1.909
LGA    F    88_B      K      81          5.387
LGA    E    89_B      -       -           -
LGA    T    90_B      -       -           -
LGA    R    91_B      -       -           -
LGA    E    92_B      -       -           -
LGA    G    93_B      -       -           -
LGA    E    94_B      -       -           -
LGA    K    95_B      D      82          5.329
LGA    R    96_B      S      83          3.116
LGA    T    97_B      V      84          2.767
LGA    V    98_B      K      85          1.562
LGA    V    99_B      V      86          1.569
LGA    E   100_B      K      87          1.472
LGA    V   101_B      L      88          1.262
LGA    E   102_B      H      89          1.200
LGA    V   103_B      L      90          0.762
LGA    D   104_B      Q      91          0.986
LGA    E   105_B      Q      92          0.832
LGA    I   106_B      A      93          0.478
LGA    G   107_B      R      94          1.036
LGA    P   108_B      R      95          1.166
LGA    S   109_B      I      96          1.686
LGA    L   110_B      A      97          3.614
LGA    R   111_B      -       -           -
LGA    Y   112_B      -       -           -
LGA    A   113_B      G      98          1.266
LGA    T   114_B      -       -           -
LGA    A   115_B      -       -           -
LGA    K   116_B      -       -           -
LGA    V   117_B      -       -           -
LGA    N   118_B      -       -           -
LGA    K   119_B      -       -           -
LGA    A   120_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  119   98    5.0     91    1.88    14.29     85.318     4.596

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.809010 * X  +   0.553780 * Y  +  -0.197055 * Z  +  26.393864
  Y_new =   0.583142 * X  +   0.798259 * Y  +  -0.150757 * Z  +   8.589901
  Z_new =   0.073815 * X  +  -0.236875 * Y  +  -0.968732 * Z  +  76.393326 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.901778    0.239815  [ DEG:  -166.2596     13.7404 ]
  Theta =  -0.073883   -3.067710  [ DEG:    -4.2332   -175.7668 ]
  Phi   =   2.517036   -0.624556  [ DEG:   144.2156    -35.7844 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 1x3e_B                                        
REMARK     2: T0491.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 1x3e_B.T0491.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  119   98   5.0   91   1.88   14.29  85.318
REMARK  ---------------------------------------------------------- 
MOLECULE 1x3e_B
HEADER    DNA BINDING PROTEIN                     04-MAY-05   1X3E              
TITLE     CRYSTAL STRUCTURE OF THE SINGLE-STRANDED DNA-BINDING                  
TITLE    2 PROTEIN FROM MYCOBACTERIUM SMEGMATIS                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: SINGLE-STRAND BINDING PROTEIN;                             
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: SINGLE-STRANDED DNA-BINDING PROTEIN, SSB, HELIX-            
COMPND   5 DESTABILIZING PROTEIN;                                               
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: MYCOBACTERIUM SMEGMATIS;                        
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PET17B                                    
KEYWDS    OLIGONUCLEOTIDE BINDING FOLD, DNA-BINDING PROTEIN                     
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    K.SAIKRISHNAN,G.P.MANJUNATH,P.SINGH,J.JEYAKANTHAN,Z.DAUTER,           
AUTHOR   2 K.SEKAR,K.MUNIYAPPA,M.VIJAYAN                                        
REVDAT   1   15-AUG-05 1X3E    0                                                
JRNL        AUTH   K.SAIKRISHNAN,G.P.MANJUNATH,P.SINGH,J.JEYAKANTHAN,           
JRNL        AUTH 2 Z.DAUTER,K.SEKAR,K.MUNIYAPPA,M.VIJAYAN                       
JRNL        TITL   STRUCTURE OF MYCOBACTERIUM SMEGMATIS                         
JRNL        TITL 2 SINGLE-STRANDED DNA-BINDING PROTEIN AND A                    
JRNL        TITL 3 COMPARATIVE STUDY INVOLVING HOMOLOGUS SSBS:                  
JRNL        TITL 4 BIOLOGICAL IMPLICATIONS OF STRUCTURAL PLASTICITY             
JRNL        TITL 5 AND VARIABILITY IN QUATERNARY ASSOCIATION.                   
JRNL        REF    ACTA CRYSTALLOGR.,SECT.D      V.  61  1140 2005              
JRNL        REFN   ASTM ABCRE6  DK ISSN 0907-4449                               
REMARK   2 RESOLUTION. 2.15 ANGSTROMS.                                          
DBREF  1X3E A    1   165  UNP    Q9AFI5   SSB_MYCSM        1    165             
DBREF  1X3E B    1   165  UNP    Q9AFI5   SSB_MYCSM        1    165             
SEQRES   1 A  165  MET ALA GLY ASP THR THR ILE THR VAL VAL GLY ASN LEU          
SEQRES   2 A  165  THR ALA ASP PRO GLU LEU ARG PHE THR PRO SER GLY ALA          
SEQRES   3 A  165  ALA VAL ALA ASN PHE THR VAL ALA SER THR PRO ARG MET          
SEQRES   4 A  165  PHE ASP ARG GLN SER GLY GLU TRP LYS ASP GLY GLU ALA          
SEQRES   5 A  165  LEU PHE LEU ARG CYS ASN ILE TRP ARG GLU ALA ALA GLU          
SEQRES   6 A  165  ASN VAL ALA GLU SER LEU THR ARG GLY SER ARG VAL ILE          
SEQRES   7 A  165  VAL THR GLY ARG LEU LYS GLN ARG SER PHE GLU THR ARG          
SEQRES   8 A  165  GLU GLY GLU LYS ARG THR VAL VAL GLU VAL GLU VAL ASP          
SEQRES   9 A  165  GLU ILE GLY PRO SER LEU ARG TYR ALA THR ALA LYS VAL          
SEQRES  10 A  165  ASN LYS ALA SER ARG SER GLY GLY GLY GLY GLY GLY PHE          
SEQRES  11 A  165  GLY SER GLY GLY GLY GLY SER ARG GLN SER GLU PRO LYS          
SEQRES  12 A  165  ASP ASP PRO TRP GLY SER ALA PRO ALA SER GLY SER PHE          
SEQRES  13 A  165  SER GLY ALA ASP ASP GLU PRO PRO PHE                          
SEQRES   1 B  165  MET ALA GLY ASP THR THR ILE THR VAL VAL GLY ASN LEU          
SEQRES   2 B  165  THR ALA ASP PRO GLU LEU ARG PHE THR PRO SER GLY ALA          
SEQRES   3 B  165  ALA VAL ALA ASN PHE THR VAL ALA SER THR PRO ARG MET          
SEQRES   4 B  165  PHE ASP ARG GLN SER GLY GLU TRP LYS ASP GLY GLU ALA          
SEQRES   5 B  165  LEU PHE LEU ARG CYS ASN ILE TRP ARG GLU ALA ALA GLU          
SEQRES   6 B  165  ASN VAL ALA GLU SER LEU THR ARG GLY SER ARG VAL ILE          
SEQRES   7 B  165  VAL THR GLY ARG LEU LYS GLN ARG SER PHE GLU THR ARG          
SEQRES   8 B  165  GLU GLY GLU LYS ARG THR VAL VAL GLU VAL GLU VAL ASP          
SEQRES   9 B  165  GLU ILE GLY PRO SER LEU ARG TYR ALA THR ALA LYS VAL          
SEQRES  10 B  165  ASN LYS ALA SER ARG SER GLY GLY GLY GLY GLY GLY PHE          
SEQRES  11 B  165  GLY SER GLY GLY GLY GLY SER ARG GLN SER GLU PRO LYS          
SEQRES  12 B  165  ASP ASP PRO TRP GLY SER ALA PRO ALA SER GLY SER PHE          
SEQRES  13 B  165  SER GLY ALA ASP ASP GLU PRO PRO PHE                          
HET     CD   1001       1                                                       
HETNAM      CD CADMIUM ION                                                      
FORMUL   3   CD    CD 2+                                                        
FORMUL   4  HOH   *243(H2 O)                                                    
CRYST1   78.620   78.620   79.834  90.00  90.00 120.00 P 31 2 1     12          
ATOM    822  N   ALA B   2      30.461  26.510  21.041  1.00 58.46           N  
ATOM    823  CA  ALA B   2      31.190  27.645  21.683  1.00 57.08           C  
ATOM    824  C   ALA B   2      30.581  27.934  23.044  1.00 55.96           C  
ATOM    825  O   ALA B   2      31.280  28.396  23.956  1.00 57.88           O  
ATOM    826  CB  ALA B   2      31.119  28.887  20.801  1.00 57.62           C  
ATOM    827  N   GLY B   3      29.276  27.687  23.172  1.00 52.60           N  
ATOM    828  CA  GLY B   3      28.553  27.876  24.417  1.00 49.55           C  
ATOM    829  C   GLY B   3      28.161  26.548  25.041  1.00 46.60           C  
ATOM    830  O   GLY B   3      27.474  25.723  24.429  1.00 46.40           O  
ATOM    831  N   ASP B   4      28.619  26.340  26.268  1.00 42.89           N  
ATOM    832  CA  ASP B   4      28.151  25.237  27.083  1.00 40.02           C  
ATOM    833  C   ASP B   4      26.760  25.595  27.639  1.00 36.55           C  
ATOM    834  O   ASP B   4      26.342  26.759  27.607  1.00 35.71           O  
ATOM    835  CB  ASP B   4      29.115  24.972  28.240  1.00 40.40           C  
ATOM    836  CG  ASP B   4      30.513  24.579  27.774  1.00 41.75           C  
ATOM    837  OD1 ASP B   4      31.089  25.301  26.933  1.00 43.13           O  
ATOM    838  OD2 ASP B   4      31.116  23.572  28.206  1.00 44.07           O  
ATOM    839  N   THR B   5      26.048  24.593  28.138  1.00 32.34           N  
ATOM    840  CA  THR B   5      24.784  24.834  28.800  1.00 29.37           C  
ATOM    841  C   THR B   5      25.040  25.244  30.231  1.00 27.58           C  
ATOM    842  O   THR B   5      25.549  24.487  31.031  1.00 26.53           O  
ATOM    843  CB  THR B   5      23.859  23.620  28.717  1.00 28.77           C  
ATOM    844  OG1 THR B   5      23.551  23.370  27.350  1.00 27.32           O  
ATOM    845  CG2 THR B   5      22.504  23.932  29.360  1.00 26.87           C  
ATOM    846  N   THR B   6      24.644  26.461  30.532  1.00 26.22           N  
ATOM    847  CA  THR B   6      25.044  27.149  31.730  1.00 26.06           C  
ATOM    848  C   THR B   6      23.859  27.283  32.646  1.00 25.11           C  
ATOM    849  O   THR B   6      22.726  27.305  32.204  1.00 24.76           O  
ATOM    850  CB  THR B   6      25.618  28.528  31.324  1.00 26.28           C  
ATOM    851  OG1 THR B   6      26.509  28.983  32.337  1.00 31.35           O  
ATOM    852  CG2 THR B   6      24.541  29.616  31.248  1.00 27.36           C  
ATOM    853  N   ILE B   7      24.115  27.392  33.931  1.00 24.67           N  
ATOM    854  CA  ILE B   7      23.042  27.421  34.900  1.00 24.41           C  
ATOM    855  C   ILE B   7      23.444  28.223  36.134  1.00 23.12           C  
ATOM    856  O   ILE B   7      24.614  28.294  36.494  1.00 20.55           O  
ATOM    857  CB  ILE B   7      22.658  25.959  35.301  1.00 25.39           C  
ATOM    858  CG1 ILE B   7      21.562  25.951  36.369  1.00 27.49           C  
ATOM    859  CG2 ILE B   7      23.913  25.178  35.791  1.00 26.43           C  
ATOM    860  CD1 ILE B   7      21.152  24.547  36.867  1.00 28.24           C  
ATOM    861  N   THR B   8      22.434  28.810  36.770  1.00 22.49           N  
ATOM    862  CA  THR B   8      22.554  29.422  38.090  1.00 23.31           C  
ATOM    863  C   THR B   8      21.546  28.765  39.042  1.00 23.37           C  
ATOM    864  O   THR B   8      20.368  28.686  38.741  1.00 23.45           O  
ATOM    865  CB  THR B   8      22.246  30.924  37.998  1.00 23.40           C  
ATOM    866  OG1 THR B   8      23.213  31.553  37.144  1.00 24.31           O  
ATOM    867  CG2 THR B   8      22.368  31.579  39.397  1.00 23.16           C  
ATOM    868  N   VAL B   9      22.010  28.275  40.172  1.00 24.40           N  
ATOM    869  CA  VAL B   9      21.132  27.706  41.165  1.00 25.49           C  
ATOM    870  C   VAL B   9      21.348  28.324  42.513  1.00 25.41           C  
ATOM    871  O   VAL B   9      22.478  28.534  42.956  1.00 25.35           O  
ATOM    872  CB  VAL B   9      21.367  26.192  41.397  1.00 26.51           C  
ATOM    873  CG1 VAL B   9      20.116  25.581  42.073  1.00 27.14           C  
ATOM    874  CG2 VAL B   9      21.686  25.508  40.122  1.00 28.71           C  
ATOM    875  N   VAL B  10      20.245  28.521  43.197  1.00 25.25           N  
ATOM    876  CA  VAL B  10      20.237  29.049  44.536  1.00 25.48           C  
ATOM    877  C   VAL B  10      19.598  27.988  45.407  1.00 25.39           C  
ATOM    878  O   VAL B  10      18.574  27.390  45.074  1.00 25.39           O  
ATOM    879  CB  VAL B  10      19.468  30.387  44.563  1.00 25.52           C  
ATOM    880  CG1 VAL B  10      19.297  30.915  46.004  1.00 25.97           C  
ATOM    881  CG2 VAL B  10      20.196  31.384  43.698  1.00 25.12           C  
ATOM    882  N   GLY B  11      20.213  27.721  46.532  1.00 25.99           N  
ATOM    883  CA  GLY B  11      19.659  26.701  47.403  1.00 25.82           C  
ATOM    884  C   GLY B  11      20.550  26.425  48.578  1.00 25.53           C  
ATOM    885  O   GLY B  11      21.464  27.174  48.846  1.00 25.11           O  
ATOM    886  N   ASN B  12      20.259  25.352  49.291  1.00 25.16           N  
ATOM    887  CA  ASN B  12      21.030  24.988  50.462  1.00 25.00           C  
ATOM    888  C   ASN B  12      21.772  23.689  50.221  1.00 24.06           C  
ATOM    889  O   ASN B  12      21.289  22.809  49.518  1.00 22.94           O  
ATOM    890  CB  ASN B  12      20.087  24.880  51.682  1.00 25.74           C  
ATOM    891  CG  ASN B  12      19.302  26.171  51.915  1.00 27.60           C  
ATOM    892  OD1 ASN B  12      18.182  26.319  51.430  1.00 32.51           O  
ATOM    893  ND2 ASN B  12      19.902  27.116  52.627  1.00 29.46           N  
ATOM    894  N   LEU B  13      22.958  23.562  50.795  1.00 23.99           N  
ATOM    895  CA  LEU B  13      23.650  22.287  50.748  1.00 24.73           C  
ATOM    896  C   LEU B  13      22.929  21.304  51.641  1.00 24.22           C  
ATOM    897  O   LEU B  13      22.550  21.647  52.750  1.00 24.53           O  
ATOM    898  CB  LEU B  13      25.090  22.412  51.201  1.00 25.86           C  
ATOM    899  CG  LEU B  13      26.026  23.358  50.474  1.00 28.02           C  
ATOM    900  CD1 LEU B  13      27.445  22.854  50.642  1.00 29.31           C  
ATOM    901  CD2 LEU B  13      25.686  23.515  49.033  1.00 30.12           C  
ATOM    902  N   THR B  14      22.712  20.093  51.150  1.00 24.42           N  
ATOM    903  CA  THR B  14      22.063  19.056  51.944  1.00 24.20           C  
ATOM    904  C   THR B  14      22.980  18.493  53.012  1.00 24.61           C  
ATOM    905  O   THR B  14      22.502  17.871  53.960  1.00 25.14           O  
ATOM    906  CB  THR B  14      21.616  17.868  51.073  1.00 24.38           C  
ATOM    907  OG1 THR B  14      22.737  17.345  50.348  1.00 22.75           O  
ATOM    908  CG2 THR B  14      20.580  18.273  50.015  1.00 24.88           C  
ATOM    909  N   ALA B  15      24.286  18.653  52.830  1.00 25.10           N  
ATOM    910  CA  ALA B  15      25.277  18.137  53.776  1.00 25.71           C  
ATOM    911  C   ALA B  15      26.574  18.916  53.662  1.00 26.39           C  
ATOM    912  O   ALA B  15      26.783  19.637  52.663  1.00 27.18           O  
ATOM    913  CB  ALA B  15      25.540  16.662  53.491  1.00 25.79           C  
ATOM    914  N   ASP B  16      27.463  18.766  54.646  1.00 26.64           N  
ATOM    915  CA  ASP B  16      28.822  19.325  54.523  1.00 27.62           C  
ATOM    916  C   ASP B  16      29.467  18.894  53.176  1.00 27.60           C  
ATOM    917  O   ASP B  16      29.310  17.751  52.746  1.00 27.71           O  
ATOM    918  CB  ASP B  16      29.753  18.892  55.682  1.00 27.62           C  
ATOM    919  CG  ASP B  16      29.295  19.392  57.046  1.00 28.70           C  
ATOM    920  OD1 ASP B  16      28.256  20.074  57.113  1.00 33.39           O  
ATOM    921  OD2 ASP B  16      29.875  19.115  58.128  1.00 28.03           O  
ATOM    922  N   PRO B  17      30.186  19.785  52.510  1.00 27.96           N  
ATOM    923  CA  PRO B  17      30.879  19.391  51.264  1.00 28.62           C  
ATOM    924  C   PRO B  17      31.838  18.200  51.447  1.00 28.19           C  
ATOM    925  O   PRO B  17      32.620  18.211  52.368  1.00 27.50           O  
ATOM    926  CB  PRO B  17      31.656  20.644  50.872  1.00 28.28           C  
ATOM    927  CG  PRO B  17      30.899  21.786  51.582  1.00 29.65           C  
ATOM    928  CD  PRO B  17      30.411  21.202  52.853  1.00 28.03           C  
ATOM    929  N   GLU B  18      31.737  17.186  50.593  1.00 28.44           N  
ATOM    930  CA  GLU B  18      32.666  16.066  50.609  1.00 29.06           C  
ATOM    931  C   GLU B  18      33.949  16.430  49.855  1.00 28.04           C  
ATOM    932  O   GLU B  18      33.904  16.654  48.652  1.00 27.58           O  
ATOM    933  CB  GLU B  18      32.015  14.863  49.945  1.00 30.11           C  
ATOM    934  CG  GLU B  18      30.806  14.328  50.696  1.00 34.12           C  
ATOM    935  CD  GLU B  18      30.043  13.269  49.924  1.00 39.03           C  
ATOM    936  OE1 GLU B  18      30.648  12.257  49.517  1.00 43.70           O  
ATOM    937  OE2 GLU B  18      28.828  13.454  49.725  1.00 45.26           O  
ATOM    938  N   LEU B  19      35.078  16.490  50.567  1.00 26.69           N  
ATOM    939  CA  LEU B  19      36.374  16.825  49.977  1.00 25.81           C  
ATOM    940  C   LEU B  19      37.273  15.594  49.798  1.00 25.33           C  
ATOM    941  O   LEU B  19      37.519  14.825  50.747  1.00 24.30           O  
ATOM    942  CB  LEU B  19      37.091  17.871  50.834  1.00 25.94           C  
ATOM    943  CG  LEU B  19      38.453  18.388  50.324  1.00 26.23           C  
ATOM    944  CD1 LEU B  19      38.269  19.226  49.067  1.00 26.47           C  
ATOM    945  CD2 LEU B  19      39.184  19.197  51.402  1.00 25.84           C  
ATOM    946  N   ARG B  20      37.741  15.414  48.565  1.00 24.53           N  
ATOM    947  CA  ARG B  20      38.668  14.344  48.218  1.00 25.08           C  
ATOM    948  C   ARG B  20      39.869  14.939  47.460  1.00 24.03           C  
ATOM    949  O   ARG B  20      39.889  16.108  47.075  1.00 22.10           O  
ATOM    950  CB  ARG B  20      37.987  13.280  47.339  1.00 25.59           C  
ATOM    951  CG  ARG B  20      36.697  12.659  47.894  1.00 29.81           C  
ATOM    952  CD  ARG B  20      35.863  11.761  46.877  1.00 34.88           C  
ATOM    953  NE  ARG B  20      36.347  11.817  45.482  1.00 39.13           N  
ATOM    954  CZ  ARG B  20      35.654  12.239  44.401  1.00 41.08           C  
ATOM    955  NH1 ARG B  20      36.250  12.248  43.206  1.00 42.81           N  
ATOM    956  NH2 ARG B  20      34.389  12.629  44.475  1.00 41.18           N  
ATOM    957  N   PHE B  21      40.858  14.099  47.244  1.00 23.67           N  
ATOM    958  CA  PHE B  21      42.041  14.453  46.467  1.00 24.06           C  
ATOM    959  C   PHE B  21      42.285  13.339  45.460  1.00 24.37           C  
ATOM    960  O   PHE B  21      42.288  12.183  45.825  1.00 24.88           O  
ATOM    961  CB  PHE B  21      43.240  14.655  47.399  1.00 23.40           C  
ATOM    962  CG  PHE B  21      43.033  15.767  48.392  1.00 23.90           C  
ATOM    963  CD1 PHE B  21      42.477  15.510  49.636  1.00 23.77           C  
ATOM    964  CD2 PHE B  21      43.361  17.093  48.064  1.00 22.93           C  
ATOM    965  CE1 PHE B  21      42.245  16.564  50.545  1.00 22.92           C  
ATOM    966  CE2 PHE B  21      43.155  18.130  48.965  1.00 21.72           C  
ATOM    967  CZ  PHE B  21      42.597  17.866  50.209  1.00 22.01           C  
ATOM    968  N   THR B  22      42.439  13.693  44.189  1.00 25.03           N  
ATOM    969  CA  THR B  22      42.814  12.747  43.144  1.00 25.21           C  
ATOM    970  C   THR B  22      44.183  12.174  43.428  1.00 25.64           C  
ATOM    971  O   THR B  22      44.909  12.699  44.276  1.00 26.11           O  
ATOM    972  CB  THR B  22      42.874  13.449  41.789  1.00 25.46           C  
ATOM    973  OG1 THR B  22      43.836  14.509  41.849  1.00 25.74           O  
ATOM    974  CG2 THR B  22      41.509  14.092  41.422  1.00 25.23           C  
ATOM    975  N   PRO B  23      44.578  11.131  42.709  1.00 25.69           N  
ATOM    976  CA  PRO B  23      45.935  10.615  42.886  1.00 25.77           C  
ATOM    977  C   PRO B  23      47.025  11.686  42.620  1.00 26.19           C  
ATOM    978  O   PRO B  23      48.076  11.659  43.275  1.00 24.76           O  
ATOM    979  CB  PRO B  23      46.011   9.404  41.929  1.00 25.76           C  
ATOM    980  CG  PRO B  23      44.811   9.413  41.105  1.00 26.62           C  
ATOM    981  CD  PRO B  23      43.821  10.396  41.679  1.00 25.93           C  
ATOM    982  N   SER B  24      46.770  12.655  41.727  1.00 26.41           N  
ATOM    983  CA  SER B  24      47.750  13.730  41.519  1.00 27.27           C  
ATOM    984  C   SER B  24      47.852  14.771  42.659  1.00 26.61           C  
ATOM    985  O   SER B  24      48.722  15.629  42.619  1.00 26.96           O  
ATOM    986  CB  SER B  24      47.432  14.481  40.248  1.00 27.57           C  
ATOM    987  OG  SER B  24      46.268  15.284  40.459  1.00 31.87           O  
ATOM    988  N   GLY B  25      46.948  14.721  43.632  1.00 26.16           N  
ATOM    989  CA  GLY B  25      46.911  15.691  44.708  1.00 25.62           C  
ATOM    990  C   GLY B  25      45.849  16.778  44.467  1.00 25.74           C  
ATOM    991  O   GLY B  25      45.541  17.525  45.381  1.00 24.73           O  
ATOM    992  N   ALA B  26      45.278  16.855  43.262  1.00 24.83           N  
ATOM    993  CA  ALA B  26      44.228  17.829  42.997  1.00 25.12           C  
ATOM    994  C   ALA B  26      43.003  17.562  43.849  1.00 25.55           C  
ATOM    995  O   ALA B  26      42.503  16.439  43.910  1.00 25.83           O  
ATOM    996  CB  ALA B  26      43.815  17.842  41.528  1.00 24.66           C  
ATOM    997  N   ALA B  27      42.509  18.625  44.466  1.00 25.41           N  
ATOM    998  CA  ALA B  27      41.339  18.570  45.311  1.00 24.85           C  
ATOM    999  C   ALA B  27      40.058  18.506  44.448  1.00 24.00           C  
ATOM   1000  O   ALA B  27      39.999  19.085  43.357  1.00 24.53           O  
ATOM   1001  CB  ALA B  27      41.315  19.776  46.194  1.00 24.95           C  
ATOM   1002  N   VAL B  28      39.070  17.757  44.924  1.00 22.68           N  
ATOM   1003  CA  VAL B  28      37.713  17.777  44.379  1.00 22.58           C  
ATOM   1004  C   VAL B  28      36.693  17.747  45.519  1.00 21.98           C  
ATOM   1005  O   VAL B  28      36.805  16.946  46.452  1.00 21.52           O  
ATOM   1006  CB  VAL B  28      37.464  16.624  43.359  1.00 22.54           C  
ATOM   1007  CG1 VAL B  28      37.810  15.277  43.950  1.00 22.56           C  
ATOM   1008  CG2 VAL B  28      36.018  16.632  42.869  1.00 23.02           C  
ATOM   1009  N   ALA B  29      35.719  18.647  45.443  1.00 21.58           N  
ATOM   1010  CA  ALA B  29      34.639  18.718  46.411  1.00 22.05           C  
ATOM   1011  C   ALA B  29      33.365  18.445  45.663  1.00 23.11           C  
ATOM   1012  O   ALA B  29      33.204  18.918  44.553  1.00 23.64           O  
ATOM   1013  CB  ALA B  29      34.562  20.088  47.069  1.00 21.64           C  
ATOM   1014  N   ASN B  30      32.475  17.673  46.277  1.00 23.31           N  
ATOM   1015  CA  ASN B  30      31.155  17.412  45.761  1.00 24.04           C  
ATOM   1016  C   ASN B  30      30.126  17.707  46.828  1.00 23.38           C  
ATOM   1017  O   ASN B  30      30.368  17.532  47.997  1.00 23.20           O  
ATOM   1018  CB  ASN B  30      31.046  15.959  45.329  1.00 25.06           C  
ATOM   1019  CG  ASN B  30      32.075  15.587  44.258  1.00 28.49           C  
ATOM   1020  OD1 ASN B  30      33.081  14.948  44.557  1.00 32.66           O  
ATOM   1021  ND2 ASN B  30      31.829  15.999  43.010  1.00 31.20           N  
ATOM   1022  N   PHE B  31      28.965  18.164  46.404  1.00 23.59           N  
ATOM   1023  CA  PHE B  31      27.865  18.481  47.304  1.00 23.98           C  
ATOM   1024  C   PHE B  31      26.583  18.597  46.482  1.00 24.31           C  
ATOM   1025  O   PHE B  31      26.627  18.684  45.264  1.00 23.20           O  
ATOM   1026  CB  PHE B  31      28.139  19.777  48.091  1.00 23.98           C  
ATOM   1027  CG  PHE B  31      28.583  20.921  47.227  1.00 23.55           C  
ATOM   1028  CD1 PHE B  31      29.934  21.183  47.032  1.00 23.84           C  
ATOM   1029  CD2 PHE B  31      27.650  21.700  46.574  1.00 25.75           C  
ATOM   1030  CE1 PHE B  31      30.323  22.187  46.212  1.00 27.34           C  
ATOM   1031  CE2 PHE B  31      28.038  22.718  45.746  1.00 24.71           C  
ATOM   1032  CZ  PHE B  31      29.373  22.965  45.564  1.00 27.87           C  
ATOM   1033  N   THR B  32      25.438  18.570  47.153  1.00 24.75           N  
ATOM   1034  CA  THR B  32      24.176  18.763  46.459  1.00 25.03           C  
ATOM   1035  C   THR B  32      23.427  19.993  46.958  1.00 24.02           C  
ATOM   1036  O   THR B  32      23.313  20.221  48.153  1.00 22.88           O  
ATOM   1037  CB  THR B  32      23.279  17.551  46.569  1.00 25.55           C  
ATOM   1038  OG1 THR B  32      22.930  17.361  47.930  1.00 31.54           O  
ATOM   1039  CG2 THR B  32      24.002  16.304  46.218  1.00 23.60           C  
ATOM   1040  N   VAL B  33      22.965  20.788  46.002  1.00 23.49           N  
ATOM   1041  CA  VAL B  33      22.129  21.928  46.276  1.00 24.08           C  
ATOM   1042  C   VAL B  33      20.667  21.491  46.217  1.00 24.21           C  
ATOM   1043  O   VAL B  33      20.222  20.921  45.224  1.00 23.66           O  
ATOM   1044  CB  VAL B  33      22.373  23.073  45.268  1.00 24.08           C  
ATOM   1045  CG1 VAL B  33      21.516  24.251  45.605  1.00 25.49           C  
ATOM   1046  CG2 VAL B  33      23.831  23.501  45.262  1.00 25.22           C  
ATOM   1047  N   ALA B  34      19.940  21.753  47.303  1.00 24.00           N  
ATOM   1048  CA  ALA B  34      18.510  21.599  47.361  1.00 24.21           C  
ATOM   1049  C   ALA B  34      17.875  22.973  47.095  1.00 24.16           C  
ATOM   1050  O   ALA B  34      18.017  23.885  47.895  1.00 24.90           O  
ATOM   1051  CB  ALA B  34      18.099  21.069  48.735  1.00 24.44           C  
ATOM   1052  N   SER B  35      17.218  23.106  45.948  1.00 23.85           N  
ATOM   1053  CA  SER B  35      16.584  24.347  45.493  1.00 23.90           C  
ATOM   1054  C   SER B  35      15.075  24.198  45.706  1.00 23.41           C  
ATOM   1055  O   SER B  35      14.448  23.384  45.061  1.00 22.27           O  
ATOM   1056  CB  SER B  35      16.880  24.552  44.000  1.00 24.02           C  
ATOM   1057  OG  SER B  35      16.290  25.716  43.451  1.00 23.86           O  
ATOM   1058  N   THR B  36      14.515  24.985  46.615  1.00 23.46           N  
ATOM   1059  CA  THR B  36      13.083  24.930  46.926  1.00 24.14           C  
ATOM   1060  C   THR B  36      12.340  26.073  46.231  1.00 24.04           C  
ATOM   1061  O   THR B  36      12.369  27.208  46.718  1.00 23.86           O  
ATOM   1062  CB  THR B  36      12.834  25.000  48.472  1.00 24.37           C  
ATOM   1063  OG1 THR B  36      13.752  25.919  49.088  1.00 24.83           O  
ATOM   1064  CG2 THR B  36      13.117  23.654  49.157  1.00 24.37           C  
ATOM   1065  N   PRO B  37      11.678  25.795  45.105  1.00 24.34           N  
ATOM   1066  CA  PRO B  37      10.868  26.819  44.430  1.00 24.84           C  
ATOM   1067  C   PRO B  37       9.592  27.111  45.232  1.00 25.49           C  
ATOM   1068  O   PRO B  37       9.347  26.460  46.252  1.00 25.33           O  
ATOM   1069  CB  PRO B  37      10.521  26.157  43.097  1.00 24.85           C  
ATOM   1070  CG  PRO B  37      10.453  24.714  43.440  1.00 24.73           C  
ATOM   1071  CD  PRO B  37      11.605  24.506  44.395  1.00 24.22           C  
ATOM   1072  N   ARG B  38       8.795  28.077  44.789  1.00 26.29           N  
ATOM   1073  CA  ARG B  38       7.569  28.442  45.520  1.00 26.90           C  
ATOM   1074  C   ARG B  38       6.479  28.903  44.573  1.00 27.14           C  
ATOM   1075  O   ARG B  38       6.709  29.788  43.753  1.00 27.33           O  
ATOM   1076  CB  ARG B  38       7.861  29.543  46.552  1.00 26.95           C  
ATOM   1077  CG  ARG B  38       9.059  29.246  47.468  1.00 27.24           C  
ATOM   1078  CD  ARG B  38       9.362  30.327  48.476  1.00 27.68           C  
ATOM   1079  NE  ARG B  38       8.355  30.391  49.534  1.00 27.90           N  
ATOM   1080  CZ  ARG B  38       8.442  31.161  50.617  1.00 27.92           C  
ATOM   1081  NH1 ARG B  38       9.499  31.949  50.808  1.00 27.84           N  
ATOM   1082  NH2 ARG B  38       7.463  31.145  51.519  1.00 27.76           N  
ATOM   1083  N   MET B  39       5.300  28.294  44.683  1.00 27.57           N  
ATOM   1084  CA  MET B  39       4.126  28.716  43.908  1.00 27.76           C  
ATOM   1085  C   MET B  39       3.180  29.589  44.739  1.00 27.93           C  
ATOM   1086  O   MET B  39       3.282  29.657  45.969  1.00 27.86           O  
ATOM   1087  CB  MET B  39       3.376  27.499  43.372  1.00 27.87           C  
ATOM   1088  N   PHE B  40       2.249  30.238  44.048  1.00 28.04           N  
ATOM   1089  CA  PHE B  40       1.263  31.101  44.692  1.00 28.25           C  
ATOM   1090  C   PHE B  40       0.249  30.320  45.536  1.00 28.35           C  
ATOM   1091  O   PHE B  40      -0.201  30.820  46.567  1.00 28.30           O  
ATOM   1092  CB  PHE B  40       0.533  31.951  43.645  1.00 28.24           C  
ATOM   1093  N   ASP B  41      -0.097  29.104  45.105  1.00 28.44           N  
ATOM   1094  CA  ASP B  41      -1.149  28.304  45.749  1.00 28.52           C  
ATOM   1095  C   ASP B  41      -2.475  29.063  45.806  1.00 28.63           C  
ATOM   1096  O   ASP B  41      -2.942  29.443  46.885  1.00 28.56           O  
ATOM   1097  CB  ASP B  41      -0.724  27.851  47.148  1.00 28.50           C  
ATOM   1098  N   ARG B  42      -3.071  29.279  44.635  1.00 28.78           N  
ATOM   1099  CA  ARG B  42      -4.382  29.921  44.536  1.00 29.06           C  
ATOM   1100  C   ARG B  42      -5.429  29.061  45.267  1.00 29.37           C  
ATOM   1101  O   ARG B  42      -5.075  28.087  45.937  1.00 29.55           O  
ATOM   1102  CB  ARG B  42      -4.764  30.152  43.062  1.00 29.01           C  
ATOM   1103  CG  ARG B  42      -5.644  31.376  42.801  1.00 28.53           C  
ATOM   1104  CD  ARG B  42      -4.882  32.672  42.598  1.00 28.15           C  
ATOM   1105  NE  ARG B  42      -5.775  33.829  42.506  1.00 27.89           N  
ATOM   1106  CZ  ARG B  42      -6.490  34.157  41.431  1.00 27.14           C  
ATOM   1107  NH1 ARG B  42      -7.264  35.234  41.463  1.00 27.09           N  
ATOM   1108  NH2 ARG B  42      -6.437  33.424  40.323  1.00 27.16           N  
ATOM   1109  N   GLN B  43      -6.706  29.416  45.140  1.00 29.59           N  
ATOM   1110  CA  GLN B  43      -7.760  28.790  45.927  1.00 29.83           C  
ATOM   1111  C   GLN B  43      -7.417  29.003  47.399  1.00 29.82           C  
ATOM   1112  O   GLN B  43      -7.011  28.063  48.098  1.00 29.89           O  
ATOM   1113  CB  GLN B  43      -7.886  27.293  45.583  1.00 29.91           C  
ATOM   1114  N   SER B  44      -7.541  30.258  47.840  1.00 29.55           N  
ATOM   1115  CA  SER B  44      -7.110  30.697  49.175  1.00 29.32           C  
ATOM   1116  C   SER B  44      -5.719  30.160  49.597  1.00 29.03           C  
ATOM   1117  O   SER B  44      -5.125  29.336  48.907  1.00 28.93           O  
ATOM   1118  CB  SER B  44      -8.182  30.356  50.218  1.00 29.15           C  
ATOM   1119  OG  SER B  44      -9.229  31.314  50.195  1.00 29.21           O  
ATOM   1120  N   GLY B  45      -5.205  30.649  50.722  1.00 28.89           N  
ATOM   1121  CA  GLY B  45      -3.942  30.176  51.268  1.00 28.84           C  
ATOM   1122  C   GLY B  45      -2.757  31.043  50.882  1.00 28.81           C  
ATOM   1123  O   GLY B  45      -2.774  31.710  49.845  1.00 28.86           O  
ATOM   1124  N   GLU B  46      -1.719  31.013  51.718  1.00 28.72           N  
ATOM   1125  CA  GLU B  46      -0.526  31.848  51.545  1.00 28.60           C  
ATOM   1126  C   GLU B  46       0.393  31.296  50.437  1.00 28.63           C  
ATOM   1127  O   GLU B  46      -0.073  31.007  49.337  1.00 28.53           O  
ATOM   1128  CB  GLU B  46       0.224  31.962  52.881  1.00 28.54           C  
ATOM   1129  CG  GLU B  46      -0.569  32.620  53.997  1.00 28.21           C  
ATOM   1130  CD  GLU B  46      -0.132  34.049  54.248  1.00 28.20           C  
ATOM   1131  OE1 GLU B  46       0.218  34.747  53.271  1.00 28.01           O  
ATOM   1132  OE2 GLU B  46      -0.137  34.474  55.421  1.00 28.38           O  
ATOM   1133  N   TRP B  47       1.691  31.164  50.720  1.00 28.71           N  
ATOM   1134  CA  TRP B  47       2.624  30.514  49.803  1.00 28.89           C  
ATOM   1135  C   TRP B  47       2.536  28.996  49.984  1.00 28.79           C  
ATOM   1136  O   TRP B  47       1.815  28.499  50.851  1.00 28.81           O  
ATOM   1137  CB  TRP B  47       4.068  30.962  50.074  1.00 29.00           C  
ATOM   1138  CG  TRP B  47       4.410  32.366  49.651  1.00 29.67           C  
ATOM   1139  CD1 TRP B  47       4.290  32.906  48.399  1.00 30.08           C  
ATOM   1140  CD2 TRP B  47       4.961  33.401  50.481  1.00 30.39           C  
ATOM   1141  NE1 TRP B  47       4.720  34.213  48.405  1.00 30.42           N  
ATOM   1142  CE2 TRP B  47       5.137  34.545  49.670  1.00 30.46           C  
ATOM   1143  CE3 TRP B  47       5.316  33.482  51.837  1.00 30.48           C  
ATOM   1144  CZ2 TRP B  47       5.652  35.750  50.167  1.00 30.51           C  
ATOM   1145  CZ3 TRP B  47       5.827  34.679  52.328  1.00 30.49           C  
ATOM   1146  CH2 TRP B  47       5.989  35.796  51.495  1.00 30.54           C  
ATOM   1147  N   LYS B  48       3.277  28.267  49.158  1.00 28.67           N  
ATOM   1148  CA  LYS B  48       3.437  26.827  49.325  1.00 28.59           C  
ATOM   1149  C   LYS B  48       4.715  26.387  48.622  1.00 28.60           C  
ATOM   1150  O   LYS B  48       4.844  26.550  47.408  1.00 28.68           O  
ATOM   1151  CB  LYS B  48       2.237  26.085  48.764  1.00 28.61           C  
ATOM   1152  N   ASP B  49       5.660  25.849  49.389  1.00 28.39           N  
ATOM   1153  CA  ASP B  49       6.898  25.327  48.823  1.00 28.41           C  
ATOM   1154  C   ASP B  49       6.597  24.291  47.742  1.00 28.46           C  
ATOM   1155  O   ASP B  49       5.728  23.433  47.927  1.00 28.22           O  
ATOM   1156  CB  ASP B  49       7.775  24.703  49.920  1.00 28.30           C  
ATOM   1157  CG  ASP B  49       8.432  25.907  50.576  1.00 28.00           C  
ATOM   1158  OD1 ASP B  49       9.042  25.725  51.646  1.00 27.43           O  
ATOM   1159  OD2 ASP B  49       8.403  27.064  50.100  1.00 27.01           O  
ATOM   1160  N   GLY B  50       7.301  24.398  46.612  1.00 28.35           N  
ATOM   1161  CA  GLY B  50       7.172  23.453  45.516  1.00 28.41           C  
ATOM   1162  C   GLY B  50       8.105  22.280  45.728  1.00 28.60           C  
ATOM   1163  O   GLY B  50       8.873  22.269  46.694  1.00 28.39           O  
ATOM   1164  N   GLU B  51       8.029  21.290  44.839  1.00 28.80           N  
ATOM   1165  CA  GLU B  51       8.967  20.167  44.857  1.00 29.07           C  
ATOM   1166  C   GLU B  51      10.426  20.643  44.709  1.00 28.72           C  
ATOM   1167  O   GLU B  51      10.756  21.384  43.785  1.00 29.03           O  
ATOM   1168  CB  GLU B  51       8.625  19.177  43.752  1.00 29.60           C  
ATOM   1169  N   ALA B  52      11.297  20.211  45.620  1.00 27.99           N  
ATOM   1170  CA  ALA B  52      12.689  20.620  45.580  1.00 27.74           C  
ATOM   1171  C   ALA B  52      13.442  19.920  44.456  1.00 26.81           C  
ATOM   1172  O   ALA B  52      13.109  18.809  44.046  1.00 28.39           O  
ATOM   1173  CB  ALA B  52      13.366  20.369  46.920  1.00 27.91           C  
ATOM   1174  N   LEU B  53      14.411  20.624  43.926  1.00 25.48           N  
ATOM   1175  CA  LEU B  53      15.305  20.112  42.921  1.00 24.75           C  
ATOM   1176  C   LEU B  53      16.618  19.887  43.640  1.00 24.52           C  
ATOM   1177  O   LEU B  53      17.046  20.731  44.386  1.00 24.32           O  
ATOM   1178  CB  LEU B  53      15.457  21.151  41.819  1.00 25.08           C  
ATOM   1179  CG  LEU B  53      16.527  20.948  40.753  1.00 24.13           C  
ATOM   1180  CD1 LEU B  53      16.174  19.776  39.838  1.00 25.55           C  
ATOM   1181  CD2 LEU B  53      16.648  22.226  39.995  1.00 23.90           C  
ATOM   1182  N   PHE B  54      17.217  18.722  43.450  1.00 24.57           N  
ATOM   1183  CA  PHE B  54      18.479  18.354  44.071  1.00 25.12           C  
ATOM   1184  C   PHE B  54      19.491  18.191  42.952  1.00 25.31           C  
ATOM   1185  O   PHE B  54      19.342  17.303  42.116  1.00 25.92           O  
ATOM   1186  CB  PHE B  54      18.338  17.031  44.809  1.00 24.95           C  
ATOM   1187  CG  PHE B  54      17.479  17.114  46.024  1.00 25.79           C  
ATOM   1188  CD1 PHE B  54      16.098  16.989  45.921  1.00 26.84           C  
ATOM   1189  CD2 PHE B  54      18.042  17.324  47.273  1.00 25.73           C  
ATOM   1190  CE1 PHE B  54      15.293  17.070  47.038  1.00 27.78           C  
ATOM   1191  CE2 PHE B  54      17.238  17.408  48.394  1.00 26.76           C  
ATOM   1192  CZ  PHE B  54      15.867  17.283  48.279  1.00 27.46           C  
ATOM   1193  N   LEU B  55      20.472  19.078  42.909  1.00 25.09           N  
ATOM   1194  CA  LEU B  55      21.540  19.015  41.926  1.00 25.64           C  
ATOM   1195  C   LEU B  55      22.891  18.758  42.561  1.00 25.58           C  
ATOM   1196  O   LEU B  55      23.365  19.523  43.417  1.00 25.16           O  
ATOM   1197  CB  LEU B  55      21.590  20.299  41.102  1.00 25.90           C  
ATOM   1198  CG  LEU B  55      20.418  20.420  40.118  1.00 26.75           C  
ATOM   1199  CD1 LEU B  55      20.371  21.808  39.580  1.00 28.38           C  
ATOM   1200  CD2 LEU B  55      20.530  19.407  38.976  1.00 28.02           C  
ATOM   1201  N   ARG B  56      23.487  17.643  42.159  1.00 25.64           N  
ATOM   1202  CA  ARG B  56      24.852  17.318  42.533  1.00 26.47           C  
ATOM   1203  C   ARG B  56      25.832  18.261  41.796  1.00 25.53           C  
ATOM   1204  O   ARG B  56      25.707  18.459  40.593  1.00 25.56           O  
ATOM   1205  CB  ARG B  56      25.136  15.858  42.190  1.00 26.92           C  
ATOM   1206  CG  ARG B  56      26.423  15.297  42.806  1.00 30.87           C  
ATOM   1207  CD  ARG B  56      26.569  15.539  44.301  1.00 35.11           C  
ATOM   1208  NE  ARG B  56      27.486  14.612  44.960  1.00 37.65           N  
ATOM   1209  CZ  ARG B  56      27.590  14.464  46.286  1.00 37.65           C  
ATOM   1210  NH1 ARG B  56      26.844  15.195  47.103  1.00 36.67           N  
ATOM   1211  NH2 ARG B  56      28.456  13.584  46.794  1.00 35.77           N  
ATOM   1212  N   CYS B  57      26.762  18.847  42.546  1.00 24.44           N  
ATOM   1213  CA  CYS B  57      27.732  19.808  42.054  1.00 24.19           C  
ATOM   1214  C   CYS B  57      29.162  19.311  42.291  1.00 23.98           C  
ATOM   1215  O   CYS B  57      29.453  18.743  43.332  1.00 24.71           O  
ATOM   1216  CB  CYS B  57      27.568  21.123  42.785  1.00 23.67           C  
ATOM   1217  SG  CYS B  57      25.955  21.902  42.556  1.00 25.32           S  
ATOM   1218  N   ASN B  58      30.035  19.557  41.327  1.00 23.26           N  
ATOM   1219  CA  ASN B  58      31.460  19.279  41.422  1.00 24.00           C  
ATOM   1220  C   ASN B  58      32.269  20.574  41.272  1.00 22.81           C  
ATOM   1221  O   ASN B  58      31.920  21.453  40.481  1.00 21.07           O  
ATOM   1222  CB  ASN B  58      31.896  18.301  40.304  1.00 23.89           C  
ATOM   1223  CG  ASN B  58      30.916  17.171  40.101  1.00 27.50           C  
ATOM   1224  OD1 ASN B  58      30.443  16.579  41.070  1.00 31.60           O  
ATOM   1225  ND2 ASN B  58      30.583  16.872  38.836  1.00 30.85           N  
ATOM   1226  N   ILE B  59      33.380  20.647  41.991  1.00 23.02           N  
ATOM   1227  CA  ILE B  59      34.293  21.787  41.908  1.00 23.43           C  
ATOM   1228  C   ILE B  59      35.726  21.341  42.235  1.00 22.78           C  
ATOM   1229  O   ILE B  59      35.914  20.441  43.031  1.00 21.09           O  
ATOM   1230  CB  ILE B  59      33.810  22.950  42.797  1.00 23.56           C  
ATOM   1231  CG1 ILE B  59      34.552  24.248  42.446  1.00 25.78           C  
ATOM   1232  CG2 ILE B  59      33.950  22.602  44.260  1.00 25.83           C  
ATOM   1233  CD1 ILE B  59      34.025  25.476  43.132  1.00 26.95           C  
ATOM   1234  N   TRP B  60      36.716  21.974  41.594  1.00 21.50           N  
ATOM   1235  CA  TRP B  60      38.084  21.509  41.643  1.00 21.90           C  
ATOM   1236  C   TRP B  60      39.081  22.474  42.277  1.00 21.66           C  
ATOM   1237  O   TRP B  60      38.880  23.691  42.309  1.00 20.59           O  
ATOM   1238  CB  TRP B  60      38.578  21.141  40.234  1.00 22.11           C  
ATOM   1239  CG  TRP B  60      37.881  19.978  39.660  1.00 23.02           C  
ATOM   1240  CD1 TRP B  60      36.651  19.975  39.060  1.00 25.40           C  
ATOM   1241  CD2 TRP B  60      38.340  18.634  39.635  1.00 24.34           C  
ATOM   1242  NE1 TRP B  60      36.320  18.704  38.660  1.00 24.67           N  
ATOM   1243  CE2 TRP B  60      37.342  17.860  38.997  1.00 25.81           C  
ATOM   1244  CE3 TRP B  60      39.508  17.997  40.065  1.00 24.06           C  
ATOM   1245  CZ2 TRP B  60      37.474  16.485  38.796  1.00 26.45           C  
ATOM   1246  CZ3 TRP B  60      39.637  16.643  39.863  1.00 25.84           C  
ATOM   1247  CH2 TRP B  60      38.627  15.896  39.237  1.00 26.40           C  
ATOM   1248  N   ARG B  61      40.169  21.870  42.761  1.00 21.83           N  
ATOM   1249  CA  ARG B  61      41.415  22.569  43.148  1.00 22.50           C  
ATOM   1250  C   ARG B  61      41.149  23.633  44.193  1.00 21.81           C  
ATOM   1251  O   ARG B  61      40.487  23.366  45.173  1.00 21.78           O  
ATOM   1252  CB  ARG B  61      42.137  23.160  41.915  1.00 22.54           C  
ATOM   1253  CG  ARG B  61      42.717  22.132  40.991  1.00 26.48           C  
ATOM   1254  CD  ARG B  61      42.724  22.457  39.489  1.00 32.49           C  
ATOM   1255  NE  ARG B  61      42.496  23.879  39.112  1.00 38.95           N  
ATOM   1256  CZ  ARG B  61      41.298  24.530  39.086  1.00 41.19           C  
ATOM   1257  NH1 ARG B  61      40.156  23.936  39.447  1.00 42.38           N  
ATOM   1258  NH2 ARG B  61      41.249  25.802  38.704  1.00 41.52           N  
ATOM   1259  N   GLU B  62      41.620  24.853  43.962  1.00 21.73           N  
ATOM   1260  CA  GLU B  62      41.623  25.841  45.027  1.00 21.95           C  
ATOM   1261  C   GLU B  62      40.235  26.151  45.447  1.00 21.79           C  
ATOM   1262  O   GLU B  62      39.943  26.199  46.642  1.00 21.63           O  
ATOM   1263  CB  GLU B  62      42.410  27.087  44.633  1.00 21.47           C  
ATOM   1264  CG  GLU B  62      43.860  26.746  44.281  1.00 21.80           C  
ATOM   1265  CD  GLU B  62      44.613  25.952  45.358  1.00 20.67           C  
ATOM   1266  OE1 GLU B  62      44.762  26.451  46.487  1.00 21.93           O  
ATOM   1267  OE2 GLU B  62      45.119  24.858  45.087  1.00 20.85           O  
ATOM   1268  N   ALA B  63      39.371  26.365  44.453  1.00 22.23           N  
ATOM   1269  CA  ALA B  63      37.971  26.634  44.685  1.00 22.05           C  
ATOM   1270  C   ALA B  63      37.309  25.541  45.522  1.00 21.54           C  
ATOM   1271  O   ALA B  63      36.476  25.854  46.354  1.00 21.65           O  
ATOM   1272  CB  ALA B  63      37.213  26.840  43.344  1.00 22.49           C  
ATOM   1273  N   ALA B  64      37.679  24.275  45.303  1.00 21.94           N  
ATOM   1274  CA  ALA B  64      37.145  23.156  46.108  1.00 21.90           C  
ATOM   1275  C   ALA B  64      37.593  23.260  47.578  1.00 21.79           C  
ATOM   1276  O   ALA B  64      36.793  23.138  48.505  1.00 21.78           O  
ATOM   1277  CB  ALA B  64      37.532  21.793  45.509  1.00 21.30           C  
ATOM   1278  N   GLU B  65      38.868  23.560  47.768  1.00 21.27           N  
ATOM   1279  CA  GLU B  65      39.382  23.807  49.098  1.00 21.43           C  
ATOM   1280  C   GLU B  65      38.677  24.975  49.775  1.00 21.18           C  
ATOM   1281  O   GLU B  65      38.362  24.889  50.934  1.00 20.71           O  
ATOM   1282  CB  GLU B  65      40.882  24.048  49.044  1.00 20.97           C  
ATOM   1283  CG  GLU B  65      41.662  22.861  48.473  1.00 20.59           C  
ATOM   1284  CD  GLU B  65      43.056  23.257  48.064  1.00 19.12           C  
ATOM   1285  OE1 GLU B  65      43.824  22.422  47.538  1.00 18.84           O  
ATOM   1286  OE2 GLU B  65      43.396  24.430  48.286  1.00 20.20           O  
ATOM   1287  N   ASN B  66      38.397  26.044  49.037  1.00 21.42           N  
ATOM   1288  CA  ASN B  66      37.757  27.223  49.619  1.00 21.65           C  
ATOM   1289  C   ASN B  66      36.325  26.876  50.050  1.00 22.23           C  
ATOM   1290  O   ASN B  66      35.850  27.345  51.084  1.00 21.35           O  
ATOM   1291  CB  ASN B  66      37.742  28.403  48.631  1.00 21.59           C  
ATOM   1292  CG  ASN B  66      39.126  28.984  48.334  1.00 20.50           C  
ATOM   1293  OD1 ASN B  66      40.020  28.972  49.172  1.00 21.44           O  
ATOM   1294  ND2 ASN B  66      39.287  29.529  47.140  1.00 18.08           N  
ATOM   1295  N   VAL B  67      35.647  26.052  49.241  1.00 23.24           N  
ATOM   1296  CA  VAL B  67      34.300  25.555  49.561  1.00 23.63           C  
ATOM   1297  C   VAL B  67      34.346  24.720  50.822  1.00 23.83           C  
ATOM   1298  O   VAL B  67      33.519  24.890  51.687  1.00 24.61           O  
ATOM   1299  CB  VAL B  67      33.709  24.700  48.409  1.00 23.52           C  
ATOM   1300  CG1 VAL B  67      32.665  23.756  48.903  1.00 24.59           C  
ATOM   1301  CG2 VAL B  67      33.128  25.593  47.298  1.00 23.39           C  
ATOM   1302  N   ALA B  68      35.316  23.806  50.923  1.00 24.66           N  
ATOM   1303  CA  ALA B  68      35.424  22.927  52.088  1.00 24.30           C  
ATOM   1304  C   ALA B  68      35.704  23.717  53.369  1.00 24.88           C  
ATOM   1305  O   ALA B  68      35.243  23.336  54.419  1.00 25.15           O  
ATOM   1306  CB  ALA B  68      36.493  21.883  51.869  1.00 24.27           C  
ATOM   1307  N   GLU B  69      36.447  24.818  53.261  1.00 24.92           N  
ATOM   1308  CA  GLU B  69      36.806  25.672  54.404  1.00 25.54           C  
ATOM   1309  C   GLU B  69      35.607  26.548  54.852  1.00 25.66           C  
ATOM   1310  O   GLU B  69      35.508  26.939  55.989  1.00 24.83           O  
ATOM   1311  CB  GLU B  69      38.032  26.564  54.023  1.00 26.61           C  
ATOM   1312  CG  GLU B  69      39.248  26.447  54.937  1.00 27.29           C  
ATOM   1313  CD  GLU B  69      40.374  27.436  54.711  1.00 27.25           C  
ATOM   1314  OE1 GLU B  69      41.172  27.219  53.774  1.00 23.44           O  
ATOM   1315  OE2 GLU B  69      40.524  28.383  55.529  1.00 29.96           O  
ATOM   1316  N   SER B  70      34.671  26.830  53.948  1.00 25.86           N  
ATOM   1317  CA  SER B  70      33.701  27.889  54.168  1.00 26.10           C  
ATOM   1318  C   SER B  70      32.255  27.442  54.284  1.00 26.48           C  
ATOM   1319  O   SER B  70      31.449  28.154  54.865  1.00 27.31           O  
ATOM   1320  CB  SER B  70      33.772  28.904  53.007  1.00 26.02           C  
ATOM   1321  OG  SER B  70      35.109  29.302  52.761  1.00 25.22           O  
ATOM   1322  N   LEU B  71      31.894  26.312  53.693  1.00 26.45           N  
ATOM   1323  CA  LEU B  71      30.480  25.927  53.624  1.00 25.96           C  
ATOM   1324  C   LEU B  71      30.222  24.639  54.400  1.00 25.68           C  
ATOM   1325  O   LEU B  71      31.114  23.820  54.584  1.00 25.18           O  
ATOM   1326  CB  LEU B  71      30.043  25.763  52.166  1.00 25.59           C  
ATOM   1327  CG  LEU B  71      30.312  26.936  51.204  1.00 25.79           C  
ATOM   1328  CD1 LEU B  71      29.742  26.607  49.821  1.00 25.71           C  
ATOM   1329  CD2 LEU B  71      29.679  28.233  51.749  1.00 25.76           C  
ATOM   1330  N   THR B  72      28.979  24.478  54.839  1.00 25.87           N  
ATOM   1331  CA  THR B  72      28.539  23.293  55.546  1.00 25.55           C  
ATOM   1332  C   THR B  72      27.099  22.983  55.206  1.00 26.21           C  
ATOM   1333  O   THR B  72      26.439  23.723  54.500  1.00 25.71           O  
ATOM   1334  CB  THR B  72      28.612  23.492  57.080  1.00 25.36           C  
ATOM   1335  OG1 THR B  72      27.827  24.630  57.447  1.00 25.03           O  
ATOM   1336  CG2 THR B  72      30.015  23.832  57.537  1.00 25.54           C  
ATOM   1337  N   ARG B  73      26.623  21.869  55.753  1.00 26.59           N  
ATOM   1338  CA  ARG B  73      25.234  21.483  55.691  1.00 26.91           C  
ATOM   1339  C   ARG B  73      24.353  22.694  56.011  1.00 25.94           C  
ATOM   1340  O   ARG B  73      24.566  23.387  57.006  1.00 25.28           O  
ATOM   1341  CB  ARG B  73      25.002  20.347  56.710  1.00 27.38           C  
ATOM   1342  CG  ARG B  73      23.568  20.034  57.024  1.00 30.34           C  
ATOM   1343  CD  ARG B  73      23.276  20.080  58.517  1.00 35.89           C  
ATOM   1344  NE  ARG B  73      24.125  19.152  59.261  1.00 39.24           N  
ATOM   1345  CZ  ARG B  73      24.353  19.220  60.576  1.00 43.50           C  
ATOM   1346  NH1 ARG B  73      23.793  20.176  61.322  1.00 44.13           N  
ATOM   1347  NH2 ARG B  73      25.144  18.315  61.163  1.00 45.99           N  
ATOM   1348  N   GLY B  74      23.366  22.936  55.156  1.00 25.59           N  
ATOM   1349  CA  GLY B  74      22.414  24.017  55.357  1.00 25.09           C  
ATOM   1350  C   GLY B  74      22.834  25.351  54.769  1.00 24.86           C  
ATOM   1351  O   GLY B  74      22.012  26.245  54.622  1.00 24.46           O  
ATOM   1352  N   SER B  75      24.107  25.501  54.428  1.00 24.60           N  
ATOM   1353  CA  SER B  75      24.577  26.756  53.871  1.00 25.15           C  
ATOM   1354  C   SER B  75      23.728  27.104  52.649  1.00 24.69           C  
ATOM   1355  O   SER B  75      23.505  26.282  51.781  1.00 23.93           O  
ATOM   1356  CB  SER B  75      26.054  26.669  53.498  1.00 25.48           C  
ATOM   1357  OG  SER B  75      26.896  26.745  54.640  1.00 27.94           O  
ATOM   1358  N   ARG B  76      23.192  28.307  52.636  1.00 25.44           N  
ATOM   1359  CA  ARG B  76      22.498  28.827  51.466  1.00 25.21           C  
ATOM   1360  C   ARG B  76      23.537  29.320  50.507  1.00 24.74           C  
ATOM   1361  O   ARG B  76      24.415  30.062  50.883  1.00 24.88           O  
ATOM   1362  CB  ARG B  76      21.584  29.976  51.843  1.00 25.80           C  
ATOM   1363  CG  ARG B  76      20.820  30.551  50.659  1.00 27.44           C  
ATOM   1364  CD  ARG B  76      19.892  31.685  51.008  1.00 29.30           C  
ATOM   1365  NE  ARG B  76      18.577  31.125  51.093  1.00 32.83           N  
ATOM   1366  CZ  ARG B  76      17.700  31.073  50.113  1.00 31.55           C  
ATOM   1367  NH1 ARG B  76      16.560  30.480  50.328  1.00 33.56           N  
ATOM   1368  NH2 ARG B  76      17.918  31.635  48.963  1.00 33.68           N  
ATOM   1369  N   VAL B  77      23.437  28.930  49.252  1.00 25.05           N  
ATOM   1370  CA  VAL B  77      24.448  29.268  48.278  1.00 24.83           C  
ATOM   1371  C   VAL B  77      23.883  29.688  46.922  1.00 26.01           C  
ATOM   1372  O   VAL B  77      22.779  29.312  46.543  1.00 27.18           O  
ATOM   1373  CB  VAL B  77      25.400  28.058  48.031  1.00 24.91           C  
ATOM   1374  CG1 VAL B  77      26.118  27.641  49.270  1.00 23.36           C  
ATOM   1375  CG2 VAL B  77      24.657  26.861  47.439  1.00 24.04           C  
ATOM   1376  N   ILE B  78      24.694  30.433  46.184  1.00 26.49           N  
ATOM   1377  CA  ILE B  78      24.479  30.747  44.781  1.00 26.90           C  
ATOM   1378  C   ILE B  78      25.585  30.035  44.003  1.00 26.55           C  
ATOM   1379  O   ILE B  78      26.755  30.159  44.337  1.00 25.73           O  
ATOM   1380  CB  ILE B  78      24.633  32.254  44.536  1.00 27.38           C  
ATOM   1381  CG1 ILE B  78      23.720  33.032  45.463  1.00 29.92           C  
ATOM   1382  CG2 ILE B  78      24.326  32.575  43.098  1.00 27.74           C  
ATOM   1383  CD1 ILE B  78      23.839  34.554  45.321  1.00 32.31           C  
ATOM   1384  N   VAL B  79      25.204  29.359  42.928  1.00 26.47           N  
ATOM   1385  CA  VAL B  79      26.109  28.567  42.126  1.00 26.88           C  
ATOM   1386  C   VAL B  79      25.842  28.840  40.659  1.00 26.89           C  
ATOM   1387  O   VAL B  79      24.688  28.832  40.251  1.00 25.68           O  
ATOM   1388  CB  VAL B  79      25.880  27.090  42.398  1.00 27.00           C  
ATOM   1389  CG1 VAL B  79      26.764  26.234  41.530  1.00 26.80           C  
ATOM   1390  CG2 VAL B  79      26.117  26.809  43.866  1.00 28.90           C  
ATOM   1391  N   THR B  80      26.917  29.112  39.913  1.00 26.39           N  
ATOM   1392  CA  THR B  80      26.927  29.110  38.464  1.00 27.37           C  
ATOM   1393  C   THR B  80      27.879  28.019  37.996  1.00 26.19           C  
ATOM   1394  O   THR B  80      28.899  27.756  38.638  1.00 26.64           O  
ATOM   1395  CB  THR B  80      27.476  30.426  37.907  1.00 28.28           C  
ATOM   1396  OG1 THR B  80      28.798  30.639  38.429  1.00 32.10           O  
ATOM   1397  CG2 THR B  80      26.728  31.583  38.422  1.00 30.06           C  
ATOM   1398  N   GLY B  81      27.561  27.417  36.865  1.00 24.87           N  
ATOM   1399  CA  GLY B  81      28.308  26.295  36.365  1.00 24.53           C  
ATOM   1400  C   GLY B  81      27.735  25.767  35.099  1.00 24.37           C  
ATOM   1401  O   GLY B  81      26.846  26.387  34.512  1.00 25.20           O  
ATOM   1402  N   ARG B  82      28.268  24.646  34.646  1.00 23.94           N  
ATOM   1403  CA  ARG B  82      27.824  24.045  33.414  1.00 23.96           C  
ATOM   1404  C   ARG B  82      27.187  22.710  33.739  1.00 22.88           C  
ATOM   1405  O   ARG B  82      27.730  21.950  34.558  1.00 22.16           O  
ATOM   1406  CB  ARG B  82      29.013  23.859  32.470  1.00 24.92           C  
ATOM   1407  CG  ARG B  82      29.593  25.174  31.946  1.00 28.92           C  
ATOM   1408  CD  ARG B  82      30.953  25.561  32.560  1.00 33.31           C  
ATOM   1409  NE  ARG B  82      31.974  24.520  32.347  1.00 35.67           N  
ATOM   1410  CZ  ARG B  82      32.875  24.110  33.254  1.00 38.07           C  
ATOM   1411  NH1 ARG B  82      32.942  24.631  34.478  1.00 39.51           N  
ATOM   1412  NH2 ARG B  82      33.724  23.151  32.930  1.00 40.63           N  
ATOM   1413  N   LEU B  83      26.048  22.435  33.107  1.00 22.33           N  
ATOM   1414  CA  LEU B  83      25.371  21.149  33.241  1.00 23.09           C  
ATOM   1415  C   LEU B  83      26.098  20.104  32.456  1.00 23.07           C  
ATOM   1416  O   LEU B  83      26.324  20.271  31.264  1.00 23.30           O  
ATOM   1417  CB  LEU B  83      23.943  21.201  32.711  1.00 23.15           C  
ATOM   1418  CG  LEU B  83      22.927  21.970  33.522  1.00 23.97           C  
ATOM   1419  CD1 LEU B  83      21.532  21.865  32.847  1.00 26.03           C  
ATOM   1420  CD2 LEU B  83      22.901  21.496  34.934  1.00 24.84           C  
ATOM   1421  N   LYS B  84      26.443  19.016  33.131  1.00 24.19           N  
ATOM   1422  CA  LYS B  84      27.128  17.878  32.510  1.00 25.41           C  
ATOM   1423  C   LYS B  84      26.411  16.575  32.851  1.00 25.46           C  
ATOM   1424  O   LYS B  84      25.859  16.406  33.938  1.00 26.23           O  
ATOM   1425  CB  LYS B  84      28.594  17.812  32.967  1.00 25.85           C  
ATOM   1426  CG  LYS B  84      29.492  18.932  32.386  1.00 29.08           C  
ATOM   1427  CD  LYS B  84      29.436  18.989  30.843  1.00 32.85           C  
ATOM   1428  CE  LYS B  84      30.598  19.823  30.247  1.00 35.97           C  
ATOM   1429  NZ  LYS B  84      30.651  21.243  30.759  1.00 36.74           N  
ATOM   1430  N   GLN B  85      26.410  15.663  31.905  1.00 25.30           N  
ATOM   1431  CA  GLN B  85      25.875  14.336  32.113  1.00 25.90           C  
ATOM   1432  C   GLN B  85      27.044  13.404  32.457  1.00 26.09           C  
ATOM   1433  O   GLN B  85      27.971  13.264  31.666  1.00 26.12           O  
ATOM   1434  CB  GLN B  85      25.175  13.873  30.824  1.00 25.59           C  
ATOM   1435  CG  GLN B  85      23.945  13.047  31.039  1.00 25.88           C  
ATOM   1436  CD  GLN B  85      22.816  13.435  30.116  1.00 26.53           C  
ATOM   1437  OE1 GLN B  85      23.040  13.744  28.951  1.00 25.61           O  
ATOM   1438  NE2 GLN B  85      21.591  13.396  30.629  1.00 28.86           N  
ATOM   1439  N   ARG B  86      27.002  12.791  33.635  1.00 26.31           N  
ATOM   1440  CA  ARG B  86      27.966  11.763  34.023  1.00 26.61           C  
ATOM   1441  C   ARG B  86      27.339  10.371  33.910  1.00 26.62           C  
ATOM   1442  O   ARG B  86      26.159  10.206  34.199  1.00 26.25           O  
ATOM   1443  CB  ARG B  86      28.431  12.006  35.460  1.00 26.78           C  
ATOM   1444  CG  ARG B  86      29.360  10.921  36.012  1.00 28.12           C  
ATOM   1445  CD  ARG B  86      30.491  11.433  36.884  1.00 29.72           C  
ATOM   1446  NE  ARG B  86      30.015  11.963  38.160  1.00 30.91           N  
ATOM   1447  CZ  ARG B  86      30.770  12.659  39.009  1.00 32.32           C  
ATOM   1448  NH1 ARG B  86      32.046  12.909  38.728  1.00 33.49           N  
ATOM   1449  NH2 ARG B  86      30.252  13.111  40.148  1.00 32.06           N  
ATOM   1450  N   SER B  87      28.139   9.380  33.500  1.00 27.02           N  
ATOM   1451  CA  SER B  87      27.719   7.965  33.468  1.00 27.36           C  
ATOM   1452  C   SER B  87      28.082   7.210  34.761  1.00 27.53           C  
ATOM   1453  O   SER B  87      29.183   7.369  35.292  1.00 27.56           O  
ATOM   1454  CB  SER B  87      28.354   7.235  32.277  1.00 27.34           C  
ATOM   1455  OG  SER B  87      28.184   7.962  31.073  1.00 27.50           O  
ATOM   1456  N   PHE B  88      27.149   6.388  35.246  1.00 27.82           N  
ATOM   1457  CA  PHE B  88      27.346   5.551  36.436  1.00 28.04           C  
ATOM   1458  C   PHE B  88      27.142   4.073  36.064  1.00 28.28           C  
ATOM   1459  O   PHE B  88      27.029   3.751  34.873  1.00 28.50           O  
ATOM   1460  CB  PHE B  88      26.379   5.970  37.536  1.00 28.04           C  
ATOM   1461  N   GLU B  89      27.106   3.189  37.069  1.00 28.44           N  
ATOM   1462  CA  GLU B  89      26.938   1.738  36.863  1.00 28.39           C  
ATOM   1463  C   GLU B  89      26.050   1.109  37.954  1.00 28.55           C  
ATOM   1464  O   GLU B  89      26.419   1.115  39.132  1.00 28.70           O  
ATOM   1465  CB  GLU B  89      28.313   1.053  36.861  1.00 28.35           C  
ATOM   1466  CG  GLU B  89      28.298  -0.437  36.523  1.00 28.06           C  
ATOM   1467  CD  GLU B  89      28.425  -1.342  37.741  1.00 28.04           C  
ATOM   1468  OE1 GLU B  89      29.301  -1.092  38.594  1.00 28.19           O  
ATOM   1469  OE2 GLU B  89      27.657  -2.322  37.839  1.00 27.38           O  
ATOM   1470  N   THR B  90      24.890   0.571  37.567  1.00 28.55           N  
ATOM   1471  CA  THR B  90      24.000  -0.119  38.512  1.00 28.52           C  
ATOM   1472  C   THR B  90      24.500  -1.527  38.820  1.00 28.48           C  
ATOM   1473  O   THR B  90      25.246  -2.113  38.037  1.00 28.53           O  
ATOM   1474  CB  THR B  90      22.520  -0.171  37.997  1.00 28.54           C  
ATOM   1475  OG1 THR B  90      21.703  -0.926  38.905  1.00 28.54           O  
ATOM   1476  CG2 THR B  90      22.379  -0.941  36.682  1.00 28.44           C  
ATOM   1477  N   ARG B  91      24.071  -2.062  39.963  1.00 28.44           N  
ATOM   1478  CA  ARG B  91      24.391  -3.438  40.369  1.00 28.40           C  
ATOM   1479  C   ARG B  91      23.683  -4.498  39.503  1.00 28.38           C  
ATOM   1480  O   ARG B  91      23.779  -5.698  39.785  1.00 28.49           O  
ATOM   1481  CB  ARG B  91      24.030  -3.657  41.853  1.00 28.40           C  
ATOM   1482  CG  ARG B  91      25.227  -3.769  42.790  1.00 28.14           C  
ATOM   1483  CD  ARG B  91      25.650  -5.204  43.088  1.00 27.87           C  
ATOM   1484  NE  ARG B  91      24.687  -5.914  43.933  1.00 27.43           N  
ATOM   1485  CZ  ARG B  91      24.533  -5.725  45.244  1.00 27.01           C  
ATOM   1486  NH1 ARG B  91      25.274  -4.838  45.904  1.00 26.70           N  
ATOM   1487  NH2 ARG B  91      23.623  -6.432  45.906  1.00 26.87           N  
ATOM   1488  N   GLU B  92      22.962  -4.047  38.473  1.00 28.26           N  
ATOM   1489  CA  GLU B  92      22.287  -4.920  37.513  1.00 28.11           C  
ATOM   1490  C   GLU B  92      22.866  -4.753  36.091  1.00 28.07           C  
ATOM   1491  O   GLU B  92      22.262  -5.210  35.118  1.00 28.11           O  
ATOM   1492  CB  GLU B  92      20.771  -4.644  37.526  1.00 28.10           C  
ATOM   1493  CG  GLU B  92      19.917  -5.769  38.114  1.00 27.97           C  
ATOM   1494  CD  GLU B  92      19.821  -5.746  39.636  1.00 27.78           C  
ATOM   1495  OE1 GLU B  92      19.790  -6.841  40.247  1.00 27.49           O  
ATOM   1496  OE2 GLU B  92      19.763  -4.644  40.229  1.00 27.27           O  
ATOM   1497  N   GLY B  93      24.028  -4.102  35.981  1.00 27.95           N  
ATOM   1498  CA  GLY B  93      24.785  -4.033  34.738  1.00 27.86           C  
ATOM   1499  C   GLY B  93      24.670  -2.763  33.909  1.00 27.81           C  
ATOM   1500  O   GLY B  93      25.624  -2.389  33.223  1.00 27.60           O  
ATOM   1501  N   GLU B  94      23.510  -2.113  33.956  1.00 27.84           N  
ATOM   1502  CA  GLU B  94      23.210  -0.983  33.071  1.00 27.88           C  
ATOM   1503  C   GLU B  94      23.921   0.323  33.448  1.00 27.94           C  
ATOM   1504  O   GLU B  94      24.288   0.545  34.602  1.00 27.70           O  
ATOM   1505  CB  GLU B  94      21.696  -0.758  33.008  1.00 27.89           C  
ATOM   1506  N   LYS B  95      24.109   1.181  32.449  1.00 28.05           N  
ATOM   1507  CA  LYS B  95      24.686   2.502  32.660  1.00 28.24           C  
ATOM   1508  C   LYS B  95      23.587   3.560  32.644  1.00 28.39           C  
ATOM   1509  O   LYS B  95      23.023   3.858  31.588  1.00 28.44           O  
ATOM   1510  CB  LYS B  95      25.729   2.803  31.596  1.00 28.26           C  
ATOM   1511  N   ARG B  96      23.285   4.114  33.820  1.00 28.50           N  
ATOM   1512  CA  ARG B  96      22.307   5.197  33.965  1.00 28.44           C  
ATOM   1513  C   ARG B  96      23.034   6.525  34.165  1.00 28.32           C  
ATOM   1514  O   ARG B  96      23.902   6.625  35.035  1.00 28.25           O  
ATOM   1515  CB  ARG B  96      21.373   4.929  35.157  1.00 28.43           C  
ATOM   1516  CG  ARG B  96      20.140   4.084  34.821  1.00 28.39           C  
ATOM   1517  CD  ARG B  96      18.995   4.869  34.180  1.00 28.42           C  
ATOM   1518  NE  ARG B  96      18.472   5.915  35.066  1.00 28.26           N  
ATOM   1519  CZ  ARG B  96      18.427   7.219  34.784  1.00 28.31           C  
ATOM   1520  NH1 ARG B  96      18.872   7.694  33.622  1.00 28.30           N  
ATOM   1521  NH2 ARG B  96      17.927   8.067  35.679  1.00 28.56           N  
ATOM   1522  N   THR B  97      22.673   7.535  33.366  1.00 28.29           N  
ATOM   1523  CA  THR B  97      23.251   8.879  33.490  1.00 28.31           C  
ATOM   1524  C   THR B  97      22.488   9.771  34.464  1.00 28.43           C  
ATOM   1525  O   THR B  97      21.316   9.550  34.763  1.00 28.12           O  
ATOM   1526  CB  THR B  97      23.346   9.614  32.118  1.00 28.28           C  
ATOM   1527  OG1 THR B  97      22.039   9.958  31.635  1.00 27.62           O  
ATOM   1528  CG2 THR B  97      23.946   8.727  31.032  1.00 28.35           C  
ATOM   1529  N   VAL B  98      23.188  10.790  34.946  1.00 29.10           N  
ATOM   1530  CA  VAL B  98      22.609  11.817  35.807  1.00 29.04           C  
ATOM   1531  C   VAL B  98      23.236  13.159  35.460  1.00 29.24           C  
ATOM   1532  O   VAL B  98      24.414  13.227  35.142  1.00 29.42           O  
ATOM   1533  CB  VAL B  98      22.829  11.474  37.301  1.00 29.20           C  
ATOM   1534  CG1 VAL B  98      24.339  11.446  37.665  1.00 29.48           C  
ATOM   1535  CG2 VAL B  98      22.055  12.448  38.201  1.00 29.41           C  
ATOM   1536  N   VAL B  99      22.447  14.225  35.535  1.00 29.43           N  
ATOM   1537  CA  VAL B  99      22.907  15.576  35.236  1.00 29.35           C  
ATOM   1538  C   VAL B  99      23.513  16.200  36.492  1.00 29.37           C  
ATOM   1539  O   VAL B  99      22.904  16.189  37.551  1.00 29.91           O  
ATOM   1540  CB  VAL B  99      21.728  16.452  34.709  1.00 29.25           C  
ATOM   1541  CG1 VAL B  99      22.192  17.851  34.380  1.00 30.31           C  
ATOM   1542  CG2 VAL B  99      21.098  15.814  33.467  1.00 29.47           C  
ATOM   1543  N   GLU B 100      24.724  16.736  36.375  1.00 28.97           N  
ATOM   1544  CA  GLU B 100      25.378  17.408  37.479  1.00 28.56           C  
ATOM   1545  C   GLU B 100      25.865  18.772  37.032  1.00 27.11           C  
ATOM   1546  O   GLU B 100      25.967  19.056  35.855  1.00 27.29           O  
ATOM   1547  CB  GLU B 100      26.592  16.616  37.959  1.00 29.07           C  
ATOM   1548  CG  GLU B 100      26.313  15.187  38.359  1.00 31.64           C  
ATOM   1549  CD  GLU B 100      27.579  14.438  38.740  1.00 34.18           C  
ATOM   1550  OE1 GLU B 100      28.641  14.571  38.043  1.00 36.44           O  
ATOM   1551  OE2 GLU B 100      27.492  13.715  39.744  1.00 36.37           O  
ATOM   1552  N   VAL B 101      26.205  19.594  37.996  1.00 25.68           N  
ATOM   1553  CA  VAL B 101      26.766  20.902  37.738  1.00 25.25           C  
ATOM   1554  C   VAL B 101      28.282  20.880  37.952  1.00 24.73           C  
ATOM   1555  O   VAL B 101      28.768  20.603  39.048  1.00 24.14           O  
ATOM   1556  CB  VAL B 101      26.147  21.960  38.660  1.00 25.37           C  
ATOM   1557  CG1 VAL B 101      26.692  23.353  38.326  1.00 25.55           C  
ATOM   1558  CG2 VAL B 101      24.614  21.951  38.545  1.00 25.64           C  
ATOM   1559  N   GLU B 102      29.013  21.176  36.895  1.00 23.78           N  
ATOM   1560  CA  GLU B 102      30.422  21.528  36.997  1.00 24.20           C  
ATOM   1561  C   GLU B 102      30.472  22.998  37.395  1.00 22.69           C  
ATOM   1562  O   GLU B 102      30.176  23.890  36.618  1.00 22.38           O  
ATOM   1563  CB  GLU B 102      31.107  21.267  35.646  1.00 24.84           C  
ATOM   1564  CG  GLU B 102      32.591  20.989  35.704  1.00 31.12           C  
ATOM   1565  CD  GLU B 102      32.928  19.594  36.200  1.00 36.66           C  
ATOM   1566  OE1 GLU B 102      33.269  19.490  37.403  1.00 41.04           O  
ATOM   1567  OE2 GLU B 102      32.875  18.629  35.389  1.00 39.91           O  
ATOM   1568  N   VAL B 103      30.831  23.257  38.630  1.00 22.96           N  
ATOM   1569  CA  VAL B 103      30.728  24.602  39.180  1.00 22.97           C  
ATOM   1570  C   VAL B 103      31.805  25.537  38.646  1.00 23.37           C  
ATOM   1571  O   VAL B 103      32.969  25.203  38.667  1.00 22.69           O  
ATOM   1572  CB  VAL B 103      30.810  24.565  40.682  1.00 22.70           C  
ATOM   1573  CG1 VAL B 103      30.901  25.966  41.269  1.00 23.48           C  
ATOM   1574  CG2 VAL B 103      29.614  23.823  41.263  1.00 24.31           C  
ATOM   1575  N   ASP B 104      31.389  26.715  38.174  1.00 24.13           N  
ATOM   1576  CA  ASP B 104      32.319  27.782  37.783  1.00 25.57           C  
ATOM   1577  C   ASP B 104      32.594  28.672  38.996  1.00 25.47           C  
ATOM   1578  O   ASP B 104      33.730  28.888  39.355  1.00 25.48           O  
ATOM   1579  CB  ASP B 104      31.749  28.662  36.667  1.00 25.92           C  
ATOM   1580  CG  ASP B 104      31.681  27.961  35.326  1.00 29.44           C  
ATOM   1581  OD1 ASP B 104      32.637  27.224  35.021  1.00 36.03           O  
ATOM   1582  OD2 ASP B 104      30.751  28.122  34.484  1.00 31.69           O  
ATOM   1583  N   GLU B 105      31.532  29.216  39.584  1.00 25.91           N  
ATOM   1584  CA  GLU B 105      31.634  30.040  40.778  1.00 26.40           C  
ATOM   1585  C   GLU B 105      30.537  29.684  41.735  1.00 26.19           C  
ATOM   1586  O   GLU B 105      29.444  29.294  41.338  1.00 26.17           O  
ATOM   1587  CB  GLU B 105      31.524  31.546  40.434  1.00 27.17           C  
ATOM   1588  CG  GLU B 105      32.348  32.007  39.248  1.00 26.13           C  
ATOM   1589  CD  GLU B 105      33.490  32.905  39.620  1.00 25.58           C  
ATOM   1590  OE1 GLU B 105      33.667  33.320  40.783  1.00 27.52           O  
ATOM   1591  OE2 GLU B 105      34.219  33.231  38.710  1.00 28.03           O  
ATOM   1592  N   ILE B 106      30.850  29.814  43.014  1.00 26.48           N  
ATOM   1593  CA  ILE B 106      29.899  29.564  44.097  1.00 26.67           C  
ATOM   1594  C   ILE B 106      30.236  30.462  45.270  1.00 26.80           C  
ATOM   1595  O   ILE B 106      31.401  30.746  45.527  1.00 26.84           O  
ATOM   1596  CB  ILE B 106      29.961  28.097  44.560  1.00 27.61           C  
ATOM   1597  CG1 ILE B 106      29.046  27.913  45.775  1.00 27.16           C  
ATOM   1598  CG2 ILE B 106      31.430  27.683  44.892  1.00 25.26           C  
ATOM   1599  CD1 ILE B 106      28.729  26.523  46.055  1.00 30.51           C  
ATOM   1600  N   GLY B 107      29.212  30.871  46.006  1.00 27.53           N  
ATOM   1601  CA  GLY B 107      29.369  31.690  47.204  1.00 26.93           C  
ATOM   1602  C   GLY B 107      28.178  31.594  48.152  1.00 26.43           C  
ATOM   1603  O   GLY B 107      27.077  31.253  47.733  1.00 26.77           O  
ATOM   1604  N   PRO B 108      28.384  31.881  49.436  1.00 25.66           N  
ATOM   1605  CA  PRO B 108      27.260  31.865  50.389  1.00 25.03           C  
ATOM   1606  C   PRO B 108      26.344  33.068  50.159  1.00 24.01           C  
ATOM   1607  O   PRO B 108      26.826  34.200  50.028  1.00 23.60           O  
ATOM   1608  CB  PRO B 108      27.953  31.929  51.755  1.00 24.48           C  
ATOM   1609  CG  PRO B 108      29.230  32.656  51.496  1.00 25.64           C  
ATOM   1610  CD  PRO B 108      29.666  32.223  50.098  1.00 25.36           C  
ATOM   1611  N   SER B 109      25.045  32.826  50.054  1.00 23.02           N  
ATOM   1612  CA  SER B 109      24.105  33.930  49.913  1.00 22.57           C  
ATOM   1613  C   SER B 109      24.090  34.787  51.175  1.00 21.58           C  
ATOM   1614  O   SER B 109      24.127  34.266  52.272  1.00 21.67           O  
ATOM   1615  CB  SER B 109      22.684  33.428  49.659  1.00 22.34           C  
ATOM   1616  OG  SER B 109      21.808  34.517  49.703  1.00 21.54           O  
ATOM   1617  N   LEU B 110      23.980  36.094  50.984  1.00 20.95           N  
ATOM   1618  CA  LEU B 110      23.845  37.044  52.061  1.00 20.94           C  
ATOM   1619  C   LEU B 110      22.383  37.385  52.417  1.00 21.08           C  
ATOM   1620  O   LEU B 110      22.100  38.316  53.169  1.00 20.29           O  
ATOM   1621  CB  LEU B 110      24.625  38.304  51.696  1.00 20.58           C  
ATOM   1622  CG  LEU B 110      26.123  38.070  51.510  1.00 20.51           C  
ATOM   1623  CD1 LEU B 110      26.813  39.434  51.399  1.00 20.02           C  
ATOM   1624  CD2 LEU B 110      26.757  37.234  52.622  1.00 20.97           C  
ATOM   1625  N   ARG B 111      21.458  36.615  51.866  1.00 22.00           N  
ATOM   1626  CA  ARG B 111      20.040  36.809  52.080  1.00 22.40           C  
ATOM   1627  C   ARG B 111      19.727  36.775  53.584  1.00 22.23           C  
ATOM   1628  O   ARG B 111      19.177  37.722  54.135  1.00 21.16           O  
ATOM   1629  CB  ARG B 111      19.312  35.701  51.331  1.00 23.22           C  
ATOM   1630  CG  ARG B 111      17.898  35.457  51.719  1.00 25.91           C  
ATOM   1631  CD  ARG B 111      16.910  36.209  50.934  1.00 30.38           C  
ATOM   1632  NE  ARG B 111      16.657  35.643  49.607  1.00 32.25           N  
ATOM   1633  CZ  ARG B 111      15.724  36.129  48.797  1.00 33.35           C  
ATOM   1634  NH1 ARG B 111      14.979  37.142  49.206  1.00 36.32           N  
ATOM   1635  NH2 ARG B 111      15.512  35.614  47.587  1.00 34.29           N  
ATOM   1636  N   TYR B 112      20.100  35.685  54.242  1.00 22.36           N  
ATOM   1637  CA  TYR B 112      19.816  35.529  55.665  1.00 22.85           C  
ATOM   1638  C   TYR B 112      21.097  35.418  56.496  1.00 22.49           C  
ATOM   1639  O   TYR B 112      21.036  35.063  57.660  1.00 22.69           O  
ATOM   1640  CB  TYR B 112      18.960  34.277  55.914  1.00 23.38           C  
ATOM   1641  CG  TYR B 112      17.689  34.144  55.098  1.00 23.43           C  
ATOM   1642  CD1 TYR B 112      17.592  33.189  54.109  1.00 25.42           C  
ATOM   1643  CD2 TYR B 112      16.588  34.937  55.346  1.00 25.38           C  
ATOM   1644  CE1 TYR B 112      16.431  33.029  53.363  1.00 26.26           C  
ATOM   1645  CE2 TYR B 112      15.407  34.790  54.598  1.00 27.50           C  
ATOM   1646  CZ  TYR B 112      15.348  33.827  53.603  1.00 27.60           C  
ATOM   1647  OH  TYR B 112      14.217  33.647  52.840  1.00 29.43           O  
ATOM   1648  N   ALA B 113      22.243  35.725  55.903  1.00 22.16           N  
ATOM   1649  CA  ALA B 113      23.541  35.579  56.580  1.00 22.22           C  
ATOM   1650  C   ALA B 113      24.534  36.671  56.196  1.00 21.88           C  
ATOM   1651  O   ALA B 113      24.402  37.293  55.158  1.00 22.00           O  
ATOM   1652  CB  ALA B 113      24.143  34.210  56.290  1.00 21.93           C  
ATOM   1653  N   THR B 114      25.500  36.916  57.070  1.00 21.95           N  
ATOM   1654  CA  THR B 114      26.628  37.787  56.785  1.00 22.04           C  
ATOM   1655  C   THR B 114      27.839  36.898  56.578  1.00 22.83           C  
ATOM   1656  O   THR B 114      27.805  35.705  56.868  1.00 22.53           O  
ATOM   1657  CB  THR B 114      26.883  38.782  57.922  1.00 21.36           C  
ATOM   1658  OG1 THR B 114      27.389  38.099  59.071  1.00 21.93           O  
ATOM   1659  CG2 THR B 114      25.599  39.418  58.399  1.00 20.79           C  
ATOM   1660  N   ALA B 115      28.906  37.472  56.046  1.00 24.01           N  
ATOM   1661  CA  ALA B 115      30.134  36.719  55.821  1.00 24.71           C  
ATOM   1662  C   ALA B 115      31.360  37.593  56.020  1.00 25.29           C  
ATOM   1663  O   ALA B 115      31.359  38.774  55.644  1.00 26.16           O  
ATOM   1664  CB  ALA B 115      30.137  36.096  54.426  1.00 25.03           C  
ATOM   1665  N   LYS B 116      32.376  37.025  56.667  1.00 25.31           N  
ATOM   1666  CA  LYS B 116      33.696  37.623  56.715  1.00 25.95           C  
ATOM   1667  C   LYS B 116      34.521  36.995  55.597  1.00 26.18           C  
ATOM   1668  O   LYS B 116      34.825  35.804  55.626  1.00 25.94           O  
ATOM   1669  CB  LYS B 116      34.367  37.392  58.076  1.00 26.44           C  
ATOM   1670  N   VAL B 117      34.857  37.807  54.607  1.00 26.73           N  
ATOM   1671  CA  VAL B 117      35.505  37.344  53.407  1.00 27.89           C  
ATOM   1672  C   VAL B 117      36.987  37.523  53.598  1.00 28.45           C  
ATOM   1673  O   VAL B 117      37.427  38.558  54.072  1.00 28.27           O  
ATOM   1674  CB  VAL B 117      35.023  38.141  52.157  1.00 28.15           C  
ATOM   1675  CG1 VAL B 117      35.837  37.784  50.915  1.00 28.90           C  
ATOM   1676  CG2 VAL B 117      33.558  37.875  51.888  1.00 28.69           C  
ATOM   1677  N   ASN B 118      37.740  36.492  53.230  1.00 29.74           N  
ATOM   1678  CA  ASN B 118      39.188  36.509  53.262  1.00 30.87           C  
ATOM   1679  C   ASN B 118      39.765  36.101  51.898  1.00 30.82           C  
ATOM   1680  O   ASN B 118      39.663  34.938  51.483  1.00 30.67           O  
ATOM   1681  CB  ASN B 118      39.672  35.597  54.383  1.00 31.67           C  
ATOM   1682  CG  ASN B 118      39.236  36.100  55.780  1.00 35.94           C  
ATOM   1683  OD1 ASN B 118      39.723  37.153  56.269  1.00 37.56           O  
ATOM   1684  ND2 ASN B 118      38.286  35.375  56.411  1.00 38.72           N  
ATOM   1685  N   LYS B 119      40.361  37.069  51.213  1.00 31.15           N  
ATOM   1686  CA  LYS B 119      40.891  36.880  49.859  1.00 32.24           C  
ATOM   1687  C   LYS B 119      42.243  36.135  49.873  1.00 32.41           C  
ATOM   1688  O   LYS B 119      43.089  36.462  50.678  1.00 31.47           O  
ATOM   1689  CB  LYS B 119      41.090  38.243  49.170  1.00 32.30           C  
ATOM   1690  CG  LYS B 119      39.892  38.801  48.404  1.00 33.73           C  
ATOM   1691  CD  LYS B 119      40.378  39.834  47.382  1.00 34.73           C  
ATOM   1692  CE  LYS B 119      39.279  40.785  46.927  1.00 35.49           C  
ATOM   1693  NZ  LYS B 119      39.844  42.028  46.287  1.00 35.47           N  
ATOM   1694  N   ALA B 120      42.417  35.170  48.956  1.00 33.34           N  
ATOM   1695  CA  ALA B 120      43.644  34.362  48.803  1.00 34.21           C  
ATOM   1696  C   ALA B 120      44.798  35.205  48.300  1.00 34.70           C  
ATOM   1697  O   ALA B 120      44.569  36.293  47.769  1.00 35.92           O  
ATOM   1698  CB  ALA B 120      43.400  33.188  47.830  1.00 34.37           C  
TER    1699      ALA B 120                                                      
END
MOLECULE T0491.pdb
ATOM      1  CB  MET     1      24.494  26.786  25.043  1.00 74.26      A   
ATOM      2  CG  MET     1      23.701  27.585  26.072  1.00 83.32      A   
ATOM      3  SD  MET     1      24.779  28.804  27.139  1.00101.46      A   
ATOM      4  CE  MET     1      25.295  30.073  25.774  1.00 95.61      A   
ATOM      5  C   MET     1      25.321  25.000  26.603  1.00 28.93      A   
ATOM      6  O   MET     1      24.649  24.022  26.272  1.00 27.36      A   
ATOM      7  N   MET     1      26.470  25.414  24.459  1.00 32.31      A   
ATOM      8  CA  MET     1      25.731  26.058  25.583  1.00 34.03      A   
ATOM      9  N   ASN     2      25.748  25.199  27.844  1.00 27.92      A   
ATOM     10  CA  ASN     2      25.434  24.272  28.928  1.00 26.69      A   
ATOM     11  CB  ASN     2      26.294  23.018  28.793  1.00 24.03      A   
ATOM     12  CG  ASN     2      26.048  22.008  29.900  1.00 24.02      A   
ATOM     13  OD1 ASN     2      25.221  22.214  30.793  1.00 23.82      A   
ATOM     14  ND2 ASN     2      26.771  20.899  29.840  1.00 20.34      A   
ATOM     15  C   ASN     2      25.750  24.978  30.234  1.00 24.38      A   
ATOM     16  O   ASN     2      26.841  24.844  30.755  1.00 24.74      A   
ATOM     17  N   THR     3      24.797  25.741  30.750  1.00 21.49      A   
ATOM     18  CA  THR     3      25.026  26.468  31.987  1.00 24.29      A   
ATOM     19  CB  THR     3      25.575  27.893  31.722  1.00 27.90      A   
ATOM     20  OG1 THR     3      25.660  28.614  32.964  1.00 31.66      A   
ATOM     21  CG2 THR     3      24.655  28.654  30.771  1.00 28.43      A   
ATOM     22  C   THR     3      23.798  26.589  32.865  1.00 23.19      A   
ATOM     23  O   THR     3      22.763  27.126  32.470  1.00 25.48      A   
ATOM     24  N   LEU     4      23.934  26.069  34.073  1.00 23.57      A   
ATOM     25  CA  LEU     4      22.876  26.123  35.060  1.00 22.87      A   
ATOM     26  CB  LEU     4      22.698  24.767  35.738  1.00 24.04      A   
ATOM     27  CG  LEU     4      21.742  24.754  36.940  1.00 23.22      A   
ATOM     28  CD1 LEU     4      20.290  24.831  36.473  1.00 21.74      A   
ATOM     29  CD2 LEU     4      21.934  23.474  37.721  1.00 22.90      A   
ATOM     30  C   LEU     4      23.257  27.132  36.127  1.00 25.19      A   
ATOM     31  O   LEU     4      24.405  27.148  36.591  1.00 26.88      A   
ATOM     32  N   GLU     5      22.305  27.977  36.505  1.00 23.62      A   
ATOM     33  CA  GLU     5      22.514  28.944  37.578  1.00 25.83      A   
ATOM     34  CB  GLU     5      22.287  30.373  37.090  1.00 40.19      A   
ATOM     35  CG  GLU     5      23.504  30.937  36.383  1.00 46.33      A   
ATOM     36  CD  GLU     5      23.285  32.346  35.896  1.00 49.75      A   
ATOM     37  OE1 GLU     5      22.490  33.076  36.533  1.00 51.69      A   
ATOM     38  OE2 GLU     5      23.920  32.725  34.888  1.00 51.36      A   
ATOM     39  C   GLU     5      21.471  28.546  38.603  1.00 23.17      A   
ATOM     40  O   GLU     5      20.295  28.409  38.282  1.00 24.66      A   
ATOM     41  N   LEU     6      21.903  28.348  39.839  1.00 25.06      A   
ATOM     42  CA  LEU     6      20.999  27.892  40.873  1.00 23.09      A   
ATOM     43  CB  LEU     6      21.109  26.372  40.969  1.00 24.01      A   
ATOM     44  CG  LEU     6      20.122  25.610  41.845  1.00 25.36      A   
ATOM     45  CD1 LEU     6      18.801  25.483  41.105  1.00 22.71      A   
ATOM     46  CD2 LEU     6      20.682  24.216  42.139  1.00 28.71      A   
ATOM     47  C   LEU     6      21.297  28.479  42.240  1.00 24.57      A   
ATOM     48  O   LEU     6      22.462  28.697  42.585  1.00 23.80      A   
ATOM     49  N   SER     7      20.243  28.719  43.017  1.00 23.82      A   
ATOM     50  CA  SER     7      20.406  29.213  44.377  1.00 26.53      A   
ATOM     51  CB  SER     7      19.457  30.382  44.667  1.00 28.18      A   
ATOM     52  OG  SER     7      18.107  29.985  44.524  1.00 32.55      A   
ATOM     53  C   SER     7      20.038  28.003  45.233  1.00 26.53      A   
ATOM     54  O   SER     7      19.038  27.338  44.976  1.00 27.01      A   
ATOM     55  N   ALA     8      20.830  27.715  46.255  1.00 26.33      A   
ATOM     56  CA  ALA     8      20.552  26.541  47.062  1.00 26.48      A   
ATOM     57  CB  ALA     8      21.060  25.300  46.331  1.00 24.59      A   
ATOM     58  C   ALA     8      21.137  26.577  48.456  1.00 28.39      A   
ATOM     59  O   ALA     8      21.896  27.480  48.816  1.00 28.01      A   
ATOM     60  N   ARG     9      20.764  25.563  49.227  1.00 24.68      A   
ATOM     61  CA  ARG     9      21.223  25.391  50.591  1.00 27.29      A   
ATOM     62  CB  ARG     9      20.004  25.199  51.497  1.00 59.09      A   
ATOM     63  CG  ARG     9      20.307  24.858  52.937  1.00 65.71      A   
ATOM     64  CD  ARG     9      19.394  23.737  53.436  1.00 70.65      A   
ATOM     65  NE  ARG     9      18.032  23.854  52.913  1.00 73.40      A   
ATOM     66  CZ  ARG     9      17.078  22.946  53.109  1.00 74.78      A   
ATOM     67  NH1 ARG     9      17.329  21.852  53.819  1.00 74.28      A   
ATOM     68  NH2 ARG     9      15.874  23.121  52.578  1.00 75.97      A   
ATOM     69  C   ARG     9      22.088  24.130  50.595  1.00 25.32      A   
ATOM     70  O   ARG     9      21.748  23.150  49.930  1.00 23.53      A   
ATOM     71  N   VAL    10      23.209  24.157  51.314  1.00 26.68      A   
ATOM     72  CA  VAL    10      24.075  22.985  51.396  1.00 26.58      A   
ATOM     73  CB  VAL    10      25.467  23.332  51.942  1.00 27.91      A   
ATOM     74  CG1 VAL    10      26.304  22.056  52.069  1.00 29.79      A   
ATOM     75  CG2 VAL    10      26.158  24.320  51.008  1.00 26.57      A   
ATOM     76  C   VAL    10      23.454  21.954  52.320  1.00 27.37      A   
ATOM     77  O   VAL    10      23.337  22.172  53.528  1.00 30.15      A   
ATOM     78  N   LEU    11      23.064  20.825  51.749  1.00 27.52      A   
ATOM     79  CA  LEU    11      22.444  19.759  52.517  1.00 27.26      A   
ATOM     80  CB  LEU    11      21.413  19.040  51.651  1.00 27.95      A   
ATOM     81  CG  LEU    11      20.469  18.035  52.310  1.00 31.34      A   
ATOM     82  CD1 LEU    11      19.627  18.705  53.403  1.00 31.87      A   
ATOM     83  CD2 LEU    11      19.572  17.470  51.226  1.00 29.70      A   
ATOM     84  C   LEU    11      23.475  18.765  53.031  1.00 26.39      A   
ATOM     85  O   LEU    11      23.264  18.113  54.036  1.00 26.52      A   
ATOM     86  N   GLU    12      24.581  18.636  52.311  1.00 26.78      A   
ATOM     87  CA  GLU    12      25.654  17.731  52.694  1.00 26.21      A   
ATOM     88  CB  GLU    12      25.364  16.296  52.219  1.00 37.59      A   
ATOM     89  CG  GLU    12      26.547  15.339  52.386  1.00 41.96      A   
ATOM     90  CD  GLU    12      26.179  13.871  52.173  1.00 46.60      A   
ATOM     91  OE1 GLU    12      25.409  13.570  51.235  1.00 47.54      A   
ATOM     92  OE2 GLU    12      26.678  13.012  52.938  1.00 48.21      A   
ATOM     93  C   GLU    12      26.919  18.255  52.041  1.00 24.78      A   
ATOM     94  O   GLU    12      26.881  18.759  50.910  1.00 21.33      A   
ATOM     95  N   CYS    13      28.031  18.172  52.760  1.00 24.07      A   
ATOM     96  CA  CYS    13      29.304  18.648  52.237  1.00 25.07      A   
ATOM     97  CB  CYS    13      29.699  19.967  52.912  1.00 27.16      A   
ATOM     98  SG  CYS    13      31.211  20.744  52.267  1.00 28.15      A   
ATOM     99  C   CYS    13      30.338  17.584  52.520  1.00 27.03      A   
ATOM    100  O   CYS    13      30.720  17.369  53.671  1.00 29.10      A   
ATOM    101  N   GLY    14      30.788  16.910  51.467  1.00 31.16      A   
ATOM    102  CA  GLY    14      31.763  15.850  51.634  1.00 32.73      A   
ATOM    103  C   GLY    14      33.106  16.283  52.187  1.00 33.43      A   
ATOM    104  O   GLY    14      33.356  17.472  52.401  1.00 32.99      A   
ATOM    105  N   ALA    15      33.968  15.307  52.450  1.00 30.50      A   
ATOM    106  CA  ALA    15      35.301  15.600  52.948  1.00 31.73      A   
ATOM    107  CB  ALA    15      35.849  14.383  53.713  1.00 43.10      A   
ATOM    108  C   ALA    15      36.195  15.931  51.743  1.00 31.06      A   
ATOM    109  O   ALA    15      35.925  15.500  50.621  1.00 30.10      A   
ATOM    110  N   MET    16      37.248  16.706  51.974  1.00 33.75      A   
ATOM    111  CA  MET    16      38.175  17.079  50.909  1.00 34.44      A   
ATOM    112  CB  MET    16      39.190  18.088  51.437  1.00 36.40      A   
ATOM    113  CG  MET    16      40.158  18.580  50.380  1.00 42.50      A   
ATOM    114  SD  MET    16      39.215  19.523  48.978  1.00 51.77      A   
ATOM    115  CE  MET    16      39.181  21.260  49.790  1.00 42.94      A   
ATOM    116  C   MET    16      38.932  15.864  50.372  1.00 34.78      A   
ATOM    117  O   MET    16      39.434  15.055  51.147  1.00 35.45      A   
ATOM    118  N   ARG    17      39.010  15.730  49.050  1.00 31.64      A   
ATOM    119  CA  ARG    17      39.746  14.626  48.430  1.00 32.60      A   
ATOM    120  CB  ARG    17      38.805  13.684  47.663  1.00 45.02      A   
ATOM    121  CG  ARG    17      37.628  13.162  48.453  1.00 51.95      A   
ATOM    122  CD  ARG    17      36.742  12.282  47.579  1.00 58.07      A   
ATOM    123  NE  ARG    17      36.175  12.984  46.421  1.00 62.07      A   
ATOM    124  CZ  ARG    17      35.360  14.037  46.491  1.00 63.33      A   
ATOM    125  NH1 ARG    17      34.996  14.533  47.668  1.00 65.34      A   
ATOM    126  NH2 ARG    17      34.912  14.609  45.380  1.00 63.27      A   
ATOM    127  C   ARG    17      40.705  15.276  47.437  1.00 31.59      A   
ATOM    128  O   ARG    17      40.657  16.490  47.235  1.00 29.81      A   
ATOM    129  N   HIS    18      41.579  14.483  46.829  1.00 31.03      A   
ATOM    130  CA  HIS    18      42.501  15.013  45.835  1.00 30.31      A   
ATOM    131  CB  HIS    18      43.885  15.278  46.431  1.00 30.18      A   
ATOM    132  CG  HIS    18      43.891  16.339  47.478  1.00 27.06      A   
ATOM    133  CD2 HIS    18      44.146  17.666  47.400  1.00 25.93      A   
ATOM    134  ND1 HIS    18      43.549  16.089  48.787  1.00 26.80      A   
ATOM    135  CE1 HIS    18      43.592  17.217  49.473  1.00 27.01      A   
ATOM    136  NE2 HIS    18      43.951  18.189  48.654  1.00 26.49      A   
ATOM    137  C   HIS    18      42.649  14.033  44.700  1.00 30.86      A   
ATOM    138  O   HIS    18      42.610  12.822  44.903  1.00 29.79      A   
ATOM    139  N   THR    19      42.797  14.569  43.498  1.00 31.93      A   
ATOM    140  CA  THR    19      42.999  13.738  42.333  1.00 32.14      A   
ATOM    141  CB  THR    19      42.770  14.536  41.041  1.00 33.79      A   
ATOM    142  OG1 THR    19      43.730  15.601  40.957  1.00 33.43      A   
ATOM    143  CG2 THR    19      41.351  15.112  41.018  1.00 30.25      A   
ATOM    144  C   THR    19      44.467  13.305  42.404  1.00 32.81      A   
ATOM    145  O   THR    19      45.213  13.776  43.263  1.00 31.81      A   
ATOM    146  N   PRO    20      44.894  12.387  41.518  1.00 35.99      A   
ATOM    147  CD  PRO    20      44.089  11.552  40.605  1.00 38.03      A   
ATOM    148  CA  PRO    20      46.290  11.934  41.533  1.00 34.64      A   
ATOM    149  CB  PRO    20      46.335  10.915  40.400  1.00 36.73      A   
ATOM    150  CG  PRO    20      44.959  10.318  40.452  1.00 40.37      A   
ATOM    151  C   PRO    20      47.268  13.077  41.308  1.00 33.24      A   
ATOM    152  O   PRO    20      48.397  13.034  41.795  1.00 33.18      A   
ATOM    153  N   ALA    21      46.838  14.088  40.556  1.00 28.39      A   
ATOM    154  CA  ALA    21      47.687  15.246  40.285  1.00 26.67      A   
ATOM    155  CB  ALA    21      47.260  15.941  39.000  1.00 30.23      A   
ATOM    156  C   ALA    21      47.613  16.230  41.450  1.00 26.44      A   
ATOM    157  O   ALA    21      48.135  17.344  41.361  1.00 26.22      A   
ATOM    158  N   GLY    22      46.942  15.824  42.528  1.00 28.68      A   
ATOM    159  CA  GLY    22      46.829  16.670  43.709  1.00 26.14      A   
ATOM    160  C   GLY    22      45.780  17.777  43.657  1.00 28.37      A   
ATOM    161  O   GLY    22      45.741  18.655  44.524  1.00 26.71      A   
ATOM    162  N   LEU    23      44.932  17.758  42.640  1.00 25.27      A   
ATOM    163  CA  LEU    23      43.883  18.767  42.538  1.00 27.04      A   
ATOM    164  CB  LEU    23      43.262  18.705  41.144  1.00 36.58      A   
ATOM    165  CG  LEU    23      42.296  19.803  40.693  1.00 40.73      A   
ATOM    166  CD1 LEU    23      42.848  21.197  41.031  1.00 40.54      A   
ATOM    167  CD2 LEU    23      42.086  19.653  39.190  1.00 40.02      A   
ATOM    168  C   LEU    23      42.804  18.542  43.619  1.00 27.04      A   
ATOM    169  O   LEU    23      42.299  17.430  43.788  1.00 26.83      A   
ATOM    170  N   PRO    24      42.457  19.588  44.392  1.00 26.02      A   
ATOM    171  CD  PRO    24      43.071  20.917  44.540  1.00 33.80      A   
ATOM    172  CA  PRO    24      41.424  19.366  45.414  1.00 25.32      A   
ATOM    173  CB  PRO    24      41.406  20.682  46.200  1.00 34.41      A   
ATOM    174  CG  PRO    24      41.988  21.680  45.246  1.00 35.64      A   
ATOM    175  C   PRO    24      40.082  19.031  44.770  1.00 23.75      A   
ATOM    176  O   PRO    24      39.735  19.570  43.725  1.00 22.81      A   
ATOM    177  N   ALA    25      39.337  18.125  45.388  1.00 23.67      A   
ATOM    178  CA  ALA    25      38.056  17.700  44.842  1.00 25.97      A   
ATOM    179  CB  ALA    25      38.209  16.362  44.128  1.00 30.92      A   
ATOM    180  C   ALA    25      37.048  17.578  45.962  1.00 25.13      A   
ATOM    181  O   ALA    25      37.319  16.978  46.994  1.00 25.71      A   
ATOM    182  N   LEU    26      35.865  18.135  45.742  1.00 25.68      A   
ATOM    183  CA  LEU    26      34.833  18.115  46.765  1.00 25.29      A   
ATOM    184  CB  LEU    26      34.834  19.465  47.486  1.00 25.63      A   
ATOM    185  CG  LEU    26      33.739  19.749  48.513  1.00 27.37      A   
ATOM    186  CD1 LEU    26      33.997  18.903  49.772  1.00 29.57      A   
ATOM    187  CD2 LEU    26      33.745  21.244  48.858  1.00 28.02      A   
ATOM    188  C   LEU    26      33.448  17.825  46.194  1.00 26.42      A   
ATOM    189  O   LEU    26      33.075  18.346  45.143  1.00 27.62      A   
ATOM    190  N   GLU    27      32.690  16.992  46.898  1.00 23.95      A   
ATOM    191  CA  GLU    27      31.341  16.630  46.477  1.00 27.32      A   
ATOM    192  CB  GLU    27      31.216  15.094  46.439  1.00 50.38      A   
ATOM    193  CG  GLU    27      29.804  14.530  46.600  1.00 58.68      A   
ATOM    194  CD  GLU    27      29.034  14.409  45.289  1.00 62.89      A   
ATOM    195  OE1 GLU    27      29.407  13.553  44.457  1.00 66.03      A   
ATOM    196  OE2 GLU    27      28.057  15.162  45.092  1.00 66.47      A   
ATOM    197  C   GLU    27      30.350  17.226  47.477  1.00 26.08      A   
ATOM    198  O   GLU    27      30.550  17.128  48.687  1.00 24.71      A   
ATOM    199  N   LEU    28      29.303  17.876  46.979  1.00 26.78      A   
ATOM    200  CA  LEU    28      28.299  18.445  47.872  1.00 26.53      A   
ATOM    201  CB  LEU    28      28.413  19.975  47.964  1.00 27.40      A   
ATOM    202  CG  LEU    28      29.738  20.650  48.326  1.00 27.58      A   
ATOM    203  CD1 LEU    28      30.465  21.049  47.038  1.00 28.75      A   
ATOM    204  CD2 LEU    28      29.463  21.884  49.182  1.00 27.49      A   
ATOM    205  C   LEU    28      26.905  18.094  47.382  1.00 24.94      A   
ATOM    206  O   LEU    28      26.715  17.720  46.225  1.00 26.86      A   
ATOM    207  N   LEU    29      25.939  18.208  48.283  1.00 23.67      A   
ATOM    208  CA  LEU    29      24.546  17.948  47.961  1.00 25.26      A   
ATOM    209  CB  LEU    29      23.980  16.847  48.859  1.00 32.81      A   
ATOM    210  CG  LEU    29      22.619  16.271  48.455  1.00 36.98      A   
ATOM    211  CD1 LEU    29      22.643  15.862  46.983  1.00 39.93      A   
ATOM    212  CD2 LEU    29      22.291  15.061  49.329  1.00 38.53      A   
ATOM    213  C   LEU    29      23.811  19.261  48.211  1.00 25.49      A   
ATOM    214  O   LEU    29      23.820  19.794  49.326  1.00 25.02      A   
ATOM    215  N   LEU    30      23.173  19.782  47.171  1.00 25.15      A   
ATOM    216  CA  LEU    30      22.457  21.048  47.272  1.00 24.89      A   
ATOM    217  CB  LEU    30      22.923  21.976  46.151  1.00 25.89      A   
ATOM    218  CG  LEU    30      24.446  22.117  46.006  1.00 27.08      A   
ATOM    219  CD1 LEU    30      24.786  22.905  44.744  1.00 25.50      A   
ATOM    220  CD2 LEU    30      25.035  22.788  47.246  1.00 25.99      A   
ATOM    221  C   LEU    30      20.951  20.854  47.160  1.00 25.18      A   
ATOM    222  O   LEU    30      20.493  19.983  46.426  1.00 23.82      A   
ATOM    223  N   VAL    31      20.184  21.652  47.898  1.00 23.42      A   
ATOM    224  CA  VAL    31      18.731  21.571  47.822  1.00 23.61      A   
ATOM    225  CB  VAL    31      18.115  21.034  49.138  1.00 30.26      A   
ATOM    226  CG1 VAL    31      18.591  21.859  50.313  1.00 32.68      A   
ATOM    227  CG2 VAL    31      16.583  21.037  49.031  1.00 31.06      A   
ATOM    228  C   VAL    31      18.191  22.959  47.489  1.00 24.03      A   
ATOM    229  O   VAL    31      18.484  23.941  48.167  1.00 21.81      A   
ATOM    230  N   HIS    32      17.430  23.033  46.404  1.00 26.38      A   
ATOM    231  CA  HIS    32      16.854  24.282  45.936  1.00 26.95      A   
ATOM    232  CB  HIS    32      17.186  24.467  44.452  1.00 28.09      A   
ATOM    233  CG  HIS    32      16.364  25.515  43.771  1.00 24.39      A   
ATOM    234  CD2 HIS    32      16.612  26.824  43.529  1.00 25.91      A   
ATOM    235  ND1 HIS    32      15.111  25.262  43.257  1.00 28.36      A   
ATOM    236  CE1 HIS    32      14.620  26.367  42.727  1.00 25.17      A   
ATOM    237  NE2 HIS    32      15.510  27.330  42.878  1.00 29.12      A   
ATOM    238  C   HIS    32      15.345  24.302  46.114  1.00 28.72      A   
ATOM    239  O   HIS    32      14.689  23.281  45.933  1.00 29.57      A   
ATOM    240  N   GLU    33      14.803  25.462  46.478  1.00 30.22      A   
ATOM    241  CA  GLU    33      13.356  25.614  46.631  1.00 31.31      A   
ATOM    242  CB  GLU    33      12.914  25.405  48.084  1.00 56.19      A   
ATOM    243  CG  GLU    33      11.397  25.481  48.265  1.00 62.70      A   
ATOM    244  CD  GLU    33      10.952  25.161  49.681  1.00 67.35      A   
ATOM    245  OE1 GLU    33      11.378  25.863  50.626  1.00 70.69      A   
ATOM    246  OE2 GLU    33      10.169  24.200  49.849  1.00 69.26      A   
ATOM    247  C   GLU    33      12.931  27.003  46.171  1.00 31.37      A   
ATOM    248  O   GLU    33      13.559  28.002  46.512  1.00 29.09      A   
ATOM    249  N   SER    34      11.863  27.060  45.385  1.00 32.63      A   
ATOM    250  CA  SER    34      11.370  28.329  44.878  1.00 32.82      A   
ATOM    251  CB  SER    34      12.356  28.929  43.871  1.00 30.99      A   
ATOM    252  OG  SER    34      12.385  28.179  42.669  1.00 27.65      A   
ATOM    253  C   SER    34      10.050  28.103  44.186  1.00 34.11      A   
ATOM    254  O   SER    34       9.665  26.960  43.931  1.00 34.53      A   
ATOM    255  N   GLU    35       9.363  29.196  43.879  1.00 31.65      A   
ATOM    256  CA  GLU    35       8.087  29.133  43.189  1.00 35.16      A   
ATOM    257  CB  GLU    35       7.055  30.018  43.895  1.00 64.06      A   
ATOM    258  CG  GLU    35       6.638  29.524  45.271  1.00 69.41      A   
ATOM    259  CD  GLU    35       5.649  28.378  45.201  1.00 72.73      A   
ATOM    260  OE1 GLU    35       4.592  28.550  44.555  1.00 75.53      A   
ATOM    261  OE2 GLU    35       5.924  27.311  45.795  1.00 75.35      A   
ATOM    262  C   GLU    35       8.346  29.668  41.791  1.00 34.94      A   
ATOM    263  O   GLU    35       9.034  30.674  41.635  1.00 34.58      A   
ATOM    264  N   VAL    36       7.822  28.988  40.779  1.00 35.89      A   
ATOM    265  CA  VAL    36       7.996  29.433  39.401  1.00 37.61      A   
ATOM    266  CB  VAL    36       8.982  28.532  38.621  1.00 33.61      A   
ATOM    267  CG1 VAL    36      10.338  28.512  39.308  1.00 32.75      A   
ATOM    268  CG2 VAL    36       8.426  27.132  38.502  1.00 34.51      A   
ATOM    269  C   VAL    36       6.659  29.434  38.663  1.00 38.71      A   
ATOM    270  O   VAL    36       5.709  28.755  39.062  1.00 38.69      A   
ATOM    271  N   VAL    37       6.590  30.203  37.587  1.00 39.43      A   
ATOM    272  CA  VAL    37       5.372  30.286  36.795  1.00 40.19      A   
ATOM    273  CB  VAL    37       5.102  31.739  36.378  1.00 49.29      A   
ATOM    274  CG1 VAL    37       6.312  32.290  35.638  1.00 50.63      A   
ATOM    275  CG2 VAL    37       3.848  31.811  35.525  1.00 50.21      A   
ATOM    276  C   VAL    37       5.529  29.414  35.553  1.00 40.89      A   
ATOM    277  O   VAL    37       6.507  29.533  34.818  1.00 38.12      A   
ATOM    278  N   GLU    38       4.566  28.528  35.324  1.00 42.38      A   
ATOM    279  CA  GLU    38       4.634  27.638  34.175  1.00 45.57      A   
ATOM    280  CB  GLU    38       4.986  26.229  34.652  1.00 50.02      A   
ATOM    281  CG  GLU    38       5.164  25.214  33.557  1.00 50.17      A   
ATOM    282  CD  GLU    38       5.800  23.942  34.073  1.00 51.94      A   
ATOM    283  OE1 GLU    38       5.411  23.486  35.169  1.00 52.48      A   
ATOM    284  OE2 GLU    38       6.684  23.393  33.385  1.00 51.85      A   
ATOM    285  C   GLU    38       3.333  27.633  33.383  1.00 46.60      A   
ATOM    286  O   GLU    38       2.289  27.217  33.886  1.00 45.91      A   
ATOM    287  N   ALA    39       3.415  28.095  32.137  1.00 66.00      A   
ATOM    288  CA  ALA    39       2.250  28.172  31.268  1.00 67.47      A   
ATOM    289  CB  ALA    39       1.708  26.771  30.984  1.00 62.56      A   
ATOM    290  C   ALA    39       1.193  29.021  31.959  1.00 67.93      A   
ATOM    291  O   ALA    39      -0.003  28.756  31.846  1.00 68.09      A   
ATOM    292  N   GLY    40       1.648  30.039  32.682  1.00 50.35      A   
ATOM    293  CA  GLY    40       0.732  30.919  33.383  1.00 50.51      A   
ATOM    294  C   GLY    40       0.170  30.337  34.663  1.00 51.76      A   
ATOM    295  O   GLY    40      -0.970  30.631  35.025  1.00 52.84      A   
ATOM    296  N   HIS    41       0.949  29.513  35.360  1.00 51.87      A   
ATOM    297  CA  HIS    41       0.475  28.912  36.607  1.00 52.47      A   
ATOM    298  CB  HIS    41      -0.160  27.541  36.330  1.00 71.49      A   
ATOM    299  CG  HIS    41      -1.320  27.592  35.387  1.00 73.74      A   
ATOM    300  CD2 HIS    41      -1.448  27.161  34.110  1.00 74.29      A   
ATOM    301  ND1 HIS    41      -2.525  28.173  35.719  1.00 74.30      A   
ATOM    302  CE1 HIS    41      -3.346  28.098  34.686  1.00 75.45      A   
ATOM    303  NE2 HIS    41      -2.716  27.488  33.697  1.00 74.43      A   
ATOM    304  C   HIS    41       1.594  28.756  37.639  1.00 52.24      A   
ATOM    305  O   HIS    41       2.702  28.355  37.303  1.00 51.82      A   
ATOM    306  N   PRO    42       1.312  29.073  38.913  1.00 59.44      A   
ATOM    307  CD  PRO    42       0.040  29.603  39.440  1.00 62.08      A   
ATOM    308  CA  PRO    42       2.316  28.955  39.980  1.00 59.00      A   
ATOM    309  CB  PRO    42       1.661  29.686  41.149  1.00 62.01      A   
ATOM    310  CG  PRO    42       0.194  29.389  40.935  1.00 61.96      A   
ATOM    311  C   PRO    42       2.647  27.493  40.304  1.00 58.49      A   
ATOM    312  O   PRO    42       1.778  26.620  40.245  1.00 57.97      A   
ATOM    313  N   ARG    43       3.904  27.232  40.647  1.00 45.42      A   
ATOM    314  CA  ARG    43       4.343  25.872  40.949  1.00 45.16      A   
ATOM    315  CB  ARG    43       4.783  25.181  39.655  1.00 63.38      A   
ATOM    316  CG  ARG    43       5.300  23.757  39.816  1.00 67.94      A   
ATOM    317  CD  ARG    43       5.748  23.220  38.463  1.00 69.41      A   
ATOM    318  NE  ARG    43       6.267  21.856  38.528  1.00 71.62      A   
ATOM    319  CZ  ARG    43       7.413  21.510  39.108  1.00 73.06      A   
ATOM    320  NH1 ARG    43       8.178  22.428  39.686  1.00 74.20      A   
ATOM    321  NH2 ARG    43       7.804  20.241  39.096  1.00 72.22      A   
ATOM    322  C   ARG    43       5.485  25.836  41.961  1.00 43.06      A   
ATOM    323  O   ARG    43       6.401  26.650  41.916  1.00 40.53      A   
ATOM    324  N   ARG    44       5.431  24.877  42.871  1.00 42.86      A   
ATOM    325  CA  ARG    44       6.470  24.750  43.880  1.00 41.76      A   
ATOM    326  CB  ARG    44       5.900  24.056  45.119  1.00 80.16      A   
ATOM    327  CG  ARG    44       4.566  24.626  45.605  1.00 86.18      A   
ATOM    328  CD  ARG    44       3.908  23.753  46.665  1.00 89.94      A   
ATOM    329  NE  ARG    44       4.813  23.455  47.768  1.00 94.16      A   
ATOM    330  CZ  ARG    44       4.432  22.910  48.918  1.00 95.74      A   
ATOM    331  NH1 ARG    44       5.325  22.667  49.869  1.00 97.16      A   
ATOM    332  NH2 ARG    44       3.155  22.624  49.118  1.00 96.57      A   
ATOM    333  C   ARG    44       7.605  23.894  43.314  1.00 39.20      A   
ATOM    334  O   ARG    44       7.365  22.771  42.882  1.00 38.72      A   
ATOM    335  N   VAL    45       8.832  24.409  43.303  1.00 31.89      A   
ATOM    336  CA  VAL    45       9.956  23.617  42.808  1.00 30.53      A   
ATOM    337  CB  VAL    45      10.784  24.353  41.715  1.00 48.89      A   
ATOM    338  CG1 VAL    45      11.869  23.422  41.192  1.00 49.73      A   
ATOM    339  CG2 VAL    45       9.891  24.820  40.581  1.00 51.08      A   
ATOM    340  C   VAL    45      10.910  23.307  43.956  1.00 28.97      A   
ATOM    341  O   VAL    45      11.385  24.212  44.638  1.00 29.10      A   
ATOM    342  N   GLU    46      11.169  22.026  44.181  1.00 35.62      A   
ATOM    343  CA  GLU    46      12.113  21.609  45.212  1.00 35.83      A   
ATOM    344  CB  GLU    46      11.406  20.961  46.396  1.00 50.70      A   
ATOM    345  CG  GLU    46      12.377  20.379  47.412  1.00 56.00      A   
ATOM    346  CD  GLU    46      11.755  20.213  48.790  1.00 59.28      A   
ATOM    347  OE1 GLU    46      10.675  19.590  48.894  1.00 59.61      A   
ATOM    348  OE2 GLU    46      12.350  20.708  49.772  1.00 60.11      A   
ATOM    349  C   GLU    46      13.061  20.610  44.562  1.00 33.49      A   
ATOM    350  O   GLU    46      12.681  19.484  44.254  1.00 33.63      A   
ATOM    351  N   LEU    47      14.301  21.032  44.368  1.00 31.55      A   
ATOM    352  CA  LEU    47      15.299  20.201  43.707  1.00 29.40      A   
ATOM    353  CB  LEU    47      15.774  20.916  42.436  1.00 26.79      A   
ATOM    354  CG  LEU    47      16.912  20.320  41.595  1.00 26.96      A   
ATOM    355  CD1 LEU    47      16.414  19.106  40.818  1.00 29.61      A   
ATOM    356  CD2 LEU    47      17.427  21.372  40.624  1.00 26.03      A   
ATOM    357  C   LEU    47      16.514  19.888  44.567  1.00 27.14      A   
ATOM    358  O   LEU    47      17.041  20.759  45.244  1.00 24.59      A   
ATOM    359  N   THR    48      16.955  18.637  44.536  1.00 27.05      A   
ATOM    360  CA  THR    48      18.148  18.238  45.270  1.00 27.97      A   
ATOM    361  CB  THR    48      17.846  17.132  46.290  1.00 29.86      A   
ATOM    362  OG1 THR    48      16.987  17.668  47.301  1.00 30.72      A   
ATOM    363  CG2 THR    48      19.119  16.634  46.949  1.00 27.80      A   
ATOM    364  C   THR    48      19.072  17.738  44.170  1.00 28.24      A   
ATOM    365  O   THR    48      18.683  16.926  43.312  1.00 27.20      A   
ATOM    366  N   ILE    49      20.293  18.247  44.174  1.00 25.73      A   
ATOM    367  CA  ILE    49      21.238  17.880  43.141  1.00 25.79      A   
ATOM    368  CB  ILE    49      21.192  18.916  42.015  1.00 27.68      A   
ATOM    369  CG2 ILE    49      21.423  20.305  42.588  1.00 25.33      A   
ATOM    370  CG1 ILE    49      22.222  18.580  40.936  1.00 31.67      A   
ATOM    371  CD1 ILE    49      21.795  17.477  40.017  1.00 35.55      A   
ATOM    372  C   ILE    49      22.652  17.813  43.685  1.00 25.13      A   
ATOM    373  O   ILE    49      23.056  18.645  44.502  1.00 22.88      A   
ATOM    374  N   SER    50      23.406  16.824  43.226  1.00 25.95      A   
ATOM    375  CA  SER    50      24.784  16.693  43.671  1.00 27.21      A   
ATOM    376  CB  SER    50      25.263  15.247  43.538  1.00 39.72      A   
ATOM    377  OG  SER    50      25.384  14.891  42.179  1.00 49.33      A   
ATOM    378  C   SER    50      25.674  17.616  42.843  1.00 26.32      A   
ATOM    379  O   SER    50      25.502  17.746  41.627  1.00 26.27      A   
ATOM    380  N   ALA    51      26.625  18.259  43.510  1.00 23.67      A   
ATOM    381  CA  ALA    51      27.524  19.173  42.837  1.00 24.76      A   
ATOM    382  CB  ALA    51      27.260  20.593  43.298  1.00 24.09      A   
ATOM    383  C   ALA    51      28.948  18.792  43.150  1.00 26.32      A   
ATOM    384  O   ALA    51      29.249  18.353  44.266  1.00 24.18      A   
ATOM    385  N   VAL    52      29.816  18.962  42.159  1.00 25.72      A   
ATOM    386  CA  VAL    52      31.227  18.656  42.319  1.00 26.52      A   
ATOM    387  CB  VAL    52      31.681  17.537  41.336  1.00 38.51      A   
ATOM    388  CG1 VAL    52      33.196  17.407  41.350  1.00 40.69      A   
ATOM    389  CG2 VAL    52      31.058  16.202  41.742  1.00 39.67      A   
ATOM    390  C   VAL    52      32.049  19.916  42.069  1.00 26.65      A   
ATOM    391  O   VAL    52      31.793  20.675  41.125  1.00 23.27      A   
ATOM    392  N   ALA    53      33.015  20.139  42.951  1.00 24.95      A   
ATOM    393  CA  ALA    53      33.918  21.274  42.862  1.00 25.72      A   
ATOM    394  CB  ALA    53      33.850  22.101  44.144  1.00 32.05      A   
ATOM    395  C   ALA    53      35.301  20.657  42.687  1.00 25.08      A   
ATOM    396  O   ALA    53      35.597  19.614  43.271  1.00 26.05      A   
ATOM    397  N   LEU    54      36.135  21.282  41.870  1.00 29.44      A   
ATOM    398  CA  LEU    54      37.469  20.761  41.597  1.00 31.81      A   
ATOM    399  CB  LEU    54      37.441  19.976  40.275  1.00 36.23      A   
ATOM    400  CG  LEU    54      38.631  19.161  39.744  1.00 42.22      A   
ATOM    401  CD1 LEU    54      39.140  18.197  40.806  1.00 42.20      A   
ATOM    402  CD2 LEU    54      38.185  18.384  38.490  1.00 41.90      A   
ATOM    403  C   LEU    54      38.401  21.958  41.497  1.00 32.80      A   
ATOM    404  O   LEU    54      38.203  22.831  40.653  1.00 34.37      A   
ATOM    405  N   GLY    55      39.405  22.010  42.367  1.00 27.13      A   
ATOM    406  CA  GLY    55      40.327  23.127  42.343  1.00 26.95      A   
ATOM    407  C   GLY    55      40.002  24.211  43.362  1.00 26.29      A   
ATOM    408  O   GLY    55      39.674  23.931  44.518  1.00 24.22      A   
ATOM    409  N   ASP    56      40.072  25.459  42.920  1.00 27.38      A   
ATOM    410  CA  ASP    56      39.824  26.590  43.793  1.00 28.10      A   
ATOM    411  CB  ASP    56      40.083  27.885  43.026  1.00 27.21      A   
ATOM    412  CG  ASP    56      41.571  28.149  42.824  1.00 31.36      A   
ATOM    413  OD1 ASP    56      41.919  29.030  42.010  1.00 30.34      A   
ATOM    414  OD2 ASP    56      42.396  27.478  43.489  1.00 28.38      A   
ATOM    415  C   ASP    56      38.455  26.625  44.475  1.00 26.99      A   
ATOM    416  O   ASP    56      38.355  27.024  45.631  1.00 25.86      A   
ATOM    417  N   LEU    57      37.409  26.201  43.778  1.00 26.03      A   
ATOM    418  CA  LEU    57      36.077  26.203  44.367  1.00 26.48      A   
ATOM    419  CB  LEU    57      35.009  25.940  43.301  1.00 36.39      A   
ATOM    420  CG  LEU    57      34.632  27.127  42.419  1.00 36.95      A   
ATOM    421  CD1 LEU    57      33.485  26.718  41.510  1.00 38.53      A   
ATOM    422  CD2 LEU    57      34.200  28.297  43.287  1.00 38.10      A   
ATOM    423  C   LEU    57      35.972  25.146  45.449  1.00 25.86      A   
ATOM    424  O   LEU    57      35.247  25.313  46.426  1.00 25.71      A   
ATOM    425  N   ALA    58      36.692  24.047  45.276  1.00 25.28      A   
ATOM    426  CA  ALA    58      36.663  22.995  46.279  1.00 23.68      A   
ATOM    427  CB  ALA    58      37.433  21.754  45.778  1.00 18.74      A   
ATOM    428  C   ALA    58      37.292  23.548  47.565  1.00 24.16      A   
ATOM    429  O   ALA    58      36.825  23.279  48.676  1.00 24.86      A   
ATOM    430  N   LEU    59      38.346  24.340  47.420  1.00 24.80      A   
ATOM    431  CA  LEU    59      39.009  24.912  48.594  1.00 25.22      A   
ATOM    432  CB  LEU    59      40.301  25.620  48.173  1.00 25.53      A   
ATOM    433  CG  LEU    59      41.408  24.698  47.635  1.00 23.74      A   
ATOM    434  CD1 LEU    59      42.621  25.539  47.185  1.00 28.11      A   
ATOM    435  CD2 LEU    59      41.819  23.735  48.726  1.00 25.60      A   
ATOM    436  C   LEU    59      38.075  25.896  49.282  1.00 26.66      A   
ATOM    437  O   LEU    59      37.977  25.945  50.514  1.00 25.80      A   
ATOM    438  N   LEU    60      37.380  26.675  48.469  1.00 26.26      A   
ATOM    439  CA  LEU    60      36.454  27.660  48.999  1.00 28.13      A   
ATOM    440  CB  LEU    60      35.907  28.519  47.858  1.00 28.63      A   
ATOM    441  CG  LEU    60      35.022  29.723  48.203  1.00 33.95      A   
ATOM    442  CD1 LEU    60      35.829  30.845  48.888  1.00 33.12      A   
ATOM    443  CD2 LEU    60      34.412  30.234  46.899  1.00 35.66      A   
ATOM    444  C   LEU    60      35.297  26.996  49.739  1.00 27.53      A   
ATOM    445  O   LEU    60      34.984  27.358  50.866  1.00 27.40      A   
ATOM    446  N   LEU    61      34.675  26.006  49.109  1.00 23.07      A   
ATOM    447  CA  LEU    61      33.526  25.334  49.705  1.00 22.98      A   
ATOM    448  CB  LEU    61      32.680  24.689  48.598  1.00 23.07      A   
ATOM    449  CG  LEU    61      32.164  25.739  47.597  1.00 26.73      A   
ATOM    450  CD1 LEU    61      31.443  25.061  46.434  1.00 24.40      A   
ATOM    451  CD2 LEU    61      31.237  26.720  48.324  1.00 27.56      A   
ATOM    452  C   LEU    61      33.819  24.320  50.796  1.00 22.65      A   
ATOM    453  O   LEU    61      32.915  23.903  51.503  1.00 21.35      A   
ATOM    454  N   ALA    62      35.075  23.920  50.951  1.00 25.49      A   
ATOM    455  CA  ALA    62      35.398  22.957  51.988  1.00 28.72      A   
ATOM    456  CB  ALA    62      36.917  22.823  52.118  1.00 45.83      A   
ATOM    457  C   ALA    62      34.788  23.337  53.346  1.00 29.14      A   
ATOM    458  O   ALA    62      34.822  24.498  53.757  1.00 29.36      A   
ATOM    459  N   ASP    63      34.216  22.350  54.025  1.00 29.35      A   
ATOM    460  CA  ASP    63      33.626  22.560  55.340  1.00 30.52      A   
ATOM    461  CB  ASP    63      34.732  22.890  56.348  1.00 46.08      A   
ATOM    462  CG  ASP    63      35.839  21.853  56.353  1.00 49.24      A   
ATOM    463  OD1 ASP    63      35.531  20.666  56.581  1.00 50.62      A   
ATOM    464  OD2 ASP    63      37.012  22.220  56.122  1.00 52.95      A   
ATOM    465  C   ASP    63      32.541  23.633  55.418  1.00 30.03      A   
ATOM    466  O   ASP    63      32.391  24.279  56.451  1.00 29.98      A   
ATOM    467  N   THR    64      31.779  23.838  54.347  1.00 27.75      A   
ATOM    468  CA  THR    64      30.705  24.833  54.407  1.00 28.05      A   
ATOM    469  CB  THR    64      29.982  24.997  53.054  1.00 31.02      A   
ATOM    470  OG1 THR    64      30.929  25.362  52.049  1.00 29.72      A   
ATOM    471  CG2 THR    64      28.917  26.094  53.142  1.00 31.52      A   
ATOM    472  C   THR    64      29.685  24.312  55.409  1.00 28.21      A   
ATOM    473  O   THR    64      29.289  23.145  55.342  1.00 25.04      A   
ATOM    474  N   PRO    65      29.257  25.153  56.365  1.00 31.00      A   
ATOM    475  CD  PRO    65      29.811  26.446  56.816  1.00 31.55      A   
ATOM    476  CA  PRO    65      28.272  24.635  57.321  1.00 31.25      A   
ATOM    477  CB  PRO    65      28.004  25.837  58.233  1.00 31.38      A   
ATOM    478  CG  PRO    65      29.332  26.534  58.272  1.00 31.89      A   
ATOM    479  C   PRO    65      27.000  24.171  56.610  1.00 32.82      A   
ATOM    480  O   PRO    65      26.565  24.802  55.645  1.00 33.91      A   
ATOM    481  N   LEU    66      26.397  23.084  57.081  1.00 29.49      A   
ATOM    482  CA  LEU    66      25.160  22.609  56.462  1.00 32.04      A   
ATOM    483  CB  LEU    66      24.726  21.262  57.051  1.00 38.32      A   
ATOM    484  CG  LEU    66      25.796  20.180  56.907  1.00 42.26      A   
ATOM    485  CD1 LEU    66      25.271  18.857  57.429  1.00 42.26      A   
ATOM    486  CD2 LEU    66      26.187  20.053  55.442  1.00 41.30      A   
ATOM    487  C   LEU    66      24.068  23.641  56.679  1.00 30.22      A   
ATOM    488  O   LEU    66      24.003  24.275  57.734  1.00 29.76      A   
ATOM    489  N   GLY    67      23.204  23.804  55.683  1.00 29.89      A   
ATOM    490  CA  GLY    67      22.145  24.789  55.787  1.00 27.82      A   
ATOM    491  C   GLY    67      22.556  26.109  55.145  1.00 27.55      A   
ATOM    492  O   GLY    67      21.704  26.954  54.861  1.00 27.26      A   
ATOM    493  N   THR    68      23.856  26.298  54.912  1.00 25.80      A   
ATOM    494  CA  THR    68      24.353  27.536  54.300  1.00 26.75      A   
ATOM    495  CB  THR    68      25.879  27.500  54.089  1.00 31.47      A   
ATOM    496  OG1 THR    68      26.531  27.304  55.345  1.00 32.99      A   
ATOM    497  CG2 THR    68      26.375  28.822  53.488  1.00 31.56      A   
ATOM    498  C   THR    68      23.731  27.803  52.937  1.00 28.81      A   
ATOM    499  O   THR    68      23.567  26.882  52.133  1.00 26.16      A   
ATOM    500  N   GLU    69      23.409  29.066  52.674  1.00 31.53      A   
ATOM    501  CA  GLU    69      22.826  29.467  51.399  1.00 34.95      A   
ATOM    502  CB  GLU    69      22.024  30.760  51.558  1.00 59.01      A   
ATOM    503  CG  GLU    69      21.170  31.132  50.347  1.00 66.23      A   
ATOM    504  CD  GLU    69      20.135  30.050  50.054  1.00 71.75      A   
ATOM    509  C   GLU    69      23.938  29.686  50.384  1.00 35.52      A   
ATOM    510  O   GLU    69      24.977  30.273  50.702  1.00 37.15      A   
ATOM    511  N   MET    70      23.695  29.239  49.157  1.00 27.26      A   
ATOM    512  CA  MET    70      24.663  29.338  48.078  0.50 29.37      A   
ATOM    513  CB  MET    70      25.252  27.954  47.788  0.50 53.54      A   
ATOM    514  CG  MET    70      25.898  27.307  48.976  0.50 59.96      A   
ATOM    515  SD  MET    70      27.190  28.525  49.679  0.50 69.62      A   
ATOM    516  CE  MET    70      28.377  28.589  48.155  0.50 67.14      A   
ATOM    517  C   MET    70      24.064  29.869  46.788  1.00 28.37      A   
ATOM    518  O   MET    70      22.861  29.775  46.564  1.00 28.60      A   
ATOM    519  N   GLN    71      24.931  30.416  45.946  1.00 32.77      A   
ATOM    520  CA  GLN    71      24.554  30.924  44.636  1.00 33.87      A   
ATOM    521  CB  GLN    71      24.610  32.452  44.622  1.00 55.43      A   
ATOM    522  CG  GLN    71      23.690  33.092  43.609  1.00 61.78      A   
ATOM    523  CD  GLN    71      23.401  34.545  43.937  1.00 63.91      A   
ATOM    524  OE1 GLN    71      22.963  34.868  45.043  1.00 64.97      A   
ATOM    525  NE2 GLN    71      23.639  35.428  42.975  1.00 64.85      A   
ATOM    526  C   GLN    71      25.634  30.313  43.749  1.00 30.52      A   
ATOM    527  O   GLN    71      26.811  30.644  43.875  1.00 30.63      A   
ATOM    528  N   VAL    72      25.248  29.401  42.866  1.00 27.97      A   
ATOM    529  CA  VAL    72      26.238  28.730  42.033  1.00 25.03      A   
ATOM    530  CB  VAL    72      26.467  27.273  42.499  1.00 26.61      A   
ATOM    531  CG1 VAL    72      26.901  27.239  43.951  1.00 27.06      A   
ATOM    532  CG2 VAL    72      25.179  26.471  42.318  1.00 26.00      A   
ATOM    533  C   VAL    72      25.862  28.658  40.569  1.00 26.84      A   
ATOM    534  O   VAL    72      24.712  28.888  40.198  1.00 27.56      A   
ATOM    535  N   GLN    73      26.856  28.316  39.754  1.00 27.71      A   
ATOM    536  CA  GLN    73      26.687  28.143  38.317  1.00 27.13      A   
ATOM    537  CB  GLN    73      26.831  29.481  37.570  1.00 38.19      A   
ATOM    538  CG  GLN    73      28.234  29.910  37.209  1.00 44.88      A   
ATOM    539  CD  GLN    73      28.772  29.236  35.954  1.00 45.71      A   
ATOM    540  OE1 GLN    73      28.021  28.672  35.152  1.00 49.24      A   
ATOM    541  NE2 GLN    73      30.079  29.307  35.774  1.00 46.81      A   
ATOM    542  C   GLN    73      27.744  27.150  37.854  1.00 26.57      A   
ATOM    543  O   GLN    73      28.808  27.020  38.475  1.00 22.41      A   
ATOM    544  N   GLY    74      27.434  26.424  36.784  1.00 23.92      A   
ATOM    545  CA  GLY    74      28.367  25.451  36.252  1.00 24.43      A   
ATOM    546  C   GLY    74      27.689  24.689  35.136  1.00 22.75      A   
ATOM    547  O   GLY    74      26.615  25.086  34.683  1.00 23.35      A   
ATOM    548  N   PHE    75      28.301  23.598  34.690  1.00 25.04      A   
ATOM    549  CA  PHE    75      27.713  22.808  33.620  1.00 25.32      A   
ATOM    550  CB  PHE    75      28.725  22.635  32.481  1.00 25.85      A   
ATOM    551  CG  PHE    75      29.955  21.841  32.858  1.00 27.05      A   
ATOM    552  CD1 PHE    75      30.002  20.452  32.677  1.00 25.82      A   
ATOM    553  CD2 PHE    75      31.082  22.487  33.367  1.00 28.65      A   
ATOM    554  CE1 PHE    75      31.164  19.712  33.000  1.00 25.68      A   
ATOM    555  CE2 PHE    75      32.241  21.771  33.692  1.00 28.59      A   
ATOM    556  CZ  PHE    75      32.285  20.375  33.506  1.00 28.50      A   
ATOM    557  C   PHE    75      27.237  21.455  34.128  1.00 25.44      A   
ATOM    558  O   PHE    75      27.764  20.928  35.107  1.00 26.99      A   
ATOM    559  N   LEU    76      26.224  20.908  33.464  1.00 25.34      A   
ATOM    560  CA  LEU    76      25.661  19.615  33.832  1.00 25.23      A   
ATOM    561  CB  LEU    76      24.162  19.579  33.505  1.00 29.09      A   
ATOM    562  CG  LEU    76      23.305  20.609  34.243  1.00 32.39      A   
ATOM    563  CD1 LEU    76      21.852  20.511  33.803  1.00 33.79      A   
ATOM    564  CD2 LEU    76      23.432  20.354  35.744  1.00 30.67      A   
ATOM    565  C   LEU    76      26.363  18.496  33.084  1.00 26.07      A   
ATOM    566  O   LEU    76      26.751  18.667  31.935  1.00 24.95      A   
ATOM    567  N   ALA    77      26.540  17.355  33.739  1.00 22.60      A   
ATOM    568  CA  ALA    77      27.177  16.230  33.077  1.00 24.61      A   
ATOM    569  CB  ALA    77      28.713  16.251  33.315  1.00 33.80      A   
ATOM    570  C   ALA    77      26.572  14.960  33.624  1.00 24.60      A   
ATOM    571  O   ALA    77      26.036  14.945  34.732  1.00 25.29      A   
ATOM    572  N   PRO    78      26.617  13.876  32.842  1.00 25.80      A   
ATOM    573  CD  PRO    78      27.189  13.690  31.497  1.00 32.45      A   
ATOM    574  CA  PRO    78      26.048  12.631  33.351  1.00 26.85      A   
ATOM    575  CB  PRO    78      26.263  11.648  32.194  1.00 31.58      A   
ATOM    576  CG  PRO    78      27.464  12.200  31.481  1.00 32.92      A   
ATOM    577  C   PRO    78      26.820  12.245  34.612  1.00 28.40      A   
ATOM    578  O   PRO    78      28.010  12.519  34.722  1.00 27.48      A   
ATOM    579  N   ALA    79      26.137  11.635  35.570  1.00 28.15      A   
ATOM    580  CA  ALA    79      26.780  11.240  36.811  1.00 32.75      A   
ATOM    581  CB  ALA    79      25.735  10.691  37.789  1.00 37.42      A   
ATOM    582  C   ALA    79      27.832  10.179  36.541  1.00 35.06      A   
ATOM    583  O   ALA    79      28.909  10.193  37.125  1.00 36.08      A   
ATOM    584  N   ARG    80      27.492   9.263  35.642  1.00 41.92      A   
ATOM    585  CA  ARG    80      28.339   8.133  35.266  1.00 46.18      A   
ATOM    586  CB  ARG    80      27.786   6.882  35.964  1.00 73.73      A   
ATOM    587  CG  ARG    80      28.511   5.572  35.732  1.00 79.35      A   
ATOM    588  CD  ARG    80      27.713   4.428  36.364  1.00 81.88      A   
ATOM    589  NE  ARG    80      28.500   3.208  36.494  1.00 85.97      A   
ATOM    590  CZ  ARG    80      29.561   3.084  37.286  1.00 87.59      A   
ATOM    591  NH1 ARG    80      29.967   4.110  38.025  1.00 88.43      A   
ATOM    592  NH2 ARG    80      30.217   1.933  37.340  1.00 88.57      A   
ATOM    593  C   ARG    80      28.209   8.006  33.749  1.00 47.15      A   
ATOM    594  O   ARG    80      27.216   8.471  33.180  1.00 46.35      A   
ATOM    595  N   LYS    81      29.184   7.387  33.084  1.00 38.64      A   
ATOM    596  CA  LYS    81      29.091   7.254  31.632  1.00 39.16      A   
ATOM    597  CB  LYS    81      30.202   6.368  31.060  1.00 63.40      A   
ATOM    598  CG  LYS    81      30.154   6.338  29.533  1.00 66.98      A   
ATOM    599  CD  LYS    81      30.962   5.215  28.914  1.00 70.58      A   
ATOM    600  CE  LYS    81      30.789   5.220  27.397  1.00 71.45      A   
ATOM    601  NZ  LYS    81      31.537   4.113  26.726  1.00 72.84      A   
ATOM    602  C   LYS    81      27.745   6.650  31.241  1.00 38.59      A   
ATOM    603  O   LYS    81      27.293   5.668  31.834  1.00 37.24      A   
ATOM    604  N   ASP    82      27.110   7.254  30.241  1.00 52.57      A   
ATOM    605  CA  ASP    82      25.816   6.807  29.730  1.00 52.05      A   
ATOM    606  CB  ASP    82      25.911   5.366  29.220  1.00 68.98      A   
ATOM    607  CG  ASP    82      27.001   5.185  28.182  1.00 70.72      A   
ATOM    608  OD1 ASP    82      27.046   5.992  27.231  1.00 72.42      A   
ATOM    609  OD2 ASP    82      27.804   4.235  28.316  1.00 72.35      A   
ATOM    610  C   ASP    82      24.682   6.897  30.740  1.00 50.43      A   
ATOM    611  O   ASP    82      23.577   6.408  30.490  1.00 51.73      A   
ATOM    612  N   SER    83      24.945   7.517  31.881  1.00 39.89      A   
ATOM    613  CA  SER    83      23.913   7.644  32.899  1.00 36.24      A   
ATOM    614  CB  SER    83      24.530   7.944  34.265  1.00 33.61      A   
ATOM    615  OG  SER    83      23.522   8.223  35.221  1.00 28.96      A   
ATOM    616  C   SER    83      22.911   8.738  32.572  1.00 33.85      A   
ATOM    617  O   SER    83      23.245   9.741  31.931  1.00 33.01      A   
ATOM    618  N   VAL    84      21.680   8.543  33.025  1.00 29.61      A   
ATOM    619  CA  VAL    84      20.651   9.537  32.810  1.00 29.31      A   
ATOM    620  CB  VAL    84      19.262   8.886  32.603  1.00 39.19      A   
ATOM    621  CG1 VAL    84      19.294   7.998  31.360  1.00 39.94      A   
ATOM    622  CG2 VAL    84      18.858   8.081  33.831  1.00 40.95      A   
ATOM    623  C   VAL    84      20.641  10.458  34.032  1.00 28.11      A   
ATOM    624  O   VAL    84      19.996  11.503  34.020  1.00 26.08      A   
ATOM    625  N   LYS    85      21.366  10.070  35.084  1.00 22.87      A   
ATOM    626  CA  LYS    85      21.445  10.895  36.293  1.00 22.83      A   
ATOM    627  CB  LYS    85      22.032  10.112  37.478  1.00 22.58      A   
ATOM    628  CG  LYS    85      21.174   8.979  38.029  1.00 28.58      A   
ATOM    629  CD  LYS    85      21.958   8.197  39.104  1.00 30.17      A   
ATOM    630  CE  LYS    85      21.265   6.899  39.500  1.00 34.34      A   
ATOM    631  NZ  LYS    85      22.133   6.072  40.407  1.00 31.90      A   
ATOM    632  C   LYS    85      22.382  12.043  35.974  1.00 22.94      A   
ATOM    633  O   LYS    85      23.359  11.853  35.252  1.00 22.47      A   
ATOM    634  N   VAL    86      22.135  13.217  36.543  1.00 27.51      A   
ATOM    635  CA  VAL    86      22.988  14.356  36.220  1.00 27.63      A   
ATOM    636  CB  VAL    86      22.190  15.440  35.448  1.00 25.37      A   
ATOM    637  CG1 VAL    86      21.432  14.805  34.289  1.00 26.36      A   
ATOM    638  CG2 VAL    86      21.223  16.150  36.390  1.00 27.29      A   
ATOM    639  C   VAL    86      23.616  15.002  37.443  1.00 29.12      A   
ATOM    640  O   VAL    86      23.017  15.023  38.522  1.00 30.61      A   
ATOM    641  N   LYS    87      24.809  15.556  37.248  1.00 22.01      A   
ATOM    642  CA  LYS    87      25.548  16.208  38.314  1.00 24.43      A   
ATOM    643  CB  LYS    87      26.761  15.336  38.671  1.00 40.98      A   
ATOM    644  CG  LYS    87      27.433  15.627  40.001  1.00 46.69      A   
ATOM    645  CD  LYS    87      28.325  14.450  40.447  1.00 48.24      A   
ATOM    646  CE  LYS    87      27.499  13.214  40.797  1.00 51.31      A   
ATOM    647  NZ  LYS    87      28.341  12.049  41.233  1.00 55.32      A   
ATOM    648  C   LYS    87      25.984  17.591  37.836  1.00 23.09      A   
ATOM    649  O   LYS    87      26.281  17.787  36.657  1.00 22.07      A   
ATOM    650  N   LEU    88      25.987  18.555  38.748  1.00 24.75      A   
ATOM    651  CA  LEU    88      26.404  19.905  38.422  1.00 25.06      A   
ATOM    652  CB  LEU    88      25.617  20.921  39.247  1.00 23.11      A   
ATOM    653  CG  LEU    88      26.078  22.376  39.097  1.00 25.69      A   
ATOM    654  CD1 LEU    88      25.804  22.876  37.676  1.00 22.82      A   
ATOM    655  CD2 LEU    88      25.346  23.244  40.126  1.00 23.24      A   
ATOM    656  C   LEU    88      27.898  20.086  38.685  1.00 24.86      A   
ATOM    657  O   LEU    88      28.363  19.882  39.801  1.00 26.07      A   
ATOM    658  N   HIS    89      28.646  20.443  37.645  1.00 22.24      A   
ATOM    659  CA  HIS    89      30.079  20.678  37.772  1.00 22.99      A   
ATOM    660  CB  HIS    89      30.815  20.154  36.552  1.00 28.93      A   
ATOM    661  CG  HIS    89      30.842  18.660  36.478  1.00 32.11      A   
ATOM    662  CD2 HIS    89      29.846  17.745  36.531  1.00 29.81      A   
ATOM    663  ND1 HIS    89      32.012  17.945  36.332  1.00 33.49      A   
ATOM    664  CE1 HIS    89      31.734  16.654  36.296  1.00 32.57      A   
ATOM    665  NE2 HIS    89      30.426  16.505  36.413  1.00 31.69      A   
ATOM    666  C   HIS    89      30.294  22.168  37.932  1.00 23.14      A   
ATOM    667  O   HIS    89      30.226  22.933  36.974  1.00 21.94      A   
ATOM    668  N   LEU    90      30.546  22.556  39.176  1.00 25.38      A   
ATOM    669  CA  LEU    90      30.716  23.946  39.568  1.00 25.66      A   
ATOM    670  CB  LEU    90      30.891  24.017  41.093  1.00 24.41      A   
ATOM    671  CG  LEU    90      29.697  23.422  41.858  1.00 24.48      A   
ATOM    672  CD1 LEU    90      30.026  23.294  43.349  1.00 25.49      A   
ATOM    673  CD2 LEU    90      28.469  24.309  41.660  1.00 23.44      A   
ATOM    674  C   LEU    90      31.827  24.715  38.882  1.00 26.58      A   
ATOM    675  O   LEU    90      32.948  24.216  38.725  1.00 24.89      A   
ATOM    676  N   GLN    91      31.503  25.937  38.467  1.00 23.53      A   
ATOM    677  CA  GLN    91      32.473  26.808  37.815  1.00 25.88      A   
ATOM    678  CB  GLN    91      32.095  27.034  36.348  1.00 27.74      A   
ATOM    679  CG  GLN    91      32.159  25.782  35.506  1.00 28.30      A   
ATOM    680  CD  GLN    91      31.774  26.050  34.068  1.00 30.80      A   
ATOM    681  OE1 GLN    91      30.673  26.513  33.794  1.00 27.87      A   
ATOM    682  NE2 GLN    91      32.684  25.763  33.140  1.00 32.48      A   
ATOM    683  C   GLN    91      32.515  28.131  38.568  1.00 26.48      A   
ATOM    684  O   GLN    91      33.488  28.875  38.477  1.00 28.32      A   
ATOM    685  N   GLN    92      31.442  28.422  39.298  1.00 26.61      A   
ATOM    686  CA  GLN    92      31.355  29.626  40.113  1.00 27.30      A   
ATOM    687  CB  GLN    92      30.724  30.797  39.352  1.00 41.60      A   
ATOM    688  CG  GLN    92      31.445  31.244  38.093  1.00 45.91      A   
ATOM    689  CD  GLN    92      30.909  32.574  37.586  1.00 49.65      A   
ATOM    690  OE1 GLN    92      29.706  32.814  37.603  1.00 52.22      A   
ATOM    691  NE2 GLN    92      31.801  33.438  37.130  1.00 52.57      A   
ATOM    692  C   GLN    92      30.486  29.326  41.328  1.00 28.32      A   
ATOM    693  O   GLN    92      29.496  28.590  41.244  1.00 25.42      A   
ATOM    694  N   ALA    93      30.856  29.897  42.464  1.00 25.17      A   
ATOM    695  CA  ALA    93      30.080  29.688  43.672  1.00 28.30      A   
ATOM    696  CB  ALA    93      30.458  28.362  44.319  1.00 41.80      A   
ATOM    697  C   ALA    93      30.330  30.823  44.640  1.00 30.53      A   
ATOM    698  O   ALA    93      31.444  31.339  44.722  1.00 29.69      A   
ATOM    699  N   ARG    94      29.284  31.224  45.353  1.00 29.52      A   
ATOM    700  CA  ARG    94      29.399  32.275  46.349  1.00 36.47      A   
ATOM    701  CB  ARG    94      29.080  33.652  45.749  1.00 66.16      A   
ATOM    702  CG  ARG    94      27.760  33.735  45.008  1.00 71.03      A   
ATOM    703  CD  ARG    94      26.758  34.634  45.723  1.00 76.08      A   
ATOM    704  NE  ARG    94      27.222  36.015  45.829  1.00 79.33      A   
ATOM    705  CZ  ARG    94      26.520  37.001  46.383  1.00 81.20      A   
ATOM    706  NH1 ARG    94      27.029  38.225  46.436  1.00 82.52      A   
ATOM    707  NH2 ARG    94      25.308  36.771  46.878  1.00 82.63      A   
ATOM    708  C   ARG    94      28.478  31.973  47.525  1.00 39.20      A   
ATOM    709  O   ARG    94      27.302  31.636  47.360  1.00 37.22      A   
ATOM    710  N   ARG    95      29.048  32.083  48.717  1.00 48.54      A   
ATOM    711  CA  ARG    95      28.346  31.826  49.964  1.00 54.70      A   
ATOM    712  CB  ARG    95      29.371  31.419  51.026  1.00 65.41      A   
ATOM    713  CG  ARG    95      28.864  31.285  52.442  1.00 68.11      A   
ATOM    714  CD  ARG    95      29.987  30.725  53.310  1.00 70.28      A   
ATOM    715  NE  ARG    95      29.590  30.495  54.696  1.00 72.39      A   
ATOM    716  CZ  ARG    95      30.260  29.720  55.544  1.00 72.88      A   
ATOM    717  NH1 ARG    95      31.364  29.096  55.149  1.00 73.41      A   
ATOM    718  NH2 ARG    95      29.824  29.563  56.786  1.00 74.05      A   
ATOM    719  C   ARG    95      27.595  33.077  50.395  1.00 57.64      A   
ATOM    720  O   ARG    95      28.201  34.125  50.610  1.00 58.67      A   
ATOM    721  N   ILE    96      26.273  32.969  50.506  1.00 76.07      A   
ATOM    722  CA  ILE    96      25.449  34.102  50.916  1.00 79.88      A   
ATOM    723  CB  ILE    96      24.011  34.007  50.355  1.00 69.35      A   
ATOM    724  CG2 ILE    96      23.276  35.308  50.633  1.00 69.35      A   
ATOM    725  CG1 ILE    96      24.042  33.731  48.850  1.00 69.24      A   
ATOM    726  CD1 ILE    96      22.682  33.474  48.244  1.00 69.56      A   
ATOM    727  C   ILE    96      25.353  34.158  52.440  1.00 82.47      A   
ATOM    728  O   ILE    96      24.751  33.284  53.064  1.00 82.91      A   
ATOM    729  N   ALA    97      25.946  35.189  53.034  1.00 94.57      A   
ATOM    730  CA  ALA    97      25.927  35.352  54.483  1.00 97.13      A   
ATOM    731  CB  ALA    97      27.216  36.007  54.952  1.00 79.37      A   
ATOM    732  C   ALA    97      24.739  36.199  54.903  1.00 98.75      A   
ATOM    733  O   ALA    97      24.671  37.386  54.585  1.00 99.27      A   
ATOM    734  N   GLY    98      23.806  35.583  55.621  1.00 99.99      A   
ATOM    735  CA  GLY    98      22.629  36.298  56.077  1.00101.66      A   
ATOM    736  C   GLY    98      22.852  36.898  57.451  1.00102.77      A   
ATOM    737  O   GLY    98      23.977  36.751  57.976  1.00103.27      A   
ATOM    738  OXT GLY    98      21.912  37.513  58.004  1.00 93.70      A   
END
