
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  158 ( 1279),  selected  158 , name 2hjv_A
# Molecule2: number of CA atoms  161 ( 1246),  selected  161 , name T0493.pdb
# PARAMETERS: 2hjv_A.T0493.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T   211_A      A       3           -
LGA    T   212_A      S       4           -
LGA    -       -      Y       5           -
LGA    R   213_A      R       6          4.108
LGA    N   214_A      S       7          4.246
LGA    -       -      T       8           -
LGA    -       -      Q       9           -
LGA    -       -      Q      10           -
LGA    I   215_A      I      11          3.580
LGA    -       -      T      12           -
LGA    -       -      D      13           -
LGA    -       -      F      14           -
LGA    -       -      T      15           -
LGA    -       -      K      16           -
LGA    -       -      E      17           -
LGA    -       -      I      18           -
LGA    -       -      L      19           -
LGA    -       -      V      20           -
LGA    -       -      N      21           -
LGA    -       -      R      30           -
LGA    -       -      Q      31           -
LGA    -       -      G      32           -
LGA    E   216_A      D      33          3.335
LGA    H   217_A      L      34          3.849
LGA    A   218_A      P      35          2.743
LGA    -       -      N      36           -
LGA    V   219_A      V      37          0.967
LGA    I   220_A      V      38          1.205
LGA    Q   221_A      V      39          1.885
LGA    V   222_A      T      40          1.332
LGA    R   223_A      P      41          1.501
LGA    E   224_A      N      42          2.611
LGA    E   225_A      F      43          2.823
LGA    -       -      E      44           -
LGA    N   226_A      A      45          1.063
LGA    K   227_A      G      46          0.378
LGA    F   228_A      V      47          0.814
LGA    S   229_A      D      48          1.236
LGA    L   230_A      Q      49          1.362
LGA    L   231_A      V      50          1.135
LGA    K   232_A      V      51          1.138
LGA    D   233_A      D      52          1.312
LGA    V   234_A      Q      53          1.355
LGA    L   235_A      L      54          1.287
LGA    M   236_A      A      55          1.564
LGA    T   237_A      M      56          1.906
LGA    E   238_A      N      57          2.059
LGA    N   239_A      D      58          1.299
LGA    P   240_A      S      59           #
LGA    -       -      E      60           -
LGA    -       -      R      61           -
LGA    D   241_A      D      62          3.787
LGA    S   242_A      T      63          1.765
LGA    C   243_A      T      64          1.243
LGA    I   244_A      A      65          1.320
LGA    I   245_A      I      66          1.023
LGA    F   246_A      I      67          1.738
LGA    C   247_A      G      68          1.766
LGA    R   248_A      K      69          2.546
LGA    T   249_A      S      70          2.670
LGA    K   250_A      L      71          1.740
LGA    E   251_A      A      72          1.819
LGA    H   252_A      E      73          1.818
LGA    V   253_A      C      74          0.946
LGA    N   254_A      E      75          0.957
LGA    Q   255_A      A      76          1.836
LGA    L   256_A      L      77          1.572
LGA    T   257_A      T      78          1.263
LGA    D   258_A      K      79          1.795
LGA    E   259_A      A      80          2.338
LGA    L   260_A      L      81          2.185
LGA    D   261_A      K      82          2.380
LGA    D   262_A      A      83          3.372
LGA    L   263_A      R      84          3.636
LGA    G   264_A      G      85          3.348
LGA    Y   265_A      E      86          1.948
LGA    P   266_A      Q      87          2.168
LGA    C   267_A      V      88          2.081
LGA    D   268_A      T      89          0.805
LGA    K   269_A      L      90          1.104
LGA    I   270_A      I      91          3.199
LGA    H   271_A      -       -           -
LGA    G   272_A      -       -           -
LGA    G   273_A      -       -           -
LGA    M   274_A      -       -           -
LGA    I   275_A      -       -           -
LGA    Q   276_A      -       -           -
LGA    E   277_A      -       -           -
LGA    D   278_A      Q      92          4.392
LGA    R   279_A      T      93          2.203
LGA    F   280_A      -       -           -
LGA    D   281_A      -       -           -
LGA    V   282_A      -       -           -
LGA    M   283_A      E      94          2.443
LGA    N   284_A      N      95          1.574
LGA    E   285_A      R      97          4.713
LGA    F   286_A      -       -           -
LGA    K   287_A      -       -           -
LGA    R   288_A      -       -           -
LGA    G   289_A      -       -           -
LGA    E   290_A      L      98           #
LGA    Y   291_A      A      99          3.770
LGA    -       -      P     100           -
LGA    R   292_A      G     101          2.985
LGA    Y   293_A      V     102          1.723
LGA    L   294_A      I     103          1.222
LGA    V   295_A      V     104          0.968
LGA    A   296_A      V     105          2.109
LGA    T   297_A      P     106          1.836
LGA    D   298_A      S     107          0.914
LGA    V   299_A      F     108          0.761
LGA    A   300_A      L     109          1.789
LGA    A   301_A      A     110          2.021
LGA    R   302_A      K     111          1.990
LGA    G   303_A      G     112          2.970
LGA    I   304_A      L     113          2.624
LGA    D   305_A      -       -           -
LGA    I   306_A      -       -           -
LGA    E   307_A      -       -           -
LGA    N   308_A      E     114          4.803
LGA    I   309_A      F     115          1.567
LGA    S   310_A      D     116          1.647
LGA    L   311_A      A     117          1.137
LGA    V   312_A      V     118          0.697
LGA    I   313_A      I     119          0.715
LGA    N   314_A      V     120          1.000
LGA    Y   315_A      W     121          1.446
LGA    D   316_A      N     122          1.322
LGA    L   317_A      A     123          0.998
LGA    P   318_A      N     124           #
LGA    -       -      Q     125           -
LGA    -       -      E     126           -
LGA    -       -      N     127           -
LGA    L   319_A      Y     128          1.677
LGA    -       -      Q     129           -
LGA    -       -      R     130           -
LGA    -       -      E     131           -
LGA    -       -      D     132           -
LGA    E   320_A      E     133          1.873
LGA    K   321_A      R     134          1.926
LGA    E   322_A      Q     135          1.933
LGA    S   323_A      L     136          2.284
LGA    Y   324_A      L     137          3.068
LGA    V   325_A      Y     138          2.924
LGA    H   326_A      T     139          1.420
LGA    R   327_A      I     140          1.807
LGA    T   328_A      C     141          3.779
LGA    -       -      S     142           -
LGA    G   329_A      R     143          2.725
LGA    R   330_A      A     144          5.317
LGA    T   331_A      M     145          1.786
LGA    G   332_A      H     146          3.713
LGA    R   333_A      -       -           -
LGA    A   334_A      -       -           -
LGA    G   335_A      -       -           -
LGA    N   336_A      -       -           -
LGA    K   337_A      -       -           -
LGA    G   338_A      -       -           -
LGA    K   339_A      E     147          0.824
LGA    A   340_A      L     148          0.654
LGA    I   341_A      T     149          0.690
LGA    S   342_A      L     150          0.682
LGA    F   343_A      V     151          1.455
LGA    V   344_A      A     152          2.853
LGA    T   345_A      V     153          4.234
LGA    A   346_A      G     154          4.562
LGA    F   347_A      S     155          3.223
LGA    E   348_A      L     156          3.252
LGA    K   349_A      S     157          4.905
LGA    R   350_A      P     158          1.826
LGA    F   351_A      L     159          2.263
LGA    L   352_A      L     160          1.555
LGA    A   353_A      A     161          1.536
LGA    D   354_A      R     162          4.652
LGA    I   355_A      -       -           -
LGA    E   356_A      V     163          2.227
LGA    E   357_A      -       -           -
LGA    Y   358_A      -       -           -
LGA    I   359_A      -       -           -
LGA    G   360_A      -       -           -
LGA    F   361_A      N     164          4.000
LGA    E   362_A      H     165          3.487
LGA    -       -      A     166           -
LGA    I   363_A      L     167          3.500
LGA    Q   364_A      Y     168          2.186
LGA    K   365_A      T     169          2.575
LGA    -       -      L     170           -
LGA    I   366_A      N     171          3.563
LGA    E   367_A      E     172          2.302
LGA    A   368_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  158  161    5.0    124    2.45    17.74     50.838     4.870

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.837087 * X  +  -0.296243 * Y  +  -0.459918 * Z  +  24.093397
  Y_new =  -0.509977 * X  +  -0.118268 * Y  +  -0.852019 * Z  + 105.633797
  Z_new =   0.198011 * X  +   0.947762 * Y  +  -0.250078 * Z  + -16.195774 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   1.828778   -1.312815  [ DEG:   104.7812    -75.2188 ]
  Theta =  -0.199328   -2.942264  [ DEG:   -11.4207   -168.5793 ]
  Phi   =  -0.547177    2.594416  [ DEG:   -31.3509    148.6491 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2hjv_A                                        
REMARK     2: T0493.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2hjv_A.T0493.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  158  161   5.0  124   2.45   17.74  50.838
REMARK  ---------------------------------------------------------- 
MOLECULE 2hjv_A
HEADER    HYDROLASE                               02-JUL-06   2HJV              
TITLE     STRUCTURE OF THE SECOND DOMAIN (RESIDUES 207-368) OF THE              
TITLE    2 BACILLUS SUBTILIS YXIN PROTEIN                                       
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ATP-DEPENDENT RNA HELICASE DBPA;                           
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 FRAGMENT: BACILLUS SUBTILIS YXIN DOMAIN 2 (RESIDUES 207-             
COMPND   5 368);                                                                
COMPND   6 EC: 3.6.1.-;                                                         
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACILLUS SUBTILIS;                              
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: DBPA;                                                          
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21(DE3);                                 
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PTWIN1                                    
KEYWDS    PARALLEL ALPHA-BETA                                                   
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    D.B.MCKAY,J.M.CARUTHERS                                               
REVDAT   1   12-DEC-06 2HJV    0                                                
JRNL        AUTH   J.M.CARUTHERS,Y.HU,D.B.MCKAY                                 
JRNL        TITL   STRUCTURE OF THE SECOND DOMAIN OF THE BACILLUS               
JRNL        TITL 2 SUBTILIS DEAD-BOX RNA HELICASE YXIN.                         
JRNL        REF    ACTA CRYSTALLOGR.,SECT.F      V.  62  1191 2006              
JRNL        REFN                DK ESSN 1744-3091                               
REMARK   2 RESOLUTION. 1.95 ANGSTROMS.                                          
DBREF  2HJV A  207   368  UNP    P42305   DBPA_BACSU     207    368             
DBREF  2HJV B  207   368  UNP    P42305   DBPA_BACSU     207    368             
SEQRES   1 A  163  MET ALA ALA GLY LEU THR THR ARG ASN ILE GLU HIS ALA          
SEQRES   2 A  163  VAL ILE GLN VAL ARG GLU GLU ASN LYS PHE SER LEU LEU          
SEQRES   3 A  163  LYS ASP VAL LEU MET THR GLU ASN PRO ASP SER CYS ILE          
SEQRES   4 A  163  ILE PHE CYS ARG THR LYS GLU HIS VAL ASN GLN LEU THR          
SEQRES   5 A  163  ASP GLU LEU ASP ASP LEU GLY TYR PRO CYS ASP LYS ILE          
SEQRES   6 A  163  HIS GLY GLY MET ILE GLN GLU ASP ARG PHE ASP VAL MET          
SEQRES   7 A  163  ASN GLU PHE LYS ARG GLY GLU TYR ARG TYR LEU VAL ALA          
SEQRES   8 A  163  THR ASP VAL ALA ALA ARG GLY ILE ASP ILE GLU ASN ILE          
SEQRES   9 A  163  SER LEU VAL ILE ASN TYR ASP LEU PRO LEU GLU LYS GLU          
SEQRES  10 A  163  SER TYR VAL HIS ARG THR GLY ARG THR GLY ARG ALA GLY          
SEQRES  11 A  163  ASN LYS GLY LYS ALA ILE SER PHE VAL THR ALA PHE GLU          
SEQRES  12 A  163  LYS ARG PHE LEU ALA ASP ILE GLU GLU TYR ILE GLY PHE          
SEQRES  13 A  163  GLU ILE GLN LYS ILE GLU ALA                                  
SEQRES   1 B  163  MET ALA ALA GLY LEU THR THR ARG ASN ILE GLU HIS ALA          
SEQRES   2 B  163  VAL ILE GLN VAL ARG GLU GLU ASN LYS PHE SER LEU LEU          
SEQRES   3 B  163  LYS ASP VAL LEU MET THR GLU ASN PRO ASP SER CYS ILE          
SEQRES   4 B  163  ILE PHE CYS ARG THR LYS GLU HIS VAL ASN GLN LEU THR          
SEQRES   5 B  163  ASP GLU LEU ASP ASP LEU GLY TYR PRO CYS ASP LYS ILE          
SEQRES   6 B  163  HIS GLY GLY MET ILE GLN GLU ASP ARG PHE ASP VAL MET          
SEQRES   7 B  163  ASN GLU PHE LYS ARG GLY GLU TYR ARG TYR LEU VAL ALA          
SEQRES   8 B  163  THR ASP VAL ALA ALA ARG GLY ILE ASP ILE GLU ASN ILE          
SEQRES   9 B  163  SER LEU VAL ILE ASN TYR ASP LEU PRO LEU GLU LYS GLU          
SEQRES  10 B  163  SER TYR VAL HIS ARG THR GLY ARG THR GLY ARG ALA GLY          
SEQRES  11 B  163  ASN LYS GLY LYS ALA ILE SER PHE VAL THR ALA PHE GLU          
SEQRES  12 B  163  LYS ARG PHE LEU ALA ASP ILE GLU GLU TYR ILE GLY PHE          
SEQRES  13 B  163  GLU ILE GLN LYS ILE GLU ALA                                  
FORMUL   3  HOH   *163(H2 O)                                                    
CRYST1  105.200  105.200   66.030  90.00  90.00 120.00 P 61         12          
ATOM      1  N   THR A 211      21.270  47.057  -8.287  1.00 39.54           N  
ATOM      2  CA  THR A 211      22.527  46.645  -8.982  1.00 40.94           C  
ATOM      3  C   THR A 211      23.673  46.356  -8.000  1.00 39.29           C  
ATOM      4  O   THR A 211      23.871  47.083  -7.029  1.00 38.70           O  
ATOM      5  CB  THR A 211      22.986  47.724  -9.971  1.00 42.48           C  
ATOM      6  OG1 THR A 211      24.357  47.498 -10.305  1.00 46.45           O  
ATOM      7  CG2 THR A 211      22.830  49.104  -9.371  1.00 42.87           C  
ATOM      8  N   THR A 212      24.436  45.305  -8.280  1.00 37.40           N  
ATOM      9  CA  THR A 212      25.529  44.887  -7.413  1.00 36.81           C  
ATOM     10  C   THR A 212      26.689  45.877  -7.303  1.00 36.77           C  
ATOM     11  O   THR A 212      27.215  46.355  -8.310  1.00 34.51           O  
ATOM     12  CB  THR A 212      26.104  43.529  -7.882  1.00 36.68           C  
ATOM     13  OG1 THR A 212      25.044  42.567  -8.000  1.00 34.87           O  
ATOM     14  CG2 THR A 212      27.145  43.017  -6.889  1.00 37.86           C  
ATOM     15  N   ARG A 213      27.080  46.180  -6.065  1.00 37.74           N  
ATOM     16  CA  ARG A 213      28.211  47.067  -5.805  1.00 37.41           C  
ATOM     17  C   ARG A 213      29.411  46.161  -5.571  1.00 36.45           C  
ATOM     18  O   ARG A 213      29.290  45.116  -4.937  1.00 38.60           O  
ATOM     19  CB  ARG A 213      27.974  47.923  -4.551  1.00 39.04           C  
ATOM     20  CG  ARG A 213      26.992  49.068  -4.746  1.00 39.51           C  
ATOM     21  CD  ARG A 213      27.556  50.150  -5.650  1.00 39.19           C  
ATOM     22  NE  ARG A 213      28.565  50.986  -5.002  1.00 40.73           N  
ATOM     23  CZ  ARG A 213      28.330  51.791  -3.969  1.00 42.39           C  
ATOM     24  NH1 ARG A 213      27.113  51.873  -3.444  1.00 41.37           N  
ATOM     25  NH2 ARG A 213      29.307  52.545  -3.477  1.00 41.64           N  
ATOM     26  N   ASN A 214      30.566  46.543  -6.088  1.00 34.31           N  
ATOM     27  CA  ASN A 214      31.757  45.729  -5.897  1.00 34.40           C  
ATOM     28  C   ASN A 214      32.835  46.524  -5.190  1.00 33.91           C  
ATOM     29  O   ASN A 214      33.608  47.243  -5.821  1.00 33.43           O  
ATOM     30  CB  ASN A 214      32.267  45.214  -7.243  1.00 35.22           C  
ATOM     31  CG  ASN A 214      31.337  44.184  -7.850  1.00 38.16           C  
ATOM     32  OD1 ASN A 214      31.196  43.072  -7.329  1.00 38.97           O  
ATOM     33  ND2 ASN A 214      30.679  44.551  -8.940  1.00 38.84           N  
ATOM     34  N   ILE A 215      32.866  46.393  -3.868  1.00 32.18           N  
ATOM     35  CA  ILE A 215      33.852  47.089  -3.060  1.00 32.43           C  
ATOM     36  C   ILE A 215      34.486  46.145  -2.060  1.00 31.25           C  
ATOM     37  O   ILE A 215      33.804  45.531  -1.245  1.00 29.29           O  
ATOM     38  CB  ILE A 215      33.224  48.260  -2.249  1.00 33.47           C  
ATOM     39  CG1 ILE A 215      32.581  49.281  -3.194  1.00 31.53           C  
ATOM     40  CG2 ILE A 215      34.311  48.947  -1.401  1.00 34.46           C  
ATOM     41  CD1 ILE A 215      31.844  50.385  -2.466  1.00 34.26           C  
ATOM     42  N   GLU A 216      35.800  46.020  -2.144  1.00 31.17           N  
ATOM     43  CA  GLU A 216      36.548  45.210  -1.202  1.00 31.88           C  
ATOM     44  C   GLU A 216      36.896  46.209  -0.089  1.00 30.31           C  
ATOM     45  O   GLU A 216      37.430  47.281  -0.377  1.00 28.47           O  
ATOM     46  CB  GLU A 216      37.816  44.693  -1.874  1.00 36.22           C  
ATOM     47  CG  GLU A 216      38.827  44.074  -0.940  1.00 43.28           C  
ATOM     48  CD  GLU A 216      40.012  43.495  -1.692  1.00 47.59           C  
ATOM     49  OE1 GLU A 216      40.564  44.200  -2.565  1.00 49.79           O  
ATOM     50  OE2 GLU A 216      40.394  42.339  -1.409  1.00 51.32           O  
ATOM     51  N   HIS A 217      36.570  45.879   1.160  1.00 27.27           N  
ATOM     52  CA  HIS A 217      36.873  46.764   2.283  1.00 26.65           C  
ATOM     53  C   HIS A 217      38.009  46.148   3.107  1.00 26.63           C  
ATOM     54  O   HIS A 217      38.090  44.919   3.241  1.00 25.46           O  
ATOM     55  CB  HIS A 217      35.661  46.928   3.207  1.00 26.92           C  
ATOM     56  CG  HIS A 217      34.413  47.385   2.518  1.00 26.30           C  
ATOM     57  ND1 HIS A 217      33.908  48.662   2.660  1.00 27.50           N  
ATOM     58  CD2 HIS A 217      33.542  46.723   1.716  1.00 28.23           C  
ATOM     59  CE1 HIS A 217      32.780  48.764   1.978  1.00 28.94           C  
ATOM     60  NE2 HIS A 217      32.535  47.603   1.395  1.00 26.22           N  
ATOM     61  N   ALA A 218      38.877  46.995   3.654  1.00 22.28           N  
ATOM     62  CA  ALA A 218      39.980  46.519   4.479  1.00 22.65           C  
ATOM     63  C   ALA A 218      40.401  47.604   5.458  1.00 23.27           C  
ATOM     64  O   ALA A 218      40.284  48.808   5.180  1.00 22.90           O  
ATOM     65  CB  ALA A 218      41.169  46.108   3.621  1.00 21.60           C  
ATOM     66  N   VAL A 219      40.873  47.155   6.613  1.00 22.54           N  
ATOM     67  CA  VAL A 219      41.327  48.029   7.671  1.00 22.42           C  
ATOM     68  C   VAL A 219      42.779  47.689   7.960  1.00 23.15           C  
ATOM     69  O   VAL A 219      43.185  46.517   7.925  1.00 23.35           O  
ATOM     70  CB  VAL A 219      40.503  47.818   8.979  1.00 22.41           C  
ATOM     71  CG1 VAL A 219      41.318  48.321  10.194  1.00 25.69           C  
ATOM     72  CG2 VAL A 219      39.162  48.578   8.894  1.00 24.85           C  
ATOM     73  N   ILE A 220      43.575  48.720   8.195  1.00 21.09           N  
ATOM     74  CA  ILE A 220      44.966  48.503   8.541  1.00 24.38           C  
ATOM     75  C   ILE A 220      45.204  49.237   9.844  1.00 24.38           C  
ATOM     76  O   ILE A 220      44.987  50.443   9.920  1.00 23.02           O  
ATOM     77  CB  ILE A 220      45.934  49.066   7.509  1.00 23.52           C  
ATOM     78  CG1 ILE A 220      45.726  48.363   6.159  1.00 24.69           C  
ATOM     79  CG2 ILE A 220      47.377  48.833   7.991  1.00 25.50           C  
ATOM     80  CD1 ILE A 220      46.562  48.956   5.031  1.00 30.77           C  
ATOM     81  N   GLN A 221      45.633  48.507  10.866  1.00 24.20           N  
ATOM     82  CA  GLN A 221      45.916  49.119  12.151  1.00 26.17           C  
ATOM     83  C   GLN A 221      47.280  49.800  12.028  1.00 24.97           C  
ATOM     84  O   GLN A 221      48.271  49.189  11.610  1.00 24.01           O  
ATOM     85  CB  GLN A 221      45.900  48.045  13.250  1.00 30.05           C  
ATOM     86  CG  GLN A 221      44.539  47.374  13.389  1.00 31.35           C  
ATOM     87  CD  GLN A 221      44.568  46.125  14.256  1.00 36.75           C  
ATOM     88  OE1 GLN A 221      45.498  45.321  14.177  1.00 40.68           O  
ATOM     89  NE2 GLN A 221      43.540  45.947  15.073  1.00 35.03           N  
ATOM     90  N   VAL A 222      47.332  51.073  12.391  1.00 25.70           N  
ATOM     91  CA  VAL A 222      48.566  51.821  12.262  1.00 26.47           C  
ATOM     92  C   VAL A 222      48.618  52.972  13.260  1.00 27.42           C  
ATOM     93  O   VAL A 222      47.590  53.576  13.589  1.00 28.21           O  
ATOM     94  CB  VAL A 222      48.676  52.396  10.812  1.00 27.59           C  
ATOM     95  CG1 VAL A 222      47.551  53.403  10.565  1.00 27.92           C  
ATOM     96  CG2 VAL A 222      50.037  53.034  10.585  1.00 27.53           C  
ATOM     97  N   ARG A 223      49.819  53.283  13.732  1.00 27.01           N  
ATOM     98  CA  ARG A 223      49.983  54.393  14.655  1.00 29.17           C  
ATOM     99  C   ARG A 223      49.933  55.692  13.847  1.00 28.98           C  
ATOM    100  O   ARG A 223      50.347  55.740  12.679  1.00 26.91           O  
ATOM    101  CB  ARG A 223      51.317  54.262  15.404  1.00 30.32           C  
ATOM    102  CG  ARG A 223      51.432  52.978  16.219  1.00 32.69           C  
ATOM    103  CD  ARG A 223      52.884  52.717  16.625  1.00 35.68           C  
ATOM    104  NE  ARG A 223      53.380  53.754  17.521  1.00 37.71           N  
ATOM    105  CZ  ARG A 223      53.177  53.760  18.834  1.00 41.02           C  
ATOM    106  NH1 ARG A 223      52.496  52.777  19.403  1.00 40.19           N  
ATOM    107  NH2 ARG A 223      53.649  54.755  19.579  1.00 42.32           N  
ATOM    108  N   GLU A 224      49.416  56.746  14.463  1.00 29.40           N  
ATOM    109  CA  GLU A 224      49.290  58.029  13.781  1.00 30.86           C  
ATOM    110  C   GLU A 224      50.558  58.509  13.074  1.00 33.15           C  
ATOM    111  O   GLU A 224      50.498  58.950  11.920  1.00 32.02           O  
ATOM    112  CB  GLU A 224      48.814  59.109  14.763  1.00 34.25           C  
ATOM    113  CG  GLU A 224      48.517  60.446  14.096  1.00 39.10           C  
ATOM    114  CD  GLU A 224      47.265  60.408  13.225  1.00 42.03           C  
ATOM    115  OE1 GLU A 224      47.105  61.305  12.362  1.00 45.61           O  
ATOM    116  OE2 GLU A 224      46.433  59.494  13.411  1.00 42.12           O  
ATOM    117  N   GLU A 225      51.698  58.416  13.759  1.00 31.90           N  
ATOM    118  CA  GLU A 225      52.982  58.858  13.209  1.00 33.88           C  
ATOM    119  C   GLU A 225      53.515  58.012  12.043  1.00 31.71           C  
ATOM    120  O   GLU A 225      54.466  58.410  11.369  1.00 31.03           O  
ATOM    121  CB  GLU A 225      54.041  58.902  14.329  1.00 37.52           C  
ATOM    122  CG  GLU A 225      54.318  57.549  14.964  1.00 40.50           C  
ATOM    123  CD  GLU A 225      53.507  57.279  16.227  1.00 43.77           C  
ATOM    124  OE1 GLU A 225      52.323  57.692  16.306  1.00 42.76           O  
ATOM    125  OE2 GLU A 225      54.066  56.633  17.142  1.00 46.45           O  
ATOM    126  N   ASN A 226      52.916  56.850  11.804  1.00 29.26           N  
ATOM    127  CA  ASN A 226      53.351  55.987  10.712  1.00 27.70           C  
ATOM    128  C   ASN A 226      52.367  55.953   9.526  1.00 25.80           C  
ATOM    129  O   ASN A 226      52.540  55.180   8.595  1.00 25.39           O  
ATOM    130  CB  ASN A 226      53.577  54.558  11.207  1.00 31.25           C  
ATOM    131  CG  ASN A 226      54.635  54.479  12.289  1.00 34.66           C  
ATOM    132  OD1 ASN A 226      55.681  55.129  12.200  1.00 36.03           O  
ATOM    133  ND2 ASN A 226      54.375  53.678  13.310  1.00 37.09           N  
ATOM    134  N   LYS A 227      51.332  56.776   9.576  1.00 24.05           N  
ATOM    135  CA  LYS A 227      50.346  56.815   8.505  1.00 24.41           C  
ATOM    136  C   LYS A 227      50.914  57.265   7.155  1.00 23.01           C  
ATOM    137  O   LYS A 227      50.590  56.678   6.135  1.00 23.29           O  
ATOM    138  CB  LYS A 227      49.182  57.735   8.884  1.00 23.16           C  
ATOM    139  CG  LYS A 227      48.183  57.133   9.886  1.00 22.23           C  
ATOM    140  CD  LYS A 227      47.055  58.146  10.148  1.00 24.11           C  
ATOM    141  CE  LYS A 227      45.930  57.561  11.013  1.00 23.17           C  
ATOM    142  NZ  LYS A 227      44.848  58.579  11.266  1.00 22.96           N  
ATOM    143  N   PHE A 228      51.760  58.291   7.139  1.00 25.04           N  
ATOM    144  CA  PHE A 228      52.269  58.750   5.855  1.00 26.85           C  
ATOM    145  C   PHE A 228      53.108  57.671   5.197  1.00 27.39           C  
ATOM    146  O   PHE A 228      52.992  57.426   4.008  1.00 27.36           O  
ATOM    147  CB  PHE A 228      53.088  60.039   5.998  1.00 29.50           C  
ATOM    148  CG  PHE A 228      53.534  60.598   4.680  1.00 32.44           C  
ATOM    149  CD1 PHE A 228      52.595  61.023   3.748  1.00 33.84           C  
ATOM    150  CD2 PHE A 228      54.884  60.642   4.341  1.00 33.81           C  
ATOM    151  CE1 PHE A 228      52.992  61.485   2.487  1.00 34.13           C  
ATOM    152  CE2 PHE A 228      55.286  61.102   3.091  1.00 34.31           C  
ATOM    153  CZ  PHE A 228      54.338  61.522   2.164  1.00 34.41           C  
ATOM    154  N   SER A 229      53.962  57.025   5.978  1.00 28.25           N  
ATOM    155  CA  SER A 229      54.788  55.958   5.439  1.00 30.09           C  
ATOM    156  C   SER A 229      53.888  54.836   4.902  1.00 28.66           C  
ATOM    157  O   SER A 229      54.170  54.256   3.857  1.00 28.48           O  
ATOM    158  CB  SER A 229      55.732  55.429   6.528  1.00 31.30           C  
ATOM    159  OG  SER A 229      56.337  54.225   6.121  1.00 35.55           O  
ATOM    160  N   LEU A 230      52.787  54.561   5.603  1.00 27.77           N  
ATOM    161  CA  LEU A 230      51.836  53.524   5.186  1.00 27.25           C  
ATOM    162  C   LEU A 230      51.142  53.936   3.875  1.00 26.13           C  
ATOM    163  O   LEU A 230      50.953  53.118   2.982  1.00 25.90           O  
ATOM    164  CB  LEU A 230      50.762  53.315   6.266  1.00 25.91           C  
ATOM    165  CG  LEU A 230      50.158  51.930   6.565  1.00 31.07           C  
ATOM    166  CD1 LEU A 230      48.673  52.088   6.963  1.00 27.17           C  
ATOM    167  CD2 LEU A 230      50.290  50.993   5.386  1.00 25.92           C  
ATOM    168  N   LEU A 231      50.750  55.204   3.771  1.00 24.88           N  
ATOM    169  CA  LEU A 231      50.087  55.676   2.558  1.00 24.81           C  
ATOM    170  C   LEU A 231      50.983  55.444   1.335  1.00 25.67           C  
ATOM    171  O   LEU A 231      50.524  54.949   0.315  1.00 24.48           O  
ATOM    172  CB  LEU A 231      49.742  57.159   2.674  1.00 23.88           C  
ATOM    173  CG  LEU A 231      49.098  57.810   1.439  1.00 22.62           C  
ATOM    174  CD1 LEU A 231      47.703  57.185   1.150  1.00 24.00           C  
ATOM    175  CD2 LEU A 231      48.951  59.298   1.698  1.00 23.80           C  
ATOM    176  N   LYS A 232      52.261  55.786   1.454  1.00 27.48           N  
ATOM    177  CA  LYS A 232      53.190  55.594   0.345  1.00 30.49           C  
ATOM    178  C   LYS A 232      53.266  54.119  -0.076  1.00 30.22           C  
ATOM    179  O   LYS A 232      53.333  53.818  -1.264  1.00 29.33           O  
ATOM    180  CB  LYS A 232      54.579  56.121   0.721  1.00 32.67           C  
ATOM    181  CG  LYS A 232      54.594  57.613   1.066  1.00 35.08           C  
ATOM    182  CD  LYS A 232      56.015  58.156   1.166  1.00 38.81           C  
ATOM    183  CE  LYS A 232      56.783  57.553   2.334  1.00 40.19           C  
ATOM    184  NZ  LYS A 232      58.224  57.969   2.307  1.00 42.93           N  
ATOM    185  N   ASP A 233      53.246  53.208   0.893  1.00 31.17           N  
ATOM    186  CA  ASP A 233      53.279  51.775   0.586  1.00 32.16           C  
ATOM    187  C   ASP A 233      51.980  51.308  -0.085  1.00 31.63           C  
ATOM    188  O   ASP A 233      52.006  50.526  -1.035  1.00 31.21           O  
ATOM    189  CB  ASP A 233      53.504  50.949   1.853  1.00 36.57           C  
ATOM    190  CG  ASP A 233      54.872  51.182   2.471  1.00 42.48           C  
ATOM    191  OD1 ASP A 233      55.827  51.486   1.717  1.00 46.23           O  
ATOM    192  OD2 ASP A 233      55.003  51.048   3.709  1.00 45.86           O  
ATOM    193  N   VAL A 234      50.844  51.783   0.418  1.00 29.52           N  
ATOM    194  CA  VAL A 234      49.541  51.416  -0.142  1.00 28.20           C  
ATOM    195  C   VAL A 234      49.409  51.898  -1.587  1.00 28.92           C  
ATOM    196  O   VAL A 234      48.933  51.152  -2.452  1.00 27.53           O  
ATOM    197  CB  VAL A 234      48.389  52.005   0.729  1.00 29.71           C  
ATOM    198  CG1 VAL A 234      47.031  51.896  -0.000  1.00 29.27           C  
ATOM    199  CG2 VAL A 234      48.346  51.270   2.057  1.00 26.97           C  
ATOM    200  N   LEU A 235      49.844  53.130  -1.856  1.00 29.29           N  
ATOM    201  CA  LEU A 235      49.764  53.672  -3.208  1.00 31.30           C  
ATOM    202  C   LEU A 235      50.704  52.908  -4.134  1.00 33.30           C  
ATOM    203  O   LEU A 235      50.368  52.634  -5.284  1.00 33.20           O  
ATOM    204  CB  LEU A 235      50.103  55.170  -3.217  1.00 31.59           C  
ATOM    205  CG  LEU A 235      49.082  56.068  -2.507  1.00 31.96           C  
ATOM    206  CD1 LEU A 235      49.498  57.515  -2.576  1.00 33.68           C  
ATOM    207  CD2 LEU A 235      47.725  55.879  -3.157  1.00 33.10           C  
ATOM    208  N   MET A 236      51.873  52.544  -3.617  1.00 34.28           N  
ATOM    209  CA  MET A 236      52.846  51.791  -4.402  1.00 37.26           C  
ATOM    210  C   MET A 236      52.274  50.420  -4.761  1.00 36.16           C  
ATOM    211  O   MET A 236      52.381  49.975  -5.909  1.00 35.59           O  
ATOM    212  CB  MET A 236      54.144  51.616  -3.609  1.00 41.19           C  
ATOM    213  CG  MET A 236      55.177  50.745  -4.292  1.00 47.43           C  
ATOM    214  SD  MET A 236      56.439  51.735  -5.071  1.00 56.34           S  
ATOM    215  CE  MET A 236      55.476  52.575  -6.346  1.00 51.15           C  
ATOM    216  N   THR A 237      51.646  49.765  -3.787  1.00 34.13           N  
ATOM    217  CA  THR A 237      51.067  48.445  -4.007  1.00 34.27           C  
ATOM    218  C   THR A 237      49.762  48.450  -4.805  1.00 34.79           C  
ATOM    219  O   THR A 237      49.573  47.614  -5.687  1.00 33.58           O  
ATOM    220  CB  THR A 237      50.827  47.714  -2.667  1.00 36.53           C  
ATOM    221  OG1 THR A 237      52.037  47.723  -1.902  1.00 39.86           O  
ATOM    222  CG2 THR A 237      50.429  46.257  -2.908  1.00 35.83           C  
ATOM    223  N   GLU A 238      48.848  49.368  -4.495  1.00 33.32           N  
ATOM    224  CA  GLU A 238      47.584  49.427  -5.225  1.00 34.29           C  
ATOM    225  C   GLU A 238      47.720  50.076  -6.607  1.00 34.58           C  
ATOM    226  O   GLU A 238      46.985  49.727  -7.533  1.00 33.26           O  
ATOM    227  CB  GLU A 238      46.528  50.185  -4.411  1.00 35.45           C  
ATOM    228  CG  GLU A 238      46.068  49.478  -3.141  1.00 37.06           C  
ATOM    229  CD  GLU A 238      45.365  48.162  -3.424  1.00 41.13           C  
ATOM    230  OE1 GLU A 238      44.548  48.109  -4.368  1.00 42.13           O  
ATOM    231  OE2 GLU A 238      45.619  47.183  -2.689  1.00 42.75           O  
ATOM    232  N   ASN A 239      48.640  51.029  -6.740  1.00 34.40           N  
ATOM    233  CA  ASN A 239      48.870  51.720  -8.015  1.00 35.04           C  
ATOM    234  C   ASN A 239      47.545  52.060  -8.714  1.00 34.83           C  
ATOM    235  O   ASN A 239      47.355  51.758  -9.889  1.00 34.34           O  
ATOM    236  CB  ASN A 239      49.732  50.824  -8.921  1.00 38.19           C  
ATOM    237  CG  ASN A 239      50.160  51.519 -10.203  1.00 39.84           C  
ATOM    238  OD1 ASN A 239      50.560  52.681 -10.192  1.00 38.43           O  
ATOM    239  ND2 ASN A 239      50.097  50.790 -11.317  1.00 43.80           N  
ATOM    240  N   PRO A 240      46.621  52.726  -8.000  1.00 34.28           N  
ATOM    241  CA  PRO A 240      45.313  53.090  -8.566  1.00 32.38           C  
ATOM    242  C   PRO A 240      45.316  54.147  -9.672  1.00 32.93           C  
ATOM    243  O   PRO A 240      46.158  55.041  -9.677  1.00 31.82           O  
ATOM    244  CB  PRO A 240      44.539  53.569  -7.335  1.00 32.76           C  
ATOM    245  CG  PRO A 240      45.604  54.296  -6.556  1.00 32.80           C  
ATOM    246  CD  PRO A 240      46.814  53.349  -6.674  1.00 32.39           C  
ATOM    247  N   ASP A 241      44.364  54.051 -10.600  1.00 34.63           N  
ATOM    248  CA  ASP A 241      44.264  55.053 -11.658  1.00 36.45           C  
ATOM    249  C   ASP A 241      43.581  56.299 -11.095  1.00 35.42           C  
ATOM    250  O   ASP A 241      43.867  57.410 -11.535  1.00 35.62           O  
ATOM    251  CB  ASP A 241      43.498  54.534 -12.889  1.00 39.74           C  
ATOM    252  CG  ASP A 241      42.220  53.806 -12.534  1.00 44.39           C  
ATOM    253  OD1 ASP A 241      41.485  54.271 -11.640  1.00 47.95           O  
ATOM    254  OD2 ASP A 241      41.943  52.762 -13.174  1.00 48.54           O  
ATOM    255  N   SER A 242      42.692  56.103 -10.115  1.00 31.92           N  
ATOM    256  CA  SER A 242      42.003  57.212  -9.442  1.00 28.98           C  
ATOM    257  C   SER A 242      41.836  56.847  -7.959  1.00 27.98           C  
ATOM    258  O   SER A 242      41.414  55.737  -7.624  1.00 25.29           O  
ATOM    259  CB  SER A 242      40.632  57.493 -10.065  1.00 28.74           C  
ATOM    260  OG  SER A 242      39.741  56.404  -9.913  1.00 27.00           O  
ATOM    261  N   CYS A 243      42.159  57.795  -7.085  1.00 26.02           N  
ATOM    262  CA  CYS A 243      42.095  57.565  -5.645  1.00 25.38           C  
ATOM    263  C   CYS A 243      41.793  58.842  -4.847  1.00 24.20           C  
ATOM    264  O   CYS A 243      42.321  59.918  -5.133  1.00 22.70           O  
ATOM    265  CB  CYS A 243      43.433  56.956  -5.196  1.00 25.45           C  
ATOM    266  SG  CYS A 243      43.702  56.889  -3.414  1.00 27.48           S  
ATOM    267  N   ILE A 244      40.904  58.726  -3.871  1.00 22.29           N  
ATOM    268  CA  ILE A 244      40.593  59.869  -3.044  1.00 19.78           C  
ATOM    269  C   ILE A 244      41.017  59.500  -1.630  1.00 19.87           C  
ATOM    270  O   ILE A 244      40.685  58.432  -1.136  1.00 21.09           O  
ATOM    271  CB  ILE A 244      39.102  60.220  -3.118  1.00 20.61           C  
ATOM    272  CG1 ILE A 244      38.825  61.462  -2.272  1.00 22.34           C  
ATOM    273  CG2 ILE A 244      38.245  59.038  -2.668  1.00 22.53           C  
ATOM    274  CD1 ILE A 244      37.574  62.183  -2.755  1.00 28.68           C  
ATOM    275  N   ILE A 245      41.785  60.382  -1.008  1.00 20.72           N  
ATOM    276  CA  ILE A 245      42.300  60.162   0.339  1.00 20.64           C  
ATOM    277  C   ILE A 245      41.625  61.150   1.290  1.00 18.60           C  
ATOM    278  O   ILE A 245      41.913  62.349   1.274  1.00 18.52           O  
ATOM    279  CB  ILE A 245      43.818  60.375   0.364  1.00 20.22           C  
ATOM    280  CG1 ILE A 245      44.482  59.482  -0.704  1.00 21.56           C  
ATOM    281  CG2 ILE A 245      44.375  60.016   1.741  1.00 23.08           C  
ATOM    282  CD1 ILE A 245      45.855  59.963  -1.102  1.00 22.51           C  
ATOM    283  N   PHE A 246      40.711  60.634   2.104  1.00 21.17           N  
ATOM    284  CA  PHE A 246      39.954  61.460   3.034  1.00 21.05           C  
ATOM    285  C   PHE A 246      40.609  61.691   4.384  1.00 23.48           C  
ATOM    286  O   PHE A 246      41.102  60.753   5.009  1.00 22.69           O  
ATOM    287  CB  PHE A 246      38.573  60.857   3.279  1.00 19.77           C  
ATOM    288  CG  PHE A 246      37.630  61.004   2.123  1.00 21.30           C  
ATOM    289  CD1 PHE A 246      37.288  59.906   1.343  1.00 20.98           C  
ATOM    290  CD2 PHE A 246      37.086  62.239   1.814  1.00 21.98           C  
ATOM    291  CE1 PHE A 246      36.414  60.037   0.270  1.00 22.26           C  
ATOM    292  CE2 PHE A 246      36.208  62.384   0.743  1.00 23.77           C  
ATOM    293  CZ  PHE A 246      35.873  61.276  -0.031  1.00 24.45           C  
ATOM    294  N   CYS A 247      40.598  62.949   4.817  1.00 23.10           N  
ATOM    295  CA  CYS A 247      41.144  63.333   6.111  1.00 23.53           C  
ATOM    296  C   CYS A 247      40.018  64.005   6.896  1.00 24.25           C  
ATOM    297  O   CYS A 247      39.029  64.474   6.312  1.00 22.29           O  
ATOM    298  CB  CYS A 247      42.304  64.317   5.951  1.00 23.49           C  
ATOM    299  SG  CYS A 247      43.706  63.636   5.023  1.00 28.63           S  
ATOM    300  N   ARG A 248      40.189  64.082   8.209  1.00 23.85           N  
ATOM    301  CA  ARG A 248      39.172  64.687   9.061  1.00 25.18           C  
ATOM    302  C   ARG A 248      39.131  66.217   9.082  1.00 25.49           C  
ATOM    303  O   ARG A 248      38.060  66.815   9.220  1.00 26.29           O  
ATOM    304  CB  ARG A 248      39.329  64.188  10.502  1.00 27.66           C  
ATOM    305  CG  ARG A 248      38.159  64.610  11.402  1.00 29.91           C  
ATOM    306  CD  ARG A 248      38.293  63.981  12.789  1.00 32.56           C  
ATOM    307  NE  ARG A 248      39.450  64.504  13.502  1.00 37.11           N  
ATOM    308  CZ  ARG A 248      39.465  65.645  14.185  1.00 39.70           C  
ATOM    309  NH1 ARG A 248      38.373  66.402  14.258  1.00 41.12           N  
ATOM    310  NH2 ARG A 248      40.580  66.037  14.794  1.00 41.97           N  
ATOM    311  N   THR A 249      40.279  66.858   8.941  1.00 23.85           N  
ATOM    312  CA  THR A 249      40.314  68.322   8.997  1.00 24.17           C  
ATOM    313  C   THR A 249      41.088  68.909   7.838  1.00 24.21           C  
ATOM    314  O   THR A 249      41.924  68.217   7.219  1.00 22.38           O  
ATOM    315  CB  THR A 249      41.002  68.791  10.274  1.00 25.53           C  
ATOM    316  OG1 THR A 249      42.386  68.403  10.226  1.00 23.52           O  
ATOM    317  CG2 THR A 249      40.349  68.142  11.490  1.00 27.53           C  
ATOM    318  N   LYS A 250      40.838  70.187   7.552  1.00 23.70           N  
ATOM    319  CA  LYS A 250      41.544  70.845   6.460  1.00 24.28           C  
ATOM    320  C   LYS A 250      43.032  70.935   6.778  1.00 24.75           C  
ATOM    321  O   LYS A 250      43.866  70.936   5.871  1.00 22.19           O  
ATOM    322  CB  LYS A 250      40.971  72.243   6.185  1.00 25.30           C  
ATOM    323  CG  LYS A 250      40.979  73.216   7.358  1.00 28.63           C  
ATOM    324  CD  LYS A 250      40.375  74.553   6.896  1.00 29.12           C  
ATOM    325  CE  LYS A 250      40.382  75.601   8.009  1.00 30.92           C  
ATOM    326  NZ  LYS A 250      39.701  76.857   7.528  1.00 32.73           N  
ATOM    327  N   GLU A 251      43.365  71.004   8.068  1.00 24.83           N  
ATOM    328  CA  GLU A 251      44.772  71.066   8.468  1.00 27.39           C  
ATOM    329  C   GLU A 251      45.509  69.781   8.065  1.00 26.48           C  
ATOM    330  O   GLU A 251      46.660  69.830   7.604  1.00 24.42           O  
ATOM    331  CB  GLU A 251      44.898  71.306   9.983  1.00 29.63           C  
ATOM    332  CG  GLU A 251      44.588  72.745  10.423  1.00 34.85           C  
ATOM    333  CD  GLU A 251      43.089  73.047  10.598  1.00 38.75           C  
ATOM    334  OE1 GLU A 251      42.758  74.244  10.814  1.00 39.10           O  
ATOM    335  OE2 GLU A 251      42.253  72.109  10.531  1.00 35.69           O  
ATOM    336  N   HIS A 252      44.850  68.634   8.241  1.00 24.63           N  
ATOM    337  CA  HIS A 252      45.439  67.350   7.858  1.00 25.73           C  
ATOM    338  C   HIS A 252      45.585  67.315   6.347  1.00 24.30           C  
ATOM    339  O   HIS A 252      46.597  66.879   5.821  1.00 22.87           O  
ATOM    340  CB  HIS A 252      44.548  66.172   8.291  1.00 28.96           C  
ATOM    341  CG  HIS A 252      44.600  65.883   9.757  1.00 34.87           C  
ATOM    342  ND1 HIS A 252      45.642  66.298  10.556  1.00 36.96           N  
ATOM    343  CD2 HIS A 252      43.748  65.211  10.566  1.00 37.03           C  
ATOM    344  CE1 HIS A 252      45.430  65.897  11.798  1.00 37.63           C  
ATOM    345  NE2 HIS A 252      44.287  65.235  11.831  1.00 40.39           N  
ATOM    346  N   VAL A 253      44.555  67.768   5.644  1.00 21.92           N  
ATOM    347  CA  VAL A 253      44.598  67.778   4.185  1.00 20.57           C  
ATOM    348  C   VAL A 253      45.771  68.605   3.677  1.00 23.11           C  
ATOM    349  O   VAL A 253      46.522  68.155   2.800  1.00 21.51           O  
ATOM    350  CB  VAL A 253      43.256  68.322   3.600  1.00 20.97           C  
ATOM    351  CG1 VAL A 253      43.383  68.580   2.078  1.00 17.45           C  
ATOM    352  CG2 VAL A 253      42.163  67.274   3.848  1.00 18.24           C  
ATOM    353  N   ASN A 254      45.948  69.799   4.242  1.00 22.28           N  
ATOM    354  CA  ASN A 254      47.042  70.671   3.802  1.00 24.23           C  
ATOM    355  C   ASN A 254      48.409  70.042   4.040  1.00 24.84           C  
ATOM    356  O   ASN A 254      49.276  70.079   3.165  1.00 24.35           O  
ATOM    357  CB  ASN A 254      46.987  72.033   4.511  1.00 25.90           C  
ATOM    358  CG  ASN A 254      45.825  72.886   4.045  1.00 29.03           C  
ATOM    359  OD1 ASN A 254      45.382  72.774   2.902  1.00 27.50           O  
ATOM    360  ND2 ASN A 254      45.335  73.759   4.925  1.00 29.83           N  
ATOM    361  N   GLN A 255      48.608  69.483   5.229  1.00 24.47           N  
ATOM    362  CA  GLN A 255      49.879  68.856   5.563  1.00 26.13           C  
ATOM    363  C   GLN A 255      50.190  67.661   4.655  1.00 26.54           C  
ATOM    364  O   GLN A 255      51.321  67.520   4.157  1.00 23.72           O  
ATOM    365  CB  GLN A 255      49.879  68.400   7.032  1.00 29.82           C  
ATOM    366  CG  GLN A 255      51.077  67.532   7.410  1.00 39.15           C  
ATOM    367  CD  GLN A 255      50.907  66.829   8.749  1.00 43.83           C  
ATOM    368  OE1 GLN A 255      51.099  67.426   9.810  1.00 48.57           O  
ATOM    369  NE2 GLN A 255      50.533  65.554   8.702  1.00 47.50           N  
ATOM    370  N   LEU A 256      49.203  66.785   4.455  1.00 24.61           N  
ATOM    371  CA  LEU A 256      49.405  65.616   3.600  1.00 23.68           C  
ATOM    372  C   LEU A 256      49.718  65.995   2.150  1.00 25.66           C  
ATOM    373  O   LEU A 256      50.575  65.382   1.500  1.00 25.22           O  
ATOM    374  CB  LEU A 256      48.161  64.718   3.638  1.00 24.72           C  
ATOM    375  CG  LEU A 256      48.199  63.416   2.834  1.00 27.58           C  
ATOM    376  CD1 LEU A 256      49.465  62.608   3.190  1.00 27.69           C  
ATOM    377  CD2 LEU A 256      46.932  62.604   3.155  1.00 26.74           C  
ATOM    378  N   THR A 257      49.021  66.994   1.628  1.00 27.05           N  
ATOM    379  CA  THR A 257      49.260  67.424   0.252  1.00 29.94           C  
ATOM    380  C   THR A 257      50.683  67.973   0.118  1.00 31.79           C  
ATOM    381  O   THR A 257      51.366  67.695  -0.864  1.00 33.02           O  
ATOM    382  CB  THR A 257      48.227  68.482  -0.175  1.00 30.56           C  
ATOM    383  OG1 THR A 257      46.916  67.941   0.015  1.00 29.99           O  
ATOM    384  CG2 THR A 257      48.394  68.845  -1.651  1.00 32.32           C  
ATOM    385  N   ASP A 258      51.135  68.739   1.108  1.00 33.82           N  
ATOM    386  CA  ASP A 258      52.494  69.273   1.071  1.00 35.89           C  
ATOM    387  C   ASP A 258      53.518  68.137   1.047  1.00 36.28           C  
ATOM    388  O   ASP A 258      54.493  68.193   0.298  1.00 35.56           O  
ATOM    389  CB  ASP A 258      52.796  70.145   2.297  1.00 40.32           C  
ATOM    390  CG  ASP A 258      52.264  71.559   2.170  1.00 45.14           C  
ATOM    391  OD1 ASP A 258      52.154  72.077   1.030  1.00 48.53           O  
ATOM    392  OD2 ASP A 258      51.980  72.169   3.226  1.00 47.92           O  
ATOM    393  N   GLU A 259      53.303  67.109   1.867  1.00 35.03           N  
ATOM    394  CA  GLU A 259      54.241  65.996   1.931  1.00 36.77           C  
ATOM    395  C   GLU A 259      54.251  65.181   0.636  1.00 36.96           C  
ATOM    396  O   GLU A 259      55.304  64.709   0.201  1.00 36.10           O  
ATOM    397  CB  GLU A 259      53.919  65.111   3.138  1.00 39.78           C  
ATOM    398  CG  GLU A 259      54.154  65.825   4.467  1.00 46.24           C  
ATOM    399  CD  GLU A 259      53.626  65.063   5.665  1.00 50.25           C  
ATOM    400  OE1 GLU A 259      54.032  65.393   6.803  1.00 53.94           O  
ATOM    401  OE2 GLU A 259      52.799  64.145   5.477  1.00 53.05           O  
ATOM    402  N   LEU A 260      53.082  65.024   0.023  1.00 35.03           N  
ATOM    403  CA  LEU A 260      52.986  64.301  -1.239  1.00 34.86           C  
ATOM    404  C   LEU A 260      53.648  65.146  -2.332  1.00 35.47           C  
ATOM    405  O   LEU A 260      54.356  64.615  -3.186  1.00 35.13           O  
ATOM    406  CB  LEU A 260      51.524  64.047  -1.606  1.00 32.36           C  
ATOM    407  CG  LEU A 260      50.741  63.070  -0.732  1.00 33.35           C  
ATOM    408  CD1 LEU A 260      49.287  63.027  -1.224  1.00 30.72           C  
ATOM    409  CD2 LEU A 260      51.384  61.674  -0.797  1.00 32.09           C  
ATOM    410  N   ASP A 261      53.409  66.457  -2.286  1.00 36.66           N  
ATOM    411  CA  ASP A 261      53.982  67.408  -3.249  1.00 39.28           C  
ATOM    412  C   ASP A 261      55.509  67.386  -3.211  1.00 41.14           C  
ATOM    413  O   ASP A 261      56.174  67.370  -4.247  1.00 40.06           O  
ATOM    414  CB  ASP A 261      53.544  68.842  -2.929  1.00 39.95           C  
ATOM    415  CG  ASP A 261      52.151  69.171  -3.429  1.00 39.53           C  
ATOM    416  OD1 ASP A 261      51.685  70.296  -3.142  1.00 39.44           O  
ATOM    417  OD2 ASP A 261      51.528  68.330  -4.109  1.00 41.76           O  
ATOM    418  N   ASP A 262      56.060  67.410  -2.004  1.00 42.86           N  
ATOM    419  CA  ASP A 262      57.506  67.413  -1.842  1.00 45.68           C  
ATOM    420  C   ASP A 262      58.167  66.149  -2.367  1.00 46.40           C  
ATOM    421  O   ASP A 262      59.365  66.147  -2.638  1.00 48.19           O  
ATOM    422  CB  ASP A 262      57.873  67.622  -0.374  1.00 47.08           C  
ATOM    423  CG  ASP A 262      57.576  69.030   0.102  1.00 49.35           C  
ATOM    424  OD1 ASP A 262      57.835  69.330   1.287  1.00 51.09           O  
ATOM    425  OD2 ASP A 262      57.083  69.843  -0.709  1.00 51.69           O  
ATOM    426  N   LEU A 263      57.395  65.078  -2.520  1.00 45.70           N  
ATOM    427  CA  LEU A 263      57.956  63.830  -3.022  1.00 44.94           C  
ATOM    428  C   LEU A 263      57.664  63.581  -4.494  1.00 44.07           C  
ATOM    429  O   LEU A 263      58.089  62.568  -5.049  1.00 44.85           O  
ATOM    430  CB  LEU A 263      57.467  62.650  -2.183  1.00 46.55           C  
ATOM    431  CG  LEU A 263      58.321  62.323  -0.955  1.00 48.70           C  
ATOM    432  CD1 LEU A 263      58.660  63.594  -0.196  1.00 49.54           C  
ATOM    433  CD2 LEU A 263      57.575  61.337  -0.063  1.00 48.73           C  
ATOM    434  N   GLY A 264      56.930  64.489  -5.127  1.00 42.74           N  
ATOM    435  CA  GLY A 264      56.645  64.323  -6.541  1.00 42.12           C  
ATOM    436  C   GLY A 264      55.376  63.594  -6.934  1.00 42.56           C  
ATOM    437  O   GLY A 264      55.249  63.156  -8.077  1.00 41.98           O  
ATOM    438  N   TYR A 265      54.433  63.448  -6.007  1.00 41.66           N  
ATOM    439  CA  TYR A 265      53.177  62.786  -6.334  1.00 41.02           C  
ATOM    440  C   TYR A 265      52.232  63.785  -6.990  1.00 41.01           C  
ATOM    441  O   TYR A 265      52.012  64.865  -6.455  1.00 42.10           O  
ATOM    442  CB  TYR A 265      52.491  62.242  -5.078  1.00 39.25           C  
ATOM    443  CG  TYR A 265      53.182  61.068  -4.439  1.00 37.83           C  
ATOM    444  CD1 TYR A 265      54.314  61.246  -3.650  1.00 39.12           C  
ATOM    445  CD2 TYR A 265      52.705  59.775  -4.622  1.00 38.46           C  
ATOM    446  CE1 TYR A 265      54.954  60.160  -3.058  1.00 39.32           C  
ATOM    447  CE2 TYR A 265      53.335  58.680  -4.032  1.00 37.84           C  
ATOM    448  CZ  TYR A 265      54.457  58.884  -3.256  1.00 38.15           C  
ATOM    449  OH  TYR A 265      55.094  57.814  -2.682  1.00 38.35           O  
ATOM    450  N   PRO A 266      51.682  63.454  -8.170  1.00 41.04           N  
ATOM    451  CA  PRO A 266      50.752  64.383  -8.831  1.00 40.57           C  
ATOM    452  C   PRO A 266      49.421  64.303  -8.079  1.00 37.86           C  
ATOM    453  O   PRO A 266      48.688  63.323  -8.185  1.00 36.36           O  
ATOM    454  CB  PRO A 266      50.640  63.821 -10.246  1.00 40.87           C  
ATOM    455  CG  PRO A 266      51.982  63.140 -10.445  1.00 43.54           C  
ATOM    456  CD  PRO A 266      52.147  62.426  -9.115  1.00 42.47           C  
ATOM    457  N   CYS A 267      49.114  65.339  -7.316  1.00 37.01           N  
ATOM    458  CA  CYS A 267      47.891  65.340  -6.531  1.00 33.69           C  
ATOM    459  C   CYS A 267      47.341  66.746  -6.413  1.00 32.67           C  
ATOM    460  O   CYS A 267      47.920  67.703  -6.919  1.00 30.93           O  
ATOM    461  CB  CYS A 267      48.196  64.823  -5.127  1.00 35.59           C  
ATOM    462  SG  CYS A 267      49.356  65.906  -4.255  1.00 36.89           S  
ATOM    463  N   ASP A 268      46.205  66.858  -5.739  1.00 30.88           N  
ATOM    464  CA  ASP A 268      45.589  68.151  -5.511  1.00 27.98           C  
ATOM    465  C   ASP A 268      44.685  67.941  -4.306  1.00 27.07           C  
ATOM    466  O   ASP A 268      44.531  66.807  -3.836  1.00 24.83           O  
ATOM    467  CB  ASP A 268      44.776  68.624  -6.718  1.00 29.64           C  
ATOM    468  CG  ASP A 268      44.792  70.142  -6.863  1.00 33.84           C  
ATOM    469  OD1 ASP A 268      44.988  70.843  -5.840  1.00 33.82           O  
ATOM    470  OD2 ASP A 268      44.606  70.640  -7.997  1.00 39.63           O  
ATOM    471  N   LYS A 269      44.093  69.017  -3.813  1.00 24.80           N  
ATOM    472  CA  LYS A 269      43.267  68.930  -2.625  1.00 24.12           C  
ATOM    473  C   LYS A 269      41.985  69.734  -2.692  1.00 24.43           C  
ATOM    474  O   LYS A 269      41.861  70.673  -3.475  1.00 23.45           O  
ATOM    475  CB  LYS A 269      44.073  69.411  -1.419  1.00 26.70           C  
ATOM    476  CG  LYS A 269      44.494  70.868  -1.546  1.00 30.16           C  
ATOM    477  CD  LYS A 269      45.134  71.405  -0.278  1.00 33.21           C  
ATOM    478  CE  LYS A 269      45.383  72.911  -0.425  1.00 35.64           C  
ATOM    479  NZ  LYS A 269      46.191  73.441   0.702  1.00 36.70           N  
ATOM    480  N   ILE A 270      41.050  69.358  -1.825  1.00 22.43           N  
ATOM    481  CA  ILE A 270      39.768  70.020  -1.707  1.00 23.70           C  
ATOM    482  C   ILE A 270      39.342  70.003  -0.236  1.00 23.25           C  
ATOM    483  O   ILE A 270      39.335  68.948   0.384  1.00 23.00           O  
ATOM    484  CB  ILE A 270      38.682  69.286  -2.533  1.00 25.03           C  
ATOM    485  CG1 ILE A 270      38.967  69.437  -4.030  1.00 27.92           C  
ATOM    486  CG2 ILE A 270      37.301  69.824  -2.178  1.00 27.18           C  
ATOM    487  CD1 ILE A 270      37.875  68.851  -4.923  1.00 29.53           C  
ATOM    488  N   HIS A 271      39.020  71.166   0.330  1.00 22.13           N  
ATOM    489  CA  HIS A 271      38.525  71.220   1.711  1.00 22.17           C  
ATOM    490  C   HIS A 271      37.703  72.482   1.916  1.00 23.77           C  
ATOM    491  O   HIS A 271      37.653  73.342   1.037  1.00 23.42           O  
ATOM    492  CB  HIS A 271      39.659  71.142   2.742  1.00 19.89           C  
ATOM    493  CG  HIS A 271      40.609  72.294   2.710  1.00 21.92           C  
ATOM    494  ND1 HIS A 271      41.956  72.141   2.458  1.00 24.35           N  
ATOM    495  CD2 HIS A 271      40.415  73.615   2.930  1.00 20.83           C  
ATOM    496  CE1 HIS A 271      42.550  73.321   2.518  1.00 19.84           C  
ATOM    497  NE2 HIS A 271      41.635  74.231   2.806  1.00 25.22           N  
ATOM    498  N   GLY A 272      37.072  72.592   3.083  1.00 25.75           N  
ATOM    499  CA  GLY A 272      36.214  73.731   3.376  1.00 25.87           C  
ATOM    500  C   GLY A 272      36.802  75.123   3.455  1.00 26.35           C  
ATOM    501  O   GLY A 272      36.052  76.099   3.531  1.00 27.46           O  
ATOM    502  N   GLY A 273      38.124  75.233   3.428  1.00 25.77           N  
ATOM    503  CA  GLY A 273      38.753  76.536   3.489  1.00 27.79           C  
ATOM    504  C   GLY A 273      38.982  77.122   2.109  1.00 27.39           C  
ATOM    505  O   GLY A 273      39.568  78.195   1.975  1.00 27.93           O  
ATOM    506  N   MET A 274      38.522  76.411   1.084  1.00 26.16           N  
ATOM    507  CA  MET A 274      38.675  76.842  -0.302  1.00 26.21           C  
ATOM    508  C   MET A 274      37.344  77.405  -0.803  1.00 27.37           C  
ATOM    509  O   MET A 274      36.283  76.902  -0.437  1.00 28.53           O  
ATOM    510  CB  MET A 274      39.086  75.648  -1.184  1.00 27.56           C  
ATOM    511  CG  MET A 274      40.489  75.114  -0.920  1.00 25.43           C  
ATOM    512  SD  MET A 274      40.774  73.461  -1.628  1.00 28.68           S  
ATOM    513  CE  MET A 274      40.459  73.778  -3.384  1.00 26.71           C  
ATOM    514  N   ILE A 275      37.384  78.444  -1.634  1.00 26.10           N  
ATOM    515  CA  ILE A 275      36.130  78.989  -2.147  1.00 27.58           C  
ATOM    516  C   ILE A 275      35.514  77.958  -3.105  1.00 28.31           C  
ATOM    517  O   ILE A 275      36.214  77.089  -3.638  1.00 24.39           O  
ATOM    518  CB  ILE A 275      36.336  80.343  -2.885  1.00 26.61           C  
ATOM    519  CG1 ILE A 275      37.240  80.148  -4.105  1.00 28.09           C  
ATOM    520  CG2 ILE A 275      36.963  81.376  -1.933  1.00 28.17           C  
ATOM    521  CD1 ILE A 275      37.502  81.451  -4.863  1.00 29.62           C  
ATOM    522  N   GLN A 276      34.199  78.063  -3.296  1.00 29.64           N  
ATOM    523  CA  GLN A 276      33.423  77.168  -4.149  1.00 31.14           C  
ATOM    524  C   GLN A 276      33.992  76.948  -5.558  1.00 31.79           C  
ATOM    525  O   GLN A 276      34.076  75.805  -6.010  1.00 29.42           O  
ATOM    526  CB  GLN A 276      31.972  77.682  -4.279  1.00 34.15           C  
ATOM    527  CG  GLN A 276      31.189  77.755  -2.968  1.00 39.31           C  
ATOM    528  CD  GLN A 276      29.841  78.492  -3.092  1.00 43.25           C  
ATOM    529  OE1 GLN A 276      29.058  78.544  -2.135  1.00 45.19           O  
ATOM    530  NE2 GLN A 276      29.578  79.065  -4.259  1.00 43.87           N  
ATOM    531  N   GLU A 277      34.371  78.024  -6.255  1.00 31.20           N  
ATOM    532  CA  GLU A 277      34.890  77.862  -7.613  1.00 31.51           C  
ATOM    533  C   GLU A 277      36.197  77.081  -7.656  1.00 30.85           C  
ATOM    534  O   GLU A 277      36.497  76.452  -8.662  1.00 29.70           O  
ATOM    535  CB  GLU A 277      35.070  79.216  -8.331  1.00 34.29           C  
ATOM    536  CG  GLU A 277      36.300  80.032  -7.941  1.00 36.74           C  
ATOM    537  CD  GLU A 277      36.507  81.265  -8.844  1.00 39.55           C  
ATOM    538  OE1 GLU A 277      37.340  81.211  -9.789  1.00 33.27           O  
ATOM    539  OE2 GLU A 277      35.821  82.285  -8.608  1.00 38.80           O  
ATOM    540  N   ASP A 278      36.983  77.127  -6.584  1.00 28.78           N  
ATOM    541  CA  ASP A 278      38.237  76.371  -6.581  1.00 28.47           C  
ATOM    542  C   ASP A 278      37.941  74.902  -6.362  1.00 26.50           C  
ATOM    543  O   ASP A 278      38.529  74.046  -7.014  1.00 26.14           O  
ATOM    544  CB  ASP A 278      39.189  76.866  -5.491  1.00 29.27           C  
ATOM    545  CG  ASP A 278      39.908  78.153  -5.877  1.00 31.75           C  
ATOM    546  OD1 ASP A 278      39.941  78.493  -7.079  1.00 32.47           O  
ATOM    547  OD2 ASP A 278      40.456  78.817  -4.976  1.00 34.08           O  
ATOM    548  N   ARG A 279      37.035  74.604  -5.438  1.00 25.70           N  
ATOM    549  CA  ARG A 279      36.685  73.213  -5.184  1.00 25.99           C  
ATOM    550  C   ARG A 279      36.132  72.597  -6.453  1.00 26.75           C  
ATOM    551  O   ARG A 279      36.453  71.460  -6.780  1.00 26.58           O  
ATOM    552  CB  ARG A 279      35.645  73.093  -4.059  1.00 26.10           C  
ATOM    553  CG  ARG A 279      36.113  73.655  -2.714  1.00 27.00           C  
ATOM    554  CD  ARG A 279      35.306  73.045  -1.553  1.00 26.70           C  
ATOM    555  NE  ARG A 279      33.897  73.437  -1.558  1.00 28.62           N  
ATOM    556  CZ  ARG A 279      33.390  74.460  -0.878  1.00 31.17           C  
ATOM    557  NH1 ARG A 279      34.173  75.220  -0.124  1.00 31.70           N  
ATOM    558  NH2 ARG A 279      32.085  74.721  -0.945  1.00 32.67           N  
ATOM    559  N   PHE A 280      35.310  73.358  -7.172  1.00 26.10           N  
ATOM    560  CA  PHE A 280      34.700  72.888  -8.415  1.00 29.22           C  
ATOM    561  C   PHE A 280      35.759  72.620  -9.491  1.00 27.01           C  
ATOM    562  O   PHE A 280      35.778  71.565 -10.114  1.00 25.32           O  
ATOM    563  CB  PHE A 280      33.698  73.942  -8.914  1.00 31.33           C  
ATOM    564  CG  PHE A 280      33.013  73.584 -10.215  1.00 35.83           C  
ATOM    565  CD1 PHE A 280      32.069  72.561 -10.267  1.00 38.81           C  
ATOM    566  CD2 PHE A 280      33.279  74.309 -11.379  1.00 37.05           C  
ATOM    567  CE1 PHE A 280      31.393  72.265 -11.463  1.00 38.60           C  
ATOM    568  CE2 PHE A 280      32.610  74.026 -12.580  1.00 38.31           C  
ATOM    569  CZ  PHE A 280      31.666  73.006 -12.623  1.00 38.04           C  
ATOM    570  N   ASP A 281      36.633  73.592  -9.712  1.00 27.20           N  
ATOM    571  CA  ASP A 281      37.668  73.446 -10.722  1.00 28.28           C  
ATOM    572  C   ASP A 281      38.622  72.301 -10.365  1.00 27.47           C  
ATOM    573  O   ASP A 281      39.077  71.581 -11.246  1.00 26.49           O  
ATOM    574  CB  ASP A 281      38.461  74.754 -10.884  1.00 30.17           C  
ATOM    575  CG  ASP A 281      37.650  75.858 -11.561  1.00 33.21           C  
ATOM    576  OD1 ASP A 281      36.644  75.538 -12.241  1.00 33.16           O  
ATOM    577  OD2 ASP A 281      38.037  77.042 -11.429  1.00 33.37           O  
ATOM    578  N   VAL A 282      38.918  72.118  -9.083  1.00 26.70           N  
ATOM    579  CA  VAL A 282      39.827  71.033  -8.715  1.00 25.58           C  
ATOM    580  C   VAL A 282      39.174  69.678  -9.003  1.00 25.02           C  
ATOM    581  O   VAL A 282      39.839  68.745  -9.462  1.00 24.64           O  
ATOM    582  CB  VAL A 282      40.260  71.135  -7.223  1.00 25.37           C  
ATOM    583  CG1 VAL A 282      41.038  69.889  -6.805  1.00 25.50           C  
ATOM    584  CG2 VAL A 282      41.145  72.370  -7.043  1.00 25.57           C  
ATOM    585  N   MET A 283      37.873  69.584  -8.770  1.00 24.76           N  
ATOM    586  CA  MET A 283      37.158  68.332  -9.014  1.00 28.72           C  
ATOM    587  C   MET A 283      37.064  68.042 -10.518  1.00 29.49           C  
ATOM    588  O   MET A 283      37.050  66.877 -10.944  1.00 27.96           O  
ATOM    589  CB  MET A 283      35.753  68.390  -8.398  1.00 30.21           C  
ATOM    590  CG  MET A 283      34.966  67.076  -8.513  1.00 33.48           C  
ATOM    591  SD  MET A 283      35.839  65.662  -7.759  1.00 37.27           S  
ATOM    592  CE  MET A 283      35.564  66.024  -6.025  1.00 34.93           C  
ATOM    593  N   ASN A 284      37.024  69.092 -11.333  1.00 29.98           N  
ATOM    594  CA  ASN A 284      36.957  68.878 -12.769  1.00 32.70           C  
ATOM    595  C   ASN A 284      38.276  68.336 -13.299  1.00 32.76           C  
ATOM    596  O   ASN A 284      38.281  67.462 -14.170  1.00 34.33           O  
ATOM    597  CB  ASN A 284      36.533  70.157 -13.496  1.00 33.05           C  
ATOM    598  CG  ASN A 284      35.066  70.472 -13.276  1.00 36.80           C  
ATOM    599  OD1 ASN A 284      34.231  69.564 -13.256  1.00 40.24           O  
ATOM    600  ND2 ASN A 284      34.739  71.747 -13.119  1.00 37.16           N  
ATOM    601  N   GLU A 285      39.393  68.817 -12.755  1.00 32.12           N  
ATOM    602  CA  GLU A 285      40.706  68.327 -13.176  1.00 33.78           C  
ATOM    603  C   GLU A 285      40.814  66.835 -12.827  1.00 32.90           C  
ATOM    604  O   GLU A 285      41.446  66.062 -13.545  1.00 33.43           O  
ATOM    605  CB  GLU A 285      41.834  69.082 -12.459  1.00 35.51           C  
ATOM    606  CG  GLU A 285      41.700  70.599 -12.485  1.00 38.30           C  
ATOM    607  CD  GLU A 285      42.901  71.304 -11.868  1.00 42.14           C  
ATOM    608  OE1 GLU A 285      43.388  70.867 -10.800  1.00 42.24           O  
ATOM    609  OE2 GLU A 285      43.356  72.311 -12.450  1.00 45.41           O  
ATOM    610  N   PHE A 286      40.216  66.454 -11.701  1.00 31.11           N  
ATOM    611  CA  PHE A 286      40.228  65.069 -11.242  1.00 31.03           C  
ATOM    612  C   PHE A 286      39.386  64.254 -12.225  1.00 31.11           C  
ATOM    613  O   PHE A 286      39.807  63.188 -12.681  1.00 31.56           O  
ATOM    614  CB  PHE A 286      39.651  64.984  -9.815  1.00 29.23           C  
ATOM    615  CG  PHE A 286      39.789  63.622  -9.165  1.00 29.73           C  
ATOM    616  CD1 PHE A 286      40.991  62.919  -9.229  1.00 30.72           C  
ATOM    617  CD2 PHE A 286      38.736  63.080  -8.432  1.00 30.04           C  
ATOM    618  CE1 PHE A 286      41.145  61.690  -8.565  1.00 30.72           C  
ATOM    619  CE2 PHE A 286      38.881  61.856  -7.765  1.00 30.80           C  
ATOM    620  CZ  PHE A 286      40.090  61.164  -7.833  1.00 27.87           C  
ATOM    621  N   LYS A 287      38.211  64.773 -12.561  1.00 32.03           N  
ATOM    622  CA  LYS A 287      37.310  64.115 -13.512  1.00 34.31           C  
ATOM    623  C   LYS A 287      37.972  63.946 -14.882  1.00 35.00           C  
ATOM    624  O   LYS A 287      37.689  62.984 -15.606  1.00 34.76           O  
ATOM    625  CB  LYS A 287      36.023  64.930 -13.685  1.00 36.14           C  
ATOM    626  CG  LYS A 287      35.131  64.929 -12.460  1.00 39.06           C  
ATOM    627  CD  LYS A 287      33.826  65.678 -12.681  1.00 40.68           C  
ATOM    628  CE  LYS A 287      32.923  65.542 -11.454  1.00 42.69           C  
ATOM    629  NZ  LYS A 287      31.627  66.275 -11.570  1.00 44.01           N  
ATOM    630  N   ARG A 288      38.853  64.877 -15.234  1.00 34.80           N  
ATOM    631  CA  ARG A 288      39.548  64.811 -16.522  1.00 35.81           C  
ATOM    632  C   ARG A 288      40.775  63.906 -16.444  1.00 35.76           C  
ATOM    633  O   ARG A 288      41.426  63.628 -17.454  1.00 35.54           O  
ATOM    634  CB  ARG A 288      39.971  66.213 -16.985  1.00 35.97           C  
ATOM    635  CG  ARG A 288      38.814  67.154 -17.275  1.00 36.22           C  
ATOM    636  CD  ARG A 288      39.293  68.382 -18.058  1.00 38.22           C  
ATOM    637  NE  ARG A 288      40.226  69.215 -17.303  1.00 37.73           N  
ATOM    638  CZ  ARG A 288      39.864  70.261 -16.563  1.00 37.33           C  
ATOM    639  NH1 ARG A 288      38.586  70.606 -16.476  1.00 35.85           N  
ATOM    640  NH2 ARG A 288      40.786  70.969 -15.916  1.00 38.28           N  
ATOM    641  N   GLY A 289      41.092  63.447 -15.240  1.00 34.95           N  
ATOM    642  CA  GLY A 289      42.237  62.567 -15.076  1.00 33.36           C  
ATOM    643  C   GLY A 289      43.580  63.270 -15.118  1.00 33.20           C  
ATOM    644  O   GLY A 289      44.587  62.649 -15.426  1.00 33.36           O  
ATOM    645  N   GLU A 290      43.615  64.558 -14.790  1.00 31.83           N  
ATOM    646  CA  GLU A 290      44.872  65.295 -14.818  1.00 32.75           C  
ATOM    647  C   GLU A 290      45.806  64.908 -13.672  1.00 33.19           C  
ATOM    648  O   GLU A 290      47.004  65.205 -13.695  1.00 33.92           O  
ATOM    649  CB  GLU A 290      44.586  66.798 -14.828  1.00 33.98           C  
ATOM    650  CG  GLU A 290      43.874  67.233 -16.117  1.00 36.65           C  
ATOM    651  CD  GLU A 290      43.577  68.718 -16.172  1.00 37.35           C  
ATOM    652  OE1 GLU A 290      43.114  69.189 -17.231  1.00 37.91           O  
ATOM    653  OE2 GLU A 290      43.800  69.413 -15.160  1.00 35.30           O  
ATOM    654  N   TYR A 291      45.255  64.243 -12.664  1.00 31.04           N  
ATOM    655  CA  TYR A 291      46.061  63.765 -11.547  1.00 31.94           C  
ATOM    656  C   TYR A 291      45.384  62.517 -10.995  1.00 31.06           C  
ATOM    657  O   TYR A 291      44.213  62.276 -11.259  1.00 30.72           O  
ATOM    658  CB  TYR A 291      46.265  64.862 -10.475  1.00 32.67           C  
ATOM    659  CG  TYR A 291      45.016  65.439  -9.841  1.00 37.82           C  
ATOM    660  CD1 TYR A 291      44.347  64.757  -8.833  1.00 36.93           C  
ATOM    661  CD2 TYR A 291      44.519  66.688 -10.235  1.00 37.44           C  
ATOM    662  CE1 TYR A 291      43.211  65.299  -8.223  1.00 39.62           C  
ATOM    663  CE2 TYR A 291      43.383  67.240  -9.631  1.00 37.51           C  
ATOM    664  CZ  TYR A 291      42.735  66.537  -8.626  1.00 38.28           C  
ATOM    665  OH  TYR A 291      41.611  67.055  -8.019  1.00 40.44           O  
ATOM    666  N   ARG A 292      46.124  61.713 -10.246  1.00 31.18           N  
ATOM    667  CA  ARG A 292      45.576  60.461  -9.740  1.00 31.98           C  
ATOM    668  C   ARG A 292      45.097  60.465  -8.295  1.00 28.92           C  
ATOM    669  O   ARG A 292      44.251  59.658  -7.922  1.00 27.78           O  
ATOM    670  CB  ARG A 292      46.620  59.364  -9.896  1.00 34.60           C  
ATOM    671  CG  ARG A 292      47.188  59.252 -11.295  1.00 39.28           C  
ATOM    672  CD  ARG A 292      48.446  58.409 -11.267  1.00 43.38           C  
ATOM    673  NE  ARG A 292      48.222  57.151 -10.563  1.00 46.26           N  
ATOM    674  CZ  ARG A 292      49.181  56.283 -10.259  1.00 47.27           C  
ATOM    675  NH1 ARG A 292      50.437  56.539 -10.602  1.00 49.54           N  
ATOM    676  NH2 ARG A 292      48.884  55.163  -9.609  1.00 47.92           N  
ATOM    677  N   TYR A 293      45.643  61.363  -7.492  1.00 26.85           N  
ATOM    678  CA  TYR A 293      45.286  61.407  -6.084  1.00 28.46           C  
ATOM    679  C   TYR A 293      44.678  62.715  -5.615  1.00 26.90           C  
ATOM    680  O   TYR A 293      45.292  63.777  -5.723  1.00 27.79           O  
ATOM    681  CB  TYR A 293      46.516  61.111  -5.221  1.00 31.85           C  
ATOM    682  CG  TYR A 293      47.391  59.997  -5.756  1.00 36.69           C  
ATOM    683  CD1 TYR A 293      48.563  60.282  -6.448  1.00 39.56           C  
ATOM    684  CD2 TYR A 293      47.031  58.655  -5.590  1.00 39.46           C  
ATOM    685  CE1 TYR A 293      49.364  59.258  -6.968  1.00 41.61           C  
ATOM    686  CE2 TYR A 293      47.825  57.623  -6.104  1.00 41.02           C  
ATOM    687  CZ  TYR A 293      48.985  57.934  -6.789  1.00 43.25           C  
ATOM    688  OH  TYR A 293      49.771  56.920  -7.297  1.00 46.92           O  
ATOM    689  N   LEU A 294      43.470  62.624  -5.075  1.00 23.60           N  
ATOM    690  CA  LEU A 294      42.788  63.785  -4.532  1.00 22.01           C  
ATOM    691  C   LEU A 294      42.802  63.653  -2.994  1.00 21.76           C  
ATOM    692  O   LEU A 294      42.360  62.634  -2.479  1.00 19.18           O  
ATOM    693  CB  LEU A 294      41.332  63.813  -5.020  1.00 22.82           C  
ATOM    694  CG  LEU A 294      40.432  64.836  -4.323  1.00 23.45           C  
ATOM    695  CD1 LEU A 294      41.034  66.240  -4.493  1.00 25.07           C  
ATOM    696  CD2 LEU A 294      39.003  64.772  -4.924  1.00 25.05           C  
ATOM    697  N   VAL A 295      43.327  64.654  -2.286  1.00 21.42           N  
ATOM    698  CA  VAL A 295      43.343  64.634  -0.816  1.00 20.78           C  
ATOM    699  C   VAL A 295      42.191  65.548  -0.427  1.00 21.48           C  
ATOM    700  O   VAL A 295      42.130  66.692  -0.887  1.00 21.21           O  
ATOM    701  CB  VAL A 295      44.640  65.220  -0.228  1.00 21.44           C  
ATOM    702  CG1 VAL A 295      44.580  65.120   1.313  1.00 19.74           C  
ATOM    703  CG2 VAL A 295      45.858  64.463  -0.756  1.00 21.54           C  
ATOM    704  N   ALA A 296      41.301  65.076   0.442  1.00 20.75           N  
ATOM    705  CA  ALA A 296      40.130  65.868   0.755  1.00 21.74           C  
ATOM    706  C   ALA A 296      39.444  65.592   2.077  1.00 20.86           C  
ATOM    707  O   ALA A 296      39.679  64.564   2.706  1.00 23.55           O  
ATOM    708  CB  ALA A 296      39.122  65.659  -0.343  1.00 22.29           C  
ATOM    709  N   THR A 297      38.593  66.526   2.483  1.00 22.36           N  
ATOM    710  CA  THR A 297      37.790  66.330   3.672  1.00 22.62           C  
ATOM    711  C   THR A 297      36.451  65.881   3.089  1.00 26.27           C  
ATOM    712  O   THR A 297      36.286  65.834   1.867  1.00 23.86           O  
ATOM    713  CB  THR A 297      37.567  67.621   4.494  1.00 22.97           C  
ATOM    714  OG1 THR A 297      37.002  68.637   3.656  1.00 21.94           O  
ATOM    715  CG2 THR A 297      38.872  68.094   5.116  1.00 20.96           C  
ATOM    716  N   ASP A 298      35.495  65.597   3.965  1.00 26.77           N  
ATOM    717  CA  ASP A 298      34.177  65.117   3.552  1.00 29.13           C  
ATOM    718  C   ASP A 298      33.411  66.045   2.618  1.00 29.38           C  
ATOM    719  O   ASP A 298      32.494  65.607   1.928  1.00 28.81           O  
ATOM    720  CB  ASP A 298      33.344  64.802   4.804  1.00 30.91           C  
ATOM    721  CG  ASP A 298      33.799  63.514   5.495  1.00 34.64           C  
ATOM    722  OD1 ASP A 298      33.451  62.416   5.005  1.00 36.67           O  
ATOM    723  OD2 ASP A 298      34.521  63.586   6.518  1.00 38.67           O  
ATOM    724  N   VAL A 299      33.783  67.317   2.581  1.00 28.78           N  
ATOM    725  CA  VAL A 299      33.084  68.245   1.710  1.00 31.91           C  
ATOM    726  C   VAL A 299      33.187  67.789   0.245  1.00 32.32           C  
ATOM    727  O   VAL A 299      32.292  68.064  -0.559  1.00 30.76           O  
ATOM    728  CB  VAL A 299      33.625  69.699   1.870  1.00 32.90           C  
ATOM    729  CG1 VAL A 299      35.048  69.806   1.332  1.00 31.91           C  
ATOM    730  CG2 VAL A 299      32.697  70.671   1.145  1.00 34.09           C  
ATOM    731  N   ALA A 300      34.252  67.061  -0.091  1.00 31.64           N  
ATOM    732  CA  ALA A 300      34.432  66.584  -1.458  1.00 34.74           C  
ATOM    733  C   ALA A 300      33.467  65.453  -1.800  1.00 36.52           C  
ATOM    734  O   ALA A 300      33.198  65.198  -2.978  1.00 37.01           O  
ATOM    735  CB  ALA A 300      35.878  66.115  -1.679  1.00 33.40           C  
ATOM    736  N   ALA A 301      32.962  64.773  -0.771  1.00 37.61           N  
ATOM    737  CA  ALA A 301      32.028  63.671  -0.959  1.00 40.42           C  
ATOM    738  C   ALA A 301      30.587  64.148  -1.140  1.00 42.05           C  
ATOM    739  O   ALA A 301      29.755  63.411  -1.665  1.00 43.28           O  
ATOM    740  CB  ALA A 301      32.103  62.712   0.229  1.00 38.91           C  
ATOM    741  N   ARG A 302      30.282  65.365  -0.705  1.00 44.19           N  
ATOM    742  CA  ARG A 302      28.918  65.868  -0.839  1.00 47.30           C  
ATOM    743  C   ARG A 302      28.616  66.335  -2.251  1.00 49.05           C  
ATOM    744  O   ARG A 302      29.267  67.245  -2.774  1.00 49.51           O  
ATOM    745  CB  ARG A 302      28.642  67.003   0.151  1.00 47.32           C  
ATOM    746  CG  ARG A 302      28.206  66.526   1.526  1.00 47.32           C  
ATOM    747  CD  ARG A 302      27.583  67.655   2.346  1.00 47.63           C  
ATOM    748  NE  ARG A 302      28.516  68.751   2.600  1.00 48.09           N  
ATOM    749  CZ  ARG A 302      29.532  68.695   3.455  1.00 46.87           C  
ATOM    750  NH1 ARG A 302      29.760  67.589   4.154  1.00 46.84           N  
ATOM    751  NH2 ARG A 302      30.319  69.750   3.616  1.00 45.84           N  
ATOM    752  N   GLY A 303      27.617  65.703  -2.861  1.00 50.52           N  
ATOM    753  CA  GLY A 303      27.237  66.044  -4.217  1.00 52.56           C  
ATOM    754  C   GLY A 303      28.201  65.419  -5.206  1.00 54.41           C  
ATOM    755  O   GLY A 303      28.072  65.603  -6.421  1.00 54.58           O  
ATOM    756  N   ILE A 304      29.179  64.682  -4.681  1.00 55.50           N  
ATOM    757  CA  ILE A 304      30.173  64.019  -5.516  1.00 56.20           C  
ATOM    758  C   ILE A 304      29.459  63.272  -6.645  1.00 56.77           C  
ATOM    759  O   ILE A 304      28.502  62.529  -6.403  1.00 57.11           O  
ATOM    760  CB  ILE A 304      31.034  63.032  -4.680  1.00 56.03           C  
ATOM    761  CG1 ILE A 304      32.158  62.461  -5.542  1.00 57.03           C  
ATOM    762  CG2 ILE A 304      30.170  61.902  -4.137  1.00 56.00           C  
ATOM    763  CD1 ILE A 304      33.048  63.517  -6.160  1.00 57.39           C  
ATOM    764  N   ASP A 305      29.916  63.473  -7.880  1.00 56.72           N  
ATOM    765  CA  ASP A 305      29.276  62.834  -9.026  1.00 56.98           C  
ATOM    766  C   ASP A 305      30.268  62.284 -10.049  1.00 54.98           C  
ATOM    767  O   ASP A 305      29.884  61.925 -11.161  1.00 54.46           O  
ATOM    768  CB  ASP A 305      28.325  63.836  -9.698  1.00 59.71           C  
ATOM    769  CG  ASP A 305      27.305  63.166 -10.604  1.00 62.93           C  
ATOM    770  OD1 ASP A 305      26.623  62.227 -10.138  1.00 64.85           O  
ATOM    771  OD2 ASP A 305      27.174  63.586 -11.778  1.00 64.36           O  
ATOM    772  N   ILE A 306      31.542  62.221  -9.680  1.00 52.94           N  
ATOM    773  CA  ILE A 306      32.552  61.695 -10.588  1.00 50.69           C  
ATOM    774  C   ILE A 306      32.220  60.238 -10.914  1.00 50.11           C  
ATOM    775  O   ILE A 306      32.041  59.408 -10.022  1.00 49.49           O  
ATOM    776  CB  ILE A 306      33.969  61.781  -9.977  1.00 49.95           C  
ATOM    777  CG1 ILE A 306      34.995  61.231 -10.972  1.00 50.08           C  
ATOM    778  CG2 ILE A 306      34.020  61.018  -8.671  1.00 48.19           C  
ATOM    779  CD1 ILE A 306      36.436  61.457 -10.567  1.00 50.02           C  
ATOM    780  N   GLU A 307      32.143  59.943 -12.207  1.00 48.78           N  
ATOM    781  CA  GLU A 307      31.808  58.616 -12.697  1.00 47.48           C  
ATOM    782  C   GLU A 307      32.352  57.461 -11.854  1.00 45.35           C  
ATOM    783  O   GLU A 307      31.593  56.578 -11.448  1.00 44.90           O  
ATOM    784  CB  GLU A 307      32.275  58.475 -14.152  1.00 51.62           C  
ATOM    785  CG  GLU A 307      31.660  57.296 -14.894  1.00 57.06           C  
ATOM    786  CD  GLU A 307      32.070  55.961 -14.308  1.00 59.44           C  
ATOM    787  OE1 GLU A 307      33.269  55.622 -14.407  1.00 61.28           O  
ATOM    788  OE2 GLU A 307      31.199  55.256 -13.745  1.00 61.73           O  
ATOM    789  N   ASN A 308      33.655  57.458 -11.586  1.00 41.14           N  
ATOM    790  CA  ASN A 308      34.242  56.377 -10.802  1.00 38.67           C  
ATOM    791  C   ASN A 308      35.534  56.744 -10.082  1.00 35.73           C  
ATOM    792  O   ASN A 308      36.336  57.527 -10.589  1.00 36.23           O  
ATOM    793  CB  ASN A 308      34.495  55.156 -11.716  1.00 37.28           C  
ATOM    794  CG  ASN A 308      35.396  54.097 -11.072  1.00 36.89           C  
ATOM    795  OD1 ASN A 308      36.616  54.126 -11.228  1.00 39.36           O  
ATOM    796  ND2 ASN A 308      34.795  53.169 -10.342  1.00 32.90           N  
ATOM    797  N   ILE A 309      35.706  56.193  -8.886  1.00 31.18           N  
ATOM    798  CA  ILE A 309      36.936  56.377  -8.123  1.00 29.41           C  
ATOM    799  C   ILE A 309      37.287  54.951  -7.708  1.00 28.07           C  
ATOM    800  O   ILE A 309      36.529  54.299  -7.006  1.00 29.34           O  
ATOM    801  CB  ILE A 309      36.748  57.267  -6.884  1.00 29.43           C  
ATOM    802  CG1 ILE A 309      36.338  58.673  -7.323  1.00 26.67           C  
ATOM    803  CG2 ILE A 309      38.045  57.294  -6.085  1.00 27.68           C  
ATOM    804  CD1 ILE A 309      36.210  59.705  -6.178  1.00 31.54           C  
ATOM    805  N   SER A 310      38.435  54.469  -8.156  1.00 27.82           N  
ATOM    806  CA  SER A 310      38.832  53.093  -7.890  1.00 28.94           C  
ATOM    807  C   SER A 310      39.215  52.737  -6.470  1.00 27.31           C  
ATOM    808  O   SER A 310      38.900  51.642  -6.007  1.00 28.11           O  
ATOM    809  CB  SER A 310      39.974  52.702  -8.833  1.00 30.70           C  
ATOM    810  OG  SER A 310      39.511  52.729 -10.168  1.00 36.34           O  
ATOM    811  N   LEU A 311      39.882  53.661  -5.790  1.00 26.18           N  
ATOM    812  CA  LEU A 311      40.342  53.442  -4.424  1.00 23.73           C  
ATOM    813  C   LEU A 311      39.992  54.596  -3.498  1.00 23.51           C  
ATOM    814  O   LEU A 311      40.211  55.762  -3.836  1.00 23.32           O  
ATOM    815  CB  LEU A 311      41.867  53.270  -4.405  1.00 24.75           C  
ATOM    816  CG  LEU A 311      42.562  52.994  -3.060  1.00 26.39           C  
ATOM    817  CD1 LEU A 311      42.055  51.668  -2.507  1.00 25.47           C  
ATOM    818  CD2 LEU A 311      44.085  52.932  -3.262  1.00 27.56           C  
ATOM    819  N   VAL A 312      39.419  54.263  -2.348  1.00 22.68           N  
ATOM    820  CA  VAL A 312      39.129  55.268  -1.326  1.00 21.64           C  
ATOM    821  C   VAL A 312      40.009  54.872  -0.143  1.00 21.23           C  
ATOM    822  O   VAL A 312      40.030  53.705   0.273  1.00 19.38           O  
ATOM    823  CB  VAL A 312      37.668  55.236  -0.838  1.00 24.72           C  
ATOM    824  CG1 VAL A 312      37.503  56.214   0.338  1.00 22.74           C  
ATOM    825  CG2 VAL A 312      36.722  55.617  -1.979  1.00 22.33           C  
ATOM    826  N   ILE A 313      40.769  55.834   0.360  1.00 21.09           N  
ATOM    827  CA  ILE A 313      41.611  55.601   1.512  1.00 19.71           C  
ATOM    828  C   ILE A 313      41.153  56.517   2.631  1.00 20.95           C  
ATOM    829  O   ILE A 313      41.162  57.737   2.488  1.00 20.22           O  
ATOM    830  CB  ILE A 313      43.103  55.907   1.225  1.00 20.51           C  
ATOM    831  CG1 ILE A 313      43.658  54.928   0.180  1.00 20.57           C  
ATOM    832  CG2 ILE A 313      43.900  55.805   2.550  1.00 21.46           C  
ATOM    833  CD1 ILE A 313      45.137  55.156  -0.142  1.00 21.61           C  
ATOM    834  N   ASN A 314      40.705  55.937   3.735  1.00 21.24           N  
ATOM    835  CA  ASN A 314      40.327  56.778   4.861  1.00 21.45           C  
ATOM    836  C   ASN A 314      41.588  56.955   5.710  1.00 22.95           C  
ATOM    837  O   ASN A 314      41.840  56.173   6.629  1.00 21.24           O  
ATOM    838  CB  ASN A 314      39.223  56.114   5.655  1.00 20.17           C  
ATOM    839  CG  ASN A 314      37.919  56.106   4.907  1.00 23.88           C  
ATOM    840  OD1 ASN A 314      37.472  57.146   4.435  1.00 23.81           O  
ATOM    841  ND2 ASN A 314      37.308  54.930   4.775  1.00 22.66           N  
ATOM    842  N   TYR A 315      42.378  57.969   5.365  1.00 23.57           N  
ATOM    843  CA  TYR A 315      43.634  58.286   6.044  1.00 28.15           C  
ATOM    844  C   TYR A 315      43.309  58.500   7.529  1.00 31.09           C  
ATOM    845  O   TYR A 315      44.064  58.100   8.411  1.00 38.68           O  
ATOM    846  CB  TYR A 315      44.255  59.532   5.394  1.00 26.00           C  
ATOM    847  CG  TYR A 315      45.686  59.816   5.779  1.00 26.98           C  
ATOM    848  CD1 TYR A 315      46.748  59.212   5.091  1.00 27.34           C  
ATOM    849  CD2 TYR A 315      45.984  60.697   6.819  1.00 28.06           C  
ATOM    850  CE1 TYR A 315      48.071  59.480   5.425  1.00 26.03           C  
ATOM    851  CE2 TYR A 315      47.307  60.976   7.170  1.00 28.46           C  
ATOM    852  CZ  TYR A 315      48.346  60.364   6.469  1.00 30.24           C  
ATOM    853  OH  TYR A 315      49.648  60.629   6.817  1.00 32.02           O  
ATOM    854  N   ASP A 316      42.177  59.146   7.779  1.00 30.76           N  
ATOM    855  CA  ASP A 316      41.650  59.341   9.131  1.00 28.45           C  
ATOM    856  C   ASP A 316      40.310  58.585   9.067  1.00 26.10           C  
ATOM    857  O   ASP A 316      39.508  58.851   8.187  1.00 22.54           O  
ATOM    858  CB  ASP A 316      41.348  60.820   9.429  1.00 27.18           C  
ATOM    859  CG  ASP A 316      42.605  61.659   9.612  1.00 29.50           C  
ATOM    860  OD1 ASP A 316      42.548  62.871   9.307  1.00 28.93           O  
ATOM    861  OD2 ASP A 316      43.635  61.120  10.070  1.00 27.48           O  
ATOM    862  N   LEU A 317      40.072  57.641   9.972  1.00 24.85           N  
ATOM    863  CA  LEU A 317      38.803  56.914   9.978  1.00 24.54           C  
ATOM    864  C   LEU A 317      37.658  57.898  10.246  1.00 27.19           C  
ATOM    865  O   LEU A 317      37.821  58.842  11.012  1.00 25.22           O  
ATOM    866  CB  LEU A 317      38.805  55.859  11.084  1.00 28.10           C  
ATOM    867  CG  LEU A 317      37.551  54.990  11.181  1.00 27.50           C  
ATOM    868  CD1 LEU A 317      37.595  53.898  10.118  1.00 25.11           C  
ATOM    869  CD2 LEU A 317      37.474  54.369  12.577  1.00 29.12           C  
ATOM    870  N   PRO A 318      36.499  57.713   9.588  1.00 27.88           N  
ATOM    871  CA  PRO A 318      35.391  58.645   9.849  1.00 30.67           C  
ATOM    872  C   PRO A 318      34.854  58.424  11.267  1.00 30.96           C  
ATOM    873  O   PRO A 318      34.687  57.288  11.718  1.00 30.52           O  
ATOM    874  CB  PRO A 318      34.376  58.319   8.755  1.00 27.44           C  
ATOM    875  CG  PRO A 318      34.690  56.918   8.377  1.00 31.48           C  
ATOM    876  CD  PRO A 318      36.201  56.826   8.450  1.00 27.77           C  
ATOM    877  N   LEU A 319      34.607  59.517  11.973  1.00 32.20           N  
ATOM    878  CA  LEU A 319      34.139  59.424  13.347  1.00 34.19           C  
ATOM    879  C   LEU A 319      32.624  59.478  13.458  1.00 35.83           C  
ATOM    880  O   LEU A 319      32.067  59.503  14.551  1.00 34.31           O  
ATOM    881  CB  LEU A 319      34.797  60.521  14.187  1.00 33.95           C  
ATOM    882  CG  LEU A 319      36.332  60.489  14.144  1.00 34.94           C  
ATOM    883  CD1 LEU A 319      36.878  61.500  15.143  1.00 36.06           C  
ATOM    884  CD2 LEU A 319      36.855  59.077  14.472  1.00 35.14           C  
ATOM    885  N   GLU A 320      31.976  59.499  12.301  1.00 37.87           N  
ATOM    886  CA  GLU A 320      30.526  59.486  12.181  1.00 39.28           C  
ATOM    887  C   GLU A 320      30.333  58.371  11.160  1.00 38.51           C  
ATOM    888  O   GLU A 320      30.846  58.461  10.046  1.00 38.35           O  
ATOM    889  CB  GLU A 320      30.017  60.824  11.641  1.00 43.50           C  
ATOM    890  CG  GLU A 320      30.079  61.963  12.654  1.00 48.85           C  
ATOM    891  CD  GLU A 320      30.746  63.218  12.110  1.00 52.86           C  
ATOM    892  OE1 GLU A 320      30.381  63.673  10.999  1.00 54.90           O  
ATOM    893  OE2 GLU A 320      31.634  63.761  12.807  1.00 55.11           O  
ATOM    894  N   LYS A 321      29.619  57.320  11.554  1.00 37.03           N  
ATOM    895  CA  LYS A 321      29.393  56.142  10.708  1.00 36.91           C  
ATOM    896  C   LYS A 321      28.832  56.378   9.309  1.00 36.24           C  
ATOM    897  O   LYS A 321      29.236  55.712   8.350  1.00 33.92           O  
ATOM    898  CB  LYS A 321      28.494  55.146  11.449  1.00 39.13           C  
ATOM    899  CG  LYS A 321      27.183  55.736  11.916  1.00 39.70           C  
ATOM    900  CD  LYS A 321      26.398  54.726  12.736  1.00 41.63           C  
ATOM    901  CE  LYS A 321      25.103  55.332  13.242  1.00 43.88           C  
ATOM    902  NZ  LYS A 321      24.396  54.408  14.174  1.00 46.81           N  
ATOM    903  N   GLU A 322      27.895  57.309   9.187  1.00 34.87           N  
ATOM    904  CA  GLU A 322      27.301  57.607   7.891  1.00 34.43           C  
ATOM    905  C   GLU A 322      28.377  58.030   6.887  1.00 30.58           C  
ATOM    906  O   GLU A 322      28.280  57.735   5.699  1.00 29.44           O  
ATOM    907  CB  GLU A 322      26.254  58.720   8.027  1.00 36.69           C  
ATOM    908  CG  GLU A 322      25.041  58.353   8.885  1.00 39.79           C  
ATOM    909  CD  GLU A 322      25.300  58.420  10.392  1.00 41.34           C  
ATOM    910  OE1 GLU A 322      24.377  58.059  11.154  1.00 43.74           O  
ATOM    911  OE2 GLU A 322      26.402  58.836  10.823  1.00 40.31           O  
ATOM    912  N   SER A 323      29.396  58.728   7.373  1.00 30.68           N  
ATOM    913  CA  SER A 323      30.492  59.185   6.519  1.00 29.72           C  
ATOM    914  C   SER A 323      31.227  58.059   5.792  1.00 28.59           C  
ATOM    915  O   SER A 323      31.705  58.261   4.673  1.00 28.99           O  
ATOM    916  CB  SER A 323      31.514  59.981   7.339  1.00 30.51           C  
ATOM    917  OG  SER A 323      30.958  61.203   7.763  1.00 31.88           O  
ATOM    918  N   TYR A 324      31.344  56.894   6.431  1.00 27.78           N  
ATOM    919  CA  TYR A 324      32.041  55.770   5.797  1.00 28.59           C  
ATOM    920  C   TYR A 324      31.361  55.432   4.474  1.00 29.41           C  
ATOM    921  O   TYR A 324      32.017  55.215   3.460  1.00 28.46           O  
ATOM    922  CB  TYR A 324      32.047  54.517   6.697  1.00 26.94           C  
ATOM    923  CG  TYR A 324      32.862  53.357   6.122  1.00 26.18           C  
ATOM    924  CD1 TYR A 324      34.243  53.262   6.346  1.00 26.66           C  
ATOM    925  CD2 TYR A 324      32.263  52.395   5.314  1.00 26.11           C  
ATOM    926  CE1 TYR A 324      35.015  52.224   5.761  1.00 26.74           C  
ATOM    927  CE2 TYR A 324      33.017  51.356   4.728  1.00 26.88           C  
ATOM    928  CZ  TYR A 324      34.388  51.283   4.954  1.00 27.80           C  
ATOM    929  OH  TYR A 324      35.118  50.293   4.347  1.00 27.03           O  
ATOM    930  N   VAL A 325      30.034  55.389   4.490  1.00 29.00           N  
ATOM    931  CA  VAL A 325      29.273  55.066   3.292  1.00 29.13           C  
ATOM    932  C   VAL A 325      29.307  56.214   2.283  1.00 29.34           C  
ATOM    933  O   VAL A 325      29.418  56.006   1.074  1.00 29.40           O  
ATOM    934  CB  VAL A 325      27.813  54.735   3.672  1.00 31.19           C  
ATOM    935  CG1 VAL A 325      26.978  54.478   2.426  1.00 32.57           C  
ATOM    936  CG2 VAL A 325      27.793  53.511   4.587  1.00 31.48           C  
ATOM    937  N   HIS A 326      29.218  57.431   2.790  1.00 28.54           N  
ATOM    938  CA  HIS A 326      29.243  58.608   1.941  1.00 29.83           C  
ATOM    939  C   HIS A 326      30.544  58.680   1.136  1.00 28.23           C  
ATOM    940  O   HIS A 326      30.534  59.024  -0.048  1.00 25.83           O  
ATOM    941  CB  HIS A 326      29.118  59.857   2.805  1.00 35.13           C  
ATOM    942  CG  HIS A 326      28.436  60.996   2.125  1.00 41.35           C  
ATOM    943  ND1 HIS A 326      28.745  61.392   0.841  1.00 45.97           N  
ATOM    944  CD2 HIS A 326      27.456  61.829   2.548  1.00 44.00           C  
ATOM    945  CE1 HIS A 326      27.983  62.416   0.501  1.00 45.68           C  
ATOM    946  NE2 HIS A 326      27.192  62.701   1.520  1.00 45.08           N  
ATOM    947  N   ARG A 327      31.662  58.375   1.791  1.00 24.85           N  
ATOM    948  CA  ARG A 327      32.971  58.420   1.142  1.00 25.72           C  
ATOM    949  C   ARG A 327      33.145  57.397   0.005  1.00 27.08           C  
ATOM    950  O   ARG A 327      33.899  57.634  -0.947  1.00 27.31           O  
ATOM    951  CB  ARG A 327      34.062  58.242   2.201  1.00 25.44           C  
ATOM    952  CG  ARG A 327      34.145  59.437   3.172  1.00 25.12           C  
ATOM    953  CD  ARG A 327      35.173  59.199   4.248  1.00 29.54           C  
ATOM    954  NE  ARG A 327      35.304  60.322   5.179  1.00 28.12           N  
ATOM    955  CZ  ARG A 327      36.271  60.403   6.092  1.00 26.36           C  
ATOM    956  NH1 ARG A 327      37.175  59.438   6.177  1.00 26.17           N  
ATOM    957  NH2 ARG A 327      36.328  61.432   6.927  1.00 28.12           N  
ATOM    958  N   THR A 328      32.450  56.269   0.094  1.00 29.43           N  
ATOM    959  CA  THR A 328      32.542  55.244  -0.950  1.00 31.22           C  
ATOM    960  C   THR A 328      31.452  55.421  -2.026  1.00 31.13           C  
ATOM    961  O   THR A 328      31.302  54.582  -2.913  1.00 31.12           O  
ATOM    962  CB  THR A 328      32.411  53.838  -0.348  1.00 34.35           C  
ATOM    963  OG1 THR A 328      31.257  53.796   0.499  1.00 36.27           O  
ATOM    964  CG2 THR A 328      33.657  53.478   0.479  1.00 33.24           C  
ATOM    965  N   GLY A 329      30.724  56.531  -1.948  1.00 29.56           N  
ATOM    966  CA  GLY A 329      29.650  56.814  -2.895  1.00 30.75           C  
ATOM    967  C   GLY A 329      29.892  56.646  -4.395  1.00 32.02           C  
ATOM    968  O   GLY A 329      28.958  56.314  -5.127  1.00 32.38           O  
ATOM    969  N   ARG A 330      31.111  56.876  -4.876  1.00 31.36           N  
ATOM    970  CA  ARG A 330      31.376  56.740  -6.314  1.00 30.73           C  
ATOM    971  C   ARG A 330      32.358  55.614  -6.620  1.00 29.79           C  
ATOM    972  O   ARG A 330      33.006  55.599  -7.668  1.00 30.21           O  
ATOM    973  CB  ARG A 330      31.897  58.061  -6.895  1.00 31.92           C  
ATOM    974  CG  ARG A 330      30.875  59.210  -6.851  1.00 36.86           C  
ATOM    975  CD  ARG A 330      29.523  58.801  -7.457  1.00 38.90           C  
ATOM    976  NE  ARG A 330      29.661  58.259  -8.805  1.00 42.32           N  
ATOM    977  CZ  ARG A 330      28.759  57.488  -9.407  1.00 43.75           C  
ATOM    978  NH1 ARG A 330      27.632  57.164  -8.785  1.00 44.51           N  
ATOM    979  NH2 ARG A 330      28.999  57.010 -10.624  1.00 44.28           N  
ATOM    980  N   THR A 331      32.440  54.660  -5.705  1.00 27.47           N  
ATOM    981  CA  THR A 331      33.331  53.526  -5.849  1.00 27.92           C  
ATOM    982  C   THR A 331      32.530  52.236  -5.992  1.00 28.23           C  
ATOM    983  O   THR A 331      31.473  52.085  -5.378  1.00 28.56           O  
ATOM    984  CB  THR A 331      34.261  53.419  -4.618  1.00 27.98           C  
ATOM    985  OG1 THR A 331      34.922  54.679  -4.424  1.00 29.89           O  
ATOM    986  CG2 THR A 331      35.327  52.317  -4.828  1.00 26.46           C  
ATOM    987  N   GLY A 332      33.044  51.316  -6.805  1.00 29.78           N  
ATOM    988  CA  GLY A 332      32.390  50.029  -6.999  1.00 31.33           C  
ATOM    989  C   GLY A 332      31.036  50.007  -7.692  1.00 34.16           C  
ATOM    990  O   GLY A 332      30.246  49.081  -7.463  1.00 32.96           O  
ATOM    991  N   ARG A 333      30.757  50.999  -8.534  1.00 34.75           N  
ATOM    992  CA  ARG A 333      29.477  51.048  -9.231  1.00 37.72           C  
ATOM    993  C   ARG A 333      29.550  50.652 -10.702  1.00 38.93           C  
ATOM    994  O   ARG A 333      30.597  50.756 -11.337  1.00 37.78           O  
ATOM    995  CB  ARG A 333      28.864  52.453  -9.148  1.00 39.53           C  
ATOM    996  CG  ARG A 333      28.340  52.847  -7.778  1.00 42.78           C  
ATOM    997  CD  ARG A 333      27.601  54.167  -7.864  1.00 45.20           C  
ATOM    998  NE  ARG A 333      27.327  54.734  -6.549  1.00 47.33           N  
ATOM    999  CZ  ARG A 333      26.356  54.333  -5.737  1.00 48.91           C  
ATOM   1000  NH1 ARG A 333      25.535  53.349  -6.099  1.00 48.29           N  
ATOM   1001  NH2 ARG A 333      26.210  54.922  -4.556  1.00 47.97           N  
ATOM   1002  N   ALA A 334      28.415  50.196 -11.230  1.00 40.28           N  
ATOM   1003  CA  ALA A 334      28.290  49.817 -12.638  1.00 41.16           C  
ATOM   1004  C   ALA A 334      29.365  48.880 -13.184  1.00 41.16           C  
ATOM   1005  O   ALA A 334      29.859  49.080 -14.291  1.00 43.36           O  
ATOM   1006  CB  ALA A 334      28.231  51.085 -13.499  1.00 39.64           C  
ATOM   1007  N   GLY A 335      29.725  47.859 -12.417  1.00 40.98           N  
ATOM   1008  CA  GLY A 335      30.722  46.912 -12.890  1.00 40.88           C  
ATOM   1009  C   GLY A 335      32.159  47.222 -12.531  1.00 39.92           C  
ATOM   1010  O   GLY A 335      33.036  46.367 -12.681  1.00 40.58           O  
ATOM   1011  N   ASN A 336      32.426  48.444 -12.084  1.00 39.70           N  
ATOM   1012  CA  ASN A 336      33.786  48.789 -11.692  1.00 38.38           C  
ATOM   1013  C   ASN A 336      34.092  48.041 -10.397  1.00 37.50           C  
ATOM   1014  O   ASN A 336      33.213  47.874  -9.550  1.00 36.45           O  
ATOM   1015  CB  ASN A 336      33.923  50.298 -11.431  1.00 38.72           C  
ATOM   1016  CG  ASN A 336      33.846  51.120 -12.696  1.00 39.19           C  
ATOM   1017  OD1 ASN A 336      32.892  51.871 -12.907  1.00 39.26           O  
ATOM   1018  ND2 ASN A 336      34.856  50.985 -13.548  1.00 40.57           N  
ATOM   1019  N   LYS A 337      35.325  47.575 -10.256  1.00 37.34           N  
ATOM   1020  CA  LYS A 337      35.738  46.894  -9.037  1.00 38.84           C  
ATOM   1021  C   LYS A 337      36.329  48.006  -8.178  1.00 37.36           C  
ATOM   1022  O   LYS A 337      37.224  48.715  -8.623  1.00 40.43           O  
ATOM   1023  CB  LYS A 337      36.813  45.848  -9.344  1.00 42.29           C  
ATOM   1024  CG  LYS A 337      36.406  44.839 -10.408  1.00 44.90           C  
ATOM   1025  CD  LYS A 337      35.128  44.114 -10.022  1.00 47.25           C  
ATOM   1026  CE  LYS A 337      34.685  43.153 -11.127  1.00 50.95           C  
ATOM   1027  NZ  LYS A 337      33.436  42.415 -10.765  1.00 52.07           N  
ATOM   1028  N   GLY A 338      35.820  48.182  -6.966  1.00 35.36           N  
ATOM   1029  CA  GLY A 338      36.339  49.238  -6.112  1.00 30.50           C  
ATOM   1030  C   GLY A 338      36.962  48.709  -4.837  1.00 29.42           C  
ATOM   1031  O   GLY A 338      36.786  47.538  -4.487  1.00 26.64           O  
ATOM   1032  N   LYS A 339      37.666  49.585  -4.125  1.00 27.87           N  
ATOM   1033  CA  LYS A 339      38.337  49.207  -2.890  1.00 27.21           C  
ATOM   1034  C   LYS A 339      38.326  50.366  -1.891  1.00 25.63           C  
ATOM   1035  O   LYS A 339      38.467  51.525  -2.276  1.00 23.58           O  
ATOM   1036  CB  LYS A 339      39.784  48.820  -3.218  1.00 31.91           C  
ATOM   1037  CG  LYS A 339      40.530  48.056  -2.142  1.00 36.69           C  
ATOM   1038  CD  LYS A 339      41.613  47.197  -2.808  1.00 40.43           C  
ATOM   1039  CE  LYS A 339      42.379  46.335  -1.817  1.00 43.43           C  
ATOM   1040  NZ  LYS A 339      43.383  45.484  -2.536  1.00 44.17           N  
ATOM   1041  N   ALA A 340      38.157  50.037  -0.615  1.00 23.41           N  
ATOM   1042  CA  ALA A 340      38.167  51.037   0.441  1.00 22.87           C  
ATOM   1043  C   ALA A 340      39.101  50.524   1.539  1.00 21.88           C  
ATOM   1044  O   ALA A 340      38.893  49.444   2.085  1.00 24.70           O  
ATOM   1045  CB  ALA A 340      36.758  51.247   0.990  1.00 23.41           C  
ATOM   1046  N   ILE A 341      40.148  51.285   1.823  1.00 20.18           N  
ATOM   1047  CA  ILE A 341      41.133  50.929   2.839  1.00 21.82           C  
ATOM   1048  C   ILE A 341      41.094  51.997   3.927  1.00 20.53           C  
ATOM   1049  O   ILE A 341      41.216  53.185   3.638  1.00 22.71           O  
ATOM   1050  CB  ILE A 341      42.566  50.876   2.225  1.00 21.56           C  
ATOM   1051  CG1 ILE A 341      42.646  49.781   1.159  1.00 24.94           C  
ATOM   1052  CG2 ILE A 341      43.603  50.628   3.330  1.00 23.32           C  
ATOM   1053  CD1 ILE A 341      44.054  49.653   0.520  1.00 24.59           C  
ATOM   1054  N   SER A 342      40.913  51.588   5.180  1.00 21.98           N  
ATOM   1055  CA  SER A 342      40.844  52.557   6.270  1.00 21.25           C  
ATOM   1056  C   SER A 342      42.013  52.409   7.241  1.00 20.03           C  
ATOM   1057  O   SER A 342      42.381  51.293   7.601  1.00 21.28           O  
ATOM   1058  CB  SER A 342      39.527  52.380   7.034  1.00 23.60           C  
ATOM   1059  OG  SER A 342      38.397  52.601   6.197  1.00 25.11           O  
ATOM   1060  N   PHE A 343      42.619  53.523   7.642  1.00 19.90           N  
ATOM   1061  CA  PHE A 343      43.718  53.473   8.617  1.00 20.90           C  
ATOM   1062  C   PHE A 343      43.051  53.677   9.990  1.00 22.19           C  
ATOM   1063  O   PHE A 343      42.302  54.645  10.184  1.00 22.70           O  
ATOM   1064  CB  PHE A 343      44.725  54.603   8.382  1.00 21.51           C  
ATOM   1065  CG  PHE A 343      45.488  54.498   7.079  1.00 22.17           C  
ATOM   1066  CD1 PHE A 343      45.343  53.388   6.242  1.00 22.62           C  
ATOM   1067  CD2 PHE A 343      46.383  55.505   6.713  1.00 22.45           C  
ATOM   1068  CE1 PHE A 343      46.091  53.285   5.054  1.00 22.95           C  
ATOM   1069  CE2 PHE A 343      47.133  55.414   5.538  1.00 26.45           C  
ATOM   1070  CZ  PHE A 343      46.987  54.299   4.706  1.00 23.54           C  
ATOM   1071  N   VAL A 344      43.339  52.789  10.934  1.00 19.92           N  
ATOM   1072  CA  VAL A 344      42.730  52.855  12.268  1.00 21.77           C  
ATOM   1073  C   VAL A 344      43.773  52.801  13.384  1.00 22.51           C  
ATOM   1074  O   VAL A 344      44.603  51.890  13.422  1.00 22.54           O  
ATOM   1075  CB  VAL A 344      41.749  51.681  12.433  1.00 20.99           C  
ATOM   1076  CG1 VAL A 344      40.997  51.755  13.810  1.00 22.05           C  
ATOM   1077  CG2 VAL A 344      40.742  51.719  11.259  1.00 25.32           C  
ATOM   1078  N   THR A 345      43.738  53.768  14.297  1.00 24.62           N  
ATOM   1079  CA  THR A 345      44.707  53.763  15.401  1.00 23.69           C  
ATOM   1080  C   THR A 345      44.165  52.950  16.569  1.00 25.19           C  
ATOM   1081  O   THR A 345      43.002  52.535  16.568  1.00 24.43           O  
ATOM   1082  CB  THR A 345      45.019  55.194  15.922  1.00 22.24           C  
ATOM   1083  OG1 THR A 345      43.853  55.725  16.568  1.00 23.41           O  
ATOM   1084  CG2 THR A 345      45.433  56.104  14.777  1.00 23.54           C  
ATOM   1085  N   ALA A 346      45.008  52.730  17.573  1.00 25.93           N  
ATOM   1086  CA  ALA A 346      44.592  51.964  18.746  1.00 28.11           C  
ATOM   1087  C   ALA A 346      43.448  52.626  19.507  1.00 28.44           C  
ATOM   1088  O   ALA A 346      42.716  51.955  20.233  1.00 31.07           O  
ATOM   1089  CB  ALA A 346      45.788  51.752  19.691  1.00 30.25           C  
ATOM   1090  N   PHE A 347      43.278  53.933  19.335  1.00 27.66           N  
ATOM   1091  CA  PHE A 347      42.228  54.658  20.040  1.00 27.80           C  
ATOM   1092  C   PHE A 347      40.867  54.743  19.327  1.00 28.76           C  
ATOM   1093  O   PHE A 347      39.910  55.283  19.889  1.00 28.47           O  
ATOM   1094  CB  PHE A 347      42.741  56.081  20.359  1.00 30.24           C  
ATOM   1095  CG  PHE A 347      44.119  56.098  20.962  1.00 28.88           C  
ATOM   1096  CD1 PHE A 347      45.242  56.321  20.171  1.00 29.37           C  
ATOM   1097  CD2 PHE A 347      44.297  55.837  22.323  1.00 29.42           C  
ATOM   1098  CE1 PHE A 347      46.529  56.280  20.719  1.00 31.03           C  
ATOM   1099  CE2 PHE A 347      45.573  55.792  22.882  1.00 28.25           C  
ATOM   1100  CZ  PHE A 347      46.692  56.013  22.082  1.00 29.94           C  
ATOM   1101  N   GLU A 348      40.756  54.189  18.119  1.00 27.45           N  
ATOM   1102  CA  GLU A 348      39.500  54.273  17.365  1.00 26.86           C  
ATOM   1103  C   GLU A 348      38.716  52.963  17.205  1.00 27.21           C  
ATOM   1104  O   GLU A 348      37.910  52.826  16.292  1.00 25.50           O  
ATOM   1105  CB  GLU A 348      39.778  54.875  15.974  1.00 28.83           C  
ATOM   1106  CG  GLU A 348      40.475  56.239  16.025  1.00 29.92           C  
ATOM   1107  CD  GLU A 348      41.030  56.706  14.675  1.00 34.57           C  
ATOM   1108  OE1 GLU A 348      41.486  55.857  13.870  1.00 31.96           O  
ATOM   1109  OE2 GLU A 348      41.031  57.936  14.429  1.00 35.73           O  
ATOM   1110  N   LYS A 349      38.936  52.003  18.094  1.00 27.40           N  
ATOM   1111  CA  LYS A 349      38.233  50.731  17.990  1.00 31.15           C  
ATOM   1112  C   LYS A 349      36.712  50.837  18.063  1.00 30.88           C  
ATOM   1113  O   LYS A 349      36.004  50.146  17.336  1.00 31.45           O  
ATOM   1114  CB  LYS A 349      38.755  49.760  19.055  1.00 33.23           C  
ATOM   1115  CG  LYS A 349      40.210  49.364  18.811  1.00 37.63           C  
ATOM   1116  CD  LYS A 349      40.770  48.468  19.909  1.00 42.37           C  
ATOM   1117  CE  LYS A 349      42.192  48.056  19.568  1.00 45.33           C  
ATOM   1118  NZ  LYS A 349      42.228  47.264  18.308  1.00 47.45           N  
ATOM   1119  N   ARG A 350      36.207  51.710  18.925  1.00 32.64           N  
ATOM   1120  CA  ARG A 350      34.765  51.871  19.064  1.00 33.75           C  
ATOM   1121  C   ARG A 350      34.173  52.549  17.836  1.00 32.61           C  
ATOM   1122  O   ARG A 350      33.043  52.255  17.445  1.00 32.23           O  
ATOM   1123  CB  ARG A 350      34.440  52.679  20.324  1.00 38.98           C  
ATOM   1124  CG  ARG A 350      34.878  51.990  21.611  1.00 44.91           C  
ATOM   1125  CD  ARG A 350      34.456  52.764  22.856  1.00 51.94           C  
ATOM   1126  NE  ARG A 350      34.777  52.032  24.084  1.00 56.17           N  
ATOM   1127  CZ  ARG A 350      34.647  52.530  25.311  1.00 59.09           C  
ATOM   1128  NH1 ARG A 350      34.200  53.771  25.483  1.00 60.29           N  
ATOM   1129  NH2 ARG A 350      34.964  51.790  26.369  1.00 59.32           N  
ATOM   1130  N   PHE A 351      34.928  53.459  17.222  1.00 30.77           N  
ATOM   1131  CA  PHE A 351      34.423  54.129  16.023  1.00 29.33           C  
ATOM   1132  C   PHE A 351      34.355  53.128  14.873  1.00 28.04           C  
ATOM   1133  O   PHE A 351      33.471  53.203  14.020  1.00 26.94           O  
ATOM   1134  CB  PHE A 351      35.319  55.308  15.628  1.00 30.73           C  
ATOM   1135  CG  PHE A 351      35.275  56.437  16.602  1.00 31.31           C  
ATOM   1136  CD1 PHE A 351      36.311  56.632  17.508  1.00 32.07           C  
ATOM   1137  CD2 PHE A 351      34.161  57.281  16.654  1.00 32.09           C  
ATOM   1138  CE1 PHE A 351      36.249  57.647  18.462  1.00 34.01           C  
ATOM   1139  CE2 PHE A 351      34.086  58.297  17.603  1.00 34.13           C  
ATOM   1140  CZ  PHE A 351      35.136  58.479  18.512  1.00 34.94           C  
ATOM   1141  N   LEU A 352      35.287  52.185  14.858  1.00 27.34           N  
ATOM   1142  CA  LEU A 352      35.306  51.173  13.806  1.00 27.36           C  
ATOM   1143  C   LEU A 352      34.128  50.225  14.012  1.00 27.32           C  
ATOM   1144  O   LEU A 352      33.454  49.847  13.060  1.00 26.87           O  
ATOM   1145  CB  LEU A 352      36.619  50.382  13.833  1.00 25.95           C  
ATOM   1146  CG  LEU A 352      36.656  49.202  12.856  1.00 25.72           C  
ATOM   1147  CD1 LEU A 352      36.408  49.704  11.426  1.00 23.84           C  
ATOM   1148  CD2 LEU A 352      38.001  48.495  12.956  1.00 25.68           C  
ATOM   1149  N   ALA A 353      33.880  49.853  15.264  1.00 28.88           N  
ATOM   1150  CA  ALA A 353      32.767  48.957  15.585  1.00 29.54           C  
ATOM   1151  C   ALA A 353      31.439  49.613  15.193  1.00 30.17           C  
ATOM   1152  O   ALA A 353      30.540  48.937  14.702  1.00 30.34           O  
ATOM   1153  CB  ALA A 353      32.772  48.608  17.092  1.00 31.62           C  
ATOM   1154  N   ASP A 354      31.319  50.925  15.405  1.00 31.34           N  
ATOM   1155  CA  ASP A 354      30.095  51.651  15.021  1.00 31.88           C  
ATOM   1156  C   ASP A 354      29.874  51.522  13.513  1.00 31.48           C  
ATOM   1157  O   ASP A 354      28.767  51.264  13.049  1.00 33.32           O  
ATOM   1158  CB  ASP A 354      30.187  53.149  15.340  1.00 34.57           C  
ATOM   1159  CG  ASP A 354      30.124  53.450  16.821  1.00 38.49           C  
ATOM   1160  OD1 ASP A 354      29.419  52.722  17.546  1.00 41.32           O  
ATOM   1161  OD2 ASP A 354      30.769  54.438  17.254  1.00 41.47           O  
ATOM   1162  N   ILE A 355      30.935  51.720  12.742  1.00 29.62           N  
ATOM   1163  CA  ILE A 355      30.833  51.619  11.294  1.00 28.31           C  
ATOM   1164  C   ILE A 355      30.408  50.212  10.842  1.00 28.11           C  
ATOM   1165  O   ILE A 355      29.517  50.062   9.999  1.00 27.92           O  
ATOM   1166  CB  ILE A 355      32.182  51.982  10.625  1.00 28.94           C  
ATOM   1167  CG1 ILE A 355      32.458  53.484  10.792  1.00 26.89           C  
ATOM   1168  CG2 ILE A 355      32.151  51.625   9.140  1.00 23.94           C  
ATOM   1169  CD1 ILE A 355      33.897  53.902  10.417  1.00 25.33           C  
ATOM   1170  N   GLU A 356      31.043  49.190  11.400  1.00 28.56           N  
ATOM   1171  CA  GLU A 356      30.737  47.822  11.017  1.00 33.05           C  
ATOM   1172  C   GLU A 356      29.301  47.424  11.348  1.00 35.61           C  
ATOM   1173  O   GLU A 356      28.647  46.759  10.548  1.00 34.83           O  
ATOM   1174  CB  GLU A 356      31.741  46.859  11.660  1.00 33.80           C  
ATOM   1175  CG  GLU A 356      33.170  47.117  11.186  1.00 35.53           C  
ATOM   1176  CD  GLU A 356      34.211  46.296  11.912  1.00 37.68           C  
ATOM   1177  OE1 GLU A 356      34.180  46.261  13.162  1.00 38.18           O  
ATOM   1178  OE2 GLU A 356      35.079  45.695  11.235  1.00 39.95           O  
ATOM   1179  N   GLU A 357      28.803  47.831  12.512  1.00 36.85           N  
ATOM   1180  CA  GLU A 357      27.424  47.495  12.862  1.00 40.26           C  
ATOM   1181  C   GLU A 357      26.484  48.219  11.902  1.00 38.64           C  
ATOM   1182  O   GLU A 357      25.435  47.694  11.526  1.00 38.84           O  
ATOM   1183  CB  GLU A 357      27.095  47.900  14.306  1.00 41.82           C  
ATOM   1184  CG  GLU A 357      25.609  47.720  14.636  1.00 47.94           C  
ATOM   1185  CD  GLU A 357      25.255  48.076  16.073  1.00 50.57           C  
ATOM   1186  OE1 GLU A 357      25.589  47.294  16.992  1.00 53.48           O  
ATOM   1187  OE2 GLU A 357      24.641  49.144  16.282  1.00 53.09           O  
ATOM   1188  N   TYR A 358      26.875  49.422  11.495  1.00 37.50           N  
ATOM   1189  CA  TYR A 358      26.077  50.229  10.579  1.00 36.97           C  
ATOM   1190  C   TYR A 358      25.995  49.668   9.159  1.00 37.21           C  
ATOM   1191  O   TYR A 358      24.926  49.688   8.552  1.00 36.59           O  
ATOM   1192  CB  TYR A 358      26.629  51.655  10.517  1.00 38.38           C  
ATOM   1193  CG  TYR A 358      25.864  52.573   9.593  1.00 37.53           C  
ATOM   1194  CD1 TYR A 358      24.529  52.903   9.852  1.00 39.42           C  
ATOM   1195  CD2 TYR A 358      26.471  53.127   8.472  1.00 37.40           C  
ATOM   1196  CE1 TYR A 358      23.826  53.763   9.016  1.00 40.90           C  
ATOM   1197  CE2 TYR A 358      25.778  53.993   7.628  1.00 40.11           C  
ATOM   1198  CZ  TYR A 358      24.453  54.307   7.909  1.00 41.12           C  
ATOM   1199  OH  TYR A 358      23.763  55.174   7.096  1.00 42.27           O  
ATOM   1200  N   ILE A 359      27.116  49.187   8.616  1.00 35.09           N  
ATOM   1201  CA  ILE A 359      27.110  48.640   7.262  1.00 34.38           C  
ATOM   1202  C   ILE A 359      26.656  47.180   7.257  1.00 35.10           C  
ATOM   1203  O   ILE A 359      26.379  46.606   6.205  1.00 35.16           O  
ATOM   1204  CB  ILE A 359      28.501  48.766   6.587  1.00 34.16           C  
ATOM   1205  CG1 ILE A 359      29.575  48.103   7.455  1.00 33.75           C  
ATOM   1206  CG2 ILE A 359      28.839  50.248   6.364  1.00 34.52           C  
ATOM   1207  CD1 ILE A 359      30.977  48.192   6.864  1.00 33.65           C  
ATOM   1208  N   GLY A 360      26.588  46.582   8.442  1.00 36.96           N  
ATOM   1209  CA  GLY A 360      26.117  45.210   8.544  1.00 37.42           C  
ATOM   1210  C   GLY A 360      27.120  44.075   8.483  1.00 37.95           C  
ATOM   1211  O   GLY A 360      26.716  42.917   8.471  1.00 38.77           O  
ATOM   1212  N   PHE A 361      28.413  44.381   8.442  1.00 36.03           N  
ATOM   1213  CA  PHE A 361      29.426  43.331   8.389  1.00 35.03           C  
ATOM   1214  C   PHE A 361      30.771  43.821   8.922  1.00 34.51           C  
ATOM   1215  O   PHE A 361      31.025  45.022   8.985  1.00 32.66           O  
ATOM   1216  CB  PHE A 361      29.589  42.829   6.951  1.00 35.19           C  
ATOM   1217  CG  PHE A 361      29.984  43.904   5.968  1.00 36.28           C  
ATOM   1218  CD1 PHE A 361      31.307  44.332   5.870  1.00 34.75           C  
ATOM   1219  CD2 PHE A 361      29.028  44.490   5.139  1.00 36.37           C  
ATOM   1220  CE1 PHE A 361      31.674  45.323   4.956  1.00 34.64           C  
ATOM   1221  CE2 PHE A 361      29.387  45.481   4.223  1.00 35.78           C  
ATOM   1222  CZ  PHE A 361      30.716  45.896   4.134  1.00 36.35           C  
ATOM   1223  N   GLU A 362      31.633  42.887   9.294  1.00 32.72           N  
ATOM   1224  CA  GLU A 362      32.944  43.250   9.808  1.00 34.71           C  
ATOM   1225  C   GLU A 362      33.909  43.415   8.644  1.00 31.52           C  
ATOM   1226  O   GLU A 362      33.791  42.728   7.636  1.00 29.99           O  
ATOM   1227  CB  GLU A 362      33.462  42.175  10.763  1.00 37.84           C  
ATOM   1228  CG  GLU A 362      32.550  41.934  11.945  1.00 43.48           C  
ATOM   1229  CD  GLU A 362      33.118  40.907  12.903  1.00 47.28           C  
ATOM   1230  OE1 GLU A 362      34.012  41.265  13.697  1.00 49.10           O  
ATOM   1231  OE2 GLU A 362      32.672  39.741  12.848  1.00 50.80           O  
ATOM   1232  N   ILE A 363      34.854  44.338   8.789  1.00 27.60           N  
ATOM   1233  CA  ILE A 363      35.819  44.594   7.740  1.00 26.40           C  
ATOM   1234  C   ILE A 363      37.104  43.851   8.051  1.00 26.09           C  
ATOM   1235  O   ILE A 363      37.605  43.916   9.168  1.00 27.11           O  
ATOM   1236  CB  ILE A 363      36.145  46.104   7.626  1.00 25.28           C  
ATOM   1237  CG1 ILE A 363      34.860  46.897   7.345  1.00 24.75           C  
ATOM   1238  CG2 ILE A 363      37.185  46.316   6.520  1.00 25.23           C  
ATOM   1239  CD1 ILE A 363      35.044  48.421   7.453  1.00 28.31           C  
ATOM   1240  N   GLN A 364      37.634  43.150   7.057  1.00 25.69           N  
ATOM   1241  CA  GLN A 364      38.866  42.404   7.234  1.00 26.15           C  
ATOM   1242  C   GLN A 364      40.070  43.289   7.556  1.00 25.73           C  
ATOM   1243  O   GLN A 364      40.311  44.316   6.907  1.00 23.42           O  
ATOM   1244  CB  GLN A 364      39.162  41.572   5.980  1.00 27.57           C  
ATOM   1245  CG  GLN A 364      40.437  40.758   6.077  1.00 29.93           C  
ATOM   1246  CD  GLN A 364      40.670  39.890   4.859  1.00 31.37           C  
ATOM   1247  OE1 GLN A 364      40.469  40.322   3.725  1.00 33.59           O  
ATOM   1248  NE2 GLN A 364      41.112  38.666   5.089  1.00 30.32           N  
ATOM   1249  N   LYS A 365      40.829  42.895   8.572  1.00 25.39           N  
ATOM   1250  CA  LYS A 365      42.021  43.640   8.931  1.00 27.94           C  
ATOM   1251  C   LYS A 365      43.178  43.007   8.174  1.00 29.49           C  
ATOM   1252  O   LYS A 365      43.323  41.785   8.165  1.00 30.00           O  
ATOM   1253  CB  LYS A 365      42.273  43.557  10.433  1.00 30.61           C  
ATOM   1254  CG  LYS A 365      41.221  44.261  11.248  1.00 32.51           C  
ATOM   1255  CD  LYS A 365      41.550  44.236  12.729  1.00 36.50           C  
ATOM   1256  CE  LYS A 365      40.718  45.269  13.480  1.00 36.34           C  
ATOM   1257  NZ  LYS A 365      39.257  44.996  13.394  1.00 38.15           N  
ATOM   1258  N   ILE A 366      43.982  43.830   7.516  1.00 30.28           N  
ATOM   1259  CA  ILE A 366      45.122  43.327   6.758  1.00 33.09           C  
ATOM   1260  C   ILE A 366      46.402  44.038   7.179  1.00 36.39           C  
ATOM   1261  O   ILE A 366      46.362  45.077   7.844  1.00 33.72           O  
ATOM   1262  CB  ILE A 366      44.905  43.522   5.239  1.00 32.57           C  
ATOM   1263  CG1 ILE A 366      44.825  45.017   4.900  1.00 31.94           C  
ATOM   1264  CG2 ILE A 366      43.616  42.830   4.821  1.00 32.98           C  
ATOM   1265  CD1 ILE A 366      44.830  45.330   3.399  1.00 33.50           C  
ATOM   1266  N   GLU A 367      47.545  43.481   6.787  1.00 40.79           N  
ATOM   1267  CA  GLU A 367      48.827  44.076   7.140  1.00 46.73           C  
ATOM   1268  C   GLU A 367      49.541  44.639   5.921  1.00 49.93           C  
ATOM   1269  O   GLU A 367      49.350  44.160   4.803  1.00 50.95           O  
ATOM   1270  CB  GLU A 367      49.707  43.025   7.824  1.00 48.31           C  
ATOM   1271  CG  GLU A 367      49.162  42.583   9.179  1.00 52.19           C  
ATOM   1272  CD  GLU A 367      49.659  41.215   9.601  1.00 54.40           C  
ATOM   1273  OE1 GLU A 367      49.368  40.231   8.886  1.00 55.09           O  
ATOM   1274  OE2 GLU A 367      50.335  41.122  10.650  1.00 57.60           O  
ATOM   1275  N   ALA A 368      50.357  45.664   6.143  1.00 52.79           N  
ATOM   1276  CA  ALA A 368      51.115  46.287   5.066  1.00 55.20           C  
ATOM   1277  C   ALA A 368      50.214  46.713   3.916  1.00 57.37           C  
ATOM   1278  O   ALA A 368      50.279  46.144   2.824  1.00 59.21           O  
ATOM   1279  CB  ALA A 368      52.176  45.325   4.564  1.00 56.29           C  
TER    1280      ALA A 368                                                      
END
MOLECULE T0493.pdb
ATOM      1  N   ALA     3      23.401  57.599  -8.026  1.00 52.44           N  
ATOM      2  CA  ALA     3      22.280  56.642  -7.749  1.00 52.03           C  
ATOM      3  C   ALA     3      22.285  55.493  -8.753  1.00 51.73           C  
ATOM      4  O   ALA     3      21.653  54.454  -8.529  1.00 52.23           O  
ATOM      5  CB  ALA     3      20.926  57.364  -7.768  1.00 52.53           C  
ATOM      6  N   SER     4      22.988  55.695  -9.867  1.00 50.50           N  
ATOM      7  CA  SER     4      23.166  54.655 -10.884  1.00 48.89           C  
ATOM      8  C   SER     4      24.388  53.791 -10.566  1.00 48.11           C  
ATOM      9  O   SER     4      24.427  52.605 -10.904  1.00 47.53           O  
ATOM     10  CB  SER     4      23.323  55.285 -12.269  1.00 49.13           C  
ATOM     11  OG  SER     4      22.194  56.066 -12.603  1.00 48.13           O  
ATOM     12  N   TYR     5      25.380  54.406  -9.923  1.00 46.98           N  
ATOM     13  CA  TYR     5      26.605  53.705  -9.531  1.00 46.69           C  
ATOM     14  C   TYR     5      26.361  52.806  -8.328  1.00 46.91           C  
ATOM     15  O   TYR     5      25.677  53.204  -7.375  1.00 48.01           O  
ATOM     16  CB  TYR     5      27.703  54.703  -9.152  1.00 46.13           C  
ATOM     17  CG  TYR     5      28.294  55.433 -10.331  1.00 45.34           C  
ATOM     18  CD1 TYR     5      29.316  54.856 -11.091  1.00 46.08           C  
ATOM     19  CD2 TYR     5      27.813  56.695 -10.702  1.00 46.11           C  
ATOM     20  CE1 TYR     5      29.867  55.532 -12.191  1.00 44.81           C  
ATOM     21  CE2 TYR     5      28.343  57.375 -11.783  1.00 44.56           C  
ATOM     22  CZ  TYR     5      29.373  56.789 -12.530  1.00 45.80           C  
ATOM     23  OH  TYR     5      29.901  57.464 -13.612  1.00 42.86           O  
ATOM     24  N   ARG     6      26.965  51.619  -8.353  1.00 45.73           N  
ATOM     25  CA  ARG     6      26.926  50.711  -7.199  1.00 44.82           C  
ATOM     26  C   ARG     6      28.313  50.148  -6.897  1.00 42.16           C  
ATOM     27  O   ARG     6      29.076  49.831  -7.829  1.00 42.87           O  
ATOM     28  CB  ARG     6      25.938  49.587  -7.455  1.00 45.46           C  
ATOM     29  CG  ARG     6      24.543  49.931  -7.000  1.00 49.70           C  
ATOM     30  CD  ARG     6      23.490  49.496  -7.997  1.00 54.87           C  
ATOM     31  NE  ARG     6      22.194  49.262  -7.353  1.00 60.25           N  
ATOM     32  CZ  ARG     6      21.451  50.193  -6.749  1.00 61.64           C  
ATOM     33  NH1 ARG     6      20.288  49.850  -6.203  1.00 62.66           N  
ATOM     34  NH2 ARG     6      21.859  51.458  -6.679  1.00 62.66           N  
ATOM     35  N   SER     7      28.633  50.040  -5.607  1.00 40.44           N  
ATOM     36  CA  SER     7      29.901  49.481  -5.187  1.00 37.38           C  
ATOM     37  C   SER     7      29.824  47.966  -5.225  1.00 34.65           C  
ATOM     38  O   SER     7      28.749  47.364  -5.449  1.00 34.03           O  
ATOM     39  CB  SER     7      30.302  49.894  -3.765  1.00 37.76           C  
ATOM     40  OG  SER     7      30.267  51.294  -3.532  1.00 43.12           O  
ATOM     41  N   THR     8      30.977  47.353  -5.003  1.00 30.63           N  
ATOM     42  CA  THR     8      31.060  45.900  -4.883  1.00 28.67           C  
ATOM     43  C   THR     8      30.276  45.477  -3.653  1.00 27.45           C  
ATOM     44  O   THR     8      30.089  46.259  -2.722  1.00 27.39           O  
ATOM     45  CB  THR     8      32.505  45.447  -4.649  1.00 28.34           C  
ATOM     46  OG1 THR     8      32.987  46.023  -3.437  1.00 28.77           O  
ATOM     47  CG2 THR     8      33.419  45.819  -5.868  1.00 28.61           C  
ATOM     48  N   GLN     9      29.839  44.218  -3.657  1.00 26.98           N  
ATOM     49  CA  GLN     9      29.210  43.680  -2.442  1.00 25.83           C  
ATOM     50  C   GLN     9      30.078  43.839  -1.189  1.00 26.06           C  
ATOM     51  O   GLN     9      29.558  44.057  -0.092  1.00 25.99           O  
ATOM     52  CB  GLN     9      28.931  42.204  -2.647  1.00 26.34           C  
ATOM     53  CG  GLN     9      28.262  41.594  -1.406  1.00 26.68           C  
ATOM     54  CD  GLN     9      27.711  40.223  -1.694  1.00 26.31           C  
ATOM     55  OE1 GLN     9      28.304  39.434  -2.445  1.00 27.31           O  
ATOM     56  NE2 GLN     9      26.561  39.927  -1.100  1.00 28.33           N  
ATOM     57  N   GLN    10      31.388  43.697  -1.348  1.00 26.07           N  
ATOM     58  CA  GLN    10      32.318  43.781  -0.211  1.00 26.63           C  
ATOM     59  C   GLN    10      32.240  45.169   0.423  1.00 27.17           C  
ATOM     60  O   GLN    10      32.144  45.301   1.650  1.00 28.40           O  
ATOM     61  CB  GLN    10      33.741  43.454  -0.677  1.00 28.52           C  
ATOM     62  CG  GLN    10      33.959  41.941  -0.882  1.00 29.61           C  
ATOM     63  CD  GLN    10      33.297  41.361  -2.098  1.00 32.71           C  
ATOM     64  OE1 GLN    10      32.935  42.059  -3.052  1.00 30.40           O  
ATOM     65  NE2 GLN    10      33.126  40.058  -2.066  1.00 35.11           N  
ATOM     66  N   ILE    11      32.307  46.203  -0.413  1.00 26.17           N  
ATOM     67  CA  ILE    11      32.245  47.587   0.101  1.00 26.61           C  
ATOM     68  C   ILE    11      30.853  47.893   0.661  1.00 26.84           C  
ATOM     69  O   ILE    11      30.741  48.492   1.724  1.00 27.77           O  
ATOM     70  CB  ILE    11      32.682  48.578  -1.024  1.00 27.26           C  
ATOM     71  CG1 ILE    11      34.173  48.377  -1.254  1.00 28.78           C  
ATOM     72  CG2 ILE    11      32.368  50.027  -0.676  1.00 28.17           C  
ATOM     73  CD1 ILE    11      34.674  49.060  -2.462  1.00 30.15           C  
ATOM     74  N   THR    12      29.803  47.462  -0.048  1.00 27.97           N  
ATOM     75  CA  THR    12      28.425  47.681   0.395  1.00 28.47           C  
ATOM     76  C   THR    12      28.179  47.075   1.781  1.00 28.17           C  
ATOM     77  O   THR    12      27.598  47.702   2.663  1.00 28.31           O  
ATOM     78  CB  THR    12      27.470  47.064  -0.648  1.00 28.90           C  
ATOM     79  OG1 THR    12      27.615  47.801  -1.876  1.00 33.88           O  
ATOM     80  CG2 THR    12      26.034  47.099  -0.145  1.00 32.17           C  
ATOM     81  N   ASP    13      28.632  45.841   1.957  1.00 26.82           N  
ATOM     82  CA  ASP    13      28.428  45.156   3.212  1.00 26.86           C  
ATOM     83  C   ASP    13      29.213  45.757   4.386  1.00 27.51           C  
ATOM     84  O   ASP    13      28.688  45.861   5.487  1.00 28.39           O  
ATOM     85  CB  ASP    13      28.782  43.680   3.074  1.00 25.89           C  
ATOM     86  CG  ASP    13      27.709  42.898   2.381  1.00 27.70           C  
ATOM     87  OD1 ASP    13      26.612  43.439   2.053  1.00 27.09           O  
ATOM     88  OD2 ASP    13      27.949  41.684   2.123  1.00 28.54           O  
ATOM     89  N   PHE    14      30.474  46.084   4.146  1.00 27.45           N  
ATOM     90  CA  PHE    14      31.265  46.782   5.153  1.00 28.16           C  
ATOM     91  C   PHE    14      30.615  48.139   5.524  1.00 28.21           C  
ATOM     92  O   PHE    14      30.364  48.439   6.721  1.00 28.31           O  
ATOM     93  CB  PHE    14      32.675  46.986   4.612  1.00 27.51           C  
ATOM     94  CG  PHE    14      33.532  47.847   5.512  1.00 28.17           C  
ATOM     95  CD1 PHE    14      34.274  47.261   6.534  1.00 29.96           C  
ATOM     96  CD2 PHE    14      33.658  49.205   5.273  1.00 29.46           C  
ATOM     97  CE1 PHE    14      35.096  48.048   7.394  1.00 30.68           C  
ATOM     98  CE2 PHE    14      34.457  50.005   6.098  1.00 27.95           C  
ATOM     99  CZ  PHE    14      35.200  49.439   7.140  1.00 28.47           C  
ATOM    100  N   THR    15      30.283  48.943   4.505  1.00 28.84           N  
ATOM    101  CA  THR    15      29.765  50.261   4.814  1.00 29.34           C  
ATOM    102  C   THR    15      28.397  50.255   5.490  1.00 29.68           C  
ATOM    103  O   THR    15      28.132  51.096   6.351  1.00 29.38           O  
ATOM    104  CB  THR    15      29.749  51.174   3.578  1.00 29.94           C  
ATOM    105  OG1 THR    15      28.857  50.635   2.583  1.00 32.54           O  
ATOM    106  CG2 THR    15      31.148  51.322   3.003  1.00 29.85           C  
ATOM    107  N   LYS    16      27.525  49.312   5.117  1.00 28.55           N  
ATOM    108  CA  LYS    16      26.176  49.306   5.689  1.00 30.01           C  
ATOM    109  C   LYS    16      26.248  49.189   7.225  1.00 29.93           C  
ATOM    110  O   LYS    16      25.403  49.712   7.929  1.00 29.63           O  
ATOM    111  CB  LYS    16      25.313  48.190   5.082  1.00 30.44           C  
ATOM    112  CG  LYS    16      25.663  46.803   5.574  1.00 35.20           C  
ATOM    113  CD  LYS    16      25.015  45.723   4.761  1.00 39.23           C  
ATOM    114  CE  LYS    16      25.507  44.375   5.271  1.00 39.43           C  
ATOM    115  NZ  LYS    16      24.716  43.343   4.422  1.00 40.41           N  
ATOM    116  N   GLU    17      27.274  48.508   7.735  1.00 28.62           N  
ATOM    117  CA  GLU    17      27.337  48.200   9.166  1.00 29.00           C  
ATOM    118  C   GLU    17      27.886  49.381   9.953  1.00 28.85           C  
ATOM    119  O   GLU    17      27.931  49.337  11.194  1.00 29.26           O  
ATOM    120  CB  GLU    17      28.186  46.954   9.390  1.00 29.41           C  
ATOM    121  CG  GLU    17      27.555  45.719   8.717  1.00 28.74           C  
ATOM    122  CD  GLU    17      27.869  44.402   9.414  1.00 30.24           C  
ATOM    123  OE1 GLU    17      28.772  44.329  10.248  1.00 29.26           O  
ATOM    124  OE2 GLU    17      27.242  43.383   9.026  1.00 29.26           O  
ATOM    125  N   ILE    18      28.312  50.430   9.235  1.00 27.91           N  
ATOM    126  CA  ILE    18      28.758  51.675   9.932  1.00 28.91           C  
ATOM    127  C   ILE    18      27.551  52.408  10.542  1.00 29.56           C  
ATOM    128  O   ILE    18      27.669  53.103  11.575  1.00 30.26           O  
ATOM    129  CB  ILE    18      29.527  52.600   8.995  1.00 27.93           C  
ATOM    130  CG1 ILE    18      30.780  51.889   8.498  1.00 29.55           C  
ATOM    131  CG2 ILE    18      29.953  53.923   9.729  1.00 29.06           C  
ATOM    132  CD1 ILE    18      31.574  52.591   7.399  1.00 29.60           C  
ATOM    133  N   LEU    19      26.407  52.280   9.878  1.00 31.41           N  
ATOM    134  CA  LEU    19      25.173  52.919  10.345  1.00 32.91           C  
ATOM    135  C   LEU    19      24.494  52.079  11.416  1.00 35.65           C  
ATOM    136  O   LEU    19      24.540  50.864  11.366  1.00 35.98           O  
ATOM    137  CB  LEU    19      24.190  53.114   9.185  1.00 32.71           C  
ATOM    138  CG  LEU    19      24.755  54.000   8.070  1.00 31.21           C  
ATOM    139  CD1 LEU    19      23.744  54.168   6.933  1.00 34.69           C  
ATOM    140  CD2 LEU    19      25.163  55.388   8.603  1.00 34.71           C  
ATOM    141  N   VAL    20      23.880  52.736  12.383  1.00 37.78           N  
ATOM    142  CA  VAL    20      22.991  52.053  13.329  1.00 42.64           C  
ATOM    143  C   VAL    20      21.570  52.516  12.940  1.00 45.75           C  
ATOM    144  O   VAL    20      21.182  53.647  13.205  1.00 47.61           O  
ATOM    145  CB  VAL    20      23.402  52.348  14.801  1.00 42.32           C  
ATOM    146  CG1 VAL    20      24.821  51.892  15.026  1.00 42.84           C  
ATOM    147  CG2 VAL    20      23.335  53.817  15.121  1.00 44.10           C  
ATOM    148  N   ASN    21      20.833  51.659  12.249  1.00 49.44           N  
ATOM    149  CA  ASN    21      19.663  52.112  11.475  1.00 51.70           C  
ATOM    150  C   ASN    21      18.342  52.025  12.233  1.00 52.61           C  
ATOM    151  O   ASN    21      17.631  53.027  12.385  1.00 54.40           O  
ATOM    152  CB  ASN    21      19.561  51.341  10.146  1.00 52.55           C  
ATOM    153  CG  ASN    21      20.582  51.814   9.098  1.00 54.02           C  
ATOM    154  OD1 ASN    21      21.369  51.016   8.583  1.00 54.60           O  
ATOM    155  ND2 ASN    21      20.542  53.106   8.755  1.00 55.63           N  
ATOM    156  N   ARG    30      28.631  42.922  -8.409  1.00 38.27           N  
ATOM    157  CA  ARG    30      29.961  43.479  -8.344  1.00 36.19           C  
ATOM    158  C   ARG    30      30.712  42.833  -7.183  1.00 35.23           C  
ATOM    159  O   ARG    30      30.336  43.012  -6.044  1.00 33.66           O  
ATOM    160  CB  ARG    30      29.880  44.997  -8.149  1.00 37.73           C  
ATOM    161  N   GLN    31      31.760  42.078  -7.489  1.00 34.39           N  
ATOM    162  CA  GLN    31      32.645  41.498  -6.466  1.00 34.32           C  
ATOM    163  C   GLN    31      34.013  42.147  -6.514  1.00 34.46           C  
ATOM    164  O   GLN    31      34.534  42.407  -7.594  1.00 34.89           O  
ATOM    165  CB  GLN    31      32.837  39.999  -6.698  1.00 34.19           C  
ATOM    166  CG  GLN    31      31.554  39.170  -6.608  1.00 34.34           C  
ATOM    167  CD  GLN    31      30.984  39.177  -5.190  1.00 32.72           C  
ATOM    168  OE1 GLN    31      31.681  38.823  -4.234  1.00 34.47           O  
ATOM    169  NE2 GLN    31      29.722  39.597  -5.049  1.00 30.84           N  
ATOM    170  N   GLY    32      34.604  42.365  -5.344  1.00 33.71           N  
ATOM    171  CA  GLY    32      35.937  42.919  -5.240  1.00 33.83           C  
ATOM    172  C   GLY    32      36.623  42.526  -3.941  1.00 34.41           C  
ATOM    173  O   GLY    32      36.130  41.652  -3.203  1.00 34.60           O  
ATOM    174  N   ASP    33      37.758  43.167  -3.671  1.00 33.50           N  
ATOM    175  CA  ASP    33      38.566  42.883  -2.480  1.00 34.03           C  
ATOM    176  C   ASP    33      37.811  43.331  -1.232  1.00 33.04           C  
ATOM    177  O   ASP    33      37.116  44.363  -1.244  1.00 32.12           O  
ATOM    178  CB  ASP    33      39.869  43.702  -2.502  1.00 35.14           C  
ATOM    179  CG  ASP    33      40.862  43.228  -3.529  1.00 40.01           C  
ATOM    180  OD1 ASP    33      40.786  42.069  -3.990  1.00 41.81           O  
ATOM    181  OD2 ASP    33      41.752  44.041  -3.848  1.00 45.63           O  
ATOM    182  N   LEU    34      38.003  42.609  -0.131  1.00 32.93           N  
ATOM    183  CA  LEU    34      37.530  43.143   1.157  1.00 31.92           C  
ATOM    184  C   LEU    34      38.221  44.481   1.434  1.00 31.89           C  
ATOM    185  O   LEU    34      39.422  44.616   1.155  1.00 30.87           O  
ATOM    186  CB  LEU    34      37.870  42.206   2.312  1.00 33.15           C  
ATOM    187  CG  LEU    34      37.117  40.880   2.353  1.00 35.07           C  
ATOM    188  CD1 LEU    34      37.693  39.994   3.470  1.00 36.02           C  
ATOM    189  CD2 LEU    34      35.627  41.090   2.512  1.00 38.24           C  
ATOM    190  N   PRO    35      37.469  45.473   1.973  1.00 31.28           N  
ATOM    191  CA  PRO    35      38.162  46.712   2.435  1.00 29.76           C  
ATOM    192  C   PRO    35      39.307  46.371   3.358  1.00 30.65           C  
ATOM    193  O   PRO    35      39.237  45.401   4.124  1.00 29.39           O  
ATOM    194  CB  PRO    35      37.074  47.475   3.188  1.00 30.31           C  
ATOM    195  CG  PRO    35      35.771  47.010   2.483  1.00 30.47           C  
ATOM    196  CD  PRO    35      36.011  45.533   2.184  1.00 30.61           C  
ATOM    197  N   ASN    36      40.400  47.104   3.213  1.00 29.90           N  
ATOM    198  CA  ASN    36      41.563  46.878   4.091  1.00 29.42           C  
ATOM    199  C   ASN    36      41.737  48.025   5.047  1.00 30.11           C  
ATOM    200  O   ASN    36      41.796  49.178   4.634  1.00 30.01           O  
ATOM    201  CB  ASN    36      42.860  46.526   3.327  1.00 30.51           C  
ATOM    202  CG  ASN    36      43.407  47.658   2.480  1.00 31.39           C  
ATOM    203  OD1 ASN    36      44.605  48.000   2.594  1.00 37.37           O  
ATOM    204  ND2 ASN    36      42.586  48.212   1.611  1.00 27.08           N  
ATOM    205  N   VAL    37      41.806  47.679   6.330  1.00 29.75           N  
ATOM    206  CA  VAL    37      41.995  48.669   7.390  1.00 29.27           C  
ATOM    207  C   VAL    37      43.424  48.511   7.918  1.00 29.72           C  
ATOM    208  O   VAL    37      43.891  47.384   8.180  1.00 29.41           O  
ATOM    209  CB  VAL    37      40.973  48.414   8.531  1.00 29.79           C  
ATOM    210  CG1 VAL    37      41.220  49.362   9.719  1.00 31.11           C  
ATOM    211  CG2 VAL    37      39.543  48.585   7.972  1.00 30.87           C  
ATOM    212  N   VAL    38      44.108  49.645   8.076  1.00 28.48           N  
ATOM    213  CA  VAL    38      45.482  49.590   8.609  1.00 30.26           C  
ATOM    214  C   VAL    38      45.566  50.597   9.708  1.00 29.13           C  
ATOM    215  O   VAL    38      45.288  51.773   9.496  1.00 29.96           O  
ATOM    216  CB  VAL    38      46.544  49.872   7.539  1.00 30.19           C  
ATOM    217  CG1 VAL    38      47.934  49.653   8.122  1.00 33.01           C  
ATOM    218  CG2 VAL    38      46.340  48.961   6.342  1.00 32.53           C  
ATOM    219  N   VAL    39      45.956  50.115  10.891  1.00 29.22           N  
ATOM    220  CA  VAL    39      46.112  50.992  12.058  1.00 28.47           C  
ATOM    221  C   VAL    39      47.595  51.207  12.274  1.00 29.64           C  
ATOM    222  O   VAL    39      48.358  50.233  12.336  1.00 31.22           O  
ATOM    223  CB  VAL    39      45.454  50.405  13.311  1.00 29.04           C  
ATOM    224  CG1 VAL    39      45.747  51.285  14.557  1.00 29.29           C  
ATOM    225  CG2 VAL    39      43.929  50.261  13.076  1.00 28.84           C  
ATOM    226  N   THR    40      48.002  52.473  12.347  1.00 28.59           N  
ATOM    227  CA  THR    40      49.419  52.838  12.379  1.00 28.56           C  
ATOM    228  C   THR    40      49.711  53.634  13.647  1.00 28.15           C  
ATOM    229  O   THR    40      48.811  54.244  14.208  1.00 28.16           O  
ATOM    230  CB  THR    40      49.779  53.693  11.156  1.00 28.70           C  
ATOM    231  OG1 THR    40      49.099  54.956  11.211  1.00 28.47           O  
ATOM    232  CG2 THR    40      49.400  52.955   9.831  1.00 29.08           C  
ATOM    233  N   PRO    41      50.963  53.597  14.134  1.00 27.77           N  
ATOM    234  CA  PRO    41      51.258  54.220  15.429  1.00 27.58           C  
ATOM    235  C   PRO    41      51.388  55.715  15.465  1.00 27.91           C  
ATOM    236  O   PRO    41      51.349  56.292  16.554  1.00 28.18           O  
ATOM    237  CB  PRO    41      52.618  53.593  15.822  1.00 27.02           C  
ATOM    238  CG  PRO    41      53.269  53.296  14.432  1.00 27.63           C  
ATOM    239  CD  PRO    41      52.102  52.816  13.615  1.00 27.09           C  
ATOM    240  N   ASN    42      51.625  56.357  14.317  1.00 27.94           N  
ATOM    241  CA  ASN    42      51.838  57.798  14.304  1.00 27.19           C  
ATOM    242  C   ASN    42      51.592  58.326  12.907  1.00 27.47           C  
ATOM    243  O   ASN    42      51.430  57.524  11.951  1.00 27.15           O  
ATOM    244  CB  ASN    42      53.237  58.198  14.813  1.00 27.28           C  
ATOM    245  CG  ASN    42      54.325  57.371  14.159  1.00 27.56           C  
ATOM    246  OD1 ASN    42      54.410  57.339  12.924  1.00 27.47           O  
ATOM    247  ND2 ASN    42      55.122  56.670  14.959  1.00 31.36           N  
ATOM    248  N   PHE    43      51.604  59.662  12.805  1.00 27.24           N  
ATOM    249  CA  PHE    43      51.237  60.333  11.550  1.00 27.35           C  
ATOM    250  C   PHE    43      52.131  59.883  10.377  1.00 27.11           C  
ATOM    251  O   PHE    43      51.598  59.514   9.325  1.00 26.47           O  
ATOM    252  CB  PHE    43      51.329  61.823  11.755  1.00 27.79           C  
ATOM    253  CG  PHE    43      51.070  62.629  10.520  1.00 28.03           C  
ATOM    254  CD1 PHE    43      49.788  62.991  10.183  1.00 30.77           C  
ATOM    255  CD2 PHE    43      52.146  63.030   9.712  1.00 29.40           C  
ATOM    256  CE1 PHE    43      49.553  63.766   9.031  1.00 29.55           C  
ATOM    257  CE2 PHE    43      51.937  63.802   8.571  1.00 32.39           C  
ATOM    258  CZ  PHE    43      50.643  64.141   8.210  1.00 30.77           C  
ATOM    259  N   GLU    44      53.444  59.860  10.601  1.00 27.44           N  
ATOM    260  CA  GLU    44      54.406  59.481   9.552  1.00 27.51           C  
ATOM    261  C   GLU    44      54.211  58.023   9.129  1.00 27.15           C  
ATOM    262  O   GLU    44      54.283  57.702   7.932  1.00 27.38           O  
ATOM    263  CB  GLU    44      55.846  59.775   9.986  1.00 29.65           C  
ATOM    264  CG  GLU    44      56.126  61.280  10.151  1.00 31.96           C  
ATOM    265  CD  GLU    44      55.997  62.122   8.860  1.00 39.55           C  
ATOM    266  OE1 GLU    44      56.223  61.616   7.732  1.00 40.81           O  
ATOM    267  OE2 GLU    44      55.671  63.330   8.981  1.00 41.40           O  
ATOM    268  N   ALA    45      53.900  57.132  10.088  1.00 26.38           N  
ATOM    269  CA  ALA    45      53.584  55.758   9.700  1.00 26.12           C  
ATOM    270  C   ALA    45      52.275  55.654   8.897  1.00 26.37           C  
ATOM    271  O   ALA    45      52.114  54.805   7.986  1.00 26.62           O  
ATOM    272  CB  ALA    45      53.528  54.876  10.911  1.00 25.52           C  
ATOM    273  N   GLY    46      51.304  56.498   9.260  1.00 26.42           N  
ATOM    274  CA  GLY    46      50.068  56.564   8.458  1.00 27.98           C  
ATOM    275  C   GLY    46      50.360  56.980   7.036  1.00 27.21           C  
ATOM    276  O   GLY    46      49.843  56.385   6.095  1.00 26.51           O  
ATOM    277  N   VAL    47      51.206  58.007   6.880  1.00 26.62           N  
ATOM    278  CA  VAL    47      51.563  58.489   5.545  1.00 26.36           C  
ATOM    279  C   VAL    47      52.308  57.365   4.776  1.00 26.49           C  
ATOM    280  O   VAL    47      52.054  57.164   3.591  1.00 27.42           O  
ATOM    281  CB  VAL    47      52.411  59.753   5.665  1.00 27.05           C  
ATOM    282  CG1 VAL    47      52.938  60.174   4.302  1.00 27.03           C  
ATOM    283  CG2 VAL    47      51.564  60.903   6.291  1.00 27.75           C  
ATOM    284  N   ASP    48      53.199  56.621   5.451  1.00 25.79           N  
ATOM    285  CA  ASP    48      53.847  55.462   4.809  1.00 25.78           C  
ATOM    286  C   ASP    48      52.771  54.541   4.187  1.00 26.24           C  
ATOM    287  O   ASP    48      52.913  54.026   3.058  1.00 27.65           O  
ATOM    288  CB  ASP    48      54.583  54.608   5.844  1.00 24.53           C  
ATOM    289  CG  ASP    48      55.889  55.244   6.363  1.00 24.70           C  
ATOM    290  OD1 ASP    48      56.320  56.316   5.863  1.00 26.68           O  
ATOM    291  OD2 ASP    48      56.571  54.582   7.199  1.00 26.76           O  
ATOM    292  N   GLN    49      51.712  54.283   4.958  1.00 26.49           N  
ATOM    293  CA  GLN    49      50.703  53.354   4.448  0.50 27.37           C  
ATOM    295  C   GLN    49      49.949  53.929   3.269  1.00 27.51           C  
ATOM    296  O   GLN    49      49.578  53.183   2.342  1.00 28.34           O  
ATOM    297  CB  GLN    49      49.736  52.872   5.539  0.50 26.94           C  
ATOM    299  CG  GLN    49      48.676  51.900   5.013  0.50 28.63           C  
ATOM    301  CD  GLN    49      49.218  50.647   4.316  0.50 26.90           C  
ATOM    303  OE1 GLN    49      50.290  50.122   4.648  0.50 31.26           O  
ATOM    305  NE2 GLN    49      48.452  50.151   3.342  0.50 28.35           N  
ATOM    307  N   VAL    50      49.695  55.234   3.287  1.00 26.98           N  
ATOM    308  CA  VAL    50      49.056  55.889   2.134  1.00 26.02           C  
ATOM    309  C   VAL    50      49.947  55.745   0.877  1.00 26.05           C  
ATOM    310  O   VAL    50      49.470  55.418  -0.217  1.00 26.38           O  
ATOM    311  CB  VAL    50      48.766  57.361   2.411  1.00 26.97           C  
ATOM    312  CG1 VAL    50      48.238  58.027   1.185  1.00 26.87           C  
ATOM    313  CG2 VAL    50      47.740  57.482   3.572  1.00 28.51           C  
ATOM    314  N   VAL    51      51.237  56.006   1.036  1.00 25.74           N  
ATOM    315  CA  VAL    51      52.181  55.882  -0.096  1.00 27.33           C  
ATOM    316  C   VAL    51      52.147  54.453  -0.669  1.00 27.45           C  
ATOM    317  O   VAL    51      52.049  54.225  -1.896  1.00 27.57           O  
ATOM    318  CB  VAL    51      53.599  56.268   0.366  1.00 27.07           C  
ATOM    319  CG1 VAL    51      54.658  55.859  -0.656  1.00 28.60           C  
ATOM    320  CG2 VAL    51      53.665  57.787   0.576  1.00 30.06           C  
ATOM    321  N   ASP    52      52.184  53.492   0.246  1.00 27.09           N  
ATOM    322  CA  ASP    52      52.201  52.088  -0.093  1.00 28.13           C  
ATOM    323  C   ASP    52      50.894  51.661  -0.786  1.00 28.54           C  
ATOM    324  O   ASP    52      50.927  50.929  -1.808  1.00 30.23           O  
ATOM    325  CB  ASP    52      52.423  51.248   1.140  1.00 28.96           C  
ATOM    326  CG  ASP    52      53.809  51.393   1.703  1.00 29.27           C  
ATOM    327  OD1 ASP    52      54.644  52.104   1.111  1.00 29.90           O  
ATOM    328  OD2 ASP    52      54.067  50.733   2.739  1.00 30.79           O  
ATOM    329  N   GLN    53      49.763  52.122  -0.249  1.00 27.74           N  
ATOM    330  CA  GLN    53      48.472  51.821  -0.868  1.00 28.46           C  
ATOM    331  C   GLN    53      48.329  52.439  -2.262  1.00 28.73           C  
ATOM    332  O   GLN    53      47.787  51.825  -3.177  1.00 29.18           O  
ATOM    333  CB  GLN    53      47.324  52.269   0.036  1.00 28.55           C  
ATOM    334  CG  GLN    53      45.958  51.733  -0.460  1.00 30.01           C  
ATOM    335  CD  GLN    53      45.847  50.239  -0.294  1.00 30.81           C  
ATOM    336  OE1 GLN    53      45.447  49.518  -1.226  1.00 35.57           O  
ATOM    337  NE2 GLN    53      46.235  49.757   0.859  1.00 29.10           N  
ATOM    338  N   LEU    54      48.840  53.655  -2.427  1.00 28.47           N  
ATOM    339  CA  LEU    54      48.777  54.311  -3.732  1.00 29.64           C  
ATOM    340  C   LEU    54      49.571  53.492  -4.746  1.00 29.85           C  
ATOM    341  O   LEU    54      49.123  53.282  -5.869  1.00 30.60           O  
ATOM    342  CB  LEU    54      49.327  55.720  -3.619  1.00 29.22           C  
ATOM    343  CG  LEU    54      48.395  56.732  -2.916  1.00 29.23           C  
ATOM    344  CD1 LEU    54      49.146  58.014  -2.693  1.00 31.77           C  
ATOM    345  CD2 LEU    54      47.125  56.998  -3.747  1.00 31.60           C  
ATOM    346  N   ALA    55      50.724  52.977  -4.322  1.00 30.15           N  
ATOM    347  CA  ALA    55      51.550  52.142  -5.205  1.00 31.94           C  
ATOM    348  C   ALA    55      50.809  50.848  -5.539  1.00 32.39           C  
ATOM    349  O   ALA    55      50.821  50.424  -6.693  1.00 34.20           O  
ATOM    350  CB  ALA    55      52.898  51.857  -4.573  1.00 32.39           C  
ATOM    351  N   MET    56      50.184  50.218  -4.538  1.00 32.54           N  
ATOM    352  CA  MET    56      49.411  48.996  -4.772  0.50 33.61           C  
ATOM    354  C   MET    56      48.268  49.264  -5.740  1.00 33.55           C  
ATOM    355  O   MET    56      48.110  48.545  -6.724  1.00 34.34           O  
ATOM    356  CB  MET    56      48.847  48.435  -3.481  0.50 34.02           C  
ATOM    358  CG  MET    56      47.933  47.239  -3.680  0.50 37.03           C  
ATOM    360  SD  MET    56      48.898  45.682  -4.358  0.30 42.24          SE  
ATOM    362  CE  MET    56      50.299  45.629  -2.993  0.50 41.17           C  
ATOM    364  N   ASN    57      47.471  50.295  -5.467  1.00 33.02           N  
ATOM    365  CA  ASN    57      46.339  50.645  -6.323  1.00 33.09           C  
ATOM    366  C   ASN    57      46.790  50.953  -7.750  1.00 33.98           C  
ATOM    367  O   ASN    57      46.195  50.450  -8.708  1.00 33.63           O  
ATOM    368  CB  ASN    57      45.551  51.825  -5.727  1.00 32.63           C  
ATOM    369  CG  ASN    57      44.821  51.452  -4.465  1.00 33.26           C  
ATOM    370  OD1 ASN    57      44.902  50.298  -3.988  1.00 30.93           O  
ATOM    371  ND2 ASN    57      44.118  52.432  -3.892  1.00 31.01           N  
ATOM    372  N   ASP    58      47.863  51.738  -7.883  1.00 34.28           N  
ATOM    373  CA  ASP    58      48.454  52.041  -9.203  1.00 35.30           C  
ATOM    374  C   ASP    58      48.793  50.769  -9.964  1.00 34.62           C  
ATOM    375  O   ASP    58      48.591  50.687 -11.167  1.00 35.23           O  
ATOM    376  CB  ASP    58      49.748  52.827  -9.018  1.00 35.27           C  
ATOM    377  CG  ASP    58      49.523  54.274  -8.664  1.00 37.33           C  
ATOM    378  OD1 ASP    58      48.366  54.725  -8.612  1.00 39.12           O  
ATOM    379  OD2 ASP    58      50.537  54.974  -8.431  1.00 39.24           O  
ATOM    380  N   SER    59      49.325  49.786  -9.254  1.00 35.56           N  
ATOM    381  CA  SER    59      49.777  48.535  -9.865  1.00 36.38           C  
ATOM    382  C   SER    59      48.609  47.694 -10.405  1.00 37.32           C  
ATOM    383  O   SER    59      48.782  46.841 -11.316  1.00 37.69           O  
ATOM    384  CB  SER    59      50.634  47.750  -8.873  1.00 35.69           C  
ATOM    385  OG  SER    59      49.847  46.914  -8.054  1.00 38.55           O  
ATOM    386  N   GLU    60      47.418  47.954  -9.866  1.00 38.51           N  
ATOM    387  CA  GLU    60      46.200  47.263 -10.277  1.00 39.77           C  
ATOM    388  C   GLU    60      45.401  48.137 -11.230  1.00 39.46           C  
ATOM    389  O   GLU    60      44.288  47.783 -11.629  1.00 39.61           O  
ATOM    390  CB  GLU    60      45.384  46.856  -9.056  1.00 40.93           C  
ATOM    391  CG  GLU    60      46.224  46.004  -8.113  1.00 45.64           C  
ATOM    392  CD  GLU    60      45.413  44.950  -7.404  1.00 51.91           C  
ATOM    393  OE1 GLU    60      45.846  43.768  -7.405  1.00 55.04           O  
ATOM    394  OE2 GLU    60      44.343  45.303  -6.855  1.00 54.05           O  
ATOM    395  N   ARG    61      45.993  49.277 -11.582  1.00 38.55           N  
ATOM    396  CA  ARG    61      45.437  50.230 -12.542  1.00 39.08           C  
ATOM    397  C   ARG    61      44.173  50.893 -12.022  1.00 38.15           C  
ATOM    398  O   ARG    61      43.265  51.222 -12.798  1.00 37.67           O  
ATOM    399  CB  ARG    61      45.202  49.575 -13.918  1.00 39.17           C  
ATOM    400  CG  ARG    61      46.422  48.869 -14.503  1.00 41.21           C  
ATOM    401  CD  ARG    61      46.069  48.231 -15.830  1.00 42.58           C  
ATOM    402  NE  ARG    61      45.291  47.004 -15.631  1.00 50.43           N  
ATOM    403  CZ  ARG    61      45.696  45.783 -15.979  1.00 53.04           C  
ATOM    404  NH1 ARG    61      46.871  45.603 -16.577  1.00 54.54           N  
ATOM    405  NH2 ARG    61      44.911  44.737 -15.749  1.00 55.26           N  
ATOM    406  N   ASP    62      44.128  51.105 -10.703  1.00 36.66           N  
ATOM    407  CA  ASP    62      43.036  51.843 -10.068  1.00 37.27           C  
ATOM    408  C   ASP    62      43.297  53.326 -10.190  1.00 37.10           C  
ATOM    409  O   ASP    62      44.456  53.752 -10.343  1.00 37.72           O  
ATOM    410  CB  ASP    62      42.954  51.530  -8.569  1.00 37.09           C  
ATOM    411  CG  ASP    62      42.603  50.092  -8.290  1.00 40.27           C  
ATOM    412  OD1 ASP    62      42.017  49.422  -9.187  1.00 41.38           O  
ATOM    413  OD2 ASP    62      42.938  49.653  -7.164  1.00 41.17           O  
ATOM    414  N   THR    63      42.219  54.102 -10.108  1.00 36.34           N  
ATOM    415  CA  THR    63      42.319  55.537  -9.903  1.00 36.30           C  
ATOM    416  C   THR    63      41.829  55.802  -8.483  1.00 34.94           C  
ATOM    417  O   THR    63      40.671  55.509  -8.167  1.00 33.31           O  
ATOM    418  CB  THR    63      41.420  56.287 -10.857  1.00 37.09           C  
ATOM    419  OG1 THR    63      41.810  55.987 -12.211  1.00 39.88           O  
ATOM    420  CG2 THR    63      41.540  57.794 -10.609  1.00 37.84           C  
ATOM    421  N   THR    64      42.727  56.335  -7.660  1.00 34.99           N  
ATOM    422  CA  THR    64      42.480  56.544  -6.241  1.00 34.95           C  
ATOM    423  C   THR    64      42.203  58.002  -5.830  1.00 35.03           C  
ATOM    424  O   THR    64      42.932  58.918  -6.276  1.00 37.22           O  
ATOM    425  CB  THR    64      43.678  55.999  -5.423  1.00 35.38           C  
ATOM    426  OG1 THR    64      43.989  54.644  -5.852  1.00 35.96           O  
ATOM    427  CG2 THR    64      43.373  56.075  -3.945  1.00 35.82           C  
ATOM    428  N   ALA    65      41.186  58.214  -4.982  1.00 31.08           N  
ATOM    429  CA  ALA    65      41.024  59.479  -4.229  1.00 30.74           C  
ATOM    430  C   ALA    65      41.271  59.248  -2.761  1.00 30.11           C  
ATOM    431  O   ALA    65      40.850  58.226  -2.225  1.00 29.59           O  
ATOM    432  CB  ALA    65      39.662  60.052  -4.411  1.00 31.71           C  
ATOM    433  N   ILE    66      41.970  60.171  -2.111  1.00 28.15           N  
ATOM    434  CA  ILE    66      42.123  60.116  -0.668  1.00 28.59           C  
ATOM    435  C   ILE    66      41.144  61.115  -0.068  1.00 29.00           C  
ATOM    436  O   ILE    66      41.135  62.296  -0.471  1.00 30.18           O  
ATOM    437  CB  ILE    66      43.507  60.566  -0.253  1.00 29.08           C  
ATOM    438  CG1 ILE    66      44.551  59.702  -0.970  1.00 28.82           C  
ATOM    439  CG2 ILE    66      43.599  60.519   1.280  1.00 30.11           C  
ATOM    440  CD1 ILE    66      46.013  60.216  -0.743  1.00 29.84           C  
ATOM    441  N   ILE    67      40.259  60.623   0.799  1.00 26.98           N  
ATOM    442  CA  ILE    67      39.259  61.520   1.442  1.00 28.66           C  
ATOM    443  C   ILE    67      39.623  61.761   2.897  1.00 29.81           C  
ATOM    444  O   ILE    67      39.721  60.793   3.685  1.00 29.66           O  
ATOM    445  CB  ILE    67      37.821  60.945   1.353  1.00 28.87           C  
ATOM    446  CG1 ILE    67      37.522  60.604  -0.109  1.00 29.34           C  
ATOM    447  CG2 ILE    67      36.826  61.958   1.933  1.00 28.41           C  
ATOM    448  CD1 ILE    67      36.114  59.998  -0.401  1.00 30.51           C  
ATOM    449  N   GLY    68      39.871  63.018   3.235  1.00 30.76           N  
ATOM    450  CA  GLY    68      40.165  63.434   4.644  1.00 30.11           C  
ATOM    451  C   GLY    68      38.901  64.111   5.201  1.00 29.17           C  
ATOM    452  O   GLY    68      38.054  64.565   4.457  1.00 29.97           O  
ATOM    453  N   LYS    69      38.781  64.183   6.506  1.00 28.07           N  
ATOM    454  CA  LYS    69      37.545  64.686   7.103  1.00 28.47           C  
ATOM    455  C   LYS    69      37.389  66.168   6.861  1.00 28.85           C  
ATOM    456  O   LYS    69      36.279  66.624   6.531  1.00 28.08           O  
ATOM    457  CB  LYS    69      37.519  64.393   8.599  1.00 28.96           C  
ATOM    458  CG  LYS    69      36.231  64.880   9.264  1.00 28.51           C  
ATOM    459  CD  LYS    69      36.137  64.465  10.765  1.00 30.08           C  
ATOM    460  CE  LYS    69      37.246  65.079  11.588  1.00 27.70           C  
ATOM    461  NZ  LYS    69      37.003  64.832  13.077  1.00 30.16           N  
ATOM    462  N   SER    70      38.465  66.915   7.138  1.00 28.47           N  
ATOM    463  CA  SER    70      38.389  68.356   7.147  1.00 27.07           C  
ATOM    464  C   SER    70      39.465  68.937   6.265  1.00 27.33           C  
ATOM    465  O   SER    70      40.459  68.255   5.954  1.00 26.51           O  
ATOM    466  CB  SER    70      38.640  68.867   8.588  1.00 28.55           C  
ATOM    467  OG  SER    70      39.998  68.595   8.959  1.00 28.42           O  
ATOM    468  N   LEU    71      39.326  70.226   5.911  1.00 26.80           N  
ATOM    469  CA  LEU    71      40.403  70.858   5.146  1.00 27.00           C  
ATOM    470  C   LEU    71      41.748  70.794   5.885  1.00 27.95           C  
ATOM    471  O   LEU    71      42.767  70.543   5.261  1.00 27.17           O  
ATOM    472  CB  LEU    71      40.066  72.302   4.779  1.00 27.53           C  
ATOM    473  CG  LEU    71      41.166  73.006   4.002  1.00 28.95           C  
ATOM    474  CD1 LEU    71      41.364  72.320   2.629  1.00 32.67           C  
ATOM    475  CD2 LEU    71      40.833  74.470   3.851  1.00 31.11           C  
ATOM    476  N   ALA    72      41.761  71.079   7.186  1.00 27.78           N  
ATOM    477  CA  ALA    72      43.039  71.185   7.928  1.00 29.00           C  
ATOM    478  C   ALA    72      43.765  69.822   7.839  1.00 28.10           C  
ATOM    479  O   ALA    72      44.996  69.741   7.610  1.00 28.44           O  
ATOM    480  CB  ALA    72      42.768  71.530   9.369  1.00 29.70           C  
ATOM    481  N   GLU    73      43.018  68.738   8.018  1.00 27.94           N  
ATOM    482  CA  GLU    73      43.625  67.383   7.974  1.00 28.74           C  
ATOM    483  C   GLU    73      44.118  67.054   6.568  1.00 28.31           C  
ATOM    484  O   GLU    73      45.191  66.495   6.400  1.00 28.75           O  
ATOM    485  CB  GLU    73      42.649  66.350   8.510  1.00 30.42           C  
ATOM    486  CG  GLU    73      42.457  66.644   9.985  1.00 28.49           C  
ATOM    487  CD  GLU    73      41.533  65.666  10.701  1.00 31.05           C  
ATOM    488  OE1 GLU    73      40.946  64.791  10.020  1.00 32.95           O  
ATOM    489  OE2 GLU    73      41.452  65.793  11.975  1.00 29.84           O  
ATOM    490  N   CYS    74      43.335  67.437   5.566  1.00 27.48           N  
ATOM    491  CA  CYS    74      43.777  67.308   4.164  1.00 27.34           C  
ATOM    492  C   CYS    74      45.017  68.094   3.841  1.00 27.85           C  
ATOM    493  O   CYS    74      45.876  67.582   3.112  1.00 28.07           O  
ATOM    494  CB  CYS    74      42.647  67.721   3.202  1.00 27.57           C  
ATOM    495  SG  CYS    74      41.274  66.520   3.187  1.00 29.32           S  
ATOM    496  N   GLU    75      45.128  69.318   4.375  1.00 27.03           N  
ATOM    497  CA  GLU    75      46.336  70.127   4.153  1.00 27.31           C  
ATOM    498  C   GLU    75      47.556  69.432   4.765  1.00 27.58           C  
ATOM    499  O   GLU    75      48.617  69.404   4.149  1.00 28.49           O  
ATOM    500  CB  GLU    75      46.129  71.510   4.782  1.00 27.63           C  
ATOM    501  CG  GLU    75      45.247  72.324   3.904  1.00 28.64           C  
ATOM    502  CD  GLU    75      44.812  73.622   4.531  1.00 34.42           C  
ATOM    503  OE1 GLU    75      44.866  73.732   5.774  1.00 39.41           O  
ATOM    504  OE2 GLU    75      44.409  74.533   3.764  1.00 35.89           O  
ATOM    505  N   ALA    76      47.405  68.908   5.987  1.00 28.61           N  
ATOM    506  CA  ALA    76      48.549  68.267   6.683  1.00 28.88           C  
ATOM    507  C   ALA    76      48.988  67.031   5.878  1.00 28.54           C  
ATOM    508  O   ALA    76      50.180  66.800   5.694  1.00 29.25           O  
ATOM    509  CB  ALA    76      48.155  67.863   8.073  1.00 28.69           C  
ATOM    510  N   LEU    77      48.021  66.259   5.378  1.00 27.87           N  
ATOM    511  CA  LEU    77      48.358  65.036   4.619  1.00 28.14           C  
ATOM    512  C   LEU    77      49.025  65.416   3.318  1.00 28.04           C  
ATOM    513  O   LEU    77      49.987  64.768   2.895  1.00 28.24           O  
ATOM    514  CB  LEU    77      47.109  64.187   4.366  1.00 28.00           C  
ATOM    515  CG  LEU    77      47.404  62.956   3.509  1.00 28.70           C  
ATOM    516  CD1 LEU    77      48.416  62.036   4.219  1.00 29.72           C  
ATOM    517  CD2 LEU    77      46.125  62.206   3.121  1.00 29.70           C  
ATOM    518  N   THR    78      48.475  66.436   2.662  1.00 26.40           N  
ATOM    519  CA  THR    78      48.997  66.892   1.367  1.00 26.92           C  
ATOM    520  C   THR    78      50.460  67.305   1.500  1.00 27.08           C  
ATOM    521  O   THR    78      51.296  66.883   0.683  1.00 27.94           O  
ATOM    522  CB  THR    78      48.106  68.012   0.793  1.00 28.12           C  
ATOM    523  OG1 THR    78      46.818  67.470   0.499  1.00 28.53           O  
ATOM    524  CG2 THR    78      48.765  68.595  -0.487  1.00 29.17           C  
ATOM    525  N   LYS    79      50.765  68.138   2.490  1.00 27.45           N  
ATOM    526  CA  LYS    79      52.153  68.591   2.696  1.00 27.58           C  
ATOM    527  C   LYS    79      53.048  67.355   2.873  1.00 27.42           C  
ATOM    528  O   LYS    79      54.126  67.267   2.288  1.00 27.52           O  
ATOM    529  CB  LYS    79      52.218  69.479   3.934  1.00 28.34           C  
ATOM    530  CG  LYS    79      53.641  69.889   4.271  1.00 30.40           C  
ATOM    531  CD  LYS    79      53.689  70.745   5.532  1.00 35.68           C  
ATOM    532  CE  LYS    79      55.138  70.958   5.966  1.00 38.78           C  
ATOM    533  NZ  LYS    79      55.277  71.779   7.213  1.00 44.07           N  
ATOM    534  N   ALA    80      52.593  66.394   3.684  1.00 27.03           N  
ATOM    535  CA  ALA    80      53.404  65.200   3.964  1.00 27.35           C  
ATOM    536  C   ALA    80      53.593  64.368   2.683  1.00 27.20           C  
ATOM    537  O   ALA    80      54.704  63.923   2.383  1.00 28.05           O  
ATOM    538  CB  ALA    80      52.760  64.368   5.027  1.00 28.54           C  
ATOM    539  N   LEU    81      52.529  64.205   1.890  1.00 26.54           N  
ATOM    540  CA  LEU    81      52.650  63.368   0.709  1.00 26.16           C  
ATOM    541  C   LEU    81      53.572  64.012  -0.328  1.00 25.00           C  
ATOM    542  O   LEU    81      54.352  63.330  -1.016  1.00 25.39           O  
ATOM    543  CB  LEU    81      51.286  63.123   0.098  1.00 27.15           C  
ATOM    544  CG  LEU    81      50.421  62.120   0.875  1.00 27.18           C  
ATOM    545  CD1 LEU    81      49.041  62.169   0.185  1.00 31.18           C  
ATOM    546  CD2 LEU    81      51.010  60.685   0.829  1.00 29.51           C  
ATOM    547  N   LYS    82      53.519  65.337  -0.438  1.00 25.13           N  
ATOM    548  CA  LYS    82      54.449  66.004  -1.385  1.00 25.34           C  
ATOM    549  C   LYS    82      55.895  65.767  -0.958  1.00 25.02           C  
ATOM    550  O   LYS    82      56.770  65.583  -1.790  1.00 24.32           O  
ATOM    551  CB  LYS    82      54.142  67.500  -1.481  1.00 26.60           C  
ATOM    552  CG  LYS    82      52.834  67.754  -2.242  1.00 27.13           C  
ATOM    553  CD  LYS    82      52.646  69.258  -2.456  1.00 30.01           C  
ATOM    554  CE  LYS    82      51.334  69.599  -3.193  1.00 29.78           C  
ATOM    555  NZ  LYS    82      51.127  71.119  -3.299  1.00 31.49           N  
ATOM    556  N   ALA    83      56.130  65.754   0.354  1.00 25.32           N  
ATOM    557  CA  ALA    83      57.458  65.447   0.897  1.00 24.90           C  
ATOM    558  C   ALA    83      57.822  63.961   0.766  1.00 25.68           C  
ATOM    559  O   ALA    83      58.962  63.573   1.075  1.00 27.05           O  
ATOM    560  CB  ALA    83      57.529  65.939   2.387  1.00 26.26           C  
ATOM    561  N   ARG    84      56.902  63.143   0.248  1.00 24.58           N  
ATOM    562  CA  ARG    84      57.244  61.758  -0.120  1.00 25.75           C  
ATOM    563  C   ARG    84      57.421  61.600  -1.611  1.00 26.80           C  
ATOM    564  O   ARG    84      57.561  60.459  -2.112  1.00 26.43           O  
ATOM    565  CB  ARG    84      56.161  60.750   0.333  1.00 26.26           C  
ATOM    566  CG  ARG    84      55.900  60.770   1.825  1.00 27.34           C  
ATOM    567  CD  ARG    84      57.175  60.739   2.708  1.00 27.09           C  
ATOM    568  NE  ARG    84      56.728  60.594   4.115  1.00 29.94           N  
ATOM    569  CZ  ARG    84      56.324  59.443   4.675  1.00 29.04           C  
ATOM    570  NH1 ARG    84      56.337  58.294   3.968  1.00 28.29           N  
ATOM    571  NH2 ARG    84      55.905  59.470   5.961  1.00 28.58           N  
ATOM    572  N   GLY    85      57.453  62.722  -2.338  1.00 26.01           N  
ATOM    573  CA  GLY    85      57.649  62.721  -3.778  1.00 26.32           C  
ATOM    574  C   GLY    85      56.388  62.447  -4.580  1.00 25.64           C  
ATOM    575  O   GLY    85      56.494  62.211  -5.795  1.00 27.54           O  
ATOM    576  N   GLU    86      55.219  62.492  -3.926  1.00 25.38           N  
ATOM    577  CA  GLU    86      53.953  62.218  -4.640  1.00 26.80           C  
ATOM    578  C   GLU    86      53.550  63.469  -5.398  1.00 27.66           C  
ATOM    579  O   GLU    86      53.785  64.602  -4.924  1.00 27.88           O  
ATOM    580  CB  GLU    86      52.830  61.881  -3.664  1.00 28.13           C  
ATOM    581  CG  GLU    86      53.088  60.622  -2.829  1.00 29.16           C  
ATOM    582  CD  GLU    86      52.892  59.285  -3.567  1.00 32.81           C  
ATOM    583  OE1 GLU    86      52.563  59.245  -4.777  1.00 34.54           O  
ATOM    584  OE2 GLU    86      53.046  58.239  -2.887  1.00 35.12           O  
ATOM    585  N   GLN    87      52.854  63.271  -6.521  1.00 27.44           N  
ATOM    586  CA  GLN    87      52.167  64.387  -7.189  1.00 28.90           C  
ATOM    587  C   GLN    87      50.820  64.480  -6.507  1.00 28.15           C  
ATOM    588  O   GLN    87      50.090  63.495  -6.505  1.00 30.27           O  
ATOM    589  CB  GLN    87      51.953  64.071  -8.678  1.00 29.60           C  
ATOM    590  CG  GLN    87      51.520  65.262  -9.512  1.00 32.69           C  
ATOM    591  CD  GLN    87      51.463  64.927 -11.015  1.00 30.87           C  
ATOM    592  OE1 GLN    87      51.238  63.777 -11.407  1.00 37.50           O  
ATOM    593  NE2 GLN    87      51.682  65.931 -11.840  1.00 37.57           N  
ATOM    594  N   VAL    88      50.536  65.607  -5.875  1.00 27.67           N  
ATOM    595  CA  VAL    88      49.300  65.734  -5.051  1.00 28.62           C  
ATOM    596  C   VAL    88      48.496  66.951  -5.469  1.00 29.30           C  
ATOM    597  O   VAL    88      49.050  68.060  -5.716  1.00 30.06           O  
ATOM    598  CB  VAL    88      49.611  65.868  -3.570  1.00 28.48           C  
ATOM    599  CG1 VAL    88      48.283  65.706  -2.735  1.00 28.49           C  
ATOM    600  CG2 VAL    88      50.613  64.807  -3.182  1.00 30.48           C  
ATOM    601  N   THR    89      47.182  66.732  -5.570  1.00 29.17           N  
ATOM    602  CA  THR    89      46.247  67.819  -5.835  1.00 29.50           C  
ATOM    603  C   THR    89      45.237  67.832  -4.692  1.00 29.61           C  
ATOM    604  O   THR    89      44.413  66.916  -4.574  1.00 29.82           O  
ATOM    605  CB  THR    89      45.534  67.606  -7.165  1.00 28.72           C  
ATOM    606  OG1 THR    89      46.500  67.667  -8.216  1.00 30.09           O  
ATOM    607  CG2 THR    89      44.465  68.687  -7.389  1.00 31.74           C  
ATOM    608  N   LEU    90      45.320  68.865  -3.856  1.00 29.77           N  
ATOM    609  CA  LEU    90      44.353  69.036  -2.791  1.00 31.46           C  
ATOM    610  C   LEU    90      43.207  69.794  -3.435  1.00 32.63           C  
ATOM    611  O   LEU    90      43.341  70.994  -3.791  1.00 31.86           O  
ATOM    612  CB  LEU    90      44.982  69.760  -1.603  1.00 31.54           C  
ATOM    613  CG  LEU    90      44.029  70.218  -0.494  1.00 35.17           C  
ATOM    614  CD1 LEU    90      43.212  69.072  -0.104  1.00 34.70           C  
ATOM    615  CD2 LEU    90      44.798  70.762   0.677  1.00 39.40           C  
ATOM    616  N   ILE    91      42.126  69.041  -3.695  1.00 35.09           N  
ATOM    617  CA  ILE    91      41.048  69.522  -4.597  1.00 37.92           C  
ATOM    618  C   ILE    91      40.224  70.575  -3.932  1.00 38.76           C  
ATOM    619  O   ILE    91      40.005  70.545  -2.714  1.00 39.84           O  
ATOM    620  CB  ILE    91      40.136  68.401  -5.252  1.00 36.99           C  
ATOM    621  CG1 ILE    91      39.179  67.756  -4.240  1.00 38.56           C  
ATOM    622  CG2 ILE    91      40.993  67.385  -6.066  1.00 39.13           C  
ATOM    623  CD1 ILE    91      37.908  67.161  -4.869  1.00 39.08           C  
ATOM    624  N   GLN    92      39.814  71.560  -4.759  1.00 39.65           N  
ATOM    625  CA  GLN    92      38.996  72.700  -4.293  1.00 41.73           C  
ATOM    626  C   GLN    92      37.625  72.701  -4.984  1.00 41.64           C  
ATOM    627  O   GLN    92      36.716  73.463  -4.610  1.00 41.15           O  
ATOM    628  CB  GLN    92      39.696  74.036  -4.584  1.00 41.30           C  
ATOM    629  CG  GLN    92      41.173  74.136  -4.142  1.00 43.70           C  
ATOM    630  CD  GLN    92      41.659  75.576  -3.995  1.00 45.01           C  
ATOM    631  OE1 GLN    92      40.874  76.522  -4.102  1.00 50.13           O  
ATOM    632  NE2 GLN    92      42.963  75.746  -3.760  1.00 49.34           N  
ATOM    633  N   THR    93      37.495  71.847  -6.001  1.00 41.02           N  
ATOM    634  CA  THR    93      36.235  71.706  -6.726  1.00 41.21           C  
ATOM    635  C   THR    93      36.198  70.306  -7.348  1.00 41.43           C  
ATOM    636  O   THR    93      37.243  69.717  -7.562  1.00 41.08           O  
ATOM    637  CB  THR    93      36.081  72.872  -7.739  1.00 41.87           C  
ATOM    638  OG1 THR    93      34.698  73.021  -8.067  1.00 42.32           O  
ATOM    639  CG2 THR    93      36.967  72.673  -9.008  1.00 39.94           C  
ATOM    640  N   GLU    94      35.016  69.763  -7.618  1.00 41.55           N  
ATOM    641  CA  GLU    94      34.920  68.351  -8.033  1.00 42.69           C  
ATOM    642  C   GLU    94      35.704  68.047  -9.327  1.00 41.56           C  
ATOM    643  O   GLU    94      36.366  67.009  -9.492  1.00 39.70           O  
ATOM    644  CB  GLU    94      33.436  67.905  -8.097  1.00 42.20           C  
ATOM    645  CG  GLU    94      32.718  68.121  -9.423  1.00 45.46           C  
ATOM    646  CD  GLU    94      31.197  67.883  -9.363  1.00 46.48           C  
ATOM    647  OE1 GLU    94      30.700  67.249  -8.391  1.00 52.48           O  
ATOM    648  OE2 GLU    94      30.503  68.344 -10.305  1.00 52.70           O  
ATOM    649  N   ASN    95      35.687  69.015 -10.226  1.00 41.54           N  
ATOM    650  CA  ASN    95      35.911  68.711 -11.604  1.00 42.22           C  
ATOM    651  C   ASN    95      36.463  67.404 -12.229  1.00 42.37           C  
ATOM    652  O   ASN    95      35.922  67.008 -13.297  1.00 43.92           O  
ATOM    653  CB  ASN    95      36.093  69.932 -12.465  1.00 41.45           C  
ATOM    654  CG  ASN    95      34.878  70.144 -13.245  1.00 42.54           C  
ATOM    655  OD1 ASN    95      34.061  69.213 -13.312  1.00 41.36           O  
ATOM    656  ND2 ASN    95      34.681  71.328 -13.789  1.00 39.43           N  
ATOM    657  N   ARG    97      42.194  70.775 -10.029  1.00 60.54           N  
ATOM    658  CA  ARG    97      42.851  71.801 -10.821  1.00 60.25           C  
ATOM    659  C   ARG    97      43.989  71.242 -11.668  1.00 59.19           C  
ATOM    660  O   ARG    97      43.951  71.332 -12.901  1.00 59.41           O  
ATOM    661  CB  ARG    97      43.353  72.949  -9.937  1.00 60.79           C  
ATOM    662  CG  ARG    97      44.048  74.064 -10.699  1.00 61.49           C  
ATOM    663  CD  ARG    97      44.684  75.092  -9.769  1.00 62.15           C  
ATOM    664  NE  ARG    97      43.939  76.352  -9.562  1.00 65.46           N  
ATOM    665  CZ  ARG    97      42.628  76.568  -9.730  1.00 65.77           C  
ATOM    666  NH1 ARG    97      42.150  77.776  -9.479  1.00 66.41           N  
ATOM    667  NH2 ARG    97      41.787  75.618 -10.130  1.00 65.58           N  
ATOM    668  N   LEU    98      45.010  70.698 -11.006  1.00 57.47           N  
ATOM    669  CA  LEU    98      46.197  70.173 -11.700  1.00 56.22           C  
ATOM    670  C   LEU    98      46.402  68.683 -11.424  1.00 54.72           C  
ATOM    671  O   LEU    98      45.696  68.093 -10.605  1.00 53.68           O  
ATOM    672  CB  LEU    98      47.460  70.947 -11.269  1.00 56.46           C  
ATOM    673  CG  LEU    98      48.105  72.001 -12.186  1.00 57.16           C  
ATOM    674  CD1 LEU    98      47.300  73.291 -12.243  1.00 57.93           C  
ATOM    675  CD2 LEU    98      49.557  72.301 -11.753  1.00 56.98           C  
ATOM    676  N   ALA    99      47.326  68.077 -12.171  1.00 53.45           N  
ATOM    677  CA  ALA    99      48.113  66.924 -11.701  1.00 52.70           C  
ATOM    678  C   ALA    99      47.467  65.547 -11.564  1.00 52.71           C  
ATOM    679  O   ALA    99      47.696  64.880 -10.552  1.00 50.85           O  
ATOM    680  CB  ALA    99      48.788  67.278 -10.388  1.00 51.46           C  
ATOM    681  N   PRO   100      46.670  65.096 -12.563  1.00 52.51           N  
ATOM    682  CA  PRO   100      46.154  63.719 -12.488  1.00 51.81           C  
ATOM    683  C   PRO   100      47.205  62.680 -12.140  1.00 51.49           C  
ATOM    684  O   PRO   100      47.746  61.974 -13.017  1.00 52.58           O  
ATOM    685  CB  PRO   100      45.527  63.524 -13.848  1.00 52.97           C  
ATOM    686  CG  PRO   100      44.959  64.871 -14.080  1.00 52.75           C  
ATOM    687  CD  PRO   100      46.113  65.773 -13.736  1.00 52.76           C  
ATOM    688  N   GLY   101      47.509  62.707 -10.839  1.00 49.07           N  
ATOM    689  CA  GLY   101      48.253  61.751 -10.019  1.00 45.84           C  
ATOM    690  C   GLY   101      47.361  61.558  -8.788  1.00 44.10           C  
ATOM    691  O   GLY   101      46.368  60.854  -8.896  1.00 43.43           O  
ATOM    692  N   VAL   102      47.637  62.238  -7.657  1.00 41.33           N  
ATOM    693  CA  VAL   102      46.896  61.931  -6.401  1.00 39.68           C  
ATOM    694  C   VAL   102      45.888  63.025  -5.997  1.00 37.04           C  
ATOM    695  O   VAL   102      46.289  64.153  -5.726  1.00 37.50           O  
ATOM    696  CB  VAL   102      47.903  61.690  -5.234  1.00 39.87           C  
ATOM    697  CG1 VAL   102      47.215  61.268  -3.961  1.00 41.23           C  
ATOM    698  CG2 VAL   102      48.962  60.654  -5.625  1.00 41.49           C  
ATOM    699  N   ILE   103      44.594  62.702  -5.883  1.00 34.73           N  
ATOM    700  CA  ILE   103      43.642  63.720  -5.403  1.00 33.48           C  
ATOM    701  C   ILE   103      43.409  63.513  -3.911  1.00 31.01           C  
ATOM    702  O   ILE   103      43.212  62.379  -3.464  1.00 29.83           O  
ATOM    703  CB  ILE   103      42.234  63.777  -6.126  1.00 34.62           C  
ATOM    704  CG1 ILE   103      41.514  62.461  -6.037  1.00 39.25           C  
ATOM    705  CG2 ILE   103      42.353  64.299  -7.569  1.00 37.60           C  
ATOM    706  CD1 ILE   103      40.177  62.472  -6.736  1.00 38.21           C  
ATOM    707  N   VAL   104      43.457  64.620  -3.170  1.00 29.13           N  
ATOM    708  CA  VAL   104      43.111  64.648  -1.755  1.00 29.30           C  
ATOM    709  C   VAL   104      41.862  65.531  -1.662  1.00 29.64           C  
ATOM    710  O   VAL   104      41.893  66.709  -2.108  1.00 30.16           O  
ATOM    711  CB  VAL   104      44.287  65.234  -0.887  1.00 28.97           C  
ATOM    712  CG1 VAL   104      43.791  65.334   0.544  1.00 29.81           C  
ATOM    713  CG2 VAL   104      45.486  64.291  -0.935  1.00 29.13           C  
ATOM    714  N   VAL   105      40.803  64.974  -1.082  1.00 29.44           N  
ATOM    715  CA  VAL   105      39.445  65.493  -1.204  1.00 30.72           C  
ATOM    716  C   VAL   105      38.928  65.670   0.234  1.00 29.44           C  
ATOM    717  O   VAL   105      38.777  64.692   0.948  1.00 30.21           O  
ATOM    718  CB  VAL   105      38.475  64.393  -1.942  1.00 30.01           C  
ATOM    719  CG1 VAL   105      37.032  64.887  -2.108  1.00 34.93           C  
ATOM    720  CG2 VAL   105      39.021  63.941  -3.305  1.00 34.25           C  
ATOM    721  N   PRO   106      38.634  66.918   0.658  1.00 29.62           N  
ATOM    722  CA  PRO   106      37.901  66.990   1.963  1.00 29.39           C  
ATOM    723  C   PRO   106      36.504  66.389   1.845  1.00 28.28           C  
ATOM    724  O   PRO   106      35.874  66.512   0.794  1.00 28.44           O  
ATOM    725  CB  PRO   106      37.750  68.487   2.196  1.00 31.07           C  
ATOM    726  CG  PRO   106      38.792  69.112   1.313  1.00 31.66           C  
ATOM    727  CD  PRO   106      38.908  68.253   0.104  1.00 31.36           C  
ATOM    728  N   SER   107      36.011  65.783   2.916  1.00 27.63           N  
ATOM    729  CA  SER   107      34.761  65.024   2.855  1.00 27.11           C  
ATOM    730  C   SER   107      33.649  65.833   2.227  1.00 28.07           C  
ATOM    731  O   SER   107      32.872  65.332   1.400  1.00 29.30           O  
ATOM    732  CB  SER   107      34.317  64.541   4.240  1.00 27.43           C  
ATOM    733  OG  SER   107      34.112  65.639   5.141  1.00 28.30           O  
ATOM    734  N   PHE   108      33.564  67.101   2.619  1.00 26.81           N  
ATOM    735  CA  PHE   108      32.495  67.985   2.116  1.00 28.73           C  
ATOM    736  C   PHE   108      32.567  68.317   0.630  1.00 30.35           C  
ATOM    737  O   PHE   108      31.613  68.939   0.084  1.00 33.22           O  
ATOM    738  CB  PHE   108      32.424  69.285   2.962  1.00 28.90           C  
ATOM    739  CG  PHE   108      33.707  70.042   3.027  1.00 28.97           C  
ATOM    740  CD1 PHE   108      34.543  69.929   4.154  1.00 28.11           C  
ATOM    741  CD2 PHE   108      34.107  70.863   1.974  1.00 30.56           C  
ATOM    742  CE1 PHE   108      35.736  70.639   4.256  1.00 27.36           C  
ATOM    743  CE2 PHE   108      35.304  71.581   2.037  1.00 29.79           C  
ATOM    744  CZ  PHE   108      36.135  71.480   3.210  1.00 30.53           C  
ATOM    745  N   LEU   109      33.675  67.974  -0.018  1.00 31.42           N  
ATOM    746  CA  LEU   109      33.772  68.247  -1.454  1.00 34.23           C  
ATOM    747  C   LEU   109      33.567  67.003  -2.256  1.00 36.48           C  
ATOM    748  O   LEU   109      33.619  67.055  -3.492  1.00 38.12           O  
ATOM    749  CB  LEU   109      35.079  68.896  -1.867  1.00 34.37           C  
ATOM    750  CG  LEU   109      35.282  70.342  -1.450  1.00 35.16           C  
ATOM    751  CD1 LEU   109      36.625  70.853  -1.999  1.00 37.37           C  
ATOM    752  CD2 LEU   109      34.107  71.245  -1.856  1.00 38.27           C  
ATOM    753  N   ALA   110      33.343  65.895  -1.574  1.00 36.83           N  
ATOM    754  CA  ALA   110      33.217  64.636  -2.279  1.00 38.84           C  
ATOM    755  C   ALA   110      31.763  64.445  -2.738  1.00 39.68           C  
ATOM    756  O   ALA   110      31.418  63.426  -3.347  1.00 40.16           O  
ATOM    757  CB  ALA   110      33.719  63.498  -1.417  1.00 37.94           C  
ATOM    758  N   LYS   111      30.914  65.437  -2.434  1.00 40.43           N  
ATOM    759  CA  LYS   111      29.475  65.366  -2.683  1.00 42.30           C  
ATOM    760  C   LYS   111      29.197  65.055  -4.144  1.00 41.25           C  
ATOM    761  O   LYS   111      29.689  65.763  -5.036  1.00 42.39           O  
ATOM    762  CB  LYS   111      28.820  66.708  -2.296  1.00 42.90           C  
ATOM    763  CG  LYS   111      27.312  66.800  -2.525  1.00 44.98           C  
ATOM    764  CD  LYS   111      26.837  68.245  -2.342  1.00 45.69           C  
ATOM    765  CE  LYS   111      25.317  68.345  -2.439  1.00 48.97           C  
ATOM    766  NZ  LYS   111      24.913  69.536  -3.246  1.00 50.80           N  
ATOM    767  N   GLY   112      28.414  64.006  -4.373  1.00 41.02           N  
ATOM    768  CA  GLY   112      28.011  63.602  -5.720  1.00 40.80           C  
ATOM    769  C   GLY   112      29.116  62.919  -6.489  1.00 40.02           C  
ATOM    770  O   GLY   112      29.038  62.832  -7.722  1.00 41.60           O  
ATOM    771  N   LEU   113      30.150  62.447  -5.779  1.00 37.99           N  
ATOM    772  CA  LEU   113      31.315  61.850  -6.455  1.00 35.87           C  
ATOM    773  C   LEU   113      31.435  60.377  -6.124  1.00 35.16           C  
ATOM    774  O   LEU   113      31.081  59.954  -5.043  1.00 35.23           O  
ATOM    775  CB  LEU   113      32.614  62.565  -6.075  1.00 36.38           C  
ATOM    776  CG  LEU   113      32.699  64.072  -6.420  1.00 36.50           C  
ATOM    777  CD1 LEU   113      34.093  64.607  -6.099  1.00 36.69           C  
ATOM    778  CD2 LEU   113      32.300  64.348  -7.855  1.00 39.22           C  
ATOM    779  N   GLU   114      31.926  59.601  -7.082  1.00 33.46           N  
ATOM    780  CA  GLU   114      32.276  58.198  -6.816  1.00 32.67           C  
ATOM    781  C   GLU   114      33.682  58.014  -7.386  1.00 31.11           C  
ATOM    782  O   GLU   114      34.034  58.658  -8.386  1.00 31.86           O  
ATOM    783  CB  GLU   114      31.273  57.224  -7.479  1.00 33.27           C  
ATOM    784  CG  GLU   114      30.999  57.471  -8.966  1.00 37.84           C  
ATOM    785  CD  GLU   114      32.147  57.043  -9.922  1.00 40.29           C  
ATOM    786  OE1 GLU   114      32.273  57.663 -11.000  1.00 41.61           O  
ATOM    787  OE2 GLU   114      32.924  56.118  -9.594  1.00 42.34           O  
ATOM    788  N   PHE   115      34.478  57.160  -6.730  1.00 29.83           N  
ATOM    789  CA  PHE   115      35.830  56.910  -7.149  1.00 29.08           C  
ATOM    790  C   PHE   115      36.056  55.404  -7.250  1.00 29.50           C  
ATOM    791  O   PHE   115      35.464  54.637  -6.495  1.00 31.61           O  
ATOM    792  CB  PHE   115      36.794  57.490  -6.100  1.00 30.72           C  
ATOM    793  CG  PHE   115      36.579  58.963  -5.854  1.00 30.38           C  
ATOM    794  CD1 PHE   115      37.044  59.898  -6.767  1.00 35.11           C  
ATOM    795  CD2 PHE   115      35.933  59.400  -4.692  1.00 34.22           C  
ATOM    796  CE1 PHE   115      36.850  61.267  -6.529  1.00 35.07           C  
ATOM    797  CE2 PHE   115      35.743  60.768  -4.449  1.00 36.21           C  
ATOM    798  CZ  PHE   115      36.208  61.684  -5.363  1.00 35.83           C  
ATOM    799  N   ASP   116      36.914  54.987  -8.185  1.00 29.97           N  
ATOM    800  CA  ASP   116      37.321  53.602  -8.303  1.00 29.86           C  
ATOM    801  C   ASP   116      37.866  53.079  -6.970  1.00 30.02           C  
ATOM    802  O   ASP   116      37.397  52.070  -6.444  1.00 29.83           O  
ATOM    803  CB  ASP   116      38.421  53.579  -9.358  1.00 30.94           C  
ATOM    804  CG  ASP   116      38.841  52.199  -9.746  1.00 34.85           C  
ATOM    805  OD1 ASP   116      38.043  51.249  -9.577  1.00 36.80           O  
ATOM    806  OD2 ASP   116      39.981  52.093 -10.268  1.00 37.88           O  
ATOM    807  N   ALA   117      38.842  53.793  -6.423  1.00 28.84           N  
ATOM    808  CA  ALA   117      39.465  53.419  -5.147  1.00 27.87           C  
ATOM    809  C   ALA   117      39.464  54.646  -4.244  1.00 28.35           C  
ATOM    810  O   ALA   117      39.668  55.790  -4.698  1.00 28.17           O  
ATOM    811  CB  ALA   117      40.882  52.965  -5.389  1.00 28.40           C  
ATOM    812  N   VAL   118      39.234  54.399  -2.962  1.00 28.36           N  
ATOM    813  CA  VAL   118      39.279  55.470  -1.975  1.00 27.52           C  
ATOM    814  C   VAL   118      40.232  55.034  -0.880  1.00 28.77           C  
ATOM    815  O   VAL   118      40.196  53.888  -0.441  1.00 28.95           O  
ATOM    816  CB  VAL   118      37.865  55.722  -1.343  1.00 28.89           C  
ATOM    817  CG1 VAL   118      37.972  56.644  -0.109  1.00 30.19           C  
ATOM    818  CG2 VAL   118      36.929  56.360  -2.413  1.00 29.50           C  
ATOM    819  N   ILE   119      41.036  55.984  -0.429  1.00 27.26           N  
ATOM    820  CA  ILE   119      41.774  55.798   0.844  1.00 27.65           C  
ATOM    821  C   ILE   119      41.199  56.790   1.848  1.00 27.78           C  
ATOM    822  O   ILE   119      41.242  57.993   1.590  1.00 28.53           O  
ATOM    823  CB  ILE   119      43.255  56.055   0.647  1.00 27.34           C  
ATOM    824  CG1 ILE   119      43.853  55.049  -0.344  1.00 29.20           C  
ATOM    825  CG2 ILE   119      44.035  56.035   2.020  1.00 28.61           C  
ATOM    826  CD1 ILE   119      45.302  55.448  -0.840  1.00 28.93           C  
ATOM    827  N   VAL   120      40.591  56.296   2.936  1.00 27.27           N  
ATOM    828  CA  VAL   120      40.062  57.167   3.979  1.00 26.74           C  
ATOM    829  C   VAL   120      41.206  57.548   4.896  1.00 27.37           C  
ATOM    830  O   VAL   120      41.788  56.707   5.579  1.00 28.83           O  
ATOM    831  CB  VAL   120      38.933  56.469   4.794  1.00 27.80           C  
ATOM    832  CG1 VAL   120      38.358  57.423   5.801  1.00 26.73           C  
ATOM    833  CG2 VAL   120      37.855  55.979   3.833  1.00 29.25           C  
ATOM    834  N   TRP   121      41.492  58.852   4.955  1.00 26.99           N  
ATOM    835  CA  TRP   121      42.633  59.292   5.764  1.00 27.72           C  
ATOM    836  C   TRP   121      42.243  59.513   7.227  1.00 28.96           C  
ATOM    837  O   TRP   121      41.392  60.370   7.589  1.00 28.42           O  
ATOM    838  CB  TRP   121      43.285  60.576   5.176  1.00 28.13           C  
ATOM    839  CG  TRP   121      44.288  61.158   6.092  1.00 27.78           C  
ATOM    840  CD1 TRP   121      44.221  62.388   6.727  1.00 30.05           C  
ATOM    841  CD2 TRP   121      45.485  60.528   6.560  1.00 29.07           C  
ATOM    842  NE1 TRP   121      45.343  62.576   7.531  1.00 28.63           N  
ATOM    843  CE2 TRP   121      46.119  61.437   7.460  1.00 27.59           C  
ATOM    844  CE3 TRP   121      46.109  59.300   6.285  1.00 30.22           C  
ATOM    845  CZ2 TRP   121      47.335  61.139   8.072  1.00 28.61           C  
ATOM    846  CZ3 TRP   121      47.323  58.993   6.936  1.00 27.83           C  
ATOM    847  CH2 TRP   121      47.902  59.916   7.812  1.00 27.84           C  
ATOM    848  N   ASN   122      42.901  58.729   8.073  1.00 28.25           N  
ATOM    849  CA  ASN   122      42.835  58.912   9.531  1.00 27.68           C  
ATOM    850  C   ASN   122      41.443  58.666  10.105  1.00 27.35           C  
ATOM    851  O   ASN   122      40.862  59.523  10.797  1.00 28.34           O  
ATOM    852  CB  ASN   122      43.429  60.226  10.012  1.00 27.53           C  
ATOM    853  CG  ASN   122      44.095  60.048  11.380  1.00 28.17           C  
ATOM    854  OD1 ASN   122      44.025  58.948  11.919  1.00 29.64           O  
ATOM    855  ND2 ASN   122      44.679  61.114  11.955  1.00 32.02           N  
ATOM    856  N   ALA   123      40.975  57.460   9.852  1.00 27.61           N  
ATOM    857  CA  ALA   123      39.713  56.954  10.385  1.00 28.03           C  
ATOM    858  C   ALA   123      39.897  56.488  11.835  1.00 28.18           C  
ATOM    859  O   ALA   123      39.619  55.312  12.156  1.00 28.50           O  
ATOM    860  CB  ALA   123      39.239  55.754   9.524  1.00 29.82           C  
ATOM    861  N   ASN   124      40.347  57.404  12.691  1.00 27.59           N  
ATOM    862  CA  ASN   124      40.777  57.011  14.016  1.00 28.53           C  
ATOM    863  C   ASN   124      39.774  57.432  15.090  1.00 29.14           C  
ATOM    864  O   ASN   124      38.653  57.883  14.780  1.00 29.75           O  
ATOM    865  CB  ASN   124      42.181  57.549  14.332  1.00 28.00           C  
ATOM    866  CG  ASN   124      42.206  59.065  14.491  1.00 29.92           C  
ATOM    867  OD1 ASN   124      41.204  59.735  14.250  1.00 29.55           O  
ATOM    868  ND2 ASN   124      43.367  59.612  14.909  1.00 29.97           N  
ATOM    869  N   GLN   125      40.142  57.235  16.346  1.00 28.40           N  
ATOM    870  CA  GLN   125      39.217  57.516  17.446  1.00 29.52           C  
ATOM    871  C   GLN   125      39.000  59.019  17.563  1.00 30.46           C  
ATOM    872  O   GLN   125      37.857  59.471  17.741  1.00 30.50           O  
ATOM    873  CB  GLN   125      39.859  56.949  18.713  1.00 29.92           C  
ATOM    874  CG  GLN   125      39.101  57.118  19.911  1.00 33.94           C  
ATOM    875  CD  GLN   125      39.872  56.474  21.046  1.00 41.32           C  
ATOM    876  OE1 GLN   125      39.942  55.251  21.133  1.00 45.19           O  
ATOM    877  NE2 GLN   125      40.528  57.295  21.857  1.00 46.09           N  
ATOM    878  N   GLU   126      40.077  59.798  17.450  1.00 30.55           N  
ATOM    879  CA  GLU   126      39.926  61.234  17.645  1.00 32.78           C  
ATOM    880  C   GLU   126      39.010  61.838  16.596  1.00 31.60           C  
ATOM    881  O   GLU   126      38.198  62.727  16.908  1.00 32.96           O  
ATOM    882  CB  GLU   126      41.276  61.932  17.606  1.00 33.79           C  
ATOM    883  CG  GLU   126      41.081  63.372  18.049  1.00 39.53           C  
ATOM    884  CD  GLU   126      42.365  64.105  18.215  1.00 46.40           C  
ATOM    885  OE1 GLU   126      43.439  63.467  18.112  1.00 49.13           O  
ATOM    886  OE2 GLU   126      42.278  65.333  18.430  1.00 49.46           O  
ATOM    887  N   ASN   127      39.152  61.364  15.361  1.00 30.09           N  
ATOM    888  CA  ASN   127      38.416  61.950  14.241  1.00 29.75           C  
ATOM    889  C   ASN   127      36.983  61.441  14.119  1.00 30.22           C  
ATOM    890  O   ASN   127      36.102  62.156  13.546  1.00 31.63           O  
ATOM    891  CB  ASN   127      39.160  61.685  12.914  1.00 28.44           C  
ATOM    892  CG  ASN   127      40.308  62.661  12.701  1.00 32.49           C  
ATOM    893  OD1 ASN   127      41.369  62.284  12.170  1.00 40.71           O  
ATOM    894  ND2 ASN   127      40.083  63.909  13.054  1.00 28.89           N  
ATOM    895  N   TYR   128      36.744  60.200  14.569  1.00 30.27           N  
ATOM    896  CA  TYR   128      35.433  59.613  14.398  1.00 30.46           C  
ATOM    897  C   TYR   128      35.044  58.932  15.691  1.00 31.11           C  
ATOM    898  O   TYR   128      35.067  57.710  15.780  1.00 30.85           O  
ATOM    899  CB  TYR   128      35.456  58.626  13.212  1.00 31.39           C  
ATOM    900  CG  TYR   128      35.723  59.308  11.894  1.00 31.77           C  
ATOM    901  CD1 TYR   128      34.675  59.902  11.152  1.00 29.39           C  
ATOM    902  CD2 TYR   128      37.010  59.350  11.355  1.00 30.74           C  
ATOM    903  CE1 TYR   128      34.926  60.539   9.943  1.00 30.63           C  
ATOM    904  CE2 TYR   128      37.281  60.005  10.109  1.00 31.04           C  
ATOM    905  CZ  TYR   128      36.224  60.583   9.411  1.00 30.95           C  
ATOM    906  OH  TYR   128      36.485  61.212   8.193  1.00 32.09           O  
ATOM    907  N   GLN   129      34.645  59.752  16.680  1.00 31.62           N  
ATOM    908  CA  GLN   129      34.394  59.303  18.016  1.00 33.63           C  
ATOM    909  C   GLN   129      32.892  59.261  18.310  1.00 32.29           C  
ATOM    910  O   GLN   129      32.420  58.428  19.077  1.00 32.43           O  
ATOM    911  CB  GLN   129      35.050  60.317  18.988  1.00 35.02           C  
ATOM    912  CG  GLN   129      34.664  60.183  20.428  1.00 41.13           C  
ATOM    913  CD  GLN   129      35.514  59.160  21.128  1.00 48.48           C  
ATOM    914  OE1 GLN   129      36.700  59.400  21.393  1.00 50.81           O  
ATOM    915  NE2 GLN   129      34.927  58.017  21.439  1.00 50.85           N  
ATOM    916  N   ARG   130      32.134  60.147  17.669  1.00 30.50           N  
ATOM    917  CA  ARG   130      30.756  60.371  18.089  1.00 30.88           C  
ATOM    918  C   ARG   130      29.786  59.564  17.269  1.00 29.03           C  
ATOM    919  O   ARG   130      29.978  59.383  16.067  1.00 29.11           O  
ATOM    920  CB  ARG   130      30.387  61.863  17.961  1.00 30.43           C  
ATOM    921  CG  ARG   130      31.286  62.743  18.779  1.00 31.17           C  
ATOM    922  CD  ARG   130      30.727  64.170  18.817  1.00 29.95           C  
ATOM    923  NE  ARG   130      29.436  64.261  19.482  1.00 31.37           N  
ATOM    924  CZ  ARG   130      29.245  64.283  20.793  1.00 32.44           C  
ATOM    925  NH1 ARG   130      30.294  64.210  21.636  1.00 32.97           N  
ATOM    926  NH2 ARG   130      28.009  64.393  21.268  1.00 32.91           N  
ATOM    927  N   GLU   131      28.699  59.121  17.915  1.00 28.84           N  
ATOM    928  CA  GLU   131      27.638  58.442  17.194  1.00 28.48           C  
ATOM    929  C   GLU   131      27.124  59.275  16.037  1.00 28.38           C  
ATOM    930  O   GLU   131      26.767  58.728  14.980  1.00 28.12           O  
ATOM    931  CB  GLU   131      26.480  58.071  18.094  1.00 30.46           C  
ATOM    932  CG  GLU   131      26.880  56.972  19.073  1.00 32.46           C  
ATOM    933  CD  GLU   131      27.129  55.631  18.376  1.00 34.22           C  
ATOM    934  OE1 GLU   131      26.216  55.119  17.704  1.00 34.57           O  
ATOM    935  OE2 GLU   131      28.256  55.128  18.503  1.00 38.12           O  
ATOM    936  N   ASP   132      27.107  60.581  16.235  1.00 27.49           N  
ATOM    937  CA  ASP   132      26.602  61.455  15.179  1.00 27.32           C  
ATOM    938  C   ASP   132      27.496  61.481  13.957  1.00 27.67           C  
ATOM    939  O   ASP   132      27.053  61.992  12.911  1.00 28.64           O  
ATOM    940  CB  ASP   132      26.394  62.885  15.718  1.00 26.75           C  
ATOM    941  CG  ASP   132      25.547  63.722  14.782  1.00 27.24           C  
ATOM    942  OD1 ASP   132      24.363  63.342  14.645  1.00 27.96           O  
ATOM    943  OD2 ASP   132      26.053  64.741  14.236  1.00 27.34           O  
ATOM    944  N   GLU   133      28.744  61.010  14.093  1.00 25.77           N  
ATOM    945  CA  GLU   133      29.705  60.973  12.970  1.00 26.67           C  
ATOM    946  C   GLU   133      29.570  59.694  12.126  1.00 27.44           C  
ATOM    947  O   GLU   133      30.304  59.530  11.167  1.00 28.55           O  
ATOM    948  CB  GLU   133      31.138  61.128  13.493  1.00 27.03           C  
ATOM    949  CG  GLU   133      31.349  62.609  13.856  1.00 28.49           C  
ATOM    950  CD  GLU   133      32.645  62.877  14.578  1.00 32.97           C  
ATOM    951  OE1 GLU   133      33.048  62.051  15.431  1.00 34.48           O  
ATOM    952  OE2 GLU   133      33.241  63.950  14.301  1.00 32.24           O  
ATOM    953  N   ARG   134      28.678  58.773  12.511  1.00 27.97           N  
ATOM    954  CA  ARG   134      28.517  57.545  11.696  1.00 28.23           C  
ATOM    955  C   ARG   134      28.100  57.897  10.266  1.00 27.92           C  
ATOM    956  O   ARG   134      28.589  57.280   9.281  1.00 28.58           O  
ATOM    957  CB  ARG   134      27.462  56.634  12.322  1.00 28.08           C  
ATOM    958  CG  ARG   134      27.997  55.908  13.554  1.00 28.12           C  
ATOM    959  CD  ARG   134      26.973  54.944  14.103  1.00 26.86           C  
ATOM    960  NE  ARG   134      27.535  54.332  15.303  1.00 28.27           N  
ATOM    961  CZ  ARG   134      28.424  53.343  15.306  1.00 30.41           C  
ATOM    962  NH1 ARG   134      28.820  52.785  14.149  1.00 30.05           N  
ATOM    963  NH2 ARG   134      28.921  52.929  16.479  1.00 29.65           N  
ATOM    964  N   GLN   135      27.195  58.869  10.125  1.00 28.59           N  
ATOM    965  CA  GLN   135      26.674  59.203   8.783  1.00 29.02           C  
ATOM    966  C   GLN   135      27.837  59.676   7.900  1.00 29.14           C  
ATOM    967  O   GLN   135      27.975  59.263   6.745  1.00 29.03           O  
ATOM    968  CB  GLN   135      25.609  60.291   8.883  1.00 30.77           C  
ATOM    969  CG  GLN   135      25.079  60.708   7.537  1.00 34.30           C  
ATOM    970  CD  GLN   135      24.412  59.541   6.826  1.00 39.47           C  
ATOM    971  OE1 GLN   135      23.690  58.761   7.442  1.00 41.28           O  
ATOM    972  NE2 GLN   135      24.641  59.431   5.530  1.00 44.92           N  
ATOM    973  N   LEU   136      28.683  60.539   8.461  1.00 28.43           N  
ATOM    974  CA  LEU   136      29.870  61.020   7.728  1.00 29.03           C  
ATOM    975  C   LEU   136      30.804  59.880   7.316  1.00 28.46           C  
ATOM    976  O   LEU   136      31.188  59.785   6.144  1.00 27.61           O  
ATOM    977  CB  LEU   136      30.623  62.039   8.597  1.00 29.21           C  
ATOM    978  CG  LEU   136      31.937  62.514   7.979  1.00 31.83           C  
ATOM    979  CD1 LEU   136      31.681  63.344   6.744  1.00 33.64           C  
ATOM    980  CD2 LEU   136      32.728  63.339   9.014  1.00 33.41           C  
ATOM    981  N   LEU   137      31.181  59.018   8.267  1.00 27.95           N  
ATOM    982  CA  LEU   137      32.112  57.957   7.948  1.00 28.06           C  
ATOM    983  C   LEU   137      31.509  57.013   6.919  1.00 28.06           C  
ATOM    984  O   LEU   137      32.189  56.613   5.974  1.00 27.97           O  
ATOM    985  CB  LEU   137      32.505  57.202   9.226  1.00 27.39           C  
ATOM    986  CG  LEU   137      33.552  56.115   9.045  1.00 28.66           C  
ATOM    987  CD1 LEU   137      34.860  56.692   8.480  1.00 27.53           C  
ATOM    988  CD2 LEU   137      33.782  55.441  10.405  1.00 31.02           C  
ATOM    989  N   TYR   138      30.222  56.706   7.074  1.00 27.25           N  
ATOM    990  CA  TYR   138      29.507  55.890   6.088  1.00 27.48           C  
ATOM    991  C   TYR   138      29.574  56.534   4.690  1.00 28.57           C  
ATOM    992  O   TYR   138      29.905  55.888   3.691  1.00 28.17           O  
ATOM    993  CB  TYR   138      28.052  55.788   6.525  1.00 28.78           C  
ATOM    994  CG  TYR   138      27.168  55.208   5.456  1.00 27.70           C  
ATOM    995  CD1 TYR   138      27.163  53.838   5.228  1.00 30.78           C  
ATOM    996  CD2 TYR   138      26.360  56.023   4.694  1.00 28.90           C  
ATOM    997  CE1 TYR   138      26.308  53.285   4.237  1.00 30.18           C  
ATOM    998  CE2 TYR   138      25.535  55.508   3.713  1.00 30.12           C  
ATOM    999  CZ  TYR   138      25.518  54.145   3.484  1.00 31.03           C  
ATOM   1000  OH  TYR   138      24.675  53.661   2.491  1.00 35.00           O  
ATOM   1001  N   THR   139      29.213  57.804   4.635  1.00 28.14           N  
ATOM   1002  CA  THR   139      29.211  58.525   3.358  1.00 28.97           C  
ATOM   1003  C   THR   139      30.592  58.529   2.694  1.00 28.60           C  
ATOM   1004  O   THR   139      30.707  58.317   1.510  1.00 30.49           O  
ATOM   1005  CB  THR   139      28.693  59.939   3.562  1.00 29.12           C  
ATOM   1006  OG1 THR   139      27.361  59.834   4.066  1.00 30.06           O  
ATOM   1007  CG2 THR   139      28.661  60.695   2.244  1.00 30.44           C  
ATOM   1008  N   ILE   140      31.633  58.794   3.466  1.00 29.03           N  
ATOM   1009  CA  ILE   140      32.988  58.794   2.910  1.00 28.61           C  
ATOM   1010  C   ILE   140      33.340  57.425   2.337  1.00 29.48           C  
ATOM   1011  O   ILE   140      33.814  57.305   1.207  1.00 29.65           O  
ATOM   1012  CB  ILE   140      33.983  59.182   3.982  1.00 29.00           C  
ATOM   1013  CG1 ILE   140      33.763  60.660   4.372  1.00 28.88           C  
ATOM   1014  CG2 ILE   140      35.421  58.937   3.508  1.00 31.15           C  
ATOM   1015  CD1 ILE   140      34.650  61.091   5.580  1.00 31.36           C  
ATOM   1016  N   CYS   141      33.116  56.392   3.129  1.00 29.07           N  
ATOM   1017  CA  CYS   141      33.514  55.058   2.697  1.00 29.13           C  
ATOM   1018  C   CYS   141      32.696  54.631   1.476  1.00 29.19           C  
ATOM   1019  O   CYS   141      33.222  53.925   0.601  1.00 29.54           O  
ATOM   1020  CB  CYS   141      33.313  54.071   3.846  1.00 30.06           C  
ATOM   1021  SG  CYS   141      34.497  54.243   5.167  1.00 30.78           S  
ATOM   1022  N   SER   142      31.439  55.081   1.407  1.00 28.43           N  
ATOM   1023  CA  SER   142      30.517  54.678   0.357  0.50 28.65           C  
ATOM   1025  C   SER   142      30.868  55.309  -1.011  1.00 28.50           C  
ATOM   1026  O   SER   142      30.279  54.947  -2.029  1.00 30.12           O  
ATOM   1027  CB  SER   142      29.061  54.956   0.773  0.50 28.43           C  
ATOM   1029  OG  SER   142      28.696  54.145   1.890  0.50 25.91           O  
ATOM   1031  N   ARG   143      31.826  56.251  -1.018  1.00 29.82           N  
ATOM   1032  CA  ARG   143      32.303  56.863  -2.273  1.00 30.89           C  
ATOM   1033  C   ARG   143      33.132  55.874  -3.082  1.00 29.99           C  
ATOM   1034  O   ARG   143      33.363  56.107  -4.261  1.00 31.24           O  
ATOM   1035  CB  ARG   143      33.153  58.093  -2.011  1.00 31.47           C  
ATOM   1036  CG  ARG   143      32.463  59.143  -1.150  1.00 34.66           C  
ATOM   1037  CD  ARG   143      31.698  60.079  -1.977  1.00 35.87           C  
ATOM   1038  NE  ARG   143      30.948  61.043  -1.174  1.00 40.42           N  
ATOM   1039  CZ  ARG   143      29.799  61.568  -1.580  1.00 41.14           C  
ATOM   1040  NH1 ARG   143      29.297  61.222  -2.769  1.00 41.61           N  
ATOM   1041  NH2 ARG   143      29.144  62.436  -0.800  1.00 42.42           N  
ATOM   1042  N   ALA   144      33.629  54.810  -2.430  1.00 28.33           N  
ATOM   1043  CA  ALA   144      34.470  53.812  -3.132  1.00 27.96           C  
ATOM   1044  C   ALA   144      33.628  52.841  -3.900  1.00 28.12           C  
ATOM   1045  O   ALA   144      32.713  52.194  -3.336  1.00 27.80           O  
ATOM   1046  CB  ALA   144      35.328  52.989  -2.116  1.00 28.28           C  
ATOM   1047  N   MET   145      33.982  52.676  -5.169  1.00 27.99           N  
ATOM   1048  CA  MET   145      33.250  51.751  -6.027  1.00 29.45           C  
ATOM   1049  C   MET   145      33.880  50.368  -5.968  1.00 29.26           C  
ATOM   1050  O   MET   145      33.152  49.361  -5.869  1.00 31.39           O  
ATOM   1051  CB  MET   145      33.155  52.275  -7.467  1.00 29.97           C  
ATOM   1052  CG  MET   145      32.339  53.530  -7.585  1.00 30.96           C  
ATOM   1053  SD  MET   145      30.449  53.319  -7.012  0.60 37.90          SE  
ATOM   1054  CE  MET   145      30.502  54.220  -5.253  1.00 36.23           C  
ATOM   1055  N   HIS   146      35.208  50.297  -6.017  1.00 28.77           N  
ATOM   1056  CA  HIS   146      35.887  49.014  -6.275  1.00 28.01           C  
ATOM   1057  C   HIS   146      36.922  48.631  -5.199  1.00 28.21           C  
ATOM   1058  O   HIS   146      37.033  47.466  -4.840  1.00 29.52           O  
ATOM   1059  CB  HIS   146      36.492  48.999  -7.699  1.00 29.10           C  
ATOM   1060  CG  HIS   146      35.469  49.301  -8.774  1.00 30.83           C  
ATOM   1061  ND1 HIS   146      35.625  50.307  -9.715  1.00 37.42           N  
ATOM   1062  CD2 HIS   146      34.247  48.764  -9.009  1.00 35.68           C  
ATOM   1063  CE1 HIS   146      34.553  50.361 -10.486  1.00 36.32           C  
ATOM   1064  NE2 HIS   146      33.706  49.428 -10.088  1.00 37.00           N  
ATOM   1065  N   GLU   147      37.643  49.617  -4.664  1.00 27.29           N  
ATOM   1066  CA  GLU   147      38.665  49.370  -3.628  1.00 27.59           C  
ATOM   1067  C   GLU   147      38.511  50.406  -2.519  1.00 27.75           C  
ATOM   1068  O   GLU   147      38.353  51.573  -2.787  1.00 27.59           O  
ATOM   1069  CB  GLU   147      40.059  49.495  -4.240  1.00 30.02           C  
ATOM   1070  CG  GLU   147      41.159  48.843  -3.400  1.00 34.07           C  
ATOM   1071  CD  GLU   147      41.190  47.305  -3.560  1.00 40.81           C  
ATOM   1072  OE1 GLU   147      40.620  46.793  -4.557  1.00 46.13           O  
ATOM   1073  OE2 GLU   147      41.813  46.619  -2.715  1.00 47.95           O  
ATOM   1074  N   LEU   148      38.548  49.928  -1.286  1.00 26.42           N  
ATOM   1075  CA  LEU   148      38.403  50.814  -0.126  1.00 25.96           C  
ATOM   1076  C   LEU   148      39.460  50.466   0.908  1.00 27.78           C  
ATOM   1077  O   LEU   148      39.574  49.308   1.332  1.00 28.11           O  
ATOM   1078  CB  LEU   148      37.001  50.664   0.466  1.00 26.47           C  
ATOM   1079  CG  LEU   148      36.747  51.375   1.797  1.00 26.48           C  
ATOM   1080  CD1 LEU   148      36.870  52.907   1.632  1.00 27.80           C  
ATOM   1081  CD2 LEU   148      35.359  50.950   2.424  1.00 27.09           C  
ATOM   1082  N   THR   149      40.199  51.491   1.324  1.00 26.92           N  
ATOM   1083  CA  THR   149      41.289  51.336   2.304  1.00 26.77           C  
ATOM   1084  C   THR   149      41.017  52.372   3.364  1.00 27.55           C  
ATOM   1085  O   THR   149      40.668  53.485   3.064  1.00 28.02           O  
ATOM   1086  CB  THR   149      42.678  51.660   1.680  1.00 27.25           C  
ATOM   1087  OG1 THR   149      42.946  50.751   0.618  1.00 28.29           O  
ATOM   1088  CG2 THR   149      43.786  51.511   2.753  1.00 30.04           C  
ATOM   1089  N   LEU   150      41.175  51.978   4.627  1.00 27.28           N  
ATOM   1090  CA  LEU   150      41.090  52.935   5.759  1.00 27.57           C  
ATOM   1091  C   LEU   150      42.405  52.905   6.480  1.00 27.94           C  
ATOM   1092  O   LEU   150      42.878  51.841   6.884  1.00 29.36           O  
ATOM   1093  CB  LEU   150      39.954  52.603   6.751  1.00 28.59           C  
ATOM   1094  CG  LEU   150      38.527  52.831   6.268  1.00 29.04           C  
ATOM   1095  CD1 LEU   150      38.100  51.752   5.316  1.00 31.77           C  
ATOM   1096  CD2 LEU   150      37.600  52.774   7.507  1.00 31.38           C  
ATOM   1097  N   VAL   151      42.966  54.092   6.682  1.00 26.84           N  
ATOM   1098  CA  VAL   151      44.207  54.237   7.479  1.00 27.14           C  
ATOM   1099  C   VAL   151      43.886  55.000   8.729  1.00 27.99           C  
ATOM   1100  O   VAL   151      43.296  56.061   8.649  1.00 27.88           O  
ATOM   1101  CB  VAL   151      45.342  54.965   6.676  1.00 27.80           C  
ATOM   1102  CG1 VAL   151      46.597  55.160   7.545  1.00 29.25           C  
ATOM   1103  CG2 VAL   151      45.702  54.189   5.404  1.00 28.21           C  
ATOM   1104  N   ALA   152      44.283  54.472   9.896  1.00 27.13           N  
ATOM   1105  CA  ALA   152      43.986  55.167  11.166  1.00 27.57           C  
ATOM   1106  C   ALA   152      45.299  55.376  11.868  1.00 28.83           C  
ATOM   1107  O   ALA   152      46.133  54.478  11.869  1.00 30.16           O  
ATOM   1108  CB  ALA   152      43.064  54.286  12.061  1.00 29.53           C  
ATOM   1109  N   VAL   153      45.467  56.542  12.470  1.00 26.26           N  
ATOM   1110  CA  VAL   153      46.665  56.853  13.269  1.00 27.40           C  
ATOM   1111  C   VAL   153      46.252  56.755  14.738  1.00 28.00           C  
ATOM   1112  O   VAL   153      45.386  57.522  15.231  1.00 28.69           O  
ATOM   1113  CB  VAL   153      47.172  58.256  12.982  1.00 27.93           C  
ATOM   1114  CG1 VAL   153      48.375  58.567  13.902  1.00 29.47           C  
ATOM   1115  CG2 VAL   153      47.607  58.334  11.508  1.00 29.89           C  
ATOM   1116  N   GLY   154      46.849  55.801  15.431  1.00 26.87           N  
ATOM   1117  CA  GLY   154      46.602  55.596  16.854  1.00 28.31           C  
ATOM   1118  C   GLY   154      45.728  54.385  17.042  1.00 29.41           C  
ATOM   1119  O   GLY   154      46.203  53.252  17.092  1.00 29.07           O  
ATOM   1120  N   SER   155      44.417  54.626  17.110  1.00 29.57           N  
ATOM   1121  CA  SER   155      43.431  53.556  17.260  1.00 29.03           C  
ATOM   1122  C   SER   155      42.369  53.688  16.202  1.00 29.44           C  
ATOM   1123  O   SER   155      42.079  54.792  15.762  1.00 29.49           O  
ATOM   1124  CB  SER   155      42.712  53.640  18.608  1.00 29.42           C  
ATOM   1125  OG  SER   155      43.621  53.314  19.675  1.00 31.86           O  
ATOM   1126  N   LEU   156      41.808  52.553  15.807  1.00 28.60           N  
ATOM   1127  CA  LEU   156      40.697  52.587  14.855  1.00 29.01           C  
ATOM   1128  C   LEU   156      39.481  53.279  15.475  1.00 29.11           C  
ATOM   1129  O   LEU   156      39.189  53.136  16.663  1.00 30.21           O  
ATOM   1130  CB  LEU   156      40.351  51.157  14.420  1.00 28.63           C  
ATOM   1131  CG  LEU   156      39.383  51.028  13.243  1.00 29.53           C  
ATOM   1132  CD1 LEU   156      39.922  51.650  11.944  1.00 29.39           C  
ATOM   1133  CD2 LEU   156      39.045  49.536  13.054  1.00 30.45           C  
ATOM   1134  N   SER   157      38.729  54.005  14.628  1.00 29.06           N  
ATOM   1135  CA  SER   157      37.492  54.627  15.102  1.00 29.30           C  
ATOM   1136  C   SER   157      36.636  53.596  15.868  1.00 27.87           C  
ATOM   1137  O   SER   157      36.374  52.496  15.346  1.00 29.69           O  
ATOM   1138  CB  SER   157      36.681  55.117  13.898  1.00 28.77           C  
ATOM   1139  OG  SER   157      35.371  55.440  14.387  1.00 30.08           O  
ATOM   1140  N   PRO   158      36.106  53.979  17.029  1.00 29.52           N  
ATOM   1141  CA  PRO   158      35.204  53.071  17.760  1.00 29.78           C  
ATOM   1142  C   PRO   158      33.903  52.832  16.994  1.00 30.01           C  
ATOM   1143  O   PRO   158      33.196  51.851  17.266  1.00 30.42           O  
ATOM   1144  CB  PRO   158      34.911  53.834  19.051  1.00 31.64           C  
ATOM   1145  CG  PRO   158      35.116  55.310  18.694  1.00 31.24           C  
ATOM   1146  CD  PRO   158      36.340  55.227  17.791  1.00 28.97           C  
ATOM   1147  N   LEU   159      33.601  53.720  16.059  1.00 28.10           N  
ATOM   1148  CA  LEU   159      32.371  53.544  15.271  1.00 27.17           C  
ATOM   1149  C   LEU   159      32.467  52.257  14.427  1.00 28.07           C  
ATOM   1150  O   LEU   159      31.454  51.770  13.937  1.00 28.47           O  
ATOM   1151  CB  LEU   159      32.097  54.774  14.393  1.00 28.70           C  
ATOM   1152  CG  LEU   159      32.062  56.094  15.186  1.00 27.54           C  
ATOM   1153  CD1 LEU   159      31.769  57.229  14.191  1.00 28.76           C  
ATOM   1154  CD2 LEU   159      30.994  56.019  16.322  1.00 29.15           C  
ATOM   1155  N   LEU   160      33.710  51.807  14.193  1.00 27.99           N  
ATOM   1156  CA  LEU   160      33.923  50.611  13.371  1.00 28.46           C  
ATOM   1157  C   LEU   160      33.909  49.335  14.187  1.00 29.01           C  
ATOM   1158  O   LEU   160      33.928  48.234  13.611  1.00 29.27           O  
ATOM   1159  CB  LEU   160      35.192  50.731  12.512  1.00 27.82           C  
ATOM   1160  CG  LEU   160      35.145  51.907  11.501  1.00 28.15           C  
ATOM   1161  CD1 LEU   160      36.517  52.039  10.825  1.00 29.93           C  
ATOM   1162  CD2 LEU   160      34.047  51.686  10.464  1.00 28.61           C  
ATOM   1163  N   ALA   161      33.805  49.460  15.521  1.00 28.42           N  
ATOM   1164  CA  ALA   161      33.876  48.262  16.388  1.00 28.64           C  
ATOM   1165  C   ALA   161      32.721  47.299  16.065  1.00 28.77           C  
ATOM   1166  O   ALA   161      32.878  46.090  16.140  1.00 30.01           O  
ATOM   1167  CB  ALA   161      33.857  48.657  17.870  1.00 30.35           C  
ATOM   1168  N   ARG   162      31.571  47.847  15.723  1.00 28.40           N  
ATOM   1169  CA  ARG   162      30.374  47.030  15.488  1.00 29.87           C  
ATOM   1170  C   ARG   162      30.458  46.241  14.202  1.00 29.92           C  
ATOM   1171  O   ARG   162      29.705  45.290  14.024  1.00 32.54           O  
ATOM   1172  CB  ARG   162      29.098  47.875  15.483  1.00 28.55           C  
ATOM   1173  CG  ARG   162      28.905  48.838  14.284  1.00 29.50           C  
ATOM   1174  CD  ARG   162      27.596  49.639  14.418  1.00 29.29           C  
ATOM   1175  NE  ARG   162      26.461  48.764  14.799  1.00 36.22           N  
ATOM   1176  CZ  ARG   162      25.832  47.963  13.943  1.00 37.88           C  
ATOM   1177  NH1 ARG   162      26.207  47.906  12.671  1.00 38.48           N  
ATOM   1178  NH2 ARG   162      24.823  47.197  14.346  1.00 39.58           N  
ATOM   1179  N   VAL   163      31.352  46.624  13.301  1.00 28.88           N  
ATOM   1180  CA  VAL   163      31.402  45.931  11.987  1.00 29.09           C  
ATOM   1181  C   VAL   163      31.909  44.507  12.160  1.00 29.90           C  
ATOM   1182  O   VAL   163      32.877  44.268  12.851  1.00 30.57           O  
ATOM   1183  CB  VAL   163      32.291  46.697  10.993  1.00 29.82           C  
ATOM   1184  CG1 VAL   163      32.328  45.983   9.654  1.00 29.99           C  
ATOM   1185  CG2 VAL   163      31.752  48.121  10.796  1.00 30.12           C  
ATOM   1186  N   ASN   164      31.252  43.565  11.490  1.00 28.00           N  
ATOM   1187  CA  ASN   164      31.656  42.178  11.503  1.00 29.01           C  
ATOM   1188  C   ASN   164      33.102  42.068  11.007  1.00 28.96           C  
ATOM   1189  O   ASN   164      33.424  42.518   9.886  1.00 28.98           O  
ATOM   1190  CB  ASN   164      30.655  41.438  10.601  1.00 27.50           C  
ATOM   1191  CG  ASN   164      30.844  39.939  10.570  1.00 28.60           C  
ATOM   1192  OD1 ASN   164      31.936  39.413  10.839  1.00 30.57           O  
ATOM   1193  ND2 ASN   164      29.786  39.236  10.177  1.00 28.16           N  
ATOM   1194  N   HIS   165      33.966  41.437  11.811  1.00 29.81           N  
ATOM   1195  CA  HIS   165      35.387  41.352  11.417  1.00 30.12           C  
ATOM   1196  C   HIS   165      35.620  40.598  10.113  1.00 29.79           C  
ATOM   1197  O   HIS   165      36.648  40.809   9.455  1.00 30.40           O  
ATOM   1198  CB  HIS   165      36.241  40.723  12.504  1.00 31.36           C  
ATOM   1199  CG  HIS   165      36.426  41.604  13.702  1.00 35.08           C  
ATOM   1200  ND1 HIS   165      37.389  41.361  14.662  1.00 40.78           N  
ATOM   1201  CD2 HIS   165      35.777  42.727  14.094  1.00 37.29           C  
ATOM   1202  CE1 HIS   165      37.316  42.298  15.598  1.00 42.17           C  
ATOM   1203  NE2 HIS   165      36.339  43.132  15.282  1.00 38.86           N  
ATOM   1204  N   ALA   166      34.670  39.761   9.713  1.00 29.21           N  
ATOM   1205  CA  ALA   166      34.785  39.039   8.440  1.00 27.78           C  
ATOM   1206  C   ALA   166      34.761  39.972   7.202  1.00 28.12           C  
ATOM   1207  O   ALA   166      35.191  39.590   6.101  1.00 27.64           O  
ATOM   1208  CB  ALA   166      33.657  38.013   8.319  1.00 28.16           C  
ATOM   1209  N   LEU   167      34.181  41.154   7.385  1.00 27.76           N  
ATOM   1210  CA  LEU   167      33.909  42.072   6.243  1.00 28.29           C  
ATOM   1211  C   LEU   167      35.089  42.928   5.838  1.00 28.89           C  
ATOM   1212  O   LEU   167      34.996  43.721   4.893  1.00 29.42           O  
ATOM   1213  CB  LEU   167      32.699  42.972   6.559  1.00 28.23           C  
ATOM   1214  CG  LEU   167      31.377  42.198   6.723  1.00 29.16           C  
ATOM   1215  CD1 LEU   167      30.264  43.157   7.141  1.00 30.86           C  
ATOM   1216  CD2 LEU   167      30.974  41.514   5.433  1.00 31.02           C  
ATOM   1217  N   TYR   168      36.181  42.851   6.584  1.00 29.08           N  
ATOM   1218  CA  TYR   168      37.362  43.610   6.203  1.00 29.16           C  
ATOM   1219  C   TYR   168      38.611  42.933   6.682  1.00 30.65           C  
ATOM   1220  O   TYR   168      38.532  42.041   7.556  1.00 31.20           O  
ATOM   1221  CB  TYR   168      37.283  45.045   6.777  1.00 29.77           C  
ATOM   1222  CG  TYR   168      37.267  45.129   8.286  1.00 30.36           C  
ATOM   1223  CD1 TYR   168      38.448  45.434   8.984  1.00 31.45           C  
ATOM   1224  CD2 TYR   168      36.073  44.983   9.019  1.00 29.24           C  
ATOM   1225  CE1 TYR   168      38.446  45.562  10.390  1.00 33.32           C  
ATOM   1226  CE2 TYR   168      36.067  45.097  10.426  1.00 31.57           C  
ATOM   1227  CZ  TYR   168      37.261  45.403  11.091  1.00 31.30           C  
ATOM   1228  OH  TYR   168      37.331  45.560  12.468  1.00 33.59           O  
ATOM   1229  N   THR   169      39.767  43.351   6.137  1.00 30.96           N  
ATOM   1230  CA  THR   169      41.046  42.882   6.671  1.00 32.22           C  
ATOM   1231  C   THR   169      41.658  43.951   7.574  1.00 33.24           C  
ATOM   1232  O   THR   169      41.421  45.152   7.383  1.00 32.67           O  
ATOM   1233  CB  THR   169      42.040  42.489   5.574  1.00 33.05           C  
ATOM   1234  OG1 THR   169      42.441  43.657   4.848  1.00 34.24           O  
ATOM   1235  CG2 THR   169      41.399  41.430   4.630  1.00 33.19           C  
ATOM   1236  N   LEU   170      42.417  43.493   8.572  1.00 34.33           N  
ATOM   1237  CA  LEU   170      43.034  44.390   9.538  1.00 35.86           C  
ATOM   1238  C   LEU   170      44.534  44.142   9.567  1.00 37.59           C  
ATOM   1239  O   LEU   170      44.989  43.014   9.849  1.00 37.52           O  
ATOM   1240  CB  LEU   170      42.428  44.186  10.932  1.00 35.38           C  
ATOM   1241  CG  LEU   170      42.996  45.080  12.035  1.00 37.37           C  
ATOM   1242  CD1 LEU   170      42.654  46.542  11.761  1.00 36.76           C  
ATOM   1243  CD2 LEU   170      42.461  44.622  13.416  1.00 37.52           C  
ATOM   1244  N   ASN   171      45.299  45.201   9.310  1.00 38.99           N  
ATOM   1245  CA  ASN   171      46.771  45.129   9.352  1.00 41.68           C  
ATOM   1246  C   ASN   171      47.330  43.921   8.606  1.00 44.00           C  
ATOM   1247  O   ASN   171      48.196  43.205   9.137  1.00 44.05           O  
ATOM   1248  CB  ASN   171      47.273  45.147  10.791  1.00 41.73           C  
ATOM   1249  CG  ASN   171      46.874  46.388  11.510  1.00 43.18           C  
ATOM   1250  OD1 ASN   171      46.695  47.411  10.892  1.00 39.27           O  
ATOM   1251  ND2 ASN   171      46.738  46.310  12.844  1.00 48.21           N  
ATOM   1252  N   GLU   172      46.830  43.701   7.382  1.00 45.89           N  
ATOM   1253  CA  GLU   172      47.212  42.528   6.598  1.00 48.27           C  
ATOM   1254  C   GLU   172      48.677  42.607   6.140  1.00 49.04           C  
ATOM   1255  O   GLU   172      49.118  43.613   5.574  1.00 50.25           O  
ATOM   1256  CB  GLU   172      46.252  42.340   5.419  1.00 49.19           C  
ATOM   1257  CG  GLU   172      46.557  41.146   4.528  1.00 52.20           C  
ATOM   1258  CD  GLU   172      45.302  40.564   3.907  1.00 56.27           C  
ATOM   1259  OE1 GLU   172      45.081  40.756   2.691  1.00 56.29           O  
ATOM   1260  OE2 GLU   172      44.534  39.908   4.647  1.00 59.80           O  
END
