
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  130 ( 1051),  selected  130 , name 2eo0_A
# Molecule2: number of CA atoms  139 ( 1110),  selected  139 , name T0495_5_143.pdb
# PARAMETERS: 2eo0_A.T0495_5_143.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      L       5           -
LGA    -       -      D       6           -
LGA    -       -      L       7           -
LGA    -       -      Q       8           -
LGA    -       -      P       9           -
LGA    -       -      G      10           -
LGA    S    12_A      Q      11          0.566
LGA    S    13_A      R      12          2.067
LGA    V    14_A      L      13          1.831
LGA    E    15_A      A      14          0.697
LGA    R    16_A      R      15          1.655
LGA    Y    17_A      G      16          2.215
LGA    I    18_A      V      17          1.406
LGA    V    19_A      A      18          0.702
LGA    S    20_A      R      19          1.612
LGA    R    21_A      H      20          1.786
LGA    L    22_A      L      21          1.044
LGA    R    23_A      R      22          0.959
LGA    D    24_A      A      23          1.830
LGA    K    25_A      H      24          1.699
LGA    G    26_A      G      25          1.065
LGA    F    27_A      F      26          0.507
LGA    A    28_A      V      27          1.906
LGA    V    29_A      S      28          1.264
LGA    I    30_A      V      29          1.253
LGA    R    31_A      E      30          1.174
LGA    A    32_A      E      31          1.619
LGA    K    38_A      F      32           -
LGA    -       -      V      33           -
LGA    -       -      P      34           -
LGA    -       -      A      35           -
LGA    R    39_A      R      36          5.567
LGA    K    40_A      G      37           #
LGA    D    41_A      -       -           -
LGA    H    42_A      L      38          2.118
LGA    V    43_A      R      39          1.580
LGA    P    44_A      V      40          1.287
LGA    D    45_A      D      41          0.597
LGA    I    46_A      V      42          0.477
LGA    I    47_A      M      43          0.659
LGA    A    48_A      G      44          0.711
LGA    L    49_A      L      45          1.741
LGA    K    50_A      G      46          1.413
LGA    S    51_A      P      47          3.652
LGA    G    52_A      K      48          3.369
LGA    -       -      G      49           -
LGA    V    53_A      E      50          2.402
LGA    I    54_A      I      51          1.879
LGA    I    55_A      W      52          1.294
LGA    L    56_A      V      53          0.568
LGA    I    57_A      I      54          0.548
LGA    E    58_A      E      55          0.843
LGA    V    59_A      C      56          0.648
LGA    K    60_A      K      57          1.355
LGA    S    61_A      S      58          0.812
LGA    R    62_A      S      59          1.387
LGA    K    63_A      -       -           -
LGA    N    64_A      -       -           -
LGA    G    65_A      -       -           -
LGA    K    67_A      R      60          5.858
LGA    I    68_A      A      61          5.434
LGA    -       -      D      62           -
LGA    -       -      F      63           -
LGA    Y    69_A      Q      64          1.577
LGA    I    70_A      A      65          2.826
LGA    E    71_A      D      66          4.263
LGA    K    72_A      A      67          3.601
LGA    E    73_A      -       -           -
LGA    Q    74_A      -       -           -
LGA    A    75_A      K      68          2.128
LGA    E    76_A      W      69           #
LGA    G    77_A      -       -           -
LGA    I    78_A      -       -           -
LGA    R    79_A      Q      70          3.522
LGA    E    80_A      G      71          2.983
LGA    F    81_A      Y      72          4.038
LGA    A    82_A      L      73          2.793
LGA    K    83_A      E      74          0.604
LGA    R    84_A      -       -           -
LGA    S    85_A      W      75          2.605
LGA    G    86_A      C      76          3.774
LGA    G    87_A      D      77          2.231
LGA    E    88_A      R      78          1.489
LGA    L    89_A      Y      79          1.364
LGA    F    90_A      F      80          1.557
LGA    L    91_A      W      81          1.864
LGA    G    92_A      A      82          1.596
LGA    V    93_A      V      83          1.914
LGA    K    94_A      D      84          2.713
LGA    L    95_A      -       -           -
LGA    P    96_A      -       -           -
LGA    K    97_A      -       -           -
LGA    M    98_A      M      85          1.493
LGA    L    99_A      E      86           -
LGA    -       -      F      87           -
LGA    -       -      P      88           -
LGA    R   100_A      A      89           #
LGA    F   101_A      E      90           -
LGA    -       -      L      91           -
LGA    -       -      L      92           -
LGA    -       -      P      93           -
LGA    -       -      A      94           -
LGA    I   102_A      E      95           #
LGA    K   103_A      S      96          1.005
LGA    F   104_A      G      97           #
LGA    D   105_A      -       -           -
LGA    M   106_A      -       -           -
LGA    L   107_A      -       -           -
LGA    R   108_A      -       -           -
LGA    Q   109_A      -       -           -
LGA    T   110_A      -       -           -
LGA    E   111_A      -       -           -
LGA    G   112_A      -       -           -
LGA    G   113_A      -       -           -
LGA    N   114_A      -       -           -
LGA    Y   115_A      -       -           -
LGA    A   116_A      -       -           -
LGA    I   117_A      -       -           -
LGA    D   118_A      -       -           -
LGA    L   119_A      -       -           -
LGA    E   120_A      -       -           -
LGA    T   121_A      -       -           -
LGA    V   122_A      -       -           -
LGA    E   123_A      -       -           -
LGA    K   124_A      -       -           -
LGA    G   125_A      -       -           -
LGA    M   126_A      L      98          4.733
LGA    E   127_A      L      99          4.156
LGA    L   128_A      I     100          4.702
LGA    -       -      A     101           -
LGA    -       -      D     102           -
LGA    -       -      A     103           -
LGA    -       -      Y     104           -
LGA    -       -      D     105           -
LGA    -       -      A     106           -
LGA    E   129_A      E     107          2.660
LGA    D   130_A      I     108          2.868
LGA    L   131_A      V     109          4.664
LGA    -       -      R     110           -
LGA    V   132_A      M     111           #
LGA    R   133_A      -       -           -
LGA    Y   134_A      -       -           -
LGA    V   135_A      A     112           #
LGA    E   136_A      P     113           -
LGA    S   137_A      -       -           -
LGA    K   138_A      E     114           #
LGA    I   139_A      Q     115           -
LGA    S   140_A      K     116           -
LGA    R   141_A      L     117           -
LGA    T   142_A      A     118           -
LGA    L   143_A      P     119           -
LGA    D   144_A      A     120           -
LGA    S   145_A      R     121           -
LGA    F   146_A      R     122           -
LGA    L   147_A      K     123           -
LGA    -       -      V     124           -
LGA    -       -      L     125           -
LGA    -       -      I     126           -
LGA    -       -      Q     127           -
LGA    -       -      K     128           -
LGA    -       -      F     129           -
LGA    -       -      A     130           -
LGA    -       -      T     131           -
LGA    -       -      H     132           -
LGA    -       -      A     133           -
LGA    -       -      A     134           -
LGA    -       -      R     135           -
LGA    -       -      R     136           -
LGA    -       -      L     137           -
LGA    -       -      Q     138           -
LGA    -       -      A     139           -
LGA    -       -      L     140           -
LGA    -       -      R     141           -
LGA    -       -      D     142           -
LGA    -       -      P     143           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  130  139    5.0     73    2.46    23.29     38.183     2.857

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.916226 * X  +  -0.169839 * Y  +  -0.362884 * Z  +  44.447418
  Y_new =   0.393341 * X  +  -0.208949 * Y  +  -0.895334 * Z  +  71.206810
  Z_new =   0.076238 * X  +  -0.963066 * Y  +   0.258249 * Z  +   0.323644 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.308807    1.832786  [ DEG:   -74.9891    105.0109 ]
  Theta =  -0.076312   -3.065280  [ DEG:    -4.3724   -175.6276 ]
  Phi   =   2.736080   -0.405512  [ DEG:   156.7659    -23.2341 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2eo0_A                                        
REMARK     2: T0495_5_143.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2eo0_A.T0495_5_143.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  130  139   5.0   73   2.46   23.29  38.183
REMARK  ---------------------------------------------------------- 
MOLECULE 2eo0_A
HEADER    DNA BINDING PROTEIN                     28-MAR-07   2EO0              
TITLE     CRYSTAL STRUCTURE OF HOLLIDAY JUNCTION RESOLVASE ST1444               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN ST1444;                               
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 SYNONYM: HOLLIDAY JUNCTION RESOLVASE ST1444;                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: SULFOLOBUS TOKODAII;                            
SOURCE   3 ORGANISM_COMMON: ARCHAEA;                                            
SOURCE   4 STRAIN: 7;                                                           
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21 CODON PLUS;                           
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET21A                                    
KEYWDS    HOLLIDAY JUNCTION RESOLVASE, DNA BINDING PROTEIN,                     
KEYWDS   2 STRUCTURAL GENOMICS, NPPSFA, NATIONAL PROJECT ON PROTEIN             
KEYWDS   3 STRUCTURAL AND FUNCTIONAL ANALYSES, RIKEN STRUCTURAL                 
KEYWDS   4 GENOMICS/PROTEOMICS INITIATIVE, RSGI                                 
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    N.SARAI,W.KAGAWA,H.KURUMIZAKA,S.YOKOYAMA,RIKEN STRUCTURAL             
AUTHOR   2 GENOMICS/PROTEOMICS INITIATIVE (RSGI)                                
REVDAT   1   02-OCT-07 2EO0    0                                                
JRNL        AUTH   N.SARAI,W.KAGAWA,H.KURUMIZAKA,S.YOKOYAMA                     
JRNL        TITL   CRYSTAL STRUCTURE OF HOLLIDAY JUNCTION RESOLVASE             
JRNL        TITL 2 ST1444                                                       
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.40 ANGSTROMS.                                          
DBREF  2EO0 A    1   147  UNP    Q971B0   Q971B0_SULTO     1    147             
DBREF  2EO0 B    1   147  UNP    Q971B0   Q971B0_SULTO     1    147             
SEQRES   1 A  147  MET TYR ILE VAL ASN SER ASN LYS SER ARG GLY SER SER          
SEQRES   2 A  147  VAL GLU ARG TYR ILE VAL SER ARG LEU ARG ASP LYS GLY          
SEQRES   3 A  147  PHE ALA VAL ILE ARG ALA PRO ALA SER GLY SER LYS ARG          
SEQRES   4 A  147  LYS ASP HIS VAL PRO ASP ILE ILE ALA LEU LYS SER GLY          
SEQRES   5 A  147  VAL ILE ILE LEU ILE GLU VAL LYS SER ARG LYS ASN GLY          
SEQRES   6 A  147  GLN LYS ILE TYR ILE GLU LYS GLU GLN ALA GLU GLY ILE          
SEQRES   7 A  147  ARG GLU PHE ALA LYS ARG SER GLY GLY GLU LEU PHE LEU          
SEQRES   8 A  147  GLY VAL LYS LEU PRO LYS MET LEU ARG PHE ILE LYS PHE          
SEQRES   9 A  147  ASP MET LEU ARG GLN THR GLU GLY GLY ASN TYR ALA ILE          
SEQRES  10 A  147  ASP LEU GLU THR VAL GLU LYS GLY MET GLU LEU GLU ASP          
SEQRES  11 A  147  LEU VAL ARG TYR VAL GLU SER LYS ILE SER ARG THR LEU          
SEQRES  12 A  147  ASP SER PHE LEU                                              
SEQRES   1 B  147  MET TYR ILE VAL ASN SER ASN LYS SER ARG GLY SER SER          
SEQRES   2 B  147  VAL GLU ARG TYR ILE VAL SER ARG LEU ARG ASP LYS GLY          
SEQRES   3 B  147  PHE ALA VAL ILE ARG ALA PRO ALA SER GLY SER LYS ARG          
SEQRES   4 B  147  LYS ASP HIS VAL PRO ASP ILE ILE ALA LEU LYS SER GLY          
SEQRES   5 B  147  VAL ILE ILE LEU ILE GLU VAL LYS SER ARG LYS ASN GLY          
SEQRES   6 B  147  GLN LYS ILE TYR ILE GLU LYS GLU GLN ALA GLU GLY ILE          
SEQRES   7 B  147  ARG GLU PHE ALA LYS ARG SER GLY GLY GLU LEU PHE LEU          
SEQRES   8 B  147  GLY VAL LYS LEU PRO LYS MET LEU ARG PHE ILE LYS PHE          
SEQRES   9 B  147  ASP MET LEU ARG GLN THR GLU GLY GLY ASN TYR ALA ILE          
SEQRES  10 B  147  ASP LEU GLU THR VAL GLU LYS GLY MET GLU LEU GLU ASP          
SEQRES  11 B  147  LEU VAL ARG TYR VAL GLU SER LYS ILE SER ARG THR LEU          
SEQRES  12 B  147  ASP SER PHE LEU                                              
CRYST1   44.661   49.326   69.894  90.00 103.28  90.00 P 1 21 1      4          
ATOM      1  N   SER A  12      44.758  34.367   8.429  1.00 63.40           N  
ATOM      2  CA  SER A  12      46.159  34.079   7.980  1.00 64.27           C  
ATOM      3  C   SER A  12      46.088  33.604   6.547  1.00 60.24           C  
ATOM      4  O   SER A  12      46.639  34.241   5.652  1.00 60.43           O  
ATOM      5  CB  SER A  12      46.813  32.992   8.839  1.00 63.32           C  
ATOM      6  OG  SER A  12      48.132  32.721   8.377  1.00 65.74           O  
ATOM      7  N   SER A  13      45.420  32.471   6.331  1.00 53.63           N  
ATOM      8  CA  SER A  13      45.255  31.957   4.980  1.00 47.68           C  
ATOM      9  C   SER A  13      44.388  33.000   4.259  1.00 45.71           C  
ATOM     10  O   SER A  13      44.574  33.275   3.064  1.00 34.37           O  
ATOM     11  CB  SER A  13      44.545  30.592   4.991  1.00 48.55           C  
ATOM     12  OG  SER A  13      43.178  30.720   5.323  1.00 42.19           O  
ATOM     13  N   VAL A  14      43.456  33.584   5.012  1.00 29.60           N  
ATOM     14  CA  VAL A  14      42.554  34.593   4.485  1.00 37.34           C  
ATOM     15  C   VAL A  14      43.342  35.848   4.100  1.00 43.26           C  
ATOM     16  O   VAL A  14      43.086  36.445   3.044  1.00 42.79           O  
ATOM     17  CB  VAL A  14      41.443  34.945   5.525  1.00 37.57           C  
ATOM     18  CG1 VAL A  14      40.554  36.079   5.015  1.00 38.52           C  
ATOM     19  CG2 VAL A  14      40.612  33.743   5.789  1.00 31.45           C  
ATOM     20  N   GLU A  15      44.294  36.237   4.954  1.00 39.89           N  
ATOM     21  CA  GLU A  15      45.151  37.405   4.707  1.00 37.91           C  
ATOM     22  C   GLU A  15      45.989  37.144   3.465  1.00 39.04           C  
ATOM     23  O   GLU A  15      46.121  38.015   2.592  1.00 34.31           O  
ATOM     24  CB  GLU A  15      46.112  37.645   5.880  1.00 35.33           C  
ATOM     25  CG  GLU A  15      45.582  38.552   6.947  1.00 47.43           C  
ATOM     26  CD  GLU A  15      45.836  38.031   8.348  1.00 53.85           C  
ATOM     27  OE1 GLU A  15      45.087  37.141   8.805  1.00 51.06           O  
ATOM     28  OE2 GLU A  15      46.783  38.519   8.996  1.00 61.08           O  
ATOM     29  N   ARG A  16      46.563  35.940   3.426  1.00 35.12           N  
ATOM     30  CA  ARG A  16      47.407  35.495   2.332  1.00 36.73           C  
ATOM     31  C   ARG A  16      46.622  35.493   1.041  1.00 35.15           C  
ATOM     32  O   ARG A  16      47.097  35.942  -0.009  1.00 31.46           O  
ATOM     33  CB  ARG A  16      47.913  34.082   2.583  1.00 41.39           C  
ATOM     34  CG  ARG A  16      49.098  33.937   3.525  1.00 39.68           C  
ATOM     35  CD  ARG A  16      49.721  32.580   3.227  1.00 49.72           C  
ATOM     36  NE  ARG A  16      50.962  32.323   3.940  1.00 54.80           N  
ATOM     37  CZ  ARG A  16      51.053  32.289   5.260  1.00 63.03           C  
ATOM     38  NH1 ARG A  16      49.971  32.500   6.003  1.00 54.31           N  
ATOM     39  NH2 ARG A  16      52.226  32.045   5.833  1.00 61.50           N  
ATOM     40  N   TYR A  17      45.405  34.977   1.116  1.00 33.68           N  
ATOM     41  CA  TYR A  17      44.587  34.947  -0.072  1.00 32.62           C  
ATOM     42  C   TYR A  17      44.295  36.395  -0.475  1.00 25.38           C  
ATOM     43  O   TYR A  17      44.369  36.737  -1.644  1.00 34.31           O  
ATOM     44  CB  TYR A  17      43.291  34.172   0.176  1.00 35.39           C  
ATOM     45  CG  TYR A  17      42.351  34.249  -0.997  1.00 35.54           C  
ATOM     46  CD1 TYR A  17      42.559  33.463  -2.133  1.00 29.20           C  
ATOM     47  CD2 TYR A  17      41.324  35.193  -1.019  1.00 26.99           C  
ATOM     48  CE1 TYR A  17      41.774  33.630  -3.267  1.00 33.65           C  
ATOM     49  CE2 TYR A  17      40.543  35.368  -2.136  1.00 32.62           C  
ATOM     50  CZ  TYR A  17      40.777  34.589  -3.264  1.00 32.59           C  
ATOM     51  OH  TYR A  17      40.047  34.814  -4.395  1.00 31.35           O  
ATOM     52  N   ILE A  18      43.999  37.257   0.491  1.00 27.95           N  
ATOM     53  CA  ILE A  18      43.700  38.644   0.151  1.00 25.63           C  
ATOM     54  C   ILE A  18      44.919  39.313  -0.508  1.00 34.65           C  
ATOM     55  O   ILE A  18      44.781  40.086  -1.465  1.00 33.74           O  
ATOM     56  CB  ILE A  18      43.312  39.438   1.396  1.00 36.17           C  
ATOM     57  CG1 ILE A  18      42.007  38.899   1.974  1.00 37.96           C  
ATOM     58  CG2 ILE A  18      43.186  40.937   1.058  1.00 28.51           C  
ATOM     59  CD1 ILE A  18      41.664  39.482   3.336  1.00 33.75           C  
ATOM     60  N   VAL A  19      46.105  39.000   0.012  1.00 31.89           N  
ATOM     61  CA  VAL A  19      47.337  39.551  -0.502  1.00 30.40           C  
ATOM     62  C   VAL A  19      47.449  39.165  -1.970  1.00 36.16           C  
ATOM     63  O   VAL A  19      47.636  40.036  -2.826  1.00 40.41           O  
ATOM     64  CB  VAL A  19      48.554  39.020   0.306  1.00 31.96           C  
ATOM     65  CG1 VAL A  19      49.854  39.422  -0.376  1.00 29.30           C  
ATOM     66  CG2 VAL A  19      48.537  39.600   1.713  1.00 26.80           C  
ATOM     67  N   SER A  20      47.318  37.868  -2.255  1.00 32.17           N  
ATOM     68  CA  SER A  20      47.378  37.360  -3.624  1.00 29.99           C  
ATOM     69  C   SER A  20      46.486  38.142  -4.562  1.00 38.75           C  
ATOM     70  O   SER A  20      46.901  38.537  -5.653  1.00 46.94           O  
ATOM     71  CB  SER A  20      46.935  35.902  -3.673  1.00 38.35           C  
ATOM     72  OG  SER A  20      47.971  35.069  -3.200  1.00 45.67           O  
ATOM     73  N   ARG A  21      45.247  38.358  -4.151  1.00 27.85           N  
ATOM     74  CA  ARG A  21      44.331  39.071  -5.011  1.00 32.84           C  
ATOM     75  C   ARG A  21      44.729  40.536  -5.231  1.00 35.12           C  
ATOM     76  O   ARG A  21      44.554  41.071  -6.328  1.00 36.66           O  
ATOM     77  CB  ARG A  21      42.907  38.970  -4.438  1.00 35.86           C  
ATOM     78  CG  ARG A  21      42.344  37.526  -4.364  1.00 32.03           C  
ATOM     79  CD  ARG A  21      42.377  36.870  -5.748  1.00 36.94           C  
ATOM     80  NE  ARG A  21      41.481  37.519  -6.706  1.00 29.93           N  
ATOM     81  CZ  ARG A  21      41.783  37.741  -7.986  1.00 48.10           C  
ATOM     82  NH1 ARG A  21      42.974  37.375  -8.486  1.00 35.33           N  
ATOM     83  NH2 ARG A  21      40.885  38.314  -8.784  1.00 47.59           N  
ATOM     84  N   LEU A  22      45.267  41.183  -4.197  1.00 32.68           N  
ATOM     85  CA  LEU A  22      45.667  42.581  -4.315  1.00 34.48           C  
ATOM     86  C   LEU A  22      46.884  42.687  -5.229  1.00 37.11           C  
ATOM     87  O   LEU A  22      46.998  43.613  -6.024  1.00 33.05           O  
ATOM     88  CB  LEU A  22      45.981  43.173  -2.929  1.00 31.62           C  
ATOM     89  CG  LEU A  22      44.775  43.388  -2.000  1.00 34.84           C  
ATOM     90  CD1 LEU A  22      45.206  43.898  -0.630  1.00 26.62           C  
ATOM     91  CD2 LEU A  22      43.815  44.358  -2.650  1.00 29.13           C  
ATOM     92  N   ARG A  23      47.797  41.728  -5.111  1.00 36.02           N  
ATOM     93  CA  ARG A  23      48.971  41.732  -5.963  1.00 34.84           C  
ATOM     94  C   ARG A  23      48.537  41.535  -7.411  1.00 34.64           C  
ATOM     95  O   ARG A  23      48.997  42.258  -8.281  1.00 34.73           O  
ATOM     96  CB  ARG A  23      49.978  40.650  -5.518  1.00 37.90           C  
ATOM     97  CG  ARG A  23      50.955  41.173  -4.459  1.00 34.38           C  
ATOM     98  CD  ARG A  23      51.807  40.099  -3.792  1.00 34.27           C  
ATOM     99  NE  ARG A  23      52.504  40.668  -2.644  1.00 33.80           N  
ATOM    100  CZ  ARG A  23      53.093  39.969  -1.675  1.00 49.85           C  
ATOM    101  NH1 ARG A  23      53.074  38.640  -1.705  1.00 52.58           N  
ATOM    102  NH2 ARG A  23      53.706  40.596  -0.668  1.00 34.79           N  
ATOM    103  N   ASP A  24      47.634  40.586  -7.666  1.00 38.33           N  
ATOM    104  CA  ASP A  24      47.155  40.354  -9.031  1.00 38.25           C  
ATOM    105  C   ASP A  24      46.510  41.614  -9.602  1.00 38.57           C  
ATOM    106  O   ASP A  24      46.553  41.844 -10.802  1.00 40.12           O  
ATOM    107  CB  ASP A  24      46.119  39.216  -9.094  1.00 42.00           C  
ATOM    108  CG  ASP A  24      46.695  37.875  -8.699  1.00 39.16           C  
ATOM    109  OD1 ASP A  24      47.879  37.645  -8.980  1.00 43.93           O  
ATOM    110  OD2 ASP A  24      45.969  37.049  -8.120  1.00 44.36           O  
ATOM    111  N   LYS A  25      45.905  42.432  -8.754  1.00 38.35           N  
ATOM    112  CA  LYS A  25      45.261  43.637  -9.253  1.00 40.69           C  
ATOM    113  C   LYS A  25      46.215  44.844  -9.266  1.00 47.13           C  
ATOM    114  O   LYS A  25      45.798  46.007  -9.302  1.00 33.93           O  
ATOM    115  CB  LYS A  25      43.988  43.917  -8.441  1.00 46.69           C  
ATOM    116  CG  LYS A  25      42.850  42.874  -8.659  1.00 51.41           C  
ATOM    117  CD  LYS A  25      42.497  42.751 -10.159  1.00 62.02           C  
ATOM    118  CE  LYS A  25      41.090  42.183 -10.439  1.00 60.56           C  
ATOM    119  NZ  LYS A  25      40.889  40.741 -10.115  1.00 58.56           N  
ATOM    120  N   GLY A  26      47.510  44.539  -9.244  1.00 44.64           N  
ATOM    121  CA  GLY A  26      48.514  45.576  -9.301  1.00 39.74           C  
ATOM    122  C   GLY A  26      48.931  46.273  -8.024  1.00 39.92           C  
ATOM    123  O   GLY A  26      49.587  47.299  -8.096  1.00 44.20           O  
ATOM    124  N   PHE A  27      48.586  45.753  -6.856  1.00 36.69           N  
ATOM    125  CA  PHE A  27      48.997  46.444  -5.634  1.00 37.46           C  
ATOM    126  C   PHE A  27      50.391  46.053  -5.201  1.00 29.02           C  
ATOM    127  O   PHE A  27      50.907  45.017  -5.603  1.00 32.40           O  
ATOM    128  CB  PHE A  27      48.047  46.145  -4.461  1.00 32.38           C  
ATOM    129  CG  PHE A  27      46.731  46.844  -4.545  1.00 28.45           C  
ATOM    130  CD1 PHE A  27      45.779  46.459  -5.483  1.00 35.67           C  
ATOM    131  CD2 PHE A  27      46.428  47.871  -3.667  1.00 30.82           C  
ATOM    132  CE1 PHE A  27      44.541  47.085  -5.546  1.00 33.24           C  
ATOM    133  CE2 PHE A  27      45.191  48.508  -3.721  1.00 37.34           C  
ATOM    134  CZ  PHE A  27      44.242  48.113  -4.666  1.00 34.17           C  
ATOM    135  N   ALA A  28      50.994  46.912  -4.387  1.00 37.61           N  
ATOM    136  CA  ALA A  28      52.310  46.656  -3.787  1.00 30.46           C  
ATOM    137  C   ALA A  28      51.785  46.254  -2.423  1.00 29.03           C  
ATOM    138  O   ALA A  28      51.135  47.053  -1.755  1.00 26.06           O  
ATOM    139  CB  ALA A  28      53.113  47.938  -3.694  1.00 34.67           C  
ATOM    140  N   VAL A  29      52.033  45.016  -2.014  1.00 36.93           N  
ATOM    141  CA  VAL A  29      51.465  44.542  -0.761  1.00 33.26           C  
ATOM    142  C   VAL A  29      52.399  43.848   0.202  1.00 34.64           C  
ATOM    143  O   VAL A  29      53.246  43.074  -0.224  1.00 42.36           O  
ATOM    144  CB  VAL A  29      50.339  43.541  -1.054  1.00 36.91           C  
ATOM    145  CG1 VAL A  29      49.561  43.234   0.235  1.00 35.09           C  
ATOM    146  CG2 VAL A  29      49.452  44.065  -2.179  1.00 32.86           C  
ATOM    147  N   ILE A  30      52.237  44.110   1.500  1.00 39.53           N  
ATOM    148  CA  ILE A  30      53.046  43.417   2.514  1.00 44.40           C  
ATOM    149  C   ILE A  30      52.212  43.028   3.758  1.00 49.51           C  
ATOM    150  O   ILE A  30      51.139  43.591   4.006  1.00 41.09           O  
ATOM    151  CB  ILE A  30      54.294  44.236   2.966  1.00 44.86           C  
ATOM    152  CG1 ILE A  30      53.907  45.319   3.964  1.00 32.00           C  
ATOM    153  CG2 ILE A  30      54.982  44.861   1.737  1.00 45.13           C  
ATOM    154  CD1 ILE A  30      53.397  46.561   3.296  1.00 60.12           C  
ATOM    155  N   ARG A  31      52.720  42.071   4.533  1.00 50.20           N  
ATOM    156  CA  ARG A  31      52.029  41.588   5.721  1.00 54.82           C  
ATOM    157  C   ARG A  31      52.660  41.880   7.075  1.00 62.21           C  
ATOM    158  O   ARG A  31      53.399  42.850   7.245  1.00 65.87           O  
ATOM    159  CB  ARG A  31      51.798  40.086   5.611  1.00 48.41           C  
ATOM    160  CG  ARG A  31      50.609  39.693   4.771  1.00 43.48           C  
ATOM    161  CD  ARG A  31      50.528  38.191   4.725  1.00 40.75           C  
ATOM    162  NE  ARG A  31      50.328  37.630   6.056  1.00 45.84           N  
ATOM    163  CZ  ARG A  31      50.947  36.540   6.502  1.00 55.33           C  
ATOM    164  NH1 ARG A  31      51.812  35.894   5.725  1.00 50.33           N  
ATOM    165  NH2 ARG A  31      50.693  36.092   7.722  1.00 52.67           N  
ATOM    166  N   ALA A  32      52.352  41.023   8.048  1.00 69.23           N  
ATOM    167  CA  ALA A  32      52.855  41.198   9.400  1.00 68.69           C  
ATOM    168  C   ALA A  32      52.241  42.497   9.914  1.00 74.09           C  
ATOM    169  O   ALA A  32      51.613  43.204   9.088  1.00 62.99           O  
ATOM    170  CB  ALA A  32      54.379  41.300   9.394  1.00 61.19           C  
ATOM    171  N   LYS A  38      55.920  41.817  18.303  1.00 67.50           N  
ATOM    172  CA  LYS A  38      56.105  42.692  19.511  1.00 66.82           C  
ATOM    173  C   LYS A  38      54.985  43.739  19.613  1.00 63.70           C  
ATOM    174  O   LYS A  38      54.273  43.807  20.617  1.00 57.00           O  
ATOM    175  CB  LYS A  38      57.467  43.402  19.443  1.00 75.40           C  
ATOM    176  CG  LYS A  38      57.651  44.297  18.213  1.00 80.53           C  
ATOM    177  CD  LYS A  38      57.983  45.755  18.567  1.00 75.12           C  
ATOM    178  CE  LYS A  38      59.445  45.941  18.963  1.00 77.95           C  
ATOM    179  NZ  LYS A  38      59.820  47.396  19.008  1.00 78.77           N  
ATOM    180  N   ARG A  39      54.844  44.560  18.573  1.00 57.13           N  
ATOM    181  CA  ARG A  39      53.811  45.587  18.529  1.00 53.35           C  
ATOM    182  C   ARG A  39      52.753  45.126  17.532  1.00 49.84           C  
ATOM    183  O   ARG A  39      51.891  45.886  17.097  1.00 47.86           O  
ATOM    184  CB  ARG A  39      54.409  46.917  18.080  1.00 61.17           C  
ATOM    185  CG  ARG A  39      55.087  46.876  16.711  1.00 56.78           C  
ATOM    186  CD  ARG A  39      55.503  48.272  16.314  1.00 49.94           C  
ATOM    187  NE  ARG A  39      56.283  48.895  17.371  1.00 41.47           N  
ATOM    188  CZ  ARG A  39      56.331  50.203  17.571  1.00 48.30           C  
ATOM    189  NH1 ARG A  39      55.642  51.021  16.786  1.00 49.19           N  
ATOM    190  NH2 ARG A  39      57.064  50.693  18.557  1.00 56.43           N  
ATOM    191  N   LYS A  40      52.851  43.856  17.188  1.00 43.37           N  
ATOM    192  CA  LYS A  40      51.970  43.194  16.255  1.00 46.87           C  
ATOM    193  C   LYS A  40      50.475  43.560  16.329  1.00 51.00           C  
ATOM    194  O   LYS A  40      49.876  43.903  15.310  1.00 51.71           O  
ATOM    195  CB  LYS A  40      52.177  41.683  16.425  1.00 46.30           C  
ATOM    196  CG  LYS A  40      51.181  40.788  15.731  1.00 56.25           C  
ATOM    197  CD  LYS A  40      51.830  39.448  15.328  1.00 56.23           C  
ATOM    198  CE  LYS A  40      52.730  38.847  16.419  1.00 62.76           C  
ATOM    199  NZ  LYS A  40      52.001  38.370  17.642  1.00 63.69           N  
ATOM    200  N   ASP A  41      49.869  43.502  17.514  1.00 49.63           N  
ATOM    201  CA  ASP A  41      48.446  43.803  17.617  1.00 38.89           C  
ATOM    202  C   ASP A  41      48.032  45.198  17.201  1.00 40.33           C  
ATOM    203  O   ASP A  41      46.858  45.436  16.964  1.00 43.55           O  
ATOM    204  CB  ASP A  41      47.931  43.517  19.020  1.00 43.54           C  
ATOM    205  CG  ASP A  41      47.956  42.032  19.358  1.00 52.42           C  
ATOM    206  OD1 ASP A  41      47.695  41.204  18.458  1.00 52.36           O  
ATOM    207  OD2 ASP A  41      48.222  41.685  20.529  1.00 62.50           O  
ATOM    208  N   HIS A  42      48.974  46.130  17.101  1.00 40.37           N  
ATOM    209  CA  HIS A  42      48.604  47.476  16.674  1.00 35.50           C  
ATOM    210  C   HIS A  42      49.055  47.824  15.268  1.00 36.23           C  
ATOM    211  O   HIS A  42      49.043  48.987  14.885  1.00 34.67           O  
ATOM    212  CB  HIS A  42      49.099  48.524  17.662  1.00 29.93           C  
ATOM    213  CG  HIS A  42      48.485  48.384  19.013  1.00 43.29           C  
ATOM    214  ND1 HIS A  42      48.668  49.304  20.016  1.00 39.37           N  
ATOM    215  CD2 HIS A  42      47.680  47.424  19.521  1.00 34.28           C  
ATOM    216  CE1 HIS A  42      48.000  48.918  21.085  1.00 40.70           C  
ATOM    217  NE2 HIS A  42      47.391  47.781  20.809  1.00 41.82           N  
ATOM    218  N   VAL A  43      49.447  46.811  14.498  1.00 39.64           N  
ATOM    219  CA  VAL A  43      49.837  47.029  13.108  1.00 38.86           C  
ATOM    220  C   VAL A  43      48.802  46.339  12.224  1.00 35.19           C  
ATOM    221  O   VAL A  43      48.504  45.156  12.421  1.00 42.03           O  
ATOM    222  CB  VAL A  43      51.236  46.442  12.809  1.00 40.92           C  
ATOM    223  CG1 VAL A  43      52.300  47.114  13.708  1.00 26.04           C  
ATOM    224  CG2 VAL A  43      51.216  44.922  13.042  1.00 47.76           C  
ATOM    225  N   PRO A  44      48.219  47.063  11.254  1.00 31.54           N  
ATOM    226  CA  PRO A  44      47.218  46.440  10.363  1.00 33.54           C  
ATOM    227  C   PRO A  44      47.780  45.132   9.795  1.00 33.48           C  
ATOM    228  O   PRO A  44      48.982  45.025   9.516  1.00 26.84           O  
ATOM    229  CB  PRO A  44      47.006  47.493   9.277  1.00 34.98           C  
ATOM    230  CG  PRO A  44      47.210  48.779  10.015  1.00 38.82           C  
ATOM    231  CD  PRO A  44      48.437  48.470  10.901  1.00 32.36           C  
ATOM    232  N   ASP A  45      46.924  44.135   9.623  1.00 29.21           N  
ATOM    233  CA  ASP A  45      47.406  42.851   9.131  1.00 31.76           C  
ATOM    234  C   ASP A  45      47.901  42.925   7.721  1.00 39.15           C  
ATOM    235  O   ASP A  45      48.819  42.195   7.327  1.00 37.57           O  
ATOM    236  CB  ASP A  45      46.305  41.798   9.226  1.00 40.07           C  
ATOM    237  CG  ASP A  45      45.788  41.647  10.633  1.00 37.28           C  
ATOM    238  OD1 ASP A  45      46.588  41.919  11.566  1.00 36.67           O  
ATOM    239  OD2 ASP A  45      44.607  41.266  10.801  1.00 31.82           O  
ATOM    240  N   ILE A  46      47.281  43.820   6.960  1.00 40.78           N  
ATOM    241  CA  ILE A  46      47.626  43.995   5.570  1.00 35.74           C  
ATOM    242  C   ILE A  46      47.786  45.456   5.250  1.00 37.89           C  
ATOM    243  O   ILE A  46      46.958  46.276   5.620  1.00 36.91           O  
ATOM    244  CB  ILE A  46      46.516  43.449   4.638  1.00 38.80           C  
ATOM    245  CG1 ILE A  46      46.322  41.943   4.876  1.00 27.73           C  
ATOM    246  CG2 ILE A  46      46.882  43.746   3.165  1.00 24.70           C  
ATOM    247  CD1 ILE A  46      45.131  41.390   4.156  1.00 26.86           C  
ATOM    248  N   ILE A  47      48.854  45.763   4.534  1.00 36.13           N  
ATOM    249  CA  ILE A  47      49.121  47.115   4.111  1.00 36.35           C  
ATOM    250  C   ILE A  47      49.260  46.999   2.615  1.00 30.64           C  
ATOM    251  O   ILE A  47      50.162  46.318   2.116  1.00 30.09           O  
ATOM    252  CB  ILE A  47      50.421  47.651   4.740  1.00 39.34           C  
ATOM    253  CG1 ILE A  47      50.217  47.805   6.244  1.00 27.83           C  
ATOM    254  CG2 ILE A  47      50.813  48.943   4.068  1.00 27.71           C  
ATOM    255  CD1 ILE A  47      51.402  48.339   6.981  1.00 38.17           C  
ATOM    256  N   ALA A  48      48.362  47.669   1.909  1.00 31.47           N  
ATOM    257  CA  ALA A  48      48.334  47.612   0.451  1.00 31.48           C  
ATOM    258  C   ALA A  48      48.457  49.004  -0.192  1.00 34.72           C  
ATOM    259  O   ALA A  48      47.683  49.908   0.117  1.00 27.56           O  
ATOM    260  CB  ALA A  48      47.033  46.917   0.002  1.00 19.79           C  
ATOM    261  N   LEU A  49      49.430  49.152  -1.096  1.00 29.44           N  
ATOM    262  CA  LEU A  49      49.671  50.419  -1.774  1.00 29.03           C  
ATOM    263  C   LEU A  49      49.498  50.303  -3.284  1.00 31.48           C  
ATOM    264  O   LEU A  49      49.843  49.290  -3.903  1.00 25.07           O  
ATOM    265  CB  LEU A  49      51.102  50.912  -1.493  1.00 27.60           C  
ATOM    266  CG  LEU A  49      51.661  50.564  -0.112  1.00 29.63           C  
ATOM    267  CD1 LEU A  49      53.197  50.564  -0.167  1.00 29.42           C  
ATOM    268  CD2 LEU A  49      51.117  51.538   0.918  1.00 27.60           C  
ATOM    269  N   LYS A  50      48.955  51.357  -3.867  1.00 29.32           N  
ATOM    270  CA  LYS A  50      48.776  51.377  -5.288  1.00 33.73           C  
ATOM    271  C   LYS A  50      48.566  52.796  -5.764  1.00 33.24           C  
ATOM    272  O   LYS A  50      47.645  53.483  -5.316  1.00 38.55           O  
ATOM    273  CB  LYS A  50      47.584  50.509  -5.723  1.00 30.34           C  
ATOM    274  CG  LYS A  50      47.435  50.470  -7.255  1.00 24.02           C  
ATOM    275  CD  LYS A  50      46.331  49.522  -7.748  1.00 34.32           C  
ATOM    276  CE  LYS A  50      46.270  49.540  -9.289  1.00 39.16           C  
ATOM    277  NZ  LYS A  50      45.293  48.560  -9.861  1.00 28.67           N  
ATOM    278  N   SER A  51      49.438  53.235  -6.663  1.00 31.97           N  
ATOM    279  CA  SER A  51      49.325  54.568  -7.237  1.00 32.69           C  
ATOM    280  C   SER A  51      49.212  55.705  -6.219  1.00 26.56           C  
ATOM    281  O   SER A  51      48.481  56.647  -6.425  1.00 30.58           O  
ATOM    282  CB  SER A  51      48.119  54.585  -8.182  1.00 40.95           C  
ATOM    283  OG  SER A  51      48.095  53.408  -9.001  1.00 43.17           O  
ATOM    284  N   GLY A  52      49.961  55.644  -5.125  1.00 31.56           N  
ATOM    285  CA  GLY A  52      49.858  56.715  -4.158  1.00 25.93           C  
ATOM    286  C   GLY A  52      48.731  56.572  -3.134  1.00 36.39           C  
ATOM    287  O   GLY A  52      48.656  57.389  -2.204  1.00 35.26           O  
ATOM    288  N   VAL A  53      47.842  55.583  -3.280  1.00 31.67           N  
ATOM    289  CA  VAL A  53      46.777  55.407  -2.287  1.00 33.09           C  
ATOM    290  C   VAL A  53      47.167  54.298  -1.302  1.00 26.14           C  
ATOM    291  O   VAL A  53      47.704  53.256  -1.683  1.00 35.39           O  
ATOM    292  CB  VAL A  53      45.398  55.094  -2.950  1.00 45.98           C  
ATOM    293  CG1 VAL A  53      44.358  54.708  -1.881  1.00 35.81           C  
ATOM    294  CG2 VAL A  53      44.898  56.324  -3.699  1.00 33.41           C  
ATOM    295  N   ILE A  54      46.921  54.555  -0.027  1.00 30.10           N  
ATOM    296  CA  ILE A  54      47.267  53.631   1.050  1.00 32.19           C  
ATOM    297  C   ILE A  54      46.024  52.975   1.624  1.00 36.96           C  
ATOM    298  O   ILE A  54      45.111  53.679   2.082  1.00 36.26           O  
ATOM    299  CB  ILE A  54      47.922  54.385   2.251  1.00 40.31           C  
ATOM    300  CG1 ILE A  54      49.157  55.180   1.804  1.00 30.45           C  
ATOM    301  CG2 ILE A  54      48.255  53.409   3.371  1.00 32.29           C  
ATOM    302  CD1 ILE A  54      49.668  56.170   2.920  1.00 27.93           C  
ATOM    303  N   ILE A  55      45.969  51.648   1.614  1.00 28.80           N  
ATOM    304  CA  ILE A  55      44.822  50.987   2.224  1.00 36.27           C  
ATOM    305  C   ILE A  55      45.281  49.990   3.278  1.00 41.88           C  
ATOM    306  O   ILE A  55      46.135  49.118   3.046  1.00 44.14           O  
ATOM    307  CB  ILE A  55      43.881  50.323   1.186  1.00 40.81           C  
ATOM    308  CG1 ILE A  55      44.645  49.317   0.348  1.00 51.07           C  
ATOM    309  CG2 ILE A  55      43.272  51.414   0.250  1.00 29.29           C  
ATOM    310  CD1 ILE A  55      43.761  48.631  -0.680  1.00 61.56           C  
ATOM    311  N   LEU A  56      44.733  50.169   4.469  1.00 35.48           N  
ATOM    312  CA  LEU A  56      45.078  49.332   5.589  1.00 40.75           C  
ATOM    313  C   LEU A  56      43.935  48.359   5.875  1.00 43.31           C  
ATOM    314  O   LEU A  56      42.752  48.742   5.856  1.00 42.11           O  
ATOM    315  CB  LEU A  56      45.360  50.240   6.784  1.00 39.51           C  
ATOM    316  CG  LEU A  56      46.393  51.350   6.492  1.00 33.22           C  
ATOM    317  CD1 LEU A  56      46.539  52.290   7.687  1.00 26.07           C  
ATOM    318  CD2 LEU A  56      47.724  50.708   6.155  1.00 23.51           C  
ATOM    319  N   ILE A  57      44.273  47.095   6.110  1.00 33.50           N  
ATOM    320  CA  ILE A  57      43.239  46.123   6.391  1.00 31.11           C  
ATOM    321  C   ILE A  57      43.555  45.220   7.554  1.00 33.36           C  
ATOM    322  O   ILE A  57      44.603  44.585   7.613  1.00 41.38           O  
ATOM    323  CB  ILE A  57      42.944  45.225   5.177  1.00 33.89           C  
ATOM    324  CG1 ILE A  57      42.705  46.080   3.925  1.00 26.42           C  
ATOM    325  CG2 ILE A  57      41.704  44.367   5.461  1.00 22.53           C  
ATOM    326  CD1 ILE A  57      42.693  45.272   2.657  1.00 34.74           C  
ATOM    327  N   GLU A  58      42.623  45.175   8.489  1.00 38.63           N  
ATOM    328  CA  GLU A  58      42.728  44.327   9.658  1.00 28.21           C  
ATOM    329  C   GLU A  58      41.743  43.187   9.342  1.00 28.64           C  
ATOM    330  O   GLU A  58      40.581  43.416   9.009  1.00 27.45           O  
ATOM    331  CB  GLU A  58      42.315  45.145  10.888  1.00 34.18           C  
ATOM    332  CG  GLU A  58      42.453  44.468  12.244  1.00 40.77           C  
ATOM    333  CD  GLU A  58      43.832  43.912  12.521  1.00 37.66           C  
ATOM    334  OE1 GLU A  58      44.832  44.520  12.076  1.00 41.79           O  
ATOM    335  OE2 GLU A  58      43.901  42.861  13.203  1.00 44.02           O  
ATOM    336  N   VAL A  59      42.228  41.960   9.407  1.00 31.57           N  
ATOM    337  CA  VAL A  59      41.404  40.811   9.109  1.00 29.35           C  
ATOM    338  C   VAL A  59      41.056  39.971  10.329  1.00 28.16           C  
ATOM    339  O   VAL A  59      41.922  39.560  11.080  1.00 33.81           O  
ATOM    340  CB  VAL A  59      42.098  39.904   8.075  1.00 41.50           C  
ATOM    341  CG1 VAL A  59      41.169  38.725   7.705  1.00 35.09           C  
ATOM    342  CG2 VAL A  59      42.497  40.735   6.848  1.00 32.94           C  
ATOM    343  N   LYS A  60      39.768  39.709  10.512  1.00 34.69           N  
ATOM    344  CA  LYS A  60      39.308  38.896  11.635  1.00 36.38           C  
ATOM    345  C   LYS A  60      38.471  37.750  11.107  1.00 32.91           C  
ATOM    346  O   LYS A  60      37.825  37.865  10.059  1.00 38.70           O  
ATOM    347  CB  LYS A  60      38.465  39.727  12.622  1.00 37.20           C  
ATOM    348  CG  LYS A  60      39.158  40.062  13.935  1.00 40.75           C  
ATOM    349  CD  LYS A  60      39.962  41.344  13.843  1.00 48.26           C  
ATOM    350  CE  LYS A  60      40.510  41.764  15.196  1.00 31.14           C  
ATOM    351  NZ  LYS A  60      41.540  40.816  15.673  1.00 49.24           N  
ATOM    352  N   SER A  61      38.502  36.637  11.829  1.00 35.46           N  
ATOM    353  CA  SER A  61      37.724  35.457  11.473  1.00 42.75           C  
ATOM    354  C   SER A  61      36.658  35.227  12.538  1.00 39.60           C  
ATOM    355  O   SER A  61      36.976  34.974  13.696  1.00 53.37           O  
ATOM    356  CB  SER A  61      38.625  34.222  11.377  1.00 45.22           C  
ATOM    357  OG  SER A  61      37.850  33.028  11.330  1.00 56.28           O  
ATOM    358  N   ARG A  62      35.392  35.331  12.149  1.00 46.48           N  
ATOM    359  CA  ARG A  62      34.274  35.123  13.079  1.00 44.99           C  
ATOM    360  C   ARG A  62      33.296  34.102  12.494  1.00 44.90           C  
ATOM    361  O   ARG A  62      32.880  34.216  11.346  1.00 38.82           O  
ATOM    362  CB  ARG A  62      33.546  36.436  13.332  1.00 46.83           C  
ATOM    363  CG  ARG A  62      34.416  37.530  13.916  1.00 46.13           C  
ATOM    364  CD  ARG A  62      34.972  37.151  15.271  1.00 41.96           C  
ATOM    365  NE  ARG A  62      35.427  38.339  15.983  1.00 40.98           N  
ATOM    366  CZ  ARG A  62      36.678  38.572  16.344  1.00 32.82           C  
ATOM    367  NH1 ARG A  62      37.637  37.701  16.065  1.00 37.81           N  
ATOM    368  NH2 ARG A  62      36.968  39.684  16.994  1.00 38.53           N  
ATOM    369  N   LYS A  63      32.918  33.110  13.288  1.00 49.10           N  
ATOM    370  CA  LYS A  63      32.022  32.081  12.777  1.00 65.22           C  
ATOM    371  C   LYS A  63      30.681  31.895  13.486  1.00 68.35           C  
ATOM    372  O   LYS A  63      30.268  30.762  13.716  1.00 72.85           O  
ATOM    373  CB  LYS A  63      32.766  30.742  12.741  1.00 63.53           C  
ATOM    374  CG  LYS A  63      34.103  30.810  12.018  1.00 61.24           C  
ATOM    375  CD  LYS A  63      33.995  31.614  10.723  1.00 64.87           C  
ATOM    376  CE  LYS A  63      35.312  31.604   9.989  1.00 57.82           C  
ATOM    377  NZ  LYS A  63      35.743  30.187   9.788  1.00 66.70           N  
ATOM    378  N   ASN A  64      29.984  32.988  13.801  1.00 72.58           N  
ATOM    379  CA  ASN A  64      28.695  32.883  14.496  1.00 74.33           C  
ATOM    380  C   ASN A  64      27.817  34.098  14.231  1.00 75.08           C  
ATOM    381  O   ASN A  64      27.740  34.586  13.107  1.00 80.21           O  
ATOM    382  CB  ASN A  64      28.939  32.770  15.994  1.00 72.58           C  
ATOM    383  CG  ASN A  64      30.348  32.330  16.306  1.00 80.32           C  
ATOM    384  OD1 ASN A  64      30.659  31.129  16.298  1.00 76.84           O  
ATOM    385  ND2 ASN A  64      31.227  33.305  16.557  1.00 81.71           N  
ATOM    386  N   GLY A  65      27.153  34.578  15.277  1.00 76.44           N  
ATOM    387  CA  GLY A  65      26.306  35.750  15.151  1.00 70.59           C  
ATOM    388  C   GLY A  65      26.896  36.839  16.023  1.00 65.53           C  
ATOM    389  O   GLY A  65      27.905  36.532  16.687  1.00 59.52           O  
ATOM    390  N   LYS A  67      26.768  40.566  16.524  1.00 43.12           N  
ATOM    391  CA  LYS A  67      27.793  41.611  16.782  1.00 42.91           C  
ATOM    392  C   LYS A  67      29.236  41.127  16.786  1.00 47.53           C  
ATOM    393  O   LYS A  67      29.579  40.149  17.456  1.00 48.58           O  
ATOM    394  CB  LYS A  67      27.520  42.312  18.112  1.00 36.86           C  
ATOM    395  CG  LYS A  67      26.432  43.380  18.045  1.00 57.51           C  
ATOM    396  CD  LYS A  67      26.166  44.053  19.405  1.00 51.50           C  
ATOM    397  CE  LYS A  67      27.301  44.981  19.832  1.00 61.95           C  
ATOM    398  NZ  LYS A  67      26.975  45.798  21.060  1.00 67.66           N  
ATOM    399  N   ILE A  68      30.073  41.830  16.028  1.00 43.74           N  
ATOM    400  CA  ILE A  68      31.501  41.543  15.959  1.00 41.99           C  
ATOM    401  C   ILE A  68      32.162  42.543  16.893  1.00 39.66           C  
ATOM    402  O   ILE A  68      31.965  43.751  16.755  1.00 39.65           O  
ATOM    403  CB  ILE A  68      32.087  41.795  14.568  1.00 46.23           C  
ATOM    404  CG1 ILE A  68      31.303  41.009  13.520  1.00 48.58           C  
ATOM    405  CG2 ILE A  68      33.563  41.426  14.568  1.00 43.10           C  
ATOM    406  CD1 ILE A  68      31.785  41.236  12.089  1.00 51.55           C  
ATOM    407  N   TYR A  69      32.961  42.040  17.824  1.00 44.67           N  
ATOM    408  CA  TYR A  69      33.628  42.882  18.797  1.00 38.99           C  
ATOM    409  C   TYR A  69      35.114  42.976  18.559  1.00 39.56           C  
ATOM    410  O   TYR A  69      35.771  41.984  18.280  1.00 39.04           O  
ATOM    411  CB  TYR A  69      33.393  42.325  20.201  1.00 38.31           C  
ATOM    412  CG  TYR A  69      32.025  42.631  20.758  1.00 47.86           C  
ATOM    413  CD1 TYR A  69      31.750  43.875  21.333  1.00 60.25           C  
ATOM    414  CD2 TYR A  69      30.998  41.688  20.707  1.00 48.90           C  
ATOM    415  CE1 TYR A  69      30.478  44.175  21.847  1.00 57.95           C  
ATOM    416  CE2 TYR A  69      29.720  41.975  21.216  1.00 59.44           C  
ATOM    417  CZ  TYR A  69      29.470  43.221  21.786  1.00 64.33           C  
ATOM    418  OH  TYR A  69      28.223  43.517  22.301  1.00 70.57           O  
ATOM    419  N   ILE A  70      35.647  44.185  18.668  1.00 41.00           N  
ATOM    420  CA  ILE A  70      37.075  44.376  18.532  1.00 37.70           C  
ATOM    421  C   ILE A  70      37.538  45.122  19.779  1.00 32.67           C  
ATOM    422  O   ILE A  70      36.954  46.129  20.164  1.00 34.50           O  
ATOM    423  CB  ILE A  70      37.404  45.164  17.279  1.00 53.53           C  
ATOM    424  CG1 ILE A  70      38.918  45.332  17.159  1.00 48.11           C  
ATOM    425  CG2 ILE A  70      36.692  46.493  17.323  1.00 68.80           C  
ATOM    426  CD1 ILE A  70      39.371  45.826  15.812  1.00 62.20           C  
ATOM    427  N   GLU A  71      38.570  44.583  20.418  1.00 33.97           N  
ATOM    428  CA  GLU A  71      39.148  45.122  21.651  1.00 32.56           C  
ATOM    429  C   GLU A  71      39.620  46.573  21.561  1.00 38.66           C  
ATOM    430  O   GLU A  71      40.320  46.973  20.619  1.00 34.19           O  
ATOM    431  CB  GLU A  71      40.295  44.212  22.095  1.00 32.88           C  
ATOM    432  CG  GLU A  71      40.836  44.465  23.489  1.00 35.09           C  
ATOM    433  CD  GLU A  71      41.879  45.552  23.517  1.00 35.00           C  
ATOM    434  OE1 GLU A  71      42.813  45.498  22.693  1.00 40.18           O  
ATOM    435  OE2 GLU A  71      41.778  46.453  24.366  1.00 37.13           O  
ATOM    436  N   LYS A  72      39.233  47.339  22.575  1.00 30.34           N  
ATOM    437  CA  LYS A  72      39.531  48.761  22.691  1.00 33.25           C  
ATOM    438  C   LYS A  72      40.956  49.217  22.351  1.00 38.95           C  
ATOM    439  O   LYS A  72      41.157  50.043  21.445  1.00 36.65           O  
ATOM    440  CB  LYS A  72      39.170  49.210  24.104  1.00 32.40           C  
ATOM    441  CG  LYS A  72      39.462  50.649  24.440  1.00 33.43           C  
ATOM    442  CD  LYS A  72      39.413  50.834  25.951  1.00 40.48           C  
ATOM    443  CE  LYS A  72      39.613  52.292  26.363  1.00 57.41           C  
ATOM    444  NZ  LYS A  72      40.954  52.838  25.959  1.00 58.32           N  
ATOM    445  N   GLU A  73      41.935  48.693  23.086  1.00 34.11           N  
ATOM    446  CA  GLU A  73      43.325  49.063  22.896  1.00 30.59           C  
ATOM    447  C   GLU A  73      43.863  48.699  21.526  1.00 36.75           C  
ATOM    448  O   GLU A  73      44.656  49.442  20.956  1.00 45.26           O  
ATOM    449  CB  GLU A  73      44.194  48.441  23.996  1.00 37.62           C  
ATOM    450  CG  GLU A  73      44.314  49.333  25.237  1.00 36.31           C  
ATOM    451  CD  GLU A  73      45.005  48.666  26.430  1.00 45.51           C  
ATOM    452  OE1 GLU A  73      45.941  47.846  26.258  1.00 36.41           O  
ATOM    453  OE2 GLU A  73      44.616  49.000  27.564  1.00 46.69           O  
ATOM    454  N   GLN A  74      43.434  47.557  20.997  1.00 39.25           N  
ATOM    455  CA  GLN A  74      43.865  47.130  19.681  1.00 34.15           C  
ATOM    456  C   GLN A  74      43.243  48.017  18.605  1.00 41.74           C  
ATOM    457  O   GLN A  74      43.898  48.363  17.622  1.00 45.20           O  
ATOM    458  CB  GLN A  74      43.477  45.672  19.436  1.00 41.54           C  
ATOM    459  CG  GLN A  74      43.452  45.279  17.948  1.00 45.89           C  
ATOM    460  CD  GLN A  74      43.288  43.787  17.747  1.00 38.48           C  
ATOM    461  OE1 GLN A  74      42.263  43.317  17.265  1.00 39.25           O  
ATOM    462  NE2 GLN A  74      44.307  43.036  18.126  1.00 39.49           N  
ATOM    463  N   ALA A  75      41.983  48.392  18.794  1.00 38.81           N  
ATOM    464  CA  ALA A  75      41.297  49.221  17.823  1.00 37.62           C  
ATOM    465  C   ALA A  75      41.858  50.623  17.812  1.00 33.38           C  
ATOM    466  O   ALA A  75      42.028  51.223  16.755  1.00 43.97           O  
ATOM    467  CB  ALA A  75      39.807  49.267  18.114  1.00 28.25           C  
ATOM    468  N   GLU A  76      42.136  51.162  18.984  1.00 36.79           N  
ATOM    469  CA  GLU A  76      42.661  52.509  19.037  1.00 35.68           C  
ATOM    470  C   GLU A  76      44.089  52.545  18.505  1.00 38.71           C  
ATOM    471  O   GLU A  76      44.496  53.535  17.897  1.00 36.96           O  
ATOM    472  CB  GLU A  76      42.570  53.046  20.466  1.00 42.02           C  
ATOM    473  CG  GLU A  76      41.127  53.150  20.939  1.00 42.12           C  
ATOM    474  CD  GLU A  76      40.992  53.600  22.379  1.00 46.12           C  
ATOM    475  OE1 GLU A  76      41.932  53.377  23.175  1.00 50.10           O  
ATOM    476  OE2 GLU A  76      39.934  54.164  22.721  1.00 40.38           O  
ATOM    477  N   GLY A  77      44.828  51.455  18.709  1.00 37.18           N  
ATOM    478  CA  GLY A  77      46.196  51.356  18.218  1.00 32.05           C  
ATOM    479  C   GLY A  77      46.299  51.331  16.689  1.00 34.54           C  
ATOM    480  O   GLY A  77      46.978  52.167  16.101  1.00 40.11           O  
ATOM    481  N   ILE A  78      45.640  50.386  16.029  1.00 31.47           N  
ATOM    482  CA  ILE A  78      45.708  50.340  14.577  1.00 41.71           C  
ATOM    483  C   ILE A  78      45.120  51.627  14.005  1.00 41.24           C  
ATOM    484  O   ILE A  78      45.449  52.033  12.895  1.00 43.59           O  
ATOM    485  CB  ILE A  78      44.966  49.113  13.997  1.00 29.48           C  
ATOM    486  CG1 ILE A  78      43.573  49.019  14.588  1.00 52.10           C  
ATOM    487  CG2 ILE A  78      45.715  47.844  14.329  1.00 42.25           C  
ATOM    488  CD1 ILE A  78      42.888  47.664  14.329  1.00 56.96           C  
ATOM    489  N   ARG A  79      44.254  52.268  14.777  1.00 39.86           N  
ATOM    490  CA  ARG A  79      43.640  53.527  14.377  1.00 35.11           C  
ATOM    491  C   ARG A  79      44.680  54.671  14.388  1.00 39.75           C  
ATOM    492  O   ARG A  79      44.667  55.553  13.527  1.00 39.11           O  
ATOM    493  CB  ARG A  79      42.504  53.820  15.342  1.00 44.57           C  
ATOM    494  CG  ARG A  79      41.619  55.001  15.018  1.00 52.90           C  
ATOM    495  CD  ARG A  79      40.325  54.887  15.832  1.00 60.23           C  
ATOM    496  NE  ARG A  79      39.355  53.999  15.190  1.00 54.63           N  
ATOM    497  CZ  ARG A  79      38.234  53.568  15.767  1.00 58.73           C  
ATOM    498  NH1 ARG A  79      37.946  53.929  17.011  1.00 56.47           N  
ATOM    499  NH2 ARG A  79      37.375  52.821  15.080  1.00 50.13           N  
ATOM    500  N   GLU A  80      45.575  54.650  15.367  1.00 28.59           N  
ATOM    501  CA  GLU A  80      46.612  55.666  15.477  1.00 38.20           C  
ATOM    502  C   GLU A  80      47.637  55.468  14.341  1.00 40.51           C  
ATOM    503  O   GLU A  80      48.223  56.416  13.815  1.00 29.83           O  
ATOM    504  CB  GLU A  80      47.301  55.554  16.845  1.00 38.95           C  
ATOM    505  CG  GLU A  80      48.189  56.734  17.183  1.00 53.76           C  
ATOM    506  CD  GLU A  80      47.505  58.070  16.930  1.00 66.99           C  
ATOM    507  OE1 GLU A  80      46.388  58.287  17.468  1.00 70.28           O  
ATOM    508  OE2 GLU A  80      48.087  58.903  16.191  1.00 70.12           O  
ATOM    509  N   PHE A  81      47.847  54.212  13.984  1.00 30.03           N  
ATOM    510  CA  PHE A  81      48.745  53.878  12.910  1.00 32.84           C  
ATOM    511  C   PHE A  81      48.114  54.394  11.607  1.00 40.98           C  
ATOM    512  O   PHE A  81      48.798  54.886  10.703  1.00 43.28           O  
ATOM    513  CB  PHE A  81      48.921  52.364  12.882  1.00 32.65           C  
ATOM    514  CG  PHE A  81      49.845  51.885  11.820  1.00 34.73           C  
ATOM    515  CD1 PHE A  81      49.473  51.941  10.484  1.00 25.51           C  
ATOM    516  CD2 PHE A  81      51.083  51.365  12.156  1.00 29.02           C  
ATOM    517  CE1 PHE A  81      50.324  51.482   9.498  1.00 33.58           C  
ATOM    518  CE2 PHE A  81      51.947  50.901  11.165  1.00 35.18           C  
ATOM    519  CZ  PHE A  81      51.562  50.961   9.841  1.00 31.05           C  
ATOM    520  N   ALA A  82      46.794  54.304  11.535  1.00 40.78           N  
ATOM    521  CA  ALA A  82      46.059  54.754  10.370  1.00 41.01           C  
ATOM    522  C   ALA A  82      46.136  56.268  10.215  1.00 35.13           C  
ATOM    523  O   ALA A  82      46.276  56.778   9.100  1.00 33.79           O  
ATOM    524  CB  ALA A  82      44.620  54.303  10.473  1.00 32.78           C  
ATOM    525  N   LYS A  83      46.034  56.983  11.333  1.00 40.46           N  
ATOM    526  CA  LYS A  83      46.104  58.445  11.306  1.00 45.16           C  
ATOM    527  C   LYS A  83      47.525  58.901  10.952  1.00 43.50           C  
ATOM    528  O   LYS A  83      47.713  59.855  10.196  1.00 41.84           O  
ATOM    529  CB  LYS A  83      45.691  59.022  12.660  1.00 42.40           C  
ATOM    530  CG  LYS A  83      46.048  60.493  12.820  1.00 60.26           C  
ATOM    531  CD  LYS A  83      45.627  61.028  14.183  1.00 68.17           C  
ATOM    532  CE  LYS A  83      44.111  61.182  14.258  1.00 70.00           C  
ATOM    533  NZ  LYS A  83      43.622  62.231  13.301  1.00 73.55           N  
ATOM    534  N   ARG A  84      48.522  58.218  11.501  1.00 39.47           N  
ATOM    535  CA  ARG A  84      49.900  58.562  11.189  1.00 43.77           C  
ATOM    536  C   ARG A  84      50.184  58.392   9.691  1.00 43.61           C  
ATOM    537  O   ARG A  84      50.647  59.323   9.015  1.00 34.94           O  
ATOM    538  CB  ARG A  84      50.888  57.691  11.994  1.00 47.91           C  
ATOM    539  CG  ARG A  84      51.054  58.068  13.468  1.00 48.13           C  
ATOM    540  CD  ARG A  84      50.743  59.542  13.679  1.00 74.56           C  
ATOM    541  NE  ARG A  84      51.340  60.399  12.642  1.00 84.58           N  
ATOM    542  CZ  ARG A  84      50.866  61.597  12.309  1.00 88.50           C  
ATOM    543  NH1 ARG A  84      49.797  62.073  12.940  1.00 93.61           N  
ATOM    544  NH2 ARG A  84      51.432  62.303  11.332  1.00 84.45           N  
ATOM    545  N   SER A  85      49.895  57.193   9.192  1.00 35.58           N  
ATOM    546  CA  SER A  85      50.121  56.821   7.803  1.00 30.54           C  
ATOM    547  C   SER A  85      49.261  57.588   6.834  1.00 33.44           C  
ATOM    548  O   SER A  85      49.622  57.755   5.669  1.00 41.90           O  
ATOM    549  CB  SER A  85      49.823  55.346   7.621  1.00 32.15           C  
ATOM    550  OG  SER A  85      48.422  55.154   7.594  1.00 40.22           O  
ATOM    551  N   GLY A  86      48.109  58.040   7.304  1.00 38.90           N  
ATOM    552  CA  GLY A  86      47.208  58.771   6.432  1.00 34.00           C  
ATOM    553  C   GLY A  86      46.493  57.821   5.484  1.00 39.76           C  
ATOM    554  O   GLY A  86      45.928  58.249   4.475  1.00 35.71           O  
ATOM    555  N   GLY A  87      46.508  56.527   5.809  1.00 34.65           N  
ATOM    556  CA  GLY A  87      45.844  55.557   4.950  1.00 45.91           C  
ATOM    557  C   GLY A  87      44.403  55.220   5.327  1.00 42.41           C  
ATOM    558  O   GLY A  87      43.992  55.384   6.468  1.00 40.95           O  
ATOM    559  N   GLU A  88      43.618  54.768   4.358  1.00 38.61           N  
ATOM    560  CA  GLU A  88      42.237  54.395   4.628  1.00 33.61           C  
ATOM    561  C   GLU A  88      42.232  53.015   5.263  1.00 31.27           C  
ATOM    562  O   GLU A  88      42.708  52.047   4.675  1.00 31.82           O  
ATOM    563  CB  GLU A  88      41.429  54.368   3.346  1.00 39.00           C  
ATOM    564  CG  GLU A  88      40.768  55.670   3.039  1.00 53.46           C  
ATOM    565  CD  GLU A  88      39.330  55.472   2.610  1.00 61.54           C  
ATOM    566  OE1 GLU A  88      38.448  55.284   3.487  1.00 53.32           O  
ATOM    567  OE2 GLU A  88      39.093  55.488   1.386  1.00 62.94           O  
ATOM    568  N   LEU A  89      41.692  52.939   6.471  1.00 26.37           N  
ATOM    569  CA  LEU A  89      41.654  51.701   7.216  1.00 29.20           C  
ATOM    570  C   LEU A  89      40.320  50.951   7.094  1.00 32.44           C  
ATOM    571  O   LEU A  89      39.258  51.550   7.274  1.00 37.43           O  
ATOM    572  CB  LEU A  89      41.940  52.011   8.678  1.00 22.52           C  
ATOM    573  CG  LEU A  89      41.903  50.780   9.546  1.00 30.37           C  
ATOM    574  CD1 LEU A  89      43.044  49.895   9.121  1.00 23.71           C  
ATOM    575  CD2 LEU A  89      41.969  51.154  11.015  1.00 27.98           C  
ATOM    576  N   PHE A  90      40.392  49.648   6.814  1.00 29.38           N  
ATOM    577  CA  PHE A  90      39.209  48.799   6.667  1.00 27.75           C  
ATOM    578  C   PHE A  90      39.238  47.570   7.580  1.00 32.90           C  
ATOM    579  O   PHE A  90      40.308  47.056   7.941  1.00 41.40           O  
ATOM    580  CB  PHE A  90      39.079  48.264   5.231  1.00 25.79           C  
ATOM    581  CG  PHE A  90      38.845  49.331   4.187  1.00 41.21           C  
ATOM    582  CD1 PHE A  90      39.880  50.158   3.767  1.00 29.00           C  
ATOM    583  CD2 PHE A  90      37.584  49.509   3.630  1.00 32.39           C  
ATOM    584  CE1 PHE A  90      39.665  51.138   2.817  1.00 35.05           C  
ATOM    585  CE2 PHE A  90      37.359  50.493   2.671  1.00 38.48           C  
ATOM    586  CZ  PHE A  90      38.402  51.309   2.264  1.00 39.80           C  
ATOM    587  N   LEU A  91      38.050  47.089   7.929  1.00 33.93           N  
ATOM    588  CA  LEU A  91      37.925  45.867   8.721  1.00 41.73           C  
ATOM    589  C   LEU A  91      37.454  44.763   7.758  1.00 35.03           C  
ATOM    590  O   LEU A  91      36.374  44.855   7.161  1.00 33.99           O  
ATOM    591  CB  LEU A  91      36.895  46.036   9.842  1.00 31.35           C  
ATOM    592  CG  LEU A  91      36.468  44.758  10.578  1.00 41.76           C  
ATOM    593  CD1 LEU A  91      37.600  44.247  11.410  1.00 21.63           C  
ATOM    594  CD2 LEU A  91      35.232  45.046  11.486  1.00 37.84           C  
ATOM    595  N   GLY A  92      38.279  43.743   7.576  1.00 27.81           N  
ATOM    596  CA  GLY A  92      37.872  42.655   6.714  1.00 31.35           C  
ATOM    597  C   GLY A  92      37.449  41.469   7.556  1.00 34.15           C  
ATOM    598  O   GLY A  92      38.239  40.994   8.370  1.00 36.61           O  
ATOM    599  N   VAL A  93      36.221  40.984   7.378  1.00 30.03           N  
ATOM    600  CA  VAL A  93      35.755  39.838   8.171  1.00 34.01           C  
ATOM    601  C   VAL A  93      35.478  38.582   7.366  1.00 29.28           C  
ATOM    602  O   VAL A  93      34.807  38.622   6.336  1.00 32.06           O  
ATOM    603  CB  VAL A  93      34.458  40.153   8.949  1.00 36.18           C  
ATOM    604  CG1 VAL A  93      34.209  39.053   9.997  1.00 25.15           C  
ATOM    605  CG2 VAL A  93      34.554  41.548   9.599  1.00 39.21           C  
ATOM    606  N   LYS A  94      35.992  37.457   7.838  1.00 30.04           N  
ATOM    607  CA  LYS A  94      35.746  36.212   7.139  1.00 32.85           C  
ATOM    608  C   LYS A  94      34.694  35.391   7.889  1.00 39.96           C  
ATOM    609  O   LYS A  94      34.985  34.781   8.928  1.00 31.19           O  
ATOM    610  CB  LYS A  94      37.041  35.396   6.991  1.00 32.45           C  
ATOM    611  CG  LYS A  94      36.843  34.077   6.225  1.00 33.94           C  
ATOM    612  CD  LYS A  94      36.236  34.316   4.828  1.00 32.42           C  
ATOM    613  CE  LYS A  94      36.032  33.012   4.063  1.00 43.95           C  
ATOM    614  NZ  LYS A  94      34.863  32.193   4.539  1.00 31.16           N  
ATOM    615  N   LEU A  95      33.465  35.405   7.370  1.00 36.77           N  
ATOM    616  CA  LEU A  95      32.396  34.641   7.970  1.00 33.35           C  
ATOM    617  C   LEU A  95      32.509  33.238   7.395  1.00 38.97           C  
ATOM    618  O   LEU A  95      33.272  33.000   6.454  1.00 43.51           O  
ATOM    619  CB  LEU A  95      31.050  35.281   7.657  1.00 26.01           C  
ATOM    620  CG  LEU A  95      30.989  36.690   8.259  1.00 30.89           C  
ATOM    621  CD1 LEU A  95      29.733  37.349   7.790  1.00 35.64           C  
ATOM    622  CD2 LEU A  95      31.049  36.651   9.784  1.00 23.82           C  
ATOM    623  N   PRO A  96      31.782  32.279   7.969  1.00 39.16           N  
ATOM    624  CA  PRO A  96      31.845  30.902   7.474  1.00 41.82           C  
ATOM    625  C   PRO A  96      31.802  30.740   5.950  1.00 45.44           C  
ATOM    626  O   PRO A  96      32.645  30.058   5.359  1.00 42.23           O  
ATOM    627  CB  PRO A  96      30.649  30.243   8.159  1.00 47.58           C  
ATOM    628  CG  PRO A  96      30.622  30.929   9.492  1.00 45.71           C  
ATOM    629  CD  PRO A  96      30.848  32.389   9.109  1.00 42.56           C  
ATOM    630  N   LYS A  97      30.817  31.369   5.318  1.00 47.68           N  
ATOM    631  CA  LYS A  97      30.640  31.243   3.876  1.00 46.04           C  
ATOM    632  C   LYS A  97      30.895  32.527   3.108  1.00 43.96           C  
ATOM    633  O   LYS A  97      30.577  32.612   1.921  1.00 39.65           O  
ATOM    634  CB  LYS A  97      29.217  30.749   3.572  1.00 50.07           C  
ATOM    635  CG  LYS A  97      28.814  29.427   4.274  1.00 60.27           C  
ATOM    636  CD  LYS A  97      27.318  29.107   4.016  1.00 68.20           C  
ATOM    637  CE  LYS A  97      26.820  27.833   4.720  1.00 56.10           C  
ATOM    638  NZ  LYS A  97      27.187  26.579   4.006  1.00 56.08           N  
ATOM    639  N   MET A  98      31.460  33.534   3.764  1.00 36.69           N  
ATOM    640  CA  MET A  98      31.726  34.782   3.050  1.00 43.74           C  
ATOM    641  C   MET A  98      32.795  35.687   3.684  1.00 42.02           C  
ATOM    642  O   MET A  98      33.091  35.601   4.893  1.00 36.06           O  
ATOM    643  CB  MET A  98      30.417  35.572   2.850  1.00 34.68           C  
ATOM    644  CG  MET A  98      29.777  36.087   4.137  1.00 42.84           C  
ATOM    645  SD  MET A  98      28.373  37.217   3.823  1.00 43.90           S  
ATOM    646  CE  MET A  98      27.074  36.020   3.538  1.00 43.44           C  
ATOM    647  N   LEU A  99      33.370  36.536   2.826  1.00 34.54           N  
ATOM    648  CA  LEU A  99      34.402  37.500   3.181  1.00 28.89           C  
ATOM    649  C   LEU A  99      33.891  38.909   2.911  1.00 33.99           C  
ATOM    650  O   LEU A  99      33.472  39.232   1.795  1.00 36.47           O  
ATOM    651  CB  LEU A  99      35.653  37.250   2.352  1.00 26.29           C  
ATOM    652  CG  LEU A  99      36.792  38.276   2.419  1.00 31.92           C  
ATOM    653  CD1 LEU A  99      37.488  38.271   3.817  1.00 17.57           C  
ATOM    654  CD2 LEU A  99      37.782  37.924   1.298  1.00 30.40           C  
ATOM    655  N   ARG A 100      33.947  39.757   3.927  1.00 32.48           N  
ATOM    656  CA  ARG A 100      33.470  41.123   3.790  1.00 35.43           C  
ATOM    657  C   ARG A 100      34.432  42.171   4.345  1.00 30.97           C  
ATOM    658  O   ARG A 100      35.278  41.873   5.189  1.00 30.35           O  
ATOM    659  CB  ARG A 100      32.132  41.263   4.496  1.00 40.08           C  
ATOM    660  CG  ARG A 100      31.107  40.313   3.998  1.00 34.59           C  
ATOM    661  CD  ARG A 100      30.572  40.749   2.679  1.00 38.64           C  
ATOM    662  NE  ARG A 100      29.977  39.597   2.028  1.00 58.84           N  
ATOM    663  CZ  ARG A 100      29.000  39.659   1.139  1.00 57.68           C  
ATOM    664  NH1 ARG A 100      28.509  40.844   0.786  1.00 63.17           N  
ATOM    665  NH2 ARG A 100      28.501  38.531   0.637  1.00 45.38           N  
ATOM    666  N   PHE A 101      34.247  43.400   3.878  1.00 27.73           N  
ATOM    667  CA  PHE A 101      35.059  44.541   4.267  1.00 32.44           C  
ATOM    668  C   PHE A 101      34.192  45.759   4.477  1.00 32.22           C  
ATOM    669  O   PHE A 101      33.373  46.078   3.634  1.00 26.47           O  
ATOM    670  CB  PHE A 101      36.040  44.889   3.137  1.00 38.68           C  
ATOM    671  CG  PHE A 101      36.936  43.766   2.754  1.00 34.02           C  
ATOM    672  CD1 PHE A 101      38.139  43.575   3.411  1.00 34.67           C  
ATOM    673  CD2 PHE A 101      36.551  42.862   1.761  1.00 36.35           C  
ATOM    674  CE1 PHE A 101      38.958  42.484   3.080  1.00 37.78           C  
ATOM    675  CE2 PHE A 101      37.349  41.778   1.427  1.00 29.91           C  
ATOM    676  CZ  PHE A 101      38.554  41.586   2.084  1.00 36.66           C  
ATOM    677  N   ILE A 102      34.391  46.452   5.583  1.00 33.07           N  
ATOM    678  CA  ILE A 102      33.671  47.697   5.830  1.00 34.45           C  
ATOM    679  C   ILE A 102      34.718  48.717   6.262  1.00 35.92           C  
ATOM    680  O   ILE A 102      35.839  48.341   6.623  1.00 35.15           O  
ATOM    681  CB  ILE A 102      32.651  47.555   6.965  1.00 41.83           C  
ATOM    682  CG1 ILE A 102      33.329  46.903   8.166  1.00 38.40           C  
ATOM    683  CG2 ILE A 102      31.442  46.746   6.493  1.00 39.94           C  
ATOM    684  CD1 ILE A 102      32.509  46.972   9.426  1.00 48.99           C  
ATOM    685  N   LYS A 103      34.369  50.001   6.209  1.00 38.41           N  
ATOM    686  CA  LYS A 103      35.289  51.050   6.655  1.00 29.69           C  
ATOM    687  C   LYS A 103      35.415  50.870   8.160  1.00 34.85           C  
ATOM    688  O   LYS A 103      34.417  50.678   8.860  1.00 27.03           O  
ATOM    689  CB  LYS A 103      34.733  52.450   6.392  1.00 35.90           C  
ATOM    690  CG  LYS A 103      34.916  52.976   4.991  1.00 37.27           C  
ATOM    691  CD  LYS A 103      34.194  54.313   4.847  1.00 50.48           C  
ATOM    692  CE  LYS A 103      34.743  55.166   3.686  1.00 65.82           C  
ATOM    693  NZ  LYS A 103      34.755  54.482   2.357  1.00 59.82           N  
ATOM    694  N   PHE A 104      36.642  50.923   8.660  1.00 33.14           N  
ATOM    695  CA  PHE A 104      36.856  50.759  10.088  1.00 37.06           C  
ATOM    696  C   PHE A 104      36.023  51.769  10.904  1.00 40.05           C  
ATOM    697  O   PHE A 104      35.724  51.542  12.084  1.00 28.08           O  
ATOM    698  CB  PHE A 104      38.330  50.921  10.403  1.00 35.07           C  
ATOM    699  CG  PHE A 104      38.760  50.155  11.588  1.00 33.40           C  
ATOM    700  CD1 PHE A 104      39.096  48.815  11.470  1.00 24.85           C  
ATOM    701  CD2 PHE A 104      38.830  50.767  12.836  1.00 32.42           C  
ATOM    702  CE1 PHE A 104      39.503  48.081  12.580  1.00 26.84           C  
ATOM    703  CE2 PHE A 104      39.238  50.041  13.959  1.00 38.34           C  
ATOM    704  CZ  PHE A 104      39.577  48.689  13.826  1.00 27.46           C  
ATOM    705  N   ASP A 105      35.652  52.871  10.255  1.00 40.93           N  
ATOM    706  CA  ASP A 105      34.849  53.924  10.876  1.00 45.00           C  
ATOM    707  C   ASP A 105      33.437  53.479  11.223  1.00 42.83           C  
ATOM    708  O   ASP A 105      32.717  54.186  11.917  1.00 39.07           O  
ATOM    709  CB  ASP A 105      34.753  55.138   9.953  1.00 50.89           C  
ATOM    710  CG  ASP A 105      36.074  55.830   9.776  1.00 69.04           C  
ATOM    711  OD1 ASP A 105      36.911  55.741  10.715  1.00 63.29           O  
ATOM    712  OD2 ASP A 105      36.269  56.477   8.710  1.00 70.68           O  
ATOM    713  N   MET A 106      33.039  52.315  10.727  1.00 42.04           N  
ATOM    714  CA  MET A 106      31.704  51.798  11.005  1.00 49.82           C  
ATOM    715  C   MET A 106      31.622  51.164  12.390  1.00 48.81           C  
ATOM    716  O   MET A 106      30.532  50.921  12.901  1.00 53.51           O  
ATOM    717  CB  MET A 106      31.293  50.775   9.945  1.00 55.18           C  
ATOM    718  CG  MET A 106      31.231  51.332   8.525  1.00 62.34           C  
ATOM    719  SD  MET A 106      29.804  52.405   8.214  1.00 74.80           S  
ATOM    720  CE  MET A 106      28.806  51.254   7.197  1.00 71.58           C  
ATOM    721  N   LEU A 107      32.765  50.877  12.997  1.00 38.72           N  
ATOM    722  CA  LEU A 107      32.756  50.294  14.333  1.00 50.24           C  
ATOM    723  C   LEU A 107      32.392  51.382  15.358  1.00 53.48           C  
ATOM    724  O   LEU A 107      33.070  52.410  15.438  1.00 48.44           O  
ATOM    725  CB  LEU A 107      34.139  49.727  14.686  1.00 42.97           C  
ATOM    726  CG  LEU A 107      34.729  48.555  13.904  1.00 50.91           C  
ATOM    727  CD1 LEU A 107      36.207  48.491  14.207  1.00 50.81           C  
ATOM    728  CD2 LEU A 107      34.048  47.239  14.284  1.00 42.16           C  
ATOM    729  N   ARG A 108      31.328  51.167  16.129  1.00 51.80           N  
ATOM    730  CA  ARG A 108      30.938  52.136  17.159  1.00 43.76           C  
ATOM    731  C   ARG A 108      31.422  51.634  18.524  1.00 48.19           C  
ATOM    732  O   ARG A 108      31.356  50.433  18.832  1.00 42.77           O  
ATOM    733  CB  ARG A 108      29.412  52.336  17.199  1.00 50.12           C  
ATOM    734  CG  ARG A 108      28.828  53.312  16.169  1.00 56.38           C  
ATOM    735  CD  ARG A 108      28.791  52.728  14.755  1.00 74.53           C  
ATOM    736  NE  ARG A 108      27.979  53.528  13.828  1.00 77.92           N  
ATOM    737  CZ  ARG A 108      27.600  53.123  12.614  1.00 76.51           C  
ATOM    738  NH1 ARG A 108      27.954  51.922  12.166  1.00 56.60           N  
ATOM    739  NH2 ARG A 108      26.861  53.918  11.842  1.00 71.81           N  
ATOM    740  N   GLN A 109      31.914  52.548  19.345  1.00 44.56           N  
ATOM    741  CA  GLN A 109      32.403  52.154  20.653  1.00 51.48           C  
ATOM    742  C   GLN A 109      31.249  51.715  21.531  1.00 54.18           C  
ATOM    743  O   GLN A 109      30.242  52.412  21.626  1.00 57.87           O  
ATOM    744  CB  GLN A 109      33.142  53.314  21.304  1.00 53.95           C  
ATOM    745  CG  GLN A 109      33.772  52.995  22.643  1.00 51.19           C  
ATOM    746  CD  GLN A 109      34.665  54.127  23.125  1.00 64.32           C  
ATOM    747  OE1 GLN A 109      34.306  55.307  23.012  1.00 57.37           O  
ATOM    748  NE2 GLN A 109      35.831  53.778  23.671  1.00 51.33           N  
ATOM    749  N   THR A 110      31.396  50.550  22.160  1.00 57.33           N  
ATOM    750  CA  THR A 110      30.364  50.004  23.047  1.00 57.62           C  
ATOM    751  C   THR A 110      30.407  50.678  24.421  1.00 65.88           C  
ATOM    752  O   THR A 110      31.383  51.358  24.784  1.00 65.53           O  
ATOM    753  CB  THR A 110      30.543  48.472  23.289  1.00 54.55           C  
ATOM    754  OG1 THR A 110      31.562  48.253  24.275  1.00 57.33           O  
ATOM    755  CG2 THR A 110      30.947  47.760  22.004  1.00 47.15           C  
ATOM    756  N   GLU A 111      29.343  50.475  25.185  1.00 67.43           N  
ATOM    757  CA  GLU A 111      29.236  51.029  26.527  1.00 69.97           C  
ATOM    758  C   GLU A 111      30.486  50.650  27.330  1.00 64.88           C  
ATOM    759  O   GLU A 111      31.091  51.490  28.001  1.00 62.02           O  
ATOM    760  CB  GLU A 111      27.985  50.473  27.220  1.00 81.15           C  
ATOM    761  CG  GLU A 111      26.688  50.517  26.384  1.00 92.80           C  
ATOM    762  CD  GLU A 111      26.479  49.286  25.483  1.00 97.14           C  
ATOM    763  OE1 GLU A 111      25.309  49.036  25.090  1.00 95.22           O  
ATOM    764  OE2 GLU A 111      27.470  48.576  25.163  1.00 98.02           O  
ATOM    765  N   GLY A 112      30.867  49.379  27.236  1.00 60.13           N  
ATOM    766  CA  GLY A 112      32.038  48.878  27.936  1.00 55.13           C  
ATOM    767  C   GLY A 112      33.376  49.466  27.508  1.00 52.43           C  
ATOM    768  O   GLY A 112      34.338  49.414  28.281  1.00 48.42           O  
ATOM    769  N   GLY A 113      33.455  49.997  26.285  1.00 48.32           N  
ATOM    770  CA  GLY A 113      34.694  50.608  25.814  1.00 40.38           C  
ATOM    771  C   GLY A 113      35.306  50.002  24.555  1.00 46.43           C  
ATOM    772  O   GLY A 113      36.216  50.571  23.941  1.00 35.05           O  
ATOM    773  N   ASN A 114      34.826  48.830  24.168  1.00 41.40           N  
ATOM    774  CA  ASN A 114      35.364  48.208  22.979  1.00 37.84           C  
ATOM    775  C   ASN A 114      34.600  48.726  21.778  1.00 32.49           C  
ATOM    776  O   ASN A 114      33.804  49.652  21.891  1.00 32.87           O  
ATOM    777  CB  ASN A 114      35.272  46.688  23.086  1.00 32.51           C  
ATOM    778  CG  ASN A 114      35.882  46.173  24.363  1.00 32.19           C  
ATOM    779  OD1 ASN A 114      35.175  45.908  25.335  1.00 34.28           O  
ATOM    780  ND2 ASN A 114      37.208  46.051  24.383  1.00 38.99           N  
ATOM    781  N   TYR A 115      34.846  48.131  20.625  1.00 33.30           N  
ATOM    782  CA  TYR A 115      34.197  48.574  19.417  1.00 29.88           C  
ATOM    783  C   TYR A 115      33.503  47.405  18.788  1.00 38.85           C  
ATOM    784  O   TYR A 115      33.968  46.266  18.884  1.00 42.30           O  
ATOM    785  CB  TYR A 115      35.232  49.169  18.473  1.00 35.02           C  
ATOM    786  CG  TYR A 115      35.882  50.411  19.041  1.00 28.87           C  
ATOM    787  CD1 TYR A 115      35.352  51.664  18.802  1.00 37.01           C  
ATOM    788  CD2 TYR A 115      36.979  50.318  19.890  1.00 24.35           C  
ATOM    789  CE1 TYR A 115      35.898  52.796  19.404  1.00 33.93           C  
ATOM    790  CE2 TYR A 115      37.515  51.415  20.482  1.00 23.76           C  
ATOM    791  CZ  TYR A 115      36.981  52.657  20.248  1.00 35.57           C  
ATOM    792  OH  TYR A 115      37.524  53.768  20.875  1.00 42.44           O  
ATOM    793  N   ALA A 116      32.371  47.685  18.151  1.00 41.67           N  
ATOM    794  CA  ALA A 116      31.600  46.632  17.531  1.00 41.26           C  
ATOM    795  C   ALA A 116      30.751  47.101  16.385  1.00 34.17           C  
ATOM    796  O   ALA A 116      30.496  48.294  16.201  1.00 35.26           O  
ATOM    797  CB  ALA A 116      30.724  45.943  18.568  1.00 49.96           C  
ATOM    798  N   ILE A 117      30.321  46.114  15.617  1.00 33.11           N  
ATOM    799  CA  ILE A 117      29.502  46.323  14.450  1.00 33.81           C  
ATOM    800  C   ILE A 117      28.627  45.068  14.396  1.00 38.40           C  
ATOM    801  O   ILE A 117      29.091  43.957  14.718  1.00 34.99           O  
ATOM    802  CB  ILE A 117      30.413  46.466  13.178  1.00 37.65           C  
ATOM    803  CG1 ILE A 117      29.563  46.715  11.932  1.00 32.93           C  
ATOM    804  CG2 ILE A 117      31.334  45.246  13.016  1.00 24.31           C  
ATOM    805  CD1 ILE A 117      29.119  48.183  11.783  1.00 34.99           C  
ATOM    806  N   ASP A 118      27.358  45.244  14.044  1.00 36.77           N  
ATOM    807  CA  ASP A 118      26.427  44.118  13.948  1.00 31.26           C  
ATOM    808  C   ASP A 118      26.763  43.266  12.710  1.00 36.11           C  
ATOM    809  O   ASP A 118      27.114  43.815  11.663  1.00 38.32           O  
ATOM    810  CB  ASP A 118      25.003  44.668  13.888  1.00 29.82           C  
ATOM    811  CG  ASP A 118      24.822  45.675  12.780  1.00 57.28           C  
ATOM    812  OD1 ASP A 118      24.273  45.284  11.728  1.00 67.16           O  
ATOM    813  OD2 ASP A 118      25.243  46.853  12.939  1.00 55.88           O  
ATOM    814  N   LEU A 119      26.666  41.938  12.817  1.00 36.56           N  
ATOM    815  CA  LEU A 119      27.003  41.096  11.669  1.00 43.81           C  
ATOM    816  C   LEU A 119      26.145  41.417  10.466  1.00 47.73           C  
ATOM    817  O   LEU A 119      26.498  41.109   9.333  1.00 54.27           O  
ATOM    818  CB  LEU A 119      26.929  39.589  11.992  1.00 48.24           C  
ATOM    819  CG  LEU A 119      25.709  38.657  11.934  1.00 56.37           C  
ATOM    820  CD1 LEU A 119      24.993  38.782  10.615  1.00 67.70           C  
ATOM    821  CD2 LEU A 119      26.157  37.203  12.116  1.00 50.24           C  
ATOM    822  N   GLU A 120      25.017  42.055  10.712  1.00 51.64           N  
ATOM    823  CA  GLU A 120      24.121  42.431   9.636  1.00 54.25           C  
ATOM    824  C   GLU A 120      24.867  43.347   8.674  1.00 52.14           C  
ATOM    825  O   GLU A 120      24.878  43.130   7.453  1.00 47.19           O  
ATOM    826  CB  GLU A 120      22.904  43.181  10.196  1.00 54.01           C  
ATOM    827  CG  GLU A 120      22.083  42.380  11.201  1.00 78.89           C  
ATOM    828  CD  GLU A 120      22.944  41.670  12.258  1.00 79.22           C  
ATOM    829  OE1 GLU A 120      23.550  42.345  13.115  1.00 71.14           O  
ATOM    830  OE2 GLU A 120      23.013  40.423  12.222  1.00 85.46           O  
ATOM    831  N   THR A 121      25.497  44.369   9.239  1.00 39.03           N  
ATOM    832  CA  THR A 121      26.211  45.366   8.456  1.00 43.53           C  
ATOM    833  C   THR A 121      27.346  44.772   7.636  1.00 45.32           C  
ATOM    834  O   THR A 121      27.515  45.085   6.458  1.00 45.93           O  
ATOM    835  CB  THR A 121      26.740  46.434   9.388  1.00 50.70           C  
ATOM    836  OG1 THR A 121      25.697  46.766  10.311  1.00 46.80           O  
ATOM    837  CG2 THR A 121      27.168  47.684   8.610  1.00 33.90           C  
ATOM    838  N   VAL A 122      28.115  43.904   8.273  1.00 44.49           N  
ATOM    839  CA  VAL A 122      29.230  43.232   7.630  1.00 40.07           C  
ATOM    840  C   VAL A 122      28.739  42.386   6.453  1.00 42.63           C  
ATOM    841  O   VAL A 122      29.348  42.367   5.383  1.00 40.60           O  
ATOM    842  CB  VAL A 122      29.952  42.343   8.670  1.00 40.30           C  
ATOM    843  CG1 VAL A 122      30.985  41.441   8.004  1.00 38.79           C  
ATOM    844  CG2 VAL A 122      30.592  43.236   9.728  1.00 32.37           C  
ATOM    845  N   GLU A 123      27.629  41.690   6.644  1.00 43.44           N  
ATOM    846  CA  GLU A 123      27.117  40.851   5.574  1.00 46.69           C  
ATOM    847  C   GLU A 123      26.796  41.700   4.361  1.00 41.06           C  
ATOM    848  O   GLU A 123      26.995  41.273   3.228  1.00 43.42           O  
ATOM    849  CB  GLU A 123      25.861  40.114   6.020  1.00 43.54           C  
ATOM    850  CG  GLU A 123      26.039  39.281   7.257  1.00 48.75           C  
ATOM    851  CD  GLU A 123      24.840  38.416   7.527  1.00 44.63           C  
ATOM    852  OE1 GLU A 123      23.702  38.933   7.452  1.00 40.03           O  
ATOM    853  OE2 GLU A 123      25.042  37.223   7.819  1.00 44.93           O  
ATOM    854  N   LYS A 124      26.304  42.908   4.615  1.00 45.31           N  
ATOM    855  CA  LYS A 124      25.937  43.829   3.548  1.00 47.52           C  
ATOM    856  C   LYS A 124      27.141  44.688   3.154  1.00 48.18           C  
ATOM    857  O   LYS A 124      27.030  45.604   2.336  1.00 48.87           O  
ATOM    858  CB  LYS A 124      24.767  44.705   4.011  1.00 47.70           C  
ATOM    859  CG  LYS A 124      24.339  45.796   3.038  1.00 65.78           C  
ATOM    860  CD  LYS A 124      23.618  46.904   3.795  1.00 74.15           C  
ATOM    861  CE  LYS A 124      23.192  48.054   2.886  1.00 71.57           C  
ATOM    862  NZ  LYS A 124      22.576  49.154   3.695  1.00 67.58           N  
ATOM    863  N   GLY A 125      28.295  44.380   3.734  1.00 47.70           N  
ATOM    864  CA  GLY A 125      29.500  45.124   3.422  1.00 47.46           C  
ATOM    865  C   GLY A 125      29.953  44.819   2.007  1.00 48.06           C  
ATOM    866  O   GLY A 125      29.223  44.194   1.245  1.00 40.67           O  
ATOM    867  N   MET A 126      31.158  45.239   1.647  1.00 45.03           N  
ATOM    868  CA  MET A 126      31.622  44.981   0.294  1.00 47.37           C  
ATOM    869  C   MET A 126      32.513  43.767   0.177  1.00 40.16           C  
ATOM    870  O   MET A 126      33.086  43.301   1.156  1.00 44.79           O  
ATOM    871  CB  MET A 126      32.329  46.220  -0.274  1.00 48.48           C  
ATOM    872  CG  MET A 126      33.678  46.549   0.299  1.00 46.17           C  
ATOM    873  SD  MET A 126      33.913  48.367   0.358  1.00 54.77           S  
ATOM    874  CE  MET A 126      34.587  48.754  -1.197  1.00 47.88           C  
ATOM    875  N   GLU A 127      32.585  43.220  -1.030  1.00 39.37           N  
ATOM    876  CA  GLU A 127      33.449  42.079  -1.275  1.00 37.96           C  
ATOM    877  C   GLU A 127      34.756  42.627  -1.780  1.00 32.89           C  
ATOM    878  O   GLU A 127      34.885  43.828  -1.993  1.00 37.22           O  
ATOM    879  CB  GLU A 127      32.853  41.144  -2.306  1.00 47.10           C  
ATOM    880  CG  GLU A 127      31.518  40.592  -1.892  1.00 46.96           C  
ATOM    881  CD  GLU A 127      31.104  39.450  -2.774  1.00 61.03           C  
ATOM    882  OE1 GLU A 127      31.785  38.391  -2.720  1.00 59.88           O  
ATOM    883  OE2 GLU A 127      30.111  39.619  -3.521  1.00 56.75           O  
ATOM    884  N   LEU A 128      35.731  41.752  -1.947  1.00 33.36           N  
ATOM    885  CA  LEU A 128      37.045  42.168  -2.398  1.00 33.94           C  
ATOM    886  C   LEU A 128      36.953  43.035  -3.649  1.00 37.02           C  
ATOM    887  O   LEU A 128      37.494  44.144  -3.700  1.00 40.11           O  
ATOM    888  CB  LEU A 128      37.900  40.932  -2.660  1.00 38.65           C  
ATOM    889  CG  LEU A 128      39.426  41.084  -2.705  1.00 33.96           C  
ATOM    890  CD1 LEU A 128      39.911  42.219  -1.821  1.00 41.91           C  
ATOM    891  CD2 LEU A 128      40.019  39.782  -2.260  1.00 30.17           C  
ATOM    892  N   GLU A 129      36.233  42.534  -4.643  1.00 36.96           N  
ATOM    893  CA  GLU A 129      36.067  43.245  -5.890  1.00 36.11           C  
ATOM    894  C   GLU A 129      35.471  44.626  -5.684  1.00 38.11           C  
ATOM    895  O   GLU A 129      35.757  45.540  -6.452  1.00 46.69           O  
ATOM    896  CB  GLU A 129      35.194  42.436  -6.831  1.00 41.13           C  
ATOM    897  CG  GLU A 129      35.747  42.400  -8.240  1.00 63.81           C  
ATOM    898  CD  GLU A 129      37.158  41.822  -8.294  1.00 70.34           C  
ATOM    899  OE1 GLU A 129      37.317  40.597  -8.032  1.00 60.60           O  
ATOM    900  OE2 GLU A 129      38.096  42.605  -8.593  1.00 64.14           O  
ATOM    901  N   ASP A 130      34.640  44.786  -4.663  1.00 31.94           N  
ATOM    902  CA  ASP A 130      34.054  46.094  -4.395  1.00 39.78           C  
ATOM    903  C   ASP A 130      35.098  46.956  -3.710  1.00 41.08           C  
ATOM    904  O   ASP A 130      35.203  48.161  -3.967  1.00 39.60           O  
ATOM    905  CB  ASP A 130      32.821  45.973  -3.493  1.00 41.79           C  
ATOM    906  CG  ASP A 130      31.771  45.036  -4.064  1.00 50.35           C  
ATOM    907  OD1 ASP A 130      31.194  45.358  -5.118  1.00 46.10           O  
ATOM    908  OD2 ASP A 130      31.531  43.964  -3.460  1.00 63.01           O  
ATOM    909  N   LEU A 131      35.873  46.335  -2.828  1.00 40.17           N  
ATOM    910  CA  LEU A 131      36.907  47.081  -2.135  1.00 41.59           C  
ATOM    911  C   LEU A 131      37.809  47.651  -3.197  1.00 42.67           C  
ATOM    912  O   LEU A 131      38.167  48.825  -3.156  1.00 41.81           O  
ATOM    913  CB  LEU A 131      37.726  46.191  -1.202  1.00 43.85           C  
ATOM    914  CG  LEU A 131      38.809  46.957  -0.429  1.00 42.74           C  
ATOM    915  CD1 LEU A 131      38.182  48.121   0.341  1.00 37.11           C  
ATOM    916  CD2 LEU A 131      39.520  46.031   0.518  1.00 40.88           C  
ATOM    917  N   VAL A 132      38.150  46.796  -4.154  1.00 37.96           N  
ATOM    918  CA  VAL A 132      39.020  47.171  -5.248  1.00 39.82           C  
ATOM    919  C   VAL A 132      38.432  48.300  -6.083  1.00 45.44           C  
ATOM    920  O   VAL A 132      39.117  49.292  -6.324  1.00 49.73           O  
ATOM    921  CB  VAL A 132      39.331  45.950  -6.142  1.00 39.89           C  
ATOM    922  CG1 VAL A 132      40.066  46.379  -7.394  1.00 27.44           C  
ATOM    923  CG2 VAL A 132      40.178  44.969  -5.362  1.00 28.94           C  
ATOM    924  N   ARG A 133      37.178  48.172  -6.515  1.00 40.34           N  
ATOM    925  CA  ARG A 133      36.572  49.242  -7.309  1.00 45.26           C  
ATOM    926  C   ARG A 133      36.650  50.554  -6.540  1.00 45.16           C  
ATOM    927  O   ARG A 133      36.943  51.618  -7.109  1.00 42.17           O  
ATOM    928  CB  ARG A 133      35.106  48.940  -7.638  1.00 43.49           C  
ATOM    929  CG  ARG A 133      34.923  47.964  -8.793  1.00 57.99           C  
ATOM    930  CD  ARG A 133      33.446  47.678  -9.085  1.00 68.97           C  
ATOM    931  NE  ARG A 133      33.279  46.738 -10.197  1.00 82.91           N  
ATOM    932  CZ  ARG A 133      32.102  46.322 -10.672  1.00 90.87           C  
ATOM    933  NH1 ARG A 133      30.959  46.758 -10.139  1.00 86.46           N  
ATOM    934  NH2 ARG A 133      32.065  45.458 -11.681  1.00 89.58           N  
ATOM    935  N   TYR A 134      36.386  50.466  -5.242  1.00 36.22           N  
ATOM    936  CA  TYR A 134      36.422  51.634  -4.389  1.00 36.71           C  
ATOM    937  C   TYR A 134      37.816  52.240  -4.383  1.00 38.01           C  
ATOM    938  O   TYR A 134      37.986  53.453  -4.500  1.00 40.78           O  
ATOM    939  CB  TYR A 134      36.059  51.261  -2.956  1.00 39.03           C  
ATOM    940  CG  TYR A 134      36.288  52.414  -2.031  1.00 36.57           C  
ATOM    941  CD1 TYR A 134      35.377  53.461  -1.968  1.00 35.07           C  
ATOM    942  CD2 TYR A 134      37.438  52.481  -1.238  1.00 41.43           C  
ATOM    943  CE1 TYR A 134      35.588  54.542  -1.138  1.00 33.77           C  
ATOM    944  CE2 TYR A 134      37.667  53.560  -0.409  1.00 34.99           C  
ATOM    945  CZ  TYR A 134      36.726  54.588  -0.355  1.00 42.56           C  
ATOM    946  OH  TYR A 134      36.881  55.630   0.527  1.00 46.31           O  
ATOM    947  N   VAL A 135      38.814  51.391  -4.198  1.00 30.31           N  
ATOM    948  CA  VAL A 135      40.181  51.873  -4.195  1.00 43.46           C  
ATOM    949  C   VAL A 135      40.503  52.550  -5.529  1.00 36.24           C  
ATOM    950  O   VAL A 135      41.127  53.602  -5.549  1.00 32.14           O  
ATOM    951  CB  VAL A 135      41.198  50.728  -3.951  1.00 49.66           C  
ATOM    952  CG1 VAL A 135      42.609  51.285  -4.004  1.00 49.90           C  
ATOM    953  CG2 VAL A 135      40.947  50.077  -2.593  1.00 40.83           C  
ATOM    954  N   GLU A 136      40.073  51.945  -6.634  1.00 30.60           N  
ATOM    955  CA  GLU A 136      40.313  52.518  -7.954  1.00 35.61           C  
ATOM    956  C   GLU A 136      39.729  53.910  -8.119  1.00 39.88           C  
ATOM    957  O   GLU A 136      40.356  54.768  -8.746  1.00 51.73           O  
ATOM    958  CB  GLU A 136      39.737  51.630  -9.056  1.00 37.64           C  
ATOM    959  CG  GLU A 136      40.554  50.390  -9.359  1.00 34.31           C  
ATOM    960  CD  GLU A 136      42.016  50.726  -9.616  1.00 47.31           C  
ATOM    961  OE1 GLU A 136      42.282  51.845 -10.116  1.00 41.62           O  
ATOM    962  OE2 GLU A 136      42.883  49.869  -9.330  1.00 40.16           O  
ATOM    963  N   SER A 137      38.539  54.141  -7.563  1.00 31.48           N  
ATOM    964  CA  SER A 137      37.897  55.438  -7.682  1.00 30.46           C  
ATOM    965  C   SER A 137      38.635  56.489  -6.872  1.00 37.57           C  
ATOM    966  O   SER A 137      38.527  57.683  -7.153  1.00 42.87           O  
ATOM    967  CB  SER A 137      36.421  55.370  -7.251  1.00 41.72           C  
ATOM    968  OG  SER A 137      36.268  55.374  -5.838  1.00 57.06           O  
ATOM    969  N   LYS A 138      39.390  56.047  -5.866  1.00 42.66           N  
ATOM    970  CA  LYS A 138      40.164  56.967  -5.038  1.00 37.86           C  
ATOM    971  C   LYS A 138      41.442  57.343  -5.756  1.00 40.30           C  
ATOM    972  O   LYS A 138      41.991  58.426  -5.550  1.00 42.39           O  
ATOM    973  CB  LYS A 138      40.465  56.350  -3.668  1.00 47.03           C  
ATOM    974  CG  LYS A 138      39.266  56.445  -2.718  1.00 59.50           C  
ATOM    975  CD  LYS A 138      39.680  56.302  -1.257  1.00 78.56           C  
ATOM    976  CE  LYS A 138      40.701  57.382  -0.832  1.00 80.24           C  
ATOM    977  NZ  LYS A 138      41.180  57.207   0.573  1.00 62.05           N  
ATOM    978  N   ILE A 139      41.913  56.439  -6.604  1.00 39.91           N  
ATOM    979  CA  ILE A 139      43.090  56.699  -7.405  1.00 32.84           C  
ATOM    980  C   ILE A 139      42.683  57.745  -8.416  1.00 39.83           C  
ATOM    981  O   ILE A 139      43.362  58.748  -8.592  1.00 50.73           O  
ATOM    982  CB  ILE A 139      43.534  55.458  -8.160  1.00 39.03           C  
ATOM    983  CG1 ILE A 139      44.125  54.452  -7.161  1.00 37.52           C  
ATOM    984  CG2 ILE A 139      44.504  55.854  -9.283  1.00 33.95           C  
ATOM    985  CD1 ILE A 139      44.531  53.131  -7.760  1.00 44.86           C  
ATOM    986  N   SER A 140      41.548  57.514  -9.067  1.00 48.81           N  
ATOM    987  CA  SER A 140      41.046  58.445 -10.071  1.00 43.86           C  
ATOM    988  C   SER A 140      40.861  59.823  -9.468  1.00 48.57           C  
ATOM    989  O   SER A 140      41.183  60.827 -10.100  1.00 55.88           O  
ATOM    990  CB  SER A 140      39.716  57.951 -10.639  1.00 47.37           C  
ATOM    991  OG  SER A 140      39.884  56.736 -11.341  1.00 45.91           O  
ATOM    992  N   ARG A 141      40.329  59.867  -8.251  1.00 48.07           N  
ATOM    993  CA  ARG A 141      40.110  61.121  -7.545  1.00 47.24           C  
ATOM    994  C   ARG A 141      41.431  61.901  -7.493  1.00 52.06           C  
ATOM    995  O   ARG A 141      41.502  63.108  -7.755  1.00 50.21           O  
ATOM    996  CB  ARG A 141      39.623  60.816  -6.126  1.00 55.56           C  
ATOM    997  CG  ARG A 141      39.512  62.033  -5.222  1.00 66.31           C  
ATOM    998  CD  ARG A 141      39.061  61.654  -3.825  1.00 65.09           C  
ATOM    999  NE  ARG A 141      37.752  61.008  -3.838  1.00 69.12           N  
ATOM   1000  CZ  ARG A 141      36.969  60.870  -2.768  1.00 71.19           C  
ATOM   1001  NH1 ARG A 141      37.364  61.337  -1.589  1.00 47.84           N  
ATOM   1002  NH2 ARG A 141      35.786  60.270  -2.878  1.00 64.37           N  
ATOM   1003  N   THR A 142      42.483  61.177  -7.157  1.00 52.15           N  
ATOM   1004  CA  THR A 142      43.813  61.742  -7.048  1.00 57.08           C  
ATOM   1005  C   THR A 142      44.303  62.391  -8.343  1.00 52.81           C  
ATOM   1006  O   THR A 142      44.969  63.424  -8.304  1.00 54.44           O  
ATOM   1007  CB  THR A 142      44.805  60.635  -6.606  1.00 56.16           C  
ATOM   1008  OG1 THR A 142      44.484  60.223  -5.267  1.00 43.20           O  
ATOM   1009  CG2 THR A 142      46.229  61.136  -6.668  1.00 57.46           C  
ATOM   1010  N   LEU A 143      43.953  61.786  -9.478  1.00 50.58           N  
ATOM   1011  CA  LEU A 143      44.358  62.257 -10.806  1.00 49.34           C  
ATOM   1012  C   LEU A 143      43.381  63.260 -11.464  1.00 53.45           C  
ATOM   1013  O   LEU A 143      43.702  63.882 -12.493  1.00 44.21           O  
ATOM   1014  CB  LEU A 143      44.523  61.050 -11.739  1.00 48.46           C  
ATOM   1015  CG  LEU A 143      45.327  59.827 -11.271  1.00 50.14           C  
ATOM   1016  CD1 LEU A 143      44.949  58.618 -12.111  1.00 50.52           C  
ATOM   1017  CD2 LEU A 143      46.815  60.099 -11.374  1.00 40.69           C  
ATOM   1018  N   ASP A 144      42.195  63.410 -10.874  1.00 47.15           N  
ATOM   1019  CA  ASP A 144      41.160  64.306 -11.402  1.00 44.55           C  
ATOM   1020  C   ASP A 144      41.537  65.771 -11.184  1.00 43.06           C  
ATOM   1021  O   ASP A 144      42.373  66.094 -10.342  1.00 47.80           O  
ATOM   1022  CB  ASP A 144      39.832  64.007 -10.701  1.00 45.51           C  
ATOM   1023  CG  ASP A 144      38.621  64.203 -11.594  1.00 47.37           C  
ATOM   1024  OD1 ASP A 144      38.748  64.644 -12.759  1.00 41.25           O  
ATOM   1025  OD2 ASP A 144      37.516  63.905 -11.103  1.00 43.22           O  
ATOM   1026  N   SER A 145      40.935  66.647 -11.974  1.00 38.52           N  
ATOM   1027  CA  SER A 145      41.159  68.085 -11.873  1.00 44.41           C  
ATOM   1028  C   SER A 145      39.803  68.648 -12.249  1.00 41.11           C  
ATOM   1029  O   SER A 145      39.030  67.974 -12.933  1.00 40.42           O  
ATOM   1030  CB  SER A 145      42.248  68.563 -12.862  1.00 49.92           C  
ATOM   1031  OG  SER A 145      41.848  68.424 -14.222  1.00 49.11           O  
ATOM   1032  N   PHE A 146      39.474  69.853 -11.805  1.00 48.96           N  
ATOM   1033  CA  PHE A 146      38.165  70.351 -12.172  1.00 55.77           C  
ATOM   1034  C   PHE A 146      38.133  71.291 -13.340  1.00 58.19           C  
ATOM   1035  O   PHE A 146      38.887  71.114 -14.297  1.00 52.13           O  
ATOM   1036  CB  PHE A 146      37.403  70.956 -10.971  1.00 68.81           C  
ATOM   1037  CG  PHE A 146      38.126  72.042 -10.222  1.00 59.30           C  
ATOM   1038  CD1 PHE A 146      39.127  71.730  -9.312  1.00 62.66           C  
ATOM   1039  CD2 PHE A 146      37.710  73.369 -10.332  1.00 72.14           C  
ATOM   1040  CE1 PHE A 146      39.699  72.720  -8.509  1.00 65.74           C  
ATOM   1041  CE2 PHE A 146      38.270  74.373  -9.540  1.00 69.10           C  
ATOM   1042  CZ  PHE A 146      39.269  74.043  -8.624  1.00 79.35           C  
ATOM   1043  N   LEU A 147      37.243  72.278 -13.257  1.00 68.09           N  
ATOM   1044  CA  LEU A 147      37.054  73.271 -14.309  1.00 61.71           C  
ATOM   1045  C   LEU A 147      36.972  72.453 -15.577  1.00 56.56           C  
ATOM   1046  O   LEU A 147      36.459  71.308 -15.507  1.00 56.63           O  
ATOM   1047  CB  LEU A 147      38.244  74.243 -14.371  1.00 69.10           C  
ATOM   1048  CG  LEU A 147      37.980  75.674 -14.863  1.00 80.26           C  
ATOM   1049  CD1 LEU A 147      37.109  76.412 -13.832  1.00 82.53           C  
ATOM   1050  CD2 LEU A 147      39.301  76.422 -15.070  1.00 73.35           C  
ATOM   1051  OXT LEU A 147      37.426  72.959 -16.614  1.00 64.82           O  
TER    1052      LEU A 147                                                      
END
MOLECULE T0495_5_143.pdb
ATOM      1  N   LEU     5      45.969  23.478   3.252  1.00 38.14           N  
ATOM      2  CA  LEU     5      46.490  24.710   3.921  1.00 38.30           C  
ATOM      3  C   LEU     5      46.362  24.598   5.434  1.00 38.70           C  
ATOM      4  O   LEU     5      45.265  24.375   5.947  1.00 38.88           O  
ATOM      5  CB  LEU     5      45.724  25.958   3.463  1.00 37.92           C  
ATOM      6  CG  LEU     5      45.678  26.334   1.977  1.00 37.39           C  
ATOM      7  CD1 LEU     5      45.154  27.777   1.825  1.00 35.18           C  
ATOM      8  CD2 LEU     5      47.048  26.165   1.302  1.00 36.39           C  
ATOM      9  N   ASP     6      47.483  24.733   6.143  1.00 39.19           N  
ATOM     10  CA  ASP     6      47.446  25.021   7.581  1.00 39.51           C  
ATOM     11  C   ASP     6      47.751  26.510   7.753  1.00 39.87           C  
ATOM     12  O   ASP     6      48.840  26.914   8.171  1.00 39.97           O  
ATOM     13  CB  ASP     6      48.340  24.100   8.452  1.00 39.40           C  
ATOM     14  CG  ASP     6      49.600  23.620   7.748  1.00 39.37           C  
ATOM     15  OD1 ASP     6      50.647  23.504   8.421  1.00 38.77           O  
ATOM     16  OD2 ASP     6      49.544  23.326   6.537  1.00 39.57           O  
ATOM     17  N   LEU     7      46.768  27.313   7.358  1.00 40.08           N  
ATOM     18  CA  LEU     7      46.722  28.728   7.677  1.00 40.61           C  
ATOM     19  C   LEU     7      45.600  28.932   8.688  1.00 41.15           C  
ATOM     20  O   LEU     7      44.546  28.297   8.592  1.00 40.41           O  
ATOM     21  CB  LEU     7      46.399  29.569   6.436  1.00 40.38           C  
ATOM     22  CG  LEU     7      47.368  29.613   5.253  1.00 40.99           C  
ATOM     23  CD1 LEU     7      46.776  30.487   4.151  1.00 40.42           C  
ATOM     24  CD2 LEU     7      48.755  30.110   5.651  1.00 40.43           C  
ATOM     25  N   GLN     8      45.822  29.829   9.645  1.00 42.24           N  
ATOM     26  CA  GLN     8      44.777  30.227  10.594  0.50 42.53           C  
ATOM     28  C   GLN     8      43.743  31.071   9.854  1.00 42.85           C  
ATOM     29  O   GLN     8      44.022  31.579   8.770  1.00 42.28           O  
ATOM     30  CB  GLN     8      45.380  31.029  11.755  0.50 42.65           C  
ATOM     32  CG  GLN     8      46.000  30.178  12.865  0.50 42.48           C  
ATOM     34  CD  GLN     8      46.979  30.965  13.716  0.50 41.89           C  
ATOM     36  OE1 GLN     8      47.364  32.081  13.364  0.50 41.95           O  
ATOM     38  NE2 GLN     8      47.383  30.391  14.844  0.50 42.22           N  
ATOM     40  N   PRO     9      42.535  31.223  10.429  1.00 43.65           N  
ATOM     41  CA  PRO     9      41.490  32.001   9.715  1.00 44.43           C  
ATOM     42  C   PRO     9      41.901  33.416   9.236  1.00 44.22           C  
ATOM     43  O   PRO     9      41.615  33.806   8.091  1.00 43.49           O  
ATOM     44  CB  PRO     9      40.349  32.054  10.740  1.00 44.78           C  
ATOM     45  CG  PRO     9      40.523  30.818  11.560  1.00 44.24           C  
ATOM     46  CD  PRO     9      42.019  30.661  11.700  1.00 43.75           C  
ATOM     47  N   GLY    10      42.574  34.186  10.086  1.00 44.09           N  
ATOM     48  CA  GLY    10      43.013  35.529   9.648  1.00 43.34           C  
ATOM     49  C   GLY    10      44.032  35.469   8.522  1.00 42.61           C  
ATOM     50  O   GLY    10      44.066  36.326   7.604  1.00 41.75           O  
ATOM     51  N   GLN    11      44.888  34.449   8.568  1.00 41.40           N  
ATOM     52  CA  GLN    11      45.884  34.302   7.538  1.00 40.04           C  
ATOM     53  C   GLN    11      45.242  33.961   6.211  1.00 38.83           C  
ATOM     54  O   GLN    11      45.787  34.295   5.169  1.00 39.89           O  
ATOM     55  CB  GLN    11      46.923  33.237   7.912  1.00 40.06           C  
ATOM     56  CG  GLN    11      47.873  33.655   9.035  1.00 40.33           C  
ATOM     57  CD  GLN    11      48.812  32.554   9.432  1.00 39.18           C  
ATOM     58  OE1 GLN    11      48.393  31.427   9.692  1.00 35.18           O  
ATOM     59  NE2 GLN    11      50.104  32.878   9.507  1.00 42.19           N  
ATOM     60  N   ARG    12      44.143  33.225   6.264  1.00 38.76           N  
ATOM     61  CA  ARG    12      43.395  32.852   5.071  1.00 37.01           C  
ATOM     62  C   ARG    12      42.862  34.084   4.372  1.00 34.65           C  
ATOM     63  O   ARG    12      43.071  34.264   3.181  1.00 34.81           O  
ATOM     64  CB  ARG    12      42.259  31.896   5.463  1.00 37.53           C  
ATOM     65  CG  ARG    12      42.702  30.436   5.681  1.00 38.59           C  
ATOM     66  CD  ARG    12      41.510  29.554   5.999  1.00 40.97           C  
ATOM     67  NE  ARG    12      41.799  28.128   5.848  1.00 43.25           N  
ATOM     68  CZ  ARG    12      41.525  27.376   4.772  1.00 44.47           C  
ATOM     69  NH1 ARG    12      41.831  26.083   4.792  1.00 45.36           N  
ATOM     70  NH2 ARG    12      40.948  27.879   3.678  1.00 44.66           N  
ATOM     71  N   LEU    13      42.158  34.928   5.123  1.00 32.91           N  
ATOM     72  CA  LEU    13      41.636  36.175   4.576  1.00 32.29           C  
ATOM     73  C   LEU    13      42.781  37.003   3.992  1.00 31.74           C  
ATOM     74  O   LEU    13      42.652  37.507   2.888  1.00 32.08           O  
ATOM     75  CB  LEU    13      40.873  36.994   5.637  1.00 32.92           C  
ATOM     76  CG  LEU    13      39.624  36.366   6.268  1.00 32.94           C  
ATOM     77  CD1 LEU    13      39.141  37.186   7.487  1.00 32.58           C  
ATOM     78  CD2 LEU    13      38.540  36.270   5.227  1.00 33.66           C  
ATOM     79  N   ALA    14      43.911  37.089   4.709  1.00 30.28           N  
ATOM     80  CA  ALA    14      45.002  37.910   4.250  1.00 30.35           C  
ATOM     81  C   ALA    14      45.583  37.382   2.911  1.00 29.01           C  
ATOM     82  O   ALA    14      46.110  38.152   2.106  1.00 29.67           O  
ATOM     83  CB  ALA    14      46.100  38.001   5.295  1.00 28.79           C  
ATOM     84  N   ARG    15      45.564  36.067   2.742  1.00 29.40           N  
ATOM     85  CA  ARG    15      46.005  35.465   1.454  1.00 29.83           C  
ATOM     86  C   ARG    15      45.180  35.916   0.310  1.00 29.24           C  
ATOM     87  O   ARG    15      45.718  36.353  -0.705  1.00 29.13           O  
ATOM     88  CB  ARG    15      46.007  33.936   1.546  1.00 30.37           C  
ATOM     89  CG  ARG    15      46.706  33.192   0.384  1.00 33.54           C  
ATOM     90  CD  ARG    15      46.524  31.724   0.763  1.00 39.34           C  
ATOM     91  NE  ARG    15      47.240  30.768  -0.023  1.00 41.73           N  
ATOM     92  CZ  ARG    15      46.689  29.951  -0.914  1.00 45.31           C  
ATOM     93  NH1 ARG    15      47.475  29.075  -1.533  1.00 45.52           N  
ATOM     94  NH2 ARG    15      45.386  30.002  -1.208  1.00 44.25           N  
ATOM     95  N   GLY    16      43.861  35.891   0.491  1.00 30.12           N  
ATOM     96  CA  GLY    16      42.936  36.343  -0.551  1.00 29.24           C  
ATOM     97  C   GLY    16      43.027  37.801  -0.808  1.00 29.52           C  
ATOM     98  O   GLY    16      43.063  38.242  -1.969  1.00 28.36           O  
ATOM     99  N   VAL    17      43.194  38.586   0.266  1.00 28.25           N  
ATOM    100  CA  VAL    17      43.387  40.014   0.101  1.00 27.59           C  
ATOM    101  C   VAL    17      44.646  40.337  -0.728  1.00 28.51           C  
ATOM    102  O   VAL    17      44.596  41.192  -1.661  1.00 28.26           O  
ATOM    103  CB  VAL    17      43.427  40.759   1.499  1.00 26.92           C  
ATOM    104  CG1 VAL    17      43.811  42.212   1.297  1.00 28.67           C  
ATOM    105  CG2 VAL    17      42.063  40.649   2.219  1.00 28.70           C  
ATOM    106  N   ALA    18      45.763  39.686  -0.367  1.00 28.55           N  
ATOM    107  CA  ALA    18      47.044  39.873  -1.053  1.00 27.98           C  
ATOM    108  C   ALA    18      46.959  39.510  -2.562  1.00 28.27           C  
ATOM    109  O   ALA    18      47.528  40.229  -3.403  1.00 27.57           O  
ATOM    110  CB  ALA    18      48.130  39.095  -0.372  1.00 27.73           C  
ATOM    111  N   ARG    19      46.283  38.412  -2.870  1.00 30.15           N  
ATOM    112  CA  ARG    19      46.061  38.000  -4.298  1.00 30.28           C  
ATOM    113  C   ARG    19      45.359  39.097  -5.014  1.00 30.51           C  
ATOM    114  O   ARG    19      45.758  39.480  -6.116  1.00 31.11           O  
ATOM    115  CB  ARG    19      45.260  36.717  -4.396  1.00 30.44           C  
ATOM    116  CG  ARG    19      45.997  35.514  -3.985  1.00 32.15           C  
ATOM    117  CD  ARG    19      45.114  34.276  -3.945  1.00 30.90           C  
ATOM    118  NE  ARG    19      45.927  33.072  -3.860  1.00 30.71           N  
ATOM    119  CZ  ARG    19      45.606  31.900  -4.405  1.00 34.06           C  
ATOM    120  NH1 ARG    19      44.443  31.701  -5.024  1.00 34.11           N  
ATOM    121  NH2 ARG    19      46.432  30.889  -4.286  1.00 36.45           N  
ATOM    122  N   HIS    20      44.283  39.638  -4.396  1.00 31.84           N  
ATOM    123  CA  HIS    20      43.448  40.623  -5.069  1.00 30.13           C  
ATOM    124  C   HIS    20      44.146  41.962  -5.243  1.00 29.99           C  
ATOM    125  O   HIS    20      44.067  42.583  -6.320  1.00 29.25           O  
ATOM    126  CB  HIS    20      42.099  40.805  -4.311  1.00 32.18           C  
ATOM    127  CG  HIS    20      41.118  41.669  -5.043  1.00 32.57           C  
ATOM    128  ND1 HIS    20      40.643  41.347  -6.295  1.00 33.23           N  
ATOM    129  CD2 HIS    20      40.597  42.888  -4.744  1.00 33.95           C  
ATOM    130  CE1 HIS    20      39.823  42.289  -6.703  1.00 33.99           C  
ATOM    131  NE2 HIS    20      39.783  43.238  -5.787  1.00 34.24           N  
ATOM    132  N   LEU    21      44.868  42.414  -4.211  1.00 28.80           N  
ATOM    133  CA  LEU    21      45.686  43.625  -4.315  1.00 30.87           C  
ATOM    134  C   LEU    21      46.682  43.491  -5.482  1.00 29.17           C  
ATOM    135  O   LEU    21      46.804  44.376  -6.308  1.00 29.80           O  
ATOM    136  CB  LEU    21      46.482  43.894  -3.033  1.00 30.12           C  
ATOM    137  CG  LEU    21      45.643  44.421  -1.869  1.00 34.58           C  
ATOM    138  CD1 LEU    21      46.525  44.462  -0.604  1.00 34.39           C  
ATOM    139  CD2 LEU    21      45.094  45.789  -2.178  1.00 36.07           C  
ATOM    140  N   ARG    22      47.320  42.351  -5.570  1.00 30.71           N  
ATOM    141  CA  ARG    22      48.371  42.149  -6.583  1.00 30.39           C  
ATOM    142  C   ARG    22      47.770  42.163  -8.013  1.00 30.86           C  
ATOM    143  O   ARG    22      48.362  42.730  -8.958  1.00 30.07           O  
ATOM    144  CB  ARG    22      49.180  40.892  -6.278  1.00 30.93           C  
ATOM    145  CG  ARG    22      50.300  40.579  -7.284  1.00 33.89           C  
ATOM    146  CD  ARG    22      50.938  39.237  -7.047  1.00 35.51           C  
ATOM    147  NE  ARG    22      51.936  39.087  -8.082  1.00 34.57           N  
ATOM    148  CZ  ARG    22      53.195  38.696  -7.913  1.00 35.50           C  
ATOM    149  NH1 ARG    22      53.656  38.311  -6.722  1.00 33.15           N  
ATOM    150  NH2 ARG    22      53.992  38.675  -8.980  1.00 34.96           N  
ATOM    151  N   ALA    23      46.619  41.553  -8.157  1.00 31.76           N  
ATOM    152  CA  ALA    23      45.849  41.569  -9.439  1.00 32.88           C  
ATOM    153  C   ALA    23      45.550  42.992  -9.922  1.00 34.72           C  
ATOM    154  O   ALA    23      45.422  43.265 -11.137  1.00 34.07           O  
ATOM    155  CB  ALA    23      44.571  40.794  -9.272  1.00 32.37           C  
ATOM    156  N   HIS    24      45.474  43.934  -8.975  1.00 36.04           N  
ATOM    157  CA  HIS    24      45.250  45.334  -9.327  1.00 36.14           C  
ATOM    158  C   HIS    24      46.427  46.284  -9.110  1.00 36.10           C  
ATOM    159  O   HIS    24      46.213  47.500  -8.923  1.00 36.57           O  
ATOM    160  CB  HIS    24      44.025  45.790  -8.591  1.00 36.62           C  
ATOM    161  CG  HIS    24      42.773  45.148  -9.090  1.00 39.20           C  
ATOM    162  ND1 HIS    24      42.127  45.574 -10.237  1.00 41.39           N  
ATOM    163  CD2 HIS    24      42.067  44.098  -8.626  1.00 39.99           C  
ATOM    164  CE1 HIS    24      41.058  44.825 -10.430  1.00 39.92           C  
ATOM    165  NE2 HIS    24      40.992  43.935  -9.463  1.00 41.57           N  
ATOM    166  N   GLY    25      47.648  45.767  -9.216  1.00 34.51           N  
ATOM    167  CA  GLY    25      48.872  46.573  -9.196  1.00 34.38           C  
ATOM    168  C   GLY    25      49.382  47.076  -7.851  1.00 33.84           C  
ATOM    169  O   GLY    25      50.367  47.828  -7.794  1.00 34.39           O  
ATOM    170  N   PHE    26      48.728  46.641  -6.770  1.00 33.03           N  
ATOM    171  CA  PHE    26      49.200  46.859  -5.425  1.00 32.41           C  
ATOM    172  C   PHE    26      50.146  45.720  -5.008  1.00 32.82           C  
ATOM    173  O   PHE    26      50.234  44.666  -5.664  1.00 32.25           O  
ATOM    174  CB  PHE    26      48.025  46.976  -4.449  1.00 32.87           C  
ATOM    175  CG  PHE    26      47.435  48.362  -4.362  1.00 32.59           C  
ATOM    176  CD1 PHE    26      46.831  48.948  -5.485  1.00 34.19           C  
ATOM    177  CD2 PHE    26      47.400  49.042  -3.149  1.00 32.00           C  
ATOM    178  CE1 PHE    26      46.270  50.199  -5.411  1.00 37.10           C  
ATOM    179  CE2 PHE    26      46.877  50.306  -3.076  1.00 33.19           C  
ATOM    180  CZ  PHE    26      46.282  50.893  -4.197  1.00 35.86           C  
ATOM    181  N   VAL    27      50.932  45.975  -3.970  1.00 30.86           N  
ATOM    182  CA  VAL    27      51.683  44.924  -3.297  1.00 29.69           C  
ATOM    183  C   VAL    27      51.322  44.998  -1.817  1.00 29.17           C  
ATOM    184  O   VAL    27      50.713  45.972  -1.374  1.00 30.58           O  
ATOM    185  CB  VAL    27      53.209  45.090  -3.475  1.00 29.88           C  
ATOM    186  CG1 VAL    27      53.601  44.831  -4.983  1.00 29.49           C  
ATOM    187  CG2 VAL    27      53.673  46.482  -3.043  1.00 28.47           C  
ATOM    188  N   SER    28      51.737  44.016  -1.055  1.00 28.60           N  
ATOM    189  CA  SER    28      51.295  43.942   0.339  1.00 27.97           C  
ATOM    190  C   SER    28      52.312  43.216   1.192  1.00 26.85           C  
ATOM    191  O   SER    28      53.161  42.470   0.690  1.00 26.63           O  
ATOM    192  CB  SER    28      49.943  43.289   0.447  1.00 27.40           C  
ATOM    193  OG  SER    28      49.995  41.929   0.001  1.00 28.09           O  
ATOM    194  N   VAL    29      52.217  43.471   2.498  1.00 26.32           N  
ATOM    195  CA  VAL    29      52.868  42.663   3.499  1.00 26.09           C  
ATOM    196  C   VAL    29      51.869  42.358   4.612  1.00 26.69           C  
ATOM    197  O   VAL    29      50.835  43.029   4.767  1.00 25.06           O  
ATOM    198  CB  VAL    29      54.155  43.294   4.125  1.00 25.96           C  
ATOM    199  CG1 VAL    29      55.258  43.478   3.036  1.00 26.47           C  
ATOM    200  CG2 VAL    29      53.900  44.569   4.878  1.00 24.70           C  
ATOM    201  N   GLU    30      52.207  41.357   5.394  1.00 26.99           N  
ATOM    202  CA  GLU    30      51.408  41.000   6.527  1.00 28.70           C  
ATOM    203  C   GLU    30      52.057  41.354   7.867  1.00 27.60           C  
ATOM    204  O   GLU    30      53.291  41.412   8.015  1.00 27.17           O  
ATOM    205  CB  GLU    30      51.109  39.498   6.493  1.00 29.53           C  
ATOM    206  CG  GLU    30      50.082  39.067   5.504  1.00 35.04           C  
ATOM    207  CD  GLU    30      49.665  37.586   5.712  1.00 43.13           C  
ATOM    208  OE1 GLU    30      49.320  37.173   6.875  1.00 48.65           O  
ATOM    209  OE2 GLU    30      49.648  36.838   4.713  1.00 39.81           O  
ATOM    210  N   GLU    31      51.198  41.593   8.857  1.00 27.51           N  
ATOM    211  CA  GLU    31      51.636  41.860  10.236  0.50 27.73           C  
ATOM    213  C   GLU    31      52.614  43.012  10.285  1.00 26.70           C  
ATOM    214  O   GLU    31      53.692  42.906  10.816  1.00 26.95           O  
ATOM    215  CB  GLU    31      52.244  40.596  10.829  0.50 28.41           C  
ATOM    217  CG  GLU    31      51.309  39.425  10.700  0.50 31.21           C  
ATOM    219  CD  GLU    31      51.797  38.212  11.432  0.50 35.16           C  
ATOM    221  OE1 GLU    31      52.986  37.874  11.284  0.50 39.43           O  
ATOM    223  OE2 GLU    31      50.974  37.584  12.139  0.50 39.69           O  
ATOM    225  N   PHE    32      52.203  44.124   9.708  1.00 26.33           N  
ATOM    226  CA  PHE    32      53.002  45.304   9.636  1.00 25.68           C  
ATOM    227  C   PHE    32      52.885  46.230  10.859  1.00 24.65           C  
ATOM    228  O   PHE    32      51.773  46.526  11.312  1.00 24.12           O  
ATOM    229  CB  PHE    32      52.590  46.095   8.426  1.00 25.46           C  
ATOM    230  CG  PHE    32      53.404  47.298   8.222  1.00 24.52           C  
ATOM    231  CD1 PHE    32      52.884  48.541   8.491  1.00 25.16           C  
ATOM    232  CD2 PHE    32      54.720  47.194   7.800  1.00 25.34           C  
ATOM    233  CE1 PHE    32      53.623  49.672   8.297  1.00 26.20           C  
ATOM    234  CE2 PHE    32      55.472  48.331   7.635  1.00 25.96           C  
ATOM    235  CZ  PHE    32      54.918  49.579   7.866  1.00 25.05           C  
ATOM    236  N   VAL    33      54.016  46.731  11.327  1.00 24.23           N  
ATOM    237  CA  VAL    33      54.088  47.595  12.530  1.00 23.50           C  
ATOM    238  C   VAL    33      54.357  49.052  12.142  1.00 24.37           C  
ATOM    239  O   VAL    33      55.509  49.435  11.869  1.00 24.23           O  
ATOM    240  CB  VAL    33      55.151  47.131  13.517  1.00 24.23           C  
ATOM    241  CG1 VAL    33      55.280  48.117  14.691  1.00 22.24           C  
ATOM    242  CG2 VAL    33      54.843  45.743  14.017  1.00 24.19           C  
ATOM    243  N   PRO    34      53.306  49.884  12.111  1.00 24.54           N  
ATOM    244  CA  PRO    34      53.506  51.294  11.752  1.00 25.71           C  
ATOM    245  C   PRO    34      54.085  52.172  12.867  1.00 26.84           C  
ATOM    246  O   PRO    34      54.626  53.251  12.588  1.00 27.21           O  
ATOM    247  CB  PRO    34      52.098  51.740  11.346  1.00 25.67           C  
ATOM    248  CG  PRO    34      51.161  50.843  12.130  1.00 25.17           C  
ATOM    249  CD  PRO    34      51.885  49.550  12.356  1.00 25.17           C  
ATOM    250  N   ALA    35      53.966  51.715  14.109  1.00 27.43           N  
ATOM    251  CA  ALA    35      54.412  52.460  15.275  1.00 29.07           C  
ATOM    252  C   ALA    35      54.355  51.486  16.435  1.00 29.37           C  
ATOM    253  O   ALA    35      53.620  50.492  16.383  1.00 27.54           O  
ATOM    254  CB  ALA    35      53.500  53.676  15.555  1.00 29.70           C  
ATOM    255  N   ARG    36      55.150  51.776  17.457  1.00 29.82           N  
ATOM    256  CA  ARG    36      55.188  50.979  18.677  1.00 30.96           C  
ATOM    257  C   ARG    36      53.791  50.685  19.158  1.00 31.11           C  
ATOM    258  O   ARG    36      52.973  51.593  19.233  1.00 31.88           O  
ATOM    259  CB  ARG    36      55.896  51.743  19.794  1.00 31.37           C  
ATOM    260  CG  ARG    36      57.369  51.514  19.876  1.00 33.43           C  
ATOM    261  CD  ARG    36      57.850  51.860  21.265  1.00 34.81           C  
ATOM    262  NE  ARG    36      59.263  51.560  21.469  1.00 36.64           N  
ATOM    263  CZ  ARG    36      59.757  50.402  21.907  1.00 37.17           C  
ATOM    264  NH1 ARG    36      58.960  49.382  22.198  1.00 37.94           N  
ATOM    265  NH2 ARG    36      61.069  50.274  22.059  1.00 38.12           N  
ATOM    266  N   GLY    37      53.529  49.430  19.510  1.00 31.00           N  
ATOM    267  CA  GLY    37      52.245  49.046  20.079  1.00 30.64           C  
ATOM    268  C   GLY    37      51.116  48.804  19.096  1.00 30.47           C  
ATOM    269  O   GLY    37      50.028  48.446  19.510  1.00 30.27           O  
ATOM    270  N   LEU    38      51.349  48.994  17.798  1.00 30.30           N  
ATOM    271  CA  LEU    38      50.332  48.695  16.792  1.00 30.44           C  
ATOM    272  C   LEU    38      50.824  47.654  15.805  1.00 29.85           C  
ATOM    273  O   LEU    38      52.008  47.579  15.498  1.00 27.66           O  
ATOM    274  CB  LEU    38      49.958  49.950  15.999  1.00 30.96           C  
ATOM    275  CG  LEU    38      49.282  51.087  16.761  1.00 34.65           C  
ATOM    276  CD1 LEU    38      49.226  52.317  15.860  1.00 37.20           C  
ATOM    277  CD2 LEU    38      47.864  50.657  17.221  1.00 37.06           C  
ATOM    278  N   ARG    39      49.894  46.878  15.287  1.00 30.06           N  
ATOM    279  CA  ARG    39      50.195  45.952  14.207  1.00 30.98           C  
ATOM    280  C   ARG    39      48.987  45.811  13.308  1.00 30.64           C  
ATOM    281  O   ARG    39      47.862  45.679  13.803  1.00 30.53           O  
ATOM    282  CB  ARG    39      50.602  44.602  14.753  1.00 31.70           C  
ATOM    283  CG  ARG    39      51.344  43.770  13.727  1.00 36.13           C  
ATOM    284  CD  ARG    39      51.801  42.461  14.311  1.00 41.67           C  
ATOM    285  NE  ARG    39      50.644  41.636  14.613  1.00 46.35           N  
ATOM    286  CZ  ARG    39      50.683  40.374  15.039  1.00 52.33           C  
ATOM    287  NH1 ARG    39      51.852  39.736  15.191  1.00 53.52           N  
ATOM    288  NH2 ARG    39      49.527  39.738  15.289  1.00 53.35           N  
ATOM    289  N   VAL    40      49.193  45.911  11.997  1.00 29.25           N  
ATOM    290  CA  VAL    40      48.084  45.806  11.073  1.00 29.29           C  
ATOM    291  C   VAL    40      48.180  44.491  10.303  1.00 29.28           C  
ATOM    292  O   VAL    40      49.260  44.038   9.971  1.00 28.16           O  
ATOM    293  CB  VAL    40      47.979  47.025  10.097  1.00 30.38           C  
ATOM    294  CG1 VAL    40      48.048  48.386  10.835  1.00 30.15           C  
ATOM    295  CG2 VAL    40      48.965  46.949   9.024  1.00 31.10           C  
ATOM    296  N   ASP    41      47.031  43.890  10.016  1.00 28.82           N  
ATOM    297  CA  ASP    41      46.989  42.539   9.423  1.00 28.90           C  
ATOM    298  C   ASP    41      47.559  42.493   7.997  1.00 29.20           C  
ATOM    299  O   ASP    41      48.356  41.616   7.681  1.00 28.96           O  
ATOM    300  CB  ASP    41      45.553  42.025   9.428  1.00 29.05           C  
ATOM    301  CG  ASP    41      45.003  41.835  10.844  1.00 29.68           C  
ATOM    302  OD1 ASP    41      45.807  41.624  11.776  1.00 28.41           O  
ATOM    303  OD2 ASP    41      43.761  41.888  10.974  1.00 29.44           O  
ATOM    304  N   VAL    42      47.146  43.451   7.170  1.00 29.53           N  
ATOM    305  CA  VAL    42      47.725  43.629   5.860  1.00 29.37           C  
ATOM    306  C   VAL    42      47.958  45.118   5.626  1.00 29.29           C  
ATOM    307  O   VAL    42      47.066  45.944   5.858  1.00 28.58           O  
ATOM    308  CB  VAL    42      46.839  43.039   4.739  1.00 30.24           C  
ATOM    309  CG1 VAL    42      47.444  43.342   3.341  1.00 29.49           C  
ATOM    310  CG2 VAL    42      46.690  41.534   4.922  1.00 29.51           C  
ATOM    311  N   MET    43      49.169  45.445   5.159  1.00 28.21           N  
ATOM    312  CA  MET    43      49.415  46.759   4.580  1.00 28.70           C  
ATOM    313  C   MET    43      49.538  46.629   3.083  1.00 29.05           C  
ATOM    314  O   MET    43      50.300  45.777   2.615  1.00 28.30           O  
ATOM    315  CB  MET    43      50.658  47.424   5.172  1.00 27.94           C  
ATOM    316  CG  MET    43      50.883  48.859   4.561  1.00 31.25           C  
ATOM    317  SD  MET    43      52.353  49.878   5.187  0.65 32.79          SE  
ATOM    318  CE  MET    43      52.924  50.775   3.501  1.00 36.03           C  
ATOM    319  N   GLY    44      48.790  47.465   2.347  1.00 29.66           N  
ATOM    320  CA  GLY    44      48.888  47.517   0.887  1.00 29.92           C  
ATOM    321  C   GLY    44      49.589  48.774   0.442  1.00 30.19           C  
ATOM    322  O   GLY    44      49.381  49.850   1.036  1.00 29.23           O  
ATOM    323  N   LEU    45      50.448  48.642  -0.590  1.00 30.88           N  
ATOM    324  CA  LEU    45      51.158  49.743  -1.171  1.00 31.78           C  
ATOM    325  C   LEU    45      50.853  49.835  -2.667  1.00 32.94           C  
ATOM    326  O   LEU    45      51.083  48.871  -3.439  1.00 32.14           O  
ATOM    327  CB  LEU    45      52.661  49.601  -0.943  1.00 31.03           C  
ATOM    328  CG  LEU    45      53.568  50.630  -1.591  1.00 32.51           C  
ATOM    329  CD1 LEU    45      53.290  52.041  -1.032  1.00 29.99           C  
ATOM    330  CD2 LEU    45      55.079  50.228  -1.445  1.00 29.43           C  
ATOM    331  N   GLY    46      50.318  50.986  -3.040  1.00 34.05           N  
ATOM    332  CA  GLY    46      49.879  51.284  -4.410  1.00 35.87           C  
ATOM    333  C   GLY    46      51.019  51.765  -5.274  1.00 37.83           C  
ATOM    334  O   GLY    46      52.109  52.125  -4.761  1.00 38.53           O  
ATOM    335  N   PRO    47      50.825  51.719  -6.603  1.00 39.46           N  
ATOM    336  CA  PRO    47      51.963  52.055  -7.492  1.00 40.90           C  
ATOM    337  C   PRO    47      52.426  53.525  -7.400  1.00 42.26           C  
ATOM    338  O   PRO    47      53.544  53.846  -7.840  1.00 43.50           O  
ATOM    339  CB  PRO    47      51.435  51.731  -8.910  1.00 40.67           C  
ATOM    340  CG  PRO    47      49.957  51.675  -8.775  1.00 40.80           C  
ATOM    341  CD  PRO    47      49.632  51.293  -7.341  1.00 38.82           C  
ATOM    342  N   LYS    48      51.595  54.390  -6.829  1.00 42.99           N  
ATOM    343  CA  LYS    48      51.946  55.797  -6.637  1.00 43.80           C  
ATOM    344  C   LYS    48      52.193  56.090  -5.162  1.00 42.11           C  
ATOM    345  O   LYS    48      52.254  57.247  -4.766  1.00 41.20           O  
ATOM    346  CB  LYS    48      50.823  56.696  -7.171  1.00 45.43           C  
ATOM    347  CG  LYS    48      50.573  56.567  -8.695  1.00 49.60           C  
ATOM    348  CD  LYS    48      49.446  57.511  -9.190  1.00 54.59           C  
ATOM    349  CE  LYS    48      48.163  56.754  -9.578  1.00 57.03           C  
ATOM    350  NZ  LYS    48      48.451  55.682 -10.606  1.00 58.42           N  
ATOM    351  N   GLY    49      52.349  55.039  -4.357  1.00 39.55           N  
ATOM    352  CA  GLY    49      52.672  55.189  -2.959  1.00 37.96           C  
ATOM    353  C   GLY    49      51.472  55.318  -2.034  1.00 36.76           C  
ATOM    354  O   GLY    49      51.631  55.663  -0.895  1.00 35.86           O  
ATOM    355  N   GLU    50      50.286  54.994  -2.516  1.00 35.39           N  
ATOM    356  CA  GLU    50      49.063  54.967  -1.695  1.00 36.06           C  
ATOM    357  C   GLU    50      49.233  53.877  -0.595  1.00 34.85           C  
ATOM    358  O   GLU    50      49.797  52.810  -0.849  1.00 34.55           O  
ATOM    359  CB  GLU    50      47.843  54.679  -2.589  1.00 36.91           C  
ATOM    360  CG  GLU    50      47.721  55.553  -3.900  1.00 42.02           C  
ATOM    361  CD  GLU    50      48.240  54.853  -5.207  1.00 46.63           C  
ATOM    362  OE1 GLU    50      47.541  54.840  -6.245  1.00 54.54           O  
ATOM    363  OE2 GLU    50      49.329  54.311  -5.222  1.00 41.20           O  
ATOM    364  N   ILE    51      48.834  54.170   0.638  1.00 32.72           N  
ATOM    365  CA  ILE    51      48.962  53.206   1.739  1.00 31.02           C  
ATOM    366  C   ILE    51      47.550  52.829   2.220  1.00 30.71           C  
ATOM    367  O   ILE    51      46.739  53.693   2.571  1.00 29.10           O  
ATOM    368  CB  ILE    51      49.842  53.760   2.910  1.00 31.37           C  
ATOM    369  CG1 ILE    51      51.291  53.948   2.439  1.00 33.61           C  
ATOM    370  CG2 ILE    51      49.866  52.793   4.125  1.00 29.15           C  
ATOM    371  CD1 ILE    51      52.022  55.011   3.209  1.00 36.59           C  
ATOM    372  N   TRP    52      47.278  51.515   2.200  1.00 30.35           N  
ATOM    373  CA  TRP    52      46.037  50.925   2.665  1.00 30.78           C  
ATOM    374  C   TRP    52      46.306  50.010   3.836  1.00 29.52           C  
ATOM    375  O   TRP    52      47.279  49.268   3.846  1.00 29.52           O  
ATOM    376  CB  TRP    52      45.424  50.083   1.556  1.00 31.80           C  
ATOM    377  CG  TRP    52      44.858  50.853   0.411  1.00 32.99           C  
ATOM    378  CD1 TRP    52      45.021  52.174   0.125  1.00 34.79           C  
ATOM    379  CD2 TRP    52      44.058  50.312  -0.642  1.00 33.33           C  
ATOM    380  NE1 TRP    52      44.387  52.489  -1.058  1.00 35.95           N  
ATOM    381  CE2 TRP    52      43.779  51.360  -1.540  1.00 36.05           C  
ATOM    382  CE3 TRP    52      43.586  49.048  -0.923  1.00 33.32           C  
ATOM    383  CZ2 TRP    52      43.012  51.183  -2.686  1.00 34.77           C  
ATOM    384  CZ3 TRP    52      42.800  48.874  -2.076  1.00 34.80           C  
ATOM    385  CH2 TRP    52      42.536  49.944  -2.927  1.00 35.32           C  
ATOM    386  N   VAL    53      45.469  50.098   4.847  1.00 29.67           N  
ATOM    387  CA  VAL    53      45.486  49.168   5.949  1.00 28.16           C  
ATOM    388  C   VAL    53      44.216  48.335   5.810  1.00 28.83           C  
ATOM    389  O   VAL    53      43.091  48.875   5.642  1.00 26.41           O  
ATOM    390  CB  VAL    53      45.524  49.899   7.297  1.00 29.11           C  
ATOM    391  CG1 VAL    53      45.002  48.988   8.448  1.00 27.78           C  
ATOM    392  CG2 VAL    53      46.940  50.456   7.540  1.00 28.12           C  
ATOM    393  N   ILE    54      44.398  47.020   5.880  1.00 28.50           N  
ATOM    394  CA  ILE    54      43.285  46.084   5.847  1.00 29.08           C  
ATOM    395  C   ILE    54      43.358  45.195   7.076  1.00 28.55           C  
ATOM    396  O   ILE    54      44.330  44.453   7.275  1.00 28.15           O  
ATOM    397  CB  ILE    54      43.272  45.213   4.565  1.00 29.43           C  
ATOM    398  CG1 ILE    54      43.212  46.102   3.335  1.00 31.46           C  
ATOM    399  CG2 ILE    54      42.083  44.228   4.538  1.00 30.38           C  
ATOM    400  CD1 ILE    54      44.488  46.089   2.575  1.00 34.04           C  
ATOM    401  N   GLU    55      42.313  45.285   7.902  1.00 26.85           N  
ATOM    402  CA  GLU    55      42.162  44.439   9.044  1.00 26.66           C  
ATOM    403  C   GLU    55      41.252  43.269   8.697  1.00 28.23           C  
ATOM    404  O   GLU    55      40.051  43.473   8.371  1.00 28.33           O  
ATOM    405  CB  GLU    55      41.580  45.241  10.223  1.00 26.95           C  
ATOM    406  CG  GLU    55      42.539  46.184  10.860  1.00 26.27           C  
ATOM    407  CD  GLU    55      43.671  45.464  11.554  1.00 28.92           C  
ATOM    408  OE1 GLU    55      43.450  44.953  12.672  1.00 30.37           O  
ATOM    409  OE2 GLU    55      44.779  45.412  10.987  1.00 26.72           O  
ATOM    410  N   CYS    56      41.792  42.077   8.878  1.00 29.07           N  
ATOM    411  CA  CYS    56      41.168  40.830   8.506  1.00 30.82           C  
ATOM    412  C   CYS    56      40.524  40.220   9.729  1.00 30.88           C  
ATOM    413  O   CYS    56      41.192  39.664  10.573  1.00 31.72           O  
ATOM    414  CB  CYS    56      42.194  39.878   7.881  1.00 30.80           C  
ATOM    415  SG  CYS    56      42.965  40.559   6.395  1.00 33.27           S  
ATOM    416  N   LYS    57      39.200  40.314   9.830  1.00 31.20           N  
ATOM    417  CA  LYS    57      38.504  39.778  10.992  1.00 32.78           C  
ATOM    418  C   LYS    57      37.786  38.473  10.639  1.00 33.46           C  
ATOM    419  O   LYS    57      36.905  38.436   9.806  1.00 32.62           O  
ATOM    420  CB  LYS    57      37.546  40.818  11.544  1.00 32.90           C  
ATOM    421  CG  LYS    57      38.238  42.112  11.931  1.00 35.60           C  
ATOM    422  CD  LYS    57      39.230  41.804  13.049  1.00 38.77           C  
ATOM    423  CE  LYS    57      39.999  42.990  13.468  1.00 42.21           C  
ATOM    424  NZ  LYS    57      40.988  42.670  14.570  1.00 43.45           N  
ATOM    425  N   SER    58      38.177  37.406  11.314  1.00 34.39           N  
ATOM    426  CA  SER    58      37.759  36.075  10.947  1.00 35.27           C  
ATOM    427  C   SER    58      36.486  35.655  11.695  1.00 35.26           C  
ATOM    428  O   SER    58      35.881  34.626  11.349  1.00 35.69           O  
ATOM    429  CB  SER    58      38.909  35.128  11.231  1.00 35.37           C  
ATOM    430  OG  SER    58      39.287  35.218  12.615  1.00 40.50           O  
ATOM    431  N   SER    59      36.088  36.486  12.679  1.00 34.46           N  
ATOM    432  CA  SER    59      34.943  36.235  13.568  0.50 34.53           C  
ATOM    434  C   SER    59      34.438  37.565  14.128  1.00 34.32           C  
ATOM    435  O   SER    59      35.182  38.525  14.196  1.00 33.74           O  
ATOM    436  CB  SER    59      35.378  35.365  14.771  0.50 34.93           C  
ATOM    438  OG  SER    59      34.823  34.065  14.735  0.50 34.74           O  
ATOM    440  N   ARG    60      33.193  37.599  14.584  1.00 35.75           N  
ATOM    441  CA  ARG    60      32.698  38.720  15.407  1.00 36.62           C  
ATOM    442  C   ARG    60      33.565  39.036  16.632  1.00 36.50           C  
ATOM    443  O   ARG    60      33.778  40.208  16.965  1.00 36.82           O  
ATOM    444  CB  ARG    60      31.297  38.420  15.900  1.00 37.23           C  
ATOM    445  CG  ARG    60      30.263  38.651  14.860  1.00 38.79           C  
ATOM    446  CD  ARG    60      28.912  38.625  15.475  1.00 40.20           C  
ATOM    447  NE  ARG    60      28.666  39.815  16.293  1.00 41.47           N  
ATOM    448  CZ  ARG    60      27.469  40.177  16.734  1.00 42.08           C  
ATOM    449  NH1 ARG    60      26.401  39.449  16.442  1.00 43.37           N  
ATOM    450  NH2 ARG    60      27.334  41.270  17.477  1.00 44.05           N  
ATOM    451  N   ALA    61      34.067  38.001  17.303  1.00 36.87           N  
ATOM    452  CA  ALA    61      34.974  38.201  18.469  1.00 36.31           C  
ATOM    453  C   ALA    61      36.273  38.886  18.035  1.00 36.59           C  
ATOM    454  O   ALA    61      36.788  39.761  18.745  1.00 36.73           O  
ATOM    455  CB  ALA    61      35.277  36.897  19.149  1.00 36.61           C  
ATOM    456  N   ASP    62      36.789  38.512  16.862  1.00 35.46           N  
ATOM    457  CA  ASP    62      37.976  39.126  16.337  1.00 35.64           C  
ATOM    458  C   ASP    62      37.748  40.632  16.174  1.00 34.83           C  
ATOM    459  O   ASP    62      38.657  41.446  16.416  1.00 35.10           O  
ATOM    460  CB  ASP    62      38.337  38.498  14.985  1.00 36.39           C  
ATOM    461  CG  ASP    62      39.794  38.623  14.654  1.00 39.25           C  
ATOM    462  OD1 ASP    62      40.637  38.680  15.583  1.00 40.62           O  
ATOM    463  OD2 ASP    62      40.114  38.638  13.450  1.00 38.77           O  
ATOM    464  N   PHE    63      36.537  40.996  15.744  1.00 32.94           N  
ATOM    465  CA  PHE    63      36.179  42.398  15.477  1.00 32.11           C  
ATOM    466  C   PHE    63      36.010  43.121  16.817  1.00 32.58           C  
ATOM    467  O   PHE    63      36.473  44.247  16.995  1.00 33.27           O  
ATOM    468  CB  PHE    63      34.899  42.469  14.593  1.00 31.56           C  
ATOM    469  CG  PHE    63      34.233  43.797  14.589  1.00 28.81           C  
ATOM    470  CD1 PHE    63      34.871  44.893  14.078  1.00 28.17           C  
ATOM    471  CD2 PHE    63      32.950  43.943  15.088  1.00 30.00           C  
ATOM    472  CE1 PHE    63      34.249  46.153  14.108  1.00 28.32           C  
ATOM    473  CE2 PHE    63      32.322  45.178  15.078  1.00 30.25           C  
ATOM    474  CZ  PHE    63      32.984  46.282  14.580  1.00 27.83           C  
ATOM    475  N   GLN    64      35.367  42.451  17.756  1.00 32.42           N  
ATOM    476  CA  GLN    64      35.174  42.992  19.090  1.00 33.60           C  
ATOM    477  C   GLN    64      36.503  43.384  19.776  1.00 34.10           C  
ATOM    478  O   GLN    64      36.585  44.416  20.447  1.00 34.13           O  
ATOM    479  CB  GLN    64      34.339  42.001  19.920  1.00 33.32           C  
ATOM    480  CG  GLN    64      32.896  41.839  19.354  1.00 34.10           C  
ATOM    481  CD  GLN    64      32.197  40.512  19.741  1.00 36.83           C  
ATOM    482  OE1 GLN    64      32.667  39.775  20.614  1.00 36.11           O  
ATOM    483  NE2 GLN    64      31.044  40.241  19.116  1.00 35.53           N  
ATOM    484  N   ALA    65      37.536  42.579  19.568  1.00 34.84           N  
ATOM    485  CA  ALA    65      38.888  42.850  20.073  1.00 35.88           C  
ATOM    486  C   ALA    65      39.640  44.026  19.386  1.00 36.86           C  
ATOM    487  O   ALA    65      40.586  44.555  19.953  1.00 37.09           O  
ATOM    488  CB  ALA    65      39.730  41.571  19.976  1.00 36.04           C  
ATOM    489  N   ASP    66      39.240  44.431  18.182  1.00 37.60           N  
ATOM    490  CA  ASP    66      39.887  45.567  17.476  1.00 38.20           C  
ATOM    491  C   ASP    66      39.131  46.910  17.766  1.00 38.27           C  
ATOM    492  O   ASP    66      38.944  47.742  16.855  1.00 38.55           O  
ATOM    493  CB  ASP    66      39.892  45.279  15.965  1.00 38.37           C  
ATOM    494  CG  ASP    66      41.248  45.575  15.260  1.00 40.27           C  
ATOM    495  OD1 ASP    66      42.284  45.891  15.898  1.00 38.46           O  
ATOM    496  OD2 ASP    66      41.267  45.439  14.011  1.00 42.28           O  
ATOM    497  N   ALA    67      38.724  47.103  19.020  1.00 37.94           N  
ATOM    498  CA  ALA    67      37.974  48.306  19.476  1.00 38.18           C  
ATOM    499  C   ALA    67      38.679  49.661  19.239  1.00 37.68           C  
ATOM    500  O   ALA    67      38.021  50.673  18.984  1.00 37.88           O  
ATOM    501  CB  ALA    67      37.598  48.168  20.949  1.00 37.97           C  
ATOM    502  N   LYS    68      40.010  49.669  19.296  1.00 36.84           N  
ATOM    503  CA  LYS    68      40.799  50.888  19.048  1.00 35.73           C  
ATOM    504  C   LYS    68      41.176  51.071  17.554  1.00 34.00           C  
ATOM    505  O   LYS    68      42.146  51.766  17.261  1.00 33.51           O  
ATOM    506  CB  LYS    68      42.086  50.896  19.910  1.00 36.00           C  
ATOM    507  CG  LYS    68      41.893  50.587  21.402  1.00 36.85           C  
ATOM    508  CD  LYS    68      41.016  51.628  22.134  1.00 38.26           C  
ATOM    509  CE  LYS    68      40.923  51.324  23.629  1.00 39.01           C  
ATOM    510  NZ  LYS    68      40.768  52.534  24.508  1.00 39.85           N  
ATOM    511  N   TRP    69      40.385  50.487  16.640  1.00 31.74           N  
ATOM    512  CA  TRP    69      40.667  50.500  15.197  1.00 30.62           C  
ATOM    513  C   TRP    69      40.785  51.913  14.634  1.00 29.24           C  
ATOM    514  O   TRP    69      41.469  52.122  13.638  1.00 28.58           O  
ATOM    515  CB  TRP    69      39.585  49.721  14.388  1.00 30.33           C  
ATOM    516  CG  TRP    69      38.240  50.371  14.427  1.00 29.23           C  
ATOM    517  CD1 TRP    69      37.264  50.197  15.372  1.00 29.94           C  
ATOM    518  CD2 TRP    69      37.727  51.339  13.498  1.00 28.17           C  
ATOM    519  NE1 TRP    69      36.185  51.017  15.101  1.00 27.93           N  
ATOM    520  CE2 TRP    69      36.441  51.727  13.958  1.00 29.02           C  
ATOM    521  CE3 TRP    69      38.243  51.944  12.353  1.00 30.65           C  
ATOM    522  CZ2 TRP    69      35.660  52.686  13.298  1.00 28.93           C  
ATOM    523  CZ3 TRP    69      37.462  52.892  11.686  1.00 31.23           C  
ATOM    524  CH2 TRP    69      36.181  53.244  12.154  1.00 29.10           C  
ATOM    525  N   GLN    70      40.075  52.870  15.219  1.00 28.41           N  
ATOM    526  CA  GLN    70      40.212  54.247  14.743  1.00 28.68           C  
ATOM    527  C   GLN    70      41.675  54.745  14.825  1.00 27.89           C  
ATOM    528  O   GLN    70      42.046  55.631  14.071  1.00 27.19           O  
ATOM    529  CB  GLN    70      39.254  55.186  15.435  1.00 29.10           C  
ATOM    530  CG  GLN    70      37.903  55.186  14.729  1.00 32.33           C  
ATOM    531  CD  GLN    70      36.780  55.565  15.629  1.00 36.45           C  
ATOM    532  OE1 GLN    70      36.146  56.603  15.447  1.00 39.10           O  
ATOM    533  NE2 GLN    70      36.514  54.724  16.628  1.00 40.07           N  
ATOM    534  N   GLY    71      42.485  54.128  15.692  1.00 27.12           N  
ATOM    535  CA  GLY    71      43.918  54.424  15.785  1.00 27.41           C  
ATOM    536  C   GLY    71      44.742  54.035  14.580  1.00 27.35           C  
ATOM    537  O   GLY    71      45.866  54.548  14.401  1.00 27.03           O  
ATOM    538  N   TYR    72      44.216  53.130  13.754  1.00 26.61           N  
ATOM    539  CA  TYR    72      44.875  52.798  12.505  1.00 26.99           C  
ATOM    540  C   TYR    72      44.747  53.886  11.439  1.00 27.21           C  
ATOM    541  O   TYR    72      45.543  53.935  10.512  1.00 26.79           O  
ATOM    542  CB  TYR    72      44.345  51.508  11.900  1.00 27.27           C  
ATOM    543  CG  TYR    72      44.484  50.262  12.727  1.00 27.75           C  
ATOM    544  CD1 TYR    72      43.357  49.517  13.068  1.00 28.90           C  
ATOM    545  CD2 TYR    72      45.732  49.788  13.133  1.00 30.26           C  
ATOM    546  CE1 TYR    72      43.455  48.343  13.795  1.00 29.21           C  
ATOM    547  CE2 TYR    72      45.842  48.595  13.883  1.00 29.26           C  
ATOM    548  CZ  TYR    72      44.699  47.889  14.212  1.00 31.18           C  
ATOM    549  OH  TYR    72      44.749  46.721  14.939  1.00 29.57           O  
ATOM    550  N   LEU    73      43.746  54.745  11.560  1.00 27.33           N  
ATOM    551  CA  LEU    73      43.444  55.725  10.512  1.00 27.22           C  
ATOM    552  C   LEU    73      44.593  56.676  10.138  1.00 26.79           C  
ATOM    553  O   LEU    73      44.805  56.986   8.953  1.00 26.50           O  
ATOM    554  CB  LEU    73      42.182  56.510  10.914  1.00 27.40           C  
ATOM    555  CG  LEU    73      40.896  55.651  10.984  1.00 26.60           C  
ATOM    556  CD1 LEU    73      39.633  56.515  11.140  1.00 25.98           C  
ATOM    557  CD2 LEU    73      40.786  54.743   9.750  1.00 25.85           C  
ATOM    558  N   GLU    74      45.315  57.149  11.151  1.00 26.70           N  
ATOM    559  CA  GLU    74      46.412  58.063  10.955  1.00 27.00           C  
ATOM    560  C   GLU    74      47.628  57.423  10.287  1.00 27.17           C  
ATOM    561  O   GLU    74      48.600  58.110   9.988  1.00 26.94           O  
ATOM    562  CB  GLU    74      46.822  58.705  12.295  1.00 27.76           C  
ATOM    563  CG  GLU    74      47.378  57.758  13.380  1.00 27.43           C  
ATOM    564  CD  GLU    74      48.101  58.532  14.471  1.00 30.96           C  
ATOM    565  OE1 GLU    74      48.632  59.626  14.155  1.00 29.86           O  
ATOM    566  OE2 GLU    74      48.148  58.061  15.633  1.00 31.00           O  
ATOM    567  N   TRP    75      47.585  56.116  10.063  1.00 27.84           N  
ATOM    568  CA  TRP    75      48.713  55.401   9.472  1.00 28.52           C  
ATOM    569  C   TRP    75      48.442  54.918   8.057  1.00 29.51           C  
ATOM    570  O   TRP    75      49.194  54.082   7.563  1.00 29.23           O  
ATOM    571  CB  TRP    75      49.091  54.215  10.359  1.00 28.34           C  
ATOM    572  CG  TRP    75      49.499  54.652  11.707  1.00 27.70           C  
ATOM    573  CD1 TRP    75      48.796  54.501  12.861  1.00 28.32           C  
ATOM    574  CD2 TRP    75      50.698  55.368  12.052  1.00 28.02           C  
ATOM    575  NE1 TRP    75      49.489  55.068  13.914  1.00 26.63           N  
ATOM    576  CE2 TRP    75      50.656  55.606  13.443  1.00 26.73           C  
ATOM    577  CE3 TRP    75      51.801  55.832  11.317  1.00 26.37           C  
ATOM    578  CZ2 TRP    75      51.671  56.264  14.113  1.00 28.27           C  
ATOM    579  CZ3 TRP    75      52.808  56.476  11.976  1.00 27.45           C  
ATOM    580  CH2 TRP    75      52.738  56.701  13.368  1.00 28.83           C  
ATOM    581  N   CYS    76      47.378  55.432   7.421  1.00 30.37           N  
ATOM    582  CA  CYS    76      47.009  55.020   6.068  1.00 30.52           C  
ATOM    583  C   CYS    76      46.244  56.096   5.308  1.00 30.62           C  
ATOM    584  O   CYS    76      45.786  57.063   5.885  1.00 30.35           O  
ATOM    585  CB  CYS    76      46.196  53.716   6.100  1.00 29.95           C  
ATOM    586  SG  CYS    76      44.615  53.781   6.963  1.00 33.52           S  
ATOM    587  N   ASP    77      46.205  55.957   3.990  1.00 30.59           N  
ATOM    588  CA  ASP    77      45.364  56.773   3.143  1.00 30.05           C  
ATOM    589  C   ASP    77      43.938  56.224   3.149  1.00 30.40           C  
ATOM    590  O   ASP    77      43.001  57.002   3.152  1.00 30.16           O  
ATOM    591  CB  ASP    77      45.881  56.791   1.713  1.00 30.00           C  
ATOM    592  CG  ASP    77      47.242  57.385   1.598  1.00 29.91           C  
ATOM    593  OD1 ASP    77      47.476  58.506   2.117  1.00 29.20           O  
ATOM    594  OD2 ASP    77      48.076  56.757   0.963  1.00 28.27           O  
ATOM    595  N   ARG    78      43.790  54.896   3.164  1.00 29.42           N  
ATOM    596  CA  ARG    78      42.491  54.227   3.170  1.00 30.31           C  
ATOM    597  C   ARG    78      42.547  53.037   4.126  1.00 30.99           C  
ATOM    598  O   ARG    78      43.531  52.321   4.164  1.00 30.71           O  
ATOM    599  CB  ARG    78      42.104  53.747   1.780  1.00 28.64           C  
ATOM    600  CG  ARG    78      41.965  54.859   0.751  1.00 30.72           C  
ATOM    601  CD  ARG    78      41.314  54.348  -0.506  1.00 30.48           C  
ATOM    602  NE  ARG    78      41.571  55.200  -1.659  1.00 32.15           N  
ATOM    603  CZ  ARG    78      40.678  55.961  -2.286  1.00 32.66           C  
ATOM    604  NH1 ARG    78      41.056  56.684  -3.326  1.00 32.79           N  
ATOM    605  NH2 ARG    78      39.419  55.982  -1.928  1.00 32.58           N  
ATOM    606  N   TYR    79      41.504  52.900   4.921  1.00 31.70           N  
ATOM    607  CA  TYR    79      41.309  51.824   5.903  1.00 31.79           C  
ATOM    608  C   TYR    79      40.117  50.941   5.538  1.00 32.08           C  
ATOM    609  O   TYR    79      38.991  51.439   5.249  1.00 31.39           O  
ATOM    610  CB  TYR    79      41.068  52.422   7.300  1.00 32.61           C  
ATOM    611  CG  TYR    79      40.800  51.366   8.318  1.00 31.46           C  
ATOM    612  CD1 TYR    79      41.838  50.715   8.945  1.00 35.19           C  
ATOM    613  CD2 TYR    79      39.485  51.014   8.662  1.00 34.21           C  
ATOM    614  CE1 TYR    79      41.600  49.708   9.871  1.00 34.13           C  
ATOM    615  CE2 TYR    79      39.236  50.004   9.565  1.00 34.41           C  
ATOM    616  CZ  TYR    79      40.307  49.385  10.195  1.00 35.70           C  
ATOM    617  OH  TYR    79      40.092  48.395  11.112  1.00 36.52           O  
ATOM    618  N   PHE    80      40.364  49.625   5.526  1.00 32.04           N  
ATOM    619  CA  PHE    80      39.387  48.598   5.133  1.00 31.79           C  
ATOM    620  C   PHE    80      39.313  47.502   6.169  1.00 32.70           C  
ATOM    621  O   PHE    80      40.330  47.155   6.826  1.00 30.72           O  
ATOM    622  CB  PHE    80      39.748  47.846   3.853  1.00 31.81           C  
ATOM    623  CG  PHE    80      39.922  48.711   2.634  1.00 30.72           C  
ATOM    624  CD1 PHE    80      38.977  48.736   1.631  1.00 31.33           C  
ATOM    625  CD2 PHE    80      41.078  49.473   2.485  1.00 31.26           C  
ATOM    626  CE1 PHE    80      39.166  49.520   0.490  1.00 31.56           C  
ATOM    627  CE2 PHE    80      41.276  50.243   1.358  1.00 28.69           C  
ATOM    628  CZ  PHE    80      40.313  50.285   0.368  1.00 31.86           C  
ATOM    629  N   TRP    81      38.103  46.939   6.278  1.00 31.67           N  
ATOM    630  CA  TRP    81      37.898  45.626   6.873  1.00 32.90           C  
ATOM    631  C   TRP    81      37.907  44.570   5.785  1.00 32.20           C  
ATOM    632  O   TRP    81      37.542  44.863   4.660  1.00 32.23           O  
ATOM    633  CB  TRP    81      36.585  45.564   7.622  1.00 34.68           C  
ATOM    634  CG  TRP    81      36.425  46.615   8.659  1.00 34.01           C  
ATOM    635  CD1 TRP    81      35.813  47.807   8.501  1.00 36.49           C  
ATOM    636  CD2 TRP    81      36.884  46.564  10.020  1.00 34.58           C  
ATOM    637  NE1 TRP    81      35.847  48.515   9.689  1.00 37.61           N  
ATOM    638  CE2 TRP    81      36.529  47.772  10.620  1.00 35.18           C  
ATOM    639  CE3 TRP    81      37.571  45.606  10.778  1.00 36.93           C  
ATOM    640  CZ2 TRP    81      36.810  48.046  11.954  1.00 37.41           C  
ATOM    641  CZ3 TRP    81      37.868  45.885  12.090  1.00 37.27           C  
ATOM    642  CH2 TRP    81      37.502  47.087  12.661  1.00 36.57           C  
ATOM    643  N   ALA    82      38.366  43.369   6.115  1.00 31.59           N  
ATOM    644  CA  ALA    82      38.247  42.185   5.236  1.00 31.92           C  
ATOM    645  C   ALA    82      37.638  41.056   6.088  1.00 30.84           C  
ATOM    646  O   ALA    82      38.151  40.731   7.143  1.00 30.63           O  
ATOM    647  CB  ALA    82      39.603  41.768   4.638  1.00 31.84           C  
ATOM    648  N   VAL    83      36.521  40.514   5.618  1.00 31.32           N  
ATOM    649  CA  VAL    83      35.763  39.465   6.294  1.00 30.64           C  
ATOM    650  C   VAL    83      35.287  38.454   5.271  1.00 31.95           C  
ATOM    651  O   VAL    83      35.279  38.730   4.050  1.00 31.88           O  
ATOM    652  CB  VAL    83      34.547  40.051   7.056  1.00 31.36           C  
ATOM    653  CG1 VAL    83      35.014  41.082   8.109  1.00 30.90           C  
ATOM    654  CG2 VAL    83      33.498  40.665   6.110  1.00 26.79           C  
ATOM    655  N   ASP    84      34.864  37.288   5.742  1.00 31.62           N  
ATOM    656  CA  ASP    84      34.318  36.324   4.835  1.00 31.95           C  
ATOM    657  C   ASP    84      32.794  36.515   4.712  1.00 31.17           C  
ATOM    658  O   ASP    84      32.190  37.331   5.409  1.00 29.18           O  
ATOM    659  CB  ASP    84      34.732  34.908   5.241  1.00 32.92           C  
ATOM    660  CG  ASP    84      34.059  34.396   6.503  1.00 34.47           C  
ATOM    661  OD1 ASP    84      32.989  34.896   6.988  1.00 34.31           O  
ATOM    662  OD2 ASP    84      34.622  33.393   7.008  1.00 41.19           O  
ATOM    663  N   MET    85      32.191  35.692   3.879  1.00 32.20           N  
ATOM    664  CA  MET    85      30.760  35.790   3.578  0.60 33.07           C  
ATOM    666  C   MET    85      29.846  35.354   4.727  1.00 33.77           C  
ATOM    667  O   MET    85      28.611  35.550   4.649  1.00 33.86           O  
ATOM    668  CB  MET    85      30.430  35.009   2.289  0.60 33.52           C  
ATOM    670  CG  MET    85      30.604  33.478   2.356  0.60 34.27           C  
ATOM    672  SD  MET    85      30.588  32.530   0.595  0.39 34.96          SE  
ATOM    674  CE  MET    85      30.777  30.720   1.349  0.60 39.15           C  
ATOM    676  N   GLU    86      30.414  34.741   5.778  1.00 34.54           N  
ATOM    677  CA  GLU    86      29.642  34.341   6.979  0.50 34.80           C  
ATOM    679  C   GLU    86      29.586  35.463   8.020  1.00 34.52           C  
ATOM    680  O   GLU    86      28.776  35.419   8.932  1.00 33.91           O  
ATOM    681  CB  GLU    86      30.258  33.118   7.664  0.50 35.25           C  
ATOM    683  CG  GLU    86      29.928  31.766   7.060  0.50 37.34           C  
ATOM    685  CD  GLU    86      30.082  30.639   8.082  0.50 39.05           C  
ATOM    687  OE1 GLU    86      31.231  30.281   8.424  0.50 40.29           O  
ATOM    689  OE2 GLU    86      29.047  30.136   8.562  0.50 41.01           O  
ATOM    691  N   PHE    87      30.459  36.460   7.881  1.00 33.43           N  
ATOM    692  CA  PHE    87      30.514  37.608   8.799  1.00 32.14           C  
ATOM    693  C   PHE    87      29.291  38.555   8.647  1.00 33.28           C  
ATOM    694  O   PHE    87      28.853  38.836   7.525  1.00 32.13           O  
ATOM    695  CB  PHE    87      31.831  38.369   8.601  1.00 32.08           C  
ATOM    696  CG  PHE    87      32.117  39.391   9.671  1.00 31.34           C  
ATOM    697  CD1 PHE    87      32.996  39.101  10.712  1.00 33.19           C  
ATOM    698  CD2 PHE    87      31.495  40.627   9.658  1.00 29.19           C  
ATOM    699  CE1 PHE    87      33.261  40.043  11.719  1.00 32.29           C  
ATOM    700  CE2 PHE    87      31.737  41.582  10.675  1.00 30.70           C  
ATOM    701  CZ  PHE    87      32.628  41.276  11.707  1.00 33.57           C  
ATOM    702  N   PRO    88      28.731  39.060   9.777  1.00 32.74           N  
ATOM    703  CA  PRO    88      27.627  40.050   9.723  1.00 32.84           C  
ATOM    704  C   PRO    88      28.187  41.443   9.366  1.00 32.72           C  
ATOM    705  O   PRO    88      28.366  42.318  10.232  1.00 32.91           O  
ATOM    706  CB  PRO    88      27.043  39.997  11.167  1.00 33.17           C  
ATOM    707  CG  PRO    88      28.226  39.725  11.959  1.00 33.49           C  
ATOM    708  CD  PRO    88      29.088  38.758  11.175  1.00 33.24           C  
ATOM    709  N   ALA    89      28.484  41.624   8.075  1.00 31.13           N  
ATOM    710  CA  ALA    89      29.129  42.815   7.561  1.00 30.72           C  
ATOM    711  C   ALA    89      28.449  44.156   7.895  1.00 30.38           C  
ATOM    712  O   ALA    89      29.130  45.181   7.983  1.00 31.56           O  
ATOM    713  CB  ALA    89      29.312  42.676   5.982  1.00 30.19           C  
ATOM    714  N   GLU    90      27.137  44.157   8.098  1.00 30.99           N  
ATOM    715  CA  GLU    90      26.377  45.371   8.444  1.00 31.12           C  
ATOM    716  C   GLU    90      26.762  45.985   9.776  1.00 32.02           C  
ATOM    717  O   GLU    90      26.505  47.156  10.024  1.00 33.10           O  
ATOM    718  CB  GLU    90      24.871  45.089   8.446  1.00 31.81           C  
ATOM    719  CG  GLU    90      24.254  45.011   7.027  1.00 29.73           C  
ATOM    720  CD  GLU    90      22.794  44.731   6.953  1.00 33.74           C  
ATOM    721  OE1 GLU    90      22.035  44.680   7.990  1.00 34.20           O  
ATOM    722  OE2 GLU    90      22.331  44.553   5.798  1.00 31.05           O  
ATOM    723  N   LEU    91      27.346  45.173  10.634  1.00 32.63           N  
ATOM    724  CA  LEU    91      27.817  45.612  11.959  1.00 34.26           C  
ATOM    725  C   LEU    91      29.124  46.366  11.898  1.00 34.34           C  
ATOM    726  O   LEU    91      29.487  47.004  12.865  1.00 34.35           O  
ATOM    727  CB  LEU    91      27.953  44.408  12.899  1.00 34.39           C  
ATOM    728  CG  LEU    91      26.625  43.659  13.155  1.00 36.53           C  
ATOM    729  CD1 LEU    91      26.799  42.696  14.337  1.00 38.24           C  
ATOM    730  CD2 LEU    91      25.377  44.560  13.379  1.00 39.11           C  
ATOM    731  N   LEU    92      29.845  46.295  10.770  1.00 34.27           N  
ATOM    732  CA  LEU    92      31.108  47.030  10.663  1.00 34.20           C  
ATOM    733  C   LEU    92      30.811  48.550  10.494  1.00 35.17           C  
ATOM    734  O   LEU    92      29.763  48.939   9.946  1.00 33.79           O  
ATOM    735  CB  LEU    92      31.972  46.516   9.532  1.00 32.57           C  
ATOM    736  CG  LEU    92      32.376  45.057   9.589  1.00 33.16           C  
ATOM    737  CD1 LEU    92      32.911  44.474   8.185  1.00 32.52           C  
ATOM    738  CD2 LEU    92      33.408  44.895  10.689  1.00 32.37           C  
ATOM    739  N   PRO    93      31.734  49.401  10.978  1.00 35.81           N  
ATOM    740  CA  PRO    93      31.588  50.865  10.836  1.00 37.22           C  
ATOM    741  C   PRO    93      31.281  51.285   9.374  1.00 38.57           C  
ATOM    742  O   PRO    93      31.985  50.864   8.435  1.00 37.83           O  
ATOM    743  CB  PRO    93      32.946  51.397  11.245  1.00 37.53           C  
ATOM    744  CG  PRO    93      33.556  50.341  12.105  1.00 37.95           C  
ATOM    745  CD  PRO    93      32.951  49.019  11.699  1.00 37.38           C  
ATOM    746  N   ALA    94      30.265  52.121   9.212  1.00 39.21           N  
ATOM    747  CA  ALA    94      29.795  52.547   7.908  1.00 40.64           C  
ATOM    748  C   ALA    94      30.846  53.293   7.097  1.00 41.69           C  
ATOM    749  O   ALA    94      30.839  53.220   5.871  1.00 43.45           O  
ATOM    750  CB  ALA    94      28.594  53.435   8.093  1.00 40.53           C  
ATOM    751  N   GLU    95      31.727  54.001   7.795  1.00 42.61           N  
ATOM    752  CA  GLU    95      32.748  54.890   7.206  0.50 43.01           C  
ATOM    754  C   GLU    95      33.948  54.142   6.627  1.00 42.97           C  
ATOM    755  O   GLU    95      34.721  54.703   5.853  1.00 45.71           O  
ATOM    756  CB  GLU    95      33.224  55.927   8.244  0.50 42.81           C  
ATOM    758  CG  GLU    95      33.351  55.423   9.716  0.50 43.53           C  
ATOM    760  CD  GLU    95      31.991  55.154  10.401  0.50 42.38           C  
ATOM    762  OE1 GLU    95      30.966  55.697   9.959  0.50 44.03           O  
ATOM    764  OE2 GLU    95      31.944  54.374  11.363  0.50 42.48           O  
ATOM    766  N   SER    96      34.114  52.886   7.026  1.00 41.41           N  
ATOM    767  CA  SER    96      35.207  52.049   6.582  1.00 40.17           C  
ATOM    768  C   SER    96      35.003  51.437   5.201  1.00 37.08           C  
ATOM    769  O   SER    96      33.889  51.255   4.728  1.00 35.17           O  
ATOM    770  CB  SER    96      35.375  50.924   7.590  1.00 40.72           C  
ATOM    771  OG  SER    96      35.655  51.500   8.866  1.00 45.53           O  
ATOM    772  N   GLY    97      36.105  51.139   4.543  1.00 34.07           N  
ATOM    773  CA  GLY    97      36.084  50.291   3.371  1.00 32.64           C  
ATOM    774  C   GLY    97      35.839  48.835   3.746  1.00 31.97           C  
ATOM    775  O   GLY    97      35.950  48.465   4.912  1.00 29.99           O  
ATOM    776  N   LEU    98      35.454  48.020   2.750  1.00 31.37           N  
ATOM    777  CA  LEU    98      35.116  46.642   3.021  1.00 31.04           C  
ATOM    778  C   LEU    98      35.460  45.738   1.870  1.00 30.64           C  
ATOM    779  O   LEU    98      35.038  45.971   0.717  1.00 30.06           O  
ATOM    780  CB  LEU    98      33.600  46.511   3.358  1.00 30.97           C  
ATOM    781  CG  LEU    98      33.051  45.099   3.698  1.00 32.31           C  
ATOM    782  CD1 LEU    98      33.697  44.497   4.956  1.00 31.26           C  
ATOM    783  CD2 LEU    98      31.482  45.121   3.898  1.00 30.70           C  
ATOM    784  N   LEU    99      36.162  44.651   2.197  1.00 30.07           N  
ATOM    785  CA  LEU    99      36.381  43.569   1.266  1.00 30.81           C  
ATOM    786  C   LEU    99      35.723  42.331   1.801  1.00 30.99           C  
ATOM    787  O   LEU    99      35.727  42.091   3.010  1.00 30.71           O  
ATOM    788  CB  LEU    99      37.885  43.238   1.058  1.00 32.25           C  
ATOM    789  CG  LEU    99      38.770  44.242   0.321  1.00 32.98           C  
ATOM    790  CD1 LEU    99      39.193  45.320   1.271  1.00 36.62           C  
ATOM    791  CD2 LEU    99      39.975  43.565  -0.229  1.00 33.97           C  
ATOM    792  N   ILE   100      35.168  41.546   0.897  1.00 30.41           N  
ATOM    793  CA  ILE   100      34.792  40.177   1.217  1.00 31.12           C  
ATOM    794  C   ILE   100      35.857  39.246   0.639  1.00 30.61           C  
ATOM    795  O   ILE   100      36.181  39.339  -0.545  1.00 30.06           O  
ATOM    796  CB  ILE   100      33.400  39.807   0.645  1.00 31.37           C  
ATOM    797  CG1 ILE   100      32.316  40.838   1.017  1.00 32.21           C  
ATOM    798  CG2 ILE   100      33.034  38.396   1.054  1.00 30.76           C  
ATOM    799  CD1 ILE   100      32.001  40.891   2.463  1.00 32.10           C  
ATOM    800  N   ALA   101      36.414  38.375   1.482  1.00 31.06           N  
ATOM    801  CA  ALA   101      37.602  37.608   1.150  1.00 31.30           C  
ATOM    802  C   ALA   101      37.462  36.157   1.616  1.00 32.07           C  
ATOM    803  O   ALA   101      36.580  35.821   2.438  1.00 29.94           O  
ATOM    804  CB  ALA   101      38.853  38.257   1.800  1.00 30.94           C  
ATOM    805  N   ASP   102      38.309  35.310   1.033  1.00 31.99           N  
ATOM    806  CA  ASP   102      38.595  33.959   1.547  1.00 32.72           C  
ATOM    807  C   ASP   102      40.051  33.647   1.231  1.00 31.93           C  
ATOM    808  O   ASP   102      40.771  34.553   0.879  1.00 31.12           O  
ATOM    809  CB  ASP   102      37.619  32.888   1.009  1.00 33.33           C  
ATOM    810  CG  ASP   102      37.670  32.697  -0.519  1.00 34.59           C  
ATOM    811  OD1 ASP   102      38.603  33.128  -1.228  1.00 33.45           O  
ATOM    812  OD2 ASP   102      36.735  32.065  -1.039  1.00 37.52           O  
ATOM    813  N   ALA   103      40.484  32.386   1.337  1.00 31.51           N  
ATOM    814  CA  ALA   103      41.897  32.076   1.133  1.00 31.02           C  
ATOM    815  C   ALA   103      42.311  32.249  -0.308  1.00 30.32           C  
ATOM    816  O   ALA   103      43.492  32.289  -0.557  1.00 30.88           O  
ATOM    817  CB  ALA   103      42.253  30.645   1.612  1.00 32.43           C  
ATOM    818  N   TYR   104      41.363  32.384  -1.245  1.00 28.87           N  
ATOM    819  CA  TYR   104      41.695  32.281  -2.640  1.00 28.34           C  
ATOM    820  C   TYR   104      41.545  33.554  -3.446  1.00 28.54           C  
ATOM    821  O   TYR   104      42.086  33.648  -4.556  1.00 27.28           O  
ATOM    822  CB  TYR   104      40.829  31.212  -3.278  1.00 29.91           C  
ATOM    823  CG  TYR   104      40.922  29.917  -2.508  1.00 31.41           C  
ATOM    824  CD1 TYR   104      42.062  29.153  -2.586  1.00 34.46           C  
ATOM    825  CD2 TYR   104      39.903  29.514  -1.639  1.00 31.16           C  
ATOM    826  CE1 TYR   104      42.179  27.950  -1.899  1.00 36.23           C  
ATOM    827  CE2 TYR   104      40.014  28.327  -0.920  1.00 33.40           C  
ATOM    828  CZ  TYR   104      41.157  27.549  -1.064  1.00 35.57           C  
ATOM    829  OH  TYR   104      41.324  26.371  -0.378  1.00 36.02           O  
ATOM    830  N   ASP   105      40.810  34.511  -2.908  1.00 28.70           N  
ATOM    831  CA  ASP   105      40.516  35.766  -3.623  1.00 30.60           C  
ATOM    832  C   ASP   105      39.815  36.739  -2.694  1.00 29.56           C  
ATOM    833  O   ASP   105      39.558  36.423  -1.538  1.00 29.98           O  
ATOM    834  CB  ASP   105      39.662  35.489  -4.837  1.00 31.52           C  
ATOM    835  CG  ASP   105      39.812  36.551  -5.961  1.00 35.65           C  
ATOM    836  OD1 ASP   105      40.466  37.614  -5.812  1.00 38.92           O  
ATOM    837  OD2 ASP   105      39.239  36.279  -7.007  1.00 38.82           O  
ATOM    838  N   ALA   106      39.534  37.941  -3.196  1.00 29.26           N  
ATOM    839  CA  ALA   106      38.810  38.950  -2.472  1.00 28.38           C  
ATOM    840  C   ALA   106      38.166  39.942  -3.425  1.00 29.35           C  
ATOM    841  O   ALA   106      38.511  40.010  -4.609  1.00 28.75           O  
ATOM    842  CB  ALA   106      39.710  39.672  -1.485  1.00 28.01           C  
ATOM    843  N   GLU   107      37.169  40.682  -2.940  1.00 29.53           N  
ATOM    844  CA  GLU   107      36.594  41.794  -3.723  1.00 29.12           C  
ATOM    845  C   GLU   107      36.297  42.980  -2.834  1.00 28.84           C  
ATOM    846  O   GLU   107      35.868  42.822  -1.713  1.00 30.23           O  
ATOM    847  CB  GLU   107      35.334  41.359  -4.476  1.00 31.03           C  
ATOM    848  CG  GLU   107      34.201  40.871  -3.577  1.00 31.48           C  
ATOM    849  CD  GLU   107      32.986  40.326  -4.320  1.00 36.07           C  
ATOM    850  OE1 GLU   107      32.978  40.275  -5.558  1.00 29.32           O  
ATOM    851  OE2 GLU   107      32.007  39.912  -3.637  1.00 32.19           O  
ATOM    852  N   ILE   108      36.489  44.178  -3.326  1.00 28.49           N  
ATOM    853  CA  ILE   108      36.142  45.373  -2.566  1.00 29.19           C  
ATOM    854  C   ILE   108      34.641  45.582  -2.845  1.00 29.79           C  
ATOM    855  O   ILE   108      34.221  45.650  -4.002  1.00 31.57           O  
ATOM    856  CB  ILE   108      36.910  46.589  -3.041  1.00 30.58           C  
ATOM    857  CG1 ILE   108      38.430  46.385  -2.854  1.00 31.34           C  
ATOM    858  CG2 ILE   108      36.395  47.861  -2.347  1.00 29.43           C  
ATOM    859  CD1 ILE   108      39.242  47.503  -3.377  1.00 30.62           C  
ATOM    860  N   VAL   109      33.844  45.597  -1.808  1.00 29.31           N  
ATOM    861  CA  VAL   109      32.410  45.850  -1.989  1.00 29.33           C  
ATOM    862  C   VAL   109      32.060  47.292  -1.589  1.00 30.06           C  
ATOM    863  O   VAL   109      30.997  47.791  -1.952  1.00 29.09           O  
ATOM    864  CB  VAL   109      31.540  44.803  -1.274  1.00 28.67           C  
ATOM    865  CG1 VAL   109      31.664  43.424  -2.020  1.00 28.48           C  
ATOM    866  CG2 VAL   109      31.878  44.678   0.186  1.00 27.23           C  
ATOM    867  N   ARG   110      32.957  47.921  -0.833  1.00 30.48           N  
ATOM    868  CA  ARG   110      32.838  49.302  -0.415  1.00 31.76           C  
ATOM    869  C   ARG   110      34.221  49.948  -0.323  1.00 31.92           C  
ATOM    870  O   ARG   110      35.073  49.527   0.469  1.00 30.40           O  
ATOM    871  CB  ARG   110      32.121  49.351   0.949  1.00 33.34           C  
ATOM    872  CG  ARG   110      31.775  50.723   1.408  1.00 32.47           C  
ATOM    873  CD  ARG   110      30.784  50.639   2.558  1.00 34.55           C  
ATOM    874  NE  ARG   110      31.397  50.331   3.818  1.00 33.13           N  
ATOM    875  CZ  ARG   110      30.895  49.500   4.742  1.00 38.01           C  
ATOM    876  NH1 ARG   110      31.545  49.328   5.885  1.00 38.34           N  
ATOM    877  NH2 ARG   110      29.748  48.860   4.549  1.00 38.93           N  
ATOM    878  N   MET   111      34.440  50.976  -1.143  1.00 32.39           N  
ATOM    879  CA  MET   111      35.747  51.614  -1.248  1.00 32.61           C  
ATOM    880  C   MET   111      35.901  52.493  -0.031  1.00 32.80           C  
ATOM    881  O   MET   111      34.948  53.179   0.350  1.00 34.31           O  
ATOM    882  CB  MET   111      35.831  52.404  -2.563  1.00 32.09           C  
ATOM    883  CG  MET   111      37.074  53.170  -2.762  1.00 32.99           C  
ATOM    884  SD  MET   111      38.685  52.092  -2.676  0.65 32.64          SE  
ATOM    885  CE  MET   111      38.431  50.909  -4.191  1.00 29.40           C  
ATOM    886  N   ALA   112      37.062  52.452   0.621  1.00 31.88           N  
ATOM    887  CA  ALA   112      37.270  53.287   1.767  1.00 32.18           C  
ATOM    888  C   ALA   112      37.368  54.764   1.359  1.00 31.82           C  
ATOM    889  O   ALA   112      37.847  55.099   0.267  1.00 31.28           O  
ATOM    890  CB  ALA   112      38.475  52.826   2.516  1.00 32.74           C  
ATOM    891  N   PRO   113      36.904  55.676   2.233  1.00 32.37           N  
ATOM    892  CA  PRO   113      37.153  57.097   1.969  1.00 32.98           C  
ATOM    893  C   PRO   113      38.671  57.422   2.065  1.00 34.37           C  
ATOM    894  O   PRO   113      39.385  56.746   2.804  1.00 33.27           O  
ATOM    895  CB  PRO   113      36.361  57.804   3.071  1.00 33.32           C  
ATOM    896  CG  PRO   113      36.246  56.845   4.164  1.00 33.19           C  
ATOM    897  CD  PRO   113      36.175  55.470   3.501  1.00 32.47           C  
ATOM    898  N   GLU   114      39.137  58.416   1.302  1.00 36.51           N  
ATOM    899  CA  GLU   114      40.559  58.817   1.305  1.00 38.56           C  
ATOM    900  C   GLU   114      40.847  59.871   2.385  1.00 39.40           C  
ATOM    901  O   GLU   114      40.219  60.919   2.412  1.00 39.23           O  
ATOM    902  CB  GLU   114      41.010  59.331  -0.076  1.00 38.96           C  
ATOM    903  CG  GLU   114      42.488  59.786  -0.083  1.00 42.79           C  
ATOM    904  CD  GLU   114      43.315  59.213  -1.225  1.00 47.89           C  
ATOM    905  OE1 GLU   114      42.714  58.779  -2.224  1.00 53.14           O  
ATOM    906  OE2 GLU   114      44.570  59.197  -1.131  1.00 48.25           O  
ATOM    907  N   GLN   115      41.783  59.548   3.275  1.00 40.80           N  
ATOM    908  CA  GLN   115      42.268  60.446   4.317  0.50 41.99           C  
ATOM    910  C   GLN   115      43.793  60.544   4.173  1.00 42.34           C  
ATOM    911  O   GLN   115      44.534  60.025   5.015  1.00 42.61           O  
ATOM    912  CB  GLN   115      41.880  59.905   5.712  0.50 42.46           C  
ATOM    914  CG  GLN   115      40.818  58.772   5.706  0.50 44.17           C  
ATOM    916  CD  GLN   115      39.800  58.895   6.827  0.50 45.73           C  
ATOM    918  OE1 GLN   115      38.600  58.789   6.585  0.50 47.54           O  
ATOM    920  NE2 GLN   115      40.271  59.125   8.052  0.50 47.44           N  
ATOM    922  N   LYS   116      44.249  61.179   3.097  1.00 42.86           N  
ATOM    923  CA  LYS   116      45.673  61.190   2.744  1.00 43.55           C  
ATOM    924  C   LYS   116      46.675  61.487   3.886  1.00 43.30           C  
ATOM    925  O   LYS   116      46.454  62.315   4.770  1.00 42.24           O  
ATOM    926  CB  LYS   116      45.944  62.167   1.595  1.00 44.43           C  
ATOM    927  CG  LYS   116      45.694  61.624   0.183  1.00 46.12           C  
ATOM    928  CD  LYS   116      46.476  62.501  -0.855  1.00 48.81           C  
ATOM    929  CE  LYS   116      45.588  63.021  -2.009  1.00 50.12           C  
ATOM    930  NZ  LYS   116      45.068  61.926  -2.889  1.00 51.16           N  
ATOM    931  N   LEU   117      47.795  60.786   3.801  1.00 43.26           N  
ATOM    932  CA  LEU   117      48.880  60.847   4.762  1.00 43.52           C  
ATOM    933  C   LEU   117      49.768  62.060   4.391  1.00 43.97           C  
ATOM    934  O   LEU   117      49.868  62.431   3.218  1.00 43.20           O  
ATOM    935  CB  LEU   117      49.662  59.524   4.650  1.00 43.32           C  
ATOM    936  CG  LEU   117      49.971  58.514   5.768  1.00 42.50           C  
ATOM    937  CD1 LEU   117      49.035  58.460   6.894  1.00 38.84           C  
ATOM    938  CD2 LEU   117      50.079  57.121   5.121  1.00 41.84           C  
ATOM    939  N   ALA   118      50.407  62.680   5.379  1.00 45.49           N  
ATOM    940  CA  ALA   118      51.416  63.721   5.118  1.00 46.60           C  
ATOM    941  C   ALA   118      52.688  63.104   4.473  1.00 47.17           C  
ATOM    942  O   ALA   118      52.980  61.941   4.739  1.00 46.34           O  
ATOM    943  CB  ALA   118      51.750  64.457   6.420  1.00 47.88           C  
ATOM    944  N   PRO   119      53.399  63.850   3.574  1.00 47.51           N  
ATOM    945  CA  PRO   119      54.599  63.389   2.842  1.00 47.59           C  
ATOM    946  C   PRO   119      55.693  62.724   3.689  1.00 47.35           C  
ATOM    947  O   PRO   119      56.294  61.727   3.249  1.00 46.86           O  
ATOM    948  CB  PRO   119      55.169  64.678   2.206  1.00 47.81           C  
ATOM    949  CG  PRO   119      53.996  65.589   2.057  1.00 48.09           C  
ATOM    950  CD  PRO   119      52.975  65.194   3.127  1.00 48.21           C  
ATOM    951  N   ALA   120      55.949  63.290   4.875  1.00 46.56           N  
ATOM    952  CA  ALA   120      57.009  62.781   5.740  1.00 46.24           C  
ATOM    953  C   ALA   120      56.628  61.425   6.315  1.00 44.99           C  
ATOM    954  O   ALA   120      57.461  60.542   6.467  1.00 43.76           O  
ATOM    955  CB  ALA   120      57.310  63.767   6.869  1.00 46.49           C  
ATOM    956  N   ARG   121      55.364  61.273   6.649  1.00 44.79           N  
ATOM    957  CA  ARG   121      54.872  60.019   7.199  1.00 44.89           C  
ATOM    958  C   ARG   121      54.772  58.924   6.150  1.00 43.80           C  
ATOM    959  O   ARG   121      55.066  57.770   6.436  1.00 43.62           O  
ATOM    960  CB  ARG   121      53.491  60.228   7.743  1.00 45.15           C  
ATOM    961  CG  ARG   121      52.984  59.105   8.616  1.00 47.67           C  
ATOM    962  CD  ARG   121      53.018  59.592  10.052  1.00 48.71           C  
ATOM    963  NE  ARG   121      51.957  59.036  10.799  1.00 47.08           N  
ATOM    964  CZ  ARG   121      51.534  59.475  11.983  1.00 45.97           C  
ATOM    965  NH1 ARG   121      50.526  58.854  12.536  1.00 42.19           N  
ATOM    966  NH2 ARG   121      52.105  60.484  12.633  1.00 42.92           N  
ATOM    967  N   ARG   122      54.295  59.281   4.962  1.00 42.61           N  
ATOM    968  CA  ARG   122      54.302  58.366   3.838  1.00 42.30           C  
ATOM    969  C   ARG   122      55.717  57.791   3.628  1.00 42.47           C  
ATOM    970  O   ARG   122      55.894  56.603   3.371  1.00 41.94           O  
ATOM    971  CB  ARG   122      53.861  59.088   2.582  1.00 41.69           C  
ATOM    972  CG  ARG   122      53.694  58.186   1.376  1.00 41.56           C  
ATOM    973  CD  ARG   122      53.218  58.964   0.170  1.00 41.36           C  
ATOM    974  NE  ARG   122      52.043  59.741   0.536  1.00 40.48           N  
ATOM    975  CZ  ARG   122      50.842  59.221   0.739  1.00 43.83           C  
ATOM    976  NH1 ARG   122      50.639  57.914   0.587  1.00 45.33           N  
ATOM    977  NH2 ARG   122      49.835  60.018   1.125  1.00 40.81           N  
ATOM    978  N   LYS   123      56.719  58.642   3.707  1.00 42.91           N  
ATOM    979  CA  LYS   123      58.126  58.207   3.531  1.00 43.36           C  
ATOM    980  C   LYS   123      58.548  57.179   4.554  1.00 42.40           C  
ATOM    981  O   LYS   123      59.149  56.157   4.210  1.00 42.17           O  
ATOM    982  CB  LYS   123      59.087  59.375   3.697  1.00 45.04           C  
ATOM    983  CG  LYS   123      59.344  60.143   2.450  1.00 49.40           C  
ATOM    984  CD  LYS   123      60.707  60.818   2.482  1.00 54.56           C  
ATOM    985  CE  LYS   123      60.650  62.240   1.878  1.00 57.35           C  
ATOM    986  NZ  LYS   123      59.260  62.655   1.400  1.00 57.21           N  
ATOM    987  N   VAL   124      58.269  57.467   5.819  1.00 41.11           N  
ATOM    988  CA  VAL   124      58.646  56.570   6.908  1.00 40.38           C  
ATOM    989  C   VAL   124      58.011  55.204   6.725  1.00 39.67           C  
ATOM    990  O   VAL   124      58.674  54.169   6.875  1.00 38.37           O  
ATOM    991  CB  VAL   124      58.257  57.153   8.287  1.00 40.77           C  
ATOM    992  CG1 VAL   124      58.451  56.116   9.393  1.00 42.42           C  
ATOM    993  CG2 VAL   124      59.092  58.337   8.592  1.00 40.80           C  
ATOM    994  N   LEU   125      56.715  55.188   6.383  1.00 38.13           N  
ATOM    995  CA  LEU   125      56.004  53.955   6.266  1.00 37.40           C  
ATOM    996  C   LEU   125      56.437  53.132   5.049  1.00 36.22           C  
ATOM    997  O   LEU   125      56.467  51.932   5.119  1.00 36.07           O  
ATOM    998  CB  LEU   125      54.501  54.230   6.178  1.00 37.35           C  
ATOM    999  CG  LEU   125      53.866  54.793   7.444  1.00 38.53           C  
ATOM   1000  CD1 LEU   125      52.439  55.234   7.103  1.00 36.55           C  
ATOM   1001  CD2 LEU   125      53.867  53.719   8.560  1.00 36.32           C  
ATOM   1002  N   ILE   126      56.713  53.779   3.931  1.00 36.14           N  
ATOM   1003  CA  ILE   126      57.241  53.080   2.749  1.00 35.99           C  
ATOM   1004  C   ILE   126      58.612  52.438   3.014  1.00 35.57           C  
ATOM   1005  O   ILE   126      58.883  51.300   2.576  1.00 35.09           O  
ATOM   1006  CB  ILE   126      57.222  53.984   1.480  1.00 35.88           C  
ATOM   1007  CG1 ILE   126      55.759  54.345   1.163  1.00 36.66           C  
ATOM   1008  CG2 ILE   126      57.978  53.277   0.261  1.00 35.04           C  
ATOM   1009  CD1 ILE   126      55.552  55.126  -0.092  1.00 37.14           C  
ATOM   1010  N   GLN   127      59.435  53.122   3.788  1.00 35.49           N  
ATOM   1011  CA  GLN   127      60.748  52.618   4.177  1.00 35.94           C  
ATOM   1012  C   GLN   127      60.589  51.363   5.038  1.00 36.10           C  
ATOM   1013  O   GLN   127      61.335  50.365   4.870  1.00 34.83           O  
ATOM   1014  CB  GLN   127      61.554  53.697   4.921  1.00 37.03           C  
ATOM   1015  CG  GLN   127      62.818  53.214   5.609  1.00 37.55           C  
ATOM   1016  CD  GLN   127      63.933  53.025   4.659  1.00 40.37           C  
ATOM   1017  OE1 GLN   127      64.111  53.833   3.752  1.00 42.14           O  
ATOM   1018  NE2 GLN   127      64.746  51.989   4.882  1.00 41.30           N  
ATOM   1019  N   LYS   128      59.604  51.410   5.936  1.00 35.63           N  
ATOM   1020  CA  LYS   128      59.332  50.301   6.848  1.00 34.77           C  
ATOM   1021  C   LYS   128      58.790  49.110   6.089  1.00 34.02           C  
ATOM   1022  O   LYS   128      59.157  47.982   6.371  1.00 33.41           O  
ATOM   1023  CB  LYS   128      58.342  50.717   7.931  1.00 34.60           C  
ATOM   1024  CG  LYS   128      58.969  51.487   9.048  1.00 39.61           C  
ATOM   1025  CD  LYS   128      57.941  52.005  10.052  1.00 41.93           C  
ATOM   1026  CE  LYS   128      58.606  53.085  10.914  1.00 46.04           C  
ATOM   1027  NZ  LYS   128      58.280  52.892  12.368  1.00 46.57           N  
ATOM   1028  N   PHE   129      57.890  49.380   5.153  1.00 32.95           N  
ATOM   1029  CA  PHE   129      57.306  48.360   4.312  1.00 33.01           C  
ATOM   1030  C   PHE   129      58.395  47.649   3.492  1.00 33.38           C  
ATOM   1031  O   PHE   129      58.469  46.406   3.489  1.00 33.16           O  
ATOM   1032  CB  PHE   129      56.273  49.021   3.422  1.00 32.46           C  
ATOM   1033  CG  PHE   129      55.574  48.100   2.489  1.00 31.79           C  
ATOM   1034  CD1 PHE   129      54.278  47.682   2.758  1.00 32.57           C  
ATOM   1035  CD2 PHE   129      56.158  47.685   1.311  1.00 31.11           C  
ATOM   1036  CE1 PHE   129      53.610  46.856   1.869  1.00 30.91           C  
ATOM   1037  CE2 PHE   129      55.499  46.864   0.425  1.00 32.46           C  
ATOM   1038  CZ  PHE   129      54.230  46.422   0.702  1.00 31.79           C  
ATOM   1039  N   ALA   130      59.221  48.448   2.818  1.00 33.33           N  
ATOM   1040  CA  ALA   130      60.407  47.950   2.052  1.00 33.63           C  
ATOM   1041  C   ALA   130      61.277  47.025   2.897  1.00 32.83           C  
ATOM   1042  O   ALA   130      61.613  45.899   2.523  1.00 31.42           O  
ATOM   1043  CB  ALA   130      61.250  49.124   1.558  1.00 32.72           C  
ATOM   1044  N   THR   131      61.591  47.500   4.073  1.00 32.85           N  
ATOM   1045  CA  THR   131      62.413  46.753   4.979  1.00 33.64           C  
ATOM   1046  C   THR   131      61.783  45.448   5.399  1.00 32.48           C  
ATOM   1047  O   THR   131      62.454  44.430   5.442  1.00 31.61           O  
ATOM   1048  CB  THR   131      62.747  47.599   6.186  1.00 34.24           C  
ATOM   1049  OG1 THR   131      63.439  48.756   5.711  1.00 34.28           O  
ATOM   1050  CG2 THR   131      63.637  46.820   7.134  1.00 36.35           C  
ATOM   1051  N   HIS   132      60.485  45.489   5.691  1.00 33.22           N  
ATOM   1052  CA  HIS   132      59.739  44.311   6.126  1.00 32.97           C  
ATOM   1053  C   HIS   132      59.736  43.274   5.015  1.00 32.06           C  
ATOM   1054  O   HIS   132      60.071  42.089   5.202  1.00 30.93           O  
ATOM   1055  CB  HIS   132      58.309  44.767   6.490  1.00 33.23           C  
ATOM   1056  CG  HIS   132      57.380  43.673   6.899  1.00 33.85           C  
ATOM   1057  ND1 HIS   132      56.700  43.700   8.101  1.00 33.95           N  
ATOM   1058  CD2 HIS   132      56.937  42.569   6.243  1.00 33.16           C  
ATOM   1059  CE1 HIS   132      55.908  42.643   8.179  1.00 32.64           C  
ATOM   1060  NE2 HIS   132      56.031  41.942   7.065  1.00 30.46           N  
ATOM   1061  N   ALA   133      59.328  43.727   3.837  1.00 31.75           N  
ATOM   1062  CA  ALA   133      59.244  42.852   2.693  1.00 30.24           C  
ATOM   1063  C   ALA   133      60.567  42.187   2.369  1.00 29.49           C  
ATOM   1064  O   ALA   133      60.622  40.971   2.107  1.00 30.73           O  
ATOM   1065  CB  ALA   133      58.757  43.650   1.511  1.00 29.31           C  
ATOM   1066  N   ALA   134      61.631  42.982   2.316  1.00 28.49           N  
ATOM   1067  CA  ALA   134      62.926  42.475   1.881  1.00 27.28           C  
ATOM   1068  C   ALA   134      63.539  41.515   2.914  1.00 28.08           C  
ATOM   1069  O   ALA   134      64.128  40.517   2.524  1.00 26.06           O  
ATOM   1070  CB  ALA   134      63.887  43.601   1.497  1.00 28.12           C  
ATOM   1071  N   ARG   135      63.335  41.771   4.208  1.00 29.15           N  
ATOM   1072  CA  ARG   135      63.798  40.846   5.246  1.00 29.60           C  
ATOM   1073  C   ARG   135      63.136  39.496   5.099  1.00 30.00           C  
ATOM   1074  O   ARG   135      63.804  38.471   5.096  1.00 30.62           O  
ATOM   1075  CB  ARG   135      63.525  41.364   6.672  1.00 29.23           C  
ATOM   1076  CG  ARG   135      64.605  42.218   7.201  1.00 34.62           C  
ATOM   1077  CD  ARG   135      64.358  42.618   8.697  1.00 38.89           C  
ATOM   1078  NE  ARG   135      65.422  43.550   9.090  1.00 47.15           N  
ATOM   1079  CZ  ARG   135      65.246  44.733   9.701  1.00 50.14           C  
ATOM   1080  NH1 ARG   135      64.028  45.160  10.070  1.00 50.63           N  
ATOM   1081  NH2 ARG   135      66.312  45.488   9.974  1.00 49.80           N  
ATOM   1082  N   ARG   136      61.790  39.495   5.037  1.00 30.67           N  
ATOM   1083  CA  ARG   136      61.048  38.243   4.931  1.00 30.83           C  
ATOM   1084  C   ARG   136      61.417  37.475   3.691  1.00 29.56           C  
ATOM   1085  O   ARG   136      61.473  36.261   3.712  1.00 29.65           O  
ATOM   1086  CB  ARG   136      59.524  38.505   4.909  1.00 31.76           C  
ATOM   1087  CG  ARG   136      59.014  39.294   6.065  1.00 36.83           C  
ATOM   1088  CD  ARG   136      59.004  38.556   7.316  1.00 42.45           C  
ATOM   1089  NE  ARG   136      58.221  39.289   8.324  1.00 48.18           N  
ATOM   1090  CZ  ARG   136      58.682  40.286   9.099  1.00 51.11           C  
ATOM   1091  NH1 ARG   136      59.940  40.731   8.999  1.00 52.60           N  
ATOM   1092  NH2 ARG   136      57.870  40.847   9.986  1.00 52.86           N  
ATOM   1093  N   LEU   137      61.579  38.178   2.582  1.00 29.38           N  
ATOM   1094  CA  LEU   137      61.999  37.561   1.329  1.00 28.94           C  
ATOM   1095  C   LEU   137      63.352  36.874   1.462  1.00 29.34           C  
ATOM   1096  O   LEU   137      63.513  35.689   1.113  1.00 30.12           O  
ATOM   1097  CB  LEU   137      62.057  38.612   0.245  1.00 28.19           C  
ATOM   1098  CG  LEU   137      62.578  38.237  -1.144  1.00 28.63           C  
ATOM   1099  CD1 LEU   137      61.872  37.025  -1.693  1.00 28.56           C  
ATOM   1100  CD2 LEU   137      62.419  39.454  -2.036  1.00 27.13           C  
ATOM   1101  N   GLN   138      64.330  37.599   2.009  1.00 28.89           N  
ATOM   1102  CA  GLN   138      65.664  37.027   2.177  1.00 27.63           C  
ATOM   1103  C   GLN   138      65.642  35.771   3.076  1.00 28.06           C  
ATOM   1104  O   GLN   138      66.330  34.810   2.799  1.00 28.10           O  
ATOM   1105  CB  GLN   138      66.680  38.080   2.654  1.00 27.43           C  
ATOM   1106  CG  GLN   138      68.167  37.618   2.581  1.00 25.72           C  
ATOM   1107  CD  GLN   138      68.624  36.982   3.883  1.00 28.91           C  
ATOM   1108  OE1 GLN   138      67.839  36.922   4.854  1.00 30.24           O  
ATOM   1109  NE2 GLN   138      69.870  36.485   3.921  1.00 24.05           N  
ATOM   1110  N   ALA   139      64.847  35.800   4.132  1.00 29.36           N  
ATOM   1111  CA  ALA   139      64.735  34.690   5.035  1.00 30.23           C  
ATOM   1112  C   ALA   139      64.095  33.433   4.382  1.00 32.15           C  
ATOM   1113  O   ALA   139      64.429  32.303   4.759  1.00 33.40           O  
ATOM   1114  CB  ALA   139      63.982  35.118   6.266  1.00 29.95           C  
ATOM   1115  N   LEU   140      63.170  33.615   3.445  1.00 32.96           N  
ATOM   1116  CA  LEU   140      62.568  32.490   2.722  1.00 34.03           C  
ATOM   1117  C   LEU   140      63.532  31.926   1.724  1.00 35.42           C  
ATOM   1118  O   LEU   140      63.681  30.714   1.620  1.00 35.86           O  
ATOM   1119  CB  LEU   140      61.274  32.916   2.012  1.00 33.87           C  
ATOM   1120  CG  LEU   140      60.018  32.982   2.847  1.00 35.13           C  
ATOM   1121  CD1 LEU   140      58.791  33.326   1.930  1.00 32.30           C  
ATOM   1122  CD2 LEU   140      59.794  31.673   3.641  1.00 35.34           C  
ATOM   1123  N   ARG   141      64.276  32.801   1.047  1.00 36.64           N  
ATOM   1124  CA  ARG   141      65.287  32.352   0.075  1.00 37.91           C  
ATOM   1125  C   ARG   141      66.548  31.761   0.649  1.00 37.87           C  
ATOM   1126  O   ARG   141      67.213  30.962  -0.007  1.00 37.13           O  
ATOM   1127  CB  ARG   141      65.639  33.496  -0.864  1.00 38.46           C  
ATOM   1128  CG  ARG   141      64.421  34.078  -1.487  1.00 41.46           C  
ATOM   1129  CD  ARG   141      64.562  34.460  -2.929  1.00 47.70           C  
ATOM   1130  NE  ARG   141      65.693  35.313  -3.174  1.00 52.73           N  
ATOM   1131  CZ  ARG   141      66.759  34.994  -3.922  1.00 57.69           C  
ATOM   1132  NH1 ARG   141      67.731  35.873  -4.045  1.00 57.08           N  
ATOM   1133  NH2 ARG   141      66.877  33.820  -4.558  1.00 60.85           N  
ATOM   1134  N   ASP   142      66.873  32.133   1.894  1.00 36.79           N  
ATOM   1135  CA  ASP   142      68.116  31.738   2.528  1.00 35.37           C  
ATOM   1136  C   ASP   142      67.823  31.607   4.025  1.00 35.29           C  
ATOM   1137  O   ASP   142      68.215  32.455   4.788  1.00 33.42           O  
ATOM   1138  CB  ASP   142      69.171  32.819   2.244  1.00 35.26           C  
ATOM   1139  CG  ASP   142      70.549  32.503   2.793  1.00 34.73           C  
ATOM   1140  OD1 ASP   142      70.806  31.384   3.324  1.00 36.25           O  
ATOM   1141  OD2 ASP   142      71.403  33.419   2.715  1.00 29.26           O  
ATOM   1142  N   PRO   143      67.130  30.523   4.427  1.00 36.28           N  
ATOM   1143  CA  PRO   143      66.664  30.323   5.800  1.00 35.81           C  
ATOM   1144  C   PRO   143      67.740  30.476   6.879  1.00 35.40           C  
ATOM   1145  O   PRO   143      67.446  31.016   7.961  1.00 34.44           O  
ATOM   1146  CB  PRO   143      66.105  28.904   5.789  1.00 36.12           C  
ATOM   1147  CG  PRO   143      65.852  28.569   4.361  1.00 37.43           C  
ATOM   1148  CD  PRO   143      66.667  29.454   3.512  1.00 37.57           C  
END
