
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  128 ( 1032),  selected  128 , name 2inb_A
# Molecule2: number of CA atoms  139 ( 1110),  selected  139 , name T0495_5_143.pdb
# PARAMETERS: 2inb_A.T0495_5_143.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      L       5           -
LGA    -       -      D       6           -
LGA    -       -      L       7           -
LGA    -       -      Q       8           -
LGA    -       -      P       9           -
LGA    -       -      G      10           -
LGA    D     5_A      Q      11          2.220
LGA    V     6_A      R      12          2.183
LGA    F     7_A      L      13          2.192
LGA    H     8_A      A      14          1.907
LGA    Q     9_A      R      15          1.345
LGA    V    10_A      G      16          1.820
LGA    V    11_A      V      17          1.538
LGA    K    12_A      A      18          0.978
LGA    I    13_A      R      19          1.153
LGA    A    14_A      H      20          1.972
LGA    L    15_A      L      21          1.595
LGA    E    16_A      R      22          1.481
LGA    K    17_A      A      23          1.958
LGA    D    18_A      H      24          2.387
LGA    G    19_A      G      25          2.315
LGA    W    20_A      F      26          1.333
LGA    Q    21_A      V      27          1.463
LGA    I    22_A      S      28          1.689
LGA    T    23_A      -       -           -
LGA    N    24_A      V      29          3.387
LGA    D    25_A      E      30          2.446
LGA    P    26_A      E      31          2.425
LGA    L    27_A      F      32          1.633
LGA    T    28_A      V      33          0.893
LGA    I    29_A      P      34          2.079
LGA    S    30_A      A      35          1.876
LGA    V    31_A      R      36          4.820
LGA    G    32_A      -       -           -
LGA    G    33_A      -       -           -
LGA    V    34_A      G      37          3.699
LGA    N    35_A      L      38          4.970
LGA    L    36_A      R      39          4.464
LGA    K    44_A      V      40          4.606
LGA    L    45_A      D      41          2.530
LGA    I    46_A      V      42          1.639
LGA    A    47_A      M      43          1.692
LGA    A    48_A      G      44          1.470
LGA    E    49_A      L      45          2.023
LGA    R    50_A      G      46          2.161
LGA    E    51_A      P      47          2.675
LGA    G    52_A      K      48          1.376
LGA    -       -      G      49           -
LGA    E    53_A      E      50          2.288
LGA    K    54_A      I      51          2.051
LGA    I    55_A      W      52          1.115
LGA    A    56_A      V      53          1.556
LGA    V    57_A      I      54          1.294
LGA    E    58_A      E      55          1.283
LGA    V    59_A      C      56          1.395
LGA    K    60_A      K      57          1.563
LGA    S    61_A      S      58          1.856
LGA    F    62_A      S      59          1.872
LGA    L    63_A      -       -           -
LGA    E    64_A      -       -           -
LGA    R    65_A      -       -           -
LGA    S    66_A      -       -           -
LGA    S    67_A      -       -           -
LGA    A    68_A      -       -           -
LGA    I    69_A      R      60          4.137
LGA    S    70_A      A      61          2.967
LGA    E    71_A      D      62          2.924
LGA    F    72_A      F      63          2.659
LGA    H    73_A      Q      64          1.665
LGA    T    74_A      A      65          1.493
LGA    A    75_A      D      66          3.034
LGA    L    76_A      A      67          3.877
LGA    G    77_A      K      68          2.776
LGA    Q    78_A      -       -           -
LGA    F    79_A      W      69          1.773
LGA    I    80_A      Q      70          1.739
LGA    N    81_A      G      71          2.481
LGA    Y    82_A      Y      72          2.190
LGA    R    83_A      L      73          2.266
LGA    G    84_A      E      74          4.432
LGA    A    85_A      -       -           -
LGA    L    86_A      W      75          1.687
LGA    R    87_A      -       -           -
LGA    R    88_A      -       -           -
LGA    R    89_A      -       -           -
LGA    Q    90_A      -       -           -
LGA    P    91_A      -       -           -
LGA    E    92_A      C      76          5.152
LGA    R    93_A      D      77          3.098
LGA    V    94_A      R      78          2.184
LGA    L    95_A      Y      79          2.047
LGA    Y    96_A      F      80          1.513
LGA    L    97_A      W      81          1.617
LGA    A    98_A      A      82          1.425
LGA    V    99_A      V      83          1.609
LGA    P   100_A      D      84          1.871
LGA    L   101_A      M      85          3.285
LGA    T   102_A      E      86          3.407
LGA    T   103_A      F      87          1.832
LGA    Y   104_A      -       -           -
LGA    K   105_A      -       -           -
LGA    T   106_A      -       -           -
LGA    F   107_A      P      88          1.355
LGA    F   108_A      A      89          2.393
LGA    Q   109_A      E      90          3.391
LGA    L   110_A      -       -           -
LGA    D   111_A      -       -           -
LGA    F   112_A      -       -           -
LGA    P   113_A      L      91          1.894
LGA    K   114_A      L      92           #
LGA    E   115_A      -       -           -
LGA    X   116_A      -       -           -
LGA    I   117_A      P      93          1.051
LGA    A   118_A      A      94          2.957
LGA    E   119_A      -       -           -
LGA    N   120_A      -       -           -
LGA    Q   121_A      -       -           -
LGA    V   122_A      E      95          4.008
LGA    K   123_A      S      96          1.421
LGA    X   124_A      G      97          2.495
LGA    L   125_A      L      98          2.726
LGA    I   126_A      L      99          1.573
LGA    Y   127_A      I     100          2.257
LGA    D   128_A      A     101          3.637
LGA    V   129_A      D     102          2.108
LGA    E   130_A      A     103           #
LGA    Q   131_A      Y     104          5.005
LGA    E   132_A      D     105          0.909
LGA    V   133_A      A     106          2.648
LGA    I   134_A      E     107          1.326
LGA    F   135_A      I     108          4.085
LGA    Q   136_A      V     109          1.489
LGA    W   137_A      R     110          2.752
LGA    I   138_A      M     111          3.703
LGA    N   139_A      A     112          3.854
LGA    -       -      P     113           -
LGA    -       -      E     114           -
LGA    -       -      Q     115           -
LGA    -       -      K     116           -
LGA    -       -      L     117           -
LGA    -       -      A     118           -
LGA    -       -      P     119           -
LGA    -       -      A     120           -
LGA    -       -      R     121           -
LGA    -       -      R     122           -
LGA    -       -      K     123           -
LGA    -       -      V     124           -
LGA    -       -      L     125           -
LGA    -       -      I     126           -
LGA    -       -      Q     127           -
LGA    -       -      K     128           -
LGA    -       -      F     129           -
LGA    -       -      A     130           -
LGA    -       -      T     131           -
LGA    -       -      H     132           -
LGA    -       -      A     133           -
LGA    -       -      A     134           -
LGA    -       -      R     135           -
LGA    -       -      R     136           -
LGA    -       -      L     137           -
LGA    -       -      Q     138           -
LGA    -       -      A     139           -
LGA    -       -      L     140           -
LGA    -       -      R     141           -
LGA    -       -      D     142           -
LGA    -       -      P     143           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  128  139    5.0     99    2.55    13.13     46.254     3.742

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.478696 * X  +   0.035762 * Y  +   0.877252 * Z  +  25.969049
  Y_new =  -0.172989 * X  +  -0.975742 * Y  +   0.134173 * Z  +  88.499138
  Z_new =   0.860770 * X  +  -0.215983 * Y  +  -0.460897 * Z  +   9.400730 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.703366    0.438226  [ DEG:  -154.8915     25.1085 ]
  Theta =  -1.036781   -2.104812  [ DEG:   -59.4032   -120.5968 ]
  Phi   =  -0.346774    2.794819  [ DEG:   -19.8687    160.1313 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2inb_A                                        
REMARK     2: T0495_5_143.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2inb_A.T0495_5_143.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  128  139   5.0   99   2.55   13.13  46.254
REMARK  ---------------------------------------------------------- 
MOLECULE 2inb_A
HEADER    STRUCTURAL GENOMICS/UNKNOWN FUNCTION    06-OCT-06   2INB              
TITLE     CRYSTAL STRUCTURE OF AN XISH FAMILY PROTEIN (ZP_00107633.1)           
TITLE    2 FROM NOSTOC PUNCTIFORME PCC 73102 AT 1.60 A RESOLUTION               
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: HYPOTHETICAL PROTEIN;                                      
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: NOSTOC PUNCTIFORME PCC 73102;                   
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: ZP_00107633.1;                                                 
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    ZP_00107633.1, HYPOTHETICAL PROTEIN, STRUCTURAL GENOMICS,             
KEYWDS   2 PSI-2, PROTEIN STRUCTURE INITIATIVE, JOINT CENTER FOR                
KEYWDS   3 STRUCTURAL GENOMICS, JCSG                                            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   24-OCT-06 2INB    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF HYPOTHETICAL PROTEIN                    
JRNL        TITL 2 (ZP_00107633.1) FROM NOSTOC PUNCTIFORME PCC 73102            
JRNL        TITL 3 AT 1.60 A RESOLUTION                                         
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.60 ANGSTROMS.                                          
DBREF  2INB A    1   139  GB     23125711 ZP_00107633      1    139             
SEQRES   1 A  140  GLY MSE SER ALA LYS ASP VAL PHE HIS GLN VAL VAL LYS          
SEQRES   2 A  140  ILE ALA LEU GLU LYS ASP GLY TRP GLN ILE THR ASN ASP          
SEQRES   3 A  140  PRO LEU THR ILE SER VAL GLY GLY VAL ASN LEU SER ILE          
SEQRES   4 A  140  ASP LEU GLY ALA GLU LYS LEU ILE ALA ALA GLU ARG GLU          
SEQRES   5 A  140  GLY GLU LYS ILE ALA VAL GLU VAL LYS SER PHE LEU GLU          
SEQRES   6 A  140  ARG SER SER ALA ILE SER GLU PHE HIS THR ALA LEU GLY          
SEQRES   7 A  140  GLN PHE ILE ASN TYR ARG GLY ALA LEU ARG ARG ARG GLN          
SEQRES   8 A  140  PRO GLU ARG VAL LEU TYR LEU ALA VAL PRO LEU THR THR          
SEQRES   9 A  140  TYR LYS THR PHE PHE GLN LEU ASP PHE PRO LYS GLU MSE          
SEQRES  10 A  140  ILE ALA GLU ASN GLN VAL LYS MSE LEU ILE TYR ASP VAL          
SEQRES  11 A  140  GLU GLN GLU VAL ILE PHE GLN TRP ILE ASN                      
HET    MSE  A 116      16                                                       
HET    MSE  A 124      16                                                       
HET     CL      1       1                                                       
HET    GOL      2      12                                                       
HET    GOL      3       6                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      CL CHLORIDE ION                                                     
HETNAM     GOL GLYCEROL                                                         
FORMUL   1  MSE    2(C5 H11 N O2 SE)                                            
FORMUL   2   CL    CL 1-                                                        
FORMUL   3  GOL    2(C3 H8 O3)                                                  
FORMUL   5  HOH   *136(H2 O)                                                    
CRYST1   59.554   59.554   71.563  90.00  90.00 120.00 P 31 2 1      6          
ATOM      1  N   ASP A   5      46.137  32.557   9.219  1.00 41.12           N  
ATOM      2  CA  ASP A   5      47.177  32.603   8.148  1.00 38.27           C  
ATOM      3  C   ASP A   5      46.521  32.456   6.783  1.00 34.82           C  
ATOM      4  O   ASP A   5      46.908  33.124   5.819  1.00 29.37           O  
ATOM      5  CB  ASP A   5      48.217  31.490   8.344  1.00 39.16           C  
ATOM      6  N   VAL A   6      45.543  31.556   6.696  1.00 33.85           N  
ATOM      7  CA  VAL A   6      44.874  31.287   5.426  1.00 32.87           C  
ATOM      8  C   VAL A   6      44.145  32.542   4.918  1.00 30.53           C  
ATOM      9  O   VAL A   6      44.316  32.918   3.755  1.00 24.51           O  
ATOM     10  CB  VAL A   6      43.884  30.104   5.526  1.00 35.74           C  
ATOM     11  CG1 VAL A   6      43.140  29.931   4.192  1.00 36.22           C  
ATOM     12  CG2 VAL A   6      44.634  28.811   5.914  1.00 33.53           C  
ATOM     13  N   PHE A   7      43.354  33.182   5.782  1.00 28.38           N  
ATOM     14  CA  PHE A   7      42.588  34.367   5.369  1.00 25.55           C  
ATOM     15  C   PHE A   7      43.501  35.556   5.056  1.00 23.11           C  
ATOM     16  O   PHE A   7      43.256  36.376   4.153  1.00 22.02           O  
ATOM     17  CB  PHE A   7      41.554  34.738   6.443  1.00 25.09           C  
ATOM     18  CG  PHE A   7      40.454  33.734   6.597  1.00 29.20           C  
ATOM     19  CD1 PHE A   7      40.605  32.627   7.448  1.00 32.06           C  
ATOM     20  CD2 PHE A   7      39.265  33.878   5.908  1.00 25.52           C  
ATOM     21  CE1 PHE A   7      39.580  31.694   7.579  1.00 34.70           C  
ATOM     22  CE2 PHE A   7      38.238  32.964   6.042  1.00 29.74           C  
ATOM     23  CZ  PHE A   7      38.391  31.865   6.865  1.00 35.27           C  
ATOM     24  N   HIS A   8      44.600  35.627   5.790  1.00 21.51           N  
ATOM     25  CA  HIS A   8      45.635  36.612   5.495  1.00 20.63           C  
ATOM     26  C   HIS A   8      46.143  36.461   4.047  1.00 22.55           C  
ATOM     27  O   HIS A   8      46.270  37.454   3.317  1.00 21.13           O  
ATOM     28  CB  HIS A   8      46.780  36.445   6.486  1.00 26.43           C  
ATOM     29  CG  HIS A   8      47.798  37.524   6.395  1.00 29.07           C  
ATOM     30  ND1 HIS A   8      47.770  38.636   7.206  1.00 28.45           N  
ATOM     31  CD2 HIS A   8      48.873  37.672   5.584  1.00 35.17           C  
ATOM     32  CE1 HIS A   8      48.782  39.424   6.901  1.00 37.52           C  
ATOM     33  NE2 HIS A   8      49.468  38.862   5.920  1.00 37.00           N  
ATOM     34  N   GLN A   9      46.386  35.212   3.646  0.50 22.02           N  
ATOM     36  CA  GLN A   9      46.886  34.910   2.304  0.50 20.90           C  
ATOM     38  C   GLN A   9      45.801  35.115   1.246  0.50 16.34           C  
ATOM     40  O   GLN A   9      46.100  35.535   0.130  0.50 17.29           O  
ATOM     42  CB  GLN A   9      47.461  33.501   2.245  0.50 22.39           C  
ATOM     44  CG  GLN A   9      48.639  33.304   3.206  0.50 21.60           C  
ATOM     46  CD  GLN A   9      49.720  34.377   3.043  0.50 24.12           C  
ATOM     48  OE1 GLN A   9      50.206  34.942   4.025  0.50 30.40           O  
ATOM     50  NE2 GLN A   9      50.077  34.673   1.800  0.50 23.53           N  
ATOM     52  N   VAL A  10      44.548  34.813   1.590  1.00 14.44           N  
ATOM     53  CA  VAL A  10      43.403  35.105   0.699  1.00 14.83           C  
ATOM     54  C   VAL A  10      43.345  36.624   0.370  1.00 13.83           C  
ATOM     55  O   VAL A  10      43.204  37.016  -0.813  1.00 15.07           O  
ATOM     56  CB  VAL A  10      42.058  34.687   1.333  1.00 14.71           C  
ATOM     57  CG1 VAL A  10      40.869  35.254   0.581  1.00 16.80           C  
ATOM     58  CG2 VAL A  10      41.922  33.129   1.395  1.00 16.19           C  
ATOM     59  N   VAL A  11      43.476  37.470   1.402  1.00 13.88           N  
ATOM     60  CA  VAL A  11      43.387  38.900   1.161  1.00 13.80           C  
ATOM     61  C   VAL A  11      44.562  39.410   0.308  1.00 14.14           C  
ATOM     62  O   VAL A  11      44.396  40.242  -0.615  1.00 14.83           O  
ATOM     63  CB  VAL A  11      43.227  39.720   2.464  1.00 16.22           C  
ATOM     64  CG1 VAL A  11      43.184  41.204   2.136  1.00 17.00           C  
ATOM     65  CG2 VAL A  11      41.937  39.297   3.181  1.00 17.19           C  
ATOM     66  N   LYS A  12      45.773  38.939   0.591  0.50 12.69           N  
ATOM     68  CA  LYS A  12      46.927  39.307  -0.264  0.50 13.14           C  
ATOM     70  C   LYS A  12      46.698  38.980  -1.728  0.50 14.12           C  
ATOM     72  O   LYS A  12      46.934  39.830  -2.608  0.50 13.80           O  
ATOM     74  CB  LYS A  12      48.219  38.634   0.240  0.50 14.36           C  
ATOM     76  CG  LYS A  12      48.695  39.153   1.559  0.50 13.64           C  
ATOM     78  CD  LYS A  12      49.943  38.446   2.059  0.50 16.76           C  
ATOM     80  CE  LYS A  12      51.160  38.910   1.286  0.50 24.47           C  
ATOM     82  N   ILE A  13      46.259  37.752  -1.994  0.50 14.24           N  
ATOM     84  CA  ILE A  13      45.979  37.311  -3.377  0.50 14.66           C  
ATOM     86  C   ILE A  13      44.876  38.177  -3.990  0.50 13.95           C  
ATOM     88  O   ILE A  13      44.984  38.609  -5.143  0.50 14.33           O  
ATOM     90  CB  ILE A  13      45.661  35.779  -3.443  0.50 16.27           C  
ATOM     92  CG1 ILE A  13      46.872  34.962  -2.966  0.50 19.65           C  
ATOM     94  CG2 ILE A  13      45.273  35.380  -4.851  0.50 14.40           C  
ATOM     96  CD1 ILE A  13      46.535  33.562  -2.481  0.50 17.31           C  
ATOM     98  N   ALA A  14      43.811  38.448  -3.234  1.00 14.23           N  
ATOM     99  CA  ALA A  14      42.750  39.317  -3.767  1.00 13.03           C  
ATOM    100  C   ALA A  14      43.312  40.690  -4.139  1.00 15.18           C  
ATOM    101  O   ALA A  14      42.984  41.206  -5.193  1.00 14.57           O  
ATOM    102  CB  ALA A  14      41.583  39.445  -2.780  1.00 13.40           C  
ATOM    103  N   LEU A  15      44.146  41.273  -3.260  1.00 14.08           N  
ATOM    104  CA  LEU A  15      44.797  42.544  -3.550  1.00 13.92           C  
ATOM    105  C   LEU A  15      45.685  42.462  -4.810  1.00 13.24           C  
ATOM    106  O   LEU A  15      45.651  43.313  -5.691  1.00 14.77           O  
ATOM    107  CB  LEU A  15      45.610  42.986  -2.337  1.00 15.23           C  
ATOM    108  CG  LEU A  15      44.814  43.601  -1.186  1.00 15.13           C  
ATOM    109  CD1 LEU A  15      45.736  43.624   0.051  1.00 15.31           C  
ATOM    110  CD2 LEU A  15      44.330  45.066  -1.548  1.00 14.93           C  
ATOM    111  N   GLU A  16      46.471  41.392  -4.898  1.00 12.67           N  
ATOM    112  CA  GLU A  16      47.382  41.203  -6.016  1.00 14.20           C  
ATOM    113  C   GLU A  16      46.623  41.095  -7.333  1.00 13.68           C  
ATOM    114  O   GLU A  16      47.038  41.659  -8.356  1.00 16.25           O  
ATOM    115  CB  GLU A  16      48.296  40.018  -5.748  1.00 15.60           C  
ATOM    116  CG  GLU A  16      49.305  40.367  -4.695  1.00 17.67           C  
ATOM    117  CD  GLU A  16      50.053  39.184  -4.136  1.00 24.78           C  
ATOM    118  OE1 GLU A  16      49.666  38.040  -4.358  1.00 22.99           O  
ATOM    119  OE2 GLU A  16      51.071  39.435  -3.460  1.00 25.51           O  
ATOM    120  N   LYS A  17      45.506  40.409  -7.308  1.00 14.06           N  
ATOM    121  CA  LYS A  17      44.695  40.277  -8.526  1.00 14.09           C  
ATOM    122  C   LYS A  17      44.206  41.625  -9.037  1.00 16.27           C  
ATOM    123  O   LYS A  17      43.978  41.779 -10.237  1.00 16.63           O  
ATOM    124  CB  LYS A  17      43.484  39.377  -8.319  1.00 15.06           C  
ATOM    125  CG  LYS A  17      43.828  37.926  -8.165  1.00 14.99           C  
ATOM    126  CD  LYS A  17      42.598  37.096  -7.854  1.00 16.40           C  
ATOM    127  CE  LYS A  17      42.896  35.626  -7.800  1.00 17.81           C  
ATOM    128  NZ  LYS A  17      41.654  34.861  -7.406  1.00 16.23           N  
ATOM    129  N   ASP A  18      44.000  42.586  -8.133  1.00 13.63           N  
ATOM    130  CA  ASP A  18      43.516  43.936  -8.469  1.00 12.85           C  
ATOM    131  C   ASP A  18      44.731  44.886  -8.714  1.00 14.37           C  
ATOM    132  O   ASP A  18      44.563  46.097  -8.757  1.00 14.55           O  
ATOM    133  CB  ASP A  18      42.595  44.493  -7.366  1.00 14.82           C  
ATOM    134  CG  ASP A  18      41.097  44.092  -7.543  1.00 14.35           C  
ATOM    135  OD1 ASP A  18      40.816  43.105  -8.258  1.00 15.49           O  
ATOM    136  OD2 ASP A  18      40.280  44.809  -6.939  1.00 17.49           O  
ATOM    137  N   GLY A  19      45.920  44.326  -8.799  1.00 13.57           N  
ATOM    138  CA  GLY A  19      47.104  45.080  -9.143  1.00 16.17           C  
ATOM    139  C   GLY A  19      47.764  45.845  -8.043  1.00 14.74           C  
ATOM    140  O   GLY A  19      48.613  46.716  -8.307  1.00 15.33           O  
ATOM    141  N   TRP A  20      47.445  45.472  -6.803  1.00 13.33           N  
ATOM    142  CA  TRP A  20      48.158  46.053  -5.627  1.00 15.42           C  
ATOM    143  C   TRP A  20      49.480  45.342  -5.393  1.00 16.22           C  
ATOM    144  O   TRP A  20      49.593  44.113  -5.534  1.00 16.88           O  
ATOM    145  CB  TRP A  20      47.270  45.995  -4.363  1.00 13.51           C  
ATOM    146  CG  TRP A  20      46.000  46.790  -4.479  1.00 14.07           C  
ATOM    147  CD1 TRP A  20      44.799  46.415  -5.090  1.00 14.83           C  
ATOM    148  CD2 TRP A  20      45.810  48.162  -4.051  1.00 15.64           C  
ATOM    149  NE1 TRP A  20      43.903  47.471  -5.028  1.00 14.81           N  
ATOM    150  CE2 TRP A  20      44.496  48.540  -4.417  1.00 14.03           C  
ATOM    151  CE3 TRP A  20      46.621  49.116  -3.391  1.00 15.90           C  
ATOM    152  CZ2 TRP A  20      43.989  49.807  -4.130  1.00 15.65           C  
ATOM    153  CZ3 TRP A  20      46.135  50.358  -3.144  1.00 16.67           C  
ATOM    154  CH2 TRP A  20      44.828  50.706  -3.520  1.00 16.47           C  
ATOM    155  N   GLN A  21      50.467  46.142  -5.011  0.50 12.86           N  
ATOM    157  CA  GLN A  21      51.744  45.652  -4.564  0.50 14.70           C  
ATOM    159  C   GLN A  21      51.757  45.581  -3.047  0.50 14.62           C  
ATOM    161  O   GLN A  21      51.496  46.590  -2.381  0.50 13.89           O  
ATOM    163  CB  GLN A  21      52.847  46.580  -5.053  0.50 14.82           C  
ATOM    165  CG  GLN A  21      54.235  45.962  -4.900  0.50 16.24           C  
ATOM    167  CD  GLN A  21      55.378  46.986  -4.947  0.50 19.03           C  
ATOM    169  OE1 GLN A  21      55.245  48.085  -5.507  0.50 27.73           O  
ATOM    171  NE2 GLN A  21      56.491  46.632  -4.331  0.50 24.29           N  
ATOM    173  N   ILE A  22      52.041  44.399  -2.489  1.00 15.79           N  
ATOM    174  CA  ILE A  22      52.209  44.271  -1.042  1.00 16.84           C  
ATOM    175  C   ILE A  22      53.623  44.688  -0.682  1.00 18.95           C  
ATOM    176  O   ILE A  22      54.591  44.150  -1.239  1.00 20.06           O  
ATOM    177  CB  ILE A  22      51.917  42.843  -0.512  1.00 18.67           C  
ATOM    178  CG1 ILE A  22      50.666  42.241  -1.186  1.00 30.77           C  
ATOM    179  CG2 ILE A  22      51.913  42.769   1.049  1.00 22.52           C  
ATOM    180  CD1 ILE A  22      49.432  42.930  -0.910  1.00 24.30           C  
ATOM    181  N   THR A  23      53.729  45.688   0.194  1.00 16.30           N  
ATOM    182  CA  THR A  23      55.050  46.243   0.558  1.00 17.45           C  
ATOM    183  C   THR A  23      55.528  45.898   1.963  1.00 22.58           C  
ATOM    184  O   THR A  23      56.755  45.911   2.227  1.00 24.59           O  
ATOM    185  CB  THR A  23      55.078  47.749   0.425  1.00 19.06           C  
ATOM    186  OG1 THR A  23      54.073  48.301   1.273  1.00 17.41           O  
ATOM    187  CG2 THR A  23      54.834  48.187  -1.008  1.00 18.65           C  
ATOM    188  N   ASN A  24      54.602  45.601   2.858  1.00 21.36           N  
ATOM    189  CA  ASN A  24      54.950  45.236   4.216  1.00 24.65           C  
ATOM    190  C   ASN A  24      53.890  44.263   4.718  1.00 25.37           C  
ATOM    191  O   ASN A  24      52.679  44.464   4.553  1.00 22.55           O  
ATOM    192  CB  ASN A  24      55.055  46.481   5.158  1.00 22.24           C  
ATOM    193  CG  ASN A  24      55.909  47.635   4.555  1.00 30.96           C  
ATOM    194  OD1 ASN A  24      55.402  48.510   3.795  1.00 30.50           O  
ATOM    195  ND2 ASN A  24      57.211  47.632   4.883  1.00 32.51           N  
ATOM    196  N   ASP A  25      54.344  43.176   5.309  1.00 23.55           N  
ATOM    197  CA  ASP A  25      53.428  42.229   5.899  1.00 26.98           C  
ATOM    198  C   ASP A  25      54.265  41.458   6.907  1.00 29.12           C  
ATOM    199  O   ASP A  25      55.005  40.558   6.508  1.00 31.54           O  
ATOM    200  CB  ASP A  25      52.837  41.335   4.810  1.00 27.72           C  
ATOM    201  CG  ASP A  25      51.932  40.291   5.346  1.00 37.47           C  
ATOM    202  OD1 ASP A  25      51.519  40.416   6.518  1.00 42.95           O  
ATOM    203  OD2 ASP A  25      51.659  39.329   4.594  1.00 44.18           O  
ATOM    204  N   PRO A  26      54.193  41.848   8.193  1.00 29.80           N  
ATOM    205  CA  PRO A  26      53.280  42.845   8.750  1.00 28.98           C  
ATOM    206  C   PRO A  26      53.769  44.266   8.564  1.00 26.95           C  
ATOM    207  O   PRO A  26      54.980  44.522   8.475  1.00 25.59           O  
ATOM    208  CB  PRO A  26      53.272  42.501  10.245  1.00 32.61           C  
ATOM    209  CG  PRO A  26      54.617  42.049  10.506  1.00 31.63           C  
ATOM    210  CD  PRO A  26      55.080  41.321   9.244  1.00 32.59           C  
ATOM    211  N   LEU A  27      52.819  45.195   8.521  1.00 25.29           N  
ATOM    212  CA  LEU A  27      53.138  46.604   8.657  1.00 25.79           C  
ATOM    213  C   LEU A  27      53.325  46.834  10.149  1.00 28.45           C  
ATOM    214  O   LEU A  27      52.402  46.588  10.931  1.00 29.79           O  
ATOM    215  CB  LEU A  27      51.993  47.476   8.123  1.00 24.98           C  
ATOM    216  CG  LEU A  27      52.156  48.994   8.298  1.00 28.34           C  
ATOM    217  CD1 LEU A  27      53.446  49.524   7.666  1.00 31.43           C  
ATOM    218  CD2 LEU A  27      50.926  49.613   7.708  1.00 28.17           C  
ATOM    219  N   THR A  28      54.516  47.261  10.537  1.00 28.16           N  
ATOM    220  CA  THR A  28      54.768  47.527  11.955  1.00 30.61           C  
ATOM    221  C   THR A  28      54.698  49.020  12.202  1.00 32.52           C  
ATOM    222  O   THR A  28      55.117  49.850  11.359  1.00 32.48           O  
ATOM    223  CB  THR A  28      56.082  46.885  12.468  1.00 34.05           C  
ATOM    224  OG1 THR A  28      57.189  47.308  11.657  1.00 37.71           O  
ATOM    225  CG2 THR A  28      55.945  45.367  12.430  1.00 31.04           C  
ATOM    226  N   ILE A  29      54.218  49.370  13.383  0.50 30.98           N  
ATOM    228  CA  ILE A  29      53.997  50.760  13.700  0.50 30.94           C  
ATOM    230  C   ILE A  29      54.130  50.947  15.210  0.50 29.98           C  
ATOM    232  O   ILE A  29      53.529  50.186  15.981  0.50 27.72           O  
ATOM    234  CB  ILE A  29      52.609  51.204  13.168  0.50 31.63           C  
ATOM    236  CG1 ILE A  29      52.383  52.701  13.392  0.50 33.19           C  
ATOM    238  CG2 ILE A  29      51.485  50.374  13.804  0.50 27.83           C  
ATOM    240  CD1 ILE A  29      51.252  53.249  12.551  0.50 34.60           C  
ATOM    242  N   SER A  30      54.944  51.931  15.602  1.00 28.97           N  
ATOM    243  CA  SER A  30      55.124  52.313  17.004  1.00 29.33           C  
ATOM    244  C   SER A  30      54.883  53.816  17.119  1.00 26.82           C  
ATOM    245  O   SER A  30      55.420  54.620  16.342  1.00 25.52           O  
ATOM    246  CB  SER A  30      56.509  51.944  17.533  1.00 31.71           C  
ATOM    247  OG  SER A  30      56.724  50.551  17.410  1.00 40.76           O  
ATOM    248  N   VAL A  31      54.090  54.197  18.101  0.50 25.31           N  
ATOM    250  CA  VAL A  31      53.848  55.595  18.316  0.50 24.37           C  
ATOM    252  C   VAL A  31      53.504  55.787  19.774  0.50 23.80           C  
ATOM    254  O   VAL A  31      53.012  54.869  20.448  0.50 24.32           O  
ATOM    256  CB  VAL A  31      52.714  56.121  17.402  0.50 25.04           C  
ATOM    258  CG1 VAL A  31      51.385  55.495  17.782  0.50 27.03           C  
ATOM    260  CG2 VAL A  31      52.655  57.650  17.431  0.50 27.42           C  
ATOM    262  N   GLY A  32      53.802  56.986  20.258  1.00 18.74           N  
ATOM    263  CA  GLY A  32      53.420  57.397  21.592  1.00 19.31           C  
ATOM    264  C   GLY A  32      53.702  56.378  22.691  1.00 20.02           C  
ATOM    265  O   GLY A  32      52.908  56.225  23.605  1.00 19.39           O  
ATOM    266  N   GLY A  33      54.850  55.711  22.591  1.00 20.20           N  
ATOM    267  CA  GLY A  33      55.315  54.811  23.673  1.00 22.68           C  
ATOM    268  C   GLY A  33      54.800  53.384  23.583  1.00 24.12           C  
ATOM    269  O   GLY A  33      55.071  52.583  24.494  1.00 26.48           O  
ATOM    270  N   VAL A  34      54.045  53.075  22.512  1.00 23.21           N  
ATOM    271  CA  VAL A  34      53.457  51.747  22.297  1.00 23.79           C  
ATOM    272  C   VAL A  34      53.858  51.164  20.951  1.00 27.03           C  
ATOM    273  O   VAL A  34      53.802  51.858  19.951  1.00 26.43           O  
ATOM    274  CB  VAL A  34      51.895  51.874  22.354  1.00 24.73           C  
ATOM    275  CG1 VAL A  34      51.230  50.557  22.022  1.00 26.45           C  
ATOM    276  CG2 VAL A  34      51.453  52.391  23.732  1.00 23.17           C  
ATOM    277  N   ASN A  35      54.227  49.882  20.918  1.00 30.30           N  
ATOM    278  CA  ASN A  35      54.372  49.153  19.650  1.00 33.41           C  
ATOM    279  C   ASN A  35      53.090  48.399  19.325  1.00 35.00           C  
ATOM    280  O   ASN A  35      52.712  47.478  20.029  1.00 37.78           O  
ATOM    281  CB  ASN A  35      55.533  48.156  19.664  1.00 37.15           C  
ATOM    282  CG  ASN A  35      55.467  47.158  18.481  1.00 40.75           C  
ATOM    283  OD1 ASN A  35      55.671  45.951  18.659  1.00 62.69           O  
ATOM    284  ND2 ASN A  35      55.170  47.658  17.286  1.00 39.83           N  
ATOM    285  N   LEU A  36      52.471  48.776  18.244  0.00 35.18           N  
ATOM    287  CA  LEU A  36      51.188  48.279  17.885  0.00 37.60           C  
ATOM    289  C   LEU A  36      51.424  47.071  16.996  0.00 39.79           C  
ATOM    291  O   LEU A  36      52.570  46.734  16.734  0.00 47.59           O  
ATOM    293  CB  LEU A  36      50.433  49.333  17.130  0.00 35.59           C  
ATOM    295  CG  LEU A  36      49.712  50.334  17.988  0.00 34.89           C  
ATOM    297  CD1 LEU A  36      50.505  51.564  18.003  0.00 35.88           C  
ATOM    299  CD2 LEU A  36      48.397  50.670  17.363  0.00 29.93           C  
ATOM    301  N   LYS A  44      50.298  42.075  11.853  1.00 37.14           N  
ATOM    302  CA  LYS A  44      49.353  41.379  10.994  1.00 37.54           C  
ATOM    303  C   LYS A  44      48.712  42.322   9.920  1.00 35.78           C  
ATOM    304  O   LYS A  44      48.124  41.823   8.934  1.00 35.91           O  
ATOM    305  CB  LYS A  44      48.288  40.724  11.890  1.00 39.18           C  
ATOM    306  CG  LYS A  44      47.385  39.756  11.175  1.00 46.62           C  
ATOM    307  CD  LYS A  44      46.575  38.894  12.137  1.00 41.60           C  
ATOM    308  N   LEU A  45      48.835  43.652  10.098  1.00 32.41           N  
ATOM    309  CA  LEU A  45      48.370  44.634   9.101  1.00 28.65           C  
ATOM    310  C   LEU A  45      49.137  44.432   7.796  1.00 23.69           C  
ATOM    311  O   LEU A  45      50.364  44.209   7.829  1.00 24.43           O  
ATOM    312  CB  LEU A  45      48.636  46.069   9.567  1.00 27.50           C  
ATOM    313  CG  LEU A  45      47.747  46.726  10.589  1.00 32.35           C  
ATOM    314  CD1 LEU A  45      48.256  48.128  10.895  1.00 29.05           C  
ATOM    315  CD2 LEU A  45      46.359  46.784  10.021  1.00 24.25           C  
ATOM    316  N   ILE A  46      48.444  44.478   6.662  1.00 20.35           N  
ATOM    317  CA  ILE A  46      49.080  44.387   5.333  1.00 19.45           C  
ATOM    318  C   ILE A  46      49.238  45.830   4.798  1.00 18.26           C  
ATOM    319  O   ILE A  46      48.269  46.602   4.809  1.00 19.83           O  
ATOM    320  CB  ILE A  46      48.222  43.625   4.362  1.00 16.96           C  
ATOM    321  CG1 ILE A  46      48.063  42.173   4.851  1.00 22.80           C  
ATOM    322  CG2 ILE A  46      48.837  43.700   2.902  1.00 23.66           C  
ATOM    323  CD1 ILE A  46      47.128  41.354   3.954  1.00 23.74           C  
ATOM    324  N   ALA A  47      50.441  46.199   4.367  1.00 16.29           N  
ATOM    325  CA  ALA A  47      50.651  47.477   3.675  1.00 15.81           C  
ATOM    326  C   ALA A  47      50.718  47.182   2.179  1.00 15.27           C  
ATOM    327  O   ALA A  47      51.453  46.290   1.761  1.00 16.87           O  
ATOM    328  CB  ALA A  47      51.982  48.155   4.100  1.00 17.18           C  
ATOM    329  N   ALA A  48      49.981  47.959   1.380  1.00 14.20           N  
ATOM    330  CA  ALA A  48      49.991  47.780  -0.048  1.00 14.55           C  
ATOM    331  C   ALA A  48      49.914  49.132  -0.741  1.00 14.02           C  
ATOM    332  O   ALA A  48      49.505  50.143  -0.124  1.00 14.16           O  
ATOM    333  CB  ALA A  48      48.832  46.893  -0.468  1.00 15.47           C  
ATOM    334  N   GLU A  49      50.274  49.147  -2.031  1.00 14.64           N  
ATOM    335  CA  GLU A  49      50.146  50.390  -2.799  1.00 14.14           C  
ATOM    336  C   GLU A  49      49.901  50.063  -4.261  1.00 15.58           C  
ATOM    337  O   GLU A  49      50.198  48.959  -4.737  1.00 16.11           O  
ATOM    338  CB  GLU A  49      51.360  51.294  -2.636  1.00 17.86           C  
ATOM    339  CG  GLU A  49      52.611  50.702  -3.125  1.00 17.43           C  
ATOM    340  CD  GLU A  49      53.779  51.656  -2.878  1.00 25.52           C  
ATOM    341  OE1 GLU A  49      54.177  51.800  -1.712  1.00 23.69           O  
ATOM    342  OE2 GLU A  49      54.237  52.298  -3.848  1.00 32.79           O  
ATOM    343  N   ARG A  50      49.371  51.053  -4.969  1.00 14.49           N  
ATOM    344  CA  ARG A  50      49.053  50.884  -6.367  1.00 15.35           C  
ATOM    345  C   ARG A  50      49.057  52.241  -7.007  1.00 17.76           C  
ATOM    346  O   ARG A  50      48.258  53.109  -6.624  1.00 19.47           O  
ATOM    347  CB  ARG A  50      47.697  50.212  -6.534  1.00 15.24           C  
ATOM    348  CG  ARG A  50      47.339  49.858  -7.945  1.00 17.78           C  
ATOM    349  CD  ARG A  50      45.978  49.159  -8.032  1.00 15.92           C  
ATOM    350  NE  ARG A  50      44.893  50.066  -7.657  1.00 15.93           N  
ATOM    351  CZ  ARG A  50      43.615  49.791  -7.852  1.00 17.40           C  
ATOM    352  NH1 ARG A  50      43.255  48.601  -8.365  1.00 15.92           N  
ATOM    353  NH2 ARG A  50      42.709  50.694  -7.518  1.00 18.36           N  
ATOM    354  N   GLU A  51      49.953  52.431  -7.973  0.50 19.05           N  
ATOM    356  CA  GLU A  51      50.194  53.748  -8.568  0.50 18.91           C  
ATOM    358  C   GLU A  51      50.205  54.871  -7.548  0.50 21.04           C  
ATOM    360  O   GLU A  51      49.514  55.881  -7.687  0.50 23.76           O  
ATOM    362  CB  GLU A  51      49.177  54.054  -9.644  0.50 22.85           C  
ATOM    364  CG  GLU A  51      49.267  53.110 -10.831  0.50 20.36           C  
ATOM    366  CD  GLU A  51      48.209  52.047 -10.803  0.50 20.44           C  
ATOM    368  OE1 GLU A  51      47.149  52.299 -10.189  0.50 26.04           O  
ATOM    370  OE2 GLU A  51      48.429  51.001 -11.433  0.50 15.76           O  
ATOM    372  N   GLY A  52      51.001  54.696  -6.511  1.00 21.88           N  
ATOM    373  CA  GLY A  52      51.146  55.770  -5.517  1.00 22.92           C  
ATOM    374  C   GLY A  52      50.030  55.943  -4.472  1.00 22.77           C  
ATOM    375  O   GLY A  52      50.197  56.707  -3.522  1.00 24.13           O  
ATOM    376  N   GLU A  53      48.908  55.258  -4.634  1.00 17.53           N  
ATOM    377  CA  GLU A  53      47.833  55.188  -3.611  1.00 20.54           C  
ATOM    378  C   GLU A  53      48.300  54.148  -2.587  1.00 15.65           C  
ATOM    379  O   GLU A  53      48.587  52.999  -2.961  1.00 17.90           O  
ATOM    380  CB  GLU A  53      46.518  54.746  -4.265  1.00 23.39           C  
ATOM    381  CG  GLU A  53      45.360  54.715  -3.275  1.00 31.16           C  
ATOM    382  CD  GLU A  53      43.965  54.342  -3.831  1.00 34.74           C  
ATOM    383  OE1 GLU A  53      43.772  54.086  -5.068  1.00 35.79           O  
ATOM    384  OE2 GLU A  53      43.055  54.287  -2.950  1.00 34.41           O  
ATOM    385  N   LYS A  54      48.394  54.538  -1.318  1.00 16.43           N  
ATOM    386  CA  LYS A  54      48.867  53.673  -0.255  1.00 14.61           C  
ATOM    387  C   LYS A  54      47.687  53.269   0.644  1.00 15.48           C  
ATOM    388  O   LYS A  54      46.860  54.139   1.052  1.00 16.22           O  
ATOM    389  CB  LYS A  54      49.928  54.432   0.588  1.00 15.46           C  
ATOM    390  CG  LYS A  54      51.198  54.675  -0.213  1.00 18.44           C  
ATOM    391  CD  LYS A  54      52.257  55.422   0.586  1.00 23.48           C  
ATOM    392  CE  LYS A  54      53.576  55.452  -0.201  1.00 36.84           C  
ATOM    393  N   ILE A  55      47.654  52.005   1.014  1.00 14.77           N  
ATOM    394  CA  ILE A  55      46.651  51.532   1.959  1.00 13.94           C  
ATOM    395  C   ILE A  55      47.258  50.607   3.016  1.00 13.06           C  
ATOM    396  O   ILE A  55      48.386  50.074   2.867  1.00 14.33           O  
ATOM    397  CB  ILE A  55      45.487  50.756   1.247  1.00 13.99           C  
ATOM    398  CG1 ILE A  55      46.023  49.454   0.605  1.00 15.34           C  
ATOM    399  CG2 ILE A  55      44.838  51.655   0.154  1.00 16.17           C  
ATOM    400  CD1 ILE A  55      44.908  48.566  -0.077  1.00 14.39           C  
ATOM    401  N   ALA A  56      46.481  50.410   4.084  1.00 14.18           N  
ATOM    402  CA  ALA A  56      46.767  49.402   5.096  1.00 14.01           C  
ATOM    403  C   ALA A  56      45.505  48.608   5.300  1.00 14.76           C  
ATOM    404  O   ALA A  56      44.423  49.159   5.234  1.00 14.83           O  
ATOM    405  CB  ALA A  56      47.198  50.043   6.468  1.00 15.39           C  
ATOM    406  N   VAL A  57      45.676  47.306   5.504  1.00 15.25           N  
ATOM    407  CA  VAL A  57      44.518  46.396   5.610  1.00 14.39           C  
ATOM    408  C   VAL A  57      44.600  45.542   6.863  1.00 14.54           C  
ATOM    409  O   VAL A  57      45.546  44.779   7.036  1.00 15.48           O  
ATOM    410  CB  VAL A  57      44.356  45.485   4.337  1.00 15.68           C  
ATOM    411  CG1 VAL A  57      43.048  44.640   4.487  1.00 13.94           C  
ATOM    412  CG2 VAL A  57      44.330  46.349   3.056  1.00 15.59           C  
ATOM    413  N   GLU A  58      43.579  45.689   7.717  1.00 15.43           N  
ATOM    414  CA  GLU A  58      43.365  44.869   8.922  1.00 14.08           C  
ATOM    415  C   GLU A  58      42.503  43.692   8.517  1.00 14.56           C  
ATOM    416  O   GLU A  58      41.319  43.880   8.205  1.00 15.17           O  
ATOM    417  CB  GLU A  58      42.643  45.756   9.970  1.00 15.52           C  
ATOM    418  CG  GLU A  58      42.125  44.998  11.143  1.00 15.17           C  
ATOM    419  CD  GLU A  58      41.284  45.838  12.085  1.00 15.24           C  
ATOM    420  OE1 GLU A  58      41.281  47.080  11.925  1.00 18.45           O  
ATOM    421  OE2 GLU A  58      40.606  45.202  12.970  1.00 14.91           O  
ATOM    422  N   VAL A  59      43.087  42.503   8.465  1.00 16.04           N  
ATOM    423  CA  VAL A  59      42.364  41.309   7.971  1.00 17.46           C  
ATOM    424  C   VAL A  59      41.687  40.603   9.106  1.00 21.27           C  
ATOM    425  O   VAL A  59      42.342  40.223  10.080  1.00 19.05           O  
ATOM    426  CB  VAL A  59      43.294  40.344   7.252  1.00 19.77           C  
ATOM    427  CG1 VAL A  59      42.468  39.131   6.773  1.00 19.06           C  
ATOM    428  CG2 VAL A  59      43.962  41.054   6.060  1.00 18.93           C  
ATOM    429  N   LYS A  60      40.380  40.367   8.945  1.00 22.06           N  
ATOM    430  CA  LYS A  60      39.575  39.555   9.876  1.00 20.47           C  
ATOM    431  C   LYS A  60      38.844  38.453   9.088  1.00 19.29           C  
ATOM    432  O   LYS A  60      38.463  38.650   7.894  1.00 20.76           O  
ATOM    433  CB  LYS A  60      38.596  40.437  10.655  1.00 24.53           C  
ATOM    434  CG  LYS A  60      39.323  41.467  11.527  1.00 21.32           C  
ATOM    435  CD  LYS A  60      40.077  40.771  12.652  1.00 25.89           C  
ATOM    436  CE  LYS A  60      40.724  41.722  13.612  1.00 24.15           C  
ATOM    437  NZ  LYS A  60      41.357  41.003  14.776  1.00 25.84           N  
ATOM    438  N   SER A  61      38.757  37.276   9.694  1.00 22.51           N  
ATOM    439  CA  SER A  61      38.030  36.172   9.113  1.00 22.63           C  
ATOM    440  C   SER A  61      36.643  36.035   9.725  1.00 24.86           C  
ATOM    441  O   SER A  61      35.754  35.412   9.134  1.00 24.66           O  
ATOM    442  CB  SER A  61      38.789  34.887   9.367  1.00 26.46           C  
ATOM    443  OG  SER A  61      38.794  34.636  10.758  1.00 26.70           O  
ATOM    444  N   PHE A  62      36.484  36.592  10.930  1.00 22.09           N  
ATOM    445  CA  PHE A  62      35.274  36.452  11.738  1.00 24.56           C  
ATOM    446  C   PHE A  62      34.988  34.984  12.069  1.00 31.35           C  
ATOM    447  O   PHE A  62      33.838  34.577  12.213  1.00 38.98           O  
ATOM    448  CB  PHE A  62      34.084  37.244  11.141  1.00 23.00           C  
ATOM    449  CG  PHE A  62      34.101  38.702  11.520  1.00 25.11           C  
ATOM    450  CD1 PHE A  62      34.953  39.566  10.862  1.00 24.28           C  
ATOM    451  CD2 PHE A  62      33.332  39.185  12.593  1.00 26.36           C  
ATOM    452  CE1 PHE A  62      35.041  40.925  11.219  1.00 25.74           C  
ATOM    453  CE2 PHE A  62      33.405  40.524  12.958  1.00 28.07           C  
ATOM    454  CZ  PHE A  62      34.257  41.385  12.288  1.00 24.98           C  
ATOM    455  N   LEU A  63      36.072  34.218  12.203  1.00 30.52           N  
ATOM    456  CA  LEU A  63      36.083  32.901  12.837  1.00 35.04           C  
ATOM    457  C   LEU A  63      37.038  32.932  14.066  1.00 37.49           C  
ATOM    458  O   LEU A  63      37.279  31.900  14.697  1.00 36.56           O  
ATOM    459  CB  LEU A  63      36.578  31.871  11.835  1.00 34.39           C  
ATOM    460  CG  LEU A  63      35.749  31.714  10.547  1.00 37.51           C  
ATOM    461  N   GLU A  64      37.555  34.128  14.408  1.00 39.74           N  
ATOM    462  CA  GLU A  64      38.620  34.300  15.442  1.00 39.83           C  
ATOM    463  C   GLU A  64      38.164  33.989  16.856  1.00 43.07           C  
ATOM    464  O   GLU A  64      38.958  33.554  17.719  1.00 42.53           O  
ATOM    465  CB  GLU A  64      39.145  35.749  15.477  1.00 38.34           C  
ATOM    466  CG  GLU A  64      40.052  36.142  14.311  1.00 37.89           C  
ATOM    467  CD  GLU A  64      39.314  36.795  13.156  1.00 37.41           C  
ATOM    468  OE1 GLU A  64      38.062  36.940  13.215  1.00 30.72           O  
ATOM    469  OE2 GLU A  64      40.012  37.152  12.177  1.00 31.07           O  
ATOM    470  N   ARG A  65      36.901  34.291  17.123  1.00 45.09           N  
ATOM    471  CA  ARG A  65      36.362  34.054  18.435  1.00 46.52           C  
ATOM    472  C   ARG A  65      35.159  33.158  18.358  1.00 47.21           C  
ATOM    473  O   ARG A  65      34.794  32.579  17.319  1.00 48.54           O  
ATOM    474  CB  ARG A  65      35.988  35.372  19.149  1.00 46.67           C  
ATOM    475  CG  ARG A  65      37.130  36.386  19.248  1.00 45.76           C  
ATOM    476  CD  ARG A  65      36.891  37.441  20.320  1.00 46.17           C  
ATOM    477  N   SER A  66      34.656  32.946  19.551  1.00 47.63           N  
ATOM    478  CA  SER A  66      33.267  33.023  19.835  1.00 45.48           C  
ATOM    479  C   SER A  66      32.540  33.775  18.687  1.00 40.55           C  
ATOM    480  O   SER A  66      32.881  33.706  17.498  1.00 42.36           O  
ATOM    481  CB  SER A  66      33.162  33.783  21.201  1.00 46.76           C  
ATOM    482  OG  SER A  66      31.852  33.886  21.737  1.00 47.66           O  
ATOM    483  N   SER A  67      31.535  34.503  19.087  1.00 34.91           N  
ATOM    484  CA  SER A  67      30.592  35.103  18.216  1.00 29.98           C  
ATOM    485  C   SER A  67      31.210  36.158  17.309  1.00 27.25           C  
ATOM    486  O   SER A  67      32.303  36.698  17.606  1.00 23.28           O  
ATOM    487  CB  SER A  67      29.632  35.806  19.152  1.00 28.73           C  
ATOM    488  OG  SER A  67      30.411  36.609  20.023  1.00 26.23           O  
ATOM    489  N   ALA A  68      30.466  36.496  16.256  1.00 22.86           N  
ATOM    490  CA  ALA A  68      30.767  37.656  15.458  1.00 20.57           C  
ATOM    491  C   ALA A  68      30.837  38.931  16.306  1.00 17.39           C  
ATOM    492  O   ALA A  68      31.709  39.762  16.081  1.00 19.32           O  
ATOM    493  CB  ALA A  68      29.753  37.844  14.325  1.00 22.21           C  
ATOM    494  N   ILE A  69      29.919  39.112  17.247  1.00 18.00           N  
ATOM    495  CA  ILE A  69      29.942  40.377  18.010  1.00 17.33           C  
ATOM    496  C   ILE A  69      31.231  40.521  18.827  1.00 18.69           C  
ATOM    497  O   ILE A  69      31.831  41.598  18.915  1.00 19.06           O  
ATOM    498  CB  ILE A  69      28.672  40.548  18.872  1.00 20.45           C  
ATOM    499  CG1 ILE A  69      28.659  41.915  19.545  1.00 22.31           C  
ATOM    500  CG2 ILE A  69      28.535  39.415  19.930  1.00 21.27           C  
ATOM    501  CD1 ILE A  69      28.768  43.126  18.560  1.00 19.47           C  
ATOM    502  N   SER A  70      31.675  39.412  19.423  0.50 18.36           N  
ATOM    504  CA  SER A  70      32.913  39.455  20.196  0.50 17.21           C  
ATOM    506  C   SER A  70      34.071  39.822  19.304  0.50 15.38           C  
ATOM    508  O   SER A  70      34.916  40.661  19.666  0.50 16.83           O  
ATOM    510  CB  SER A  70      33.227  38.113  20.864  0.50 17.35           C  
ATOM    512  OG  SER A  70      34.419  38.238  21.626  0.50 20.94           O  
ATOM    514  N   GLU A  71      34.133  39.217  18.120  0.50 15.25           N  
ATOM    516  CA  GLU A  71      35.229  39.571  17.235  0.50 14.65           C  
ATOM    518  C   GLU A  71      35.088  41.022  16.831  0.50 15.10           C  
ATOM    520  O   GLU A  71      36.099  41.741  16.755  0.50 14.77           O  
ATOM    522  CB  GLU A  71      35.341  38.680  15.988  0.50 14.14           C  
ATOM    524  CG  GLU A  71      36.453  39.092  15.055  0.50 16.89           C  
ATOM    526  CD  GLU A  71      37.788  39.301  15.774  0.50 19.92           C  
ATOM    528  OE1 GLU A  71      38.095  38.535  16.719  0.50 19.62           O  
ATOM    530  OE2 GLU A  71      38.527  40.225  15.410  0.50 18.16           O  
ATOM    532  N   PHE A  72      33.849  41.474  16.596  1.00 14.99           N  
ATOM    533  CA  PHE A  72      33.640  42.847  16.128  1.00 14.86           C  
ATOM    534  C   PHE A  72      34.193  43.842  17.152  1.00 12.91           C  
ATOM    535  O   PHE A  72      34.776  44.860  16.780  1.00 15.66           O  
ATOM    536  CB  PHE A  72      32.180  43.130  15.813  1.00 15.38           C  
ATOM    537  CG  PHE A  72      31.934  44.521  15.305  1.00 16.18           C  
ATOM    538  CD1 PHE A  72      32.590  45.012  14.188  1.00 18.61           C  
ATOM    539  CD2 PHE A  72      30.998  45.325  15.946  1.00 18.88           C  
ATOM    540  CE1 PHE A  72      32.311  46.327  13.753  1.00 18.33           C  
ATOM    541  CE2 PHE A  72      30.728  46.634  15.498  1.00 17.05           C  
ATOM    542  CZ  PHE A  72      31.364  47.092  14.390  1.00 14.86           C  
ATOM    543  N   HIS A  73      34.007  43.581  18.433  1.00 14.58           N  
ATOM    544  CA  HIS A  73      34.549  44.500  19.418  1.00 14.64           C  
ATOM    545  C   HIS A  73      36.067  44.696  19.241  1.00 16.06           C  
ATOM    546  O   HIS A  73      36.574  45.830  19.204  1.00 14.37           O  
ATOM    547  CB  HIS A  73      34.366  44.000  20.850  1.00 15.42           C  
ATOM    548  CG  HIS A  73      32.957  43.870  21.293  1.00 15.58           C  
ATOM    549  ND1 HIS A  73      32.017  44.847  21.081  1.00 16.77           N  
ATOM    550  CD2 HIS A  73      32.353  42.901  22.031  1.00 16.35           C  
ATOM    551  CE1 HIS A  73      30.869  44.458  21.627  1.00 23.16           C  
ATOM    552  NE2 HIS A  73      31.045  43.273  22.200  1.00 19.40           N  
ATOM    553  N   THR A  74      36.798  43.579  19.129  1.00 14.94           N  
ATOM    554  CA  THR A  74      38.254  43.645  18.979  1.00 13.88           C  
ATOM    555  C   THR A  74      38.614  44.242  17.635  1.00 15.68           C  
ATOM    556  O   THR A  74      39.519  45.070  17.547  1.00 16.13           O  
ATOM    557  CB  THR A  74      38.848  42.241  19.150  1.00 13.56           C  
ATOM    558  OG1 THR A  74      38.577  41.793  20.496  1.00 17.64           O  
ATOM    559  CG2 THR A  74      40.362  42.157  18.811  1.00 17.64           C  
ATOM    560  N   ALA A  75      37.898  43.854  16.577  1.00 15.43           N  
ATOM    561  CA  ALA A  75      38.196  44.386  15.251  1.00 16.56           C  
ATOM    562  C   ALA A  75      38.033  45.899  15.193  1.00 15.53           C  
ATOM    563  O   ALA A  75      38.809  46.612  14.546  1.00 15.34           O  
ATOM    564  CB  ALA A  75      37.320  43.726  14.146  1.00 16.87           C  
ATOM    565  N   LEU A  76      36.980  46.380  15.831  1.00 14.10           N  
ATOM    566  CA  LEU A  76      36.674  47.819  15.856  1.00 14.75           C  
ATOM    567  C   LEU A  76      37.717  48.577  16.672  1.00 14.60           C  
ATOM    568  O   LEU A  76      38.199  49.634  16.274  1.00 15.10           O  
ATOM    569  CB  LEU A  76      35.275  48.032  16.426  1.00 14.90           C  
ATOM    570  CG  LEU A  76      34.849  49.489  16.552  1.00 14.01           C  
ATOM    571  CD1 LEU A  76      34.807  50.152  15.113  1.00 17.04           C  
ATOM    572  CD2 LEU A  76      33.430  49.592  17.217  1.00 14.84           C  
ATOM    573  N   GLY A  77      38.048  48.067  17.847  1.00 13.35           N  
ATOM    574  CA  GLY A  77      39.068  48.747  18.694  1.00 13.10           C  
ATOM    575  C   GLY A  77      40.409  48.809  17.975  1.00 13.18           C  
ATOM    576  O   GLY A  77      41.108  49.850  17.976  1.00 14.20           O  
ATOM    577  N   GLN A  78      40.823  47.676  17.397  1.00 13.34           N  
ATOM    578  CA  GLN A  78      42.032  47.650  16.597  1.00 14.77           C  
ATOM    579  C   GLN A  78      41.960  48.656  15.469  1.00 13.95           C  
ATOM    580  O   GLN A  78      42.928  49.393  15.171  1.00 14.64           O  
ATOM    581  CB  GLN A  78      42.262  46.232  16.037  1.00 14.90           C  
ATOM    582  CG  GLN A  78      42.788  45.269  17.071  1.00 15.09           C  
ATOM    583  CD  GLN A  78      42.898  43.853  16.603  1.00 20.33           C  
ATOM    584  OE1 GLN A  78      42.258  43.466  15.634  1.00 23.31           O  
ATOM    585  NE2 GLN A  78      43.589  43.034  17.398  1.00 24.87           N  
ATOM    586  N   PHE A  79      40.821  48.694  14.792  1.00 13.15           N  
ATOM    587  CA  PHE A  79      40.680  49.615  13.661  1.00 15.14           C  
ATOM    588  C   PHE A  79      40.924  51.071  14.114  1.00 15.51           C  
ATOM    589  O   PHE A  79      41.706  51.853  13.521  1.00 14.62           O  
ATOM    590  CB  PHE A  79      39.307  49.489  12.982  1.00 15.67           C  
ATOM    591  CG  PHE A  79      39.179  50.390  11.797  1.00 13.44           C  
ATOM    592  CD1 PHE A  79      39.578  49.973  10.514  1.00 14.86           C  
ATOM    593  CD2 PHE A  79      38.661  51.677  11.911  1.00 15.53           C  
ATOM    594  CE1 PHE A  79      39.483  50.815   9.435  1.00 14.98           C  
ATOM    595  CE2 PHE A  79      38.583  52.525  10.794  1.00 16.37           C  
ATOM    596  CZ  PHE A  79      38.994  52.093   9.561  1.00 15.18           C  
ATOM    597  N   ILE A  80      40.277  51.433  15.221  1.00 13.83           N  
ATOM    598  CA  ILE A  80      40.360  52.815  15.720  1.00 14.94           C  
ATOM    599  C   ILE A  80      41.805  53.144  16.110  1.00 13.44           C  
ATOM    600  O   ILE A  80      42.361  54.239  15.816  1.00 14.31           O  
ATOM    601  CB  ILE A  80      39.329  53.023  16.863  1.00 15.84           C  
ATOM    602  CG1 ILE A  80      37.920  53.055  16.247  1.00 17.69           C  
ATOM    603  CG2 ILE A  80      39.600  54.335  17.673  1.00 14.91           C  
ATOM    604  CD1 ILE A  80      36.821  52.927  17.244  1.00 24.47           C  
ATOM    605  N   ASN A  81      42.424  52.203  16.829  1.00 13.85           N  
ATOM    606  CA  ASN A  81      43.783  52.465  17.302  1.00 13.67           C  
ATOM    607  C   ASN A  81      44.798  52.473  16.163  1.00 14.95           C  
ATOM    608  O   ASN A  81      45.672  53.367  16.128  1.00 15.19           O  
ATOM    609  CB  ASN A  81      44.154  51.464  18.380  1.00 14.09           C  
ATOM    610  CG  ASN A  81      43.524  51.773  19.710  1.00 15.23           C  
ATOM    611  OD1 ASN A  81      43.248  52.925  20.026  1.00 15.56           O  
ATOM    612  ND2 ASN A  81      43.336  50.724  20.529  1.00 16.19           N  
ATOM    613  N   TYR A  82      44.693  51.507  15.235  1.00 13.47           N  
ATOM    614  CA  TYR A  82      45.616  51.516  14.118  1.00 14.24           C  
ATOM    615  C   TYR A  82      45.420  52.784  13.278  1.00 14.15           C  
ATOM    616  O   TYR A  82      46.384  53.342  12.770  1.00 14.99           O  
ATOM    617  CB  TYR A  82      45.465  50.260  13.243  1.00 14.26           C  
ATOM    618  CG  TYR A  82      45.789  48.941  13.919  1.00 16.82           C  
ATOM    619  CD1 TYR A  82      46.764  48.847  14.888  1.00 26.66           C  
ATOM    620  CD2 TYR A  82      45.137  47.770  13.499  1.00 21.04           C  
ATOM    621  CE1 TYR A  82      47.059  47.617  15.510  1.00 30.19           C  
ATOM    622  CE2 TYR A  82      45.423  46.534  14.116  1.00 23.77           C  
ATOM    623  CZ  TYR A  82      46.399  46.480  15.095  1.00 26.20           C  
ATOM    624  OH  TYR A  82      46.704  45.266  15.707  1.00 36.40           O  
ATOM    625  N   ARG A  83      44.177  53.201  13.091  1.00 12.82           N  
ATOM    626  CA  ARG A  83      43.888  54.377  12.278  1.00 12.52           C  
ATOM    627  C   ARG A  83      44.544  55.593  12.942  1.00 14.27           C  
ATOM    628  O   ARG A  83      45.186  56.422  12.277  1.00 13.93           O  
ATOM    629  CB  ARG A  83      42.405  54.579  12.163  1.00 12.37           C  
ATOM    630  CG  ARG A  83      42.092  55.810  11.336  1.00 14.18           C  
ATOM    631  CD  ARG A  83      40.538  56.019  11.142  1.00 16.02           C  
ATOM    632  NE  ARG A  83      39.857  56.167  12.412  1.00 14.29           N  
ATOM    633  CZ  ARG A  83      38.545  56.087  12.556  1.00 15.91           C  
ATOM    634  NH1 ARG A  83      37.776  55.994  11.487  1.00 15.65           N  
ATOM    635  NH2 ARG A  83      38.015  56.139  13.752  1.00 17.28           N  
ATOM    636  N   GLY A  84      44.398  55.716  14.261  1.00 13.84           N  
ATOM    637  CA  GLY A  84      45.047  56.834  14.989  1.00 12.15           C  
ATOM    638  C   GLY A  84      46.547  56.854  14.893  1.00 15.76           C  
ATOM    639  O   GLY A  84      47.159  57.891  14.632  1.00 16.60           O  
ATOM    640  N   ALA A  85      47.149  55.670  15.066  1.00 13.27           N  
ATOM    641  CA  ALA A  85      48.601  55.509  14.944  1.00 15.46           C  
ATOM    642  C   ALA A  85      49.071  55.879  13.548  1.00 14.74           C  
ATOM    643  O   ALA A  85      50.014  56.633  13.371  1.00 13.38           O  
ATOM    644  CB  ALA A  85      49.020  54.100  15.268  1.00 14.85           C  
ATOM    645  N   LEU A  86      48.352  55.408  12.539  1.00 13.24           N  
ATOM    646  CA  LEU A  86      48.747  55.648  11.141  1.00 12.53           C  
ATOM    647  C   LEU A  86      48.652  57.131  10.769  1.00 12.40           C  
ATOM    648  O   LEU A  86      49.470  57.639   9.967  1.00 13.45           O  
ATOM    649  CB  LEU A  86      47.982  54.779  10.166  1.00 15.66           C  
ATOM    650  CG  LEU A  86      48.444  53.353  10.151  1.00 16.50           C  
ATOM    651  CD1 LEU A  86      47.367  52.415   9.462  1.00 19.08           C  
ATOM    652  CD2 LEU A  86      49.820  53.234   9.331  1.00 18.19           C  
ATOM    653  N   ARG A  87      47.699  57.849  11.344  0.50 12.46           N  
ATOM    655  CA  ARG A  87      47.639  59.284  11.072  0.50 13.60           C  
ATOM    657  C   ARG A  87      48.964  59.961  11.389  0.50 13.84           C  
ATOM    659  O   ARG A  87      49.409  60.859  10.676  0.50 12.46           O  
ATOM    661  CB  ARG A  87      46.586  59.960  11.898  0.50 16.69           C  
ATOM    663  CG  ARG A  87      45.203  59.619  11.538  0.50 19.44           C  
ATOM    665  CD  ARG A  87      44.326  60.679  12.126  0.50 27.27           C  
ATOM    667  NE  ARG A  87      43.068  60.198  12.634  0.50 33.80           N  
ATOM    669  CZ  ARG A  87      42.166  59.491  11.957  0.50 30.60           C  
ATOM    671  NH1 ARG A  87      42.344  59.084  10.675  0.50 30.96           N  
ATOM    673  NH2 ARG A  87      41.060  59.175  12.611  0.50 19.46           N  
ATOM    675  N   ARG A  88      49.565  59.544  12.503  0.50 13.04           N  
ATOM    677  CA  ARG A  88      50.747  60.203  13.051  0.50 12.16           C  
ATOM    679  C   ARG A  88      52.067  59.706  12.455  0.50 13.82           C  
ATOM    681  O   ARG A  88      53.137  60.237  12.777  0.50 15.67           O  
ATOM    683  CB  ARG A  88      50.784  59.987  14.559  0.50 13.80           C  
ATOM    685  CG  ARG A  88      49.532  60.471  15.286  0.50 14.25           C  
ATOM    687  CD  ARG A  88      49.186  61.938  15.012  0.50 15.64           C  
ATOM    689  NE  ARG A  88      48.017  62.375  15.792  0.50 10.25           N  
ATOM    691  CZ  ARG A  88      48.056  62.824  17.045  0.50  9.51           C  
ATOM    693  NH1 ARG A  88      49.202  62.899  17.713  0.50 14.62           N  
ATOM    695  NH2 ARG A  88      46.939  63.186  17.662  0.50  9.97           N  
ATOM    697  N   ARG A  89      51.986  58.693  11.609  1.00 15.53           N  
ATOM    698  CA  ARG A  89      53.182  58.106  10.984  1.00 14.70           C  
ATOM    699  C   ARG A  89      53.127  58.098   9.460  1.00 15.79           C  
ATOM    700  O   ARG A  89      54.131  58.448   8.808  1.00 15.40           O  
ATOM    701  CB  ARG A  89      53.323  56.659  11.446  1.00 17.40           C  
ATOM    702  CG  ARG A  89      53.703  56.496  12.859  1.00 19.77           C  
ATOM    703  CD  ARG A  89      55.082  57.056  13.068  1.00 23.60           C  
ATOM    704  NE  ARG A  89      55.606  56.920  14.419  1.00 26.34           N  
ATOM    705  CZ  ARG A  89      55.488  57.840  15.379  1.00 27.61           C  
ATOM    706  NH1 ARG A  89      54.831  58.986  15.174  1.00 27.37           N  
ATOM    707  NH2 ARG A  89      56.040  57.620  16.570  1.00 34.26           N  
ATOM    708  N   GLN A  90      52.011  57.680   8.863  0.50 13.55           N  
ATOM    710  CA  GLN A  90      51.897  57.634   7.403  0.50 13.28           C  
ATOM    712  C   GLN A  90      50.487  58.109   7.083  0.50 14.61           C  
ATOM    714  O   GLN A  90      49.606  57.323   6.745  0.50 15.57           O  
ATOM    716  CB  GLN A  90      52.120  56.234   6.851  0.50 15.76           C  
ATOM    718  CG  GLN A  90      53.528  55.724   6.978  0.50  8.65           C  
ATOM    720  CD  GLN A  90      53.629  54.395   6.290  0.50 11.41           C  
ATOM    722  OE1 GLN A  90      53.260  54.291   5.159  0.50 10.59           O  
ATOM    724  NE2 GLN A  90      54.087  53.367   7.006  0.50 26.48           N  
ATOM    726  N   PRO A  91      50.267  59.418   7.212  1.00 14.81           N  
ATOM    727  CA  PRO A  91      48.941  60.020   7.116  1.00 13.53           C  
ATOM    728  C   PRO A  91      48.249  59.853   5.755  1.00 15.04           C  
ATOM    729  O   PRO A  91      47.071  60.131   5.674  1.00 18.61           O  
ATOM    730  CB  PRO A  91      49.187  61.500   7.491  1.00 15.93           C  
ATOM    731  CG  PRO A  91      50.581  61.722   7.025  1.00 15.45           C  
ATOM    732  CD  PRO A  91      51.290  60.451   7.443  1.00 17.21           C  
ATOM    733  N   GLU A  92      48.974  59.491   4.704  1.00 14.60           N  
ATOM    734  CA  GLU A  92      48.296  59.261   3.441  1.00 13.61           C  
ATOM    735  C   GLU A  92      48.051  57.767   3.155  1.00 16.72           C  
ATOM    736  O   GLU A  92      47.559  57.448   2.064  1.00 18.42           O  
ATOM    737  CB  GLU A  92      49.023  59.979   2.333  1.00 17.34           C  
ATOM    738  CG  GLU A  92      48.967  61.480   2.623  1.00 17.92           C  
ATOM    739  CD  GLU A  92      49.458  62.396   1.550  1.00 21.96           C  
ATOM    740  OE1 GLU A  92      49.703  61.954   0.370  1.00 26.20           O  
ATOM    741  OE2 GLU A  92      49.596  63.579   1.898  1.00 19.83           O  
ATOM    742  N   ARG A  93      48.347  56.877   4.127  1.00 15.17           N  
ATOM    743  CA  ARG A  93      48.040  55.460   3.989  1.00 14.79           C  
ATOM    744  C   ARG A  93      46.687  55.211   4.622  1.00 15.85           C  
ATOM    745  O   ARG A  93      46.529  55.344   5.824  1.00 17.90           O  
ATOM    746  CB  ARG A  93      49.114  54.585   4.644  1.00 14.74           C  
ATOM    747  CG  ARG A  93      48.922  53.130   4.390  1.00 16.22           C  
ATOM    748  CD  ARG A  93      50.012  52.274   4.941  1.00 16.18           C  
ATOM    749  NE  ARG A  93      51.300  52.547   4.317  1.00 18.43           N  
ATOM    750  CZ  ARG A  93      51.720  52.052   3.147  1.00 16.13           C  
ATOM    751  NH1 ARG A  93      50.920  51.304   2.355  1.00 16.45           N  
ATOM    752  NH2 ARG A  93      52.937  52.396   2.725  1.00 19.80           N  
ATOM    753  N   VAL A  94      45.708  54.845   3.808  1.00 14.86           N  
ATOM    754  CA  VAL A  94      44.331  54.693   4.250  1.00 13.55           C  
ATOM    755  C   VAL A  94      44.093  53.295   4.756  1.00 15.39           C  
ATOM    756  O   VAL A  94      44.376  52.316   4.054  1.00 15.27           O  
ATOM    757  CB  VAL A  94      43.366  55.061   3.134  1.00 15.39           C  
ATOM    758  CG1 VAL A  94      41.872  54.885   3.552  1.00 15.90           C  
ATOM    759  CG2 VAL A  94      43.613  56.514   2.588  1.00 17.36           C  
ATOM    760  N   LEU A  95      43.505  53.227   5.959  1.00 14.50           N  
ATOM    761  CA  LEU A  95      43.221  51.960   6.623  1.00 13.60           C  
ATOM    762  C   LEU A  95      41.827  51.397   6.268  1.00 14.55           C  
ATOM    763  O   LEU A  95      40.828  52.119   6.363  1.00 14.43           O  
ATOM    764  CB  LEU A  95      43.356  52.065   8.152  1.00 14.88           C  
ATOM    765  CG  LEU A  95      43.110  50.757   8.946  1.00 14.97           C  
ATOM    766  CD1 LEU A  95      44.194  49.771   8.755  1.00 14.20           C  
ATOM    767  CD2 LEU A  95      42.957  51.058  10.480  1.00 15.86           C  
ATOM    768  N   TYR A  96      41.799  50.087   5.947  1.00 14.22           N  
ATOM    769  CA  TYR A  96      40.578  49.347   5.690  1.00 15.53           C  
ATOM    770  C   TYR A  96      40.518  48.092   6.595  1.00 13.92           C  
ATOM    771  O   TYR A  96      41.512  47.426   6.848  1.00 15.27           O  
ATOM    772  CB  TYR A  96      40.564  48.852   4.223  1.00 14.86           C  
ATOM    773  CG  TYR A  96      40.484  49.984   3.248  1.00 12.22           C  
ATOM    774  CD1 TYR A  96      41.641  50.653   2.830  1.00 13.99           C  
ATOM    775  CD2 TYR A  96      39.242  50.439   2.757  1.00 13.80           C  
ATOM    776  CE1 TYR A  96      41.563  51.752   1.979  1.00 16.19           C  
ATOM    777  CE2 TYR A  96      39.177  51.517   1.876  1.00 15.60           C  
ATOM    778  CZ  TYR A  96      40.351  52.169   1.490  1.00 15.78           C  
ATOM    779  OH  TYR A  96      40.260  53.254   0.624  1.00 20.94           O  
ATOM    780  N   LEU A  97      39.312  47.786   7.044  1.00 15.10           N  
ATOM    781  CA  LEU A  97      38.969  46.527   7.683  1.00 15.81           C  
ATOM    782  C   LEU A  97      38.504  45.545   6.635  1.00 12.96           C  
ATOM    783  O   LEU A  97      37.529  45.803   5.928  1.00 13.70           O  
ATOM    784  CB  LEU A  97      37.823  46.738   8.677  1.00 15.25           C  
ATOM    785  CG  LEU A  97      37.238  45.504   9.384  1.00 16.89           C  
ATOM    786  CD1 LEU A  97      38.303  44.691  10.147  1.00 18.54           C  
ATOM    787  CD2 LEU A  97      36.012  45.843  10.247  1.00 16.48           C  
ATOM    788  N   ALA A  98      39.249  44.460   6.481  1.00 13.36           N  
ATOM    789  CA  ALA A  98      38.881  43.433   5.499  1.00 13.19           C  
ATOM    790  C   ALA A  98      37.998  42.346   6.125  1.00 14.24           C  
ATOM    791  O   ALA A  98      38.380  41.787   7.138  1.00 16.09           O  
ATOM    792  CB  ALA A  98      40.123  42.809   4.890  1.00 15.10           C  
ATOM    793  N   VAL A  99      36.832  42.089   5.531  1.00 15.73           N  
ATOM    794  CA  VAL A  99      35.993  41.036   6.032  1.00 16.72           C  
ATOM    795  C   VAL A  99      35.425  40.194   4.886  1.00 16.52           C  
ATOM    796  O   VAL A  99      35.207  40.716   3.768  1.00 15.38           O  
ATOM    797  CB  VAL A  99      34.864  41.476   6.953  1.00 20.96           C  
ATOM    798  CG1 VAL A  99      35.363  42.516   8.024  1.00 21.22           C  
ATOM    799  CG2 VAL A  99      33.697  42.046   6.181  1.00 20.54           C  
ATOM    800  N   PRO A 100      35.191  38.898   5.152  1.00 16.21           N  
ATOM    801  CA  PRO A 100      34.622  38.025   4.117  1.00 13.33           C  
ATOM    802  C   PRO A 100      33.227  38.438   3.676  1.00 16.14           C  
ATOM    803  O   PRO A 100      32.439  38.982   4.476  1.00 15.46           O  
ATOM    804  CB  PRO A 100      34.596  36.657   4.801  1.00 16.51           C  
ATOM    805  CG  PRO A 100      35.570  36.717   5.889  1.00 19.93           C  
ATOM    806  CD  PRO A 100      35.443  38.124   6.377  1.00 17.21           C  
ATOM    807  N   LEU A 101      32.916  38.159   2.416  1.00 16.24           N  
ATOM    808  CA  LEU A 101      31.617  38.444   1.843  1.00 16.98           C  
ATOM    809  C   LEU A 101      30.494  37.806   2.669  1.00 15.64           C  
ATOM    810  O   LEU A 101      29.464  38.447   2.897  1.00 17.18           O  
ATOM    811  CB  LEU A 101      31.531  37.951   0.375  1.00 18.19           C  
ATOM    812  CG  LEU A 101      30.230  38.296  -0.349  1.00 14.85           C  
ATOM    813  CD1 LEU A 101      29.806  39.744  -0.362  1.00 18.28           C  
ATOM    814  CD2 LEU A 101      30.354  37.753  -1.803  1.00 19.09           C  
ATOM    815  N   THR A 102      30.676  36.563   3.124  1.00 15.14           N  
ATOM    816  CA  THR A 102      29.628  35.858   3.928  1.00 17.37           C  
ATOM    817  C   THR A 102      29.299  36.671   5.183  1.00 17.31           C  
ATOM    818  O   THR A 102      28.135  36.853   5.542  1.00 18.51           O  
ATOM    819  CB  THR A 102      30.046  34.432   4.302  1.00 20.07           C  
ATOM    820  OG1 THR A 102      31.330  34.433   4.928  1.00 20.21           O  
ATOM    821  CG2 THR A 102      30.121  33.545   3.038  1.00 21.03           C  
ATOM    822  N   THR A 103      30.332  37.194   5.837  1.00 14.69           N  
ATOM    823  CA  THR A 103      30.130  38.012   7.053  1.00 16.48           C  
ATOM    824  C   THR A 103      29.487  39.365   6.715  1.00 14.95           C  
ATOM    825  O   THR A 103      28.594  39.852   7.427  1.00 16.82           O  
ATOM    826  CB  THR A 103      31.486  38.263   7.720  1.00 16.97           C  
ATOM    827  OG1 THR A 103      32.154  37.022   7.901  1.00 21.79           O  
ATOM    828  CG2 THR A 103      31.357  39.041   9.058  1.00 18.97           C  
ATOM    829  N   TYR A 104      29.911  39.943   5.601  1.00 14.55           N  
ATOM    830  CA  TYR A 104      29.370  41.218   5.156  1.00 15.81           C  
ATOM    831  C   TYR A 104      27.856  41.076   4.915  1.00 17.26           C  
ATOM    832  O   TYR A 104      27.070  41.943   5.293  1.00 18.07           O  
ATOM    833  CB  TYR A 104      30.046  41.689   3.869  1.00 16.95           C  
ATOM    834  CG  TYR A 104      29.469  42.983   3.348  1.00 16.88           C  
ATOM    835  CD1 TYR A 104      29.667  44.172   4.049  1.00 20.14           C  
ATOM    836  CD2 TYR A 104      28.739  43.015   2.168  1.00 24.05           C  
ATOM    837  CE1 TYR A 104      29.126  45.360   3.602  1.00 25.95           C  
ATOM    838  CE2 TYR A 104      28.189  44.219   1.709  1.00 23.57           C  
ATOM    839  CZ  TYR A 104      28.397  45.366   2.442  1.00 23.90           C  
ATOM    840  OH  TYR A 104      27.836  46.545   2.002  1.00 37.27           O  
ATOM    841  N   LYS A 105      27.461  39.990   4.288  1.00 16.41           N  
ATOM    842  CA  LYS A 105      26.066  39.823   3.890  1.00 19.34           C  
ATOM    843  C   LYS A 105      25.168  39.410   5.048  1.00 20.42           C  
ATOM    844  O   LYS A 105      23.927  39.400   4.902  1.00 22.75           O  
ATOM    845  CB  LYS A 105      25.938  38.769   2.794  1.00 19.60           C  
ATOM    846  CG  LYS A 105      26.489  39.200   1.451  1.00 22.79           C  
ATOM    847  CD  LYS A 105      26.411  38.031   0.421  1.00 25.59           C  
ATOM    848  CE  LYS A 105      24.976  37.739  -0.018  1.00 34.35           C  
ATOM    849  N   THR A 106      25.760  38.982   6.168  1.00 17.80           N  
ATOM    850  CA  THR A 106      24.968  38.510   7.319  1.00 18.43           C  
ATOM    851  C   THR A 106      25.134  39.466   8.485  1.00 17.31           C  
ATOM    852  O   THR A 106      24.334  40.393   8.654  1.00 15.44           O  
ATOM    853  CB  THR A 106      25.378  37.070   7.724  1.00 18.03           C  
ATOM    854  OG1 THR A 106      26.791  36.993   7.937  1.00 18.50           O  
ATOM    855  CG2 THR A 106      24.980  36.059   6.608  1.00 20.27           C  
ATOM    856  N   PHE A 107      26.230  39.312   9.244  1.00 17.34           N  
ATOM    857  CA  PHE A 107      26.474  40.173  10.424  1.00 16.01           C  
ATOM    858  C   PHE A 107      26.417  41.671  10.123  1.00 15.19           C  
ATOM    859  O   PHE A 107      25.744  42.426  10.827  1.00 16.51           O  
ATOM    860  CB  PHE A 107      27.820  39.821  11.060  1.00 16.23           C  
ATOM    861  CG  PHE A 107      28.176  40.645  12.267  1.00 14.70           C  
ATOM    862  CD1 PHE A 107      27.503  40.427  13.473  1.00 15.99           C  
ATOM    863  CD2 PHE A 107      29.192  41.572  12.241  1.00 17.19           C  
ATOM    864  CE1 PHE A 107      27.828  41.134  14.591  1.00 16.84           C  
ATOM    865  CE2 PHE A 107      29.496  42.294  13.369  1.00 17.43           C  
ATOM    866  CZ  PHE A 107      28.787  42.057  14.551  1.00 15.11           C  
ATOM    867  N   PHE A 108      27.111  42.104   9.059  1.00 15.83           N  
ATOM    868  CA  PHE A 108      27.170  43.531   8.735  1.00 16.41           C  
ATOM    869  C   PHE A 108      25.895  44.068   8.091  1.00 17.09           C  
ATOM    870  O   PHE A 108      25.802  45.270   7.870  1.00 20.80           O  
ATOM    871  CB  PHE A 108      28.451  43.908   7.931  1.00 18.30           C  
ATOM    872  CG  PHE A 108      29.689  43.873   8.766  1.00 16.08           C  
ATOM    873  CD1 PHE A 108      29.893  44.854   9.721  1.00 18.02           C  
ATOM    874  CD2 PHE A 108      30.546  42.791   8.731  1.00 17.08           C  
ATOM    875  CE1 PHE A 108      30.994  44.808  10.551  1.00 20.51           C  
ATOM    876  CE2 PHE A 108      31.682  42.735   9.597  1.00 16.60           C  
ATOM    877  CZ  PHE A 108      31.858  43.754  10.507  1.00 18.25           C  
ATOM    878  N   GLN A 109      24.904  43.223   7.835  1.00 17.43           N  
ATOM    879  CA  GLN A 109      23.582  43.722   7.459  1.00 20.48           C  
ATOM    880  C   GLN A 109      22.626  43.889   8.641  1.00 19.69           C  
ATOM    881  O   GLN A 109      21.506  44.407   8.482  1.00 18.90           O  
ATOM    882  CB  GLN A 109      22.945  42.819   6.390  1.00 22.15           C  
ATOM    883  CG  GLN A 109      23.780  42.763   5.092  1.00 21.74           C  
ATOM    884  CD  GLN A 109      24.206  44.150   4.616  1.00 28.83           C  
ATOM    885  OE1 GLN A 109      23.368  45.065   4.512  1.00 31.18           O  
ATOM    886  NE2 GLN A 109      25.504  44.338   4.374  1.00 28.96           N  
ATOM    887  N   LEU A 110      23.036  43.442   9.822  1.00 17.65           N  
ATOM    888  CA  LEU A 110      22.286  43.719  11.048  1.00 17.13           C  
ATOM    889  C   LEU A 110      22.390  45.215  11.380  1.00 14.61           C  
ATOM    890  O   LEU A 110      23.392  45.859  11.100  1.00 14.48           O  
ATOM    891  CB  LEU A 110      22.781  42.870  12.226  1.00 16.44           C  
ATOM    892  CG  LEU A 110      22.626  41.341  12.012  1.00 17.79           C  
ATOM    893  CD1 LEU A 110      23.282  40.600  13.169  1.00 17.60           C  
ATOM    894  CD2 LEU A 110      21.148  40.915  11.878  1.00 20.60           C  
ATOM    895  N   ASP A 111      21.342  45.758  11.972  1.00 14.09           N  
ATOM    896  CA  ASP A 111      21.271  47.193  12.189  1.00 14.73           C  
ATOM    897  C   ASP A 111      22.436  47.681  13.096  1.00 14.46           C  
ATOM    898  O   ASP A 111      23.037  48.727  12.839  1.00 14.99           O  
ATOM    899  CB  ASP A 111      19.941  47.593  12.805  1.00 15.77           C  
ATOM    900  CG  ASP A 111      18.765  47.595  11.833  1.00 22.75           C  
ATOM    901  OD1 ASP A 111      18.965  47.469  10.622  1.00 22.85           O  
ATOM    902  OD2 ASP A 111      17.635  47.782  12.360  1.00 26.69           O  
ATOM    903  N   PHE A 112      22.767  46.932  14.157  1.00 14.71           N  
ATOM    904  CA  PHE A 112      23.741  47.438  15.116  1.00 14.99           C  
ATOM    905  C   PHE A 112      25.149  47.589  14.512  1.00 14.61           C  
ATOM    906  O   PHE A 112      25.751  48.678  14.526  1.00 13.53           O  
ATOM    907  CB  PHE A 112      23.758  46.604  16.394  1.00 14.06           C  
ATOM    908  CG  PHE A 112      24.750  47.088  17.393  1.00 13.66           C  
ATOM    909  CD1 PHE A 112      24.490  48.215  18.118  1.00 13.94           C  
ATOM    910  CD2 PHE A 112      25.955  46.456  17.551  1.00 16.93           C  
ATOM    911  CE1 PHE A 112      25.462  48.716  19.011  1.00 18.12           C  
ATOM    912  CE2 PHE A 112      26.899  46.940  18.437  1.00 13.37           C  
ATOM    913  CZ  PHE A 112      26.647  48.031  19.199  1.00 13.93           C  
ATOM    914  N   PRO A 113      25.714  46.495  13.939  1.00 13.93           N  
ATOM    915  CA  PRO A 113      27.045  46.658  13.336  1.00 13.41           C  
ATOM    916  C   PRO A 113      27.043  47.691  12.205  1.00 13.31           C  
ATOM    917  O   PRO A 113      28.003  48.448  12.052  1.00 14.21           O  
ATOM    918  CB  PRO A 113      27.379  45.268  12.791  1.00 18.10           C  
ATOM    919  CG  PRO A 113      26.418  44.364  13.363  1.00 19.97           C  
ATOM    920  CD  PRO A 113      25.266  45.093  13.889  1.00 15.57           C  
ATOM    921  N   LYS A 114      26.001  47.718  11.391  1.00 14.42           N  
ATOM    922  CA  LYS A 114      25.937  48.705  10.311  1.00 14.93           C  
ATOM    923  C   LYS A 114      26.052  50.124  10.893  1.00 13.22           C  
ATOM    924  O   LYS A 114      26.818  50.993  10.386  1.00 15.60           O  
ATOM    925  CB  LYS A 114      24.605  48.507   9.562  1.00 16.05           C  
ATOM    926  CG  LYS A 114      24.369  49.456   8.477  1.00 20.39           C  
ATOM    927  CD  LYS A 114      23.109  49.061   7.652  1.00 22.24           C  
ATOM    928  CE  LYS A 114      23.261  47.768   6.918  1.00 31.91           C  
ATOM    929  N   GLU A 115      25.322  50.352  11.976  1.00 13.84           N  
ATOM    930  CA  GLU A 115      25.340  51.675  12.654  1.00 14.32           C  
ATOM    931  C   GLU A 115      26.717  51.999  13.204  1.00 14.16           C  
ATOM    932  O   GLU A 115      27.243  53.119  13.055  1.00 14.22           O  
ATOM    933  CB  GLU A 115      24.282  51.798  13.786  1.00 13.29           C  
ATOM    934  CG  GLU A 115      24.266  53.086  14.518  1.00 12.92           C  
ATOM    935  CD  GLU A 115      24.021  54.351  13.710  1.00 16.36           C  
ATOM    936  OE1 GLU A 115      23.549  54.250  12.576  1.00 17.43           O  
ATOM    937  OE2 GLU A 115      24.347  55.420  14.297  1.00 15.76           O  
HETATM  938  N   MSE A 116      27.343  51.026  13.866  0.50 15.16           N  
HETATM  940  CA  MSE A 116      28.661  51.269  14.479  0.50 13.99           C  
HETATM  942  C   MSE A 116      29.810  51.466  13.467  0.50 13.28           C  
HETATM  944  O   MSE A 116      30.741  52.223  13.717  0.50 14.54           O  
HETATM  946  CB  MSE A 116      28.977  50.172  15.517  0.50 11.89           C  
HETATM  948  CG  MSE A 116      27.846  49.986  16.536  0.50 13.29           C  
HETATM  950 SE   MSE A 116      27.311  51.659  17.411  0.37 10.58          SE  
HETATM  952  CE  MSE A 116      29.136  52.211  18.060  0.50 11.47           C  
ATOM    954  N   ILE A 117      29.729  50.801  12.320  1.00 12.96           N  
ATOM    955  CA  ILE A 117      30.621  51.055  11.202  1.00 13.83           C  
ATOM    956  C   ILE A 117      30.430  52.503  10.740  1.00 14.38           C  
ATOM    957  O   ILE A 117      31.368  53.256  10.551  1.00 15.20           O  
ATOM    958  CB  ILE A 117      30.356  50.075  10.041  1.00 15.51           C  
ATOM    959  CG1 ILE A 117      30.817  48.659  10.389  1.00 16.03           C  
ATOM    960  CG2 ILE A 117      30.935  50.610   8.681  1.00 15.96           C  
ATOM    961  CD1 ILE A 117      32.312  48.450  10.482  1.00 17.42           C  
ATOM    962  N   ALA A 118      29.170  52.929  10.586  1.00 13.94           N  
ATOM    963  CA  ALA A 118      28.911  54.287  10.130  1.00 14.14           C  
ATOM    964  C   ALA A 118      29.390  55.345  11.135  1.00 14.25           C  
ATOM    965  O   ALA A 118      29.998  56.335  10.768  1.00 16.66           O  
ATOM    966  CB  ALA A 118      27.420  54.469   9.878  1.00 14.99           C  
ATOM    967  N   GLU A 119      29.077  55.134  12.423  1.00 13.86           N  
ATOM    968  CA  GLU A 119      29.400  56.125  13.458  1.00 12.84           C  
ATOM    969  C   GLU A 119      30.915  56.357  13.532  1.00 14.41           C  
ATOM    970  O   GLU A 119      31.375  57.438  13.908  1.00 17.20           O  
ATOM    971  CB  GLU A 119      28.879  55.693  14.811  1.00 13.60           C  
ATOM    972  CG  GLU A 119      27.361  55.685  14.965  1.00 15.14           C  
ATOM    973  CD  GLU A 119      26.849  55.438  16.381  1.00 16.25           C  
ATOM    974  OE1 GLU A 119      27.662  55.402  17.308  1.00 16.19           O  
ATOM    975  OE2 GLU A 119      25.562  55.334  16.506  1.00 15.73           O  
ATOM    976  N   ASN A 120      31.687  55.294  13.289  1.00 14.06           N  
ATOM    977  CA  ASN A 120      33.145  55.343  13.416  1.00 14.84           C  
ATOM    978  C   ASN A 120      33.890  55.456  12.074  1.00 15.07           C  
ATOM    979  O   ASN A 120      35.122  55.278  12.048  1.00 15.45           O  
ATOM    980  CB  ASN A 120      33.570  54.124  14.229  1.00 14.39           C  
ATOM    981  CG  ASN A 120      33.094  54.246  15.646  1.00 13.77           C  
ATOM    982  OD1 ASN A 120      33.706  54.983  16.457  1.00 15.30           O  
ATOM    983  ND2 ASN A 120      31.979  53.607  15.951  1.00 13.83           N  
ATOM    984  N   GLN A 121      33.179  55.737  10.985  1.00 13.72           N  
ATOM    985  CA  GLN A 121      33.776  55.933   9.701  1.00 15.76           C  
ATOM    986  C   GLN A 121      34.703  54.791   9.308  1.00 16.30           C  
ATOM    987  O   GLN A 121      35.790  54.980   8.744  1.00 17.54           O  
ATOM    988  CB  GLN A 121      34.485  57.300   9.652  1.00 19.90           C  
ATOM    989  CG  GLN A 121      33.542  58.478   9.569  1.00 28.27           C  
ATOM    990  CD  GLN A 121      32.762  58.818  10.838  1.00 48.45           C  
ATOM    991  OE1 GLN A 121      33.321  58.802  11.944  1.00 55.26           O  
ATOM    992  NE2 GLN A 121      31.448  59.169  10.676  1.00 38.01           N  
ATOM    993  N   VAL A 122      34.278  53.567   9.562  1.00 13.67           N  
ATOM    994  CA  VAL A 122      35.120  52.401   9.266  1.00 13.06           C  
ATOM    995  C   VAL A 122      35.012  52.116   7.758  1.00 16.32           C  
ATOM    996  O   VAL A 122      33.919  51.938   7.207  1.00 19.51           O  
ATOM    997  CB  VAL A 122      34.683  51.181  10.099  1.00 14.67           C  
ATOM    998  CG1 VAL A 122      35.552  49.938   9.765  1.00 14.23           C  
ATOM    999  CG2 VAL A 122      34.710  51.469  11.609  1.00 15.19           C  
ATOM   1000  N   LYS A 123      36.164  52.088   7.133  1.00 13.11           N  
ATOM   1001  CA  LYS A 123      36.302  51.736   5.731  1.00 13.10           C  
ATOM   1002  C   LYS A 123      36.529  50.232   5.652  1.00 13.72           C  
ATOM   1003  O   LYS A 123      37.258  49.681   6.500  1.00 15.54           O  
ATOM   1004  CB  LYS A 123      37.471  52.513   5.136  1.00 15.71           C  
ATOM   1005  CG  LYS A 123      37.335  54.017   5.201  1.00 15.58           C  
ATOM   1006  CD  LYS A 123      38.514  54.692   4.513  1.00 16.63           C  
ATOM   1007  CE  LYS A 123      38.544  56.162   4.754  1.00 17.71           C  
ATOM   1008  NZ  LYS A 123      37.375  56.858   4.188  1.00 21.04           N  
HETATM 1009  N   MSE A 124      35.948  49.576   4.651  0.50 13.97           N  
HETATM 1011  CA  MSE A 124      36.058  48.116   4.593  0.50 13.30           C  
HETATM 1013  C   MSE A 124      36.484  47.600   3.210  0.50 13.96           C  
HETATM 1015  O   MSE A 124      36.261  48.245   2.180  0.50 13.54           O  
HETATM 1017  CB  MSE A 124      34.753  47.453   5.038  0.50 15.55           C  
HETATM 1019  CG  MSE A 124      34.425  47.733   6.493  0.50 11.00           C  
HETATM 1021 SE   MSE A 124      32.707  46.917   7.013  0.37 22.46          SE  
HETATM 1023  CE  MSE A 124      31.645  48.108   5.876  0.50 17.06           C  
ATOM   1025  N   LEU A 125      37.136  46.450   3.230  0.50 14.37           N  
ATOM   1027  CA  LEU A 125      37.476  45.698   2.036  0.50 15.06           C  
ATOM   1029  C   LEU A 125      36.677  44.403   2.127  0.50 14.89           C  
ATOM   1031  O   LEU A 125      36.921  43.601   3.023  0.50 15.30           O  
ATOM   1033  CB  LEU A 125      38.977  45.469   1.996  0.50 17.41           C  
ATOM   1035  CG  LEU A 125      39.558  44.726   0.792  0.50 17.18           C  
ATOM   1037  CD1 LEU A 125      39.115  45.444  -0.493  0.50 24.81           C  
ATOM   1039  CD2 LEU A 125      41.074  44.611   0.905  0.50 15.35           C  
ATOM   1041  N   ILE A 126      35.686  44.231   1.254  1.00 13.64           N  
ATOM   1042  CA  ILE A 126      34.908  43.017   1.277  1.00 15.23           C  
ATOM   1043  C   ILE A 126      35.507  42.045   0.267  1.00 16.13           C  
ATOM   1044  O   ILE A 126      35.578  42.356  -0.942  1.00 14.71           O  
ATOM   1045  CB  ILE A 126      33.444  43.255   0.952  1.00 16.34           C  
ATOM   1046  CG1 ILE A 126      32.891  44.437   1.774  1.00 16.18           C  
ATOM   1047  CG2 ILE A 126      32.652  41.964   1.206  1.00 17.21           C  
ATOM   1048  CD1 ILE A 126      33.100  44.318   3.266  1.00 15.86           C  
ATOM   1049  N   TYR A 127      35.917  40.874   0.758  1.00 14.04           N  
ATOM   1050  CA  TYR A 127      36.602  39.870  -0.096  1.00 14.00           C  
ATOM   1051  C   TYR A 127      35.828  38.556  -0.125  1.00 15.72           C  
ATOM   1052  O   TYR A 127      35.254  38.134   0.871  1.00 15.24           O  
ATOM   1053  CB  TYR A 127      38.036  39.623   0.344  1.00 15.74           C  
ATOM   1054  CG  TYR A 127      38.256  39.037   1.744  1.00 15.09           C  
ATOM   1055  CD1 TYR A 127      38.304  39.876   2.875  1.00 16.34           C  
ATOM   1056  CD2 TYR A 127      38.519  37.677   1.955  1.00 16.38           C  
ATOM   1057  CE1 TYR A 127      38.521  39.357   4.137  1.00 14.75           C  
ATOM   1058  CE2 TYR A 127      38.753  37.173   3.221  1.00 17.26           C  
ATOM   1059  CZ  TYR A 127      38.768  37.989   4.304  1.00 17.10           C  
ATOM   1060  OH  TYR A 127      39.048  37.432   5.527  1.00 17.31           O  
ATOM   1061  N   ASP A 128      35.858  37.919  -1.277  1.00 12.60           N  
ATOM   1062  CA  ASP A 128      35.237  36.625  -1.433  1.00 12.26           C  
ATOM   1063  C   ASP A 128      36.287  35.572  -1.185  1.00 14.54           C  
ATOM   1064  O   ASP A 128      37.309  35.562  -1.839  1.00 13.27           O  
ATOM   1065  CB  ASP A 128      34.622  36.492  -2.828  1.00 14.60           C  
ATOM   1066  CG  ASP A 128      33.927  35.175  -3.013  1.00 14.70           C  
ATOM   1067  OD1 ASP A 128      34.572  34.199  -3.394  1.00 17.57           O  
ATOM   1068  OD2 ASP A 128      32.724  35.081  -2.694  1.00 16.72           O  
ATOM   1069  N   VAL A 129      36.050  34.719  -0.191  1.00 13.96           N  
ATOM   1070  CA  VAL A 129      37.017  33.691   0.175  1.00 15.14           C  
ATOM   1071  C   VAL A 129      37.214  32.593  -0.876  1.00 14.88           C  
ATOM   1072  O   VAL A 129      38.350  32.272  -1.225  1.00 16.75           O  
ATOM   1073  CB  VAL A 129      36.663  33.088   1.550  1.00 15.35           C  
ATOM   1074  CG1 VAL A 129      37.593  31.920   1.871  1.00 16.59           C  
ATOM   1075  CG2 VAL A 129      36.750  34.192   2.647  1.00 15.65           C  
ATOM   1076  N   GLU A 130      36.123  32.022  -1.404  1.00 14.07           N  
ATOM   1077  CA  GLU A 130      36.189  30.903  -2.338  1.00 15.93           C  
ATOM   1078  C   GLU A 130      37.029  31.234  -3.571  1.00 15.77           C  
ATOM   1079  O   GLU A 130      37.867  30.431  -3.995  1.00 17.69           O  
ATOM   1080  CB  GLU A 130      34.764  30.490  -2.753  1.00 17.66           C  
ATOM   1081  CG  GLU A 130      34.742  29.356  -3.784  1.00 24.11           C  
ATOM   1082  CD  GLU A 130      33.552  29.440  -4.755  1.00 39.62           C  
ATOM   1083  OE1 GLU A 130      32.459  28.962  -4.377  1.00 46.00           O  
ATOM   1084  OE2 GLU A 130      33.710  29.960  -5.888  1.00 40.08           O  
ATOM   1085  N   GLN A 131      36.798  32.421  -4.132  1.00 13.56           N  
ATOM   1086  CA  GLN A 131      37.516  32.805  -5.343  1.00 12.81           C  
ATOM   1087  C   GLN A 131      38.711  33.716  -5.083  1.00 13.82           C  
ATOM   1088  O   GLN A 131      39.502  33.988  -5.995  1.00 14.43           O  
ATOM   1089  CB  GLN A 131      36.566  33.480  -6.367  1.00 15.26           C  
ATOM   1090  CG  GLN A 131      35.665  32.494  -7.042  1.00 16.40           C  
ATOM   1091  CD  GLN A 131      36.441  31.408  -7.789  1.00 16.74           C  
ATOM   1092  OE1 GLN A 131      37.369  31.719  -8.586  1.00 20.23           O  
ATOM   1093  NE2 GLN A 131      36.062  30.138  -7.574  1.00 19.83           N  
ATOM   1094  N   GLU A 132      38.859  34.188  -3.851  0.00 12.57           N  
ATOM   1096  CA  GLU A 132      39.993  35.034  -3.495  0.00 12.06           C  
ATOM   1098  C   GLU A 132      40.040  36.287  -4.367  0.00 12.71           C  
ATOM   1100  O   GLU A 132      41.005  36.517  -5.096  0.00 13.15           O  
ATOM   1102  CB  GLU A 132      41.304  34.255  -3.622  0.00 14.38           C  
ATOM   1104  CG  GLU A 132      41.503  33.198  -2.549  0.00 16.85           C  
ATOM   1106  CD  GLU A 132      42.562  32.179  -2.925  0.00 23.21           C  
ATOM   1108  OE1 GLU A 132      43.342  32.448  -3.862  0.00 26.47           O  
ATOM   1110  OE2 GLU A 132      42.613  31.109  -2.283  0.00 38.38           O  
ATOM   1112  N   VAL A 133      38.981  37.075  -4.282  1.00 13.60           N  
ATOM   1113  CA  VAL A 133      38.861  38.308  -5.041  1.00 12.46           C  
ATOM   1114  C   VAL A 133      38.244  39.403  -4.180  1.00 13.87           C  
ATOM   1115  O   VAL A 133      37.545  39.142  -3.180  1.00 13.42           O  
ATOM   1116  CB  VAL A 133      37.974  38.130  -6.299  1.00 13.05           C  
ATOM   1117  CG1 VAL A 133      38.612  37.115  -7.255  1.00 13.40           C  
ATOM   1118  CG2 VAL A 133      36.539  37.749  -5.910  1.00 13.74           C  
ATOM   1119  N   ILE A 134      38.556  40.651  -4.539  1.00 13.11           N  
ATOM   1120  CA  ILE A 134      37.904  41.804  -3.926  1.00 13.54           C  
ATOM   1121  C   ILE A 134      36.514  42.013  -4.573  1.00 12.04           C  
ATOM   1122  O   ILE A 134      36.400  42.177  -5.788  1.00 14.64           O  
ATOM   1123  CB  ILE A 134      38.728  43.095  -4.082  1.00 14.44           C  
ATOM   1124  CG1 ILE A 134      40.072  42.941  -3.385  1.00 13.51           C  
ATOM   1125  CG2 ILE A 134      37.950  44.330  -3.582  1.00 15.87           C  
ATOM   1126  CD1 ILE A 134      40.995  44.195  -3.439  1.00 16.71           C  
ATOM   1127  N   PHE A 135      35.467  42.040  -3.721  1.00 14.62           N  
ATOM   1128  CA  PHE A 135      34.081  42.219  -4.145  1.00 15.81           C  
ATOM   1129  C   PHE A 135      33.651  43.678  -4.043  1.00 14.46           C  
ATOM   1130  O   PHE A 135      32.934  44.163  -4.926  1.00 15.15           O  
ATOM   1131  CB  PHE A 135      33.173  41.385  -3.249  1.00 15.08           C  
ATOM   1132  CG  PHE A 135      31.700  41.674  -3.428  1.00 14.23           C  
ATOM   1133  CD1 PHE A 135      31.088  41.402  -4.613  1.00 15.32           C  
ATOM   1134  CD2 PHE A 135      30.947  42.267  -2.396  1.00 15.72           C  
ATOM   1135  CE1 PHE A 135      29.719  41.625  -4.784  1.00 17.36           C  
ATOM   1136  CE2 PHE A 135      29.609  42.539  -2.598  1.00 18.91           C  
ATOM   1137  CZ  PHE A 135      29.000  42.206  -3.776  1.00 18.77           C  
ATOM   1138  N   GLN A 136      34.075  44.395  -2.995  1.00 14.87           N  
ATOM   1139  CA  GLN A 136      33.636  45.783  -2.832  1.00 15.28           C  
ATOM   1140  C   GLN A 136      34.576  46.523  -1.872  1.00 15.32           C  
ATOM   1141  O   GLN A 136      35.116  45.956  -0.940  1.00 16.08           O  
ATOM   1142  CB  GLN A 136      32.219  45.793  -2.251  1.00 15.01           C  
ATOM   1143  CG  GLN A 136      31.549  47.140  -2.359  1.00 20.95           C  
ATOM   1144  CD  GLN A 136      30.100  47.062  -1.960  1.00 27.54           C  
ATOM   1145  OE1 GLN A 136      29.530  45.978  -1.867  1.00 35.36           O  
ATOM   1146  NE2 GLN A 136      29.503  48.207  -1.689  1.00 30.05           N  
ATOM   1147  N   TRP A 137      34.814  47.794  -2.185  1.00 17.97           N  
ATOM   1148  CA  TRP A 137      35.401  48.738  -1.243  1.00 16.58           C  
ATOM   1149  C   TRP A 137      34.296  49.624  -0.697  1.00 17.32           C  
ATOM   1150  O   TRP A 137      33.470  50.139  -1.459  1.00 17.87           O  
ATOM   1151  CB  TRP A 137      36.398  49.594  -1.972  1.00 15.82           C  
ATOM   1152  CG  TRP A 137      37.603  48.902  -2.527  1.00 15.82           C  
ATOM   1153  CD1 TRP A 137      37.774  48.440  -3.798  1.00 16.99           C  
ATOM   1154  CD2 TRP A 137      38.805  48.613  -1.839  1.00 13.49           C  
ATOM   1155  NE1 TRP A 137      39.038  47.905  -3.961  1.00 16.28           N  
ATOM   1156  CE2 TRP A 137      39.686  48.005  -2.756  1.00 15.31           C  
ATOM   1157  CE3 TRP A 137      39.270  48.900  -0.555  1.00 16.83           C  
ATOM   1158  CZ2 TRP A 137      40.989  47.684  -2.422  1.00 16.74           C  
ATOM   1159  CZ3 TRP A 137      40.544  48.501  -0.199  1.00 17.03           C  
ATOM   1160  CH2 TRP A 137      41.396  47.921  -1.135  1.00 17.84           C  
ATOM   1161  N   ILE A 138      34.276  49.785   0.619  1.00 15.95           N  
ATOM   1162  CA  ILE A 138      33.255  50.623   1.305  1.00 19.11           C  
ATOM   1163  C   ILE A 138      33.913  51.803   2.057  1.00 23.16           C  
ATOM   1164  O   ILE A 138      34.860  51.619   2.847  1.00 21.27           O  
ATOM   1165  CB  ILE A 138      32.451  49.784   2.228  1.00 24.62           C  
ATOM   1166  CG1 ILE A 138      31.744  48.681   1.431  1.00 26.91           C  
ATOM   1167  CG2 ILE A 138      31.458  50.658   3.073  1.00 27.49           C  
ATOM   1168  CD1 ILE A 138      30.972  47.748   2.251  1.00 37.33           C  
ATOM   1169  N   ASN A 139      33.371  52.998   1.786  1.00 27.94           N  
ATOM   1170  CA  ASN A 139      33.623  54.274   2.527  1.00 32.64           C  
ATOM   1171  C   ASN A 139      34.992  54.751   2.157  1.00 37.50           C  
ATOM   1172  O   ASN A 139      35.550  54.171   1.225  1.00 37.85           O  
ATOM   1173  CB  ASN A 139      33.492  54.155   4.049  1.00 33.87           C  
ATOM   1174  CG  ASN A 139      32.105  53.845   4.489  1.00 41.49           C  
ATOM   1175  OD1 ASN A 139      31.158  54.099   3.741  1.00 34.39           O  
ATOM   1176  ND2 ASN A 139      31.954  53.309   5.740  1.00 32.99           N  
ATOM   1177  OXT ASN A 139      35.490  55.704   2.790  1.00 43.79           O  
TER    1178      ASN A 139                                                      
END
MOLECULE T0495_5_143.pdb
ATOM      1  N   LEU     5      45.969  23.478   3.252  1.00 38.14           N  
ATOM      2  CA  LEU     5      46.490  24.710   3.921  1.00 38.30           C  
ATOM      3  C   LEU     5      46.362  24.598   5.434  1.00 38.70           C  
ATOM      4  O   LEU     5      45.265  24.375   5.947  1.00 38.88           O  
ATOM      5  CB  LEU     5      45.724  25.958   3.463  1.00 37.92           C  
ATOM      6  CG  LEU     5      45.678  26.334   1.977  1.00 37.39           C  
ATOM      7  CD1 LEU     5      45.154  27.777   1.825  1.00 35.18           C  
ATOM      8  CD2 LEU     5      47.048  26.165   1.302  1.00 36.39           C  
ATOM      9  N   ASP     6      47.483  24.733   6.143  1.00 39.19           N  
ATOM     10  CA  ASP     6      47.446  25.021   7.581  1.00 39.51           C  
ATOM     11  C   ASP     6      47.751  26.510   7.753  1.00 39.87           C  
ATOM     12  O   ASP     6      48.840  26.914   8.171  1.00 39.97           O  
ATOM     13  CB  ASP     6      48.340  24.100   8.452  1.00 39.40           C  
ATOM     14  CG  ASP     6      49.600  23.620   7.748  1.00 39.37           C  
ATOM     15  OD1 ASP     6      50.647  23.504   8.421  1.00 38.77           O  
ATOM     16  OD2 ASP     6      49.544  23.326   6.537  1.00 39.57           O  
ATOM     17  N   LEU     7      46.768  27.313   7.358  1.00 40.08           N  
ATOM     18  CA  LEU     7      46.722  28.728   7.677  1.00 40.61           C  
ATOM     19  C   LEU     7      45.600  28.932   8.688  1.00 41.15           C  
ATOM     20  O   LEU     7      44.546  28.297   8.592  1.00 40.41           O  
ATOM     21  CB  LEU     7      46.399  29.569   6.436  1.00 40.38           C  
ATOM     22  CG  LEU     7      47.368  29.613   5.253  1.00 40.99           C  
ATOM     23  CD1 LEU     7      46.776  30.487   4.151  1.00 40.42           C  
ATOM     24  CD2 LEU     7      48.755  30.110   5.651  1.00 40.43           C  
ATOM     25  N   GLN     8      45.822  29.829   9.645  1.00 42.24           N  
ATOM     26  CA  GLN     8      44.777  30.227  10.594  0.50 42.53           C  
ATOM     28  C   GLN     8      43.743  31.071   9.854  1.00 42.85           C  
ATOM     29  O   GLN     8      44.022  31.579   8.770  1.00 42.28           O  
ATOM     30  CB  GLN     8      45.380  31.029  11.755  0.50 42.65           C  
ATOM     32  CG  GLN     8      46.000  30.178  12.865  0.50 42.48           C  
ATOM     34  CD  GLN     8      46.979  30.965  13.716  0.50 41.89           C  
ATOM     36  OE1 GLN     8      47.364  32.081  13.364  0.50 41.95           O  
ATOM     38  NE2 GLN     8      47.383  30.391  14.844  0.50 42.22           N  
ATOM     40  N   PRO     9      42.535  31.223  10.429  1.00 43.65           N  
ATOM     41  CA  PRO     9      41.490  32.001   9.715  1.00 44.43           C  
ATOM     42  C   PRO     9      41.901  33.416   9.236  1.00 44.22           C  
ATOM     43  O   PRO     9      41.615  33.806   8.091  1.00 43.49           O  
ATOM     44  CB  PRO     9      40.349  32.054  10.740  1.00 44.78           C  
ATOM     45  CG  PRO     9      40.523  30.818  11.560  1.00 44.24           C  
ATOM     46  CD  PRO     9      42.019  30.661  11.700  1.00 43.75           C  
ATOM     47  N   GLY    10      42.574  34.186  10.086  1.00 44.09           N  
ATOM     48  CA  GLY    10      43.013  35.529   9.648  1.00 43.34           C  
ATOM     49  C   GLY    10      44.032  35.469   8.522  1.00 42.61           C  
ATOM     50  O   GLY    10      44.066  36.326   7.604  1.00 41.75           O  
ATOM     51  N   GLN    11      44.888  34.449   8.568  1.00 41.40           N  
ATOM     52  CA  GLN    11      45.884  34.302   7.538  1.00 40.04           C  
ATOM     53  C   GLN    11      45.242  33.961   6.211  1.00 38.83           C  
ATOM     54  O   GLN    11      45.787  34.295   5.169  1.00 39.89           O  
ATOM     55  CB  GLN    11      46.923  33.237   7.912  1.00 40.06           C  
ATOM     56  CG  GLN    11      47.873  33.655   9.035  1.00 40.33           C  
ATOM     57  CD  GLN    11      48.812  32.554   9.432  1.00 39.18           C  
ATOM     58  OE1 GLN    11      48.393  31.427   9.692  1.00 35.18           O  
ATOM     59  NE2 GLN    11      50.104  32.878   9.507  1.00 42.19           N  
ATOM     60  N   ARG    12      44.143  33.225   6.264  1.00 38.76           N  
ATOM     61  CA  ARG    12      43.395  32.852   5.071  1.00 37.01           C  
ATOM     62  C   ARG    12      42.862  34.084   4.372  1.00 34.65           C  
ATOM     63  O   ARG    12      43.071  34.264   3.181  1.00 34.81           O  
ATOM     64  CB  ARG    12      42.259  31.896   5.463  1.00 37.53           C  
ATOM     65  CG  ARG    12      42.702  30.436   5.681  1.00 38.59           C  
ATOM     66  CD  ARG    12      41.510  29.554   5.999  1.00 40.97           C  
ATOM     67  NE  ARG    12      41.799  28.128   5.848  1.00 43.25           N  
ATOM     68  CZ  ARG    12      41.525  27.376   4.772  1.00 44.47           C  
ATOM     69  NH1 ARG    12      41.831  26.083   4.792  1.00 45.36           N  
ATOM     70  NH2 ARG    12      40.948  27.879   3.678  1.00 44.66           N  
ATOM     71  N   LEU    13      42.158  34.928   5.123  1.00 32.91           N  
ATOM     72  CA  LEU    13      41.636  36.175   4.576  1.00 32.29           C  
ATOM     73  C   LEU    13      42.781  37.003   3.992  1.00 31.74           C  
ATOM     74  O   LEU    13      42.652  37.507   2.888  1.00 32.08           O  
ATOM     75  CB  LEU    13      40.873  36.994   5.637  1.00 32.92           C  
ATOM     76  CG  LEU    13      39.624  36.366   6.268  1.00 32.94           C  
ATOM     77  CD1 LEU    13      39.141  37.186   7.487  1.00 32.58           C  
ATOM     78  CD2 LEU    13      38.540  36.270   5.227  1.00 33.66           C  
ATOM     79  N   ALA    14      43.911  37.089   4.709  1.00 30.28           N  
ATOM     80  CA  ALA    14      45.002  37.910   4.250  1.00 30.35           C  
ATOM     81  C   ALA    14      45.583  37.382   2.911  1.00 29.01           C  
ATOM     82  O   ALA    14      46.110  38.152   2.106  1.00 29.67           O  
ATOM     83  CB  ALA    14      46.100  38.001   5.295  1.00 28.79           C  
ATOM     84  N   ARG    15      45.564  36.067   2.742  1.00 29.40           N  
ATOM     85  CA  ARG    15      46.005  35.465   1.454  1.00 29.83           C  
ATOM     86  C   ARG    15      45.180  35.916   0.310  1.00 29.24           C  
ATOM     87  O   ARG    15      45.718  36.353  -0.705  1.00 29.13           O  
ATOM     88  CB  ARG    15      46.007  33.936   1.546  1.00 30.37           C  
ATOM     89  CG  ARG    15      46.706  33.192   0.384  1.00 33.54           C  
ATOM     90  CD  ARG    15      46.524  31.724   0.763  1.00 39.34           C  
ATOM     91  NE  ARG    15      47.240  30.768  -0.023  1.00 41.73           N  
ATOM     92  CZ  ARG    15      46.689  29.951  -0.914  1.00 45.31           C  
ATOM     93  NH1 ARG    15      47.475  29.075  -1.533  1.00 45.52           N  
ATOM     94  NH2 ARG    15      45.386  30.002  -1.208  1.00 44.25           N  
ATOM     95  N   GLY    16      43.861  35.891   0.491  1.00 30.12           N  
ATOM     96  CA  GLY    16      42.936  36.343  -0.551  1.00 29.24           C  
ATOM     97  C   GLY    16      43.027  37.801  -0.808  1.00 29.52           C  
ATOM     98  O   GLY    16      43.063  38.242  -1.969  1.00 28.36           O  
ATOM     99  N   VAL    17      43.194  38.586   0.266  1.00 28.25           N  
ATOM    100  CA  VAL    17      43.387  40.014   0.101  1.00 27.59           C  
ATOM    101  C   VAL    17      44.646  40.337  -0.728  1.00 28.51           C  
ATOM    102  O   VAL    17      44.596  41.192  -1.661  1.00 28.26           O  
ATOM    103  CB  VAL    17      43.427  40.759   1.499  1.00 26.92           C  
ATOM    104  CG1 VAL    17      43.811  42.212   1.297  1.00 28.67           C  
ATOM    105  CG2 VAL    17      42.063  40.649   2.219  1.00 28.70           C  
ATOM    106  N   ALA    18      45.763  39.686  -0.367  1.00 28.55           N  
ATOM    107  CA  ALA    18      47.044  39.873  -1.053  1.00 27.98           C  
ATOM    108  C   ALA    18      46.959  39.510  -2.562  1.00 28.27           C  
ATOM    109  O   ALA    18      47.528  40.229  -3.403  1.00 27.57           O  
ATOM    110  CB  ALA    18      48.130  39.095  -0.372  1.00 27.73           C  
ATOM    111  N   ARG    19      46.283  38.412  -2.870  1.00 30.15           N  
ATOM    112  CA  ARG    19      46.061  38.000  -4.298  1.00 30.28           C  
ATOM    113  C   ARG    19      45.359  39.097  -5.014  1.00 30.51           C  
ATOM    114  O   ARG    19      45.758  39.480  -6.116  1.00 31.11           O  
ATOM    115  CB  ARG    19      45.260  36.717  -4.396  1.00 30.44           C  
ATOM    116  CG  ARG    19      45.997  35.514  -3.985  1.00 32.15           C  
ATOM    117  CD  ARG    19      45.114  34.276  -3.945  1.00 30.90           C  
ATOM    118  NE  ARG    19      45.927  33.072  -3.860  1.00 30.71           N  
ATOM    119  CZ  ARG    19      45.606  31.900  -4.405  1.00 34.06           C  
ATOM    120  NH1 ARG    19      44.443  31.701  -5.024  1.00 34.11           N  
ATOM    121  NH2 ARG    19      46.432  30.889  -4.286  1.00 36.45           N  
ATOM    122  N   HIS    20      44.283  39.638  -4.396  1.00 31.84           N  
ATOM    123  CA  HIS    20      43.448  40.623  -5.069  1.00 30.13           C  
ATOM    124  C   HIS    20      44.146  41.962  -5.243  1.00 29.99           C  
ATOM    125  O   HIS    20      44.067  42.583  -6.320  1.00 29.25           O  
ATOM    126  CB  HIS    20      42.099  40.805  -4.311  1.00 32.18           C  
ATOM    127  CG  HIS    20      41.118  41.669  -5.043  1.00 32.57           C  
ATOM    128  ND1 HIS    20      40.643  41.347  -6.295  1.00 33.23           N  
ATOM    129  CD2 HIS    20      40.597  42.888  -4.744  1.00 33.95           C  
ATOM    130  CE1 HIS    20      39.823  42.289  -6.703  1.00 33.99           C  
ATOM    131  NE2 HIS    20      39.783  43.238  -5.787  1.00 34.24           N  
ATOM    132  N   LEU    21      44.868  42.414  -4.211  1.00 28.80           N  
ATOM    133  CA  LEU    21      45.686  43.625  -4.315  1.00 30.87           C  
ATOM    134  C   LEU    21      46.682  43.491  -5.482  1.00 29.17           C  
ATOM    135  O   LEU    21      46.804  44.376  -6.308  1.00 29.80           O  
ATOM    136  CB  LEU    21      46.482  43.894  -3.033  1.00 30.12           C  
ATOM    137  CG  LEU    21      45.643  44.421  -1.869  1.00 34.58           C  
ATOM    138  CD1 LEU    21      46.525  44.462  -0.604  1.00 34.39           C  
ATOM    139  CD2 LEU    21      45.094  45.789  -2.178  1.00 36.07           C  
ATOM    140  N   ARG    22      47.320  42.351  -5.570  1.00 30.71           N  
ATOM    141  CA  ARG    22      48.371  42.149  -6.583  1.00 30.39           C  
ATOM    142  C   ARG    22      47.770  42.163  -8.013  1.00 30.86           C  
ATOM    143  O   ARG    22      48.362  42.730  -8.958  1.00 30.07           O  
ATOM    144  CB  ARG    22      49.180  40.892  -6.278  1.00 30.93           C  
ATOM    145  CG  ARG    22      50.300  40.579  -7.284  1.00 33.89           C  
ATOM    146  CD  ARG    22      50.938  39.237  -7.047  1.00 35.51           C  
ATOM    147  NE  ARG    22      51.936  39.087  -8.082  1.00 34.57           N  
ATOM    148  CZ  ARG    22      53.195  38.696  -7.913  1.00 35.50           C  
ATOM    149  NH1 ARG    22      53.656  38.311  -6.722  1.00 33.15           N  
ATOM    150  NH2 ARG    22      53.992  38.675  -8.980  1.00 34.96           N  
ATOM    151  N   ALA    23      46.619  41.553  -8.157  1.00 31.76           N  
ATOM    152  CA  ALA    23      45.849  41.569  -9.439  1.00 32.88           C  
ATOM    153  C   ALA    23      45.550  42.992  -9.922  1.00 34.72           C  
ATOM    154  O   ALA    23      45.422  43.265 -11.137  1.00 34.07           O  
ATOM    155  CB  ALA    23      44.571  40.794  -9.272  1.00 32.37           C  
ATOM    156  N   HIS    24      45.474  43.934  -8.975  1.00 36.04           N  
ATOM    157  CA  HIS    24      45.250  45.334  -9.327  1.00 36.14           C  
ATOM    158  C   HIS    24      46.427  46.284  -9.110  1.00 36.10           C  
ATOM    159  O   HIS    24      46.213  47.500  -8.923  1.00 36.57           O  
ATOM    160  CB  HIS    24      44.025  45.790  -8.591  1.00 36.62           C  
ATOM    161  CG  HIS    24      42.773  45.148  -9.090  1.00 39.20           C  
ATOM    162  ND1 HIS    24      42.127  45.574 -10.237  1.00 41.39           N  
ATOM    163  CD2 HIS    24      42.067  44.098  -8.626  1.00 39.99           C  
ATOM    164  CE1 HIS    24      41.058  44.825 -10.430  1.00 39.92           C  
ATOM    165  NE2 HIS    24      40.992  43.935  -9.463  1.00 41.57           N  
ATOM    166  N   GLY    25      47.648  45.767  -9.216  1.00 34.51           N  
ATOM    167  CA  GLY    25      48.872  46.573  -9.196  1.00 34.38           C  
ATOM    168  C   GLY    25      49.382  47.076  -7.851  1.00 33.84           C  
ATOM    169  O   GLY    25      50.367  47.828  -7.794  1.00 34.39           O  
ATOM    170  N   PHE    26      48.728  46.641  -6.770  1.00 33.03           N  
ATOM    171  CA  PHE    26      49.200  46.859  -5.425  1.00 32.41           C  
ATOM    172  C   PHE    26      50.146  45.720  -5.008  1.00 32.82           C  
ATOM    173  O   PHE    26      50.234  44.666  -5.664  1.00 32.25           O  
ATOM    174  CB  PHE    26      48.025  46.976  -4.449  1.00 32.87           C  
ATOM    175  CG  PHE    26      47.435  48.362  -4.362  1.00 32.59           C  
ATOM    176  CD1 PHE    26      46.831  48.948  -5.485  1.00 34.19           C  
ATOM    177  CD2 PHE    26      47.400  49.042  -3.149  1.00 32.00           C  
ATOM    178  CE1 PHE    26      46.270  50.199  -5.411  1.00 37.10           C  
ATOM    179  CE2 PHE    26      46.877  50.306  -3.076  1.00 33.19           C  
ATOM    180  CZ  PHE    26      46.282  50.893  -4.197  1.00 35.86           C  
ATOM    181  N   VAL    27      50.932  45.975  -3.970  1.00 30.86           N  
ATOM    182  CA  VAL    27      51.683  44.924  -3.297  1.00 29.69           C  
ATOM    183  C   VAL    27      51.322  44.998  -1.817  1.00 29.17           C  
ATOM    184  O   VAL    27      50.713  45.972  -1.374  1.00 30.58           O  
ATOM    185  CB  VAL    27      53.209  45.090  -3.475  1.00 29.88           C  
ATOM    186  CG1 VAL    27      53.601  44.831  -4.983  1.00 29.49           C  
ATOM    187  CG2 VAL    27      53.673  46.482  -3.043  1.00 28.47           C  
ATOM    188  N   SER    28      51.737  44.016  -1.055  1.00 28.60           N  
ATOM    189  CA  SER    28      51.295  43.942   0.339  1.00 27.97           C  
ATOM    190  C   SER    28      52.312  43.216   1.192  1.00 26.85           C  
ATOM    191  O   SER    28      53.161  42.470   0.690  1.00 26.63           O  
ATOM    192  CB  SER    28      49.943  43.289   0.447  1.00 27.40           C  
ATOM    193  OG  SER    28      49.995  41.929   0.001  1.00 28.09           O  
ATOM    194  N   VAL    29      52.217  43.471   2.498  1.00 26.32           N  
ATOM    195  CA  VAL    29      52.868  42.663   3.499  1.00 26.09           C  
ATOM    196  C   VAL    29      51.869  42.358   4.612  1.00 26.69           C  
ATOM    197  O   VAL    29      50.835  43.029   4.767  1.00 25.06           O  
ATOM    198  CB  VAL    29      54.155  43.294   4.125  1.00 25.96           C  
ATOM    199  CG1 VAL    29      55.258  43.478   3.036  1.00 26.47           C  
ATOM    200  CG2 VAL    29      53.900  44.569   4.878  1.00 24.70           C  
ATOM    201  N   GLU    30      52.207  41.357   5.394  1.00 26.99           N  
ATOM    202  CA  GLU    30      51.408  41.000   6.527  1.00 28.70           C  
ATOM    203  C   GLU    30      52.057  41.354   7.867  1.00 27.60           C  
ATOM    204  O   GLU    30      53.291  41.412   8.015  1.00 27.17           O  
ATOM    205  CB  GLU    30      51.109  39.498   6.493  1.00 29.53           C  
ATOM    206  CG  GLU    30      50.082  39.067   5.504  1.00 35.04           C  
ATOM    207  CD  GLU    30      49.665  37.586   5.712  1.00 43.13           C  
ATOM    208  OE1 GLU    30      49.320  37.173   6.875  1.00 48.65           O  
ATOM    209  OE2 GLU    30      49.648  36.838   4.713  1.00 39.81           O  
ATOM    210  N   GLU    31      51.198  41.593   8.857  1.00 27.51           N  
ATOM    211  CA  GLU    31      51.636  41.860  10.236  0.50 27.73           C  
ATOM    213  C   GLU    31      52.614  43.012  10.285  1.00 26.70           C  
ATOM    214  O   GLU    31      53.692  42.906  10.816  1.00 26.95           O  
ATOM    215  CB  GLU    31      52.244  40.596  10.829  0.50 28.41           C  
ATOM    217  CG  GLU    31      51.309  39.425  10.700  0.50 31.21           C  
ATOM    219  CD  GLU    31      51.797  38.212  11.432  0.50 35.16           C  
ATOM    221  OE1 GLU    31      52.986  37.874  11.284  0.50 39.43           O  
ATOM    223  OE2 GLU    31      50.974  37.584  12.139  0.50 39.69           O  
ATOM    225  N   PHE    32      52.203  44.124   9.708  1.00 26.33           N  
ATOM    226  CA  PHE    32      53.002  45.304   9.636  1.00 25.68           C  
ATOM    227  C   PHE    32      52.885  46.230  10.859  1.00 24.65           C  
ATOM    228  O   PHE    32      51.773  46.526  11.312  1.00 24.12           O  
ATOM    229  CB  PHE    32      52.590  46.095   8.426  1.00 25.46           C  
ATOM    230  CG  PHE    32      53.404  47.298   8.222  1.00 24.52           C  
ATOM    231  CD1 PHE    32      52.884  48.541   8.491  1.00 25.16           C  
ATOM    232  CD2 PHE    32      54.720  47.194   7.800  1.00 25.34           C  
ATOM    233  CE1 PHE    32      53.623  49.672   8.297  1.00 26.20           C  
ATOM    234  CE2 PHE    32      55.472  48.331   7.635  1.00 25.96           C  
ATOM    235  CZ  PHE    32      54.918  49.579   7.866  1.00 25.05           C  
ATOM    236  N   VAL    33      54.016  46.731  11.327  1.00 24.23           N  
ATOM    237  CA  VAL    33      54.088  47.595  12.530  1.00 23.50           C  
ATOM    238  C   VAL    33      54.357  49.052  12.142  1.00 24.37           C  
ATOM    239  O   VAL    33      55.509  49.435  11.869  1.00 24.23           O  
ATOM    240  CB  VAL    33      55.151  47.131  13.517  1.00 24.23           C  
ATOM    241  CG1 VAL    33      55.280  48.117  14.691  1.00 22.24           C  
ATOM    242  CG2 VAL    33      54.843  45.743  14.017  1.00 24.19           C  
ATOM    243  N   PRO    34      53.306  49.884  12.111  1.00 24.54           N  
ATOM    244  CA  PRO    34      53.506  51.294  11.752  1.00 25.71           C  
ATOM    245  C   PRO    34      54.085  52.172  12.867  1.00 26.84           C  
ATOM    246  O   PRO    34      54.626  53.251  12.588  1.00 27.21           O  
ATOM    247  CB  PRO    34      52.098  51.740  11.346  1.00 25.67           C  
ATOM    248  CG  PRO    34      51.161  50.843  12.130  1.00 25.17           C  
ATOM    249  CD  PRO    34      51.885  49.550  12.356  1.00 25.17           C  
ATOM    250  N   ALA    35      53.966  51.715  14.109  1.00 27.43           N  
ATOM    251  CA  ALA    35      54.412  52.460  15.275  1.00 29.07           C  
ATOM    252  C   ALA    35      54.355  51.486  16.435  1.00 29.37           C  
ATOM    253  O   ALA    35      53.620  50.492  16.383  1.00 27.54           O  
ATOM    254  CB  ALA    35      53.500  53.676  15.555  1.00 29.70           C  
ATOM    255  N   ARG    36      55.150  51.776  17.457  1.00 29.82           N  
ATOM    256  CA  ARG    36      55.188  50.979  18.677  1.00 30.96           C  
ATOM    257  C   ARG    36      53.791  50.685  19.158  1.00 31.11           C  
ATOM    258  O   ARG    36      52.973  51.593  19.233  1.00 31.88           O  
ATOM    259  CB  ARG    36      55.896  51.743  19.794  1.00 31.37           C  
ATOM    260  CG  ARG    36      57.369  51.514  19.876  1.00 33.43           C  
ATOM    261  CD  ARG    36      57.850  51.860  21.265  1.00 34.81           C  
ATOM    262  NE  ARG    36      59.263  51.560  21.469  1.00 36.64           N  
ATOM    263  CZ  ARG    36      59.757  50.402  21.907  1.00 37.17           C  
ATOM    264  NH1 ARG    36      58.960  49.382  22.198  1.00 37.94           N  
ATOM    265  NH2 ARG    36      61.069  50.274  22.059  1.00 38.12           N  
ATOM    266  N   GLY    37      53.529  49.430  19.510  1.00 31.00           N  
ATOM    267  CA  GLY    37      52.245  49.046  20.079  1.00 30.64           C  
ATOM    268  C   GLY    37      51.116  48.804  19.096  1.00 30.47           C  
ATOM    269  O   GLY    37      50.028  48.446  19.510  1.00 30.27           O  
ATOM    270  N   LEU    38      51.349  48.994  17.798  1.00 30.30           N  
ATOM    271  CA  LEU    38      50.332  48.695  16.792  1.00 30.44           C  
ATOM    272  C   LEU    38      50.824  47.654  15.805  1.00 29.85           C  
ATOM    273  O   LEU    38      52.008  47.579  15.498  1.00 27.66           O  
ATOM    274  CB  LEU    38      49.958  49.950  15.999  1.00 30.96           C  
ATOM    275  CG  LEU    38      49.282  51.087  16.761  1.00 34.65           C  
ATOM    276  CD1 LEU    38      49.226  52.317  15.860  1.00 37.20           C  
ATOM    277  CD2 LEU    38      47.864  50.657  17.221  1.00 37.06           C  
ATOM    278  N   ARG    39      49.894  46.878  15.287  1.00 30.06           N  
ATOM    279  CA  ARG    39      50.195  45.952  14.207  1.00 30.98           C  
ATOM    280  C   ARG    39      48.987  45.811  13.308  1.00 30.64           C  
ATOM    281  O   ARG    39      47.862  45.679  13.803  1.00 30.53           O  
ATOM    282  CB  ARG    39      50.602  44.602  14.753  1.00 31.70           C  
ATOM    283  CG  ARG    39      51.344  43.770  13.727  1.00 36.13           C  
ATOM    284  CD  ARG    39      51.801  42.461  14.311  1.00 41.67           C  
ATOM    285  NE  ARG    39      50.644  41.636  14.613  1.00 46.35           N  
ATOM    286  CZ  ARG    39      50.683  40.374  15.039  1.00 52.33           C  
ATOM    287  NH1 ARG    39      51.852  39.736  15.191  1.00 53.52           N  
ATOM    288  NH2 ARG    39      49.527  39.738  15.289  1.00 53.35           N  
ATOM    289  N   VAL    40      49.193  45.911  11.997  1.00 29.25           N  
ATOM    290  CA  VAL    40      48.084  45.806  11.073  1.00 29.29           C  
ATOM    291  C   VAL    40      48.180  44.491  10.303  1.00 29.28           C  
ATOM    292  O   VAL    40      49.260  44.038   9.971  1.00 28.16           O  
ATOM    293  CB  VAL    40      47.979  47.025  10.097  1.00 30.38           C  
ATOM    294  CG1 VAL    40      48.048  48.386  10.835  1.00 30.15           C  
ATOM    295  CG2 VAL    40      48.965  46.949   9.024  1.00 31.10           C  
ATOM    296  N   ASP    41      47.031  43.890  10.016  1.00 28.82           N  
ATOM    297  CA  ASP    41      46.989  42.539   9.423  1.00 28.90           C  
ATOM    298  C   ASP    41      47.559  42.493   7.997  1.00 29.20           C  
ATOM    299  O   ASP    41      48.356  41.616   7.681  1.00 28.96           O  
ATOM    300  CB  ASP    41      45.553  42.025   9.428  1.00 29.05           C  
ATOM    301  CG  ASP    41      45.003  41.835  10.844  1.00 29.68           C  
ATOM    302  OD1 ASP    41      45.807  41.624  11.776  1.00 28.41           O  
ATOM    303  OD2 ASP    41      43.761  41.888  10.974  1.00 29.44           O  
ATOM    304  N   VAL    42      47.146  43.451   7.170  1.00 29.53           N  
ATOM    305  CA  VAL    42      47.725  43.629   5.860  1.00 29.37           C  
ATOM    306  C   VAL    42      47.958  45.118   5.626  1.00 29.29           C  
ATOM    307  O   VAL    42      47.066  45.944   5.858  1.00 28.58           O  
ATOM    308  CB  VAL    42      46.839  43.039   4.739  1.00 30.24           C  
ATOM    309  CG1 VAL    42      47.444  43.342   3.341  1.00 29.49           C  
ATOM    310  CG2 VAL    42      46.690  41.534   4.922  1.00 29.51           C  
ATOM    311  N   MET    43      49.169  45.445   5.159  1.00 28.21           N  
ATOM    312  CA  MET    43      49.415  46.759   4.580  1.00 28.70           C  
ATOM    313  C   MET    43      49.538  46.629   3.083  1.00 29.05           C  
ATOM    314  O   MET    43      50.300  45.777   2.615  1.00 28.30           O  
ATOM    315  CB  MET    43      50.658  47.424   5.172  1.00 27.94           C  
ATOM    316  CG  MET    43      50.883  48.859   4.561  1.00 31.25           C  
ATOM    317  SD  MET    43      52.353  49.878   5.187  0.65 32.79          SE  
ATOM    318  CE  MET    43      52.924  50.775   3.501  1.00 36.03           C  
ATOM    319  N   GLY    44      48.790  47.465   2.347  1.00 29.66           N  
ATOM    320  CA  GLY    44      48.888  47.517   0.887  1.00 29.92           C  
ATOM    321  C   GLY    44      49.589  48.774   0.442  1.00 30.19           C  
ATOM    322  O   GLY    44      49.381  49.850   1.036  1.00 29.23           O  
ATOM    323  N   LEU    45      50.448  48.642  -0.590  1.00 30.88           N  
ATOM    324  CA  LEU    45      51.158  49.743  -1.171  1.00 31.78           C  
ATOM    325  C   LEU    45      50.853  49.835  -2.667  1.00 32.94           C  
ATOM    326  O   LEU    45      51.083  48.871  -3.439  1.00 32.14           O  
ATOM    327  CB  LEU    45      52.661  49.601  -0.943  1.00 31.03           C  
ATOM    328  CG  LEU    45      53.568  50.630  -1.591  1.00 32.51           C  
ATOM    329  CD1 LEU    45      53.290  52.041  -1.032  1.00 29.99           C  
ATOM    330  CD2 LEU    45      55.079  50.228  -1.445  1.00 29.43           C  
ATOM    331  N   GLY    46      50.318  50.986  -3.040  1.00 34.05           N  
ATOM    332  CA  GLY    46      49.879  51.284  -4.410  1.00 35.87           C  
ATOM    333  C   GLY    46      51.019  51.765  -5.274  1.00 37.83           C  
ATOM    334  O   GLY    46      52.109  52.125  -4.761  1.00 38.53           O  
ATOM    335  N   PRO    47      50.825  51.719  -6.603  1.00 39.46           N  
ATOM    336  CA  PRO    47      51.963  52.055  -7.492  1.00 40.90           C  
ATOM    337  C   PRO    47      52.426  53.525  -7.400  1.00 42.26           C  
ATOM    338  O   PRO    47      53.544  53.846  -7.840  1.00 43.50           O  
ATOM    339  CB  PRO    47      51.435  51.731  -8.910  1.00 40.67           C  
ATOM    340  CG  PRO    47      49.957  51.675  -8.775  1.00 40.80           C  
ATOM    341  CD  PRO    47      49.632  51.293  -7.341  1.00 38.82           C  
ATOM    342  N   LYS    48      51.595  54.390  -6.829  1.00 42.99           N  
ATOM    343  CA  LYS    48      51.946  55.797  -6.637  1.00 43.80           C  
ATOM    344  C   LYS    48      52.193  56.090  -5.162  1.00 42.11           C  
ATOM    345  O   LYS    48      52.254  57.247  -4.766  1.00 41.20           O  
ATOM    346  CB  LYS    48      50.823  56.696  -7.171  1.00 45.43           C  
ATOM    347  CG  LYS    48      50.573  56.567  -8.695  1.00 49.60           C  
ATOM    348  CD  LYS    48      49.446  57.511  -9.190  1.00 54.59           C  
ATOM    349  CE  LYS    48      48.163  56.754  -9.578  1.00 57.03           C  
ATOM    350  NZ  LYS    48      48.451  55.682 -10.606  1.00 58.42           N  
ATOM    351  N   GLY    49      52.349  55.039  -4.357  1.00 39.55           N  
ATOM    352  CA  GLY    49      52.672  55.189  -2.959  1.00 37.96           C  
ATOM    353  C   GLY    49      51.472  55.318  -2.034  1.00 36.76           C  
ATOM    354  O   GLY    49      51.631  55.663  -0.895  1.00 35.86           O  
ATOM    355  N   GLU    50      50.286  54.994  -2.516  1.00 35.39           N  
ATOM    356  CA  GLU    50      49.063  54.967  -1.695  1.00 36.06           C  
ATOM    357  C   GLU    50      49.233  53.877  -0.595  1.00 34.85           C  
ATOM    358  O   GLU    50      49.797  52.810  -0.849  1.00 34.55           O  
ATOM    359  CB  GLU    50      47.843  54.679  -2.589  1.00 36.91           C  
ATOM    360  CG  GLU    50      47.721  55.553  -3.900  1.00 42.02           C  
ATOM    361  CD  GLU    50      48.240  54.853  -5.207  1.00 46.63           C  
ATOM    362  OE1 GLU    50      47.541  54.840  -6.245  1.00 54.54           O  
ATOM    363  OE2 GLU    50      49.329  54.311  -5.222  1.00 41.20           O  
ATOM    364  N   ILE    51      48.834  54.170   0.638  1.00 32.72           N  
ATOM    365  CA  ILE    51      48.962  53.206   1.739  1.00 31.02           C  
ATOM    366  C   ILE    51      47.550  52.829   2.220  1.00 30.71           C  
ATOM    367  O   ILE    51      46.739  53.693   2.571  1.00 29.10           O  
ATOM    368  CB  ILE    51      49.842  53.760   2.910  1.00 31.37           C  
ATOM    369  CG1 ILE    51      51.291  53.948   2.439  1.00 33.61           C  
ATOM    370  CG2 ILE    51      49.866  52.793   4.125  1.00 29.15           C  
ATOM    371  CD1 ILE    51      52.022  55.011   3.209  1.00 36.59           C  
ATOM    372  N   TRP    52      47.278  51.515   2.200  1.00 30.35           N  
ATOM    373  CA  TRP    52      46.037  50.925   2.665  1.00 30.78           C  
ATOM    374  C   TRP    52      46.306  50.010   3.836  1.00 29.52           C  
ATOM    375  O   TRP    52      47.279  49.268   3.846  1.00 29.52           O  
ATOM    376  CB  TRP    52      45.424  50.083   1.556  1.00 31.80           C  
ATOM    377  CG  TRP    52      44.858  50.853   0.411  1.00 32.99           C  
ATOM    378  CD1 TRP    52      45.021  52.174   0.125  1.00 34.79           C  
ATOM    379  CD2 TRP    52      44.058  50.312  -0.642  1.00 33.33           C  
ATOM    380  NE1 TRP    52      44.387  52.489  -1.058  1.00 35.95           N  
ATOM    381  CE2 TRP    52      43.779  51.360  -1.540  1.00 36.05           C  
ATOM    382  CE3 TRP    52      43.586  49.048  -0.923  1.00 33.32           C  
ATOM    383  CZ2 TRP    52      43.012  51.183  -2.686  1.00 34.77           C  
ATOM    384  CZ3 TRP    52      42.800  48.874  -2.076  1.00 34.80           C  
ATOM    385  CH2 TRP    52      42.536  49.944  -2.927  1.00 35.32           C  
ATOM    386  N   VAL    53      45.469  50.098   4.847  1.00 29.67           N  
ATOM    387  CA  VAL    53      45.486  49.168   5.949  1.00 28.16           C  
ATOM    388  C   VAL    53      44.216  48.335   5.810  1.00 28.83           C  
ATOM    389  O   VAL    53      43.091  48.875   5.642  1.00 26.41           O  
ATOM    390  CB  VAL    53      45.524  49.899   7.297  1.00 29.11           C  
ATOM    391  CG1 VAL    53      45.002  48.988   8.448  1.00 27.78           C  
ATOM    392  CG2 VAL    53      46.940  50.456   7.540  1.00 28.12           C  
ATOM    393  N   ILE    54      44.398  47.020   5.880  1.00 28.50           N  
ATOM    394  CA  ILE    54      43.285  46.084   5.847  1.00 29.08           C  
ATOM    395  C   ILE    54      43.358  45.195   7.076  1.00 28.55           C  
ATOM    396  O   ILE    54      44.330  44.453   7.275  1.00 28.15           O  
ATOM    397  CB  ILE    54      43.272  45.213   4.565  1.00 29.43           C  
ATOM    398  CG1 ILE    54      43.212  46.102   3.335  1.00 31.46           C  
ATOM    399  CG2 ILE    54      42.083  44.228   4.538  1.00 30.38           C  
ATOM    400  CD1 ILE    54      44.488  46.089   2.575  1.00 34.04           C  
ATOM    401  N   GLU    55      42.313  45.285   7.902  1.00 26.85           N  
ATOM    402  CA  GLU    55      42.162  44.439   9.044  1.00 26.66           C  
ATOM    403  C   GLU    55      41.252  43.269   8.697  1.00 28.23           C  
ATOM    404  O   GLU    55      40.051  43.473   8.371  1.00 28.33           O  
ATOM    405  CB  GLU    55      41.580  45.241  10.223  1.00 26.95           C  
ATOM    406  CG  GLU    55      42.539  46.184  10.860  1.00 26.27           C  
ATOM    407  CD  GLU    55      43.671  45.464  11.554  1.00 28.92           C  
ATOM    408  OE1 GLU    55      43.450  44.953  12.672  1.00 30.37           O  
ATOM    409  OE2 GLU    55      44.779  45.412  10.987  1.00 26.72           O  
ATOM    410  N   CYS    56      41.792  42.077   8.878  1.00 29.07           N  
ATOM    411  CA  CYS    56      41.168  40.830   8.506  1.00 30.82           C  
ATOM    412  C   CYS    56      40.524  40.220   9.729  1.00 30.88           C  
ATOM    413  O   CYS    56      41.192  39.664  10.573  1.00 31.72           O  
ATOM    414  CB  CYS    56      42.194  39.878   7.881  1.00 30.80           C  
ATOM    415  SG  CYS    56      42.965  40.559   6.395  1.00 33.27           S  
ATOM    416  N   LYS    57      39.200  40.314   9.830  1.00 31.20           N  
ATOM    417  CA  LYS    57      38.504  39.778  10.992  1.00 32.78           C  
ATOM    418  C   LYS    57      37.786  38.473  10.639  1.00 33.46           C  
ATOM    419  O   LYS    57      36.905  38.436   9.806  1.00 32.62           O  
ATOM    420  CB  LYS    57      37.546  40.818  11.544  1.00 32.90           C  
ATOM    421  CG  LYS    57      38.238  42.112  11.931  1.00 35.60           C  
ATOM    422  CD  LYS    57      39.230  41.804  13.049  1.00 38.77           C  
ATOM    423  CE  LYS    57      39.999  42.990  13.468  1.00 42.21           C  
ATOM    424  NZ  LYS    57      40.988  42.670  14.570  1.00 43.45           N  
ATOM    425  N   SER    58      38.177  37.406  11.314  1.00 34.39           N  
ATOM    426  CA  SER    58      37.759  36.075  10.947  1.00 35.27           C  
ATOM    427  C   SER    58      36.486  35.655  11.695  1.00 35.26           C  
ATOM    428  O   SER    58      35.881  34.626  11.349  1.00 35.69           O  
ATOM    429  CB  SER    58      38.909  35.128  11.231  1.00 35.37           C  
ATOM    430  OG  SER    58      39.287  35.218  12.615  1.00 40.50           O  
ATOM    431  N   SER    59      36.088  36.486  12.679  1.00 34.46           N  
ATOM    432  CA  SER    59      34.943  36.235  13.568  0.50 34.53           C  
ATOM    434  C   SER    59      34.438  37.565  14.128  1.00 34.32           C  
ATOM    435  O   SER    59      35.182  38.525  14.196  1.00 33.74           O  
ATOM    436  CB  SER    59      35.378  35.365  14.771  0.50 34.93           C  
ATOM    438  OG  SER    59      34.823  34.065  14.735  0.50 34.74           O  
ATOM    440  N   ARG    60      33.193  37.599  14.584  1.00 35.75           N  
ATOM    441  CA  ARG    60      32.698  38.720  15.407  1.00 36.62           C  
ATOM    442  C   ARG    60      33.565  39.036  16.632  1.00 36.50           C  
ATOM    443  O   ARG    60      33.778  40.208  16.965  1.00 36.82           O  
ATOM    444  CB  ARG    60      31.297  38.420  15.900  1.00 37.23           C  
ATOM    445  CG  ARG    60      30.263  38.651  14.860  1.00 38.79           C  
ATOM    446  CD  ARG    60      28.912  38.625  15.475  1.00 40.20           C  
ATOM    447  NE  ARG    60      28.666  39.815  16.293  1.00 41.47           N  
ATOM    448  CZ  ARG    60      27.469  40.177  16.734  1.00 42.08           C  
ATOM    449  NH1 ARG    60      26.401  39.449  16.442  1.00 43.37           N  
ATOM    450  NH2 ARG    60      27.334  41.270  17.477  1.00 44.05           N  
ATOM    451  N   ALA    61      34.067  38.001  17.303  1.00 36.87           N  
ATOM    452  CA  ALA    61      34.974  38.201  18.469  1.00 36.31           C  
ATOM    453  C   ALA    61      36.273  38.886  18.035  1.00 36.59           C  
ATOM    454  O   ALA    61      36.788  39.761  18.745  1.00 36.73           O  
ATOM    455  CB  ALA    61      35.277  36.897  19.149  1.00 36.61           C  
ATOM    456  N   ASP    62      36.789  38.512  16.862  1.00 35.46           N  
ATOM    457  CA  ASP    62      37.976  39.126  16.337  1.00 35.64           C  
ATOM    458  C   ASP    62      37.748  40.632  16.174  1.00 34.83           C  
ATOM    459  O   ASP    62      38.657  41.446  16.416  1.00 35.10           O  
ATOM    460  CB  ASP    62      38.337  38.498  14.985  1.00 36.39           C  
ATOM    461  CG  ASP    62      39.794  38.623  14.654  1.00 39.25           C  
ATOM    462  OD1 ASP    62      40.637  38.680  15.583  1.00 40.62           O  
ATOM    463  OD2 ASP    62      40.114  38.638  13.450  1.00 38.77           O  
ATOM    464  N   PHE    63      36.537  40.996  15.744  1.00 32.94           N  
ATOM    465  CA  PHE    63      36.179  42.398  15.477  1.00 32.11           C  
ATOM    466  C   PHE    63      36.010  43.121  16.817  1.00 32.58           C  
ATOM    467  O   PHE    63      36.473  44.247  16.995  1.00 33.27           O  
ATOM    468  CB  PHE    63      34.899  42.469  14.593  1.00 31.56           C  
ATOM    469  CG  PHE    63      34.233  43.797  14.589  1.00 28.81           C  
ATOM    470  CD1 PHE    63      34.871  44.893  14.078  1.00 28.17           C  
ATOM    471  CD2 PHE    63      32.950  43.943  15.088  1.00 30.00           C  
ATOM    472  CE1 PHE    63      34.249  46.153  14.108  1.00 28.32           C  
ATOM    473  CE2 PHE    63      32.322  45.178  15.078  1.00 30.25           C  
ATOM    474  CZ  PHE    63      32.984  46.282  14.580  1.00 27.83           C  
ATOM    475  N   GLN    64      35.367  42.451  17.756  1.00 32.42           N  
ATOM    476  CA  GLN    64      35.174  42.992  19.090  1.00 33.60           C  
ATOM    477  C   GLN    64      36.503  43.384  19.776  1.00 34.10           C  
ATOM    478  O   GLN    64      36.585  44.416  20.447  1.00 34.13           O  
ATOM    479  CB  GLN    64      34.339  42.001  19.920  1.00 33.32           C  
ATOM    480  CG  GLN    64      32.896  41.839  19.354  1.00 34.10           C  
ATOM    481  CD  GLN    64      32.197  40.512  19.741  1.00 36.83           C  
ATOM    482  OE1 GLN    64      32.667  39.775  20.614  1.00 36.11           O  
ATOM    483  NE2 GLN    64      31.044  40.241  19.116  1.00 35.53           N  
ATOM    484  N   ALA    65      37.536  42.579  19.568  1.00 34.84           N  
ATOM    485  CA  ALA    65      38.888  42.850  20.073  1.00 35.88           C  
ATOM    486  C   ALA    65      39.640  44.026  19.386  1.00 36.86           C  
ATOM    487  O   ALA    65      40.586  44.555  19.953  1.00 37.09           O  
ATOM    488  CB  ALA    65      39.730  41.571  19.976  1.00 36.04           C  
ATOM    489  N   ASP    66      39.240  44.431  18.182  1.00 37.60           N  
ATOM    490  CA  ASP    66      39.887  45.567  17.476  1.00 38.20           C  
ATOM    491  C   ASP    66      39.131  46.910  17.766  1.00 38.27           C  
ATOM    492  O   ASP    66      38.944  47.742  16.855  1.00 38.55           O  
ATOM    493  CB  ASP    66      39.892  45.279  15.965  1.00 38.37           C  
ATOM    494  CG  ASP    66      41.248  45.575  15.260  1.00 40.27           C  
ATOM    495  OD1 ASP    66      42.284  45.891  15.898  1.00 38.46           O  
ATOM    496  OD2 ASP    66      41.267  45.439  14.011  1.00 42.28           O  
ATOM    497  N   ALA    67      38.724  47.103  19.020  1.00 37.94           N  
ATOM    498  CA  ALA    67      37.974  48.306  19.476  1.00 38.18           C  
ATOM    499  C   ALA    67      38.679  49.661  19.239  1.00 37.68           C  
ATOM    500  O   ALA    67      38.021  50.673  18.984  1.00 37.88           O  
ATOM    501  CB  ALA    67      37.598  48.168  20.949  1.00 37.97           C  
ATOM    502  N   LYS    68      40.010  49.669  19.296  1.00 36.84           N  
ATOM    503  CA  LYS    68      40.799  50.888  19.048  1.00 35.73           C  
ATOM    504  C   LYS    68      41.176  51.071  17.554  1.00 34.00           C  
ATOM    505  O   LYS    68      42.146  51.766  17.261  1.00 33.51           O  
ATOM    506  CB  LYS    68      42.086  50.896  19.910  1.00 36.00           C  
ATOM    507  CG  LYS    68      41.893  50.587  21.402  1.00 36.85           C  
ATOM    508  CD  LYS    68      41.016  51.628  22.134  1.00 38.26           C  
ATOM    509  CE  LYS    68      40.923  51.324  23.629  1.00 39.01           C  
ATOM    510  NZ  LYS    68      40.768  52.534  24.508  1.00 39.85           N  
ATOM    511  N   TRP    69      40.385  50.487  16.640  1.00 31.74           N  
ATOM    512  CA  TRP    69      40.667  50.500  15.197  1.00 30.62           C  
ATOM    513  C   TRP    69      40.785  51.913  14.634  1.00 29.24           C  
ATOM    514  O   TRP    69      41.469  52.122  13.638  1.00 28.58           O  
ATOM    515  CB  TRP    69      39.585  49.721  14.388  1.00 30.33           C  
ATOM    516  CG  TRP    69      38.240  50.371  14.427  1.00 29.23           C  
ATOM    517  CD1 TRP    69      37.264  50.197  15.372  1.00 29.94           C  
ATOM    518  CD2 TRP    69      37.727  51.339  13.498  1.00 28.17           C  
ATOM    519  NE1 TRP    69      36.185  51.017  15.101  1.00 27.93           N  
ATOM    520  CE2 TRP    69      36.441  51.727  13.958  1.00 29.02           C  
ATOM    521  CE3 TRP    69      38.243  51.944  12.353  1.00 30.65           C  
ATOM    522  CZ2 TRP    69      35.660  52.686  13.298  1.00 28.93           C  
ATOM    523  CZ3 TRP    69      37.462  52.892  11.686  1.00 31.23           C  
ATOM    524  CH2 TRP    69      36.181  53.244  12.154  1.00 29.10           C  
ATOM    525  N   GLN    70      40.075  52.870  15.219  1.00 28.41           N  
ATOM    526  CA  GLN    70      40.212  54.247  14.743  1.00 28.68           C  
ATOM    527  C   GLN    70      41.675  54.745  14.825  1.00 27.89           C  
ATOM    528  O   GLN    70      42.046  55.631  14.071  1.00 27.19           O  
ATOM    529  CB  GLN    70      39.254  55.186  15.435  1.00 29.10           C  
ATOM    530  CG  GLN    70      37.903  55.186  14.729  1.00 32.33           C  
ATOM    531  CD  GLN    70      36.780  55.565  15.629  1.00 36.45           C  
ATOM    532  OE1 GLN    70      36.146  56.603  15.447  1.00 39.10           O  
ATOM    533  NE2 GLN    70      36.514  54.724  16.628  1.00 40.07           N  
ATOM    534  N   GLY    71      42.485  54.128  15.692  1.00 27.12           N  
ATOM    535  CA  GLY    71      43.918  54.424  15.785  1.00 27.41           C  
ATOM    536  C   GLY    71      44.742  54.035  14.580  1.00 27.35           C  
ATOM    537  O   GLY    71      45.866  54.548  14.401  1.00 27.03           O  
ATOM    538  N   TYR    72      44.216  53.130  13.754  1.00 26.61           N  
ATOM    539  CA  TYR    72      44.875  52.798  12.505  1.00 26.99           C  
ATOM    540  C   TYR    72      44.747  53.886  11.439  1.00 27.21           C  
ATOM    541  O   TYR    72      45.543  53.935  10.512  1.00 26.79           O  
ATOM    542  CB  TYR    72      44.345  51.508  11.900  1.00 27.27           C  
ATOM    543  CG  TYR    72      44.484  50.262  12.727  1.00 27.75           C  
ATOM    544  CD1 TYR    72      43.357  49.517  13.068  1.00 28.90           C  
ATOM    545  CD2 TYR    72      45.732  49.788  13.133  1.00 30.26           C  
ATOM    546  CE1 TYR    72      43.455  48.343  13.795  1.00 29.21           C  
ATOM    547  CE2 TYR    72      45.842  48.595  13.883  1.00 29.26           C  
ATOM    548  CZ  TYR    72      44.699  47.889  14.212  1.00 31.18           C  
ATOM    549  OH  TYR    72      44.749  46.721  14.939  1.00 29.57           O  
ATOM    550  N   LEU    73      43.746  54.745  11.560  1.00 27.33           N  
ATOM    551  CA  LEU    73      43.444  55.725  10.512  1.00 27.22           C  
ATOM    552  C   LEU    73      44.593  56.676  10.138  1.00 26.79           C  
ATOM    553  O   LEU    73      44.805  56.986   8.953  1.00 26.50           O  
ATOM    554  CB  LEU    73      42.182  56.510  10.914  1.00 27.40           C  
ATOM    555  CG  LEU    73      40.896  55.651  10.984  1.00 26.60           C  
ATOM    556  CD1 LEU    73      39.633  56.515  11.140  1.00 25.98           C  
ATOM    557  CD2 LEU    73      40.786  54.743   9.750  1.00 25.85           C  
ATOM    558  N   GLU    74      45.315  57.149  11.151  1.00 26.70           N  
ATOM    559  CA  GLU    74      46.412  58.063  10.955  1.00 27.00           C  
ATOM    560  C   GLU    74      47.628  57.423  10.287  1.00 27.17           C  
ATOM    561  O   GLU    74      48.600  58.110   9.988  1.00 26.94           O  
ATOM    562  CB  GLU    74      46.822  58.705  12.295  1.00 27.76           C  
ATOM    563  CG  GLU    74      47.378  57.758  13.380  1.00 27.43           C  
ATOM    564  CD  GLU    74      48.101  58.532  14.471  1.00 30.96           C  
ATOM    565  OE1 GLU    74      48.632  59.626  14.155  1.00 29.86           O  
ATOM    566  OE2 GLU    74      48.148  58.061  15.633  1.00 31.00           O  
ATOM    567  N   TRP    75      47.585  56.116  10.063  1.00 27.84           N  
ATOM    568  CA  TRP    75      48.713  55.401   9.472  1.00 28.52           C  
ATOM    569  C   TRP    75      48.442  54.918   8.057  1.00 29.51           C  
ATOM    570  O   TRP    75      49.194  54.082   7.563  1.00 29.23           O  
ATOM    571  CB  TRP    75      49.091  54.215  10.359  1.00 28.34           C  
ATOM    572  CG  TRP    75      49.499  54.652  11.707  1.00 27.70           C  
ATOM    573  CD1 TRP    75      48.796  54.501  12.861  1.00 28.32           C  
ATOM    574  CD2 TRP    75      50.698  55.368  12.052  1.00 28.02           C  
ATOM    575  NE1 TRP    75      49.489  55.068  13.914  1.00 26.63           N  
ATOM    576  CE2 TRP    75      50.656  55.606  13.443  1.00 26.73           C  
ATOM    577  CE3 TRP    75      51.801  55.832  11.317  1.00 26.37           C  
ATOM    578  CZ2 TRP    75      51.671  56.264  14.113  1.00 28.27           C  
ATOM    579  CZ3 TRP    75      52.808  56.476  11.976  1.00 27.45           C  
ATOM    580  CH2 TRP    75      52.738  56.701  13.368  1.00 28.83           C  
ATOM    581  N   CYS    76      47.378  55.432   7.421  1.00 30.37           N  
ATOM    582  CA  CYS    76      47.009  55.020   6.068  1.00 30.52           C  
ATOM    583  C   CYS    76      46.244  56.096   5.308  1.00 30.62           C  
ATOM    584  O   CYS    76      45.786  57.063   5.885  1.00 30.35           O  
ATOM    585  CB  CYS    76      46.196  53.716   6.100  1.00 29.95           C  
ATOM    586  SG  CYS    76      44.615  53.781   6.963  1.00 33.52           S  
ATOM    587  N   ASP    77      46.205  55.957   3.990  1.00 30.59           N  
ATOM    588  CA  ASP    77      45.364  56.773   3.143  1.00 30.05           C  
ATOM    589  C   ASP    77      43.938  56.224   3.149  1.00 30.40           C  
ATOM    590  O   ASP    77      43.001  57.002   3.152  1.00 30.16           O  
ATOM    591  CB  ASP    77      45.881  56.791   1.713  1.00 30.00           C  
ATOM    592  CG  ASP    77      47.242  57.385   1.598  1.00 29.91           C  
ATOM    593  OD1 ASP    77      47.476  58.506   2.117  1.00 29.20           O  
ATOM    594  OD2 ASP    77      48.076  56.757   0.963  1.00 28.27           O  
ATOM    595  N   ARG    78      43.790  54.896   3.164  1.00 29.42           N  
ATOM    596  CA  ARG    78      42.491  54.227   3.170  1.00 30.31           C  
ATOM    597  C   ARG    78      42.547  53.037   4.126  1.00 30.99           C  
ATOM    598  O   ARG    78      43.531  52.321   4.164  1.00 30.71           O  
ATOM    599  CB  ARG    78      42.104  53.747   1.780  1.00 28.64           C  
ATOM    600  CG  ARG    78      41.965  54.859   0.751  1.00 30.72           C  
ATOM    601  CD  ARG    78      41.314  54.348  -0.506  1.00 30.48           C  
ATOM    602  NE  ARG    78      41.571  55.200  -1.659  1.00 32.15           N  
ATOM    603  CZ  ARG    78      40.678  55.961  -2.286  1.00 32.66           C  
ATOM    604  NH1 ARG    78      41.056  56.684  -3.326  1.00 32.79           N  
ATOM    605  NH2 ARG    78      39.419  55.982  -1.928  1.00 32.58           N  
ATOM    606  N   TYR    79      41.504  52.900   4.921  1.00 31.70           N  
ATOM    607  CA  TYR    79      41.309  51.824   5.903  1.00 31.79           C  
ATOM    608  C   TYR    79      40.117  50.941   5.538  1.00 32.08           C  
ATOM    609  O   TYR    79      38.991  51.439   5.249  1.00 31.39           O  
ATOM    610  CB  TYR    79      41.068  52.422   7.300  1.00 32.61           C  
ATOM    611  CG  TYR    79      40.800  51.366   8.318  1.00 31.46           C  
ATOM    612  CD1 TYR    79      41.838  50.715   8.945  1.00 35.19           C  
ATOM    613  CD2 TYR    79      39.485  51.014   8.662  1.00 34.21           C  
ATOM    614  CE1 TYR    79      41.600  49.708   9.871  1.00 34.13           C  
ATOM    615  CE2 TYR    79      39.236  50.004   9.565  1.00 34.41           C  
ATOM    616  CZ  TYR    79      40.307  49.385  10.195  1.00 35.70           C  
ATOM    617  OH  TYR    79      40.092  48.395  11.112  1.00 36.52           O  
ATOM    618  N   PHE    80      40.364  49.625   5.526  1.00 32.04           N  
ATOM    619  CA  PHE    80      39.387  48.598   5.133  1.00 31.79           C  
ATOM    620  C   PHE    80      39.313  47.502   6.169  1.00 32.70           C  
ATOM    621  O   PHE    80      40.330  47.155   6.826  1.00 30.72           O  
ATOM    622  CB  PHE    80      39.748  47.846   3.853  1.00 31.81           C  
ATOM    623  CG  PHE    80      39.922  48.711   2.634  1.00 30.72           C  
ATOM    624  CD1 PHE    80      38.977  48.736   1.631  1.00 31.33           C  
ATOM    625  CD2 PHE    80      41.078  49.473   2.485  1.00 31.26           C  
ATOM    626  CE1 PHE    80      39.166  49.520   0.490  1.00 31.56           C  
ATOM    627  CE2 PHE    80      41.276  50.243   1.358  1.00 28.69           C  
ATOM    628  CZ  PHE    80      40.313  50.285   0.368  1.00 31.86           C  
ATOM    629  N   TRP    81      38.103  46.939   6.278  1.00 31.67           N  
ATOM    630  CA  TRP    81      37.898  45.626   6.873  1.00 32.90           C  
ATOM    631  C   TRP    81      37.907  44.570   5.785  1.00 32.20           C  
ATOM    632  O   TRP    81      37.542  44.863   4.660  1.00 32.23           O  
ATOM    633  CB  TRP    81      36.585  45.564   7.622  1.00 34.68           C  
ATOM    634  CG  TRP    81      36.425  46.615   8.659  1.00 34.01           C  
ATOM    635  CD1 TRP    81      35.813  47.807   8.501  1.00 36.49           C  
ATOM    636  CD2 TRP    81      36.884  46.564  10.020  1.00 34.58           C  
ATOM    637  NE1 TRP    81      35.847  48.515   9.689  1.00 37.61           N  
ATOM    638  CE2 TRP    81      36.529  47.772  10.620  1.00 35.18           C  
ATOM    639  CE3 TRP    81      37.571  45.606  10.778  1.00 36.93           C  
ATOM    640  CZ2 TRP    81      36.810  48.046  11.954  1.00 37.41           C  
ATOM    641  CZ3 TRP    81      37.868  45.885  12.090  1.00 37.27           C  
ATOM    642  CH2 TRP    81      37.502  47.087  12.661  1.00 36.57           C  
ATOM    643  N   ALA    82      38.366  43.369   6.115  1.00 31.59           N  
ATOM    644  CA  ALA    82      38.247  42.185   5.236  1.00 31.92           C  
ATOM    645  C   ALA    82      37.638  41.056   6.088  1.00 30.84           C  
ATOM    646  O   ALA    82      38.151  40.731   7.143  1.00 30.63           O  
ATOM    647  CB  ALA    82      39.603  41.768   4.638  1.00 31.84           C  
ATOM    648  N   VAL    83      36.521  40.514   5.618  1.00 31.32           N  
ATOM    649  CA  VAL    83      35.763  39.465   6.294  1.00 30.64           C  
ATOM    650  C   VAL    83      35.287  38.454   5.271  1.00 31.95           C  
ATOM    651  O   VAL    83      35.279  38.730   4.050  1.00 31.88           O  
ATOM    652  CB  VAL    83      34.547  40.051   7.056  1.00 31.36           C  
ATOM    653  CG1 VAL    83      35.014  41.082   8.109  1.00 30.90           C  
ATOM    654  CG2 VAL    83      33.498  40.665   6.110  1.00 26.79           C  
ATOM    655  N   ASP    84      34.864  37.288   5.742  1.00 31.62           N  
ATOM    656  CA  ASP    84      34.318  36.324   4.835  1.00 31.95           C  
ATOM    657  C   ASP    84      32.794  36.515   4.712  1.00 31.17           C  
ATOM    658  O   ASP    84      32.190  37.331   5.409  1.00 29.18           O  
ATOM    659  CB  ASP    84      34.732  34.908   5.241  1.00 32.92           C  
ATOM    660  CG  ASP    84      34.059  34.396   6.503  1.00 34.47           C  
ATOM    661  OD1 ASP    84      32.989  34.896   6.988  1.00 34.31           O  
ATOM    662  OD2 ASP    84      34.622  33.393   7.008  1.00 41.19           O  
ATOM    663  N   MET    85      32.191  35.692   3.879  1.00 32.20           N  
ATOM    664  CA  MET    85      30.760  35.790   3.578  0.60 33.07           C  
ATOM    666  C   MET    85      29.846  35.354   4.727  1.00 33.77           C  
ATOM    667  O   MET    85      28.611  35.550   4.649  1.00 33.86           O  
ATOM    668  CB  MET    85      30.430  35.009   2.289  0.60 33.52           C  
ATOM    670  CG  MET    85      30.604  33.478   2.356  0.60 34.27           C  
ATOM    672  SD  MET    85      30.588  32.530   0.595  0.39 34.96          SE  
ATOM    674  CE  MET    85      30.777  30.720   1.349  0.60 39.15           C  
ATOM    676  N   GLU    86      30.414  34.741   5.778  1.00 34.54           N  
ATOM    677  CA  GLU    86      29.642  34.341   6.979  0.50 34.80           C  
ATOM    679  C   GLU    86      29.586  35.463   8.020  1.00 34.52           C  
ATOM    680  O   GLU    86      28.776  35.419   8.932  1.00 33.91           O  
ATOM    681  CB  GLU    86      30.258  33.118   7.664  0.50 35.25           C  
ATOM    683  CG  GLU    86      29.928  31.766   7.060  0.50 37.34           C  
ATOM    685  CD  GLU    86      30.082  30.639   8.082  0.50 39.05           C  
ATOM    687  OE1 GLU    86      31.231  30.281   8.424  0.50 40.29           O  
ATOM    689  OE2 GLU    86      29.047  30.136   8.562  0.50 41.01           O  
ATOM    691  N   PHE    87      30.459  36.460   7.881  1.00 33.43           N  
ATOM    692  CA  PHE    87      30.514  37.608   8.799  1.00 32.14           C  
ATOM    693  C   PHE    87      29.291  38.555   8.647  1.00 33.28           C  
ATOM    694  O   PHE    87      28.853  38.836   7.525  1.00 32.13           O  
ATOM    695  CB  PHE    87      31.831  38.369   8.601  1.00 32.08           C  
ATOM    696  CG  PHE    87      32.117  39.391   9.671  1.00 31.34           C  
ATOM    697  CD1 PHE    87      32.996  39.101  10.712  1.00 33.19           C  
ATOM    698  CD2 PHE    87      31.495  40.627   9.658  1.00 29.19           C  
ATOM    699  CE1 PHE    87      33.261  40.043  11.719  1.00 32.29           C  
ATOM    700  CE2 PHE    87      31.737  41.582  10.675  1.00 30.70           C  
ATOM    701  CZ  PHE    87      32.628  41.276  11.707  1.00 33.57           C  
ATOM    702  N   PRO    88      28.731  39.060   9.777  1.00 32.74           N  
ATOM    703  CA  PRO    88      27.627  40.050   9.723  1.00 32.84           C  
ATOM    704  C   PRO    88      28.187  41.443   9.366  1.00 32.72           C  
ATOM    705  O   PRO    88      28.366  42.318  10.232  1.00 32.91           O  
ATOM    706  CB  PRO    88      27.043  39.997  11.167  1.00 33.17           C  
ATOM    707  CG  PRO    88      28.226  39.725  11.959  1.00 33.49           C  
ATOM    708  CD  PRO    88      29.088  38.758  11.175  1.00 33.24           C  
ATOM    709  N   ALA    89      28.484  41.624   8.075  1.00 31.13           N  
ATOM    710  CA  ALA    89      29.129  42.815   7.561  1.00 30.72           C  
ATOM    711  C   ALA    89      28.449  44.156   7.895  1.00 30.38           C  
ATOM    712  O   ALA    89      29.130  45.181   7.983  1.00 31.56           O  
ATOM    713  CB  ALA    89      29.312  42.676   5.982  1.00 30.19           C  
ATOM    714  N   GLU    90      27.137  44.157   8.098  1.00 30.99           N  
ATOM    715  CA  GLU    90      26.377  45.371   8.444  1.00 31.12           C  
ATOM    716  C   GLU    90      26.762  45.985   9.776  1.00 32.02           C  
ATOM    717  O   GLU    90      26.505  47.156  10.024  1.00 33.10           O  
ATOM    718  CB  GLU    90      24.871  45.089   8.446  1.00 31.81           C  
ATOM    719  CG  GLU    90      24.254  45.011   7.027  1.00 29.73           C  
ATOM    720  CD  GLU    90      22.794  44.731   6.953  1.00 33.74           C  
ATOM    721  OE1 GLU    90      22.035  44.680   7.990  1.00 34.20           O  
ATOM    722  OE2 GLU    90      22.331  44.553   5.798  1.00 31.05           O  
ATOM    723  N   LEU    91      27.346  45.173  10.634  1.00 32.63           N  
ATOM    724  CA  LEU    91      27.817  45.612  11.959  1.00 34.26           C  
ATOM    725  C   LEU    91      29.124  46.366  11.898  1.00 34.34           C  
ATOM    726  O   LEU    91      29.487  47.004  12.865  1.00 34.35           O  
ATOM    727  CB  LEU    91      27.953  44.408  12.899  1.00 34.39           C  
ATOM    728  CG  LEU    91      26.625  43.659  13.155  1.00 36.53           C  
ATOM    729  CD1 LEU    91      26.799  42.696  14.337  1.00 38.24           C  
ATOM    730  CD2 LEU    91      25.377  44.560  13.379  1.00 39.11           C  
ATOM    731  N   LEU    92      29.845  46.295  10.770  1.00 34.27           N  
ATOM    732  CA  LEU    92      31.108  47.030  10.663  1.00 34.20           C  
ATOM    733  C   LEU    92      30.811  48.550  10.494  1.00 35.17           C  
ATOM    734  O   LEU    92      29.763  48.939   9.946  1.00 33.79           O  
ATOM    735  CB  LEU    92      31.972  46.516   9.532  1.00 32.57           C  
ATOM    736  CG  LEU    92      32.376  45.057   9.589  1.00 33.16           C  
ATOM    737  CD1 LEU    92      32.911  44.474   8.185  1.00 32.52           C  
ATOM    738  CD2 LEU    92      33.408  44.895  10.689  1.00 32.37           C  
ATOM    739  N   PRO    93      31.734  49.401  10.978  1.00 35.81           N  
ATOM    740  CA  PRO    93      31.588  50.865  10.836  1.00 37.22           C  
ATOM    741  C   PRO    93      31.281  51.285   9.374  1.00 38.57           C  
ATOM    742  O   PRO    93      31.985  50.864   8.435  1.00 37.83           O  
ATOM    743  CB  PRO    93      32.946  51.397  11.245  1.00 37.53           C  
ATOM    744  CG  PRO    93      33.556  50.341  12.105  1.00 37.95           C  
ATOM    745  CD  PRO    93      32.951  49.019  11.699  1.00 37.38           C  
ATOM    746  N   ALA    94      30.265  52.121   9.212  1.00 39.21           N  
ATOM    747  CA  ALA    94      29.795  52.547   7.908  1.00 40.64           C  
ATOM    748  C   ALA    94      30.846  53.293   7.097  1.00 41.69           C  
ATOM    749  O   ALA    94      30.839  53.220   5.871  1.00 43.45           O  
ATOM    750  CB  ALA    94      28.594  53.435   8.093  1.00 40.53           C  
ATOM    751  N   GLU    95      31.727  54.001   7.795  1.00 42.61           N  
ATOM    752  CA  GLU    95      32.748  54.890   7.206  0.50 43.01           C  
ATOM    754  C   GLU    95      33.948  54.142   6.627  1.00 42.97           C  
ATOM    755  O   GLU    95      34.721  54.703   5.853  1.00 45.71           O  
ATOM    756  CB  GLU    95      33.224  55.927   8.244  0.50 42.81           C  
ATOM    758  CG  GLU    95      33.351  55.423   9.716  0.50 43.53           C  
ATOM    760  CD  GLU    95      31.991  55.154  10.401  0.50 42.38           C  
ATOM    762  OE1 GLU    95      30.966  55.697   9.959  0.50 44.03           O  
ATOM    764  OE2 GLU    95      31.944  54.374  11.363  0.50 42.48           O  
ATOM    766  N   SER    96      34.114  52.886   7.026  1.00 41.41           N  
ATOM    767  CA  SER    96      35.207  52.049   6.582  1.00 40.17           C  
ATOM    768  C   SER    96      35.003  51.437   5.201  1.00 37.08           C  
ATOM    769  O   SER    96      33.889  51.255   4.728  1.00 35.17           O  
ATOM    770  CB  SER    96      35.375  50.924   7.590  1.00 40.72           C  
ATOM    771  OG  SER    96      35.655  51.500   8.866  1.00 45.53           O  
ATOM    772  N   GLY    97      36.105  51.139   4.543  1.00 34.07           N  
ATOM    773  CA  GLY    97      36.084  50.291   3.371  1.00 32.64           C  
ATOM    774  C   GLY    97      35.839  48.835   3.746  1.00 31.97           C  
ATOM    775  O   GLY    97      35.950  48.465   4.912  1.00 29.99           O  
ATOM    776  N   LEU    98      35.454  48.020   2.750  1.00 31.37           N  
ATOM    777  CA  LEU    98      35.116  46.642   3.021  1.00 31.04           C  
ATOM    778  C   LEU    98      35.460  45.738   1.870  1.00 30.64           C  
ATOM    779  O   LEU    98      35.038  45.971   0.717  1.00 30.06           O  
ATOM    780  CB  LEU    98      33.600  46.511   3.358  1.00 30.97           C  
ATOM    781  CG  LEU    98      33.051  45.099   3.698  1.00 32.31           C  
ATOM    782  CD1 LEU    98      33.697  44.497   4.956  1.00 31.26           C  
ATOM    783  CD2 LEU    98      31.482  45.121   3.898  1.00 30.70           C  
ATOM    784  N   LEU    99      36.162  44.651   2.197  1.00 30.07           N  
ATOM    785  CA  LEU    99      36.381  43.569   1.266  1.00 30.81           C  
ATOM    786  C   LEU    99      35.723  42.331   1.801  1.00 30.99           C  
ATOM    787  O   LEU    99      35.727  42.091   3.010  1.00 30.71           O  
ATOM    788  CB  LEU    99      37.885  43.238   1.058  1.00 32.25           C  
ATOM    789  CG  LEU    99      38.770  44.242   0.321  1.00 32.98           C  
ATOM    790  CD1 LEU    99      39.193  45.320   1.271  1.00 36.62           C  
ATOM    791  CD2 LEU    99      39.975  43.565  -0.229  1.00 33.97           C  
ATOM    792  N   ILE   100      35.168  41.546   0.897  1.00 30.41           N  
ATOM    793  CA  ILE   100      34.792  40.177   1.217  1.00 31.12           C  
ATOM    794  C   ILE   100      35.857  39.246   0.639  1.00 30.61           C  
ATOM    795  O   ILE   100      36.181  39.339  -0.545  1.00 30.06           O  
ATOM    796  CB  ILE   100      33.400  39.807   0.645  1.00 31.37           C  
ATOM    797  CG1 ILE   100      32.316  40.838   1.017  1.00 32.21           C  
ATOM    798  CG2 ILE   100      33.034  38.396   1.054  1.00 30.76           C  
ATOM    799  CD1 ILE   100      32.001  40.891   2.463  1.00 32.10           C  
ATOM    800  N   ALA   101      36.414  38.375   1.482  1.00 31.06           N  
ATOM    801  CA  ALA   101      37.602  37.608   1.150  1.00 31.30           C  
ATOM    802  C   ALA   101      37.462  36.157   1.616  1.00 32.07           C  
ATOM    803  O   ALA   101      36.580  35.821   2.438  1.00 29.94           O  
ATOM    804  CB  ALA   101      38.853  38.257   1.800  1.00 30.94           C  
ATOM    805  N   ASP   102      38.309  35.310   1.033  1.00 31.99           N  
ATOM    806  CA  ASP   102      38.595  33.959   1.547  1.00 32.72           C  
ATOM    807  C   ASP   102      40.051  33.647   1.231  1.00 31.93           C  
ATOM    808  O   ASP   102      40.771  34.553   0.879  1.00 31.12           O  
ATOM    809  CB  ASP   102      37.619  32.888   1.009  1.00 33.33           C  
ATOM    810  CG  ASP   102      37.670  32.697  -0.519  1.00 34.59           C  
ATOM    811  OD1 ASP   102      38.603  33.128  -1.228  1.00 33.45           O  
ATOM    812  OD2 ASP   102      36.735  32.065  -1.039  1.00 37.52           O  
ATOM    813  N   ALA   103      40.484  32.386   1.337  1.00 31.51           N  
ATOM    814  CA  ALA   103      41.897  32.076   1.133  1.00 31.02           C  
ATOM    815  C   ALA   103      42.311  32.249  -0.308  1.00 30.32           C  
ATOM    816  O   ALA   103      43.492  32.289  -0.557  1.00 30.88           O  
ATOM    817  CB  ALA   103      42.253  30.645   1.612  1.00 32.43           C  
ATOM    818  N   TYR   104      41.363  32.384  -1.245  1.00 28.87           N  
ATOM    819  CA  TYR   104      41.695  32.281  -2.640  1.00 28.34           C  
ATOM    820  C   TYR   104      41.545  33.554  -3.446  1.00 28.54           C  
ATOM    821  O   TYR   104      42.086  33.648  -4.556  1.00 27.28           O  
ATOM    822  CB  TYR   104      40.829  31.212  -3.278  1.00 29.91           C  
ATOM    823  CG  TYR   104      40.922  29.917  -2.508  1.00 31.41           C  
ATOM    824  CD1 TYR   104      42.062  29.153  -2.586  1.00 34.46           C  
ATOM    825  CD2 TYR   104      39.903  29.514  -1.639  1.00 31.16           C  
ATOM    826  CE1 TYR   104      42.179  27.950  -1.899  1.00 36.23           C  
ATOM    827  CE2 TYR   104      40.014  28.327  -0.920  1.00 33.40           C  
ATOM    828  CZ  TYR   104      41.157  27.549  -1.064  1.00 35.57           C  
ATOM    829  OH  TYR   104      41.324  26.371  -0.378  1.00 36.02           O  
ATOM    830  N   ASP   105      40.810  34.511  -2.908  1.00 28.70           N  
ATOM    831  CA  ASP   105      40.516  35.766  -3.623  1.00 30.60           C  
ATOM    832  C   ASP   105      39.815  36.739  -2.694  1.00 29.56           C  
ATOM    833  O   ASP   105      39.558  36.423  -1.538  1.00 29.98           O  
ATOM    834  CB  ASP   105      39.662  35.489  -4.837  1.00 31.52           C  
ATOM    835  CG  ASP   105      39.812  36.551  -5.961  1.00 35.65           C  
ATOM    836  OD1 ASP   105      40.466  37.614  -5.812  1.00 38.92           O  
ATOM    837  OD2 ASP   105      39.239  36.279  -7.007  1.00 38.82           O  
ATOM    838  N   ALA   106      39.534  37.941  -3.196  1.00 29.26           N  
ATOM    839  CA  ALA   106      38.810  38.950  -2.472  1.00 28.38           C  
ATOM    840  C   ALA   106      38.166  39.942  -3.425  1.00 29.35           C  
ATOM    841  O   ALA   106      38.511  40.010  -4.609  1.00 28.75           O  
ATOM    842  CB  ALA   106      39.710  39.672  -1.485  1.00 28.01           C  
ATOM    843  N   GLU   107      37.169  40.682  -2.940  1.00 29.53           N  
ATOM    844  CA  GLU   107      36.594  41.794  -3.723  1.00 29.12           C  
ATOM    845  C   GLU   107      36.297  42.980  -2.834  1.00 28.84           C  
ATOM    846  O   GLU   107      35.868  42.822  -1.713  1.00 30.23           O  
ATOM    847  CB  GLU   107      35.334  41.359  -4.476  1.00 31.03           C  
ATOM    848  CG  GLU   107      34.201  40.871  -3.577  1.00 31.48           C  
ATOM    849  CD  GLU   107      32.986  40.326  -4.320  1.00 36.07           C  
ATOM    850  OE1 GLU   107      32.978  40.275  -5.558  1.00 29.32           O  
ATOM    851  OE2 GLU   107      32.007  39.912  -3.637  1.00 32.19           O  
ATOM    852  N   ILE   108      36.489  44.178  -3.326  1.00 28.49           N  
ATOM    853  CA  ILE   108      36.142  45.373  -2.566  1.00 29.19           C  
ATOM    854  C   ILE   108      34.641  45.582  -2.845  1.00 29.79           C  
ATOM    855  O   ILE   108      34.221  45.650  -4.002  1.00 31.57           O  
ATOM    856  CB  ILE   108      36.910  46.589  -3.041  1.00 30.58           C  
ATOM    857  CG1 ILE   108      38.430  46.385  -2.854  1.00 31.34           C  
ATOM    858  CG2 ILE   108      36.395  47.861  -2.347  1.00 29.43           C  
ATOM    859  CD1 ILE   108      39.242  47.503  -3.377  1.00 30.62           C  
ATOM    860  N   VAL   109      33.844  45.597  -1.808  1.00 29.31           N  
ATOM    861  CA  VAL   109      32.410  45.850  -1.989  1.00 29.33           C  
ATOM    862  C   VAL   109      32.060  47.292  -1.589  1.00 30.06           C  
ATOM    863  O   VAL   109      30.997  47.791  -1.952  1.00 29.09           O  
ATOM    864  CB  VAL   109      31.540  44.803  -1.274  1.00 28.67           C  
ATOM    865  CG1 VAL   109      31.664  43.424  -2.020  1.00 28.48           C  
ATOM    866  CG2 VAL   109      31.878  44.678   0.186  1.00 27.23           C  
ATOM    867  N   ARG   110      32.957  47.921  -0.833  1.00 30.48           N  
ATOM    868  CA  ARG   110      32.838  49.302  -0.415  1.00 31.76           C  
ATOM    869  C   ARG   110      34.221  49.948  -0.323  1.00 31.92           C  
ATOM    870  O   ARG   110      35.073  49.527   0.469  1.00 30.40           O  
ATOM    871  CB  ARG   110      32.121  49.351   0.949  1.00 33.34           C  
ATOM    872  CG  ARG   110      31.775  50.723   1.408  1.00 32.47           C  
ATOM    873  CD  ARG   110      30.784  50.639   2.558  1.00 34.55           C  
ATOM    874  NE  ARG   110      31.397  50.331   3.818  1.00 33.13           N  
ATOM    875  CZ  ARG   110      30.895  49.500   4.742  1.00 38.01           C  
ATOM    876  NH1 ARG   110      31.545  49.328   5.885  1.00 38.34           N  
ATOM    877  NH2 ARG   110      29.748  48.860   4.549  1.00 38.93           N  
ATOM    878  N   MET   111      34.440  50.976  -1.143  1.00 32.39           N  
ATOM    879  CA  MET   111      35.747  51.614  -1.248  1.00 32.61           C  
ATOM    880  C   MET   111      35.901  52.493  -0.031  1.00 32.80           C  
ATOM    881  O   MET   111      34.948  53.179   0.350  1.00 34.31           O  
ATOM    882  CB  MET   111      35.831  52.404  -2.563  1.00 32.09           C  
ATOM    883  CG  MET   111      37.074  53.170  -2.762  1.00 32.99           C  
ATOM    884  SD  MET   111      38.685  52.092  -2.676  0.65 32.64          SE  
ATOM    885  CE  MET   111      38.431  50.909  -4.191  1.00 29.40           C  
ATOM    886  N   ALA   112      37.062  52.452   0.621  1.00 31.88           N  
ATOM    887  CA  ALA   112      37.270  53.287   1.767  1.00 32.18           C  
ATOM    888  C   ALA   112      37.368  54.764   1.359  1.00 31.82           C  
ATOM    889  O   ALA   112      37.847  55.099   0.267  1.00 31.28           O  
ATOM    890  CB  ALA   112      38.475  52.826   2.516  1.00 32.74           C  
ATOM    891  N   PRO   113      36.904  55.676   2.233  1.00 32.37           N  
ATOM    892  CA  PRO   113      37.153  57.097   1.969  1.00 32.98           C  
ATOM    893  C   PRO   113      38.671  57.422   2.065  1.00 34.37           C  
ATOM    894  O   PRO   113      39.385  56.746   2.804  1.00 33.27           O  
ATOM    895  CB  PRO   113      36.361  57.804   3.071  1.00 33.32           C  
ATOM    896  CG  PRO   113      36.246  56.845   4.164  1.00 33.19           C  
ATOM    897  CD  PRO   113      36.175  55.470   3.501  1.00 32.47           C  
ATOM    898  N   GLU   114      39.137  58.416   1.302  1.00 36.51           N  
ATOM    899  CA  GLU   114      40.559  58.817   1.305  1.00 38.56           C  
ATOM    900  C   GLU   114      40.847  59.871   2.385  1.00 39.40           C  
ATOM    901  O   GLU   114      40.219  60.919   2.412  1.00 39.23           O  
ATOM    902  CB  GLU   114      41.010  59.331  -0.076  1.00 38.96           C  
ATOM    903  CG  GLU   114      42.488  59.786  -0.083  1.00 42.79           C  
ATOM    904  CD  GLU   114      43.315  59.213  -1.225  1.00 47.89           C  
ATOM    905  OE1 GLU   114      42.714  58.779  -2.224  1.00 53.14           O  
ATOM    906  OE2 GLU   114      44.570  59.197  -1.131  1.00 48.25           O  
ATOM    907  N   GLN   115      41.783  59.548   3.275  1.00 40.80           N  
ATOM    908  CA  GLN   115      42.268  60.446   4.317  0.50 41.99           C  
ATOM    910  C   GLN   115      43.793  60.544   4.173  1.00 42.34           C  
ATOM    911  O   GLN   115      44.534  60.025   5.015  1.00 42.61           O  
ATOM    912  CB  GLN   115      41.880  59.905   5.712  0.50 42.46           C  
ATOM    914  CG  GLN   115      40.818  58.772   5.706  0.50 44.17           C  
ATOM    916  CD  GLN   115      39.800  58.895   6.827  0.50 45.73           C  
ATOM    918  OE1 GLN   115      38.600  58.789   6.585  0.50 47.54           O  
ATOM    920  NE2 GLN   115      40.271  59.125   8.052  0.50 47.44           N  
ATOM    922  N   LYS   116      44.249  61.179   3.097  1.00 42.86           N  
ATOM    923  CA  LYS   116      45.673  61.190   2.744  1.00 43.55           C  
ATOM    924  C   LYS   116      46.675  61.487   3.886  1.00 43.30           C  
ATOM    925  O   LYS   116      46.454  62.315   4.770  1.00 42.24           O  
ATOM    926  CB  LYS   116      45.944  62.167   1.595  1.00 44.43           C  
ATOM    927  CG  LYS   116      45.694  61.624   0.183  1.00 46.12           C  
ATOM    928  CD  LYS   116      46.476  62.501  -0.855  1.00 48.81           C  
ATOM    929  CE  LYS   116      45.588  63.021  -2.009  1.00 50.12           C  
ATOM    930  NZ  LYS   116      45.068  61.926  -2.889  1.00 51.16           N  
ATOM    931  N   LEU   117      47.795  60.786   3.801  1.00 43.26           N  
ATOM    932  CA  LEU   117      48.880  60.847   4.762  1.00 43.52           C  
ATOM    933  C   LEU   117      49.768  62.060   4.391  1.00 43.97           C  
ATOM    934  O   LEU   117      49.868  62.431   3.218  1.00 43.20           O  
ATOM    935  CB  LEU   117      49.662  59.524   4.650  1.00 43.32           C  
ATOM    936  CG  LEU   117      49.971  58.514   5.768  1.00 42.50           C  
ATOM    937  CD1 LEU   117      49.035  58.460   6.894  1.00 38.84           C  
ATOM    938  CD2 LEU   117      50.079  57.121   5.121  1.00 41.84           C  
ATOM    939  N   ALA   118      50.407  62.680   5.379  1.00 45.49           N  
ATOM    940  CA  ALA   118      51.416  63.721   5.118  1.00 46.60           C  
ATOM    941  C   ALA   118      52.688  63.104   4.473  1.00 47.17           C  
ATOM    942  O   ALA   118      52.980  61.941   4.739  1.00 46.34           O  
ATOM    943  CB  ALA   118      51.750  64.457   6.420  1.00 47.88           C  
ATOM    944  N   PRO   119      53.399  63.850   3.574  1.00 47.51           N  
ATOM    945  CA  PRO   119      54.599  63.389   2.842  1.00 47.59           C  
ATOM    946  C   PRO   119      55.693  62.724   3.689  1.00 47.35           C  
ATOM    947  O   PRO   119      56.294  61.727   3.249  1.00 46.86           O  
ATOM    948  CB  PRO   119      55.169  64.678   2.206  1.00 47.81           C  
ATOM    949  CG  PRO   119      53.996  65.589   2.057  1.00 48.09           C  
ATOM    950  CD  PRO   119      52.975  65.194   3.127  1.00 48.21           C  
ATOM    951  N   ALA   120      55.949  63.290   4.875  1.00 46.56           N  
ATOM    952  CA  ALA   120      57.009  62.781   5.740  1.00 46.24           C  
ATOM    953  C   ALA   120      56.628  61.425   6.315  1.00 44.99           C  
ATOM    954  O   ALA   120      57.461  60.542   6.467  1.00 43.76           O  
ATOM    955  CB  ALA   120      57.310  63.767   6.869  1.00 46.49           C  
ATOM    956  N   ARG   121      55.364  61.273   6.649  1.00 44.79           N  
ATOM    957  CA  ARG   121      54.872  60.019   7.199  1.00 44.89           C  
ATOM    958  C   ARG   121      54.772  58.924   6.150  1.00 43.80           C  
ATOM    959  O   ARG   121      55.066  57.770   6.436  1.00 43.62           O  
ATOM    960  CB  ARG   121      53.491  60.228   7.743  1.00 45.15           C  
ATOM    961  CG  ARG   121      52.984  59.105   8.616  1.00 47.67           C  
ATOM    962  CD  ARG   121      53.018  59.592  10.052  1.00 48.71           C  
ATOM    963  NE  ARG   121      51.957  59.036  10.799  1.00 47.08           N  
ATOM    964  CZ  ARG   121      51.534  59.475  11.983  1.00 45.97           C  
ATOM    965  NH1 ARG   121      50.526  58.854  12.536  1.00 42.19           N  
ATOM    966  NH2 ARG   121      52.105  60.484  12.633  1.00 42.92           N  
ATOM    967  N   ARG   122      54.295  59.281   4.962  1.00 42.61           N  
ATOM    968  CA  ARG   122      54.302  58.366   3.838  1.00 42.30           C  
ATOM    969  C   ARG   122      55.717  57.791   3.628  1.00 42.47           C  
ATOM    970  O   ARG   122      55.894  56.603   3.371  1.00 41.94           O  
ATOM    971  CB  ARG   122      53.861  59.088   2.582  1.00 41.69           C  
ATOM    972  CG  ARG   122      53.694  58.186   1.376  1.00 41.56           C  
ATOM    973  CD  ARG   122      53.218  58.964   0.170  1.00 41.36           C  
ATOM    974  NE  ARG   122      52.043  59.741   0.536  1.00 40.48           N  
ATOM    975  CZ  ARG   122      50.842  59.221   0.739  1.00 43.83           C  
ATOM    976  NH1 ARG   122      50.639  57.914   0.587  1.00 45.33           N  
ATOM    977  NH2 ARG   122      49.835  60.018   1.125  1.00 40.81           N  
ATOM    978  N   LYS   123      56.719  58.642   3.707  1.00 42.91           N  
ATOM    979  CA  LYS   123      58.126  58.207   3.531  1.00 43.36           C  
ATOM    980  C   LYS   123      58.548  57.179   4.554  1.00 42.40           C  
ATOM    981  O   LYS   123      59.149  56.157   4.210  1.00 42.17           O  
ATOM    982  CB  LYS   123      59.087  59.375   3.697  1.00 45.04           C  
ATOM    983  CG  LYS   123      59.344  60.143   2.450  1.00 49.40           C  
ATOM    984  CD  LYS   123      60.707  60.818   2.482  1.00 54.56           C  
ATOM    985  CE  LYS   123      60.650  62.240   1.878  1.00 57.35           C  
ATOM    986  NZ  LYS   123      59.260  62.655   1.400  1.00 57.21           N  
ATOM    987  N   VAL   124      58.269  57.467   5.819  1.00 41.11           N  
ATOM    988  CA  VAL   124      58.646  56.570   6.908  1.00 40.38           C  
ATOM    989  C   VAL   124      58.011  55.204   6.725  1.00 39.67           C  
ATOM    990  O   VAL   124      58.674  54.169   6.875  1.00 38.37           O  
ATOM    991  CB  VAL   124      58.257  57.153   8.287  1.00 40.77           C  
ATOM    992  CG1 VAL   124      58.451  56.116   9.393  1.00 42.42           C  
ATOM    993  CG2 VAL   124      59.092  58.337   8.592  1.00 40.80           C  
ATOM    994  N   LEU   125      56.715  55.188   6.383  1.00 38.13           N  
ATOM    995  CA  LEU   125      56.004  53.955   6.266  1.00 37.40           C  
ATOM    996  C   LEU   125      56.437  53.132   5.049  1.00 36.22           C  
ATOM    997  O   LEU   125      56.467  51.932   5.119  1.00 36.07           O  
ATOM    998  CB  LEU   125      54.501  54.230   6.178  1.00 37.35           C  
ATOM    999  CG  LEU   125      53.866  54.793   7.444  1.00 38.53           C  
ATOM   1000  CD1 LEU   125      52.439  55.234   7.103  1.00 36.55           C  
ATOM   1001  CD2 LEU   125      53.867  53.719   8.560  1.00 36.32           C  
ATOM   1002  N   ILE   126      56.713  53.779   3.931  1.00 36.14           N  
ATOM   1003  CA  ILE   126      57.241  53.080   2.749  1.00 35.99           C  
ATOM   1004  C   ILE   126      58.612  52.438   3.014  1.00 35.57           C  
ATOM   1005  O   ILE   126      58.883  51.300   2.576  1.00 35.09           O  
ATOM   1006  CB  ILE   126      57.222  53.984   1.480  1.00 35.88           C  
ATOM   1007  CG1 ILE   126      55.759  54.345   1.163  1.00 36.66           C  
ATOM   1008  CG2 ILE   126      57.978  53.277   0.261  1.00 35.04           C  
ATOM   1009  CD1 ILE   126      55.552  55.126  -0.092  1.00 37.14           C  
ATOM   1010  N   GLN   127      59.435  53.122   3.788  1.00 35.49           N  
ATOM   1011  CA  GLN   127      60.748  52.618   4.177  1.00 35.94           C  
ATOM   1012  C   GLN   127      60.589  51.363   5.038  1.00 36.10           C  
ATOM   1013  O   GLN   127      61.335  50.365   4.870  1.00 34.83           O  
ATOM   1014  CB  GLN   127      61.554  53.697   4.921  1.00 37.03           C  
ATOM   1015  CG  GLN   127      62.818  53.214   5.609  1.00 37.55           C  
ATOM   1016  CD  GLN   127      63.933  53.025   4.659  1.00 40.37           C  
ATOM   1017  OE1 GLN   127      64.111  53.833   3.752  1.00 42.14           O  
ATOM   1018  NE2 GLN   127      64.746  51.989   4.882  1.00 41.30           N  
ATOM   1019  N   LYS   128      59.604  51.410   5.936  1.00 35.63           N  
ATOM   1020  CA  LYS   128      59.332  50.301   6.848  1.00 34.77           C  
ATOM   1021  C   LYS   128      58.790  49.110   6.089  1.00 34.02           C  
ATOM   1022  O   LYS   128      59.157  47.982   6.371  1.00 33.41           O  
ATOM   1023  CB  LYS   128      58.342  50.717   7.931  1.00 34.60           C  
ATOM   1024  CG  LYS   128      58.969  51.487   9.048  1.00 39.61           C  
ATOM   1025  CD  LYS   128      57.941  52.005  10.052  1.00 41.93           C  
ATOM   1026  CE  LYS   128      58.606  53.085  10.914  1.00 46.04           C  
ATOM   1027  NZ  LYS   128      58.280  52.892  12.368  1.00 46.57           N  
ATOM   1028  N   PHE   129      57.890  49.380   5.153  1.00 32.95           N  
ATOM   1029  CA  PHE   129      57.306  48.360   4.312  1.00 33.01           C  
ATOM   1030  C   PHE   129      58.395  47.649   3.492  1.00 33.38           C  
ATOM   1031  O   PHE   129      58.469  46.406   3.489  1.00 33.16           O  
ATOM   1032  CB  PHE   129      56.273  49.021   3.422  1.00 32.46           C  
ATOM   1033  CG  PHE   129      55.574  48.100   2.489  1.00 31.79           C  
ATOM   1034  CD1 PHE   129      54.278  47.682   2.758  1.00 32.57           C  
ATOM   1035  CD2 PHE   129      56.158  47.685   1.311  1.00 31.11           C  
ATOM   1036  CE1 PHE   129      53.610  46.856   1.869  1.00 30.91           C  
ATOM   1037  CE2 PHE   129      55.499  46.864   0.425  1.00 32.46           C  
ATOM   1038  CZ  PHE   129      54.230  46.422   0.702  1.00 31.79           C  
ATOM   1039  N   ALA   130      59.221  48.448   2.818  1.00 33.33           N  
ATOM   1040  CA  ALA   130      60.407  47.950   2.052  1.00 33.63           C  
ATOM   1041  C   ALA   130      61.277  47.025   2.897  1.00 32.83           C  
ATOM   1042  O   ALA   130      61.613  45.899   2.523  1.00 31.42           O  
ATOM   1043  CB  ALA   130      61.250  49.124   1.558  1.00 32.72           C  
ATOM   1044  N   THR   131      61.591  47.500   4.073  1.00 32.85           N  
ATOM   1045  CA  THR   131      62.413  46.753   4.979  1.00 33.64           C  
ATOM   1046  C   THR   131      61.783  45.448   5.399  1.00 32.48           C  
ATOM   1047  O   THR   131      62.454  44.430   5.442  1.00 31.61           O  
ATOM   1048  CB  THR   131      62.747  47.599   6.186  1.00 34.24           C  
ATOM   1049  OG1 THR   131      63.439  48.756   5.711  1.00 34.28           O  
ATOM   1050  CG2 THR   131      63.637  46.820   7.134  1.00 36.35           C  
ATOM   1051  N   HIS   132      60.485  45.489   5.691  1.00 33.22           N  
ATOM   1052  CA  HIS   132      59.739  44.311   6.126  1.00 32.97           C  
ATOM   1053  C   HIS   132      59.736  43.274   5.015  1.00 32.06           C  
ATOM   1054  O   HIS   132      60.071  42.089   5.202  1.00 30.93           O  
ATOM   1055  CB  HIS   132      58.309  44.767   6.490  1.00 33.23           C  
ATOM   1056  CG  HIS   132      57.380  43.673   6.899  1.00 33.85           C  
ATOM   1057  ND1 HIS   132      56.700  43.700   8.101  1.00 33.95           N  
ATOM   1058  CD2 HIS   132      56.937  42.569   6.243  1.00 33.16           C  
ATOM   1059  CE1 HIS   132      55.908  42.643   8.179  1.00 32.64           C  
ATOM   1060  NE2 HIS   132      56.031  41.942   7.065  1.00 30.46           N  
ATOM   1061  N   ALA   133      59.328  43.727   3.837  1.00 31.75           N  
ATOM   1062  CA  ALA   133      59.244  42.852   2.693  1.00 30.24           C  
ATOM   1063  C   ALA   133      60.567  42.187   2.369  1.00 29.49           C  
ATOM   1064  O   ALA   133      60.622  40.971   2.107  1.00 30.73           O  
ATOM   1065  CB  ALA   133      58.757  43.650   1.511  1.00 29.31           C  
ATOM   1066  N   ALA   134      61.631  42.982   2.316  1.00 28.49           N  
ATOM   1067  CA  ALA   134      62.926  42.475   1.881  1.00 27.28           C  
ATOM   1068  C   ALA   134      63.539  41.515   2.914  1.00 28.08           C  
ATOM   1069  O   ALA   134      64.128  40.517   2.524  1.00 26.06           O  
ATOM   1070  CB  ALA   134      63.887  43.601   1.497  1.00 28.12           C  
ATOM   1071  N   ARG   135      63.335  41.771   4.208  1.00 29.15           N  
ATOM   1072  CA  ARG   135      63.798  40.846   5.246  1.00 29.60           C  
ATOM   1073  C   ARG   135      63.136  39.496   5.099  1.00 30.00           C  
ATOM   1074  O   ARG   135      63.804  38.471   5.096  1.00 30.62           O  
ATOM   1075  CB  ARG   135      63.525  41.364   6.672  1.00 29.23           C  
ATOM   1076  CG  ARG   135      64.605  42.218   7.201  1.00 34.62           C  
ATOM   1077  CD  ARG   135      64.358  42.618   8.697  1.00 38.89           C  
ATOM   1078  NE  ARG   135      65.422  43.550   9.090  1.00 47.15           N  
ATOM   1079  CZ  ARG   135      65.246  44.733   9.701  1.00 50.14           C  
ATOM   1080  NH1 ARG   135      64.028  45.160  10.070  1.00 50.63           N  
ATOM   1081  NH2 ARG   135      66.312  45.488   9.974  1.00 49.80           N  
ATOM   1082  N   ARG   136      61.790  39.495   5.037  1.00 30.67           N  
ATOM   1083  CA  ARG   136      61.048  38.243   4.931  1.00 30.83           C  
ATOM   1084  C   ARG   136      61.417  37.475   3.691  1.00 29.56           C  
ATOM   1085  O   ARG   136      61.473  36.261   3.712  1.00 29.65           O  
ATOM   1086  CB  ARG   136      59.524  38.505   4.909  1.00 31.76           C  
ATOM   1087  CG  ARG   136      59.014  39.294   6.065  1.00 36.83           C  
ATOM   1088  CD  ARG   136      59.004  38.556   7.316  1.00 42.45           C  
ATOM   1089  NE  ARG   136      58.221  39.289   8.324  1.00 48.18           N  
ATOM   1090  CZ  ARG   136      58.682  40.286   9.099  1.00 51.11           C  
ATOM   1091  NH1 ARG   136      59.940  40.731   8.999  1.00 52.60           N  
ATOM   1092  NH2 ARG   136      57.870  40.847   9.986  1.00 52.86           N  
ATOM   1093  N   LEU   137      61.579  38.178   2.582  1.00 29.38           N  
ATOM   1094  CA  LEU   137      61.999  37.561   1.329  1.00 28.94           C  
ATOM   1095  C   LEU   137      63.352  36.874   1.462  1.00 29.34           C  
ATOM   1096  O   LEU   137      63.513  35.689   1.113  1.00 30.12           O  
ATOM   1097  CB  LEU   137      62.057  38.612   0.245  1.00 28.19           C  
ATOM   1098  CG  LEU   137      62.578  38.237  -1.144  1.00 28.63           C  
ATOM   1099  CD1 LEU   137      61.872  37.025  -1.693  1.00 28.56           C  
ATOM   1100  CD2 LEU   137      62.419  39.454  -2.036  1.00 27.13           C  
ATOM   1101  N   GLN   138      64.330  37.599   2.009  1.00 28.89           N  
ATOM   1102  CA  GLN   138      65.664  37.027   2.177  1.00 27.63           C  
ATOM   1103  C   GLN   138      65.642  35.771   3.076  1.00 28.06           C  
ATOM   1104  O   GLN   138      66.330  34.810   2.799  1.00 28.10           O  
ATOM   1105  CB  GLN   138      66.680  38.080   2.654  1.00 27.43           C  
ATOM   1106  CG  GLN   138      68.167  37.618   2.581  1.00 25.72           C  
ATOM   1107  CD  GLN   138      68.624  36.982   3.883  1.00 28.91           C  
ATOM   1108  OE1 GLN   138      67.839  36.922   4.854  1.00 30.24           O  
ATOM   1109  NE2 GLN   138      69.870  36.485   3.921  1.00 24.05           N  
ATOM   1110  N   ALA   139      64.847  35.800   4.132  1.00 29.36           N  
ATOM   1111  CA  ALA   139      64.735  34.690   5.035  1.00 30.23           C  
ATOM   1112  C   ALA   139      64.095  33.433   4.382  1.00 32.15           C  
ATOM   1113  O   ALA   139      64.429  32.303   4.759  1.00 33.40           O  
ATOM   1114  CB  ALA   139      63.982  35.118   6.266  1.00 29.95           C  
ATOM   1115  N   LEU   140      63.170  33.615   3.445  1.00 32.96           N  
ATOM   1116  CA  LEU   140      62.568  32.490   2.722  1.00 34.03           C  
ATOM   1117  C   LEU   140      63.532  31.926   1.724  1.00 35.42           C  
ATOM   1118  O   LEU   140      63.681  30.714   1.620  1.00 35.86           O  
ATOM   1119  CB  LEU   140      61.274  32.916   2.012  1.00 33.87           C  
ATOM   1120  CG  LEU   140      60.018  32.982   2.847  1.00 35.13           C  
ATOM   1121  CD1 LEU   140      58.791  33.326   1.930  1.00 32.30           C  
ATOM   1122  CD2 LEU   140      59.794  31.673   3.641  1.00 35.34           C  
ATOM   1123  N   ARG   141      64.276  32.801   1.047  1.00 36.64           N  
ATOM   1124  CA  ARG   141      65.287  32.352   0.075  1.00 37.91           C  
ATOM   1125  C   ARG   141      66.548  31.761   0.649  1.00 37.87           C  
ATOM   1126  O   ARG   141      67.213  30.962  -0.007  1.00 37.13           O  
ATOM   1127  CB  ARG   141      65.639  33.496  -0.864  1.00 38.46           C  
ATOM   1128  CG  ARG   141      64.421  34.078  -1.487  1.00 41.46           C  
ATOM   1129  CD  ARG   141      64.562  34.460  -2.929  1.00 47.70           C  
ATOM   1130  NE  ARG   141      65.693  35.313  -3.174  1.00 52.73           N  
ATOM   1131  CZ  ARG   141      66.759  34.994  -3.922  1.00 57.69           C  
ATOM   1132  NH1 ARG   141      67.731  35.873  -4.045  1.00 57.08           N  
ATOM   1133  NH2 ARG   141      66.877  33.820  -4.558  1.00 60.85           N  
ATOM   1134  N   ASP   142      66.873  32.133   1.894  1.00 36.79           N  
ATOM   1135  CA  ASP   142      68.116  31.738   2.528  1.00 35.37           C  
ATOM   1136  C   ASP   142      67.823  31.607   4.025  1.00 35.29           C  
ATOM   1137  O   ASP   142      68.215  32.455   4.788  1.00 33.42           O  
ATOM   1138  CB  ASP   142      69.171  32.819   2.244  1.00 35.26           C  
ATOM   1139  CG  ASP   142      70.549  32.503   2.793  1.00 34.73           C  
ATOM   1140  OD1 ASP   142      70.806  31.384   3.324  1.00 36.25           O  
ATOM   1141  OD2 ASP   142      71.403  33.419   2.715  1.00 29.26           O  
ATOM   1142  N   PRO   143      67.130  30.523   4.427  1.00 36.28           N  
ATOM   1143  CA  PRO   143      66.664  30.323   5.800  1.00 35.81           C  
ATOM   1144  C   PRO   143      67.740  30.476   6.879  1.00 35.40           C  
ATOM   1145  O   PRO   143      67.446  31.016   7.961  1.00 34.44           O  
ATOM   1146  CB  PRO   143      66.105  28.904   5.789  1.00 36.12           C  
ATOM   1147  CG  PRO   143      65.852  28.569   4.361  1.00 37.43           C  
ATOM   1148  CD  PRO   143      66.667  29.454   3.512  1.00 37.57           C  
END
