
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  111 (  911),  selected  111 , name 3d7c_A
# Molecule2: number of CA atoms  119 ( 1007),  selected  119 , name T0496_4_122.pdb
# PARAMETERS: 3d7c_A.T0496_4_122.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    M   727_A      -       -           -
LGA    E   728_A      P       4           #
LGA    D   729_A      V       5           -
LGA    P   730_A      -       -           -
LGA    D   731_A      -       -           -
LGA    Q   732_A      S       6          3.424
LGA    L   733_A      V       7          1.667
LGA    Y   734_A      -       -           -
LGA    T   735_A      N       8          1.353
LGA    T   736_A      E       9          0.907
LGA    L   737_A      K      10          1.373
LGA    K   738_A      K      11          1.684
LGA    N   739_A      D      12          1.155
LGA    L   740_A      F      13          0.790
LGA    L   741_A      V      14          0.978
LGA    A   742_A      K      15          1.361
LGA    Q   743_A      W      16          1.442
LGA    I   744_A      F      17          1.130
LGA    K   745_A      L      18          0.906
LGA    S   746_A      N      19          1.334
LGA    H   747_A      N      20          1.957
LGA    P   748_A      Y      21          4.460
LGA    S   749_A      Q      22          3.359
LGA    A   750_A      -       -           -
LGA    W   751_A      L      23          4.566
LGA    P   752_A      K      24          2.760
LGA    F   753_A      Q      25          3.316
LGA    M   754_A      R      26          3.619
LGA    E   755_A      E      27          2.762
LGA    P   756_A      -       -           -
LGA    V   757_A      -       -           -
LGA    K   758_A      -       -           -
LGA    K   759_A      -       -           -
LGA    S   760_A      -       -           -
LGA    E   761_A      -       -           -
LGA    A   762_A      -       -           -
LGA    P   763_A      -       -           -
LGA    D   764_A      -       -           -
LGA    Y   765_A      -       -           -
LGA    Y   766_A      -       -           -
LGA    E   767_A      -       -           -
LGA    V   768_A      -       -           -
LGA    I   769_A      -       -           -
LGA    R   770_A      -       -           -
LGA    F   771_A      -       -           -
LGA    P   772_A      -       -           -
LGA    I   773_A      -       -           -
LGA    D   774_A      C      28          0.429
LGA    L   775_A      V      29          1.745
LGA    K   776_A      W      30          1.316
LGA    T   777_A      I      31          1.108
LGA    M   778_A      L      32          1.428
LGA    T   779_A      N      33          1.371
LGA    E   780_A      Y      34          0.405
LGA    R   781_A      L      35          1.818
LGA    L   782_A      M      36          2.527
LGA    R   783_A      S      37          1.403
LGA    S   784_A      H      38          1.686
LGA    R   785_A      D      39          2.944
LGA    -       -      Q      40           -
LGA    Y   786_A      L      41          1.487
LGA    Y   787_A      M      42          2.391
LGA    V   788_A      H      43          1.573
LGA    T   789_A      K      44          3.783
LGA    R   790_A      V      45          4.908
LGA    K   791_A      H      46          1.875
LGA    L   792_A      F      47           #
LGA    F   793_A      -       -           -
LGA    V   794_A      V      48          4.069
LGA    A   795_A      E      49           #
LGA    -       -      H      50           -
LGA    -       -      A      51           -
LGA    -       -      K      52           -
LGA    -       -      Y      53           -
LGA    -       -      C      54           -
LGA    -       -      P      55           -
LGA    -       -      R      56           -
LGA    D   796_A      G      57           #
LGA    L   797_A      L      58           #
LGA    Q   798_A      -       -           -
LGA    R   799_A      V      59          0.219
LGA    V   800_A      M      60          0.887
LGA    I   801_A      S      61          2.538
LGA    A   802_A      A      62           -
LGA    N   803_A      N      63           -
LGA    -       -      C      64           -
LGA    -       -      V      65           -
LGA    C   804_A      K      66           #
LGA    R   805_A      D      67          3.247
LGA    E   806_A      T      68          4.382
LGA    Y   807_A      P      69           #
LGA    N   808_A      F      70           -
LGA    P   809_A      H      71           -
LGA    P   810_A      F      72           -
LGA    D   811_A      F      73           -
LGA    S   812_A      K      74           -
LGA    E   813_A      Q      75           -
LGA    Y   814_A      N      76           -
LGA    C   815_A      V      77           -
LGA    R   816_A      M      78           -
LGA    C   817_A      T      79           -
LGA    A   818_A      T      80           -
LGA    S   819_A      D      81           -
LGA    A   820_A      A      82           -
LGA    -       -      E      83           -
LGA    -       -      K      84           -
LGA    -       -      S      85           -
LGA    -       -      F      86           -
LGA    -       -      H      87           -
LGA    -       -      D      88           -
LGA    -       -      I      89           -
LGA    -       -      R      90           -
LGA    -       -      L      91           -
LGA    -       -      N      92           -
LGA    -       -      R      93           -
LGA    -       -      D      94           -
LGA    -       -      E      95           -
LGA    -       -      D      96           -
LGA    -       -      I      97           -
LGA    -       -      Y      98           -
LGA    -       -      I      99           -
LGA    -       -      Q     100           -
LGA    -       -      L     101           -
LGA    L   821_A      N     102           #
LGA    E   822_A      F     103          1.616
LGA    K   823_A      K     104          2.872
LGA    F   824_A      S     105          3.396
LGA    F   825_A      S     106          4.045
LGA    Y   826_A      F     107          3.810
LGA    F   827_A      Q     108          3.327
LGA    K   828_A      N     109          3.459
LGA    L   829_A      -       -           -
LGA    K   830_A      A     110          3.561
LGA    E   831_A      N     111          2.923
LGA    G   832_A      Y     112          5.351
LGA    -       -      V     113           -
LGA    G   833_A      A     114          1.768
LGA    L   834_A      V     115          2.412
LGA    I   835_A      L     116          3.344
LGA    D   836_A      E     117           -
LGA    K   837_A      E     118           -
LGA    -       -      N     119           -
LGA    -       -      P     120           -
LGA    -       -      Y     121           -
LGA    -       -      L     122           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  111  119    5.0     59    2.65     6.78     34.002     2.148

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.936233 * X  +  -0.290178 * Y  +   0.198154 * Z  +  37.140503
  Y_new =  -0.057762 * X  +   0.429162 * Y  +   0.901379 * Z  +  28.502661
  Z_new =  -0.346600 * X  +  -0.855346 * Y  +   0.385035 * Z  + 113.572014 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.147817    1.993775  [ DEG:   -65.7651    114.2349 ]
  Theta =   0.353944    2.787649  [ DEG:    20.2795    159.7205 ]
  Phi   =  -0.061618    3.079975  [ DEG:    -3.5304    176.4696 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 3d7c_A                                        
REMARK     2: T0496_4_122.pdb                               
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 3d7c_A.T0496_4_122.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  111  119   5.0   59   2.65    6.78  34.002
REMARK  ---------------------------------------------------------- 
MOLECULE 3d7c_A
HEADER    TRANSCRIPTION                           21-MAY-08   3D7C              
TITLE     CRYSTAL STRUCTURE OF THE BROMODOMAIN OF HUMAN GCN5, THE               
TITLE    2 GENERAL CONTROL OF AMINO-ACID SYNTHESIS PROTEIN 5-LIKE 2             
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: GENERAL CONTROL OF AMINO ACID SYNTHESIS PROTEIN            
COMPND   3 5-LIKE 2;                                                            
COMPND   4 CHAIN: A, B;                                                         
COMPND   5 FRAGMENT: BROMO DOMAIN: RESIDUES 729-837;                            
COMPND   6 SYNONYM: HISTONE ACETYLTRANSFERASE GCN5, HSGCN5, STAF97;             
COMPND   7 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 GENE: GCN5L2, GCN5, HGCN5;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_STRAIN: BL21(DE3)-R3;                              
SOURCE   6 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   7 EXPRESSION_SYSTEM_PLASMID: PNIC28-BSA4                               
KEYWDS    GCN5, BROMODOMAIN, AMINO-ACID SYNTHESIS, STRUCTURAL                   
KEYWDS   2 GENOMICS CONSORTIUM, SGC, ALTERNATIVE SPLICING, HOST-VIRUS           
KEYWDS   3 INTERACTION, NUCLEUS, PHOSPHOPROTEIN, TRANSCRIPTION,                 
KEYWDS   4 TRANSCRIPTION REGULATION, TRANSFERASE, BIOSYNTHETIC PROTEIN          
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    P.FILIPPAKOPOULOS,J.ESWARAN,S.PICAUD,O.FEDOROV,J.MURRAY,              
AUTHOR   2 F.VON DELFT,C.H.ARROWSMITH,A.M.EDWARDS,C.BOUNTRA,S.KNAPP,            
AUTHOR   3 STRUCTURAL GENOMICS CONSORTIUM (SGC)                                 
REVDAT   1   15-JUL-08 3D7C    0                                                
JRNL        AUTH   P.FILIPPAKOPOULOS,J.ESWARAN,S.PICAUD,O.FEDOROV,              
JRNL        AUTH 2 J.MURRAY,F.VON DELFT,C.H.ARROWSMITH,A.M.EDWARDS,             
JRNL        AUTH 3 C.BOUNTRA,S.KNAPP                                            
JRNL        TITL   CRYSTAL STRUCTURE OF THE BROMODOMAIN OF HUMAN                
JRNL        TITL 2 GCN5, THE GENERAL CONTROL OF AMINO-ACID SYNTHESIS            
JRNL        TITL 3 PROTEIN 5-LIKE 2.                                            
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.06 ANGSTROMS.                                          
DBREF  3D7C A  729   837  UNP    Q92830   GCNL2_HUMAN    729    837             
DBREF  3D7C B  729   837  UNP    Q92830   GCNL2_HUMAN    729    837             
SEQRES   1 A  112  SER MET GLU ASP PRO ASP GLN LEU TYR THR THR LEU LYS          
SEQRES   2 A  112  ASN LEU LEU ALA GLN ILE LYS SER HIS PRO SER ALA TRP          
SEQRES   3 A  112  PRO PHE MET GLU PRO VAL LYS LYS SER GLU ALA PRO ASP          
SEQRES   4 A  112  TYR TYR GLU VAL ILE ARG PHE PRO ILE ASP LEU LYS THR          
SEQRES   5 A  112  MET THR GLU ARG LEU ARG SER ARG TYR TYR VAL THR ARG          
SEQRES   6 A  112  LYS LEU PHE VAL ALA ASP LEU GLN ARG VAL ILE ALA ASN          
SEQRES   7 A  112  CYS ARG GLU TYR ASN PRO PRO ASP SER GLU TYR CYS ARG          
SEQRES   8 A  112  CYS ALA SER ALA LEU GLU LYS PHE PHE TYR PHE LYS LEU          
SEQRES   9 A  112  LYS GLU GLY GLY LEU ILE ASP LYS                              
SEQRES   1 B  112  SER MET GLU ASP PRO ASP GLN LEU TYR THR THR LEU LYS          
SEQRES   2 B  112  ASN LEU LEU ALA GLN ILE LYS SER HIS PRO SER ALA TRP          
SEQRES   3 B  112  PRO PHE MET GLU PRO VAL LYS LYS SER GLU ALA PRO ASP          
SEQRES   4 B  112  TYR TYR GLU VAL ILE ARG PHE PRO ILE ASP LEU LYS THR          
SEQRES   5 B  112  MET THR GLU ARG LEU ARG SER ARG TYR TYR VAL THR ARG          
SEQRES   6 B  112  LYS LEU PHE VAL ALA ASP LEU GLN ARG VAL ILE ALA ASN          
SEQRES   7 B  112  CYS ARG GLU TYR ASN PRO PRO ASP SER GLU TYR CYS ARG          
SEQRES   8 B  112  CYS ALA SER ALA LEU GLU LYS PHE PHE TYR PHE LYS LEU          
SEQRES   9 B  112  LYS GLU GLY GLY LEU ILE ASP LYS                              
FORMUL   3  HOH   *159(H2 O)                                                    
CRYST1   45.428   72.862   75.890  90.00  90.00  90.00 P 21 21 21    8          
ATOM      1  N   MET A 727      35.522  23.204 104.788  1.00 27.50           N  
ATOM      2  CA  MET A 727      36.486  23.324 105.905  1.00 28.60           C  
ATOM      3  C   MET A 727      36.016  22.717 107.235  1.00 38.40           C  
ATOM      4  O   MET A 727      35.253  23.338 107.985  1.00 37.12           O  
ATOM      5  CB  MET A 727      36.903  24.776 106.135  1.00 24.09           C  
ATOM      6  N   GLU A 728      36.439  21.462 107.450  1.00 40.19           N  
ATOM      7  CA  GLU A 728      36.967  20.987 108.736  1.00 33.79           C  
ATOM      8  C   GLU A 728      38.505  21.091 108.617  1.00 33.73           C  
ATOM      9  O   GLU A 728      39.253  20.696 109.519  1.00 27.77           O  
ATOM     10  CB  GLU A 728      36.580  19.532 108.994  1.00 31.06           C  
ATOM     11  N   ASP A 729      38.946  21.594 107.457  1.00 27.66           N  
ATOM     12  CA  ASP A 729      40.332  21.907 107.146  1.00 21.31           C  
ATOM     13  C   ASP A 729      40.383  23.395 106.805  1.00 13.39           C  
ATOM     14  O   ASP A 729      40.502  23.767 105.637  1.00 14.93           O  
ATOM     15  CB  ASP A 729      40.794  21.040 105.952  1.00 20.04           C  
ATOM     16  CG  ASP A 729      42.277  21.131 105.690  1.00 25.18           C  
ATOM     17  OD1 ASP A 729      42.944  21.938 106.371  1.00 22.19           O  
ATOM     18  OD2 ASP A 729      42.766  20.383 104.809  1.00 23.57           O  
ATOM     19  N   PRO A 730      40.263  24.264 107.832  1.00 18.17           N  
ATOM     20  CA  PRO A 730      40.231  25.697 107.613  1.00 16.88           C  
ATOM     21  C   PRO A 730      41.482  26.263 106.959  1.00 20.21           C  
ATOM     22  O   PRO A 730      41.396  27.271 106.245  1.00 16.29           O  
ATOM     23  CB  PRO A 730      40.036  26.275 109.032  1.00 22.04           C  
ATOM     24  CG  PRO A 730      40.313  25.189 109.942  1.00 12.01           C  
ATOM     25  CD  PRO A 730      39.947  23.945 109.234  1.00 14.46           C  
ATOM     26  N   ASP A 731      42.616  25.613 107.200  1.00 17.06           N  
ATOM     27  CA  ASP A 731      43.883  26.058 106.672  1.00 21.99           C  
ATOM     28  C   ASP A 731      43.916  25.855 105.167  1.00 11.94           C  
ATOM     29  O   ASP A 731      44.326  26.769 104.460  1.00 10.47           O  
ATOM     30  CB  ASP A 731      45.059  25.322 107.338  1.00 27.16           C  
ATOM     31  CG  ASP A 731      45.192  25.632 108.829  1.00 31.16           C  
ATOM     32  OD1 ASP A 731      44.523  26.565 109.340  1.00 36.96           O  
ATOM     33  OD2 ASP A 731      45.993  24.932 109.478  1.00 36.45           O  
ATOM     34  N   GLN A 732      43.482  24.683 104.670  1.00  9.59           N  
ATOM     35  CA  GLN A 732      43.410  24.473 103.209  1.00 12.84           C  
ATOM     36  C   GLN A 732      42.578  25.582 102.530  1.00  6.94           C  
ATOM     37  O   GLN A 732      43.013  26.157 101.540  1.00 14.02           O  
ATOM     38  CB  GLN A 732      42.856  23.079 102.811  1.00  9.68           C  
ATOM     39  CG  GLN A 732      42.818  22.911 101.254  1.00 16.37           C  
ATOM     40  CD  GLN A 732      42.098  21.685 100.783  1.00 27.64           C  
ATOM     41  OE1 GLN A 732      41.143  21.221 101.408  1.00 31.76           O  
ATOM     42  NE2 GLN A 732      42.535  21.155  99.665  1.00 21.62           N  
ATOM     43  N   LEU A 733      41.407  25.876 103.093  1.00  9.52           N  
ATOM     44  CA  LEU A 733      40.497  26.925 102.594  1.00 14.72           C  
ATOM     45  C   LEU A 733      41.189  28.266 102.556  1.00 10.31           C  
ATOM     46  O   LEU A 733      41.192  28.924 101.516  1.00 11.39           O  
ATOM     47  CB  LEU A 733      39.224  27.042 103.463  1.00  9.91           C  
ATOM     48  CG  LEU A 733      38.127  28.033 103.023  1.00 10.58           C  
ATOM     49  CD1 LEU A 733      37.658  27.686 101.594  1.00 10.55           C  
ATOM     50  CD2 LEU A 733      36.961  28.112 103.968  1.00 10.26           C  
ATOM     51  N   TYR A 734      41.797  28.644 103.685  1.00 12.21           N  
ATOM     52  CA  TYR A 734      42.459  29.950 103.814  1.00 13.02           C  
ATOM     53  C   TYR A 734      43.518  30.189 102.742  1.00 11.04           C  
ATOM     54  O   TYR A 734      43.550  31.222 102.075  1.00 10.22           O  
ATOM     55  CB  TYR A 734      43.080  30.113 105.222  1.00 10.83           C  
ATOM     56  CG  TYR A 734      43.724  31.468 105.437  1.00 17.30           C  
ATOM     57  CD1 TYR A 734      42.943  32.568 105.762  1.00  8.61           C  
ATOM     58  CD2 TYR A 734      45.101  31.654 105.282  1.00 19.21           C  
ATOM     59  CE1 TYR A 734      43.507  33.835 105.916  1.00 15.78           C  
ATOM     60  CE2 TYR A 734      45.691  32.923 105.461  1.00 18.16           C  
ATOM     61  CZ  TYR A 734      44.873  34.009 105.771  1.00 16.19           C  
ATOM     62  OH  TYR A 734      45.402  35.254 105.965  1.00 24.95           O  
ATOM     63  N   THR A 735      44.410  29.229 102.602  1.00 13.53           N  
ATOM     64  CA  THR A 735      45.514  29.339 101.672  1.00 12.54           C  
ATOM     65  C   THR A 735      45.004  29.272 100.235  1.00 11.14           C  
ATOM     66  O   THR A 735      45.464  30.037  99.394  1.00 13.90           O  
ATOM     67  CB  THR A 735      46.583  28.256 101.957  1.00 22.63           C  
ATOM     68  OG1 THR A 735      45.944  26.992 102.057  1.00 17.84           O  
ATOM     69  CG2 THR A 735      47.303  28.530 103.268  1.00 18.83           C  
ATOM     70  N   THR A 736      44.031  28.403  99.955  1.00 12.68           N  
ATOM     71  CA  THR A 736      43.341  28.409  98.649  1.00 13.99           C  
ATOM     72  C   THR A 736      42.734  29.774  98.269  1.00 15.56           C  
ATOM     73  O   THR A 736      43.005  30.287  97.178  1.00 14.40           O  
ATOM     74  CB  THR A 736      42.252  27.340  98.568  1.00 13.06           C  
ATOM     75  OG1 THR A 736      42.829  26.070  98.846  1.00 12.40           O  
ATOM     76  CG2 THR A 736      41.616  27.332  97.181  1.00 10.29           C  
ATOM     77  N   LEU A 737      41.957  30.366  99.177  1.00 16.23           N  
ATOM     78  CA  LEU A 737      41.382  31.714  98.956  1.00 17.81           C  
ATOM     79  C   LEU A 737      42.451  32.805  98.837  1.00 11.21           C  
ATOM     80  O   LEU A 737      42.344  33.723  98.036  1.00 14.94           O  
ATOM     81  CB  LEU A 737      40.369  32.065 100.075  1.00 17.03           C  
ATOM     82  CG  LEU A 737      39.176  31.093 100.179  1.00 14.40           C  
ATOM     83  CD1 LEU A 737      38.154  31.407 101.320  1.00  5.58           C  
ATOM     84  CD2 LEU A 737      38.484  31.019  98.819  1.00  6.18           C  
ATOM     85  N   LYS A 738      43.474  32.727  99.662  1.00 15.92           N  
ATOM     86  CA  LYS A 738      44.523  33.746  99.666  1.00 16.78           C  
ATOM     87  C   LYS A 738      45.296  33.708  98.339  1.00 16.01           C  
ATOM     88  O   LYS A 738      45.592  34.742  97.736  1.00 10.73           O  
ATOM     89  CB  LYS A 738      45.473  33.534 100.865  1.00 20.26           C  
ATOM     90  CG  LYS A 738      46.864  34.208 100.776  1.00 14.76           C  
ATOM     91  CD  LYS A 738      47.615  34.145 102.133  1.00 19.39           C  
ATOM     92  N   ASN A 739      45.597  32.503  97.894  1.00 14.30           N  
ATOM     93  CA  ASN A 739      46.243  32.314  96.600  1.00 17.30           C  
ATOM     94  C   ASN A 739      45.386  32.755  95.436  1.00 16.56           C  
ATOM     95  O   ASN A 739      45.914  33.346  94.472  1.00 16.11           O  
ATOM     96  CB  ASN A 739      46.689  30.867  96.412  1.00  6.36           C  
ATOM     97  CG  ASN A 739      47.928  30.498  97.276  1.00  7.72           C  
ATOM     98  OD1 ASN A 739      48.690  31.334  97.678  1.00 19.08           O  
ATOM     99  ND2 ASN A 739      48.116  29.221  97.501  1.00 13.22           N  
ATOM    100  N   LEU A 740      44.077  32.472  95.523  1.00 20.54           N  
ATOM    101  CA  LEU A 740      43.137  32.960  94.549  1.00 17.16           C  
ATOM    102  C   LEU A 740      43.085  34.497  94.509  1.00 16.95           C  
ATOM    103  O   LEU A 740      43.075  35.067  93.442  1.00 10.70           O  
ATOM    104  CB  LEU A 740      41.717  32.428  94.814  1.00 18.24           C  
ATOM    105  CG  LEU A 740      40.597  32.907  93.857  1.00 13.36           C  
ATOM    106  CD1 LEU A 740      40.998  32.692  92.362  1.00 19.07           C  
ATOM    107  CD2 LEU A 740      39.273  32.186  94.179  1.00  7.25           C  
ATOM    108  N   LEU A 741      43.018  35.142  95.668  1.00 14.46           N  
ATOM    109  CA  LEU A 741      42.749  36.579  95.725  1.00 18.13           C  
ATOM    110  C   LEU A 741      43.973  37.371  95.317  1.00 12.10           C  
ATOM    111  O   LEU A 741      43.814  38.452  94.739  1.00 11.25           O  
ATOM    112  CB  LEU A 741      42.243  37.015  97.124  1.00 15.62           C  
ATOM    113  CG  LEU A 741      41.910  38.491  97.377  1.00 16.53           C  
ATOM    114  CD1 LEU A 741      40.677  38.941  96.541  1.00 12.55           C  
ATOM    115  CD2 LEU A 741      41.717  38.761  98.902  1.00 15.82           C  
ATOM    116  N   ALA A 742      45.167  36.854  95.660  1.00 16.03           N  
ATOM    117  CA  ALA A 742      46.435  37.440  95.257  1.00 18.41           C  
ATOM    118  C   ALA A 742      46.519  37.544  93.727  1.00 16.83           C  
ATOM    119  O   ALA A 742      46.951  38.564  93.174  1.00 16.30           O  
ATOM    120  CB  ALA A 742      47.652  36.644  95.846  1.00 10.89           C  
ATOM    121  N   GLN A 743      46.107  36.477  93.059  1.00 13.39           N  
ATOM    122  CA  GLN A 743      46.024  36.422  91.592  1.00 16.88           C  
ATOM    123  C   GLN A 743      44.996  37.357  90.963  1.00 19.86           C  
ATOM    124  O   GLN A 743      45.302  38.023  89.964  1.00 11.73           O  
ATOM    125  CB  GLN A 743      45.644  35.026  91.154  1.00  8.28           C  
ATOM    126  CG  GLN A 743      46.676  34.011  91.435  1.00 12.30           C  
ATOM    127  CD  GLN A 743      46.198  32.634  91.130  1.00 11.78           C  
ATOM    128  OE1 GLN A 743      46.116  32.236  89.950  1.00 16.34           O  
ATOM    129  NE2 GLN A 743      45.947  31.855  92.179  1.00 13.52           N  
ATOM    130  N   ILE A 744      43.783  37.384  91.547  1.00 14.46           N  
ATOM    131  CA  ILE A 744      42.725  38.310  91.131  1.00 15.29           C  
ATOM    132  C   ILE A 744      43.196  39.769  91.262  1.00 11.52           C  
ATOM    133  O   ILE A 744      43.046  40.566  90.334  1.00 14.57           O  
ATOM    134  CB  ILE A 744      41.434  38.085  91.944  1.00 18.51           C  
ATOM    135  CG1 ILE A 744      40.797  36.718  91.583  1.00 22.32           C  
ATOM    136  CG2 ILE A 744      40.515  39.255  91.741  1.00 15.45           C  
ATOM    137  CD1 ILE A 744      39.613  36.293  92.478  1.00 18.25           C  
ATOM    138  N   LYS A 745      43.793  40.121  92.397  1.00 13.88           N  
ATOM    139  CA  LYS A 745      44.298  41.495  92.591  1.00 14.56           C  
ATOM    140  C   LYS A 745      45.481  41.881  91.681  1.00 15.39           C  
ATOM    141  O   LYS A 745      45.805  43.071  91.552  1.00 12.77           O  
ATOM    142  CB  LYS A 745      44.682  41.733  94.060  1.00 11.33           C  
ATOM    143  CG  LYS A 745      43.513  41.702  94.987  1.00 10.67           C  
ATOM    144  CD  LYS A 745      43.955  41.565  96.390  1.00 14.79           C  
ATOM    145  CE  LYS A 745      44.589  42.843  96.935  1.00 20.78           C  
ATOM    146  NZ  LYS A 745      45.152  42.550  98.282  1.00 23.90           N  
ATOM    147  N   SER A 746      46.101  40.872  91.067  1.00 23.12           N  
ATOM    148  CA  SER A 746      47.203  41.052  90.117  1.00 18.75           C  
ATOM    149  C   SER A 746      46.757  41.303  88.693  1.00 18.27           C  
ATOM    150  O   SER A 746      47.584  41.733  87.899  1.00  9.71           O  
ATOM    151  CB  SER A 746      48.107  39.821  90.111  1.00 19.67           C  
ATOM    152  OG  SER A 746      48.768  39.693  91.343  1.00 14.85           O  
ATOM    153  N   HIS A 747      45.486  40.981  88.374  1.00 15.17           N  
ATOM    154  CA  HIS A 747      44.955  41.073  87.021  1.00 15.98           C  
ATOM    155  C   HIS A 747      44.729  42.574  86.697  1.00 12.86           C  
ATOM    156  O   HIS A 747      44.210  43.307  87.545  1.00 13.92           O  
ATOM    157  CB  HIS A 747      43.640  40.287  86.909  1.00 17.92           C  
ATOM    158  CG  HIS A 747      43.211  40.036  85.504  1.00  9.93           C  
ATOM    159  ND1 HIS A 747      42.539  40.974  84.749  1.00 12.14           N  
ATOM    160  CD2 HIS A 747      43.411  38.968  84.690  1.00 19.11           C  
ATOM    161  CE1 HIS A 747      42.317  40.485  83.540  1.00 14.58           C  
ATOM    162  NE2 HIS A 747      42.850  39.274  83.473  1.00 12.78           N  
ATOM    163  N   PRO A 748      45.114  43.031  85.488  1.00 11.02           N  
ATOM    164  CA  PRO A 748      44.973  44.464  85.136  1.00 16.15           C  
ATOM    165  C   PRO A 748      43.496  45.007  85.155  1.00 15.17           C  
ATOM    166  O   PRO A 748      43.271  46.207  85.360  1.00 17.95           O  
ATOM    167  CB  PRO A 748      45.605  44.526  83.743  1.00 13.60           C  
ATOM    168  CG  PRO A 748      45.429  43.160  83.208  1.00  8.60           C  
ATOM    169  CD  PRO A 748      45.691  42.279  84.371  1.00  7.98           C  
ATOM    170  N   SER A 749      42.510  44.128  84.990  1.00 14.00           N  
ATOM    171  CA  SER A 749      41.095  44.546  85.014  1.00 20.74           C  
ATOM    172  C   SER A 749      40.522  44.682  86.447  1.00 12.54           C  
ATOM    173  O   SER A 749      39.404  45.208  86.639  1.00 15.02           O  
ATOM    174  CB  SER A 749      40.245  43.599  84.170  0.50 19.26           C  
ATOM    176  OG  SER A 749      40.819  43.420  82.888  0.50 19.19           O  
ATOM    178  N   ALA A 750      41.321  44.286  87.443  1.00 14.86           N  
ATOM    179  CA  ALA A 750      40.992  44.492  88.862  1.00 18.91           C  
ATOM    180  C   ALA A 750      41.134  45.957  89.289  1.00 18.84           C  
ATOM    181  O   ALA A 750      40.664  46.288  90.360  1.00 15.17           O  
ATOM    182  CB  ALA A 750      41.868  43.596  89.808  1.00  7.55           C  
ATOM    183  N   TRP A 751      41.756  46.821  88.477  1.00 11.56           N  
ATOM    184  CA  TRP A 751      42.058  48.208  88.920  1.00 13.81           C  
ATOM    185  C   TRP A 751      40.834  49.003  89.432  1.00  7.55           C  
ATOM    186  O   TRP A 751      40.961  49.647  90.485  1.00 15.94           O  
ATOM    187  CB  TRP A 751      42.936  49.024  87.899  1.00 14.83           C  
ATOM    188  CG  TRP A 751      42.187  49.560  86.678  1.00 17.95           C  
ATOM    189  CD1 TRP A 751      42.094  48.960  85.448  1.00 23.04           C  
ATOM    190  CD2 TRP A 751      41.417  50.779  86.582  1.00 21.47           C  
ATOM    191  NE1 TRP A 751      41.320  49.714  84.604  1.00 27.68           N  
ATOM    192  CE2 TRP A 751      40.887  50.833  85.269  1.00  9.16           C  
ATOM    193  CE3 TRP A 751      41.116  51.823  87.478  1.00 11.08           C  
ATOM    194  CZ2 TRP A 751      40.077  51.885  84.829  1.00 17.71           C  
ATOM    195  CZ3 TRP A 751      40.299  52.863  87.045  1.00 22.69           C  
ATOM    196  CH2 TRP A 751      39.788  52.884  85.730  1.00 20.15           C  
ATOM    197  N   PRO A 752      39.638  48.927  88.772  1.00 12.13           N  
ATOM    198  CA  PRO A 752      38.574  49.751  89.341  1.00 12.13           C  
ATOM    199  C   PRO A 752      37.965  49.234  90.638  1.00 16.11           C  
ATOM    200  O   PRO A 752      37.220  49.956  91.263  1.00 14.28           O  
ATOM    201  CB  PRO A 752      37.500  49.770  88.243  1.00 16.08           C  
ATOM    202  CG  PRO A 752      38.156  49.101  87.028  1.00 16.98           C  
ATOM    203  CD  PRO A 752      39.144  48.205  87.582  1.00  8.00           C  
ATOM    204  N   PHE A 753      38.324  48.015  91.042  1.00  9.90           N  
ATOM    205  CA  PHE A 753      37.684  47.277  92.106  1.00 11.87           C  
ATOM    206  C   PHE A 753      38.651  47.067  93.263  1.00 18.13           C  
ATOM    207  O   PHE A 753      38.365  46.291  94.184  1.00 12.13           O  
ATOM    208  CB  PHE A 753      37.236  45.918  91.547  1.00 14.84           C  
ATOM    209  CG  PHE A 753      36.533  46.031  90.205  1.00 10.02           C  
ATOM    210  CD1 PHE A 753      35.330  46.729  90.112  1.00 12.50           C  
ATOM    211  CD2 PHE A 753      37.035  45.438  89.081  1.00 14.22           C  
ATOM    212  CE1 PHE A 753      34.684  46.853  88.922  1.00 16.99           C  
ATOM    213  CE2 PHE A 753      36.367  45.550  87.872  1.00 20.11           C  
ATOM    214  CZ  PHE A 753      35.201  46.269  87.799  1.00 14.72           C  
ATOM    215  N   MET A 754      39.783  47.776  93.233  1.00 16.41           N  
ATOM    216  CA  MET A 754      40.871  47.531  94.198  1.00 18.13           C  
ATOM    217  C   MET A 754      40.579  48.133  95.586  1.00 16.79           C  
ATOM    218  O   MET A 754      41.074  47.651  96.606  1.00 14.83           O  
ATOM    219  CB  MET A 754      42.244  48.047  93.662  1.00 17.29           C  
ATOM    220  CG  MET A 754      42.919  47.126  92.628  1.00 15.04           C  
ATOM    221  SD  MET A 754      43.405  45.486  93.214  1.00 21.99           S  
ATOM    222  CE  MET A 754      44.975  45.912  94.020  1.00 21.67           C  
ATOM    223  N   GLU A 755      39.753  49.169  95.624  1.00 15.35           N  
ATOM    224  CA  GLU A 755      39.462  49.872  96.851  1.00 15.32           C  
ATOM    225  C   GLU A 755      38.016  50.315  96.841  1.00 17.26           C  
ATOM    226  O   GLU A 755      37.381  50.358  95.765  1.00 13.49           O  
ATOM    227  CB  GLU A 755      40.376  51.103  96.986  1.00 18.96           C  
ATOM    228  CG  GLU A 755      41.847  50.737  97.027  1.00 32.50           C  
ATOM    229  CD  GLU A 755      42.680  51.859  97.527  1.00 44.95           C  
ATOM    230  OE1 GLU A 755      42.436  53.001  97.078  1.00 52.04           O  
ATOM    231  OE2 GLU A 755      43.560  51.597  98.373  1.00 59.04           O  
ATOM    232  N   PRO A 756      37.491  50.670  98.025  1.00 16.47           N  
ATOM    233  CA  PRO A 756      36.126  51.162  98.001  1.00 16.22           C  
ATOM    234  C   PRO A 756      35.914  52.420  97.130  1.00 15.45           C  
ATOM    235  O   PRO A 756      36.731  53.350  97.119  1.00 15.62           O  
ATOM    236  CB  PRO A 756      35.830  51.471  99.474  1.00 19.18           C  
ATOM    237  CG  PRO A 756      36.891  50.810 100.269  1.00 16.17           C  
ATOM    238  CD  PRO A 756      38.077  50.721  99.377  1.00 14.54           C  
ATOM    239  N   VAL A 757      34.796  52.423  96.413  1.00 20.27           N  
ATOM    240  CA  VAL A 757      34.293  53.593  95.678  1.00 15.57           C  
ATOM    241  C   VAL A 757      34.380  54.848  96.568  1.00 15.03           C  
ATOM    242  O   VAL A 757      33.882  54.855  97.699  1.00 17.75           O  
ATOM    243  CB  VAL A 757      32.799  53.350  95.220  1.00 17.60           C  
ATOM    244  CG1 VAL A 757      32.239  54.540  94.501  1.00 20.01           C  
ATOM    245  CG2 VAL A 757      32.686  52.117  94.326  1.00 12.83           C  
ATOM    246  N   LYS A 758      35.034  55.895  96.075  1.00 17.66           N  
ATOM    247  CA  LYS A 758      34.963  57.204  96.708  1.00 18.43           C  
ATOM    248  C   LYS A 758      33.661  57.912  96.324  1.00 12.95           C  
ATOM    249  O   LYS A 758      33.235  57.855  95.162  1.00 22.35           O  
ATOM    250  CB  LYS A 758      36.183  58.078  96.328  1.00 21.92           C  
ATOM    251  CG  LYS A 758      37.539  57.619  96.924  1.00 22.65           C  
ATOM    252  N   LYS A 759      33.056  58.600  97.287  1.00 19.42           N  
ATOM    253  CA  LYS A 759      31.824  59.380  97.051  1.00 20.83           C  
ATOM    254  C   LYS A 759      32.096  60.619  96.209  1.00 19.76           C  
ATOM    255  O   LYS A 759      31.286  61.005  95.387  1.00 21.87           O  
ATOM    256  CB  LYS A 759      31.200  59.816  98.362  1.00 17.52           C  
ATOM    257  CG  LYS A 759      30.722  58.711  99.279  1.00 27.04           C  
ATOM    258  CD  LYS A 759      30.240  59.365 100.583  1.00 20.16           C  
ATOM    259  CE  LYS A 759      29.097  58.622 101.264  1.00 32.16           C  
ATOM    260  NZ  LYS A 759      29.452  58.098 102.635  1.00 42.27           N  
ATOM    261  N   SER A 760      33.251  61.243  96.397  1.00 20.58           N  
ATOM    262  CA  SER A 760      33.636  62.356  95.532  1.00 20.12           C  
ATOM    263  C   SER A 760      33.592  61.968  94.064  1.00 19.23           C  
ATOM    264  O   SER A 760      33.534  62.831  93.207  1.00 29.95           O  
ATOM    265  CB  SER A 760      35.035  62.870  95.888  1.00 21.02           C  
ATOM    266  OG  SER A 760      35.992  61.843  95.777  1.00 19.87           O  
ATOM    267  N   GLU A 761      33.640  60.672  93.769  1.00 19.40           N  
ATOM    268  CA  GLU A 761      33.507  60.199  92.395  1.00 20.33           C  
ATOM    269  C   GLU A 761      32.079  59.699  92.058  1.00 14.90           C  
ATOM    270  O   GLU A 761      31.591  59.947  90.972  1.00 18.60           O  
ATOM    271  CB  GLU A 761      34.533  59.106  92.105  1.00 16.73           C  
ATOM    272  CG  GLU A 761      34.273  58.420  90.749  1.00 41.92           C  
ATOM    273  CD  GLU A 761      35.340  57.400  90.324  1.00 58.22           C  
ATOM    274  OE1 GLU A 761      36.444  57.343  90.922  1.00 42.62           O  
ATOM    275  OE2 GLU A 761      35.047  56.651  89.362  1.00 32.85           O  
ATOM    276  N   ALA A 762      31.452  58.997  92.998  1.00 10.94           N  
ATOM    277  CA  ALA A 762      30.125  58.416  92.845  1.00 18.29           C  
ATOM    278  C   ALA A 762      29.309  58.704  94.116  1.00 17.65           C  
ATOM    279  O   ALA A 762      29.174  57.838  94.993  1.00 16.67           O  
ATOM    280  CB  ALA A 762      30.244  56.927  92.569  1.00 16.27           C  
ATOM    281  N   PRO A 763      28.776  59.950  94.225  1.00 17.80           N  
ATOM    282  CA  PRO A 763      28.255  60.481  95.506  1.00  8.81           C  
ATOM    283  C   PRO A 763      27.009  59.775  96.070  1.00  5.90           C  
ATOM    284  O   PRO A 763      26.817  59.765  97.271  1.00  8.62           O  
ATOM    285  CB  PRO A 763      28.021  61.964  95.210  1.00  8.73           C  
ATOM    286  CG  PRO A 763      27.977  62.072  93.699  1.00 11.81           C  
ATOM    287  CD  PRO A 763      28.830  60.986  93.169  1.00 19.38           C  
ATOM    288  N   ASP A 764      26.206  59.133  95.231  1.00  7.14           N  
ATOM    289  CA  ASP A 764      25.078  58.326  95.715  1.00  9.33           C  
ATOM    290  C   ASP A 764      25.345  56.813  95.821  1.00 14.40           C  
ATOM    291  O   ASP A 764      24.404  56.051  96.073  1.00  8.30           O  
ATOM    292  CB  ASP A 764      23.857  58.549  94.813  1.00 14.82           C  
ATOM    293  CG  ASP A 764      24.074  58.033  93.404  1.00  5.27           C  
ATOM    294  OD1 ASP A 764      25.252  57.857  93.000  1.00 12.84           O  
ATOM    295  OD2 ASP A 764      23.043  57.816  92.708  1.00 15.10           O  
ATOM    296  N   TYR A 765      26.608  56.396  95.614  1.00 16.28           N  
ATOM    297  CA  TYR A 765      26.950  54.984  95.450  1.00 15.69           C  
ATOM    298  C   TYR A 765      26.445  54.144  96.605  1.00  5.63           C  
ATOM    299  O   TYR A 765      25.943  53.016  96.402  1.00 11.39           O  
ATOM    300  CB  TYR A 765      28.469  54.753  95.321  1.00 15.38           C  
ATOM    301  CG  TYR A 765      28.811  53.323  94.925  1.00  9.05           C  
ATOM    302  CD1 TYR A 765      28.717  52.917  93.602  1.00 12.29           C  
ATOM    303  CD2 TYR A 765      29.256  52.377  95.887  1.00 12.72           C  
ATOM    304  CE1 TYR A 765      29.030  51.617  93.222  1.00 16.46           C  
ATOM    305  CE2 TYR A 765      29.588  51.076  95.513  1.00 12.66           C  
ATOM    306  CZ  TYR A 765      29.438  50.699  94.181  1.00 11.18           C  
ATOM    307  OH  TYR A 765      29.713  49.452  93.774  1.00 12.52           O  
ATOM    308  N   TYR A 766      26.623  54.674  97.809  1.00 15.36           N  
ATOM    309  CA  TYR A 766      26.367  53.932  99.029  1.00 14.80           C  
ATOM    310  C   TYR A 766      24.890  53.935  99.451  1.00 15.43           C  
ATOM    311  O   TYR A 766      24.494  53.130 100.275  1.00 16.75           O  
ATOM    312  CB  TYR A 766      27.319  54.407 100.130  1.00 14.64           C  
ATOM    313  CG  TYR A 766      28.751  54.071  99.779  1.00 10.04           C  
ATOM    314  CD1 TYR A 766      29.273  52.802 100.044  1.00 19.11           C  
ATOM    315  CD2 TYR A 766      29.580  55.014  99.147  1.00 12.59           C  
ATOM    316  CE1 TYR A 766      30.588  52.470  99.692  1.00 13.00           C  
ATOM    317  CE2 TYR A 766      30.868  54.718  98.821  1.00 21.56           C  
ATOM    318  CZ  TYR A 766      31.389  53.444  99.093  1.00 20.87           C  
ATOM    319  OH  TYR A 766      32.697  53.172  98.743  1.00 12.97           O  
ATOM    320  N   GLU A 767      24.093  54.823  98.849  1.00 12.88           N  
ATOM    321  CA  GLU A 767      22.637  54.710  98.854  1.00  6.67           C  
ATOM    322  C   GLU A 767      22.120  53.666  97.814  1.00 11.30           C  
ATOM    323  O   GLU A 767      21.244  52.844  98.132  1.00 16.44           O  
ATOM    324  CB  GLU A 767      22.011  56.103  98.657  1.00  9.53           C  
ATOM    325  CG  GLU A 767      20.456  56.131  98.658  1.00 19.25           C  
ATOM    326  CD  GLU A 767      19.805  55.280  99.771  1.00 14.99           C  
ATOM    327  OE1 GLU A 767      20.314  55.302 100.911  1.00 24.69           O  
ATOM    328  OE2 GLU A 767      18.791  54.584  99.475  1.00 21.09           O  
ATOM    329  N   VAL A 768      22.679  53.679  96.602  1.00 11.41           N  
ATOM    330  CA  VAL A 768      22.224  52.807  95.484  1.00 13.67           C  
ATOM    331  C   VAL A 768      22.670  51.356  95.747  1.00 13.27           C  
ATOM    332  O   VAL A 768      21.866  50.435  95.657  1.00 13.41           O  
ATOM    333  CB  VAL A 768      22.758  53.281  94.096  1.00 13.81           C  
ATOM    334  CG1 VAL A 768      22.476  52.268  92.968  1.00 10.10           C  
ATOM    335  CG2 VAL A 768      22.158  54.628  93.733  1.00 11.14           C  
ATOM    336  N   ILE A 769      23.924  51.191  96.159  1.00 11.38           N  
ATOM    337  CA  ILE A 769      24.543  49.886  96.380  1.00  9.69           C  
ATOM    338  C   ILE A 769      24.673  49.613  97.882  1.00 14.76           C  
ATOM    339  O   ILE A 769      25.542  50.180  98.565  1.00 16.20           O  
ATOM    340  CB  ILE A 769      25.935  49.817  95.666  1.00  5.85           C  
ATOM    341  CG1 ILE A 769      25.784  50.031  94.157  1.00  9.46           C  
ATOM    342  CG2 ILE A 769      26.727  48.467  96.020  1.00  6.37           C  
ATOM    343  CD1 ILE A 769      25.028  48.853  93.327  1.00  2.48           C  
ATOM    344  N   ARG A 770      23.800  48.749  98.413  1.00 14.92           N  
ATOM    345  CA  ARG A 770      23.721  48.586  99.876  1.00 19.13           C  
ATOM    346  C   ARG A 770      24.724  47.610 100.432  1.00 13.89           C  
ATOM    347  O   ARG A 770      24.988  47.643 101.622  1.00 12.00           O  
ATOM    348  CB  ARG A 770      22.303  48.200 100.300  1.00 17.09           C  
ATOM    349  CG  ARG A 770      21.304  49.268  99.948  1.00 12.90           C  
ATOM    350  CD  ARG A 770      21.601  50.545 100.728  1.00  6.87           C  
ATOM    351  NE  ARG A 770      20.485  51.454 100.616  1.00  5.74           N  
ATOM    352  CZ  ARG A 770      19.348  51.363 101.310  1.00 16.47           C  
ATOM    353  NH1 ARG A 770      19.162  50.416 102.213  1.00 10.95           N  
ATOM    354  NH2 ARG A 770      18.403  52.267 101.119  1.00 16.32           N  
ATOM    355  N   PHE A 771      25.277  46.749  99.576  1.00  6.80           N  
ATOM    356  CA  PHE A 771      26.376  45.865  99.976  1.00 17.12           C  
ATOM    357  C   PHE A 771      27.619  46.131  99.109  1.00 15.87           C  
ATOM    358  O   PHE A 771      28.051  45.291  98.324  1.00  9.94           O  
ATOM    359  CB  PHE A 771      25.963  44.408  99.925  1.00  7.70           C  
ATOM    360  CG  PHE A 771      24.849  44.072 100.874  1.00 15.60           C  
ATOM    361  CD1 PHE A 771      25.102  43.941 102.241  1.00  9.67           C  
ATOM    362  CD2 PHE A 771      23.529  43.933 100.408  1.00 14.45           C  
ATOM    363  CE1 PHE A 771      24.081  43.656 103.133  1.00 15.92           C  
ATOM    364  CE2 PHE A 771      22.503  43.674 101.290  1.00 10.29           C  
ATOM    365  CZ  PHE A 771      22.768  43.525 102.656  1.00 10.45           C  
ATOM    366  N   PRO A 772      28.207  47.319  99.279  1.00 13.63           N  
ATOM    367  CA  PRO A 772      29.442  47.584  98.572  1.00 15.44           C  
ATOM    368  C   PRO A 772      30.585  46.620  98.961  1.00 15.74           C  
ATOM    369  O   PRO A 772      30.707  46.160 100.128  1.00 17.70           O  
ATOM    370  CB  PRO A 772      29.727  49.046  98.941  1.00 14.66           C  
ATOM    371  CG  PRO A 772      29.097  49.231 100.202  1.00  8.00           C  
ATOM    372  CD  PRO A 772      27.974  48.321 100.335  1.00  8.76           C  
ATOM    373  N   ILE A 773      31.378  46.273  97.958  1.00  9.12           N  
ATOM    374  CA  ILE A 773      32.447  45.315  98.124  1.00 15.92           C  
ATOM    375  C   ILE A 773      33.547  45.676  97.129  1.00 15.73           C  
ATOM    376  O   ILE A 773      33.283  46.283  96.099  1.00 20.89           O  
ATOM    377  CB  ILE A 773      31.915  43.825  98.118  1.00 11.19           C  
ATOM    378  CG1 ILE A 773      32.979  42.823  98.624  1.00 13.17           C  
ATOM    379  CG2 ILE A 773      31.341  43.427  96.765  1.00  4.60           C  
ATOM    380  CD1 ILE A 773      33.429  43.000 100.129  1.00  5.56           C  
ATOM    381  N   ASP A 774      34.785  45.374  97.515  1.00 18.74           N  
ATOM    382  CA  ASP A 774      35.978  45.712  96.771  1.00 15.92           C  
ATOM    383  C   ASP A 774      37.086  44.737  97.208  1.00 11.77           C  
ATOM    384  O   ASP A 774      36.946  44.013  98.196  1.00 10.91           O  
ATOM    385  CB  ASP A 774      36.377  47.192  97.040  1.00  6.05           C  
ATOM    386  CG  ASP A 774      36.797  47.428  98.440  1.00 11.28           C  
ATOM    387  OD1 ASP A 774      35.951  47.728  99.307  1.00 14.06           O  
ATOM    388  OD2 ASP A 774      37.977  47.326  98.696  1.00 10.37           O  
ATOM    389  N   LEU A 775      38.205  44.756  96.511  1.00 14.21           N  
ATOM    390  CA  LEU A 775      39.283  43.807  96.777  1.00 11.22           C  
ATOM    391  C   LEU A 775      40.120  44.114  98.038  1.00  8.73           C  
ATOM    392  O   LEU A 775      40.660  43.215  98.625  1.00 11.79           O  
ATOM    393  CB  LEU A 775      40.129  43.588  95.508  1.00  9.44           C  
ATOM    394  CG  LEU A 775      39.348  43.087  94.276  1.00 16.32           C  
ATOM    395  CD1 LEU A 775      40.103  43.179  92.917  1.00  8.76           C  
ATOM    396  CD2 LEU A 775      38.839  41.652  94.506  1.00  8.13           C  
ATOM    397  N   LYS A 776      40.129  45.353  98.512  1.00  7.55           N  
ATOM    398  CA  LYS A 776      40.809  45.703  99.735  1.00 13.46           C  
ATOM    399  C   LYS A 776      40.019  45.161 100.906  1.00 11.37           C  
ATOM    400  O   LYS A 776      40.583  44.516 101.765  1.00  8.24           O  
ATOM    401  CB  LYS A 776      40.977  47.224  99.860  1.00 12.51           C  
ATOM    402  CG  LYS A 776      41.694  47.695 101.129  1.00 21.48           C  
ATOM    403  CD  LYS A 776      41.984  49.198 101.043  1.00 15.66           C  
ATOM    404  CE  LYS A 776      42.633  49.743 102.326  1.00 28.78           C  
ATOM    405  NZ  LYS A 776      41.644  49.946 103.413  1.00 34.52           N  
ATOM    406  N   THR A 777      38.699  45.387 100.895  1.00 12.36           N  
ATOM    407  CA  THR A 777      37.771  44.868 101.926  1.00 10.39           C  
ATOM    408  C   THR A 777      37.785  43.330 101.942  1.00 14.41           C  
ATOM    409  O   THR A 777      37.833  42.692 103.003  1.00 15.83           O  
ATOM    410  CB  THR A 777      36.371  45.434 101.693  1.00  7.23           C  
ATOM    411  OG1 THR A 777      36.467  46.876 101.633  1.00 12.44           O  
ATOM    412  CG2 THR A 777      35.339  45.009 102.797  1.00  7.88           C  
ATOM    413  N   MET A 778      37.864  42.739 100.770  1.00 14.48           N  
ATOM    414  CA  MET A 778      37.921  41.276 100.671  1.00 11.93           C  
ATOM    415  C   MET A 778      39.208  40.684 101.261  1.00 12.54           C  
ATOM    416  O   MET A 778      39.162  39.621 101.833  1.00 11.50           O  
ATOM    417  CB  MET A 778      37.751  40.833  99.244  1.00  6.82           C  
ATOM    418  CG  MET A 778      36.333  40.834  98.747  1.00 13.48           C  
ATOM    419  SD  MET A 778      36.153  39.953  97.161  1.00 15.05           S  
ATOM    420  CE  MET A 778      36.189  38.240  97.668  1.00 14.43           C  
ATOM    421  N   THR A 779      40.334  41.370 101.048  1.00  8.66           N  
ATOM    422  CA  THR A 779      41.631  41.090 101.662  1.00 14.34           C  
ATOM    423  C   THR A 779      41.550  41.214 103.192  1.00 10.52           C  
ATOM    424  O   THR A 779      42.101  40.383 103.901  1.00 12.36           O  
ATOM    425  CB  THR A 779      42.718  42.030 101.070  1.00  9.22           C  
ATOM    426  OG1 THR A 779      42.737  41.910  99.634  1.00  7.63           O  
ATOM    427  CG2 THR A 779      44.168  41.773 101.650  1.00  7.82           C  
ATOM    428  N   GLU A 780      40.822  42.217 103.684  1.00 14.42           N  
ATOM    429  CA  GLU A 780      40.664  42.425 105.124  1.00 10.00           C  
ATOM    430  C   GLU A 780      39.784  41.375 105.738  1.00  6.95           C  
ATOM    431  O   GLU A 780      40.079  40.864 106.820  1.00 10.67           O  
ATOM    432  CB  GLU A 780      40.117  43.793 105.429  1.00 11.55           C  
ATOM    433  CG  GLU A 780      41.103  44.891 105.108  1.00 13.17           C  
ATOM    434  CD  GLU A 780      40.497  46.283 104.966  1.00 15.67           C  
ATOM    435  OE1 GLU A 780      39.299  46.482 105.229  1.00 13.25           O  
ATOM    436  OE2 GLU A 780      41.255  47.202 104.601  1.00 23.44           O  
ATOM    437  N   ARG A 781      38.732  41.006 105.019  1.00 16.12           N  
ATOM    438  CA  ARG A 781      37.863  39.878 105.400  1.00 14.25           C  
ATOM    439  C   ARG A 781      38.621  38.548 105.397  1.00 11.28           C  
ATOM    440  O   ARG A 781      38.488  37.774 106.313  1.00 14.55           O  
ATOM    441  CB  ARG A 781      36.612  39.834 104.497  1.00 12.69           C  
ATOM    442  CG  ARG A 781      35.701  40.987 104.744  1.00  9.00           C  
ATOM    443  CD  ARG A 781      34.465  41.018 103.850  1.00  6.90           C  
ATOM    444  NE  ARG A 781      33.546  42.010 104.366  1.00 19.87           N  
ATOM    445  CZ  ARG A 781      32.252  42.044 104.095  1.00 14.21           C  
ATOM    446  NH1 ARG A 781      31.704  41.202 103.236  1.00 13.83           N  
ATOM    447  NH2 ARG A 781      31.521  42.970 104.636  1.00 22.33           N  
ATOM    448  N   LEU A 782      39.441  38.293 104.390  1.00 20.79           N  
ATOM    449  CA  LEU A 782      40.198  37.055 104.343  1.00 22.29           C  
ATOM    450  C   LEU A 782      41.102  36.976 105.563  1.00 13.59           C  
ATOM    451  O   LEU A 782      41.121  35.979 106.268  1.00 13.08           O  
ATOM    452  CB  LEU A 782      41.055  36.968 103.071  1.00 16.87           C  
ATOM    453  CG  LEU A 782      41.926  35.728 102.851  1.00 20.54           C  
ATOM    454  CD1 LEU A 782      41.084  34.457 102.624  1.00 14.68           C  
ATOM    455  CD2 LEU A 782      42.949  35.978 101.679  1.00  9.15           C  
ATOM    456  N   ARG A 783      41.830  38.047 105.806  1.00 11.83           N  
ATOM    457  CA  ARG A 783      42.829  38.050 106.864  1.00 16.77           C  
ATOM    458  C   ARG A 783      42.238  37.974 108.275  1.00 15.42           C  
ATOM    459  O   ARG A 783      42.858  37.400 109.181  1.00 13.49           O  
ATOM    460  CB  ARG A 783      43.772  39.215 106.653  1.00  8.44           C  
ATOM    461  CG  ARG A 783      44.604  38.978 105.380  1.00 12.97           C  
ATOM    462  CD  ARG A 783      45.300  40.242 104.928  1.00 13.39           C  
ATOM    463  NE  ARG A 783      46.150  40.862 105.981  1.00  8.95           N  
ATOM    464  CZ  ARG A 783      47.394  40.516 106.276  1.00  7.02           C  
ATOM    465  NH1 ARG A 783      47.973  39.491 105.677  1.00  5.98           N  
ATOM    466  NH2 ARG A 783      48.046  41.145 107.251  1.00  7.95           N  
ATOM    467  N   SER A 784      41.004  38.444 108.431  1.00 12.07           N  
ATOM    468  CA  SER A 784      40.320  38.355 109.715  1.00  9.01           C  
ATOM    469  C   SER A 784      39.486  37.061 109.858  1.00 10.97           C  
ATOM    470  O   SER A 784      38.829  36.897 110.832  1.00 12.70           O  
ATOM    471  CB  SER A 784      39.491  39.612 109.981  1.00 16.16           C  
ATOM    472  OG  SER A 784      38.554  39.843 108.976  1.00 18.52           O  
ATOM    473  N   ARG A 785      39.581  36.137 108.899  1.00 12.12           N  
ATOM    474  CA  ARG A 785      38.887  34.826 108.916  1.00 15.02           C  
ATOM    475  C   ARG A 785      37.380  34.941 108.776  1.00 15.21           C  
ATOM    476  O   ARG A 785      36.644  34.104 109.324  1.00 14.07           O  
ATOM    477  CB  ARG A 785      39.233  33.950 110.148  1.00 19.18           C  
ATOM    478  CG  ARG A 785      40.700  33.640 110.347  1.00 14.09           C  
ATOM    479  CD  ARG A 785      41.395  33.238 109.075  1.00 22.00           C  
ATOM    480  NE  ARG A 785      42.827  33.042 109.298  1.00 37.41           N  
ATOM    481  CZ  ARG A 785      43.458  31.870 109.299  1.00 30.25           C  
ATOM    482  NH1 ARG A 785      42.829  30.718 109.070  1.00 22.46           N  
ATOM    483  NH2 ARG A 785      44.758  31.858 109.526  1.00 31.46           N  
ATOM    484  N   TYR A 786      36.945  35.945 108.004  1.00 10.71           N  
ATOM    485  CA  TYR A 786      35.555  36.144 107.672  1.00 14.03           C  
ATOM    486  C   TYR A 786      35.084  35.017 106.788  1.00 13.04           C  
ATOM    487  O   TYR A 786      33.976  34.525 106.956  1.00  9.70           O  
ATOM    488  CB  TYR A 786      35.389  37.464 106.913  1.00 11.48           C  
ATOM    489  CG  TYR A 786      33.966  37.871 106.574  1.00 12.32           C  
ATOM    490  CD1 TYR A 786      33.292  38.803 107.356  1.00 22.76           C  
ATOM    491  CD2 TYR A 786      33.321  37.384 105.434  1.00  5.68           C  
ATOM    492  CE1 TYR A 786      32.014  39.218 107.054  1.00 18.25           C  
ATOM    493  CE2 TYR A 786      32.054  37.789 105.134  1.00 17.06           C  
ATOM    494  CZ  TYR A 786      31.398  38.723 105.946  1.00 14.81           C  
ATOM    495  OH  TYR A 786      30.112  39.154 105.654  1.00 12.95           O  
ATOM    496  N   TYR A 787      35.932  34.618 105.840  1.00 13.43           N  
ATOM    497  CA  TYR A 787      35.576  33.566 104.872  1.00 16.41           C  
ATOM    498  C   TYR A 787      35.667  32.099 105.351  1.00 16.66           C  
ATOM    499  O   TYR A 787      36.476  31.294 104.872  1.00 13.20           O  
ATOM    500  CB  TYR A 787      36.377  33.746 103.601  1.00 16.71           C  
ATOM    501  CG  TYR A 787      36.127  35.084 102.972  1.00  8.77           C  
ATOM    502  CD1 TYR A 787      34.818  35.519 102.741  1.00  9.70           C  
ATOM    503  CD2 TYR A 787      37.188  35.920 102.622  1.00 13.98           C  
ATOM    504  CE1 TYR A 787      34.561  36.734 102.138  1.00  6.03           C  
ATOM    505  CE2 TYR A 787      36.945  37.179 102.019  1.00  6.01           C  
ATOM    506  CZ  TYR A 787      35.647  37.578 101.808  1.00 15.49           C  
ATOM    507  OH  TYR A 787      35.422  38.781 101.243  1.00 13.25           O  
ATOM    508  N   VAL A 788      34.756  31.719 106.223  1.00 11.61           N  
ATOM    509  CA  VAL A 788      34.808  30.387 106.786  1.00 13.40           C  
ATOM    510  C   VAL A 788      34.299  29.305 105.791  1.00  8.75           C  
ATOM    511  O   VAL A 788      34.492  28.120 106.020  1.00 13.52           O  
ATOM    512  CB  VAL A 788      34.065  30.324 108.149  1.00 14.09           C  
ATOM    513  CG1 VAL A 788      34.846  31.116 109.251  1.00 16.94           C  
ATOM    514  CG2 VAL A 788      32.675  30.855 108.003  1.00  7.46           C  
ATOM    515  N   THR A 789      33.668  29.728 104.693  1.00  8.48           N  
ATOM    516  CA  THR A 789      33.285  28.845 103.612  1.00 11.33           C  
ATOM    517  C   THR A 789      33.789  29.480 102.304  1.00 11.37           C  
ATOM    518  O   THR A 789      33.955  30.683 102.198  1.00  9.40           O  
ATOM    519  CB  THR A 789      31.742  28.653 103.517  1.00 10.87           C  
ATOM    520  OG1 THR A 789      31.120  29.916 103.246  1.00 10.38           O  
ATOM    521  CG2 THR A 789      31.146  28.039 104.814  1.00 10.22           C  
ATOM    522  N   ARG A 790      34.011  28.633 101.312  1.00  8.99           N  
ATOM    523  CA  ARG A 790      34.279  29.064  99.924  1.00 16.14           C  
ATOM    524  C   ARG A 790      33.117  29.917  99.355  1.00  7.41           C  
ATOM    525  O   ARG A 790      33.335  30.862  98.626  1.00 15.13           O  
ATOM    526  CB  ARG A 790      34.494  27.834  99.040  1.00 11.93           C  
ATOM    527  CG  ARG A 790      34.112  28.022  97.579  1.00 25.43           C  
ATOM    528  CD  ARG A 790      34.227  26.766  96.746  1.00 43.52           C  
ATOM    529  NE  ARG A 790      33.409  25.667  97.234  1.00 29.75           N  
ATOM    530  CZ  ARG A 790      33.813  24.743  98.104  1.00 47.26           C  
ATOM    531  NH1 ARG A 790      35.041  24.761  98.621  1.00 56.51           N  
ATOM    532  NH2 ARG A 790      32.969  23.788  98.476  1.00 36.29           N  
ATOM    533  N   LYS A 791      31.894  29.532  99.682  1.00 16.98           N  
ATOM    534  CA  LYS A 791      30.710  30.255  99.219  1.00 19.85           C  
ATOM    535  C   LYS A 791      30.674  31.730  99.659  1.00 14.40           C  
ATOM    536  O   LYS A 791      30.240  32.562  98.884  1.00 14.20           O  
ATOM    537  CB  LYS A 791      29.432  29.506  99.628  1.00 17.11           C  
ATOM    538  CG  LYS A 791      29.090  28.286  98.754  1.00 18.62           C  
ATOM    539  CD  LYS A 791      27.910  27.495  99.361  1.00 32.86           C  
ATOM    540  CE  LYS A 791      26.565  28.136  99.111  1.00 47.16           C  
ATOM    541  NZ  LYS A 791      25.420  27.267  99.569  1.00 64.41           N  
ATOM    542  N   LEU A 792      31.125  32.040 100.877  1.00 10.07           N  
ATOM    543  CA  LEU A 792      31.149  33.430 101.389  1.00 15.69           C  
ATOM    544  C   LEU A 792      32.114  34.306 100.586  1.00 11.12           C  
ATOM    545  O   LEU A 792      31.796  35.486 100.246  1.00 10.92           O  
ATOM    546  CB  LEU A 792      31.482  33.464 102.900  1.00 18.39           C  
ATOM    547  CG  LEU A 792      30.370  33.202 103.915  1.00 19.73           C  
ATOM    548  CD1 LEU A 792      30.922  32.776 105.287  1.00  6.22           C  
ATOM    549  CD2 LEU A 792      29.422  34.419 104.035  1.00 14.96           C  
ATOM    550  N   PHE A 793      33.264  33.716 100.251  1.00 11.46           N  
ATOM    551  CA  PHE A 793      34.268  34.341  99.368  1.00 11.60           C  
ATOM    552  C   PHE A 793      33.732  34.568  97.973  1.00 15.16           C  
ATOM    553  O   PHE A 793      33.863  35.659  97.475  1.00  9.39           O  
ATOM    554  CB  PHE A 793      35.569  33.514  99.294  1.00  8.46           C  
ATOM    555  CG  PHE A 793      36.661  34.146  98.488  1.00  8.86           C  
ATOM    556  CD1 PHE A 793      37.618  34.953  99.091  1.00 15.98           C  
ATOM    557  CD2 PHE A 793      36.731  33.937  97.110  1.00 23.97           C  
ATOM    558  CE1 PHE A 793      38.625  35.527  98.338  1.00 14.32           C  
ATOM    559  CE2 PHE A 793      37.714  34.510  96.362  1.00  9.57           C  
ATOM    560  CZ  PHE A 793      38.695  35.297  96.991  1.00 10.89           C  
ATOM    561  N   VAL A 794      33.173  33.525  97.348  1.00 11.88           N  
ATOM    562  CA  VAL A 794      32.598  33.628  96.001  1.00 13.53           C  
ATOM    563  C   VAL A 794      31.436  34.628  95.960  1.00 12.33           C  
ATOM    564  O   VAL A 794      31.321  35.365  94.997  1.00 15.21           O  
ATOM    565  CB  VAL A 794      32.155  32.227  95.430  1.00  9.03           C  
ATOM    566  CG1 VAL A 794      31.523  32.390  94.067  1.00  8.11           C  
ATOM    567  CG2 VAL A 794      33.382  31.265  95.298  1.00 11.63           C  
ATOM    568  N   ALA A 795      30.570  34.642  96.992  1.00 10.04           N  
ATOM    569  CA  ALA A 795      29.485  35.612  97.031  1.00 10.10           C  
ATOM    570  C   ALA A 795      30.042  37.049  96.946  1.00  5.82           C  
ATOM    571  O   ALA A 795      29.550  37.846  96.164  1.00 12.71           O  
ATOM    572  CB  ALA A 795      28.578  35.403  98.283  1.00  6.53           C  
ATOM    573  N   ASP A 796      31.098  37.358  97.711  1.00 11.12           N  
ATOM    574  CA  ASP A 796      31.666  38.700  97.758  1.00 10.12           C  
ATOM    575  C   ASP A 796      32.339  39.063  96.446  1.00 11.25           C  
ATOM    576  O   ASP A 796      32.172  40.155  95.940  1.00 11.08           O  
ATOM    577  CB  ASP A 796      32.677  38.848  98.876  1.00 10.05           C  
ATOM    578  CG  ASP A 796      32.057  39.163 100.207  1.00 15.37           C  
ATOM    579  OD1 ASP A 796      30.827  39.056 100.358  1.00 20.36           O  
ATOM    580  OD2 ASP A 796      32.836  39.525 101.107  1.00 11.06           O  
ATOM    581  N   LEU A 797      33.081  38.117  95.887  1.00 13.73           N  
ATOM    582  CA  LEU A 797      33.697  38.309  94.574  1.00 11.38           C  
ATOM    583  C   LEU A 797      32.655  38.517  93.476  1.00  8.52           C  
ATOM    584  O   LEU A 797      32.759  39.440  92.627  1.00 15.01           O  
ATOM    585  CB  LEU A 797      34.599  37.089  94.261  1.00 14.54           C  
ATOM    586  CG  LEU A 797      35.575  37.234  93.100  1.00 20.73           C  
ATOM    587  CD1 LEU A 797      36.468  38.475  93.253  1.00 20.75           C  
ATOM    588  CD2 LEU A 797      36.361  35.911  92.997  1.00 25.51           C  
ATOM    589  N   GLN A 798      31.655  37.654  93.448  1.00 16.74           N  
ATOM    590  CA  GLN A 798      30.588  37.805  92.451  1.00 16.45           C  
ATOM    591  C   GLN A 798      29.805  39.123  92.623  1.00 13.99           C  
ATOM    592  O   GLN A 798      29.344  39.688  91.644  1.00 12.30           O  
ATOM    593  CB  GLN A 798      29.643  36.630  92.513  1.00 15.36           C  
ATOM    594  CG  GLN A 798      30.295  35.354  92.049  1.00 14.41           C  
ATOM    595  CD  GLN A 798      29.362  34.175  92.167  1.00 17.42           C  
ATOM    596  OE1 GLN A 798      28.525  34.125  93.063  1.00 17.42           O  
ATOM    597  NE2 GLN A 798      29.482  33.235  91.248  1.00 13.51           N  
ATOM    598  N   ARG A 799      29.719  39.633  93.854  1.00 13.12           N  
ATOM    599  CA  ARG A 799      29.062  40.904  94.112  1.00 11.94           C  
ATOM    600  C   ARG A 799      29.887  42.134  93.699  1.00  7.16           C  
ATOM    601  O   ARG A 799      29.318  43.202  93.445  1.00  7.29           O  
ATOM    602  CB  ARG A 799      28.626  40.989  95.579  1.00  9.73           C  
ATOM    603  CG  ARG A 799      27.701  42.188  95.895  1.00 14.29           C  
ATOM    604  CD  ARG A 799      27.121  42.107  97.305  1.00 11.20           C  
ATOM    605  NE  ARG A 799      28.105  42.342  98.350  1.00 14.53           N  
ATOM    606  CZ  ARG A 799      28.713  41.405  99.076  1.00  5.11           C  
ATOM    607  NH1 ARG A 799      29.607  41.797  99.950  1.00 16.11           N  
ATOM    608  NH2 ARG A 799      28.535  40.096  98.867  1.00  9.83           N  
ATOM    609  N   VAL A 800      31.212  42.009  93.635  1.00 17.49           N  
ATOM    610  CA  VAL A 800      32.056  43.100  93.111  1.00 11.93           C  
ATOM    611  C   VAL A 800      31.626  43.412  91.652  1.00 12.25           C  
ATOM    612  O   VAL A 800      31.497  44.583  91.234  1.00 11.12           O  
ATOM    613  CB  VAL A 800      33.540  42.720  93.082  1.00  8.93           C  
ATOM    614  CG1 VAL A 800      34.321  43.700  92.226  1.00  5.64           C  
ATOM    615  CG2 VAL A 800      34.149  42.575  94.509  1.00 11.62           C  
ATOM    616  N   ILE A 801      31.448  42.330  90.905  1.00 12.56           N  
ATOM    617  CA  ILE A 801      30.963  42.342  89.527  1.00 16.33           C  
ATOM    618  C   ILE A 801      29.486  42.787  89.428  1.00 13.51           C  
ATOM    619  O   ILE A 801      29.186  43.730  88.662  1.00  8.82           O  
ATOM    620  CB  ILE A 801      31.127  40.941  88.872  1.00  9.46           C  
ATOM    621  CG1 ILE A 801      32.559  40.408  88.996  1.00 15.07           C  
ATOM    622  CG2 ILE A 801      30.601  40.901  87.417  1.00  6.08           C  
ATOM    623  CD1 ILE A 801      33.616  41.290  88.438  1.00 13.66           C  
ATOM    624  N   ALA A 802      28.574  42.119  90.167  1.00 13.10           N  
ATOM    625  CA  ALA A 802      27.120  42.464  90.134  1.00  8.35           C  
ATOM    626  C   ALA A 802      26.907  43.939  90.532  1.00  7.51           C  
ATOM    627  O   ALA A 802      26.194  44.639  89.857  1.00 11.24           O  
ATOM    628  CB  ALA A 802      26.265  41.551  90.994  1.00  6.43           C  
ATOM    629  N   ASN A 803      27.561  44.396  91.590  1.00  9.96           N  
ATOM    630  CA  ASN A 803      27.499  45.809  91.960  1.00  9.55           C  
ATOM    631  C   ASN A 803      27.919  46.740  90.806  1.00  5.90           C  
ATOM    632  O   ASN A 803      27.274  47.763  90.538  1.00  9.10           O  
ATOM    633  CB  ASN A 803      28.365  46.090  93.206  1.00 11.74           C  
ATOM    634  CG  ASN A 803      27.680  45.714  94.507  1.00 13.60           C  
ATOM    635  OD1 ASN A 803      26.477  45.436  94.554  1.00 14.79           O  
ATOM    636  ND2 ASN A 803      28.451  45.736  95.590  1.00 10.61           N  
ATOM    637  N   CYS A 804      28.999  46.394  90.119  1.00  8.93           N  
ATOM    638  CA  CYS A 804      29.450  47.181  88.977  1.00 14.51           C  
ATOM    639  C   CYS A 804      28.399  47.303  87.874  1.00 16.40           C  
ATOM    640  O   CYS A 804      28.123  48.395  87.359  1.00  9.35           O  
ATOM    641  CB  CYS A 804      30.724  46.568  88.394  1.00 20.41           C  
ATOM    642  SG  CYS A 804      31.539  47.604  87.168  1.00 12.69           S  
ATOM    643  N   ARG A 805      27.848  46.156  87.498  1.00 14.03           N  
ATOM    644  CA  ARG A 805      26.815  46.071  86.504  1.00 12.69           C  
ATOM    645  C   ARG A 805      25.440  46.724  86.916  1.00  9.13           C  
ATOM    646  O   ARG A 805      24.686  47.185  86.067  1.00 16.80           O  
ATOM    647  CB  ARG A 805      26.639  44.602  86.134  1.00  7.08           C  
ATOM    648  CG  ARG A 805      27.813  44.025  85.386  1.00 10.38           C  
ATOM    649  CD  ARG A 805      27.539  42.560  85.052  1.00 17.70           C  
ATOM    650  NE  ARG A 805      28.648  42.014  84.298  1.00 12.85           N  
ATOM    651  CZ  ARG A 805      29.032  40.746  84.254  1.00 10.83           C  
ATOM    652  NH1 ARG A 805      28.412  39.775  84.935  1.00 15.20           N  
ATOM    653  NH2 ARG A 805      30.090  40.458  83.537  1.00 13.78           N  
ATOM    654  N   GLU A 806      25.136  46.763  88.210  1.00 14.80           N  
ATOM    655  CA  GLU A 806      23.951  47.464  88.708  1.00 13.37           C  
ATOM    656  C   GLU A 806      24.149  48.990  88.626  1.00 12.98           C  
ATOM    657  O   GLU A 806      23.261  49.723  88.194  1.00 14.76           O  
ATOM    658  CB  GLU A 806      23.672  47.071  90.149  1.00 16.51           C  
ATOM    659  CG  GLU A 806      22.321  47.548  90.682  1.00 25.84           C  
ATOM    660  CD  GLU A 806      21.102  46.936  89.928  1.00 53.43           C  
ATOM    661  OE1 GLU A 806      20.010  47.576  89.939  1.00 42.21           O  
ATOM    662  OE2 GLU A 806      21.238  45.833  89.323  1.00 33.44           O  
ATOM    663  N   TYR A 807      25.311  49.459  89.017  1.00  8.64           N  
ATOM    664  CA  TYR A 807      25.570  50.930  89.052  1.00 10.71           C  
ATOM    665  C   TYR A 807      26.102  51.576  87.793  1.00 13.96           C  
ATOM    666  O   TYR A 807      25.909  52.779  87.608  1.00 16.51           O  
ATOM    667  CB  TYR A 807      26.510  51.283  90.209  1.00  4.68           C  
ATOM    668  CG  TYR A 807      26.612  52.776  90.522  1.00 16.29           C  
ATOM    669  CD1 TYR A 807      25.725  53.379  91.414  1.00 16.55           C  
ATOM    670  CD2 TYR A 807      27.582  53.575  89.928  1.00 12.09           C  
ATOM    671  CE1 TYR A 807      25.816  54.758  91.733  1.00 10.46           C  
ATOM    672  CE2 TYR A 807      27.680  54.977  90.222  1.00 15.66           C  
ATOM    673  CZ  TYR A 807      26.801  55.543  91.145  1.00  4.97           C  
ATOM    674  OH  TYR A 807      26.865  56.880  91.442  1.00 10.86           O  
ATOM    675  N   ASN A 808      26.820  50.846  86.946  1.00 16.97           N  
ATOM    676  CA  ASN A 808      27.515  51.502  85.834  1.00 11.93           C  
ATOM    677  C   ASN A 808      26.881  51.128  84.505  1.00 15.73           C  
ATOM    678  O   ASN A 808      26.249  50.081  84.399  1.00 11.81           O  
ATOM    679  CB  ASN A 808      29.016  51.165  85.796  1.00 12.75           C  
ATOM    680  CG  ASN A 808      29.748  51.614  87.012  1.00 21.86           C  
ATOM    681  OD1 ASN A 808      30.155  50.799  87.843  1.00 18.50           O  
ATOM    682  ND2 ASN A 808      29.923  52.908  87.142  1.00  8.69           N  
ATOM    683  N   PRO A 809      27.043  51.979  83.478  1.00 18.22           N  
ATOM    684  CA  PRO A 809      26.492  51.602  82.159  1.00 20.46           C  
ATOM    685  C   PRO A 809      27.081  50.294  81.617  1.00 15.68           C  
ATOM    686  O   PRO A 809      28.266  50.051  81.812  1.00 19.03           O  
ATOM    687  CB  PRO A 809      26.866  52.793  81.287  1.00 22.11           C  
ATOM    688  CG  PRO A 809      26.800  53.932  82.224  1.00 18.99           C  
ATOM    689  CD  PRO A 809      27.410  53.402  83.518  1.00 20.99           C  
ATOM    690  N   PRO A 810      26.254  49.454  80.954  1.00 19.87           N  
ATOM    691  CA  PRO A 810      26.699  48.089  80.622  1.00 20.82           C  
ATOM    692  C   PRO A 810      27.945  48.019  79.720  1.00 16.28           C  
ATOM    693  O   PRO A 810      28.712  47.068  79.809  1.00 15.79           O  
ATOM    694  CB  PRO A 810      25.468  47.428  79.970  1.00 23.04           C  
ATOM    695  CG  PRO A 810      24.511  48.574  79.604  1.00 23.60           C  
ATOM    696  CD  PRO A 810      24.883  49.754  80.471  1.00 21.55           C  
ATOM    697  N   ASP A 811      28.170  49.021  78.886  1.00 19.60           N  
ATOM    698  CA  ASP A 811      29.433  49.075  78.127  1.00 23.68           C  
ATOM    699  C   ASP A 811      30.380  50.215  78.541  1.00 12.99           C  
ATOM    700  O   ASP A 811      31.230  50.631  77.779  1.00 21.94           O  
ATOM    701  CB  ASP A 811      29.147  49.110  76.628  1.00 21.59           C  
ATOM    702  CG  ASP A 811      30.384  48.864  75.800  1.00 21.64           C  
ATOM    703  OD1 ASP A 811      31.218  47.988  76.133  1.00 18.55           O  
ATOM    704  OD2 ASP A 811      30.519  49.573  74.801  1.00  8.54           O  
ATOM    705  N   SER A 812      30.251  50.686  79.772  1.00 18.60           N  
ATOM    706  CA  SER A 812      31.256  51.513  80.386  1.00 15.68           C  
ATOM    707  C   SER A 812      32.613  50.756  80.559  1.00 16.82           C  
ATOM    708  O   SER A 812      32.671  49.515  80.521  1.00 14.48           O  
ATOM    709  CB  SER A 812      30.754  52.024  81.744  1.00 16.00           C  
ATOM    710  OG  SER A 812      30.690  50.984  82.695  1.00 14.09           O  
ATOM    711  N   GLU A 813      33.695  51.514  80.732  1.00 15.10           N  
ATOM    712  CA  GLU A 813      35.029  50.955  80.984  1.00 19.77           C  
ATOM    713  C   GLU A 813      34.987  50.065  82.221  1.00 16.07           C  
ATOM    714  O   GLU A 813      35.441  48.932  82.207  1.00 15.30           O  
ATOM    715  CB  GLU A 813      36.079  52.078  81.179  1.00 15.51           C  
ATOM    716  CG  GLU A 813      37.559  51.617  81.256  1.00 22.97           C  
ATOM    717  CD  GLU A 813      37.950  50.691  80.091  1.00 29.78           C  
ATOM    718  OE1 GLU A 813      37.415  50.851  78.970  1.00 29.40           O  
ATOM    719  OE2 GLU A 813      38.782  49.784  80.298  1.00 25.29           O  
ATOM    720  N   TYR A 814      34.423  50.593  83.295  1.00 18.53           N  
ATOM    721  CA  TYR A 814      34.246  49.801  84.490  1.00 18.91           C  
ATOM    722  C   TYR A 814      33.594  48.473  84.234  1.00 14.84           C  
ATOM    723  O   TYR A 814      34.070  47.476  84.767  1.00 11.33           O  
ATOM    724  CB  TYR A 814      33.466  50.561  85.546  1.00 12.49           C  
ATOM    725  CG  TYR A 814      34.216  51.704  86.143  1.00 21.53           C  
ATOM    726  CD1 TYR A 814      35.597  51.822  86.004  1.00 17.73           C  
ATOM    727  CD2 TYR A 814      33.555  52.668  86.877  1.00 31.72           C  
ATOM    728  CE1 TYR A 814      36.267  52.867  86.552  1.00 20.13           C  
ATOM    729  CE2 TYR A 814      34.234  53.723  87.433  1.00 37.71           C  
ATOM    730  CZ  TYR A 814      35.591  53.815  87.278  1.00 29.11           C  
ATOM    731  OH  TYR A 814      36.287  54.880  87.824  1.00 22.46           O  
ATOM    732  N   CYS A 815      32.505  48.440  83.461  1.00 17.71           N  
ATOM    733  CA  CYS A 815      31.858  47.155  83.130  1.00 18.31           C  
ATOM    734  C   CYS A 815      32.697  46.316  82.169  1.00 11.37           C  
ATOM    735  O   CYS A 815      32.672  45.104  82.257  1.00 11.94           O  
ATOM    736  CB  CYS A 815      30.432  47.315  82.593  1.00 16.68           C  
ATOM    737  SG  CYS A 815      29.206  47.675  83.872  1.00 16.45           S  
ATOM    738  N   ARG A 816      33.429  46.955  81.269  1.00 14.11           N  
ATOM    739  CA  ARG A 816      34.441  46.231  80.460  1.00 17.17           C  
ATOM    740  C   ARG A 816      35.431  45.481  81.324  1.00 10.89           C  
ATOM    741  O   ARG A 816      35.677  44.305  81.111  1.00 11.18           O  
ATOM    742  CB  ARG A 816      35.179  47.165  79.496  1.00 13.48           C  
ATOM    743  CG  ARG A 816      34.253  47.640  78.354  1.00 16.41           C  
ATOM    744  CD  ARG A 816      34.950  48.465  77.269  1.00 25.68           C  
ATOM    745  NE  ARG A 816      33.999  49.392  76.632  1.00 34.12           N  
ATOM    746  CZ  ARG A 816      34.145  50.721  76.535  1.00 50.78           C  
ATOM    747  NH1 ARG A 816      35.233  51.332  76.994  1.00 61.71           N  
ATOM    748  NH2 ARG A 816      33.198  51.461  75.945  1.00 35.03           N  
ATOM    749  N   CYS A 817      35.987  46.170  82.305  1.00 16.57           N  
ATOM    750  CA  CYS A 817      36.871  45.549  83.296  1.00 11.81           C  
ATOM    751  C   CYS A 817      36.177  44.399  84.069  1.00 10.88           C  
ATOM    752  O   CYS A 817      36.771  43.340  84.245  1.00 16.14           O  
ATOM    753  CB  CYS A 817      37.389  46.640  84.247  1.00  8.83           C  
ATOM    754  SG  CYS A 817      38.563  47.799  83.449  1.00 13.06           S  
ATOM    755  N   ALA A 818      34.929  44.630  84.515  1.00 13.97           N  
ATOM    756  CA  ALA A 818      34.150  43.645  85.282  1.00 14.83           C  
ATOM    757  C   ALA A 818      34.018  42.330  84.527  1.00  6.47           C  
ATOM    758  O   ALA A 818      34.260  41.249  85.113  1.00 15.39           O  
ATOM    759  CB  ALA A 818      32.756  44.198  85.714  1.00 10.93           C  
ATOM    760  N   SER A 819      33.674  42.402  83.239  1.00 17.31           N  
ATOM    761  CA  SER A 819      33.600  41.196  82.394  1.00 17.18           C  
ATOM    762  C   SER A 819      34.943  40.513  82.220  1.00 15.41           C  
ATOM    763  O   SER A 819      35.008  39.299  82.257  1.00 15.05           O  
ATOM    764  CB  SER A 819      33.020  41.499  80.995  1.00 14.37           C  
ATOM    765  OG  SER A 819      31.666  41.850  81.118  1.00 21.48           O  
ATOM    766  N   ALA A 820      36.004  41.296  81.989  1.00 18.80           N  
ATOM    767  CA  ALA A 820      37.364  40.739  81.848  1.00 13.11           C  
ATOM    768  C   ALA A 820      37.818  40.011  83.132  1.00  8.63           C  
ATOM    769  O   ALA A 820      38.279  38.872  83.064  1.00 16.26           O  
ATOM    770  CB  ALA A 820      38.389  41.825  81.385  1.00  4.30           C  
ATOM    771  N   LEU A 821      37.610  40.634  84.284  1.00 11.52           N  
ATOM    772  CA  LEU A 821      38.032  40.084  85.605  1.00 15.27           C  
ATOM    773  C   LEU A 821      37.223  38.841  85.970  1.00 18.64           C  
ATOM    774  O   LEU A 821      37.784  37.872  86.477  1.00 12.70           O  
ATOM    775  CB  LEU A 821      37.884  41.150  86.728  1.00 21.51           C  
ATOM    776  CG  LEU A 821      38.572  40.870  88.089  1.00 21.44           C  
ATOM    777  CD1 LEU A 821      40.117  40.908  87.977  1.00 11.75           C  
ATOM    778  CD2 LEU A 821      38.077  41.808  89.201  1.00  9.65           C  
ATOM    779  N   GLU A 822      35.902  38.896  85.717  1.00 19.78           N  
ATOM    780  CA  GLU A 822      34.972  37.754  85.901  1.00 18.01           C  
ATOM    781  C   GLU A 822      35.360  36.522  85.095  1.00 12.52           C  
ATOM    782  O   GLU A 822      35.332  35.364  85.585  1.00 13.60           O  
ATOM    783  CB  GLU A 822      33.569  38.187  85.507  1.00 11.03           C  
ATOM    784  CG  GLU A 822      32.532  37.065  85.533  1.00 14.84           C  
ATOM    785  CD  GLU A 822      31.168  37.474  85.038  1.00 19.49           C  
ATOM    786  OE1 GLU A 822      31.043  37.827  83.825  1.00 14.21           O  
ATOM    787  OE2 GLU A 822      30.215  37.362  85.856  1.00 21.84           O  
ATOM    788  N   LYS A 823      35.697  36.761  83.842  1.00 14.90           N  
ATOM    789  CA  LYS A 823      36.177  35.682  82.987  1.00 17.92           C  
ATOM    790  C   LYS A 823      37.451  35.087  83.593  1.00 13.24           C  
ATOM    791  O   LYS A 823      37.602  33.864  83.714  1.00 10.18           O  
ATOM    792  CB  LYS A 823      36.451  36.211  81.563  1.00 13.55           C  
ATOM    793  CG  LYS A 823      36.747  35.127  80.515  1.00 13.04           C  
ATOM    794  CD  LYS A 823      37.478  35.730  79.298  1.00 19.63           C  
ATOM    795  CE  LYS A 823      36.903  35.279  78.001  1.00 26.83           C  
ATOM    796  NZ  LYS A 823      37.880  34.616  77.114  1.00 28.68           N  
ATOM    797  N   PHE A 824      38.391  35.958  83.934  1.00 16.39           N  
ATOM    798  CA  PHE A 824      39.623  35.500  84.551  1.00 12.97           C  
ATOM    799  C   PHE A 824      39.334  34.727  85.858  1.00 12.45           C  
ATOM    800  O   PHE A 824      39.896  33.628  86.056  1.00 11.81           O  
ATOM    801  CB  PHE A 824      40.601  36.649  84.775  1.00 13.90           C  
ATOM    802  CG  PHE A 824      41.827  36.256  85.570  1.00 14.36           C  
ATOM    803  CD1 PHE A 824      42.829  35.476  84.990  1.00 14.87           C  
ATOM    804  CD2 PHE A 824      42.011  36.729  86.880  1.00 11.35           C  
ATOM    805  CE1 PHE A 824      43.982  35.119  85.717  1.00  5.76           C  
ATOM    806  CE2 PHE A 824      43.171  36.385  87.620  1.00 10.99           C  
ATOM    807  CZ  PHE A 824      44.146  35.571  87.036  1.00 16.93           C  
ATOM    808  N   PHE A 825      38.469  35.234  86.740  1.00 13.53           N  
ATOM    809  CA  PHE A 825      38.284  34.502  88.030  1.00 12.21           C  
ATOM    810  C   PHE A 825      37.492  33.222  87.911  1.00 12.53           C  
ATOM    811  O   PHE A 825      37.726  32.279  88.664  1.00 13.83           O  
ATOM    812  CB  PHE A 825      37.899  35.382  89.229  1.00 27.48           C  
ATOM    813  CG  PHE A 825      36.510  35.955  89.221  1.00 15.86           C  
ATOM    814  CD1 PHE A 825      35.376  35.148  89.328  1.00 18.72           C  
ATOM    815  CD2 PHE A 825      36.350  37.341  89.281  1.00 27.19           C  
ATOM    816  CE1 PHE A 825      34.135  35.690  89.393  1.00 27.65           C  
ATOM    817  CE2 PHE A 825      35.094  37.893  89.351  1.00 34.43           C  
ATOM    818  CZ  PHE A 825      33.975  37.058  89.403  1.00 22.97           C  
ATOM    819  N   TYR A 826      36.664  33.110  86.880  1.00 16.11           N  
ATOM    820  CA  TYR A 826      36.015  31.808  86.620  1.00 10.10           C  
ATOM    821  C   TYR A 826      36.972  30.720  86.126  1.00  9.34           C  
ATOM    822  O   TYR A 826      36.846  29.554  86.527  1.00 12.52           O  
ATOM    823  CB  TYR A 826      34.741  31.955  85.782  1.00  8.88           C  
ATOM    824  CG  TYR A 826      33.572  32.515  86.606  1.00 16.32           C  
ATOM    825  CD1 TYR A 826      33.235  31.979  87.871  1.00 17.33           C  
ATOM    826  CD2 TYR A 826      32.831  33.596  86.148  1.00  8.81           C  
ATOM    827  CE1 TYR A 826      32.181  32.516  88.639  1.00 26.82           C  
ATOM    828  CE2 TYR A 826      31.763  34.133  86.911  1.00 13.82           C  
ATOM    829  CZ  TYR A 826      31.459  33.595  88.150  1.00 16.67           C  
ATOM    830  OH  TYR A 826      30.445  34.120  88.884  1.00 17.46           O  
ATOM    831  N   PHE A 827      37.922  31.099  85.278  1.00 10.00           N  
ATOM    832  CA  PHE A 827      39.019  30.229  84.911  1.00 12.10           C  
ATOM    833  C   PHE A 827      39.814  29.826  86.163  1.00  5.71           C  
ATOM    834  O   PHE A 827      40.189  28.681  86.315  1.00 10.33           O  
ATOM    835  CB  PHE A 827      39.971  30.880  83.872  1.00  7.02           C  
ATOM    836  CG  PHE A 827      39.520  30.760  82.436  1.00 24.07           C  
ATOM    837  CD1 PHE A 827      39.213  31.884  81.686  1.00 16.05           C  
ATOM    838  CD2 PHE A 827      39.442  29.517  81.819  1.00 30.81           C  
ATOM    839  CE1 PHE A 827      38.806  31.778  80.366  1.00 31.53           C  
ATOM    840  CE2 PHE A 827      39.043  29.409  80.496  1.00 39.55           C  
ATOM    841  CZ  PHE A 827      38.719  30.541  79.770  1.00 30.46           C  
ATOM    842  N   LYS A 828      40.103  30.766  87.036  1.00  9.98           N  
ATOM    843  CA  LYS A 828      40.802  30.427  88.307  1.00  8.76           C  
ATOM    844  C   LYS A 828      39.967  29.526  89.240  1.00 10.55           C  
ATOM    845  O   LYS A 828      40.453  28.542  89.753  1.00 13.11           O  
ATOM    846  CB  LYS A 828      41.259  31.709  89.032  1.00  7.79           C  
ATOM    847  CG  LYS A 828      42.178  32.603  88.188  1.00  9.59           C  
ATOM    848  CD  LYS A 828      43.493  31.886  87.697  1.00 13.36           C  
ATOM    849  CE  LYS A 828      43.494  31.595  86.166  1.00 10.24           C  
ATOM    850  NZ  LYS A 828      44.632  30.789  85.629  1.00  4.27           N  
ATOM    851  N   LEU A 829      38.691  29.840  89.417  1.00 12.95           N  
ATOM    852  CA  LEU A 829      37.826  29.032  90.249  1.00 19.04           C  
ATOM    853  C   LEU A 829      37.765  27.605  89.781  1.00 17.58           C  
ATOM    854  O   LEU A 829      37.754  26.683  90.608  1.00 12.95           O  
ATOM    855  CB  LEU A 829      36.401  29.590  90.306  1.00 18.67           C  
ATOM    856  CG  LEU A 829      36.221  30.869  91.110  1.00 18.41           C  
ATOM    857  CD1 LEU A 829      34.748  31.242  91.050  1.00 19.84           C  
ATOM    858  CD2 LEU A 829      36.713  30.733  92.546  1.00 18.68           C  
ATOM    859  N   LYS A 830      37.726  27.452  88.460  1.00 11.54           N  
ATOM    860  CA  LYS A 830      37.686  26.172  87.810  1.00 16.97           C  
ATOM    861  C   LYS A 830      39.020  25.461  87.959  1.00 19.56           C  
ATOM    862  O   LYS A 830      39.027  24.268  88.254  1.00  7.60           O  
ATOM    863  CB  LYS A 830      37.341  26.346  86.329  1.00 17.01           C  
ATOM    864  CG  LYS A 830      35.862  26.600  86.060  1.00 33.47           C  
ATOM    865  CD  LYS A 830      35.559  26.616  84.575  1.00 32.36           C  
ATOM    866  CE  LYS A 830      34.081  26.915  84.270  1.00 38.33           C  
ATOM    867  NZ  LYS A 830      33.830  26.801  82.786  1.00 27.24           N  
ATOM    868  N   GLU A 831      40.130  26.205  87.775  1.00 12.67           N  
ATOM    869  CA  GLU A 831      41.482  25.687  88.030  1.00 13.65           C  
ATOM    870  C   GLU A 831      41.695  25.168  89.456  1.00  8.23           C  
ATOM    871  O   GLU A 831      42.318  24.124  89.642  1.00  7.86           O  
ATOM    872  CB  GLU A 831      42.542  26.754  87.688  1.00 12.51           C  
ATOM    873  CG  GLU A 831      44.019  26.359  87.969  1.00 11.98           C  
ATOM    874  CD  GLU A 831      45.002  27.530  87.715  1.00 13.64           C  
ATOM    875  OE1 GLU A 831      44.581  28.556  87.133  1.00 31.73           O  
ATOM    876  OE2 GLU A 831      46.184  27.407  88.085  1.00 23.90           O  
ATOM    877  N   GLY A 832      41.178  25.883  90.446  1.00  9.80           N  
ATOM    878  CA  GLY A 832      41.355  25.510  91.854  1.00  3.85           C  
ATOM    879  C   GLY A 832      40.330  24.523  92.373  1.00 11.56           C  
ATOM    880  O   GLY A 832      40.330  24.257  93.551  1.00 10.25           O  
ATOM    881  N   GLY A 833      39.477  23.976  91.488  1.00 17.81           N  
ATOM    882  CA  GLY A 833      38.429  23.011  91.822  1.00 15.09           C  
ATOM    883  C   GLY A 833      37.309  23.585  92.675  1.00 18.57           C  
ATOM    884  O   GLY A 833      36.629  22.866  93.382  1.00 16.46           O  
ATOM    885  N   LEU A 834      37.128  24.901  92.629  1.00 13.99           N  
ATOM    886  CA  LEU A 834      36.254  25.594  93.554  1.00 19.40           C  
ATOM    887  C   LEU A 834      34.837  25.709  92.979  1.00 23.73           C  
ATOM    888  O   LEU A 834      33.885  25.979  93.701  1.00 26.91           O  
ATOM    889  CB  LEU A 834      36.835  26.979  93.918  1.00 17.97           C  
ATOM    890  CG  LEU A 834      38.150  26.957  94.733  1.00 24.42           C  
ATOM    891  CD1 LEU A 834      38.882  28.286  94.673  1.00 14.80           C  
ATOM    892  CD2 LEU A 834      37.877  26.601  96.186  1.00 16.44           C  
ATOM    893  N   ILE A 835      34.715  25.560  91.668  1.00 27.98           N  
ATOM    894  CA  ILE A 835      33.413  25.354  91.009  1.00 20.99           C  
ATOM    895  C   ILE A 835      33.646  24.272  89.989  1.00 29.58           C  
ATOM    896  O   ILE A 835      34.799  23.956  89.656  1.00 29.61           O  
ATOM    897  CB  ILE A 835      32.859  26.615  90.267  1.00 29.23           C  
ATOM    898  CG1 ILE A 835      33.700  26.959  89.014  1.00 19.01           C  
ATOM    899  CG2 ILE A 835      32.696  27.795  91.230  1.00 18.38           C  
ATOM    900  CD1 ILE A 835      33.414  28.355  88.419  1.00 21.77           C  
ATOM    901  N   ASP A 836      32.561  23.699  89.490  1.00 34.33           N  
ATOM    902  CA  ASP A 836      32.664  22.655  88.473  1.00 34.20           C  
ATOM    903  C   ASP A 836      33.224  23.219  87.156  1.00 37.17           C  
ATOM    904  O   ASP A 836      33.007  24.394  86.818  1.00 38.46           O  
ATOM    905  CB  ASP A 836      31.311  21.972  88.264  1.00 33.33           C  
ATOM    906  CG  ASP A 836      30.940  21.026  89.405  1.00 39.02           C  
ATOM    907  OD1 ASP A 836      31.670  20.954  90.429  1.00 30.54           O  
ATOM    908  OD2 ASP A 836      29.914  20.338  89.258  1.00 34.65           O  
ATOM    909  N   LYS A 837      33.959  22.366  86.443  1.00 33.00           N  
ATOM    910  CA  LYS A 837      34.649  22.720  85.218  1.00 30.31           C  
ATOM    911  C   LYS A 837      33.776  22.308  84.041  1.00 33.97           C  
ATOM    912  O   LYS A 837      32.577  22.069  84.222  1.00 31.95           O  
ATOM    913  CB  LYS A 837      36.017  22.030  85.170  1.00 32.84           C  
TER     914      LYS A 837                                                      
END
MOLECULE T0496_4_122.pdb
ATOM      1  N   PRO     4      36.250  18.877 100.419  1.00126.33           N  
ATOM      2  CA  PRO     4      36.001  19.915  99.413  1.00124.51           C  
ATOM      3  C   PRO     4      37.048  21.022  99.469  1.00125.13           C  
ATOM      4  O   PRO     4      38.211  20.787  99.138  1.00127.61           O  
ATOM      5  CB  PRO     4      34.632  20.466  99.818  1.00125.32           C  
ATOM      6  CG  PRO     4      33.962  19.327 100.500  1.00121.87           C  
ATOM      7  CD  PRO     4      35.049  18.581 101.220  1.00130.35           C  
ATOM      8  N   VAL     5      36.635  22.214  99.886  1.00119.84           N  
ATOM      9  CA  VAL     5      37.466  23.415  99.734  1.00107.77           C  
ATOM     10  C   VAL     5      38.099  23.855 101.061  1.00100.94           C  
ATOM     11  O   VAL     5      37.438  23.869 102.102  1.00 94.89           O  
ATOM     12  CB  VAL     5      36.652  24.587  99.107  1.00107.75           C  
ATOM     13  CG1 VAL     5      37.577  25.679  98.576  1.00 88.65           C  
ATOM     14  CG2 VAL     5      35.760  24.081  97.980  1.00101.53           C  
ATOM     15  N   SER     6      39.384  24.211 101.004  1.00 99.68           N  
ATOM     16  CA  SER     6      40.148  24.635 102.180  1.00 91.17           C  
ATOM     17  C   SER     6      40.377  26.152 102.243  1.00 85.27           C  
ATOM     18  O   SER     6      40.045  26.881 101.305  1.00 80.81           O  
ATOM     19  CB  SER     6      41.485  23.887 102.244  1.00 92.89           C  
ATOM     20  OG  SER     6      42.256  24.108 101.075  1.00 94.88           O  
ATOM     21  N   VAL     7      40.955  26.603 103.357  1.00 77.69           N  
ATOM     22  CA  VAL     7      41.146  28.027 103.663  1.00 67.00           C  
ATOM     23  C   VAL     7      42.287  28.655 102.855  1.00 73.76           C  
ATOM     24  O   VAL     7      42.125  29.739 102.284  1.00 70.86           O  
ATOM     25  CB  VAL     7      41.386  28.239 105.189  1.00 56.84           C  
ATOM     26  CG1 VAL     7      41.504  29.720 105.535  1.00 44.52           C  
ATOM     27  CG2 VAL     7      40.260  27.609 105.996  1.00 60.50           C  
ATOM     28  N   ASN     8      43.429  27.964 102.811  1.00 79.15           N  
ATOM     29  CA  ASN     8      44.614  28.407 102.064  1.00 82.93           C  
ATOM     30  C   ASN     8      44.353  28.483 100.565  1.00 82.41           C  
ATOM     31  O   ASN     8      44.933  29.314  99.868  1.00 69.82           O  
ATOM     32  CB  ASN     8      45.797  27.466 102.313  1.00 88.19           C  
ATOM     33  CG  ASN     8      45.839  26.934 103.733  1.00114.21           C  
ATOM     34  OD1 ASN     8      46.100  27.681 104.683  1.00130.04           O  
ATOM     35  ND2 ASN     8      45.591  25.630 103.881  1.00130.36           N  
ATOM     36  N   GLU     9      43.480  27.595 100.092  1.00 83.32           N  
ATOM     37  CA  GLU     9      43.007  27.568  98.713  1.00 85.50           C  
ATOM     38  C   GLU     9      42.250  28.849  98.365  1.00 71.59           C  
ATOM     39  O   GLU     9      42.421  29.397  97.276  1.00 49.75           O  
ATOM     40  CB  GLU     9      42.100  26.354  98.514  1.00 91.21           C  
ATOM     41  CG  GLU     9      41.941  25.894  97.075  1.00105.16           C  
ATOM     42  CD  GLU     9      41.154  24.600  96.967  1.00104.81           C  
ATOM     43  OE1 GLU     9      41.478  23.634  97.694  1.00128.20           O  
ATOM     44  OE2 GLU     9      40.215  24.543  96.146  1.00128.75           O  
ATOM     45  N   LYS    10      41.422  29.316  99.301  1.00 64.67           N  
ATOM     46  CA  LYS    10      40.664  30.558  99.143  1.00 50.06           C  
ATOM     47  C   LYS    10      41.562  31.786  99.278  1.00 55.22           C  
ATOM     48  O   LYS    10      41.451  32.721  98.484  1.00 39.45           O  
ATOM     49  CB  LYS    10      39.520  30.630 100.159  1.00 46.21           C  
ATOM     50  CG  LYS    10      38.442  29.572  99.977  1.00 55.81           C  
ATOM     51  CD  LYS    10      37.454  29.599 101.131  1.00 24.13           C  
ATOM     52  CE  LYS    10      36.592  28.342 101.154  1.00 39.89           C  
ATOM     53  NZ  LYS    10      35.728  28.288 102.368  1.00 67.89           N  
ATOM     54  N   LYS    11      42.441  31.767 100.285  1.00 48.64           N  
ATOM     55  CA  LYS    11      43.408  32.842 100.546  1.00 45.25           C  
ATOM     56  C   LYS    11      44.308  33.122  99.349  1.00 49.17           C  
ATOM     57  O   LYS    11      44.501  34.277  98.962  1.00 43.86           O  
ATOM     58  CB  LYS    11      44.301  32.484 101.735  1.00 39.85           C  
ATOM     59  CG  LYS    11      43.695  32.691 103.103  1.00 57.76           C  
ATOM     60  CD  LYS    11      44.805  32.720 104.140  1.00  5.48           C  
ATOM     61  CE  LYS    11      44.286  32.363 105.520  1.00 66.84           C  
ATOM     62  NZ  LYS    11      45.381  32.369 106.532  1.00 74.77           N  
ATOM     63  N   ASP    12      44.853  32.051  98.775  1.00 52.53           N  
ATOM     64  CA  ASP    12      45.754  32.147  97.633  1.00 66.79           C  
ATOM     65  C   ASP    12      45.012  32.497  96.345  1.00 62.97           C  
ATOM     66  O   ASP    12      45.597  33.094  95.440  1.00 55.08           O  
ATOM     67  CB  ASP    12      46.544  30.850  97.456  1.00 73.82           C  
ATOM     68  CG  ASP    12      47.718  31.008  96.517  1.00102.22           C  
ATOM     69  OD1 ASP    12      47.613  30.542  95.362  1.00130.59           O  
ATOM     70  OD2 ASP    12      48.736  31.612  96.923  1.00119.67           O  
ATOM     71  N   PHE    13      43.734  32.119  96.267  1.00 66.99           N  
ATOM     72  CA  PHE    13      42.888  32.486  95.130  1.00 56.84           C  
ATOM     73  C   PHE    13      42.672  33.996  95.059  1.00 54.17           C  
ATOM     74  O   PHE    13      42.798  34.584  93.985  1.00 38.21           O  
ATOM     75  CB  PHE    13      41.537  31.755  95.161  1.00 35.95           C  
ATOM     76  CG  PHE    13      40.511  32.338  94.224  1.00 61.09           C  
ATOM     77  CD1 PHE    13      40.651  32.202  92.844  1.00 70.08           C  
ATOM     78  CD2 PHE    13      39.413  33.037  94.720  1.00 81.31           C  
ATOM     79  CE1 PHE    13      39.715  32.753  91.977  1.00 61.10           C  
ATOM     80  CE2 PHE    13      38.471  33.588  93.858  1.00 74.91           C  
ATOM     81  CZ  PHE    13      38.622  33.444  92.486  1.00 61.44           C  
ATOM     82  N   VAL    14      42.344  34.606  96.199  1.00 49.01           N  
ATOM     83  CA  VAL    14      42.154  36.059  96.301  1.00 48.53           C  
ATOM     84  C   VAL    14      43.472  36.787  96.023  1.00 51.26           C  
ATOM     85  O   VAL    14      43.491  37.814  95.335  1.00 35.61           O  
ATOM     86  CB  VAL    14      41.587  36.474  97.689  1.00 49.32           C  
ATOM     87  CG1 VAL    14      41.388  37.982  97.783  1.00 40.40           C  
ATOM     88  CG2 VAL    14      40.276  35.779  97.958  1.00 45.96           C  
ATOM     89  N   LYS    15      44.565  36.228  96.546  1.00 53.00           N  
ATOM     90  CA  LYS    15      45.920  36.723  96.294  1.00 57.32           C  
ATOM     91  C   LYS    15      46.273  36.674  94.803  1.00 57.75           C  
ATOM     92  O   LYS    15      46.907  37.596  94.283  1.00 61.78           O  
ATOM     93  CB  LYS    15      46.940  35.919  97.110  1.00 54.99           C  
ATOM     94  CG  LYS    15      48.342  36.520  97.148  1.00 70.96           C  
ATOM     95  CD  LYS    15      49.350  35.544  97.737  1.00 94.48           C  
ATOM     96  CE  LYS    15      50.767  36.092  97.648  1.00102.05           C  
ATOM     97  NZ  LYS    15      51.775  35.124  98.168  1.00 93.67           N  
ATOM     98  N   TRP    16      45.853  35.603  94.126  1.00 58.07           N  
ATOM     99  CA  TRP    16      46.032  35.474  92.679  1.00 64.97           C  
ATOM    100  C   TRP    16      45.142  36.446  91.907  1.00 55.53           C  
ATOM    101  O   TRP    16      45.617  37.138  91.003  1.00 49.84           O  
ATOM    102  CB  TRP    16      45.759  34.038  92.213  1.00 77.49           C  
ATOM    103  CG  TRP    16      45.646  33.907  90.716  1.00 93.75           C  
ATOM    104  CD1 TRP    16      46.675  33.872  89.818  1.00 94.66           C  
ATOM    105  CD2 TRP    16      44.438  33.804  89.946  1.00110.74           C  
ATOM    106  NE1 TRP    16      46.186  33.752  88.539  1.00 85.41           N  
ATOM    107  CE2 TRP    16      44.817  33.709  88.588  1.00106.09           C  
ATOM    108  CE3 TRP    16      43.073  33.788  90.272  1.00108.96           C  
ATOM    109  CZ2 TRP    16      43.882  33.593  87.554  1.00 92.48           C  
ATOM    110  CZ3 TRP    16      42.143  33.670  89.243  1.00 88.27           C  
ATOM    111  CH2 TRP    16      42.554  33.575  87.900  1.00 91.46           C  
ATOM    112  N   PHE    17      43.857  36.477  92.268  1.00 52.15           N  
ATOM    113  CA  PHE    17      42.840  37.278  91.577  1.00 46.03           C  
ATOM    114  C   PHE    17      43.159  38.772  91.558  1.00 45.00           C  
ATOM    115  O   PHE    17      43.011  39.429  90.525  1.00 39.80           O  
ATOM    116  CB  PHE    17      41.450  37.032  92.190  1.00 37.75           C  
ATOM    117  CG  PHE    17      40.401  38.012  91.736  1.00 44.98           C  
ATOM    118  CD1 PHE    17      39.874  37.940  90.451  1.00 34.59           C  
ATOM    119  CD2 PHE    17      39.940  39.008  92.595  1.00 52.39           C  
ATOM    120  CE1 PHE    17      38.912  38.849  90.024  1.00 36.78           C  
ATOM    121  CE2 PHE    17      38.978  39.920  92.176  1.00 46.87           C  
ATOM    122  CZ  PHE    17      38.461  39.839  90.888  1.00 46.11           C  
ATOM    123  N   LEU    18      43.600  39.292  92.702  1.00 48.42           N  
ATOM    124  CA  LEU    18      43.920  40.713  92.846  1.00 54.75           C  
ATOM    125  C   LEU    18      45.206  41.112  92.125  1.00 64.57           C  
ATOM    126  O   LEU    18      45.377  42.274  91.748  1.00 70.78           O  
ATOM    127  CB  LEU    18      44.001  41.100  94.327  1.00 53.04           C  
ATOM    128  CG  LEU    18      42.683  41.160  95.107  1.00 47.69           C  
ATOM    129  CD1 LEU    18      42.960  41.302  96.595  1.00 23.90           C  
ATOM    130  CD2 LEU    18      41.809  42.310  94.614  1.00 37.79           C  
ATOM    131  N   ASN    19      46.100  40.145  91.934  1.00 71.72           N  
ATOM    132  CA  ASN    19      47.373  40.376  91.254  1.00 74.85           C  
ATOM    133  C   ASN    19      47.278  40.265  89.729  1.00 67.96           C  
ATOM    134  O   ASN    19      48.226  40.604  89.015  1.00 75.30           O  
ATOM    135  CB  ASN    19      48.447  39.421  91.793  1.00 75.25           C  
ATOM    136  CG  ASN    19      49.049  39.894  93.110  1.00105.13           C  
ATOM    137  OD1 ASN    19      50.229  40.248  93.166  1.00124.46           O  
ATOM    138  ND2 ASN    19      48.242  39.905  94.174  1.00113.30           N  
ATOM    139  N   ASN    20      46.130  39.801  89.239  1.00 68.40           N  
ATOM    140  CA  ASN    20      45.927  39.568  87.810  1.00 67.61           C  
ATOM    141  C   ASN    20      44.795  40.397  87.201  1.00 72.51           C  
ATOM    142  O   ASN    20      44.790  40.656  85.994  1.00 70.43           O  
ATOM    143  CB  ASN    20      45.693  38.077  87.538  1.00 59.20           C  
ATOM    144  CG  ASN    20      46.964  37.248  87.658  1.00 75.65           C  
ATOM    145  OD1 ASN    20      47.535  36.826  86.652  1.00101.51           O  
ATOM    146  ND2 ASN    20      47.412  37.011  88.887  1.00 92.03           N  
ATOM    147  N   TYR    21      43.845  40.809  88.038  1.00 72.03           N  
ATOM    148  CA  TYR    21      42.660  41.533  87.576  1.00 63.08           C  
ATOM    149  C   TYR    21      42.437  42.823  88.360  1.00 62.42           C  
ATOM    150  O   TYR    21      42.660  42.873  89.573  1.00 73.78           O  
ATOM    151  CB  TYR    21      41.415  40.639  87.653  1.00 66.80           C  
ATOM    152  CG  TYR    21      41.537  39.350  86.866  1.00 63.40           C  
ATOM    153  CD1 TYR    21      41.920  38.163  87.492  1.00 63.16           C  
ATOM    154  CD2 TYR    21      41.280  39.319  85.495  1.00 52.50           C  
ATOM    155  CE1 TYR    21      42.041  36.979  86.775  1.00 62.89           C  
ATOM    156  CE2 TYR    21      41.398  38.137  84.769  1.00 69.94           C  
ATOM    157  CZ  TYR    21      41.780  36.973  85.416  1.00 76.20           C  
ATOM    158  OH  TYR    21      41.898  35.800  84.708  1.00 81.40           O  
ATOM    159  N   GLN    22      41.995  43.861  87.653  1.00 51.11           N  
ATOM    160  CA  GLN    22      41.745  45.169  88.250  1.00 52.42           C  
ATOM    161  C   GLN    22      40.249  45.389  88.468  1.00 57.96           C  
ATOM    162  O   GLN    22      39.487  45.488  87.504  1.00 53.40           O  
ATOM    163  CB  GLN    22      42.336  46.276  87.365  1.00 47.18           C  
ATOM    164  CG  GLN    22      42.085  47.709  87.842  1.00 69.65           C  
ATOM    165  CD  GLN    22      43.001  48.131  88.978  1.00102.66           C  
ATOM    166  OE1 GLN    22      42.801  47.750  90.132  1.00106.07           O  
ATOM    167  NE2 GLN    22      44.004  48.940  88.656  1.00112.87           N  
ATOM    168  N   LEU    23      39.844  45.461  89.735  1.00 57.15           N  
ATOM    169  CA  LEU    23      38.442  45.683  90.103  1.00 50.60           C  
ATOM    170  C   LEU    23      37.989  47.107  89.782  1.00 48.31           C  
ATOM    171  O   LEU    23      38.782  48.049  89.859  1.00 46.36           O  
ATOM    172  CB  LEU    23      38.205  45.361  91.586  1.00 37.08           C  
ATOM    173  CG  LEU    23      38.211  43.888  92.022  1.00 29.17           C  
ATOM    174  CD1 LEU    23      38.286  43.767  93.536  1.00 27.93           C  
ATOM    175  CD2 LEU    23      36.996  43.131  91.492  1.00 49.92           C  
ATOM    176  N   LYS    24      36.715  47.242  89.409  1.00 42.88           N  
ATOM    177  CA  LYS    24      36.118  48.529  89.034  1.00 60.04           C  
ATOM    178  C   LYS    24      36.082  49.526  90.187  1.00 66.54           C  
ATOM    179  O   LYS    24      36.366  50.712  90.000  1.00 67.76           O  
ATOM    180  CB  LYS    24      34.702  48.329  88.489  1.00 60.30           C  
ATOM    181  CG  LYS    24      34.637  48.073  86.999  1.00 65.66           C  
ATOM    182  CD  LYS    24      33.203  47.933  86.519  1.00 74.26           C  
ATOM    183  CE  LYS    24      33.144  47.745  85.013  1.00 60.22           C  
ATOM    184  NZ  LYS    24      31.741  47.687  84.520  1.00 63.42           N  
ATOM    185  N   GLN    25      35.730  49.037  91.372  1.00 64.06           N  
ATOM    186  CA  GLN    25      35.673  49.873  92.562  1.00 54.75           C  
ATOM    187  C   GLN    25      36.805  49.501  93.519  1.00 55.82           C  
ATOM    188  O   GLN    25      37.046  48.321  93.786  1.00 55.35           O  
ATOM    189  CB  GLN    25      34.301  49.761  93.229  1.00 61.23           C  
ATOM    190  CG  GLN    25      33.994  50.859  94.234  1.00 68.73           C  
ATOM    191  CD  GLN    25      32.516  51.197  94.290  1.00 73.24           C  
ATOM    192  OE1 GLN    25      31.818  50.831  95.235  1.00103.95           O  
ATOM    193  NE2 GLN    25      32.030  51.896  93.268  1.00 97.79           N  
ATOM    194  N   ARG    26      37.491  50.529  94.014  1.00 40.57           N  
ATOM    195  CA  ARG    26      38.721  50.380  94.795  1.00 27.79           C  
ATOM    196  C   ARG    26      38.507  49.778  96.185  1.00 33.96           C  
ATOM    197  O   ARG    26      39.371  49.067  96.700  1.00 47.26           O  
ATOM    198  CB  ARG    26      39.425  51.735  94.905  1.00 25.04           C  
ATOM    199  CG  ARG    26      40.865  51.676  95.394  1.00 27.91           C  
ATOM    200  CD  ARG    26      41.569  53.000  95.184  1.00 53.62           C  
ATOM    201  NE  ARG    26      40.876  54.113  95.832  1.00 72.82           N  
ATOM    202  CZ  ARG    26      41.003  55.383  95.462  1.00 63.56           C  
ATOM    203  NH1 ARG    26      41.793  55.698  94.445  1.00 19.76           N  
ATOM    204  NH2 ARG    26      40.339  56.336  96.103  1.00 56.62           N  
ATOM    205  N   GLU    27      37.352  50.059  96.782  1.00 24.81           N  
ATOM    206  CA  GLU    27      37.032  49.564  98.126  1.00 28.34           C  
ATOM    207  C   GLU    27      36.711  48.069  98.165  1.00 20.31           C  
ATOM    208  O   GLU    27      36.733  47.457  99.232  1.00  8.99           O  
ATOM    209  CB  GLU    27      35.923  50.398  98.793  1.00 15.34           C  
ATOM    210  CG  GLU    27      35.043  51.220  97.848  1.00 60.22           C  
ATOM    211  CD  GLU    27      35.609  52.602  97.542  1.00 74.48           C  
ATOM    212  OE1 GLU    27      35.664  52.969  96.349  1.00 78.12           O  
ATOM    213  OE2 GLU    27      36.002  53.317  98.489  1.00 62.62           O  
ATOM    214  N   CYS    28      36.439  47.490  96.996  1.00  3.93           N  
ATOM    215  CA  CYS    28      36.234  46.049  96.841  1.00 36.87           C  
ATOM    216  C   CYS    28      37.543  45.272  96.980  1.00 39.48           C  
ATOM    217  O   CYS    28      37.543  44.112  97.402  1.00 40.62           O  
ATOM    218  CB  CYS    28      35.604  45.752  95.483  1.00 32.52           C  
ATOM    219  SG  CYS    28      34.088  46.672  95.157  1.00 64.11           S  
ATOM    220  N   VAL    29      38.647  45.920  96.603  1.00 26.07           N  
ATOM    221  CA  VAL    29      40.000  45.398  96.811  1.00 33.41           C  
ATOM    222  C   VAL    29      40.289  45.353  98.313  1.00 40.89           C  
ATOM    223  O   VAL    29      40.858  44.381  98.816  1.00 29.88           O  
ATOM    224  CB  VAL    29      41.071  46.276  96.090  1.00 18.96           C  
ATOM    225  CG1 VAL    29      42.470  45.681  96.219  1.00 42.64           C  
ATOM    226  CG2 VAL    29      40.717  46.479  94.621  1.00 12.99           C  
ATOM    227  N   TRP    30      39.866  46.402  99.018  1.00 35.56           N  
ATOM    228  CA  TRP    30      40.076  46.520 100.461  1.00 28.30           C  
ATOM    229  C   TRP    30      39.164  45.602 101.267  1.00 34.00           C  
ATOM    230  O   TRP    30      39.520  45.204 102.376  1.00 24.65           O  
ATOM    231  CB  TRP    30      39.916  47.971 100.929  1.00 19.25           C  
ATOM    232  CG  TRP    30      40.816  48.950 100.224  1.00 39.94           C  
ATOM    233  CD1 TRP    30      42.044  48.696  99.675  1.00 32.48           C  
ATOM    234  CD2 TRP    30      40.568  50.347 100.017  1.00 35.28           C  
ATOM    235  NE1 TRP    30      42.563  49.839  99.122  1.00 33.05           N  
ATOM    236  CE2 TRP    30      41.683  50.870  99.323  1.00 36.64           C  
ATOM    237  CE3 TRP    30      39.512  51.207 100.348  1.00  9.12           C  
ATOM    238  CZ2 TRP    30      41.772  52.215  98.952  1.00 32.40           C  
ATOM    239  CZ3 TRP    30      39.600  52.546  99.976  1.00 19.31           C  
ATOM    240  CH2 TRP    30      40.723  53.035  99.285  1.00 42.28           C  
ATOM    241  N   ILE    31      37.991  45.286 100.712  1.00 32.16           N  
ATOM    242  CA  ILE    31      37.098  44.271 101.279  1.00 29.88           C  
ATOM    243  C   ILE    31      37.771  42.895 101.188  1.00 29.23           C  
ATOM    244  O   ILE    31      37.806  42.149 102.170  1.00 29.23           O  
ATOM    245  CB  ILE    31      35.701  44.267 100.576  1.00 37.41           C  
ATOM    246  CG1 ILE    31      34.868  45.475 101.018  1.00 31.27           C  
ATOM    247  CG2 ILE    31      34.924  42.980 100.874  1.00  2.00           C  
ATOM    248  CD1 ILE    31      33.747  45.854 100.060  1.00 38.02           C  
ATOM    249  N   LEU    32      38.329  42.591 100.015  1.00 36.37           N  
ATOM    250  CA  LEU    32      39.024  41.323  99.766  1.00 28.05           C  
ATOM    251  C   LEU    32      40.318  41.163 100.564  1.00 32.19           C  
ATOM    252  O   LEU    32      40.619  40.065 101.043  1.00 25.56           O  
ATOM    253  CB  LEU    32      39.316  41.145  98.272  1.00 11.59           C  
ATOM    254  CG  LEU    32      38.190  40.639  97.368  1.00 40.82           C  
ATOM    255  CD1 LEU    32      38.606  40.702  95.907  1.00 31.11           C  
ATOM    256  CD2 LEU    32      37.744  39.224  97.735  1.00 16.32           C  
ATOM    257  N   ASN    33      41.076  42.253 100.694  1.00 33.88           N  
ATOM    258  CA  ASN    33      42.309  42.269 101.487  1.00 41.02           C  
ATOM    259  C   ASN    33      42.045  42.119 102.982  1.00 48.35           C  
ATOM    260  O   ASN    33      42.861  41.544 103.708  1.00 42.87           O  
ATOM    261  CB  ASN    33      43.105  43.553 101.236  1.00 38.12           C  
ATOM    262  CG  ASN    33      43.837  43.545  99.906  1.00 28.78           C  
ATOM    263  OD1 ASN    33      44.367  42.520  99.475  1.00 60.55           O  
ATOM    264  ND2 ASN    33      43.887  44.702  99.258  1.00 57.45           N  
ATOM    265  N   TYR    34      40.908  42.656 103.427  1.00 42.24           N  
ATOM    266  CA  TYR    34      40.432  42.500 104.800  1.00 36.83           C  
ATOM    267  C   TYR    34      40.098  41.038 105.079  1.00 23.18           C  
ATOM    268  O   TYR    34      40.462  40.503 106.126  1.00 16.66           O  
ATOM    269  CB  TYR    34      39.197  43.378 105.027  1.00 41.90           C  
ATOM    270  CG  TYR    34      38.520  43.229 106.374  1.00 22.34           C  
ATOM    271  CD1 TYR    34      38.973  43.939 107.484  1.00 28.54           C  
ATOM    272  CD2 TYR    34      37.408  42.398 106.533  1.00 27.86           C  
ATOM    273  CE1 TYR    34      38.350  43.812 108.720  1.00  4.43           C  
ATOM    274  CE2 TYR    34      36.781  42.262 107.766  1.00 43.11           C  
ATOM    275  CZ  TYR    34      37.257  42.972 108.855  1.00 35.09           C  
ATOM    276  OH  TYR    34      36.639  42.845 110.078  1.00 54.06           O  
ATOM    277  N   LEU    35      39.403  40.407 104.134  1.00 24.05           N  
ATOM    278  CA  LEU    35      38.988  39.012 104.264  1.00 40.94           C  
ATOM    279  C   LEU    35      40.166  38.045 104.184  1.00 38.13           C  
ATOM    280  O   LEU    35      40.156  37.005 104.841  1.00 37.34           O  
ATOM    281  CB  LEU    35      37.922  38.662 103.220  1.00 42.89           C  
ATOM    282  CG  LEU    35      36.547  39.306 103.438  1.00 42.92           C  
ATOM    283  CD1 LEU    35      35.752  39.347 102.143  1.00 49.87           C  
ATOM    284  CD2 LEU    35      35.763  38.605 104.543  1.00 59.35           C  
ATOM    285  N   MET    36      41.175  38.399 103.385  1.00 34.40           N  
ATOM    286  CA  MET    36      42.427  37.636 103.305  1.00 46.16           C  
ATOM    287  C   MET    36      43.219  37.656 104.610  1.00 50.13           C  
ATOM    288  O   MET    36      43.874  36.672 104.960  1.00 60.87           O  
ATOM    289  CB  MET    36      43.315  38.160 102.175  1.00 42.82           C  
ATOM    290  CG  MET    36      43.368  37.261 100.955  1.00 48.71           C  
ATOM    291  SD  MET    36      44.881  37.467  99.986  1.00 60.10           S  
ATOM    292  CE  MET    36      44.640  39.097  99.278  1.00 16.43           C  
ATOM    293  N   SER    37      43.153  38.781 105.317  1.00 42.11           N  
ATOM    294  CA  SER    37      43.859  38.960 106.582  1.00 36.76           C  
ATOM    295  C   SER    37      43.206  38.197 107.734  1.00 37.15           C  
ATOM    296  O   SER    37      43.880  37.823 108.697  1.00 53.92           O  
ATOM    297  CB  SER    37      43.943  40.445 106.928  1.00 18.16           C  
ATOM    298  OG  SER    37      44.692  40.659 108.113  1.00 32.55           O  
ATOM    299  N   HIS    38      41.899  37.971 107.629  1.00 44.07           N  
ATOM    300  CA  HIS    38      41.138  37.305 108.681  1.00 38.86           C  
ATOM    301  C   HIS    38      40.825  35.861 108.290  1.00 42.18           C  
ATOM    302  O   HIS    38      39.936  35.604 107.473  1.00 55.60           O  
ATOM    303  CB  HIS    38      39.861  38.094 108.994  1.00 26.86           C  
ATOM    304  CG  HIS    38      40.118  39.468 109.535  1.00 33.91           C  
ATOM    305  ND1 HIS    38      40.550  40.511 108.745  1.00 26.80           N  
ATOM    306  CD2 HIS    38      40.005  39.969 110.788  1.00 16.28           C  
ATOM    307  CE1 HIS    38      40.698  41.592 109.488  1.00 39.50           C  
ATOM    308  NE2 HIS    38      40.369  41.292 110.731  1.00 34.08           N  
ATOM    309  N   ASP    39      41.570  34.926 108.877  1.00 42.22           N  
ATOM    310  CA  ASP    39      41.487  33.505 108.508  1.00 57.50           C  
ATOM    311  C   ASP    39      40.239  32.755 108.989  1.00 50.55           C  
ATOM    312  O   ASP    39      39.903  31.705 108.434  1.00 54.74           O  
ATOM    313  CB  ASP    39      42.773  32.732 108.877  1.00 58.09           C  
ATOM    314  CG  ASP    39      43.669  33.483 109.855  1.00101.47           C  
ATOM    315  OD1 ASP    39      44.908  33.492 109.630  1.00113.01           O  
ATOM    316  OD2 ASP    39      43.151  34.059 110.842  1.00137.21           O  
ATOM    317  N   GLN    40      39.555  33.273 110.007  1.00 52.26           N  
ATOM    318  CA  GLN    40      38.258  32.696 110.392  1.00 59.48           C  
ATOM    319  C   GLN    40      37.060  33.448 109.802  1.00 61.27           C  
ATOM    320  O   GLN    40      35.904  33.139 110.110  1.00 51.95           O  
ATOM    321  CB  GLN    40      38.134  32.455 111.912  1.00 52.01           C  
ATOM    322  CG  GLN    40      38.868  33.458 112.809  1.00 76.20           C  
ATOM    323  CD  GLN    40      39.624  32.719 113.944  1.00 91.61           C  
ATOM    324  OE1 GLN    40      40.507  33.294 114.589  1.00 83.79           O  
ATOM    325  NE2 GLN    40      39.287  31.442 114.185  1.00106.56           N  
ATOM    326  N   LEU    41      37.353  34.431 108.953  1.00 66.52           N  
ATOM    327  CA  LEU    41      36.367  34.944 108.006  1.00 67.80           C  
ATOM    328  C   LEU    41      36.392  34.058 106.766  1.00 70.55           C  
ATOM    329  O   LEU    41      35.342  33.755 106.197  1.00 75.93           O  
ATOM    330  CB  LEU    41      36.654  36.403 107.621  1.00 78.53           C  
ATOM    331  CG  LEU    41      35.895  37.555 108.301  1.00 73.60           C  
ATOM    332  CD1 LEU    41      34.390  37.484 108.038  1.00 46.01           C  
ATOM    333  CD2 LEU    41      36.183  37.616 109.797  1.00 73.23           C  
ATOM    334  N   MET    42      37.595  33.627 106.378  1.00 56.00           N  
ATOM    335  CA  MET    42      37.808  32.775 105.199  1.00 57.81           C  
ATOM    336  C   MET    42      37.240  31.360 105.324  1.00 69.74           C  
ATOM    337  O   MET    42      37.038  30.683 104.313  1.00 74.92           O  
ATOM    338  CB  MET    42      39.293  32.719 104.825  1.00 48.73           C  
ATOM    339  CG  MET    42      39.756  33.857 103.932  1.00 26.11           C  
ATOM    340  SD  MET    42      38.932  33.896 102.326  1.00 46.81           S  
ATOM    341  CE  MET    42      39.502  35.472 101.695  1.00 20.11           C  
ATOM    342  N   HIS    43      37.006  30.916 106.560  1.00 77.46           N  
ATOM    343  CA  HIS    43      36.227  29.708 106.828  1.00 81.40           C  
ATOM    344  C   HIS    43      34.802  29.904 106.332  1.00 77.35           C  
ATOM    345  O   HIS    43      34.234  29.036 105.665  1.00 81.45           O  
ATOM    346  CB  HIS    43      36.169  29.422 108.331  1.00 92.98           C  
ATOM    347  CG  HIS    43      37.329  28.635 108.852  1.00115.47           C  
ATOM    348  ND1 HIS    43      38.190  29.129 109.810  1.00123.92           N  
ATOM    349  CD2 HIS    43      37.760  27.384 108.565  1.00132.13           C  
ATOM    350  CE1 HIS    43      39.108  28.220 110.081  1.00129.28           C  
ATOM    351  NE2 HIS    43      38.871  27.152 109.340  1.00131.76           N  
ATOM    352  N   LYS    44      34.243  31.066 106.666  1.00 73.33           N  
ATOM    353  CA  LYS    44      32.857  31.404 106.366  1.00 61.04           C  
ATOM    354  C   LYS    44      32.678  32.023 104.976  1.00 57.30           C  
ATOM    355  O   LYS    44      31.551  32.189 104.508  1.00 69.14           O  
ATOM    356  CB  LYS    44      32.298  32.335 107.448  1.00 58.50           C  
ATOM    357  CG  LYS    44      32.146  31.683 108.818  1.00 46.12           C  
ATOM    358  CD  LYS    44      31.729  32.697 109.876  1.00 62.71           C  
ATOM    359  CE  LYS    44      31.584  32.047 111.249  1.00 86.47           C  
ATOM    360  NZ  LYS    44      32.894  31.607 111.823  1.00104.81           N  
ATOM    361  N   VAL    45      33.789  32.365 104.325  1.00 47.83           N  
ATOM    362  CA  VAL    45      33.767  32.889 102.957  1.00 54.28           C  
ATOM    363  C   VAL    45      33.536  31.748 101.963  1.00 57.64           C  
ATOM    364  O   VAL    45      34.229  30.726 102.003  1.00 64.15           O  
ATOM    365  CB  VAL    45      35.068  33.693 102.629  1.00 44.32           C  
ATOM    366  CG1 VAL    45      35.346  33.757 101.125  1.00 51.43           C  
ATOM    367  CG2 VAL    45      34.979  35.101 103.199  1.00 59.36           C  
ATOM    368  N   HIS    46      32.541  31.921 101.094  1.00 52.06           N  
ATOM    369  CA  HIS    46      32.242  30.946 100.051  1.00 44.49           C  
ATOM    370  C   HIS    46      32.204  31.604  98.678  1.00 53.29           C  
ATOM    371  O   HIS    46      31.514  32.606  98.478  1.00 65.04           O  
ATOM    372  CB  HIS    46      30.912  30.242 100.331  1.00 36.82           C  
ATOM    373  CG  HIS    46      30.851  29.573 101.668  1.00 36.12           C  
ATOM    374  ND1 HIS    46      31.564  28.430 101.960  1.00 72.73           N  
ATOM    375  CD2 HIS    46      30.161  29.883 102.791  1.00 67.78           C  
ATOM    376  CE1 HIS    46      31.318  28.067 103.206  1.00 76.73           C  
ATOM    377  NE2 HIS    46      30.470  28.932 103.733  1.00 68.01           N  
ATOM    378  N   PHE    47      32.956  31.037  97.738  1.00 56.48           N  
ATOM    379  CA  PHE    47      32.956  31.526  96.363  1.00 61.28           C  
ATOM    380  C   PHE    47      31.879  30.823  95.549  1.00 58.84           C  
ATOM    381  O   PHE    47      31.816  29.594  95.506  1.00 62.21           O  
ATOM    382  CB  PHE    47      34.349  31.429  95.740  1.00 65.70           C  
ATOM    383  CG  PHE    47      35.332  32.390  96.345  1.00 59.38           C  
ATOM    384  CD1 PHE    47      36.184  31.983  97.368  1.00 64.32           C  
ATOM    385  CD2 PHE    47      35.381  33.715  95.919  1.00 51.39           C  
ATOM    386  CE1 PHE    47      37.083  32.874  97.941  1.00 82.12           C  
ATOM    387  CE2 PHE    47      36.275  34.611  96.490  1.00 40.37           C  
ATOM    388  CZ  PHE    47      37.125  34.189  97.501  1.00 63.01           C  
ATOM    389  N   VAL    48      31.027  31.628  94.918  1.00 55.73           N  
ATOM    390  CA  VAL    48      29.686  31.201  94.521  1.00 48.33           C  
ATOM    391  C   VAL    48      29.289  31.869  93.194  1.00 46.26           C  
ATOM    392  O   VAL    48      29.760  32.964  92.892  1.00 54.94           O  
ATOM    393  CB  VAL    48      28.691  31.499  95.719  1.00 51.09           C  
ATOM    394  CG1 VAL    48      27.323  32.038  95.289  1.00 66.36           C  
ATOM    395  CG2 VAL    48      28.538  30.277  96.614  1.00 25.83           C  
ATOM    396  N   GLU    49      28.443  31.203  92.407  0.50 40.44           N  
ATOM    398  CA  GLU    49      27.781  31.851  91.274  0.50 38.59           C  
ATOM    400  C   GLU    49      26.316  32.151  91.594  0.50 38.61           C  
ATOM    402  O   GLU    49      25.588  31.292  92.094  0.50 23.18           O  
ATOM    404  CB  GLU    49      27.906  31.014  89.999  0.50 39.79           C  
ATOM    406  CG  GLU    49      29.260  31.147  89.313  0.50 32.47           C  
ATOM    408  CD  GLU    49      29.242  30.675  87.871  0.50 47.37           C  
ATOM    410  OE1 GLU    49      28.857  29.512  87.621  0.50 67.13           O  
ATOM    412  OE2 GLU    49      29.625  31.468  86.984  0.50 41.08           O  
ATOM    414  N   HIS    50      25.893  33.378  91.305  0.50 35.51           N  
ATOM    416  CA  HIS    50      24.555  33.838  91.665  0.50 37.04           C  
ATOM    418  C   HIS    50      24.477  34.066  93.175  0.50 39.05           C  
ATOM    420  O   HIS    50      23.753  33.370  93.889  0.50 45.49           O  
ATOM    422  CB  HIS    50      23.483  32.836  91.220  0.50 33.33           C  
ATOM    424  CG  HIS    50      23.660  32.328  89.823  0.50 30.55           C  
ATOM    426  ND1 HIS    50      23.963  31.012  89.545  0.50 43.39           N  
ATOM    428  CD2 HIS    50      23.575  32.956  88.625  0.50 24.25           C  
ATOM    430  CE1 HIS    50      24.057  30.850  88.238  0.50 47.64           C  
ATOM    432  NE2 HIS    50      23.826  32.015  87.656  0.50 42.44           N  
ATOM    434  N   ALA    51      25.227  35.053  93.655  0.50 45.35           N  
ATOM    436  CA  ALA    51      25.294  35.347  95.086  0.50 48.89           C  
ATOM    438  C   ALA    51      24.154  36.246  95.576  0.50 51.83           C  
ATOM    440  O   ALA    51      24.079  36.574  96.762  0.50 53.16           O  
ATOM    442  CB  ALA    51      26.649  35.958  95.435  0.50 49.32           C  
ATOM    444  N   LYS    52      23.264  36.625  94.660  1.00 58.57           N  
ATOM    445  CA  LYS    52      22.124  37.506  94.966  1.00 54.64           C  
ATOM    446  C   LYS    52      21.017  36.826  95.781  1.00 46.90           C  
ATOM    447  O   LYS    52      20.208  37.496  96.427  1.00 46.97           O  
ATOM    448  CB  LYS    52      21.546  38.104  93.674  1.00 44.05           C  
ATOM    449  CG  LYS    52      21.045  37.074  92.661  1.00 66.73           C  
ATOM    450  CD  LYS    52      20.582  37.740  91.380  1.00 82.91           C  
ATOM    451  CE  LYS    52      19.977  36.734  90.415  1.00 97.19           C  
ATOM    452  NZ  LYS    52      19.523  37.389  89.153  1.00115.97           N  
ATOM    453  N   TYR    53      21.001  35.495  95.745  1.00 37.98           N  
ATOM    454  CA  TYR    53      20.046  34.682  96.491  1.00 37.72           C  
ATOM    455  C   TYR    53      20.497  34.436  97.934  1.00 45.31           C  
ATOM    456  O   TYR    53      19.725  33.933  98.754  1.00 54.77           O  
ATOM    457  CB  TYR    53      19.845  33.337  95.786  1.00 46.24           C  
ATOM    458  CG  TYR    53      19.406  33.437  94.341  1.00 72.72           C  
ATOM    459  CD1 TYR    53      18.073  33.684  94.014  1.00 81.57           C  
ATOM    460  CD2 TYR    53      20.320  33.270  93.300  1.00 82.33           C  
ATOM    461  CE1 TYR    53      17.662  33.773  92.688  1.00 71.14           C  
ATOM    462  CE2 TYR    53      19.918  33.357  91.970  1.00 86.46           C  
ATOM    463  CZ  TYR    53      18.588  33.608  91.672  1.00 63.48           C  
ATOM    464  OH  TYR    53      18.186  33.695  90.359  1.00 81.98           O  
ATOM    465  N   CYS    54      21.742  34.800  98.236  1.00 49.67           N  
ATOM    466  CA  CYS    54      22.366  34.482  99.519  1.00 56.54           C  
ATOM    467  C   CYS    54      22.061  35.511 100.615  1.00 60.03           C  
ATOM    468  O   CYS    54      21.984  36.708 100.328  1.00 67.34           O  
ATOM    469  CB  CYS    54      23.878  34.329  99.335  1.00 51.50           C  
ATOM    470  SG  CYS    54      24.343  33.106  98.085  1.00 97.57           S  
ATOM    471  N   PRO    55      21.869  35.038 101.870  1.00 58.20           N  
ATOM    472  CA  PRO    55      21.696  35.838 103.093  1.00 59.98           C  
ATOM    473  C   PRO    55      22.735  36.943 103.312  1.00 67.06           C  
ATOM    474  O   PRO    55      22.407  37.977 103.897  1.00 85.49           O  
ATOM    475  CB  PRO    55      21.791  34.793 104.223  1.00 66.59           C  
ATOM    476  CG  PRO    55      22.246  33.520 103.566  1.00 67.66           C  
ATOM    477  CD  PRO    55      21.746  33.602 102.171  1.00 69.20           C  
ATOM    478  N   ARG    56      23.968  36.722 102.861  1.00 48.08           N  
ATOM    479  CA  ARG    56      24.998  37.754 102.905  1.00 42.87           C  
ATOM    480  C   ARG    56      25.850  37.682 101.637  1.00 45.44           C  
ATOM    481  O   ARG    56      26.996  37.221 101.659  1.00 49.24           O  
ATOM    482  CB  ARG    56      25.839  37.621 104.175  1.00 49.88           C  
ATOM    483  CG  ARG    56      26.133  38.946 104.852  1.00 18.97           C  
ATOM    484  CD  ARG    56      26.176  38.798 106.364  1.00 24.76           C  
ATOM    485  NE  ARG    56      27.468  38.313 106.845  1.00 40.44           N  
ATOM    486  CZ  ARG    56      28.460  39.097 107.256  1.00 53.66           C  
ATOM    487  NH1 ARG    56      28.323  40.416 107.240  1.00 58.73           N  
ATOM    488  NH2 ARG    56      29.596  38.562 107.684  1.00 45.76           N  
ATOM    489  N   GLY    57      25.264  38.142 100.534  1.00 45.31           N  
ATOM    490  CA  GLY    57      25.861  38.009  99.209  1.00 39.80           C  
ATOM    491  C   GLY    57      26.650  39.214  98.741  1.00 40.11           C  
ATOM    492  O   GLY    57      26.211  40.353  98.890  1.00 39.59           O  
ATOM    493  N   LEU    58      27.814  38.943  98.156  1.00 34.25           N  
ATOM    494  CA  LEU    58      28.733  39.975  97.700  1.00 24.42           C  
ATOM    495  C   LEU    58      29.002  39.793  96.207  1.00 27.60           C  
ATOM    496  O   LEU    58      29.446  38.728  95.774  1.00 43.01           O  
ATOM    497  CB  LEU    58      30.037  39.878  98.501  1.00 39.75           C  
ATOM    498  CG  LEU    58      30.890  41.113  98.805  1.00 23.91           C  
ATOM    499  CD1 LEU    58      30.151  42.118  99.666  1.00 58.63           C  
ATOM    500  CD2 LEU    58      32.169  40.683  99.500  1.00 14.12           C  
ATOM    501  N   VAL    59      28.705  40.826  95.420  1.00 32.14           N  
ATOM    502  CA  VAL    59      28.933  40.795  93.972  1.00 31.60           C  
ATOM    503  C   VAL    59      29.955  41.865  93.602  1.00 51.55           C  
ATOM    504  O   VAL    59      29.745  43.049  93.870  1.00 58.66           O  
ATOM    505  CB  VAL    59      27.618  41.013  93.169  1.00 28.84           C  
ATOM    506  CG1 VAL    59      27.883  41.002  91.664  1.00 11.97           C  
ATOM    507  CG2 VAL    59      26.581  39.957  93.525  1.00 28.33           C  
ATOM    508  N   MET    60      31.063  41.442  92.998  1.00 46.21           N  
ATOM    509  CA  MET    60      32.144  42.357  92.635  1.00 43.37           C  
ATOM    510  C   MET    60      32.669  42.100  91.227  1.00 44.35           C  
ATOM    511  O   MET    60      32.773  40.951  90.797  1.00 52.83           O  
ATOM    512  CB  MET    60      33.269  42.275  93.662  1.00 44.96           C  
ATOM    513  CG  MET    60      33.034  43.154  94.879  1.00 48.21           C  
ATOM    514  SD  MET    60      33.481  42.433  96.469  1.00 46.13           S  
ATOM    515  CE  MET    60      34.825  41.344  96.023  1.00  4.14           C  
ATOM    516  N   SER    61      33.001  43.177  90.518  1.00 33.48           N  
ATOM    517  CA  SER    61      33.352  43.085  89.102  1.00 36.37           C  
ATOM    518  C   SER    61      34.679  43.747  88.754  1.00 44.79           C  
ATOM    519  O   SER    61      34.992  44.836  89.243  1.00 57.16           O  
ATOM    520  CB  SER    61      32.236  43.683  88.243  1.00 41.88           C  
ATOM    521  OG  SER    61      30.989  43.082  88.542  1.00 61.05           O  
ATOM    522  N   ALA    62      35.450  43.073  87.905  1.00 58.28           N  
ATOM    523  CA  ALA    62      36.674  43.634  87.346  1.00 58.50           C  
ATOM    524  C   ALA    62      36.339  44.552  86.170  1.00 64.19           C  
ATOM    525  O   ALA    62      35.240  44.478  85.613  1.00 75.24           O  
ATOM    526  CB  ALA    62      37.620  42.523  86.917  1.00 58.97           C  
ATOM    527  N   ASN    63      37.287  45.408  85.793  1.00 68.09           N  
ATOM    528  CA  ASN    63      37.062  46.432  84.756  1.00 69.47           C  
ATOM    529  C   ASN    63      36.980  45.953  83.296  1.00 64.12           C  
ATOM    530  O   ASN    63      36.721  46.748  82.388  1.00 58.40           O  
ATOM    531  CB  ASN    63      38.022  47.635  84.920  1.00 65.01           C  
ATOM    532  CG  ASN    63      39.505  47.293  84.677  1.00 91.40           C  
ATOM    533  OD1 ASN    63      40.339  48.201  84.624  1.00107.59           O  
ATOM    534  ND2 ASN    63      39.836  46.010  84.532  1.00 94.71           N  
ATOM    535  N   CYS    64      37.195  44.657  83.089  1.00 60.02           N  
ATOM    536  CA  CYS    64      37.081  44.040  81.771  1.00 75.98           C  
ATOM    537  C   CYS    64      35.619  43.849  81.359  1.00 79.71           C  
ATOM    538  O   CYS    64      35.171  44.435  80.369  1.00 80.65           O  
ATOM    539  CB  CYS    64      37.841  42.712  81.738  1.00 82.49           C  
ATOM    540  SG  CYS    64      37.673  41.726  83.249  1.00 98.58           S  
ATOM    541  N   VAL    65      34.882  43.036  82.119  1.00 73.13           N  
ATOM    542  CA  VAL    65      33.457  42.808  81.857  1.00 69.48           C  
ATOM    543  C   VAL    65      32.646  43.994  82.365  1.00 68.33           C  
ATOM    544  O   VAL    65      33.004  44.620  83.367  1.00 62.17           O  
ATOM    545  CB  VAL    65      32.921  41.516  82.520  1.00 68.74           C  
ATOM    546  CG1 VAL    65      31.853  40.870  81.643  1.00 97.15           C  
ATOM    547  CG2 VAL    65      34.032  40.537  82.757  1.00 69.93           C  
ATOM    548  N   LYS    66      31.545  44.287  81.676  1.00 78.50           N  
ATOM    549  CA  LYS    66      30.731  45.469  81.961  1.00 86.16           C  
ATOM    550  C   LYS    66      29.637  45.258  83.018  1.00 84.47           C  
ATOM    551  O   LYS    66      28.615  45.951  83.007  1.00 77.59           O  
ATOM    552  CB  LYS    66      30.125  46.021  80.662  1.00 95.79           C  
ATOM    553  CG  LYS    66      31.095  46.834  79.801  1.00113.77           C  
ATOM    554  CD  LYS    66      31.301  48.254  80.336  1.00122.57           C  
ATOM    555  CE  LYS    66      30.109  49.156  80.032  1.00120.31           C  
ATOM    556  NZ  LYS    66      30.291  50.525  80.592  1.00115.46           N  
ATOM    557  N   ASP    67      29.858  44.310  83.927  1.00 80.20           N  
ATOM    558  CA  ASP    67      28.968  44.109  85.069  1.00 71.67           C  
ATOM    559  C   ASP    67      29.181  45.216  86.103  1.00 72.53           C  
ATOM    560  O   ASP    67      30.254  45.827  86.154  1.00 74.41           O  
ATOM    561  CB  ASP    67      29.193  42.729  85.700  1.00 61.88           C  
ATOM    562  CG  ASP    67      28.744  41.588  84.798  1.00 67.35           C  
ATOM    563  OD1 ASP    67      29.148  41.555  83.614  1.00 65.09           O  
ATOM    564  OD2 ASP    67      27.991  40.714  85.281  1.00 60.45           O  
ATOM    565  N   THR    68      28.149  45.468  86.908  1.00 72.93           N  
ATOM    566  CA  THR    68      28.159  46.508  87.945  1.00 74.31           C  
ATOM    567  C   THR    68      29.237  46.251  89.007  1.00 64.76           C  
ATOM    568  O   THR    68      29.387  45.113  89.458  1.00 60.99           O  
ATOM    569  CB  THR    68      26.781  46.617  88.633  1.00 75.76           C  
ATOM    570  OG1 THR    68      26.394  45.326  89.135  1.00 61.69           O  
ATOM    571  CG2 THR    68      25.723  47.125  87.656  1.00 77.58           C  
ATOM    572  N   PRO    69      29.992  47.306  89.397  1.00 58.71           N  
ATOM    573  CA  PRO    69      31.149  47.214  90.301  1.00 51.46           C  
ATOM    574  C   PRO    69      30.899  46.539  91.652  1.00 52.55           C  
ATOM    575  O   PRO    69      31.702  45.703  92.070  1.00 54.61           O  
ATOM    576  CB  PRO    69      31.536  48.681  90.523  1.00 34.40           C  
ATOM    577  CG  PRO    69      31.056  49.379  89.317  1.00 27.54           C  
ATOM    578  CD  PRO    69      29.773  48.699  88.957  1.00 48.11           C  
ATOM    579  N   PHE    70      29.806  46.897  92.325  1.00 47.73           N  
ATOM    580  CA  PHE    70      29.535  46.373  93.665  1.00 38.96           C  
ATOM    581  C   PHE    70      28.051  46.180  93.972  1.00 47.67           C  
ATOM    582  O   PHE    70      27.218  47.019  93.621  1.00 44.07           O  
ATOM    583  CB  PHE    70      30.181  47.268  94.736  1.00 27.56           C  
ATOM    584  CG  PHE    70      30.034  46.741  96.142  1.00 35.59           C  
ATOM    585  CD1 PHE    70      29.015  47.203  96.975  1.00 28.02           C  
ATOM    586  CD2 PHE    70      30.909  45.777  96.630  1.00 26.65           C  
ATOM    587  CE1 PHE    70      28.868  46.705  98.265  1.00 55.54           C  
ATOM    588  CE2 PHE    70      30.777  45.284  97.922  1.00 13.83           C  
ATOM    589  CZ  PHE    70      29.756  45.748  98.741  1.00 52.02           C  
ATOM    590  N   HIS    71      27.747  45.070  94.645  1.00 38.09           N  
ATOM    591  CA  HIS    71      26.436  44.824  95.244  1.00 41.20           C  
ATOM    592  C   HIS    71      26.564  44.016  96.533  1.00 51.31           C  
ATOM    593  O   HIS    71      27.296  43.025  96.583  1.00 60.30           O  
ATOM    594  CB  HIS    71      25.515  44.095  94.267  1.00 36.38           C  
ATOM    595  CG  HIS    71      24.807  45.004  93.316  1.00 61.41           C  
ATOM    596  ND1 HIS    71      25.370  45.420  92.129  1.00 74.55           N  
ATOM    597  CD2 HIS    71      23.586  45.585  93.378  1.00 41.09           C  
ATOM    598  CE1 HIS    71      24.526  46.217  91.500  1.00 57.77           C  
ATOM    599  NE2 HIS    71      23.435  46.333  92.236  1.00 43.51           N  
ATOM    600  N   PHE    72      25.852  44.449  97.571  1.00 46.42           N  
ATOM    601  CA  PHE    72      25.787  43.703  98.824  1.00 42.49           C  
ATOM    602  C   PHE    72      24.352  43.284  99.128  1.00 41.28           C  
ATOM    603  O   PHE    72      23.463  44.125  99.290  1.00 41.05           O  
ATOM    604  CB  PHE    72      26.398  44.503  99.982  1.00 33.96           C  
ATOM    605  CG  PHE    72      26.478  43.742 101.286  1.00 53.39           C  
ATOM    606  CD1 PHE    72      26.960  42.434 101.324  1.00 63.75           C  
ATOM    607  CD2 PHE    72      26.092  44.346 102.480  1.00 28.53           C  
ATOM    608  CE1 PHE    72      27.042  41.737 102.526  1.00 53.03           C  
ATOM    609  CE2 PHE    72      26.173  43.659 103.688  1.00 64.73           C  
ATOM    610  CZ  PHE    72      26.649  42.353 103.710  1.00 46.99           C  
ATOM    611  N   PHE    73      24.145  41.972  99.194  1.00 42.22           N  
ATOM    612  CA  PHE    73      22.824  41.395  99.393  1.00 32.18           C  
ATOM    613  C   PHE    73      22.647  40.823 100.795  1.00 47.36           C  
ATOM    614  O   PHE    73      22.866  39.630 101.020  1.00 50.59           O  
ATOM    615  CB  PHE    73      22.550  40.302  98.352  1.00 16.68           C  
ATOM    616  CG  PHE    73      22.437  40.812  96.945  1.00 46.08           C  
ATOM    617  CD1 PHE    73      21.241  41.350  96.479  1.00 36.49           C  
ATOM    618  CD2 PHE    73      23.520  40.740  96.078  1.00 49.46           C  
ATOM    619  CE1 PHE    73      21.129  41.818  95.173  1.00 47.29           C  
ATOM    620  CE2 PHE    73      23.414  41.201  94.770  1.00 41.84           C  
ATOM    621  CZ  PHE    73      22.219  41.743  94.317  1.00 24.14           C  
ATOM    622  N   LYS    74      22.252  41.677 101.736  1.00 63.57           N  
ATOM    623  CA  LYS    74      21.788  41.203 103.037  1.00 65.79           C  
ATOM    624  C   LYS    74      20.345  40.710 102.925  1.00 64.36           C  
ATOM    625  O   LYS    74      19.711  40.873 101.878  1.00 57.86           O  
ATOM    626  CB  LYS    74      21.931  42.278 104.118  1.00 69.06           C  
ATOM    627  CG  LYS    74      23.118  42.045 105.040  1.00 62.10           C  
ATOM    628  CD  LYS    74      22.904  42.709 106.402  1.00 94.79           C  
ATOM    629  CE  LYS    74      23.653  41.967 107.509  1.00 98.09           C  
ATOM    630  NZ  LYS    74      25.141  42.013 107.336  1.00 73.68           N  
ATOM    631  N   GLN    75      19.837  40.112 104.004  1.00 73.63           N  
ATOM    632  CA  GLN    75      18.522  39.451 104.008  1.00 83.30           C  
ATOM    633  C   GLN    75      17.328  40.317 103.591  1.00 66.97           C  
ATOM    634  O   GLN    75      16.366  39.806 103.014  1.00 64.86           O  
ATOM    635  CB  GLN    75      18.241  38.802 105.366  1.00 97.58           C  
ATOM    636  CG  GLN    75      18.763  37.378 105.494  1.00119.01           C  
ATOM    637  CD  GLN    75      17.893  36.504 106.388  1.00132.39           C  
ATOM    638  OE1 GLN    75      16.774  36.875 106.751  1.00122.34           O  
ATOM    639  NE2 GLN    75      18.404  35.330 106.741  1.00128.61           N  
ATOM    640  N   ASN    76      17.394  41.616 103.877  1.00 70.77           N  
ATOM    641  CA  ASN    76      16.306  42.534 103.534  1.00 73.19           C  
ATOM    642  C   ASN    76      16.680  43.674 102.581  1.00 67.26           C  
ATOM    643  O   ASN    76      15.802  44.257 101.937  1.00 74.46           O  
ATOM    644  CB  ASN    76      15.649  43.092 104.804  1.00 80.64           C  
ATOM    645  CG  ASN    76      14.540  42.193 105.339  1.00 94.09           C  
ATOM    646  OD1 ASN    76      14.310  41.091 104.836  1.00116.49           O  
ATOM    647  ND2 ASN    76      13.844  42.667 106.366  1.00109.69           N  
ATOM    648  N   VAL    77      17.974  43.990 102.491  1.00 69.09           N  
ATOM    649  CA  VAL    77      18.442  45.125 101.684  1.00 62.67           C  
ATOM    650  C   VAL    77      19.398  44.696 100.564  1.00 61.27           C  
ATOM    651  O   VAL    77      20.153  43.732 100.715  1.00 62.47           O  
ATOM    652  CB  VAL    77      19.153  46.216 102.547  1.00 64.53           C  
ATOM    653  CG1 VAL    77      18.833  47.612 102.020  1.00 55.69           C  
ATOM    654  CG2 VAL    77      18.772  46.111 104.024  1.00 82.06           C  
ATOM    655  N   MET    78      19.349  45.419  99.445  1.00 42.50           N  
ATOM    656  CA  MET    78      20.336  45.285  98.371  1.00 50.14           C  
ATOM    657  C   MET    78      21.078  46.613  98.143  1.00 38.69           C  
ATOM    658  O   MET    78      20.716  47.413  97.274  1.00 48.81           O  
ATOM    659  CB  MET    78      19.703  44.737  97.077  1.00 47.97           C  
ATOM    660  CG  MET    78      18.332  45.317  96.706  1.00 69.92           C  
ATOM    661  SD  MET    78      17.692  44.689  95.138  1.00 61.78           S  
ATOM    662  CE  MET    78      17.085  43.063  95.638  1.00 74.72           C  
ATOM    663  N   THR    79      22.115  46.838  98.946  1.00 47.80           N  
ATOM    664  CA  THR    79      22.876  48.092  98.914  1.00 52.87           C  
ATOM    665  C   THR    79      24.004  48.084  97.879  1.00 52.91           C  
ATOM    666  O   THR    79      24.603  47.041  97.602  1.00 52.97           O  
ATOM    667  CB  THR    79      23.424  48.482 100.320  1.00 54.82           C  
ATOM    668  OG1 THR    79      24.399  49.528 100.192  1.00 68.46           O  
ATOM    669  CG2 THR    79      24.060  47.285 101.023  1.00 70.18           C  
ATOM    670  N   THR    80      24.279  49.260  97.318  1.00 51.14           N  
ATOM    671  CA  THR    80      25.340  49.434  96.323  1.00 51.08           C  
ATOM    672  C   THR    80      26.563  50.161  96.894  1.00 55.47           C  
ATOM    673  O   THR    80      27.634  50.164  96.279  1.00 58.74           O  
ATOM    674  CB  THR    80      24.820  50.154  95.045  1.00 47.82           C  
ATOM    675  OG1 THR    80      25.865  50.215  94.064  1.00 74.38           O  
ATOM    676  CG2 THR    80      24.325  51.569  95.356  1.00 61.08           C  
ATOM    677  N   ASP    81      26.394  50.771  98.068  1.00 55.83           N  
ATOM    678  CA  ASP    81      27.473  51.496  98.737  1.00 46.86           C  
ATOM    679  C   ASP    81      28.443  50.518  99.392  1.00 48.86           C  
ATOM    680  O   ASP    81      28.072  49.776 100.305  1.00 38.32           O  
ATOM    681  CB  ASP    81      26.906  52.473  99.775  1.00 52.86           C  
ATOM    682  CG  ASP    81      27.947  53.459 100.286  1.00 63.92           C  
ATOM    683  OD1 ASP    81      27.945  53.746 101.502  1.00 77.56           O  
ATOM    684  OD2 ASP    81      28.764  53.952  99.478  1.00108.65           O  
ATOM    685  N   ALA    82      29.684  50.524  98.912  1.00 49.02           N  
ATOM    686  CA  ALA    82      30.701  49.585  99.380  1.00 37.82           C  
ATOM    687  C   ALA    82      31.286  49.960 100.737  1.00 47.96           C  
ATOM    688  O   ALA    82      31.702  49.083 101.489  1.00 56.08           O  
ATOM    689  CB  ALA    82      31.800  49.430  98.345  1.00 43.64           C  
ATOM    690  N   GLU    83      31.309  51.258 101.037  1.00 37.70           N  
ATOM    691  CA  GLU    83      31.862  51.775 102.292  1.00 37.91           C  
ATOM    692  C   GLU    83      31.017  51.418 103.512  1.00 49.17           C  
ATOM    693  O   GLU    83      31.561  51.067 104.562  1.00 63.96           O  
ATOM    694  CB  GLU    83      32.046  53.293 102.220  1.00 28.88           C  
ATOM    695  CG  GLU    83      33.246  53.744 101.401  1.00 39.60           C  
ATOM    696  CD  GLU    83      33.449  55.251 101.436  1.00 80.26           C  
ATOM    697  OE1 GLU    83      33.713  55.837 100.365  1.00105.07           O  
ATOM    698  OE2 GLU    83      33.345  55.852 102.528  1.00 70.49           O  
ATOM    699  N   LYS    84      29.695  51.520 103.368  1.00 47.28           N  
ATOM    700  CA  LYS    84      28.765  51.139 104.429  1.00 53.19           C  
ATOM    701  C   LYS    84      28.750  49.623 104.603  1.00 56.27           C  
ATOM    702  O   LYS    84      28.696  49.127 105.728  1.00 61.84           O  
ATOM    703  CB  LYS    84      27.355  51.676 104.139  1.00 62.44           C  
ATOM    704  CG  LYS    84      26.317  51.460 105.256  1.00 75.22           C  
ATOM    705  CD  LYS    84      26.762  52.016 106.617  1.00111.96           C  
ATOM    706  CE  LYS    84      26.751  53.544 106.663  1.00115.36           C  
ATOM    707  NZ  LYS    84      25.373  54.111 106.606  1.00122.53           N  
ATOM    708  N   SER    85      28.824  48.904 103.483  1.00 52.57           N  
ATOM    709  CA  SER    85      28.869  47.442 103.478  1.00 49.61           C  
ATOM    710  C   SER    85      30.157  46.897 104.095  1.00 47.01           C  
ATOM    711  O   SER    85      30.130  45.872 104.774  1.00 52.71           O  
ATOM    712  CB  SER    85      28.703  46.911 102.054  1.00 45.25           C  
ATOM    713  OG  SER    85      27.475  47.341 101.493  1.00 55.42           O  
ATOM    714  N   PHE    86      31.271  47.591 103.855  1.00 40.80           N  
ATOM    715  CA  PHE    86      32.565  47.250 104.453  1.00 37.95           C  
ATOM    716  C   PHE    86      32.561  47.534 105.954  1.00 39.94           C  
ATOM    717  O   PHE    86      33.125  46.763 106.733  1.00 42.91           O  
ATOM    718  CB  PHE    86      33.703  48.009 103.754  1.00 43.18           C  
ATOM    719  CG  PHE    86      35.089  47.585 104.178  1.00 36.61           C  
ATOM    720  CD1 PHE    86      35.374  46.255 104.496  1.00 27.09           C  
ATOM    721  CD2 PHE    86      36.123  48.521 104.224  1.00 21.57           C  
ATOM    722  CE1 PHE    86      36.649  45.876 104.881  1.00 27.27           C  
ATOM    723  CE2 PHE    86      37.408  48.145 104.603  1.00 13.85           C  
ATOM    724  CZ  PHE    86      37.671  46.820 104.931  1.00 37.04           C  
ATOM    725  N   HIS    87      31.913  48.632 106.346  1.00 43.45           N  
ATOM    726  CA  HIS    87      31.733  48.990 107.755  1.00 33.20           C  
ATOM    727  C   HIS    87      30.821  47.992 108.483  1.00 26.92           C  
ATOM    728  O   HIS    87      30.957  47.782 109.694  1.00 38.35           O  
ATOM    729  CB  HIS    87      31.187  50.423 107.869  1.00 47.79           C  
ATOM    730  CG  HIS    87      30.780  50.816 109.256  1.00 77.67           C  
ATOM    731  ND1 HIS    87      31.689  51.004 110.276  1.00 95.54           N  
ATOM    732  CD2 HIS    87      29.560  51.056 109.791  1.00 62.79           C  
ATOM    733  CE1 HIS    87      31.046  51.341 111.380  1.00 68.04           C  
ATOM    734  NE2 HIS    87      29.753  51.381 111.113  1.00 57.51           N  
ATOM    735  N   ASP    88      29.913  47.373 107.727  1.00 37.53           N  
ATOM    736  CA  ASP    88      28.997  46.413 108.322  0.50 28.64           C  
ATOM    738  C   ASP    88      29.578  45.004 108.437  1.00 28.85           C  
ATOM    739  O   ASP    88      29.406  44.370 109.478  1.00 26.48           O  
ATOM    740  CB  ASP    88      27.622  46.450 107.604  0.50 29.14           C  
ATOM    742  CG  ASP    88      26.892  47.808 107.904  0.50 35.28           C  
ATOM    744  OD1 ASP    88      27.128  48.454 108.977  0.50 49.49           O  
ATOM    746  OD2 ASP    88      26.073  48.216 107.050  0.50 20.40           O  
ATOM    748  N   ILE    89      30.290  44.529 107.409  1.00 34.25           N  
ATOM    749  CA  ILE    89      30.942  43.200 107.451  1.00 50.45           C  
ATOM    750  C   ILE    89      32.134  43.168 108.418  1.00 46.38           C  
ATOM    751  O   ILE    89      32.570  42.095 108.855  1.00 54.94           O  
ATOM    752  CB  ILE    89      31.356  42.663 106.032  1.00 56.41           C  
ATOM    753  CG1 ILE    89      32.425  43.541 105.363  1.00 54.06           C  
ATOM    754  CG2 ILE    89      30.136  42.497 105.129  1.00 53.34           C  
ATOM    755  CD1 ILE    89      33.822  42.934 105.343  1.00 46.88           C  
ATOM    756  N   ARG    90      32.647  44.364 108.718  1.00 36.15           N  
ATOM    757  CA  ARG    90      33.648  44.613 109.751  1.00 33.44           C  
ATOM    758  C   ARG    90      33.174  44.112 111.112  1.00 35.88           C  
ATOM    759  O   ARG    90      33.923  43.464 111.846  1.00 32.69           O  
ATOM    760  CB  ARG    90      33.873  46.124 109.851  1.00 50.53           C  
ATOM    761  CG  ARG    90      35.309  46.587 109.914  1.00 49.31           C  
ATOM    762  CD  ARG    90      35.980  46.545 108.546  1.00 11.36           C  
ATOM    763  NE  ARG    90      36.812  47.723 108.294  1.00 39.72           N  
ATOM    764  CZ  ARG    90      38.043  47.915 108.768  1.00 44.50           C  
ATOM    765  NH1 ARG    90      38.630  47.013 109.548  1.00 21.11           N  
ATOM    766  NH2 ARG    90      38.693  49.029 108.462  1.00 41.44           N  
ATOM    767  N   LEU    91      31.919  44.426 111.428  1.00 49.46           N  
ATOM    768  CA  LEU    91      31.334  44.160 112.737  1.00 39.94           C  
ATOM    769  C   LEU    91      30.506  42.877 112.775  1.00 52.25           C  
ATOM    770  O   LEU    91      30.407  42.235 113.824  1.00 68.83           O  
ATOM    771  CB  LEU    91      30.465  45.347 113.181  1.00 31.54           C  
ATOM    772  CG  LEU    91      31.063  46.545 113.937  1.00 53.08           C  
ATOM    773  CD1 LEU    91      32.020  47.394 113.065  1.00 64.99           C  
ATOM    774  CD2 LEU    91      29.928  47.422 114.518  1.00 42.90           C  
ATOM    775  N   ASN    92      29.920  42.512 111.639  1.00 56.70           N  
ATOM    776  CA  ASN    92      28.881  41.490 111.607  1.00 67.96           C  
ATOM    777  C   ASN    92      29.457  40.080 111.686  1.00 72.93           C  
ATOM    778  O   ASN    92      28.842  39.179 112.256  1.00 76.53           O  
ATOM    779  CB  ASN    92      28.023  41.637 110.350  1.00 78.08           C  
ATOM    780  CG  ASN    92      26.855  42.584 110.549  1.00 88.02           C  
ATOM    781  OD1 ASN    92      25.957  42.665 109.711  1.00131.72           O  
ATOM    782  ND2 ASN    92      26.863  43.307 111.663  1.00 59.87           N  
ATOM    783  N   ARG    93      30.641  39.896 111.111  1.00 71.19           N  
ATOM    784  CA  ARG    93      31.543  38.834 111.538  1.00 73.30           C  
ATOM    785  C   ARG    93      30.928  37.458 111.301  1.00 77.32           C  
ATOM    786  O   ARG    93      31.088  36.872 110.231  1.00 84.52           O  
ATOM    787  CB  ARG    93      31.907  39.000 113.015  1.00 74.54           C  
ATOM    788  CG  ARG    93      33.069  39.947 113.265  1.00 81.79           C  
ATOM    789  CD  ARG    93      34.170  39.755 112.235  1.00 42.00           C  
ATOM    790  NE  ARG    93      35.213  40.770 112.353  1.00 52.63           N  
ATOM    791  CZ  ARG    93      36.415  40.548 112.873  1.00 69.36           C  
ATOM    792  NH1 ARG    93      36.732  39.343 113.327  1.00 79.09           N  
ATOM    793  NH2 ARG    93      37.302  41.532 112.940  1.00 90.19           N  
ATOM    794  N   ASP    94      30.224  36.950 112.307  1.00 76.75           N  
ATOM    795  CA  ASP    94      30.181  35.515 112.563  1.00 75.47           C  
ATOM    796  C   ASP    94      29.214  34.814 111.614  1.00 70.61           C  
ATOM    797  O   ASP    94      28.876  33.646 111.808  1.00 77.92           O  
ATOM    798  CB  ASP    94      29.782  35.242 114.015  1.00 74.90           C  
ATOM    799  CG  ASP    94      28.643  36.126 114.483  1.00 99.50           C  
ATOM    800  OD1 ASP    94      28.572  37.291 114.039  1.00125.90           O  
ATOM    801  OD2 ASP    94      27.818  35.656 115.295  1.00115.48           O  
ATOM    802  N   GLU    95      28.774  35.534 110.588  1.00 67.83           N  
ATOM    803  CA  GLU    95      27.934  34.949 109.541  1.00 72.63           C  
ATOM    804  C   GLU    95      28.752  34.584 108.303  1.00 69.46           C  
ATOM    805  O   GLU    95      29.844  35.120 108.089  1.00 62.78           O  
ATOM    806  CB  GLU    95      26.792  35.897 109.161  1.00 84.56           C  
ATOM    807  CG  GLU    95      25.454  35.587 109.828  1.00103.34           C  
ATOM    808  CD  GLU    95      25.446  35.870 111.321  1.00131.10           C  
ATOM    809  OE1 GLU    95      24.975  34.999 112.083  1.00149.05           O  
ATOM    810  OE2 GLU    95      25.907  36.956 111.734  1.00120.75           O  
ATOM    811  N   ASP    96      28.218  33.662 107.502  1.00 67.14           N  
ATOM    812  CA  ASP    96      28.824  33.275 106.229  1.00 61.36           C  
ATOM    813  C   ASP    96      28.684  34.390 105.199  1.00 57.82           C  
ATOM    814  O   ASP    96      27.626  35.014 105.096  1.00 58.90           O  
ATOM    815  CB  ASP    96      28.166  32.001 105.686  1.00 63.82           C  
ATOM    816  CG  ASP    96      28.538  30.760 106.478  1.00 83.76           C  
ATOM    817  OD1 ASP    96      29.690  30.294 106.361  1.00 83.72           O  
ATOM    818  OD2 ASP    96      27.668  30.237 107.206  1.00 94.54           O  
ATOM    819  N   ILE    97      29.754  34.640 104.446  1.00 50.57           N  
ATOM    820  CA  ILE    97      29.721  35.600 103.340  1.00 42.35           C  
ATOM    821  C   ILE    97      29.851  34.847 102.017  1.00 48.41           C  
ATOM    822  O   ILE    97      30.668  33.930 101.892  1.00 61.71           O  
ATOM    823  CB  ILE    97      30.836  36.681 103.452  1.00 38.51           C  
ATOM    824  CG1 ILE    97      30.998  37.146 104.905  1.00 56.20           C  
ATOM    825  CG2 ILE    97      30.543  37.866 102.519  1.00 36.70           C  
ATOM    826  CD1 ILE    97      32.017  38.258 105.111  1.00 36.92           C  
ATOM    827  N   TYR    98      29.036  35.235 101.038  1.00 43.37           N  
ATOM    828  CA  TYR    98      29.033  34.593  99.728  1.00 41.55           C  
ATOM    829  C   TYR    98      29.468  35.571  98.639  1.00 45.44           C  
ATOM    830  O   TYR    98      28.735  36.499  98.298  1.00 53.75           O  
ATOM    831  CB  TYR    98      27.649  34.019  99.419  1.00 43.75           C  
ATOM    832  CG  TYR    98      27.234  32.868 100.314  1.00 46.05           C  
ATOM    833  CD1 TYR    98      27.502  31.550  99.950  1.00 57.34           C  
ATOM    834  CD2 TYR    98      26.568  33.095 101.521  1.00 43.28           C  
ATOM    835  CE1 TYR    98      27.125  30.486 100.764  1.00 67.21           C  
ATOM    836  CE2 TYR    98      26.186  32.038 102.343  1.00 73.75           C  
ATOM    837  CZ  TYR    98      26.468  30.737 101.957  1.00 66.92           C  
ATOM    838  OH  TYR    98      26.093  29.688 102.765  1.00 54.52           O  
ATOM    839  N   ILE    99      30.663  35.352  98.098  1.00 37.68           N  
ATOM    840  CA  ILE    99      31.256  36.271  97.125  1.00 28.08           C  
ATOM    841  C   ILE    99      31.253  35.693  95.710  1.00 42.24           C  
ATOM    842  O   ILE    99      31.662  34.549  95.497  1.00 51.89           O  
ATOM    843  CB  ILE    99      32.712  36.664  97.512  1.00 32.23           C  
ATOM    844  CG1 ILE    99      32.817  36.961  99.014  1.00 42.55           C  
ATOM    845  CG2 ILE    99      33.200  37.863  96.683  1.00 37.46           C  
ATOM    846  CD1 ILE    99      34.240  37.035  99.531  1.00 44.76           C  
ATOM    847  N   GLN   100      30.778  36.487  94.752  1.00 41.82           N  
ATOM    848  CA  GLN   100      30.997  36.194  93.339  1.00 50.21           C  
ATOM    849  C   GLN   100      31.923  37.230  92.706  1.00 54.68           C  
ATOM    850  O   GLN   100      31.944  38.398  93.113  1.00 54.28           O  
ATOM    851  CB  GLN   100      29.678  36.066  92.560  1.00 50.15           C  
ATOM    852  CG  GLN   100      28.947  37.353  92.243  1.00 46.68           C  
ATOM    853  CD  GLN   100      27.981  37.186  91.088  1.00 48.67           C  
ATOM    854  OE1 GLN   100      28.382  37.188  89.922  1.00 30.74           O  
ATOM    855  NE2 GLN   100      26.702  37.039  91.406  1.00 37.98           N  
ATOM    856  N   LEU   101      32.703  36.784  91.724  1.00 50.71           N  
ATOM    857  CA  LEU   101      33.607  37.672  91.003  1.00 52.79           C  
ATOM    858  C   LEU   101      33.303  37.675  89.512  1.00 48.52           C  
ATOM    859  O   LEU   101      33.158  36.615  88.895  1.00 54.98           O  
ATOM    860  CB  LEU   101      35.076  37.300  91.253  1.00 57.78           C  
ATOM    861  CG  LEU   101      35.778  37.766  92.539  1.00 45.95           C  
ATOM    862  CD1 LEU   101      35.421  39.206  92.898  1.00 44.26           C  
ATOM    863  CD2 LEU   101      35.496  36.844  93.713  1.00 51.41           C  
ATOM    864  N   ASN   102      33.203  38.874  88.944  1.00 44.83           N  
ATOM    865  CA  ASN   102      32.942  39.035  87.518  1.00 54.17           C  
ATOM    866  C   ASN   102      34.192  39.484  86.763  1.00 63.67           C  
ATOM    867  O   ASN   102      34.495  40.678  86.690  1.00 68.06           O  
ATOM    868  CB  ASN   102      31.780  40.012  87.282  1.00 52.28           C  
ATOM    869  CG  ASN   102      30.482  39.560  87.940  1.00 52.25           C  
ATOM    870  OD1 ASN   102      29.761  40.367  88.527  1.00 64.12           O  
ATOM    871  ND2 ASN   102      30.180  38.268  87.842  1.00 50.03           N  
ATOM    872  N   PHE   103      34.917  38.512  86.213  1.00 64.90           N  
ATOM    873  CA  PHE   103      36.127  38.782  85.431  1.00 71.60           C  
ATOM    874  C   PHE   103      36.130  38.030  84.095  1.00 72.29           C  
ATOM    875  O   PHE   103      35.446  37.014  83.956  1.00 67.27           O  
ATOM    876  CB  PHE   103      37.415  38.570  86.256  1.00 69.00           C  
ATOM    877  CG  PHE   103      37.562  37.193  86.863  1.00 58.28           C  
ATOM    878  CD1 PHE   103      36.832  36.817  87.992  1.00 59.61           C  
ATOM    879  CD2 PHE   103      38.478  36.291  86.336  1.00 44.98           C  
ATOM    880  CE1 PHE   103      36.987  35.554  88.558  1.00 62.83           C  
ATOM    881  CE2 PHE   103      38.647  35.029  86.901  1.00 79.49           C  
ATOM    882  CZ  PHE   103      37.896  34.659  88.011  1.00 69.92           C  
ATOM    883  N   LYS   104      36.894  38.532  83.130  1.00 79.77           N  
ATOM    884  CA  LYS   104      36.661  38.217  81.726  1.00 77.85           C  
ATOM    885  C   LYS   104      36.767  36.717  81.472  1.00 80.76           C  
ATOM    886  O   LYS   104      35.888  36.119  80.852  1.00 89.35           O  
ATOM    887  CB  LYS   104      37.649  38.972  80.836  1.00 72.34           C  
ATOM    888  CG  LYS   104      37.514  38.660  79.354  1.00 89.58           C  
ATOM    889  CD  LYS   104      37.651  39.917  78.511  1.00108.84           C  
ATOM    890  CE  LYS   104      36.312  40.613  78.335  1.00111.27           C  
ATOM    891  NZ  LYS   104      36.408  41.778  77.412  1.00106.29           N  
ATOM    892  N   SER   105      37.849  36.115  81.956  1.00 79.14           N  
ATOM    893  CA  SER   105      38.225  34.768  81.544  1.00 84.89           C  
ATOM    894  C   SER   105      37.589  33.717  82.448  1.00 82.17           C  
ATOM    895  O   SER   105      37.340  32.589  82.023  1.00 88.04           O  
ATOM    896  CB  SER   105      39.747  34.613  81.548  1.00 93.30           C  
ATOM    897  OG  SER   105      40.275  34.793  82.850  1.00 90.41           O  
ATOM    898  N   SER   106      37.328  34.096  83.695  1.00 73.03           N  
ATOM    899  CA  SER   106      36.538  33.267  84.597  1.00 75.36           C  
ATOM    900  C   SER   106      36.819  31.785  84.373  1.00 81.22           C  
ATOM    901  O   SER   106      37.758  31.228  84.942  1.00 72.87           O  
ATOM    902  CB  SER   106      35.046  33.552  84.419  1.00 64.71           C  
ATOM    903  OG  SER   106      34.653  34.698  85.155  1.00 77.91           O  
ATOM    904  N   PHE   107      35.999  31.151  83.541  1.00 83.20           N  
ATOM    905  CA  PHE   107      35.974  29.697  83.449  1.00 84.24           C  
ATOM    906  C   PHE   107      37.065  29.184  82.516  1.00 86.74           C  
ATOM    907  O   PHE   107      37.000  28.055  82.029  1.00 85.34           O  
ATOM    908  CB  PHE   107      34.603  29.213  82.971  1.00 81.07           C  
ATOM    909  CG  PHE   107      33.671  28.836  84.087  1.00 80.14           C  
ATOM    910  CD1 PHE   107      33.679  27.555  84.611  1.00 79.45           C  
ATOM    911  CD2 PHE   107      32.785  29.763  84.611  1.00 81.77           C  
ATOM    912  CE1 PHE   107      32.822  27.205  85.638  1.00 73.72           C  
ATOM    913  CE2 PHE   107      31.926  29.419  85.637  1.00 86.27           C  
ATOM    914  CZ  PHE   107      31.945  28.138  86.151  1.00 81.88           C  
ATOM    915  N   GLN   108      38.068  30.021  82.269  1.00 81.83           N  
ATOM    916  CA  GLN   108      39.314  29.567  81.664  1.00 71.50           C  
ATOM    917  C   GLN   108      40.315  29.128  82.727  1.00 73.51           C  
ATOM    918  O   GLN   108      41.228  28.350  82.450  1.00 84.63           O  
ATOM    919  CB  GLN   108      39.920  30.670  80.794  1.00 60.92           C  
ATOM    920  CG  GLN   108      41.374  30.435  80.417  1.00 65.78           C  
ATOM    921  CD  GLN   108      42.133  31.727  80.189  1.00 78.37           C  
ATOM    922  OE1 GLN   108      41.699  32.589  79.424  1.00 89.24           O  
ATOM    923  NE2 GLN   108      43.274  31.869  80.853  1.00 93.78           N  
ATOM    924  N   ASN   109      40.138  29.632  83.944  1.00 61.06           N  
ATOM    925  CA  ASN   109      41.099  29.402  85.016  1.00 56.97           C  
ATOM    926  C   ASN   109      40.647  28.313  85.986  1.00 59.09           C  
ATOM    927  O   ASN   109      39.636  28.468  86.676  1.00 75.42           O  
ATOM    928  CB  ASN   109      41.355  30.715  85.760  1.00 60.45           C  
ATOM    929  CG  ASN   109      41.531  31.894  84.820  1.00 74.41           C  
ATOM    930  OD1 ASN   109      42.538  31.999  84.117  1.00 79.56           O  
ATOM    931  ND2 ASN   109      40.550  32.791  84.809  1.00 59.82           N  
ATOM    932  N   ALA   110      41.421  27.226  86.034  1.00 59.44           N  
ATOM    933  CA  ALA   110      41.104  26.024  86.820  1.00 76.50           C  
ATOM    934  C   ALA   110      40.965  26.262  88.322  1.00 85.33           C  
ATOM    935  O   ALA   110      40.127  25.641  88.974  1.00 92.26           O  
ATOM    936  CB  ALA   110      42.139  24.935  86.554  1.00 82.37           C  
ATOM    937  N   ASN   111      41.793  27.159  88.852  1.00 82.09           N  
ATOM    938  CA  ASN   111      41.751  27.555  90.263  1.00 78.31           C  
ATOM    939  C   ASN   111      40.481  28.279  90.704  1.00 81.26           C  
ATOM    940  O   ASN   111      40.028  28.098  91.838  1.00 72.89           O  
ATOM    941  CB  ASN   111      43.003  28.352  90.673  1.00 74.33           C  
ATOM    942  CG  ASN   111      43.195  29.661  89.888  1.00 91.41           C  
ATOM    943  OD1 ASN   111      43.724  30.630  90.433  1.00100.72           O  
ATOM    944  ND2 ASN   111      42.798  29.687  88.621  1.00 89.07           N  
ATOM    945  N   TYR   112      39.919  29.097  89.812  1.00 79.02           N  
ATOM    946  CA  TYR   112      38.642  29.763  90.070  1.00 74.72           C  
ATOM    947  C   TYR   112      37.493  28.757  90.073  1.00 69.62           C  
ATOM    948  O   TYR   112      36.572  28.866  90.882  1.00 78.78           O  
ATOM    949  CB  TYR   112      38.386  30.890  89.057  1.00 72.88           C  
ATOM    950  CG  TYR   112      36.951  31.392  89.019  1.00 74.65           C  
ATOM    951  CD1 TYR   112      36.144  31.159  87.905  1.00 79.19           C  
ATOM    952  CD2 TYR   112      36.398  32.089  90.098  1.00 68.23           C  
ATOM    953  CE1 TYR   112      34.829  31.611  87.860  1.00 84.25           C  
ATOM    954  CE2 TYR   112      35.082  32.543  90.065  1.00 59.00           C  
ATOM    955  CZ  TYR   112      34.305  32.301  88.942  1.00 78.44           C  
ATOM    956  OH  TYR   112      33.004  32.748  88.902  1.00 73.48           O  
ATOM    957  N   VAL   113      37.558  27.778  89.172  1.00 62.73           N  
ATOM    958  CA  VAL   113      36.542  26.726  89.111  1.00 67.82           C  
ATOM    959  C   VAL   113      36.683  25.765  90.301  1.00 71.35           C  
ATOM    960  O   VAL   113      35.686  25.234  90.801  1.00 73.33           O  
ATOM    961  CB  VAL   113      36.566  25.959  87.761  1.00 63.65           C  
ATOM    962  CG1 VAL   113      35.270  25.182  87.569  1.00 54.93           C  
ATOM    963  CG2 VAL   113      36.724  26.935  86.605  1.00 60.95           C  
ATOM    964  N   ALA   114      37.919  25.572  90.765  1.00 76.69           N  
ATOM    965  CA  ALA   114      38.192  24.758  91.953  1.00 80.97           C  
ATOM    966  C   ALA   114      37.709  25.418  93.245  1.00 78.44           C  
ATOM    967  O   ALA   114      37.286  24.727  94.175  1.00 66.02           O  
ATOM    968  CB  ALA   114      39.676  24.435  92.051  1.00 92.18           C  
ATOM    969  N   VAL   115      37.770  26.748  93.296  1.00 75.18           N  
ATOM    970  CA  VAL   115      37.393  27.499  94.499  1.00 59.72           C  
ATOM    971  C   VAL   115      35.870  27.702  94.617  1.00 56.76           C  
ATOM    972  O   VAL   115      35.364  28.046  95.692  1.00 50.37           O  
ATOM    973  CB  VAL   115      38.187  28.845  94.612  1.00 58.85           C  
ATOM    974  CG1 VAL   115      37.478  29.989  93.887  1.00 60.87           C  
ATOM    975  CG2 VAL   115      38.449  29.205  96.073  1.00 56.17           C  
ATOM    976  N   LEU   116      35.151  27.466  93.517  1.00 48.29           N  
ATOM    977  CA  LEU   116      33.690  27.584  93.485  1.00 47.06           C  
ATOM    978  C   LEU   116      33.000  26.504  94.314  1.00 54.39           C  
ATOM    979  O   LEU   116      33.454  25.358  94.365  1.00 65.36           O  
ATOM    980  CB  LEU   116      33.167  27.548  92.044  1.00 49.10           C  
ATOM    981  CG  LEU   116      33.228  28.833  91.208  1.00 59.28           C  
ATOM    982  CD1 LEU   116      33.046  28.512  89.730  1.00 80.25           C  
ATOM    983  CD2 LEU   116      32.196  29.866  91.670  1.00 67.83           C  
ATOM    984  N   GLU   117      31.901  26.889  94.962  1.00 54.18           N  
ATOM    985  CA  GLU   117      31.165  26.003  95.862  1.00 65.51           C  
ATOM    986  C   GLU   117      29.683  25.931  95.498  1.00 73.86           C  
ATOM    987  O   GLU   117      29.170  26.787  94.769  1.00 82.41           O  
ATOM    988  CB  GLU   117      31.321  26.465  97.317  1.00 59.45           C  
ATOM    989  CG  GLU   117      32.745  26.386  97.860  1.00 68.90           C  
ATOM    990  CD  GLU   117      32.862  26.863  99.295  1.00 78.47           C  
ATOM    991  OE1 GLU   117      33.674  27.777  99.552  1.00104.50           O  
ATOM    992  OE2 GLU   117      32.145  26.326 100.167  1.00 96.20           O  
ATOM    993  N   GLU   118      29.011  24.898  96.008  1.00 83.47           N  
ATOM    994  CA  GLU   118      27.568  24.732  95.846  1.00 86.27           C  
ATOM    995  C   GLU   118      26.795  25.804  96.608  1.00 80.52           C  
ATOM    996  O   GLU   118      26.851  25.872  97.838  1.00 81.70           O  
ATOM    997  CB  GLU   118      27.133  23.336  96.304  1.00 92.70           C  
ATOM    998  CG  GLU   118      26.780  22.378  95.173  1.00116.45           C  
ATOM    999  CD  GLU   118      25.311  22.451  94.776  1.00132.68           C  
ATOM   1000  OE1 GLU   118      24.438  22.359  95.671  1.00133.96           O  
ATOM   1001  OE2 GLU   118      25.029  22.589  93.566  1.00138.23           O  
ATOM   1002  N   ASN   119      26.096  26.646  95.853  1.00 71.42           N  
ATOM   1003  CA  ASN   119      25.233  27.688  96.397  1.00 67.20           C  
ATOM   1004  C   ASN   119      23.840  27.099  96.645  1.00 66.23           C  
ATOM   1005  O   ASN   119      23.119  26.792  95.692  1.00 71.02           O  
ATOM   1006  CB  ASN   119      25.201  28.882  95.423  1.00 71.74           C  
ATOM   1007  CG  ASN   119      24.132  29.926  95.778  1.00 54.24           C  
ATOM   1008  OD1 ASN   119      23.699  30.063  96.934  1.00 63.35           O  
ATOM   1009  ND2 ASN   119      23.721  30.686  94.767  1.00 50.59           N  
ATOM   1010  N   PRO   120      23.458  26.941  97.930  1.00 67.17           N  
ATOM   1011  CA  PRO   120      22.210  26.271  98.289  1.00 72.55           C  
ATOM   1012  C   PRO   120      21.014  27.218  98.461  1.00 70.30           C  
ATOM   1013  O   PRO   120      20.143  26.969  99.300  1.00 79.44           O  
ATOM   1014  CB  PRO   120      22.561  25.599  99.621  1.00 75.47           C  
ATOM   1015  CG  PRO   120      23.674  26.451 100.210  1.00 68.75           C  
ATOM   1016  CD  PRO   120      24.189  27.380  99.133  1.00 60.87           C  
ATOM   1017  N   TYR   121      20.976  28.287  97.668  1.00 66.26           N  
ATOM   1018  CA  TYR   121      19.871  29.248  97.703  1.00 70.81           C  
ATOM   1019  C   TYR   121      19.294  29.470  96.308  1.00 75.80           C  
ATOM   1020  O   TYR   121      18.388  30.288  96.117  1.00 86.93           O  
ATOM   1021  CB  TYR   121      20.316  30.569  98.340  1.00 77.51           C  
ATOM   1022  CG  TYR   121      20.838  30.401  99.748  1.00 92.01           C  
ATOM   1023  CD1 TYR   121      22.207  30.339  99.998  1.00102.48           C  
ATOM   1024  CD2 TYR   121      19.964  30.284 100.828  1.00102.41           C  
ATOM   1025  CE1 TYR   121      22.697  30.169 101.288  1.00 93.63           C  
ATOM   1026  CE2 TYR   121      20.443  30.118 102.122  1.00 97.11           C  
ATOM   1027  CZ  TYR   121      21.809  30.060 102.345  1.00 87.71           C  
ATOM   1028  OH  TYR   121      22.287  29.899 103.625  1.00 82.59           O  
ATOM   1029  N   LEU   122      19.823  28.737  95.334  1.00 74.94           N  
ATOM   1030  CA  LEU   122      19.115  28.503  94.081  1.00 73.34           C  
ATOM   1031  C   LEU   122      17.804  27.762  94.319  1.00 73.93           C  
ATOM   1032  O   LEU   122      17.756  26.793  95.077  1.00 74.38           O  
ATOM   1033  CB  LEU   122      19.995  27.716  93.107  1.00 79.27           C  
ATOM   1034  CG  LEU   122      20.942  28.540  92.233  1.00 62.59           C  
ATOM   1035  CD1 LEU   122      20.590  28.382  90.761  1.00104.35           C  
ATOM   1036  CD2 LEU   122      20.914  30.004  92.641  1.00 57.43           C  
END
