
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  118 ( 1934),  selected  118 , name 2ftu_A
# Molecule2: number of CA atoms  175 ( 1486),  selected  175 , name T0496.pdb
# PARAMETERS: 2ftu_A.T0496.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    R     1_A      P       4           -
LGA    V     2_A      V       5           -
LGA    S     3_A      S       6           -
LGA    -       -      V       7           -
LGA    -       -      N       8           -
LGA    -       -      E       9           -
LGA    -       -      K      10           -
LGA    -       -      K      11           -
LGA    -       -      D      12           -
LGA    -       -      F      13           -
LGA    -       -      V      14           -
LGA    -       -      K      15           -
LGA    H     4_A      W      16           #
LGA    Q     5_A      F      17           -
LGA    -       -      L      18           -
LGA    -       -      N      19           -
LGA    G     6_A      N      20           #
LGA    Y     7_A      Y      21           -
LGA    -       -      Q      22           -
LGA    -       -      L      23           -
LGA    -       -      K      24           -
LGA    -       -      Q      25           -
LGA    -       -      R      26           -
LGA    -       -      E      27           -
LGA    -       -      C      28           -
LGA    -       -      V      29           -
LGA    -       -      W      30           -
LGA    -       -      I      31           -
LGA    -       -      L      32           -
LGA    -       -      N      33           -
LGA    -       -      Y      34           -
LGA    -       -      L      35           -
LGA    -       -      M      36           -
LGA    -       -      S      37           -
LGA    -       -      H      38           -
LGA    -       -      D      39           -
LGA    -       -      Q      40           -
LGA    -       -      L      41           -
LGA    -       -      M      42           -
LGA    -       -      H      43           -
LGA    -       -      K      44           -
LGA    -       -      V      45           -
LGA    -       -      H      46           -
LGA    -       -      F      47           -
LGA    -       -      V      48           -
LGA    -       -      E      49           -
LGA    -       -      H      50           -
LGA    -       -      A      51           -
LGA    -       -      K      52           -
LGA    -       -      Y      53           -
LGA    -       -      C      54           -
LGA    -       -      P      55           -
LGA    -       -      R      56           -
LGA    -       -      G      57           -
LGA    -       -      L      58           -
LGA    -       -      V      59           -
LGA    -       -      M      60           -
LGA    -       -      S      61           -
LGA    -       -      A      62           -
LGA    -       -      N      63           -
LGA    S     8_A      C      64           #
LGA    T     9_A      V      65           -
LGA    -       -      K      66           -
LGA    -       -      D      67           -
LGA    -       -      T      68           -
LGA    -       -      P      69           -
LGA    -       -      F      70           -
LGA    -       -      H      71           -
LGA    -       -      F      72           -
LGA    -       -      F      73           -
LGA    -       -      K      74           -
LGA    -       -      Q      75           -
LGA    -       -      N      76           -
LGA    -       -      V      77           -
LGA    -       -      M      78           -
LGA    -       -      T      79           -
LGA    -       -      T      80           -
LGA    -       -      D      81           -
LGA    -       -      A      82           -
LGA    -       -      E      83           -
LGA    -       -      K      84           -
LGA    -       -      S      85           -
LGA    -       -      F      86           -
LGA    -       -      H      87           -
LGA    -       -      D      88           -
LGA    -       -      I      89           -
LGA    -       -      R      90           -
LGA    -       -      L      91           -
LGA    -       -      N      92           -
LGA    -       -      R      93           -
LGA    -       -      D      94           -
LGA    -       -      E      95           -
LGA    -       -      D      96           -
LGA    -       -      I      97           -
LGA    -       -      Y      98           -
LGA    -       -      I      99           -
LGA    -       -      Q     100           -
LGA    -       -      L     101           -
LGA    -       -      N     102           -
LGA    -       -      F     103           -
LGA    E    10_A      K     104          4.818
LGA    A    11_A      S     105          1.993
LGA    E    12_A      S     106          3.594
LGA    F    13_A      F     107          4.968
LGA    E    14_A      Q     108          4.423
LGA    -       -      N     109           -
LGA    -       -      A     110           -
LGA    -       -      N     111           -
LGA    -       -      Y     112           -
LGA    E    15_A      V     113          2.880
LGA    P    16_A      A     114           -
LGA    R    17_A      -       -           -
LGA    V    18_A      -       -           -
LGA    I    19_A      -       -           -
LGA    D    20_A      V     115          2.781
LGA    L    21_A      L     116          3.070
LGA    W    22_A      E     117          3.155
LGA    D    23_A      -       -           -
LGA    L    24_A      -       -           -
LGA    A    25_A      E     118          3.368
LGA    Q    26_A      N     119           -
LGA    S    27_A      -       -           -
LGA    A    28_A      -       -           -
LGA    N    29_A      -       -           -
LGA    L    30_A      P     120           #
LGA    T    31_A      Y     121           -
LGA    D    32_A      L     122           -
LGA    K    33_A      P     123           -
LGA    -       -      K     124           -
LGA    -       -      H     125           -
LGA    E    34_A      I     126           #
LGA    L    35_A      E     127           -
LGA    E    36_A      -       -           -
LGA    A    37_A      V     128          4.457
LGA    F    38_A      N     129          3.010
LGA    R    39_A      E     130          2.129
LGA    E    40_A      -       -           -
LGA    E    41_A      K     131          3.203
LGA    L    42_A      D     132          4.018
LGA    K    43_A      R     133          2.631
LGA    H    44_A      L     134          3.313
LGA    F    45_A      L     135          3.606
LGA    E    46_A      A     136          1.542
LGA    A    47_A      E     137          1.295
LGA    K    48_A      R     138          2.554
LGA    I    49_A      F     139          2.425
LGA    E    50_A      L     140          0.833
LGA    K    51_A      E     141          1.788
LGA    H    52_A      E     142          1.621
LGA    N    53_A      S     143          0.839
LGA    H    54_A      V     144          0.948
LGA    Y    55_A      F     145          1.723
LGA    Q    56_A      S     146          0.527
LGA    K    57_A      F     147          0.966
LGA    Q    58_A      R     148          1.470
LGA    L    59_A      R     149          1.256
LGA    E    60_A      E     150          1.232
LGA    I    61_A      R     151          1.525
LGA    A    62_A      L     152          1.237
LGA    H    63_A      L     153          1.170
LGA    E    64_A      K     154          1.264
LGA    K    65_A      Q     155          1.041
LGA    L    66_A      I     156          0.836
LGA    R    67_A      D     157          0.340
LGA    H    68_A      E     158          0.348
LGA    A    69_A      A     159          0.601
LGA    E    70_A      L     160          1.394
LGA    S    71_A      D     161          1.417
LGA    V    72_A      K     162          1.625
LGA    G    73_A      Q     163          2.089
LGA    D    74_A      D     164          2.043
LGA    G    75_A      K     165          1.939
LGA    E    76_A      E     166          2.290
LGA    R    77_A      A     167          1.291
LGA    V    78_A      F     168          0.685
LGA    S    79_A      H     169          1.161
LGA    R    80_A      R     170          1.742
LGA    S    81_A      L     171          1.101
LGA    R    82_A      T     172          0.678
LGA    E    83_A      A     173          1.539
LGA    K    84_A      E     174          2.130
LGA    H    85_A      L     175          1.718
LGA    A    86_A      K     176          2.164
LGA    L    87_A      M     177          2.796
LGA    L    88_A      L     178          3.008
LGA    E    89_A      -       -           -
LGA    G    90_A      -       -           -
LGA    R    91_A      -       -           -
LGA    T    92_A      -       -           -
LGA    K    93_A      -       -           -
LGA    E    94_A      -       -           -
LGA    L    95_A      -       -           -
LGA    G    96_A      -       -           -
LGA    Y    97_A      -       -           -
LGA    T    98_A      -       -           -
LGA    V    99_A      -       -           -
LGA    K   100_A      -       -           -
LGA    K   101_A      -       -           -
LGA    H   102_A      -       -           -
LGA    L   103_A      -       -           -
LGA    Q   104_A      -       -           -
LGA    D   105_A      -       -           -
LGA    L   106_A      -       -           -
LGA    S   107_A      -       -           -
LGA    G   108_A      -       -           -
LGA    R   109_A      -       -           -
LGA    I   110_A      -       -           -
LGA    S   111_A      -       -           -
LGA    R   112_A      -       -           -
LGA    A   113_A      -       -           -
LGA    R   114_A      -       -           -
LGA    H   115_A      -       -           -
LGA    N   116_A      -       -           -
LGA    E   117_A      -       -           -
LGA    L   118_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  118  175    5.0     61    2.32    13.11     27.747     2.519

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.569845 * X  +  -0.740721 * Y  +  -0.355820 * Z  +  34.325779
  Y_new =   0.334932 * X  +  -0.186047 * Y  +   0.923692 * Z  +  29.249437
  Z_new =  -0.750398 * X  +  -0.645537 * Y  +   0.142073 * Z  +  80.536110 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.354165    1.787428  [ DEG:   -77.5879    102.4121 ]
  Theta =   0.848664    2.292929  [ DEG:    48.6249    131.3751 ]
  Phi   =   0.531370   -2.610223  [ DEG:    30.4453   -149.5547 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ftu_A                                        
REMARK     2: T0496.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ftu_A.T0496.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  118  175   5.0   61   2.32   13.11  27.747
REMARK  ---------------------------------------------------------- 
MOLECULE 2ftu_A
HEADER    LIPID BINDING PROTEIN                   24-JAN-06   2FTU              
TITLE     SOLUTION STRUCTURE OF DOMAIN 3 OF RAP                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ALPHA-2-MACROGLOBULIN RECEPTOR-ASSOCIATED                  
COMPND   3 PROTEIN, DOMAIN 3;                                                   
COMPND   4 CHAIN: A;                                                            
COMPND   5 FRAGMENT: RESIDUES 240-357;                                          
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: HOMO SAPIENS;                                   
SOURCE   3 ORGANISM_COMMON: HUMAN;                                              
SOURCE   4 GENE: LRPAP1;                                                        
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    DOMAIN 3; RAP; RECEPTOR-ASSOCIATED PROTEIN                            
EXPDTA    NMR, 20 STRUCTURES                                                    
AUTHOR    D.LEE,J.D.WALSH,Y.-X.WANG                                             
REVDAT   1   09-MAY-06 2FTU    0                                                
JRNL        AUTH   D.LEE,J.D.WALSH,I.MIKHAILENKO,P.YU,M.MIGLIORINI,             
JRNL        AUTH 2 Y.WU,S.KRUEGER,J.E.CURTIS,B.HARRIS,S.LOCKETT,                
JRNL        AUTH 3 S.C.BLACKLOW,D.K.STRICKLAND,Y.X.WANG                         
JRNL        TITL   RAP USES A HISTIDINE SWITCH TO REGULATE ITS                  
JRNL        TITL 2 INTERACTION WITH LRP IN THE ER AND GOLGI.                    
JRNL        REF    MOL.CELL                      V.  22   423 2006              
JRNL        REFN   ASTM MOCEFL  US ISSN 1097-2765                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2FTU A    1   118  UNP    P30533   AMRP_HUMAN     240    357             
SEQRES   1 A  118  ARG VAL SER HIS GLN GLY TYR SER THR GLU ALA GLU PHE          
SEQRES   2 A  118  GLU GLU PRO ARG VAL ILE ASP LEU TRP ASP LEU ALA GLN          
SEQRES   3 A  118  SER ALA ASN LEU THR ASP LYS GLU LEU GLU ALA PHE ARG          
SEQRES   4 A  118  GLU GLU LEU LYS HIS PHE GLU ALA LYS ILE GLU LYS HIS          
SEQRES   5 A  118  ASN HIS TYR GLN LYS GLN LEU GLU ILE ALA HIS GLU LYS          
SEQRES   6 A  118  LEU ARG HIS ALA GLU SER VAL GLY ASP GLY GLU ARG VAL          
SEQRES   7 A  118  SER ARG SER ARG GLU LYS HIS ALA LEU LEU GLU GLY ARG          
SEQRES   8 A  118  THR LYS GLU LEU GLY TYR THR VAL LYS LYS HIS LEU GLN          
SEQRES   9 A  118  ASP LEU SER GLY ARG ILE SER ARG ALA ARG HIS ASN GLU          
SEQRES  10 A  118  LEU                                                          
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM      1  N   ARG A   1      43.660  21.267  82.443  1.00  0.00           N  
ATOM      2  CA  ARG A   1      42.540  21.828  83.214  1.00  0.00           C  
ATOM      3  C   ARG A   1      42.647  23.354  83.135  1.00  0.00           C  
ATOM      4  O   ARG A   1      43.714  23.877  82.803  1.00  0.00           O  
ATOM      5  CB  ARG A   1      42.537  21.282  84.654  1.00  0.00           C  
ATOM      6  CG  ARG A   1      41.175  21.135  85.348  1.00  0.00           C  
ATOM      7  CD  ARG A   1      40.726  22.402  86.102  1.00  0.00           C  
ATOM      8  NE  ARG A   1      39.898  22.089  87.285  1.00  0.00           N  
ATOM      9  CZ  ARG A   1      40.330  21.528  88.429  1.00  0.00           C  
ATOM     10  NH1 ARG A   1      41.629  21.312  88.640  1.00  0.00           N  
ATOM     11  NH2 ARG A   1      39.451  21.145  89.353  1.00  0.00           N  
ATOM     12  HA  ARG A   1      41.620  21.519  82.719  1.00  0.00           H  
ATOM     13  HB2 ARG A   1      42.972  20.281  84.630  1.00  0.00           H  
ATOM     14  HB3 ARG A   1      43.172  21.908  85.275  1.00  0.00           H  
ATOM     15  HG2 ARG A   1      40.416  20.828  84.628  1.00  0.00           H  
ATOM     16  HG3 ARG A   1      41.283  20.319  86.065  1.00  0.00           H  
ATOM     17  HD2 ARG A   1      41.589  22.983  86.436  1.00  0.00           H  
ATOM     18  HD3 ARG A   1      40.132  23.009  85.425  1.00  0.00           H  
ATOM     19  HE  ARG A   1      38.904  22.272  87.212  1.00  0.00           H  
ATOM     20 HH11 ARG A   1      42.363  21.661  88.034  1.00  0.00           H  
ATOM     21 HH12 ARG A   1      41.900  20.768  89.456  1.00  0.00           H  
ATOM     22 HH21 ARG A   1      38.459  21.337  89.253  1.00  0.00           H  
ATOM     23 HH22 ARG A   1      39.763  20.628  90.167  1.00  0.00           H  
ATOM     24  H1  ARG A   1      43.830  21.707  81.561  1.00  0.00           H  
ATOM     25  N   VAL A   2      41.547  24.077  83.356  1.00  0.00           N  
ATOM     26  CA  VAL A   2      41.529  25.535  83.257  1.00  0.00           C  
ATOM     27  C   VAL A   2      42.638  26.132  84.133  1.00  0.00           C  
ATOM     28  O   VAL A   2      42.910  25.639  85.230  1.00  0.00           O  
ATOM     29  CB  VAL A   2      40.117  26.072  83.584  1.00  0.00           C  
ATOM     30  CG1 VAL A   2      39.787  26.067  85.084  1.00  0.00           C  
ATOM     31  CG2 VAL A   2      39.919  27.482  83.022  1.00  0.00           C  
ATOM     32  H   VAL A   2      40.674  23.592  83.518  1.00  0.00           H  
ATOM     33  HA  VAL A   2      41.755  25.781  82.218  1.00  0.00           H  
ATOM     34  HB  VAL A   2      39.395  25.426  83.080  1.00  0.00           H  
ATOM     35 HG11 VAL A   2      40.361  26.838  85.599  1.00  0.00           H  
ATOM     36 HG12 VAL A   2      38.727  26.270  85.229  1.00  0.00           H  
ATOM     37 HG13 VAL A   2      40.053  25.109  85.525  1.00  0.00           H  
ATOM     38 HG21 VAL A   2      40.159  27.491  81.962  1.00  0.00           H  
ATOM     39 HG22 VAL A   2      38.882  27.793  83.151  1.00  0.00           H  
ATOM     40 HG23 VAL A   2      40.572  28.192  83.531  1.00  0.00           H  
ATOM     41  N   SER A   3      43.308  27.160  83.627  1.00  0.00           N  
ATOM     42  CA  SER A   3      44.294  27.942  84.347  1.00  0.00           C  
ATOM     43  C   SER A   3      44.299  29.336  83.729  1.00  0.00           C  
ATOM     44  O   SER A   3      43.965  29.482  82.547  1.00  0.00           O  
ATOM     45  CB  SER A   3      45.668  27.287  84.204  1.00  0.00           C  
ATOM     46  OG  SER A   3      45.713  26.044  84.884  1.00  0.00           O  
ATOM     47  H   SER A   3      43.044  27.580  82.743  1.00  0.00           H  
ATOM     48  HA  SER A   3      44.023  28.009  85.398  1.00  0.00           H  
ATOM     49  HB2 SER A   3      45.887  27.124  83.147  1.00  0.00           H  
ATOM     50  HB3 SER A   3      46.424  27.949  84.628  1.00  0.00           H  
ATOM     51  HG  SER A   3      44.798  25.758  85.063  1.00  0.00           H  
ATOM     52  N   HIS A   4      44.720  30.337  84.500  1.00  0.00           N  
ATOM     53  CA  HIS A   4      44.763  31.713  84.034  1.00  0.00           C  
ATOM     54  C   HIS A   4      45.709  31.890  82.846  1.00  0.00           C  
ATOM     55  O   HIS A   4      46.747  31.224  82.759  1.00  0.00           O  
ATOM     56  CB  HIS A   4      45.113  32.662  85.191  1.00  0.00           C  
ATOM     57  CG  HIS A   4      46.407  32.441  85.943  1.00  0.00           C  
ATOM     58  ND1 HIS A   4      46.853  33.252  86.962  1.00  0.00           N  
ATOM     59  CD2 HIS A   4      47.323  31.428  85.799  1.00  0.00           C  
ATOM     60  CE1 HIS A   4      47.997  32.735  87.428  1.00  0.00           C  
ATOM     61  NE2 HIS A   4      48.330  31.624  86.747  1.00  0.00           N  
ATOM     62  H   HIS A   4      44.908  30.170  85.481  1.00  0.00           H  
ATOM     63  HA  HIS A   4      43.760  31.961  83.691  1.00  0.00           H  
ATOM     64  HB2 HIS A   4      45.126  33.680  84.803  1.00  0.00           H  
ATOM     65  HB3 HIS A   4      44.301  32.605  85.912  1.00  0.00           H  
ATOM     66  HD1 HIS A   4      46.413  34.093  87.322  1.00  0.00           H  
ATOM     67  HD2 HIS A   4      47.288  30.608  85.097  1.00  0.00           H  
ATOM     68  HE1 HIS A   4      48.563  33.166  88.240  1.00  0.00           H  
ATOM     69  N   GLN A   5      45.362  32.798  81.937  1.00  0.00           N  
ATOM     70  CA  GLN A   5      46.287  33.350  80.962  1.00  0.00           C  
ATOM     71  C   GLN A   5      47.148  34.342  81.750  1.00  0.00           C  
ATOM     72  O   GLN A   5      48.363  34.164  81.869  1.00  0.00           O  
ATOM     73  CB  GLN A   5      45.524  34.018  79.794  1.00  0.00           C  
ATOM     74  CG  GLN A   5      46.234  33.832  78.441  1.00  0.00           C  
ATOM     75  CD  GLN A   5      45.761  32.580  77.698  1.00  0.00           C  
ATOM     76  OE1 GLN A   5      46.108  31.454  78.049  1.00  0.00           O  
ATOM     77  NE2 GLN A   5      44.971  32.743  76.649  1.00  0.00           N  
ATOM     78  H   GLN A   5      44.490  33.295  82.085  1.00  0.00           H  
ATOM     79  HA  GLN A   5      46.920  32.546  80.578  1.00  0.00           H  
ATOM     80  HB2 GLN A   5      44.515  33.602  79.714  1.00  0.00           H  
ATOM     81  HB3 GLN A   5      45.429  35.090  79.982  1.00  0.00           H  
ATOM     82  HG2 GLN A   5      46.009  34.702  77.824  1.00  0.00           H  
ATOM     83  HG3 GLN A   5      47.318  33.791  78.578  1.00  0.00           H  
ATOM     84 HE21 GLN A   5      44.784  33.691  76.307  1.00  0.00           H  
ATOM     85 HE22 GLN A   5      44.619  31.975  76.107  1.00  0.00           H  
ATOM     86  N   GLY A   6      46.502  35.319  82.392  1.00  0.00           N  
ATOM     87  CA  GLY A   6      47.162  36.433  83.045  1.00  0.00           C  
ATOM     88  C   GLY A   6      47.471  37.476  81.985  1.00  0.00           C  
ATOM     89  O   GLY A   6      48.637  37.778  81.723  1.00  0.00           O  
ATOM     90  H   GLY A   6      45.506  35.453  82.216  1.00  0.00           H  
ATOM     91  HA2 GLY A   6      46.496  36.869  83.793  1.00  0.00           H  
ATOM     92  HA3 GLY A   6      48.084  36.117  83.527  1.00  0.00           H  
ATOM     93  N   TYR A   7      46.421  37.973  81.338  1.00  0.00           N  
ATOM     94  CA  TYR A   7      46.456  39.127  80.462  1.00  0.00           C  
ATOM     95  C   TYR A   7      45.209  39.955  80.803  1.00  0.00           C  
ATOM     96  O   TYR A   7      44.854  40.062  81.978  1.00  0.00           O  
ATOM     97  CB  TYR A   7      46.598  38.668  78.997  1.00  0.00           C  
ATOM     98  CG  TYR A   7      48.018  38.450  78.518  1.00  0.00           C  
ATOM     99  CD1 TYR A   7      48.853  39.567  78.322  1.00  0.00           C  
ATOM    100  CD2 TYR A   7      48.480  37.163  78.183  1.00  0.00           C  
ATOM    101  CE1 TYR A   7      50.134  39.402  77.773  1.00  0.00           C  
ATOM    102  CE2 TYR A   7      49.767  36.988  77.642  1.00  0.00           C  
ATOM    103  CZ  TYR A   7      50.595  38.114  77.423  1.00  0.00           C  
ATOM    104  OH  TYR A   7      51.820  37.982  76.850  1.00  0.00           O  
ATOM    105  H   TYR A   7      45.482  37.670  81.598  1.00  0.00           H  
ATOM    106  HA  TYR A   7      47.321  39.737  80.715  1.00  0.00           H  
ATOM    107  HB2 TYR A   7      46.013  37.763  78.840  1.00  0.00           H  
ATOM    108  HB3 TYR A   7      46.203  39.423  78.326  1.00  0.00           H  
ATOM    109  HD1 TYR A   7      48.514  40.559  78.593  1.00  0.00           H  
ATOM    110  HD2 TYR A   7      47.850  36.302  78.340  1.00  0.00           H  
ATOM    111  HE1 TYR A   7      50.769  40.258  77.604  1.00  0.00           H  
ATOM    112  HE2 TYR A   7      50.114  35.995  77.391  1.00  0.00           H  
ATOM    113  HH  TYR A   7      51.999  37.054  76.602  1.00  0.00           H  
ATOM    114  N   SER A   8      44.589  40.590  79.815  1.00  0.00           N  
ATOM    115  CA  SER A   8      43.422  41.433  79.955  1.00  0.00           C  
ATOM    116  C   SER A   8      42.510  41.210  78.759  1.00  0.00           C  
ATOM    117  O   SER A   8      42.308  42.098  77.921  1.00  0.00           O  
ATOM    118  CB  SER A   8      43.903  42.863  80.102  1.00  0.00           C  
ATOM    119  OG  SER A   8      44.371  43.172  81.397  1.00  0.00           O  
ATOM    120  H   SER A   8      44.928  40.460  78.876  1.00  0.00           H  
ATOM    121  HA  SER A   8      42.856  41.164  80.821  1.00  0.00           H  
ATOM    122  HB2 SER A   8      44.716  42.989  79.411  1.00  0.00           H  
ATOM    123  HB3 SER A   8      43.105  43.533  79.821  1.00  0.00           H  
ATOM    124  HG  SER A   8      43.628  43.095  82.020  1.00  0.00           H  
ATOM    125  N   THR A   9      42.060  39.970  78.608  1.00  0.00           N  
ATOM    126  CA  THR A   9      41.527  39.488  77.342  1.00  0.00           C  
ATOM    127  C   THR A   9      40.743  38.170  77.504  1.00  0.00           C  
ATOM    128  O   THR A   9      39.897  37.826  76.676  1.00  0.00           O  
ATOM    129  CB  THR A   9      42.730  39.400  76.370  1.00  0.00           C  
ATOM    130  OG1 THR A   9      42.366  39.095  75.047  1.00  0.00           O  
ATOM    131  CG2 THR A   9      43.813  38.431  76.850  1.00  0.00           C  
ATOM    132  H   THR A   9      42.360  39.273  79.289  1.00  0.00           H  
ATOM    133  HA  THR A   9      40.843  40.245  76.973  1.00  0.00           H  
ATOM    134  HB  THR A   9      43.188  40.387  76.345  1.00  0.00           H  
ATOM    135  HG1 THR A   9      43.173  39.089  74.509  1.00  0.00           H  
ATOM    136 HG21 THR A   9      44.093  38.687  77.872  1.00  0.00           H  
ATOM    137 HG22 THR A   9      43.444  37.407  76.821  1.00  0.00           H  
ATOM    138 HG23 THR A   9      44.699  38.521  76.218  1.00  0.00           H  
ATOM    139  N   GLU A  10      40.960  37.439  78.598  1.00  0.00           N  
ATOM    140  CA  GLU A  10      40.186  36.301  79.060  1.00  0.00           C  
ATOM    141  C   GLU A  10      38.858  36.815  79.621  1.00  0.00           C  
ATOM    142  O   GLU A  10      38.513  37.998  79.465  1.00  0.00           O  
ATOM    143  CB  GLU A  10      41.014  35.529  80.114  1.00  0.00           C  
ATOM    144  CG  GLU A  10      41.436  36.403  81.311  1.00  0.00           C  
ATOM    145  CD  GLU A  10      42.868  36.931  81.141  1.00  0.00           C  
ATOM    146  OE1 GLU A  10      43.021  37.920  80.392  1.00  0.00           O  
ATOM    147  OE2 GLU A  10      43.797  36.310  81.715  1.00  0.00           O  
ATOM    148  H   GLU A  10      41.540  37.824  79.334  1.00  0.00           H  
ATOM    149  HA  GLU A  10      39.976  35.629  78.233  1.00  0.00           H  
ATOM    150  HB2 GLU A  10      40.418  34.694  80.490  1.00  0.00           H  
ATOM    151  HB3 GLU A  10      41.899  35.101  79.634  1.00  0.00           H  
ATOM    152  HG2 GLU A  10      40.742  37.240  81.426  1.00  0.00           H  
ATOM    153  HG3 GLU A  10      41.364  35.799  82.213  1.00  0.00           H  
ATOM    154  N   ALA A  11      38.142  35.952  80.344  1.00  0.00           N  
ATOM    155  CA  ALA A  11      37.149  36.425  81.283  1.00  0.00           C  
ATOM    156  C   ALA A  11      37.423  35.821  82.654  1.00  0.00           C  
ATOM    157  O   ALA A  11      37.479  34.605  82.810  1.00  0.00           O  
ATOM    158  CB  ALA A  11      35.749  36.102  80.770  1.00  0.00           C  
ATOM    159  H   ALA A  11      38.474  34.994  80.422  1.00  0.00           H  
ATOM    160  HA  ALA A  11      37.279  37.507  81.362  1.00  0.00           H  
ATOM    161  HB1 ALA A  11      35.618  35.030  80.683  1.00  0.00           H  
ATOM    162  HB2 ALA A  11      35.010  36.499  81.458  1.00  0.00           H  
ATOM    163  HB3 ALA A  11      35.605  36.547  79.792  1.00  0.00           H  
ATOM    164  N   GLU A  12      37.563  36.684  83.656  1.00  0.00           N  
ATOM    165  CA  GLU A  12      37.977  36.527  85.062  1.00  0.00           C  
ATOM    166  C   GLU A  12      37.046  35.688  85.952  1.00  0.00           C  
ATOM    167  O   GLU A  12      37.017  35.807  87.181  1.00  0.00           O  
ATOM    168  CB  GLU A  12      38.010  37.951  85.617  1.00  0.00           C  
ATOM    169  CG  GLU A  12      39.008  38.200  86.769  1.00  0.00           C  
ATOM    170  CD  GLU A  12      38.435  39.077  87.896  1.00  0.00           C  
ATOM    171  OE1 GLU A  12      37.440  39.813  87.668  1.00  0.00           O  
ATOM    172  OE2 GLU A  12      38.819  38.905  89.069  1.00  0.00           O  
ATOM    173  H   GLU A  12      37.474  37.652  83.411  1.00  0.00           H  
ATOM    174  HA  GLU A  12      38.973  36.094  85.092  1.00  0.00           H  
ATOM    175  HB2 GLU A  12      38.264  38.592  84.786  1.00  0.00           H  
ATOM    176  HB3 GLU A  12      36.995  38.219  85.905  1.00  0.00           H  
ATOM    177  HG2 GLU A  12      39.318  37.246  87.195  1.00  0.00           H  
ATOM    178  HG3 GLU A  12      39.893  38.677  86.352  1.00  0.00           H  
ATOM    179  N   PHE A  13      36.186  34.933  85.302  1.00  0.00           N  
ATOM    180  CA  PHE A  13      35.244  33.977  85.862  1.00  0.00           C  
ATOM    181  C   PHE A  13      35.676  32.572  85.425  1.00  0.00           C  
ATOM    182  O   PHE A  13      34.964  31.918  84.661  1.00  0.00           O  
ATOM    183  CB  PHE A  13      33.824  34.289  85.347  1.00  0.00           C  
ATOM    184  CG  PHE A  13      33.197  35.616  85.747  1.00  0.00           C  
ATOM    185  CD1 PHE A  13      32.994  35.937  87.103  1.00  0.00           C  
ATOM    186  CD2 PHE A  13      32.718  36.482  84.745  1.00  0.00           C  
ATOM    187  CE1 PHE A  13      32.265  37.088  87.445  1.00  0.00           C  
ATOM    188  CE2 PHE A  13      32.016  37.644  85.094  1.00  0.00           C  
ATOM    189  CZ  PHE A  13      31.779  37.940  86.442  1.00  0.00           C  
ATOM    190  H   PHE A  13      36.352  34.970  84.307  1.00  0.00           H  
ATOM    191  HA  PHE A  13      35.265  34.010  86.953  1.00  0.00           H  
ATOM    192  HB2 PHE A  13      33.881  34.256  84.263  1.00  0.00           H  
ATOM    193  HB3 PHE A  13      33.159  33.473  85.648  1.00  0.00           H  
ATOM    194  HD1 PHE A  13      33.346  35.269  87.880  1.00  0.00           H  
ATOM    195  HD2 PHE A  13      32.851  36.233  83.702  1.00  0.00           H  
ATOM    196  HE1 PHE A  13      32.077  37.306  88.485  1.00  0.00           H  
ATOM    197  HE2 PHE A  13      31.643  38.297  84.323  1.00  0.00           H  
ATOM    198  HZ  PHE A  13      31.227  38.823  86.703  1.00  0.00           H  
ATOM    199  N   GLU A  14      36.867  32.130  85.820  1.00  0.00           N  
ATOM    200  CA  GLU A  14      37.358  30.813  85.431  1.00  0.00           C  
ATOM    201  C   GLU A  14      37.206  29.870  86.610  1.00  0.00           C  
ATOM    202  O   GLU A  14      36.316  29.031  86.594  1.00  0.00           O  
ATOM    203  CB  GLU A  14      38.797  30.892  84.918  1.00  0.00           C  
ATOM    204  CG  GLU A  14      38.942  31.906  83.775  1.00  0.00           C  
ATOM    205  CD  GLU A  14      40.276  31.758  83.050  1.00  0.00           C  
ATOM    206  OE1 GLU A  14      41.302  31.564  83.743  1.00  0.00           O  
ATOM    207  OE2 GLU A  14      40.266  31.794  81.797  1.00  0.00           O  
ATOM    208  H   GLU A  14      37.492  32.721  86.362  1.00  0.00           H  
ATOM    209  HA  GLU A  14      36.755  30.413  84.612  1.00  0.00           H  
ATOM    210  HB2 GLU A  14      39.464  31.181  85.728  1.00  0.00           H  
ATOM    211  HB3 GLU A  14      39.083  29.905  84.558  1.00  0.00           H  
ATOM    212  HG2 GLU A  14      38.123  31.762  83.064  1.00  0.00           H  
ATOM    213  HG3 GLU A  14      38.884  32.917  84.183  1.00  0.00           H  
ATOM    214  N   GLU A  15      38.038  30.019  87.642  1.00  0.00           N  
ATOM    215  CA  GLU A  15      37.984  29.206  88.853  1.00  0.00           C  
ATOM    216  C   GLU A  15      38.558  30.035  90.023  1.00  0.00           C  
ATOM    217  O   GLU A  15      39.650  29.734  90.505  1.00  0.00           O  
ATOM    218  CB  GLU A  15      38.718  27.882  88.559  1.00  0.00           C  
ATOM    219  CG  GLU A  15      38.598  26.822  89.657  1.00  0.00           C  
ATOM    220  CD  GLU A  15      39.026  25.462  89.112  1.00  0.00           C  
ATOM    221  OE1 GLU A  15      40.217  25.274  88.797  1.00  0.00           O  
ATOM    222  OE2 GLU A  15      38.170  24.561  88.952  1.00  0.00           O  
ATOM    223  H   GLU A  15      38.722  30.764  87.611  1.00  0.00           H  
ATOM    224  HA  GLU A  15      36.942  28.971  89.083  1.00  0.00           H  
ATOM    225  HB2 GLU A  15      38.286  27.461  87.651  1.00  0.00           H  
ATOM    226  HB3 GLU A  15      39.767  28.084  88.350  1.00  0.00           H  
ATOM    227  HG2 GLU A  15      39.228  27.090  90.504  1.00  0.00           H  
ATOM    228  HG3 GLU A  15      37.565  26.766  89.993  1.00  0.00           H  
ATOM    229  N   PRO A  16      37.905  31.150  90.429  1.00  0.00           N  
ATOM    230  CA  PRO A  16      38.345  31.954  91.568  1.00  0.00           C  
ATOM    231  C   PRO A  16      37.914  31.321  92.894  1.00  0.00           C  
ATOM    232  O   PRO A  16      38.739  30.801  93.639  1.00  0.00           O  
ATOM    233  CB  PRO A  16      37.735  33.340  91.353  1.00  0.00           C  
ATOM    234  CG  PRO A  16      36.479  33.085  90.516  1.00  0.00           C  
ATOM    235  CD  PRO A  16      36.831  31.832  89.713  1.00  0.00           C  
ATOM    236  HA  PRO A  16      39.432  32.043  91.561  1.00  0.00           H  
ATOM    237  HB2 PRO A  16      37.490  33.825  92.301  1.00  0.00           H  
ATOM    238  HB3 PRO A  16      38.433  33.943  90.771  1.00  0.00           H  
ATOM    239  HG2 PRO A  16      35.627  32.881  91.161  1.00  0.00           H  
ATOM    240  HG3 PRO A  16      36.255  33.925  89.857  1.00  0.00           H  
ATOM    241  HD2 PRO A  16      35.960  31.185  89.599  1.00  0.00           H  
ATOM    242  HD3 PRO A  16      37.186  32.150  88.731  1.00  0.00           H  
ATOM    243  N   ARG A  17      36.617  31.403  93.214  1.00  0.00           N  
ATOM    244  CA  ARG A  17      35.942  30.692  94.301  1.00  0.00           C  
ATOM    245  C   ARG A  17      34.560  30.187  93.857  1.00  0.00           C  
ATOM    246  O   ARG A  17      33.777  29.715  94.677  1.00  0.00           O  
ATOM    247  CB  ARG A  17      35.858  31.566  95.573  1.00  0.00           C  
ATOM    248  CG  ARG A  17      36.872  31.120  96.643  1.00  0.00           C  
ATOM    249  CD  ARG A  17      38.143  31.966  96.574  1.00  0.00           C  
ATOM    250  NE  ARG A  17      39.356  31.213  96.929  1.00  0.00           N  
ATOM    251  CZ  ARG A  17      40.498  31.746  97.374  1.00  0.00           C  
ATOM    252  NH1 ARG A  17      40.536  33.026  97.743  1.00  0.00           N  
ATOM    253  NH2 ARG A  17      41.596  31.002  97.446  1.00  0.00           N  
ATOM    254  H   ARG A  17      36.029  31.922  92.585  1.00  0.00           H  
ATOM    255  HA  ARG A  17      36.540  29.808  94.514  1.00  0.00           H  
ATOM    256  HB2 ARG A  17      35.994  32.621  95.327  1.00  0.00           H  
ATOM    257  HB3 ARG A  17      34.864  31.487  96.005  1.00  0.00           H  
ATOM    258  HG2 ARG A  17      36.428  31.258  97.626  1.00  0.00           H  
ATOM    259  HG3 ARG A  17      37.105  30.059  96.534  1.00  0.00           H  
ATOM    260  HD2 ARG A  17      38.272  32.335  95.558  1.00  0.00           H  
ATOM    261  HD3 ARG A  17      38.007  32.823  97.235  1.00  0.00           H  
ATOM    262  HE  ARG A  17      39.358  30.242  96.609  1.00  0.00           H  
ATOM    263 HH11 ARG A  17      39.690  33.595  97.751  1.00  0.00           H  
ATOM    264 HH12 ARG A  17      41.388  33.499  98.035  1.00  0.00           H  
ATOM    265 HH21 ARG A  17      41.571  30.026  97.140  1.00  0.00           H  
ATOM    266 HH22 ARG A  17      42.510  31.374  97.646  1.00  0.00           H  
ATOM    267  N   VAL A  18      34.222  30.342  92.578  1.00  0.00           N  
ATOM    268  CA  VAL A  18      32.882  30.139  92.042  1.00  0.00           C  
ATOM    269  C   VAL A  18      32.673  28.643  91.817  1.00  0.00           C  
ATOM    270  O   VAL A  18      31.952  27.981  92.567  1.00  0.00           O  
ATOM    271  CB  VAL A  18      32.752  31.004  90.774  1.00  0.00           C  
ATOM    272  CG1 VAL A  18      31.587  30.608  89.873  1.00  0.00           C  
ATOM    273  CG2 VAL A  18      32.600  32.486  91.154  1.00  0.00           C  
ATOM    274  H   VAL A  18      34.975  30.517  91.931  1.00  0.00           H  
ATOM    275  HA  VAL A  18      32.149  30.463  92.775  1.00  0.00           H  
ATOM    276  HB  VAL A  18      33.669  30.892  90.188  1.00  0.00           H  
ATOM    277 HG11 VAL A  18      30.630  30.761  90.374  1.00  0.00           H  
ATOM    278 HG12 VAL A  18      31.655  31.207  88.975  1.00  0.00           H  
ATOM    279 HG13 VAL A  18      31.660  29.568  89.560  1.00  0.00           H  
ATOM    280 HG21 VAL A  18      33.416  32.806  91.798  1.00  0.00           H  
ATOM    281 HG22 VAL A  18      32.611  33.100  90.255  1.00  0.00           H  
ATOM    282 HG23 VAL A  18      31.662  32.644  91.686  1.00  0.00           H  
ATOM    283  N   ILE A  19      33.363  28.117  90.802  1.00  0.00           N  
ATOM    284  CA  ILE A  19      33.382  26.700  90.483  1.00  0.00           C  
ATOM    285  C   ILE A  19      33.838  25.910  91.720  1.00  0.00           C  
ATOM    286  O   ILE A  19      33.442  24.769  91.898  1.00  0.00           O  
ATOM    287  CB  ILE A  19      34.307  26.467  89.267  1.00  0.00           C  
ATOM    288  CG1 ILE A  19      34.055  27.412  88.068  1.00  0.00           C  
ATOM    289  CG2 ILE A  19      34.280  25.004  88.806  1.00  0.00           C  
ATOM    290  CD1 ILE A  19      32.634  27.444  87.497  1.00  0.00           C  
ATOM    291  H   ILE A  19      33.882  28.719  90.181  1.00  0.00           H  
ATOM    292  HA  ILE A  19      32.369  26.383  90.235  1.00  0.00           H  
ATOM    293  HB  ILE A  19      35.317  26.690  89.603  1.00  0.00           H  
ATOM    294 HG12 ILE A  19      34.321  28.430  88.357  1.00  0.00           H  
ATOM    295 HG13 ILE A  19      34.727  27.124  87.260  1.00  0.00           H  
ATOM    296 HG21 ILE A  19      34.896  24.878  87.920  1.00  0.00           H  
ATOM    297 HG22 ILE A  19      34.676  24.357  89.587  1.00  0.00           H  
ATOM    298 HG23 ILE A  19      33.257  24.704  88.587  1.00  0.00           H  
ATOM    299 HD11 ILE A  19      32.365  26.473  87.082  1.00  0.00           H  
ATOM    300 HD12 ILE A  19      31.918  27.715  88.268  1.00  0.00           H  
ATOM    301 HD13 ILE A  19      32.596  28.195  86.705  1.00  0.00           H  
ATOM    302  N   ASP A  20      34.614  26.534  92.606  1.00  0.00           N  
ATOM    303  CA  ASP A  20      35.142  26.003  93.847  1.00  0.00           C  
ATOM    304  C   ASP A  20      33.997  25.809  94.830  1.00  0.00           C  
ATOM    305  O   ASP A  20      33.836  24.715  95.371  1.00  0.00           O  
ATOM    306  CB  ASP A  20      36.182  26.962  94.437  1.00  0.00           C  
ATOM    307  CG  ASP A  20      37.188  27.462  93.403  1.00  0.00           C  
ATOM    308  OD1 ASP A  20      36.787  28.295  92.560  1.00  0.00           O  
ATOM    309  OD2 ASP A  20      38.371  27.055  93.508  1.00  0.00           O  
ATOM    310  H   ASP A  20      34.928  27.471  92.394  1.00  0.00           H  
ATOM    311  HA  ASP A  20      35.629  25.049  93.647  1.00  0.00           H  
ATOM    312  HB2 ASP A  20      35.682  27.818  94.884  1.00  0.00           H  
ATOM    313  HB3 ASP A  20      36.711  26.454  95.239  1.00  0.00           H  
ATOM    314  N   LEU A  21      33.156  26.839  95.037  1.00  0.00           N  
ATOM    315  CA  LEU A  21      31.952  26.685  95.851  1.00  0.00           C  
ATOM    316  C   LEU A  21      31.084  25.547  95.304  1.00  0.00           C  
ATOM    317  O   LEU A  21      30.549  24.758  96.085  1.00  0.00           O  
ATOM    318  CB  LEU A  21      31.199  28.018  96.072  1.00  0.00           C  
ATOM    319  CG  LEU A  21      29.972  28.289  95.173  1.00  0.00           C  
ATOM    320  CD1 LEU A  21      28.676  27.822  95.851  1.00  0.00           C  
ATOM    321  CD2 LEU A  21      29.814  29.763  94.809  1.00  0.00           C  
ATOM    322  H   LEU A  21      33.294  27.714  94.538  1.00  0.00           H  
ATOM    323  HA  LEU A  21      32.315  26.381  96.823  1.00  0.00           H  
ATOM    324  HB2 LEU A  21      30.874  28.044  97.113  1.00  0.00           H  
ATOM    325  HB3 LEU A  21      31.914  28.827  95.965  1.00  0.00           H  
ATOM    326  HG  LEU A  21      30.095  27.774  94.235  1.00  0.00           H  
ATOM    327 HD11 LEU A  21      28.527  28.357  96.787  1.00  0.00           H  
ATOM    328 HD12 LEU A  21      27.822  28.012  95.203  1.00  0.00           H  
ATOM    329 HD13 LEU A  21      28.725  26.756  96.066  1.00  0.00           H  
ATOM    330 HD21 LEU A  21      29.041  29.877  94.051  1.00  0.00           H  
ATOM    331 HD22 LEU A  21      29.537  30.332  95.689  1.00  0.00           H  
ATOM    332 HD23 LEU A  21      30.753  30.141  94.409  1.00  0.00           H  
ATOM    333  N   TRP A  22      30.989  25.435  93.975  1.00  0.00           N  
ATOM    334  CA  TRP A  22      30.268  24.342  93.334  1.00  0.00           C  
ATOM    335  C   TRP A  22      31.042  23.017  93.418  1.00  0.00           C  
ATOM    336  O   TRP A  22      30.460  21.952  93.245  1.00  0.00           O  
ATOM    337  CB  TRP A  22      29.927  24.724  91.892  1.00  0.00           C  
ATOM    338  CG  TRP A  22      29.186  26.014  91.691  1.00  0.00           C  
ATOM    339  CD1 TRP A  22      28.459  26.684  92.611  1.00  0.00           C  
ATOM    340  CD2 TRP A  22      29.025  26.772  90.463  1.00  0.00           C  
ATOM    341  NE1 TRP A  22      27.955  27.848  92.070  1.00  0.00           N  
ATOM    342  CE2 TRP A  22      28.283  27.959  90.738  1.00  0.00           C  
ATOM    343  CE3 TRP A  22      29.397  26.545  89.129  1.00  0.00           C  
ATOM    344  CZ2 TRP A  22      27.975  28.903  89.747  1.00  0.00           C  
ATOM    345  CZ3 TRP A  22      28.992  27.420  88.115  1.00  0.00           C  
ATOM    346  CH2 TRP A  22      28.285  28.590  88.415  1.00  0.00           C  
ATOM    347  H   TRP A  22      31.422  26.147  93.384  1.00  0.00           H  
ATOM    348  HA  TRP A  22      29.322  24.199  93.853  1.00  0.00           H  
ATOM    349  HB2 TRP A  22      30.850  24.766  91.314  1.00  0.00           H  
ATOM    350  HB3 TRP A  22      29.319  23.928  91.470  1.00  0.00           H  
ATOM    351  HD1 TRP A  22      28.317  26.350  93.628  1.00  0.00           H  
ATOM    352  HE1 TRP A  22      27.356  28.472  92.586  1.00  0.00           H  
ATOM    353  HE3 TRP A  22      29.940  25.652  88.866  1.00  0.00           H  
ATOM    354  HZ2 TRP A  22      27.429  29.807  89.977  1.00  0.00           H  
ATOM    355  HZ3 TRP A  22      29.202  27.163  87.096  1.00  0.00           H  
ATOM    356  HH2 TRP A  22      27.948  29.215  87.606  1.00  0.00           H  
ATOM    357  N   ASP A  23      32.342  23.043  93.694  1.00  0.00           N  
ATOM    358  CA  ASP A  23      33.188  21.873  93.892  1.00  0.00           C  
ATOM    359  C   ASP A  23      32.857  21.230  95.223  1.00  0.00           C  
ATOM    360  O   ASP A  23      32.620  20.022  95.281  1.00  0.00           O  
ATOM    361  CB  ASP A  23      34.677  22.233  93.861  1.00  0.00           C  
ATOM    362  CG  ASP A  23      35.515  21.007  93.526  1.00  0.00           C  
ATOM    363  OD1 ASP A  23      35.444  20.503  92.377  1.00  0.00           O  
ATOM    364  OD2 ASP A  23      36.245  20.538  94.424  1.00  0.00           O  
ATOM    365  H   ASP A  23      32.817  23.941  93.686  1.00  0.00           H  
ATOM    366  HA  ASP A  23      32.994  21.162  93.096  1.00  0.00           H  
ATOM    367  HB2 ASP A  23      34.857  23.026  93.147  1.00  0.00           H  
ATOM    368  HB3 ASP A  23      34.994  22.610  94.831  1.00  0.00           H  
ATOM    369  N   LEU A  24      32.782  22.031  96.299  1.00  0.00           N  
ATOM    370  CA  LEU A  24      32.325  21.491  97.573  1.00  0.00           C  
ATOM    371  C   LEU A  24      30.829  21.222  97.495  1.00  0.00           C  
ATOM    372  O   LEU A  24      30.357  20.339  98.199  1.00  0.00           O  
ATOM    373  CB  LEU A  24      32.644  22.356  98.805  1.00  0.00           C  
ATOM    374  CG  LEU A  24      33.959  23.150  98.754  1.00  0.00           C  
ATOM    375  CD1 LEU A  24      33.622  24.555  98.279  1.00  0.00           C  
ATOM    376  CD2 LEU A  24      34.687  23.244 100.097  1.00  0.00           C  
ATOM    377  H   LEU A  24      32.905  23.038  96.205  1.00  0.00           H  
ATOM    378  HA  LEU A  24      32.826  20.534  97.726  1.00  0.00           H  
ATOM    379  HB2 LEU A  24      31.807  23.026  99.019  1.00  0.00           H  
ATOM    380  HB3 LEU A  24      32.698  21.660  99.628  1.00  0.00           H  
ATOM    381  HG  LEU A  24      34.640  22.682  98.044  1.00  0.00           H  
ATOM    382 HD11 LEU A  24      33.241  25.166  99.096  1.00  0.00           H  
ATOM    383 HD12 LEU A  24      34.504  25.002  97.826  1.00  0.00           H  
ATOM    384 HD13 LEU A  24      32.849  24.479  97.518  1.00  0.00           H  
ATOM    385 HD21 LEU A  24      35.016  22.254 100.403  1.00  0.00           H  
ATOM    386 HD22 LEU A  24      35.567  23.882 100.000  1.00  0.00           H  
ATOM    387 HD23 LEU A  24      34.028  23.654 100.860  1.00  0.00           H  
ATOM    388  N   ALA A  25      30.071  21.922  96.639  1.00  0.00           N  
ATOM    389  CA  ALA A  25      28.661  21.605  96.458  1.00  0.00           C  
ATOM    390  C   ALA A  25      28.427  20.182  95.928  1.00  0.00           C  
ATOM    391  O   ALA A  25      27.306  19.701  96.002  1.00  0.00           O  
ATOM    392  CB  ALA A  25      27.922  22.637  95.610  1.00  0.00           C  
ATOM    393  H   ALA A  25      30.474  22.697  96.127  1.00  0.00           H  
ATOM    394  HA  ALA A  25      28.220  21.677  97.441  1.00  0.00           H  
ATOM    395  HB1 ALA A  25      26.847  22.463  95.722  1.00  0.00           H  
ATOM    396  HB2 ALA A  25      28.160  23.644  95.947  1.00  0.00           H  
ATOM    397  HB3 ALA A  25      28.187  22.504  94.566  1.00  0.00           H  
ATOM    398  N   GLN A  26      29.451  19.472  95.441  1.00  0.00           N  
ATOM    399  CA  GLN A  26      29.282  18.066  95.099  1.00  0.00           C  
ATOM    400  C   GLN A  26      29.030  17.201  96.357  1.00  0.00           C  
ATOM    401  O   GLN A  26      28.658  16.036  96.216  1.00  0.00           O  
ATOM    402  CB  GLN A  26      30.488  17.582  94.272  1.00  0.00           C  
ATOM    403  CG  GLN A  26      30.194  16.377  93.362  1.00  0.00           C  
ATOM    404  CD  GLN A  26      31.440  15.555  93.032  1.00  0.00           C  
ATOM    405  OE1 GLN A  26      31.420  14.326  93.090  1.00  0.00           O  
ATOM    406  NE2 GLN A  26      32.559  16.169  92.693  1.00  0.00           N  
ATOM    407  H   GLN A  26      30.376  19.876  95.387  1.00  0.00           H  
ATOM    408  HA  GLN A  26      28.394  18.001  94.473  1.00  0.00           H  
ATOM    409  HB2 GLN A  26      30.853  18.395  93.640  1.00  0.00           H  
ATOM    410  HB3 GLN A  26      31.280  17.311  94.957  1.00  0.00           H  
ATOM    411  HG2 GLN A  26      29.473  15.716  93.842  1.00  0.00           H  
ATOM    412  HG3 GLN A  26      29.755  16.731  92.433  1.00  0.00           H  
ATOM    413 HE21 GLN A  26      32.601  17.188  92.621  1.00  0.00           H  
ATOM    414 HE22 GLN A  26      33.378  15.633  92.477  1.00  0.00           H  
ATOM    415  N   SER A  27      29.232  17.707  97.585  1.00  0.00           N  
ATOM    416  CA  SER A  27      29.034  16.910  98.795  1.00  0.00           C  
ATOM    417  C   SER A  27      28.717  17.721 100.068  1.00  0.00           C  
ATOM    418  O   SER A  27      28.511  17.119 101.129  1.00  0.00           O  
ATOM    419  CB  SER A  27      30.290  16.032  98.964  1.00  0.00           C  
ATOM    420  OG  SER A  27      30.102  14.936  99.847  1.00  0.00           O  
ATOM    421  H   SER A  27      29.712  18.597  97.656  1.00  0.00           H  
ATOM    422  HA  SER A  27      28.174  16.272  98.610  1.00  0.00           H  
ATOM    423  HB2 SER A  27      30.582  15.629  97.994  1.00  0.00           H  
ATOM    424  HB3 SER A  27      31.105  16.658  99.324  1.00  0.00           H  
ATOM    425  HG  SER A  27      29.177  14.636  99.705  1.00  0.00           H  
ATOM    426  N   ALA A  28      28.711  19.060 100.014  1.00  0.00           N  
ATOM    427  CA  ALA A  28      28.694  19.956 101.169  1.00  0.00           C  
ATOM    428  C   ALA A  28      27.551  19.638 102.141  1.00  0.00           C  
ATOM    429  O   ALA A  28      27.785  19.040 103.199  1.00  0.00           O  
ATOM    430  CB  ALA A  28      28.666  21.426 100.709  1.00  0.00           C  
ATOM    431  H   ALA A  28      28.964  19.480  99.130  1.00  0.00           H  
ATOM    432  HA  ALA A  28      29.629  19.804 101.711  1.00  0.00           H  
ATOM    433  HB1 ALA A  28      28.553  22.082 101.574  1.00  0.00           H  
ATOM    434  HB2 ALA A  28      29.600  21.682 100.207  1.00  0.00           H  
ATOM    435  HB3 ALA A  28      27.832  21.595 100.024  1.00  0.00           H  
ATOM    436  N   ASN A  29      26.335  20.102 101.841  1.00  0.00           N  
ATOM    437  CA  ASN A  29      25.153  19.849 102.655  1.00  0.00           C  
ATOM    438  C   ASN A  29      23.874  20.085 101.842  1.00  0.00           C  
ATOM    439  O   ASN A  29      22.964  20.798 102.283  1.00  0.00           O  
ATOM    440  CB  ASN A  29      25.190  20.711 103.932  1.00  0.00           C  
ATOM    441  CG  ASN A  29      24.374  20.077 105.036  1.00  0.00           C  
ATOM    442  OD1 ASN A  29      23.257  19.601 104.839  1.00  0.00           O  
ATOM    443  ND2 ASN A  29      24.912  20.058 106.236  1.00  0.00           N  
ATOM    444  H   ASN A  29      26.213  20.638 100.991  1.00  0.00           H  
ATOM    445  HA  ASN A  29      25.176  18.798 102.953  1.00  0.00           H  
ATOM    446  HB2 ASN A  29      26.217  20.821 104.275  1.00  0.00           H  
ATOM    447  HB3 ASN A  29      24.793  21.706 103.763  1.00  0.00           H  
ATOM    448 HD21 ASN A  29      25.839  20.418 106.410  1.00  0.00           H  
ATOM    449 HD22 ASN A  29      24.388  19.575 106.946  1.00  0.00           H  
ATOM    450  N   LEU A  30      23.806  19.539 100.624  1.00  0.00           N  
ATOM    451  CA  LEU A  30      22.652  19.724  99.747  1.00  0.00           C  
ATOM    452  C   LEU A  30      21.721  18.531 100.001  1.00  0.00           C  
ATOM    453  O   LEU A  30      21.434  18.253 101.174  1.00  0.00           O  
ATOM    454  CB  LEU A  30      23.029  20.015  98.277  1.00  0.00           C  
ATOM    455  CG  LEU A  30      23.935  21.268  98.158  1.00  0.00           C  
ATOM    456  CD1 LEU A  30      25.395  20.868  98.259  1.00  0.00           C  
ATOM    457  CD2 LEU A  30      23.740  22.076  96.874  1.00  0.00           C  
ATOM    458  H   LEU A  30      24.543  18.915 100.296  1.00  0.00           H  
ATOM    459  HA  LEU A  30      22.150  20.635 100.061  1.00  0.00           H  
ATOM    460  HB2 LEU A  30      23.503  19.147  97.812  1.00  0.00           H  
ATOM    461  HB3 LEU A  30      22.104  20.209  97.730  1.00  0.00           H  
ATOM    462  HG  LEU A  30      23.745  21.947  98.985  1.00  0.00           H  
ATOM    463 HD11 LEU A  30      26.034  21.717  98.039  1.00  0.00           H  
ATOM    464 HD12 LEU A  30      25.603  20.516  99.257  1.00  0.00           H  
ATOM    465 HD13 LEU A  30      25.560  20.060  97.554  1.00  0.00           H  
ATOM    466 HD21 LEU A  30      24.282  23.014  96.942  1.00  0.00           H  
ATOM    467 HD22 LEU A  30      24.126  21.514  96.022  1.00  0.00           H  
ATOM    468 HD23 LEU A  30      22.683  22.279  96.709  1.00  0.00           H  
ATOM    469  N   THR A  31      21.210  17.866  98.967  1.00  0.00           N  
ATOM    470  CA  THR A  31      20.438  16.626  99.083  1.00  0.00           C  
ATOM    471  C   THR A  31      20.699  15.766  97.846  1.00  0.00           C  
ATOM    472  O   THR A  31      21.172  16.288  96.846  1.00  0.00           O  
ATOM    473  CB  THR A  31      18.928  16.914  99.231  1.00  0.00           C  
ATOM    474  OG1 THR A  31      18.473  17.818  98.238  1.00  0.00           O  
ATOM    475  CG2 THR A  31      18.537  17.484 100.600  1.00  0.00           C  
ATOM    476  H   THR A  31      21.534  18.086  98.030  1.00  0.00           H  
ATOM    477  HA  THR A  31      20.785  16.072  99.955  1.00  0.00           H  
ATOM    478  HB  THR A  31      18.386  15.976  99.112  1.00  0.00           H  
ATOM    479  HG1 THR A  31      17.589  18.126  98.502  1.00  0.00           H  
ATOM    480 HG21 THR A  31      17.452  17.449 100.722  1.00  0.00           H  
ATOM    481 HG22 THR A  31      18.988  16.882 101.391  1.00  0.00           H  
ATOM    482 HG23 THR A  31      18.870  18.518 100.696  1.00  0.00           H  
ATOM    483  N   ASP A  32      20.344  14.479  97.860  1.00  0.00           N  
ATOM    484  CA  ASP A  32      20.622  13.526  96.774  1.00  0.00           C  
ATOM    485  C   ASP A  32      20.027  13.952  95.426  1.00  0.00           C  
ATOM    486  O   ASP A  32      20.610  13.705  94.369  1.00  0.00           O  
ATOM    487  CB  ASP A  32      20.020  12.151  97.116  1.00  0.00           C  
ATOM    488  CG  ASP A  32      20.887  11.244  97.982  1.00  0.00           C  
ATOM    489  OD1 ASP A  32      22.113  11.483  98.096  1.00  0.00           O  
ATOM    490  OD2 ASP A  32      20.341  10.212  98.442  1.00  0.00           O  
ATOM    491  H   ASP A  32      20.013  14.105  98.746  1.00  0.00           H  
ATOM    492  HA  ASP A  32      21.700  13.429  96.642  1.00  0.00           H  
ATOM    493  HB2 ASP A  32      19.051  12.295  97.599  1.00  0.00           H  
ATOM    494  HB3 ASP A  32      19.835  11.607  96.186  1.00  0.00           H  
ATOM    495  N   LYS A  33      18.817  14.513  95.454  1.00  0.00           N  
ATOM    496  CA  LYS A  33      18.043  14.883  94.268  1.00  0.00           C  
ATOM    497  C   LYS A  33      18.670  16.116  93.628  1.00  0.00           C  
ATOM    498  O   LYS A  33      19.026  16.085  92.442  1.00  0.00           O  
ATOM    499  CB  LYS A  33      16.557  15.080  94.641  1.00  0.00           C  
ATOM    500  CG  LYS A  33      15.596  14.411  93.643  1.00  0.00           C  
ATOM    501  CD  LYS A  33      15.411  15.196  92.336  1.00  0.00           C  
ATOM    502  CE  LYS A  33      14.645  14.310  91.343  1.00  0.00           C  
ATOM    503  NZ  LYS A  33      14.488  14.943  90.020  1.00  0.00           N  
ATOM    504  H   LYS A  33      18.437  14.688  96.365  1.00  0.00           H  
ATOM    505  HA  LYS A  33      18.118  14.064  93.560  1.00  0.00           H  
ATOM    506  HB2 LYS A  33      16.375  14.613  95.609  1.00  0.00           H  
ATOM    507  HB3 LYS A  33      16.311  16.139  94.741  1.00  0.00           H  
ATOM    508  HG2 LYS A  33      15.966  13.407  93.418  1.00  0.00           H  
ATOM    509  HG3 LYS A  33      14.618  14.310  94.116  1.00  0.00           H  
ATOM    510  HD2 LYS A  33      14.849  16.111  92.531  1.00  0.00           H  
ATOM    511  HD3 LYS A  33      16.375  15.475  91.918  1.00  0.00           H  
ATOM    512  HE2 LYS A  33      15.180  13.367  91.218  1.00  0.00           H  
ATOM    513  HE3 LYS A  33      13.658  14.101  91.755  1.00  0.00           H  
ATOM    514  HZ1 LYS A  33      15.382  15.048  89.552  1.00  0.00           H  
ATOM    515  HZ2 LYS A  33      13.874  14.385  89.432  1.00  0.00           H  
ATOM    516  HZ3 LYS A  33      14.101  15.879  90.101  1.00  0.00           H  
ATOM    517  N   GLU A  34      18.826  17.151  94.459  1.00  0.00           N  
ATOM    518  CA  GLU A  34      19.529  18.377  94.136  1.00  0.00           C  
ATOM    519  C   GLU A  34      20.882  17.998  93.562  1.00  0.00           C  
ATOM    520  O   GLU A  34      21.178  18.415  92.454  1.00  0.00           O  
ATOM    521  CB  GLU A  34      19.669  19.224  95.412  1.00  0.00           C  
ATOM    522  CG  GLU A  34      20.106  20.668  95.156  1.00  0.00           C  
ATOM    523  CD  GLU A  34      21.461  20.858  94.465  1.00  0.00           C  
ATOM    524  OE1 GLU A  34      22.415  20.182  94.897  1.00  0.00           O  
ATOM    525  OE2 GLU A  34      21.538  21.723  93.556  1.00  0.00           O  
ATOM    526  H   GLU A  34      18.588  17.016  95.429  1.00  0.00           H  
ATOM    527  HA  GLU A  34      18.960  18.933  93.382  1.00  0.00           H  
ATOM    528  HB2 GLU A  34      18.693  19.267  95.901  1.00  0.00           H  
ATOM    529  HB3 GLU A  34      20.363  18.755  96.111  1.00  0.00           H  
ATOM    530  HG2 GLU A  34      19.329  21.128  94.555  1.00  0.00           H  
ATOM    531  HG3 GLU A  34      20.144  21.174  96.120  1.00  0.00           H  
ATOM    532  N   LEU A  35      21.648  17.168  94.277  1.00  0.00           N  
ATOM    533  CA  LEU A  35      23.001  16.807  93.920  1.00  0.00           C  
ATOM    534  C   LEU A  35      22.995  16.293  92.499  1.00  0.00           C  
ATOM    535  O   LEU A  35      23.630  16.888  91.654  1.00  0.00           O  
ATOM    536  CB  LEU A  35      23.599  15.806  94.931  1.00  0.00           C  
ATOM    537  CG  LEU A  35      25.056  15.362  94.682  1.00  0.00           C  
ATOM    538  CD1 LEU A  35      25.247  14.400  93.503  1.00  0.00           C  
ATOM    539  CD2 LEU A  35      25.996  16.555  94.520  1.00  0.00           C  
ATOM    540  H   LEU A  35      21.330  16.911  95.201  1.00  0.00           H  
ATOM    541  HA  LEU A  35      23.576  17.734  93.951  1.00  0.00           H  
ATOM    542  HB2 LEU A  35      23.575  16.281  95.912  1.00  0.00           H  
ATOM    543  HB3 LEU A  35      22.965  14.921  94.978  1.00  0.00           H  
ATOM    544  HG  LEU A  35      25.372  14.813  95.569  1.00  0.00           H  
ATOM    545 HD11 LEU A  35      25.227  14.929  92.553  1.00  0.00           H  
ATOM    546 HD12 LEU A  35      26.214  13.906  93.593  1.00  0.00           H  
ATOM    547 HD13 LEU A  35      24.466  13.639  93.512  1.00  0.00           H  
ATOM    548 HD21 LEU A  35      27.000  16.199  94.312  1.00  0.00           H  
ATOM    549 HD22 LEU A  35      25.669  17.184  93.701  1.00  0.00           H  
ATOM    550 HD23 LEU A  35      25.997  17.152  95.432  1.00  0.00           H  
ATOM    551  N   GLU A  36      22.304  15.206  92.187  1.00  0.00           N  
ATOM    552  CA  GLU A  36      22.363  14.640  90.842  1.00  0.00           C  
ATOM    553  C   GLU A  36      21.877  15.641  89.766  1.00  0.00           C  
ATOM    554  O   GLU A  36      22.439  15.659  88.657  1.00  0.00           O  
ATOM    555  CB  GLU A  36      21.615  13.307  90.867  1.00  0.00           C  
ATOM    556  CG  GLU A  36      21.854  12.448  89.619  1.00  0.00           C  
ATOM    557  CD  GLU A  36      23.112  11.571  89.647  1.00  0.00           C  
ATOM    558  OE1 GLU A  36      24.238  12.041  89.361  1.00  0.00           O  
ATOM    559  OE2 GLU A  36      22.933  10.339  89.811  1.00  0.00           O  
ATOM    560  H   GLU A  36      21.726  14.790  92.906  1.00  0.00           H  
ATOM    561  HA  GLU A  36      23.403  14.430  90.604  1.00  0.00           H  
ATOM    562  HB2 GLU A  36      21.893  12.737  91.758  1.00  0.00           H  
ATOM    563  HB3 GLU A  36      20.557  13.537  90.944  1.00  0.00           H  
ATOM    564  HG2 GLU A  36      20.983  11.805  89.492  1.00  0.00           H  
ATOM    565  HG3 GLU A  36      21.898  13.086  88.751  1.00  0.00           H  
ATOM    566  N   ALA A  37      20.904  16.511  90.089  1.00  0.00           N  
ATOM    567  CA  ALA A  37      20.497  17.597  89.196  1.00  0.00           C  
ATOM    568  C   ALA A  37      21.647  18.581  88.938  1.00  0.00           C  
ATOM    569  O   ALA A  37      21.999  18.831  87.779  1.00  0.00           O  
ATOM    570  CB  ALA A  37      19.276  18.324  89.760  1.00  0.00           C  
ATOM    571  H   ALA A  37      20.513  16.508  91.035  1.00  0.00           H  
ATOM    572  HA  ALA A  37      20.210  17.158  88.240  1.00  0.00           H  
ATOM    573  HB1 ALA A  37      18.962  19.092  89.054  1.00  0.00           H  
ATOM    574  HB2 ALA A  37      18.464  17.620  89.927  1.00  0.00           H  
ATOM    575  HB3 ALA A  37      19.525  18.815  90.697  1.00  0.00           H  
ATOM    576  N   PHE A  38      22.255  19.107  90.005  1.00  0.00           N  
ATOM    577  CA  PHE A  38      23.451  19.941  89.977  1.00  0.00           C  
ATOM    578  C   PHE A  38      24.529  19.230  89.172  1.00  0.00           C  
ATOM    579  O   PHE A  38      25.261  19.851  88.412  1.00  0.00           O  
ATOM    580  CB  PHE A  38      23.920  20.238  91.422  1.00  0.00           C  
ATOM    581  CG  PHE A  38      25.422  20.184  91.690  1.00  0.00           C  
ATOM    582  CD1 PHE A  38      26.085  18.951  91.820  1.00  0.00           C  
ATOM    583  CD2 PHE A  38      26.165  21.361  91.845  1.00  0.00           C  
ATOM    584  CE1 PHE A  38      27.459  18.880  92.086  1.00  0.00           C  
ATOM    585  CE2 PHE A  38      27.545  21.304  92.106  1.00  0.00           C  
ATOM    586  CZ  PHE A  38      28.192  20.063  92.230  1.00  0.00           C  
ATOM    587  H   PHE A  38      21.935  18.832  90.932  1.00  0.00           H  
ATOM    588  HA  PHE A  38      23.209  20.883  89.484  1.00  0.00           H  
ATOM    589  HB2 PHE A  38      23.542  21.219  91.706  1.00  0.00           H  
ATOM    590  HB3 PHE A  38      23.463  19.530  92.111  1.00  0.00           H  
ATOM    591  HD1 PHE A  38      25.531  18.042  91.714  1.00  0.00           H  
ATOM    592  HD2 PHE A  38      25.670  22.309  91.748  1.00  0.00           H  
ATOM    593  HE1 PHE A  38      27.937  17.921  92.214  1.00  0.00           H  
ATOM    594  HE2 PHE A  38      28.099  22.218  92.227  1.00  0.00           H  
ATOM    595  HZ  PHE A  38      29.243  19.999  92.454  1.00  0.00           H  
ATOM    596  N   ARG A  39      24.633  17.912  89.324  1.00  0.00           N  
ATOM    597  CA  ARG A  39      25.723  17.115  88.808  1.00  0.00           C  
ATOM    598  C   ARG A  39      25.648  17.220  87.310  1.00  0.00           C  
ATOM    599  O   ARG A  39      26.648  17.573  86.687  1.00  0.00           O  
ATOM    600  CB  ARG A  39      25.577  15.675  89.319  1.00  0.00           C  
ATOM    601  CG  ARG A  39      26.859  14.968  89.713  1.00  0.00           C  
ATOM    602  CD  ARG A  39      27.584  14.383  88.510  1.00  0.00           C  
ATOM    603  NE  ARG A  39      28.543  13.382  88.984  1.00  0.00           N  
ATOM    604  CZ  ARG A  39      28.378  12.054  88.977  1.00  0.00           C  
ATOM    605  NH1 ARG A  39      27.270  11.487  88.498  1.00  0.00           N  
ATOM    606  NH2 ARG A  39      29.347  11.284  89.452  1.00  0.00           N  
ATOM    607  H   ARG A  39      23.969  17.484  89.960  1.00  0.00           H  
ATOM    608  HA  ARG A  39      26.652  17.567  89.157  1.00  0.00           H  
ATOM    609  HB2 ARG A  39      25.010  15.691  90.231  1.00  0.00           H  
ATOM    610  HB3 ARG A  39      25.022  15.068  88.607  1.00  0.00           H  
ATOM    611  HG2 ARG A  39      27.510  15.647  90.262  1.00  0.00           H  
ATOM    612  HG3 ARG A  39      26.587  14.150  90.381  1.00  0.00           H  
ATOM    613  HD2 ARG A  39      26.868  13.929  87.825  1.00  0.00           H  
ATOM    614  HD3 ARG A  39      28.113  15.178  87.982  1.00  0.00           H  
ATOM    615  HE  ARG A  39      29.376  13.792  89.413  1.00  0.00           H  
ATOM    616 HH11 ARG A  39      26.414  12.028  88.397  1.00  0.00           H  
ATOM    617 HH12 ARG A  39      27.184  10.474  88.456  1.00  0.00           H  
ATOM    618 HH21 ARG A  39      30.044  11.689  90.082  1.00  0.00           H  
ATOM    619 HH22 ARG A  39      29.327  10.275  89.355  1.00  0.00           H  
ATOM    620  N   GLU A  40      24.476  16.935  86.737  1.00  0.00           N  
ATOM    621  CA  GLU A  40      24.368  17.060  85.287  1.00  0.00           C  
ATOM    622  C   GLU A  40      24.522  18.504  84.794  1.00  0.00           C  
ATOM    623  O   GLU A  40      25.158  18.732  83.754  1.00  0.00           O  
ATOM    624  CB  GLU A  40      23.112  16.410  84.706  1.00  0.00           C  
ATOM    625  CG  GLU A  40      21.740  17.057  84.960  1.00  0.00           C  
ATOM    626  CD  GLU A  40      20.823  16.799  83.763  1.00  0.00           C  
ATOM    627  OE1 GLU A  40      20.827  17.612  82.803  1.00  0.00           O  
ATOM    628  OE2 GLU A  40      20.160  15.744  83.702  1.00  0.00           O  
ATOM    629  H   GLU A  40      23.703  16.655  87.348  1.00  0.00           H  
ATOM    630  HA  GLU A  40      25.211  16.500  84.883  1.00  0.00           H  
ATOM    631  HB2 GLU A  40      23.270  16.411  83.636  1.00  0.00           H  
ATOM    632  HB3 GLU A  40      23.096  15.371  85.015  1.00  0.00           H  
ATOM    633  HG2 GLU A  40      21.299  16.659  85.874  1.00  0.00           H  
ATOM    634  HG3 GLU A  40      21.837  18.133  85.065  1.00  0.00           H  
ATOM    635  N   GLU A  41      23.947  19.469  85.523  1.00  0.00           N  
ATOM    636  CA  GLU A  41      23.889  20.859  85.082  1.00  0.00           C  
ATOM    637  C   GLU A  41      25.304  21.421  84.998  1.00  0.00           C  
ATOM    638  O   GLU A  41      25.696  22.030  83.992  1.00  0.00           O  
ATOM    639  CB  GLU A  41      22.928  21.686  85.965  1.00  0.00           C  
ATOM    640  CG  GLU A  41      23.529  22.551  87.091  1.00  0.00           C  
ATOM    641  CD  GLU A  41      22.442  23.325  87.846  1.00  0.00           C  
ATOM    642  OE1 GLU A  41      21.645  24.022  87.168  1.00  0.00           O  
ATOM    643  OE2 GLU A  41      22.368  23.238  89.090  1.00  0.00           O  
ATOM    644  H   GLU A  41      23.432  19.224  86.365  1.00  0.00           H  
ATOM    645  HA  GLU A  41      23.475  20.855  84.075  1.00  0.00           H  
ATOM    646  HB2 GLU A  41      22.396  22.357  85.297  1.00  0.00           H  
ATOM    647  HB3 GLU A  41      22.182  21.024  86.397  1.00  0.00           H  
ATOM    648  HG2 GLU A  41      24.079  21.927  87.788  1.00  0.00           H  
ATOM    649  HG3 GLU A  41      24.231  23.267  86.663  1.00  0.00           H  
ATOM    650  N   LEU A  42      26.099  21.132  86.029  1.00  0.00           N  
ATOM    651  CA  LEU A  42      27.490  21.500  86.077  1.00  0.00           C  
ATOM    652  C   LEU A  42      28.301  20.693  85.090  1.00  0.00           C  
ATOM    653  O   LEU A  42      29.278  21.220  84.589  1.00  0.00           O  
ATOM    654  CB  LEU A  42      28.097  21.298  87.467  1.00  0.00           C  
ATOM    655  CG  LEU A  42      28.426  22.654  88.121  1.00  0.00           C  
ATOM    656  CD1 LEU A  42      27.259  23.192  88.933  1.00  0.00           C  
ATOM    657  CD2 LEU A  42      29.704  22.492  88.920  1.00  0.00           C  
ATOM    658  H   LEU A  42      25.700  20.634  86.824  1.00  0.00           H  
ATOM    659  HA  LEU A  42      27.554  22.549  85.799  1.00  0.00           H  
ATOM    660  HB2 LEU A  42      27.447  20.725  88.120  1.00  0.00           H  
ATOM    661  HB3 LEU A  42      28.993  20.679  87.351  1.00  0.00           H  
ATOM    662  HG  LEU A  42      28.622  23.432  87.396  1.00  0.00           H  
ATOM    663 HD11 LEU A  42      27.561  24.102  89.453  1.00  0.00           H  
ATOM    664 HD12 LEU A  42      26.437  23.419  88.253  1.00  0.00           H  
ATOM    665 HD13 LEU A  42      26.928  22.439  89.642  1.00  0.00           H  
ATOM    666 HD21 LEU A  42      29.540  21.768  89.714  1.00  0.00           H  
ATOM    667 HD22 LEU A  42      30.481  22.148  88.227  1.00  0.00           H  
ATOM    668 HD23 LEU A  42      29.983  23.457  89.331  1.00  0.00           H  
ATOM    669  N   LYS A  43      27.949  19.447  84.776  1.00  0.00           N  
ATOM    670  CA  LYS A  43      28.699  18.698  83.769  1.00  0.00           C  
ATOM    671  C   LYS A  43      28.612  19.387  82.403  1.00  0.00           C  
ATOM    672  O   LYS A  43      29.622  19.512  81.689  1.00  0.00           O  
ATOM    673  CB  LYS A  43      28.219  17.241  83.762  1.00  0.00           C  
ATOM    674  CG  LYS A  43      29.380  16.262  83.593  1.00  0.00           C  
ATOM    675  CD  LYS A  43      30.254  16.170  84.856  1.00  0.00           C  
ATOM    676  CE  LYS A  43      31.610  15.547  84.541  1.00  0.00           C  
ATOM    677  NZ  LYS A  43      31.543  14.086  84.363  1.00  0.00           N  
ATOM    678  H   LYS A  43      27.197  19.005  85.302  1.00  0.00           H  
ATOM    679  HA  LYS A  43      29.743  18.738  84.069  1.00  0.00           H  
ATOM    680  HB2 LYS A  43      27.758  17.020  84.719  1.00  0.00           H  
ATOM    681  HB3 LYS A  43      27.485  17.090  82.969  1.00  0.00           H  
ATOM    682  HG2 LYS A  43      28.980  15.275  83.370  1.00  0.00           H  
ATOM    683  HG3 LYS A  43      29.982  16.590  82.754  1.00  0.00           H  
ATOM    684  HD2 LYS A  43      30.444  17.162  85.255  1.00  0.00           H  
ATOM    685  HD3 LYS A  43      29.738  15.604  85.633  1.00  0.00           H  
ATOM    686  HE2 LYS A  43      32.002  16.001  83.630  1.00  0.00           H  
ATOM    687  HE3 LYS A  43      32.302  15.782  85.351  1.00  0.00           H  
ATOM    688  HZ1 LYS A  43      30.956  13.865  83.567  1.00  0.00           H  
ATOM    689  HZ2 LYS A  43      32.469  13.731  84.165  1.00  0.00           H  
ATOM    690  HZ3 LYS A  43      31.197  13.633  85.204  1.00  0.00           H  
ATOM    691  N   HIS A  44      27.421  19.875  82.043  1.00  0.00           N  
ATOM    692  CA  HIS A  44      27.314  20.738  80.870  1.00  0.00           C  
ATOM    693  C   HIS A  44      28.104  22.037  81.082  1.00  0.00           C  
ATOM    694  O   HIS A  44      28.738  22.516  80.133  1.00  0.00           O  
ATOM    695  CB  HIS A  44      25.848  21.037  80.518  1.00  0.00           C  
ATOM    696  CG  HIS A  44      25.145  19.901  79.815  1.00  0.00           C  
ATOM    697  ND1 HIS A  44      24.489  19.970  78.604  1.00  0.00           N  
ATOM    698  CD2 HIS A  44      25.012  18.619  80.279  1.00  0.00           C  
ATOM    699  CE1 HIS A  44      23.968  18.760  78.347  1.00  0.00           C  
ATOM    700  NE2 HIS A  44      24.238  17.909  79.351  1.00  0.00           N  
ATOM    701  H   HIS A  44      26.620  19.725  82.660  1.00  0.00           H  
ATOM    702  HA  HIS A  44      27.769  20.220  80.023  1.00  0.00           H  
ATOM    703  HB2 HIS A  44      25.296  21.295  81.424  1.00  0.00           H  
ATOM    704  HB3 HIS A  44      25.827  21.904  79.855  1.00  0.00           H  
ATOM    705  HD1 HIS A  44      24.358  20.775  77.993  1.00  0.00           H  
ATOM    706  HD2 HIS A  44      25.403  18.238  81.210  1.00  0.00           H  
ATOM    707  HE1 HIS A  44      23.392  18.517  77.462  1.00  0.00           H  
ATOM    708  N   PHE A  45      28.064  22.620  82.289  1.00  0.00           N  
ATOM    709  CA  PHE A  45      28.729  23.886  82.563  1.00  0.00           C  
ATOM    710  C   PHE A  45      30.250  23.758  82.407  1.00  0.00           C  
ATOM    711  O   PHE A  45      30.820  24.451  81.560  1.00  0.00           O  
ATOM    712  CB  PHE A  45      28.317  24.420  83.943  1.00  0.00           C  
ATOM    713  CG  PHE A  45      28.605  25.893  84.068  1.00  0.00           C  
ATOM    714  CD1 PHE A  45      27.742  26.816  83.452  1.00  0.00           C  
ATOM    715  CD2 PHE A  45      29.751  26.340  84.747  1.00  0.00           C  
ATOM    716  CE1 PHE A  45      28.011  28.189  83.536  1.00  0.00           C  
ATOM    717  CE2 PHE A  45      30.016  27.719  84.825  1.00  0.00           C  
ATOM    718  CZ  PHE A  45      29.122  28.641  84.263  1.00  0.00           C  
ATOM    719  H   PHE A  45      27.549  22.207  83.069  1.00  0.00           H  
ATOM    720  HA  PHE A  45      28.387  24.598  81.812  1.00  0.00           H  
ATOM    721  HB2 PHE A  45      27.241  24.284  84.092  1.00  0.00           H  
ATOM    722  HB3 PHE A  45      28.854  23.884  84.726  1.00  0.00           H  
ATOM    723  HD1 PHE A  45      26.862  26.469  82.934  1.00  0.00           H  
ATOM    724  HD2 PHE A  45      30.396  25.629  85.249  1.00  0.00           H  
ATOM    725  HE1 PHE A  45      27.358  28.896  83.053  1.00  0.00           H  
ATOM    726  HE2 PHE A  45      30.883  28.071  85.361  1.00  0.00           H  
ATOM    727  HZ  PHE A  45      29.307  29.696  84.374  1.00  0.00           H  
ATOM    728  N   GLU A  46      30.882  22.844  83.155  1.00  0.00           N  
ATOM    729  CA  GLU A  46      32.302  22.516  83.098  1.00  0.00           C  
ATOM    730  C   GLU A  46      32.681  22.245  81.659  1.00  0.00           C  
ATOM    731  O   GLU A  46      33.664  22.830  81.204  1.00  0.00           O  
ATOM    732  CB  GLU A  46      32.739  21.384  84.055  1.00  0.00           C  
ATOM    733  CG  GLU A  46      32.250  19.966  83.744  1.00  0.00           C  
ATOM    734  CD  GLU A  46      33.094  19.104  82.784  1.00  0.00           C  
ATOM    735  OE1 GLU A  46      33.965  19.598  82.037  1.00  0.00           O  
ATOM    736  OE2 GLU A  46      32.825  17.878  82.727  1.00  0.00           O  
ATOM    737  H   GLU A  46      30.340  22.335  83.843  1.00  0.00           H  
ATOM    738  HA  GLU A  46      32.839  23.396  83.443  1.00  0.00           H  
ATOM    739  HB2 GLU A  46      33.827  21.369  84.116  1.00  0.00           H  
ATOM    740  HB3 GLU A  46      32.364  21.629  85.045  1.00  0.00           H  
ATOM    741  HG2 GLU A  46      32.151  19.437  84.697  1.00  0.00           H  
ATOM    742  HG3 GLU A  46      31.265  20.061  83.323  1.00  0.00           H  
ATOM    743  N   ALA A  47      31.882  21.450  80.919  1.00  0.00           N  
ATOM    744  CA  ALA A  47      32.252  21.150  79.547  1.00  0.00           C  
ATOM    745  C   ALA A  47      32.377  22.444  78.723  1.00  0.00           C  
ATOM    746  O   ALA A  47      33.362  22.653  77.996  1.00  0.00           O  
ATOM    747  CB  ALA A  47      31.250  20.176  78.924  1.00  0.00           C  
ATOM    748  H   ALA A  47      31.083  20.961  81.334  1.00  0.00           H  
ATOM    749  HA  ALA A  47      33.221  20.654  79.598  1.00  0.00           H  
ATOM    750  HB1 ALA A  47      31.190  19.280  79.535  1.00  0.00           H  
ATOM    751  HB2 ALA A  47      30.263  20.632  78.861  1.00  0.00           H  
ATOM    752  HB3 ALA A  47      31.594  19.886  77.933  1.00  0.00           H  
ATOM    753  N   LYS A  48      31.379  23.329  78.822  1.00  0.00           N  
ATOM    754  CA  LYS A  48      31.398  24.573  78.066  1.00  0.00           C  
ATOM    755  C   LYS A  48      32.527  25.514  78.480  1.00  0.00           C  
ATOM    756  O   LYS A  48      33.148  26.089  77.582  1.00  0.00           O  
ATOM    757  CB  LYS A  48      30.036  25.277  78.140  1.00  0.00           C  
ATOM    758  CG  LYS A  48      29.229  25.057  76.849  1.00  0.00           C  
ATOM    759  CD  LYS A  48      29.820  25.792  75.630  1.00  0.00           C  
ATOM    760  CE  LYS A  48      29.238  25.277  74.309  1.00  0.00           C  
ATOM    761  NZ  LYS A  48      27.805  25.594  74.162  1.00  0.00           N  
ATOM    762  H   LYS A  48      30.594  23.130  79.444  1.00  0.00           H  
ATOM    763  HA  LYS A  48      31.611  24.290  77.038  1.00  0.00           H  
ATOM    764  HB2 LYS A  48      29.465  24.904  78.993  1.00  0.00           H  
ATOM    765  HB3 LYS A  48      30.201  26.341  78.302  1.00  0.00           H  
ATOM    766  HG2 LYS A  48      29.184  23.986  76.644  1.00  0.00           H  
ATOM    767  HG3 LYS A  48      28.212  25.411  77.012  1.00  0.00           H  
ATOM    768  HD2 LYS A  48      29.638  26.863  75.726  1.00  0.00           H  
ATOM    769  HD3 LYS A  48      30.898  25.648  75.586  1.00  0.00           H  
ATOM    770  HE2 LYS A  48      29.790  25.725  73.480  1.00  0.00           H  
ATOM    771  HE3 LYS A  48      29.376  24.194  74.261  1.00  0.00           H  
ATOM    772  HZ1 LYS A  48      27.614  26.580  74.325  1.00  0.00           H  
ATOM    773  HZ2 LYS A  48      27.452  25.300  73.259  1.00  0.00           H  
ATOM    774  HZ3 LYS A  48      27.251  25.104  74.859  1.00  0.00           H  
ATOM    775  N   ILE A  49      32.795  25.721  79.773  1.00  0.00           N  
ATOM    776  CA  ILE A  49      33.910  26.586  80.175  1.00  0.00           C  
ATOM    777  C   ILE A  49      35.244  25.941  79.758  1.00  0.00           C  
ATOM    778  O   ILE A  49      36.164  26.648  79.347  1.00  0.00           O  
ATOM    779  CB  ILE A  49      33.817  27.009  81.665  1.00  0.00           C  
ATOM    780  CG1 ILE A  49      34.898  28.029  82.089  1.00  0.00           C  
ATOM    781  CG2 ILE A  49      33.879  25.817  82.616  1.00  0.00           C  
ATOM    782  CD1 ILE A  49      34.593  29.441  81.591  1.00  0.00           C  
ATOM    783  H   ILE A  49      32.259  25.239  80.491  1.00  0.00           H  
ATOM    784  HA  ILE A  49      33.811  27.500  79.593  1.00  0.00           H  
ATOM    785  HB  ILE A  49      32.843  27.477  81.816  1.00  0.00           H  
ATOM    786 HG12 ILE A  49      34.951  28.079  83.178  1.00  0.00           H  
ATOM    787 HG13 ILE A  49      35.878  27.717  81.728  1.00  0.00           H  
ATOM    788 HG21 ILE A  49      34.847  25.324  82.546  1.00  0.00           H  
ATOM    789 HG22 ILE A  49      33.714  26.151  83.640  1.00  0.00           H  
ATOM    790 HG23 ILE A  49      33.087  25.128  82.364  1.00  0.00           H  
ATOM    791 HD11 ILE A  49      34.346  29.426  80.529  1.00  0.00           H  
ATOM    792 HD12 ILE A  49      33.757  29.852  82.157  1.00  0.00           H  
ATOM    793 HD13 ILE A  49      35.460  30.077  81.758  1.00  0.00           H  
ATOM    794  N   GLU A  50      35.343  24.609  79.738  1.00  0.00           N  
ATOM    795  CA  GLU A  50      36.522  23.902  79.247  1.00  0.00           C  
ATOM    796  C   GLU A  50      36.777  24.224  77.771  1.00  0.00           C  
ATOM    797  O   GLU A  50      37.925  24.400  77.350  1.00  0.00           O  
ATOM    798  CB  GLU A  50      36.340  22.385  79.395  1.00  0.00           C  
ATOM    799  CG  GLU A  50      37.671  21.639  79.507  1.00  0.00           C  
ATOM    800  CD  GLU A  50      37.769  20.400  78.616  1.00  0.00           C  
ATOM    801  OE1 GLU A  50      36.747  19.725  78.364  1.00  0.00           O  
ATOM    802  OE2 GLU A  50      38.903  20.139  78.136  1.00  0.00           O  
ATOM    803  H   GLU A  50      34.584  24.049  80.120  1.00  0.00           H  
ATOM    804  HA  GLU A  50      37.373  24.231  79.843  1.00  0.00           H  
ATOM    805  HB2 GLU A  50      35.775  22.150  80.290  1.00  0.00           H  
ATOM    806  HB3 GLU A  50      35.782  22.028  78.533  1.00  0.00           H  
ATOM    807  HG2 GLU A  50      38.493  22.314  79.254  1.00  0.00           H  
ATOM    808  HG3 GLU A  50      37.795  21.328  80.544  1.00  0.00           H  
ATOM    809  N   LYS A  51      35.709  24.286  76.971  1.00  0.00           N  
ATOM    810  CA  LYS A  51      35.821  24.636  75.557  1.00  0.00           C  
ATOM    811  C   LYS A  51      36.121  26.119  75.359  1.00  0.00           C  
ATOM    812  O   LYS A  51      36.970  26.441  74.534  1.00  0.00           O  
ATOM    813  CB  LYS A  51      34.552  24.233  74.817  1.00  0.00           C  
ATOM    814  CG  LYS A  51      34.469  22.704  74.675  1.00  0.00           C  
ATOM    815  CD  LYS A  51      33.056  22.186  74.403  1.00  0.00           C  
ATOM    816  CE  LYS A  51      33.133  20.662  74.228  1.00  0.00           C  
ATOM    817  NZ  LYS A  51      31.907  20.097  73.635  1.00  0.00           N  
ATOM    818  H   LYS A  51      34.803  24.017  77.361  1.00  0.00           H  
ATOM    819  HA  LYS A  51      36.655  24.079  75.129  1.00  0.00           H  
ATOM    820  HB2 LYS A  51      33.694  24.629  75.353  1.00  0.00           H  
ATOM    821  HB3 LYS A  51      34.606  24.680  73.826  1.00  0.00           H  
ATOM    822  HG2 LYS A  51      35.121  22.402  73.854  1.00  0.00           H  
ATOM    823  HG3 LYS A  51      34.830  22.228  75.585  1.00  0.00           H  
ATOM    824  HD2 LYS A  51      32.402  22.433  75.243  1.00  0.00           H  
ATOM    825  HD3 LYS A  51      32.674  22.656  73.499  1.00  0.00           H  
ATOM    826  HE2 LYS A  51      33.971  20.420  73.570  1.00  0.00           H  
ATOM    827  HE3 LYS A  51      33.323  20.199  75.198  1.00  0.00           H  
ATOM    828  HZ1 LYS A  51      31.793  20.451  72.692  1.00  0.00           H  
ATOM    829  HZ2 LYS A  51      32.003  19.086  73.571  1.00  0.00           H  
ATOM    830  HZ3 LYS A  51      31.093  20.306  74.207  1.00  0.00           H  
ATOM    831  N   HIS A  52      35.486  27.018  76.116  1.00  0.00           N  
ATOM    832  CA  HIS A  52      35.880  28.418  76.180  1.00  0.00           C  
ATOM    833  C   HIS A  52      37.384  28.564  76.402  1.00  0.00           C  
ATOM    834  O   HIS A  52      38.055  29.139  75.556  1.00  0.00           O  
ATOM    835  CB  HIS A  52      35.073  29.096  77.276  1.00  0.00           C  
ATOM    836  CG  HIS A  52      35.399  30.543  77.477  1.00  0.00           C  
ATOM    837  ND1 HIS A  52      35.973  31.140  78.578  1.00  0.00           N  
ATOM    838  CD2 HIS A  52      35.043  31.526  76.609  1.00  0.00           C  
ATOM    839  CE1 HIS A  52      35.940  32.467  78.377  1.00  0.00           C  
ATOM    840  NE2 HIS A  52      35.366  32.746  77.198  1.00  0.00           N  
ATOM    841  H   HIS A  52      34.719  26.745  76.722  1.00  0.00           H  
ATOM    842  HA  HIS A  52      35.639  28.889  75.228  1.00  0.00           H  
ATOM    843  HB2 HIS A  52      34.031  29.009  76.988  1.00  0.00           H  
ATOM    844  HB3 HIS A  52      35.187  28.585  78.221  1.00  0.00           H  
ATOM    845  HD1 HIS A  52      36.442  30.710  79.383  1.00  0.00           H  
ATOM    846  HD2 HIS A  52      34.566  31.350  75.660  1.00  0.00           H  
ATOM    847  HE1 HIS A  52      36.327  33.213  79.061  1.00  0.00           H  
ATOM    848  N   ASN A  53      37.914  27.979  77.471  1.00  0.00           N  
ATOM    849  CA  ASN A  53      39.348  27.827  77.754  1.00  0.00           C  
ATOM    850  C   ASN A  53      40.123  27.337  76.528  1.00  0.00           C  
ATOM    851  O   ASN A  53      41.108  27.968  76.146  1.00  0.00           O  
ATOM    852  CB  ASN A  53      39.500  26.880  78.962  1.00  0.00           C  
ATOM    853  CG  ASN A  53      40.822  26.116  79.094  1.00  0.00           C  
ATOM    854  OD1 ASN A  53      41.887  26.519  78.640  1.00  0.00           O  
ATOM    855  ND2 ASN A  53      40.778  24.963  79.742  1.00  0.00           N  
ATOM    856  H   ASN A  53      37.248  27.606  78.136  1.00  0.00           H  
ATOM    857  HA  ASN A  53      39.766  28.807  78.012  1.00  0.00           H  
ATOM    858  HB2 ASN A  53      39.326  27.452  79.871  1.00  0.00           H  
ATOM    859  HB3 ASN A  53      38.708  26.145  78.912  1.00  0.00           H  
ATOM    860 HD21 ASN A  53      39.912  24.636  80.128  1.00  0.00           H  
ATOM    861 HD22 ASN A  53      41.610  24.389  79.859  1.00  0.00           H  
ATOM    862  N   HIS A  54      39.667  26.270  75.859  1.00  0.00           N  
ATOM    863  CA  HIS A  54      40.353  25.745  74.675  1.00  0.00           C  
ATOM    864  C   HIS A  54      40.493  26.837  73.607  1.00  0.00           C  
ATOM    865  O   HIS A  54      41.526  26.960  72.945  1.00  0.00           O  
ATOM    866  CB  HIS A  54      39.535  24.556  74.151  1.00  0.00           C  
ATOM    867  CG  HIS A  54      40.268  23.592  73.260  1.00  0.00           C  
ATOM    868  ND1 HIS A  54      40.592  22.289  73.581  1.00  0.00           N  
ATOM    869  CD2 HIS A  54      40.584  23.793  71.944  1.00  0.00           C  
ATOM    870  CE1 HIS A  54      41.094  21.714  72.476  1.00  0.00           C  
ATOM    871  NE2 HIS A  54      41.072  22.580  71.450  1.00  0.00           N  
ATOM    872  H   HIS A  54      38.790  25.824  76.138  1.00  0.00           H  
ATOM    873  HA  HIS A  54      41.358  25.412  74.952  1.00  0.00           H  
ATOM    874  HB2 HIS A  54      39.143  24.001  75.000  1.00  0.00           H  
ATOM    875  HB3 HIS A  54      38.678  24.926  73.591  1.00  0.00           H  
ATOM    876  HD1 HIS A  54      40.479  21.830  74.492  1.00  0.00           H  
ATOM    877  HD2 HIS A  54      40.424  24.700  71.374  1.00  0.00           H  
ATOM    878  HE1 HIS A  54      41.445  20.692  72.417  1.00  0.00           H  
ATOM    879  N   TYR A  55      39.444  27.637  73.438  1.00  0.00           N  
ATOM    880  CA  TYR A  55      39.393  28.691  72.448  1.00  0.00           C  
ATOM    881  C   TYR A  55      40.159  29.928  72.911  1.00  0.00           C  
ATOM    882  O   TYR A  55      40.796  30.529  72.060  1.00  0.00           O  
ATOM    883  CB  TYR A  55      37.938  29.033  72.147  1.00  0.00           C  
ATOM    884  CG  TYR A  55      37.156  28.081  71.238  1.00  0.00           C  
ATOM    885  CD1 TYR A  55      37.556  26.745  71.014  1.00  0.00           C  
ATOM    886  CD2 TYR A  55      36.048  28.585  70.529  1.00  0.00           C  
ATOM    887  CE1 TYR A  55      36.901  25.952  70.058  1.00  0.00           C  
ATOM    888  CE2 TYR A  55      35.382  27.801  69.568  1.00  0.00           C  
ATOM    889  CZ  TYR A  55      35.833  26.486  69.308  1.00  0.00           C  
ATOM    890  OH  TYR A  55      35.279  25.737  68.317  1.00  0.00           O  
ATOM    891  H   TYR A  55      38.635  27.529  74.044  1.00  0.00           H  
ATOM    892  HA  TYR A  55      39.856  28.344  71.524  1.00  0.00           H  
ATOM    893  HB2 TYR A  55      37.441  29.163  73.103  1.00  0.00           H  
ATOM    894  HB3 TYR A  55      37.937  30.006  71.660  1.00  0.00           H  
ATOM    895  HD1 TYR A  55      38.390  26.316  71.543  1.00  0.00           H  
ATOM    896  HD2 TYR A  55      35.749  29.612  70.692  1.00  0.00           H  
ATOM    897  HE1 TYR A  55      37.239  24.941  69.878  1.00  0.00           H  
ATOM    898  HE2 TYR A  55      34.567  28.228  69.002  1.00  0.00           H  
ATOM    899  HH  TYR A  55      34.472  26.126  67.929  1.00  0.00           H  
ATOM    900  N   GLN A  56      40.172  30.291  74.204  1.00  0.00           N  
ATOM    901  CA  GLN A  56      41.037  31.358  74.716  1.00  0.00           C  
ATOM    902  C   GLN A  56      42.501  31.006  74.437  1.00  0.00           C  
ATOM    903  O   GLN A  56      43.306  31.862  74.083  1.00  0.00           O  
ATOM    904  CB  GLN A  56      40.913  31.588  76.233  1.00  0.00           C  
ATOM    905  CG  GLN A  56      39.567  32.012  76.824  1.00  0.00           C  
ATOM    906  CD  GLN A  56      39.682  32.530  78.269  1.00  0.00           C  
ATOM    907  OE1 GLN A  56      38.721  33.049  78.824  1.00  0.00           O  
ATOM    908  NE2 GLN A  56      40.778  32.326  78.981  1.00  0.00           N  
ATOM    909  H   GLN A  56      39.602  29.782  74.869  1.00  0.00           H  
ATOM    910  HA  GLN A  56      40.790  32.292  74.214  1.00  0.00           H  
ATOM    911  HB2 GLN A  56      41.272  30.708  76.767  1.00  0.00           H  
ATOM    912  HB3 GLN A  56      41.571  32.421  76.444  1.00  0.00           H  
ATOM    913  HG2 GLN A  56      39.143  32.800  76.207  1.00  0.00           H  
ATOM    914  HG3 GLN A  56      38.889  31.160  76.817  1.00  0.00           H  
ATOM    915 HE21 GLN A  56      41.644  31.964  78.607  1.00  0.00           H  
ATOM    916 HE22 GLN A  56      40.768  32.514  79.985  1.00  0.00           H  
ATOM    917  N   LYS A  57      42.861  29.724  74.568  1.00  0.00           N  
ATOM    918  CA  LYS A  57      44.236  29.306  74.289  1.00  0.00           C  
ATOM    919  C   LYS A  57      44.517  29.464  72.806  1.00  0.00           C  
ATOM    920  O   LYS A  57      45.522  30.065  72.429  1.00  0.00           O  
ATOM    921  CB  LYS A  57      44.515  27.872  74.771  1.00  0.00           C  
ATOM    922  CG  LYS A  57      44.742  27.808  76.288  1.00  0.00           C  
ATOM    923  CD  LYS A  57      46.108  28.382  76.703  1.00  0.00           C  
ATOM    924  CE  LYS A  57      46.222  28.397  78.228  1.00  0.00           C  
ATOM    925  NZ  LYS A  57      47.502  28.971  78.681  1.00  0.00           N  
ATOM    926  H   LYS A  57      42.115  29.073  74.817  1.00  0.00           H  
ATOM    927  HA  LYS A  57      44.911  29.999  74.793  1.00  0.00           H  
ATOM    928  HB2 LYS A  57      43.676  27.228  74.507  1.00  0.00           H  
ATOM    929  HB3 LYS A  57      45.406  27.486  74.272  1.00  0.00           H  
ATOM    930  HG2 LYS A  57      43.944  28.353  76.791  1.00  0.00           H  
ATOM    931  HG3 LYS A  57      44.696  26.766  76.603  1.00  0.00           H  
ATOM    932  HD2 LYS A  57      46.905  27.772  76.278  1.00  0.00           H  
ATOM    933  HD3 LYS A  57      46.217  29.404  76.341  1.00  0.00           H  
ATOM    934  HE2 LYS A  57      45.414  29.008  78.638  1.00  0.00           H  
ATOM    935  HE3 LYS A  57      46.137  27.383  78.616  1.00  0.00           H  
ATOM    936  HZ1 LYS A  57      47.579  29.953  78.421  1.00  0.00           H  
ATOM    937  HZ2 LYS A  57      47.529  28.953  79.697  1.00  0.00           H  
ATOM    938  HZ3 LYS A  57      48.304  28.446  78.342  1.00  0.00           H  
ATOM    939  N   GLN A  58      43.626  28.939  71.962  1.00  0.00           N  
ATOM    940  CA  GLN A  58      43.764  29.127  70.526  1.00  0.00           C  
ATOM    941  C   GLN A  58      43.725  30.606  70.128  1.00  0.00           C  
ATOM    942  O   GLN A  58      44.313  30.932  69.103  1.00  0.00           O  
ATOM    943  CB  GLN A  58      42.708  28.305  69.768  1.00  0.00           C  
ATOM    944  CG  GLN A  58      42.991  26.797  69.842  1.00  0.00           C  
ATOM    945  CD  GLN A  58      44.348  26.462  69.229  1.00  0.00           C  
ATOM    946  OE1 GLN A  58      44.550  26.603  68.024  1.00  0.00           O  
ATOM    947  NE2 GLN A  58      45.297  26.004  70.030  1.00  0.00           N  
ATOM    948  H   GLN A  58      42.820  28.445  72.333  1.00  0.00           H  
ATOM    949  HA  GLN A  58      44.756  28.778  70.242  1.00  0.00           H  
ATOM    950  HB2 GLN A  58      41.719  28.513  70.174  1.00  0.00           H  
ATOM    951  HB3 GLN A  58      42.720  28.603  68.718  1.00  0.00           H  
ATOM    952  HG2 GLN A  58      42.964  26.461  70.879  1.00  0.00           H  
ATOM    953  HG3 GLN A  58      42.215  26.262  69.291  1.00  0.00           H  
ATOM    954 HE21 GLN A  58      45.105  25.851  71.010  1.00  0.00           H  
ATOM    955 HE22 GLN A  58      46.236  25.832  69.662  1.00  0.00           H  
ATOM    956  N   LEU A  59      43.097  31.490  70.906  1.00  0.00           N  
ATOM    957  CA  LEU A  59      43.084  32.930  70.690  1.00  0.00           C  
ATOM    958  C   LEU A  59      44.460  33.505  70.912  1.00  0.00           C  
ATOM    959  O   LEU A  59      44.957  34.184  70.028  1.00  0.00           O  
ATOM    960  CB  LEU A  59      42.097  33.632  71.633  1.00  0.00           C  
ATOM    961  CG  LEU A  59      40.902  34.199  70.876  1.00  0.00           C  
ATOM    962  CD1 LEU A  59      39.769  34.430  71.873  1.00  0.00           C  
ATOM    963  CD2 LEU A  59      41.216  35.461  70.071  1.00  0.00           C  
ATOM    964  H   LEU A  59      42.578  31.147  71.707  1.00  0.00           H  
ATOM    965  HA  LEU A  59      42.804  33.121  69.654  1.00  0.00           H  
ATOM    966  HB2 LEU A  59      41.741  32.923  72.372  1.00  0.00           H  
ATOM    967  HB3 LEU A  59      42.583  34.442  72.177  1.00  0.00           H  
ATOM    968  HG  LEU A  59      40.590  33.448  70.167  1.00  0.00           H  
ATOM    969 HD11 LEU A  59      40.145  35.040  72.694  1.00  0.00           H  
ATOM    970 HD12 LEU A  59      38.935  34.942  71.394  1.00  0.00           H  
ATOM    971 HD13 LEU A  59      39.436  33.476  72.279  1.00  0.00           H  
ATOM    972 HD21 LEU A  59      40.314  35.816  69.568  1.00  0.00           H  
ATOM    973 HD22 LEU A  59      41.583  36.245  70.734  1.00  0.00           H  
ATOM    974 HD23 LEU A  59      41.984  35.250  69.330  1.00  0.00           H  
ATOM    975  N   GLU A  60      45.091  33.220  72.047  1.00  0.00           N  
ATOM    976  CA  GLU A  60      46.424  33.732  72.340  1.00  0.00           C  
ATOM    977  C   GLU A  60      47.440  33.240  71.303  1.00  0.00           C  
ATOM    978  O   GLU A  60      48.335  33.976  70.877  1.00  0.00           O  
ATOM    979  CB  GLU A  60      46.820  33.311  73.766  1.00  0.00           C  
ATOM    980  CG  GLU A  60      47.183  34.532  74.630  1.00  0.00           C  
ATOM    981  CD  GLU A  60      46.045  35.562  74.694  1.00  0.00           C  
ATOM    982  OE1 GLU A  60      44.966  35.243  75.242  1.00  0.00           O  
ATOM    983  OE2 GLU A  60      46.215  36.670  74.127  1.00  0.00           O  
ATOM    984  H   GLU A  60      44.572  32.733  72.774  1.00  0.00           H  
ATOM    985  HA  GLU A  60      46.379  34.819  72.268  1.00  0.00           H  
ATOM    986  HB2 GLU A  60      46.001  32.763  74.231  1.00  0.00           H  
ATOM    987  HB3 GLU A  60      47.660  32.614  73.722  1.00  0.00           H  
ATOM    988  HG2 GLU A  60      47.420  34.195  75.640  1.00  0.00           H  
ATOM    989  HG3 GLU A  60      48.083  34.996  74.217  1.00  0.00           H  
ATOM    990  N   ILE A  61      47.314  31.985  70.874  1.00  0.00           N  
ATOM    991  CA  ILE A  61      48.172  31.407  69.844  1.00  0.00           C  
ATOM    992  C   ILE A  61      47.861  32.069  68.490  1.00  0.00           C  
ATOM    993  O   ILE A  61      48.773  32.338  67.700  1.00  0.00           O  
ATOM    994  CB  ILE A  61      47.986  29.874  69.876  1.00  0.00           C  
ATOM    995  CG1 ILE A  61      48.506  29.315  71.225  1.00  0.00           C  
ATOM    996  CG2 ILE A  61      48.724  29.179  68.726  1.00  0.00           C  
ATOM    997  CD1 ILE A  61      47.868  27.979  71.606  1.00  0.00           C  
ATOM    998  H   ILE A  61      46.580  31.415  71.289  1.00  0.00           H  
ATOM    999  HA  ILE A  61      49.214  31.631  70.083  1.00  0.00           H  
ATOM   1000  HB  ILE A  61      46.921  29.657  69.779  1.00  0.00           H  
ATOM   1001 HG12 ILE A  61      49.589  29.199  71.188  1.00  0.00           H  
ATOM   1002 HG13 ILE A  61      48.281  30.004  72.038  1.00  0.00           H  
ATOM   1003 HG21 ILE A  61      48.256  29.425  67.778  1.00  0.00           H  
ATOM   1004 HG22 ILE A  61      49.770  29.491  68.705  1.00  0.00           H  
ATOM   1005 HG23 ILE A  61      48.680  28.099  68.851  1.00  0.00           H  
ATOM   1006 HD11 ILE A  61      48.257  27.182  70.976  1.00  0.00           H  
ATOM   1007 HD12 ILE A  61      48.097  27.769  72.648  1.00  0.00           H  
ATOM   1008 HD13 ILE A  61      46.788  28.041  71.500  1.00  0.00           H  
ATOM   1009  N   ALA A  62      46.586  32.361  68.214  1.00  0.00           N  
ATOM   1010  CA  ALA A  62      46.174  33.109  67.040  1.00  0.00           C  
ATOM   1011  C   ALA A  62      46.759  34.518  67.073  1.00  0.00           C  
ATOM   1012  O   ALA A  62      47.314  34.942  66.069  1.00  0.00           O  
ATOM   1013  CB  ALA A  62      44.647  33.148  66.908  1.00  0.00           C  
ATOM   1014  H   ALA A  62      45.857  32.106  68.873  1.00  0.00           H  
ATOM   1015  HA  ALA A  62      46.569  32.599  66.166  1.00  0.00           H  
ATOM   1016  HB1 ALA A  62      44.385  33.554  65.939  1.00  0.00           H  
ATOM   1017  HB2 ALA A  62      44.238  32.141  66.957  1.00  0.00           H  
ATOM   1018  HB3 ALA A  62      44.209  33.782  67.677  1.00  0.00           H  
ATOM   1019  N   HIS A  63      46.661  35.221  68.196  1.00  0.00           N  
ATOM   1020  CA  HIS A  63      47.083  36.593  68.438  1.00  0.00           C  
ATOM   1021  C   HIS A  63      48.594  36.733  68.225  1.00  0.00           C  
ATOM   1022  O   HIS A  63      49.055  37.607  67.488  1.00  0.00           O  
ATOM   1023  CB  HIS A  63      46.658  36.956  69.872  1.00  0.00           C  
ATOM   1024  CG  HIS A  63      47.219  38.236  70.436  1.00  0.00           C  
ATOM   1025  ND1 HIS A  63      47.101  39.496  69.901  1.00  0.00           N  
ATOM   1026  CD2 HIS A  63      47.765  38.368  71.681  1.00  0.00           C  
ATOM   1027  CE1 HIS A  63      47.530  40.374  70.819  1.00  0.00           C  
ATOM   1028  NE2 HIS A  63      47.995  39.732  71.906  1.00  0.00           N  
ATOM   1029  H   HIS A  63      46.172  34.776  68.966  1.00  0.00           H  
ATOM   1030  HA  HIS A  63      46.545  37.232  67.740  1.00  0.00           H  
ATOM   1031  HB2 HIS A  63      45.569  37.012  69.912  1.00  0.00           H  
ATOM   1032  HB3 HIS A  63      46.965  36.153  70.538  1.00  0.00           H  
ATOM   1033  HD1 HIS A  63      46.563  39.743  69.072  1.00  0.00           H  
ATOM   1034  HD2 HIS A  63      47.912  37.561  72.390  1.00  0.00           H  
ATOM   1035  HE1 HIS A  63      47.453  41.448  70.713  1.00  0.00           H  
ATOM   1036  N   GLU A  64      49.371  35.817  68.801  1.00  0.00           N  
ATOM   1037  CA  GLU A  64      50.807  35.726  68.591  1.00  0.00           C  
ATOM   1038  C   GLU A  64      51.111  35.555  67.091  1.00  0.00           C  
ATOM   1039  O   GLU A  64      51.837  36.365  66.490  1.00  0.00           O  
ATOM   1040  CB  GLU A  64      51.330  34.576  69.465  1.00  0.00           C  
ATOM   1041  CG  GLU A  64      52.853  34.424  69.412  1.00  0.00           C  
ATOM   1042  CD  GLU A  64      53.269  33.053  68.895  1.00  0.00           C  
ATOM   1043  OE1 GLU A  64      53.425  32.120  69.707  1.00  0.00           O  
ATOM   1044  OE2 GLU A  64      53.463  32.885  67.664  1.00  0.00           O  
ATOM   1045  H   GLU A  64      48.930  35.133  69.411  1.00  0.00           H  
ATOM   1046  HA  GLU A  64      51.261  36.657  68.934  1.00  0.00           H  
ATOM   1047  HB2 GLU A  64      51.045  34.770  70.500  1.00  0.00           H  
ATOM   1048  HB3 GLU A  64      50.851  33.644  69.162  1.00  0.00           H  
ATOM   1049  HG2 GLU A  64      53.280  35.190  68.775  1.00  0.00           H  
ATOM   1050  HG3 GLU A  64      53.261  34.567  70.413  1.00  0.00           H  
ATOM   1051  N   LYS A  65      50.533  34.521  66.463  1.00  0.00           N  
ATOM   1052  CA  LYS A  65      50.744  34.292  65.036  1.00  0.00           C  
ATOM   1053  C   LYS A  65      50.174  35.423  64.184  1.00  0.00           C  
ATOM   1054  O   LYS A  65      50.665  35.589  63.072  1.00  0.00           O  
ATOM   1055  CB  LYS A  65      50.156  32.941  64.597  1.00  0.00           C  
ATOM   1056  CG  LYS A  65      50.932  31.730  65.138  1.00  0.00           C  
ATOM   1057  CD  LYS A  65      52.081  31.224  64.246  1.00  0.00           C  
ATOM   1058  CE  LYS A  65      53.340  32.101  64.257  1.00  0.00           C  
ATOM   1059  NZ  LYS A  65      54.465  31.452  63.542  1.00  0.00           N  
ATOM   1060  H   LYS A  65      49.939  33.883  66.990  1.00  0.00           H  
ATOM   1061  HA  LYS A  65      51.818  34.282  64.866  1.00  0.00           H  
ATOM   1062  HB2 LYS A  65      49.125  32.887  64.948  1.00  0.00           H  
ATOM   1063  HB3 LYS A  65      50.129  32.889  63.507  1.00  0.00           H  
ATOM   1064  HG2 LYS A  65      51.303  31.952  66.137  1.00  0.00           H  
ATOM   1065  HG3 LYS A  65      50.225  30.908  65.232  1.00  0.00           H  
ATOM   1066  HD2 LYS A  65      52.359  30.233  64.608  1.00  0.00           H  
ATOM   1067  HD3 LYS A  65      51.722  31.119  63.221  1.00  0.00           H  
ATOM   1068  HE2 LYS A  65      53.116  33.058  63.778  1.00  0.00           H  
ATOM   1069  HE3 LYS A  65      53.631  32.285  65.294  1.00  0.00           H  
ATOM   1070  HZ1 LYS A  65      54.304  31.433  62.538  1.00  0.00           H  
ATOM   1071  HZ2 LYS A  65      55.330  31.970  63.677  1.00  0.00           H  
ATOM   1072  HZ3 LYS A  65      54.643  30.509  63.876  1.00  0.00           H  
ATOM   1073  N   LEU A  66      49.192  36.194  64.658  1.00  0.00           N  
ATOM   1074  CA  LEU A  66      48.587  37.311  63.968  1.00  0.00           C  
ATOM   1075  C   LEU A  66      49.625  38.405  63.899  1.00  0.00           C  
ATOM   1076  O   LEU A  66      49.974  38.800  62.792  1.00  0.00           O  
ATOM   1077  CB  LEU A  66      47.298  37.803  64.663  1.00  0.00           C  
ATOM   1078  CG  LEU A  66      46.909  39.226  64.223  1.00  0.00           C  
ATOM   1079  CD1 LEU A  66      46.610  39.255  62.723  1.00  0.00           C  
ATOM   1080  CD2 LEU A  66      45.783  39.819  65.070  1.00  0.00           C  
ATOM   1081  H   LEU A  66      48.803  36.024  65.575  1.00  0.00           H  
ATOM   1082  HA  LEU A  66      48.337  36.996  62.953  1.00  0.00           H  
ATOM   1083  HB2 LEU A  66      46.486  37.110  64.443  1.00  0.00           H  
ATOM   1084  HB3 LEU A  66      47.437  37.823  65.737  1.00  0.00           H  
ATOM   1085  HG  LEU A  66      47.758  39.872  64.407  1.00  0.00           H  
ATOM   1086 HD11 LEU A  66      47.503  38.939  62.181  1.00  0.00           H  
ATOM   1087 HD12 LEU A  66      45.789  38.587  62.472  1.00  0.00           H  
ATOM   1088 HD13 LEU A  66      46.374  40.273  62.414  1.00  0.00           H  
ATOM   1089 HD21 LEU A  66      45.216  40.555  64.500  1.00  0.00           H  
ATOM   1090 HD22 LEU A  66      45.126  39.047  65.473  1.00  0.00           H  
ATOM   1091 HD23 LEU A  66      46.228  40.336  65.921  1.00  0.00           H  
ATOM   1092  N   ARG A  67      50.132  38.899  65.040  1.00  0.00           N  
ATOM   1093  CA  ARG A  67      51.146  39.953  64.973  1.00  0.00           C  
ATOM   1094  C   ARG A  67      52.325  39.459  64.139  1.00  0.00           C  
ATOM   1095  O   ARG A  67      52.906  40.231  63.381  1.00  0.00           O  
ATOM   1096  CB  ARG A  67      51.554  40.487  66.362  1.00  0.00           C  
ATOM   1097  CG  ARG A  67      52.371  39.527  67.249  1.00  0.00           C  
ATOM   1098  CD  ARG A  67      53.043  40.236  68.439  1.00  0.00           C  
ATOM   1099  NE  ARG A  67      52.379  39.967  69.721  1.00  0.00           N  
ATOM   1100  CZ  ARG A  67      51.328  40.619  70.232  1.00  0.00           C  
ATOM   1101  NH1 ARG A  67      50.777  41.655  69.609  1.00  0.00           N  
ATOM   1102  NH2 ARG A  67      50.823  40.226  71.388  1.00  0.00           N  
ATOM   1103  H   ARG A  67      49.820  38.528  65.936  1.00  0.00           H  
ATOM   1104  HA  ARG A  67      50.704  40.792  64.427  1.00  0.00           H  
ATOM   1105  HB2 ARG A  67      52.153  41.381  66.188  1.00  0.00           H  
ATOM   1106  HB3 ARG A  67      50.654  40.790  66.899  1.00  0.00           H  
ATOM   1107  HG2 ARG A  67      51.728  38.723  67.605  1.00  0.00           H  
ATOM   1108  HG3 ARG A  67      53.170  39.090  66.654  1.00  0.00           H  
ATOM   1109  HD2 ARG A  67      54.071  39.877  68.516  1.00  0.00           H  
ATOM   1110  HD3 ARG A  67      53.081  41.309  68.271  1.00  0.00           H  
ATOM   1111  HE  ARG A  67      52.795  39.197  70.243  1.00  0.00           H  
ATOM   1112 HH11 ARG A  67      51.164  42.068  68.767  1.00  0.00           H  
ATOM   1113 HH12 ARG A  67      50.047  42.215  70.047  1.00  0.00           H  
ATOM   1114 HH21 ARG A  67      51.343  39.600  71.999  1.00  0.00           H  
ATOM   1115 HH22 ARG A  67      49.893  40.489  71.701  1.00  0.00           H  
ATOM   1116  N   HIS A  68      52.612  38.153  64.194  1.00  0.00           N  
ATOM   1117  CA  HIS A  68      53.706  37.588  63.416  1.00  0.00           C  
ATOM   1118  C   HIS A  68      53.375  37.480  61.914  1.00  0.00           C  
ATOM   1119  O   HIS A  68      54.289  37.448  61.092  1.00  0.00           O  
ATOM   1120  CB  HIS A  68      54.100  36.232  64.011  1.00  0.00           C  
ATOM   1121  CG  HIS A  68      55.554  35.897  63.818  1.00  0.00           C  
ATOM   1122  ND1 HIS A  68      56.253  35.924  62.633  1.00  0.00           N  
ATOM   1123  CD2 HIS A  68      56.432  35.583  64.817  1.00  0.00           C  
ATOM   1124  CE1 HIS A  68      57.531  35.615  62.910  1.00  0.00           C  
ATOM   1125  NE2 HIS A  68      57.687  35.393  64.230  1.00  0.00           N  
ATOM   1126  H   HIS A  68      52.027  37.566  64.793  1.00  0.00           H  
ATOM   1127  HA  HIS A  68      54.559  38.261  63.524  1.00  0.00           H  
ATOM   1128  HB2 HIS A  68      53.919  36.250  65.083  1.00  0.00           H  
ATOM   1129  HB3 HIS A  68      53.478  35.447  63.588  1.00  0.00           H  
ATOM   1130  HD1 HIS A  68      55.877  36.177  61.720  1.00  0.00           H  
ATOM   1131  HD2 HIS A  68      56.195  35.503  65.869  1.00  0.00           H  
ATOM   1132  HE1 HIS A  68      58.324  35.556  62.176  1.00  0.00           H  
ATOM   1133  N   ALA A  69      52.096  37.373  61.537  1.00  0.00           N  
ATOM   1134  CA  ALA A  69      51.604  37.263  60.167  1.00  0.00           C  
ATOM   1135  C   ALA A  69      51.453  38.639  59.533  1.00  0.00           C  
ATOM   1136  O   ALA A  69      51.780  38.829  58.361  1.00  0.00           O  
ATOM   1137  CB  ALA A  69      50.241  36.562  60.140  1.00  0.00           C  
ATOM   1138  H   ALA A  69      51.387  37.346  62.263  1.00  0.00           H  
ATOM   1139  HA  ALA A  69      52.308  36.678  59.579  1.00  0.00           H  
ATOM   1140  HB1 ALA A  69      49.534  37.072  60.795  1.00  0.00           H  
ATOM   1141  HB2 ALA A  69      49.848  36.596  59.125  1.00  0.00           H  
ATOM   1142  HB3 ALA A  69      50.336  35.523  60.454  1.00  0.00           H  
ATOM   1143  N   GLU A  70      50.963  39.612  60.297  1.00  0.00           N  
ATOM   1144  CA  GLU A  70      50.913  40.980  59.825  1.00  0.00           C  
ATOM   1145  C   GLU A  70      52.356  41.458  59.620  1.00  0.00           C  
ATOM   1146  O   GLU A  70      52.657  42.080  58.608  1.00  0.00           O  
ATOM   1147  CB  GLU A  70      50.100  41.868  60.785  1.00  0.00           C  
ATOM   1148  CG  GLU A  70      48.606  41.648  60.522  1.00  0.00           C  
ATOM   1149  CD  GLU A  70      47.711  42.731  61.120  1.00  0.00           C  
ATOM   1150  OE1 GLU A  70      47.899  43.136  62.289  1.00  0.00           O  
ATOM   1151  OE2 GLU A  70      46.836  43.256  60.389  1.00  0.00           O  
ATOM   1152  H   GLU A  70      50.695  39.412  61.254  1.00  0.00           H  
ATOM   1153  HA  GLU A  70      50.405  40.960  58.855  1.00  0.00           H  
ATOM   1154  HB2 GLU A  70      50.323  41.640  61.831  1.00  0.00           H  
ATOM   1155  HB3 GLU A  70      50.341  42.913  60.582  1.00  0.00           H  
ATOM   1156  HG2 GLU A  70      48.450  41.652  59.444  1.00  0.00           H  
ATOM   1157  HG3 GLU A  70      48.312  40.674  60.906  1.00  0.00           H  
ATOM   1158  N   SER A  71      53.278  41.058  60.506  1.00  0.00           N  
ATOM   1159  CA  SER A  71      54.709  41.296  60.384  1.00  0.00           C  
ATOM   1160  C   SER A  71      55.400  40.464  59.280  1.00  0.00           C  
ATOM   1161  O   SER A  71      56.633  40.442  59.260  1.00  0.00           O  
ATOM   1162  CB  SER A  71      55.363  41.082  61.759  1.00  0.00           C  
ATOM   1163  OG  SER A  71      56.686  41.589  61.799  1.00  0.00           O  
ATOM   1164  H   SER A  71      52.959  40.586  61.345  1.00  0.00           H  
ATOM   1165  HA  SER A  71      54.826  42.345  60.117  1.00  0.00           H  
ATOM   1166  HB2 SER A  71      54.781  41.608  62.516  1.00  0.00           H  
ATOM   1167  HB3 SER A  71      55.378  40.017  61.995  1.00  0.00           H  
ATOM   1168  HG  SER A  71      57.108  41.274  60.980  1.00  0.00           H  
ATOM   1169  N   VAL A  72      54.675  39.790  58.379  1.00  0.00           N  
ATOM   1170  CA  VAL A  72      55.236  39.269  57.125  1.00  0.00           C  
ATOM   1171  C   VAL A  72      54.518  39.860  55.912  1.00  0.00           C  
ATOM   1172  O   VAL A  72      55.176  40.088  54.899  1.00  0.00           O  
ATOM   1173  CB  VAL A  72      55.316  37.723  57.104  1.00  0.00           C  
ATOM   1174  CG1 VAL A  72      54.034  37.002  57.493  1.00  0.00           C  
ATOM   1175  CG2 VAL A  72      55.737  37.171  55.735  1.00  0.00           C  
ATOM   1176  H   VAL A  72      53.667  39.820  58.452  1.00  0.00           H  
ATOM   1177  HA  VAL A  72      56.265  39.623  57.045  1.00  0.00           H  
ATOM   1178  HB  VAL A  72      56.043  37.419  57.854  1.00  0.00           H  
ATOM   1179 HG11 VAL A  72      54.167  35.922  57.442  1.00  0.00           H  
ATOM   1180 HG12 VAL A  72      53.847  37.276  58.519  1.00  0.00           H  
ATOM   1181 HG13 VAL A  72      53.206  37.300  56.850  1.00  0.00           H  
ATOM   1182 HG21 VAL A  72      55.849  36.089  55.782  1.00  0.00           H  
ATOM   1183 HG22 VAL A  72      54.976  37.417  54.988  1.00  0.00           H  
ATOM   1184 HG23 VAL A  72      56.679  37.626  55.430  1.00  0.00           H  
ATOM   1185  N   GLY A  73      53.211  40.139  55.991  1.00  0.00           N  
ATOM   1186  CA  GLY A  73      52.500  40.763  54.879  1.00  0.00           C  
ATOM   1187  C   GLY A  73      51.693  39.787  54.026  1.00  0.00           C  
ATOM   1188  O   GLY A  73      51.133  40.194  53.019  1.00  0.00           O  
ATOM   1189  H   GLY A  73      52.703  39.973  56.850  1.00  0.00           H  
ATOM   1190  HA2 GLY A  73      51.835  41.538  55.260  1.00  0.00           H  
ATOM   1191  HA3 GLY A  73      53.234  41.222  54.217  1.00  0.00           H  
ATOM   1192  N   ASP A  74      51.630  38.508  54.414  1.00  0.00           N  
ATOM   1193  CA  ASP A  74      51.088  37.401  53.611  1.00  0.00           C  
ATOM   1194  C   ASP A  74      49.632  37.590  53.161  1.00  0.00           C  
ATOM   1195  O   ASP A  74      49.209  36.957  52.198  1.00  0.00           O  
ATOM   1196  CB  ASP A  74      51.241  36.113  54.427  1.00  0.00           C  
ATOM   1197  CG  ASP A  74      50.558  34.890  53.809  1.00  0.00           C  
ATOM   1198  OD1 ASP A  74      49.429  34.549  54.235  1.00  0.00           O  
ATOM   1199  OD2 ASP A  74      51.249  34.076  53.166  1.00  0.00           O  
ATOM   1200  H   ASP A  74      52.138  38.275  55.248  1.00  0.00           H  
ATOM   1201  HA  ASP A  74      51.690  37.302  52.707  1.00  0.00           H  
ATOM   1202  HB2 ASP A  74      52.305  35.902  54.554  1.00  0.00           H  
ATOM   1203  HB3 ASP A  74      50.820  36.282  55.421  1.00  0.00           H  
ATOM   1204  N   GLY A  75      48.863  38.459  53.823  1.00  0.00           N  
ATOM   1205  CA  GLY A  75      47.530  38.870  53.402  1.00  0.00           C  
ATOM   1206  C   GLY A  75      46.498  37.782  53.678  1.00  0.00           C  
ATOM   1207  O   GLY A  75      45.687  37.910  54.591  1.00  0.00           O  
ATOM   1208  H   GLY A  75      49.323  39.016  54.523  1.00  0.00           H  
ATOM   1209  HA2 GLY A  75      47.248  39.779  53.931  1.00  0.00           H  
ATOM   1210  HA3 GLY A  75      47.540  39.092  52.333  1.00  0.00           H  
ATOM   1211  N   GLU A  76      46.552  36.688  52.931  1.00  0.00           N  
ATOM   1212  CA  GLU A  76      45.686  35.527  53.052  1.00  0.00           C  
ATOM   1213  C   GLU A  76      45.620  35.055  54.511  1.00  0.00           C  
ATOM   1214  O   GLU A  76      44.527  34.986  55.088  1.00  0.00           O  
ATOM   1215  CB  GLU A  76      46.188  34.458  52.065  1.00  0.00           C  
ATOM   1216  CG  GLU A  76      45.678  33.027  52.283  1.00  0.00           C  
ATOM   1217  CD  GLU A  76      44.178  32.797  52.100  1.00  0.00           C  
ATOM   1218  OE1 GLU A  76      43.377  33.753  52.174  1.00  0.00           O  
ATOM   1219  OE2 GLU A  76      43.798  31.611  51.955  1.00  0.00           O  
ATOM   1220  H   GLU A  76      47.339  36.625  52.291  1.00  0.00           H  
ATOM   1221  HA  GLU A  76      44.683  35.824  52.751  1.00  0.00           H  
ATOM   1222  HB2 GLU A  76      45.946  34.768  51.047  1.00  0.00           H  
ATOM   1223  HB3 GLU A  76      47.274  34.412  52.134  1.00  0.00           H  
ATOM   1224  HG2 GLU A  76      46.204  32.376  51.582  1.00  0.00           H  
ATOM   1225  HG3 GLU A  76      45.949  32.707  53.288  1.00  0.00           H  
ATOM   1226  N   ARG A  77      46.763  34.749  55.142  1.00  0.00           N  
ATOM   1227  CA  ARG A  77      46.737  34.297  56.532  1.00  0.00           C  
ATOM   1228  C   ARG A  77      46.424  35.439  57.494  1.00  0.00           C  
ATOM   1229  O   ARG A  77      45.877  35.154  58.547  1.00  0.00           O  
ATOM   1230  CB  ARG A  77      47.995  33.487  56.907  1.00  0.00           C  
ATOM   1231  CG  ARG A  77      49.199  34.295  57.425  1.00  0.00           C  
ATOM   1232  CD  ARG A  77      50.504  33.480  57.505  1.00  0.00           C  
ATOM   1233  NE  ARG A  77      50.952  33.040  56.176  1.00  0.00           N  
ATOM   1234  CZ  ARG A  77      51.931  32.179  55.878  1.00  0.00           C  
ATOM   1235  NH1 ARG A  77      52.573  31.486  56.813  1.00  0.00           N  
ATOM   1236  NH2 ARG A  77      52.295  32.012  54.611  1.00  0.00           N  
ATOM   1237  H   ARG A  77      47.654  34.808  54.646  1.00  0.00           H  
ATOM   1238  HA  ARG A  77      45.903  33.601  56.611  1.00  0.00           H  
ATOM   1239  HB2 ARG A  77      47.716  32.787  57.694  1.00  0.00           H  
ATOM   1240  HB3 ARG A  77      48.288  32.893  56.042  1.00  0.00           H  
ATOM   1241  HG2 ARG A  77      49.357  35.164  56.791  1.00  0.00           H  
ATOM   1242  HG3 ARG A  77      48.953  34.642  58.427  1.00  0.00           H  
ATOM   1243  HD2 ARG A  77      51.293  34.110  57.926  1.00  0.00           H  
ATOM   1244  HD3 ARG A  77      50.351  32.617  58.151  1.00  0.00           H  
ATOM   1245  HE  ARG A  77      50.428  33.457  55.402  1.00  0.00           H  
ATOM   1246 HH11 ARG A  77      52.348  31.513  57.810  1.00  0.00           H  
ATOM   1247 HH12 ARG A  77      53.267  30.805  56.516  1.00  0.00           H  
ATOM   1248 HH21 ARG A  77      51.908  32.648  53.896  1.00  0.00           H  
ATOM   1249 HH22 ARG A  77      53.013  31.358  54.336  1.00  0.00           H  
ATOM   1250  N   VAL A  78      46.681  36.709  57.155  1.00  0.00           N  
ATOM   1251  CA  VAL A  78      46.289  37.851  57.992  1.00  0.00           C  
ATOM   1252  C   VAL A  78      44.753  37.840  58.131  1.00  0.00           C  
ATOM   1253  O   VAL A  78      44.212  37.959  59.234  1.00  0.00           O  
ATOM   1254  CB  VAL A  78      46.833  39.174  57.406  1.00  0.00           C  
ATOM   1255  CG1 VAL A  78      46.321  40.385  58.198  1.00  0.00           C  
ATOM   1256  CG2 VAL A  78      48.373  39.172  57.407  1.00  0.00           C  
ATOM   1257  H   VAL A  78      46.962  36.899  56.203  1.00  0.00           H  
ATOM   1258  HA  VAL A  78      46.751  37.750  58.979  1.00  0.00           H  
ATOM   1259  HB  VAL A  78      46.498  39.302  56.383  1.00  0.00           H  
ATOM   1260 HG11 VAL A  78      46.540  40.261  59.257  1.00  0.00           H  
ATOM   1261 HG12 VAL A  78      46.786  41.302  57.828  1.00  0.00           H  
ATOM   1262 HG13 VAL A  78      45.243  40.485  58.080  1.00  0.00           H  
ATOM   1263 HG21 VAL A  78      48.745  40.113  56.997  1.00  0.00           H  
ATOM   1264 HG22 VAL A  78      48.741  39.056  58.427  1.00  0.00           H  
ATOM   1265 HG23 VAL A  78      48.754  38.354  56.793  1.00  0.00           H  
ATOM   1266  N   SER A  79      44.048  37.681  57.011  1.00  0.00           N  
ATOM   1267  CA  SER A  79      42.599  37.582  56.973  1.00  0.00           C  
ATOM   1268  C   SER A  79      42.109  36.322  57.690  1.00  0.00           C  
ATOM   1269  O   SER A  79      41.216  36.412  58.529  1.00  0.00           O  
ATOM   1270  CB  SER A  79      42.163  37.647  55.510  1.00  0.00           C  
ATOM   1271  OG  SER A  79      42.590  38.896  54.994  1.00  0.00           O  
ATOM   1272  H   SER A  79      44.523  37.662  56.111  1.00  0.00           H  
ATOM   1273  HA  SER A  79      42.176  38.438  57.498  1.00  0.00           H  
ATOM   1274  HB2 SER A  79      42.634  36.843  54.948  1.00  0.00           H  
ATOM   1275  HB3 SER A  79      41.080  37.561  55.433  1.00  0.00           H  
ATOM   1276  HG  SER A  79      42.505  38.880  54.014  1.00  0.00           H  
ATOM   1277  N   ARG A  80      42.714  35.153  57.445  1.00  0.00           N  
ATOM   1278  CA  ARG A  80      42.253  33.926  58.104  1.00  0.00           C  
ATOM   1279  C   ARG A  80      42.466  33.984  59.616  1.00  0.00           C  
ATOM   1280  O   ARG A  80      41.593  33.543  60.366  1.00  0.00           O  
ATOM   1281  CB  ARG A  80      42.889  32.680  57.472  1.00  0.00           C  
ATOM   1282  CG  ARG A  80      41.787  31.728  56.989  1.00  0.00           C  
ATOM   1283  CD  ARG A  80      42.423  30.527  56.296  1.00  0.00           C  
ATOM   1284  NE  ARG A  80      41.433  29.610  55.711  1.00  0.00           N  
ATOM   1285  CZ  ARG A  80      41.022  28.446  56.223  1.00  0.00           C  
ATOM   1286  NH1 ARG A  80      41.236  28.135  57.499  1.00  0.00           N  
ATOM   1287  NH2 ARG A  80      40.412  27.558  55.453  1.00  0.00           N  
ATOM   1288  H   ARG A  80      43.465  35.123  56.763  1.00  0.00           H  
ATOM   1289  HA  ARG A  80      41.172  33.881  57.950  1.00  0.00           H  
ATOM   1290  HB2 ARG A  80      43.509  32.961  56.621  1.00  0.00           H  
ATOM   1291  HB3 ARG A  80      43.522  32.171  58.200  1.00  0.00           H  
ATOM   1292  HG2 ARG A  80      41.192  31.398  57.836  1.00  0.00           H  
ATOM   1293  HG3 ARG A  80      41.139  32.247  56.283  1.00  0.00           H  
ATOM   1294  HD2 ARG A  80      43.049  30.902  55.486  1.00  0.00           H  
ATOM   1295  HD3 ARG A  80      43.064  29.991  56.999  1.00  0.00           H  
ATOM   1296  HE  ARG A  80      41.191  29.821  54.743  1.00  0.00           H  
ATOM   1297 HH11 ARG A  80      41.448  28.851  58.193  1.00  0.00           H  
ATOM   1298 HH12 ARG A  80      40.982  27.215  57.848  1.00  0.00           H  
ATOM   1299 HH21 ARG A  80      40.180  27.743  54.476  1.00  0.00           H  
ATOM   1300 HH22 ARG A  80      40.052  26.700  55.857  1.00  0.00           H  
ATOM   1301  N   SER A  81      43.575  34.585  60.061  1.00  0.00           N  
ATOM   1302  CA  SER A  81      43.795  34.982  61.438  1.00  0.00           C  
ATOM   1303  C   SER A  81      42.578  35.772  61.928  1.00  0.00           C  
ATOM   1304  O   SER A  81      41.929  35.322  62.872  1.00  0.00           O  
ATOM   1305  CB  SER A  81      45.112  35.772  61.552  1.00  0.00           C  
ATOM   1306  OG  SER A  81      46.242  34.927  61.446  1.00  0.00           O  
ATOM   1307  H   SER A  81      44.295  34.871  59.406  1.00  0.00           H  
ATOM   1308  HA  SER A  81      43.871  34.079  62.048  1.00  0.00           H  
ATOM   1309  HB2 SER A  81      45.168  36.523  60.773  1.00  0.00           H  
ATOM   1310  HB3 SER A  81      45.152  36.292  62.506  1.00  0.00           H  
ATOM   1311  HG  SER A  81      46.289  34.402  62.268  1.00  0.00           H  
ATOM   1312  N   ARG A  82      42.236  36.902  61.294  1.00  0.00           N  
ATOM   1313  CA  ARG A  82      41.100  37.742  61.695  1.00  0.00           C  
ATOM   1314  C   ARG A  82      39.776  36.981  61.753  1.00  0.00           C  
ATOM   1315  O   ARG A  82      38.997  37.190  62.679  1.00  0.00           O  
ATOM   1316  CB  ARG A  82      40.983  38.951  60.752  1.00  0.00           C  
ATOM   1317  CG  ARG A  82      41.662  40.195  61.330  1.00  0.00           C  
ATOM   1318  CD  ARG A  82      41.450  41.386  60.388  1.00  0.00           C  
ATOM   1319  NE  ARG A  82      41.854  42.666  60.995  1.00  0.00           N  
ATOM   1320  CZ  ARG A  82      41.060  43.614  61.517  1.00  0.00           C  
ATOM   1321  NH1 ARG A  82      39.732  43.477  61.570  1.00  0.00           N  
ATOM   1322  NH2 ARG A  82      41.634  44.718  61.975  1.00  0.00           N  
ATOM   1323  H   ARG A  82      42.788  37.201  60.492  1.00  0.00           H  
ATOM   1324  HA  ARG A  82      41.280  38.104  62.705  1.00  0.00           H  
ATOM   1325  HB2 ARG A  82      41.402  38.721  59.773  1.00  0.00           H  
ATOM   1326  HB3 ARG A  82      39.929  39.190  60.621  1.00  0.00           H  
ATOM   1327  HG2 ARG A  82      41.204  40.406  62.293  1.00  0.00           H  
ATOM   1328  HG3 ARG A  82      42.727  40.014  61.471  1.00  0.00           H  
ATOM   1329  HD2 ARG A  82      42.035  41.228  59.482  1.00  0.00           H  
ATOM   1330  HD3 ARG A  82      40.401  41.431  60.104  1.00  0.00           H  
ATOM   1331  HE  ARG A  82      42.848  42.884  60.947  1.00  0.00           H  
ATOM   1332 HH11 ARG A  82      39.294  42.631  61.237  1.00  0.00           H  
ATOM   1333 HH12 ARG A  82      39.116  44.200  61.940  1.00  0.00           H  
ATOM   1334 HH21 ARG A  82      42.637  44.837  61.875  1.00  0.00           H  
ATOM   1335 HH22 ARG A  82      41.107  45.509  62.351  1.00  0.00           H  
ATOM   1336  N   GLU A  83      39.527  36.080  60.813  1.00  0.00           N  
ATOM   1337  CA  GLU A  83      38.283  35.341  60.664  1.00  0.00           C  
ATOM   1338  C   GLU A  83      38.094  34.394  61.852  1.00  0.00           C  
ATOM   1339  O   GLU A  83      37.068  34.433  62.548  1.00  0.00           O  
ATOM   1340  CB  GLU A  83      38.322  34.630  59.297  1.00  0.00           C  
ATOM   1341  CG  GLU A  83      37.206  33.601  59.054  1.00  0.00           C  
ATOM   1342  CD  GLU A  83      37.603  32.175  59.453  1.00  0.00           C  
ATOM   1343  OE1 GLU A  83      38.625  31.655  58.952  1.00  0.00           O  
ATOM   1344  OE2 GLU A  83      36.840  31.516  60.203  1.00  0.00           O  
ATOM   1345  H   GLU A  83      40.240  35.942  60.112  1.00  0.00           H  
ATOM   1346  HA  GLU A  83      37.456  36.051  60.665  1.00  0.00           H  
ATOM   1347  HB2 GLU A  83      38.241  35.399  58.528  1.00  0.00           H  
ATOM   1348  HB3 GLU A  83      39.290  34.145  59.172  1.00  0.00           H  
ATOM   1349  HG2 GLU A  83      36.300  33.903  59.586  1.00  0.00           H  
ATOM   1350  HG3 GLU A  83      36.975  33.591  57.986  1.00  0.00           H  
ATOM   1351  N   LYS A  84      39.093  33.546  62.118  1.00  0.00           N  
ATOM   1352  CA  LYS A  84      39.004  32.617  63.240  1.00  0.00           C  
ATOM   1353  C   LYS A  84      39.103  33.386  64.555  1.00  0.00           C  
ATOM   1354  O   LYS A  84      38.546  32.932  65.552  1.00  0.00           O  
ATOM   1355  CB  LYS A  84      40.089  31.532  63.151  1.00  0.00           C  
ATOM   1356  CG  LYS A  84      39.567  30.105  63.378  1.00  0.00           C  
ATOM   1357  CD  LYS A  84      38.969  29.861  64.772  1.00  0.00           C  
ATOM   1358  CE  LYS A  84      38.850  28.376  65.149  1.00  0.00           C  
ATOM   1359  NZ  LYS A  84      38.294  27.499  64.096  1.00  0.00           N  
ATOM   1360  H   LYS A  84      39.950  33.612  61.574  1.00  0.00           H  
ATOM   1361  HA  LYS A  84      38.024  32.148  63.185  1.00  0.00           H  
ATOM   1362  HB2 LYS A  84      40.546  31.557  62.163  1.00  0.00           H  
ATOM   1363  HB3 LYS A  84      40.865  31.738  63.889  1.00  0.00           H  
ATOM   1364  HG2 LYS A  84      38.817  29.877  62.620  1.00  0.00           H  
ATOM   1365  HG3 LYS A  84      40.409  29.427  63.242  1.00  0.00           H  
ATOM   1366  HD2 LYS A  84      39.602  30.334  65.522  1.00  0.00           H  
ATOM   1367  HD3 LYS A  84      37.999  30.346  64.868  1.00  0.00           H  
ATOM   1368  HE2 LYS A  84      39.848  28.012  65.404  1.00  0.00           H  
ATOM   1369  HE3 LYS A  84      38.224  28.293  66.037  1.00  0.00           H  
ATOM   1370  HZ1 LYS A  84      38.924  27.427  63.300  1.00  0.00           H  
ATOM   1371  HZ2 LYS A  84      38.164  26.565  64.466  1.00  0.00           H  
ATOM   1372  HZ3 LYS A  84      37.392  27.804  63.734  1.00  0.00           H  
ATOM   1373  N   HIS A  85      39.794  34.531  64.567  1.00  0.00           N  
ATOM   1374  CA  HIS A  85      39.929  35.369  65.749  1.00  0.00           C  
ATOM   1375  C   HIS A  85      38.564  35.909  66.140  1.00  0.00           C  
ATOM   1376  O   HIS A  85      38.143  35.698  67.272  1.00  0.00           O  
ATOM   1377  CB  HIS A  85      40.941  36.492  65.500  1.00  0.00           C  
ATOM   1378  CG  HIS A  85      41.277  37.305  66.716  1.00  0.00           C  
ATOM   1379  ND1 HIS A  85      40.470  38.218  67.369  1.00  0.00           N  
ATOM   1380  CD2 HIS A  85      42.485  37.279  67.355  1.00  0.00           C  
ATOM   1381  CE1 HIS A  85      41.173  38.703  68.405  1.00  0.00           C  
ATOM   1382  NE2 HIS A  85      42.414  38.192  68.402  1.00  0.00           N  
ATOM   1383  H   HIS A  85      40.221  34.854  63.700  1.00  0.00           H  
ATOM   1384  HA  HIS A  85      40.298  34.755  66.571  1.00  0.00           H  
ATOM   1385  HB2 HIS A  85      41.865  36.019  65.197  1.00  0.00           H  
ATOM   1386  HB3 HIS A  85      40.631  37.156  64.691  1.00  0.00           H  
ATOM   1387  HD1 HIS A  85      39.491  38.479  67.201  1.00  0.00           H  
ATOM   1388  HD2 HIS A  85      43.340  36.668  67.101  1.00  0.00           H  
ATOM   1389  HE1 HIS A  85      40.797  39.408  69.134  1.00  0.00           H  
ATOM   1390  N   ALA A  86      37.861  36.548  65.204  1.00  0.00           N  
ATOM   1391  CA  ALA A  86      36.522  37.069  65.419  1.00  0.00           C  
ATOM   1392  C   ALA A  86      35.571  35.970  65.877  1.00  0.00           C  
ATOM   1393  O   ALA A  86      34.798  36.196  66.807  1.00  0.00           O  
ATOM   1394  CB  ALA A  86      36.004  37.699  64.128  1.00  0.00           C  
ATOM   1395  H   ALA A  86      38.273  36.686  64.287  1.00  0.00           H  
ATOM   1396  HA  ALA A  86      36.566  37.827  66.203  1.00  0.00           H  
ATOM   1397  HB1 ALA A  86      35.987  36.953  63.330  1.00  0.00           H  
ATOM   1398  HB2 ALA A  86      34.989  38.051  64.296  1.00  0.00           H  
ATOM   1399  HB3 ALA A  86      36.644  38.533  63.847  1.00  0.00           H  
ATOM   1400  N   LEU A  87      35.643  34.788  65.249  1.00  0.00           N  
ATOM   1401  CA  LEU A  87      34.890  33.622  65.710  1.00  0.00           C  
ATOM   1402  C   LEU A  87      35.215  33.317  67.174  1.00  0.00           C  
ATOM   1403  O   LEU A  87      34.288  33.248  67.987  1.00  0.00           O  
ATOM   1404  CB  LEU A  87      35.094  32.442  64.739  1.00  0.00           C  
ATOM   1405  CG  LEU A  87      35.185  31.016  65.312  1.00  0.00           C  
ATOM   1406  CD1 LEU A  87      33.933  30.544  66.063  1.00  0.00           C  
ATOM   1407  CD2 LEU A  87      35.405  30.022  64.168  1.00  0.00           C  
ATOM   1408  H   LEU A  87      36.246  34.705  64.433  1.00  0.00           H  
ATOM   1409  HA  LEU A  87      33.834  33.888  65.671  1.00  0.00           H  
ATOM   1410  HB2 LEU A  87      34.263  32.472  64.037  1.00  0.00           H  
ATOM   1411  HB3 LEU A  87      36.013  32.614  64.180  1.00  0.00           H  
ATOM   1412  HG  LEU A  87      36.058  30.954  65.956  1.00  0.00           H  
ATOM   1413 HD11 LEU A  87      33.993  29.474  66.263  1.00  0.00           H  
ATOM   1414 HD12 LEU A  87      33.835  31.052  67.017  1.00  0.00           H  
ATOM   1415 HD13 LEU A  87      33.046  30.752  65.461  1.00  0.00           H  
ATOM   1416 HD21 LEU A  87      36.195  30.363  63.500  1.00  0.00           H  
ATOM   1417 HD22 LEU A  87      35.664  29.047  64.578  1.00  0.00           H  
ATOM   1418 HD23 LEU A  87      34.491  29.924  63.589  1.00  0.00           H  
ATOM   1419  N   LEU A  88      36.492  33.139  67.526  1.00  0.00           N  
ATOM   1420  CA  LEU A  88      36.880  32.780  68.887  1.00  0.00           C  
ATOM   1421  C   LEU A  88      36.427  33.866  69.877  1.00  0.00           C  
ATOM   1422  O   LEU A  88      35.872  33.512  70.916  1.00  0.00           O  
ATOM   1423  CB  LEU A  88      38.392  32.546  69.014  1.00  0.00           C  
ATOM   1424  CG  LEU A  88      38.949  31.110  68.864  1.00  0.00           C  
ATOM   1425  CD1 LEU A  88      38.081  30.161  68.036  1.00  0.00           C  
ATOM   1426  CD2 LEU A  88      40.358  31.131  68.256  1.00  0.00           C  
ATOM   1427  H   LEU A  88      37.222  33.274  66.832  1.00  0.00           H  
ATOM   1428  HA  LEU A  88      36.388  31.840  69.126  1.00  0.00           H  
ATOM   1429  HB2 LEU A  88      38.921  33.240  68.360  1.00  0.00           H  
ATOM   1430  HB3 LEU A  88      38.625  32.818  70.038  1.00  0.00           H  
ATOM   1431  HG  LEU A  88      39.033  30.671  69.856  1.00  0.00           H  
ATOM   1432 HD11 LEU A  88      38.589  29.206  67.918  1.00  0.00           H  
ATOM   1433 HD12 LEU A  88      37.137  29.973  68.539  1.00  0.00           H  
ATOM   1434 HD13 LEU A  88      37.886  30.626  67.079  1.00  0.00           H  
ATOM   1435 HD21 LEU A  88      40.739  30.117  68.140  1.00  0.00           H  
ATOM   1436 HD22 LEU A  88      40.347  31.636  67.291  1.00  0.00           H  
ATOM   1437 HD23 LEU A  88      41.033  31.667  68.919  1.00  0.00           H  
ATOM   1438  N   GLU A  89      36.627  35.152  69.562  1.00  0.00           N  
ATOM   1439  CA  GLU A  89      36.184  36.296  70.364  1.00  0.00           C  
ATOM   1440  C   GLU A  89      34.660  36.314  70.501  1.00  0.00           C  
ATOM   1441  O   GLU A  89      34.113  36.702  71.534  1.00  0.00           O  
ATOM   1442  CB  GLU A  89      36.651  37.627  69.739  1.00  0.00           C  
ATOM   1443  CG  GLU A  89      38.055  38.063  70.194  1.00  0.00           C  
ATOM   1444  CD  GLU A  89      38.079  39.424  70.916  1.00  0.00           C  
ATOM   1445  OE1 GLU A  89      37.245  39.682  71.815  1.00  0.00           O  
ATOM   1446  OE2 GLU A  89      38.942  40.276  70.600  1.00  0.00           O  
ATOM   1447  H   GLU A  89      37.115  35.366  68.697  1.00  0.00           H  
ATOM   1448  HA  GLU A  89      36.615  36.209  71.357  1.00  0.00           H  
ATOM   1449  HB2 GLU A  89      36.629  37.540  68.653  1.00  0.00           H  
ATOM   1450  HB3 GLU A  89      35.941  38.411  69.996  1.00  0.00           H  
ATOM   1451  HG2 GLU A  89      38.489  37.307  70.843  1.00  0.00           H  
ATOM   1452  HG3 GLU A  89      38.684  38.122  69.309  1.00  0.00           H  
ATOM   1453  N   GLY A  90      33.942  35.912  69.455  1.00  0.00           N  
ATOM   1454  CA  GLY A  90      32.496  35.781  69.486  1.00  0.00           C  
ATOM   1455  C   GLY A  90      32.108  34.768  70.554  1.00  0.00           C  
ATOM   1456  O   GLY A  90      31.251  35.045  71.401  1.00  0.00           O  
ATOM   1457  H   GLY A  90      34.434  35.649  68.605  1.00  0.00           H  
ATOM   1458  HA2 GLY A  90      32.045  36.746  69.717  1.00  0.00           H  
ATOM   1459  HA3 GLY A  90      32.139  35.446  68.514  1.00  0.00           H  
ATOM   1460  N   ARG A  91      32.774  33.611  70.562  1.00  0.00           N  
ATOM   1461  CA  ARG A  91      32.556  32.603  71.584  1.00  0.00           C  
ATOM   1462  C   ARG A  91      33.038  33.091  72.953  1.00  0.00           C  
ATOM   1463  O   ARG A  91      32.388  32.715  73.924  1.00  0.00           O  
ATOM   1464  CB  ARG A  91      33.156  31.253  71.145  1.00  0.00           C  
ATOM   1465  CG  ARG A  91      33.190  30.144  72.220  1.00  0.00           C  
ATOM   1466  CD  ARG A  91      31.842  29.769  72.840  1.00  0.00           C  
ATOM   1467  NE  ARG A  91      30.926  29.121  71.895  1.00  0.00           N  
ATOM   1468  CZ  ARG A  91      29.628  29.416  71.749  1.00  0.00           C  
ATOM   1469  NH1 ARG A  91      29.033  30.300  72.547  1.00  0.00           N  
ATOM   1470  NH2 ARG A  91      28.917  28.800  70.817  1.00  0.00           N  
ATOM   1471  H   ARG A  91      33.483  33.458  69.851  1.00  0.00           H  
ATOM   1472  HA  ARG A  91      31.476  32.468  71.657  1.00  0.00           H  
ATOM   1473  HB2 ARG A  91      32.587  30.890  70.290  1.00  0.00           H  
ATOM   1474  HB3 ARG A  91      34.174  31.417  70.800  1.00  0.00           H  
ATOM   1475  HG2 ARG A  91      33.636  29.251  71.787  1.00  0.00           H  
ATOM   1476  HG3 ARG A  91      33.835  30.460  73.036  1.00  0.00           H  
ATOM   1477  HD2 ARG A  91      32.022  29.085  73.671  1.00  0.00           H  
ATOM   1478  HD3 ARG A  91      31.385  30.672  73.225  1.00  0.00           H  
ATOM   1479  HE  ARG A  91      31.348  28.357  71.365  1.00  0.00           H  
ATOM   1480 HH11 ARG A  91      29.564  30.827  73.218  1.00  0.00           H  
ATOM   1481 HH12 ARG A  91      28.092  30.641  72.331  1.00  0.00           H  
ATOM   1482 HH21 ARG A  91      29.347  28.219  70.105  1.00  0.00           H  
ATOM   1483 HH22 ARG A  91      27.942  29.028  70.652  1.00  0.00           H  
ATOM   1484  N   THR A  92      34.091  33.905  73.100  1.00  0.00           N  
ATOM   1485  CA  THR A  92      34.470  34.359  74.439  1.00  0.00           C  
ATOM   1486  C   THR A  92      33.409  35.308  74.993  1.00  0.00           C  
ATOM   1487  O   THR A  92      32.922  35.081  76.098  1.00  0.00           O  
ATOM   1488  CB  THR A  92      35.897  34.930  74.562  1.00  0.00           C  
ATOM   1489  OG1 THR A  92      36.052  35.976  73.644  1.00  0.00           O  
ATOM   1490  CG2 THR A  92      37.018  33.901  74.346  1.00  0.00           C  
ATOM   1491  H   THR A  92      34.638  34.250  72.319  1.00  0.00           H  
ATOM   1492  HA  THR A  92      34.433  33.492  75.079  1.00  0.00           H  
ATOM   1493  HB  THR A  92      36.010  35.333  75.568  1.00  0.00           H  
ATOM   1494  HG1 THR A  92      36.987  36.285  73.692  1.00  0.00           H  
ATOM   1495 HG21 THR A  92      37.959  34.274  74.752  1.00  0.00           H  
ATOM   1496 HG22 THR A  92      36.798  32.978  74.880  1.00  0.00           H  
ATOM   1497 HG23 THR A  92      37.160  33.715  73.285  1.00  0.00           H  
ATOM   1498  N   LYS A  93      32.969  36.318  74.234  1.00  0.00           N  
ATOM   1499  CA  LYS A  93      31.947  37.261  74.709  1.00  0.00           C  
ATOM   1500  C   LYS A  93      30.665  36.517  75.063  1.00  0.00           C  
ATOM   1501  O   LYS A  93      30.115  36.703  76.148  1.00  0.00           O  
ATOM   1502  CB  LYS A  93      31.714  38.367  73.663  1.00  0.00           C  
ATOM   1503  CG  LYS A  93      31.148  39.685  74.229  1.00  0.00           C  
ATOM   1504  CD  LYS A  93      29.660  39.674  74.626  1.00  0.00           C  
ATOM   1505  CE  LYS A  93      29.416  39.796  76.139  1.00  0.00           C  
ATOM   1506  NZ  LYS A  93      29.716  41.135  76.693  1.00  0.00           N  
ATOM   1507  H   LYS A  93      33.422  36.475  73.337  1.00  0.00           H  
ATOM   1508  HA  LYS A  93      32.330  37.721  75.621  1.00  0.00           H  
ATOM   1509  HB2 LYS A  93      32.677  38.611  73.221  1.00  0.00           H  
ATOM   1510  HB3 LYS A  93      31.076  38.001  72.859  1.00  0.00           H  
ATOM   1511  HG2 LYS A  93      31.760  39.997  75.076  1.00  0.00           H  
ATOM   1512  HG3 LYS A  93      31.265  40.436  73.446  1.00  0.00           H  
ATOM   1513  HD2 LYS A  93      29.153  40.499  74.117  1.00  0.00           H  
ATOM   1514  HD3 LYS A  93      29.197  38.752  74.277  1.00  0.00           H  
ATOM   1515  HE2 LYS A  93      28.360  39.592  76.330  1.00  0.00           H  
ATOM   1516  HE3 LYS A  93      30.007  39.044  76.669  1.00  0.00           H  
ATOM   1517  HZ1 LYS A  93      30.705  41.364  76.692  1.00  0.00           H  
ATOM   1518  HZ2 LYS A  93      29.203  41.872  76.218  1.00  0.00           H  
ATOM   1519  HZ3 LYS A  93      29.385  41.170  77.656  1.00  0.00           H  
ATOM   1520  N   GLU A  94      30.182  35.656  74.167  1.00  0.00           N  
ATOM   1521  CA  GLU A  94      28.928  34.946  74.371  1.00  0.00           C  
ATOM   1522  C   GLU A  94      29.046  33.922  75.496  1.00  0.00           C  
ATOM   1523  O   GLU A  94      28.166  33.880  76.365  1.00  0.00           O  
ATOM   1524  CB  GLU A  94      28.496  34.275  73.067  1.00  0.00           C  
ATOM   1525  CG  GLU A  94      27.141  33.568  73.205  1.00  0.00           C  
ATOM   1526  CD  GLU A  94      26.702  33.055  71.841  1.00  0.00           C  
ATOM   1527  OE1 GLU A  94      26.183  33.861  71.043  1.00  0.00           O  
ATOM   1528  OE2 GLU A  94      26.961  31.869  71.522  1.00  0.00           O  
ATOM   1529  H   GLU A  94      30.661  35.542  73.278  1.00  0.00           H  
ATOM   1530  HA  GLU A  94      28.158  35.671  74.653  1.00  0.00           H  
ATOM   1531  HB2 GLU A  94      28.410  35.045  72.303  1.00  0.00           H  
ATOM   1532  HB3 GLU A  94      29.251  33.550  72.757  1.00  0.00           H  
ATOM   1533  HG2 GLU A  94      27.227  32.730  73.901  1.00  0.00           H  
ATOM   1534  HG3 GLU A  94      26.401  34.273  73.591  1.00  0.00           H  
ATOM   1535  N   LEU A  95      30.088  33.074  75.492  1.00  0.00           N  
ATOM   1536  CA  LEU A  95      30.224  32.076  76.547  1.00  0.00           C  
ATOM   1537  C   LEU A  95      30.402  32.806  77.866  1.00  0.00           C  
ATOM   1538  O   LEU A  95      29.673  32.490  78.793  1.00  0.00           O  
ATOM   1539  CB  LEU A  95      31.352  31.033  76.344  1.00  0.00           C  
ATOM   1540  CG  LEU A  95      31.248  29.788  77.248  1.00  0.00           C  
ATOM   1541  CD1 LEU A  95      31.964  30.000  78.571  1.00  0.00           C  
ATOM   1542  CD2 LEU A  95      29.812  29.307  77.504  1.00  0.00           C  
ATOM   1543  H   LEU A  95      30.854  33.202  74.837  1.00  0.00           H  
ATOM   1544  HA  LEU A  95      29.266  31.559  76.574  1.00  0.00           H  
ATOM   1545  HB2 LEU A  95      31.369  30.634  75.340  1.00  0.00           H  
ATOM   1546  HB3 LEU A  95      32.313  31.523  76.502  1.00  0.00           H  
ATOM   1547  HG  LEU A  95      31.763  28.975  76.734  1.00  0.00           H  
ATOM   1548 HD11 LEU A  95      31.498  30.806  79.122  1.00  0.00           H  
ATOM   1549 HD12 LEU A  95      31.959  29.079  79.156  1.00  0.00           H  
ATOM   1550 HD13 LEU A  95      32.988  30.311  78.415  1.00  0.00           H  
ATOM   1551 HD21 LEU A  95      29.267  30.020  78.121  1.00  0.00           H  
ATOM   1552 HD22 LEU A  95      29.288  29.159  76.560  1.00  0.00           H  
ATOM   1553 HD23 LEU A  95      29.832  28.375  78.054  1.00  0.00           H  
ATOM   1554  N   GLY A  96      31.276  33.810  77.939  1.00  0.00           N  
ATOM   1555  CA  GLY A  96      31.533  34.580  79.143  1.00  0.00           C  
ATOM   1556  C   GLY A  96      30.264  35.182  79.725  1.00  0.00           C  
ATOM   1557  O   GLY A  96      29.999  35.044  80.917  1.00  0.00           O  
ATOM   1558  H   GLY A  96      31.838  34.061  77.132  1.00  0.00           H  
ATOM   1559  HA2 GLY A  96      31.950  33.904  79.877  1.00  0.00           H  
ATOM   1560  HA3 GLY A  96      32.248  35.375  78.929  1.00  0.00           H  
ATOM   1561  N   TYR A  97      29.414  35.764  78.882  1.00  0.00           N  
ATOM   1562  CA  TYR A  97      28.113  36.264  79.300  1.00  0.00           C  
ATOM   1563  C   TYR A  97      27.258  35.126  79.865  1.00  0.00           C  
ATOM   1564  O   TYR A  97      26.628  35.274  80.912  1.00  0.00           O  
ATOM   1565  CB  TYR A  97      27.435  36.942  78.101  1.00  0.00           C  
ATOM   1566  CG  TYR A  97      25.927  36.941  78.188  1.00  0.00           C  
ATOM   1567  CD1 TYR A  97      25.269  37.825  79.061  1.00  0.00           C  
ATOM   1568  CD2 TYR A  97      25.191  35.982  77.469  1.00  0.00           C  
ATOM   1569  CE1 TYR A  97      23.868  37.801  79.163  1.00  0.00           C  
ATOM   1570  CE2 TYR A  97      23.794  35.930  77.587  1.00  0.00           C  
ATOM   1571  CZ  TYR A  97      23.123  36.863  78.413  1.00  0.00           C  
ATOM   1572  OH  TYR A  97      21.766  36.884  78.482  1.00  0.00           O  
ATOM   1573  H   TYR A  97      29.660  35.817  77.900  1.00  0.00           H  
ATOM   1574  HA  TYR A  97      28.251  37.001  80.092  1.00  0.00           H  
ATOM   1575  HB2 TYR A  97      27.797  37.968  78.024  1.00  0.00           H  
ATOM   1576  HB3 TYR A  97      27.715  36.424  77.183  1.00  0.00           H  
ATOM   1577  HD1 TYR A  97      25.851  38.499  79.675  1.00  0.00           H  
ATOM   1578  HD2 TYR A  97      25.698  35.268  76.832  1.00  0.00           H  
ATOM   1579  HE1 TYR A  97      23.362  38.488  79.829  1.00  0.00           H  
ATOM   1580  HE2 TYR A  97      23.264  35.164  77.039  1.00  0.00           H  
ATOM   1581  HH  TYR A  97      21.365  36.347  77.771  1.00  0.00           H  
ATOM   1582  N   THR A  98      27.225  33.989  79.173  1.00  0.00           N  
ATOM   1583  CA  THR A  98      26.409  32.846  79.551  1.00  0.00           C  
ATOM   1584  C   THR A  98      26.902  32.273  80.888  1.00  0.00           C  
ATOM   1585  O   THR A  98      26.088  31.984  81.765  1.00  0.00           O  
ATOM   1586  CB  THR A  98      26.434  31.800  78.426  1.00  0.00           C  
ATOM   1587  OG1 THR A  98      26.109  32.370  77.165  1.00  0.00           O  
ATOM   1588  CG2 THR A  98      25.418  30.686  78.707  1.00  0.00           C  
ATOM   1589  H   THR A  98      27.861  33.894  78.391  1.00  0.00           H  
ATOM   1590  HA  THR A  98      25.384  33.192  79.684  1.00  0.00           H  
ATOM   1591  HB  THR A  98      27.440  31.388  78.360  1.00  0.00           H  
ATOM   1592  HG1 THR A  98      26.841  32.966  76.911  1.00  0.00           H  
ATOM   1593 HG21 THR A  98      25.590  30.248  79.692  1.00  0.00           H  
ATOM   1594 HG22 THR A  98      24.406  31.096  78.666  1.00  0.00           H  
ATOM   1595 HG23 THR A  98      25.521  29.897  77.965  1.00  0.00           H  
ATOM   1596  N   VAL A  99      28.221  32.145  81.060  1.00  0.00           N  
ATOM   1597  CA  VAL A  99      28.884  31.783  82.298  1.00  0.00           C  
ATOM   1598  C   VAL A  99      28.441  32.777  83.351  1.00  0.00           C  
ATOM   1599  O   VAL A  99      27.789  32.328  84.273  1.00  0.00           O  
ATOM   1600  CB  VAL A  99      30.411  31.641  82.088  1.00  0.00           C  
ATOM   1601  CG1 VAL A  99      31.313  31.767  83.327  1.00  0.00           C  
ATOM   1602  CG2 VAL A  99      30.663  30.244  81.505  1.00  0.00           C  
ATOM   1603  H   VAL A  99      28.839  32.420  80.307  1.00  0.00           H  
ATOM   1604  HA  VAL A  99      28.494  30.815  82.600  1.00  0.00           H  
ATOM   1605  HB  VAL A  99      30.735  32.393  81.367  1.00  0.00           H  
ATOM   1606 HG11 VAL A  99      31.143  32.714  83.837  1.00  0.00           H  
ATOM   1607 HG12 VAL A  99      31.168  30.935  84.018  1.00  0.00           H  
ATOM   1608 HG13 VAL A  99      32.359  31.747  83.018  1.00  0.00           H  
ATOM   1609 HG21 VAL A  99      30.039  30.080  80.627  1.00  0.00           H  
ATOM   1610 HG22 VAL A  99      31.714  30.160  81.239  1.00  0.00           H  
ATOM   1611 HG23 VAL A  99      30.451  29.467  82.234  1.00  0.00           H  
ATOM   1612  N   LYS A 100      28.652  34.089  83.204  1.00  0.00           N  
ATOM   1613  CA  LYS A 100      28.253  35.090  84.203  1.00  0.00           C  
ATOM   1614  C   LYS A 100      26.776  34.962  84.595  1.00  0.00           C  
ATOM   1615  O   LYS A 100      26.435  35.122  85.770  1.00  0.00           O  
ATOM   1616  CB  LYS A 100      28.555  36.495  83.649  1.00  0.00           C  
ATOM   1617  CG  LYS A 100      28.370  37.609  84.694  1.00  0.00           C  
ATOM   1618  CD  LYS A 100      26.965  38.238  84.683  1.00  0.00           C  
ATOM   1619  CE  LYS A 100      26.532  38.556  86.115  1.00  0.00           C  
ATOM   1620  NZ  LYS A 100      25.266  39.308  86.175  1.00  0.00           N  
ATOM   1621  H   LYS A 100      29.120  34.407  82.357  1.00  0.00           H  
ATOM   1622  HA  LYS A 100      28.861  34.920  85.101  1.00  0.00           H  
ATOM   1623  HB2 LYS A 100      29.594  36.517  83.314  1.00  0.00           H  
ATOM   1624  HB3 LYS A 100      27.908  36.691  82.792  1.00  0.00           H  
ATOM   1625  HG2 LYS A 100      28.605  37.209  85.682  1.00  0.00           H  
ATOM   1626  HG3 LYS A 100      29.089  38.403  84.489  1.00  0.00           H  
ATOM   1627  HD2 LYS A 100      26.999  39.155  84.093  1.00  0.00           H  
ATOM   1628  HD3 LYS A 100      26.236  37.565  84.232  1.00  0.00           H  
ATOM   1629  HE2 LYS A 100      26.426  37.623  86.674  1.00  0.00           H  
ATOM   1630  HE3 LYS A 100      27.310  39.154  86.590  1.00  0.00           H  
ATOM   1631  HZ1 LYS A 100      25.097  39.568  87.145  1.00  0.00           H  
ATOM   1632  HZ2 LYS A 100      25.319  40.164  85.635  1.00  0.00           H  
ATOM   1633  HZ3 LYS A 100      24.465  38.761  85.869  1.00  0.00           H  
ATOM   1634  N   LYS A 101      25.894  34.703  83.625  1.00  0.00           N  
ATOM   1635  CA  LYS A 101      24.474  34.491  83.868  1.00  0.00           C  
ATOM   1636  C   LYS A 101      24.285  33.302  84.809  1.00  0.00           C  
ATOM   1637  O   LYS A 101      23.760  33.465  85.916  1.00  0.00           O  
ATOM   1638  CB  LYS A 101      23.729  34.276  82.530  1.00  0.00           C  
ATOM   1639  CG  LYS A 101      23.034  35.529  81.981  1.00  0.00           C  
ATOM   1640  CD  LYS A 101      21.855  35.997  82.846  1.00  0.00           C  
ATOM   1641  CE  LYS A 101      20.707  34.980  82.930  1.00  0.00           C  
ATOM   1642  NZ  LYS A 101      19.843  35.248  84.098  1.00  0.00           N  
ATOM   1643  H   LYS A 101      26.240  34.619  82.672  1.00  0.00           H  
ATOM   1644  HA  LYS A 101      24.114  35.384  84.372  1.00  0.00           H  
ATOM   1645  HB2 LYS A 101      24.425  33.925  81.771  1.00  0.00           H  
ATOM   1646  HB3 LYS A 101      22.990  33.487  82.643  1.00  0.00           H  
ATOM   1647  HG2 LYS A 101      23.766  36.333  81.910  1.00  0.00           H  
ATOM   1648  HG3 LYS A 101      22.666  35.320  80.978  1.00  0.00           H  
ATOM   1649  HD2 LYS A 101      22.217  36.219  83.847  1.00  0.00           H  
ATOM   1650  HD3 LYS A 101      21.467  36.923  82.420  1.00  0.00           H  
ATOM   1651  HE2 LYS A 101      20.112  35.043  82.015  1.00  0.00           H  
ATOM   1652  HE3 LYS A 101      21.104  33.967  83.018  1.00  0.00           H  
ATOM   1653  HZ1 LYS A 101      18.986  34.702  84.068  1.00  0.00           H  
ATOM   1654  HZ2 LYS A 101      20.332  35.027  84.965  1.00  0.00           H  
ATOM   1655  HZ3 LYS A 101      19.600  36.233  84.129  1.00  0.00           H  
ATOM   1656  N   HIS A 102      24.694  32.114  84.363  1.00  0.00           N  
ATOM   1657  CA  HIS A 102      24.562  30.892  85.139  1.00  0.00           C  
ATOM   1658  C   HIS A 102      25.330  30.996  86.457  1.00  0.00           C  
ATOM   1659  O   HIS A 102      24.885  30.439  87.444  1.00  0.00           O  
ATOM   1660  CB  HIS A 102      25.028  29.682  84.315  1.00  0.00           C  
ATOM   1661  CG  HIS A 102      23.938  28.752  83.846  1.00  0.00           C  
ATOM   1662  ND1 HIS A 102      23.996  27.966  82.716  1.00  0.00           N  
ATOM   1663  CD2 HIS A 102      22.799  28.407  84.528  1.00  0.00           C  
ATOM   1664  CE1 HIS A 102      22.926  27.160  82.726  1.00  0.00           C  
ATOM   1665  NE2 HIS A 102      22.156  27.409  83.798  1.00  0.00           N  
ATOM   1666  H   HIS A 102      25.159  32.055  83.463  1.00  0.00           H  
ATOM   1667  HA  HIS A 102      23.509  30.775  85.390  1.00  0.00           H  
ATOM   1668  HB2 HIS A 102      25.572  30.035  83.441  1.00  0.00           H  
ATOM   1669  HB3 HIS A 102      25.717  29.086  84.914  1.00  0.00           H  
ATOM   1670  HD1 HIS A 102      24.722  27.930  82.004  1.00  0.00           H  
ATOM   1671  HD2 HIS A 102      22.477  28.767  85.497  1.00  0.00           H  
ATOM   1672  HE1 HIS A 102      22.719  26.403  81.979  1.00  0.00           H  
ATOM   1673  N   LEU A 103      26.429  31.747  86.507  1.00  0.00           N  
ATOM   1674  CA  LEU A 103      27.196  32.094  87.695  1.00  0.00           C  
ATOM   1675  C   LEU A 103      26.246  32.656  88.720  1.00  0.00           C  
ATOM   1676  O   LEU A 103      26.014  32.019  89.740  1.00  0.00           O  
ATOM   1677  CB  LEU A 103      28.312  33.102  87.368  1.00  0.00           C  
ATOM   1678  CG  LEU A 103      29.709  32.553  87.624  1.00  0.00           C  
ATOM   1679  CD1 LEU A 103      30.074  31.392  86.692  1.00  0.00           C  
ATOM   1680  CD2 LEU A 103      30.743  33.661  87.463  1.00  0.00           C  
ATOM   1681  H   LEU A 103      26.774  32.111  85.630  1.00  0.00           H  
ATOM   1682  HA  LEU A 103      27.636  31.198  88.121  1.00  0.00           H  
ATOM   1683  HB2 LEU A 103      28.249  33.398  86.339  1.00  0.00           H  
ATOM   1684  HB3 LEU A 103      28.188  34.006  87.965  1.00  0.00           H  
ATOM   1685  HG  LEU A 103      29.729  32.232  88.650  1.00  0.00           H  
ATOM   1686 HD11 LEU A 103      29.471  30.519  86.917  1.00  0.00           H  
ATOM   1687 HD12 LEU A 103      29.890  31.688  85.667  1.00  0.00           H  
ATOM   1688 HD13 LEU A 103      31.122  31.109  86.807  1.00  0.00           H  
ATOM   1689 HD21 LEU A 103      30.517  34.474  88.154  1.00  0.00           H  
ATOM   1690 HD22 LEU A 103      31.729  33.264  87.696  1.00  0.00           H  
ATOM   1691 HD23 LEU A 103      30.734  34.033  86.439  1.00  0.00           H  
ATOM   1692  N   GLN A 104      25.634  33.802  88.420  1.00  0.00           N  
ATOM   1693  CA  GLN A 104      24.708  34.413  89.354  1.00  0.00           C  
ATOM   1694  C   GLN A 104      23.499  33.520  89.632  1.00  0.00           C  
ATOM   1695  O   GLN A 104      22.961  33.594  90.737  1.00  0.00           O  
ATOM   1696  CB  GLN A 104      24.279  35.798  88.851  1.00  0.00           C  
ATOM   1697  CG  GLN A 104      24.814  36.864  89.810  1.00  0.00           C  
ATOM   1698  CD  GLN A 104      24.368  38.257  89.400  1.00  0.00           C  
ATOM   1699  OE1 GLN A 104      25.159  39.039  88.880  1.00  0.00           O  
ATOM   1700  NE2 GLN A 104      23.105  38.592  89.579  1.00  0.00           N  
ATOM   1701  H   GLN A 104      25.822  34.248  87.527  1.00  0.00           H  
ATOM   1702  HA  GLN A 104      25.241  34.524  90.301  1.00  0.00           H  
ATOM   1703  HB2 GLN A 104      24.659  35.988  87.846  1.00  0.00           H  
ATOM   1704  HB3 GLN A 104      23.191  35.858  88.818  1.00  0.00           H  
ATOM   1705  HG2 GLN A 104      24.449  36.657  90.816  1.00  0.00           H  
ATOM   1706  HG3 GLN A 104      25.905  36.826  89.823  1.00  0.00           H  
ATOM   1707 HE21 GLN A 104      22.482  37.917  90.026  1.00  0.00           H  
ATOM   1708 HE22 GLN A 104      22.779  39.517  89.325  1.00  0.00           H  
ATOM   1709  N   ASP A 105      23.090  32.679  88.673  1.00  0.00           N  
ATOM   1710  CA  ASP A 105      21.941  31.805  88.872  1.00  0.00           C  
ATOM   1711  C   ASP A 105      22.286  30.720  89.904  1.00  0.00           C  
ATOM   1712  O   ASP A 105      21.717  30.700  90.993  1.00  0.00           O  
ATOM   1713  CB  ASP A 105      21.447  31.244  87.527  1.00  0.00           C  
ATOM   1714  CG  ASP A 105      19.993  30.765  87.569  1.00  0.00           C  
ATOM   1715  OD1 ASP A 105      19.421  30.591  88.664  1.00  0.00           O  
ATOM   1716  OD2 ASP A 105      19.409  30.558  86.475  1.00  0.00           O  
ATOM   1717  H   ASP A 105      23.609  32.591  87.800  1.00  0.00           H  
ATOM   1718  HA  ASP A 105      21.136  32.417  89.280  1.00  0.00           H  
ATOM   1719  HB2 ASP A 105      21.509  32.025  86.769  1.00  0.00           H  
ATOM   1720  HB3 ASP A 105      22.085  30.420  87.211  1.00  0.00           H  
ATOM   1721  N   LEU A 106      23.263  29.861  89.609  1.00  0.00           N  
ATOM   1722  CA  LEU A 106      23.723  28.757  90.449  1.00  0.00           C  
ATOM   1723  C   LEU A 106      24.284  29.279  91.775  1.00  0.00           C  
ATOM   1724  O   LEU A 106      23.994  28.703  92.814  1.00  0.00           O  
ATOM   1725  CB  LEU A 106      24.768  27.908  89.700  1.00  0.00           C  
ATOM   1726  CG  LEU A 106      24.211  26.892  88.682  1.00  0.00           C  
ATOM   1727  CD1 LEU A 106      23.366  27.490  87.564  1.00  0.00           C  
ATOM   1728  CD2 LEU A 106      25.400  26.220  87.999  1.00  0.00           C  
ATOM   1729  H   LEU A 106      23.751  29.988  88.731  1.00  0.00           H  
ATOM   1730  HA  LEU A 106      22.875  28.114  90.675  1.00  0.00           H  
ATOM   1731  HB2 LEU A 106      25.451  28.581  89.190  1.00  0.00           H  
ATOM   1732  HB3 LEU A 106      25.354  27.333  90.424  1.00  0.00           H  
ATOM   1733  HG  LEU A 106      23.600  26.154  89.189  1.00  0.00           H  
ATOM   1734 HD11 LEU A 106      23.066  26.686  86.891  1.00  0.00           H  
ATOM   1735 HD12 LEU A 106      22.463  27.944  87.968  1.00  0.00           H  
ATOM   1736 HD13 LEU A 106      23.967  28.208  87.014  1.00  0.00           H  
ATOM   1737 HD21 LEU A 106      25.045  25.431  87.333  1.00  0.00           H  
ATOM   1738 HD22 LEU A 106      25.961  26.966  87.434  1.00  0.00           H  
ATOM   1739 HD23 LEU A 106      26.049  25.785  88.757  1.00  0.00           H  
ATOM   1740  N   SER A 107      25.035  30.385  91.781  1.00  0.00           N  
ATOM   1741  CA  SER A 107      25.446  31.090  92.999  1.00  0.00           C  
ATOM   1742  C   SER A 107      24.203  31.398  93.830  1.00  0.00           C  
ATOM   1743  O   SER A 107      24.178  31.080  95.021  1.00  0.00           O  
ATOM   1744  CB  SER A 107      26.212  32.372  92.630  1.00  0.00           C  
ATOM   1745  OG  SER A 107      26.471  33.237  93.724  1.00  0.00           O  
ATOM   1746  H   SER A 107      25.230  30.811  90.882  1.00  0.00           H  
ATOM   1747  HA  SER A 107      26.096  30.432  93.581  1.00  0.00           H  
ATOM   1748  HB2 SER A 107      27.155  32.107  92.150  1.00  0.00           H  
ATOM   1749  HB3 SER A 107      25.602  32.942  91.928  1.00  0.00           H  
ATOM   1750  HG  SER A 107      27.147  32.847  94.325  1.00  0.00           H  
ATOM   1751  N   GLY A 108      23.170  31.972  93.204  1.00  0.00           N  
ATOM   1752  CA  GLY A 108      21.868  32.207  93.798  1.00  0.00           C  
ATOM   1753  C   GLY A 108      21.351  30.959  94.507  1.00  0.00           C  
ATOM   1754  O   GLY A 108      21.115  30.992  95.719  1.00  0.00           O  
ATOM   1755  H   GLY A 108      23.243  32.208  92.219  1.00  0.00           H  
ATOM   1756  HA2 GLY A 108      21.937  33.038  94.495  1.00  0.00           H  
ATOM   1757  HA3 GLY A 108      21.163  32.480  93.010  1.00  0.00           H  
ATOM   1758  N   ARG A 109      21.172  29.864  93.762  1.00  0.00           N  
ATOM   1759  CA  ARG A 109      20.492  28.669  94.220  1.00  0.00           C  
ATOM   1760  C   ARG A 109      21.347  27.972  95.270  1.00  0.00           C  
ATOM   1761  O   ARG A 109      20.909  27.803  96.405  1.00  0.00           O  
ATOM   1762  CB  ARG A 109      20.194  27.751  93.021  1.00  0.00           C  
ATOM   1763  CG  ARG A 109      19.398  28.364  91.865  1.00  0.00           C  
ATOM   1764  CD  ARG A 109      19.333  27.345  90.726  1.00  0.00           C  
ATOM   1765  NE  ARG A 109      18.978  27.965  89.444  1.00  0.00           N  
ATOM   1766  CZ  ARG A 109      18.589  27.299  88.354  1.00  0.00           C  
ATOM   1767  NH1 ARG A 109      18.482  25.975  88.376  1.00  0.00           N  
ATOM   1768  NH2 ARG A 109      18.316  27.979  87.242  1.00  0.00           N  
ATOM   1769  H   ARG A 109      21.505  29.832  92.806  1.00  0.00           H  
ATOM   1770  HA  ARG A 109      19.548  28.960  94.679  1.00  0.00           H  
ATOM   1771  HB2 ARG A 109      21.135  27.359  92.631  1.00  0.00           H  
ATOM   1772  HB3 ARG A 109      19.596  26.926  93.376  1.00  0.00           H  
ATOM   1773  HG2 ARG A 109      18.392  28.624  92.193  1.00  0.00           H  
ATOM   1774  HG3 ARG A 109      19.895  29.254  91.505  1.00  0.00           H  
ATOM   1775  HD2 ARG A 109      20.313  26.882  90.605  1.00  0.00           H  
ATOM   1776  HD3 ARG A 109      18.604  26.570  90.979  1.00  0.00           H  
ATOM   1777  HE  ARG A 109      19.081  28.980  89.376  1.00  0.00           H  
ATOM   1778 HH11 ARG A 109      18.900  25.439  89.144  1.00  0.00           H  
ATOM   1779 HH12 ARG A 109      18.013  25.419  87.665  1.00  0.00           H  
ATOM   1780 HH21 ARG A 109      18.564  28.972  87.175  1.00  0.00           H  
ATOM   1781 HH22 ARG A 109      18.150  27.475  86.368  1.00  0.00           H  
ATOM   1782  N   ILE A 110      22.577  27.587  94.941  1.00  0.00           N  
ATOM   1783  CA  ILE A 110      23.449  26.817  95.824  1.00  0.00           C  
ATOM   1784  C   ILE A 110      23.716  27.579  97.119  1.00  0.00           C  
ATOM   1785  O   ILE A 110      23.915  26.940  98.154  1.00  0.00           O  
ATOM   1786  CB  ILE A 110      24.753  26.441  95.084  1.00  0.00           C  
ATOM   1787  CG1 ILE A 110      24.369  25.550  93.870  1.00  0.00           C  
ATOM   1788  CG2 ILE A 110      25.793  25.769  95.999  1.00  0.00           C  
ATOM   1789  CD1 ILE A 110      25.476  24.671  93.273  1.00  0.00           C  
ATOM   1790  H   ILE A 110      22.925  27.794  94.009  1.00  0.00           H  
ATOM   1791  HA  ILE A 110      22.928  25.895  96.089  1.00  0.00           H  
ATOM   1792  HB  ILE A 110      25.211  27.374  94.750  1.00  0.00           H  
ATOM   1793 HG12 ILE A 110      23.568  24.872  94.168  1.00  0.00           H  
ATOM   1794 HG13 ILE A 110      23.966  26.188  93.079  1.00  0.00           H  
ATOM   1795 HG21 ILE A 110      26.100  26.450  96.790  1.00  0.00           H  
ATOM   1796 HG22 ILE A 110      25.378  24.862  96.434  1.00  0.00           H  
ATOM   1797 HG23 ILE A 110      26.687  25.517  95.433  1.00  0.00           H  
ATOM   1798 HD11 ILE A 110      26.364  25.252  93.047  1.00  0.00           H  
ATOM   1799 HD12 ILE A 110      25.714  23.868  93.982  1.00  0.00           H  
ATOM   1800 HD13 ILE A 110      25.126  24.249  92.331  1.00  0.00           H  
ATOM   1801  N   SER A 111      23.699  28.918  97.113  1.00  0.00           N  
ATOM   1802  CA  SER A 111      23.968  29.625  98.351  1.00  0.00           C  
ATOM   1803  C   SER A 111      22.838  29.498  99.381  1.00  0.00           C  
ATOM   1804  O   SER A 111      23.124  29.604 100.579  1.00  0.00           O  
ATOM   1805  CB  SER A 111      24.397  31.068  98.106  1.00  0.00           C  
ATOM   1806  OG  SER A 111      25.561  31.058  97.303  1.00  0.00           O  
ATOM   1807  H   SER A 111      23.543  29.447  96.262  1.00  0.00           H  
ATOM   1808  HA  SER A 111      24.827  29.109  98.757  1.00  0.00           H  
ATOM   1809  HB2 SER A 111      23.598  31.616  97.610  1.00  0.00           H  
ATOM   1810  HB3 SER A 111      24.625  31.544  99.058  1.00  0.00           H  
ATOM   1811  HG  SER A 111      25.216  31.133  96.390  1.00  0.00           H  
ATOM   1812  N   ARG A 112      21.590  29.225  98.966  1.00  0.00           N  
ATOM   1813  CA  ARG A 112      20.620  28.614  99.877  1.00  0.00           C  
ATOM   1814  C   ARG A 112      20.923  27.138 100.031  1.00  0.00           C  
ATOM   1815  O   ARG A 112      21.040  26.681 101.168  1.00  0.00           O  
ATOM   1816  CB  ARG A 112      19.142  28.841  99.497  1.00  0.00           C  
ATOM   1817  CG  ARG A 112      18.702  28.802  98.031  1.00  0.00           C  
ATOM   1818  CD  ARG A 112      17.257  29.302  97.868  1.00  0.00           C  
ATOM   1819  NE  ARG A 112      16.802  29.240  96.467  1.00  0.00           N  
ATOM   1820  CZ  ARG A 112      17.151  30.079  95.482  1.00  0.00           C  
ATOM   1821  NH1 ARG A 112      18.006  31.072  95.681  1.00  0.00           N  
ATOM   1822  NH2 ARG A 112      16.650  29.940  94.266  1.00  0.00           N  
ATOM   1823  H   ARG A 112      21.419  29.151  97.968  1.00  0.00           H  
ATOM   1824  HA  ARG A 112      20.747  29.049 100.869  1.00  0.00           H  
ATOM   1825  HB2 ARG A 112      18.561  28.079 100.009  1.00  0.00           H  
ATOM   1826  HB3 ARG A 112      18.857  29.803  99.901  1.00  0.00           H  
ATOM   1827  HG2 ARG A 112      19.354  29.443  97.443  1.00  0.00           H  
ATOM   1828  HG3 ARG A 112      18.761  27.779  97.664  1.00  0.00           H  
ATOM   1829  HD2 ARG A 112      16.595  28.685  98.473  1.00  0.00           H  
ATOM   1830  HD3 ARG A 112      17.185  30.333  98.224  1.00  0.00           H  
ATOM   1831  HE  ARG A 112      15.969  28.684  96.281  1.00  0.00           H  
ATOM   1832 HH11 ARG A 112      18.468  31.246  96.573  1.00  0.00           H  
ATOM   1833 HH12 ARG A 112      18.158  31.769  94.948  1.00  0.00           H  
ATOM   1834 HH21 ARG A 112      15.960  29.227  94.013  1.00  0.00           H  
ATOM   1835 HH22 ARG A 112      16.864  30.651  93.562  1.00  0.00           H  
ATOM   1836  N   ALA A 113      21.008  26.429  98.900  1.00  0.00           N  
ATOM   1837  CA  ALA A 113      20.827  24.993  98.763  1.00  0.00           C  
ATOM   1838  C   ALA A 113      19.551  24.589  99.504  1.00  0.00           C  
ATOM   1839  O   ALA A 113      19.546  24.320 100.703  1.00  0.00           O  
ATOM   1840  CB  ALA A 113      22.093  24.228  99.141  1.00  0.00           C  
ATOM   1841  H   ALA A 113      20.956  26.950  98.033  1.00  0.00           H  
ATOM   1842  HA  ALA A 113      20.668  24.791  97.708  1.00  0.00           H  
ATOM   1843  HB1 ALA A 113      22.415  24.510 100.142  1.00  0.00           H  
ATOM   1844  HB2 ALA A 113      21.872  23.163  99.119  1.00  0.00           H  
ATOM   1845  HB3 ALA A 113      22.886  24.447  98.416  1.00  0.00           H  
ATOM   1846  N   ARG A 114      18.426  24.708  98.792  1.00  0.00           N  
ATOM   1847  CA  ARG A 114      17.079  24.757  99.349  1.00  0.00           C  
ATOM   1848  C   ARG A 114      16.747  23.489 100.140  1.00  0.00           C  
ATOM   1849  O   ARG A 114      16.716  23.587 101.361  1.00  0.00           O  
ATOM   1850  CB  ARG A 114      16.049  25.103  98.259  1.00  0.00           C  
ATOM   1851  CG  ARG A 114      14.876  25.968  98.731  1.00  0.00           C  
ATOM   1852  CD  ARG A 114      14.137  25.502  99.997  1.00  0.00           C  
ATOM   1853  NE  ARG A 114      14.764  26.041 101.221  1.00  0.00           N  
ATOM   1854  CZ  ARG A 114      14.162  26.233 102.399  1.00  0.00           C  
ATOM   1855  NH1 ARG A 114      12.977  25.696 102.665  1.00  0.00           N  
ATOM   1856  NH2 ARG A 114      14.755  26.994 103.308  1.00  0.00           N  
ATOM   1857  H   ARG A 114      18.534  24.889  97.804  1.00  0.00           H  
ATOM   1858  HA  ARG A 114      17.096  25.578 100.058  1.00  0.00           H  
ATOM   1859  HB2 ARG A 114      16.539  25.673  97.469  1.00  0.00           H  
ATOM   1860  HB3 ARG A 114      15.665  24.190  97.809  1.00  0.00           H  
ATOM   1861  HG2 ARG A 114      15.243  26.982  98.884  1.00  0.00           H  
ATOM   1862  HG3 ARG A 114      14.163  26.006  97.908  1.00  0.00           H  
ATOM   1863  HD2 ARG A 114      13.115  25.882  99.945  1.00  0.00           H  
ATOM   1864  HD3 ARG A 114      14.094  24.413 100.025  1.00  0.00           H  
ATOM   1865  HE  ARG A 114      15.690  26.435 101.105  1.00  0.00           H  
ATOM   1866 HH11 ARG A 114      12.647  24.935 102.066  1.00  0.00           H  
ATOM   1867 HH12 ARG A 114      12.522  25.799 103.555  1.00  0.00           H  
ATOM   1868 HH21 ARG A 114      15.682  27.379 103.121  1.00  0.00           H  
ATOM   1869 HH22 ARG A 114      14.268  27.372 104.115  1.00  0.00           H  
ATOM   1870  N   HIS A 115      16.494  22.353  99.475  1.00  0.00           N  
ATOM   1871  CA  HIS A 115      16.376  20.988 100.021  1.00  0.00           C  
ATOM   1872  C   HIS A 115      15.692  20.042  99.027  1.00  0.00           C  
ATOM   1873  O   HIS A 115      16.120  18.896  98.903  1.00  0.00           O  
ATOM   1874  CB  HIS A 115      15.687  20.868 101.403  1.00  0.00           C  
ATOM   1875  CG  HIS A 115      14.315  21.497 101.516  1.00  0.00           C  
ATOM   1876  ND1 HIS A 115      13.143  20.992 101.004  1.00  0.00           N  
ATOM   1877  CD2 HIS A 115      14.004  22.653 102.179  1.00  0.00           C  
ATOM   1878  CE1 HIS A 115      12.160  21.863 101.285  1.00  0.00           C  
ATOM   1879  NE2 HIS A 115      12.638  22.901 101.992  1.00  0.00           N  
ATOM   1880  H   HIS A 115      16.521  22.401  98.467  1.00  0.00           H  
ATOM   1881  HA  HIS A 115      17.394  20.619 100.155  1.00  0.00           H  
ATOM   1882  HB2 HIS A 115      15.590  19.809 101.643  1.00  0.00           H  
ATOM   1883  HB3 HIS A 115      16.338  21.284 102.171  1.00  0.00           H  
ATOM   1884  HD1 HIS A 115      13.020  20.082 100.560  1.00  0.00           H  
ATOM   1885  HD2 HIS A 115      14.697  23.270 102.733  1.00  0.00           H  
ATOM   1886  HE1 HIS A 115      11.123  21.732 101.000  1.00  0.00           H  
ATOM   1887  N   ASN A 116      14.649  20.473  98.309  1.00  0.00           N  
ATOM   1888  CA  ASN A 116      13.877  19.605  97.408  1.00  0.00           C  
ATOM   1889  C   ASN A 116      14.219  19.970  95.975  1.00  0.00           C  
ATOM   1890  O   ASN A 116      13.334  20.352  95.208  1.00  0.00           O  
ATOM   1891  CB  ASN A 116      12.361  19.702  97.666  1.00  0.00           C  
ATOM   1892  CG  ASN A 116      11.869  18.926  98.875  1.00  0.00           C  
ATOM   1893  OD1 ASN A 116      12.646  18.504  99.728  1.00  0.00           O  
ATOM   1894  ND2 ASN A 116      10.566  18.769  99.002  1.00  0.00           N  
ATOM   1895  H   ASN A 116      14.347  21.435  98.387  1.00  0.00           H  
ATOM   1896  HA  ASN A 116      14.160  18.566  97.537  1.00  0.00           H  
ATOM   1897  HB2 ASN A 116      12.063  20.748  97.742  1.00  0.00           H  
ATOM   1898  HB3 ASN A 116      11.849  19.265  96.807  1.00  0.00           H  
ATOM   1899 HD21 ASN A 116       9.957  19.161  98.276  1.00  0.00           H  
ATOM   1900 HD22 ASN A 116      10.193  18.209  99.748  1.00  0.00           H  
ATOM   1901  N   GLU A 117      15.506  19.899  95.618  1.00  0.00           N  
ATOM   1902  CA  GLU A 117      16.030  20.651  94.475  1.00  0.00           C  
ATOM   1903  C   GLU A 117      15.722  22.157  94.692  1.00  0.00           C  
ATOM   1904  O   GLU A 117      15.301  22.535  95.801  1.00  0.00           O  
ATOM   1905  CB  GLU A 117      15.613  19.929  93.173  1.00  0.00           C  
ATOM   1906  CG  GLU A 117      15.940  20.637  91.857  1.00  0.00           C  
ATOM   1907  CD  GLU A 117      14.822  21.552  91.346  1.00  0.00           C  
ATOM   1908  OE1 GLU A 117      13.621  21.253  91.553  1.00  0.00           O  
ATOM   1909  OE2 GLU A 117      15.160  22.556  90.678  1.00  0.00           O  
ATOM   1910  H   GLU A 117      16.183  19.576  96.291  1.00  0.00           H  
ATOM   1911  HA  GLU A 117      17.117  20.578  94.503  1.00  0.00           H  
ATOM   1912  HB2 GLU A 117      16.157  18.981  93.168  1.00  0.00           H  
ATOM   1913  HB3 GLU A 117      14.560  19.656  93.189  1.00  0.00           H  
ATOM   1914  HG2 GLU A 117      16.859  21.207  91.978  1.00  0.00           H  
ATOM   1915  HG3 GLU A 117      16.132  19.870  91.109  1.00  0.00           H  
ATOM   1916  N   LEU A 118      16.131  23.052  93.784  1.00  0.00           N  
ATOM   1917  CA  LEU A 118      16.329  24.467  94.099  1.00  0.00           C  
ATOM   1918  C   LEU A 118      15.412  25.315  93.237  1.00  0.00           C  
ATOM   1919  O   LEU A 118      14.179  25.228  93.426  1.00  0.00           O  
ATOM   1920  CB  LEU A 118      17.816  24.881  93.978  1.00  0.00           C  
ATOM   1921  CG  LEU A 118      18.898  24.038  94.692  1.00  0.00           C  
ATOM   1922  CD1 LEU A 118      20.109  24.901  95.054  1.00  0.00           C  
ATOM   1923  CD2 LEU A 118      18.424  23.396  96.002  1.00  0.00           C  
ATOM   1924  H   LEU A 118      16.424  22.760  92.858  1.00  0.00           H  
ATOM   1925  HA  LEU A 118      16.013  24.657  95.121  1.00  0.00           H  
ATOM   1926  HB2 LEU A 118      18.079  24.905  92.917  1.00  0.00           H  
ATOM   1927  HB3 LEU A 118      17.863  25.907  94.341  1.00  0.00           H  
ATOM   1928  HG  LEU A 118      19.226  23.256  94.016  1.00  0.00           H  
ATOM   1929 HD11 LEU A 118      20.865  24.292  95.548  1.00  0.00           H  
ATOM   1930 HD12 LEU A 118      20.584  25.270  94.144  1.00  0.00           H  
ATOM   1931 HD13 LEU A 118      19.792  25.726  95.694  1.00  0.00           H  
ATOM   1932 HD21 LEU A 118      17.983  22.433  95.784  1.00  0.00           H  
ATOM   1933 HD22 LEU A 118      19.257  23.199  96.674  1.00  0.00           H  
ATOM   1934 HD23 LEU A 118      17.672  24.018  96.456  1.00  0.00           H  
TER    1935      LEU A 118                                                      
END
MOLECULE T0496.pdb
ATOM      1  N   PRO     4      36.250  18.877 100.419  1.00126.33           N  
ATOM      2  CA  PRO     4      36.001  19.915  99.413  1.00124.51           C  
ATOM      3  C   PRO     4      37.048  21.022  99.469  1.00125.13           C  
ATOM      4  O   PRO     4      38.211  20.787  99.138  1.00127.61           O  
ATOM      5  CB  PRO     4      34.632  20.466  99.818  1.00125.32           C  
ATOM      6  CG  PRO     4      33.962  19.327 100.500  1.00121.87           C  
ATOM      7  CD  PRO     4      35.049  18.581 101.220  1.00130.35           C  
ATOM      8  N   VAL     5      36.635  22.214  99.886  1.00119.84           N  
ATOM      9  CA  VAL     5      37.466  23.415  99.734  1.00107.77           C  
ATOM     10  C   VAL     5      38.099  23.855 101.061  1.00100.94           C  
ATOM     11  O   VAL     5      37.438  23.869 102.102  1.00 94.89           O  
ATOM     12  CB  VAL     5      36.652  24.587  99.107  1.00107.75           C  
ATOM     13  CG1 VAL     5      37.577  25.679  98.576  1.00 88.65           C  
ATOM     14  CG2 VAL     5      35.760  24.081  97.980  1.00101.53           C  
ATOM     15  N   SER     6      39.384  24.211 101.004  1.00 99.68           N  
ATOM     16  CA  SER     6      40.148  24.635 102.180  1.00 91.17           C  
ATOM     17  C   SER     6      40.377  26.152 102.243  1.00 85.27           C  
ATOM     18  O   SER     6      40.045  26.881 101.305  1.00 80.81           O  
ATOM     19  CB  SER     6      41.485  23.887 102.244  1.00 92.89           C  
ATOM     20  OG  SER     6      42.256  24.108 101.075  1.00 94.88           O  
ATOM     21  N   VAL     7      40.955  26.603 103.357  1.00 77.69           N  
ATOM     22  CA  VAL     7      41.146  28.027 103.663  1.00 67.00           C  
ATOM     23  C   VAL     7      42.287  28.655 102.855  1.00 73.76           C  
ATOM     24  O   VAL     7      42.125  29.739 102.284  1.00 70.86           O  
ATOM     25  CB  VAL     7      41.386  28.239 105.189  1.00 56.84           C  
ATOM     26  CG1 VAL     7      41.504  29.720 105.535  1.00 44.52           C  
ATOM     27  CG2 VAL     7      40.260  27.609 105.996  1.00 60.50           C  
ATOM     28  N   ASN     8      43.429  27.964 102.811  1.00 79.15           N  
ATOM     29  CA  ASN     8      44.614  28.407 102.064  1.00 82.93           C  
ATOM     30  C   ASN     8      44.353  28.483 100.565  1.00 82.41           C  
ATOM     31  O   ASN     8      44.933  29.314  99.868  1.00 69.82           O  
ATOM     32  CB  ASN     8      45.797  27.466 102.313  1.00 88.19           C  
ATOM     33  CG  ASN     8      45.839  26.934 103.733  1.00114.21           C  
ATOM     34  OD1 ASN     8      46.100  27.681 104.683  1.00130.04           O  
ATOM     35  ND2 ASN     8      45.591  25.630 103.881  1.00130.36           N  
ATOM     36  N   GLU     9      43.480  27.595 100.092  1.00 83.32           N  
ATOM     37  CA  GLU     9      43.007  27.568  98.713  1.00 85.50           C  
ATOM     38  C   GLU     9      42.250  28.849  98.365  1.00 71.59           C  
ATOM     39  O   GLU     9      42.421  29.397  97.276  1.00 49.75           O  
ATOM     40  CB  GLU     9      42.100  26.354  98.514  1.00 91.21           C  
ATOM     41  CG  GLU     9      41.941  25.894  97.075  1.00105.16           C  
ATOM     42  CD  GLU     9      41.154  24.600  96.967  1.00104.81           C  
ATOM     43  OE1 GLU     9      41.478  23.634  97.694  1.00128.20           O  
ATOM     44  OE2 GLU     9      40.215  24.543  96.146  1.00128.75           O  
ATOM     45  N   LYS    10      41.422  29.316  99.301  1.00 64.67           N  
ATOM     46  CA  LYS    10      40.664  30.558  99.143  1.00 50.06           C  
ATOM     47  C   LYS    10      41.562  31.786  99.278  1.00 55.22           C  
ATOM     48  O   LYS    10      41.451  32.721  98.484  1.00 39.45           O  
ATOM     49  CB  LYS    10      39.520  30.630 100.159  1.00 46.21           C  
ATOM     50  CG  LYS    10      38.442  29.572  99.977  1.00 55.81           C  
ATOM     51  CD  LYS    10      37.454  29.599 101.131  1.00 24.13           C  
ATOM     52  CE  LYS    10      36.592  28.342 101.154  1.00 39.89           C  
ATOM     53  NZ  LYS    10      35.728  28.288 102.368  1.00 67.89           N  
ATOM     54  N   LYS    11      42.441  31.767 100.285  1.00 48.64           N  
ATOM     55  CA  LYS    11      43.408  32.842 100.546  1.00 45.25           C  
ATOM     56  C   LYS    11      44.308  33.122  99.349  1.00 49.17           C  
ATOM     57  O   LYS    11      44.501  34.277  98.962  1.00 43.86           O  
ATOM     58  CB  LYS    11      44.301  32.484 101.735  1.00 39.85           C  
ATOM     59  CG  LYS    11      43.695  32.691 103.103  1.00 57.76           C  
ATOM     60  CD  LYS    11      44.805  32.720 104.140  1.00  5.48           C  
ATOM     61  CE  LYS    11      44.286  32.363 105.520  1.00 66.84           C  
ATOM     62  NZ  LYS    11      45.381  32.369 106.532  1.00 74.77           N  
ATOM     63  N   ASP    12      44.853  32.051  98.775  1.00 52.53           N  
ATOM     64  CA  ASP    12      45.754  32.147  97.633  1.00 66.79           C  
ATOM     65  C   ASP    12      45.012  32.497  96.345  1.00 62.97           C  
ATOM     66  O   ASP    12      45.597  33.094  95.440  1.00 55.08           O  
ATOM     67  CB  ASP    12      46.544  30.850  97.456  1.00 73.82           C  
ATOM     68  CG  ASP    12      47.718  31.008  96.517  1.00102.22           C  
ATOM     69  OD1 ASP    12      47.613  30.542  95.362  1.00130.59           O  
ATOM     70  OD2 ASP    12      48.736  31.612  96.923  1.00119.67           O  
ATOM     71  N   PHE    13      43.734  32.119  96.267  1.00 66.99           N  
ATOM     72  CA  PHE    13      42.888  32.486  95.130  1.00 56.84           C  
ATOM     73  C   PHE    13      42.672  33.996  95.059  1.00 54.17           C  
ATOM     74  O   PHE    13      42.798  34.584  93.985  1.00 38.21           O  
ATOM     75  CB  PHE    13      41.537  31.755  95.161  1.00 35.95           C  
ATOM     76  CG  PHE    13      40.511  32.338  94.224  1.00 61.09           C  
ATOM     77  CD1 PHE    13      40.651  32.202  92.844  1.00 70.08           C  
ATOM     78  CD2 PHE    13      39.413  33.037  94.720  1.00 81.31           C  
ATOM     79  CE1 PHE    13      39.715  32.753  91.977  1.00 61.10           C  
ATOM     80  CE2 PHE    13      38.471  33.588  93.858  1.00 74.91           C  
ATOM     81  CZ  PHE    13      38.622  33.444  92.486  1.00 61.44           C  
ATOM     82  N   VAL    14      42.344  34.606  96.199  1.00 49.01           N  
ATOM     83  CA  VAL    14      42.154  36.059  96.301  1.00 48.53           C  
ATOM     84  C   VAL    14      43.472  36.787  96.023  1.00 51.26           C  
ATOM     85  O   VAL    14      43.491  37.814  95.335  1.00 35.61           O  
ATOM     86  CB  VAL    14      41.587  36.474  97.689  1.00 49.32           C  
ATOM     87  CG1 VAL    14      41.388  37.982  97.783  1.00 40.40           C  
ATOM     88  CG2 VAL    14      40.276  35.779  97.958  1.00 45.96           C  
ATOM     89  N   LYS    15      44.565  36.228  96.546  1.00 53.00           N  
ATOM     90  CA  LYS    15      45.920  36.723  96.294  1.00 57.32           C  
ATOM     91  C   LYS    15      46.273  36.674  94.803  1.00 57.75           C  
ATOM     92  O   LYS    15      46.907  37.596  94.283  1.00 61.78           O  
ATOM     93  CB  LYS    15      46.940  35.919  97.110  1.00 54.99           C  
ATOM     94  CG  LYS    15      48.342  36.520  97.148  1.00 70.96           C  
ATOM     95  CD  LYS    15      49.350  35.544  97.737  1.00 94.48           C  
ATOM     96  CE  LYS    15      50.767  36.092  97.648  1.00102.05           C  
ATOM     97  NZ  LYS    15      51.775  35.124  98.168  1.00 93.67           N  
ATOM     98  N   TRP    16      45.853  35.603  94.126  1.00 58.07           N  
ATOM     99  CA  TRP    16      46.032  35.474  92.679  1.00 64.97           C  
ATOM    100  C   TRP    16      45.142  36.446  91.907  1.00 55.53           C  
ATOM    101  O   TRP    16      45.617  37.138  91.003  1.00 49.84           O  
ATOM    102  CB  TRP    16      45.759  34.038  92.213  1.00 77.49           C  
ATOM    103  CG  TRP    16      45.646  33.907  90.716  1.00 93.75           C  
ATOM    104  CD1 TRP    16      46.675  33.872  89.818  1.00 94.66           C  
ATOM    105  CD2 TRP    16      44.438  33.804  89.946  1.00110.74           C  
ATOM    106  NE1 TRP    16      46.186  33.752  88.539  1.00 85.41           N  
ATOM    107  CE2 TRP    16      44.817  33.709  88.588  1.00106.09           C  
ATOM    108  CE3 TRP    16      43.073  33.788  90.272  1.00108.96           C  
ATOM    109  CZ2 TRP    16      43.882  33.593  87.554  1.00 92.48           C  
ATOM    110  CZ3 TRP    16      42.143  33.670  89.243  1.00 88.27           C  
ATOM    111  CH2 TRP    16      42.554  33.575  87.900  1.00 91.46           C  
ATOM    112  N   PHE    17      43.857  36.477  92.268  1.00 52.15           N  
ATOM    113  CA  PHE    17      42.840  37.278  91.577  1.00 46.03           C  
ATOM    114  C   PHE    17      43.159  38.772  91.558  1.00 45.00           C  
ATOM    115  O   PHE    17      43.011  39.429  90.525  1.00 39.80           O  
ATOM    116  CB  PHE    17      41.450  37.032  92.190  1.00 37.75           C  
ATOM    117  CG  PHE    17      40.401  38.012  91.736  1.00 44.98           C  
ATOM    118  CD1 PHE    17      39.874  37.940  90.451  1.00 34.59           C  
ATOM    119  CD2 PHE    17      39.940  39.008  92.595  1.00 52.39           C  
ATOM    120  CE1 PHE    17      38.912  38.849  90.024  1.00 36.78           C  
ATOM    121  CE2 PHE    17      38.978  39.920  92.176  1.00 46.87           C  
ATOM    122  CZ  PHE    17      38.461  39.839  90.888  1.00 46.11           C  
ATOM    123  N   LEU    18      43.600  39.292  92.702  1.00 48.42           N  
ATOM    124  CA  LEU    18      43.920  40.713  92.846  1.00 54.75           C  
ATOM    125  C   LEU    18      45.206  41.112  92.125  1.00 64.57           C  
ATOM    126  O   LEU    18      45.377  42.274  91.748  1.00 70.78           O  
ATOM    127  CB  LEU    18      44.001  41.100  94.327  1.00 53.04           C  
ATOM    128  CG  LEU    18      42.683  41.160  95.107  1.00 47.69           C  
ATOM    129  CD1 LEU    18      42.960  41.302  96.595  1.00 23.90           C  
ATOM    130  CD2 LEU    18      41.809  42.310  94.614  1.00 37.79           C  
ATOM    131  N   ASN    19      46.100  40.145  91.934  1.00 71.72           N  
ATOM    132  CA  ASN    19      47.373  40.376  91.254  1.00 74.85           C  
ATOM    133  C   ASN    19      47.278  40.265  89.729  1.00 67.96           C  
ATOM    134  O   ASN    19      48.226  40.604  89.015  1.00 75.30           O  
ATOM    135  CB  ASN    19      48.447  39.421  91.793  1.00 75.25           C  
ATOM    136  CG  ASN    19      49.049  39.894  93.110  1.00105.13           C  
ATOM    137  OD1 ASN    19      50.229  40.248  93.166  1.00124.46           O  
ATOM    138  ND2 ASN    19      48.242  39.905  94.174  1.00113.30           N  
ATOM    139  N   ASN    20      46.130  39.801  89.239  1.00 68.40           N  
ATOM    140  CA  ASN    20      45.927  39.568  87.810  1.00 67.61           C  
ATOM    141  C   ASN    20      44.795  40.397  87.201  1.00 72.51           C  
ATOM    142  O   ASN    20      44.790  40.656  85.994  1.00 70.43           O  
ATOM    143  CB  ASN    20      45.693  38.077  87.538  1.00 59.20           C  
ATOM    144  CG  ASN    20      46.964  37.248  87.658  1.00 75.65           C  
ATOM    145  OD1 ASN    20      47.535  36.826  86.652  1.00101.51           O  
ATOM    146  ND2 ASN    20      47.412  37.011  88.887  1.00 92.03           N  
ATOM    147  N   TYR    21      43.845  40.809  88.038  1.00 72.03           N  
ATOM    148  CA  TYR    21      42.660  41.533  87.576  1.00 63.08           C  
ATOM    149  C   TYR    21      42.437  42.823  88.360  1.00 62.42           C  
ATOM    150  O   TYR    21      42.660  42.873  89.573  1.00 73.78           O  
ATOM    151  CB  TYR    21      41.415  40.639  87.653  1.00 66.80           C  
ATOM    152  CG  TYR    21      41.537  39.350  86.866  1.00 63.40           C  
ATOM    153  CD1 TYR    21      41.920  38.163  87.492  1.00 63.16           C  
ATOM    154  CD2 TYR    21      41.280  39.319  85.495  1.00 52.50           C  
ATOM    155  CE1 TYR    21      42.041  36.979  86.775  1.00 62.89           C  
ATOM    156  CE2 TYR    21      41.398  38.137  84.769  1.00 69.94           C  
ATOM    157  CZ  TYR    21      41.780  36.973  85.416  1.00 76.20           C  
ATOM    158  OH  TYR    21      41.898  35.800  84.708  1.00 81.40           O  
ATOM    159  N   GLN    22      41.995  43.861  87.653  1.00 51.11           N  
ATOM    160  CA  GLN    22      41.745  45.169  88.250  1.00 52.42           C  
ATOM    161  C   GLN    22      40.249  45.389  88.468  1.00 57.96           C  
ATOM    162  O   GLN    22      39.487  45.488  87.504  1.00 53.40           O  
ATOM    163  CB  GLN    22      42.336  46.276  87.365  1.00 47.18           C  
ATOM    164  CG  GLN    22      42.085  47.709  87.842  1.00 69.65           C  
ATOM    165  CD  GLN    22      43.001  48.131  88.978  1.00102.66           C  
ATOM    166  OE1 GLN    22      42.801  47.750  90.132  1.00106.07           O  
ATOM    167  NE2 GLN    22      44.004  48.940  88.656  1.00112.87           N  
ATOM    168  N   LEU    23      39.844  45.461  89.735  1.00 57.15           N  
ATOM    169  CA  LEU    23      38.442  45.683  90.103  1.00 50.60           C  
ATOM    170  C   LEU    23      37.989  47.107  89.782  1.00 48.31           C  
ATOM    171  O   LEU    23      38.782  48.049  89.859  1.00 46.36           O  
ATOM    172  CB  LEU    23      38.205  45.361  91.586  1.00 37.08           C  
ATOM    173  CG  LEU    23      38.211  43.888  92.022  1.00 29.17           C  
ATOM    174  CD1 LEU    23      38.286  43.767  93.536  1.00 27.93           C  
ATOM    175  CD2 LEU    23      36.996  43.131  91.492  1.00 49.92           C  
ATOM    176  N   LYS    24      36.715  47.242  89.409  1.00 42.88           N  
ATOM    177  CA  LYS    24      36.118  48.529  89.034  1.00 60.04           C  
ATOM    178  C   LYS    24      36.082  49.526  90.187  1.00 66.54           C  
ATOM    179  O   LYS    24      36.366  50.712  90.000  1.00 67.76           O  
ATOM    180  CB  LYS    24      34.702  48.329  88.489  1.00 60.30           C  
ATOM    181  CG  LYS    24      34.637  48.073  86.999  1.00 65.66           C  
ATOM    182  CD  LYS    24      33.203  47.933  86.519  1.00 74.26           C  
ATOM    183  CE  LYS    24      33.144  47.745  85.013  1.00 60.22           C  
ATOM    184  NZ  LYS    24      31.741  47.687  84.520  1.00 63.42           N  
ATOM    185  N   GLN    25      35.730  49.037  91.372  1.00 64.06           N  
ATOM    186  CA  GLN    25      35.673  49.873  92.562  1.00 54.75           C  
ATOM    187  C   GLN    25      36.805  49.501  93.519  1.00 55.82           C  
ATOM    188  O   GLN    25      37.046  48.321  93.786  1.00 55.35           O  
ATOM    189  CB  GLN    25      34.301  49.761  93.229  1.00 61.23           C  
ATOM    190  CG  GLN    25      33.994  50.859  94.234  1.00 68.73           C  
ATOM    191  CD  GLN    25      32.516  51.197  94.290  1.00 73.24           C  
ATOM    192  OE1 GLN    25      31.818  50.831  95.235  1.00103.95           O  
ATOM    193  NE2 GLN    25      32.030  51.896  93.268  1.00 97.79           N  
ATOM    194  N   ARG    26      37.491  50.529  94.014  1.00 40.57           N  
ATOM    195  CA  ARG    26      38.721  50.380  94.795  1.00 27.79           C  
ATOM    196  C   ARG    26      38.507  49.778  96.185  1.00 33.96           C  
ATOM    197  O   ARG    26      39.371  49.067  96.700  1.00 47.26           O  
ATOM    198  CB  ARG    26      39.425  51.735  94.905  1.00 25.04           C  
ATOM    199  CG  ARG    26      40.865  51.676  95.394  1.00 27.91           C  
ATOM    200  CD  ARG    26      41.569  53.000  95.184  1.00 53.62           C  
ATOM    201  NE  ARG    26      40.876  54.113  95.832  1.00 72.82           N  
ATOM    202  CZ  ARG    26      41.003  55.383  95.462  1.00 63.56           C  
ATOM    203  NH1 ARG    26      41.793  55.698  94.445  1.00 19.76           N  
ATOM    204  NH2 ARG    26      40.339  56.336  96.103  1.00 56.62           N  
ATOM    205  N   GLU    27      37.352  50.059  96.782  1.00 24.81           N  
ATOM    206  CA  GLU    27      37.032  49.564  98.126  1.00 28.34           C  
ATOM    207  C   GLU    27      36.711  48.069  98.165  1.00 20.31           C  
ATOM    208  O   GLU    27      36.733  47.457  99.232  1.00  8.99           O  
ATOM    209  CB  GLU    27      35.923  50.398  98.793  1.00 15.34           C  
ATOM    210  CG  GLU    27      35.043  51.220  97.848  1.00 60.22           C  
ATOM    211  CD  GLU    27      35.609  52.602  97.542  1.00 74.48           C  
ATOM    212  OE1 GLU    27      35.664  52.969  96.349  1.00 78.12           O  
ATOM    213  OE2 GLU    27      36.002  53.317  98.489  1.00 62.62           O  
ATOM    214  N   CYS    28      36.439  47.490  96.996  1.00  3.93           N  
ATOM    215  CA  CYS    28      36.234  46.049  96.841  1.00 36.87           C  
ATOM    216  C   CYS    28      37.543  45.272  96.980  1.00 39.48           C  
ATOM    217  O   CYS    28      37.543  44.112  97.402  1.00 40.62           O  
ATOM    218  CB  CYS    28      35.604  45.752  95.483  1.00 32.52           C  
ATOM    219  SG  CYS    28      34.088  46.672  95.157  1.00 64.11           S  
ATOM    220  N   VAL    29      38.647  45.920  96.603  1.00 26.07           N  
ATOM    221  CA  VAL    29      40.000  45.398  96.811  1.00 33.41           C  
ATOM    222  C   VAL    29      40.289  45.353  98.313  1.00 40.89           C  
ATOM    223  O   VAL    29      40.858  44.381  98.816  1.00 29.88           O  
ATOM    224  CB  VAL    29      41.071  46.276  96.090  1.00 18.96           C  
ATOM    225  CG1 VAL    29      42.470  45.681  96.219  1.00 42.64           C  
ATOM    226  CG2 VAL    29      40.717  46.479  94.621  1.00 12.99           C  
ATOM    227  N   TRP    30      39.866  46.402  99.018  1.00 35.56           N  
ATOM    228  CA  TRP    30      40.076  46.520 100.461  1.00 28.30           C  
ATOM    229  C   TRP    30      39.164  45.602 101.267  1.00 34.00           C  
ATOM    230  O   TRP    30      39.520  45.204 102.376  1.00 24.65           O  
ATOM    231  CB  TRP    30      39.916  47.971 100.929  1.00 19.25           C  
ATOM    232  CG  TRP    30      40.816  48.950 100.224  1.00 39.94           C  
ATOM    233  CD1 TRP    30      42.044  48.696  99.675  1.00 32.48           C  
ATOM    234  CD2 TRP    30      40.568  50.347 100.017  1.00 35.28           C  
ATOM    235  NE1 TRP    30      42.563  49.839  99.122  1.00 33.05           N  
ATOM    236  CE2 TRP    30      41.683  50.870  99.323  1.00 36.64           C  
ATOM    237  CE3 TRP    30      39.512  51.207 100.348  1.00  9.12           C  
ATOM    238  CZ2 TRP    30      41.772  52.215  98.952  1.00 32.40           C  
ATOM    239  CZ3 TRP    30      39.600  52.546  99.976  1.00 19.31           C  
ATOM    240  CH2 TRP    30      40.723  53.035  99.285  1.00 42.28           C  
ATOM    241  N   ILE    31      37.991  45.286 100.712  1.00 32.16           N  
ATOM    242  CA  ILE    31      37.098  44.271 101.279  1.00 29.88           C  
ATOM    243  C   ILE    31      37.771  42.895 101.188  1.00 29.23           C  
ATOM    244  O   ILE    31      37.806  42.149 102.170  1.00 29.23           O  
ATOM    245  CB  ILE    31      35.701  44.267 100.576  1.00 37.41           C  
ATOM    246  CG1 ILE    31      34.868  45.475 101.018  1.00 31.27           C  
ATOM    247  CG2 ILE    31      34.924  42.980 100.874  1.00  2.00           C  
ATOM    248  CD1 ILE    31      33.747  45.854 100.060  1.00 38.02           C  
ATOM    249  N   LEU    32      38.329  42.591 100.015  1.00 36.37           N  
ATOM    250  CA  LEU    32      39.024  41.323  99.766  1.00 28.05           C  
ATOM    251  C   LEU    32      40.318  41.163 100.564  1.00 32.19           C  
ATOM    252  O   LEU    32      40.619  40.065 101.043  1.00 25.56           O  
ATOM    253  CB  LEU    32      39.316  41.145  98.272  1.00 11.59           C  
ATOM    254  CG  LEU    32      38.190  40.639  97.368  1.00 40.82           C  
ATOM    255  CD1 LEU    32      38.606  40.702  95.907  1.00 31.11           C  
ATOM    256  CD2 LEU    32      37.744  39.224  97.735  1.00 16.32           C  
ATOM    257  N   ASN    33      41.076  42.253 100.694  1.00 33.88           N  
ATOM    258  CA  ASN    33      42.309  42.269 101.487  1.00 41.02           C  
ATOM    259  C   ASN    33      42.045  42.119 102.982  1.00 48.35           C  
ATOM    260  O   ASN    33      42.861  41.544 103.708  1.00 42.87           O  
ATOM    261  CB  ASN    33      43.105  43.553 101.236  1.00 38.12           C  
ATOM    262  CG  ASN    33      43.837  43.545  99.906  1.00 28.78           C  
ATOM    263  OD1 ASN    33      44.367  42.520  99.475  1.00 60.55           O  
ATOM    264  ND2 ASN    33      43.887  44.702  99.258  1.00 57.45           N  
ATOM    265  N   TYR    34      40.908  42.656 103.427  1.00 42.24           N  
ATOM    266  CA  TYR    34      40.432  42.500 104.800  1.00 36.83           C  
ATOM    267  C   TYR    34      40.098  41.038 105.079  1.00 23.18           C  
ATOM    268  O   TYR    34      40.462  40.503 106.126  1.00 16.66           O  
ATOM    269  CB  TYR    34      39.197  43.378 105.027  1.00 41.90           C  
ATOM    270  CG  TYR    34      38.520  43.229 106.374  1.00 22.34           C  
ATOM    271  CD1 TYR    34      38.973  43.939 107.484  1.00 28.54           C  
ATOM    272  CD2 TYR    34      37.408  42.398 106.533  1.00 27.86           C  
ATOM    273  CE1 TYR    34      38.350  43.812 108.720  1.00  4.43           C  
ATOM    274  CE2 TYR    34      36.781  42.262 107.766  1.00 43.11           C  
ATOM    275  CZ  TYR    34      37.257  42.972 108.855  1.00 35.09           C  
ATOM    276  OH  TYR    34      36.639  42.845 110.078  1.00 54.06           O  
ATOM    277  N   LEU    35      39.403  40.407 104.134  1.00 24.05           N  
ATOM    278  CA  LEU    35      38.988  39.012 104.264  1.00 40.94           C  
ATOM    279  C   LEU    35      40.166  38.045 104.184  1.00 38.13           C  
ATOM    280  O   LEU    35      40.156  37.005 104.841  1.00 37.34           O  
ATOM    281  CB  LEU    35      37.922  38.662 103.220  1.00 42.89           C  
ATOM    282  CG  LEU    35      36.547  39.306 103.438  1.00 42.92           C  
ATOM    283  CD1 LEU    35      35.752  39.347 102.143  1.00 49.87           C  
ATOM    284  CD2 LEU    35      35.763  38.605 104.543  1.00 59.35           C  
ATOM    285  N   MET    36      41.175  38.399 103.385  1.00 34.40           N  
ATOM    286  CA  MET    36      42.427  37.636 103.305  1.00 46.16           C  
ATOM    287  C   MET    36      43.219  37.656 104.610  1.00 50.13           C  
ATOM    288  O   MET    36      43.874  36.672 104.960  1.00 60.87           O  
ATOM    289  CB  MET    36      43.315  38.160 102.175  1.00 42.82           C  
ATOM    290  CG  MET    36      43.368  37.261 100.955  1.00 48.71           C  
ATOM    291  SD  MET    36      44.881  37.467  99.986  1.00 60.10           S  
ATOM    292  CE  MET    36      44.640  39.097  99.278  1.00 16.43           C  
ATOM    293  N   SER    37      43.153  38.781 105.317  1.00 42.11           N  
ATOM    294  CA  SER    37      43.859  38.960 106.582  1.00 36.76           C  
ATOM    295  C   SER    37      43.206  38.197 107.734  1.00 37.15           C  
ATOM    296  O   SER    37      43.880  37.823 108.697  1.00 53.92           O  
ATOM    297  CB  SER    37      43.943  40.445 106.928  1.00 18.16           C  
ATOM    298  OG  SER    37      44.692  40.659 108.113  1.00 32.55           O  
ATOM    299  N   HIS    38      41.899  37.971 107.629  1.00 44.07           N  
ATOM    300  CA  HIS    38      41.138  37.305 108.681  1.00 38.86           C  
ATOM    301  C   HIS    38      40.825  35.861 108.290  1.00 42.18           C  
ATOM    302  O   HIS    38      39.936  35.604 107.473  1.00 55.60           O  
ATOM    303  CB  HIS    38      39.861  38.094 108.994  1.00 26.86           C  
ATOM    304  CG  HIS    38      40.118  39.468 109.535  1.00 33.91           C  
ATOM    305  ND1 HIS    38      40.550  40.511 108.745  1.00 26.80           N  
ATOM    306  CD2 HIS    38      40.005  39.969 110.788  1.00 16.28           C  
ATOM    307  CE1 HIS    38      40.698  41.592 109.488  1.00 39.50           C  
ATOM    308  NE2 HIS    38      40.369  41.292 110.731  1.00 34.08           N  
ATOM    309  N   ASP    39      41.570  34.926 108.877  1.00 42.22           N  
ATOM    310  CA  ASP    39      41.487  33.505 108.508  1.00 57.50           C  
ATOM    311  C   ASP    39      40.239  32.755 108.989  1.00 50.55           C  
ATOM    312  O   ASP    39      39.903  31.705 108.434  1.00 54.74           O  
ATOM    313  CB  ASP    39      42.773  32.732 108.877  1.00 58.09           C  
ATOM    314  CG  ASP    39      43.669  33.483 109.855  1.00101.47           C  
ATOM    315  OD1 ASP    39      44.908  33.492 109.630  1.00113.01           O  
ATOM    316  OD2 ASP    39      43.151  34.059 110.842  1.00137.21           O  
ATOM    317  N   GLN    40      39.555  33.273 110.007  1.00 52.26           N  
ATOM    318  CA  GLN    40      38.258  32.696 110.392  1.00 59.48           C  
ATOM    319  C   GLN    40      37.060  33.448 109.802  1.00 61.27           C  
ATOM    320  O   GLN    40      35.904  33.139 110.110  1.00 51.95           O  
ATOM    321  CB  GLN    40      38.134  32.455 111.912  1.00 52.01           C  
ATOM    322  CG  GLN    40      38.868  33.458 112.809  1.00 76.20           C  
ATOM    323  CD  GLN    40      39.624  32.719 113.944  1.00 91.61           C  
ATOM    324  OE1 GLN    40      40.507  33.294 114.589  1.00 83.79           O  
ATOM    325  NE2 GLN    40      39.287  31.442 114.185  1.00106.56           N  
ATOM    326  N   LEU    41      37.353  34.431 108.953  1.00 66.52           N  
ATOM    327  CA  LEU    41      36.367  34.944 108.006  1.00 67.80           C  
ATOM    328  C   LEU    41      36.392  34.058 106.766  1.00 70.55           C  
ATOM    329  O   LEU    41      35.342  33.755 106.197  1.00 75.93           O  
ATOM    330  CB  LEU    41      36.654  36.403 107.621  1.00 78.53           C  
ATOM    331  CG  LEU    41      35.895  37.555 108.301  1.00 73.60           C  
ATOM    332  CD1 LEU    41      34.390  37.484 108.038  1.00 46.01           C  
ATOM    333  CD2 LEU    41      36.183  37.616 109.797  1.00 73.23           C  
ATOM    334  N   MET    42      37.595  33.627 106.378  1.00 56.00           N  
ATOM    335  CA  MET    42      37.808  32.775 105.199  1.00 57.81           C  
ATOM    336  C   MET    42      37.240  31.360 105.324  1.00 69.74           C  
ATOM    337  O   MET    42      37.038  30.683 104.313  1.00 74.92           O  
ATOM    338  CB  MET    42      39.293  32.719 104.825  1.00 48.73           C  
ATOM    339  CG  MET    42      39.756  33.857 103.932  1.00 26.11           C  
ATOM    340  SD  MET    42      38.932  33.896 102.326  1.00 46.81           S  
ATOM    341  CE  MET    42      39.502  35.472 101.695  1.00 20.11           C  
ATOM    342  N   HIS    43      37.006  30.916 106.560  1.00 77.46           N  
ATOM    343  CA  HIS    43      36.227  29.708 106.828  1.00 81.40           C  
ATOM    344  C   HIS    43      34.802  29.904 106.332  1.00 77.35           C  
ATOM    345  O   HIS    43      34.234  29.036 105.665  1.00 81.45           O  
ATOM    346  CB  HIS    43      36.169  29.422 108.331  1.00 92.98           C  
ATOM    347  CG  HIS    43      37.329  28.635 108.852  1.00115.47           C  
ATOM    348  ND1 HIS    43      38.190  29.129 109.810  1.00123.92           N  
ATOM    349  CD2 HIS    43      37.760  27.384 108.565  1.00132.13           C  
ATOM    350  CE1 HIS    43      39.108  28.220 110.081  1.00129.28           C  
ATOM    351  NE2 HIS    43      38.871  27.152 109.340  1.00131.76           N  
ATOM    352  N   LYS    44      34.243  31.066 106.666  1.00 73.33           N  
ATOM    353  CA  LYS    44      32.857  31.404 106.366  1.00 61.04           C  
ATOM    354  C   LYS    44      32.678  32.023 104.976  1.00 57.30           C  
ATOM    355  O   LYS    44      31.551  32.189 104.508  1.00 69.14           O  
ATOM    356  CB  LYS    44      32.298  32.335 107.448  1.00 58.50           C  
ATOM    357  CG  LYS    44      32.146  31.683 108.818  1.00 46.12           C  
ATOM    358  CD  LYS    44      31.729  32.697 109.876  1.00 62.71           C  
ATOM    359  CE  LYS    44      31.584  32.047 111.249  1.00 86.47           C  
ATOM    360  NZ  LYS    44      32.894  31.607 111.823  1.00104.81           N  
ATOM    361  N   VAL    45      33.789  32.365 104.325  1.00 47.83           N  
ATOM    362  CA  VAL    45      33.767  32.889 102.957  1.00 54.28           C  
ATOM    363  C   VAL    45      33.536  31.748 101.963  1.00 57.64           C  
ATOM    364  O   VAL    45      34.229  30.726 102.003  1.00 64.15           O  
ATOM    365  CB  VAL    45      35.068  33.693 102.629  1.00 44.32           C  
ATOM    366  CG1 VAL    45      35.346  33.757 101.125  1.00 51.43           C  
ATOM    367  CG2 VAL    45      34.979  35.101 103.199  1.00 59.36           C  
ATOM    368  N   HIS    46      32.541  31.921 101.094  1.00 52.06           N  
ATOM    369  CA  HIS    46      32.242  30.946 100.051  1.00 44.49           C  
ATOM    370  C   HIS    46      32.204  31.604  98.678  1.00 53.29           C  
ATOM    371  O   HIS    46      31.514  32.606  98.478  1.00 65.04           O  
ATOM    372  CB  HIS    46      30.912  30.242 100.331  1.00 36.82           C  
ATOM    373  CG  HIS    46      30.851  29.573 101.668  1.00 36.12           C  
ATOM    374  ND1 HIS    46      31.564  28.430 101.960  1.00 72.73           N  
ATOM    375  CD2 HIS    46      30.161  29.883 102.791  1.00 67.78           C  
ATOM    376  CE1 HIS    46      31.318  28.067 103.206  1.00 76.73           C  
ATOM    377  NE2 HIS    46      30.470  28.932 103.733  1.00 68.01           N  
ATOM    378  N   PHE    47      32.956  31.037  97.738  1.00 56.48           N  
ATOM    379  CA  PHE    47      32.956  31.526  96.363  1.00 61.28           C  
ATOM    380  C   PHE    47      31.879  30.823  95.549  1.00 58.84           C  
ATOM    381  O   PHE    47      31.816  29.594  95.506  1.00 62.21           O  
ATOM    382  CB  PHE    47      34.349  31.429  95.740  1.00 65.70           C  
ATOM    383  CG  PHE    47      35.332  32.390  96.345  1.00 59.38           C  
ATOM    384  CD1 PHE    47      36.184  31.983  97.368  1.00 64.32           C  
ATOM    385  CD2 PHE    47      35.381  33.715  95.919  1.00 51.39           C  
ATOM    386  CE1 PHE    47      37.083  32.874  97.941  1.00 82.12           C  
ATOM    387  CE2 PHE    47      36.275  34.611  96.490  1.00 40.37           C  
ATOM    388  CZ  PHE    47      37.125  34.189  97.501  1.00 63.01           C  
ATOM    389  N   VAL    48      31.027  31.628  94.918  1.00 55.73           N  
ATOM    390  CA  VAL    48      29.686  31.201  94.521  1.00 48.33           C  
ATOM    391  C   VAL    48      29.289  31.869  93.194  1.00 46.26           C  
ATOM    392  O   VAL    48      29.760  32.964  92.892  1.00 54.94           O  
ATOM    393  CB  VAL    48      28.691  31.499  95.719  1.00 51.09           C  
ATOM    394  CG1 VAL    48      27.323  32.038  95.289  1.00 66.36           C  
ATOM    395  CG2 VAL    48      28.538  30.277  96.614  1.00 25.83           C  
ATOM    396  N   GLU    49      28.443  31.203  92.407  0.50 40.44           N  
ATOM    398  CA  GLU    49      27.781  31.851  91.274  0.50 38.59           C  
ATOM    400  C   GLU    49      26.316  32.151  91.594  0.50 38.61           C  
ATOM    402  O   GLU    49      25.588  31.292  92.094  0.50 23.18           O  
ATOM    404  CB  GLU    49      27.906  31.014  89.999  0.50 39.79           C  
ATOM    406  CG  GLU    49      29.260  31.147  89.313  0.50 32.47           C  
ATOM    408  CD  GLU    49      29.242  30.675  87.871  0.50 47.37           C  
ATOM    410  OE1 GLU    49      28.857  29.512  87.621  0.50 67.13           O  
ATOM    412  OE2 GLU    49      29.625  31.468  86.984  0.50 41.08           O  
ATOM    414  N   HIS    50      25.893  33.378  91.305  0.50 35.51           N  
ATOM    416  CA  HIS    50      24.555  33.838  91.665  0.50 37.04           C  
ATOM    418  C   HIS    50      24.477  34.066  93.175  0.50 39.05           C  
ATOM    420  O   HIS    50      23.753  33.370  93.889  0.50 45.49           O  
ATOM    422  CB  HIS    50      23.483  32.836  91.220  0.50 33.33           C  
ATOM    424  CG  HIS    50      23.660  32.328  89.823  0.50 30.55           C  
ATOM    426  ND1 HIS    50      23.963  31.012  89.545  0.50 43.39           N  
ATOM    428  CD2 HIS    50      23.575  32.956  88.625  0.50 24.25           C  
ATOM    430  CE1 HIS    50      24.057  30.850  88.238  0.50 47.64           C  
ATOM    432  NE2 HIS    50      23.826  32.015  87.656  0.50 42.44           N  
ATOM    434  N   ALA    51      25.227  35.053  93.655  0.50 45.35           N  
ATOM    436  CA  ALA    51      25.294  35.347  95.086  0.50 48.89           C  
ATOM    438  C   ALA    51      24.154  36.246  95.576  0.50 51.83           C  
ATOM    440  O   ALA    51      24.079  36.574  96.762  0.50 53.16           O  
ATOM    442  CB  ALA    51      26.649  35.958  95.435  0.50 49.32           C  
ATOM    444  N   LYS    52      23.264  36.625  94.660  1.00 58.57           N  
ATOM    445  CA  LYS    52      22.124  37.506  94.966  1.00 54.64           C  
ATOM    446  C   LYS    52      21.017  36.826  95.781  1.00 46.90           C  
ATOM    447  O   LYS    52      20.208  37.496  96.427  1.00 46.97           O  
ATOM    448  CB  LYS    52      21.546  38.104  93.674  1.00 44.05           C  
ATOM    449  CG  LYS    52      21.045  37.074  92.661  1.00 66.73           C  
ATOM    450  CD  LYS    52      20.582  37.740  91.380  1.00 82.91           C  
ATOM    451  CE  LYS    52      19.977  36.734  90.415  1.00 97.19           C  
ATOM    452  NZ  LYS    52      19.523  37.389  89.153  1.00115.97           N  
ATOM    453  N   TYR    53      21.001  35.495  95.745  1.00 37.98           N  
ATOM    454  CA  TYR    53      20.046  34.682  96.491  1.00 37.72           C  
ATOM    455  C   TYR    53      20.497  34.436  97.934  1.00 45.31           C  
ATOM    456  O   TYR    53      19.725  33.933  98.754  1.00 54.77           O  
ATOM    457  CB  TYR    53      19.845  33.337  95.786  1.00 46.24           C  
ATOM    458  CG  TYR    53      19.406  33.437  94.341  1.00 72.72           C  
ATOM    459  CD1 TYR    53      18.073  33.684  94.014  1.00 81.57           C  
ATOM    460  CD2 TYR    53      20.320  33.270  93.300  1.00 82.33           C  
ATOM    461  CE1 TYR    53      17.662  33.773  92.688  1.00 71.14           C  
ATOM    462  CE2 TYR    53      19.918  33.357  91.970  1.00 86.46           C  
ATOM    463  CZ  TYR    53      18.588  33.608  91.672  1.00 63.48           C  
ATOM    464  OH  TYR    53      18.186  33.695  90.359  1.00 81.98           O  
ATOM    465  N   CYS    54      21.742  34.800  98.236  1.00 49.67           N  
ATOM    466  CA  CYS    54      22.366  34.482  99.519  1.00 56.54           C  
ATOM    467  C   CYS    54      22.061  35.511 100.615  1.00 60.03           C  
ATOM    468  O   CYS    54      21.984  36.708 100.328  1.00 67.34           O  
ATOM    469  CB  CYS    54      23.878  34.329  99.335  1.00 51.50           C  
ATOM    470  SG  CYS    54      24.343  33.106  98.085  1.00 97.57           S  
ATOM    471  N   PRO    55      21.869  35.038 101.870  1.00 58.20           N  
ATOM    472  CA  PRO    55      21.696  35.838 103.093  1.00 59.98           C  
ATOM    473  C   PRO    55      22.735  36.943 103.312  1.00 67.06           C  
ATOM    474  O   PRO    55      22.407  37.977 103.897  1.00 85.49           O  
ATOM    475  CB  PRO    55      21.791  34.793 104.223  1.00 66.59           C  
ATOM    476  CG  PRO    55      22.246  33.520 103.566  1.00 67.66           C  
ATOM    477  CD  PRO    55      21.746  33.602 102.171  1.00 69.20           C  
ATOM    478  N   ARG    56      23.968  36.722 102.861  1.00 48.08           N  
ATOM    479  CA  ARG    56      24.998  37.754 102.905  1.00 42.87           C  
ATOM    480  C   ARG    56      25.850  37.682 101.637  1.00 45.44           C  
ATOM    481  O   ARG    56      26.996  37.221 101.659  1.00 49.24           O  
ATOM    482  CB  ARG    56      25.839  37.621 104.175  1.00 49.88           C  
ATOM    483  CG  ARG    56      26.133  38.946 104.852  1.00 18.97           C  
ATOM    484  CD  ARG    56      26.176  38.798 106.364  1.00 24.76           C  
ATOM    485  NE  ARG    56      27.468  38.313 106.845  1.00 40.44           N  
ATOM    486  CZ  ARG    56      28.460  39.097 107.256  1.00 53.66           C  
ATOM    487  NH1 ARG    56      28.323  40.416 107.240  1.00 58.73           N  
ATOM    488  NH2 ARG    56      29.596  38.562 107.684  1.00 45.76           N  
ATOM    489  N   GLY    57      25.264  38.142 100.534  1.00 45.31           N  
ATOM    490  CA  GLY    57      25.861  38.009  99.209  1.00 39.80           C  
ATOM    491  C   GLY    57      26.650  39.214  98.741  1.00 40.11           C  
ATOM    492  O   GLY    57      26.211  40.353  98.890  1.00 39.59           O  
ATOM    493  N   LEU    58      27.814  38.943  98.156  1.00 34.25           N  
ATOM    494  CA  LEU    58      28.733  39.975  97.700  1.00 24.42           C  
ATOM    495  C   LEU    58      29.002  39.793  96.207  1.00 27.60           C  
ATOM    496  O   LEU    58      29.446  38.728  95.774  1.00 43.01           O  
ATOM    497  CB  LEU    58      30.037  39.878  98.501  1.00 39.75           C  
ATOM    498  CG  LEU    58      30.890  41.113  98.805  1.00 23.91           C  
ATOM    499  CD1 LEU    58      30.151  42.118  99.666  1.00 58.63           C  
ATOM    500  CD2 LEU    58      32.169  40.683  99.500  1.00 14.12           C  
ATOM    501  N   VAL    59      28.705  40.826  95.420  1.00 32.14           N  
ATOM    502  CA  VAL    59      28.933  40.795  93.972  1.00 31.60           C  
ATOM    503  C   VAL    59      29.955  41.865  93.602  1.00 51.55           C  
ATOM    504  O   VAL    59      29.745  43.049  93.870  1.00 58.66           O  
ATOM    505  CB  VAL    59      27.618  41.013  93.169  1.00 28.84           C  
ATOM    506  CG1 VAL    59      27.883  41.002  91.664  1.00 11.97           C  
ATOM    507  CG2 VAL    59      26.581  39.957  93.525  1.00 28.33           C  
ATOM    508  N   MET    60      31.063  41.442  92.998  1.00 46.21           N  
ATOM    509  CA  MET    60      32.144  42.357  92.635  1.00 43.37           C  
ATOM    510  C   MET    60      32.669  42.100  91.227  1.00 44.35           C  
ATOM    511  O   MET    60      32.773  40.951  90.797  1.00 52.83           O  
ATOM    512  CB  MET    60      33.269  42.275  93.662  1.00 44.96           C  
ATOM    513  CG  MET    60      33.034  43.154  94.879  1.00 48.21           C  
ATOM    514  SD  MET    60      33.481  42.433  96.469  1.00 46.13           S  
ATOM    515  CE  MET    60      34.825  41.344  96.023  1.00  4.14           C  
ATOM    516  N   SER    61      33.001  43.177  90.518  1.00 33.48           N  
ATOM    517  CA  SER    61      33.352  43.085  89.102  1.00 36.37           C  
ATOM    518  C   SER    61      34.679  43.747  88.754  1.00 44.79           C  
ATOM    519  O   SER    61      34.992  44.836  89.243  1.00 57.16           O  
ATOM    520  CB  SER    61      32.236  43.683  88.243  1.00 41.88           C  
ATOM    521  OG  SER    61      30.989  43.082  88.542  1.00 61.05           O  
ATOM    522  N   ALA    62      35.450  43.073  87.905  1.00 58.28           N  
ATOM    523  CA  ALA    62      36.674  43.634  87.346  1.00 58.50           C  
ATOM    524  C   ALA    62      36.339  44.552  86.170  1.00 64.19           C  
ATOM    525  O   ALA    62      35.240  44.478  85.613  1.00 75.24           O  
ATOM    526  CB  ALA    62      37.620  42.523  86.917  1.00 58.97           C  
ATOM    527  N   ASN    63      37.287  45.408  85.793  1.00 68.09           N  
ATOM    528  CA  ASN    63      37.062  46.432  84.756  1.00 69.47           C  
ATOM    529  C   ASN    63      36.980  45.953  83.296  1.00 64.12           C  
ATOM    530  O   ASN    63      36.721  46.748  82.388  1.00 58.40           O  
ATOM    531  CB  ASN    63      38.022  47.635  84.920  1.00 65.01           C  
ATOM    532  CG  ASN    63      39.505  47.293  84.677  1.00 91.40           C  
ATOM    533  OD1 ASN    63      40.339  48.201  84.624  1.00107.59           O  
ATOM    534  ND2 ASN    63      39.836  46.010  84.532  1.00 94.71           N  
ATOM    535  N   CYS    64      37.195  44.657  83.089  1.00 60.02           N  
ATOM    536  CA  CYS    64      37.081  44.040  81.771  1.00 75.98           C  
ATOM    537  C   CYS    64      35.619  43.849  81.359  1.00 79.71           C  
ATOM    538  O   CYS    64      35.171  44.435  80.369  1.00 80.65           O  
ATOM    539  CB  CYS    64      37.841  42.712  81.738  1.00 82.49           C  
ATOM    540  SG  CYS    64      37.673  41.726  83.249  1.00 98.58           S  
ATOM    541  N   VAL    65      34.882  43.036  82.119  1.00 73.13           N  
ATOM    542  CA  VAL    65      33.457  42.808  81.857  1.00 69.48           C  
ATOM    543  C   VAL    65      32.646  43.994  82.365  1.00 68.33           C  
ATOM    544  O   VAL    65      33.004  44.620  83.367  1.00 62.17           O  
ATOM    545  CB  VAL    65      32.921  41.516  82.520  1.00 68.74           C  
ATOM    546  CG1 VAL    65      31.853  40.870  81.643  1.00 97.15           C  
ATOM    547  CG2 VAL    65      34.032  40.537  82.757  1.00 69.93           C  
ATOM    548  N   LYS    66      31.545  44.287  81.676  1.00 78.50           N  
ATOM    549  CA  LYS    66      30.731  45.469  81.961  1.00 86.16           C  
ATOM    550  C   LYS    66      29.637  45.258  83.018  1.00 84.47           C  
ATOM    551  O   LYS    66      28.615  45.951  83.007  1.00 77.59           O  
ATOM    552  CB  LYS    66      30.125  46.021  80.662  1.00 95.79           C  
ATOM    553  CG  LYS    66      31.095  46.834  79.801  1.00113.77           C  
ATOM    554  CD  LYS    66      31.301  48.254  80.336  1.00122.57           C  
ATOM    555  CE  LYS    66      30.109  49.156  80.032  1.00120.31           C  
ATOM    556  NZ  LYS    66      30.291  50.525  80.592  1.00115.46           N  
ATOM    557  N   ASP    67      29.858  44.310  83.927  1.00 80.20           N  
ATOM    558  CA  ASP    67      28.968  44.109  85.069  1.00 71.67           C  
ATOM    559  C   ASP    67      29.181  45.216  86.103  1.00 72.53           C  
ATOM    560  O   ASP    67      30.254  45.827  86.154  1.00 74.41           O  
ATOM    561  CB  ASP    67      29.193  42.729  85.700  1.00 61.88           C  
ATOM    562  CG  ASP    67      28.744  41.588  84.798  1.00 67.35           C  
ATOM    563  OD1 ASP    67      29.148  41.555  83.614  1.00 65.09           O  
ATOM    564  OD2 ASP    67      27.991  40.714  85.281  1.00 60.45           O  
ATOM    565  N   THR    68      28.149  45.468  86.908  1.00 72.93           N  
ATOM    566  CA  THR    68      28.159  46.508  87.945  1.00 74.31           C  
ATOM    567  C   THR    68      29.237  46.251  89.007  1.00 64.76           C  
ATOM    568  O   THR    68      29.387  45.113  89.458  1.00 60.99           O  
ATOM    569  CB  THR    68      26.781  46.617  88.633  1.00 75.76           C  
ATOM    570  OG1 THR    68      26.394  45.326  89.135  1.00 61.69           O  
ATOM    571  CG2 THR    68      25.723  47.125  87.656  1.00 77.58           C  
ATOM    572  N   PRO    69      29.992  47.306  89.397  1.00 58.71           N  
ATOM    573  CA  PRO    69      31.149  47.214  90.301  1.00 51.46           C  
ATOM    574  C   PRO    69      30.899  46.539  91.652  1.00 52.55           C  
ATOM    575  O   PRO    69      31.702  45.703  92.070  1.00 54.61           O  
ATOM    576  CB  PRO    69      31.536  48.681  90.523  1.00 34.40           C  
ATOM    577  CG  PRO    69      31.056  49.379  89.317  1.00 27.54           C  
ATOM    578  CD  PRO    69      29.773  48.699  88.957  1.00 48.11           C  
ATOM    579  N   PHE    70      29.806  46.897  92.325  1.00 47.73           N  
ATOM    580  CA  PHE    70      29.535  46.373  93.665  1.00 38.96           C  
ATOM    581  C   PHE    70      28.051  46.180  93.972  1.00 47.67           C  
ATOM    582  O   PHE    70      27.218  47.019  93.621  1.00 44.07           O  
ATOM    583  CB  PHE    70      30.181  47.268  94.736  1.00 27.56           C  
ATOM    584  CG  PHE    70      30.034  46.741  96.142  1.00 35.59           C  
ATOM    585  CD1 PHE    70      29.015  47.203  96.975  1.00 28.02           C  
ATOM    586  CD2 PHE    70      30.909  45.777  96.630  1.00 26.65           C  
ATOM    587  CE1 PHE    70      28.868  46.705  98.265  1.00 55.54           C  
ATOM    588  CE2 PHE    70      30.777  45.284  97.922  1.00 13.83           C  
ATOM    589  CZ  PHE    70      29.756  45.748  98.741  1.00 52.02           C  
ATOM    590  N   HIS    71      27.747  45.070  94.645  1.00 38.09           N  
ATOM    591  CA  HIS    71      26.436  44.824  95.244  1.00 41.20           C  
ATOM    592  C   HIS    71      26.564  44.016  96.533  1.00 51.31           C  
ATOM    593  O   HIS    71      27.296  43.025  96.583  1.00 60.30           O  
ATOM    594  CB  HIS    71      25.515  44.095  94.267  1.00 36.38           C  
ATOM    595  CG  HIS    71      24.807  45.004  93.316  1.00 61.41           C  
ATOM    596  ND1 HIS    71      25.370  45.420  92.129  1.00 74.55           N  
ATOM    597  CD2 HIS    71      23.586  45.585  93.378  1.00 41.09           C  
ATOM    598  CE1 HIS    71      24.526  46.217  91.500  1.00 57.77           C  
ATOM    599  NE2 HIS    71      23.435  46.333  92.236  1.00 43.51           N  
ATOM    600  N   PHE    72      25.852  44.449  97.571  1.00 46.42           N  
ATOM    601  CA  PHE    72      25.787  43.703  98.824  1.00 42.49           C  
ATOM    602  C   PHE    72      24.352  43.284  99.128  1.00 41.28           C  
ATOM    603  O   PHE    72      23.463  44.125  99.290  1.00 41.05           O  
ATOM    604  CB  PHE    72      26.398  44.503  99.982  1.00 33.96           C  
ATOM    605  CG  PHE    72      26.478  43.742 101.286  1.00 53.39           C  
ATOM    606  CD1 PHE    72      26.960  42.434 101.324  1.00 63.75           C  
ATOM    607  CD2 PHE    72      26.092  44.346 102.480  1.00 28.53           C  
ATOM    608  CE1 PHE    72      27.042  41.737 102.526  1.00 53.03           C  
ATOM    609  CE2 PHE    72      26.173  43.659 103.688  1.00 64.73           C  
ATOM    610  CZ  PHE    72      26.649  42.353 103.710  1.00 46.99           C  
ATOM    611  N   PHE    73      24.145  41.972  99.194  1.00 42.22           N  
ATOM    612  CA  PHE    73      22.824  41.395  99.393  1.00 32.18           C  
ATOM    613  C   PHE    73      22.647  40.823 100.795  1.00 47.36           C  
ATOM    614  O   PHE    73      22.866  39.630 101.020  1.00 50.59           O  
ATOM    615  CB  PHE    73      22.550  40.302  98.352  1.00 16.68           C  
ATOM    616  CG  PHE    73      22.437  40.812  96.945  1.00 46.08           C  
ATOM    617  CD1 PHE    73      21.241  41.350  96.479  1.00 36.49           C  
ATOM    618  CD2 PHE    73      23.520  40.740  96.078  1.00 49.46           C  
ATOM    619  CE1 PHE    73      21.129  41.818  95.173  1.00 47.29           C  
ATOM    620  CE2 PHE    73      23.414  41.201  94.770  1.00 41.84           C  
ATOM    621  CZ  PHE    73      22.219  41.743  94.317  1.00 24.14           C  
ATOM    622  N   LYS    74      22.252  41.677 101.736  1.00 63.57           N  
ATOM    623  CA  LYS    74      21.788  41.203 103.037  1.00 65.79           C  
ATOM    624  C   LYS    74      20.345  40.710 102.925  1.00 64.36           C  
ATOM    625  O   LYS    74      19.711  40.873 101.878  1.00 57.86           O  
ATOM    626  CB  LYS    74      21.931  42.278 104.118  1.00 69.06           C  
ATOM    627  CG  LYS    74      23.118  42.045 105.040  1.00 62.10           C  
ATOM    628  CD  LYS    74      22.904  42.709 106.402  1.00 94.79           C  
ATOM    629  CE  LYS    74      23.653  41.967 107.509  1.00 98.09           C  
ATOM    630  NZ  LYS    74      25.141  42.013 107.336  1.00 73.68           N  
ATOM    631  N   GLN    75      19.837  40.112 104.004  1.00 73.63           N  
ATOM    632  CA  GLN    75      18.522  39.451 104.008  1.00 83.30           C  
ATOM    633  C   GLN    75      17.328  40.317 103.591  1.00 66.97           C  
ATOM    634  O   GLN    75      16.366  39.806 103.014  1.00 64.86           O  
ATOM    635  CB  GLN    75      18.241  38.802 105.366  1.00 97.58           C  
ATOM    636  CG  GLN    75      18.763  37.378 105.494  1.00119.01           C  
ATOM    637  CD  GLN    75      17.893  36.504 106.388  1.00132.39           C  
ATOM    638  OE1 GLN    75      16.774  36.875 106.751  1.00122.34           O  
ATOM    639  NE2 GLN    75      18.404  35.330 106.741  1.00128.61           N  
ATOM    640  N   ASN    76      17.394  41.616 103.877  1.00 70.77           N  
ATOM    641  CA  ASN    76      16.306  42.534 103.534  1.00 73.19           C  
ATOM    642  C   ASN    76      16.680  43.674 102.581  1.00 67.26           C  
ATOM    643  O   ASN    76      15.802  44.257 101.937  1.00 74.46           O  
ATOM    644  CB  ASN    76      15.649  43.092 104.804  1.00 80.64           C  
ATOM    645  CG  ASN    76      14.540  42.193 105.339  1.00 94.09           C  
ATOM    646  OD1 ASN    76      14.310  41.091 104.836  1.00116.49           O  
ATOM    647  ND2 ASN    76      13.844  42.667 106.366  1.00109.69           N  
ATOM    648  N   VAL    77      17.974  43.990 102.491  1.00 69.09           N  
ATOM    649  CA  VAL    77      18.442  45.125 101.684  1.00 62.67           C  
ATOM    650  C   VAL    77      19.398  44.696 100.564  1.00 61.27           C  
ATOM    651  O   VAL    77      20.153  43.732 100.715  1.00 62.47           O  
ATOM    652  CB  VAL    77      19.153  46.216 102.547  1.00 64.53           C  
ATOM    653  CG1 VAL    77      18.833  47.612 102.020  1.00 55.69           C  
ATOM    654  CG2 VAL    77      18.772  46.111 104.024  1.00 82.06           C  
ATOM    655  N   MET    78      19.349  45.419  99.445  1.00 42.50           N  
ATOM    656  CA  MET    78      20.336  45.285  98.371  1.00 50.14           C  
ATOM    657  C   MET    78      21.078  46.613  98.143  1.00 38.69           C  
ATOM    658  O   MET    78      20.716  47.413  97.274  1.00 48.81           O  
ATOM    659  CB  MET    78      19.703  44.737  97.077  1.00 47.97           C  
ATOM    660  CG  MET    78      18.332  45.317  96.706  1.00 69.92           C  
ATOM    661  SD  MET    78      17.692  44.689  95.138  1.00 61.78           S  
ATOM    662  CE  MET    78      17.085  43.063  95.638  1.00 74.72           C  
ATOM    663  N   THR    79      22.115  46.838  98.946  1.00 47.80           N  
ATOM    664  CA  THR    79      22.876  48.092  98.914  1.00 52.87           C  
ATOM    665  C   THR    79      24.004  48.084  97.879  1.00 52.91           C  
ATOM    666  O   THR    79      24.603  47.041  97.602  1.00 52.97           O  
ATOM    667  CB  THR    79      23.424  48.482 100.320  1.00 54.82           C  
ATOM    668  OG1 THR    79      24.399  49.528 100.192  1.00 68.46           O  
ATOM    669  CG2 THR    79      24.060  47.285 101.023  1.00 70.18           C  
ATOM    670  N   THR    80      24.279  49.260  97.318  1.00 51.14           N  
ATOM    671  CA  THR    80      25.340  49.434  96.323  1.00 51.08           C  
ATOM    672  C   THR    80      26.563  50.161  96.894  1.00 55.47           C  
ATOM    673  O   THR    80      27.634  50.164  96.279  1.00 58.74           O  
ATOM    674  CB  THR    80      24.820  50.154  95.045  1.00 47.82           C  
ATOM    675  OG1 THR    80      25.865  50.215  94.064  1.00 74.38           O  
ATOM    676  CG2 THR    80      24.325  51.569  95.356  1.00 61.08           C  
ATOM    677  N   ASP    81      26.394  50.771  98.068  1.00 55.83           N  
ATOM    678  CA  ASP    81      27.473  51.496  98.737  1.00 46.86           C  
ATOM    679  C   ASP    81      28.443  50.518  99.392  1.00 48.86           C  
ATOM    680  O   ASP    81      28.072  49.776 100.305  1.00 38.32           O  
ATOM    681  CB  ASP    81      26.906  52.473  99.775  1.00 52.86           C  
ATOM    682  CG  ASP    81      27.947  53.459 100.286  1.00 63.92           C  
ATOM    683  OD1 ASP    81      27.945  53.746 101.502  1.00 77.56           O  
ATOM    684  OD2 ASP    81      28.764  53.952  99.478  1.00108.65           O  
ATOM    685  N   ALA    82      29.684  50.524  98.912  1.00 49.02           N  
ATOM    686  CA  ALA    82      30.701  49.585  99.380  1.00 37.82           C  
ATOM    687  C   ALA    82      31.286  49.960 100.737  1.00 47.96           C  
ATOM    688  O   ALA    82      31.702  49.083 101.489  1.00 56.08           O  
ATOM    689  CB  ALA    82      31.800  49.430  98.345  1.00 43.64           C  
ATOM    690  N   GLU    83      31.309  51.258 101.037  1.00 37.70           N  
ATOM    691  CA  GLU    83      31.862  51.775 102.292  1.00 37.91           C  
ATOM    692  C   GLU    83      31.017  51.418 103.512  1.00 49.17           C  
ATOM    693  O   GLU    83      31.561  51.067 104.562  1.00 63.96           O  
ATOM    694  CB  GLU    83      32.046  53.293 102.220  1.00 28.88           C  
ATOM    695  CG  GLU    83      33.246  53.744 101.401  1.00 39.60           C  
ATOM    696  CD  GLU    83      33.449  55.251 101.436  1.00 80.26           C  
ATOM    697  OE1 GLU    83      33.713  55.837 100.365  1.00105.07           O  
ATOM    698  OE2 GLU    83      33.345  55.852 102.528  1.00 70.49           O  
ATOM    699  N   LYS    84      29.695  51.520 103.368  1.00 47.28           N  
ATOM    700  CA  LYS    84      28.765  51.139 104.429  1.00 53.19           C  
ATOM    701  C   LYS    84      28.750  49.623 104.603  1.00 56.27           C  
ATOM    702  O   LYS    84      28.696  49.127 105.728  1.00 61.84           O  
ATOM    703  CB  LYS    84      27.355  51.676 104.139  1.00 62.44           C  
ATOM    704  CG  LYS    84      26.317  51.460 105.256  1.00 75.22           C  
ATOM    705  CD  LYS    84      26.762  52.016 106.617  1.00111.96           C  
ATOM    706  CE  LYS    84      26.751  53.544 106.663  1.00115.36           C  
ATOM    707  NZ  LYS    84      25.373  54.111 106.606  1.00122.53           N  
ATOM    708  N   SER    85      28.824  48.904 103.483  1.00 52.57           N  
ATOM    709  CA  SER    85      28.869  47.442 103.478  1.00 49.61           C  
ATOM    710  C   SER    85      30.157  46.897 104.095  1.00 47.01           C  
ATOM    711  O   SER    85      30.130  45.872 104.774  1.00 52.71           O  
ATOM    712  CB  SER    85      28.703  46.911 102.054  1.00 45.25           C  
ATOM    713  OG  SER    85      27.475  47.341 101.493  1.00 55.42           O  
ATOM    714  N   PHE    86      31.271  47.591 103.855  1.00 40.80           N  
ATOM    715  CA  PHE    86      32.565  47.250 104.453  1.00 37.95           C  
ATOM    716  C   PHE    86      32.561  47.534 105.954  1.00 39.94           C  
ATOM    717  O   PHE    86      33.125  46.763 106.733  1.00 42.91           O  
ATOM    718  CB  PHE    86      33.703  48.009 103.754  1.00 43.18           C  
ATOM    719  CG  PHE    86      35.089  47.585 104.178  1.00 36.61           C  
ATOM    720  CD1 PHE    86      35.374  46.255 104.496  1.00 27.09           C  
ATOM    721  CD2 PHE    86      36.123  48.521 104.224  1.00 21.57           C  
ATOM    722  CE1 PHE    86      36.649  45.876 104.881  1.00 27.27           C  
ATOM    723  CE2 PHE    86      37.408  48.145 104.603  1.00 13.85           C  
ATOM    724  CZ  PHE    86      37.671  46.820 104.931  1.00 37.04           C  
ATOM    725  N   HIS    87      31.913  48.632 106.346  1.00 43.45           N  
ATOM    726  CA  HIS    87      31.733  48.990 107.755  1.00 33.20           C  
ATOM    727  C   HIS    87      30.821  47.992 108.483  1.00 26.92           C  
ATOM    728  O   HIS    87      30.957  47.782 109.694  1.00 38.35           O  
ATOM    729  CB  HIS    87      31.187  50.423 107.869  1.00 47.79           C  
ATOM    730  CG  HIS    87      30.780  50.816 109.256  1.00 77.67           C  
ATOM    731  ND1 HIS    87      31.689  51.004 110.276  1.00 95.54           N  
ATOM    732  CD2 HIS    87      29.560  51.056 109.791  1.00 62.79           C  
ATOM    733  CE1 HIS    87      31.046  51.341 111.380  1.00 68.04           C  
ATOM    734  NE2 HIS    87      29.753  51.381 111.113  1.00 57.51           N  
ATOM    735  N   ASP    88      29.913  47.373 107.727  1.00 37.53           N  
ATOM    736  CA  ASP    88      28.997  46.413 108.322  0.50 28.64           C  
ATOM    738  C   ASP    88      29.578  45.004 108.437  1.00 28.85           C  
ATOM    739  O   ASP    88      29.406  44.370 109.478  1.00 26.48           O  
ATOM    740  CB  ASP    88      27.622  46.450 107.604  0.50 29.14           C  
ATOM    742  CG  ASP    88      26.892  47.808 107.904  0.50 35.28           C  
ATOM    744  OD1 ASP    88      27.128  48.454 108.977  0.50 49.49           O  
ATOM    746  OD2 ASP    88      26.073  48.216 107.050  0.50 20.40           O  
ATOM    748  N   ILE    89      30.290  44.529 107.409  1.00 34.25           N  
ATOM    749  CA  ILE    89      30.942  43.200 107.451  1.00 50.45           C  
ATOM    750  C   ILE    89      32.134  43.168 108.418  1.00 46.38           C  
ATOM    751  O   ILE    89      32.570  42.095 108.855  1.00 54.94           O  
ATOM    752  CB  ILE    89      31.356  42.663 106.032  1.00 56.41           C  
ATOM    753  CG1 ILE    89      32.425  43.541 105.363  1.00 54.06           C  
ATOM    754  CG2 ILE    89      30.136  42.497 105.129  1.00 53.34           C  
ATOM    755  CD1 ILE    89      33.822  42.934 105.343  1.00 46.88           C  
ATOM    756  N   ARG    90      32.647  44.364 108.718  1.00 36.15           N  
ATOM    757  CA  ARG    90      33.648  44.613 109.751  1.00 33.44           C  
ATOM    758  C   ARG    90      33.174  44.112 111.112  1.00 35.88           C  
ATOM    759  O   ARG    90      33.923  43.464 111.846  1.00 32.69           O  
ATOM    760  CB  ARG    90      33.873  46.124 109.851  1.00 50.53           C  
ATOM    761  CG  ARG    90      35.309  46.587 109.914  1.00 49.31           C  
ATOM    762  CD  ARG    90      35.980  46.545 108.546  1.00 11.36           C  
ATOM    763  NE  ARG    90      36.812  47.723 108.294  1.00 39.72           N  
ATOM    764  CZ  ARG    90      38.043  47.915 108.768  1.00 44.50           C  
ATOM    765  NH1 ARG    90      38.630  47.013 109.548  1.00 21.11           N  
ATOM    766  NH2 ARG    90      38.693  49.029 108.462  1.00 41.44           N  
ATOM    767  N   LEU    91      31.919  44.426 111.428  1.00 49.46           N  
ATOM    768  CA  LEU    91      31.334  44.160 112.737  1.00 39.94           C  
ATOM    769  C   LEU    91      30.506  42.877 112.775  1.00 52.25           C  
ATOM    770  O   LEU    91      30.407  42.235 113.824  1.00 68.83           O  
ATOM    771  CB  LEU    91      30.465  45.347 113.181  1.00 31.54           C  
ATOM    772  CG  LEU    91      31.063  46.545 113.937  1.00 53.08           C  
ATOM    773  CD1 LEU    91      32.020  47.394 113.065  1.00 64.99           C  
ATOM    774  CD2 LEU    91      29.928  47.422 114.518  1.00 42.90           C  
ATOM    775  N   ASN    92      29.920  42.512 111.639  1.00 56.70           N  
ATOM    776  CA  ASN    92      28.881  41.490 111.607  1.00 67.96           C  
ATOM    777  C   ASN    92      29.457  40.080 111.686  1.00 72.93           C  
ATOM    778  O   ASN    92      28.842  39.179 112.256  1.00 76.53           O  
ATOM    779  CB  ASN    92      28.023  41.637 110.350  1.00 78.08           C  
ATOM    780  CG  ASN    92      26.855  42.584 110.549  1.00 88.02           C  
ATOM    781  OD1 ASN    92      25.957  42.665 109.711  1.00131.72           O  
ATOM    782  ND2 ASN    92      26.863  43.307 111.663  1.00 59.87           N  
ATOM    783  N   ARG    93      30.641  39.896 111.111  1.00 71.19           N  
ATOM    784  CA  ARG    93      31.543  38.834 111.538  1.00 73.30           C  
ATOM    785  C   ARG    93      30.928  37.458 111.301  1.00 77.32           C  
ATOM    786  O   ARG    93      31.088  36.872 110.231  1.00 84.52           O  
ATOM    787  CB  ARG    93      31.907  39.000 113.015  1.00 74.54           C  
ATOM    788  CG  ARG    93      33.069  39.947 113.265  1.00 81.79           C  
ATOM    789  CD  ARG    93      34.170  39.755 112.235  1.00 42.00           C  
ATOM    790  NE  ARG    93      35.213  40.770 112.353  1.00 52.63           N  
ATOM    791  CZ  ARG    93      36.415  40.548 112.873  1.00 69.36           C  
ATOM    792  NH1 ARG    93      36.732  39.343 113.327  1.00 79.09           N  
ATOM    793  NH2 ARG    93      37.302  41.532 112.940  1.00 90.19           N  
ATOM    794  N   ASP    94      30.224  36.950 112.307  1.00 76.75           N  
ATOM    795  CA  ASP    94      30.181  35.515 112.563  1.00 75.47           C  
ATOM    796  C   ASP    94      29.214  34.814 111.614  1.00 70.61           C  
ATOM    797  O   ASP    94      28.876  33.646 111.808  1.00 77.92           O  
ATOM    798  CB  ASP    94      29.782  35.242 114.015  1.00 74.90           C  
ATOM    799  CG  ASP    94      28.643  36.126 114.483  1.00 99.50           C  
ATOM    800  OD1 ASP    94      28.572  37.291 114.039  1.00125.90           O  
ATOM    801  OD2 ASP    94      27.818  35.656 115.295  1.00115.48           O  
ATOM    802  N   GLU    95      28.774  35.534 110.588  1.00 67.83           N  
ATOM    803  CA  GLU    95      27.934  34.949 109.541  1.00 72.63           C  
ATOM    804  C   GLU    95      28.752  34.584 108.303  1.00 69.46           C  
ATOM    805  O   GLU    95      29.844  35.120 108.089  1.00 62.78           O  
ATOM    806  CB  GLU    95      26.792  35.897 109.161  1.00 84.56           C  
ATOM    807  CG  GLU    95      25.454  35.587 109.828  1.00103.34           C  
ATOM    808  CD  GLU    95      25.446  35.870 111.321  1.00131.10           C  
ATOM    809  OE1 GLU    95      24.975  34.999 112.083  1.00149.05           O  
ATOM    810  OE2 GLU    95      25.907  36.956 111.734  1.00120.75           O  
ATOM    811  N   ASP    96      28.218  33.662 107.502  1.00 67.14           N  
ATOM    812  CA  ASP    96      28.824  33.275 106.229  1.00 61.36           C  
ATOM    813  C   ASP    96      28.684  34.390 105.199  1.00 57.82           C  
ATOM    814  O   ASP    96      27.626  35.014 105.096  1.00 58.90           O  
ATOM    815  CB  ASP    96      28.166  32.001 105.686  1.00 63.82           C  
ATOM    816  CG  ASP    96      28.538  30.760 106.478  1.00 83.76           C  
ATOM    817  OD1 ASP    96      29.690  30.294 106.361  1.00 83.72           O  
ATOM    818  OD2 ASP    96      27.668  30.237 107.206  1.00 94.54           O  
ATOM    819  N   ILE    97      29.754  34.640 104.446  1.00 50.57           N  
ATOM    820  CA  ILE    97      29.721  35.600 103.340  1.00 42.35           C  
ATOM    821  C   ILE    97      29.851  34.847 102.017  1.00 48.41           C  
ATOM    822  O   ILE    97      30.668  33.930 101.892  1.00 61.71           O  
ATOM    823  CB  ILE    97      30.836  36.681 103.452  1.00 38.51           C  
ATOM    824  CG1 ILE    97      30.998  37.146 104.905  1.00 56.20           C  
ATOM    825  CG2 ILE    97      30.543  37.866 102.519  1.00 36.70           C  
ATOM    826  CD1 ILE    97      32.017  38.258 105.111  1.00 36.92           C  
ATOM    827  N   TYR    98      29.036  35.235 101.038  1.00 43.37           N  
ATOM    828  CA  TYR    98      29.033  34.593  99.728  1.00 41.55           C  
ATOM    829  C   TYR    98      29.468  35.571  98.639  1.00 45.44           C  
ATOM    830  O   TYR    98      28.735  36.499  98.298  1.00 53.75           O  
ATOM    831  CB  TYR    98      27.649  34.019  99.419  1.00 43.75           C  
ATOM    832  CG  TYR    98      27.234  32.868 100.314  1.00 46.05           C  
ATOM    833  CD1 TYR    98      27.502  31.550  99.950  1.00 57.34           C  
ATOM    834  CD2 TYR    98      26.568  33.095 101.521  1.00 43.28           C  
ATOM    835  CE1 TYR    98      27.125  30.486 100.764  1.00 67.21           C  
ATOM    836  CE2 TYR    98      26.186  32.038 102.343  1.00 73.75           C  
ATOM    837  CZ  TYR    98      26.468  30.737 101.957  1.00 66.92           C  
ATOM    838  OH  TYR    98      26.093  29.688 102.765  1.00 54.52           O  
ATOM    839  N   ILE    99      30.663  35.352  98.098  1.00 37.68           N  
ATOM    840  CA  ILE    99      31.256  36.271  97.125  1.00 28.08           C  
ATOM    841  C   ILE    99      31.253  35.693  95.710  1.00 42.24           C  
ATOM    842  O   ILE    99      31.662  34.549  95.497  1.00 51.89           O  
ATOM    843  CB  ILE    99      32.712  36.664  97.512  1.00 32.23           C  
ATOM    844  CG1 ILE    99      32.817  36.961  99.014  1.00 42.55           C  
ATOM    845  CG2 ILE    99      33.200  37.863  96.683  1.00 37.46           C  
ATOM    846  CD1 ILE    99      34.240  37.035  99.531  1.00 44.76           C  
ATOM    847  N   GLN   100      30.778  36.487  94.752  1.00 41.82           N  
ATOM    848  CA  GLN   100      30.997  36.194  93.339  1.00 50.21           C  
ATOM    849  C   GLN   100      31.923  37.230  92.706  1.00 54.68           C  
ATOM    850  O   GLN   100      31.944  38.398  93.113  1.00 54.28           O  
ATOM    851  CB  GLN   100      29.678  36.066  92.560  1.00 50.15           C  
ATOM    852  CG  GLN   100      28.947  37.353  92.243  1.00 46.68           C  
ATOM    853  CD  GLN   100      27.981  37.186  91.088  1.00 48.67           C  
ATOM    854  OE1 GLN   100      28.382  37.188  89.922  1.00 30.74           O  
ATOM    855  NE2 GLN   100      26.702  37.039  91.406  1.00 37.98           N  
ATOM    856  N   LEU   101      32.703  36.784  91.724  1.00 50.71           N  
ATOM    857  CA  LEU   101      33.607  37.672  91.003  1.00 52.79           C  
ATOM    858  C   LEU   101      33.303  37.675  89.512  1.00 48.52           C  
ATOM    859  O   LEU   101      33.158  36.615  88.895  1.00 54.98           O  
ATOM    860  CB  LEU   101      35.076  37.300  91.253  1.00 57.78           C  
ATOM    861  CG  LEU   101      35.778  37.766  92.539  1.00 45.95           C  
ATOM    862  CD1 LEU   101      35.421  39.206  92.898  1.00 44.26           C  
ATOM    863  CD2 LEU   101      35.496  36.844  93.713  1.00 51.41           C  
ATOM    864  N   ASN   102      33.203  38.874  88.944  1.00 44.83           N  
ATOM    865  CA  ASN   102      32.942  39.035  87.518  1.00 54.17           C  
ATOM    866  C   ASN   102      34.192  39.484  86.763  1.00 63.67           C  
ATOM    867  O   ASN   102      34.495  40.678  86.690  1.00 68.06           O  
ATOM    868  CB  ASN   102      31.780  40.012  87.282  1.00 52.28           C  
ATOM    869  CG  ASN   102      30.482  39.560  87.940  1.00 52.25           C  
ATOM    870  OD1 ASN   102      29.761  40.367  88.527  1.00 64.12           O  
ATOM    871  ND2 ASN   102      30.180  38.268  87.842  1.00 50.03           N  
ATOM    872  N   PHE   103      34.917  38.512  86.213  1.00 64.90           N  
ATOM    873  CA  PHE   103      36.127  38.782  85.431  1.00 71.60           C  
ATOM    874  C   PHE   103      36.130  38.030  84.095  1.00 72.29           C  
ATOM    875  O   PHE   103      35.446  37.014  83.956  1.00 67.27           O  
ATOM    876  CB  PHE   103      37.415  38.570  86.256  1.00 69.00           C  
ATOM    877  CG  PHE   103      37.562  37.193  86.863  1.00 58.28           C  
ATOM    878  CD1 PHE   103      36.832  36.817  87.992  1.00 59.61           C  
ATOM    879  CD2 PHE   103      38.478  36.291  86.336  1.00 44.98           C  
ATOM    880  CE1 PHE   103      36.987  35.554  88.558  1.00 62.83           C  
ATOM    881  CE2 PHE   103      38.647  35.029  86.901  1.00 79.49           C  
ATOM    882  CZ  PHE   103      37.896  34.659  88.011  1.00 69.92           C  
ATOM    883  N   LYS   104      36.894  38.532  83.130  1.00 79.77           N  
ATOM    884  CA  LYS   104      36.661  38.217  81.726  1.00 77.85           C  
ATOM    885  C   LYS   104      36.767  36.717  81.472  1.00 80.76           C  
ATOM    886  O   LYS   104      35.888  36.119  80.852  1.00 89.35           O  
ATOM    887  CB  LYS   104      37.649  38.972  80.836  1.00 72.34           C  
ATOM    888  CG  LYS   104      37.514  38.660  79.354  1.00 89.58           C  
ATOM    889  CD  LYS   104      37.651  39.917  78.511  1.00108.84           C  
ATOM    890  CE  LYS   104      36.312  40.613  78.335  1.00111.27           C  
ATOM    891  NZ  LYS   104      36.408  41.778  77.412  1.00106.29           N  
ATOM    892  N   SER   105      37.849  36.115  81.956  1.00 79.14           N  
ATOM    893  CA  SER   105      38.225  34.768  81.544  1.00 84.89           C  
ATOM    894  C   SER   105      37.589  33.717  82.448  1.00 82.17           C  
ATOM    895  O   SER   105      37.340  32.589  82.023  1.00 88.04           O  
ATOM    896  CB  SER   105      39.747  34.613  81.548  1.00 93.30           C  
ATOM    897  OG  SER   105      40.275  34.793  82.850  1.00 90.41           O  
ATOM    898  N   SER   106      37.328  34.096  83.695  1.00 73.03           N  
ATOM    899  CA  SER   106      36.538  33.267  84.597  1.00 75.36           C  
ATOM    900  C   SER   106      36.819  31.785  84.373  1.00 81.22           C  
ATOM    901  O   SER   106      37.758  31.228  84.942  1.00 72.87           O  
ATOM    902  CB  SER   106      35.046  33.552  84.419  1.00 64.71           C  
ATOM    903  OG  SER   106      34.653  34.698  85.155  1.00 77.91           O  
ATOM    904  N   PHE   107      35.999  31.151  83.541  1.00 83.20           N  
ATOM    905  CA  PHE   107      35.974  29.697  83.449  1.00 84.24           C  
ATOM    906  C   PHE   107      37.065  29.184  82.516  1.00 86.74           C  
ATOM    907  O   PHE   107      37.000  28.055  82.029  1.00 85.34           O  
ATOM    908  CB  PHE   107      34.603  29.213  82.971  1.00 81.07           C  
ATOM    909  CG  PHE   107      33.671  28.836  84.087  1.00 80.14           C  
ATOM    910  CD1 PHE   107      33.679  27.555  84.611  1.00 79.45           C  
ATOM    911  CD2 PHE   107      32.785  29.763  84.611  1.00 81.77           C  
ATOM    912  CE1 PHE   107      32.822  27.205  85.638  1.00 73.72           C  
ATOM    913  CE2 PHE   107      31.926  29.419  85.637  1.00 86.27           C  
ATOM    914  CZ  PHE   107      31.945  28.138  86.151  1.00 81.88           C  
ATOM    915  N   GLN   108      38.068  30.021  82.269  1.00 81.83           N  
ATOM    916  CA  GLN   108      39.314  29.567  81.664  1.00 71.50           C  
ATOM    917  C   GLN   108      40.315  29.128  82.727  1.00 73.51           C  
ATOM    918  O   GLN   108      41.228  28.350  82.450  1.00 84.63           O  
ATOM    919  CB  GLN   108      39.920  30.670  80.794  1.00 60.92           C  
ATOM    920  CG  GLN   108      41.374  30.435  80.417  1.00 65.78           C  
ATOM    921  CD  GLN   108      42.133  31.727  80.189  1.00 78.37           C  
ATOM    922  OE1 GLN   108      41.699  32.589  79.424  1.00 89.24           O  
ATOM    923  NE2 GLN   108      43.274  31.869  80.853  1.00 93.78           N  
ATOM    924  N   ASN   109      40.138  29.632  83.944  1.00 61.06           N  
ATOM    925  CA  ASN   109      41.099  29.402  85.016  1.00 56.97           C  
ATOM    926  C   ASN   109      40.647  28.313  85.986  1.00 59.09           C  
ATOM    927  O   ASN   109      39.636  28.468  86.676  1.00 75.42           O  
ATOM    928  CB  ASN   109      41.355  30.715  85.760  1.00 60.45           C  
ATOM    929  CG  ASN   109      41.531  31.894  84.820  1.00 74.41           C  
ATOM    930  OD1 ASN   109      42.538  31.999  84.117  1.00 79.56           O  
ATOM    931  ND2 ASN   109      40.550  32.791  84.809  1.00 59.82           N  
ATOM    932  N   ALA   110      41.421  27.226  86.034  1.00 59.44           N  
ATOM    933  CA  ALA   110      41.104  26.024  86.820  1.00 76.50           C  
ATOM    934  C   ALA   110      40.965  26.262  88.322  1.00 85.33           C  
ATOM    935  O   ALA   110      40.127  25.641  88.974  1.00 92.26           O  
ATOM    936  CB  ALA   110      42.139  24.935  86.554  1.00 82.37           C  
ATOM    937  N   ASN   111      41.793  27.159  88.852  1.00 82.09           N  
ATOM    938  CA  ASN   111      41.751  27.555  90.263  1.00 78.31           C  
ATOM    939  C   ASN   111      40.481  28.279  90.704  1.00 81.26           C  
ATOM    940  O   ASN   111      40.028  28.098  91.838  1.00 72.89           O  
ATOM    941  CB  ASN   111      43.003  28.352  90.673  1.00 74.33           C  
ATOM    942  CG  ASN   111      43.195  29.661  89.888  1.00 91.41           C  
ATOM    943  OD1 ASN   111      43.724  30.630  90.433  1.00100.72           O  
ATOM    944  ND2 ASN   111      42.798  29.687  88.621  1.00 89.07           N  
ATOM    945  N   TYR   112      39.919  29.097  89.812  1.00 79.02           N  
ATOM    946  CA  TYR   112      38.642  29.763  90.070  1.00 74.72           C  
ATOM    947  C   TYR   112      37.493  28.757  90.073  1.00 69.62           C  
ATOM    948  O   TYR   112      36.572  28.866  90.882  1.00 78.78           O  
ATOM    949  CB  TYR   112      38.386  30.890  89.057  1.00 72.88           C  
ATOM    950  CG  TYR   112      36.951  31.392  89.019  1.00 74.65           C  
ATOM    951  CD1 TYR   112      36.144  31.159  87.905  1.00 79.19           C  
ATOM    952  CD2 TYR   112      36.398  32.089  90.098  1.00 68.23           C  
ATOM    953  CE1 TYR   112      34.829  31.611  87.860  1.00 84.25           C  
ATOM    954  CE2 TYR   112      35.082  32.543  90.065  1.00 59.00           C  
ATOM    955  CZ  TYR   112      34.305  32.301  88.942  1.00 78.44           C  
ATOM    956  OH  TYR   112      33.004  32.748  88.902  1.00 73.48           O  
ATOM    957  N   VAL   113      37.558  27.778  89.172  1.00 62.73           N  
ATOM    958  CA  VAL   113      36.542  26.726  89.111  1.00 67.82           C  
ATOM    959  C   VAL   113      36.683  25.765  90.301  1.00 71.35           C  
ATOM    960  O   VAL   113      35.686  25.234  90.801  1.00 73.33           O  
ATOM    961  CB  VAL   113      36.566  25.959  87.761  1.00 63.65           C  
ATOM    962  CG1 VAL   113      35.270  25.182  87.569  1.00 54.93           C  
ATOM    963  CG2 VAL   113      36.724  26.935  86.605  1.00 60.95           C  
ATOM    964  N   ALA   114      37.919  25.572  90.765  1.00 76.69           N  
ATOM    965  CA  ALA   114      38.192  24.758  91.953  1.00 80.97           C  
ATOM    966  C   ALA   114      37.709  25.418  93.245  1.00 78.44           C  
ATOM    967  O   ALA   114      37.286  24.727  94.175  1.00 66.02           O  
ATOM    968  CB  ALA   114      39.676  24.435  92.051  1.00 92.18           C  
ATOM    969  N   VAL   115      37.770  26.748  93.296  1.00 75.18           N  
ATOM    970  CA  VAL   115      37.393  27.499  94.499  1.00 59.72           C  
ATOM    971  C   VAL   115      35.870  27.702  94.617  1.00 56.76           C  
ATOM    972  O   VAL   115      35.364  28.046  95.692  1.00 50.37           O  
ATOM    973  CB  VAL   115      38.187  28.845  94.612  1.00 58.85           C  
ATOM    974  CG1 VAL   115      37.478  29.989  93.887  1.00 60.87           C  
ATOM    975  CG2 VAL   115      38.449  29.205  96.073  1.00 56.17           C  
ATOM    976  N   LEU   116      35.151  27.466  93.517  1.00 48.29           N  
ATOM    977  CA  LEU   116      33.690  27.584  93.485  1.00 47.06           C  
ATOM    978  C   LEU   116      33.000  26.504  94.314  1.00 54.39           C  
ATOM    979  O   LEU   116      33.454  25.358  94.365  1.00 65.36           O  
ATOM    980  CB  LEU   116      33.167  27.548  92.044  1.00 49.10           C  
ATOM    981  CG  LEU   116      33.228  28.833  91.208  1.00 59.28           C  
ATOM    982  CD1 LEU   116      33.046  28.512  89.730  1.00 80.25           C  
ATOM    983  CD2 LEU   116      32.196  29.866  91.670  1.00 67.83           C  
ATOM    984  N   GLU   117      31.901  26.889  94.962  1.00 54.18           N  
ATOM    985  CA  GLU   117      31.165  26.003  95.862  1.00 65.51           C  
ATOM    986  C   GLU   117      29.683  25.931  95.498  1.00 73.86           C  
ATOM    987  O   GLU   117      29.170  26.787  94.769  1.00 82.41           O  
ATOM    988  CB  GLU   117      31.321  26.465  97.317  1.00 59.45           C  
ATOM    989  CG  GLU   117      32.745  26.386  97.860  1.00 68.90           C  
ATOM    990  CD  GLU   117      32.862  26.863  99.295  1.00 78.47           C  
ATOM    991  OE1 GLU   117      33.674  27.777  99.552  1.00104.50           O  
ATOM    992  OE2 GLU   117      32.145  26.326 100.167  1.00 96.20           O  
ATOM    993  N   GLU   118      29.011  24.898  96.008  1.00 83.47           N  
ATOM    994  CA  GLU   118      27.568  24.732  95.846  1.00 86.27           C  
ATOM    995  C   GLU   118      26.795  25.804  96.608  1.00 80.52           C  
ATOM    996  O   GLU   118      26.851  25.872  97.838  1.00 81.70           O  
ATOM    997  CB  GLU   118      27.133  23.336  96.304  1.00 92.70           C  
ATOM    998  CG  GLU   118      26.780  22.378  95.173  1.00116.45           C  
ATOM    999  CD  GLU   118      25.311  22.451  94.776  1.00132.68           C  
ATOM   1000  OE1 GLU   118      24.438  22.359  95.671  1.00133.96           O  
ATOM   1001  OE2 GLU   118      25.029  22.589  93.566  1.00138.23           O  
ATOM   1002  N   ASN   119      26.096  26.646  95.853  1.00 71.42           N  
ATOM   1003  CA  ASN   119      25.233  27.688  96.397  1.00 67.20           C  
ATOM   1004  C   ASN   119      23.840  27.099  96.645  1.00 66.23           C  
ATOM   1005  O   ASN   119      23.119  26.792  95.692  1.00 71.02           O  
ATOM   1006  CB  ASN   119      25.201  28.882  95.423  1.00 71.74           C  
ATOM   1007  CG  ASN   119      24.132  29.926  95.778  1.00 54.24           C  
ATOM   1008  OD1 ASN   119      23.699  30.063  96.934  1.00 63.35           O  
ATOM   1009  ND2 ASN   119      23.721  30.686  94.767  1.00 50.59           N  
ATOM   1010  N   PRO   120      23.458  26.941  97.930  1.00 67.17           N  
ATOM   1011  CA  PRO   120      22.210  26.271  98.289  1.00 72.55           C  
ATOM   1012  C   PRO   120      21.014  27.218  98.461  1.00 70.30           C  
ATOM   1013  O   PRO   120      20.143  26.969  99.300  1.00 79.44           O  
ATOM   1014  CB  PRO   120      22.561  25.599  99.621  1.00 75.47           C  
ATOM   1015  CG  PRO   120      23.674  26.451 100.210  1.00 68.75           C  
ATOM   1016  CD  PRO   120      24.189  27.380  99.133  1.00 60.87           C  
ATOM   1017  N   TYR   121      20.976  28.287  97.668  1.00 66.26           N  
ATOM   1018  CA  TYR   121      19.871  29.248  97.703  1.00 70.81           C  
ATOM   1019  C   TYR   121      19.294  29.470  96.308  1.00 75.80           C  
ATOM   1020  O   TYR   121      18.388  30.288  96.117  1.00 86.93           O  
ATOM   1021  CB  TYR   121      20.316  30.569  98.340  1.00 77.51           C  
ATOM   1022  CG  TYR   121      20.838  30.401  99.748  1.00 92.01           C  
ATOM   1023  CD1 TYR   121      22.207  30.339  99.998  1.00102.48           C  
ATOM   1024  CD2 TYR   121      19.964  30.284 100.828  1.00102.41           C  
ATOM   1025  CE1 TYR   121      22.697  30.169 101.288  1.00 93.63           C  
ATOM   1026  CE2 TYR   121      20.443  30.118 102.122  1.00 97.11           C  
ATOM   1027  CZ  TYR   121      21.809  30.060 102.345  1.00 87.71           C  
ATOM   1028  OH  TYR   121      22.287  29.899 103.625  1.00 82.59           O  
ATOM   1029  N   LEU   122      19.823  28.737  95.334  1.00 74.94           N  
ATOM   1030  CA  LEU   122      19.115  28.503  94.081  1.00 73.34           C  
ATOM   1031  C   LEU   122      17.804  27.762  94.319  1.00 73.93           C  
ATOM   1032  O   LEU   122      17.756  26.793  95.077  1.00 74.38           O  
ATOM   1033  CB  LEU   122      19.995  27.716  93.107  1.00 79.27           C  
ATOM   1034  CG  LEU   122      20.942  28.540  92.233  1.00 62.59           C  
ATOM   1035  CD1 LEU   122      20.590  28.382  90.761  1.00104.35           C  
ATOM   1036  CD2 LEU   122      20.914  30.004  92.641  1.00 57.43           C  
ATOM   1037  N   PRO   123      16.742  28.224  93.667  1.00 76.58           N  
ATOM   1038  CA  PRO   123      15.381  27.804  94.014  1.00 86.95           C  
ATOM   1039  C   PRO   123      14.845  26.760  93.040  1.00 94.89           C  
ATOM   1040  O   PRO   123      14.496  25.654  93.452  1.00 96.50           O  
ATOM   1041  CB  PRO   123      14.578  29.099  93.891  1.00 86.25           C  
ATOM   1042  CG  PRO   123      15.321  29.901  92.883  1.00 70.13           C  
ATOM   1043  CD  PRO   123      16.774  29.580  93.092  1.00 71.11           C  
ATOM   1044  N   LYS   124      14.781  27.115  91.761  1.00 99.47           N  
ATOM   1045  CA  LYS   124      13.868  26.464  90.829  1.00 97.66           C  
ATOM   1046  C   LYS   124      14.613  25.927  89.612  1.00 99.29           C  
ATOM   1047  O   LYS   124      15.112  24.802  89.624  1.00 88.83           O  
ATOM   1048  CB  LYS   124      12.771  27.435  90.388  1.00 99.07           C  
ATOM   1049  CG  LYS   124      13.241  28.502  89.414  1.00 88.96           C  
ATOM   1050  CD  LYS   124      12.574  29.839  89.695  1.00 60.45           C  
ATOM   1051  CE  LYS   124      13.040  30.905  88.717  1.00 77.64           C  
ATOM   1052  NZ  LYS   124      14.449  31.314  88.972  1.00103.39           N  
ATOM   1053  N   HIS   125      14.685  26.739  88.562  1.00111.40           N  
ATOM   1054  CA  HIS   125      15.925  27.415  88.199  1.00120.81           C  
ATOM   1055  C   HIS   125      17.084  26.428  88.110  1.00124.10           C  
ATOM   1056  O   HIS   125      17.734  26.312  87.071  1.00130.62           O  
ATOM   1057  CB  HIS   125      16.249  28.518  89.208  1.00122.82           C  
ATOM   1058  CG  HIS   125      17.365  29.419  88.779  1.00132.21           C  
ATOM   1059  ND1 HIS   125      18.064  30.211  89.665  1.00143.34           N  
ATOM   1060  CD2 HIS   125      17.904  29.654  87.559  1.00143.21           C  
ATOM   1061  CE1 HIS   125      18.985  30.895  89.009  1.00148.70           C  
ATOM   1062  NE2 HIS   125      18.909  30.575  87.729  1.00150.43           N  
ATOM   1063  N   ILE   126      17.338  25.720  89.206  1.00122.25           N  
ATOM   1064  CA  ILE   126      18.415  24.739  89.251  1.00119.56           C  
ATOM   1065  C   ILE   126      18.367  23.811  88.042  1.00124.87           C  
ATOM   1066  O   ILE   126      19.190  23.917  87.133  1.00126.05           O  
ATOM   1067  CB  ILE   126      18.355  23.894  90.538  1.00115.52           C  
ATOM   1068  CG1 ILE   126      18.721  24.747  91.754  1.00117.28           C  
ATOM   1069  CG2 ILE   126      19.278  22.690  90.428  1.00100.84           C  
ATOM   1070  CD1 ILE   126      18.542  24.035  93.076  1.00114.50           C  
ATOM   1071  N   GLU   127      17.399  22.901  88.039  1.00130.50           N  
ATOM   1072  CA  GLU   127      17.003  22.207  86.819  1.00132.71           C  
ATOM   1073  C   GLU   127      18.218  21.656  86.079  1.00137.88           C  
ATOM   1074  O   GLU   127      18.103  21.171  84.954  1.00136.92           O  
ATOM   1075  CB  GLU   127      16.210  23.142  85.905  1.00126.44           C  
ATOM   1076  CG  GLU   127      14.859  23.559  86.464  1.00 99.47           C  
ATOM   1077  CD  GLU   127      13.847  23.862  85.377  1.00122.62           C  
ATOM   1078  OE1 GLU   127      14.178  24.633  84.452  1.00137.37           O  
ATOM   1079  OE2 GLU   127      12.719  23.329  85.448  1.00126.82           O  
ATOM   1080  N   VAL   128      19.380  21.735  86.719  1.00143.02           N  
ATOM   1081  CA  VAL   128      20.532  20.979  86.293  1.00146.68           C  
ATOM   1082  C   VAL   128      21.008  20.288  87.563  1.00151.71           C  
ATOM   1083  O   VAL   128      21.691  20.907  88.389  1.00150.33           O  
ATOM   1084  CB  VAL   128      21.676  21.899  85.771  1.00145.68           C  
ATOM   1085  CG1 VAL   128      22.770  21.053  85.159  1.00142.40           C  
ATOM   1086  CG2 VAL   128      21.165  22.927  84.746  1.00132.66           C  
ATOM   1087  N   ASN   129      20.634  19.021  87.751  1.00156.50           N  
ATOM   1088  CA  ASN   129      21.191  18.279  88.885  1.00162.91           C  
ATOM   1089  C   ASN   129      22.515  17.565  88.550  1.00163.98           C  
ATOM   1090  O   ASN   129      22.914  16.584  89.186  1.00164.09           O  
ATOM   1091  CB  ASN   129      20.125  17.460  89.670  1.00166.25           C  
ATOM   1092  CG  ASN   129      19.868  16.049  89.109  1.00174.14           C  
ATOM   1093  OD1 ASN   129      19.621  15.109  89.918  1.00176.80           O  
ATOM   1094  ND2 ASN   129      19.916  15.895  87.743  1.00182.23           N  
ATOM   1095  N   GLU   130      23.181  18.111  87.528  1.00166.46           N  
ATOM   1096  CA  GLU   130      24.549  17.778  87.160  1.00168.88           C  
ATOM   1097  C   GLU   130      25.336  19.072  86.926  1.00167.62           C  
ATOM   1098  O   GLU   130      26.216  19.120  86.065  1.00169.80           O  
ATOM   1099  CB  GLU   130      24.584  16.899  85.901  1.00171.40           C  
ATOM   1100  CG  GLU   130      23.996  15.493  86.061  1.00176.31           C  
ATOM   1101  CD  GLU   130      24.872  14.549  86.877  1.00180.24           C  
ATOM   1102  OE1 GLU   130      26.097  14.784  86.986  1.00187.90           O  
ATOM   1103  OE2 GLU   130      24.327  13.556  87.409  1.00176.77           O  
ATOM   1104  N   LYS   131      25.011  20.114  87.695  1.00166.22           N  
ATOM   1105  CA  LYS   131      25.738  21.390  87.643  1.00166.47           C  
ATOM   1106  C   LYS   131      27.144  21.242  88.227  1.00168.50           C  
ATOM   1107  O   LYS   131      28.032  22.037  87.934  1.00170.14           O  
ATOM   1108  CB  LYS   131      24.953  22.516  88.338  1.00166.91           C  
ATOM   1109  CG  LYS   131      24.650  22.294  89.822  1.00162.29           C  
ATOM   1110  CD  LYS   131      23.619  23.296  90.350  1.00153.11           C  
ATOM   1111  CE  LYS   131      24.202  24.698  90.541  1.00150.31           C  
ATOM   1112  NZ  LYS   131      25.172  24.766  91.672  1.00147.23           N  
ATOM   1113  N   ASP   132      27.317  20.206  89.048  1.00168.43           N  
ATOM   1114  CA  ASP   132      28.619  19.730  89.504  1.00167.51           C  
ATOM   1115  C   ASP   132      29.454  19.211  88.327  1.00164.29           C  
ATOM   1116  O   ASP   132      30.673  19.394  88.293  1.00161.39           O  
ATOM   1117  CB  ASP   132      28.413  18.615  90.539  1.00168.08           C  
ATOM   1118  CG  ASP   132      29.719  18.058  91.079  1.00172.67           C  
ATOM   1119  OD1 ASP   132      30.434  18.792  91.800  1.00177.57           O  
ATOM   1120  OD2 ASP   132      30.022  16.878  90.794  1.00175.86           O  
ATOM   1121  N   ARG   133      28.784  18.572  87.366  1.00161.72           N  
ATOM   1122  CA  ARG   133      29.440  17.992  86.193  1.00156.47           C  
ATOM   1123  C   ARG   133      29.428  18.875  84.939  1.00152.18           C  
ATOM   1124  O   ARG   133      30.107  18.557  83.955  1.00154.16           O  
ATOM   1125  CB  ARG   133      28.848  16.618  85.868  1.00156.09           C  
ATOM   1126  CG  ARG   133      29.700  15.444  86.322  1.00151.99           C  
ATOM   1127  CD  ARG   133      29.161  14.153  85.730  1.00158.43           C  
ATOM   1128  NE  ARG   133      30.133  13.061  85.777  1.00168.95           N  
ATOM   1129  CZ  ARG   133      29.928  11.853  85.255  1.00173.55           C  
ATOM   1130  NH1 ARG   133      28.784  11.570  84.642  1.00167.84           N  
ATOM   1131  NH2 ARG   133      30.870  10.922  85.347  1.00182.13           N  
ATOM   1132  N   LEU   134      28.658  19.963  84.957  1.00143.68           N  
ATOM   1133  CA  LEU   134      28.728  20.936  83.859  1.00136.50           C  
ATOM   1134  C   LEU   134      29.092  22.364  84.278  1.00131.84           C  
ATOM   1135  O   LEU   134      28.673  23.337  83.654  1.00129.34           O  
ATOM   1136  CB  LEU   134      27.522  20.852  82.902  1.00133.97           C  
ATOM   1137  CG  LEU   134      26.057  21.046  83.285  1.00131.61           C  
ATOM   1138  CD1 LEU   134      25.596  22.482  83.071  1.00117.89           C  
ATOM   1139  CD2 LEU   134      25.208  20.084  82.468  1.00134.59           C  
ATOM   1140  N   LEU   135      29.887  22.470  85.343  1.00124.48           N  
ATOM   1141  CA  LEU   135      30.802  23.595  85.500  1.00119.54           C  
ATOM   1142  C   LEU   135      31.929  23.282  84.525  1.00117.09           C  
ATOM   1143  O   LEU   135      32.481  24.179  83.864  1.00111.90           O  
ATOM   1144  CB  LEU   135      31.384  23.652  86.917  1.00117.24           C  
ATOM   1145  CG  LEU   135      30.546  24.017  88.147  1.00114.44           C  
ATOM   1146  CD1 LEU   135      31.173  23.430  89.406  1.00 80.61           C  
ATOM   1147  CD2 LEU   135      30.363  25.516  88.289  1.00124.48           C  
ATOM   1148  N   ALA   136      32.246  21.979  84.469  1.00113.51           N  
ATOM   1149  CA  ALA   136      33.234  21.380  83.564  1.00105.54           C  
ATOM   1150  C   ALA   136      33.027  21.710  82.090  1.00 97.47           C  
ATOM   1151  O   ALA   136      33.984  22.074  81.403  1.00 87.77           O  
ATOM   1152  CB  ALA   136      33.257  19.866  83.755  1.00105.25           C  
ATOM   1153  N   GLU   137      31.784  21.559  81.623  1.00 91.76           N  
ATOM   1154  CA  GLU   137      31.394  21.832  80.236  1.00104.50           C  
ATOM   1155  C   GLU   137      31.785  23.245  79.801  1.00 97.80           C  
ATOM   1156  O   GLU   137      32.379  23.435  78.738  1.00 99.73           O  
ATOM   1157  CB  GLU   137      29.882  21.621  80.076  1.00111.32           C  
ATOM   1158  CG  GLU   137      29.269  22.186  78.794  1.00126.99           C  
ATOM   1159  CD  GLU   137      27.848  22.696  78.989  1.00127.36           C  
ATOM   1160  OE1 GLU   137      27.153  22.908  77.971  1.00144.09           O  
ATOM   1161  OE2 GLU   137      27.425  22.893  80.152  1.00140.64           O  
ATOM   1162  N   ARG   138      31.467  24.220  80.649  1.00 96.98           N  
ATOM   1163  CA  ARG   138      31.740  25.626  80.368  1.00 94.62           C  
ATOM   1164  C   ARG   138      33.204  25.983  80.613  1.00 87.70           C  
ATOM   1165  O   ARG   138      33.720  26.918  80.000  1.00 79.71           O  
ATOM   1166  CB  ARG   138      30.830  26.536  81.199  1.00 95.97           C  
ATOM   1167  CG  ARG   138      29.613  25.830  81.795  1.00 90.70           C  
ATOM   1168  CD  ARG   138      28.379  26.722  81.868  1.00104.95           C  
ATOM   1169  NE  ARG   138      28.698  28.106  82.236  1.00107.84           N  
ATOM   1170  CZ  ARG   138      28.788  28.563  83.487  1.00103.24           C  
ATOM   1171  NH1 ARG   138      29.085  29.843  83.697  1.00 93.93           N  
ATOM   1172  NH2 ARG   138      28.584  27.753  84.529  1.00 64.70           N  
ATOM   1173  N   PHE   139      33.858  25.247  81.516  1.00 77.95           N  
ATOM   1174  CA  PHE   139      35.295  25.398  81.771  1.00 74.41           C  
ATOM   1175  C   PHE   139      36.097  24.969  80.549  1.00 83.45           C  
ATOM   1176  O   PHE   139      37.004  25.690  80.107  1.00 79.15           O  
ATOM   1177  CB  PHE   139      35.728  24.603  83.017  1.00 63.85           C  
ATOM   1178  CG  PHE   139      37.232  24.510  83.209  1.00 72.63           C  
ATOM   1179  CD1 PHE   139      37.868  23.273  83.212  1.00 71.78           C  
ATOM   1180  CD2 PHE   139      38.007  25.650  83.399  1.00 79.68           C  
ATOM   1181  CE1 PHE   139      39.247  23.178  83.402  1.00 62.97           C  
ATOM   1182  CE2 PHE   139      39.383  25.565  83.574  1.00 85.92           C  
ATOM   1183  CZ  PHE   139      40.004  24.327  83.576  1.00 74.84           C  
ATOM   1184  N   LEU   140      35.741  23.789  80.027  1.00 89.76           N  
ATOM   1185  CA  LEU   140      36.295  23.245  78.788  1.00 83.72           C  
ATOM   1186  C   LEU   140      36.123  24.214  77.632  1.00 74.89           C  
ATOM   1187  O   LEU   140      37.104  24.597  76.992  1.00 80.65           O  
ATOM   1188  CB  LEU   140      35.594  21.930  78.440  1.00 85.92           C  
ATOM   1189  CG  LEU   140      35.955  21.255  77.109  1.00 97.88           C  
ATOM   1190  CD1 LEU   140      37.001  20.183  77.324  1.00109.90           C  
ATOM   1191  CD2 LEU   140      34.722  20.695  76.412  1.00 94.45           C  
ATOM   1192  N   GLU   141      34.867  24.601  77.394  1.00 62.12           N  
ATOM   1193  CA  GLU   141      34.477  25.525  76.331  1.00 72.91           C  
ATOM   1194  C   GLU   141      35.274  26.826  76.372  1.00 70.76           C  
ATOM   1195  O   GLU   141      35.735  27.296  75.338  1.00 61.12           O  
ATOM   1196  CB  GLU   141      32.975  25.820  76.419  1.00 71.12           C  
ATOM   1197  CG  GLU   141      32.398  26.627  75.259  1.00 87.40           C  
ATOM   1198  CD  GLU   141      30.977  27.108  75.518  1.00117.73           C  
ATOM   1199  OE1 GLU   141      30.327  27.574  74.559  1.00128.96           O  
ATOM   1200  OE2 GLU   141      30.506  27.026  76.675  1.00129.54           O  
ATOM   1201  N   GLU   142      35.450  27.380  77.572  1.00 70.57           N  
ATOM   1202  CA  GLU   142      36.199  28.624  77.756  1.00 70.18           C  
ATOM   1203  C   GLU   142      37.710  28.475  77.600  1.00 57.86           C  
ATOM   1204  O   GLU   142      38.347  29.335  76.997  1.00 51.15           O  
ATOM   1205  CB  GLU   142      35.874  29.271  79.104  1.00 63.85           C  
ATOM   1206  CG  GLU   142      34.630  30.143  79.089  1.00 64.36           C  
ATOM   1207  CD  GLU   142      34.770  31.346  78.172  1.00 80.51           C  
ATOM   1208  OE1 GLU   142      33.866  31.559  77.339  1.00 90.24           O  
ATOM   1209  OE2 GLU   142      35.783  32.072  78.277  1.00 95.88           O  
ATOM   1210  N   SER   143      38.276  27.398  78.148  1.00 46.49           N  
ATOM   1211  CA  SER   143      39.715  27.131  78.045  1.00 54.07           C  
ATOM   1212  C   SER   143      40.127  26.814  76.608  1.00 61.59           C  
ATOM   1213  O   SER   143      41.213  27.200  76.171  1.00 59.40           O  
ATOM   1214  CB  SER   143      40.132  25.991  78.978  1.00 53.73           C  
ATOM   1215  OG  SER   143      39.842  26.307  80.332  1.00 68.77           O  
ATOM   1216  N   VAL   144      39.248  26.114  75.887  1.00 64.71           N  
ATOM   1217  CA  VAL   144      39.433  25.831  74.461  1.00 57.48           C  
ATOM   1218  C   VAL   144      39.257  27.105  73.622  1.00 64.86           C  
ATOM   1219  O   VAL   144      40.089  27.390  72.755  1.00 70.26           O  
ATOM   1220  CB  VAL   144      38.493  24.679  73.977  1.00 51.67           C  
ATOM   1221  CG1 VAL   144      38.338  24.659  72.456  1.00 44.75           C  
ATOM   1222  CG2 VAL   144      39.000  23.330  74.475  1.00 55.62           C  
ATOM   1223  N   PHE   145      38.192  27.865  73.900  1.00 66.42           N  
ATOM   1224  CA  PHE   145      37.913  29.135  73.211  1.00 76.46           C  
ATOM   1225  C   PHE   145      39.072  30.110  73.345  1.00 77.87           C  
ATOM   1226  O   PHE   145      39.564  30.632  72.343  1.00 57.57           O  
ATOM   1227  CB  PHE   145      36.632  29.795  73.747  1.00 75.46           C  
ATOM   1228  CG  PHE   145      36.284  31.102  73.075  1.00 87.93           C  
ATOM   1229  CD1 PHE   145      35.535  31.112  71.903  1.00 96.65           C  
ATOM   1230  CD2 PHE   145      36.693  32.322  73.623  1.00100.65           C  
ATOM   1231  CE1 PHE   145      35.209  32.311  71.279  1.00105.76           C  
ATOM   1232  CE2 PHE   145      36.376  33.527  73.002  1.00 89.52           C  
ATOM   1233  CZ  PHE   145      35.632  33.521  71.827  1.00 97.76           C  
ATOM   1234  N   SER   146      39.485  30.349  74.591  1.00 85.48           N  
ATOM   1235  CA  SER   146      40.549  31.297  74.905  1.00 84.48           C  
ATOM   1236  C   SER   146      41.874  30.888  74.286  1.00 81.30           C  
ATOM   1237  O   SER   146      42.569  31.739  73.741  1.00 78.40           O  
ATOM   1238  CB  SER   146      40.714  31.464  76.415  1.00 90.99           C  
ATOM   1239  OG  SER   146      41.039  30.226  77.021  1.00 88.16           O  
ATOM   1240  N   PHE   147      42.209  29.595  74.357  1.00 72.76           N  
ATOM   1241  CA  PHE   147      43.453  29.093  73.766  1.00 60.52           C  
ATOM   1242  C   PHE   147      43.495  29.341  72.268  1.00 58.73           C  
ATOM   1243  O   PHE   147      44.467  29.906  71.775  1.00 58.69           O  
ATOM   1244  CB  PHE   147      43.700  27.603  74.045  1.00 59.05           C  
ATOM   1245  CG  PHE   147      45.082  27.141  73.649  1.00 79.27           C  
ATOM   1246  CD1 PHE   147      45.370  26.775  72.332  1.00 95.03           C  
ATOM   1247  CD2 PHE   147      46.105  27.096  74.590  1.00 94.94           C  
ATOM   1248  CE1 PHE   147      46.649  26.382  71.960  1.00 99.11           C  
ATOM   1249  CE2 PHE   147      47.388  26.687  74.230  1.00103.59           C  
ATOM   1250  CZ  PHE   147      47.659  26.328  72.914  1.00103.17           C  
ATOM   1251  N   ARG   148      42.449  28.908  71.561  1.00 56.45           N  
ATOM   1252  CA  ARG   148      42.353  29.089  70.112  1.00 66.02           C  
ATOM   1253  C   ARG   148      42.444  30.565  69.734  1.00 64.81           C  
ATOM   1254  O   ARG   148      43.113  30.913  68.768  1.00 60.81           O  
ATOM   1255  CB  ARG   148      41.070  28.463  69.550  1.00 69.58           C  
ATOM   1256  CG  ARG   148      41.059  26.938  69.552  1.00 87.35           C  
ATOM   1257  CD  ARG   148      40.281  26.392  68.359  1.00106.94           C  
ATOM   1258  NE  ARG   148      39.961  24.972  68.511  1.00110.94           N  
ATOM   1259  CZ  ARG   148      38.720  24.477  68.537  1.00115.08           C  
ATOM   1260  NH1 ARG   148      37.659  25.281  68.415  1.00124.74           N  
ATOM   1261  NH2 ARG   148      38.539  23.170  68.679  1.00109.53           N  
ATOM   1262  N   ARG   149      41.797  31.418  70.529  1.00 71.52           N  
ATOM   1263  CA  ARG   149      41.869  32.872  70.377  1.00 72.50           C  
ATOM   1264  C   ARG   149      43.273  33.430  70.665  1.00 75.06           C  
ATOM   1265  O   ARG   149      43.764  34.272  69.911  1.00 65.23           O  
ATOM   1266  CB  ARG   149      40.816  33.544  71.267  1.00 67.03           C  
ATOM   1267  CG  ARG   149      40.778  35.061  71.204  1.00 73.40           C  
ATOM   1268  CD  ARG   149      39.642  35.600  72.050  1.00103.29           C  
ATOM   1269  NE  ARG   149      40.067  36.735  72.865  1.00120.85           N  
ATOM   1270  CZ  ARG   149      40.533  36.633  74.109  1.00134.65           C  
ATOM   1271  NH1 ARG   149      40.638  35.446  74.700  1.00121.87           N  
ATOM   1272  NH2 ARG   149      40.895  37.725  74.768  1.00154.18           N  
ATOM   1273  N   GLU   150      43.905  32.955  71.743  1.00 74.27           N  
ATOM   1274  CA  GLU   150      45.288  33.324  72.090  1.00 75.73           C  
ATOM   1275  C   GLU   150      46.269  32.848  71.026  1.00 73.14           C  
ATOM   1276  O   GLU   150      47.253  33.533  70.724  1.00 75.28           O  
ATOM   1277  CB  GLU   150      45.697  32.734  73.446  1.00 83.69           C  
ATOM   1278  CG  GLU   150      45.168  33.476  74.673  1.00114.64           C  
ATOM   1279  CD  GLU   150      46.134  34.521  75.201  1.00141.80           C  
ATOM   1280  OE1 GLU   150      46.621  34.350  76.340  1.00152.55           O  
ATOM   1281  OE2 GLU   150      46.411  35.510  74.485  1.00137.85           O  
ATOM   1282  N   ARG   151      45.987  31.664  70.478  1.00 71.22           N  
ATOM   1283  CA  ARG   151      46.755  31.088  69.382  1.00 76.62           C  
ATOM   1284  C   ARG   151      46.594  31.926  68.119  1.00 79.08           C  
ATOM   1285  O   ARG   151      47.592  32.301  67.504  1.00 72.14           O  
ATOM   1286  CB  ARG   151      46.328  29.636  69.127  1.00 81.50           C  
ATOM   1287  CG  ARG   151      47.387  28.773  68.463  1.00103.35           C  
ATOM   1288  CD  ARG   151      48.667  28.736  69.292  1.00129.47           C  
ATOM   1289  NE  ARG   151      49.844  28.545  68.449  1.00151.64           N  
ATOM   1290  CZ  ARG   151      50.499  29.523  67.825  1.00159.51           C  
ATOM   1291  NH1 ARG   151      50.106  30.787  67.944  1.00161.59           N  
ATOM   1292  NH2 ARG   151      51.557  29.236  67.080  1.00164.07           N  
ATOM   1293  N   LEU   152      45.342  32.225  67.758  1.00 75.71           N  
ATOM   1294  CA  LEU   152      45.017  33.074  66.603  1.00 77.27           C  
ATOM   1295  C   LEU   152      45.658  34.458  66.684  1.00 72.85           C  
ATOM   1296  O   LEU   152      46.334  34.877  65.745  1.00 68.69           O  
ATOM   1297  CB  LEU   152      43.495  33.218  66.415  1.00 81.40           C  
ATOM   1298  CG  LEU   152      42.718  32.518  65.281  1.00 84.07           C  
ATOM   1299  CD1 LEU   152      43.486  32.572  63.946  1.00 68.82           C  
ATOM   1300  CD2 LEU   152      42.353  31.064  65.625  1.00 83.77           C  
ATOM   1301  N   LEU   153      45.465  35.141  67.816  1.00 68.30           N  
ATOM   1302  CA  LEU   153      45.988  36.499  68.037  1.00 65.07           C  
ATOM   1303  C   LEU   153      47.515  36.592  68.038  1.00 68.44           C  
ATOM   1304  O   LEU   153      48.074  37.660  67.773  1.00 68.83           O  
ATOM   1305  CB  LEU   153      45.435  37.098  69.337  1.00 47.32           C  
ATOM   1306  CG  LEU   153      44.009  37.664  69.330  1.00 72.83           C  
ATOM   1307  CD1 LEU   153      43.474  37.766  70.751  1.00 75.17           C  
ATOM   1308  CD2 LEU   153      43.944  39.023  68.629  1.00 65.76           C  
ATOM   1309  N   LYS   154      48.177  35.477  68.343  1.00 62.19           N  
ATOM   1310  CA  LYS   154      49.632  35.388  68.269  1.00 65.37           C  
ATOM   1311  C   LYS   154      50.101  35.398  66.811  1.00 69.21           C  
ATOM   1312  O   LYS   154      51.031  36.129  66.463  1.00 73.82           O  
ATOM   1313  CB  LYS   154      50.132  34.128  68.986  1.00 75.17           C  
ATOM   1314  CG  LYS   154      51.630  34.115  69.274  1.00 90.55           C  
ATOM   1315  CD  LYS   154      52.053  32.815  69.956  1.00 84.35           C  
ATOM   1316  CE  LYS   154      53.547  32.803  70.259  1.00112.15           C  
ATOM   1317  NZ  LYS   154      53.906  33.701  71.408  1.00110.82           N  
ATOM   1318  N   GLN   155      49.435  34.603  65.971  1.00 73.88           N  
ATOM   1319  CA  GLN   155      49.824  34.421  64.566  1.00 78.76           C  
ATOM   1320  C   GLN   155      49.559  35.644  63.687  1.00 74.50           C  
ATOM   1321  O   GLN   155      50.288  35.873  62.719  1.00 64.20           O  
ATOM   1322  CB  GLN   155      49.139  33.189  63.960  1.00 73.72           C  
ATOM   1323  CG  GLN   155      49.277  31.912  64.819  1.00 93.60           C  
ATOM   1324  CD  GLN   155      48.923  30.663  64.004  1.00104.78           C  
ATOM   1325  OE1 GLN   155      49.569  30.349  62.990  1.00109.54           O  
ATOM   1326  NE2 GLN   155      47.904  29.929  64.454  1.00106.81           N  
ATOM   1327  N   ILE   156      48.513  36.406  64.024  1.00 65.67           N  
ATOM   1328  CA  ILE   156      48.171  37.660  63.333  1.00 69.28           C  
ATOM   1329  C   ILE   156      49.313  38.672  63.461  1.00 75.10           C  
ATOM   1330  O   ILE   156      49.699  39.322  62.483  1.00 64.94           O  
ATOM   1331  CB  ILE   156      46.853  38.279  63.890  1.00 66.32           C  
ATOM   1332  CG1 ILE   156      45.675  37.330  63.673  1.00 73.15           C  
ATOM   1333  CG2 ILE   156      46.544  39.630  63.236  1.00 72.47           C  
ATOM   1334  CD1 ILE   156      44.520  37.556  64.620  1.00 72.32           C  
ATOM   1335  N   ASP   157      49.859  38.769  64.673  1.00 84.79           N  
ATOM   1336  CA  ASP   157      50.978  39.658  64.978  1.00 90.40           C  
ATOM   1337  C   ASP   157      52.280  39.190  64.321  1.00 94.53           C  
ATOM   1338  O   ASP   157      53.126  40.013  63.961  1.00 94.91           O  
ATOM   1339  CB  ASP   157      51.162  39.782  66.495  1.00 93.65           C  
ATOM   1340  CG  ASP   157      49.945  40.385  67.195  1.00100.18           C  
ATOM   1341  OD1 ASP   157      48.845  40.422  66.600  1.00109.63           O  
ATOM   1342  OD2 ASP   157      50.094  40.822  68.355  1.00105.64           O  
ATOM   1343  N   GLU   158      52.429  37.872  64.172  1.00 95.46           N  
ATOM   1344  CA  GLU   158      53.559  37.275  63.453  1.00 98.92           C  
ATOM   1345  C   GLU   158      53.437  37.491  61.946  1.00 97.21           C  
ATOM   1346  O   GLU   158      54.445  37.611  61.245  1.00 94.11           O  
ATOM   1347  CB  GLU   158      53.652  35.773  63.733  1.00102.70           C  
ATOM   1348  CG  GLU   158      54.014  35.401  65.176  1.00118.28           C  
ATOM   1349  CD  GLU   158      53.657  33.957  65.511  1.00147.57           C  
ATOM   1350  OE1 GLU   158      53.937  33.529  66.654  1.00159.25           O  
ATOM   1351  OE2 GLU   158      53.097  33.247  64.640  1.00157.29           O  
ATOM   1352  N   ALA   159      52.198  37.518  61.456  1.00 89.56           N  
ATOM   1353  CA  ALA   159      51.914  37.762  60.041  1.00 81.83           C  
ATOM   1354  C   ALA   159      52.113  39.232  59.686  1.00 78.16           C  
ATOM   1355  O   ALA   159      52.569  39.554  58.583  1.00 69.30           O  
ATOM   1356  CB  ALA   159      50.499  37.316  59.690  1.00 80.05           C  
ATOM   1357  N   LEU   160      51.766  40.114  60.627  1.00 82.35           N  
ATOM   1358  CA  LEU   160      51.998  41.552  60.488  1.00 89.16           C  
ATOM   1359  C   LEU   160      53.486  41.884  60.566  1.00 90.27           C  
ATOM   1360  O   LEU   160      53.940  42.863  59.974  1.00 83.37           O  
ATOM   1361  CB  LEU   160      51.227  42.331  61.559  1.00 82.86           C  
ATOM   1362  CG  LEU   160      49.733  42.572  61.320  1.00 76.37           C  
ATOM   1363  CD1 LEU   160      48.985  42.706  62.639  1.00 84.08           C  
ATOM   1364  CD2 LEU   160      49.496  43.793  60.433  1.00100.86           C  
ATOM   1365  N   ASP   161      54.228  41.059  61.304  1.00 91.85           N  
ATOM   1366  CA  ASP   161      55.684  41.153  61.403  1.00100.86           C  
ATOM   1367  C   ASP   161      56.372  40.828  60.073  1.00108.28           C  
ATOM   1368  O   ASP   161      57.334  41.497  59.686  1.00114.55           O  
ATOM   1369  CB  ASP   161      56.193  40.215  62.509  1.00105.02           C  
ATOM   1370  CG  ASP   161      57.712  40.149  62.579  1.00118.94           C  
ATOM   1371  OD1 ASP   161      58.363  41.216  62.619  1.00123.36           O  
ATOM   1372  OD2 ASP   161      58.255  39.022  62.607  1.00119.40           O  
ATOM   1373  N   LYS   162      55.865  39.810  59.381  1.00109.05           N  
ATOM   1374  CA  LYS   162      56.491  39.301  58.157  1.00106.28           C  
ATOM   1375  C   LYS   162      55.835  39.827  56.877  1.00108.25           C  
ATOM   1376  O   LYS   162      56.156  39.364  55.776  1.00113.51           O  
ATOM   1377  CB  LYS   162      56.497  37.768  58.168  1.00103.73           C  
ATOM   1378  CG  LYS   162      57.313  37.162  59.301  1.00100.56           C  
ATOM   1379  CD  LYS   162      56.848  35.755  59.629  1.00 97.37           C  
ATOM   1380  CE  LYS   162      57.421  35.288  60.962  1.00 89.05           C  
ATOM   1381  NZ  LYS   162      56.849  33.981  61.392  1.00 68.97           N  
ATOM   1382  N   GLN   163      54.923  40.792  57.041  1.00102.08           N  
ATOM   1383  CA  GLN   163      54.162  41.438  55.948  1.00 93.16           C  
ATOM   1384  C   GLN   163      53.322  40.462  55.112  1.00 87.88           C  
ATOM   1385  O   GLN   163      53.017  40.722  53.943  1.00 91.97           O  
ATOM   1386  CB  GLN   163      55.065  42.316  55.060  1.00 94.17           C  
ATOM   1387  CG  GLN   163      55.975  43.270  55.844  1.00108.02           C  
ATOM   1388  CD  GLN   163      56.477  44.439  55.002  1.00134.52           C  
ATOM   1389  OE1 GLN   163      56.384  44.433  53.770  1.00148.99           O  
ATOM   1390  NE2 GLN   163      57.018  45.453  55.671  1.00136.35           N  
ATOM   1391  N   ASP   164      52.947  39.348  55.736  1.00 84.04           N  
ATOM   1392  CA  ASP   164      52.146  38.315  55.101  1.00 80.22           C  
ATOM   1393  C   ASP   164      50.683  38.755  55.112  1.00 75.36           C  
ATOM   1394  O   ASP   164      49.931  38.443  56.041  1.00 56.40           O  
ATOM   1395  CB  ASP   164      52.344  36.982  55.831  1.00 86.52           C  
ATOM   1396  CG  ASP   164      52.066  35.782  54.949  1.00 96.72           C  
ATOM   1397  OD1 ASP   164      53.028  35.214  54.390  1.00114.82           O  
ATOM   1398  OD2 ASP   164      50.889  35.406  54.813  1.00 94.55           O  
ATOM   1399  N   LYS   165      50.307  39.503  54.073  1.00 75.59           N  
ATOM   1400  CA  LYS   165      48.963  40.069  53.919  1.00 89.20           C  
ATOM   1401  C   LYS   165      47.926  38.970  53.700  1.00 90.05           C  
ATOM   1402  O   LYS   165      46.758  39.109  54.107  1.00 82.51           O  
ATOM   1403  CB  LYS   165      48.946  41.051  52.744  1.00 90.79           C  
ATOM   1404  CG  LYS   165      47.847  42.096  52.816  1.00 94.61           C  
ATOM   1405  CD  LYS   165      47.936  43.058  51.642  1.00109.41           C  
ATOM   1406  CE  LYS   165      46.998  44.244  51.818  1.00112.18           C  
ATOM   1407  NZ  LYS   165      45.557  43.853  51.797  1.00100.23           N  
ATOM   1408  N   GLU   166      48.377  37.907  53.018  1.00 89.90           N  
ATOM   1409  CA  GLU   166      47.702  36.609  52.958  1.00 86.66           C  
ATOM   1410  C   GLU   166      47.109  36.186  54.297  1.00 92.06           C  
ATOM   1411  O   GLU   166      45.890  36.223  54.479  1.00 92.76           O  
ATOM   1412  CB  GLU   166      48.717  35.545  52.531  1.00 85.52           C  
ATOM   1413  CG  GLU   166      48.748  35.197  51.067  1.00 94.57           C  
ATOM   1414  CD  GLU   166      48.068  33.874  50.773  1.00 92.78           C  
ATOM   1415  OE1 GLU   166      48.571  33.131  49.904  1.00 81.70           O  
ATOM   1416  OE2 GLU   166      47.033  33.570  51.406  1.00 91.07           O  
ATOM   1417  N   ALA   167      47.993  35.809  55.225  1.00 93.30           N  
ATOM   1418  CA  ALA   167      47.614  35.245  56.520  1.00 87.68           C  
ATOM   1419  C   ALA   167      46.807  36.191  57.392  1.00 85.88           C  
ATOM   1420  O   ALA   167      45.864  35.755  58.038  1.00 64.46           O  
ATOM   1421  CB  ALA   167      48.840  34.741  57.277  1.00 84.02           C  
ATOM   1422  N   PHE   168      47.172  37.475  57.394  1.00 92.12           N  
ATOM   1423  CA  PHE   168      46.454  38.492  58.172  1.00 91.98           C  
ATOM   1424  C   PHE   168      44.946  38.393  57.955  1.00 89.50           C  
ATOM   1425  O   PHE   168      44.197  38.213  58.910  1.00 77.45           O  
ATOM   1426  CB  PHE   168      46.953  39.908  57.843  1.00 91.45           C  
ATOM   1427  CG  PHE   168      46.221  41.002  58.585  1.00105.66           C  
ATOM   1428  CD1 PHE   168      45.224  41.749  57.955  1.00133.10           C  
ATOM   1429  CD2 PHE   168      46.527  41.284  59.913  1.00110.96           C  
ATOM   1430  CE1 PHE   168      44.543  42.755  58.639  1.00140.33           C  
ATOM   1431  CE2 PHE   168      45.854  42.289  60.605  1.00117.51           C  
ATOM   1432  CZ  PHE   168      44.860  43.026  59.966  1.00128.58           C  
ATOM   1433  N   HIS   169      44.525  38.474  56.693  1.00 92.89           N  
ATOM   1434  CA  HIS   169      43.112  38.393  56.320  1.00 93.13           C  
ATOM   1435  C   HIS   169      42.511  37.000  56.470  1.00 93.06           C  
ATOM   1436  O   HIS   169      41.298  36.872  56.666  1.00 89.48           O  
ATOM   1437  CB  HIS   169      42.906  38.887  54.891  1.00 95.30           C  
ATOM   1438  CG  HIS   169      43.060  40.366  54.742  1.00 91.10           C  
ATOM   1439  ND1 HIS   169      42.088  41.258  55.139  1.00 71.00           N  
ATOM   1440  CD2 HIS   169      44.073  41.111  54.242  1.00 94.45           C  
ATOM   1441  CE1 HIS   169      42.495  42.489  54.890  1.00 94.35           C  
ATOM   1442  NE2 HIS   169      43.697  42.428  54.344  1.00 99.18           N  
ATOM   1443  N   ARG   170      43.349  35.967  56.353  1.00 85.94           N  
ATOM   1444  CA  ARG   170      42.920  34.600  56.642  1.00 87.65           C  
ATOM   1445  C   ARG   170      42.591  34.492  58.127  1.00 89.38           C  
ATOM   1446  O   ARG   170      41.479  34.114  58.488  1.00 87.31           O  
ATOM   1447  CB  ARG   170      43.996  33.568  56.275  1.00 86.82           C  
ATOM   1448  CG  ARG   170      44.280  33.398  54.784  1.00 92.58           C  
ATOM   1449  CD  ARG   170      45.032  32.091  54.487  1.00122.98           C  
ATOM   1450  NE  ARG   170      45.819  31.613  55.631  1.00148.50           N  
ATOM   1451  CZ  ARG   170      47.147  31.684  55.736  1.00149.79           C  
ATOM   1452  NH1 ARG   170      47.881  32.210  54.760  1.00144.98           N  
ATOM   1453  NH2 ARG   170      47.746  31.216  56.826  1.00148.62           N  
ATOM   1454  N   LEU   171      43.551  34.874  58.970  1.00 93.51           N  
ATOM   1455  CA  LEU   171      43.452  34.718  60.426  1.00 89.67           C  
ATOM   1456  C   LEU   171      42.479  35.685  61.112  1.00 96.30           C  
ATOM   1457  O   LEU   171      41.901  35.336  62.145  1.00 96.58           O  
ATOM   1458  CB  LEU   171      44.838  34.806  61.086  1.00 84.91           C  
ATOM   1459  CG  LEU   171      45.993  33.919  60.597  1.00 67.24           C  
ATOM   1460  CD1 LEU   171      47.327  34.567  60.936  1.00 52.99           C  
ATOM   1461  CD2 LEU   171      45.937  32.496  61.136  1.00 25.36           C  
ATOM   1462  N   THR   172      42.313  36.889  60.555  1.00 96.62           N  
ATOM   1463  CA  THR   172      41.340  37.863  61.073  1.00 93.35           C  
ATOM   1464  C   THR   172      39.922  37.325  60.884  1.00 92.58           C  
ATOM   1465  O   THR   172      39.112  37.359  61.812  1.00 80.77           O  
ATOM   1466  CB  THR   172      41.479  39.262  60.406  1.00 96.10           C  
ATOM   1467  OG1 THR   172      42.834  39.715  60.512  1.00 94.44           O  
ATOM   1468  CG2 THR   172      40.566  40.289  61.072  1.00 92.44           C  
ATOM   1469  N   ALA   173      39.649  36.800  59.690  1.00 94.45           N  
ATOM   1470  CA  ALA   173      38.363  36.178  59.375  1.00 96.42           C  
ATOM   1471  C   ALA   173      38.179  34.824  60.069  1.00 96.31           C  
ATOM   1472  O   ALA   173      37.045  34.397  60.304  1.00 93.83           O  
ATOM   1473  CB  ALA   173      38.196  36.033  57.868  1.00 97.32           C  
ATOM   1474  N   GLU   174      39.292  34.155  60.381  1.00 97.86           N  
ATOM   1475  CA  GLU   174      39.281  32.901  61.147  1.00 98.15           C  
ATOM   1476  C   GLU   174      38.821  33.127  62.583  1.00105.52           C  
ATOM   1477  O   GLU   174      38.040  32.338  63.120  1.00110.13           O  
ATOM   1478  CB  GLU   174      40.672  32.255  61.165  1.00 93.96           C  
ATOM   1479  CG  GLU   174      40.961  31.305  60.008  1.00 97.37           C  
ATOM   1480  CD  GLU   174      40.673  29.846  60.327  1.00119.57           C  
ATOM   1481  OE1 GLU   174      41.121  28.976  59.550  1.00123.19           O  
ATOM   1482  OE2 GLU   174      40.008  29.561  61.347  1.00118.20           O  
ATOM   1483  N   LEU   175      39.311  34.205  63.195  1.00110.06           N  
ATOM   1484  CA  LEU   175      38.984  34.533  64.583  1.00115.43           C  
ATOM   1485  C   LEU   175      37.571  35.112  64.702  1.00119.52           C  
ATOM   1486  O   LEU   175      36.930  34.965  65.743  1.00121.42           O  
ATOM   1487  CB  LEU   175      40.038  35.480  65.187  1.00114.42           C  
ATOM   1488  CG  LEU   175      39.709  36.943  65.515  1.00116.07           C  
ATOM   1489  CD1 LEU   175      39.452  37.113  67.010  1.00111.43           C  
ATOM   1490  CD2 LEU   175      40.820  37.868  65.070  1.00104.39           C  
ATOM   1491  N   LYS   176      37.100  35.759  63.630  1.00119.31           N  
ATOM   1492  CA  LYS   176      35.740  36.308  63.551  1.00111.26           C  
ATOM   1493  C   LYS   176      34.679  35.212  63.637  1.00109.72           C  
ATOM   1494  O   LYS   176      33.591  35.428  64.179  1.00110.92           O  
ATOM   1495  CB  LYS   176      35.548  37.094  62.250  1.00107.68           C  
ATOM   1496  CG  LYS   176      36.045  38.530  62.284  1.00111.15           C  
ATOM   1497  CD  LYS   176      36.005  39.143  60.890  1.00112.05           C  
ATOM   1498  CE  LYS   176      36.656  40.516  60.861  1.00107.77           C  
ATOM   1499  NZ  LYS   176      36.659  41.098  59.489  1.00 96.87           N  
ATOM   1500  N   MET   177      35.019  34.044  63.089  1.00108.45           N  
ATOM   1501  CA  MET   177      34.175  32.851  63.119  1.00114.36           C  
ATOM   1502  C   MET   177      33.998  32.289  64.538  1.00110.70           C  
ATOM   1503  O   MET   177      32.921  31.794  64.881  1.00115.95           O  
ATOM   1504  CB  MET   177      34.781  31.781  62.200  1.00114.15           C  
ATOM   1505  CG  MET   177      33.955  30.509  62.036  1.00117.22           C  
ATOM   1506  SD  MET   177      34.919  29.117  61.405  1.00131.42           S  
ATOM   1507  CE  MET   177      35.877  28.663  62.854  1.00105.31           C  
ATOM   1508  N   LEU   178      35.052  32.387  65.350  1.00107.19           N  
ATOM   1509  CA  LEU   178      35.109  31.758  66.681  1.00106.52           C  
ATOM   1510  C   LEU   178      34.101  32.268  67.718  1.00114.78           C  
ATOM   1511  O   LEU   178      33.412  31.466  68.358  1.00116.74           O  
ATOM   1512  CB  LEU   178      36.529  31.838  67.259  1.00101.97           C  
ATOM   1513  CG  LEU   178      37.446  30.613  67.088  1.00100.79           C  
ATOM   1514  CD1 LEU   178      38.892  30.985  67.386  1.00 99.48           C  
ATOM   1515  CD2 LEU   178      37.004  29.455  67.988  1.00 78.49           C  
END
