
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  142 ( 1146),  selected  142 , name 2hq7_B
# Molecule2: number of CA atoms  145 ( 1098),  selected  145 , name T0497.pdb
# PARAMETERS: 2hq7_B.T0497.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    -       -      M       1           -
LGA    -       -      A       2           -
LGA    I     2_B      D       3          3.097
LGA    D     3_B      P       4           #
LGA    E     4_B      K       5          3.505
LGA    K     5_B      E       6          2.342
LGA    F     6_B      L       7          1.356
LGA    L     7_B      Q       8          2.390
LGA    I     8_B      D       9          2.442
LGA    E     9_B      K      10          1.608
LGA    S    10_B      F      11          1.364
LGA    N    11_B      W      12          2.355
LGA    E    12_B      K      13          2.317
LGA    L    13_B      A      14          1.263
LGA    V    14_B      L      15          0.969
LGA    E    15_B      K      16          2.218
LGA    S    16_B      S      17          2.348
LGA    S    17_B      D      18          1.500
LGA    K    18_B      R      19          3.293
LGA    I    19_B      T      20          2.539
LGA    V    20_B      V      21          2.437
LGA    X    21_B      M      22          2.138
LGA    V    22_B      L      23          1.672
LGA    G    23_B      G      24          2.106
LGA    T    24_B      L      25          1.715
LGA    N    25_B      D      26          3.895
LGA    G    26_B      G      27           -
LGA    E    27_B      -       -           -
LGA    N    28_B      V      28          5.582
LGA    G    29_B      E      29          2.221
LGA    Y    30_B      D      30          3.309
LGA    P    31_B      G      31          2.489
LGA    N    32_B      H      32          2.909
LGA    I    33_B      A      33          1.476
LGA    K    34_B      R      34          1.291
LGA    A    35_B      P      35          1.458
LGA    X    36_B      M      36          1.465
LGA    X    37_B      T      37          1.960
LGA    R    38_B      A      38          2.299
LGA    L    39_B      Q      39          3.131
LGA    K    40_B      I      40          2.307
LGA    H    41_B      E      41          4.096
LGA    D    42_B      G      42          5.097
LGA    G    43_B      D      43          5.350
LGA    L    44_B      S      44          5.366
LGA    K    45_B      G      45          3.425
LGA    K    46_B      G      46          0.971
LGA    -       -      P      47           -
LGA    F    47_B      I      48          1.096
LGA    W    48_B      W      49          1.588
LGA    L    49_B      F      50          1.536
LGA    S    50_B      F      51          0.904
LGA    T    51_B      T      52          1.414
LGA    N    52_B      S      53          1.664
LGA    T    53_B      K      54          1.555
LGA    S    54_B      D      55          1.311
LGA    T    55_B      N      56           #
LGA    R    56_B      A      57          3.206
LGA    X    57_B      L      58          2.130
LGA    V    58_B      I      59          1.566
LGA    E    59_B      A      60          1.181
LGA    R    60_B      M      61          1.038
LGA    L    61_B      L      62          1.411
LGA    K    62_B      G      63          1.826
LGA    K    63_B      Q      64           #
LGA    N    64_B      G      65          5.452
LGA    N    65_B      R      66          1.481
LGA    K    66_B      R      67          0.813
LGA    I    67_B      V      68          1.238
LGA    C    68_B      I      69          2.343
LGA    L    69_B      G      70          2.307
LGA    Y    70_B      A      71          2.741
LGA    F    71_B      F      72          2.067
LGA    V    72_B      S      73          0.533
LGA    D    73_B      S      74          2.878
LGA    D    74_B      K      75          6.066
LGA    N    75_B      G      76          3.461
LGA    K    76_B      H      77          3.281
LGA    F    77_B      D      78          4.930
LGA    A    78_B      L      79          2.508
LGA    G    79_B      F      80          0.772
LGA    L    80_B      A      81          1.463
LGA    X    81_B      S      82          1.942
LGA    L    82_B      I      83          1.604
LGA    V    83_B      S      84          0.786
LGA    G    84_B      G      85          0.695
LGA    T    85_B      S      86          0.574
LGA    I    86_B      L      87          1.859
LGA    E    87_B      R      88          2.262
LGA    I    88_B      E      89          0.924
LGA    L    89_B      D      90          1.323
LGA    H    90_B      T      91          3.102
LGA    D    91_B      D      92          3.400
LGA    R    92_B      P      93          2.493
LGA    A    93_B      A      94          2.929
LGA    S    94_B      V      95          2.769
LGA    K    95_B      V      96          2.079
LGA    E    96_B      D      97          2.311
LGA    X    97_B      R      98          2.753
LGA    L    98_B      L      99          2.412
LGA    W    99_B      W     100          1.613
LGA    T   100_B      N     101          1.788
LGA    D   101_B      P     102          1.874
LGA    G   102_B      Y     103          1.117
LGA    C   103_B      V     104          1.100
LGA    E   104_B      A     105          1.478
LGA    I   105_B      A     106          1.094
LGA    Y   106_B      W     107          0.381
LGA    Y   107_B      Y     108          0.621
LGA    P   108_B      E     109          1.356
LGA    L   109_B      G     110          0.914
LGA    G   110_B      G     111          0.634
LGA    I   111_B      K     112          0.405
LGA    D   112_B      D     113          0.979
LGA    D   113_B      D     114          1.022
LGA    P   114_B      P     115          1.969
LGA    D   115_B      K     116          2.315
LGA    Y   116_B      L     117          1.870
LGA    T   117_B      A     118          0.947
LGA    A   118_B      L     119          0.831
LGA    L   119_B      L     120          1.633
LGA    C   120_B      R     121          1.677
LGA    F   121_B      L     122          1.393
LGA    T   122_B      D     123          1.293
LGA    A   123_B      A     124          1.074
LGA    E   124_B      D     125          0.923
LGA    W   125_B      H     126          0.809
LGA    G   126_B      A     127          0.692
LGA    N   127_B      Q     128          0.712
LGA    Y   128_B      I     129          0.595
LGA    Y   129_B      W     130          1.019
LGA    R   130_B      L     131          1.990
LGA    -       -      N     132           -
LGA    H   131_B      G     133          3.638
LGA    L   132_B      S     134           -
LGA    K   133_B      S     135           -
LGA    N   134_B      L     136           -
LGA    I   135_B      L     137           -
LGA    T   136_B      A     138           -
LGA    F   137_B      G     139           -
LGA    K   138_B      I     140           -
LGA    I   139_B      K     141           -
LGA    D   140_B      V     142           -
LGA    E   141_B      L     143           -
LGA    I   142_B      L     144           -
LGA    Y   143_B      G     145           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  142  145    5.0    125    2.34    15.20     59.492     5.129

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.351182 * X  +   0.556872 * Y  +   0.752705 * Z  +  -4.717036
  Y_new =  -0.678887 * X  +   0.402190 * Y  +  -0.614293 * Z  +  26.531231
  Z_new =  -0.644813 * X  +  -0.726730 * Y  +   0.236811 * Z  +   5.186100 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -1.255789    1.885804  [ DEG:   -71.9514    108.0486 ]
  Theta =   0.700779    2.440814  [ DEG:    40.1517    139.8483 ]
  Phi   =  -2.048181    1.093412  [ DEG:  -117.3521     62.6479 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2hq7_B                                        
REMARK     2: T0497.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2hq7_B.T0497.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  142  145   5.0  125   2.34   15.20  59.492
REMARK  ---------------------------------------------------------- 
MOLECULE 2hq7_B
HEADER    OXIDOREDUCTASE                          18-JUL-06   2HQ7              
TITLE     CRYSTAL STRUCTURE OF PROTEIN RELATED TO GENERAL STRESS                
TITLE    2 PROTEIN 26(GS26) OF B.SUBTILIS (PYRIDOXINEPHOSPHATE                  
TITLE    3 OXIDASE FAMILY) (NP_350077.1) FROM CLOSTRIDIUM                       
TITLE    4 ACETOBUTYLICUM AT 2.00 A RESOLUTION                                  
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PROTEIN, RELATED TO GENERAL STRESS PROTEIN                 
COMPND   3 26(GS26) OF B.SUBTILIS;                                              
COMPND   4 CHAIN: A, B;                                                         
COMPND   5 SYNONYM: PYRIDOXINEPHOSPHATE OXIDASE FAMILY;                         
COMPND   6 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: CLOSTRIDIUM ACETOBUTYLICUM;                     
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: NP_350077.1;                                                   
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    NP_350077.1, PROTEIN RELATED TO GENERAL STRESS PROTEIN                
KEYWDS   2 26(GS26) OF B.SUBTILIS (PYRIDOXINEPHOSPHATE OXIDASE FAMILY),         
KEYWDS   3 STRUCTURAL GENOMICS, JOINT CENTER FOR STRUCTURAL GENOMICS,           
KEYWDS   4 JCSG, PROTEIN STRUCTURE INITIATIVE, PSI                              
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   15-AUG-06 2HQ7    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF PROTEIN RELATED TO GENERAL              
JRNL        TITL 2 STRESS PROTEIN 26(GS26) OF B.SUBTILIS                        
JRNL        TITL 3 (PYRIDOXINEPHOSPHATE OXIDASE FAMILY) (NP_350077.1)           
JRNL        TITL 4 FROM CLOSTRIDIUM ACETOBUTYLICUM AT 2.00 A                    
JRNL        TITL 5 RESOLUTION                                                   
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 2.00 ANGSTROMS.                                          
DBREF  2HQ7 A    1   145  UNP    Q97DI6   Q97DI6_CLOAB     1    145             
DBREF  2HQ7 B    1   145  UNP    Q97DI6   Q97DI6_CLOAB     1    145             
SEQRES   1 A  146  GLY MSE ILE ASP GLU LYS PHE LEU ILE GLU SER ASN GLU          
SEQRES   2 A  146  LEU VAL GLU SER SER LYS ILE VAL MSE VAL GLY THR ASN          
SEQRES   3 A  146  GLY GLU ASN GLY TYR PRO ASN ILE LYS ALA MSE MSE ARG          
SEQRES   4 A  146  LEU LYS HIS ASP GLY LEU LYS LYS PHE TRP LEU SER THR          
SEQRES   5 A  146  ASN THR SER THR ARG MSE VAL GLU ARG LEU LYS LYS ASN          
SEQRES   6 A  146  ASN LYS ILE CYS LEU TYR PHE VAL ASP ASP ASN LYS PHE          
SEQRES   7 A  146  ALA GLY LEU MSE LEU VAL GLY THR ILE GLU ILE LEU HIS          
SEQRES   8 A  146  ASP ARG ALA SER LYS GLU MSE LEU TRP THR ASP GLY CYS          
SEQRES   9 A  146  GLU ILE TYR TYR PRO LEU GLY ILE ASP ASP PRO ASP TYR          
SEQRES  10 A  146  THR ALA LEU CYS PHE THR ALA GLU TRP GLY ASN TYR TYR          
SEQRES  11 A  146  ARG HIS LEU LYS ASN ILE THR PHE LYS ILE ASP GLU ILE          
SEQRES  12 A  146  TYR ASN TYR                                                  
SEQRES   1 B  146  GLY MSE ILE ASP GLU LYS PHE LEU ILE GLU SER ASN GLU          
SEQRES   2 B  146  LEU VAL GLU SER SER LYS ILE VAL MSE VAL GLY THR ASN          
SEQRES   3 B  146  GLY GLU ASN GLY TYR PRO ASN ILE LYS ALA MSE MSE ARG          
SEQRES   4 B  146  LEU LYS HIS ASP GLY LEU LYS LYS PHE TRP LEU SER THR          
SEQRES   5 B  146  ASN THR SER THR ARG MSE VAL GLU ARG LEU LYS LYS ASN          
SEQRES   6 B  146  ASN LYS ILE CYS LEU TYR PHE VAL ASP ASP ASN LYS PHE          
SEQRES   7 B  146  ALA GLY LEU MSE LEU VAL GLY THR ILE GLU ILE LEU HIS          
SEQRES   8 B  146  ASP ARG ALA SER LYS GLU MSE LEU TRP THR ASP GLY CYS          
SEQRES   9 B  146  GLU ILE TYR TYR PRO LEU GLY ILE ASP ASP PRO ASP TYR          
SEQRES  10 B  146  THR ALA LEU CYS PHE THR ALA GLU TRP GLY ASN TYR TYR          
SEQRES  11 B  146  ARG HIS LEU LYS ASN ILE THR PHE LYS ILE ASP GLU ILE          
SEQRES  12 B  146  TYR ASN TYR                                                  
HET    MSE  A  21       8                                                       
HET    MSE  A  36       8                                                       
HET    MSE  A  37       8                                                       
HET    MSE  A  57       8                                                       
HET    MSE  A  81       8                                                       
HET    MSE  A  97       8                                                       
HET    MSE  B  21       8                                                       
HET    MSE  B  36       8                                                       
HET    MSE  B  37       8                                                       
HET    MSE  B  57       8                                                       
HET    MSE  B  81       8                                                       
HET    MSE  B  97       8                                                       
HET     CL      1       1                                                       
HET     CL      2       1                                                       
HET    EDO      3       4                                                       
HET    EDO      4       4                                                       
HET    EDO      5       4                                                       
HET    EDO      6       4                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      CL CHLORIDE ION                                                     
HETNAM     EDO 1,2-ETHANEDIOL                                                   
HETSYN     EDO ETHYLENE GLYCOL                                                  
FORMUL   1  MSE    12(C5 H11 N O2 SE)                                           
FORMUL   3   CL    2(CL 1-)                                                     
FORMUL   5  EDO    4(C2 H6 O2)                                                  
FORMUL   9  HOH   *141(H2 O)                                                    
CRYST1   85.850   36.790   97.970  90.00 113.75  90.00 C 1 2 1       8          
ATOM   1141  N   ILE B   2       9.934  42.166  23.670  1.00 63.56           N  
ATOM   1142  CA  ILE B   2       8.520  42.638  23.498  1.00 64.04           C  
ATOM   1143  C   ILE B   2       8.293  43.463  22.182  1.00 64.30           C  
ATOM   1144  O   ILE B   2       7.143  43.663  21.791  1.00 64.74           O  
ATOM   1145  CB  ILE B   2       7.952  43.308  24.855  1.00 64.36           C  
ATOM   1146  CG1 ILE B   2       6.688  44.161  24.632  1.00 66.83           C  
ATOM   1147  CG2 ILE B   2       9.017  44.117  25.597  1.00 59.02           C  
ATOM   1148  CD1 ILE B   2       5.903  44.455  25.915  1.00 62.79           C  
ATOM   1149  N   ASP B   3       9.358  43.868  21.471  1.00 64.41           N  
ATOM   1150  CA  ASP B   3       9.208  44.507  20.129  1.00 64.66           C  
ATOM   1151  C   ASP B   3       8.449  43.599  19.149  1.00 64.47           C  
ATOM   1152  O   ASP B   3       8.620  42.376  19.170  1.00 63.88           O  
ATOM   1153  CB  ASP B   3      10.566  44.886  19.504  1.00 64.84           C  
ATOM   1154  CG  ASP B   3      10.426  45.629  18.149  1.00 66.57           C  
ATOM   1155  OD1 ASP B   3       9.930  45.036  17.164  1.00 68.71           O  
ATOM   1156  OD2 ASP B   3      10.833  46.810  18.059  1.00 72.12           O  
ATOM   1157  N   GLU B   4       7.643  44.207  18.275  1.00 63.75           N  
ATOM   1158  CA  GLU B   4       6.738  43.459  17.388  1.00 63.76           C  
ATOM   1159  C   GLU B   4       7.474  42.608  16.341  1.00 61.87           C  
ATOM   1160  O   GLU B   4       6.912  41.625  15.844  1.00 59.77           O  
ATOM   1161  CB  GLU B   4       5.732  44.416  16.716  1.00 64.65           C  
ATOM   1162  CG  GLU B   4       4.648  43.754  15.839  1.00 72.23           C  
ATOM   1163  CD  GLU B   4       3.917  42.577  16.511  1.00 80.10           C  
ATOM   1164  OE1 GLU B   4       3.847  42.523  17.764  1.00 84.62           O  
ATOM   1165  OE2 GLU B   4       3.407  41.699  15.774  1.00 84.14           O  
ATOM   1166  N   LYS B   5       8.725  42.970  16.036  1.00 60.20           N  
ATOM   1167  CA  LYS B   5       9.548  42.238  15.069  1.00 58.76           C  
ATOM   1168  C   LYS B   5       9.590  40.734  15.354  1.00 58.27           C  
ATOM   1169  O   LYS B   5       9.386  39.920  14.446  1.00 55.79           O  
ATOM   1170  CB  LYS B   5      10.976  42.835  14.980  1.00 58.91           C  
ATOM   1171  CG  LYS B   5      11.927  42.588  16.163  1.00 57.69           C  
ATOM   1172  CD  LYS B   5      13.345  43.048  15.838  1.00 59.01           C  
ATOM   1173  N   PHE B   6       9.797  40.370  16.623  1.00 59.47           N  
ATOM   1174  CA  PHE B   6       9.990  38.962  16.993  1.00 58.66           C  
ATOM   1175  C   PHE B   6       8.798  38.147  16.632  1.00 56.86           C  
ATOM   1176  O   PHE B   6       8.933  37.194  15.882  1.00 54.09           O  
ATOM   1177  CB  PHE B   6      10.329  38.786  18.476  1.00 60.70           C  
ATOM   1178  CG  PHE B   6      11.638  39.409  18.852  1.00 65.20           C  
ATOM   1179  CD1 PHE B   6      12.790  39.112  18.125  1.00 65.99           C  
ATOM   1180  CD2 PHE B   6      11.713  40.336  19.883  1.00 67.43           C  
ATOM   1181  CE1 PHE B   6      13.989  39.700  18.432  1.00 66.27           C  
ATOM   1182  CE2 PHE B   6      12.919  40.941  20.197  1.00 69.49           C  
ATOM   1183  CZ  PHE B   6      14.062  40.623  19.473  1.00 68.96           C  
ATOM   1184  N   LEU B   7       7.632  38.524  17.136  1.00 57.55           N  
ATOM   1185  CA  LEU B   7       6.416  37.769  16.818  1.00 59.69           C  
ATOM   1186  C   LEU B   7       6.236  37.557  15.294  1.00 59.08           C  
ATOM   1187  O   LEU B   7       5.872  36.452  14.850  1.00 58.51           O  
ATOM   1188  CB  LEU B   7       5.170  38.441  17.422  1.00 59.98           C  
ATOM   1189  CG  LEU B   7       3.836  37.736  17.150  1.00 61.41           C  
ATOM   1190  CD1 LEU B   7       3.880  36.266  17.564  1.00 60.66           C  
ATOM   1191  CD2 LEU B   7       2.707  38.485  17.854  1.00 61.19           C  
ATOM   1192  N   ILE B   8       6.497  38.614  14.519  1.00 57.88           N  
ATOM   1193  CA  ILE B   8       6.444  38.553  13.051  1.00 57.08           C  
ATOM   1194  C   ILE B   8       7.611  37.721  12.489  1.00 55.72           C  
ATOM   1195  O   ILE B   8       7.394  36.907  11.596  1.00 58.22           O  
ATOM   1196  CB  ILE B   8       6.425  39.984  12.389  1.00 58.62           C  
ATOM   1197  CG1 ILE B   8       5.140  40.746  12.761  1.00 59.82           C  
ATOM   1198  CG2 ILE B   8       6.547  39.892  10.865  1.00 54.57           C  
ATOM   1199  CD1 ILE B   8       5.130  42.211  12.315  1.00 55.90           C  
ATOM   1200  N   GLU B   9       8.827  37.909  13.019  1.00 53.04           N  
ATOM   1201  CA  GLU B   9      10.000  37.133  12.577  1.00 51.71           C  
ATOM   1202  C   GLU B   9       9.866  35.643  12.949  1.00 51.18           C  
ATOM   1203  O   GLU B   9      10.058  34.771  12.104  1.00 51.57           O  
ATOM   1204  CB  GLU B   9      11.292  37.706  13.160  1.00 51.59           C  
ATOM   1205  CG  GLU B   9      12.502  37.616  12.231  1.00 52.47           C  
ATOM   1206  N   SER B  10       9.531  35.369  14.210  1.00 48.81           N  
ATOM   1207  CA  SER B  10       9.199  34.021  14.654  1.00 47.17           C  
ATOM   1208  C   SER B  10       8.052  33.447  13.856  1.00 47.89           C  
ATOM   1209  O   SER B  10       8.010  32.235  13.632  1.00 48.79           O  
ATOM   1210  CB  SER B  10       8.783  34.011  16.122  1.00 44.70           C  
ATOM   1211  OG  SER B  10       9.844  34.383  16.972  1.00 41.57           O  
ATOM   1212  N   ASN B  11       7.092  34.278  13.455  1.00 47.71           N  
ATOM   1213  CA  ASN B  11       5.976  33.732  12.672  1.00 48.40           C  
ATOM   1214  C   ASN B  11       6.408  33.308  11.291  1.00 47.09           C  
ATOM   1215  O   ASN B  11       6.006  32.237  10.829  1.00 48.50           O  
ATOM   1216  CB  ASN B  11       4.774  34.672  12.588  1.00 50.64           C  
ATOM   1217  CG  ASN B  11       3.663  34.268  13.544  1.00 55.77           C  
ATOM   1218  OD1 ASN B  11       2.684  33.629  13.134  1.00 62.36           O  
ATOM   1219  ND2 ASN B  11       3.829  34.597  14.834  1.00 59.57           N  
ATOM   1220  N   GLU B  12       7.226  34.129  10.638  1.00 45.42           N  
ATOM   1221  CA  GLU B  12       7.801  33.749   9.356  1.00 45.53           C  
ATOM   1222  C   GLU B  12       8.532  32.434   9.534  1.00 44.48           C  
ATOM   1223  O   GLU B  12       8.383  31.519   8.723  1.00 47.26           O  
ATOM   1224  CB  GLU B  12       8.769  34.815   8.821  1.00 43.84           C  
ATOM   1225  N   LEU B  13       9.310  32.337  10.604  1.00 42.70           N  
ATOM   1226  CA  LEU B  13      10.058  31.114  10.898  1.00 44.65           C  
ATOM   1227  C   LEU B  13       9.156  29.907  10.942  1.00 45.91           C  
ATOM   1228  O   LEU B  13       9.436  28.891  10.310  1.00 48.00           O  
ATOM   1229  CB  LEU B  13      10.787  31.225  12.232  1.00 42.93           C  
ATOM   1230  CG  LEU B  13      11.849  30.163  12.494  1.00 45.64           C  
ATOM   1231  CD1 LEU B  13      12.579  29.714  11.204  1.00 42.10           C  
ATOM   1232  CD2 LEU B  13      12.836  30.723  13.530  1.00 48.81           C  
ATOM   1233  N   VAL B  14       8.071  30.023  11.697  1.00 46.97           N  
ATOM   1234  CA  VAL B  14       7.064  28.968  11.769  1.00 46.97           C  
ATOM   1235  C   VAL B  14       6.467  28.648  10.389  1.00 50.41           C  
ATOM   1236  O   VAL B  14       6.435  27.474   9.967  1.00 51.34           O  
ATOM   1237  CB  VAL B  14       5.948  29.353  12.709  1.00 45.63           C  
ATOM   1238  CG1 VAL B  14       4.809  28.376  12.564  1.00 44.33           C  
ATOM   1239  CG2 VAL B  14       6.493  29.415  14.141  1.00 35.99           C  
ATOM   1240  N   GLU B  15       6.059  29.688   9.663  1.00 51.25           N  
ATOM   1241  CA  GLU B  15       5.403  29.501   8.372  1.00 50.72           C  
ATOM   1242  C   GLU B  15       6.311  28.915   7.310  1.00 51.12           C  
ATOM   1243  O   GLU B  15       5.837  28.316   6.354  1.00 49.32           O  
ATOM   1244  CB  GLU B  15       4.817  30.812   7.878  1.00 52.46           C  
ATOM   1245  CG  GLU B  15       3.510  31.214   8.553  1.00 60.03           C  
ATOM   1246  CD  GLU B  15       2.334  30.287   8.202  1.00 71.16           C  
ATOM   1247  OE1 GLU B  15       2.512  29.361   7.375  1.00 77.33           O  
ATOM   1248  OE2 GLU B  15       1.228  30.485   8.761  1.00 71.19           O  
ATOM   1249  N   SER B  16       7.614  29.063   7.480  1.00 53.24           N  
ATOM   1250  CA  SER B  16       8.538  28.728   6.414  1.00 55.39           C  
ATOM   1251  C   SER B  16       8.718  27.229   6.180  1.00 56.49           C  
ATOM   1252  O   SER B  16       9.285  26.836   5.147  1.00 58.71           O  
ATOM   1253  CB  SER B  16       9.905  29.391   6.645  1.00 56.35           C  
ATOM   1254  OG  SER B  16      10.610  28.824   7.740  1.00 60.38           O  
ATOM   1255  N   SER B  17       8.275  26.401   7.128  1.00 56.39           N  
ATOM   1256  CA  SER B  17       8.293  24.936   6.947  1.00 56.02           C  
ATOM   1257  C   SER B  17       7.072  24.270   7.590  1.00 54.82           C  
ATOM   1258  O   SER B  17       6.518  24.748   8.585  1.00 54.54           O  
ATOM   1259  CB  SER B  17       9.592  24.307   7.490  1.00 55.96           C  
ATOM   1260  OG  SER B  17       9.655  22.911   7.206  1.00 56.57           O  
ATOM   1261  N   LYS B  18       6.658  23.163   6.990  1.00 53.08           N  
ATOM   1262  CA  LYS B  18       5.548  22.388   7.509  1.00 53.84           C  
ATOM   1263  C   LYS B  18       6.023  21.398   8.577  1.00 48.63           C  
ATOM   1264  O   LYS B  18       5.197  20.732   9.205  1.00 50.19           O  
ATOM   1265  CB  LYS B  18       4.841  21.662   6.354  1.00 56.30           C  
ATOM   1266  CG  LYS B  18       4.323  22.606   5.250  1.00 62.33           C  
ATOM   1267  CD  LYS B  18       3.016  23.317   5.644  1.00 66.82           C  
ATOM   1268  CE  LYS B  18       2.672  24.498   4.697  1.00 70.08           C  
ATOM   1269  NZ  LYS B  18       3.376  25.801   5.023  1.00 65.82           N  
ATOM   1270  N   ILE B  19       7.344  21.311   8.769  1.00 45.90           N  
ATOM   1271  CA  ILE B  19       7.978  20.333   9.671  1.00 43.63           C  
ATOM   1272  C   ILE B  19       8.404  20.994  10.957  1.00 39.02           C  
ATOM   1273  O   ILE B  19       9.009  22.047  10.940  1.00 38.14           O  
ATOM   1274  CB  ILE B  19       9.245  19.690   9.041  1.00 45.43           C  
ATOM   1275  CG1 ILE B  19       8.965  19.203   7.618  1.00 48.29           C  
ATOM   1276  CG2 ILE B  19       9.729  18.508   9.877  1.00 40.58           C  
ATOM   1277  CD1 ILE B  19       7.783  18.238   7.534  1.00 51.42           C  
ATOM   1278  N   VAL B  20       8.085  20.379  12.080  1.00 35.12           N  
ATOM   1279  CA  VAL B  20       8.507  20.916  13.351  1.00 34.81           C  
ATOM   1280  C   VAL B  20       9.190  19.811  14.121  1.00 30.58           C  
ATOM   1281  O   VAL B  20       8.749  18.653  14.098  1.00 34.66           O  
ATOM   1282  CB  VAL B  20       7.316  21.499  14.183  1.00 36.80           C  
ATOM   1283  CG1 VAL B  20       6.389  20.464  14.557  1.00 38.30           C  
ATOM   1284  CG2 VAL B  20       7.818  22.149  15.434  1.00 35.18           C  
HETATM 1285  N   MSE B  21      10.231  20.189  14.848  1.00 29.18           N  
HETATM 1286  CA  MSE B  21      10.987  19.252  15.669  1.00 28.34           C  
HETATM 1287  C   MSE B  21      10.327  19.229  17.026  1.00 22.81           C  
HETATM 1288  O   MSE B  21      10.129  20.293  17.635  1.00 25.85           O  
HETATM 1289  CB  MSE B  21      12.376  19.755  15.899  1.00 24.85           C  
HETATM 1290  CG  MSE B  21      13.114  20.335  14.743  1.00 47.97           C  
HETATM 1291 SE   MSE B  21      14.162  18.924  14.162  0.75 78.43          SE  
HETATM 1292  CE  MSE B  21      12.808  18.269  12.915  1.00 25.70           C  
ATOM   1293  N   VAL B  22      10.013  18.058  17.537  1.00 27.41           N  
ATOM   1294  CA  VAL B  22       9.255  17.979  18.776  1.00 24.01           C  
ATOM   1295  C   VAL B  22      10.077  17.231  19.808  1.00 26.94           C  
ATOM   1296  O   VAL B  22      10.394  16.042  19.618  1.00 27.34           O  
ATOM   1297  CB  VAL B  22       7.957  17.222  18.587  1.00 26.22           C  
ATOM   1298  CG1 VAL B  22       7.245  17.096  19.917  1.00 18.52           C  
ATOM   1299  CG2 VAL B  22       7.111  17.875  17.546  1.00 28.78           C  
ATOM   1300  N   GLY B  23      10.390  17.906  20.909  1.00 25.74           N  
ATOM   1301  CA  GLY B  23      11.101  17.290  22.000  1.00 23.75           C  
ATOM   1302  C   GLY B  23      10.162  16.725  23.060  1.00 24.92           C  
ATOM   1303  O   GLY B  23       9.248  17.390  23.481  1.00 26.83           O  
ATOM   1304  N   THR B  24      10.407  15.490  23.471  1.00 23.54           N  
ATOM   1305  CA  THR B  24       9.614  14.818  24.461  1.00 26.42           C  
ATOM   1306  C   THR B  24      10.530  14.158  25.492  1.00 26.55           C  
ATOM   1307  O   THR B  24      11.721  14.017  25.280  1.00 29.15           O  
ATOM   1308  CB  THR B  24       8.725  13.714  23.837  1.00 26.73           C  
ATOM   1309  OG1 THR B  24       9.536  12.825  23.059  1.00 26.85           O  
ATOM   1310  CG2 THR B  24       7.641  14.277  22.996  1.00 28.59           C  
ATOM   1311  N   ASN B  25       9.934  13.757  26.599  1.00 28.87           N  
ATOM   1312  CA  ASN B  25      10.640  13.044  27.655  1.00 30.75           C  
ATOM   1313  C   ASN B  25      10.596  11.561  27.372  1.00 28.53           C  
ATOM   1314  O   ASN B  25       9.552  10.956  27.513  1.00 27.11           O  
ATOM   1315  CB  ASN B  25      10.011  13.329  28.987  1.00 29.64           C  
ATOM   1316  CG  ASN B  25      10.214  14.759  29.428  1.00 32.84           C  
ATOM   1317  OD1 ASN B  25       9.272  15.445  29.794  1.00 34.07           O  
ATOM   1318  ND2 ASN B  25      11.437  15.210  29.385  1.00 25.42           N  
ATOM   1319  N   GLY B  26      11.716  11.006  26.918  1.00 28.05           N  
ATOM   1320  CA  GLY B  26      11.786   9.609  26.524  1.00 29.72           C  
ATOM   1321  C   GLY B  26      12.084   8.667  27.675  1.00 30.57           C  
ATOM   1322  O   GLY B  26      12.154   9.076  28.841  1.00 30.73           O  
ATOM   1323  N   GLU B  27      12.236   7.390  27.343  1.00 33.47           N  
ATOM   1324  CA  GLU B  27      12.520   6.365  28.351  1.00 36.11           C  
ATOM   1325  C   GLU B  27      13.857   6.632  29.006  1.00 36.62           C  
ATOM   1326  O   GLU B  27      14.788   7.172  28.370  1.00 36.68           O  
ATOM   1327  CB  GLU B  27      12.534   4.958  27.724  1.00 38.13           C  
ATOM   1328  CG  GLU B  27      11.180   4.449  27.239  1.00 38.54           C  
ATOM   1329  N   ASN B  28      13.937   6.253  30.283  1.00 37.90           N  
ATOM   1330  CA  ASN B  28      15.185   6.269  31.046  1.00 37.72           C  
ATOM   1331  C   ASN B  28      15.768   7.662  31.259  1.00 36.70           C  
ATOM   1332  O   ASN B  28      16.963   7.808  31.509  1.00 37.60           O  
ATOM   1333  CB  ASN B  28      16.208   5.333  30.387  1.00 39.86           C  
ATOM   1334  CG  ASN B  28      15.738   3.876  30.370  1.00 43.73           C  
ATOM   1335  OD1 ASN B  28      15.123   3.404  31.325  1.00 48.02           O  
ATOM   1336  ND2 ASN B  28      16.028   3.164  29.284  1.00 44.57           N  
ATOM   1337  N   GLY B  29      14.917   8.684  31.181  1.00 33.58           N  
ATOM   1338  CA  GLY B  29      15.320  10.025  31.537  1.00 30.32           C  
ATOM   1339  C   GLY B  29      16.066  10.783  30.449  1.00 27.64           C  
ATOM   1340  O   GLY B  29      16.601  11.854  30.723  1.00 26.15           O  
ATOM   1341  N   TYR B  30      16.085  10.240  29.233  1.00 26.52           N  
ATOM   1342  CA  TYR B  30      16.678  10.900  28.064  1.00 29.60           C  
ATOM   1343  C   TYR B  30      15.636  11.672  27.255  1.00 28.89           C  
ATOM   1344  O   TYR B  30      14.525  11.174  27.038  1.00 29.38           O  
ATOM   1345  CB  TYR B  30      17.298   9.861  27.148  1.00 29.95           C  
ATOM   1346  CG  TYR B  30      18.459   9.110  27.737  1.00 30.91           C  
ATOM   1347  CD1 TYR B  30      18.268   7.934  28.469  1.00 37.59           C  
ATOM   1348  CD2 TYR B  30      19.752   9.576  27.567  1.00 30.87           C  
ATOM   1349  CE1 TYR B  30      19.359   7.242  29.011  1.00 33.96           C  
ATOM   1350  CE2 TYR B  30      20.829   8.899  28.082  1.00 36.07           C  
ATOM   1351  CZ  TYR B  30      20.639   7.737  28.809  1.00 37.47           C  
ATOM   1352  OH  TYR B  30      21.762   7.108  29.324  1.00 38.44           O  
ATOM   1353  N   PRO B  31      15.983  12.894  26.785  1.00 29.09           N  
ATOM   1354  CA  PRO B  31      15.053  13.542  25.893  1.00 27.92           C  
ATOM   1355  C   PRO B  31      15.093  12.873  24.527  1.00 26.01           C  
ATOM   1356  O   PRO B  31      16.033  12.164  24.187  1.00 26.99           O  
ATOM   1357  CB  PRO B  31      15.559  14.976  25.817  1.00 27.50           C  
ATOM   1358  CG  PRO B  31      16.680  15.062  26.726  1.00 28.09           C  
ATOM   1359  CD  PRO B  31      17.157  13.728  27.037  1.00 26.49           C  
ATOM   1360  N   ASN B  32      14.023  13.025  23.791  1.00 26.15           N  
ATOM   1361  CA  ASN B  32      13.940  12.448  22.481  1.00 27.46           C  
ATOM   1362  C   ASN B  32      13.425  13.566  21.608  1.00 28.28           C  
ATOM   1363  O   ASN B  32      12.707  14.420  22.072  1.00 27.61           O  
ATOM   1364  CB  ASN B  32      12.959  11.285  22.424  1.00 27.08           C  
ATOM   1365  CG  ASN B  32      13.443  10.023  23.095  1.00 27.88           C  
ATOM   1366  OD1 ASN B  32      12.700   9.036  23.065  1.00 29.12           O  
ATOM   1367  ND2 ASN B  32      14.649  10.016  23.697  1.00 21.67           N  
ATOM   1368  N   ILE B  33      13.860  13.578  20.364  1.00 26.05           N  
ATOM   1369  CA  ILE B  33      13.388  14.527  19.384  1.00 26.90           C  
ATOM   1370  C   ILE B  33      12.884  13.750  18.188  1.00 25.65           C  
ATOM   1371  O   ILE B  33      13.576  12.839  17.708  1.00 22.71           O  
ATOM   1372  CB  ILE B  33      14.516  15.474  18.900  1.00 25.66           C  
ATOM   1373  CG1 ILE B  33      15.064  16.303  20.061  1.00 29.16           C  
ATOM   1374  CG2 ILE B  33      14.005  16.391  17.796  1.00 24.16           C  
ATOM   1375  CD1 ILE B  33      16.349  17.161  19.716  1.00 26.74           C  
ATOM   1376  N   LYS B  34      11.695  14.131  17.714  1.00 27.95           N  
ATOM   1377  CA  LYS B  34      11.109  13.636  16.468  1.00 29.31           C  
ATOM   1378  C   LYS B  34      10.587  14.773  15.610  1.00 27.49           C  
ATOM   1379  O   LYS B  34      10.091  15.765  16.144  1.00 26.95           O  
ATOM   1380  CB  LYS B  34       9.929  12.724  16.791  1.00 29.89           C  
ATOM   1381  CG  LYS B  34       9.522  11.850  15.656  1.00 38.49           C  
ATOM   1382  CD  LYS B  34       8.503  10.843  16.137  1.00 37.55           C  
ATOM   1383  CE  LYS B  34       8.018   9.942  15.023  1.00 46.22           C  
ATOM   1384  NZ  LYS B  34       7.183   8.839  15.600  1.00 51.73           N  
ATOM   1385  N   ALA B  35      10.692  14.618  14.287  1.00 28.65           N  
ATOM   1386  CA  ALA B  35      10.035  15.515  13.328  1.00 26.47           C  
ATOM   1387  C   ALA B  35       8.526  15.214  13.240  1.00 27.97           C  
ATOM   1388  O   ALA B  35       8.099  14.061  13.267  1.00 26.72           O  
ATOM   1389  CB  ALA B  35      10.692  15.425  11.945  1.00 27.41           C  
HETATM 1390  N   MSE B  36       7.720  16.268  13.255  1.00 26.93           N  
HETATM 1391  CA  MSE B  36       6.278  16.137  13.096  1.00 30.34           C  
HETATM 1392  C   MSE B  36       5.795  17.148  12.103  1.00 31.77           C  
HETATM 1393  O   MSE B  36       6.533  18.041  11.720  1.00 28.24           O  
HETATM 1394  CB  MSE B  36       5.570  16.327  14.427  1.00 29.54           C  
HETATM 1395  CG  MSE B  36       5.731  15.150  15.330  1.00 34.37           C  
HETATM 1396 SE   MSE B  36       4.590  15.253  16.897  0.75 35.75          SE  
HETATM 1397  CE  MSE B  36       2.845  15.595  16.106  1.00 71.06           C  
HETATM 1398  N   MSE B  37       4.567  16.980  11.642  1.00 37.15           N  
HETATM 1399  CA  MSE B  37       4.024  17.876  10.627  1.00 44.89           C  
HETATM 1400  C   MSE B  37       3.072  18.856  11.302  1.00 35.87           C  
HETATM 1401  O   MSE B  37       2.275  18.477  12.172  1.00 32.17           O  
HETATM 1402  CB  MSE B  37       3.344  17.076   9.503  1.00 45.16           C  
HETATM 1403  CG  MSE B  37       2.182  17.783   8.804  1.00 58.16           C  
HETATM 1404 SE   MSE B  37       1.680  16.903   7.109  0.75 75.26          SE  
HETATM 1405  CE  MSE B  37       3.261  17.529   6.091  1.00 60.57           C  
ATOM   1406  N   ARG B  38       3.228  20.119  10.945  1.00 32.02           N  
ATOM   1407  CA  ARG B  38       2.375  21.177  11.393  1.00 33.72           C  
ATOM   1408  C   ARG B  38       1.142  21.183  10.509  1.00 34.08           C  
ATOM   1409  O   ARG B  38       1.230  21.489   9.326  1.00 32.98           O  
ATOM   1410  CB  ARG B  38       3.060  22.537  11.275  1.00 36.84           C  
ATOM   1411  CG  ARG B  38       2.146  23.680  11.744  1.00 42.43           C  
ATOM   1412  CD  ARG B  38       2.774  25.040  11.614  1.00 51.13           C  
ATOM   1413  NE  ARG B  38       3.203  25.365  10.261  1.00 53.15           N  
ATOM   1414  CZ  ARG B  38       2.398  25.681   9.258  1.00 51.35           C  
ATOM   1415  NH1 ARG B  38       1.080  25.677   9.392  1.00 64.23           N  
ATOM   1416  NH2 ARG B  38       2.926  25.962   8.093  1.00 43.95           N  
ATOM   1417  N   LEU B  39      -0.000  20.838  11.100  1.00 34.49           N  
ATOM   1418  CA  LEU B  39      -1.283  20.917  10.428  1.00 33.09           C  
ATOM   1419  C   LEU B  39      -1.800  22.362  10.476  1.00 33.96           C  
ATOM   1420  O   LEU B  39      -2.337  22.867   9.506  1.00 33.46           O  
ATOM   1421  CB  LEU B  39      -2.293  19.988  11.106  1.00 32.03           C  
ATOM   1422  CG  LEU B  39      -1.979  18.508  11.033  1.00 26.13           C  
ATOM   1423  CD1 LEU B  39      -3.012  17.697  11.866  1.00 36.41           C  
ATOM   1424  CD2 LEU B  39      -1.876  17.952   9.639  1.00 36.52           C  
ATOM   1425  N   LYS B  40      -1.622  23.025  11.603  1.00 31.69           N  
ATOM   1426  CA  LYS B  40      -2.188  24.357  11.783  1.00 32.73           C  
ATOM   1427  C   LYS B  40      -1.493  25.043  12.930  1.00 31.01           C  
ATOM   1428  O   LYS B  40      -1.005  24.380  13.853  1.00 28.60           O  
ATOM   1429  CB  LYS B  40      -3.703  24.253  12.107  1.00 31.14           C  
ATOM   1430  CG  LYS B  40      -4.386  25.604  12.381  1.00 34.16           C  
ATOM   1431  CD  LYS B  40      -5.873  25.498  12.609  1.00 35.33           C  
ATOM   1432  CE  LYS B  40      -6.525  26.897  12.578  1.00 41.00           C  
ATOM   1433  NZ  LYS B  40      -6.685  27.366  11.188  1.00 46.77           N  
ATOM   1434  N   HIS B  41      -1.443  26.364  12.890  1.00 29.00           N  
ATOM   1435  CA  HIS B  41      -1.098  27.076  14.094  1.00 29.98           C  
ATOM   1436  C   HIS B  41      -1.866  28.362  14.273  1.00 32.84           C  
ATOM   1437  O   HIS B  41      -2.414  28.907  13.309  1.00 31.64           O  
ATOM   1438  CB  HIS B  41       0.399  27.346  14.144  1.00 31.33           C  
ATOM   1439  CG  HIS B  41       0.870  28.327  13.135  1.00 26.19           C  
ATOM   1440  ND1 HIS B  41       1.280  29.597  13.473  1.00 31.69           N  
ATOM   1441  CD2 HIS B  41       1.008  28.225  11.792  1.00 32.81           C  
ATOM   1442  CE1 HIS B  41       1.659  30.235  12.375  1.00 33.58           C  
ATOM   1443  NE2 HIS B  41       1.490  29.428  11.341  1.00 26.52           N  
ATOM   1444  N   ASP B  42      -1.918  28.812  15.531  1.00 33.61           N  
ATOM   1445  CA  ASP B  42      -2.444  30.108  15.880  1.00 35.31           C  
ATOM   1446  C   ASP B  42      -1.328  30.968  16.465  1.00 35.35           C  
ATOM   1447  O   ASP B  42      -1.046  30.918  17.663  1.00 34.33           O  
ATOM   1448  CB  ASP B  42      -3.585  29.960  16.885  1.00 37.56           C  
ATOM   1449  CG  ASP B  42      -4.227  31.304  17.249  1.00 44.51           C  
ATOM   1450  OD1 ASP B  42      -3.978  32.310  16.549  1.00 44.35           O  
ATOM   1451  OD2 ASP B  42      -4.986  31.348  18.237  1.00 47.82           O  
ATOM   1452  N   GLY B  43      -0.713  31.798  15.629  1.00 33.77           N  
ATOM   1453  CA  GLY B  43       0.447  32.539  16.070  1.00 35.26           C  
ATOM   1454  C   GLY B  43       1.447  31.632  16.759  1.00 33.43           C  
ATOM   1455  O   GLY B  43       1.750  30.556  16.240  1.00 35.74           O  
ATOM   1456  N   LEU B  44       1.951  32.060  17.917  1.00 31.71           N  
ATOM   1457  CA  LEU B  44       2.860  31.221  18.730  1.00 33.26           C  
ATOM   1458  C   LEU B  44       2.157  30.570  19.905  1.00 32.01           C  
ATOM   1459  O   LEU B  44       2.789  29.928  20.750  1.00 29.51           O  
ATOM   1460  CB  LEU B  44       4.010  32.041  19.289  1.00 35.15           C  
ATOM   1461  CG  LEU B  44       4.836  32.873  18.326  1.00 35.83           C  
ATOM   1462  CD1 LEU B  44       5.978  33.516  19.081  1.00 43.52           C  
ATOM   1463  CD2 LEU B  44       5.330  31.992  17.226  1.00 28.71           C  
ATOM   1464  N   LYS B  45       0.846  30.697  19.943  1.00 32.40           N  
ATOM   1465  CA  LYS B  45       0.060  30.202  21.075  1.00 33.64           C  
ATOM   1466  C   LYS B  45      -0.276  28.731  20.990  1.00 33.16           C  
ATOM   1467  O   LYS B  45      -0.366  28.040  22.013  1.00 29.62           O  
ATOM   1468  CB  LYS B  45      -1.283  30.965  21.118  1.00 32.73           C  
ATOM   1469  CG  LYS B  45      -1.155  32.475  21.154  1.00 42.37           C  
ATOM   1470  CD  LYS B  45      -2.487  33.173  21.461  1.00 42.02           C  
ATOM   1471  CE  LYS B  45      -3.168  33.742  20.213  1.00 55.13           C  
ATOM   1472  NZ  LYS B  45      -4.621  34.131  20.473  1.00 51.81           N  
ATOM   1473  N   LYS B  46      -0.569  28.262  19.784  1.00 32.42           N  
ATOM   1474  CA  LYS B  46      -1.176  26.940  19.629  1.00 32.88           C  
ATOM   1475  C   LYS B  46      -0.773  26.316  18.303  1.00 29.31           C  
ATOM   1476  O   LYS B  46      -0.790  26.963  17.254  1.00 28.87           O  
ATOM   1477  CB  LYS B  46      -2.724  26.994  19.758  1.00 33.30           C  
ATOM   1478  CG  LYS B  46      -3.290  26.281  20.987  1.00 39.74           C  
ATOM   1479  CD  LYS B  46      -4.830  26.179  20.981  1.00 36.34           C  
ATOM   1480  CE  LYS B  46      -5.417  25.604  22.289  1.00 47.93           C  
ATOM   1481  NZ  LYS B  46      -6.864  25.137  22.169  1.00 47.41           N  
ATOM   1482  N   PHE B  47      -0.391  25.046  18.370  1.00 29.07           N  
ATOM   1483  CA  PHE B  47       0.001  24.284  17.190  1.00 28.41           C  
ATOM   1484  C   PHE B  47      -0.772  22.980  17.147  1.00 27.87           C  
ATOM   1485  O   PHE B  47      -0.901  22.283  18.148  1.00 26.75           O  
ATOM   1486  CB  PHE B  47       1.482  23.993  17.236  1.00 29.65           C  
ATOM   1487  CG  PHE B  47       2.314  25.193  17.005  1.00 26.11           C  
ATOM   1488  CD1 PHE B  47       2.435  26.162  18.002  1.00 30.63           C  
ATOM   1489  CD2 PHE B  47       2.910  25.407  15.791  1.00 30.58           C  
ATOM   1490  CE1 PHE B  47       3.165  27.291  17.806  1.00 33.34           C  
ATOM   1491  CE2 PHE B  47       3.667  26.547  15.592  1.00 32.26           C  
ATOM   1492  CZ  PHE B  47       3.776  27.489  16.597  1.00 30.00           C  
ATOM   1493  N   TRP B  48      -1.224  22.607  15.976  1.00 23.87           N  
ATOM   1494  CA  TRP B  48      -1.866  21.312  15.789  1.00 27.69           C  
ATOM   1495  C   TRP B  48      -0.935  20.547  14.879  1.00 28.42           C  
ATOM   1496  O   TRP B  48      -0.540  21.051  13.826  1.00 25.95           O  
ATOM   1497  CB  TRP B  48      -3.241  21.493  15.133  1.00 29.16           C  
ATOM   1498  CG  TRP B  48      -4.267  22.068  16.050  1.00 24.13           C  
ATOM   1499  CD1 TRP B  48      -5.141  21.379  16.816  1.00 26.69           C  
ATOM   1500  CD2 TRP B  48      -4.523  23.455  16.298  1.00 23.98           C  
ATOM   1501  NE1 TRP B  48      -5.906  22.243  17.547  1.00 28.39           N  
ATOM   1502  CE2 TRP B  48      -5.583  23.526  17.193  1.00 23.77           C  
ATOM   1503  CE3 TRP B  48      -4.001  24.640  15.789  1.00 23.65           C  
ATOM   1504  CZ2 TRP B  48      -6.077  24.738  17.667  1.00 27.10           C  
ATOM   1505  CZ3 TRP B  48      -4.486  25.831  16.237  1.00 29.81           C  
ATOM   1506  CH2 TRP B  48      -5.538  25.879  17.165  1.00 26.46           C  
ATOM   1507  N   LEU B  49      -0.555  19.356  15.311  1.00 29.23           N  
ATOM   1508  CA  LEU B  49       0.496  18.624  14.625  1.00 28.44           C  
ATOM   1509  C   LEU B  49       0.036  17.241  14.292  1.00 30.14           C  
ATOM   1510  O   LEU B  49      -0.850  16.688  14.963  1.00 28.62           O  
ATOM   1511  CB  LEU B  49       1.729  18.523  15.518  1.00 27.68           C  
ATOM   1512  CG  LEU B  49       2.341  19.783  16.103  1.00 23.27           C  
ATOM   1513  CD1 LEU B  49       3.307  19.397  17.182  1.00 29.56           C  
ATOM   1514  CD2 LEU B  49       3.043  20.643  14.975  1.00 26.75           C  
ATOM   1515  N   SER B  50       0.651  16.683  13.266  1.00 27.65           N  
ATOM   1516  CA  SER B  50       0.431  15.300  12.870  1.00 34.33           C  
ATOM   1517  C   SER B  50       1.668  14.429  13.020  1.00 31.55           C  
ATOM   1518  O   SER B  50       2.758  14.854  12.725  1.00 32.14           O  
ATOM   1519  CB  SER B  50       0.030  15.219  11.405  1.00 31.80           C  
ATOM   1520  OG  SER B  50      -0.475  13.939  11.138  1.00 49.36           O  
ATOM   1521  N   THR B  51       1.451  13.197  13.454  1.00 34.37           N  
ATOM   1522  CA  THR B  51       2.487  12.187  13.465  1.00 34.68           C  
ATOM   1523  C   THR B  51       1.855  10.810  13.328  1.00 37.05           C  
ATOM   1524  O   THR B  51       0.621  10.645  13.440  1.00 32.28           O  
ATOM   1525  CB  THR B  51       3.357  12.291  14.737  1.00 37.95           C  
ATOM   1526  OG1 THR B  51       4.602  11.604  14.538  1.00 36.77           O  
ATOM   1527  CG2 THR B  51       2.611  11.753  15.982  1.00 35.21           C  
ATOM   1528  N   ASN B  52       2.701   9.823  13.064  1.00 38.01           N  
ATOM   1529  CA  ASN B  52       2.246   8.442  12.965  1.00 40.12           C  
ATOM   1530  C   ASN B  52       1.901   7.858  14.336  1.00 41.24           C  
ATOM   1531  O   ASN B  52       2.639   8.032  15.304  1.00 42.12           O  
ATOM   1532  CB  ASN B  52       3.286   7.585  12.253  1.00 42.13           C  
ATOM   1533  CG  ASN B  52       4.652   7.637  12.939  1.00 50.19           C  
ATOM   1534  OD1 ASN B  52       5.516   8.473  12.600  1.00 53.89           O  
ATOM   1535  ND2 ASN B  52       4.836   6.773  13.935  1.00 55.29           N  
ATOM   1536  N   THR B  53       0.755   7.180  14.411  1.00 42.01           N  
ATOM   1537  CA  THR B  53       0.382   6.445  15.613  1.00 43.71           C  
ATOM   1538  C   THR B  53       1.488   5.451  15.913  1.00 45.28           C  
ATOM   1539  O   THR B  53       1.789   4.591  15.096  1.00 46.51           O  
ATOM   1540  CB  THR B  53      -0.912   5.671  15.430  1.00 42.71           C  
ATOM   1541  OG1 THR B  53      -1.873   6.506  14.780  1.00 41.99           O  
ATOM   1542  CG2 THR B  53      -1.455   5.189  16.790  1.00 39.18           C  
ATOM   1543  N   SER B  54       2.138   5.643  17.051  1.00 46.26           N  
ATOM   1544  CA  SER B  54       2.988   4.626  17.668  1.00 45.48           C  
ATOM   1545  C   SER B  54       2.471   4.479  19.093  1.00 44.04           C  
ATOM   1546  O   SER B  54       2.248   5.474  19.789  1.00 41.01           O  
ATOM   1547  CB  SER B  54       4.478   5.030  17.633  1.00 47.69           C  
ATOM   1548  OG  SER B  54       4.959   5.512  18.880  1.00 46.40           O  
ATOM   1549  N   THR B  55       2.240   3.249  19.523  1.00 45.34           N  
ATOM   1550  CA  THR B  55       1.835   3.013  20.908  1.00 46.49           C  
ATOM   1551  C   THR B  55       2.871   3.553  21.904  1.00 44.60           C  
ATOM   1552  O   THR B  55       2.504   4.093  22.931  1.00 43.94           O  
ATOM   1553  CB  THR B  55       1.616   1.528  21.176  1.00 47.93           C  
ATOM   1554  OG1 THR B  55       2.832   0.823  20.892  1.00 53.95           O  
ATOM   1555  CG2 THR B  55       0.482   0.996  20.316  1.00 45.08           C  
ATOM   1556  N   ARG B  56       4.155   3.401  21.591  1.00 44.07           N  
ATOM   1557  CA  ARG B  56       5.226   3.989  22.400  1.00 44.95           C  
ATOM   1558  C   ARG B  56       4.964   5.478  22.664  1.00 42.16           C  
ATOM   1559  O   ARG B  56       4.821   5.888  23.804  1.00 38.45           O  
ATOM   1560  CB  ARG B  56       6.592   3.801  21.704  1.00 46.06           C  
ATOM   1561  CG  ARG B  56       7.814   3.737  22.624  1.00 50.57           C  
ATOM   1562  CD  ARG B  56       8.807   2.619  22.212  1.00 51.86           C  
HETATM 1563  N   MSE B  57       4.884   6.269  21.600  1.00 39.98           N  
HETATM 1564  CA  MSE B  57       4.727   7.712  21.718  1.00 39.93           C  
HETATM 1565  C   MSE B  57       3.460   8.052  22.484  1.00 39.89           C  
HETATM 1566  O   MSE B  57       3.470   8.914  23.341  1.00 41.38           O  
HETATM 1567  CB  MSE B  57       4.680   8.367  20.326  1.00 38.73           C  
HETATM 1568  CG  MSE B  57       4.489   9.873  20.303  1.00 43.71           C  
HETATM 1569 SE   MSE B  57       5.949  10.911  21.169  0.75 52.10          SE  
HETATM 1570  CE  MSE B  57       5.687  10.435  23.033  1.00 69.17           C  
ATOM   1571  N   VAL B  58       2.373   7.359  22.177  1.00 39.19           N  
ATOM   1572  CA  VAL B  58       1.086   7.641  22.804  1.00 39.92           C  
ATOM   1573  C   VAL B  58       1.129   7.379  24.295  1.00 39.92           C  
ATOM   1574  O   VAL B  58       0.745   8.234  25.083  1.00 38.83           O  
ATOM   1575  CB  VAL B  58      -0.044   6.820  22.175  1.00 39.18           C  
ATOM   1576  CG1 VAL B  58      -1.326   6.971  22.990  1.00 43.40           C  
ATOM   1577  CG2 VAL B  58      -0.248   7.240  20.733  1.00 38.95           C  
ATOM   1578  N   GLU B  59       1.598   6.197  24.666  1.00 41.11           N  
ATOM   1579  CA  GLU B  59       1.782   5.837  26.062  1.00 44.61           C  
ATOM   1580  C   GLU B  59       2.658   6.844  26.801  1.00 43.57           C  
ATOM   1581  O   GLU B  59       2.351   7.191  27.931  1.00 45.53           O  
ATOM   1582  CB  GLU B  59       2.408   4.451  26.178  1.00 43.51           C  
ATOM   1583  CG  GLU B  59       1.456   3.301  25.838  1.00 52.64           C  
ATOM   1584  CD  GLU B  59       2.148   1.924  25.842  1.00 51.97           C  
ATOM   1585  OE1 GLU B  59       3.412   1.861  25.838  1.00 58.99           O  
ATOM   1586  OE2 GLU B  59       1.414   0.905  25.834  1.00 60.12           O  
ATOM   1587  N   ARG B  60       3.752   7.272  26.171  1.00 39.70           N  
ATOM   1588  CA  ARG B  60       4.654   8.280  26.726  1.00 38.88           C  
ATOM   1589  C   ARG B  60       3.976   9.630  26.926  1.00 36.04           C  
ATOM   1590  O   ARG B  60       4.138  10.256  27.972  1.00 33.79           O  
ATOM   1591  CB  ARG B  60       5.887   8.481  25.831  1.00 40.38           C  
ATOM   1592  CG  ARG B  60       6.732   9.784  26.161  1.00 44.71           C  
ATOM   1593  CD  ARG B  60       7.872  10.088  25.153  1.00 41.30           C  
ATOM   1594  NE  ARG B  60       8.513   8.840  24.756  1.00 44.41           N  
ATOM   1595  CZ  ARG B  60       9.313   8.691  23.713  1.00 38.83           C  
ATOM   1596  NH1 ARG B  60       9.647   9.723  22.938  1.00 43.60           N  
ATOM   1597  NH2 ARG B  60       9.793   7.486  23.453  1.00 42.14           N  
ATOM   1598  N   LEU B  61       3.270  10.118  25.911  1.00 37.47           N  
ATOM   1599  CA  LEU B  61       2.556  11.393  26.048  1.00 36.56           C  
ATOM   1600  C   LEU B  61       1.433  11.348  27.092  1.00 38.62           C  
ATOM   1601  O   LEU B  61       1.138  12.351  27.740  1.00 41.15           O  
ATOM   1602  CB  LEU B  61       2.000  11.838  24.720  1.00 38.22           C  
ATOM   1603  CG  LEU B  61       3.086  12.239  23.741  1.00 36.60           C  
ATOM   1604  CD1 LEU B  61       2.394  12.691  22.465  1.00 34.14           C  
ATOM   1605  CD2 LEU B  61       4.037  13.310  24.338  1.00 32.10           C  
ATOM   1606  N   LYS B  62       0.839  10.178  27.265  1.00 39.09           N  
ATOM   1607  CA  LYS B  62      -0.166   9.965  28.299  1.00 40.49           C  
ATOM   1608  C   LYS B  62       0.389  10.135  29.720  1.00 41.04           C  
ATOM   1609  O   LYS B  62      -0.305  10.625  30.611  1.00 44.89           O  
ATOM   1610  CB  LYS B  62      -0.770   8.557  28.161  1.00 42.36           C  
ATOM   1611  CG  LYS B  62      -1.787   8.399  27.011  1.00 46.74           C  
ATOM   1612  CD  LYS B  62      -2.566   7.064  27.078  1.00 45.89           C  
ATOM   1613  CE  LYS B  62      -3.696   7.016  26.030  1.00 49.81           C  
ATOM   1614  NZ  LYS B  62      -4.257   5.638  25.832  1.00 57.70           N  
ATOM   1615  N   LYS B  63       1.628   9.717  29.932  1.00 37.74           N  
ATOM   1616  CA  LYS B  63       2.257   9.758  31.236  1.00 35.70           C  
ATOM   1617  C   LYS B  63       3.016  11.060  31.432  1.00 33.27           C  
ATOM   1618  O   LYS B  63       3.226  11.494  32.550  1.00 28.74           O  
ATOM   1619  CB  LYS B  63       3.236   8.594  31.370  1.00 35.80           C  
ATOM   1620  CG  LYS B  63       2.628   7.210  31.120  1.00 43.74           C  
ATOM   1621  CD  LYS B  63       2.141   6.546  32.398  1.00 50.86           C  
ATOM   1622  CE  LYS B  63       2.215   5.025  32.326  1.00 52.01           C  
ATOM   1623  NZ  LYS B  63       3.633   4.573  32.250  1.00 55.87           N  
ATOM   1624  N   ASN B  64       3.477  11.676  30.342  1.00 30.51           N  
ATOM   1625  CA  ASN B  64       4.236  12.910  30.456  1.00 27.17           C  
ATOM   1626  C   ASN B  64       4.047  13.711  29.171  1.00 28.15           C  
ATOM   1627  O   ASN B  64       4.548  13.312  28.144  1.00 26.83           O  
ATOM   1628  CB  ASN B  64       5.703  12.566  30.688  1.00 28.63           C  
ATOM   1629  CG  ASN B  64       6.547  13.765  31.013  1.00 28.48           C  
ATOM   1630  OD1 ASN B  64       6.257  14.889  30.615  1.00 30.92           O  
ATOM   1631  ND2 ASN B  64       7.613  13.527  31.752  1.00 27.36           N  
ATOM   1632  N   ASN B  65       3.291  14.804  29.243  1.00 26.95           N  
ATOM   1633  CA  ASN B  65       2.949  15.625  28.075  1.00 28.75           C  
ATOM   1634  C   ASN B  65       3.688  16.951  28.013  1.00 30.93           C  
ATOM   1635  O   ASN B  65       3.291  17.839  27.293  1.00 32.38           O  
ATOM   1636  CB  ASN B  65       1.434  15.874  28.025  1.00 31.15           C  
ATOM   1637  CG  ASN B  65       0.937  16.756  29.161  1.00 33.85           C  
ATOM   1638  OD1 ASN B  65       1.684  17.103  30.075  1.00 33.74           O  
ATOM   1639  ND2 ASN B  65      -0.305  17.181  29.065  1.00 33.21           N  
ATOM   1640  N   LYS B  66       4.794  17.059  28.738  1.00 31.12           N  
ATOM   1641  CA  LYS B  66       5.637  18.231  28.702  1.00 28.10           C  
ATOM   1642  C   LYS B  66       6.566  18.093  27.512  1.00 27.14           C  
ATOM   1643  O   LYS B  66       7.313  17.110  27.358  1.00 26.53           O  
ATOM   1644  CB  LYS B  66       6.423  18.363  29.996  1.00 31.79           C  
ATOM   1645  CG  LYS B  66       5.539  18.622  31.247  1.00 25.16           C  
ATOM   1646  CD  LYS B  66       6.431  18.850  32.471  1.00 31.81           C  
ATOM   1647  CE  LYS B  66       5.572  19.000  33.728  1.00 40.79           C  
ATOM   1648  NZ  LYS B  66       6.301  19.673  34.824  1.00 40.74           N  
ATOM   1649  N   ILE B  67       6.458  19.050  26.616  1.00 24.20           N  
ATOM   1650  CA  ILE B  67       7.187  18.939  25.399  1.00 25.78           C  
ATOM   1651  C   ILE B  67       7.773  20.283  25.035  1.00 23.10           C  
ATOM   1652  O   ILE B  67       7.479  21.333  25.646  1.00 25.36           O  
ATOM   1653  CB  ILE B  67       6.325  18.387  24.217  1.00 25.59           C  
ATOM   1654  CG1 ILE B  67       5.288  19.396  23.750  1.00 27.97           C  
ATOM   1655  CG2 ILE B  67       5.681  17.041  24.533  1.00 24.33           C  
ATOM   1656  CD1 ILE B  67       4.974  19.230  22.269  1.00 28.59           C  
ATOM   1657  N   CYS B  68       8.572  20.265  23.995  1.00 24.94           N  
ATOM   1658  CA  CYS B  68       8.933  21.506  23.369  1.00 24.15           C  
ATOM   1659  C   CYS B  68       8.949  21.342  21.870  1.00 20.70           C  
ATOM   1660  O   CYS B  68       9.091  20.235  21.338  1.00 23.93           O  
ATOM   1661  CB  CYS B  68      10.254  22.013  23.892  1.00 28.62           C  
ATOM   1662  SG  CYS B  68      11.648  21.268  23.139  1.00 37.33           S  
ATOM   1663  N   LEU B  69       8.721  22.440  21.194  1.00 22.53           N  
ATOM   1664  CA  LEU B  69       8.836  22.508  19.710  1.00 22.32           C  
ATOM   1665  C   LEU B  69      10.036  23.327  19.330  1.00 23.93           C  
ATOM   1666  O   LEU B  69      10.359  24.318  20.006  1.00 28.47           O  
ATOM   1667  CB  LEU B  69       7.604  23.181  19.095  1.00 23.06           C  
ATOM   1668  CG  LEU B  69       6.197  22.611  19.349  1.00 29.60           C  
ATOM   1669  CD1 LEU B  69       5.166  23.270  18.390  1.00 25.34           C  
ATOM   1670  CD2 LEU B  69       6.198  21.168  19.119  1.00 25.07           C  
ATOM   1671  N   TYR B  70      10.682  22.976  18.227  1.00 24.40           N  
ATOM   1672  CA  TYR B  70      11.801  23.791  17.721  1.00 23.17           C  
ATOM   1673  C   TYR B  70      11.690  24.016  16.217  1.00 26.53           C  
ATOM   1674  O   TYR B  70      11.398  23.085  15.472  1.00 27.62           O  
ATOM   1675  CB  TYR B  70      13.138  23.120  18.057  1.00 26.78           C  
ATOM   1676  CG  TYR B  70      14.342  23.996  17.837  1.00 23.10           C  
ATOM   1677  CD1 TYR B  70      14.746  24.900  18.809  1.00 31.25           C  
ATOM   1678  CD2 TYR B  70      15.055  23.938  16.667  1.00 38.72           C  
ATOM   1679  CE1 TYR B  70      15.843  25.724  18.613  1.00 30.70           C  
ATOM   1680  CE2 TYR B  70      16.159  24.770  16.466  1.00 43.02           C  
ATOM   1681  CZ  TYR B  70      16.533  25.651  17.451  1.00 33.95           C  
ATOM   1682  OH  TYR B  70      17.615  26.467  17.242  1.00 40.89           O  
ATOM   1683  N   PHE B  71      11.942  25.249  15.789  1.00 27.96           N  
ATOM   1684  CA  PHE B  71      11.899  25.636  14.394  1.00 29.81           C  
ATOM   1685  C   PHE B  71      13.216  26.245  14.091  1.00 31.76           C  
ATOM   1686  O   PHE B  71      13.693  27.063  14.863  1.00 32.59           O  
ATOM   1687  CB  PHE B  71      10.842  26.716  14.148  1.00 30.69           C  
ATOM   1688  CG  PHE B  71       9.496  26.358  14.645  1.00 34.88           C  
ATOM   1689  CD1 PHE B  71       9.184  26.527  15.982  1.00 29.22           C  
ATOM   1690  CD2 PHE B  71       8.543  25.805  13.790  1.00 36.92           C  
ATOM   1691  CE1 PHE B  71       7.955  26.187  16.457  1.00 31.29           C  
ATOM   1692  CE2 PHE B  71       7.297  25.446  14.286  1.00 34.20           C  
ATOM   1693  CZ  PHE B  71       7.012  25.652  15.617  1.00 28.78           C  
ATOM   1694  N   VAL B  72      13.826  25.885  12.984  1.00 36.22           N  
ATOM   1695  CA  VAL B  72      15.149  26.429  12.717  1.00 41.83           C  
ATOM   1696  C   VAL B  72      15.252  26.928  11.298  1.00 46.49           C  
ATOM   1697  O   VAL B  72      14.557  26.417  10.436  1.00 47.39           O  
ATOM   1698  CB  VAL B  72      16.228  25.345  12.985  1.00 43.18           C  
ATOM   1699  CG1 VAL B  72      16.292  24.355  11.820  1.00 40.60           C  
ATOM   1700  CG2 VAL B  72      17.595  25.988  13.342  1.00 41.80           C  
ATOM   1701  N   ASP B  73      16.074  27.958  11.073  1.00 50.10           N  
ATOM   1702  CA  ASP B  73      16.753  28.099   9.772  1.00 55.73           C  
ATOM   1703  C   ASP B  73      18.280  28.206   9.943  1.00 56.00           C  
ATOM   1704  O   ASP B  73      18.828  29.246  10.351  1.00 54.00           O  
ATOM   1705  CB  ASP B  73      16.231  29.245   8.908  1.00 57.45           C  
ATOM   1706  CG  ASP B  73      16.678  29.101   7.434  1.00 66.47           C  
ATOM   1707  OD1 ASP B  73      16.542  27.980   6.867  1.00 65.48           O  
ATOM   1708  OD2 ASP B  73      17.184  30.092   6.850  1.00 77.13           O  
ATOM   1709  N   ASP B  74      18.945  27.096   9.623  1.00 57.90           N  
ATOM   1710  CA  ASP B  74      20.399  26.978   9.697  1.00 58.33           C  
ATOM   1711  C   ASP B  74      21.122  28.028   8.871  1.00 57.99           C  
ATOM   1712  O   ASP B  74      22.252  28.364   9.198  1.00 57.34           O  
ATOM   1713  CB  ASP B  74      20.879  25.556   9.305  1.00 59.01           C  
ATOM   1714  CG  ASP B  74      20.123  24.960   8.108  1.00 60.53           C  
ATOM   1715  OD1 ASP B  74      19.258  25.647   7.524  1.00 65.26           O  
ATOM   1716  OD2 ASP B  74      20.393  23.788   7.759  1.00 62.86           O  
ATOM   1717  N   ASN B  75      20.477  28.544   7.820  1.00 58.86           N  
ATOM   1718  CA  ASN B  75      21.083  29.582   6.969  1.00 60.66           C  
ATOM   1719  C   ASN B  75      21.317  30.883   7.736  1.00 60.84           C  
ATOM   1720  O   ASN B  75      22.358  31.539   7.557  1.00 61.38           O  
ATOM   1721  CB  ASN B  75      20.243  29.866   5.718  1.00 60.51           C  
ATOM   1722  CG  ASN B  75      20.079  28.648   4.831  1.00 63.91           C  
ATOM   1723  OD1 ASN B  75      19.017  28.015   4.822  1.00 70.88           O  
ATOM   1724  ND2 ASN B  75      21.128  28.304   4.086  1.00 61.65           N  
ATOM   1725  N   LYS B  76      20.361  31.253   8.591  1.00 59.50           N  
ATOM   1726  CA  LYS B  76      20.548  32.401   9.471  1.00 58.60           C  
ATOM   1727  C   LYS B  76      21.161  32.016  10.829  1.00 57.60           C  
ATOM   1728  O   LYS B  76      21.486  32.885  11.642  1.00 59.78           O  
ATOM   1729  CB  LYS B  76      19.222  33.118   9.684  1.00 59.56           C  
ATOM   1730  CG  LYS B  76      18.644  33.757   8.434  1.00 61.16           C  
ATOM   1731  CD  LYS B  76      17.341  34.486   8.768  1.00 66.45           C  
ATOM   1732  CE  LYS B  76      16.883  35.397   7.642  1.00 69.20           C  
ATOM   1733  NZ  LYS B  76      15.467  35.827   7.821  1.00 66.07           N  
ATOM   1734  N   PHE B  77      21.355  30.726  11.064  1.00 55.25           N  
ATOM   1735  CA  PHE B  77      21.628  30.209  12.415  1.00 53.28           C  
ATOM   1736  C   PHE B  77      20.688  30.877  13.464  1.00 48.87           C  
ATOM   1737  O   PHE B  77      21.110  31.418  14.495  1.00 48.42           O  
ATOM   1738  CB  PHE B  77      23.129  30.289  12.781  1.00 53.90           C  
ATOM   1739  CG  PHE B  77      23.506  29.395  13.942  1.00 55.73           C  
ATOM   1740  CD1 PHE B  77      23.219  28.033  13.907  1.00 60.97           C  
ATOM   1741  CD2 PHE B  77      24.095  29.913  15.086  1.00 60.64           C  
ATOM   1742  CE1 PHE B  77      23.531  27.203  14.986  1.00 59.51           C  
ATOM   1743  CE2 PHE B  77      24.412  29.079  16.176  1.00 62.40           C  
ATOM   1744  CZ  PHE B  77      24.133  27.726  16.117  1.00 56.38           C  
ATOM   1745  N   ALA B  78      19.399  30.841  13.134  1.00 42.27           N  
ATOM   1746  CA  ALA B  78      18.343  31.300  13.996  1.00 36.66           C  
ATOM   1747  C   ALA B  78      17.420  30.118  14.250  1.00 35.34           C  
ATOM   1748  O   ALA B  78      17.280  29.199  13.436  1.00 32.23           O  
ATOM   1749  CB  ALA B  78      17.570  32.475  13.370  1.00 31.46           C  
ATOM   1750  N   GLY B  79      16.810  30.153  15.410  1.00 33.22           N  
ATOM   1751  CA  GLY B  79      15.853  29.156  15.774  1.00 33.73           C  
ATOM   1752  C   GLY B  79      14.866  29.723  16.751  1.00 31.36           C  
ATOM   1753  O   GLY B  79      15.100  30.747  17.383  1.00 34.02           O  
ATOM   1754  N   LEU B  80      13.753  29.030  16.893  1.00 32.34           N  
ATOM   1755  CA  LEU B  80      12.746  29.404  17.836  1.00 26.47           C  
ATOM   1756  C   LEU B  80      12.363  28.166  18.609  1.00 29.16           C  
ATOM   1757  O   LEU B  80      12.055  27.155  17.998  1.00 28.26           O  
ATOM   1758  CB  LEU B  80      11.546  29.930  17.060  1.00 25.57           C  
ATOM   1759  CG  LEU B  80      10.238  29.997  17.868  1.00 23.93           C  
ATOM   1760  CD1 LEU B  80      10.364  31.059  18.915  1.00 22.54           C  
ATOM   1761  CD2 LEU B  80       9.076  30.329  16.934  1.00 18.35           C  
HETATM 1762  N   MSE B  81      12.345  28.232  19.940  1.00 30.24           N  
HETATM 1763  CA  MSE B  81      11.869  27.115  20.738  1.00 30.34           C  
HETATM 1764  C   MSE B  81      10.671  27.540  21.544  1.00 27.74           C  
HETATM 1765  O   MSE B  81      10.701  28.583  22.195  1.00 26.05           O  
HETATM 1766  CB  MSE B  81      12.935  26.629  21.715  1.00 29.55           C  
HETATM 1767  CG  MSE B  81      12.373  25.672  22.759  1.00 38.84           C  
HETATM 1768 SE   MSE B  81      13.552  25.208  24.181  0.75 50.68          SE  
HETATM 1769  CE  MSE B  81      13.572  26.777  25.368  1.00 33.05           C  
ATOM   1770  N   LEU B  82       9.645  26.689  21.561  1.00 25.33           N  
ATOM   1771  CA  LEU B  82       8.463  26.930  22.367  1.00 25.95           C  
ATOM   1772  C   LEU B  82       8.312  25.774  23.300  1.00 25.36           C  
ATOM   1773  O   LEU B  82       8.490  24.618  22.881  1.00 24.30           O  
ATOM   1774  CB  LEU B  82       7.208  27.035  21.510  1.00 26.39           C  
ATOM   1775  CG  LEU B  82       7.235  28.127  20.435  1.00 19.24           C  
ATOM   1776  CD1 LEU B  82       6.040  27.922  19.468  1.00 28.98           C  
ATOM   1777  CD2 LEU B  82       7.227  29.563  21.010  1.00 19.84           C  
ATOM   1778  N   VAL B  83       7.937  26.082  24.541  1.00 24.86           N  
ATOM   1779  CA  VAL B  83       7.800  25.114  25.615  1.00 25.05           C  
ATOM   1780  C   VAL B  83       6.354  25.101  26.128  1.00 25.13           C  
ATOM   1781  O   VAL B  83       5.714  26.150  26.272  1.00 25.95           O  
ATOM   1782  CB  VAL B  83       8.772  25.440  26.765  1.00 24.13           C  
ATOM   1783  CG1 VAL B  83       8.472  24.517  28.017  1.00 28.22           C  
ATOM   1784  CG2 VAL B  83      10.165  25.305  26.300  1.00 29.78           C  
ATOM   1785  N   GLY B  84       5.843  23.913  26.403  1.00 25.39           N  
ATOM   1786  CA  GLY B  84       4.416  23.737  26.655  1.00 24.81           C  
ATOM   1787  C   GLY B  84       4.027  22.295  26.807  1.00 27.82           C  
ATOM   1788  O   GLY B  84       4.868  21.471  27.077  1.00 27.89           O  
ATOM   1789  N   THR B  85       2.726  22.021  26.681  1.00 29.96           N  
ATOM   1790  CA  THR B  85       2.164  20.696  26.845  1.00 28.77           C  
ATOM   1791  C   THR B  85       1.283  20.340  25.663  1.00 28.03           C  
ATOM   1792  O   THR B  85       0.701  21.203  25.007  1.00 25.36           O  
ATOM   1793  CB  THR B  85       1.243  20.619  28.077  1.00 28.80           C  
ATOM   1794  OG1 THR B  85       0.244  21.616  27.930  1.00 26.98           O  
ATOM   1795  CG2 THR B  85       1.996  20.861  29.342  1.00 32.07           C  
ATOM   1796  N   ILE B  86       1.158  19.052  25.424  1.00 30.03           N  
ATOM   1797  CA  ILE B  86       0.524  18.559  24.218  1.00 32.62           C  
ATOM   1798  C   ILE B  86      -0.601  17.590  24.605  1.00 33.78           C  
ATOM   1799  O   ILE B  86      -0.483  16.873  25.581  1.00 33.52           O  
ATOM   1800  CB  ILE B  86       1.571  17.879  23.348  1.00 32.71           C  
ATOM   1801  CG1 ILE B  86       1.093  17.782  21.906  1.00 42.28           C  
ATOM   1802  CG2 ILE B  86       1.960  16.509  23.946  1.00 29.18           C  
ATOM   1803  CD1 ILE B  86       2.212  17.687  20.914  1.00 36.02           C  
ATOM   1804  N   GLU B  87      -1.707  17.599  23.860  1.00 32.86           N  
ATOM   1805  CA  GLU B  87      -2.739  16.591  24.074  1.00 36.84           C  
ATOM   1806  C   GLU B  87      -3.073  15.915  22.746  1.00 33.86           C  
ATOM   1807  O   GLU B  87      -3.020  16.557  21.692  1.00 27.41           O  
ATOM   1808  CB  GLU B  87      -3.968  17.211  24.715  1.00 36.08           C  
ATOM   1809  CG  GLU B  87      -4.831  18.008  23.810  1.00 48.33           C  
ATOM   1810  CD  GLU B  87      -6.295  18.065  24.303  1.00 60.88           C  
ATOM   1811  OE1 GLU B  87      -6.969  17.001  24.340  1.00 66.41           O  
ATOM   1812  OE2 GLU B  87      -6.767  19.178  24.623  1.00 64.54           O  
ATOM   1813  N   ILE B  88      -3.388  14.627  22.799  1.00 32.24           N  
ATOM   1814  CA  ILE B  88      -3.770  13.856  21.606  1.00 33.94           C  
ATOM   1815  C   ILE B  88      -5.227  14.113  21.359  1.00 32.72           C  
ATOM   1816  O   ILE B  88      -6.019  13.989  22.256  1.00 29.04           O  
ATOM   1817  CB  ILE B  88      -3.598  12.333  21.814  1.00 33.90           C  
ATOM   1818  CG1 ILE B  88      -2.122  11.962  22.038  1.00 37.48           C  
ATOM   1819  CG2 ILE B  88      -4.189  11.532  20.627  1.00 37.21           C  
ATOM   1820  CD1 ILE B  88      -1.928  10.626  22.829  1.00 35.49           C  
ATOM   1821  N   LEU B  89      -5.586  14.431  20.128  1.00 32.93           N  
ATOM   1822  CA  LEU B  89      -6.989  14.603  19.787  1.00 32.01           C  
ATOM   1823  C   LEU B  89      -7.566  13.345  19.142  1.00 33.74           C  
ATOM   1824  O   LEU B  89      -7.290  13.021  17.980  1.00 32.59           O  
ATOM   1825  CB  LEU B  89      -7.168  15.792  18.862  1.00 31.48           C  
ATOM   1826  CG  LEU B  89      -6.654  17.142  19.336  1.00 30.38           C  
ATOM   1827  CD1 LEU B  89      -6.924  18.167  18.218  1.00 24.35           C  
ATOM   1828  CD2 LEU B  89      -7.332  17.547  20.644  1.00 32.66           C  
ATOM   1829  N   HIS B  90      -8.409  12.657  19.895  1.00 30.50           N  
ATOM   1830  CA  HIS B  90      -8.944  11.366  19.465  1.00 34.46           C  
ATOM   1831  C   HIS B  90     -10.215  11.431  18.618  1.00 37.25           C  
ATOM   1832  O   HIS B  90     -10.554  10.463  17.931  1.00 39.37           O  
ATOM   1833  CB  HIS B  90      -9.192  10.484  20.699  1.00 34.17           C  
ATOM   1834  CG  HIS B  90      -7.922  10.076  21.380  1.00 37.95           C  
ATOM   1835  ND1 HIS B  90      -7.497  10.635  22.571  1.00 39.91           N  
ATOM   1836  CD2 HIS B  90      -6.950   9.210  21.001  1.00 39.36           C  
ATOM   1837  CE1 HIS B  90      -6.336  10.103  22.912  1.00 41.58           C  
ATOM   1838  NE2 HIS B  90      -5.986   9.231  21.981  1.00 43.39           N  
ATOM   1839  N   ASP B  91     -10.902  12.560  18.640  1.00 37.45           N  
ATOM   1840  CA  ASP B  91     -12.193  12.653  17.976  1.00 36.57           C  
ATOM   1841  C   ASP B  91     -12.056  12.940  16.486  1.00 35.95           C  
ATOM   1842  O   ASP B  91     -11.193  13.701  16.043  1.00 38.15           O  
ATOM   1843  CB  ASP B  91     -13.057  13.702  18.641  1.00 36.95           C  
ATOM   1844  CG  ASP B  91     -12.518  15.073  18.459  1.00 39.01           C  
ATOM   1845  OD1 ASP B  91     -11.386  15.300  18.948  1.00 45.20           O  
ATOM   1846  OD2 ASP B  91     -13.216  15.905  17.829  1.00 50.98           O  
ATOM   1847  N   ARG B  92     -12.926  12.306  15.713  1.00 36.65           N  
ATOM   1848  CA  ARG B  92     -12.837  12.328  14.269  1.00 35.15           C  
ATOM   1849  C   ARG B  92     -13.182  13.707  13.734  1.00 33.54           C  
ATOM   1850  O   ARG B  92     -12.592  14.134  12.755  1.00 30.78           O  
ATOM   1851  CB  ARG B  92     -13.743  11.271  13.655  1.00 34.97           C  
ATOM   1852  CG  ARG B  92     -13.683  11.227  12.121  1.00 40.52           C  
ATOM   1853  CD  ARG B  92     -14.624  10.168  11.524  1.00 39.76           C  
ATOM   1854  NE  ARG B  92     -14.241   9.857  10.148  1.00 43.56           N  
ATOM   1855  CZ  ARG B  92     -14.383  10.692   9.119  1.00 41.20           C  
ATOM   1856  NH1 ARG B  92     -14.946  11.889   9.259  1.00 49.73           N  
ATOM   1857  NH2 ARG B  92     -14.000  10.309   7.919  1.00 41.46           N  
ATOM   1858  N   ALA B  93     -14.098  14.409  14.406  1.00 30.81           N  
ATOM   1859  CA  ALA B  93     -14.432  15.793  14.069  1.00 31.87           C  
ATOM   1860  C   ALA B  93     -13.174  16.666  13.944  1.00 30.53           C  
ATOM   1861  O   ALA B  93     -12.933  17.333  12.918  1.00 30.55           O  
ATOM   1862  CB  ALA B  93     -15.389  16.354  15.133  1.00 31.45           C  
ATOM   1863  N   SER B  94     -12.327  16.606  14.959  1.00 31.00           N  
ATOM   1864  CA  SER B  94     -11.114  17.419  14.986  1.00 30.34           C  
ATOM   1865  C   SER B  94     -10.127  16.987  13.914  1.00 30.22           C  
ATOM   1866  O   SER B  94      -9.534  17.825  13.209  1.00 26.05           O  
ATOM   1867  CB  SER B  94     -10.459  17.346  16.368  1.00 34.78           C  
ATOM   1868  OG  SER B  94     -11.376  17.759  17.376  1.00 29.99           O  
ATOM   1869  N   LYS B  95      -9.973  15.678  13.802  1.00 26.06           N  
ATOM   1870  CA  LYS B  95      -9.112  15.074  12.850  1.00 30.71           C  
ATOM   1871  C   LYS B  95      -9.507  15.483  11.457  1.00 29.42           C  
ATOM   1872  O   LYS B  95      -8.663  15.791  10.669  1.00 29.79           O  
ATOM   1873  CB  LYS B  95      -9.115  13.554  13.059  1.00 30.34           C  
ATOM   1874  CG  LYS B  95      -8.294  13.179  14.306  1.00 32.79           C  
ATOM   1875  CD  LYS B  95      -8.387  11.705  14.700  1.00 36.00           C  
ATOM   1876  CE  LYS B  95      -7.260  10.880  14.128  1.00 40.17           C  
ATOM   1877  NZ  LYS B  95      -7.352   9.430  14.516  1.00 48.63           N  
ATOM   1878  N   GLU B  96     -10.809  15.524  11.186  1.00 29.38           N  
ATOM   1879  CA  GLU B  96     -11.335  15.986   9.905  1.00 28.62           C  
ATOM   1880  C   GLU B  96     -11.095  17.482   9.669  1.00 30.19           C  
ATOM   1881  O   GLU B  96     -10.696  17.879   8.574  1.00 28.03           O  
ATOM   1882  CB  GLU B  96     -12.831  15.719   9.865  1.00 29.40           C  
ATOM   1883  CG  GLU B  96     -13.499  16.089   8.590  1.00 33.66           C  
ATOM   1884  CD  GLU B  96     -14.965  15.734   8.632  1.00 37.95           C  
ATOM   1885  OE1 GLU B  96     -15.623  16.067   9.642  1.00 29.40           O  
ATOM   1886  OE2 GLU B  96     -15.448  15.118   7.666  1.00 33.13           O  
HETATM 1887  N   MSE B  97     -11.344  18.314  10.679  1.00 26.84           N  
HETATM 1888  CA  MSE B  97     -11.118  19.743  10.537  1.00 28.89           C  
HETATM 1889  C   MSE B  97      -9.653  20.111  10.383  1.00 30.25           C  
HETATM 1890  O   MSE B  97      -9.337  21.130   9.785  1.00 31.74           O  
HETATM 1891  CB  MSE B  97     -11.676  20.509  11.709  1.00 23.89           C  
HETATM 1892  CG  MSE B  97     -13.135  20.788  11.539  1.00 36.54           C  
HETATM 1893 SE   MSE B  97     -13.824  21.789  13.036  0.75 35.03          SE  
HETATM 1894  CE  MSE B  97     -13.915  20.336  14.371  1.00 34.28           C  
ATOM   1895  N   LEU B  98      -8.758  19.286  10.902  1.00 29.14           N  
ATOM   1896  CA  LEU B  98      -7.335  19.589  10.811  1.00 30.02           C  
ATOM   1897  C   LEU B  98      -6.640  18.987   9.609  1.00 30.53           C  
ATOM   1898  O   LEU B  98      -5.528  19.408   9.265  1.00 32.45           O  
ATOM   1899  CB  LEU B  98      -6.682  19.089  12.093  1.00 31.91           C  
ATOM   1900  CG  LEU B  98      -7.038  19.880  13.332  1.00 29.25           C  
ATOM   1901  CD1 LEU B  98      -6.577  19.045  14.542  1.00 33.21           C  
ATOM   1902  CD2 LEU B  98      -6.372  21.318  13.219  1.00 28.86           C  
ATOM   1903  N   TRP B  99      -7.283  18.004   8.972  1.00 31.71           N  
ATOM   1904  CA  TRP B  99      -6.752  17.356   7.772  1.00 34.23           C  
ATOM   1905  C   TRP B  99      -6.345  18.376   6.718  1.00 37.41           C  
ATOM   1906  O   TRP B  99      -7.041  19.372   6.519  1.00 38.24           O  
ATOM   1907  CB  TRP B  99      -7.788  16.379   7.192  1.00 34.59           C  
ATOM   1908  CG  TRP B  99      -7.351  15.638   5.957  1.00 31.65           C  
ATOM   1909  CD1 TRP B  99      -7.525  16.033   4.672  1.00 36.76           C  
ATOM   1910  CD2 TRP B  99      -6.677  14.376   5.899  1.00 30.19           C  
ATOM   1911  NE1 TRP B  99      -7.000  15.098   3.809  1.00 33.69           N  
ATOM   1912  CE2 TRP B  99      -6.484  14.065   4.540  1.00 33.61           C  
ATOM   1913  CE3 TRP B  99      -6.245  13.465   6.864  1.00 30.65           C  
ATOM   1914  CZ2 TRP B  99      -5.839  12.898   4.118  1.00 33.54           C  
ATOM   1915  CZ3 TRP B  99      -5.621  12.306   6.448  1.00 34.46           C  
ATOM   1916  CH2 TRP B  99      -5.429  12.031   5.085  1.00 36.10           C  
ATOM   1917  N   THR B 100      -5.211  18.145   6.060  1.00 38.31           N  
ATOM   1918  CA  THR B 100      -4.745  19.040   5.004  1.00 41.93           C  
ATOM   1919  C   THR B 100      -4.294  18.240   3.803  1.00 46.53           C  
ATOM   1920  O   THR B 100      -4.084  17.030   3.886  1.00 45.70           O  
ATOM   1921  CB  THR B 100      -3.524  19.905   5.416  1.00 43.56           C  
ATOM   1922  OG1 THR B 100      -2.369  19.067   5.538  1.00 46.39           O  
ATOM   1923  CG2 THR B 100      -3.740  20.628   6.736  1.00 40.26           C  
ATOM   1924  N   ASP B 101      -4.138  18.935   2.681  1.00 50.64           N  
ATOM   1925  CA  ASP B 101      -3.419  18.397   1.536  1.00 53.29           C  
ATOM   1926  C   ASP B 101      -2.058  17.908   1.977  1.00 53.68           C  
ATOM   1927  O   ASP B 101      -1.431  18.486   2.874  1.00 55.41           O  
ATOM   1928  CB  ASP B 101      -3.239  19.466   0.457  1.00 55.52           C  
ATOM   1929  CG  ASP B 101      -4.494  19.678  -0.375  1.00 60.68           C  
ATOM   1930  OD1 ASP B 101      -5.574  19.162   0.014  1.00 55.56           O  
ATOM   1931  OD2 ASP B 101      -4.389  20.364  -1.425  1.00 70.53           O  
ATOM   1932  N   GLY B 102      -1.600  16.825   1.368  1.00 52.52           N  
ATOM   1933  CA  GLY B 102      -0.334  16.249   1.780  1.00 52.95           C  
ATOM   1934  C   GLY B 102      -0.311  15.613   3.164  1.00 51.50           C  
ATOM   1935  O   GLY B 102       0.759  15.211   3.634  1.00 53.43           O  
ATOM   1936  N   CYS B 103      -1.467  15.540   3.826  1.00 46.25           N  
ATOM   1937  CA  CYS B 103      -1.710  14.478   4.769  1.00 43.66           C  
ATOM   1938  C   CYS B 103      -1.856  13.179   3.972  1.00 46.01           C  
ATOM   1939  O   CYS B 103      -1.504  12.101   4.452  1.00 44.45           O  
ATOM   1940  CB  CYS B 103      -2.979  14.713   5.566  1.00 43.04           C  
ATOM   1941  SG  CYS B 103      -2.798  15.730   7.038  1.00 40.20           S  
ATOM   1942  N   GLU B 104      -2.386  13.299   2.755  1.00 46.18           N  
ATOM   1943  CA  GLU B 104      -2.723  12.154   1.931  1.00 49.43           C  
ATOM   1944  C   GLU B 104      -1.503  11.328   1.574  1.00 49.61           C  
ATOM   1945  O   GLU B 104      -1.595  10.105   1.429  1.00 50.65           O  
ATOM   1946  CB  GLU B 104      -3.441  12.619   0.658  1.00 51.95           C  
ATOM   1947  CG  GLU B 104      -2.606  13.511  -0.259  1.00 61.09           C  
ATOM   1948  CD  GLU B 104      -3.407  14.657  -0.849  1.00 74.21           C  
ATOM   1949  OE1 GLU B 104      -3.814  15.540  -0.062  1.00 83.74           O  
ATOM   1950  OE2 GLU B 104      -3.613  14.691  -2.087  1.00 75.23           O  
ATOM   1951  N   ILE B 105      -0.366  12.006   1.467  1.00 48.74           N  
ATOM   1952  CA  ILE B 105       0.905  11.374   1.138  1.00 48.99           C  
ATOM   1953  C   ILE B 105       1.308  10.417   2.236  1.00 45.58           C  
ATOM   1954  O   ILE B 105       1.985   9.429   1.982  1.00 46.67           O  
ATOM   1955  CB  ILE B 105       2.043  12.415   0.996  1.00 50.05           C  
ATOM   1956  CG1 ILE B 105       1.712  13.479  -0.068  1.00 58.18           C  
ATOM   1957  CG2 ILE B 105       3.324  11.720   0.623  1.00 51.39           C  
ATOM   1958  CD1 ILE B 105       2.292  14.887   0.249  1.00 61.50           C  
ATOM   1959  N   TYR B 106       0.909  10.731   3.464  1.00 42.57           N  
ATOM   1960  CA  TYR B 106       1.337   9.990   4.641  1.00 40.54           C  
ATOM   1961  C   TYR B 106       0.276   9.059   5.143  1.00 39.83           C  
ATOM   1962  O   TYR B 106       0.589   8.042   5.754  1.00 36.96           O  
ATOM   1963  CB  TYR B 106       1.697  10.966   5.759  1.00 43.24           C  
ATOM   1964  CG  TYR B 106       2.831  11.870   5.364  1.00 48.39           C  
ATOM   1965  CD1 TYR B 106       4.080  11.339   5.073  1.00 53.59           C  
ATOM   1966  CD2 TYR B 106       2.659  13.248   5.244  1.00 55.18           C  
ATOM   1967  CE1 TYR B 106       5.130  12.140   4.686  1.00 54.74           C  
ATOM   1968  CE2 TYR B 106       3.714  14.069   4.855  1.00 54.46           C  
ATOM   1969  CZ  TYR B 106       4.951  13.501   4.574  1.00 56.40           C  
ATOM   1970  OH  TYR B 106       6.031  14.266   4.177  1.00 56.15           O  
ATOM   1971  N   TYR B 107      -0.980   9.424   4.922  1.00 37.53           N  
ATOM   1972  CA  TYR B 107      -2.105   8.650   5.414  1.00 39.20           C  
ATOM   1973  C   TYR B 107      -3.045   8.323   4.254  1.00 39.55           C  
ATOM   1974  O   TYR B 107      -4.052   8.990   4.047  1.00 38.25           O  
ATOM   1975  CB  TYR B 107      -2.800   9.414   6.525  1.00 40.14           C  
ATOM   1976  CG  TYR B 107      -1.826   9.979   7.540  1.00 43.02           C  
ATOM   1977  CD1 TYR B 107      -1.000   9.140   8.298  1.00 41.29           C  
ATOM   1978  CD2 TYR B 107      -1.716  11.351   7.734  1.00 40.32           C  
ATOM   1979  CE1 TYR B 107      -0.097   9.665   9.232  1.00 42.20           C  
ATOM   1980  CE2 TYR B 107      -0.822  11.881   8.670  1.00 41.08           C  
ATOM   1981  CZ  TYR B 107      -0.019  11.030   9.412  1.00 45.98           C  
ATOM   1982  OH  TYR B 107       0.856  11.571  10.326  1.00 52.04           O  
ATOM   1983  N   PRO B 108      -2.700   7.287   3.476  1.00 39.99           N  
ATOM   1984  CA  PRO B 108      -3.460   6.849   2.307  1.00 40.39           C  
ATOM   1985  C   PRO B 108      -4.940   6.601   2.540  1.00 38.57           C  
ATOM   1986  O   PRO B 108      -5.723   6.818   1.632  1.00 40.94           O  
ATOM   1987  CB  PRO B 108      -2.789   5.527   1.943  1.00 41.48           C  
ATOM   1988  CG  PRO B 108      -1.441   5.664   2.402  1.00 43.29           C  
ATOM   1989  CD  PRO B 108      -1.516   6.444   3.679  1.00 42.29           C  
ATOM   1990  N   LEU B 109      -5.322   6.145   3.733  1.00 38.61           N  
ATOM   1991  CA  LEU B 109      -6.733   5.809   4.024  1.00 37.07           C  
ATOM   1992  C   LEU B 109      -7.549   6.966   4.597  1.00 37.93           C  
ATOM   1993  O   LEU B 109      -8.633   6.744   5.143  1.00 39.05           O  
ATOM   1994  CB  LEU B 109      -6.808   4.637   4.992  1.00 35.44           C  
ATOM   1995  CG  LEU B 109      -6.230   3.301   4.550  1.00 37.67           C  
ATOM   1996  CD1 LEU B 109      -6.710   2.226   5.533  1.00 42.00           C  
ATOM   1997  CD2 LEU B 109      -6.658   2.958   3.150  1.00 38.78           C  
ATOM   1998  N   GLY B 110      -7.017   8.183   4.506  1.00 37.23           N  
ATOM   1999  CA  GLY B 110      -7.767   9.359   4.846  1.00 33.09           C  
ATOM   2000  C   GLY B 110      -7.818   9.617   6.323  1.00 34.15           C  
ATOM   2001  O   GLY B 110      -6.972   9.167   7.076  1.00 32.83           O  
ATOM   2002  N   ILE B 111      -8.829  10.386   6.721  1.00 36.16           N  
ATOM   2003  CA  ILE B 111      -9.059  10.749   8.107  1.00 33.03           C  
ATOM   2004  C   ILE B 111      -9.115   9.519   8.992  1.00 32.97           C  
ATOM   2005  O   ILE B 111      -8.694   9.569  10.144  1.00 32.95           O  
ATOM   2006  CB  ILE B 111     -10.345  11.616   8.237  1.00 33.15           C  
ATOM   2007  CG1 ILE B 111     -10.069  12.996   7.640  1.00 37.92           C  
ATOM   2008  CG2 ILE B 111     -10.827  11.695   9.699  1.00 25.82           C  
ATOM   2009  CD1 ILE B 111     -11.249  13.615   6.827  1.00 42.58           C  
ATOM   2010  N   ASP B 112      -9.609   8.409   8.457  1.00 34.03           N  
ATOM   2011  CA  ASP B 112      -9.723   7.186   9.245  1.00 33.68           C  
ATOM   2012  C   ASP B 112      -8.483   6.300   9.223  1.00 30.74           C  
ATOM   2013  O   ASP B 112      -8.513   5.219   9.784  1.00 32.80           O  
ATOM   2014  CB  ASP B 112     -10.923   6.364   8.788  1.00 34.78           C  
ATOM   2015  CG  ASP B 112     -12.202   7.159   8.804  1.00 37.52           C  
ATOM   2016  OD1 ASP B 112     -12.713   7.412   9.908  1.00 30.23           O  
ATOM   2017  OD2 ASP B 112     -12.667   7.546   7.707  1.00 36.06           O  
ATOM   2018  N   ASP B 113      -7.400   6.744   8.585  1.00 32.49           N  
ATOM   2019  CA  ASP B 113      -6.151   5.979   8.569  1.00 30.61           C  
ATOM   2020  C   ASP B 113      -5.752   5.729  10.016  1.00 32.25           C  
ATOM   2021  O   ASP B 113      -5.760   6.660  10.828  1.00 31.83           O  
ATOM   2022  CB  ASP B 113      -5.061   6.750   7.829  1.00 32.37           C  
ATOM   2023  CG  ASP B 113      -3.859   5.881   7.430  1.00 26.19           C  
ATOM   2024  OD1 ASP B 113      -3.127   5.367   8.303  1.00 31.00           O  
ATOM   2025  OD2 ASP B 113      -3.601   5.783   6.218  1.00 29.29           O  
ATOM   2026  N   PRO B 114      -5.460   4.469  10.375  1.00 33.34           N  
ATOM   2027  CA  PRO B 114      -5.107   4.227  11.760  1.00 32.04           C  
ATOM   2028  C   PRO B 114      -3.773   4.852  12.171  1.00 31.90           C  
ATOM   2029  O   PRO B 114      -3.534   4.976  13.348  1.00 31.41           O  
ATOM   2030  CB  PRO B 114      -5.039   2.700  11.849  1.00 33.05           C  
ATOM   2031  CG  PRO B 114      -4.812   2.247  10.473  1.00 33.20           C  
ATOM   2032  CD  PRO B 114      -5.478   3.221   9.584  1.00 32.22           C  
ATOM   2033  N   ASP B 115      -2.920   5.255  11.219  1.00 30.51           N  
ATOM   2034  CA  ASP B 115      -1.677   5.894  11.548  1.00 31.36           C  
ATOM   2035  C   ASP B 115      -1.723   7.424  11.647  1.00 31.51           C  
ATOM   2036  O   ASP B 115      -0.684   8.042  11.876  1.00 31.03           O  
ATOM   2037  CB  ASP B 115      -0.618   5.512  10.514  1.00 33.93           C  
ATOM   2038  CG  ASP B 115      -0.423   4.014  10.418  1.00 41.60           C  
ATOM   2039  OD1 ASP B 115      -0.251   3.364  11.472  1.00 46.23           O  
ATOM   2040  OD2 ASP B 115      -0.471   3.490   9.285  1.00 48.82           O  
ATOM   2041  N   TYR B 116      -2.886   8.029  11.432  1.00 30.89           N  
ATOM   2042  CA  TYR B 116      -3.033   9.469  11.530  1.00 28.71           C  
ATOM   2043  C   TYR B 116      -3.365   9.793  12.976  1.00 31.94           C  
ATOM   2044  O   TYR B 116      -4.440   9.474  13.452  1.00 28.81           O  
ATOM   2045  CB  TYR B 116      -4.123   9.936  10.572  1.00 29.09           C  
ATOM   2046  CG  TYR B 116      -4.590  11.391  10.682  1.00 27.85           C  
ATOM   2047  CD1 TYR B 116      -3.701  12.417  10.884  1.00 29.37           C  
ATOM   2048  CD2 TYR B 116      -5.932  11.718  10.544  1.00 30.85           C  
ATOM   2049  CE1 TYR B 116      -4.136  13.745  10.976  1.00 32.91           C  
ATOM   2050  CE2 TYR B 116      -6.389  13.058  10.638  1.00 23.82           C  
ATOM   2051  CZ  TYR B 116      -5.482  14.055  10.865  1.00 29.37           C  
ATOM   2052  OH  TYR B 116      -5.904  15.368  10.945  1.00 27.28           O  
ATOM   2053  N   THR B 117      -2.418  10.396  13.678  1.00 32.87           N  
ATOM   2054  CA  THR B 117      -2.649  10.938  15.022  1.00 33.74           C  
ATOM   2055  C   THR B 117      -2.556  12.461  14.955  1.00 32.49           C  
ATOM   2056  O   THR B 117      -1.682  13.003  14.297  1.00 30.29           O  
ATOM   2057  CB  THR B 117      -1.624  10.377  16.028  1.00 36.56           C  
ATOM   2058  OG1 THR B 117      -1.952   9.014  16.308  1.00 37.80           O  
ATOM   2059  CG2 THR B 117      -1.594  11.170  17.372  1.00 35.92           C  
ATOM   2060  N   ALA B 118      -3.496  13.153  15.593  1.00 28.68           N  
ATOM   2061  CA  ALA B 118      -3.459  14.597  15.637  1.00 27.89           C  
ATOM   2062  C   ALA B 118      -3.219  15.029  17.065  1.00 29.59           C  
ATOM   2063  O   ALA B 118      -3.801  14.464  18.005  1.00 28.51           O  
ATOM   2064  CB  ALA B 118      -4.736  15.180  15.122  1.00 26.50           C  
ATOM   2065  N   LEU B 119      -2.377  16.033  17.226  1.00 31.35           N  
ATOM   2066  CA  LEU B 119      -2.024  16.558  18.559  1.00 33.07           C  
ATOM   2067  C   LEU B 119      -2.252  18.051  18.634  1.00 31.82           C  
ATOM   2068  O   LEU B 119      -2.179  18.748  17.640  1.00 25.29           O  
ATOM   2069  CB  LEU B 119      -0.554  16.253  18.880  1.00 33.64           C  
ATOM   2070  CG  LEU B 119      -0.288  14.762  18.788  1.00 34.01           C  
ATOM   2071  CD1 LEU B 119       0.219  14.486  17.385  1.00 35.08           C  
ATOM   2072  CD2 LEU B 119       0.694  14.282  19.782  1.00 32.58           C  
ATOM   2073  N   CYS B 120      -2.567  18.545  19.817  1.00 32.47           N  
ATOM   2074  CA  CYS B 120      -2.653  19.997  20.006  1.00 31.47           C  
ATOM   2075  C   CYS B 120      -1.624  20.434  21.063  1.00 29.71           C  
ATOM   2076  O   CYS B 120      -1.680  19.986  22.208  1.00 28.16           O  
ATOM   2077  CB  CYS B 120      -4.066  20.362  20.408  1.00 31.34           C  
ATOM   2078  SG  CYS B 120      -4.278  22.103  20.605  1.00 35.35           S  
ATOM   2079  N   PHE B 121      -0.644  21.237  20.633  1.00 27.49           N  
ATOM   2080  CA  PHE B 121       0.349  21.839  21.524  1.00 28.01           C  
ATOM   2081  C   PHE B 121      -0.045  23.253  21.923  1.00 28.14           C  
ATOM   2082  O   PHE B 121      -0.371  24.053  21.072  1.00 27.99           O  
ATOM   2083  CB  PHE B 121       1.695  21.923  20.817  1.00 24.78           C  
ATOM   2084  CG  PHE B 121       2.750  22.731  21.572  1.00 21.70           C  
ATOM   2085  CD1 PHE B 121       3.439  22.183  22.652  1.00 29.68           C  
ATOM   2086  CD2 PHE B 121       3.121  23.996  21.126  1.00 26.88           C  
ATOM   2087  CE1 PHE B 121       4.442  22.914  23.317  1.00 21.22           C  
ATOM   2088  CE2 PHE B 121       4.139  24.716  21.751  1.00 24.30           C  
ATOM   2089  CZ  PHE B 121       4.807  24.190  22.846  1.00 23.92           C  
ATOM   2090  N   THR B 122       0.051  23.560  23.211  1.00 28.41           N  
ATOM   2091  CA  THR B 122      -0.234  24.896  23.754  1.00 28.02           C  
ATOM   2092  C   THR B 122       1.038  25.413  24.384  1.00 28.20           C  
ATOM   2093  O   THR B 122       1.527  24.790  25.315  1.00 23.14           O  
ATOM   2094  CB  THR B 122      -1.343  24.807  24.846  1.00 28.10           C  
ATOM   2095  OG1 THR B 122      -2.535  24.300  24.244  1.00 33.04           O  
ATOM   2096  CG2 THR B 122      -1.630  26.168  25.514  1.00 30.69           C  
ATOM   2097  N   ALA B 123       1.604  26.507  23.836  1.00 25.11           N  
ATOM   2098  CA  ALA B 123       2.876  27.079  24.295  1.00 26.67           C  
ATOM   2099  C   ALA B 123       2.731  27.928  25.548  1.00 29.18           C  
ATOM   2100  O   ALA B 123       1.824  28.733  25.648  1.00 33.01           O  
ATOM   2101  CB  ALA B 123       3.549  27.929  23.152  1.00 24.57           C  
ATOM   2102  N   GLU B 124       3.637  27.745  26.504  1.00 32.85           N  
ATOM   2103  CA  GLU B 124       3.691  28.576  27.716  1.00 35.26           C  
ATOM   2104  C   GLU B 124       4.737  29.684  27.555  1.00 33.19           C  
ATOM   2105  O   GLU B 124       4.497  30.832  27.924  1.00 30.11           O  
ATOM   2106  CB  GLU B 124       4.040  27.730  28.929  1.00 34.87           C  
ATOM   2107  CG  GLU B 124       2.945  26.696  29.345  1.00 41.94           C  
ATOM   2108  CD  GLU B 124       3.519  25.524  30.152  1.00 44.00           C  
ATOM   2109  OE1 GLU B 124       4.556  25.721  30.841  1.00 51.80           O  
ATOM   2110  OE2 GLU B 124       2.950  24.407  30.072  1.00 42.60           O  
ATOM   2111  N   TRP B 125       5.908  29.334  27.019  1.00 33.64           N  
ATOM   2112  CA  TRP B 125       6.937  30.346  26.750  1.00 31.67           C  
ATOM   2113  C   TRP B 125       7.851  29.951  25.612  1.00 31.78           C  
ATOM   2114  O   TRP B 125       7.753  28.858  25.067  1.00 30.27           O  
ATOM   2115  CB  TRP B 125       7.758  30.650  28.018  1.00 34.05           C  
ATOM   2116  CG  TRP B 125       8.460  29.489  28.611  1.00 35.25           C  
ATOM   2117  CD1 TRP B 125       7.932  28.575  29.463  1.00 31.56           C  
ATOM   2118  CD2 TRP B 125       9.840  29.126  28.428  1.00 32.43           C  
ATOM   2119  NE1 TRP B 125       8.893  27.646  29.810  1.00 35.04           N  
ATOM   2120  CE2 TRP B 125      10.073  27.969  29.196  1.00 30.10           C  
ATOM   2121  CE3 TRP B 125      10.894  29.664  27.687  1.00 33.72           C  
ATOM   2122  CZ2 TRP B 125      11.322  27.334  29.242  1.00 27.68           C  
ATOM   2123  CZ3 TRP B 125      12.124  29.039  27.737  1.00 36.29           C  
ATOM   2124  CH2 TRP B 125      12.328  27.883  28.507  1.00 35.41           C  
ATOM   2125  N   GLY B 126       8.743  30.848  25.261  1.00 29.69           N  
ATOM   2126  CA  GLY B 126       9.708  30.529  24.251  1.00 30.76           C  
ATOM   2127  C   GLY B 126      10.991  31.278  24.363  1.00 32.79           C  
ATOM   2128  O   GLY B 126      11.199  32.108  25.253  1.00 31.57           O  
ATOM   2129  N   ASN B 127      11.838  30.957  23.395  1.00 32.63           N  
ATOM   2130  CA  ASN B 127      13.144  31.450  23.299  1.00 32.85           C  
ATOM   2131  C   ASN B 127      13.454  31.646  21.838  1.00 31.35           C  
ATOM   2132  O   ASN B 127      13.328  30.721  21.055  1.00 33.59           O  
ATOM   2133  CB  ASN B 127      14.071  30.418  23.887  1.00 34.58           C  
ATOM   2134  CG  ASN B 127      15.224  31.033  24.470  1.00 42.66           C  
ATOM   2135  OD1 ASN B 127      16.320  30.914  23.952  1.00 60.17           O  
ATOM   2136  ND2 ASN B 127      14.993  31.831  25.498  1.00 49.82           N  
ATOM   2137  N   TYR B 128      13.794  32.858  21.448  1.00 32.68           N  
ATOM   2138  CA  TYR B 128      14.222  33.126  20.090  1.00 35.03           C  
ATOM   2139  C   TYR B 128      15.727  33.204  20.100  1.00 36.93           C  
ATOM   2140  O   TYR B 128      16.284  34.027  20.835  1.00 35.26           O  
ATOM   2141  CB  TYR B 128      13.634  34.453  19.624  1.00 38.93           C  
ATOM   2142  CG  TYR B 128      14.049  34.890  18.258  1.00 46.00           C  
ATOM   2143  CD1 TYR B 128      13.497  34.297  17.125  1.00 50.42           C  
ATOM   2144  CD2 TYR B 128      14.977  35.914  18.084  1.00 50.51           C  
ATOM   2145  CE1 TYR B 128      13.866  34.704  15.848  1.00 54.63           C  
ATOM   2146  CE2 TYR B 128      15.352  36.335  16.811  1.00 53.38           C  
ATOM   2147  CZ  TYR B 128      14.786  35.725  15.690  1.00 54.81           C  
ATOM   2148  OH  TYR B 128      15.146  36.129  14.408  1.00 56.51           O  
ATOM   2149  N   TYR B 129      16.396  32.369  19.299  1.00 36.45           N  
ATOM   2150  CA  TYR B 129      17.858  32.366  19.249  1.00 38.01           C  
ATOM   2151  C   TYR B 129      18.283  33.017  17.949  1.00 38.30           C  
ATOM   2152  O   TYR B 129      17.701  32.737  16.912  1.00 38.07           O  
ATOM   2153  CB  TYR B 129      18.460  30.961  19.284  1.00 40.18           C  
ATOM   2154  CG  TYR B 129      18.077  30.053  20.443  1.00 47.81           C  
ATOM   2155  CD1 TYR B 129      16.918  29.249  20.383  1.00 52.24           C  
ATOM   2156  CD2 TYR B 129      18.904  29.923  21.566  1.00 54.04           C  
ATOM   2157  CE1 TYR B 129      16.569  28.377  21.433  1.00 49.74           C  
ATOM   2158  CE2 TYR B 129      18.563  29.041  22.638  1.00 52.08           C  
ATOM   2159  CZ  TYR B 129      17.394  28.271  22.554  1.00 54.30           C  
ATOM   2160  OH  TYR B 129      17.040  27.401  23.588  1.00 58.24           O  
ATOM   2161  N   ARG B 130      19.284  33.893  18.011  1.00 39.09           N  
ATOM   2162  CA  ARG B 130      19.797  34.575  16.822  1.00 42.23           C  
ATOM   2163  C   ARG B 130      21.004  35.411  17.228  1.00 44.62           C  
ATOM   2164  O   ARG B 130      21.036  35.967  18.330  1.00 45.79           O  
ATOM   2165  CB  ARG B 130      18.722  35.438  16.140  1.00 41.00           C  
ATOM   2166  CG  ARG B 130      19.217  36.166  14.885  1.00 48.51           C  
ATOM   2167  CD  ARG B 130      18.126  36.327  13.807  1.00 55.09           C  
ATOM   2168  NE  ARG B 130      18.551  37.079  12.613  1.00 57.16           N  
ATOM   2169  CZ  ARG B 130      19.574  36.753  11.806  1.00 61.76           C  
ATOM   2170  NH1 ARG B 130      20.347  35.683  12.036  1.00 60.43           N  
ATOM   2171  NH2 ARG B 130      19.849  37.524  10.754  1.00 61.10           N  
ATOM   2172  N   HIS B 131      21.987  35.476  16.335  1.00 46.87           N  
ATOM   2173  CA  HIS B 131      23.289  36.124  16.589  1.00 48.51           C  
ATOM   2174  C   HIS B 131      23.936  35.609  17.892  1.00 50.20           C  
ATOM   2175  O   HIS B 131      24.564  36.366  18.640  1.00 49.29           O  
ATOM   2176  CB  HIS B 131      23.158  37.652  16.616  1.00 48.13           C  
ATOM   2177  CG  HIS B 131      22.514  38.243  15.395  1.00 44.82           C  
ATOM   2178  ND1 HIS B 131      21.349  38.981  15.452  1.00 48.48           N  
ATOM   2179  CD2 HIS B 131      22.886  38.232  14.092  1.00 50.56           C  
ATOM   2180  CE1 HIS B 131      21.029  39.401  14.239  1.00 41.91           C  
ATOM   2181  NE2 HIS B 131      21.948  38.964  13.396  1.00 50.70           N  
ATOM   2182  N   LEU B 132      23.773  34.314  18.149  1.00 50.04           N  
ATOM   2183  CA  LEU B 132      24.371  33.647  19.302  1.00 51.32           C  
ATOM   2184  C   LEU B 132      23.867  34.212  20.616  1.00 48.95           C  
ATOM   2185  O   LEU B 132      24.512  34.042  21.655  1.00 51.36           O  
ATOM   2186  CB  LEU B 132      25.910  33.691  19.238  1.00 54.25           C  
ATOM   2187  CG  LEU B 132      26.590  32.372  19.657  1.00 61.02           C  
ATOM   2188  CD1 LEU B 132      26.165  31.181  18.739  1.00 59.51           C  
ATOM   2189  CD2 LEU B 132      28.133  32.515  19.721  1.00 53.72           C  
ATOM   2190  N   LYS B 133      22.690  34.841  20.565  1.00 43.10           N  
ATOM   2191  CA  LYS B 133      21.990  35.297  21.752  1.00 41.91           C  
ATOM   2192  C   LYS B 133      20.585  34.751  21.716  1.00 40.61           C  
ATOM   2193  O   LYS B 133      20.099  34.288  20.690  1.00 36.37           O  
ATOM   2194  CB  LYS B 133      21.862  36.818  21.818  1.00 41.83           C  
ATOM   2195  CG  LYS B 133      22.805  37.556  20.939  1.00 43.96           C  
ATOM   2196  CD  LYS B 133      22.690  39.020  21.141  1.00 38.85           C  
ATOM   2197  CE  LYS B 133      23.820  39.715  20.434  1.00 30.59           C  
ATOM   2198  NZ  LYS B 133      24.070  40.920  21.186  1.00 24.64           N  
ATOM   2199  N   ASN B 134      19.917  34.855  22.844  1.00 40.98           N  
ATOM   2200  CA  ASN B 134      18.534  34.544  22.858  1.00 42.26           C  
ATOM   2201  C   ASN B 134      17.742  35.459  23.758  1.00 40.52           C  
ATOM   2202  O   ASN B 134      18.270  36.039  24.698  1.00 41.96           O  
ATOM   2203  CB  ASN B 134      18.328  33.061  23.164  1.00 45.07           C  
ATOM   2204  CG  ASN B 134      18.785  32.673  24.531  1.00 47.35           C  
ATOM   2205  OD1 ASN B 134      18.093  32.922  25.509  1.00 53.35           O  
ATOM   2206  ND2 ASN B 134      19.942  32.034  24.611  1.00 50.98           N  
ATOM   2207  N   ILE B 135      16.480  35.618  23.382  1.00 37.18           N  
ATOM   2208  CA  ILE B 135      15.485  36.369  24.101  1.00 36.83           C  
ATOM   2209  C   ILE B 135      14.431  35.383  24.500  1.00 35.96           C  
ATOM   2210  O   ILE B 135      13.871  34.724  23.643  1.00 34.73           O  
ATOM   2211  CB  ILE B 135      14.829  37.436  23.172  1.00 36.93           C  
ATOM   2212  CG1 ILE B 135      15.804  38.583  22.914  1.00 41.59           C  
ATOM   2213  CG2 ILE B 135      13.529  37.968  23.792  1.00 36.87           C  
ATOM   2214  CD1 ILE B 135      15.885  39.035  21.496  1.00 34.33           C  
ATOM   2215  N   THR B 136      14.182  35.280  25.806  1.00 36.93           N  
ATOM   2216  CA  THR B 136      13.169  34.433  26.366  1.00 36.84           C  
ATOM   2217  C   THR B 136      11.960  35.282  26.641  1.00 36.67           C  
ATOM   2218  O   THR B 136      12.094  36.374  27.189  1.00 36.53           O  
ATOM   2219  CB  THR B 136      13.603  33.822  27.732  1.00 37.33           C  
ATOM   2220  OG1 THR B 136      14.822  33.106  27.584  1.00 41.54           O  
ATOM   2221  CG2 THR B 136      12.572  32.851  28.225  1.00 37.01           C  
ATOM   2222  N   PHE B 137      10.778  34.761  26.327  1.00 36.16           N  
ATOM   2223  CA  PHE B 137       9.521  35.482  26.579  1.00 36.10           C  
ATOM   2224  C   PHE B 137       8.442  34.534  27.002  1.00 34.24           C  
ATOM   2225  O   PHE B 137       8.460  33.374  26.598  1.00 34.55           O  
ATOM   2226  CB  PHE B 137       9.084  36.180  25.297  1.00 34.54           C  
ATOM   2227  CG  PHE B 137       9.033  35.265  24.101  1.00 33.04           C  
ATOM   2228  CD1 PHE B 137      10.175  35.034  23.329  1.00 33.73           C  
ATOM   2229  CD2 PHE B 137       7.847  34.654  23.734  1.00 33.69           C  
ATOM   2230  CE1 PHE B 137      10.123  34.187  22.228  1.00 36.46           C  
ATOM   2231  CE2 PHE B 137       7.786  33.811  22.643  1.00 40.48           C  
ATOM   2232  CZ  PHE B 137       8.922  33.575  21.876  1.00 33.64           C  
ATOM   2233  N   LYS B 138       7.485  35.020  27.791  1.00 35.68           N  
ATOM   2234  CA  LYS B 138       6.251  34.286  28.058  1.00 38.67           C  
ATOM   2235  C   LYS B 138       5.244  34.611  26.970  1.00 38.04           C  
ATOM   2236  O   LYS B 138       5.180  35.745  26.493  1.00 39.20           O  
ATOM   2237  CB  LYS B 138       5.649  34.651  29.414  1.00 38.65           C  
ATOM   2238  CG  LYS B 138       6.509  34.345  30.624  1.00 41.17           C  
ATOM   2239  CD  LYS B 138       5.686  34.600  31.908  1.00 47.33           C  
ATOM   2240  CE  LYS B 138       6.575  34.636  33.175  1.00 58.70           C  
ATOM   2241  NZ  LYS B 138       5.790  34.756  34.456  1.00 54.43           N  
ATOM   2242  N   ILE B 139       4.451  33.620  26.570  1.00 39.77           N  
ATOM   2243  CA  ILE B 139       3.506  33.802  25.472  1.00 42.42           C  
ATOM   2244  C   ILE B 139       2.546  34.935  25.790  1.00 44.91           C  
ATOM   2245  O   ILE B 139       2.323  35.802  24.958  1.00 44.18           O  
ATOM   2246  CB  ILE B 139       2.710  32.504  25.166  1.00 43.41           C  
ATOM   2247  CG1 ILE B 139       3.615  31.502  24.493  1.00 44.63           C  
ATOM   2248  CG2 ILE B 139       1.564  32.757  24.188  1.00 45.76           C  
ATOM   2249  CD1 ILE B 139       4.168  32.011  23.219  1.00 36.54           C  
ATOM   2250  N   ASP B 140       2.017  34.935  27.007  1.00 48.69           N  
ATOM   2251  CA  ASP B 140       1.076  35.966  27.445  1.00 54.88           C  
ATOM   2252  C   ASP B 140       1.643  37.401  27.398  1.00 56.21           C  
ATOM   2253  O   ASP B 140       0.858  38.353  27.373  1.00 58.75           O  
ATOM   2254  CB  ASP B 140       0.511  35.630  28.844  1.00 56.20           C  
ATOM   2255  CG  ASP B 140       1.391  36.125  29.981  1.00 63.06           C  
ATOM   2256  OD1 ASP B 140       1.264  37.309  30.361  1.00 77.69           O  
ATOM   2257  OD2 ASP B 140       2.173  35.320  30.533  1.00 72.41           O  
ATOM   2258  N   GLU B 141       2.971  37.548  27.379  1.00 55.62           N  
ATOM   2259  CA  GLU B 141       3.618  38.855  27.248  1.00 58.27           C  
ATOM   2260  C   GLU B 141       3.688  39.296  25.784  1.00 59.84           C  
ATOM   2261  O   GLU B 141       3.359  40.432  25.448  1.00 60.29           O  
ATOM   2262  CB  GLU B 141       5.041  38.833  27.836  1.00 58.82           C  
ATOM   2263  CG  GLU B 141       5.139  38.594  29.356  1.00 60.52           C  
ATOM   2264  CD  GLU B 141       6.589  38.337  29.868  1.00 61.55           C  
ATOM   2265  OE1 GLU B 141       7.544  38.091  29.067  1.00 59.39           O  
ATOM   2266  OE2 GLU B 141       6.754  38.367  31.111  1.00 70.76           O  
ATOM   2267  N   ILE B 142       4.115  38.390  24.909  1.00 63.16           N  
ATOM   2268  CA  ILE B 142       4.345  38.705  23.491  1.00 65.03           C  
ATOM   2269  C   ILE B 142       3.039  39.037  22.734  1.00 66.84           C  
ATOM   2270  O   ILE B 142       3.062  39.268  21.532  1.00 66.68           O  
ATOM   2271  CB  ILE B 142       5.141  37.547  22.775  1.00 64.53           C  
ATOM   2272  CG1 ILE B 142       5.925  38.082  21.559  1.00 69.55           C  
ATOM   2273  CG2 ILE B 142       4.207  36.397  22.396  1.00 62.78           C  
ATOM   2274  CD1 ILE B 142       7.096  37.180  21.051  1.00 64.73           C  
ATOM   2275  N   TYR B 143       1.912  39.060  23.448  1.00 69.56           N  
ATOM   2276  CA  TYR B 143       0.616  39.454  22.892  1.00 70.76           C  
ATOM   2277  C   TYR B 143      -0.100  40.442  23.839  1.00 70.73           C  
ATOM   2278  O   TYR B 143       0.076  41.665  23.751  1.00 69.87           O  
ATOM   2279  CB  TYR B 143      -0.261  38.210  22.691  1.00 71.01           C  
ATOM   2280  CG  TYR B 143       0.181  37.259  21.584  1.00 72.42           C  
ATOM   2281  CD1 TYR B 143      -0.142  37.512  20.248  1.00 74.97           C  
ATOM   2282  CD2 TYR B 143       0.891  36.091  21.871  1.00 72.90           C  
ATOM   2283  CE1 TYR B 143       0.242  36.634  19.227  1.00 73.11           C  
ATOM   2284  CE2 TYR B 143       1.283  35.207  20.848  1.00 71.37           C  
ATOM   2285  CZ  TYR B 143       0.953  35.487  19.534  1.00 69.85           C  
ATOM   2286  OH  TYR B 143       1.329  34.640  18.520  1.00 70.37           O  
TER    2287      TYR B 143                                                      
END
MOLECULE T0497.pdb
ATOM      5  N   MET     1      13.726  45.186  17.326  1.00 86.05           N  
ATOM      6  CA  MET     1      13.854  43.790  16.854  1.00 85.86           C  
ATOM      7  C   MET     1      13.936  42.784  18.030  1.00 83.85           C  
ATOM      8  O   MET     1      13.538  41.620  17.875  1.00 83.45           O  
ATOM      9  CB  MET     1      15.056  43.633  15.890  1.00 86.69           C  
ATOM     10  CG  MET     1      16.377  43.182  16.523  1.00 88.68           C  
ATOM     11  SD  MET     1      17.988  43.731  15.614  0.75 92.01          SE  
ATOM     12  CE  MET     1      19.110  42.057  15.901  1.00 88.06           C  
ATOM     13  N   ALA     2      14.466  43.250  19.173  1.00 81.16           N  
ATOM     14  CA  ALA     2      14.590  42.453  20.391  1.00 79.87           C  
ATOM     15  C   ALA     2      13.345  42.445  21.296  1.00 78.34           C  
ATOM     16  O   ALA     2      13.382  41.748  22.306  1.00 77.90           O  
ATOM     17  CB  ALA     2      15.820  42.896  21.195  1.00 79.19           C  
ATOM     18  N   ASP     3      12.264  43.181  20.962  1.00 78.03           N  
ATOM     19  CA  ASP     3      11.048  43.193  21.798  0.50 77.68           C  
ATOM     21  C   ASP     3      10.259  41.889  21.613  1.00 78.01           C  
ATOM     22  O   ASP     3      10.343  41.273  20.544  1.00 77.66           O  
ATOM     23  CB  ASP     3      10.174  44.413  21.482  0.50 76.52           C  
ATOM     25  CG  ASP     3      10.832  45.730  21.887  0.50 70.99           C  
ATOM     27  OD1 ASP     3      11.319  45.846  23.031  0.50 59.83           O  
ATOM     29  OD2 ASP     3      10.834  46.662  21.065  0.50 63.66           O  
ATOM     31  N   PRO     4       9.492  41.452  22.649  1.00 78.39           N  
ATOM     32  CA  PRO     4       8.737  40.183  22.525  1.00 78.04           C  
ATOM     33  C   PRO     4       7.714  40.059  21.383  1.00 77.52           C  
ATOM     34  O   PRO     4       7.550  38.958  20.872  1.00 78.02           O  
ATOM     35  CB  PRO     4       8.035  40.049  23.895  1.00 77.81           C  
ATOM     36  CG  PRO     4       7.965  41.401  24.410  1.00 79.56           C  
ATOM     37  CD  PRO     4       9.243  42.058  23.973  1.00 78.48           C  
ATOM     38  N   LYS     5       7.054  41.151  20.996  1.00 77.64           N  
ATOM     39  CA  LYS     5       6.046  41.131  19.915  1.00 76.64           C  
ATOM     40  C   LYS     5       6.667  40.855  18.541  1.00 75.44           C  
ATOM     41  O   LYS     5       6.147  40.032  17.799  1.00 74.56           O  
ATOM     42  CB  LYS     5       5.236  42.433  19.904  1.00 77.43           C  
ATOM     43  CG  LYS     5       4.157  42.589  18.809  1.00 78.67           C  
ATOM     44  CD  LYS     5       3.166  41.414  18.745  1.00 83.74           C  
ATOM     45  CE  LYS     5       1.946  41.759  17.884  1.00 85.48           C  
ATOM     46  NZ  LYS     5       2.287  42.297  16.531  1.00 87.86           N  
ATOM     47  N   GLU     6       7.765  41.537  18.211  1.00 74.70           N  
ATOM     48  CA  GLU     6       8.451  41.325  16.925  1.00 74.09           C  
ATOM     49  C   GLU     6       9.058  39.927  16.840  1.00 72.42           C  
ATOM     50  O   GLU     6       9.009  39.306  15.782  1.00 71.12           O  
ATOM     51  CB  GLU     6       9.522  42.390  16.642  1.00 72.75           C  
ATOM     52  CG  GLU     6       8.964  43.783  16.364  1.00 74.88           C  
ATOM     53  N   LEU     7       9.619  39.446  17.952  1.00 71.95           N  
ATOM     54  CA  LEU     7      10.216  38.109  18.022  1.00 71.61           C  
ATOM     55  C   LEU     7       9.159  37.010  17.931  1.00 70.57           C  
ATOM     56  O   LEU     7       9.353  36.020  17.231  1.00 70.00           O  
ATOM     57  CB  LEU     7      11.053  37.939  19.297  1.00 72.48           C  
ATOM     58  CG  LEU     7      12.379  38.701  19.340  1.00 74.29           C  
ATOM     59  CD1 LEU     7      12.939  38.740  20.750  1.00 73.61           C  
ATOM     60  CD2 LEU     7      13.383  38.093  18.346  1.00 73.78           C  
ATOM     61  N   GLN     8       8.053  37.187  18.645  1.00 70.21           N  
ATOM     62  CA  GLN     8       6.950  36.242  18.577  1.00 70.98           C  
ATOM     63  C   GLN     8       6.400  36.178  17.129  1.00 70.04           C  
ATOM     64  O   GLN     8       6.181  35.094  16.610  1.00 69.96           O  
ATOM     65  CB  GLN     8       5.864  36.595  19.612  1.00 70.88           C  
ATOM     66  CG  GLN     8       4.709  35.596  19.639  1.00 74.74           C  
ATOM     67  CD  GLN     8       3.784  35.686  20.860  1.00 74.95           C  
ATOM     68  OE1 GLN     8       2.872  34.845  21.009  1.00 81.07           O  
ATOM     69  NE2 GLN     8       3.997  36.686  21.731  1.00 75.50           N  
ATOM     70  N   ASP     9       6.209  37.341  16.497  1.00 69.03           N  
ATOM     71  CA  ASP     9       5.728  37.442  15.104  1.00 68.39           C  
ATOM     72  C   ASP     9       6.646  36.715  14.117  1.00 67.45           C  
ATOM     73  O   ASP     9       6.150  35.967  13.266  1.00 68.40           O  
ATOM     74  CB  ASP     9       5.538  38.907  14.668  1.00 67.15           C  
ATOM     75  CG  ASP     9       4.327  39.587  15.326  1.00 68.12           C  
ATOM     76  OD1 ASP     9       3.360  38.916  15.752  1.00 66.97           O  
ATOM     77  OD2 ASP     9       4.336  40.835  15.391  1.00 72.15           O  
ATOM     78  N   LYS    10       7.958  36.932  14.238  1.00 65.30           N  
ATOM     79  CA  LYS    10       8.949  36.236  13.400  1.00 66.18           C  
ATOM     80  C   LYS    10       8.919  34.726  13.623  1.00 65.37           C  
ATOM     81  O   LYS    10       9.059  33.953  12.672  1.00 64.60           O  
ATOM     82  CB  LYS    10      10.379  36.717  13.676  1.00 66.97           C  
ATOM     83  CG  LYS    10      10.726  38.076  13.126  1.00 68.25           C  
ATOM     84  CD  LYS    10      12.172  38.403  13.489  1.00 67.43           C  
ATOM     85  CE  LYS    10      12.640  39.737  12.936  1.00 69.89           C  
ATOM     86  NZ  LYS    10      14.068  39.991  13.369  1.00 70.59           N  
ATOM     87  N   PHE    11       8.778  34.325  14.890  1.00 64.73           N  
ATOM     88  CA  PHE    11       8.679  32.908  15.248  1.00 64.13           C  
ATOM     89  C   PHE    11       7.501  32.203  14.554  1.00 62.79           C  
ATOM     90  O   PHE    11       7.703  31.224  13.846  1.00 62.00           O  
ATOM     91  CB  PHE    11       8.606  32.715  16.770  1.00 64.85           C  
ATOM     92  CG  PHE    11       8.128  31.361  17.169  1.00 65.60           C  
ATOM     93  CD1 PHE    11       8.969  30.261  17.035  1.00 65.90           C  
ATOM     94  CD2 PHE    11       6.821  31.171  17.631  1.00 66.31           C  
ATOM     95  CE1 PHE    11       8.527  28.974  17.367  1.00 65.48           C  
ATOM     96  CE2 PHE    11       6.373  29.897  17.971  1.00 65.66           C  
ATOM     97  CZ  PHE    11       7.240  28.793  17.849  1.00 64.98           C  
ATOM     98  N   TRP    12       6.290  32.699  14.786  1.00 62.76           N  
ATOM     99  CA  TRP    12       5.095  32.138  14.164  1.00 64.24           C  
ATOM    100  C   TRP    12       5.156  32.130  12.618  1.00 63.97           C  
ATOM    101  O   TRP    12       4.725  31.157  12.000  1.00 63.92           O  
ATOM    102  CB  TRP    12       3.829  32.863  14.604  1.00 65.03           C  
ATOM    103  CG  TRP    12       3.457  32.681  16.017  1.00 63.68           C  
ATOM    104  CD1 TRP    12       3.341  33.660  16.952  1.00 64.00           C  
ATOM    105  CD2 TRP    12       3.146  31.449  16.675  1.00 67.38           C  
ATOM    106  NE1 TRP    12       2.964  33.122  18.152  1.00 66.48           N  
ATOM    107  CE2 TRP    12       2.850  31.764  18.024  1.00 65.04           C  
ATOM    108  CE3 TRP    12       3.082  30.107  16.261  1.00 64.03           C  
ATOM    109  CZ2 TRP    12       2.478  30.790  18.967  1.00 66.99           C  
ATOM    110  CZ3 TRP    12       2.728  29.129  17.209  1.00 65.28           C  
ATOM    111  CH2 TRP    12       2.427  29.476  18.541  1.00 65.62           C  
ATOM    112  N   LYS    13       5.716  33.185  12.031  1.00 63.71           N  
ATOM    113  CA  LYS    13       5.891  33.272  10.576  1.00 65.47           C  
ATOM    114  C   LYS    13       6.833  32.171  10.061  1.00 64.51           C  
ATOM    115  O   LYS    13       6.554  31.527   9.035  1.00 63.48           O  
ATOM    116  CB  LYS    13       6.437  34.649  10.179  1.00 65.83           C  
ATOM    117  CG  LYS    13       6.467  34.958   8.674  1.00 65.60           C  
ATOM    118  CD  LYS    13       7.293  36.239   8.447  1.00 67.39           C  
ATOM    119  CE  LYS    13       7.540  36.582   6.978  1.00 72.72           C  
ATOM    120  NZ  LYS    13       6.403  37.268   6.291  1.00 77.16           N  
ATOM    121  N   ALA    14       7.934  31.957  10.781  1.00 63.23           N  
ATOM    122  CA  ALA    14       8.915  30.938  10.392  1.00 62.31           C  
ATOM    123  C   ALA    14       8.343  29.550  10.645  1.00 61.62           C  
ATOM    124  O   ALA    14       8.500  28.680   9.820  1.00 61.28           O  
ATOM    125  CB  ALA    14      10.220  31.124  11.128  1.00 62.06           C  
ATOM    126  N   LEU    15       7.661  29.360  11.774  1.00 63.05           N  
ATOM    127  CA  LEU    15       7.090  28.062  12.111  1.00 63.38           C  
ATOM    128  C   LEU    15       6.057  27.653  11.096  1.00 63.95           C  
ATOM    129  O   LEU    15       6.019  26.491  10.720  1.00 62.84           O  
ATOM    130  CB  LEU    15       6.436  28.052  13.493  1.00 63.75           C  
ATOM    131  CG  LEU    15       5.826  26.702  13.961  1.00 63.96           C  
ATOM    132  CD1 LEU    15       6.941  25.682  14.102  1.00 62.00           C  
ATOM    133  CD2 LEU    15       5.036  26.839  15.266  1.00 62.15           C  
ATOM    134  N   LYS    16       5.220  28.605  10.672  1.00 65.58           N  
ATOM    135  CA  LYS    16       4.143  28.292   9.740  1.00 66.91           C  
ATOM    136  C   LYS    16       4.657  27.898   8.345  1.00 66.08           C  
ATOM    137  O   LYS    16       4.116  26.984   7.737  1.00 66.49           O  
ATOM    138  CB  LYS    16       3.082  29.395   9.676  1.00 67.00           C  
ATOM    139  CG  LYS    16       1.879  28.927   8.881  1.00 69.94           C  
ATOM    140  CD  LYS    16       0.664  29.755   9.027  1.00 69.31           C  
ATOM    141  CE  LYS    16      -0.516  29.056   8.326  1.00 69.26           C  
ATOM    142  NZ  LYS    16      -1.008  27.907   9.104  1.00 65.56           N  
ATOM    143  N   SER    17       5.696  28.567   7.854  1.00 66.10           N  
ATOM    144  CA  SER    17       6.248  28.227   6.551  1.00 65.35           C  
ATOM    145  C   SER    17       7.270  27.069   6.578  1.00 65.04           C  
ATOM    146  O   SER    17       7.323  26.315   5.615  1.00 65.07           O  
ATOM    147  CB  SER    17       6.853  29.447   5.884  1.00 65.18           C  
ATOM    148  OG  SER    17       7.974  29.877   6.577  1.00 71.43           O  
ATOM    149  N   ASP    18       8.051  26.927   7.653  1.00 63.43           N  
ATOM    150  CA  ASP    18       9.121  25.920   7.718  1.00 63.53           C  
ATOM    151  C   ASP    18       8.739  24.638   8.462  1.00 63.23           C  
ATOM    152  O   ASP    18       9.279  23.584   8.157  1.00 62.99           O  
ATOM    153  CB  ASP    18      10.405  26.562   8.246  1.00 63.75           C  
ATOM    154  CG  ASP    18      10.870  27.725   7.383  1.00 61.31           C  
ATOM    155  OD1 ASP    18      10.465  27.840   6.209  1.00 63.82           O  
ATOM    156  OD2 ASP    18      11.684  28.527   7.866  1.00 66.28           O  
ATOM    157  N   ARG    19       7.866  24.742   9.462  1.00 63.86           N  
ATOM    158  CA  ARG    19       7.186  23.580  10.105  1.00 64.11           C  
ATOM    159  C   ARG    19       7.929  22.557  10.969  1.00 62.46           C  
ATOM    160  O   ARG    19       7.410  22.169  12.013  1.00 61.74           O  
ATOM    161  CB  ARG    19       6.388  22.816   9.034  1.00 63.62           C  
ATOM    162  CG  ARG    19       5.393  23.691   8.272  1.00 67.91           C  
ATOM    163  CD  ARG    19       4.563  22.875   7.257  1.00 71.16           C  
ATOM    164  NE  ARG    19       3.187  23.389   7.168  1.00 87.12           N  
ATOM    165  CZ  ARG    19       2.155  22.781   6.554  1.00 93.44           C  
ATOM    166  NH1 ARG    19       2.294  21.602   5.906  1.00 94.97           N  
ATOM    167  NH2 ARG    19       0.951  23.374   6.579  1.00 94.24           N  
ATOM    168  N   THR    20       9.114  22.110  10.559  1.00 62.82           N  
ATOM    169  CA  THR    20       9.813  21.035  11.278  1.00 62.12           C  
ATOM    170  C   THR    20      10.289  21.449  12.675  1.00 62.25           C  
ATOM    171  O   THR    20      10.986  22.453  12.837  1.00 62.77           O  
ATOM    172  CB  THR    20      10.976  20.473  10.473  1.00 61.39           C  
ATOM    173  OG1 THR    20      10.525  20.203   9.142  1.00 57.65           O  
ATOM    174  CG2 THR    20      11.518  19.168  11.113  1.00 60.69           C  
ATOM    175  N   VAL    21       9.827  20.703  13.672  1.00 61.75           N  
ATOM    176  CA  VAL    21      10.223  20.849  15.081  1.00 61.41           C  
ATOM    177  C   VAL    21      10.738  19.484  15.562  1.00 60.57           C  
ATOM    178  O   VAL    21      10.059  18.480  15.358  1.00 60.04           O  
ATOM    179  CB  VAL    21       9.033  21.273  15.979  1.00 60.48           C  
ATOM    180  CG1 VAL    21       9.498  21.463  17.457  1.00 54.74           C  
ATOM    181  CG2 VAL    21       8.372  22.566  15.416  1.00 58.54           C  
ATOM    182  N   MET    22      11.933  19.486  16.162  1.00 62.27           N  
ATOM    183  CA  MET    22      12.554  18.294  16.762  0.50 63.02           C  
ATOM    185  C   MET    22      11.975  18.227  18.188  1.00 63.56           C  
ATOM    186  O   MET    22      12.339  19.014  19.049  1.00 61.75           O  
ATOM    187  CB  MET    22      14.081  18.448  16.778  0.50 63.15           C  
ATOM    189  CG  MET    22      14.878  17.312  17.398  0.50 62.14           C  
ATOM    191  SD  MET    22      15.028  15.746  16.284  0.38 65.65          SE  
ATOM    193  CE  MET    22      16.508  16.277  15.168  0.50 63.37           C  
ATOM    195  N   LEU    23      11.057  17.291  18.427  1.00 65.21           N  
ATOM    196  CA  LEU    23      10.365  17.155  19.718  1.00 65.88           C  
ATOM    197  C   LEU    23      10.875  16.040  20.578  1.00 67.75           C  
ATOM    198  O   LEU    23      10.906  14.880  20.139  1.00 68.07           O  
ATOM    199  CB  LEU    23       8.854  16.903  19.526  1.00 67.56           C  
ATOM    200  CG  LEU    23       7.857  18.043  19.478  1.00 71.70           C  
ATOM    201  CD1 LEU    23       6.457  17.461  19.191  1.00 72.00           C  
ATOM    202  CD2 LEU    23       7.878  18.806  20.780  1.00 67.11           C  
ATOM    203  N   GLY    24      11.168  16.377  21.834  1.00 69.16           N  
ATOM    204  CA  GLY    24      11.643  15.425  22.815  1.00 69.80           C  
ATOM    205  C   GLY    24      10.884  15.598  24.108  1.00 70.76           C  
ATOM    206  O   GLY    24      10.494  16.710  24.465  1.00 70.97           O  
ATOM    207  N   LEU    25      10.735  14.494  24.830  1.00 72.47           N  
ATOM    208  CA  LEU    25      10.015  14.463  26.091  1.00 74.34           C  
ATOM    209  C   LEU    25      11.010  14.993  27.150  1.00 74.96           C  
ATOM    210  O   LEU    25      12.145  14.525  27.228  1.00 73.70           O  
ATOM    211  CB  LEU    25       9.503  13.033  26.394  1.00 72.84           C  
ATOM    212  CG  LEU    25       8.015  12.953  26.735  1.00 72.49           C  
ATOM    213  CD1 LEU    25       7.161  13.401  25.557  1.00 69.61           C  
ATOM    214  CD2 LEU    25       7.623  11.535  27.118  1.00 75.59           C  
ATOM    215  N   ASP    26      10.589  16.011  27.903  1.00 76.90           N  
ATOM    216  CA  ASP    26      11.405  16.637  28.950  1.00 77.57           C  
ATOM    217  C   ASP    26      11.492  15.718  30.181  1.00 78.59           C  
ATOM    218  O   ASP    26      10.601  14.907  30.414  1.00 78.82           O  
ATOM    219  CB  ASP    26      10.802  17.995  29.359  1.00 78.83           C  
ATOM    220  CG  ASP    26      11.741  18.816  30.227  1.00 81.71           C  
ATOM    221  OD1 ASP    26      12.559  19.572  29.658  1.00 83.33           O  
ATOM    222  OD2 ASP    26      11.656  18.697  31.477  1.00 86.77           O  
ATOM    223  N   GLY    27      12.588  15.839  30.931  1.00 79.96           N  
ATOM    224  CA  GLY    27      12.803  15.090  32.163  1.00 81.85           C  
ATOM    225  C   GLY    27      12.993  13.589  32.069  1.00 82.54           C  
ATOM    226  O   GLY    27      12.705  12.893  33.043  1.00 82.96           O  
ATOM    227  N   VAL    28      13.517  13.090  30.947  1.00 83.40           N  
ATOM    228  CA  VAL    28      13.666  11.631  30.732  1.00 83.75           C  
ATOM    229  C   VAL    28      15.039  11.179  30.220  1.00 85.25           C  
ATOM    230  O   VAL    28      15.856  11.988  29.769  1.00 85.54           O  
ATOM    231  CB  VAL    28      12.585  11.094  29.742  1.00 84.15           C  
ATOM    232  CG1 VAL    28      11.212  11.221  30.329  1.00 84.76           C  
ATOM    233  CG2 VAL    28      12.650  11.807  28.426  1.00 81.15           C  
ATOM    234  N   GLU    29      15.252   9.860  30.326  1.00 86.69           N  
ATOM    235  CA  GLU    29      16.440   9.141  29.835  1.00 86.65           C  
ATOM    236  C   GLU    29      16.421   9.238  28.292  1.00 86.73           C  
ATOM    237  O   GLU    29      17.189  10.022  27.712  1.00 87.28           O  
ATOM    238  CB  GLU    29      16.408   7.674  30.358  1.00 86.71           C  
ATOM    239  CG  GLU    29      17.569   6.733  29.973  1.00 86.87           C  
ATOM    240  CD  GLU    29      18.839   6.941  30.784  1.00 87.16           C  
ATOM    241  OE1 GLU    29      19.032   8.033  31.364  1.00 87.24           O  
ATOM    242  OE2 GLU    29      19.658   5.996  30.835  1.00 86.54           O  
ATOM    243  N   ASP    30      15.501   8.507  27.654  1.00 86.31           N  
ATOM    244  CA  ASP    30      15.326   8.521  26.204  1.00 85.65           C  
ATOM    245  C   ASP    30      14.176   9.495  25.941  1.00 83.74           C  
ATOM    246  O   ASP    30      13.006   9.191  26.217  1.00 82.36           O  
ATOM    247  CB  ASP    30      15.018   7.105  25.670  1.00 86.22           C  
ATOM    248  CG  ASP    30      14.946   7.025  24.122  1.00 87.39           C  
ATOM    249  OD1 ASP    30      15.191   8.032  23.397  1.00 89.81           O  
ATOM    250  OD2 ASP    30      14.642   5.911  23.630  1.00 88.30           O  
ATOM    251  N   GLY    31      14.531  10.679  25.430  1.00 82.51           N  
ATOM    252  CA  GLY    31      13.562  11.723  25.081  1.00 80.49           C  
ATOM    253  C   GLY    31      12.677  11.425  23.878  1.00 79.75           C  
ATOM    254  O   GLY    31      11.636  12.076  23.721  1.00 78.15           O  
ATOM    255  N   HIS    32      13.078  10.442  23.053  1.00 78.92           N  
ATOM    256  CA  HIS    32      12.392  10.079  21.807  1.00 78.38           C  
ATOM    257  C   HIS    32      12.324  11.305  20.877  1.00 76.42           C  
ATOM    258  O   HIS    32      11.267  11.624  20.292  1.00 76.30           O  
ATOM    259  CB  HIS    32      11.031   9.430  22.090  1.00 78.51           C  
ATOM    260  CG  HIS    32      11.137   8.161  22.875  1.00 81.02           C  
ATOM    261  ND1 HIS    32      11.167   8.137  24.253  1.00 82.96           N  
ATOM    262  CD2 HIS    32      11.253   6.875  22.474  1.00 80.06           C  
ATOM    263  CE1 HIS    32      11.275   6.889  24.669  1.00 81.78           C  
ATOM    264  NE2 HIS    32      11.329   6.104  23.609  1.00 83.16           N  
ATOM    265  N   ALA    33      13.479  11.984  20.772  1.00 74.02           N  
ATOM    266  CA  ALA    33      13.626  13.184  19.948  1.00 72.19           C  
ATOM    267  C   ALA    33      13.449  12.783  18.497  1.00 69.70           C  
ATOM    268  O   ALA    33      14.078  11.814  18.039  1.00 67.12           O  
ATOM    269  CB  ALA    33      14.987  13.859  20.151  1.00 71.80           C  
ATOM    270  N   ARG    34      12.556  13.488  17.806  1.00 67.19           N  
ATOM    271  CA  ARG    34      12.339  13.250  16.393  1.00 67.22           C  
ATOM    272  C   ARG    34      11.691  14.442  15.720  1.00 64.44           C  
ATOM    273  O   ARG    34      10.952  15.196  16.381  1.00 63.48           O  
ATOM    274  CB  ARG    34      11.540  11.965  16.150  1.00 67.18           C  
ATOM    275  CG  ARG    34      10.172  11.922  16.792  1.00 71.28           C  
ATOM    276  CD  ARG    34       9.592  10.502  16.810  1.00 72.39           C  
ATOM    277  NE  ARG    34      10.255   9.616  17.784  1.00 81.01           N  
ATOM    278  CZ  ARG    34      11.288   8.782  17.558  1.00 84.19           C  
ATOM    279  NH1 ARG    34      11.871   8.654  16.352  1.00 86.28           N  
ATOM    280  NH2 ARG    34      11.755   8.044  18.570  1.00 85.67           N  
ATOM    281  N   PRO    35      11.967  14.626  14.405  1.00 62.56           N  
ATOM    282  CA  PRO    35      11.426  15.765  13.686  1.00 62.47           C  
ATOM    283  C   PRO    35      10.011  15.537  13.223  1.00 61.87           C  
ATOM    284  O   PRO    35       9.737  14.514  12.622  1.00 62.42           O  
ATOM    285  CB  PRO    35      12.380  15.911  12.504  1.00 62.79           C  
ATOM    286  CG  PRO    35      12.923  14.613  12.292  1.00 63.92           C  
ATOM    287  CD  PRO    35      12.796  13.802  13.519  1.00 61.73           C  
ATOM    288  N   MET    36       9.127  16.489  13.525  1.00 62.63           N  
ATOM    289  CA  MET    36       7.711  16.439  13.142  1.00 63.63           C  
ATOM    290  C   MET    36       7.276  17.753  12.556  1.00 61.06           C  
ATOM    291  O   MET    36       7.868  18.789  12.833  1.00 58.73           O  
ATOM    292  CB  MET    36       6.852  16.100  14.341  1.00 63.46           C  
ATOM    293  CG  MET    36       7.253  14.748  14.930  1.00 70.87           C  
ATOM    294  SD  MET    36       6.058  14.216  16.269  0.75 71.16          SE  
ATOM    295  CE  MET    36       4.760  13.683  15.149  1.00 72.71           C  
ATOM    296  N   THR    37       6.192  17.695  11.797  1.00 60.76           N  
ATOM    297  CA  THR    37       5.691  18.830  11.015  1.00 61.43           C  
ATOM    298  C   THR    37       4.609  19.633  11.756  1.00 61.72           C  
ATOM    299  O   THR    37       3.489  19.163  11.945  1.00 62.45           O  
ATOM    300  CB  THR    37       5.194  18.316   9.652  1.00 61.45           C  
ATOM    301  OG1 THR    37       6.248  17.555   9.038  1.00 59.62           O  
ATOM    302  CG2 THR    37       4.794  19.463   8.737  1.00 60.60           C  
ATOM    303  N   ALA    38       4.965  20.832  12.204  1.00 61.37           N  
ATOM    304  CA  ALA    38       4.027  21.700  12.904  1.00 62.54           C  
ATOM    305  C   ALA    38       2.965  22.281  11.944  1.00 63.67           C  
ATOM    306  O   ALA    38       3.258  22.588  10.802  1.00 63.92           O  
ATOM    307  CB  ALA    38       4.762  22.829  13.609  1.00 62.62           C  
ATOM    308  N   GLN    39       1.724  22.329  12.411  1.00 65.02           N  
ATOM    309  CA  GLN    39       0.640  23.011  11.738  1.00 65.99           C  
ATOM    310  C   GLN    39      -0.092  23.849  12.786  1.00 65.24           C  
ATOM    311  O   GLN    39      -0.253  23.414  13.934  1.00 63.32           O  
ATOM    312  CB  GLN    39      -0.320  22.029  11.100  1.00 66.62           C  
ATOM    313  CG  GLN    39       0.320  21.221   9.999  1.00 71.74           C  
ATOM    314  CD  GLN    39      -0.640  20.379   9.188  1.00 70.73           C  
ATOM    315  OE1 GLN    39      -0.287  19.246   8.822  1.00 82.77           O  
ATOM    316  NE2 GLN    39      -1.852  20.917   8.876  1.00 71.37           N  
ATOM    317  N   ILE    40      -0.485  25.058  12.399  1.00 65.86           N  
ATOM    318  CA  ILE    40      -1.327  25.933  13.232  1.00 66.67           C  
ATOM    319  C   ILE    40      -2.519  26.452  12.390  1.00 67.29           C  
ATOM    320  O   ILE    40      -2.403  26.617  11.177  1.00 66.21           O  
ATOM    321  CB  ILE    40      -0.512  27.114  13.872  1.00 66.43           C  
ATOM    322  CG1 ILE    40      -0.119  28.195  12.854  1.00 64.90           C  
ATOM    323  CG2 ILE    40       0.743  26.583  14.584  1.00 66.36           C  
ATOM    324  CD1 ILE    40       0.694  29.355  13.464  1.00 66.76           C  
ATOM    325  N   GLU    41      -3.651  26.712  13.035  1.00 67.88           N  
ATOM    326  CA  GLU    41      -4.796  27.321  12.351  1.00 68.19           C  
ATOM    327  C   GLU    41      -4.506  28.811  12.417  1.00 68.29           C  
ATOM    328  O   GLU    41      -4.081  29.315  13.447  1.00 67.75           O  
ATOM    329  CB  GLU    41      -6.122  26.965  13.011  1.00 67.65           C  
ATOM    330  CG  GLU    41      -6.338  25.465  13.148  1.00 67.09           C  
ATOM    331  CD  GLU    41      -7.748  25.110  13.531  1.00 69.19           C  
ATOM    332  OE1 GLU    41      -8.005  24.874  14.734  1.00 70.22           O  
ATOM    333  OE2 GLU    41      -8.613  25.101  12.630  1.00 72.58           O  
ATOM    334  N   GLY    42      -4.715  29.512  11.315  1.00 69.31           N  
ATOM    335  CA  GLY    42      -4.371  30.923  11.232  1.00 70.73           C  
ATOM    336  C   GLY    42      -2.881  31.113  10.995  1.00 72.32           C  
ATOM    337  O   GLY    42      -2.152  30.168  10.670  1.00 71.78           O  
ATOM    338  N   ASP    43      -2.439  32.350  11.171  1.00 74.76           N  
ATOM    339  CA  ASP    43      -1.040  32.751  10.935  1.00 76.24           C  
ATOM    340  C   ASP    43      -0.192  32.843  12.215  1.00 76.23           C  
ATOM    341  O   ASP    43       1.043  32.789  12.142  1.00 75.95           O  
ATOM    342  CB  ASP    43      -1.047  34.066  10.152  1.00 77.32           C  
ATOM    343  CG  ASP    43      -1.873  33.966   8.854  1.00 80.76           C  
ATOM    344  OD1 ASP    43      -1.801  32.923   8.153  1.00 84.46           O  
ATOM    345  OD2 ASP    43      -2.602  34.929   8.543  1.00 86.27           O  
ATOM    346  N   SER    44      -0.847  32.986  13.368  1.00 75.83           N  
ATOM    347  CA  SER    44      -0.172  32.991  14.672  1.00 76.04           C  
ATOM    348  C   SER    44      -0.974  32.203  15.726  1.00 74.54           C  
ATOM    349  O   SER    44      -2.106  31.772  15.497  1.00 74.05           O  
ATOM    350  CB  SER    44       0.034  34.432  15.162  1.00 75.37           C  
ATOM    351  OG  SER    44      -1.194  35.014  15.568  1.00 77.39           O  
ATOM    352  N   GLY    45      -0.354  32.041  16.881  1.00 73.61           N  
ATOM    353  CA  GLY    45      -0.959  31.406  18.034  1.00 73.37           C  
ATOM    354  C   GLY    45      -1.141  29.913  17.966  1.00 72.49           C  
ATOM    355  O   GLY    45      -1.494  29.371  16.939  1.00 72.76           O  
ATOM    356  N   GLY    46      -0.921  29.244  19.090  1.00 72.31           N  
ATOM    357  CA  GLY    46      -1.103  27.797  19.180  1.00 70.26           C  
ATOM    358  C   GLY    46      -2.585  27.445  19.311  1.00 68.19           C  
ATOM    359  O   GLY    46      -3.421  28.324  19.176  1.00 67.96           O  
ATOM    360  N   PRO    47      -2.921  26.163  19.564  1.00 66.61           N  
ATOM    361  CA  PRO    47      -1.986  25.041  19.729  1.00 65.95           C  
ATOM    362  C   PRO    47      -1.200  24.697  18.459  1.00 64.51           C  
ATOM    363  O   PRO    47      -1.618  25.063  17.361  1.00 65.61           O  
ATOM    364  CB  PRO    47      -2.895  23.871  20.133  1.00 65.74           C  
ATOM    365  CG  PRO    47      -4.206  24.502  20.510  1.00 68.47           C  
ATOM    366  CD  PRO    47      -4.322  25.722  19.704  1.00 66.10           C  
ATOM    367  N   ILE    48      -0.054  24.051  18.639  1.00 62.85           N  
ATOM    368  CA  ILE    48       0.774  23.589  17.536  1.00 62.67           C  
ATOM    369  C   ILE    48       0.409  22.103  17.403  1.00 61.35           C  
ATOM    370  O   ILE    48       0.603  21.307  18.348  1.00 61.17           O  
ATOM    371  CB  ILE    48       2.284  23.820  17.807  1.00 62.84           C  
ATOM    372  CG1 ILE    48       2.573  25.334  17.988  1.00 65.82           C  
ATOM    373  CG2 ILE    48       3.112  23.258  16.679  1.00 55.88           C  
ATOM    374  CD1 ILE    48       3.926  25.655  18.683  1.00 63.10           C  
ATOM    375  N   TRP    49      -0.105  21.748  16.231  1.00 59.20           N  
ATOM    376  CA  TRP    49      -0.565  20.413  15.929  1.00 58.95           C  
ATOM    377  C   TRP    49       0.455  19.634  15.100  1.00 59.22           C  
ATOM    378  O   TRP    49       1.116  20.194  14.236  1.00 60.26           O  
ATOM    379  CB  TRP    49      -1.874  20.491  15.160  1.00 60.06           C  
ATOM    380  CG  TRP    49      -2.976  21.246  15.842  1.00 61.83           C  
ATOM    381  CD1 TRP    49      -3.241  22.581  15.740  1.00 62.31           C  
ATOM    382  CD2 TRP    49      -3.946  20.712  16.746  1.00 63.23           C  
ATOM    383  NE1 TRP    49      -4.333  22.910  16.499  1.00 63.51           N  
ATOM    384  CE2 TRP    49      -4.791  21.785  17.130  1.00 64.70           C  
ATOM    385  CE3 TRP    49      -4.192  19.430  17.258  1.00 60.45           C  
ATOM    386  CZ2 TRP    49      -5.871  21.617  18.015  1.00 64.00           C  
ATOM    387  CZ3 TRP    49      -5.269  19.247  18.125  1.00 62.95           C  
ATOM    388  CH2 TRP    49      -6.096  20.343  18.504  1.00 65.90           C  
ATOM    389  N   PHE    50       0.544  18.336  15.359  1.00 59.87           N  
ATOM    390  CA  PHE    50       1.432  17.408  14.667  1.00 59.82           C  
ATOM    391  C   PHE    50       0.679  16.129  14.288  1.00 60.06           C  
ATOM    392  O   PHE    50       0.203  15.427  15.169  1.00 59.72           O  
ATOM    393  CB  PHE    50       2.602  17.023  15.567  1.00 60.78           C  
ATOM    394  CG  PHE    50       3.443  18.176  15.986  1.00 57.50           C  
ATOM    395  CD1 PHE    50       4.467  18.641  15.155  1.00 56.54           C  
ATOM    396  CD2 PHE    50       3.231  18.797  17.213  1.00 61.39           C  
ATOM    397  CE1 PHE    50       5.263  19.740  15.538  1.00 61.15           C  
ATOM    398  CE2 PHE    50       4.026  19.911  17.619  1.00 61.39           C  
ATOM    399  CZ  PHE    50       5.038  20.379  16.783  1.00 59.11           C  
ATOM    400  N   PHE    51       0.540  15.873  12.980  1.00 60.22           N  
ATOM    401  CA  PHE    51      -0.034  14.639  12.465  1.00 60.99           C  
ATOM    402  C   PHE    51       0.996  13.534  12.659  1.00 62.77           C  
ATOM    403  O   PHE    51       2.188  13.735  12.416  1.00 61.23           O  
ATOM    404  CB  PHE    51      -0.437  14.730  10.980  1.00 59.72           C  
ATOM    405  CG  PHE    51      -1.811  15.267  10.760  1.00 59.54           C  
ATOM    406  CD1 PHE    51      -2.924  14.421  10.890  1.00 59.07           C  
ATOM    407  CD2 PHE    51      -2.018  16.612  10.431  1.00 56.93           C  
ATOM    408  CE1 PHE    51      -4.227  14.898  10.691  1.00 56.00           C  
ATOM    409  CE2 PHE    51      -3.315  17.101  10.230  1.00 57.90           C  
ATOM    410  CZ  PHE    51      -4.425  16.242  10.352  1.00 55.28           C  
ATOM    411  N   THR    52       0.529  12.363  13.087  1.00 64.97           N  
ATOM    412  CA  THR    52       1.431  11.252  13.360  1.00 66.70           C  
ATOM    413  C   THR    52       0.715   9.907  13.320  1.00 68.53           C  
ATOM    414  O   THR    52      -0.503   9.849  13.124  1.00 67.55           O  
ATOM    415  CB  THR    52       2.156  11.486  14.732  1.00 66.81           C  
ATOM    416  OG1 THR    52       3.324  10.661  14.826  1.00 66.69           O  
ATOM    417  CG2 THR    52       1.218  11.261  15.929  1.00 67.16           C  
ATOM    418  N   SER    53       1.503   8.842  13.475  1.00 71.02           N  
ATOM    419  CA  SER    53       1.007   7.462  13.488  1.00 73.79           C  
ATOM    420  C   SER    53       0.726   7.057  14.924  1.00 74.03           C  
ATOM    421  O   SER    53       1.457   7.448  15.825  1.00 73.97           O  
ATOM    422  CB  SER    53       2.028   6.511  12.842  1.00 74.45           C  
ATOM    423  OG  SER    53       3.347   6.758  13.326  1.00 77.89           O  
ATOM    424  N   LYS    54      -0.317   6.249  15.122  1.00 75.47           N  
ATOM    425  CA  LYS    54      -0.727   5.767  16.466  1.00 76.05           C  
ATOM    426  C   LYS    54       0.378   4.954  17.194  1.00 76.73           C  
ATOM    427  O   LYS    54       0.372   4.863  18.430  1.00 76.65           O  
ATOM    428  CB  LYS    54      -2.038   4.962  16.384  1.00 75.95           C  
ATOM    429  CG  LYS    54      -2.723   4.735  17.727  1.00 75.99           C  
ATOM    430  N   ASP    55       1.312   4.393  16.415  1.00 77.08           N  
ATOM    431  CA  ASP    55       2.486   3.668  16.927  1.00 77.47           C  
ATOM    432  C   ASP    55       3.756   4.543  17.137  1.00 77.73           C  
ATOM    433  O   ASP    55       4.865   4.003  17.202  1.00 77.71           O  
ATOM    434  CB  ASP    55       2.769   2.405  16.057  1.00 78.39           C  
ATOM    435  CG  ASP    55       3.146   2.723  14.594  1.00 79.86           C  
ATOM    436  OD1 ASP    55       3.702   3.814  14.296  1.00 76.90           O  
ATOM    437  OD2 ASP    55       2.882   1.844  13.742  1.00 75.84           O  
ATOM    438  N   ASN    56       3.604   5.877  17.225  1.00 78.26           N  
ATOM    439  CA  ASN    56       4.730   6.786  17.527  1.00 77.69           C  
ATOM    440  C   ASN    56       5.063   6.579  19.009  1.00 77.79           C  
ATOM    441  O   ASN    56       4.163   6.580  19.850  1.00 77.84           O  
ATOM    442  CB  ASN    56       4.373   8.259  17.235  1.00 78.20           C  
ATOM    443  CG  ASN    56       5.575   9.239  17.393  1.00 78.54           C  
ATOM    444  OD1 ASN    56       6.618   8.904  17.961  1.00 81.25           O  
ATOM    445  ND2 ASN    56       5.402  10.467  16.892  1.00 76.95           N  
ATOM    446  N   ALA    57       6.353   6.390  19.305  1.00 77.88           N  
ATOM    447  CA  ALA    57       6.862   6.139  20.673  1.00 77.42           C  
ATOM    448  C   ALA    57       6.356   7.121  21.743  1.00 77.21           C  
ATOM    449  O   ALA    57       6.012   6.703  22.852  1.00 78.12           O  
ATOM    450  CB  ALA    57       8.395   6.125  20.674  1.00 78.03           C  
ATOM    451  N   LEU    58       6.293   8.404  21.390  1.00 75.66           N  
ATOM    452  CA  LEU    58       5.806   9.455  22.297  1.00 75.14           C  
ATOM    453  C   LEU    58       4.381   9.207  22.822  1.00 74.76           C  
ATOM    454  O   LEU    58       4.159   9.244  24.039  1.00 75.19           O  
ATOM    455  CB  LEU    58       5.835  10.823  21.607  1.00 75.44           C  
ATOM    456  CG  LEU    58       7.167  11.385  21.116  1.00 75.89           C  
ATOM    457  CD1 LEU    58       6.926  12.648  20.323  1.00 77.91           C  
ATOM    458  CD2 LEU    58       8.087  11.656  22.285  1.00 78.44           C  
ATOM    459  N   ILE    59       3.464   8.877  21.906  1.00 73.25           N  
ATOM    460  CA  ILE    59       2.014   8.743  22.190  1.00 73.11           C  
ATOM    461  C   ILE    59       1.621   8.007  23.482  1.00 72.50           C  
ATOM    462  O   ILE    59       0.824   8.533  24.266  1.00 72.90           O  
ATOM    463  CB  ILE    59       1.236   8.119  20.986  1.00 72.45           C  
ATOM    464  CG1 ILE    59       1.214   9.077  19.803  1.00 71.37           C  
ATOM    465  CG2 ILE    59      -0.223   7.792  21.357  1.00 72.55           C  
ATOM    466  CD1 ILE    59       0.611   8.451  18.569  1.00 73.52           C  
ATOM    467  N   ALA    60       2.187   6.822  23.703  1.00 72.02           N  
ATOM    468  CA  ALA    60       1.866   6.014  24.898  1.00 71.94           C  
ATOM    469  C   ALA    60       2.331   6.613  26.247  1.00 71.50           C  
ATOM    470  O   ALA    60       1.842   6.197  27.297  1.00 71.70           O  
ATOM    471  CB  ALA    60       2.408   4.598  24.738  1.00 71.96           C  
ATOM    472  N   MET    61       3.257   7.573  26.188  1.00 71.59           N  
ATOM    473  CA  MET    61       3.829   8.262  27.356  0.50 71.96           C  
ATOM    475  C   MET    61       3.029   9.526  27.769  1.00 70.87           C  
ATOM    476  O   MET    61       3.049   9.928  28.920  1.00 70.86           O  
ATOM    477  CB  MET    61       5.308   8.657  27.063  0.50 72.25           C  
ATOM    479  CG  MET    61       6.197   7.492  26.514  0.50 73.77           C  
ATOM    481  SD  MET    61       8.167   7.783  26.352  0.38 75.42          SE  
ATOM    483  CE  MET    61       8.247   9.135  25.028  0.50 75.19           C  
ATOM    485  N   LEU    62       2.283  10.118  26.842  1.00 69.59           N  
ATOM    486  CA  LEU    62       1.606  11.414  27.092  1.00 68.81           C  
ATOM    487  C   LEU    62       0.483  11.543  28.142  1.00 66.71           C  
ATOM    488  O   LEU    62       0.504  12.487  28.924  1.00 65.74           O  
ATOM    489  CB  LEU    62       1.144  12.039  25.760  1.00 68.82           C  
ATOM    490  CG  LEU    62       2.150  12.080  24.597  1.00 66.91           C  
ATOM    491  CD1 LEU    62       1.573  12.864  23.444  1.00 65.18           C  
ATOM    492  CD2 LEU    62       3.503  12.641  25.019  1.00 67.43           C  
ATOM    493  N   GLY    63      -0.484  10.630  28.152  1.00 66.16           N  
ATOM    494  CA  GLY    63      -1.649  10.712  29.056  1.00 66.32           C  
ATOM    495  C   GLY    63      -2.434  12.035  28.966  1.00 65.63           C  
ATOM    496  O   GLY    63      -2.892  12.444  27.902  1.00 65.48           O  
ATOM    497  N   GLN    64      -2.526  12.726  30.095  1.00 66.49           N  
ATOM    498  CA  GLN    64      -3.162  14.057  30.221  1.00 66.40           C  
ATOM    499  C   GLN    64      -2.281  15.170  29.596  1.00 64.88           C  
ATOM    500  O   GLN    64      -2.723  16.288  29.421  1.00 63.57           O  
ATOM    501  CB  GLN    64      -3.361  14.351  31.738  1.00 68.24           C  
ATOM    502  CG  GLN    64      -4.310  15.495  32.149  1.00 68.00           C  
ATOM    503  CD  GLN    64      -4.161  15.929  33.634  1.00 67.37           C  
ATOM    504  OE1 GLN    64      -3.052  16.233  34.087  1.00 72.68           O  
ATOM    505  NE2 GLN    64      -5.281  15.989  34.375  1.00 55.14           N  
ATOM    506  N   GLY    65      -1.024  14.859  29.299  1.00 64.73           N  
ATOM    507  CA  GLY    65      -0.069  15.787  28.750  1.00 65.43           C  
ATOM    508  C   GLY    65       1.242  15.662  29.502  1.00 66.21           C  
ATOM    509  O   GLY    65       1.241  15.457  30.712  1.00 66.90           O  
ATOM    510  N   ARG    66       2.352  15.729  28.776  1.00 67.81           N  
ATOM    511  CA  ARG    66       3.709  15.714  29.342  1.00 68.20           C  
ATOM    512  C   ARG    66       4.434  16.905  28.823  1.00 68.16           C  
ATOM    513  O   ARG    66       4.195  17.319  27.686  1.00 67.24           O  
ATOM    514  CB  ARG    66       4.485  14.473  28.947  1.00 68.79           C  
ATOM    515  CG  ARG    66       4.023  13.260  29.688  1.00 75.77           C  
ATOM    516  CD  ARG    66       5.041  12.160  29.651  1.00 84.49           C  
ATOM    517  NE  ARG    66       6.263  12.502  30.375  1.00 88.64           N  
ATOM    518  CZ  ARG    66       7.240  11.643  30.675  1.00 91.91           C  
ATOM    519  NH1 ARG    66       7.168  10.346  30.342  1.00 92.78           N  
ATOM    520  NH2 ARG    66       8.309  12.087  31.343  1.00 93.03           N  
ATOM    521  N   ARG    67       5.352  17.429  29.633  1.00 69.22           N  
ATOM    522  CA  ARG    67       6.094  18.619  29.252  1.00 70.73           C  
ATOM    523  C   ARG    67       7.126  18.197  28.198  1.00 67.85           C  
ATOM    524  O   ARG    67       7.712  17.123  28.299  1.00 68.41           O  
ATOM    525  CB  ARG    67       6.756  19.329  30.455  1.00 70.26           C  
ATOM    526  CG  ARG    67       6.821  20.848  30.221  1.00 76.57           C  
ATOM    527  CD  ARG    67       7.966  21.566  30.904  1.00 77.32           C  
ATOM    528  NE  ARG    67       7.855  21.681  32.362  1.00 86.77           N  
ATOM    529  CZ  ARG    67       8.456  20.913  33.286  1.00 88.48           C  
ATOM    530  NH1 ARG    67       9.276  19.899  32.970  1.00 89.88           N  
ATOM    531  NH2 ARG    67       8.239  21.180  34.573  1.00 88.54           N  
ATOM    532  N   VAL    68       7.271  19.005  27.159  1.00 65.16           N  
ATOM    533  CA  VAL    68       8.215  18.747  26.063  1.00 62.41           C  
ATOM    534  C   VAL    68       8.978  20.007  25.717  1.00 60.91           C  
ATOM    535  O   VAL    68       8.543  21.090  26.072  1.00 59.60           O  
ATOM    536  CB  VAL    68       7.498  18.254  24.764  1.00 61.59           C  
ATOM    537  CG1 VAL    68       6.901  16.871  24.965  1.00 61.91           C  
ATOM    538  CG2 VAL    68       6.433  19.268  24.275  1.00 55.67           C  
ATOM    539  N   ILE    69      10.122  19.827  25.049  1.00 60.95           N  
ATOM    540  CA  ILE    69      10.926  20.890  24.436  1.00 61.42           C  
ATOM    541  C   ILE    69      10.969  20.593  22.918  1.00 62.59           C  
ATOM    542  O   ILE    69      11.247  19.472  22.513  1.00 63.16           O  
ATOM    543  CB  ILE    69      12.359  20.987  25.029  1.00 61.23           C  
ATOM    544  CG1 ILE    69      12.309  21.469  26.486  1.00 62.50           C  
ATOM    545  CG2 ILE    69      13.291  21.908  24.186  1.00 56.80           C  
ATOM    546  CD1 ILE    69      11.826  22.910  26.653  1.00 63.44           C  
ATOM    547  N   GLY    70      10.686  21.605  22.099  1.00 62.73           N  
ATOM    548  CA  GLY    70      10.683  21.493  20.647  1.00 62.02           C  
ATOM    549  C   GLY    70      11.794  22.387  20.116  1.00 61.75           C  
ATOM    550  O   GLY    70      11.733  23.605  20.304  1.00 62.94           O  
ATOM    551  N   ALA    71      12.817  21.793  19.520  1.00 59.28           N  
ATOM    552  CA  ALA    71      13.928  22.558  18.933  1.00 60.54           C  
ATOM    553  C   ALA    71      13.531  22.928  17.483  1.00 59.79           C  
ATOM    554  O   ALA    71      13.273  22.042  16.668  1.00 59.76           O  
ATOM    555  CB  ALA    71      15.217  21.749  18.984  1.00 58.60           C  
ATOM    556  N   PHE    72      13.434  24.227  17.204  1.00 59.98           N  
ATOM    557  CA  PHE    72      13.040  24.764  15.881  1.00 60.04           C  
ATOM    558  C   PHE    72      14.087  25.714  15.286  1.00 60.96           C  
ATOM    559  O   PHE    72      14.642  26.566  16.003  1.00 60.23           O  
ATOM    560  CB  PHE    72      11.733  25.575  15.998  1.00 59.18           C  
ATOM    561  CG  PHE    72      11.344  26.281  14.725  1.00 58.73           C  
ATOM    562  CD1 PHE    72      10.759  25.576  13.684  1.00 58.25           C  
ATOM    563  CD2 PHE    72      11.630  27.630  14.535  1.00 60.96           C  
ATOM    564  CE1 PHE    72      10.437  26.187  12.475  1.00 59.78           C  
ATOM    565  CE2 PHE    72      11.313  28.266  13.322  1.00 64.31           C  
ATOM    566  CZ  PHE    72      10.701  27.539  12.297  1.00 59.65           C  
ATOM    567  N   SER    73      14.300  25.593  13.973  1.00 60.67           N  
ATOM    568  CA  SER    73      15.104  26.554  13.233  1.00 61.76           C  
ATOM    569  C   SER    73      14.387  26.874  11.932  1.00 61.94           C  
ATOM    570  O   SER    73      13.763  25.993  11.344  1.00 61.60           O  
ATOM    571  CB  SER    73      16.533  26.050  12.965  1.00 62.88           C  
ATOM    572  OG  SER    73      16.613  25.073  11.935  1.00 64.92           O  
ATOM    573  N   SER    74      14.431  28.142  11.511  1.00 62.03           N  
ATOM    574  CA  SER    74      13.942  28.540  10.202  1.00 62.94           C  
ATOM    575  C   SER    74      14.851  27.889   9.130  1.00 62.64           C  
ATOM    576  O   SER    74      15.990  27.551   9.408  1.00 61.33           O  
ATOM    577  CB  SER    74      13.929  30.074  10.048  1.00 62.75           C  
ATOM    578  OG  SER    74      15.209  30.614  10.328  1.00 67.23           O  
ATOM    579  N   LYS    75      14.347  27.753   7.913  1.00 64.07           N  
ATOM    580  CA  LYS    75      15.071  27.094   6.799  1.00 65.55           C  
ATOM    581  C   LYS    75      16.431  27.760   6.465  1.00 66.03           C  
ATOM    582  O   LYS    75      17.456  27.074   6.222  1.00 66.43           O  
ATOM    583  CB  LYS    75      14.146  26.987   5.582  1.00 64.21           C  
ATOM    584  CG  LYS    75      14.528  25.940   4.558  1.00 69.75           C  
ATOM    585  CD  LYS    75      13.380  25.629   3.534  1.00 68.15           C  
ATOM    586  CE  LYS    75      12.201  24.845   4.199  1.00 75.85           C  
ATOM    587  NZ  LYS    75      11.098  24.432   3.271  1.00 74.33           N  
ATOM    588  N   GLY    76      16.454  29.086   6.521  1.00 65.47           N  
ATOM    589  CA  GLY    76      17.695  29.823   6.305  1.00 64.53           C  
ATOM    590  C   GLY    76      18.616  29.969   7.510  1.00 64.33           C  
ATOM    591  O   GLY    76      19.679  30.580   7.377  1.00 64.98           O  
ATOM    592  N   HIS    77      18.230  29.432   8.674  1.00 63.35           N  
ATOM    593  CA  HIS    77      19.004  29.540   9.914  1.00 63.01           C  
ATOM    594  C   HIS    77      19.153  30.968  10.472  1.00 62.42           C  
ATOM    595  O   HIS    77      20.116  31.266  11.186  1.00 62.37           O  
ATOM    596  CB  HIS    77      20.359  28.812   9.771  1.00 62.40           C  
ATOM    597  CG  HIS    77      20.264  27.329   9.882  1.00 65.14           C  
ATOM    598  ND1 HIS    77      21.384  26.544  10.009  1.00 63.19           N  
ATOM    599  CD2 HIS    77      19.200  26.491   9.977  1.00 60.11           C  
ATOM    600  CE1 HIS    77      21.022  25.281  10.114  1.00 63.23           C  
ATOM    601  NE2 HIS    77      19.704  25.219  10.107  1.00 64.01           N  
ATOM    602  N   ASP    78      18.176  31.822  10.164  1.00 62.73           N  
ATOM    603  CA  ASP    78      18.120  33.200  10.668  1.00 63.74           C  
ATOM    604  C   ASP    78      17.443  33.299  12.036  1.00 62.49           C  
ATOM    605  O   ASP    78      17.598  34.293  12.714  1.00 61.00           O  
ATOM    606  CB  ASP    78      17.465  34.172   9.664  1.00 65.53           C  
ATOM    607  CG  ASP    78      16.011  33.852   9.363  1.00 74.11           C  
ATOM    608  OD1 ASP    78      15.706  32.676   9.082  1.00 87.52           O  
ATOM    609  OD2 ASP    78      15.181  34.791   9.350  1.00 86.29           O  
ATOM    610  N   LEU    79      16.693  32.267  12.420  1.00 63.41           N  
ATOM    611  CA  LEU    79      16.018  32.193  13.702  1.00 62.72           C  
ATOM    612  C   LEU    79      16.037  30.779  14.262  1.00 62.60           C  
ATOM    613  O   LEU    79      15.770  29.825  13.543  1.00 62.56           O  
ATOM    614  CB  LEU    79      14.571  32.682  13.538  1.00 62.83           C  
ATOM    615  CG  LEU    79      13.612  32.684  14.742  1.00 63.48           C  
ATOM    616  CD1 LEU    79      12.605  33.802  14.634  1.00 60.71           C  
ATOM    617  CD2 LEU    79      12.912  31.345  14.948  1.00 61.69           C  
ATOM    618  N   PHE    80      16.349  30.676  15.557  1.00 63.03           N  
ATOM    619  CA  PHE    80      16.302  29.445  16.331  1.00 61.20           C  
ATOM    620  C   PHE    80      15.329  29.671  17.497  1.00 61.24           C  
ATOM    621  O   PHE    80      15.302  30.747  18.058  1.00 61.99           O  
ATOM    622  CB  PHE    80      17.698  29.080  16.813  1.00 61.64           C  
ATOM    623  CG  PHE    80      18.629  28.791  15.692  1.00 62.13           C  
ATOM    624  CD1 PHE    80      18.686  27.513  15.140  1.00 59.83           C  
ATOM    625  CD2 PHE    80      19.398  29.808  15.132  1.00 62.75           C  
ATOM    626  CE1 PHE    80      19.521  27.243  14.062  1.00 60.15           C  
ATOM    627  CE2 PHE    80      20.226  29.561  14.027  1.00 60.53           C  
ATOM    628  CZ  PHE    80      20.299  28.274  13.502  1.00 61.80           C  
ATOM    629  N   ALA    81      14.506  28.672  17.809  1.00 60.35           N  
ATOM    630  CA  ALA    81      13.524  28.758  18.893  1.00 59.85           C  
ATOM    631  C   ALA    81      13.447  27.422  19.627  1.00 61.07           C  
ATOM    632  O   ALA    81      13.455  26.357  18.989  1.00 61.07           O  
ATOM    633  CB  ALA    81      12.123  29.169  18.347  1.00 57.08           C  
ATOM    634  N   SER    82      13.425  27.501  20.960  1.00 61.50           N  
ATOM    635  CA  SER    82      13.270  26.357  21.849  1.00 61.69           C  
ATOM    636  C   SER    82      11.882  26.548  22.472  1.00 61.85           C  
ATOM    637  O   SER    82      11.663  27.507  23.219  1.00 62.53           O  
ATOM    638  CB  SER    82      14.371  26.351  22.900  1.00 61.04           C  
ATOM    639  OG  SER    82      14.242  25.225  23.714  1.00 61.74           O  
ATOM    640  N   ILE    83      10.963  25.643  22.148  1.00 61.03           N  
ATOM    641  CA  ILE    83       9.553  25.764  22.517  1.00 60.58           C  
ATOM    642  C   ILE    83       9.266  24.847  23.697  1.00 60.93           C  
ATOM    643  O   ILE    83       9.510  23.656  23.602  1.00 61.95           O  
ATOM    644  CB  ILE    83       8.633  25.355  21.334  1.00 60.49           C  
ATOM    645  CG1 ILE    83       9.032  26.076  20.025  1.00 61.83           C  
ATOM    646  CG2 ILE    83       7.177  25.624  21.675  1.00 58.47           C  
ATOM    647  CD1 ILE    83       8.434  25.478  18.765  1.00 60.88           C  
ATOM    648  N   SER    84       8.759  25.418  24.787  1.00 59.46           N  
ATOM    649  CA  SER    84       8.364  24.697  25.970  1.00 60.27           C  
ATOM    650  C   SER    84       6.845  24.641  26.009  1.00 59.71           C  
ATOM    651  O   SER    84       6.184  25.641  25.786  1.00 58.95           O  
ATOM    652  CB  SER    84       8.864  25.397  27.227  1.00 59.24           C  
ATOM    653  OG  SER    84       8.388  24.722  28.346  1.00 61.61           O  
ATOM    654  N   GLY    85       6.313  23.461  26.315  1.00 59.32           N  
ATOM    655  CA  GLY    85       4.886  23.285  26.414  1.00 59.57           C  
ATOM    656  C   GLY    85       4.476  21.884  26.795  1.00 59.93           C  
ATOM    657  O   GLY    85       5.316  21.040  27.130  1.00 57.84           O  
ATOM    658  N   SER    86       3.167  21.652  26.718  1.00 60.53           N  
ATOM    659  CA  SER    86       2.579  20.379  27.083  1.00 62.22           C  
ATOM    660  C   SER    86       2.099  19.687  25.827  1.00 61.21           C  
ATOM    661  O   SER    86       1.456  20.327  24.998  1.00 60.49           O  
ATOM    662  CB  SER    86       1.424  20.601  28.056  1.00 62.37           C  
ATOM    663  OG  SER    86       1.041  19.368  28.593  1.00 69.29           O  
ATOM    664  N   LEU    87       2.410  18.390  25.709  1.00 61.36           N  
ATOM    665  CA  LEU    87       2.066  17.577  24.555  1.00 61.79           C  
ATOM    666  C   LEU    87       1.098  16.463  24.945  1.00 62.05           C  
ATOM    667  O   LEU    87       1.339  15.762  25.910  1.00 61.68           O  
ATOM    668  CB  LEU    87       3.332  16.959  23.956  1.00 62.08           C  
ATOM    669  CG  LEU    87       3.223  16.237  22.587  1.00 60.82           C  
ATOM    670  CD1 LEU    87       2.987  17.238  21.460  1.00 56.57           C  
ATOM    671  CD2 LEU    87       4.471  15.424  22.316  1.00 60.35           C  
ATOM    672  N   ARG    88       0.013  16.314  24.189  1.00 62.43           N  
ATOM    673  CA  ARG    88      -0.968  15.221  24.395  1.00 63.66           C  
ATOM    674  C   ARG    88      -1.614  14.877  23.060  1.00 65.27           C  
ATOM    675  O   ARG    88      -1.478  15.629  22.091  1.00 65.49           O  
ATOM    676  CB  ARG    88      -2.045  15.593  25.414  1.00 61.65           C  
ATOM    677  CG  ARG    88      -3.136  16.563  24.942  1.00 62.82           C  
ATOM    678  CD  ARG    88      -3.992  17.029  26.093  1.00 64.88           C  
ATOM    679  NE  ARG    88      -5.296  17.545  25.669  1.00 68.30           N  
ATOM    680  CZ  ARG    88      -5.652  18.829  25.496  1.00 73.89           C  
ATOM    681  NH1 ARG    88      -4.840  19.870  25.744  1.00 70.34           N  
ATOM    682  NH2 ARG    88      -6.898  19.082  25.081  1.00 77.03           N  
ATOM    683  N   GLU    89      -2.309  13.748  23.022  1.00 65.27           N  
ATOM    684  CA  GLU    89      -3.038  13.341  21.837  1.00 65.79           C  
ATOM    685  C   GLU    89      -4.428  13.954  21.904  1.00 65.73           C  
ATOM    686  O   GLU    89      -5.092  13.873  22.930  1.00 65.83           O  
ATOM    687  CB  GLU    89      -3.160  11.826  21.762  1.00 65.81           C  
ATOM    688  CG  GLU    89      -3.649  11.337  20.397  1.00 66.36           C  
ATOM    689  CD  GLU    89      -4.083   9.899  20.410  1.00 66.98           C  
ATOM    690  OE1 GLU    89      -3.488   9.087  21.159  1.00 69.53           O  
ATOM    691  OE2 GLU    89      -5.033   9.581  19.657  1.00 75.68           O  
ATOM    692  N   ASP    90      -4.849  14.597  20.820  1.00 67.11           N  
ATOM    693  CA  ASP    90      -6.206  15.145  20.705  1.00 67.14           C  
ATOM    694  C   ASP    90      -6.621  14.961  19.255  1.00 67.68           C  
ATOM    695  O   ASP    90      -6.628  15.917  18.464  1.00 68.75           O  
ATOM    696  CB  ASP    90      -6.315  16.617  21.162  1.00 66.98           C  
ATOM    697  CG  ASP    90      -7.786  17.152  21.154  1.00 68.16           C  
ATOM    698  OD1 ASP    90      -8.764  16.372  21.278  1.00 66.63           O  
ATOM    699  OD2 ASP    90      -7.973  18.377  21.026  1.00 70.41           O  
ATOM    700  N   THR    91      -6.947  13.708  18.924  1.00 66.34           N  
ATOM    701  CA  THR    91      -7.418  13.320  17.601  1.00 66.46           C  
ATOM    702  C   THR    91      -8.928  13.639  17.527  1.00 66.88           C  
ATOM    703  O   THR    91      -9.805  12.750  17.586  1.00 66.05           O  
ATOM    704  CB  THR    91      -7.056  11.851  17.277  1.00 66.58           C  
ATOM    705  OG1 THR    91      -5.648  11.653  17.532  1.00 64.66           O  
ATOM    706  CG2 THR    91      -7.383  11.512  15.802  1.00 64.38           C  
ATOM    707  N   ASP    92      -9.184  14.951  17.407  1.00 66.79           N  
ATOM    708  CA  ASP    92     -10.499  15.528  17.320  1.00 65.30           C  
ATOM    709  C   ASP    92     -10.811  15.527  15.826  1.00 65.43           C  
ATOM    710  O   ASP    92     -10.123  16.230  15.077  1.00 65.65           O  
ATOM    711  CB  ASP    92     -10.516  16.960  17.880  1.00 64.41           C  
ATOM    712  CG  ASP    92     -11.928  17.619  17.866  1.00 66.57           C  
ATOM    713  OD1 ASP    92     -12.837  17.213  17.098  1.00 62.25           O  
ATOM    714  OD2 ASP    92     -12.124  18.592  18.634  1.00 68.03           O  
ATOM    715  N   PRO    93     -11.854  14.773  15.392  1.00 64.19           N  
ATOM    716  CA  PRO    93     -12.262  14.737  13.982  1.00 63.47           C  
ATOM    717  C   PRO    93     -12.436  16.092  13.331  1.00 62.27           C  
ATOM    718  O   PRO    93     -12.122  16.236  12.151  1.00 60.14           O  
ATOM    719  CB  PRO    93     -13.644  14.033  14.017  1.00 62.28           C  
ATOM    720  CG  PRO    93     -13.973  13.845  15.393  1.00 62.35           C  
ATOM    721  CD  PRO    93     -12.741  13.919  16.200  1.00 63.70           C  
ATOM    722  N   ALA    94     -12.990  17.047  14.084  1.00 62.20           N  
ATOM    723  CA  ALA    94     -13.192  18.401  13.580  1.00 62.51           C  
ATOM    724  C   ALA    94     -11.854  19.078  13.309  1.00 61.72           C  
ATOM    725  O   ALA    94     -11.733  19.783  12.318  1.00 61.42           O  
ATOM    726  CB  ALA    94     -14.045  19.242  14.545  1.00 62.99           C  
ATOM    727  N   VAL    95     -10.861  18.857  14.177  1.00 62.04           N  
ATOM    728  CA  VAL    95      -9.512  19.437  13.972  1.00 62.22           C  
ATOM    729  C   VAL    95      -8.829  18.730  12.792  1.00 61.88           C  
ATOM    730  O   VAL    95      -8.248  19.388  11.941  1.00 61.01           O  
ATOM    731  CB  VAL    95      -8.645  19.399  15.222  1.00 62.15           C  
ATOM    732  CG1 VAL    95      -7.285  20.045  14.939  1.00 62.94           C  
ATOM    733  CG2 VAL    95      -9.347  20.119  16.363  1.00 59.03           C  
ATOM    734  N   VAL    96      -8.946  17.402  12.739  1.00 61.69           N  
ATOM    735  CA  VAL    96      -8.433  16.610  11.624  1.00 62.38           C  
ATOM    736  C   VAL    96      -8.931  17.202  10.307  1.00 62.20           C  
ATOM    737  O   VAL    96      -8.125  17.431   9.429  1.00 60.58           O  
ATOM    738  CB  VAL    96      -8.826  15.096  11.729  1.00 61.95           C  
ATOM    739  CG1 VAL    96      -8.649  14.352  10.383  1.00 60.55           C  
ATOM    740  CG2 VAL    96      -8.025  14.423  12.832  1.00 61.12           C  
ATOM    741  N   ASP    97     -10.236  17.480  10.219  1.00 63.00           N  
ATOM    742  CA  ASP    97     -10.858  18.070   9.026  1.00 64.24           C  
ATOM    743  C   ASP    97     -10.265  19.399   8.616  1.00 63.53           C  
ATOM    744  O   ASP    97      -9.943  19.574   7.468  1.00 63.50           O  
ATOM    745  CB  ASP    97     -12.379  18.258   9.201  1.00 65.15           C  
ATOM    746  CG  ASP    97     -13.150  16.958   9.125  1.00 71.53           C  
ATOM    747  OD1 ASP    97     -12.846  16.116   8.246  1.00 76.19           O  
ATOM    748  OD2 ASP    97     -14.106  16.798   9.921  1.00 80.54           O  
ATOM    749  N   ARG    98     -10.137  20.319   9.560  1.00 64.71           N  
ATOM    750  CA  ARG    98      -9.585  21.664   9.297  1.00 66.64           C  
ATOM    751  C   ARG    98      -8.117  21.652   8.884  1.00 65.82           C  
ATOM    752  O   ARG    98      -7.730  22.345   7.952  1.00 66.83           O  
ATOM    753  CB  ARG    98      -9.763  22.569  10.526  1.00 66.66           C  
ATOM    754  CG  ARG    98     -11.253  22.861  10.798  1.00 71.03           C  
ATOM    755  CD  ARG    98     -11.517  23.743  11.998  1.00 69.73           C  
ATOM    756  NE  ARG    98     -10.833  23.306  13.216  1.00 75.27           N  
ATOM    757  CZ  ARG    98     -11.032  23.817  14.430  1.00 77.58           C  
ATOM    758  NH1 ARG    98     -11.949  24.771  14.646  1.00 86.21           N  
ATOM    759  NH2 ARG    98     -10.327  23.344  15.457  1.00 76.48           N  
ATOM    760  N   LEU    99      -7.308  20.866   9.584  1.00 64.51           N  
ATOM    761  CA  LEU    99      -5.885  20.755   9.277  1.00 63.88           C  
ATOM    762  C   LEU    99      -5.584  19.870   8.068  1.00 63.94           C  
ATOM    763  O   LEU    99      -4.462  19.897   7.571  1.00 63.94           O  
ATOM    764  CB  LEU    99      -5.115  20.237  10.488  1.00 62.08           C  
ATOM    765  CG  LEU    99      -5.236  21.082  11.741  1.00 59.09           C  
ATOM    766  CD1 LEU    99      -4.488  20.403  12.860  1.00 62.82           C  
ATOM    767  CD2 LEU    99      -4.698  22.491  11.510  1.00 60.05           C  
ATOM    768  N   TRP   100      -6.563  19.093   7.604  1.00 64.23           N  
ATOM    769  CA  TRP   100      -6.368  18.208   6.457  1.00 64.94           C  
ATOM    770  C   TRP   100      -5.943  18.993   5.196  1.00 66.40           C  
ATOM    771  O   TRP   100      -6.492  20.062   4.904  1.00 66.40           O  
ATOM    772  CB  TRP   100      -7.647  17.416   6.134  1.00 63.32           C  
ATOM    773  CG  TRP   100      -7.401  16.171   5.391  1.00 60.10           C  
ATOM    774  CD1 TRP   100      -7.703  15.915   4.101  1.00 60.68           C  
ATOM    775  CD2 TRP   100      -6.792  14.995   5.907  1.00 56.49           C  
ATOM    776  NE1 TRP   100      -7.326  14.642   3.770  1.00 59.73           N  
ATOM    777  CE2 TRP   100      -6.761  14.052   4.866  1.00 58.04           C  
ATOM    778  CE3 TRP   100      -6.253  14.649   7.155  1.00 61.51           C  
ATOM    779  CZ2 TRP   100      -6.218  12.773   5.025  1.00 60.05           C  
ATOM    780  CZ3 TRP   100      -5.722  13.370   7.323  1.00 62.28           C  
ATOM    781  CH2 TRP   100      -5.711  12.446   6.257  1.00 61.37           C  
ATOM    782  N   ASN   101      -4.936  18.470   4.507  1.00 67.33           N  
ATOM    783  CA  ASN   101      -4.440  19.036   3.242  1.00 68.25           C  
ATOM    784  C   ASN   101      -3.796  17.912   2.420  1.00 68.25           C  
ATOM    785  O   ASN   101      -3.561  16.831   2.975  1.00 67.18           O  
ATOM    786  CB  ASN   101      -3.521  20.244   3.506  1.00 68.78           C  
ATOM    787  CG  ASN   101      -2.252  19.891   4.277  1.00 70.98           C  
ATOM    788  OD1 ASN   101      -1.543  18.923   3.967  1.00 73.81           O  
ATOM    789  ND2 ASN   101      -1.942  20.711   5.265  1.00 69.56           N  
ATOM    790  N   PRO   102      -3.482  18.158   1.120  1.00 69.56           N  
ATOM    791  CA  PRO   102      -2.961  17.054   0.312  1.00 69.80           C  
ATOM    792  C   PRO   102      -1.602  16.513   0.768  1.00 69.69           C  
ATOM    793  O   PRO   102      -1.349  15.316   0.605  1.00 68.78           O  
ATOM    794  CB  PRO   102      -2.912  17.648  -1.100  1.00 71.45           C  
ATOM    795  CG  PRO   102      -3.715  18.929  -1.024  1.00 71.12           C  
ATOM    796  CD  PRO   102      -3.516  19.407   0.334  1.00 69.40           C  
ATOM    797  N   TYR   103      -0.779  17.369   1.396  1.00 70.60           N  
ATOM    798  CA  TYR   103       0.528  16.945   1.919  1.00 71.40           C  
ATOM    799  C   TYR   103       0.273  15.894   3.022  1.00 71.59           C  
ATOM    800  O   TYR   103       0.827  14.796   2.953  1.00 72.12           O  
ATOM    801  CB  TYR   103       1.380  18.111   2.457  1.00 73.01           C  
ATOM    802  CG  TYR   103       1.556  19.319   1.541  1.00 74.63           C  
ATOM    803  CD1 TYR   103       2.579  19.359   0.586  1.00 79.83           C  
ATOM    804  CD2 TYR   103       0.718  20.452   1.662  1.00 77.56           C  
ATOM    805  CE1 TYR   103       2.757  20.503  -0.267  1.00 79.67           C  
ATOM    806  CE2 TYR   103       0.880  21.594   0.828  1.00 76.18           C  
ATOM    807  CZ  TYR   103       1.906  21.615  -0.131  1.00 78.35           C  
ATOM    808  OH  TYR   103       2.081  22.714  -0.952  1.00 74.78           O  
ATOM    809  N   VAL   104      -0.611  16.207   3.979  1.00 71.00           N  
ATOM    810  CA  VAL   104      -0.982  15.253   5.050  1.00 71.32           C  
ATOM    811  C   VAL   104      -1.676  14.042   4.448  1.00 71.94           C  
ATOM    812  O   VAL   104      -1.395  12.913   4.856  1.00 72.55           O  
ATOM    813  CB  VAL   104      -1.908  15.868   6.153  1.00 70.76           C  
ATOM    814  CG1 VAL   104      -2.369  14.799   7.148  1.00 69.40           C  
ATOM    815  CG2 VAL   104      -1.195  16.957   6.879  1.00 72.76           C  
ATOM    816  N   ALA   105      -2.593  14.289   3.504  1.00 72.51           N  
ATOM    817  CA  ALA   105      -3.296  13.226   2.771  1.00 74.46           C  
ATOM    818  C   ALA   105      -2.313  12.167   2.258  1.00 75.45           C  
ATOM    819  O   ALA   105      -2.558  10.970   2.436  1.00 76.15           O  
ATOM    820  CB  ALA   105      -4.096  13.809   1.599  1.00 73.94           C  
ATOM    821  N   ALA   106      -1.196  12.631   1.676  1.00 75.72           N  
ATOM    822  CA  ALA   106      -0.115  11.769   1.161  1.00 76.68           C  
ATOM    823  C   ALA   106       0.417  10.723   2.155  1.00 77.50           C  
ATOM    824  O   ALA   106       0.709   9.598   1.754  1.00 78.04           O  
ATOM    825  CB  ALA   106       1.062  12.632   0.649  1.00 76.97           C  
ATOM    826  N   TRP   107       0.529  11.090   3.433  1.00 78.25           N  
ATOM    827  CA  TRP   107       1.049  10.169   4.467  1.00 79.00           C  
ATOM    828  C   TRP   107       0.102   9.052   4.890  1.00 78.50           C  
ATOM    829  O   TRP   107       0.565   8.098   5.518  1.00 78.90           O  
ATOM    830  CB  TRP   107       1.476  10.925   5.735  1.00 81.75           C  
ATOM    831  CG  TRP   107       2.578  11.855   5.503  1.00 85.01           C  
ATOM    832  CD1 TRP   107       2.472  13.167   5.177  1.00 88.16           C  
ATOM    833  CD2 TRP   107       3.974  11.559   5.560  1.00 88.53           C  
ATOM    834  NE1 TRP   107       3.719  13.726   5.022  1.00 89.70           N  
ATOM    835  CE2 TRP   107       4.666  12.763   5.255  1.00 92.17           C  
ATOM    836  CE3 TRP   107       4.718  10.396   5.839  1.00 88.93           C  
ATOM    837  CZ2 TRP   107       6.084  12.843   5.228  1.00 91.14           C  
ATOM    838  CZ3 TRP   107       6.137  10.467   5.806  1.00 88.41           C  
ATOM    839  CH2 TRP   107       6.797  11.688   5.499  1.00 88.94           C  
ATOM    840  N   TYR   108      -1.190   9.156   4.569  1.00 77.70           N  
ATOM    841  CA  TYR   108      -2.183   8.176   5.020  1.00 77.58           C  
ATOM    842  C   TYR   108      -2.958   7.561   3.853  1.00 78.24           C  
ATOM    843  O   TYR   108      -3.724   8.266   3.183  1.00 78.55           O  
ATOM    844  CB  TYR   108      -3.168   8.840   5.999  1.00 76.95           C  
ATOM    845  CG  TYR   108      -2.543   9.466   7.239  1.00 75.66           C  
ATOM    846  CD1 TYR   108      -2.285   8.702   8.386  1.00 74.93           C  
ATOM    847  CD2 TYR   108      -2.242  10.831   7.280  1.00 73.90           C  
ATOM    848  CE1 TYR   108      -1.713   9.278   9.538  1.00 73.25           C  
ATOM    849  CE2 TYR   108      -1.677  11.424   8.432  1.00 75.10           C  
ATOM    850  CZ  TYR   108      -1.418  10.639   9.556  1.00 73.87           C  
ATOM    851  OH  TYR   108      -0.877  11.208  10.686  1.00 71.72           O  
ATOM    852  N   GLU   109      -2.759   6.256   3.622  1.00 78.29           N  
ATOM    853  CA  GLU   109      -3.483   5.521   2.577  1.00 78.32           C  
ATOM    854  C   GLU   109      -4.983   5.426   2.914  1.00 78.59           C  
ATOM    855  O   GLU   109      -5.822   5.547   2.021  1.00 79.15           O  
ATOM    856  CB  GLU   109      -2.895   4.118   2.367  1.00 78.53           C  
ATOM    857  N   GLY   110      -5.307   5.230   4.198  1.00 78.33           N  
ATOM    858  CA  GLY   110      -6.699   5.168   4.674  1.00 77.97           C  
ATOM    859  C   GLY   110      -7.416   6.508   4.868  1.00 77.86           C  
ATOM    860  O   GLY   110      -8.599   6.516   5.253  1.00 77.81           O  
ATOM    861  N   GLY   111      -6.713   7.627   4.626  1.00 77.37           N  
ATOM    862  CA  GLY   111      -7.273   8.973   4.753  1.00 76.88           C  
ATOM    863  C   GLY   111      -7.530   9.338   6.201  1.00 76.06           C  
ATOM    864  O   GLY   111      -6.775   8.942   7.078  1.00 76.40           O  
ATOM    865  N   LYS   112      -8.615  10.066   6.443  1.00 75.40           N  
ATOM    866  CA  LYS   112      -9.004  10.499   7.793  1.00 75.45           C  
ATOM    867  C   LYS   112      -9.533   9.346   8.669  1.00 76.00           C  
ATOM    868  O   LYS   112      -9.520   9.440   9.906  1.00 76.72           O  
ATOM    869  CB  LYS   112     -10.073  11.591   7.711  1.00 75.43           C  
ATOM    870  CG  LYS   112      -9.662  12.859   6.981  1.00 74.16           C  
ATOM    871  CD  LYS   112     -10.866  13.731   6.775  1.00 74.95           C  
ATOM    872  CE  LYS   112     -10.520  14.996   6.064  1.00 76.57           C  
ATOM    873  NZ  LYS   112     -11.749  15.771   5.752  1.00 82.34           N  
ATOM    874  N   ASP   113     -10.034   8.295   8.025  1.00 75.85           N  
ATOM    875  CA  ASP   113     -10.531   7.089   8.701  1.00 76.36           C  
ATOM    876  C   ASP   113      -9.419   6.097   9.050  1.00 76.13           C  
ATOM    877  O   ASP   113      -9.698   5.091   9.718  1.00 75.33           O  
ATOM    878  CB  ASP   113     -11.555   6.366   7.811  1.00 77.25           C  
ATOM    879  CG  ASP   113     -12.774   7.212   7.529  1.00 79.58           C  
ATOM    880  OD1 ASP   113     -13.497   7.558   8.498  1.00 80.73           O  
ATOM    881  OD2 ASP   113     -13.026   7.506   6.337  1.00 82.08           O  
ATOM    882  N   ASP   114      -8.188   6.359   8.578  1.00 76.33           N  
ATOM    883  CA  ASP   114      -7.018   5.509   8.839  1.00 76.24           C  
ATOM    884  C   ASP   114      -6.921   5.261  10.363  1.00 76.47           C  
ATOM    885  O   ASP   114      -6.805   6.235  11.123  1.00 76.72           O  
ATOM    886  CB  ASP   114      -5.731   6.165   8.295  1.00 76.13           C  
ATOM    887  CG  ASP   114      -4.517   5.220   8.278  1.00 76.90           C  
ATOM    888  OD1 ASP   114      -4.320   4.422   9.229  1.00 77.06           O  
ATOM    889  OD2 ASP   114      -3.726   5.312   7.302  1.00 76.48           O  
ATOM    890  N   PRO   115      -7.053   3.979  10.813  1.00 76.23           N  
ATOM    891  CA  PRO   115      -6.917   3.620  12.241  1.00 75.60           C  
ATOM    892  C   PRO   115      -5.544   3.998  12.811  1.00 75.10           C  
ATOM    893  O   PRO   115      -5.455   4.418  13.978  1.00 74.61           O  
ATOM    894  CB  PRO   115      -7.089   2.098  12.244  1.00 75.83           C  
ATOM    895  CG  PRO   115      -7.773   1.789  10.988  1.00 76.33           C  
ATOM    896  CD  PRO   115      -7.345   2.783   9.999  1.00 76.11           C  
ATOM    897  N   LYS   116      -4.503   3.888  11.970  1.00 74.15           N  
ATOM    898  CA  LYS   116      -3.137   4.270  12.319  1.00 73.62           C  
ATOM    899  C   LYS   116      -2.886   5.793  12.175  1.00 73.82           C  
ATOM    900  O   LYS   116      -1.837   6.193  11.660  1.00 74.05           O  
ATOM    901  CB  LYS   116      -2.134   3.488  11.457  1.00 73.64           C  
ATOM    902  N   LEU   117      -3.836   6.627  12.627  1.00 72.81           N  
ATOM    903  CA  LEU   117      -3.703   8.090  12.600  1.00 72.20           C  
ATOM    904  C   LEU   117      -3.889   8.641  14.013  1.00 70.18           C  
ATOM    905  O   LEU   117      -4.798   8.224  14.761  1.00 70.07           O  
ATOM    906  CB  LEU   117      -4.690   8.779  11.622  1.00 72.07           C  
ATOM    907  CG  LEU   117      -4.478  10.312  11.431  1.00 71.77           C  
ATOM    908  CD1 LEU   117      -4.834  10.788  10.027  1.00 70.09           C  
ATOM    909  CD2 LEU   117      -5.202  11.157  12.477  1.00 65.73           C  
ATOM    910  N   ALA   118      -3.007   9.582  14.347  1.00 68.08           N  
ATOM    911  CA  ALA   118      -3.020  10.297  15.612  1.00 65.82           C  
ATOM    912  C   ALA   118      -2.637  11.745  15.329  1.00 63.61           C  
ATOM    913  O   ALA   118      -1.849  12.033  14.426  1.00 61.85           O  
ATOM    914  CB  ALA   118      -2.051   9.666  16.594  1.00 64.77           C  
ATOM    915  N   LEU   119      -3.225  12.638  16.106  1.00 62.76           N  
ATOM    916  CA  LEU   119      -2.966  14.050  16.023  1.00 61.29           C  
ATOM    917  C   LEU   119      -2.557  14.502  17.420  1.00 62.26           C  
ATOM    918  O   LEU   119      -3.339  14.377  18.364  1.00 63.42           O  
ATOM    919  CB  LEU   119      -4.235  14.755  15.566  1.00 60.40           C  
ATOM    920  CG  LEU   119      -4.172  16.242  15.293  1.00 59.44           C  
ATOM    921  CD1 LEU   119      -3.043  16.591  14.297  1.00 52.48           C  
ATOM    922  CD2 LEU   119      -5.552  16.736  14.813  1.00 59.31           C  
ATOM    923  N   LEU   120      -1.327  14.991  17.549  1.00 61.72           N  
ATOM    924  CA  LEU   120      -0.807  15.499  18.812  1.00 61.86           C  
ATOM    925  C   LEU   120      -0.988  17.008  18.872  1.00 61.72           C  
ATOM    926  O   LEU   120      -0.861  17.664  17.838  1.00 61.15           O  
ATOM    927  CB  LEU   120       0.696  15.185  18.941  1.00 61.56           C  
ATOM    928  CG  LEU   120       1.129  13.731  18.723  1.00 60.31           C  
ATOM    929  CD1 LEU   120       2.615  13.582  19.060  1.00 56.29           C  
ATOM    930  CD2 LEU   120       0.279  12.778  19.543  1.00 55.20           C  
ATOM    931  N   ARG   121      -1.297  17.544  20.061  1.00 61.18           N  
ATOM    932  CA  ARG   121      -1.330  19.005  20.282  1.00 61.97           C  
ATOM    933  C   ARG   121      -0.284  19.405  21.302  1.00 61.10           C  
ATOM    934  O   ARG   121      -0.164  18.793  22.366  1.00 60.42           O  
ATOM    935  CB  ARG   121      -2.700  19.574  20.687  1.00 61.52           C  
ATOM    936  CG  ARG   121      -3.293  19.113  21.975  1.00 63.20           C  
ATOM    937  CD  ARG   121      -4.717  19.648  22.120  1.00 63.33           C  
ATOM    938  NE  ARG   121      -4.812  21.045  22.572  1.00 65.57           N  
ATOM    939  CZ  ARG   121      -5.927  21.786  22.566  1.00 62.63           C  
ATOM    940  NH1 ARG   121      -7.074  21.337  22.059  1.00 63.35           N  
ATOM    941  NH2 ARG   121      -5.888  23.032  23.023  1.00 59.07           N  
ATOM    942  N   LEU   122       0.483  20.429  20.934  1.00 60.61           N  
ATOM    943  CA  LEU   122       1.454  21.029  21.778  1.00 59.91           C  
ATOM    944  C   LEU   122       0.805  22.339  22.176  1.00 61.19           C  
ATOM    945  O   LEU   122       0.557  23.218  21.323  1.00 62.19           O  
ATOM    946  CB  LEU   122       2.773  21.234  21.057  1.00 60.23           C  
ATOM    947  CG  LEU   122       3.875  22.062  21.736  1.00 61.37           C  
ATOM    948  CD1 LEU   122       4.141  21.611  23.143  1.00 61.75           C  
ATOM    949  CD2 LEU   122       5.153  21.980  20.891  1.00 60.34           C  
ATOM    950  N   ASP   123       0.434  22.421  23.452  1.00 60.69           N  
ATOM    951  CA  ASP   123      -0.089  23.641  24.028  1.00 61.57           C  
ATOM    952  C   ASP   123       1.141  24.364  24.504  1.00 61.00           C  
ATOM    953  O   ASP   123       1.729  23.994  25.507  1.00 62.72           O  
ATOM    954  CB  ASP   123      -1.094  23.326  25.130  1.00 62.91           C  
ATOM    955  CG  ASP   123      -2.431  22.963  24.555  1.00 66.49           C  
ATOM    956  OD1 ASP   123      -3.034  23.882  23.953  1.00 63.57           O  
ATOM    957  OD2 ASP   123      -2.848  21.793  24.682  1.00 67.70           O  
ATOM    958  N   ALA   124       1.557  25.351  23.721  1.00 62.14           N  
ATOM    959  CA  ALA   124       2.829  26.072  23.923  1.00 62.86           C  
ATOM    960  C   ALA   124       2.719  27.054  25.049  1.00 63.49           C  
ATOM    961  O   ALA   124       1.792  27.847  25.100  1.00 64.38           O  
ATOM    962  CB  ALA   124       3.260  26.792  22.634  1.00 61.47           C  
ATOM    963  N   ASP   125       3.674  27.000  25.958  1.00 64.30           N  
ATOM    964  CA  ASP   125       3.694  27.897  27.090  1.00 64.07           C  
ATOM    965  C   ASP   125       4.555  29.133  26.771  1.00 64.53           C  
ATOM    966  O   ASP   125       4.117  30.277  26.904  1.00 64.73           O  
ATOM    967  CB  ASP   125       4.234  27.152  28.303  1.00 63.65           C  
ATOM    968  CG  ASP   125       4.373  28.044  29.479  1.00 66.71           C  
ATOM    969  OD1 ASP   125       3.326  28.563  29.916  1.00 70.42           O  
ATOM    970  OD2 ASP   125       5.520  28.256  29.920  1.00 67.28           O  
ATOM    971  N   HIS   126       5.806  28.883  26.419  1.00 65.57           N  
ATOM    972  CA  HIS   126       6.746  29.952  26.070  1.00 65.43           C  
ATOM    973  C   HIS   126       7.822  29.426  25.142  1.00 64.29           C  
ATOM    974  O   HIS   126       7.908  28.223  24.892  1.00 63.35           O  
ATOM    975  CB  HIS   126       7.361  30.584  27.332  1.00 65.55           C  
ATOM    976  CG  HIS   126       8.323  29.708  28.080  1.00 66.47           C  
ATOM    977  ND1 HIS   126       7.923  28.833  29.065  1.00 67.28           N  
ATOM    978  CD2 HIS   126       9.676  29.622  28.029  1.00 68.42           C  
ATOM    979  CE1 HIS   126       8.981  28.211  29.556  1.00 67.71           C  
ATOM    980  NE2 HIS   126      10.059  28.681  28.956  1.00 67.36           N  
ATOM    981  N   ALA   127       8.617  30.347  24.624  1.00 63.66           N  
ATOM    982  CA  ALA   127       9.755  30.017  23.787  1.00 63.18           C  
ATOM    983  C   ALA   127      10.903  30.936  24.025  1.00 62.13           C  
ATOM    984  O   ALA   127      10.699  32.131  24.256  1.00 61.43           O  
ATOM    985  CB  ALA   127       9.401  30.070  22.294  1.00 63.21           C  
ATOM    986  N   GLN   128      12.109  30.375  23.930  1.00 61.22           N  
ATOM    987  CA  GLN   128      13.310  31.173  23.934  1.00 61.80           C  
ATOM    988  C   GLN   128      13.686  31.276  22.469  1.00 60.96           C  
ATOM    989  O   GLN   128      13.774  30.260  21.792  1.00 60.64           O  
ATOM    990  CB  GLN   128      14.403  30.566  24.774  1.00 62.50           C  
ATOM    991  CG  GLN   128      15.552  31.516  24.945  1.00 66.72           C  
ATOM    992  CD  GLN   128      16.469  31.161  26.095  1.00 70.40           C  
ATOM    993  OE1 GLN   128      16.385  30.075  26.675  1.00 67.31           O  
ATOM    994  NE2 GLN   128      17.377  32.081  26.412  1.00 65.37           N  
ATOM    995  N   ILE   129      13.879  32.509  21.990  1.00 60.87           N  
ATOM    996  CA  ILE   129      14.139  32.804  20.583  1.00 59.58           C  
ATOM    997  C   ILE   129      15.507  33.475  20.424  1.00 60.07           C  
ATOM    998  O   ILE   129      15.780  34.501  21.060  1.00 60.01           O  
ATOM    999  CB  ILE   129      13.028  33.749  20.040  1.00 59.53           C  
ATOM   1000  CG1 ILE   129      11.651  33.068  20.090  1.00 58.16           C  
ATOM   1001  CG2 ILE   129      13.336  34.198  18.609  1.00 56.19           C  
ATOM   1002  CD1 ILE   129      10.470  34.066  19.975  1.00 59.27           C  
ATOM   1003  N   TRP   130      16.347  32.876  19.580  1.00 60.50           N  
ATOM   1004  CA  TRP   130      17.684  33.370  19.236  1.00 60.23           C  
ATOM   1005  C   TRP   130      17.721  33.703  17.748  1.00 60.63           C  
ATOM   1006  O   TRP   130      17.531  32.811  16.898  1.00 62.63           O  
ATOM   1007  CB  TRP   130      18.751  32.307  19.454  1.00 59.73           C  
ATOM   1008  CG  TRP   130      18.931  31.827  20.827  1.00 62.03           C  
ATOM   1009  CD1 TRP   130      19.893  32.210  21.698  1.00 60.85           C  
ATOM   1010  CD2 TRP   130      18.178  30.795  21.486  1.00 64.35           C  
ATOM   1011  NE1 TRP   130      19.780  31.513  22.862  1.00 60.14           N  
ATOM   1012  CE2 TRP   130      18.740  30.631  22.767  1.00 62.71           C  
ATOM   1013  CE3 TRP   130      17.101  29.976  21.106  1.00 62.95           C  
ATOM   1014  CZ2 TRP   130      18.252  29.687  23.696  1.00 64.49           C  
ATOM   1015  CZ3 TRP   130      16.620  29.038  22.023  1.00 61.66           C  
ATOM   1016  CH2 TRP   130      17.190  28.906  23.307  1.00 62.93           C  
ATOM   1017  N   LEU   131      17.936  34.971  17.435  1.00 60.43           N  
ATOM   1018  CA  LEU   131      18.156  35.403  16.058  1.00 60.89           C  
ATOM   1019  C   LEU   131      19.648  35.171  15.734  1.00 61.72           C  
ATOM   1020  O   LEU   131      20.522  35.294  16.604  1.00 60.15           O  
ATOM   1021  CB  LEU   131      17.815  36.875  15.870  1.00 58.93           C  
ATOM   1022  CG  LEU   131      16.405  37.315  16.295  1.00 61.09           C  
ATOM   1023  CD1 LEU   131      16.237  38.841  16.084  1.00 49.80           C  
ATOM   1024  CD2 LEU   131      15.306  36.515  15.580  1.00 53.92           C  
ATOM   1025  N   ASN   132      19.921  34.791  14.490  1.00 62.74           N  
ATOM   1026  CA  ASN   132      21.279  34.608  14.027  1.00 63.75           C  
ATOM   1027  C   ASN   132      21.623  35.951  13.364  1.00 65.20           C  
ATOM   1028  O   ASN   132      21.063  36.292  12.333  1.00 66.63           O  
ATOM   1029  CB  ASN   132      21.339  33.424  13.067  1.00 63.10           C  
ATOM   1030  CG  ASN   132      22.756  32.937  12.771  1.00 64.38           C  
ATOM   1031  OD1 ASN   132      23.739  33.313  13.410  1.00 66.90           O  
ATOM   1032  ND2 ASN   132      22.847  32.049  11.799  1.00 65.55           N  
ATOM   1033  N   GLY   133      22.472  36.738  14.019  1.00 65.89           N  
ATOM   1034  CA  GLY   133      22.928  38.033  13.513  1.00 65.80           C  
ATOM   1035  C   GLY   133      24.273  37.866  12.840  1.00 65.28           C  
ATOM   1036  O   GLY   133      24.550  36.815  12.252  1.00 66.27           O  
ATOM   1037  N   SER   134      25.112  38.891  12.925  1.00 64.55           N  
ATOM   1038  CA  SER   134      26.453  38.833  12.348  1.00 64.53           C  
ATOM   1039  C   SER   134      27.446  39.623  13.187  1.00 64.39           C  
ATOM   1040  O   SER   134      27.038  40.511  13.912  1.00 64.78           O  
ATOM   1041  CB  SER   134      26.413  39.349  10.905  1.00 64.99           C  
ATOM   1042  OG  SER   134      26.081  40.730  10.848  1.00 65.96           O  
ATOM   1043  N   SER   135      28.729  39.267  13.116  1.00 64.44           N  
ATOM   1044  CA  SER   135      29.785  39.989  13.830  1.00 65.34           C  
ATOM   1045  C   SER   135      30.841  40.437  12.807  1.00 63.57           C  
ATOM   1046  O   SER   135      31.427  39.600  12.109  1.00 63.08           O  
ATOM   1047  CB  SER   135      30.426  39.147  14.963  1.00 66.54           C  
ATOM   1048  OG  SER   135      31.524  38.337  14.532  1.00 70.43           O  
ATOM   1049  N   LEU   136      31.081  41.746  12.736  1.00 61.69           N  
ATOM   1050  CA  LEU   136      32.059  42.296  11.812  1.00 61.12           C  
ATOM   1051  C   LEU   136      33.433  42.072  12.430  1.00 59.81           C  
ATOM   1052  O   LEU   136      33.646  42.445  13.582  1.00 60.39           O  
ATOM   1053  CB  LEU   136      31.823  43.796  11.594  1.00 61.14           C  
ATOM   1054  CG  LEU   136      32.442  44.352  10.313  1.00 61.78           C  
ATOM   1055  CD1 LEU   136      31.538  44.017   9.124  1.00 59.14           C  
ATOM   1056  CD2 LEU   136      32.657  45.865  10.408  1.00 61.99           C  
ATOM   1057  N   LEU   137      34.342  41.435  11.694  1.00 58.51           N  
ATOM   1058  CA  LEU   137      35.707  41.216  12.179  1.00 58.04           C  
ATOM   1059  C   LEU   137      36.523  42.492  12.002  1.00 57.44           C  
ATOM   1060  O   LEU   137      36.082  43.443  11.352  1.00 57.36           O  
ATOM   1061  CB  LEU   137      36.422  40.064  11.452  1.00 58.32           C  
ATOM   1062  CG  LEU   137      35.743  38.699  11.251  1.00 59.84           C  
ATOM   1063  CD1 LEU   137      36.827  37.625  11.029  1.00 60.58           C  
ATOM   1064  CD2 LEU   137      34.883  38.315  12.395  1.00 60.91           C  
ATOM   1065  N   ALA   138      37.714  42.499  12.595  1.00 57.39           N  
ATOM   1066  CA  ALA   138      38.658  43.610  12.468  1.00 57.25           C  
ATOM   1067  C   ALA   138      39.122  43.692  11.017  1.00 57.29           C  
ATOM   1068  O   ALA   138      39.334  42.657  10.371  1.00 56.94           O  
ATOM   1069  CB  ALA   138      39.857  43.420  13.392  1.00 56.76           C  
ATOM   1070  N   GLY   139      39.247  44.917  10.509  1.00 57.45           N  
ATOM   1071  CA  GLY   139      39.658  45.141   9.138  1.00 57.98           C  
ATOM   1072  C   GLY   139      41.117  44.779   8.936  1.00 59.06           C  
ATOM   1073  O   GLY   139      41.933  44.939   9.852  1.00 59.88           O  
ATOM   1074  N   ILE   140      41.433  44.283   7.740  1.00 59.80           N  
ATOM   1075  CA  ILE   140      42.794  43.886   7.364  1.00 59.77           C  
ATOM   1076  C   ILE   140      43.141  44.612   6.080  1.00 60.20           C  
ATOM   1077  O   ILE   140      42.533  44.341   5.040  1.00 59.84           O  
ATOM   1078  CB  ILE   140      42.888  42.359   7.163  1.00 59.89           C  
ATOM   1079  CG1 ILE   140      42.524  41.634   8.472  1.00 59.59           C  
ATOM   1080  CG2 ILE   140      44.284  41.959   6.679  1.00 57.61           C  
ATOM   1081  CD1 ILE   140      42.558  40.124   8.388  1.00 60.05           C  
ATOM   1082  N   LYS   141      44.089  45.550   6.166  1.00 61.05           N  
ATOM   1083  CA  LYS   141      44.551  46.308   5.004  1.00 61.39           C  
ATOM   1084  C   LYS   141      45.505  45.436   4.196  1.00 61.80           C  
ATOM   1085  O   LYS   141      46.435  44.863   4.758  1.00 61.94           O  
ATOM   1086  CB  LYS   141      45.220  47.636   5.395  1.00 61.26           C  
ATOM   1087  CG  LYS   141      44.261  48.637   6.051  1.00 60.97           C  
ATOM   1088  CD  LYS   141      44.626  50.104   5.782  1.00 62.29           C  
ATOM   1089  CE  LYS   141      45.887  50.578   6.490  1.00 64.00           C  
ATOM   1090  NZ  LYS   141      45.648  50.668   7.955  1.00 66.94           N  
ATOM   1091  N   VAL   142      45.263  45.347   2.886  1.00 62.47           N  
ATOM   1092  CA  VAL   142      46.056  44.518   1.960  1.00 62.73           C  
ATOM   1093  C   VAL   142      46.397  45.304   0.688  1.00 62.79           C  
ATOM   1094  O   VAL   142      45.686  46.247   0.341  1.00 63.25           O  
ATOM   1095  CB  VAL   142      45.279  43.192   1.617  1.00 62.84           C  
ATOM   1096  CG1 VAL   142      43.942  43.483   0.942  1.00 61.54           C  
ATOM   1097  CG2 VAL   142      46.118  42.251   0.754  1.00 62.99           C  
ATOM   1098  N   LEU   143      47.503  44.942   0.031  1.00 62.93           N  
ATOM   1099  CA  LEU   143      47.899  45.541  -1.257  1.00 62.76           C  
ATOM   1100  C   LEU   143      47.322  44.669  -2.384  1.00 63.19           C  
ATOM   1101  O   LEU   143      47.264  43.442  -2.251  1.00 63.43           O  
ATOM   1102  CB  LEU   143      49.418  45.684  -1.374  1.00 62.31           C  
ATOM   1103  CG  LEU   143      50.110  46.684  -0.431  1.00 61.86           C  
ATOM   1104  CD1 LEU   143      51.635  46.657  -0.621  1.00 56.90           C  
ATOM   1105  CD2 LEU   143      49.587  48.107  -0.615  1.00 60.19           C  
ATOM   1106  N   LEU   144      46.890  45.314  -3.474  1.00 63.28           N  
ATOM   1107  CA  LEU   144      46.237  44.652  -4.623  1.00 63.02           C  
ATOM   1108  C   LEU   144      47.069  44.717  -5.899  1.00 62.91           C  
ATOM   1109  O   LEU   144      47.958  45.564  -6.018  1.00 63.42           O  
ATOM   1110  CB  LEU   144      44.884  45.320  -4.886  1.00 63.08           C  
ATOM   1111  CG  LEU   144      43.824  45.246  -3.788  1.00 60.34           C  
ATOM   1112  CD1 LEU   144      42.664  46.175  -4.098  1.00 57.50           C  
ATOM   1113  CD2 LEU   144      43.346  43.822  -3.622  1.00 61.41           C  
ATOM   1114  N   GLY   145      46.763  43.832  -6.853  1.00 62.92           N  
ATOM   1115  CA  GLY   145      47.483  43.799  -8.134  1.00 63.90           C  
ATOM   1116  C   GLY   145      47.247  42.592  -9.027  1.00 64.09           C  
ATOM   1117  O   GLY   145      47.895  42.477 -10.091  1.00 63.32           O  
END
