
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  175 ( 1346),  selected  175 , name 2ou5_A
# Molecule2: number of CA atoms  145 ( 1098),  selected  145 , name T0497.pdb
# PARAMETERS: 2ou5_A.T0497.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    G     0_A      -       -           -
LGA    X     1_A      -       -           -
LGA    S     2_A      -       -           -
LGA    D     3_A      -       -           -
LGA    T     4_A      M       1          5.593
LGA    V     5_A      A       2          3.637
LGA    L     6_A      D       3          1.470
LGA    T     7_A      P       4           #
LGA    -       -      K       5           -
LGA    G     8_A      E       6          1.470
LGA    L     9_A      L       7          2.030
LGA    L    10_A      Q       8          1.783
LGA    D    11_A      D       9          0.872
LGA    T    12_A      K      10          0.770
LGA    V    13_A      F      11          0.855
LGA    W    14_A      W      12          0.970
LGA    Q    15_A      K      13          0.823
LGA    Q    16_A      A      14          0.721
LGA    F    17_A      L      15          1.390
LGA    G    18_A      K      16          1.962
LGA    R    19_A      S      17          1.287
LGA    G    20_A      D      18          2.658
LGA    T    21_A      -       -           -
LGA    K    22_A      -       -           -
LGA    D    23_A      -       -           -
LGA    R    24_A      -       -           -
LGA    H    25_A      -       -           -
LGA    H    26_A      -       -           -
LGA    P    27_A      -       -           -
LGA    A    28_A      -       -           -
LGA    R    29_A      R      19          2.754
LGA    H    30_A      T      20          2.054
LGA    P    31_A      V      21          1.735
LGA    T    32_A      M      22          1.030
LGA    L    33_A      L      23          1.043
LGA    A    34_A      G      24          0.981
LGA    T    35_A      L      25          1.487
LGA    I    36_A      D      26          4.664
LGA    -       -      G      27           -
LGA    G    37_A      V      28           #
LGA    T    38_A      -       -           -
LGA    D    39_A      E      29          3.713
LGA    G    40_A      D      30          2.914
LGA    P    41_A      G      31          1.957
LGA    D    42_A      H      32          2.124
LGA    L    43_A      A      33          0.397
LGA    R    44_A      R      34          0.343
LGA    T    45_A      P      35          1.027
LGA    L    46_A      M      36          1.064
LGA    V    47_A      T      37          1.819
LGA    L    48_A      A      38          2.184
LGA    R    49_A      Q      39          2.992
LGA    A    50_A      I      40          2.711
LGA    A    51_A      E      41          4.983
LGA    S    52_A      G      42          5.066
LGA    H    53_A      D      43          5.845
LGA    A    54_A      S      44          5.094
LGA    E    55_A      G      45          3.909
LGA    A    56_A      G      46          2.679
LGA    T    57_A      P      47          2.032
LGA    L    58_A      I      48          1.001
LGA    E    59_A      W      49          0.728
LGA    F    60_A      F      50          0.617
LGA    H    61_A      F      51          0.870
LGA    T    62_A      T      52          1.291
LGA    D    63_A      S      53          1.843
LGA    A    64_A      K      54          2.283
LGA    A    65_A      D      55          2.914
LGA    S    66_A      N      56          2.245
LGA    P    67_A      A      57          1.444
LGA    K    68_A      L      58          1.233
LGA    V    69_A      I      59          0.357
LGA    A    70_A      A      60          1.121
LGA    H    71_A      M      61          2.275
LGA    I    72_A      L      62          1.806
LGA    R    73_A      G      63          2.506
LGA    R    74_A      Q      64           -
LGA    D    75_A      G      65          5.565
LGA    A    76_A      R      66          1.338
LGA    R    77_A      R      67          0.861
LGA    V    78_A      V      68          1.151
LGA    A    79_A      I      69          1.413
LGA    I    80_A      G      70          1.140
LGA    H    81_A      A      71          1.439
LGA    I    82_A      F      72          1.530
LGA    W    83_A      S      73          2.127
LGA    I    84_A      S      74          2.552
LGA    P    85_A      K      75          5.568
LGA    K    86_A      G      76          1.716
LGA    A    87_A      H      77          4.558
LGA    S    88_A      D      78          1.736
LGA    L    89_A      L      79          1.189
LGA    Q    90_A      F      80          0.843
LGA    V    91_A      A      81          1.035
LGA    R    92_A      S      82          0.724
LGA    A    93_A      I      83          0.350
LGA    K    94_A      S      84          0.297
LGA    A    95_A      G      85          1.014
LGA    I    96_A      S      86          0.726
LGA    A    97_A      L      87          1.341
LGA    K    98_A      R      88          2.651
LGA    I    99_A      E      89          0.927
LGA    L   100_A      D      90          1.167
LGA    P   101_A      T      91          1.870
LGA    G   102_A      D      92          4.678
LGA    -       -      P      93           -
LGA    -       -      A      94           -
LGA    D   103_A      V      95           #
LGA    P   104_A      V      96           #
LGA    N   105_A      -       -           -
LGA    L   106_A      D      97          4.544
LGA    F   107_A      R      98           -
LGA    A   108_A      L      99           -
LGA    Q   109_A      W     100           -
LGA    L   110_A      N     101           #
LGA    -       -      P     102           -
LGA    -       -      Y     103           -
LGA    -       -      V     104           -
LGA    P   111_A      A     105           #
LGA    E   112_A      A     106           #
LGA    A   113_A      -       -           -
LGA    A   114_A      W     107          2.442
LGA    R   115_A      Y     108          1.969
LGA    X   116_A      E     109          4.321
LGA    N   117_A      G     110           -
LGA    -       -      G     111           -
LGA    -       -      K     112           -
LGA    -       -      D     113           -
LGA    Y   118_A      D     114          5.347
LGA    Q   119_A      -       -           -
LGA    G   120_A      -       -           -
LGA    P   121_A      -       -           -
LGA    V   122_A      -       -           -
LGA    P   123_A      -       -           -
LGA    G   124_A      -       -           -
LGA    T   125_A      -       -           -
LGA    P   126_A      -       -           -
LGA    L   127_A      -       -           -
LGA    P   128_A      -       -           -
LGA    A   129_A      -       -           -
LGA    E   130_A      -       -           -
LGA    P   131_A      -       -           -
LGA    D   132_A      -       -           -
LGA    A   133_A      -       -           -
LGA    T   134_A      -       -           -
LGA    P   135_A      -       -           -
LGA    N   136_A      P     115          3.853
LGA    R   137_A      K     116          3.514
LGA    F   138_A      L     117          1.816
LGA    T   139_A      A     118          1.775
LGA    R   140_A      L     119          1.416
LGA    L   141_A      L     120          0.737
LGA    I   142_A      R     121          1.070
LGA    C   143_A      L     122          0.752
LGA    H   144_A      D     123          0.929
LGA    L   145_A      A     124          0.672
LGA    S   146_A      D     125          0.567
LGA    E   147_A      H     126          0.998
LGA    I   148_A      A     127          0.752
LGA    D   149_A      Q     128          0.600
LGA    V   150_A      I     129          0.716
LGA    L   151_A      W     130          0.797
LGA    H   152_A      L     131          0.933
LGA    L   153_A      N     132          1.553
LGA    T   154_A      G     133          0.579
LGA    T   155_A      S     134          2.347
LGA    P   156_A      S     135          4.814
LGA    H   157_A      L     136           -
LGA    Q   158_A      L     137           -
LGA    R   159_A      A     138           -
LGA    A   160_A      G     139           -
LGA    V   161_A      I     140           -
LGA    Y   162_A      K     141           -
LGA    T   163_A      V     142           -
LGA    A   164_A      L     143           -
LGA    P   165_A      L     144           -
LGA    D   166_A      G     145           -
LGA    W   167_A      -       -           -
LGA    R   168_A      -       -           -
LGA    G   169_A      -       -           -
LGA    I   170_A      -       -           -
LGA    W   171_A      -       -           -
LGA    V   172_A      -       -           -
LGA    S   173_A      -       -           -
LGA    P   174_A      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  175  145    5.0    113    2.42    11.50     54.105     4.479

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.084207 * X  +  -0.949790 * Y  +  -0.301344 * Z  +  67.124146
  Y_new =  -0.368727 * X  +   0.251250 * Y  +  -0.894938 * Z  +  84.721550
  Z_new =   0.925716 * X  +   0.186474 * Y  +  -0.329056 * Z  +   0.609409 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =   2.626024   -0.515569  [ DEG:   150.4601    -29.5399 ]
  Theta =  -1.182923   -1.958669  [ DEG:   -67.7765   -112.2235 ]
  Phi   =  -1.346274    1.795318  [ DEG:   -77.1358    102.8642 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2ou5_A                                        
REMARK     2: T0497.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2ou5_A.T0497.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  175  145   5.0  113   2.42   11.50  54.105
REMARK  ---------------------------------------------------------- 
MOLECULE 2ou5_A
HEADER    OXIDOREDUCTASE                          09-FEB-07   2OU5              
TITLE     CRYSTAL STRUCTURE OF PYRIDOXAMINE 5'-PHOSPHATE OXIDASE-               
TITLE    2 RELATED FMN-BINDING (YP_508196.1) FROM JANNASCHIA SP. CCS1           
TITLE    3 AT 1.60 A RESOLUTION                                                 
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PYRIDOXAMINE 5'-PHOSPHATE OXIDASE-RELATED, FMN-            
COMPND   3 BINDING;                                                             
COMPND   4 CHAIN: A, B;                                                         
COMPND   5 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: JANNASCHIA SP. CCS1;                            
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: CCS1;                                                        
SOURCE   5 GENE: YP_508196.1, JANN_0254;                                        
SOURCE   6 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   7 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   8 EXPRESSION_SYSTEM_STRAIN: HK100;                                     
SOURCE   9 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  10 EXPRESSION_SYSTEM_PLASMID: SPEEDET                                   
KEYWDS    YP_508196.1, PYRIDOXAMINE 5'-PHOSPHATE OXIDASE,                       
KEYWDS   2 PYRIDOXAMINE 5'-PHOSPHATE OXIDASE-RELATED FMN-BINDING,               
KEYWDS   3 STRUCTURAL GENOMICS, JOINT CENTER FOR STRUCTURAL GENOMICS,           
KEYWDS   4 JCSG, PROTEIN STRUCTURE INITIATIVE, PSI-2                            
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   06-MAR-07 2OU5    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF PYRIDOXAMINE 5'-PHOSPHATE               
JRNL        TITL 2 OXIDASE-RELATED FMN-BINDING (YP_508196.1) FROM               
JRNL        TITL 3 JANNASCHIA SP. CCS1 AT 1.60 A RESOLUTION                     
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.60 ANGSTROMS.                                          
DBREF  2OU5 A    1   174  UNP    Q28VU1   Q28VU1_JANSC     1    174             
DBREF  2OU5 B    1   174  UNP    Q28VU1   Q28VU1_JANSC     1    174             
SEQRES   1 A  175  GLY MSE SER ASP THR VAL LEU THR GLY LEU LEU ASP THR          
SEQRES   2 A  175  VAL TRP GLN GLN PHE GLY ARG GLY THR LYS ASP ARG HIS          
SEQRES   3 A  175  HIS PRO ALA ARG HIS PRO THR LEU ALA THR ILE GLY THR          
SEQRES   4 A  175  ASP GLY PRO ASP LEU ARG THR LEU VAL LEU ARG ALA ALA          
SEQRES   5 A  175  SER HIS ALA GLU ALA THR LEU GLU PHE HIS THR ASP ALA          
SEQRES   6 A  175  ALA SER PRO LYS VAL ALA HIS ILE ARG ARG ASP ALA ARG          
SEQRES   7 A  175  VAL ALA ILE HIS ILE TRP ILE PRO LYS ALA SER LEU GLN          
SEQRES   8 A  175  VAL ARG ALA LYS ALA ILE ALA LYS ILE LEU PRO GLY ASP          
SEQRES   9 A  175  PRO ASN LEU PHE ALA GLN LEU PRO GLU ALA ALA ARG MSE          
SEQRES  10 A  175  ASN TYR GLN GLY PRO VAL PRO GLY THR PRO LEU PRO ALA          
SEQRES  11 A  175  GLU PRO ASP ALA THR PRO ASN ARG PHE THR ARG LEU ILE          
SEQRES  12 A  175  CYS HIS LEU SER GLU ILE ASP VAL LEU HIS LEU THR THR          
SEQRES  13 A  175  PRO HIS GLN ARG ALA VAL TYR THR ALA PRO ASP TRP ARG          
SEQRES  14 A  175  GLY ILE TRP VAL SER PRO                                      
SEQRES   1 B  175  GLY MSE SER ASP THR VAL LEU THR GLY LEU LEU ASP THR          
SEQRES   2 B  175  VAL TRP GLN GLN PHE GLY ARG GLY THR LYS ASP ARG HIS          
SEQRES   3 B  175  HIS PRO ALA ARG HIS PRO THR LEU ALA THR ILE GLY THR          
SEQRES   4 B  175  ASP GLY PRO ASP LEU ARG THR LEU VAL LEU ARG ALA ALA          
SEQRES   5 B  175  SER HIS ALA GLU ALA THR LEU GLU PHE HIS THR ASP ALA          
SEQRES   6 B  175  ALA SER PRO LYS VAL ALA HIS ILE ARG ARG ASP ALA ARG          
SEQRES   7 B  175  VAL ALA ILE HIS ILE TRP ILE PRO LYS ALA SER LEU GLN          
SEQRES   8 B  175  VAL ARG ALA LYS ALA ILE ALA LYS ILE LEU PRO GLY ASP          
SEQRES   9 B  175  PRO ASN LEU PHE ALA GLN LEU PRO GLU ALA ALA ARG MSE          
SEQRES  10 B  175  ASN TYR GLN GLY PRO VAL PRO GLY THR PRO LEU PRO ALA          
SEQRES  11 B  175  GLU PRO ASP ALA THR PRO ASN ARG PHE THR ARG LEU ILE          
SEQRES  12 B  175  CYS HIS LEU SER GLU ILE ASP VAL LEU HIS LEU THR THR          
SEQRES  13 B  175  PRO HIS GLN ARG ALA VAL TYR THR ALA PRO ASP TRP ARG          
SEQRES  14 B  175  GLY ILE TRP VAL SER PRO                                      
HET    MSE  A   1      13                                                       
HET    MSE  A 116       8                                                       
HET    MSE  B   1       8                                                       
HET    MSE  B 116       8                                                       
HET    SO4      1       5                                                       
HET    FMN  A 300      31                                                       
HET    FMN  B 300      31                                                       
HET    GOL      2       6                                                       
HET    GOL      3       6                                                       
HET    GOL      4       6                                                       
HET    GOL      5       6                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM     SO4 SULFATE ION                                                      
HETNAM     FMN FLAVIN MONONUCLEOTIDE                                            
HETNAM     GOL GLYCEROL                                                         
HETSYN     FMN RIBOFLAVIN MONOPHOSPHATE                                         
FORMUL   1  MSE    4(C5 H11 N O2 SE)                                            
FORMUL   3  SO4    O4 S 2-                                                      
FORMUL   4  FMN    2(C17 H21 N4 O9 P)                                           
FORMUL   6  GOL    4(C3 H8 O3)                                                  
FORMUL  10  HOH   *413(H2 O)                                                    
CRYST1   45.880   68.510  111.920  90.00  90.00  90.00 P 21 21 21    8          
ATOM      1  N   GLY A   0      19.150  46.617  17.530  1.00 30.26           N  
ATOM      2  CA  GLY A   0      18.898  47.258  18.849  1.00 30.39           C  
ATOM      3  C   GLY A   0      18.266  46.299  19.833  1.00 30.17           C  
ATOM      4  O   GLY A   0      18.028  45.140  19.508  1.00 29.26           O  
HETATM    5  N   MSE A   1      18.020  46.792  21.041  1.00 31.37           N  
HETATM    6  CA  MSE A   1      17.454  45.974  22.118  0.50 29.85           C  
HETATM    8  C   MSE A   1      16.091  46.548  22.549  1.00 29.59           C  
HETATM    9  O   MSE A   1      15.646  46.345  23.670  1.00 35.11           O  
HETATM   10  CB  MSE A   1      18.426  45.872  23.320  0.50 31.12           C  
HETATM   12  CG  MSE A   1      19.844  45.261  23.034  0.50 24.40           C  
HETATM   14 SE   MSE A   1      19.960  43.334  22.579  0.38 32.65          SE  
HETATM   16  CE  MSE A   1      20.104  42.560  24.245  0.50 18.80           C  
ATOM     18  N   SER A   2      15.417  47.233  21.658  1.00 27.21           N  
ATOM     19  CA  SER A   2      14.162  47.847  22.027  1.00 24.99           C  
ATOM     20  C   SER A   2      13.016  46.850  22.174  1.00 22.84           C  
ATOM     21  O   SER A   2      13.083  45.730  21.682  1.00 21.67           O  
ATOM     22  CB  SER A   2      13.768  48.891  21.004  1.00 27.84           C  
ATOM     23  OG  SER A   2      13.524  48.290  19.737  1.00 32.02           O  
ATOM     24  N   ASP A   3      11.945  47.315  22.814  1.00 21.49           N  
ATOM     25  CA  ASP A   3      10.670  46.581  22.880  1.00 21.19           C  
ATOM     26  C   ASP A   3      10.158  46.294  21.465  1.00 21.06           C  
ATOM     27  O   ASP A   3       9.525  45.242  21.212  1.00 20.76           O  
ATOM     28  CB  ASP A   3       9.615  47.392  23.643  1.00 21.40           C  
ATOM     29  CG  ASP A   3       9.922  47.522  25.134  1.00 27.12           C  
ATOM     30  OD1 ASP A   3      11.004  47.074  25.615  1.00 25.41           O  
ATOM     31  OD2 ASP A   3       9.035  48.073  25.821  1.00 28.94           O  
ATOM     32  N   THR A   4      10.435  47.229  20.554  1.00 19.98           N  
ATOM     33  CA  THR A   4       9.996  47.112  19.169  1.00 21.45           C  
ATOM     34  C   THR A   4      10.677  45.910  18.506  1.00 18.87           C  
ATOM     35  O   THR A   4      10.030  45.113  17.802  1.00 19.42           O  
ATOM     36  CB  THR A   4      10.274  48.424  18.377  1.00 21.17           C  
ATOM     37  OG1 THR A   4       9.558  49.502  18.987  1.00 30.23           O  
ATOM     38  CG2 THR A   4       9.847  48.303  16.929  1.00 24.37           C  
ATOM     39  N   VAL A   5      11.976  45.795  18.726  1.00 17.90           N  
ATOM     40  CA  VAL A   5      12.752  44.685  18.186  1.00 17.41           C  
ATOM     41  C   VAL A   5      12.280  43.369  18.815  1.00 16.50           C  
ATOM     42  O   VAL A   5      12.078  42.372  18.096  1.00 16.36           O  
ATOM     43  CB  VAL A   5      14.261  44.905  18.379  1.00 18.74           C  
ATOM     44  CG1 VAL A   5      15.063  43.673  18.036  1.00 22.15           C  
ATOM     45  CG2 VAL A   5      14.711  46.094  17.511  1.00 20.61           C  
ATOM     46  N   LEU A   6      12.078  43.385  20.132  1.00 15.48           N  
ATOM     47  CA  LEU A   6      11.554  42.203  20.837  1.00 18.99           C  
ATOM     48  C   LEU A   6      10.271  41.710  20.215  1.00 19.86           C  
ATOM     49  O   LEU A   6      10.153  40.528  19.895  1.00 17.95           O  
ATOM     50  CB  LEU A   6      11.271  42.465  22.325  1.00 22.32           C  
ATOM     51  CG  LEU A   6      12.312  42.256  23.401  1.00 25.09           C  
ATOM     52  CD1 LEU A   6      11.677  42.623  24.719  1.00 21.52           C  
ATOM     53  CD2 LEU A   6      12.868  40.840  23.403  1.00 21.10           C  
ATOM     54  N   THR A   7       9.290  42.606  20.060  1.00 20.82           N  
ATOM     55  CA  THR A   7       7.998  42.251  19.449  1.00 22.12           C  
ATOM     56  C   THR A   7       8.154  41.730  18.028  1.00 23.18           C  
ATOM     57  O   THR A   7       7.530  40.753  17.647  1.00 23.77           O  
ATOM     58  CB  THR A   7       7.020  43.456  19.393  1.00 23.54           C  
ATOM     59  OG1 THR A   7       6.833  43.967  20.704  1.00 26.91           O  
ATOM     60  CG2 THR A   7       5.697  43.014  18.835  1.00 29.21           C  
ATOM     61  N   GLY A   8       8.988  42.397  17.248  1.00 21.18           N  
ATOM     62  CA  GLY A   8       9.226  42.007  15.878  1.00 21.83           C  
ATOM     63  C   GLY A   8       9.852  40.642  15.746  1.00 22.33           C  
ATOM     64  O   GLY A   8       9.622  39.936  14.762  1.00 23.01           O  
ATOM     65  N   LEU A   9      10.661  40.270  16.732  1.00 19.29           N  
ATOM     66  CA  LEU A   9      11.398  39.011  16.640  1.00 18.95           C  
ATOM     67  C   LEU A   9      10.439  37.839  16.863  1.00 19.29           C  
ATOM     68  O   LEU A   9      10.540  36.803  16.184  1.00 18.93           O  
ATOM     69  CB  LEU A   9      12.555  39.022  17.627  1.00 19.26           C  
ATOM     70  CG  LEU A   9      13.459  37.789  17.721  1.00 21.75           C  
ATOM     71  CD1 LEU A   9      14.152  37.472  16.352  1.00 19.40           C  
ATOM     72  CD2 LEU A   9      14.517  38.015  18.801  1.00 20.15           C  
ATOM     73  N   LEU A  10       9.497  38.008  17.785  1.00 18.02           N  
ATOM     74  CA  LEU A  10       8.468  36.988  18.013  1.00 19.61           C  
ATOM     75  C   LEU A  10       7.479  36.910  16.848  1.00 18.90           C  
ATOM     76  O   LEU A  10       7.122  35.809  16.417  1.00 20.24           O  
ATOM     77  CB  LEU A  10       7.743  37.257  19.314  1.00 19.06           C  
ATOM     78  CG  LEU A  10       6.713  36.224  19.779  1.00 19.73           C  
ATOM     79  CD1 LEU A  10       7.353  34.854  19.936  1.00 23.12           C  
ATOM     80  CD2 LEU A  10       5.989  36.662  21.039  1.00 21.68           C  
ATOM     81  N   ASP A  11       7.100  38.058  16.296  1.00 20.10           N  
ATOM     82  CA  ASP A  11       6.350  38.049  15.046  1.00 21.20           C  
ATOM     83  C   ASP A  11       7.080  37.271  13.948  1.00 20.00           C  
ATOM     84  O   ASP A  11       6.450  36.512  13.203  1.00 21.35           O  
ATOM     85  CB  ASP A  11       6.030  39.481  14.555  1.00 22.92           C  
ATOM     86  CG  ASP A  11       5.044  40.204  15.453  1.00 26.96           C  
ATOM     87  OD1 ASP A  11       4.303  39.525  16.215  1.00 29.83           O  
ATOM     88  OD2 ASP A  11       5.008  41.457  15.384  1.00 28.10           O  
ATOM     89  N   THR A  12       8.403  37.421  13.869  1.00 19.33           N  
ATOM     90  CA  THR A  12       9.180  36.727  12.854  1.00 19.44           C  
ATOM     91  C   THR A  12       9.075  35.211  13.040  1.00 21.32           C  
ATOM     92  O   THR A  12       8.884  34.459  12.072  1.00 20.51           O  
ATOM     93  CB  THR A  12      10.636  37.165  12.882  1.00 19.78           C  
ATOM     94  OG1 THR A  12      10.705  38.535  12.483  1.00 18.85           O  
ATOM     95  CG2 THR A  12      11.462  36.365  11.920  1.00 22.07           C  
ATOM     96  N   VAL A  13       9.190  34.785  14.291  1.00 18.84           N  
ATOM     97  CA  VAL A  13       9.049  33.373  14.633  1.00 18.32           C  
ATOM     98  C   VAL A  13       7.706  32.820  14.126  1.00 18.54           C  
ATOM     99  O   VAL A  13       7.648  31.727  13.507  1.00 19.11           O  
ATOM    100  CB  VAL A  13       9.230  33.173  16.159  1.00 16.88           C  
ATOM    101  CG1 VAL A  13       8.834  31.764  16.576  1.00 17.78           C  
ATOM    102  CG2 VAL A  13      10.700  33.450  16.521  1.00 17.50           C  
ATOM    103  N   TRP A  14       6.628  33.549  14.366  1.00 17.96           N  
ATOM    104  CA  TRP A  14       5.321  33.058  13.956  1.00 18.14           C  
ATOM    105  C   TRP A  14       5.146  33.046  12.426  1.00 20.21           C  
ATOM    106  O   TRP A  14       4.516  32.152  11.871  1.00 20.16           O  
ATOM    107  CB  TRP A  14       4.190  33.805  14.654  1.00 16.99           C  
ATOM    108  CG  TRP A  14       3.983  33.310  16.016  1.00 18.26           C  
ATOM    109  CD1 TRP A  14       4.424  33.895  17.178  1.00 21.16           C  
ATOM    110  CD2 TRP A  14       3.385  32.066  16.399  1.00 20.12           C  
ATOM    111  NE1 TRP A  14       4.104  33.102  18.249  1.00 17.32           N  
ATOM    112  CE2 TRP A  14       3.444  31.991  17.806  1.00 18.64           C  
ATOM    113  CE3 TRP A  14       2.773  31.022  15.694  1.00 19.31           C  
ATOM    114  CZ2 TRP A  14       2.960  30.903  18.509  1.00 19.42           C  
ATOM    115  CZ3 TRP A  14       2.277  29.955  16.402  1.00 18.02           C  
ATOM    116  CH2 TRP A  14       2.391  29.892  17.789  1.00 19.17           C  
ATOM    117  N   GLN A  15       5.766  34.000  11.761  1.00 20.86           N  
ATOM    118  CA  GLN A  15       5.775  34.036  10.291  1.00 23.22           C  
ATOM    119  C   GLN A  15       6.544  32.805   9.734  1.00 24.19           C  
ATOM    120  O   GLN A  15       6.107  32.187   8.752  1.00 23.87           O  
ATOM    121  CB  GLN A  15       6.362  35.374   9.825  1.00 24.10           C  
ATOM    122  CG  GLN A  15       6.119  35.720   8.360  1.00 36.59           C  
ATOM    123  CD  GLN A  15       7.264  35.270   7.451  1.00 42.91           C  
ATOM    124  OE1 GLN A  15       8.413  35.146   7.896  1.00 47.05           O  
ATOM    125  NE2 GLN A  15       6.954  35.041   6.170  1.00 36.42           N  
ATOM    126  N   GLN A  16       7.625  32.398  10.408  1.00 20.95           N  
ATOM    127  CA  GLN A  16       8.383  31.227  10.002  1.00 20.10           C  
ATOM    128  C   GLN A  16       7.595  29.923  10.203  1.00 20.38           C  
ATOM    129  O   GLN A  16       7.639  29.039   9.338  1.00 20.02           O  
ATOM    130  CB  GLN A  16       9.745  31.181  10.690  1.00 21.84           C  
ATOM    131  CG  GLN A  16      10.672  32.333  10.258  1.00 25.77           C  
ATOM    132  CD  GLN A  16      11.079  32.200   8.810  1.00 29.58           C  
ATOM    133  OE1 GLN A  16      11.821  31.309   8.473  1.00 23.83           O  
ATOM    134  NE2 GLN A  16      10.571  33.072   7.945  1.00 34.02           N  
ATOM    135  N   PHE A  17       6.873  29.797  11.327  1.00 17.76           N  
ATOM    136  CA  PHE A  17       5.973  28.660  11.539  1.00 17.32           C  
ATOM    137  C   PHE A  17       4.934  28.626  10.413  1.00 18.00           C  
ATOM    138  O   PHE A  17       4.606  27.548   9.887  1.00 19.63           O  
ATOM    139  CB  PHE A  17       5.207  28.761  12.853  1.00 15.12           C  
ATOM    140  CG  PHE A  17       6.027  28.548  14.151  1.00 20.17           C  
ATOM    141  CD1 PHE A  17       7.086  27.685  14.243  1.00 29.51           C  
ATOM    142  CD2 PHE A  17       5.626  29.187  15.320  1.00 19.86           C  
ATOM    143  CE1 PHE A  17       7.769  27.543  15.482  1.00 24.71           C  
ATOM    144  CE2 PHE A  17       6.276  29.045  16.504  1.00 22.59           C  
ATOM    145  CZ  PHE A  17       7.384  28.229  16.569  1.00 18.00           C  
ATOM    146  N   GLY A  18       4.404  29.797  10.080  1.00 18.79           N  
ATOM    147  CA  GLY A  18       3.458  29.964   8.976  1.00 19.82           C  
ATOM    148  C   GLY A  18       3.997  29.446   7.669  1.00 18.91           C  
ATOM    149  O   GLY A  18       3.345  28.615   7.027  1.00 21.62           O  
ATOM    150  N   ARG A  19       5.184  29.911   7.288  1.00 19.21           N  
ATOM    151  CA  ARG A  19       5.893  29.382   6.108  1.00 22.28           C  
ATOM    152  C   ARG A  19       6.028  27.849   6.194  1.00 23.86           C  
ATOM    153  O   ARG A  19       5.812  27.139   5.211  1.00 22.57           O  
ATOM    154  CB  ARG A  19       7.284  30.008   5.916  1.00 24.62           C  
ATOM    155  CG  ARG A  19       7.343  31.520   5.573  1.00 25.07           C  
ATOM    156  CD  ARG A  19       6.230  31.997   4.631  1.00 36.18           C  
ATOM    157  NE  ARG A  19       6.248  31.236   3.383  1.00 39.84           N  
ATOM    158  CZ  ARG A  19       5.177  30.811   2.713  1.00 33.87           C  
ATOM    159  NH1 ARG A  19       3.934  31.072   3.119  1.00 38.44           N  
ATOM    160  NH2 ARG A  19       5.362  30.112   1.604  1.00 40.57           N  
ATOM    161  N   GLY A  20       6.352  27.342   7.377  1.00 22.00           N  
ATOM    162  CA  GLY A  20       6.467  25.908   7.571  1.00 23.83           C  
ATOM    163  C   GLY A  20       5.208  25.136   7.224  1.00 19.69           C  
ATOM    164  O   GLY A  20       5.274  24.018   6.739  1.00 21.30           O  
ATOM    165  N   THR A  21       4.029  25.693   7.470  1.00 21.74           N  
ATOM    166  CA  THR A  21       2.808  24.945   7.136  1.00 22.24           C  
ATOM    167  C   THR A  21       2.557  24.954   5.638  1.00 24.30           C  
ATOM    168  O   THR A  21       2.000  24.018   5.090  1.00 28.46           O  
ATOM    169  CB  THR A  21       1.563  25.495   7.834  1.00 21.19           C  
ATOM    170  OG1 THR A  21       1.283  26.849   7.400  1.00 25.52           O  
ATOM    171  CG2 THR A  21       1.728  25.479   9.350  1.00 20.59           C  
ATOM    172  N   LYS A  22       3.007  26.006   4.980  1.00 22.96           N  
ATOM    173  CA  LYS A  22       2.714  26.207   3.554  1.00 25.44           C  
ATOM    174  C   LYS A  22       3.775  25.681   2.575  1.00 24.75           C  
ATOM    175  O   LYS A  22       3.432  25.340   1.439  1.00 25.67           O  
ATOM    176  CB  LYS A  22       2.536  27.705   3.301  1.00 24.63           C  
ATOM    177  CG  LYS A  22       1.440  28.340   4.158  1.00 30.48           C  
ATOM    178  CD  LYS A  22       0.057  27.844   3.786  1.00 35.50           C  
ATOM    179  CE  LYS A  22      -1.017  28.337   4.746  1.00 39.43           C  
ATOM    180  NZ  LYS A  22      -1.289  27.359   5.844  1.00 46.83           N  
ATOM    181  N   ASP A  23       5.043  25.667   2.979  1.00 22.18           N  
ATOM    182  CA  ASP A  23       6.142  25.418   2.067  1.00 22.61           C  
ATOM    183  C   ASP A  23       6.871  24.129   2.477  1.00 23.01           C  
ATOM    184  O   ASP A  23       7.581  24.103   3.485  1.00 23.53           O  
ATOM    185  CB  ASP A  23       7.099  26.618   2.094  1.00 25.33           C  
ATOM    186  CG  ASP A  23       8.306  26.431   1.205  1.00 25.75           C  
ATOM    187  OD1 ASP A  23       8.365  25.389   0.506  1.00 30.23           O  
ATOM    188  OD2 ASP A  23       9.198  27.309   1.221  1.00 31.18           O  
ATOM    189  N   ARG A  24       6.714  23.068   1.683  1.00 23.57           N  
ATOM    190  CA  ARG A  24       7.364  21.778   1.965  1.00 25.86           C  
ATOM    191  C   ARG A  24       8.873  21.811   2.086  1.00 25.06           C  
ATOM    192  O   ARG A  24       9.470  20.908   2.715  1.00 26.67           O  
ATOM    193  CB  ARG A  24       6.993  20.754   0.876  1.00 28.64           C  
ATOM    194  CG  ARG A  24       5.591  20.238   1.042  1.00 34.51           C  
ATOM    195  CD  ARG A  24       4.887  19.691  -0.224  1.00 38.86           C  
ATOM    196  NE  ARG A  24       3.508  19.306   0.120  1.00 41.12           N  
ATOM    197  CZ  ARG A  24       2.528  20.172   0.392  1.00 39.18           C  
ATOM    198  NH1 ARG A  24       2.743  21.480   0.375  1.00 39.84           N  
ATOM    199  NH2 ARG A  24       1.323  19.732   0.714  1.00 51.37           N  
ATOM    200  N   HIS A  25       9.513  22.812   1.498  1.00 26.63           N  
ATOM    201  CA  HIS A  25      10.977  22.869   1.490  1.00 27.98           C  
ATOM    202  C   HIS A  25      11.539  23.737   2.623  1.00 25.86           C  
ATOM    203  O   HIS A  25      12.747  23.829   2.786  1.00 27.87           O  
ATOM    204  CB  HIS A  25      11.497  23.367   0.130  1.00 30.11           C  
ATOM    205  CG  HIS A  25      11.222  22.424  -1.002  1.00 34.83           C  
ATOM    206  ND1 HIS A  25      11.544  21.084  -0.944  1.00 40.44           N  
ATOM    207  CD2 HIS A  25      10.652  22.626  -2.212  1.00 39.98           C  
ATOM    208  CE1 HIS A  25      11.177  20.500  -2.070  1.00 42.33           C  
ATOM    209  NE2 HIS A  25      10.637  21.414  -2.857  1.00 43.40           N  
ATOM    210  N   HIS A  26      10.666  24.344   3.414  1.00 22.38           N  
ATOM    211  CA  HIS A  26      11.084  25.274   4.469  1.00 18.30           C  
ATOM    212  C   HIS A  26      11.441  24.435   5.711  1.00 19.15           C  
ATOM    213  O   HIS A  26      10.756  23.451   6.021  1.00 19.25           O  
ATOM    214  CB  HIS A  26       9.907  26.217   4.775  1.00 19.59           C  
ATOM    215  CG  HIS A  26      10.260  27.374   5.653  1.00 18.44           C  
ATOM    216  ND1 HIS A  26      10.488  27.242   7.003  1.00 17.10           N  
ATOM    217  CD2 HIS A  26      10.407  28.691   5.379  1.00 18.18           C  
ATOM    218  CE1 HIS A  26      10.796  28.420   7.517  1.00 16.97           C  
ATOM    219  NE2 HIS A  26      10.738  29.319   6.549  1.00 19.74           N  
ATOM    220  N   PRO A  27      12.528  24.777   6.425  1.00 18.68           N  
ATOM    221  CA  PRO A  27      12.836  24.005   7.629  1.00 19.87           C  
ATOM    222  C   PRO A  27      11.706  23.891   8.642  1.00 19.75           C  
ATOM    223  O   PRO A  27      11.613  22.885   9.341  1.00 18.44           O  
ATOM    224  CB  PRO A  27      14.023  24.763   8.251  1.00 21.95           C  
ATOM    225  CG  PRO A  27      14.669  25.440   7.096  1.00 25.09           C  
ATOM    226  CD  PRO A  27      13.560  25.790   6.142  1.00 16.25           C  
ATOM    227  N   ALA A  28      10.847  24.899   8.760  1.00 17.62           N  
ATOM    228  CA  ALA A  28       9.743  24.838   9.757  1.00 18.01           C  
ATOM    229  C   ALA A  28       8.625  23.864   9.383  1.00 16.18           C  
ATOM    230  O   ALA A  28       7.703  23.629  10.186  1.00 17.37           O  
ATOM    231  CB  ALA A  28       9.175  26.210  10.027  1.00 20.23           C  
ATOM    232  N   ARG A  29       8.669  23.325   8.169  1.00 15.37           N  
ATOM    233  CA  ARG A  29       7.805  22.237   7.782  1.00 16.45           C  
ATOM    234  C   ARG A  29       8.053  21.001   8.658  1.00 18.05           C  
ATOM    235  O   ARG A  29       7.132  20.207   8.941  1.00 16.33           O  
ATOM    236  CB  ARG A  29       7.972  21.911   6.274  1.00 15.71           C  
ATOM    237  CG  ARG A  29       7.201  20.661   5.798  1.00 19.60           C  
ATOM    238  CD  ARG A  29       5.729  20.765   6.025  1.00 20.16           C  
ATOM    239  NE  ARG A  29       5.067  21.702   5.119  1.00 26.97           N  
ATOM    240  CZ  ARG A  29       4.376  21.345   4.032  1.00 27.96           C  
ATOM    241  NH1 ARG A  29       4.264  20.070   3.672  1.00 26.41           N  
ATOM    242  NH2 ARG A  29       3.786  22.278   3.290  1.00 32.55           N  
ATOM    243  N   HIS A  30       9.316  20.848   9.096  1.00 16.43           N  
ATOM    244  CA  HIS A  30       9.795  19.639   9.772  1.00 16.90           C  
ATOM    245  C   HIS A  30      10.500  19.935  11.114  1.00 15.74           C  
ATOM    246  O   HIS A  30      11.705  19.665  11.299  1.00 16.22           O  
ATOM    247  CB  HIS A  30      10.706  18.866   8.818  1.00 15.92           C  
ATOM    248  CG  HIS A  30      10.001  18.306   7.615  1.00 20.60           C  
ATOM    249  ND1 HIS A  30      10.325  18.681   6.328  1.00 26.49           N  
ATOM    250  CD2 HIS A  30       8.984  17.420   7.502  1.00 23.79           C  
ATOM    251  CE1 HIS A  30       9.561  18.021   5.476  1.00 22.97           C  
ATOM    252  NE2 HIS A  30       8.728  17.256   6.158  1.00 20.82           N  
ATOM    253  N   PRO A  31       9.777  20.438  12.071  1.00 14.79           N  
ATOM    254  CA  PRO A  31      10.414  20.678  13.365  1.00 17.79           C  
ATOM    255  C   PRO A  31      10.700  19.365  14.079  1.00 15.53           C  
ATOM    256  O   PRO A  31      10.241  18.289  13.630  1.00 15.58           O  
ATOM    257  CB  PRO A  31       9.378  21.450  14.160  1.00 19.34           C  
ATOM    258  CG  PRO A  31       8.194  21.662  13.275  1.00 22.63           C  
ATOM    259  CD  PRO A  31       8.340  20.763  12.098  1.00 16.19           C  
ATOM    260  N   THR A  32      11.491  19.464  15.157  1.00 17.79           N  
ATOM    261  CA  THR A  32      11.907  18.305  15.961  1.00 14.21           C  
ATOM    262  C   THR A  32      11.100  18.412  17.272  1.00 16.90           C  
ATOM    263  O   THR A  32      11.093  19.463  17.894  1.00 19.57           O  
ATOM    264  CB  THR A  32      13.426  18.277  16.163  1.00 17.32           C  
ATOM    265  OG1 THR A  32      14.052  18.328  14.891  1.00 18.15           O  
ATOM    266  CG2 THR A  32      13.859  17.063  16.888  1.00 17.42           C  
ATOM    267  N   LEU A  33      10.416  17.330  17.663  1.00 13.01           N  
ATOM    268  CA  LEU A  33       9.694  17.278  18.930  1.00 14.26           C  
ATOM    269  C   LEU A  33      10.446  16.367  19.914  1.00 13.57           C  
ATOM    270  O   LEU A  33      10.664  15.226  19.623  1.00 17.00           O  
ATOM    271  CB  LEU A  33       8.306  16.722  18.674  1.00 17.23           C  
ATOM    272  CG  LEU A  33       7.446  16.418  19.939  1.00 17.09           C  
ATOM    273  CD1 LEU A  33       6.896  17.637  20.435  1.00 23.12           C  
ATOM    274  CD2 LEU A  33       6.355  15.364  19.708  1.00 24.96           C  
ATOM    275  N   ALA A  34      10.707  16.886  21.110  1.00 15.84           N  
ATOM    276  CA  ALA A  34      11.318  16.140  22.228  1.00 13.84           C  
ATOM    277  C   ALA A  34      10.225  15.732  23.228  1.00 14.40           C  
ATOM    278  O   ALA A  34       9.258  16.495  23.543  1.00 16.35           O  
ATOM    279  CB  ALA A  34      12.264  17.001  22.934  1.00 15.66           C  
ATOM    280  N   THR A  35      10.374  14.494  23.692  1.00 17.11           N  
ATOM    281  CA  THR A  35       9.565  13.949  24.770  1.00 15.13           C  
ATOM    282  C   THR A  35      10.481  13.344  25.828  1.00 15.81           C  
ATOM    283  O   THR A  35      11.705  13.165  25.591  1.00 13.72           O  
ATOM    284  CB  THR A  35       8.637  12.815  24.240  1.00 15.62           C  
ATOM    285  OG1 THR A  35       9.461  11.840  23.543  1.00 16.22           O  
ATOM    286  CG2 THR A  35       7.535  13.340  23.344  1.00 17.88           C  
ATOM    287  N   ILE A  36       9.897  13.025  26.982  1.00 19.18           N  
ATOM    288  CA  ILE A  36      10.548  12.156  27.981  1.00 18.74           C  
ATOM    289  C   ILE A  36      10.148  10.716  27.620  1.00 17.99           C  
ATOM    290  O   ILE A  36       8.956  10.383  27.599  1.00 18.55           O  
ATOM    291  CB  ILE A  36      10.265  12.546  29.442  1.00 17.98           C  
ATOM    292  CG1 ILE A  36      10.827  13.964  29.662  1.00 21.16           C  
ATOM    293  CG2 ILE A  36      10.937  11.491  30.356  1.00 20.12           C  
ATOM    294  CD1 ILE A  36      10.853  14.497  31.032  1.00 25.83           C  
ATOM    295  N   GLY A  37      11.154   9.914  27.253  1.00 19.36           N  
ATOM    296  CA  GLY A  37      10.903   8.522  26.919  1.00 21.05           C  
ATOM    297  C   GLY A  37      10.995   7.578  28.101  1.00 20.83           C  
ATOM    298  O   GLY A  37      10.938   7.997  29.271  1.00 18.36           O  
ATOM    299  N   THR A  38      11.169   6.296  27.775  1.00 26.34           N  
ATOM    300  CA  THR A  38      11.256   5.238  28.770  1.00 26.39           C  
ATOM    301  C   THR A  38      12.564   5.243  29.560  1.00 24.35           C  
ATOM    302  O   THR A  38      12.608   4.834  30.742  1.00 23.70           O  
ATOM    303  CB  THR A  38      11.022   3.850  28.112  1.00 28.97           C  
ATOM    304  OG1 THR A  38      11.541   3.850  26.762  1.00 33.05           O  
ATOM    305  CG2 THR A  38       9.529   3.599  28.047  1.00 33.09           C  
ATOM    306  N   ASP A  39      13.625   5.715  28.912  1.00 20.09           N  
ATOM    307  CA  ASP A  39      14.945   5.757  29.514  1.00 18.36           C  
ATOM    308  C   ASP A  39      15.698   6.961  28.969  1.00 17.97           C  
ATOM    309  O   ASP A  39      16.688   6.824  28.244  1.00 20.08           O  
ATOM    310  CB  ASP A  39      15.695   4.474  29.189  1.00 18.85           C  
ATOM    311  CG  ASP A  39      17.039   4.358  29.921  1.00 15.74           C  
ATOM    312  OD1 ASP A  39      17.164   4.767  31.103  1.00 24.74           O  
ATOM    313  OD2 ASP A  39      17.963   3.806  29.314  1.00 31.33           O  
ATOM    314  N   GLY A  40      15.265   8.137  29.367  1.00 16.62           N  
ATOM    315  CA  GLY A  40      15.912   9.376  28.927  1.00 14.80           C  
ATOM    316  C   GLY A  40      15.080  10.090  27.891  1.00 15.37           C  
ATOM    317  O   GLY A  40      13.936   9.693  27.577  1.00 14.45           O  
ATOM    318  N   PRO A  41      15.612  11.215  27.423  1.00 16.07           N  
ATOM    319  CA  PRO A  41      14.919  11.995  26.465  1.00 15.25           C  
ATOM    320  C   PRO A  41      14.878  11.321  25.083  1.00 11.97           C  
ATOM    321  O   PRO A  41      15.688  10.442  24.780  1.00 15.01           O  
ATOM    322  CB  PRO A  41      15.700  13.309  26.458  1.00 15.78           C  
ATOM    323  CG  PRO A  41      17.082  12.905  26.719  1.00 15.89           C  
ATOM    324  CD  PRO A  41      16.934  11.788  27.744  1.00 15.90           C  
ATOM    325  N   ASP A  42      13.909  11.755  24.282  1.00 15.97           N  
ATOM    326  CA  ASP A  42      13.759  11.255  22.929  1.00 15.34           C  
ATOM    327  C   ASP A  42      13.348  12.441  22.031  1.00 16.66           C  
ATOM    328  O   ASP A  42      12.696  13.402  22.471  1.00 16.85           O  
ATOM    329  CB  ASP A  42      12.733  10.128  22.905  1.00 14.14           C  
ATOM    330  CG  ASP A  42      12.869   9.179  21.702  1.00 16.32           C  
ATOM    331  OD1 ASP A  42      13.630   9.458  20.723  1.00 19.46           O  
ATOM    332  OD2 ASP A  42      12.263   8.083  21.771  1.00 19.76           O  
ATOM    333  N   LEU A  43      13.761  12.358  20.782  1.00 14.95           N  
ATOM    334  CA  LEU A  43      13.270  13.326  19.845  1.00 15.04           C  
ATOM    335  C   LEU A  43      13.152  12.751  18.436  1.00 16.91           C  
ATOM    336  O   LEU A  43      13.757  11.739  18.085  1.00 16.23           O  
ATOM    337  CB  LEU A  43      14.114  14.580  19.898  1.00 21.18           C  
ATOM    338  CG  LEU A  43      15.545  14.468  19.419  1.00 20.85           C  
ATOM    339  CD1 LEU A  43      16.253  15.730  19.761  1.00 23.65           C  
ATOM    340  CD2 LEU A  43      16.347  13.293  19.943  1.00 30.39           C  
ATOM    341  N   ARG A  44      12.320  13.407  17.656  1.00 17.36           N  
ATOM    342  CA  ARG A  44      12.096  13.051  16.255  1.00 13.82           C  
ATOM    343  C   ARG A  44      11.430  14.189  15.464  1.00 13.62           C  
ATOM    344  O   ARG A  44      10.719  15.069  16.048  1.00 15.85           O  
ATOM    345  CB  ARG A  44      11.273  11.774  16.171  1.00 14.76           C  
ATOM    346  CG  ARG A  44       9.767  12.004  16.354  1.00 13.02           C  
ATOM    347  CD  ARG A  44       9.362  12.436  17.752  1.00 16.21           C  
ATOM    348  NE  ARG A  44       9.420  11.306  18.692  1.00 18.05           N  
ATOM    349  CZ  ARG A  44       9.515  11.406  20.013  1.00 16.44           C  
ATOM    350  NH1 ARG A  44       9.704  12.581  20.587  1.00 15.16           N  
ATOM    351  NH2 ARG A  44       9.520  10.288  20.757  1.00 15.42           N  
ATOM    352  N   THR A  45      11.556  14.067  14.143  1.00 14.76           N  
ATOM    353  CA  THR A  45      10.977  14.986  13.190  1.00 16.09           C  
ATOM    354  C   THR A  45       9.484  14.701  13.013  1.00 13.67           C  
ATOM    355  O   THR A  45       9.053  13.520  12.888  1.00 15.06           O  
ATOM    356  CB  THR A  45      11.613  14.822  11.828  1.00 15.51           C  
ATOM    357  OG1 THR A  45      13.035  15.059  11.885  1.00 14.50           O  
ATOM    358  CG2 THR A  45      10.996  15.703  10.771  1.00 15.43           C  
ATOM    359  N   LEU A  46       8.658  15.749  12.997  1.00 19.19           N  
ATOM    360  CA  LEU A  46       7.316  15.637  12.565  1.00 19.27           C  
ATOM    361  C   LEU A  46       7.031  16.683  11.492  1.00 18.71           C  
ATOM    362  O   LEU A  46       7.766  17.671  11.354  1.00 18.92           O  
ATOM    363  CB  LEU A  46       6.378  15.917  13.735  1.00 17.50           C  
ATOM    364  CG  LEU A  46       6.586  15.121  15.050  1.00 21.86           C  
ATOM    365  CD1 LEU A  46       5.725  15.678  16.232  1.00 32.54           C  
ATOM    366  CD2 LEU A  46       6.243  13.741  14.762  1.00 23.24           C  
ATOM    367  N   VAL A  47       5.919  16.487  10.792  1.00 18.97           N  
ATOM    368  CA  VAL A  47       5.395  17.478   9.835  1.00 16.38           C  
ATOM    369  C   VAL A  47       4.468  18.448  10.515  1.00 14.42           C  
ATOM    370  O   VAL A  47       3.464  18.037  11.080  1.00 16.16           O  
ATOM    371  CB  VAL A  47       4.674  16.756   8.675  1.00 19.98           C  
ATOM    372  CG1 VAL A  47       4.034  17.771   7.721  1.00 20.04           C  
ATOM    373  CG2 VAL A  47       5.633  15.892   7.929  1.00 22.55           C  
ATOM    374  N   LEU A  48       4.786  19.743  10.443  1.00 15.25           N  
ATOM    375  CA  LEU A  48       3.886  20.788  10.925  1.00 17.07           C  
ATOM    376  C   LEU A  48       2.678  20.925  10.032  1.00 19.95           C  
ATOM    377  O   LEU A  48       2.848  21.239   8.858  1.00 20.61           O  
ATOM    378  CB  LEU A  48       4.640  22.121  10.982  1.00 18.61           C  
ATOM    379  CG  LEU A  48       3.916  23.241  11.685  1.00 15.41           C  
ATOM    380  CD1 LEU A  48       3.671  22.965  13.156  1.00 17.67           C  
ATOM    381  CD2 LEU A  48       4.747  24.502  11.501  1.00 20.64           C  
ATOM    382  N   ARG A  49       1.494  20.639  10.589  1.00 13.59           N  
ATOM    383  CA  ARG A  49       0.179  20.693   9.903  1.00 16.92           C  
ATOM    384  C   ARG A  49      -0.569  22.008  10.056  1.00 19.58           C  
ATOM    385  O   ARG A  49      -1.308  22.423   9.155  1.00 19.71           O  
ATOM    386  CB  ARG A  49      -0.692  19.548  10.447  1.00 18.66           C  
ATOM    387  CG  ARG A  49      -0.112  18.125  10.313  1.00 21.13           C  
ATOM    388  CD  ARG A  49       0.124  17.687   8.881  1.00 22.95           C  
ATOM    389  NE  ARG A  49       0.816  16.397   8.830  1.00 22.24           N  
ATOM    390  CZ  ARG A  49       1.166  15.779   7.703  1.00 24.47           C  
ATOM    391  NH1 ARG A  49       0.861  16.315   6.530  1.00 26.63           N  
ATOM    392  NH2 ARG A  49       1.825  14.622   7.766  1.00 24.14           N  
ATOM    393  N   ALA A  50      -0.436  22.664  11.206  1.00 18.73           N  
ATOM    394  CA  ALA A  50      -1.066  23.922  11.432  1.00 18.64           C  
ATOM    395  C   ALA A  50      -0.381  24.652  12.551  1.00 17.46           C  
ATOM    396  O   ALA A  50       0.394  24.072  13.332  1.00 17.49           O  
ATOM    397  CB  ALA A  50      -2.584  23.759  11.736  1.00 15.94           C  
ATOM    398  N   ALA A  51      -0.541  25.969  12.532  1.00 16.00           N  
ATOM    399  CA  ALA A  51       0.008  26.840  13.584  1.00 18.63           C  
ATOM    400  C   ALA A  51      -0.893  28.033  13.851  1.00 20.58           C  
ATOM    401  O   ALA A  51      -1.431  28.640  12.910  1.00 23.19           O  
ATOM    402  CB  ALA A  51       1.399  27.330  13.196  1.00 19.03           C  
ATOM    403  N   SER A  52      -1.100  28.369  15.122  1.00 21.12           N  
ATOM    404  CA  SER A  52      -2.004  29.469  15.468  1.00 19.51           C  
ATOM    405  C   SER A  52      -1.292  30.394  16.397  1.00 19.30           C  
ATOM    406  O   SER A  52      -1.102  30.057  17.560  1.00 18.64           O  
ATOM    407  CB  SER A  52      -3.241  28.972  16.197  1.00 21.41           C  
ATOM    408  OG  SER A  52      -3.959  30.098  16.674  1.00 23.73           O  
ATOM    409  N   HIS A  53      -0.875  31.559  15.889  1.00 18.61           N  
ATOM    410  CA  HIS A  53      -0.256  32.584  16.725  1.00 20.10           C  
ATOM    411  C   HIS A  53      -1.240  32.985  17.838  1.00 19.15           C  
ATOM    412  O   HIS A  53      -0.837  33.081  18.992  1.00 21.97           O  
ATOM    413  CB  HIS A  53       0.148  33.788  15.863  1.00 19.61           C  
ATOM    414  CG  HIS A  53       0.944  34.835  16.580  1.00 26.10           C  
ATOM    415  ND1 HIS A  53       1.508  35.910  15.916  1.00 26.15           N  
ATOM    416  CD2 HIS A  53       1.331  34.949  17.876  1.00 28.03           C  
ATOM    417  CE1 HIS A  53       2.166  36.662  16.782  1.00 30.51           C  
ATOM    418  NE2 HIS A  53       2.077  36.102  17.977  1.00 27.46           N  
ATOM    419  N   ALA A  54      -2.515  33.174  17.510  1.00 24.33           N  
ATOM    420  CA  ALA A  54      -3.464  33.662  18.501  1.00 23.31           C  
ATOM    421  C   ALA A  54      -3.684  32.702  19.668  1.00 22.67           C  
ATOM    422  O   ALA A  54      -3.791  33.133  20.815  1.00 25.24           O  
ATOM    423  CB  ALA A  54      -4.805  34.041  17.854  1.00 22.97           C  
ATOM    424  N   GLU A  55      -3.751  31.411  19.388  1.00 19.95           N  
ATOM    425  CA  GLU A  55      -3.862  30.407  20.453  1.00 19.98           C  
ATOM    426  C   GLU A  55      -2.509  29.890  20.969  1.00 19.27           C  
ATOM    427  O   GLU A  55      -2.472  29.089  21.886  1.00 22.81           O  
ATOM    428  CB  GLU A  55      -4.676  29.219  19.954  1.00 21.65           C  
ATOM    429  CG  GLU A  55      -6.093  29.585  19.506  1.00 26.82           C  
ATOM    430  CD  GLU A  55      -6.927  30.220  20.619  1.00 40.64           C  
ATOM    431  OE1 GLU A  55      -6.704  29.878  21.803  1.00 48.01           O  
ATOM    432  OE2 GLU A  55      -7.800  31.065  20.308  1.00 46.10           O  
ATOM    433  N   ALA A  56      -1.424  30.368  20.390  1.00 21.80           N  
ATOM    434  CA  ALA A  56      -0.080  29.815  20.614  1.00 20.67           C  
ATOM    435  C   ALA A  56      -0.054  28.284  20.580  1.00 21.49           C  
ATOM    436  O   ALA A  56       0.387  27.629  21.526  1.00 20.72           O  
ATOM    437  CB  ALA A  56       0.522  30.313  21.909  1.00 22.94           C  
ATOM    438  N   THR A  57      -0.493  27.733  19.453  1.00 20.19           N  
ATOM    439  CA  THR A  57      -0.449  26.283  19.253  1.00 17.74           C  
ATOM    440  C   THR A  57       0.225  25.896  17.942  1.00 18.78           C  
ATOM    441  O   THR A  57       0.186  26.671  16.945  1.00 16.64           O  
ATOM    442  CB  THR A  57      -1.866  25.707  19.240  1.00 15.60           C  
ATOM    443  OG1 THR A  57      -2.666  26.376  18.268  1.00 20.91           O  
ATOM    444  CG2 THR A  57      -2.491  25.822  20.598  1.00 23.80           C  
ATOM    445  N   LEU A  58       0.861  24.713  17.983  1.00 16.85           N  
ATOM    446  CA  LEU A  58       1.334  24.002  16.818  1.00 13.80           C  
ATOM    447  C   LEU A  58       0.673  22.626  16.768  1.00 17.34           C  
ATOM    448  O   LEU A  58       0.531  22.001  17.797  1.00 17.93           O  
ATOM    449  CB  LEU A  58       2.834  23.815  16.927  1.00 15.88           C  
ATOM    450  CG  LEU A  58       3.646  25.077  17.166  1.00 17.61           C  
ATOM    451  CD1 LEU A  58       5.127  24.702  17.295  1.00 22.81           C  
ATOM    452  CD2 LEU A  58       3.472  26.051  16.028  1.00 14.50           C  
ATOM    453  N   GLU A  59       0.345  22.148  15.578  1.00 15.29           N  
ATOM    454  CA  GLU A  59      -0.417  20.903  15.411  1.00 14.30           C  
ATOM    455  C   GLU A  59       0.360  19.960  14.504  1.00 17.65           C  
ATOM    456  O   GLU A  59       0.796  20.347  13.416  1.00 16.30           O  
ATOM    457  CB  GLU A  59      -1.802  21.143  14.815  1.00 19.25           C  
ATOM    458  CG  GLU A  59      -2.565  19.846  14.502  1.00 15.68           C  
ATOM    459  CD  GLU A  59      -4.025  20.042  14.222  1.00 18.18           C  
ATOM    460  OE1 GLU A  59      -4.561  21.130  14.496  1.00 19.69           O  
ATOM    461  OE2 GLU A  59      -4.631  19.077  13.721  1.00 21.90           O  
ATOM    462  N   PHE A  60       0.448  18.710  14.943  1.00 17.87           N  
ATOM    463  CA  PHE A  60       1.074  17.613  14.208  1.00 18.33           C  
ATOM    464  C   PHE A  60       0.052  16.476  14.136  1.00 18.68           C  
ATOM    465  O   PHE A  60      -0.830  16.428  14.966  1.00 17.57           O  
ATOM    466  CB  PHE A  60       2.304  17.144  14.953  1.00 20.18           C  
ATOM    467  CG  PHE A  60       3.311  18.229  15.225  1.00 23.03           C  
ATOM    468  CD1 PHE A  60       4.149  18.671  14.228  1.00 18.54           C  
ATOM    469  CD2 PHE A  60       3.350  18.843  16.447  1.00 22.92           C  
ATOM    470  CE1 PHE A  60       5.119  19.662  14.457  1.00 16.21           C  
ATOM    471  CE2 PHE A  60       4.274  19.866  16.694  1.00 23.44           C  
ATOM    472  CZ  PHE A  60       5.172  20.265  15.686  1.00 19.99           C  
ATOM    473  N   HIS A  61       0.169  15.600  13.139  1.00 18.63           N  
ATOM    474  CA  HIS A  61      -0.643  14.391  13.034  1.00 19.92           C  
ATOM    475  C   HIS A  61       0.218  13.194  13.251  1.00 17.27           C  
ATOM    476  O   HIS A  61       1.361  13.138  12.789  1.00 17.07           O  
ATOM    477  CB  HIS A  61      -1.331  14.307  11.681  1.00 20.70           C  
ATOM    478  CG  HIS A  61      -2.299  15.405  11.467  1.00 19.41           C  
ATOM    479  ND1 HIS A  61      -2.846  15.689  10.240  1.00 17.93           N  
ATOM    480  CD2 HIS A  61      -2.806  16.317  12.332  1.00 18.01           C  
ATOM    481  CE1 HIS A  61      -3.675  16.711  10.362  1.00 19.76           C  
ATOM    482  NE2 HIS A  61      -3.661  17.116  11.620  1.00 18.15           N  
ATOM    483  N   THR A  62      -0.285  12.199  13.964  1.00 17.23           N  
ATOM    484  CA  THR A  62       0.552  11.042  14.281  1.00 16.47           C  
ATOM    485  C   THR A  62      -0.309   9.774  14.480  1.00 16.74           C  
ATOM    486  O   THR A  62      -1.497   9.837  14.481  1.00 15.90           O  
ATOM    487  CB  THR A  62       1.467  11.321  15.518  1.00 21.37           C  
ATOM    488  OG1 THR A  62       2.572  10.394  15.529  1.00 26.53           O  
ATOM    489  CG2 THR A  62       0.706  11.220  16.814  1.00 22.36           C  
ATOM    490  N   ASP A  63       0.318   8.647  14.628  1.00 14.62           N  
ATOM    491  CA  ASP A  63      -0.298   7.347  14.785  1.00 14.98           C  
ATOM    492  C   ASP A  63      -0.463   7.153  16.273  1.00 17.99           C  
ATOM    493  O   ASP A  63       0.513   7.183  17.029  1.00 18.49           O  
ATOM    494  CB  ASP A  63       0.647   6.282  14.241  1.00 15.50           C  
ATOM    495  CG  ASP A  63       0.056   4.888  14.234  1.00 16.83           C  
ATOM    496  OD1 ASP A  63      -0.938   4.609  14.943  1.00 17.24           O  
ATOM    497  OD2 ASP A  63       0.679   4.073  13.523  1.00 20.56           O  
ATOM    498  N   ALA A  64      -1.708   6.919  16.696  1.00 15.52           N  
ATOM    499  CA  ALA A  64      -2.024   6.652  18.124  1.00 18.21           C  
ATOM    500  C   ALA A  64      -1.213   5.532  18.771  1.00 17.89           C  
ATOM    501  O   ALA A  64      -1.021   5.503  20.007  1.00 19.03           O  
ATOM    502  CB  ALA A  64      -3.484   6.384  18.286  1.00 18.92           C  
ATOM    503  N   ALA A  65      -0.772   4.595  17.936  1.00 19.65           N  
ATOM    504  CA  ALA A  65      -0.027   3.432  18.383  1.00 18.58           C  
ATOM    505  C   ALA A  65       1.443   3.671  18.491  1.00 20.46           C  
ATOM    506  O   ALA A  65       2.157   2.753  18.899  1.00 19.18           O  
ATOM    507  CB  ALA A  65      -0.285   2.261  17.463  1.00 17.37           C  
ATOM    508  N   SER A  66       1.909   4.868  18.108  1.00 19.56           N  
ATOM    509  CA  SER A  66       3.330   5.131  18.110  1.00 18.22           C  
ATOM    510  C   SER A  66       3.849   5.379  19.542  1.00 17.04           C  
ATOM    511  O   SER A  66       3.133   5.812  20.419  1.00 17.23           O  
ATOM    512  CB  SER A  66       3.707   6.314  17.179  1.00 18.40           C  
ATOM    513  OG  SER A  66       3.204   7.520  17.673  1.00 19.61           O  
ATOM    514  N   PRO A  67       5.113   5.107  19.780  1.00 18.31           N  
ATOM    515  CA  PRO A  67       5.697   5.390  21.081  1.00 18.09           C  
ATOM    516  C   PRO A  67       5.632   6.829  21.551  1.00 19.92           C  
ATOM    517  O   PRO A  67       5.501   7.047  22.745  1.00 18.04           O  
ATOM    518  CB  PRO A  67       7.128   5.013  20.860  1.00 16.20           C  
ATOM    519  CG  PRO A  67       7.023   3.899  19.881  1.00 18.12           C  
ATOM    520  CD  PRO A  67       6.062   4.425  18.909  1.00 17.18           C  
ATOM    521  N   LYS A  68       5.723   7.807  20.647  1.00 17.71           N  
ATOM    522  CA  LYS A  68       5.663   9.222  21.095  1.00 16.44           C  
ATOM    523  C   LYS A  68       4.350   9.513  21.864  1.00 17.36           C  
ATOM    524  O   LYS A  68       4.318  10.283  22.825  1.00 20.08           O  
ATOM    525  CB  LYS A  68       5.897  10.170  19.908  1.00 15.70           C  
ATOM    526  CG  LYS A  68       4.645  10.356  18.980  1.00 17.81           C  
ATOM    527  CD  LYS A  68       4.966  11.205  17.734  1.00 20.01           C  
ATOM    528  CE  LYS A  68       5.958  10.541  16.806  1.00 19.46           C  
ATOM    529  NZ  LYS A  68       5.561   9.169  16.354  1.00 23.63           N  
ATOM    530  N   VAL A  69       3.258   8.871  21.461  1.00 17.12           N  
ATOM    531  CA  VAL A  69       1.949   9.073  22.072  1.00 17.04           C  
ATOM    532  C   VAL A  69       1.947   8.520  23.497  1.00 16.68           C  
ATOM    533  O   VAL A  69       1.395   9.123  24.438  1.00 18.91           O  
ATOM    534  CB  VAL A  69       0.855   8.459  21.202  1.00 12.88           C  
ATOM    535  CG1 VAL A  69      -0.490   8.536  21.943  1.00 16.69           C  
ATOM    536  CG2 VAL A  69       0.801   9.178  19.889  1.00 18.62           C  
ATOM    537  N   ALA A  70       2.545   7.345  23.636  1.00 19.10           N  
ATOM    538  CA  ALA A  70       2.747   6.705  24.941  1.00 16.71           C  
ATOM    539  C   ALA A  70       3.593   7.553  25.837  1.00 15.00           C  
ATOM    540  O   ALA A  70       3.336   7.664  27.012  1.00 14.96           O  
ATOM    541  CB  ALA A  70       3.405   5.330  24.769  1.00 21.61           C  
ATOM    542  N   HIS A  71       4.629   8.166  25.274  1.00 15.61           N  
ATOM    543  CA  HIS A  71       5.470   9.127  26.039  1.00 17.19           C  
ATOM    544  C   HIS A  71       4.626  10.258  26.626  1.00 17.53           C  
ATOM    545  O   HIS A  71       4.725  10.550  27.820  1.00 16.04           O  
ATOM    546  CB  HIS A  71       6.614   9.720  25.193  1.00 17.57           C  
ATOM    547  CG  HIS A  71       7.653   8.754  24.707  1.00 20.60           C  
ATOM    548  ND1 HIS A  71       8.659   9.168  23.867  1.00 17.64           N  
ATOM    549  CD2 HIS A  71       7.835   7.424  24.883  1.00 18.34           C  
ATOM    550  CE1 HIS A  71       9.451   8.147  23.580  1.00 14.64           C  
ATOM    551  NE2 HIS A  71       8.964   7.066  24.178  1.00 17.58           N  
ATOM    552  N   ILE A  72       3.780  10.853  25.780  1.00 20.14           N  
ATOM    553  CA  ILE A  72       2.979  12.019  26.087  1.00 18.32           C  
ATOM    554  C   ILE A  72       1.895  11.623  27.069  1.00 15.47           C  
ATOM    555  O   ILE A  72       1.587  12.389  27.951  1.00 17.42           O  
ATOM    556  CB  ILE A  72       2.420  12.720  24.778  1.00 19.38           C  
ATOM    557  CG1 ILE A  72       3.595  13.329  23.974  1.00 15.00           C  
ATOM    558  CG2 ILE A  72       1.394  13.780  25.099  1.00 22.19           C  
ATOM    559  CD1 ILE A  72       3.323  13.632  22.541  1.00 18.92           C  
ATOM    560  N   ARG A  73       1.397  10.382  26.967  1.00 17.52           N  
ATOM    561  CA  ARG A  73       0.439   9.845  27.975  1.00 17.38           C  
ATOM    562  C   ARG A  73       1.037   9.891  29.393  1.00 16.82           C  
ATOM    563  O   ARG A  73       0.346  10.235  30.346  1.00 22.73           O  
ATOM    564  CB  ARG A  73      -0.004   8.406  27.648  1.00 17.55           C  
ATOM    565  CG  ARG A  73      -0.574   8.188  26.256  1.00 16.88           C  
ATOM    566  CD  ARG A  73      -1.326   6.849  26.057  1.00 23.82           C  
ATOM    567  NE  ARG A  73      -2.130   6.816  24.823  1.00 21.86           N  
ATOM    568  CZ  ARG A  73      -2.036   5.890  23.857  1.00 35.88           C  
ATOM    569  NH1 ARG A  73      -1.136   4.913  23.943  1.00 41.41           N  
ATOM    570  NH2 ARG A  73      -2.830   5.934  22.774  1.00 36.01           N  
ATOM    571  N   ARG A  74       2.314   9.542  29.528  1.00 16.89           N  
ATOM    572  CA  ARG A  74       2.991   9.512  30.841  1.00 18.45           C  
ATOM    573  C   ARG A  74       3.523  10.869  31.298  1.00 18.52           C  
ATOM    574  O   ARG A  74       3.583  11.156  32.478  1.00 20.16           O  
ATOM    575  CB  ARG A  74       4.126   8.500  30.796  1.00 21.16           C  
ATOM    576  CG  ARG A  74       3.671   7.128  30.350  1.00 28.54           C  
ATOM    577  N   ASP A  75       3.924  11.698  30.341  1.00 18.55           N  
ATOM    578  CA  ASP A  75       4.408  13.051  30.606  1.00 17.69           C  
ATOM    579  C   ASP A  75       4.103  13.953  29.409  1.00 15.60           C  
ATOM    580  O   ASP A  75       4.709  13.791  28.342  1.00 18.77           O  
ATOM    581  CB  ASP A  75       5.916  13.027  30.851  1.00 21.13           C  
ATOM    582  CG  ASP A  75       6.427  14.304  31.487  1.00 25.54           C  
ATOM    583  OD1 ASP A  75       5.814  15.394  31.354  1.00 17.55           O  
ATOM    584  OD2 ASP A  75       7.478  14.203  32.129  1.00 29.97           O  
ATOM    585  N   ALA A  76       3.137  14.862  29.599  1.00 16.34           N  
ATOM    586  CA  ALA A  76       2.632  15.771  28.550  1.00 16.94           C  
ATOM    587  C   ALA A  76       3.612  16.922  28.171  1.00 16.82           C  
ATOM    588  O   ALA A  76       3.407  17.664  27.189  1.00 18.52           O  
ATOM    589  CB  ALA A  76       1.260  16.333  28.974  1.00 21.72           C  
ATOM    590  N   ARG A  77       4.658  17.093  28.964  1.00 16.25           N  
ATOM    591  CA  ARG A  77       5.644  18.125  28.709  1.00 16.28           C  
ATOM    592  C   ARG A  77       6.548  17.771  27.540  1.00 17.94           C  
ATOM    593  O   ARG A  77       7.256  16.752  27.565  1.00 16.04           O  
ATOM    594  CB  ARG A  77       6.483  18.340  29.967  1.00 18.03           C  
ATOM    595  CG  ARG A  77       5.674  18.767  31.190  1.00 22.21           C  
ATOM    596  CD  ARG A  77       6.573  18.868  32.436  1.00 21.68           C  
ATOM    597  NE  ARG A  77       7.108  17.563  32.791  1.00 24.58           N  
ATOM    598  CZ  ARG A  77       7.806  17.306  33.891  1.00 22.00           C  
ATOM    599  NH1 ARG A  77       8.084  18.267  34.750  1.00 20.87           N  
ATOM    600  NH2 ARG A  77       8.239  16.079  34.115  1.00 25.23           N  
ATOM    601  N   VAL A  78       6.557  18.649  26.533  1.00 16.55           N  
ATOM    602  CA  VAL A  78       7.371  18.434  25.346  1.00 16.12           C  
ATOM    603  C   VAL A  78       8.088  19.686  24.984  1.00 14.28           C  
ATOM    604  O   VAL A  78       7.868  20.737  25.585  1.00 16.27           O  
ATOM    605  CB  VAL A  78       6.496  17.969  24.178  1.00 18.70           C  
ATOM    606  CG1 VAL A  78       5.698  16.668  24.582  1.00 17.70           C  
ATOM    607  CG2 VAL A  78       5.540  19.073  23.715  1.00 19.37           C  
ATOM    608  N   ALA A  79       9.081  19.558  24.085  1.00 14.58           N  
ATOM    609  CA  ALA A  79       9.803  20.751  23.590  1.00 14.82           C  
ATOM    610  C   ALA A  79       9.884  20.624  22.066  1.00 13.89           C  
ATOM    611  O   ALA A  79       9.872  19.500  21.525  1.00 15.27           O  
ATOM    612  CB  ALA A  79      11.169  20.850  24.232  1.00 19.12           C  
ATOM    613  N   ILE A  80       9.879  21.764  21.380  1.00 15.42           N  
ATOM    614  CA  ILE A  80       9.864  21.805  19.918  1.00 16.09           C  
ATOM    615  C   ILE A  80      11.010  22.674  19.435  1.00 15.96           C  
ATOM    616  O   ILE A  80      11.270  23.714  20.010  1.00 19.44           O  
ATOM    617  CB  ILE A  80       8.534  22.334  19.329  1.00 16.10           C  
ATOM    618  CG1 ILE A  80       7.335  21.501  19.832  1.00 19.39           C  
ATOM    619  CG2 ILE A  80       8.608  22.328  17.807  1.00 22.85           C  
ATOM    620  CD1 ILE A  80       6.642  22.177  20.943  1.00 32.63           C  
ATOM    621  N   HIS A  81      11.735  22.241  18.409  1.00 17.92           N  
ATOM    622  CA  HIS A  81      12.947  22.947  17.955  1.00 16.13           C  
ATOM    623  C   HIS A  81      12.956  23.091  16.424  1.00 14.36           C  
ATOM    624  O   HIS A  81      12.524  22.174  15.713  1.00 14.73           O  
ATOM    625  CB  HIS A  81      14.205  22.185  18.439  1.00 13.23           C  
ATOM    626  CG  HIS A  81      15.503  22.670  17.877  1.00 16.23           C  
ATOM    627  ND1 HIS A  81      16.021  22.217  16.687  1.00 14.17           N  
ATOM    628  CD2 HIS A  81      16.377  23.598  18.334  1.00 13.93           C  
ATOM    629  CE1 HIS A  81      17.142  22.857  16.420  1.00 17.65           C  
ATOM    630  NE2 HIS A  81      17.412  23.650  17.439  1.00 15.15           N  
ATOM    631  N   ILE A  82      13.412  24.247  15.955  1.00 13.50           N  
ATOM    632  CA  ILE A  82      13.717  24.431  14.550  1.00 15.12           C  
ATOM    633  C   ILE A  82      14.995  25.268  14.440  1.00 14.27           C  
ATOM    634  O   ILE A  82      15.162  26.264  15.184  1.00 14.60           O  
ATOM    635  CB  ILE A  82      12.590  25.172  13.783  1.00 17.15           C  
ATOM    636  CG1 ILE A  82      11.193  24.717  14.184  1.00 22.48           C  
ATOM    637  CG2 ILE A  82      12.773  24.958  12.274  1.00 24.19           C  
ATOM    638  CD1 ILE A  82      10.049  25.646  13.646  1.00 23.28           C  
ATOM    639  N   TRP A  83      15.890  24.848  13.553  1.00 17.01           N  
ATOM    640  CA  TRP A  83      17.015  25.626  13.117  1.00 18.01           C  
ATOM    641  C   TRP A  83      16.772  26.076  11.690  1.00 16.67           C  
ATOM    642  O   TRP A  83      16.525  25.264  10.782  1.00 17.33           O  
ATOM    643  CB  TRP A  83      18.273  24.789  13.210  1.00 19.26           C  
ATOM    644  CG  TRP A  83      19.490  25.341  12.568  1.00 24.10           C  
ATOM    645  CD1 TRP A  83      20.355  24.666  11.755  1.00 26.13           C  
ATOM    646  CD2 TRP A  83      20.003  26.659  12.690  1.00 28.73           C  
ATOM    647  NE1 TRP A  83      21.369  25.470  11.386  1.00 28.07           N  
ATOM    648  CE2 TRP A  83      21.188  26.708  11.928  1.00 25.51           C  
ATOM    649  CE3 TRP A  83      19.565  27.821  13.335  1.00 29.86           C  
ATOM    650  CZ2 TRP A  83      21.950  27.866  11.798  1.00 27.07           C  
ATOM    651  CZ3 TRP A  83      20.328  28.979  13.216  1.00 31.15           C  
ATOM    652  CH2 TRP A  83      21.499  28.996  12.455  1.00 28.09           C  
ATOM    653  N   ILE A  84      16.779  27.393  11.518  1.00 17.19           N  
ATOM    654  CA  ILE A  84      16.444  28.034  10.239  1.00 18.88           C  
ATOM    655  C   ILE A  84      17.645  28.884   9.800  1.00 15.53           C  
ATOM    656  O   ILE A  84      17.730  30.074  10.026  1.00 17.46           O  
ATOM    657  CB  ILE A  84      15.161  28.874  10.358  1.00 15.87           C  
ATOM    658  CG1 ILE A  84      14.072  28.106  11.106  1.00 20.99           C  
ATOM    659  CG2 ILE A  84      14.701  29.281   8.976  1.00 19.09           C  
ATOM    660  CD1 ILE A  84      12.813  28.932  11.415  1.00 22.67           C  
ATOM    661  N   PRO A  85      18.641  28.247   9.196  1.00 18.00           N  
ATOM    662  CA  PRO A  85      19.901  28.932   8.873  1.00 21.55           C  
ATOM    663  C   PRO A  85      19.738  30.172   7.980  1.00 21.66           C  
ATOM    664  O   PRO A  85      20.422  31.175   8.181  1.00 23.12           O  
ATOM    665  CB  PRO A  85      20.698  27.836   8.167  1.00 23.37           C  
ATOM    666  CG  PRO A  85      19.814  26.769   7.878  1.00 21.74           C  
ATOM    667  CD  PRO A  85      18.663  26.835   8.785  1.00 20.73           C  
ATOM    668  N   LYS A  86      18.816  30.120   7.030  1.00 21.37           N  
ATOM    669  CA  LYS A  86      18.637  31.244   6.114  1.00 21.19           C  
ATOM    670  C   LYS A  86      18.097  32.482   6.815  1.00 22.53           C  
ATOM    671  O   LYS A  86      18.329  33.590   6.347  1.00 26.94           O  
ATOM    672  CB  LYS A  86      17.738  30.857   4.937  1.00 21.36           C  
ATOM    673  CG  LYS A  86      18.341  29.814   4.013  1.00 26.62           C  
ATOM    674  N   ALA A  87      17.391  32.299   7.924  1.00 22.52           N  
ATOM    675  CA  ALA A  87      16.880  33.398   8.738  1.00 23.17           C  
ATOM    676  C   ALA A  87      17.773  33.670   9.949  1.00 23.85           C  
ATOM    677  O   ALA A  87      17.468  34.531  10.762  1.00 25.31           O  
ATOM    678  CB  ALA A  87      15.486  33.067   9.210  1.00 25.54           C  
ATOM    679  N   SER A  88      18.875  32.935  10.058  1.00 22.27           N  
ATOM    680  CA  SER A  88      19.735  32.940  11.248  1.00 23.12           C  
ATOM    681  C   SER A  88      18.928  32.855  12.537  1.00 21.50           C  
ATOM    682  O   SER A  88      19.145  33.622  13.462  1.00 23.59           O  
ATOM    683  CB  SER A  88      20.618  34.183  11.281  1.00 25.73           C  
ATOM    684  OG  SER A  88      21.410  34.231  10.128  1.00 29.40           O  
ATOM    685  N   LEU A  89      17.987  31.916  12.587  1.00 17.69           N  
ATOM    686  CA  LEU A  89      17.133  31.782  13.738  1.00 15.69           C  
ATOM    687  C   LEU A  89      17.159  30.357  14.246  1.00 15.49           C  
ATOM    688  O   LEU A  89      16.916  29.431  13.479  1.00 18.02           O  
ATOM    689  CB  LEU A  89      15.690  32.117  13.424  1.00 19.97           C  
ATOM    690  CG  LEU A  89      15.285  33.566  13.201  1.00 26.34           C  
ATOM    691  CD1 LEU A  89      13.821  33.557  12.805  1.00 27.80           C  
ATOM    692  CD2 LEU A  89      15.484  34.408  14.460  1.00 23.97           C  
ATOM    693  N   GLN A  90      17.361  30.193  15.557  1.00 15.99           N  
ATOM    694  CA  GLN A  90      16.986  28.961  16.237  1.00 14.53           C  
ATOM    695  C   GLN A  90      15.766  29.258  17.116  1.00 17.90           C  
ATOM    696  O   GLN A  90      15.744  30.237  17.871  1.00 20.99           O  
ATOM    697  CB  GLN A  90      18.155  28.414  17.084  1.00 15.54           C  
ATOM    698  CG  GLN A  90      17.730  27.333  18.079  1.00 17.23           C  
ATOM    699  CD  GLN A  90      18.845  26.722  18.905  1.00 18.82           C  
ATOM    700  OE1 GLN A  90      18.968  25.556  18.919  1.00 17.69           O  
ATOM    701  NE2 GLN A  90      19.558  27.509  19.672  1.00 19.77           N  
ATOM    702  N   VAL A  91      14.765  28.386  17.048  1.00 15.90           N  
ATOM    703  CA  VAL A  91      13.611  28.484  17.898  1.00 16.69           C  
ATOM    704  C   VAL A  91      13.506  27.248  18.794  1.00 18.42           C  
ATOM    705  O   VAL A  91      13.507  26.146  18.299  1.00 15.79           O  
ATOM    706  CB  VAL A  91      12.342  28.594  17.042  1.00 16.83           C  
ATOM    707  CG1 VAL A  91      11.060  28.680  17.914  1.00 17.56           C  
ATOM    708  CG2 VAL A  91      12.381  29.800  16.123  1.00 21.14           C  
ATOM    709  N   ARG A  92      13.420  27.471  20.106  1.00 19.64           N  
ATOM    710  CA  ARG A  92      13.118  26.432  21.146  1.00 19.49           C  
ATOM    711  C   ARG A  92      11.886  26.769  21.915  1.00 18.83           C  
ATOM    712  O   ARG A  92      11.814  27.831  22.547  1.00 20.15           O  
ATOM    713  CB  ARG A  92      14.239  26.376  22.179  1.00 17.13           C  
ATOM    714  CG  ARG A  92      15.546  26.010  21.561  1.00 16.27           C  
ATOM    715  CD  ARG A  92      16.730  26.428  22.386  1.00 20.10           C  
ATOM    716  NE  ARG A  92      16.852  25.613  23.581  1.00 18.17           N  
ATOM    717  CZ  ARG A  92      17.717  25.802  24.583  1.00 17.56           C  
ATOM    718  NH1 ARG A  92      18.538  26.842  24.630  1.00 19.17           N  
ATOM    719  NH2 ARG A  92      17.708  24.944  25.585  1.00 18.91           N  
ATOM    720  N   ALA A  93      10.918  25.857  21.923  1.00 17.41           N  
ATOM    721  CA  ALA A  93       9.623  26.107  22.516  1.00 17.89           C  
ATOM    722  C   ALA A  93       9.289  25.022  23.520  1.00 19.22           C  
ATOM    723  O   ALA A  93       9.397  23.843  23.208  1.00 22.53           O  
ATOM    724  CB  ALA A  93       8.485  26.268  21.460  1.00 19.59           C  
ATOM    725  N   LYS A  94       8.814  25.436  24.694  1.00 18.78           N  
ATOM    726  CA  LYS A  94       8.260  24.566  25.725  1.00 20.90           C  
ATOM    727  C   LYS A  94       6.742  24.503  25.507  1.00 18.86           C  
ATOM    728  O   LYS A  94       6.107  25.504  25.224  1.00 17.80           O  
ATOM    729  CB  LYS A  94       8.605  25.161  27.079  1.00 21.36           C  
ATOM    730  CG  LYS A  94       8.064  24.407  28.259  1.00 26.64           C  
ATOM    731  CD  LYS A  94       8.537  25.011  29.574  1.00 30.58           C  
ATOM    732  CE  LYS A  94       8.092  24.127  30.767  1.00 29.63           C  
ATOM    733  NZ  LYS A  94       8.265  24.808  32.074  1.00 36.26           N  
ATOM    734  N   ALA A  95       6.188  23.308  25.602  1.00 19.04           N  
ATOM    735  CA  ALA A  95       4.777  23.120  25.419  1.00 18.43           C  
ATOM    736  C   ALA A  95       4.180  21.979  26.269  1.00 14.96           C  
ATOM    737  O   ALA A  95       4.910  21.083  26.749  1.00 18.71           O  
ATOM    738  CB  ALA A  95       4.484  22.871  23.962  1.00 19.63           C  
ATOM    739  N   ILE A  96       2.863  22.018  26.397  1.00 16.35           N  
ATOM    740  CA  ILE A  96       2.090  20.843  26.814  1.00 15.84           C  
ATOM    741  C   ILE A  96       1.417  20.273  25.546  1.00 18.59           C  
ATOM    742  O   ILE A  96       0.705  20.993  24.833  1.00 17.39           O  
ATOM    743  CB  ILE A  96       0.975  21.170  27.839  1.00 17.26           C  
ATOM    744  CG1 ILE A  96       1.573  21.765  29.098  1.00 20.91           C  
ATOM    745  CG2 ILE A  96       0.218  19.904  28.184  1.00 16.99           C  
ATOM    746  CD1 ILE A  96       2.546  20.883  29.775  1.00 20.97           C  
ATOM    747  N   ALA A  97       1.572  18.984  25.336  1.00 18.63           N  
ATOM    748  CA  ALA A  97       0.977  18.274  24.197  1.00 16.73           C  
ATOM    749  C   ALA A  97      -0.371  17.637  24.604  1.00 18.40           C  
ATOM    750  O   ALA A  97      -0.472  16.965  25.622  1.00 16.77           O  
ATOM    751  CB  ALA A  97       1.950  17.228  23.666  1.00 16.56           C  
ATOM    752  N   LYS A  98      -1.398  17.875  23.799  1.00 20.04           N  
ATOM    753  CA  LYS A  98      -2.673  17.208  23.984  1.00 19.75           C  
ATOM    754  C   LYS A  98      -2.826  16.262  22.794  1.00 17.76           C  
ATOM    755  O   LYS A  98      -2.446  16.591  21.668  1.00 19.03           O  
ATOM    756  CB  LYS A  98      -3.855  18.200  24.035  1.00 20.14           C  
ATOM    757  CG  LYS A  98      -3.674  19.363  25.011  1.00 27.66           C  
ATOM    758  CD  LYS A  98      -3.849  18.949  26.445  1.00 27.21           C  
ATOM    759  N   ILE A  99      -3.300  15.053  23.064  1.00 16.89           N  
ATOM    760  CA  ILE A  99      -3.606  14.037  22.065  1.00 17.33           C  
ATOM    761  C   ILE A  99      -5.142  14.023  21.824  1.00 15.63           C  
ATOM    762  O   ILE A  99      -5.905  13.740  22.740  1.00 21.18           O  
ATOM    763  CB  ILE A  99      -3.199  12.675  22.589  1.00 19.66           C  
ATOM    764  CG1 ILE A  99      -1.691  12.589  22.826  1.00 26.14           C  
ATOM    765  CG2 ILE A  99      -3.637  11.610  21.668  1.00 23.11           C  
ATOM    766  CD1 ILE A  99      -1.289  11.524  23.936  1.00 30.01           C  
ATOM    767  N   LEU A 100      -5.574  14.333  20.604  1.00 15.23           N  
ATOM    768  CA  LEU A 100      -6.959  14.386  20.238  1.00 16.75           C  
ATOM    769  C   LEU A 100      -7.251  13.453  19.053  1.00 15.93           C  
ATOM    770  O   LEU A 100      -6.336  13.143  18.257  1.00 17.03           O  
ATOM    771  CB  LEU A 100      -7.353  15.815  19.887  1.00 18.62           C  
ATOM    772  CG  LEU A 100      -7.309  16.876  21.006  1.00 21.47           C  
ATOM    773  CD1 LEU A 100      -7.658  18.205  20.370  1.00 23.09           C  
ATOM    774  CD2 LEU A 100      -8.204  16.587  22.159  1.00 30.59           C  
ATOM    775  N   PRO A 101      -8.507  12.988  18.926  1.00 17.18           N  
ATOM    776  CA  PRO A 101      -8.880  12.165  17.765  1.00 17.44           C  
ATOM    777  C   PRO A 101      -8.665  12.970  16.467  1.00 20.79           C  
ATOM    778  O   PRO A 101      -8.957  14.170  16.464  1.00 21.94           O  
ATOM    779  CB  PRO A 101     -10.379  11.914  17.972  1.00 17.91           C  
ATOM    780  CG  PRO A 101     -10.696  12.364  19.288  1.00 18.88           C  
ATOM    781  CD  PRO A 101      -9.656  13.242  19.804  1.00 16.18           C  
ATOM    782  N   GLY A 102      -8.184  12.348  15.390  1.00 21.41           N  
ATOM    783  CA  GLY A 102      -8.220  13.029  14.088  1.00 21.02           C  
ATOM    784  C   GLY A 102      -9.626  13.212  13.522  1.00 24.59           C  
ATOM    785  O   GLY A 102     -10.554  12.536  13.922  1.00 22.30           O  
ATOM    786  N   ASP A 103      -9.763  14.140  12.582  1.00 22.46           N  
ATOM    787  CA  ASP A 103     -10.990  14.342  11.836  1.00 21.69           C  
ATOM    788  C   ASP A 103     -11.210  13.210  10.850  1.00 22.32           C  
ATOM    789  O   ASP A 103     -10.441  13.061   9.905  1.00 19.34           O  
ATOM    790  CB  ASP A 103     -10.897  15.673  11.116  1.00 24.08           C  
ATOM    791  CG  ASP A 103     -12.116  15.991  10.270  1.00 24.43           C  
ATOM    792  OD1 ASP A 103     -12.943  15.093   9.924  1.00 27.01           O  
ATOM    793  OD2 ASP A 103     -12.195  17.174   9.914  1.00 31.20           O  
ATOM    794  N   PRO A 104     -12.258  12.397  11.065  1.00 20.46           N  
ATOM    795  CA  PRO A 104     -12.430  11.276  10.163  1.00 22.68           C  
ATOM    796  C   PRO A 104     -12.744  11.671   8.715  1.00 21.64           C  
ATOM    797  O   PRO A 104     -12.532  10.857   7.809  1.00 26.27           O  
ATOM    798  CB  PRO A 104     -13.584  10.499  10.792  1.00 25.88           C  
ATOM    799  CG  PRO A 104     -14.282  11.473  11.629  1.00 23.19           C  
ATOM    800  CD  PRO A 104     -13.322  12.447  12.090  1.00 25.98           C  
ATOM    801  N   ASN A 105     -13.189  12.906   8.487  1.00 26.47           N  
ATOM    802  CA  ASN A 105     -13.493  13.356   7.116  1.00 26.17           C  
ATOM    803  C   ASN A 105     -12.230  13.701   6.356  1.00 25.05           C  
ATOM    804  O   ASN A 105     -12.117  13.413   5.163  1.00 23.76           O  
ATOM    805  CB  ASN A 105     -14.496  14.505   7.125  1.00 29.12           C  
ATOM    806  CG  ASN A 105     -15.822  14.076   7.708  1.00 30.91           C  
ATOM    807  OD1 ASN A 105     -16.548  13.291   7.095  1.00 32.35           O  
ATOM    808  ND2 ASN A 105     -16.119  14.540   8.919  1.00 27.09           N  
ATOM    809  N   LEU A 106     -11.252  14.222   7.073  1.00 19.83           N  
ATOM    810  CA  LEU A 106      -9.921  14.388   6.533  1.00 24.67           C  
ATOM    811  C   LEU A 106      -9.253  13.048   6.268  1.00 20.04           C  
ATOM    812  O   LEU A 106      -8.632  12.858   5.217  1.00 22.71           O  
ATOM    813  CB  LEU A 106      -9.060  15.187   7.508  1.00 22.71           C  
ATOM    814  CG  LEU A 106      -7.591  15.375   7.072  1.00 29.08           C  
ATOM    815  CD1 LEU A 106      -7.466  15.854   5.610  1.00 38.14           C  
ATOM    816  CD2 LEU A 106      -6.886  16.335   8.022  1.00 30.04           C  
ATOM    817  N   PHE A 107      -9.370  12.104   7.202  1.00 21.11           N  
ATOM    818  CA  PHE A 107      -8.809  10.767   6.966  1.00 20.17           C  
ATOM    819  C   PHE A 107      -9.391  10.138   5.701  1.00 16.89           C  
ATOM    820  O   PHE A 107      -8.626   9.580   4.921  1.00 21.63           O  
ATOM    821  CB  PHE A 107      -8.992   9.833   8.173  1.00 22.07           C  
ATOM    822  CG  PHE A 107      -8.243   8.528   8.055  1.00 18.72           C  
ATOM    823  CD1 PHE A 107      -6.876   8.468   8.184  1.00 21.25           C  
ATOM    824  CD2 PHE A 107      -8.935   7.351   7.811  1.00 23.17           C  
ATOM    825  CE1 PHE A 107      -6.194   7.256   8.035  1.00 27.16           C  
ATOM    826  CE2 PHE A 107      -8.278   6.127   7.685  1.00 23.97           C  
ATOM    827  CZ  PHE A 107      -6.899   6.075   7.800  1.00 22.60           C  
ATOM    828  N   ALA A 108     -10.707  10.301   5.487  1.00 18.28           N  
ATOM    829  CA  ALA A 108     -11.416   9.808   4.285  1.00 20.46           C  
ATOM    830  C   ALA A 108     -10.868  10.423   2.998  1.00 21.28           C  
ATOM    831  O   ALA A 108     -10.869   9.756   1.936  1.00 24.58           O  
ATOM    832  CB  ALA A 108     -12.905  10.054   4.421  1.00 21.37           C  
ATOM    833  N   GLN A 109     -10.332  11.651   3.113  1.00 21.31           N  
ATOM    834  CA  GLN A 109      -9.797  12.410   1.971  1.00 19.28           C  
ATOM    835  C   GLN A 109      -8.304  12.225   1.696  1.00 19.74           C  
ATOM    836  O   GLN A 109      -7.836  12.680   0.660  1.00 24.33           O  
ATOM    837  CB  GLN A 109     -10.087  13.895   2.147  1.00 18.04           C  
ATOM    838  CG  GLN A 109     -11.556  14.242   2.126  1.00 15.38           C  
ATOM    839  CD  GLN A 109     -11.807  15.720   2.300  1.00 17.46           C  
ATOM    840  OE1 GLN A 109     -10.878  16.524   2.235  1.00 21.56           O  
ATOM    841  NE2 GLN A 109     -13.045  16.084   2.532  1.00 18.69           N  
ATOM    842  N   LEU A 110      -7.571  11.536   2.567  1.00 21.73           N  
ATOM    843  CA  LEU A 110      -6.148  11.279   2.341  1.00 20.60           C  
ATOM    844  C   LEU A 110      -5.889  10.192   1.297  1.00 22.69           C  
ATOM    845  O   LEU A 110      -6.613   9.192   1.230  1.00 22.60           O  
ATOM    846  CB  LEU A 110      -5.468  10.839   3.637  1.00 24.06           C  
ATOM    847  CG  LEU A 110      -5.411  11.741   4.868  1.00 26.18           C  
ATOM    848  CD1 LEU A 110      -4.547  11.060   5.889  1.00 27.34           C  
ATOM    849  CD2 LEU A 110      -4.892  13.138   4.528  1.00 28.45           C  
ATOM    850  N   PRO A 111      -4.820  10.350   0.507  1.00 24.95           N  
ATOM    851  CA  PRO A 111      -4.327   9.264  -0.365  1.00 28.78           C  
ATOM    852  C   PRO A 111      -4.031   8.010   0.437  1.00 32.73           C  
ATOM    853  O   PRO A 111      -3.915   8.104   1.652  1.00 31.40           O  
ATOM    854  CB  PRO A 111      -3.027   9.836  -0.936  1.00 29.19           C  
ATOM    855  CG  PRO A 111      -3.226  11.323  -0.893  1.00 29.16           C  
ATOM    856  CD  PRO A 111      -4.008  11.568   0.382  1.00 25.34           C  
ATOM    857  N   GLU A 112      -3.931   6.846  -0.214  1.00 35.23           N  
ATOM    858  CA  GLU A 112      -3.659   5.590   0.523  1.00 35.09           C  
ATOM    859  C   GLU A 112      -2.229   5.546   1.035  1.00 34.57           C  
ATOM    860  O   GLU A 112      -1.953   4.938   2.039  1.00 34.15           O  
ATOM    861  CB  GLU A 112      -3.978   4.349  -0.327  1.00 38.19           C  
ATOM    862  CG  GLU A 112      -5.476   4.165  -0.651  1.00 39.17           C  
ATOM    863  CD  GLU A 112      -6.368   3.772   0.548  1.00 39.18           C  
ATOM    864  OE1 GLU A 112      -5.982   2.902   1.369  1.00 40.37           O  
ATOM    865  OE2 GLU A 112      -7.488   4.326   0.659  1.00 43.09           O  
ATOM    866  N   ALA A 113      -1.321   6.238   0.366  1.00 34.94           N  
ATOM    867  CA  ALA A 113       0.049   6.354   0.853  1.00 37.86           C  
ATOM    868  C   ALA A 113       0.065   7.101   2.189  1.00 36.89           C  
ATOM    869  O   ALA A 113       0.821   6.744   3.102  1.00 39.52           O  
ATOM    870  CB  ALA A 113       0.918   7.085  -0.165  1.00 38.58           C  
ATOM    871  N   ALA A 114      -0.772   8.131   2.301  1.00 33.97           N  
ATOM    872  CA  ALA A 114      -0.829   8.915   3.537  1.00 30.73           C  
ATOM    873  C   ALA A 114      -1.594   8.134   4.576  1.00 28.88           C  
ATOM    874  O   ALA A 114      -1.229   8.159   5.745  1.00 26.22           O  
ATOM    875  CB  ALA A 114      -1.484  10.291   3.311  1.00 31.33           C  
ATOM    876  N   ARG A 115      -2.663   7.467   4.149  1.00 27.24           N  
ATOM    877  CA  ARG A 115      -3.510   6.722   5.076  1.00 27.09           C  
ATOM    878  C   ARG A 115      -2.660   5.645   5.796  1.00 32.27           C  
ATOM    879  O   ARG A 115      -2.855   5.371   6.991  1.00 33.33           O  
ATOM    880  CB  ARG A 115      -4.763   6.166   4.373  1.00 28.74           C  
ATOM    881  CG  ARG A 115      -5.856   7.232   4.106  1.00 25.96           C  
ATOM    882  CD  ARG A 115      -6.944   6.776   3.115  1.00 28.47           C  
ATOM    883  NE  ARG A 115      -7.662   5.596   3.583  1.00 29.40           N  
ATOM    884  CZ  ARG A 115      -8.845   5.592   4.211  1.00 27.67           C  
ATOM    885  NH1 ARG A 115      -9.488   6.706   4.460  1.00 28.06           N  
ATOM    886  NH2 ARG A 115      -9.387   4.448   4.607  1.00 27.30           N  
HETATM  887  N   MSE A 116      -1.670   5.096   5.082  1.00 34.94           N  
HETATM  888  CA  MSE A 116      -0.800   4.032   5.620  1.00 33.37           C  
HETATM  889  C   MSE A 116       0.120   4.451   6.776  1.00 33.79           C  
HETATM  890  O   MSE A 116       0.524   3.607   7.557  1.00 34.55           O  
HETATM  891  CB  MSE A 116       0.009   3.397   4.482  1.00 36.25           C  
HETATM  892  CG  MSE A 116      -0.800   2.386   3.685  1.00 39.05           C  
HETATM  893 SE   MSE A 116      -1.809   1.062   4.818  0.75 49.42          SE  
HETATM  894  CE  MSE A 116      -3.650   0.996   3.795  1.00 41.75           C  
ATOM    895  N   ASN A 117       0.415   5.742   6.891  1.00 32.96           N  
ATOM    896  CA  ASN A 117       1.050   6.312   8.099  1.00 33.27           C  
ATOM    897  C   ASN A 117       0.267   6.012   9.402  1.00 32.26           C  
ATOM    898  O   ASN A 117       0.792   6.229  10.510  1.00 32.85           O  
ATOM    899  CB  ASN A 117       1.171   7.851   8.005  1.00 34.11           C  
ATOM    900  CG  ASN A 117       1.929   8.339   6.769  1.00 41.53           C  
ATOM    901  OD1 ASN A 117       2.762   7.626   6.206  1.00 50.76           O  
ATOM    902  ND2 ASN A 117       1.631   9.580   6.347  1.00 41.91           N  
ATOM    903  N   TYR A 118      -0.996   5.582   9.267  1.00 30.28           N  
ATOM    904  CA  TYR A 118      -1.911   5.367  10.417  1.00 28.93           C  
ATOM    905  C   TYR A 118      -2.537   3.956  10.347  1.00 27.02           C  
ATOM    906  O   TYR A 118      -3.555   3.656  11.008  1.00 28.18           O  
ATOM    907  CB  TYR A 118      -2.957   6.494  10.490  1.00 22.59           C  
ATOM    908  CG  TYR A 118      -2.386   7.852  10.212  1.00 23.18           C  
ATOM    909  CD1 TYR A 118      -1.739   8.603  11.212  1.00 20.58           C  
ATOM    910  CD2 TYR A 118      -2.422   8.385   8.934  1.00 22.89           C  
ATOM    911  CE1 TYR A 118      -1.156   9.879  10.936  1.00 21.31           C  
ATOM    912  CE2 TYR A 118      -1.865   9.619   8.656  1.00 18.33           C  
ATOM    913  CZ  TYR A 118      -1.210  10.388   9.660  1.00 18.74           C  
ATOM    914  OH  TYR A 118      -0.698  11.644   9.319  1.00 21.44           O  
ATOM    915  N   GLN A 119      -1.900   3.093   9.570  1.00 29.33           N  
ATOM    916  CA  GLN A 119      -2.311   1.685   9.430  1.00 28.28           C  
ATOM    917  C   GLN A 119      -1.080   0.766   9.581  1.00 26.81           C  
ATOM    918  O   GLN A 119       0.038   1.244   9.744  1.00 30.94           O  
ATOM    919  CB  GLN A 119      -2.934   1.449   8.042  1.00 31.36           C  
ATOM    920  N   GLY A 120      -1.281  -0.543   9.496  1.00 23.70           N  
ATOM    921  CA  GLY A 120      -0.148  -1.476   9.455  1.00 21.03           C  
ATOM    922  C   GLY A 120       0.415  -1.777  10.830  1.00 16.66           C  
ATOM    923  O   GLY A 120      -0.318  -1.644  11.838  1.00 16.67           O  
ATOM    924  N   PRO A 121       1.668  -2.233  10.880  1.00 16.56           N  
ATOM    925  CA  PRO A 121       2.164  -2.529  12.205  1.00 17.88           C  
ATOM    926  C   PRO A 121       2.361  -1.321  13.112  1.00 18.06           C  
ATOM    927  O   PRO A 121       2.316  -0.177  12.656  1.00 17.90           O  
ATOM    928  CB  PRO A 121       3.531  -3.169  11.950  1.00 17.66           C  
ATOM    929  CG  PRO A 121       3.594  -3.459  10.471  1.00 19.00           C  
ATOM    930  CD  PRO A 121       2.643  -2.525   9.821  1.00 20.16           C  
ATOM    931  N   VAL A 122       2.566  -1.616  14.396  1.00 18.90           N  
ATOM    932  CA  VAL A 122       2.934  -0.569  15.351  1.00 17.04           C  
ATOM    933  C   VAL A 122       4.331  -0.030  14.980  1.00 16.55           C  
ATOM    934  O   VAL A 122       5.276  -0.795  14.784  1.00 17.72           O  
ATOM    935  CB  VAL A 122       2.911  -1.098  16.782  1.00 16.89           C  
ATOM    936  CG1 VAL A 122       3.511  -0.066  17.755  1.00 21.16           C  
ATOM    937  CG2 VAL A 122       1.528  -1.489  17.143  1.00 23.34           C  
ATOM    938  N   PRO A 123       4.464   1.307  14.821  1.00 16.82           N  
ATOM    939  CA  PRO A 123       5.746   1.846  14.452  1.00 17.29           C  
ATOM    940  C   PRO A 123       6.847   1.408  15.463  1.00 16.53           C  
ATOM    941  O   PRO A 123       6.616   1.349  16.707  1.00 19.97           O  
ATOM    942  CB  PRO A 123       5.511   3.367  14.475  1.00 19.52           C  
ATOM    943  CG  PRO A 123       4.077   3.545  14.318  1.00 20.31           C  
ATOM    944  CD  PRO A 123       3.426   2.343  14.891  1.00 16.92           C  
ATOM    945  N   GLY A 124       8.013   1.066  14.966  1.00 18.07           N  
ATOM    946  CA  GLY A 124       9.072   0.579  15.834  1.00 17.13           C  
ATOM    947  C   GLY A 124       9.130  -0.906  16.061  1.00 16.38           C  
ATOM    948  O   GLY A 124      10.126  -1.407  16.567  1.00 16.66           O  
ATOM    949  N   THR A 125       8.127  -1.645  15.612  1.00 14.66           N  
ATOM    950  CA  THR A 125       8.065  -3.087  15.850  1.00 16.70           C  
ATOM    951  C   THR A 125       9.066  -3.816  14.964  1.00 15.09           C  
ATOM    952  O   THR A 125       9.131  -3.578  13.786  1.00 14.52           O  
ATOM    953  CB  THR A 125       6.679  -3.660  15.581  1.00 18.47           C  
ATOM    954  OG1 THR A 125       5.700  -2.944  16.342  1.00 19.85           O  
ATOM    955  CG2 THR A 125       6.633  -5.116  15.931  1.00 17.38           C  
ATOM    956  N   PRO A 126       9.862  -4.721  15.528  1.00 15.01           N  
ATOM    957  CA  PRO A 126      10.743  -5.506  14.680  1.00 16.35           C  
ATOM    958  C   PRO A 126       9.983  -6.282  13.585  1.00 18.56           C  
ATOM    959  O   PRO A 126       8.879  -6.824  13.821  1.00 17.81           O  
ATOM    960  CB  PRO A 126      11.408  -6.442  15.682  1.00 18.49           C  
ATOM    961  CG  PRO A 126      11.344  -5.677  16.959  1.00 18.06           C  
ATOM    962  CD  PRO A 126      10.050  -5.045  16.954  1.00 17.13           C  
ATOM    963  N   LEU A 127      10.552  -6.296  12.392  1.00 17.43           N  
ATOM    964  CA  LEU A 127       9.950  -7.011  11.253  1.00 18.32           C  
ATOM    965  C   LEU A 127      10.294  -8.488  11.311  1.00 19.17           C  
ATOM    966  O   LEU A 127      11.346  -8.859  11.856  1.00 16.14           O  
ATOM    967  CB  LEU A 127      10.408  -6.409   9.928  1.00 16.07           C  
ATOM    968  CG  LEU A 127      10.023  -4.950   9.701  1.00 19.32           C  
ATOM    969  CD1 LEU A 127      10.355  -4.536   8.294  1.00 22.00           C  
ATOM    970  CD2 LEU A 127       8.584  -4.746  10.002  1.00 23.34           C  
ATOM    971  N   PRO A 128       9.390  -9.353  10.782  1.00 20.43           N  
ATOM    972  CA  PRO A 128       8.098  -9.011  10.193  1.00 19.12           C  
ATOM    973  C   PRO A 128       7.106  -8.720  11.307  1.00 16.69           C  
ATOM    974  O   PRO A 128       7.173  -9.309  12.388  1.00 18.91           O  
ATOM    975  CB  PRO A 128       7.727 -10.288   9.413  1.00 21.03           C  
ATOM    976  CG  PRO A 128       8.330 -11.329  10.150  1.00 21.20           C  
ATOM    977  CD  PRO A 128       9.600 -10.810  10.771  1.00 23.27           C  
ATOM    978  N   ALA A 129       6.247  -7.749  11.079  1.00 18.54           N  
ATOM    979  CA  ALA A 129       5.370  -7.229  12.118  1.00 21.39           C  
ATOM    980  C   ALA A 129       3.929  -7.381  11.689  1.00 21.43           C  
ATOM    981  O   ALA A 129       3.550  -7.033  10.570  1.00 22.55           O  
ATOM    982  CB  ALA A 129       5.707  -5.742  12.389  1.00 20.98           C  
ATOM    983  N   GLU A 130       3.128  -7.886  12.614  1.00 24.11           N  
ATOM    984  CA  GLU A 130       1.700  -8.038  12.428  1.00 25.81           C  
ATOM    985  C   GLU A 130       1.041  -6.661  12.359  1.00 24.49           C  
ATOM    986  O   GLU A 130       1.353  -5.786  13.171  1.00 24.98           O  
ATOM    987  CB  GLU A 130       1.156  -8.850  13.609  1.00 27.45           C  
ATOM    988  CG  GLU A 130      -0.362  -9.116  13.599  1.00 35.59           C  
ATOM    989  CD  GLU A 130      -0.795 -10.202  12.617  1.00 46.41           C  
ATOM    990  OE1 GLU A 130       0.058 -10.727  11.846  1.00 49.82           O  
ATOM    991  OE2 GLU A 130      -2.006 -10.532  12.623  1.00 37.57           O  
ATOM    992  N   PRO A 131       0.130  -6.457  11.392  1.00 21.56           N  
ATOM    993  CA  PRO A 131      -0.733  -5.293  11.348  1.00 23.90           C  
ATOM    994  C   PRO A 131      -1.522  -5.122  12.638  1.00 21.77           C  
ATOM    995  O   PRO A 131      -2.097  -6.070  13.185  1.00 21.81           O  
ATOM    996  CB  PRO A 131      -1.694  -5.596  10.181  1.00 26.75           C  
ATOM    997  CG  PRO A 131      -0.963  -6.613   9.330  1.00 28.45           C  
ATOM    998  CD  PRO A 131      -0.123  -7.388  10.270  1.00 23.94           C  
ATOM    999  N   ASP A 132      -1.548  -3.899  13.126  1.00 22.37           N  
ATOM   1000  CA  ASP A 132      -2.259  -3.610  14.350  1.00 18.97           C  
ATOM   1001  C   ASP A 132      -3.687  -3.183  14.005  1.00 20.92           C  
ATOM   1002  O   ASP A 132      -3.892  -2.355  13.116  1.00 18.79           O  
ATOM   1003  CB  ASP A 132      -1.494  -2.557  15.109  1.00 20.46           C  
ATOM   1004  CG  ASP A 132      -2.191  -2.133  16.365  1.00 22.54           C  
ATOM   1005  OD1 ASP A 132      -3.062  -1.263  16.259  1.00 25.56           O  
ATOM   1006  OD2 ASP A 132      -1.856  -2.663  17.451  1.00 30.45           O  
ATOM   1007  N   ALA A 133      -4.669  -3.749  14.704  1.00 17.25           N  
ATOM   1008  CA  ALA A 133      -6.082  -3.494  14.408  1.00 18.38           C  
ATOM   1009  C   ALA A 133      -6.764  -2.418  15.273  1.00 16.85           C  
ATOM   1010  O   ALA A 133      -7.999  -2.325  15.274  1.00 16.40           O  
ATOM   1011  CB  ALA A 133      -6.888  -4.810  14.434  1.00 19.31           C  
ATOM   1012  N   THR A 134      -6.004  -1.581  15.982  1.00 16.02           N  
ATOM   1013  CA  THR A 134      -6.632  -0.535  16.796  1.00 18.02           C  
ATOM   1014  C   THR A 134      -7.464   0.388  15.897  1.00 13.77           C  
ATOM   1015  O   THR A 134      -6.938   0.894  14.873  1.00 18.57           O  
ATOM   1016  CB  THR A 134      -5.600   0.314  17.541  1.00 19.28           C  
ATOM   1017  OG1 THR A 134      -4.684  -0.549  18.236  1.00 20.68           O  
ATOM   1018  CG2 THR A 134      -6.301   1.257  18.539  1.00 19.91           C  
ATOM   1019  N   PRO A 135      -8.742   0.624  16.262  1.00 14.16           N  
ATOM   1020  CA  PRO A 135      -9.485   1.644  15.566  1.00 16.90           C  
ATOM   1021  C   PRO A 135      -8.981   3.059  15.830  1.00 14.21           C  
ATOM   1022  O   PRO A 135      -8.385   3.341  16.863  1.00 18.51           O  
ATOM   1023  CB  PRO A 135     -10.924   1.481  16.120  1.00 18.03           C  
ATOM   1024  CG  PRO A 135     -10.943   0.097  16.749  1.00 18.38           C  
ATOM   1025  CD  PRO A 135      -9.566  -0.081  17.255  1.00 18.61           C  
ATOM   1026  N   ASN A 136      -9.183   3.907  14.842  1.00 16.92           N  
ATOM   1027  CA  ASN A 136      -8.997   5.341  14.991  1.00 17.83           C  
ATOM   1028  C   ASN A 136      -7.590   5.789  15.370  1.00 17.06           C  
ATOM   1029  O   ASN A 136      -7.403   6.628  16.268  1.00 17.99           O  
ATOM   1030  CB  ASN A 136     -10.060   5.865  15.970  1.00 18.49           C  
ATOM   1031  CG  ASN A 136     -11.454   5.549  15.523  1.00 23.93           C  
ATOM   1032  OD1 ASN A 136     -11.794   5.765  14.361  1.00 22.01           O  
ATOM   1033  ND2 ASN A 136     -12.285   4.997  16.428  1.00 18.52           N  
ATOM   1034  N   ARG A 137      -6.602   5.259  14.638  1.00 16.28           N  
ATOM   1035  CA  ARG A 137      -5.203   5.566  14.848  1.00 18.09           C  
ATOM   1036  C   ARG A 137      -4.790   6.967  14.373  1.00 15.20           C  
ATOM   1037  O   ARG A 137      -3.845   7.488  14.896  1.00 16.50           O  
ATOM   1038  CB  ARG A 137      -4.333   4.503  14.231  1.00 18.11           C  
ATOM   1039  CG  ARG A 137      -4.289   3.253  15.135  1.00 17.31           C  
ATOM   1040  CD  ARG A 137      -3.763   2.075  14.410  1.00 20.41           C  
ATOM   1041  NE  ARG A 137      -2.335   2.217  14.157  1.00 18.39           N  
ATOM   1042  CZ  ARG A 137      -1.643   1.358  13.412  1.00 18.57           C  
ATOM   1043  NH1 ARG A 137      -2.257   0.294  12.854  1.00 17.04           N  
ATOM   1044  NH2 ARG A 137      -0.347   1.531  13.244  1.00 19.20           N  
ATOM   1045  N   PHE A 138      -5.511   7.559  13.418  1.00 15.44           N  
ATOM   1046  CA  PHE A 138      -5.256   8.951  12.975  1.00 16.53           C  
ATOM   1047  C   PHE A 138      -5.542   9.892  14.149  1.00 15.94           C  
ATOM   1048  O   PHE A 138      -6.706  10.061  14.561  1.00 18.82           O  
ATOM   1049  CB  PHE A 138      -6.122   9.259  11.745  1.00 20.29           C  
ATOM   1050  CG  PHE A 138      -5.884  10.619  11.084  1.00 15.58           C  
ATOM   1051  CD1 PHE A 138      -4.601  10.993  10.633  1.00 17.97           C  
ATOM   1052  CD2 PHE A 138      -6.976  11.439  10.789  1.00 23.95           C  
ATOM   1053  CE1 PHE A 138      -4.407  12.210   9.956  1.00 17.87           C  
ATOM   1054  CE2 PHE A 138      -6.805  12.637  10.136  1.00 23.22           C  
ATOM   1055  CZ  PHE A 138      -5.527  13.029   9.704  1.00 18.36           C  
ATOM   1056  N   THR A 139      -4.489  10.538  14.636  1.00 16.89           N  
ATOM   1057  CA  THR A 139      -4.456  11.306  15.879  0.50 16.07           C  
ATOM   1059  C   THR A 139      -3.885  12.733  15.669  1.00 16.82           C  
ATOM   1060  O   THR A 139      -2.985  12.915  14.850  1.00 19.32           O  
ATOM   1061  CB  THR A 139      -3.585  10.510  16.909  0.50 17.31           C  
ATOM   1063  OG1 THR A 139      -4.230   9.264  17.218  0.50 25.29           O  
ATOM   1065  CG2 THR A 139      -3.343  11.262  18.192  0.50 19.85           C  
ATOM   1067  N   ARG A 140      -4.354  13.695  16.463  1.00 14.68           N  
ATOM   1068  CA  ARG A 140      -3.838  15.085  16.438  1.00 16.57           C  
ATOM   1069  C   ARG A 140      -2.977  15.272  17.656  1.00 20.15           C  
ATOM   1070  O   ARG A 140      -3.364  14.928  18.773  1.00 15.23           O  
ATOM   1071  CB  ARG A 140      -4.942  16.134  16.446  1.00 17.02           C  
ATOM   1072  CG  ARG A 140      -5.856  16.065  15.292  1.00 15.63           C  
ATOM   1073  CD  ARG A 140      -7.110  16.886  15.518  1.00 16.80           C  
ATOM   1074  NE  ARG A 140      -6.853  18.318  15.346  1.00 20.55           N  
ATOM   1075  CZ  ARG A 140      -7.622  19.273  15.889  1.00 26.22           C  
ATOM   1076  NH1 ARG A 140      -8.655  18.946  16.649  1.00 33.04           N  
ATOM   1077  NH2 ARG A 140      -7.348  20.568  15.699  1.00 19.01           N  
ATOM   1078  N   LEU A 141      -1.790  15.818  17.445  1.00 17.73           N  
ATOM   1079  CA  LEU A 141      -0.948  16.173  18.551  1.00 17.71           C  
ATOM   1080  C   LEU A 141      -0.922  17.744  18.605  1.00 17.52           C  
ATOM   1081  O   LEU A 141      -0.342  18.411  17.744  1.00 18.17           O  
ATOM   1082  CB  LEU A 141       0.403  15.538  18.315  1.00 19.12           C  
ATOM   1083  CG  LEU A 141       1.291  15.294  19.496  1.00 25.57           C  
ATOM   1084  CD1 LEU A 141       2.441  14.411  19.060  1.00 26.83           C  
ATOM   1085  CD2 LEU A 141       1.793  16.601  20.039  1.00 35.31           C  
ATOM   1086  N   ILE A 142      -1.613  18.335  19.581  1.00 17.72           N  
ATOM   1087  CA  ILE A 142      -1.713  19.808  19.687  1.00 19.23           C  
ATOM   1088  C   ILE A 142      -0.768  20.302  20.776  1.00 19.98           C  
ATOM   1089  O   ILE A 142      -0.952  19.942  21.932  1.00 20.67           O  
ATOM   1090  CB  ILE A 142      -3.140  20.263  20.044  1.00 21.26           C  
ATOM   1091  CG1 ILE A 142      -4.156  19.609  19.119  1.00 20.48           C  
ATOM   1092  CG2 ILE A 142      -3.291  21.833  20.031  1.00 17.57           C  
ATOM   1093  CD1 ILE A 142      -3.868  19.801  17.701  1.00 23.71           C  
ATOM   1094  N   CYS A 143       0.183  21.153  20.417  1.00 17.98           N  
ATOM   1095  CA  CYS A 143       1.232  21.617  21.365  1.00 18.71           C  
ATOM   1096  C   CYS A 143       0.813  23.028  21.763  1.00 19.41           C  
ATOM   1097  O   CYS A 143       0.801  23.943  20.942  1.00 19.81           O  
ATOM   1098  CB  CYS A 143       2.637  21.574  20.758  1.00 20.90           C  
ATOM   1099  SG  CYS A 143       3.085  19.877  20.361  1.00 20.97           S  
ATOM   1100  N   HIS A 144       0.403  23.163  23.020  1.00 16.34           N  
ATOM   1101  CA  HIS A 144       0.135  24.446  23.622  1.00 16.53           C  
ATOM   1102  C   HIS A 144       1.405  25.074  24.182  1.00 16.62           C  
ATOM   1103  O   HIS A 144       1.901  24.704  25.228  1.00 18.87           O  
ATOM   1104  CB  HIS A 144      -0.874  24.240  24.716  1.00 16.70           C  
ATOM   1105  CG  HIS A 144      -2.206  23.782  24.203  1.00 18.71           C  
ATOM   1106  ND1 HIS A 144      -3.237  24.646  23.936  1.00 24.23           N  
ATOM   1107  CD2 HIS A 144      -2.648  22.552  23.857  1.00 21.39           C  
ATOM   1108  CE1 HIS A 144      -4.271  23.967  23.472  1.00 24.69           C  
ATOM   1109  NE2 HIS A 144      -3.927  22.696  23.396  1.00 21.00           N  
ATOM   1110  N   LEU A 145       1.939  26.032  23.444  1.00 20.91           N  
ATOM   1111  CA  LEU A 145       3.210  26.613  23.803  1.00 18.74           C  
ATOM   1112  C   LEU A 145       3.088  27.517  25.021  1.00 15.41           C  
ATOM   1113  O   LEU A 145       2.153  28.319  25.125  1.00 19.12           O  
ATOM   1114  CB  LEU A 145       3.797  27.408  22.650  1.00 21.01           C  
ATOM   1115  CG  LEU A 145       3.773  26.856  21.239  1.00 23.61           C  
ATOM   1116  CD1 LEU A 145       4.598  27.758  20.328  1.00 26.19           C  
ATOM   1117  CD2 LEU A 145       4.322  25.480  21.218  1.00 22.04           C  
ATOM   1118  N   SER A 146       4.055  27.381  25.926  1.00 16.82           N  
ATOM   1119  CA  SER A 146       4.176  28.194  27.122  1.00 15.70           C  
ATOM   1120  C   SER A 146       5.380  29.116  27.149  1.00 15.19           C  
ATOM   1121  O   SER A 146       5.384  30.105  27.884  1.00 15.78           O  
ATOM   1122  CB  SER A 146       4.212  27.314  28.364  1.00 19.24           C  
ATOM   1123  OG  SER A 146       5.371  26.533  28.392  1.00 19.60           O  
ATOM   1124  N   GLU A 147       6.457  28.763  26.427  1.00 16.83           N  
ATOM   1125  CA  GLU A 147       7.641  29.604  26.344  1.00 20.54           C  
ATOM   1126  C   GLU A 147       8.316  29.429  24.998  1.00 17.61           C  
ATOM   1127  O   GLU A 147       8.328  28.337  24.443  1.00 18.59           O  
ATOM   1128  CB  GLU A 147       8.605  29.263  27.488  1.00 18.87           C  
ATOM   1129  CG  GLU A 147       9.975  29.929  27.435  1.00 23.06           C  
ATOM   1130  CD  GLU A 147      10.964  29.316  28.416  1.00 26.26           C  
ATOM   1131  OE1 GLU A 147      10.836  29.556  29.625  1.00 31.59           O  
ATOM   1132  OE2 GLU A 147      11.885  28.592  27.971  1.00 40.92           O  
ATOM   1133  N   ILE A 148       8.822  30.522  24.446  1.00 17.15           N  
ATOM   1134  CA  ILE A 148       9.614  30.472  23.205  1.00 16.89           C  
ATOM   1135  C   ILE A 148      10.944  31.183  23.483  1.00 15.09           C  
ATOM   1136  O   ILE A 148      10.974  32.344  23.942  1.00 15.32           O  
ATOM   1137  CB  ILE A 148       8.901  31.100  22.004  1.00 16.57           C  
ATOM   1138  CG1 ILE A 148       7.544  30.398  21.714  1.00 19.46           C  
ATOM   1139  CG2 ILE A 148       9.818  31.060  20.748  1.00 22.68           C  
ATOM   1140  CD1 ILE A 148       6.567  31.173  20.717  1.00 16.70           C  
ATOM   1141  N   ASP A 149      12.049  30.488  23.193  1.00 17.59           N  
ATOM   1142  CA  ASP A 149      13.420  30.973  23.380  1.00 19.45           C  
ATOM   1143  C   ASP A 149      13.997  31.095  21.976  1.00 17.86           C  
ATOM   1144  O   ASP A 149      14.182  30.103  21.276  1.00 18.79           O  
ATOM   1145  CB  ASP A 149      14.165  29.925  24.230  1.00 20.17           C  
ATOM   1146  CG  ASP A 149      15.650  30.263  24.525  1.00 23.82           C  
ATOM   1147  OD1 ASP A 149      16.245  31.171  23.926  1.00 18.64           O  
ATOM   1148  OD2 ASP A 149      16.202  29.631  25.434  1.00 30.48           O  
ATOM   1149  N   VAL A 150      14.254  32.322  21.554  1.00 15.88           N  
ATOM   1150  CA  VAL A 150      14.719  32.596  20.219  1.00 16.25           C  
ATOM   1151  C   VAL A 150      16.134  33.088  20.218  1.00 17.54           C  
ATOM   1152  O   VAL A 150      16.438  34.112  20.877  1.00 16.75           O  
ATOM   1153  CB  VAL A 150      13.878  33.722  19.514  1.00 20.58           C  
ATOM   1154  CG1 VAL A 150      14.187  33.729  18.003  1.00 24.98           C  
ATOM   1155  CG2 VAL A 150      12.432  33.554  19.774  1.00 26.44           C  
ATOM   1156  N   LEU A 151      16.980  32.438  19.436  1.00 17.77           N  
ATOM   1157  CA  LEU A 151      18.328  32.900  19.230  1.00 18.27           C  
ATOM   1158  C   LEU A 151      18.431  33.424  17.825  1.00 16.68           C  
ATOM   1159  O   LEU A 151      18.151  32.693  16.876  1.00 16.33           O  
ATOM   1160  CB  LEU A 151      19.358  31.797  19.463  1.00 15.45           C  
ATOM   1161  CG  LEU A 151      20.836  32.118  19.189  1.00 19.28           C  
ATOM   1162  CD1 LEU A 151      21.377  33.144  20.157  1.00 19.41           C  
ATOM   1163  CD2 LEU A 151      21.621  30.816  19.324  1.00 18.89           C  
ATOM   1164  N   HIS A 152      18.847  34.676  17.690  1.00 19.22           N  
ATOM   1165  CA  HIS A 152      19.020  35.325  16.402  1.00 24.12           C  
ATOM   1166  C   HIS A 152      20.508  35.422  16.141  1.00 22.21           C  
ATOM   1167  O   HIS A 152      21.208  36.135  16.860  1.00 22.00           O  
ATOM   1168  CB  HIS A 152      18.361  36.711  16.439  1.00 25.47           C  
ATOM   1169  CG  HIS A 152      18.223  37.375  15.104  1.00 28.52           C  
ATOM   1170  ND1 HIS A 152      18.532  36.751  13.910  1.00 29.85           N  
ATOM   1171  CD2 HIS A 152      17.783  38.617  14.779  1.00 33.17           C  
ATOM   1172  CE1 HIS A 152      18.316  37.589  12.911  1.00 33.41           C  
ATOM   1173  NE2 HIS A 152      17.858  38.724  13.412  1.00 37.39           N  
ATOM   1174  N   LEU A 153      21.021  34.701  15.151  1.00 24.92           N  
ATOM   1175  CA  LEU A 153      22.479  34.572  15.012  1.00 27.46           C  
ATOM   1176  C   LEU A 153      23.030  35.707  14.141  1.00 28.59           C  
ATOM   1177  O   LEU A 153      23.800  35.490  13.198  1.00 27.94           O  
ATOM   1178  CB  LEU A 153      22.930  33.175  14.521  1.00 27.20           C  
ATOM   1179  CG  LEU A 153      22.720  32.010  15.492  1.00 25.60           C  
ATOM   1180  CD1 LEU A 153      21.285  31.512  15.286  1.00 27.19           C  
ATOM   1181  CD2 LEU A 153      23.756  30.850  15.320  1.00 30.97           C  
ATOM   1182  N   THR A 154      22.624  36.922  14.505  1.00 32.08           N  
ATOM   1183  CA  THR A 154      23.211  38.158  14.003  1.00 32.78           C  
ATOM   1184  C   THR A 154      24.685  38.217  14.402  1.00 32.15           C  
ATOM   1185  O   THR A 154      25.170  37.314  15.086  1.00 29.69           O  
ATOM   1186  CB  THR A 154      22.432  39.399  14.582  1.00 34.93           C  
ATOM   1187  OG1 THR A 154      22.124  39.221  15.977  1.00 30.74           O  
ATOM   1188  CG2 THR A 154      21.123  39.613  13.824  1.00 37.80           C  
ATOM   1189  N   THR A 155      25.396  39.274  13.993  1.00 32.38           N  
ATOM   1190  CA  THR A 155      26.726  39.561  14.563  1.00 32.89           C  
ATOM   1191  C   THR A 155      26.659  40.816  15.458  1.00 32.97           C  
ATOM   1192  O   THR A 155      26.534  41.932  14.945  1.00 35.55           O  
ATOM   1193  CB  THR A 155      27.833  39.768  13.478  1.00 35.30           C  
ATOM   1194  OG1 THR A 155      27.873  38.634  12.594  1.00 36.89           O  
ATOM   1195  CG2 THR A 155      29.216  39.943  14.137  1.00 33.71           C  
ATOM   1196  N   PRO A 156      26.684  40.633  16.795  1.00 28.44           N  
ATOM   1197  CA  PRO A 156      26.755  39.386  17.522  1.00 27.23           C  
ATOM   1198  C   PRO A 156      25.317  38.809  17.719  1.00 23.83           C  
ATOM   1199  O   PRO A 156      24.290  39.429  17.309  1.00 23.65           O  
ATOM   1200  CB  PRO A 156      27.366  39.830  18.850  1.00 28.22           C  
ATOM   1201  CG  PRO A 156      26.695  41.108  19.087  1.00 28.49           C  
ATOM   1202  CD  PRO A 156      26.555  41.762  17.736  1.00 27.97           C  
ATOM   1203  N   HIS A 157      25.253  37.642  18.338  1.00 21.06           N  
ATOM   1204  CA  HIS A 157      23.974  37.035  18.590  1.00 23.29           C  
ATOM   1205  C   HIS A 157      23.144  37.891  19.525  1.00 23.27           C  
ATOM   1206  O   HIS A 157      23.687  38.625  20.366  1.00 26.08           O  
ATOM   1207  CB  HIS A 157      24.149  35.663  19.209  1.00 22.15           C  
ATOM   1208  CG  HIS A 157      24.682  34.639  18.261  1.00 27.53           C  
ATOM   1209  ND1 HIS A 157      25.277  34.974  17.061  1.00 39.26           N  
ATOM   1210  CD2 HIS A 157      24.771  33.292  18.361  1.00 32.35           C  
ATOM   1211  CE1 HIS A 157      25.677  33.873  16.449  1.00 35.88           C  
ATOM   1212  NE2 HIS A 157      25.394  32.840  17.220  1.00 37.42           N  
ATOM   1213  N   GLN A 158      21.826  37.832  19.355  1.00 17.63           N  
ATOM   1214  CA  GLN A 158      20.897  38.275  20.401  1.00 19.55           C  
ATOM   1215  C   GLN A 158      19.875  37.175  20.680  1.00 17.51           C  
ATOM   1216  O   GLN A 158      19.631  36.328  19.851  1.00 16.66           O  
ATOM   1217  CB  GLN A 158      20.290  39.649  20.112  1.00 21.17           C  
ATOM   1218  CG  GLN A 158      19.288  39.776  19.074  1.00 24.52           C  
ATOM   1219  CD  GLN A 158      18.857  41.250  18.882  1.00 29.04           C  
ATOM   1220  OE1 GLN A 158      19.059  42.110  19.769  1.00 29.11           O  
ATOM   1221  NE2 GLN A 158      18.260  41.536  17.737  1.00 38.15           N  
ATOM   1222  N   ARG A 159      19.348  37.154  21.889  1.00 15.14           N  
ATOM   1223  CA  ARG A 159      18.505  36.067  22.323  1.00 15.61           C  
ATOM   1224  C   ARG A 159      17.431  36.576  23.235  1.00 15.48           C  
ATOM   1225  O   ARG A 159      17.680  37.421  24.108  1.00 15.28           O  
ATOM   1226  CB  ARG A 159      19.335  35.009  23.043  1.00 16.60           C  
ATOM   1227  CG  ARG A 159      18.544  33.770  23.506  1.00 18.85           C  
ATOM   1228  CD  ARG A 159      19.571  32.813  24.127  1.00 18.18           C  
ATOM   1229  NE  ARG A 159      18.916  31.688  24.779  1.00 20.20           N  
ATOM   1230  CZ  ARG A 159      19.485  30.920  25.721  1.00 21.51           C  
ATOM   1231  NH1 ARG A 159      20.720  31.146  26.130  1.00 21.89           N  
ATOM   1232  NH2 ARG A 159      18.786  29.934  26.261  1.00 21.62           N  
ATOM   1233  N   ALA A 160      16.222  36.088  22.995  1.00 16.64           N  
ATOM   1234  CA  ALA A 160      15.052  36.547  23.763  1.00 14.13           C  
ATOM   1235  C   ALA A 160      14.203  35.379  24.198  1.00 17.56           C  
ATOM   1236  O   ALA A 160      14.120  34.388  23.500  1.00 16.29           O  
ATOM   1237  CB  ALA A 160      14.186  37.537  22.945  1.00 16.65           C  
ATOM   1238  N   VAL A 161      13.510  35.547  25.317  1.00 15.91           N  
ATOM   1239  CA  VAL A 161      12.625  34.528  25.862  1.00 16.09           C  
ATOM   1240  C   VAL A 161      11.272  35.184  26.097  1.00 17.59           C  
ATOM   1241  O   VAL A 161      11.190  36.238  26.708  1.00 18.12           O  
ATOM   1242  CB  VAL A 161      13.167  33.926  27.176  1.00 17.01           C  
ATOM   1243  CG1 VAL A 161      12.158  32.969  27.802  1.00 21.89           C  
ATOM   1244  CG2 VAL A 161      14.454  33.226  26.941  1.00 18.08           C  
ATOM   1245  N   TYR A 162      10.233  34.545  25.570  1.00 15.39           N  
ATOM   1246  CA  TYR A 162       8.843  34.995  25.628  1.00 14.76           C  
ATOM   1247  C   TYR A 162       8.026  33.904  26.317  1.00 18.49           C  
ATOM   1248  O   TYR A 162       8.205  32.712  26.072  1.00 15.97           O  
ATOM   1249  CB  TYR A 162       8.312  35.234  24.223  1.00 15.84           C  
ATOM   1250  CG  TYR A 162       9.179  36.096  23.301  1.00 12.97           C  
ATOM   1251  CD1 TYR A 162      10.284  35.562  22.643  1.00 15.85           C  
ATOM   1252  CD2 TYR A 162       8.923  37.444  23.152  1.00 13.77           C  
ATOM   1253  CE1 TYR A 162      11.071  36.356  21.798  1.00 16.03           C  
ATOM   1254  CE2 TYR A 162       9.691  38.237  22.340  1.00 19.07           C  
ATOM   1255  CZ  TYR A 162      10.767  37.706  21.674  1.00 18.44           C  
ATOM   1256  OH  TYR A 162      11.519  38.508  20.850  1.00 19.20           O  
ATOM   1257  N   THR A 163       7.046  34.329  27.125  1.00 16.87           N  
ATOM   1258  CA  THR A 163       6.316  33.436  28.036  1.00 19.86           C  
ATOM   1259  C   THR A 163       4.817  33.778  27.979  1.00 22.20           C  
ATOM   1260  O   THR A 163       4.429  34.943  27.960  1.00 23.08           O  
ATOM   1261  CB  THR A 163       6.841  33.637  29.500  1.00 23.90           C  
ATOM   1262  OG1 THR A 163       8.237  33.331  29.577  1.00 25.49           O  
ATOM   1263  CG2 THR A 163       6.165  32.746  30.457  1.00 24.08           C  
ATOM   1264  N   ALA A 164       3.975  32.723  27.858  1.00 19.55           N  
ATOM   1265  CA  ALA A 164       2.524  32.846  27.915  1.00 21.26           C  
ATOM   1266  C   ALA A 164       2.080  33.407  29.277  1.00 23.50           C  
ATOM   1267  O   ALA A 164       2.749  33.157  30.285  1.00 23.26           O  
ATOM   1268  CB  ALA A 164       1.913  31.483  27.668  1.00 20.38           C  
ATOM   1269  N   PRO A 165       0.938  34.139  29.322  1.00 21.73           N  
ATOM   1270  CA  PRO A 165      -0.037  34.387  28.274  1.00 21.82           C  
ATOM   1271  C   PRO A 165       0.142  35.688  27.506  1.00 24.00           C  
ATOM   1272  O   PRO A 165      -0.532  35.875  26.477  1.00 24.58           O  
ATOM   1273  CB  PRO A 165      -1.339  34.450  29.063  1.00 23.55           C  
ATOM   1274  CG  PRO A 165      -0.924  35.144  30.329  1.00 22.65           C  
ATOM   1275  CD  PRO A 165       0.506  34.751  30.588  1.00 24.34           C  
ATOM   1276  N   ASP A 166       1.046  36.556  27.983  1.00 25.40           N  
ATOM   1277  CA  ASP A 166       1.260  37.896  27.451  0.50 24.37           C  
ATOM   1279  C   ASP A 166       2.337  37.950  26.347  1.00 24.37           C  
ATOM   1280  O   ASP A 166       2.302  38.803  25.451  1.00 24.37           O  
ATOM   1281  CB  ASP A 166       1.590  38.871  28.608  0.50 25.60           C  
ATOM   1283  CG  ASP A 166       2.486  38.247  29.726  0.50 23.67           C  
ATOM   1285  OD1 ASP A 166       2.978  37.091  29.618  0.50 23.09           O  
ATOM   1287  OD2 ASP A 166       2.711  38.954  30.739  0.50 30.36           O  
ATOM   1289  N   TRP A 167       3.314  37.055  26.425  1.00 23.56           N  
ATOM   1290  CA  TRP A 167       4.383  36.987  25.418  1.00 21.20           C  
ATOM   1291  C   TRP A 167       5.196  38.282  25.162  1.00 23.17           C  
ATOM   1292  O   TRP A 167       5.643  38.554  24.034  1.00 21.54           O  
ATOM   1293  CB  TRP A 167       3.792  36.458  24.082  1.00 21.09           C  
ATOM   1294  CG  TRP A 167       3.077  35.134  24.180  1.00 16.60           C  
ATOM   1295  CD1 TRP A 167       1.725  34.927  24.214  1.00 20.71           C  
ATOM   1296  CD2 TRP A 167       3.676  33.827  24.244  1.00 16.36           C  
ATOM   1297  NE1 TRP A 167       1.457  33.584  24.300  1.00 18.12           N  
ATOM   1298  CE2 TRP A 167       2.636  32.888  24.317  1.00 17.67           C  
ATOM   1299  CE3 TRP A 167       4.994  33.371  24.264  1.00 17.85           C  
ATOM   1300  CZ2 TRP A 167       2.868  31.531  24.398  1.00 16.94           C  
ATOM   1301  CZ3 TRP A 167       5.225  32.022  24.339  1.00 20.14           C  
ATOM   1302  CH2 TRP A 167       4.169  31.113  24.394  1.00 16.41           C  
ATOM   1303  N   ARG A 168       5.434  39.061  26.204  1.00 21.69           N  
ATOM   1304  CA  ARG A 168       6.112  40.351  26.056  1.00 22.96           C  
ATOM   1305  C   ARG A 168       7.610  40.304  25.680  1.00 23.20           C  
ATOM   1306  O   ARG A 168       8.094  41.129  24.849  1.00 25.33           O  
ATOM   1307  CB  ARG A 168       5.921  41.174  27.332  1.00 23.48           C  
ATOM   1308  CG  ARG A 168       4.497  41.531  27.573  1.00 21.24           C  
ATOM   1309  CD  ARG A 168       4.352  42.326  28.851  1.00 26.37           C  
ATOM   1310  NE  ARG A 168       3.122  43.129  28.814  1.00 28.78           N  
ATOM   1311  CZ  ARG A 168       1.959  42.805  29.386  1.00 35.97           C  
ATOM   1312  NH1 ARG A 168       1.822  41.686  30.092  1.00 43.53           N  
ATOM   1313  NH2 ARG A 168       0.918  43.630  29.270  1.00 38.61           N  
ATOM   1314  N   GLY A 169       8.321  39.381  26.319  1.00 19.66           N  
ATOM   1315  CA  GLY A 169       9.722  39.114  26.055  1.00 18.98           C  
ATOM   1316  C   GLY A 169      10.680  39.765  27.039  1.00 18.89           C  
ATOM   1317  O   GLY A 169      10.389  40.836  27.601  1.00 19.62           O  
ATOM   1318  N   ILE A 170      11.828  39.103  27.230  1.00 18.20           N  
ATOM   1319  CA  ILE A 170      13.019  39.700  27.826  1.00 20.78           C  
ATOM   1320  C   ILE A 170      14.265  39.275  27.061  1.00 18.50           C  
ATOM   1321  O   ILE A 170      14.306  38.190  26.481  1.00 19.71           O  
ATOM   1322  CB  ILE A 170      13.177  39.338  29.316  1.00 21.23           C  
ATOM   1323  CG1 ILE A 170      13.266  37.834  29.536  1.00 22.17           C  
ATOM   1324  CG2 ILE A 170      11.994  39.868  30.116  1.00 25.15           C  
ATOM   1325  CD1 ILE A 170      14.000  37.458  30.802  1.00 25.40           C  
ATOM   1326  N   TRP A 171      15.267  40.143  27.052  1.00 15.82           N  
ATOM   1327  CA  TRP A 171      16.538  39.842  26.455  1.00 14.52           C  
ATOM   1328  C   TRP A 171      17.363  39.050  27.454  1.00 16.82           C  
ATOM   1329  O   TRP A 171      17.419  39.383  28.656  1.00 15.59           O  
ATOM   1330  CB  TRP A 171      17.286  41.126  26.076  1.00 17.18           C  
ATOM   1331  CG  TRP A 171      16.626  41.914  25.039  1.00 15.66           C  
ATOM   1332  CD1 TRP A 171      16.049  43.131  25.196  1.00 16.82           C  
ATOM   1333  CD2 TRP A 171      16.469  41.560  23.657  1.00 20.17           C  
ATOM   1334  NE1 TRP A 171      15.539  43.568  24.006  1.00 16.64           N  
ATOM   1335  CE2 TRP A 171      15.758  42.623  23.038  1.00 18.55           C  
ATOM   1336  CE3 TRP A 171      16.824  40.445  22.896  1.00 20.40           C  
ATOM   1337  CZ2 TRP A 171      15.398  42.605  21.671  1.00 19.73           C  
ATOM   1338  CZ3 TRP A 171      16.483  40.431  21.527  1.00 20.09           C  
ATOM   1339  CH2 TRP A 171      15.769  41.500  20.940  1.00 20.98           C  
ATOM   1340  N   VAL A 172      18.055  38.021  26.960  1.00 17.91           N  
ATOM   1341  CA  VAL A 172      18.876  37.181  27.813  1.00 14.74           C  
ATOM   1342  C   VAL A 172      20.236  36.968  27.174  1.00 15.52           C  
ATOM   1343  O   VAL A 172      20.430  37.154  25.960  1.00 16.35           O  
ATOM   1344  CB  VAL A 172      18.187  35.788  28.113  1.00 16.67           C  
ATOM   1345  CG1 VAL A 172      16.786  35.980  28.708  1.00 16.29           C  
ATOM   1346  CG2 VAL A 172      18.111  34.955  26.864  1.00 17.07           C  
ATOM   1347  N   SER A 173      21.202  36.538  27.979  1.00 15.47           N  
ATOM   1348  CA  SER A 173      22.494  36.289  27.413  1.00 16.96           C  
ATOM   1349  C   SER A 173      22.464  35.062  26.518  1.00 20.65           C  
ATOM   1350  O   SER A 173      21.889  34.020  26.910  1.00 19.29           O  
ATOM   1351  CB  SER A 173      23.537  36.086  28.508  1.00 17.27           C  
ATOM   1352  OG  SER A 173      24.868  36.251  28.016  1.00 21.89           O  
ATOM   1353  N   PRO A 174      23.078  35.177  25.321  1.00 19.84           N  
ATOM   1354  CA  PRO A 174      23.247  34.000  24.458  1.00 21.02           C  
ATOM   1355  C   PRO A 174      23.977  32.879  25.197  1.00 25.54           C  
ATOM   1356  O   PRO A 174      24.874  33.140  26.021  1.00 25.94           O  
ATOM   1357  CB  PRO A 174      24.061  34.544  23.285  1.00 23.75           C  
ATOM   1358  CG  PRO A 174      23.663  35.949  23.195  1.00 23.94           C  
ATOM   1359  CD  PRO A 174      23.581  36.386  24.651  1.00 20.86           C  
ATOM   1360  OXT PRO A 174      23.603  31.707  25.062  1.00 27.14           O  
TER    1361      PRO A 174                                                      
END
MOLECULE T0497.pdb
ATOM      5  N   MET     1      13.726  45.186  17.326  1.00 86.05           N  
ATOM      6  CA  MET     1      13.854  43.790  16.854  1.00 85.86           C  
ATOM      7  C   MET     1      13.936  42.784  18.030  1.00 83.85           C  
ATOM      8  O   MET     1      13.538  41.620  17.875  1.00 83.45           O  
ATOM      9  CB  MET     1      15.056  43.633  15.890  1.00 86.69           C  
ATOM     10  CG  MET     1      16.377  43.182  16.523  1.00 88.68           C  
ATOM     11  SD  MET     1      17.988  43.731  15.614  0.75 92.01          SE  
ATOM     12  CE  MET     1      19.110  42.057  15.901  1.00 88.06           C  
ATOM     13  N   ALA     2      14.466  43.250  19.173  1.00 81.16           N  
ATOM     14  CA  ALA     2      14.590  42.453  20.391  1.00 79.87           C  
ATOM     15  C   ALA     2      13.345  42.445  21.296  1.00 78.34           C  
ATOM     16  O   ALA     2      13.382  41.748  22.306  1.00 77.90           O  
ATOM     17  CB  ALA     2      15.820  42.896  21.195  1.00 79.19           C  
ATOM     18  N   ASP     3      12.264  43.181  20.962  1.00 78.03           N  
ATOM     19  CA  ASP     3      11.048  43.193  21.798  0.50 77.68           C  
ATOM     21  C   ASP     3      10.259  41.889  21.613  1.00 78.01           C  
ATOM     22  O   ASP     3      10.343  41.273  20.544  1.00 77.66           O  
ATOM     23  CB  ASP     3      10.174  44.413  21.482  0.50 76.52           C  
ATOM     25  CG  ASP     3      10.832  45.730  21.887  0.50 70.99           C  
ATOM     27  OD1 ASP     3      11.319  45.846  23.031  0.50 59.83           O  
ATOM     29  OD2 ASP     3      10.834  46.662  21.065  0.50 63.66           O  
ATOM     31  N   PRO     4       9.492  41.452  22.649  1.00 78.39           N  
ATOM     32  CA  PRO     4       8.737  40.183  22.525  1.00 78.04           C  
ATOM     33  C   PRO     4       7.714  40.059  21.383  1.00 77.52           C  
ATOM     34  O   PRO     4       7.550  38.958  20.872  1.00 78.02           O  
ATOM     35  CB  PRO     4       8.035  40.049  23.895  1.00 77.81           C  
ATOM     36  CG  PRO     4       7.965  41.401  24.410  1.00 79.56           C  
ATOM     37  CD  PRO     4       9.243  42.058  23.973  1.00 78.48           C  
ATOM     38  N   LYS     5       7.054  41.151  20.996  1.00 77.64           N  
ATOM     39  CA  LYS     5       6.046  41.131  19.915  1.00 76.64           C  
ATOM     40  C   LYS     5       6.667  40.855  18.541  1.00 75.44           C  
ATOM     41  O   LYS     5       6.147  40.032  17.799  1.00 74.56           O  
ATOM     42  CB  LYS     5       5.236  42.433  19.904  1.00 77.43           C  
ATOM     43  CG  LYS     5       4.157  42.589  18.809  1.00 78.67           C  
ATOM     44  CD  LYS     5       3.166  41.414  18.745  1.00 83.74           C  
ATOM     45  CE  LYS     5       1.946  41.759  17.884  1.00 85.48           C  
ATOM     46  NZ  LYS     5       2.287  42.297  16.531  1.00 87.86           N  
ATOM     47  N   GLU     6       7.765  41.537  18.211  1.00 74.70           N  
ATOM     48  CA  GLU     6       8.451  41.325  16.925  1.00 74.09           C  
ATOM     49  C   GLU     6       9.058  39.927  16.840  1.00 72.42           C  
ATOM     50  O   GLU     6       9.009  39.306  15.782  1.00 71.12           O  
ATOM     51  CB  GLU     6       9.522  42.390  16.642  1.00 72.75           C  
ATOM     52  CG  GLU     6       8.964  43.783  16.364  1.00 74.88           C  
ATOM     53  N   LEU     7       9.619  39.446  17.952  1.00 71.95           N  
ATOM     54  CA  LEU     7      10.216  38.109  18.022  1.00 71.61           C  
ATOM     55  C   LEU     7       9.159  37.010  17.931  1.00 70.57           C  
ATOM     56  O   LEU     7       9.353  36.020  17.231  1.00 70.00           O  
ATOM     57  CB  LEU     7      11.053  37.939  19.297  1.00 72.48           C  
ATOM     58  CG  LEU     7      12.379  38.701  19.340  1.00 74.29           C  
ATOM     59  CD1 LEU     7      12.939  38.740  20.750  1.00 73.61           C  
ATOM     60  CD2 LEU     7      13.383  38.093  18.346  1.00 73.78           C  
ATOM     61  N   GLN     8       8.053  37.187  18.645  1.00 70.21           N  
ATOM     62  CA  GLN     8       6.950  36.242  18.577  1.00 70.98           C  
ATOM     63  C   GLN     8       6.400  36.178  17.129  1.00 70.04           C  
ATOM     64  O   GLN     8       6.181  35.094  16.610  1.00 69.96           O  
ATOM     65  CB  GLN     8       5.864  36.595  19.612  1.00 70.88           C  
ATOM     66  CG  GLN     8       4.709  35.596  19.639  1.00 74.74           C  
ATOM     67  CD  GLN     8       3.784  35.686  20.860  1.00 74.95           C  
ATOM     68  OE1 GLN     8       2.872  34.845  21.009  1.00 81.07           O  
ATOM     69  NE2 GLN     8       3.997  36.686  21.731  1.00 75.50           N  
ATOM     70  N   ASP     9       6.209  37.341  16.497  1.00 69.03           N  
ATOM     71  CA  ASP     9       5.728  37.442  15.104  1.00 68.39           C  
ATOM     72  C   ASP     9       6.646  36.715  14.117  1.00 67.45           C  
ATOM     73  O   ASP     9       6.150  35.967  13.266  1.00 68.40           O  
ATOM     74  CB  ASP     9       5.538  38.907  14.668  1.00 67.15           C  
ATOM     75  CG  ASP     9       4.327  39.587  15.326  1.00 68.12           C  
ATOM     76  OD1 ASP     9       3.360  38.916  15.752  1.00 66.97           O  
ATOM     77  OD2 ASP     9       4.336  40.835  15.391  1.00 72.15           O  
ATOM     78  N   LYS    10       7.958  36.932  14.238  1.00 65.30           N  
ATOM     79  CA  LYS    10       8.949  36.236  13.400  1.00 66.18           C  
ATOM     80  C   LYS    10       8.919  34.726  13.623  1.00 65.37           C  
ATOM     81  O   LYS    10       9.059  33.953  12.672  1.00 64.60           O  
ATOM     82  CB  LYS    10      10.379  36.717  13.676  1.00 66.97           C  
ATOM     83  CG  LYS    10      10.726  38.076  13.126  1.00 68.25           C  
ATOM     84  CD  LYS    10      12.172  38.403  13.489  1.00 67.43           C  
ATOM     85  CE  LYS    10      12.640  39.737  12.936  1.00 69.89           C  
ATOM     86  NZ  LYS    10      14.068  39.991  13.369  1.00 70.59           N  
ATOM     87  N   PHE    11       8.778  34.325  14.890  1.00 64.73           N  
ATOM     88  CA  PHE    11       8.679  32.908  15.248  1.00 64.13           C  
ATOM     89  C   PHE    11       7.501  32.203  14.554  1.00 62.79           C  
ATOM     90  O   PHE    11       7.703  31.224  13.846  1.00 62.00           O  
ATOM     91  CB  PHE    11       8.606  32.715  16.770  1.00 64.85           C  
ATOM     92  CG  PHE    11       8.128  31.361  17.169  1.00 65.60           C  
ATOM     93  CD1 PHE    11       8.969  30.261  17.035  1.00 65.90           C  
ATOM     94  CD2 PHE    11       6.821  31.171  17.631  1.00 66.31           C  
ATOM     95  CE1 PHE    11       8.527  28.974  17.367  1.00 65.48           C  
ATOM     96  CE2 PHE    11       6.373  29.897  17.971  1.00 65.66           C  
ATOM     97  CZ  PHE    11       7.240  28.793  17.849  1.00 64.98           C  
ATOM     98  N   TRP    12       6.290  32.699  14.786  1.00 62.76           N  
ATOM     99  CA  TRP    12       5.095  32.138  14.164  1.00 64.24           C  
ATOM    100  C   TRP    12       5.156  32.130  12.618  1.00 63.97           C  
ATOM    101  O   TRP    12       4.725  31.157  12.000  1.00 63.92           O  
ATOM    102  CB  TRP    12       3.829  32.863  14.604  1.00 65.03           C  
ATOM    103  CG  TRP    12       3.457  32.681  16.017  1.00 63.68           C  
ATOM    104  CD1 TRP    12       3.341  33.660  16.952  1.00 64.00           C  
ATOM    105  CD2 TRP    12       3.146  31.449  16.675  1.00 67.38           C  
ATOM    106  NE1 TRP    12       2.964  33.122  18.152  1.00 66.48           N  
ATOM    107  CE2 TRP    12       2.850  31.764  18.024  1.00 65.04           C  
ATOM    108  CE3 TRP    12       3.082  30.107  16.261  1.00 64.03           C  
ATOM    109  CZ2 TRP    12       2.478  30.790  18.967  1.00 66.99           C  
ATOM    110  CZ3 TRP    12       2.728  29.129  17.209  1.00 65.28           C  
ATOM    111  CH2 TRP    12       2.427  29.476  18.541  1.00 65.62           C  
ATOM    112  N   LYS    13       5.716  33.185  12.031  1.00 63.71           N  
ATOM    113  CA  LYS    13       5.891  33.272  10.576  1.00 65.47           C  
ATOM    114  C   LYS    13       6.833  32.171  10.061  1.00 64.51           C  
ATOM    115  O   LYS    13       6.554  31.527   9.035  1.00 63.48           O  
ATOM    116  CB  LYS    13       6.437  34.649  10.179  1.00 65.83           C  
ATOM    117  CG  LYS    13       6.467  34.958   8.674  1.00 65.60           C  
ATOM    118  CD  LYS    13       7.293  36.239   8.447  1.00 67.39           C  
ATOM    119  CE  LYS    13       7.540  36.582   6.978  1.00 72.72           C  
ATOM    120  NZ  LYS    13       6.403  37.268   6.291  1.00 77.16           N  
ATOM    121  N   ALA    14       7.934  31.957  10.781  1.00 63.23           N  
ATOM    122  CA  ALA    14       8.915  30.938  10.392  1.00 62.31           C  
ATOM    123  C   ALA    14       8.343  29.550  10.645  1.00 61.62           C  
ATOM    124  O   ALA    14       8.500  28.680   9.820  1.00 61.28           O  
ATOM    125  CB  ALA    14      10.220  31.124  11.128  1.00 62.06           C  
ATOM    126  N   LEU    15       7.661  29.360  11.774  1.00 63.05           N  
ATOM    127  CA  LEU    15       7.090  28.062  12.111  1.00 63.38           C  
ATOM    128  C   LEU    15       6.057  27.653  11.096  1.00 63.95           C  
ATOM    129  O   LEU    15       6.019  26.491  10.720  1.00 62.84           O  
ATOM    130  CB  LEU    15       6.436  28.052  13.493  1.00 63.75           C  
ATOM    131  CG  LEU    15       5.826  26.702  13.961  1.00 63.96           C  
ATOM    132  CD1 LEU    15       6.941  25.682  14.102  1.00 62.00           C  
ATOM    133  CD2 LEU    15       5.036  26.839  15.266  1.00 62.15           C  
ATOM    134  N   LYS    16       5.220  28.605  10.672  1.00 65.58           N  
ATOM    135  CA  LYS    16       4.143  28.292   9.740  1.00 66.91           C  
ATOM    136  C   LYS    16       4.657  27.898   8.345  1.00 66.08           C  
ATOM    137  O   LYS    16       4.116  26.984   7.737  1.00 66.49           O  
ATOM    138  CB  LYS    16       3.082  29.395   9.676  1.00 67.00           C  
ATOM    139  CG  LYS    16       1.879  28.927   8.881  1.00 69.94           C  
ATOM    140  CD  LYS    16       0.664  29.755   9.027  1.00 69.31           C  
ATOM    141  CE  LYS    16      -0.516  29.056   8.326  1.00 69.26           C  
ATOM    142  NZ  LYS    16      -1.008  27.907   9.104  1.00 65.56           N  
ATOM    143  N   SER    17       5.696  28.567   7.854  1.00 66.10           N  
ATOM    144  CA  SER    17       6.248  28.227   6.551  1.00 65.35           C  
ATOM    145  C   SER    17       7.270  27.069   6.578  1.00 65.04           C  
ATOM    146  O   SER    17       7.323  26.315   5.615  1.00 65.07           O  
ATOM    147  CB  SER    17       6.853  29.447   5.884  1.00 65.18           C  
ATOM    148  OG  SER    17       7.974  29.877   6.577  1.00 71.43           O  
ATOM    149  N   ASP    18       8.051  26.927   7.653  1.00 63.43           N  
ATOM    150  CA  ASP    18       9.121  25.920   7.718  1.00 63.53           C  
ATOM    151  C   ASP    18       8.739  24.638   8.462  1.00 63.23           C  
ATOM    152  O   ASP    18       9.279  23.584   8.157  1.00 62.99           O  
ATOM    153  CB  ASP    18      10.405  26.562   8.246  1.00 63.75           C  
ATOM    154  CG  ASP    18      10.870  27.725   7.383  1.00 61.31           C  
ATOM    155  OD1 ASP    18      10.465  27.840   6.209  1.00 63.82           O  
ATOM    156  OD2 ASP    18      11.684  28.527   7.866  1.00 66.28           O  
ATOM    157  N   ARG    19       7.866  24.742   9.462  1.00 63.86           N  
ATOM    158  CA  ARG    19       7.186  23.580  10.105  1.00 64.11           C  
ATOM    159  C   ARG    19       7.929  22.557  10.969  1.00 62.46           C  
ATOM    160  O   ARG    19       7.410  22.169  12.013  1.00 61.74           O  
ATOM    161  CB  ARG    19       6.388  22.816   9.034  1.00 63.62           C  
ATOM    162  CG  ARG    19       5.393  23.691   8.272  1.00 67.91           C  
ATOM    163  CD  ARG    19       4.563  22.875   7.257  1.00 71.16           C  
ATOM    164  NE  ARG    19       3.187  23.389   7.168  1.00 87.12           N  
ATOM    165  CZ  ARG    19       2.155  22.781   6.554  1.00 93.44           C  
ATOM    166  NH1 ARG    19       2.294  21.602   5.906  1.00 94.97           N  
ATOM    167  NH2 ARG    19       0.951  23.374   6.579  1.00 94.24           N  
ATOM    168  N   THR    20       9.114  22.110  10.559  1.00 62.82           N  
ATOM    169  CA  THR    20       9.813  21.035  11.278  1.00 62.12           C  
ATOM    170  C   THR    20      10.289  21.449  12.675  1.00 62.25           C  
ATOM    171  O   THR    20      10.986  22.453  12.837  1.00 62.77           O  
ATOM    172  CB  THR    20      10.976  20.473  10.473  1.00 61.39           C  
ATOM    173  OG1 THR    20      10.525  20.203   9.142  1.00 57.65           O  
ATOM    174  CG2 THR    20      11.518  19.168  11.113  1.00 60.69           C  
ATOM    175  N   VAL    21       9.827  20.703  13.672  1.00 61.75           N  
ATOM    176  CA  VAL    21      10.223  20.849  15.081  1.00 61.41           C  
ATOM    177  C   VAL    21      10.738  19.484  15.562  1.00 60.57           C  
ATOM    178  O   VAL    21      10.059  18.480  15.358  1.00 60.04           O  
ATOM    179  CB  VAL    21       9.033  21.273  15.979  1.00 60.48           C  
ATOM    180  CG1 VAL    21       9.498  21.463  17.457  1.00 54.74           C  
ATOM    181  CG2 VAL    21       8.372  22.566  15.416  1.00 58.54           C  
ATOM    182  N   MET    22      11.933  19.486  16.162  1.00 62.27           N  
ATOM    183  CA  MET    22      12.554  18.294  16.762  0.50 63.02           C  
ATOM    185  C   MET    22      11.975  18.227  18.188  1.00 63.56           C  
ATOM    186  O   MET    22      12.339  19.014  19.049  1.00 61.75           O  
ATOM    187  CB  MET    22      14.081  18.448  16.778  0.50 63.15           C  
ATOM    189  CG  MET    22      14.878  17.312  17.398  0.50 62.14           C  
ATOM    191  SD  MET    22      15.028  15.746  16.284  0.38 65.65          SE  
ATOM    193  CE  MET    22      16.508  16.277  15.168  0.50 63.37           C  
ATOM    195  N   LEU    23      11.057  17.291  18.427  1.00 65.21           N  
ATOM    196  CA  LEU    23      10.365  17.155  19.718  1.00 65.88           C  
ATOM    197  C   LEU    23      10.875  16.040  20.578  1.00 67.75           C  
ATOM    198  O   LEU    23      10.906  14.880  20.139  1.00 68.07           O  
ATOM    199  CB  LEU    23       8.854  16.903  19.526  1.00 67.56           C  
ATOM    200  CG  LEU    23       7.857  18.043  19.478  1.00 71.70           C  
ATOM    201  CD1 LEU    23       6.457  17.461  19.191  1.00 72.00           C  
ATOM    202  CD2 LEU    23       7.878  18.806  20.780  1.00 67.11           C  
ATOM    203  N   GLY    24      11.168  16.377  21.834  1.00 69.16           N  
ATOM    204  CA  GLY    24      11.643  15.425  22.815  1.00 69.80           C  
ATOM    205  C   GLY    24      10.884  15.598  24.108  1.00 70.76           C  
ATOM    206  O   GLY    24      10.494  16.710  24.465  1.00 70.97           O  
ATOM    207  N   LEU    25      10.735  14.494  24.830  1.00 72.47           N  
ATOM    208  CA  LEU    25      10.015  14.463  26.091  1.00 74.34           C  
ATOM    209  C   LEU    25      11.010  14.993  27.150  1.00 74.96           C  
ATOM    210  O   LEU    25      12.145  14.525  27.228  1.00 73.70           O  
ATOM    211  CB  LEU    25       9.503  13.033  26.394  1.00 72.84           C  
ATOM    212  CG  LEU    25       8.015  12.953  26.735  1.00 72.49           C  
ATOM    213  CD1 LEU    25       7.161  13.401  25.557  1.00 69.61           C  
ATOM    214  CD2 LEU    25       7.623  11.535  27.118  1.00 75.59           C  
ATOM    215  N   ASP    26      10.589  16.011  27.903  1.00 76.90           N  
ATOM    216  CA  ASP    26      11.405  16.637  28.950  1.00 77.57           C  
ATOM    217  C   ASP    26      11.492  15.718  30.181  1.00 78.59           C  
ATOM    218  O   ASP    26      10.601  14.907  30.414  1.00 78.82           O  
ATOM    219  CB  ASP    26      10.802  17.995  29.359  1.00 78.83           C  
ATOM    220  CG  ASP    26      11.741  18.816  30.227  1.00 81.71           C  
ATOM    221  OD1 ASP    26      12.559  19.572  29.658  1.00 83.33           O  
ATOM    222  OD2 ASP    26      11.656  18.697  31.477  1.00 86.77           O  
ATOM    223  N   GLY    27      12.588  15.839  30.931  1.00 79.96           N  
ATOM    224  CA  GLY    27      12.803  15.090  32.163  1.00 81.85           C  
ATOM    225  C   GLY    27      12.993  13.589  32.069  1.00 82.54           C  
ATOM    226  O   GLY    27      12.705  12.893  33.043  1.00 82.96           O  
ATOM    227  N   VAL    28      13.517  13.090  30.947  1.00 83.40           N  
ATOM    228  CA  VAL    28      13.666  11.631  30.732  1.00 83.75           C  
ATOM    229  C   VAL    28      15.039  11.179  30.220  1.00 85.25           C  
ATOM    230  O   VAL    28      15.856  11.988  29.769  1.00 85.54           O  
ATOM    231  CB  VAL    28      12.585  11.094  29.742  1.00 84.15           C  
ATOM    232  CG1 VAL    28      11.212  11.221  30.329  1.00 84.76           C  
ATOM    233  CG2 VAL    28      12.650  11.807  28.426  1.00 81.15           C  
ATOM    234  N   GLU    29      15.252   9.860  30.326  1.00 86.69           N  
ATOM    235  CA  GLU    29      16.440   9.141  29.835  1.00 86.65           C  
ATOM    236  C   GLU    29      16.421   9.238  28.292  1.00 86.73           C  
ATOM    237  O   GLU    29      17.189  10.022  27.712  1.00 87.28           O  
ATOM    238  CB  GLU    29      16.408   7.674  30.358  1.00 86.71           C  
ATOM    239  CG  GLU    29      17.569   6.733  29.973  1.00 86.87           C  
ATOM    240  CD  GLU    29      18.839   6.941  30.784  1.00 87.16           C  
ATOM    241  OE1 GLU    29      19.032   8.033  31.364  1.00 87.24           O  
ATOM    242  OE2 GLU    29      19.658   5.996  30.835  1.00 86.54           O  
ATOM    243  N   ASP    30      15.501   8.507  27.654  1.00 86.31           N  
ATOM    244  CA  ASP    30      15.326   8.521  26.204  1.00 85.65           C  
ATOM    245  C   ASP    30      14.176   9.495  25.941  1.00 83.74           C  
ATOM    246  O   ASP    30      13.006   9.191  26.217  1.00 82.36           O  
ATOM    247  CB  ASP    30      15.018   7.105  25.670  1.00 86.22           C  
ATOM    248  CG  ASP    30      14.946   7.025  24.122  1.00 87.39           C  
ATOM    249  OD1 ASP    30      15.191   8.032  23.397  1.00 89.81           O  
ATOM    250  OD2 ASP    30      14.642   5.911  23.630  1.00 88.30           O  
ATOM    251  N   GLY    31      14.531  10.679  25.430  1.00 82.51           N  
ATOM    252  CA  GLY    31      13.562  11.723  25.081  1.00 80.49           C  
ATOM    253  C   GLY    31      12.677  11.425  23.878  1.00 79.75           C  
ATOM    254  O   GLY    31      11.636  12.076  23.721  1.00 78.15           O  
ATOM    255  N   HIS    32      13.078  10.442  23.053  1.00 78.92           N  
ATOM    256  CA  HIS    32      12.392  10.079  21.807  1.00 78.38           C  
ATOM    257  C   HIS    32      12.324  11.305  20.877  1.00 76.42           C  
ATOM    258  O   HIS    32      11.267  11.624  20.292  1.00 76.30           O  
ATOM    259  CB  HIS    32      11.031   9.430  22.090  1.00 78.51           C  
ATOM    260  CG  HIS    32      11.137   8.161  22.875  1.00 81.02           C  
ATOM    261  ND1 HIS    32      11.167   8.137  24.253  1.00 82.96           N  
ATOM    262  CD2 HIS    32      11.253   6.875  22.474  1.00 80.06           C  
ATOM    263  CE1 HIS    32      11.275   6.889  24.669  1.00 81.78           C  
ATOM    264  NE2 HIS    32      11.329   6.104  23.609  1.00 83.16           N  
ATOM    265  N   ALA    33      13.479  11.984  20.772  1.00 74.02           N  
ATOM    266  CA  ALA    33      13.626  13.184  19.948  1.00 72.19           C  
ATOM    267  C   ALA    33      13.449  12.783  18.497  1.00 69.70           C  
ATOM    268  O   ALA    33      14.078  11.814  18.039  1.00 67.12           O  
ATOM    269  CB  ALA    33      14.987  13.859  20.151  1.00 71.80           C  
ATOM    270  N   ARG    34      12.556  13.488  17.806  1.00 67.19           N  
ATOM    271  CA  ARG    34      12.339  13.250  16.393  1.00 67.22           C  
ATOM    272  C   ARG    34      11.691  14.442  15.720  1.00 64.44           C  
ATOM    273  O   ARG    34      10.952  15.196  16.381  1.00 63.48           O  
ATOM    274  CB  ARG    34      11.540  11.965  16.150  1.00 67.18           C  
ATOM    275  CG  ARG    34      10.172  11.922  16.792  1.00 71.28           C  
ATOM    276  CD  ARG    34       9.592  10.502  16.810  1.00 72.39           C  
ATOM    277  NE  ARG    34      10.255   9.616  17.784  1.00 81.01           N  
ATOM    278  CZ  ARG    34      11.288   8.782  17.558  1.00 84.19           C  
ATOM    279  NH1 ARG    34      11.871   8.654  16.352  1.00 86.28           N  
ATOM    280  NH2 ARG    34      11.755   8.044  18.570  1.00 85.67           N  
ATOM    281  N   PRO    35      11.967  14.626  14.405  1.00 62.56           N  
ATOM    282  CA  PRO    35      11.426  15.765  13.686  1.00 62.47           C  
ATOM    283  C   PRO    35      10.011  15.537  13.223  1.00 61.87           C  
ATOM    284  O   PRO    35       9.737  14.514  12.622  1.00 62.42           O  
ATOM    285  CB  PRO    35      12.380  15.911  12.504  1.00 62.79           C  
ATOM    286  CG  PRO    35      12.923  14.613  12.292  1.00 63.92           C  
ATOM    287  CD  PRO    35      12.796  13.802  13.519  1.00 61.73           C  
ATOM    288  N   MET    36       9.127  16.489  13.525  1.00 62.63           N  
ATOM    289  CA  MET    36       7.711  16.439  13.142  1.00 63.63           C  
ATOM    290  C   MET    36       7.276  17.753  12.556  1.00 61.06           C  
ATOM    291  O   MET    36       7.868  18.789  12.833  1.00 58.73           O  
ATOM    292  CB  MET    36       6.852  16.100  14.341  1.00 63.46           C  
ATOM    293  CG  MET    36       7.253  14.748  14.930  1.00 70.87           C  
ATOM    294  SD  MET    36       6.058  14.216  16.269  0.75 71.16          SE  
ATOM    295  CE  MET    36       4.760  13.683  15.149  1.00 72.71           C  
ATOM    296  N   THR    37       6.192  17.695  11.797  1.00 60.76           N  
ATOM    297  CA  THR    37       5.691  18.830  11.015  1.00 61.43           C  
ATOM    298  C   THR    37       4.609  19.633  11.756  1.00 61.72           C  
ATOM    299  O   THR    37       3.489  19.163  11.945  1.00 62.45           O  
ATOM    300  CB  THR    37       5.194  18.316   9.652  1.00 61.45           C  
ATOM    301  OG1 THR    37       6.248  17.555   9.038  1.00 59.62           O  
ATOM    302  CG2 THR    37       4.794  19.463   8.737  1.00 60.60           C  
ATOM    303  N   ALA    38       4.965  20.832  12.204  1.00 61.37           N  
ATOM    304  CA  ALA    38       4.027  21.700  12.904  1.00 62.54           C  
ATOM    305  C   ALA    38       2.965  22.281  11.944  1.00 63.67           C  
ATOM    306  O   ALA    38       3.258  22.588  10.802  1.00 63.92           O  
ATOM    307  CB  ALA    38       4.762  22.829  13.609  1.00 62.62           C  
ATOM    308  N   GLN    39       1.724  22.329  12.411  1.00 65.02           N  
ATOM    309  CA  GLN    39       0.640  23.011  11.738  1.00 65.99           C  
ATOM    310  C   GLN    39      -0.092  23.849  12.786  1.00 65.24           C  
ATOM    311  O   GLN    39      -0.253  23.414  13.934  1.00 63.32           O  
ATOM    312  CB  GLN    39      -0.320  22.029  11.100  1.00 66.62           C  
ATOM    313  CG  GLN    39       0.320  21.221   9.999  1.00 71.74           C  
ATOM    314  CD  GLN    39      -0.640  20.379   9.188  1.00 70.73           C  
ATOM    315  OE1 GLN    39      -0.287  19.246   8.822  1.00 82.77           O  
ATOM    316  NE2 GLN    39      -1.852  20.917   8.876  1.00 71.37           N  
ATOM    317  N   ILE    40      -0.485  25.058  12.399  1.00 65.86           N  
ATOM    318  CA  ILE    40      -1.327  25.933  13.232  1.00 66.67           C  
ATOM    319  C   ILE    40      -2.519  26.452  12.390  1.00 67.29           C  
ATOM    320  O   ILE    40      -2.403  26.617  11.177  1.00 66.21           O  
ATOM    321  CB  ILE    40      -0.512  27.114  13.872  1.00 66.43           C  
ATOM    322  CG1 ILE    40      -0.119  28.195  12.854  1.00 64.90           C  
ATOM    323  CG2 ILE    40       0.743  26.583  14.584  1.00 66.36           C  
ATOM    324  CD1 ILE    40       0.694  29.355  13.464  1.00 66.76           C  
ATOM    325  N   GLU    41      -3.651  26.712  13.035  1.00 67.88           N  
ATOM    326  CA  GLU    41      -4.796  27.321  12.351  1.00 68.19           C  
ATOM    327  C   GLU    41      -4.506  28.811  12.417  1.00 68.29           C  
ATOM    328  O   GLU    41      -4.081  29.315  13.447  1.00 67.75           O  
ATOM    329  CB  GLU    41      -6.122  26.965  13.011  1.00 67.65           C  
ATOM    330  CG  GLU    41      -6.338  25.465  13.148  1.00 67.09           C  
ATOM    331  CD  GLU    41      -7.748  25.110  13.531  1.00 69.19           C  
ATOM    332  OE1 GLU    41      -8.005  24.874  14.734  1.00 70.22           O  
ATOM    333  OE2 GLU    41      -8.613  25.101  12.630  1.00 72.58           O  
ATOM    334  N   GLY    42      -4.715  29.512  11.315  1.00 69.31           N  
ATOM    335  CA  GLY    42      -4.371  30.923  11.232  1.00 70.73           C  
ATOM    336  C   GLY    42      -2.881  31.113  10.995  1.00 72.32           C  
ATOM    337  O   GLY    42      -2.152  30.168  10.670  1.00 71.78           O  
ATOM    338  N   ASP    43      -2.439  32.350  11.171  1.00 74.76           N  
ATOM    339  CA  ASP    43      -1.040  32.751  10.935  1.00 76.24           C  
ATOM    340  C   ASP    43      -0.192  32.843  12.215  1.00 76.23           C  
ATOM    341  O   ASP    43       1.043  32.789  12.142  1.00 75.95           O  
ATOM    342  CB  ASP    43      -1.047  34.066  10.152  1.00 77.32           C  
ATOM    343  CG  ASP    43      -1.873  33.966   8.854  1.00 80.76           C  
ATOM    344  OD1 ASP    43      -1.801  32.923   8.153  1.00 84.46           O  
ATOM    345  OD2 ASP    43      -2.602  34.929   8.543  1.00 86.27           O  
ATOM    346  N   SER    44      -0.847  32.986  13.368  1.00 75.83           N  
ATOM    347  CA  SER    44      -0.172  32.991  14.672  1.00 76.04           C  
ATOM    348  C   SER    44      -0.974  32.203  15.726  1.00 74.54           C  
ATOM    349  O   SER    44      -2.106  31.772  15.497  1.00 74.05           O  
ATOM    350  CB  SER    44       0.034  34.432  15.162  1.00 75.37           C  
ATOM    351  OG  SER    44      -1.194  35.014  15.568  1.00 77.39           O  
ATOM    352  N   GLY    45      -0.354  32.041  16.881  1.00 73.61           N  
ATOM    353  CA  GLY    45      -0.959  31.406  18.034  1.00 73.37           C  
ATOM    354  C   GLY    45      -1.141  29.913  17.966  1.00 72.49           C  
ATOM    355  O   GLY    45      -1.494  29.371  16.939  1.00 72.76           O  
ATOM    356  N   GLY    46      -0.921  29.244  19.090  1.00 72.31           N  
ATOM    357  CA  GLY    46      -1.103  27.797  19.180  1.00 70.26           C  
ATOM    358  C   GLY    46      -2.585  27.445  19.311  1.00 68.19           C  
ATOM    359  O   GLY    46      -3.421  28.324  19.176  1.00 67.96           O  
ATOM    360  N   PRO    47      -2.921  26.163  19.564  1.00 66.61           N  
ATOM    361  CA  PRO    47      -1.986  25.041  19.729  1.00 65.95           C  
ATOM    362  C   PRO    47      -1.200  24.697  18.459  1.00 64.51           C  
ATOM    363  O   PRO    47      -1.618  25.063  17.361  1.00 65.61           O  
ATOM    364  CB  PRO    47      -2.895  23.871  20.133  1.00 65.74           C  
ATOM    365  CG  PRO    47      -4.206  24.502  20.510  1.00 68.47           C  
ATOM    366  CD  PRO    47      -4.322  25.722  19.704  1.00 66.10           C  
ATOM    367  N   ILE    48      -0.054  24.051  18.639  1.00 62.85           N  
ATOM    368  CA  ILE    48       0.774  23.589  17.536  1.00 62.67           C  
ATOM    369  C   ILE    48       0.409  22.103  17.403  1.00 61.35           C  
ATOM    370  O   ILE    48       0.603  21.307  18.348  1.00 61.17           O  
ATOM    371  CB  ILE    48       2.284  23.820  17.807  1.00 62.84           C  
ATOM    372  CG1 ILE    48       2.573  25.334  17.988  1.00 65.82           C  
ATOM    373  CG2 ILE    48       3.112  23.258  16.679  1.00 55.88           C  
ATOM    374  CD1 ILE    48       3.926  25.655  18.683  1.00 63.10           C  
ATOM    375  N   TRP    49      -0.105  21.748  16.231  1.00 59.20           N  
ATOM    376  CA  TRP    49      -0.565  20.413  15.929  1.00 58.95           C  
ATOM    377  C   TRP    49       0.455  19.634  15.100  1.00 59.22           C  
ATOM    378  O   TRP    49       1.116  20.194  14.236  1.00 60.26           O  
ATOM    379  CB  TRP    49      -1.874  20.491  15.160  1.00 60.06           C  
ATOM    380  CG  TRP    49      -2.976  21.246  15.842  1.00 61.83           C  
ATOM    381  CD1 TRP    49      -3.241  22.581  15.740  1.00 62.31           C  
ATOM    382  CD2 TRP    49      -3.946  20.712  16.746  1.00 63.23           C  
ATOM    383  NE1 TRP    49      -4.333  22.910  16.499  1.00 63.51           N  
ATOM    384  CE2 TRP    49      -4.791  21.785  17.130  1.00 64.70           C  
ATOM    385  CE3 TRP    49      -4.192  19.430  17.258  1.00 60.45           C  
ATOM    386  CZ2 TRP    49      -5.871  21.617  18.015  1.00 64.00           C  
ATOM    387  CZ3 TRP    49      -5.269  19.247  18.125  1.00 62.95           C  
ATOM    388  CH2 TRP    49      -6.096  20.343  18.504  1.00 65.90           C  
ATOM    389  N   PHE    50       0.544  18.336  15.359  1.00 59.87           N  
ATOM    390  CA  PHE    50       1.432  17.408  14.667  1.00 59.82           C  
ATOM    391  C   PHE    50       0.679  16.129  14.288  1.00 60.06           C  
ATOM    392  O   PHE    50       0.203  15.427  15.169  1.00 59.72           O  
ATOM    393  CB  PHE    50       2.602  17.023  15.567  1.00 60.78           C  
ATOM    394  CG  PHE    50       3.443  18.176  15.986  1.00 57.50           C  
ATOM    395  CD1 PHE    50       4.467  18.641  15.155  1.00 56.54           C  
ATOM    396  CD2 PHE    50       3.231  18.797  17.213  1.00 61.39           C  
ATOM    397  CE1 PHE    50       5.263  19.740  15.538  1.00 61.15           C  
ATOM    398  CE2 PHE    50       4.026  19.911  17.619  1.00 61.39           C  
ATOM    399  CZ  PHE    50       5.038  20.379  16.783  1.00 59.11           C  
ATOM    400  N   PHE    51       0.540  15.873  12.980  1.00 60.22           N  
ATOM    401  CA  PHE    51      -0.034  14.639  12.465  1.00 60.99           C  
ATOM    402  C   PHE    51       0.996  13.534  12.659  1.00 62.77           C  
ATOM    403  O   PHE    51       2.188  13.735  12.416  1.00 61.23           O  
ATOM    404  CB  PHE    51      -0.437  14.730  10.980  1.00 59.72           C  
ATOM    405  CG  PHE    51      -1.811  15.267  10.760  1.00 59.54           C  
ATOM    406  CD1 PHE    51      -2.924  14.421  10.890  1.00 59.07           C  
ATOM    407  CD2 PHE    51      -2.018  16.612  10.431  1.00 56.93           C  
ATOM    408  CE1 PHE    51      -4.227  14.898  10.691  1.00 56.00           C  
ATOM    409  CE2 PHE    51      -3.315  17.101  10.230  1.00 57.90           C  
ATOM    410  CZ  PHE    51      -4.425  16.242  10.352  1.00 55.28           C  
ATOM    411  N   THR    52       0.529  12.363  13.087  1.00 64.97           N  
ATOM    412  CA  THR    52       1.431  11.252  13.360  1.00 66.70           C  
ATOM    413  C   THR    52       0.715   9.907  13.320  1.00 68.53           C  
ATOM    414  O   THR    52      -0.503   9.849  13.124  1.00 67.55           O  
ATOM    415  CB  THR    52       2.156  11.486  14.732  1.00 66.81           C  
ATOM    416  OG1 THR    52       3.324  10.661  14.826  1.00 66.69           O  
ATOM    417  CG2 THR    52       1.218  11.261  15.929  1.00 67.16           C  
ATOM    418  N   SER    53       1.503   8.842  13.475  1.00 71.02           N  
ATOM    419  CA  SER    53       1.007   7.462  13.488  1.00 73.79           C  
ATOM    420  C   SER    53       0.726   7.057  14.924  1.00 74.03           C  
ATOM    421  O   SER    53       1.457   7.448  15.825  1.00 73.97           O  
ATOM    422  CB  SER    53       2.028   6.511  12.842  1.00 74.45           C  
ATOM    423  OG  SER    53       3.347   6.758  13.326  1.00 77.89           O  
ATOM    424  N   LYS    54      -0.317   6.249  15.122  1.00 75.47           N  
ATOM    425  CA  LYS    54      -0.727   5.767  16.466  1.00 76.05           C  
ATOM    426  C   LYS    54       0.378   4.954  17.194  1.00 76.73           C  
ATOM    427  O   LYS    54       0.372   4.863  18.430  1.00 76.65           O  
ATOM    428  CB  LYS    54      -2.038   4.962  16.384  1.00 75.95           C  
ATOM    429  CG  LYS    54      -2.723   4.735  17.727  1.00 75.99           C  
ATOM    430  N   ASP    55       1.312   4.393  16.415  1.00 77.08           N  
ATOM    431  CA  ASP    55       2.486   3.668  16.927  1.00 77.47           C  
ATOM    432  C   ASP    55       3.756   4.543  17.137  1.00 77.73           C  
ATOM    433  O   ASP    55       4.865   4.003  17.202  1.00 77.71           O  
ATOM    434  CB  ASP    55       2.769   2.405  16.057  1.00 78.39           C  
ATOM    435  CG  ASP    55       3.146   2.723  14.594  1.00 79.86           C  
ATOM    436  OD1 ASP    55       3.702   3.814  14.296  1.00 76.90           O  
ATOM    437  OD2 ASP    55       2.882   1.844  13.742  1.00 75.84           O  
ATOM    438  N   ASN    56       3.604   5.877  17.225  1.00 78.26           N  
ATOM    439  CA  ASN    56       4.730   6.786  17.527  1.00 77.69           C  
ATOM    440  C   ASN    56       5.063   6.579  19.009  1.00 77.79           C  
ATOM    441  O   ASN    56       4.163   6.580  19.850  1.00 77.84           O  
ATOM    442  CB  ASN    56       4.373   8.259  17.235  1.00 78.20           C  
ATOM    443  CG  ASN    56       5.575   9.239  17.393  1.00 78.54           C  
ATOM    444  OD1 ASN    56       6.618   8.904  17.961  1.00 81.25           O  
ATOM    445  ND2 ASN    56       5.402  10.467  16.892  1.00 76.95           N  
ATOM    446  N   ALA    57       6.353   6.390  19.305  1.00 77.88           N  
ATOM    447  CA  ALA    57       6.862   6.139  20.673  1.00 77.42           C  
ATOM    448  C   ALA    57       6.356   7.121  21.743  1.00 77.21           C  
ATOM    449  O   ALA    57       6.012   6.703  22.852  1.00 78.12           O  
ATOM    450  CB  ALA    57       8.395   6.125  20.674  1.00 78.03           C  
ATOM    451  N   LEU    58       6.293   8.404  21.390  1.00 75.66           N  
ATOM    452  CA  LEU    58       5.806   9.455  22.297  1.00 75.14           C  
ATOM    453  C   LEU    58       4.381   9.207  22.822  1.00 74.76           C  
ATOM    454  O   LEU    58       4.159   9.244  24.039  1.00 75.19           O  
ATOM    455  CB  LEU    58       5.835  10.823  21.607  1.00 75.44           C  
ATOM    456  CG  LEU    58       7.167  11.385  21.116  1.00 75.89           C  
ATOM    457  CD1 LEU    58       6.926  12.648  20.323  1.00 77.91           C  
ATOM    458  CD2 LEU    58       8.087  11.656  22.285  1.00 78.44           C  
ATOM    459  N   ILE    59       3.464   8.877  21.906  1.00 73.25           N  
ATOM    460  CA  ILE    59       2.014   8.743  22.190  1.00 73.11           C  
ATOM    461  C   ILE    59       1.621   8.007  23.482  1.00 72.50           C  
ATOM    462  O   ILE    59       0.824   8.533  24.266  1.00 72.90           O  
ATOM    463  CB  ILE    59       1.236   8.119  20.986  1.00 72.45           C  
ATOM    464  CG1 ILE    59       1.214   9.077  19.803  1.00 71.37           C  
ATOM    465  CG2 ILE    59      -0.223   7.792  21.357  1.00 72.55           C  
ATOM    466  CD1 ILE    59       0.611   8.451  18.569  1.00 73.52           C  
ATOM    467  N   ALA    60       2.187   6.822  23.703  1.00 72.02           N  
ATOM    468  CA  ALA    60       1.866   6.014  24.898  1.00 71.94           C  
ATOM    469  C   ALA    60       2.331   6.613  26.247  1.00 71.50           C  
ATOM    470  O   ALA    60       1.842   6.197  27.297  1.00 71.70           O  
ATOM    471  CB  ALA    60       2.408   4.598  24.738  1.00 71.96           C  
ATOM    472  N   MET    61       3.257   7.573  26.188  1.00 71.59           N  
ATOM    473  CA  MET    61       3.829   8.262  27.356  0.50 71.96           C  
ATOM    475  C   MET    61       3.029   9.526  27.769  1.00 70.87           C  
ATOM    476  O   MET    61       3.049   9.928  28.920  1.00 70.86           O  
ATOM    477  CB  MET    61       5.308   8.657  27.063  0.50 72.25           C  
ATOM    479  CG  MET    61       6.197   7.492  26.514  0.50 73.77           C  
ATOM    481  SD  MET    61       8.167   7.783  26.352  0.38 75.42          SE  
ATOM    483  CE  MET    61       8.247   9.135  25.028  0.50 75.19           C  
ATOM    485  N   LEU    62       2.283  10.118  26.842  1.00 69.59           N  
ATOM    486  CA  LEU    62       1.606  11.414  27.092  1.00 68.81           C  
ATOM    487  C   LEU    62       0.483  11.543  28.142  1.00 66.71           C  
ATOM    488  O   LEU    62       0.504  12.487  28.924  1.00 65.74           O  
ATOM    489  CB  LEU    62       1.144  12.039  25.760  1.00 68.82           C  
ATOM    490  CG  LEU    62       2.150  12.080  24.597  1.00 66.91           C  
ATOM    491  CD1 LEU    62       1.573  12.864  23.444  1.00 65.18           C  
ATOM    492  CD2 LEU    62       3.503  12.641  25.019  1.00 67.43           C  
ATOM    493  N   GLY    63      -0.484  10.630  28.152  1.00 66.16           N  
ATOM    494  CA  GLY    63      -1.649  10.712  29.056  1.00 66.32           C  
ATOM    495  C   GLY    63      -2.434  12.035  28.966  1.00 65.63           C  
ATOM    496  O   GLY    63      -2.892  12.444  27.902  1.00 65.48           O  
ATOM    497  N   GLN    64      -2.526  12.726  30.095  1.00 66.49           N  
ATOM    498  CA  GLN    64      -3.162  14.057  30.221  1.00 66.40           C  
ATOM    499  C   GLN    64      -2.281  15.170  29.596  1.00 64.88           C  
ATOM    500  O   GLN    64      -2.723  16.288  29.421  1.00 63.57           O  
ATOM    501  CB  GLN    64      -3.361  14.351  31.738  1.00 68.24           C  
ATOM    502  CG  GLN    64      -4.310  15.495  32.149  1.00 68.00           C  
ATOM    503  CD  GLN    64      -4.161  15.929  33.634  1.00 67.37           C  
ATOM    504  OE1 GLN    64      -3.052  16.233  34.087  1.00 72.68           O  
ATOM    505  NE2 GLN    64      -5.281  15.989  34.375  1.00 55.14           N  
ATOM    506  N   GLY    65      -1.024  14.859  29.299  1.00 64.73           N  
ATOM    507  CA  GLY    65      -0.069  15.787  28.750  1.00 65.43           C  
ATOM    508  C   GLY    65       1.242  15.662  29.502  1.00 66.21           C  
ATOM    509  O   GLY    65       1.241  15.457  30.712  1.00 66.90           O  
ATOM    510  N   ARG    66       2.352  15.729  28.776  1.00 67.81           N  
ATOM    511  CA  ARG    66       3.709  15.714  29.342  1.00 68.20           C  
ATOM    512  C   ARG    66       4.434  16.905  28.823  1.00 68.16           C  
ATOM    513  O   ARG    66       4.195  17.319  27.686  1.00 67.24           O  
ATOM    514  CB  ARG    66       4.485  14.473  28.947  1.00 68.79           C  
ATOM    515  CG  ARG    66       4.023  13.260  29.688  1.00 75.77           C  
ATOM    516  CD  ARG    66       5.041  12.160  29.651  1.00 84.49           C  
ATOM    517  NE  ARG    66       6.263  12.502  30.375  1.00 88.64           N  
ATOM    518  CZ  ARG    66       7.240  11.643  30.675  1.00 91.91           C  
ATOM    519  NH1 ARG    66       7.168  10.346  30.342  1.00 92.78           N  
ATOM    520  NH2 ARG    66       8.309  12.087  31.343  1.00 93.03           N  
ATOM    521  N   ARG    67       5.352  17.429  29.633  1.00 69.22           N  
ATOM    522  CA  ARG    67       6.094  18.619  29.252  1.00 70.73           C  
ATOM    523  C   ARG    67       7.126  18.197  28.198  1.00 67.85           C  
ATOM    524  O   ARG    67       7.712  17.123  28.299  1.00 68.41           O  
ATOM    525  CB  ARG    67       6.756  19.329  30.455  1.00 70.26           C  
ATOM    526  CG  ARG    67       6.821  20.848  30.221  1.00 76.57           C  
ATOM    527  CD  ARG    67       7.966  21.566  30.904  1.00 77.32           C  
ATOM    528  NE  ARG    67       7.855  21.681  32.362  1.00 86.77           N  
ATOM    529  CZ  ARG    67       8.456  20.913  33.286  1.00 88.48           C  
ATOM    530  NH1 ARG    67       9.276  19.899  32.970  1.00 89.88           N  
ATOM    531  NH2 ARG    67       8.239  21.180  34.573  1.00 88.54           N  
ATOM    532  N   VAL    68       7.271  19.005  27.159  1.00 65.16           N  
ATOM    533  CA  VAL    68       8.215  18.747  26.063  1.00 62.41           C  
ATOM    534  C   VAL    68       8.978  20.007  25.717  1.00 60.91           C  
ATOM    535  O   VAL    68       8.543  21.090  26.072  1.00 59.60           O  
ATOM    536  CB  VAL    68       7.498  18.254  24.764  1.00 61.59           C  
ATOM    537  CG1 VAL    68       6.901  16.871  24.965  1.00 61.91           C  
ATOM    538  CG2 VAL    68       6.433  19.268  24.275  1.00 55.67           C  
ATOM    539  N   ILE    69      10.122  19.827  25.049  1.00 60.95           N  
ATOM    540  CA  ILE    69      10.926  20.890  24.436  1.00 61.42           C  
ATOM    541  C   ILE    69      10.969  20.593  22.918  1.00 62.59           C  
ATOM    542  O   ILE    69      11.247  19.472  22.513  1.00 63.16           O  
ATOM    543  CB  ILE    69      12.359  20.987  25.029  1.00 61.23           C  
ATOM    544  CG1 ILE    69      12.309  21.469  26.486  1.00 62.50           C  
ATOM    545  CG2 ILE    69      13.291  21.908  24.186  1.00 56.80           C  
ATOM    546  CD1 ILE    69      11.826  22.910  26.653  1.00 63.44           C  
ATOM    547  N   GLY    70      10.686  21.605  22.099  1.00 62.73           N  
ATOM    548  CA  GLY    70      10.683  21.493  20.647  1.00 62.02           C  
ATOM    549  C   GLY    70      11.794  22.387  20.116  1.00 61.75           C  
ATOM    550  O   GLY    70      11.733  23.605  20.304  1.00 62.94           O  
ATOM    551  N   ALA    71      12.817  21.793  19.520  1.00 59.28           N  
ATOM    552  CA  ALA    71      13.928  22.558  18.933  1.00 60.54           C  
ATOM    553  C   ALA    71      13.531  22.928  17.483  1.00 59.79           C  
ATOM    554  O   ALA    71      13.273  22.042  16.668  1.00 59.76           O  
ATOM    555  CB  ALA    71      15.217  21.749  18.984  1.00 58.60           C  
ATOM    556  N   PHE    72      13.434  24.227  17.204  1.00 59.98           N  
ATOM    557  CA  PHE    72      13.040  24.764  15.881  1.00 60.04           C  
ATOM    558  C   PHE    72      14.087  25.714  15.286  1.00 60.96           C  
ATOM    559  O   PHE    72      14.642  26.566  16.003  1.00 60.23           O  
ATOM    560  CB  PHE    72      11.733  25.575  15.998  1.00 59.18           C  
ATOM    561  CG  PHE    72      11.344  26.281  14.725  1.00 58.73           C  
ATOM    562  CD1 PHE    72      10.759  25.576  13.684  1.00 58.25           C  
ATOM    563  CD2 PHE    72      11.630  27.630  14.535  1.00 60.96           C  
ATOM    564  CE1 PHE    72      10.437  26.187  12.475  1.00 59.78           C  
ATOM    565  CE2 PHE    72      11.313  28.266  13.322  1.00 64.31           C  
ATOM    566  CZ  PHE    72      10.701  27.539  12.297  1.00 59.65           C  
ATOM    567  N   SER    73      14.300  25.593  13.973  1.00 60.67           N  
ATOM    568  CA  SER    73      15.104  26.554  13.233  1.00 61.76           C  
ATOM    569  C   SER    73      14.387  26.874  11.932  1.00 61.94           C  
ATOM    570  O   SER    73      13.763  25.993  11.344  1.00 61.60           O  
ATOM    571  CB  SER    73      16.533  26.050  12.965  1.00 62.88           C  
ATOM    572  OG  SER    73      16.613  25.073  11.935  1.00 64.92           O  
ATOM    573  N   SER    74      14.431  28.142  11.511  1.00 62.03           N  
ATOM    574  CA  SER    74      13.942  28.540  10.202  1.00 62.94           C  
ATOM    575  C   SER    74      14.851  27.889   9.130  1.00 62.64           C  
ATOM    576  O   SER    74      15.990  27.551   9.408  1.00 61.33           O  
ATOM    577  CB  SER    74      13.929  30.074  10.048  1.00 62.75           C  
ATOM    578  OG  SER    74      15.209  30.614  10.328  1.00 67.23           O  
ATOM    579  N   LYS    75      14.347  27.753   7.913  1.00 64.07           N  
ATOM    580  CA  LYS    75      15.071  27.094   6.799  1.00 65.55           C  
ATOM    581  C   LYS    75      16.431  27.760   6.465  1.00 66.03           C  
ATOM    582  O   LYS    75      17.456  27.074   6.222  1.00 66.43           O  
ATOM    583  CB  LYS    75      14.146  26.987   5.582  1.00 64.21           C  
ATOM    584  CG  LYS    75      14.528  25.940   4.558  1.00 69.75           C  
ATOM    585  CD  LYS    75      13.380  25.629   3.534  1.00 68.15           C  
ATOM    586  CE  LYS    75      12.201  24.845   4.199  1.00 75.85           C  
ATOM    587  NZ  LYS    75      11.098  24.432   3.271  1.00 74.33           N  
ATOM    588  N   GLY    76      16.454  29.086   6.521  1.00 65.47           N  
ATOM    589  CA  GLY    76      17.695  29.823   6.305  1.00 64.53           C  
ATOM    590  C   GLY    76      18.616  29.969   7.510  1.00 64.33           C  
ATOM    591  O   GLY    76      19.679  30.580   7.377  1.00 64.98           O  
ATOM    592  N   HIS    77      18.230  29.432   8.674  1.00 63.35           N  
ATOM    593  CA  HIS    77      19.004  29.540   9.914  1.00 63.01           C  
ATOM    594  C   HIS    77      19.153  30.968  10.472  1.00 62.42           C  
ATOM    595  O   HIS    77      20.116  31.266  11.186  1.00 62.37           O  
ATOM    596  CB  HIS    77      20.359  28.812   9.771  1.00 62.40           C  
ATOM    597  CG  HIS    77      20.264  27.329   9.882  1.00 65.14           C  
ATOM    598  ND1 HIS    77      21.384  26.544  10.009  1.00 63.19           N  
ATOM    599  CD2 HIS    77      19.200  26.491   9.977  1.00 60.11           C  
ATOM    600  CE1 HIS    77      21.022  25.281  10.114  1.00 63.23           C  
ATOM    601  NE2 HIS    77      19.704  25.219  10.107  1.00 64.01           N  
ATOM    602  N   ASP    78      18.176  31.822  10.164  1.00 62.73           N  
ATOM    603  CA  ASP    78      18.120  33.200  10.668  1.00 63.74           C  
ATOM    604  C   ASP    78      17.443  33.299  12.036  1.00 62.49           C  
ATOM    605  O   ASP    78      17.598  34.293  12.714  1.00 61.00           O  
ATOM    606  CB  ASP    78      17.465  34.172   9.664  1.00 65.53           C  
ATOM    607  CG  ASP    78      16.011  33.852   9.363  1.00 74.11           C  
ATOM    608  OD1 ASP    78      15.706  32.676   9.082  1.00 87.52           O  
ATOM    609  OD2 ASP    78      15.181  34.791   9.350  1.00 86.29           O  
ATOM    610  N   LEU    79      16.693  32.267  12.420  1.00 63.41           N  
ATOM    611  CA  LEU    79      16.018  32.193  13.702  1.00 62.72           C  
ATOM    612  C   LEU    79      16.037  30.779  14.262  1.00 62.60           C  
ATOM    613  O   LEU    79      15.770  29.825  13.543  1.00 62.56           O  
ATOM    614  CB  LEU    79      14.571  32.682  13.538  1.00 62.83           C  
ATOM    615  CG  LEU    79      13.612  32.684  14.742  1.00 63.48           C  
ATOM    616  CD1 LEU    79      12.605  33.802  14.634  1.00 60.71           C  
ATOM    617  CD2 LEU    79      12.912  31.345  14.948  1.00 61.69           C  
ATOM    618  N   PHE    80      16.349  30.676  15.557  1.00 63.03           N  
ATOM    619  CA  PHE    80      16.302  29.445  16.331  1.00 61.20           C  
ATOM    620  C   PHE    80      15.329  29.671  17.497  1.00 61.24           C  
ATOM    621  O   PHE    80      15.302  30.747  18.058  1.00 61.99           O  
ATOM    622  CB  PHE    80      17.698  29.080  16.813  1.00 61.64           C  
ATOM    623  CG  PHE    80      18.629  28.791  15.692  1.00 62.13           C  
ATOM    624  CD1 PHE    80      18.686  27.513  15.140  1.00 59.83           C  
ATOM    625  CD2 PHE    80      19.398  29.808  15.132  1.00 62.75           C  
ATOM    626  CE1 PHE    80      19.521  27.243  14.062  1.00 60.15           C  
ATOM    627  CE2 PHE    80      20.226  29.561  14.027  1.00 60.53           C  
ATOM    628  CZ  PHE    80      20.299  28.274  13.502  1.00 61.80           C  
ATOM    629  N   ALA    81      14.506  28.672  17.809  1.00 60.35           N  
ATOM    630  CA  ALA    81      13.524  28.758  18.893  1.00 59.85           C  
ATOM    631  C   ALA    81      13.447  27.422  19.627  1.00 61.07           C  
ATOM    632  O   ALA    81      13.455  26.357  18.989  1.00 61.07           O  
ATOM    633  CB  ALA    81      12.123  29.169  18.347  1.00 57.08           C  
ATOM    634  N   SER    82      13.425  27.501  20.960  1.00 61.50           N  
ATOM    635  CA  SER    82      13.270  26.357  21.849  1.00 61.69           C  
ATOM    636  C   SER    82      11.882  26.548  22.472  1.00 61.85           C  
ATOM    637  O   SER    82      11.663  27.507  23.219  1.00 62.53           O  
ATOM    638  CB  SER    82      14.371  26.351  22.900  1.00 61.04           C  
ATOM    639  OG  SER    82      14.242  25.225  23.714  1.00 61.74           O  
ATOM    640  N   ILE    83      10.963  25.643  22.148  1.00 61.03           N  
ATOM    641  CA  ILE    83       9.553  25.764  22.517  1.00 60.58           C  
ATOM    642  C   ILE    83       9.266  24.847  23.697  1.00 60.93           C  
ATOM    643  O   ILE    83       9.510  23.656  23.602  1.00 61.95           O  
ATOM    644  CB  ILE    83       8.633  25.355  21.334  1.00 60.49           C  
ATOM    645  CG1 ILE    83       9.032  26.076  20.025  1.00 61.83           C  
ATOM    646  CG2 ILE    83       7.177  25.624  21.675  1.00 58.47           C  
ATOM    647  CD1 ILE    83       8.434  25.478  18.765  1.00 60.88           C  
ATOM    648  N   SER    84       8.759  25.418  24.787  1.00 59.46           N  
ATOM    649  CA  SER    84       8.364  24.697  25.970  1.00 60.27           C  
ATOM    650  C   SER    84       6.845  24.641  26.009  1.00 59.71           C  
ATOM    651  O   SER    84       6.184  25.641  25.786  1.00 58.95           O  
ATOM    652  CB  SER    84       8.864  25.397  27.227  1.00 59.24           C  
ATOM    653  OG  SER    84       8.388  24.722  28.346  1.00 61.61           O  
ATOM    654  N   GLY    85       6.313  23.461  26.315  1.00 59.32           N  
ATOM    655  CA  GLY    85       4.886  23.285  26.414  1.00 59.57           C  
ATOM    656  C   GLY    85       4.476  21.884  26.795  1.00 59.93           C  
ATOM    657  O   GLY    85       5.316  21.040  27.130  1.00 57.84           O  
ATOM    658  N   SER    86       3.167  21.652  26.718  1.00 60.53           N  
ATOM    659  CA  SER    86       2.579  20.379  27.083  1.00 62.22           C  
ATOM    660  C   SER    86       2.099  19.687  25.827  1.00 61.21           C  
ATOM    661  O   SER    86       1.456  20.327  24.998  1.00 60.49           O  
ATOM    662  CB  SER    86       1.424  20.601  28.056  1.00 62.37           C  
ATOM    663  OG  SER    86       1.041  19.368  28.593  1.00 69.29           O  
ATOM    664  N   LEU    87       2.410  18.390  25.709  1.00 61.36           N  
ATOM    665  CA  LEU    87       2.066  17.577  24.555  1.00 61.79           C  
ATOM    666  C   LEU    87       1.098  16.463  24.945  1.00 62.05           C  
ATOM    667  O   LEU    87       1.339  15.762  25.910  1.00 61.68           O  
ATOM    668  CB  LEU    87       3.332  16.959  23.956  1.00 62.08           C  
ATOM    669  CG  LEU    87       3.223  16.237  22.587  1.00 60.82           C  
ATOM    670  CD1 LEU    87       2.987  17.238  21.460  1.00 56.57           C  
ATOM    671  CD2 LEU    87       4.471  15.424  22.316  1.00 60.35           C  
ATOM    672  N   ARG    88       0.013  16.314  24.189  1.00 62.43           N  
ATOM    673  CA  ARG    88      -0.968  15.221  24.395  1.00 63.66           C  
ATOM    674  C   ARG    88      -1.614  14.877  23.060  1.00 65.27           C  
ATOM    675  O   ARG    88      -1.478  15.629  22.091  1.00 65.49           O  
ATOM    676  CB  ARG    88      -2.045  15.593  25.414  1.00 61.65           C  
ATOM    677  CG  ARG    88      -3.136  16.563  24.942  1.00 62.82           C  
ATOM    678  CD  ARG    88      -3.992  17.029  26.093  1.00 64.88           C  
ATOM    679  NE  ARG    88      -5.296  17.545  25.669  1.00 68.30           N  
ATOM    680  CZ  ARG    88      -5.652  18.829  25.496  1.00 73.89           C  
ATOM    681  NH1 ARG    88      -4.840  19.870  25.744  1.00 70.34           N  
ATOM    682  NH2 ARG    88      -6.898  19.082  25.081  1.00 77.03           N  
ATOM    683  N   GLU    89      -2.309  13.748  23.022  1.00 65.27           N  
ATOM    684  CA  GLU    89      -3.038  13.341  21.837  1.00 65.79           C  
ATOM    685  C   GLU    89      -4.428  13.954  21.904  1.00 65.73           C  
ATOM    686  O   GLU    89      -5.092  13.873  22.930  1.00 65.83           O  
ATOM    687  CB  GLU    89      -3.160  11.826  21.762  1.00 65.81           C  
ATOM    688  CG  GLU    89      -3.649  11.337  20.397  1.00 66.36           C  
ATOM    689  CD  GLU    89      -4.083   9.899  20.410  1.00 66.98           C  
ATOM    690  OE1 GLU    89      -3.488   9.087  21.159  1.00 69.53           O  
ATOM    691  OE2 GLU    89      -5.033   9.581  19.657  1.00 75.68           O  
ATOM    692  N   ASP    90      -4.849  14.597  20.820  1.00 67.11           N  
ATOM    693  CA  ASP    90      -6.206  15.145  20.705  1.00 67.14           C  
ATOM    694  C   ASP    90      -6.621  14.961  19.255  1.00 67.68           C  
ATOM    695  O   ASP    90      -6.628  15.917  18.464  1.00 68.75           O  
ATOM    696  CB  ASP    90      -6.315  16.617  21.162  1.00 66.98           C  
ATOM    697  CG  ASP    90      -7.786  17.152  21.154  1.00 68.16           C  
ATOM    698  OD1 ASP    90      -8.764  16.372  21.278  1.00 66.63           O  
ATOM    699  OD2 ASP    90      -7.973  18.377  21.026  1.00 70.41           O  
ATOM    700  N   THR    91      -6.947  13.708  18.924  1.00 66.34           N  
ATOM    701  CA  THR    91      -7.418  13.320  17.601  1.00 66.46           C  
ATOM    702  C   THR    91      -8.928  13.639  17.527  1.00 66.88           C  
ATOM    703  O   THR    91      -9.805  12.750  17.586  1.00 66.05           O  
ATOM    704  CB  THR    91      -7.056  11.851  17.277  1.00 66.58           C  
ATOM    705  OG1 THR    91      -5.648  11.653  17.532  1.00 64.66           O  
ATOM    706  CG2 THR    91      -7.383  11.512  15.802  1.00 64.38           C  
ATOM    707  N   ASP    92      -9.184  14.951  17.407  1.00 66.79           N  
ATOM    708  CA  ASP    92     -10.499  15.528  17.320  1.00 65.30           C  
ATOM    709  C   ASP    92     -10.811  15.527  15.826  1.00 65.43           C  
ATOM    710  O   ASP    92     -10.123  16.230  15.077  1.00 65.65           O  
ATOM    711  CB  ASP    92     -10.516  16.960  17.880  1.00 64.41           C  
ATOM    712  CG  ASP    92     -11.928  17.619  17.866  1.00 66.57           C  
ATOM    713  OD1 ASP    92     -12.837  17.213  17.098  1.00 62.25           O  
ATOM    714  OD2 ASP    92     -12.124  18.592  18.634  1.00 68.03           O  
ATOM    715  N   PRO    93     -11.854  14.773  15.392  1.00 64.19           N  
ATOM    716  CA  PRO    93     -12.262  14.737  13.982  1.00 63.47           C  
ATOM    717  C   PRO    93     -12.436  16.092  13.331  1.00 62.27           C  
ATOM    718  O   PRO    93     -12.122  16.236  12.151  1.00 60.14           O  
ATOM    719  CB  PRO    93     -13.644  14.033  14.017  1.00 62.28           C  
ATOM    720  CG  PRO    93     -13.973  13.845  15.393  1.00 62.35           C  
ATOM    721  CD  PRO    93     -12.741  13.919  16.200  1.00 63.70           C  
ATOM    722  N   ALA    94     -12.990  17.047  14.084  1.00 62.20           N  
ATOM    723  CA  ALA    94     -13.192  18.401  13.580  1.00 62.51           C  
ATOM    724  C   ALA    94     -11.854  19.078  13.309  1.00 61.72           C  
ATOM    725  O   ALA    94     -11.733  19.783  12.318  1.00 61.42           O  
ATOM    726  CB  ALA    94     -14.045  19.242  14.545  1.00 62.99           C  
ATOM    727  N   VAL    95     -10.861  18.857  14.177  1.00 62.04           N  
ATOM    728  CA  VAL    95      -9.512  19.437  13.972  1.00 62.22           C  
ATOM    729  C   VAL    95      -8.829  18.730  12.792  1.00 61.88           C  
ATOM    730  O   VAL    95      -8.248  19.388  11.941  1.00 61.01           O  
ATOM    731  CB  VAL    95      -8.645  19.399  15.222  1.00 62.15           C  
ATOM    732  CG1 VAL    95      -7.285  20.045  14.939  1.00 62.94           C  
ATOM    733  CG2 VAL    95      -9.347  20.119  16.363  1.00 59.03           C  
ATOM    734  N   VAL    96      -8.946  17.402  12.739  1.00 61.69           N  
ATOM    735  CA  VAL    96      -8.433  16.610  11.624  1.00 62.38           C  
ATOM    736  C   VAL    96      -8.931  17.202  10.307  1.00 62.20           C  
ATOM    737  O   VAL    96      -8.125  17.431   9.429  1.00 60.58           O  
ATOM    738  CB  VAL    96      -8.826  15.096  11.729  1.00 61.95           C  
ATOM    739  CG1 VAL    96      -8.649  14.352  10.383  1.00 60.55           C  
ATOM    740  CG2 VAL    96      -8.025  14.423  12.832  1.00 61.12           C  
ATOM    741  N   ASP    97     -10.236  17.480  10.219  1.00 63.00           N  
ATOM    742  CA  ASP    97     -10.858  18.070   9.026  1.00 64.24           C  
ATOM    743  C   ASP    97     -10.265  19.399   8.616  1.00 63.53           C  
ATOM    744  O   ASP    97      -9.943  19.574   7.468  1.00 63.50           O  
ATOM    745  CB  ASP    97     -12.379  18.258   9.201  1.00 65.15           C  
ATOM    746  CG  ASP    97     -13.150  16.958   9.125  1.00 71.53           C  
ATOM    747  OD1 ASP    97     -12.846  16.116   8.246  1.00 76.19           O  
ATOM    748  OD2 ASP    97     -14.106  16.798   9.921  1.00 80.54           O  
ATOM    749  N   ARG    98     -10.137  20.319   9.560  1.00 64.71           N  
ATOM    750  CA  ARG    98      -9.585  21.664   9.297  1.00 66.64           C  
ATOM    751  C   ARG    98      -8.117  21.652   8.884  1.00 65.82           C  
ATOM    752  O   ARG    98      -7.730  22.345   7.952  1.00 66.83           O  
ATOM    753  CB  ARG    98      -9.763  22.569  10.526  1.00 66.66           C  
ATOM    754  CG  ARG    98     -11.253  22.861  10.798  1.00 71.03           C  
ATOM    755  CD  ARG    98     -11.517  23.743  11.998  1.00 69.73           C  
ATOM    756  NE  ARG    98     -10.833  23.306  13.216  1.00 75.27           N  
ATOM    757  CZ  ARG    98     -11.032  23.817  14.430  1.00 77.58           C  
ATOM    758  NH1 ARG    98     -11.949  24.771  14.646  1.00 86.21           N  
ATOM    759  NH2 ARG    98     -10.327  23.344  15.457  1.00 76.48           N  
ATOM    760  N   LEU    99      -7.308  20.866   9.584  1.00 64.51           N  
ATOM    761  CA  LEU    99      -5.885  20.755   9.277  1.00 63.88           C  
ATOM    762  C   LEU    99      -5.584  19.870   8.068  1.00 63.94           C  
ATOM    763  O   LEU    99      -4.462  19.897   7.571  1.00 63.94           O  
ATOM    764  CB  LEU    99      -5.115  20.237  10.488  1.00 62.08           C  
ATOM    765  CG  LEU    99      -5.236  21.082  11.741  1.00 59.09           C  
ATOM    766  CD1 LEU    99      -4.488  20.403  12.860  1.00 62.82           C  
ATOM    767  CD2 LEU    99      -4.698  22.491  11.510  1.00 60.05           C  
ATOM    768  N   TRP   100      -6.563  19.093   7.604  1.00 64.23           N  
ATOM    769  CA  TRP   100      -6.368  18.208   6.457  1.00 64.94           C  
ATOM    770  C   TRP   100      -5.943  18.993   5.196  1.00 66.40           C  
ATOM    771  O   TRP   100      -6.492  20.062   4.904  1.00 66.40           O  
ATOM    772  CB  TRP   100      -7.647  17.416   6.134  1.00 63.32           C  
ATOM    773  CG  TRP   100      -7.401  16.171   5.391  1.00 60.10           C  
ATOM    774  CD1 TRP   100      -7.703  15.915   4.101  1.00 60.68           C  
ATOM    775  CD2 TRP   100      -6.792  14.995   5.907  1.00 56.49           C  
ATOM    776  NE1 TRP   100      -7.326  14.642   3.770  1.00 59.73           N  
ATOM    777  CE2 TRP   100      -6.761  14.052   4.866  1.00 58.04           C  
ATOM    778  CE3 TRP   100      -6.253  14.649   7.155  1.00 61.51           C  
ATOM    779  CZ2 TRP   100      -6.218  12.773   5.025  1.00 60.05           C  
ATOM    780  CZ3 TRP   100      -5.722  13.370   7.323  1.00 62.28           C  
ATOM    781  CH2 TRP   100      -5.711  12.446   6.257  1.00 61.37           C  
ATOM    782  N   ASN   101      -4.936  18.470   4.507  1.00 67.33           N  
ATOM    783  CA  ASN   101      -4.440  19.036   3.242  1.00 68.25           C  
ATOM    784  C   ASN   101      -3.796  17.912   2.420  1.00 68.25           C  
ATOM    785  O   ASN   101      -3.561  16.831   2.975  1.00 67.18           O  
ATOM    786  CB  ASN   101      -3.521  20.244   3.506  1.00 68.78           C  
ATOM    787  CG  ASN   101      -2.252  19.891   4.277  1.00 70.98           C  
ATOM    788  OD1 ASN   101      -1.543  18.923   3.967  1.00 73.81           O  
ATOM    789  ND2 ASN   101      -1.942  20.711   5.265  1.00 69.56           N  
ATOM    790  N   PRO   102      -3.482  18.158   1.120  1.00 69.56           N  
ATOM    791  CA  PRO   102      -2.961  17.054   0.312  1.00 69.80           C  
ATOM    792  C   PRO   102      -1.602  16.513   0.768  1.00 69.69           C  
ATOM    793  O   PRO   102      -1.349  15.316   0.605  1.00 68.78           O  
ATOM    794  CB  PRO   102      -2.912  17.648  -1.100  1.00 71.45           C  
ATOM    795  CG  PRO   102      -3.715  18.929  -1.024  1.00 71.12           C  
ATOM    796  CD  PRO   102      -3.516  19.407   0.334  1.00 69.40           C  
ATOM    797  N   TYR   103      -0.779  17.369   1.396  1.00 70.60           N  
ATOM    798  CA  TYR   103       0.528  16.945   1.919  1.00 71.40           C  
ATOM    799  C   TYR   103       0.273  15.894   3.022  1.00 71.59           C  
ATOM    800  O   TYR   103       0.827  14.796   2.953  1.00 72.12           O  
ATOM    801  CB  TYR   103       1.380  18.111   2.457  1.00 73.01           C  
ATOM    802  CG  TYR   103       1.556  19.319   1.541  1.00 74.63           C  
ATOM    803  CD1 TYR   103       2.579  19.359   0.586  1.00 79.83           C  
ATOM    804  CD2 TYR   103       0.718  20.452   1.662  1.00 77.56           C  
ATOM    805  CE1 TYR   103       2.757  20.503  -0.267  1.00 79.67           C  
ATOM    806  CE2 TYR   103       0.880  21.594   0.828  1.00 76.18           C  
ATOM    807  CZ  TYR   103       1.906  21.615  -0.131  1.00 78.35           C  
ATOM    808  OH  TYR   103       2.081  22.714  -0.952  1.00 74.78           O  
ATOM    809  N   VAL   104      -0.611  16.207   3.979  1.00 71.00           N  
ATOM    810  CA  VAL   104      -0.982  15.253   5.050  1.00 71.32           C  
ATOM    811  C   VAL   104      -1.676  14.042   4.448  1.00 71.94           C  
ATOM    812  O   VAL   104      -1.395  12.913   4.856  1.00 72.55           O  
ATOM    813  CB  VAL   104      -1.908  15.868   6.153  1.00 70.76           C  
ATOM    814  CG1 VAL   104      -2.369  14.799   7.148  1.00 69.40           C  
ATOM    815  CG2 VAL   104      -1.195  16.957   6.879  1.00 72.76           C  
ATOM    816  N   ALA   105      -2.593  14.289   3.504  1.00 72.51           N  
ATOM    817  CA  ALA   105      -3.296  13.226   2.771  1.00 74.46           C  
ATOM    818  C   ALA   105      -2.313  12.167   2.258  1.00 75.45           C  
ATOM    819  O   ALA   105      -2.558  10.970   2.436  1.00 76.15           O  
ATOM    820  CB  ALA   105      -4.096  13.809   1.599  1.00 73.94           C  
ATOM    821  N   ALA   106      -1.196  12.631   1.676  1.00 75.72           N  
ATOM    822  CA  ALA   106      -0.115  11.769   1.161  1.00 76.68           C  
ATOM    823  C   ALA   106       0.417  10.723   2.155  1.00 77.50           C  
ATOM    824  O   ALA   106       0.709   9.598   1.754  1.00 78.04           O  
ATOM    825  CB  ALA   106       1.062  12.632   0.649  1.00 76.97           C  
ATOM    826  N   TRP   107       0.529  11.090   3.433  1.00 78.25           N  
ATOM    827  CA  TRP   107       1.049  10.169   4.467  1.00 79.00           C  
ATOM    828  C   TRP   107       0.102   9.052   4.890  1.00 78.50           C  
ATOM    829  O   TRP   107       0.565   8.098   5.518  1.00 78.90           O  
ATOM    830  CB  TRP   107       1.476  10.925   5.735  1.00 81.75           C  
ATOM    831  CG  TRP   107       2.578  11.855   5.503  1.00 85.01           C  
ATOM    832  CD1 TRP   107       2.472  13.167   5.177  1.00 88.16           C  
ATOM    833  CD2 TRP   107       3.974  11.559   5.560  1.00 88.53           C  
ATOM    834  NE1 TRP   107       3.719  13.726   5.022  1.00 89.70           N  
ATOM    835  CE2 TRP   107       4.666  12.763   5.255  1.00 92.17           C  
ATOM    836  CE3 TRP   107       4.718  10.396   5.839  1.00 88.93           C  
ATOM    837  CZ2 TRP   107       6.084  12.843   5.228  1.00 91.14           C  
ATOM    838  CZ3 TRP   107       6.137  10.467   5.806  1.00 88.41           C  
ATOM    839  CH2 TRP   107       6.797  11.688   5.499  1.00 88.94           C  
ATOM    840  N   TYR   108      -1.190   9.156   4.569  1.00 77.70           N  
ATOM    841  CA  TYR   108      -2.183   8.176   5.020  1.00 77.58           C  
ATOM    842  C   TYR   108      -2.958   7.561   3.853  1.00 78.24           C  
ATOM    843  O   TYR   108      -3.724   8.266   3.183  1.00 78.55           O  
ATOM    844  CB  TYR   108      -3.168   8.840   5.999  1.00 76.95           C  
ATOM    845  CG  TYR   108      -2.543   9.466   7.239  1.00 75.66           C  
ATOM    846  CD1 TYR   108      -2.285   8.702   8.386  1.00 74.93           C  
ATOM    847  CD2 TYR   108      -2.242  10.831   7.280  1.00 73.90           C  
ATOM    848  CE1 TYR   108      -1.713   9.278   9.538  1.00 73.25           C  
ATOM    849  CE2 TYR   108      -1.677  11.424   8.432  1.00 75.10           C  
ATOM    850  CZ  TYR   108      -1.418  10.639   9.556  1.00 73.87           C  
ATOM    851  OH  TYR   108      -0.877  11.208  10.686  1.00 71.72           O  
ATOM    852  N   GLU   109      -2.759   6.256   3.622  1.00 78.29           N  
ATOM    853  CA  GLU   109      -3.483   5.521   2.577  1.00 78.32           C  
ATOM    854  C   GLU   109      -4.983   5.426   2.914  1.00 78.59           C  
ATOM    855  O   GLU   109      -5.822   5.547   2.021  1.00 79.15           O  
ATOM    856  CB  GLU   109      -2.895   4.118   2.367  1.00 78.53           C  
ATOM    857  N   GLY   110      -5.307   5.230   4.198  1.00 78.33           N  
ATOM    858  CA  GLY   110      -6.699   5.168   4.674  1.00 77.97           C  
ATOM    859  C   GLY   110      -7.416   6.508   4.868  1.00 77.86           C  
ATOM    860  O   GLY   110      -8.599   6.516   5.253  1.00 77.81           O  
ATOM    861  N   GLY   111      -6.713   7.627   4.626  1.00 77.37           N  
ATOM    862  CA  GLY   111      -7.273   8.973   4.753  1.00 76.88           C  
ATOM    863  C   GLY   111      -7.530   9.338   6.201  1.00 76.06           C  
ATOM    864  O   GLY   111      -6.775   8.942   7.078  1.00 76.40           O  
ATOM    865  N   LYS   112      -8.615  10.066   6.443  1.00 75.40           N  
ATOM    866  CA  LYS   112      -9.004  10.499   7.793  1.00 75.45           C  
ATOM    867  C   LYS   112      -9.533   9.346   8.669  1.00 76.00           C  
ATOM    868  O   LYS   112      -9.520   9.440   9.906  1.00 76.72           O  
ATOM    869  CB  LYS   112     -10.073  11.591   7.711  1.00 75.43           C  
ATOM    870  CG  LYS   112      -9.662  12.859   6.981  1.00 74.16           C  
ATOM    871  CD  LYS   112     -10.866  13.731   6.775  1.00 74.95           C  
ATOM    872  CE  LYS   112     -10.520  14.996   6.064  1.00 76.57           C  
ATOM    873  NZ  LYS   112     -11.749  15.771   5.752  1.00 82.34           N  
ATOM    874  N   ASP   113     -10.034   8.295   8.025  1.00 75.85           N  
ATOM    875  CA  ASP   113     -10.531   7.089   8.701  1.00 76.36           C  
ATOM    876  C   ASP   113      -9.419   6.097   9.050  1.00 76.13           C  
ATOM    877  O   ASP   113      -9.698   5.091   9.718  1.00 75.33           O  
ATOM    878  CB  ASP   113     -11.555   6.366   7.811  1.00 77.25           C  
ATOM    879  CG  ASP   113     -12.774   7.212   7.529  1.00 79.58           C  
ATOM    880  OD1 ASP   113     -13.497   7.558   8.498  1.00 80.73           O  
ATOM    881  OD2 ASP   113     -13.026   7.506   6.337  1.00 82.08           O  
ATOM    882  N   ASP   114      -8.188   6.359   8.578  1.00 76.33           N  
ATOM    883  CA  ASP   114      -7.018   5.509   8.839  1.00 76.24           C  
ATOM    884  C   ASP   114      -6.921   5.261  10.363  1.00 76.47           C  
ATOM    885  O   ASP   114      -6.805   6.235  11.123  1.00 76.72           O  
ATOM    886  CB  ASP   114      -5.731   6.165   8.295  1.00 76.13           C  
ATOM    887  CG  ASP   114      -4.517   5.220   8.278  1.00 76.90           C  
ATOM    888  OD1 ASP   114      -4.320   4.422   9.229  1.00 77.06           O  
ATOM    889  OD2 ASP   114      -3.726   5.312   7.302  1.00 76.48           O  
ATOM    890  N   PRO   115      -7.053   3.979  10.813  1.00 76.23           N  
ATOM    891  CA  PRO   115      -6.917   3.620  12.241  1.00 75.60           C  
ATOM    892  C   PRO   115      -5.544   3.998  12.811  1.00 75.10           C  
ATOM    893  O   PRO   115      -5.455   4.418  13.978  1.00 74.61           O  
ATOM    894  CB  PRO   115      -7.089   2.098  12.244  1.00 75.83           C  
ATOM    895  CG  PRO   115      -7.773   1.789  10.988  1.00 76.33           C  
ATOM    896  CD  PRO   115      -7.345   2.783   9.999  1.00 76.11           C  
ATOM    897  N   LYS   116      -4.503   3.888  11.970  1.00 74.15           N  
ATOM    898  CA  LYS   116      -3.137   4.270  12.319  1.00 73.62           C  
ATOM    899  C   LYS   116      -2.886   5.793  12.175  1.00 73.82           C  
ATOM    900  O   LYS   116      -1.837   6.193  11.660  1.00 74.05           O  
ATOM    901  CB  LYS   116      -2.134   3.488  11.457  1.00 73.64           C  
ATOM    902  N   LEU   117      -3.836   6.627  12.627  1.00 72.81           N  
ATOM    903  CA  LEU   117      -3.703   8.090  12.600  1.00 72.20           C  
ATOM    904  C   LEU   117      -3.889   8.641  14.013  1.00 70.18           C  
ATOM    905  O   LEU   117      -4.798   8.224  14.761  1.00 70.07           O  
ATOM    906  CB  LEU   117      -4.690   8.779  11.622  1.00 72.07           C  
ATOM    907  CG  LEU   117      -4.478  10.312  11.431  1.00 71.77           C  
ATOM    908  CD1 LEU   117      -4.834  10.788  10.027  1.00 70.09           C  
ATOM    909  CD2 LEU   117      -5.202  11.157  12.477  1.00 65.73           C  
ATOM    910  N   ALA   118      -3.007   9.582  14.347  1.00 68.08           N  
ATOM    911  CA  ALA   118      -3.020  10.297  15.612  1.00 65.82           C  
ATOM    912  C   ALA   118      -2.637  11.745  15.329  1.00 63.61           C  
ATOM    913  O   ALA   118      -1.849  12.033  14.426  1.00 61.85           O  
ATOM    914  CB  ALA   118      -2.051   9.666  16.594  1.00 64.77           C  
ATOM    915  N   LEU   119      -3.225  12.638  16.106  1.00 62.76           N  
ATOM    916  CA  LEU   119      -2.966  14.050  16.023  1.00 61.29           C  
ATOM    917  C   LEU   119      -2.557  14.502  17.420  1.00 62.26           C  
ATOM    918  O   LEU   119      -3.339  14.377  18.364  1.00 63.42           O  
ATOM    919  CB  LEU   119      -4.235  14.755  15.566  1.00 60.40           C  
ATOM    920  CG  LEU   119      -4.172  16.242  15.293  1.00 59.44           C  
ATOM    921  CD1 LEU   119      -3.043  16.591  14.297  1.00 52.48           C  
ATOM    922  CD2 LEU   119      -5.552  16.736  14.813  1.00 59.31           C  
ATOM    923  N   LEU   120      -1.327  14.991  17.549  1.00 61.72           N  
ATOM    924  CA  LEU   120      -0.807  15.499  18.812  1.00 61.86           C  
ATOM    925  C   LEU   120      -0.988  17.008  18.872  1.00 61.72           C  
ATOM    926  O   LEU   120      -0.861  17.664  17.838  1.00 61.15           O  
ATOM    927  CB  LEU   120       0.696  15.185  18.941  1.00 61.56           C  
ATOM    928  CG  LEU   120       1.129  13.731  18.723  1.00 60.31           C  
ATOM    929  CD1 LEU   120       2.615  13.582  19.060  1.00 56.29           C  
ATOM    930  CD2 LEU   120       0.279  12.778  19.543  1.00 55.20           C  
ATOM    931  N   ARG   121      -1.297  17.544  20.061  1.00 61.18           N  
ATOM    932  CA  ARG   121      -1.330  19.005  20.282  1.00 61.97           C  
ATOM    933  C   ARG   121      -0.284  19.405  21.302  1.00 61.10           C  
ATOM    934  O   ARG   121      -0.164  18.793  22.366  1.00 60.42           O  
ATOM    935  CB  ARG   121      -2.700  19.574  20.687  1.00 61.52           C  
ATOM    936  CG  ARG   121      -3.293  19.113  21.975  1.00 63.20           C  
ATOM    937  CD  ARG   121      -4.717  19.648  22.120  1.00 63.33           C  
ATOM    938  NE  ARG   121      -4.812  21.045  22.572  1.00 65.57           N  
ATOM    939  CZ  ARG   121      -5.927  21.786  22.566  1.00 62.63           C  
ATOM    940  NH1 ARG   121      -7.074  21.337  22.059  1.00 63.35           N  
ATOM    941  NH2 ARG   121      -5.888  23.032  23.023  1.00 59.07           N  
ATOM    942  N   LEU   122       0.483  20.429  20.934  1.00 60.61           N  
ATOM    943  CA  LEU   122       1.454  21.029  21.778  1.00 59.91           C  
ATOM    944  C   LEU   122       0.805  22.339  22.176  1.00 61.19           C  
ATOM    945  O   LEU   122       0.557  23.218  21.323  1.00 62.19           O  
ATOM    946  CB  LEU   122       2.773  21.234  21.057  1.00 60.23           C  
ATOM    947  CG  LEU   122       3.875  22.062  21.736  1.00 61.37           C  
ATOM    948  CD1 LEU   122       4.141  21.611  23.143  1.00 61.75           C  
ATOM    949  CD2 LEU   122       5.153  21.980  20.891  1.00 60.34           C  
ATOM    950  N   ASP   123       0.434  22.421  23.452  1.00 60.69           N  
ATOM    951  CA  ASP   123      -0.089  23.641  24.028  1.00 61.57           C  
ATOM    952  C   ASP   123       1.141  24.364  24.504  1.00 61.00           C  
ATOM    953  O   ASP   123       1.729  23.994  25.507  1.00 62.72           O  
ATOM    954  CB  ASP   123      -1.094  23.326  25.130  1.00 62.91           C  
ATOM    955  CG  ASP   123      -2.431  22.963  24.555  1.00 66.49           C  
ATOM    956  OD1 ASP   123      -3.034  23.882  23.953  1.00 63.57           O  
ATOM    957  OD2 ASP   123      -2.848  21.793  24.682  1.00 67.70           O  
ATOM    958  N   ALA   124       1.557  25.351  23.721  1.00 62.14           N  
ATOM    959  CA  ALA   124       2.829  26.072  23.923  1.00 62.86           C  
ATOM    960  C   ALA   124       2.719  27.054  25.049  1.00 63.49           C  
ATOM    961  O   ALA   124       1.792  27.847  25.100  1.00 64.38           O  
ATOM    962  CB  ALA   124       3.260  26.792  22.634  1.00 61.47           C  
ATOM    963  N   ASP   125       3.674  27.000  25.958  1.00 64.30           N  
ATOM    964  CA  ASP   125       3.694  27.897  27.090  1.00 64.07           C  
ATOM    965  C   ASP   125       4.555  29.133  26.771  1.00 64.53           C  
ATOM    966  O   ASP   125       4.117  30.277  26.904  1.00 64.73           O  
ATOM    967  CB  ASP   125       4.234  27.152  28.303  1.00 63.65           C  
ATOM    968  CG  ASP   125       4.373  28.044  29.479  1.00 66.71           C  
ATOM    969  OD1 ASP   125       3.326  28.563  29.916  1.00 70.42           O  
ATOM    970  OD2 ASP   125       5.520  28.256  29.920  1.00 67.28           O  
ATOM    971  N   HIS   126       5.806  28.883  26.419  1.00 65.57           N  
ATOM    972  CA  HIS   126       6.746  29.952  26.070  1.00 65.43           C  
ATOM    973  C   HIS   126       7.822  29.426  25.142  1.00 64.29           C  
ATOM    974  O   HIS   126       7.908  28.223  24.892  1.00 63.35           O  
ATOM    975  CB  HIS   126       7.361  30.584  27.332  1.00 65.55           C  
ATOM    976  CG  HIS   126       8.323  29.708  28.080  1.00 66.47           C  
ATOM    977  ND1 HIS   126       7.923  28.833  29.065  1.00 67.28           N  
ATOM    978  CD2 HIS   126       9.676  29.622  28.029  1.00 68.42           C  
ATOM    979  CE1 HIS   126       8.981  28.211  29.556  1.00 67.71           C  
ATOM    980  NE2 HIS   126      10.059  28.681  28.956  1.00 67.36           N  
ATOM    981  N   ALA   127       8.617  30.347  24.624  1.00 63.66           N  
ATOM    982  CA  ALA   127       9.755  30.017  23.787  1.00 63.18           C  
ATOM    983  C   ALA   127      10.903  30.936  24.025  1.00 62.13           C  
ATOM    984  O   ALA   127      10.699  32.131  24.256  1.00 61.43           O  
ATOM    985  CB  ALA   127       9.401  30.070  22.294  1.00 63.21           C  
ATOM    986  N   GLN   128      12.109  30.375  23.930  1.00 61.22           N  
ATOM    987  CA  GLN   128      13.310  31.173  23.934  1.00 61.80           C  
ATOM    988  C   GLN   128      13.686  31.276  22.469  1.00 60.96           C  
ATOM    989  O   GLN   128      13.774  30.260  21.792  1.00 60.64           O  
ATOM    990  CB  GLN   128      14.403  30.566  24.774  1.00 62.50           C  
ATOM    991  CG  GLN   128      15.552  31.516  24.945  1.00 66.72           C  
ATOM    992  CD  GLN   128      16.469  31.161  26.095  1.00 70.40           C  
ATOM    993  OE1 GLN   128      16.385  30.075  26.675  1.00 67.31           O  
ATOM    994  NE2 GLN   128      17.377  32.081  26.412  1.00 65.37           N  
ATOM    995  N   ILE   129      13.879  32.509  21.990  1.00 60.87           N  
ATOM    996  CA  ILE   129      14.139  32.804  20.583  1.00 59.58           C  
ATOM    997  C   ILE   129      15.507  33.475  20.424  1.00 60.07           C  
ATOM    998  O   ILE   129      15.780  34.501  21.060  1.00 60.01           O  
ATOM    999  CB  ILE   129      13.028  33.749  20.040  1.00 59.53           C  
ATOM   1000  CG1 ILE   129      11.651  33.068  20.090  1.00 58.16           C  
ATOM   1001  CG2 ILE   129      13.336  34.198  18.609  1.00 56.19           C  
ATOM   1002  CD1 ILE   129      10.470  34.066  19.975  1.00 59.27           C  
ATOM   1003  N   TRP   130      16.347  32.876  19.580  1.00 60.50           N  
ATOM   1004  CA  TRP   130      17.684  33.370  19.236  1.00 60.23           C  
ATOM   1005  C   TRP   130      17.721  33.703  17.748  1.00 60.63           C  
ATOM   1006  O   TRP   130      17.531  32.811  16.898  1.00 62.63           O  
ATOM   1007  CB  TRP   130      18.751  32.307  19.454  1.00 59.73           C  
ATOM   1008  CG  TRP   130      18.931  31.827  20.827  1.00 62.03           C  
ATOM   1009  CD1 TRP   130      19.893  32.210  21.698  1.00 60.85           C  
ATOM   1010  CD2 TRP   130      18.178  30.795  21.486  1.00 64.35           C  
ATOM   1011  NE1 TRP   130      19.780  31.513  22.862  1.00 60.14           N  
ATOM   1012  CE2 TRP   130      18.740  30.631  22.767  1.00 62.71           C  
ATOM   1013  CE3 TRP   130      17.101  29.976  21.106  1.00 62.95           C  
ATOM   1014  CZ2 TRP   130      18.252  29.687  23.696  1.00 64.49           C  
ATOM   1015  CZ3 TRP   130      16.620  29.038  22.023  1.00 61.66           C  
ATOM   1016  CH2 TRP   130      17.190  28.906  23.307  1.00 62.93           C  
ATOM   1017  N   LEU   131      17.936  34.971  17.435  1.00 60.43           N  
ATOM   1018  CA  LEU   131      18.156  35.403  16.058  1.00 60.89           C  
ATOM   1019  C   LEU   131      19.648  35.171  15.734  1.00 61.72           C  
ATOM   1020  O   LEU   131      20.522  35.294  16.604  1.00 60.15           O  
ATOM   1021  CB  LEU   131      17.815  36.875  15.870  1.00 58.93           C  
ATOM   1022  CG  LEU   131      16.405  37.315  16.295  1.00 61.09           C  
ATOM   1023  CD1 LEU   131      16.237  38.841  16.084  1.00 49.80           C  
ATOM   1024  CD2 LEU   131      15.306  36.515  15.580  1.00 53.92           C  
ATOM   1025  N   ASN   132      19.921  34.791  14.490  1.00 62.74           N  
ATOM   1026  CA  ASN   132      21.279  34.608  14.027  1.00 63.75           C  
ATOM   1027  C   ASN   132      21.623  35.951  13.364  1.00 65.20           C  
ATOM   1028  O   ASN   132      21.063  36.292  12.333  1.00 66.63           O  
ATOM   1029  CB  ASN   132      21.339  33.424  13.067  1.00 63.10           C  
ATOM   1030  CG  ASN   132      22.756  32.937  12.771  1.00 64.38           C  
ATOM   1031  OD1 ASN   132      23.739  33.313  13.410  1.00 66.90           O  
ATOM   1032  ND2 ASN   132      22.847  32.049  11.799  1.00 65.55           N  
ATOM   1033  N   GLY   133      22.472  36.738  14.019  1.00 65.89           N  
ATOM   1034  CA  GLY   133      22.928  38.033  13.513  1.00 65.80           C  
ATOM   1035  C   GLY   133      24.273  37.866  12.840  1.00 65.28           C  
ATOM   1036  O   GLY   133      24.550  36.815  12.252  1.00 66.27           O  
ATOM   1037  N   SER   134      25.112  38.891  12.925  1.00 64.55           N  
ATOM   1038  CA  SER   134      26.453  38.833  12.348  1.00 64.53           C  
ATOM   1039  C   SER   134      27.446  39.623  13.187  1.00 64.39           C  
ATOM   1040  O   SER   134      27.038  40.511  13.912  1.00 64.78           O  
ATOM   1041  CB  SER   134      26.413  39.349  10.905  1.00 64.99           C  
ATOM   1042  OG  SER   134      26.081  40.730  10.848  1.00 65.96           O  
ATOM   1043  N   SER   135      28.729  39.267  13.116  1.00 64.44           N  
ATOM   1044  CA  SER   135      29.785  39.989  13.830  1.00 65.34           C  
ATOM   1045  C   SER   135      30.841  40.437  12.807  1.00 63.57           C  
ATOM   1046  O   SER   135      31.427  39.600  12.109  1.00 63.08           O  
ATOM   1047  CB  SER   135      30.426  39.147  14.963  1.00 66.54           C  
ATOM   1048  OG  SER   135      31.524  38.337  14.532  1.00 70.43           O  
ATOM   1049  N   LEU   136      31.081  41.746  12.736  1.00 61.69           N  
ATOM   1050  CA  LEU   136      32.059  42.296  11.812  1.00 61.12           C  
ATOM   1051  C   LEU   136      33.433  42.072  12.430  1.00 59.81           C  
ATOM   1052  O   LEU   136      33.646  42.445  13.582  1.00 60.39           O  
ATOM   1053  CB  LEU   136      31.823  43.796  11.594  1.00 61.14           C  
ATOM   1054  CG  LEU   136      32.442  44.352  10.313  1.00 61.78           C  
ATOM   1055  CD1 LEU   136      31.538  44.017   9.124  1.00 59.14           C  
ATOM   1056  CD2 LEU   136      32.657  45.865  10.408  1.00 61.99           C  
ATOM   1057  N   LEU   137      34.342  41.435  11.694  1.00 58.51           N  
ATOM   1058  CA  LEU   137      35.707  41.216  12.179  1.00 58.04           C  
ATOM   1059  C   LEU   137      36.523  42.492  12.002  1.00 57.44           C  
ATOM   1060  O   LEU   137      36.082  43.443  11.352  1.00 57.36           O  
ATOM   1061  CB  LEU   137      36.422  40.064  11.452  1.00 58.32           C  
ATOM   1062  CG  LEU   137      35.743  38.699  11.251  1.00 59.84           C  
ATOM   1063  CD1 LEU   137      36.827  37.625  11.029  1.00 60.58           C  
ATOM   1064  CD2 LEU   137      34.883  38.315  12.395  1.00 60.91           C  
ATOM   1065  N   ALA   138      37.714  42.499  12.595  1.00 57.39           N  
ATOM   1066  CA  ALA   138      38.658  43.610  12.468  1.00 57.25           C  
ATOM   1067  C   ALA   138      39.122  43.692  11.017  1.00 57.29           C  
ATOM   1068  O   ALA   138      39.334  42.657  10.371  1.00 56.94           O  
ATOM   1069  CB  ALA   138      39.857  43.420  13.392  1.00 56.76           C  
ATOM   1070  N   GLY   139      39.247  44.917  10.509  1.00 57.45           N  
ATOM   1071  CA  GLY   139      39.658  45.141   9.138  1.00 57.98           C  
ATOM   1072  C   GLY   139      41.117  44.779   8.936  1.00 59.06           C  
ATOM   1073  O   GLY   139      41.933  44.939   9.852  1.00 59.88           O  
ATOM   1074  N   ILE   140      41.433  44.283   7.740  1.00 59.80           N  
ATOM   1075  CA  ILE   140      42.794  43.886   7.364  1.00 59.77           C  
ATOM   1076  C   ILE   140      43.141  44.612   6.080  1.00 60.20           C  
ATOM   1077  O   ILE   140      42.533  44.341   5.040  1.00 59.84           O  
ATOM   1078  CB  ILE   140      42.888  42.359   7.163  1.00 59.89           C  
ATOM   1079  CG1 ILE   140      42.524  41.634   8.472  1.00 59.59           C  
ATOM   1080  CG2 ILE   140      44.284  41.959   6.679  1.00 57.61           C  
ATOM   1081  CD1 ILE   140      42.558  40.124   8.388  1.00 60.05           C  
ATOM   1082  N   LYS   141      44.089  45.550   6.166  1.00 61.05           N  
ATOM   1083  CA  LYS   141      44.551  46.308   5.004  1.00 61.39           C  
ATOM   1084  C   LYS   141      45.505  45.436   4.196  1.00 61.80           C  
ATOM   1085  O   LYS   141      46.435  44.863   4.758  1.00 61.94           O  
ATOM   1086  CB  LYS   141      45.220  47.636   5.395  1.00 61.26           C  
ATOM   1087  CG  LYS   141      44.261  48.637   6.051  1.00 60.97           C  
ATOM   1088  CD  LYS   141      44.626  50.104   5.782  1.00 62.29           C  
ATOM   1089  CE  LYS   141      45.887  50.578   6.490  1.00 64.00           C  
ATOM   1090  NZ  LYS   141      45.648  50.668   7.955  1.00 66.94           N  
ATOM   1091  N   VAL   142      45.263  45.347   2.886  1.00 62.47           N  
ATOM   1092  CA  VAL   142      46.056  44.518   1.960  1.00 62.73           C  
ATOM   1093  C   VAL   142      46.397  45.304   0.688  1.00 62.79           C  
ATOM   1094  O   VAL   142      45.686  46.247   0.341  1.00 63.25           O  
ATOM   1095  CB  VAL   142      45.279  43.192   1.617  1.00 62.84           C  
ATOM   1096  CG1 VAL   142      43.942  43.483   0.942  1.00 61.54           C  
ATOM   1097  CG2 VAL   142      46.118  42.251   0.754  1.00 62.99           C  
ATOM   1098  N   LEU   143      47.503  44.942   0.031  1.00 62.93           N  
ATOM   1099  CA  LEU   143      47.899  45.541  -1.257  1.00 62.76           C  
ATOM   1100  C   LEU   143      47.322  44.669  -2.384  1.00 63.19           C  
ATOM   1101  O   LEU   143      47.264  43.442  -2.251  1.00 63.43           O  
ATOM   1102  CB  LEU   143      49.418  45.684  -1.374  1.00 62.31           C  
ATOM   1103  CG  LEU   143      50.110  46.684  -0.431  1.00 61.86           C  
ATOM   1104  CD1 LEU   143      51.635  46.657  -0.621  1.00 56.90           C  
ATOM   1105  CD2 LEU   143      49.587  48.107  -0.615  1.00 60.19           C  
ATOM   1106  N   LEU   144      46.890  45.314  -3.474  1.00 63.28           N  
ATOM   1107  CA  LEU   144      46.237  44.652  -4.623  1.00 63.02           C  
ATOM   1108  C   LEU   144      47.069  44.717  -5.899  1.00 62.91           C  
ATOM   1109  O   LEU   144      47.958  45.564  -6.018  1.00 63.42           O  
ATOM   1110  CB  LEU   144      44.884  45.320  -4.886  1.00 63.08           C  
ATOM   1111  CG  LEU   144      43.824  45.246  -3.788  1.00 60.34           C  
ATOM   1112  CD1 LEU   144      42.664  46.175  -4.098  1.00 57.50           C  
ATOM   1113  CD2 LEU   144      43.346  43.822  -3.622  1.00 61.41           C  
ATOM   1114  N   GLY   145      46.763  43.832  -6.853  1.00 62.92           N  
ATOM   1115  CA  GLY   145      47.483  43.799  -8.134  1.00 63.90           C  
ATOM   1116  C   GLY   145      47.247  42.592  -9.027  1.00 64.09           C  
ATOM   1117  O   GLY   145      47.895  42.477 -10.091  1.00 63.32           O  
END
