
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  135 ( 1060),  selected  135 , name 2fhq_A
# Molecule2: number of CA atoms  145 ( 1098),  selected  145 , name T0497.pdb
# PARAMETERS: 2fhq_A.T0497.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T     3_A      -       -           -
LGA    K     4_A      M       1           #
LGA    T     5_A      A       2           #
LGA    -       -      D       3           -
LGA    -       -      P       4           -
LGA    -       -      K       5           -
LGA    -       -      E       6           -
LGA    X     6_A      L       7          1.632
LGA    K     7_A      Q       8          1.163
LGA    E     8_A      D       9          1.634
LGA    K     9_A      K      10          2.061
LGA    A    10_A      F      11          1.401
LGA    V    11_A      W      12          1.878
LGA    E    12_A      K      13          2.273
LGA    L    13_A      A      14          2.093
LGA    L    14_A      L      15          1.717
LGA    Q    15_A      K      16          2.775
LGA    K    16_A      S      17          2.842
LGA    C    17_A      D      18          0.924
LGA    E    18_A      R      19          2.797
LGA    V    19_A      T      20          1.598
LGA    V    20_A      V      21          1.723
LGA    T    21_A      M      22          1.564
LGA    L    22_A      L      23          1.588
LGA    A    23_A      G      24          1.677
LGA    S    24_A      L      25          2.042
LGA    V    25_A      D      26          4.346
LGA    N    26_A      -       -           -
LGA    K    27_A      -       -           -
LGA    E    28_A      -       -           -
LGA    G    29_A      G      27          4.789
LGA    Y    30_A      V      28          2.692
LGA    -       -      E      29           -
LGA    -       -      D      30           -
LGA    P    31_A      G      31          2.148
LGA    R    32_A      H      32          2.553
LGA    P    33_A      A      33          1.823
LGA    V    34_A      R      34          0.846
LGA    P    35_A      P      35          0.498
LGA    X    36_A      M      36          0.614
LGA    S    37_A      T      37          1.455
LGA    K    38_A      A      38          2.011
LGA    I    39_A      Q      39          3.027
LGA    A    40_A      I      40          2.905
LGA    A    41_A      E      41          4.972
LGA    E    42_A      G      42          4.995
LGA    -       -      D      43           -
LGA    G    43_A      S      44          1.836
LGA    I    44_A      G      45          4.604
LGA    S    45_A      G      46          3.006
LGA    T    46_A      P      47          2.064
LGA    I    47_A      I      48          0.964
LGA    W    48_A      W      49          0.991
LGA    X    49_A      F      50          0.683
LGA    S    50_A      F      51          0.847
LGA    T    51_A      T      52          1.075
LGA    G    52_A      S      53          1.449
LGA    A    53_A      K      54          1.738
LGA    D    54_A      D      55          2.461
LGA    S    55_A      N      56          1.451
LGA    L    56_A      A      57          0.526
LGA    K    57_A      L      58          1.669
LGA    T    58_A      I      59          0.828
LGA    I    59_A      A      60          1.376
LGA    D    60_A      M      61          2.185
LGA    F    61_A      L      62          1.644
LGA    L    62_A      G      63          2.490
LGA    S    63_A      Q      64           #
LGA    N    64_A      G      65          5.013
LGA    P    65_A      R      66          1.711
LGA    K    66_A      R      67          1.012
LGA    A    67_A      V      68          1.446
LGA    G    68_A      I      69          1.541
LGA    L    69_A      G      70          1.510
LGA    C    70_A      A      71          2.497
LGA    F    71_A      F      72          1.442
LGA    Q    72_A      S      73          0.775
LGA    E    73_A      S      74          1.980
LGA    -       -      K      75           -
LGA    -       -      G      76           -
LGA    K    74_A      H      77          1.691
LGA    G    75_A      D      78          3.694
LGA    D    76_A      L      79          1.588
LGA    S    77_A      F      80          0.394
LGA    V    78_A      A      81          0.937
LGA    A    79_A      S      82          0.992
LGA    L    80_A      I      83          0.942
LGA    X    81_A      S      84          0.230
LGA    G    82_A      G      85          0.464
LGA    E    83_A      S      86          0.622
LGA    V    84_A      L      87          1.403
LGA    E    85_A      R      88          2.439
LGA    V    86_A      E      89          0.517
LGA    V    87_A      D      90          0.986
LGA    T    88_A      T      91          1.902
LGA    D    89_A      D      92          1.393
LGA    E    90_A      P      93          1.485
LGA    K    91_A      A      94          1.510
LGA    L    92_A      V      95          1.471
LGA    K    93_A      V      96          1.780
LGA    Q    94_A      D      97          2.396
LGA    E    95_A      R      98          2.303
LGA    L    96_A      L      99          1.894
LGA    W    97_A      W     100          2.344
LGA    Q    98_A      N     101          3.074
LGA    D    99_A      P     102          2.691
LGA    W   100_A      Y     103          3.810
LGA    F   101_A      V     104          3.777
LGA    -       -      A     105           -
LGA    -       -      A     106           -
LGA    I   102_A      W     107          4.074
LGA    E   103_A      Y     108          4.143
LGA    H   104_A      -       -           -
LGA    F   105_A      -       -           -
LGA    P   106_A      E     109          2.547
LGA    G   107_A      G     110          1.940
LGA    G   108_A      G     111          1.292
LGA    P   109_A      K     112          0.531
LGA    T   110_A      D     113          1.763
LGA    D   111_A      D     114          1.925
LGA    P   112_A      P     115          2.427
LGA    G   113_A      K     116          1.957
LGA    Y   114_A      L     117          1.037
LGA    V   115_A      A     118          1.221
LGA    L   116_A      L     119          0.717
LGA    L   117_A      L     120          0.904
LGA    K   118_A      R     121          1.052
LGA    F   119_A      L     122          0.829
LGA    T   120_A      D     123          1.177
LGA    A   121_A      A     124          0.964
LGA    N   122_A      D     125          0.837
LGA    H   123_A      H     126          1.541
LGA    A   124_A      A     127          1.056
LGA    T   125_A      Q     128          0.278
LGA    Y   126_A      I     129          0.672
LGA    W   127_A      W     130          0.040
LGA    I   128_A      L     131          1.601
LGA    E   129_A      N     132          4.875
LGA    G   130_A      G     133          4.141
LGA    T   131_A      S     134           -
LGA    F   132_A      S     135           -
LGA    I   133_A      L     136           -
LGA    H   134_A      L     137           -
LGA    K   135_A      A     138           -
LGA    K   136_A      G     139           -
LGA    L   137_A      I     140           -
LGA    -       -      K     141           -
LGA    -       -      V     142           -
LGA    -       -      L     143           -
LGA    -       -      L     144           -
LGA    -       -      G     145           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  135  145    5.0    119    2.18    22.69     62.163     5.226

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =   0.017644 * X  +   0.673544 * Y  +  -0.738937 * Z  +  26.819462
  Y_new =   0.983760 * X  +   0.120333 * Y  +   0.133174 * Z  +  -9.439299
  Z_new =   0.178617 * X  +  -0.729286 * Y  +  -0.660483 * Z  +  54.935444 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -2.306727    0.834865  [ DEG:  -132.1657     47.8343 ]
  Theta =  -0.179581   -2.962012  [ DEG:   -10.2892   -169.7108 ]
  Phi   =   1.552863   -1.588729  [ DEG:    88.9725    -91.0275 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2fhq_A                                        
REMARK     2: T0497.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2fhq_A.T0497.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  135  145   5.0  119   2.18   22.69  62.163
REMARK  ---------------------------------------------------------- 
MOLECULE 2fhq_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   26-DEC-05   2FHQ              
TITLE     CRYSTAL STRUCTURE OF GENERAL STRESS PROTEIN FROM                      
TITLE    2 BACTEROIDES THETAIOTAOMICRON                                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: PUTATIVE GENERAL STRESS PROTEIN;                           
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: BACTEROIDES THETAIOTAOMICRON;                   
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 STRAIN: VPI-5482;                                                    
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_STRAIN: BL21DE3;                                   
SOURCE   8 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   9 EXPRESSION_SYSTEM_PLASMID: PMCSG7                                    
KEYWDS    ALPHA-BETA STRUCTURE, STRUCTURAL GENOMICS, PSI, PROTEIN               
KEYWDS   2 STRUCTURE INITIATIVE, MIDWEST CENTER FOR STRUCTURAL                  
KEYWDS   3 GENOMICS, MCSG                                                       
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    Y.KIM,C.HATZOS,J.ABDULLAH,A.JOACHIMIAK,MIDWEST CENTER FOR             
AUTHOR   2 STRUCTURAL GENOMICS (MCSG)                                           
REVDAT   1   07-FEB-06 2FHQ    0                                                
JRNL        AUTH   Y.KIM,C.HATZOS,J.ABDULLAH,A.JOACHIMIAK                       
JRNL        TITL   CRYSTAL STRUCTURE OF GENERAL STRESS PROTEIN FROM             
JRNL        TITL 2 BACTEROIDES THETAIOTAOMICRON                                 
JRNL        REF    TO BE PUBLISHED                            2006              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.87 ANGSTROMS.                                          
DBREF  2FHQ A    1   138  GB     29338736 AAO76536         1    138             
DBREF  2FHQ B    1   138  GB     29338736 AAO76536         1    138             
SEQRES   1 A  141  SER ASN ALA MSE SER THR LYS THR MSE LYS GLU LYS ALA          
SEQRES   2 A  141  VAL GLU LEU LEU GLN LYS CYS GLU VAL VAL THR LEU ALA          
SEQRES   3 A  141  SER VAL ASN LYS GLU GLY TYR PRO ARG PRO VAL PRO MSE          
SEQRES   4 A  141  SER LYS ILE ALA ALA GLU GLY ILE SER THR ILE TRP MSE          
SEQRES   5 A  141  SER THR GLY ALA ASP SER LEU LYS THR ILE ASP PHE LEU          
SEQRES   6 A  141  SER ASN PRO LYS ALA GLY LEU CYS PHE GLN GLU LYS GLY          
SEQRES   7 A  141  ASP SER VAL ALA LEU MSE GLY GLU VAL GLU VAL VAL THR          
SEQRES   8 A  141  ASP GLU LYS LEU LYS GLN GLU LEU TRP GLN ASP TRP PHE          
SEQRES   9 A  141  ILE GLU HIS PHE PRO GLY GLY PRO THR ASP PRO GLY TYR          
SEQRES  10 A  141  VAL LEU LEU LYS PHE THR ALA ASN HIS ALA THR TYR TRP          
SEQRES  11 A  141  ILE GLU GLY THR PHE ILE HIS LYS LYS LEU ASP                  
SEQRES   1 B  141  SER ASN ALA MSE SER THR LYS THR MSE LYS GLU LYS ALA          
SEQRES   2 B  141  VAL GLU LEU LEU GLN LYS CYS GLU VAL VAL THR LEU ALA          
SEQRES   3 B  141  SER VAL ASN LYS GLU GLY TYR PRO ARG PRO VAL PRO MSE          
SEQRES   4 B  141  SER LYS ILE ALA ALA GLU GLY ILE SER THR ILE TRP MSE          
SEQRES   5 B  141  SER THR GLY ALA ASP SER LEU LYS THR ILE ASP PHE LEU          
SEQRES   6 B  141  SER ASN PRO LYS ALA GLY LEU CYS PHE GLN GLU LYS GLY          
SEQRES   7 B  141  ASP SER VAL ALA LEU MSE GLY GLU VAL GLU VAL VAL THR          
SEQRES   8 B  141  ASP GLU LYS LEU LYS GLN GLU LEU TRP GLN ASP TRP PHE          
SEQRES   9 B  141  ILE GLU HIS PHE PRO GLY GLY PRO THR ASP PRO GLY TYR          
SEQRES  10 B  141  VAL LEU LEU LYS PHE THR ALA ASN HIS ALA THR TYR TRP          
SEQRES  11 B  141  ILE GLU GLY THR PHE ILE HIS LYS LYS LEU ASP                  
HET    MSE  A   6       8                                                       
HET    MSE  A  36       8                                                       
HET    MSE  A  49       8                                                       
HET    MSE  A  81      16                                                       
HET    MSE  B   6       8                                                       
HET    MSE  B  36       8                                                       
HET    MSE  B  49       8                                                       
HET    MSE  B  81       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
FORMUL   1  MSE    8(C5 H11 N O2 SE)                                            
FORMUL   3  HOH   *225(H2 O)                                                    
CRYST1   44.223   66.280   50.690  90.00 114.77  90.00 P 1 21 1      4          
ATOM      1  N   THR A   3       8.147  48.374  14.659  1.00 41.99           N  
ATOM      2  CA  THR A   3       9.083  47.298  15.103  1.00 41.94           C  
ATOM      3  C   THR A   3       8.350  46.081  15.659  1.00 41.48           C  
ATOM      4  O   THR A   3       7.417  46.220  16.456  1.00 42.89           O  
ATOM      5  CB  THR A   3      10.028  47.785  16.206  1.00 41.88           C  
ATOM      6  OG1 THR A   3       9.244  48.201  17.328  1.00 43.50           O  
ATOM      7  CG2 THR A   3      10.919  48.935  15.719  1.00 41.70           C  
ATOM      8  N   LYS A   4       8.819  44.898  15.276  1.00 39.32           N  
ATOM      9  CA  LYS A   4       8.242  43.641  15.716  1.00 37.25           C  
ATOM     10  C   LYS A   4       8.933  43.126  16.962  1.00 35.17           C  
ATOM     11  O   LYS A   4      10.147  43.188  17.069  1.00 34.37           O  
ATOM     12  CB  LYS A   4       8.364  42.597  14.612  1.00 37.49           C  
ATOM     13  CG  LYS A   4       7.503  42.873  13.410  1.00 40.03           C  
ATOM     14  CD  LYS A   4       8.256  43.673  12.350  1.00 43.86           C  
ATOM     15  CE  LYS A   4       7.449  43.737  11.054  1.00 45.70           C  
ATOM     16  NZ  LYS A   4       6.870  42.404  10.693  1.00 48.69           N  
ATOM     17  N   THR A   5       8.146  42.597  17.893  1.00 33.47           N  
ATOM     18  CA  THR A   5       8.675  41.978  19.104  1.00 32.23           C  
ATOM     19  C   THR A   5       9.312  40.646  18.739  1.00 31.69           C  
ATOM     20  O   THR A   5       9.128  40.163  17.621  1.00 31.66           O  
ATOM     21  CB  THR A   5       7.561  41.676  20.106  1.00 32.59           C  
ATOM     22  OG1 THR A   5       6.615  40.771  19.504  1.00 30.67           O  
ATOM     23  CG2 THR A   5       6.867  42.971  20.561  1.00 32.61           C  
HETATM   24  N   MSE A   6      10.064  40.065  19.664  1.00 30.27           N  
HETATM   25  CA  MSE A   6      10.560  38.707  19.501  1.00 30.02           C  
HETATM   26  C   MSE A   6       9.422  37.720  19.131  1.00 29.43           C  
HETATM   27  O   MSE A   6       9.600  36.840  18.266  1.00 28.85           O  
HETATM   28  CB  MSE A   6      11.249  38.249  20.776  1.00 29.69           C  
HETATM   29  CG  MSE A   6      12.662  38.817  20.995  1.00 31.13           C  
HETATM   30 SE   MSE A   6      13.833  38.540  19.494  0.70 32.66          SE  
HETATM   31  CE  MSE A   6      15.442  38.133  20.489  1.00 31.23           C  
ATOM     32  N   LYS A   7       8.269  37.854  19.779  1.00 29.55           N  
ATOM     33  CA  LYS A   7       7.124  36.980  19.459  1.00 29.77           C  
ATOM     34  C   LYS A   7       6.656  37.098  18.016  1.00 30.38           C  
ATOM     35  O   LYS A   7       6.478  36.092  17.315  1.00 29.80           O  
ATOM     36  CB  LYS A   7       5.970  37.208  20.415  1.00 30.56           C  
ATOM     37  CG  LYS A   7       4.727  36.365  20.067  1.00 31.33           C  
ATOM     38  CD  LYS A   7       4.082  35.772  21.294  1.00 33.72           C  
ATOM     39  CE  LYS A   7       3.214  36.774  21.987  1.00 34.96           C  
ATOM     40  NZ  LYS A   7       2.192  36.036  22.791  1.00 37.88           N  
ATOM     41  N   GLU A   8       6.484  38.330  17.560  1.00 30.77           N  
ATOM     42  CA  GLU A   8       6.066  38.611  16.195  1.00 31.03           C  
ATOM     43  C   GLU A   8       7.097  38.131  15.159  1.00 31.71           C  
ATOM     44  O   GLU A   8       6.742  37.608  14.090  1.00 31.56           O  
ATOM     45  CB  GLU A   8       5.784  40.101  16.049  1.00 30.82           C  
ATOM     46  CG  GLU A   8       4.583  40.576  16.880  1.00 31.48           C  
ATOM     47  CD  GLU A   8       4.368  42.086  16.855  1.00 32.45           C  
ATOM     48  OE1 GLU A   8       3.193  42.520  16.859  1.00 36.32           O  
ATOM     49  OE2 GLU A   8       5.353  42.849  16.867  1.00 32.29           O  
ATOM     50  N   LYS A   9       8.373  38.305  15.481  1.00 30.86           N  
ATOM     51  CA  LYS A   9       9.465  37.790  14.651  1.00 31.56           C  
ATOM     52  C   LYS A   9       9.439  36.249  14.558  1.00 31.13           C  
ATOM     53  O   LYS A   9       9.680  35.673  13.485  1.00 30.80           O  
ATOM     54  CB  LYS A   9      10.813  38.252  15.236  1.00 32.19           C  
ATOM     55  CG  LYS A   9      10.975  39.770  15.381  1.00 33.66           C  
ATOM     56  CD  LYS A   9      11.641  40.422  14.159  1.00 37.99           C  
ATOM     57  CE  LYS A   9      10.776  40.329  12.909  1.00 39.34           C  
ATOM     58  NZ  LYS A   9      11.595  40.358  11.653  1.00 41.57           N  
ATOM     59  N   ALA A  10       9.159  35.604  15.695  1.00 30.64           N  
ATOM     60  CA  ALA A  10       9.060  34.154  15.762  1.00 30.77           C  
ATOM     61  C   ALA A  10       7.884  33.619  14.935  1.00 30.72           C  
ATOM     62  O   ALA A  10       8.001  32.587  14.277  1.00 31.59           O  
ATOM     63  CB  ALA A  10       8.941  33.719  17.161  1.00 30.46           C  
ATOM     64  N   VAL A  11       6.754  34.320  14.967  1.00 30.78           N  
ATOM     65  CA  VAL A  11       5.594  33.948  14.142  1.00 30.33           C  
ATOM     66  C   VAL A  11       5.978  33.957  12.656  1.00 31.74           C  
ATOM     67  O   VAL A  11       5.721  32.989  11.925  1.00 29.70           O  
ATOM     68  CB  VAL A  11       4.359  34.846  14.443  1.00 30.37           C  
ATOM     69  CG1 VAL A  11       3.191  34.552  13.478  1.00 28.62           C  
ATOM     70  CG2 VAL A  11       3.921  34.665  15.879  1.00 28.22           C  
ATOM     71  N   GLU A  12       6.655  35.028  12.232  1.00 32.64           N  
ATOM     72  CA  GLU A  12       7.161  35.134  10.869  1.00 34.47           C  
ATOM     73  C   GLU A  12       8.088  33.982  10.497  1.00 34.59           C  
ATOM     74  O   GLU A  12       7.990  33.420   9.412  1.00 35.47           O  
ATOM     75  CB  GLU A  12       7.914  36.445  10.697  1.00 34.64           C  
ATOM     76  CG  GLU A  12       7.030  37.629  10.385  1.00 39.14           C  
ATOM     77  CD  GLU A  12       7.822  38.799   9.831  1.00 43.71           C  
ATOM     78  OE1 GLU A  12       7.450  39.321   8.752  1.00 44.70           O  
ATOM     79  OE2 GLU A  12       8.834  39.175  10.463  1.00 45.66           O  
ATOM     80  N   LEU A  13       8.994  33.652  11.408  1.00 34.99           N  
ATOM     81  CA  LEU A  13       9.946  32.553  11.234  1.00 35.02           C  
ATOM     82  C   LEU A  13       9.210  31.216  11.033  1.00 34.34           C  
ATOM     83  O   LEU A  13       9.558  30.420  10.143  1.00 34.52           O  
ATOM     84  CB  LEU A  13      10.789  32.456  12.506  1.00 35.14           C  
ATOM     85  CG  LEU A  13      12.314  32.425  12.555  1.00 37.61           C  
ATOM     86  CD1 LEU A  13      12.938  31.577  11.452  1.00 37.77           C  
ATOM     87  CD2 LEU A  13      12.850  33.860  12.523  1.00 37.16           C  
ATOM     88  N   LEU A  14       8.205  30.979  11.881  1.00 33.87           N  
ATOM     89  CA  LEU A  14       7.444  29.725  11.874  1.00 32.96           C  
ATOM     90  C   LEU A  14       6.723  29.557  10.558  1.00 34.40           C  
ATOM     91  O   LEU A  14       6.749  28.479   9.972  1.00 34.52           O  
ATOM     92  CB  LEU A  14       6.440  29.664  13.031  1.00 31.73           C  
ATOM     93  CG  LEU A  14       5.799  28.280  13.278  1.00 29.50           C  
ATOM     94  CD1 LEU A  14       6.820  27.120  13.208  1.00 27.82           C  
ATOM     95  CD2 LEU A  14       5.069  28.274  14.613  1.00 30.07           C  
ATOM     96  N   GLN A  15       6.081  30.627  10.102  1.00 36.32           N  
ATOM     97  CA  GLN A  15       5.361  30.612   8.825  1.00 38.85           C  
ATOM     98  C   GLN A  15       6.262  30.140   7.674  1.00 38.96           C  
ATOM     99  O   GLN A  15       5.772  29.614   6.665  1.00 39.34           O  
ATOM    100  CB  GLN A  15       4.705  31.984   8.546  1.00 38.81           C  
ATOM    101  CG  GLN A  15       3.479  32.268   9.446  1.00 40.14           C  
ATOM    102  CD  GLN A  15       2.989  33.732   9.431  1.00 40.61           C  
ATOM    103  OE1 GLN A  15       3.685  34.653   8.967  1.00 42.31           O  
ATOM    104  NE2 GLN A  15       1.790  33.946   9.965  1.00 41.60           N  
ATOM    105  N   LYS A  16       7.574  30.280   7.853  1.00 39.66           N  
ATOM    106  CA  LYS A  16       8.560  29.853   6.848  1.00 40.19           C  
ATOM    107  C   LYS A  16       9.007  28.407   7.018  1.00 39.33           C  
ATOM    108  O   LYS A  16       9.623  27.843   6.111  1.00 39.78           O  
ATOM    109  CB  LYS A  16       9.794  30.767   6.871  1.00 40.38           C  
ATOM    110  CG  LYS A  16       9.507  32.240   6.468  1.00 42.20           C  
ATOM    111  CD  LYS A  16      10.753  33.132   6.559  1.00 42.70           C  
ATOM    112  CE  LYS A  16      11.534  33.183   5.238  1.00 47.55           C  
ATOM    113  NZ  LYS A  16      11.848  31.840   4.638  1.00 49.96           N  
ATOM    114  N   CYS A  17       8.728  27.817   8.183  1.00 37.79           N  
ATOM    115  CA  CYS A  17       9.155  26.449   8.475  1.00 36.29           C  
ATOM    116  C   CYS A  17       8.024  25.461   8.211  1.00 34.97           C  
ATOM    117  O   CYS A  17       6.890  25.674   8.654  1.00 34.78           O  
ATOM    118  CB  CYS A  17       9.632  26.315   9.929  1.00 35.78           C  
ATOM    119  SG  CYS A  17      11.014  27.368  10.380  1.00 39.16           S  
ATOM    120  N   GLU A  18       8.316  24.392   7.481  0.50 34.42           N  
ATOM    122  CA  GLU A  18       7.331  23.320   7.324  0.50 33.78           C  
ATOM    124  C   GLU A  18       7.666  22.134   8.229  0.50 33.05           C  
ATOM    126  O   GLU A  18       6.880  21.192   8.354  0.50 32.83           O  
ATOM    128  CB  GLU A  18       7.175  22.906   5.851  0.50 34.06           C  
ATOM    130  CG  GLU A  18       6.359  23.896   4.995  0.50 34.10           C  
ATOM    132  CD  GLU A  18       4.938  24.171   5.530  0.50 36.10           C  
ATOM    134  OE1 GLU A  18       4.274  23.247   6.057  0.50 35.05           O  
ATOM    136  OE2 GLU A  18       4.483  25.330   5.413  0.50 37.26           O  
ATOM    138  N   VAL A  19       8.829  22.212   8.876  1.00 32.52           N  
ATOM    139  CA  VAL A  19       9.319  21.168   9.764  1.00 31.74           C  
ATOM    140  C   VAL A  19       9.701  21.804  11.114  1.00 30.14           C  
ATOM    141  O   VAL A  19      10.234  22.926  11.165  1.00 29.59           O  
ATOM    142  CB  VAL A  19      10.509  20.398   9.090  1.00 31.63           C  
ATOM    143  CG1 VAL A  19      11.336  19.600  10.087  1.00 33.93           C  
ATOM    144  CG2 VAL A  19       9.993  19.473   7.982  1.00 32.54           C  
ATOM    145  N   VAL A  20       9.401  21.088  12.198  1.00 27.86           N  
ATOM    146  CA  VAL A  20       9.796  21.495  13.542  1.00 26.33           C  
ATOM    147  C   VAL A  20      10.407  20.267  14.197  1.00 26.26           C  
ATOM    148  O   VAL A  20      10.267  19.172  13.675  1.00 26.69           O  
ATOM    149  CB  VAL A  20       8.594  22.006  14.393  1.00 25.42           C  
ATOM    150  CG1 VAL A  20       7.958  23.234  13.741  1.00 25.18           C  
ATOM    151  CG2 VAL A  20       7.536  20.887  14.627  1.00 23.31           C  
ATOM    152  N   THR A  21      11.099  20.446  15.315  1.00 25.29           N  
ATOM    153  CA  THR A  21      11.550  19.300  16.108  1.00 24.99           C  
ATOM    154  C   THR A  21      10.781  19.264  17.423  1.00 24.45           C  
ATOM    155  O   THR A  21      10.768  20.261  18.174  1.00 23.82           O  
ATOM    156  CB  THR A  21      13.070  19.363  16.377  1.00 26.11           C  
ATOM    157  OG1 THR A  21      13.749  19.494  15.131  1.00 25.27           O  
ATOM    158  CG2 THR A  21      13.548  18.100  17.065  1.00 26.36           C  
ATOM    159  N   LEU A  22      10.176  18.114  17.711  1.00 23.47           N  
ATOM    160  CA  LEU A  22       9.289  17.953  18.865  1.00 22.67           C  
ATOM    161  C   LEU A  22       9.945  16.983  19.814  1.00 22.15           C  
ATOM    162  O   LEU A  22      10.448  15.940  19.372  1.00 23.11           O  
ATOM    163  CB  LEU A  22       7.915  17.416  18.409  1.00 23.32           C  
ATOM    164  CG  LEU A  22       6.892  17.116  19.512  1.00 21.82           C  
ATOM    165  CD1 LEU A  22       6.509  18.441  20.249  1.00 21.04           C  
ATOM    166  CD2 LEU A  22       5.647  16.378  18.977  1.00 22.73           C  
ATOM    167  N   ALA A  23       9.996  17.335  21.097  1.00 21.36           N  
ATOM    168  CA  ALA A  23      10.494  16.437  22.130  1.00 21.24           C  
ATOM    169  C   ALA A  23       9.415  16.040  23.124  1.00 21.84           C  
ATOM    170  O   ALA A  23       8.606  16.865  23.559  1.00 21.34           O  
ATOM    171  CB  ALA A  23      11.700  17.052  22.879  1.00 21.26           C  
ATOM    172  N   SER A  24       9.426  14.766  23.481  1.00 22.30           N  
ATOM    173  CA  SER A  24       8.651  14.245  24.587  1.00 23.71           C  
ATOM    174  C   SER A  24       9.662  13.807  25.633  1.00 24.35           C  
ATOM    175  O   SER A  24      10.861  13.836  25.382  1.00 24.59           O  
ATOM    176  CB  SER A  24       7.806  13.032  24.149  1.00 23.69           C  
ATOM    177  OG  SER A  24       8.619  12.008  23.577  1.00 24.78           O  
ATOM    178  N   VAL A  25       9.169  13.400  26.796  1.00 25.51           N  
ATOM    179  CA  VAL A  25       9.967  12.706  27.779  1.00 26.25           C  
ATOM    180  C   VAL A  25       9.388  11.287  27.881  1.00 26.78           C  
ATOM    181  O   VAL A  25       8.172  11.122  28.092  1.00 26.96           O  
ATOM    182  CB  VAL A  25       9.905  13.399  29.148  1.00 26.38           C  
ATOM    183  CG1 VAL A  25      10.820  12.709  30.134  1.00 27.43           C  
ATOM    184  CG2 VAL A  25      10.280  14.891  29.015  1.00 28.31           C  
ATOM    185  N   ASN A  26      10.232  10.274  27.714  1.00 26.52           N  
ATOM    186  CA  ASN A  26       9.731   8.908  27.828  1.00 28.43           C  
ATOM    187  C   ASN A  26       9.579   8.486  29.298  1.00 29.76           C  
ATOM    188  O   ASN A  26       9.929   9.239  30.217  1.00 29.34           O  
ATOM    189  CB  ASN A  26      10.520   7.909  26.959  1.00 27.62           C  
ATOM    190  CG  ASN A  26      11.804   7.418  27.603  1.00 27.02           C  
ATOM    191  OD1 ASN A  26      12.164   7.809  28.727  1.00 25.47           O  
ATOM    192  ND2 ASN A  26      12.491   6.515  26.902  1.00 27.47           N  
ATOM    193  N   LYS A  27       9.035   7.296  29.524  1.00 31.67           N  
ATOM    194  CA  LYS A  27       8.776   6.879  30.891  1.00 33.10           C  
ATOM    195  C   LYS A  27      10.050   6.761  31.727  1.00 32.82           C  
ATOM    196  O   LYS A  27       9.989   6.821  32.946  1.00 32.67           O  
ATOM    197  CB  LYS A  27       7.969   5.576  30.945  1.00 33.93           C  
ATOM    198  CG  LYS A  27       8.462   4.450  30.059  1.00 37.32           C  
ATOM    199  CD  LYS A  27       8.034   3.091  30.646  1.00 43.46           C  
ATOM    200  CE  LYS A  27       6.768   3.230  31.492  1.00 43.60           C  
ATOM    201  NZ  LYS A  27       6.699   2.211  32.595  1.00 47.02           N  
ATOM    202  N   GLU A  28      11.196   6.604  31.067  1.00 32.71           N  
ATOM    203  CA  GLU A  28      12.469   6.511  31.783  1.00 32.61           C  
ATOM    204  C   GLU A  28      13.148   7.861  32.070  1.00 31.37           C  
ATOM    205  O   GLU A  28      14.229   7.882  32.643  1.00 31.73           O  
ATOM    206  CB  GLU A  28      13.431   5.587  31.051  1.00 33.08           C  
ATOM    207  CG  GLU A  28      13.459   4.181  31.589  1.00 37.41           C  
ATOM    208  CD  GLU A  28      14.167   3.219  30.657  1.00 43.48           C  
ATOM    209  OE1 GLU A  28      13.466   2.331  30.134  1.00 46.75           O  
ATOM    210  OE2 GLU A  28      15.405   3.356  30.427  1.00 44.81           O  
ATOM    211  N   GLY A  29      12.518   8.967  31.663  1.00 29.92           N  
ATOM    212  CA  GLY A  29      13.037  10.313  31.922  1.00 28.38           C  
ATOM    213  C   GLY A  29      13.915  10.880  30.810  1.00 27.93           C  
ATOM    214  O   GLY A  29      14.482  11.957  30.960  1.00 27.42           O  
ATOM    215  N   TYR A  30      14.021  10.160  29.692  1.00 27.41           N  
ATOM    216  CA  TYR A  30      14.837  10.598  28.539  1.00 26.41           C  
ATOM    217  C   TYR A  30      14.046  11.486  27.617  1.00 25.55           C  
ATOM    218  O   TYR A  30      12.941  11.130  27.220  1.00 25.54           O  
ATOM    219  CB  TYR A  30      15.390   9.404  27.742  1.00 26.05           C  
ATOM    220  CG  TYR A  30      16.453   8.643  28.467  1.00 26.56           C  
ATOM    221  CD1 TYR A  30      17.794   9.015  28.364  1.00 28.05           C  
ATOM    222  CD2 TYR A  30      16.125   7.547  29.269  1.00 28.69           C  
ATOM    223  CE1 TYR A  30      18.791   8.318  29.061  1.00 29.26           C  
ATOM    224  CE2 TYR A  30      17.118   6.840  29.970  1.00 29.66           C  
ATOM    225  CZ  TYR A  30      18.434   7.233  29.854  1.00 28.10           C  
ATOM    226  OH  TYR A  30      19.402   6.541  30.523  1.00 29.17           O  
ATOM    227  N   PRO A  31      14.617  12.651  27.242  1.00 25.95           N  
ATOM    228  CA  PRO A  31      13.921  13.484  26.258  1.00 25.12           C  
ATOM    229  C   PRO A  31      14.166  12.902  24.863  1.00 25.44           C  
ATOM    230  O   PRO A  31      15.246  12.377  24.603  1.00 25.45           O  
ATOM    231  CB  PRO A  31      14.597  14.857  26.416  1.00 26.19           C  
ATOM    232  CG  PRO A  31      15.962  14.563  26.914  1.00 24.42           C  
ATOM    233  CD  PRO A  31      15.907  13.240  27.663  1.00 25.20           C  
ATOM    234  N   ARG A  32      13.166  12.992  23.986  1.00 25.34           N  
ATOM    235  CA  ARG A  32      13.198  12.341  22.676  1.00 25.90           C  
ATOM    236  C   ARG A  32      12.831  13.350  21.603  1.00 24.86           C  
ATOM    237  O   ARG A  32      11.653  13.489  21.288  1.00 24.94           O  
ATOM    238  CB  ARG A  32      12.170  11.198  22.635  1.00 26.02           C  
ATOM    239  CG  ARG A  32      12.514   9.965  23.475  1.00 27.71           C  
ATOM    240  CD  ARG A  32      11.517   8.792  23.190  1.00 28.00           C  
ATOM    241  NE  ARG A  32      11.456   8.452  21.769  1.00 32.59           N  
ATOM    242  CZ  ARG A  32      12.404   7.797  21.098  1.00 34.03           C  
ATOM    243  NH1 ARG A  32      12.254   7.564  19.802  1.00 33.97           N  
ATOM    244  NH2 ARG A  32      13.511   7.388  21.704  1.00 35.21           N  
ATOM    245  N   PRO A  33      13.836  14.051  21.036  1.00 24.43           N  
ATOM    246  CA  PRO A  33      13.596  15.006  19.965  1.00 23.74           C  
ATOM    247  C   PRO A  33      13.406  14.267  18.627  1.00 23.72           C  
ATOM    248  O   PRO A  33      14.147  13.337  18.325  1.00 24.33           O  
ATOM    249  CB  PRO A  33      14.870  15.862  19.958  1.00 23.76           C  
ATOM    250  CG  PRO A  33      15.955  14.963  20.481  1.00 23.39           C  
ATOM    251  CD  PRO A  33      15.268  13.975  21.413  1.00 24.50           C  
ATOM    252  N   VAL A  34      12.389  14.644  17.864  1.00 23.97           N  
ATOM    253  CA  VAL A  34      12.163  14.066  16.531  1.00 24.35           C  
ATOM    254  C   VAL A  34      11.652  15.154  15.575  1.00 24.12           C  
ATOM    255  O   VAL A  34      10.871  16.011  15.980  1.00 24.14           O  
ATOM    256  CB  VAL A  34      11.199  12.829  16.596  1.00 24.75           C  
ATOM    257  CG1 VAL A  34       9.833  13.253  17.032  1.00 24.82           C  
ATOM    258  CG2 VAL A  34      11.115  12.135  15.269  1.00 27.85           C  
ATOM    259  N   PRO A  35      12.128  15.154  14.317  1.00 23.97           N  
ATOM    260  CA  PRO A  35      11.577  16.080  13.331  1.00 24.30           C  
ATOM    261  C   PRO A  35      10.144  15.729  12.951  1.00 24.79           C  
ATOM    262  O   PRO A  35       9.823  14.552  12.782  1.00 24.57           O  
ATOM    263  CB  PRO A  35      12.514  15.921  12.117  1.00 25.34           C  
ATOM    264  CG  PRO A  35      13.218  14.615  12.322  1.00 24.69           C  
ATOM    265  CD  PRO A  35      13.237  14.333  13.777  1.00 24.56           C  
HETATM  266  N   MSE A  36       9.297  16.750  12.815  1.00 24.82           N  
HETATM  267  CA  MSE A  36       7.884  16.555  12.564  1.00 25.15           C  
HETATM  268  C   MSE A  36       7.425  17.572  11.543  1.00 25.47           C  
HETATM  269  O   MSE A  36       7.852  18.724  11.578  1.00 25.05           O  
HETATM  270  CB  MSE A  36       7.064  16.757  13.850  1.00 25.22           C  
HETATM  271  CG  MSE A  36       7.435  15.909  15.058  1.00 27.37           C  
HETATM  272 SE   MSE A  36       6.848  14.058  14.840  0.65 30.45          SE  
HETATM  273  CE  MSE A  36       4.948  14.355  14.944  1.00 30.37           C  
ATOM    274  N   SER A  37       6.509  17.179  10.659  1.00 25.25           N  
ATOM    275  CA  SER A  37       5.951  18.166   9.747  1.00 25.84           C  
ATOM    276  C   SER A  37       4.974  18.999  10.547  1.00 25.68           C  
ATOM    277  O   SER A  37       4.205  18.453  11.333  1.00 25.05           O  
ATOM    278  CB  SER A  37       5.190  17.496   8.592  1.00 25.88           C  
ATOM    279  OG  SER A  37       6.016  16.565   7.933  1.00 29.45           O  
ATOM    280  N   LYS A  38       5.015  20.309  10.330  1.00 25.72           N  
ATOM    281  CA  LYS A  38       4.106  21.260  10.943  1.00 26.75           C  
ATOM    282  C   LYS A  38       2.858  21.299  10.068  1.00 27.52           C  
ATOM    283  O   LYS A  38       2.922  21.770   8.921  1.00 26.42           O  
ATOM    284  CB  LYS A  38       4.763  22.658  10.969  1.00 27.06           C  
ATOM    285  CG  LYS A  38       3.813  23.761  11.456  1.00 27.03           C  
ATOM    286  CD  LYS A  38       4.195  25.166  10.979  1.00 27.82           C  
ATOM    287  CE  LYS A  38       3.775  25.441   9.547  1.00 28.31           C  
ATOM    288  NZ  LYS A  38       4.418  26.722   9.121  1.00 30.12           N  
ATOM    289  N   ILE A  39       1.730  20.801  10.573  1.00 27.36           N  
ATOM    290  CA  ILE A  39       0.558  20.767   9.708  1.00 28.77           C  
ATOM    291  C   ILE A  39      -0.208  22.097   9.745  1.00 28.63           C  
ATOM    292  O   ILE A  39      -0.704  22.568   8.720  1.00 28.92           O  
ATOM    293  CB  ILE A  39      -0.290  19.409   9.772  1.00 29.35           C  
ATOM    294  CG1 ILE A  39      -1.284  19.344  10.928  1.00 31.08           C  
ATOM    295  CG2 ILE A  39       0.647  18.168   9.646  1.00 29.99           C  
ATOM    296  CD1 ILE A  39      -1.835  17.903  11.180  1.00 29.84           C  
ATOM    297  N   ALA A  40      -0.214  22.736  10.908  1.00 27.27           N  
ATOM    298  CA  ALA A  40      -0.810  24.053  11.079  1.00 27.35           C  
ATOM    299  C   ALA A  40      -0.289  24.690  12.366  1.00 27.07           C  
ATOM    300  O   ALA A  40       0.167  24.003  13.251  1.00 25.85           O  
ATOM    301  CB  ALA A  40      -2.345  23.933  11.126  1.00 27.10           C  
ATOM    302  N   ALA A  41      -0.382  26.009  12.454  1.00 29.00           N  
ATOM    303  CA  ALA A  41      -0.038  26.737  13.671  1.00 30.40           C  
ATOM    304  C   ALA A  41      -0.877  28.005  13.804  1.00 31.00           C  
ATOM    305  O   ALA A  41      -1.228  28.631  12.798  1.00 31.96           O  
ATOM    306  CB  ALA A  41       1.446  27.078  13.668  1.00 30.27           C  
ATOM    307  N   GLU A  42      -1.203  28.367  15.043  1.00 31.17           N  
ATOM    308  CA  GLU A  42      -1.900  29.612  15.370  1.00 32.27           C  
ATOM    309  C   GLU A  42      -0.843  30.452  16.098  1.00 31.11           C  
ATOM    310  O   GLU A  42      -0.531  30.156  17.260  1.00 30.57           O  
ATOM    311  CB  GLU A  42      -3.106  29.314  16.289  1.00 31.90           C  
ATOM    312  CG  GLU A  42      -4.121  28.316  15.670  1.00 35.76           C  
ATOM    313  CD  GLU A  42      -4.971  27.532  16.695  1.00 36.57           C  
ATOM    314  OE1 GLU A  42      -4.974  26.272  16.626  1.00 41.87           O  
ATOM    315  OE2 GLU A  42      -5.660  28.161  17.539  1.00 41.94           O  
ATOM    316  N   GLY A  43      -0.288  31.462  15.418  1.00 30.68           N  
ATOM    317  CA  GLY A  43       0.923  32.170  15.896  1.00 30.87           C  
ATOM    318  C   GLY A  43       2.029  31.185  16.232  1.00 30.64           C  
ATOM    319  O   GLY A  43       2.309  30.285  15.432  1.00 31.14           O  
ATOM    320  N   ILE A  44       2.657  31.363  17.405  1.00 30.50           N  
ATOM    321  CA  ILE A  44       3.523  30.351  18.030  1.00 29.64           C  
ATOM    322  C   ILE A  44       2.836  29.712  19.237  1.00 30.19           C  
ATOM    323  O   ILE A  44       3.434  28.898  19.950  1.00 31.54           O  
ATOM    324  CB  ILE A  44       4.949  30.899  18.442  1.00 29.55           C  
ATOM    325  CG1 ILE A  44       4.872  32.025  19.500  1.00 30.64           C  
ATOM    326  CG2 ILE A  44       5.720  31.317  17.215  1.00 28.78           C  
ATOM    327  CD1 ILE A  44       6.261  32.447  20.089  1.00 29.01           C  
ATOM    328  N   SER A  45       1.573  30.066  19.446  1.00 29.70           N  
ATOM    329  CA  SER A  45       0.814  29.619  20.608  1.00 29.84           C  
ATOM    330  C   SER A  45       0.359  28.174  20.498  1.00 28.55           C  
ATOM    331  O   SER A  45       0.365  27.439  21.474  1.00 28.46           O  
ATOM    332  CB  SER A  45      -0.409  30.523  20.807  1.00 29.82           C  
ATOM    333  OG  SER A  45       0.006  31.857  21.089  1.00 35.78           O  
ATOM    334  N   THR A  46      -0.066  27.767  19.307  1.00 28.06           N  
ATOM    335  CA  THR A  46      -0.578  26.420  19.115  1.00 27.17           C  
ATOM    336  C   THR A  46       0.046  25.858  17.862  1.00 25.85           C  
ATOM    337  O   THR A  46       0.054  26.509  16.844  1.00 25.56           O  
ATOM    338  CB  THR A  46      -2.113  26.426  18.979  1.00 27.45           C  
ATOM    339  OG1 THR A  46      -2.678  27.047  20.149  1.00 30.04           O  
ATOM    340  CG2 THR A  46      -2.668  25.016  18.821  1.00 28.20           C  
ATOM    341  N   ILE A  47       0.561  24.642  17.952  1.00 24.62           N  
ATOM    342  CA  ILE A  47       1.187  24.034  16.788  1.00 25.38           C  
ATOM    343  C   ILE A  47       0.669  22.612  16.652  1.00 25.29           C  
ATOM    344  O   ILE A  47       0.651  21.863  17.626  1.00 24.87           O  
ATOM    345  CB  ILE A  47       2.743  24.075  16.897  1.00 24.77           C  
ATOM    346  CG1 ILE A  47       3.211  25.533  17.094  1.00 25.62           C  
ATOM    347  CG2 ILE A  47       3.353  23.426  15.655  1.00 26.15           C  
ATOM    348  CD1 ILE A  47       4.664  25.739  17.557  1.00 26.49           C  
ATOM    349  N   TRP A  48       0.239  22.267  15.432  1.00 25.55           N  
ATOM    350  CA  TRP A  48      -0.439  21.007  15.146  1.00 25.84           C  
ATOM    351  C   TRP A  48       0.449  20.076  14.355  1.00 25.52           C  
ATOM    352  O   TRP A  48       0.993  20.475  13.329  1.00 25.16           O  
ATOM    353  CB  TRP A  48      -1.702  21.278  14.313  1.00 26.48           C  
ATOM    354  CG  TRP A  48      -2.796  21.959  15.068  1.00 26.95           C  
ATOM    355  CD1 TRP A  48      -3.100  23.293  15.070  1.00 27.69           C  
ATOM    356  CD2 TRP A  48      -3.741  21.327  15.931  1.00 28.76           C  
ATOM    357  NE1 TRP A  48      -4.175  23.528  15.890  1.00 28.15           N  
ATOM    358  CE2 TRP A  48      -4.588  22.337  16.433  1.00 28.95           C  
ATOM    359  CE3 TRP A  48      -3.966  19.998  16.318  1.00 28.14           C  
ATOM    360  CZ2 TRP A  48      -5.654  22.057  17.291  1.00 30.00           C  
ATOM    361  CZ3 TRP A  48      -5.009  19.727  17.198  1.00 27.82           C  
ATOM    362  CH2 TRP A  48      -5.850  20.740  17.655  1.00 27.77           C  
HETATM  363  N   MSE A  49       0.555  18.831  14.815  1.00 25.08           N  
HETATM  364  CA  MSE A  49       1.269  17.771  14.112  1.00 26.15           C  
HETATM  365  C   MSE A  49       0.404  16.500  14.042  1.00 25.86           C  
HETATM  366  O   MSE A  49      -0.620  16.407  14.695  1.00 24.98           O  
HETATM  367  CB  MSE A  49       2.590  17.497  14.821  1.00 25.39           C  
HETATM  368  CG  MSE A  49       3.525  18.689  14.726  1.00 26.80           C  
HETATM  369 SE   MSE A  49       4.709  18.938  16.205  0.75 29.22          SE  
HETATM  370  CE  MSE A  49       3.443  19.648  17.533  1.00 23.02           C  
ATOM    371  N   SER A  50       0.816  15.529  13.242  1.00 27.17           N  
ATOM    372  CA  SER A  50       0.099  14.265  13.214  1.00 27.90           C  
ATOM    373  C   SER A  50       1.071  13.154  13.545  1.00 27.75           C  
ATOM    374  O   SER A  50       2.295  13.334  13.443  1.00 27.94           O  
ATOM    375  CB  SER A  50      -0.613  14.063  11.876  1.00 27.90           C  
ATOM    376  OG  SER A  50       0.324  13.886  10.811  1.00 32.59           O  
ATOM    377  N   THR A  51       0.530  12.014  13.972  1.00 27.56           N  
ATOM    378  CA  THR A  51       1.329  10.854  14.353  1.00 27.84           C  
ATOM    379  C   THR A  51       0.425   9.617  14.393  1.00 27.71           C  
ATOM    380  O   THR A  51      -0.769   9.741  14.273  1.00 26.75           O  
ATOM    381  CB  THR A  51       2.002  11.068  15.736  1.00 27.48           C  
ATOM    382  OG1 THR A  51       2.960  10.039  15.965  1.00 30.17           O  
ATOM    383  CG2 THR A  51       0.983  11.052  16.841  1.00 27.96           C  
ATOM    384  N   GLY A  52       1.019   8.433  14.501  1.00 29.07           N  
ATOM    385  CA  GLY A  52       0.247   7.181  14.690  1.00 30.52           C  
ATOM    386  C   GLY A  52      -0.316   7.023  16.096  1.00 31.18           C  
ATOM    387  O   GLY A  52       0.286   7.466  17.081  1.00 31.21           O  
ATOM    388  N   ALA A  53      -1.453   6.359  16.210  1.00 31.58           N  
ATOM    389  CA  ALA A  53      -2.069   6.129  17.510  1.00 32.12           C  
ATOM    390  C   ALA A  53      -1.179   5.274  18.405  1.00 32.36           C  
ATOM    391  O   ALA A  53      -1.288   5.344  19.625  1.00 33.42           O  
ATOM    392  CB  ALA A  53      -3.462   5.508  17.360  1.00 32.03           C  
ATOM    393  N   ASP A  54      -0.280   4.503  17.804  1.00 33.03           N  
ATOM    394  CA  ASP A  54       0.650   3.646  18.566  1.00 33.82           C  
ATOM    395  C   ASP A  54       2.102   4.113  18.521  1.00 32.25           C  
ATOM    396  O   ASP A  54       3.012   3.348  18.857  1.00 31.30           O  
ATOM    397  CB  ASP A  54       0.567   2.185  18.089  1.00 35.01           C  
ATOM    398  CG  ASP A  54       0.934   1.188  19.186  1.00 39.47           C  
ATOM    399  OD1 ASP A  54       0.599   1.440  20.373  1.00 44.73           O  
ATOM    400  OD2 ASP A  54       1.550   0.140  18.854  1.00 45.27           O  
ATOM    401  N   SER A  55       2.324   5.364  18.109  1.00 30.72           N  
ATOM    402  CA  SER A  55       3.687   5.879  17.968  1.00 29.33           C  
ATOM    403  C   SER A  55       4.318   6.047  19.355  1.00 29.03           C  
ATOM    404  O   SER A  55       3.598   6.228  20.337  1.00 27.93           O  
ATOM    405  CB  SER A  55       3.669   7.224  17.260  1.00 29.34           C  
ATOM    406  OG  SER A  55       3.094   8.206  18.111  1.00 26.23           O  
ATOM    407  N   LEU A  56       5.649   6.018  19.422  1.00 28.72           N  
ATOM    408  CA  LEU A  56       6.363   6.305  20.669  1.00 28.60           C  
ATOM    409  C   LEU A  56       5.996   7.685  21.229  1.00 28.32           C  
ATOM    410  O   LEU A  56       5.858   7.850  22.433  1.00 28.48           O  
ATOM    411  CB  LEU A  56       7.887   6.190  20.490  1.00 28.51           C  
ATOM    412  CG  LEU A  56       8.484   4.880  19.948  1.00 29.58           C  
ATOM    413  CD1 LEU A  56       9.874   5.146  19.442  1.00 30.10           C  
ATOM    414  CD2 LEU A  56       8.516   3.795  20.988  1.00 31.42           C  
ATOM    415  N   LYS A  57       5.852   8.679  20.354  1.00 28.62           N  
ATOM    416  CA  LYS A  57       5.404  10.007  20.775  1.00 27.40           C  
ATOM    417  C   LYS A  57       4.047   9.939  21.481  1.00 27.85           C  
ATOM    418  O   LYS A  57       3.885  10.472  22.587  1.00 26.18           O  
ATOM    419  CB  LYS A  57       5.343  10.963  19.567  1.00 27.12           C  
ATOM    420  CG  LYS A  57       6.669  11.583  19.173  1.00 26.78           C  
ATOM    421  CD  LYS A  57       7.017  12.790  20.092  1.00 26.92           C  
ATOM    422  CE  LYS A  57       8.486  13.177  19.997  1.00 24.83           C  
ATOM    423  NZ  LYS A  57       9.380  12.115  20.540  1.00 23.79           N  
ATOM    424  N   THR A  58       3.066   9.277  20.854  1.00 27.93           N  
ATOM    425  CA  THR A  58       1.765   9.120  21.496  1.00 28.18           C  
ATOM    426  C   THR A  58       1.905   8.443  22.846  1.00 28.61           C  
ATOM    427  O   THR A  58       1.352   8.906  23.804  1.00 29.44           O  
ATOM    428  CB  THR A  58       0.731   8.400  20.589  1.00 28.64           C  
ATOM    429  OG1 THR A  58       0.486   9.210  19.430  1.00 28.09           O  
ATOM    430  CG2 THR A  58      -0.608   8.175  21.345  1.00 28.43           C  
ATOM    431  N   ILE A  59       2.684   7.379  22.931  1.00 29.60           N  
ATOM    432  CA  ILE A  59       2.861   6.660  24.202  1.00 30.18           C  
ATOM    433  C   ILE A  59       3.453   7.578  25.285  1.00 29.92           C  
ATOM    434  O   ILE A  59       2.940   7.650  26.417  1.00 29.78           O  
ATOM    435  CB  ILE A  59       3.696   5.386  23.977  1.00 30.43           C  
ATOM    436  CG1 ILE A  59       2.854   4.350  23.221  1.00 31.47           C  
ATOM    437  CG2 ILE A  59       4.198   4.779  25.285  1.00 32.08           C  
ATOM    438  CD1 ILE A  59       3.679   3.254  22.595  1.00 33.45           C  
ATOM    439  N   ASP A  60       4.513   8.314  24.940  1.00 29.12           N  
ATOM    440  CA  ASP A  60       5.087   9.280  25.888  1.00 28.23           C  
ATOM    441  C   ASP A  60       4.070  10.295  26.391  1.00 27.95           C  
ATOM    442  O   ASP A  60       3.955  10.508  27.602  1.00 28.04           O  
ATOM    443  CB  ASP A  60       6.272  10.023  25.280  1.00 27.92           C  
ATOM    444  CG  ASP A  60       7.439   9.119  24.996  1.00 28.14           C  
ATOM    445  OD1 ASP A  60       7.436   7.969  25.481  1.00 28.28           O  
ATOM    446  OD2 ASP A  60       8.364   9.567  24.284  1.00 29.31           O  
ATOM    447  N   PHE A  61       3.336  10.919  25.470  1.00 27.64           N  
ATOM    448  CA  PHE A  61       2.462  12.039  25.835  1.00 28.03           C  
ATOM    449  C   PHE A  61       1.218  11.617  26.611  1.00 28.76           C  
ATOM    450  O   PHE A  61       0.640  12.429  27.351  1.00 28.59           O  
ATOM    451  CB  PHE A  61       2.060  12.861  24.616  1.00 27.63           C  
ATOM    452  CG  PHE A  61       3.199  13.681  24.016  1.00 27.29           C  
ATOM    453  CD1 PHE A  61       3.970  14.524  24.807  1.00 25.66           C  
ATOM    454  CD2 PHE A  61       3.472  13.610  22.654  1.00 27.12           C  
ATOM    455  CE1 PHE A  61       5.007  15.294  24.249  1.00 25.03           C  
ATOM    456  CE2 PHE A  61       4.501  14.379  22.081  1.00 25.33           C  
ATOM    457  CZ  PHE A  61       5.274  15.217  22.889  1.00 24.85           C  
ATOM    458  N   LEU A  62       0.818  10.360  26.426  1.00 29.69           N  
ATOM    459  CA  LEU A  62      -0.283   9.776  27.197  1.00 30.59           C  
ATOM    460  C   LEU A  62       0.034   9.697  28.669  1.00 30.98           C  
ATOM    461  O   LEU A  62      -0.875   9.721  29.489  1.00 32.00           O  
ATOM    462  CB  LEU A  62      -0.661   8.396  26.667  1.00 30.64           C  
ATOM    463  CG  LEU A  62      -1.442   8.444  25.347  1.00 31.21           C  
ATOM    464  CD1 LEU A  62      -1.811   7.064  24.905  1.00 31.44           C  
ATOM    465  CD2 LEU A  62      -2.662   9.328  25.435  1.00 32.84           C  
ATOM    466  N   SER A  63       1.316   9.609  29.015  1.00 31.07           N  
ATOM    467  CA  SER A  63       1.696   9.577  30.420  1.00 31.66           C  
ATOM    468  C   SER A  63       2.414  10.837  30.920  1.00 31.29           C  
ATOM    469  O   SER A  63       2.421  11.109  32.118  1.00 30.41           O  
ATOM    470  CB  SER A  63       2.502   8.322  30.728  1.00 32.50           C  
ATOM    471  OG  SER A  63       3.881   8.628  30.760  1.00 37.33           O  
ATOM    472  N   ASN A  64       2.996  11.623  30.007  1.00 29.83           N  
ATOM    473  CA  ASN A  64       3.655  12.857  30.385  1.00 28.75           C  
ATOM    474  C   ASN A  64       3.387  13.897  29.312  1.00 28.31           C  
ATOM    475  O   ASN A  64       3.955  13.802  28.243  1.00 28.41           O  
ATOM    476  CB  ASN A  64       5.168  12.599  30.521  1.00 29.29           C  
ATOM    477  CG  ASN A  64       5.936  13.793  31.083  1.00 28.02           C  
ATOM    478  OD1 ASN A  64       5.422  14.915  31.176  1.00 29.22           O  
ATOM    479  ND2 ASN A  64       7.178  13.551  31.464  1.00 26.26           N  
ATOM    480  N   PRO A  65       2.520  14.892  29.590  1.00 27.86           N  
ATOM    481  CA  PRO A  65       2.187  15.889  28.578  1.00 27.83           C  
ATOM    482  C   PRO A  65       3.264  16.938  28.288  1.00 27.14           C  
ATOM    483  O   PRO A  65       3.118  17.703  27.336  1.00 26.84           O  
ATOM    484  CB  PRO A  65       0.942  16.585  29.157  1.00 28.19           C  
ATOM    485  CG  PRO A  65       1.061  16.421  30.611  1.00 28.76           C  
ATOM    486  CD  PRO A  65       1.817  15.135  30.868  1.00 28.33           C  
ATOM    487  N   LYS A  66       4.315  16.996  29.107  1.00 26.88           N  
ATOM    488  CA  LYS A  66       5.303  18.050  28.978  1.00 25.61           C  
ATOM    489  C   LYS A  66       6.127  17.861  27.709  1.00 24.99           C  
ATOM    490  O   LYS A  66       6.641  16.764  27.445  1.00 24.76           O  
ATOM    491  CB  LYS A  66       6.196  18.113  30.207  1.00 26.40           C  
ATOM    492  CG  LYS A  66       5.479  18.657  31.461  1.00 25.97           C  
ATOM    493  CD  LYS A  66       6.492  18.811  32.630  1.00 27.11           C  
ATOM    494  CE  LYS A  66       5.805  19.420  33.867  1.00 29.72           C  
ATOM    495  NZ  LYS A  66       6.620  19.109  35.080  1.00 33.78           N  
ATOM    496  N   ALA A  67       6.236  18.951  26.948  1.00 24.03           N  
ATOM    497  CA  ALA A  67       6.851  18.929  25.620  1.00 24.39           C  
ATOM    498  C   ALA A  67       7.775  20.112  25.361  1.00 23.95           C  
ATOM    499  O   ALA A  67       7.725  21.138  26.062  1.00 23.90           O  
ATOM    500  CB  ALA A  67       5.737  18.877  24.556  1.00 23.49           C  
ATOM    501  N   GLY A  68       8.621  19.954  24.339  1.00 23.50           N  
ATOM    502  CA  GLY A  68       9.501  21.003  23.860  1.00 23.46           C  
ATOM    503  C   GLY A  68       9.472  20.975  22.340  1.00 23.56           C  
ATOM    504  O   GLY A  68       9.377  19.904  21.731  1.00 23.11           O  
ATOM    505  N   LEU A  69       9.514  22.145  21.728  1.00 22.80           N  
ATOM    506  CA  LEU A  69       9.432  22.251  20.274  1.00 23.90           C  
ATOM    507  C   LEU A  69      10.399  23.336  19.826  1.00 24.19           C  
ATOM    508  O   LEU A  69      10.365  24.422  20.399  1.00 25.38           O  
ATOM    509  CB  LEU A  69       7.992  22.617  19.857  1.00 23.50           C  
ATOM    510  CG  LEU A  69       7.638  22.630  18.358  1.00 25.98           C  
ATOM    511  CD1 LEU A  69       6.173  22.347  18.171  1.00 24.58           C  
ATOM    512  CD2 LEU A  69       8.006  23.946  17.715  1.00 25.22           C  
ATOM    513  N   CYS A  70      11.242  23.060  18.823  1.00 23.22           N  
ATOM    514  CA  CYS A  70      12.082  24.097  18.255  1.00 24.48           C  
ATOM    515  C   CYS A  70      12.016  24.128  16.737  1.00 25.22           C  
ATOM    516  O   CYS A  70      11.555  23.171  16.084  1.00 25.37           O  
ATOM    517  CB  CYS A  70      13.527  24.005  18.755  1.00 24.57           C  
ATOM    518  SG  CYS A  70      14.464  22.562  18.186  1.00 26.16           S  
ATOM    519  N   PHE A  71      12.426  25.257  16.183  1.00 26.31           N  
ATOM    520  CA  PHE A  71      12.453  25.438  14.749  1.00 28.50           C  
ATOM    521  C   PHE A  71      13.522  26.490  14.442  1.00 30.75           C  
ATOM    522  O   PHE A  71      13.914  27.276  15.325  1.00 30.09           O  
ATOM    523  CB  PHE A  71      11.054  25.744  14.168  1.00 27.52           C  
ATOM    524  CG  PHE A  71      10.380  26.946  14.775  1.00 26.83           C  
ATOM    525  CD1 PHE A  71       9.599  26.827  15.933  1.00 25.44           C  
ATOM    526  CD2 PHE A  71      10.493  28.194  14.165  1.00 26.40           C  
ATOM    527  CE1 PHE A  71       8.979  27.944  16.495  1.00 26.00           C  
ATOM    528  CE2 PHE A  71       9.870  29.318  14.712  1.00 24.83           C  
ATOM    529  CZ  PHE A  71       9.129  29.200  15.877  1.00 26.79           C  
ATOM    530  N   GLN A  72      14.040  26.442  13.226  1.00 33.89           N  
ATOM    531  CA  GLN A  72      15.212  27.227  12.863  1.00 37.72           C  
ATOM    532  C   GLN A  72      15.139  27.570  11.400  1.00 38.77           C  
ATOM    533  O   GLN A  72      14.726  26.750  10.560  1.00 38.37           O  
ATOM    534  CB  GLN A  72      16.513  26.463  13.174  1.00 37.69           C  
ATOM    535  CG  GLN A  72      16.722  25.212  12.312  1.00 40.70           C  
ATOM    536  CD  GLN A  72      18.175  24.769  12.208  1.00 41.21           C  
ATOM    537  OE1 GLN A  72      19.021  25.147  13.023  1.00 47.82           O  
ATOM    538  NE2 GLN A  72      18.473  23.951  11.198  1.00 45.53           N  
ATOM    539  N   GLU A  73      15.484  28.815  11.096  1.00 40.68           N  
ATOM    540  CA  GLU A  73      15.749  29.194   9.723  1.00 42.84           C  
ATOM    541  C   GLU A  73      16.806  30.288   9.708  1.00 43.53           C  
ATOM    542  O   GLU A  73      16.583  31.393  10.215  1.00 44.24           O  
ATOM    543  CB  GLU A  73      14.478  29.612   8.991  1.00 43.36           C  
ATOM    544  CG  GLU A  73      14.419  29.085   7.551  1.00 46.29           C  
ATOM    545  CD  GLU A  73      12.996  28.939   7.033  1.00 50.01           C  
ATOM    546  OE1 GLU A  73      12.489  29.914   6.444  1.00 51.86           O  
ATOM    547  OE2 GLU A  73      12.397  27.844   7.200  1.00 51.79           O  
ATOM    548  N   LYS A  74      17.976  29.926   9.184  1.00 44.19           N  
ATOM    549  CA  LYS A  74      19.056  30.869   8.870  1.00 44.25           C  
ATOM    550  C   LYS A  74      19.691  31.549  10.088  1.00 43.68           C  
ATOM    551  O   LYS A  74      19.664  32.767  10.207  1.00 44.41           O  
ATOM    552  CB  LYS A  74      18.574  31.910   7.845  1.00 44.71           C  
ATOM    553  CG  LYS A  74      18.532  31.399   6.402  1.00 44.99           C  
ATOM    554  CD  LYS A  74      17.894  32.415   5.448  1.00 44.74           C  
ATOM    555  CE  LYS A  74      18.919  33.357   4.800  1.00 44.94           C  
ATOM    556  NZ  LYS A  74      19.395  34.500   5.665  1.00 43.23           N  
ATOM    557  N   GLY A  75      20.269  30.755  10.986  1.00 42.26           N  
ATOM    558  CA  GLY A  75      20.898  31.299  12.189  1.00 40.71           C  
ATOM    559  C   GLY A  75      19.927  31.765  13.257  1.00 38.97           C  
ATOM    560  O   GLY A  75      20.319  31.975  14.395  1.00 40.00           O  
ATOM    561  N   ASP A  76      18.660  31.927  12.885  1.00 37.38           N  
ATOM    562  CA  ASP A  76      17.598  32.296  13.824  1.00 35.11           C  
ATOM    563  C   ASP A  76      16.873  31.030  14.284  1.00 33.93           C  
ATOM    564  O   ASP A  76      16.422  30.253  13.457  1.00 32.18           O  
ATOM    565  CB  ASP A  76      16.585  33.189  13.106  1.00 34.84           C  
ATOM    566  CG  ASP A  76      17.025  34.642  13.019  1.00 35.27           C  
ATOM    567  OD1 ASP A  76      18.021  35.045  13.677  1.00 34.26           O  
ATOM    568  OD2 ASP A  76      16.324  35.394  12.310  1.00 36.63           O  
ATOM    569  N   SER A  77      16.760  30.834  15.588  1.00 32.41           N  
ATOM    570  CA  SER A  77      16.060  29.669  16.115  1.00 31.97           C  
ATOM    571  C   SER A  77      15.100  30.084  17.213  1.00 31.05           C  
ATOM    572  O   SER A  77      15.286  31.125  17.827  1.00 30.24           O  
ATOM    573  CB  SER A  77      17.060  28.661  16.656  1.00 31.94           C  
ATOM    574  OG  SER A  77      17.621  29.115  17.869  1.00 35.00           O  
ATOM    575  N   VAL A  78      14.070  29.268  17.447  1.00 30.31           N  
ATOM    576  CA  VAL A  78      13.104  29.505  18.515  1.00 29.30           C  
ATOM    577  C   VAL A  78      12.876  28.156  19.196  1.00 29.33           C  
ATOM    578  O   VAL A  78      12.715  27.142  18.509  1.00 27.57           O  
ATOM    579  CB  VAL A  78      11.756  30.027  17.957  1.00 29.15           C  
ATOM    580  CG1 VAL A  78      10.757  30.188  19.070  1.00 29.70           C  
ATOM    581  CG2 VAL A  78      11.922  31.331  17.205  1.00 28.45           C  
ATOM    582  N   ALA A  79      12.918  28.152  20.521  1.00 29.05           N  
ATOM    583  CA  ALA A  79      12.703  26.967  21.311  1.00 29.79           C  
ATOM    584  C   ALA A  79      11.575  27.232  22.279  1.00 30.06           C  
ATOM    585  O   ALA A  79      11.614  28.184  23.059  1.00 30.56           O  
ATOM    586  CB  ALA A  79      13.962  26.546  22.036  1.00 29.95           C  
ATOM    587  N   LEU A  80      10.559  26.379  22.209  1.00 29.66           N  
ATOM    588  CA  LEU A  80       9.316  26.577  22.928  1.00 29.00           C  
ATOM    589  C   LEU A  80       9.174  25.484  23.939  1.00 28.74           C  
ATOM    590  O   LEU A  80       9.635  24.348  23.728  1.00 27.47           O  
ATOM    591  CB  LEU A  80       8.124  26.505  21.949  1.00 28.76           C  
ATOM    592  CG  LEU A  80       7.519  27.737  21.263  1.00 30.41           C  
ATOM    593  CD1 LEU A  80       8.423  28.960  21.149  1.00 31.20           C  
ATOM    594  CD2 LEU A  80       6.908  27.377  19.918  1.00 28.82           C  
HETATM  595  N   MSE A  81       8.562  25.822  25.059  0.50 27.49           N  
HETATM  597  CA  MSE A  81       8.185  24.827  26.035  0.50 26.90           C  
HETATM  599  C   MSE A  81       6.656  24.838  26.118  0.50 27.31           C  
HETATM  601  O   MSE A  81       6.037  25.863  25.854  0.50 27.49           O  
HETATM  603  CB  MSE A  81       8.828  25.151  27.384  0.50 26.74           C  
HETATM  605  CG  MSE A  81       8.183  24.445  28.526  0.50 25.60           C  
HETATM  607 SE   MSE A  81       8.303  25.354  30.244  0.05 24.50          SE  
HETATM  609  CE  MSE A  81      10.081  25.245  30.330  0.50  7.63           C  
ATOM    611  N   GLY A  82       6.057  23.698  26.455  1.00 28.73           N  
ATOM    612  CA  GLY A  82       4.620  23.608  26.614  1.00 27.28           C  
ATOM    613  C   GLY A  82       4.113  22.205  26.837  1.00 27.12           C  
ATOM    614  O   GLY A  82       4.825  21.337  27.355  1.00 26.62           O  
ATOM    615  N   GLU A  83       2.857  21.985  26.469  1.00 26.27           N  
ATOM    616  CA  GLU A  83       2.269  20.678  26.635  1.00 27.31           C  
ATOM    617  C   GLU A  83       1.641  20.195  25.344  1.00 26.57           C  
ATOM    618  O   GLU A  83       1.217  21.007  24.531  1.00 26.48           O  
ATOM    619  CB  GLU A  83       1.239  20.680  27.773  1.00 28.10           C  
ATOM    620  CG  GLU A  83       1.895  20.575  29.165  1.00 32.56           C  
ATOM    621  CD  GLU A  83       2.159  21.918  29.812  1.00 39.42           C  
ATOM    622  OE1 GLU A  83       1.722  22.940  29.239  1.00 43.72           O  
ATOM    623  OE2 GLU A  83       2.791  21.958  30.903  1.00 41.28           O  
ATOM    624  N   VAL A  84       1.619  18.874  25.177  1.00 26.60           N  
ATOM    625  CA  VAL A  84       0.916  18.216  24.067  1.00 26.93           C  
ATOM    626  C   VAL A  84      -0.321  17.466  24.558  1.00 27.94           C  
ATOM    627  O   VAL A  84      -0.260  16.687  25.528  1.00 28.99           O  
ATOM    628  CB  VAL A  84       1.848  17.262  23.262  1.00 26.31           C  
ATOM    629  CG1 VAL A  84       1.058  16.296  22.369  1.00 25.14           C  
ATOM    630  CG2 VAL A  84       2.804  18.065  22.388  1.00 27.44           C  
ATOM    631  N   GLU A  85      -1.433  17.720  23.874  1.00 28.12           N  
ATOM    632  CA  GLU A  85      -2.655  16.932  23.972  1.00 29.10           C  
ATOM    633  C   GLU A  85      -2.723  16.008  22.751  1.00 29.68           C  
ATOM    634  O   GLU A  85      -2.491  16.456  21.611  1.00 29.44           O  
ATOM    635  CB  GLU A  85      -3.876  17.858  23.924  1.00 30.42           C  
ATOM    636  CG  GLU A  85      -4.001  18.886  25.048  1.00 34.12           C  
ATOM    637  CD  GLU A  85      -4.754  20.157  24.611  1.00 42.58           C  
ATOM    638  OE1 GLU A  85      -5.164  20.234  23.431  1.00 48.24           O  
ATOM    639  OE2 GLU A  85      -4.943  21.085  25.439  1.00 45.03           O  
ATOM    640  N   VAL A  86      -3.009  14.730  22.973  1.00 29.12           N  
ATOM    641  CA  VAL A  86      -3.271  13.800  21.873  1.00 29.77           C  
ATOM    642  C   VAL A  86      -4.737  13.994  21.503  1.00 30.84           C  
ATOM    643  O   VAL A  86      -5.615  13.847  22.367  1.00 30.44           O  
ATOM    644  CB  VAL A  86      -3.020  12.320  22.281  1.00 30.09           C  
ATOM    645  CG1 VAL A  86      -3.278  11.396  21.097  1.00 28.74           C  
ATOM    646  CG2 VAL A  86      -1.605  12.124  22.824  1.00 28.24           C  
ATOM    647  N   VAL A  87      -5.012  14.362  20.251  1.00 31.67           N  
ATOM    648  CA  VAL A  87      -6.389  14.636  19.881  1.00 32.92           C  
ATOM    649  C   VAL A  87      -6.939  13.622  18.878  1.00 33.11           C  
ATOM    650  O   VAL A  87      -6.254  13.217  17.943  1.00 31.53           O  
ATOM    651  CB  VAL A  87      -6.730  16.174  19.558  1.00 32.84           C  
ATOM    652  CG1 VAL A  87      -5.641  17.128  20.049  1.00 33.18           C  
ATOM    653  CG2 VAL A  87      -7.140  16.419  18.104  1.00 34.10           C  
ATOM    654  N   THR A  88      -8.164  13.170  19.129  1.00 34.59           N  
ATOM    655  CA  THR A  88      -8.779  12.168  18.263  1.00 35.43           C  
ATOM    656  C   THR A  88     -10.084  12.695  17.685  1.00 36.80           C  
ATOM    657  O   THR A  88     -10.788  11.945  17.009  1.00 37.26           O  
ATOM    658  CB  THR A  88      -9.081  10.849  19.008  1.00 35.59           C  
ATOM    659  OG1 THR A  88      -9.928  11.136  20.112  1.00 32.87           O  
ATOM    660  CG2 THR A  88      -7.816  10.154  19.513  1.00 35.62           C  
ATOM    661  N   ASP A  89     -10.396  13.966  17.968  1.00 37.91           N  
ATOM    662  CA  ASP A  89     -11.585  14.668  17.464  1.00 39.17           C  
ATOM    663  C   ASP A  89     -11.755  14.508  15.941  1.00 39.50           C  
ATOM    664  O   ASP A  89     -10.981  15.068  15.162  1.00 39.04           O  
ATOM    665  CB  ASP A  89     -11.522  16.158  17.860  1.00 39.75           C  
ATOM    666  CG  ASP A  89     -12.627  16.998  17.217  1.00 42.61           C  
ATOM    667  OD1 ASP A  89     -13.425  16.434  16.454  1.00 47.85           O  
ATOM    668  OD2 ASP A  89     -12.717  18.227  17.468  1.00 46.30           O  
ATOM    669  N   GLU A  90     -12.778  13.752  15.533  1.00 39.74           N  
ATOM    670  CA  GLU A  90     -13.059  13.490  14.104  1.00 39.98           C  
ATOM    671  C   GLU A  90     -13.049  14.748  13.229  1.00 38.43           C  
ATOM    672  O   GLU A  90     -12.573  14.721  12.092  1.00 39.02           O  
ATOM    673  CB  GLU A  90     -14.409  12.765  13.938  1.00 39.86           C  
ATOM    674  CG  GLU A  90     -14.460  11.342  14.511  1.00 41.60           C  
ATOM    675  CD  GLU A  90     -15.781  10.623  14.211  1.00 43.44           C  
ATOM    676  OE1 GLU A  90     -16.450  10.980  13.207  1.00 48.97           O  
ATOM    677  OE2 GLU A  90     -16.158   9.698  14.976  1.00 48.49           O  
ATOM    678  N   LYS A  91     -13.595  15.839  13.752  1.00 37.61           N  
ATOM    679  CA  LYS A  91     -13.711  17.099  13.017  1.00 36.82           C  
ATOM    680  C   LYS A  91     -12.343  17.728  12.710  1.00 36.34           C  
ATOM    681  O   LYS A  91     -12.132  18.321  11.637  1.00 35.72           O  
ATOM    682  CB  LYS A  91     -14.551  18.092  13.820  1.00 36.63           C  
ATOM    683  CG  LYS A  91     -14.696  19.454  13.158  1.00 36.74           C  
ATOM    684  CD  LYS A  91     -15.429  20.447  14.044  1.00 37.61           C  
ATOM    685  CE  LYS A  91     -15.472  21.799  13.363  1.00 40.12           C  
ATOM    686  NZ  LYS A  91     -16.279  22.799  14.126  1.00 42.80           N  
ATOM    687  N   LEU A  92     -11.442  17.633  13.683  1.00 35.18           N  
ATOM    688  CA  LEU A  92     -10.108  18.168  13.524  1.00 34.32           C  
ATOM    689  C   LEU A  92      -9.287  17.232  12.653  1.00 33.83           C  
ATOM    690  O   LEU A  92      -8.582  17.709  11.780  1.00 33.82           O  
ATOM    691  CB  LEU A  92      -9.442  18.464  14.876  1.00 34.27           C  
ATOM    692  CG  LEU A  92     -10.007  19.678  15.652  1.00 34.62           C  
ATOM    693  CD1 LEU A  92      -9.334  19.837  17.013  1.00 36.61           C  
ATOM    694  CD2 LEU A  92      -9.915  20.986  14.871  1.00 35.97           C  
ATOM    695  N   LYS A  93      -9.412  15.916  12.868  1.00 33.03           N  
ATOM    696  CA  LYS A  93      -8.784  14.906  11.998  1.00 33.17           C  
ATOM    697  C   LYS A  93      -9.064  15.140  10.523  1.00 33.46           C  
ATOM    698  O   LYS A  93      -8.160  15.026   9.671  1.00 33.14           O  
ATOM    699  CB  LYS A  93      -9.217  13.482  12.394  1.00 32.91           C  
ATOM    700  CG  LYS A  93      -8.548  12.956  13.653  1.00 32.33           C  
ATOM    701  CD  LYS A  93      -9.083  11.591  14.083  1.00 32.97           C  
ATOM    702  CE  LYS A  93      -8.750  10.500  13.054  1.00 31.61           C  
ATOM    703  NZ  LYS A  93      -8.925   9.097  13.565  1.00 33.10           N  
ATOM    704  N   GLN A  94     -10.307  15.479  10.204  0.50 33.60           N  
ATOM    706  CA  GLN A  94     -10.683  15.690   8.809  0.50 33.63           C  
ATOM    708  C   GLN A  94     -10.292  17.079   8.308  0.50 33.81           C  
ATOM    710  O   GLN A  94      -9.879  17.223   7.166  0.50 33.89           O  
ATOM    712  CB  GLN A  94     -12.169  15.397   8.586  0.50 33.67           C  
ATOM    714  CG  GLN A  94     -12.529  13.934   8.843  0.50 32.87           C  
ATOM    716  CD  GLN A  94     -13.238  13.291   7.667  0.50 31.96           C  
ATOM    718  OE1 GLN A  94     -13.089  13.724   6.523  0.50 32.37           O  
ATOM    720  NE2 GLN A  94     -13.998  12.246   7.937  0.50 31.06           N  
ATOM    722  N   GLU A  95     -10.392  18.094   9.163  1.00 34.21           N  
ATOM    723  CA  GLU A  95      -9.939  19.446   8.787  1.00 35.06           C  
ATOM    724  C   GLU A  95      -8.417  19.557   8.577  1.00 34.21           C  
ATOM    725  O   GLU A  95      -7.951  20.323   7.723  1.00 33.73           O  
ATOM    726  CB  GLU A  95     -10.399  20.471   9.816  1.00 35.69           C  
ATOM    727  CG  GLU A  95     -11.848  20.898   9.614  1.00 37.89           C  
ATOM    728  CD  GLU A  95     -12.407  21.736  10.770  1.00 38.60           C  
ATOM    729  OE1 GLU A  95     -11.819  21.747  11.888  1.00 42.92           O  
ATOM    730  OE2 GLU A  95     -13.450  22.389  10.544  1.00 43.73           O  
ATOM    731  N   LEU A  96      -7.655  18.772   9.332  1.00 32.61           N  
ATOM    732  CA  LEU A  96      -6.193  18.887   9.288  1.00 32.48           C  
ATOM    733  C   LEU A  96      -5.516  17.846   8.396  1.00 31.98           C  
ATOM    734  O   LEU A  96      -4.282  17.849   8.242  1.00 31.51           O  
ATOM    735  CB  LEU A  96      -5.602  18.894  10.711  1.00 31.64           C  
ATOM    736  CG  LEU A  96      -6.007  20.127  11.537  1.00 33.14           C  
ATOM    737  CD1 LEU A  96      -5.367  20.110  12.939  1.00 32.04           C  
ATOM    738  CD2 LEU A  96      -5.692  21.441  10.843  1.00 35.52           C  
ATOM    739  N   TRP A  97      -6.338  16.991   7.783  1.00 30.59           N  
ATOM    740  CA  TRP A  97      -5.850  15.962   6.882  1.00 30.03           C  
ATOM    741  C   TRP A  97      -5.100  16.599   5.712  1.00 29.59           C  
ATOM    742  O   TRP A  97      -5.556  17.592   5.128  1.00 29.46           O  
ATOM    743  CB  TRP A  97      -7.042  15.128   6.385  1.00 30.01           C  
ATOM    744  CG  TRP A  97      -6.683  14.122   5.382  1.00 28.55           C  
ATOM    745  CD1 TRP A  97      -6.710  14.273   4.028  1.00 29.46           C  
ATOM    746  CD2 TRP A  97      -6.268  12.782   5.632  1.00 28.44           C  
ATOM    747  NE1 TRP A  97      -6.302  13.122   3.417  1.00 29.63           N  
ATOM    748  CE2 TRP A  97      -6.025  12.183   4.378  1.00 28.84           C  
ATOM    749  CE3 TRP A  97      -6.032  12.042   6.794  1.00 27.87           C  
ATOM    750  CZ2 TRP A  97      -5.577  10.877   4.251  1.00 29.44           C  
ATOM    751  CZ3 TRP A  97      -5.601  10.737   6.673  1.00 29.31           C  
ATOM    752  CH2 TRP A  97      -5.377  10.163   5.412  1.00 30.84           C  
ATOM    753  N   GLN A  98      -3.941  16.026   5.394  1.00 29.61           N  
ATOM    754  CA  GLN A  98      -3.125  16.448   4.254  1.00 29.77           C  
ATOM    755  C   GLN A  98      -3.039  15.279   3.310  1.00 29.31           C  
ATOM    756  O   GLN A  98      -3.067  14.149   3.760  1.00 28.74           O  
ATOM    757  CB  GLN A  98      -1.704  16.842   4.702  1.00 30.06           C  
ATOM    758  CG  GLN A  98      -1.667  17.878   5.834  1.00 30.86           C  
ATOM    759  CD  GLN A  98      -2.398  19.146   5.464  1.00 33.13           C  
ATOM    760  OE1 GLN A  98      -2.186  19.697   4.388  1.00 37.30           O  
ATOM    761  NE2 GLN A  98      -3.279  19.614   6.348  1.00 34.82           N  
ATOM    762  N   ASP A  99      -2.892  15.544   2.012  1.00 29.47           N  
ATOM    763  CA  ASP A  99      -2.782  14.467   1.029  1.00 30.35           C  
ATOM    764  C   ASP A  99      -1.675  13.490   1.337  1.00 30.86           C  
ATOM    765  O   ASP A  99      -1.831  12.295   1.110  1.00 31.14           O  
ATOM    766  CB  ASP A  99      -2.565  15.022  -0.377  1.00 30.54           C  
ATOM    767  CG  ASP A  99      -3.728  15.870  -0.854  1.00 31.02           C  
ATOM    768  OD1 ASP A  99      -4.817  15.733  -0.264  1.00 32.43           O  
ATOM    769  OD2 ASP A  99      -3.552  16.664  -1.810  1.00 32.43           O  
ATOM    770  N   TRP A 100      -0.546  13.997   1.840  1.00 31.23           N  
ATOM    771  CA  TRP A 100       0.612  13.139   2.070  1.00 31.15           C  
ATOM    772  C   TRP A 100       0.385  12.181   3.251  1.00 30.63           C  
ATOM    773  O   TRP A 100       1.158  11.224   3.450  1.00 30.48           O  
ATOM    774  CB  TRP A 100       1.900  13.976   2.217  1.00 32.45           C  
ATOM    775  CG  TRP A 100       1.972  14.830   3.458  1.00 33.05           C  
ATOM    776  CD1 TRP A 100       1.612  16.145   3.583  1.00 34.24           C  
ATOM    777  CD2 TRP A 100       2.456  14.423   4.738  1.00 34.77           C  
ATOM    778  NE1 TRP A 100       1.826  16.575   4.877  1.00 34.66           N  
ATOM    779  CE2 TRP A 100       2.351  15.540   5.602  1.00 34.07           C  
ATOM    780  CE3 TRP A 100       2.989  13.222   5.237  1.00 33.72           C  
ATOM    781  CZ2 TRP A 100       2.755  15.494   6.935  1.00 34.65           C  
ATOM    782  CZ3 TRP A 100       3.363  13.172   6.576  1.00 35.15           C  
ATOM    783  CH2 TRP A 100       3.256  14.307   7.406  1.00 34.74           C  
ATOM    784  N   PHE A 101      -0.693  12.411   3.998  1.00 30.81           N  
ATOM    785  CA  PHE A 101      -1.132  11.479   5.070  1.00 31.25           C  
ATOM    786  C   PHE A 101      -1.534  10.096   4.558  1.00 32.05           C  
ATOM    787  O   PHE A 101      -1.573   9.137   5.336  1.00 32.58           O  
ATOM    788  CB  PHE A 101      -2.318  12.044   5.847  1.00 31.31           C  
ATOM    789  CG  PHE A 101      -1.977  13.172   6.802  1.00 30.82           C  
ATOM    790  CD1 PHE A 101      -0.754  13.838   6.740  1.00 32.17           C  
ATOM    791  CD2 PHE A 101      -2.930  13.601   7.725  1.00 30.17           C  
ATOM    792  CE1 PHE A 101      -0.473  14.876   7.625  1.00 31.73           C  
ATOM    793  CE2 PHE A 101      -2.684  14.644   8.578  1.00 30.96           C  
ATOM    794  CZ  PHE A 101      -1.440  15.289   8.533  1.00 31.77           C  
ATOM    795  N   ILE A 102      -1.845   9.986   3.263  1.00 32.23           N  
ATOM    796  CA  ILE A 102      -2.330   8.709   2.722  1.00 32.44           C  
ATOM    797  C   ILE A 102      -1.292   7.606   2.875  1.00 33.76           C  
ATOM    798  O   ILE A 102      -1.621   6.495   3.264  1.00 33.03           O  
ATOM    799  CB  ILE A 102      -2.781   8.793   1.240  1.00 32.57           C  
ATOM    800  CG1 ILE A 102      -3.987   9.733   1.080  1.00 28.73           C  
ATOM    801  CG2 ILE A 102      -3.181   7.389   0.753  1.00 30.20           C  
ATOM    802  CD1 ILE A 102      -4.219  10.168  -0.358  1.00 30.12           C  
ATOM    803  N   GLU A 103      -0.044   7.934   2.561  1.00 35.93           N  
ATOM    804  CA  GLU A 103       1.100   7.039   2.764  1.00 38.25           C  
ATOM    805  C   GLU A 103       1.226   6.472   4.182  1.00 39.21           C  
ATOM    806  O   GLU A 103       1.828   5.410   4.358  1.00 39.77           O  
ATOM    807  CB  GLU A 103       2.392   7.801   2.453  1.00 38.92           C  
ATOM    808  CG  GLU A 103       3.000   7.496   1.107  1.00 42.11           C  
ATOM    809  CD  GLU A 103       3.831   6.215   1.090  1.00 44.44           C  
ATOM    810  OE1 GLU A 103       4.521   5.914   2.093  1.00 47.17           O  
ATOM    811  OE2 GLU A 103       3.817   5.524   0.052  1.00 45.21           O  
ATOM    812  N   HIS A 104       0.687   7.195   5.177  1.00 39.49           N  
ATOM    813  CA  HIS A 104       0.838   6.852   6.600  1.00 40.17           C  
ATOM    814  C   HIS A 104      -0.431   6.319   7.229  1.00 39.69           C  
ATOM    815  O   HIS A 104      -0.364   5.476   8.107  1.00 40.45           O  
ATOM    816  CB  HIS A 104       1.291   8.075   7.415  1.00 40.48           C  
ATOM    817  CG  HIS A 104       2.617   8.629   7.000  1.00 42.80           C  
ATOM    818  ND1 HIS A 104       2.744   9.650   6.080  1.00 44.38           N  
ATOM    819  CD2 HIS A 104       3.876   8.319   7.392  1.00 42.69           C  
ATOM    820  CE1 HIS A 104       4.024   9.936   5.918  1.00 44.86           C  
ATOM    821  NE2 HIS A 104       4.731   9.145   6.706  1.00 44.57           N  
ATOM    822  N   PHE A 105      -1.583   6.831   6.796  1.00 39.42           N  
ATOM    823  CA  PHE A 105      -2.874   6.415   7.330  1.00 38.43           C  
ATOM    824  C   PHE A 105      -3.788   5.967   6.198  1.00 37.78           C  
ATOM    825  O   PHE A 105      -4.627   6.744   5.742  1.00 37.21           O  
ATOM    826  CB  PHE A 105      -3.532   7.545   8.126  1.00 38.22           C  
ATOM    827  CG  PHE A 105      -2.588   8.251   9.075  1.00 39.31           C  
ATOM    828  CD1 PHE A 105      -2.371   9.622   8.960  1.00 37.97           C  
ATOM    829  CD2 PHE A 105      -1.902   7.535  10.059  1.00 39.95           C  
ATOM    830  CE1 PHE A 105      -1.481  10.290   9.825  1.00 39.99           C  
ATOM    831  CE2 PHE A 105      -1.008   8.188  10.925  1.00 40.93           C  
ATOM    832  CZ  PHE A 105      -0.807   9.576  10.805  1.00 38.93           C  
ATOM    833  N   PRO A 106      -3.650   4.696   5.767  1.00 38.28           N  
ATOM    834  CA  PRO A 106      -4.345   4.186   4.568  1.00 37.94           C  
ATOM    835  C   PRO A 106      -5.881   4.182   4.652  1.00 38.00           C  
ATOM    836  O   PRO A 106      -6.551   3.986   3.625  1.00 37.78           O  
ATOM    837  CB  PRO A 106      -3.813   2.748   4.419  1.00 38.35           C  
ATOM    838  CG  PRO A 106      -2.590   2.664   5.348  1.00 38.62           C  
ATOM    839  CD  PRO A 106      -2.849   3.644   6.435  1.00 37.78           C  
ATOM    840  N   GLY A 107      -6.433   4.405   5.844  1.00 37.11           N  
ATOM    841  CA  GLY A 107      -7.883   4.438   6.027  1.00 36.83           C  
ATOM    842  C   GLY A 107      -8.512   5.780   5.725  1.00 36.61           C  
ATOM    843  O   GLY A 107      -9.735   5.920   5.750  1.00 36.31           O  
ATOM    844  N   GLY A 108      -7.673   6.770   5.425  1.00 36.66           N  
ATOM    845  CA  GLY A 108      -8.137   8.149   5.246  1.00 37.34           C  
ATOM    846  C   GLY A 108      -8.343   8.899   6.564  1.00 37.58           C  
ATOM    847  O   GLY A 108      -7.925   8.420   7.619  1.00 37.38           O  
ATOM    848  N   PRO A 109      -8.992  10.078   6.505  1.00 37.46           N  
ATOM    849  CA  PRO A 109      -9.183  10.978   7.649  1.00 38.02           C  
ATOM    850  C   PRO A 109      -9.973  10.365   8.799  1.00 38.51           C  
ATOM    851  O   PRO A 109     -10.081  10.965   9.882  1.00 38.95           O  
ATOM    852  CB  PRO A 109      -9.940  12.162   7.049  1.00 38.21           C  
ATOM    853  CG  PRO A 109     -10.461  11.708   5.743  1.00 37.57           C  
ATOM    854  CD  PRO A 109      -9.554  10.638   5.265  1.00 37.94           C  
ATOM    855  N   THR A 110     -10.476   9.162   8.563  1.00 38.19           N  
ATOM    856  CA  THR A 110     -11.310   8.451   9.505  1.00 38.07           C  
ATOM    857  C   THR A 110     -10.527   7.284  10.149  1.00 37.70           C  
ATOM    858  O   THR A 110     -10.995   6.659  11.119  1.00 38.23           O  
ATOM    859  CB  THR A 110     -12.618   7.992   8.753  1.00 38.06           C  
ATOM    860  OG1 THR A 110     -13.750   8.104   9.613  1.00 39.85           O  
ATOM    861  CG2 THR A 110     -12.488   6.604   8.187  1.00 37.40           C  
ATOM    862  N   ASP A 111      -9.324   7.022   9.619  1.00 36.91           N  
ATOM    863  CA  ASP A 111      -8.423   5.954  10.076  1.00 36.56           C  
ATOM    864  C   ASP A 111      -8.235   6.010  11.599  1.00 36.53           C  
ATOM    865  O   ASP A 111      -7.870   7.067  12.142  1.00 35.87           O  
ATOM    866  CB  ASP A 111      -7.057   6.103   9.372  1.00 36.68           C  
ATOM    867  CG  ASP A 111      -6.172   4.875   9.505  1.00 36.69           C  
ATOM    868  OD1 ASP A 111      -6.019   4.330  10.615  1.00 38.61           O  
ATOM    869  OD2 ASP A 111      -5.588   4.462   8.486  1.00 38.66           O  
ATOM    870  N   PRO A 112      -8.466   4.872  12.291  1.00 36.55           N  
ATOM    871  CA  PRO A 112      -8.362   4.842  13.761  1.00 36.57           C  
ATOM    872  C   PRO A 112      -6.913   4.963  14.193  1.00 36.05           C  
ATOM    873  O   PRO A 112      -6.633   5.306  15.337  1.00 37.44           O  
ATOM    874  CB  PRO A 112      -8.878   3.440  14.127  1.00 36.29           C  
ATOM    875  CG  PRO A 112      -9.533   2.904  12.892  1.00 37.01           C  
ATOM    876  CD  PRO A 112      -8.808   3.541  11.749  1.00 36.98           C  
ATOM    877  N   GLY A 113      -5.997   4.665  13.278  1.00 35.63           N  
ATOM    878  CA  GLY A 113      -4.573   4.815  13.532  1.00 34.87           C  
ATOM    879  C   GLY A 113      -4.077   6.253  13.468  1.00 34.69           C  
ATOM    880  O   GLY A 113      -2.912   6.502  13.788  1.00 34.76           O  
ATOM    881  N   TYR A 114      -4.958   7.188  13.079  1.00 33.83           N  
ATOM    882  CA  TYR A 114      -4.583   8.597  12.811  1.00 33.48           C  
ATOM    883  C   TYR A 114      -4.946   9.536  13.973  1.00 33.24           C  
ATOM    884  O   TYR A 114      -6.109   9.698  14.336  1.00 33.21           O  
ATOM    885  CB  TYR A 114      -5.160   9.067  11.455  1.00 32.80           C  
ATOM    886  CG  TYR A 114      -5.298  10.574  11.216  1.00 32.39           C  
ATOM    887  CD1 TYR A 114      -4.322  11.497  11.653  1.00 31.41           C  
ATOM    888  CD2 TYR A 114      -6.386  11.068  10.502  1.00 31.59           C  
ATOM    889  CE1 TYR A 114      -4.469  12.876  11.416  1.00 30.04           C  
ATOM    890  CE2 TYR A 114      -6.534  12.419  10.258  1.00 32.10           C  
ATOM    891  CZ  TYR A 114      -5.575  13.323  10.721  1.00 32.36           C  
ATOM    892  OH  TYR A 114      -5.761  14.665  10.456  1.00 32.65           O  
ATOM    893  N   VAL A 115      -3.912  10.159  14.540  1.00 32.66           N  
ATOM    894  CA  VAL A 115      -4.025  10.978  15.739  1.00 32.27           C  
ATOM    895  C   VAL A 115      -3.355  12.330  15.491  1.00 30.76           C  
ATOM    896  O   VAL A 115      -2.381  12.400  14.722  1.00 30.63           O  
ATOM    897  CB  VAL A 115      -3.331  10.195  16.892  1.00 32.96           C  
ATOM    898  CG1 VAL A 115      -2.563  11.090  17.839  1.00 33.06           C  
ATOM    899  CG2 VAL A 115      -4.339   9.273  17.585  1.00 34.02           C  
ATOM    900  N   LEU A 116      -3.895  13.390  16.089  1.00 29.38           N  
ATOM    901  CA  LEU A 116      -3.259  14.705  16.047  1.00 28.94           C  
ATOM    902  C   LEU A 116      -2.558  15.041  17.370  1.00 28.66           C  
ATOM    903  O   LEU A 116      -2.969  14.590  18.448  1.00 27.86           O  
ATOM    904  CB  LEU A 116      -4.245  15.812  15.698  1.00 28.91           C  
ATOM    905  CG  LEU A 116      -4.896  15.688  14.316  1.00 29.28           C  
ATOM    906  CD1 LEU A 116      -6.163  16.453  14.281  1.00 28.17           C  
ATOM    907  CD2 LEU A 116      -3.919  16.210  13.282  1.00 31.05           C  
ATOM    908  N   LEU A 117      -1.483  15.817  17.259  1.00 27.65           N  
ATOM    909  CA  LEU A 117      -0.786  16.324  18.443  1.00 26.91           C  
ATOM    910  C   LEU A 117      -0.913  17.837  18.471  1.00 27.08           C  
ATOM    911  O   LEU A 117      -0.458  18.540  17.558  1.00 26.35           O  
ATOM    912  CB  LEU A 117       0.682  15.878  18.463  1.00 26.77           C  
ATOM    913  CG  LEU A 117       1.016  14.388  18.370  1.00 26.08           C  
ATOM    914  CD1 LEU A 117       2.547  14.137  18.248  1.00 24.85           C  
ATOM    915  CD2 LEU A 117       0.426  13.566  19.556  1.00 24.86           C  
ATOM    916  N   LYS A 118      -1.581  18.336  19.507  1.00 26.61           N  
ATOM    917  CA  LYS A 118      -1.739  19.772  19.691  1.00 27.11           C  
ATOM    918  C   LYS A 118      -0.722  20.238  20.724  1.00 26.57           C  
ATOM    919  O   LYS A 118      -0.842  19.895  21.891  1.00 27.52           O  
ATOM    920  CB  LYS A 118      -3.157  20.090  20.208  1.00 26.30           C  
ATOM    921  CG  LYS A 118      -3.444  21.593  20.342  1.00 26.74           C  
ATOM    922  CD  LYS A 118      -4.892  21.849  20.726  1.00 28.64           C  
ATOM    923  CE  LYS A 118      -5.177  23.305  20.949  1.00 31.80           C  
ATOM    924  NZ  LYS A 118      -6.493  23.499  21.645  1.00 34.24           N  
ATOM    925  N   PHE A 119       0.262  21.022  20.295  1.00 26.67           N  
ATOM    926  CA  PHE A 119       1.263  21.589  21.197  1.00 26.21           C  
ATOM    927  C   PHE A 119       0.829  22.986  21.595  1.00 26.88           C  
ATOM    928  O   PHE A 119       0.598  23.831  20.727  1.00 27.46           O  
ATOM    929  CB  PHE A 119       2.623  21.665  20.483  1.00 25.21           C  
ATOM    930  CG  PHE A 119       3.723  22.324  21.304  1.00 24.33           C  
ATOM    931  CD1 PHE A 119       4.542  21.561  22.153  1.00 22.84           C  
ATOM    932  CD2 PHE A 119       3.925  23.691  21.226  1.00 22.62           C  
ATOM    933  CE1 PHE A 119       5.581  22.169  22.903  1.00 23.49           C  
ATOM    934  CE2 PHE A 119       4.956  24.323  21.991  1.00 24.02           C  
ATOM    935  CZ  PHE A 119       5.774  23.556  22.821  1.00 23.03           C  
ATOM    936  N   THR A 120       0.743  23.232  22.900  1.00 27.22           N  
ATOM    937  CA  THR A 120       0.384  24.542  23.437  1.00 27.71           C  
ATOM    938  C   THR A 120       1.565  25.088  24.207  1.00 26.83           C  
ATOM    939  O   THR A 120       2.047  24.433  25.143  1.00 26.29           O  
ATOM    940  CB  THR A 120      -0.867  24.476  24.364  1.00 27.58           C  
ATOM    941  OG1 THR A 120      -1.976  23.958  23.621  1.00 30.00           O  
ATOM    942  CG2 THR A 120      -1.232  25.852  24.871  1.00 29.95           C  
ATOM    943  N   ALA A 121       2.025  26.271  23.794  1.00 26.99           N  
ATOM    944  CA  ALA A 121       3.279  26.841  24.292  1.00 28.39           C  
ATOM    945  C   ALA A 121       3.049  27.607  25.585  1.00 29.24           C  
ATOM    946  O   ALA A 121       2.013  28.243  25.739  1.00 29.40           O  
ATOM    947  CB  ALA A 121       3.872  27.745  23.249  1.00 28.52           C  
ATOM    948  N   ASN A 122       4.012  27.501  26.508  0.50 30.21           N  
ATOM    950  CA  ASN A 122       4.013  28.225  27.791  0.50 31.33           C  
ATOM    952  C   ASN A 122       5.133  29.265  27.863  0.50 31.30           C  
ATOM    954  O   ASN A 122       5.001  30.303  28.523  0.50 31.29           O  
ATOM    956  CB  ASN A 122       4.241  27.248  28.958  0.50 31.74           C  
ATOM    958  CG  ASN A 122       3.057  26.332  29.225  0.50 33.48           C  
ATOM    960  OD1 ASN A 122       3.243  25.188  29.649  0.50 35.39           O  
ATOM    962  ND2 ASN A 122       1.842  26.831  29.020  0.50 35.68           N  
ATOM    964  N   HIS A 123       6.242  28.962  27.192  1.00 30.87           N  
ATOM    965  CA  HIS A 123       7.518  29.652  27.370  1.00 31.59           C  
ATOM    966  C   HIS A 123       8.292  29.625  26.058  1.00 31.72           C  
ATOM    967  O   HIS A 123       8.339  28.595  25.369  1.00 32.31           O  
ATOM    968  CB  HIS A 123       8.336  28.969  28.484  1.00 31.59           C  
ATOM    969  CG  HIS A 123       9.454  29.804  29.026  1.00 35.34           C  
ATOM    970  ND1 HIS A 123       9.329  30.559  30.175  1.00 38.28           N  
ATOM    971  CD2 HIS A 123      10.723  29.993  28.588  1.00 35.47           C  
ATOM    972  CE1 HIS A 123      10.471  31.184  30.413  1.00 37.76           C  
ATOM    973  NE2 HIS A 123      11.331  30.860  29.463  1.00 36.83           N  
ATOM    974  N   ALA A 124       8.883  30.752  25.686  1.00 31.56           N  
ATOM    975  CA  ALA A 124       9.764  30.773  24.524  1.00 31.77           C  
ATOM    976  C   ALA A 124      11.184  31.210  24.878  1.00 32.49           C  
ATOM    977  O   ALA A 124      11.412  32.005  25.820  1.00 32.89           O  
ATOM    978  CB  ALA A 124       9.206  31.645  23.440  1.00 30.96           C  
ATOM    979  N   THR A 125      12.123  30.671  24.113  1.00 32.47           N  
ATOM    980  CA  THR A 125      13.500  31.075  24.112  1.00 33.46           C  
ATOM    981  C   THR A 125      13.796  31.433  22.663  1.00 33.14           C  
ATOM    982  O   THR A 125      13.739  30.576  21.762  1.00 33.07           O  
ATOM    983  CB  THR A 125      14.404  29.947  24.652  1.00 33.61           C  
ATOM    984  OG1 THR A 125      14.017  29.622  25.998  1.00 37.15           O  
ATOM    985  CG2 THR A 125      15.869  30.354  24.632  1.00 35.97           C  
ATOM    986  N   TYR A 126      14.066  32.709  22.423  1.00 32.88           N  
ATOM    987  CA  TYR A 126      14.377  33.192  21.077  1.00 33.46           C  
ATOM    988  C   TYR A 126      15.879  33.413  20.886  1.00 34.61           C  
ATOM    989  O   TYR A 126      16.537  33.988  21.765  1.00 34.29           O  
ATOM    990  CB  TYR A 126      13.653  34.518  20.783  1.00 32.44           C  
ATOM    991  CG  TYR A 126      12.182  34.566  21.141  1.00 32.90           C  
ATOM    992  CD1 TYR A 126      11.203  34.188  20.206  1.00 31.00           C  
ATOM    993  CD2 TYR A 126      11.759  35.008  22.398  1.00 32.36           C  
ATOM    994  CE1 TYR A 126       9.846  34.249  20.514  1.00 29.67           C  
ATOM    995  CE2 TYR A 126      10.390  35.070  22.715  1.00 31.85           C  
ATOM    996  CZ  TYR A 126       9.441  34.689  21.762  1.00 31.92           C  
ATOM    997  OH  TYR A 126       8.084  34.711  22.071  1.00 28.87           O  
ATOM    998  N   TRP A 127      16.402  32.965  19.742  1.00 36.07           N  
ATOM    999  CA  TRP A 127      17.721  33.386  19.232  1.00 37.60           C  
ATOM   1000  C   TRP A 127      17.471  34.073  17.909  1.00 37.11           C  
ATOM   1001  O   TRP A 127      17.513  33.456  16.853  1.00 35.18           O  
ATOM   1002  CB  TRP A 127      18.685  32.200  19.042  1.00 40.32           C  
ATOM   1003  CG  TRP A 127      20.096  32.584  18.558  1.00 43.60           C  
ATOM   1004  CD1 TRP A 127      20.791  33.727  18.870  1.00 44.96           C  
ATOM   1005  CD2 TRP A 127      20.977  31.802  17.719  1.00 46.83           C  
ATOM   1006  NE1 TRP A 127      22.026  33.712  18.266  1.00 46.89           N  
ATOM   1007  CE2 TRP A 127      22.170  32.546  17.558  1.00 46.70           C  
ATOM   1008  CE3 TRP A 127      20.875  30.543  17.095  1.00 47.97           C  
ATOM   1009  CZ2 TRP A 127      23.258  32.080  16.785  1.00 47.06           C  
ATOM   1010  CZ3 TRP A 127      21.963  30.079  16.322  1.00 46.52           C  
ATOM   1011  CH2 TRP A 127      23.136  30.851  16.177  1.00 45.43           C  
ATOM   1012  N   ILE A 128      17.146  35.358  17.969  1.00 36.52           N  
ATOM   1013  CA  ILE A 128      16.902  36.107  16.761  1.00 36.21           C  
ATOM   1014  C   ILE A 128      17.790  37.328  16.839  1.00 36.90           C  
ATOM   1015  O   ILE A 128      18.006  37.869  17.930  1.00 36.75           O  
ATOM   1016  CB  ILE A 128      15.400  36.471  16.608  1.00 36.39           C  
ATOM   1017  CG1 ILE A 128      14.572  35.200  16.388  1.00 35.10           C  
ATOM   1018  CG2 ILE A 128      15.164  37.438  15.455  1.00 36.02           C  
ATOM   1019  CD1 ILE A 128      13.057  35.431  16.337  1.00 35.42           C  
ATOM   1020  N   GLU A 129      18.319  37.730  15.683  1.00 37.78           N  
ATOM   1021  CA  GLU A 129      19.328  38.800  15.573  1.00 38.45           C  
ATOM   1022  C   GLU A 129      20.503  38.595  16.533  1.00 38.59           C  
ATOM   1023  O   GLU A 129      20.926  39.522  17.248  1.00 38.28           O  
ATOM   1024  CB  GLU A 129      18.685  40.182  15.744  1.00 38.72           C  
ATOM   1025  CG  GLU A 129      17.360  40.285  15.038  1.00 41.35           C  
ATOM   1026  CD  GLU A 129      17.172  41.578  14.307  1.00 45.06           C  
ATOM   1027  OE1 GLU A 129      17.817  42.578  14.696  1.00 47.92           O  
ATOM   1028  OE2 GLU A 129      16.378  41.591  13.336  1.00 46.01           O  
ATOM   1029  N   GLY A 130      21.024  37.364  16.528  1.00 38.64           N  
ATOM   1030  CA  GLY A 130      22.108  36.941  17.423  1.00 38.72           C  
ATOM   1031  C   GLY A 130      21.921  37.375  18.865  1.00 38.82           C  
ATOM   1032  O   GLY A 130      22.905  37.610  19.590  1.00 39.58           O  
ATOM   1033  N   THR A 131      20.658  37.494  19.274  1.00 38.05           N  
ATOM   1034  CA  THR A 131      20.296  37.932  20.608  1.00 38.07           C  
ATOM   1035  C   THR A 131      19.390  36.898  21.260  1.00 38.31           C  
ATOM   1036  O   THR A 131      18.387  36.481  20.676  1.00 38.15           O  
ATOM   1037  CB  THR A 131      19.571  39.294  20.557  1.00 38.24           C  
ATOM   1038  OG1 THR A 131      20.318  40.199  19.735  1.00 37.63           O  
ATOM   1039  CG2 THR A 131      19.404  39.878  21.924  1.00 36.91           C  
ATOM   1040  N   PHE A 132      19.748  36.498  22.472  1.00 39.11           N  
ATOM   1041  CA  PHE A 132      18.960  35.552  23.243  1.00 39.73           C  
ATOM   1042  C   PHE A 132      17.947  36.220  24.184  1.00 39.32           C  
ATOM   1043  O   PHE A 132      18.299  37.100  24.964  1.00 39.54           O  
ATOM   1044  CB  PHE A 132      19.880  34.595  24.012  1.00 40.36           C  
ATOM   1045  CG  PHE A 132      20.413  33.445  23.174  1.00 42.46           C  
ATOM   1046  CD1 PHE A 132      21.792  33.230  23.046  1.00 45.58           C  
ATOM   1047  CD2 PHE A 132      19.539  32.571  22.531  1.00 44.29           C  
ATOM   1048  CE1 PHE A 132      22.295  32.150  22.282  1.00 46.63           C  
ATOM   1049  CE2 PHE A 132      20.024  31.478  21.762  1.00 44.96           C  
ATOM   1050  CZ  PHE A 132      21.399  31.275  21.631  1.00 44.97           C  
ATOM   1051  N   ILE A 133      16.685  35.791  24.094  1.00 38.52           N  
ATOM   1052  CA  ILE A 133      15.614  36.250  24.998  1.00 38.40           C  
ATOM   1053  C   ILE A 133      14.716  35.094  25.444  1.00 38.53           C  
ATOM   1054  O   ILE A 133      14.321  34.263  24.630  1.00 37.84           O  
ATOM   1055  CB  ILE A 133      14.811  37.425  24.392  1.00 38.19           C  
ATOM   1056  CG1 ILE A 133      15.414  38.744  24.878  1.00 39.93           C  
ATOM   1057  CG2 ILE A 133      13.340  37.385  24.816  1.00 36.91           C  
ATOM   1058  CD1 ILE A 133      15.564  39.743  23.813  1.00 41.13           C  
ATOM   1059  N   HIS A 134      14.429  35.041  26.740  1.00 39.13           N  
ATOM   1060  CA  HIS A 134      13.718  33.925  27.333  1.00 40.28           C  
ATOM   1061  C   HIS A 134      12.498  34.447  28.079  1.00 40.72           C  
ATOM   1062  O   HIS A 134      12.615  34.940  29.223  1.00 41.11           O  
ATOM   1063  CB  HIS A 134      14.620  33.119  28.287  1.00 40.94           C  
ATOM   1064  CG  HIS A 134      16.042  32.962  27.823  1.00 43.49           C  
ATOM   1065  ND1 HIS A 134      17.026  33.887  28.104  1.00 46.24           N  
ATOM   1066  CD2 HIS A 134      16.651  31.969  27.129  1.00 45.55           C  
ATOM   1067  CE1 HIS A 134      18.175  33.482  27.585  1.00 46.43           C  
ATOM   1068  NE2 HIS A 134      17.975  32.319  26.989  1.00 45.99           N  
ATOM   1069  N   LYS A 135      11.334  34.323  27.433  1.00 40.34           N  
ATOM   1070  CA  LYS A 135      10.061  34.892  27.914  1.00 40.33           C  
ATOM   1071  C   LYS A 135       8.978  33.855  28.222  1.00 40.03           C  
ATOM   1072  O   LYS A 135       8.822  32.882  27.482  1.00 39.47           O  
ATOM   1073  CB  LYS A 135       9.463  35.783  26.822  1.00 40.28           C  
ATOM   1074  CG  LYS A 135       9.941  37.190  26.755  1.00 41.54           C  
ATOM   1075  CD  LYS A 135       9.098  37.978  25.744  1.00 43.97           C  
ATOM   1076  CE  LYS A 135       8.925  37.256  24.362  1.00 42.19           C  
ATOM   1077  NZ  LYS A 135       7.569  36.612  24.057  1.00 36.42           N  
ATOM   1078  N   LYS A 136       8.182  34.106  29.266  1.00 39.36           N  
ATOM   1079  CA  LYS A 136       6.912  33.388  29.478  1.00 39.50           C  
ATOM   1080  C   LYS A 136       5.889  33.785  28.393  1.00 38.77           C  
ATOM   1081  O   LYS A 136       5.871  34.928  27.975  1.00 38.08           O  
ATOM   1082  CB  LYS A 136       6.383  33.704  30.888  1.00 39.73           C  
ATOM   1083  CG  LYS A 136       5.130  32.977  31.314  1.00 41.63           C  
ATOM   1084  CD  LYS A 136       3.929  33.917  31.293  1.00 44.30           C  
ATOM   1085  CE  LYS A 136       2.729  33.292  31.952  1.00 46.71           C  
ATOM   1086  NZ  LYS A 136       1.472  33.957  31.476  1.00 49.28           N  
ATOM   1087  N   LEU A 137       5.071  32.842  27.920  1.00 38.79           N  
ATOM   1088  CA  LEU A 137       4.018  33.155  26.929  1.00 39.30           C  
ATOM   1089  C   LEU A 137       2.618  33.232  27.522  1.00 39.42           C  
ATOM   1090  O   LEU A 137       2.183  32.318  28.226  1.00 40.51           O  
ATOM   1091  CB  LEU A 137       4.021  32.164  25.753  1.00 39.37           C  
ATOM   1092  CG  LEU A 137       5.221  32.154  24.793  1.00 39.65           C  
ATOM   1093  CD1 LEU A 137       4.970  31.111  23.713  1.00 38.60           C  
ATOM   1094  CD2 LEU A 137       5.509  33.522  24.157  1.00 39.30           C  
TER    1095      LEU A 137                                                      
END
MOLECULE T0497.pdb
ATOM      5  N   MET     1      13.726  45.186  17.326  1.00 86.05           N  
ATOM      6  CA  MET     1      13.854  43.790  16.854  1.00 85.86           C  
ATOM      7  C   MET     1      13.936  42.784  18.030  1.00 83.85           C  
ATOM      8  O   MET     1      13.538  41.620  17.875  1.00 83.45           O  
ATOM      9  CB  MET     1      15.056  43.633  15.890  1.00 86.69           C  
ATOM     10  CG  MET     1      16.377  43.182  16.523  1.00 88.68           C  
ATOM     11  SD  MET     1      17.988  43.731  15.614  0.75 92.01          SE  
ATOM     12  CE  MET     1      19.110  42.057  15.901  1.00 88.06           C  
ATOM     13  N   ALA     2      14.466  43.250  19.173  1.00 81.16           N  
ATOM     14  CA  ALA     2      14.590  42.453  20.391  1.00 79.87           C  
ATOM     15  C   ALA     2      13.345  42.445  21.296  1.00 78.34           C  
ATOM     16  O   ALA     2      13.382  41.748  22.306  1.00 77.90           O  
ATOM     17  CB  ALA     2      15.820  42.896  21.195  1.00 79.19           C  
ATOM     18  N   ASP     3      12.264  43.181  20.962  1.00 78.03           N  
ATOM     19  CA  ASP     3      11.048  43.193  21.798  0.50 77.68           C  
ATOM     21  C   ASP     3      10.259  41.889  21.613  1.00 78.01           C  
ATOM     22  O   ASP     3      10.343  41.273  20.544  1.00 77.66           O  
ATOM     23  CB  ASP     3      10.174  44.413  21.482  0.50 76.52           C  
ATOM     25  CG  ASP     3      10.832  45.730  21.887  0.50 70.99           C  
ATOM     27  OD1 ASP     3      11.319  45.846  23.031  0.50 59.83           O  
ATOM     29  OD2 ASP     3      10.834  46.662  21.065  0.50 63.66           O  
ATOM     31  N   PRO     4       9.492  41.452  22.649  1.00 78.39           N  
ATOM     32  CA  PRO     4       8.737  40.183  22.525  1.00 78.04           C  
ATOM     33  C   PRO     4       7.714  40.059  21.383  1.00 77.52           C  
ATOM     34  O   PRO     4       7.550  38.958  20.872  1.00 78.02           O  
ATOM     35  CB  PRO     4       8.035  40.049  23.895  1.00 77.81           C  
ATOM     36  CG  PRO     4       7.965  41.401  24.410  1.00 79.56           C  
ATOM     37  CD  PRO     4       9.243  42.058  23.973  1.00 78.48           C  
ATOM     38  N   LYS     5       7.054  41.151  20.996  1.00 77.64           N  
ATOM     39  CA  LYS     5       6.046  41.131  19.915  1.00 76.64           C  
ATOM     40  C   LYS     5       6.667  40.855  18.541  1.00 75.44           C  
ATOM     41  O   LYS     5       6.147  40.032  17.799  1.00 74.56           O  
ATOM     42  CB  LYS     5       5.236  42.433  19.904  1.00 77.43           C  
ATOM     43  CG  LYS     5       4.157  42.589  18.809  1.00 78.67           C  
ATOM     44  CD  LYS     5       3.166  41.414  18.745  1.00 83.74           C  
ATOM     45  CE  LYS     5       1.946  41.759  17.884  1.00 85.48           C  
ATOM     46  NZ  LYS     5       2.287  42.297  16.531  1.00 87.86           N  
ATOM     47  N   GLU     6       7.765  41.537  18.211  1.00 74.70           N  
ATOM     48  CA  GLU     6       8.451  41.325  16.925  1.00 74.09           C  
ATOM     49  C   GLU     6       9.058  39.927  16.840  1.00 72.42           C  
ATOM     50  O   GLU     6       9.009  39.306  15.782  1.00 71.12           O  
ATOM     51  CB  GLU     6       9.522  42.390  16.642  1.00 72.75           C  
ATOM     52  CG  GLU     6       8.964  43.783  16.364  1.00 74.88           C  
ATOM     53  N   LEU     7       9.619  39.446  17.952  1.00 71.95           N  
ATOM     54  CA  LEU     7      10.216  38.109  18.022  1.00 71.61           C  
ATOM     55  C   LEU     7       9.159  37.010  17.931  1.00 70.57           C  
ATOM     56  O   LEU     7       9.353  36.020  17.231  1.00 70.00           O  
ATOM     57  CB  LEU     7      11.053  37.939  19.297  1.00 72.48           C  
ATOM     58  CG  LEU     7      12.379  38.701  19.340  1.00 74.29           C  
ATOM     59  CD1 LEU     7      12.939  38.740  20.750  1.00 73.61           C  
ATOM     60  CD2 LEU     7      13.383  38.093  18.346  1.00 73.78           C  
ATOM     61  N   GLN     8       8.053  37.187  18.645  1.00 70.21           N  
ATOM     62  CA  GLN     8       6.950  36.242  18.577  1.00 70.98           C  
ATOM     63  C   GLN     8       6.400  36.178  17.129  1.00 70.04           C  
ATOM     64  O   GLN     8       6.181  35.094  16.610  1.00 69.96           O  
ATOM     65  CB  GLN     8       5.864  36.595  19.612  1.00 70.88           C  
ATOM     66  CG  GLN     8       4.709  35.596  19.639  1.00 74.74           C  
ATOM     67  CD  GLN     8       3.784  35.686  20.860  1.00 74.95           C  
ATOM     68  OE1 GLN     8       2.872  34.845  21.009  1.00 81.07           O  
ATOM     69  NE2 GLN     8       3.997  36.686  21.731  1.00 75.50           N  
ATOM     70  N   ASP     9       6.209  37.341  16.497  1.00 69.03           N  
ATOM     71  CA  ASP     9       5.728  37.442  15.104  1.00 68.39           C  
ATOM     72  C   ASP     9       6.646  36.715  14.117  1.00 67.45           C  
ATOM     73  O   ASP     9       6.150  35.967  13.266  1.00 68.40           O  
ATOM     74  CB  ASP     9       5.538  38.907  14.668  1.00 67.15           C  
ATOM     75  CG  ASP     9       4.327  39.587  15.326  1.00 68.12           C  
ATOM     76  OD1 ASP     9       3.360  38.916  15.752  1.00 66.97           O  
ATOM     77  OD2 ASP     9       4.336  40.835  15.391  1.00 72.15           O  
ATOM     78  N   LYS    10       7.958  36.932  14.238  1.00 65.30           N  
ATOM     79  CA  LYS    10       8.949  36.236  13.400  1.00 66.18           C  
ATOM     80  C   LYS    10       8.919  34.726  13.623  1.00 65.37           C  
ATOM     81  O   LYS    10       9.059  33.953  12.672  1.00 64.60           O  
ATOM     82  CB  LYS    10      10.379  36.717  13.676  1.00 66.97           C  
ATOM     83  CG  LYS    10      10.726  38.076  13.126  1.00 68.25           C  
ATOM     84  CD  LYS    10      12.172  38.403  13.489  1.00 67.43           C  
ATOM     85  CE  LYS    10      12.640  39.737  12.936  1.00 69.89           C  
ATOM     86  NZ  LYS    10      14.068  39.991  13.369  1.00 70.59           N  
ATOM     87  N   PHE    11       8.778  34.325  14.890  1.00 64.73           N  
ATOM     88  CA  PHE    11       8.679  32.908  15.248  1.00 64.13           C  
ATOM     89  C   PHE    11       7.501  32.203  14.554  1.00 62.79           C  
ATOM     90  O   PHE    11       7.703  31.224  13.846  1.00 62.00           O  
ATOM     91  CB  PHE    11       8.606  32.715  16.770  1.00 64.85           C  
ATOM     92  CG  PHE    11       8.128  31.361  17.169  1.00 65.60           C  
ATOM     93  CD1 PHE    11       8.969  30.261  17.035  1.00 65.90           C  
ATOM     94  CD2 PHE    11       6.821  31.171  17.631  1.00 66.31           C  
ATOM     95  CE1 PHE    11       8.527  28.974  17.367  1.00 65.48           C  
ATOM     96  CE2 PHE    11       6.373  29.897  17.971  1.00 65.66           C  
ATOM     97  CZ  PHE    11       7.240  28.793  17.849  1.00 64.98           C  
ATOM     98  N   TRP    12       6.290  32.699  14.786  1.00 62.76           N  
ATOM     99  CA  TRP    12       5.095  32.138  14.164  1.00 64.24           C  
ATOM    100  C   TRP    12       5.156  32.130  12.618  1.00 63.97           C  
ATOM    101  O   TRP    12       4.725  31.157  12.000  1.00 63.92           O  
ATOM    102  CB  TRP    12       3.829  32.863  14.604  1.00 65.03           C  
ATOM    103  CG  TRP    12       3.457  32.681  16.017  1.00 63.68           C  
ATOM    104  CD1 TRP    12       3.341  33.660  16.952  1.00 64.00           C  
ATOM    105  CD2 TRP    12       3.146  31.449  16.675  1.00 67.38           C  
ATOM    106  NE1 TRP    12       2.964  33.122  18.152  1.00 66.48           N  
ATOM    107  CE2 TRP    12       2.850  31.764  18.024  1.00 65.04           C  
ATOM    108  CE3 TRP    12       3.082  30.107  16.261  1.00 64.03           C  
ATOM    109  CZ2 TRP    12       2.478  30.790  18.967  1.00 66.99           C  
ATOM    110  CZ3 TRP    12       2.728  29.129  17.209  1.00 65.28           C  
ATOM    111  CH2 TRP    12       2.427  29.476  18.541  1.00 65.62           C  
ATOM    112  N   LYS    13       5.716  33.185  12.031  1.00 63.71           N  
ATOM    113  CA  LYS    13       5.891  33.272  10.576  1.00 65.47           C  
ATOM    114  C   LYS    13       6.833  32.171  10.061  1.00 64.51           C  
ATOM    115  O   LYS    13       6.554  31.527   9.035  1.00 63.48           O  
ATOM    116  CB  LYS    13       6.437  34.649  10.179  1.00 65.83           C  
ATOM    117  CG  LYS    13       6.467  34.958   8.674  1.00 65.60           C  
ATOM    118  CD  LYS    13       7.293  36.239   8.447  1.00 67.39           C  
ATOM    119  CE  LYS    13       7.540  36.582   6.978  1.00 72.72           C  
ATOM    120  NZ  LYS    13       6.403  37.268   6.291  1.00 77.16           N  
ATOM    121  N   ALA    14       7.934  31.957  10.781  1.00 63.23           N  
ATOM    122  CA  ALA    14       8.915  30.938  10.392  1.00 62.31           C  
ATOM    123  C   ALA    14       8.343  29.550  10.645  1.00 61.62           C  
ATOM    124  O   ALA    14       8.500  28.680   9.820  1.00 61.28           O  
ATOM    125  CB  ALA    14      10.220  31.124  11.128  1.00 62.06           C  
ATOM    126  N   LEU    15       7.661  29.360  11.774  1.00 63.05           N  
ATOM    127  CA  LEU    15       7.090  28.062  12.111  1.00 63.38           C  
ATOM    128  C   LEU    15       6.057  27.653  11.096  1.00 63.95           C  
ATOM    129  O   LEU    15       6.019  26.491  10.720  1.00 62.84           O  
ATOM    130  CB  LEU    15       6.436  28.052  13.493  1.00 63.75           C  
ATOM    131  CG  LEU    15       5.826  26.702  13.961  1.00 63.96           C  
ATOM    132  CD1 LEU    15       6.941  25.682  14.102  1.00 62.00           C  
ATOM    133  CD2 LEU    15       5.036  26.839  15.266  1.00 62.15           C  
ATOM    134  N   LYS    16       5.220  28.605  10.672  1.00 65.58           N  
ATOM    135  CA  LYS    16       4.143  28.292   9.740  1.00 66.91           C  
ATOM    136  C   LYS    16       4.657  27.898   8.345  1.00 66.08           C  
ATOM    137  O   LYS    16       4.116  26.984   7.737  1.00 66.49           O  
ATOM    138  CB  LYS    16       3.082  29.395   9.676  1.00 67.00           C  
ATOM    139  CG  LYS    16       1.879  28.927   8.881  1.00 69.94           C  
ATOM    140  CD  LYS    16       0.664  29.755   9.027  1.00 69.31           C  
ATOM    141  CE  LYS    16      -0.516  29.056   8.326  1.00 69.26           C  
ATOM    142  NZ  LYS    16      -1.008  27.907   9.104  1.00 65.56           N  
ATOM    143  N   SER    17       5.696  28.567   7.854  1.00 66.10           N  
ATOM    144  CA  SER    17       6.248  28.227   6.551  1.00 65.35           C  
ATOM    145  C   SER    17       7.270  27.069   6.578  1.00 65.04           C  
ATOM    146  O   SER    17       7.323  26.315   5.615  1.00 65.07           O  
ATOM    147  CB  SER    17       6.853  29.447   5.884  1.00 65.18           C  
ATOM    148  OG  SER    17       7.974  29.877   6.577  1.00 71.43           O  
ATOM    149  N   ASP    18       8.051  26.927   7.653  1.00 63.43           N  
ATOM    150  CA  ASP    18       9.121  25.920   7.718  1.00 63.53           C  
ATOM    151  C   ASP    18       8.739  24.638   8.462  1.00 63.23           C  
ATOM    152  O   ASP    18       9.279  23.584   8.157  1.00 62.99           O  
ATOM    153  CB  ASP    18      10.405  26.562   8.246  1.00 63.75           C  
ATOM    154  CG  ASP    18      10.870  27.725   7.383  1.00 61.31           C  
ATOM    155  OD1 ASP    18      10.465  27.840   6.209  1.00 63.82           O  
ATOM    156  OD2 ASP    18      11.684  28.527   7.866  1.00 66.28           O  
ATOM    157  N   ARG    19       7.866  24.742   9.462  1.00 63.86           N  
ATOM    158  CA  ARG    19       7.186  23.580  10.105  1.00 64.11           C  
ATOM    159  C   ARG    19       7.929  22.557  10.969  1.00 62.46           C  
ATOM    160  O   ARG    19       7.410  22.169  12.013  1.00 61.74           O  
ATOM    161  CB  ARG    19       6.388  22.816   9.034  1.00 63.62           C  
ATOM    162  CG  ARG    19       5.393  23.691   8.272  1.00 67.91           C  
ATOM    163  CD  ARG    19       4.563  22.875   7.257  1.00 71.16           C  
ATOM    164  NE  ARG    19       3.187  23.389   7.168  1.00 87.12           N  
ATOM    165  CZ  ARG    19       2.155  22.781   6.554  1.00 93.44           C  
ATOM    166  NH1 ARG    19       2.294  21.602   5.906  1.00 94.97           N  
ATOM    167  NH2 ARG    19       0.951  23.374   6.579  1.00 94.24           N  
ATOM    168  N   THR    20       9.114  22.110  10.559  1.00 62.82           N  
ATOM    169  CA  THR    20       9.813  21.035  11.278  1.00 62.12           C  
ATOM    170  C   THR    20      10.289  21.449  12.675  1.00 62.25           C  
ATOM    171  O   THR    20      10.986  22.453  12.837  1.00 62.77           O  
ATOM    172  CB  THR    20      10.976  20.473  10.473  1.00 61.39           C  
ATOM    173  OG1 THR    20      10.525  20.203   9.142  1.00 57.65           O  
ATOM    174  CG2 THR    20      11.518  19.168  11.113  1.00 60.69           C  
ATOM    175  N   VAL    21       9.827  20.703  13.672  1.00 61.75           N  
ATOM    176  CA  VAL    21      10.223  20.849  15.081  1.00 61.41           C  
ATOM    177  C   VAL    21      10.738  19.484  15.562  1.00 60.57           C  
ATOM    178  O   VAL    21      10.059  18.480  15.358  1.00 60.04           O  
ATOM    179  CB  VAL    21       9.033  21.273  15.979  1.00 60.48           C  
ATOM    180  CG1 VAL    21       9.498  21.463  17.457  1.00 54.74           C  
ATOM    181  CG2 VAL    21       8.372  22.566  15.416  1.00 58.54           C  
ATOM    182  N   MET    22      11.933  19.486  16.162  1.00 62.27           N  
ATOM    183  CA  MET    22      12.554  18.294  16.762  0.50 63.02           C  
ATOM    185  C   MET    22      11.975  18.227  18.188  1.00 63.56           C  
ATOM    186  O   MET    22      12.339  19.014  19.049  1.00 61.75           O  
ATOM    187  CB  MET    22      14.081  18.448  16.778  0.50 63.15           C  
ATOM    189  CG  MET    22      14.878  17.312  17.398  0.50 62.14           C  
ATOM    191  SD  MET    22      15.028  15.746  16.284  0.38 65.65          SE  
ATOM    193  CE  MET    22      16.508  16.277  15.168  0.50 63.37           C  
ATOM    195  N   LEU    23      11.057  17.291  18.427  1.00 65.21           N  
ATOM    196  CA  LEU    23      10.365  17.155  19.718  1.00 65.88           C  
ATOM    197  C   LEU    23      10.875  16.040  20.578  1.00 67.75           C  
ATOM    198  O   LEU    23      10.906  14.880  20.139  1.00 68.07           O  
ATOM    199  CB  LEU    23       8.854  16.903  19.526  1.00 67.56           C  
ATOM    200  CG  LEU    23       7.857  18.043  19.478  1.00 71.70           C  
ATOM    201  CD1 LEU    23       6.457  17.461  19.191  1.00 72.00           C  
ATOM    202  CD2 LEU    23       7.878  18.806  20.780  1.00 67.11           C  
ATOM    203  N   GLY    24      11.168  16.377  21.834  1.00 69.16           N  
ATOM    204  CA  GLY    24      11.643  15.425  22.815  1.00 69.80           C  
ATOM    205  C   GLY    24      10.884  15.598  24.108  1.00 70.76           C  
ATOM    206  O   GLY    24      10.494  16.710  24.465  1.00 70.97           O  
ATOM    207  N   LEU    25      10.735  14.494  24.830  1.00 72.47           N  
ATOM    208  CA  LEU    25      10.015  14.463  26.091  1.00 74.34           C  
ATOM    209  C   LEU    25      11.010  14.993  27.150  1.00 74.96           C  
ATOM    210  O   LEU    25      12.145  14.525  27.228  1.00 73.70           O  
ATOM    211  CB  LEU    25       9.503  13.033  26.394  1.00 72.84           C  
ATOM    212  CG  LEU    25       8.015  12.953  26.735  1.00 72.49           C  
ATOM    213  CD1 LEU    25       7.161  13.401  25.557  1.00 69.61           C  
ATOM    214  CD2 LEU    25       7.623  11.535  27.118  1.00 75.59           C  
ATOM    215  N   ASP    26      10.589  16.011  27.903  1.00 76.90           N  
ATOM    216  CA  ASP    26      11.405  16.637  28.950  1.00 77.57           C  
ATOM    217  C   ASP    26      11.492  15.718  30.181  1.00 78.59           C  
ATOM    218  O   ASP    26      10.601  14.907  30.414  1.00 78.82           O  
ATOM    219  CB  ASP    26      10.802  17.995  29.359  1.00 78.83           C  
ATOM    220  CG  ASP    26      11.741  18.816  30.227  1.00 81.71           C  
ATOM    221  OD1 ASP    26      12.559  19.572  29.658  1.00 83.33           O  
ATOM    222  OD2 ASP    26      11.656  18.697  31.477  1.00 86.77           O  
ATOM    223  N   GLY    27      12.588  15.839  30.931  1.00 79.96           N  
ATOM    224  CA  GLY    27      12.803  15.090  32.163  1.00 81.85           C  
ATOM    225  C   GLY    27      12.993  13.589  32.069  1.00 82.54           C  
ATOM    226  O   GLY    27      12.705  12.893  33.043  1.00 82.96           O  
ATOM    227  N   VAL    28      13.517  13.090  30.947  1.00 83.40           N  
ATOM    228  CA  VAL    28      13.666  11.631  30.732  1.00 83.75           C  
ATOM    229  C   VAL    28      15.039  11.179  30.220  1.00 85.25           C  
ATOM    230  O   VAL    28      15.856  11.988  29.769  1.00 85.54           O  
ATOM    231  CB  VAL    28      12.585  11.094  29.742  1.00 84.15           C  
ATOM    232  CG1 VAL    28      11.212  11.221  30.329  1.00 84.76           C  
ATOM    233  CG2 VAL    28      12.650  11.807  28.426  1.00 81.15           C  
ATOM    234  N   GLU    29      15.252   9.860  30.326  1.00 86.69           N  
ATOM    235  CA  GLU    29      16.440   9.141  29.835  1.00 86.65           C  
ATOM    236  C   GLU    29      16.421   9.238  28.292  1.00 86.73           C  
ATOM    237  O   GLU    29      17.189  10.022  27.712  1.00 87.28           O  
ATOM    238  CB  GLU    29      16.408   7.674  30.358  1.00 86.71           C  
ATOM    239  CG  GLU    29      17.569   6.733  29.973  1.00 86.87           C  
ATOM    240  CD  GLU    29      18.839   6.941  30.784  1.00 87.16           C  
ATOM    241  OE1 GLU    29      19.032   8.033  31.364  1.00 87.24           O  
ATOM    242  OE2 GLU    29      19.658   5.996  30.835  1.00 86.54           O  
ATOM    243  N   ASP    30      15.501   8.507  27.654  1.00 86.31           N  
ATOM    244  CA  ASP    30      15.326   8.521  26.204  1.00 85.65           C  
ATOM    245  C   ASP    30      14.176   9.495  25.941  1.00 83.74           C  
ATOM    246  O   ASP    30      13.006   9.191  26.217  1.00 82.36           O  
ATOM    247  CB  ASP    30      15.018   7.105  25.670  1.00 86.22           C  
ATOM    248  CG  ASP    30      14.946   7.025  24.122  1.00 87.39           C  
ATOM    249  OD1 ASP    30      15.191   8.032  23.397  1.00 89.81           O  
ATOM    250  OD2 ASP    30      14.642   5.911  23.630  1.00 88.30           O  
ATOM    251  N   GLY    31      14.531  10.679  25.430  1.00 82.51           N  
ATOM    252  CA  GLY    31      13.562  11.723  25.081  1.00 80.49           C  
ATOM    253  C   GLY    31      12.677  11.425  23.878  1.00 79.75           C  
ATOM    254  O   GLY    31      11.636  12.076  23.721  1.00 78.15           O  
ATOM    255  N   HIS    32      13.078  10.442  23.053  1.00 78.92           N  
ATOM    256  CA  HIS    32      12.392  10.079  21.807  1.00 78.38           C  
ATOM    257  C   HIS    32      12.324  11.305  20.877  1.00 76.42           C  
ATOM    258  O   HIS    32      11.267  11.624  20.292  1.00 76.30           O  
ATOM    259  CB  HIS    32      11.031   9.430  22.090  1.00 78.51           C  
ATOM    260  CG  HIS    32      11.137   8.161  22.875  1.00 81.02           C  
ATOM    261  ND1 HIS    32      11.167   8.137  24.253  1.00 82.96           N  
ATOM    262  CD2 HIS    32      11.253   6.875  22.474  1.00 80.06           C  
ATOM    263  CE1 HIS    32      11.275   6.889  24.669  1.00 81.78           C  
ATOM    264  NE2 HIS    32      11.329   6.104  23.609  1.00 83.16           N  
ATOM    265  N   ALA    33      13.479  11.984  20.772  1.00 74.02           N  
ATOM    266  CA  ALA    33      13.626  13.184  19.948  1.00 72.19           C  
ATOM    267  C   ALA    33      13.449  12.783  18.497  1.00 69.70           C  
ATOM    268  O   ALA    33      14.078  11.814  18.039  1.00 67.12           O  
ATOM    269  CB  ALA    33      14.987  13.859  20.151  1.00 71.80           C  
ATOM    270  N   ARG    34      12.556  13.488  17.806  1.00 67.19           N  
ATOM    271  CA  ARG    34      12.339  13.250  16.393  1.00 67.22           C  
ATOM    272  C   ARG    34      11.691  14.442  15.720  1.00 64.44           C  
ATOM    273  O   ARG    34      10.952  15.196  16.381  1.00 63.48           O  
ATOM    274  CB  ARG    34      11.540  11.965  16.150  1.00 67.18           C  
ATOM    275  CG  ARG    34      10.172  11.922  16.792  1.00 71.28           C  
ATOM    276  CD  ARG    34       9.592  10.502  16.810  1.00 72.39           C  
ATOM    277  NE  ARG    34      10.255   9.616  17.784  1.00 81.01           N  
ATOM    278  CZ  ARG    34      11.288   8.782  17.558  1.00 84.19           C  
ATOM    279  NH1 ARG    34      11.871   8.654  16.352  1.00 86.28           N  
ATOM    280  NH2 ARG    34      11.755   8.044  18.570  1.00 85.67           N  
ATOM    281  N   PRO    35      11.967  14.626  14.405  1.00 62.56           N  
ATOM    282  CA  PRO    35      11.426  15.765  13.686  1.00 62.47           C  
ATOM    283  C   PRO    35      10.011  15.537  13.223  1.00 61.87           C  
ATOM    284  O   PRO    35       9.737  14.514  12.622  1.00 62.42           O  
ATOM    285  CB  PRO    35      12.380  15.911  12.504  1.00 62.79           C  
ATOM    286  CG  PRO    35      12.923  14.613  12.292  1.00 63.92           C  
ATOM    287  CD  PRO    35      12.796  13.802  13.519  1.00 61.73           C  
ATOM    288  N   MET    36       9.127  16.489  13.525  1.00 62.63           N  
ATOM    289  CA  MET    36       7.711  16.439  13.142  1.00 63.63           C  
ATOM    290  C   MET    36       7.276  17.753  12.556  1.00 61.06           C  
ATOM    291  O   MET    36       7.868  18.789  12.833  1.00 58.73           O  
ATOM    292  CB  MET    36       6.852  16.100  14.341  1.00 63.46           C  
ATOM    293  CG  MET    36       7.253  14.748  14.930  1.00 70.87           C  
ATOM    294  SD  MET    36       6.058  14.216  16.269  0.75 71.16          SE  
ATOM    295  CE  MET    36       4.760  13.683  15.149  1.00 72.71           C  
ATOM    296  N   THR    37       6.192  17.695  11.797  1.00 60.76           N  
ATOM    297  CA  THR    37       5.691  18.830  11.015  1.00 61.43           C  
ATOM    298  C   THR    37       4.609  19.633  11.756  1.00 61.72           C  
ATOM    299  O   THR    37       3.489  19.163  11.945  1.00 62.45           O  
ATOM    300  CB  THR    37       5.194  18.316   9.652  1.00 61.45           C  
ATOM    301  OG1 THR    37       6.248  17.555   9.038  1.00 59.62           O  
ATOM    302  CG2 THR    37       4.794  19.463   8.737  1.00 60.60           C  
ATOM    303  N   ALA    38       4.965  20.832  12.204  1.00 61.37           N  
ATOM    304  CA  ALA    38       4.027  21.700  12.904  1.00 62.54           C  
ATOM    305  C   ALA    38       2.965  22.281  11.944  1.00 63.67           C  
ATOM    306  O   ALA    38       3.258  22.588  10.802  1.00 63.92           O  
ATOM    307  CB  ALA    38       4.762  22.829  13.609  1.00 62.62           C  
ATOM    308  N   GLN    39       1.724  22.329  12.411  1.00 65.02           N  
ATOM    309  CA  GLN    39       0.640  23.011  11.738  1.00 65.99           C  
ATOM    310  C   GLN    39      -0.092  23.849  12.786  1.00 65.24           C  
ATOM    311  O   GLN    39      -0.253  23.414  13.934  1.00 63.32           O  
ATOM    312  CB  GLN    39      -0.320  22.029  11.100  1.00 66.62           C  
ATOM    313  CG  GLN    39       0.320  21.221   9.999  1.00 71.74           C  
ATOM    314  CD  GLN    39      -0.640  20.379   9.188  1.00 70.73           C  
ATOM    315  OE1 GLN    39      -0.287  19.246   8.822  1.00 82.77           O  
ATOM    316  NE2 GLN    39      -1.852  20.917   8.876  1.00 71.37           N  
ATOM    317  N   ILE    40      -0.485  25.058  12.399  1.00 65.86           N  
ATOM    318  CA  ILE    40      -1.327  25.933  13.232  1.00 66.67           C  
ATOM    319  C   ILE    40      -2.519  26.452  12.390  1.00 67.29           C  
ATOM    320  O   ILE    40      -2.403  26.617  11.177  1.00 66.21           O  
ATOM    321  CB  ILE    40      -0.512  27.114  13.872  1.00 66.43           C  
ATOM    322  CG1 ILE    40      -0.119  28.195  12.854  1.00 64.90           C  
ATOM    323  CG2 ILE    40       0.743  26.583  14.584  1.00 66.36           C  
ATOM    324  CD1 ILE    40       0.694  29.355  13.464  1.00 66.76           C  
ATOM    325  N   GLU    41      -3.651  26.712  13.035  1.00 67.88           N  
ATOM    326  CA  GLU    41      -4.796  27.321  12.351  1.00 68.19           C  
ATOM    327  C   GLU    41      -4.506  28.811  12.417  1.00 68.29           C  
ATOM    328  O   GLU    41      -4.081  29.315  13.447  1.00 67.75           O  
ATOM    329  CB  GLU    41      -6.122  26.965  13.011  1.00 67.65           C  
ATOM    330  CG  GLU    41      -6.338  25.465  13.148  1.00 67.09           C  
ATOM    331  CD  GLU    41      -7.748  25.110  13.531  1.00 69.19           C  
ATOM    332  OE1 GLU    41      -8.005  24.874  14.734  1.00 70.22           O  
ATOM    333  OE2 GLU    41      -8.613  25.101  12.630  1.00 72.58           O  
ATOM    334  N   GLY    42      -4.715  29.512  11.315  1.00 69.31           N  
ATOM    335  CA  GLY    42      -4.371  30.923  11.232  1.00 70.73           C  
ATOM    336  C   GLY    42      -2.881  31.113  10.995  1.00 72.32           C  
ATOM    337  O   GLY    42      -2.152  30.168  10.670  1.00 71.78           O  
ATOM    338  N   ASP    43      -2.439  32.350  11.171  1.00 74.76           N  
ATOM    339  CA  ASP    43      -1.040  32.751  10.935  1.00 76.24           C  
ATOM    340  C   ASP    43      -0.192  32.843  12.215  1.00 76.23           C  
ATOM    341  O   ASP    43       1.043  32.789  12.142  1.00 75.95           O  
ATOM    342  CB  ASP    43      -1.047  34.066  10.152  1.00 77.32           C  
ATOM    343  CG  ASP    43      -1.873  33.966   8.854  1.00 80.76           C  
ATOM    344  OD1 ASP    43      -1.801  32.923   8.153  1.00 84.46           O  
ATOM    345  OD2 ASP    43      -2.602  34.929   8.543  1.00 86.27           O  
ATOM    346  N   SER    44      -0.847  32.986  13.368  1.00 75.83           N  
ATOM    347  CA  SER    44      -0.172  32.991  14.672  1.00 76.04           C  
ATOM    348  C   SER    44      -0.974  32.203  15.726  1.00 74.54           C  
ATOM    349  O   SER    44      -2.106  31.772  15.497  1.00 74.05           O  
ATOM    350  CB  SER    44       0.034  34.432  15.162  1.00 75.37           C  
ATOM    351  OG  SER    44      -1.194  35.014  15.568  1.00 77.39           O  
ATOM    352  N   GLY    45      -0.354  32.041  16.881  1.00 73.61           N  
ATOM    353  CA  GLY    45      -0.959  31.406  18.034  1.00 73.37           C  
ATOM    354  C   GLY    45      -1.141  29.913  17.966  1.00 72.49           C  
ATOM    355  O   GLY    45      -1.494  29.371  16.939  1.00 72.76           O  
ATOM    356  N   GLY    46      -0.921  29.244  19.090  1.00 72.31           N  
ATOM    357  CA  GLY    46      -1.103  27.797  19.180  1.00 70.26           C  
ATOM    358  C   GLY    46      -2.585  27.445  19.311  1.00 68.19           C  
ATOM    359  O   GLY    46      -3.421  28.324  19.176  1.00 67.96           O  
ATOM    360  N   PRO    47      -2.921  26.163  19.564  1.00 66.61           N  
ATOM    361  CA  PRO    47      -1.986  25.041  19.729  1.00 65.95           C  
ATOM    362  C   PRO    47      -1.200  24.697  18.459  1.00 64.51           C  
ATOM    363  O   PRO    47      -1.618  25.063  17.361  1.00 65.61           O  
ATOM    364  CB  PRO    47      -2.895  23.871  20.133  1.00 65.74           C  
ATOM    365  CG  PRO    47      -4.206  24.502  20.510  1.00 68.47           C  
ATOM    366  CD  PRO    47      -4.322  25.722  19.704  1.00 66.10           C  
ATOM    367  N   ILE    48      -0.054  24.051  18.639  1.00 62.85           N  
ATOM    368  CA  ILE    48       0.774  23.589  17.536  1.00 62.67           C  
ATOM    369  C   ILE    48       0.409  22.103  17.403  1.00 61.35           C  
ATOM    370  O   ILE    48       0.603  21.307  18.348  1.00 61.17           O  
ATOM    371  CB  ILE    48       2.284  23.820  17.807  1.00 62.84           C  
ATOM    372  CG1 ILE    48       2.573  25.334  17.988  1.00 65.82           C  
ATOM    373  CG2 ILE    48       3.112  23.258  16.679  1.00 55.88           C  
ATOM    374  CD1 ILE    48       3.926  25.655  18.683  1.00 63.10           C  
ATOM    375  N   TRP    49      -0.105  21.748  16.231  1.00 59.20           N  
ATOM    376  CA  TRP    49      -0.565  20.413  15.929  1.00 58.95           C  
ATOM    377  C   TRP    49       0.455  19.634  15.100  1.00 59.22           C  
ATOM    378  O   TRP    49       1.116  20.194  14.236  1.00 60.26           O  
ATOM    379  CB  TRP    49      -1.874  20.491  15.160  1.00 60.06           C  
ATOM    380  CG  TRP    49      -2.976  21.246  15.842  1.00 61.83           C  
ATOM    381  CD1 TRP    49      -3.241  22.581  15.740  1.00 62.31           C  
ATOM    382  CD2 TRP    49      -3.946  20.712  16.746  1.00 63.23           C  
ATOM    383  NE1 TRP    49      -4.333  22.910  16.499  1.00 63.51           N  
ATOM    384  CE2 TRP    49      -4.791  21.785  17.130  1.00 64.70           C  
ATOM    385  CE3 TRP    49      -4.192  19.430  17.258  1.00 60.45           C  
ATOM    386  CZ2 TRP    49      -5.871  21.617  18.015  1.00 64.00           C  
ATOM    387  CZ3 TRP    49      -5.269  19.247  18.125  1.00 62.95           C  
ATOM    388  CH2 TRP    49      -6.096  20.343  18.504  1.00 65.90           C  
ATOM    389  N   PHE    50       0.544  18.336  15.359  1.00 59.87           N  
ATOM    390  CA  PHE    50       1.432  17.408  14.667  1.00 59.82           C  
ATOM    391  C   PHE    50       0.679  16.129  14.288  1.00 60.06           C  
ATOM    392  O   PHE    50       0.203  15.427  15.169  1.00 59.72           O  
ATOM    393  CB  PHE    50       2.602  17.023  15.567  1.00 60.78           C  
ATOM    394  CG  PHE    50       3.443  18.176  15.986  1.00 57.50           C  
ATOM    395  CD1 PHE    50       4.467  18.641  15.155  1.00 56.54           C  
ATOM    396  CD2 PHE    50       3.231  18.797  17.213  1.00 61.39           C  
ATOM    397  CE1 PHE    50       5.263  19.740  15.538  1.00 61.15           C  
ATOM    398  CE2 PHE    50       4.026  19.911  17.619  1.00 61.39           C  
ATOM    399  CZ  PHE    50       5.038  20.379  16.783  1.00 59.11           C  
ATOM    400  N   PHE    51       0.540  15.873  12.980  1.00 60.22           N  
ATOM    401  CA  PHE    51      -0.034  14.639  12.465  1.00 60.99           C  
ATOM    402  C   PHE    51       0.996  13.534  12.659  1.00 62.77           C  
ATOM    403  O   PHE    51       2.188  13.735  12.416  1.00 61.23           O  
ATOM    404  CB  PHE    51      -0.437  14.730  10.980  1.00 59.72           C  
ATOM    405  CG  PHE    51      -1.811  15.267  10.760  1.00 59.54           C  
ATOM    406  CD1 PHE    51      -2.924  14.421  10.890  1.00 59.07           C  
ATOM    407  CD2 PHE    51      -2.018  16.612  10.431  1.00 56.93           C  
ATOM    408  CE1 PHE    51      -4.227  14.898  10.691  1.00 56.00           C  
ATOM    409  CE2 PHE    51      -3.315  17.101  10.230  1.00 57.90           C  
ATOM    410  CZ  PHE    51      -4.425  16.242  10.352  1.00 55.28           C  
ATOM    411  N   THR    52       0.529  12.363  13.087  1.00 64.97           N  
ATOM    412  CA  THR    52       1.431  11.252  13.360  1.00 66.70           C  
ATOM    413  C   THR    52       0.715   9.907  13.320  1.00 68.53           C  
ATOM    414  O   THR    52      -0.503   9.849  13.124  1.00 67.55           O  
ATOM    415  CB  THR    52       2.156  11.486  14.732  1.00 66.81           C  
ATOM    416  OG1 THR    52       3.324  10.661  14.826  1.00 66.69           O  
ATOM    417  CG2 THR    52       1.218  11.261  15.929  1.00 67.16           C  
ATOM    418  N   SER    53       1.503   8.842  13.475  1.00 71.02           N  
ATOM    419  CA  SER    53       1.007   7.462  13.488  1.00 73.79           C  
ATOM    420  C   SER    53       0.726   7.057  14.924  1.00 74.03           C  
ATOM    421  O   SER    53       1.457   7.448  15.825  1.00 73.97           O  
ATOM    422  CB  SER    53       2.028   6.511  12.842  1.00 74.45           C  
ATOM    423  OG  SER    53       3.347   6.758  13.326  1.00 77.89           O  
ATOM    424  N   LYS    54      -0.317   6.249  15.122  1.00 75.47           N  
ATOM    425  CA  LYS    54      -0.727   5.767  16.466  1.00 76.05           C  
ATOM    426  C   LYS    54       0.378   4.954  17.194  1.00 76.73           C  
ATOM    427  O   LYS    54       0.372   4.863  18.430  1.00 76.65           O  
ATOM    428  CB  LYS    54      -2.038   4.962  16.384  1.00 75.95           C  
ATOM    429  CG  LYS    54      -2.723   4.735  17.727  1.00 75.99           C  
ATOM    430  N   ASP    55       1.312   4.393  16.415  1.00 77.08           N  
ATOM    431  CA  ASP    55       2.486   3.668  16.927  1.00 77.47           C  
ATOM    432  C   ASP    55       3.756   4.543  17.137  1.00 77.73           C  
ATOM    433  O   ASP    55       4.865   4.003  17.202  1.00 77.71           O  
ATOM    434  CB  ASP    55       2.769   2.405  16.057  1.00 78.39           C  
ATOM    435  CG  ASP    55       3.146   2.723  14.594  1.00 79.86           C  
ATOM    436  OD1 ASP    55       3.702   3.814  14.296  1.00 76.90           O  
ATOM    437  OD2 ASP    55       2.882   1.844  13.742  1.00 75.84           O  
ATOM    438  N   ASN    56       3.604   5.877  17.225  1.00 78.26           N  
ATOM    439  CA  ASN    56       4.730   6.786  17.527  1.00 77.69           C  
ATOM    440  C   ASN    56       5.063   6.579  19.009  1.00 77.79           C  
ATOM    441  O   ASN    56       4.163   6.580  19.850  1.00 77.84           O  
ATOM    442  CB  ASN    56       4.373   8.259  17.235  1.00 78.20           C  
ATOM    443  CG  ASN    56       5.575   9.239  17.393  1.00 78.54           C  
ATOM    444  OD1 ASN    56       6.618   8.904  17.961  1.00 81.25           O  
ATOM    445  ND2 ASN    56       5.402  10.467  16.892  1.00 76.95           N  
ATOM    446  N   ALA    57       6.353   6.390  19.305  1.00 77.88           N  
ATOM    447  CA  ALA    57       6.862   6.139  20.673  1.00 77.42           C  
ATOM    448  C   ALA    57       6.356   7.121  21.743  1.00 77.21           C  
ATOM    449  O   ALA    57       6.012   6.703  22.852  1.00 78.12           O  
ATOM    450  CB  ALA    57       8.395   6.125  20.674  1.00 78.03           C  
ATOM    451  N   LEU    58       6.293   8.404  21.390  1.00 75.66           N  
ATOM    452  CA  LEU    58       5.806   9.455  22.297  1.00 75.14           C  
ATOM    453  C   LEU    58       4.381   9.207  22.822  1.00 74.76           C  
ATOM    454  O   LEU    58       4.159   9.244  24.039  1.00 75.19           O  
ATOM    455  CB  LEU    58       5.835  10.823  21.607  1.00 75.44           C  
ATOM    456  CG  LEU    58       7.167  11.385  21.116  1.00 75.89           C  
ATOM    457  CD1 LEU    58       6.926  12.648  20.323  1.00 77.91           C  
ATOM    458  CD2 LEU    58       8.087  11.656  22.285  1.00 78.44           C  
ATOM    459  N   ILE    59       3.464   8.877  21.906  1.00 73.25           N  
ATOM    460  CA  ILE    59       2.014   8.743  22.190  1.00 73.11           C  
ATOM    461  C   ILE    59       1.621   8.007  23.482  1.00 72.50           C  
ATOM    462  O   ILE    59       0.824   8.533  24.266  1.00 72.90           O  
ATOM    463  CB  ILE    59       1.236   8.119  20.986  1.00 72.45           C  
ATOM    464  CG1 ILE    59       1.214   9.077  19.803  1.00 71.37           C  
ATOM    465  CG2 ILE    59      -0.223   7.792  21.357  1.00 72.55           C  
ATOM    466  CD1 ILE    59       0.611   8.451  18.569  1.00 73.52           C  
ATOM    467  N   ALA    60       2.187   6.822  23.703  1.00 72.02           N  
ATOM    468  CA  ALA    60       1.866   6.014  24.898  1.00 71.94           C  
ATOM    469  C   ALA    60       2.331   6.613  26.247  1.00 71.50           C  
ATOM    470  O   ALA    60       1.842   6.197  27.297  1.00 71.70           O  
ATOM    471  CB  ALA    60       2.408   4.598  24.738  1.00 71.96           C  
ATOM    472  N   MET    61       3.257   7.573  26.188  1.00 71.59           N  
ATOM    473  CA  MET    61       3.829   8.262  27.356  0.50 71.96           C  
ATOM    475  C   MET    61       3.029   9.526  27.769  1.00 70.87           C  
ATOM    476  O   MET    61       3.049   9.928  28.920  1.00 70.86           O  
ATOM    477  CB  MET    61       5.308   8.657  27.063  0.50 72.25           C  
ATOM    479  CG  MET    61       6.197   7.492  26.514  0.50 73.77           C  
ATOM    481  SD  MET    61       8.167   7.783  26.352  0.38 75.42          SE  
ATOM    483  CE  MET    61       8.247   9.135  25.028  0.50 75.19           C  
ATOM    485  N   LEU    62       2.283  10.118  26.842  1.00 69.59           N  
ATOM    486  CA  LEU    62       1.606  11.414  27.092  1.00 68.81           C  
ATOM    487  C   LEU    62       0.483  11.543  28.142  1.00 66.71           C  
ATOM    488  O   LEU    62       0.504  12.487  28.924  1.00 65.74           O  
ATOM    489  CB  LEU    62       1.144  12.039  25.760  1.00 68.82           C  
ATOM    490  CG  LEU    62       2.150  12.080  24.597  1.00 66.91           C  
ATOM    491  CD1 LEU    62       1.573  12.864  23.444  1.00 65.18           C  
ATOM    492  CD2 LEU    62       3.503  12.641  25.019  1.00 67.43           C  
ATOM    493  N   GLY    63      -0.484  10.630  28.152  1.00 66.16           N  
ATOM    494  CA  GLY    63      -1.649  10.712  29.056  1.00 66.32           C  
ATOM    495  C   GLY    63      -2.434  12.035  28.966  1.00 65.63           C  
ATOM    496  O   GLY    63      -2.892  12.444  27.902  1.00 65.48           O  
ATOM    497  N   GLN    64      -2.526  12.726  30.095  1.00 66.49           N  
ATOM    498  CA  GLN    64      -3.162  14.057  30.221  1.00 66.40           C  
ATOM    499  C   GLN    64      -2.281  15.170  29.596  1.00 64.88           C  
ATOM    500  O   GLN    64      -2.723  16.288  29.421  1.00 63.57           O  
ATOM    501  CB  GLN    64      -3.361  14.351  31.738  1.00 68.24           C  
ATOM    502  CG  GLN    64      -4.310  15.495  32.149  1.00 68.00           C  
ATOM    503  CD  GLN    64      -4.161  15.929  33.634  1.00 67.37           C  
ATOM    504  OE1 GLN    64      -3.052  16.233  34.087  1.00 72.68           O  
ATOM    505  NE2 GLN    64      -5.281  15.989  34.375  1.00 55.14           N  
ATOM    506  N   GLY    65      -1.024  14.859  29.299  1.00 64.73           N  
ATOM    507  CA  GLY    65      -0.069  15.787  28.750  1.00 65.43           C  
ATOM    508  C   GLY    65       1.242  15.662  29.502  1.00 66.21           C  
ATOM    509  O   GLY    65       1.241  15.457  30.712  1.00 66.90           O  
ATOM    510  N   ARG    66       2.352  15.729  28.776  1.00 67.81           N  
ATOM    511  CA  ARG    66       3.709  15.714  29.342  1.00 68.20           C  
ATOM    512  C   ARG    66       4.434  16.905  28.823  1.00 68.16           C  
ATOM    513  O   ARG    66       4.195  17.319  27.686  1.00 67.24           O  
ATOM    514  CB  ARG    66       4.485  14.473  28.947  1.00 68.79           C  
ATOM    515  CG  ARG    66       4.023  13.260  29.688  1.00 75.77           C  
ATOM    516  CD  ARG    66       5.041  12.160  29.651  1.00 84.49           C  
ATOM    517  NE  ARG    66       6.263  12.502  30.375  1.00 88.64           N  
ATOM    518  CZ  ARG    66       7.240  11.643  30.675  1.00 91.91           C  
ATOM    519  NH1 ARG    66       7.168  10.346  30.342  1.00 92.78           N  
ATOM    520  NH2 ARG    66       8.309  12.087  31.343  1.00 93.03           N  
ATOM    521  N   ARG    67       5.352  17.429  29.633  1.00 69.22           N  
ATOM    522  CA  ARG    67       6.094  18.619  29.252  1.00 70.73           C  
ATOM    523  C   ARG    67       7.126  18.197  28.198  1.00 67.85           C  
ATOM    524  O   ARG    67       7.712  17.123  28.299  1.00 68.41           O  
ATOM    525  CB  ARG    67       6.756  19.329  30.455  1.00 70.26           C  
ATOM    526  CG  ARG    67       6.821  20.848  30.221  1.00 76.57           C  
ATOM    527  CD  ARG    67       7.966  21.566  30.904  1.00 77.32           C  
ATOM    528  NE  ARG    67       7.855  21.681  32.362  1.00 86.77           N  
ATOM    529  CZ  ARG    67       8.456  20.913  33.286  1.00 88.48           C  
ATOM    530  NH1 ARG    67       9.276  19.899  32.970  1.00 89.88           N  
ATOM    531  NH2 ARG    67       8.239  21.180  34.573  1.00 88.54           N  
ATOM    532  N   VAL    68       7.271  19.005  27.159  1.00 65.16           N  
ATOM    533  CA  VAL    68       8.215  18.747  26.063  1.00 62.41           C  
ATOM    534  C   VAL    68       8.978  20.007  25.717  1.00 60.91           C  
ATOM    535  O   VAL    68       8.543  21.090  26.072  1.00 59.60           O  
ATOM    536  CB  VAL    68       7.498  18.254  24.764  1.00 61.59           C  
ATOM    537  CG1 VAL    68       6.901  16.871  24.965  1.00 61.91           C  
ATOM    538  CG2 VAL    68       6.433  19.268  24.275  1.00 55.67           C  
ATOM    539  N   ILE    69      10.122  19.827  25.049  1.00 60.95           N  
ATOM    540  CA  ILE    69      10.926  20.890  24.436  1.00 61.42           C  
ATOM    541  C   ILE    69      10.969  20.593  22.918  1.00 62.59           C  
ATOM    542  O   ILE    69      11.247  19.472  22.513  1.00 63.16           O  
ATOM    543  CB  ILE    69      12.359  20.987  25.029  1.00 61.23           C  
ATOM    544  CG1 ILE    69      12.309  21.469  26.486  1.00 62.50           C  
ATOM    545  CG2 ILE    69      13.291  21.908  24.186  1.00 56.80           C  
ATOM    546  CD1 ILE    69      11.826  22.910  26.653  1.00 63.44           C  
ATOM    547  N   GLY    70      10.686  21.605  22.099  1.00 62.73           N  
ATOM    548  CA  GLY    70      10.683  21.493  20.647  1.00 62.02           C  
ATOM    549  C   GLY    70      11.794  22.387  20.116  1.00 61.75           C  
ATOM    550  O   GLY    70      11.733  23.605  20.304  1.00 62.94           O  
ATOM    551  N   ALA    71      12.817  21.793  19.520  1.00 59.28           N  
ATOM    552  CA  ALA    71      13.928  22.558  18.933  1.00 60.54           C  
ATOM    553  C   ALA    71      13.531  22.928  17.483  1.00 59.79           C  
ATOM    554  O   ALA    71      13.273  22.042  16.668  1.00 59.76           O  
ATOM    555  CB  ALA    71      15.217  21.749  18.984  1.00 58.60           C  
ATOM    556  N   PHE    72      13.434  24.227  17.204  1.00 59.98           N  
ATOM    557  CA  PHE    72      13.040  24.764  15.881  1.00 60.04           C  
ATOM    558  C   PHE    72      14.087  25.714  15.286  1.00 60.96           C  
ATOM    559  O   PHE    72      14.642  26.566  16.003  1.00 60.23           O  
ATOM    560  CB  PHE    72      11.733  25.575  15.998  1.00 59.18           C  
ATOM    561  CG  PHE    72      11.344  26.281  14.725  1.00 58.73           C  
ATOM    562  CD1 PHE    72      10.759  25.576  13.684  1.00 58.25           C  
ATOM    563  CD2 PHE    72      11.630  27.630  14.535  1.00 60.96           C  
ATOM    564  CE1 PHE    72      10.437  26.187  12.475  1.00 59.78           C  
ATOM    565  CE2 PHE    72      11.313  28.266  13.322  1.00 64.31           C  
ATOM    566  CZ  PHE    72      10.701  27.539  12.297  1.00 59.65           C  
ATOM    567  N   SER    73      14.300  25.593  13.973  1.00 60.67           N  
ATOM    568  CA  SER    73      15.104  26.554  13.233  1.00 61.76           C  
ATOM    569  C   SER    73      14.387  26.874  11.932  1.00 61.94           C  
ATOM    570  O   SER    73      13.763  25.993  11.344  1.00 61.60           O  
ATOM    571  CB  SER    73      16.533  26.050  12.965  1.00 62.88           C  
ATOM    572  OG  SER    73      16.613  25.073  11.935  1.00 64.92           O  
ATOM    573  N   SER    74      14.431  28.142  11.511  1.00 62.03           N  
ATOM    574  CA  SER    74      13.942  28.540  10.202  1.00 62.94           C  
ATOM    575  C   SER    74      14.851  27.889   9.130  1.00 62.64           C  
ATOM    576  O   SER    74      15.990  27.551   9.408  1.00 61.33           O  
ATOM    577  CB  SER    74      13.929  30.074  10.048  1.00 62.75           C  
ATOM    578  OG  SER    74      15.209  30.614  10.328  1.00 67.23           O  
ATOM    579  N   LYS    75      14.347  27.753   7.913  1.00 64.07           N  
ATOM    580  CA  LYS    75      15.071  27.094   6.799  1.00 65.55           C  
ATOM    581  C   LYS    75      16.431  27.760   6.465  1.00 66.03           C  
ATOM    582  O   LYS    75      17.456  27.074   6.222  1.00 66.43           O  
ATOM    583  CB  LYS    75      14.146  26.987   5.582  1.00 64.21           C  
ATOM    584  CG  LYS    75      14.528  25.940   4.558  1.00 69.75           C  
ATOM    585  CD  LYS    75      13.380  25.629   3.534  1.00 68.15           C  
ATOM    586  CE  LYS    75      12.201  24.845   4.199  1.00 75.85           C  
ATOM    587  NZ  LYS    75      11.098  24.432   3.271  1.00 74.33           N  
ATOM    588  N   GLY    76      16.454  29.086   6.521  1.00 65.47           N  
ATOM    589  CA  GLY    76      17.695  29.823   6.305  1.00 64.53           C  
ATOM    590  C   GLY    76      18.616  29.969   7.510  1.00 64.33           C  
ATOM    591  O   GLY    76      19.679  30.580   7.377  1.00 64.98           O  
ATOM    592  N   HIS    77      18.230  29.432   8.674  1.00 63.35           N  
ATOM    593  CA  HIS    77      19.004  29.540   9.914  1.00 63.01           C  
ATOM    594  C   HIS    77      19.153  30.968  10.472  1.00 62.42           C  
ATOM    595  O   HIS    77      20.116  31.266  11.186  1.00 62.37           O  
ATOM    596  CB  HIS    77      20.359  28.812   9.771  1.00 62.40           C  
ATOM    597  CG  HIS    77      20.264  27.329   9.882  1.00 65.14           C  
ATOM    598  ND1 HIS    77      21.384  26.544  10.009  1.00 63.19           N  
ATOM    599  CD2 HIS    77      19.200  26.491   9.977  1.00 60.11           C  
ATOM    600  CE1 HIS    77      21.022  25.281  10.114  1.00 63.23           C  
ATOM    601  NE2 HIS    77      19.704  25.219  10.107  1.00 64.01           N  
ATOM    602  N   ASP    78      18.176  31.822  10.164  1.00 62.73           N  
ATOM    603  CA  ASP    78      18.120  33.200  10.668  1.00 63.74           C  
ATOM    604  C   ASP    78      17.443  33.299  12.036  1.00 62.49           C  
ATOM    605  O   ASP    78      17.598  34.293  12.714  1.00 61.00           O  
ATOM    606  CB  ASP    78      17.465  34.172   9.664  1.00 65.53           C  
ATOM    607  CG  ASP    78      16.011  33.852   9.363  1.00 74.11           C  
ATOM    608  OD1 ASP    78      15.706  32.676   9.082  1.00 87.52           O  
ATOM    609  OD2 ASP    78      15.181  34.791   9.350  1.00 86.29           O  
ATOM    610  N   LEU    79      16.693  32.267  12.420  1.00 63.41           N  
ATOM    611  CA  LEU    79      16.018  32.193  13.702  1.00 62.72           C  
ATOM    612  C   LEU    79      16.037  30.779  14.262  1.00 62.60           C  
ATOM    613  O   LEU    79      15.770  29.825  13.543  1.00 62.56           O  
ATOM    614  CB  LEU    79      14.571  32.682  13.538  1.00 62.83           C  
ATOM    615  CG  LEU    79      13.612  32.684  14.742  1.00 63.48           C  
ATOM    616  CD1 LEU    79      12.605  33.802  14.634  1.00 60.71           C  
ATOM    617  CD2 LEU    79      12.912  31.345  14.948  1.00 61.69           C  
ATOM    618  N   PHE    80      16.349  30.676  15.557  1.00 63.03           N  
ATOM    619  CA  PHE    80      16.302  29.445  16.331  1.00 61.20           C  
ATOM    620  C   PHE    80      15.329  29.671  17.497  1.00 61.24           C  
ATOM    621  O   PHE    80      15.302  30.747  18.058  1.00 61.99           O  
ATOM    622  CB  PHE    80      17.698  29.080  16.813  1.00 61.64           C  
ATOM    623  CG  PHE    80      18.629  28.791  15.692  1.00 62.13           C  
ATOM    624  CD1 PHE    80      18.686  27.513  15.140  1.00 59.83           C  
ATOM    625  CD2 PHE    80      19.398  29.808  15.132  1.00 62.75           C  
ATOM    626  CE1 PHE    80      19.521  27.243  14.062  1.00 60.15           C  
ATOM    627  CE2 PHE    80      20.226  29.561  14.027  1.00 60.53           C  
ATOM    628  CZ  PHE    80      20.299  28.274  13.502  1.00 61.80           C  
ATOM    629  N   ALA    81      14.506  28.672  17.809  1.00 60.35           N  
ATOM    630  CA  ALA    81      13.524  28.758  18.893  1.00 59.85           C  
ATOM    631  C   ALA    81      13.447  27.422  19.627  1.00 61.07           C  
ATOM    632  O   ALA    81      13.455  26.357  18.989  1.00 61.07           O  
ATOM    633  CB  ALA    81      12.123  29.169  18.347  1.00 57.08           C  
ATOM    634  N   SER    82      13.425  27.501  20.960  1.00 61.50           N  
ATOM    635  CA  SER    82      13.270  26.357  21.849  1.00 61.69           C  
ATOM    636  C   SER    82      11.882  26.548  22.472  1.00 61.85           C  
ATOM    637  O   SER    82      11.663  27.507  23.219  1.00 62.53           O  
ATOM    638  CB  SER    82      14.371  26.351  22.900  1.00 61.04           C  
ATOM    639  OG  SER    82      14.242  25.225  23.714  1.00 61.74           O  
ATOM    640  N   ILE    83      10.963  25.643  22.148  1.00 61.03           N  
ATOM    641  CA  ILE    83       9.553  25.764  22.517  1.00 60.58           C  
ATOM    642  C   ILE    83       9.266  24.847  23.697  1.00 60.93           C  
ATOM    643  O   ILE    83       9.510  23.656  23.602  1.00 61.95           O  
ATOM    644  CB  ILE    83       8.633  25.355  21.334  1.00 60.49           C  
ATOM    645  CG1 ILE    83       9.032  26.076  20.025  1.00 61.83           C  
ATOM    646  CG2 ILE    83       7.177  25.624  21.675  1.00 58.47           C  
ATOM    647  CD1 ILE    83       8.434  25.478  18.765  1.00 60.88           C  
ATOM    648  N   SER    84       8.759  25.418  24.787  1.00 59.46           N  
ATOM    649  CA  SER    84       8.364  24.697  25.970  1.00 60.27           C  
ATOM    650  C   SER    84       6.845  24.641  26.009  1.00 59.71           C  
ATOM    651  O   SER    84       6.184  25.641  25.786  1.00 58.95           O  
ATOM    652  CB  SER    84       8.864  25.397  27.227  1.00 59.24           C  
ATOM    653  OG  SER    84       8.388  24.722  28.346  1.00 61.61           O  
ATOM    654  N   GLY    85       6.313  23.461  26.315  1.00 59.32           N  
ATOM    655  CA  GLY    85       4.886  23.285  26.414  1.00 59.57           C  
ATOM    656  C   GLY    85       4.476  21.884  26.795  1.00 59.93           C  
ATOM    657  O   GLY    85       5.316  21.040  27.130  1.00 57.84           O  
ATOM    658  N   SER    86       3.167  21.652  26.718  1.00 60.53           N  
ATOM    659  CA  SER    86       2.579  20.379  27.083  1.00 62.22           C  
ATOM    660  C   SER    86       2.099  19.687  25.827  1.00 61.21           C  
ATOM    661  O   SER    86       1.456  20.327  24.998  1.00 60.49           O  
ATOM    662  CB  SER    86       1.424  20.601  28.056  1.00 62.37           C  
ATOM    663  OG  SER    86       1.041  19.368  28.593  1.00 69.29           O  
ATOM    664  N   LEU    87       2.410  18.390  25.709  1.00 61.36           N  
ATOM    665  CA  LEU    87       2.066  17.577  24.555  1.00 61.79           C  
ATOM    666  C   LEU    87       1.098  16.463  24.945  1.00 62.05           C  
ATOM    667  O   LEU    87       1.339  15.762  25.910  1.00 61.68           O  
ATOM    668  CB  LEU    87       3.332  16.959  23.956  1.00 62.08           C  
ATOM    669  CG  LEU    87       3.223  16.237  22.587  1.00 60.82           C  
ATOM    670  CD1 LEU    87       2.987  17.238  21.460  1.00 56.57           C  
ATOM    671  CD2 LEU    87       4.471  15.424  22.316  1.00 60.35           C  
ATOM    672  N   ARG    88       0.013  16.314  24.189  1.00 62.43           N  
ATOM    673  CA  ARG    88      -0.968  15.221  24.395  1.00 63.66           C  
ATOM    674  C   ARG    88      -1.614  14.877  23.060  1.00 65.27           C  
ATOM    675  O   ARG    88      -1.478  15.629  22.091  1.00 65.49           O  
ATOM    676  CB  ARG    88      -2.045  15.593  25.414  1.00 61.65           C  
ATOM    677  CG  ARG    88      -3.136  16.563  24.942  1.00 62.82           C  
ATOM    678  CD  ARG    88      -3.992  17.029  26.093  1.00 64.88           C  
ATOM    679  NE  ARG    88      -5.296  17.545  25.669  1.00 68.30           N  
ATOM    680  CZ  ARG    88      -5.652  18.829  25.496  1.00 73.89           C  
ATOM    681  NH1 ARG    88      -4.840  19.870  25.744  1.00 70.34           N  
ATOM    682  NH2 ARG    88      -6.898  19.082  25.081  1.00 77.03           N  
ATOM    683  N   GLU    89      -2.309  13.748  23.022  1.00 65.27           N  
ATOM    684  CA  GLU    89      -3.038  13.341  21.837  1.00 65.79           C  
ATOM    685  C   GLU    89      -4.428  13.954  21.904  1.00 65.73           C  
ATOM    686  O   GLU    89      -5.092  13.873  22.930  1.00 65.83           O  
ATOM    687  CB  GLU    89      -3.160  11.826  21.762  1.00 65.81           C  
ATOM    688  CG  GLU    89      -3.649  11.337  20.397  1.00 66.36           C  
ATOM    689  CD  GLU    89      -4.083   9.899  20.410  1.00 66.98           C  
ATOM    690  OE1 GLU    89      -3.488   9.087  21.159  1.00 69.53           O  
ATOM    691  OE2 GLU    89      -5.033   9.581  19.657  1.00 75.68           O  
ATOM    692  N   ASP    90      -4.849  14.597  20.820  1.00 67.11           N  
ATOM    693  CA  ASP    90      -6.206  15.145  20.705  1.00 67.14           C  
ATOM    694  C   ASP    90      -6.621  14.961  19.255  1.00 67.68           C  
ATOM    695  O   ASP    90      -6.628  15.917  18.464  1.00 68.75           O  
ATOM    696  CB  ASP    90      -6.315  16.617  21.162  1.00 66.98           C  
ATOM    697  CG  ASP    90      -7.786  17.152  21.154  1.00 68.16           C  
ATOM    698  OD1 ASP    90      -8.764  16.372  21.278  1.00 66.63           O  
ATOM    699  OD2 ASP    90      -7.973  18.377  21.026  1.00 70.41           O  
ATOM    700  N   THR    91      -6.947  13.708  18.924  1.00 66.34           N  
ATOM    701  CA  THR    91      -7.418  13.320  17.601  1.00 66.46           C  
ATOM    702  C   THR    91      -8.928  13.639  17.527  1.00 66.88           C  
ATOM    703  O   THR    91      -9.805  12.750  17.586  1.00 66.05           O  
ATOM    704  CB  THR    91      -7.056  11.851  17.277  1.00 66.58           C  
ATOM    705  OG1 THR    91      -5.648  11.653  17.532  1.00 64.66           O  
ATOM    706  CG2 THR    91      -7.383  11.512  15.802  1.00 64.38           C  
ATOM    707  N   ASP    92      -9.184  14.951  17.407  1.00 66.79           N  
ATOM    708  CA  ASP    92     -10.499  15.528  17.320  1.00 65.30           C  
ATOM    709  C   ASP    92     -10.811  15.527  15.826  1.00 65.43           C  
ATOM    710  O   ASP    92     -10.123  16.230  15.077  1.00 65.65           O  
ATOM    711  CB  ASP    92     -10.516  16.960  17.880  1.00 64.41           C  
ATOM    712  CG  ASP    92     -11.928  17.619  17.866  1.00 66.57           C  
ATOM    713  OD1 ASP    92     -12.837  17.213  17.098  1.00 62.25           O  
ATOM    714  OD2 ASP    92     -12.124  18.592  18.634  1.00 68.03           O  
ATOM    715  N   PRO    93     -11.854  14.773  15.392  1.00 64.19           N  
ATOM    716  CA  PRO    93     -12.262  14.737  13.982  1.00 63.47           C  
ATOM    717  C   PRO    93     -12.436  16.092  13.331  1.00 62.27           C  
ATOM    718  O   PRO    93     -12.122  16.236  12.151  1.00 60.14           O  
ATOM    719  CB  PRO    93     -13.644  14.033  14.017  1.00 62.28           C  
ATOM    720  CG  PRO    93     -13.973  13.845  15.393  1.00 62.35           C  
ATOM    721  CD  PRO    93     -12.741  13.919  16.200  1.00 63.70           C  
ATOM    722  N   ALA    94     -12.990  17.047  14.084  1.00 62.20           N  
ATOM    723  CA  ALA    94     -13.192  18.401  13.580  1.00 62.51           C  
ATOM    724  C   ALA    94     -11.854  19.078  13.309  1.00 61.72           C  
ATOM    725  O   ALA    94     -11.733  19.783  12.318  1.00 61.42           O  
ATOM    726  CB  ALA    94     -14.045  19.242  14.545  1.00 62.99           C  
ATOM    727  N   VAL    95     -10.861  18.857  14.177  1.00 62.04           N  
ATOM    728  CA  VAL    95      -9.512  19.437  13.972  1.00 62.22           C  
ATOM    729  C   VAL    95      -8.829  18.730  12.792  1.00 61.88           C  
ATOM    730  O   VAL    95      -8.248  19.388  11.941  1.00 61.01           O  
ATOM    731  CB  VAL    95      -8.645  19.399  15.222  1.00 62.15           C  
ATOM    732  CG1 VAL    95      -7.285  20.045  14.939  1.00 62.94           C  
ATOM    733  CG2 VAL    95      -9.347  20.119  16.363  1.00 59.03           C  
ATOM    734  N   VAL    96      -8.946  17.402  12.739  1.00 61.69           N  
ATOM    735  CA  VAL    96      -8.433  16.610  11.624  1.00 62.38           C  
ATOM    736  C   VAL    96      -8.931  17.202  10.307  1.00 62.20           C  
ATOM    737  O   VAL    96      -8.125  17.431   9.429  1.00 60.58           O  
ATOM    738  CB  VAL    96      -8.826  15.096  11.729  1.00 61.95           C  
ATOM    739  CG1 VAL    96      -8.649  14.352  10.383  1.00 60.55           C  
ATOM    740  CG2 VAL    96      -8.025  14.423  12.832  1.00 61.12           C  
ATOM    741  N   ASP    97     -10.236  17.480  10.219  1.00 63.00           N  
ATOM    742  CA  ASP    97     -10.858  18.070   9.026  1.00 64.24           C  
ATOM    743  C   ASP    97     -10.265  19.399   8.616  1.00 63.53           C  
ATOM    744  O   ASP    97      -9.943  19.574   7.468  1.00 63.50           O  
ATOM    745  CB  ASP    97     -12.379  18.258   9.201  1.00 65.15           C  
ATOM    746  CG  ASP    97     -13.150  16.958   9.125  1.00 71.53           C  
ATOM    747  OD1 ASP    97     -12.846  16.116   8.246  1.00 76.19           O  
ATOM    748  OD2 ASP    97     -14.106  16.798   9.921  1.00 80.54           O  
ATOM    749  N   ARG    98     -10.137  20.319   9.560  1.00 64.71           N  
ATOM    750  CA  ARG    98      -9.585  21.664   9.297  1.00 66.64           C  
ATOM    751  C   ARG    98      -8.117  21.652   8.884  1.00 65.82           C  
ATOM    752  O   ARG    98      -7.730  22.345   7.952  1.00 66.83           O  
ATOM    753  CB  ARG    98      -9.763  22.569  10.526  1.00 66.66           C  
ATOM    754  CG  ARG    98     -11.253  22.861  10.798  1.00 71.03           C  
ATOM    755  CD  ARG    98     -11.517  23.743  11.998  1.00 69.73           C  
ATOM    756  NE  ARG    98     -10.833  23.306  13.216  1.00 75.27           N  
ATOM    757  CZ  ARG    98     -11.032  23.817  14.430  1.00 77.58           C  
ATOM    758  NH1 ARG    98     -11.949  24.771  14.646  1.00 86.21           N  
ATOM    759  NH2 ARG    98     -10.327  23.344  15.457  1.00 76.48           N  
ATOM    760  N   LEU    99      -7.308  20.866   9.584  1.00 64.51           N  
ATOM    761  CA  LEU    99      -5.885  20.755   9.277  1.00 63.88           C  
ATOM    762  C   LEU    99      -5.584  19.870   8.068  1.00 63.94           C  
ATOM    763  O   LEU    99      -4.462  19.897   7.571  1.00 63.94           O  
ATOM    764  CB  LEU    99      -5.115  20.237  10.488  1.00 62.08           C  
ATOM    765  CG  LEU    99      -5.236  21.082  11.741  1.00 59.09           C  
ATOM    766  CD1 LEU    99      -4.488  20.403  12.860  1.00 62.82           C  
ATOM    767  CD2 LEU    99      -4.698  22.491  11.510  1.00 60.05           C  
ATOM    768  N   TRP   100      -6.563  19.093   7.604  1.00 64.23           N  
ATOM    769  CA  TRP   100      -6.368  18.208   6.457  1.00 64.94           C  
ATOM    770  C   TRP   100      -5.943  18.993   5.196  1.00 66.40           C  
ATOM    771  O   TRP   100      -6.492  20.062   4.904  1.00 66.40           O  
ATOM    772  CB  TRP   100      -7.647  17.416   6.134  1.00 63.32           C  
ATOM    773  CG  TRP   100      -7.401  16.171   5.391  1.00 60.10           C  
ATOM    774  CD1 TRP   100      -7.703  15.915   4.101  1.00 60.68           C  
ATOM    775  CD2 TRP   100      -6.792  14.995   5.907  1.00 56.49           C  
ATOM    776  NE1 TRP   100      -7.326  14.642   3.770  1.00 59.73           N  
ATOM    777  CE2 TRP   100      -6.761  14.052   4.866  1.00 58.04           C  
ATOM    778  CE3 TRP   100      -6.253  14.649   7.155  1.00 61.51           C  
ATOM    779  CZ2 TRP   100      -6.218  12.773   5.025  1.00 60.05           C  
ATOM    780  CZ3 TRP   100      -5.722  13.370   7.323  1.00 62.28           C  
ATOM    781  CH2 TRP   100      -5.711  12.446   6.257  1.00 61.37           C  
ATOM    782  N   ASN   101      -4.936  18.470   4.507  1.00 67.33           N  
ATOM    783  CA  ASN   101      -4.440  19.036   3.242  1.00 68.25           C  
ATOM    784  C   ASN   101      -3.796  17.912   2.420  1.00 68.25           C  
ATOM    785  O   ASN   101      -3.561  16.831   2.975  1.00 67.18           O  
ATOM    786  CB  ASN   101      -3.521  20.244   3.506  1.00 68.78           C  
ATOM    787  CG  ASN   101      -2.252  19.891   4.277  1.00 70.98           C  
ATOM    788  OD1 ASN   101      -1.543  18.923   3.967  1.00 73.81           O  
ATOM    789  ND2 ASN   101      -1.942  20.711   5.265  1.00 69.56           N  
ATOM    790  N   PRO   102      -3.482  18.158   1.120  1.00 69.56           N  
ATOM    791  CA  PRO   102      -2.961  17.054   0.312  1.00 69.80           C  
ATOM    792  C   PRO   102      -1.602  16.513   0.768  1.00 69.69           C  
ATOM    793  O   PRO   102      -1.349  15.316   0.605  1.00 68.78           O  
ATOM    794  CB  PRO   102      -2.912  17.648  -1.100  1.00 71.45           C  
ATOM    795  CG  PRO   102      -3.715  18.929  -1.024  1.00 71.12           C  
ATOM    796  CD  PRO   102      -3.516  19.407   0.334  1.00 69.40           C  
ATOM    797  N   TYR   103      -0.779  17.369   1.396  1.00 70.60           N  
ATOM    798  CA  TYR   103       0.528  16.945   1.919  1.00 71.40           C  
ATOM    799  C   TYR   103       0.273  15.894   3.022  1.00 71.59           C  
ATOM    800  O   TYR   103       0.827  14.796   2.953  1.00 72.12           O  
ATOM    801  CB  TYR   103       1.380  18.111   2.457  1.00 73.01           C  
ATOM    802  CG  TYR   103       1.556  19.319   1.541  1.00 74.63           C  
ATOM    803  CD1 TYR   103       2.579  19.359   0.586  1.00 79.83           C  
ATOM    804  CD2 TYR   103       0.718  20.452   1.662  1.00 77.56           C  
ATOM    805  CE1 TYR   103       2.757  20.503  -0.267  1.00 79.67           C  
ATOM    806  CE2 TYR   103       0.880  21.594   0.828  1.00 76.18           C  
ATOM    807  CZ  TYR   103       1.906  21.615  -0.131  1.00 78.35           C  
ATOM    808  OH  TYR   103       2.081  22.714  -0.952  1.00 74.78           O  
ATOM    809  N   VAL   104      -0.611  16.207   3.979  1.00 71.00           N  
ATOM    810  CA  VAL   104      -0.982  15.253   5.050  1.00 71.32           C  
ATOM    811  C   VAL   104      -1.676  14.042   4.448  1.00 71.94           C  
ATOM    812  O   VAL   104      -1.395  12.913   4.856  1.00 72.55           O  
ATOM    813  CB  VAL   104      -1.908  15.868   6.153  1.00 70.76           C  
ATOM    814  CG1 VAL   104      -2.369  14.799   7.148  1.00 69.40           C  
ATOM    815  CG2 VAL   104      -1.195  16.957   6.879  1.00 72.76           C  
ATOM    816  N   ALA   105      -2.593  14.289   3.504  1.00 72.51           N  
ATOM    817  CA  ALA   105      -3.296  13.226   2.771  1.00 74.46           C  
ATOM    818  C   ALA   105      -2.313  12.167   2.258  1.00 75.45           C  
ATOM    819  O   ALA   105      -2.558  10.970   2.436  1.00 76.15           O  
ATOM    820  CB  ALA   105      -4.096  13.809   1.599  1.00 73.94           C  
ATOM    821  N   ALA   106      -1.196  12.631   1.676  1.00 75.72           N  
ATOM    822  CA  ALA   106      -0.115  11.769   1.161  1.00 76.68           C  
ATOM    823  C   ALA   106       0.417  10.723   2.155  1.00 77.50           C  
ATOM    824  O   ALA   106       0.709   9.598   1.754  1.00 78.04           O  
ATOM    825  CB  ALA   106       1.062  12.632   0.649  1.00 76.97           C  
ATOM    826  N   TRP   107       0.529  11.090   3.433  1.00 78.25           N  
ATOM    827  CA  TRP   107       1.049  10.169   4.467  1.00 79.00           C  
ATOM    828  C   TRP   107       0.102   9.052   4.890  1.00 78.50           C  
ATOM    829  O   TRP   107       0.565   8.098   5.518  1.00 78.90           O  
ATOM    830  CB  TRP   107       1.476  10.925   5.735  1.00 81.75           C  
ATOM    831  CG  TRP   107       2.578  11.855   5.503  1.00 85.01           C  
ATOM    832  CD1 TRP   107       2.472  13.167   5.177  1.00 88.16           C  
ATOM    833  CD2 TRP   107       3.974  11.559   5.560  1.00 88.53           C  
ATOM    834  NE1 TRP   107       3.719  13.726   5.022  1.00 89.70           N  
ATOM    835  CE2 TRP   107       4.666  12.763   5.255  1.00 92.17           C  
ATOM    836  CE3 TRP   107       4.718  10.396   5.839  1.00 88.93           C  
ATOM    837  CZ2 TRP   107       6.084  12.843   5.228  1.00 91.14           C  
ATOM    838  CZ3 TRP   107       6.137  10.467   5.806  1.00 88.41           C  
ATOM    839  CH2 TRP   107       6.797  11.688   5.499  1.00 88.94           C  
ATOM    840  N   TYR   108      -1.190   9.156   4.569  1.00 77.70           N  
ATOM    841  CA  TYR   108      -2.183   8.176   5.020  1.00 77.58           C  
ATOM    842  C   TYR   108      -2.958   7.561   3.853  1.00 78.24           C  
ATOM    843  O   TYR   108      -3.724   8.266   3.183  1.00 78.55           O  
ATOM    844  CB  TYR   108      -3.168   8.840   5.999  1.00 76.95           C  
ATOM    845  CG  TYR   108      -2.543   9.466   7.239  1.00 75.66           C  
ATOM    846  CD1 TYR   108      -2.285   8.702   8.386  1.00 74.93           C  
ATOM    847  CD2 TYR   108      -2.242  10.831   7.280  1.00 73.90           C  
ATOM    848  CE1 TYR   108      -1.713   9.278   9.538  1.00 73.25           C  
ATOM    849  CE2 TYR   108      -1.677  11.424   8.432  1.00 75.10           C  
ATOM    850  CZ  TYR   108      -1.418  10.639   9.556  1.00 73.87           C  
ATOM    851  OH  TYR   108      -0.877  11.208  10.686  1.00 71.72           O  
ATOM    852  N   GLU   109      -2.759   6.256   3.622  1.00 78.29           N  
ATOM    853  CA  GLU   109      -3.483   5.521   2.577  1.00 78.32           C  
ATOM    854  C   GLU   109      -4.983   5.426   2.914  1.00 78.59           C  
ATOM    855  O   GLU   109      -5.822   5.547   2.021  1.00 79.15           O  
ATOM    856  CB  GLU   109      -2.895   4.118   2.367  1.00 78.53           C  
ATOM    857  N   GLY   110      -5.307   5.230   4.198  1.00 78.33           N  
ATOM    858  CA  GLY   110      -6.699   5.168   4.674  1.00 77.97           C  
ATOM    859  C   GLY   110      -7.416   6.508   4.868  1.00 77.86           C  
ATOM    860  O   GLY   110      -8.599   6.516   5.253  1.00 77.81           O  
ATOM    861  N   GLY   111      -6.713   7.627   4.626  1.00 77.37           N  
ATOM    862  CA  GLY   111      -7.273   8.973   4.753  1.00 76.88           C  
ATOM    863  C   GLY   111      -7.530   9.338   6.201  1.00 76.06           C  
ATOM    864  O   GLY   111      -6.775   8.942   7.078  1.00 76.40           O  
ATOM    865  N   LYS   112      -8.615  10.066   6.443  1.00 75.40           N  
ATOM    866  CA  LYS   112      -9.004  10.499   7.793  1.00 75.45           C  
ATOM    867  C   LYS   112      -9.533   9.346   8.669  1.00 76.00           C  
ATOM    868  O   LYS   112      -9.520   9.440   9.906  1.00 76.72           O  
ATOM    869  CB  LYS   112     -10.073  11.591   7.711  1.00 75.43           C  
ATOM    870  CG  LYS   112      -9.662  12.859   6.981  1.00 74.16           C  
ATOM    871  CD  LYS   112     -10.866  13.731   6.775  1.00 74.95           C  
ATOM    872  CE  LYS   112     -10.520  14.996   6.064  1.00 76.57           C  
ATOM    873  NZ  LYS   112     -11.749  15.771   5.752  1.00 82.34           N  
ATOM    874  N   ASP   113     -10.034   8.295   8.025  1.00 75.85           N  
ATOM    875  CA  ASP   113     -10.531   7.089   8.701  1.00 76.36           C  
ATOM    876  C   ASP   113      -9.419   6.097   9.050  1.00 76.13           C  
ATOM    877  O   ASP   113      -9.698   5.091   9.718  1.00 75.33           O  
ATOM    878  CB  ASP   113     -11.555   6.366   7.811  1.00 77.25           C  
ATOM    879  CG  ASP   113     -12.774   7.212   7.529  1.00 79.58           C  
ATOM    880  OD1 ASP   113     -13.497   7.558   8.498  1.00 80.73           O  
ATOM    881  OD2 ASP   113     -13.026   7.506   6.337  1.00 82.08           O  
ATOM    882  N   ASP   114      -8.188   6.359   8.578  1.00 76.33           N  
ATOM    883  CA  ASP   114      -7.018   5.509   8.839  1.00 76.24           C  
ATOM    884  C   ASP   114      -6.921   5.261  10.363  1.00 76.47           C  
ATOM    885  O   ASP   114      -6.805   6.235  11.123  1.00 76.72           O  
ATOM    886  CB  ASP   114      -5.731   6.165   8.295  1.00 76.13           C  
ATOM    887  CG  ASP   114      -4.517   5.220   8.278  1.00 76.90           C  
ATOM    888  OD1 ASP   114      -4.320   4.422   9.229  1.00 77.06           O  
ATOM    889  OD2 ASP   114      -3.726   5.312   7.302  1.00 76.48           O  
ATOM    890  N   PRO   115      -7.053   3.979  10.813  1.00 76.23           N  
ATOM    891  CA  PRO   115      -6.917   3.620  12.241  1.00 75.60           C  
ATOM    892  C   PRO   115      -5.544   3.998  12.811  1.00 75.10           C  
ATOM    893  O   PRO   115      -5.455   4.418  13.978  1.00 74.61           O  
ATOM    894  CB  PRO   115      -7.089   2.098  12.244  1.00 75.83           C  
ATOM    895  CG  PRO   115      -7.773   1.789  10.988  1.00 76.33           C  
ATOM    896  CD  PRO   115      -7.345   2.783   9.999  1.00 76.11           C  
ATOM    897  N   LYS   116      -4.503   3.888  11.970  1.00 74.15           N  
ATOM    898  CA  LYS   116      -3.137   4.270  12.319  1.00 73.62           C  
ATOM    899  C   LYS   116      -2.886   5.793  12.175  1.00 73.82           C  
ATOM    900  O   LYS   116      -1.837   6.193  11.660  1.00 74.05           O  
ATOM    901  CB  LYS   116      -2.134   3.488  11.457  1.00 73.64           C  
ATOM    902  N   LEU   117      -3.836   6.627  12.627  1.00 72.81           N  
ATOM    903  CA  LEU   117      -3.703   8.090  12.600  1.00 72.20           C  
ATOM    904  C   LEU   117      -3.889   8.641  14.013  1.00 70.18           C  
ATOM    905  O   LEU   117      -4.798   8.224  14.761  1.00 70.07           O  
ATOM    906  CB  LEU   117      -4.690   8.779  11.622  1.00 72.07           C  
ATOM    907  CG  LEU   117      -4.478  10.312  11.431  1.00 71.77           C  
ATOM    908  CD1 LEU   117      -4.834  10.788  10.027  1.00 70.09           C  
ATOM    909  CD2 LEU   117      -5.202  11.157  12.477  1.00 65.73           C  
ATOM    910  N   ALA   118      -3.007   9.582  14.347  1.00 68.08           N  
ATOM    911  CA  ALA   118      -3.020  10.297  15.612  1.00 65.82           C  
ATOM    912  C   ALA   118      -2.637  11.745  15.329  1.00 63.61           C  
ATOM    913  O   ALA   118      -1.849  12.033  14.426  1.00 61.85           O  
ATOM    914  CB  ALA   118      -2.051   9.666  16.594  1.00 64.77           C  
ATOM    915  N   LEU   119      -3.225  12.638  16.106  1.00 62.76           N  
ATOM    916  CA  LEU   119      -2.966  14.050  16.023  1.00 61.29           C  
ATOM    917  C   LEU   119      -2.557  14.502  17.420  1.00 62.26           C  
ATOM    918  O   LEU   119      -3.339  14.377  18.364  1.00 63.42           O  
ATOM    919  CB  LEU   119      -4.235  14.755  15.566  1.00 60.40           C  
ATOM    920  CG  LEU   119      -4.172  16.242  15.293  1.00 59.44           C  
ATOM    921  CD1 LEU   119      -3.043  16.591  14.297  1.00 52.48           C  
ATOM    922  CD2 LEU   119      -5.552  16.736  14.813  1.00 59.31           C  
ATOM    923  N   LEU   120      -1.327  14.991  17.549  1.00 61.72           N  
ATOM    924  CA  LEU   120      -0.807  15.499  18.812  1.00 61.86           C  
ATOM    925  C   LEU   120      -0.988  17.008  18.872  1.00 61.72           C  
ATOM    926  O   LEU   120      -0.861  17.664  17.838  1.00 61.15           O  
ATOM    927  CB  LEU   120       0.696  15.185  18.941  1.00 61.56           C  
ATOM    928  CG  LEU   120       1.129  13.731  18.723  1.00 60.31           C  
ATOM    929  CD1 LEU   120       2.615  13.582  19.060  1.00 56.29           C  
ATOM    930  CD2 LEU   120       0.279  12.778  19.543  1.00 55.20           C  
ATOM    931  N   ARG   121      -1.297  17.544  20.061  1.00 61.18           N  
ATOM    932  CA  ARG   121      -1.330  19.005  20.282  1.00 61.97           C  
ATOM    933  C   ARG   121      -0.284  19.405  21.302  1.00 61.10           C  
ATOM    934  O   ARG   121      -0.164  18.793  22.366  1.00 60.42           O  
ATOM    935  CB  ARG   121      -2.700  19.574  20.687  1.00 61.52           C  
ATOM    936  CG  ARG   121      -3.293  19.113  21.975  1.00 63.20           C  
ATOM    937  CD  ARG   121      -4.717  19.648  22.120  1.00 63.33           C  
ATOM    938  NE  ARG   121      -4.812  21.045  22.572  1.00 65.57           N  
ATOM    939  CZ  ARG   121      -5.927  21.786  22.566  1.00 62.63           C  
ATOM    940  NH1 ARG   121      -7.074  21.337  22.059  1.00 63.35           N  
ATOM    941  NH2 ARG   121      -5.888  23.032  23.023  1.00 59.07           N  
ATOM    942  N   LEU   122       0.483  20.429  20.934  1.00 60.61           N  
ATOM    943  CA  LEU   122       1.454  21.029  21.778  1.00 59.91           C  
ATOM    944  C   LEU   122       0.805  22.339  22.176  1.00 61.19           C  
ATOM    945  O   LEU   122       0.557  23.218  21.323  1.00 62.19           O  
ATOM    946  CB  LEU   122       2.773  21.234  21.057  1.00 60.23           C  
ATOM    947  CG  LEU   122       3.875  22.062  21.736  1.00 61.37           C  
ATOM    948  CD1 LEU   122       4.141  21.611  23.143  1.00 61.75           C  
ATOM    949  CD2 LEU   122       5.153  21.980  20.891  1.00 60.34           C  
ATOM    950  N   ASP   123       0.434  22.421  23.452  1.00 60.69           N  
ATOM    951  CA  ASP   123      -0.089  23.641  24.028  1.00 61.57           C  
ATOM    952  C   ASP   123       1.141  24.364  24.504  1.00 61.00           C  
ATOM    953  O   ASP   123       1.729  23.994  25.507  1.00 62.72           O  
ATOM    954  CB  ASP   123      -1.094  23.326  25.130  1.00 62.91           C  
ATOM    955  CG  ASP   123      -2.431  22.963  24.555  1.00 66.49           C  
ATOM    956  OD1 ASP   123      -3.034  23.882  23.953  1.00 63.57           O  
ATOM    957  OD2 ASP   123      -2.848  21.793  24.682  1.00 67.70           O  
ATOM    958  N   ALA   124       1.557  25.351  23.721  1.00 62.14           N  
ATOM    959  CA  ALA   124       2.829  26.072  23.923  1.00 62.86           C  
ATOM    960  C   ALA   124       2.719  27.054  25.049  1.00 63.49           C  
ATOM    961  O   ALA   124       1.792  27.847  25.100  1.00 64.38           O  
ATOM    962  CB  ALA   124       3.260  26.792  22.634  1.00 61.47           C  
ATOM    963  N   ASP   125       3.674  27.000  25.958  1.00 64.30           N  
ATOM    964  CA  ASP   125       3.694  27.897  27.090  1.00 64.07           C  
ATOM    965  C   ASP   125       4.555  29.133  26.771  1.00 64.53           C  
ATOM    966  O   ASP   125       4.117  30.277  26.904  1.00 64.73           O  
ATOM    967  CB  ASP   125       4.234  27.152  28.303  1.00 63.65           C  
ATOM    968  CG  ASP   125       4.373  28.044  29.479  1.00 66.71           C  
ATOM    969  OD1 ASP   125       3.326  28.563  29.916  1.00 70.42           O  
ATOM    970  OD2 ASP   125       5.520  28.256  29.920  1.00 67.28           O  
ATOM    971  N   HIS   126       5.806  28.883  26.419  1.00 65.57           N  
ATOM    972  CA  HIS   126       6.746  29.952  26.070  1.00 65.43           C  
ATOM    973  C   HIS   126       7.822  29.426  25.142  1.00 64.29           C  
ATOM    974  O   HIS   126       7.908  28.223  24.892  1.00 63.35           O  
ATOM    975  CB  HIS   126       7.361  30.584  27.332  1.00 65.55           C  
ATOM    976  CG  HIS   126       8.323  29.708  28.080  1.00 66.47           C  
ATOM    977  ND1 HIS   126       7.923  28.833  29.065  1.00 67.28           N  
ATOM    978  CD2 HIS   126       9.676  29.622  28.029  1.00 68.42           C  
ATOM    979  CE1 HIS   126       8.981  28.211  29.556  1.00 67.71           C  
ATOM    980  NE2 HIS   126      10.059  28.681  28.956  1.00 67.36           N  
ATOM    981  N   ALA   127       8.617  30.347  24.624  1.00 63.66           N  
ATOM    982  CA  ALA   127       9.755  30.017  23.787  1.00 63.18           C  
ATOM    983  C   ALA   127      10.903  30.936  24.025  1.00 62.13           C  
ATOM    984  O   ALA   127      10.699  32.131  24.256  1.00 61.43           O  
ATOM    985  CB  ALA   127       9.401  30.070  22.294  1.00 63.21           C  
ATOM    986  N   GLN   128      12.109  30.375  23.930  1.00 61.22           N  
ATOM    987  CA  GLN   128      13.310  31.173  23.934  1.00 61.80           C  
ATOM    988  C   GLN   128      13.686  31.276  22.469  1.00 60.96           C  
ATOM    989  O   GLN   128      13.774  30.260  21.792  1.00 60.64           O  
ATOM    990  CB  GLN   128      14.403  30.566  24.774  1.00 62.50           C  
ATOM    991  CG  GLN   128      15.552  31.516  24.945  1.00 66.72           C  
ATOM    992  CD  GLN   128      16.469  31.161  26.095  1.00 70.40           C  
ATOM    993  OE1 GLN   128      16.385  30.075  26.675  1.00 67.31           O  
ATOM    994  NE2 GLN   128      17.377  32.081  26.412  1.00 65.37           N  
ATOM    995  N   ILE   129      13.879  32.509  21.990  1.00 60.87           N  
ATOM    996  CA  ILE   129      14.139  32.804  20.583  1.00 59.58           C  
ATOM    997  C   ILE   129      15.507  33.475  20.424  1.00 60.07           C  
ATOM    998  O   ILE   129      15.780  34.501  21.060  1.00 60.01           O  
ATOM    999  CB  ILE   129      13.028  33.749  20.040  1.00 59.53           C  
ATOM   1000  CG1 ILE   129      11.651  33.068  20.090  1.00 58.16           C  
ATOM   1001  CG2 ILE   129      13.336  34.198  18.609  1.00 56.19           C  
ATOM   1002  CD1 ILE   129      10.470  34.066  19.975  1.00 59.27           C  
ATOM   1003  N   TRP   130      16.347  32.876  19.580  1.00 60.50           N  
ATOM   1004  CA  TRP   130      17.684  33.370  19.236  1.00 60.23           C  
ATOM   1005  C   TRP   130      17.721  33.703  17.748  1.00 60.63           C  
ATOM   1006  O   TRP   130      17.531  32.811  16.898  1.00 62.63           O  
ATOM   1007  CB  TRP   130      18.751  32.307  19.454  1.00 59.73           C  
ATOM   1008  CG  TRP   130      18.931  31.827  20.827  1.00 62.03           C  
ATOM   1009  CD1 TRP   130      19.893  32.210  21.698  1.00 60.85           C  
ATOM   1010  CD2 TRP   130      18.178  30.795  21.486  1.00 64.35           C  
ATOM   1011  NE1 TRP   130      19.780  31.513  22.862  1.00 60.14           N  
ATOM   1012  CE2 TRP   130      18.740  30.631  22.767  1.00 62.71           C  
ATOM   1013  CE3 TRP   130      17.101  29.976  21.106  1.00 62.95           C  
ATOM   1014  CZ2 TRP   130      18.252  29.687  23.696  1.00 64.49           C  
ATOM   1015  CZ3 TRP   130      16.620  29.038  22.023  1.00 61.66           C  
ATOM   1016  CH2 TRP   130      17.190  28.906  23.307  1.00 62.93           C  
ATOM   1017  N   LEU   131      17.936  34.971  17.435  1.00 60.43           N  
ATOM   1018  CA  LEU   131      18.156  35.403  16.058  1.00 60.89           C  
ATOM   1019  C   LEU   131      19.648  35.171  15.734  1.00 61.72           C  
ATOM   1020  O   LEU   131      20.522  35.294  16.604  1.00 60.15           O  
ATOM   1021  CB  LEU   131      17.815  36.875  15.870  1.00 58.93           C  
ATOM   1022  CG  LEU   131      16.405  37.315  16.295  1.00 61.09           C  
ATOM   1023  CD1 LEU   131      16.237  38.841  16.084  1.00 49.80           C  
ATOM   1024  CD2 LEU   131      15.306  36.515  15.580  1.00 53.92           C  
ATOM   1025  N   ASN   132      19.921  34.791  14.490  1.00 62.74           N  
ATOM   1026  CA  ASN   132      21.279  34.608  14.027  1.00 63.75           C  
ATOM   1027  C   ASN   132      21.623  35.951  13.364  1.00 65.20           C  
ATOM   1028  O   ASN   132      21.063  36.292  12.333  1.00 66.63           O  
ATOM   1029  CB  ASN   132      21.339  33.424  13.067  1.00 63.10           C  
ATOM   1030  CG  ASN   132      22.756  32.937  12.771  1.00 64.38           C  
ATOM   1031  OD1 ASN   132      23.739  33.313  13.410  1.00 66.90           O  
ATOM   1032  ND2 ASN   132      22.847  32.049  11.799  1.00 65.55           N  
ATOM   1033  N   GLY   133      22.472  36.738  14.019  1.00 65.89           N  
ATOM   1034  CA  GLY   133      22.928  38.033  13.513  1.00 65.80           C  
ATOM   1035  C   GLY   133      24.273  37.866  12.840  1.00 65.28           C  
ATOM   1036  O   GLY   133      24.550  36.815  12.252  1.00 66.27           O  
ATOM   1037  N   SER   134      25.112  38.891  12.925  1.00 64.55           N  
ATOM   1038  CA  SER   134      26.453  38.833  12.348  1.00 64.53           C  
ATOM   1039  C   SER   134      27.446  39.623  13.187  1.00 64.39           C  
ATOM   1040  O   SER   134      27.038  40.511  13.912  1.00 64.78           O  
ATOM   1041  CB  SER   134      26.413  39.349  10.905  1.00 64.99           C  
ATOM   1042  OG  SER   134      26.081  40.730  10.848  1.00 65.96           O  
ATOM   1043  N   SER   135      28.729  39.267  13.116  1.00 64.44           N  
ATOM   1044  CA  SER   135      29.785  39.989  13.830  1.00 65.34           C  
ATOM   1045  C   SER   135      30.841  40.437  12.807  1.00 63.57           C  
ATOM   1046  O   SER   135      31.427  39.600  12.109  1.00 63.08           O  
ATOM   1047  CB  SER   135      30.426  39.147  14.963  1.00 66.54           C  
ATOM   1048  OG  SER   135      31.524  38.337  14.532  1.00 70.43           O  
ATOM   1049  N   LEU   136      31.081  41.746  12.736  1.00 61.69           N  
ATOM   1050  CA  LEU   136      32.059  42.296  11.812  1.00 61.12           C  
ATOM   1051  C   LEU   136      33.433  42.072  12.430  1.00 59.81           C  
ATOM   1052  O   LEU   136      33.646  42.445  13.582  1.00 60.39           O  
ATOM   1053  CB  LEU   136      31.823  43.796  11.594  1.00 61.14           C  
ATOM   1054  CG  LEU   136      32.442  44.352  10.313  1.00 61.78           C  
ATOM   1055  CD1 LEU   136      31.538  44.017   9.124  1.00 59.14           C  
ATOM   1056  CD2 LEU   136      32.657  45.865  10.408  1.00 61.99           C  
ATOM   1057  N   LEU   137      34.342  41.435  11.694  1.00 58.51           N  
ATOM   1058  CA  LEU   137      35.707  41.216  12.179  1.00 58.04           C  
ATOM   1059  C   LEU   137      36.523  42.492  12.002  1.00 57.44           C  
ATOM   1060  O   LEU   137      36.082  43.443  11.352  1.00 57.36           O  
ATOM   1061  CB  LEU   137      36.422  40.064  11.452  1.00 58.32           C  
ATOM   1062  CG  LEU   137      35.743  38.699  11.251  1.00 59.84           C  
ATOM   1063  CD1 LEU   137      36.827  37.625  11.029  1.00 60.58           C  
ATOM   1064  CD2 LEU   137      34.883  38.315  12.395  1.00 60.91           C  
ATOM   1065  N   ALA   138      37.714  42.499  12.595  1.00 57.39           N  
ATOM   1066  CA  ALA   138      38.658  43.610  12.468  1.00 57.25           C  
ATOM   1067  C   ALA   138      39.122  43.692  11.017  1.00 57.29           C  
ATOM   1068  O   ALA   138      39.334  42.657  10.371  1.00 56.94           O  
ATOM   1069  CB  ALA   138      39.857  43.420  13.392  1.00 56.76           C  
ATOM   1070  N   GLY   139      39.247  44.917  10.509  1.00 57.45           N  
ATOM   1071  CA  GLY   139      39.658  45.141   9.138  1.00 57.98           C  
ATOM   1072  C   GLY   139      41.117  44.779   8.936  1.00 59.06           C  
ATOM   1073  O   GLY   139      41.933  44.939   9.852  1.00 59.88           O  
ATOM   1074  N   ILE   140      41.433  44.283   7.740  1.00 59.80           N  
ATOM   1075  CA  ILE   140      42.794  43.886   7.364  1.00 59.77           C  
ATOM   1076  C   ILE   140      43.141  44.612   6.080  1.00 60.20           C  
ATOM   1077  O   ILE   140      42.533  44.341   5.040  1.00 59.84           O  
ATOM   1078  CB  ILE   140      42.888  42.359   7.163  1.00 59.89           C  
ATOM   1079  CG1 ILE   140      42.524  41.634   8.472  1.00 59.59           C  
ATOM   1080  CG2 ILE   140      44.284  41.959   6.679  1.00 57.61           C  
ATOM   1081  CD1 ILE   140      42.558  40.124   8.388  1.00 60.05           C  
ATOM   1082  N   LYS   141      44.089  45.550   6.166  1.00 61.05           N  
ATOM   1083  CA  LYS   141      44.551  46.308   5.004  1.00 61.39           C  
ATOM   1084  C   LYS   141      45.505  45.436   4.196  1.00 61.80           C  
ATOM   1085  O   LYS   141      46.435  44.863   4.758  1.00 61.94           O  
ATOM   1086  CB  LYS   141      45.220  47.636   5.395  1.00 61.26           C  
ATOM   1087  CG  LYS   141      44.261  48.637   6.051  1.00 60.97           C  
ATOM   1088  CD  LYS   141      44.626  50.104   5.782  1.00 62.29           C  
ATOM   1089  CE  LYS   141      45.887  50.578   6.490  1.00 64.00           C  
ATOM   1090  NZ  LYS   141      45.648  50.668   7.955  1.00 66.94           N  
ATOM   1091  N   VAL   142      45.263  45.347   2.886  1.00 62.47           N  
ATOM   1092  CA  VAL   142      46.056  44.518   1.960  1.00 62.73           C  
ATOM   1093  C   VAL   142      46.397  45.304   0.688  1.00 62.79           C  
ATOM   1094  O   VAL   142      45.686  46.247   0.341  1.00 63.25           O  
ATOM   1095  CB  VAL   142      45.279  43.192   1.617  1.00 62.84           C  
ATOM   1096  CG1 VAL   142      43.942  43.483   0.942  1.00 61.54           C  
ATOM   1097  CG2 VAL   142      46.118  42.251   0.754  1.00 62.99           C  
ATOM   1098  N   LEU   143      47.503  44.942   0.031  1.00 62.93           N  
ATOM   1099  CA  LEU   143      47.899  45.541  -1.257  1.00 62.76           C  
ATOM   1100  C   LEU   143      47.322  44.669  -2.384  1.00 63.19           C  
ATOM   1101  O   LEU   143      47.264  43.442  -2.251  1.00 63.43           O  
ATOM   1102  CB  LEU   143      49.418  45.684  -1.374  1.00 62.31           C  
ATOM   1103  CG  LEU   143      50.110  46.684  -0.431  1.00 61.86           C  
ATOM   1104  CD1 LEU   143      51.635  46.657  -0.621  1.00 56.90           C  
ATOM   1105  CD2 LEU   143      49.587  48.107  -0.615  1.00 60.19           C  
ATOM   1106  N   LEU   144      46.890  45.314  -3.474  1.00 63.28           N  
ATOM   1107  CA  LEU   144      46.237  44.652  -4.623  1.00 63.02           C  
ATOM   1108  C   LEU   144      47.069  44.717  -5.899  1.00 62.91           C  
ATOM   1109  O   LEU   144      47.958  45.564  -6.018  1.00 63.42           O  
ATOM   1110  CB  LEU   144      44.884  45.320  -4.886  1.00 63.08           C  
ATOM   1111  CG  LEU   144      43.824  45.246  -3.788  1.00 60.34           C  
ATOM   1112  CD1 LEU   144      42.664  46.175  -4.098  1.00 57.50           C  
ATOM   1113  CD2 LEU   144      43.346  43.822  -3.622  1.00 61.41           C  
ATOM   1114  N   GLY   145      46.763  43.832  -6.853  1.00 62.92           N  
ATOM   1115  CA  GLY   145      47.483  43.799  -8.134  1.00 63.90           C  
ATOM   1116  C   GLY   145      47.247  42.592  -9.027  1.00 64.09           C  
ATOM   1117  O   GLY   145      47.895  42.477 -10.091  1.00 63.32           O  
END
