
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms  140 ( 1133),  selected  140 , name 2i02_A
# Molecule2: number of CA atoms  145 ( 1098),  selected  145 , name T0497.pdb
# PARAMETERS: 2i02_A.T0497.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    T     5_A      M       1           -
LGA    -       -      A       2           -
LGA    -       -      D       3           -
LGA    D     6_A      P       4           #
LGA    R     7_A      -       -           -
LGA    T     8_A      K       5           #
LGA    Q     9_A      E       6          6.253
LGA    E    10_A      L       7          6.112
LGA    I    11_A      Q       8          4.644
LGA    Q    12_A      D       9          2.582
LGA    K    13_A      K      10          3.470
LGA    L    14_A      F      11          2.593
LGA    H    15_A      W      12          1.408
LGA    E    16_A      K      13          2.691
LGA    L    17_A      A      14          3.383
LGA    I    18_A      L      15          1.947
LGA    K    19_A      K      16          2.775
LGA    N    20_A      S      17          2.479
LGA    I    21_A      D      18          1.244
LGA    D    22_A      R      19          3.131
LGA    Y    23_A      T      20          1.728
LGA    G    24_A      V      21          1.623
LGA    X    25_A      M      22          1.002
LGA    F    26_A      L      23          1.333
LGA    T    27_A      G      24          1.116
LGA    T    28_A      L      25          1.576
LGA    V    29_A      D      26          4.617
LGA    D    30_A      -       -           -
LGA    D    31_A      -       -           -
LGA    D    32_A      G      27           #
LGA    G    33_A      V      28          2.458
LGA    S    34_A      E      29          1.568
LGA    L    35_A      D      30          3.489
LGA    -       -      G      31           -
LGA    H    36_A      H      32          1.904
LGA    S    37_A      A      33          0.754
LGA    Y    38_A      R      34          1.157
LGA    P    39_A      P      35          1.356
LGA    X    40_A      M      36          0.690
LGA    S    41_A      T      37          1.254
LGA    K    42_A      A      38          1.512
LGA    S    43_A      Q      39          1.805
LGA    G    44_A      I      40          2.919
LGA    -       -      E      41           -
LGA    -       -      G      42           -
LGA    D    45_A      D      43          4.172
LGA    E    49_A      S      44          6.022
LGA    A    50_A      G      45          3.532
LGA    T    51_A      G      46          1.725
LGA    -       -      P      47           -
LGA    L    52_A      I      48          0.625
LGA    W    53_A      W      49          0.655
LGA    F    54_A      F      50          0.689
LGA    F    55_A      F      51          1.011
LGA    T    56_A      T      52          1.852
LGA    Y    57_A      S      53          2.668
LGA    A    58_A      K      54          3.383
LGA    G    59_A      D      55          4.100
LGA    S    60_A      N      56          2.676
LGA    H    61_A      A      57          1.781
LGA    K    62_A      L      58          0.816
LGA    V    63_A      I      59          0.776
LGA    T    64_A      A      60          1.335
LGA    E    65_A      M      61          2.178
LGA    I    66_A      L      62          2.241
LGA    E    67_A      G      63          2.530
LGA    H    68_A      Q      64           -
LGA    H    69_A      G      65           #
LGA    E    70_A      R      66          0.606
LGA    Q    71_A      R      67          0.564
LGA    V    72_A      V      68          0.881
LGA    N    73_A      I      69          1.536
LGA    V    74_A      G      70          1.442
LGA    S    75_A      A      71          1.582
LGA    F    76_A      F      72          1.563
LGA    S    77_A      S      73          1.878
LGA    S    78_A      S      74          3.717
LGA    P    79_A      K      75           #
LGA    E    80_A      G      76          2.114
LGA    Q    81_A      H      77          3.881
LGA    Q    82_A      D      78          1.912
LGA    R    83_A      L      79          2.020
LGA    Y    84_A      F      80          1.537
LGA    V    85_A      A      81          1.489
LGA    S    86_A      S      82          1.104
LGA    I    87_A      I      83          0.779
LGA    S    88_A      S      84          0.896
LGA    G    89_A      G      85          0.792
LGA    T    90_A      S      86          0.505
LGA    S    91_A      L      87          0.990
LGA    Q    92_A      R      88          1.581
LGA    L    93_A      E      89          0.913
LGA    V    94_A      D      90          0.410
LGA    K    95_A      T      91          2.109
LGA    D    96_A      D      92          0.918
LGA    R    97_A      P      93          0.315
LGA    N    98_A      A      94          0.695
LGA    K    99_A      V      95          0.601
LGA    X   100_A      V      96          0.580
LGA    R   101_A      D      97          0.556
LGA    E   102_A      R      98          0.229
LGA    L   103_A      L      99          0.524
LGA    W   104_A      W     100          1.319
LGA    K   105_A      N     101          1.685
LGA    P   106_A      P     102          1.079
LGA    E   107_A      Y     103          0.966
LGA    L   108_A      V     104          1.851
LGA    Q   109_A      A     105          3.437
LGA    T   110_A      A     106          4.065
LGA    W   111_A      W     107          3.026
LGA    F   112_A      Y     108          2.341
LGA    P   113_A      E     109          2.646
LGA    K   114_A      G     110          2.221
LGA    G   115_A      G     111          2.388
LGA    L   116_A      K     112          1.031
LGA    D   117_A      D     113          2.088
LGA    E   118_A      D     114          0.896
LGA    P   119_A      P     115          1.257
LGA    D   120_A      K     116          3.068
LGA    I   121_A      L     117          1.355
LGA    A   122_A      A     118          2.391
LGA    L   123_A      L     119          1.313
LGA    L   124_A      L     120          0.848
LGA    K   125_A      R     121          0.837
LGA    V   126_A      L     122          0.623
LGA    N   127_A      D     123          0.971
LGA    I   128_A      A     124          0.888
LGA    N   129_A      D     125          1.208
LGA    Q   130_A      H     126          1.499
LGA    V   131_A      A     127          0.854
LGA    N   132_A      Q     128          1.150
LGA    Y   133_A      I     129          1.736
LGA    W   134_A      W     130          1.541
LGA    D   135_A      L     131          1.438
LGA    S   136_A      N     132          3.322
LGA    T   137_A      -       -           -
LGA    S   138_A      -       -           -
LGA    S   139_A      -       -           -
LGA    F   140_A      G     133          4.863
LGA    K   141_A      S     134           -
LGA    P   142_A      S     135           -
LGA    Q   143_A      L     136           -
LGA    T   144_A      L     137           -
LGA    I   145_A      A     138           -
LGA    S   146_A      G     139           -
LGA    F   147_A      I     140           -
LGA    -       -      K     141           -
LGA    -       -      V     142           -
LGA    -       -      L     143           -
LGA    -       -      L     144           -
LGA    -       -      G     145           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)  140  145    5.0    120    2.26    24.17     63.196     5.079

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.974916 * X  +  -0.007199 * Y  +  -0.222456 * Z  +  36.808235
  Y_new =   0.124684 * X  +  -0.845589 * Y  +  -0.519069 * Z  +  46.956108
  Z_new =  -0.184370 * X  +  -0.533785 * Y  +   0.825276 * Z  +  22.786978 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.574119    2.567473  [ DEG:   -32.8946    147.1054 ]
  Theta =   0.185430    2.956162  [ DEG:    10.6244    169.3756 ]
  Phi   =   3.014391   -0.127202  [ DEG:   172.7119     -7.2881 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2i02_A                                        
REMARK     2: T0497.pdb                                     
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2i02_A.T0497.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:  140  145   5.0  120   2.26   24.17  63.196
REMARK  ---------------------------------------------------------- 
MOLECULE 2i02_A
HEADER    STRUCTURAL GENOMICS, UNKNOWN FUNCTION   09-AUG-06   2I02              
TITLE     CRYSTAL STRUCTURE OF GENERAL STRESS PROTEIN OF COG3871                
TITLE    2 (ZP_00108720.1) FROM NOSTOC PUNCTIFORME PCC 73102 AT 1.80            
TITLE    3 A RESOLUTION                                                         
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: GENERAL STRESS PROTEIN OF COG3871;                         
COMPND   3 CHAIN: A, B;                                                         
COMPND   4 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: NOSTOC PUNCTIFORME PCC 73102;                   
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 GENE: ZP_00108720.1;                                                 
SOURCE   5 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   6 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID                               
KEYWDS    ZP_00108720.1, GENERAL STRESS PROTEIN OF COG3871, ,                   
KEYWDS   2 STRUCTURAL GENOMICS, PSI-2, PROTEIN STRUCTURE INITIATIVE,            
KEYWDS   3 JOINT CENTER FOR STRUCTURAL GENOMICS, JCSG                           
EXPDTA    X-RAY DIFFRACTION                                                     
AUTHOR    JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                           
REVDAT   1   29-AUG-06 2I02    0                                                
JRNL        AUTH   JOINT CENTER FOR STRUCTURAL GENOMICS (JCSG)                  
JRNL        TITL   CRYSTAL STRUCTURE OF GENERAL STRESS PROTEIN OF               
JRNL        TITL 2 COG3871 (ZP_00108720.1) FROM NOSTOC PUNCTIFORME              
JRNL        TITL 3 PCC 73102 AT 1.80 A RESOLUTION                               
JRNL        REF    TO BE PUBLISHED                                              
JRNL        REFN                                                                
REMARK   2 RESOLUTION. 1.80 ANGSTROMS.                                          
DBREF  2I02 A    1   147  UNP    Q8YS45   Q8YS45_ANASP     1    128             
DBREF  2I02 B    1   147  UNP    Q8YS45   Q8YS45_ANASP     1    128             
SEQRES   1 A  148  GLY MSE ALA THR SER THR ASP ARG THR GLN GLU ILE GLN          
SEQRES   2 A  148  LYS LEU HIS GLU LEU ILE LYS ASN ILE ASP TYR GLY MSE          
SEQRES   3 A  148  PHE THR THR VAL ASP ASP ASP GLY SER LEU HIS SER TYR          
SEQRES   4 A  148  PRO MSE SER LYS SER GLY ASP ILE ASN SER GLU ALA THR          
SEQRES   5 A  148  LEU TRP PHE PHE THR TYR ALA GLY SER HIS LYS VAL THR          
SEQRES   6 A  148  GLU ILE GLU HIS HIS GLU GLN VAL ASN VAL SER PHE SER          
SEQRES   7 A  148  SER PRO GLU GLN GLN ARG TYR VAL SER ILE SER GLY THR          
SEQRES   8 A  148  SER GLN LEU VAL LYS ASP ARG ASN LYS MSE ARG GLU LEU          
SEQRES   9 A  148  TRP LYS PRO GLU LEU GLN THR TRP PHE PRO LYS GLY LEU          
SEQRES  10 A  148  ASP GLU PRO ASP ILE ALA LEU LEU LYS VAL ASN ILE ASN          
SEQRES  11 A  148  GLN VAL ASN TYR TRP ASP SER THR SER SER PHE LYS PRO          
SEQRES  12 A  148  GLN THR ILE SER PHE                                          
SEQRES   1 B  148  GLY MSE ALA THR SER THR ASP ARG THR GLN GLU ILE GLN          
SEQRES   2 B  148  LYS LEU HIS GLU LEU ILE LYS ASN ILE ASP TYR GLY MSE          
SEQRES   3 B  148  PHE THR THR VAL ASP ASP ASP GLY SER LEU HIS SER TYR          
SEQRES   4 B  148  PRO MSE SER LYS SER GLY ASP ILE ASN SER GLU ALA THR          
SEQRES   5 B  148  LEU TRP PHE PHE THR TYR ALA GLY SER HIS LYS VAL THR          
SEQRES   6 B  148  GLU ILE GLU HIS HIS GLU GLN VAL ASN VAL SER PHE SER          
SEQRES   7 B  148  SER PRO GLU GLN GLN ARG TYR VAL SER ILE SER GLY THR          
SEQRES   8 B  148  SER GLN LEU VAL LYS ASP ARG ASN LYS MSE ARG GLU LEU          
SEQRES   9 B  148  TRP LYS PRO GLU LEU GLN THR TRP PHE PRO LYS GLY LEU          
SEQRES  10 B  148  ASP GLU PRO ASP ILE ALA LEU LEU LYS VAL ASN ILE ASN          
SEQRES  11 B  148  GLN VAL ASN TYR TRP ASP SER THR SER SER PHE LYS PRO          
SEQRES  12 B  148  GLN THR ILE SER PHE                                          
HET    MSE  A  25       8                                                       
HET    MSE  A  40      13                                                       
HET    MSE  A 100       8                                                       
HET    MSE  B  25       8                                                       
HET    MSE  B  40      13                                                       
HET    MSE  B 100       8                                                       
HET     CL      3       1                                                       
HET    FMN  A 200      31                                                       
HET    P33      1      13                                                       
HET    P33      2       8                                                       
HETNAM     MSE SELENOMETHIONINE                                                 
HETNAM      CL CHLORIDE ION                                                     
HETNAM     FMN FLAVIN MONONUCLEOTIDE                                            
HETNAM     P33 3,6,9,12,15,18-HEXAOXAICOSANE-1,20-DIOL                          
HETSYN     FMN RIBOFLAVIN MONOPHOSPHATE                                         
HETSYN     P33 HEPTAETHYLENE GLYCOL, PEG330                                     
FORMUL   1  MSE    6(C5 H11 N O2 SE)                                            
FORMUL   3   CL    CL 1-                                                        
FORMUL   4  FMN    C17 H21 N4 O9 P                                              
FORMUL   5  P33    2(C14 H30 O8)                                                
FORMUL   7  HOH   *175(H2 O)                                                    
CRYST1  103.646  103.646  109.695  90.00  90.00 120.00 P 63 2 2     24          
ATOM      1  N   THR A   5      -2.093  41.673  22.794  1.00 60.68           N  
ATOM      2  CA  THR A   5      -1.452  42.988  23.118  1.00 61.62           C  
ATOM      3  C   THR A   5       0.046  42.936  22.748  1.00 58.79           C  
ATOM      4  O   THR A   5       0.392  42.767  21.574  1.00 57.66           O  
ATOM      5  CB  THR A   5      -1.691  43.341  24.621  1.00 63.56           C  
ATOM      6  OG1 THR A   5      -0.888  44.474  25.009  1.00 67.43           O  
ATOM      7  CG2 THR A   5      -1.380  42.125  25.530  1.00 63.26           C  
ATOM      8  N   ASP A   6       0.926  43.089  23.737  1.00 55.96           N  
ATOM      9  CA  ASP A   6       2.265  42.528  23.641  1.00 54.32           C  
ATOM     10  C   ASP A   6       2.126  41.041  23.292  1.00 49.77           C  
ATOM     11  O   ASP A   6       2.904  40.518  22.510  1.00 46.71           O  
ATOM     12  CB  ASP A   6       3.040  42.709  24.954  1.00 55.93           C  
ATOM     13  CG  ASP A   6       4.527  42.355  24.823  1.00 62.38           C  
ATOM     14  OD1 ASP A   6       5.193  42.887  23.909  1.00 75.03           O  
ATOM     15  OD2 ASP A   6       5.040  41.545  25.633  1.00 71.70           O  
ATOM     16  N   ARG A   7       1.109  40.386  23.854  1.00 45.87           N  
ATOM     17  CA  ARG A   7       0.842  38.973  23.599  1.00 44.78           C  
ATOM     18  C   ARG A   7       0.567  38.688  22.126  1.00 44.52           C  
ATOM     19  O   ARG A   7       1.219  37.847  21.530  1.00 42.10           O  
ATOM     20  CB  ARG A   7      -0.342  38.481  24.438  1.00 44.28           C  
ATOM     21  CG  ARG A   7      -0.516  36.978  24.434  1.00 44.27           C  
ATOM     22  CD  ARG A   7      -1.430  36.479  25.564  1.00 43.90           C  
ATOM     23  NE  ARG A   7      -1.077  35.120  25.996  1.00 43.75           N  
ATOM     24  CZ  ARG A   7      -1.452  34.003  25.380  1.00 34.27           C  
ATOM     25  NH1 ARG A   7      -2.192  34.040  24.282  1.00 39.29           N  
ATOM     26  NH2 ARG A   7      -1.077  32.832  25.852  1.00 44.20           N  
ATOM     27  N   THR A   8      -0.396  39.387  21.534  1.00 43.51           N  
ATOM     28  CA  THR A   8      -0.714  39.182  20.119  1.00 44.30           C  
ATOM     29  C   THR A   8       0.511  39.423  19.256  1.00 42.51           C  
ATOM     30  O   THR A   8       0.710  38.745  18.257  1.00 44.93           O  
ATOM     31  CB  THR A   8      -1.837  40.120  19.636  1.00 45.05           C  
ATOM     32  OG1 THR A   8      -1.622  41.414  20.210  1.00 48.56           O  
ATOM     33  CG2 THR A   8      -3.202  39.575  20.040  1.00 44.60           C  
ATOM     34  N   GLN A   9       1.334  40.374  19.664  1.00 41.06           N  
ATOM     35  CA  GLN A   9       2.593  40.654  19.008  1.00 42.13           C  
ATOM     36  C   GLN A   9       3.530  39.450  19.085  1.00 42.62           C  
ATOM     37  O   GLN A   9       3.936  38.903  18.054  1.00 42.41           O  
ATOM     38  CB  GLN A   9       3.251  41.865  19.666  1.00 40.85           C  
ATOM     39  CG  GLN A   9       4.680  42.143  19.237  1.00 48.95           C  
ATOM     40  N   GLU A  10       3.852  39.043  20.314  1.00 39.65           N  
ATOM     41  CA  GLU A  10       4.663  37.841  20.562  1.00 37.96           C  
ATOM     42  C   GLU A  10       4.208  36.668  19.708  1.00 35.62           C  
ATOM     43  O   GLU A  10       5.031  35.947  19.124  1.00 34.53           O  
ATOM     44  CB  GLU A  10       4.585  37.486  22.046  1.00 37.47           C  
ATOM     45  CG  GLU A  10       5.350  38.441  22.943  1.00 39.45           C  
ATOM     46  CD  GLU A  10       5.200  38.076  24.408  1.00 42.21           C  
ATOM     47  OE1 GLU A  10       4.058  37.805  24.844  1.00 53.76           O  
ATOM     48  OE2 GLU A  10       6.227  38.020  25.108  1.00 52.83           O  
ATOM     49  N   ILE A  11       2.900  36.473  19.598  1.00 34.90           N  
ATOM     50  CA  ILE A  11       2.388  35.398  18.777  1.00 38.60           C  
ATOM     51  C   ILE A  11       2.755  35.651  17.296  1.00 41.78           C  
ATOM     52  O   ILE A  11       3.059  34.706  16.560  1.00 41.17           O  
ATOM     53  CB  ILE A  11       0.877  35.190  18.962  1.00 40.38           C  
ATOM     54  CG1 ILE A  11       0.609  34.612  20.360  1.00 36.75           C  
ATOM     55  CG2 ILE A  11       0.340  34.218  17.916  1.00 42.84           C  
ATOM     56  CD1 ILE A  11      -0.858  34.421  20.703  1.00 38.45           C  
ATOM     57  N   GLN A  12       2.759  36.924  16.899  1.00 44.61           N  
ATOM     58  CA  GLN A  12       3.189  37.337  15.559  1.00 43.51           C  
ATOM     59  C   GLN A  12       4.700  37.104  15.316  1.00 42.56           C  
ATOM     60  O   GLN A  12       5.064  36.609  14.259  1.00 42.05           O  
ATOM     61  CB  GLN A  12       2.811  38.802  15.296  1.00 46.57           C  
ATOM     62  N   LYS A  13       5.570  37.448  16.270  1.00 39.93           N  
ATOM     63  CA  LYS A  13       7.009  37.132  16.133  1.00 38.77           C  
ATOM     64  C   LYS A  13       7.206  35.632  15.969  1.00 37.07           C  
ATOM     65  O   LYS A  13       7.972  35.171  15.114  1.00 33.44           O  
ATOM     66  CB  LYS A  13       7.823  37.652  17.323  1.00 38.49           C  
ATOM     67  CG  LYS A  13       9.368  37.373  17.267  1.00 41.45           C  
ATOM     68  CD  LYS A  13      10.132  37.942  16.029  1.00 36.24           C  
ATOM     69  CE  LYS A  13      11.631  37.524  16.082  1.00 45.57           C  
ATOM     70  NZ  LYS A  13      12.583  37.986  14.957  1.00 40.85           N  
ATOM     71  N   LEU A  14       6.502  34.861  16.788  1.00 34.21           N  
ATOM     72  CA  LEU A  14       6.596  33.418  16.705  1.00 33.67           C  
ATOM     73  C   LEU A  14       6.187  32.952  15.329  1.00 33.59           C  
ATOM     74  O   LEU A  14       6.837  32.085  14.725  1.00 29.29           O  
ATOM     75  CB  LEU A  14       5.727  32.768  17.777  1.00 32.84           C  
ATOM     76  CG  LEU A  14       5.531  31.264  17.737  1.00 37.42           C  
ATOM     77  CD1 LEU A  14       6.853  30.481  17.896  1.00 36.26           C  
ATOM     78  CD2 LEU A  14       4.466  30.916  18.786  1.00 38.84           C  
ATOM     79  N   HIS A  15       5.101  33.537  14.826  1.00 36.55           N  
ATOM     80  CA  HIS A  15       4.665  33.271  13.447  1.00 36.86           C  
ATOM     81  C   HIS A  15       5.747  33.584  12.409  1.00 34.15           C  
ATOM     82  O   HIS A  15       6.029  32.747  11.574  1.00 36.72           O  
ATOM     83  CB  HIS A  15       3.385  34.052  13.130  1.00 37.80           C  
ATOM     84  CG  HIS A  15       2.860  33.792  11.753  1.00 42.81           C  
ATOM     85  ND1 HIS A  15       2.499  32.530  11.324  1.00 50.56           N  
ATOM     86  CD2 HIS A  15       2.650  34.622  10.704  1.00 44.84           C  
ATOM     87  CE1 HIS A  15       2.091  32.597  10.068  1.00 48.39           C  
ATOM     88  NE2 HIS A  15       2.180  33.853   9.668  1.00 44.83           N  
ATOM     89  N   GLU A  16       6.346  34.777  12.485  1.00 34.51           N  
ATOM     90  CA  GLU A  16       7.459  35.193  11.621  1.00 36.05           C  
ATOM     91  C   GLU A  16       8.564  34.140  11.669  1.00 33.93           C  
ATOM     92  O   GLU A  16       9.137  33.781  10.646  1.00 33.23           O  
ATOM     93  CB  GLU A  16       8.014  36.571  12.065  1.00 37.18           C  
ATOM     94  CG  GLU A  16       9.258  37.163  11.278  1.00 40.75           C  
ATOM     95  CD  GLU A  16      10.671  36.744  11.833  1.00 55.50           C  
ATOM     96  OE1 GLU A  16      10.953  36.858  13.055  1.00 52.27           O  
ATOM     97  OE2 GLU A  16      11.522  36.326  11.016  1.00 57.12           O  
ATOM     98  N   LEU A  17       8.841  33.632  12.864  1.00 29.96           N  
ATOM     99  CA  LEU A  17       9.974  32.739  13.052  1.00 28.22           C  
ATOM    100  C   LEU A  17       9.805  31.400  12.356  1.00 29.01           C  
ATOM    101  O   LEU A  17      10.722  30.964  11.673  1.00 27.75           O  
ATOM    102  CB  LEU A  17      10.256  32.512  14.541  1.00 29.10           C  
ATOM    103  CG  LEU A  17      10.961  33.658  15.267  1.00 29.70           C  
ATOM    104  CD1 LEU A  17      10.813  33.407  16.759  1.00 29.03           C  
ATOM    105  CD2 LEU A  17      12.454  33.822  14.858  1.00 28.52           C  
ATOM    106  N   ILE A  18       8.654  30.724  12.505  1.00 26.75           N  
ATOM    107  CA  ILE A  18       8.569  29.327  12.060  1.00 25.34           C  
ATOM    108  C   ILE A  18       7.717  29.058  10.804  1.00 28.77           C  
ATOM    109  O   ILE A  18       7.701  27.941  10.301  1.00 28.28           O  
ATOM    110  CB  ILE A  18       8.141  28.444  13.249  1.00 27.67           C  
ATOM    111  CG1 ILE A  18       6.689  28.736  13.653  1.00 31.79           C  
ATOM    112  CG2 ILE A  18       9.116  28.706  14.427  1.00 27.24           C  
ATOM    113  CD1 ILE A  18       6.120  27.755  14.726  1.00 28.17           C  
ATOM    114  N   LYS A  19       7.090  30.111  10.293  1.00 28.82           N  
ATOM    115  CA  LYS A  19       6.183  30.076   9.146  1.00 34.97           C  
ATOM    116  C   LYS A  19       6.745  29.278   7.966  1.00 33.36           C  
ATOM    117  O   LYS A  19       6.047  28.466   7.359  1.00 33.82           O  
ATOM    118  CB  LYS A  19       5.931  31.528   8.756  1.00 35.65           C  
ATOM    119  CG  LYS A  19       5.227  31.809   7.472  1.00 45.47           C  
ATOM    120  CD  LYS A  19       4.913  33.311   7.386  1.00 44.35           C  
ATOM    121  CE  LYS A  19       6.173  34.189   7.340  1.00 53.16           C  
ATOM    122  NZ  LYS A  19       5.867  35.644   7.459  1.00 54.06           N  
ATOM    123  N   ASN A  20       8.014  29.508   7.650  1.00 30.17           N  
ATOM    124  CA  ASN A  20       8.634  28.897   6.495  1.00 30.38           C  
ATOM    125  C   ASN A  20       9.593  27.758   6.839  1.00 29.97           C  
ATOM    126  O   ASN A  20      10.483  27.439   6.057  1.00 29.33           O  
ATOM    127  CB  ASN A  20       9.328  29.999   5.659  1.00 32.16           C  
ATOM    128  CG  ASN A  20       8.329  30.929   4.997  1.00 33.75           C  
ATOM    129  OD1 ASN A  20       8.258  32.124   5.290  1.00 35.83           O  
ATOM    130  ND2 ASN A  20       7.523  30.364   4.116  1.00 32.60           N  
ATOM    131  N   ILE A  21       9.414  27.119   8.002  1.00 27.90           N  
ATOM    132  CA  ILE A  21      10.199  25.936   8.338  1.00 26.97           C  
ATOM    133  C   ILE A  21       9.213  24.766   8.441  1.00 30.39           C  
ATOM    134  O   ILE A  21       8.257  24.849   9.207  1.00 35.04           O  
ATOM    135  CB  ILE A  21      10.992  26.120   9.653  1.00 27.52           C  
ATOM    136  CG1 ILE A  21      11.931  27.329   9.542  1.00 27.30           C  
ATOM    137  CG2 ILE A  21      11.798  24.863   9.986  1.00 27.44           C  
ATOM    138  CD1 ILE A  21      12.588  27.717  10.877  1.00 25.07           C  
ATOM    139  N   ASP A  22       9.467  23.711   7.670  1.00 32.04           N  
ATOM    140  CA  ASP A  22       8.499  22.629   7.426  1.00 35.22           C  
ATOM    141  C   ASP A  22       8.436  21.597   8.523  1.00 32.91           C  
ATOM    142  O   ASP A  22       7.342  21.244   8.942  1.00 40.23           O  
ATOM    143  CB  ASP A  22       8.813  21.895   6.109  1.00 36.83           C  
ATOM    144  N   TYR A  23       9.599  21.103   8.948  1.00 29.79           N  
ATOM    145  CA  TYR A  23       9.688  19.998   9.901  1.00 27.84           C  
ATOM    146  C   TYR A  23      10.379  20.525  11.170  1.00 28.51           C  
ATOM    147  O   TYR A  23      11.351  21.255  11.098  1.00 32.23           O  
ATOM    148  CB  TYR A  23      10.468  18.798   9.334  1.00 32.04           C  
ATOM    149  CG  TYR A  23       9.965  18.342   7.970  1.00 30.08           C  
ATOM    150  CD1 TYR A  23       8.718  17.748   7.830  1.00 43.65           C  
ATOM    151  CD2 TYR A  23      10.710  18.568   6.815  1.00 40.61           C  
ATOM    152  CE1 TYR A  23       8.239  17.363   6.591  1.00 40.63           C  
ATOM    153  CE2 TYR A  23      10.239  18.194   5.570  1.00 38.91           C  
ATOM    154  CZ  TYR A  23       9.001  17.588   5.461  1.00 44.32           C  
ATOM    155  OH  TYR A  23       8.519  17.198   4.217  1.00 42.57           O  
ATOM    156  N   GLY A  24       9.874  20.158  12.313  1.00 25.41           N  
ATOM    157  CA  GLY A  24      10.591  20.436  13.555  1.00 27.04           C  
ATOM    158  C   GLY A  24      11.023  19.098  14.125  1.00 25.67           C  
ATOM    159  O   GLY A  24      10.589  18.042  13.652  1.00 24.86           O  
HETATM  160  N   MSE A  25      11.898  19.145  15.123  1.00 21.54           N  
HETATM  161  CA  MSE A  25      12.287  17.962  15.855  1.00 21.59           C  
HETATM  162  C   MSE A  25      11.545  18.020  17.188  1.00 19.91           C  
HETATM  163  O   MSE A  25      11.686  18.991  17.953  1.00 22.75           O  
HETATM  164  CB  MSE A  25      13.799  17.905  16.058  1.00 20.56           C  
HETATM  165  CG  MSE A  25      14.650  17.733  14.828  1.00 21.68           C  
HETATM  166 SE   MSE A  25      14.274  16.096  13.903  0.75 27.35          SE  
HETATM  167  CE  MSE A  25      15.094  14.784  15.140  1.00 24.85           C  
ATOM    168  N   PHE A  26      10.710  17.012  17.421  1.00 20.76           N  
ATOM    169  CA  PHE A  26       9.786  16.899  18.545  1.00 20.86           C  
ATOM    170  C   PHE A  26      10.396  15.998  19.577  1.00 21.17           C  
ATOM    171  O   PHE A  26      10.668  14.827  19.284  1.00 22.50           O  
ATOM    172  CB  PHE A  26       8.473  16.304  18.029  1.00 23.38           C  
ATOM    173  CG  PHE A  26       7.317  16.387  18.975  1.00 22.24           C  
ATOM    174  CD1 PHE A  26       7.253  15.568  20.077  1.00 23.75           C  
ATOM    175  CD2 PHE A  26       6.246  17.247  18.734  1.00 22.12           C  
ATOM    176  CE1 PHE A  26       6.188  15.610  20.933  1.00 28.35           C  
ATOM    177  CE2 PHE A  26       5.127  17.273  19.612  1.00 24.78           C  
ATOM    178  CZ  PHE A  26       5.116  16.470  20.713  1.00 26.74           C  
ATOM    179  N   THR A  27      10.710  16.548  20.761  1.00 19.98           N  
ATOM    180  CA  THR A  27      11.400  15.797  21.791  1.00 22.64           C  
ATOM    181  C   THR A  27      10.538  15.513  23.022  1.00 22.93           C  
ATOM    182  O   THR A  27       9.885  16.416  23.570  1.00 22.58           O  
ATOM    183  CB  THR A  27      12.665  16.558  22.280  1.00 24.14           C  
ATOM    184  OG1 THR A  27      13.493  16.876  21.148  1.00 22.83           O  
ATOM    185  CG2 THR A  27      13.476  15.716  23.267  1.00 23.77           C  
ATOM    186  N   THR A  28      10.617  14.281  23.498  1.00 23.11           N  
ATOM    187  CA  THR A  28       9.891  13.801  24.667  1.00 23.42           C  
ATOM    188  C   THR A  28      10.842  13.139  25.646  1.00 25.29           C  
ATOM    189  O   THR A  28      11.983  12.852  25.306  1.00 24.92           O  
ATOM    190  CB  THR A  28       8.825  12.720  24.270  1.00 26.17           C  
ATOM    191  OG1 THR A  28       9.494  11.633  23.618  1.00 24.82           O  
ATOM    192  CG2 THR A  28       7.732  13.253  23.372  1.00 21.78           C  
ATOM    193  N   VAL A  29      10.340  12.870  26.850  1.00 23.86           N  
ATOM    194  CA  VAL A  29      11.058  12.157  27.890  1.00 25.28           C  
ATOM    195  C   VAL A  29      10.322  10.884  28.165  1.00 25.81           C  
ATOM    196  O   VAL A  29       9.094  10.876  28.313  1.00 26.65           O  
ATOM    197  CB  VAL A  29      11.106  12.913  29.248  1.00 27.20           C  
ATOM    198  CG1 VAL A  29      12.115  12.222  30.191  1.00 25.71           C  
ATOM    199  CG2 VAL A  29      11.434  14.350  29.078  1.00 27.93           C  
ATOM    200  N   ASP A  30      11.076   9.799  28.270  1.00 24.51           N  
ATOM    201  CA  ASP A  30      10.523   8.482  28.530  1.00 29.23           C  
ATOM    202  C   ASP A  30      10.547   8.152  30.009  1.00 28.74           C  
ATOM    203  O   ASP A  30      11.120   8.883  30.827  1.00 27.19           O  
ATOM    204  CB  ASP A  30      11.316   7.451  27.703  1.00 31.59           C  
ATOM    205  CG  ASP A  30      10.483   6.240  27.286  1.00 50.13           C  
ATOM    206  OD1 ASP A  30       9.415   5.976  27.908  1.00 60.25           O  
ATOM    207  OD2 ASP A  30      10.921   5.538  26.329  1.00 59.04           O  
ATOM    208  N   ASP A  31       9.911   7.046  30.380  1.00 30.34           N  
ATOM    209  CA  ASP A  31       9.832   6.653  31.800  1.00 31.23           C  
ATOM    210  C   ASP A  31      11.192   6.412  32.430  1.00 30.23           C  
ATOM    211  O   ASP A  31      11.351   6.596  33.631  1.00 36.39           O  
ATOM    212  CB  ASP A  31       8.999   5.381  31.955  1.00 34.30           C  
ATOM    213  CG  ASP A  31       7.503   5.620  31.877  1.00 40.55           C  
ATOM    214  OD1 ASP A  31       7.016   6.745  32.123  1.00 44.99           O  
ATOM    215  OD2 ASP A  31       6.795   4.629  31.606  1.00 44.73           O  
ATOM    216  N   ASP A  32      12.195   6.056  31.633  1.00 29.95           N  
ATOM    217  CA  ASP A  32      13.566   5.911  32.151  1.00 31.08           C  
ATOM    218  C   ASP A  32      14.365   7.202  32.189  1.00 30.02           C  
ATOM    219  O   ASP A  32      15.532   7.172  32.540  1.00 31.88           O  
ATOM    220  CB  ASP A  32      14.325   4.807  31.377  1.00 31.41           C  
ATOM    221  CG  ASP A  32      14.595   5.162  29.916  1.00 42.95           C  
ATOM    222  OD1 ASP A  32      14.241   6.275  29.445  1.00 40.25           O  
ATOM    223  OD2 ASP A  32      15.178   4.307  29.218  1.00 48.11           O  
ATOM    224  N   GLY A  33      13.745   8.339  31.867  1.00 26.77           N  
ATOM    225  CA  GLY A  33      14.435   9.606  31.892  1.00 28.09           C  
ATOM    226  C   GLY A  33      15.136   9.968  30.606  1.00 25.99           C  
ATOM    227  O   GLY A  33      15.629  11.068  30.492  1.00 22.96           O  
ATOM    228  N   SER A  34      15.157   9.066  29.626  1.00 24.92           N  
ATOM    229  CA  SER A  34      15.866   9.346  28.390  1.00 25.41           C  
ATOM    230  C   SER A  34      15.015  10.240  27.493  1.00 22.96           C  
ATOM    231  O   SER A  34      13.772  10.209  27.551  1.00 26.28           O  
ATOM    232  CB  SER A  34      16.281   8.030  27.724  1.00 27.81           C  
ATOM    233  OG  SER A  34      15.154   7.322  27.332  1.00 35.44           O  
ATOM    234  N   LEU A  35      15.686  11.025  26.643  1.00 21.76           N  
ATOM    235  CA  LEU A  35      15.017  11.968  25.763  1.00 21.38           C  
ATOM    236  C   LEU A  35      15.135  11.455  24.341  1.00 25.14           C  
ATOM    237  O   LEU A  35      16.211  11.036  23.942  1.00 26.68           O  
ATOM    238  CB  LEU A  35      15.617  13.347  25.823  1.00 21.49           C  
ATOM    239  CG  LEU A  35      15.212  14.252  26.963  1.00 24.55           C  
ATOM    240  CD1 LEU A  35      15.741  13.681  28.245  1.00 27.12           C  
ATOM    241  CD2 LEU A  35      15.709  15.686  26.718  1.00 22.00           C  
ATOM    242  N   HIS A  36      14.032  11.480  23.618  1.00 24.12           N  
ATOM    243  CA  HIS A  36      13.998  11.017  22.211  1.00 26.43           C  
ATOM    244  C   HIS A  36      13.369  12.103  21.368  1.00 23.62           C  
ATOM    245  O   HIS A  36      12.432  12.758  21.815  1.00 23.34           O  
ATOM    246  CB  HIS A  36      13.184   9.749  22.062  1.00 29.42           C  
ATOM    247  CG  HIS A  36      13.709   8.621  22.883  1.00 34.42           C  
ATOM    248  ND1 HIS A  36      12.994   8.057  23.912  1.00 49.44           N  
ATOM    249  CD2 HIS A  36      14.894   7.971  22.838  1.00 37.36           C  
ATOM    250  CE1 HIS A  36      13.718   7.099  24.467  1.00 50.51           C  
ATOM    251  NE2 HIS A  36      14.879   7.035  23.842  1.00 40.88           N  
ATOM    252  N   SER A  37      13.917  12.300  20.169  1.00 23.43           N  
ATOM    253  CA  SER A  37      13.379  13.315  19.248  0.50 22.57           C  
ATOM    255  C   SER A  37      12.995  12.671  17.926  1.00 22.51           C  
ATOM    256  O   SER A  37      13.565  11.640  17.510  1.00 22.02           O  
ATOM    257  CB  SER A  37      14.311  14.514  19.043  0.50 23.70           C  
ATOM    259  OG  SER A  37      15.528  14.187  18.408  0.50 23.36           O  
ATOM    261  N   TYR A  38      11.985  13.271  17.305  1.00 24.24           N  
ATOM    262  CA  TYR A  38      11.327  12.764  16.112  1.00 23.58           C  
ATOM    263  C   TYR A  38      11.015  13.900  15.149  1.00 20.90           C  
ATOM    264  O   TYR A  38      10.461  14.898  15.590  1.00 20.38           O  
ATOM    265  CB  TYR A  38       9.960  12.168  16.508  1.00 26.09           C  
ATOM    266  CG  TYR A  38       9.930  11.229  17.672  1.00 26.69           C  
ATOM    267  CD1 TYR A  38       9.775  11.686  18.976  1.00 29.13           C  
ATOM    268  CD2 TYR A  38       9.978   9.860  17.472  1.00 32.51           C  
ATOM    269  CE1 TYR A  38       9.755  10.798  20.049  1.00 25.00           C  
ATOM    270  CE2 TYR A  38       9.936   8.964  18.537  1.00 33.75           C  
ATOM    271  CZ  TYR A  38       9.824   9.426  19.822  1.00 30.42           C  
ATOM    272  OH  TYR A  38       9.780   8.490  20.858  1.00 30.85           O  
ATOM    273  N   PRO A  39      11.302  13.751  13.851  1.00 23.10           N  
ATOM    274  CA  PRO A  39      10.869  14.793  12.922  1.00 23.48           C  
ATOM    275  C   PRO A  39       9.370  14.795  12.768  1.00 23.33           C  
ATOM    276  O   PRO A  39       8.774  13.742  12.686  1.00 23.62           O  
ATOM    277  CB  PRO A  39      11.545  14.440  11.607  1.00 22.89           C  
ATOM    278  CG  PRO A  39      11.866  13.020  11.707  1.00 29.63           C  
ATOM    279  CD  PRO A  39      12.019  12.671  13.162  1.00 24.50           C  
HETATM  280  N   MSE A  40       8.774  15.971  12.765  1.00 24.89           N  
HETATM  281  CA  MSE A  40       7.321  16.120  12.670  0.50 25.55           C  
HETATM  283  C   MSE A  40       6.984  17.283  11.752  1.00 27.22           C  
HETATM  284  O   MSE A  40       7.594  18.331  11.846  1.00 27.23           O  
HETATM  285  CB  MSE A  40       6.708  16.369  14.055  0.50 24.37           C  
HETATM  287  CG  MSE A  40       6.926  15.264  15.090  0.50 22.47           C  
HETATM  289 SE   MSE A  40       6.054  13.586  14.645  0.38 25.34          SE  
HETATM  291  CE  MSE A  40       4.300  13.943  15.386  0.50 17.62           C  
ATOM    293  N   SER A  41       6.006  17.088  10.876  1.00 31.51           N  
ATOM    294  CA  SER A  41       5.555  18.130   9.984  1.00 34.49           C  
ATOM    295  C   SER A  41       4.544  18.997  10.713  1.00 33.06           C  
ATOM    296  O   SER A  41       3.552  18.485  11.169  1.00 32.24           O  
ATOM    297  CB  SER A  41       4.886  17.500   8.754  1.00 36.23           C  
ATOM    298  OG  SER A  41       4.575  18.503   7.799  1.00 42.70           O  
ATOM    299  N   LYS A  42       4.757  20.296  10.805  1.00 33.69           N  
ATOM    300  CA  LYS A  42       3.802  21.144  11.516  1.00 35.27           C  
ATOM    301  C   LYS A  42       2.590  21.457  10.625  1.00 35.93           C  
ATOM    302  O   LYS A  42       2.765  21.745   9.448  1.00 35.18           O  
ATOM    303  CB  LYS A  42       4.473  22.424  12.049  1.00 39.36           C  
ATOM    304  CG  LYS A  42       4.703  23.564  11.072  1.00 40.73           C  
ATOM    305  CD  LYS A  42       5.487  24.720  11.743  1.00 43.07           C  
ATOM    306  CE  LYS A  42       5.455  26.002  10.907  1.00 44.66           C  
ATOM    307  NZ  LYS A  42       5.864  25.741   9.501  1.00 54.45           N  
ATOM    308  N   SER A  43       1.391  21.404  11.205  1.00 37.31           N  
ATOM    309  CA  SER A  43       0.125  21.763  10.540  1.00 41.72           C  
ATOM    310  C   SER A  43      -0.549  23.054  11.048  1.00 46.06           C  
ATOM    311  O   SER A  43      -0.542  23.351  12.243  1.00 45.60           O  
ATOM    312  CB  SER A  43      -0.873  20.637  10.748  1.00 41.26           C  
ATOM    313  OG  SER A  43      -0.521  19.540   9.947  1.00 41.29           O  
ATOM    314  N   GLY A  44      -1.200  23.780  10.145  1.00 48.46           N  
ATOM    315  CA  GLY A  44      -1.878  25.035  10.510  1.00 49.56           C  
ATOM    316  C   GLY A  44      -0.888  26.173  10.736  1.00 52.47           C  
ATOM    317  O   GLY A  44       0.339  25.957  10.738  1.00 52.84           O  
ATOM    318  N   ASP A  45      -1.419  27.382  10.930  1.00 52.84           N  
ATOM    319  CA  ASP A  45      -0.610  28.602  11.004  1.00 53.51           C  
ATOM    320  C   ASP A  45      -0.613  29.162  12.418  1.00 53.86           C  
ATOM    321  O   ASP A  45      -1.614  29.037  13.128  1.00 54.94           O  
ATOM    322  CB  ASP A  45      -1.145  29.648  10.018  1.00 53.70           C  
ATOM    323  N   GLU A  49      -3.473  31.359  18.077  1.00 38.51           N  
ATOM    324  CA  GLU A  49      -3.194  30.855  19.423  1.00 36.56           C  
ATOM    325  C   GLU A  49      -1.725  30.472  19.582  1.00 34.97           C  
ATOM    326  O   GLU A  49      -1.016  30.194  18.596  1.00 32.55           O  
ATOM    327  CB  GLU A  49      -4.064  29.626  19.747  1.00 38.34           C  
ATOM    328  CG  GLU A  49      -5.572  29.823  19.565  1.00 47.87           C  
ATOM    329  CD  GLU A  49      -6.169  30.774  20.587  1.00 58.71           C  
ATOM    330  OE1 GLU A  49      -5.443  31.187  21.525  1.00 70.92           O  
ATOM    331  OE2 GLU A  49      -7.364  31.123  20.442  1.00 64.08           O  
ATOM    332  N   ALA A  50      -1.285  30.434  20.825  1.00 26.90           N  
ATOM    333  CA  ALA A  50       0.089  30.066  21.130  1.00 28.00           C  
ATOM    334  C   ALA A  50       0.108  28.569  21.202  1.00 25.75           C  
ATOM    335  O   ALA A  50       0.306  27.986  22.289  1.00 23.90           O  
ATOM    336  CB  ALA A  50       0.523  30.663  22.432  1.00 28.90           C  
ATOM    337  N   THR A  51      -0.188  27.930  20.063  1.00 23.96           N  
ATOM    338  CA  THR A  51      -0.403  26.462  20.017  1.00 23.19           C  
ATOM    339  C   THR A  51       0.190  25.942  18.726  1.00 25.01           C  
ATOM    340  O   THR A  51       0.187  26.653  17.711  1.00 28.47           O  
ATOM    341  CB  THR A  51      -1.894  26.152  20.036  0.50 26.16           C  
ATOM    343  OG1 THR A  51      -2.448  26.482  18.762  0.50 26.99           O  
ATOM    345  CG2 THR A  51      -2.626  27.000  21.087  0.50 20.29           C  
ATOM    347  N   LEU A  52       0.752  24.748  18.762  1.00 22.64           N  
ATOM    348  CA  LEU A  52       1.180  24.063  17.567  1.00 23.11           C  
ATOM    349  C   LEU A  52       0.386  22.772  17.490  1.00 25.50           C  
ATOM    350  O   LEU A  52      -0.041  22.238  18.520  1.00 25.40           O  
ATOM    351  CB  LEU A  52       2.642  23.689  17.594  1.00 23.47           C  
ATOM    352  CG  LEU A  52       3.767  24.699  17.823  1.00 30.53           C  
ATOM    353  CD1 LEU A  52       5.067  23.924  18.111  1.00 32.41           C  
ATOM    354  CD2 LEU A  52       3.876  25.585  16.661  1.00 34.46           C  
ATOM    355  N   TRP A  53       0.218  22.298  16.263  1.00 25.18           N  
ATOM    356  CA  TRP A  53      -0.530  21.064  15.996  1.00 25.58           C  
ATOM    357  C   TRP A  53       0.257  20.133  15.086  1.00 25.63           C  
ATOM    358  O   TRP A  53       0.837  20.578  14.093  1.00 24.92           O  
ATOM    359  CB  TRP A  53      -1.836  21.419  15.324  1.00 23.87           C  
ATOM    360  CG  TRP A  53      -2.826  22.163  16.161  1.00 25.16           C  
ATOM    361  CD1 TRP A  53      -2.969  23.516  16.260  1.00 28.85           C  
ATOM    362  CD2 TRP A  53      -3.815  21.591  17.007  1.00 24.02           C  
ATOM    363  NE1 TRP A  53      -3.993  23.811  17.120  1.00 28.26           N  
ATOM    364  CE2 TRP A  53      -4.526  22.644  17.594  1.00 27.25           C  
ATOM    365  CE3 TRP A  53      -4.187  20.286  17.310  1.00 26.17           C  
ATOM    366  CZ2 TRP A  53      -5.573  22.429  18.476  1.00 24.93           C  
ATOM    367  CZ3 TRP A  53      -5.211  20.080  18.206  1.00 30.84           C  
ATOM    368  CH2 TRP A  53      -5.914  21.154  18.755  1.00 28.33           C  
ATOM    369  N   PHE A  54       0.244  18.835  15.402  1.00 24.92           N  
ATOM    370  CA  PHE A  54       0.877  17.804  14.570  1.00 24.92           C  
ATOM    371  C   PHE A  54      -0.045  16.614  14.482  1.00 23.88           C  
ATOM    372  O   PHE A  54      -0.702  16.275  15.471  1.00 24.59           O  
ATOM    373  CB  PHE A  54       2.197  17.312  15.170  1.00 26.28           C  
ATOM    374  CG  PHE A  54       3.173  18.405  15.453  1.00 25.26           C  
ATOM    375  CD1 PHE A  54       3.146  19.086  16.667  1.00 24.71           C  
ATOM    376  CD2 PHE A  54       4.116  18.760  14.503  1.00 24.02           C  
ATOM    377  CE1 PHE A  54       4.058  20.136  16.926  1.00 26.15           C  
ATOM    378  CE2 PHE A  54       5.044  19.780  14.756  1.00 28.10           C  
ATOM    379  CZ  PHE A  54       5.002  20.471  15.949  1.00 26.39           C  
ATOM    380  N   PHE A  55      -0.090  15.990  13.314  1.00 25.01           N  
ATOM    381  CA  PHE A  55      -0.751  14.695  13.175  1.00 22.71           C  
ATOM    382  C   PHE A  55       0.159  13.590  13.669  1.00 25.11           C  
ATOM    383  O   PHE A  55       1.382  13.650  13.481  1.00 23.89           O  
ATOM    384  CB  PHE A  55      -1.144  14.468  11.711  1.00 23.29           C  
ATOM    385  CG  PHE A  55      -2.345  15.226  11.289  1.00 23.06           C  
ATOM    386  CD1 PHE A  55      -3.627  14.678  11.399  1.00 26.92           C  
ATOM    387  CD2 PHE A  55      -2.209  16.498  10.724  1.00 26.63           C  
ATOM    388  CE1 PHE A  55      -4.742  15.386  10.983  1.00 25.72           C  
ATOM    389  CE2 PHE A  55      -3.327  17.210  10.319  1.00 26.59           C  
ATOM    390  CZ  PHE A  55      -4.599  16.643  10.438  1.00 26.67           C  
ATOM    391  N   THR A  56      -0.415  12.593  14.343  1.00 24.28           N  
ATOM    392  CA  THR A  56       0.326  11.434  14.836  1.00 25.10           C  
ATOM    393  C   THR A  56      -0.587  10.200  14.797  1.00 26.64           C  
ATOM    394  O   THR A  56      -1.751  10.311  14.372  1.00 27.70           O  
ATOM    395  CB  THR A  56       0.845  11.659  16.246  1.00 29.90           C  
ATOM    396  OG1 THR A  56       1.846  10.677  16.520  1.00 30.02           O  
ATOM    397  CG2 THR A  56      -0.305  11.613  17.277  1.00 26.15           C  
ATOM    398  N   TYR A  57      -0.052   9.032  15.148  1.00 23.96           N  
ATOM    399  CA  TYR A  57      -0.864   7.828  15.354  1.00 22.49           C  
ATOM    400  C   TYR A  57      -1.043   7.707  16.871  1.00 23.39           C  
ATOM    401  O   TYR A  57      -0.075   7.848  17.621  1.00 24.01           O  
ATOM    402  CB  TYR A  57      -0.195   6.589  14.771  1.00 22.60           C  
ATOM    403  CG  TYR A  57      -0.135   6.616  13.270  1.00 25.35           C  
ATOM    404  CD1 TYR A  57      -1.255   6.292  12.512  1.00 23.78           C  
ATOM    405  CD2 TYR A  57       1.029   6.980  12.604  1.00 29.94           C  
ATOM    406  CE1 TYR A  57      -1.215   6.312  11.123  1.00 24.66           C  
ATOM    407  CE2 TYR A  57       1.078   7.019  11.203  1.00 25.04           C  
ATOM    408  CZ  TYR A  57      -0.041   6.680  10.480  1.00 27.85           C  
ATOM    409  OH  TYR A  57      -0.013   6.685   9.107  1.00 26.39           O  
ATOM    410  N   ALA A  58      -2.257   7.430  17.302  1.00 22.65           N  
ATOM    411  CA  ALA A  58      -2.599   7.423  18.746  1.00 24.34           C  
ATOM    412  C   ALA A  58      -1.906   6.295  19.462  1.00 24.41           C  
ATOM    413  O   ALA A  58      -1.675   6.373  20.689  1.00 24.43           O  
ATOM    414  CB  ALA A  58      -4.099   7.348  18.966  1.00 20.81           C  
ATOM    415  N   GLY A  59      -1.566   5.236  18.722  1.00 24.80           N  
ATOM    416  CA  GLY A  59      -0.822   4.137  19.303  1.00 23.95           C  
ATOM    417  C   GLY A  59       0.689   4.268  19.280  1.00 24.75           C  
ATOM    418  O   GLY A  59       1.376   3.332  19.680  1.00 24.91           O  
ATOM    419  N   SER A  60       1.216   5.405  18.820  1.00 22.86           N  
ATOM    420  CA  SER A  60       2.644   5.625  18.737  1.00 25.62           C  
ATOM    421  C   SER A  60       3.337   5.704  20.109  1.00 24.95           C  
ATOM    422  O   SER A  60       2.726   6.030  21.141  1.00 24.14           O  
ATOM    423  CB  SER A  60       2.959   6.897  17.943  1.00 25.57           C  
ATOM    424  OG  SER A  60       2.519   8.033  18.659  1.00 28.18           O  
ATOM    425  N   HIS A  61       4.628   5.408  20.111  1.00 26.78           N  
ATOM    426  CA  HIS A  61       5.379   5.436  21.364  1.00 28.16           C  
ATOM    427  C   HIS A  61       5.444   6.867  21.904  1.00 25.49           C  
ATOM    428  O   HIS A  61       5.357   7.054  23.094  1.00 26.09           O  
ATOM    429  CB  HIS A  61       6.784   4.828  21.184  1.00 31.71           C  
ATOM    430  CG  HIS A  61       7.517   4.668  22.481  1.00 39.30           C  
ATOM    431  ND1 HIS A  61       7.038   3.887  23.510  1.00 43.74           N  
ATOM    432  CD2 HIS A  61       8.673   5.210  22.929  1.00 47.58           C  
ATOM    433  CE1 HIS A  61       7.863   3.958  24.538  1.00 46.91           C  
ATOM    434  NE2 HIS A  61       8.865   4.754  24.213  1.00 41.30           N  
ATOM    435  N   LYS A  62       5.557   7.874  21.051  1.00 26.02           N  
ATOM    436  CA  LYS A  62       5.629   9.251  21.527  1.00 25.57           C  
ATOM    437  C   LYS A  62       4.366   9.636  22.317  1.00 27.40           C  
ATOM    438  O   LYS A  62       4.412  10.435  23.231  1.00 24.96           O  
ATOM    439  CB  LYS A  62       5.907  10.246  20.388  1.00 24.51           C  
ATOM    440  CG  LYS A  62       4.753  10.545  19.418  1.00 27.99           C  
ATOM    441  CD  LYS A  62       5.199  11.475  18.292  1.00 30.96           C  
ATOM    442  CE  LYS A  62       6.093  10.762  17.246  1.00 37.17           C  
ATOM    443  NZ  LYS A  62       5.377   9.554  16.719  1.00 41.58           N  
ATOM    444  N   VAL A  63       3.216   9.089  21.936  1.00 25.72           N  
ATOM    445  CA  VAL A  63       1.985   9.359  22.661  1.00 22.08           C  
ATOM    446  C   VAL A  63       2.019   8.731  24.049  1.00 24.72           C  
ATOM    447  O   VAL A  63       1.618   9.345  25.036  1.00 26.71           O  
ATOM    448  CB  VAL A  63       0.730   8.893  21.808  1.00 22.38           C  
ATOM    449  CG1 VAL A  63      -0.507   8.898  22.655  1.00 21.93           C  
ATOM    450  CG2 VAL A  63       0.542   9.784  20.605  1.00 22.85           C  
ATOM    451  N   THR A  64       2.547   7.516  24.156  1.00 23.86           N  
ATOM    452  CA  THR A  64       2.702   6.894  25.455  1.00 25.94           C  
ATOM    453  C   THR A  64       3.650   7.726  26.322  1.00 23.06           C  
ATOM    454  O   THR A  64       3.392   7.907  27.495  1.00 25.94           O  
ATOM    455  CB  THR A  64       3.141   5.391  25.400  1.00 29.09           C  
ATOM    456  OG1 THR A  64       4.551   5.290  25.221  1.00 41.07           O  
ATOM    457  CG2 THR A  64       2.431   4.700  24.278  1.00 22.18           C  
ATOM    458  N   GLU A  65       4.701   8.302  25.716  1.00 23.52           N  
ATOM    459  CA  GLU A  65       5.599   9.175  26.474  1.00 22.92           C  
ATOM    460  C   GLU A  65       4.872  10.402  26.989  1.00 25.10           C  
ATOM    461  O   GLU A  65       4.971  10.741  28.185  1.00 23.83           O  
ATOM    462  CB  GLU A  65       6.844   9.542  25.633  1.00 20.79           C  
ATOM    463  CG  GLU A  65       7.641   8.286  25.259  1.00 25.24           C  
ATOM    464  CD  GLU A  65       8.717   8.451  24.186  1.00 32.48           C  
ATOM    465  OE1 GLU A  65       8.575   9.273  23.232  1.00 29.38           O  
ATOM    466  OE2 GLU A  65       9.713   7.687  24.281  1.00 40.46           O  
ATOM    467  N   ILE A  66       4.150  11.083  26.106  1.00 23.32           N  
ATOM    468  CA  ILE A  66       3.552  12.363  26.514  0.50 25.00           C  
ATOM    470  C   ILE A  66       2.415  12.122  27.512  1.00 25.16           C  
ATOM    471  O   ILE A  66       2.135  12.982  28.355  1.00 26.35           O  
ATOM    472  CB  ILE A  66       3.146  13.284  25.331  0.50 24.57           C  
ATOM    474  CG1 ILE A  66       2.051  12.667  24.449  0.50 26.74           C  
ATOM    476  CG2 ILE A  66       4.390  13.689  24.502  0.50 27.71           C  
ATOM    478  CD1 ILE A  66       0.712  13.270  24.707  0.50 27.24           C  
ATOM    480  N   GLU A  67       1.807  10.947  27.484  1.00 24.37           N  
ATOM    481  CA  GLU A  67       0.806  10.639  28.449  1.00 27.01           C  
ATOM    482  C   GLU A  67       1.360  10.530  29.872  1.00 29.26           C  
ATOM    483  O   GLU A  67       0.638  10.802  30.811  1.00 31.55           O  
ATOM    484  CB  GLU A  67       0.051   9.390  28.020  1.00 28.52           C  
ATOM    485  CG  GLU A  67      -0.751   9.637  26.736  1.00 33.28           C  
ATOM    486  CD  GLU A  67      -2.189  10.049  26.969  1.00 46.76           C  
ATOM    487  OE1 GLU A  67      -2.624  10.043  28.130  1.00 53.18           O  
ATOM    488  OE2 GLU A  67      -2.895  10.353  25.977  1.00 46.06           O  
ATOM    489  N   HIS A  68       2.631  10.167  30.038  1.00 26.77           N  
ATOM    490  CA  HIS A  68       3.253  10.171  31.348  1.00 26.54           C  
ATOM    491  C   HIS A  68       4.018  11.469  31.645  1.00 28.45           C  
ATOM    492  O   HIS A  68       4.160  11.869  32.811  1.00 31.02           O  
ATOM    493  CB  HIS A  68       4.222   9.002  31.467  1.00 25.99           C  
ATOM    494  CG  HIS A  68       3.578   7.721  31.896  1.00 29.08           C  
ATOM    495  ND1 HIS A  68       4.307   6.580  32.142  1.00 36.11           N  
ATOM    496  CD2 HIS A  68       2.285   7.410  32.134  1.00 32.65           C  
ATOM    497  CE1 HIS A  68       3.481   5.609  32.502  1.00 38.64           C  
ATOM    498  NE2 HIS A  68       2.248   6.081  32.490  1.00 31.97           N  
ATOM    499  N   HIS A  69       4.589  12.088  30.619  1.00 24.75           N  
ATOM    500  CA  HIS A  69       5.315  13.345  30.809  1.00 21.52           C  
ATOM    501  C   HIS A  69       4.903  14.305  29.713  1.00 22.23           C  
ATOM    502  O   HIS A  69       5.425  14.245  28.617  1.00 22.00           O  
ATOM    503  CB  HIS A  69       6.829  13.136  30.804  1.00 22.49           C  
ATOM    504  CG  HIS A  69       7.595  14.311  31.327  1.00 21.43           C  
ATOM    505  ND1 HIS A  69       7.750  14.526  32.681  1.00 25.33           N  
ATOM    506  CD2 HIS A  69       8.197  15.355  30.709  1.00 24.55           C  
ATOM    507  CE1 HIS A  69       8.441  15.645  32.871  1.00 26.49           C  
ATOM    508  NE2 HIS A  69       8.712  16.178  31.694  1.00 23.10           N  
ATOM    509  N   GLU A  70       3.964  15.186  30.027  1.00 20.95           N  
ATOM    510  CA  GLU A  70       3.333  16.043  28.999  1.00 22.48           C  
ATOM    511  C   GLU A  70       4.242  17.116  28.435  1.00 20.62           C  
ATOM    512  O   GLU A  70       3.993  17.588  27.338  1.00 22.37           O  
ATOM    513  CB  GLU A  70       2.044  16.673  29.541  1.00 23.54           C  
ATOM    514  CG  GLU A  70       2.270  17.681  30.664  1.00 22.77           C  
ATOM    515  CD  GLU A  70       1.067  18.520  31.028  1.00 25.59           C  
ATOM    516  OE1 GLU A  70      -0.016  18.374  30.402  1.00 25.36           O  
ATOM    517  OE2 GLU A  70       1.225  19.377  31.940  1.00 26.18           O  
ATOM    518  N   GLN A  71       5.266  17.544  29.189  1.00 21.67           N  
ATOM    519  CA  GLN A  71       6.175  18.546  28.699  1.00 22.61           C  
ATOM    520  C   GLN A  71       6.991  18.007  27.530  1.00 22.04           C  
ATOM    521  O   GLN A  71       7.553  16.904  27.595  1.00 22.63           O  
ATOM    522  CB  GLN A  71       7.116  19.025  29.783  1.00 22.64           C  
ATOM    523  CG  GLN A  71       6.404  19.605  30.987  1.00 24.27           C  
ATOM    524  CD  GLN A  71       6.330  18.621  32.116  1.00 27.35           C  
ATOM    525  OE1 GLN A  71       5.938  17.459  31.942  1.00 26.24           O  
ATOM    526  NE2 GLN A  71       6.707  19.075  33.288  1.00 23.71           N  
ATOM    527  N   VAL A  72       7.102  18.820  26.494  1.00 22.57           N  
ATOM    528  CA  VAL A  72       7.862  18.497  25.296  1.00 22.75           C  
ATOM    529  C   VAL A  72       8.647  19.697  24.827  1.00 23.30           C  
ATOM    530  O   VAL A  72       8.436  20.812  25.302  1.00 21.14           O  
ATOM    531  CB  VAL A  72       6.916  18.027  24.143  1.00 22.94           C  
ATOM    532  CG1 VAL A  72       6.137  16.743  24.559  1.00 21.94           C  
ATOM    533  CG2 VAL A  72       5.967  19.174  23.632  1.00 20.39           C  
ATOM    534  N   ASN A  73       9.521  19.475  23.867  1.00 21.84           N  
ATOM    535  CA  ASN A  73      10.149  20.579  23.148  1.00 21.25           C  
ATOM    536  C   ASN A  73      10.005  20.327  21.686  1.00 23.85           C  
ATOM    537  O   ASN A  73      10.117  19.200  21.236  1.00 23.78           O  
ATOM    538  CB  ASN A  73      11.658  20.652  23.515  1.00 25.40           C  
ATOM    539  CG  ASN A  73      12.384  21.822  22.850  1.00 22.66           C  
ATOM    540  OD1 ASN A  73      12.826  21.730  21.696  1.00 23.80           O  
ATOM    541  ND2 ASN A  73      12.455  22.936  23.561  1.00 21.91           N  
ATOM    542  N   VAL A  74       9.762  21.393  20.935  1.00 24.57           N  
ATOM    543  CA  VAL A  74       9.845  21.313  19.487  1.00 22.50           C  
ATOM    544  C   VAL A  74      10.859  22.325  19.031  1.00 21.52           C  
ATOM    545  O   VAL A  74      10.745  23.505  19.378  1.00 22.30           O  
ATOM    546  CB  VAL A  74       8.508  21.574  18.784  1.00 24.97           C  
ATOM    547  CG1 VAL A  74       8.667  21.186  17.303  1.00 26.97           C  
ATOM    548  CG2 VAL A  74       7.387  20.760  19.430  1.00 21.68           C  
ATOM    549  N   SER A  75      11.877  21.865  18.305  1.00 22.92           N  
ATOM    550  CA  SER A  75      12.866  22.778  17.782  1.00 24.37           C  
ATOM    551  C   SER A  75      12.717  22.937  16.267  1.00 23.92           C  
ATOM    552  O   SER A  75      12.428  21.986  15.541  1.00 22.22           O  
ATOM    553  CB  SER A  75      14.265  22.339  18.168  1.00 25.55           C  
ATOM    554  OG  SER A  75      14.646  21.128  17.540  1.00 29.94           O  
ATOM    555  N   PHE A  76      12.988  24.127  15.792  1.00 26.25           N  
ATOM    556  CA  PHE A  76      12.945  24.421  14.359  1.00 29.18           C  
ATOM    557  C   PHE A  76      14.257  25.065  13.990  1.00 32.56           C  
ATOM    558  O   PHE A  76      14.691  26.030  14.622  1.00 32.69           O  
ATOM    559  CB  PHE A  76      11.774  25.342  14.034  1.00 30.82           C  
ATOM    560  CG  PHE A  76      10.439  24.704  14.196  1.00 25.01           C  
ATOM    561  CD1 PHE A  76       9.870  23.986  13.175  1.00 26.20           C  
ATOM    562  CD2 PHE A  76       9.730  24.846  15.377  1.00 31.59           C  
ATOM    563  CE1 PHE A  76       8.611  23.403  13.321  1.00 34.12           C  
ATOM    564  CE2 PHE A  76       8.492  24.291  15.524  1.00 33.86           C  
ATOM    565  CZ  PHE A  76       7.930  23.546  14.488  1.00 31.44           C  
ATOM    566  N   SER A  77      14.960  24.509  13.009  1.00 30.44           N  
ATOM    567  CA  SER A  77      16.209  25.154  12.645  1.00 34.69           C  
ATOM    568  C   SER A  77      16.338  25.356  11.154  1.00 31.91           C  
ATOM    569  O   SER A  77      15.876  24.525  10.374  1.00 31.27           O  
ATOM    570  CB  SER A  77      17.399  24.429  13.246  1.00 34.85           C  
ATOM    571  OG  SER A  77      17.216  23.043  13.271  1.00 40.14           O  
ATOM    572  N   SER A  78      16.878  26.522  10.777  1.00 29.69           N  
ATOM    573  CA  SER A  78      17.146  26.839   9.390  1.00 29.72           C  
ATOM    574  C   SER A  78      18.376  27.730   9.315  1.00 26.83           C  
ATOM    575  O   SER A  78      18.282  28.944   9.477  1.00 23.70           O  
ATOM    576  CB  SER A  78      15.971  27.551   8.667  1.00 28.49           C  
ATOM    577  OG  SER A  78      16.348  27.817   7.311  1.00 32.30           O  
ATOM    578  N   PRO A  79      19.531  27.126   9.030  1.00 30.65           N  
ATOM    579  CA  PRO A  79      20.719  27.908   8.660  1.00 28.57           C  
ATOM    580  C   PRO A  79      20.463  28.903   7.546  1.00 26.85           C  
ATOM    581  O   PRO A  79      20.926  30.036   7.651  1.00 26.89           O  
ATOM    582  CB  PRO A  79      21.693  26.838   8.183  1.00 30.00           C  
ATOM    583  CG  PRO A  79      21.289  25.621   9.001  1.00 29.69           C  
ATOM    584  CD  PRO A  79      19.809  25.677   9.036  1.00 29.30           C  
ATOM    585  N   GLU A  80      19.754  28.498   6.490  1.00 23.99           N  
ATOM    586  CA  GLU A  80      19.521  29.376   5.337  1.00 25.84           C  
ATOM    587  C   GLU A  80      18.751  30.627   5.763  1.00 24.11           C  
ATOM    588  O   GLU A  80      18.966  31.709   5.218  1.00 23.34           O  
ATOM    589  CB  GLU A  80      18.739  28.657   4.215  1.00 27.87           C  
ATOM    590  CG  GLU A  80      19.567  27.727   3.325  1.00 35.41           C  
ATOM    591  CD  GLU A  80      18.822  27.217   2.059  1.00 34.19           C  
ATOM    592  OE1 GLU A  80      17.833  27.875   1.661  1.00 28.56           O  
ATOM    593  OE2 GLU A  80      19.251  26.178   1.461  1.00 35.98           O  
ATOM    594  N   GLN A  81      17.865  30.476   6.741  1.00 23.95           N  
ATOM    595  CA  GLN A  81      17.072  31.596   7.249  1.00 25.11           C  
ATOM    596  C   GLN A  81      17.706  32.193   8.484  1.00 24.62           C  
ATOM    597  O   GLN A  81      17.099  33.040   9.165  1.00 27.08           O  
ATOM    598  CB  GLN A  81      15.620  31.156   7.557  1.00 24.45           C  
ATOM    599  CG  GLN A  81      14.872  30.586   6.372  1.00 25.10           C  
ATOM    600  CD  GLN A  81      13.502  30.055   6.754  1.00 29.10           C  
ATOM    601  OE1 GLN A  81      12.822  30.608   7.632  1.00 29.19           O  
ATOM    602  NE2 GLN A  81      13.092  28.971   6.104  1.00 32.98           N  
ATOM    603  N   GLN A  82      18.911  31.735   8.822  1.00 25.40           N  
ATOM    604  CA  GLN A  82      19.620  32.244   9.967  1.00 25.70           C  
ATOM    605  C   GLN A  82      18.780  32.233  11.259  1.00 26.36           C  
ATOM    606  O   GLN A  82      18.631  33.255  11.927  1.00 26.39           O  
ATOM    607  CB  GLN A  82      20.059  33.676   9.683  1.00 27.51           C  
ATOM    608  CG  GLN A  82      20.945  33.855   8.452  1.00 29.29           C  
ATOM    609  CD  GLN A  82      21.540  35.258   8.401  1.00 32.71           C  
ATOM    610  OE1 GLN A  82      20.922  36.192   7.874  1.00 41.26           O  
ATOM    611  NE2 GLN A  82      22.746  35.413   8.969  1.00 34.47           N  
ATOM    612  N   ARG A  83      18.191  31.097  11.592  1.00 25.89           N  
ATOM    613  CA  ARG A  83      17.416  31.036  12.814  1.00 26.14           C  
ATOM    614  C   ARG A  83      17.254  29.646  13.402  1.00 20.82           C  
ATOM    615  O   ARG A  83      17.110  28.634  12.693  1.00 23.71           O  
ATOM    616  CB  ARG A  83      16.019  31.629  12.603  1.00 29.94           C  
ATOM    617  CG  ARG A  83      15.163  30.826  11.691  1.00 31.29           C  
ATOM    618  CD  ARG A  83      13.917  31.603  11.339  1.00 35.87           C  
ATOM    619  NE  ARG A  83      14.232  32.762  10.551  1.00 34.54           N  
ATOM    620  CZ  ARG A  83      13.341  33.599  10.030  1.00 35.14           C  
ATOM    621  NH1 ARG A  83      12.067  33.423  10.218  1.00 37.77           N  
ATOM    622  NH2 ARG A  83      13.743  34.616   9.292  1.00 38.79           N  
ATOM    623  N   TYR A  84      17.226  29.640  14.728  1.00 21.76           N  
ATOM    624  CA  TYR A  84      17.114  28.436  15.503  1.00 20.15           C  
ATOM    625  C   TYR A  84      16.079  28.751  16.557  1.00 22.39           C  
ATOM    626  O   TYR A  84      16.186  29.803  17.204  1.00 24.04           O  
ATOM    627  CB  TYR A  84      18.436  28.153  16.163  1.00 23.14           C  
ATOM    628  CG  TYR A  84      19.520  27.940  15.154  1.00 23.45           C  
ATOM    629  CD1 TYR A  84      20.237  29.011  14.651  1.00 32.24           C  
ATOM    630  CD2 TYR A  84      19.742  26.686  14.630  1.00 29.34           C  
ATOM    631  CE1 TYR A  84      21.172  28.820  13.685  1.00 35.42           C  
ATOM    632  CE2 TYR A  84      20.683  26.491  13.656  1.00 34.48           C  
ATOM    633  CZ  TYR A  84      21.374  27.554  13.196  1.00 31.40           C  
ATOM    634  OH  TYR A  84      22.334  27.364  12.231  1.00 42.96           O  
ATOM    635  N   VAL A  85      15.070  27.890  16.699  1.00 21.08           N  
ATOM    636  CA  VAL A  85      13.955  28.167  17.596  1.00 21.25           C  
ATOM    637  C   VAL A  85      13.713  26.964  18.498  1.00 22.80           C  
ATOM    638  O   VAL A  85      13.612  25.819  18.024  1.00 26.19           O  
ATOM    639  CB  VAL A  85      12.664  28.466  16.825  1.00 22.77           C  
ATOM    640  CG1 VAL A  85      11.505  28.855  17.799  1.00 21.37           C  
ATOM    641  CG2 VAL A  85      12.889  29.543  15.751  1.00 23.14           C  
ATOM    642  N   SER A  86      13.615  27.217  19.793  1.00 19.78           N  
ATOM    643  CA  SER A  86      13.254  26.180  20.760  1.00 18.85           C  
ATOM    644  C   SER A  86      11.886  26.508  21.354  1.00 19.87           C  
ATOM    645  O   SER A  86      11.725  27.563  21.970  1.00 24.14           O  
ATOM    646  CB  SER A  86      14.263  26.163  21.862  1.00 21.01           C  
ATOM    647  OG  SER A  86      13.885  25.353  22.960  1.00 23.82           O  
ATOM    648  N   ILE A  87      10.933  25.605  21.214  1.00 22.34           N  
ATOM    649  CA  ILE A  87       9.593  25.807  21.740  1.00 20.39           C  
ATOM    650  C   ILE A  87       9.330  24.827  22.868  1.00 23.09           C  
ATOM    651  O   ILE A  87       9.236  23.637  22.632  1.00 23.98           O  
ATOM    652  CB  ILE A  87       8.514  25.691  20.647  1.00 21.17           C  
ATOM    653  CG1 ILE A  87       8.787  26.744  19.560  1.00 22.19           C  
ATOM    654  CG2 ILE A  87       7.099  25.838  21.248  1.00 23.82           C  
ATOM    655  CD1 ILE A  87       7.893  26.701  18.328  1.00 23.98           C  
ATOM    656  N   SER A  88       9.205  25.342  24.085  1.00 20.19           N  
ATOM    657  CA  SER A  88       8.848  24.501  25.243  1.00 20.90           C  
ATOM    658  C   SER A  88       7.370  24.604  25.433  1.00 21.12           C  
ATOM    659  O   SER A  88       6.824  25.724  25.543  1.00 21.25           O  
ATOM    660  CB  SER A  88       9.528  24.970  26.530  1.00 24.07           C  
ATOM    661  OG  SER A  88      10.935  25.107  26.349  1.00 28.86           O  
ATOM    662  N   GLY A  89       6.717  23.454  25.537  1.00 22.18           N  
ATOM    663  CA  GLY A  89       5.285  23.399  25.740  1.00 24.17           C  
ATOM    664  C   GLY A  89       4.828  22.106  26.381  1.00 23.51           C  
ATOM    665  O   GLY A  89       5.642  21.238  26.740  1.00 23.39           O  
ATOM    666  N   THR A  90       3.513  21.966  26.467  1.00 22.51           N  
ATOM    667  CA  THR A  90       2.917  20.732  26.956  1.00 23.17           C  
ATOM    668  C   THR A  90       2.049  20.186  25.843  1.00 24.23           C  
ATOM    669  O   THR A  90       1.381  20.953  25.157  1.00 25.59           O  
ATOM    670  CB  THR A  90       2.088  20.931  28.244  1.00 24.64           C  
ATOM    671  OG1 THR A  90       0.979  21.800  28.000  1.00 22.71           O  
ATOM    672  CG2 THR A  90       2.961  21.482  29.412  1.00 23.93           C  
ATOM    673  N   SER A  91       2.010  18.867  25.731  1.00 23.16           N  
ATOM    674  CA  SER A  91       1.325  18.229  24.638  1.00 21.50           C  
ATOM    675  C   SER A  91       0.182  17.369  25.142  1.00 25.20           C  
ATOM    676  O   SER A  91       0.209  16.796  26.246  1.00 26.66           O  
ATOM    677  CB  SER A  91       2.352  17.402  23.828  1.00 24.11           C  
ATOM    678  OG  SER A  91       1.767  16.869  22.665  1.00 32.89           O  
ATOM    679  N   GLN A  92      -0.854  17.262  24.314  1.00 26.28           N  
ATOM    680  CA  GLN A  92      -1.968  16.419  24.645  1.00 26.95           C  
ATOM    681  C   GLN A  92      -2.483  15.790  23.358  1.00 23.88           C  
ATOM    682  O   GLN A  92      -2.457  16.401  22.281  1.00 24.21           O  
ATOM    683  CB  GLN A  92      -3.078  17.215  25.305  1.00 29.83           C  
ATOM    684  CG  GLN A  92      -3.639  18.313  24.508  1.00 35.36           C  
ATOM    685  CD  GLN A  92      -4.782  19.054  25.231  1.00 40.99           C  
ATOM    686  OE1 GLN A  92      -5.846  18.475  25.493  1.00 50.44           O  
ATOM    687  NE2 GLN A  92      -4.563  20.340  25.535  1.00 40.30           N  
ATOM    688  N   LEU A  93      -2.970  14.574  23.524  1.00 24.72           N  
ATOM    689  CA  LEU A  93      -3.553  13.818  22.422  1.00 23.02           C  
ATOM    690  C   LEU A  93      -4.972  14.336  22.201  1.00 25.26           C  
ATOM    691  O   LEU A  93      -5.766  14.408  23.149  1.00 28.15           O  
ATOM    692  CB  LEU A  93      -3.555  12.340  22.766  1.00 26.11           C  
ATOM    693  CG  LEU A  93      -4.173  11.413  21.691  1.00 24.28           C  
ATOM    694  CD1 LEU A  93      -3.295  11.345  20.486  1.00 23.39           C  
ATOM    695  CD2 LEU A  93      -4.430  10.022  22.272  1.00 26.86           C  
ATOM    696  N   VAL A  94      -5.295  14.676  20.962  1.00 26.39           N  
ATOM    697  CA  VAL A  94      -6.600  15.207  20.613  1.00 24.54           C  
ATOM    698  C   VAL A  94      -7.194  14.318  19.511  1.00 25.59           C  
ATOM    699  O   VAL A  94      -6.524  14.027  18.520  1.00 23.53           O  
ATOM    700  CB  VAL A  94      -6.500  16.661  20.164  1.00 22.89           C  
ATOM    701  CG1 VAL A  94      -7.856  17.186  19.573  1.00 22.50           C  
ATOM    702  CG2 VAL A  94      -6.025  17.557  21.346  1.00 25.41           C  
ATOM    703  N   LYS A  95      -8.449  13.926  19.700  1.00 24.88           N  
ATOM    704  CA  LYS A  95      -9.152  13.028  18.767  1.00 25.65           C  
ATOM    705  C   LYS A  95     -10.320  13.676  18.004  1.00 27.35           C  
ATOM    706  O   LYS A  95     -11.107  13.009  17.385  1.00 33.24           O  
ATOM    707  CB  LYS A  95      -9.634  11.824  19.550  1.00 27.65           C  
ATOM    708  CG  LYS A  95      -8.498  11.057  20.161  1.00 26.73           C  
ATOM    709  CD  LYS A  95      -8.984   9.811  20.821  1.00 30.44           C  
ATOM    710  CE  LYS A  95      -7.862   9.063  21.458  1.00 34.26           C  
ATOM    711  NZ  LYS A  95      -8.354   7.976  22.355  1.00 32.85           N  
ATOM    712  N   ASP A  96     -10.365  14.981  18.013  1.00 29.49           N  
ATOM    713  CA  ASP A  96     -11.381  15.783  17.349  1.00 29.61           C  
ATOM    714  C   ASP A  96     -11.324  15.759  15.835  1.00 29.51           C  
ATOM    715  O   ASP A  96     -10.485  16.394  15.228  1.00 29.26           O  
ATOM    716  CB  ASP A  96     -11.221  17.229  17.812  1.00 30.32           C  
ATOM    717  CG  ASP A  96     -12.367  18.105  17.388  1.00 40.05           C  
ATOM    718  OD1 ASP A  96     -12.699  18.119  16.191  1.00 41.56           O  
ATOM    719  OD2 ASP A  96     -12.922  18.791  18.263  1.00 53.09           O  
ATOM    720  N   ARG A  97     -12.299  15.100  15.226  1.00 27.37           N  
ATOM    721  CA  ARG A  97     -12.343  14.953  13.769  1.00 29.41           C  
ATOM    722  C   ARG A  97     -12.481  16.272  12.995  1.00 28.38           C  
ATOM    723  O   ARG A  97     -11.921  16.407  11.914  1.00 28.23           O  
ATOM    724  CB  ARG A  97     -13.479  14.016  13.397  1.00 33.34           C  
ATOM    725  CG  ARG A  97     -13.278  12.606  13.962  1.00 40.59           C  
ATOM    726  CD  ARG A  97     -12.211  11.856  13.203  1.00 49.50           C  
ATOM    727  NE  ARG A  97     -12.592  11.668  11.807  1.00 54.50           N  
ATOM    728  CZ  ARG A  97     -11.784  11.183  10.866  1.00 56.82           C  
ATOM    729  NH1 ARG A  97     -10.536  10.834  11.173  1.00 51.23           N  
ATOM    730  NH2 ARG A  97     -12.236  11.042   9.617  1.00 57.19           N  
ATOM    731  N   ASN A  98     -13.210  17.236  13.557  1.00 31.03           N  
ATOM    732  CA  ASN A  98     -13.360  18.550  12.922  1.00 32.69           C  
ATOM    733  C   ASN A  98     -12.002  19.262  12.830  1.00 30.64           C  
ATOM    734  O   ASN A  98     -11.620  19.788  11.782  1.00 27.79           O  
ATOM    735  CB  ASN A  98     -14.355  19.427  13.692  1.00 35.75           C  
ATOM    736  CG  ASN A  98     -15.813  18.871  13.672  1.00 45.64           C  
ATOM    737  OD1 ASN A  98     -16.329  18.474  12.627  1.00 42.64           O  
ATOM    738  ND2 ASN A  98     -16.469  18.866  14.840  1.00 52.53           N  
ATOM    739  N   LYS A  99     -11.255  19.251  13.914  1.00 29.59           N  
ATOM    740  CA  LYS A  99      -9.923  19.869  13.895  1.00 29.07           C  
ATOM    741  C   LYS A  99      -8.990  19.187  12.899  1.00 29.13           C  
ATOM    742  O   LYS A  99      -8.228  19.845  12.170  1.00 28.13           O  
ATOM    743  CB  LYS A  99      -9.291  19.883  15.275  1.00 30.81           C  
ATOM    744  CG  LYS A  99      -8.051  20.768  15.320  1.00 36.03           C  
ATOM    745  CD  LYS A  99      -8.389  22.270  15.278  1.00 42.30           C  
ATOM    746  CE  LYS A  99      -7.138  23.111  14.996  1.00 45.85           C  
ATOM    747  NZ  LYS A  99      -7.326  24.554  15.351  1.00 53.03           N  
HETATM  748  N   MSE A 100      -9.060  17.866  12.835  1.00 27.26           N  
HETATM  749  CA  MSE A 100      -8.306  17.143  11.816  1.00 28.52           C  
HETATM  750  C   MSE A 100      -8.664  17.569  10.416  1.00 26.94           C  
HETATM  751  O   MSE A 100      -7.781  17.792   9.600  1.00 28.85           O  
HETATM  752  CB  MSE A 100      -8.488  15.645  11.989  1.00 28.18           C  
HETATM  753  CG  MSE A 100      -7.651  15.144  13.154  1.00 29.92           C  
HETATM  754 SE   MSE A 100      -7.749  13.184  13.277  0.75 40.39          SE  
HETATM  755  CE  MSE A 100      -8.990  13.111  14.711  1.00 29.18           C  
ATOM    756  N   ARG A 101      -9.954  17.680  10.117  1.00 27.74           N  
ATOM    757  CA  ARG A 101     -10.353  18.170   8.816  1.00 28.82           C  
ATOM    758  C   ARG A 101      -9.784  19.543   8.557  1.00 27.02           C  
ATOM    759  O   ARG A 101      -9.271  19.816   7.479  1.00 28.53           O  
ATOM    760  CB  ARG A 101     -11.870  18.227   8.697  1.00 27.64           C  
ATOM    761  CG  ARG A 101     -12.449  16.914   8.306  1.00 40.20           C  
ATOM    762  CD  ARG A 101     -13.964  16.966   8.132  1.00 48.48           C  
ATOM    763  NE  ARG A 101     -14.526  15.830   8.858  1.00 56.34           N  
ATOM    764  CZ  ARG A 101     -15.105  15.896  10.056  1.00 56.36           C  
ATOM    765  NH1 ARG A 101     -15.290  17.062  10.668  1.00 54.95           N  
ATOM    766  NH2 ARG A 101     -15.545  14.781  10.632  1.00 56.64           N  
ATOM    767  N   GLU A 102      -9.894  20.405   9.554  1.00 29.74           N  
ATOM    768  CA  GLU A 102      -9.436  21.781   9.425  0.50 30.08           C  
ATOM    770  C   GLU A 102      -7.933  21.837   9.138  1.00 31.33           C  
ATOM    771  O   GLU A 102      -7.483  22.637   8.333  1.00 31.40           O  
ATOM    772  CB  GLU A 102      -9.797  22.573  10.692  0.50 31.11           C  
ATOM    774  CG  GLU A 102     -11.291  22.800  10.832  0.50 31.67           C  
ATOM    776  CD  GLU A 102     -11.695  23.677  12.012  0.50 30.27           C  
ATOM    778  OE1 GLU A 102     -11.128  23.546  13.114  0.50 35.65           O  
ATOM    780  OE2 GLU A 102     -12.614  24.502  11.831  0.50 34.41           O  
ATOM    782  N   LEU A 103      -7.160  20.964   9.778  1.00 26.92           N  
ATOM    783  CA  LEU A 103      -5.697  21.015   9.691  1.00 30.63           C  
ATOM    784  C   LEU A 103      -5.052  20.146   8.616  1.00 32.22           C  
ATOM    785  O   LEU A 103      -3.880  20.337   8.294  1.00 33.61           O  
ATOM    786  CB  LEU A 103      -5.111  20.593  11.033  1.00 30.41           C  
ATOM    787  CG  LEU A 103      -5.367  21.520  12.213  1.00 32.90           C  
ATOM    788  CD1 LEU A 103      -4.934  20.883  13.471  1.00 33.49           C  
ATOM    789  CD2 LEU A 103      -4.645  22.844  12.027  1.00 38.03           C  
ATOM    790  N   TRP A 104      -5.780  19.164   8.098  1.00 31.20           N  
ATOM    791  CA  TRP A 104      -5.226  18.257   7.115  1.00 33.76           C  
ATOM    792  C   TRP A 104      -4.679  18.977   5.886  1.00 36.07           C  
ATOM    793  O   TRP A 104      -5.315  19.877   5.370  1.00 39.12           O  
ATOM    794  CB  TRP A 104      -6.295  17.257   6.655  1.00 32.84           C  
ATOM    795  CG  TRP A 104      -5.767  16.347   5.591  1.00 32.77           C  
ATOM    796  CD1 TRP A 104      -6.005  16.416   4.253  1.00 35.40           C  
ATOM    797  CD2 TRP A 104      -4.861  15.258   5.783  1.00 29.78           C  
ATOM    798  NE1 TRP A 104      -5.311  15.426   3.595  1.00 34.35           N  
ATOM    799  CE2 TRP A 104      -4.598  14.703   4.515  1.00 33.15           C  
ATOM    800  CE3 TRP A 104      -4.243  14.700   6.906  1.00 31.17           C  
ATOM    801  CZ2 TRP A 104      -3.759  13.614   4.341  1.00 32.96           C  
ATOM    802  CZ3 TRP A 104      -3.402  13.617   6.727  1.00 29.79           C  
ATOM    803  CH2 TRP A 104      -3.171  13.089   5.459  1.00 34.42           C  
ATOM    804  N   LYS A 105      -3.513  18.557   5.408  1.00 38.32           N  
ATOM    805  CA  LYS A 105      -2.997  18.997   4.112  1.00 41.54           C  
ATOM    806  C   LYS A 105      -2.527  17.775   3.310  1.00 40.48           C  
ATOM    807  O   LYS A 105      -2.028  16.809   3.899  1.00 39.84           O  
ATOM    808  CB  LYS A 105      -1.860  20.017   4.300  1.00 41.48           C  
ATOM    809  CG  LYS A 105      -0.598  19.443   4.947  1.00 44.94           C  
ATOM    810  CD  LYS A 105       0.290  20.498   5.616  1.00 45.46           C  
ATOM    811  CE  LYS A 105       1.720  19.981   5.798  1.00 52.92           C  
ATOM    812  NZ  LYS A 105       2.326  20.342   7.127  1.00 53.00           N  
ATOM    813  N   PRO A 106      -2.669  17.810   1.971  1.00 40.71           N  
ATOM    814  CA  PRO A 106      -2.334  16.669   1.101  1.00 39.71           C  
ATOM    815  C   PRO A 106      -0.918  16.114   1.281  1.00 39.28           C  
ATOM    816  O   PRO A 106      -0.695  14.918   1.112  1.00 39.17           O  
ATOM    817  CB  PRO A 106      -2.486  17.252  -0.306  1.00 39.95           C  
ATOM    818  CG  PRO A 106      -3.462  18.339  -0.148  1.00 40.27           C  
ATOM    819  CD  PRO A 106      -3.182  18.947   1.186  1.00 41.51           C  
ATOM    820  N   GLU A 107       0.026  16.970   1.635  1.00 38.11           N  
ATOM    821  CA  GLU A 107       1.405  16.549   1.832  1.00 39.41           C  
ATOM    822  C   GLU A 107       1.556  15.473   2.907  1.00 39.06           C  
ATOM    823  O   GLU A 107       2.494  14.663   2.878  1.00 39.65           O  
ATOM    824  CB  GLU A 107       2.277  17.754   2.207  1.00 42.03           C  
ATOM    825  CG  GLU A 107       2.159  18.932   1.236  1.00 47.50           C  
ATOM    826  CD  GLU A 107       1.010  19.877   1.569  1.00 50.60           C  
ATOM    827  OE1 GLU A 107       1.135  20.635   2.555  1.00 63.99           O  
ATOM    828  OE2 GLU A 107      -0.007  19.864   0.843  1.00 58.79           O  
ATOM    829  N   LEU A 108       0.641  15.469   3.869  1.00 37.63           N  
ATOM    830  CA  LEU A 108       0.724  14.538   4.990  1.00 36.00           C  
ATOM    831  C   LEU A 108       0.450  13.084   4.593  1.00 34.10           C  
ATOM    832  O   LEU A 108       0.719  12.177   5.369  1.00 32.16           O  
ATOM    833  CB  LEU A 108      -0.240  14.964   6.095  1.00 34.24           C  
ATOM    834  CG  LEU A 108       0.180  16.261   6.777  1.00 35.02           C  
ATOM    835  CD1 LEU A 108      -0.851  16.658   7.811  1.00 33.19           C  
ATOM    836  CD2 LEU A 108       1.547  16.127   7.423  1.00 37.84           C  
ATOM    837  N   GLN A 109      -0.063  12.869   3.389  1.00 33.66           N  
ATOM    838  CA  GLN A 109      -0.320  11.512   2.917  1.00 35.04           C  
ATOM    839  C   GLN A 109       0.945  10.651   2.842  1.00 35.62           C  
ATOM    840  O   GLN A 109       0.869   9.435   2.903  1.00 33.18           O  
ATOM    841  CB  GLN A 109      -0.992  11.540   1.566  1.00 34.78           C  
ATOM    842  CG  GLN A 109      -1.536  10.198   1.193  1.00 42.89           C  
ATOM    843  CD  GLN A 109      -2.179  10.188  -0.157  1.00 45.43           C  
ATOM    844  OE1 GLN A 109      -2.965  11.077  -0.492  1.00 48.92           O  
ATOM    845  NE2 GLN A 109      -1.860   9.170  -0.948  1.00 53.04           N  
ATOM    846  N   THR A 110       2.110  11.291   2.757  1.00 36.90           N  
ATOM    847  CA  THR A 110       3.384  10.591   2.861  1.00 35.49           C  
ATOM    848  C   THR A 110       3.502   9.754   4.127  1.00 33.61           C  
ATOM    849  O   THR A 110       4.026   8.642   4.080  1.00 32.50           O  
ATOM    850  CB  THR A 110       4.567  11.578   2.856  1.00 35.05           C  
ATOM    851  OG1 THR A 110       4.600  12.264   1.604  1.00 39.10           O  
ATOM    852  CG2 THR A 110       5.898  10.841   3.066  1.00 36.92           C  
ATOM    853  N   TRP A 111       3.073  10.302   5.261  1.00 32.30           N  
ATOM    854  CA  TRP A 111       3.183   9.578   6.529  1.00 33.00           C  
ATOM    855  C   TRP A 111       1.845   8.998   6.958  1.00 29.96           C  
ATOM    856  O   TRP A 111       1.818   8.171   7.872  1.00 29.52           O  
ATOM    857  CB  TRP A 111       3.771  10.473   7.635  1.00 36.44           C  
ATOM    858  CG  TRP A 111       5.082  11.009   7.218  1.00 40.66           C  
ATOM    859  CD1 TRP A 111       6.290  10.374   7.280  1.00 44.13           C  
ATOM    860  CD2 TRP A 111       5.314  12.258   6.578  1.00 38.95           C  
ATOM    861  NE1 TRP A 111       7.267  11.169   6.732  1.00 43.78           N  
ATOM    862  CE2 TRP A 111       6.694  12.333   6.295  1.00 41.57           C  
ATOM    863  CE3 TRP A 111       4.493  13.334   6.228  1.00 44.19           C  
ATOM    864  CZ2 TRP A 111       7.268  13.439   5.672  1.00 44.61           C  
ATOM    865  CZ3 TRP A 111       5.072  14.443   5.616  1.00 44.45           C  
ATOM    866  CH2 TRP A 111       6.441  14.486   5.346  1.00 44.30           C  
ATOM    867  N   PHE A 112       0.771   9.436   6.290  1.00 27.73           N  
ATOM    868  CA  PHE A 112      -0.627   9.013   6.557  1.00 27.37           C  
ATOM    869  C   PHE A 112      -1.333   8.638   5.247  1.00 25.92           C  
ATOM    870  O   PHE A 112      -2.166   9.386   4.718  1.00 26.69           O  
ATOM    871  CB  PHE A 112      -1.387  10.122   7.310  1.00 28.25           C  
ATOM    872  CG  PHE A 112      -0.746  10.504   8.601  1.00 28.05           C  
ATOM    873  CD1 PHE A 112      -0.998   9.786   9.757  1.00 23.23           C  
ATOM    874  CD2 PHE A 112       0.150  11.565   8.674  1.00 31.62           C  
ATOM    875  CE1 PHE A 112      -0.381  10.117  10.953  1.00 29.98           C  
ATOM    876  CE2 PHE A 112       0.757  11.895   9.863  1.00 28.30           C  
ATOM    877  CZ  PHE A 112       0.502  11.175  11.001  1.00 31.89           C  
ATOM    878  N   PRO A 113      -0.998   7.464   4.697  1.00 24.56           N  
ATOM    879  CA  PRO A 113      -1.490   7.075   3.359  1.00 24.47           C  
ATOM    880  C   PRO A 113      -3.006   7.092   3.156  1.00 26.42           C  
ATOM    881  O   PRO A 113      -3.447   7.495   2.087  1.00 26.61           O  
ATOM    882  CB  PRO A 113      -0.931   5.657   3.181  1.00 25.33           C  
ATOM    883  CG  PRO A 113       0.273   5.648   4.048  1.00 26.31           C  
ATOM    884  CD  PRO A 113      -0.099   6.446   5.250  1.00 23.15           C  
ATOM    885  N   LYS A 114      -3.799   6.656   4.131  1.00 25.57           N  
ATOM    886  CA  LYS A 114      -5.259   6.710   3.982  1.00 26.94           C  
ATOM    887  C   LYS A 114      -5.806   8.068   4.431  1.00 24.86           C  
ATOM    888  O   LYS A 114      -7.023   8.252   4.548  1.00 23.60           O  
ATOM    889  CB  LYS A 114      -5.957   5.610   4.788  1.00 26.27           C  
ATOM    890  CG  LYS A 114      -5.516   4.194   4.483  1.00 29.80           C  
ATOM    891  CD  LYS A 114      -6.444   3.192   5.197  1.00 34.51           C  
ATOM    892  CE  LYS A 114      -5.781   1.805   5.433  1.00 45.49           C  
ATOM    893  NZ  LYS A 114      -6.202   1.140   6.744  1.00 39.73           N  
ATOM    894  N   GLY A 115      -4.916   9.020   4.684  1.00 25.12           N  
ATOM    895  CA  GLY A 115      -5.344  10.323   5.151  1.00 24.82           C  
ATOM    896  C   GLY A 115      -6.203  10.234   6.384  1.00 24.64           C  
ATOM    897  O   GLY A 115      -5.868   9.536   7.342  1.00 21.36           O  
ATOM    898  N   LEU A 116      -7.305  10.965   6.374  1.00 24.50           N  
ATOM    899  CA  LEU A 116      -8.160  11.037   7.546  1.00 24.36           C  
ATOM    900  C   LEU A 116      -8.946   9.735   7.746  1.00 25.28           C  
ATOM    901  O   LEU A 116      -9.599   9.564   8.754  1.00 27.32           O  
ATOM    902  CB  LEU A 116      -9.102  12.239   7.440  1.00 26.69           C  
ATOM    903  CG  LEU A 116      -8.388  13.616   7.496  1.00 29.65           C  
ATOM    904  CD1 LEU A 116      -9.410  14.731   7.428  1.00 36.89           C  
ATOM    905  CD2 LEU A 116      -7.568  13.760   8.719  1.00 32.44           C  
ATOM    906  N   ASP A 117      -8.892   8.827   6.776  1.00 24.95           N  
ATOM    907  CA  ASP A 117      -9.433   7.490   6.972  1.00 26.05           C  
ATOM    908  C   ASP A 117      -8.466   6.489   7.628  1.00 26.09           C  
ATOM    909  O   ASP A 117      -8.849   5.337   7.833  1.00 24.89           O  
ATOM    910  CB  ASP A 117      -9.911   6.923   5.637  1.00 24.85           C  
ATOM    911  CG  ASP A 117     -11.197   7.583   5.154  1.00 29.72           C  
ATOM    912  OD1 ASP A 117     -11.891   8.249   5.966  1.00 31.14           O  
ATOM    913  OD2 ASP A 117     -11.516   7.415   3.969  1.00 36.79           O  
ATOM    914  N   GLU A 118      -7.237   6.907   7.944  1.00 24.83           N  
ATOM    915  CA  GLU A 118      -6.331   6.079   8.763  1.00 22.56           C  
ATOM    916  C   GLU A 118      -7.056   5.757  10.077  1.00 23.44           C  
ATOM    917  O   GLU A 118      -7.521   6.663  10.740  1.00 23.19           O  
ATOM    918  CB  GLU A 118      -5.016   6.812   9.062  1.00 23.19           C  
ATOM    919  CG  GLU A 118      -3.989   6.794   7.928  1.00 24.31           C  
ATOM    920  CD  GLU A 118      -3.482   5.388   7.570  1.00 24.31           C  
ATOM    921  OE1 GLU A 118      -3.556   4.460   8.414  1.00 23.67           O  
ATOM    922  OE2 GLU A 118      -3.021   5.217   6.429  1.00 24.68           O  
ATOM    923  N   PRO A 119      -7.177   4.472  10.446  1.00 20.42           N  
ATOM    924  CA  PRO A 119      -7.909   4.141  11.671  1.00 19.98           C  
ATOM    925  C   PRO A 119      -7.302   4.701  12.933  1.00 18.81           C  
ATOM    926  O   PRO A 119      -8.011   4.939  13.900  1.00 21.65           O  
ATOM    927  CB  PRO A 119      -7.890   2.600  11.707  1.00 22.53           C  
ATOM    928  CG  PRO A 119      -6.804   2.203  10.780  1.00 21.75           C  
ATOM    929  CD  PRO A 119      -6.681   3.268   9.756  1.00 25.07           C  
ATOM    930  N   ASP A 120      -5.994   4.915  12.954  1.00 19.54           N  
ATOM    931  CA  ASP A 120      -5.346   5.322  14.171  1.00 19.03           C  
ATOM    932  C   ASP A 120      -4.834   6.766  14.174  1.00 19.98           C  
ATOM    933  O   ASP A 120      -4.065   7.163  15.055  1.00 21.47           O  
ATOM    934  CB  ASP A 120      -4.194   4.361  14.458  1.00 19.04           C  
ATOM    935  CG  ASP A 120      -3.819   4.350  15.924  1.00 22.56           C  
ATOM    936  OD1 ASP A 120      -4.771   4.334  16.730  1.00 24.44           O  
ATOM    937  OD2 ASP A 120      -2.611   4.311  16.239  1.00 19.27           O  
ATOM    938  N   ILE A 121      -5.226   7.551  13.188  1.00 20.86           N  
ATOM    939  CA  ILE A 121      -4.685   8.893  13.076  1.00 21.61           C  
ATOM    940  C   ILE A 121      -5.345   9.797  14.142  1.00 20.36           C  
ATOM    941  O   ILE A 121      -6.543   9.678  14.409  1.00 20.26           O  
ATOM    942  CB  ILE A 121      -4.880   9.477  11.655  1.00 20.48           C  
ATOM    943  CG1 ILE A 121      -4.060  10.779  11.506  1.00 23.27           C  
ATOM    944  CG2 ILE A 121      -6.362   9.674  11.330  1.00 22.19           C  
ATOM    945  CD1 ILE A 121      -4.099  11.374  10.061  1.00 23.34           C  
ATOM    946  N   ALA A 122      -4.563  10.689  14.716  1.00 20.86           N  
ATOM    947  CA  ALA A 122      -5.005  11.626  15.725  1.00 21.02           C  
ATOM    948  C   ALA A 122      -4.099  12.872  15.657  1.00 23.57           C  
ATOM    949  O   ALA A 122      -3.293  13.022  14.721  1.00 22.21           O  
ATOM    950  CB  ALA A 122      -4.972  11.000  17.146  1.00 22.09           C  
ATOM    951  N   LEU A 123      -4.314  13.782  16.602  1.00 22.73           N  
ATOM    952  CA  LEU A 123      -3.538  15.015  16.705  1.00 23.84           C  
ATOM    953  C   LEU A 123      -2.815  15.109  18.034  1.00 25.35           C  
ATOM    954  O   LEU A 123      -3.283  14.612  19.078  1.00 24.25           O  
ATOM    955  CB  LEU A 123      -4.432  16.267  16.543  1.00 25.19           C  
ATOM    956  CG  LEU A 123      -5.011  16.617  15.178  1.00 24.65           C  
ATOM    957  CD1 LEU A 123      -6.232  17.574  15.357  1.00 25.59           C  
ATOM    958  CD2 LEU A 123      -3.983  17.193  14.201  1.00 24.75           C  
ATOM    959  N   LEU A 124      -1.637  15.726  17.979  1.00 25.15           N  
ATOM    960  CA  LEU A 124      -0.981  16.252  19.162  1.00 26.22           C  
ATOM    961  C   LEU A 124      -1.097  17.769  19.149  1.00 24.25           C  
ATOM    962  O   LEU A 124      -0.687  18.453  18.184  1.00 26.58           O  
ATOM    963  CB  LEU A 124       0.487  15.867  19.181  1.00 27.28           C  
ATOM    964  CG  LEU A 124       0.789  14.400  19.436  1.00 26.20           C  
ATOM    965  CD1 LEU A 124       2.309  14.146  19.263  1.00 26.37           C  
ATOM    966  CD2 LEU A 124       0.302  13.936  20.787  1.00 31.95           C  
ATOM    967  N   LYS A 125      -1.651  18.288  20.224  1.00 24.88           N  
ATOM    968  CA  LYS A 125      -1.739  19.720  20.434  1.00 25.33           C  
ATOM    969  C   LYS A 125      -0.604  20.085  21.367  1.00 28.27           C  
ATOM    970  O   LYS A 125      -0.428  19.420  22.390  1.00 29.35           O  
ATOM    971  CB  LYS A 125      -3.043  20.077  21.102  1.00 25.46           C  
ATOM    972  CG  LYS A 125      -3.244  21.578  21.260  1.00 28.19           C  
ATOM    973  CD  LYS A 125      -4.470  21.864  22.065  1.00 31.45           C  
ATOM    974  CE  LYS A 125      -4.715  23.354  22.196  1.00 37.74           C  
ATOM    975  NZ  LYS A 125      -5.965  23.602  22.954  1.00 42.49           N  
ATOM    976  N   VAL A 126       0.167  21.101  21.011  1.00 22.71           N  
ATOM    977  CA  VAL A 126       1.240  21.601  21.898  1.00 20.82           C  
ATOM    978  C   VAL A 126       0.862  23.022  22.344  1.00 22.74           C  
ATOM    979  O   VAL A 126       0.784  23.925  21.534  1.00 23.24           O  
ATOM    980  CB  VAL A 126       2.615  21.591  21.259  1.00 22.49           C  
ATOM    981  CG1 VAL A 126       3.662  22.103  22.272  1.00 20.99           C  
ATOM    982  CG2 VAL A 126       2.999  20.167  20.795  1.00 23.13           C  
ATOM    983  N   ASN A 127       0.566  23.160  23.640  1.00 22.58           N  
ATOM    984  CA  ASN A 127       0.372  24.453  24.292  1.00 22.78           C  
ATOM    985  C   ASN A 127       1.718  25.074  24.611  1.00 20.59           C  
ATOM    986  O   ASN A 127       2.476  24.539  25.392  1.00 22.93           O  
ATOM    987  CB  ASN A 127      -0.405  24.327  25.593  1.00 24.37           C  
ATOM    988  CG  ASN A 127      -1.891  24.418  25.374  1.00 42.95           C  
ATOM    989  OD1 ASN A 127      -2.469  23.547  24.773  1.00 37.60           O  
ATOM    990  ND2 ASN A 127      -2.501  25.518  25.818  1.00 54.67           N  
ATOM    991  N   ILE A 128       2.017  26.212  24.001  1.00 21.29           N  
ATOM    992  CA  ILE A 128       3.341  26.775  24.104  1.00 20.33           C  
ATOM    993  C   ILE A 128       3.504  27.543  25.403  1.00 23.08           C  
ATOM    994  O   ILE A 128       2.663  28.370  25.748  1.00 21.64           O  
ATOM    995  CB  ILE A 128       3.627  27.706  22.917  1.00 19.71           C  
ATOM    996  CG1 ILE A 128       3.575  26.924  21.609  1.00 22.47           C  
ATOM    997  CG2 ILE A 128       5.020  28.372  23.066  1.00 22.92           C  
ATOM    998  CD1 ILE A 128       3.758  27.784  20.361  1.00 22.95           C  
ATOM    999  N   ASN A 129       4.588  27.277  26.114  1.00 21.22           N  
ATOM   1000  CA  ASN A 129       4.872  27.984  27.340  1.00 22.64           C  
ATOM   1001  C   ASN A 129       5.970  29.031  27.127  1.00 23.82           C  
ATOM   1002  O   ASN A 129       5.932  30.136  27.669  1.00 23.67           O  
ATOM   1003  CB  ASN A 129       5.308  26.988  28.436  1.00 24.67           C  
ATOM   1004  CG  ASN A 129       4.299  25.889  28.694  1.00 24.14           C  
ATOM   1005  OD1 ASN A 129       4.676  24.728  28.771  1.00 27.69           O  
ATOM   1006  ND2 ASN A 129       3.018  26.240  28.832  1.00 22.87           N  
ATOM   1007  N   GLN A 130       7.008  28.636  26.415  1.00 22.67           N  
ATOM   1008  CA  GLN A 130       8.170  29.505  26.210  1.00 24.82           C  
ATOM   1009  C   GLN A 130       8.799  29.250  24.871  1.00 25.02           C  
ATOM   1010  O   GLN A 130       8.866  28.099  24.389  1.00 24.72           O  
ATOM   1011  CB  GLN A 130       9.194  29.228  27.314  1.00 24.75           C  
ATOM   1012  CG  GLN A 130      10.354  30.192  27.390  1.00 35.25           C  
ATOM   1013  CD  GLN A 130      11.382  29.783  28.450  1.00 37.12           C  
ATOM   1014  OE1 GLN A 130      12.556  29.508  28.142  1.00 50.78           O  
ATOM   1015  NE2 GLN A 130      10.941  29.723  29.685  1.00 36.22           N  
ATOM   1016  N   VAL A 131       9.245  30.319  24.233  1.00 21.46           N  
ATOM   1017  CA  VAL A 131       9.975  30.227  22.989  1.00 21.81           C  
ATOM   1018  C   VAL A 131      11.326  30.924  23.216  1.00 24.58           C  
ATOM   1019  O   VAL A 131      11.385  32.068  23.659  1.00 23.89           O  
ATOM   1020  CB  VAL A 131       9.264  30.921  21.832  1.00 23.54           C  
ATOM   1021  CG1 VAL A 131      10.082  30.776  20.532  1.00 22.33           C  
ATOM   1022  CG2 VAL A 131       7.871  30.320  21.607  1.00 24.31           C  
ATOM   1023  N   ASN A 132      12.404  30.206  22.936  1.00 22.11           N  
ATOM   1024  CA  ASN A 132      13.726  30.784  22.936  1.00 23.66           C  
ATOM   1025  C   ASN A 132      14.220  30.723  21.534  1.00 25.82           C  
ATOM   1026  O   ASN A 132      14.103  29.688  20.886  1.00 23.80           O  
ATOM   1027  CB  ASN A 132      14.609  30.000  23.874  1.00 24.96           C  
ATOM   1028  CG  ASN A 132      14.124  30.099  25.296  1.00 33.61           C  
ATOM   1029  OD1 ASN A 132      14.173  31.166  25.888  1.00 36.06           O  
ATOM   1030  ND2 ASN A 132      13.619  29.010  25.839  1.00 38.40           N  
ATOM   1031  N   TYR A 133      14.736  31.833  21.036  1.00 23.85           N  
ATOM   1032  CA  TYR A 133      15.240  31.833  19.656  1.00 24.31           C  
ATOM   1033  C   TYR A 133      16.539  32.607  19.488  1.00 24.98           C  
ATOM   1034  O   TYR A 133      16.892  33.473  20.304  1.00 24.39           O  
ATOM   1035  CB  TYR A 133      14.168  32.313  18.696  1.00 24.94           C  
ATOM   1036  CG  TYR A 133      13.778  33.751  18.876  1.00 26.37           C  
ATOM   1037  CD1 TYR A 133      12.787  34.116  19.783  1.00 31.16           C  
ATOM   1038  CD2 TYR A 133      14.404  34.755  18.156  1.00 32.56           C  
ATOM   1039  CE1 TYR A 133      12.423  35.449  19.932  1.00 31.98           C  
ATOM   1040  CE2 TYR A 133      14.069  36.071  18.326  1.00 38.07           C  
ATOM   1041  CZ  TYR A 133      13.076  36.415  19.199  1.00 36.90           C  
ATOM   1042  OH  TYR A 133      12.774  37.768  19.350  1.00 43.12           O  
ATOM   1043  N   TRP A 134      17.270  32.206  18.457  1.00 24.27           N  
ATOM   1044  CA  TRP A 134      18.534  32.785  18.091  1.00 23.21           C  
ATOM   1045  C   TRP A 134      18.399  33.083  16.613  1.00 24.81           C  
ATOM   1046  O   TRP A 134      18.169  32.190  15.833  1.00 25.59           O  
ATOM   1047  CB  TRP A 134      19.683  31.800  18.328  1.00 24.86           C  
ATOM   1048  CG  TRP A 134      19.908  31.373  19.749  1.00 24.17           C  
ATOM   1049  CD1 TRP A 134      20.911  31.792  20.590  1.00 30.07           C  
ATOM   1050  CD2 TRP A 134      19.132  30.431  20.505  1.00 23.04           C  
ATOM   1051  NE1 TRP A 134      20.798  31.159  21.816  1.00 27.99           N  
ATOM   1052  CE2 TRP A 134      19.715  30.331  21.785  1.00 25.96           C  
ATOM   1053  CE3 TRP A 134      18.017  29.641  20.213  1.00 23.68           C  
ATOM   1054  CZ2 TRP A 134      19.204  29.480  22.775  1.00 23.45           C  
ATOM   1055  CZ3 TRP A 134      17.500  28.810  21.222  1.00 26.52           C  
ATOM   1056  CH2 TRP A 134      18.102  28.750  22.468  1.00 24.50           C  
ATOM   1057  N   ASP A 135      18.516  34.349  16.242  1.00 24.48           N  
ATOM   1058  CA  ASP A 135      18.425  34.703  14.831  1.00 26.66           C  
ATOM   1059  C   ASP A 135      19.204  35.926  14.408  1.00 27.61           C  
ATOM   1060  O   ASP A 135      19.783  36.644  15.219  1.00 30.00           O  
ATOM   1061  CB  ASP A 135      16.944  34.811  14.418  1.00 26.26           C  
ATOM   1062  CG  ASP A 135      16.243  36.072  14.943  1.00 35.75           C  
ATOM   1063  OD1 ASP A 135      16.878  36.909  15.618  1.00 37.56           O  
ATOM   1064  OD2 ASP A 135      15.018  36.203  14.672  1.00 37.94           O  
ATOM   1065  N   SER A 136      19.234  36.181  13.109  1.00 30.71           N  
ATOM   1066  CA  SER A 136      20.004  37.335  12.621  1.00 35.91           C  
ATOM   1067  C   SER A 136      19.544  38.660  13.278  1.00 35.36           C  
ATOM   1068  O   SER A 136      20.374  39.512  13.558  1.00 35.00           O  
ATOM   1069  CB  SER A 136      19.920  37.420  11.099  1.00 34.50           C  
ATOM   1070  OG  SER A 136      18.592  37.724  10.724  1.00 45.38           O  
ATOM   1071  N   THR A 137      18.242  38.827  13.528  1.00 37.24           N  
ATOM   1072  CA  THR A 137      17.729  40.021  14.261  1.00 40.00           C  
ATOM   1073  C   THR A 137      18.336  40.170  15.665  1.00 41.16           C  
ATOM   1074  O   THR A 137      18.625  41.275  16.104  1.00 47.07           O  
ATOM   1075  CB  THR A 137      16.151  40.078  14.383  1.00 41.53           C  
ATOM   1076  OG1 THR A 137      15.667  39.246  15.484  1.00 44.38           O  
ATOM   1077  CG2 THR A 137      15.492  39.701  13.046  1.00 43.87           C  
ATOM   1078  N   SER A 138      18.547  39.057  16.347  1.00 40.77           N  
ATOM   1079  CA  SER A 138      19.081  39.061  17.698  1.00 41.60           C  
ATOM   1080  C   SER A 138      20.607  39.026  17.713  1.00 39.40           C  
ATOM   1081  O   SER A 138      21.200  38.823  18.767  1.00 39.78           O  
ATOM   1082  CB  SER A 138      18.522  37.854  18.505  1.00 43.98           C  
ATOM   1083  OG  SER A 138      19.202  36.590  18.299  1.00 34.98           O  
ATOM   1084  N   SER A 139      21.239  39.183  16.550  1.00 36.36           N  
ATOM   1085  CA  SER A 139      22.670  38.888  16.411  1.00 35.18           C  
ATOM   1086  C   SER A 139      23.036  37.520  17.004  1.00 35.89           C  
ATOM   1087  O   SER A 139      24.124  37.335  17.543  1.00 33.69           O  
ATOM   1088  CB  SER A 139      23.482  40.008  17.059  1.00 37.41           C  
ATOM   1089  OG  SER A 139      23.097  41.252  16.486  1.00 36.61           O  
ATOM   1090  N   PHE A 140      22.105  36.573  16.893  1.00 35.41           N  
ATOM   1091  CA  PHE A 140      22.246  35.193  17.400  1.00 36.81           C  
ATOM   1092  C   PHE A 140      22.502  35.044  18.886  1.00 38.35           C  
ATOM   1093  O   PHE A 140      23.032  34.025  19.324  1.00 40.69           O  
ATOM   1094  CB  PHE A 140      23.320  34.438  16.618  1.00 37.34           C  
ATOM   1095  CG  PHE A 140      23.011  34.334  15.181  1.00 41.07           C  
ATOM   1096  CD1 PHE A 140      22.039  33.455  14.742  1.00 41.27           C  
ATOM   1097  CD2 PHE A 140      23.644  35.156  14.265  1.00 42.37           C  
ATOM   1098  CE1 PHE A 140      21.735  33.371  13.407  1.00 44.62           C  
ATOM   1099  CE2 PHE A 140      23.344  35.080  12.935  1.00 45.92           C  
ATOM   1100  CZ  PHE A 140      22.386  34.189  12.501  1.00 45.28           C  
ATOM   1101  N   LYS A 141      22.110  36.053  19.648  1.00 37.73           N  
ATOM   1102  CA  LYS A 141      22.097  35.973  21.102  1.00 38.25           C  
ATOM   1103  C   LYS A 141      20.678  35.566  21.506  1.00 36.43           C  
ATOM   1104  O   LYS A 141      19.716  35.962  20.845  1.00 36.86           O  
ATOM   1105  CB  LYS A 141      22.464  37.314  21.734  1.00 38.22           C  
ATOM   1106  CG  LYS A 141      23.913  37.751  21.443  1.00 37.07           C  
ATOM   1107  N   PRO A 142      20.548  34.819  22.607  1.00 35.83           N  
ATOM   1108  CA  PRO A 142      19.268  34.154  22.957  1.00 32.67           C  
ATOM   1109  C   PRO A 142      18.139  35.158  23.303  1.00 32.09           C  
ATOM   1110  O   PRO A 142      18.373  36.063  24.107  1.00 37.44           O  
ATOM   1111  CB  PRO A 142      19.646  33.296  24.176  1.00 33.36           C  
ATOM   1112  CG  PRO A 142      20.886  33.965  24.762  1.00 39.34           C  
ATOM   1113  CD  PRO A 142      21.611  34.570  23.599  1.00 37.79           C  
ATOM   1114  N   GLN A 143      16.986  35.056  22.642  1.00 25.50           N  
ATOM   1115  CA  GLN A 143      15.828  35.915  22.910  1.00 27.18           C  
ATOM   1116  C   GLN A 143      14.730  35.031  23.453  1.00 29.71           C  
ATOM   1117  O   GLN A 143      14.715  33.841  23.150  1.00 27.06           O  
ATOM   1118  CB  GLN A 143      15.326  36.566  21.637  1.00 30.17           C  
ATOM   1119  CG  GLN A 143      16.313  37.458  20.977  1.00 41.37           C  
ATOM   1120  CD  GLN A 143      16.456  38.740  21.719  1.00 47.08           C  
ATOM   1121  OE1 GLN A 143      17.258  38.852  22.650  1.00 58.83           O  
ATOM   1122  NE2 GLN A 143      15.660  39.724  21.332  1.00 59.11           N  
ATOM   1123  N   THR A 144      13.828  35.567  24.279  1.00 28.06           N  
ATOM   1124  CA  THR A 144      12.786  34.732  24.871  1.00 26.25           C  
ATOM   1125  C   THR A 144      11.407  35.363  24.810  1.00 30.17           C  
ATOM   1126  O   THR A 144      11.256  36.588  24.984  1.00 29.16           O  
ATOM   1127  CB  THR A 144      13.150  34.358  26.341  1.00 32.42           C  
ATOM   1128  OG1 THR A 144      14.480  33.847  26.380  1.00 40.63           O  
ATOM   1129  CG2 THR A 144      12.247  33.284  26.894  1.00 32.97           C  
ATOM   1130  N   ILE A 145      10.402  34.533  24.540  1.00 26.37           N  
ATOM   1131  CA  ILE A 145       8.978  34.927  24.580  1.00 27.59           C  
ATOM   1132  C   ILE A 145       8.352  33.957  25.565  1.00 26.69           C  
ATOM   1133  O   ILE A 145       8.621  32.773  25.443  1.00 24.89           O  
ATOM   1134  CB  ILE A 145       8.281  34.744  23.233  1.00 27.05           C  
ATOM   1135  CG1 ILE A 145       8.841  35.683  22.170  1.00 35.83           C  
ATOM   1136  CG2 ILE A 145       6.782  34.983  23.344  1.00 32.40           C  
ATOM   1137  CD1 ILE A 145       8.433  35.246  20.743  1.00 33.29           C  
ATOM   1138  N   SER A 146       7.572  34.447  26.528  1.00 26.35           N  
ATOM   1139  CA  SER A 146       6.887  33.594  27.488  1.00 27.01           C  
ATOM   1140  C   SER A 146       5.389  33.832  27.466  1.00 29.20           C  
ATOM   1141  O   SER A 146       4.948  34.975  27.416  1.00 26.81           O  
ATOM   1142  CB  SER A 146       7.421  33.813  28.906  1.00 32.93           C  
ATOM   1143  OG  SER A 146       8.597  33.072  29.098  1.00 44.55           O  
ATOM   1144  N   PHE A 147       4.627  32.749  27.494  1.00 24.18           N  
ATOM   1145  CA  PHE A 147       3.197  32.804  27.583  1.00 25.05           C  
ATOM   1146  C   PHE A 147       2.784  32.235  28.956  1.00 31.94           C  
ATOM   1147  O   PHE A 147       3.505  31.334  29.447  1.00 33.62           O  
ATOM   1148  CB  PHE A 147       2.562  31.997  26.470  1.00 26.66           C  
ATOM   1149  CG  PHE A 147       2.884  32.501  25.097  1.00 27.29           C  
ATOM   1150  CD1 PHE A 147       2.398  33.723  24.673  1.00 29.97           C  
ATOM   1151  CD2 PHE A 147       3.701  31.786  24.260  1.00 26.31           C  
ATOM   1152  CE1 PHE A 147       2.731  34.226  23.402  1.00 29.64           C  
ATOM   1153  CE2 PHE A 147       4.036  32.286  22.989  1.00 35.29           C  
ATOM   1154  CZ  PHE A 147       3.543  33.500  22.574  1.00 29.71           C  
ATOM   1155  OXT PHE A 147       1.770  32.663  29.561  1.00 29.67           O  
TER    1156      PHE A 147                                                      
END
MOLECULE T0497.pdb
ATOM      5  N   MET     1      13.726  45.186  17.326  1.00 86.05           N  
ATOM      6  CA  MET     1      13.854  43.790  16.854  1.00 85.86           C  
ATOM      7  C   MET     1      13.936  42.784  18.030  1.00 83.85           C  
ATOM      8  O   MET     1      13.538  41.620  17.875  1.00 83.45           O  
ATOM      9  CB  MET     1      15.056  43.633  15.890  1.00 86.69           C  
ATOM     10  CG  MET     1      16.377  43.182  16.523  1.00 88.68           C  
ATOM     11  SD  MET     1      17.988  43.731  15.614  0.75 92.01          SE  
ATOM     12  CE  MET     1      19.110  42.057  15.901  1.00 88.06           C  
ATOM     13  N   ALA     2      14.466  43.250  19.173  1.00 81.16           N  
ATOM     14  CA  ALA     2      14.590  42.453  20.391  1.00 79.87           C  
ATOM     15  C   ALA     2      13.345  42.445  21.296  1.00 78.34           C  
ATOM     16  O   ALA     2      13.382  41.748  22.306  1.00 77.90           O  
ATOM     17  CB  ALA     2      15.820  42.896  21.195  1.00 79.19           C  
ATOM     18  N   ASP     3      12.264  43.181  20.962  1.00 78.03           N  
ATOM     19  CA  ASP     3      11.048  43.193  21.798  0.50 77.68           C  
ATOM     21  C   ASP     3      10.259  41.889  21.613  1.00 78.01           C  
ATOM     22  O   ASP     3      10.343  41.273  20.544  1.00 77.66           O  
ATOM     23  CB  ASP     3      10.174  44.413  21.482  0.50 76.52           C  
ATOM     25  CG  ASP     3      10.832  45.730  21.887  0.50 70.99           C  
ATOM     27  OD1 ASP     3      11.319  45.846  23.031  0.50 59.83           O  
ATOM     29  OD2 ASP     3      10.834  46.662  21.065  0.50 63.66           O  
ATOM     31  N   PRO     4       9.492  41.452  22.649  1.00 78.39           N  
ATOM     32  CA  PRO     4       8.737  40.183  22.525  1.00 78.04           C  
ATOM     33  C   PRO     4       7.714  40.059  21.383  1.00 77.52           C  
ATOM     34  O   PRO     4       7.550  38.958  20.872  1.00 78.02           O  
ATOM     35  CB  PRO     4       8.035  40.049  23.895  1.00 77.81           C  
ATOM     36  CG  PRO     4       7.965  41.401  24.410  1.00 79.56           C  
ATOM     37  CD  PRO     4       9.243  42.058  23.973  1.00 78.48           C  
ATOM     38  N   LYS     5       7.054  41.151  20.996  1.00 77.64           N  
ATOM     39  CA  LYS     5       6.046  41.131  19.915  1.00 76.64           C  
ATOM     40  C   LYS     5       6.667  40.855  18.541  1.00 75.44           C  
ATOM     41  O   LYS     5       6.147  40.032  17.799  1.00 74.56           O  
ATOM     42  CB  LYS     5       5.236  42.433  19.904  1.00 77.43           C  
ATOM     43  CG  LYS     5       4.157  42.589  18.809  1.00 78.67           C  
ATOM     44  CD  LYS     5       3.166  41.414  18.745  1.00 83.74           C  
ATOM     45  CE  LYS     5       1.946  41.759  17.884  1.00 85.48           C  
ATOM     46  NZ  LYS     5       2.287  42.297  16.531  1.00 87.86           N  
ATOM     47  N   GLU     6       7.765  41.537  18.211  1.00 74.70           N  
ATOM     48  CA  GLU     6       8.451  41.325  16.925  1.00 74.09           C  
ATOM     49  C   GLU     6       9.058  39.927  16.840  1.00 72.42           C  
ATOM     50  O   GLU     6       9.009  39.306  15.782  1.00 71.12           O  
ATOM     51  CB  GLU     6       9.522  42.390  16.642  1.00 72.75           C  
ATOM     52  CG  GLU     6       8.964  43.783  16.364  1.00 74.88           C  
ATOM     53  N   LEU     7       9.619  39.446  17.952  1.00 71.95           N  
ATOM     54  CA  LEU     7      10.216  38.109  18.022  1.00 71.61           C  
ATOM     55  C   LEU     7       9.159  37.010  17.931  1.00 70.57           C  
ATOM     56  O   LEU     7       9.353  36.020  17.231  1.00 70.00           O  
ATOM     57  CB  LEU     7      11.053  37.939  19.297  1.00 72.48           C  
ATOM     58  CG  LEU     7      12.379  38.701  19.340  1.00 74.29           C  
ATOM     59  CD1 LEU     7      12.939  38.740  20.750  1.00 73.61           C  
ATOM     60  CD2 LEU     7      13.383  38.093  18.346  1.00 73.78           C  
ATOM     61  N   GLN     8       8.053  37.187  18.645  1.00 70.21           N  
ATOM     62  CA  GLN     8       6.950  36.242  18.577  1.00 70.98           C  
ATOM     63  C   GLN     8       6.400  36.178  17.129  1.00 70.04           C  
ATOM     64  O   GLN     8       6.181  35.094  16.610  1.00 69.96           O  
ATOM     65  CB  GLN     8       5.864  36.595  19.612  1.00 70.88           C  
ATOM     66  CG  GLN     8       4.709  35.596  19.639  1.00 74.74           C  
ATOM     67  CD  GLN     8       3.784  35.686  20.860  1.00 74.95           C  
ATOM     68  OE1 GLN     8       2.872  34.845  21.009  1.00 81.07           O  
ATOM     69  NE2 GLN     8       3.997  36.686  21.731  1.00 75.50           N  
ATOM     70  N   ASP     9       6.209  37.341  16.497  1.00 69.03           N  
ATOM     71  CA  ASP     9       5.728  37.442  15.104  1.00 68.39           C  
ATOM     72  C   ASP     9       6.646  36.715  14.117  1.00 67.45           C  
ATOM     73  O   ASP     9       6.150  35.967  13.266  1.00 68.40           O  
ATOM     74  CB  ASP     9       5.538  38.907  14.668  1.00 67.15           C  
ATOM     75  CG  ASP     9       4.327  39.587  15.326  1.00 68.12           C  
ATOM     76  OD1 ASP     9       3.360  38.916  15.752  1.00 66.97           O  
ATOM     77  OD2 ASP     9       4.336  40.835  15.391  1.00 72.15           O  
ATOM     78  N   LYS    10       7.958  36.932  14.238  1.00 65.30           N  
ATOM     79  CA  LYS    10       8.949  36.236  13.400  1.00 66.18           C  
ATOM     80  C   LYS    10       8.919  34.726  13.623  1.00 65.37           C  
ATOM     81  O   LYS    10       9.059  33.953  12.672  1.00 64.60           O  
ATOM     82  CB  LYS    10      10.379  36.717  13.676  1.00 66.97           C  
ATOM     83  CG  LYS    10      10.726  38.076  13.126  1.00 68.25           C  
ATOM     84  CD  LYS    10      12.172  38.403  13.489  1.00 67.43           C  
ATOM     85  CE  LYS    10      12.640  39.737  12.936  1.00 69.89           C  
ATOM     86  NZ  LYS    10      14.068  39.991  13.369  1.00 70.59           N  
ATOM     87  N   PHE    11       8.778  34.325  14.890  1.00 64.73           N  
ATOM     88  CA  PHE    11       8.679  32.908  15.248  1.00 64.13           C  
ATOM     89  C   PHE    11       7.501  32.203  14.554  1.00 62.79           C  
ATOM     90  O   PHE    11       7.703  31.224  13.846  1.00 62.00           O  
ATOM     91  CB  PHE    11       8.606  32.715  16.770  1.00 64.85           C  
ATOM     92  CG  PHE    11       8.128  31.361  17.169  1.00 65.60           C  
ATOM     93  CD1 PHE    11       8.969  30.261  17.035  1.00 65.90           C  
ATOM     94  CD2 PHE    11       6.821  31.171  17.631  1.00 66.31           C  
ATOM     95  CE1 PHE    11       8.527  28.974  17.367  1.00 65.48           C  
ATOM     96  CE2 PHE    11       6.373  29.897  17.971  1.00 65.66           C  
ATOM     97  CZ  PHE    11       7.240  28.793  17.849  1.00 64.98           C  
ATOM     98  N   TRP    12       6.290  32.699  14.786  1.00 62.76           N  
ATOM     99  CA  TRP    12       5.095  32.138  14.164  1.00 64.24           C  
ATOM    100  C   TRP    12       5.156  32.130  12.618  1.00 63.97           C  
ATOM    101  O   TRP    12       4.725  31.157  12.000  1.00 63.92           O  
ATOM    102  CB  TRP    12       3.829  32.863  14.604  1.00 65.03           C  
ATOM    103  CG  TRP    12       3.457  32.681  16.017  1.00 63.68           C  
ATOM    104  CD1 TRP    12       3.341  33.660  16.952  1.00 64.00           C  
ATOM    105  CD2 TRP    12       3.146  31.449  16.675  1.00 67.38           C  
ATOM    106  NE1 TRP    12       2.964  33.122  18.152  1.00 66.48           N  
ATOM    107  CE2 TRP    12       2.850  31.764  18.024  1.00 65.04           C  
ATOM    108  CE3 TRP    12       3.082  30.107  16.261  1.00 64.03           C  
ATOM    109  CZ2 TRP    12       2.478  30.790  18.967  1.00 66.99           C  
ATOM    110  CZ3 TRP    12       2.728  29.129  17.209  1.00 65.28           C  
ATOM    111  CH2 TRP    12       2.427  29.476  18.541  1.00 65.62           C  
ATOM    112  N   LYS    13       5.716  33.185  12.031  1.00 63.71           N  
ATOM    113  CA  LYS    13       5.891  33.272  10.576  1.00 65.47           C  
ATOM    114  C   LYS    13       6.833  32.171  10.061  1.00 64.51           C  
ATOM    115  O   LYS    13       6.554  31.527   9.035  1.00 63.48           O  
ATOM    116  CB  LYS    13       6.437  34.649  10.179  1.00 65.83           C  
ATOM    117  CG  LYS    13       6.467  34.958   8.674  1.00 65.60           C  
ATOM    118  CD  LYS    13       7.293  36.239   8.447  1.00 67.39           C  
ATOM    119  CE  LYS    13       7.540  36.582   6.978  1.00 72.72           C  
ATOM    120  NZ  LYS    13       6.403  37.268   6.291  1.00 77.16           N  
ATOM    121  N   ALA    14       7.934  31.957  10.781  1.00 63.23           N  
ATOM    122  CA  ALA    14       8.915  30.938  10.392  1.00 62.31           C  
ATOM    123  C   ALA    14       8.343  29.550  10.645  1.00 61.62           C  
ATOM    124  O   ALA    14       8.500  28.680   9.820  1.00 61.28           O  
ATOM    125  CB  ALA    14      10.220  31.124  11.128  1.00 62.06           C  
ATOM    126  N   LEU    15       7.661  29.360  11.774  1.00 63.05           N  
ATOM    127  CA  LEU    15       7.090  28.062  12.111  1.00 63.38           C  
ATOM    128  C   LEU    15       6.057  27.653  11.096  1.00 63.95           C  
ATOM    129  O   LEU    15       6.019  26.491  10.720  1.00 62.84           O  
ATOM    130  CB  LEU    15       6.436  28.052  13.493  1.00 63.75           C  
ATOM    131  CG  LEU    15       5.826  26.702  13.961  1.00 63.96           C  
ATOM    132  CD1 LEU    15       6.941  25.682  14.102  1.00 62.00           C  
ATOM    133  CD2 LEU    15       5.036  26.839  15.266  1.00 62.15           C  
ATOM    134  N   LYS    16       5.220  28.605  10.672  1.00 65.58           N  
ATOM    135  CA  LYS    16       4.143  28.292   9.740  1.00 66.91           C  
ATOM    136  C   LYS    16       4.657  27.898   8.345  1.00 66.08           C  
ATOM    137  O   LYS    16       4.116  26.984   7.737  1.00 66.49           O  
ATOM    138  CB  LYS    16       3.082  29.395   9.676  1.00 67.00           C  
ATOM    139  CG  LYS    16       1.879  28.927   8.881  1.00 69.94           C  
ATOM    140  CD  LYS    16       0.664  29.755   9.027  1.00 69.31           C  
ATOM    141  CE  LYS    16      -0.516  29.056   8.326  1.00 69.26           C  
ATOM    142  NZ  LYS    16      -1.008  27.907   9.104  1.00 65.56           N  
ATOM    143  N   SER    17       5.696  28.567   7.854  1.00 66.10           N  
ATOM    144  CA  SER    17       6.248  28.227   6.551  1.00 65.35           C  
ATOM    145  C   SER    17       7.270  27.069   6.578  1.00 65.04           C  
ATOM    146  O   SER    17       7.323  26.315   5.615  1.00 65.07           O  
ATOM    147  CB  SER    17       6.853  29.447   5.884  1.00 65.18           C  
ATOM    148  OG  SER    17       7.974  29.877   6.577  1.00 71.43           O  
ATOM    149  N   ASP    18       8.051  26.927   7.653  1.00 63.43           N  
ATOM    150  CA  ASP    18       9.121  25.920   7.718  1.00 63.53           C  
ATOM    151  C   ASP    18       8.739  24.638   8.462  1.00 63.23           C  
ATOM    152  O   ASP    18       9.279  23.584   8.157  1.00 62.99           O  
ATOM    153  CB  ASP    18      10.405  26.562   8.246  1.00 63.75           C  
ATOM    154  CG  ASP    18      10.870  27.725   7.383  1.00 61.31           C  
ATOM    155  OD1 ASP    18      10.465  27.840   6.209  1.00 63.82           O  
ATOM    156  OD2 ASP    18      11.684  28.527   7.866  1.00 66.28           O  
ATOM    157  N   ARG    19       7.866  24.742   9.462  1.00 63.86           N  
ATOM    158  CA  ARG    19       7.186  23.580  10.105  1.00 64.11           C  
ATOM    159  C   ARG    19       7.929  22.557  10.969  1.00 62.46           C  
ATOM    160  O   ARG    19       7.410  22.169  12.013  1.00 61.74           O  
ATOM    161  CB  ARG    19       6.388  22.816   9.034  1.00 63.62           C  
ATOM    162  CG  ARG    19       5.393  23.691   8.272  1.00 67.91           C  
ATOM    163  CD  ARG    19       4.563  22.875   7.257  1.00 71.16           C  
ATOM    164  NE  ARG    19       3.187  23.389   7.168  1.00 87.12           N  
ATOM    165  CZ  ARG    19       2.155  22.781   6.554  1.00 93.44           C  
ATOM    166  NH1 ARG    19       2.294  21.602   5.906  1.00 94.97           N  
ATOM    167  NH2 ARG    19       0.951  23.374   6.579  1.00 94.24           N  
ATOM    168  N   THR    20       9.114  22.110  10.559  1.00 62.82           N  
ATOM    169  CA  THR    20       9.813  21.035  11.278  1.00 62.12           C  
ATOM    170  C   THR    20      10.289  21.449  12.675  1.00 62.25           C  
ATOM    171  O   THR    20      10.986  22.453  12.837  1.00 62.77           O  
ATOM    172  CB  THR    20      10.976  20.473  10.473  1.00 61.39           C  
ATOM    173  OG1 THR    20      10.525  20.203   9.142  1.00 57.65           O  
ATOM    174  CG2 THR    20      11.518  19.168  11.113  1.00 60.69           C  
ATOM    175  N   VAL    21       9.827  20.703  13.672  1.00 61.75           N  
ATOM    176  CA  VAL    21      10.223  20.849  15.081  1.00 61.41           C  
ATOM    177  C   VAL    21      10.738  19.484  15.562  1.00 60.57           C  
ATOM    178  O   VAL    21      10.059  18.480  15.358  1.00 60.04           O  
ATOM    179  CB  VAL    21       9.033  21.273  15.979  1.00 60.48           C  
ATOM    180  CG1 VAL    21       9.498  21.463  17.457  1.00 54.74           C  
ATOM    181  CG2 VAL    21       8.372  22.566  15.416  1.00 58.54           C  
ATOM    182  N   MET    22      11.933  19.486  16.162  1.00 62.27           N  
ATOM    183  CA  MET    22      12.554  18.294  16.762  0.50 63.02           C  
ATOM    185  C   MET    22      11.975  18.227  18.188  1.00 63.56           C  
ATOM    186  O   MET    22      12.339  19.014  19.049  1.00 61.75           O  
ATOM    187  CB  MET    22      14.081  18.448  16.778  0.50 63.15           C  
ATOM    189  CG  MET    22      14.878  17.312  17.398  0.50 62.14           C  
ATOM    191  SD  MET    22      15.028  15.746  16.284  0.38 65.65          SE  
ATOM    193  CE  MET    22      16.508  16.277  15.168  0.50 63.37           C  
ATOM    195  N   LEU    23      11.057  17.291  18.427  1.00 65.21           N  
ATOM    196  CA  LEU    23      10.365  17.155  19.718  1.00 65.88           C  
ATOM    197  C   LEU    23      10.875  16.040  20.578  1.00 67.75           C  
ATOM    198  O   LEU    23      10.906  14.880  20.139  1.00 68.07           O  
ATOM    199  CB  LEU    23       8.854  16.903  19.526  1.00 67.56           C  
ATOM    200  CG  LEU    23       7.857  18.043  19.478  1.00 71.70           C  
ATOM    201  CD1 LEU    23       6.457  17.461  19.191  1.00 72.00           C  
ATOM    202  CD2 LEU    23       7.878  18.806  20.780  1.00 67.11           C  
ATOM    203  N   GLY    24      11.168  16.377  21.834  1.00 69.16           N  
ATOM    204  CA  GLY    24      11.643  15.425  22.815  1.00 69.80           C  
ATOM    205  C   GLY    24      10.884  15.598  24.108  1.00 70.76           C  
ATOM    206  O   GLY    24      10.494  16.710  24.465  1.00 70.97           O  
ATOM    207  N   LEU    25      10.735  14.494  24.830  1.00 72.47           N  
ATOM    208  CA  LEU    25      10.015  14.463  26.091  1.00 74.34           C  
ATOM    209  C   LEU    25      11.010  14.993  27.150  1.00 74.96           C  
ATOM    210  O   LEU    25      12.145  14.525  27.228  1.00 73.70           O  
ATOM    211  CB  LEU    25       9.503  13.033  26.394  1.00 72.84           C  
ATOM    212  CG  LEU    25       8.015  12.953  26.735  1.00 72.49           C  
ATOM    213  CD1 LEU    25       7.161  13.401  25.557  1.00 69.61           C  
ATOM    214  CD2 LEU    25       7.623  11.535  27.118  1.00 75.59           C  
ATOM    215  N   ASP    26      10.589  16.011  27.903  1.00 76.90           N  
ATOM    216  CA  ASP    26      11.405  16.637  28.950  1.00 77.57           C  
ATOM    217  C   ASP    26      11.492  15.718  30.181  1.00 78.59           C  
ATOM    218  O   ASP    26      10.601  14.907  30.414  1.00 78.82           O  
ATOM    219  CB  ASP    26      10.802  17.995  29.359  1.00 78.83           C  
ATOM    220  CG  ASP    26      11.741  18.816  30.227  1.00 81.71           C  
ATOM    221  OD1 ASP    26      12.559  19.572  29.658  1.00 83.33           O  
ATOM    222  OD2 ASP    26      11.656  18.697  31.477  1.00 86.77           O  
ATOM    223  N   GLY    27      12.588  15.839  30.931  1.00 79.96           N  
ATOM    224  CA  GLY    27      12.803  15.090  32.163  1.00 81.85           C  
ATOM    225  C   GLY    27      12.993  13.589  32.069  1.00 82.54           C  
ATOM    226  O   GLY    27      12.705  12.893  33.043  1.00 82.96           O  
ATOM    227  N   VAL    28      13.517  13.090  30.947  1.00 83.40           N  
ATOM    228  CA  VAL    28      13.666  11.631  30.732  1.00 83.75           C  
ATOM    229  C   VAL    28      15.039  11.179  30.220  1.00 85.25           C  
ATOM    230  O   VAL    28      15.856  11.988  29.769  1.00 85.54           O  
ATOM    231  CB  VAL    28      12.585  11.094  29.742  1.00 84.15           C  
ATOM    232  CG1 VAL    28      11.212  11.221  30.329  1.00 84.76           C  
ATOM    233  CG2 VAL    28      12.650  11.807  28.426  1.00 81.15           C  
ATOM    234  N   GLU    29      15.252   9.860  30.326  1.00 86.69           N  
ATOM    235  CA  GLU    29      16.440   9.141  29.835  1.00 86.65           C  
ATOM    236  C   GLU    29      16.421   9.238  28.292  1.00 86.73           C  
ATOM    237  O   GLU    29      17.189  10.022  27.712  1.00 87.28           O  
ATOM    238  CB  GLU    29      16.408   7.674  30.358  1.00 86.71           C  
ATOM    239  CG  GLU    29      17.569   6.733  29.973  1.00 86.87           C  
ATOM    240  CD  GLU    29      18.839   6.941  30.784  1.00 87.16           C  
ATOM    241  OE1 GLU    29      19.032   8.033  31.364  1.00 87.24           O  
ATOM    242  OE2 GLU    29      19.658   5.996  30.835  1.00 86.54           O  
ATOM    243  N   ASP    30      15.501   8.507  27.654  1.00 86.31           N  
ATOM    244  CA  ASP    30      15.326   8.521  26.204  1.00 85.65           C  
ATOM    245  C   ASP    30      14.176   9.495  25.941  1.00 83.74           C  
ATOM    246  O   ASP    30      13.006   9.191  26.217  1.00 82.36           O  
ATOM    247  CB  ASP    30      15.018   7.105  25.670  1.00 86.22           C  
ATOM    248  CG  ASP    30      14.946   7.025  24.122  1.00 87.39           C  
ATOM    249  OD1 ASP    30      15.191   8.032  23.397  1.00 89.81           O  
ATOM    250  OD2 ASP    30      14.642   5.911  23.630  1.00 88.30           O  
ATOM    251  N   GLY    31      14.531  10.679  25.430  1.00 82.51           N  
ATOM    252  CA  GLY    31      13.562  11.723  25.081  1.00 80.49           C  
ATOM    253  C   GLY    31      12.677  11.425  23.878  1.00 79.75           C  
ATOM    254  O   GLY    31      11.636  12.076  23.721  1.00 78.15           O  
ATOM    255  N   HIS    32      13.078  10.442  23.053  1.00 78.92           N  
ATOM    256  CA  HIS    32      12.392  10.079  21.807  1.00 78.38           C  
ATOM    257  C   HIS    32      12.324  11.305  20.877  1.00 76.42           C  
ATOM    258  O   HIS    32      11.267  11.624  20.292  1.00 76.30           O  
ATOM    259  CB  HIS    32      11.031   9.430  22.090  1.00 78.51           C  
ATOM    260  CG  HIS    32      11.137   8.161  22.875  1.00 81.02           C  
ATOM    261  ND1 HIS    32      11.167   8.137  24.253  1.00 82.96           N  
ATOM    262  CD2 HIS    32      11.253   6.875  22.474  1.00 80.06           C  
ATOM    263  CE1 HIS    32      11.275   6.889  24.669  1.00 81.78           C  
ATOM    264  NE2 HIS    32      11.329   6.104  23.609  1.00 83.16           N  
ATOM    265  N   ALA    33      13.479  11.984  20.772  1.00 74.02           N  
ATOM    266  CA  ALA    33      13.626  13.184  19.948  1.00 72.19           C  
ATOM    267  C   ALA    33      13.449  12.783  18.497  1.00 69.70           C  
ATOM    268  O   ALA    33      14.078  11.814  18.039  1.00 67.12           O  
ATOM    269  CB  ALA    33      14.987  13.859  20.151  1.00 71.80           C  
ATOM    270  N   ARG    34      12.556  13.488  17.806  1.00 67.19           N  
ATOM    271  CA  ARG    34      12.339  13.250  16.393  1.00 67.22           C  
ATOM    272  C   ARG    34      11.691  14.442  15.720  1.00 64.44           C  
ATOM    273  O   ARG    34      10.952  15.196  16.381  1.00 63.48           O  
ATOM    274  CB  ARG    34      11.540  11.965  16.150  1.00 67.18           C  
ATOM    275  CG  ARG    34      10.172  11.922  16.792  1.00 71.28           C  
ATOM    276  CD  ARG    34       9.592  10.502  16.810  1.00 72.39           C  
ATOM    277  NE  ARG    34      10.255   9.616  17.784  1.00 81.01           N  
ATOM    278  CZ  ARG    34      11.288   8.782  17.558  1.00 84.19           C  
ATOM    279  NH1 ARG    34      11.871   8.654  16.352  1.00 86.28           N  
ATOM    280  NH2 ARG    34      11.755   8.044  18.570  1.00 85.67           N  
ATOM    281  N   PRO    35      11.967  14.626  14.405  1.00 62.56           N  
ATOM    282  CA  PRO    35      11.426  15.765  13.686  1.00 62.47           C  
ATOM    283  C   PRO    35      10.011  15.537  13.223  1.00 61.87           C  
ATOM    284  O   PRO    35       9.737  14.514  12.622  1.00 62.42           O  
ATOM    285  CB  PRO    35      12.380  15.911  12.504  1.00 62.79           C  
ATOM    286  CG  PRO    35      12.923  14.613  12.292  1.00 63.92           C  
ATOM    287  CD  PRO    35      12.796  13.802  13.519  1.00 61.73           C  
ATOM    288  N   MET    36       9.127  16.489  13.525  1.00 62.63           N  
ATOM    289  CA  MET    36       7.711  16.439  13.142  1.00 63.63           C  
ATOM    290  C   MET    36       7.276  17.753  12.556  1.00 61.06           C  
ATOM    291  O   MET    36       7.868  18.789  12.833  1.00 58.73           O  
ATOM    292  CB  MET    36       6.852  16.100  14.341  1.00 63.46           C  
ATOM    293  CG  MET    36       7.253  14.748  14.930  1.00 70.87           C  
ATOM    294  SD  MET    36       6.058  14.216  16.269  0.75 71.16          SE  
ATOM    295  CE  MET    36       4.760  13.683  15.149  1.00 72.71           C  
ATOM    296  N   THR    37       6.192  17.695  11.797  1.00 60.76           N  
ATOM    297  CA  THR    37       5.691  18.830  11.015  1.00 61.43           C  
ATOM    298  C   THR    37       4.609  19.633  11.756  1.00 61.72           C  
ATOM    299  O   THR    37       3.489  19.163  11.945  1.00 62.45           O  
ATOM    300  CB  THR    37       5.194  18.316   9.652  1.00 61.45           C  
ATOM    301  OG1 THR    37       6.248  17.555   9.038  1.00 59.62           O  
ATOM    302  CG2 THR    37       4.794  19.463   8.737  1.00 60.60           C  
ATOM    303  N   ALA    38       4.965  20.832  12.204  1.00 61.37           N  
ATOM    304  CA  ALA    38       4.027  21.700  12.904  1.00 62.54           C  
ATOM    305  C   ALA    38       2.965  22.281  11.944  1.00 63.67           C  
ATOM    306  O   ALA    38       3.258  22.588  10.802  1.00 63.92           O  
ATOM    307  CB  ALA    38       4.762  22.829  13.609  1.00 62.62           C  
ATOM    308  N   GLN    39       1.724  22.329  12.411  1.00 65.02           N  
ATOM    309  CA  GLN    39       0.640  23.011  11.738  1.00 65.99           C  
ATOM    310  C   GLN    39      -0.092  23.849  12.786  1.00 65.24           C  
ATOM    311  O   GLN    39      -0.253  23.414  13.934  1.00 63.32           O  
ATOM    312  CB  GLN    39      -0.320  22.029  11.100  1.00 66.62           C  
ATOM    313  CG  GLN    39       0.320  21.221   9.999  1.00 71.74           C  
ATOM    314  CD  GLN    39      -0.640  20.379   9.188  1.00 70.73           C  
ATOM    315  OE1 GLN    39      -0.287  19.246   8.822  1.00 82.77           O  
ATOM    316  NE2 GLN    39      -1.852  20.917   8.876  1.00 71.37           N  
ATOM    317  N   ILE    40      -0.485  25.058  12.399  1.00 65.86           N  
ATOM    318  CA  ILE    40      -1.327  25.933  13.232  1.00 66.67           C  
ATOM    319  C   ILE    40      -2.519  26.452  12.390  1.00 67.29           C  
ATOM    320  O   ILE    40      -2.403  26.617  11.177  1.00 66.21           O  
ATOM    321  CB  ILE    40      -0.512  27.114  13.872  1.00 66.43           C  
ATOM    322  CG1 ILE    40      -0.119  28.195  12.854  1.00 64.90           C  
ATOM    323  CG2 ILE    40       0.743  26.583  14.584  1.00 66.36           C  
ATOM    324  CD1 ILE    40       0.694  29.355  13.464  1.00 66.76           C  
ATOM    325  N   GLU    41      -3.651  26.712  13.035  1.00 67.88           N  
ATOM    326  CA  GLU    41      -4.796  27.321  12.351  1.00 68.19           C  
ATOM    327  C   GLU    41      -4.506  28.811  12.417  1.00 68.29           C  
ATOM    328  O   GLU    41      -4.081  29.315  13.447  1.00 67.75           O  
ATOM    329  CB  GLU    41      -6.122  26.965  13.011  1.00 67.65           C  
ATOM    330  CG  GLU    41      -6.338  25.465  13.148  1.00 67.09           C  
ATOM    331  CD  GLU    41      -7.748  25.110  13.531  1.00 69.19           C  
ATOM    332  OE1 GLU    41      -8.005  24.874  14.734  1.00 70.22           O  
ATOM    333  OE2 GLU    41      -8.613  25.101  12.630  1.00 72.58           O  
ATOM    334  N   GLY    42      -4.715  29.512  11.315  1.00 69.31           N  
ATOM    335  CA  GLY    42      -4.371  30.923  11.232  1.00 70.73           C  
ATOM    336  C   GLY    42      -2.881  31.113  10.995  1.00 72.32           C  
ATOM    337  O   GLY    42      -2.152  30.168  10.670  1.00 71.78           O  
ATOM    338  N   ASP    43      -2.439  32.350  11.171  1.00 74.76           N  
ATOM    339  CA  ASP    43      -1.040  32.751  10.935  1.00 76.24           C  
ATOM    340  C   ASP    43      -0.192  32.843  12.215  1.00 76.23           C  
ATOM    341  O   ASP    43       1.043  32.789  12.142  1.00 75.95           O  
ATOM    342  CB  ASP    43      -1.047  34.066  10.152  1.00 77.32           C  
ATOM    343  CG  ASP    43      -1.873  33.966   8.854  1.00 80.76           C  
ATOM    344  OD1 ASP    43      -1.801  32.923   8.153  1.00 84.46           O  
ATOM    345  OD2 ASP    43      -2.602  34.929   8.543  1.00 86.27           O  
ATOM    346  N   SER    44      -0.847  32.986  13.368  1.00 75.83           N  
ATOM    347  CA  SER    44      -0.172  32.991  14.672  1.00 76.04           C  
ATOM    348  C   SER    44      -0.974  32.203  15.726  1.00 74.54           C  
ATOM    349  O   SER    44      -2.106  31.772  15.497  1.00 74.05           O  
ATOM    350  CB  SER    44       0.034  34.432  15.162  1.00 75.37           C  
ATOM    351  OG  SER    44      -1.194  35.014  15.568  1.00 77.39           O  
ATOM    352  N   GLY    45      -0.354  32.041  16.881  1.00 73.61           N  
ATOM    353  CA  GLY    45      -0.959  31.406  18.034  1.00 73.37           C  
ATOM    354  C   GLY    45      -1.141  29.913  17.966  1.00 72.49           C  
ATOM    355  O   GLY    45      -1.494  29.371  16.939  1.00 72.76           O  
ATOM    356  N   GLY    46      -0.921  29.244  19.090  1.00 72.31           N  
ATOM    357  CA  GLY    46      -1.103  27.797  19.180  1.00 70.26           C  
ATOM    358  C   GLY    46      -2.585  27.445  19.311  1.00 68.19           C  
ATOM    359  O   GLY    46      -3.421  28.324  19.176  1.00 67.96           O  
ATOM    360  N   PRO    47      -2.921  26.163  19.564  1.00 66.61           N  
ATOM    361  CA  PRO    47      -1.986  25.041  19.729  1.00 65.95           C  
ATOM    362  C   PRO    47      -1.200  24.697  18.459  1.00 64.51           C  
ATOM    363  O   PRO    47      -1.618  25.063  17.361  1.00 65.61           O  
ATOM    364  CB  PRO    47      -2.895  23.871  20.133  1.00 65.74           C  
ATOM    365  CG  PRO    47      -4.206  24.502  20.510  1.00 68.47           C  
ATOM    366  CD  PRO    47      -4.322  25.722  19.704  1.00 66.10           C  
ATOM    367  N   ILE    48      -0.054  24.051  18.639  1.00 62.85           N  
ATOM    368  CA  ILE    48       0.774  23.589  17.536  1.00 62.67           C  
ATOM    369  C   ILE    48       0.409  22.103  17.403  1.00 61.35           C  
ATOM    370  O   ILE    48       0.603  21.307  18.348  1.00 61.17           O  
ATOM    371  CB  ILE    48       2.284  23.820  17.807  1.00 62.84           C  
ATOM    372  CG1 ILE    48       2.573  25.334  17.988  1.00 65.82           C  
ATOM    373  CG2 ILE    48       3.112  23.258  16.679  1.00 55.88           C  
ATOM    374  CD1 ILE    48       3.926  25.655  18.683  1.00 63.10           C  
ATOM    375  N   TRP    49      -0.105  21.748  16.231  1.00 59.20           N  
ATOM    376  CA  TRP    49      -0.565  20.413  15.929  1.00 58.95           C  
ATOM    377  C   TRP    49       0.455  19.634  15.100  1.00 59.22           C  
ATOM    378  O   TRP    49       1.116  20.194  14.236  1.00 60.26           O  
ATOM    379  CB  TRP    49      -1.874  20.491  15.160  1.00 60.06           C  
ATOM    380  CG  TRP    49      -2.976  21.246  15.842  1.00 61.83           C  
ATOM    381  CD1 TRP    49      -3.241  22.581  15.740  1.00 62.31           C  
ATOM    382  CD2 TRP    49      -3.946  20.712  16.746  1.00 63.23           C  
ATOM    383  NE1 TRP    49      -4.333  22.910  16.499  1.00 63.51           N  
ATOM    384  CE2 TRP    49      -4.791  21.785  17.130  1.00 64.70           C  
ATOM    385  CE3 TRP    49      -4.192  19.430  17.258  1.00 60.45           C  
ATOM    386  CZ2 TRP    49      -5.871  21.617  18.015  1.00 64.00           C  
ATOM    387  CZ3 TRP    49      -5.269  19.247  18.125  1.00 62.95           C  
ATOM    388  CH2 TRP    49      -6.096  20.343  18.504  1.00 65.90           C  
ATOM    389  N   PHE    50       0.544  18.336  15.359  1.00 59.87           N  
ATOM    390  CA  PHE    50       1.432  17.408  14.667  1.00 59.82           C  
ATOM    391  C   PHE    50       0.679  16.129  14.288  1.00 60.06           C  
ATOM    392  O   PHE    50       0.203  15.427  15.169  1.00 59.72           O  
ATOM    393  CB  PHE    50       2.602  17.023  15.567  1.00 60.78           C  
ATOM    394  CG  PHE    50       3.443  18.176  15.986  1.00 57.50           C  
ATOM    395  CD1 PHE    50       4.467  18.641  15.155  1.00 56.54           C  
ATOM    396  CD2 PHE    50       3.231  18.797  17.213  1.00 61.39           C  
ATOM    397  CE1 PHE    50       5.263  19.740  15.538  1.00 61.15           C  
ATOM    398  CE2 PHE    50       4.026  19.911  17.619  1.00 61.39           C  
ATOM    399  CZ  PHE    50       5.038  20.379  16.783  1.00 59.11           C  
ATOM    400  N   PHE    51       0.540  15.873  12.980  1.00 60.22           N  
ATOM    401  CA  PHE    51      -0.034  14.639  12.465  1.00 60.99           C  
ATOM    402  C   PHE    51       0.996  13.534  12.659  1.00 62.77           C  
ATOM    403  O   PHE    51       2.188  13.735  12.416  1.00 61.23           O  
ATOM    404  CB  PHE    51      -0.437  14.730  10.980  1.00 59.72           C  
ATOM    405  CG  PHE    51      -1.811  15.267  10.760  1.00 59.54           C  
ATOM    406  CD1 PHE    51      -2.924  14.421  10.890  1.00 59.07           C  
ATOM    407  CD2 PHE    51      -2.018  16.612  10.431  1.00 56.93           C  
ATOM    408  CE1 PHE    51      -4.227  14.898  10.691  1.00 56.00           C  
ATOM    409  CE2 PHE    51      -3.315  17.101  10.230  1.00 57.90           C  
ATOM    410  CZ  PHE    51      -4.425  16.242  10.352  1.00 55.28           C  
ATOM    411  N   THR    52       0.529  12.363  13.087  1.00 64.97           N  
ATOM    412  CA  THR    52       1.431  11.252  13.360  1.00 66.70           C  
ATOM    413  C   THR    52       0.715   9.907  13.320  1.00 68.53           C  
ATOM    414  O   THR    52      -0.503   9.849  13.124  1.00 67.55           O  
ATOM    415  CB  THR    52       2.156  11.486  14.732  1.00 66.81           C  
ATOM    416  OG1 THR    52       3.324  10.661  14.826  1.00 66.69           O  
ATOM    417  CG2 THR    52       1.218  11.261  15.929  1.00 67.16           C  
ATOM    418  N   SER    53       1.503   8.842  13.475  1.00 71.02           N  
ATOM    419  CA  SER    53       1.007   7.462  13.488  1.00 73.79           C  
ATOM    420  C   SER    53       0.726   7.057  14.924  1.00 74.03           C  
ATOM    421  O   SER    53       1.457   7.448  15.825  1.00 73.97           O  
ATOM    422  CB  SER    53       2.028   6.511  12.842  1.00 74.45           C  
ATOM    423  OG  SER    53       3.347   6.758  13.326  1.00 77.89           O  
ATOM    424  N   LYS    54      -0.317   6.249  15.122  1.00 75.47           N  
ATOM    425  CA  LYS    54      -0.727   5.767  16.466  1.00 76.05           C  
ATOM    426  C   LYS    54       0.378   4.954  17.194  1.00 76.73           C  
ATOM    427  O   LYS    54       0.372   4.863  18.430  1.00 76.65           O  
ATOM    428  CB  LYS    54      -2.038   4.962  16.384  1.00 75.95           C  
ATOM    429  CG  LYS    54      -2.723   4.735  17.727  1.00 75.99           C  
ATOM    430  N   ASP    55       1.312   4.393  16.415  1.00 77.08           N  
ATOM    431  CA  ASP    55       2.486   3.668  16.927  1.00 77.47           C  
ATOM    432  C   ASP    55       3.756   4.543  17.137  1.00 77.73           C  
ATOM    433  O   ASP    55       4.865   4.003  17.202  1.00 77.71           O  
ATOM    434  CB  ASP    55       2.769   2.405  16.057  1.00 78.39           C  
ATOM    435  CG  ASP    55       3.146   2.723  14.594  1.00 79.86           C  
ATOM    436  OD1 ASP    55       3.702   3.814  14.296  1.00 76.90           O  
ATOM    437  OD2 ASP    55       2.882   1.844  13.742  1.00 75.84           O  
ATOM    438  N   ASN    56       3.604   5.877  17.225  1.00 78.26           N  
ATOM    439  CA  ASN    56       4.730   6.786  17.527  1.00 77.69           C  
ATOM    440  C   ASN    56       5.063   6.579  19.009  1.00 77.79           C  
ATOM    441  O   ASN    56       4.163   6.580  19.850  1.00 77.84           O  
ATOM    442  CB  ASN    56       4.373   8.259  17.235  1.00 78.20           C  
ATOM    443  CG  ASN    56       5.575   9.239  17.393  1.00 78.54           C  
ATOM    444  OD1 ASN    56       6.618   8.904  17.961  1.00 81.25           O  
ATOM    445  ND2 ASN    56       5.402  10.467  16.892  1.00 76.95           N  
ATOM    446  N   ALA    57       6.353   6.390  19.305  1.00 77.88           N  
ATOM    447  CA  ALA    57       6.862   6.139  20.673  1.00 77.42           C  
ATOM    448  C   ALA    57       6.356   7.121  21.743  1.00 77.21           C  
ATOM    449  O   ALA    57       6.012   6.703  22.852  1.00 78.12           O  
ATOM    450  CB  ALA    57       8.395   6.125  20.674  1.00 78.03           C  
ATOM    451  N   LEU    58       6.293   8.404  21.390  1.00 75.66           N  
ATOM    452  CA  LEU    58       5.806   9.455  22.297  1.00 75.14           C  
ATOM    453  C   LEU    58       4.381   9.207  22.822  1.00 74.76           C  
ATOM    454  O   LEU    58       4.159   9.244  24.039  1.00 75.19           O  
ATOM    455  CB  LEU    58       5.835  10.823  21.607  1.00 75.44           C  
ATOM    456  CG  LEU    58       7.167  11.385  21.116  1.00 75.89           C  
ATOM    457  CD1 LEU    58       6.926  12.648  20.323  1.00 77.91           C  
ATOM    458  CD2 LEU    58       8.087  11.656  22.285  1.00 78.44           C  
ATOM    459  N   ILE    59       3.464   8.877  21.906  1.00 73.25           N  
ATOM    460  CA  ILE    59       2.014   8.743  22.190  1.00 73.11           C  
ATOM    461  C   ILE    59       1.621   8.007  23.482  1.00 72.50           C  
ATOM    462  O   ILE    59       0.824   8.533  24.266  1.00 72.90           O  
ATOM    463  CB  ILE    59       1.236   8.119  20.986  1.00 72.45           C  
ATOM    464  CG1 ILE    59       1.214   9.077  19.803  1.00 71.37           C  
ATOM    465  CG2 ILE    59      -0.223   7.792  21.357  1.00 72.55           C  
ATOM    466  CD1 ILE    59       0.611   8.451  18.569  1.00 73.52           C  
ATOM    467  N   ALA    60       2.187   6.822  23.703  1.00 72.02           N  
ATOM    468  CA  ALA    60       1.866   6.014  24.898  1.00 71.94           C  
ATOM    469  C   ALA    60       2.331   6.613  26.247  1.00 71.50           C  
ATOM    470  O   ALA    60       1.842   6.197  27.297  1.00 71.70           O  
ATOM    471  CB  ALA    60       2.408   4.598  24.738  1.00 71.96           C  
ATOM    472  N   MET    61       3.257   7.573  26.188  1.00 71.59           N  
ATOM    473  CA  MET    61       3.829   8.262  27.356  0.50 71.96           C  
ATOM    475  C   MET    61       3.029   9.526  27.769  1.00 70.87           C  
ATOM    476  O   MET    61       3.049   9.928  28.920  1.00 70.86           O  
ATOM    477  CB  MET    61       5.308   8.657  27.063  0.50 72.25           C  
ATOM    479  CG  MET    61       6.197   7.492  26.514  0.50 73.77           C  
ATOM    481  SD  MET    61       8.167   7.783  26.352  0.38 75.42          SE  
ATOM    483  CE  MET    61       8.247   9.135  25.028  0.50 75.19           C  
ATOM    485  N   LEU    62       2.283  10.118  26.842  1.00 69.59           N  
ATOM    486  CA  LEU    62       1.606  11.414  27.092  1.00 68.81           C  
ATOM    487  C   LEU    62       0.483  11.543  28.142  1.00 66.71           C  
ATOM    488  O   LEU    62       0.504  12.487  28.924  1.00 65.74           O  
ATOM    489  CB  LEU    62       1.144  12.039  25.760  1.00 68.82           C  
ATOM    490  CG  LEU    62       2.150  12.080  24.597  1.00 66.91           C  
ATOM    491  CD1 LEU    62       1.573  12.864  23.444  1.00 65.18           C  
ATOM    492  CD2 LEU    62       3.503  12.641  25.019  1.00 67.43           C  
ATOM    493  N   GLY    63      -0.484  10.630  28.152  1.00 66.16           N  
ATOM    494  CA  GLY    63      -1.649  10.712  29.056  1.00 66.32           C  
ATOM    495  C   GLY    63      -2.434  12.035  28.966  1.00 65.63           C  
ATOM    496  O   GLY    63      -2.892  12.444  27.902  1.00 65.48           O  
ATOM    497  N   GLN    64      -2.526  12.726  30.095  1.00 66.49           N  
ATOM    498  CA  GLN    64      -3.162  14.057  30.221  1.00 66.40           C  
ATOM    499  C   GLN    64      -2.281  15.170  29.596  1.00 64.88           C  
ATOM    500  O   GLN    64      -2.723  16.288  29.421  1.00 63.57           O  
ATOM    501  CB  GLN    64      -3.361  14.351  31.738  1.00 68.24           C  
ATOM    502  CG  GLN    64      -4.310  15.495  32.149  1.00 68.00           C  
ATOM    503  CD  GLN    64      -4.161  15.929  33.634  1.00 67.37           C  
ATOM    504  OE1 GLN    64      -3.052  16.233  34.087  1.00 72.68           O  
ATOM    505  NE2 GLN    64      -5.281  15.989  34.375  1.00 55.14           N  
ATOM    506  N   GLY    65      -1.024  14.859  29.299  1.00 64.73           N  
ATOM    507  CA  GLY    65      -0.069  15.787  28.750  1.00 65.43           C  
ATOM    508  C   GLY    65       1.242  15.662  29.502  1.00 66.21           C  
ATOM    509  O   GLY    65       1.241  15.457  30.712  1.00 66.90           O  
ATOM    510  N   ARG    66       2.352  15.729  28.776  1.00 67.81           N  
ATOM    511  CA  ARG    66       3.709  15.714  29.342  1.00 68.20           C  
ATOM    512  C   ARG    66       4.434  16.905  28.823  1.00 68.16           C  
ATOM    513  O   ARG    66       4.195  17.319  27.686  1.00 67.24           O  
ATOM    514  CB  ARG    66       4.485  14.473  28.947  1.00 68.79           C  
ATOM    515  CG  ARG    66       4.023  13.260  29.688  1.00 75.77           C  
ATOM    516  CD  ARG    66       5.041  12.160  29.651  1.00 84.49           C  
ATOM    517  NE  ARG    66       6.263  12.502  30.375  1.00 88.64           N  
ATOM    518  CZ  ARG    66       7.240  11.643  30.675  1.00 91.91           C  
ATOM    519  NH1 ARG    66       7.168  10.346  30.342  1.00 92.78           N  
ATOM    520  NH2 ARG    66       8.309  12.087  31.343  1.00 93.03           N  
ATOM    521  N   ARG    67       5.352  17.429  29.633  1.00 69.22           N  
ATOM    522  CA  ARG    67       6.094  18.619  29.252  1.00 70.73           C  
ATOM    523  C   ARG    67       7.126  18.197  28.198  1.00 67.85           C  
ATOM    524  O   ARG    67       7.712  17.123  28.299  1.00 68.41           O  
ATOM    525  CB  ARG    67       6.756  19.329  30.455  1.00 70.26           C  
ATOM    526  CG  ARG    67       6.821  20.848  30.221  1.00 76.57           C  
ATOM    527  CD  ARG    67       7.966  21.566  30.904  1.00 77.32           C  
ATOM    528  NE  ARG    67       7.855  21.681  32.362  1.00 86.77           N  
ATOM    529  CZ  ARG    67       8.456  20.913  33.286  1.00 88.48           C  
ATOM    530  NH1 ARG    67       9.276  19.899  32.970  1.00 89.88           N  
ATOM    531  NH2 ARG    67       8.239  21.180  34.573  1.00 88.54           N  
ATOM    532  N   VAL    68       7.271  19.005  27.159  1.00 65.16           N  
ATOM    533  CA  VAL    68       8.215  18.747  26.063  1.00 62.41           C  
ATOM    534  C   VAL    68       8.978  20.007  25.717  1.00 60.91           C  
ATOM    535  O   VAL    68       8.543  21.090  26.072  1.00 59.60           O  
ATOM    536  CB  VAL    68       7.498  18.254  24.764  1.00 61.59           C  
ATOM    537  CG1 VAL    68       6.901  16.871  24.965  1.00 61.91           C  
ATOM    538  CG2 VAL    68       6.433  19.268  24.275  1.00 55.67           C  
ATOM    539  N   ILE    69      10.122  19.827  25.049  1.00 60.95           N  
ATOM    540  CA  ILE    69      10.926  20.890  24.436  1.00 61.42           C  
ATOM    541  C   ILE    69      10.969  20.593  22.918  1.00 62.59           C  
ATOM    542  O   ILE    69      11.247  19.472  22.513  1.00 63.16           O  
ATOM    543  CB  ILE    69      12.359  20.987  25.029  1.00 61.23           C  
ATOM    544  CG1 ILE    69      12.309  21.469  26.486  1.00 62.50           C  
ATOM    545  CG2 ILE    69      13.291  21.908  24.186  1.00 56.80           C  
ATOM    546  CD1 ILE    69      11.826  22.910  26.653  1.00 63.44           C  
ATOM    547  N   GLY    70      10.686  21.605  22.099  1.00 62.73           N  
ATOM    548  CA  GLY    70      10.683  21.493  20.647  1.00 62.02           C  
ATOM    549  C   GLY    70      11.794  22.387  20.116  1.00 61.75           C  
ATOM    550  O   GLY    70      11.733  23.605  20.304  1.00 62.94           O  
ATOM    551  N   ALA    71      12.817  21.793  19.520  1.00 59.28           N  
ATOM    552  CA  ALA    71      13.928  22.558  18.933  1.00 60.54           C  
ATOM    553  C   ALA    71      13.531  22.928  17.483  1.00 59.79           C  
ATOM    554  O   ALA    71      13.273  22.042  16.668  1.00 59.76           O  
ATOM    555  CB  ALA    71      15.217  21.749  18.984  1.00 58.60           C  
ATOM    556  N   PHE    72      13.434  24.227  17.204  1.00 59.98           N  
ATOM    557  CA  PHE    72      13.040  24.764  15.881  1.00 60.04           C  
ATOM    558  C   PHE    72      14.087  25.714  15.286  1.00 60.96           C  
ATOM    559  O   PHE    72      14.642  26.566  16.003  1.00 60.23           O  
ATOM    560  CB  PHE    72      11.733  25.575  15.998  1.00 59.18           C  
ATOM    561  CG  PHE    72      11.344  26.281  14.725  1.00 58.73           C  
ATOM    562  CD1 PHE    72      10.759  25.576  13.684  1.00 58.25           C  
ATOM    563  CD2 PHE    72      11.630  27.630  14.535  1.00 60.96           C  
ATOM    564  CE1 PHE    72      10.437  26.187  12.475  1.00 59.78           C  
ATOM    565  CE2 PHE    72      11.313  28.266  13.322  1.00 64.31           C  
ATOM    566  CZ  PHE    72      10.701  27.539  12.297  1.00 59.65           C  
ATOM    567  N   SER    73      14.300  25.593  13.973  1.00 60.67           N  
ATOM    568  CA  SER    73      15.104  26.554  13.233  1.00 61.76           C  
ATOM    569  C   SER    73      14.387  26.874  11.932  1.00 61.94           C  
ATOM    570  O   SER    73      13.763  25.993  11.344  1.00 61.60           O  
ATOM    571  CB  SER    73      16.533  26.050  12.965  1.00 62.88           C  
ATOM    572  OG  SER    73      16.613  25.073  11.935  1.00 64.92           O  
ATOM    573  N   SER    74      14.431  28.142  11.511  1.00 62.03           N  
ATOM    574  CA  SER    74      13.942  28.540  10.202  1.00 62.94           C  
ATOM    575  C   SER    74      14.851  27.889   9.130  1.00 62.64           C  
ATOM    576  O   SER    74      15.990  27.551   9.408  1.00 61.33           O  
ATOM    577  CB  SER    74      13.929  30.074  10.048  1.00 62.75           C  
ATOM    578  OG  SER    74      15.209  30.614  10.328  1.00 67.23           O  
ATOM    579  N   LYS    75      14.347  27.753   7.913  1.00 64.07           N  
ATOM    580  CA  LYS    75      15.071  27.094   6.799  1.00 65.55           C  
ATOM    581  C   LYS    75      16.431  27.760   6.465  1.00 66.03           C  
ATOM    582  O   LYS    75      17.456  27.074   6.222  1.00 66.43           O  
ATOM    583  CB  LYS    75      14.146  26.987   5.582  1.00 64.21           C  
ATOM    584  CG  LYS    75      14.528  25.940   4.558  1.00 69.75           C  
ATOM    585  CD  LYS    75      13.380  25.629   3.534  1.00 68.15           C  
ATOM    586  CE  LYS    75      12.201  24.845   4.199  1.00 75.85           C  
ATOM    587  NZ  LYS    75      11.098  24.432   3.271  1.00 74.33           N  
ATOM    588  N   GLY    76      16.454  29.086   6.521  1.00 65.47           N  
ATOM    589  CA  GLY    76      17.695  29.823   6.305  1.00 64.53           C  
ATOM    590  C   GLY    76      18.616  29.969   7.510  1.00 64.33           C  
ATOM    591  O   GLY    76      19.679  30.580   7.377  1.00 64.98           O  
ATOM    592  N   HIS    77      18.230  29.432   8.674  1.00 63.35           N  
ATOM    593  CA  HIS    77      19.004  29.540   9.914  1.00 63.01           C  
ATOM    594  C   HIS    77      19.153  30.968  10.472  1.00 62.42           C  
ATOM    595  O   HIS    77      20.116  31.266  11.186  1.00 62.37           O  
ATOM    596  CB  HIS    77      20.359  28.812   9.771  1.00 62.40           C  
ATOM    597  CG  HIS    77      20.264  27.329   9.882  1.00 65.14           C  
ATOM    598  ND1 HIS    77      21.384  26.544  10.009  1.00 63.19           N  
ATOM    599  CD2 HIS    77      19.200  26.491   9.977  1.00 60.11           C  
ATOM    600  CE1 HIS    77      21.022  25.281  10.114  1.00 63.23           C  
ATOM    601  NE2 HIS    77      19.704  25.219  10.107  1.00 64.01           N  
ATOM    602  N   ASP    78      18.176  31.822  10.164  1.00 62.73           N  
ATOM    603  CA  ASP    78      18.120  33.200  10.668  1.00 63.74           C  
ATOM    604  C   ASP    78      17.443  33.299  12.036  1.00 62.49           C  
ATOM    605  O   ASP    78      17.598  34.293  12.714  1.00 61.00           O  
ATOM    606  CB  ASP    78      17.465  34.172   9.664  1.00 65.53           C  
ATOM    607  CG  ASP    78      16.011  33.852   9.363  1.00 74.11           C  
ATOM    608  OD1 ASP    78      15.706  32.676   9.082  1.00 87.52           O  
ATOM    609  OD2 ASP    78      15.181  34.791   9.350  1.00 86.29           O  
ATOM    610  N   LEU    79      16.693  32.267  12.420  1.00 63.41           N  
ATOM    611  CA  LEU    79      16.018  32.193  13.702  1.00 62.72           C  
ATOM    612  C   LEU    79      16.037  30.779  14.262  1.00 62.60           C  
ATOM    613  O   LEU    79      15.770  29.825  13.543  1.00 62.56           O  
ATOM    614  CB  LEU    79      14.571  32.682  13.538  1.00 62.83           C  
ATOM    615  CG  LEU    79      13.612  32.684  14.742  1.00 63.48           C  
ATOM    616  CD1 LEU    79      12.605  33.802  14.634  1.00 60.71           C  
ATOM    617  CD2 LEU    79      12.912  31.345  14.948  1.00 61.69           C  
ATOM    618  N   PHE    80      16.349  30.676  15.557  1.00 63.03           N  
ATOM    619  CA  PHE    80      16.302  29.445  16.331  1.00 61.20           C  
ATOM    620  C   PHE    80      15.329  29.671  17.497  1.00 61.24           C  
ATOM    621  O   PHE    80      15.302  30.747  18.058  1.00 61.99           O  
ATOM    622  CB  PHE    80      17.698  29.080  16.813  1.00 61.64           C  
ATOM    623  CG  PHE    80      18.629  28.791  15.692  1.00 62.13           C  
ATOM    624  CD1 PHE    80      18.686  27.513  15.140  1.00 59.83           C  
ATOM    625  CD2 PHE    80      19.398  29.808  15.132  1.00 62.75           C  
ATOM    626  CE1 PHE    80      19.521  27.243  14.062  1.00 60.15           C  
ATOM    627  CE2 PHE    80      20.226  29.561  14.027  1.00 60.53           C  
ATOM    628  CZ  PHE    80      20.299  28.274  13.502  1.00 61.80           C  
ATOM    629  N   ALA    81      14.506  28.672  17.809  1.00 60.35           N  
ATOM    630  CA  ALA    81      13.524  28.758  18.893  1.00 59.85           C  
ATOM    631  C   ALA    81      13.447  27.422  19.627  1.00 61.07           C  
ATOM    632  O   ALA    81      13.455  26.357  18.989  1.00 61.07           O  
ATOM    633  CB  ALA    81      12.123  29.169  18.347  1.00 57.08           C  
ATOM    634  N   SER    82      13.425  27.501  20.960  1.00 61.50           N  
ATOM    635  CA  SER    82      13.270  26.357  21.849  1.00 61.69           C  
ATOM    636  C   SER    82      11.882  26.548  22.472  1.00 61.85           C  
ATOM    637  O   SER    82      11.663  27.507  23.219  1.00 62.53           O  
ATOM    638  CB  SER    82      14.371  26.351  22.900  1.00 61.04           C  
ATOM    639  OG  SER    82      14.242  25.225  23.714  1.00 61.74           O  
ATOM    640  N   ILE    83      10.963  25.643  22.148  1.00 61.03           N  
ATOM    641  CA  ILE    83       9.553  25.764  22.517  1.00 60.58           C  
ATOM    642  C   ILE    83       9.266  24.847  23.697  1.00 60.93           C  
ATOM    643  O   ILE    83       9.510  23.656  23.602  1.00 61.95           O  
ATOM    644  CB  ILE    83       8.633  25.355  21.334  1.00 60.49           C  
ATOM    645  CG1 ILE    83       9.032  26.076  20.025  1.00 61.83           C  
ATOM    646  CG2 ILE    83       7.177  25.624  21.675  1.00 58.47           C  
ATOM    647  CD1 ILE    83       8.434  25.478  18.765  1.00 60.88           C  
ATOM    648  N   SER    84       8.759  25.418  24.787  1.00 59.46           N  
ATOM    649  CA  SER    84       8.364  24.697  25.970  1.00 60.27           C  
ATOM    650  C   SER    84       6.845  24.641  26.009  1.00 59.71           C  
ATOM    651  O   SER    84       6.184  25.641  25.786  1.00 58.95           O  
ATOM    652  CB  SER    84       8.864  25.397  27.227  1.00 59.24           C  
ATOM    653  OG  SER    84       8.388  24.722  28.346  1.00 61.61           O  
ATOM    654  N   GLY    85       6.313  23.461  26.315  1.00 59.32           N  
ATOM    655  CA  GLY    85       4.886  23.285  26.414  1.00 59.57           C  
ATOM    656  C   GLY    85       4.476  21.884  26.795  1.00 59.93           C  
ATOM    657  O   GLY    85       5.316  21.040  27.130  1.00 57.84           O  
ATOM    658  N   SER    86       3.167  21.652  26.718  1.00 60.53           N  
ATOM    659  CA  SER    86       2.579  20.379  27.083  1.00 62.22           C  
ATOM    660  C   SER    86       2.099  19.687  25.827  1.00 61.21           C  
ATOM    661  O   SER    86       1.456  20.327  24.998  1.00 60.49           O  
ATOM    662  CB  SER    86       1.424  20.601  28.056  1.00 62.37           C  
ATOM    663  OG  SER    86       1.041  19.368  28.593  1.00 69.29           O  
ATOM    664  N   LEU    87       2.410  18.390  25.709  1.00 61.36           N  
ATOM    665  CA  LEU    87       2.066  17.577  24.555  1.00 61.79           C  
ATOM    666  C   LEU    87       1.098  16.463  24.945  1.00 62.05           C  
ATOM    667  O   LEU    87       1.339  15.762  25.910  1.00 61.68           O  
ATOM    668  CB  LEU    87       3.332  16.959  23.956  1.00 62.08           C  
ATOM    669  CG  LEU    87       3.223  16.237  22.587  1.00 60.82           C  
ATOM    670  CD1 LEU    87       2.987  17.238  21.460  1.00 56.57           C  
ATOM    671  CD2 LEU    87       4.471  15.424  22.316  1.00 60.35           C  
ATOM    672  N   ARG    88       0.013  16.314  24.189  1.00 62.43           N  
ATOM    673  CA  ARG    88      -0.968  15.221  24.395  1.00 63.66           C  
ATOM    674  C   ARG    88      -1.614  14.877  23.060  1.00 65.27           C  
ATOM    675  O   ARG    88      -1.478  15.629  22.091  1.00 65.49           O  
ATOM    676  CB  ARG    88      -2.045  15.593  25.414  1.00 61.65           C  
ATOM    677  CG  ARG    88      -3.136  16.563  24.942  1.00 62.82           C  
ATOM    678  CD  ARG    88      -3.992  17.029  26.093  1.00 64.88           C  
ATOM    679  NE  ARG    88      -5.296  17.545  25.669  1.00 68.30           N  
ATOM    680  CZ  ARG    88      -5.652  18.829  25.496  1.00 73.89           C  
ATOM    681  NH1 ARG    88      -4.840  19.870  25.744  1.00 70.34           N  
ATOM    682  NH2 ARG    88      -6.898  19.082  25.081  1.00 77.03           N  
ATOM    683  N   GLU    89      -2.309  13.748  23.022  1.00 65.27           N  
ATOM    684  CA  GLU    89      -3.038  13.341  21.837  1.00 65.79           C  
ATOM    685  C   GLU    89      -4.428  13.954  21.904  1.00 65.73           C  
ATOM    686  O   GLU    89      -5.092  13.873  22.930  1.00 65.83           O  
ATOM    687  CB  GLU    89      -3.160  11.826  21.762  1.00 65.81           C  
ATOM    688  CG  GLU    89      -3.649  11.337  20.397  1.00 66.36           C  
ATOM    689  CD  GLU    89      -4.083   9.899  20.410  1.00 66.98           C  
ATOM    690  OE1 GLU    89      -3.488   9.087  21.159  1.00 69.53           O  
ATOM    691  OE2 GLU    89      -5.033   9.581  19.657  1.00 75.68           O  
ATOM    692  N   ASP    90      -4.849  14.597  20.820  1.00 67.11           N  
ATOM    693  CA  ASP    90      -6.206  15.145  20.705  1.00 67.14           C  
ATOM    694  C   ASP    90      -6.621  14.961  19.255  1.00 67.68           C  
ATOM    695  O   ASP    90      -6.628  15.917  18.464  1.00 68.75           O  
ATOM    696  CB  ASP    90      -6.315  16.617  21.162  1.00 66.98           C  
ATOM    697  CG  ASP    90      -7.786  17.152  21.154  1.00 68.16           C  
ATOM    698  OD1 ASP    90      -8.764  16.372  21.278  1.00 66.63           O  
ATOM    699  OD2 ASP    90      -7.973  18.377  21.026  1.00 70.41           O  
ATOM    700  N   THR    91      -6.947  13.708  18.924  1.00 66.34           N  
ATOM    701  CA  THR    91      -7.418  13.320  17.601  1.00 66.46           C  
ATOM    702  C   THR    91      -8.928  13.639  17.527  1.00 66.88           C  
ATOM    703  O   THR    91      -9.805  12.750  17.586  1.00 66.05           O  
ATOM    704  CB  THR    91      -7.056  11.851  17.277  1.00 66.58           C  
ATOM    705  OG1 THR    91      -5.648  11.653  17.532  1.00 64.66           O  
ATOM    706  CG2 THR    91      -7.383  11.512  15.802  1.00 64.38           C  
ATOM    707  N   ASP    92      -9.184  14.951  17.407  1.00 66.79           N  
ATOM    708  CA  ASP    92     -10.499  15.528  17.320  1.00 65.30           C  
ATOM    709  C   ASP    92     -10.811  15.527  15.826  1.00 65.43           C  
ATOM    710  O   ASP    92     -10.123  16.230  15.077  1.00 65.65           O  
ATOM    711  CB  ASP    92     -10.516  16.960  17.880  1.00 64.41           C  
ATOM    712  CG  ASP    92     -11.928  17.619  17.866  1.00 66.57           C  
ATOM    713  OD1 ASP    92     -12.837  17.213  17.098  1.00 62.25           O  
ATOM    714  OD2 ASP    92     -12.124  18.592  18.634  1.00 68.03           O  
ATOM    715  N   PRO    93     -11.854  14.773  15.392  1.00 64.19           N  
ATOM    716  CA  PRO    93     -12.262  14.737  13.982  1.00 63.47           C  
ATOM    717  C   PRO    93     -12.436  16.092  13.331  1.00 62.27           C  
ATOM    718  O   PRO    93     -12.122  16.236  12.151  1.00 60.14           O  
ATOM    719  CB  PRO    93     -13.644  14.033  14.017  1.00 62.28           C  
ATOM    720  CG  PRO    93     -13.973  13.845  15.393  1.00 62.35           C  
ATOM    721  CD  PRO    93     -12.741  13.919  16.200  1.00 63.70           C  
ATOM    722  N   ALA    94     -12.990  17.047  14.084  1.00 62.20           N  
ATOM    723  CA  ALA    94     -13.192  18.401  13.580  1.00 62.51           C  
ATOM    724  C   ALA    94     -11.854  19.078  13.309  1.00 61.72           C  
ATOM    725  O   ALA    94     -11.733  19.783  12.318  1.00 61.42           O  
ATOM    726  CB  ALA    94     -14.045  19.242  14.545  1.00 62.99           C  
ATOM    727  N   VAL    95     -10.861  18.857  14.177  1.00 62.04           N  
ATOM    728  CA  VAL    95      -9.512  19.437  13.972  1.00 62.22           C  
ATOM    729  C   VAL    95      -8.829  18.730  12.792  1.00 61.88           C  
ATOM    730  O   VAL    95      -8.248  19.388  11.941  1.00 61.01           O  
ATOM    731  CB  VAL    95      -8.645  19.399  15.222  1.00 62.15           C  
ATOM    732  CG1 VAL    95      -7.285  20.045  14.939  1.00 62.94           C  
ATOM    733  CG2 VAL    95      -9.347  20.119  16.363  1.00 59.03           C  
ATOM    734  N   VAL    96      -8.946  17.402  12.739  1.00 61.69           N  
ATOM    735  CA  VAL    96      -8.433  16.610  11.624  1.00 62.38           C  
ATOM    736  C   VAL    96      -8.931  17.202  10.307  1.00 62.20           C  
ATOM    737  O   VAL    96      -8.125  17.431   9.429  1.00 60.58           O  
ATOM    738  CB  VAL    96      -8.826  15.096  11.729  1.00 61.95           C  
ATOM    739  CG1 VAL    96      -8.649  14.352  10.383  1.00 60.55           C  
ATOM    740  CG2 VAL    96      -8.025  14.423  12.832  1.00 61.12           C  
ATOM    741  N   ASP    97     -10.236  17.480  10.219  1.00 63.00           N  
ATOM    742  CA  ASP    97     -10.858  18.070   9.026  1.00 64.24           C  
ATOM    743  C   ASP    97     -10.265  19.399   8.616  1.00 63.53           C  
ATOM    744  O   ASP    97      -9.943  19.574   7.468  1.00 63.50           O  
ATOM    745  CB  ASP    97     -12.379  18.258   9.201  1.00 65.15           C  
ATOM    746  CG  ASP    97     -13.150  16.958   9.125  1.00 71.53           C  
ATOM    747  OD1 ASP    97     -12.846  16.116   8.246  1.00 76.19           O  
ATOM    748  OD2 ASP    97     -14.106  16.798   9.921  1.00 80.54           O  
ATOM    749  N   ARG    98     -10.137  20.319   9.560  1.00 64.71           N  
ATOM    750  CA  ARG    98      -9.585  21.664   9.297  1.00 66.64           C  
ATOM    751  C   ARG    98      -8.117  21.652   8.884  1.00 65.82           C  
ATOM    752  O   ARG    98      -7.730  22.345   7.952  1.00 66.83           O  
ATOM    753  CB  ARG    98      -9.763  22.569  10.526  1.00 66.66           C  
ATOM    754  CG  ARG    98     -11.253  22.861  10.798  1.00 71.03           C  
ATOM    755  CD  ARG    98     -11.517  23.743  11.998  1.00 69.73           C  
ATOM    756  NE  ARG    98     -10.833  23.306  13.216  1.00 75.27           N  
ATOM    757  CZ  ARG    98     -11.032  23.817  14.430  1.00 77.58           C  
ATOM    758  NH1 ARG    98     -11.949  24.771  14.646  1.00 86.21           N  
ATOM    759  NH2 ARG    98     -10.327  23.344  15.457  1.00 76.48           N  
ATOM    760  N   LEU    99      -7.308  20.866   9.584  1.00 64.51           N  
ATOM    761  CA  LEU    99      -5.885  20.755   9.277  1.00 63.88           C  
ATOM    762  C   LEU    99      -5.584  19.870   8.068  1.00 63.94           C  
ATOM    763  O   LEU    99      -4.462  19.897   7.571  1.00 63.94           O  
ATOM    764  CB  LEU    99      -5.115  20.237  10.488  1.00 62.08           C  
ATOM    765  CG  LEU    99      -5.236  21.082  11.741  1.00 59.09           C  
ATOM    766  CD1 LEU    99      -4.488  20.403  12.860  1.00 62.82           C  
ATOM    767  CD2 LEU    99      -4.698  22.491  11.510  1.00 60.05           C  
ATOM    768  N   TRP   100      -6.563  19.093   7.604  1.00 64.23           N  
ATOM    769  CA  TRP   100      -6.368  18.208   6.457  1.00 64.94           C  
ATOM    770  C   TRP   100      -5.943  18.993   5.196  1.00 66.40           C  
ATOM    771  O   TRP   100      -6.492  20.062   4.904  1.00 66.40           O  
ATOM    772  CB  TRP   100      -7.647  17.416   6.134  1.00 63.32           C  
ATOM    773  CG  TRP   100      -7.401  16.171   5.391  1.00 60.10           C  
ATOM    774  CD1 TRP   100      -7.703  15.915   4.101  1.00 60.68           C  
ATOM    775  CD2 TRP   100      -6.792  14.995   5.907  1.00 56.49           C  
ATOM    776  NE1 TRP   100      -7.326  14.642   3.770  1.00 59.73           N  
ATOM    777  CE2 TRP   100      -6.761  14.052   4.866  1.00 58.04           C  
ATOM    778  CE3 TRP   100      -6.253  14.649   7.155  1.00 61.51           C  
ATOM    779  CZ2 TRP   100      -6.218  12.773   5.025  1.00 60.05           C  
ATOM    780  CZ3 TRP   100      -5.722  13.370   7.323  1.00 62.28           C  
ATOM    781  CH2 TRP   100      -5.711  12.446   6.257  1.00 61.37           C  
ATOM    782  N   ASN   101      -4.936  18.470   4.507  1.00 67.33           N  
ATOM    783  CA  ASN   101      -4.440  19.036   3.242  1.00 68.25           C  
ATOM    784  C   ASN   101      -3.796  17.912   2.420  1.00 68.25           C  
ATOM    785  O   ASN   101      -3.561  16.831   2.975  1.00 67.18           O  
ATOM    786  CB  ASN   101      -3.521  20.244   3.506  1.00 68.78           C  
ATOM    787  CG  ASN   101      -2.252  19.891   4.277  1.00 70.98           C  
ATOM    788  OD1 ASN   101      -1.543  18.923   3.967  1.00 73.81           O  
ATOM    789  ND2 ASN   101      -1.942  20.711   5.265  1.00 69.56           N  
ATOM    790  N   PRO   102      -3.482  18.158   1.120  1.00 69.56           N  
ATOM    791  CA  PRO   102      -2.961  17.054   0.312  1.00 69.80           C  
ATOM    792  C   PRO   102      -1.602  16.513   0.768  1.00 69.69           C  
ATOM    793  O   PRO   102      -1.349  15.316   0.605  1.00 68.78           O  
ATOM    794  CB  PRO   102      -2.912  17.648  -1.100  1.00 71.45           C  
ATOM    795  CG  PRO   102      -3.715  18.929  -1.024  1.00 71.12           C  
ATOM    796  CD  PRO   102      -3.516  19.407   0.334  1.00 69.40           C  
ATOM    797  N   TYR   103      -0.779  17.369   1.396  1.00 70.60           N  
ATOM    798  CA  TYR   103       0.528  16.945   1.919  1.00 71.40           C  
ATOM    799  C   TYR   103       0.273  15.894   3.022  1.00 71.59           C  
ATOM    800  O   TYR   103       0.827  14.796   2.953  1.00 72.12           O  
ATOM    801  CB  TYR   103       1.380  18.111   2.457  1.00 73.01           C  
ATOM    802  CG  TYR   103       1.556  19.319   1.541  1.00 74.63           C  
ATOM    803  CD1 TYR   103       2.579  19.359   0.586  1.00 79.83           C  
ATOM    804  CD2 TYR   103       0.718  20.452   1.662  1.00 77.56           C  
ATOM    805  CE1 TYR   103       2.757  20.503  -0.267  1.00 79.67           C  
ATOM    806  CE2 TYR   103       0.880  21.594   0.828  1.00 76.18           C  
ATOM    807  CZ  TYR   103       1.906  21.615  -0.131  1.00 78.35           C  
ATOM    808  OH  TYR   103       2.081  22.714  -0.952  1.00 74.78           O  
ATOM    809  N   VAL   104      -0.611  16.207   3.979  1.00 71.00           N  
ATOM    810  CA  VAL   104      -0.982  15.253   5.050  1.00 71.32           C  
ATOM    811  C   VAL   104      -1.676  14.042   4.448  1.00 71.94           C  
ATOM    812  O   VAL   104      -1.395  12.913   4.856  1.00 72.55           O  
ATOM    813  CB  VAL   104      -1.908  15.868   6.153  1.00 70.76           C  
ATOM    814  CG1 VAL   104      -2.369  14.799   7.148  1.00 69.40           C  
ATOM    815  CG2 VAL   104      -1.195  16.957   6.879  1.00 72.76           C  
ATOM    816  N   ALA   105      -2.593  14.289   3.504  1.00 72.51           N  
ATOM    817  CA  ALA   105      -3.296  13.226   2.771  1.00 74.46           C  
ATOM    818  C   ALA   105      -2.313  12.167   2.258  1.00 75.45           C  
ATOM    819  O   ALA   105      -2.558  10.970   2.436  1.00 76.15           O  
ATOM    820  CB  ALA   105      -4.096  13.809   1.599  1.00 73.94           C  
ATOM    821  N   ALA   106      -1.196  12.631   1.676  1.00 75.72           N  
ATOM    822  CA  ALA   106      -0.115  11.769   1.161  1.00 76.68           C  
ATOM    823  C   ALA   106       0.417  10.723   2.155  1.00 77.50           C  
ATOM    824  O   ALA   106       0.709   9.598   1.754  1.00 78.04           O  
ATOM    825  CB  ALA   106       1.062  12.632   0.649  1.00 76.97           C  
ATOM    826  N   TRP   107       0.529  11.090   3.433  1.00 78.25           N  
ATOM    827  CA  TRP   107       1.049  10.169   4.467  1.00 79.00           C  
ATOM    828  C   TRP   107       0.102   9.052   4.890  1.00 78.50           C  
ATOM    829  O   TRP   107       0.565   8.098   5.518  1.00 78.90           O  
ATOM    830  CB  TRP   107       1.476  10.925   5.735  1.00 81.75           C  
ATOM    831  CG  TRP   107       2.578  11.855   5.503  1.00 85.01           C  
ATOM    832  CD1 TRP   107       2.472  13.167   5.177  1.00 88.16           C  
ATOM    833  CD2 TRP   107       3.974  11.559   5.560  1.00 88.53           C  
ATOM    834  NE1 TRP   107       3.719  13.726   5.022  1.00 89.70           N  
ATOM    835  CE2 TRP   107       4.666  12.763   5.255  1.00 92.17           C  
ATOM    836  CE3 TRP   107       4.718  10.396   5.839  1.00 88.93           C  
ATOM    837  CZ2 TRP   107       6.084  12.843   5.228  1.00 91.14           C  
ATOM    838  CZ3 TRP   107       6.137  10.467   5.806  1.00 88.41           C  
ATOM    839  CH2 TRP   107       6.797  11.688   5.499  1.00 88.94           C  
ATOM    840  N   TYR   108      -1.190   9.156   4.569  1.00 77.70           N  
ATOM    841  CA  TYR   108      -2.183   8.176   5.020  1.00 77.58           C  
ATOM    842  C   TYR   108      -2.958   7.561   3.853  1.00 78.24           C  
ATOM    843  O   TYR   108      -3.724   8.266   3.183  1.00 78.55           O  
ATOM    844  CB  TYR   108      -3.168   8.840   5.999  1.00 76.95           C  
ATOM    845  CG  TYR   108      -2.543   9.466   7.239  1.00 75.66           C  
ATOM    846  CD1 TYR   108      -2.285   8.702   8.386  1.00 74.93           C  
ATOM    847  CD2 TYR   108      -2.242  10.831   7.280  1.00 73.90           C  
ATOM    848  CE1 TYR   108      -1.713   9.278   9.538  1.00 73.25           C  
ATOM    849  CE2 TYR   108      -1.677  11.424   8.432  1.00 75.10           C  
ATOM    850  CZ  TYR   108      -1.418  10.639   9.556  1.00 73.87           C  
ATOM    851  OH  TYR   108      -0.877  11.208  10.686  1.00 71.72           O  
ATOM    852  N   GLU   109      -2.759   6.256   3.622  1.00 78.29           N  
ATOM    853  CA  GLU   109      -3.483   5.521   2.577  1.00 78.32           C  
ATOM    854  C   GLU   109      -4.983   5.426   2.914  1.00 78.59           C  
ATOM    855  O   GLU   109      -5.822   5.547   2.021  1.00 79.15           O  
ATOM    856  CB  GLU   109      -2.895   4.118   2.367  1.00 78.53           C  
ATOM    857  N   GLY   110      -5.307   5.230   4.198  1.00 78.33           N  
ATOM    858  CA  GLY   110      -6.699   5.168   4.674  1.00 77.97           C  
ATOM    859  C   GLY   110      -7.416   6.508   4.868  1.00 77.86           C  
ATOM    860  O   GLY   110      -8.599   6.516   5.253  1.00 77.81           O  
ATOM    861  N   GLY   111      -6.713   7.627   4.626  1.00 77.37           N  
ATOM    862  CA  GLY   111      -7.273   8.973   4.753  1.00 76.88           C  
ATOM    863  C   GLY   111      -7.530   9.338   6.201  1.00 76.06           C  
ATOM    864  O   GLY   111      -6.775   8.942   7.078  1.00 76.40           O  
ATOM    865  N   LYS   112      -8.615  10.066   6.443  1.00 75.40           N  
ATOM    866  CA  LYS   112      -9.004  10.499   7.793  1.00 75.45           C  
ATOM    867  C   LYS   112      -9.533   9.346   8.669  1.00 76.00           C  
ATOM    868  O   LYS   112      -9.520   9.440   9.906  1.00 76.72           O  
ATOM    869  CB  LYS   112     -10.073  11.591   7.711  1.00 75.43           C  
ATOM    870  CG  LYS   112      -9.662  12.859   6.981  1.00 74.16           C  
ATOM    871  CD  LYS   112     -10.866  13.731   6.775  1.00 74.95           C  
ATOM    872  CE  LYS   112     -10.520  14.996   6.064  1.00 76.57           C  
ATOM    873  NZ  LYS   112     -11.749  15.771   5.752  1.00 82.34           N  
ATOM    874  N   ASP   113     -10.034   8.295   8.025  1.00 75.85           N  
ATOM    875  CA  ASP   113     -10.531   7.089   8.701  1.00 76.36           C  
ATOM    876  C   ASP   113      -9.419   6.097   9.050  1.00 76.13           C  
ATOM    877  O   ASP   113      -9.698   5.091   9.718  1.00 75.33           O  
ATOM    878  CB  ASP   113     -11.555   6.366   7.811  1.00 77.25           C  
ATOM    879  CG  ASP   113     -12.774   7.212   7.529  1.00 79.58           C  
ATOM    880  OD1 ASP   113     -13.497   7.558   8.498  1.00 80.73           O  
ATOM    881  OD2 ASP   113     -13.026   7.506   6.337  1.00 82.08           O  
ATOM    882  N   ASP   114      -8.188   6.359   8.578  1.00 76.33           N  
ATOM    883  CA  ASP   114      -7.018   5.509   8.839  1.00 76.24           C  
ATOM    884  C   ASP   114      -6.921   5.261  10.363  1.00 76.47           C  
ATOM    885  O   ASP   114      -6.805   6.235  11.123  1.00 76.72           O  
ATOM    886  CB  ASP   114      -5.731   6.165   8.295  1.00 76.13           C  
ATOM    887  CG  ASP   114      -4.517   5.220   8.278  1.00 76.90           C  
ATOM    888  OD1 ASP   114      -4.320   4.422   9.229  1.00 77.06           O  
ATOM    889  OD2 ASP   114      -3.726   5.312   7.302  1.00 76.48           O  
ATOM    890  N   PRO   115      -7.053   3.979  10.813  1.00 76.23           N  
ATOM    891  CA  PRO   115      -6.917   3.620  12.241  1.00 75.60           C  
ATOM    892  C   PRO   115      -5.544   3.998  12.811  1.00 75.10           C  
ATOM    893  O   PRO   115      -5.455   4.418  13.978  1.00 74.61           O  
ATOM    894  CB  PRO   115      -7.089   2.098  12.244  1.00 75.83           C  
ATOM    895  CG  PRO   115      -7.773   1.789  10.988  1.00 76.33           C  
ATOM    896  CD  PRO   115      -7.345   2.783   9.999  1.00 76.11           C  
ATOM    897  N   LYS   116      -4.503   3.888  11.970  1.00 74.15           N  
ATOM    898  CA  LYS   116      -3.137   4.270  12.319  1.00 73.62           C  
ATOM    899  C   LYS   116      -2.886   5.793  12.175  1.00 73.82           C  
ATOM    900  O   LYS   116      -1.837   6.193  11.660  1.00 74.05           O  
ATOM    901  CB  LYS   116      -2.134   3.488  11.457  1.00 73.64           C  
ATOM    902  N   LEU   117      -3.836   6.627  12.627  1.00 72.81           N  
ATOM    903  CA  LEU   117      -3.703   8.090  12.600  1.00 72.20           C  
ATOM    904  C   LEU   117      -3.889   8.641  14.013  1.00 70.18           C  
ATOM    905  O   LEU   117      -4.798   8.224  14.761  1.00 70.07           O  
ATOM    906  CB  LEU   117      -4.690   8.779  11.622  1.00 72.07           C  
ATOM    907  CG  LEU   117      -4.478  10.312  11.431  1.00 71.77           C  
ATOM    908  CD1 LEU   117      -4.834  10.788  10.027  1.00 70.09           C  
ATOM    909  CD2 LEU   117      -5.202  11.157  12.477  1.00 65.73           C  
ATOM    910  N   ALA   118      -3.007   9.582  14.347  1.00 68.08           N  
ATOM    911  CA  ALA   118      -3.020  10.297  15.612  1.00 65.82           C  
ATOM    912  C   ALA   118      -2.637  11.745  15.329  1.00 63.61           C  
ATOM    913  O   ALA   118      -1.849  12.033  14.426  1.00 61.85           O  
ATOM    914  CB  ALA   118      -2.051   9.666  16.594  1.00 64.77           C  
ATOM    915  N   LEU   119      -3.225  12.638  16.106  1.00 62.76           N  
ATOM    916  CA  LEU   119      -2.966  14.050  16.023  1.00 61.29           C  
ATOM    917  C   LEU   119      -2.557  14.502  17.420  1.00 62.26           C  
ATOM    918  O   LEU   119      -3.339  14.377  18.364  1.00 63.42           O  
ATOM    919  CB  LEU   119      -4.235  14.755  15.566  1.00 60.40           C  
ATOM    920  CG  LEU   119      -4.172  16.242  15.293  1.00 59.44           C  
ATOM    921  CD1 LEU   119      -3.043  16.591  14.297  1.00 52.48           C  
ATOM    922  CD2 LEU   119      -5.552  16.736  14.813  1.00 59.31           C  
ATOM    923  N   LEU   120      -1.327  14.991  17.549  1.00 61.72           N  
ATOM    924  CA  LEU   120      -0.807  15.499  18.812  1.00 61.86           C  
ATOM    925  C   LEU   120      -0.988  17.008  18.872  1.00 61.72           C  
ATOM    926  O   LEU   120      -0.861  17.664  17.838  1.00 61.15           O  
ATOM    927  CB  LEU   120       0.696  15.185  18.941  1.00 61.56           C  
ATOM    928  CG  LEU   120       1.129  13.731  18.723  1.00 60.31           C  
ATOM    929  CD1 LEU   120       2.615  13.582  19.060  1.00 56.29           C  
ATOM    930  CD2 LEU   120       0.279  12.778  19.543  1.00 55.20           C  
ATOM    931  N   ARG   121      -1.297  17.544  20.061  1.00 61.18           N  
ATOM    932  CA  ARG   121      -1.330  19.005  20.282  1.00 61.97           C  
ATOM    933  C   ARG   121      -0.284  19.405  21.302  1.00 61.10           C  
ATOM    934  O   ARG   121      -0.164  18.793  22.366  1.00 60.42           O  
ATOM    935  CB  ARG   121      -2.700  19.574  20.687  1.00 61.52           C  
ATOM    936  CG  ARG   121      -3.293  19.113  21.975  1.00 63.20           C  
ATOM    937  CD  ARG   121      -4.717  19.648  22.120  1.00 63.33           C  
ATOM    938  NE  ARG   121      -4.812  21.045  22.572  1.00 65.57           N  
ATOM    939  CZ  ARG   121      -5.927  21.786  22.566  1.00 62.63           C  
ATOM    940  NH1 ARG   121      -7.074  21.337  22.059  1.00 63.35           N  
ATOM    941  NH2 ARG   121      -5.888  23.032  23.023  1.00 59.07           N  
ATOM    942  N   LEU   122       0.483  20.429  20.934  1.00 60.61           N  
ATOM    943  CA  LEU   122       1.454  21.029  21.778  1.00 59.91           C  
ATOM    944  C   LEU   122       0.805  22.339  22.176  1.00 61.19           C  
ATOM    945  O   LEU   122       0.557  23.218  21.323  1.00 62.19           O  
ATOM    946  CB  LEU   122       2.773  21.234  21.057  1.00 60.23           C  
ATOM    947  CG  LEU   122       3.875  22.062  21.736  1.00 61.37           C  
ATOM    948  CD1 LEU   122       4.141  21.611  23.143  1.00 61.75           C  
ATOM    949  CD2 LEU   122       5.153  21.980  20.891  1.00 60.34           C  
ATOM    950  N   ASP   123       0.434  22.421  23.452  1.00 60.69           N  
ATOM    951  CA  ASP   123      -0.089  23.641  24.028  1.00 61.57           C  
ATOM    952  C   ASP   123       1.141  24.364  24.504  1.00 61.00           C  
ATOM    953  O   ASP   123       1.729  23.994  25.507  1.00 62.72           O  
ATOM    954  CB  ASP   123      -1.094  23.326  25.130  1.00 62.91           C  
ATOM    955  CG  ASP   123      -2.431  22.963  24.555  1.00 66.49           C  
ATOM    956  OD1 ASP   123      -3.034  23.882  23.953  1.00 63.57           O  
ATOM    957  OD2 ASP   123      -2.848  21.793  24.682  1.00 67.70           O  
ATOM    958  N   ALA   124       1.557  25.351  23.721  1.00 62.14           N  
ATOM    959  CA  ALA   124       2.829  26.072  23.923  1.00 62.86           C  
ATOM    960  C   ALA   124       2.719  27.054  25.049  1.00 63.49           C  
ATOM    961  O   ALA   124       1.792  27.847  25.100  1.00 64.38           O  
ATOM    962  CB  ALA   124       3.260  26.792  22.634  1.00 61.47           C  
ATOM    963  N   ASP   125       3.674  27.000  25.958  1.00 64.30           N  
ATOM    964  CA  ASP   125       3.694  27.897  27.090  1.00 64.07           C  
ATOM    965  C   ASP   125       4.555  29.133  26.771  1.00 64.53           C  
ATOM    966  O   ASP   125       4.117  30.277  26.904  1.00 64.73           O  
ATOM    967  CB  ASP   125       4.234  27.152  28.303  1.00 63.65           C  
ATOM    968  CG  ASP   125       4.373  28.044  29.479  1.00 66.71           C  
ATOM    969  OD1 ASP   125       3.326  28.563  29.916  1.00 70.42           O  
ATOM    970  OD2 ASP   125       5.520  28.256  29.920  1.00 67.28           O  
ATOM    971  N   HIS   126       5.806  28.883  26.419  1.00 65.57           N  
ATOM    972  CA  HIS   126       6.746  29.952  26.070  1.00 65.43           C  
ATOM    973  C   HIS   126       7.822  29.426  25.142  1.00 64.29           C  
ATOM    974  O   HIS   126       7.908  28.223  24.892  1.00 63.35           O  
ATOM    975  CB  HIS   126       7.361  30.584  27.332  1.00 65.55           C  
ATOM    976  CG  HIS   126       8.323  29.708  28.080  1.00 66.47           C  
ATOM    977  ND1 HIS   126       7.923  28.833  29.065  1.00 67.28           N  
ATOM    978  CD2 HIS   126       9.676  29.622  28.029  1.00 68.42           C  
ATOM    979  CE1 HIS   126       8.981  28.211  29.556  1.00 67.71           C  
ATOM    980  NE2 HIS   126      10.059  28.681  28.956  1.00 67.36           N  
ATOM    981  N   ALA   127       8.617  30.347  24.624  1.00 63.66           N  
ATOM    982  CA  ALA   127       9.755  30.017  23.787  1.00 63.18           C  
ATOM    983  C   ALA   127      10.903  30.936  24.025  1.00 62.13           C  
ATOM    984  O   ALA   127      10.699  32.131  24.256  1.00 61.43           O  
ATOM    985  CB  ALA   127       9.401  30.070  22.294  1.00 63.21           C  
ATOM    986  N   GLN   128      12.109  30.375  23.930  1.00 61.22           N  
ATOM    987  CA  GLN   128      13.310  31.173  23.934  1.00 61.80           C  
ATOM    988  C   GLN   128      13.686  31.276  22.469  1.00 60.96           C  
ATOM    989  O   GLN   128      13.774  30.260  21.792  1.00 60.64           O  
ATOM    990  CB  GLN   128      14.403  30.566  24.774  1.00 62.50           C  
ATOM    991  CG  GLN   128      15.552  31.516  24.945  1.00 66.72           C  
ATOM    992  CD  GLN   128      16.469  31.161  26.095  1.00 70.40           C  
ATOM    993  OE1 GLN   128      16.385  30.075  26.675  1.00 67.31           O  
ATOM    994  NE2 GLN   128      17.377  32.081  26.412  1.00 65.37           N  
ATOM    995  N   ILE   129      13.879  32.509  21.990  1.00 60.87           N  
ATOM    996  CA  ILE   129      14.139  32.804  20.583  1.00 59.58           C  
ATOM    997  C   ILE   129      15.507  33.475  20.424  1.00 60.07           C  
ATOM    998  O   ILE   129      15.780  34.501  21.060  1.00 60.01           O  
ATOM    999  CB  ILE   129      13.028  33.749  20.040  1.00 59.53           C  
ATOM   1000  CG1 ILE   129      11.651  33.068  20.090  1.00 58.16           C  
ATOM   1001  CG2 ILE   129      13.336  34.198  18.609  1.00 56.19           C  
ATOM   1002  CD1 ILE   129      10.470  34.066  19.975  1.00 59.27           C  
ATOM   1003  N   TRP   130      16.347  32.876  19.580  1.00 60.50           N  
ATOM   1004  CA  TRP   130      17.684  33.370  19.236  1.00 60.23           C  
ATOM   1005  C   TRP   130      17.721  33.703  17.748  1.00 60.63           C  
ATOM   1006  O   TRP   130      17.531  32.811  16.898  1.00 62.63           O  
ATOM   1007  CB  TRP   130      18.751  32.307  19.454  1.00 59.73           C  
ATOM   1008  CG  TRP   130      18.931  31.827  20.827  1.00 62.03           C  
ATOM   1009  CD1 TRP   130      19.893  32.210  21.698  1.00 60.85           C  
ATOM   1010  CD2 TRP   130      18.178  30.795  21.486  1.00 64.35           C  
ATOM   1011  NE1 TRP   130      19.780  31.513  22.862  1.00 60.14           N  
ATOM   1012  CE2 TRP   130      18.740  30.631  22.767  1.00 62.71           C  
ATOM   1013  CE3 TRP   130      17.101  29.976  21.106  1.00 62.95           C  
ATOM   1014  CZ2 TRP   130      18.252  29.687  23.696  1.00 64.49           C  
ATOM   1015  CZ3 TRP   130      16.620  29.038  22.023  1.00 61.66           C  
ATOM   1016  CH2 TRP   130      17.190  28.906  23.307  1.00 62.93           C  
ATOM   1017  N   LEU   131      17.936  34.971  17.435  1.00 60.43           N  
ATOM   1018  CA  LEU   131      18.156  35.403  16.058  1.00 60.89           C  
ATOM   1019  C   LEU   131      19.648  35.171  15.734  1.00 61.72           C  
ATOM   1020  O   LEU   131      20.522  35.294  16.604  1.00 60.15           O  
ATOM   1021  CB  LEU   131      17.815  36.875  15.870  1.00 58.93           C  
ATOM   1022  CG  LEU   131      16.405  37.315  16.295  1.00 61.09           C  
ATOM   1023  CD1 LEU   131      16.237  38.841  16.084  1.00 49.80           C  
ATOM   1024  CD2 LEU   131      15.306  36.515  15.580  1.00 53.92           C  
ATOM   1025  N   ASN   132      19.921  34.791  14.490  1.00 62.74           N  
ATOM   1026  CA  ASN   132      21.279  34.608  14.027  1.00 63.75           C  
ATOM   1027  C   ASN   132      21.623  35.951  13.364  1.00 65.20           C  
ATOM   1028  O   ASN   132      21.063  36.292  12.333  1.00 66.63           O  
ATOM   1029  CB  ASN   132      21.339  33.424  13.067  1.00 63.10           C  
ATOM   1030  CG  ASN   132      22.756  32.937  12.771  1.00 64.38           C  
ATOM   1031  OD1 ASN   132      23.739  33.313  13.410  1.00 66.90           O  
ATOM   1032  ND2 ASN   132      22.847  32.049  11.799  1.00 65.55           N  
ATOM   1033  N   GLY   133      22.472  36.738  14.019  1.00 65.89           N  
ATOM   1034  CA  GLY   133      22.928  38.033  13.513  1.00 65.80           C  
ATOM   1035  C   GLY   133      24.273  37.866  12.840  1.00 65.28           C  
ATOM   1036  O   GLY   133      24.550  36.815  12.252  1.00 66.27           O  
ATOM   1037  N   SER   134      25.112  38.891  12.925  1.00 64.55           N  
ATOM   1038  CA  SER   134      26.453  38.833  12.348  1.00 64.53           C  
ATOM   1039  C   SER   134      27.446  39.623  13.187  1.00 64.39           C  
ATOM   1040  O   SER   134      27.038  40.511  13.912  1.00 64.78           O  
ATOM   1041  CB  SER   134      26.413  39.349  10.905  1.00 64.99           C  
ATOM   1042  OG  SER   134      26.081  40.730  10.848  1.00 65.96           O  
ATOM   1043  N   SER   135      28.729  39.267  13.116  1.00 64.44           N  
ATOM   1044  CA  SER   135      29.785  39.989  13.830  1.00 65.34           C  
ATOM   1045  C   SER   135      30.841  40.437  12.807  1.00 63.57           C  
ATOM   1046  O   SER   135      31.427  39.600  12.109  1.00 63.08           O  
ATOM   1047  CB  SER   135      30.426  39.147  14.963  1.00 66.54           C  
ATOM   1048  OG  SER   135      31.524  38.337  14.532  1.00 70.43           O  
ATOM   1049  N   LEU   136      31.081  41.746  12.736  1.00 61.69           N  
ATOM   1050  CA  LEU   136      32.059  42.296  11.812  1.00 61.12           C  
ATOM   1051  C   LEU   136      33.433  42.072  12.430  1.00 59.81           C  
ATOM   1052  O   LEU   136      33.646  42.445  13.582  1.00 60.39           O  
ATOM   1053  CB  LEU   136      31.823  43.796  11.594  1.00 61.14           C  
ATOM   1054  CG  LEU   136      32.442  44.352  10.313  1.00 61.78           C  
ATOM   1055  CD1 LEU   136      31.538  44.017   9.124  1.00 59.14           C  
ATOM   1056  CD2 LEU   136      32.657  45.865  10.408  1.00 61.99           C  
ATOM   1057  N   LEU   137      34.342  41.435  11.694  1.00 58.51           N  
ATOM   1058  CA  LEU   137      35.707  41.216  12.179  1.00 58.04           C  
ATOM   1059  C   LEU   137      36.523  42.492  12.002  1.00 57.44           C  
ATOM   1060  O   LEU   137      36.082  43.443  11.352  1.00 57.36           O  
ATOM   1061  CB  LEU   137      36.422  40.064  11.452  1.00 58.32           C  
ATOM   1062  CG  LEU   137      35.743  38.699  11.251  1.00 59.84           C  
ATOM   1063  CD1 LEU   137      36.827  37.625  11.029  1.00 60.58           C  
ATOM   1064  CD2 LEU   137      34.883  38.315  12.395  1.00 60.91           C  
ATOM   1065  N   ALA   138      37.714  42.499  12.595  1.00 57.39           N  
ATOM   1066  CA  ALA   138      38.658  43.610  12.468  1.00 57.25           C  
ATOM   1067  C   ALA   138      39.122  43.692  11.017  1.00 57.29           C  
ATOM   1068  O   ALA   138      39.334  42.657  10.371  1.00 56.94           O  
ATOM   1069  CB  ALA   138      39.857  43.420  13.392  1.00 56.76           C  
ATOM   1070  N   GLY   139      39.247  44.917  10.509  1.00 57.45           N  
ATOM   1071  CA  GLY   139      39.658  45.141   9.138  1.00 57.98           C  
ATOM   1072  C   GLY   139      41.117  44.779   8.936  1.00 59.06           C  
ATOM   1073  O   GLY   139      41.933  44.939   9.852  1.00 59.88           O  
ATOM   1074  N   ILE   140      41.433  44.283   7.740  1.00 59.80           N  
ATOM   1075  CA  ILE   140      42.794  43.886   7.364  1.00 59.77           C  
ATOM   1076  C   ILE   140      43.141  44.612   6.080  1.00 60.20           C  
ATOM   1077  O   ILE   140      42.533  44.341   5.040  1.00 59.84           O  
ATOM   1078  CB  ILE   140      42.888  42.359   7.163  1.00 59.89           C  
ATOM   1079  CG1 ILE   140      42.524  41.634   8.472  1.00 59.59           C  
ATOM   1080  CG2 ILE   140      44.284  41.959   6.679  1.00 57.61           C  
ATOM   1081  CD1 ILE   140      42.558  40.124   8.388  1.00 60.05           C  
ATOM   1082  N   LYS   141      44.089  45.550   6.166  1.00 61.05           N  
ATOM   1083  CA  LYS   141      44.551  46.308   5.004  1.00 61.39           C  
ATOM   1084  C   LYS   141      45.505  45.436   4.196  1.00 61.80           C  
ATOM   1085  O   LYS   141      46.435  44.863   4.758  1.00 61.94           O  
ATOM   1086  CB  LYS   141      45.220  47.636   5.395  1.00 61.26           C  
ATOM   1087  CG  LYS   141      44.261  48.637   6.051  1.00 60.97           C  
ATOM   1088  CD  LYS   141      44.626  50.104   5.782  1.00 62.29           C  
ATOM   1089  CE  LYS   141      45.887  50.578   6.490  1.00 64.00           C  
ATOM   1090  NZ  LYS   141      45.648  50.668   7.955  1.00 66.94           N  
ATOM   1091  N   VAL   142      45.263  45.347   2.886  1.00 62.47           N  
ATOM   1092  CA  VAL   142      46.056  44.518   1.960  1.00 62.73           C  
ATOM   1093  C   VAL   142      46.397  45.304   0.688  1.00 62.79           C  
ATOM   1094  O   VAL   142      45.686  46.247   0.341  1.00 63.25           O  
ATOM   1095  CB  VAL   142      45.279  43.192   1.617  1.00 62.84           C  
ATOM   1096  CG1 VAL   142      43.942  43.483   0.942  1.00 61.54           C  
ATOM   1097  CG2 VAL   142      46.118  42.251   0.754  1.00 62.99           C  
ATOM   1098  N   LEU   143      47.503  44.942   0.031  1.00 62.93           N  
ATOM   1099  CA  LEU   143      47.899  45.541  -1.257  1.00 62.76           C  
ATOM   1100  C   LEU   143      47.322  44.669  -2.384  1.00 63.19           C  
ATOM   1101  O   LEU   143      47.264  43.442  -2.251  1.00 63.43           O  
ATOM   1102  CB  LEU   143      49.418  45.684  -1.374  1.00 62.31           C  
ATOM   1103  CG  LEU   143      50.110  46.684  -0.431  1.00 61.86           C  
ATOM   1104  CD1 LEU   143      51.635  46.657  -0.621  1.00 56.90           C  
ATOM   1105  CD2 LEU   143      49.587  48.107  -0.615  1.00 60.19           C  
ATOM   1106  N   LEU   144      46.890  45.314  -3.474  1.00 63.28           N  
ATOM   1107  CA  LEU   144      46.237  44.652  -4.623  1.00 63.02           C  
ATOM   1108  C   LEU   144      47.069  44.717  -5.899  1.00 62.91           C  
ATOM   1109  O   LEU   144      47.958  45.564  -6.018  1.00 63.42           O  
ATOM   1110  CB  LEU   144      44.884  45.320  -4.886  1.00 63.08           C  
ATOM   1111  CG  LEU   144      43.824  45.246  -3.788  1.00 60.34           C  
ATOM   1112  CD1 LEU   144      42.664  46.175  -4.098  1.00 57.50           C  
ATOM   1113  CD2 LEU   144      43.346  43.822  -3.622  1.00 61.41           C  
ATOM   1114  N   GLY   145      46.763  43.832  -6.853  1.00 62.92           N  
ATOM   1115  CA  GLY   145      47.483  43.799  -8.134  1.00 63.90           C  
ATOM   1116  C   GLY   145      47.247  42.592  -9.027  1.00 64.09           C  
ATOM   1117  O   GLY   145      47.895  42.477 -10.091  1.00 63.32           O  
END
