
#######################################################
#                                                     #
#                        LGA                          #
#                  ---------------                    #
#                                                     #
#               Local-Global Alignment                #
#        A Method for Finding 3-D Similarities        #
#               in Protein Structures                 #
#                                                     #
#                  --------------- 06/2006            #
#                                                     #
#      Adam Zemla (adamz@llnl.gov)                    #
#      Lawrence Livermore National Laboratory, CA     #
#                                                     #
#######################################################

###   For updated version of LGA program   ###
# please contact Adam Zemla:  adamz@llnl.gov #

# Molecule1: number of CA atoms   58 (  920),  selected   58 , name 2b87_B
# Molecule2: number of CA atoms   45 (  848),  selected   45 , name T0498_8_52.pdb
# PARAMETERS: 2b87_B.T0498_8_52.pdb  -4  -sia  -d:5.0  -ah:0  -o2  
# Search for Atom-Atom correspondence
# Structure alignment analysis 

#      Molecule1      Molecule2       DISTANCE
LGA    V     1_B      -       -           -
LGA    D     2_B      -       -           -
LGA    N     3_B      -       -           -
LGA    K     4_B      N       8          1.717
LGA    F     5_B      L       9          1.033
LGA    N     6_B      K      10          1.111
LGA    K     7_B      Q      11          2.048
LGA    E     8_B      A      12          2.228
LGA    R     9_B      K      13          1.292
LGA    V    10_B      E      14          0.429
LGA    I    11_B      E      15          1.048
LGA    A    12_B      A      16          1.991
LGA    I    13_B      I      17          1.910
LGA    G    14_B      K      18          1.054
LGA    E    15_B      E      19          0.560
LGA    I    16_B      L      20          2.000
LGA    M    17_B      V      21          2.453
LGA    R    18_B      D      22          1.620
LGA    L    19_B      A      23          1.175
LGA    P    20_B      G      24          3.437
LGA    N    21_B      -       -           -
LGA    L    22_B      T      25          1.739
LGA    N    23_B      A      26          3.587
LGA    S    24_B      -       -           -
LGA    L    25_B      -       -           -
LGA    Q    26_B      -       -           -
LGA    V    27_B      E      27          1.276
LGA    V    28_B      K      28          2.738
LGA    A    29_B      -       -           -
LGA    F    30_B      Y      29          1.672
LGA    I    31_B      I      30          1.711
LGA    N    32_B      K      31          1.596
LGA    S    33_B      L      32          1.369
LGA    L    34_B      I      33          1.100
LGA    R    35_B      A      34          1.867
LGA    D    36_B      N      35          2.355
LGA    D    37_B      A      36          1.105
LGA    P    38_B      K      37          4.068
LGA    S    39_B      T      38          2.067
LGA    -       -      V      39           -
LGA    -       -      E      40           -
LGA    Q    40_B      G      41          1.169
LGA    S    41_B      V      42          1.085
LGA    A    42_B      W      43          0.651
LGA    N    43_B      T      44          0.933
LGA    L    44_B      L      45          0.834
LGA    L    45_B      K      46          0.649
LGA    A    46_B      D      47          1.537
LGA    E    47_B      E      48          1.218
LGA    A    48_B      I      49          1.393
LGA    K    49_B      K      50          0.916
LGA    K    50_B      T      51          1.089
LGA    L    51_B      F      52          2.231
LGA    N    52_B      -       -           -
LGA    D    53_B      -       -           -
LGA    A    54_B      -       -           -
LGA    Q    55_B      -       -           -
LGA    A    56_B      -       -           -
LGA    P    57_B      -       -           -
LGA    K    58_B      -       -           -

#              N1   N2   DIST      N    RMSD   Seq_Id      LGA_S     LGA_Q 
SUMMARY(LGA)   58   45    5.0     43    1.79    16.28     85.702     2.278

Unitary ROTATION matrix and the shift VECTOR superimpose MOLECULES  (1=>2)
  X_new =  -0.317304 * X  +   0.704259 * Y  +   0.635089 * Z  +   6.619791
  Y_new =  -0.663980 * X  +  -0.643140 * Y  +   0.381447 * Z  +  -5.918546
  Z_new =   0.677088 * X  +  -0.300651 * Y  +   0.671685 * Z  +   4.938147 

Euler angles from the ROTATION matrix (XYZ convention, two solutions)
  Psi   =  -0.420863    2.720730  [ DEG:   -24.1137    155.8863 ]
  Theta =  -0.743799   -2.397794  [ DEG:   -42.6165   -137.3835 ]
  Phi   =  -2.016594    1.124999  [ DEG:  -115.5423     64.4577 ]
 
# END of job
REMARK  ---------------------------------------------------------- 
REMARK   Citing LGA: 
REMARK   Zemla A., LGA - a Method for Finding 3D Similarities in  
REMARK   Protein Structures, Nucleic Acids Research, 2003, V. 31, 
REMARK   No. 13, pp. 3370-3374. 
REMARK  ---------------------------------------------------------- 
REMARK   Superimposed MOLECULES (1=>2)   Output: 2 molecules     
REMARK     1: 2b87_B                                        
REMARK     2: T0498_8_52.pdb                                
REMARK   Structure alignment analysis
REMARK   Search for Atom-Atom correspondence
REMARK   LGA parameters: 2b87_B.T0498_8_52.pdb -4 -sia -d:5.0 -ah:0 -o2 
REMARK   #CA        N1   N2  DIST    N   RMSD  Seq_Id   LGA_S
REMARK   SUMMARY:   58   45   5.0   43   1.79   16.28  85.702
REMARK  ---------------------------------------------------------- 
MOLECULE 2b87_B
HEADER    PROTEIN BINDING                         06-OCT-05   2B87              
TITLE     STRUCTURAL BASIS FOR MOLECULAR RECOGNITION IN AN                      
TITLE    2 AFFIBODY:AFFIBODY COMPLEX                                            
COMPND    MOL_ID: 1;                                                            
COMPND   2 MOLECULE: ZTAQ AFFIBODY;                                             
COMPND   3 CHAIN: A;                                                            
COMPND   4 ENGINEERED: YES;                                                     
COMPND   5 MOL_ID: 2;                                                           
COMPND   6 MOLECULE: ANTI-ZTAQ AFFIBODY;                                        
COMPND   7 CHAIN: B;                                                            
COMPND   8 ENGINEERED: YES                                                      
SOURCE    MOL_ID: 1;                                                            
SOURCE   2 ORGANISM_SCIENTIFIC: STAPHYLOCOCCUS AUREUS;                          
SOURCE   3 ORGANISM_COMMON: BACTERIA;                                           
SOURCE   4 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE   5 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE   6 EXPRESSION_SYSTEM_STRAIN: BL21 DE3;                                  
SOURCE   7 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE   8 EXPRESSION_SYSTEM_PLASMID: PET28A(+);                                
SOURCE   9 MOL_ID: 2;                                                           
SOURCE  10 ORGANISM_SCIENTIFIC: STAPHYLOCOCCUS AUREUS;                          
SOURCE  11 ORGANISM_COMMON: BACTERIA;                                           
SOURCE  12 EXPRESSION_SYSTEM: ESCHERICHIA COLI;                                 
SOURCE  13 EXPRESSION_SYSTEM_COMMON: BACTERIA;                                  
SOURCE  14 EXPRESSION_SYSTEM_STRAIN: BL21 DE3;                                  
SOURCE  15 EXPRESSION_SYSTEM_VECTOR_TYPE: PLASMID;                              
SOURCE  16 EXPRESSION_SYSTEM_PLASMID: PET28A(+)                                 
KEYWDS    PROTEIN-PROTEIN INTERACTIONS PROTEIN ENGINEERING, MOLECULAR           
KEYWDS   2 RECOGNITION, NMR SPECTROSCOPY, INDUCED FIT, AFFIBODY                 
EXPDTA    NMR, 40 STRUCTURES                                                    
AUTHOR    C.LENDEL,J.DOGAN,T.HARD                                               
REVDAT   2   04-JUL-06 2B87    1       JRNL                                     
REVDAT   1   23-MAY-06 2B87    0                                                
JRNL        AUTH   C.LENDEL,J.DOGAN,T.HARD                                      
JRNL        TITL   STRUCTURAL BASIS FOR MOLECULAR RECOGNITION IN AN             
JRNL        TITL 2 AFFIBODY:AFFIBODY COMPLEX.                                   
JRNL        REF    J.MOL.BIOL.                   V. 359  1293 2006              
JRNL        REFN   ASTM JMOBAK  UK ISSN 0022-2836                               
REMARK   2 RESOLUTION. NOT APPLICABLE.                                          
DBREF  2B87 A    2    58  UNP    Q70AB8   Q70AB8_STAAU   117    173             
DBREF  2B87 B    2    58  UNP    Q70AB8   Q70AB8_STAAU   117    173             
SEQRES   1 A   58  VAL ASP ASN LYS PHE ASN LYS GLU LEU GLY TRP ALA THR          
SEQRES   2 A   58  TRP GLU ILE PHE ASN LEU PRO ASN LEU ASN GLY VAL GLN          
SEQRES   3 A   58  VAL LYS ALA PHE ILE ASP SER LEU ARG ASP ASP PRO SER          
SEQRES   4 A   58  GLN SER ALA ASN LEU LEU ALA GLU ALA LYS LYS LEU ASN          
SEQRES   5 A   58  ASP ALA GLN ALA PRO LYS                                      
SEQRES   1 B   58  VAL ASP ASN LYS PHE ASN LYS GLU ARG VAL ILE ALA ILE          
SEQRES   2 B   58  GLY GLU ILE MET ARG LEU PRO ASN LEU ASN SER LEU GLN          
SEQRES   3 B   58  VAL VAL ALA PHE ILE ASN SER LEU ARG ASP ASP PRO SER          
SEQRES   4 B   58  GLN SER ALA ASN LEU LEU ALA GLU ALA LYS LYS LEU ASN          
SEQRES   5 B   58  ASP ALA GLN ALA PRO LYS                                      
CRYST1    1.000    1.000    1.000  90.00  90.00  90.00 P 1           1          
MODEL        1                                                                  
ATOM    915  N   VAL B   1       9.805  10.057   3.788  1.00  0.00           N  
ATOM    916  CA  VAL B   1      10.845  10.321   2.753  1.00  0.00           C  
ATOM    917  C   VAL B   1      10.176  10.374   1.381  1.00  0.00           C  
ATOM    918  O   VAL B   1      10.187  11.411   0.715  1.00  0.00           O  
ATOM    919  CB  VAL B   1      11.903   9.202   2.794  1.00  0.00           C  
ATOM    920  CG1 VAL B   1      12.981   9.457   1.729  1.00  0.00           C  
ATOM    921  CG2 VAL B   1      12.561   9.166   4.182  1.00  0.00           C  
ATOM    922  H2  VAL B   1      10.140  10.399   4.712  1.00  0.00           H  
ATOM    923  HA  VAL B   1      11.317  11.272   2.957  1.00  0.00           H  
ATOM    924  HB  VAL B   1      11.426   8.251   2.599  1.00  0.00           H  
ATOM    925 HG11 VAL B   1      13.792   8.756   1.863  1.00  0.00           H  
ATOM    926 HG12 VAL B   1      13.356  10.465   1.827  1.00  0.00           H  
ATOM    927 HG13 VAL B   1      12.553   9.326   0.745  1.00  0.00           H  
ATOM    928 HG21 VAL B   1      12.986  10.135   4.405  1.00  0.00           H  
ATOM    929 HG22 VAL B   1      13.344   8.421   4.190  1.00  0.00           H  
ATOM    930 HG23 VAL B   1      11.822   8.916   4.927  1.00  0.00           H  
ATOM    931  H1  VAL B   1       8.927  10.552   3.533  1.00  0.00           H  
ATOM    932  H3  VAL B   1       9.620   9.035   3.842  1.00  0.00           H  
ATOM    933  N   ASP B   2       9.587   9.249   0.976  1.00  0.00           N  
ATOM    934  CA  ASP B   2       8.897   9.151  -0.312  1.00  0.00           C  
ATOM    935  C   ASP B   2       7.739  10.149  -0.379  1.00  0.00           C  
ATOM    936  O   ASP B   2       7.515  10.796  -1.405  1.00  0.00           O  
ATOM    937  CB  ASP B   2       8.351   7.725  -0.479  1.00  0.00           C  
ATOM    938  CG  ASP B   2       7.372   7.399   0.658  1.00  0.00           C  
ATOM    939  OD1 ASP B   2       7.834   7.179   1.767  1.00  0.00           O  
ATOM    940  OD2 ASP B   2       6.179   7.393   0.411  1.00  0.00           O  
ATOM    941  H   ASP B   2       9.611   8.463   1.562  1.00  0.00           H  
ATOM    942  HA  ASP B   2       9.595   9.356  -1.108  1.00  0.00           H  
ATOM    943  HB2 ASP B   2       7.839   7.646  -1.428  1.00  0.00           H  
ATOM    944  HB3 ASP B   2       9.171   7.022  -0.457  1.00  0.00           H  
ATOM    945  N   ASN B   3       7.021  10.252   0.735  1.00  0.00           N  
ATOM    946  CA  ASN B   3       5.876  11.145   0.872  1.00  0.00           C  
ATOM    947  C   ASN B   3       5.345  11.028   2.298  1.00  0.00           C  
ATOM    948  O   ASN B   3       5.951  10.342   3.128  1.00  0.00           O  
ATOM    949  CB  ASN B   3       4.770  10.758  -0.131  1.00  0.00           C  
ATOM    950  CG  ASN B   3       3.830  11.937  -0.369  1.00  0.00           C  
ATOM    951  OD1 ASN B   3       2.698  11.939   0.109  1.00  0.00           O  
ATOM    952  ND2 ASN B   3       4.240  12.950  -1.082  1.00  0.00           N  
ATOM    953  H   ASN B   3       7.271   9.703   1.503  1.00  0.00           H  
ATOM    954  HA  ASN B   3       6.192  12.157   0.690  1.00  0.00           H  
ATOM    955  HB2 ASN B   3       5.216  10.466  -1.069  1.00  0.00           H  
ATOM    956  HB3 ASN B   3       4.204   9.927   0.263  1.00  0.00           H  
ATOM    957 HD21 ASN B   3       5.144  12.949  -1.461  1.00  0.00           H  
ATOM    958 HD22 ASN B   3       3.642  13.710  -1.239  1.00  0.00           H  
ATOM    959  N   LYS B   4       4.208  11.666   2.586  1.00  0.00           N  
ATOM    960  CA  LYS B   4       3.628  11.571   3.924  1.00  0.00           C  
ATOM    961  C   LYS B   4       3.174  10.135   4.188  1.00  0.00           C  
ATOM    962  O   LYS B   4       2.873   9.762   5.324  1.00  0.00           O  
ATOM    963  CB  LYS B   4       2.459  12.560   4.102  1.00  0.00           C  
ATOM    964  CG  LYS B   4       1.405  12.361   3.002  1.00  0.00           C  
ATOM    965  CD  LYS B   4       0.018  12.121   3.624  1.00  0.00           C  
ATOM    966  CE  LYS B   4      -0.040  10.736   4.289  1.00  0.00           C  
ATOM    967  NZ  LYS B   4      -1.426  10.194   4.197  1.00  0.00           N  
ATOM    968  H   LYS B   4       3.750  12.183   1.892  1.00  0.00           H  
ATOM    969  HA  LYS B   4       4.389  11.811   4.633  1.00  0.00           H  
ATOM    970  HB2 LYS B   4       2.006  12.403   5.071  1.00  0.00           H  
ATOM    971  HB3 LYS B   4       2.840  13.569   4.051  1.00  0.00           H  
ATOM    972  HG2 LYS B   4       1.368  13.245   2.382  1.00  0.00           H  
ATOM    973  HG3 LYS B   4       1.674  11.519   2.394  1.00  0.00           H  
ATOM    974  HD2 LYS B   4      -0.179  12.883   4.365  1.00  0.00           H  
ATOM    975  HD3 LYS B   4      -0.732  12.177   2.849  1.00  0.00           H  
ATOM    976  HE2 LYS B   4       0.638  10.063   3.787  1.00  0.00           H  
ATOM    977  HE3 LYS B   4       0.245  10.822   5.326  1.00  0.00           H  
ATOM    978  HZ1 LYS B   4      -2.079  10.954   3.928  1.00  0.00           H  
ATOM    979  HZ2 LYS B   4      -1.705   9.804   5.121  1.00  0.00           H  
ATOM    980  HZ3 LYS B   4      -1.456   9.442   3.480  1.00  0.00           H  
ATOM    981  N   PHE B   5       3.145   9.338   3.118  1.00  0.00           N  
ATOM    982  CA  PHE B   5       2.749   7.947   3.196  1.00  0.00           C  
ATOM    983  C   PHE B   5       3.856   7.077   3.755  1.00  0.00           C  
ATOM    984  O   PHE B   5       3.654   5.894   3.939  1.00  0.00           O  
ATOM    985  CB  PHE B   5       2.329   7.445   1.813  1.00  0.00           C  
ATOM    986  CG  PHE B   5       0.955   7.984   1.529  1.00  0.00           C  
ATOM    987  CD1 PHE B   5       0.796   9.344   1.256  1.00  0.00           C  
ATOM    988  CD2 PHE B   5      -0.156   7.136   1.568  1.00  0.00           C  
ATOM    989  CE1 PHE B   5      -0.481   9.862   1.026  1.00  0.00           C  
ATOM    990  CE2 PHE B   5      -1.433   7.651   1.332  1.00  0.00           C  
ATOM    991  CZ  PHE B   5      -1.595   9.014   1.064  1.00  0.00           C  
ATOM    992  H   PHE B   5       3.398   9.699   2.252  1.00  0.00           H  
ATOM    993  HA  PHE B   5       1.899   7.876   3.855  1.00  0.00           H  
ATOM    994  HB2 PHE B   5       3.024   7.803   1.067  1.00  0.00           H  
ATOM    995  HB3 PHE B   5       2.306   6.365   1.803  1.00  0.00           H  
ATOM    996  HD1 PHE B   5       1.664   9.994   1.236  1.00  0.00           H  
ATOM    997  HD2 PHE B   5      -0.027   6.084   1.776  1.00  0.00           H  
ATOM    998  HE1 PHE B   5      -0.608  10.912   0.814  1.00  0.00           H  
ATOM    999  HE2 PHE B   5      -2.292   6.998   1.362  1.00  0.00           H  
ATOM   1000  HZ  PHE B   5      -2.580   9.410   0.897  1.00  0.00           H  
ATOM   1001  N   ASN B   6       5.018   7.655   4.057  1.00  0.00           N  
ATOM   1002  CA  ASN B   6       6.097   6.859   4.639  1.00  0.00           C  
ATOM   1003  C   ASN B   6       5.566   6.223   5.920  1.00  0.00           C  
ATOM   1004  O   ASN B   6       5.789   5.045   6.179  1.00  0.00           O  
ATOM   1005  CB  ASN B   6       7.316   7.745   4.935  1.00  0.00           C  
ATOM   1006  CG  ASN B   6       8.573   6.889   5.089  1.00  0.00           C  
ATOM   1007  OD1 ASN B   6       9.677   7.358   4.818  1.00  0.00           O  
ATOM   1008  ND2 ASN B   6       8.473   5.657   5.508  1.00  0.00           N  
ATOM   1009  H   ASN B   6       5.138   8.617   3.914  1.00  0.00           H  
ATOM   1010  HA  ASN B   6       6.378   6.068   3.957  1.00  0.00           H  
ATOM   1011  HB2 ASN B   6       7.457   8.439   4.121  1.00  0.00           H  
ATOM   1012  HB3 ASN B   6       7.146   8.296   5.848  1.00  0.00           H  
ATOM   1013 HD21 ASN B   6       7.592   5.280   5.721  1.00  0.00           H  
ATOM   1014 HD22 ASN B   6       9.276   5.109   5.609  1.00  0.00           H  
ATOM   1015  N   LYS B   7       4.807   7.016   6.673  1.00  0.00           N  
ATOM   1016  CA  LYS B   7       4.167   6.551   7.898  1.00  0.00           C  
ATOM   1017  C   LYS B   7       3.051   5.559   7.556  1.00  0.00           C  
ATOM   1018  O   LYS B   7       2.928   4.500   8.173  1.00  0.00           O  
ATOM   1019  CB  LYS B   7       3.571   7.764   8.634  1.00  0.00           C  
ATOM   1020  CG  LYS B   7       2.767   7.315   9.864  1.00  0.00           C  
ATOM   1021  CD  LYS B   7       2.043   8.522  10.474  1.00  0.00           C  
ATOM   1022  CE  LYS B   7       1.079   8.050  11.567  1.00  0.00           C  
ATOM   1023  NZ  LYS B   7      -0.053   7.302  10.944  1.00  0.00           N  
ATOM   1024  H   LYS B   7       4.639   7.934   6.372  1.00  0.00           H  
ATOM   1025  HA  LYS B   7       4.898   6.072   8.532  1.00  0.00           H  
ATOM   1026  HB2 LYS B   7       4.372   8.416   8.950  1.00  0.00           H  
ATOM   1027  HB3 LYS B   7       2.920   8.303   7.961  1.00  0.00           H  
ATOM   1028  HG2 LYS B   7       2.040   6.571   9.570  1.00  0.00           H  
ATOM   1029  HG3 LYS B   7       3.440   6.896  10.597  1.00  0.00           H  
ATOM   1030  HD2 LYS B   7       2.769   9.198  10.901  1.00  0.00           H  
ATOM   1031  HD3 LYS B   7       1.485   9.035   9.704  1.00  0.00           H  
ATOM   1032  HE2 LYS B   7       1.602   7.404  12.257  1.00  0.00           H  
ATOM   1033  HE3 LYS B   7       0.693   8.906  12.101  1.00  0.00           H  
ATOM   1034  HZ1 LYS B   7       0.145   6.283  10.976  1.00  0.00           H  
ATOM   1035  HZ2 LYS B   7      -0.164   7.603   9.953  1.00  0.00           H  
ATOM   1036  HZ3 LYS B   7      -0.929   7.500  11.466  1.00  0.00           H  
ATOM   1037  N   GLU B   8       2.235   5.952   6.578  1.00  0.00           N  
ATOM   1038  CA  GLU B   8       1.089   5.157   6.132  1.00  0.00           C  
ATOM   1039  C   GLU B   8       1.510   3.834   5.488  1.00  0.00           C  
ATOM   1040  O   GLU B   8       0.824   2.817   5.624  1.00  0.00           O  
ATOM   1041  CB  GLU B   8       0.294   5.975   5.093  1.00  0.00           C  
ATOM   1042  CG  GLU B   8      -0.162   7.323   5.684  1.00  0.00           C  
ATOM   1043  CD  GLU B   8      -0.850   7.124   7.038  1.00  0.00           C  
ATOM   1044  OE1 GLU B   8      -1.866   6.450   7.075  1.00  0.00           O  
ATOM   1045  OE2 GLU B   8      -0.348   7.656   8.018  1.00  0.00           O  
ATOM   1046  H   GLU B   8       2.396   6.822   6.155  1.00  0.00           H  
ATOM   1047  HA  GLU B   8       0.452   4.949   6.976  1.00  0.00           H  
ATOM   1048  HB2 GLU B   8       0.922   6.165   4.230  1.00  0.00           H  
ATOM   1049  HB3 GLU B   8      -0.573   5.412   4.782  1.00  0.00           H  
ATOM   1050  HG2 GLU B   8       0.700   7.963   5.811  1.00  0.00           H  
ATOM   1051  HG3 GLU B   8      -0.855   7.794   4.996  1.00  0.00           H  
ATOM   1052  N   ARG B   9       2.616   3.873   4.755  1.00  0.00           N  
ATOM   1053  CA  ARG B   9       3.122   2.718   4.039  1.00  0.00           C  
ATOM   1054  C   ARG B   9       3.523   1.587   4.981  1.00  0.00           C  
ATOM   1055  O   ARG B   9       3.192   0.433   4.726  1.00  0.00           O  
ATOM   1056  CB  ARG B   9       4.330   3.138   3.198  1.00  0.00           C  
ATOM   1057  CG  ARG B   9       4.821   1.952   2.365  1.00  0.00           C  
ATOM   1058  CD  ARG B   9       5.946   2.410   1.437  1.00  0.00           C  
ATOM   1059  NE  ARG B   9       7.087   2.858   2.229  1.00  0.00           N  
ATOM   1060  CZ  ARG B   9       7.816   3.910   1.872  1.00  0.00           C  
ATOM   1061  NH1 ARG B   9       8.018   4.176   0.610  1.00  0.00           N  
ATOM   1062  NH2 ARG B   9       8.329   4.678   2.785  1.00  0.00           N  
ATOM   1063  H   ARG B   9       3.098   4.718   4.669  1.00  0.00           H  
ATOM   1064  HA  ARG B   9       2.347   2.367   3.365  1.00  0.00           H  
ATOM   1065  HB2 ARG B   9       4.042   3.943   2.536  1.00  0.00           H  
ATOM   1066  HB3 ARG B   9       5.123   3.474   3.848  1.00  0.00           H  
ATOM   1067  HG2 ARG B   9       5.190   1.179   3.023  1.00  0.00           H  
ATOM   1068  HG3 ARG B   9       4.007   1.564   1.779  1.00  0.00           H  
ATOM   1069  HD2 ARG B   9       6.246   1.587   0.807  1.00  0.00           H  
ATOM   1070  HD3 ARG B   9       5.590   3.222   0.818  1.00  0.00           H  
ATOM   1071  HE  ARG B   9       7.310   2.382   3.055  1.00  0.00           H  
ATOM   1072 HH11 ARG B   9       7.624   3.585  -0.094  1.00  0.00           H  
ATOM   1073 HH12 ARG B   9       8.562   4.971   0.348  1.00  0.00           H  
ATOM   1074 HH21 ARG B   9       8.174   4.475   3.752  1.00  0.00           H  
ATOM   1075 HH22 ARG B   9       8.873   5.474   2.522  1.00  0.00           H  
ATOM   1076  N   VAL B  10       4.244   1.911   6.064  1.00  0.00           N  
ATOM   1077  CA  VAL B  10       4.678   0.869   6.995  1.00  0.00           C  
ATOM   1078  C   VAL B  10       3.468   0.152   7.580  1.00  0.00           C  
ATOM   1079  O   VAL B  10       3.504  -1.056   7.770  1.00  0.00           O  
ATOM   1080  CB  VAL B  10       5.668   1.373   8.092  1.00  0.00           C  
ATOM   1081  CG1 VAL B  10       6.272   2.748   7.745  1.00  0.00           C  
ATOM   1082  CG2 VAL B  10       5.009   1.439   9.468  1.00  0.00           C  
ATOM   1083  H   VAL B  10       4.486   2.845   6.227  1.00  0.00           H  
ATOM   1084  HA  VAL B  10       5.204   0.137   6.410  1.00  0.00           H  
ATOM   1085  HB  VAL B  10       6.475   0.662   8.150  1.00  0.00           H  
ATOM   1086 HG11 VAL B  10       6.472   2.805   6.682  1.00  0.00           H  
ATOM   1087 HG12 VAL B  10       7.205   2.883   8.293  1.00  0.00           H  
ATOM   1088 HG13 VAL B  10       5.580   3.528   8.022  1.00  0.00           H  
ATOM   1089 HG21 VAL B  10       4.273   2.228   9.479  1.00  0.00           H  
ATOM   1090 HG22 VAL B  10       5.770   1.634  10.216  1.00  0.00           H  
ATOM   1091 HG23 VAL B  10       4.533   0.491   9.686  1.00  0.00           H  
ATOM   1092  N   ILE B  11       2.387   0.885   7.843  1.00  0.00           N  
ATOM   1093  CA  ILE B  11       1.185   0.255   8.380  1.00  0.00           C  
ATOM   1094  C   ILE B  11       0.659  -0.772   7.377  1.00  0.00           C  
ATOM   1095  O   ILE B  11       0.252  -1.868   7.761  1.00  0.00           O  
ATOM   1096  CB  ILE B  11       0.095   1.293   8.679  1.00  0.00           C  
ATOM   1097  CG1 ILE B  11       0.676   2.409   9.573  1.00  0.00           C  
ATOM   1098  CG2 ILE B  11      -1.067   0.595   9.406  1.00  0.00           C  
ATOM   1099  CD1 ILE B  11      -0.379   2.919  10.572  1.00  0.00           C  
ATOM   1100  H   ILE B  11       2.391   1.845   7.650  1.00  0.00           H  
ATOM   1101  HA  ILE B  11       1.442  -0.257   9.299  1.00  0.00           H  
ATOM   1102  HB  ILE B  11      -0.255   1.720   7.749  1.00  0.00           H  
ATOM   1103 HG12 ILE B  11       1.521   2.023  10.119  1.00  0.00           H  
ATOM   1104 HG13 ILE B  11       1.000   3.230   8.951  1.00  0.00           H  
ATOM   1105 HG21 ILE B  11      -0.758   0.357  10.417  1.00  0.00           H  
ATOM   1106 HG22 ILE B  11      -1.337  -0.309   8.886  1.00  0.00           H  
ATOM   1107 HG23 ILE B  11      -1.918   1.259   9.439  1.00  0.00           H  
ATOM   1108 HD11 ILE B  11      -1.312   3.094  10.055  1.00  0.00           H  
ATOM   1109 HD12 ILE B  11      -0.042   3.839  11.021  1.00  0.00           H  
ATOM   1110 HD13 ILE B  11      -0.532   2.171  11.343  1.00  0.00           H  
ATOM   1111  N   ALA B  12       0.701  -0.414   6.087  1.00  0.00           N  
ATOM   1112  CA  ALA B  12       0.255  -1.311   5.031  1.00  0.00           C  
ATOM   1113  C   ALA B  12       1.159  -2.502   4.962  1.00  0.00           C  
ATOM   1114  O   ALA B  12       0.672  -3.617   4.906  1.00  0.00           O  
ATOM   1115  CB  ALA B  12       0.260  -0.586   3.690  1.00  0.00           C  
ATOM   1116  H   ALA B  12       1.056   0.462   5.837  1.00  0.00           H  
ATOM   1117  HA  ALA B  12      -0.738  -1.668   5.245  1.00  0.00           H  
ATOM   1118  HB1 ALA B  12      -0.561   0.111   3.651  1.00  0.00           H  
ATOM   1119  HB2 ALA B  12       0.162  -1.309   2.894  1.00  0.00           H  
ATOM   1120  HB3 ALA B  12       1.190  -0.050   3.577  1.00  0.00           H  
ATOM   1121  N   ILE B  13       2.470  -2.262   5.012  1.00  0.00           N  
ATOM   1122  CA  ILE B  13       3.428  -3.355   4.984  1.00  0.00           C  
ATOM   1123  C   ILE B  13       3.093  -4.266   6.142  1.00  0.00           C  
ATOM   1124  O   ILE B  13       2.929  -5.459   5.970  1.00  0.00           O  
ATOM   1125  CB  ILE B  13       4.863  -2.798   5.111  1.00  0.00           C  
ATOM   1126  CG1 ILE B  13       5.136  -1.880   3.933  1.00  0.00           C  
ATOM   1127  CG2 ILE B  13       5.900  -3.919   5.067  1.00  0.00           C  
ATOM   1128  CD1 ILE B  13       6.396  -1.062   4.153  1.00  0.00           C  
ATOM   1129  H   ILE B  13       2.790  -1.339   5.094  1.00  0.00           H  
ATOM   1130  HA  ILE B  13       3.332  -3.900   4.057  1.00  0.00           H  
ATOM   1131  HB  ILE B  13       4.965  -2.246   6.031  1.00  0.00           H  
ATOM   1132 HG12 ILE B  13       5.278  -2.494   3.059  1.00  0.00           H  
ATOM   1133 HG13 ILE B  13       4.302  -1.223   3.783  1.00  0.00           H  
ATOM   1134 HG21 ILE B  13       5.875  -4.480   5.984  1.00  0.00           H  
ATOM   1135 HG22 ILE B  13       6.886  -3.480   4.939  1.00  0.00           H  
ATOM   1136 HG23 ILE B  13       5.691  -4.573   4.239  1.00  0.00           H  
ATOM   1137 HD11 ILE B  13       6.528  -0.371   3.330  1.00  0.00           H  
ATOM   1138 HD12 ILE B  13       7.231  -1.730   4.197  1.00  0.00           H  
ATOM   1139 HD13 ILE B  13       6.325  -0.518   5.074  1.00  0.00           H  
ATOM   1140  N   GLY B  14       2.914  -3.666   7.305  1.00  0.00           N  
ATOM   1141  CA  GLY B  14       2.539  -4.405   8.498  1.00  0.00           C  
ATOM   1142  C   GLY B  14       1.252  -5.169   8.275  1.00  0.00           C  
ATOM   1143  O   GLY B  14       1.121  -6.313   8.693  1.00  0.00           O  
ATOM   1144  H   GLY B  14       3.008  -2.692   7.353  1.00  0.00           H  
ATOM   1145  HA2 GLY B  14       3.325  -5.096   8.761  1.00  0.00           H  
ATOM   1146  HA3 GLY B  14       2.386  -3.710   9.307  1.00  0.00           H  
ATOM   1147  N   GLU B  15       0.303  -4.527   7.606  1.00  0.00           N  
ATOM   1148  CA  GLU B  15      -0.972  -5.148   7.340  1.00  0.00           C  
ATOM   1149  C   GLU B  15      -0.766  -6.340   6.432  1.00  0.00           C  
ATOM   1150  O   GLU B  15      -1.341  -7.395   6.673  1.00  0.00           O  
ATOM   1151  CB  GLU B  15      -1.919  -4.128   6.724  1.00  0.00           C  
ATOM   1152  CG  GLU B  15      -3.387  -4.570   6.908  1.00  0.00           C  
ATOM   1153  CD  GLU B  15      -3.733  -4.740   8.395  1.00  0.00           C  
ATOM   1154  OE1 GLU B  15      -3.263  -3.946   9.199  1.00  0.00           O  
ATOM   1155  OE2 GLU B  15      -4.477  -5.655   8.705  1.00  0.00           O  
ATOM   1156  H   GLU B  15       0.467  -3.624   7.284  1.00  0.00           H  
ATOM   1157  HA  GLU B  15      -1.385  -5.495   8.276  1.00  0.00           H  
ATOM   1158  HB2 GLU B  15      -1.764  -3.177   7.199  1.00  0.00           H  
ATOM   1159  HB3 GLU B  15      -1.700  -4.034   5.683  1.00  0.00           H  
ATOM   1160  HG2 GLU B  15      -4.031  -3.816   6.487  1.00  0.00           H  
ATOM   1161  HG3 GLU B  15      -3.558  -5.505   6.387  1.00  0.00           H  
ATOM   1162  N   ILE B  16       0.088  -6.191   5.408  1.00  0.00           N  
ATOM   1163  CA  ILE B  16       0.345  -7.351   4.526  1.00  0.00           C  
ATOM   1164  C   ILE B  16       0.889  -8.489   5.392  1.00  0.00           C  
ATOM   1165  O   ILE B  16       0.416  -9.626   5.348  1.00  0.00           O  
ATOM   1166  CB  ILE B  16       1.443  -7.113   3.448  1.00  0.00           C  
ATOM   1167  CG1 ILE B  16       1.385  -5.728   2.800  1.00  0.00           C  
ATOM   1168  CG2 ILE B  16       1.310  -8.175   2.349  1.00  0.00           C  
ATOM   1169  CD1 ILE B  16       0.116  -5.576   1.984  1.00  0.00           C  
ATOM   1170  H   ILE B  16       0.535  -5.312   5.263  1.00  0.00           H  
ATOM   1171  HA  ILE B  16      -0.585  -7.651   4.066  1.00  0.00           H  
ATOM   1172  HB  ILE B  16       2.415  -7.234   3.916  1.00  0.00           H  
ATOM   1173 HG12 ILE B  16       1.421  -4.982   3.555  1.00  0.00           H  
ATOM   1174 HG13 ILE B  16       2.236  -5.608   2.147  1.00  0.00           H  
ATOM   1175 HG21 ILE B  16       2.073  -8.015   1.605  1.00  0.00           H  
ATOM   1176 HG22 ILE B  16       0.337  -8.102   1.885  1.00  0.00           H  
ATOM   1177 HG23 ILE B  16       1.427  -9.153   2.779  1.00  0.00           H  
ATOM   1178 HD11 ILE B  16       0.036  -4.558   1.641  1.00  0.00           H  
ATOM   1179 HD12 ILE B  16      -0.732  -5.826   2.599  1.00  0.00           H  
ATOM   1180 HD13 ILE B  16       0.164  -6.245   1.135  1.00  0.00           H  
ATOM   1181  N   MET B  17       1.907  -8.129   6.167  1.00  0.00           N  
ATOM   1182  CA  MET B  17       2.599  -9.041   7.069  1.00  0.00           C  
ATOM   1183  C   MET B  17       1.646  -9.612   8.133  1.00  0.00           C  
ATOM   1184  O   MET B  17       1.871 -10.710   8.645  1.00  0.00           O  
ATOM   1185  CB  MET B  17       3.768  -8.295   7.703  1.00  0.00           C  
ATOM   1186  CG  MET B  17       4.654  -7.702   6.595  1.00  0.00           C  
ATOM   1187  SD  MET B  17       5.475  -9.020   5.702  1.00  0.00           S  
ATOM   1188  CE  MET B  17       6.474  -9.581   7.078  1.00  0.00           C  
ATOM   1189  H   MET B  17       2.220  -7.202   6.118  1.00  0.00           H  
ATOM   1190  HA  MET B  17       3.004  -9.858   6.505  1.00  0.00           H  
ATOM   1191  HB2 MET B  17       3.398  -7.504   8.330  1.00  0.00           H  
ATOM   1192  HB3 MET B  17       4.357  -8.991   8.285  1.00  0.00           H  
ATOM   1193  HG2 MET B  17       4.053  -7.160   5.902  1.00  0.00           H  
ATOM   1194  HG3 MET B  17       5.389  -7.046   7.030  1.00  0.00           H  
ATOM   1195  HE1 MET B  17       6.400  -8.857   7.897  1.00  0.00           H  
ATOM   1196  HE2 MET B  17       7.498  -9.663   6.752  1.00  0.00           H  
ATOM   1197  HE3 MET B  17       6.114 -10.550   7.405  1.00  0.00           H  
ATOM   1198  N   ARG B  18       0.572  -8.876   8.447  1.00  0.00           N  
ATOM   1199  CA  ARG B  18      -0.416  -9.352   9.422  1.00  0.00           C  
ATOM   1200  C   ARG B  18      -1.225 -10.503   8.836  1.00  0.00           C  
ATOM   1201  O   ARG B  18      -1.552 -11.463   9.534  1.00  0.00           O  
ATOM   1202  CB  ARG B  18      -1.384  -8.237   9.801  1.00  0.00           C  
ATOM   1203  CG  ARG B  18      -0.730  -7.243  10.764  1.00  0.00           C  
ATOM   1204  CD  ARG B  18      -1.078  -7.580  12.220  1.00  0.00           C  
ATOM   1205  NE  ARG B  18      -1.391  -6.358  12.957  1.00  0.00           N  
ATOM   1206  CZ  ARG B  18      -2.582  -5.774  12.859  1.00  0.00           C  
ATOM   1207  NH1 ARG B  18      -2.837  -4.973  11.866  1.00  0.00           N  
ATOM   1208  NH2 ARG B  18      -3.495  -6.006  13.759  1.00  0.00           N  
ATOM   1209  H   ARG B  18       0.428  -8.016   8.004  1.00  0.00           H  
ATOM   1210  HA  ARG B  18       0.088  -9.682  10.305  1.00  0.00           H  
ATOM   1211  HB2 ARG B  18      -1.674  -7.724   8.913  1.00  0.00           H  
ATOM   1212  HB3 ARG B  18      -2.258  -8.663  10.264  1.00  0.00           H  
ATOM   1213  HG2 ARG B  18       0.340  -7.271  10.641  1.00  0.00           H  
ATOM   1214  HG3 ARG B  18      -1.091  -6.255  10.534  1.00  0.00           H  
ATOM   1215  HD2 ARG B  18      -1.932  -8.242  12.249  1.00  0.00           H  
ATOM   1216  HD3 ARG B  18      -0.233  -8.071  12.683  1.00  0.00           H  
ATOM   1217  HE  ARG B  18      -0.707  -5.959  13.534  1.00  0.00           H  
ATOM   1218 HH11 ARG B  18      -2.138  -4.793  11.174  1.00  0.00           H  
ATOM   1219 HH12 ARG B  18      -3.734  -4.537  11.792  1.00  0.00           H  
ATOM   1220 HH21 ARG B  18      -3.300  -6.622  14.521  1.00  0.00           H  
ATOM   1221 HH22 ARG B  18      -4.391  -5.568  13.685  1.00  0.00           H  
ATOM   1222  N   LEU B  19      -1.559 -10.372   7.547  1.00  0.00           N  
ATOM   1223  CA  LEU B  19      -2.357 -11.377   6.846  1.00  0.00           C  
ATOM   1224  C   LEU B  19      -1.676 -12.739   6.855  1.00  0.00           C  
ATOM   1225  O   LEU B  19      -0.661 -12.933   6.187  1.00  0.00           O  
ATOM   1226  CB  LEU B  19      -2.592 -10.956   5.390  1.00  0.00           C  
ATOM   1227  CG  LEU B  19      -3.261  -9.580   5.299  1.00  0.00           C  
ATOM   1228  CD1 LEU B  19      -3.241  -9.095   3.852  1.00  0.00           C  
ATOM   1229  CD2 LEU B  19      -4.703  -9.665   5.761  1.00  0.00           C  
ATOM   1230  H   LEU B  19      -1.274  -9.569   7.061  1.00  0.00           H  
ATOM   1231  HA  LEU B  19      -3.309 -11.470   7.333  1.00  0.00           H  
ATOM   1232  HB2 LEU B  19      -1.654 -10.914   4.883  1.00  0.00           H  
ATOM   1233  HB3 LEU B  19      -3.213 -11.687   4.915  1.00  0.00           H  
ATOM   1234  HG  LEU B  19      -2.729  -8.881   5.915  1.00  0.00           H  
ATOM   1235 HD11 LEU B  19      -3.708  -9.840   3.218  1.00  0.00           H  
ATOM   1236 HD12 LEU B  19      -2.226  -8.938   3.541  1.00  0.00           H  
ATOM   1237 HD13 LEU B  19      -3.786  -8.169   3.775  1.00  0.00           H  
ATOM   1238 HD21 LEU B  19      -5.348  -9.752   4.902  1.00  0.00           H  
ATOM   1239 HD22 LEU B  19      -4.945  -8.769   6.307  1.00  0.00           H  
ATOM   1240 HD23 LEU B  19      -4.825 -10.521   6.395  1.00  0.00           H  
ATOM   1241  N   PRO B  20      -2.221 -13.691   7.580  1.00  0.00           N  
ATOM   1242  CA  PRO B  20      -1.662 -15.064   7.655  1.00  0.00           C  
ATOM   1243  C   PRO B  20      -2.049 -15.919   6.445  1.00  0.00           C  
ATOM   1244  O   PRO B  20      -1.615 -17.066   6.332  1.00  0.00           O  
ATOM   1245  CB  PRO B  20      -2.276 -15.638   8.945  1.00  0.00           C  
ATOM   1246  CG  PRO B  20      -3.143 -14.574   9.532  1.00  0.00           C  
ATOM   1247  CD  PRO B  20      -3.427 -13.586   8.418  1.00  0.00           C  
ATOM   1248  HA  PRO B  20      -0.589 -15.026   7.757  1.00  0.00           H  
ATOM   1249  HB2 PRO B  20      -2.874 -16.503   8.712  1.00  0.00           H  
ATOM   1250  HB3 PRO B  20      -1.497 -15.897   9.639  1.00  0.00           H  
ATOM   1251  HG2 PRO B  20      -4.066 -15.008   9.894  1.00  0.00           H  
ATOM   1252  HG3 PRO B  20      -2.626 -14.075  10.338  1.00  0.00           H  
ATOM   1253  HD2 PRO B  20      -4.310 -13.882   7.867  1.00  0.00           H  
ATOM   1254  HD3 PRO B  20      -3.534 -12.595   8.818  1.00  0.00           H  
ATOM   1255  N   ASN B  21      -2.878 -15.362   5.551  1.00  0.00           N  
ATOM   1256  CA  ASN B  21      -3.324 -16.094   4.372  1.00  0.00           C  
ATOM   1257  C   ASN B  21      -2.433 -15.788   3.171  1.00  0.00           C  
ATOM   1258  O   ASN B  21      -2.364 -16.580   2.229  1.00  0.00           O  
ATOM   1259  CB  ASN B  21      -4.775 -15.722   4.061  1.00  0.00           C  
ATOM   1260  CG  ASN B  21      -5.692 -16.081   5.228  1.00  0.00           C  
ATOM   1261  OD1 ASN B  21      -5.378 -16.961   6.029  1.00  0.00           O  
ATOM   1262  ND2 ASN B  21      -6.819 -15.445   5.371  1.00  0.00           N  
ATOM   1263  H   ASN B  21      -3.197 -14.443   5.686  1.00  0.00           H  
ATOM   1264  HA  ASN B  21      -3.282 -17.155   4.576  1.00  0.00           H  
ATOM   1265  HB2 ASN B  21      -4.834 -14.665   3.879  1.00  0.00           H  
ATOM   1266  HB3 ASN B  21      -5.098 -16.253   3.182  1.00  0.00           H  
ATOM   1267 HD21 ASN B  21      -7.070 -14.744   4.732  1.00  0.00           H  
ATOM   1268 HD22 ASN B  21      -7.417 -15.665   6.115  1.00  0.00           H  
ATOM   1269  N   LEU B  22      -1.751 -14.637   3.206  1.00  0.00           N  
ATOM   1270  CA  LEU B  22      -0.870 -14.249   2.105  1.00  0.00           C  
ATOM   1271  C   LEU B  22       0.410 -15.068   2.090  1.00  0.00           C  
ATOM   1272  O   LEU B  22       0.926 -15.472   3.133  1.00  0.00           O  
ATOM   1273  CB  LEU B  22      -0.468 -12.767   2.194  1.00  0.00           C  
ATOM   1274  CG  LEU B  22      -1.673 -11.837   2.080  1.00  0.00           C  
ATOM   1275  CD1 LEU B  22      -1.194 -10.405   1.827  1.00  0.00           C  
ATOM   1276  CD2 LEU B  22      -2.526 -12.280   0.917  1.00  0.00           C  
ATOM   1277  H   LEU B  22      -1.846 -14.038   3.980  1.00  0.00           H  
ATOM   1278  HA  LEU B  22      -1.387 -14.413   1.174  1.00  0.00           H  
ATOM   1279  HB2 LEU B  22       0.007 -12.590   3.133  1.00  0.00           H  
ATOM   1280  HB3 LEU B  22       0.226 -12.544   1.397  1.00  0.00           H  
ATOM   1281  HG  LEU B  22      -2.248 -11.875   2.989  1.00  0.00           H  
ATOM   1282 HD11 LEU B  22      -2.038  -9.782   1.563  1.00  0.00           H  
ATOM   1283 HD12 LEU B  22      -0.481 -10.399   1.015  1.00  0.00           H  
ATOM   1284 HD13 LEU B  22      -0.725 -10.019   2.718  1.00  0.00           H  
ATOM   1285 HD21 LEU B  22      -3.150 -11.466   0.605  1.00  0.00           H  
ATOM   1286 HD22 LEU B  22      -3.139 -13.115   1.229  1.00  0.00           H  
ATOM   1287 HD23 LEU B  22      -1.881 -12.571   0.103  1.00  0.00           H  
ATOM   1288  N   ASN B  23       0.934 -15.250   0.884  1.00  0.00           N  
ATOM   1289  CA  ASN B  23       2.187 -15.956   0.685  1.00  0.00           C  
ATOM   1290  C   ASN B  23       3.313 -14.964   0.981  1.00  0.00           C  
ATOM   1291  O   ASN B  23       3.117 -13.757   0.851  1.00  0.00           O  
ATOM   1292  CB  ASN B  23       2.198 -16.472  -0.784  1.00  0.00           C  
ATOM   1293  CG  ASN B  23       3.533 -16.302  -1.505  1.00  0.00           C  
ATOM   1294  OD1 ASN B  23       4.589 -16.496  -0.935  1.00  0.00           O  
ATOM   1295  ND2 ASN B  23       3.531 -15.965  -2.763  1.00  0.00           N  
ATOM   1296  H   ASN B  23       0.482 -14.862   0.110  1.00  0.00           H  
ATOM   1297  HA  ASN B  23       2.265 -16.791   1.365  1.00  0.00           H  
ATOM   1298  HB2 ASN B  23       1.954 -17.506  -0.788  1.00  0.00           H  
ATOM   1299  HB3 ASN B  23       1.446 -15.939  -1.343  1.00  0.00           H  
ATOM   1300 HD21 ASN B  23       2.682 -15.825  -3.231  1.00  0.00           H  
ATOM   1301 HD22 ASN B  23       4.375 -15.851  -3.243  1.00  0.00           H  
ATOM   1302  N   SER B  24       4.487 -15.460   1.371  1.00  0.00           N  
ATOM   1303  CA  SER B  24       5.612 -14.571   1.674  1.00  0.00           C  
ATOM   1304  C   SER B  24       5.959 -13.764   0.433  1.00  0.00           C  
ATOM   1305  O   SER B  24       6.163 -12.551   0.497  1.00  0.00           O  
ATOM   1306  CB  SER B  24       6.830 -15.378   2.134  1.00  0.00           C  
ATOM   1307  OG  SER B  24       6.502 -16.761   2.182  1.00  0.00           O  
ATOM   1308  H   SER B  24       4.598 -16.430   1.457  1.00  0.00           H  
ATOM   1309  HA  SER B  24       5.320 -13.893   2.465  1.00  0.00           H  
ATOM   1310  HB2 SER B  24       7.641 -15.231   1.446  1.00  0.00           H  
ATOM   1311  HB3 SER B  24       7.132 -15.034   3.114  1.00  0.00           H  
ATOM   1312  HG  SER B  24       6.532 -17.040   3.101  1.00  0.00           H  
ATOM   1313  N   LEU B  25       5.977 -14.454  -0.698  1.00  0.00           N  
ATOM   1314  CA  LEU B  25       6.245 -13.829  -1.978  1.00  0.00           C  
ATOM   1315  C   LEU B  25       5.082 -12.927  -2.367  1.00  0.00           C  
ATOM   1316  O   LEU B  25       5.288 -11.860  -2.945  1.00  0.00           O  
ATOM   1317  CB  LEU B  25       6.482 -14.897  -3.057  1.00  0.00           C  
ATOM   1318  CG  LEU B  25       7.957 -14.963  -3.404  1.00  0.00           C  
ATOM   1319  CD1 LEU B  25       8.198 -16.037  -4.475  1.00  0.00           C  
ATOM   1320  CD2 LEU B  25       8.389 -13.597  -3.919  1.00  0.00           C  
ATOM   1321  H   LEU B  25       5.776 -15.410  -0.671  1.00  0.00           H  
ATOM   1322  HA  LEU B  25       7.128 -13.225  -1.883  1.00  0.00           H  
ATOM   1323  HB2 LEU B  25       6.165 -15.851  -2.699  1.00  0.00           H  
ATOM   1324  HB3 LEU B  25       5.932 -14.645  -3.937  1.00  0.00           H  
ATOM   1325  HG  LEU B  25       8.509 -15.208  -2.523  1.00  0.00           H  
ATOM   1326 HD11 LEU B  25       7.880 -16.999  -4.099  1.00  0.00           H  
ATOM   1327 HD12 LEU B  25       9.251 -16.076  -4.715  1.00  0.00           H  
ATOM   1328 HD13 LEU B  25       7.635 -15.793  -5.364  1.00  0.00           H  
ATOM   1329 HD21 LEU B  25       8.996 -13.114  -3.169  1.00  0.00           H  
ATOM   1330 HD22 LEU B  25       7.504 -13.001  -4.103  1.00  0.00           H  
ATOM   1331 HD23 LEU B  25       8.951 -13.705  -4.831  1.00  0.00           H  
ATOM   1332  N   GLN B  26       3.858 -13.342  -2.013  1.00  0.00           N  
ATOM   1333  CA  GLN B  26       2.676 -12.519  -2.306  1.00  0.00           C  
ATOM   1334  C   GLN B  26       2.782 -11.226  -1.522  1.00  0.00           C  
ATOM   1335  O   GLN B  26       2.449 -10.147  -2.003  1.00  0.00           O  
ATOM   1336  CB  GLN B  26       1.392 -13.219  -1.859  1.00  0.00           C  
ATOM   1337  CG  GLN B  26       0.674 -13.897  -3.034  1.00  0.00           C  
ATOM   1338  CD  GLN B  26      -0.568 -14.612  -2.519  1.00  0.00           C  
ATOM   1339  OE1 GLN B  26      -1.238 -15.316  -3.272  1.00  0.00           O  
ATOM   1340  NE2 GLN B  26      -0.927 -14.462  -1.272  1.00  0.00           N  
ATOM   1341  H   GLN B  26       3.754 -14.187  -1.529  1.00  0.00           H  
ATOM   1342  HA  GLN B  26       2.635 -12.313  -3.359  1.00  0.00           H  
ATOM   1343  HB2 GLN B  26       1.637 -13.956  -1.119  1.00  0.00           H  
ATOM   1344  HB3 GLN B  26       0.727 -12.489  -1.418  1.00  0.00           H  
ATOM   1345  HG2 GLN B  26       0.374 -13.149  -3.756  1.00  0.00           H  
ATOM   1346  HG3 GLN B  26       1.332 -14.610  -3.502  1.00  0.00           H  
ATOM   1347 HE21 GLN B  26      -0.396 -13.889  -0.670  1.00  0.00           H  
ATOM   1348 HE22 GLN B  26      -1.713 -14.925  -0.934  1.00  0.00           H  
ATOM   1349  N   VAL B  27       3.265 -11.376  -0.300  1.00  0.00           N  
ATOM   1350  CA  VAL B  27       3.448 -10.264   0.605  1.00  0.00           C  
ATOM   1351  C   VAL B  27       4.488  -9.328   0.037  1.00  0.00           C  
ATOM   1352  O   VAL B  27       4.275  -8.121  -0.028  1.00  0.00           O  
ATOM   1353  CB  VAL B  27       3.812 -10.822   1.986  1.00  0.00           C  
ATOM   1354  CG1 VAL B  27       4.372  -9.736   2.906  1.00  0.00           C  
ATOM   1355  CG2 VAL B  27       2.531 -11.409   2.593  1.00  0.00           C  
ATOM   1356  H   VAL B  27       3.510 -12.273  -0.003  1.00  0.00           H  
ATOM   1357  HA  VAL B  27       2.525  -9.731   0.679  1.00  0.00           H  
ATOM   1358  HB  VAL B  27       4.542 -11.607   1.876  1.00  0.00           H  
ATOM   1359 HG11 VAL B  27       4.305 -10.075   3.930  1.00  0.00           H  
ATOM   1360 HG12 VAL B  27       3.803  -8.827   2.788  1.00  0.00           H  
ATOM   1361 HG13 VAL B  27       5.405  -9.552   2.658  1.00  0.00           H  
ATOM   1362 HG21 VAL B  27       2.354 -10.971   3.563  1.00  0.00           H  
ATOM   1363 HG22 VAL B  27       2.634 -12.478   2.692  1.00  0.00           H  
ATOM   1364 HG23 VAL B  27       1.692 -11.188   1.943  1.00  0.00           H  
ATOM   1365  N   VAL B  28       5.573  -9.907  -0.451  1.00  0.00           N  
ATOM   1366  CA  VAL B  28       6.607  -9.141  -1.096  1.00  0.00           C  
ATOM   1367  C   VAL B  28       5.997  -8.439  -2.315  1.00  0.00           C  
ATOM   1368  O   VAL B  28       6.391  -7.333  -2.661  1.00  0.00           O  
ATOM   1369  CB  VAL B  28       7.761 -10.059  -1.521  1.00  0.00           C  
ATOM   1370  CG1 VAL B  28       8.824  -9.222  -2.230  1.00  0.00           C  
ATOM   1371  CG2 VAL B  28       8.376 -10.741  -0.281  1.00  0.00           C  
ATOM   1372  H   VAL B  28       5.660 -10.875  -0.418  1.00  0.00           H  
ATOM   1373  HA  VAL B  28       6.979  -8.397  -0.409  1.00  0.00           H  
ATOM   1374  HB  VAL B  28       7.388 -10.813  -2.201  1.00  0.00           H  
ATOM   1375 HG11 VAL B  28       8.992  -9.613  -3.222  1.00  0.00           H  
ATOM   1376 HG12 VAL B  28       9.748  -9.246  -1.668  1.00  0.00           H  
ATOM   1377 HG13 VAL B  28       8.476  -8.204  -2.301  1.00  0.00           H  
ATOM   1378 HG21 VAL B  28       8.458 -11.805  -0.460  1.00  0.00           H  
ATOM   1379 HG22 VAL B  28       7.743 -10.573   0.579  1.00  0.00           H  
ATOM   1380 HG23 VAL B  28       9.356 -10.331  -0.087  1.00  0.00           H  
ATOM   1381  N   ALA B  29       5.021  -9.103  -2.950  1.00  0.00           N  
ATOM   1382  CA  ALA B  29       4.342  -8.552  -4.117  1.00  0.00           C  
ATOM   1383  C   ALA B  29       3.672  -7.239  -3.748  1.00  0.00           C  
ATOM   1384  O   ALA B  29       3.780  -6.246  -4.473  1.00  0.00           O  
ATOM   1385  CB  ALA B  29       3.280  -9.545  -4.613  1.00  0.00           C  
ATOM   1386  H   ALA B  29       4.740  -9.970  -2.613  1.00  0.00           H  
ATOM   1387  HA  ALA B  29       5.063  -8.379  -4.904  1.00  0.00           H  
ATOM   1388  HB1 ALA B  29       2.303  -9.259  -4.236  1.00  0.00           H  
ATOM   1389  HB2 ALA B  29       3.520 -10.537  -4.256  1.00  0.00           H  
ATOM   1390  HB3 ALA B  29       3.262  -9.547  -5.692  1.00  0.00           H  
ATOM   1391  N   PHE B  30       2.994  -7.239  -2.599  1.00  0.00           N  
ATOM   1392  CA  PHE B  30       2.327  -6.068  -2.121  1.00  0.00           C  
ATOM   1393  C   PHE B  30       3.350  -5.049  -1.635  1.00  0.00           C  
ATOM   1394  O   PHE B  30       3.254  -3.877  -1.976  1.00  0.00           O  
ATOM   1395  CB  PHE B  30       1.351  -6.485  -1.012  1.00  0.00           C  
ATOM   1396  CG  PHE B  30       0.282  -7.395  -1.611  1.00  0.00           C  
ATOM   1397  CD1 PHE B  30      -0.552  -6.946  -2.660  1.00  0.00           C  
ATOM   1398  CD2 PHE B  30       0.152  -8.719  -1.149  1.00  0.00           C  
ATOM   1399  CE1 PHE B  30      -1.485  -7.813  -3.224  1.00  0.00           C  
ATOM   1400  CE2 PHE B  30      -0.790  -9.568  -1.719  1.00  0.00           C  
ATOM   1401  CZ  PHE B  30      -1.606  -9.119  -2.757  1.00  0.00           C  
ATOM   1402  H   PHE B  30       2.948  -8.047  -2.056  1.00  0.00           H  
ATOM   1403  HA  PHE B  30       1.768  -5.631  -2.932  1.00  0.00           H  
ATOM   1404  HB2 PHE B  30       1.890  -7.029  -0.237  1.00  0.00           H  
ATOM   1405  HB3 PHE B  30       0.898  -5.610  -0.588  1.00  0.00           H  
ATOM   1406  HD1 PHE B  30      -0.485  -5.932  -3.031  1.00  0.00           H  
ATOM   1407  HD2 PHE B  30       0.762  -9.084  -0.341  1.00  0.00           H  
ATOM   1408  HE1 PHE B  30      -2.113  -7.472  -4.025  1.00  0.00           H  
ATOM   1409  HE2 PHE B  30      -0.878 -10.577  -1.359  1.00  0.00           H  
ATOM   1410  HZ  PHE B  30      -2.329  -9.781  -3.198  1.00  0.00           H  
ATOM   1411  N   ILE B  31       4.360  -5.509  -0.883  1.00  0.00           N  
ATOM   1412  CA  ILE B  31       5.406  -4.607  -0.390  1.00  0.00           C  
ATOM   1413  C   ILE B  31       6.086  -3.915  -1.573  1.00  0.00           C  
ATOM   1414  O   ILE B  31       6.270  -2.698  -1.576  1.00  0.00           O  
ATOM   1415  CB  ILE B  31       6.440  -5.396   0.438  1.00  0.00           C  
ATOM   1416  CG1 ILE B  31       5.761  -6.019   1.674  1.00  0.00           C  
ATOM   1417  CG2 ILE B  31       7.552  -4.453   0.912  1.00  0.00           C  
ATOM   1418  CD1 ILE B  31       6.689  -7.065   2.308  1.00  0.00           C  
ATOM   1419  H   ILE B  31       4.413  -6.467  -0.678  1.00  0.00           H  
ATOM   1420  HA  ILE B  31       4.953  -3.857   0.241  1.00  0.00           H  
ATOM   1421  HB  ILE B  31       6.868  -6.177  -0.173  1.00  0.00           H  
ATOM   1422 HG12 ILE B  31       5.552  -5.243   2.392  1.00  0.00           H  
ATOM   1423 HG13 ILE B  31       4.837  -6.488   1.387  1.00  0.00           H  
ATOM   1424 HG21 ILE B  31       7.112  -3.629   1.449  1.00  0.00           H  
ATOM   1425 HG22 ILE B  31       8.098  -4.077   0.061  1.00  0.00           H  
ATOM   1426 HG23 ILE B  31       8.227  -4.987   1.565  1.00  0.00           H  
ATOM   1427 HD11 ILE B  31       6.213  -7.505   3.178  1.00  0.00           H  
ATOM   1428 HD12 ILE B  31       7.619  -6.593   2.609  1.00  0.00           H  
ATOM   1429 HD13 ILE B  31       6.894  -7.837   1.582  1.00  0.00           H  
ATOM   1430  N   ASN B  32       6.417  -4.704  -2.588  1.00  0.00           N  
ATOM   1431  CA  ASN B  32       7.044  -4.178  -3.806  1.00  0.00           C  
ATOM   1432  C   ASN B  32       6.150  -3.135  -4.482  1.00  0.00           C  
ATOM   1433  O   ASN B  32       6.651  -2.213  -5.130  1.00  0.00           O  
ATOM   1434  CB  ASN B  32       7.303  -5.308  -4.821  1.00  0.00           C  
ATOM   1435  CG  ASN B  32       8.669  -5.948  -4.604  1.00  0.00           C  
ATOM   1436  OD1 ASN B  32       9.681  -5.253  -4.531  1.00  0.00           O  
ATOM   1437  ND2 ASN B  32       8.762  -7.244  -4.511  1.00  0.00           N  
ATOM   1438  H   ASN B  32       6.220  -5.660  -2.522  1.00  0.00           H  
ATOM   1439  HA  ASN B  32       7.987  -3.716  -3.543  1.00  0.00           H  
ATOM   1440  HB2 ASN B  32       6.538  -6.060  -4.717  1.00  0.00           H  
ATOM   1441  HB3 ASN B  32       7.262  -4.903  -5.822  1.00  0.00           H  
ATOM   1442 HD21 ASN B  32       7.957  -7.799  -4.581  1.00  0.00           H  
ATOM   1443 HD22 ASN B  32       9.635  -7.665  -4.371  1.00  0.00           H  
ATOM   1444  N   SER B  33       4.827  -3.285  -4.339  1.00  0.00           N  
ATOM   1445  CA  SER B  33       3.898  -2.361  -4.947  1.00  0.00           C  
ATOM   1446  C   SER B  33       3.831  -1.083  -4.129  1.00  0.00           C  
ATOM   1447  O   SER B  33       3.612  -0.009  -4.682  1.00  0.00           O  
ATOM   1448  CB  SER B  33       2.543  -3.023  -5.133  1.00  0.00           C  
ATOM   1449  OG  SER B  33       2.540  -3.741  -6.360  1.00  0.00           O  
ATOM   1450  H   SER B  33       4.465  -4.023  -3.811  1.00  0.00           H  
ATOM   1451  HA  SER B  33       4.275  -2.106  -5.918  1.00  0.00           H  
ATOM   1452  HB2 SER B  33       2.374  -3.715  -4.328  1.00  0.00           H  
ATOM   1453  HB3 SER B  33       1.769  -2.268  -5.144  1.00  0.00           H  
ATOM   1454  HG  SER B  33       2.756  -3.125  -7.064  1.00  0.00           H  
ATOM   1455  N   LEU B  34       4.080  -1.185  -2.812  1.00  0.00           N  
ATOM   1456  CA  LEU B  34       4.110   0.015  -1.976  1.00  0.00           C  
ATOM   1457  C   LEU B  34       5.258   0.855  -2.507  1.00  0.00           C  
ATOM   1458  O   LEU B  34       5.136   2.061  -2.721  1.00  0.00           O  
ATOM   1459  CB  LEU B  34       4.380  -0.319  -0.504  1.00  0.00           C  
ATOM   1460  CG  LEU B  34       3.503  -1.482  -0.025  1.00  0.00           C  
ATOM   1461  CD1 LEU B  34       3.722  -1.717   1.449  1.00  0.00           C  
ATOM   1462  CD2 LEU B  34       2.045  -1.169  -0.235  1.00  0.00           C  
ATOM   1463  H   LEU B  34       4.293  -2.059  -2.422  1.00  0.00           H  
ATOM   1464  HA  LEU B  34       3.179   0.554  -2.074  1.00  0.00           H  
ATOM   1465  HB2 LEU B  34       5.416  -0.587  -0.388  1.00  0.00           H  
ATOM   1466  HB3 LEU B  34       4.174   0.550   0.095  1.00  0.00           H  
ATOM   1467  HG  LEU B  34       3.764  -2.367  -0.563  1.00  0.00           H  
ATOM   1468 HD11 LEU B  34       2.960  -1.202   2.026  1.00  0.00           H  
ATOM   1469 HD12 LEU B  34       4.692  -1.335   1.712  1.00  0.00           H  
ATOM   1470 HD13 LEU B  34       3.673  -2.780   1.652  1.00  0.00           H  
ATOM   1471 HD21 LEU B  34       1.443  -1.957   0.184  1.00  0.00           H  
ATOM   1472 HD22 LEU B  34       1.860  -1.084  -1.280  1.00  0.00           H  
ATOM   1473 HD23 LEU B  34       1.814  -0.248   0.253  1.00  0.00           H  
ATOM   1474  N   ARG B  35       6.362   0.151  -2.773  1.00  0.00           N  
ATOM   1475  CA  ARG B  35       7.560   0.757  -3.361  1.00  0.00           C  
ATOM   1476  C   ARG B  35       7.185   1.428  -4.683  1.00  0.00           C  
ATOM   1477  O   ARG B  35       7.567   2.570  -4.948  1.00  0.00           O  
ATOM   1478  CB  ARG B  35       8.589  -0.357  -3.652  1.00  0.00           C  
ATOM   1479  CG  ARG B  35       9.883  -0.165  -2.846  1.00  0.00           C  
ATOM   1480  CD  ARG B  35      10.179  -1.427  -2.024  1.00  0.00           C  
ATOM   1481  NE  ARG B  35      10.996  -1.095  -0.863  1.00  0.00           N  
ATOM   1482  CZ  ARG B  35      12.227  -0.617  -1.000  1.00  0.00           C  
ATOM   1483  NH1 ARG B  35      13.230  -1.433  -1.160  1.00  0.00           N  
ATOM   1484  NH2 ARG B  35      12.431   0.669  -0.970  1.00  0.00           N  
ATOM   1485  H   ARG B  35       6.355  -0.819  -2.583  1.00  0.00           H  
ATOM   1486  HA  ARG B  35       7.980   1.485  -2.688  1.00  0.00           H  
ATOM   1487  HB2 ARG B  35       8.151  -1.311  -3.400  1.00  0.00           H  
ATOM   1488  HB3 ARG B  35       8.827  -0.353  -4.707  1.00  0.00           H  
ATOM   1489  HG2 ARG B  35      10.702   0.007  -3.527  1.00  0.00           H  
ATOM   1490  HG3 ARG B  35       9.786   0.678  -2.185  1.00  0.00           H  
ATOM   1491  HD2 ARG B  35       9.253  -1.868  -1.690  1.00  0.00           H  
ATOM   1492  HD3 ARG B  35      10.709  -2.136  -2.645  1.00  0.00           H  
ATOM   1493  HE  ARG B  35      10.628  -1.229   0.037  1.00  0.00           H  
ATOM   1494 HH11 ARG B  35      13.072  -2.421  -1.181  1.00  0.00           H  
ATOM   1495 HH12 ARG B  35      14.157  -1.072  -1.261  1.00  0.00           H  
ATOM   1496 HH21 ARG B  35      11.661   1.292  -0.843  1.00  0.00           H  
ATOM   1497 HH22 ARG B  35      13.357   1.030  -1.072  1.00  0.00           H  
ATOM   1498  N   ASP B  36       6.422   0.693  -5.496  1.00  0.00           N  
ATOM   1499  CA  ASP B  36       5.964   1.182  -6.795  1.00  0.00           C  
ATOM   1500  C   ASP B  36       5.032   2.384  -6.634  1.00  0.00           C  
ATOM   1501  O   ASP B  36       5.072   3.324  -7.429  1.00  0.00           O  
ATOM   1502  CB  ASP B  36       5.224   0.052  -7.529  1.00  0.00           C  
ATOM   1503  CG  ASP B  36       4.822   0.508  -8.932  1.00  0.00           C  
ATOM   1504  OD1 ASP B  36       5.650   0.420  -9.824  1.00  0.00           O  
ATOM   1505  OD2 ASP B  36       3.692   0.940  -9.091  1.00  0.00           O  
ATOM   1506  H   ASP B  36       6.154  -0.204  -5.209  1.00  0.00           H  
ATOM   1507  HA  ASP B  36       6.820   1.476  -7.383  1.00  0.00           H  
ATOM   1508  HB2 ASP B  36       5.873  -0.809  -7.603  1.00  0.00           H  
ATOM   1509  HB3 ASP B  36       4.337  -0.219  -6.973  1.00  0.00           H  
ATOM   1510  N   ASP B  37       4.189   2.326  -5.604  1.00  0.00           N  
ATOM   1511  CA  ASP B  37       3.226   3.390  -5.332  1.00  0.00           C  
ATOM   1512  C   ASP B  37       2.918   3.470  -3.845  1.00  0.00           C  
ATOM   1513  O   ASP B  37       2.059   2.743  -3.333  1.00  0.00           O  
ATOM   1514  CB  ASP B  37       1.929   3.134  -6.115  1.00  0.00           C  
ATOM   1515  CG  ASP B  37       1.892   3.987  -7.380  1.00  0.00           C  
ATOM   1516  OD1 ASP B  37       1.405   5.105  -7.301  1.00  0.00           O  
ATOM   1517  OD2 ASP B  37       2.343   3.511  -8.407  1.00  0.00           O  
ATOM   1518  H   ASP B  37       4.210   1.539  -5.019  1.00  0.00           H  
ATOM   1519  HA  ASP B  37       3.643   4.337  -5.639  1.00  0.00           H  
ATOM   1520  HB2 ASP B  37       1.877   2.091  -6.383  1.00  0.00           H  
ATOM   1521  HB3 ASP B  37       1.084   3.379  -5.495  1.00  0.00           H  
ATOM   1522  N   PRO B  38       3.594   4.346  -3.146  1.00  0.00           N  
ATOM   1523  CA  PRO B  38       3.375   4.534  -1.695  1.00  0.00           C  
ATOM   1524  C   PRO B  38       2.020   5.171  -1.406  1.00  0.00           C  
ATOM   1525  O   PRO B  38       1.440   4.966  -0.338  1.00  0.00           O  
ATOM   1526  CB  PRO B  38       4.506   5.449  -1.240  1.00  0.00           C  
ATOM   1527  CG  PRO B  38       5.361   5.750  -2.429  1.00  0.00           C  
ATOM   1528  CD  PRO B  38       4.631   5.250  -3.669  1.00  0.00           C  
ATOM   1529  HA  PRO B  38       3.459   3.591  -1.189  1.00  0.00           H  
ATOM   1530  HB2 PRO B  38       4.089   6.360  -0.850  1.00  0.00           H  
ATOM   1531  HB3 PRO B  38       5.089   4.954  -0.487  1.00  0.00           H  
ATOM   1532  HG2 PRO B  38       5.523   6.818  -2.501  1.00  0.00           H  
ATOM   1533  HG3 PRO B  38       6.309   5.242  -2.338  1.00  0.00           H  
ATOM   1534  HD2 PRO B  38       4.183   6.079  -4.201  1.00  0.00           H  
ATOM   1535  HD3 PRO B  38       5.310   4.707  -4.311  1.00  0.00           H  
ATOM   1536  N   SER B  39       1.523   5.939  -2.378  1.00  0.00           N  
ATOM   1537  CA  SER B  39       0.233   6.602  -2.244  1.00  0.00           C  
ATOM   1538  C   SER B  39      -0.865   5.558  -2.210  1.00  0.00           C  
ATOM   1539  O   SER B  39      -1.822   5.671  -1.442  1.00  0.00           O  
ATOM   1540  CB  SER B  39       0.009   7.559  -3.418  1.00  0.00           C  
ATOM   1541  OG  SER B  39       1.089   8.482  -3.483  1.00  0.00           O  
ATOM   1542  H   SER B  39       2.027   6.044  -3.208  1.00  0.00           H  
ATOM   1543  HA  SER B  39       0.218   7.165  -1.322  1.00  0.00           H  
ATOM   1544  HB2 SER B  39      -0.036   7.000  -4.338  1.00  0.00           H  
ATOM   1545  HB3 SER B  39      -0.924   8.090  -3.274  1.00  0.00           H  
ATOM   1546  HG  SER B  39       1.259   8.805  -2.594  1.00  0.00           H  
ATOM   1547  N   GLN B  40      -0.702   4.532  -3.050  1.00  0.00           N  
ATOM   1548  CA  GLN B  40      -1.663   3.452  -3.122  1.00  0.00           C  
ATOM   1549  C   GLN B  40      -1.186   2.256  -2.316  1.00  0.00           C  
ATOM   1550  O   GLN B  40      -1.623   1.136  -2.564  1.00  0.00           O  
ATOM   1551  CB  GLN B  40      -1.957   3.036  -4.576  1.00  0.00           C  
ATOM   1552  CG  GLN B  40      -1.538   4.134  -5.574  1.00  0.00           C  
ATOM   1553  CD  GLN B  40      -1.502   3.567  -6.989  1.00  0.00           C  
ATOM   1554  OE1 GLN B  40      -2.064   4.153  -7.913  1.00  0.00           O  
ATOM   1555  NE2 GLN B  40      -0.870   2.450  -7.210  1.00  0.00           N  
ATOM   1556  H   GLN B  40       0.085   4.503  -3.624  1.00  0.00           H  
ATOM   1557  HA  GLN B  40      -2.574   3.785  -2.687  1.00  0.00           H  
ATOM   1558  HB2 GLN B  40      -1.446   2.114  -4.798  1.00  0.00           H  
ATOM   1559  HB3 GLN B  40      -3.012   2.871  -4.672  1.00  0.00           H  
ATOM   1560  HG2 GLN B  40      -2.252   4.945  -5.533  1.00  0.00           H  
ATOM   1561  HG3 GLN B  40      -0.561   4.510  -5.321  1.00  0.00           H  
ATOM   1562 HE21 GLN B  40      -0.427   1.987  -6.469  1.00  0.00           H  
ATOM   1563 HE22 GLN B  40      -0.836   2.074  -8.114  1.00  0.00           H  
ATOM   1564  N   SER B  41      -0.312   2.489  -1.327  1.00  0.00           N  
ATOM   1565  CA  SER B  41       0.156   1.392  -0.493  1.00  0.00           C  
ATOM   1566  C   SER B  41      -1.043   0.665   0.098  1.00  0.00           C  
ATOM   1567  O   SER B  41      -1.018  -0.544   0.309  1.00  0.00           O  
ATOM   1568  CB  SER B  41       1.024   1.937   0.644  1.00  0.00           C  
ATOM   1569  OG  SER B  41       2.308   2.265   0.145  1.00  0.00           O  
ATOM   1570  H   SER B  41       0.004   3.406  -1.141  1.00  0.00           H  
ATOM   1571  HA  SER B  41       0.724   0.702  -1.102  1.00  0.00           H  
ATOM   1572  HB2 SER B  41       0.566   2.822   1.052  1.00  0.00           H  
ATOM   1573  HB3 SER B  41       1.108   1.192   1.423  1.00  0.00           H  
ATOM   1574  HG  SER B  41       2.516   1.657  -0.568  1.00  0.00           H  
ATOM   1575  N   ALA B  42      -2.088   1.442   0.334  1.00  0.00           N  
ATOM   1576  CA  ALA B  42      -3.339   0.943   0.875  1.00  0.00           C  
ATOM   1577  C   ALA B  42      -4.115   0.143  -0.176  1.00  0.00           C  
ATOM   1578  O   ALA B  42      -4.930  -0.708   0.166  1.00  0.00           O  
ATOM   1579  CB  ALA B  42      -4.188   2.136   1.308  1.00  0.00           C  
ATOM   1580  H   ALA B  42      -2.019   2.391   0.118  1.00  0.00           H  
ATOM   1581  HA  ALA B  42      -3.144   0.323   1.735  1.00  0.00           H  
ATOM   1582  HB1 ALA B  42      -4.576   2.634   0.427  1.00  0.00           H  
ATOM   1583  HB2 ALA B  42      -3.574   2.825   1.869  1.00  0.00           H  
ATOM   1584  HB3 ALA B  42      -5.008   1.795   1.921  1.00  0.00           H  
ATOM   1585  N   ASN B  43      -3.873   0.470  -1.452  1.00  0.00           N  
ATOM   1586  CA  ASN B  43      -4.558  -0.159  -2.577  1.00  0.00           C  
ATOM   1587  C   ASN B  43      -4.139  -1.597  -2.788  1.00  0.00           C  
ATOM   1588  O   ASN B  43      -4.975  -2.493  -2.838  1.00  0.00           O  
ATOM   1589  CB  ASN B  43      -4.229   0.614  -3.825  1.00  0.00           C  
ATOM   1590  CG  ASN B  43      -5.126   0.180  -4.981  1.00  0.00           C  
ATOM   1591  OD1 ASN B  43      -4.682  -0.541  -5.874  1.00  0.00           O  
ATOM   1592  ND2 ASN B  43      -6.368   0.578  -5.019  1.00  0.00           N  
ATOM   1593  H   ASN B  43      -3.225   1.170  -1.642  1.00  0.00           H  
ATOM   1594  HA  ASN B  43      -5.611  -0.106  -2.417  1.00  0.00           H  
ATOM   1595  HB2 ASN B  43      -4.373   1.660  -3.622  1.00  0.00           H  
ATOM   1596  HB3 ASN B  43      -3.197   0.425  -4.077  1.00  0.00           H  
ATOM   1597 HD21 ASN B  43      -6.720   1.151  -4.307  1.00  0.00           H  
ATOM   1598 HD22 ASN B  43      -6.948   0.302  -5.758  1.00  0.00           H  
ATOM   1599  N   LEU B  44      -2.837  -1.814  -2.906  1.00  0.00           N  
ATOM   1600  CA  LEU B  44      -2.338  -3.146  -3.094  1.00  0.00           C  
ATOM   1601  C   LEU B  44      -2.440  -3.862  -1.760  1.00  0.00           C  
ATOM   1602  O   LEU B  44      -2.631  -5.067  -1.699  1.00  0.00           O  
ATOM   1603  CB  LEU B  44      -0.948  -3.173  -3.774  1.00  0.00           C  
ATOM   1604  CG  LEU B  44       0.186  -2.621  -2.927  1.00  0.00           C  
ATOM   1605  CD1 LEU B  44       0.071  -1.118  -2.817  1.00  0.00           C  
ATOM   1606  CD2 LEU B  44       0.252  -3.281  -1.569  1.00  0.00           C  
ATOM   1607  H   LEU B  44      -2.220  -1.079  -2.855  1.00  0.00           H  
ATOM   1608  HA  LEU B  44      -3.027  -3.626  -3.758  1.00  0.00           H  
ATOM   1609  HB2 LEU B  44      -0.708  -4.180  -4.048  1.00  0.00           H  
ATOM   1610  HB3 LEU B  44      -1.007  -2.575  -4.670  1.00  0.00           H  
ATOM   1611  HG  LEU B  44       1.093  -2.827  -3.427  1.00  0.00           H  
ATOM   1612 HD11 LEU B  44      -0.335  -0.858  -1.859  1.00  0.00           H  
ATOM   1613 HD12 LEU B  44      -0.573  -0.741  -3.597  1.00  0.00           H  
ATOM   1614 HD13 LEU B  44       1.059  -0.695  -2.931  1.00  0.00           H  
ATOM   1615 HD21 LEU B  44      -0.193  -4.260  -1.625  1.00  0.00           H  
ATOM   1616 HD22 LEU B  44      -0.266  -2.673  -0.851  1.00  0.00           H  
ATOM   1617 HD23 LEU B  44       1.280  -3.380  -1.287  1.00  0.00           H  
ATOM   1618  N   LEU B  45      -2.399  -3.080  -0.680  1.00  0.00           N  
ATOM   1619  CA  LEU B  45      -2.600  -3.631   0.640  1.00  0.00           C  
ATOM   1620  C   LEU B  45      -4.026  -4.134   0.645  1.00  0.00           C  
ATOM   1621  O   LEU B  45      -4.352  -5.180   1.200  1.00  0.00           O  
ATOM   1622  CB  LEU B  45      -2.423  -2.544   1.709  1.00  0.00           C  
ATOM   1623  CG  LEU B  45      -3.210  -2.901   2.977  1.00  0.00           C  
ATOM   1624  CD1 LEU B  45      -2.712  -4.236   3.531  1.00  0.00           C  
ATOM   1625  CD2 LEU B  45      -3.040  -1.790   4.023  1.00  0.00           C  
ATOM   1626  H   LEU B  45      -2.306  -2.114  -0.787  1.00  0.00           H  
ATOM   1627  HA  LEU B  45      -1.915  -4.444   0.814  1.00  0.00           H  
ATOM   1628  HB2 LEU B  45      -1.375  -2.449   1.950  1.00  0.00           H  
ATOM   1629  HB3 LEU B  45      -2.787  -1.609   1.322  1.00  0.00           H  
ATOM   1630  HG  LEU B  45      -4.258  -2.991   2.732  1.00  0.00           H  
ATOM   1631 HD11 LEU B  45      -2.859  -5.010   2.800  1.00  0.00           H  
ATOM   1632 HD12 LEU B  45      -3.264  -4.482   4.420  1.00  0.00           H  
ATOM   1633 HD13 LEU B  45      -1.661  -4.158   3.761  1.00  0.00           H  
ATOM   1634 HD21 LEU B  45      -2.887  -2.227   4.998  1.00  0.00           H  
ATOM   1635 HD22 LEU B  45      -3.931  -1.181   4.039  1.00  0.00           H  
ATOM   1636 HD23 LEU B  45      -2.194  -1.176   3.767  1.00  0.00           H  
ATOM   1637  N   ALA B  46      -4.858  -3.369  -0.047  1.00  0.00           N  
ATOM   1638  CA  ALA B  46      -6.252  -3.717  -0.197  1.00  0.00           C  
ATOM   1639  C   ALA B  46      -6.303  -5.037  -0.950  1.00  0.00           C  
ATOM   1640  O   ALA B  46      -7.016  -5.961  -0.570  1.00  0.00           O  
ATOM   1641  CB  ALA B  46      -6.994  -2.622  -0.981  1.00  0.00           C  
ATOM   1642  H   ALA B  46      -4.500  -2.572  -0.498  1.00  0.00           H  
ATOM   1643  HA  ALA B  46      -6.693  -3.838   0.786  1.00  0.00           H  
ATOM   1644  HB1 ALA B  46      -7.375  -3.033  -1.902  1.00  0.00           H  
ATOM   1645  HB2 ALA B  46      -6.312  -1.809  -1.212  1.00  0.00           H  
ATOM   1646  HB3 ALA B  46      -7.812  -2.245  -0.387  1.00  0.00           H  
ATOM   1647  N   GLU B  47      -5.474  -5.111  -1.995  1.00  0.00           N  
ATOM   1648  CA  GLU B  47      -5.341  -6.309  -2.802  1.00  0.00           C  
ATOM   1649  C   GLU B  47      -4.837  -7.454  -1.933  1.00  0.00           C  
ATOM   1650  O   GLU B  47      -5.169  -8.612  -2.158  1.00  0.00           O  
ATOM   1651  CB  GLU B  47      -4.331  -6.086  -3.945  1.00  0.00           C  
ATOM   1652  CG  GLU B  47      -4.818  -5.023  -4.921  1.00  0.00           C  
ATOM   1653  CD  GLU B  47      -6.238  -5.324  -5.412  1.00  0.00           C  
ATOM   1654  OE1 GLU B  47      -6.450  -6.400  -5.948  1.00  0.00           O  
ATOM   1655  OE2 GLU B  47      -7.093  -4.472  -5.239  1.00  0.00           O  
ATOM   1656  H   GLU B  47      -4.910  -4.342  -2.204  1.00  0.00           H  
ATOM   1657  HA  GLU B  47      -6.298  -6.567  -3.216  1.00  0.00           H  
ATOM   1658  HB2 GLU B  47      -3.390  -5.753  -3.536  1.00  0.00           H  
ATOM   1659  HB3 GLU B  47      -4.181  -7.013  -4.475  1.00  0.00           H  
ATOM   1660  HG2 GLU B  47      -4.800  -4.068  -4.430  1.00  0.00           H  
ATOM   1661  HG3 GLU B  47      -4.139  -4.997  -5.761  1.00  0.00           H  
ATOM   1662  N   ALA B  48      -4.005  -7.102  -0.953  1.00  0.00           N  
ATOM   1663  CA  ALA B  48      -3.412  -8.068  -0.053  1.00  0.00           C  
ATOM   1664  C   ALA B  48      -4.429  -8.619   0.912  1.00  0.00           C  
ATOM   1665  O   ALA B  48      -4.543  -9.817   1.080  1.00  0.00           O  
ATOM   1666  CB  ALA B  48      -2.346  -7.359   0.757  1.00  0.00           C  
ATOM   1667  H   ALA B  48      -3.771  -6.160  -0.841  1.00  0.00           H  
ATOM   1668  HA  ALA B  48      -2.968  -8.871  -0.613  1.00  0.00           H  
ATOM   1669  HB1 ALA B  48      -1.478  -7.984   0.832  1.00  0.00           H  
ATOM   1670  HB2 ALA B  48      -2.738  -7.152   1.745  1.00  0.00           H  
ATOM   1671  HB3 ALA B  48      -2.089  -6.429   0.273  1.00  0.00           H  
ATOM   1672  N   LYS B  49      -5.177  -7.722   1.523  1.00  0.00           N  
ATOM   1673  CA  LYS B  49      -6.210  -8.114   2.456  1.00  0.00           C  
ATOM   1674  C   LYS B  49      -7.264  -8.898   1.681  1.00  0.00           C  
ATOM   1675  O   LYS B  49      -7.860  -9.847   2.192  1.00  0.00           O  
ATOM   1676  CB  LYS B  49      -6.761  -6.855   3.132  1.00  0.00           C  
ATOM   1677  CG  LYS B  49      -5.753  -6.336   4.163  1.00  0.00           C  
ATOM   1678  CD  LYS B  49      -6.389  -5.196   4.972  1.00  0.00           C  
ATOM   1679  CE  LYS B  49      -6.549  -3.944   4.099  1.00  0.00           C  
ATOM   1680  NZ  LYS B  49      -5.912  -2.780   4.778  1.00  0.00           N  
ATOM   1681  H   LYS B  49      -5.043  -6.776   1.326  1.00  0.00           H  
ATOM   1682  HA  LYS B  49      -5.780  -8.767   3.208  1.00  0.00           H  
ATOM   1683  HB2 LYS B  49      -6.904  -6.094   2.388  1.00  0.00           H  
ATOM   1684  HB3 LYS B  49      -7.689  -7.076   3.625  1.00  0.00           H  
ATOM   1685  HG2 LYS B  49      -5.474  -7.137   4.830  1.00  0.00           H  
ATOM   1686  HG3 LYS B  49      -4.873  -5.968   3.654  1.00  0.00           H  
ATOM   1687  HD2 LYS B  49      -7.360  -5.509   5.328  1.00  0.00           H  
ATOM   1688  HD3 LYS B  49      -5.761  -4.965   5.817  1.00  0.00           H  
ATOM   1689  HE2 LYS B  49      -6.076  -4.101   3.141  1.00  0.00           H  
ATOM   1690  HE3 LYS B  49      -7.600  -3.739   3.950  1.00  0.00           H  
ATOM   1691  HZ1 LYS B  49      -5.984  -1.940   4.170  1.00  0.00           H  
ATOM   1692  HZ2 LYS B  49      -4.911  -2.993   4.962  1.00  0.00           H  
ATOM   1693  HZ3 LYS B  49      -6.399  -2.596   5.679  1.00  0.00           H  
ATOM   1694  N   LYS B  50      -7.417  -8.523   0.408  1.00  0.00           N  
ATOM   1695  CA  LYS B  50      -8.317  -9.215  -0.507  1.00  0.00           C  
ATOM   1696  C   LYS B  50      -7.740 -10.581  -0.854  1.00  0.00           C  
ATOM   1697  O   LYS B  50      -8.468 -11.562  -0.943  1.00  0.00           O  
ATOM   1698  CB  LYS B  50      -8.488  -8.416  -1.793  1.00  0.00           C  
ATOM   1699  CG  LYS B  50      -9.462  -7.245  -1.577  1.00  0.00           C  
ATOM   1700  CD  LYS B  50      -9.307  -6.213  -2.709  1.00  0.00           C  
ATOM   1701  CE  LYS B  50      -9.548  -6.874  -4.072  1.00  0.00           C  
ATOM   1702  NZ  LYS B  50      -9.593  -5.828  -5.130  1.00  0.00           N  
ATOM   1703  H   LYS B  50      -6.862  -7.795   0.065  1.00  0.00           H  
ATOM   1704  HA  LYS B  50      -9.275  -9.347  -0.041  1.00  0.00           H  
ATOM   1705  HB2 LYS B  50      -7.529  -8.039  -2.100  1.00  0.00           H  
ATOM   1706  HB3 LYS B  50      -8.880  -9.068  -2.558  1.00  0.00           H  
ATOM   1707  HG2 LYS B  50     -10.476  -7.620  -1.569  1.00  0.00           H  
ATOM   1708  HG3 LYS B  50      -9.252  -6.770  -0.630  1.00  0.00           H  
ATOM   1709  HD2 LYS B  50     -10.025  -5.418  -2.567  1.00  0.00           H  
ATOM   1710  HD3 LYS B  50      -8.310  -5.799  -2.687  1.00  0.00           H  
ATOM   1711  HE2 LYS B  50      -8.746  -7.565  -4.285  1.00  0.00           H  
ATOM   1712  HE3 LYS B  50     -10.488  -7.409  -4.053  1.00  0.00           H  
ATOM   1713  HZ1 LYS B  50      -9.746  -6.276  -6.057  1.00  0.00           H  
ATOM   1714  HZ2 LYS B  50      -8.690  -5.309  -5.142  1.00  0.00           H  
ATOM   1715  HZ3 LYS B  50     -10.372  -5.168  -4.935  1.00  0.00           H  
ATOM   1716  N   LEU B  51      -6.419 -10.627  -1.056  1.00  0.00           N  
ATOM   1717  CA  LEU B  51      -5.743 -11.881  -1.388  1.00  0.00           C  
ATOM   1718  C   LEU B  51      -5.775 -12.786  -0.196  1.00  0.00           C  
ATOM   1719  O   LEU B  51      -6.012 -13.989  -0.302  1.00  0.00           O  
ATOM   1720  CB  LEU B  51      -4.290 -11.620  -1.798  1.00  0.00           C  
ATOM   1721  CG  LEU B  51      -4.129 -11.861  -3.295  1.00  0.00           C  
ATOM   1722  CD1 LEU B  51      -4.269 -13.366  -3.573  1.00  0.00           C  
ATOM   1723  CD2 LEU B  51      -5.194 -11.058  -4.070  1.00  0.00           C  
ATOM   1724  H   LEU B  51      -5.892  -9.802  -0.973  1.00  0.00           H  
ATOM   1725  HA  LEU B  51      -6.267 -12.357  -2.202  1.00  0.00           H  
ATOM   1726  HB2 LEU B  51      -4.020 -10.602  -1.562  1.00  0.00           H  
ATOM   1727  HB3 LEU B  51      -3.640 -12.294  -1.265  1.00  0.00           H  
ATOM   1728  HG  LEU B  51      -3.147 -11.542  -3.595  1.00  0.00           H  
ATOM   1729 HD11 LEU B  51      -4.683 -13.518  -4.557  1.00  0.00           H  
ATOM   1730 HD12 LEU B  51      -4.922 -13.818  -2.832  1.00  0.00           H  
ATOM   1731 HD13 LEU B  51      -3.290 -13.827  -3.518  1.00  0.00           H  
ATOM   1732 HD21 LEU B  51      -5.871 -10.577  -3.373  1.00  0.00           H  
ATOM   1733 HD22 LEU B  51      -5.757 -11.721  -4.709  1.00  0.00           H  
ATOM   1734 HD23 LEU B  51      -4.705 -10.306  -4.670  1.00  0.00           H  
ATOM   1735  N   ASN B  52      -5.586 -12.166   0.946  1.00  0.00           N  
ATOM   1736  CA  ASN B  52      -5.642 -12.853   2.201  1.00  0.00           C  
ATOM   1737  C   ASN B  52      -7.015 -13.455   2.300  1.00  0.00           C  
ATOM   1738  O   ASN B  52      -7.188 -14.621   2.644  1.00  0.00           O  
ATOM   1739  CB  ASN B  52      -5.435 -11.829   3.308  1.00  0.00           C  
ATOM   1740  CG  ASN B  52      -6.042 -12.302   4.617  1.00  0.00           C  
ATOM   1741  OD1 ASN B  52      -7.227 -12.097   4.875  1.00  0.00           O  
ATOM   1742  ND2 ASN B  52      -5.291 -12.917   5.455  1.00  0.00           N  
ATOM   1743  H   ASN B  52      -5.443 -11.199   0.941  1.00  0.00           H  
ATOM   1744  HA  ASN B  52      -4.885 -13.617   2.245  1.00  0.00           H  
ATOM   1745  HB2 ASN B  52      -4.384 -11.677   3.438  1.00  0.00           H  
ATOM   1746  HB3 ASN B  52      -5.893 -10.898   3.022  1.00  0.00           H  
ATOM   1747 HD21 ASN B  52      -4.353 -13.067   5.232  1.00  0.00           H  
ATOM   1748 HD22 ASN B  52      -5.655 -13.230   6.301  1.00  0.00           H  
ATOM   1749  N   ASP B  53      -7.973 -12.622   1.936  1.00  0.00           N  
ATOM   1750  CA  ASP B  53      -9.370 -13.032   1.922  1.00  0.00           C  
ATOM   1751  C   ASP B  53      -9.578 -14.120   0.872  1.00  0.00           C  
ATOM   1752  O   ASP B  53     -10.360 -15.051   1.066  1.00  0.00           O  
ATOM   1753  CB  ASP B  53     -10.284 -11.845   1.605  1.00  0.00           C  
ATOM   1754  CG  ASP B  53     -11.745 -12.247   1.823  1.00  0.00           C  
ATOM   1755  OD1 ASP B  53     -12.213 -12.130   2.943  1.00  0.00           O  
ATOM   1756  OD2 ASP B  53     -12.369 -12.679   0.866  1.00  0.00           O  
ATOM   1757  H   ASP B  53      -7.711 -11.706   1.642  1.00  0.00           H  
ATOM   1758  HA  ASP B  53      -9.624 -13.423   2.892  1.00  0.00           H  
ATOM   1759  HB2 ASP B  53     -10.038 -11.017   2.253  1.00  0.00           H  
ATOM   1760  HB3 ASP B  53     -10.145 -11.551   0.577  1.00  0.00           H  
ATOM   1761  N   ALA B  54      -8.863 -13.979  -0.247  1.00  0.00           N  
ATOM   1762  CA  ALA B  54      -8.951 -14.924  -1.348  1.00  0.00           C  
ATOM   1763  C   ALA B  54      -8.459 -16.298  -0.912  1.00  0.00           C  
ATOM   1764  O   ALA B  54      -9.032 -17.322  -1.288  1.00  0.00           O  
ATOM   1765  CB  ALA B  54      -8.112 -14.414  -2.520  1.00  0.00           C  
ATOM   1766  H   ALA B  54      -8.261 -13.211  -0.331  1.00  0.00           H  
ATOM   1767  HA  ALA B  54      -9.975 -14.999  -1.669  1.00  0.00           H  
ATOM   1768  HB1 ALA B  54      -7.073 -14.666  -2.359  1.00  0.00           H  
ATOM   1769  HB2 ALA B  54      -8.214 -13.340  -2.589  1.00  0.00           H  
ATOM   1770  HB3 ALA B  54      -8.455 -14.869  -3.436  1.00  0.00           H  
ATOM   1771  N   GLN B  55      -7.401 -16.303  -0.102  1.00  0.00           N  
ATOM   1772  CA  GLN B  55      -6.831 -17.543   0.403  1.00  0.00           C  
ATOM   1773  C   GLN B  55      -7.494 -17.953   1.717  1.00  0.00           C  
ATOM   1774  O   GLN B  55      -7.290 -19.068   2.202  1.00  0.00           O  
ATOM   1775  CB  GLN B  55      -5.343 -17.348   0.604  1.00  0.00           C  
ATOM   1776  CG  GLN B  55      -4.668 -17.137  -0.751  1.00  0.00           C  
ATOM   1777  CD  GLN B  55      -3.413 -16.302  -0.569  1.00  0.00           C  
ATOM   1778  OE1 GLN B  55      -2.306 -16.765  -0.843  1.00  0.00           O  
ATOM   1779  NE2 GLN B  55      -3.526 -15.088  -0.111  1.00  0.00           N  
ATOM   1780  H   GLN B  55      -6.989 -15.446   0.166  1.00  0.00           H  
ATOM   1781  HA  GLN B  55      -6.974 -18.319  -0.318  1.00  0.00           H  
ATOM   1782  HB2 GLN B  55      -5.194 -16.485   1.211  1.00  0.00           H  
ATOM   1783  HB3 GLN B  55      -4.921 -18.211   1.088  1.00  0.00           H  
ATOM   1784  HG2 GLN B  55      -4.408 -18.093  -1.179  1.00  0.00           H  
ATOM   1785  HG3 GLN B  55      -5.345 -16.616  -1.413  1.00  0.00           H  
ATOM   1786 HE21 GLN B  55      -4.412 -14.730   0.112  1.00  0.00           H  
ATOM   1787 HE22 GLN B  55      -2.731 -14.533   0.008  1.00  0.00           H  
ATOM   1788  N   ALA B  56      -8.296 -17.047   2.282  1.00  0.00           N  
ATOM   1789  CA  ALA B  56      -8.996 -17.321   3.538  1.00  0.00           C  
ATOM   1790  C   ALA B  56     -10.105 -18.335   3.319  1.00  0.00           C  
ATOM   1791  O   ALA B  56     -10.493 -18.611   2.180  1.00  0.00           O  
ATOM   1792  CB  ALA B  56      -9.610 -16.044   4.114  1.00  0.00           C  
ATOM   1793  H   ALA B  56      -8.420 -16.177   1.841  1.00  0.00           H  
ATOM   1794  HA  ALA B  56      -8.297 -17.731   4.252  1.00  0.00           H  
ATOM   1795  HB1 ALA B  56      -8.899 -15.240   4.056  1.00  0.00           H  
ATOM   1796  HB2 ALA B  56      -9.880 -16.214   5.145  1.00  0.00           H  
ATOM   1797  HB3 ALA B  56     -10.493 -15.787   3.550  1.00  0.00           H  
ATOM   1798  N   PRO B  57     -10.622 -18.893   4.386  1.00  0.00           N  
ATOM   1799  CA  PRO B  57     -11.701 -19.892   4.324  1.00  0.00           C  
ATOM   1800  C   PRO B  57     -13.061 -19.219   4.182  1.00  0.00           C  
ATOM   1801  O   PRO B  57     -13.186 -18.004   4.350  1.00  0.00           O  
ATOM   1802  CB  PRO B  57     -11.580 -20.648   5.660  1.00  0.00           C  
ATOM   1803  CG  PRO B  57     -10.448 -20.012   6.404  1.00  0.00           C  
ATOM   1804  CD  PRO B  57     -10.258 -18.646   5.780  1.00  0.00           C  
ATOM   1805  HA  PRO B  57     -11.531 -20.566   3.507  1.00  0.00           H  
ATOM   1806  HB2 PRO B  57     -12.493 -20.560   6.225  1.00  0.00           H  
ATOM   1807  HB3 PRO B  57     -11.352 -21.683   5.474  1.00  0.00           H  
ATOM   1808  HG2 PRO B  57     -10.700 -19.914   7.451  1.00  0.00           H  
ATOM   1809  HG3 PRO B  57      -9.549 -20.594   6.287  1.00  0.00           H  
ATOM   1810  HD2 PRO B  57     -10.937 -17.931   6.228  1.00  0.00           H  
ATOM   1811  HD3 PRO B  57      -9.238 -18.324   5.863  1.00  0.00           H  
ATOM   1812  N   LYS B  58     -14.061 -20.022   3.857  1.00  0.00           N  
ATOM   1813  CA  LYS B  58     -15.420 -19.529   3.668  1.00  0.00           C  
ATOM   1814  C   LYS B  58     -16.442 -20.603   4.048  1.00  0.00           C  
ATOM   1815  O   LYS B  58     -16.231 -21.751   3.691  1.00  0.00           O  
ATOM   1816  CB  LYS B  58     -15.601 -19.126   2.205  1.00  0.00           C  
ATOM   1817  CG  LYS B  58     -15.377 -17.611   2.033  1.00  0.00           C  
ATOM   1818  CD  LYS B  58     -14.445 -17.344   0.837  1.00  0.00           C  
ATOM   1819  CE  LYS B  58     -13.645 -16.056   1.074  1.00  0.00           C  
ATOM   1820  NZ  LYS B  58     -12.556 -16.323   2.057  1.00  0.00           N  
ATOM   1821  OXT LYS B  58     -17.422 -20.259   4.689  1.00  0.00           O  
ATOM   1822  H   LYS B  58     -13.879 -20.966   3.732  1.00  0.00           H  
ATOM   1823  HA  LYS B  58     -15.571 -18.665   4.283  1.00  0.00           H  
ATOM   1824  HB2 LYS B  58     -14.888 -19.666   1.613  1.00  0.00           H  
ATOM   1825  HB3 LYS B  58     -16.594 -19.383   1.885  1.00  0.00           H  
ATOM   1826  HG2 LYS B  58     -16.329 -17.130   1.858  1.00  0.00           H  
ATOM   1827  HG3 LYS B  58     -14.935 -17.204   2.929  1.00  0.00           H  
ATOM   1828  HD2 LYS B  58     -13.761 -18.171   0.716  1.00  0.00           H  
ATOM   1829  HD3 LYS B  58     -15.036 -17.236  -0.061  1.00  0.00           H  
ATOM   1830  HE2 LYS B  58     -13.214 -15.725   0.141  1.00  0.00           H  
ATOM   1831  HE3 LYS B  58     -14.299 -15.288   1.461  1.00  0.00           H  
ATOM   1832  HZ1 LYS B  58     -12.970 -16.515   2.991  1.00  0.00           H  
ATOM   1833  HZ2 LYS B  58     -11.931 -15.492   2.116  1.00  0.00           H  
ATOM   1834  HZ3 LYS B  58     -12.005 -17.149   1.749  1.00  0.00           H  
TER    1835      LYS B  58                                                      
END
MOLECULE T0498_8_52.pdb
ATOM    153  N   ASN     8       1.180  11.526   4.071  1.00  0.00
ATOM    154  H   ASN     8       0.611  11.164   3.368  1.00  0.00
ATOM    155  CA  ASN     8       2.289  10.722   4.582  1.00  0.00
ATOM    156  HA  ASN     8       3.207  11.234   4.338  1.00  0.00
ATOM    157  CB  ASN     8       2.189  10.584   6.105  1.00  0.00
ATOM    158 1HB  ASN     8       1.857   9.581   6.346  1.00  0.00
ATOM    159 2HB  ASN     8       1.468  11.293   6.477  1.00  0.00
ATOM    160  QB  ASN     8       1.662  10.437   6.412  1.00  0.00
ATOM    161  CG  ASN     8       3.513  10.831   6.796  1.00  0.00
ATOM    162  OD1 ASN     8       4.578  10.685   6.197  1.00  0.00
ATOM    163  ND2 ASN     8       3.458  11.213   8.069  1.00  0.00
ATOM    164 1HD2 ASN     8       2.575  11.310   8.485  1.00  0.00
ATOM    165 2HD2 ASN     8       4.301  11.383   8.543  1.00  0.00
ATOM    166  QD2 ASN     8       3.438  11.346   8.514  1.00  0.00
ATOM    167  C   ASN     8       2.319   9.342   3.945  1.00  0.00
ATOM    168  O   ASN     8       1.350   8.590   4.024  1.00  0.00
ATOM    169  N   LEU     9       3.450   9.006   3.332  1.00  0.00
ATOM    170  H   LEU     9       4.195   9.634   3.326  1.00  0.00
ATOM    171  CA  LEU     9       3.623   7.702   2.703  1.00  0.00
ATOM    172  HA  LEU     9       2.656   7.367   2.353  1.00  0.00
ATOM    173  CB  LEU     9       4.589   7.784   1.523  1.00  0.00
ATOM    174 1HB  LEU     9       4.959   6.786   1.322  1.00  0.00
ATOM    175 2HB  LEU     9       5.423   8.413   1.810  1.00  0.00
ATOM    176  QB  LEU     9       5.191   7.599   1.566  1.00  0.00
ATOM    177  CG  LEU     9       3.989   8.341   0.230  1.00  0.00
ATOM    178  HG  LEU     9       4.740   8.317  -0.547  1.00  0.00
ATOM    179  QD1 LEU     9       2.535   7.287  -0.337  1.00  0.00
ATOM    180  QD2 LEU     9       3.459  10.131   0.471  1.00  0.00
ATOM    181  CD1 LEU     9       2.814   7.489  -0.228  1.00  0.00
ATOM    182 1HD1 LEU     9       2.660   6.680   0.471  1.00  0.00
ATOM    183 2HD1 LEU     9       3.024   7.083  -1.206  1.00  0.00
ATOM    184 3HD1 LEU     9       1.922   8.097  -0.276  1.00  0.00
ATOM    185  CD2 LEU     9       3.560   9.788   0.424  1.00  0.00
ATOM    186 1HD2 LEU     9       2.506   9.824   0.653  1.00  0.00
ATOM    187 2HD2 LEU     9       3.751  10.346  -0.481  1.00  0.00
ATOM    188 3HD2 LEU     9       4.119  10.223   1.240  1.00  0.00
ATOM    189  QQD LEU     9       2.997   8.709   0.067  1.00  0.00
ATOM    190  C   LEU     9       4.145   6.718   3.730  1.00  0.00
ATOM    191  O   LEU     9       3.692   5.578   3.816  1.00  0.00
ATOM    192  N   LYS+   10       5.100   7.194   4.521  1.00  0.00
ATOM    193  H   LYS+   10       5.397   8.118   4.393  1.00  0.00
ATOM    194  CA  LYS+   10       5.709   6.403   5.576  1.00  0.00
ATOM    195  HA  LYS+   10       6.376   5.687   5.124  1.00  0.00
ATOM    196  CB  LYS+   10       6.507   7.326   6.496  1.00  0.00
ATOM    197 1HB  LYS+   10       6.086   7.271   7.485  1.00  0.00
ATOM    198 2HB  LYS+   10       6.412   8.336   6.121  1.00  0.00
ATOM    199  QB  LYS+   10       6.249   7.804   6.803  1.00  0.00
ATOM    200  CG  LYS+   10       7.981   6.974   6.572  1.00  0.00
ATOM    201 1HG  LYS+   10       8.526   7.588   5.869  1.00  0.00
ATOM    202 2HG  LYS+   10       8.114   5.937   6.325  1.00  0.00
ATOM    203  QG  LYS+   10       8.320   6.763   6.097  1.00  0.00
ATOM    204  CD  LYS+   10       8.536   7.218   7.969  1.00  0.00
ATOM    205 1HD  LYS+   10       9.507   6.750   8.047  1.00  0.00
ATOM    206 2HD  LYS+   10       7.865   6.781   8.692  1.00  0.00
ATOM    207  QD  LYS+   10       8.686   6.766   8.370  1.00  0.00
ATOM    208  CE  LYS+   10       8.681   8.704   8.262  1.00  0.00
ATOM    209 1HE  LYS+   10       7.818   9.029   8.823  1.00  0.00
ATOM    210 2HE  LYS+   10       8.723   9.241   7.327  1.00  0.00
ATOM    211  QE  LYS+   10       8.270   9.135   8.075  1.00  0.00
ATOM    212  NZ  LYS+   10       9.910   8.996   9.041  1.00  0.00
ATOM    213 1HZ  LYS+   10      10.217   9.981   8.879  1.00  0.00
ATOM    214 2HZ  LYS+   10      10.678   8.354   8.758  1.00  0.00
ATOM    215 3HZ  LYS+   10       9.731   8.874  10.062  1.00  0.00
ATOM    216  QZ  LYS+   10      10.208   9.070   9.233  1.00  0.00
ATOM    217  C   LYS+   10       4.638   5.664   6.369  1.00  0.00
ATOM    218  O   LYS+   10       4.823   4.521   6.785  1.00  0.00
ATOM    219  N   GLN    11       3.507   6.333   6.553  1.00  0.00
ATOM    220  H   GLN    11       3.422   7.229   6.175  1.00  0.00
ATOM    221  CA  GLN    11       2.382   5.764   7.274  1.00  0.00
ATOM    222  HA  GLN    11       2.751   5.309   8.176  1.00  0.00
ATOM    223  CB  GLN    11       1.383   6.865   7.627  1.00  0.00
ATOM    224 1HB  GLN    11       1.132   7.411   6.732  1.00  0.00
ATOM    225 2HB  GLN    11       1.857   7.547   8.321  1.00  0.00
ATOM    226  QB  GLN    11       1.494   7.479   7.527  1.00  0.00
ATOM    227  CG  GLN    11       0.101   6.364   8.271  1.00  0.00
ATOM    228 1HG  GLN    11      -0.207   5.461   7.765  1.00  0.00
ATOM    229 2HG  GLN    11      -0.664   7.118   8.155  1.00  0.00
ATOM    230  QG  GLN    11      -0.436   6.289   7.960  1.00  0.00
ATOM    231  CD  GLN    11       0.262   6.061   9.746  1.00  0.00
ATOM    232  OE1 GLN    11       1.378   5.917  10.244  1.00  0.00
ATOM    233  NE2 GLN    11      -0.858   5.960  10.453  1.00  0.00
ATOM    234 1HE2 GLN    11      -1.714   6.085   9.988  1.00  0.00
ATOM    235 2HE2 GLN    11      -0.785   5.764  11.411  1.00  0.00
ATOM    236  QE2 GLN    11      -1.250   5.924  10.700  1.00  0.00
ATOM    237  C   GLN    11       1.702   4.693   6.429  1.00  0.00
ATOM    238  O   GLN    11       1.319   3.637   6.934  1.00  0.00
ATOM    239  N   ALA    12       1.568   4.973   5.137  1.00  0.00
ATOM    240  H   ALA    12       1.901   5.830   4.798  1.00  0.00
ATOM    241  CA  ALA    12       0.947   4.036   4.212  1.00  0.00
ATOM    242  HA  ALA    12      -0.009   3.742   4.620  1.00  0.00
ATOM    243  QB  ALA    12       0.648   4.865   2.549  1.00  0.00
ATOM    244  CB  ALA    12       0.705   4.706   2.867  1.00  0.00
ATOM    245 1HB  ALA    12       1.558   4.543   2.225  1.00  0.00
ATOM    246 2HB  ALA    12       0.563   5.767   3.014  1.00  0.00
ATOM    247 3HB  ALA    12      -0.178   4.286   2.408  1.00  0.00
ATOM    248  C   ALA    12       1.815   2.798   4.035  1.00  0.00
ATOM    249  O   ALA    12       1.319   1.670   4.077  1.00  0.00
ATOM    250  N   LYS+   13       3.112   3.010   3.834  1.00  0.00
ATOM    251  H   LYS+   13       3.449   3.934   3.807  1.00  0.00
ATOM    252  CA  LYS+   13       4.042   1.901   3.648  1.00  0.00
ATOM    253  HA  LYS+   13       3.622   1.249   2.897  1.00  0.00
ATOM    254  CB  LYS+   13       5.399   2.408   3.152  1.00  0.00
ATOM    255 1HB  LYS+   13       5.294   2.734   2.127  1.00  0.00
ATOM    256 2HB  LYS+   13       6.108   1.594   3.189  1.00  0.00
ATOM    257  QB  LYS+   13       5.701   2.164   2.658  1.00  0.00
ATOM    258  CG  LYS+   13       5.960   3.566   3.962  1.00  0.00
ATOM    259 1HG  LYS+   13       5.183   3.958   4.601  1.00  0.00
ATOM    260 2HG  LYS+   13       6.293   4.337   3.284  1.00  0.00
ATOM    261  QG  LYS+   13       5.738   4.148   3.942  1.00  0.00
ATOM    262  CD  LYS+   13       7.134   3.129   4.823  1.00  0.00
ATOM    263 1HD  LYS+   13       6.859   2.235   5.362  1.00  0.00
ATOM    264 2HD  LYS+   13       7.368   3.916   5.523  1.00  0.00
ATOM    265  QD  LYS+   13       7.114   3.075   5.442  1.00  0.00
ATOM    266  CE  LYS+   13       8.364   2.839   3.978  1.00  0.00
ATOM    267 1HE  LYS+   13       8.046   2.461   3.018  1.00  0.00
ATOM    268 2HE  LYS+   13       8.961   2.091   4.480  1.00  0.00
ATOM    269  QE  LYS+   13       8.503   2.276   3.749  1.00  0.00
ATOM    270  NZ  LYS+   13       9.196   4.058   3.769  1.00  0.00
ATOM    271 1HZ  LYS+   13       9.665   4.327   4.659  1.00  0.00
ATOM    272 2HZ  LYS+   13       8.599   4.848   3.455  1.00  0.00
ATOM    273 3HZ  LYS+   13       9.921   3.875   3.047  1.00  0.00
ATOM    274  QZ  LYS+   13       9.395   4.350   3.720  1.00  0.00
ATOM    275  C   LYS+   13       4.216   1.105   4.940  1.00  0.00
ATOM    276  O   LYS+   13       4.072  -0.121   4.946  1.00  0.00
ATOM    277  N   GLU    14       4.519   1.799   6.035  1.00  0.00
ATOM    278  H   GLU    14       4.618   2.771   5.971  1.00  0.00
ATOM    279  CA  GLU    14       4.704   1.138   7.327  1.00  0.00
ATOM    280  HA  GLU    14       5.612   0.557   7.274  1.00  0.00
ATOM    281  CB  GLU    14       4.838   2.165   8.459  1.00  0.00
ATOM    282 1HB  GLU    14       4.722   1.656   9.406  1.00  0.00
ATOM    283 2HB  GLU    14       4.056   2.903   8.362  1.00  0.00
ATOM    284  QB  GLU    14       4.389   2.279   8.884  1.00  0.00
ATOM    285  CG  GLU    14       6.178   2.887   8.473  1.00  0.00
ATOM    286 1HG  GLU    14       5.998   3.942   8.594  1.00  0.00
ATOM    287 2HG  GLU    14       6.675   2.715   7.530  1.00  0.00
ATOM    288  QG  GLU    14       6.337   3.328   8.062  1.00  0.00
ATOM    289  CD  GLU    14       7.084   2.411   9.590  1.00  0.00
ATOM    290  OE1 GLU    14       8.272   2.141   9.315  1.00  0.00
ATOM    291  OE2 GLU    14       6.606   2.309  10.739  1.00  0.00
ATOM    292  C   GLU    14       3.540   0.198   7.620  1.00  0.00
ATOM    293  O   GLU    14       3.725  -0.884   8.177  1.00  0.00
ATOM    294  N   GLU    15       2.342   0.615   7.227  1.00  0.00
ATOM    295  H   GLU    15       2.261   1.484   6.779  1.00  0.00
ATOM    296  CA  GLU    15       1.148  -0.193   7.433  1.00  0.00
ATOM    297  HA  GLU    15       1.146  -0.530   8.458  1.00  0.00
ATOM    298  CB  GLU    15      -0.111   0.640   7.177  1.00  0.00
ATOM    299 1HB  GLU    15      -0.941  -0.028   6.999  1.00  0.00
ATOM    300 2HB  GLU    15       0.046   1.248   6.297  1.00  0.00
ATOM    301  QB  GLU    15      -0.447   0.610   6.648  1.00  0.00
ATOM    302  CG  GLU    15      -0.478   1.559   8.333  1.00  0.00
ATOM    303 1HG  GLU    15      -1.426   2.026   8.115  1.00  0.00
ATOM    304 2HG  GLU    15       0.283   2.319   8.425  1.00  0.00
ATOM    305  QG  GLU    15      -0.571   2.172   8.270  1.00  0.00
ATOM    306  CD  GLU    15      -0.590   0.822   9.652  1.00  0.00
ATOM    307  OE1 GLU    15      -1.727   0.487  10.049  1.00  0.00
ATOM    308  OE2 GLU    15       0.458   0.577  10.287  1.00  0.00
ATOM    309  C   GLU    15       1.167  -1.407   6.513  1.00  0.00
ATOM    310  O   GLU    15       0.677  -2.479   6.870  1.00  0.00
ATOM    311  N   ALA    16       1.743  -1.231   5.325  1.00  0.00
ATOM    312  H   ALA    16       2.118  -0.354   5.102  1.00  0.00
ATOM    313  CA  ALA    16       1.836  -2.311   4.351  1.00  0.00
ATOM    314  HA  ALA    16       0.831  -2.597   4.073  1.00  0.00
ATOM    315  QB  ALA    16       2.728  -1.721   2.804  1.00  0.00
ATOM    316  CB  ALA    16       2.557  -1.834   3.100  1.00  0.00
ATOM    317 1HB  ALA    16       2.522  -2.608   2.348  1.00  0.00
ATOM    318 2HB  ALA    16       3.587  -1.612   3.341  1.00  0.00
ATOM    319 3HB  ALA    16       2.074  -0.944   2.724  1.00  0.00
ATOM    320  C   ALA    16       2.546  -3.520   4.947  1.00  0.00
ATOM    321  O   ALA    16       2.112  -4.659   4.767  1.00  0.00
ATOM    322  N   ILE    17       3.636  -3.268   5.667  1.00  0.00
ATOM    323  H   ILE    17       3.924  -2.339   5.779  1.00  0.00
ATOM    324  CA  ILE    17       4.396  -4.348   6.298  1.00  0.00
ATOM    325  HA  ILE    17       4.538  -5.122   5.562  1.00  0.00
ATOM    326  CB  ILE    17       5.788  -3.888   6.797  1.00  0.00
ATOM    327  HB  ILE    17       5.650  -3.205   7.624  1.00  0.00
ATOM    328  QG2 ILE    17       6.762  -5.363   7.432  1.00  0.00
ATOM    329  CG2 ILE    17       6.573  -5.078   7.310  1.00  0.00
ATOM    330 1HG2 ILE    17       5.985  -5.613   8.042  1.00  0.00
ATOM    331 2HG2 ILE    17       7.491  -4.736   7.768  1.00  0.00
ATOM    332 3HG2 ILE    17       6.811  -5.740   6.488  1.00  0.00
ATOM    333  CG1 ILE    17       6.567  -3.183   5.680  1.00  0.00
ATOM    334 1HG1 ILE    17       6.368  -3.673   4.739  1.00  0.00
ATOM    335 2HG1 ILE    17       7.624  -3.245   5.893  1.00  0.00
ATOM    336  QG1 ILE    17       6.996  -3.459   5.316  1.00  0.00
ATOM    337  QD1 ILE    17       6.132  -1.374   5.489  1.00  0.00
ATOM    338  CD1 ILE    17       6.216  -1.722   5.527  1.00  0.00
ATOM    339 1HD1 ILE    17       7.120  -1.130   5.535  1.00  0.00
ATOM    340 2HD1 ILE    17       5.577  -1.418   6.342  1.00  0.00
ATOM    341 3HD1 ILE    17       5.699  -1.574   4.590  1.00  0.00
ATOM    342  C   ILE    17       3.620  -4.927   7.477  1.00  0.00
ATOM    343  O   ILE    17       3.428  -6.137   7.572  1.00  0.00
ATOM    344  N   LYS+   18       3.173  -4.044   8.365  1.00  0.00
ATOM    345  H   LYS+   18       3.356  -3.105   8.218  1.00  0.00
ATOM    346  CA  LYS+   18       2.411  -4.437   9.544  1.00  0.00
ATOM    347  HA  LYS+   18       3.052  -5.038  10.172  1.00  0.00
ATOM    348  CB  LYS+   18       1.966  -3.200  10.325  1.00  0.00
ATOM    349 1HB  LYS+   18       1.336  -2.595   9.691  1.00  0.00
ATOM    350 2HB  LYS+   18       2.839  -2.630  10.600  1.00  0.00
ATOM    351  QB  LYS+   18       2.088  -2.613  10.146  1.00  0.00
ATOM    352  CG  LYS+   18       1.192  -3.526  11.590  1.00  0.00
ATOM    353 1HG  LYS+   18       0.468  -4.298  11.368  1.00  0.00
ATOM    354 2HG  LYS+   18       0.683  -2.638  11.929  1.00  0.00
ATOM    355  QG  LYS+   18       0.575  -3.468  11.648  1.00  0.00
ATOM    356  CD  LYS+   18       2.113  -4.019  12.697  1.00  0.00
ATOM    357 1HD  LYS+   18       3.053  -4.324  12.261  1.00  0.00
ATOM    358 2HD  LYS+   18       1.652  -4.863  13.188  1.00  0.00
ATOM    359  QD  LYS+   18       2.352  -4.594  12.724  1.00  0.00
ATOM    360  CE  LYS+   18       2.377  -2.935  13.731  1.00  0.00
ATOM    361 1HE  LYS+   18       1.944  -3.240  14.672  1.00  0.00
ATOM    362 2HE  LYS+   18       1.911  -2.019  13.402  1.00  0.00
ATOM    363  QE  LYS+   18       1.927  -2.629  14.037  1.00  0.00
ATOM    364  NZ  LYS+   18       3.833  -2.692  13.923  1.00  0.00
ATOM    365 1HZ  LYS+   18       4.138  -1.875  13.356  1.00  0.00
ATOM    366 2HZ  LYS+   18       4.377  -3.528  13.627  1.00  0.00
ATOM    367 3HZ  LYS+   18       4.034  -2.501  14.925  1.00  0.00
ATOM    368  QZ  LYS+   18       4.183  -2.635  13.969  1.00  0.00
ATOM    369  C   LYS+   18       1.200  -5.265   9.147  1.00  0.00
ATOM    370  O   LYS+   18       0.965  -6.338   9.701  1.00  0.00
ATOM    371  N   GLU    19       0.443  -4.777   8.171  1.00  0.00
ATOM    372  H   GLU    19       0.684  -3.925   7.751  1.00  0.00
ATOM    373  CA  GLU    19      -0.727  -5.503   7.698  1.00  0.00
ATOM    374  HA  GLU    19      -1.409  -5.614   8.527  1.00  0.00
ATOM    375  CB  GLU    19      -1.418  -4.748   6.562  1.00  0.00
ATOM    376 1HB  GLU    19      -2.250  -5.339   6.205  1.00  0.00
ATOM    377 2HB  GLU    19      -0.715  -4.612   5.753  1.00  0.00
ATOM    378  QB  GLU    19      -1.483  -4.975   5.979  1.00  0.00
ATOM    379  CG  GLU    19      -1.945  -3.382   6.970  1.00  0.00
ATOM    380 1HG  GLU    19      -1.905  -2.724   6.115  1.00  0.00
ATOM    381 2HG  GLU    19      -1.318  -2.990   7.756  1.00  0.00
ATOM    382  QG  GLU    19      -1.611  -2.857   6.935  1.00  0.00
ATOM    383  CD  GLU    19      -3.373  -3.437   7.474  1.00  0.00
ATOM    384  OE1 GLU    19      -3.771  -4.487   8.023  1.00  0.00
ATOM    385  OE2 GLU    19      -4.096  -2.430   7.320  1.00  0.00
ATOM    386  C   GLU    19      -0.297  -6.884   7.236  1.00  0.00
ATOM    387  O   GLU    19      -0.922  -7.887   7.576  1.00  0.00
ATOM    388  N   LEU    20       0.807  -6.928   6.498  1.00  0.00
ATOM    389  H   LEU    20       1.285  -6.096   6.284  1.00  0.00
ATOM    390  CA  LEU    20       1.350  -8.186   6.040  1.00  0.00
ATOM    391  HA  LEU    20       0.577  -8.719   5.502  1.00  0.00
ATOM    392  CB  LEU    20       2.531  -7.935   5.111  1.00  0.00
ATOM    393 1HB  LEU    20       3.444  -8.182   5.636  1.00  0.00
ATOM    394 2HB  LEU    20       2.548  -6.880   4.870  1.00  0.00
ATOM    395  QB  LEU    20       2.996  -7.531   5.253  1.00  0.00
ATOM    396  CG  LEU    20       2.489  -8.719   3.804  1.00  0.00
ATOM    397  HG  LEU    20       2.004  -9.675   3.971  1.00  0.00
ATOM    398  QD1 LEU    20       1.477  -7.775   2.538  1.00  0.00
ATOM    399  QD2 LEU    20       4.227  -9.042   3.172  1.00  0.00
ATOM    400  CD1 LEU    20       1.672  -7.956   2.778  1.00  0.00
ATOM    401 1HD1 LEU    20       0.665  -8.348   2.762  1.00  0.00
ATOM    402 2HD1 LEU    20       2.123  -8.069   1.801  1.00  0.00
ATOM    403 3HD1 LEU    20       1.643  -6.908   3.051  1.00  0.00
ATOM    404  CD2 LEU    20       3.895  -8.982   3.293  1.00  0.00
ATOM    405 1HD2 LEU    20       3.932  -9.955   2.832  1.00  0.00
ATOM    406 2HD2 LEU    20       4.589  -8.943   4.118  1.00  0.00
ATOM    407 3HD2 LEU    20       4.161  -8.229   2.565  1.00  0.00
ATOM    408  QQD LEU    20       2.852  -8.409   2.855  1.00  0.00
ATOM    409  C   LEU    20       1.794  -9.004   7.246  1.00  0.00
ATOM    410  O   LEU    20       1.727 -10.230   7.242  1.00  0.00
ATOM    411  N   VAL    21       2.231  -8.293   8.287  1.00  0.00
ATOM    412  H   VAL    21       2.246  -7.315   8.220  1.00  0.00
ATOM    413  CA  VAL    21       2.676  -8.930   9.519  1.00  0.00
ATOM    414  HA  VAL    21       3.310  -9.742   9.239  1.00  0.00
ATOM    415  CB  VAL    21       3.488  -7.975  10.425  1.00  0.00
ATOM    416  HB  VAL    21       2.829  -7.208  10.805  1.00  0.00
ATOM    417  QG1 VAL    21       4.187  -8.911  11.901  1.00  0.00
ATOM    418  QG2 VAL    21       4.869  -7.146   9.450  1.00  0.00
ATOM    419  CG1 VAL    21       4.055  -8.735  11.621  1.00  0.00
ATOM    420 1HG1 VAL    21       5.096  -8.962  11.441  1.00  0.00
ATOM    421 2HG1 VAL    21       3.501  -9.649  11.757  1.00  0.00
ATOM    422 3HG1 VAL    21       3.964  -8.122  12.505  1.00  0.00
ATOM    423  CG2 VAL    21       4.603  -7.304   9.638  1.00  0.00
ATOM    424 1HG2 VAL    21       4.630  -7.705   8.635  1.00  0.00
ATOM    425 2HG2 VAL    21       5.550  -7.491  10.123  1.00  0.00
ATOM    426 3HG2 VAL    21       4.428  -6.240   9.592  1.00  0.00
ATOM    427  QQG VAL    21       4.528  -8.028  10.675  1.00  0.00
ATOM    428  C   VAL    21       1.485  -9.468  10.309  1.00  0.00
ATOM    429  O   VAL    21       1.585 -10.512  10.957  1.00  0.00
ATOM    430  N   ASP    22       0.366  -8.756  10.258  1.00  0.00
ATOM    431  H   ASP    22       0.346  -7.928   9.726  1.00  0.00
ATOM    432  CA  ASP    22      -0.834  -9.169  10.977  1.00  0.00
ATOM    433  HA  ASP    22      -0.523  -9.658  11.887  1.00  0.00
ATOM    434  CB  ASP    22      -1.681  -7.948  11.338  1.00  0.00
ATOM    435 1HB  ASP    22      -2.726  -8.226  11.335  1.00  0.00
ATOM    436 2HB  ASP    22      -1.519  -7.174  10.603  1.00  0.00
ATOM    437  QB  ASP    22      -2.122  -7.700  10.969  1.00  0.00
ATOM    438  CG  ASP    22      -1.338  -7.388  12.704  1.00  0.00
ATOM    439  OD1 ASP    22      -1.528  -6.172  12.914  1.00  0.00
ATOM    440  OD2 ASP    22      -0.878  -8.168  13.565  1.00  0.00
ATOM    441  C   ASP    22      -1.662 -10.149  10.152  1.00  0.00
ATOM    442  O   ASP    22      -2.403 -10.965  10.699  1.00  0.00
ATOM    443  N   ALA    23      -1.534 -10.065   8.831  1.00  0.00
ATOM    444  H   ALA    23      -0.929  -9.394   8.450  1.00  0.00
ATOM    445  CA  ALA    23      -2.273 -10.943   7.935  1.00  0.00
ATOM    446  HA  ALA    23      -3.126 -11.331   8.477  1.00  0.00
ATOM    447  QB  ALA    23      -2.913  -9.975   6.455  1.00  0.00
ATOM    448  CB  ALA    23      -2.791 -10.160   6.738  1.00  0.00
ATOM    449 1HB  ALA    23      -3.660  -9.589   7.030  1.00  0.00
ATOM    450 2HB  ALA    23      -3.059 -10.845   5.948  1.00  0.00
ATOM    451 3HB  ALA    23      -2.021  -9.490   6.387  1.00  0.00
ATOM    452  C   ALA    23      -1.411 -12.112   7.471  1.00  0.00
ATOM    453  O   ALA    23      -1.745 -13.274   7.710  1.00  0.00
ATOM    454  N   GLY    24      -0.308 -11.799   6.801  1.00  0.00
ATOM    455  H   GLY    24      -0.097 -10.856   6.638  1.00  0.00
ATOM    456  CA  GLY    24       0.575 -12.830   6.307  1.00  0.00
ATOM    457 1HA  GLY    24       0.556 -13.668   6.996  1.00  0.00
ATOM    458 2HA  GLY    24       1.585 -12.437   6.262  1.00  0.00
ATOM    459  QA  GLY    24       1.070 -13.052   6.629  1.00  0.00
ATOM    460  C   GLY    24       0.176 -13.318   4.930  1.00  0.00
ATOM    461  O   GLY    24      -0.255 -14.462   4.770  1.00  0.00
ATOM    462  N   THR    25       0.323 -12.455   3.937  1.00  0.00
ATOM    463  H   THR    25       0.670 -11.559   4.132  1.00  0.00
ATOM    464  CA  THR    25      -0.031 -12.797   2.565  1.00  0.00
ATOM    465  HA  THR    25      -0.363 -13.820   2.544  1.00  0.00
ATOM    466  CB  THR    25      -1.174 -11.904   2.077  1.00  0.00
ATOM    467  HB  THR    25      -1.969 -11.920   2.810  1.00  0.00
ATOM    468  QG2 THR    25      -0.664 -10.117   1.822  1.00  0.00
ATOM    469  OG1 THR    25      -1.693 -12.383   0.850  1.00  0.00
ATOM    470 1HG  THR    25      -2.646 -12.467   0.915  1.00  0.00
ATOM    471  CG2 THR    25      -0.763 -10.459   1.871  1.00  0.00
ATOM    472 1HG2 THR    25      -0.288 -10.090   2.768  1.00  0.00
ATOM    473 2HG2 THR    25      -1.635  -9.863   1.654  1.00  0.00
ATOM    474 3HG2 THR    25      -0.068 -10.398   1.046  1.00  0.00
ATOM    475  C   THR    25       1.159 -12.652   1.634  1.00  0.00
ATOM    476  O   THR    25       2.292 -12.455   2.075  1.00  0.00
ATOM    477  N   ALA    26       0.894 -12.759   0.340  1.00  0.00
ATOM    478  H   ALA    26      -0.030 -12.914   0.058  1.00  0.00
ATOM    479  CA  ALA    26       1.930 -12.645  -0.673  1.00  0.00
ATOM    480  HA  ALA    26       2.618 -13.467  -0.545  1.00  0.00
ATOM    481  QB  ALA    26       1.155 -12.784  -2.375  1.00  0.00
ATOM    482  CB  ALA    26       1.305 -12.758  -2.051  1.00  0.00
ATOM    483 1HB  ALA    26       0.340 -13.236  -1.963  1.00  0.00
ATOM    484 2HB  ALA    26       1.945 -13.346  -2.691  1.00  0.00
ATOM    485 3HB  ALA    26       1.179 -11.769  -2.472  1.00  0.00
ATOM    486  C   ALA    26       2.692 -11.331  -0.536  1.00  0.00
ATOM    487  O   ALA    26       2.229 -10.283  -0.983  1.00  0.00
ATOM    488  N   GLU    27       3.859 -11.394   0.089  1.00  0.00
ATOM    489  H   GLU    27       4.174 -12.262   0.427  1.00  0.00
ATOM    490  CA  GLU    27       4.684 -10.209   0.292  1.00  0.00
ATOM    491  HA  GLU    27       4.132  -9.527   0.918  1.00  0.00
ATOM    492  CB  GLU    27       5.987 -10.584   0.999  1.00  0.00
ATOM    493 1HB  GLU    27       6.483  -9.678   1.318  1.00  0.00
ATOM    494 2HB  GLU    27       6.629 -11.105   0.301  1.00  0.00
ATOM    495  QB  GLU    27       6.556 -10.392   0.810  1.00  0.00
ATOM    496  CG  GLU    27       5.791 -11.476   2.216  1.00  0.00
ATOM    497 1HG  GLU    27       4.755 -11.780   2.258  1.00  0.00
ATOM    498 2HG  GLU    27       6.037 -10.912   3.104  1.00  0.00
ATOM    499  QG  GLU    27       5.396 -11.346   2.681  1.00  0.00
ATOM    500  CD  GLU    27       6.661 -12.720   2.181  1.00  0.00
ATOM    501  OE1 GLU    27       7.397 -12.949   3.157  1.00  0.00
ATOM    502  OE2 GLU    27       6.596 -13.459   1.178  1.00  0.00
ATOM    503  C   GLU    27       4.994  -9.527  -1.033  1.00  0.00
ATOM    504  O   GLU    27       5.177  -8.312  -1.082  1.00  0.00
ATOM    505  N   LYS+   28       5.042 -10.301  -2.113  1.00  0.00
ATOM    506  H   LYS+   28       4.884 -11.265  -2.018  1.00  0.00
ATOM    507  CA  LYS+   28       5.323  -9.751  -3.436  1.00  0.00
ATOM    508  HA  LYS+   28       6.370  -9.507  -3.483  1.00  0.00
ATOM    509  CB  LYS+   28       4.998 -10.780  -4.521  1.00  0.00
ATOM    510 1HB  LYS+   28       5.327 -10.394  -5.476  1.00  0.00
ATOM    511 2HB  LYS+   28       3.928 -10.929  -4.554  1.00  0.00
ATOM    512  QB  LYS+   28       4.627 -10.661  -5.015  1.00  0.00
ATOM    513  CG  LYS+   28       5.658 -12.124  -4.302  1.00  0.00
ATOM    514 1HG  LYS+   28       6.279 -12.067  -3.419  1.00  0.00
ATOM    515 2HG  LYS+   28       6.269 -12.358  -5.160  1.00  0.00
ATOM    516  QG  LYS+   28       6.274 -12.213  -4.290  1.00  0.00
ATOM    517  CD  LYS+   28       4.634 -13.234  -4.110  1.00  0.00
ATOM    518 1HD  LYS+   28       3.987 -12.973  -3.283  1.00  0.00
ATOM    519 2HD  LYS+   28       5.150 -14.155  -3.893  1.00  0.00
ATOM    520  QD  LYS+   28       4.568 -13.564  -3.588  1.00  0.00
ATOM    521  CE  LYS+   28       3.785 -13.427  -5.356  1.00  0.00
ATOM    522 1HE  LYS+   28       4.321 -13.032  -6.208  1.00  0.00
ATOM    523 2HE  LYS+   28       2.862 -12.888  -5.232  1.00  0.00
ATOM    524  QE  LYS+   28       3.591 -12.960  -5.720  1.00  0.00
ATOM    525  NZ  LYS+   28       3.476 -14.863  -5.601  1.00  0.00
ATOM    526 1HZ  LYS+   28       3.524 -15.397  -4.709  1.00  0.00
ATOM    527 2HZ  LYS+   28       4.163 -15.270  -6.269  1.00  0.00
ATOM    528 3HZ  LYS+   28       2.520 -14.959  -5.999  1.00  0.00
ATOM    529  QZ  LYS+   28       3.402 -15.208  -5.659  1.00  0.00
ATOM    530  C   LYS+   28       4.511  -8.478  -3.665  1.00  0.00
ATOM    531  O   LYS+   28       4.976  -7.532  -4.303  1.00  0.00
ATOM    532  N   TYR    29       3.300  -8.461  -3.116  1.00  0.00
ATOM    533  H   TYR    29       2.991  -9.239  -2.606  1.00  0.00
ATOM    534  CA  TYR    29       2.429  -7.304  -3.242  1.00  0.00
ATOM    535  HA  TYR    29       2.444  -6.992  -4.276  1.00  0.00
ATOM    536  CB  TYR    29       0.998  -7.673  -2.856  1.00  0.00
ATOM    537 1HB  TYR    29       0.622  -6.952  -2.142  1.00  0.00
ATOM    538 2HB  TYR    29       0.990  -8.659  -2.413  1.00  0.00
ATOM    539  QB  TYR    29       0.806  -7.805  -2.278  1.00  0.00
ATOM    540  QD  TYR    29      -0.054  -7.718  -4.149  1.00  0.00
ATOM    541  QE  TYR    29      -1.604  -7.822  -6.041  1.00  0.00
ATOM    542  QR  TYR    29      -0.829  -7.770  -5.095  1.00  0.00
ATOM    543  CG  TYR    29       0.049  -7.714  -4.019  1.00  0.00
ATOM    544  CD1 TYR    29      -0.618  -8.883  -4.327  1.00  0.00
ATOM    545 1HD  TYR    29      -0.449  -9.759  -3.718  1.00  0.00
ATOM    546  CE1 TYR    29      -1.487  -8.948  -5.386  1.00  0.00
ATOM    547 1HE  TYR    29      -1.993  -9.871  -5.602  1.00  0.00
ATOM    548  CZ  TYR    29      -1.704  -7.828  -6.164  1.00  0.00
ATOM    549  CE2 TYR    29      -1.049  -6.649  -5.875  1.00  0.00
ATOM    550 2HE  TYR    29      -1.215  -5.772  -6.480  1.00  0.00
ATOM    551  CD2 TYR    29      -0.177  -6.595  -4.809  1.00  0.00
ATOM    552 2HD  TYR    29       0.340  -5.676  -4.579  1.00  0.00
ATOM    553  OH  TYR    29      -2.575  -7.889  -7.226  1.00  0.00
ATOM    554  HH  TYR    29      -2.179  -7.464  -7.989  1.00  0.00
ATOM    555  C   TYR    29       2.941  -6.157  -2.377  1.00  0.00
ATOM    556  O   TYR    29       2.942  -5.002  -2.803  1.00  0.00
ATOM    557  N   ILE    30       3.397  -6.479  -1.167  1.00  0.00
ATOM    558  H   ILE    30       3.387  -7.418  -0.882  1.00  0.00
ATOM    559  CA  ILE    30       3.930  -5.464  -0.266  1.00  0.00
ATOM    560  HA  ILE    30       3.154  -4.726  -0.119  1.00  0.00
ATOM    561  CB  ILE    30       4.314  -6.062   1.120  1.00  0.00
ATOM    562  HB  ILE    30       3.541  -6.759   1.397  1.00  0.00
ATOM    563  QG2 ILE    30       5.940  -7.020   1.056  1.00  0.00
ATOM    564  CG2 ILE    30       5.629  -6.835   1.066  1.00  0.00
ATOM    565 1HG2 ILE    30       5.423  -7.895   1.094  1.00  0.00
ATOM    566 2HG2 ILE    30       6.239  -6.568   1.915  1.00  0.00
ATOM    567 3HG2 ILE    30       6.159  -6.598   0.159  1.00  0.00
ATOM    568  CG1 ILE    30       4.387  -4.969   2.197  1.00  0.00
ATOM    569 1HG1 ILE    30       4.651  -5.426   3.140  1.00  0.00
ATOM    570 2HG1 ILE    30       3.421  -4.495   2.295  1.00  0.00
ATOM    571  QG1 ILE    30       4.036  -4.960   2.717  1.00  0.00
ATOM    572  QD1 ILE    30       5.647  -3.631   1.839  1.00  0.00
ATOM    573  CD1 ILE    30       5.406  -3.888   1.908  1.00  0.00
ATOM    574 1HD1 ILE    30       4.924  -3.067   1.397  1.00  0.00
ATOM    575 2HD1 ILE    30       6.190  -4.290   1.284  1.00  0.00
ATOM    576 3HD1 ILE    30       5.829  -3.535   2.836  1.00  0.00
ATOM    577  C   ILE    30       5.128  -4.781  -0.922  1.00  0.00
ATOM    578  O   ILE    30       5.369  -3.590  -0.731  1.00  0.00
ATOM    579  N   LYS+   31       5.858  -5.545  -1.731  1.00  0.00
ATOM    580  H   LYS+   31       5.602  -6.480  -1.867  1.00  0.00
ATOM    581  CA  LYS+   31       7.006  -5.013  -2.447  1.00  0.00
ATOM    582  HA  LYS+   31       7.633  -4.493  -1.738  1.00  0.00
ATOM    583  CB  LYS+   31       7.804  -6.146  -3.093  1.00  0.00
ATOM    584 1HB  LYS+   31       7.190  -6.615  -3.851  1.00  0.00
ATOM    585 2HB  LYS+   31       8.050  -6.876  -2.332  1.00  0.00
ATOM    586  QB  LYS+   31       7.620  -6.745  -3.092  1.00  0.00
ATOM    587  CG  LYS+   31       9.099  -5.683  -3.746  1.00  0.00
ATOM    588 1HG  LYS+   31       9.356  -4.708  -3.359  1.00  0.00
ATOM    589 2HG  LYS+   31       8.948  -5.623  -4.812  1.00  0.00
ATOM    590  QG  LYS+   31       9.152  -5.166  -4.086  1.00  0.00
ATOM    591  CD  LYS+   31      10.235  -6.642  -3.464  1.00  0.00
ATOM    592 1HD  LYS+   31      10.005  -7.214  -2.574  1.00  0.00
ATOM    593 2HD  LYS+   31      11.143  -6.077  -3.301  1.00  0.00
ATOM    594  QD  LYS+   31      10.574  -6.645  -2.938  1.00  0.00
ATOM    595  CE  LYS+   31      10.462  -7.606  -4.620  1.00  0.00
ATOM    596 1HE  LYS+   31       9.615  -7.540  -5.293  1.00  0.00
ATOM    597 2HE  LYS+   31      10.532  -8.609  -4.231  1.00  0.00
ATOM    598  QE  LYS+   31      10.074  -8.074  -4.762  1.00  0.00
ATOM    599  NZ  LYS+   31      11.701  -7.284  -5.375  1.00  0.00
ATOM    600 1HZ  LYS+   31      12.487  -7.896  -5.046  1.00  0.00
ATOM    601 2HZ  LYS+   31      11.968  -6.293  -5.229  1.00  0.00
ATOM    602 3HZ  LYS+   31      11.557  -7.450  -6.391  1.00  0.00
ATOM    603  QZ  LYS+   31      12.004  -7.213  -5.555  1.00  0.00
ATOM    604  C   LYS+   31       6.533  -4.029  -3.508  1.00  0.00
ATOM    605  O   LYS+   31       7.218  -3.055  -3.824  1.00  0.00
ATOM    606  N   LEU    32       5.342  -4.287  -4.046  1.00  0.00
ATOM    607  H   LEU    32       4.842  -5.074  -3.744  1.00  0.00
ATOM    608  CA  LEU    32       4.753  -3.424  -5.061  1.00  0.00
ATOM    609  HA  LEU    32       5.486  -3.277  -5.841  1.00  0.00
ATOM    610  CB  LEU    32       3.505  -4.083  -5.662  1.00  0.00
ATOM    611 1HB  LEU    32       2.629  -3.597  -5.252  1.00  0.00
ATOM    612 2HB  LEU    32       3.494  -5.125  -5.362  1.00  0.00
ATOM    613  QB  LEU    32       3.062  -4.361  -5.307  1.00  0.00
ATOM    614  CG  LEU    32       3.413  -4.020  -7.188  1.00  0.00
ATOM    615  HG  LEU    32       4.395  -4.183  -7.610  1.00  0.00
ATOM    616  QD1 LEU    32       2.274  -5.370  -7.836  1.00  0.00
ATOM    617  QD2 LEU    32       2.813  -2.327  -7.743  1.00  0.00
ATOM    618  CD1 LEU    32       2.492  -5.113  -7.712  1.00  0.00
ATOM    619 1HD1 LEU    32       1.552  -5.075  -7.180  1.00  0.00
ATOM    620 2HD1 LEU    32       2.954  -6.076  -7.560  1.00  0.00
ATOM    621 3HD1 LEU    32       2.316  -4.959  -8.768  1.00  0.00
ATOM    622  CD2 LEU    32       2.928  -2.651  -7.636  1.00  0.00
ATOM    623 1HD2 LEU    32       2.330  -2.207  -6.854  1.00  0.00
ATOM    624 2HD2 LEU    32       2.331  -2.756  -8.531  1.00  0.00
ATOM    625 3HD2 LEU    32       3.777  -2.017  -7.843  1.00  0.00
ATOM    626  QQD LEU    32       2.543  -3.848  -7.789  1.00  0.00
ATOM    627  C   LEU    32       4.388  -2.066  -4.466  1.00  0.00
ATOM    628  O   LEU    32       4.436  -1.045  -5.150  1.00  0.00
ATOM    629  N   ILE    33       4.019  -2.066  -3.186  1.00  0.00
ATOM    630  H   ILE    33       3.998  -2.913  -2.693  1.00  0.00
ATOM    631  CA  ILE    33       3.643  -0.832  -2.501  1.00  0.00
ATOM    632  HA  ILE    33       3.009  -0.271  -3.170  1.00  0.00
ATOM    633  CB  ILE    33       2.840  -1.114  -1.203  1.00  0.00
ATOM    634  HB  ILE    33       2.219  -0.254  -1.003  1.00  0.00
ATOM    635  QG2 ILE    33       1.708  -2.596  -1.442  1.00  0.00
ATOM    636  CG2 ILE    33       1.925  -2.312  -1.396  1.00  0.00
ATOM    637 1HG2 ILE    33       2.430  -3.208  -1.069  1.00  0.00
ATOM    638 2HG2 ILE    33       1.669  -2.404  -2.442  1.00  0.00
ATOM    639 3HG2 ILE    33       1.024  -2.175  -0.816  1.00  0.00
ATOM    640  CG1 ILE    33       3.771  -1.344  -0.007  1.00  0.00
ATOM    641 1HG1 ILE    33       4.744  -1.642  -0.365  1.00  0.00
ATOM    642 2HG1 ILE    33       3.365  -2.128   0.614  1.00  0.00
ATOM    643  QG1 ILE    33       4.055  -1.885   0.124  1.00  0.00
ATOM    644  QD1 ILE    33       3.996   0.176   1.065  1.00  0.00
ATOM    645  CD1 ILE    33       3.953  -0.118   0.859  1.00  0.00
ATOM    646 1HD1 ILE    33       3.014   0.134   1.330  1.00  0.00
ATOM    647 2HD1 ILE    33       4.281   0.710   0.247  1.00  0.00
ATOM    648 3HD1 ILE    33       4.694  -0.318   1.619  1.00  0.00
ATOM    649  C   ILE    33       4.873   0.014  -2.181  1.00  0.00
ATOM    650  O   ILE    33       4.796   1.242  -2.133  1.00  0.00
ATOM    651  N   ALA    34       6.008  -0.647  -1.971  1.00  0.00
ATOM    652  H   ALA    34       6.010  -1.626  -2.025  1.00  0.00
ATOM    653  CA  ALA    34       7.253   0.050  -1.661  1.00  0.00
ATOM    654  HA  ALA    34       7.153   0.493  -0.682  1.00  0.00
ATOM    655  QB  ALA    34       8.687  -1.169  -1.610  1.00  0.00
ATOM    656  CB  ALA    34       8.412  -0.936  -1.620  1.00  0.00
ATOM    657 1HB  ALA    34       8.169  -1.805  -2.215  1.00  0.00
ATOM    658 2HB  ALA    34       8.591  -1.237  -0.598  1.00  0.00
ATOM    659 3HB  ALA    34       9.300  -0.466  -2.018  1.00  0.00
ATOM    660  C   ALA    34       7.532   1.155  -2.679  1.00  0.00
ATOM    661  O   ALA    34       8.186   2.150  -2.365  1.00  0.00
ATOM    662  N   ASN    35       7.028   0.974  -3.897  1.00  0.00
ATOM    663  H   ASN    35       6.514   0.160  -4.084  1.00  0.00
ATOM    664  CA  ASN    35       7.219   1.955  -4.958  1.00  0.00
ATOM    665  HA  ASN    35       8.112   2.516  -4.733  1.00  0.00
ATOM    666  CB  ASN    35       7.405   1.249  -6.304  1.00  0.00
ATOM    667 1HB  ASN    35       6.541   1.438  -6.929  1.00  0.00
ATOM    668 2HB  ASN    35       7.499   0.186  -6.135  1.00  0.00
ATOM    669  QB  ASN    35       7.020   0.812  -6.532  1.00  0.00
ATOM    670  CG  ASN    35       8.636   1.723  -7.034  1.00  0.00
ATOM    671  OD1 ASN    35       8.895   2.924  -7.125  1.00  0.00
ATOM    672  ND2 ASN    35       9.409   0.782  -7.562  1.00  0.00
ATOM    673 1HD2 ASN    35       9.143  -0.155  -7.451  1.00  0.00
ATOM    674 2HD2 ASN    35      10.217   1.063  -8.046  1.00  0.00
ATOM    675  QD2 ASN    35       9.680   0.454  -7.749  1.00  0.00
ATOM    676  C   ASN    35       6.039   2.925  -5.036  1.00  0.00
ATOM    677  O   ASN    35       6.123   3.964  -5.688  1.00  0.00
ATOM    678  N   ALA    36       4.942   2.577  -4.367  1.00  0.00
ATOM    679  H   ALA    36       4.932   1.739  -3.865  1.00  0.00
ATOM    680  CA  ALA    36       3.747   3.417  -4.358  1.00  0.00
ATOM    681  HA  ALA    36       3.282   3.343  -5.329  1.00  0.00
ATOM    682  QB  ALA    36       2.519   2.789  -3.078  1.00  0.00
ATOM    683  CB  ALA    36       2.754   2.909  -3.322  1.00  0.00
ATOM    684 1HB  ALA    36       2.860   1.840  -3.218  1.00  0.00
ATOM    685 2HB  ALA    36       1.749   3.142  -3.643  1.00  0.00
ATOM    686 3HB  ALA    36       2.949   3.385  -2.373  1.00  0.00
ATOM    687  C   ALA    36       4.095   4.879  -4.087  1.00  0.00
ATOM    688  O   ALA    36       4.852   5.186  -3.167  1.00  0.00
ATOM    689  N   LYS+   37       3.534   5.773  -4.892  1.00  0.00
ATOM    690  H   LYS+   37       2.935   5.461  -5.605  1.00  0.00
ATOM    691  CA  LYS+   37       3.783   7.204  -4.737  1.00  0.00
ATOM    692  HA  LYS+   37       4.634   7.319  -4.080  1.00  0.00
ATOM    693  CB  LYS+   37       4.109   7.855  -6.088  1.00  0.00
ATOM    694 1HB  LYS+   37       3.189   7.981  -6.647  1.00  0.00
ATOM    695 2HB  LYS+   37       4.776   7.205  -6.638  1.00  0.00
ATOM    696  QB  LYS+   37       3.983   7.593  -6.643  1.00  0.00
ATOM    697  CG  LYS+   37       4.769   9.214  -5.956  1.00  0.00
ATOM    698 1HG  LYS+   37       5.843   9.088  -6.000  1.00  0.00
ATOM    699 2HG  LYS+   37       4.498   9.653  -5.010  1.00  0.00
ATOM    700  QG  LYS+   37       5.171   9.370  -5.505  1.00  0.00
ATOM    701  CD  LYS+   37       4.336  10.151  -7.070  1.00  0.00
ATOM    702 1HD  LYS+   37       3.297   9.968  -7.299  1.00  0.00
ATOM    703 2HD  LYS+   37       4.942   9.956  -7.948  1.00  0.00
ATOM    704  QD  LYS+   37       4.119   9.962  -7.624  1.00  0.00
ATOM    705  CE  LYS+   37       4.510  11.611  -6.676  1.00  0.00
ATOM    706 1HE  LYS+   37       5.545  11.890  -6.815  1.00  0.00
ATOM    707 2HE  LYS+   37       4.246  11.720  -5.637  1.00  0.00
ATOM    708  QE  LYS+   37       4.896  11.805  -6.226  1.00  0.00
ATOM    709  NZ  LYS+   37       3.649  12.512  -7.492  1.00  0.00
ATOM    710 1HZ  LYS+   37       4.145  13.403  -7.677  1.00  0.00
ATOM    711 2HZ  LYS+   37       2.768  12.722  -6.981  1.00  0.00
ATOM    712 3HZ  LYS+   37       3.416  12.059  -8.398  1.00  0.00
ATOM    713  QZ  LYS+   37       3.443  12.728  -7.686  1.00  0.00
ATOM    714  C   LYS+   37       2.581   7.894  -4.103  1.00  0.00
ATOM    715  O   LYS+   37       2.727   8.878  -3.379  1.00  0.00
ATOM    716  N   THR    38       1.392   7.367  -4.377  1.00  0.00
ATOM    717  H   THR    38       1.341   6.580  -4.958  1.00  0.00
ATOM    718  CA  THR    38       0.164   7.927  -3.829  1.00  0.00
ATOM    719  HA  THR    38       0.354   8.957  -3.573  1.00  0.00
ATOM    720  CB  THR    38      -0.955   7.871  -4.871  1.00  0.00
ATOM    721  HB  THR    38      -1.909   7.926  -4.363  1.00  0.00
ATOM    722  QG2 THR    38      -0.886   9.274  -6.109  1.00  0.00
ATOM    723  OG1 THR    38      -0.907   6.656  -5.595  1.00  0.00
ATOM    724 1HG  THR    38      -1.768   6.478  -5.982  1.00  0.00
ATOM    725  CG2 THR    38      -0.900   9.004  -5.872  1.00  0.00
ATOM    726 1HG2 THR    38      -1.502   8.755  -6.733  1.00  0.00
ATOM    727 2HG2 THR    38       0.124   9.161  -6.179  1.00  0.00
ATOM    728 3HG2 THR    38      -1.281   9.905  -5.415  1.00  0.00
ATOM    729  C   THR    38      -0.258   7.174  -2.572  1.00  0.00
ATOM    730  O   THR    38      -0.176   5.946  -2.515  1.00  0.00
ATOM    731  N   VAL    39      -0.708   7.916  -1.564  1.00  0.00
ATOM    732  H   VAL    39      -0.749   8.890  -1.669  1.00  0.00
ATOM    733  CA  VAL    39      -1.139   7.315  -0.307  1.00  0.00
ATOM    734  HA  VAL    39      -0.283   6.834   0.145  1.00  0.00
ATOM    735  CB  VAL    39      -1.668   8.379   0.673  1.00  0.00
ATOM    736  HB  VAL    39      -2.101   7.871   1.524  1.00  0.00
ATOM    737  QG1 VAL    39      -0.266   9.471   1.293  1.00  0.00
ATOM    738  QG2 VAL    39      -3.015   9.411  -0.141  1.00  0.00
ATOM    739  CG1 VAL    39      -0.535   9.263   1.173  1.00  0.00
ATOM    740 1HG1 VAL    39       0.402   8.920   0.758  1.00  0.00
ATOM    741 2HG1 VAL    39      -0.489   9.210   2.252  1.00  0.00
ATOM    742 3HG1 VAL    39      -0.710  10.284   0.870  1.00  0.00
ATOM    743  CG2 VAL    39      -2.758   9.214   0.015  1.00  0.00
ATOM    744 1HG2 VAL    39      -2.697  10.232   0.373  1.00  0.00
ATOM    745 2HG2 VAL    39      -3.725   8.801   0.262  1.00  0.00
ATOM    746 3HG2 VAL    39      -2.624   9.201  -1.056  1.00  0.00
ATOM    747  QQG VAL    39      -1.641   9.441   0.576  1.00  0.00
ATOM    748  C   VAL    39      -2.226   6.268  -0.537  1.00  0.00
ATOM    749  O   VAL    39      -2.227   5.211   0.090  1.00  0.00
ATOM    750  N   GLU    40      -3.149   6.572  -1.443  1.00  0.00
ATOM    751  H   GLU    40      -3.097   7.431  -1.912  1.00  0.00
ATOM    752  CA  GLU    40      -4.241   5.656  -1.756  1.00  0.00
ATOM    753  HA  GLU    40      -4.701   5.361  -0.825  1.00  0.00
ATOM    754  CB  GLU    40      -5.286   6.354  -2.629  1.00  0.00
ATOM    755 1HB  GLU    40      -4.960   6.322  -3.656  1.00  0.00
ATOM    756 2HB  GLU    40      -5.365   7.386  -2.318  1.00  0.00
ATOM    757  QB  GLU    40      -5.163   6.854  -2.987  1.00  0.00
ATOM    758  CG  GLU    40      -6.668   5.724  -2.545  1.00  0.00
ATOM    759 1HG  GLU    40      -6.629   4.890  -1.860  1.00  0.00
ATOM    760 2HG  GLU    40      -6.945   5.368  -3.526  1.00  0.00
ATOM    761  QG  GLU    40      -6.787   5.129  -2.693  1.00  0.00
ATOM    762  CD  GLU    40      -7.728   6.696  -2.068  1.00  0.00
ATOM    763  OE1 GLU    40      -8.606   6.279  -1.284  1.00  0.00
ATOM    764  OE2 GLU    40      -7.679   7.876  -2.476  1.00  0.00
ATOM    765  C   GLU    40      -3.721   4.411  -2.464  1.00  0.00
ATOM    766  O   GLU    40      -4.144   3.292  -2.166  1.00  0.00
ATOM    767  N   GLY    41      -2.803   4.609  -3.403  1.00  0.00
ATOM    768  H   GLY    41      -2.505   5.523  -3.598  1.00  0.00
ATOM    769  CA  GLY    41      -2.239   3.493  -4.139  1.00  0.00
ATOM    770 1HA  GLY    41      -1.506   3.869  -4.836  1.00  0.00
ATOM    771 2HA  GLY    41      -3.028   3.006  -4.692  1.00  0.00
ATOM    772  QA  GLY    41      -2.267   3.437  -4.764  1.00  0.00
ATOM    773  C   GLY    41      -1.577   2.476  -3.231  1.00  0.00
ATOM    774  O   GLY    41      -1.545   1.283  -3.542  1.00  0.00
ATOM    775  N   VAL    42      -1.051   2.946  -2.106  1.00  0.00
ATOM    776  H   VAL    42      -1.112   3.904  -1.912  1.00  0.00
ATOM    777  CA  VAL    42      -0.384   2.063  -1.153  1.00  0.00
ATOM    778  HA  VAL    42       0.168   1.328  -1.721  1.00  0.00
ATOM    779  CB  VAL    42       0.607   2.827  -0.240  1.00  0.00
ATOM    780  HB  VAL    42       0.096   3.076   0.679  1.00  0.00
ATOM    781  QG1 VAL    42       2.092   1.752   0.195  1.00  0.00
ATOM    782  QG2 VAL    42       1.177   4.432  -1.045  1.00  0.00
ATOM    783  CG1 VAL    42       1.807   1.956   0.111  1.00  0.00
ATOM    784 1HG1 VAL    42       1.468   0.979   0.423  1.00  0.00
ATOM    785 2HG1 VAL    42       2.360   2.417   0.916  1.00  0.00
ATOM    786 3HG1 VAL    42       2.448   1.859  -0.755  1.00  0.00
ATOM    787  CG2 VAL    42       1.068   4.125  -0.892  1.00  0.00
ATOM    788 1HG2 VAL    42       2.091   4.325  -0.611  1.00  0.00
ATOM    789 2HG2 VAL    42       0.439   4.938  -0.559  1.00  0.00
ATOM    790 3HG2 VAL    42       1.001   4.033  -1.966  1.00  0.00
ATOM    791  QQG VAL    42       1.635   3.092  -0.425  1.00  0.00
ATOM    792  C   VAL    42      -1.410   1.342  -0.285  1.00  0.00
ATOM    793  O   VAL    42      -1.377   0.116  -0.156  1.00  0.00
ATOM    794  N   TRP    43      -2.330   2.107   0.298  1.00  0.00
ATOM    795  H   TRP    43      -2.310   3.076   0.149  1.00  0.00
ATOM    796  CA  TRP    43      -3.373   1.536   1.141  1.00  0.00
ATOM    797  HA  TRP    43      -2.897   1.043   1.976  1.00  0.00
ATOM    798  CB  TRP    43      -4.299   2.639   1.670  1.00  0.00
ATOM    799 1HB  TRP    43      -5.325   2.354   1.478  1.00  0.00
ATOM    800 2HB  TRP    43      -4.090   3.557   1.149  1.00  0.00
ATOM    801  QB  TRP    43      -4.707   2.956   1.314  1.00  0.00
ATOM    802  CG  TRP    43      -4.161   2.886   3.144  1.00  0.00
ATOM    803  CD1 TRP    43      -4.825   2.227   4.138  1.00  0.00
ATOM    804  CD2 TRP    43      -3.321   3.856   3.801  1.00  0.00
ATOM    805  CE3 TRP    43      -2.409   4.826   3.361  1.00  0.00
ATOM    806  CE2 TRP    43      -3.537   3.716   5.188  1.00  0.00
ATOM    807  NE1 TRP    43      -4.457   2.718   5.365  1.00  0.00
ATOM    808  HD  TRP    43      -5.536   1.432   3.968  1.00  0.00
ATOM    809 3HE  TRP    43      -2.203   4.973   2.313  1.00  0.00
ATOM    810  CZ3 TRP    43      -1.761   5.606   4.301  1.00  0.00
ATOM    811  CZ2 TRP    43      -2.883   4.505   6.129  1.00  0.00
ATOM    812 1HE  TRP    43      -4.798   2.404   6.228  1.00  0.00
ATOM    813 3HZ  TRP    43      -1.058   6.360   3.981  1.00  0.00
ATOM    814  CH2 TRP    43      -2.000   5.442   5.669  1.00  0.00
ATOM    815 2HZ  TRP    43      -3.055   4.391   7.189  1.00  0.00
ATOM    816  HH  TRP    43      -1.472   6.076   6.365  1.00  0.00
ATOM    817  C   TRP    43      -4.190   0.514   0.360  1.00  0.00
ATOM    818  O   TRP    43      -4.690  -0.463   0.919  1.00  0.00
ATOM    819  N   THR    44      -4.327   0.754  -0.941  1.00  0.00
ATOM    820  H   THR    44      -3.908   1.552  -1.327  1.00  0.00
ATOM    821  CA  THR    44      -5.089  -0.135  -1.810  1.00  0.00
ATOM    822  HA  THR    44      -6.014  -0.371  -1.310  1.00  0.00
ATOM    823  CB  THR    44      -5.403   0.564  -3.134  1.00  0.00
ATOM    824  HB  THR    44      -4.478   0.783  -3.643  1.00  0.00
ATOM    825  QG2 THR    44      -6.460  -0.473  -4.282  1.00  0.00
ATOM    826  OG1 THR    44      -6.087   1.784  -2.905  1.00  0.00
ATOM    827 1HG  THR    44      -5.626   2.288  -2.232  1.00  0.00
ATOM    828  CG2 THR    44      -6.258  -0.273  -4.061  1.00  0.00
ATOM    829 1HG2 THR    44      -6.948  -0.866  -3.480  1.00  0.00
ATOM    830 2HG2 THR    44      -5.624  -0.927  -4.643  1.00  0.00
ATOM    831 3HG2 THR    44      -6.810   0.375  -4.725  1.00  0.00
ATOM    832  C   THR    44      -4.332  -1.432  -2.076  1.00  0.00
ATOM    833  O   THR    44      -4.919  -2.510  -2.072  1.00  0.00
ATOM    834  N   LEU    45      -3.027  -1.323  -2.313  1.00  0.00
ATOM    835  H   LEU    45      -2.612  -0.435  -2.308  1.00  0.00
ATOM    836  CA  LEU    45      -2.204  -2.500  -2.585  1.00  0.00
ATOM    837  HA  LEU    45      -2.594  -2.968  -3.476  1.00  0.00
ATOM    838  CB  LEU    45      -0.750  -2.094  -2.846  1.00  0.00
ATOM    839 1HB  LEU    45      -0.158  -2.993  -2.934  1.00  0.00
ATOM    840 2HB  LEU    45      -0.391  -1.529  -1.999  1.00  0.00
ATOM    841  QB  LEU    45      -0.275  -2.261  -2.466  1.00  0.00
ATOM    842  CG  LEU    45      -0.532  -1.256  -4.108  1.00  0.00
ATOM    843  QD1 LEU    45      -0.289  -2.368  -5.606  1.00  0.00
ATOM    844  QD2 LEU    45       0.932  -0.098  -3.892  1.00  0.00
ATOM    845  CD1 LEU    45       0.652  -0.319  -3.934  1.00  0.00
ATOM    846 1HD1 LEU    45      -1.052  -2.963  -5.289  1.00  0.00
ATOM    847 2HD1 LEU    45       0.665  -2.560  -5.308  1.00  0.00
ATOM    848 3HD1 LEU    45      -0.479  -1.580  -6.221  1.00  0.00
ATOM    849  CD2 LEU    45      -0.335  -2.154  -5.320  1.00  0.00
ATOM    850 1HD2 LEU    45       1.521  -0.746  -4.409  1.00  0.00
ATOM    851 2HD2 LEU    45       0.850  -0.182  -2.881  1.00  0.00
ATOM    852 3HD2 LEU    45       0.425   0.635  -4.385  1.00  0.00
ATOM    853  QQD LEU    45       0.322  -1.233  -4.749  1.00  0.00
ATOM    854  C   LEU    45      -2.280  -3.510  -1.436  1.00  0.00
ATOM    855  O   LEU    45      -2.543  -4.693  -1.659  1.00  0.00
ATOM    856  N   LYS+   46      -2.058  -3.041  -0.210  1.00  0.00
ATOM    857  H   LYS+   46      -1.863  -2.089  -0.084  1.00  0.00
ATOM    858  CA  LYS+   46      -2.112  -3.914   0.960  1.00  0.00
ATOM    859  HA  LYS+   46      -1.398  -4.715   0.809  1.00  0.00
ATOM    860  CB  LYS+   46      -1.726  -3.144   2.225  1.00  0.00
ATOM    861 1HB  LYS+   46      -0.692  -2.839   2.147  1.00  0.00
ATOM    862 2HB  LYS+   46      -1.835  -3.797   3.078  1.00  0.00
ATOM    863  QB  LYS+   46      -1.264  -3.318   2.612  1.00  0.00
ATOM    864  CG  LYS+   46      -2.568  -1.902   2.470  1.00  0.00
ATOM    865 1HG  LYS+   46      -3.556  -2.205   2.777  1.00  0.00
ATOM    866 2HG  LYS+   46      -2.631  -1.334   1.555  1.00  0.00
ATOM    867  QG  LYS+   46      -3.094  -1.769   2.166  1.00  0.00
ATOM    868  CD  LYS+   46      -1.961  -1.022   3.552  1.00  0.00
ATOM    869 1HD  LYS+   46      -1.202  -0.396   3.109  1.00  0.00
ATOM    870 2HD  LYS+   46      -1.514  -1.653   4.306  1.00  0.00
ATOM    871  QD  LYS+   46      -1.358  -1.025   3.708  1.00  0.00
ATOM    872  CE  LYS+   46      -3.011  -0.141   4.207  1.00  0.00
ATOM    873 1HE  LYS+   46      -3.871  -0.083   3.555  1.00  0.00
ATOM    874 2HE  LYS+   46      -2.598   0.847   4.346  1.00  0.00
ATOM    875  QE  LYS+   46      -3.234   0.382   3.950  1.00  0.00
ATOM    876  NZ  LYS+   46      -3.441  -0.675   5.527  1.00  0.00
ATOM    877 1HZ  LYS+   46      -4.371  -0.287   5.786  1.00  0.00
ATOM    878 2HZ  LYS+   46      -2.751  -0.412   6.262  1.00  0.00
ATOM    879 3HZ  LYS+   46      -3.510  -1.712   5.490  1.00  0.00
ATOM    880  QZ  LYS+   46      -3.544  -0.804   5.846  1.00  0.00
ATOM    881  C   LYS+   46      -3.505  -4.519   1.119  1.00  0.00
ATOM    882  O   LYS+   46      -3.659  -5.738   1.242  1.00  0.00
ATOM    883  N   ASP    47      -4.522  -3.660   1.110  1.00  0.00
ATOM    884  H   ASP    47      -4.339  -2.704   1.002  1.00  0.00
ATOM    885  CA  ASP    47      -5.902  -4.108   1.248  1.00  0.00
ATOM    886  HA  ASP    47      -5.972  -4.691   2.153  1.00  0.00
ATOM    887  CB  ASP    47      -6.843  -2.906   1.354  1.00  0.00
ATOM    888 1HB  ASP    47      -7.035  -2.518   0.365  1.00  0.00
ATOM    889 2HB  ASP    47      -6.373  -2.141   1.953  1.00  0.00
ATOM    890  QB  ASP    47      -6.704  -2.329   1.159  1.00  0.00
ATOM    891  CG  ASP    47      -8.171  -3.266   1.995  1.00  0.00
ATOM    892  OD1 ASP    47      -9.199  -2.681   1.598  1.00  0.00
ATOM    893  OD2 ASP    47      -8.179  -4.133   2.894  1.00  0.00
ATOM    894  C   ASP    47      -6.306  -4.981   0.066  1.00  0.00
ATOM    895  O   ASP    47      -7.108  -5.906   0.206  1.00  0.00
ATOM    896  N   GLU    48      -5.741  -4.682  -1.100  1.00  0.00
ATOM    897  H   GLU    48      -5.109  -3.936  -1.146  1.00  0.00
ATOM    898  CA  GLU    48      -6.037  -5.439  -2.310  1.00  0.00
ATOM    899  HA  GLU    48      -7.092  -5.342  -2.514  1.00  0.00
ATOM    900  CB  GLU    48      -5.246  -4.881  -3.497  1.00  0.00
ATOM    901 1HB  GLU    48      -4.943  -5.703  -4.130  1.00  0.00
ATOM    902 2HB  GLU    48      -4.364  -4.381  -3.126  1.00  0.00
ATOM    903  QB  GLU    48      -4.654  -5.042  -3.628  1.00  0.00
ATOM    904  CG  GLU    48      -6.035  -3.895  -4.345  1.00  0.00
ATOM    905 1HG  GLU    48      -6.306  -3.049  -3.731  1.00  0.00
ATOM    906 2HG  GLU    48      -6.929  -4.383  -4.700  1.00  0.00
ATOM    907  QG  GLU    48      -6.617  -3.716  -4.215  1.00  0.00
ATOM    908  CD  GLU    48      -5.249  -3.398  -5.542  1.00  0.00
ATOM    909  OE1 GLU    48      -4.061  -3.051  -5.370  1.00  0.00
ATOM    910  OE2 GLU    48      -5.821  -3.350  -6.651  1.00  0.00
ATOM    911  C   GLU    48      -5.707  -6.909  -2.109  1.00  0.00
ATOM    912  O   GLU    48      -6.394  -7.788  -2.630  1.00  0.00
ATOM    913  N   ILE    49      -4.657  -7.173  -1.339  1.00  0.00
ATOM    914  H   ILE    49      -4.152  -6.431  -0.944  1.00  0.00
ATOM    915  CA  ILE    49      -4.248  -8.543  -1.062  1.00  0.00
ATOM    916  HA  ILE    49      -4.328  -9.107  -1.980  1.00  0.00
ATOM    917  CB  ILE    49      -2.795  -8.632  -0.560  1.00  0.00
ATOM    918  HB  ILE    49      -2.788  -8.396   0.493  1.00  0.00
ATOM    919  QG2 ILE    49      -2.152 -10.387  -0.767  1.00  0.00
ATOM    920  CG2 ILE    49      -2.275 -10.051  -0.728  1.00  0.00
ATOM    921 1HG2 ILE    49      -2.468 -10.388  -1.735  1.00  0.00
ATOM    922 2HG2 ILE    49      -2.776 -10.702  -0.028  1.00  0.00
ATOM    923 3HG2 ILE    49      -1.212 -10.070  -0.539  1.00  0.00
ATOM    924  CG1 ILE    49      -1.892  -7.643  -1.299  1.00  0.00
ATOM    925 1HG1 ILE    49      -2.501  -6.963  -1.876  1.00  0.00
ATOM    926 2HG1 ILE    49      -1.241  -8.188  -1.965  1.00  0.00
ATOM    927  QG1 ILE    49      -1.871  -7.575  -1.920  1.00  0.00
ATOM    928  QD1 ILE    49      -0.817  -6.624  -0.153  1.00  0.00
ATOM    929  CD1 ILE    49      -1.024  -6.820  -0.374  1.00  0.00
ATOM    930 1HD1 ILE    49      -0.091  -7.336  -0.201  1.00  0.00
ATOM    931 2HD1 ILE    49      -1.535  -6.678   0.567  1.00  0.00
ATOM    932 3HD1 ILE    49      -0.825  -5.859  -0.824  1.00  0.00
ATOM    933  C   ILE    49      -5.163  -9.169  -0.018  1.00  0.00
ATOM    934  O   ILE    49      -5.442 -10.368  -0.062  1.00  0.00
ATOM    935  N   LYS+   50      -5.630  -8.348   0.919  1.00  0.00
ATOM    936  H   LYS+   50      -5.376  -7.400   0.899  1.00  0.00
ATOM    937  CA  LYS+   50      -6.521  -8.827   1.972  1.00  0.00
ATOM    938  HA  LYS+   50      -5.989  -9.573   2.544  1.00  0.00
ATOM    939  CB  LYS+   50      -6.920  -7.679   2.901  1.00  0.00
ATOM    940 1HB  LYS+   50      -7.496  -8.079   3.722  1.00  0.00
ATOM    941 2HB  LYS+   50      -7.533  -6.982   2.349  1.00  0.00
ATOM    942  QB  LYS+   50      -7.515  -7.530   3.036  1.00  0.00
ATOM    943  CG  LYS+   50      -5.735  -6.922   3.474  1.00  0.00
ATOM    944 1HG  LYS+   50      -6.099  -6.174   4.164  1.00  0.00
ATOM    945 2HG  LYS+   50      -5.200  -6.444   2.669  1.00  0.00
ATOM    946  QG  LYS+   50      -5.649  -6.309   3.416  1.00  0.00
ATOM    947  CD  LYS+   50      -4.786  -7.852   4.212  1.00  0.00
ATOM    948 1HD  LYS+   50      -4.302  -8.499   3.495  1.00  0.00
ATOM    949 2HD  LYS+   50      -5.352  -8.448   4.913  1.00  0.00
ATOM    950  QD  LYS+   50      -4.827  -8.473   4.204  1.00  0.00
ATOM    951  CE  LYS+   50      -3.723  -7.075   4.974  1.00  0.00
ATOM    952 1HE  LYS+   50      -3.639  -6.088   4.542  1.00  0.00
ATOM    953 2HE  LYS+   50      -2.779  -7.591   4.876  1.00  0.00
ATOM    954  QE  LYS+   50      -3.209  -6.839   4.709  1.00  0.00
ATOM    955  NZ  LYS+   50      -4.056  -6.943   6.420  1.00  0.00
ATOM    956 1HZ  LYS+   50      -4.979  -7.381   6.618  1.00  0.00
ATOM    957 2HZ  LYS+   50      -4.096  -5.939   6.687  1.00  0.00
ATOM    958 3HZ  LYS+   50      -3.331  -7.414   6.998  1.00  0.00
ATOM    959  QZ  LYS+   50      -4.135  -6.911   6.768  1.00  0.00
ATOM    960  C   LYS+   50      -7.769  -9.466   1.371  1.00  0.00
ATOM    961  O   LYS+   50      -8.326 -10.410   1.929  1.00  0.00
ATOM    962  N   THR    51      -8.197  -8.944   0.226  1.00  0.00
ATOM    963  H   THR    51      -7.707  -8.194  -0.170  1.00  0.00
ATOM    964  CA  THR    51      -9.376  -9.464  -0.458  1.00  0.00
ATOM    965  HA  THR    51     -10.002  -9.942   0.279  1.00  0.00
ATOM    966  CB  THR    51     -10.156  -8.324  -1.111  1.00  0.00
ATOM    967  HB  THR    51      -9.816  -8.206  -2.131  1.00  0.00
ATOM    968  QG2 THR    51     -12.005  -8.621  -1.153  1.00  0.00
ATOM    969  OG1 THR    51      -9.932  -7.104  -0.425  1.00  0.00
ATOM    970 1HG  THR    51     -10.004  -7.252   0.522  1.00  0.00
ATOM    971  CG2 THR    51     -11.651  -8.563  -1.145  1.00  0.00
ATOM    972 1HG2 THR    51     -11.863  -9.553  -0.771  1.00  0.00
ATOM    973 2HG2 THR    51     -12.005  -8.479  -2.162  1.00  0.00
ATOM    974 3HG2 THR    51     -12.146  -7.830  -0.527  1.00  0.00
ATOM    975  C   THR    51      -8.983 -10.497  -1.513  1.00  0.00
ATOM    976  O   THR    51      -9.797 -11.331  -1.911  1.00  0.00
ATOM    977  N   PHE    52      -7.731 -10.437  -1.962  1.00  0.00
ATOM    978  H   PHE    52      -7.128  -9.751  -1.607  1.00  0.00
ATOM    979  CA  PHE    52      -7.230 -11.368  -2.970  1.00  0.00
ATOM    980  HA  PHE    52      -6.174 -11.191  -3.085  1.00  0.00
ATOM    981  CB  PHE    52      -7.443 -12.813  -2.512  1.00  0.00
ATOM    982 1HB  PHE    52      -8.289 -13.229  -3.041  1.00  0.00
ATOM    983 2HB  PHE    52      -7.648 -12.821  -1.452  1.00  0.00
ATOM    984  QB  PHE    52      -7.969 -13.025  -2.247  1.00  0.00
ATOM    985  QD  PHE    52      -6.126 -13.799  -2.788  1.00  0.00
ATOM    986  QE  PHE    52      -4.184 -15.255  -3.193  1.00  0.00
ATOM    987  QR  PHE    52      -4.766 -14.818  -3.072  1.00  0.00
ATOM    988  CG  PHE    52      -6.258 -13.702  -2.760  1.00  0.00
ATOM    989  CD1 PHE    52      -6.103 -14.351  -3.974  1.00  0.00
ATOM    990 1HD  PHE    52      -6.844 -14.214  -4.747  1.00  0.00
ATOM    991  CE1 PHE    52      -5.013 -15.168  -4.205  1.00  0.00
ATOM    992 1HE  PHE    52      -4.905 -15.670  -5.157  1.00  0.00
ATOM    993  CZ  PHE    52      -4.064 -15.346  -3.218  1.00  0.00
ATOM    994  HZ  PHE    52      -3.211 -15.983  -3.396  1.00  0.00
ATOM    995  CE2 PHE    52      -4.205 -14.703  -2.003  1.00  0.00
ATOM    996 2HE  PHE    52      -3.463 -14.840  -1.230  1.00  0.00
ATOM    997  CD2 PHE    52      -5.298 -13.886  -1.779  1.00  0.00
ATOM    998 2HD  PHE    52      -5.407 -13.385  -0.829  1.00  0.00
ATOM    999  C   PHE    52      -7.915 -11.143  -4.315  1.00  0.00
ATOM   1000  O   PHE    52      -7.953 -12.039  -5.158  1.00  0.00
END
